﻿USE sofia;
DROP TABLE IF EXISTS sofia.nou_vpl;
CREATE TABLE nou_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nou_vpl WRITE;
INSERT INTO nou_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Eiawa Iesu Keriso da mamoumbogo. Edo umo awa David da orobe. Edo David awa Abraham da orobe. ");
INSERT INTO nou_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Edo Abraham awa Isaac da mamo. Isaac awa Jacob da mamo. Jacob awa Judah de uso nanonamendi de da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah awa Perez de Zerah de da mamo ungoda ai awa Tamar. Perez awa Hezron da mamo. Hezron awa Ram da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram awa Amminadab da mamo. Amminadab awa Nahshon da mamo. Nahshon awa Salmon da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon awa Boaz da mamo edo uso ai awa Rahab. Boaz awa Obed da mamo edo Obed uso ai awa Ruth. Obed awa Jesse da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse awa gitijigari nembodiba David da mamo. Edo David awa Solomon da mamo edo Solomon uso ai awa Uriah da rori. ");
INSERT INTO nou_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon awa Rehoboam da mamo. Rehoboam awa Abijah da mamo. Abijah awa Asa da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa awa Jehoshaphat da mamo. Jehoshaphat awa Joram da mamo. Joram awa Uzziah da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah awa Jotham da mamo. Jotham awa Ahaz da mamo. Ahaz awa Hezekiah da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah awa Manasseh da mamo. Manasseh awa Amon da mamo. Amon awa Josiah da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah awa Jechoniah de uso nanonamendi de da mamo edo ungo awa iji ainde Babylon busu embomei mi Jew embomei bundedo budo mambusera Babylon busu ainda. ");
INSERT INTO nou_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Edo wasiri awa atae etiri ainda amboda Jechoniah awa Shealtiel da mamo. Shealtiel awa Zerubbabel da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel awa Abiud da mamo. Abiud awa Eliakim da mamo. Eliakim awa Azor da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor awa Zadok da mamo. Zadok awa Achim da mamo. Achim awa Eliud da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud awa Eleazar da mamo. Eleazar awa Matthan da mamo. Matthan awa Jacob da mamo. ");
INSERT INTO nou_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob awa Joseph da mamo edo Joseph awa Mary da iu. Mary awa Iesu awa jawo nei Keriso ainda ai. ");
INSERT INTO nou_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eiawa orobe ajigari 14 Abraham da iji de edo mambudo gitijigari nembodiba David da iji de. Edo ajigari 14 David da iji de edo mambudo ungo Babylon busu da gajari oro da atisera ainda. Edo ajigari 14 mambudo Soregari Embo Mamo mi itari bugarase sisira bugusira ainda. ");
INSERT INTO nou_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Eiawa be Iesu Keriso da kumbari da kiki ra. Joseph Mary Iesu da ai adira awa jimbadi dipapa etiri ungoda orobe awara sisera. Ungo dada edo iu aro awodo ae awarate Asisi Kotopu mi Mary da tini da sirore etiri Mary gasou jijirisira. ");
INSERT INTO nou_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Edo Joseph Mary doadi dipapa isira awarate umo awa embo ewamei awasedo gae gae ari ge soro Mary me geurase Joseph kotisira, “Na Mary doadena te mana sano embo gadera.” ");
INSERT INTO nou_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Edo Joseph ge awodo kotise atiko eturo isira. Eturo da asisi ewamei Mamo da yei edo uso yei bugusira. Bugudo sisira, “Joseph David da orobe imo Mary jimbari oju eose amone ta Asisi Kotopu mi tini da sirore etiri gasou jirira. ");
INSERT INTO nou_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Edo Mary mei bari uso jawo Iesu seio ainda be awa unemi uso embomei wasiri biae da soregadira.” ");
INSERT INTO nou_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Edo Mamo mi uso binga sari embo da yei da awodo matu sisira, “Embo berari dengoro ewo. Gagara ademei mi tini de edo mei badira. Edo uso jawo awa Emmanuel sadera ainda be awa Mamo ingode atadi bugira.” Edo Mary mei Iesu ingari embo berari mi gadera Mamo da binga sari embo mi ro sisira awa be etira awa. ");
INSERT INTO nou_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Edo Joseph ewuko erido asisi ewamei mi ro sisira awa isira. ");
INSERT INTO nou_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Edo Mary jimbusira awarate umo Mary ga ewae atiri Mary mei burisira. Etiri Joseph mi mei jawo Iesu sisira. ");
INSERT INTO nou_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mary Iesu Bethlehem nati ainda Judea busu da joda burisira iji ainde awa embo nembodiba jawo Herod awa busu embomei ainda da gitijigari atisira. Edo iji tupo jiro gari embomei ungo damana de eturo de da be gido era awa ungoda busu nati waiko vitari kena awa dodo Jerusalem nati da bugusera. ");
INSERT INTO nou_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bugudo sisera, “Mei kiambu seka Jew embomei gitijigadi bugira mo rawari? Nango uso damana waiko vitari kena gido umo tumondebain adi bugera.” ");
INSERT INTO nou_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Setero Herod ge awa ingido umo duduku isira Jerusalem nati embomei daedo da awodo isera. ");
INSERT INTO nou_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Edo Herod mi setiri Jew embomei da priest da gitijijigegari de agodari da atopapotegari de uso yei dada etero Herod ungoda yei sedo gosisira, “Mamo da binga sari embomei mi yei rawainda evetu mi Keriso barase siseri?’” ");
INSERT INTO nou_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Setiri ungoi mina sisera, “Bethlehem nati da Judea busu joda. Eire Mamo da binga sari embo mi gaisira, ");
INSERT INTO nou_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ingo Bethlehem nati embo Judea busu da awa kiambu aera awarate nati embomei nenei Judea busu da awa memeia ra. Ingo awa nati embomei nembodiba ra ainda be awa ingoda yei da edo gitijigari nembodiba bugudo Mamo da embo Israel gitijigadira.’” ");
INSERT INTO nou_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Awasedo Herod mi esega embo iji vitari da bugusera ainda gae unjugari da setiri bugero ungoda yei nganega edo gosisira, “Ingo be iji nonde damana eiawa bugiri getevi?” ");
INSERT INTO nou_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Setiri ungo iji nonde damana bugusira awa uso yei sisira edo Herod ungoda yei sisira, “Ingo Bethlehem nati da mambuwo. Mambudo mei kiambu awa eura edo gogowo ewo. Edo ingo umo tambudo gido bugudo sewo na gane ainda be awa na daedo mambudo umo tumondebain adi dipapa ena.” ");
INSERT INTO nou_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Edo umo awa setiri ungo yei awa doturisera. Dodo mambuse damana iji vitari da gosisera da awa gosisera. Edo damana eiawa giti giti mambudo pepetisira mei kiambu atira yei ainda inda beitigurisira. ");
INSERT INTO nou_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Edo ungo damana awa gido ainda amboda dubo ewamei isera. ");
INSERT INTO nou_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Edo ungo mambudo mando joda torido mei kiambu uso ai Mary ga gosisera. Gido baingo dederi edo tumondebain isera. Edoungo ungoda sapoia pirigedo Iesu da kando ewamei ititisera gold edo ri da vibu muno ewamei jawo frankincense edo myrrh awa ititisera. ");
INSERT INTO nou_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Edo Mamo mi eturo da bugudo ungoda yei sisira, “Herod da yei sekago engenembedo mambove.” Setiri gido ungo emboro nei da awodo ungoda busu da mambusera. ");
INSERT INTO nou_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Edo ungo mambero ainda amboda Mamo da asisi ewamei eturo da bugudo Joseph da yei sisira, “Erio. Erido mei kiambu de uso ai de budo oju sumbudo Egypt busu da mambase. Edo Herod awa mei kiambu eura edo dari betarase jarira awasedo ainda atiroso amboda nanemi sano engenembase.” ");
INSERT INTO nou_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Awasedo Joseph tumba de erido mei kiambu de uso ai de budo yei awa dodo Egypt da mambudo ainda atirari amboda Herod betarase. ");
INSERT INTO nou_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Etiri Mamo mi matu ro sisira awa be isira. Umo sisira, “Na naso mei Egypt dodo mambarase jawo sisena.” ");
INSERT INTO nou_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Edo esega embomei iji vitari da awa Herod da yei bugae etero Herod kotisira awa embomei ami umo gandubari ge sedo umo tini gambari isira. Edo tini gambari edo embo nenei uso yei da setiri bugero edo ungoda yei sisira, “Bethlehem nati da mambuwo edo daedo uso nati demonda ainda memei memeiako ungoda gaeko etoto edo tuda awa dawo bebetegore.” Edo Herod eiedo sisira ainda be awa esega embomei iji vitari da edo bugusera amimi sisera awa ungo damana awa gaeko etoto da gari sisera awasedo. ");
INSERT INTO nou_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Eiawa bugiri ge ro binga itari embo Jeremiah mi ro sisira awa be bugusira. ");
INSERT INTO nou_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Edo Jeremiah mi sisira, “Embo mi javi ingera Ramah nati ainda awawa embo da ji bia da gembu. Edo Rachel da edo uso orobe emboevetu berari ji sewora ungoda kinapeina betetera awasedo.” ");
INSERT INTO nou_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Edo Herod betetiri ainda amboda Joseph Egypt ainda atiri Mamo da asisi ewamei mi uso yei bugudo eturo da sisira, “Embo mei kiambu dari betarase evira amone betetira awasedo erido mei kiambu de uso ai de budo sekago Israel busu da engenembase.” ");
INSERT INTO nou_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Awasedo Joseph erido mei kiambu de uso ai de budo sekago engenembedo busu Israel da mambusira. Edo Joseph eiedo isira amimi Mamo mi binga sari embo da yei sisira awa be isira. Edo Mamo mi sisira, “Nanemi naso mei Egypt busu ainda jawo seteno bugira.” ");
INSERT INTO nou_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Edo Joseph umo Israel busu da mambuse binga ingisira awa Herod da mei Archelaus mi Judea busu embomei awa gitijijigurira awa. Edo binga awa ingido Joseph umo ainda petari awa oju isira awarate sekago Mamo mi Joseph da yei eturo da sisira awasedo umo mambudo busu Galilee ainda anumburisira Nazareth nati ainda. ");
INSERT INTO nou_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Edo umo ainda anumbetiri ro binga sari embo mi sisira awa be isira, “Umo awa Nazareth nati embo adira.” ");
INSERT INTO nou_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Iji ainde John umo mi ewamei ari embo mi bugudo Judea busu da yei embo atae ainda atopatadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Edo John mi sisira, “Iji bugira edo Mamo mi gitijigadira awa aikambu etira awasedo wasiri biae dodo Mamo da yei puwo.” ");
INSERT INTO nou_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Edo binga sari embo jawo Isaiah mi embo einda jawo da ge sisira, “Embo da mi yei embo atae da tembuse binga minonu sadira, ‘Gitijigari da emboro sia ewo edo emboro ewamei ewo.’” ");
INSERT INTO nou_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Edo John uso ombari digari awa wo jawo camel da tu mi ari edo uso sini awa wo da tu mi ari edo umo indari awa sopika de mumuni de awa indido isira. ");
INSERT INTO nou_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Edo Jerusalem nati embomei edo Judea busu embomei berari de edo Jordan umo bengi da atima edo isera embomei ainde mi bugudo John atopapotira awa gadi bugusera. ");
INSERT INTO nou_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Edo John da dengoro bagari awa ingido ainda amboda ungoi sisera, “Nango buria etera.” Setero John mi umo Jordan da ungo umo mi ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Edo John mi agodari simba ari embomei jiwae Pharisee de Sadducee uso yei bugutero gosisira edo ungo John mi umo mi ewamei arase dipapa etero umo ungoda yei sisira, “Ingo awa teta jingabu da memei ingege. Edo iji Mamo mi ingo kasadira awa bugutira. Na kove be ena ko imo kotesa Mamo busu da embo kasadira ainde awa imo jebugadesa. ");
INSERT INTO nou_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Edo ingo wasiri ewamei ewo. Edo wasiri ewamei adewa awa embomei ingo ingoda wasiri biae awa doturewa awa gadera. ");
INSERT INTO nou_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Edo kotove Abraham awa nangoda mamoumbogo awasedo Mamo mi nango mana kasadira kotove. Awodo aera te Mamo mi ingo kasadira. Edo Mamo uso dipapa awodo edo ganuma einda Mamo mi Abraham da orobe adira. ");
INSERT INTO nou_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Edo ingo awa teta ribe ae edo ira da awodo ra. Edo embo oto de awa sia etira ri jegadi. Jegedo pigari riawo da ewarase ribe ae edo ira awa mambadira. ");
INSERT INTO nou_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Edo embo ave ungoda wasiri biae doturera awa nanemi umo mi ewamei ena awarate embo da naso amboda bugutira amimi Asisi Kotopu de riawo de mi ewamei adira. Edo embo eiawa nembodiba be awarate na awa embo nembodiba ae edo na awa ewa raro uso tei goru simba eni? ");
INSERT INTO nou_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Edo umo indari wheat da puti awa demonda ititise edo indari wheat be awa ewoga ewoga adira. Edo indari wheat be awa uso indari itari yei da ititise edo puti awa pigari riawo da ewadira riawo matawa atari da ewadira.” ");
INSERT INTO nou_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Edo iji ainde Iesu Galilee busu awa dodo edo Jordan umo be da bugusira John mi ainda umo mi ewamei arase. ");
INSERT INTO nou_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Awarate John Iesu umo mi ewamei ari oju ae edo uso yei sisira, “Na imo umo mi ewamei anase sedo geose. Na awa embo wasiri biae de ra awarate imo awa wasiri biae aera awasedo na inemi umo mi ewamei asase dipapa ena.” ");
INSERT INTO nou_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Setiri Iesu mi mina sisira, “Sedo gosena te umo mi ewamei egae ko eiedo adesa amimi ingae Mamo ro sisira awa adera.” Setiri John awara sisira. ");
INSERT INTO nou_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Edo John Iesu umo mi ewamei etiri ainda amboda Iesu umo jo dodo vivitiri utu pirigetiri edo umo Mamo da Asisi teta ri ribo inge wowosiri gosisira. ");
INSERT INTO nou_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Edo Mamo da Asisi wosedo uso yei anumbetiri edo ge javi utu da awodo sisira, “Emone naso mei na awa na dubo burena. Na uso yei naso jo iaviri ira.” ");
INSERT INTO nou_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Edo Asisi Kotopu mi Iesu budo yei embo atae da Satan mi bagarase budo mambusira. ");
INSERT INTO nou_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Edo Iesu ainda iji 40 edo tumba 40 indari indae atisira. ");
INSERT INTO nou_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Edo Iesu umo beji tambutiri Satan mi bagarase uso yei bugudo sisira, “Imo Mamo da mei sadesa awa seio ganuma eiawa ambe ari indase.” ");
INSERT INTO nou_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Awarate Iesu mi mina sisira, “Awodo aera jiwari ewamei be ewamei sira awa embo ave ambe berari indadira awa uso asisi awa beji de atadira awarate umo Mamo mi ge berari ro sira awa ingadira awa uso asisi awa inono adira.” ");
INSERT INTO nou_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Edo ainda amboda Satan mi Iesu budo Jerusalem nati da budo mambudo edo Jew embomei da tumondebain ari oro da inda ititisira. ");
INSERT INTO nou_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Edo Satan Iesu ainda itido atae edo uso yei sisira, “Imo Mamo da mei sadesa awa kekepunya edo busu da woseio ainda be awa jiwari ewamei be ewamei mi sira awa Mamo mi uso asisi ewagaewa sari imo simba adera edo ungo mi imo simba ise ungoda ingo mi imo jigadera oro iso tei awa mana ganuma da dadesa sira.” ");
INSERT INTO nou_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Setiri Iesu mi mina sisira, “Awarate jiwari ewamei be ewamei da daedo sira imo mana Mamo iso bawari da itadesa sira.” ");
INSERT INTO nou_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Setiri ainda amboda Satan mi Iesu budo doriri nembodiba da tamo da mambusira. Edo Satan Iesu ainda itido Satan mi Iesu busu da embo berari awa ujugetiri gosisira. Edo Iesu gosisira awa ewamei be ra. ");
INSERT INTO nou_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Edo Satan mi Iesu da yei sisira, “Imo baingo dederi edo na tumondebain adesa awa nanemi yei berari da eiawa iso yei da itadena.” ");
INSERT INTO nou_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Setiri Iesu mi mina sisira, “Satan ewoga mambu. Edo jiwari ewamei be ewamei mi sira awa ingo Mamo da awa tumondebain adewa edo kera adewa edo embo nei awa kera eove sira.” ");
INSERT INTO nou_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Awasedo Satan Iesu dodo mambiri edo asisi ewagaewa mi bugudo Iesu kondade isera. ");
INSERT INTO nou_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Edo Iesu umo John gajari oro da itero binga ingido Iesu Galilee busu da mambusira. ");
INSERT INTO nou_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Edo Nazareth nati da iji tupo atinatina yei awa dodo nati Capernaum da mambudo atima isira. Edo nati eiawa umo diuga Galilee da bengi da busu Zebulun de Naphtali deda demonda. ");
INSERT INTO nou_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Edo Iesu ainda mambusira ainda be awa binga sari embo Isaiah mi ro sisira awa be isira. ");
INSERT INTO nou_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Edo Isaiah mi sisira, “Edo Jordan umo be nei da edo ewa kena awa Zebulun busu de edo Naphtali busu de edo Galilee busu mendo da awa embo Jew ae jawo Gentile atima isera. ");
INSERT INTO nou_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Edo embo ainda atima isera awa teta umenga da atarago edo isera edo teta betari da utumo da atarago edo isera. Edo ungo awodo atiroro embomei amimi usasa nembodiba be gadera.” ");
INSERT INTO nou_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Edo iji ainde Iesu umo atopatadi tuturo isira edo sisira, “Mamo mi ingo gitijigadira iji awa bugira awasedo ingoda wasiri bebegae awa dodo Mamo da yei puwo.” ");
INSERT INTO nou_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Edo Iesu umo Galilee umo bengi da pepeta ise nanonamendi etoto wo buro ero gosisira. Simon uso jawo nei Peter de uso namendi Andrew de awa komboro mi wo burero gosisira. ");
INSERT INTO nou_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Edo Iesu ungoda yei sisira, “Na ambo ambo ewo. Ingoda imamo mi ingo wo oiro awase atopapotisira da awodo nanemi ingo atopatano na awa embo embo berave.” ");
INSERT INTO nou_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Setiri iji ainde ungo ungoda komboro dodo Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Edo kiambu yise nanonamendi nenei etoto James de John de Zebedee da memei awa gosisira ungo awa ungoda nga da anumbedo ungoda mamo Zebedee ga da ungoda komboro to ise atero gosisira. Gido Iesu mi ungoda yei sisira umo ambo ambo orase sisira. ");
INSERT INTO nou_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Setiri ungo burigi be erido ungoda mamo de nga de dodo Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Edo Iesu Galilee busu jo da tembuse Jew da dada ari oro da atopatido isira. Edo binga ewamei Mamo mi iji nonde embomei gitijigadira awa atopatido isira. Edo embo karu amburo neinde kainde bari awa euri jebugedo isera. ");
INSERT INTO nou_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Edo busu Syria embo mi Iesu da buro ira ainda binga awa gido embo karu amburo neinde kainde edo dubo vevera tambudo isera awa budo Iesu da yei bugusera. Edo embo ave asisi biae mi sirari ta ko edo embo ave karu jawo epilepsy bari ta edo embo nenei karu tei ingo ambari ta awa berari Iesu mi euri jebugedo isera. ");
INSERT INTO nou_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Edo embo jiwae be busu Galilee da edo yei jawo Gabu Etoto nati da edo Jerusalem nati da edo Judea busu da edo busu nei Jordan umo bengi da awa berari bugudo Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Edo Iesu embo diti nembodiba awa gido doriri inda vivitisira. Vitido ainda anumburisira. ");
INSERT INTO nou_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Etiri uso ambojimbi bugudo uso yei dada etero Iesu ungo atopatadi tuturo isira edo ge eiawa sisira. ");
INSERT INTO nou_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Embo ave umo umosuka kondade ari sago ae awa gosira embo unemi Mamo gebe ira embo awa dubo ewamei ira ainda be awa Mamo mi gitijigadira ainde awa umo awa Mamo ga daedo atadira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Edo embo ave nei ro mi dubo vevera ira awa dubo ewamei ira ainda be awa Mamo mi umo kondade adira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Edo embo ave saboa evira awa Mamo mi ro barase sisira awa badira awasedo dubo ewamei ira. ");
INSERT INTO nou_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Edo embo ave Mamo da dipapa awa adi dipapa be evira awa dubo ewamei ira ainda be awa Mamo mi umo awa ari beda adira. ");
INSERT INTO nou_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Edo embo ave embo nenei da yei jo edo ira awa dubo ewamei ira ainda be awa Mamo uso yei da jo adira. ");
INSERT INTO nou_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Edo embo ave uso jiro jingama ewamei evira awa dubo ewamei ira unemi Mamo gadira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Edo embobo ememi embo nenei ge bagera awa eoro atae edo ira awa dubo ewamei ira Mamo mi umo awa uso kinapeina sadira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Edo embo ave Mamo da dipapa awa adi euri embo mi dedo gaedo ewora awa dubo ewamei ira Mamo gitijigadira ainde awa umo awa Mamo ga daedo awasedo. ");
INSERT INTO nou_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Edo imo na ambo ambo esa awasedo embo mi iso yei da ge biae sadera edo imo dedo gaedo ise gebusadera awa dubo ewamei eio ainda be awa nanemi kando nembodiba imo awasedo utu da sia ena. Edo da awodo embo nenei mi Mamo da binga sari embomei matu da atima isera dedo gaedo isera.” ");
INSERT INTO nou_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Edo Iesu uso ambojimbi atopapotise atise sisira, “Nanemi ingo awa embo da teda ititena teta ewa tokaka embo mi indari da itido era da awodo awarate tokaka awa uso tokaka da mina bari awa atae ari inemi mana aso sekago tokaka adira. Amone jingama ari sago ae etira awasedo imo pigaso mambari embo mi ainda tamo da pepeta adera. ");
INSERT INTO nou_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Awarate na ingo ititena teta goriwo usasa de embo mi yei umenga da itido era da awodo. Edo embo nati doriri tamo da edo ira awa embo berari mi nati awa gido era. ");
INSERT INTO nou_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Awarate embo amemi mana ri injibedo ou to da itadira awodo aera te unemi ri injibedo awa aviga da itari embo berari mando da awa usasa adira. ");
INSERT INTO nou_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Da awodo iso wasiri esa awa amimi teta riawo mi janibarago are embo da yei. Edo wasiri ewamei awa gosise iso Mamo utu da awa jasiga ore. ");
INSERT INTO nou_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Edo Moses da agodari de Mamo da binga sari embomei mi ro atopapotisera awa na budo pigadi bugusena awa kotove ainda be awa na budo pigadi bugae awarate na awa ro Moses de Mamo da binga sari embo de mi ro atopapotisera awa amo be arase bugusena. ");
INSERT INTO nou_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Edo ro sena awa ruvegeove Mamo da ge awa matawa atadira edo uso ge awa be adira. Edo Mamo mi mana doari uso ove kiambu ta ko ove nembodiba agodari jiwari awa mana embo mi pigoro mana mambadira. ");
INSERT INTO nou_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Awasedo embo ave Mamo da agodari kiambu ta agodari nembodiba ta awa kera ae adira ise embo nenei da awodo atopatadira awa embo awa Mamo bugudo gitijigadira iji ainde awa kiambu adira. Awarate embo ave Mamo da agodari awa gebe ise da awodo embo nenei atopatadira awa embo awa Mamo bugudo gitijigadira ainde awa embo nembodiba adira. ");
INSERT INTO nou_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Edo na ingoda yei sena ingoda wasiri agodari da simba ari embomei jawo Pharisee de agodari da gaiari embomei jawo Scribe de da awodo ae gadewa gido awa mana Mamo mi gitijigadira ainda iji de awa ingo awa ainda adewa.” ");
INSERT INTO nou_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Edo Iesu atopapotise atise sisira, “Moses mi embo iji ainde atima isera ainda yei sisira embo dawo beture edo embo ave embo nei dari betadira awa embo awa budo busu da kasari embo da yei buguwo sisira. ");
INSERT INTO nou_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Awarate nanemi ingoda yei sena embo amemi embo nei da yei tini gambari adira awa busu da kasari embo da yei budo buguwo. Edo embo amei uso namendi da yei imo embo biae sadira awa embo awa ungomi kundo budo nati embobo mi kasadera ainda yei mambadera. Edo embo ave embo nei da yei sadira imo jiro gari ae embo sadira embo awa mambudo riawo natopo atari da mambadira. ");
INSERT INTO nou_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Awasedo imo Mamo da rorou itari yei da derido imo iso otao ga da ge bagetesa awa kotedo re iso rorou ainda dodo iso otao da yei mambuio. Edo mambudo awa otao ga da dubo ewamei ari eio. Edo imo awodo edo awa engenembedo mambudo Mamo da yei iso rorouitio. ");
INSERT INTO nou_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Edo embo amemi iso yei rora da ro da tamo da tini gambari edo edo imo kasari yei da budo mambadi ari gido re embo ainga da burigi namendi eio awarate imo awodo ae adesa awa embo amimi imo budo kasari embo da itadira. Itari amimi budo agodari simba ari embo da itadira. Edo ungoi imo badera awa imo gajari oro da itadera. ");
INSERT INTO nou_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Edo na ingoda yei gebe sena unemi imo gajari oro da itadira awa imo ainda atise iso buria da mina berari awa itadesa. ");
INSERT INTO nou_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","28","“Edo ingo gosewowa ungoi sisera ipu da eove sisera awarate nanemi ingoda yei sena embo amemi evetu ta ko gagara awa gido dipapa adira awa unemi evetu ta mo gagara ainga uso jo da ipu da ari awa etira. ");
INSERT INTO nou_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Edo iso diti be mi ari imo wasiri biae edo gido re gurugedo budo pigeio. ");
INSERT INTO nou_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Edo iso ingo be mi ari imo wasiri biae edo gido re diugedo budo pigeio. Edo ro mi etiri imo wasiri biae etesa awa pigadesa amone ewamei ra. Edo ro mi etiri wasiri biae etesa awa pigae etesa amone biae ra awasedo imo awa riawo natopo atari euse atira ainda mambadesa. ");
INSERT INTO nou_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Edo ingo daedo ingewa ungoi sisera embo ave uso aro doadi dipapa adira awara sari gari ove jivedo evetu awa doadira sisera awarate naso ge eiawa ingiwo. ");
INSERT INTO nou_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Embo amemi uso aro awa saboa edo atirari dodo tepo awodo uso aro doadira evetu awa sekago jimbadira embo amimi ari evetu awa ipu da ari adira. Edo embo ave evetu awa jimbadira embo awa ipu da ari awa adira. ");
INSERT INTO nou_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Edo ingo daedo matu gosewowa tuturo da sisera imo Mamo da yei ro adi sari ge be mi sisesa awa eio sisera. ");
INSERT INTO nou_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Awarate boroko na ingoda yei sena ingo ro adi sari sadewa awa ge mi goroba edo seove. Edo utu da jawo seove utu amone ta Mamo da anumba de gitijigari yei ra. ");
INSERT INTO nou_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Edo daedo busu da jawo da seove amone ta Mamo da tei itari yei ra. Edo Jerusalem nati da jawo da seove amone ta gitijigari nembodiba da nati ra. ");
INSERT INTO nou_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Edo iso wasiri da jawo da adi sari awa goroba edo seove ainda be awa Mamo umo umosuka ari embo awa wasiri de atadera awasedo. ");
INSERT INTO nou_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Awodo aera ge goroba de awodo seove ta ko da awara o awara aera awodo sewo. Edo ge eiawa sadesa awa inono ra te ge goroba edo sadesa awa ewamei aera ainda be awa Satan mi ge da awodo sedo ira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Edo ingo matu gosewowa daedo sisera embo amemi embo nei da dombu gaedo gurugadira awa mina dari dombu da gurugadira. Edo embo amemi embo nei da di da dari eregadira awa mina dari di da eragadira sisera. ");
INSERT INTO nou_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Awarate na ingoda yei sena embo amemi iso yei biae ari gido mi biae mina eose. Edo amemi imo sogo da dari gido sogo benei eio dare. ");
INSERT INTO nou_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Edo embo amemi imo kasedo iso ombari tu da awa bari gido iso ombari tamo ainde da doio bare. ");
INSERT INTO nou_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Edo isoro embo da mi uso rora ango edo yei tupo yasase sari gido budo yei ribori mambuio. ");
INSERT INTO nou_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Edo embo amemi uso yei rora itasase sari gido uso yei itio. Edo embo amemi iso rora jingama ari dipapa ari gido re awara seio jingama are. ");
INSERT INTO nou_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Edo ingo gosewa daedo sisera namendi iso dubo burise gitopo iso de tini gambari eio sisera. ");
INSERT INTO nou_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Awarate naso ge ingiwo. Na ingoda yei sena gitopo ingoda dubo buwo edo sedo giwo Mamo mi embo ingo dedo gaedo edo era awa kondade are. ");
INSERT INTO nou_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Edo embo mi ingo wasiri eiedo irirowo gadera awa ungoi gadera ingo awa Mamo da kinapeina awodo gadera. Embo nenei da yei awodo ewamei ewo ko Mamo mi ari waiko embo biae de embo ewamei de da yei janibadira edo Mamo daedo ga embo biae da embo ewamei de da yei itido ira. ");
INSERT INTO nou_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Edo ingo embo ingo dubo burera awa dubo badewa te ingoda gitopo awa dubo bae awa Mamo mi awa awasedo ingo ewamei adi aera. Tax bari embobo mi embomei nei awodo dubo budo isera. ");
INSERT INTO nou_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Edo imo iso otao ga ge sise iso gitopo ga daedo ge sae adesa awa imo awa embo nei aera. Edo embo ave awa Mamo da kinapeina ae awa wasiri awodo edo era. ");
INSERT INTO nou_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imo wasiri ewamei be eio teta iso Mamo utu topo mi edo ira da awodo.” ");
INSERT INTO nou_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Edo Iesu uso ambojimbi atopapotise sisira, “Gido gogo ewo. Edo ingo embo mi ingo jasiga orase dipapa edo gido ingoda ari ewagaewa awa embo berari da jo da eove. Edo ingo ingoda ari ewagaewa awa embo da jo da adewa awa ingoda Mamo utu da amimi ingoda yei riroga itadi aera. ");
INSERT INTO nou_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Awasedo ingo embo rora ae embo gido kando itadewa awa mambudo embo berari da ingo ro etewa awa seove. Awodo adewa amone embo ise sarago edo era ainda wasiri ra. Awodo ise emboro da edo Jew embomei da dada ari oro da edo nati da tembuma era. Ari ewamei ise sarago euri embo mi sedo era embo omone embo ewamei ra sedo era. Awarate ruvegeove embo mi awodo sadera embo awa uso mina re matu betira. ");
INSERT INTO nou_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Awarate imo rora atae embo awa kondade adesa awa gae unjugari da eio. Imo awodo adesa awa Mamo imo gae unjugari da ro esa awa gido iso yei mina itadira. ");
INSERT INTO nou_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Edo embo ise sarago ari embo mi erido Mamo da yei da ge sedo ira Jew embomei da dada ari yei da edo emboro da irari embo mi umo gorase. Awarate ruvegeove embo mi umo gadera awa embo awa uso mina awa matu betira. ");
INSERT INTO nou_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Awarate boroko Mamo da yei ge teta ise sarago ari embo mi sarago eove ta ingo Mamo da yei ge sari dipapa adewa awa mambuwo ingoda mando da mando be gajedo edo Mamo da yei ingo ingosuka ge save. Ingo Mamo da yei ge awodo sadewa awa Mamo mi ingoda ge awa ingido ingo gido edo ingoda yei mina itadira. ");
INSERT INTO nou_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Edo ingo Mamo da yei ge sise gido ge dawadawa teta embo Mamo gae mi sarago eove. Edo ungo Mamo da yei ge awodo sise Mamo mi ungoda ge ingari kotedo era. ");
INSERT INTO nou_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Edo ingo Mamo da yei embomei omimi Mamo da yei ge sedo era da awodo seove ko ingoda Mamo ingo ro dipapa ewa amone matu gosira. Ingo mi uso yei sae gae rate umo umosuka gosira. ");
INSERT INTO nou_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Edo Mamo da yei ge eiedo sewo. ");
INSERT INTO nou_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","‘Mamo nangoda utu da atima esa awa embo berari mi iso jawo jasiga ore. Nango imo burigi burigi bugudo gitijigasase dipapa era. Utu da iso wasiri era da awodo embo busu da awa imo ungo ro orase dipapa esa ore. ");
INSERT INTO nou_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nangoda indari boroko da awa inono da itigae. ");
INSERT INTO nou_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nangoda buria awa kotembedo dogae edo da awodo nango embo nenei da buria nangoda yei awa kotembedo dodo ore. ");
INSERT INTO nou_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Edo nango bawari da kundo yiose ta ko nango biae da yeorase soregegae. Imo awa ewamei edo inemi busu da embo berari awa simba edo esa.’ ");
INSERT INTO nou_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Imo embo iso yei biae oro kotembedo doadesa awa imo wasiri biae adesa awa Mamo iso utu da da amimi imo kotembedo doadira. ");
INSERT INTO nou_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Awarate imo embo iso yei wasiri biae oro kotembedo doae adesa awa imo wasiri biae adesa Mamo utu da amimi imo mana kotembedo doadira. ");
INSERT INTO nou_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Iji dada imo Mamo da yei ge sari dipapa edo indari indae adesa awarate iso dombu awa doaso biae eure teta ise sarago ari embo da awodo. Edo ungo dubo vevera dombu ise temburoro embo mi ungo mamaso era awa gorase edo era te ungo mi era da awodo eove ta giwo ungo awa ungoda mina awa matu betera. ");
INSERT INTO nou_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Awarate imo neta ise Mamo da yei ge sari dipapa edo re iso dombu segedo kopiri tu gaedo eio. ");
INSERT INTO nou_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Awodo adesa amimi awa imo neta esa awa mana gadera. Awarate Mamo utu da mi iso wasiri gae esa awa gido iso yei mina itadira. ");
INSERT INTO nou_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Edo ingo rora jiwae budo busu da einda dada eove ko wowo de siri sasove mi indoro edo biae adira o bengono embo mi bejedo torido bengono adera. ");
INSERT INTO nou_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Awasedo rora jiwae utu da dada ewo awo wowo ta siri sasove mi mana usibesi adira edo bengono embo mi mana bejedo torido badera. ");
INSERT INTO nou_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Edo ingoda rora rawainda atira ainda ingoda jo awa daedo ainda. ");
INSERT INTO nou_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Edo dombu awa teta tamo da usasa awodo. Edo iso dombu ewamei awa iso tamo awa bibinago adira te iso dombu biae awa iso tamo awa umenga adira. ");
INSERT INTO nou_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Edo iso yei usasa awa umenga da awodo adira awa teta ge biae kotise edo atari biae da atadesa. ");
INSERT INTO nou_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Embo amemi mana gitijigari etoto kera adira. Awodo adira awa unemi gitijigari nei awa dubo burise nei awa biae adira o umo nei awa embo buro ewamei ise nei awa doadira. Da awodo imo mana Mamo sapo ise edo busu da rora awa jiwae dipapa adesa. ");
INSERT INTO nou_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Awasedo na ingoda yei sena ingo indari nonda budo indido kumbudo evi edo bo nonda budo evevi awa sedo kotembari jiwae eove ko indari kumbari de bo de awa nembodiba aera awarate ko ingo be awa nembodiba be ra. ");
INSERT INTO nou_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Edo ri memei inda giwo. Ungo ri ve gowae edo ungo indari dada edo budo indari atari yei da itae awodo aera te Mamo ingoda utu inda atima ira amimi ungo simba ise ungo kondade euri indari tambudo era. Edo ri memei da mina awa nembodiba awarate ingoda mina awa be nembodiba be ra awasedo Mamo mi ingo awa daedo simba adira. ");
INSERT INTO nou_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Edo rora berari einda kotembari jiwae ise iji natopo adewa amimi ari mana busu da iji nei kiambu yise atadewa. ");
INSERT INTO nou_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Awasedo kotembari jiwae eose imo bo ro evesi awasedo. Awarate ri wuji erido era awa koteio. Ungo buro aera te ungo erido era gari dagariae be. ");
INSERT INTO nou_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Edo gitijigari Solomon awa umo rora embo edo umo ombari ewamei edo isira. Edo umo iwuga awodo edo isira amimi euri gari ewamei edo isira awarate ri wuji awa ewamei be ra. ");
INSERT INTO nou_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","“Edo boroko Mamo mi etiri sasawa eiawa ribori edo goroba de eririra awarate amboda embo mi riawo mi itoro ewadira. Edo da awodo Mamo mi edo ira Mamo mi ingo simba adira. Edo Ingo Mamo awa gebe ae sumbae edo ewa. ");
INSERT INTO nou_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Edo embo ave Mamo gae awa iji berari kotedo ira na indari kumbari de bo sini de nonda beni kotedo ira. Awarate awodo kotove ainda be awa Mamo ingoda utu da atira amimi ingo ro embo jarewa amone gosira amimi ingo simba adira. ");
INSERT INTO nou_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Edo ingo iji berari Mamo ro awase dipapa ira awa adewa awa ingo awodo irirowo Mamo ingoda yei indari de rora nenei de awa itadira. ");
INSERT INTO nou_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Awasedo ro euma bugadira awa kotembari jiwae eove ko euma bugadira awa iji ainde awa euma da buria awa kotadesa. Edo iji dada awa tetegurise atiwo.” ");
INSERT INTO nou_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Edo Iesu uso ambojimbi atopapotise sisira, “Embo nei jigi gatove awodo adewa awa embo nenei mi mana ingo kiki diradera. ");
INSERT INTO nou_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Edo ingo embo nenei gae tu sumbadewa awa da awodo embo nenei mi ingo gae tu sumbadera. Emboro rawodo da imo embo nenei da yei edo esa da awodo Mamo mi iso yei adira. ");
INSERT INTO nou_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Edo imo iso diti joda ri dewo awa atirari embo nenei da diti joda ri momono awa geose. Edo imo iso diti da ri dewo awa atirari iso namendi da yei seose iso diti da ri momono awa bane seose. ");
INSERT INTO nou_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Imo wasiri biae embo giti iso diti da ri dewo awa budo yei isaga ari gosise awa iso namendi da diti da ri momono awa badesa. ");
INSERT INTO nou_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Edo embo ave Mamo da binga ewamei awa bae era awa teta sino inge ra awasedo Mamo da binga awa sekago ungoda yei itove ainda be awa teta sino inge awasedo ungo wareregedo ingo gambadera. Edo kotari ewagaewa Mamo mi ingoda yei ititira awa teta ingoda mamoumbogo da ri guri nembogambo ingege ra. Edo imo mamoumbogo da ri guri nembogambo awa pigae busu da pu da joda wosae ko awodo adesa awa pu mi yise puse ise patoro biae adira. ");
INSERT INTO nou_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Edo Mamo da yei sedo gio itare. Edo eura edo imo tambadesa. Edo taintain deio mangiro pirigare. ");
INSERT INTO nou_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Eiedo eio ainda be awa embo ave sedo gosera awa Mamo uso yei da itadira. Edo embo ave eura era amimi tambadera. Edo embo amemi taintain dorera ainda yei mangiro awa pirigadira. ");
INSERT INTO nou_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Edo ingo mamono ingoda memei mi indari embo soro ingo mana ungoda yei ganuma itadewa. ");
INSERT INTO nou_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Edo ungo wo embo soro ingo mana jingabu itadewa. ");
INSERT INTO nou_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Edo ingo awa embo ewagaewa aera te ingo ingoda kinapeina da yei rora ewagaewa itari dipapa edo ewa. Mamo da kando itari awa iso kando itari de inono aera awasedo iso Mamo utu da atima ira awa gari gido umo iji berari rora ewagaewa embo amemi uso yei sedo gido era ainda yei itido ira. ");
INSERT INTO nou_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Edo imo embo nei mi iso yei rawodo orase dipapa edo esa da awodo ungoda yei eio. Eiawa Moses da agodari da ititisira edo Mamo da binga sari embo mi atopapotisera. ");
INSERT INTO nou_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Edo be kiambu da torio. Emboro riawo matawa ewuse atira ainda tuturo awa be beraga be ra. Edo emboro ainda toradesa amone pepeta ari re isaga be ra awasedo embo jiwae be emboro ainda pepeta edo era. ");
INSERT INTO nou_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Awarate emboro ingodena mambudo Mamo ga atadera ainda tuturo awa kiambu ra awasedo embo jiwae mi emboro awa tambae edo era. Edo emboro ainda toradesa awa okain be ra. ");
INSERT INTO nou_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Edo dombu iso mi embo ave umo Mamo da binga sari embo sira awarate umo gebe moka awa atopatae awa gio. Edo umo iso yei teta iso otao edo teta atopatari Mamo da yei awodo bugari inge adira awarate uso kotari awa teta ambe sino da da awodo. ");
INSERT INTO nou_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Edo imo umo ro adira awa gido imo umo gadesa. Imo mana maumesi awa ri bebe de ainda mana badesa edo daedo imo mana bijo sari awa ri nei bebe de ainda mana badesa. ");
INSERT INTO nou_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Awarate ri ewamei awa indari ewamei edo ira awarate ri betari awa indari biae edo ira. ");
INSERT INTO nou_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Edo ri ewamei mi mana be biae mana adira edo ri betari mi mana indari ewamei mana adira. ");
INSERT INTO nou_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Edo ri indari ewamei ae adira awa ingo mi diugedo ingoda riawo adewa. Awasedo ingo ri be biae irirari gadewa awa ingo gadewa ri awa biae ra. ");
INSERT INTO nou_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Edo ingo embo amimi ro era awa gadewa awa ungo embo averi awa gadewa. ");
INSERT INTO nou_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Edo embo jiwae naso yei sera imo awa naso gitijigari sera awarate ungo berari awa mana Mamo mi gitijigadira ainda mana atadera. Edo embo ave ro naso Mama mi orase dipapa edo ira awa edo era iji ainde awa ainda atadera. ");
INSERT INTO nou_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Edo iji awa bugadira ainde embo jiwae mi naso yei sadera aio gitijigari iso jawo da nango Mamo da binga sedo era edo nango asisi bebegae ondoro ijegedo isera edo nango ari goroba neinde kainde edo isera sadera. ");
INSERT INTO nou_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Soro na ungoda yei da sadena na matu ingo embo bebegae awa gae ewona awasedo naso yei dodo edo mambuwo sadena. ");
INSERT INTO nou_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Awasedo embo ave naso ge ingido na ro sena awa adira awa umo awa teta jiro gari embo inge adira. Jiro gari embo eiawa uso mando tutuvi ngambedo ganuma itiri wosedo etiri tutuvi awa derido goroba isira. ");
INSERT INTO nou_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Edo amboda ga de bisi bisara de umo bojedo pusira te mando awa durae ko mando da tutuvi awa etiri goroba isira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Awarate embo ave naso ge ingido na ro sena awa ae era teta embo jiro biae embo da awodo. Embo eiawa uso mando tutuvi awa ngambusira te umo tutuvi da ganuma itae uso tutuvi awa derido edo goroba ae. ");
INSERT INTO nou_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Edo amboda ga de bisi bisara de umo bojisira etiri mando awa dudurisira. Edo mando dudurisira ainda amboda mando awa ainda atae.” ");
INSERT INTO nou_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Edo Iesu uso ambojimbi atopatido atae etiri embo jiwae uso ge ingisera amimi kove be edo sisera, “Embo oiawa ingodenaso agodari da atopapotegari awodo aera te awa goroba de da atopapotira.” ");
INSERT INTO nou_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Edo Iesu doriri awa dodo wowosiri embo jiwae be mi umo ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Edo Iesu uso ambojimbi de wosedo bugero embo da karu jawo leprosy bari amimi Iesu da yei bugudo Iesu da jo da baingo dederi edo sisira, “Bada imo dipapa adesa awa na egae seka ane.” ");
INSERT INTO nou_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Edo embo awa awodo setiri Iesu uso ingo gogorugedo embo awa tamesi ise embo ainda yei sisira, “Awara dipapa ena. Iso tamo awa ewamei adira.” Edo Iesu awodo sisira iji da ainde embo ainda tamo awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Edo Iesu mi embo ainda yei sisira, “Ro iso yei da ijegetira awa saso embo nenei mi geore ta dambuderari mambuio. Mambudo priest da yei mambaso iso tamo ujugedo gare. Gari awa rorou Moses da agodari mi sira awa itase. Awodo adesa awa embo mi imo karu jawo leprosy awa atae etesa awa gadera.” ");
INSERT INTO nou_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Edo Iesu Capernaum nati da toriri Rome isoro embobo ajigari 100 awodo gitijigedo isira embo da amimi Iesu tambudo umo kondade arase benunu sisira, “Bajari naso buro ari embo da awa karu edo memesi burise besi da pasido atira.” ");
INSERT INTO nou_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Setiri edo Iesu mi mina uso yei sisira, “Iso buro ari embo da yei amboda mambudo ano jebugadira.” ");
INSERT INTO nou_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Setiri Rome isoro embobo da gitijigari mi Iesu da yei mina sisira, “Na ewa raro naso mando da toresi ta ko ge mi segae naso buro ari embo awa ewamei are ko na gosena awodo re adira ainda be awa na awa gitijigari nembodiba da tuda edo isoro embobo nenei awa naso simba ari da atima era. Edo nanemi isoro embo da ainda sadena mambu sadena awa umo mambadira. ");
INSERT INTO nou_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Edo nei da sadena po sadena awa umo puradira. Edo naso buro ari embo da sadena eiawa e sadena awa umo adira.” ");
INSERT INTO nou_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Edo embo awa awodo setiri Iesu ge awa ingido kove be edo embo umo ambo ambo isera ainda sisira, “Na ingoda yei gebe sena na Israel embo da mi embo emimi na gebe ira da awodo awa gae be ra giwo. ");
INSERT INTO nou_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Edo na ro sena awa ruvegeove. Embo jiwae busu berari dodo bugadera amimi Mamo mi gitijigadira yei ainda dada adera. Edo anumbedo Abraham de Isaac de edo Jacob deda indido kumbudo ise atadera. ");
INSERT INTO nou_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Edo Mamo mi yei eiawa Jew embomei embo sia ira te Mamo mi Jew embomei jiwae awa budo wawara ari ponda yei umenga da atadera. Edo ungo ainda mambudo di vegise de edo ji de daedo atadera.” ");
INSERT INTO nou_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Edo Iesu ge awawa sedo atae edo Iesu mi Rome isoro embo da gitijigari da yei sisira, “Imo ro gebe esa awa nanemi ano be bugadira.” Edo Iesu ge awodo sisira iji da ainde Rome isoro embobo da gitijigari embo da buro ari embo awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Edo Iesu Peter da mando da mambudo Peter da umboti awa karu yauya budo besi da pasido atiri gosisira. ");
INSERT INTO nou_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Edo Iesu mi evetu ainda ingo awa jigiri uso yauya atae isira. Etiri Peter da umboti ewamei edo erido indari sia edo Iesu da yei ititisira. ");
INSERT INTO nou_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Edo ongobo etiri embo mi embo asisi bebegae mi sandari awa budo Iesu da yei bugusera. Bugero Iesu asisi bebegae da yei ge setiri edo asisi bebegae embo awa doturisera. Edo Iesu karu embomei ainda bugusera awa daedo etiri jebugurisera. ");
INSERT INTO nou_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Edo Iesu awodo isira amimi ro Mamo da binga itari embo Isaiah mi sisira awa be isira. Isaiah mi sisira, “Unemi ingodena ro etiri goroba ae etera awa soregedo edo ingodenaso karu amburo awa etiri ewamei etera.” ");
INSERT INTO nou_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Edo Iesu embo jiwae mi umo jinene burero gido uso ambojimbi da yei sisira, “Nga sia ewo. Awo ingodena umo diuga benei da sembore.” ");
INSERT INTO nou_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Siri iji ainde agodari da atopatari awa Iesu da yei bugusira. Bugudo sisira, “Atopatari imo yei rawainda yadesa awa na da ainda yadi sia etena.” ");
INSERT INTO nou_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Setiri Iesu mi uso yei mina sisira, “Ambe wo awa uso ngaja ewari yei atira edo daedo ri memei awa ungoda ngaja atira awarate na Mamo da mei busu da bugudo embo isena naso ewari yei atae ra.” ");
INSERT INTO nou_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Edo Iesu awodo siri embo nei ge ingido isira amimi Iesu da yei sisira, “Embo nembodiba na naso mama betari govedo ainda amboda awa na imo ambo ambo adena.” ");
INSERT INTO nou_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Setiri Iesu mi sisira, “Embo ave Mamo gae awa ainda dodo imo puio na ambo ambo ase.” ");
INSERT INTO nou_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Edo Iesu ge awa sedo Iesu nga da vivitisira uso ambojimbi de edo yei awa dodo mambusera. ");
INSERT INTO nou_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Edo kiambu yise Iesu pasido nga joda ewo isira. Edo Iesu ewo iri ga de bisi bisara de edo umo diuga awa teta ewa yawata ise arago edo sasaka nga joda vivitisira. Edo nga awa kununu badi isira. ");
INSERT INTO nou_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Awodo iri Iesu da ambojimbi mi Iesu da yei mambudo Iesu ewo wujido sisera, “Gitijigari nango betadi aikambu era mo gosesita nango kondade egae.” ");
INSERT INTO nou_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Setero Iesu mi mina sisira, “Ingo na gebe edo gogo ae edo ewa awasedo ingo oju mi biae etewa.” Sedo Iesu erido bisara de kau yawata de ainda yei ge setiri bisara jamo jamo etiri sasaka ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Etiri ambojimbi wasiri awa gido kove be edo sisira, “Embo eiawa averi? Bisara de kau yawata de umo kera etera.” ");
INSERT INTO nou_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Edo umo diuga awa sembudo Iesu Gadarene embo atima isera busu ainda bugusira. Ainda awa embo etoto meko to da embo govedo isera ainda atima isera. Edo embo etoto einda atero asisi bebegae ungoda joda atima isera amimi eoro embomei eiawa tini gambari ise dombu gunjoro gido embo emboro awodo yari awa oju edo isera. ");
INSERT INTO nou_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Edo ungoi Iesu gido Iesu da yei gogo dimbudo sisera, “Mamo da mei imo nangoda yei ro adi dipapa edo bugesi? Nangoda kasari iji awa bugae awasedo nangoda riroga itose.” ");
INSERT INTO nou_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Edo ungoi awa sero pu diti da ainda demonda durise atisera awasedo asisi bebegae embo etoto da joda amimi Iesu da yei benunu sisera, “Imo nango ondadi adesa re nango itio mambudo pu da joda torore.” ");
INSERT INTO nou_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Setero Iesu mi ungoda yei da sisira, “Mambuwo.” Setiri embo etoto awa dodo ungoi pu da joda totorisera. Etero pu mane mi sumbudo yei diwari awa dodo kekepunya edo umo da wosedo bebetegurisera. ");
INSERT INTO nou_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Edo pu simba ari embo sumbudo nati da mambudo embo etoto Iesu mi asisi bebegae etiri ewamei isera awa sisera. ");
INSERT INTO nou_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Edo nati da embo berari mambudo Iesu tambudo gido ungoda yei awa dodo mambarase sisera. ");
INSERT INTO nou_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Edo Iesu nga da vitido umo diuga da awodo sembudo sekago uso nati be da bugusira. ");
INSERT INTO nou_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Edo Iesu ainda bugiri embo mi embo tei ingo ambari awa apara da edo budo Iesu da yei bugusera. Etero Iesu ungo gebe era awa gido edo embo daguna da yei sisira, “Naso mei iso buria awa kotembedo doturena awasedo dubo ewamei eio.” ");
INSERT INTO nou_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Edo agodari da atopatari nenei mi ungo ungosuka ge mina sara edo sisira, “Embo emimi sira ro Mamo mi edo ira awa umo daedo adira sira. Edo umo ge awodo sira awa umo Mamo da yei da ge biae sira.” ");
INSERT INTO nou_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Awarate Iesu umo ungo ge ro kotera awa gido edo ungoda yei sisira, “Ingo ro awasedo kotari biae kotevi? ");
INSERT INTO nou_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Edo na ro seni? Na eiedo senita erido pepeta eio senita ko eiedo seni nanemi iso buria kotembedo doadena seni? Edo ge etoto einda ge rawa ge okain ri? ");
INSERT INTO nou_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na busu da atena ainde awa Mamo mi naso yei embo da buria kotembedo doanase goroba ari ititisira. Edo boroko nanemi buro nembodiba awa ano ingo mi eiawa gadewa.” Edo Iesu ge awa sedo edo embo ingo tei ambari da yei sisira, “Erido iso ewari besi budo edo iso nati da mambuio.” ");
INSERT INTO nou_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Setiri embo awawa erido uso nati da mambusira. ");
INSERT INTO nou_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Edo embo awa mambiri embo mi wasiri awa gido oju mi biae isera te ko Mamo jasiga isera unemi embo da yei goroba ari itira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Edo Iesu yei awa dodo mambuse Iesu tax bari embo jawo Matthew awa gosisira. Edo Matthew uso tax bari yei da anumbedo atiri edo Iesu mi uso yei da sisira, “Na ambo ambo eio.” Setiri Matthew erido Iesu ambo ambo isira. ");
INSERT INTO nou_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Edo Iesu uso ambojimbi de mando da indari indero tax bari embomei nei de embo bebegae de bugudo ungoda demonda anumburisera. ");
INSERT INTO nou_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Edo ungo anumbetero edo Pharisee embomei nei mi ungo gido edo Iesu da ambojimbi da yei sisera, “Ro awasedo ingoda atopatari embo bebegae de tax bari embo de da indari indiri?” ");
INSERT INTO nou_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Setero Iesu ingido ungoda yei sisira, “Karu ari jebugari embo awa embo karu ae ainda yei manamambadira te umo embo karu de ainda yei mambadira. Edo da awodo na awa embo ewagaewa awa embo bugae rate na embo bebegae awa embo bugusena. ");
INSERT INTO nou_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jiwari ewamei be da sisira awa ingiwo, ‘Na wo mi rorou itawase awa dipapa aera te ingo mi embo nenei dubo bawase dipapa ena.’ Awara mambuwo ge ainda be rori awa eura ave.” ");
INSERT INTO nou_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Edo John da ambojimbi mi Iesu da yei bugudo sisera, “Nango de Pharisee embomei deda wasiri awa nango iji dada neta kakana edo era. Edo ro awasedo iso ambojimbi wasiri da eiawa ambo ambo ae edo eri?” ");
INSERT INTO nou_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Edo ungo awodo setero Iesu mi mina sisira, “Edo jimbari iu seka awa jimbari da bondo da atadira mo esega embo mo dubo vevera erita? Awodo aera ungo awa dubo vevera adi aera. Edo na awa teta jimbari iu seka inge. Edo iji tupo na budo mambadera ainde awa naso ambojimbi awa dubo vevera ise neta kakana adera. ");
INSERT INTO nou_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Naso atopatari awa seka. Edo na ingoda yei kiki etoto sano ingido edo ingo eiawa gadewa. Embo amemi mana bo matu da to awa bo seka mi mana tauta adira. Awodo adira awa bo seka mi bo matu awa budo isisibari keradira segadi adira iji ainde. Edo keradira ainde awa to nembodiba be adira. ");
INSERT INTO nou_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Edo embo amemi mana umo seka jawo wine awa utingi wo ando mi ari matu da mana itadira ko wo ando matu awa mana jitugadira awasedo umo wine awa porokukusedo sauma utingi wo ando matu mi ari awa bejadira. Edo awodo adira umo wine awa yoyogo edo busu da wosadira. Awodo aera embo mi awodo ae edo era te umo wine seka awa utingi wo ando mi ari seka da itido era awa etoto awa ewamei atima era. Da awodo naso atopatari seka de ingoda wasiri matu de awa ingo mi mana dada adewa.” ");
INSERT INTO nou_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Edo Iesu ge awa ungoda yei sise atiri Jew embo da gitijigari nei mi bugudo Iesu da joda baingo dederi edo sisira, “Naso gagara ademei boroko betetira te pogae iso ingo mi uso tamo da itaso gagara ewamei edo atare.” ");
INSERT INTO nou_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Setiri gido Iesu erido edo uso ambojimbi deda gitijigari awa ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Edo ungo mambutero evetu karu orobi budo ororo wowoseuri atise gaeko 12 atae isira amimi kotisira, “Na uso ombari begiti da jigadena awa na ewamei adena.” Awa kotedo evetu awawa gunda bugudo Iesu da gara begiti da jijigurisira. ");
INSERT INTO nou_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Edo evetu awodo etiri Iesu wareregedo evetu awa gido uso yei sisira, “Naso gagara goroba eio. Imo na gebe etesa amimi imo ewamei etesa.” Edo Iesu awodo setiri iji ainde evetu awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Edo Iesu gitijigari da oro da bugudo joda totorisira. Edo Iesu joda torido embomei mi gauro pusero edo betari embomei awa embo jibia ero gosisira. ");
INSERT INTO nou_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Edo Iesu mi ungoda yei sisira, “Ingo berari dodo mambuwo. Edo gagara ademei eiawa betae ra te ewo ira.” Edo Iesu awodo setiri ungoi berari iro jirisira. ");
INSERT INTO nou_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Edo Iesu embo berari setiri ponda ijegetero Iesu gagara da diumba da torido gagara awa ingoda jigiri gagara awa eririsira. ");
INSERT INTO nou_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Etiri ge eiawa yei berari da rawusira. ");
INSERT INTO nou_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Edo Iesu yei awa dodo mambutiri embo diti guba egeregari etoto mi umo ambo ambo ise Iesu da yei sisera, “David da orobe nango jo egae.” ");
INSERT INTO nou_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Edo Iesu uso mando joda toriri embo diti guba egeregari awa daedo totorisera. Etero Iesu mi ungoda yei nganega isira, “Ingo nanemi ingo kondade adena awa gebe evita?” Setiri ungoi Iesu da yei mina sisera, “Embo nembodiba nango gebe era.” ");
INSERT INTO nou_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Setero Iesu mi ungoda diti awa jigido ungoda yei sisira, “Ingo ro gebe ewa awa awodo are.” ");
INSERT INTO nou_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Edo Iesu awodo setiri ungoda diti ewamei etiri ungoi yei gosisera. Etero Iesu mi ungoda yei ge tini javi de sisira, “Eiawa sawo embo nenei mi geore.” ");
INSERT INTO nou_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Awarate Iesu ge awodo setiri ungo mando awa dodo yei berari da mambudo embo jiwae be setero gosisera. ");
INSERT INTO nou_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Edo embomei mando awa doturero embo nenei mi embo asisi biae mi joda aturi ge sae edo isira awa budo Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Etero Iesu mi asisi biae awa budo pigetiri ijegetiri embo awa ge sadi tuturo isira. Etiri embo berari mi awa gido kove be isera edo sisera, “Nango Israel embomei wasiri eiedo irirae nango matu gae.” ");
INSERT INTO nou_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Awarate Pharisee embo mi sisera, “Amone asisi bebegae da bajari mi Iesu da yei asisi bebegae ondarase goroba itiri gido awodo re ira.” ");
INSERT INTO nou_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Awodo atae edo Iesu pepeta edo nati berari awa esega isira. Ise Jew embomei da dada ari mando mando da embo atopapotisira. Edo embo atopapotise binga ewamei Mamo mi embo gitijigadira iji awa sisira. Edo daedo Iesu embo jiwae karu amburo neinde kainde dubo vevera edo isera awa euri ewamei edo isera. ");
INSERT INTO nou_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Edo Iesu embo eiawa gido ungo jo isira ko ungo bouga be burera awa ungo ro adera awa ungo gae. Edo embo amenda soro ungo kondade aderi awawa ungo awa teta wo jawo sheep mi wo simba ari embo ae gido tepo tapo tembuma era da awodo gosisira. ");
INSERT INTO nou_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Awasedo Iesu mi uso ambojimbi da yei sisira, “Indari be jiwae edo sia etira embo mi dada orase awarate indari dada ari embomei awa enumba ae mi dada edo era. ");
INSERT INTO nou_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Awasedo busu da indari erido ira ainda topo da sewo, “Buro ari embomei jiwae itaso mambudo indari awa dada ore.” ");
INSERT INTO nou_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Edo Iesu uso ambojimbi 12 setiri uso yei dada isera. Edo ungo dada etero Iesu ungoda yei asisi bebegae ta ko karu neinde kainde ari jebugari da goroba awa ititisira. ");
INSERT INTO nou_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","3","Edo eiawa Iesu da ambojimbi 12 Iesu mi itiri mambusera awa Simon uso jawo nei Peter de uso namendi Andrew de edo James de uso namendi John Zebedee da memei de edo Philip de Bartholomew de Thomas de Matthew tax bari embo de edo James Alphaeus da mei de Thaddaeus de edo Cana embo Simon de daedo. ");
INSERT INTO nou_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Edo Judas Iscariot umo Iesu Jew embomei da gitijigari da yei indiga sisira ainde. ");
INSERT INTO nou_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Edo Iesu embomei 12 eiawa itiri mambusera te giti awa Iesu ungo atopapotisira. Edo ungo atopapotise Iesu mi sisira, “Embo Jew ae jawo Gentiles ainda yei da mambove edo daedo Samaria busu ainda nati memeia da mambove. ");
INSERT INTO nou_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Awarate Jew embomei awa teta wo jawo sheep inge edo jiwae jajovegari awasedo ungoda yei da mambuwo. ");
INSERT INTO nou_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mambudo ungoda yei save iji Mamo mi gitijigadira awa asusubetira sewo. ");
INSERT INTO nou_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Edo karu embo ewo jebubugore. Betari embo awa jigiwo erore. Edo karu jawo leprosy awa ewo ewamei ore edo asisi bebegae awa ondewo ijegore. Na ingoda yei ro itena awa ingo mina itae awasedo ingo daedo itido edo mina bari dipapa eove. ");
INSERT INTO nou_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Ungoi buro embomei awa indari de rora nenei de ungo dipapa era awa itadera awasedo ingoda rora da mana gano awa badewa. Edo daedo ingoda sapoia ta bo nei ta tei goru ta ko ketu awa mana badewa. ");
INSERT INTO nou_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Edo ingo nati nei da mambudo embo ingo gadi dipapa ira awa tambudo edo embo ainga atiwo. Edo ingoda buro atae ari gido awa mando awa dodo mambuwo. ");
INSERT INTO nou_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Edo ingo mambudo mando da vivitise gido re jao namendi ari atega awodo ewo. ");
INSERT INTO nou_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Awarate embo mando ainda mi imo atega adira awa mando ainda anumbedo daga kiki dirio. Awarate ungoi imo atega ae adera awa ainda atise ungoda yei ewamei eose. Edo embomei awa dowo. ");
INSERT INTO nou_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Embo amemi ingo atega ae ise ingoda ge ingae adera awa yei awa doturise yei ainda konipo ingoda tei da awa dede ewo wosare. ");
INSERT INTO nou_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Edo na ingoda yei sena Mamo da kasari iji bugadira. Iji awa bugadira iji ainde awa Mamo mi Sodom embo bebegae de edo Gomorrah embo bebegae de da yei riroga nembodiba itadira awarate nati awa embomei ingo atega ae etera ainda yei awa riroga nembodiba be nembodiba itadira. ");
INSERT INTO nou_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Dengoro edo naso ge ingido gogowo ewo. Teta maine sino mi wo jawo sheep gambarago adera giwo na ingo iteno mambadewa iji ainde naso gitopo mi ingo gambadera awasedo jiro gari embo edo saboa ewo teta ri ribo inge ewo. ");
INSERT INTO nou_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Edo sia ise tembuwo embo mi ingo bundedo budo Jew embomei da dada ari oro da mambadera. Mambudo ainda ungoi ingo kasedo edo ingo vejadera. ");
INSERT INTO nou_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Edo embo mi daedo budo gitijigari kiambu da edo gitijigari nembodiba da yei mamboro ingo na ambo ambo edo ewa awasedo kasadera. Edo nanemi doano eiawa adera ainde ingo mi binga ewamei awa gitijijigegari embomei ainde edo daedo embo Jew ae ainda yei sadewa. ");
INSERT INTO nou_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Edo ingo budo gitijijigegari da yei mamboro gido ae ro seni edo rawodo seni awa kotove awarate iji awa bugadira ainde awa nanemi ro sadewa awa sano sadewa. ");
INSERT INTO nou_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Edo ge ro ingo mi sadewa awa ingoda ge aera ainda be awa Mamo da asisi mi ingoda joda atise ge amone sadira. ");
INSERT INTO nou_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Edo iji ainde awa namendi mi namendi embo nenei mi doro betarase itadira. Edo da awodo mamono mi kinapeina awa indiga sadera edo daedo kinapeina mi ai mamono awa embo nenei mi doro betorase indiga sadera. ");
INSERT INTO nou_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Embo jiwae mi ingo ujo ae adera ko ingo awa naso topo awasedo. Awarate iji sangove be da awa embo amemi goroba edo atadira awa Mamo mi soregadira. ");
INSERT INTO nou_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Edo ingo nati nei da dedo gaedo oro gido oju nati nei da mambuwo. Edo iji ainde na bugadena ainde awa ingo nati berari ainda esega ae atirowo bugadena. ");
INSERT INTO nou_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Edo gari gadira embo awa kiambu rate umo atopapotira awa nembodiba ra. Edo buro ari embo awa kiambu rate bajari awa nembodiba ra. ");
INSERT INTO nou_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Awasedo gari gadira embo ainde buro ira embo ainde awa teta atopatari inge edo bajari inge adera awa dowo inono be ore. Na awa orobe da gitijigari edo ungoi na awa Beelzelbul Satan da jawo nei awa sadera awa ungoi daedo ingoda jawo biae sadera. ");
INSERT INTO nou_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Edo wasiri embo mi ro unjugurera awa nanemi isaga adena edo embo da koma ge awa nanemi isaga adena awasedo embo oju eove. ");
INSERT INTO nou_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ro na ingoda yei umenga da sena awa ingo mi isaga da sadewa. Edo ro na ingoda yei gae sena awa ingo mi embo dada edo era ainda sadewa. ");
INSERT INTO nou_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Edo embo deoro betedo era awa oju eove. Embo emimi tamo awa deoro betedo era te ungo mi mana embo da asisi awa mana doro betadira. Edo Mamo mi riawo mata awa ewuse atari ititisira ainda awa embo da tamo de asisi de awa dari betadera awasedo Mamo oju ewo. ");
INSERT INTO nou_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Edo ingo mi ri memei etoto awa mina kiambu itido badewa te ri mei awa mana tepo busu da wosadira. Edo ri mei da awa busu da duradira awa iso Imamo awa gosisira. ");
INSERT INTO nou_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Da awodo Mamo awa iji berari awa imo awa ruvegae iso kopiri tu roinge ri awa gosira. ");
INSERT INTO nou_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Teta Mamo mi ri memeia simba ira da awodo ingo awa simba ira awasedo oju eove. ");
INSERT INTO nou_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Embo amemi arapa da umo na gari sadira awa na utu da atise na naso Mama da yei embo awa na gari sadena. ");
INSERT INTO nou_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Awarate embo amemi arapa da umo na gae sadira awa na utu da atise naso Mama da yei na embo awa na gae sadena. ");
INSERT INTO nou_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ingo ro kotevi? Ingo kotewa naso bugari mi ari embo dubo jamo de ateri ta? Ingo awa kotevita? ");
INSERT INTO nou_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Awarate awodo kotove naso bugari mi ari embomei dubo jamo de atadi ari awa kotove ta embo ewoga ewoga adera. Embo nenei awa na gebe adera te embo nenei awa na gebe adi aera awawa eiedo adira. Memei de mamono de awa kausu kausu adera. Ai de meigagara de kausu kausu adera. Umboti de mei aro de kausu kausu adera. ");
INSERT INTO nou_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Edo wasiri eiedo bugadira ainde awa embo uso gitopo awa topo adira. ");
INSERT INTO nou_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Embo ave uso ai de mamo de dubo nembodiba burise na dubo bae sumbae ira edo na edo gogo edo sapo ae ira. Daedo embo ave uso mei ta gagara awa dubo burise na dubo bae sumbae ira awa naso ambojimbi be aera. ");
INSERT INTO nou_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Embo amemi uso orega budo edo na pepeta ena emboro da ainda pepeta ae adira embo awa naso buro ari embo be aera. ");
INSERT INTO nou_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Embo ave wasiri de atadi dipapa adira awa betadira awarate embo ave na awa embo betadira awa wasiri natopo atari badira. ");
INSERT INTO nou_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Embo ave ingo atega adira awa na atega adira. Edo embo ave na atega adira awa Mamo na itiri bugusena awa atega adira. ");
INSERT INTO nou_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Embo ave Mamo da binga sari embo atega adira ko Mamo mi umo itiri bugira awasedo umone daedo awa binga sari embo da riroga awa umo daedo badira. Embo ave embo ewamei awa atega adira awa embo ewamei da riroga awa daedo badira. ");
INSERT INTO nou_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Edo embo ave sasaka jamo naso ambojimbi dubo gagara ira ainda itadira awa umo embo kiambu rate embo ainda Mamo mi mina itadira.” ");
INSERT INTO nou_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Edo Iesu uso ambojimbi 12 awa atopatido atae etiri edo yei awa dodo nati demonda ainda mambudo embo ainda awa atopapotisira. ");
INSERT INTO nou_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John awa bundari oro da atise Keriso da buro da binga awa ingisira awasedo John uso ambojimbi nenei itiri Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Edo ungoi Iesu da yei bugudo Iesu da yei nganega isera, “Imo mo embo John mi bugarase sevira awa tamo ko nango mo embo nei simba eri?” ");
INSERT INTO nou_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Setero Iesu mi mina sisira, “Engenembedo John da yei mambudo ingo ro ingewa edo gosewa awa John sewo gare edo sewo embo dombu guba ari yei gosera edo tei bebegae ari ewamei era edo karu jawo leprosy bari awa ewamei era edo dengoro junjugari ge ingera edo bebetegari sekago ererera edo rora ae embobo awa binga ewamei ingera. ");
INSERT INTO nou_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Edo John da embo amende naso yei na nganega aera te na gebe era embo awa dubo ewamei adira awa sewo gare.” ");
INSERT INTO nou_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Edo John da ambojimbi engenemburero Iesu mi embo da yei John da jawo da ge sisira, “Iji da ainde ingo yei ro atae da John gadi mambusewa ingo ro gadi kotise mambusevi? Ingo embo teta openga bisara mi piguri mambudo bugudo ise atima ira da awodo gadi mambusevita? ");
INSERT INTO nou_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ta ingo embo rora embo ombari digari ewagaewa de awa gadi mambusevi? Embo ombari digari ewagaewa de awodo re gitijigari da mando da gitijigari mi atarago adera. ");
INSERT INTO nou_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Awodo aera ingo embo awodo awa gadi mambae rate ingo re Mamo da binga sari embo awa gadi mambusewa. Edo John awa binga sari embo nenei derigadira. ");
INSERT INTO nou_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","John awa Mamo mi ove jiwari da sisira embo awa sisira, ‘Eiawa naso binga sari embo nanemi giti itano mambudo iso emboro ewamei adira.’ ");
INSERT INTO nou_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Edo emboevetu mi kinapeina budo era ainda teda John awa nembodiba be awarate John awa embomei Mamo mi gitijigido ira ainda atima era ainde inono ae. Embomei awa nembogambo ra te John awa nembodiba ae. ");
INSERT INTO nou_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Edo John atopatadi tuturo isira ainda edo bugudo boroko awa embo jiwae be jo de berari simba ewora Mamo gitijigido ira amimi ungo ewamei arase. Awodo ise awa ungo goroba berari oro Mamo mi ungo ewamei arase edo era. ");
INSERT INTO nou_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Binga sari embo berari de Moses da agodari de berari awa John bugae atiri awa sisera Mamo gitijigido ira amimi ari eiedo awa adira awa sedo isera. ");
INSERT INTO nou_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Edo binga sari embo mi sedo era Elijah binga sari embo awa bugadira sedo era awasedo ingo ro binga sari embo mi sewora awa gebe adewa awa ingo mi gadewa John awa binga sari embo umo awa Elijah inge. ");
INSERT INTO nou_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ingo embo berari ro nanemi sena awa kotedo gogowo ewo.” ");
INSERT INTO nou_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Edo Iesu mi sisira, “Embo boroko atera awa embo gari rawodo ri? ");
INSERT INTO nou_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ungo awa teta kinapeina memeiako mi nati da usini ise mina sara arago edo era, ‘Nango jimbari da usini etera te ingo ya diwae awasedo nango betari da usini etera te ingo ji sae awasedo usini ingode ro eri awawa ingo dubo ewamei ae? ");
INSERT INTO nou_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Awodo edo John bugusira iji ainde John neta edo umo wine indae edo isira awasedo embo berari mi sedo isera asisi biae uso joda atima ira sedo isera. ");
INSERT INTO nou_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Edo na Mamo da mei awa embo isena awa bugudo indido kumbudo eono embo berari mi sedo isera embo oiawa giwo. Embo omone rora jiwae indise edo umo wine jiwae indido ira edo tax bari embo de embo bebegae nenei de da otao edo ira sedo isera. Awarate imo ro esa awa embo mi gido awa imo jiro gari embo ta ko jiro gari embo ae ri awa gadera.” ");
INSERT INTO nou_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Edo embo nati nenei da Iesu mi uso wasiri jiwae ewamei uso goroba mi edo isira awa ungoda wasiri bebegae awa dodo Mamo da yei wareregae edo isera. ");
INSERT INTO nou_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Awasedo Iesu mi embomei ainda yei tini gambari edo sisira, “Ingo Chorazin de Bethsaida embomei de gido gogowo ewo. Ingo naso goroba mi wasiri ewamei etena awa getewa awarate Tyre embomei de Sidon embomei bebegae de matu awa wasiri goroba de eiawa gae etera awa ungo ungoda wasiri bebegae awa dodo Mamo da yei wareregae eterita rora. Edo bo matu ewudo digido edo aviga budo beo da gutoro embo mi ungoda Mamo da yei wareregari awa gae etera. ");
INSERT INTO nou_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Edo Mamo da kasari iji puradira ainde awa Mamo mi Tyre de Sidon embomei awa nembodiba kasadira te ingo Chorazin de Bethsaida embomei de awa kiambu ae kasadira.” ");
INSERT INTO nou_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Edo Iesu mi Capernaum embomei da yei daedo sisira, “Ingo kotewa ingo mi utu da vitadewa ainda be awa naso ewamei ari jiwae ingoda yei bugudo ira awasedo awarate ingo awa riawo mata awa ewuse atira ainda wosadewa. Ingo getewa ingoda nati da wasiri goroba de etena awa awarate Sodom embomei mi wasiri eiawa gae etera awa ungoda nati awa boroko atae etira. ");
INSERT INTO nou_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kotewo Mamo da kasari iji bugadira ainde Mamo mi ingo awa nembodiba be kiambu ae kasise edo Sodom embomei awa kasari awa nembodiba itadira. ");
INSERT INTO nou_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Iji ainde Iesu mi sisira, “Mamo imo busu de utu de gitijigido esa imo ro gari embomei da itae doturisesa awa kinapeina da yei ititisesa ko emboro awodo arase imo dipapa isesa awasedo.” ");
INSERT INTO nou_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Edo sekago Iesu uso ambojimbi da yei sisira, “Naso Mama mi rora berari awa naso ingo da itido nanemi simba anase sisira. Edo embo mi na awa gido gogo ae awarate naso Mama na awa gosira. Embo mi Mamo awa gido gogowo ae awarate embo amemi Mamo awa embomei ounda yei isaga arase dipapa ena ungo awa Mamo awa gosera. ");
INSERT INTO nou_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Edo embo amemi bouga burise begogo adera embo awa naso yei puwo nanemi ano jango indave. Edo ingoda buro nangae otao ise ewo. ");
INSERT INTO nou_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Edo ingo awodo irirowo awa nanemi ingo atopatane ainda be awa na awa jo sasainbari de ra. Edo nanemi sedo gano ingo buro ari katogo ae awa mana adewa. ");
INSERT INTO nou_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Edo na buro ro ingoda yei itena awa ingo nangae otao edo buro ise awa dubo jamo de edo atadewa.” ");
INSERT INTO nou_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Edo iji tupo Jew embomei da tumondebain ari iji de Iesu uso ambojimbi de wheat buro da awodo pepeta ero Iesu da ambojimbi beji mi bebegae edo gido pisa nenei awa gavedo kandedo indisera. ");
INSERT INTO nou_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ero Pharisee embomei mi gido Iesu da yei sisera, “Gio nangoda agodari mi sira tumondebain ari iji de buro eose sira edo ro awasedo iso ambojimbi eiedo eri?” ");
INSERT INTO nou_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Setero Iesu mi mina sisira, “Ingo kiki gitijigari David da awa ajigedo gae ta iji ainde umo uso embomei de beji eteri? ");
INSERT INTO nou_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Edo umo Mamo da tumondebain ari oro da torido edo Mamo da buro ari embo mi indari ambe awa itiri uso embomei deda indisera. Edo ambe amone Mamo da yei kando ititisera awa edo Mamo da agodari mi sira awa Jew embomei da priest ungo ungosuka indari ambe awa indadera te embo nenei mi mana indadera. ");
INSERT INTO nou_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Edo ingo Moses da agodari ainda sira awa Mamo da buro ari embo awa tumondebain ari iji de buro edo era awa ajigedo gae ta? Edo buro eiedo ise amimi ungo agodari awa diugae. ");
INSERT INTO nou_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Edo na ingoda yei sena na awa teda ingoda embo nembodiba awarate tumondebain ari oro awa nembodiba aera. ");
INSERT INTO nou_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mamo jiwari ewamei be da sira, ‘Na wo mi rorou itawase awa dipapa ae awarate na dipapa ena awa ingo embo nenei dubo bawase.’ Edo ingo ge eiawa rori ainda be awa gadewa awa ingo mana embo nenei buria ae ingo mana dawo betadewa. ");
INSERT INTO nou_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na Mamo da mei embo isena awa daedo tumondebain ari iji awa gitijigido ena.” ");
INSERT INTO nou_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Edo Iesu Jew embomei da dada ari oro da mambudo embo da ingo ambari awa gosisira. ");
INSERT INTO nou_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Edo embo nenei mi Iesu bekuba adi dipapa edo gido Iesu da yei nganega isera, “Ingodenaso agodari mi sari tumondebain ari iji de embo oro ewamei eita?” ");
INSERT INTO nou_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Setero Iesu mi mina sisira, “Edo ingoda wo da awa tumondebain ari iji de kouro ngambari da durari mo jumbawo vitaetita? ");
INSERT INTO nou_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ingoda wo awa nembodiba awarate ingo awa nembodiba be ra. Awasedo ingodenaso agodari mi atopapotira awa tumondebain ari iji de embo nenei awa kondade adera.” ");
INSERT INTO nou_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sedo Iesu mi embo ainda yei sisira, “Iso ingo awa besugeio.” Setiri embo awa uso ingo besugurisira. Etiri embo ainda ingo awa ingo be nei awodo ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Etiri Pharisee embomei yei awa dodo mambudo Iesu doro betarase kiki dirisera. ");
INSERT INTO nou_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Edo Iesu ge awa ingido umo yei awa dodo mambusira. Mambutiri embo jiwae mi Iesu ambo ambo isera. Edo Iesu mi karu embobo berari awa etiri ewamei isera. ");
INSERT INTO nou_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Etero embo nenei soro georase sisera. ");
INSERT INTO nou_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Edo Iesu awodo isira awa ro Mamo mi binga sari embo Isaiah da yei matu sisira awa be isira. ");
INSERT INTO nou_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Edo Mamo da ge awa binga sari embo Isaiah mi sisira, “Naso buro ari embo awa giwo ave nanemi dubo budo ena edo daedo na umo awa embo na dubo ewamei edo ena. Edo buro ari embo eiawa na dipapa ena awasedo nanemi naso Asisi Ewamei uso yei itadena. Edo naso Asisi Ewamei uso yei itadena awa unemi naso wasiri ewamei awa embo Mamo da ge matu gae ainda yei karigadira. ");
INSERT INTO nou_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Awarate ge sasainbedo sise tini gambari adi ae edo ge bagadi ae. ");
INSERT INTO nou_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","“Edo embo ave goroba ae awa teta sasawa bainyedo atima ira da awodo. Edo naso buro ari embo awa mana sasawa bainyedo atira awa vejadira. Edo embo ave goroba ae awa teta goriwo da usasa ambadi aikambu edo ira awodo. Edo naso buro ari embo mi mana usasa awa ari atae adira te unemi mata buro ise atadira edo amboda ewamei mi derigari wasiri biae awa atae adira. ");
INSERT INTO nou_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","“Edo embo neinde kainde mi naso buro ari embo da jawo awa ingido edo naso buro ari embo gebe adera.” ");
INSERT INTO nou_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Edo embo nenei mi Iesu da yei embo diti guba ari edo ge sae awa budo bugusera ko asisi biae mi uso joda atima isira awasedo. Edo Iesu embo awa etiri ewamei edo sekago yei gosise edo ge sisira. ");
INSERT INTO nou_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Etiri embo berari mi be gido jarisera edo sisera, “Embo emomo David da orobe ta?” ");
INSERT INTO nou_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Setero edo Pharisee mi ge awa ingido sisera, “Asisi biae da gitijigari jawo Beelzebul mi Iesu da yei goroba itiri asisi bebegae awa ondetiri mambera awarate embo nei mi goroba awa itae itaera.” ");
INSERT INTO nou_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Setero Iesu ungo ge ro kotera awa gido Pharisee embobo da yei sisira, “Embo busu da da amimi katabedo edo embogo adera amone borere ae atae adera. Edo daedo embo nati da da amimi katabedo embogo adera amone borere ae atae adera. Edo daedo embo orobe nenei da da amimi katabedo edo embogo adera amone borere ae atae adera. ");
INSERT INTO nou_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Edo da awodo Satan da ambojimbi asisi bebegae de embogo edo mina onda edo mambujegadera awa ungo ungosuka usibesi mina ara adera. ");
INSERT INTO nou_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Edo ingo sewa na asisi bebegae ondeno ijegurera awa asisi bebegae da gitijigari jawo nei Beelzebul mi goroba itari ari ge sewa te na awodo ena awa ingoda ambojimbi da goroba mo amimi ititiri asisi bebegae onderi? Edo sewo ingoda ambojimbi mi naso yei ge ro sewa ainda mina awa soro gave. ");
INSERT INTO nou_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Awarate Mamo da Asisi da goroba mi na asisi bebegae awa ondeno ijegurera gido re ingo gadewa Mamo awa ingoda joda matu buro tuturo etira. ");
INSERT INTO nou_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Edo embo da mi embo goroba embo da ainda mando bejedo uso rora bengono adi ae etira awa rawodo ae etiri? Giti awa embo goroba embo awa bundedo awa uso mando bejedo torae etira. ");
INSERT INTO nou_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Edo embo ave na kondade ae ira awa naso gitopo ra. Edo embo ave nangae dada ae ira amimi iri embomei ewoga ewoga era. ");
INSERT INTO nou_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Edo na ingoda yei sena embo ave ge biae sise wasiri biae edo ira awa Mamo mi kotembedo doadira awarate embo amemi Asisi Kotopu da yei ge biae sadira awa Mamo mi mana embo awa kotembedo doadira. ");
INSERT INTO nou_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Edo embo amemi na Mamo da mei bugudo embo isena naso yei biae sadira awa Mamo mi kotembedo doadira awarate embo amemi Asisi Kotopu da yei biae sadira awa Mamo mi mana embo awa kotembedo doadira. Edo embo amone da awodo mata atadira. ");
INSERT INTO nou_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Edo imo ribe euri inda gido imo ri awa ro ri awa gido esa. Edo ri ewamei awa ribe ewamei edo ira edo embo mi ri awa ewamei awa gadera. Edo ri biae awa ribe biae ari embo mi ri biae awa gadera. ");
INSERT INTO nou_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ingo embo bebegae awa teta jingabu ingege. Ingo awa embo bebegae awasedo ingo ge ewamei sae edo ewa. Edo ingo ingoda joda ro kotewa da awa ingoda be mi sadewa. ");
INSERT INTO nou_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Edo embo ewamei da kotari awa ewamei awasedo embo awa ge ewamei sadira awarate embo biae da kotari awa bebegae awasedo umo ge bebegae sadira. ");
INSERT INTO nou_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Edo na ingoda yei sena iji ge kasari bugadira ainde ge bebegae sewowa awa Mamo da yei ingo mi edo gogo edo sawo gadira. ");
INSERT INTO nou_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Edo ingo mi Mamo da yei edo gogo edo sawo Mamo mi ingoda yei sadira ingo buria etewa saride o ingo buria aera sadira.” ");
INSERT INTO nou_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Edo Iesu ge awa setiri agodari atopatari embo jawo Scribe de agodari da simba ari embo jawo Pharisee de mi Iesu da yei sisera, “Atopatari nango inemi kariwa da goroba de asase dipapa era.” ");
INSERT INTO nou_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Setero Iesu mi ungoda yei sisira, “Embo boroko atima era awa bebegae edo ungo Mamo awa gae. Edo ingo naso yei da iwata goroba de gari dipapa ewa te na mana adena. Ro Mamo mi binga sari embo Jonah da yei isira amone iwata goroba de ra. Edo na mana ingoda yei iwata nei itadena. ");
INSERT INTO nou_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Edo Jonah iji tamonde edo tumba tamonde wo nembodiba da tini da atisira da awodo na Mamo da mei umo embo isira da awodo iji tamonde edo tumba tamonde busu da joda atadena. ");
INSERT INTO nou_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Edo iji ge kasari iji de Nineveh nati embo mi erido oro ingo me gadewa ainda be awa Jonah ungoda yei mambudo ungo atopatetiri ungo ungoda wasiri bebegae dodo Mamo da yei wareregurisera. Edo na awa Jonah derigedo edo boroko ingoda teda derido atena. ");
INSERT INTO nou_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Edo iji ge kasari iji de daedo busu Sheba da gitijigari evetu mi erido ari ingo me gadewa ainda be awa matu be matu evetu awa yei besaun be edo Solomon da uso jiro gari ge awa gadi bugusira. Edo Solomon awa gitijigari nembodiba awarate gitijigari nembodiba be nembodiba awa boroko ingoda teda atira.” ");
INSERT INTO nou_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sedo Iesu sisira, “Asisi biae embo da jo dodo wosedo mambudo yei embo atae da tembuma jango indari yei eura edo yei da tambae edo umo umosuka sedo ira, ‘Embo dodo bugena awa naso mando ra awasedo na ainda sekago engenembadena.’ ");
INSERT INTO nou_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Awasedo engenembedo mambudo mando ainda mambudo mando awa jo ewamei gadira. ");
INSERT INTO nou_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jo ewamei gido dodo wosedo ponda mambudo asisi biae mi asisi bebegae nenei 7 awodo budo mando ainda daga atorase bugadira. Edo asisi biae awa biae ra awarate asisi bebegae nenei 7 awa be bebegae be bebegae ra. Edo embo asisi biae uso joda atima isira awa giti da awa biae atima isira te boroko awa biae be biae atira. Emboro eiedo awa embo bebegae boroko atera ainda bugadira.” ");
INSERT INTO nou_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Edo Iesu embo da yei ge sedo atae adi iri uso ai de nanonamendi de bugusera. Bugudo ponda derido embo da yei sisera, “Nango Iesu ga da ge sadi dipapa era.” ");
INSERT INTO nou_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Setero embo da ainda atisira amimi Iesu da yei sisira, “Gi. Iso ai de nanonamendi de ponda derido ingae da ge sadi dipapa era.” ");
INSERT INTO nou_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Setiri Iesu mi mina sisira, “Naso aia de nanonamendi de mo averi?” ");
INSERT INTO nou_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sedo Iesu ingo mi uso ambojimbi da yei ujiji ise sisira, “Giwo. Eiawa naso aia de nanonamendi de ra. ");
INSERT INTO nou_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Embo ave ro naso Mamo utu da mi arase dipapa ira awodo ira awa naso namendi de naso ru de naso aia dera.” ");
INSERT INTO nou_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iji ainde Iesu mando awa dodo umo diuga da bengi da mambudo anumbedo atopapotisira. ");
INSERT INTO nou_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Edo Iesu ainda anumbedo atiri embo jiwae be mi bugudo umo jinene burisera. Etero gido Iesu erido nga da vivitisira. Vitido Iesu anumbetiri embo umo diuga da bengi da derido atisera. ");
INSERT INTO nou_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Edo embo ainda atero Iesu inia ge mi ungo atopapotisira. Iesu embo da yei kiki eiawa sisira, “Embo da amimi uso buro da ve gowadi mambusira. ");
INSERT INTO nou_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Edo embo awa uso buro joda tembuse ve budo yei berari da pigedo isira. Edo ve nenei awa emboro da dudurisera. Etero ri memei mi wosedo ve awa indisera. ");
INSERT INTO nou_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Edo ve nenei awa busu ganuma de ainda dudurisera ko ainda awa busu awa kiambu awasedo ve awa burigi eririsera ainda be awa busu awa kiambu awasedo. ");
INSERT INTO nou_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Edo waiko vitido ve seka awa ewusira. Edo ve awa ambusira ainda be awa ve ainda besisi awa be wosae awasedo. ");
INSERT INTO nou_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Edo ve nenei awa bebe soropuda dudurisera. Edo bebe erido nembodiba etiri ve seka awa uso teda awasedo erae sumbae isera. ");
INSERT INTO nou_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Edo ve nenei awa busu ewamei da wowosisera edo ewamei be eririsera. Edo ve ewamei eiawa erido ve nenei awa be 100 edo ve nenei awa be 60 edo nenei awa 30 awodo isera.” ");
INSERT INTO nou_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Edo Iesu kiki eiawa atae edo ungoda yei sisira, “Ingo ingoda dengoro atira awasedo naso ge eiawa ingido gogo ewo.” ");
INSERT INTO nou_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Edo Iesu kiki awa sedo atae etiri uso ambojimbi mi bugudo uso yei nganega isera, “Imo embo da yei ge sise ro awasedo imo inia ge mi sedo esi?” ");
INSERT INTO nou_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Setero Iesu mi mina sisira, “Mamo mi iji nonde unemi gitijigadira awa ingoda yei tu ge awa isaga etira awarate ungoda yei tu ge awa isaga aera. ");
INSERT INTO nou_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Embo ave uso jiro kotari nembodiba atirari gido re jiro kotari awa jingama ira Mamo mi uso yei jiro kotari nenei jiwae itadira. Edo embo awa jiro kotari embo are. Edo embo ave uso jiro kotari kiambu awa jingama ae edo ira awa Mamo mi embo ainda jiro kotari kiambu awa badira. ");
INSERT INTO nou_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na embo da yei ge inia da mi sena ainda be awa, ‘Ungoda diti awa pirigedo atira te ungo gae edo era edo ungoda dengoro awa pirigari rate ungo ingae edo era.’ ");
INSERT INTO nou_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Edo ge ro Mamo da binga sari embo Isaiah mi sisira awa be etira. Edo Isaiah mi sisira, ‘Ingo ingido ingido ewa te ingo kotae. Ingo gido gido ewa te ingo gae. ");
INSERT INTO nou_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Embomei einda jiro awa okain edo ungoda dengoro mi ro ingae edo ungoda diti awa ewo ditivi ira. Awarate ungo ungoda diti mi gosise edo ungoda dengoro mi ingise edo ungoda jiro mi kotadera awa ungoi naso yei da wareregadera. Edo ungoi naso yei wareregoro awa nanemi ungo ano ewamei adera.’” ");
INSERT INTO nou_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Edo Iesu ge awa uso ambojimbi da yei sedo sisira, “Awarate ingo awa isaga gosewa edo ewamei ingewa awasedo ingo awa awara atima ewa. ");
INSERT INTO nou_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ko na ingoda yei gebe sena binga sari embo jiwae de embo ewagaewa jiwae de ingo mi ro gosewa awa gadi dipapa isera te ungoi gae. Edo ungoi ingo ro ingewa awa ingadi dipapa isera te ungoi ingae.” ");
INSERT INTO nou_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Iesu mi uso ambojimbi da yei sisira, “Ingido gogo ewo na inia da mi ve gowari embo da ge setena ainda be awa ujugedo sano gave. ");
INSERT INTO nou_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Embo ave Mamo da gitijigari iji awa ingido edo be gae edo ira amone teta ve emboro da dudurisira awodo ra. Edo umo ge awa ingiri ainda amboda Satan mi bugudo uso joda ge awa sounbedo burisira. ");
INSERT INTO nou_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Edo embo ave ge awa ingido edo iji da amimi budo dubo ewamei edo ira awa teta ve ganuma tamo da dudurisira da awodo. ");
INSERT INTO nou_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Edo uso kotari awa teta besisi tutupo awodo. Edo umo ge ainda be awa edo gogo edo kotae edo ira awasedo Mamo da ge awa sedo dari gaiari uso yei buguri umo burigi be Mamo da emboro awa dodo ira. ");
INSERT INTO nou_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Edo embo ave Mamo da ge ingido ira te rora jiwae badi dipapa edo ira amone teta ve bebe da soropuda wosedo isira da awodo ko uso rora jiwae da dipapa edo ira edo wasiri einda dubo vevera amimi euri uso joda ge awa atae ambudo ira. ");
INSERT INTO nou_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Edo embo ave Mamo da ge ingido edo gebe edo era amone teta ve yei busu ewamei da durido isira awodo ungoi ge awa atopapotise Mamo da buro edo era. Edo embo nenei Mamo da buro nembogambo edo era amimi embo 100 awodo kondade eoro Mamo gido era. Edo embo nenei Mamo da buro nei kiambu nembogambo edo era amimi kondade eoro embo 60 awodo Mamo gido era. Edo nenei awa buro kiambu Mamo awasedo eoro embo 30 awodo awa Mamo gido era.” ");
INSERT INTO nou_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Edo Iesu inia ge mi kiki nei sisira, “Mamo da gitijigari iji awa teta embo mi uso buro da pisa ve gowarago adira. ");
INSERT INTO nou_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Edo ve govetiri tumba de embo berari evero gitopo embo mi bugudo pisa teda vive govedo edo umo mambusira. ");
INSERT INTO nou_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Edo amboda pisa erido edo be adi tuturo isira. Edo vive awa teta pisa inge edo daedo eririsira. ");
INSERT INTO nou_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Edo embo ainda buro ari embo mi bugudo uso yei sisera, ‘Gitijigari imo iso buro da ve ewamei gowusesa. Edo ro awasedo vive eiawa daedo erereri?’ ");
INSERT INTO nou_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Setero embo mina sisira, ‘Gitopo mi eiedo etera.’ “Setiri buro embomei mi uso yei sedo gosisera, ‘Imo vive awa sokorase dipapa esi ta?’ ");
INSERT INTO nou_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Setero embo amimi mina sisira, “Awodo aera mana vive awa sokadewa ko awodo ise pisa nenei de daedo sokadewa awasedo dowo. ");
INSERT INTO nou_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pisa de vive de dada erore. Edo erido sari oro awawa nanemi buro ari embomei da yei sane giti awa vive awa sokedo dada digiwo edo riawo da pigave. Edo ingo vive awa ri da pigedo awa pisa awa dada edo budo naso indari atari yei da itave.’” ");
INSERT INTO nou_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Edo Iesu mi inia ge mi kiki nei ungoda yei sisira, “Mamo da gitijigari da iji amone teta ri ve jawo mustard inge awa embo mi uso buro da govedo era da awodo. ");
INSERT INTO nou_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Edo ve eiawa ve nembogambo nenei awodo ae amone kiambu be rate ri awa erido ri nembodiba be nembodiba euri ri memei mi uso patu da ungoda ngaja itido era.” ");
INSERT INTO nou_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Edo Iesu inia ge mi kiki nei ungoda yei sisira, “Mamo da gitijigari iji amone teta evetu mi ambe bajari siwo jawo yeast sedo era awa budo ambe de da jigido ira. Edo evetu awodo euri siwo yeast mi ambe awa euri bajido ingari katogo euri riawo da ingedo ira.” ");
INSERT INTO nou_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Edo Iesu inia ge mi embo ainda dada isera awa atopapotisira. Edo Iesu ungoda yei ge nei mi sae rate ungoda yei inia ge mi sedo isira. ");
INSERT INTO nou_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Edo Iesu ge eiedo sedo isira amimi ro Mamo da binga sari embo mi sisira awa be edo isira. Edo binga sari embo mi sisira, “Na ungoda yei ge sadena awa inia da mi sadena. Edo tuturo da Mamo mi utu de busu de isira iji ainde edo bugudo boroko da einde da kotari embo nenei mi gae awa nanemi boroko ungoda yei isaga adena.” ");
INSERT INTO nou_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Edo Iesu nga dodo wosedo edo embo jiwae be awa dodo mando joda vivitisira. Etiri uso ambojimbi mi uso yei da bugudo nganega isira edo sisera, “Inia da mi pisa de vive de da setesa ainda be awa ujuge gore.” ");
INSERT INTO nou_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Setero Iesu mi mina sisira, “Embo ve ewamei gowusira amone Mamo da mei mi busu da wosedo embo isira awa ra. ");
INSERT INTO nou_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Edo buro amone busu eire. Edo ve ewamei amone Mamo da embomei Mamo ga da gitijigadera awa ra. Edo vive amone Satan da embomei awa ra. ");
INSERT INTO nou_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Edo gitopo mi vive gowusera amone Satan awa ra. Edo pisa sari ari iji amone busu eiawa atae adira iji awa ra. Edo buro ari embomei amone asisi ewagaewa awa ra. ");
INSERT INTO nou_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Edo embo mi vive sokedo ri da pigoro evedo era da awodo awa iji amboda adira. ");
INSERT INTO nou_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Edo ainde Mamo da mei busu da bugudo embo isira amimi uso asisi ewagaewa itari bugudo asisi ewagaewa amimi embo wasiri biae ise eoro embo nenei wasiri biae edo era embobo awa tambudo asisi ewagaewa mi embomei eiawa Mamo da embo Mamo gada gitijigadera ainda teda budo pigoro riawo matawa atari da ewadera. ");
INSERT INTO nou_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Edo embo bebegae eiawa riawo matawa atari da atise awa ungoi ji sise di gambuse atadera. ");
INSERT INTO nou_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Edo Mamo mi gitijigadira ainde awa uso embomei awa waiko mi janibarago adera. Edo ingo embomei dengoro de ra ingido gogo ewo.” ");
INSERT INTO nou_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Edo Iesu inia da mi sisira, “Eiawa Mamo da gitijigari da iji da awodo. Embo da amimi busu ngambedo gano jiwae be gowusira. Edo embo nei mi busu awa ngambuko gano awa tambusira te sekago govedo embo awa mambudo dubo ewamei de iaviri ise uso rora berari awa ori isira. Edo engenembedo mambudo busu awa mina itido burisira.” ");
INSERT INTO nou_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Edo Iesu ge awa atae edo inia da mi ge nei sisira, “Mamo da gitijigari iji awa teta embo da mi nati da ingo ove ewamei awa mina itido ari dipapa edo gido yei berari da eura isira. ");
INSERT INTO nou_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iko nati da ingo ove da ainda mina awa nembodiba awa tambudo gido mambudo uso rora berari awa ori ise edo engenembedo mambudo nati da ingo ove uso mina nembodiba awa mina itido burisira.” ");
INSERT INTO nou_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Edo Iesu ge awa atae edo inia da mi ge nei sisira, “Eiawa Mamo da gitijigari da iji da awodo. Embo mi komboro ewa da wo badi pigisera. ");
INSERT INTO nou_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Edo komboro awa wo neinde kainde mi beda etiri edo oiro embo mi komboro awa jumbero ombo da vitiri edo oiro embo anumbedo wo awa katabadera. Katabedo wo indari ewamei awa ungoda kandea da ititise edo indapu awa wawara oro mambadera. ");
INSERT INTO nou_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Da awodo utu de busu de atae adira ainde asisi ewagaewa mi wosedo embo bebegae de ewagaewa de awa katabadera. ");
INSERT INTO nou_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Edo katabedo atae edo asisi ewagaewa mi embo bebegae awa riawo matawa atari da pigoro ainda atise embo bebegae mi ungoda di gambuse ji de atadera.” ");
INSERT INTO nou_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Edo Iesu inia da mi kiki sisira awa atae edo ungoda yei nganega isira, “Ingo kiki ainda be mo gosevita?” Setiri ungoi mina sisera, “En nango gosera.” ");
INSERT INTO nou_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Setero Iesu mi mina sisira, “Moses da agodari da atopatari awa Mamo da gitijigadira iji ainda gari seka awa budo edo jiro gari seka de jiro gari matu de awa atopapotira.” ");
INSERT INTO nou_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Edo Iesu inia da mi kiki sisira awa atae edo yei awa dodo umo engenembedo uso nati topo da mambusira. ");
INSERT INTO nou_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Edo ainda mambudo Iesu Jew embobo da dada ari yei da mambudo embo atopapotisira. Atopapotiri ingido embo mi be gido jarisera edo sisera, “Jiro gari edo kotari nembodiba eiawa nonda burisiri? Edo wasiri ewagaewa eiawa rawodo iri? ");
INSERT INTO nou_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Umone ri mi buro ari embo da mei ra edo uso ai re Mary ra edo James de Joseph de Simon de Judas de re uso nanonamendi ra. ");
INSERT INTO nou_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Edo uso ru aimono ne nati da atima era.” ");
INSERT INTO nou_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Awasedo ungoi tini gambari edo ungoi Iesu ujo ae isera. Edo ungoi Iesu da yei awodo etero Iesu mi ungoda yei sisera, “Yei berari da embomei awa binga sari embo awa sapo edo era awarate binga sari embo da nati da embobo de uso orobe de awa umo sapo ae edo era.” ");
INSERT INTO nou_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Edo Iesu ge awodo sedo edo sekago wasiri ewagaewa nembogambo nenei awa ae doturisira ainda be awa embo ainda mi umo gebe ae isera awasedo. ");
INSERT INTO nou_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Iji ainde Herod Galilee busu simba edo isira amimi Iesu ro ira awa binga ingisira. ");
INSERT INTO nou_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ingido uso gitijijigegari nenei da yei sisira, “Embo eiawa John umo mi ewamei ari embo umo betedo erido bugira awodo da umo goroba budo ari wasiri goroba de awa ira.” ");
INSERT INTO nou_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Iji nei giti da awa Herod mi setiri ungoi John budo bundedo budo gajari oro da ititisera. Edo Herod mi uso namendi Philip da aro Herodias awa bengono isira awarate John mi iji berari Herod da yei sedo isira, “Namendi da aro awodo burisesa amone biae ra awasedo doio.” Edo John umo iji berari awodo seuri Philip da aro Herodias awa tini gambari edo Herod iji berari bagedo isira awasedo Herod mi setiri ungoi John budo doro betarase sedo gajari oro da ititisera. ");
INSERT INTO nou_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Edo Jew embo berari kotedo isera John awa binga sari embo awasedo Herod ungo oju edo John dae betae doturisira. ");
INSERT INTO nou_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Amboda Herod da kumbari iji bugiri umo bondo nembodiba sia isira. Etiri embo jiwae be bugusera. Edo bugero Herodias da gagara mi ungoda teda ya diwusira. ");
INSERT INTO nou_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Etiri Herod dubo ewamei edo jo iaviri ise gagara ainda yei sisira, “Ro naso yei da dipapa adesa awa na iso yei da adi adi sari sena nanemi iso yei itadena.” ");
INSERT INTO nou_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Edo Herod awodo setiri gagara uso ai Herodias mi ro sadira awa sisira. Setiri gagara mi Herod da yei sisira, “John umo mi ewamei ari embo da kopiri awa tewo da itido naso itio bane.” ");
INSERT INTO nou_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Setiri gitijigari nembodiba awa dubo vevera isira. ");
INSERT INTO nou_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Awarate Herod umo adi sari sisira awa embo berari uso ge awa ingisera awasedo John umo gajari oro da atiri Herod mi ge setiri ungoi uso koma kausugurisera. ");
INSERT INTO nou_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kausugedo ungoi tewo da itido budo torido ungoi gagara ainda ititisera. Itero gagara amimi budo uso ai da yei mambudo ai da ititisira. ");
INSERT INTO nou_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Edo John da ambojimbi mi gajari oro da mambudo John da tamo budo mambudo gowusera. Govedo mambudo Iesu setero gosisira. ");
INSERT INTO nou_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Edo Iesu binga awa ingido yei awa dodo umo umosuka nga da vitido yei embo atae da mambusira. Awarate embomei mi ge awa ingido nati awa dodo tei mi umo bengi da awodo pepeta edo yei Iesu mambutira ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Edo Iesu yei ainda mambudo nga dodo wosedo embo diti nembodiba gosisira. Gido Iesu embomei awa jo isira. Etiri ungoda karu amburo embomei ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Edo ongobo edo piri Iesu da ambojimbi mi uso yei sisira, “Yei eiawa ro atae ra edo daedo ongobo ira awasedo embomei eiawa itio mambudo nati da indari mina itido indore.” ");
INSERT INTO nou_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Setero Iesu mi mina sisira, “Ro awasedo na ungo itano mamberi? Ingo mi indari itiwo indore.” ");
INSERT INTO nou_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Setiri ungoi Iesu da yei sisera, “Nangoda indari kiambu be atira ambe ingari 5 edo wo kiambu etoto de amimi atira.” ");
INSERT INTO nou_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Setero Iesu mi ungoda yei sisira, “Indari awa naso yei budo pou.” ");
INSERT INTO nou_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sedo Iesu setiri embomei awa sasawa da anumburisera. Anumbetero Iesu ambe ingari 5 de wo etoto de awa ingo mi kumbudo diti utu inda edo Mamo da yei ategari ititisisira. Ategari sedo atae edo Iesu ambe awa gavedo memeia edo uso ambojimbi da yei ititisira. Edo Iesu mi ambe gavedo uso ambojimbi da ititisira awa ungoi budo ambe awa embomei da yei ititisera. Edo ungoi ambe awa itero embomei mi indari awa indido inono be isera. ");
INSERT INTO nou_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Edo ungoi indido atae etero indari buso awa dada edo kandea 12 awodo beda isira. ");
INSERT INTO nou_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Edo embo indari awa indisera ainda ajigari awa 5,000 awodo. Edo daedo evetu de kinapeina de indari awa indisera. ");
INSERT INTO nou_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Edo Iesu mi setiri uso ambojimbi nga da vitido giti umo diuga da sembusera. Edo ungo sembutero Iesu embomei itiri mambutero Iesu umo umosuka doriri da Mamo ga da ge sadi vivitisira. ");
INSERT INTO nou_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Edo tumba jijiriri Iesu umo umosuka ainda atisira. ");
INSERT INTO nou_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Edo Iesu ainda atiri nga awa umo soropuda mambusira. Mambiri edo bisi bisara de edo umo diuga de awa teta ewa yawata ise arago edo amimi nga awa budo vitido wosedo benei da sembari katogo ae isira. ");
INSERT INTO nou_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Edo sipo tu busedo piri Iesu umo tamo da pepeta edo uso ambojimbi da yei asusubedo bugusira. ");
INSERT INTO nou_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Edo uso ambojimbi Iesu umo tamo da pepeta iri gido ungo oju mi biae isera edo gogo dimbudo sisera, “Asisi ra.” ");
INSERT INTO nou_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Setero Iesu ungoda yei ge sisira, “Goroba ewo. Oju eove. Amone namona.” ");
INSERT INTO nou_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Setiri Peter mi sisira, “Gitijigari imo be gadera awa ge segae edo na umo tamo da pepeta edo iso yei yane.” ");
INSERT INTO nou_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Setiri Iesu mi sisira, “Puio.” Setiri Peter nga dodo wosedo umo tamo da pepeta edo Iesu da yei mambusira. ");
INSERT INTO nou_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Awarate pepeta ise bisara kiambu ae gido Peter oju isira. Oju edo umo kununubadi isira. Kununuburise Peter Iesu da yei gogo dimbudo sisira, “Bada na kondade e.” ");
INSERT INTO nou_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Setiri Iesu burigi be ingo kerere edo Peter da ingo da budo Peter da yei sisira, “Imo tumonda ari kiambu embo ro awasedo imo na tumonda ae etesi? ");
INSERT INTO nou_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sedo ungo etoto nga da vivitisera. ");
INSERT INTO nou_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Vitero bisara atae isira awasedo ambojimbi nga da mi Iesu tumondebain edo Iesu da yei sisera, “Gebe imo awa Mamo da mei.” ");
INSERT INTO nou_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Edo umo diuga awa sembudo busu Gennesaret umo bengi da vivitisera. Edo ainda bugero embomei ainda awa Iesu awa gari awasedo binga Iesu bugira awa embo berari da yei itero mambusira. ");
INSERT INTO nou_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Edo binga awa ingido ungoi karu embomei budo Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Budo bugudo ungoi Iesu da yei sedo gosisera, “Karu embomei mi uso ombari begiti jigadera awa imo ungo ondose.” Awa setero embo amemi Iesu da ombari begiti jigido isera awa embo awa ewamei edo isera. ");
INSERT INTO nou_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Edo Pharisee embo nenei de agodari da atopapotegari embo nenei mi Jerusalem dodo Iesu da yei bugudo sedo gosisera, “Ro awasedo iso ambojimbi ingodenaso mamoumbogo da atopatari awa kera ae edo eri? Ko ungo indari indae giti da awa ingodenaso agodari da ingo segari awa ambo ambo ae edo era.” ");
INSERT INTO nou_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Setero Iesu mi mina sisira, “Edo ingo ingoda mamoumbogo da atopatari awa ingido ewa awa ro awasedo ingo Mamo da agodari awa kera ae edo evi? ");
INSERT INTO nou_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Edo Mamo mi sisira aimamo iso sapo eio. Edo embo amemi uso aimamo da yei biae sadira awa embo mi dadera sisira. ");
INSERT INTO nou_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Edo ingo re eiawa atopapotewa embo da uso kando atadira gido kando awa aimamono da yei itae dodo Mamo da yei itadira. ");
INSERT INTO nou_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Eiedo ise embo awa uso aimamo simba ae sumbae edo ira awa awara sewa. Edo ingo atopatari eiedo ise ingo ingoda mamoumbogo da ari awa Mamo da agodari da tamo da ititewa. ");
INSERT INTO nou_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","8","Ingo ise sarago ari embobo Isaiah gebe sisira Mamo mi ro ingoda jawo da sira awa sisira, ‘Embomei eiawa tepo ge mi na sapo edo era te ungoda jo mi na sapo aera. ");
INSERT INTO nou_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Edo na tumondebain awodo edo era ainda joda be atae ra ainda be awa ungo ungoda mamoumbogo da wasiri da awa atopatido era.’” ");
INSERT INTO nou_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Edo Iesu mi ge setiri embo jiwae be bugutero ainda yei sisira, “Naso ge ingido edo gido gogo ewo. ");
INSERT INTO nou_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ro embo da be da mambutira amimi ae embo awa embo biae aera te ro embo da joda edo bugutira edo embo amimi be mi sira amimi iri embo awa embo biae ira.” ");
INSERT INTO nou_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Setiri ainda amboda Iesu da ambojimbi uso yei bugudo Iesu da yei sisera, “Pharisee embomei ge setesa awa ingido ainda amboda ungo awa ujo ae etera awa imo gosesita?” ");
INSERT INTO nou_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Setero Iesu mi mina sisira, “Rive berari naso Mama utu da amimi gowae awa embo mi sokadera. ");
INSERT INTO nou_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Edo embomei awa dowo. Ungo awa gitijijigegari diti ambubura. Edo diti guba ari embo nei mi diti guba ari embo nei awa gitijigadira amone embo etoto emone mambudo koto ngambari nembodiba da wosadera.” ");
INSERT INTO nou_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Setiri Peter mi sisira, “Nangoda yei ge ingari sago ae ainda be awa ujuge gore.” ");
INSERT INTO nou_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Setiri Iesu mina sisira, “Iso jiro okain embo nenei da da awodo ta?” ");
INSERT INTO nou_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","18","Imo gosesita ro embo da be da torido ira awa mambudo embo da tini da edo ijegedo ira awarate embo da joda kotari awa be mi sira emimi euri embo wasiri biae edo ira. ");
INSERT INTO nou_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Edo kotari bebegae jiwae joda edo bugutera amimi embo dadira edo viro bengaba adira edo bengono adira edo gebusadira edo embo nei bekuba adira edo wasiri bebegae nenei jiwae adira. ");
INSERT INTO nou_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Edo kotari biae amimi ari embo wasiri biae adira awarate ingo segari wasiri amimi ari ae mana embo wasiri biae awa mana adira.” ");
INSERT INTO nou_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Edo Iesu yei awa dodo mambudo busu nati Tyre de Sidon de da demo da ainda bugusira. ");
INSERT INTO nou_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Edo Iesu ainda bugiri Cana evetu busu ainda atinatina amimi Iesu da yei bugudo sisira, “Bada David da orobe na jo egae ko asisi biae mi naso gagara da joda atise amimi euri gagara atari biae atima ira.” ");
INSERT INTO nou_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sisira te Iesu evetu ainda ge mina sae. Etiri uso ambojimbi uso yei bugudo sedo gosisera, “Evetu eiawa ingodena ambo ambo ise ingodenaso yei gogo dimbira awasedo evetu oiawa itiu mambare.” ");
INSERT INTO nou_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Setero Iesu mi sisira, “Mamo mi na awa Israel embomei teta wo sheep mi jajovegari inge edo atima era ainda yei itiri bugusena awarate umo na embo Israel embo ae ainda yei itae bugaera.” ");
INSERT INTO nou_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Awa setiri evetu bugudo Iesu da jo da baingo dederi edo Iesu da yei sisira, “Gitijigari na kondade egae.” ");
INSERT INTO nou_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Setiri Iesu mi mina sisira, “Embo mi kinapeina da indari awa budo mana sino da itadira.” ");
INSERT INTO nou_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Setiri evetu mi mina sisira, “Gitijigari gebe setesa awarate indari momono mamo da tewo da edo busu da wosedo ira amone sino mi indadira amone awara.” ");
INSERT INTO nou_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Setiri Iesu mi evetu da yei mina sisira, “Evetu gebe setesa edo tumonda ari nembogo etesa awasedo imo ro dipapa esa awa adena.” Setiri edo iji da ainde evetu ainda gagara awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Edo yei awa dodo Iesu pepeta edo Galilee umo bengi da awodo mambudo doriri da vitido anumburisira. ");
INSERT INTO nou_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Anumbetiri embo jiwae be mi Iesu da yei tei ingo ambari de diti guba ari de tei ingo ambari de ge segeregae de edo karu embo nenei jiwae deda budo bugusera. Bugudo embomei eiawa Iesu da jo da itero Iesu mi berari ewamei isera. ");
INSERT INTO nou_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Edo Iesu ungo ewamei etero ge segeregae ge sera edo tei ambari pepeta era edo ingo ambari ewamei isera edo diti guba ari yei gosisera. Edo ungoi awodo etero embo berari mi awa be gido jarisera edo gido ungoi Israel embomei da Mamo awa jasiga isera. ");
INSERT INTO nou_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Edo Iesu mi setiri uso ambojimbi uso yei bugero Iesu ungoda yei sisira, “Embomei eiawa nangae atise iji tamonde atae etera edo indari atae etera awasedo na ungo jo ira. Edo indari itae dodo ungo itano mambadera edo ungo pepeta edo mambuse awa ambadera awasedo na ungo mana itano mambadera.” ");
INSERT INTO nou_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Setiri Iesu da ambojimbi mi uso yei sisera, “Yei ro atae einda nango indari embo berari eiawa embo nonda indari inono budo embomei eiawa underi?” ");
INSERT INTO nou_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Setero Iesu ungoda yei sedo gosisira, “Ingoda yei ambe ingari roinge atiri?” Setiri ungoi mina sisera, “Nango da yei ambe ingari 7 edo wo memeia de ra.” ");
INSERT INTO nou_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Setero Iesu mi setiri embo berari anumburisera. ");
INSERT INTO nou_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Anumbetero Iesu ambe ingari 7 edo wo de awa Mamo da yei ategari ititisira. Ategari itido Iesu mi ambe de wo de awa gavedo memeia edo memeia itido isira awa ambojimbi da itiri ambojimbi mi embo da yei itido isera. ");
INSERT INTO nou_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Itero embo berari mi indido embo inono be isera. Edo ungoi indido atae etero indari buso doturisera awa ambojimbi mi dada isera edo kandea 7 awodo awa beda isera. ");
INSERT INTO nou_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Edo embo indari awa indisera ainda ajigari awa 4,000 edo emboevetu de kinapeina de indari indisera awa ajigae. ");
INSERT INTO nou_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Edo Iesu embomei itiri mambusera. Mambudo Iesu nga da vitido nati Magada busu ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Edo Iesu ainda bugutiri edo Pharisee de Sadducee embomei de mi uso yei da bugusera. Bugudo Iesu bagedo gadi isera edo ungoi Iesu da yei wasiri Mamo da goroba mi ungoda yei arase sisera ainda be awa Iesu mi awodo adira amimi ungo gadera awa Mamo mi Iesu itiri bugusira awa gadera sisera. ");
INSERT INTO nou_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Awarate ungoi awa setero Iesu mi ungoda yei mina sisira, “Waiko wowoseuri ongobo euri ingo sedo ewa euma awa yei ewamei adira ainda be awa poroga awa kokoi etira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Edo sipo de erido ingo sedo ewa yei umenga etira awasedo ga dadira sedo ewa. Edo ingo utu da iwata awa ewamei gido ewa awarate ingo iwata Mamo mi busu atae adira ainda ititira awa ingo gae jarewa. ");
INSERT INTO nou_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Embo boroko atera awa embo bebegae edo ungo Mamo dubo bae. Edo ingo nanemi ari wasiri goroba de anase sedo gosewa te mana adena. Mamo mi ari wasiri goroba de awa adira teta ari Jonah da isira awodo edo ari awa ingo mi gadewa awarate nanemi nei mana adena.” Edo Iesu awa sedo ungo dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Edo ambojimbi mi umo diuga da sembusera awarate ungoi ambe nenei bae ruvegurisera. ");
INSERT INTO nou_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Etero Iesu mi ungoda yei sisira, “Pharisee de Sadducee embomei da ambe bajari siwo jawo yeast awa jinjibewo.” ");
INSERT INTO nou_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Setiri edo ambojimbi ungosuka ge ainda be ro ri awa eura isera edo sisera, “Iesu ge awa setira ainda be awa ingodena ambe bae bugera awasedo.” ");
INSERT INTO nou_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Edo ungo awa sero Iesu ungo ro sera awa gido ungoda yei sedo gosisira, “Ro awasedo ingo ingosuka ambe bae bugewa awasedo ge mina sara evi? Ingo awa embo da embo ingoda tumonda ari awa kiambu ra. ");
INSERT INTO nou_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ingo naso ge ainda be awa gadi jarewa. Edo ambe ingari 5 mi embo 5,000 awodo undutana amomo ingo mo ruvegetevita? Edo kandea roinge awa indari buso mi siritavi? ");
INSERT INTO nou_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Edo ingo kotevita ainda amboda ambe ingari 7 mi embo 4,000 awodo awa nanemi undetena mo gosevita? Edo iji ainde indari buso mi kandea roinge siritavi? ");
INSERT INTO nou_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na ingoda yei ambe da ge saera mo ro awasedo ingo gadi jarevi? Pharisee de Sadducee embomei da ambe bajari siwo jawo yeast awa jinjibewo.” ");
INSERT INTO nou_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Setiri edo uso ambojimbi gosisera ko Iesu awa ambe bajari jawo yeast awa jinjiborase saera te Iesu awa ungoda yei sisira Pharisee de Sadducee embomei da atopatari awa teta ambe bajari siwo jawo yeast mi rawarago ira awa jinjiborase sisira. ");
INSERT INTO nou_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Amboda Iesu busu Caesarea Philippi demonda ainda bugusira. Ainda bugudo Iesu uso ambojimbi da yei sisira, “Embo mi na Mamo da mei busu da bugudo embo isena awa ave sedo eri?” ");
INSERT INTO nou_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Setiri ungoi mina sisera, “Embo nenei sedo era John umo mi ewamei ari embo edo nenei sedo era Elijah edo nenei sedo era Jeremiah o Mamo da binga sari embo nenei awodo sedo era.” ");
INSERT INTO nou_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Setero Iesu ungoda yei sedo gosisira, “Edo ingo na awa ave sedo evi?” ");
INSERT INTO nou_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Setiri Simon Peter mi sisira, “Imo awa Soregari Embo Mamo mi itari bugarase sisira Mamo natopo atari da mei.” ");
INSERT INTO nou_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Setiri Iesu mi mina sisira, “Simon Jonah da mei Mamo mi imo ewamei be etira. Edo embo nei mi gebe awa iso yei saera te naso Mama utu da atima ira amimi iso yei setira awasedo na iso yei sena imo awa Peter edo iso jawo ainda be awa ganuma. ");
INSERT INTO nou_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Edo ganuma einda tamo da nanemi naso gebe ari embomei awa itadena. Itano betari matawa atari da goroba mi mana ari duradera. ");
INSERT INTO nou_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Edo nanemi Mamo da atari yei da mangiro pirigari rora awa iso yei itadena. Emboro busu da rawa gajadesa da awodo Mamo mi utu da emboro gajadira. Emboro busu da rawa gajadi ae da awodo Mamo mi utu da gajadi aera. ");
INSERT INTO nou_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Awa sedo Iesu mi ambojimbi da yei sisira, “Na Soregari Embo Mamo mi itari bugarase sisira awa embo nenei da yei sawo geore.” ");
INSERT INTO nou_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Edo iji ainda edo Iesu uso ambojimbi isaga da atopapotise ungoda yei sisira, “Na Jerusalem da mambadena ainde awa Jew embomei da gitijijigegari de Priest da gitijijigegari edo agodari atopatari embomei mi oro na memesi nembodiba be badena. Edo ungoi awodo na doro betadena awarate iji tamonde atae ari Mamo mi na awa betari da edo jigari sekago wasiri de eradena.” ");
INSERT INTO nou_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Awodo setiri Peter mi Iesu budo demonda yiko Iesu da yei sisira, “Kotari biae awa do. Na wasiri awodo awa iso yei ijegeurase ujo ae ena.” ");
INSERT INTO nou_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Setiri Iesu wareregedo Peter da yei sisira, “Satan imo naso buro awa beitiguresa awasedo na dodo mambuio. Edo imo awa embo da kotari awa kotesa te Mamo da kotari awa kotaera.” ");
INSERT INTO nou_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Awasedo Iesu mi uso ambojimbi da yei sisira, “Embo ave na ambo ambo ari dipapa edo gido re dowo uso dipapa berari awa dodo edo orega uso awa budo na ambo ambo are. ");
INSERT INTO nou_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Edo embo ave betari oju ise kakana ira awa amboda betadira awarate embo ave na awasedo betadira awa natopo atadira. ");
INSERT INTO nou_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Edo embo ave busu da rora berari awa badira te wasiri natopo atari awa bae adira amone biae be ra. Edo embo da rawa mi mana uso asisi da natopo atari awa rora mi mana mina itido badira. ");
INSERT INTO nou_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Edo na Mamo da mei bugudo embo isena awa naso asisi ewagaewa de edo Mamo da goroba ewamei de mi jinenebari mi bugadena. Awodo bugudo embo dada ungo ro isera ainda mina awa itadena. ");
INSERT INTO nou_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Edo kotembewo embo nenei boroko einda derido atera awa ungoi na Mamo da mei embo isena awa gitijigadi bugutinono gadera. Gido amboda ungo betadera awarate giti gadera.” ");
INSERT INTO nou_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iji 6 atae etiri Iesu Peter de nanonamendi etoto James de John de budo daedo doriri inda ungo ungosuka vivitisera. ");
INSERT INTO nou_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Edo ungoi Iesu ditini ero Iesu dombu nei isira. Edo uso dombu teta waiko mi janibarago isira edo uso bosini awa teta poroga parara inge isira. ");
INSERT INTO nou_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Edo wasiri eiawa ijegetiri ambojimbi tamonde mi Moses de Elijah de awa Iesu ga ge sero gosisera. ");
INSERT INTO nou_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Gido Peter mi Iesu da yei sisira, “Gitijigari na dubo ewamei ena ingodena einda atera awasedo. Edo imo dipapa adesa awa nanemi boga tamonde adena imo da Moses da edo Elijah da.” ");
INSERT INTO nou_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Edo Peter umo ge awa sise atiri poroga parara mi ungo dogisira. Edo ge poroga da awodo bugudo sisira, “Emone naso mei na awa na dubo burena. Na uso yei iaviri ena awasedo uso ge ingiwo.” ");
INSERT INTO nou_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Edo ambojimbi ge awa ingido oju edo gido dombu mi busu da paposisera. ");
INSERT INTO nou_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Edo pasetero Iesu ungoda yei bugudo sisira, “Oju eove ta eriwo.” ");
INSERT INTO nou_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Setiri ambojimbi diti inda edo Iesu gosisera awarate ungo embo nenei gae. ");
INSERT INTO nou_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Edo ungo doriri da edo wowosero Iesu mi ungoda yei sisira, “Ingo ro getewa awa embo nenei da yei seove. Amboda na Mamo da mei embo isena awa betedo eradena ainde awa sadewa.” ");
INSERT INTO nou_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Edo Iesu awa setiri uso ambojimbi uso yei sedo gosisera, “Ro awasedo agodari da atopapotegari embomei mi siseri Elijah awa giti bugadira siseri?” ");
INSERT INTO nou_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Setero Iesu mi mina sisira, “Gebe Elijah giti bugari rora berari awa sia adira awarate umo bugusira awa embo mi umo gae awasedo uso yei wasiri bebegae isera da awodo embo mi na Mamo da mei busu da bugudo embo isena ainda yei biae adera ko ungo na gae awasedo. ");
INSERT INTO nou_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Edo Iesu ge awa setiri uso ambojimbi mi umo John umo mi ewamei ari embo da ge setira awa gosisera. ");
INSERT INTO nou_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Edo ungoi engenembedo embo jiwae be da yei mambero embo da amimi Iesu da yei bugudo jo da baingo dederi edo sisira, “Gitijigari naso mei jo egae. Naso mei awa jiro biae awasedo umo iji dada riawo da edo umo da wosedo ira. ");
INSERT INTO nou_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Edo na naso mei budo iso ambojimbi da yei bugena te ungoi naso mei ari ewamei ari sago ae etera.” ");
INSERT INTO nou_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Setiri Iesu mi mina sisira, “Ingo awa jiro okain embomei. Na iji roinge ingo awa embo eni? Mei awa budo naso yei pou.” ");
INSERT INTO nou_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sedo Iesu mi ge asisi biae da yei setiri asisi biae ijegetiri iji ainde mei awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Edo Iesu da ambojimbi mi ungo ungosuka bugudo Iesu da yei nganega isera, “Ro awasedo nango asisi biae mei kiambu da joda awa ro embo ondae wosae eteri?” ");
INSERT INTO nou_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Setero Iesu mi mina sisira, “Ingoda gebe ari awa atae ra awasedo ingo asisi biae ondae wosae etewa. Edo na ingoda yei gebe sena awasedo ingiwo. Ingo ingoda gebe ari awa kiambu teta ve kiambu jawo mustard awodo awa ingo mi doriri einda sae etewa erido ounda mambu sae etewa awa doriri awa mambae etira. Edo ingo mi rora neinde kainde ae etewa. Edo Mamo ga daedo ge sae etewa edo neta ae etewa amimi ari ingo asisi bebegae nenei awa ondawo ijegae etera. ");
INSERT INTO nou_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Awarate ingo Mamo ga da ge sae edo neta ae awa ingo mi mana asisi bebegae awa mana ondae etewa.” ");
INSERT INTO nou_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Edo iji tupo Iesu da ambojimbi Iesu ga Galilee busu da dada etero Iesu mi ungoda yei sisira, “Iji bugutira ainde embo mi na Mamo da mei bugudo embo isena awa ungo mi embo na doro betadena ainda ingo da na itadera. ");
INSERT INTO nou_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Awarate ungoi doro iji tamonde atae ari unemi sekago eradira.” Awa setiri uso ambojimbi dubo vevera isera. ");
INSERT INTO nou_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Edo Iesu uso ambojimbi de Capernaum nati da bugusera. Bugero Jew embomei da tumondebain ari oro da tax bari embo mi bugudo Peter da yei sisera, “Iso atopatari tumondebain ari oro da tax itido ita?” ");
INSERT INTO nou_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Setero Peter mi sisira, “En umo itido ira.” Sedo mando joda totorisira. Etiri Iesu mi ge giti sisira, “Simon imo ro kotesi? Gitijigari embo nembodiba da kinapeina mi uso yei tax gano itido eri ta embo nenei mi uso yei tax gano uso yei itido eri?” ");
INSERT INTO nou_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Setiri Peter mi mina sisira, “Embo nenei mi tax gano uso yei itido era.” Setiri Iesu mi mina sisira, “Gebe mei uso mamo da yei tax gano itae edo ira. ");
INSERT INTO nou_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Awarate ingae na mana ano embo tini gambari eorase ujo ae era awasedo ingae itadena. Imo umo diuga da mambudo guti pigeio. Edo wo giti dimbadesa ainda joda awa gano tambadesa. Edo gano badesa amone imo de namo da Jew embomei da tumondebain ari oro da tax itari inono ra gio. Edo gano awa budo mambudo tax bari embo da yei itio bore. ");
INSERT INTO nou_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iji nei Iesu da ambojimbi mi bugudo uso yei sisera, “Mamo atima ira yei ainda mo embo ave awa nembogo ri?” ");
INSERT INTO nou_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Setero Iesu mi setiri mei kiambu bugudo Iesu da jo da dederisira. ");
INSERT INTO nou_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Derido atiri Iesu uso ambojimbi da yei sisira, “Ingo nei edo tetakinapeina memeia inge ae adewa awa imo mana Mamo da atari yei da toradewa. ");
INSERT INTO nou_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Edo embo ave saboa edo mei kiambu inge adira amone Mamo da atari yei ainda umo embo nembodiba adira. ");
INSERT INTO nou_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Edo embo ave mei kiambu naso jawo da awa kondade adira awa embo awa na kondade ira. ");
INSERT INTO nou_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Iesu mi sisira, “Embo amemi ari mei kiambu na gebe ira awa na dodo wareregadira awa wasiri biae adira. Embo awa wasiri biae awa ae giti da awa embo mi ganuma nembodiba awa embo ainda dubo da kikivi edo ewa kapuru da pigadera awa uso yei awa ewamei. Awarate embo awa atise wasiri biae awa adira awa embo ainda yei awa biae be ra. ");
INSERT INTO nou_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Edo wasiri bebegae busu berari da jiwae atira amimi euri embo ungoda gebe ari awa jajovegedo era awa biae be ra. Wasiri biae awa yei berari ijegedo ira awarate embo amemi euri wasiri biae awa bugudo ira awa embo ainda yei biae adira. ");
INSERT INTO nou_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Iso ingo ta tei mi ari wasiri biae edo re diugedo pigeio. Imo iso tei da ta ingo da ta awa diugedo pigedo utu da toradesa awa ewamei ra te iso ingo etoto de tei etoto de atadera edo ungoi pigoro riawo matawa atari da mambadesa awa biae ra. ");
INSERT INTO nou_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Imo iso diti mi ari wasiri biae edo re diti gurugedo budo pigeio. Edo imo iso diti da de utu da toradesa awa ewamei ra te iso diti etoto atadera edo ungoi pigoro riawo matawa atari da toradesa awa biae ra. ");
INSERT INTO nou_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Awasedo kinapeina memeia awa ujo ae eove. Ingido gogowo ewo. Ungoda asisi ewagaewa utu da awa iji berari naso Mamo da diti da atera. ");
INSERT INTO nou_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Edo Mamo da mei bugudo embo isira awa embo jajovegari awa soregadi bugusira. ");
INSERT INTO nou_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kotedo gogowo ewo. Embo da uso wo jawo sheep awa 100 edo da jajovegae etira awa ro ae etiri? Edo wo nenei 99 awa doriri da dodo mambae etira umo wo sheep jajovegetira awa eura adira. ");
INSERT INTO nou_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Edo ingoda yei sena umo eura ima tambudo dubo ewamei adira. Edo umo eura ima wo sheep da munenegurisira awa tambudo uso iaviri wo sheep 99 munenegae awa derigadira. ");
INSERT INTO nou_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Edo da awodo ingoda Mamo utu da atira awa kinapeina memeia da awa riawo mata awa ewuse atira ainda mamborase ujo ae edo ira.” ");
INSERT INTO nou_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iesu mi sisira, “Embo nei mi iso yei biae ari gido uso yei mambudo gae unjugari da ro etira awa ujugeio gare. Edo umo iso ge ingadira awa ingo sekago otao adewa. ");
INSERT INTO nou_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Awarate umo iso ge ingae adira awa embo da ta etoto awodo budo ingae embo ainda yei da mambuio edo sekago seio gare jiwari mi sira da awodo. Jiwari mi sira, ‘Embo ave embo nei bekuba ari gido embo etoto ta tamonde mi bekuba ge sera da awodo awa soro kasari embo mi gadira bekuba ge sera awa gebe ra.’ ");
INSERT INTO nou_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ungo embo ainda ge sadera awa awarate embo awa ungoda ge ingae adira awa gebe ari embomei dada oro ainda edo gogowo edo seio gore. Saso ungoi embo ainda yei ge sore awarate umo ungoda ge ingae adira awa demonda itiwo wosare. Awodo ise umo teta aumo o tax bari embo awodo jijipo eio. ");
INSERT INTO nou_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na ingoda yei gebe sena awasedo ingido gogowo ewo. Emboro busu da rawa gajadesa da awodo Mamo mi utu da emboro gajadira. Emboro busu da rawa gajadi ae da awodo Mamo mi utu da gajadi aera.” ");
INSERT INTO nou_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Iesu mi sisira, “Ge nei ingoda yei sadena. Embo etoto ungo jiro da edo Mamo da yei ro embo sadi adera awa ungo awa embo adira ainda be awa embo etoto ta tamonde naso gebe ari embo mi dada adera awa na awa ungode daedo ra.” ");
INSERT INTO nou_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peter mi Iesu da yei bugudo sisira, “Bada embo nei mi naso yei iji berari biae ari mo iji roinge na umo kotembedo doeni? Iji 7 awodo kotembedo doenita?” ");
INSERT INTO nou_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Setiri Iesu mi mina sisira, “Awodo aera iji 7 aera te ajigari da aera te iji berari kotembedo doio. ");
INSERT INTO nou_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Edo Mamo da gitijigari iji awa teta gitijigari da mi uso gano roinge uso buro embomei mi jingama edo mina itadi siseri awa gadi dipapa isira. ");
INSERT INTO nou_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Edo umo awa tuturo iri ungoi embo da uso gano nembodiba jingama isira te mina itae awa budo totorisera. ");
INSERT INTO nou_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Edo buro embo awa gano mina itari sago ae gido gitijigari mi sisira ungoi uso buro embo de uso aro de uso kinapeina de edo uso rora topo berari awa ori orase sisira. Edo ungoi awodo adera awa buro embo awa gitijigari da mina awa sekago itadira awa gitijigari mi sisira. ");
INSERT INTO nou_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Edo buro embo ge awa ingido gitijigari da jo da baingo dederi edo gegeta edo sisira, ‘Iji tupo simba egae sekago iso yei itore.’ ");
INSERT INTO nou_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Setiri edo gitijigari awa buro embo awa jo edo gido kotembedo doturisira. Edo buro embo awa mina itae. ");
INSERT INTO nou_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Edo embo awa ijegedo buro embo nei tambusira. Edo embo ainda yei gano kiambu ititisira te mina uso yei awa itae. Edo buro embo nei awa gido dubo da kundo uso yei sisira, ‘Naso gano awa sekago naso yei iti.’ ");
INSERT INTO nou_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Setiri buro embo nei uso jo da durido gegeta edo uso yei sisira, ‘Imo iji tupo simba adesa awa na iso gano awa sekago iso yei itadena.’ ");
INSERT INTO nou_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Setiri embo awa simba ae edo embo mi sisira, “Gajari oro da itiwo. Edo atare. ");
INSERT INTO nou_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Etero buro embo nenei mi ro isera awa gido dubo vevera edo gido ungoi gitijigari nembodiba da yei mambusera. Mambudo ungoi uso yei ro berari ijegurisira awa sisera. ");
INSERT INTO nou_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Edo ungoi awa setero gitijigari mi setiri buro embo giti da bugusira awa totorisira. Toriri gitijigari mi uso yei sisira, ‘Imo awa buro embo biae. Imo naso yei gegeta etesa na naso gano awa simba anase edo na imo kotembedo doetena. ");
INSERT INTO nou_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Awodo na imo jo etena edo imo daedo buro embo nei da jo ae etesa.’ ");
INSERT INTO nou_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Edo gitijigari tini gambari edo setiri ungoi buro embo awa bundari oro da ititisera. Edo gitijigari mi sisira amboda buro embo mi uso gano berari awa sekago itarase sisira. ");
INSERT INTO nou_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Edo ingo berari ingoda jo mi embo nenei da buria awa kotembedo doae adewa awa naso Mamo mi ingoda buria awa mana kotembedo doadira.” Edo Iesu awa sedo uso ambojimbi da yei ge awa atae isira. ");
INSERT INTO nou_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Edo Iesu ge awa atae edo Iesu Galilee dodo Judea busu da mambusira Jordan umo benei da. ");
INSERT INTO nou_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Edo mambiri edo embo jiwae be umo ambo ambo edo mambero embomei awa etiri ewamei isera. ");
INSERT INTO nou_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Edo Pharisee embomei mi bugudo Iesu bagadi sedo uso yei sisera, “Embo ave uso aro tepo doadi dipapa adira amomo nangoda agodari mo awara seita?” ");
INSERT INTO nou_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Setero Iesu mi mina sisira, “Ingo jiwari ewamei be ajigedo gaeta, ‘Tuturo da Mamo mi janja edo poega isira. ");
INSERT INTO nou_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Edo umo awodo edo Mamo mi daedo sisira embo awa uso aimamo ga dodo uso aro ga dada edo ungo etoto awa da adera sisira.’ ");
INSERT INTO nou_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Edo ungo awa etoto aera te ungo awa da awasedo ro Mamo mi pundegetiri dada etera awa doawo ungo awa embo nenei mi ewoga ewoga eore.” ");
INSERT INTO nou_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Setiri Pharisee embomei mi uso yei sedo gosisera, “Awa gebe edo ro awasedo Moses mi sisiri embo ave uso aro doari dipapa edo awa umo aro doari da ge gaedo edo aro doari mambarase sisiri?” ");
INSERT INTO nou_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Setero Iesu mina sisira, “Moses mi sisira ingoda aro asini doadewa awa awara sisira ainda be awa ingoda jo awa bebegae awasedo awarate tuturo da Mamo wasiri awawa umo dipapa ae isira. ");
INSERT INTO nou_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Edo na ingoda yei sena embo ave uso aro doadira awa evetu awa viro aera edo embo awa evetu nei jimbadira awa viro adira. Edo daedo embo ave evetu jimbudo doari jimbadira awa viro adira giwo.” ");
INSERT INTO nou_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Edo Iesu ge awa setiri uso ambojimbi mi uso yei sisera, “Awodo da embo uso aro ga dada atadera gido re ewamei awa embo awa masewo atadira awa ta rora.” ");
INSERT INTO nou_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Setero Iesu mi mina sisira, “Embo amenda yei Mamo atopatari eiawa isaga ira embomei amimi atopatari eiawa ambo ambo adira awarate embo nenei ambo ambo ae. ");
INSERT INTO nou_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Edo be neinde kainde mi euri embo jimbae masewo atima era. Embo nenei ungoda aimono mi budo era ainde awa ungo ve ae awasedo ungo jimbae atima era. Edo embo nenei awa kasiwo mi diugedo era awasedo ungo jimbae atima era. Edo embo nenei awa iji berari Mamo da agipo adi awasedo dipapa edo gido jimbae edo era. Edo embo ave atopatari eiawa badira gido bare.” ");
INSERT INTO nou_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Embo nenei awa Iesu mi uso ingo awa ungoda kinapeina da beo da itido Mamo da yei ungo awasedo gegeta arase dipapa edo gido ungoda kinapeina awa budo bugusera. ");
INSERT INTO nou_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Edo budo bugero Iesu da ambojimbi mi embomei awa isiburisera awarate Iesu mi sisira, “Kinapeina naso yei puradi iriroro beitigeove. Na ungo naso yei purorase dipapa ena ainda be awa embo amenda yei saboa ari teta kinapeina einda ainda awodo awa Mamo da gitijigari yei da toradera.” ");
INSERT INTO nou_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Edo Iesu uso ingo ungoda kopiri da itido Iesu mambusira. ");
INSERT INTO nou_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iji da mei singa da mi Iesu da yei bugudo sedo gosisira, “Atopatari na wasiri ewamei ro edo wasiri ewamei natopo atari awa beni?” ");
INSERT INTO nou_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Setiri Iesu mi mina sisira, “Ro awasedo imo naso yei ro ewamei awa nganega esi? Mamo umo umosuka awa ewamei ra. Edo imo wasiri matawa atari dipapa adesa awa Mamo da agodari awa kera eio.” ");
INSERT INTO nou_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Setiri mei singa mi nganega isira, “Agodari mo rori?” ");
INSERT INTO nou_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Setiri Iesu mi mina sisira, “Embo nei deose. Ipu da eose. Bengono eose. Ge busose. Iso ai de mamo de sapo eio. Imo imosuka dubo buresa da awodo embo nenei dubo buio.” ");
INSERT INTO nou_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Setiri mei singa mi mina sisira, “Agodari berari awa na kera emona. Edo nei ro eni.” ");
INSERT INTO nou_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Setiri Iesu mina sisira, “Imo ewamei teta Mamo ewamei awodo adi dipapa adesa awa mambuio. Mambudo iso rora berari awa ori edo gano awa embo rora ae ainda itio. Edo rora jiwae awa imo simba ise utu da atira awasedo puio na ambo ambo ase.” ");
INSERT INTO nou_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Setiri mei singa awa ge awa ingido dubo vevera de mambusira ko umo awa rora jiwae de awasedo. ");
INSERT INTO nou_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Edo Iesu ge awa sedo atae edo Iesu uso ambojimbi da yei sisira, “Na ingoda yei sena embo rora jiwae de embo mi Mamo da gitijigari yei da torari awa okain be ra. ");
INSERT INTO nou_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Edo na ingoda yei ge nei sane. Wo nembodiba camel mi ningu to da torari awa okain be ra awarate embo rora jiwae embo mi Mamo da gitijigari yei da torari awa okain be okain ra.” ");
INSERT INTO nou_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Edo Iesu uso ambojimbi ge awa ingido kove be kove edo Iesu da yei nganega isera, “Awodo re awarate ko Mamo mo embo ave awa soregeiri?” ");
INSERT INTO nou_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Setero Iesu ungo gon edo ditini edo mina sisira, “Embo mi eiawa ari sago aera te Mamo mi rora berari awa adira.” ");
INSERT INTO nou_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Setiri Peter mi sisira, “Nango rora berari dodo imo ambo ambo era awasedo imo nangoda yei ro itesi?” ");
INSERT INTO nou_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Setiri Iesu mi mina sisira, “Na iso yei gebe mi sedo ena awasedo ingio. Edo busu seka bugadira ainda Mamo da mei busu da bugudo embo isira awawa uso anumba ewamei parara de ainda anumbadira. Edo daedo ingo naso ambojimbi 12 awa gitijigari da anumba da anumbedo ingo mi Israel da orobe 12 awa kasadewa. ");
INSERT INTO nou_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Edo embo ave na awa embo mando de namendi de ru de ai de mamo de edo kinapeina de ba buro da awa doadira nanemi embo ainda rora da awodo jiwae de edo wasiri natopo atari de awa itadena. Edo embo jiwae boroko embo nembogambo era awa nembogambo adi aera. ");
INSERT INTO nou_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Edo embo jiwae boroko embo nembogambo ae etera awa nembogambo adera.” ");
INSERT INTO nou_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesu mi sisira, “Mamo da gitijigari da iji awa teta buro da ainda topo mi ribe jawo grape gowusira. Sipo kiambu de embo eiawa buro embomei budo uso buro da buro orase eura adi mambusira. ");
INSERT INTO nou_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mambudo embo nenei tambudo daedo umo ge sisira gano roinge ungoda yei mina itadira awa ge sisira. Edo sisira umo ungo iji da da mina awa itadira sisira. Setiri ungo awara sisera. Setero buro topo mi setiri buro adi mambusera. ");
INSERT INTO nou_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","“Edo waiko beo da ae atiri buro topo sekago origarori ari yei da mambudo embo nenei tepo awodo buro ae dederigedo atero gido sisira, ‘Daedo mambuwo naso buro yei da buro ave. Awo nanemi mina inono da awodo itane.’ ");
INSERT INTO nou_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Setiri ungo mambusera. Edo waiko beo da edo waiko wareregurisira awa buro topo ari da awodo isira. ");
INSERT INTO nou_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Edo ongobo de sekago origarori ari yei da mambudo embo nenei iji natopo dederigedo atero gosisira. Gido ungoda yei sisira, ‘Ro awasedo ingo einda ro ae tepo awodo atevi?’ ");
INSERT INTO nou_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Setiri ungoi sisera, ‘Embo nenei nangoda yei buro itae etera awasedo nango einda dederigedo tepo atera.’ “Setero buro topo mi mina sisira, ‘Awara ingo daedo mambuwo naso buro yei da buro ave.’ ");
INSERT INTO nou_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Edo ongobo etiri buro topo mi buro embo da gitijigari da yei sisira, ‘Buro embomei jawo seio. Bugoro ungoda mina itase. Edo buro embobo ongobo de bugera ainda mina awa giti itio. Edo amboda awa buro embo sipo kiambu de bugera ainda mina awa itio.’ ");
INSERT INTO nou_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Setiri buro da gitijigari setiri buro embo ongobo de bugusera awa totorisera. Torero ungoda iji da da mina awa ititisira. ");
INSERT INTO nou_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Awasedo buro embo sipo kiambu de bugusira awa kotisera awa ungo mina nembodiba badera awasedo bugusera awarate ungo daedo iji da da mina awa burisera. ");
INSERT INTO nou_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Edo ungoda gano awa budo tini gambari edo buro topo da yei sisera, ‘Embomei eiawa ongobo be de bugudo edo buro kiambu be etera. Edo nango awa sipo de waiko vevera janibetiri derera te imo nango de edo ungo de awa gano inono da itesa.’ ");
INSERT INTO nou_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Setero buro topo mi buro embo dakain da yei sisira, ‘Naso otao ingio. Na imo potaera te ingode gano da ge awa dada setera edo imo iji da da mina da buro adi setesa awasedo iso mina budo iso nati da mambuio. ");
INSERT INTO nou_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na embo buro adi bugera berari ainda mina da awodo itadi dipapa etena. ");
INSERT INTO nou_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na naso gano topo awasedo na ro adi adena amone adena. Edo imo tini gambari esa ainda be mo na ewamei etena awasedo ta?’” ");
INSERT INTO nou_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Edo Iesu ge awa atae edo sisira, “Embo ave giti na ambo ambo adi setera edo embo ave amboda na ambo ambo adi setera embomei awa simba ari da awodo adena.” ");
INSERT INTO nou_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Edo Iesu Jerusalem kena pepeta ise uso ambojimbi budo demonda mambusira. ");
INSERT INTO nou_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Edo ungo ungosuka mambuse ungoda yei sisira, “Ingodena Jerusalem vivitera. Edo ainda mambadera ainde na Mamo da mei busu da embo isira awa ungoi budo Priest gitijigari de edo agodari da atopapotegari de da ingo da itadera. ");
INSERT INTO nou_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Edo embomei omimi budo embomei Jew ae jawo Gentile da yei itadera. Edo embomei omimi dedo gaedo gandubedo edo benema mi ri orega da dadera awarate iji tamonde atae ari Mamo mi betari da edo wasiri de atari da jigari sekago eradira.” ");
INSERT INTO nou_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedee da memei da ai mi uso memei de Iesu da yei bugusira. Bugudo tumondebain isira uso dipapa awa Iesu da yei sadi. ");
INSERT INTO nou_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Edo evetu awa bugiri Iesu uso yei nganega isira, “Imo ro dipapa esi?” Setiri evetu mi mina sisira, “Na imo gitijigadesa iji ainde naso memei etoto eiawa mei da iso ingo be da mei nei awa iso ingo anda da anumborase sasase sedo kundo bugena.” ");
INSERT INTO nou_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Setiri Iesu ungoda yei mi mina sisira, “Ingo gae ro embo sedo gosewa. Ingo na memesi badena da awodo bevita?” Setiri ungoi mina sisera, “Nango adera.” ");
INSERT INTO nou_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Setero Iesu mi sisira, “Ingo gebe setewa. Ingo na memesi badena da awodo badewa awarate anumba etoto awa naso ae awasedo nanemi amemi anumbadera awa sadi aera. Mamo mi anumba etoto awa sia etira awasedo amemi anumbadera awa sadira.” ");
INSERT INTO nou_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Edo ambojimbi nenei 10 mi ge awa ingido ungoi namendi namendi ga da yei tini gambari isera awasedo Iesu mi setiri ungo berari Iesu ga dada isera. ");
INSERT INTO nou_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Etero Iesu mi ungoda yei sisira, “Ingo gosewa aumo embo awa dombu okain de gitijigido era awarate ingo mana awodo gitijigari mina mina adewa. ");
INSERT INTO nou_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Embo amemi embo nembodiba adi dipapa adira awa embo nenei kondade adira. ");
INSERT INTO nou_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Edo embo ave ingoda gitijigari adi dipapa adira awa umo ingoda buro embo adira ainda be awa na Mamo da mei embo isena awa da awodo isena. ");
INSERT INTO nou_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na embo nei mi na kera orase bugaera te na embo berari awa kera adi bugusena. Bugudo naso betari mi embo jiwae wasiri biae da agipo embobo ewora awa wujegadira.” ");
INSERT INTO nou_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu uso ambojimbi de Jericho nati awa doturero embo jiwae be mi Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Edo embo etoto diti guba egeregari awa emboro be aikambu da anumbedo atisera amimi Iesu bugudo mambari awa setero gido edo gogo dimbudo sisera, “Gitijigari David da orobe nango jo egae.” ");
INSERT INTO nou_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Setero embo mi ungo isiburisera edo ge dorase sisera te ungo sekago gogo dimbudo kiambu ae be sisira, “Gitijigari David da orobe nango jo egae.” ");
INSERT INTO nou_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Setero Iesu ainda petedo ungoda yei sisira, “Ingo ro anase dipapa evi?” ");
INSERT INTO nou_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Setiri ungoi mina sisera, “Gitijigari nango aso sekago yei gadi sera.” ");
INSERT INTO nou_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Setero Iesu ungo jo edo gido ungoda diti jijigiri ungoi yei sekago gido Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu uso ambojimbi de Jerusalem nati aikambu ise ungoi nati Bethphage Olive doriri tamo da ainda bugusera. ");
INSERT INTO nou_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Edo ainda bugudo Iesu umo uso ambojimbi etoto giti itari mamborase sedo sisira, “Nati nei da ounda mambudo ingo wo donkey poega de uso mei de awa digari atirari gadewa. Gido wujegedo budo naso yei da buguwo. ");
INSERT INTO nou_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Edo embo amemi ro ewa awa nganega oro gido ungoda yei sewo gitijigari mi dipapa ira sewo. Sawo ungoi ingoda yei itore.” ");
INSERT INTO nou_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ko Mamo da binga sari embo mi matu be sisira awasedo Iesu mi awodo sisira. ");
INSERT INTO nou_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mamo da binga sari embo mi sisira, “Zion embomei awa seio gore ungoda gitijigari bugutira awa embo nembodiba awodo bugadi aera te wo donkey da mei da tamo da vitido bugadira seio gore.” ");
INSERT INTO nou_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Awasedo Iesu da ambojimbi etoto giti giti mambudo ro Iesu mi orase sisira awa berari isera. ");
INSERT INTO nou_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ungoi wo donkey de uso mei de awa budo bugusera. Edo ungoda ombari wo etoto da tamo da itero Iesu vitido wo mei tamo da anumburisira. ");
INSERT INTO nou_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Edo embo jiwae be bugudo nenei ungoda ombari totedo emboro da besi isera. Edo nenei awa ri papatu divedo budo emboro da itido isera. ");
INSERT INTO nou_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Edo embo nenei Iesu da dombu da Iesu soropu da embo nenei gun da awodo mambusera. Edo ungoi mambuse iaviri edo gogo dimbudo sisera, “Nango David da orobe awa jasiga era. Embo eiawa Mamo da jawo da bugira Mamo mi umo ewamei are. Embo berari Mamo jasiga ore.” ");
INSERT INTO nou_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Edo Iesu Jerusalem nati da toriri edo nati embomei berari awa iaviri be iaviri edo sisera, “Embo eiawa averi?” ");
INSERT INTO nou_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Setero embo Iesu ambo ambo isera amimi sisera, “Emone binga sari embo Iesu ra busu Galilee edo nati Nazareth embo ra.” ");
INSERT INTO nou_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu Jew embomei da tumondebain ari oro joda torido embo mina itido budo ise atisera awa ondetiri bugusera. Edo embo mi gano mina ita edo isera ainda tendeba jigido kapotegedo edo ribo rorou itari embo da anumba budo wawara isira. ");
INSERT INTO nou_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Edo ungoda yei sisira, “Jiwari ewamei be mi sira Mamo mi sisira, ‘Naso mando awa embo da benunu sari yei.’ Awarate ingo mi ewo bengono embomei da meko to ira.” ");
INSERT INTO nou_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Edo Iesu umo Jew embomei da tumondebain ari oro joda atiri embo diti guba egeregari de tei ambari de mi uso yei bugero unemi etiri berari ewamei isera. ");
INSERT INTO nou_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Edo priest da gitijijigegari de agodari da atopapotegari mi Iesu wasiri ewagaewa ira awa gosisera. Edo ungo kinapeina gogo dimbudo isera embo eiawa David da orobe awa jasiga ewo sero ingisera. Ingido edo gido priest gitijijigegari de edo agodari da atopapotegari de awa tini gambari edo gido Iesu da yei sisera, “Imo ro sera awa ingesita?” ");
INSERT INTO nou_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Setero Iesu mi mina sisira, “En na ingena. Edo jiwari ewamei be mi sira ingo mi kinapeina awa jasiga orase atopapotisewa edo ingo ajigedo gaeta?” ");
INSERT INTO nou_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sedo Iesu ungo dodo edo Jerusalem nati dodo umo mambudo Bethany nati ainda tumba de eusira. ");
INSERT INTO nou_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iesu ainda euko sipo atae erido nati dodo sekago Jerusalem da engenemburise beji tambusira. ");
INSERT INTO nou_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Edo ri betora awa emboro demonda gido gadi mambusira awarate be ae igi berari mi atisira awasedo Iesu mi ri ainda yei sekago be eurase sisira awasedo ri awa ambusira. ");
INSERT INTO nou_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ambiri edo ambojimbi awa gido kove be isera. Edo kove be edo Iesu da yei sisera, “Rawodo edo ri eiawa burigi be garasa etiri?” ");
INSERT INTO nou_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Setero Iesu mi mina sisira, “Ingiwo. Ingo jo de Mamo gebe adewa awa ro ri einda etena da awodo ingo adewa. Edo daedo ingo doriri einda sae etewa erido ewa da woseio sae etewa awa doriri awa wosae etira. ");
INSERT INTO nou_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ingo na gebe adewa awa ro Mamo da yei sedo gadewa amone badewa.” ");
INSERT INTO nou_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Edo Iesu engenembedo Jew embomei da tumondebain ari oro da bugudo embo atopapotisra. Edo Iesu atopapotiri Priest da gitijijigegari de Jew embomei de embo nembogambo mi bugudo Iesu da yei nganega isera, “Goroba amenda mi imo wasiri eiawa esi? Edo goroba emomo amemi iso yei ititisiri?” ");
INSERT INTO nou_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Setero Iesu mi mina ungoda yei sisira, “Na ingoda yei sedo gari da itadena. Edo ingo naso yei mina sadewa awa na goroba eiawa amemi etiri budo buro eiawa edo eni awa sadena. ");
INSERT INTO nou_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Edo John goroba mo amemi itiri budo embo umo mi ewamei edo isiri? Embo mi goroba amo itero burisita ko Mamo mi ititisiri?” Setiri ungo ungosuka ge mina baga edo sisera, “Ingode ro seri? Ingode Mamo mi John da yei goroba ititisira sadera awa Iesu umo ingodenaso yei sadira ro awasedo ingo John gebe ae edo isevi sadira. ");
INSERT INTO nou_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Awarate ingode embo mi John da yei goroba ititisira awodo sadera awa embo awa oju adera ko embo berari mi kotedo era John awa binga sari embo awasedo.” ");
INSERT INTO nou_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Awasedo ungoi Iesu da yei mina sisera, “Nango gaera.” Setero Iesu mi ungoda yei sisira, “Awasedo na goroba amemi ituri wasiri eiawa edo eni awa na ingoda yei sadi aera.” ");
INSERT INTO nou_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesu mi sisira, “Inia ge eiawa kotewo. Edo memei etoto da mamo mi mei bego da yei sisira, ‘Naso mei boroko mambuio grape buro yei da buro ase.’ ");
INSERT INTO nou_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Setiri uso mei bego mi sisira, ‘Na buro ari ujo ae ena.’ Awarate amboda umo jiro nei kotedo buro yei da mambudo buro isira. ");
INSERT INTO nou_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Edo Mamo mi mambudo uso mei ambo da yei sari da awodo sisira. Setiri mei ambo mi mina sisira awara na buro adena sisira awarate umo buro da mambae. ");
INSERT INTO nou_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Edo mei rawa mi Mamo da dipapa awa isiri?” Setiri embo berari mi Iesu da yei mina sisera, “Mei bego mi.” Setero Iesu mi ungoda yei sisira, “Edo na ingoda yei eiawa sano gadewa. Tax bari embomei de edo viro emboevetu de mi Mamo da atari yei da toradera te ingo mo torevi ta ko toradi aeri? ");
INSERT INTO nou_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","John umo mi ewamei ari embo ingoda yei bugusira edo ingoda yei emboro ewamei da pepeta awase ujugurisira. Edo ingo John gebe ae isewa te tax bari embomei de viro emboevetu de awa umo gebe isera. Edo embomei awodo etero ingo gosisewa te ingo ingoda jiro wareregedo John gebe ae isewa.” ");
INSERT INTO nou_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Edo Iesu awa sedo sisira, “Inia da kiki nei eiawa sadena ingiwo. Embo da amimi ve jawo grape awa sokedo buro da gowusira. Edo tano itido edo grape jasari yei edo simba ari embo da gaga de didigurisira edo buro awa embomei nei mi simba orase sedo sisira. Edo sisira grape be sari ari awa be nenei awa ungo mi badera edo be nenei awa unemi badi sisira. Edo buro ainda topo awa yei awa dodo busu nei da mambusira. ");
INSERT INTO nou_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Edo ainda amboda grape be awa sari etiri buro topo awa ri be awa uso tega awa badi dipapa edo uso buro embomei itiri badi mambusera. ");
INSERT INTO nou_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Edo buro embobo awa buro da mambero edo simba ari embo amimi buro embo awa sandido nenei awa ituka mi dedo gaedo ise nenei awa deoro betedo isera. Edo nenei awa ganuma mi doro betorase wawara edo isera. ");
INSERT INTO nou_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Awasedo buro topo mi buro ari embomei nenei jiwae ituri mambudo isera awarate ungo buro da mamboro edo buro simba ari embo mi ari da awodo edo isera. ");
INSERT INTO nou_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Awasedo ambo be amboda awa buro topo uso mei awa ititisira edo sisira ungo mi uso mei awa sapo orase sisira. ");
INSERT INTO nou_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Awarate buro simba ari embomei mi uso mei gido ungosuka sisera, ‘Buro topo da mei re bugutira. Edo ingode uso mei doro betadira ainda amboda uso rora berari awa ingodenaso topo adira.’ ");
INSERT INTO nou_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Awasedo ungoi mei awa buro ponda pigetero wosetiri edo ungoi detero bebetisira.” ");
INSERT INTO nou_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Edo Iesu awa sedo ungoda yei nganega isira. “Buro topo engenembedo mo buro simba ari embo da yei ro eiri?” ");
INSERT INTO nou_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Setiri ungoi mina sisera, “Embo bebegae awa dari betoro ainda amboda buro awa embo nei da itari simba adera. Edo ri be awa sari ari awa buro topo ga kando edo badera.” ");
INSERT INTO nou_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Setero Iesu mi ungoda yei sisira, “Ingo jiwari ewamei be ro sira awa ajigedo gaeta? Jiwari mi sira, ‘Ganuma mando itari embobo mi ujo ae isera awa tutuvi sangove da derari inge etira. Eiawa kove ari be awa Mamo mi etira.’ ");
INSERT INTO nou_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Awasedo nanemi ingoda yei sena Mamo mi ingoda anumba utu da atira awa budo embo nenei Mamo da buro edo gogo edo era ainda yei itadira. ");
INSERT INTO nou_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Edo embo ave ganuma einda tamo da duradira awa embo awa bejedo memeia adira. Edo embo ave ganuma emimi tamo da wosadira awa jasedo busu inge adira.” ");
INSERT INTO nou_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","46","Edo priest gitijijigegari de Pharisee embomei de Iesu inia da ge sisira awa ingido gosisera Iesu awa ungoda jawo da ge sira awasedo ungoi Iesu sandadi dipapa isera te ungo gosisera embo jiwae be awa Iesu awa binga sari embo awodo kotedo era awasedo oju isera. ");
INSERT INTO nou_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu sekago inia da mi embo da yei ge sisira. ");
INSERT INTO nou_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Iesu mi sisira, “Mamo da gitijigari da iji awa teta gitijigari nembodiba da amimi uso mei da jimbari bondo isira da awodo. ");
INSERT INTO nou_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Edo gitijigari awa embo bugorase matu sedo gosisira awasedo uso buro embomei ainda yei bondo da sari bugorase itiri mambusera. ");
INSERT INTO nou_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Awarate ungo bondo da purari ujo ae isera awasedo gitijigari buro embomei nei itiri mambusera embomei ainda yei edo sorase, ‘Naso bondo awa boroko sia etera edo na naso wo memei detena bondo adi edo berari awa sia etera. Jimbari bondo da puwo.’ ");
INSERT INTO nou_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Awarate embomei awawa binga sari embomei da ge awa ingaera te ungo ro era awa ise atisera. ");
INSERT INTO nou_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Embo nenei ungoda buro da mambutero embo nenei ungoda ori garori ari yei da mambutero edo embo nenei awa binga sari embomei awa sandido ituka mi dedo gaedo edo detero bebetisera. ");
INSERT INTO nou_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Edo gitijigari nembodiba tini gambari edo uso isoro embo itiri mambusera. Mambudo embo detero bebetisera embomei awa dorise ungoda oro mando dungetero ewusira. ");
INSERT INTO nou_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Edo gitijigari uso buro embobo jawo setiri bugusera. Bugero ungoda yei sisira, ‘Naso jimbari bondo awa sia etera awarate embo bugorase tuturo da sega etena awa bugari ujo ae etera awasedo ingo emboro da mambuwo. ");
INSERT INTO nou_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Edo ingo emboro da yima itido puma itido ise embo gadewa berari awa sega ewo bondo da purore.’ ");
INSERT INTO nou_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Setiri buro embomei mambusera. Mambudo yima itido puma itido ise embo ewa de embo bebegae de gosisera awa budo bugusera. Budo bugero edo jimbari bondo awa embo mi ato ae be isira. ");
INSERT INTO nou_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Edo gitijigari nembodiba embo bugusera awa gadi torido embo da awa jimbari bondo da iwuga awa ae atiri gosisira. ");
INSERT INTO nou_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Gido gitijigari mi uso yei nganega isira, ‘Otao imo awa jimbari bondo da iwuga awa ae etesa. Embo amemi awara setiri imo toresi?’ ");
INSERT INTO nou_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Setiri embo awa ge mina gitijigari da yei ge da sae isira awasedo gitijigari mi uso buro embomei da sisira, ‘Tei bundedo ingo bundedo edo pigewo ponda umenga da atise ji de di vegise atare.’” ");
INSERT INTO nou_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Edo inia kiki einda amboda Iesu mi sisira, “Mamo mi embo jiwae jawo setira te embo enumba ae awa katabetira.” ");
INSERT INTO nou_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pharisee embo nenei mi Iesu ga ge sadi dipapa isera wao adi sedo mambusera. ");
INSERT INTO nou_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mambudo ungosuka ge ro sadera awa dada edo sisera. Ge sedo ungoda ambojimbi de Herod da ambojimbi de awa itero Iesu da yei bugusera. Bugudo ungoi Iesu da yei sisera, “Atopatari nango gido era imo gebe sedo esa. Imo Mamo da emboro awa edo gogowo edo atopatido esa. Embo nenei awa nembogambo edo embo nenei awa nembogambo aera awarate imo ungo oju ae awasedo imo ungo awa da awodo ewamei edo esa. ");
INSERT INTO nou_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Edo nango agodari nangoda awa kera adera mo nango Rome embomei da gitijigari nembodiba da yei tax gano mo iterita mo itadi aeri? Se gore imo ro kotesi?” ");
INSERT INTO nou_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Setero Iesu ungoda kotari biae awa gido gido ungoda yei mina sisira, “Ingo ise sarago ari embomei ro awasedo ingo na wao ari dipapa evi? Ingoda tax gano awa eu gane?” ");
INSERT INTO nou_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Setiri ungoi gano uso yei ititisera. ");
INSERT INTO nou_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Etero ungoda yei sisira, “Gano tamo da dombu ove ari edo jawo mo amenda ri?” ");
INSERT INTO nou_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Setiri ungoi gano awa gido sisera, “Emone gitijigari nembodiba Caesar da ove de edo uso jawo de ra.” Setero Iesu mi ungoda yei sisira, “Ro Caesar da awa Caesar da itiwo edo ro Mamo da awa Mamo da itiwo.” ");
INSERT INTO nou_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Setiri ungo be gido jarisera edo Iesu dodo mambusera. ");
INSERT INTO nou_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Edo iji da ainde Sadducee embo mi embo betedo awa sekago wasiri de atadi ae awa atopatido isera amimi Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bugudo Iesu da yei sisera, “Atopatari Moses mi atopapotisira embo ave kinapeina itae betadira awa embo ainda namendi da aro rori awa jimbudo namendi betari ainda kinapeina itadira awa Moses mi atopapotisira. ");
INSERT INTO nou_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Boroko imo nangoda ge ingio. Nanonamendi 7 einda atima isera. Edo bego mi aro jimbusira te evetu awa kinapeina ingae. Edo mei bego awa betetiri uso namendi mi namendi da aro rori awa jimbusira awarate sekago evetu awa kinapeina ingae. ");
INSERT INTO nou_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Edo namendi awa bebetisira daedo edo nanonamendi berari da awodo isera. ");
INSERT INTO nou_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Edo ambo be ambo da evetu awa bebetisira awasedo betari da edo eradera ainde evetu amomo uso iu be mo averi? ");
INSERT INTO nou_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Edo busu einda atise nanonamendi berari mi evetu da awa jimbusera awasedo evetu iu be mo averi?” ");
INSERT INTO nou_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Setero Iesu mi mina sisira, “Ingo jiwari ewamei be de edo Mamo da goroba de awa gae awasedo ingo ge busetewa. ");
INSERT INTO nou_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Awarate embo de evetu de bebetegari awa sekago wasiri de atadera ainde awa ungo teta utu da asisi da awodo adera awasedo mana jimbadera. ");
INSERT INTO nou_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Edo ge embo betari awa wasiri de sekago eradera awa kotewo. Ingo ro Mamo mi ingoda yei sisira awa ajigedo gaeta? ");
INSERT INTO nou_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Mamo mi sisira, ‘Na awa Abraham da Mamo edo Isaac da Mamo edo Jacob da Mamo.’ Edo uso ge da be awa Mamo awa embo wasiri de atari da Mamo awarate Mamo awa betari da Mamo aera.” ");
INSERT INTO nou_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Setiri embo jiwae be mi uso atopatari awa gido ungo be gido jarisera. ");
INSERT INTO nou_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Edo Pharisee embomei Iesu mi awa setiri Sadducee embomei ge atae etero gido ungo dada isera. ");
INSERT INTO nou_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dada edo Pharisee embo agodari da atopatari embo da amimi Iesu da yei sedo gari mi itido gadi dipapa isira. ");
INSERT INTO nou_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Edo Iesu da yei sedo gari ititisira, “Atopatari agodari rawawa agodari nembodiba ri?” ");
INSERT INTO nou_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Setiri Iesu mina sisira, “Imo iso jo berari mi edo jiro iso berari mi edo asisi iso mi Mamo dubo buio. ");
INSERT INTO nou_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eiawa agodari nembodiba ra. ");
INSERT INTO nou_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Edo eiawa agodari nembodiba nei ra. Imo imosuka dubo buresa da awodo embo nenei dubo buio. ");
INSERT INTO nou_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Edo Moses da agodari de edo binga sari embomei de mi ro atopapotisera awa agodari etoto einda orereka ise atima ira.” ");
INSERT INTO nou_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Edo amboda Pharisee embomei dada etero Iesu mi ungoda yei nganega isira, “Soregari Embo Mamo mi itari bugarase sisira awa ingo ro kotevi? Umo mo amenda orobe ri?” ");
INSERT INTO nou_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Setiri ungoi mina sisera, “Umone David da orobe ra.” ");
INSERT INTO nou_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Setero Iesu mi nganega isira, “Ro awasedo Asisi Kotopu mi David da yei jiro gari nembodiba be ititisiri edo David Keriso awa gitijigari sedo isita? ");
INSERT INTO nou_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ko David mi sisira, ‘Mamo mi naso gitijigari da yei sisira naso ingo be da anumbeio. Edo anumbedo atise iso gitopo berari awa simba ase Mamo mi sisira.’ ");
INSERT INTO nou_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Edo David awa uso gitijigari sisira mo rawodo edo Soregari Embo Mamo mi itari bugarase sisira amomo David da orobe ge siri?” ");
INSERT INTO nou_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Setiri ungo oju edo sekago ungo uso yei nganega nenei ae doturisera. ");
INSERT INTO nou_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Edo Iesu mi embo jiwae de edo uso ambojimbi de da yei sisira, “Agodari da atopapotegari de agodari simba edo era embo jawo Pharisee de awa Moses da goroba budo ge sedo era awasedo ungo ro awase sadera awa ewo. ");
INSERT INTO nou_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Awarate ungo ro era awa gido eove ainda be awa ungo embo nenei mi ro orase sera awa ungo daedo ae era. ");
INSERT INTO nou_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ungo ungoda agodari bouga be embo nenei da saga da itido era te ungo embomei awa ungoda bouga awa kondade ae edo era. ");
INSERT INTO nou_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Edo ungo embo mi ungo ro era awa gorase dipapa edo era awasedo ungo awodo era. Giu Mamo da ge jiwari awa ungoi kera edo digido ungoda ingo da edo beo da digido era kera memeia aera te kera nembodiba ra. Giu ungoda ombari begiti riribori. ");
INSERT INTO nou_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Edo ungo embo mi ungo gorase iwuga oiedo edo tembuma era. ");
INSERT INTO nou_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","8","Edo ungo bondo da ta ko Jew embomei da dada ari oro da embo berari mi gadera ainda ungo anumbedo era. Edo ungo mina itido kundo ari yei da mambudo era awa embo mi ungo awa saboa edo atega orase dipapa edo era. Edo ungo tembuse embo mi ungo awa atopatari sorase dipapa edo era. “Awarate ingo awa nanonamendi edo na awa ingoda atopatari awasedo embo nenei da yei atopatari seove. ");
INSERT INTO nou_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Edo busu einda embo nenei awa mama seove ainda be awa ingoda Mamo da awa utu da matawa atira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Edo daedo na Soregari Embo Mamo mi itari bugarase sisira awa ingoda gitijigari da awasedo embo nenei awa gitijigari seove. ");
INSERT INTO nou_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Edo embo ave ingoda teda awa embo nembodiba adi dipapa adira awa umo ingoda buro ari embo adira. ");
INSERT INTO nou_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Edo embo ave umo umosuka edo embo nembodiba sadira awa Mamo mi ari embo kiambu adira. Edo embo ave umo umosuka kiambu adira awa Mamo mi ari embo nembodiba adira. ");
INSERT INTO nou_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ingo agodari da atopapotegari de Pharisee embomei de ingoda kasari iji re bugadira giwo. Ingo ise sarago ari embobo ingo mi Mamo da gitijigari yei da torari emboro awa embo nenei mi tororase sedo gajedo ewa. Ingo ingosuka awa mana toradewa te embo nenei toradi eoro ingo mi gajedo ewa. ");
INSERT INTO nou_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ingo agodari da atopapotegari edo Pharisee embomei ingoda kasari iji awa bugadira ingo gosewa. Edo embo mi ditini ero ingo gegata riribori edo ewa awarate ijegedo bugutewa awa ingo emboevetu rorigarori awa kondade ae edo ingo ungoda mando bengono edo ewa awasedo ingoda kasari awa nembodiba be ra. ");
INSERT INTO nou_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ingo agodari da atopapotegari de Pharisee embomei de ingoda kasari iji awa bugadira awasedo giwo. Ingo ise sarago ari embobo ingo embo nenei mi ingoda ambojimbi orase dipapa ise gido ingo ewa sembudo busu sembudo ise embo awa eura edo ewa. Ingo embo bebegae awarate embo nei ingoda ambojimbi adira awa embo awa embo biae be adira. Awodo ise awa ingo etoto awa riawo natopo atari da mambadewa. ");
INSERT INTO nou_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ingo agodari da atopapotegari de Pharisee embomei de ingoda kasari iji awa asusubetira giwo. Ingo embo nenei dedegedo ewa awarate ingo awa diti guba egeregari. Ingo sedo ewa, ‘Embo ave Jew embomei da tumondebain ari oro da jawo da ro adi sadira edo amboda embo awa ari dipapa ae adira awa umo mana adira. Awarate embo ave tumondebain ari oro jo da rora mina nembogambo de atira ainda jawo da ro adi sari sadira awa adira.’ ");
INSERT INTO nou_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ingo diti guba ari edo embo bebegae. Rora tumondebain ari oro jo da atira awa nembodiba ra ta ko tumondebain ari oro mi euri tumondebain ari oro da rovi ravi awa ewamei be ewamei edo ira awa nembodiba ri? ");
INSERT INTO nou_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ingo daedo atopatido ewa, ‘Embo ave rorou itari yei da jawo da ro adi sari sadira awarate amboda embo rora awa ari ujo ae adira awa mana adira. Awarate embo ave kando rorou itari yei da ainda itira ainda jawo da ro adi setira awa adira.’ ");
INSERT INTO nou_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ingo diti guba ari embomei. Rora kando awa nembodiba ta ko rorou itari yei mi euri kando awa ewamei be ewamei edo ira awa nembodiba ri? ");
INSERT INTO nou_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Awasedo embo ave rorou itari yei da jawo da ro adi sadira amone sira rorou itari yei da jawo da edo kando berari tamo da atira ainda jawo da sira awa unemi adira. ");
INSERT INTO nou_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","22","Edo embo ave Jew embomei da tumondebain ari oro da jawo da ro adi sadira amone sira Mamo da gitijigari anumba da jawo da edo Mamo ainda anumbedo atira ainda jawo da sira amone adira. ");
INSERT INTO nou_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ingo agodari da atopapotegari de Pharisee embomei ingoda kasari iji re bugutira giwo. Ingo ise sarago ari embomei ingo ingoda rora be da edo indari buro da be da awa itido ewa agodari mi sira awodo awarate agodari nembogambo nenei embo da yei ewamei ewo edo embomei jo ewo edo bengono eove eiawa ingo ae ewa. Agodari memeia awa iji berari edo ewa te agodari nembodiba daedo ari ruvegeove. ");
INSERT INTO nou_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ingo gitijigari dombu ambubu. Ingoda indari tewo da someni memeia awa gido budo wawara ewa te someni nembogambo indari tewo da ainda awa gae dodo nukewa. ");
INSERT INTO nou_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ingo agodari da atopapotegari de Pharisee embomei de ingoda kasari iji awa bugutira awasedo giwo. Ingo ise sarago ari embomei. Ingo ingoda tewo de adego de da pon awa segedo ewa te ungoda jo awa indari kumbari bengono isera amimi dongono ira. ");
INSERT INTO nou_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ingo Pharisee embomei diti guba egeregari. Ingo ingoda adego jo awa segadewa awa adego pon awa tepo ra. ");
INSERT INTO nou_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ingo agodari da atopapotegari de Pharisee embomei de ingoda kasari iji awa bugutira awasedo giwo. Ingo busari embomei. Ingo awa embo gowari yei da awodo uso tamo awa gari ewamei ra te uso jo awa embo da vetu mi beda ari edo rora bebetegari jiwae atira. ");
INSERT INTO nou_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Da awodo ingoda tamo de dombu de awa gari ewamei ra te ingoda jo awa biae edo kotari bebegae awodo atima ira. ");
INSERT INTO nou_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ingo agodari da atopapotegari de Pharisee embomei de ingoda kasari iji awa aikambu etira awasedo giwo. Ingo binga sari embomei da kokobo be awa simba edo gogo ise embo matu wasiri ewamei ise atima isera ainda kokobo be da giro edo ewa. ");
INSERT INTO nou_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Awodo ise ingo sedo ewa nango nangoda mamoumbogo da iji de atae etera awa binga sari embomei awa mana dae etera sedo ewa. ");
INSERT INTO nou_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ingo awodo sewa amone ingo eiedo sise sewa nango awa embo detero bebetegurisera ainda orobe ra sewa. ");
INSERT INTO nou_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Awasedo ingo ingoda mamoumbogo da wasiri bebegae tuturo isera awa ingo mi atae ewa awara. ");
INSERT INTO nou_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ingo awa jingabu edo jingabu da ve ra. Ingo ro edo riawo natopo atari ainda mambae doevi? ");
INSERT INTO nou_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Awasedo nanemi ingoda yei sena nanemi ingoda binga sari embomei de jiro gari embomei de atopapotegari de itano bugadera te nenei awa ingo mi dawo betadera nenei awa ingo mi benema mi ri orega da dawo betadera nenei awa ingoda dada ari oro berari da bugoro vejedo dedo ondawo ijegadera. ");
INSERT INTO nou_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ingo mi ondawo ijegedo ungo mi nati nei da edo mambudo nati nei da adera. Edo embo ewagaewa embo Abel da iji de edo mambudo embo Zachariah da ingoda mamoumbogo detero bebetegurisera ainda riroga awa Mamo mi itari badewa. Edo embo Zachariah awa Jew embomei da tumondebain ari oro joda rorou itari yei edo yei ewamei be ewamei ainda soropu da ingoda mamoumbogo dorisera amone embo Berakiah da mei ra. ");
INSERT INTO nou_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Edo nanemi ingoda yei sena Mamo mi embomei eiawa dorisewa ainda tamo da riroga awa itari badewa. ");
INSERT INTO nou_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ingo Jerusalem nati embomei nango jo era. Ingo Mamo da binga sari embomei dedo isewa edo ingo Mamo mi embo ituri bugudo isera awa ganuma mi dedo isewa. Na ingo teta kokora mi uso piki mi memeia rou edo apuregedo simba edo ira da awodo simba ari dipapa ena te ingo naso simba awa ujo ae ewa. ");
INSERT INTO nou_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Awasedo na boroko ingo doturena ingo ingosuka simba ewo. ");
INSERT INTO nou_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Edo boroko tuturo edo ingo mana na gadewa te na ingoda yei sena amboda ingo na embo Mamo da jawo da bugutena awa sise atega adewa iji ainde awa ingo mi sekago na gadewa.” ");
INSERT INTO nou_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu Jew embomei da tumondebain ari oro dodo mambutiri uso ambojimbi mi uso yei bugudo sisera, “Puio tumondebain ari oro awa gase.” ");
INSERT INTO nou_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Setero Iesu mi ungoda yei mina sisira, “Boroko ingo oro eiawa gosewa awarate na ingoda yei sena iji nei de awa tumondebain ari oro awa ganuma mi ititisera awa duradira edo tumondebain ari oro awa bebegae adera.” ");
INSERT INTO nou_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Edo Iesu Olives doriri da anumbedo atiri uso ambojimbi mi uso yei bugudo ungo ungosuka sisera, “Se gore iji nonde tumondebain ari oro eiawa dureiri? Edo iso bugari iji edo busu da sangove awa bugadi asusubetira awa ro ijegari nango mi iji awa geri?” ");
INSERT INTO nou_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Setero Iesu mi mina sisira, “Gido gogowo ewo. Doawo embo nenei mi ingo gandubeore. ");
INSERT INTO nou_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Embo jiwae mi naso jawo da bugudo sadera, ‘Namone Soregari Embo Mamo mi itari bugarase sisira awara.’ Edo ungoi awodo sedo amimi embo jiwae gandubadera. ");
INSERT INTO nou_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Edo ingo mi javi embo aikambu embogo era ainda awa ingadewa. Edo embo yei besaun embogo era ainda binga awa ingadewa awarate oju eove. Eiawa be bugadira te busu da sangove awa ainde awa aera. ");
INSERT INTO nou_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Embo busu neinde kainde da mi mina dara adera edo embo gari neinde kainde mi mina dara adera. Edo busu jiwae da baimana bugadira edo busu jiwae da didira adira. ");
INSERT INTO nou_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Edo rora berari eiawa tuturo adira ainde awa embo mi memesi awa teta evetu mi kinapeina badi jarise memesi budo ira da awodo tuturo edo badera. ");
INSERT INTO nou_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Edo daedo iji ainde embo mi imo bundadera edo imo dedo gaedo adera. Edo yei berari da awa embo mi imo ujo ae adera ko imo awa na ambo ambo ari embo awasedo. ");
INSERT INTO nou_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Edo naso ambojimbi nenei jiwae mi iji ainde na dodo ungosuka bekuba mina ara ise ujo ae mina ara adera. ");
INSERT INTO nou_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Edo iji ainde ge busari da binga itari embomei mi bugudo ganduboro embo jiwae mi ungo ambo ambo adera. ");
INSERT INTO nou_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Embo bebegae mi wasiri bebegae oro gido embo jiwae begogo edo dubo bari awa doadera. ");
INSERT INTO nou_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Awarate embo amemi busu sangove ari iji de na doae na ambo ambo ira embo awa Mamo mi soregadira. ");
INSERT INTO nou_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Edo naso ambojimbi busu berari da mi embo da yei Mamo iji nonde gitijigadira awa soro gadera. Awa sadera iji ainde awa busu da sangove iji awa bugadira.” ");
INSERT INTO nou_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Edo Iesu mi sisira, “Ro Mamo da binga sari embo Daniel matu be matu sisira awa ingo mi gadewa. Daniel mi sisira, ‘Embo mi rora biae awa Jew embomei da tumondebain ari oro da yei ewamei be ewamei da itoro deradira.’ (Ingo ge eiawa ajigurewa awa gido gogo ewo.) ");
INSERT INTO nou_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Edo ingo Judea busu embomei wasiri eiawa bugadira gido re oju sumbudo doriri da mambuwo. ");
INSERT INTO nou_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Embo ave uso mando gaga inda anumbedo atira awa mana wosedo mando joda uso rora mana badira. ");
INSERT INTO nou_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Embo ave uso buro da ira awa mana engenembedo uso tamo da ombari awa mana badira. ");
INSERT INTO nou_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Edo iji ainde evetu ave gasou de edo evetu ave mei emi gaira awa okain be adira. ");
INSERT INTO nou_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Edo Mamo da yei sedo giwo ga iji de o Jew embomei tumondebain ari iji de ingo sumbowase sedo giwo. ");
INSERT INTO nou_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Edo wasiri bebegae busu neinde kainde berari da awa atima ira busu tuturo isira ainde edo bugudo boroko awa nembodiba ra te iji ainde wasiri bebegae awa nembodiba be nembodiba adira. Embo iji ainde atadera amimi ari wasiri biae awodo awa ungo matu gae. ");
INSERT INTO nou_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Edo wasiri biae awa iji ribori adira awa embo berari betadera awarate Mamo mi uso embo awasedo matu sisira iji awa tupo kain adira sisira. ");
INSERT INTO nou_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Edo iji ainde embo ave iso yei sadira gi Soregari Embo Mamo mi itari bugarase sisira eire sadira o Soregari Embo oure sadira awa embo awa gebe eose ainda be awa embo teta Keriso awodo inge edo ge busari binga sari embobo jiwae be bugadera. ");
INSERT INTO nou_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Edo ungo bugudo ari wasiri goroba de ise edo iwata neinde kainde adera amimi awa ungo Mamo da embo jiwae be tei jumbadera. ");
INSERT INTO nou_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Amboda emone bugadira te nanemi boroko ingoda yei sena. ");
INSERT INTO nou_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Edo iji ainde embo nenei mi sadera Keriso re yei embo atae da ra sadera awa ainda mambose. Edo embo nei mi iso yei sadira Keriso re einda unjugedo atira sadira awa embo gebe eose. ");
INSERT INTO nou_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Edo Mamo da mei busu da bugudo embo isira awa bugadira awa teta birigi mi iji vitari da edo jaririgedo mambudo iji wosari da edo ira da awodo bugadira. ");
INSERT INTO nou_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Edo tamo betari rawainda atira ainda oga mi indari dipapa edo mambadira. ");
INSERT INTO nou_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Edo wasiri bebegae eiawa atae ari iji tupo, ‘Waiko ambudo umenga adira edo kariga janibadi ae adira edo damana utu dodo sokedo wosadera edo utu wasiri adira.’ ");
INSERT INTO nou_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Edo na Mamo da mei embo isena awa naso iwata awa utu da bugadira. Edo busu da embo berari naso iwata awa gido ji sadera. Edo na Mamo da mei bugudo embo isena awa poroga da naso goroba de edo usasa nembodiba de bugutinono embo berari mi na gadera. ");
INSERT INTO nou_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Edo utu da javi nembodiba be sadira teta puin da javi da awodo. Ainde awa Mamo mi uso asisi ewagaewa itari busu berari da edo ewa berari ainda mambadera. Edo asisi ewagaewa eiawa iji vitari da edo iji wosari da edo ijari edo sawari da awodo mambudo Mamo da katabari embomei awa budo dada adera. ");
INSERT INTO nou_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ingoda buro da ri ve eririra awa giwo. Edo ve seka koru edo vitari ingo gadewa ga dari iji tuturo etira awa ra. ");
INSERT INTO nou_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Da awodo ingo rora eiedo ijegurirari gido awa ingo gadewa naso bugari iji awa aikambu etira. ");
INSERT INTO nou_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Edo rora eiawa bugutirari awa ingoda orobe nenei awa iji ainde awa wasiri de atadera. ");
INSERT INTO nou_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Edo utu de busu de awa atae adira te naso ge awa matawa atadira. ");
INSERT INTO nou_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Awarate naso bugari iji awa embo mi gaera. Asisi utu da awa gae edo na Mamo da mei awa gae awarate Mamo umosuka garira. ");
INSERT INTO nou_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Edo na Mamo da mei busu da bugudo embo isena naso bugari awa teta ro Noah da iji de isira da awodo. ");
INSERT INTO nou_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Iji ainde embo ro bugutira awa gae awasedo ungo rawodo atima isera da awodo atisera. Edo Noah nga nembodiba da totorisira iji ainda edo embobo awa indido kumbudo ise edo embo de evetu de jimbudo isera. ");
INSERT INTO nou_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Edo Noah awa nga nembodiba vivitisira edo umo bojetiri embo nga pon da awa berari umo da indido ambujegurisera. Da awodo Mamo da mei bugudo embo isira awa bugadira iji ainde ro embo mi adi dipapa era awa ungoi ise atadera. ");
INSERT INTO nou_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Edo iji ainde embo etoto buro da buro ise atadera edo nanemi da awa burise da awa doadena. ");
INSERT INTO nou_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Edo evetu etoto indari sia ise atadera edo da awa nanemi burise da awa doadena. ");
INSERT INTO nou_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Edo ingo ingoda gitijigari iji nonde bugadira awa ingo gae awasedo gido gogo ewo. ");
INSERT INTO nou_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Embo mando topo awa bengono embo iji nonde bugadira awa gido awa embo awa ewae mando simba edo gogowo ise atadira bengono embo awa torurase. ");
INSERT INTO nou_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Awasedo ingo iji berari sia ewo ainda be awa ingo na Mamo da mei bugudo embo isira awa boroko bugadi aera awodo kotadewa te iji ainde awa na bugadena. ");
INSERT INTO nou_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Embo ave awa saboa edo jiro gari buro embo ri? Mando topo da amimi uso buro embo da yei uso buro embo nenei awa simba arase sisira. Edo embo awa sipo de ongobo de ungoda indari sia adira awa embo awa saboa edo buro ari embo ra. ");
INSERT INTO nou_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Edo mando topo awa engenembae etira edo buro embo awa awodo ae etira awa buro embo awa jo iaviri ae etira. ");
INSERT INTO nou_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Edo na ingoda yei sena mando topo awodo gido awa buro embo awa sari uso busu de edo uso rora berari de awa simba ae etira. ");
INSERT INTO nou_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Awarate buro embo awa biae awa umo kotae etira naso gitijigari da bugari iji awa asusubae ra. ");
INSERT INTO nou_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Awodo kotedo umo buro embo nenei awa dedo umo embo umo okain iji berari indido era ainde indido kumbudo ae etira. ");
INSERT INTO nou_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Edo buro embo awa uso gitijigari iji nonde bugadira awa kotae adira edo iji ainde awa uso gitijigari awa bugadira. ");
INSERT INTO nou_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Edo gitijigari bugudo buro embo ainda riroga itae etira edo itari ise sarago ari embomei deda atae etira. Edo ainda daedo itido unemi ungo berari da riroga itari ungoi ji sise di vegise atadera.” ");
INSERT INTO nou_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu mi sisira, “Mamo da gitijigari iji awa eiedo ra. Meigagara ademei 10 ungoda diti usasa ari rora budo jimbari embo tambadi mambusera. ");
INSERT INTO nou_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Meigagara 5 awa kotari de ra te meigagara nenei 5 awa kotari ae. ");
INSERT INTO nou_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Edo meigagara kotari egeregae awa ungoda diti usasa ari rora awa burisera te ainda goriwo da ngamo awa bae. ");
INSERT INTO nou_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Edo meigagara kotari de awa ungoda diti usasa ari rora burisera edo daedo goriwo dangamo burisera. ");
INSERT INTO nou_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Edo jimbari embo awa burigi bugae etiri gido memeigagara ademei awa diti bouga etiri gido pasido ewo isera. ");
INSERT INTO nou_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Edo tumba soropu da embo da amimi minonu sisira, ‘Jimbari embo bugutira. Puwo umo tambave.’ ");
INSERT INTO nou_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Setiri meigagara berari erido ungoda diti usasa ari rora jigero eririsira edo gaisera. ");
INSERT INTO nou_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Edo meigagara ademei kotari atae amimi meigagara kotari de ainda sisera, ‘Nango ingoda goriwo da ngamo awa kiambu iti gave ko nangoda diti usasa ari rora awa ambadi aikambu ira.’ ");
INSERT INTO nou_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Setero meigagara kotari de mi mina ungoda yei sisera, ‘Awodo aera nangoda goriwo da ngamo awa ingodena berari einde inono aera awasedo ingo mina itido kundo ari oro kire da mambudo ingoda goriwo da ngamo mina itido kumbuwo. ");
INSERT INTO nou_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Awasedo meigagara kotari egeregae awa goriwo da ngamo mina itido badi mambusera. Mambero jimbari embo seka bugusira. Edo meigagara ademei 5 sia isera awa jimbari embo seka de jimbari bondo da mambusera. Etero mangiro gajisira. ");
INSERT INTO nou_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Amboda ademei nenei 5 bugudo sisera, ‘Embo nembodiba mangiro pirigegae nango torore.’ ");
INSERT INTO nou_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Setero jimbari embo seka mi mina sisira, ‘Na ingo gaera.’” ");
INSERT INTO nou_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Edo Iesu mi inia da kiki awa atae edo sisira, “Iji nonde na bugadena awa ingo gae awasedo gido gogowo ewo.” ");
INSERT INTO nou_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesu mi sisira, “Mamo da gitijigari iji awa eiedo ra. Embo nembodiba awa esega busu nei da adi sia isira. Sia edo setiri uso buro ari embomei bugusera. Bugero uso busu de uso mando de uso rora berari de awa simba orase sisira. ");
INSERT INTO nou_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Edo daedo uso buro embomei da yei gano itido uso jawo da buro orase ititisira nei da awa K5,000 edo nei da awa K2,000 edo nei da awa K1,000. Edo buro ari embomei einda jiro gari awa neinde kainde ra awasedo buro embomei berari tamonde einda gano ajigari da awodo itae ra. Edo gano awa itido embo nembodiba awa mambusira. ");
INSERT INTO nou_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Edo buro embo gano K5,000 burisira awa burigi be mambudo gano awa jingama edo rora mina itido kundo isira. Awodo edo sekago tamo da K5,000 nei burisira. ");
INSERT INTO nou_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Edo da awodo buro embo nei K2,000 burisira awa gano awa jingama edo rora mina itido kundo isira edo sekago K2,000 nei tamo da burisira. ");
INSERT INTO nou_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Awarate buro embo K1,000 burisira awa mambudo uro ngambedo uso gitijigari da gano awa gousira. ");
INSERT INTO nou_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Edo amboda iji ribori be atae etiri embo nembodiba engenemburisira. Engenembedo uso buro embomei da yei gano rawodo jingama iseri awa nganega isira. ");
INSERT INTO nou_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Edo buro embo ave K5,000 burisira awa K5,000 nei budo ainda bugusira. Budo bugudo sisira, ‘Gitijigari imo naso yei K5,000 ititisesa edo na K5,000 nei betena eire.’ ");
INSERT INTO nou_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Setiri edo gitijigari mi mina sisira, ‘Naso tumonda ari edo buro embo ewamei imo buro ewamei be etesa. Edo imo gano kiambu eiawa edo gogo edo jingama etesa awasedo nanemi iso yei gano nembodiba itano jingama adesa. Edo torio edo nangae atise dubo ewamei ase. ");
INSERT INTO nou_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Edo buro embo nei K2,000 burisira awa torido sisira, ‘Gitijigari imo naso yei K2,000 ititisesa te gi K2,000 nei eire.’ ");
INSERT INTO nou_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Setiri uso gitijigari mi uso yei sisira, ‘Tumonda ari edo buro embo ewamei imo buro ewamei be etesa. Buro awodo edo awa gano kiambu eiawa jingama edo gogowo etesa awasedo nanemi iso yei gano nembodiba itano jingama adesa. Edo torio nangae atise dubo ewamei ase.’ ");
INSERT INTO nou_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Edo buro embo K1,000 burisira awa torido sisira, ‘Gitijigari na gari imo awa embo okain be. Edo embo nenei iso buro era awasedo imo buro da uredo govedo aera te imo indari jiwae budo esa. ");
INSERT INTO nou_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Edo na awa oju edo mambudo iso gano awa busu da govedo unjugurana. Gio iso gano eire kumbuio.’ ");
INSERT INTO nou_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Setiri gitijigari mi mina sisira, ‘Imo awa embo biae edo begogo embo ra. Edo imo na uredo govedo ae edo ena te indari jiwae budo ena awa imo garira awa imo ro edo naso gano awa atari oro da itae mo etesi? ");
INSERT INTO nou_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Imo ainda iteso awa na engenembedo bugudo naso gano berari budo edo nei kiambu tamo da banesae etesi? ");
INSERT INTO nou_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Awasedo embo ainda gano awa ingo da kumbudo embo K10,000 burisira embo ainda itio ainda be awa embo ave rora jiwae de awa rora nenei jiwae badira. ");
INSERT INTO nou_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Awarate embo ave rora enumba ae de awa rora uso yei dodo soubadera. ");
INSERT INTO nou_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Edo buro embo biae eiawa budo pigewo ponda umenga da atise ji de di gambuse atare.’” ");
INSERT INTO nou_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesu mi sisira, “Na Mamo da mei bugudo embo isena awa gitijigadi bugadena awa asisi ewagaewa berari awa daga bugadera. Umo bugudo uso anumba parara de ainda anumbadira. ");
INSERT INTO nou_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ainda anumbedo sari busu berari da embo awa uso yei dada adera. Dada oro gitijigari mi embo katabadira teta wo sheep simba ari embo mi wo sheep de goat de ewoga ewoga edo ira da awodo. ");
INSERT INTO nou_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Awodo edo unemi embo wo sheep inge awa budo uso ingo be da itido edo embo wo goat inge awa budo uso ingo anda da itadira. ");
INSERT INTO nou_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Edo gitijigari mi embo uso ingo be da ainda sadira, ‘Ingo awa naso Mama mi ewamei etira awasedo puwo. Puwo Mamo da gitijigari yei da atari ewamei tuturo ase Mamo mi imo awa sedo sia isira awodo. ");
INSERT INTO nou_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Edo na beji tambuteono ingo mi na indari itido isewa. Edo na sasaka ujo tambuteono ingo mi na sasaka itido isewa. Edo na bugudo isena edo ingo na matu gaera te ingo embo topo awodo edo na atega edo isewa. ");
INSERT INTO nou_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Edo naso bosini atae adi aikambu euri ingo mi na bosini nenei itido isewa. Edo na karu eono ingo mi na simba edo isewa. Edo na bundari oro da atono ingo mi na esega edo isewa.’ ");
INSERT INTO nou_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sari Mamo da embo mi uso yei mina sadera, ‘Gitijigari nanjigo imo beji tambuteoso nango gido indari itido iseri? Edo nanjigo imo umo ujo mi biae eoso gido umo itido iseri? ");
INSERT INTO nou_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Edo nango imo nanjigo gido edo embo topo awodo atega edo iseri? Edo nanjigo iso bosini atae adi aikambu euri gido bosini nenei itido iseri? ");
INSERT INTO nou_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Edo nanjigo imo karu eoso imo simba edo iseri? Edo nanjigo imo bundari oro da atoso imo esega edo iseri?’ ");
INSERT INTO nou_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Awodo soro gitijigari mi mina ungoda yei sadira, ‘Na gebe sena giwo. Ingo naso ambojimbi kiambu be da yei wasiri eiedo edo isewa amone naso yei da edo isewa.’ ");
INSERT INTO nou_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Awodo sedo gitijigari mi embo uso ingo anda da ainda sadira, ‘Ingo embo bebegae. Edo Mamo mana ingo ewamei adira awasedo na dodo mambuwo. Mamo mi Satan de uso asisi bebegae de awasedo riawo matawa atari sia isira ainda mambuwo. ");
INSERT INTO nou_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na beji tambuteono ingo naso yei indari itari ujo ae edo isewa. Na umo ujo tambuteono ingo na umo itae edo isewa. ");
INSERT INTO nou_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ingo na gaera te ingo na atega ae edo isewa. Naso bosini atae adi aikambu isira te ingo naso yei bosini seka itari ujo ae edo isewa. Na karu edo isena te ingo na simba ae edo isewa. Na bundari oro da atima isena te ingo na esega ae edo isewa.’ ");
INSERT INTO nou_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Sari ungoi mina sadera, ‘Gitijigari nanjigo imo beji de edo sasaka ujo mi biae eoso edo nango imo gae edo iso bosini atae adi aikambu euri edo karu eoso edo bundari oro da atoso imo gido kondade ae edo iseri?’ ");
INSERT INTO nou_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Awodo soro gitijigari mi mina ungoda yei sadira, ‘Na gebe sena awasedo ingiwo. Iji ainde ingo naso ambojimbi kiambu be awa kondade ari ujo ae edo isewa amone ingo na kondade ae edo isewa.’ ");
INSERT INTO nou_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Awasedo embomei eiawa riawo matawa ewuse atira ainda mambadera te Mamo da embomei awa wasiri natopo atari ainda mambadera.” ");
INSERT INTO nou_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu atopatido atae edo uso ambojimbi da yei sisira, “Iji etoto atae ari Jew embomei da jarusegari bondo da iji bugadira ingo gosewa. ");
INSERT INTO nou_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Iji ainde embo mi na Mamo da mei embo isena awa ungo mi na awa embo da ingo da itadera. Itido ungoi orega itido benema mi dadera.” ");
INSERT INTO nou_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Edo priest gitijijjigegari de Jew embo nembogambo de priest nembodiba jawo Caiaphas de Caiaphas da mando da dada isera. ");
INSERT INTO nou_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ungoi dada edo Iesu gae unjugari da budo doro betarase ainda kiki dirisera. ");
INSERT INTO nou_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Edo ungoi sisera, “Ingode bondo iji de adera awa embo tini gambari edo embogo adera awasedo iji ainde awa mana adera.” ");
INSERT INTO nou_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu Bethany nati da bugudo Simon karu leprosy bari embo awa ewamei isira ainda mando da mambusira. ");
INSERT INTO nou_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Edo Iesu anumbedo indari indise atiri evetu da mi utingi kiambu ganuma mi ari awa joino muno ewamei de mi beda ari uso mina nembodiba awa budo bugusira. Bugudo totorisira. Torido utingi kiambu be awa bejedo awa Iesu da beo da jojisira. ");
INSERT INTO nou_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Edo Iesu da ambojimbi evetu mi ro isira awa gido ungo tini gambari edo sisera, “Evetu ro awasedo eiedo etiri? ");
INSERT INTO nou_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ko joino oiawa ori edo gano nembodiba bae etira. Edo gano bae etira awa embo rora ae embomei da itae etira.” ");
INSERT INTO nou_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Edo Iesu ungo ro sera awa gido ungoda yei sisira, “Ingo ro awasedo evetu einda yei kotari bebegae evi? Evetu eiawa ro etira awa ewamei be etira. ");
INSERT INTO nou_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Edo embo rora ae embomei awa iji berari ingode daedo atadera awarate na awa ingode einda iji berari atadi aera. ");
INSERT INTO nou_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Edo evetu eiawa joino naso tamo da jojetira awa naso tamo gowari da sia etira. ");
INSERT INTO nou_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mamo mi evetu eiawa mana ruvegadira. Busu yei rawainda Mamo da binga ewamei sadera ainde embo berari mi evetu emimi etira awa ingadera.” ");
INSERT INTO nou_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iscariot awa Iesu da ambojimbi 12 da teda amimi priest gitijijigegari da yei mambudo sisira, “Na Iesu ingoda ingo da itano ingo naso yei ro itadevi?” ");
INSERT INTO nou_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Setiri ungoi K25 uso yei ititisera. ");
INSERT INTO nou_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Edo itero Judas iji ewamei budo Iesu indiga sadi simba isira. ");
INSERT INTO nou_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bondo da iji tuturo da ungo ambe indisera ambe bajari siwo jawo yeast ae ainde Iesu uso ambojimbi mi bugudo uso yei nganega isera, “Yei rawainda jarusegari bondo sia oro imo indadi dipapa esi?” ");
INSERT INTO nou_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Setero Iesu mi mina sisira, “Ingo nati da joda torido embo da tambadewa ainda sewo atopatari mi setira naso iji bugira awasedo na naso ambojimbi de jarusegari bondo awa iso mando da indadena sewo.” ");
INSERT INTO nou_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Setiri Iesu uso ambojimbi unemi ro sisira awa edo jarusegari bondo awa sia isera. ");
INSERT INTO nou_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Edo ongobo etiri Iesu uso ambojimbi 12 de indari indadi anumburisera. ");
INSERT INTO nou_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Edo ungoi indari indise Iesu mi sisira, “Na ingoda yei sena ingoda teda da amimi na indiga sadira.” ");
INSERT INTO nou_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Setiri uso ambojimbi dubo vevera edo dada uso yei sisera, “Gitijigari nanemi imo indiga senita?” ");
INSERT INTO nou_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Setero Iesu mi mina sisira, “Embo ave nangae indari dada betari embo amimi na indiga sadira. ");
INSERT INTO nou_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jiwari mi sira da awodo Mamo da mei bugudo embo isira awa betadira te embo na indiga sadira embo ainda yei awa biae be biae ra. Edo embo ainda ai mi umo kumbae doae etira awa uso yei awa ewamei ae etira.” ");
INSERT INTO nou_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Edo Iesu awodo setiri Judas Iesu indiga sadira embo amimi Iesu da yei nganega isira, “Awodo enita ko awodo adi aeri?” Setiri Iesu mi mina sisira, “Gebe imo awa awodo adesa embo awa ra.” ");
INSERT INTO nou_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Edo ungo indari indise atero Iesu ambe budo Mamo da yei ategari sedo ngaugedo uso ambojimbi da yei memeia ititisira. Edo ititise ungoda yei sisira, “Emone naso tamo. Kumbudo indiwo.” ");
INSERT INTO nou_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Awodo sedo aga kumbudo Mamo da yei ategari sedo ungoda yei ititise sisira, “Emone naso ororo amimi etiri Mamo da adi sari awa be etira. Nanemi naso ororo awa jojano Mamo mi embo jiwae da buria kotembedo doadira. ");
INSERT INTO nou_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Edo na ingoda yei sena na ingode daedo ribe grape da ngamo indena awarate na mana ingode daedo sekago indadena boroko edo mambudo iji na ingode wine seka awa naso Mama da gitijigari yei da ingode indadena.” ");
INSERT INTO nou_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Edo awodo sedo ungoi jasiga ari ya awa sise mando dodo wosedo Olives doriri da mambusera. ");
INSERT INTO nou_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Edo ungo doriri da vitido Iesu ambojimbi da yei sisira, “Boroko tumba de ingo berari sumbuse na nasuka doadewa edo ro jiwari da sisira awa be adira. Edo jiwari mi sira, ‘Mamo mi wo sheep simba ari embo dadira ainde wo sheep awa sisikakain adera.’ ");
INSERT INTO nou_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Awarate na betadena ainda amboda Mamo mi na jigari wasiri de sekago erido na ingoda giti da Galilee busu da mambadena.” ");
INSERT INTO nou_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Edo Iesu awodo setiri Peter mi uso yei sisira, “Berari emimi imo doadera te na mana imo doadena.” ");
INSERT INTO nou_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Awodo setiri Iesu mi Peter da yei sisira, “Boroko tumba de kokora egoro sae atirari imo na iji tamonde imo na gae sadesa.” ");
INSERT INTO nou_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Setiri Peter mi mina sisira, “Na ingae betadena te na mana imo gae mana sadena.” Edo Peter awodo setiri ambojimbi berari sari da awodo berari sisera. ");
INSERT INTO nou_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Edo yei awa dodo Iesu uso ambojimbi de yei jawo Gethsemane ainda mambusera. Ainda mambudo Iesu mi ungoda yei sisira, “Na ounda Mamo gada ge sadi mambutinono ingo einda anumbedo atiwo.” ");
INSERT INTO nou_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Edo Iesu Peter de Zebedee da memei etoto de kundo mambusira. ");
INSERT INTO nou_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Edo dubo vevera tambudo ungoda yei sisira, “Naso dubo vevera nembodiba mi na dadi aikambu ira awasedo einda nangae atise na kondade ewo.” ");
INSERT INTO nou_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Awodo sedo Iesu kiambu yarago ise baingo dederi edo dombu mi busu da gaedo edo Mamo da yei sisira, “Naso Mamo iso dipapa mi naso memesi eiawa kumbuio awarate imo ujo ae edo re doio. Edo naso dipapa awa eose ta iso dipapa mi awa eio.” ");
INSERT INTO nou_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Edo Iesu awodo sedo umo sekago uso ambojimbi da yei engenemburisira awarate ungo awa ewo ise atisera. Edo ungo gido Peter da yei sisira, “Ro awasedo ingo tamonde nangae tepo iji tupo simba edo gae evi? ");
INSERT INTO nou_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Simba edo gogo ise Mamo da yei ge sewo. Awodo adewa amimi bawari nembodiba ingoda yei bugadira awa ingo mana duradewa. Ingo ingoda jo berari mi ro ewamei awa adi dipapa ewa te ingoda tamo awa goroba ae ira.” ");
INSERT INTO nou_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Edo Iesu sekago kiambu yarago ise Mamo da yei sisira, “Mamo naso yei memesi eiawa bae etesita awarate imo ro adi dipapa esa awa eio.” ");
INSERT INTO nou_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Edo Iesu awodo sedo sekago engenembedo ambojimbi da yei bugusira te ungo ewo ise atisera. Ungo erido atari awa inono ae edo gido. ");
INSERT INTO nou_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Edo Iesu ungo sekago dodo sekago Mamo da yei sari da awodo sisira. ");
INSERT INTO nou_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sedo engenembedo uso ambojimbi da yei bugusira edo ungoda yei sisira, “Ingo jango indise ewo ise atewa? Giwo na Mamo da mei embo isena awa embo mi budo embo bebegae da ingo da itari iji awa bugira. ");
INSERT INTO nou_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Eriwo edo ingode mambore edo giwo embo na indiga sira embo awa bugutira.” ");
INSERT INTO nou_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Edo Iesu ge sise atiri Judas ambojimbi 12 da teda amimi embo jiwae be deda kokoro de kasiwo deda kundo bugusera. Edo priest gitijijigegari de edo Jew embobo embo nembogambo mi setero gido bugusera. ");
INSERT INTO nou_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Edo Judas indiga sari embo mi matu embo da yei sisira, “Embo nanemi sandido muno adena embo amone ingo dipapa ewa embo ra awasedo bundewo.” ");
INSERT INTO nou_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Edo Judas bugudo dambuderari Iesu da yei da mambudo Iesu muno ise sisira, “Atopatari na imo atega ena.” ");
INSERT INTO nou_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Setiri Iesu mi uso yei sisira, “Otao imo ro adi bugesi awa eio.” Setiri ungoi bugudo Iesu sandisera. ");
INSERT INTO nou_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Edo ambojimbi da mi uso kasiwo gorugedo budo priest da gitijigari da buro ari embo ainda dengoro awa diugurisira. ");
INSERT INTO nou_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Etiri Iesu mi uso yei sisira, “Embo ave kasiwo mi embogo adira awa kasiwo mi doro betadira awasedo iso kasiwo awa sekago uso atari yei da itio. ");
INSERT INTO nou_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Edo eiawa kotewo. Na dipapa adena awa na naso Mamo da yei kondade dipapa adena sedo gadena. Edo uso yei sedo gano unemi uso asisi ewagaewa ajigari nembodiba be itari bugudo na kondade adera. ");
INSERT INTO nou_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Awarate na awodo adena awa ro jiwari mi be arase sisira awa be adi aera.” ");
INSERT INTO nou_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Edo Iesu ge awa sedo wareregedo embo da yei sisira, “Ingo na awa teta bengono embo oju sumbudo mambari badi ingoda kokoro de kasiwo deda na badi bugevi? Iji jiwae be na Jew embomei tumondebain ari mando da anumbedo atise atopatido isena te ingo na bundae. ");
INSERT INTO nou_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Edo rora berari eiawa be bugiri ro Mamo da binga sari embo mi jiwari ewamei be joda jiwusira awa be isira.” Edo Iesu awodo setiri ambojimbi berari umo dodo sumbudo mambusera. ");
INSERT INTO nou_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Edo embo Iesu bundisera amimi Iesu budo Caiaphas embo nembodiba priest da gitijigari da mando da budo mambusera ainda agodari da atopapotegari de Jew embo nembogambo dada edo atisera. ");
INSERT INTO nou_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Edo Peter Iesu ambo ambo ise ambo da bugudo Caiaphas da ara da bugusira. Edo Peter ainda bugudo mando simba ari embomei deda anumburisira ainda be awa Peter umo ro aderi awa gari dipapa isira awasedo. ");
INSERT INTO nou_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Edo priest gitijijigegari de edo Jew embo nembogambo berari de awa Iesu bekuba edo biae da tambudo Iesu dadi dipapa isera. ");
INSERT INTO nou_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Edo embo jiwae bugudo Iesu da jawo da ge busedo isera awarate Iesu buria nei ro ae awasedo ungo Iesu bekuba ari sago ae isera. ");
INSERT INTO nou_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Edo ambo be ambo da embo etoto mi bugudo sisera, “Embo emimi sisira nanemi Mamo da tumondebain ari oro eiawa arasegedo edo iji tamonde de sekago jigano eradira sisira.” ");
INSERT INTO nou_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Setero priest gitijigari nembodiba mi erido Iesu da yei nganega isira, “Imo bekuba era einda mina ro sesi.” ");
INSERT INTO nou_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Setiri Iesu mina ro sae isira. Edo sekago priest gitijigari mi Iesu da yei sisira, “Mamo wasiri de atima ira ainda jawo da gebe seio. Imo Soregari Embo Mamo mi itari bugarase sisira edo Mamo da mei ta mo?” ");
INSERT INTO nou_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Setiri Iesu mi mina sisira, “Imo gebe setesa edo na ingo berari da yei sena amboda na Mamo da mei embo isira awa Mamo goroba jiwae de da ingo be da anumbedo atinono gadewa. Edo amboda poroga da bugutirari ingo mi daedo gadewa.” ");
INSERT INTO nou_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Setiri priest gitijigari nembodiba mi tini gambari edo uso ombari kerise sisira, “Umo ge biae Mamo da jawo da setira awasedo ingode mana bekuba embo nenei soro toradera. Edo ingo boroko uso ge biae awa ingewa. Ingo ro kotevi?” ");
INSERT INTO nou_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Setiri embo berari mi mina sisera, “Umo buria etira awasedo umo betadira.” ");
INSERT INTO nou_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Edo ungoi awodo sedo uso dombu da kosiwa edo Iesu dorisera. ");
INSERT INTO nou_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Edo embo umo dorisera amimi Iesu gandubedo sisera, “Imo sesa imo awa Keriso awasedo embo amemi imo detiri awa se gore.” ");
INSERT INTO nou_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Edo Peter awa mando demonda anumbedo atiri buro ari gagara da amimi bugudo Peter da yei sisira, “Imo awa Iesu Galilee busu embo ainda ambojimbi ra.” ");
INSERT INTO nou_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Setiri Peter embo berari da jo da sisira, “Imo ge ro sesa awa na gaera.” Sedo Peter wosedo ara be da awodo wowosisira. ");
INSERT INTO nou_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Edo buro ari gagara nei mi Peter gido embo atisera ainda sisira, “Umone Iesu Nazareth nati embo da ambojimbi ra.” ");
INSERT INTO nou_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Setiri Peter mi sisira, “Na gebe sena na embo awa na gaera.” ");
INSERT INTO nou_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Edo iji tupo embo derido atisera amimi Peter da yei bugudo sisera, “Nango gosera imo awa Iesu da ambojimbi ra ainda be awa iso ge de Iesu da ge awa da awara.” ");
INSERT INTO nou_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Setero Peter mi sisira, “Na ge busae ra. Na gebe sena. Edo na ge busadena awa Mamo mi na dari betadena. Edo na embo awa na gaera.” ");
INSERT INTO nou_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Edo Peter awa siri kokora egoro sisira. Edo kokora egoro setiri Peter Iesu mi ro sisira awa kotisira. Edo Iesu mi sisira, “Kokora egoro sae giti da imo iji tamonde na gae sadesa.” Sisira awa Peter kotedo arapa da bugudo dubo vevera mi biae edo ji sisira. ");
INSERT INTO nou_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sipo be sipo de priest gitijijigegari de Jew embo nembogambo de mi Iesu dadi ge dada sisera. ");
INSERT INTO nou_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Edo ungoi Iesu da ingo awa dada bundedo budo Rome embomei da gitijigari Pilate da yei mambusera edo ungoi Iesu Pilate da yei ititisera. ");
INSERT INTO nou_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Edo indiga sari embo Judas umo Iesu doro betarase era awa gido umo jiro wareregurisira. Edo jiro wareregedo K25 awa budo priest gitijijigegari de Jew embo nembogambo da yei mambudo Judas gano awa ungoda yei ititisira. ");
INSERT INTO nou_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Itido sisira, “Na buria etena ainda be awa na embo wasiri biae ae embo awa indiga setena edo ingo mi dawo betadira.” Setiri ungoi mina sisera, “Amone nangoda buria ae ra. Amone iso buria ra.” ");
INSERT INTO nou_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Setero Judas gano awa Jew embomei da tumondebain ari oro joda warawara edo pon da mambudo dubo da esi mi kikivi edo digidobebetisira. ");
INSERT INTO nou_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Edo Judas awodo etiri priest gitijijigegari gano awa budo ungosuka ge mina sara isera. Edo sisera, “Gano emone embo doro betarase mina itera. Edo ingodenaso agodari mi sira awa gano awa mana Jew embomei da tumondebain ari oro da gano de dada adira.” ");
INSERT INTO nou_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Edo ungoi ge mina sara edo ungoi gano amimi embo mi ou edo isira ainda busu mina itido isera. ");
INSERT INTO nou_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mina itido etero busu awa aumo embomei da embo gowari yei isira awasedo busu ainda jawo awa ororo busu. ");
INSERT INTO nou_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Edo wasiri awa atae etiri ro binga itari embo Jeremiah mi sisira awa be isira. Edo Jeremiah mi sisira, “Israel embomei nenei mi gano K25 buro ari embo da tega awa budo embo mi ou edo ira ainda busu mina itido badera. Eiawa Mamo mi nanemi anase sisira.” ");
INSERT INTO nou_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Edo Iesu Rome embomei da gitijigari da diti da derido atiri edo gitijigari mi Iesu nganega isira, “Imo mo Jew embomei da gitijigari nembodiba ta?” Setiri Iesu mi mina sisira, “Gebe setesa.” ");
INSERT INTO nou_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","13","Edo priest gitijijigegari de Jew embo nembogambo de mi Iesu bekuba isera te Iesu mina ro sae awasedo Pilate mi Iesu da yei sisira, “Imo ge jiwae sedo bekuba era mo gosesita? Edo ro edo mina sae esi?” ");
INSERT INTO nou_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Edo Iesu ungoda bekuba isera ainda mina ro sae isira awa gido Pilate kove be isira. ");
INSERT INTO nou_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gaeko jaige da jarusegari bondo iji de bundari embo ave awa embo mi Rome embomei da gitijigari mi wujegarase dipapa edo isera awa wujegedo isira. ");
INSERT INTO nou_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Edo iji ainde awa bundari embo jawo Barabbas awa bundari oro da atima isira. ");
INSERT INTO nou_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Edo embo jiwae be dada etero Pilate mi ungoda yei sedo gosisira, “Embo ave awa wujegeni Barabbas awa wujegadeni ta ko Iesu embo mi sedo era Keriso awa wujegeni? ");
INSERT INTO nou_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Edo umo gosisira embomei awa Iesu ujo ae edo isera awasedo ungoi Iesu awa Pilate uso ingo da ititisera awa umo gosisira. ");
INSERT INTO nou_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Edo Pilate awa uso kasari anumba da atiri uso aro ge itiri bugusira edo aro mi sisira, “Embo amone embo ewamei awasedo doio ainda be awa tumba de na eturo da embo awa getena edo uso yei mina biae betena.” ");
INSERT INTO nou_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Awarate priest gitijijigegari de Jew embo nembogambo mi ro orase sisera awasedo embo jiwae be mi Pilate da yei Barabbas awa wujegurise edo Iesu awa betarase dipapa isera. ");
INSERT INTO nou_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Edo Rome embomei da gitijigari mi ungoda yei sekago nganega isira, “Embo etoto einda da rawa wujeganase dipapa evi?” Setiri ungoi sisera, “Barabbas awa wujege.” ");
INSERT INTO nou_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Setero Pilate ungoda yei nganega isira, “Na Barabbas wujegadena edo Iesu Keriso sedo era mo ro eni?” Setiri ungoi mina sisera, “Benema mi orega da de betare.” ");
INSERT INTO nou_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Setero Pilate ungoda yei nganega isira, “Edo buria ro etiri?” Setiri ungoi berari gogo dimbudo sisera, “Benema mi orega da de betare.” ");
INSERT INTO nou_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Setero edo Pilate embo uso ge sekago ingadi ae awa gido gosisira awa embo mi embogo tuturo adera awa gosisira. Awasedo Pilate umo budo edo uso ingo awa embo berari da diti da segise ungoda yei sisira, “Ingo mi mana embo einda betari awa naso yei bekuba adewa. Ingo ingosuka awa uso betari da riroga badewa.” ");
INSERT INTO nou_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Setiri embo berari mi sisera, “Umo betari nango nangoda orobe de mi uso betari da riroga awa badera.” ");
INSERT INTO nou_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Setero Pilate Barabbas awa wujegurisira. Edo Pilate mi setiri ungoi Iesu vejedo edo Iesu awa embo da yei ititisira benema mi orega da doro betarase. ");
INSERT INTO nou_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Edo Pilate da isoro embomei mi Iesu budo Rome embomei da gitijigari da oro da torido edo embo berari mi Iesu jiriroka isera. ");
INSERT INTO nou_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Edo ungoi Iesu da ombari totigedo edo Iesu awa ombari kokoi ribori awa itero ombusira. ");
INSERT INTO nou_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Edo ungoi bebe mi gobe edo Iesu da beo da itero asugurisira. Edo Iesu da ingo be da ituka itero jigiri baingo dederi edo iro jirise ganduburise ungoi sisera, “Jew embomei da gitijigari nembodiba iji be ribori be atare.” ");
INSERT INTO nou_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sedo ungoi uso tamo da kosiwa edo ituka budo umo beo da dorisera. ");
INSERT INTO nou_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Edo ungo Iesu dedo gandubedo atae edo ungoi ombari kokoi awa totigedo uso ombari awa sekago itero ombusira. Edo ungoi Iesu budo benema mi orega da doro betarase budo mambusera. ");
INSERT INTO nou_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Edo ungo mambuteriko Cyrene nati embo jawo Simon awa tambusera. Tambudo setero Iesu da orega awa ango isira. ");
INSERT INTO nou_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Etiri mambudo ungoi yei jawo Golgotha ainda be awa beo agatu da yei ainda bugusera. ");
INSERT INTO nou_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Edo ungoi ri be jawo grape da ngamo awa rora muti tokaka de dada edo Iesu mi indarase itido isera awarate Iesu gambudo gido indae doturisira. ");
INSERT INTO nou_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Edo ungoi Iesu benema mi orega da dedo Iesu da ombari awa katabedo badi sedo pipi ga isera. ");
INSERT INTO nou_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ise Iesu ditini isera. ");
INSERT INTO nou_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Edo ungoi ge gaedo benema mi orega inda ge gaisera awa dorisira. Edo ge gaisera awa eiedo sisira, “Eiawa Iesu Jew embomei da gitijigari nembodiba.” ");
INSERT INTO nou_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Edo ge gaiari awa itido edo ungoi bengono embomei etoto awa benema mi orega etoto da dorisera. Edo uro ngambedo embo da awa Iesu da ingo be da edo nei awa Iesu da ingo anda da awodo orega da dederisera. ");
INSERT INTO nou_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Edo embo ave puma derigurise mani mani edo Iesu gandubedo iro jirido isera. ");
INSERT INTO nou_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Edo iro jirise sedo isera, “Inemi sedo isesa Jew embomei datumondebain ari oro awa arasegedo edo sekago iji tamonde de jigaso erarase sedo isesa. Edo imo Mamo da mei gido orega dodo wosedo imo imosuka kondade eio.” ");
INSERT INTO nou_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Edo ungoi awodo seoro da awodo priest gitijijigegari de edo agodari atopatari embomei de Jew embo nembogambo de mi Iesu ganduburise sedo isera, “Umo embo nenei soregedo ira te umo umosuka soregari sago ae ira giwo. ");
INSERT INTO nou_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Edo umo mo Jew embomei da gitijigari ta? Edo umo orega awa dodo wosadira awa nango umo gebe adera. ");
INSERT INTO nou_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Edo umo sedo ira umo awa Mamo da mei edo umo Mamo tumonda edo ira. Edo Mamo umo kondade ari dipapa ita mo aeri awa ingode gore.” ");
INSERT INTO nou_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Edo da awodo bengono embo etoto daedo benema mi orega da dorisera amimi Iesu da yei biae sisira. ");
INSERT INTO nou_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Edo iji soropu da busu berari awa umenga mi gajisira. ");
INSERT INTO nou_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Edo ongobo soropu da waiko sekago janibetiri Iesu gogo dimbusira, “Eli Eli lema sabachthani?” Ainda be awa, “Naso Mama Naso Mama ro edo na dotesi?” ");
INSERT INTO nou_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Siri embo nenei derido atisira amimi ingido sisira, “Elijah jawo sira.” ");
INSERT INTO nou_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sedo embo da mi sumbudo openga budo ribe grape da ngamo tokaka ainda patido ituka da digido Iesu da yei jijigurisera edo Iesu mi indarase sisera. ");
INSERT INTO nou_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Awarate embo nenei mi sisera, “Elijah mi bugudo umo kondade eita mo adi aeri? Simba eu ingode gore.” ");
INSERT INTO nou_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sedo simba ero Iesu sekago gogo dimbudo uso asisi Mamo da yei itido edo bebetisira. ");
INSERT INTO nou_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Edo Iesu betetiri bo nembodiba Jew embomei da tumondebain ari oro da yei ewamei be gajari awa tuturo inda edo keredo wosedo tuda bugusira. ");
INSERT INTO nou_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Edo busu didira isira edo ganuma bejisira edo kokombo be pirigetiri edo Mamo da embo jiwae matu bebetegari awa Mamo mi etiri ungoi ungoda kokombo dodo wasiri de eririsera. ");
INSERT INTO nou_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Edo ainda amboda Iesu wasiri de eriri embomei awa Jerusalem torero embo jiwae mi ungo gosisera. ");
INSERT INTO nou_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Edo isoro da gitijigari de isoro embomei de Iesu ditini ise atisera amimi busu wasiri isira edo ro berari isira awa gido ungoi oju edo sisera, “Gebe umone be Mamo da mei ra.” ");
INSERT INTO nou_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Edo embo evetu jiwae Galilee busu dodo Iesu kondade adi bugusera awa aike anumbedo atise ditini isera. ");
INSERT INTO nou_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Edo ainda teda awa Mary Magdalene edo Mary James de Joseph de da ai edo Zebedee da memei da ai de mi atisera. ");
INSERT INTO nou_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Edo ongobo etiri embo rora jiwae embo Arimathea busu da amimi uso jawo Joseph umo awa Iesu da ambojimbi da amimi bugusira. ");
INSERT INTO nou_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Bugudo Pilate da yei mambudo Iesu da tamo awa itari badi benunu sisira. Benunu setiri Pilate mi setiri Iesu da tamo itero Joseph mi burisira. ");
INSERT INTO nou_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Edo Iesu da tamo itero budo Joseph mi bo seka mi dogedo Iesu da Tamo awa Joseph unemi meko da kokombo uso ingo mi seka be seka isira ainda ititisira. ");
INSERT INTO nou_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Edo Joseph mi ganuma nembodiba awa budo bunini setiri meko uso be awa gajisira. Gajedo awodo dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Edo Mary Magdalene de edo Mary nei de awa meko kokombo benei da anumbedo atisera. ");
INSERT INTO nou_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Edo bondo sia ari iji awa atae etiri sipo de priest gitijijigegari de Pharisee embomei de mi Pilate ga dada edo Pilate da yei sisera, “Gitijigari nango kotemburera atise gebusari embo mi sisira iji tamonde atae ari na sekagoeradena sisira awasedo seio kokombo be awa iji tamonde atiroro simba edo gogo ore. ");
INSERT INTO nou_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Doro uso ambojimbi mi uso tamo awa bengono edo seore Iesu re betedo sekago erira. Edo umo matu ge busisira awarate ge busari eiawa be biae be ra. ");
INSERT INTO nou_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Setero Pilate mi ungoda yei sisira, “Simba ari embo budo mambudo kokombo awa simba edo gogo ewo.” ");
INSERT INTO nou_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Setiri ungo Pilate dodo mambudo ganuma awa esi mi yise genibedo puse genibedo edo etero okain etiri ungo simba ari embomei simba orase dodo ungo mambusera. ");
INSERT INTO nou_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Edo Jew embomei da tumondebain ari iji atae etiri Sunday sipo be sipo de Mary Magdalene de evetu nei Mary ainde mi kokombo gadi mambusera. ");
INSERT INTO nou_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Edo iji ainde busu wasiri adi tuturo isira. Edo Mamo da asisi ewamei awa utu dodo wowosisira. Wosedo ganuma misetiri mambiri ainda tamo da anumburisira. ");
INSERT INTO nou_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Edo uso gari awa gari teta birigi inge edo uso ombari awa parara teta aginya da tamo da awodo. ");
INSERT INTO nou_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Edo simba ari embomei asisi ewamei awa gido oju mi bebegae edo dudu gasedo ambae sumbae isera. ");
INSERT INTO nou_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Edo asisi ewamei ainda anumbedo emboevetu da yei sisira, “Oju eove. Na gosena ingo Iesu benema mi orega da doritara awa eura ewa te Iesu re einda atae ra ainda be awa umo sekago wasiri de erira unemi sisira da awodo. ");
INSERT INTO nou_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Edo yei umo pasido atari jirira awa puwo gave. ");
INSERT INTO nou_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Edo ingo burigi mambuwo. Mambudo uso ambojimbi da yei save Iesu betedo wasiri de sekago erira. Erido umone giti giti Galilee busu da mambutira edo umone ainda gadewa sewo. Edo na ro setena awa kotewo.” ");
INSERT INTO nou_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Edo asisi ewamei awodo setiri embo evetu awa kokombo awa dodo oju isera te daedo iaviri isera edo ungoi burigi be Iesu da ambojimbi soro gorase sumbusera. ");
INSERT INTO nou_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Edo ungo sumbero Iesu mi ungo tambudo sisira, “Bugutewa.” Setiri ungo uso yei bugudo uso tei da jigido ungoi Iesu tumondebain isera. ");
INSERT INTO nou_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Edo Iesu mi sisira, “Oju eove ta mambudo naso otatao awa sewo Galilee busu da mambore edo ainda ungo na gadera sewo.” ");
INSERT INTO nou_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Emboevetu awa mambutero isoro embomei etoto ungo kokombo simba ise atisera awa engenembedo nati da mambusera. Edo mambudo ro berari isira awa ungoi priest gitijijigegari da sisera. ");
INSERT INTO nou_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Edo priest gitijijigegari de Jew embo nambogambo de dada edo ro eri awa kasisera. ");
INSERT INTO nou_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Edo ungoi ge dada sedo isoro embomei da yei gano nembodiba be itido sisera, “Sewo uso ambojimbi mi nango ewo ero tumba de bugudo uso tamo awa bengono edo budo mambera sewo. ");
INSERT INTO nou_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Edo Rome embomei da gitijigari ro etira awa ingido sari nango mi ge eiawa soro gido umo mana ingoda yei riroga mana itadira.” ");
INSERT INTO nou_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Setero simba ari embomei gano awa budo ro priest gitijijigegari mi sisera awa isera. Edo iji ainde edo bugudo boroko da awodo Jew embomei da awodo kiki da awodo awa sedo era. ");
INSERT INTO nou_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Edo ambojimbi 11 awa doriri Galilee busu da ainda Iesu mi mamborase sisira ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Edo ungoi Iesu gido Iesu tumondebain isera awarate embo nenei awa mana mana isera. ");
INSERT INTO nou_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Edo Iesu mi asusubedo bugudo ungoda yei sisira, “Mamo mi naso yei goroba nembodiba itira awasedo nanemi rora berari awa simba ena edo embo berari utu da atera ainde busu da atera ainde simba ena. ");
INSERT INTO nou_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Awasedo busu berari da embo atera ainda mambuwo. Edo ingo Mamo da binga awa sewo edo awo naso ambojimbi ore. Edo ungo naso ambojimbi oro Mamo de uso Mei de Asisi Kotopu de da jawo da ewamei ewo. ");
INSERT INTO nou_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Edo ewamei edo ro berari nanemi ingoda yei setena awa atopatiwo. Edo utu de busu de awa atae adira te na awa ingode iji natopo atadena.” ");
INSERT INTO nou_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Binga ewamei eiawa Iesu Keriso God da mei da jawo da eiawa kiki tuturo ra. ");
INSERT INTO nou_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God da binga sari embo Isaiah mi gaisira, “God mi sisira, ‘Eiawa giwo. Na iso giti da naso binga sari embo itano iso emboro pirigadi mambadira. ");
INSERT INTO nou_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Edo unemi yei dumbari da atise unemi gogo dimbudo sadira gitijigari da emboro ewo dambuderari edo umo embo sia ewo sadira.’” ");
INSERT INTO nou_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Awasedo John bugudo dumbari da atise iji berari embo awa umo mi ewamei ise edo uso binga awa minonu sedo isira. Edo John embo da yei minonu sedo isira, “Ingo ingoda wasiri bebegae awa dodo God da yei wareregadewa awa God mi ingoda wasiri bebegae awa kotembedo doadira edo nanemi ingo umo mi ewamei adena.” ");
INSERT INTO nou_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Edo Judea embomei de Jerusalem nati embomei de awa John da ge ingadi mambudo isera. Edo ungoi geawa ingido ungoi ungoda wasiri bebegae awa bejoro edo John mi umo Jordan ainda umo mi ewamei edo isira. ");
INSERT INTO nou_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Edo John wo jawo camel da tu awa piredo bo edo wo ando mi sini edo isira. Edo John uso indari awa sopika de mumuni de ra. ");
INSERT INTO nou_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Edo John umo embo da yei minonu sedo isira, “Na awa embo nembodiba aera awarate embo da amboda bugadira awa embo nembodiba be ra. Edo na awa ewa raro uso tei goru simba eni? ");
INSERT INTO nou_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Edo na awa umo mi ingo ewamei ena te unemi ingo awa Asisi Kotopu mi ewamei adira.” ");
INSERT INTO nou_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Edo iji tupo Iesu Nazareth nati busu Galilee da awa dodo bugusira. Bugiri John mi umo Jordan da umo mi ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Edo umo mi ewamei etiri Iesu umo dodo vivitiri utu pirigetiri Asisi Kotopu teta ri ribo inge mi uso yei wowosiri gosisira. ");
INSERT INTO nou_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gido umo utu da edo ge sisira awa ingisira edo sisira, “Imo awa naso mei da awa dubo burena. Edo imo ro esa amimi na dubo ewamei ena.” ");
INSERT INTO nou_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Edo awa setiri edo Asisi Kotopu mi Iesu budo yei embo atae ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Edo Iesu ainda iji 40 atiri Satan mi Iesu iji berari bagedo isira. Edo ambe wo jiwae yima puma edo isera te asisi ewagaewa mi bugudo Iesu kondade isera. ");
INSERT INTO nou_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Edo gitijigari nembodiba Herod mi John bundari oro da itiri Iesu Galilee busu da mambudo God da binga ewamei awa sisira. ");
INSERT INTO nou_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Edo Iesu mi sisira, “Iji ro God mi sisira awawa bugiri God gitijigadi tuturo etira. Awasedo ingoda wasiri bebegae awa dodo wareregedo edo binga ewamei awa gebe ewo.” ");
INSERT INTO nou_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Edo Iesu Galilee umo bengi da pepeta ise wo oiro embomei etoto Simon de uso namendi Andrew de wo berero gosisira. ");
INSERT INTO nou_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Gido Iesu mi ungoda yei sisira, “Na ambo ambo ewo edo nanemi ingo awa rawodo embo badevi awa atopatadena. Ano embo berari embo ave edo ungoi naso ambojimbi ore.” ");
INSERT INTO nou_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Setiri iji ainde namendi namendi ga komboro dodo Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Edo kiambu yarago ise Iesu nanonamendi nenei etoto gosisira James de uso ambo John de ungo awa Zebedee da memei. Edo ungo awa nga da anumbedo komboro to ise atisera. ");
INSERT INTO nou_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Edo Iesu ungo gido jawo sisira. Setiri ungoi ungoda mamo de buro embomei de nga da dodo Iesu ga da mambusera. ");
INSERT INTO nou_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Edo Iesu ambojimbi de Capernaum nati da bugudo edo Jew embomei da tumondebain ari iji awa bugiri gido Iesu Jew embomei da dada ari oro da mambusira. Mambudo torido Iesu embo atopapotisira. ");
INSERT INTO nou_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Edo Iesu atopapotiri embomei Iesu da atopatari ingisera awa kove be isera ko Iesu atopapotira awa agodari da atopapotegari mi atopapotido era awodo aera te goroba de da atopapotira awasedo. ");
INSERT INTO nou_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Edo iji ainde embo da asisi biae mi sirari awa bugusira. ");
INSERT INTO nou_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Bugudo gogo dimbudo sisira, “Iesu Nazareth nati embo mo nangoda yei ro adi dipapa esi? Imo nango usibesi adi bugesi ta? Na imo gosena. Imo awa God da binga sari embo ewamei be ewamei.” ");
INSERT INTO nou_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Setiri Iesu mi asisi biae da yei ge okain sisira, “Ge do. Edo embo awa dodo arapa da bugu.” ");
INSERT INTO nou_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Setiri asisi biae embo awa budo yakawo yakawo edo gogo de embo awa dodo mambusera. ");
INSERT INTO nou_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Edo asisi biae arapa da bugiri embo berari mi kove edo ungosuka mina sara isera, “Eiawa rori? Eiawa atopatari seka ta? Embo eiawa goroba de asisi biae da ge siri edo umo ro sira awa ungo era.” ");
INSERT INTO nou_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Awasedo Galilee busu berari da Iesu ro isira awa berari binga ingisera. ");
INSERT INTO nou_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Edo Iesu uso ambojimbi de Jew embomei da dada ari oro awa dodo ungoi James de John de daedo Simon de Andrew de da mando da mambusera. ");
INSERT INTO nou_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Edo ungo mando da torido ungoi Iesu da yei sisera Simon da umboti awa karu yauya budo besi da atira awa sisera. ");
INSERT INTO nou_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Edo Iesu evetu ainda yei mambudo uso ingo da jigiri evetu awa eririsira. Edo evetu eriri yauya umo doturisira. Etiri umo ewamei isira. Edo ewamei edo indari sia edo Iesu uso ambojimbi de da yei ititisira. ");
INSERT INTO nou_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Edo ongobo etiri karu embo berari de embo asisi bebegae mi jo sirari awa embo mi budo Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Edo nati embomei berari awa mando be da dada isera. ");
INSERT INTO nou_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Edo ungoi dada etero Iesu mi embo karu neinde kainde mi karu edo isera awa euri jebugedo isera edo daedo asisi bebegae onduri mambudo isera. Edo asisi bebegae Iesu awa averi awa garira awasedo Iesu ungo beitigeuri ungo ge sari ato jaredo isera. ");
INSERT INTO nou_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sipo be sipo de yei isaga ae atiri Iesu erido nati dodo mambusira. Mambudo yei jamo jamo ainda God ga da ge sadi mambusira. ");
INSERT INTO nou_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Awarate Simon de uso otatao de awa mambudo Iesu eura isera. ");
INSERT INTO nou_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eura edo Iesu tambudo uso yei sisera, “Embo berari imo eura era.” ");
INSERT INTO nou_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Setero Iesu mi mina sisira, “Ingode na nati berari ainda mambadera ainda be awa na nati berari ainda embomei ainda embomei ainda binga daedo sadi bugena.” ");
INSERT INTO nou_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Awasedo Iesu nati berari Galilee busu da ainda tembuse Jew embomei da dada ari yei da binga sise edo asisi bebegae ondise tembuma isira. ");
INSERT INTO nou_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Edo embo da karu jawo leprosy bari amimi Iesu da yei bugudo baingo dederi edo umo kondade arase benunu sisira. Edo sisira, “Imo na kondade ari dipapa adesa awa na aso ewamei adena.” ");
INSERT INTO nou_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Setiri Iesu embo awa jo etiri gido Iesu mi mina sisira, “Na imo kondade ari dipapa ena. Iso tamo ewamei are.” ");
INSERT INTO nou_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Setiri iji da amimi karu awa atae isira etiri embo awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Edo Iesu mi embo awa itiri mambutiri ge tini javi de uso yei sisira, “Gio. Na iso yei ro etena awa embo nenei da yei saso geore ta dambuderari priest da yei mambuio. Mambaso unemi iso tamo awa gido ewamei etesi ta ko ewamei aeri awa gare. Imo ewamei edo edo imo ewamei etesa awa embo mi gorase sedo awa rorou ro Moses mi itorase sisira awa itio.” ");
INSERT INTO nou_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Setiri beuso edo mambuse embo jiwae da yei ro isiri awa sisira. Edo embo awa ge jiwae sisira awasedo Iesu nati ainda torae doturisira. Edo doturisira ainda mina awa umo yei embo atae ainda atiri embo jiwae be jiwae mi umo gadi ainda bugusera. ");
INSERT INTO nou_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iji roinge atae etiri ainda amboda Iesu uso mando da Capernaum nati da engenemburisira edo embo jiwae be Iesu bugari binga ingisera. ");
INSERT INTO nou_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ingido embo jiwae be bugudo mando de mando gaga de awa embo mi ato ae be isera. ");
INSERT INTO nou_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","4","Edo Iesu embo atopapotiri embo ingo kopiri patido amimi embo tei ingo ambari awa budo Iesu da yei bugusera te yei awa ato ae etiri gido ungo torari sago ae isera. Awasedo ungo mi embo awa budo mando sa beraga da vivitisera. Edo vitido Iesu rawainda atisira yei ainda sisoro to isera. Edo to isera edo to edo esi mi embo ainda ewari besi da mendo digido edo embo awa mando joda itero wowosisira. ");
INSERT INTO nou_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Edo Iesu ungo gebe nembodiba era awa gido embo tei ingo ambari ainda sisira, “Naso mei iso wasiri biae kotembedo dotena.” ");
INSERT INTO nou_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Setiri agodari da atopapotegari nenei ainda anumbedo atisera amimi kotisera, “Embo awa God da yei ge biae setira ainda be awa umo setira umo embo da buria kotembedo doadira awa setira. Edo God mi wasiri bebegae kotembedo doadira te embo mi mana wasiri bebegae kotembedo doadira.” ");
INSERT INTO nou_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Edo awodo kotero Iesu gido gido ungoda yei sisira, “Ingo ro awasedo ge awodo kotevi? ");
INSERT INTO nou_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Edo na ge ro seni? Na iso wasiri bebegae kotembedo dotena seni ta ko na erido iso ewari besi bojedo budo mambu seni? Edo ge etoto einda teda ge isaga mo ro seni? ");
INSERT INTO nou_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na ingo mi gawase dipapa ena God da mei bugudo embo isira awa busu da goroba ari burisira wasiri bebegae kotembedo doare.” ");
INSERT INTO nou_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Awasedo Iesu ge awa sedo embo tei ingo ambari da yei sisira, “Na iso yei sena erido iso ewari besi budo iso mando da mambuio.” ");
INSERT INTO nou_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Setiri ungo berari ditini ero embo awa erido uso ewari besi budo burigi be mambusira. Edo Iesu awodo etiri ungo berari kove be edo God jasiga ise sisera, “Eiawa nangoda tuturo da wasiri eiedo awa getera.” ");
INSERT INTO nou_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu engenembedo Galilee umo diuga da kora da mambiri embo jiwae be bugero Iesu ungo atopatadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Edo Levi tax bari embo Alphaeus da mei awa uso tax bari oro da anumbedo atisira. Edo Iesu pepeta ise embo awa gosisira. Gido Iesu Levi da yei sisira, “Na ambo ambo eio.” Setiri Levi erido Iesu ambo ambo isira. ");
INSERT INTO nou_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Edo amboda Levi da mando da Iesu uso ambojimbi de indari indise atisera. Edo embo neinde kainde mi Iesu ambo ambo isera awasedo tax bari embo jiwae edo embo bebegae jiwae awa Iesu uso ambojimbi de daedo anumbedo indari indise atisera. ");
INSERT INTO nou_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Edo agodari atopapotegari embomei jawo Pharisee nenei mi Iesu tax bari embomei de embo bebegae de dada anumbedo indari indiri gido Iesu da ambojimbi da yei nganega isera, “Ro awasedo Iesu embomei ounde indari indiri?” ");
INSERT INTO nou_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Setero Iesu ungoda ge awa ingido ungoda ge mina sisira, “Ari jegugari embo awa embo karu ae ewamei atira ainda yei mana mambadira te umo embo karu edo atira ainda yei mambadira. Da awodo na embo ewagaewa awasedo bugaera te na embo jimbo bebegae awa jawo sadi bugusena.” ");
INSERT INTO nou_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Iji nei John da ambojimbi de Pharisee embomei da ambojimbi de God tumondebain edo gogo edo adi sedo ungo indari neta edo isera. Edo ungo indari neta ero embo nenei mi Iesu da yei bugudo nganega isera, “John da ambojimbi de Pharisee embomei da ambojimbi de neta edo era awasedo iso ambojimbi neta ae edo eri?” ");
INSERT INTO nou_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Setero Iesu umo uso engenembedo utu da mambari awa kotise mina sisira, “Ingo kotewa jimbari bondo da esega ira embo awa neta edo ita? Awodo aera. Edo jimbari susu awa ainda atadira awa ungo neta adi aera. ");
INSERT INTO nou_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Awarate amboda jimbari susu awa mabadira awa ungo neta adera. ");
INSERT INTO nou_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Naso atopatari awa seka. Na ingoda yei kiki etoto sano gido eiawa gadewa. Embo da amemi mana bo seka da begiti mi bo matu da to awa tauta adira. Awodo adira awa umo bo awa segadira awa bo seka da begiti awa kiambu ise bo matu awa jumbari bo awa keradira. Edo awodo keradera amimi awa to nembodiba adira. ");
INSERT INTO nou_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Edo embo da amemi mana ribe da ngamo jawo wine seka awa utingi wo ando mi ari matu ainda mana itadira ko wo ando matu awa mana jitugadira awasedo wine awa porokusedo sauma utingi wo ando matu mi ari awa bejadira. Edo awodo adira awa utingi wo ando matu mi ari ainde umo jawo wine seka de awa usibesi adira. Awodo aera embo awodo adi aera te umo wine seka awa utingi wo ando seka mi ari ainda itadira.” Edo Iesu awodo setiri embo mi kotisera ungo mana Iesu da atopatari awa ungoda ari barari mamatu ainde dada adera awa gosisera. ");
INSERT INTO nou_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","24","Edo Jew embomei da tumondebain ari iji de Iesu uso ambojimbi de pisa buro joda awodo pepeta ero Iesu da ambojimbi mi pisa sari awa burero gido Pharisee embomei mi Iesu da yei sisera, “Gi ro awasedo iso ambojimbi nangoda tumondebain ari iji da agodari awa bebejeri?” ");
INSERT INTO nou_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Setero Iesu mi mina sisira, “Ingo kiki David de uso otatao de ungo beji tambudo isera da iji de awa ingo ajigedo garira. ");
INSERT INTO nou_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iji ainde awa Abiathar awa priest da gitijigari atiri David Jew embobo da tumondebain ari oro bo mi ari ainda torido ambe God da kando itido isera awa indisira. Edo ingodenaso agodari mi sira awa priest mi rorou indari awa indadera te embo nenei mi mana rorou indari eiawa mana indadera. Awarate David indari eiawa indisira edo uso otatao daedo itiri indisera.” ");
INSERT INTO nou_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesu awodo sedo umo sisira, “God embo da yei ewamei adi dipapa ira gido umo Jew embomei da tumondebain ari iji eiawa isira. Edo God embo awa tumondebain ari iji awasedo ae isira. ");
INSERT INTO nou_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Awasedo na God da mei embo isena awa goroba atira awasedo embo mi tumondebain ari iji de ro adera awa sadera.” ");
INSERT INTO nou_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu Jew embomei da dada ari oro da mambudo embo da ainda gosisira uso ingo awa ambari. ");
INSERT INTO nou_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Edo Pharisee embomei ainda atisera awa Iesu bekuba ari dipapa edo gido Iesu diti jimba isera edo umo embo ingo ambari awa Jew embomei da tumondebain ari iji de ari ewamei eita awa gadi. ");
INSERT INTO nou_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Edo ungo ditini ero Iesu mi embo ingo ambari da sisira, “Naso yei po.” ");
INSERT INTO nou_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sedo Iesu mi embomei da yei sisira, “Ingodenaso agodari mi tumondebain ari iji de ro orase siri? Ingodenaso agodari mo sita embo da yei ewamei ari itadera mo awata ko embo da yei biae orase siri? Edo ingodenaso agodari mi embo kondade oro ewamei eita ko ingodenaso agodari mi ingodena embo awa kondade ae doro betarase siri?” Setiri ungo ge da nei ro sae isera. ");
INSERT INTO nou_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ge sae etero Iesu ungo gido umo tini gambari isira te iji da ainde awa Iesu embomei awa gido umo jo isira ko ungo awa embo jo okain de awasedo. Edo Iesu mi embo ainda yei sisira, “Iso ingo besugeio.” Setiri embo awa uso ingo besuguriri uso ingo awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Awasedo Pharisee embomei Jew embomei da dada ari oro awa dodo gitijigari Herod da ambojimbi de dada isera. Dada edo ungoi Iesu doro betarase kiki dirisera. ");
INSERT INTO nou_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu uso ambojimbi de Galilee umo da mambutero embo jiwae be umo ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Embomei eiawa Galilee busu de Judea de Jerusalem nati de Idumea busu de edo busu umo Jordan be neinda ainde edo busu Tyre nati demonda ainde Sidon nati de awa dodo bugusera. Edo embo jiwae be eiawa Iesu ro ira ainda binga awa ingido gido ungoi Iesu gadi bugusera. ");
INSERT INTO nou_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ungoi bugero Iesu setiri uso ambojimbi nga sia isira umo embo ko embo jiwae be mi Iesu umo awa misoro umo da wosadiri ta rora sedo. ");
INSERT INTO nou_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Edo Iesu embo jiwae be etiri ewamei isera awasedo embo nenei misoro demonda yeoro Iesu da yei Iesu jigadi bugudo isera. ");
INSERT INTO nou_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Edo embo asisi bebegae mi sirari Iesu gido embomei eiawa Iesu da jo da durido gogo dimbudo sedo isera, “Imo awa God da mei.” ");
INSERT INTO nou_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Seoro Iesu tini gambari de asisi bebegae da yei umo embo averi awa seorase sedo isira. ");
INSERT INTO nou_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu doriri da vitido unemi embo dipapa edo isira awa uso yei setiri bugusera. ");
INSERT INTO nou_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Edo ungo uso yei bugero Iesu embo 12 awa kataburisira edo jawo Iesu da binga atopapotegari embomei awa ungoda yei ititisira. Edo Iesu ungoda jawo awa itido Iesu ungoda yei sisira, “Nanemi ingo nangae atawase katabetena. ");
INSERT INTO nou_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Edo daedo nanemi ingo itano mambudo binga sadewa edo nanemi ingoda yei goroba ari itano asisi bebegae ondawo bugujegadera.” ");
INSERT INTO nou_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Edoembo 12 Iesu mi kataburisira ainda jawo re Simon uso jawo nei Iesu mi ititisira Peter edo Zebedee da memei James de John de awa Iesu mi jawo nei ititisira Boanerges ainda be awa duberi dimbari embo edo Andrew de Philip de Bartholomew de Matthew de Thomas de James awa Alphaeus da mei de Thaddeus de Cana busu embo Simon de Judas Iscariot indiga sisira embo ainde. ");
INSERT INTO nou_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Edo Iesu nati da mambiri embo jiwae be mi sekago mando da dada etero gido Iesu uso ambojimbi de indari sia ari sago ae isera. ");
INSERT INTO nou_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Edo Iesu da orobe ge awa ingido sisera Iesu jiro biae etira awasedo nango Iesu bari dipapa era. ");
INSERT INTO nou_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Edo agodari da atopapotegari mi Jerusalem nati dodo bugudo sisera, “Asisi bebegae da gitijigari Beelzebul awa Iesu da jo da atima ira amimi Iesu da yei goroba itiri asisi bebegae ondiri ijegurera.” ");
INSERT INTO nou_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Setero gido Iesu embo jawo setiri uso yei bugusera. Bugero Iesu ungoda yei inia da mi kiki sisira, “Satan rawodo edo umo umosuka ondari ponda bugae etiri? ");
INSERT INTO nou_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Busu da embo awa ungosuka diti diti edo embogo mina ara ae etera busu ainda embo awa atae ae etera. ");
INSERT INTO nou_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Edo embo orobe da amimi ewoga ewoga edo embogo mina ara ae etera orobe awa atae ae etera. ");
INSERT INTO nou_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Da awodo Satan da buro ari embomei awa ewoga ewoga ae etera awa ungo atae ae etera. ");
INSERT INTO nou_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Embo amemi goroba embo da mando bejedo torido uso rora bengono adi dipapa adira embo awa giti goroba embo awa ingo tei bundedo awa adira. Bundedo atae edo awa goroba embo ainda rora awa bengono ae etira. ");
INSERT INTO nou_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","“Eiawa giwo. God mi embo da wasiri bebegae berari de edo ge bebegae sedo ira awa kotembedo doadira te embo amemi Asisi Kotopu da yei biae sadira awa God mi mana embo ainda wasiri bebegae awa mana kotembedo doadira ainda be awa embo awa wasiri biae matawa atari wasiri biae awa etira awasedo.” ");
INSERT INTO nou_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Edo embo nenei mi sisera asisi bebegae mi Iesu da yei atima ira awasedo Iesu ge eiawa sisira awa sisera. ");
INSERT INTO nou_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesu da ai de nanonamendi de bugudo ponda simba atise Iesu gadi dipapa isera edo binga itero Iesu da yei mambusira. ");
INSERT INTO nou_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Edo embo jiwae Iesu ga da atisera amimi Iesu da yei sisera, “Gi iso ai de nanonamendi de ponda imo gadi simba atera.” ");
INSERT INTO nou_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Setero Iesu mi mina sisira, “Naso aia de nanonamendi de mo averi?” ");
INSERT INTO nou_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sedo embo daga atisera awa gido ungoda yei sisira, “Giu emone naso aia de nanonamendi de ra. ");
INSERT INTO nou_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Embo ave God mi ro orase dipapa ira awa era embo amone naso aia de ru aimono de nanonamendi de ra.” ");
INSERT INTO nou_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu sekago Galilee umo bengi da atopatadi tuturo isira. Edo embo jiwae be dada etero gido Iesu nga da wosedo anumburisira. Edo nga awa umo da peko peko iri edo embo awa bengi da dederigurisera. ");
INSERT INTO nou_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Edo Iesu inia ge mi rora jiwae embo atopapotisira. ");
INSERT INTO nou_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Edo Iesu awodo atopapotise ungoda yei sisira, “Eiawa giwo. Embo da ve gowadi mambusira. ");
INSERT INTO nou_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Edo umo uso buro joda awodo mambuse ve awa ingo da budo pigedo jiroroka isira. Edo ve nenei awa emboro da wowosisira etiri rimei wosedo atae indisera. ");
INSERT INTO nou_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Edo ve nenei awa ganuma tamo da busu kiambu atiri ainda wowosisira. Wosedo ve awa burigi eririsera te busu awa nembo ae. ");
INSERT INTO nou_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Awasedo amboda waiko vitido ve seka awa ewusira. Edo ve uso besisi awa be wosae awasedo ve awa ambusira. ");
INSERT INTO nou_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Edo ve nenei awa bebe teda wowosisira. Edo ve bebe teda awa erido nembogambo isera awasedo ve seka bebe da teda awa erari bebegae erido be ewamei ae isera. ");
INSERT INTO nou_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Awarate ve nenei awa busu ewamei da wowosisera awasedo ewamei eririsera edo nenei awa be 30 isera nenei awa 60 edo nenei awa 100 isera.” ");
INSERT INTO nou_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Edo kiki sangove da Iesu mi embo da yei sisira, “Ingo embomei awa dengoro atira awasedo naso ge awa ingido gogo ewo.” ");
INSERT INTO nou_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesu umosuka anumbedo atiri embo nenei uso ge ingise atisera ainde uso ambojimbi 12 de mi uso yei bugusera. Bugudo Iesu da yei inia ge sisira ainda be awa ujugari gadi sedo nganega isera. ");
INSERT INTO nou_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Etero Iesu mi mina sisira, “God mi iji umo gitijigadira ainda tu ge awa ingoda yei isaga etira awarate embo nenei demonda awa nanemi inia ge mi atopapotena. ");
INSERT INTO nou_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ainda be awa eire, ‘Ungo mi sekago sekago gosera te gae jarera. Edo ungoi be gido awa ungoi God da yei wareregoro ungoda wasiri bebegae kotembedo doadira.’” ");
INSERT INTO nou_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Edo Iesu mi embomei da yei nganega isira, “Ingo inia kiki da be mo gosevi ta? Ingo inia kiki einda be gae adewa mo rawodo edo inia kiki nenei da be mo gevi?” ");
INSERT INTO nou_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Edo ve gowari embo amone God da ge govira. ");
INSERT INTO nou_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Edo emboro da ve nenei dudurisira amone teta embo jo okain de awodo ra. ");
INSERT INTO nou_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ungo God da binga ingoro Satan bugudo jo da binga awa bengono edo mambudo ira. ");
INSERT INTO nou_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Edo ganuma tamo amone teta embo God da binga dubo ewamei de da ingido edo iaviri de da budo era te ungoda gebe ari awa inono ae teta besisi tupo awa inono ae awodo ra. Edo wasiri biae edo dedo gaedo ari peuri ungoda gebe ari atae edo ira. ");
INSERT INTO nou_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Edo ve bebe teda dudurisira amone teta embo nenei binga ingido era te iji berari rora nenei awa kotedo era. ");
INSERT INTO nou_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Iji berari ungo rawodo edo rora seseka jiwae be bae etera awa kotedo era awasedo kotari emimi God da binga awa misuri mambudo ira. Edo eiawa euri embomei eiawa gebe ari inono ae awasedo ungo embo nenei kondade oro God gebe ari awa ae edo era. ");
INSERT INTO nou_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Edo ve busu ewamei da wowosisira amone teta embo God da binga ingido budo edo binga awa embo nenei da sedo era da awodo. Edo embo nenei awa embo 30 awodo kondade edo era edo embo nenei awa embo 60 awodo kondade edo era edo embo nenei awa embo 100 awodo kondade edo era.” ");
INSERT INTO nou_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Edo Iesu sekago inia kiki mi atopapotise sisira, “Embo amemi ou rokuvegedo goriwo tuda itido iri ko embo amemi goriwo budo ewari besi tuda itido iri? Awodo aera te embo goriwo budo era awa inda esegedo era. ");
INSERT INTO nou_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Embo amemi rora unjugadira awa amboda embo nenei mi tambudo isaga adira. Edo embo amemi rora ro awa gowadira awa amboda embo nei mi tambudo isaga adira. ");
INSERT INTO nou_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Edo ge eiawa ingiwo.” ");
INSERT INTO nou_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Edo Iesu daedo ungoda yei sisira, “Ingo ge ro ingadewa awa kotedo gogo ewo. Ingo gari ro betewa awa jingama edo gogo adewa awa God mi ingoda yei gari nei itadira. ");
INSERT INTO nou_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Edo embo ave naso ge ingido gogo adira awa jiro gari ewamei badira awarate embo amemi naso ge ingido gogo ae adira embo awa uso yei gari kiambu atira awa jajovegadira.” ");
INSERT INTO nou_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Edo Iesu atopapotise sisira, “God mi gitijigadira iji ainde ro adira amone teta embo mi ve buro da govetiri ro isira da awodo. ");
INSERT INTO nou_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Edo tumba de embo awa ewuri edo iji de embo awa buro euri ve awa erido isira. Edo ve awa eririra awarate rawodo eririri awa embo awa gae. ");
INSERT INTO nou_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Edo busu mi etiri ve awa erido be etira. Tuturo da awa igi bugadira edo pisa be awa adira edo ambo be amboda awa pisa be awa sari adira. ");
INSERT INTO nou_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sari ari embo awa bugudo pisa sari awa wujadira.” ");
INSERT INTO nou_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu mi sisira, “God da gitijigari iji awa rawodo sano gevi? Inia kiki ro sano gevi? ");
INSERT INTO nou_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God da gitijigari iji awa teta ri jawo mustard awodo uso ve awa kiambu be ra ve nembogambo awodo ae. Edo embo mi uso buro da gowadira awa erido ri nembodiba adira ri nenei awodo ae. ");
INSERT INTO nou_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Edo ri awa eririrari patu bugadira edo uso utumo awa nembodiba adira awasedo ri memei neinde kainde bugudo ungoda nganja itadera.” ");
INSERT INTO nou_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Edo eiedo da inia kiki jiwae da Iesu uso binga embo da yei atopatido isira. Edo embo uso ge da be moka awa gosero Iesu ungo atopapotisira te ungo uso ge da be moka awawa gae eoro re Iesu ungo atopatae edo isira. Amboda sekago tuturo adira. Edo iji berari Iesu inia ge mi embo atopatido isira. ");
INSERT INTO nou_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Edo Iesu ge nenei mi atopatae isira. Awarate Iesu uso ambojimbi de ungo ungosuka atise Iesu inia kiki da be awa ungoda yei sisira. ");
INSERT INTO nou_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iji ainde amimi ongobo iri Iesu uso ambojimbi da yei sisira, “Pou ingode umo jirora be nei da sembore.” ");
INSERT INTO nou_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Setiri ungo embo jiwae be awa dodo nga Iesu atisira ainde sembusera. Edo ungo nga da vitido Iesu ga da mambusera. Edo nga memeia nenei teda ainda ra. ");
INSERT INTO nou_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Edo iji tupo bisara nembodiba sumbadi tuturo isira edo umo nga da vitadi isira edo umo nga beda ari aikambu isira. ");
INSERT INTO nou_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Edo Iesu awa nga amboda beo guto gaedo ewo ise atisira. Edo ambojimbi mi umo ewo wujedo sisera, “Gitijigari imo nango indido ambadera awa kotae atesi ta?” ");
INSERT INTO nou_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Setero Iesu erido sisira bisara ge dodo jamo jamo eio edo umo awa dodo binono eio sisira. ");
INSERT INTO nou_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Edo awa etiri Iesu mi uso ambojimbi da yei sisira, “Ingo roedo oju etevi? Ingo na gebe ae ta?” ");
INSERT INTO nou_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Setiri uso ambojimbi oju edo mina sara isera, “Embo eiawa rawodo ri? Umo ge seuri umo de bisara de ro sira awa edo era.” ");
INSERT INTO nou_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Edo ungo umo jirora da sembudo Gadarene busu embomei da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Edo Iesu nga dodo wosedo embo da embo gowari meko awa dodo bugudo Iesu tambusira. ");
INSERT INTO nou_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Edo asisi biae mi embo einda joda aturi edo embo eiawa embo gowari meko da embo da uje teda atima isira. ");
INSERT INTO nou_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Edo iji jiwae be embo mi esi gavesi mi uso tei de ingo de digido isera te iji berari esi diugedo isira awasedo embo umo esi mi digari awa doturisera. Edo embo amemi embo awa beitigadi edo isera te inono ae edo isira ainda be awa embo awa goroba jiwae awasedo. ");
INSERT INTO nou_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Edoiji berari tumba de iji de umo uje be da tembuse edo doriri da tembuse umo gogo dimbuse ganuma mi umo umosuka divedo isira. ");
INSERT INTO nou_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","7","Edo embo awa aikambu bugudo Iesu gosisira awasedo sumbudo Iesu da jo da baingo mi durido gogo dimbudo sisira, “Iesu God da mei goroba de imo naso yei ro ari dipapa esi? Na God da jawo da sedo gosena naso yei riroga itose.” ");
INSERT INTO nou_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Edo Iesu asisi biae da yei sisira embo awa dodo mambuio sisira awasedo embo awa ge awodo sisira. ");
INSERT INTO nou_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Awasedo Iesu mi embo awa nganega isira, “Iso jawo rori?” Setiri embo amimi mina sisira, “Nango jiwae einda atera awasedo naso jawo awa jiwae ra.” ");
INSERT INTO nou_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sedo embo amimi Iesu da yei gegata isira asisi bebegae awa itari busu awa dodo mamborase sisira. ");
INSERT INTO nou_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Edo doriri demonda ainda awa pu jiwae be mutiro isera. ");
INSERT INTO nou_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Edo asisi bebegae mi Iesu da yei sisera, “Nango iti pu da yei mambore edo doio ungoda joda torore.” ");
INSERT INTO nou_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Setero Iesu mi setiri asisi bebegae embo awa dodo pu da joda totorisera. Edo pu berari ainda ajigari 2,000 awa sumbudo doriri da yei diwari awa dodo umo da kekepuinya edo indido ambujegurisera. ");
INSERT INTO nou_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Edo pu simba edo isira embo awa yei awa dodo burigi sumbudo mambudo buro da edo nati da ro isira awa sisera. Edo embo mi ge awa ingido ungo ungosuka mambudo ro isiri awa gadi mambusera. ");
INSERT INTO nou_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Edo ungo Iesu gadi bugudo ungoi embo asisi bebegae matu atima isera embo awa gosisera. Edo embo awa jamo jamo edo sini bo ewamei edo uso jiro ewamei de da atiri. Edo embo awa gido ungo oju isera. ");
INSERT INTO nou_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","17","Edo embo pu da edo embo da yei ro isira awa gosisera embomei amimi embo nenei setero gosisera awasedo embomei mi Iesu yei awa doarase sisera. ");
INSERT INTO nou_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Edo Iesu nga da vivitiri edo embo asisi bebegae joda atima isera embo amimi Iesu da yei doari daga mambadi gegata isira. ");
INSERT INTO nou_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Edo setiri Iesu mi sisira, “Awodo aera te engenembedo iso orobe da yei mambudo God iso yei ro etiri edo umo imo jo etira awa seio gore.” ");
INSERT INTO nou_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Setiri edo embo awa yei awa dodo yei jawo Decapolis ainda be awa nati 10 awodo mambuse Iesu mi uso yei ro isira awa embomei ainda yei sisira. Edo embo berari ge awa ingido ungoi kove be isera. ");
INSERT INTO nou_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Edo Iesu umo diuga da be nei da sekago sembiri embo jiwae be mi umo bengi da dada isera Iesu umo jiroroka edo. ");
INSERT INTO nou_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Edo Jairus Jew embomei da dada ari yei simba edo isira embo awa bugusira. ");
INSERT INTO nou_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bugudo Iesu gido Iesu da tei da baingo dederi edo uso goroba berari mi Iesu da yei gegeta isira, “Naso gagara karu etira awasedo nangae pogae. Mambudo iso ingo uso tamo da itaso umo ewamei are.” ");
INSERT INTO nou_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Setiri Iesu Jairus ga da mambusira. Edo ungo mambutero embo jiwae be daedo mambusera awasedo emboro awa embo mi ato ae etiri embo Iesu da demonda mina misa edo isera. ");
INSERT INTO nou_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Edo embo jiwae da teda awa evetu da gaeko 12 awodo karu orobi awa budo atima isira awa umo umosuka pusira. ");
INSERT INTO nou_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Edo evetu awa uso gano berari karu ari ewamei ari embomei da yei itido isira te ungomi evetu awa ari ewamei ari sago ae edo isera. Edo iji berari uso karu aturi umo karu biae be edo isira. ");
INSERT INTO nou_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Awasedo Iesu ro ira awa ingido Iesu da gun da bugudo evetu awa kotisira na Iesu da ombari begiti jigadena awa na ewamei adena awasedo evetu Iesu da ombari begiti da jijigurisira. ");
INSERT INTO nou_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jigido iji da amimi orobi awa atae isira. Edo orobi atae etiri umo uso joda kotisira na ewamei etena kotisira. ");
INSERT INTO nou_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Edo daedo Iesu burigi be gosisira goroba umo dodo mambira awa. Awasedo wareregedo embomei jiwae be ainda yei sisira, “Naso ombari begiti amemi jigiri?” ");
INSERT INTO nou_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Setiri uso ambojimbi mi mina sisera, “Imo gosesa embo jiwae be iso demonda mina misa era edo imo embo amemi jigiri awa roedo nganega esa.” ");
INSERT INTO nou_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Setero Iesu embo amemi umo jigiri awa gadi eura isira. ");
INSERT INTO nou_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Edo eura iri evetu uso yei ro etira awa gido oju mi biae ise bugudo Iesu da tei da baingo dederi isira edo Iesu da yei gebe sisira. ");
INSERT INTO nou_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Edo Iesu evetu ainda yei sisira, “Naso gagara imo goroba iso berari mi na gebe etesa awasedo imo ewamei etesa. Edo imo mana karu awa sekago badesa awasedo dubo ewamei de mambuio.” ");
INSERT INTO nou_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Edo Iesu eiedo sise atiri embo Jairus da mando da edo bugudo Jairus da yei sisera, “Iso gagara awa boroko betetira awasedo iso bouga berari awa atopatari da yei itido doio.” ");
INSERT INTO nou_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Setero Iesu ungo dodo Jairus da yei wareregedo sisira, “Oju eose ta na gebe eio.” ");
INSERT INTO nou_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sedo embo nenei awa yeorase gajedo umo Peter de James uso namendi John de awa budo mambusira. ");
INSERT INTO nou_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Edo ungo Jew embomei da dada ari oro simba ari embo Jairus da mando da bugudo Iesu embo yise puse ero edo embo ji sero ingisira. ");
INSERT INTO nou_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Edo Iesu mando jo da torido embomei da yei sisira, “Ro awasedo ingo wasiri eiedo evi? Ro awasedo ingo ji sevi? Gagara kiambu eiawa betaera te ewo ira.” ");
INSERT INTO nou_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Setiri embomei mi Iesu gandubedo iro isera awasedo Iesu embo itiri ponda mambero gagara da mamo de ai de ambojimbi tamonde de budo gagara da ewari yei da totorisira. ");
INSERT INTO nou_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Torido gagara kiambu da ingo da jigido sisira, “Talitha koum,” ainda be awa “Gagara kiambu na iso yei sena eri.” ");
INSERT INTO nou_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Setiri gagara burigi be erido pepeta adi tuturo isira. Edo gagara ainda gaeko awa 12. Edo wasiri eiawa etiri ungoi kove be isera. ");
INSERT INTO nou_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Edo Iesu mi ungoda yei ge tini javi de sisira, “Embo nenei ro etena awa sawo geore. Edo gagara kiambu indari itiwo indare.” ");
INSERT INTO nou_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Edo Iesu yei awa dodo uso ambojimbi de daedo engenembedo uso nati da mambusira. ");
INSERT INTO nou_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Edo Jew embomei da tumondebain ari iji bugiri Iesu embo atopatadi tuturo isira Jew da dada ari oro da. Edo embo jiwae uso ge ingise atisera awa kove be isera edo nganega mina ara isera, “Umo goroba berari eiawa rawainda beteri? Edo jiro gari emomo rawodo beteri? Edo wasiri nembogambo emomo rawodo iri? ");
INSERT INTO nou_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Umone ri ituka mi mando ari embo ra edo Mary da mei bego ra edo James de Joseph de Judas de Simon de awa uso nanonamendi ra. Edo uso ruaimono berari nati einda atima era.” Awasedo ungoi awodo sedo Iesu ujo ae isera. ");
INSERT INTO nou_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Edo Iesu mi ungoda yei sisira, “Embo nati nenei da awa God da binga sari embo awa sapo edo era te embo uso nati susu da ainde uso orobe de awa umo sapo ae edo era.” ");
INSERT INTO nou_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Edo Iesu uso nati be ainda awa karu embomei enumba ae awa ingo tamo da itiri jebugurisera te umo wasiri nembogambo awa ari sago ae isira. ");
INSERT INTO nou_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Edo Iesu awa kove be isira ainda be awa embo ainda mi umo gebe ae isera awasedo. ");
INSERT INTO nou_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Edo Iesu nati demonda ainda mambuse embo atopapotisira. Edo ambojimbi 12 jawo setiri dada etero etoto etoto itiri mambusera. ");
INSERT INTO nou_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Edo asisi bebegae ondari da goroba itido ungoda yei sisira, “Pepeta ari ketu budo edo tei goru asugewo awarate indari de kandea de gano de ombari nei de awa beove.” ");
INSERT INTO nou_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Edo Iesu daedo sisira, “Orobe da rawae ingo dipapa oro re ingo nati ainda atise gido ingo dipapa era orobe ainda mando da atiwo. Dodo mambudo mando orobe nei da ainda atove. ");
INSERT INTO nou_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Edo amboda nati nei embo mi ingo atega edo gogo edo ae edo ingoda ge ingae oro re ingoda tei janjara gajigedo dodo mambuwo. Edo ingo awodo adewa awa embomei gadera awa God mi riroga biae itadira ungoda jimbo biae awasedo.” ");
INSERT INTO nou_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Awasedo ambojimbi mambudo embo da yei sisera ingoda wasiri bebegae dodo God da yei wareregewo sisera. ");
INSERT INTO nou_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Edo ungo daedo asisi bebegae jiwae ondisera edo ungo karu embomei da kopiri da ngamo jawo oil jojedo edo eoro jebugedo isera. ");
INSERT INTO nou_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yei berari da embo berari ro Iesu mi ira awa binga ingisera awasedo gitijigari Herod daedo ingisira. Edo embo nenei mi sisera, “John umo mi ewamei ari embo betedo erido sekago wasiri de atise gido umo ari goroba de emone ira.” ");
INSERT INTO nou_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Awarate embo nenei mi sisera, “Amone Elijah ra.” Seoro embo nenei awa sedo isera, “Amone God da binga sari embo ra. Edo umo atopapotira teta God da binga sari embo matu atima edo isera awodo.” ");
INSERT INTO nou_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Edo Herod ge awa ingido sisira, “Umone John umo mi ewamei ari embo ra. Nanemi seteno dubo diugurisera awa ra te umo wasiri de sekago erira.” ");
INSERT INTO nou_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Edo Herod umo umosuka setiri uso buro embomei John budo ingo tei digido gajari oro da ititisera. Herod wasiri eiedo John da yei isira ainda be awa uso aro Herodias awasedo. Herod awa uso namendi Philip da aro Herodias awa jimbusira awarate Philip betae atiri. ");
INSERT INTO nou_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John eiawa gido Herod da yei iji berari sedo isira, “Iso namendi da aro awodo badesa amone imone nangoda agodari awa bejesa.” ");
INSERT INTO nou_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Edo John iji berari awodo seuri Herodias tini gambari edo John dari betarase dipapa isira awarate Herod awara sae edo isira. ");
INSERT INTO nou_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Edo Herod gari John awa embo ewamei be ewamei awasedo umo John oju edo isira edo simba edo gogo edo isira. Edo Herod John da yei dengoro edo isira ainda be awa umo dipapa edo isira awasedo awarate Herod umo iji jiwae be John da yei dengoro ise jiro jango indae edo isira. ");
INSERT INTO nou_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Awarate amboda Herodias da iji ewamei bugusira umo ro adi dipapa edo isira awa arase. Edo Herod da kumbari iji bugiri umo bondo nembodiba sia edo setiri Rome embomei da gitijijigegari de isoro embomei da gitijijigegari de Galilee busu da embo nembogambo berari de awa bugusera. ");
INSERT INTO nou_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bugero Herodias da gagara bugudo ya diwusira edo Herod de uso esega embomei de awa iaviri isera awasedo Herod gagara ainda yei sisira, “Imo kando ro dipapa esi? Imo ro dipapa adesa awa na iso yei itadena.” ");
INSERT INTO nou_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herod mi gagara ainda yei sari gari ge sisira, “Na sari gari ge mi sena imo ro naso yei sedo gadesa awa na iso yei itadena. Imo naso busu soropu da diugedo itanase sadesa awa itadena.” ");
INSERT INTO nou_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Setiri gagara uso ai da yei mambudo sisira, “Na ro dipapa edo seni?” Setiri uso ai mi mina sisira, “John da kopiri awa dipapa eio iso yei itare.” ");
INSERT INTO nou_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Setiri Herodias da gagara burigi mambudo Herod da yei mambudo sisira, “Na dipapa ena imo John da kopiri tewo da itido naso yei itio.” ");
INSERT INTO nou_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Setiri Herod awa dubo vevera isira te umo awodo aera sari ae isira ainda be awa embo berari ingero umo gagara da yei sari gari sisira awasedo. ");
INSERT INTO nou_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Awasedo Herod mi setiri isoro embomei mi bundari oro da mambudo ungoi John da dubo diugurisera. ");
INSERT INTO nou_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Diugedo tewo da itido budo bugusira. Bugudo gagara ainda yei ititisera. Edo itero gagara awa budo ai da yei mambudo ititisira. ");
INSERT INTO nou_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Edo John da ambojimbi binga awa ingido bugudo uso tamo budo gousera. ");
INSERT INTO nou_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Edo ambojimbi engenembedo Iesu ga dada edo ungoi ro atopapotisera edo isera awa uso yei da sisera. ");
INSERT INTO nou_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Edo embo jiwae be bugudo mambudo ero Iesu uso ambojimbi de indari sia ari sago ae isera awasedo Iesu mi uso ambojimbi da yei sisira, “Ingode yei embo ae da ingode nasuka mambudo ingo iji tupo jango indave.” ");
INSERT INTO nou_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Setiri ungo ungosuka nga de yei embo atae da mambusera. ");
INSERT INTO nou_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Awarate embo jiwae ungo mambutero gido ungo averi awa gosisera. Gido nati berari dodo tei mi mambudo yei ainda giti bugujegurisera. ");
INSERT INTO nou_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Edo amboda Iesu uso ambojimbi de bugusira. Edo ungo nga dodo wosedo ungoi embo jiwae be awa gosisera. Edo Iesu ungo gido ungo jo isira ko ungo awa teta wo sheep mi wo sheep simba ari embo ae inge awasedo. Awasedo Iesu ungo atopatadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Edo ongobo iri Iesu uso ambojimbi mi bugudo sisera, “Yei emone yei ro indae atae ra edo tumba jijirira awasedo embomei iti mambudo demonda buro da edo nati da indari ori ore.” ");
INSERT INTO nou_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Setero Iesu mi ungoda ge mina sisira, “Ingo mi indari itiwo indore.” Setiri ungoi Iesu da yei nganega isera, “Nango rawodo eri? Nango mi embo berari einda indari ori adi adera amone embo da da gaeko da da mina awa itadera.” ");
INSERT INTO nou_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Setero Iesu ungoda yei nganega isira, “Indari ingoda yei roinge atiri? Mambuwo gave.” Setiri ungo mambudo gido engenembedo uso yei sisera, “Ambe ingari 5 edo wo etoto atira.” ");
INSERT INTO nou_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Setero Iesu uso ambojimbi da yei sisira, “Sewo embomei diti diti sasawa da anumbore.” ");
INSERT INTO nou_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Setiri ambojimbi mi setero embo diti diti nenei diti da 100 nenei 50 awodo anumburisera. ");
INSERT INTO nou_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Edo ungo anumbetero Iesu ambe ingari 5 de wo etoto de budo diti utu da edo God ategurisira. Ategedo ambe ingari gavedo memeia edo memeia isira awa ambojimbi da yei ititise atisira. Edo Iesu ambe memeia isira awa ambojimbi da yei ititise atiri ambojimbi ambe memeia isira awa embo da yei ititise atisera. Edo ungoi wo de da awodo itisera. ");
INSERT INTO nou_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Edo embo berari indido inono etero edo ambojimbi mi momono doturisera awa dada isera. ");
INSERT INTO nou_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Edo dada isera awa kandea berari 12 awa beda isira. ");
INSERT INTO nou_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Edo embo ungoda ajigari awa 5,000 mi indari awa indisera. Edo emboevetu de kinapeina nenei de awa daedo ainda atisera. ");
INSERT INTO nou_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Edo Iesu setiri uso ambojimbi nga da vitido umo diuga be nei da giti giti mambusera. Edo Iesu daedo embomei awa itiri mambusera. ");
INSERT INTO nou_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Edo Iesu uso ambojimbi atega edo Iesu God ga da ge sadi doriri da vivitisira. ");
INSERT INTO nou_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Edo ongobo etiri Iesu umo umosuka doriri da atiri uso ambojimbi nga de bugudo umo diuga da soropu da isera. ");
INSERT INTO nou_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Edo Iesu ungo nga dawari da bouga era awa gosisera ainda be awa bisara nembodiba ungoda dombu da sumbira awasedo ungo yari sago ae isera. ");
INSERT INTO nou_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Awasedo sipo tu busedo piri yei umenga atiri Iesu umo tamo da pepeta edo uso ambojimbi da yei aikambu bugusira edo umo ungo derigadi aikambu isira te ungoi umo gido oju mi biae edo gogo dimbudo sisera, “Emone asisi ra.” ");
INSERT INTO nou_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Setero Iesu ungoda yei sisira, “Goroba ewo. Amone namona. Oju eove.” ");
INSERT INTO nou_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sedo Iesu nga da daedo vivitisira. Etiri bisara nembodiba atae isira. ");
INSERT INTO nou_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Edo ambojimbi nga da anumbedo atise ungo ge atae be isera. Ungo Iesu embo jiwae da yei indari ititisira awa gosisera te ungo Iesu mo averi awa gido gogo ae isera ainda be awa ungo Iesu gebe ari dipapa ae isera. ");
INSERT INTO nou_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Edo ungo umo diuga da sembudo Gennesaret busu da bugudo nga didigurisera. ");
INSERT INTO nou_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Edo ungo nga doturero embo Iesu gido umo averi awa gosisera. ");
INSERT INTO nou_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Awasedo nati berari da sumbudo karu embomei ungoda ewari besi da budo Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Edo Iesu nati kiambu da ta nati nembodiba da ta buro da ta awodo yima isira awa ungoda karu embomei budo ori garori ari yei da budo bugudo isera. Edo ungo budo bugudo ungoi karu embomei mi Iesu da ombari begiti jigido ewamei orase dipapa edo isera awasedo ungo Iesu mi awara sarase benunu sisera. Edo embo ave Iesu da ombari begiti jigido isera awa ewamei edo isera. ");
INSERT INTO nou_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Edo Pharisee embomei de agodari da atopapotegari de Jerusalem nati dodo bugudo Iesu jinenebedo dada isera. ");
INSERT INTO nou_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Edo ungoi dada edo Iesu da ambojimbi nenei awa indari indise atera awa gosisera. Awarate ambojimbi awawa Jew embomei da ingo segari da wasiri awa ae ero gosisera. ");
INSERT INTO nou_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Edo Pharisee embomei de Jew embomei berari de awa ungoda mamoumbogo da atopatari awa ambo ambo isera. Ungo indari indadi ise awa ungoda mamoumbogo da ingo segari da wasiri awa giti edo isera. ");
INSERT INTO nou_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Edo daedo indari ori ari yei da indari budo ungoda mamoumbogo da indari segari da wasiri awa edo isera. Edo daedo tewo adego segari da agodari de ewari besi segari de da agodari awa ambo ambo edo isera. Edo daedo ungo mamoumbogo da agodari nenei awodo awa ambo ambo edo isera. ");
INSERT INTO nou_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Awasedo Pharisee embomei de agodari da atopapotegari de mi Iesu da yei nganega isera, “Ro awasedo iso ambojimbi nangoda mamoumbogo da wasiri awa ambo ambo ae eri? Ro edo indari indae giti da nangoda mamoumbogo da wasiri awa ingo segedo indari indae eri?” ");
INSERT INTO nou_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Setero Iesu mi mina sisira, “Ingo embomei ingo ro sewa awa ingo ae edo ewa. Edo Isaiah God da binga sari embo mi gebe ingoda jawo da gaisira. Edo Isaiah mi gaisira, ‘God mi sira, “Embomei eiawa naso jawo da ge ewamei sera te ungoda joda awa naso jawo da ge ewamei kotae era. ");
INSERT INTO nou_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Edo ungo na awodo tumondebain edo era edo ungo ewamei ae edo era ainda be awa ungo embomei da agodari awa atopatido era. Edo agodari eiawa atopapotise ungoi sedo era God mi agodari eiawa isira.” ’ ");
INSERT INTO nou_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Edo ingo embo God da agodari dodo embo da atopatari awa kera edo ewa.” ");
INSERT INTO nou_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Edo Iesu awa sedo ungoda yei ge nei sisira, “Ingo God da agodari awa atopatari ujo ae edo ingo ingoda wasiri matu awa atopatadi dipapa edo ewa awa ingo rawodo evi awa ingo gari. Eiedo edo ewa. ");
INSERT INTO nou_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses mi sisira ingoda aimamo sapo ewo. Embo ave uso ai de mamo de da yei biae sadira awa embo mi dadera sisira. ");
INSERT INTO nou_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Awarate ingo atopatido ewa embo ave rora ro mi aimamo kondade ari sago awa sedo ira eiawa God da topo ra edo aimamo kondade ae edo ira. ");
INSERT INTO nou_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Embo ave eiedo edo ira amone awara awa ingo mi atopatido ewa. ");
INSERT INTO nou_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Edo awodo ise ingo God da atopatari awa dodo ingoda wasiri matu awa atopatido ewa. Da awodo wasiri bebegae nenei edo ewa.” ");
INSERT INTO nou_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Edo Iesu awodo sedo sekago embo jiwae jawo setiri uso yei bugero ungoda yei sisira, “Ingo berari naso ge ingise giwo. ");
INSERT INTO nou_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ro embo da be da torido ira amimi ae embo biae aera te kotari bebegae embo da jo mi kotise edo be mi sira amimi euri embo awa biae edo ira. ");
INSERT INTO nou_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ingo dengoro de awasedo naso ge ingido gogo ewo.” ");
INSERT INTO nou_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Edo Iesu embo jiwae awa dodo mando da toriri uso ambojimbi mi inia ge ainda be awa ujugari gadi nganega isera. ");
INSERT INTO nou_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Etero Iesu ungoda yei sisira, “Ingo gaeta? Ingo embo nenei awodo jiro okain de ra. ");
INSERT INTO nou_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ro embo da be da torido ira amimi ae embo awa biae ae ainda be awa rora awa uso joda toraera te uso tini da torido ira. Edo torido sekago je de wosedo ira.” Edo ge eiawa Iesu umo sisira rora neinde kainde awa indari ewamei ra. ");
INSERT INTO nou_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Awa sedo Iesu sekago uso ambojimbi da yei ge sisira. Edo sisira, “Ro biae embo mi uso joda kotise edo uso be mi sedo ira rora emimi euri embo awa embo biae edo ira. ");
INSERT INTO nou_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Embo da joda awa wasiri bebegae ari da kotari bengono da kotari edo dari betari da kotari edo viro ari da kotari edo rora jiwae bari da kotari edo potedo pari da kotari edo ge busari da kotari edo embo nenei da yei ge biae sari da kotari edo jariga da kotari edo dumo ari da kotari edo kotari neinde kainde bebegae iji berari uso joda atima ira. ");
INSERT INTO nou_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Edo kotari bebegae eiawa embo da joda atise euri embo awa embo biae edo ira.” ");
INSERT INTO nou_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Edo Iesu awa sedo yei awa dodo yei da busu Tyre nati demonda ainda mambusira. Edo umo ainda atira awa embo mi georase ujo ae edo gido mando joda totorisira. Awarate embo mi umo burigi be tambusera. ");
INSERT INTO nou_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Edo evetu da uso gagara asisi biae mi sirido atima isira awa Iesu mi ro isira awa gido dambuderari Iesu da yei mambudo Iesu da joda baingo dederi isira. ");
INSERT INTO nou_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Edo evetu emone aumo ra Phoenicia ainda bugusira. Edo baingo dederi edo Iesu da tei da atise evetu emimi Iesu da yei uso gagara da joda asisi bebegae awa ondari bugudo mambarase benunu sisira. ");
INSERT INTO nou_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Awarate Iesu mi sisira, “Ingode kinapeina da indari giti itore ko kinapeina da indari awa budo sino da itadera awa inono ae.” ");
INSERT INTO nou_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Setiri evetu mi uso ge gido mina sisira, “Gebe Bada awarate sino mane demonda atise kinapeina da momono ujo ae edo era awa indido era.” ");
INSERT INTO nou_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Setiri Iesu mi uso yei sisira, “Imo mina ewamei setesa awasedo iso mando da mambuio ainda be awa asisi biae iso gagara awa dodo mambira.” ");
INSERT INTO nou_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Setiri evetu awa uso mando da mambudo uso gagara uso besi da pasido atiri tambusira edo asisi biae awa mambusira. ");
INSERT INTO nou_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu Tyre nati awa dodo Sidon nati da mambusira edo Galilee umo diuga da mambusira edo busu jawo Nati Gabu Etoto ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Edo embo nenei mi embo ge kiambu kiambu sedo isira edo ge ingae edo isira awa budo Iesu da yei bugusera edo Iesu da yei sedo gosisera uso ingo embo ainda tamo da itarase. ");
INSERT INTO nou_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Awasedo Iesu embo jiwae be awa dodo embo awa budo yei nei da umosuka mambusira edo ainda Iesu uso ingo etoto awa embo da dengoro da ititisira. Awodo edo Iesu uso ingo da kosiwa edo embo ainda avewa awa jijigurisira. ");
INSERT INTO nou_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Edo Iesu diti utu da edo oena apuse embo ainda yei sisira, “Ephphatha,” ainda be awa “Pirige.” ");
INSERT INTO nou_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Edo iji da amimi embo ainda dengoro piriguriri uso avewa wujeguriri umo nei ro mi beitigae ge sadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Edo Iesu mi ungoda yei embo nenei soro georase sisira. Awarate Iesu ungo seorase siri ungo Iesu mi ro isira awa embo nenei da yei sisira. ");
INSERT INTO nou_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Edo embo berari ave ge awa ingido kove be edo sisera, “Umo ro ira awa ewamei edo ira. Iesu mi etiri embo ge sae awa ge sero edo embo ge ingae awa ge ingisera.” ");
INSERT INTO nou_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Edo iji tupo embo jiwae be nenei dada isera. ");
INSERT INTO nou_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Edo ungoda indari atae etiri Iesu uso ambojimbi jawo sedo ungoda yei sisira, “Na embomei eiawa jo ira ko ungo nangae atise iji tamonde atae etera edo ungoda indari atae etera. ");
INSERT INTO nou_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Edo na ungoda yei indari itae ungo ungoda nati da itano mambadera awa ungoda nati besaun ainda mambuse ungo beji ditivi mi ambadera.” ");
INSERT INTO nou_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Edo Iesu ge awa setiri uso ambojimbi uso yei nganega isera, “Yei ro atae einda embo amemi indari embo ingetaingo einda indari inono da tambudo embo undae eteri?” ");
INSERT INTO nou_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Setero Iesu ungoda yei nganega isira, “Ambe ingari ingoda yei roinge atiri?” Setiri ungoi mina sisera, “7 awodo atiraeire.” ");
INSERT INTO nou_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Setero Iesu mi setiri embo diti diti busu da anumburisera. Anumbetero Iesu ategari itido ambe gavedo memeia edo ambojimbi da yei ititisira. Edo Iesu itiri edo ambojimbi mi embo da yei ititisera. ");
INSERT INTO nou_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Edo wo kiambu enumba ae daedo atera. Edo Iesu wo da ategari daedo ititisira. Edo Iesu setiri ambojimbi wo de daedo ungoda yei kando isera. ");
INSERT INTO nou_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Edo ungo kando isera edo embo berari da ajigari awa 4,000 aikambu awa indido inono be isera. ");
INSERT INTO nou_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Edo ungo inono etero ambojimbi momono awa dada isera. Edo dada etero indari awa kandea 7 beda isira. ");
INSERT INTO nou_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Edo Iesu embo itiri mambutero nga da vitido uso ambojimbi de busu Dalmanutha da mambusera. ");
INSERT INTO nou_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Edo Pharisee embo nenei mi Iesu da yei bugudo Iesu ga da besora isera. Edo ungo Iesu itido gadi sedo bugudo Iesu uso ari wasiri goroba de awa ari gadi umo itido gosisera. ");
INSERT INTO nou_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Edo ungo awodo Iesu da yei setero Iesu ungoda ge da begogo tambudo ungoda yei sisira, “Ro awasedo embo busu da boroko atima era awa ari wasiri goroba de awa gadi dipapa edo eri? Na ingoda yei be sena. Embomei eiawa mana ari wasiri goroba de awa gadera.” ");
INSERT INTO nou_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Edo Iesu awa sedo Pharisee embomei ungo dodo sekago nga da vitido umo benei da sembusira. ");
INSERT INTO nou_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iesu da ambojimbi ambe ingari nenei bae ruvegurisera. Edo ambe da awa ungoda nga joda atisira. ");
INSERT INTO nou_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Edo Iesu jegigi ari ge mi ungoda yei sisira, “Ingosuka simba ewo. Edo Pharisee embomei de Herod de da ambe bajari siwo yeast awa gido gogo ewo.” ");
INSERT INTO nou_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Edo Iesu awodo setiri ungoi mina sara isera, “Ingodena ambe ae awasedo umo ge emone setira.” ");
INSERT INTO nou_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Edo ungo awa sero Iesu ungoda ge awa gido ungoda yei nganega isera, “Ro awasedo ingo ingosuka ingodenaso ambe atae etira sevi? Ingo gae jarevi ta? Ingo jiro okain de ta? Ingo diti atira edo ro edo gae jarevi? ");
INSERT INTO nou_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Edo ingo dengoro atira edo roedo ingo ingae jarevi? Edo ingo na ambe 5 awa gavedo embo 5,000 da ititisena iji awa ruvegurisevi ta? ");
INSERT INTO nou_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Edo na awodo eteno ingo kandea roinge awa indari buso mi sirisevi?” Setiri ungoi mina sisera, “Nango kandea 12 awodo sirisera.” ");
INSERT INTO nou_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Setero Iesu mi nganega isira, “Ingo na ambe 7 awa embo 4,000 da yei ititisena edo iji ainde ingo kandea roinge indari buso mi sirisevi?” Setiri ungoi mina sisera, “Nango kandea 7 awodo sirisera.” ");
INSERT INTO nou_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Setero Iesu mi ungoda yei nganega isira, “Boroko ingo gosevi ta?” ");
INSERT INTO nou_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Edo Iesu uso ambojimbi de nati Bethsaida ainda bugero embo mi embo diti guba ari awa budo Iesu da yei bugudo Iesu mi tamo jigarase benunu sisera. ");
INSERT INTO nou_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Edo ungo benunu setero Iesu embo diti guba ari awa ingo da budo nati sapu da mambusira. Edo Iesu embo ainda diti awa kosiwa mi sasapi edo uso ingo awa embo ainda diti da itido nganega isira, “Imo rora ro gosesi?” ");
INSERT INTO nou_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Setiri embo awa diti gunjedo sisira, “En. Na embo gosena te ungo teta ri mi yima puma arago ero gosena.” ");
INSERT INTO nou_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Setiri sekago Iesu uso ingo embo ainda diti da ititisira. Edo Iesu awodo etiri embo awa uso diti sekago gunjisira. Edo diti gunjiri uso diti ewamei isira. Etiri umo rora berari isaga gosisira. ");
INSERT INTO nou_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Edo Iesu mi uso yei sisira, “Sekago engenembedo nati nembodiba da mambose te iso nati da mambuio.” Sedo Iesu mi itiri embo awa dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Edo Iesu uso ambojimbi da yei awa dodo nati Caesarea Philippi busu da ainda mambusira. Edo ungo mambuse Iesu mi uso ambojimbi da yei nganega isira, “Embo na awa ave sedo eri?” ");
INSERT INTO nou_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Setiri ungoi mina sisera, “Embo nenei sedo era John umo mi ewamei ari embo sedo era edo embo nenei awa Elijah sedo era edo nenei awa God da binga sari embo nei ra.” ");
INSERT INTO nou_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Setero Iesu ungo nganega isira, “Ingo ingosuka na awa ave sedo evi?” Setiri Peter mi mina sisira, “Imo awa Soregari Embo God mi itari bugarase sisira.” ");
INSERT INTO nou_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Setiri Iesu ge tini javi de sisira, “Embo nenei da na awa saso geore.” ");
INSERT INTO nou_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iesu uso ambojimbi atopapotise ungoda yei sisira, “Na God da mei bugudo embo isena amimi memesi nembodiba tambadena. Edo Jew embomei da embo nembogambo de priest gitijijigegari de agodari atopapotegari de mi na ujo ae adera. Edo ungo na ujo ae oro embo nenei mi na doro betadena. Awarate na betedo iji tamonde atae ari na wasiri de sekago eradena.” ");
INSERT INTO nou_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Edo Iesu awodo sedo etiri uso ambojimbi isaga be gosisera awasedo Peter mi Iesu budo demonda yiko awodo eurase sedo sisira, “Ge awodo seose.” ");
INSERT INTO nou_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Setiri Iesu wareregedo uso ambojimbi gosise ge awodo seorase eurase Peter da yei sisira, “Satan na dodo mambu. Iso kotari awa embo da kotari ra God da kotari aera.” ");
INSERT INTO nou_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Edo Iesu uso ambojimbi de embo jiwae be de jawo setiri bugero ungoda yei sisira, “Embo ave na ambo ambo adi dipapa edo embo awa uso dipapa awa dodo uso orega saga da itido na ambo ambo are. ");
INSERT INTO nou_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Edo embo ave uso wasiri busu da soregadi kotadira embo awa betadira te embo ave na embo edo binga ewamei awa sedo betadira awa embo awa wasiri natopo atari tambadira. ");
INSERT INTO nou_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Awarate embo ave busu da rora berari budo betadira amone rora berari amomo uso inono ta? Awodo aera amone inono aera. ");
INSERT INTO nou_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Edo embo uso wasiri soregadi adira awa mina ro itadira awa inono ri? ");
INSERT INTO nou_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Boroko busu da embo berari awa wasiri bebegae era edo God gebe ae era. Amboda na God da usasa mi jinenebari edo God da asisi ewamei de daedo busu da engenembadena. Embo nenei naso yei edo naso atopatari da me era. Amboda na engenembadena iji ainde na embomei ainda yei me adena.” ");
INSERT INTO nou_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Edo Iesu uso ge atae edo uso ambojimbi da yei sisira, “Eiawa kotewo amboda embo einda betae atise God gitijigadira ainda iji goroba nembodiba de bugutirari gadera.” ");
INSERT INTO nou_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Edo iji 6 atae etiri Iesu Peter de James de John de budo ungo ungosuka doriri nembodiba da vivitisera. Edo ambojimbi ditini ero Iesu gari nei isira. ");
INSERT INTO nou_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Uso ombari janiburisira. Edo embo mi ombari digari segadera awa awodo jatebadi aera. ");
INSERT INTO nou_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Edo ambojimbi tamonde Elijah de Moses de Iesu ga ge sero gosisera. ");
INSERT INTO nou_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Gido Peter mi Iesu da yei sisira, “Atopatari na iaviri ena ingodena einda atera awasedo. Nango gaga kikire tamonde einda ore da Moses da da Elijah da da iso.” ");
INSERT INTO nou_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Edo Peter ro sadiri awa gae edo gido awodo sisira ainda be awa Peter umo de ambojimbi etoto de awa oju mi bebegae isera awasedo. ");
INSERT INTO nou_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Edo ungo awodo ero poroga mi bugudo ungo apuregurisira. Edo poroga ungo apuregedo atiri poroga joda ge javi sisira, “Emone naso mei awa na dubo burena ena awasedo uso ge ingiwo.” ");
INSERT INTO nou_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Edo ge awa ingido ambojimbi wareregedo demo gido demo gido isera te embo nei gae. Iesu umo umosuka gosisera. ");
INSERT INTO nou_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Edo ungo doriri da edo wowosero Iesu ungoda yei ge okain sisira, “Ingo ro getewa awa embo nenei da yei seove. Amboda na God da mei embo isena awa betedo wasiri de sekago eradena iji ainde awa embo da yei sadewa.” ");
INSERT INTO nou_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","11","Edo Iesu ge awodo setiri ungoi kera isera te ungo Iesu da betari de erari de da ge awa ainda be awa rori awa gadi dipapa edo Iesu da yei sisera, “Ro awasedo agodari da atopapotegari mi siseri Elijah awa giti bugadira siseri?” ");
INSERT INTO nou_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Setero Iesu mina sisira, “Gebe Elijah giti bugudo rora berari sia isira. Edo jiwari da ge na God da mei embo isena awa sisira, ‘Edo memesi nembodiba tambadira. Edo embo mi umo ujo ae adera.’ Ro awasedo jiwari da awodo siseri? ");
INSERT INTO nou_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na ingoda yei sena Elijah matu bugusira etiri embo mi ungo uso ro adi dipapa era awa isera ro jiwari mi orase sira awa da awodo isira.” ");
INSERT INTO nou_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Edo ungo ambojimbi nenei sekago tambudo yei ainda ungoi embo jiwae be gosisera. Edo agodari da atopapotegari nenei mi Iesu da ambojimbi de ge bagisera. ");
INSERT INTO nou_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Edo embo Iesu gido kove be edo Iesu da yei sumbudo umo atega isera. ");
INSERT INTO nou_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Edo ungo Iesu atega etero Iesu uso ambojimbi da yei sisira, “Ingo agodari da atopapotegari ga ge nonda tamo da ge bagevi?” ");
INSERT INTO nou_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Setiri embo da teda atisira amimi mina sisira, “Atopatari na naso mei iso yei budo bugena ainda be awa asisi biae uso joda atima ira amimi euri ge sae edo ira. ");
INSERT INTO nou_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Edo yei rawainda mei iri awa asisi biae awa mei biae edo busu da piguri durido ira edo poro kusedo ira edo di gamburi edo uso tamo dagaiya edo ira. Edo na iso ambojimbi da yei asisi biae awa ondorase sedo getena awa ungo ari sago ae etera.” ");
INSERT INTO nou_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Setiri Iesu mi mina sisira, “Ingoda yei tumonda ari atae ra. Na iji roinge ingode ateni?’ Na iji roinge ingo sano gevi? Mei awa naso yei budo pou.” ");
INSERT INTO nou_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Setiri ungoi mei awa budo Iesu da yei pusera. Edo asisi biae Iesu gido mei kiambu awa dedo busu da warawara etiri mei awa poro bejigo mi beda dada ari busu da apepo apepo isira. ");
INSERT INTO nou_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Edo mei awa awodo iri Iesu uso mamo nganega isira, “Iji roinge mei eiawa karu eiedo eviri?” Setiri mei ainda mamo mi sisira, “Umo mei kiambu atise karu eiawa burisira. ");
INSERT INTO nou_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iji jiwae asisi biae mei eiawa dadi sedo piguri riawo da edo da wosedo ira. Imo adesa gido sedo gosena nango jo edo nango kondade egae.” ");
INSERT INTO nou_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Setiri Iesu mi mina sisira, “Na karu eiawa ano ewamei aetita imo sesa? Embo ave God gebe adira awa rora berari adira.” ");
INSERT INTO nou_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Setiri mei ainda mamo mi burigi sisira, “Naso tumonda ari kiambu awa inono aera awasedo kondade egae tumonda ari nembodiba awa tambane.” ");
INSERT INTO nou_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Setiri Iesu embo neungo ae aikambu bugutero gido asisi biae da yei sisira, “Imo asisi ge sae de dengoro junjari de nanemi sena imo mei awa dodo bugu. Edo sekago uso yei torose.” ");
INSERT INTO nou_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Setiri asisi biae gogo dimbudo mei awa busu da pigedo ponda bugusera. Edo mei awa teta betari embo inge isira awasedo embo mi sisera mei amone betetira. ");
INSERT INTO nou_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Awarate Iesu mi mei awa ingo da budo kondade etiri mei awa eririsira. ");
INSERT INTO nou_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Edo Iesu mando joda toriri uso ambojimbi mi gae uso yei da nganega isera, “Roedo nango asisi biae ondae jareteri?” ");
INSERT INTO nou_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Setero Iesu mi mina sisira, “Ingo asisi biae eiedo ondari dipapa adewa awa ingo God ga da ge sedo sedo giwo ingo kondade are. Edo emboro nei rawodo adi aera.” ");
INSERT INTO nou_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Edo ungo yei awa dodo busu Galilee awodo mambusera. ");
INSERT INTO nou_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Edo Iesu embo mi umo yei rawainda ri awa georase ujo ae isira ainda be awa umo uso ambojimbi atopapotise sisira, “Na God da mei bugudo embo isira awa ungoi embo nenei da soro na dadera. Edo na betedo iji tamonde atae ari sekago wasiri de eradena.” ");
INSERT INTO nou_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Edo ambojimbi atopatari einda be awa gadi jarisera te ungo oju edo gido uso yei ainda be awa sari gadi nganega ae isera. ");
INSERT INTO nou_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Edo ungo Capernaum nati da bugudo mando da vitido Iesu uso ambojimbi da yei nganega isira, “Ingo emboro da pepeta ise ingo nonda tamonda ge bagetevi?” ");
INSERT INTO nou_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Setiri ungo uso ge mina sae isera ainda be awa ungo emboro da pepeta ise ungo ungoda teda awa embo nembodiba mo averi ainda tamo da sititaro jirira. ");
INSERT INTO nou_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Edo Iesu anumbedo ambojimbi 12 setiri uso yei bugero ungoda yei sisira, “Embo ave giti adi dipapa adira awa umo umosuka gun da itare edo embo nenei awa kera are.” ");
INSERT INTO nou_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sedo setiri ungoi mei kiambu awa budo Iesu da jo da itero dederisera. ");
INSERT INTO nou_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Edo mei kiambu awa derido atiri Iesu uso ingo mi mei awa sandido ungoda yei sisira, “Embo ave naso jawo da kinapeina memeia eiedo badira embo awa na badira. Edo embo ave na badira embo awa God na itiri bugusena awa badira.” ");
INSERT INTO nou_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John mi Iesu da yei sisira, “Atopatari nango embo da iso jawo da asisi bebegae ondiri gido buro ira awa doarase sisera ainda be awa umo awa ingodenaso embo nei ae awasedo.” ");
INSERT INTO nou_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Edo Iesu ge awa ingido ungoda yei sisira, “Embo ave naso jawo da ari nembodiba ro adira edo amboda naso jawo da biae ro sae adira awasedo sawo buro awa doure. ");
INSERT INTO nou_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Edo embo ave ingodena dae ira embo amone ingodena kondade ira. ");
INSERT INTO nou_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Edo ge eiawa ruvegeove. Embo ave ingo Keriso da kinapeina awa gido ingo umo indawase itadira embo amone uso mina ne badira.” ");
INSERT INTO nou_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iesu mi sisira, “Embo amemi mei kiambu eiawa na gebe ira awa ari na dodo mambadira embo awa wasiri biae ira. Edo embo awa wasiri biae awodo ae giti da embo amemi embo ainda koma da ganuma kaingedo ewa kapuru da pigadira embo awa wasiri ewamei etira. Awarate embo awa atise wasiri biae awa adira awa biae embo ainda yei atadira. ");
INSERT INTO nou_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Awasedo ingoda ingo mi ari wasiri biae edo gido diugedo pigeio. Edo atari ingo da de edo amboda utu da vitadi adesa amone ewamei na awarate atari ingo etoto de edo amboda riawo mata awa atari da torari amone biae ra. ");
INSERT INTO nou_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ainda embo betae edo riawo mana ambadira. ");
INSERT INTO nou_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Edo daedo iso tei mi ari imo wasiri biae edo re diugedo pigeio. Edo tei da de atima amboda utu da vitari amone ewamei na awarate tei etoto de atima amboda riawo matawa ewuse atima ira ainda torari amone biae ra. ");
INSERT INTO nou_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ainda embo mana betadera edo riawo mana ambadira. ");
INSERT INTO nou_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Edo iso diti da mi ari imo wasiri biae edo re gurugedo pigeio. Edo atari diti da de edo amboda God da gitijigari yei da torari amone ewamei na awarate diti etoto de atima amboda riawo matawa ewuse atira ainda torari amone biae ra. ");
INSERT INTO nou_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ainda embo betae edo riawo mana ambadira. ");
INSERT INTO nou_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Riawo embo berari da yei wosadira teta ewa budo indari da para para edo ewa awodo. ");
INSERT INTO nou_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ewa awa ewamei. Edo ingodena embomei kondade edo era awa ingodena teta ewa ingode indari da pigedo era da awodo. Edo ewa gambae adira awa ingode ro oro sekago ewamei eiri? Embo kondade ise atiwo edo daedo jao namendi ise atiwo.” ");
INSERT INTO nou_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Edo Iesu yei awa dodo Judea busu da awodo sembusira edo Jordan umo awodo sembusira. Edo sembiri embo jiwae be uso yei bugero Iesu ungo atopapotisira. ");
INSERT INTO nou_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Edo Pharisee embomei bugudo Iesu itido gadi dipapa edo sisera, “Nangoda agodari mi embo uso aro doarase mo awara sita?” ");
INSERT INTO nou_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Setero Iesu mina sisira, “Moses ingoda yei agodari ititise ro sisiri?” ");
INSERT INTO nou_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Setiri ungoi mina sisera, “Moses mi sisira embo ave uso aro doari dipapa edo embo awa uso aro da doari jiwari awa itido aro doari mambadira.” ");
INSERT INTO nou_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Setero Iesu mi ungoda yei sisira, “Ingo awa embo okain awasedo Moses agodari awa gaisira. ");
INSERT INTO nou_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","Te jiwari mi sira tuturo da God utu de busu de rora berari isira ainde God embo de evetu de isira awasedo embo uso ai de mamo de dodo uso aro ga tatadira. ");
INSERT INTO nou_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Awodo edo etoto awa da edo adera. Edo ungo awa etoto aera te embo da edo adera. ");
INSERT INTO nou_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Awasedo embo de evetu de God mi dada edo ira embo etoto eiawa embo nenei mi mana oro ewoga ewoga adera.” ");
INSERT INTO nou_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Edo ungo mando da mambudo Iesu da ambojimbi mi Iesu da yei aro doari da nganega sekago isera. ");
INSERT INTO nou_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Etero Iesu mi ungoda yei sisira, “Embo ave uso aro dodo aro nei jimbadira embo awa viro etira. ");
INSERT INTO nou_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Edo da awodo evetu ave uso iu dodo iu nei jimbadira evetu awa viro etira.” ");
INSERT INTO nou_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Embo nenei mi Iesu mi ungoda kinapeina ewamei arase budo bugusera te Iesu da ambojimbi mi embomei eiawa ujo ae isera. ");
INSERT INTO nou_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Edo ambojimbi awodo ero Iesu gido ambojimbi da yei tini gambari edo sisira, “Kinapeina memeia dowo naso yei da purore. Emboro gajove ainda be awa God da gitijigari yei awa embo kinapeina memeia mi God gebe edo era da awodo era ainda. ");
INSERT INTO nou_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kinapeina memeia awa God mi ungo gitijigarase dipapa edo ira awarate embo awodo awa God mi uso gitijigari arase ujo ae edo ira awa God awa uso gitijigari adi aera awa ruvegeove.” ");
INSERT INTO nou_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Edo Iesu awodo sedo kinapeina memeia kumbudo uso ingo ungoda beo da itido ungo ewamei isira. ");
INSERT INTO nou_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Edo Iesu yei awa dodo mambadi iri embo da sumbudo Iesu da yei da bugusira. Bugudo Iesu da joda baingo dederi edo sedo gosisira, “Atopatari ewamei na roedo wasiri natopo atari beni?” ");
INSERT INTO nou_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Setiri Iesu mi uso yei sedo gosisira, “Roedo na ewamei sesi? Embo ave embo da teda awa ewamei ri? God umosuka awa ewamei na. ");
INSERT INTO nou_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Edo agodari mi sisera imo gari awa eire, embo daso betore dogae, viro eose dogae, bengono eose dogae, ge busose dogae, embo nei da rora potose dogae, ai de mamo de sapo eio.” ");
INSERT INTO nou_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Setiri embo amimi mina sisira, “Na mei kiambu da iji de edo bugudo boroko agodari berari eiawa na kera emona.” ");
INSERT INTO nou_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Setiri Iesu embo awa dubo bari mi gon gon edo sisira, “Buro da iso yei sadena awa eio. Mambuio iso rora berari awa ori edo uso gano berari awa rora ae embomei da itase. Edo imo awodo adesa awa imo utu da vitaso God mi utu da rora mina nembogambo de awa iso yei itadira. Edo puio na ambo ambo ase.” ");
INSERT INTO nou_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Setiri embo awa ge awa ingido dubo vevera tambusira ainda be awa umo awa rora jiwae embo awasedo. Edo awodo mina burise Iesu dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Edo Iesu uso ambojimbi gosise ungoda yei sisira, “Embo rora jiwae de embo awa ungo God da gitijigari yei da torari awa okain be ra.” ");
INSERT INTO nou_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Edo Iesu ge awa setiri uso ambojimbi ge awa ingido duduku isera te Iesu mi ungoda yei sisira, “Naso kinapeina God da gitijigari yei da torari awa be kiambu okain be ra. ");
INSERT INTO nou_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Edo wo nembodiba jawo camel mi nigu to da torari awa okain be ra te embo rora jiwae de embo mi God da gitijigari yei da torari awa okain be okain ra.” ");
INSERT INTO nou_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Edo Iesu ge awodo setiri uso ambojimbi duduku edo ungosuka mina sara isera, “Awasedo embo amemi wasiri natopo atari tamberi?” ");
INSERT INTO nou_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Setero Iesu ungo ditini edo ungoda yei sisira, “Embo mi mana awodo adera te God mi awodo adira ainda be awa God mi rora berari awa adira awa uso yei da isaga be ra.” ");
INSERT INTO nou_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Edo Iesu awodo setiri Peter mi sisira, “Awara na ge sadena. Nango rora berari dodo imo ambo ambo edo era.” ");
INSERT INTO nou_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Setiri Iesu mi ungoda yei sisira, “Gebe edo na ingoda yei boroko gebe sena. Embo ave uso nati ta uso namendi ta uso ru ta uso ai ta uso mamo ta uso kinapeina ta uso busu ta awa na embo edo binga ewamei awasedo doadira embo awa boroko iji einde nati nenei jiwae de nanonamendi de ruaimono de aimamo de kinapeina de busu de edo dedo gaedo ari de daedo badira. Amboda embo awa daedo wasiri natopo atari badira. ");
INSERT INTO nou_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Edo embo jiwae boroko nembogambo atera awa iji ainde awa ungo awa embo nembogambo adi aera. Edo embo jiwae be boroko embo nembogambo ae atera awa iji ainde embo nembogambo adera.” ");
INSERT INTO nou_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu uso ambojimbi de Jerusalem mambadi sedo emboro da mambusera. Edo ungo mambutero Iesu awa giti etiri edo uso ambojimbi de edo embo jiwae de awa uso ambo ambo da pepeta isera. Edo ungo mambuse Iesu da ambojimbi de embo de awa oju isera. Edo Iesu uso ambojimbi 12 awa budo demonda yiko ro uso yei adera awa ungoda yei sisira. ");
INSERT INTO nou_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Edo Iesu mi ungoda yei sisira, “Giwo ingodena Jerusalem vivitera ainda na God da mei embo isena awa priest gitijijigegari de agodari da atopapotegari de da yei itadera. Edo ungo na betanase dipapa edo budo embo Jew ae ainda yei itadera. ");
INSERT INTO nou_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Edo ungoi na gandubedo naso yei kosiwa edo na vejedo doro betadena. Awarate na betedo iji tamonde na sekago eradena.” ");
INSERT INTO nou_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","James de John de Zebedee da memei mi Iesu da yei bugudo sisera, “Atopatari imo nangoda yei ro esi awa iso yei sadi era.” ");
INSERT INTO nou_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Setero Iesu mi ungoda yei nganega isira, “Na ingoda yei ro eni?” ");
INSERT INTO nou_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Setiri ungo mi uso yei mina sisera, “Imo iso gitijigari da anumba da anumbedo gitijigadesa iji ainde nango ingae daedo anumbadi dipapa era da iso ingo be da edo da iso ingo anda da. Edo eiawa awara sesi ta?” ");
INSERT INTO nou_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Setero Iesu mi ungoda yei sisira, “Ingo ro embo sedo gosewa awa ingo gae jarewa. Edo ingo na memesi badena da awodo ingo bevi ta? Na dedo gaedo ari jiwae tambadena. Edo ingo da awodo dedo gaedo ari jiwae tambadewa mo edo gevi ta?” ");
INSERT INTO nou_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Setiri ungoi mina sisera, “Nango adera.” Setero Iesu mi sisira, “Gebe. Na memesi badena da awodo ingo daedo memesi badewa. Edo dedo gaedo ari na tambadena da awodo ingo dedo gaedo ari tambadena. ");
INSERT INTO nou_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Awarate amemi naso ingo be da anumberi edo amemi naso ingo anda da anumberi awa na sari katogo aera. God mi anumbari yei etoto awa sia etira awasedo embo amemi ainda anumbaderi awa unemi sadira.” ");
INSERT INTO nou_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","42","Edo ambojimbi nenei 10 ge awa ingido ungo James de John de da yei tini gambari isera awasedo Iesu ungo jawo setiri ungo dada etero ungoda yei sisira, “Ingo gosewa aumo embo da gitijigari awa ge okain de embo gitijigido ira awarate ingo mana eiedo gitijigari mina ara adewa. ");
INSERT INTO nou_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Embo ave ingoda teda awa embo nembodiba adi dipapa adira awa umo embo nenei berari awa kondade adira. ");
INSERT INTO nou_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Embo ave ingoda gitijigari adi dipapa adira awa umo ingoda buro ari embo adira ainda be awa na God da mei embo isena awa da awodo buro isena. ");
INSERT INTO nou_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Embo nenei mi na kondade orase bugaera te na embo berari awa kondade adi dipapa edo bugusena. Na bugusena edo betedo embo jiwae da wasiri biae da mina itadena.” ");
INSERT INTO nou_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Edo ungo Jericho nati da bugudo Iesu uso ambojimbi de embo neungo ae de awa mambadi isera. Edo diti guba ari embo jawo Bartimaeus Timaeus da mei awa emboro demonda anumbedo atise embo da indari de gano de benunu sise adi atima isira. ");
INSERT INTO nou_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Edo umo Iesu bugira ainda ge awa ingido gogo dimbudo sisira, “Iesu David da mei na jo egae.” ");
INSERT INTO nou_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Setiri embo jiwae mi umo isibedo ge doarase sisera. Awarate Bartimaeus sekago gogo dimbudo sisira, “David da mei na jo egae.” ");
INSERT INTO nou_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Setiri Iesu petedo sisira, “Jawo seu naso yei purare.” Setiri ungoi embo diti guba ari jawo sedo sisera, “Iesu imo jawo sira awasedo oju eose ta erio.” ");
INSERT INTO nou_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Setero embo diti guba ari awa burigi uso ombari totigedo erido Iesu da yei bugusira. ");
INSERT INTO nou_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Edo embo awa bugiri Iesu uso yei nganega isira, “Iso yei ro anase dipapa esi?” Setiri embo diti guba ari mi mina sisira, “Na sekago yei gadi dipapa ena.” ");
INSERT INTO nou_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Setiri Iesu mi uso yei sisira, “Mambuio iso gebe ari mi etiri ewamei etesa.” Setiri embo awa yei sekago gosisira edo emboro da Iesu ambo ambo isira. ");
INSERT INTO nou_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Edo ungo Bethphage edo Bethany nati aikambu bugusera doriri Olive susu Jerusalem be nei eikena. Edo Iesu ambojimbi etoto itiri giti mambutero sisira, “Mambuwo nati ingoda dombu da atira ainda. ");
INSERT INTO nou_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Edo ingo nati da torido re wo donkey da mei awa tambadewa. Edo embo da amemi wo donkey mei da tamo da matu anumbae. Edo tambudo wujegedo budo buguwo. ");
INSERT INTO nou_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Edo embo amemi ingoda yei ro edo wo awa wujegurevi soro gido ungoda yei sewo gitijigari buro adi sedo setiri burera sewo. Edo umo sekago burigi wo awa einda itadira sewo.” ");
INSERT INTO nou_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Setiri ungo mambudo wo donkey da mei awa tambusera. Edo nenei mi wo awa mando be da digero emboro da derido atisira. ");
INSERT INTO nou_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Edo ungo wo ainda esi awa wujegurero embo demonda derido atisera amimi nganega isera, “Ingo ro edo wo ainda esi wujegurevi? Ingo ro adi kotise evi?” ");
INSERT INTO nou_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Setero ro Iesu mi sorase sisira awa ambojimbi etoto mi sisera awasedo embo amimi awara mambuwo sisera. ");
INSERT INTO nou_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Edo ambojimbi etoto wo awa Iesu da yei budo bugudo ungoda ombari wo da tamonda direro Iesu vitido wo da tamo da anumburisira. ");
INSERT INTO nou_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Edo embo jiwae be mi ungoda ombari digari mi besi dirarago emboro da ero embo nenei mi ri patu ro emboro demonda awa divedo emboro da itido isera. ");
INSERT INTO nou_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Edo embo amboda edo giti da yima edo isera amimi gogo dimbudo sisera, “Oro oro oro. Embo eiawa God da jawo da bugudo pira God mi umo ewamei are. ");
INSERT INTO nou_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Edo God mi gitijigadira awa bugutira awasedo ingode God jasiga ore. Oro oro oro.” ");
INSERT INTO nou_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Edo Iesu Jerusalem torido edo Jew embomei da tumondebain ari oro da totorisira. Torido umo rora berari gosisira. Edo tumba jijiriri gido Iesu uso ambojimbi 12 de dodo ungo Bethany nati da mambusera. ");
INSERT INTO nou_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sipo de Bethany nati dodo Jerusalem pepeta edo bugutero Iesu beji isira. ");
INSERT INTO nou_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Edo Iesu ri betora awa igi mi ato ae ari awa besaungo gido be de ta awa gadi mambusira. Edo ri awa asusubedo be ae tepo igi berari awa gosisira ainda be awa ribe ari iji ae awasedo. ");
INSERT INTO nou_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Edo Iesu ge sedo ri ainda sisira, “Embo mi iso be awa sekago indadi aera.” Edo umo awodo setiri uso ambojimbi ge awa ingisera. ");
INSERT INTO nou_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Edo ungo Jerusalem torido Iesu Jew embomei da tumondebain ari oro da totorisira. Edo embo berari ainda origarori isera awa ondadi tuturo isira. Edo gano mina ita ari embo da tendeba awa budo kapotegedo edo gumbara rorou itari embomei da anumba awa budo dada isira. ");
INSERT INTO nou_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Edo embo ave budo Jew embomei tumondebain ari oro joda torido isera awa seuri awodo dodo isera. ");
INSERT INTO nou_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Awodo edo Iesu embo atopapotisira, “Jiwari da God mi sisira naso mando awa embo mi na God ga da ge sadera sisira te ingo mi etewo bengono embomei da meko to etira.” ");
INSERT INTO nou_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Edo Iesu umo awodo setiri priest gitijijigegari de agodari da atopapotegari de ingido emboro eura edo Iesu doro betarase isera. Edo ungo Iesu oju isera ainda be awa embo berari awa uso atopatari awa gadi dipapa isera awasedo. ");
INSERT INTO nou_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Edo ongobo etiri Iesu uso ambojimbi de Jerusalem doturisera. ");
INSERT INTO nou_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sipo be sipo de ungo pepeta edo mambuse ungoi ri betora awa gosisera. Ri de uso besisi de awa ambusira. ");
INSERT INTO nou_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Edo Peter ro isira awa kotedo Iesu da yei sisira, “Atopatari ro betora da yei imo ge biae setesa awa ambira.” ");
INSERT INTO nou_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Setiri Iesu mi mina sisira, “Ingo berari eiawa ruvegeove. ");
INSERT INTO nou_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ingo God gebe adewa awa ingo doriri einda sadewa erido ewa da woseio. Edo ingo na gebe adewa awa ro God da yei sedo gadewa awa ingoda yei adira. Awarate ingo gebe ae adewa awa rora awa adi aera. ");
INSERT INTO nou_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Awasedo na ingoda yei sena ingo God da yei ro embo sedo gosise iji da ainde ingoda yei itadira awa gebe ewo. Edo ingo awodo gebe adewa amimi ro God mi ingoda yei itarase sadewa awa ingoda yei itadira. ");
INSERT INTO nou_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Edo ingo God da yei ge sise ingo wasiri biae embo nei mi ingoda yei isira awa kotedo re ingoda joda embo da wasiri biae awa kotembedo dowo. Edo ingo awodo adewa awa ingoda God utu da amimi ingoda wasiri biae awa kotembedo doadira. ");
INSERT INTO nou_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Edo embo nei mi iso yei da biae isera awa kotembedo doae adesa awa God mi iso buria awa mana kotembedo doadira.” ");
INSERT INTO nou_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Edo ungo sekago Jerusalem engenemburisera. ");
INSERT INTO nou_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Edo Iesu Jew embomei da tumondebain ari oro da yiri priest gitijijigegari de agodari da atopapotegari de Jew embo nembogambo de mi Iesu da yei bugudo nganega isera, “Ro edo imo wasiri eiawa iji berari edo esi? Embo amemi iso yei goroba itiri esi?” ");
INSERT INTO nou_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Edo ungoi awa setero Iesu mi mina sisira, “Na ingoda yei sedo gari da itadena. Edo ingo naso ge mina sadewa awa na goroba amemi itiri budo buro eiawa edo eni awa sano gadewa. ");
INSERT INTO nou_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Embo amemi John da yei goroba ari itiri budo umo mi ewamei edo isiri? Embo mi John da goroba ari ititiseni ta ko God mi John da yei goroba ari ititisiri?” ");
INSERT INTO nou_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Setiri ungo ungosuka mina sara isera, “Ingode ro seri? Ingode sadera God mi John da yei goroba ari awa ititisira sadera awa Iesu mi ingodenaso yei sadira ro edo ingo John gebe ae edo evi awarate ingode John da goroba awa embo mi ititisera seri ta?” ");
INSERT INTO nou_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ungo embo oju isera ainda be awa embo berari kotedo era John awa binga sari embo awasedo. ");
INSERT INTO nou_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Awasedo ungoi Iesu da yei mina sisera, “Nango gaera.” Setero Iesu mi ungoda yei sisira, “Awasedo naso goroba amemi etiri buro eiawa eni awa na ingoda yei sadi aera.” ");
INSERT INTO nou_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu inia ge mi ungoda yei sisira, “Embo da mi grape da ve awa uso buro da gowusira. Edo puga digido edo grape simba ari oro itadi uro ngambusira. Edo simba ari embo da gaga didigurisira edo uso buro awa embo nenei mi simba orase ititisira. Edo ungoda yei sisira ribe awa sari ari awa umo nenei burirari edo ungo nenei badera sisira. Edo buro topo awa busu awa dodo busu nei da mambusira. ");
INSERT INTO nou_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Edo amboda ribe awa sari etiri buro topo uso tega awa badi dipapa edo gido uso buro embo mi borase itiri mambusira. ");
INSERT INTO nou_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Edo embo awa bugiri buro simba ari embo mi embo awa sandido ituka mi dedo edo ribe nei ro bae sekago itero buro topo da yei engenemburisira. ");
INSERT INTO nou_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Awasedo buro topo mi buro embo nei itiri mambusira. Edo buro embo awa bugiri buro simba ari embo mi ituka mi beo da dedo edo ungoi uso yei biae isera. ");
INSERT INTO nou_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Awasedo buro topo sekago buro embo nei ititisira edo buro simba ari embo mi deteri bebetisira. Edo buro embo nenei bugero buro simba ari embo mi ari da awodo isira. Nenei awa ituka mi dedo gaedo isira. Nenei deoro betedo isera. ");
INSERT INTO nou_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Edo embo da be da awa buro topo da yei atisira uso mei topo awa. Awasedo ambo be ambo da buro topo umo kotisira ungo mi naso mei awa sapo adera sedo itiri buro simba ari embo da yei mambusira. ");
INSERT INTO nou_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Mambiri edo buro simba ari embobo ungosuka mina sara isera, ‘Emone buro topo da mei ra. Edo uso mamo betadira awa uso mamo da busu berari awa unemi badira. Ingode doro betadira awa uso busu awa ingodenaso busu adira. Pou.’ ");
INSERT INTO nou_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Awasedo ungoi mei awa sandido detero betetiri uso tamo awa buro ponda pigisera. ");
INSERT INTO nou_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Edo ungo awa etero buro topo ro adira awa kotevi? Umo bugudo embomei awa dari betero buro awa budo embo nenei da itari simba adera. ");
INSERT INTO nou_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Edo ingo ro jiwari da sira awa ajigedo gae ta? Jiwari sira, ‘Ganuma mando itari embo mi ujo ae etera awa teta tutuvi tuturo da itari inge etera. ");
INSERT INTO nou_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Eiawa God mi etiri etira. Eiawa gari ewamei be.’” ");
INSERT INTO nou_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Edo ungo Iesu da ge awa ingido ungo inia ge eiawa ungoda jawo da setira awa gido ungo Iesu bundadi sedo isera. Awarate ungo embo jiwae be awa oju edo gido Iesu dodo mambusera. ");
INSERT INTO nou_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jew embomei da gitijijigegari mi Iesu sedo gari mi itido gadi sedo dipapa edo Iesu da yei Herod da ambojimbi de Pharisee nenei de ititisera. ");
INSERT INTO nou_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Edo ungo Iesu da yei bugudo uso yei sisera, “Atopatari nango gari imo embo oju ae iji berari gebe berari mi sedo esa. Edo embo nenei awa nembogambo ae edo embo nenei awa nembogambo awarate imo ungo berari awa da awa edo gogo edo esa. Edo ro God mi embo mi orase dipapa edo ira awa gebe mi atopatido esa. Edo nango Rome embobo da gitijigari nembodiba Caesar da yei tax gano itido era mo nango nangoda agodari bebejeri ta? Edo tax eiawa itadera mo awara ta ko awara aeri?” ");
INSERT INTO nou_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Setero Iesu ungoda gandubari ge awa gido ungoda ge mina sisira, “Ro edo ingo na gandubadi jarevi? Gano budo puwo gane.” ");
INSERT INTO nou_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Setiri ungo gano budo uso yei bugusera. Etero budo ungoda yei sisira, “Emomo embo amenda dombu ove jawo ri?” Setiri ungoi mina sisera, “Amone Caesar da ra.” ");
INSERT INTO nou_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Setero Iesu ungoda yei sisira, “Ro Caesar da topo awa uso itiwo edo ro God da topo awa uso itiwo.” Edo Iesu awodo setiri uso mina sari awa ungo kove be isera. ");
INSERT INTO nou_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Edo ungo mambero Sadducee embomei embo betedo sekago eradi ae sedo atopatido isera amimi Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Bugudo Iesu da yei sisera, “Moses mi agodari eiawa nango embo gaisira embo da betadira edo uso aro awa kinapeina bae wasiri de atadira edo betari embo da namendi mi namendi da rori awa jimbudo namendi kinapeina itae betetira ainda kinapeina itadira gaisira. ");
INSERT INTO nou_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Boroko nangoda ge eiawa ingio. Nanonamendi 7 einda atima isera. Edo mei bego aro jimbusira te evetu awa kinapeina ingae. ");
INSERT INTO nou_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Edo mei bego betetiri uso namendi mi uso rori awa jimbusira te evetu awa kinapeina ingae. ");
INSERT INTO nou_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Edo namendi awa daedo bebetisira edo nanonamendi 7 berari da awodo isera. Edo ambo be amboda evetu awa kinapeina bae bebetisira. ");
INSERT INTO nou_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Awasedo embo bebetegedo era awa wasiri de sekago eradera iji ainde evetu amomo anda aro ri? Edo nanonamendi 7 berari busu einda atise evetu awa dada jimbusera awasedo evetu amomo anda aro eiri?” ");
INSERT INTO nou_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Edo ungo awodo setero Iesu mina ungoda yei sisira, “Ingo gaegae setewa. Ingo gaegae setewa ainda be awa ingo gosevi ta? Ingo gaegae setewa ainda be awa ingo jiwari de God da goroba de awa gae. ");
INSERT INTO nou_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Embo de evetu de bebetisera awa wasiri de sekago eradera iji ainde ungo awa teta asisi utu da atima era da awodo edo jimbae adera. ");
INSERT INTO nou_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Edo embo betari da edo wasiri de sekago eradera ainda ge awa kotewo. Ingo Moses da kiki da ri mata ambae ewuse atisira awa gaisira awa ingo ajigedo gaeta? Edo kiki ainda ge awa God mi Moses da yei sisira. Edo God mi sisira, ‘Na awa Abraham da God edo Isaac da God edo Jacob da God.’ ");
INSERT INTO nou_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Edo ge emimi ingodena atopapotira awa God awa embo wasiri de atari da God awarate umo awa embo atae da God aera. Edo ingo awa gaegae be etewa.” ");
INSERT INTO nou_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Edo ungo ge awa sero agodari da atopatari awa ge awa ingise atiko umo kotisira Iesu Sadducee embomei da ge mina awa ewamei setira awa kotedo umo Iesu da yei bugudo sedo gari ititisira, “Agodari nembodiba mo rori?” ");
INSERT INTO nou_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Setiri Iesu mi mina sisira, “Agodari nembodiba re eire, ‘Israel embomei ingiwo. Ingodenaso God da awa nembodiba ra. Edo umo awa ingodenaso gitijigari. ");
INSERT INTO nou_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ingo ingoda gitijigari God awa jo ingoda berari de asisi ingoda berari de goroba ingoda berari de jiro ingoda berari mi dubo buwo.’ ");
INSERT INTO nou_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Edo agodari nembodiba nei awa eire, ‘Imo imosuka dubo buresa da awodo embo nenei dubo buio.’ Edo agodari nenei awa nembogambo rate agodari etoto eiawa nembogambo be nembogambo ra.” ");
INSERT INTO nou_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Edo Iesu awa setiri agodari da atopatari mi Iesu da yei sisira, “Atopatari imo naso mina sari ewamei setesa. Edo imo setesa God umosuka awa ingodenaso God. Edo God nenei atae. ");
INSERT INTO nou_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Edo wasiri wo mi rorou itari edo rorou nenei God da yei rorou itari tendeba da itari da wasiri awa kiambu ewamei na. Awarate wasiri God dubo bari nangoda jo berari edo nangoda asisi berari edo nangoda jiro berari edo nangoda goroba berari da wasiri edo wasiri embo nenei dubo bari teta nango nasuka dubo budo era da awodo edo wasiri etoto awa ewamei be ewamei be ra. Edo imo ro setesa awa gebe ra.” ");
INSERT INTO nou_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Setiri Iesu kotisira umo gari jiwae mi mina setira awasedo Iesu uso yei sisira, “Imo God rora ewagaewa imo embo sia isira awa badi aikambu etesa.” Setiri embo berari iji ainde Iesu da yei sedo gari itari oju isera. ");
INSERT INTO nou_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Edo amboda Iesu Jew embomei da tumondebain ari oro da atopapotise umo embo da yei nganega isira, “Agodari da atopapotegari mi sedo era Keriso awa David da orobe. Ro edo awodo sedo eri?” ");
INSERT INTO nou_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Edo Asisi Kotopu mi David da yei dubo kotari itiri sisira, ‘God mi naso Bada da yei sisira imo naso ingo be da anumbedo atio edo nanemi iso gitopo embo berari awa iso jo da budo dada ano inemi ungo gitijigase God mi sisira.’ ");
INSERT INTO nou_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Edo David awodo sisira edo embo awa uso Bada sisira edo rawodo edo seri Keriso awa David da orobe?” Edo Iesu awodo setiri embo jiwae be ge ingise atisera awa kotisera uso atopatari awa ewamei be ewamei awasedo ungo uso ge ingise atari dipapa isera. ");
INSERT INTO nou_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Edo Iesu embo atopapotise ungoda yei sisira, “Agodari da atopapotegari awa diti jimba ewo. Ungo embo mi ungo gosise ungo embo ewagaewa awa kotarase ombari riribori ombudo ori garori ari yei da yima puma edo era. ");
INSERT INTO nou_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Edo ungo Jew embomei da dada ari oro da mambudo ungo embo nembogambo anumbedo era yei ainda anumbadi dipapa edo era. Edo ungo bondo da mambudo era daedo gitijijigegari anumbedo era yei ainda anumbadi edo era. ");
INSERT INTO nou_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Edo ungo emboevetu rori garori kondade ise arago edo era te ungo ungoda rora bengono edo era. Edo ungo ungoda ari bebegae awa gajadi sedo embo mi ungo gadera yei ainda God da yei gegeta iji ribori edo era. Edo ungo embo ewagaewa awodo edo era. Edo ungoda riroga awa nembodiba be badera.” ");
INSERT INTO nou_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Edo Iesu Jew embomei da tumondebain ari oro da gano kando itari mauma demonda anumbedo atiri edo embo ungoda kando gano awa ititero gosisira. ");
INSERT INTO nou_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Rora embo jiwae be gano jiwae be kando itido isera te evetu rori rora atae da awa bugudo gano memeia etoto awa ititisira. ");
INSERT INTO nou_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Awa gido Iesu uso ambojimbi jawo setiri ungoi dada etero ungoda yei sisira, “Na ingoda yei gebe sena kando evetu rori omimi itira amimi kando embo berari mi itera awa derigetira ainda be awa ungoda atae awa itera te nenei jiwae atira te evetu rora atae eiawa umo uso gano berari itira edo nei ro atae etera.” ");
INSERT INTO nou_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu Jew embomei da tumondebain ari oro dodo mambutiri uso ambojimbi da mi uso yei sisira, “Atopatari gi. Eiawa tumondebain ari oro ingo ove oro da ganuma da amimi ewamei be ewamei ira.” ");
INSERT INTO nou_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Setiri Iesu mi mina sisira, “Gebe mando nembodiba eiawa gi. Embo mi amboda mando eiawa arasegadera. Edo ganuma etoto awa mana dada edo atadera.” ");
INSERT INTO nou_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Edo Iesu Olive doriri Jew embomei da tumondebain ari oro demonda ainda anumbedo atiri Peter de James de John de Andrew de uso yei bugusera. ");
INSERT INTO nou_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Bugudo uso yei sisera, “Se gore awa nanjigo eiri? Edo ro ari nango rora berari einda iji bugira awa geri?” ");
INSERT INTO nou_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Setero Iesu ungoda yei sisira, “Doawo embo mi ingo gandubeore. Gido gogo ewo. ");
INSERT INTO nou_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Embo jiwae be bugudo ge busedo sadera ungo awa Keriso sadera edo ungo mi embo jiwae awa gandubadera. ");
INSERT INTO nou_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Edo ingo embogo da javi aikambu ingido edo embogo da binga besaun ingido awa oju eove. Embogo jiwae be bugadera awarate busu da kasari iji awa bugaera. ");
INSERT INTO nou_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Embo busu neinde kainde berari amimi mina dara adera. Edo embo diti neinde kainde embogo mina ara adera. Edo busu jiwae da busu wasiri adira. Baimana iji bugadira. Edo evetu mei badi jarise uso memesi tuturo da awa kiambu ra awarate amboda memesi awa nembodiba edo ira da awodo memesi nanemi ingoda yei boroko setena awa bugadira. Edo memesi awa bugadira awa ingo gadewa amboda memesi nembodiba awa bugadira. ");
INSERT INTO nou_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Edo ingo ingosuka gido gogo ewo. Embo mi imo bundedo budo kasari oro da mambadera. Edo Jew embomei da dada ari oro da ungoi ingo dadera. Edo ungoi ingo budo gitijigari da dombu da naso jawo awasedo deradewa. Edo ainda derido ingo mi binga ewamei awa ungoda yei sadewa. ");
INSERT INTO nou_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Edo binga ewamei awa giti embo berari busu berari da ainda soro awa busu da sangove awa bugadira. ");
INSERT INTO nou_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Edo ungoi ingo sandido budo kasari oro da mambutiroro ingo ro sevi awa kotove ta iji awa bugadira ainde Asisi Kotopu mi ro sadewa awa sari sadewa. Ingo mi sadi aera te Asisi Kotopu mi sadira. ");
INSERT INTO nou_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Embo mi ungoda nanonamendi awa kasari embo mi dorase itadera edo mamono mi da awodo ungoda kinapeina itadera. Edo kinapeina awa aimamono da gitopo edo isoro embo da itoro doro betadera. ");
INSERT INTO nou_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Edo ingo naso ambojimbi awasedo embo yei berari da mi ingo ujo ae adera. Edo embo ave na ambo ambo ise doae edo embo ave busu da sangove da iji de na gebe adira embo awa God mi soregadira.” ");
INSERT INTO nou_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Edo Iesu atopapotise sisira, “Rora biae be biae awa Jew embomei da tumondebain ari oro da erari ingo mi gadewa. Rora nei mi ainda atae etera katogo awa.” (Embo ave ge jiwari eiawa ajigurira awa gare.) “Edo iji ainde embo ave Judea busu da atima era awa sumbudo doriri da mambore. ");
INSERT INTO nou_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Edo embo ave uso mando gaga da anumbedo atadira awa mana uso mando joda torido uso rora badira te burigi sumbudo mambare. ");
INSERT INTO nou_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Edo embo ave uso buro da buro ira awa mana uso mando da uso ombari badi mambadira. ");
INSERT INTO nou_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Edo iji ainde gasou emboevetu de emboevetu kinapeina emi beda awa memesi nembodiba tambadera. ");
INSERT INTO nou_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Edo God da yei sedo giwo ga iji de eiawa bugure. ");
INSERT INTO nou_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tuturo da God rora berari isira ainda edo mambudo boroko embo mi memesi awa tambudo era te iji ainde memesi awa nembodiba be nembodiba ra. Memesi awodo awa matu ae isira edo sekago amboda memesi awodo awa adi aera. ");
INSERT INTO nou_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Edo wasiri biae ainda iji awa ribori adira awa embo berari awa bebetegadera awasedo God uso embomei kataburisira awasedo ari wasiri biae ainda iji awa tupo adira. ");
INSERT INTO nou_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Edo iji ainde embo amemi iso yei sadira gi Keriso eire o Keriso re oure sadira embo awa gebe eose ainda be awa embo Keriso arago edo edo embo God da binga sari embo inge edo bugadera. ");
INSERT INTO nou_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Edo ungoi ingo embomei God mi kataburisira awa gandubadi adera awasedo ungoi wasiri goroba de embo mi matu gae awa adera edo wasiri embo mi gido kove ari wasiri awa adera. ");
INSERT INTO nou_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ingo gido gogo ewo. Ro amboda bugadira awa nanemi ingoda yei boroko seteno getewa.” ");
INSERT INTO nou_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Edo Iesu atopapotise sisira, “Edo iji biae awa atae ari waiko umenga adira. Edo kariga mana janibadira. ");
INSERT INTO nou_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Edo damana utu da edo dudurigadera. Edo God mi sari utu wasiri adira. ");
INSERT INTO nou_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Edo embo berari mi na God da mei bugudo embo isena awa sekago parara mi jinenebari poroga da edo goroba nembodiba de da engenembadena awa gadera. ");
INSERT INTO nou_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Edo nanemi asisi ewagaewa busu berari einda edo ounda edo yei berari da itano embo God mi kataburisira awa dada adera. ");
INSERT INTO nou_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Edo ingo ri betora awa gido gari gido ewa. Edo betora da patu seka awa be euri ingo ga iji aikambu ira awa gido ewa. ");
INSERT INTO nou_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Da awodo ingo rora eiawa irirari ingo iji aikambu etira awa gadewa. ");
INSERT INTO nou_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Edo na ingoda yei gebe sena. Edo rora eiawa irirari ingoda orobe nenei awa wasiri de atadera. ");
INSERT INTO nou_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Utu de busu de awa atae adira te naso ge awa mata awa atadira. ");
INSERT INTO nou_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Awarate na iji nonde bugadena awa embo mi gaera. God umo na iji nonde bugadena awa gosisira te utu da asisi ewagaewa de na God da mei awa gaera. ");
INSERT INTO nou_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Edo ingo iji awa nonde bugadiri awa ingo gae awasedo gido gogo ewo. ");
INSERT INTO nou_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Edonaso bugari awa eiedo ra. Embo da amimi busu nei esega adi dipapa edo uso buro embo da yei uso rora berari awa simba orase sisira. Edo buro embomei dada da buro ititisira. Edo mangiro be simba ari embo awa gido gogo arase sisira edo embo awa mambusira. ");
INSERT INTO nou_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Edo mando da embo topo iji nonde engenembadira awa imo gae awasedo gido gogo eio. Umo waiko wowosirari engenembadi ta rora o tumba soropu da o sipo be de o waiko vivitirari. ");
INSERT INTO nou_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Edo umo burigi engenembadira awa imo ewo esa awa doaso geure. ");
INSERT INTO nou_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na ingoda yei ro sena awa na embo berari da yei sena ingo gido gogo ewo.” ");
INSERT INTO nou_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iji etoto atae ari Jew embomei da jarusegari bondo awa bugadira. Edo priest gitijijigegari de agodari da atopapotegari de awa emboro eura edo Iesu budo gae unjugari da doro betarase isera. ");
INSERT INTO nou_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Edo ungoi sisera, “Bondo iji de awa ari sago aera ainda be awa embo jiwae mi ge bagedo embogo adera awasedo.” ");
INSERT INTO nou_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu Simon karu leprosy bari embo da mando da atisira. Edo Iesu indari indiri evetu da amimi utingi ganuma mi ari awa siwo muno ewamei de mi beda ari edo uso mina nembodiba be awa budo bugusira. Bugudo torido ganuma utingi ainda dubo awa bejedo siwo awa Iesu da beo da jojisira. ");
INSERT INTO nou_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Edo embo ainda atisera amimi tini gambari edo sisera, “Ro edo evetu oiawa siwo oiawa tepo pigetiri? ");
INSERT INTO nou_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Umo gano embo siwo oiawa ori ae etira. Edo ori edo umo K300 budo edo gano awa embo rora atae embomei da itae etira.” Edo ungo evetu awa awodo gae tu burise sisera. ");
INSERT INTO nou_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Awarate Iesu ungoda yei sisira, “Evetu awa dowo. Ro edo ingo umo bekuba evi? Umo naso yei ro etira amone ewamei be ra. ");
INSERT INTO nou_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Edo embo rora atae awa einda ingo de da atadera awasedo ingoda dipapa mi ungo kondade adewa. Awarate na awa einda ingode daedo atadi aera. ");
INSERT INTO nou_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Edo evetu eiawa ro ae etira awa etira. Na betae eteno umo siwo naso tamo da jojetira awa naso gowari sia etira. ");
INSERT INTO nou_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Edo ruvegeove eiawa. Busu berari da ungoi binga ewamei awa sise ainda evetu emimi ro etira awa embo da sadira awa ruvegadi aera.” ");
INSERT INTO nou_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariot awa Iesu da ambojimbi 12 nei da amimi priest gitijijigegari da Iesu indiga sadi mambusira. ");
INSERT INTO nou_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Edo ungoi Judas ro sisira awa ingido iaviri edo ungoi uso yei gano itadi sari gari sisera. Awasedo Judas iji ewamei budo Iesu indiga sadi simba isira. ");
INSERT INTO nou_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jarusegari bondo da iji tuturo da awa Jew embomei da wasiri awa wo sheepuso mei awa bondo awasedo dedo era. Edo iji ainde Iesu uso ambojimbi mi uso yei nganega isera, “Imo yei rawainda nango mambudo iso jarusegari bondo sia orase dipapa esi?” ");
INSERT INTO nou_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Setero Iesu uso ambojimbi etoto itido ungoda yei sisira, “Ingo Jerusalem nati da totorirowo embo da umo utingi de mi ingo tambadira. ");
INSERT INTO nou_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Edo umo ingo tambari umo ambo ambo ewo. Edo umo mando da torari ingo mando topo ainda yei sewo atopatari mi setira diumba na naso ambojimbi de jarusegari bondo indadena mo rawari? ");
INSERT INTO nou_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Sawo unemi diumba mando inda nembodiba atira unemi rora sia etira awa itari gadewa. Edo ingo diumba ainda torido ingodenaso bondo rora awa berari sia ewo.” ");
INSERT INTO nou_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Setiri ungo yei awa dodo nati nembodiba da mambusera. Edo ungo Iesu mi ro sisira berari awa tambusera. Edo awodo gido ungo jarusegari indari awa sia isera. ");
INSERT INTO nou_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Edo ongobo iri Iesu edo uso ambojimbi 12 awa mando einda bugusera. ");
INSERT INTO nou_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Edo ungo indari indero Iesu mi ungoda yei sisira, “Na ingoda yei eiawa sena embo da ingoda teda amimi na indiga sadira. Edo embo boroko einda nangae indari indise atira amimi adira.” ");
INSERT INTO nou_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Setiri uso ambojimbi dubo vevera edo uso yei da da sisera, “Embo mo namo ta ko amemi eiri?” ");
INSERT INTO nou_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Setero Iesu ungoda yei mina sisira, “Embo da ingoda teda edo embo nangae indari tewo dada indira embo amimi adira. ");
INSERT INTO nou_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Edo na God da mei bugudo embo isena awa betadena teta jiwari da sisera awodo awarate embo na indiga sadira embo awa wasiri biae be awa tambadira. Edo na indiga sadira embo ainda ai mi umo bae doae etira awa ewamei na.” ");
INSERT INTO nou_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Edo ungo indiri indise Iesu ambe budo God da yei ategari itido gavedo uso ambojimbi da yei memeia isira. Edo ititise ungoda yei sisira, “Eiawa naso tamo kumbudo indiwo.” ");
INSERT INTO nou_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Edo umo awa sedo aga budo God da yei ategari itido ungoda yei itiri ungoi da da kiambu kiambu indisera. ");
INSERT INTO nou_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Edo ungoda yei ititise Iesu mi sisira, “Eiawa naso ororo embo berari awa embo jojena amimi God da adi sari seka awa be ira. ");
INSERT INTO nou_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Edo na ingoda yei sena na mana sekago ingode grape da be da ngamo eiawa ingode indadena. Amboda God da gitijigari iji de na ingode umo seka awa ingode indadena.” ");
INSERT INTO nou_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Edo Iesu ge awa setiri ungo berari jasiga ari ya awa sedo mando awa dodo doriri Olive da mambusera. ");
INSERT INTO nou_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu mi ungoda yei sisira, “Ingo berari mi na dodo sumbadewa. Edo ingo awodo awo ro jiwari mi sira awa be adira. Edo jiwari mi sira, ‘God mi wo sheep simba ari embo awa dadira iji ainde wo sheep awa dada adera.’ ");
INSERT INTO nou_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Awarate na betadena ainda amboda wasiri de sekago erido na ingoda giti da Galilee busu da mambadena.” ");
INSERT INTO nou_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Setiri Peter mi mina sisira, “Nenei berari awa ungo imo doadera te na mana imo doadena.” ");
INSERT INTO nou_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Setiri Iesu mi Peter da yei sisira, “Na iso yei ro boroko sena awa ruvegeose. Boroko tumba de kokora egoro etoto sae atirari imo na iji tamonde imo na gae sadesa.” ");
INSERT INTO nou_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Setiri Peter ge tini javi de mina sisira, “Ungoi na dadera awa na ingae betadena awarate na mana na imo gae sadena.” Edo Peter ge awodo setiri ambojimbi nenei sari da awodo sisera. ");
INSERT INTO nou_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Edo ungo yei Gethsemane ainda bugudo Iesu uso ambojimbi da yei sisira, “Na God da yei ge sirinono ingo einda anumbedo atiwo.” ");
INSERT INTO nou_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Sedo Iesu Peter de James de John de budo kiambu yise dubo vevera edo ungoda yei sisira, “Naso dubo vevera nembodiba mi iri na betadi aikambu ena. Ingo einda atise simba ewo.” ");
INSERT INTO nou_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sedo kiambu yise baingo dederi edo dombu busu da edo umo God da yei sedo gosisira, “Dubo vevera da iji bugutira awa derigaetita awa awara ta awa sedo gosena. ");
INSERT INTO nou_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Naso Mama naso Mama imo rora berari awa adesa awa inono be ra. Sedo gosena naso memesi eiawa kumbugae na doare. Awarate imo ro dipapa esa awa egae naso dipapa aera.” ");
INSERT INTO nou_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sedo ambojimbi da yei engenembedo ewo ero gido Peter da yei sisira, “Simon imo ewo esa? Imo iji tupo erido atae etesi ta?” ");
INSERT INTO nou_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sedo ungoda yei sisira, “Wasiri biae eove ta erido atise God da yei ge sewo. Ingo ingoda jo mi ro ewamei awa awase ira te ingoda tamo awa ari sago ae ira.” ");
INSERT INTO nou_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Edo sekago mambudo God da yei ge da awodo sisira. ");
INSERT INTO nou_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Edo sekagoambojimbi da yei engenembedo ungo ewo ero gosisira. Ungo erido atari awa inono ae edo ewo ditivi mi euri ewo edo isira. Edo ungo uso yei ro saderi awa ungo gae. ");
INSERT INTO nou_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Edo Iesu sekago mambudo engenembedo awa ungoda yei sisira, “Ingo ewo ise jango indise atewa? Awara jango indise ewo ise atiwo. Awodo aera ditivi ari iji awa atae etira. Iji bugira. Giwo umo God da mei bugudo embo isira awa embo bebegae da ingo da itadi aikambu etira. ");
INSERT INTO nou_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Eriwo ingode mambore. Giwo embo na indiga sira awa eire.” ");
INSERT INTO nou_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Edo Iesu ge sise atiri Judas ambojimbi 12 da da amimi bugusira. Embo jiwae be isoro gi emi budo Judas ga da bugusera. Priest gitijijigegari de agodari da atopapotegari de Jew embomei da embo nembogambo mi itero mambusera. ");
INSERT INTO nou_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Edo indiga sari embo mi matu embo da yei sisira, “Embo ave nanemi tamo dorasegurise muno adena embo amone embo ingo dipapa ewa awara. Ingo berari umo jigido edo takibedo budo mambuwo.” ");
INSERT INTO nou_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Edo Judas bugudo Iesu da yei mambudo tamo dorasegurise muno edo sisira, “Atopatari.” ");
INSERT INTO nou_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Edo Judas awodo etiri ungoi Iesu bundedo goroba de jijigurisera. ");
INSERT INTO nou_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Awarate embo da embo jiwae da teda atisira amimi uso kasiwo budo priest gitijigari da buro embo da dengoro awa diugurisira. ");
INSERT INTO nou_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Diugetiri Iesu mi ungoda yei sisira, “Na bengono embo awa embo mi eura eri ta? Ingo ro edo iso gi emi de na bundadi bugevi? ");
INSERT INTO nou_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na iji berari Jew embomei da tumondebain ari oro da atopatido isena ainde ingo na bundae. Awarate jiwari awa be are.” ");
INSERT INTO nou_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Setiri ambojimbi umo dodo berari sumbudo mambusera. ");
INSERT INTO nou_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Edo mei singa da bo da awa ewudo Iesu ambo ambo isira. Edo ungo umo bundari dipapa edo umo sandisera. ");
INSERT INTO nou_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Edo ungo wasiri jiwae ero uso bo ujugetiri umo dodo sumbudo mambusira. ");
INSERT INTO nou_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Edo ungo mi Iesu budo priest gitijigari nembodiba da mando da priest gitijijigegari de Jew embomei da embo nembogambo de agodari da atopapotegari de dada edo atisera ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Edo Peter aike be Iesu ambo ambo ise mambusira awa priest gitijigari da mando da ara digari da awodo pon da totorisira. Torido ainda mando simba ari embomei de anumbedo atisira. Edo umo anumbedo ainda ri egise atisira. ");
INSERT INTO nou_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Edo priest gitijijigegari de Jew embomei da gitijijigegari de awa Iesu bekuba edo doro betarase sedo ungoi uso wasiri biae ro ari ri awa eura be eura isera. Edo ungo eura isera te da biae ro tambae. ");
INSERT INTO nou_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ro Iesu mi isira awa embo jiwae mi ge busisera te ungoda ge busari awa da awodo ae. ");
INSERT INTO nou_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Edo embo nenei mi erido ge busedo sisera, “Nango ingisera Iesu mi sisira nanemi Jew embomei da tumondebain ari oro embo mi isera eiawa arasegadena te iji tamonde de nanemi nei adena embo da ingo mi ari ae awa sisira.” ");
INSERT INTO nou_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Edo embomei awa ge busari awodo isera te kiki berari ungoi sisira awa neinde kainde ra. Ungo kiki nenei de da awara ae edo isera. ");
INSERT INTO nou_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Edo priest gitijigari nembodiba embo berari da joda erido Iesu nganega isira, “Embo einda atera amimi imo bekuba era imo ungoda yei ge mina sari mo atae ta?” ");
INSERT INTO nou_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Setiri Iesu ge ambu isira ge da ro sae isira. Edo priest gitijigari sekago Iesu da yei nganega isira, “Imo mo Keriso ta? God nango berari mi iji berari jasiga edo era ainda mei ta?” ");
INSERT INTO nou_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Setiri Iesu mi mina sisira, “Gebe na awa God da mei. Amboda na God da mei bugudo embo isena awa God goroba jiwae da ingo be da anumbedo atinono ingo gadewa. Edo na utu da poroga de bugutinono ingo gadewa.” ");
INSERT INTO nou_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Setiri priest gitijigari uso ombari kerise sisira, “Embo Iesu bekuba awa tambadi ingodena ro edo eura eri? ");
INSERT INTO nou_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ingo berari uso ge biae awa ingewa ingo ro adi kotevi?” Setiri ungo berari mi sisera, “Umo wasiri biae etira awasedo doro betare.” ");
INSERT INTO nou_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sedo ungoi Iesu da yei kosiwa edo uso dombu bo begiti mi digido ungoi umo dorisera. Edo ungo Iesu dorise uso yei sisera, “Embo amemi imo detiri awa uso jawo se gore.” Setero buro embo mi umo budo mambuse ungoi ingo beraga edo uso sogo da dorisera. ");
INSERT INTO nou_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Edo Peter ainda priest gitijigari da mando ponda ara da atiri priest gitijigari nambodiba da buro ari gagara da awa bugusira. ");
INSERT INTO nou_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bugudo Peter ri egise demonda atiri gido gon gon edo Peter da yei sisira, “Imo awa Iesu Nazareth embo da uso ambojimbi nei ra.” ");
INSERT INTO nou_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Setiri Peter mi mina sisira, “Na gaera. Na imo ge ro sesa awa gaera.” Sedo umo amboda ara be da yeri kokora egoro sisira. ");
INSERT INTO nou_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Edo buro gagara mi Peter ainda gido embo derido atisera ainda sisira, “Embo emone uso embo nei ra.” ");
INSERT INTO nou_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Setiri Peter sekago sisira, “Imo ge busesa.” Edo iji tupo embo ainda dederigedo atisera amimi sekago Peter da yei sisera, “Nango gebe sera. Imo awa uso embo nei ra ainda be awa imo awa daedo Galilee busu embo ra.” ");
INSERT INTO nou_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Setero Peter ge tini javi de sisira, “Na ge busadena awa God mi naso riroga itare. Embo ingo sewa embo awa na umo gaera.” ");
INSERT INTO nou_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Setiri kokora sekago egoro sisira. Egoro setiri Peter Iesu uso yei ro sisira awa kotisira. Iesu matu Peter da yei sisira, “Kokora egoro iji etoto sae atirari iji ainde imo na gae iji tamonde sadesa.” Edo Peter ge awa kotedo ji biae be sisira. ");
INSERT INTO nou_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sipo be sipo de priest gitijijigegari de Jew embomei da embo nembogambo de agodari da atopapotegari de edo Jew embomei da gitijijigegari de burigi be dada isera edo Iesu dadi kiki dirisera. Edo ungoi Iesu da ingo bundedo budo Pilate da yei mambusera. ");
INSERT INTO nou_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Etero Pilate mi Iesu nganega isira, “Imo Jew embomei da gitijigari nembodiba ta?” Setero Iesu mi mina sisira, “Inemi sesa da awodo awara.” ");
INSERT INTO nou_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Setiri priest gitijijigegari Iesu bekuba isera amimi sisera Iesu wasiri bebegae edo isira sisera awasedo Pilate Iesu sekago nganega isira, “Imo ro edo ge mina sae esi? Ungo imo bekuba ise sera imo wasiri bebegae jiwae edo esa sera.” ");
INSERT INTO nou_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Awarate Iesu ge mina sae etiri Pilate kove be kove isira. ");
INSERT INTO nou_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jarusegari da bondo iji ainde embo embo ave dipapa edo iseri awa Pilate mi wujegedo isira. ");
INSERT INTO nou_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Iji ainde embo jawo Barabbas de embo daga embo da gitijijigegari budo wawara adi edo isera awa bundari oro da atima isera. Embomei eiawa bundari da atima isera ainda be awa ungo embogo ise embo nenei detero bebetisira awasedo. ");
INSERT INTO nou_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","9","Edo embo jiwae dada edo ungoda wasiri awodo gido Pilate da yei sedo gosisera bundari embo da wujegarase awasedo Pilate ungoda yei nganega isira, “Ingo dipapa nanemi Jew embomei da gitijigari nembodiba awa wujegedoingoda yei itanase dipapa evi ta?” ");
INSERT INTO nou_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilate awodo sisira ainda be awa umo gosisira priest gitijijigegari awa Iesu ujo ae edo uso ingo da ititisera awa. ");
INSERT INTO nou_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Awarate priest gitijijigegari embo da yei sisera Pilate soro Iesu awa doturise Barabbas awa wujegarase edo ungoda yei itarase. ");
INSERT INTO nou_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Awasedo Pilate sekago embo da yei ge sisira, “Na Barabbas wujegadena edo embo Jew embomei da gitijigari nembodiba sedo ewa amo ro eni?” ");
INSERT INTO nou_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Setiri ungoi gogo dimbudo mina sisera, “Benema mi orega da deio betare.” ");
INSERT INTO nou_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate mi nganega isira ro edo awodo sevi? Umo wasiri biae ro etiri?” Setiri ungoi gogo nembodiba dimbudo sisera, “Benema mi orega da deio betare.” ");
INSERT INTO nou_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Setero Pilate ari embo dubo ewamei orase Barabbas awa wujegedo Iesu awa ungoda ingo da ititisira. Edo setiri ungoi Iesu vejedo edo embo da yei benema mi orega da doro betarase ititisera. ");
INSERT INTO nou_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Edo isoro embomei Iesu budo Rome embomei da gitijigari da kasari yei da mambudo setero isoro embo nenei daedo dada isera. ");
INSERT INTO nou_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ungoi berari dada edo ombari kokoi awa itero Iesu mi ombusira edo gobe jiroroka ari awa bebe mi edo uso beo da ititisera. ");
INSERT INTO nou_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Awodo edo umo gandubedo uso yei sisera, “Jew embomei da gitijigari nembodiba imo awara.” ");
INSERT INTO nou_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Edo ungo awodo sedo ituka mi umo beo da dedo kosiwa edo baingo dederi edo uso yei tumondebain edo isera. ");
INSERT INTO nou_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Edo ungo umo gandubedo atae edo ombari kokoi awa totigedo uso ombari topo awa sekago itero ombusira. Awodo edo ungoi Iesu budo ponda bugudo benema mi orega da doro betarase budo mambusera. ");
INSERT INTO nou_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Edo ungo mambuse embo jawo Simon tambusera. Embo Simon eiawa Alexander de Rufus de da mamo awa uso busu Cyrene awa dodo Jerusalem nati da mambusira. Edo ungoi umo tambudo umo sae beuso aera te setero Iesu da orega ango isira. ");
INSERT INTO nou_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Edo ungoi Iesu budo bugudo yei jawo Golgotha uso jawo ainda be awa agatu da yei ainda bugusera. ");
INSERT INTO nou_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Edo ainda ungoi Iesu grape ngamo awa rora tokaka de dada isera awa itoro indarase isera te umo indari ujo ae isira. ");
INSERT INTO nou_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Edo jareriko ungoi benema mi Iesu orega da dorisera. Edo ungo Iesu orega da dedo uso ombari awa kando edo badi sedo amemi bo rawa beiri awa gadi sedo ungo pipi isera. ");
INSERT INTO nou_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Edo sipo de 9 A.M. awa Iesu orega da dorisera. ");
INSERT INTO nou_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Edo bekuba ari ge ungoi gaisera awa sisera, “Umo awa Jew embomei da gitijigari nembodiba.” ");
INSERT INTO nou_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Edo iji ainde ungo embo bengono embobo etoto daedo orega da benema mi dorisera bengono embo da awa Iesu da ingo be da edo nei awa uso ingo anda da. ");
INSERT INTO nou_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Edo ungo awodo isera amimi ro jiwari da awa be isira edo jiwari mi sisira, “Ungoi umo embo bebegae deda ititisera.” ");
INSERT INTO nou_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Edo embo yima derigurise mani mani ise ge biae Iesu da yei sise sedo isera, “Imo Jew embomei da tumondebain ari oro arasegedo edo iji tamonde de sekago adi mo inemi sedo isesa? ");
INSERT INTO nou_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Boroko orega dodo wosedo imo imosuka soregeio.” ");
INSERT INTO nou_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Da awodo priest gitijijigegari de agodari da atopapotegari de mi Iesu gandubedo ungo ungosuka mina sara edo isera, “Umo embo nenei soregedo isira te umo umosuka soregari awa umo gaera. ");
INSERT INTO nou_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Edo Keriso Israel embomei da gitijigari nembodiba orega dodo wosari ingodena gadera awa ingodena umo gebe adera.” Edo embo etoto Iesu ga daedo orega etoto da dorisera awa daedo Iesu da yei ge bebegae sisera. ");
INSERT INTO nou_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Iji soropu da umenga mi busu berari awa apuregurisira. ");
INSERT INTO nou_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Edo iji wosedo yiko ongobo iri iji 3 P.M. awa umenga atae etiri Iesu gogo dimbudo sisira, “Eli Eli Lama Sabachthani,” ainda be awa “Naso God naso God ro edo na dotesi?” ");
INSERT INTO nou_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Setiri embo nenei ainda atisera amimi ingido sisera, “Elijah jawo sira mo gosewa?” ");
INSERT INTO nou_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Setero embo da mi bo budo grape ngamo tokaka ainda patido ituka mendo da itido Iesu mi indarase jijigurisira. Edo Iesu da begiti aikambu jigiri embo nenei mi sisera, “Simba e. Elijah mo bugudo umo orega da budo itari woseita? Awa ingode simba ise gore.” ");
INSERT INTO nou_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Setiri Iesu gogo dimbudo umo bebetisira. ");
INSERT INTO nou_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Edo Iesu betetiri bo Jew embomei da tumondebain ari oro da yei kotopu da be gajari awa inda tuturo edo bugudo tu edo keresegurisira edo bo be etoto isira. ");
INSERT INTO nou_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Edo isoro embo 100 awodo da gitijigari umo orega da jo kena derido atisira amimi Iesu gogo dimbudo bebetisira awa gido sisira, “Gebe embo emone God da mei ra.” ");
INSERT INTO nou_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Edo emboevetu nenei daedo besaungo atisera awa gosise atisera. Edo emboevetu ainda teda awa Mary Magdalene de Mary de Joseph de uso namendi singa James de da ai de Salome de awa ainda atisera. ");
INSERT INTO nou_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Edo Iesu Galilee busu da pepeta edo isira ainde emboevetu awawa Iesu ambo ambo ise umo kondade edo isera. Emboevetu nenei jiwae Iesu ga da Jerusalem bugusera awa daedo ainda atisera. ");
INSERT INTO nou_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ongobo edo piri Joseph Arimathea nati embo amimi bugusira. Embo eiawa Jew embomei da gitijigari awa God da gitijigari iji awa bugarase dipapa edo isira. ");
INSERT INTO nou_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph awa gosisira iji awa bondo sia ari iji edo gosisira euma awa Jew embomei da tumondebain ari iji awasedo umo goroba edo Pilate da yei mambudo Iesu da tamo itari badi atega sisira. ");
INSERT INTO nou_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Edo Pilate Iesu matu betetira ainda ge awa ingido kove isira. Edo Pilate setiri isoro embobo 100 da gitijigari bugudo toriri Pilate uso yei sisira, “Iesu matu betetita?” ");
INSERT INTO nou_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Setiri isoro embo bo da gitijigari mi mina sisira, “Gebe umo matu betetira.” Edo Pilate ge awa ingido Joseph da yei sisira, “Awara Iesu da tamo buio.” ");
INSERT INTO nou_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Setiri Joseph bo seka budo Iesu da tamo itiri wosetiri bo amimi ruwusira. Edo tamo awa ruvedo budo uje meko da ainda ititisira. Itido ganuma nembodiba awa mimino mimino etiri bugudo uje meko be awa gajisira. ");
INSERT INTO nou_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Edo Joseph umo awa iri Mary Magdalene de Mary Joseph da ai de Iesu rawainda ititiri awa gosisera. ");
INSERT INTO nou_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Edo Jew embomei da tumondebain ari iji atae etiri Mary Magdalene de Mary James da ai de Salome awa siwo muno de awa ori edo Iesu da tamo da itadi isera. ");
INSERT INTO nou_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Edo Sunday sipo waiko seka sineguriri emboevetu eiawa uje meko be da ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Edo ungo mambuse ungosuka mina sara isera, “Embo amemiingodenaso ganuma awa miminegoro demonda yeiri?” Edo ungo awodo sisera ainda be awa ganuma awa nembodiba awasedo. ");
INSERT INTO nou_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Edo ungo uje meko da ainda bugudo ungo ganuma nembodiba awa matu demonda atiri gosisera. ");
INSERT INTO nou_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Edo ungo uje meko da ainda torido mei singa ombari parara edo ingo be kena anumbedo atiri gosisera. ");
INSERT INTO nou_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Gido ungo oju isera te unemi ungoda yei sisira, “Oju eove. Na gosena ingo awa Iesu dorisera awa eura ewa. Edo umone einda ataera umone erira. Giwo uso tamo itititara yei re eire. ");
INSERT INTO nou_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ingo mambudo binga eiawa uso ambojimbi de Peter de da yei sewo, ‘Umone giti giti Galilee busu da mambutira ainda gadewa unemi ingoda yei sisira awodo.’” ");
INSERT INTO nou_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Setiri ungo kokombo awa dodo sumbudo mambusera ainda be awa ungo kove isera edo daedo oju isera awasedo. Edo ungo oju edo gido embo nenei da sae isera. (Binga ewamei Mark mi gaisera awa einda atae ira te matu be matu embo nei mi ge nei gaisira awa Mark da ge da sangove da ititisira. Embo ainda ge re eire.) ");
INSERT INTO nou_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sunday sipo be de Iesu erido umo Mary Magdalene asisi bebegae 7 ondetiri bugusera ainda yei giti ujiji etiri gosisira. ");
INSERT INTO nou_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Edo evetu awa gido mambudo Iesu da otatao ungo ji mi bebetegedo atisera ainda sisira, “Na boroko Iesu wasiri de getena.” Setiri ungo umo gebe ae isera. ");
INSERT INTO nou_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Edo iji tupo Iesu gari nei edo embo etoto emboro da pepeta edo nati nei da mambutero ainda ujiji etiri gosisera. ");
INSERT INTO nou_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Edo ungo gido Jerusalem nati da engenembedo embo nenei ainda awa setero gosisera. ");
INSERT INTO nou_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Edo amboda ambojimbi 11 awa indari indero umo umosuka ujiji etiri gosisera. Edo ungo jo okain edo embo nenei Iesu wasiri de gido sedo isera awa gebe ae edo isera awasedo Iesu ungo isiburisira. ");
INSERT INTO nou_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Edo umo ungo isibedo ungoda yei sisira, “Mambuwo busu neinde kainde da binga ewamei eiawa embo berari da sewo. ");
INSERT INTO nou_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Edo embo ave binga ewamei eiawa gebe edo isera awa umo mi ewamei isera embo awa God mi soregadira. Awarate embo ave binga ewamei gebe ae edo isira embo awa God mi mana soregadira. ");
INSERT INTO nou_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Edo embo ave na gebe adera awa ari wasiri nembogambo adera. Edo naso jawo da asisi bebegae ondadera. Edo ungo ge nei embo mi matu ingae ge awa sadera. ");
INSERT INTO nou_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Edo ungo jingabu embo gambari betari jingabu awa jigadera te ungo mana nei ro adira. Edo ungo umo indapu awa indadera awa ungo mana betadera. Ungo ungoda ingo awa karu embo da tamonda itoro embomei awa ewamei adera.” ");
INSERT INTO nou_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Edo gitijigari Iesu uso ambojimbi da yei ge setiri God mi umo budo utu da vitiri umo God da ingo be da anumburisira. ");
INSERT INTO nou_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Edo ambojimbi yei neinde kainde da mambudo binga ewamei awa embo da yei sisera. Edo ungo binga ewamei sero God ungo kondade edo embo mi uso ge awa gebe orase ari wasiri nembogambo edo isera. ");
INSERT INTO nou_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Oarie Theopilus, Embo jiwae ingodenaso teda ro iutara awa gositara tuturo da edo bugudo boroka da. ");
INSERT INTO nou_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Edo ungo ro gosisera awa ungo ingodenaso yei seoro gido era. Edo ungo binga ewamei sedo era. Edo embomei berari eiawa ro atopatido era awa ungo kiki awa gaedo era. ");
INSERT INTO nou_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Embo nembogambo Theopilus awodo na kotena na daedo gaiadena awa kotari ewamei ra ainda be awa na rora ro berari isira awa kotedo gogo edo ena awasedo. ");
INSERT INTO nou_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Edo imo ro iutara awa matu ingutasa te na imo gido gogo asase dipapa ena awasedo eno isaga iri iso yei kiki eiawa gaena. Edo kiki re eire. ");
INSERT INTO nou_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod awa busu Judea embomei gitijigido isira iji ainde priest jawo Zechariah awa ainda atima isira. Umo awa Abijah da orobe. Edo Abijah de uso orobe de awa iji berari Mamo sapo edo isera. Edo Zechariah da uso aro Elizabeth awa orobe nei ungo iji berari Mamo sapo edo isera. ");
INSERT INTO nou_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Edo evetu de embo de eiawa ungo Mamo da agodari berari awa beuso ae edo isera te kera edo isera. ");
INSERT INTO nou_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Awarate ungo awa kinapeina ae ainda be awa Elizabeth awa ero edo Zechariah awa embo ogo etiri edo Elizabeth awa evetu ogo isira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Iji da Zechariah awa Mamo da buro Jew embomei da tumondebain ari oro da isira. Iji dada priest Jew embomei da tumondebain ari oro da awa ungoda wasiri awodo gido buro neinde kainde edo isera. ");
INSERT INTO nou_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Iji da priest da buro nei edo isira edo iji nei buro nei edo isira. Edo iji boroko Zechariah da orobe da iji awasedo umo Jew embomei da tumondebain ari oro da torido tetemba joino muno de dungoro muno ewamei edo isira awa unemi simba edo isira. ");
INSERT INTO nou_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Edo umo buro awa iri embo jiwae Jew embomei da tumondebain ari oro ponda gaga da atise edo ungo joino muno de dungoro muno ewamei edo isira iji ainde Mamo da yei ge sedo isera. ");
INSERT INTO nou_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Edo ungo awa ero asisi ewamei mi bugudo Zechariah da ingo be da tetemba da dederisira. ");
INSERT INTO nou_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","13","Edo umo ainda deriri Zechariah umo gido umo mana mana edo oju isira awarate asisi ewamei mi uso yei sisira, “Zechariah oju eose Mamo mi iso ge awa ingira awasedo ari iso aro Elizabeth awa mei badira. Edo umo mei bari imo uso jawo awa John sadesa. ");
INSERT INTO nou_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Edo imo awa iaviri adesa edo embo jiwae nenei daedo iaviri adera ainda be awa iso aro awa mei John betira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Edo umo awa Mamo da buro ari embo nembodiba edo uso wasiri tuturo da awa Asisi Kotopu mi umo beda adira edo uso jo da atadira. Edo umo mana ribe grape da ngamo awa mana indadira edo umo mana umo okain awa mana indadira. ");
INSERT INTO nou_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Edo Israel embo jiwae be Mamo dubo bae doturisera awa John mi ari ungoi Mamo da yei sekago engenembadera. ");
INSERT INTO nou_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Matu be Asisi Kotopu mi etiri Mamo da binga sari embo Elijah goroba isira da awodo Asisi Kotopu mi ari John awa Mamo da binga sari embo goroba adira. Edo John mi ari mamo de kinapeina de tini gambari mina ara ewora awa atae adira. Edo unemi ari embo Mamo da ge beuso ewora awa Mamo da ge kera adi tuturo adera teta Mamo da embomei mi edo era da awodo. Edo John mi ari embo jiwae awa Keriso da bugari awasedo sia adera.” ");
INSERT INTO nou_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Edo asisi ewamei awodo setiri Zechariah mi uso yei sisira, “Na awa embo ogo etena edo naso aro daedo awa evetu ogo ra. Edo imo ro setesa awa ge be ta? Na rawodo geni?” ");
INSERT INTO nou_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","20","Setiri asisi ewamei mi mina sisira, “Na Gabriel iji berari Mamo da dombu da atima ena. Unemi na itiri iso yei binga ewamei eiawa sadi bugena awarate imo naso binga eiawa ge be ae kotesa awasedo imo ge sadi ae atadesa. Edo atiroso amboda na iso yei da ro setena awa be adira iji ainde imo sekago ge sadesa.” ");
INSERT INTO nou_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Edo asisi ewamei de Zechariah de ge sise atero embo Zechariah simba atisera amimi kotisera Zechariah ro edo Jew embomei da tumondebain ari oro da borere be atiri? ");
INSERT INTO nou_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Edo Zechariah bugusira awa umo ungoda yei ge sadi jarisira awasedo ungo gosisera umo Jew embomei da tumondebain ari oro da atari jirira awa umo gari usasa be awa getira. Edo Zechariah ge sari ato jarise uso ingo mi iwata kawata isira. ");
INSERT INTO nou_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Edo Zechariah da buro iji atae etiri umo uso mando da mambusira. ");
INSERT INTO nou_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mandoda mambudo atiri uso aro awa gasou jijirisira. Edo kariga ingo da awa mando da atisira. ");
INSERT INTO nou_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Awodo ise sisira, “Mamo mi na emboro eiedo da kondade etiri naso me gari awa atae etira.” ");
INSERT INTO nou_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth gasou jiriri amboda kariga 6 atae etiri Mamo asisi ewamei Gabriel itiri Nazareth Galilee da ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Edo gagara ademei jawo Mary de embo jawo Joseph de awa gitijigari nembodiba David da orobe awa ainda atima isera. Edo embo awa gagara awa jimbarase ungoda orobe ge sedo matu awara isera. ");
INSERT INTO nou_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Awarate iji ainde Joseph evetu awa jimbae atiri asisi ewamei mi Mary da yei bugudo sisira, “Dubo ewamei de da atio. Mamo imo de daedo atise imo ewamei be ira.” ");
INSERT INTO nou_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Setiri asisi ewamei da ge awa Mary da yei bouga budo pusira ainda be awa umo asisi ewamei da ge awa be gae isira. ");
INSERT INTO nou_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Edo Mary umo awodo kotiri asisi ewamei mi uso yei sisira, “Mary oju eose, Mamo iso yei ewamei etira. ");
INSERT INTO nou_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Imo gasou jirido mei budo uso jawo awa Iesu sadesa. ");
INSERT INTO nou_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Edo umo awa embo nembodiba adira rora berari adira ainda tamo da Mamo da mei adira. Edo Mamo mi ari Iesu awa gitijigari nembodiba adira teta uso umbogo David awa gitijigari nembodiba awodo. ");
INSERT INTO nou_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Unemi Jacob da orobe awa mata awodo gitijijigurise atadira. Uso gitijigari da iji awa mana atae adira te mata awa atadira.” ");
INSERT INTO nou_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Setiri Mary asisi ewamei da yei sisira, “Na awa ademei ra awasedo na rawodo edo mei beni?” ");
INSERT INTO nou_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Setiri asisi ewamei mi mina sisira, “Asisi Kotopu mi iso yei bugari edo Mamo da goroba mi ari imo gasou jiradesa awasedo mei inemi badesa awa mei wasiri biae de ae ra, Mamo da mei na. ");
INSERT INTO nou_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Edo iso orobe Elizabeth awa koteio. Embo kotisera awa umo kinapeina bari sago ae awarate umo gasou jirido kariga 6 awa awodo atevira. ");
INSERT INTO nou_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Edo Mamo awa goroba de goroba de gido rora berari awa adira.” ");
INSERT INTO nou_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Setiri Mary mi sisira, “Na awa Mamo da buro ari gagara. Ro inemi setesa naso yei awa awodo are.” Setiri asisi ewamei umo dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Iji tupo amboda Mary uso rora sia edo burigi be Elizabeth da nati Judea doriri da ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mambudo ainda Zechariah da mando da totorise umo Elizabeth atega isira. ");
INSERT INTO nou_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Edo Elizabeth uso ge javi ingiri uso tini da mei wasiri isira. ");
INSERT INTO nou_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Edo Elizabeth Asisi Kotopu mi jo da buro etiri kotari itiri umo duduku edo Mary da yei sisira, “Imo awa emboevetu nenei de inono ae. Edo mei kiambu iso tini da atira awa ewamei be ra. ");
INSERT INTO nou_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","44","Imo awa naso Bada da ai edo na esega eiedo esa amimi imo naso yei jasiga ari nembodiba be esa awasedo na iso atega awa ingeno mei kiambu naso tini da awa dubo ewamei edo wasiri etira. ");
INSERT INTO nou_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Imo binga ro Mamo mi iso yei itira awa ge be edo dubo ewamei etesa ainda be awa imo gosesa Mamo ro setira awa be adira awasedo.” ");
INSERT INTO nou_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Edo umo awodo setiri Mary mi sisira, “Na naso jo berari mi Mamo jasiga ena edo dubo ewamei ena ainda be awa Mamo naso soregari embo na ruvegae. ");
INSERT INTO nou_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na umo saboa edo kera ise atima ena. ");
INSERT INTO nou_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mamo goroba jiwae mi berari eiawa naso yei etira awasedo orobe berari boroko tuturo edo iji jaige sadera Mamo uso yei kando edo umo kondade nembodiba etira awasedo umo dubo ewamei ari de atima ira sadera. Edo Mamo da jawo kotopu awa embo mi mana uso jawo tepo sadera. ");
INSERT INTO nou_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","“Edo Mamo uso jawo embo berari orobe da amimi sapo adera awa ungoda yei jo ari iji berari adira. ");
INSERT INTO nou_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Awarate Mamo da goroba mi euri jariga embobo rora ro edo oro ungoda jawo nembodiba arase edo era awa biae edo era. ");
INSERT INTO nou_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Edo Mamo mi euri gitijijigegari nembogamo jiwae awa durido era awarate Mamo mi embo jiwae embo nembogamo ae awa jiguri erido ungo embo nembogambo edo era. ");
INSERT INTO nou_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","“Edo Mamo embo beji mi ambutera ainda yei rora ewagaewa jiwae itira awarate rora embobo uso yei bugero ungoda yei rora itae tepo itiri mambera. ");
INSERT INTO nou_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Edo umo ingodenaso mamoumbogo da yei jo ari adi sari sisira awa umo ruvegae. ");
INSERT INTO nou_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Edo umo Abraham da yei adi sari ge sise sisira, ‘Nanemi iji matawa imo de edo iso orobe de ewamei adena.’” ");
INSERT INTO nou_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Awodo sedo Mary Elizabeth ga atinatina. Amboda kariga tamonde atae etiri uso nati da engenemburisira. ");
INSERT INTO nou_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth da mei bari iji awa bugiri umo mei burisira. ");
INSERT INTO nou_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Edo uso orobe de otatao de Mamo mi ro nembodiba ewamei etira awa ingido ungo dubo ewamei be ewamei isera. ");
INSERT INTO nou_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Edo iji 8 ainda amboda ungo mei ainda tamo kotopu da andiso diugurise uso mamo Zechariah da jawo sadi isera te uso ai mi sisira, “Awodo ae ra ingode uso jawo John sadera.” ");
INSERT INTO nou_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Setiri ungoi uso yei sisera, “Awarate iso orobe da jawo da awodo awa atae ra.” ");
INSERT INTO nou_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sedo ungoi ingo mi iwata mamo da yei etero umo mei da jawo ro sadi ira awa sedo gosisera. ");
INSERT INTO nou_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Edo ungo awodo nganega etero Zechariah uso ingo mi ove jiwari rora embo sisira. Setiri ungoi itero umo gaisiri, “Uso jawo John.” Gaitiri ungo berari kove be isera. ");
INSERT INTO nou_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Edo iji ainde Zechariah sekago ge sadi tuturo isira edo Mamo jasiga isira. ");
INSERT INTO nou_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Awasedo embo demo da atisera awa oju isera. Edo binga awa ungoi yei berari da sisera edo Judea embo doriri da atima isera awa ro isira awa ingisera. ");
INSERT INTO nou_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Edo ungo binga awa ingido nganega edo gosisera, “Amboda mei eiawa bajido mo buro mo ro eiri?” Mamo da goroba awa mei kiambu einda jo da atima ira awa ungoi isaga gosisera. ");
INSERT INTO nou_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John da mamo Zechariah awa Asisi Kotopu mi usu jo da buro euri atise umo Mamo da binga sedo isira. ");
INSERT INTO nou_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Edo sisira, “Israel embomei da Mamo awa ingode berari umo jasiga ore. Umo uso embo kondade adi bugudo ungo soregetira. ");
INSERT INTO nou_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Umo ingodenaso yei soregari embo goroba jiwae de itiri bugusira embo David da orobe da uso kondade ari embo. ");
INSERT INTO nou_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Matu Mamo mi uso binga sari embo da yei sisira edo ungo umo ro sisira awa embo da yei sisera. ");
INSERT INTO nou_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mamo mi adi sari sisira, ingodenaso gitopo ingodena dadi aikambu iriroro unemi ingodena kondade adi sisira. Edo umo daedo adi sari sisira embo ave ingodena ujo ae ise biae adi era ainde ingodena soregadi sisira. ");
INSERT INTO nou_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","“Edo umo sisira uso adi sari awa ruvegadiae awasedo umo ingodenaso mamoumbogo da yei jo ari isira. ");
INSERT INTO nou_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Umo adi sari ingodenaso umbogo Abraham da sisira isoro embomei mi ingodena badi iriroro unemi ingodena soregadi sisira. Edo unemi sisira ingodenaso wasiri ewamei uso dombu da wasiri da orase sisira edo oju ae umo kera orase sisira. ");
INSERT INTO nou_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Edo imo naso mei ungoi sadera imo awa Mamo goroba jiwae da binga sari embo sadera. Edo imo Bada da giti da mambuse uso emboro sia adesa. ");
INSERT INTO nou_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Edo inemi uso embo da yei sadesa Mamo mi ungoda buria kotembedo dodo ungo soregadira sadesa. ");
INSERT INTO nou_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Edo Mamo awa embo jo embo edo embo berari da yei jo edo ira. Edo unemi soregari embo itari ingodenaso yei bugadira teta unemi euri iji sipo de vitido parara de jani beuri edo umenga atae edo ira da awodo. Edo ingodena embo awa wasiri biae edo era teta embo umenga da atima edo era da awodo. Edo ingodena awa betari oju edo era edo ingodena awa teta embo umenga da atima era da awodo. Edo Mamo ingodenaso yei parara itadira edo umo ingodena emboro seka da gitijigido budo mambari dubo ewamei ari tamborase ira.” ");
INSERT INTO nou_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Edo amboda mei awa bajido goroba etiri umo gari ewamei budo umo yei embo atae ainda atima edo isira. Edo ambo be ambo da umo buro adi tuturo isira ainde Jew embobo da yei bugusira. ");
INSERT INTO nou_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Iji ainde Rome embomei da gitijigari nembodiba be Caesar Augustus umo embo gitijigido isira ainda yei binga ititisira. Edo umo embo roinge atera awa gadi dipapa edo gido sisira embo berari ungoda nati da mamboro buro embo nenei mi ungoda jawo awa gaiari pepa da gaiorase sisira. Ainda be awa embo da jawo gaiari da buro awa ungo matu ae isera. ");
INSERT INTO nou_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Edo Quirinius Syria busu embo da gitijigari nembodiba awa buro nembodiba eiawa kondade isira. ");
INSERT INTO nou_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Edo embo berari binga eiawa ingido ungoda nati be da mambusera. ");
INSERT INTO nou_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Edo gitijigari nembodiba be David da nati awa Bethlehem nati ra. Edo Joseph awa David da orobe ra awasedo umo Nazareth nati Galilee busu da awa dodo Bethlehem nati Judea busu da ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Edo Joseph Mary gagara unemi jimbadira awa budo daga mambusira ungoda jawo awa buro embo mi gaiorase. ");
INSERT INTO nou_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Edo iji ainde Mary awa uso mei bari iji aikambu isira. Edo ungo Bethlehem atise edo Mary da mei bari iji awa bugiri edo esega embo da ewari oro awa embo mi beda isera awasedo ungo wo mane da ewari oro da mambusera. ");
INSERT INTO nou_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Edo ungo ainda torido edo Mary uso mei bego awa burisira. Edo budo bo mi mei ruvedo wo mane da undari yei da ainda umo simba isira. ");
INSERT INTO nou_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wo sheep simba ari embo nenei awa yei besaungo tumba de ungoda wo sheep awa simba ise atisera. ");
INSERT INTO nou_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Edo ungo wo simba ero Mamo da asisi ewamei bugiri ungoi gosisera. Edo Mamo da usasa ungo jiroro edo jani burisira edo ungo oju isera ");
INSERT INTO nou_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Awarate asisi ewamei mi ungoda yei sisira, “Oju eove ainda be awa na ingo berari da binga ewamei budo bugena. Yei berari da embo mi binga eiawa ingido dubo ewamei adera.” ");
INSERT INTO nou_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Boroko David da nati da evetu mi ingoda soregari embo betira Keriso gitijigari nembodiba. ");
INSERT INTO nou_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ingo mei kiambu uso ai mi bo mi ruvedo itiri wo mane da undari yei da atira awa gadewa. Gido ingo na ingoda yei ro setena awa ge be adewa. ");
INSERT INTO nou_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Edo umo awodo siri asisi ewagaewa nenei jiwae mi bugudo uso demo da derido ungae atise ungoi Mamo jasiga ise ya sisera, ");
INSERT INTO nou_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ingode Mamo utu da inbe inda atima ira awa jasiga ore. Edo embo busu da wasiri ewamei edo era awa Mamo iaviri ira awa dowo dubo jamo ari tambore.” ");
INSERT INTO nou_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Edo asisi ewagaewa ungo dodo utu da mambutero wo simba ari embomei ungosuka mina sara isera, “Ingode Bethlehem nati da mambudo ro Mamo mi ingodenaso yei setira awa etira awa ingode gore.” ");
INSERT INTO nou_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sedo ungoi burigi be mambudo Mary de Joseph de mei kiambu awa wo mane da ewari oro da atero gosisera. ");
INSERT INTO nou_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","19","Edo wo simba ari embomei mei kiambu awa gido ungo mambudo ro anela mi mei kiambu da jawo da sisira awa embo berari da yei sisera. Setero embo berari ge awa ingido kove be kove isera awarate Mary uso jo da edo gogo edo ro isira awa kotise atina tina. ");
INSERT INTO nou_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Edo wo sheep simba ari embomei amboda ungo engenemburise ro gosisera edo ro ingisera awa Mamo awa ya mi jasiga isera ainda be awa ro anela mi ungoda yei sisera awa ungo ge be gosiseraawasedo. ");
INSERT INTO nou_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Edo pura da atae etiri ungo mei kiambu da tamo da andiso diugari iji bugiri ungo uso jawo Iesu sisera. Tuturo da mei awa ai da vetuto da atiri asisi ewamei mi jawo amone sisira. ");
INSERT INTO nou_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Evetu mei budo iji 40 awodo awa uso mando da atadira awa ta Jew embomei da wasiri ra. Edo Mary uso mando da iji 40 atinatina edo Joseph de Mary de ungoda mamoumbogo da wasiri memei Mamo da yei itari da wasiri da iji awa bugusira. ");
INSERT INTO nou_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Edo Moses mi Mamo da agodari da gaedo sisira, “Evetu uso mei bego badira mei awa Mamo da yei itadira.” Edo Moses daedo Mamo da agodari nei gaisira, “Evetu uso mando da atima atae edo ri memei ribo etoto awa buria da rorou awasedo itari rorou dungoro ewadira.” ");
INSERT INTO nou_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Awasedo Mary de Joseph de ungoda mei budo Jerusalem mambudo Mamo da yei itadi mambusera. Edo ungo daedo agodari mi ro sira awa ri memei etoto da rorou itadi mambusera. ");
INSERT INTO nou_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Edo embo ewamei jawo Simeon awa Mamo dubo budo isira edo Jerusalem atima isira. Edo umo kotedo isira Soregari Embo awa bugutira edo umo Mamo mi uso embo Israel soregadira awa simba edo isira. ");
INSERT INTO nou_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Edo Asisi Kotopu Simeon ga da atima isira amimi sisira umo mana betadira te atima Mamo umo soregari embo itadi sari gari sisira awa gido betarase sisira. ");
INSERT INTO nou_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Edo Asisi Kotopu mi umo gitijigido budo mambiri Simeon Jew embomei da tumondebain ari oro da totorisira. Edo aimamo mei Iesu budo Jew embomei da tumondebain ari oro da bugusera agodari mi ro sira awa ungo uso yei adi sedo. ");
INSERT INTO nou_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Edo ungo awa adi bugero Simeon mei kiambu uso ingo da budo Mamo da yei ategari itido sisira, “Gitijigari na boroko betadi sia etena ainda be awa imo ro adi sarigari sisesa awa etesa. ");
INSERT INTO nou_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na soregari embo imo embo berari da yei itesa awa getena. ");
INSERT INTO nou_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","Umo teta usasa nembodiba mi aumo embomei da yei jani barago etira edo ungoi gari nembogamo badera. Edo umo bugadira amimi Israel embomei da yei jasiga ari budo puradira.” ");
INSERT INTO nou_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Setiri mei kiambu ainda ai de mamo de mana mana isera ro Simeon mi mei da jawo da sisira awa gido. ");
INSERT INTO nou_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Edo Simeon ungo ewamei ari itido Iesu da ai Mary da yei sisira, “Mamo mi mei eiawa itiri bugira. Edo Israel embo nenei mi umo ujo ae adera awa iji biae tambadera te Israel embo nenei umo badera awa Mamo mi ungo soregadira. Iesu awa teta Mamo mi iwata itarago etira. ");
INSERT INTO nou_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Embo nenei mi uso yei biae sadera amimi isaga adira awa ungo ungoda jo da ro kotera awa sadera. Edo ungo eiedo adera ainde dubo vevera teta gi vegari mi iso jo da gaiarago adira.” ");
INSERT INTO nou_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Edo iji ainde binga sari evetu Anna ainda atima isira. Edo uso mamo Phanuel awa Asher da orobe ra. Anna awa matu be awa iu jimbari rate gaeko 7 atae etiri uso iu awa bebetisira. Betetiri umo rori awodo atise gaeko 84 atae isira. Edo umo evetu ogo isira te umo Jew embomei da tumondebain ari oro awa nanjigo doae iji de ta tumba de awa neta ise edo tumondebain edo isira edo Mamo kera edo isira. ");
INSERT INTO nou_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Awasedo Simeon Mary da yei ge siri Anna bugudo Mamo jasiga isira. Edo jasiga ise embo berari Mamo mi Israel embo soregarase simba edo isera ainda yei mei ainda jawo da ge sisira. ");
INSERT INTO nou_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Edo ungo Mamo da agodari da ro sisira awa edo atae edo ungo engenembedo ungoda nati be Nazareth Galilee busu ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Edo ungo engenembedo mambero mei kiambu awa babojiri uso tamo goroba isira. Edo umo jiro gari mei edo Mamo uso yei iji berari umo ewamei edo isira. ");
INSERT INTO nou_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gaeko jaige Iesu da aimamo ga jarusegari bondo da Jerusalem nati da mambudo isera. ");
INSERT INTO nou_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Edo Iesu awa gaeko 12 etiri iji ainde ungo sekago bondo da mambusira. ");
INSERT INTO nou_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Edo jarusegari bondo da iji awa atae etiri Iesu da aimamo ungoda nati da engenembadi sedo mambusera te mei singa Iesu awa Jerusalem ainda atisira. ");
INSERT INTO nou_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Edo uso aimamo umo bugari ge sedo ungo kotisera awa umo awa embo emboro da arusegedo mambutera ainda teda mambari ge sisera. Edo pepeta edo mambudo ongobo etiri ungo ungoda otatao de orobe de da yei umo eura adi tuturo isera awarate tambae isera. ");
INSERT INTO nou_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Edo eudo sipo de ungo sekago eura edo ungo umo tambae isera awasedo engenembedo Jerusalem mambudo ainda umo eura isera. ");
INSERT INTO nou_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Edo sipo nei Iesu Jew embomei da atopapotegari de anumbedo Jew embomei da tumondebain ari oro da atisira edo ungo ainda umo tambusera. Edo umo ainda anumbedo atise Iesu de atopapotegari de ge mina sara edo sedo gari mina ita ero gosisera. ");
INSERT INTO nou_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Edo Iesu atopapotegari da sedo mina seuri embo ingise atima edo isera awa kove be kove edo isera ainda be awa umo gari nembodiba de mi mina sira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Edo Iesu uso aimamo ga umo tambudo kove be edo uso ai mi uso yei sisira, “Naso mei ro edo nangoda yei eiedo etesi? Edo iso mamo de namo de imo awa tambadi eura edo iso yei kotembu kotembu etera.” ");
INSERT INTO nou_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Setiri Iesu mi mina sisira, “Ro edo ingo na eura etevi? Ingo na naso Mama da mando da atena ingo gaeta?” ");
INSERT INTO nou_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Setiri ungo uso ge awa mina sae isera. ");
INSERT INTO nou_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Awasedo Iesu uso aimamo ga de da Nazareth engenemburisira. Edo umo ainda daedo atise umo iji berari uso aimamo ga kera edo isira. Edo Iesu da ai awa iji berari uso jo da ro isira awa kotise atima edo isira. ");
INSERT INTO nou_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Edo Iesu bajiri edo uso tamo goroba isira edo uso jiro gari awa nembogo isira. Edo umo awodo babojiri Mamo de embo de umo dubo budo isera. ");
INSERT INTO nou_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rome embobo da gitijigari nembodiba be Tiberius awa embo berari awa gitijijigurise gaeko 15 atae isira. Edo Pontius Pilate mi Judea busu embobo awa gitijigido isira. Edo umo gitijijiguriri Herod Galilee embomei awa gitijiguri edo Herod da namendi Philip awa Iturea de Trachonitis busu de awa gitijigido iri edo Lysanias awa Abilene busu da embomei awa gitijigido isira. ");
INSERT INTO nou_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Edo Annas de Caiaphas de awa Jew embomei da priest gitijijigegari atima isera. Edo iji ainde John Zechariah da mei awa yei embo atae ainda atiri Mamo John uso yei ge sisira. ");
INSERT INTO nou_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Setiri John yei umo Jordan beda awa berari esega ise embo da yei sisira, “Ingoda wasiri bebegae awa dodo Mamo da yei wareregewo. Edo ingo jo wareregadewa awa nanemi ingo umo mi ewamei adena. Edo na ingo umo mi ewamei adena awa embo mi ingo Mamo da yei wareregetewa awa gadera.” ");
INSERT INTO nou_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Edo John awodo isira awa ro Mamo da binga sari embo Isaiah mi matu be matu gaisira awa be isira. Edo Isaiah mi John da jawo da gaisira, “Embo da mi yei embo atae ainda atise minonu sadira, ‘Gitijigari da emboro sia ewo. Edo eiedo ewo. Momono berari awa genjewo. ");
INSERT INTO nou_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Edo yei vitido wosedo awa ewo vivisegare. Edo emboro ongego jigego awa ewo dambu are edo emboro uroko uroko awa ajegewo edo awo pepeta ari emboro ewamei are. ");
INSERT INTO nou_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Edo awodo awo embo berari busu da mi rawodo Mamo mi ungo soregadira awa gadera.’” ");
INSERT INTO nou_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Edo embo jiwae mi John da yei bugudo John mi umo mi ewamei arase dipapa edo isera te John mi ungoda yei sisira, “Ingo awa teta jingabu mi embo gamburi betedo era da awodo. Mamo da kasari iji awa aikambu etira. Edo ro awasedo ingo nanemi ingo umo mi ewamei ano Mamo mi ingo kasae doarase kotevi? ");
INSERT INTO nou_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ingo wasiri ewamei adewa awa embo mi ingo ingoda wasiri bebegae awa dodo Mamo da yei wareregurewa awa gadera. Edo ingo ingosuka seove Abraham awa ingodenaso umbogo awasedo roedo ingodena Mamo da yei wareregeri seove. Mamo umo dipapa adira awa ari ganuma eiawa ari wareregedo Abraham da orobe adira. ");
INSERT INTO nou_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Edo ingo Jew embobo awa teta ri be ae edo ira da awodo ra. Edo embo oto kokoro de awa ri ainda besisi awa diwari durorase oto kokoro sia etira. Edo ri berari be ewamei ae edo era awa embo mi jegoro duroro budo riawo da itoro ewadera.” ");
INSERT INTO nou_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Edo John awodo setiri embo berari da teda embo da amimi uso yei nganega isera, “Imo ro sesa ainda be mo nango mo ro eri?” ");
INSERT INTO nou_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Setero John mi sisira, “Embo ave ombari etoto de ri awa ombari nei awa embo ombari ae de ainda itare. Edo embo ave uso buro da indari jiwae atadira awa indari nenei awa budo embo indari ae beji tambutira ainda itare.” ");
INSERT INTO nou_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Edo tax bari embo nenei mi John da yei bugudo John mi umo mi ewamei arase dipapa edo sedo gosisera, “Atopatari nango ro eri?” ");
INSERT INTO nou_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sedo getero John mi mina sisira, “Tax ganu gitijijigegari mi embo mi itorase sera ganu da awa buwo awarate ganu nenei awa beove.” ");
INSERT INTO nou_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Edo isoro embomei nenei mi John da yei nganega isera, “Edo nango daedo einda atera mo nango mo ro eri?” Setero John mi mina sisira, “Embo amemi uso rora topo awa nenei iso yei itari ujo ae ari gido inemi uso rora awa gatedo beose. Edo ge busari ge mi embo nei bekuba eove. Dubo ewamei ewo gitijijigegari mi ingoda ganu mina ititera ainde edo nenei jiwae badi awasedo sedo geove.” ");
INSERT INTO nou_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Edo embo awa sorega embo bugarase simba edo isera awasedo ungo John mi ro sisira awa kotise atima edo isera. Edo ungo awodo kotise ungo ungosuka sedo isera John awa Keriso embo Mamo mi ingodena kondade arase itari bugarase sisera awa ta rora. ");
INSERT INTO nou_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Awasedo John mi ungo berari da yei sisira, “Na ingo umo mi ewamei ena awa kiambu rate embo nembodiba awa bugutira. Edo na awa ewa raro uso buro eni? Edo embo nembodiba awa bugadira awa unemi Asisi Kotopu de edo riawo de mi ingo ewamei adira. ");
INSERT INTO nou_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Edo embo awa teta embo uso rora ewoga ewoga ari rora mi indari ve awa ewoga ewoga ise puti awa ewoga itido ira da awodo. Edo umo indari ewoga ewoga adira awa indari awa indari atari yei da itadira te puti awa pigari riawo matawa ewuse awodo atima ira ainda ewadira.” ");
INSERT INTO nou_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Edo ge nenei awodo jiwae mi embo atopapotise dengoro edo isira. ");
INSERT INTO nou_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Edo Rome embobo da gitijigari nembodiba Herod awa uso namendi da aro Herodias awa budo daga atima edo isira edo daedo wasiri bebegae nenei de da edo isira awasedo John uso yei da tini gambari ge sisira. ");
INSERT INTO nou_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Edo John setiri Herod John itiri bundari oro da mambusira. Edo Herod John bundari oro da itiri mambusira ainda buria de buria nenei berari bebegae edo isira ainde awa biae be biae ra. ");
INSERT INTO nou_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Edo John embo jiwae umo mi ewamei edo daedo Iesu ewamei isira. Edo Iesu Mamo da yei ge siri utu pirigetiri Asisi Kotopu teta ribo inge mi wowosisira. ");
INSERT INTO nou_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wosedo Iesu da yei anumburisira. Edo anumbetiri utu da ge javi Iesu da yei sisira, “Imo awa naso dubo bari mei. Na iso yei iaviri ena.” ");
INSERT INTO nou_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Edo Iesu awa uso gaeko 30 edo atopatadi tuturo isira. Edo embo mi sisera Iesu awa Joseph da mei sisera. Joseph da mamo awa Heli. ");
INSERT INTO nou_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli da mamo awa Matthat. Matthat da mamo awa Levi. Levi da mamo awa Melchi. Melchi da mamo awa Jannai. Jannai da mamo awa Joseph. ");
INSERT INTO nou_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph da mamo awa Matthias. Matthias da mamo awa Amos. Amos da mamo awa Nahum. Nahum da mamo awa Esli. Esli da mamo awa Naggai. ");
INSERT INTO nou_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai da mamo awa Maath. Maath da mamo awa Mattathias. Mattathias da mamo awa Semein. Semein da mamo awa Josech. Josech da mamo da mamo awa Joda. ");
INSERT INTO nou_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda da mamo awa Joanan. Joanan da mamo awa Rhesa. Rhesa da mamo awa Zerubbabel. Zerubbbabel da mamo awa Shealtiel. Shealtiel da mamo awa Neri. ");
INSERT INTO nou_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri da mamo awa Melchi. Melchi da mamo awa Addi. Addi da mamo awa Cosam. Cosam da mamo awa Elmadam. ");
INSERT INTO nou_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Elmadam da mamo awa Er. Er da mamo awa Joshua. Joshua da mamo awa Eliezer. Eliezer da mamo awa Jorim. Jorim da mamo awa Matthat. Matthat da mamo awa Levi. ");
INSERT INTO nou_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi da mamo awa Simeon. Simeon da mamo awa Judah. Judah da mamo awa Joseph. Joseph da mamo awa Jonam. Jonam da mamo awa Eliakim. ");
INSERT INTO nou_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim da mamo awa Melea. Melea da mamo awa Menna. Menna da mamo awa Mattatha. Mattatha da mamo awa Nathan. Nathan da mamo awa David. ");
INSERT INTO nou_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David da mamo awa Jesse. Jesse da mamo awa Obed. Obed da mamo awa Boaz. Boaz da mamo awa Salmon. Salmon da mamo awa Nahshon da mamo awa Amminadab. ");
INSERT INTO nou_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amminadab da mamo awa Admin. Admin da mamo awa Arni. Arni da mamo awa Hezron. Hezron da mamo awa Perez. Perez da mamo awa Judah. ");
INSERT INTO nou_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah da mamo awa Jacob. Jacob da mamo awa Isaac. Isaac da mamo awa Abraham. Abraham da mamo awa Terah. Terah da mamo awa Nahor. ");
INSERT INTO nou_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor da mamo awa Serug. Serug da mamo awa Reu. Reu da mamo awa Peleg. Peleg da mamo awa Eber. Eber da mamo awa Shelah. ");
INSERT INTO nou_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah da mamo awa Cainan. Cainan da mamo awa Arphazad. Arphazad da mamo awa Shem. Shem da da mamo awa Noah. Noah da mamo awa Lemech. ");
INSERT INTO nou_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech da mamo awa Methuselah. Methuselah da mamo awa Enoch. Enoch da mamo awa Jared. Jared da mamo awa Mahalaleel. Mahalaleel da mamo awa Cainan. ");
INSERT INTO nou_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan da mamo awa Enos. Enos da mamo awa Seth. Seth da mamo awa Adam. Adam da Mamo awa God ra. ");
INSERT INTO nou_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Asisi Kotopu mi dedegetiri sekago engenembedo Jordan umo beda bugusira. Edo amimi etiri Iesu goroba etiri Iesu budo yei embo atae da mambusira. ");
INSERT INTO nou_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Edo Iesu ainda mambudo atise nei ro indae atiri Satan mi umo bagisira. Amboda iji 40 atae etiri Iesu beji tambusira. ");
INSERT INTO nou_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Edo Iesu yei ro atae ainda atiri Satan mi uso yei bugudo sisira, “Imo Mamo da mei gadesa awa seio ganuma eiawa ambe ari indase.” ");
INSERT INTO nou_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Setiri Iesu mi mina sisira, “Jiwari mi sira ambe umo umosuka mana ari embo wasiri de atadira awasedo na mana ganuma da yei ge sadena.” ");
INSERT INTO nou_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Setiri Satan Iesu budo yei inda vivitisira edo busu da gitijijigegari berari de edo embo berari de ungoda busu de awa Satan mi Iesu ujiji etiri gosisira. ");
INSERT INTO nou_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Edo Satan mi Iesu da yei sisira, “Ro berari gosesa awa nanemi iso yei itadena. Embo nei mi naso yei berari eiawa ititisira awasedo embo amenda yei berari eiawa itadi dipapa adena awa uso yei itadena. ");
INSERT INTO nou_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Imo naso joda baingo dederi edo na tumondebain adesa awa rora berari gosesa eiawa nanemi iso yei itadena.” ");
INSERT INTO nou_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Setiri Iesu mi mina sisira, “Jiwari mi sira iso Mamo gitijigari awa kera ise tumondebain eio awarate embo nenei aera awasedo na mana imo tumondebain adena.” ");
INSERT INTO nou_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","10","Setiri edo Satan mi Iesu budo daga Jew embomei da tumondebain ari oro Jerusalem nati ainda inbe inda vivitisera. Vitido atise Satan mi Iesu da yei sisira, “Imo Mamo da mei gadesa awa yei eiawa dodo kekepuinya edo busu da woseio ainda be awa jiwari mi sira awa Mamo mi sari uso asisi ewamei mi bugudo imo kondade adera.” ");
INSERT INTO nou_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Edo jiwari mi daedo sira, “Mamo da uso asisi ewamei mi ungoda ingo mi jigoro imo durae adesa awasedo iso tei awa mana ganuma da dadira.” ");
INSERT INTO nou_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Setiri Iesu mi mina sisira, “Jiwari mi sira iso Mamo gitijigari awa bagose awasedo na mana kekepuinya adena.” ");
INSERT INTO nou_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setiri Satan Iesu bagedo atae edo iji tupo umo dotorisira. ");
INSERT INTO nou_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Edo Iesu Asisi Kotopu mi beda iri engenembedo Galilee da bugusira. Edo embo yei berari da awa Iesu da jawo da ge sero embo berari yei ainda awa binga awa ingisera. ");
INSERT INTO nou_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Edo Iesu Jew embobo da dada ari oro berari da torido embo atopatido isira. Edo embo berari Iesu da ge ingido umo jasiga isira. ");
INSERT INTO nou_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Edo Iesu umo atise babojisira busu ainda engenemburisira Nazareth nati da Galilee busu da. Edo umo ainda mambudo Jew embomei tumondebain ari iji de Jew embomei da dada ari oro da totorisira ko umo tumondebain ari iji berari awa ainda torido ira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Edo Iesu ajigadi eriri embo da amimi jiwari binga sari embo Isaiah mi jiwusira awa ajigarase ititisira. Itiri Iesu jiwari awa besugedo jiwari da ge da awa eura edo tambudo ajigurisira, ");
INSERT INTO nou_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Asisi Kotopu naso yei da buro iri na goroba ena. Umo na etiri goroba eteno Mamo mi na rora ae embobo da yei itiri bugusena. Itiri bugudo nanemi bundari embobo berari awa embo amemi ungo soregadira awa sano gadera. Edo nanemi embo ave dubo vevera nembodiba tambutera awa embo amemi ari ungo dubo ewamei adera awa sano gadera. Edo nanemi diti guba egeregari awa embo amemi ungoda diti ari ewamei adira awa sano gadera. Edo nanemi embo ave embo nenei mi biae edo eri awa embo amemi ungo kondade adiri awa sano gadera. ");
INSERT INTO nou_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Edo daedo gaeko nonde Mamo uso embomei soregadiri awawa nanemi minonu sadena.” ");
INSERT INTO nou_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Edo Iesu awa ajigedo jiwari ruvedo sekago kondade ari embo da itido anumburisira. Anumbetiri embo berari umo gonga etero, ");
INSERT INTO nou_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iesu mi sisira, “Jiwari nanemi ingoda yei ajigetena awa boroko be etira.” ");
INSERT INTO nou_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Setiri ungo berari umo sapo isera awarate ungo kove isera ainda be awa umo ge ewagaewa setira awasedo. Edo ungo awodo kove edo sisera, “Umone Joseph da mei ra edo umo rawodo edo ge ewagaewa eiawa setiri?” ");
INSERT INTO nou_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Setero umo ungoda yei sisira, “Na gosena ingo naso yei inia ge eiawa sadewa, ‘Karu gawo ari embo imo imosuka gawo eio.’ Edo ingo daedo naso yei sadewa, ‘Ungoi imo ro Capernaum da etesa awa setero getera. Eiawa iso nati topo ra wasiri awodo awa eio.’ ");
INSERT INTO nou_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Awawa ingo mi naso yei sadewa te na ingoda yei gebe sena, Mamo da binga sari embo uso nati topo esega edo isira awa ungo umo ujo ae edo isera. ");
INSERT INTO nou_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Edo naso ge ingiwo. ");
INSERT INTO nou_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Iji ainde Elijah atima isira ainde rorigarori jiwae Israel da atima isera. Edo gaeko tamonde edo soropuda awa ga busu berari da wosae etiri baimana nembodiba bugusira te Mamo Elijah itiri Israel da rorigarori berari awa derigedo mambudo umo rori da Sidon busu da nati Zarephath da ainda atima isira ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Edo daedo iji ainde Elisha atima isira ainde embo jiwae karu leprosy budo Israel busu da atima isera te Mamo umo Israel embobo awawa ae ewagaewa ae rate umo Naaman Syria da atima isira awa etiri ewamei isira.” ");
INSERT INTO nou_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Setiri embo berari Jew embomei da dada ari oro da atisera awa uso ge awa ingido ungo tini gambari be isira. ");
INSERT INTO nou_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tini gambari edo erido Iesu sandido budo jigido jumbudo doriri da nati digisera ainda vivitisera. ");
INSERT INTO nou_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Vitido ungoi Iesu pigoro bengi da wosarase isera te umo embo da teda pepeta edo ungo dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesu Nazareth nati dodo Capernaum nati nei da Galilee busu da mambudo Jew embomei da tumondebain ari iji de embo atopapotisira. ");
INSERT INTO nou_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Edo umo embo atopapotiri embo awa kove be isera ainda be awa Iesu goroba de atopapotira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Edo embo da asisi biae mi jingama edo isira awa ainda Jew embomei da dada ari oro da torido atisira. ");
INSERT INTO nou_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Edo atiko gogo nembodiba dimbudo sisira, “Aio Iesu Nazareth nati embo imo nangoda yei ro ari dipapa esi? Imo nango usibesi esi ta? Na imo embo averi awa gosena. Imo awa soregari embo awa God mi itari mambarase sisira.” ");
INSERT INTO nou_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Setiri Iesu asisi biae da yei ge okain sisira, “Ge dodo wosedo embo awa dodo mambu.” Setiri asisi biae embo awa embo da jo da pigetiri duriri umo usibesi ae ijegurisira. Etero umo mambusira. ");
INSERT INTO nou_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Edo asisi biae awa mambiri embo berari kove be edo ge mina sara isera, “Uso ge eiawa nei ra. Embo eiawa embo ewoga ra. Umo ge siri asisi bebegae embo dodo mambutera.” ");
INSERT INTO nou_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Edo embo nati ainda berari awa Iesu da wasiri ro isira awa sedo isera. ");
INSERT INTO nou_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu Jew embomei da dada ari oro awa dodo umo Simon da mando da mambusira. Simon da uso umboti awa yauya nembodiba budo besi da pasido atiri ungoi Iesu da yei ari ewamei arase benunu sisera. ");
INSERT INTO nou_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Awasedo Iesu evetu ainda demo da derido desegedo setiri karu awa dodo mambusira. Mambiri evetu awa erido indari indorase sia isira. ");
INSERT INTO nou_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Edo ongobo etiri embo berari ungoda otatao ave karu neinde kainde ari awa baredo Iesu da yei bugusera. Bugero Iesu uso ingo ungo dada ainda tamo da itido ungo berari ewamei isira. ");
INSERT INTO nou_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Edo daedo asisi bebegae embo jiwae da yei edo ijegurise asisi bebegae gogo dimbudo isera, “Imo awa Mamo da mei.” Embomei awawa ungo gosera Iesu awa Keriso awasedo Iesu embo da yei uso jawo da ge seorase ge gajedo isira. ");
INSERT INTO nou_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sipo atedo waiko vivitiri Iesu nati dodo yei embo atae da mambusira. Mambiri embo umo eura eriko tambudo ungo dourase sisera. ");
INSERT INTO nou_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Awarate Iesu mi sisira, “Na mana ingode atadena ainda be awa Mamo na itiri bugusena awa embo nenei nati nenei da awa binga ewamei Mamo umo ungoda yei ro adi dipapa ira awa sano gadera awasedo.” ");
INSERT INTO nou_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sedo Iesu Jew embobo ungoda yei berari da tembuse Jew embomei da dada ari oro berari da embo atopatido isira. ");
INSERT INTO nou_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iji da Iesu umo diuga jawo Gennesaret ainda bengi da derido atiri embo jiwae be bugudo mina misa ise bugudo Mamo da ge ingadi Iesu jineneburisera. ");
INSERT INTO nou_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Edo Iesu nga etoto wo buro embomei mi kora da jigero atiri gosisira. Jigero vitiri wo buro embomei awa ungoda komboro segise atisera. ");
INSERT INTO nou_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Edo Iesu Simon da nga da vitido setiri Simon mi sinegetiri kiambu umo be da wowosisira. Edo Iesu nga da anumbedo atise embo umo diuga da bengi da atisera awa atopapotisira. ");
INSERT INTO nou_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Edo Iesu ge sedo atae edo Simon da yei sisira, “Davedo umo be da wosedo imo iso wo buro embomei de komboro ingoda itawo ounda wosadera awa ingo wo jiwae be beradewa.” ");
INSERT INTO nou_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Setiri Simon mi sisira, “Gitijigari tumba de nango buro okain be etera te wo nei ro baera. Awarate imo nango da yei sesa awa nanemi komboro itano wosadira.” ");
INSERT INTO nou_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sedo ungo komboro itero wowosisera. Etiri wo jiwae be berero komboro diugadi aikambu isira awasedo ungo mi wo buro embo nenei daedo isera awa jawo sisera bugudo ungo kondade orase. ");
INSERT INTO nou_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Setero bugudo nga etoto awa wo mi sirero edo nga etoto awa kununubadi aikambu isira. ");
INSERT INTO nou_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Edo Simon Peter wasiri awa gido Iesu da jo da baingo dederi edo sisira, “Gitijigari na dodo mambu ko na awa embo ewa aera.” ");
INSERT INTO nou_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Edo umo uso embo nenei de awa kove be isera ko ungo wo jiwae be burisera awasedo. ");
INSERT INTO nou_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Edo Zebedee da memei James de John de daedo wo buro edo isera awa daedo kove be isera. Edo Iesu mi Simon da yei sisira, “Oju eose. Tuturo einda edo teta wo beresa da eiedo embo beradesa.” ");
INSERT INTO nou_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Setiri ungo nga jigero ombo da vitero ungoda rora berari awa dodo ungoi Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iji da Iesu embo da karu leprosy bari nati ainda atima isira awa gosisira. Edo embo awa Iesu gido uso joda busu da durido Iesu da yei benunu sisira, “Embo nembodiba iso dipapa mi naso tamo aso ewamei adira.” ");
INSERT INTO nou_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Setiri Iesu uso ingo sinegedo embo ainda tamo awa jigido uso yei sisira, “Na imo ewamei ari dipapa ena. Iso tamo awa ewamei are.” Setiri iji ainde karu leprosy embo ainda tamo da awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Edo Iesu mi embo ainda yei sisira, “Embo nenei da yei ro iso yei etena awa saso geore ta dambuderari mambudo priest da itio iso tamo awa edo gogo edo gare. Edo Moses mi rorou itorase sisira awa itio. Aso edo embo berari mi gadera awa iso tamo awa ewamei etira awa.” ");
INSERT INTO nou_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Awarate embo amimi Iesu ro isira awa setiri binga awa yei berari da rawusira. ");
INSERT INTO nou_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Etiri embo jiwae uso ge gadi bugudo Iesu mi ungoda karu neinde kainde jiwae awa ari ewamei adi dipapa isera te Iesu yei embo atae ainda Mamo ga da ge sadi mambusira. ");
INSERT INTO nou_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iji da Moses da agodari simba edo isera ungoda jawo Pharisee sedo era ainde Moses da agodari atopatido era embo awa Jerusalem nati de edo Galilee busu de edo Judea busu de da awa bugusera. Edo Iesu atopapotiri ungo anumbedo uso ge ingise atisera. Edo Iesu Mamo da goroba de awa ainda karu embomei ari ewamei orase sia edo atisira. ");
INSERT INTO nou_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Edo embo nenei mi embo awa apara da edo budo bugusera. Edo ungo embo awa Iesu da jo da itari dipapa edo gido embo awa budo mando joda toradi isera. ");
INSERT INTO nou_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Awarate ungo embo awa ango edo budo joda torari awa sago ae isira ko embo jiwae be mi dada edo emboro awa beitigurisera awasedo. Edo beitigetero gido ungo embo awa ango edo budo riri da mando sa beraga da vitido sisoro to edo embo awa uso ewari besi da awa itero Iesu da jo da embo da teda wowosisira. ");
INSERT INTO nou_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Edo Iesu ungo jo mi berari gebe era awa gido uso yei sisira, “Naso otao iso wasiri biae kotembedo dotena.” ");
INSERT INTO nou_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Awa setiri Pharisee embomei de agodari da atopapotegari de mi ungosuka mina sara isera edo sisera, “Embo eiawa Mamo da yei ge biae sira. Edo umo embo ave awodo kotiri? Edo embo nei mi mana embo nei da wasiri biae awa kotembedo doari sago aera. Mamo umo umosuka awa embo da buria kotembedo doadira.” ");
INSERT INTO nou_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sero Iesu ungoda kotari awa gido ungoda yei sisira, “Ingo roedo kotari awodo kotevi? ");
INSERT INTO nou_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na ge ro seni? Na ro seni ta iso wasiri biae kotembedo dotena seni ta ko erido iso ewari besi bojedo budo pepeta e seni? Edo ge etoto einda ge isaga mo rawa seni? ");
INSERT INTO nou_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Awara nanemi wasiri da ano ingo gadewa ko na awa Mamo da mei bugudo busu da embo isena edo goroba de embo da wasiri biae kotembedo doturise atena.” Edo Iesu awodo sedo embo tei ingo ambari da yei sisira, “Erido iso ewari besi bojedo mando iso da mambuio.” ");
INSERT INTO nou_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Setiri embo berari ditini ero embo awa erido uso ewari besi bojedo Mamo jasiga ise pepeta edo uso mando da mambusira. ");
INSERT INTO nou_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Edo embo kove be kove isera amimi Mamo jasiga isera. Awarate oju be oju edo sisera, “Wasiri boroko etiri getera wasiri awa nango matu da awodo awa gaera.” ");
INSERT INTO nou_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ponda bugudo Iesu tax bari embo jawo Levi awa uso tax bari oro da anumbedo atiri gosisira. Gido Iesu mi uso yei sisira, “Na ambo ambo eio.” ");
INSERT INTO nou_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Setiri Levi erido uso rora berari dodo Iesu ga da mambusira. ");
INSERT INTO nou_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Edo amboda Levi Iesu awasedo bondo nembodiba uso mando da sia isira. Edo tax bari embobo jiwae be de edo embo nenei jiwae de bondo da indari awa indadi bugusera. ");
INSERT INTO nou_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Edo Pharisee nenei de edo agodari da atopapotegari de mi Iesu da ambojimbi da yei bekuba edo sisera, “Roedo ingo tax bari embobo de embo bebegae nenei deda einda anumbedo indido kumbudo evi?” ");
INSERT INTO nou_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Setero Iesu mi mina sisira, “Karu embobo gawo ari embo awa embo karu ae ainda yei mambae rate umo embo karu de ainda yei mambadira. ");
INSERT INTO nou_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Da awodo na embo ewagaewa awasedo nanemi ano ungoda wasiri bebegae awa dodo Mamo da yei wareregorase na bugae ra te na embo bebegae awasedo nanemi ano ungoda wasiri bebegae awa dodo Mamo da yei wareregorase na bugusena.” ");
INSERT INTO nou_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Embo nenei mi Iesu da yei sisera, “John da ambojimbi de Pharisee da ambojimbi de awa iji berari neta ise Mamo da yei ge sedo era te iso ambojimbi awa indido kumbudo edo era.” ");
INSERT INTO nou_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Setero Iesu mi mina sisira, “Jimbari susu awa jimbari bondo da atirari imo kotesa inemi aso jimbari bondo da esega bugera awa neta ae eterita? Awodo aera imo mana awodo adesa. ");
INSERT INTO nou_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Awarate amboda gitopo bugudo jimbari susu awa sandido kundo mambadera iji ainde awa ungo neta adera.” ");
INSERT INTO nou_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Edo Iesu ungoda yei daedo sisira, “Na ingoda yei inia ge da sano gido ingo naso atopatari awa seka awa gadewa. Embo bo matu da to awa bo seka diugedo budo mana bo matu tamonda piradira. Umo awodo adira awa bo matu awa ari biae edo gari ewamei adi aera. ");
INSERT INTO nou_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Edo embo amemi mana ribe da ngamo wine seka awa utingi wo andiso matu mi ari ainda nukadira ainda be awa utingi wo andiso matu mi ari awa mana bimbijadi edo umo wine awa porokukusedo sawadira ainde utingi wo andiso matu mi ari awa bejadira. Awodo adira awa utingi wo andiso matu mi ari de ribe da ngamo wine seka de awa biae adira. ");
INSERT INTO nou_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Awodo aera embo awodo aera te umo wine seka awa utingi wo andiso seka mi ari ainda itido ira. ");
INSERT INTO nou_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Embo ave ribe ngamo wine matu awa tuturo da indadira awa umo mana ribe ngamo wine seka awa indadira. Edo wine matu awa ewamei sadira.” ");
INSERT INTO nou_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iesu uso ambojimbi de Jew embomei da tumondebain ari iji de buro emboro da beji mi biae edo pepeta ero uso ambojimbi mi ungoda agodari awa bejedo ungo pisa awa budo kandedo indisera. ");
INSERT INTO nou_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Edo Pharisee embobo nenei mi sisera, “Ingo ro edo awodo evi? Nangoda agodari mi sira awa tumondebain ari iji de buro eove.” ");
INSERT INTO nou_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Setero Iesu mi mina sisira, “Ingo gitijigari nembodiba David de uso embomei de ungo iji ainde beji mi ambudo ro isera ainda kiki ingo ajigedo gaeta? Mamo da agodari mi sira awa ambe ingari Mamo da yei rorou ititera awa priest mi indadi rate embo nenei mi mana indadera. ");
INSERT INTO nou_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Awarate David Mamo da oro da torido ambe ingari rorou Mamo da yei ititisera awa budo umo indise nenei uso otatao da itiri ungo deda indisera.” ");
INSERT INTO nou_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sedo Iesu uso mina sari atae ise sisira, “Na Mamo da mei bugudo embo isena awa tumondebain ari iji isena ainda wasiri awa simba ena.” ");
INSERT INTO nou_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Edo Jew embomei da tumondebain ari iji nei Iesu Jew embobo da dada ari oro da embo atopapotisira. Jew embobo da dada ari oro da awa embo da uso ingo be ambari awa anumbedo atisira. ");
INSERT INTO nou_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Edo Pharisee embo nenei de agodari da atopapotegari de awa iji ewamei budo Iesu bekuba adi sedo eura edo isera awasedo ungo Iesu simba edo gogo ise kotisera, “Umo tumondebain ari iji de embo ari ewamei adera amone umone buria adira.” ");
INSERT INTO nou_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Awarate Iesu ungo ro kotera awa gido embo ingo ambari da yei sisira, “Erido naso yei da po.” Setiri embo awa erido bugudo Iesu da jo da dederisira. ");
INSERT INTO nou_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Edo umo ainda derido atiri Iesu embo da yei sisira, “Na ingoda yei nganega adena. Ingodenaso agodari mi tumondebain ari iji de embo nenei kondade orase sita mo ko embo nenei da yei biae orase siri? Ingodenaso agodari mi embo nenei soregorase sita mo ko embo nei doro betarase siri?” ");
INSERT INTO nou_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sedo umo diti pigedo embo berari awa gido embo ainda yei sisira, “Iso ingo besugedo dagaiya eio.” Setiri embo awa uso ingo sekago besuguriri ingo ewamei isira. ");
INSERT INTO nou_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Edo embo awawa tini gambari edo ungosuka Iesu da yei ro adera awa ge mina sara isera. ");
INSERT INTO nou_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Iesu umo umosuka Mamo gada ge sadi sedo doriri da vivitisira. Vitido ainda tumba de atise Mamo gada ge sisira. ");
INSERT INTO nou_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Edo sipo de Iesu mi setiri uso ambojimbi berari uso yei bugusera. Ungo bugero Iesu mi embo 12 kataburisira. Katabedo Iesu mi embo 12 ainda jawo Itari Mambari Embobo ititisira. ");
INSERT INTO nou_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Edo eiawa ungoda jawo ra. Simon uso jawo Iesu mi Peter ititisira edo uso namendi Andrew. ");
INSERT INTO nou_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","16","James de John de Philip de Bartholomew de Matthew de Thomas de James Alphaeus da mei de Simon Rome gitijijigegari embo awa durido dodo wosorase isira ainde edo Judas James da mei de Judas Iscariot umo amboda Iesu indiga sisira ainde. ");
INSERT INTO nou_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu uso ambojimbi de doriri dodo wosedo yei ewamei da dederisera. Edo embo jiwae be Judea busu de Jerusalem nati de edo Tyre busu de Sidon nati ewa beda awa Iesu da yei bugusera. ");
INSERT INTO nou_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bugudo Iesu mi ungoda karu amburo neinde kainde jiwae awa ari ewamei orase edo ungo uso ge dengoro orase bugusera. Edo embo asisi bebegae mi joda atima isera amimi Iesu da yei bugoro ari berari ewamei orase bugusera. ");
INSERT INTO nou_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Edo embo berari awa Iesu jigadi jarima isera ainda be awa umo gorobe de buro ise iri berari jebugurera awasedo. ");
INSERT INTO nou_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu uso ambojimbi gosise sisira, “Imo rora ae embo gido iaviri eio ainda be awa rora Mamo da topo berari awa iso topo awasedo. ");
INSERT INTO nou_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Edo imo boroko beji tambutesa awa dubo ewamei eio ainda be awa Mamo mi imo undadira awasedo. Edo imo boroko ji sesa awa iaviri eio ainda be awa iro jiradesa awasedo. ");
INSERT INTO nou_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","“Embo mi na God da mei embo isena awasedo ingo ujo ae ise ge biae ingoda yei sise ingo wasiri biae etewa sadera awa dubo ewamei ewo ko Mamo mi ingoda riroga nembodiba utu da sia ira awasedo. Embo ingo dedo gaedo era ainda mamoumbogo awa Mamo da binga sari embo da yei awodo isera. ");
INSERT INTO nou_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Imo rora jiwae embo boroko esa re awa biae ra ainda be awa ingo matu ingoda riroga betewa awasedo. ");
INSERT INTO nou_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Imo boroko indari jiwae buresa re amboda awa iso yei re biae adira ko imo baimana tambadesa awasedo. Imo boroko iro jiresa re amboda iso yei re biae ra ko dubo vevera tambudo ji sadesa awasedo. ");
INSERT INTO nou_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Boroko embo berari imo jasiga era te amboda iso yei re biae ra. Edo ruvegeove embo ingo dedo gaedo era ainda mamoumbogo re da awodo ge busari da binga sari embobo jasiga edo isera. ");
INSERT INTO nou_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Awarate ingo naso ge ingewa ainda yei sena, Gitopo iso dubo buio. Edo embo iso yei tini gambari era ainda yei ewamei eio. ");
INSERT INTO nou_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Embo iso jawo da ge biae sera ainda yei ewamei eio. Embo iso yei wasiri biae era, embomei awasedo Mamo da yei gegata eio. ");
INSERT INTO nou_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Edo embo amemi imo sogo be nei da doro gido sogo be nei itio dore. Edo embo amemi iso ombari boro gido seio ombari nei de daedo bore. ");
INSERT INTO nou_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Embo amemi rora ro itasase sari re itio. Embo amemi rora iso topo awa bari sekago iso yei itarase seose. ");
INSERT INTO nou_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Edo imo embo nenei mi iso yei orase dipapa esa da awodo embo nenei da yei eio. ");
INSERT INTO nou_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Imo embo imo dubo burera awa dubo burise embo nenei dubo bae esa mo ro edo Mamo mi iso yei riroga ewamei itarase kotesi? Edo embo ari bebegae edo era amone daedo da awodo edo era. ");
INSERT INTO nou_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Imo embo iso yei ewamei era ainda yei ewamei esa mo rawodo edo riroga badi kotesi? Edo embo bebegae awa emboro ainda pepeta edo era. ");
INSERT INTO nou_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Imo embo nenei da yei rora itido sekago badi dipapa esa mo ro edo imo rirogo badesa awa kotesi? Embo bebegae rora embo bebegae da yei itido sekago badi dipapa edo era. ");
INSERT INTO nou_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Awodo aera awodo eose. Gitopo iso dubo burise ewamei eio. Embo nenei da yei rora itio awarate sekago itoro badi sedo nganega eose. Imo awodo embo nenei da yei adesa awa imo teta Mamo da embomei mi arago adesa. Mamo mi iso riroga nembodiba sia etiri atira. Mamo embo bebegae uso yei ategae edo era ainda yei umo jo edo ira. ");
INSERT INTO nou_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Da awodo imo jo ari embo nenei da yei eio. ");
INSERT INTO nou_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Imo embo nenei kasae adesa awa Mamo imo mana kasadira. Imo embo nenei bekuba eose ainda be re Mamo mi imo bekuba adi ta rora awasedo. Imo embo nenei mi iso yei biae oro kotembedo doadesa awa Mamo mi iso wasiri bebegae awa kotembedo doadira. ");
INSERT INTO nou_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Imo embo nenei da yei kando itadesa awa Mamo mi iso kando itadira. Mamo mi iso yei kiambu awa mana itadira te teta embo mi indari bondo da kando berugedo era da awodo itadira. Mamo mi iso yei kando jiwae be jiwae itadira awasedo imo kando berari awa budo tembari sago ae adesa. Kando tega rawodo itadesa tega da awodo awa Mamo mi iso yei kando awodo awa itadira.” ");
INSERT INTO nou_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Edo Iesu mi inia kiki eiawa sisira, “Embo ditiguba ari mi mana embo ditiguba ari nei awa gitijigadira ko ungo etoto awa koto da duradera. ");
INSERT INTO nou_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Gari eura ira embo ainda jiro gari awa kiambu awarate uso atopatari da jiro gari awa nembodiba ra. Jiro gari eura ira embo awa buro okain adira awa amboda awa uso jiro gari awa teta uso atopatari da da awodo. ");
INSERT INTO nou_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ro edo ri momono iso namendi da diti da awa gosise dodo ri dewo iso diti da awa imo kotae esi? ");
INSERT INTO nou_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ro edo iso namendi da yei sesi iso diti da ri momono awa bane sesi ko imo iso diti da ri dewo atira awa imo gae esi? Imo ise sarago ari embo imo giti iso diti da ri dewo awa budo gido awa namendi da diti da ri momono awa badesa.” ");
INSERT INTO nou_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Edo Iesu ungo atopapotise sisira, “Ri ewamei mi mana be biae adira edo ri biae mi mana be ewamei adira. ");
INSERT INTO nou_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Edo imo ri da be awa gido awa ri amomo ro ri awa gadesa. Ri bebe de mi mana sisira be adira edo ri nenei bebe de mi mana sigore be adira. ");
INSERT INTO nou_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Embo ewamei da kotari jo da awa ewamei kotise ari ewamei ira te embo biae da kotari jo da awa biae ari bebegae ira. Embo umo rori awa gadewa uso ge sadira ainda. ");
INSERT INTO nou_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ingo na gitijigari sedo ewa te ingo na ro sena awa ae edo ewa. Ro edo awodo edo evi? ");
INSERT INTO nou_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Embo da mi naso ge ingadi bugudo ge ingido ge awa kera edo ira awa nanemi embo awa rawodo ri awa ingoda yei ujugano gadewa. ");
INSERT INTO nou_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Embo awa teta embo mando eiedo ititisira awa inge. Tutuvi uro tu be tuda ngambedo tutuvi derido ganuma wawara etiri wosedo amimi etiri tutuvi awa goroba edo dederisira. Ainda amboda umo bojedo mando awa dorisira te mando awa wasiri ae ko ainda be awa embo awa uso mando awa itido gogo isira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Edo embo naso ge ingido awodo ae edo ira awa ujugano gadewa. Embo awa uso mando tutuvi awa derido gogo ae rate busu tamo da uso mando awa ititisira. Edo umo bojetiri mando awa burigi be dudurisira edo biae be isira.” ");
INSERT INTO nou_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Edo Iesu embomei awa atopatido atae edo Capernaum nati da mambusira. ");
INSERT INTO nou_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Edo ainda Rome isoro embomei 100 da gitijigari awa ainda atima isira. Edo gitijigari einda agipo embo awa buro ewamei edo isira awasedo gitijigari embo awa dipapa be edo isira awarate agipo embo awa karu edo betadi aikambu isira. ");
INSERT INTO nou_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Edo isoro embobo da gitijigari Iesu mi ro ira awa ingido unemi uso agipo embo awa ari ewamei arase dipapa isira awasedo Jew embo nembogamo nenei itiri Iesu da yei sedo gadi mambusera. ");
INSERT INTO nou_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Edo ungo Iesu da yei mambudo sedo gosisera, “Embo awa embo nenei awodo ae umo awa embo ewamei awasedo nango imo sedo gosera embo awa kondade esita? ");
INSERT INTO nou_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Umo ingodenaso embo dubo budo ira edo umo ganu itiri ingodenaso dada ari oro ititisera.” ");
INSERT INTO nou_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Setero Iesu ungode daedo mambusira. Edo Iesu mando aikambu bugiri gitijigari da otatao unemi itiri bugusera amimi Iesu tambusera. Tambudo gitijigari da binga Iesu da sorase sisira awa sisera, “Gitijigari naso mando da toradi eose ko na awa ewa aera. ");
INSERT INTO nou_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Edo daedo na ewa raro iso yei peni awasedo imo ainda atise tepo ge mi seio naso agipo embo ewamei are. ");
INSERT INTO nou_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na gosena awa be adira ko na awa daedo isoro embo nenei da gitijigari da agodari da tuda ra edo daedo isoro embobo nenei awa naso agodari da tuda ra. Na isoro embo da da sadena mambu awa umo mambadira. Edo na isoro embo nei da sadena po awa umo puradira. Edo naso agipo embo da yei eiawa e sadena awa umo adira.” ");
INSERT INTO nou_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Edo Iesu binga awa ingido kove be edo wareregedo embo berari umo ambo ambo isera ainda yei sisira, “Dowo sano gave. Na Israel embomei da teda embo gebe ari embo eiedo awa da tambae be ra.” ");
INSERT INTO nou_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Setiri binga sisera embobo awa sekago engenembedo isoro embobo da gitijigari da mando da mambudo uso agipo embo awa ewamei edo atiri tambusera. ");
INSERT INTO nou_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iji tupo Iesu uso ambojimbi de embo jiwae be de nati Nain ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Edo ungo nati da totorero embo nati da edo bugusera embo mei singa betari awa ango edo betari kokombo da budo mambadi. Edo mei singa betari ainda ai awa kinapeina nenei bae edo uso iu awa daedo betari. Edo embo jiwae be jiwae awa evetu ainga da pepeta isera. ");
INSERT INTO nou_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Edo Iesu evetu awa gido jo be jo isira evetu ainda yei sisira, “Ji do.” ");
INSERT INTO nou_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sedo Iesu aikambu mambudo apara awa jigiri embo apara ango isera awa pepetisera. Petetero Iesu mi sisira, “Mei singa iso yei sena eri.” ");
INSERT INTO nou_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Setiri mei singa betari awa erido ge sadi tuturo isira. Edo Iesu mi budo mambudo uso ai da ititisira. ");
INSERT INTO nou_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Edo embo berari oju edo Mamo jasiga ise sisera, “Binga sari embo nembodiba awa ingodenaso teda bugira. Mamo uso embo soregadi bugira.” ");
INSERT INTO nou_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Edo binga ravetiri embo Judea da edo busu demo da damo da awa ro Iesu mi ira awa ingisera. ");
INSERT INTO nou_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John uso ambojimbi mi Iesu ro ira awa setero gido gido John Iesu da yei binga ititisira. ");
INSERT INTO nou_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Edo John setiri ambojimbi etoto uso yei bugero ungoda yei sisira, “Mambudo Iesu da yei nganega ari eiawa sewo, ‘Imo mo embo John mi bugarase sevira awa ta mo ko nango embo nei diti eri?’” ");
INSERT INTO nou_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Setiri ungo Iesu da yei mambudo sisera, “John umo mi ewamei ari embo iso yei nganega orase setiri bugera. Imo mo embo John unemi bugarase sevira awa ta mo ko nango embo nei diti eri?” ");
INSERT INTO nou_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Edo iji ainde Iesu awa embo karu amburo neinde kainde berari awa iri jebugurisera. Edo umo asisi bebegae jo da atima isera awa onduri bugudo isera edo diti guba egeregari euri ewamei edo isera. ");
INSERT INTO nou_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Edo Iesu John da ambojimbi etoto da ge mina sisira, “Engenembedo John da yei mambudo ingo boroko ro getewa edo ingewa awa sewo gare. Diti guba egeregari yei gosera edo tei ingo ambujegari embobo pepeta era edo embo karu leprosy barari ewamei era edo dengoro junjari ge ingera edo bebetegari awa wasiri de sekago ererera edo rora ae embobo awa binga ewamei ingera. ");
INSERT INTO nou_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Embo ave na ro ena gido naso yei da gebe adira awa umo atari ewamei tambadira.” ");
INSERT INTO nou_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Edo John da ambojimbi mambutero Iesu embo jiwae atisera ainda yei John da jawo da ge sisira, “Ingo yei embo atae da John da yei mambusewa iji ainde ingo ave gadi kotise mambusevi? Embo teta sasawa bisara mi deuri mambudo bugudo ise atarago ira awa gadi mambusevi ta? Embo teta sasawa bisara mi deuri pasido atima ira da awodo awa gadi mambusevi ta? ");
INSERT INTO nou_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Embo ombari digari ewagaewa ari gadi mambusevi ta? Awodo aera ingo embo awodo awa gadi mambaera. Embo ombari digari ewagaewa edo rora jiwae topo edo era embomei awa gitijigari da mando da atima edo era. ");
INSERT INTO nou_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ingo ave gadi mambusevi? Ingo Mamo da binga sari embo gadi mambusevi ta? Gebe ingo binga sari embo gadi mambusewa. Dowo sano gave binga sari embo nenei awa nembogamo rate John awa binga sari embo nembodiba be nembodiba ra. ");
INSERT INTO nou_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Edo ungoi ge embo einda da ge gaisera, ‘Gi nanemi embo itano naso binga budo bugadira. Umo giti mambuse iso emboro ari ewamei adira.’ ");
INSERT INTO nou_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Awasedo na sano gave John da buro mi busu berari da embo da buro awa derigurira awarate embo nembo ae God mi gitijigarase sedo gosira amimi John awa derigurira.” ");
INSERT INTO nou_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Edo embo berari de tax bari embomei de John da dengoro bagari awa gido ungoi sisera, “Gebe Mamo da emboro awa gebe ra.” Awasedo ungoi setero John mi ungo umo mi ewamei isira. ");
INSERT INTO nou_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Awarate agodari simba ari embomemei jawo Pharisee de agodari da atopapotegari de awa Mamo da emboro awa ujo ae edo John da umo mi ewamei ari awa ujo ae isera. ");
INSERT INTO nou_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Edo Iesu mi sisira, “Embo boroko atera embo awa gari rawodo ri? Rawodo seni? ");
INSERT INTO nou_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ungo awa teta kinapeina nati da usini ise mina sara edo era, ‘Nango jimbari awa usini etera te ingo nangode da usini ae awasedo nango betari da usini etera te ingo nangode da usini ae.’ ");
INSERT INTO nou_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ge ro sena amone eire. Edo John bugusira ainde umo neta edo umo wine awa indae etiri gido ingo sisewa asisi biae uso jo da atira sisewa. ");
INSERT INTO nou_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Edo na Mamo da mei bugudo embo isena indido kumbudo eteno ingo sewa embo eiawa giu. Umone indari jiwae indari edo umo wine indari embo. Umo awa tax bari embobo de embo bebegae de da otao ra sewa. ");
INSERT INTO nou_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Awarate embo mi ingo ro ewa awa gido ingo God da emboro ambo ambo evi ta mo ko emboro nei adevi awa gadera.” ");
INSERT INTO nou_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee embo da mi Iesu ga da indari indadi sega isira. Edo Iesu embo ainda mando da mambudo indari indadi anumburisera. ");
INSERT INTO nou_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Edo evetu da wasiri biae edo isira awa nati ainda atima isira awa Iesu mando ainda indari indise atira awa binga ingisira. Ingido kopiri kiambu ganuma mi ari awa siwo muno ewamei de mi nukari awa budo bugusira. ");
INSERT INTO nou_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bugudo Iesu da tei da baingo dederi ise ji siri uso jijiu mi wosedo Iesu da tei awa sasapi isira. Edo evetu uso kopiri tu mi Iesu da tei awa gaimburisira. Edo evetu amimi Iesu da tei muno edo siwo muno de awa uso tei da jojisira. ");
INSERT INTO nou_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Edo Pharisee embo Iesu uso mando da bugarase sega isira awa evetu mi ro isira awa gido umo kotisira, “Embo eiawa binga sari embo be gido re evetu umo tamesi ira evetu amone evetu biae awa geure.” ");
INSERT INTO nou_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Edo Iesu embo ainda kotari awa gido uso yei sisira, “Simon na iso yei ge sadi ena.” Setiri Simon mi mina sisira, “Awara atopatari naso yei ge segae.” ");
INSERT INTO nou_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Setiri Iesu mi uso yei sisira, “Embo da ganu osisa ari embo mi embo etoto da yei ganu ititisira. Embo amimi K500 awa embo nei da itido K50 awa embo nei da ititisira. ");
INSERT INTO nou_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Edo embo etoto awa uso ganu awa ganu ititisira embo ainda yei mina itari sago ae awasedo embo amimi embo etoto ainda yei sisira awara na ganu mina itawase dipapa mana adena sisira. Edo embo etoto ainda teda mo rawa mi embo awa dubo be beiri?” ");
INSERT INTO nou_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Setiri Simon mi mina sisira, “Na kotena embo ganu nembodiba burisira amimi dubo be badira.” Setiri Iesu mi sisira, “Ge mina ewamei be setesa.” ");
INSERT INTO nou_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Edo Iesu evetu ainda yei wareregurise Simon da yei sisira, “Evetu eiawa ro etira awa koteio. Na iso mando da torena awa imo ingodenaso wasiri awa edo umo itae naso tei segae awarate evetu emimi uso jijiu mi naso tei segetira. Segedo naso tei awa uso beo tu mi gaimbetira. ");
INSERT INTO nou_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Edo na iso mando da torena edo imo ingodenaso wasiri awa ise na seia baia ae awarate evetu eiawa na mando da totoreno tuturo edo naso tei awa doae muno ise atira. ");
INSERT INTO nou_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Imo naso beo da u itae awarate evetu eiawa naso tei da siwo muno de awa itira. ");
INSERT INTO nou_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sano gio. Nanemi uso buria jiwae awa kotembedo dotena awasedo umo na dubo be burira. Awarate embo ave buria kiambu kotembedo doadena embo awa na kiambu dubo badira.” ");
INSERT INTO nou_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Awodo sedo Iesu mi evetu da yei sisira, “Nanemi iso buria kotembedo dotena.” ");
INSERT INTO nou_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Setiri embo nenei Iesu ga daedo indari indisera amimi ungosuka mina sara isera, “Embo eiawa averi umo embo da buria kotembedo doturiri?” ");
INSERT INTO nou_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sero Iesu mi evetu da yei sisira, “Nanemi imo soregetena ko imo na ge be etesa awasedo mambuio dubo ewamei de atase.” ");
INSERT INTO nou_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Amboda Iesu uso ambojimbi 12 de pepeta ise nati nembogamo de memeia de awa esega isira. Edo esega ise Iesu Mamo iji nonde gitijigadira ainda binga ewamei awa atopapotisira. ");
INSERT INTO nou_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Edo Iesu matu asisi bebegae embo evetu nenei da jo da awa ondise edo embo evetu ainda karu awa etiri jebugurisera emboevetu awa daedo Iesu ga mambusera. Edo emboevetu ainda teda awa Mary Magdalene ra. Iesu mi matu asisi bebegae 7 uso jo da atima isera awa ondisira. ");
INSERT INTO nou_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Edo evetu nei awa Joanna Chuza da aro. Chuza awa Herod Galilee busu da gitijigari embo da mando da agipo embomei de simba edo ira. Evetu nei awa Susanna. Edo emboevetu nenei jiwae de ungoda ganu de roviravi de mi Iesu de uso ambojimbi de kondade edo isera amimi daedo pepeta isera. ");
INSERT INTO nou_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Embo nati berari da mi Iesu da yei enjegedo purae edo isera. Edo embo jiwae be diti diti bugudo dada etero Iesu ungoda yei inia kiki eiawa sisira, ");
INSERT INTO nou_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Embo da uso buro da ve gowadi mambusira. Edo umo pepeta ise ve awa uso demo ponda awodo wawara isira. Ve nenei awa emboro da dudurisira. Etiri embo mi patetero edo rimemei mi indisera. ");
INSERT INTO nou_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ve nenei awa busu ganuma de ainda dudurisira. Durido edo ve awa burigi eririsera te ungo ambusera ko busu ainda umo atae awasedo. ");
INSERT INTO nou_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ve nenei awa bebe teda wowosisera. Edo bebe de edo indari ve de eririsera. Edo bebe mi erido indari ve awa apuregurisera ve awa ambusera. ");
INSERT INTO nou_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ve nenei awa busu ewamei da wowosisera ainda ve ewamei be eririsera. Edo ve eiawa be ewagaewa jiwae isera.” Edo Iesu kiki awa atae edo sisira, “Embo ave ingadi edo gido re ingare.” ");
INSERT INTO nou_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iesu uso ambojimbi mi uso yei inia kiki sisira ainda be awa nganega isera. ");
INSERT INTO nou_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Etero Iesu mi sisira, “Mamo mi ingoda yei gae unjugari da iji nonde umo gitijigadira awa isaga etira te embo nenei da yei awa nanemi inia ge mi iji nonde Mamo mi gitijigadiri awa atopapotena. Edo na ungo inia ge mi atopapoteno ungo gosera te ungo gaera edo ungo ingera te ungo ingaera. ");
INSERT INTO nou_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Eiawa inia kiki ainda be ra. Ve awa teta Mamo da ge inge ra. ");
INSERT INTO nou_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Edo ve emboro da dudurisira awa teta embo Mamo da ge ingido ira te Satan mi bugudo ge awa embo ainda jo da bengono edo ira. Edo Satan mi ge awa awodo bengono edo euri embo awa Mamo da ge gebe ae edo ira awasedo Mamo mana umo soregadira. ");
INSERT INTO nou_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Edo ve busu ganuma de ainda wowosisira awa teta embo Mamo da ge ingido ira tutura da awa jo iaviri ise uso jo da ge awa kotedo ira te burigi be ruvegedo ira. Edo bawari buguri uso Mamo tumonda ari awa atae edo ira. ");
INSERT INTO nou_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Edo ve bebe soropu da dudurisera awa teta embo Mamo da ge ingido ira te iji berari umo rawodo rora jiwae be bae etiri edo dubo ewamei ae etiri awa kotedo ira. Awodo kotise euri Mamo da ge uso jo da awa ambudo ira awasedo umo Mamo goroba de gebe ari embo ae edo ira. ");
INSERT INTO nou_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Edo ve busu ewamei da wowosisira awa teta embo Mamo da ge ingido kotedo gogo ise Mamo da ge awa embo nenei da yei sedo ira. Awodo ise umo embo jiwae be kondade euri Mamo gebe edo era.” ");
INSERT INTO nou_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesu mi sisira, “Ingodena goriwo injibedo ou to da itae edo era edo ingodena goriwo injibedo ewari besi tu da itae edo era. Awodo aera te ingodena goriwo injibedo awa mando da itoro embo ingodena tumba de esega era awa yei isaga gadera. ");
INSERT INTO nou_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Embo amemi ro apuregadira awa amboda embo nei mi tambudo awa isaga adira. Embo amemi ro unjugadira awa amboda embo nei mi tambudo isaga da itadira. Da awodo God da ge awa ujugano isaga adira. ");
INSERT INTO nou_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Dengoro edo ingido gogo ewo ko embo amemi Mamo da ge budo ira embo ainda yei Mamo mi ge nei itadira awarate embo ave Mamo da ge bae edo ira awa Mamo mi ge matu ititisira awa dodo badira.” ");
INSERT INTO nou_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu da ai de nanonamendi de uso yei bugusera te ungo uso yei aikambu purari awa jarisera ainda be awa embo jiwae be dada isera awasedo. ");
INSERT INTO nou_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Edo embo da mi Iesu da yei sisira, “Iso inyei de nanonamendi de imo gadi bugudo ponda derido atera.” ");
INSERT INTO nou_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Setiri Iesu mi embo ainda atisera ainda sisira, “Embo de evetu de Mamo da ge ingise kera era awa ungo awa daedo naso aia de nanonamendi de ra.” ");
INSERT INTO nou_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iji da Iesu da uso ambojimbi de nga da vitido ungoda yei sisira, “Ingode umo diuga da be nei da sembudo mambore.” Setiri ungo tuturo edo mambusera. ");
INSERT INTO nou_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Edo ungo mambutero Iesu pasido ewo isira. Edo bisara nembodiba be doriri da edo wosedo umo diuga da edo umo awa nga joda vitadi tuturo isira. Edo vitiri nga awa kununubadi aikambu isira. ");
INSERT INTO nou_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Awasedo ambojimbi Iesu da yei mambudo umo ewo wujedo uso yei sisera, “Gitijigari gitijigari nango betadi aikambu etera.” Setero Iesu erido bisara de umo de teta ewa yawata ise arago isira ainda ge sisira. Ge setiri bisara atae etiri edo umo awa ewa binono inge isira. ");
INSERT INTO nou_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Edo Iesu awodo edo uso ambojimbi da yei sisira, “Roedo ingo na gebe ae etevi?” Setiri ambojimbi kove be edo oju edo ungosuka mina sara isera, “Embo eiawa averi? Umo ge setiri bisara de umo de, umo ro setira awa etera.” ");
INSERT INTO nou_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu uso ambojimbi de nga de umo diuga da sembudo Gergesene busu embo da yei bugusera. Galilee busu awa umo be nei da edo Gadarene embo da busu awa umo be nei da ra. ");
INSERT INTO nou_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Edo Iesu nga dodo vitido umo bengi da iri nati embo da asisi biae mi bundari mi Iesu tambusira. Embo eiawa nati da atae ra te iji ribori be embo eiawa sini bo ewae edo betari embo da kokombo da atima edo isira. Edo iji jiwae be embo mi ngobu nembogamo mi ingo de tei de bundedo isera te asisi biae da goroba mi euri iji berari ngobu awa divedo isira. Iji berari awodo edo isira edo asisi biae mi umo budo yei ro atae da mambudo isera. ");
INSERT INTO nou_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Edo embo eiawa Iesu gido gogo batitibedo dimbuse Iesu da joda baingo dederi edo gogo dimbudo sisira, “Iesu Mamo utu in da atima ira ainda mei imo ro edo naso yei da bugesi? Na iso yei sedo gosena naso yei riroga itose.” ");
INSERT INTO nou_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Umo awodo sisira ainda be awa Iesu asisi biae da yei embo awa dodo bugarase sira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Edo Iesu mi uso yei nganega isira, “Iso jawo rori?” Edo asisi bebegae jiwae mi embo ainda joda totorisera awasedo umo Iesu da yei mina sisira, “Naso jawo awa jiwae ra.” ");
INSERT INTO nou_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Setiri edo asisi bebegae mi Iesu da yei gegeta isera, “Nango itaso riawo matawa euse atima ira ainda yei doaso wosore.” ");
INSERT INTO nou_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Edo pu diti da awa doriri demo da gasigungusa ise atisera awasedo asisi bebegae mi Iesu da yei gegata isera, “Imo sesa awara te dogae nango pu da joda torore.” ");
INSERT INTO nou_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Setero Iesu awara setiri asisi bebegae embo ainda jo awa dodo bugudo pu da joda totorisera. Edo ungo torero pu berari burigi be sumbudo wosedo wii da awodo kekepuinya edo umo da wosedo berari indido ambusera. ");
INSERT INTO nou_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Edo pu simba ari embo ro isira awa gido ungo sumbudo embo buro da isera edo embo nati da atisera ainda yei kiki awa setero ingisera. ");
INSERT INTO nou_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Edo ungo kiki awa setero embo ro isera awa gadi bugusera. Edo ungo Iesu da yei bugudo embo asisi bebegae dodo bugera embo awa gido umo sini bo ewudo Iesu ga da anumbedo kotari ewamei sekago kotise atiri gosisera. Gido embo oju isera. ");
INSERT INTO nou_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Edo embo wasiri awa iri gosisera amimi Iesu rawodo edo embo awa etiri ewamei isira ainda kiki awa sisera. ");
INSERT INTO nou_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Edo Gergesene busu embo berari mi Iesu ungoda busu awa dodo mambarase sisera ko ungo oju mi bebegae isera awasedo. Edo ungo awodo setero Iesu nga da vitido mambusira. ");
INSERT INTO nou_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Edo embo asisi bebegae dodo bugusira embo amimi Iesu da yei sedo gosisira, “Na ingae mambari dipapa ena.” Setiri Iesu mi mina sisira, ");
INSERT INTO nou_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Iso nati da mambudo embo da yei Mamo mi iso yei ro etira awa seio gore.” Setiri embo awa uso nati da mambudo embo berari da yei Iesu mi uso yei ro isira awa sisira. ");
INSERT INTO nou_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Edo Iesu sekago umo diuga be nei da sembiri embo jiwae be umo simba atisera amimi umo atega isera. ");
INSERT INTO nou_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Edo Jew embomei da dada ari oro simba ari embo jawo Jairus bugusira. Bugudo Iesu da jo da baingo dederi edo sedo gosisira uso mando da mambarase ko uso gagara da uso gaeko 12 awa betadi aikambu ira awasedo. Edo Iesu mambutiri embo jiwae be mi Iesu misisera. ");
INSERT INTO nou_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Edo evetu da awa gaeko 12 awodo karu orobi awa budo atima isira awa embo da teda umo umosuka pepeta isira. Edo evetu eiawa uso ganu berari awa karu gawo ari embobo da yei ititisira te ungo evetu eiawa ewamei ae. ");
INSERT INTO nou_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Edo evetu awa Iesu da gun da bugudo uso bo begiti awa jigiri uso orobi awa iji ainde atae isira. ");
INSERT INTO nou_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Edo Iesu mi nganega isira, “Na amemi jigiri?” Sedo getiri ungoi sisera, “Na aera na aera.” Setero Peter mi sisira, “Gitijigari embo jiwae be imo jiriroka edo imo misera.” ");
INSERT INTO nou_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Setiri Iesu mi sisira, “Na gosena embo da na jigira ainda be awa goroba na dodo mambira.” ");
INSERT INTO nou_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Setiri evetu awa gosisira Iesu getira awasedo dadara gasise bugudo Iesu da jo da baingo dederi isira. Edo baingo dederi edo atiri embo berari ditini ero evetu awa Iesu da yei ro edo umo jigiri edo rawodo edo iji ainde umo ewamei etira awa setiri edo ");
INSERT INTO nou_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iesu mi evetu ainda yei sisira, “Naso gagara imo na gebe nembodiba etesa awasedo imo ewamei etesa, Dubo ewamei de mambuio.” ");
INSERT INTO nou_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Edo Iesu awa siri binga sari embo mi Jairus da mando da edo bugusira. Bugudo Jairus da yei sisira, “Iso gagara awa matu betetira awasedo atopatari da yei bouga itose.” ");
INSERT INTO nou_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Setiri Iesu ingido Jairus da yei sisira, “Oju eose ta na gebe eio. Edo imo na gebe adesa awa iso gagara ewamei adira.” ");
INSERT INTO nou_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sedo umo mambudo Jairus da mando da bugusira. Bugudo sisira embo ungae tororase. Awarate Iesu mi setiri Peter de John de James de gagara ainda aimamo ga de daga totorisera. ");
INSERT INTO nou_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Edo embo berari ji sisera ko gagara awa betetira awasedo awarate Iesu mi sisira, “Ji seove gagara amone betae ra te ewo ira.” ");
INSERT INTO nou_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Setiri ungoi berari Iesu ganduburisera ko ungo gosisera gagara awa be betetira awa gosisera. ");
INSERT INTO nou_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Awarate Iesu gagara ainda ingo da jigido sisira, “Gagara eri.” ");
INSERT INTO nou_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Setiri gagara iji ainde oena tuturo edo apuse eririsira. Eriri Iesu mi ungoda yei sisira indari itoro indarase sisira. ");
INSERT INTO nou_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Edo gagara da aimamo ga kove ero Iesu mi ungoda yei sisira, “Embo nenei da yei ro etira awa sawo geore.” ");
INSERT INTO nou_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu mi setiri ambojimbi 12 uso yei bugusera. Edo ungo mi asisi bebegae awa ondise edo karu bebegae neinde kainde awa oro ewagaewa orase sedo Iesu goroba ari ungoda yei ititisira. ");
INSERT INTO nou_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Edo Iesu ungo itiri mambusera awa iji nonde Mamo mi gitijigadira awa atopapotise edo karu embobo oro ewamei orase. ");
INSERT INTO nou_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Edo Iesu mi ungoda yei sisira, “Ingo mambadi ise gido rora jiwae beove. Pepeta ari ketu beove edo kandia de indari de ganu de ombari nei de beove. ");
INSERT INTO nou_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Edo ingo nati da bugawo embo amemi ingo atega adera embo ainde da uso mando da atiwo. Edo ingo ainda atise mambudo mando neinda ewo eove. ");
INSERT INTO nou_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Edo ingo nati da bugawo edo embo mi ingo atega ae adera awa gun ingoda awa ungo kena edo ungoda nati awa dowo. Edo ingo awodo adewa awa ungo gadera ungo biae etera awa gadera.” ");
INSERT INTO nou_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Edo Iesu awodo setiri ambojimbi dodo mambusera edo nati berari esega ise binga ewamei atopapotise edo karu embobo eoro ewamei edo isera. ");
INSERT INTO nou_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Gitijigari Herod Iesu mi ro ira awa ingisira. Ingido umo mana mana isira ko embo nenei mi sera John umo mi ewamei ari embo awa wasiri de sekago erira awarate embo nenei mi sera Elijah mi bugira. Edo embo nenei mi sera awa binga sari embo matu boroko ae bebetisira awa sekago wasiri de erira sera. ");
INSERT INTO nou_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Edo Herod mi sisira, “Nanemi seteno John umo mi ewamei ari embo da dubo diugurisera. Awarate embo ro iri binga ingena embo emomo averi?” Edo umo awodo sedo iji nonde Iesu gadiri awa eura isira. ");
INSERT INTO nou_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Edo ambojimbi 12 engenembedo ungoi ro isera awa Iesu setero ingisira. Edo umo ungo budo daedo ungoi ungo ungosuka Bethsaida nati da mambusera. ");
INSERT INTO nou_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Edo embo ungo mambusera ainda binga awa ingido ungo ambo ambo isera. Edo ungo bugero Iesu ungo atega edo ungoda yei iji nonde Mamo mi gitijigadiri awa sise edo ungoda teda embo ave karu de ri awa etiri ewamei isera. ");
INSERT INTO nou_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Edo iji wowosiri ambojimbi 12 mi Iesu da yei bugudo sisera. “Yei eiawa embo atae yei ra awasedo embo itio mambudo buro demo da edo nati da awodo indari de edo ewari yei de eura ore.” ");
INSERT INTO nou_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Setero Iesu mi ungoda yei sisira, “Ingo ingosuka ungoda yei indari itiwo indore.” Setiri ungoi mina sisera, “Nangoda yei indari kiambu atira ambe ingari 5 edo wo etoto de atira. Edo imo nango mi embo jiwae be eiawa embo mambudo indari ori orase dipapa esi ta?” ");
INSERT INTO nou_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Edo ungoi awodo sisera ainda be awa embo ajigari 5,000 awodo ainda atisera awasedo. Edo Iesu mi uso ambojimbi da yei sisira, “Sewo embo diti da 50 diti da 50 awodo anumbore.” ");
INSERT INTO nou_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Setiri ambojimbi mi setero embo berari anumburisera. ");
INSERT INTO nou_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Edo ungo anumbetero Iesu ambe ingari 5 edo wo etoto awa budo diti utu da edo Mamo da yei ategari itido edo ambe ingari de wo de awa gavedo memeia isira. Edo gavedo memeia edo uso ambojimbi da yei ititise atisira. Edo Iesu umo ititise atiri ambojimbi da edo ambojimbi ungo embo da yei osisa ise atisera. ");
INSERT INTO nou_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Edo embo berari indido ungo inono be isera. Edo ambojimbi embo mi indari indido doturisera awa dada isera. Edo ungoi dada etero indari awa kandia 12 beda isira. ");
INSERT INTO nou_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Iji da Iesu umo umosuka Mamo da yei ge siri ambojimbi uso yei bugusera. Edo ungo bugero Iesu ungo nganega isira, “Embo na awa ave sedo eri?” ");
INSERT INTO nou_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Setiri ungoi mina sisera, “Embo nenei sedo era imo awa John umo mi ewamei ari embo edo embo nenei sedo era imo awa Elijah. Edo embo nenei sedo era imo awa binga sari embo nei matu boroko ae bebetisira awa sekago wasiri de sekago erira sedo era.” ");
INSERT INTO nou_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Edo ungo awodo setero Iesu ungoda yei nganega isira, “Awarate ingo mo namomo ave sedo evi?” Setiri Peter mi mina sisira, “Imo awa Mamo da soregari embo jawo Keriso ra.” ");
INSERT INTO nou_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Setiri Iesu mi ungoda yei sisira, “Eiawa embo nenei da yei seove. ");
INSERT INTO nou_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na Mamo da mei embo isena awa memesi nembodiba tambadena. Edo Jew embo nembogamo de priest gitijijigegari de edo agodari da atopapotegari de mi na ujo ae adera. Edo ungo mi soro embo mi na doro betadena te iji etoto atae ari Mamo mi ari na sekago wasiri de eradena.” ");
INSERT INTO nou_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sedo Iesu ge nei ambojimbi da yei sisira, “Embo ave na ambo ambo ari dipapa edo gido dowo umo uso dipapa berari awa dodo edo iji berari imo iso bouga ango adesa teta na naso orega ango adena da awodo naso demonda nangae pepeta are. ");
INSERT INTO nou_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Edo embo ave busu da uso wasiri soregadi adira embo awa uso wasiri busu da awa doadira. ");
INSERT INTO nou_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Awarate embo ave na awa embo betadira embo awa wasiri ewamei tambadira. Awarate embo ave busu berari da rora jiwae badira awa betadi ta ko iji biae tambadira awa rora berari amimi ari embo awa iavira eita? Awodo aera. ");
INSERT INTO nou_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Embo nenei naso atopatari de namonde awasedo me gosera. Amboda na Mamo da mei embo isena awa naso usasa janibadira ainde edo Mamo da usasa janibadira ainde mi jiroroka ari edo asisi ewagaewa de na sekago busu da engenembadena. Iji ainde na embomei naso yei me gosisira ainda yei na me gadena. ");
INSERT INTO nou_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Edo na ingoda yei gebe sena embo nenei boroko einda derido atera awa ungoi iji nonde Mamo mi gitijigadi iji awa gadera.” ");
INSERT INTO nou_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Edo Iesu ge awa sedo pura da amboda Iesu Peter de John de James de budo daedo doriri da Mamo gada ge sadi vivitisera. ");
INSERT INTO nou_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Edo Iesu umo Mamo gada ge siri Iesu da dombu gari nei isira edo uso ombari digari usasa nembodiba de janiburisira. ");
INSERT INTO nou_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Edo embo etoto Moses de Elijah de Mamo da usasa mi jiroroka etiri bugusera edo Iesu gada Iesu da uso betari Jerusalem nati da awa iji nonde ri awa Mamo mi sia isira da awodo awa aikambu etira awa ungo Iesu ga da sisera. ");
INSERT INTO nou_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Edo Peter uso otatao etoto de awa ewo bouga be isera awarate ungo erido Iesu awa gari nei isira awa gido edo embo etoto uso demo da derido atisera awa gosisera. ");
INSERT INTO nou_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Edo embo etoto awa Iesu dodo mambutero Peter mi Iesu da yei sisira, “Gitijigari ingodena einda atera awa ewamei. Edo ingode gaga tamonde pigadera da awa iso da awa Moses da edo da awa Elijah da.” Awarate Peter ge sisira awa biae ko umo ro sira awa umo gido gogo ae awasedo. ");
INSERT INTO nou_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Edo Peter ge siri poroga mi bugudo ungo apuregetiri ambojimbi oju isera. ");
INSERT INTO nou_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Edo ge javi poroga joda sisira, “Embo eiawa nanemi katabetena awa naso mei na awasedo uso ge ingiwo.” ");
INSERT INTO nou_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Awodo setiri Iesu umo umosuka awa ainda derido atisira. Edo ro ambojimbi mi gosisera iji ainde awa embo nenei da yei sae doturisera. ");
INSERT INTO nou_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sipo de ungo yei awa dodo doriri da wosetero embo jiwae be mi Iesu tambusera. ");
INSERT INTO nou_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Edo embo da teda amimi gogo dimbudo sisira, “Atopatari na iso yei sedo gosena naso mei gi, naso mei da ra. ");
INSERT INTO nou_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Edo asisi biae mi gae gae gogo dimbuse mei dorise atira. Edo dorise iri mei awa jiro biae embo awodo ise be da porokusedo ira. Edo mei doae mambudo bugudo ise asisi biae mi euri mei eiawa memesi nembodiba budo ira. ");
INSERT INTO nou_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Edo na iso ambojimbi da yei sedo getena asisi biae ondorase awarate ungo ari sago ae etera.” ");
INSERT INTO nou_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Setiri Iesu mi mina sisira, “Ingo embobo awa ewamei ae ewa edo ingo na gebe ae edo ewa. Na iji roinge ingode einda ateni? Na ingoda yei iji roinge eni?” Sedo Iesu mi embo ainda yei sisira, “Iso mei awa naso yei budo puio.” ");
INSERT INTO nou_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Setiri mei awa bugutiri asisi biae mi detiri mei awa busu da dudurisira. Edo umo duriri asisi biae mi etiri mei awa teta jiro biae embo da awodo isira. Awarate Iesu mi setiri asisi biae mei awa dodo bugusira. Edo Iesu mei awa ewamei edo uso mamo da yei ititisira. ");
INSERT INTO nou_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Edo awodo etiri embo berari awa kove be isera ainda be awa ungo Mamo da goroba nembodiba getera awasedo. Edo embomei kove be ise atisera ainda be awa Iesu mi wasiri goroba de ira awa gido edo Iesu mi uso ambojimbi da yei sisira, ");
INSERT INTO nou_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Na ingoda yei ro sadi ena awa ruvegeove. Na Mamo da mei bugudo embo isena awa ungo mi embo da ingo da itadera.” ");
INSERT INTO nou_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Edo Iesu uso ge unjugarase awodo setira awasedo uso ge awa ungo gadi jarisera ainda be awa uso ge da be awa unjugurisira te ungo Iesu da yei nganega ari awa oju isera. ");
INSERT INTO nou_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ambojimbi mi ungo ungosuka embo ungoda teda mo amemi mamo gitijigadira iji ainde awa embo nembodiba eiri awa ge bagise atisera. ");
INSERT INTO nou_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Edo Iesu ungo ro kotera awa gido setiri mei kiambu da bugudo uso demo da derido atisira. ");
INSERT INTO nou_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Edo mei kiambu awa ainda derido atiri Iesu uso ambojimbi da yei sisira, “Embo ave naso jawo da mei kiambu eiawa atega iri awa embo awa na atega ira. Edo embo ave na atega iri awa embo amemi na itiri bugusena awa atega ira. Embo ave ingoda teda embo kiambu ri embo awa God da dombu da embo nembodiba ra.” ");
INSERT INTO nou_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John mi Iesu da yei sisira, “Gitijigari nango embo da iso jawo da asisi bebegae ondiri ge doarase setera ko umo awa ingodenaso embo nei ae awasedo.” ");
INSERT INTO nou_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Setiri Iesu mi John da yei edo ambojimbi nenei da yei sisira, “Embo awa beitigeove ko embo ave ingoda gitopo ae embo amone ingoda otao ra.” ");
INSERT INTO nou_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Edo Mamo mi Iesu budo utu da vitadira iji awa aikambu etiri Iesu jamo jamo ae edo demo da yae Jerusalem nati da vitadira awodo isira. ");
INSERT INTO nou_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Edo embo nenei Iesu mi giti da itiri Samaria da nati da ainda Iesu awasedo rora berari sia adi mambusera. ");
INSERT INTO nou_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Awarate nati ainda embomei awa Iesu ujo ae isera ainda be awa ungo gosisera umo Jerusalem nati da mambutira edo ungo ainda tumonde bain ae edo isera awasedo. ");
INSERT INTO nou_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Edo ambojimbi etoto James de John de wasiri awa gido sisera, “Gitijigari ingode utu da riawo jawo soro wosedo ungo usibesi eita?” ");
INSERT INTO nou_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Setero Iesu wareregedo ungoda yei awa eorase sisira. ");
INSERT INTO nou_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Edo umo ungo awodo eorase sedo ungo budo ungoi nati nei da mambusera. ");
INSERT INTO nou_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Edo ungo emboro da mambutero embo da mi Iesu da yei sisira, “Imo yei nonda yadesa awa na imo ambo ambo adena.” ");
INSERT INTO nou_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Setiri Iesu mi uso yei sisira, “Ambe wo awa uso ewari yei atira edo ri memei awa ungoda ngaja atira te na Mamo da mei embo isena awa naso ewari yei atae ra.” ");
INSERT INTO nou_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Edo embo nei da Iesu mi sisira, “Na ambo ambo eio. Awarate embo amimi sisira, “Gitijigari na naso mama betari govedo ainda amboda awa na imo ambo ambo adena.” ");
INSERT INTO nou_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Setiri Iesu mi mina sisira, “Embo ave betari tumonda eri awa dowo ungo ungosuka kondade mina ara ore. Edo imo mambuio Mamo da gitijigari iji aikambu etira awa embo da yei saso gore.” ");
INSERT INTO nou_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Setiri embo nei mi Iesu da yei sisira, “Embo nembodiba na imo ambo ambo adena te giti awa na mambudo naso orobe awa atega adena.” ");
INSERT INTO nou_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Setiri Iesu mi uso yei sisira, “Embo ave nga dawuse gun gadi edo ira embo awa umo yei nonda yari dipapa ira yei ainda mambadi aera. Da awodo embo ave Mamo da buro ari dipapa ise dodo ambo gadi edo ira embo awa mana Mamo da buro awa edo gogo edo adira.” ");
INSERT INTO nou_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Amboda Iesu buro embobo seka 70 awodo kataburisira. Edo itiri giti nati berari umo mambadi dipapa ira ainda etoto etoto awodo mambusera. ");
INSERT INTO nou_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Edo Iesu mi ungoda yei sisira, “Indari jiwae buro da awa sari etira awarate buro embobo enumbae mi dada adi atera. Awasedo buro topo da sewo buro embobo itari mambudo indari sari awa dada ore. ");
INSERT INTO nou_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Buro da mambuwo. Nanemi ingo ititeno teta wo sheep da mei mi ambe sino da teda mambarago ewa. ");
INSERT INTO nou_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gano dada ari sapoia beove edo benunu embo da sapoia de tei goru de beove. Edo ingo emboro da mambuse anumbedo embo nenei de da kiki dirise atove. ");
INSERT INTO nou_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ingo nati embo da mando da totorise gido sewo, ‘Mamo da ewamei ari mando einda embo atima era ainda atare.’ ");
INSERT INTO nou_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Edo ingo awodo sawo embo ave Mamo da ewamei ari bari dipapa edo ira embo mando ainda atadira gido ewamei ari ge setesa awa be adira. Awarate embo mando ainda atera awa Mamo da ewamei ari bari dipapa ae adera awa ewamei ari ge inemi setesa awa be adi aera. ");
INSERT INTO nou_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Edo imo mando ainda atiroso embo mi ro indido kumbudo asase itadera da awa indido kumbudo eio ainda be awa buro embo buro ira ainda mina awa badira. Edo mando imo atesa awa dodo mando nei da mambose. ");
INSERT INTO nou_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Edo ingo nati da totorirowo embo mei awa jao namendi ari awodo ingoda yei oro gido indari ungoi ro indawase itadera awa indiwo. ");
INSERT INTO nou_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Edo daedo karu embobo nati ainda atima era awa ewo jebugoro ungoda yei save, ‘Mamo da gitijigari iji bugira.’ ");
INSERT INTO nou_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Awarate ingo nati ainda totorirowo embomei ainda awa jao namendi ingode daedo ae oro gido nati soropu da mambudo embobo ainda yei sewo, ");
INSERT INTO nou_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nango ingoda nati da konipo nangoda tei da awa dede era ko ingo mi gadewa ingo wasiri biae etewa awa. Edo ruvegeove Mamo da gitijigari iji bugira.’ ");
INSERT INTO nou_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Na ingoda yei sena Mamo mi busu berari da embobo awa kasadira iji ainde Sodom nati embobo da yei awa nembogo be jo adira awarate nati embobo amemi ingoda ge awa beuso adera awa unemi ungoda yei jo ari kiambu adira.” ");
INSERT INTO nou_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Iesu mi sisira, “Ingo Chorazin nati embobo God mi kasari ingo iji biae be tambadewa. Edo ingo Bethsaida nati embobo ingo daedo awa God mi kasadira. Edo Tyre nati embomei de Sidon nati embomei ainda atari awa kotewo. Ungo berari wasiri bebegae be edo isera awarate na ari wasiri goroba de ingoda nati da isena awa ungoda nati ainda aetena awa nati ainda embomei awa ungo ombari digari mamatu awa edo aviga mi tamo da gutedo ungo ungoda wasiri bebegae awa dodo Mamo da yei wareregaetera. ");
INSERT INTO nou_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na ari wasiri goroba de ingoda nati da isena awarate ingo ingoda wasiri biae awa dodo God da yei wareregae awasedo busu berari da embo awa kasadira iji ainde riroga ingo badewa amimi riroga ungo badera awa derigadira. ");
INSERT INTO nou_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Edo ingo Capernaum embobo ingo ro kotevi? Ingo mi utu da vitadevi ta? Awodo aera. Ingo naso ge ingae awasedo yei riawo mata awodo euse atira ainda ingo mambadewa.” ");
INSERT INTO nou_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu mi uso ambojimbi da yei sisira, “Embo ave ingoda ge ingido era awa naso ge ingido era awarate embo ave ingo ujo ae era awa na ujo ae era. Edo embo ave na ujo ae era awa embo amemi na itiri bugusena embo awa ujo ae era.” ");
INSERT INTO nou_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Edo embo 70 Iesu mi itiri mambusera awa asisi bebegae ungoda goroba tuda atisera awasedo jo iaviri de engenembedo Iesu da yei sisera, “Bada nango iso jawo da asisi bebegae ro orase setera iji ainde etera.” ");
INSERT INTO nou_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Setero Iesu mi ungoda yei sisira, “Na Satan utu dodo wowosiri getena. Edo umo burigi be teta birigi da awodo jara ise wosetira. ");
INSERT INTO nou_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Edo naso ge ingiwo. Nanemi ingoda yei goroba ari itena awasedo ingo pepeta ise ingoda tei awa jingabu da ta wuwuji da tamo da itadewa awa mana ungo mi oro ingo memesi tambadewa. Edo na ingoda yei da naso goroba awa itano Satan da goroba de edo asisi bebegae berari ainda goroba awa derigadewa. Edo rora berari mi mana ingo memesi da itadira. ");
INSERT INTO nou_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Edo asisi bebegae mi ingoda ge kera etera awasedo iaviri eove ta iaviri ewo ko Mamo mi ingoda jawo awa utu da gaetiri atira awasedo.” ");
INSERT INTO nou_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Iji ainde Asisi Kotopu Iesu da jo da amimi etiri uso jo awa iaviri be isira. Edo Iesu mi sisira, “Mama imo awa utu de edo busu de da gitijigari. Na imo jasiga ena ainda be awa imo iso ge awa jiro gari embobo da yei unjugedo eoso ungo gadi jarima era te iso ge awa embo jiro egae ainda yei isaga eoso ungo mi gido era. Mama imo awodo edo esa ainda be awa ta imo awodo adi dipapa isesa awasedo na imo jasiga ena. ");
INSERT INTO nou_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Naso Mama mi rora berari awa naso ingoda itira. Edo embo berari na Mamo da mei mo averi awa ungo gae rate Mamo umo umosuka gari ra. Edo embo berari Mamo mo averi awa gae rate na Mamo da mei mi gari ra. Edo embo ave na Mamo da mei mi Mamo isaga adi dipapa ena embomei awa Mamo daedo gari ra.” ");
INSERT INTO nou_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Edo Iesu uso ambojimbi da yei wareregedo ungoda yei gae unjugari da sisira, “Ingo gari seka gosewa awasedo ingo iaviri ewo. ");
INSERT INTO nou_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Edo embo binga sari embobo jiwae edo gitijijigegari nembogamo ingo ro gosewa awa gadi dipapa isera te ungo gari sago ae ra. Edo daedo ge ingo mi ingewa awa ingari dipapa isera te ungo ingari sago ae ra.” ");
INSERT INTO nou_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jew embomei da agodari da atopatari embo mi bugudo Iesu uso ge mi bagedo gadi sisira, “Atopatari na ro edo wasiri natopo atari beni?” ");
INSERT INTO nou_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Setiri Iesu mi uso yei mina sisira, “Ro jiwari mi siri? Imo ajigurise gido esi ta?” ");
INSERT INTO nou_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Setiri embo amimi sisira, “Iso jo berari de asisi berari de iso goroba berari de iso jiro berari de mi Mamo iso dubo buio. Edo imo imosuka simba esa da awodo embo nenei simba eio.” ");
INSERT INTO nou_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Setiri Iesu mi mina sisira, “Imo mina sari ewamei setesa. Edo imo awodo adesa awa imo wasiri natopo atari badesa.” ");
INSERT INTO nou_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Awarate agodari da atopatari awa umo uso jawo awa ewamei da itari dipapa edo gido Iesu da yei nganega isira, “Awarate embo mo averi awa simba eni?” ");
INSERT INTO nou_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Setiri Iesu mi uso mina sari awa kiki eiawa dirisira, “Embo da Jericho nati da mambadi dipapa edo Jerusalem nati dotorisira. Edo umo wosedo yiri bengono embobo mi umo sandido biae be dedo gaedo isera. Edo dedo gaedo uso rora berari awa budo umo ainda dotero betadi aikambu ise atisira. ");
INSERT INTO nou_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Edo iji ainde Jew embo da priest awa emboro ainda pepeta ise embo awa gosisira te umo emboro be nei da awodo sembudo yise edo embo awa derigurisira. ");
INSERT INTO nou_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Edo priest da kondade ari embo uso orobe da jawo Levi daedo yei ainda bugudo embo awa gido emboro be nei da awodo derigurisira. ");
INSERT INTO nou_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Awarate Samaria busu embo awa emboro ainda bugutiko embo awa gido jo mi biae isira. ");
INSERT INTO nou_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Edo embo ainda yei mambudo uso isomatu da siwo jojedo uso bo mi sasiro isira. Edo embo awa budo uso wo jawo donkey tamo da itido budo esega embobo da ewari mando da budo mambudo ainda simba isira. ");
INSERT INTO nou_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Edo sipo de esega embobo da ewari mando da topo da yei Kina etoto awa itido sisira, ‘Imo embo eiawa edo gogo edo simba eio. Edo na iji nonde engenembadena edo ganu ro embo einda indari da pigadesa awa nanemi iso yei da mina itadena.’” ");
INSERT INTO nou_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Awa sedo Iesu mi sisira, “Imo kiki eiawa ingido mo imomo ro kotetesi? Embo tamonde embo bengono embobo midetero betae sumbae isira ainda yei bugusera. Edo embo rawa uso yei ewamei isiri?” ");
INSERT INTO nou_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Setiri agodari da atopatari mi mina sisira, “Embo amei umo jo edo uso jao namendi ari isira awa awara.” Setiri Iesu mi uso yei mina sisira, “Awara imo mambudo wasiri da awodo awa eio.” ");
INSERT INTO nou_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu uso ambojimbi de mambudo edo ungo nati da ainda bugero evetu jawo Martha mi ungo atega isira. Etiri gido ungo uso mando da vivitisera. ");
INSERT INTO nou_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Edo uso jao Mary awa Iesu da tei da anumbedo Iesu da ge awa ingise atisira. ");
INSERT INTO nou_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Edo Mary awa Iesu da ge awa ingise atiri Martha awa indari sia ari da buro jiwae isira awasedo umo tini gambari isira. Edo Iesu da yei bugudo sisira, “Bada naso jao na dotiri na nasuka indari sia ari da buro jiwae be ena. Imo kotesa amomo awara ta? Seio puma na kondade are.” ");
INSERT INTO nou_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Setiri Bada mi mina sisira, “Martha, buro berari emimi etiri imo tini gambari esa. ");
INSERT INTO nou_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Awarate buro da awa ingodena ari dipapa edo era. Edo Mary awa buro ewamei ari dipapa ira awasedo nango mi mana uso buro da awa badera.” ");
INSERT INTO nou_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iji nei de Iesu yei da ainda atise Mamo da yei ge sisira. Edo umo Mamo da yei ge sedo atae etiri uso ambojimbi diti da amimi uso yei sisira, “Gitijigari nango Mamo da yei ge sari da emboro awa atopatigae gore teta John mi uso ambojimbi atopapotisira da awodo.” ");
INSERT INTO nou_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Setero Iesu mi ungoda yei sisira, “Ingo Mamo da yei benunu sadi ise gido eiedo sewo, ‘Mamo embo berari mi iso jawo kotopu awa jasiga ore. Iso gitijigari iji awa itio bugare. ");
INSERT INTO nou_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Edo nangoda indari iji jaige da awa inono da itigae. ");
INSERT INTO nou_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nangoda buria awa kotembedo dogae ainda be awa nango embo amemi nangoda yei buria era awa kotembedo doturera. Edo nango bawari da kundo yiose ta ko nango biae eorase soregae.’” ");
INSERT INTO nou_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Edo Iesu awodo sedo Iesu uso ambojimbi da yei sisira, “Ingo embo da mi uso otao da mando da tumba soropu da mambudo uso yei saetesita, ‘Otao, na ambe be tamonde dipapa ena. Imo naso yei itadesa awa na iso yei ambe be tamonde sekago iso yei itadena. ");
INSERT INTO nou_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ko naso otao nei awa yei berari esega ise buguteviko naso mando da bugira te na indari ae gido uso yei ro itari sago ae ena.’ ");
INSERT INTO nou_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Umo awa sedo sisira ko iso otao awa mando jo da atise ge mina saetira, ‘Na roedo seso jareni. Na matu mangiro be dedo edo na naso kinapeina de ewadi awasedo besi da pasetena. Na mana erido iso indari itadena.’ ");
INSERT INTO nou_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Edo ro aetiri? Sano giwo. Mando topo awa mana erido iso yei ambe awa itaetira ko umo awa iso otao awasedo awarate umo erido imo ro embo simba esi awa itae etira ainda be awa imo iji mata awa tain tain dorise atesa awasedo. ");
INSERT INTO nou_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Awasedo na ingoda yei sena, sedo giwo itari kumbave. Eura edo tambuwo. Taintain dewo mangiro pirigare. ");
INSERT INTO nou_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Edo embo amemi sedo gadira awa badira edo embo amemi eura adira awa tambadira edo embo amemi taintain dadira awa mangiro be pirigadira. ");
INSERT INTO nou_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ingo mamono ingo ingoda memei mi wo embo soro ingo mana jingabu itadewa. ");
INSERT INTO nou_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Edo ungo ri munju embo soro imo mana wuwuji itadewa. ");
INSERT INTO nou_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Edo ingo awa embo bebegae awarate ingo ingoda kinapeina da yei rora ewagaewa itari gari ra. Awarate Mamo utu da atima ira amimi ingoda kando itari awa derigedo embo amemi uso yei sedo gadira ainda yei Asisi Kotopu itadira.” ");
INSERT INTO nou_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Asisi biae mi embo da ainda jo da atise euri embo awa ge sae edo isira awa Iesu mi ondetiri bugusira. Edo Iesu asisi biae awa ondetiri bugiri embo awa ge sadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Edo embo awa ge sadi tuturo iri embo jiwae be mi kove be isera awarate embo nenei mi sisera, “Beelzebul asisi bebegae da gitijigari mi Iesu da yei goroba ititiri edo umo asisi bebegae ondira.” ");
INSERT INTO nou_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Edo embo nenei mi umo ungoda ge mi wao ari dipapa isera. Edo ungo mi God mi Iesu kondade ira awa gorase sedo ungo mi Iesu mi ari goroba de arase sedo gosisera. ");
INSERT INTO nou_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Awarate Iesu ungoda kotari awa gido ungoda yei sisira, “Busu da embo mi katabedo diti diti edo mina dara aetera awa embo berari awa atae aetera. Edo embo orobe da amimi diti diti petedo mina dara aetera awa ungo atae aetera. ");
INSERT INTO nou_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Da awodo asisi bebegae Satan mi gitijigido ira awa diti diti petedo mina dara aetera awa ungo atae aetera. Edo ingo sewa na awa Beelzebul da goroba mi asisi biae ondari ge sewa. ");
INSERT INTO nou_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Edo ingoda ge awa ge be adira awa ingoda ambojimbi rawodo edo asisi bebegae ondedo eri? Ingoda ambojimbi topo mi ingoda ge awa oro ge busari adira. ");
INSERT INTO nou_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Edo na awodo aera te Mamo da goroba mi asisi bebegae ondedo ena awasedo ingo gosewa Mamo ingoda teda buro adi tuturo etira. ");
INSERT INTO nou_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Edo embo goroba embo mi uso gi emi berari sia edo uso mando simba adira awa uso rora berari awa ewamei atadira. ");
INSERT INTO nou_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Awarate embo goroba jiwae de mi umo dedo gaedo edo umo usibesi edo embo ainda gi emi umo tumonda ira awa budo edo uso rora berari bengono edo budo mambudo embo nenei de da kando edo badira. ");
INSERT INTO nou_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Edo embo ave nangae otao ae ira awa naso gitopo ra. Edo embo ave na kondade ari dada eonase ira awa embo awa sisi kakain adira.” ");
INSERT INTO nou_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Edo Iesu mi kiki nei dirise sisira, “Asisi biae mi embo da joda edo bugudo jango indari yei eura edo ambe da mambadira. Edo umo yei tambae edo umo umosuka sadira, ‘Na naso mando doturisena ainda engenembadena.’ ");
INSERT INTO nou_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Awasedo umo engenembedo gosisira ungo mi yei genjedo edo mando sirigurisira awa gosisira. ");
INSERT INTO nou_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Edo awa gido umo mambudo uso asisi bebegae otatao 7 biae umo inge aerate bebegae be bebegae awa budo bugudo daedo ainda atadira. Edo ungo awodo oro embo awa umo matu atima edo isira awodo atadi aerate umo biae be atadira.” ");
INSERT INTO nou_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Edo Iesu awodo setiri evetu da mi embo da teda edo Iesu da yei sisira, “Evetu amemi imo budo simba isiri awa dowo dubo ewamei are.” ");
INSERT INTO nou_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Setiri Iesu mi mina sisira, “Awodo aerate embo de evetu de amemi Mamo da ge ingido edo kera edo ira awa dowo iaviri ore.” ");
INSERT INTO nou_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Edo embo nenei jiwae dada etero Iesu mi ungoda yei sisira, “Embo boroko atera awa embo bebegae ra. Edo ungo ari wasiri goroba de awa gari dipapa edo era. Edo ari wasiri goroba de Jonah da yei isira da awa ungo gadera te ungo mi nei awa gadi aera. ");
INSERT INTO nou_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Edo binga sari embo Jonah da yei ro isira awa Nineveh nati embobo da yei isaga da gari awa isira. Da awodo ro Mamo da mei embo isira ainda yei adira awa embo boroko atera ainda yei isaga da gari adira. ");
INSERT INTO nou_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Edo Mamo busu berari da embo kasadira ainde evetu gitijigari nembodiba busu ijari kena da amimi erido ari embobo boroko atera awa me gadera ko evetu awa yei ribori be pepeta edo embo jiro gari embo Solomon da atopatari ewamei awa gadi bugusira. Awarate na ingoda yei sena na awa Solomon derigedo ingoda teda atena. ");
INSERT INTO nou_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Edo Mamo busu berari da embo kasadira iji ainde Nineveh nati embobo mi erido oro ingo me gadewa ainda be awa ungo Jonah mi Mamo da binga awa setiri gido ungo ungoda wasiri bebegae awa dodo Mamo da yei wareregurisera. Awarate na boroko ingoda yei sena, na Jonah derigedo ingoda teda atena.” ");
INSERT INTO nou_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Embo amemi mana goriwo injibedo yei nei da unjugadira. Daedo embo mi mana goriwo injibedo gono to da itadira. Awodo aera. Embo mando da toradera awa ingodena ungo usasa gadi dipapa adera awasedo ingodena goriwo injibedo inda esegadera. ");
INSERT INTO nou_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Edo ingoda diti awa teta tamo da usasa awodo ra. Edo ingoda diti ewamei awa ingoda tamo berari awa usasa adira te ingoda diti biae awa ingoda tamo berari awa umenga adira. ");
INSERT INTO nou_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Awasedo doawo ingoda yei usasa awa umenga eure simba edo gogo ewo. ");
INSERT INTO nou_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Edo ingoda tamo berari awa usasa mi beda adira nei ro umenga adi ae awa ingoda dombu awa daedo usasa adira teta goriwo mi iso tamo da usasa arago adira.” ");
INSERT INTO nou_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Edo Iesu ge sedo atae etiri Pharisee embo da mi uso mando da mambudo daga indari indarase sisira. Setiri gido Pharisee embo da mando da mambudo indari indadi anumburisira. ");
INSERT INTO nou_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Edo Pharisee embo awa gosisira Iesu umo indari indae giti da umo Jew embobo da wasiri indari indadi ise giti ingo segedo era awa ae isira awa gido kove isira. ");
INSERT INTO nou_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Awasedo Bada mi uso yei sisira, “Ingo Pharisee embobo da atari awa teta ingo ingoda aga de tewo de awa pon awa segedo ewa te jo awa ruvegedo ewa da awodo. Ingoda jo da awa dari betari da kotari de edo kotari bebegae nenei de mi beda etira. ");
INSERT INTO nou_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ingo jiro bebegae embobo Mamo mi ingoda tamo pon isira da awodo jo isira. ");
INSERT INTO nou_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Edo ingoda jo awa dagariae adira awa rora berari iso awa dagariae adira. ");
INSERT INTO nou_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Edo ingo Pharisee embobo ingoda kasari iji awa bugutira awasedo giwo. Edo siwo kosi dada edo muno rora edo rora gowari nenei de awa dada edo diti ajigari 10 edo diti da awa Mamo da yei itido ewa. Edo ingo eiedo ewa te ingo embo nenei jo ae edo ingo Mamo koma bae. Edo ingo ro berari edo ewa awa ise daedo na ro setena awa adewa awa awara adira. ");
INSERT INTO nou_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Edo ingo Pharisee embobo ingoda kasari iji awa bugutira awasedo giwo. Ingo Jew embomei da dada ari yei da ingo embo mi gadera yei ainda anumbari dipapa edo ewa. Edo ingo rora ori garoro ari yei da mambudo ewa awa ingo embo mi ingo sapo ise atega orase dipapa edo ewa. ");
INSERT INTO nou_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Edo ingoda kasari iji awa bugutira awasedo giwo. Ingo awa teta embo mi uje gae busu da aturi tamo da pepeta edo era da awodo. Edo ungo ingo derigedo era te ingoda joda kotari biae ewa awa ungo gae ra.” ");
INSERT INTO nou_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Edo Iesu awa setiri agodari da atopatari mi uso yei sisira, “Atopatari awodo sesa awa imo nango daedo bekuba esa.” ");
INSERT INTO nou_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Setiri Iesu mi mina sisira, “Ingo agodari da atopapotegari ingoda kasari iji daedo bugutira awa giwo. Agodari nembogamo bari sago ae awa ingo mi embo da saga da itido ewa te ingo ingo soro da amimi ungo kondade ae agodari bouga awa ango aera. ");
INSERT INTO nou_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Edo ingoda kasari iji awa bugutira awa giwo. Edo ingo binga sari embobo ingoda mamoumbogo mi detero bebetegurisera ainda uje be awa gongobedo ewa. ");
INSERT INTO nou_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Edo binga sari embobo da uje be awa gongoburise ingo sedo ewa ingoda mamoumbogo mi ungo dorisera amone awara sedo ewa. ");
INSERT INTO nou_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Edo ro Mamo jiro gari embo mi sisira awa be isira. Edo Mamo mi sisira, ‘Nanemi ungoda yei binga sari embobo itano mambadera te nenei awa dedo gaedo ise edo nenei awa doro betadera.’ ");
INSERT INTO nou_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Edo riroga awa ingo embo boroko atewa ainda bugadira ainda be awa Mamo mi rora berari isira edo embo berari isira iji ainde tuturo edo ingoda mamoumbogo mi binga sari embobo jiwae dorisera. ");
INSERT INTO nou_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Edo binga sari embobo dari tuturo isera iji awa tuturo Abel da betari da edo mambudo Zechariah da betari da bugusira. Edo ungoi Zechariah Jew embomei da tumondebain ari oro jo da rorou itari yei da edo yei kotopu da soropu da dorisera. Edo nanemi ingoda yei sena, riroga awa embo boroko atera ainda yei bugadira ainda be awa dari betari berari eiawa awasedo. ");
INSERT INTO nou_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ingo agodari da atopapotegari ingoda kasari iji awa bugutira giwo. Ingo mi jiro gari da mando da be pirigari rora awa bengono etewa. Edo ingo ingosuka torari awa ujo ae ewa awarate ingo embo nenei toradi dipapa era awa beigo beigo ewa.” ");
INSERT INTO nou_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Iesu ge awa sedo atae edo mando awa doturisira. Edo Iesu mando awa dotiri agodari da atopapotegari de Pharisee embobo de awa Iesu uso ge da wao adi jarisera edo umo ge biae sari bekuba adi sedo isera. Awasedo ungoi umo tu burise edo sedo gari neinde kainde uso yei sedo gosisera. ");
INSERT INTO nou_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Embo jiwae be jiwae mi dada edo tei da mina pata ise dada isera awarate giti Iesu mi uso ambojimbi da yei sisira, “Pharisee embo awa gido gowo ewo. Ungo awa ewamei ari inge edo era te ungo awa ewamei aera. Edo ungoda atopatari biae awa teta ambe bajari siwo jawo yeast awodo. ");
INSERT INTO nou_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Edo rora ro embo mi boroko unjugurera awa amboda awa isaga adira edo embo da jo awa embo nenei mi gadera. ");
INSERT INTO nou_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Awasedo imo ro umenga da ge setesa awa embo berari mi iji de ingadera edo ge ro mando jo da gae sasainbari mi setesa awa embo nati jo da berari mi minonu sadera.” ");
INSERT INTO nou_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Iesu mi sisira, “Naso otatao na ingoda yei sena embo ingoda tamo doro betadira te wasiri bebegae nenei ingoda yei ari sago ae era awa oju eove. ");
INSERT INTO nou_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nanemi ave oju evi awa sadena. God uso goroba mi embo dari betoro edo embo riawo matawa atari da pigadira awasedo umo oju ewo. Awa gebe na ingoda yei sena umo oju ewo. ");
INSERT INTO nou_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ingo rimei memeiya ingo da awa ganu kiambu mi ori adewa awarate Mamo mi rimei memeiya da awa ruvegae. ");
INSERT INTO nou_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Da awodo Mamo ingoda beo tu ajigari roinge ri awa gido iji berari ingo simba ira. Edo ingoda mina awa wujiko da mina awa derigedo atira awasedo oju eove.” ");
INSERT INTO nou_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Iesu mi sisira, “Na ingoda yei sena embo amemi embo berari da diti da umo naso topo sadira awa na Mamo da mei embo isena amimi God da asisi ewamei da diti da embo eiawa naso topo ra sadena. ");
INSERT INTO nou_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Awarate embo amemi embo berari da yei umo na gae sadira awa na Mamo da mei embo isena amimi Mamo da asisi ewamei da diti da na embo awa gae sadena. ");
INSERT INTO nou_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Embo amemi na Mamo da mei embo isena ainda yei ge biae sadira embo ainda wasiri biae awa Mamo mi kotembedo doadira te embo amemi asisi Kotopu da yei ge biae sadira embo ainda wasiri biae awa Mamo mi kotembedo doari sago aera. ");
INSERT INTO nou_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","“Edo embo mi ingo budo Jew embobo da dada ari oro edo gitijigari kiambu da edo gitijigari nembodiba da yei imo kasorase mambadera. Edo ungo awodo adera awa imo na ro seni edo na nasuka rawodo edo beitigari ge ro eni awa kotose ainda be awa iji ainde awa Asisi Kotopu mi ro sadesa awa ari sadesa.” ");
INSERT INTO nou_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Embo da teda amimi Iesu da yei sisira, “Atopatari segae naso namendi ungaenaso mama betari da rora edo uso busu awa nangae katabedo bare.” ");
INSERT INTO nou_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Setiri Iesu mi mina uso yei sisira, “Embo amimi na awa ingoda kasari embo awodo edo ingoda rora de edo busu de katabanase awara seteri? Na awodo adi ae ra.” ");
INSERT INTO nou_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Awodo sedo Iesu embo berari ainda yei sisira, “Ingo na na sari embo awodo eove awa gido gogo ewo ainda be awa rora jiwae badewa amimi ari atari ewamei adi aera. Edo embo da rora jiwae be jiwae badira awarate ungoi oro umo atari ewamei adi aera.” ");
INSERT INTO nou_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Edo umo awodo sedo Iesu ungoda yei inia kiki da eiawa sisira, “Embo rora jiwae embo da ainda buro da rora jiwae eririsira edo bari sia isira. ");
INSERT INTO nou_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Edo embo awa umo umosuka kotisira, ‘Naso indari atari oro awa kiambu ra mo na ro eni? ");
INSERT INTO nou_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Awodo kotedo umo umosuka sisira, ‘Na naso indari atari oro kiambu eiawa arasegedo neinda nembodiba be itadena edo ainda naso indari ve de edo naso rora nenei jiwae de itadena. ");
INSERT INTO nou_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Itido na nasuka jo da kotadena iji ewamei naso yei da bugira. Edo naso rora ewagaewa jiwae be eiawa gaeko jiwae be atadira awasedo na jango indise indido kumbudo ise na iaviri adena.’ ");
INSERT INTO nou_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Awarate Mamo mi uso yei sisira, ‘Imo jiro biae embo, boroko tumbade imo betadesa. Edo imo betaso rora berari inemi imo embo etesa emomo amemi beiri?’” ");
INSERT INTO nou_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Edo Iesu inia da kiki eiawa sedo Iesu uso ge atae ise sisira, “Embo ave umo umosuka awasedo rora jiwae dada edo ira te Mamo da ewamei ari awa tambae edo ira embo ainda yei rora da eiedo awa adira.” ");
INSERT INTO nou_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iesu mi uso ambojimbi da yei sisira, “Awasedo na ingoda yei sena ingoda wasiri awasedo dubo vevera edo seove, ‘Na rora inono da nonda budo indeni?’ Edo daedo ingoda tamo awasedo dubo vevera edo seove, ‘Naso ombari digari yei nonda beni?’ ");
INSERT INTO nou_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Awarate ingoda wasiri mi indari derigedo atira edo daedo ingoda tamo mi ombari digari derigedo atira. ");
INSERT INTO nou_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Giwo oga mane inda tembera. Ungoda indari atari oro kiambu de indari atari oro nembodiba de atae rate Mamo mi ungoda indari itido ira. Edo rimemei awa mina nembogamo rate ingo awa mina nembogamo be nembogamo ra. ");
INSERT INTO nou_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Edo ingoda wasiri awasedo dubo vevera adewa amimi mana ari ingo iji ribori atadewa. ");
INSERT INTO nou_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Edo ingo awodo ari sago ae ewa mo ro awasedo rora nenei awasedo dubo vevera evi? ");
INSERT INTO nou_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ri wuji eririra awa kotewo. Ungo buro ae ra. Edo ungo ungosuka gongobaera te ungoda gari awa dagariae be ra. Na ingoda yei sena rora jiwae embo Solomon awa uso ombari digari dagari egeregae ra te ri wuji da gari dagari egae amimi Solomon da ombari da gari ewagaewa awa derigurira. ");
INSERT INTO nou_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Edo sasawa boroko eririra te euma awa vejedo pigoro ri mi ewadira te Mamo babojise euri sasawa awa gari dagariae be edo ira. Edo da awodo Mamo mi ingoda ombari digari itadira. Edo ingoda tumonda ari kiambu awa kotewo. ");
INSERT INTO nou_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Edo dubo memesi eove. Edo iji berari na ro indido kumbudo eni awa kotove. ");
INSERT INTO nou_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Edo embo God gae awa iji berari ungo indari inono da tambae etera edo ombari digari de baetera awasedo dubo vevera edo era. Te ingoda Mamo ingo ro dipapa ewa awa gosira. ");
INSERT INTO nou_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Edo ingo dubo vevera ewa awa dowo. Edo Mamo da wasiri seka awa tambae etewa awa embo jo da kotewo. Edo awodo ewo unemi rora berari einde da itadira.” ");
INSERT INTO nou_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Iesu mi sisira, “Ingo embo enumbaeko ingoda Mamo umo ingoda yei uso ewamei ari jiwae itadi iaviri ira awasedo oju eove. ");
INSERT INTO nou_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ingoda rora berari awa ori edo ganu awa rora ae embobo da itiwo. Awodo adewa awa ingo rora mina nembogamo de jiwae tambadewa awa biae adi aera. Edo rora eiawa Mamo mi utu da ingo awasedo dada adira ainda ungoda ajigari awa mana kiambu adira ainda be awa bengono embobo mi mana bengono adera edo jiniko mi mana indadira. ");
INSERT INTO nou_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Edo yei iso rovi ravi itadesa yei da ainda iso jo daedo atadira.” ");
INSERT INTO nou_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Iesu mi sisira, “Ingoda sini digido gogowo edo goriwo injibedo iji berari sia ewo teta agipo embobo ungo ungoda gitijigari jimbari bondo dodo engenembadira awa simba era awodo awasedo umo bugudo tain tain dari ungo burigi be be pirigadera. ");
INSERT INTO nou_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Awarate gitijigari engenembedo agipo embobo erido sia edo atiroro gadira awa ungo dubo ewamei adera ko na ingoda yei sena umo buro ombari budo ombudo sari ungo anumboro ungoda indari ititise edo ungo simba adira. ");
INSERT INTO nou_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Umo tumba soropu da o sipo usabasa irirari bugudo ungo sia edo atiroro gadira awa ungo iaviri adera. ");
INSERT INTO nou_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Awarate eiawa kotewo. Embo mando topo awa iji nonde bengono embo bugudo uso mando bejedo toradira awa gido umo sia adira awa umo torurase beitigadira. ");
INSERT INTO nou_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Edo ingo iji berari awa sia ewo ainda be awa na Mamo da mei bugudo embo isena awa ingo naso bugari iji awa kotae atadewa iji ainde na bugadena awasedo.” ");
INSERT INTO nou_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter mi Iesu da yei sisira, “Bada imo inia kiki emomo nangoda yei sesi ta ko embo berari da yei sesi?” ");
INSERT INTO nou_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Setiri Iesu mi mina sisira, “Embo ave agipo embo ewamei embo ainda yei na ge sena. Edo embo ave saboa edo jiro gari agipo embo awa uso gitijigari mi sari agipo embobo nenei da buro awa simba adira. ");
INSERT INTO nou_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Edo uso gitijigari awa esega mambudo edo uso mando da engenembedo bugudo uso buro embo ro arase setira awa iri getira awa agipo embo awa iaviri adira. ");
INSERT INTO nou_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Edo umo iaviri adira ainda be awa gitijigari mi sari agipo embo amimi uso rora berari de uso busu de awa simba adira edo umo awa buro embo da nembodiba adira. ");
INSERT INTO nou_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Awarate agipo embo awa kotadira, ‘Naso gitijigari mana burigi engenembadira,’ awasedo umo buro embobo nenei de buro embo evetu de awa dedo gaedo edo umo umo okain indido jiro biae edo. ");
INSERT INTO nou_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Edo umo awodo irirari gitijigari da bugari iji awa uso agipo embo awa gae iji ainde umo engenembadira. Edo engenembedo gitijigari agipo embo awa vejedo embo bebegae da yei da itadira. ");
INSERT INTO nou_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Edo agipo embo umo uso gitijigari ro arase dipapa ira awa gosira te sia ae adira edo ro uso gitijigari mi arase sira awa ae adira, embo awa ungoi vejadera awa riroga nembodiba badira. ");
INSERT INTO nou_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Awarate agipo embo umo uso gitijigari mi ro arase dipapa ira awa gae edo buro biae adira embo awa riroga kiambu badira. Edo embo ave rora jiwae badira awa ungoi soro mina rora jiwae mina itadira. Edo embo ave rora jiwae be jiwae badira awa ungoi soro mina rora jiwae be jiwae mi mina itadira.” ");
INSERT INTO nou_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iesu mi sisira, “Na riawo pigano busu da embo berari da tamo da vitarase bugusena. Edo naso buro atae adira iji ainde na iaviri adena. ");
INSERT INTO nou_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Edo memesi nanemi badena awa nembodiba be ra. Edo na boroko awa dubo vevera ena te naso memesi awa atae adira na iaviri adena. ");
INSERT INTO nou_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Edo ingo kotewa naso bugari mi ari embo dubo ewamei de ateri ta? Awodo kotove ainda be awa naso bugari mi mana ari embo da atari awa ewamei adira te naso bugari mi ari embo ewoga ewoga adera. ");
INSERT INTO nou_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Boroko tuturo edo embo ingo da awa mando da ainda atima era awa kausu kausu edo ungoi diti etoto adera. Tamonde awa etoto da gitopo edo etoto awa tamonde da gitopo adera. ");
INSERT INTO nou_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Edo eiedo awa kausu kausu adera. Mamo de mei de awa gitopo mina ara adera. Edo ai de uso gagara de awa gitopo mina ara adera. Edo mei da aro de uso umboti de awa gitopo mina ara adera.” ");
INSERT INTO nou_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Edo Iesu daedo embo da yei sisira, “Ingo poroga waiko wosedo ira ainda vivitirari gido ingo sadewa ga bugadira sadewa awa awodo adira. ");
INSERT INTO nou_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Edo ingo bisara nembodiba be ijari kena edo sumburari ingo sadewa boroko awa waiko nembodiba janibadira sadewa. Awodo awa adira. ");
INSERT INTO nou_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Edo ingo ise sarago ari embobo ingo wasiri utu da edo busu da awa gido ainda be awa gido ewa. Edo ro edo ingo naso bugari da wasiri awa ingo gaeri?” ");
INSERT INTO nou_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ro edo ingo ingosuka ro ewamei ri awa gido ae edo evi? ");
INSERT INTO nou_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Edo embo da mi iso yei da rora ro embo tini gambari edo imo budo kasari yei da mambutirari gido edo imo yei ainda seka mambuse gido edo gido ge awa embo ainga seio ewamei are. Edo imo awodo ae adesa awa unemi imo awa budo kasari embo da yei mambadira. Edo kasari embo mi imo awa budo bundari embo da yei itadira edo bundari embo mi imo awa gajari oro da itadera. ");
INSERT INTO nou_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Edo nanemi iso yei sena imo mana gajari oro awa doadesa te giti awa imo iso mina awa itido ponda bugadesa.” ");
INSERT INTO nou_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Iji ainde embo nenei ainda atisera amimi Iesu da yei sisera, “Galilee busu embobo nenei mi wo mi Mamo da yei rorou ititero Pilate mi setiri embo nenei mi bugudo ungo detero bebetisera.” ");
INSERT INTO nou_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Setero Iesu mi mina sisira, “Ingo kotewa ungoda wasiri bebegae mi Galilee busu embomei nenei da wasiri bebegae awa derigari awasedo ungo bebetiseri ta? ");
INSERT INTO nou_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Awodo ae be aera. Edo na ingoda yei sena ingo ingoda wasiri bebegae awa dodo Mamo da yei wareregae adewa awa ingo berari awa daedo betadewa. ");
INSERT INTO nou_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Edo ingo embo 18 awodo Siloam ainda mando mi wosedo patetiri bebetegurisera mo kotevi ta? Edo ingo kotewa ungoda wasiri bebegae mi embo nenei Jerusalem nati da atima era ainda wasiri bebegae awa derigari ta? ");
INSERT INTO nou_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Awodo ae be aera. Edo na ingoda yei sena ingo ingoda wasiri bebegae awa dodo Mamo da yei wareregae adewa awa ingo daedo betadewa.” ");
INSERT INTO nou_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu mi ungoda yei inia kiki eiawa sisira, “Embo da mi menga awa uso buro da gousira edo ri awa erido atisira. Edo amboda embo awa menga be wujadi bugusira te be aera. ");
INSERT INTO nou_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Awasedo umo uso buro simba ari embo da yei sisira, ‘Giwo gaeko tamonde na einda bugutemona edo ri einda be da meani tambae. Edo ri emone tepo busu ngamo awa indise atira awasedo ri eiawa jegewo durare.’ ");
INSERT INTO nou_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Awarate buro embo mi sisira, ‘Naso gitijigari doio gaeko da eiawa atare. Edo gaeko einde nanemi busu be ngambedo edo wo je awa itido gane. ");
INSERT INTO nou_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Edo gaeko nei ri awa be adira awa awara doaso atadira te be ae adira awa jegaso duradira.’” ");
INSERT INTO nou_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jew embomei da tumondebain ari iji da Iesu awa Jew embomei da dada ari oro da atopapotise atisira. ");
INSERT INTO nou_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Edo evetu da awa ainda atisira edo asisi bebegae uso jo da gaeko 18 awodo atise eoro umo karu de atima isira. Edo evetu ainda gun vetu awa detegari awasedo umo dagaia edo derari sago ae edo isira. ");
INSERT INTO nou_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Edo Iesu evetu awa gido umo evetu awa jawo setiri uso yei bugusira edo Iesu uso yei sisira, “Evetu na imo wujegurena edo iso karu atae etira edo imo ewamei etesa.” ");
INSERT INTO nou_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sedo uso ingo uso tamo da itiri uso gun vetu burigi be dagaia etiri umo dambuderari derido Mamo jasiga isira. ");
INSERT INTO nou_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Edo Jew embomei da dada ari oro da gitijigari mi tini gambari isira ainda be awa Iesu mi tumondebain ari iji de evetu awa etiri ewamei isira awasedo. Awasedo umo embo jiwae be atisera ainda yei gogo dimbudo sisira, “Iji 6 ainde ingode buro adera awasedo iji ainde buguwo unemi ingo ewamei are awarate tumondebain ari iji de bugove.” ");
INSERT INTO nou_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Setiri Bada mi uso yei mina sisira, “Ingo ise sarago ari embobo ingo berari tumondebain ari iji de ingoda wo cow ta donkey awa wujegedo budo koto ngambari da mambawo umo indadira. ");
INSERT INTO nou_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Edo evetu eiawa Abraham da orobe awa Satan mi matu boroko ae be bundisira edo gaeko 18 atae etira. Edo ro edo ingo nanemi tumondebain ari iji de evetu eiawa ewamei etena awa biae kotevi?” ");
INSERT INTO nou_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sisira da amimi etiri uso gitopo embobo berari awa ungo ungosuka me gosisera te embo nenei awa iaviri isera ko umo wasiri ewagaewa eiawa ira awasedo. ");
INSERT INTO nou_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu mi ungoda yei sisira, “Mamo da gitijigari iji awa gari rawodo ri? Rawodo edo ingoda yei ujugano gevi? ");
INSERT INTO nou_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mamo da gitijigari iji awa teta ve jawo mustard ingera edo embo mi budo uso buro da gousira. Edo ve emone kiambu be ra te koru edo bugudo ri nembodiba be eradira edo ri memei uso patu da ungoda ngaja itadera.” ");
INSERT INTO nou_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu ungoda yei inia kiki nei sisira, “Mamo da gitijigari iji awa rawodo awa sano gevi? ");
INSERT INTO nou_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mamo da gitijigari iji awa teta ambe bajari siwo jawo yeast emboevetu mi budo ambe de da jigido era da awodo ra. Edo awodo dause atoro edo ambe berari awa bajido sauma ira.” ");
INSERT INTO nou_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu Jerusalem mambuse nati memeia de nati nembogamo de awa da da torido bugudo ise mambusira. Edo umo awodo ise embo atopapotisira. ");
INSERT INTO nou_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Edo embo da mi uso yei nganega isira, “Atopatari Mamo mo embo enumbae ko awa soregeita?” ");
INSERT INTO nou_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Setiri Iesu mi mina ungoda yei sisira, “Mangiro be utu da awa kiambu ra awasedo imo iso goroba mi edo mangiro be kiambu da toradi jareio. Edo na ingoda yei sena embo jiwae be mi toradi jaradera te ungo inono ae awa mana toradera. ");
INSERT INTO nou_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Edo amboda mando topo erido mangiro be digadira te ingo awa ponda derido atise mangiro be da tain tain dorise sadewa, ‘Bada nango embo mangiro pirigegae.’ “Edo ingo awodo sawo unemi ingoda yei mina sadira, ‘Ingoda nati jawo mo rori? Na ingo gaera.’ ");
INSERT INTO nou_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Sari ingo mina sadewa, ‘Imo nangoda nati da bugudo embo atopapotisesa edo iji ainde nango ingae indido kumbudo isera.’ ");
INSERT INTO nou_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Edo ingo awodo sawo umo ingoda yei mina sekago sadira, ‘Ingoda nati jawo mo rori? Na ingo gaera. Ingo wasiri biae embo na dodo mambuwo.’ ");
INSERT INTO nou_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Edo amboda ingo ji sise di vegadewa ainda be awa Abraham de Isaac de Jacob de edo binga sari embobo berari de awa Mamo ga atera uso gitijigari yei da edo ingo awa ponda atadewa. ");
INSERT INTO nou_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Embo iji vitari da edo iji wosari da edo ijari da edo sawari da awa ungoi bugudo dada anumbedo Mamo da gitijigari yei da indise atadera. ");
INSERT INTO nou_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Edo yei ainda awa embo boroko gun da mambutera awa ungoi giti adera. Edo embo nenei ungoi boroko giti giti mambutera awa ungoi amboda adera.” ");
INSERT INTO nou_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iji ainde Pharisee embobo nenei mi Iesu da yei bugudo uso yei sisera, “Herod imo dadi dipapa ira awasedo yei eiawa dodo yei nei da mambuio.” ");
INSERT INTO nou_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Setero Iesu mi ungoda yei sisira, “Ingo mambudo ambe sino ainda yei sewo gare, Na boroko edo euma awa asisi bebegae awa ondadena edo karu embobo ano ewamei adera. Edo iji tamonde atae ari na naso buro awa atae adena Herod sewo gare. ");
INSERT INTO nou_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Boroko edo euma edo sipo nei tei mi Jerusalem nati da mambadena ainda be awa ungo binga sari embo yei nei da doro betadira awa awara aera. ");
INSERT INTO nou_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem embobo, Jerusalem embobo. Ingo awa iji berari Mamo da binga sari embobo awa deowo betedo era. Edo Mamo mi iji berari binga sari embobo ingoda yei itido ira awa ingo mi ganuma mi dawo betorase pigedo ewa. Edo na ingo embo berari awa naso yei aikambu dada edo teta kokora ai mi uso kinapeina awa uso piki mi apuregedo ungo soregedo ira da awodo adi ena te ingo ujo ae ewa. ");
INSERT INTO nou_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Edo Mamo ingoda nati eiawa dodo mambadira. Na ingoda yei sena boroko tuturo edo mambudo naso engenembari iji de awa ingo mana na gadewa. Edo iji bugari ingo na sekago gido sadewa, ‘Embo Mamo da jawo da bugudo pira awa Mamo mi umo ewamei are.’” ");
INSERT INTO nou_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jew embomei da tumondebain ari iji da Iesu Pharisee embomei da gitijigari da mando da indari indadi mambusira. Edo umo ainda atiri embo mi umo diti jimba isera. ");
INSERT INTO nou_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Edo ungo diti jimba edo gogo ero embo da uso tei de ingo de bajari amimi Iesu da yei bugusira. ");
INSERT INTO nou_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Edo umo bugiri Iesu mi agodari da atopapotegari de Pharisee embomei de da yei nganega isira, “Ingodenaso agodari mi tumondabain ari iji de embo oro ewamei orase sisita mo sae ri?” ");
INSERT INTO nou_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Setiri ungo ge nei da ro sae jamo jamo edo atisera. Edo Iesu embo ainda ingo awa budo etiri ewamei etiri itiri mambusira. ");
INSERT INTO nou_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Edo Iesu umo embo awa itiri mambutiri umo ungoda yei nganega isira, “Tumondebain ari iji de mei kiambu ta wo cow ta ko ingoda teda embo da awa umo koto da duraetira mo ingo burigi mambudo jigawo vitaetira mo awara ta mo awara ae ri?” ");
INSERT INTO nou_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","“Awa umo nganega isira edo ungo sekago ge sae jamo jamo isera edo uso ge mina sari sago ae isera. ");
INSERT INTO nou_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu esega embobo nenei mi embo nembogamo da anumba awa eura edo ainda anumburero gosisira awasedo umo inia da kiki eiawa ungo berari da yei sisira, ");
INSERT INTO nou_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bondo susu mi ingo jimbari bondo da mambawase oru ari gido gaegae edo embo nembogamo da anumba da anumbeove ko bondo susu embo nembodiba oru etita rora awasedo. ");
INSERT INTO nou_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Edo bondo susu ingo etoto oru etira amimi iso yei bugudo sadira, ‘Erido doio embo eiawa ainda anumbare.’ Sari imo me gosise embo nembogamo ae da anumba da ainda anumbadesa. ");
INSERT INTO nou_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Awarate bondo susu mi imo bondo da oru ari imo mambudo embo tepo da anumba da anumbedo atio. Edo imo ainda anumbedo atiroso edo bondo susu mi bugudo iso yei sadira, ‘Naso otao puio embo nembogamo da anumba da anumbase.’ Awodo sadira awa embo esega bugujegetera amimi imo awa embo nembodiba awa gadera. ");
INSERT INTO nou_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Edo embo amemi uso jawo jigari eradira awa Mamo mi ari umo saboa adira te embo ave umo saboa adira awa God mi uso jawo awa jigari eradira.” ");
INSERT INTO nou_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Edo Iesu mi bondo susu da sisira, “Imo bondo sia edo gido iso otatao de iso nanonamendi de edo iso orobe de edo iso jao namendi edo rora embo demonda awa oru eose. Imo awodo adesa awa imo ro etesa ainda mina awa badesa ainda be awa ungo mi imo ungoda bondo da oru oro mambadesa. ");
INSERT INTO nou_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Imo bondo sia ise embo rora atae edo embo tei ingo ambari embo edo embo ketu mi kondade euri tembuma era awa oru eio. ");
INSERT INTO nou_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Embomei emimi iso mina awa mana itadira te Mamo mi imo ewamei adira. Amboda embo ewagaewa awa betedo sekago eradera iji ainde Mamo mi iso mina awa itadira.” ");
INSERT INTO nou_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Embo da ainda anumbedo Iesu ga indari indise atisira amimi ge awa ingido Iesu da yei sisira, “Embo Mamo da gitijigari yei da anumbedo atise indera awa iaviri era.” ");
INSERT INTO nou_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Setiri Iesu mi uso yei sisira, “Embo da amimi bondo nembodiba sia edo embo jiwae be oru isira. ");
INSERT INTO nou_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Edo bondo iji bugusira etiri umo uso agipo embo itiri embo matu bondo da bugorase oru isira awa bugorase sadi mambusira. Mambudo ungoda yei sisira, ‘Ingo berari boroko puwo nango bondo da rora berari sia etera.’ ");
INSERT INTO nou_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Edo uso agipo embo ungoda yei mambudo awodo setiri embo berari awa da da ungo buro nenei ari ge sisera. Edo embo da mi agipo embo da yei sisira, ‘Na mambona te busu seka betena awa gadi sedo mambadena. Edo seio iso gitijigari naso yei ge biae koture.’ ");
INSERT INTO nou_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Edo embo nei mi sisira, ‘Na buro wo oxen 10 awodo betena edo ungo buro wo ewagaewa ta buro wo bebegae ri awa gadi mambutena. Awasedo iso gitijigari seio naso yei kotari biae eure.’ ");
INSERT INTO nou_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Edo embo nei mi sisira, ‘Na boroko aro jimbena awasedo na mambari sago ae ena.’ ");
INSERT INTO nou_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Edo ungo berari awodo setero agipo embo engenembedo uso gitijigari da yei ungo ro sisera awa sisira. Edo umo awodo setiri embo awa tini gambari edo uso agipo embo da yei sisira, “Burigi mambudo emboro memeia berari da edo emboro nembogamo berari da edo nati demo da, embo rora ae embobo berari de embo tei ingo ambujegari de diti guba egeregari de embo ketu de awa berari budo bonda da buguio.’ ");
INSERT INTO nou_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Setiri agipo embo mambudo engenembedo bugudo uso gitijigari da yei sisira, ‘Ro anase setesa awa etena te yei awa embo mi atoae ae atira.’ ");
INSERT INTO nou_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Setiri embo amimi uso agipo embo da yei sisira, ‘Mambudo emboro yei besaun da memeia de nembogamo de berari ainda embo berari tambadesa awa doio torore edo naso yei awa embo mi atoae be ore. ");
INSERT INTO nou_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Edo na iso yei sena embo berari tuturo da oru etena awa naso bondo da indari awa mana indadera.’” ");
INSERT INTO nou_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Embo jiwae be awa Iesu ga da pepeta isera. Edo Iesu wareregedo ungoda yei sisira, ");
INSERT INTO nou_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Embo amemi naso ambojimbi adi dipapa edo gido uso dubo bari mi naso yei uso dubo bari mamo da ta ai da ta aro da ta kinapeina da ta nanonamendi da ta ruaimono da edo umo umosuka awa derigadira. ");
INSERT INTO nou_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Edo embo ave umo na ambo ambo ise edo uso orega ango ae adira embo awa naso ambojimbi adi aera. ");
INSERT INTO nou_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Edo inia ge sane embo ingoda teda da awa umo mando nembodiba itadi jiro buro adira giti awa umo anumbedo mando ainda mina roingeri awa kotadira. Edo uso ganu ajigedo sadira, ‘Naso ganu mo inono ta ko inono ae ri?’ ");
INSERT INTO nou_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Edo umo awodo giti ae adira awa amboda umo tutuvi itadira edo burigi atae ae adira iji ainde awa embo berari mi uso buro awa gido umo ganduburise sadera, ");
INSERT INTO nou_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Embo eiawa uso mando adi tuturo isira te umo atae ari sago ae ira.’ ");
INSERT INTO nou_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Edo sekago ge sane gitijigari nembodiba da mi gitijigari nembodiba nei ga da nange gaiadi dipapa adira awa umo embogo awa ae atise umo anumbedo kotadira, ‘Naso isoro embobo 10,000 mo naso gitopo embo da isoro embobo 20,000 mo derita?” ");
INSERT INTO nou_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Edo umo kotadira, ‘Naso isoro embobo inono aera,’ awa uso gitopo embo awa yei besaun atirari umo binga sari embomei itari uso gitopo da yei mambadera. Edo ungo uso yei mambudo daga dubo ewamei ari adi sedo gadira. ");
INSERT INTO nou_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Da awodo embo amemi uso rora berari doae adira awa umo mana naso ambojimbi adira.” ");
INSERT INTO nou_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Iesu mi sisira, “Tokaka awa ewamei awarate tokaka uso tokaka da gambari awa atae adira awa inemi mana aso tokaka sekago adira. ");
INSERT INTO nou_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tokaka awodo awa rora nenei da yei ewamei aera. Edo ingode nanemi mana oro busu ngamo arase adira. Amone jingama ari sago ae be etira edo ingode pigoro mambadira. “Edo ingo naso ge da be gari dipapa edo re ingido gogowo ewo.” ");
INSERT INTO nou_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iji da tax bari embobo jiwae de embo bebegae de bugudo Iesu da ge ingise atisera. ");
INSERT INTO nou_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Edo Pharisee de agodari da atopapotegari de ujo ae edo sisera, “Embo eiawa embo bebegae de otao ise edo daedo indari indido ira.” ");
INSERT INTO nou_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Setero Iesu ungoda yei inia kiki eiawa sisira. ");
INSERT INTO nou_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Embo da ingoda teda awa wo sheep 100 awodo topo aetira edo gaetira wo da awa jajovegetira awa edo embo awa ro aetiri? Wo 99 awa indari indari yei ainda dodo wo da jajovegetira awa mambudo eura aetira. ");
INSERT INTO nou_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Edo umo eura edo doae edo iji ainde tambudo awa eura doadira. Edo umo iaviri ise saga da budo edo engenembedo nati da bugadira. ");
INSERT INTO nou_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Edo umo budo nati da engenembedo buguse uso otatao de jao namendi de jawo sise ungoda yei sadira, ‘Na dubo ewamei ena ko naso wo sheep da munenegetira awa tambena awasedo. Puwo nangae da iaviri ave.’” ");
INSERT INTO nou_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Edo umo kiki awa sedo Iesu mi sisira, “Na ingoda yei sena, da awodo embo 99 awa ewamei atise edo Mamo ambo ambo ari doae era awa embo utu da atera awa iaviri kiambu era. Awarate embo da wasiri biae edo ira embo awa uso wasiri biae awa dodo Mamo da yei wareregadira awa umo embo ungo awa iaviri be iaviri be adera.” ");
INSERT INTO nou_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Iesu mi inia kiki eiawa sisira, “Evetu da awa uso yei Kina 10 ataetira edo Kina da awa doae etira awa ro aetiri? Umo goriwo injibedo uso mando genjedo edo yei berari da eura edo gogo aetira. Edo umo eura edo doae adira awarate amboda uso Kina da awa tambudo eura ae doadira. ");
INSERT INTO nou_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Edo evetu awa uso Kina da awa tambudo uso otatao de uso jao tato de jawo sari dada oro ungoda yei sadira, ‘Na naso Kina da jajovegurana awa tambena awasedo na iaviri ena. Puwo nangae da iaviri ave.’” ");
INSERT INTO nou_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Edo Iesu inia kiki awa sedo sisira, “Na ingoda yei sena, da awodo embo wasiri biae edo ira embo da awa uso wasiri biae awa dodo Mamo da yei wareregadira awa Mamo da asisi ewagaewa iaviri adera.” ");
INSERT INTO nou_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu mi inia ge eiawa dirisira, “Embo da awa uso memei etoto de atima isira. ");
INSERT INTO nou_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Edo mei ambo mi uso mamo da yei sisira, ‘Mama iso busu awa amboda katabedo nango memei etoto da yei itadesa te naso tega awa boroko itae etesita.’ Awa setiri embo awa uso busu awa katabedo uso memei jaige ungoda tega awa ititisira. ");
INSERT INTO nou_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Edo iji tupo atae etiri mei ambo awa uso busu seka awa ori edo ganu budo uso mamo da mando awa dodo umo busu besaun be ainda mambusira. Ainda mambudo umo atari tepo tapo ise atiri uso ganu awa burigi be atae isira. ");
INSERT INTO nou_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Edo uso ganu atae etiri ainda baimana iji bugusira. Etiri mei awa indari atae edo nei ro atae tepo awodo ainda atima isira. ");
INSERT INTO nou_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Awasedo embo da busu ainda atima isira embo amimi uso yei buro ititisira. Edo embo amimi mei awawa uso busu da uso pu simba arase itiri mambusira. ");
INSERT INTO nou_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Edo mei awa beji mi biae edo pu da indari awa indae etira awa kotisira. Edo embo da amemi uso yei indari itae indae. ");
INSERT INTO nou_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Edo amboda mei awa uso wasiri biae awa kotedo sisira, ‘Embo berari naso mama da yei buro edo era awa ungoda indari awa inono edo nenei buso dodo era te na awa einda atise edo beji mi betadi aikambu ena. ");
INSERT INTO nou_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","19","Edo erido naso mama da yei mambudo sadena, ‘Mama na wasiri biae iso yei edo God da yei memesi nembodiba be itena awasedo na iso mei awodo seose ta na iso buro ari embomei da teda da edo buro ane.’ ");
INSERT INTO nou_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Awodo sedo mei awa erido pepeta edo uso mamo da yei engenembedo mambusira. “Edo umo mambutiri mamo nati da edo mei yei ribori butiri gosisira. Gido umo uso mei jo isira. Etiri mamo sumbudo mei sandido muno isira. ");
INSERT INTO nou_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Edo mamo umo awodo iri uso mei mi sisira, ‘Mama nanemi wasiri biae eteno imo memesi buresa da awodo Mamo memesi burira. Edo na awa wasiri biae embo ra awasedo na iso mei awodo seose.’ ");
INSERT INTO nou_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Awa setiri mamo uso buro embobo jawo setiri uso yei bugero sisira, ‘Burigi ombari ewamei budo puwo ombare. Edo ingo bumbuke itiwo mungari edo uso tei goru itiwo asugare. ");
INSERT INTO nou_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Awodo edo ingodenaso wo mei da nembogo awodo budo dewo betari edo bondo sia ave. ");
INSERT INTO nou_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ingode indise iaviri ore ko na naso mei bebetisira awodo kotemona te umo boroko wasiri de engenembetira. Umo munenegurisira te bugiri betena.’ Awa sedo setiri bondo jijigurisera. ");
INSERT INTO nou_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Edo ungo awodo ero mei bego awa uso buro da buro ise atiko engenembedo bugudo mando aikambu ise ya sedo diuse ero ainda javi awa ingisira. ");
INSERT INTO nou_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ingido buro embo da jawo setiri bugiri uso yei nganega isira, ‘Eiroedo embo ya sise diveri? ");
INSERT INTO nou_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Awa setiri buro embo mi mina sisira, ‘Iso namendi engenembedo bugira awasedo iso mamo mi wo mei da detira. Edo umo yaviri ira ainda be awa iso namendi awa wasiri de engenembetira awasedo.’ ");
INSERT INTO nou_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Edo umo awodo setiri mei bego awa tini gambari edo gido mando da torari ujo ae isira. Awasedo uso mamo mi bugudo torarase sedo gosisira. ");
INSERT INTO nou_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Etiri mei bego mi mamo da ge mina sisira, ‘Gaeko tupo atae be na imo sapo ewamei ise pemona edo na imo ro anase sewosa awa emona. Edo imo naso yei ro itesi? Imo naso yei wo kiambu itae na naso otatao de bondo ae. ");
INSERT INTO nou_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Awarate iso mei eiawa viro emboevetu de atise uso ganu atae be pigiteviko engenembedo bugiri imo umo embo wo mei da detesa.’ ");
INSERT INTO nou_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Awa setiri uso mamo mi mina sisira, ‘Naso mei imo awa iji berari nangae atima esa edo rora naso berari awa iso ra. ");
INSERT INTO nou_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Awarate ingodena iaviri de bondo era ainda be awa iso namendi betari awodo kotise atemona edo umo munenegurisira awa sekago bugiri betena.’” ");
INSERT INTO nou_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu mi uso ambojimbi da yei sisira, “Embo da mi rora embo da rora berari awa simba edo isira. Edo umo simba iri embo nenei mi bugudo rora jiwae embo da yei sisera, ‘Iso buro simba ari embo awa iso gano tepo tapo jingama iri atae ira.’ ");
INSERT INTO nou_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Setero rora embo mi uso buro simba ari embo awa jawo setiri uso yei bugiri sisira, ‘Iso buro da ge eiawa ro ingeni? Na imo boroko sano naso buro da awa atae adesa awara awasedo buro da ge ro gaewosa awa budo puio gane.’ ");
INSERT INTO nou_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Setiri buro simba ari embo awa kotisira, ‘Na naso gitijigari mi sari buro eiawa doadena mo namo buro mo ro eni? Na buro okain ari sago ae ena edo na rora embo benunu sadena awa na me gadena. ");
INSERT INTO nou_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Edo naso buro atae adira awa na otatao ano amimi na ungoda mando da soro mambano ungo mi na simba adera. Awasedo na ro adena awa gosena. ");
INSERT INTO nou_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Edo embo awa awodo kotedo embo uso yei uso gitijigari da rora budo mina amboda itadi sisera awa jawo setiri da da uso yei bugusera. Edo da awa bugiri buro simba ari embo mi uso yei sisira, ‘Imo rora roinge naso gitijigari da yei budo amboda mina itadi sisesi?’ ");
INSERT INTO nou_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Setiri embo amimi sisira, ‘Utingi berari 100 awodo awa oil mi beda ari.’ “Edo umo awodo setiri buro simba ari embo mi sisira, ‘Eire buro da ge gaiari atira 100 awa tupedo 50 awodo gaeio.’ ");
INSERT INTO nou_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Edo embo nei awa bugiri buro simba ari embo mi uso yei sisira, ‘Imo rora roinge awa naso gitijigari da yei da budo amboda mina itadi sisesi?’ “Setiri embo amimi mina sisira, ‘Indari wheat awa karara 100 awodo.’ “Setiri edo buro simba ari embo mi uso yei sisira, ‘Eire buro da ge jiwari eire 100 awa tupedo kondago 80 gaeio.’ ");
INSERT INTO nou_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Edo rora embo eiawa uso buro simba ari embo mi isira awa gido umo kotisira umo awa jiro gari embo awodo awasedo umo embo awa jasiga isira. Edo busu da embo ungoda rora simba ari da awa jiro gari embobo ra te Mamo da embobo ungoda rora simba ari da awa jiro gari kiambu ra. ");
INSERT INTO nou_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Awarate tepo awodo edo embo nenei awa awo ingoda otatao orase awodo eove. Awodo adewa amimi mana ari utu da, embobo mi imo utu da sia mana adera. ");
INSERT INTO nou_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Embo amemi rora kiambu da jo okain edo simba adira awa rora nembogamo da jo okain edo simba adira. Edo embo amemi rora kiambu simba ise ge be ae adira awa umo rora nembodiba simba ise awa ge be adi aera. ");
INSERT INTO nou_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Edo imo busu da rora uso mina kiambu da jo okain ae adesa awa amemi iso yei rora uso mina nembogamo be awa itari simba esi? ");
INSERT INTO nou_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Edo imo embo nenei da rora simba ise jo okain ae adesa awa embo amemi rora iso topo mo itoro besi? ");
INSERT INTO nou_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Edo buro embo da mi mana embo nembogamo etoto awa kera adira ainda be awa umo nei da awa ujo ae ise edo nei awa dubo badira edo umo nei da yei saboa edo kera adira edo umo nei awa ujo ae adira. Imo mana be iji da amimi Mamo da buro embo ise edo ganu da buro embo adesa.” ");
INSERT INTO nou_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Edo Pharisee embobo Iesu ge sisira awa ingido umo ganduburisera ainda be awa ungo ganu dubo budo era awasedo. ");
INSERT INTO nou_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Edo Iesu mi ungoda yei sisira, “Ingo ingoda jawo awa embo embo da jo da awa eowo nembodiba edo ira te Mamo mi ingoda jo da ro kotewa amone gosira. Rora awa embo mi ewamei kotera awa Mamo mi kotira rora awa biae be ra. ");
INSERT INTO nou_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Edo Moses da agodari de edo binga sari embobo da ove jiwari de edo mambudo John bugusira iji ainde ro awase sisira te wasiri awa atae isira. Edo atae etiri ainde tuturo edo Mamo mi gitijigadira iji ainda binga ewamei awa sewora. Edo embo jiwae be Mamo da gitijigari yei da toradi sedo ungoda goroba berari mi edo gosera. ");
INSERT INTO nou_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Awarate Moses da agodari de binga sari embobo da ove jiwari de awawa boroko goroba de atira teta busu de utu de goroba de atera da awodo. ");
INSERT INTO nou_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Edo embo amemi uso aro dodo evetu nei jimbadira embo awa viro adira. Edo embo amemi evetu embo nei mi doadira awa jimbadira awa viro adira.” ");
INSERT INTO nou_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Embo rora jiwae embo da awa atima isira. Edo iji berari umo ombari digari ewagaewa edo isira edo umo iaviri edo isira edo indari kumbari jiwae be indido isira. ");
INSERT INTO nou_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Edo daedo iji ainde rora ae embo jawo Lazarus atima isira. Tamo matu mi uso tamo awa ato ae be ari. ");
INSERT INTO nou_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Edo umo rora embo da uso tendeba juda indari momono wosedo isira awa indadi sedo edo seuri iji berari embo mi budo rora embo da mando da bugudo isera. Edo Lazarus ainda simba aturi sino mi bugudo uso isomatu awa sandibo edo indido isera. ");
INSERT INTO nou_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Iji da rora ae embo awa betetiri asisi ewamei mi budo Abraham da yei mambusera. Edo rora embo awa daedo bebetiri gousera. ");
INSERT INTO nou_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Govetero uso asisi awa riawo euse mata awa atima ira ainda mambusira. Edo ainda atise memesi nambodiba tambuse umo yei besaun be Lazarus awa Abraham da demo da atiri gosisira. ");
INSERT INTO nou_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Awasedo umo gogo dimbudo sisira, ‘Mama Abraham na jo egae. Edo Lazarus itaso bugudo uso ingo soro da mi umo da patare. Patari saso bugudo naso avewa ari jamo jamo are ko na awa einda riawo da atena edo memesi nembodiba be tambutena.’ ");
INSERT INTO nou_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Awarate Abraham mi uso yei sisira, ‘Naso mei ruvegeose, imo busu da atise rora ewagaewa budo isesa edo Lazarus awa rora bebegae awa budo isira. Awarate boroko imo ainda memesi nembodiba tambuse ateso edo umo einda iaviri de atira. ");
INSERT INTO nou_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Awarate ingaenaso soropuda awa bengi nembodiba atira awasedo embo einda awa kekepuinya edo ainda yadi edo era te inono ae edo era. Edo embo ainda awa einda kekepuinya edo puradi edo era te purari awa inono ae ra.’ ");
INSERT INTO nou_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Edo Abraham awodo setiri edo rora jiwae embo amimi uso yei da sisira, ‘Awa be ra te Lazarus awa itigae naso mama da mando da naso nanonamendi 5 da yei mambare. ");
INSERT INTO nou_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Edo ungo mi memesi nembodiba tambari yei einda bugorase sedo awa seio Lazarus mi ungoda yei nembogo be sare. ");
INSERT INTO nou_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Setiri Abraham mi sisira, ‘Awodo aera. Moses da ge de edo binga sari embobo da ge de awa ungode daedo atira awasedo doio iso nanonamendi awa doio ge awa ingore.’ ");
INSERT INTO nou_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Setiri rora jiwae embo mi mina sisira, ‘Mama Abraham da ge awawa inono aera. Te embo da betedo edo sekago erido ungoda yei mambadira awa ungo ungoda wasiri bebegae awa dodo edo Mamo da yei wareregadera.’ ");
INSERT INTO nou_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Setiri Abraham mi sisira, ‘Ungo Moses da ge de edo binga sari embobo da ge de awa gebe ae era. Da awodo betedo sekago erido mambudo ungoda yei ge sadira awa ungo mana ge be adera.’” ");
INSERT INTO nou_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu mi uso ambojimbi da yei sisira, “Bagari neinde kainde mi ari embo wasiri bebegae adera awa iji berari bugadira. Awarate embo amemi ari bagari eiawa bugadiri embo ainda yei awa biae be ra. ");
INSERT INTO nou_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Edo embo amemi ari mei kiambu wasiri biae adira awa biae be biae ra. Edo embo awa wasiri biae awodo ae giti da embo amemi embo ainda dubo da ganuma kaingedo ewa kapuru da pigae etira embo awa wasiri ewamei ae etira. Awarate embo awa wasiri biae awa ae etira awa biae embo ainda yei atae etira. ");
INSERT INTO nou_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Ingosuka simba ise atiwo. Edo iso namendi mi wasiri biae ari gido isibeio awarate umo uso wasiri biae awa dodo wareregari re imo uso wasiri biae kotembedo doio. ");
INSERT INTO nou_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Edo iso namendi iji da amimi iso yei wasiri bebegae 7 awodo adira awarate iji berari iso yei bugudo sadira na naso wasiri biae doadena sadira awa iji berari kotembedo doio.” ");
INSERT INTO nou_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Edo Bada awodo setiri uso ambojimbi mi uso yei sisera, “Nangoda gebe ari awa goroba aera. Edo inemi eteso nangoda gebe ari awa goroba etira.” ");
INSERT INTO nou_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Edo ungo awodo setero Bada mi mina sisira, “Ingoda gebe ari awa kiambu teta ri mustard da ve kiambu inge awa ingo mi ri nembodiba einda saetewa besisi de da sokubedo sekago ewa da goveio saetewa awa ri awawa ingoda ge awa kera aetira. ");
INSERT INTO nou_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Embo da ingoda teda ainda uso agipo ari embo awa buro da ko wo sheep simba aetiri. Edo ongobo de umo nati da bugaetira awa uso gitijigari mi uso yei mo saetita burigi puio iso indari indase saetita? ");
INSERT INTO nou_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Awodo aera umo uso yei saetira naso indari sia edo iso ombari digari parara edo indari budo naso yei da puio saetira. Edo na indari indido atae ano imo iso indari indase saetira. ");
INSERT INTO nou_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Edo agipo embo uso gitijigari mi ro arase setira awa edo atae ari mo uso gitijigari mi imo awa buro embo ewamei na saetita. Awodo aera. ");
INSERT INTO nou_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Da awodo ingo ro Mamo mi awase setiri etewa awa sewo nango awa buro embobo ewagaewa seove awarate sewo nango Mamo mi buro ro orase dipapa etira awa etera awasedo nango iaviri era.” ");
INSERT INTO nou_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu Jerusalem da mambuse edo umo emboro Samaria busu de Galilee busu de ainda soropuda awodo pepeta isira. ");
INSERT INTO nou_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Edo umo nati da toradi aikambu iri edo embo 10 awodo karu leprosy bari mi umo tambusera. ");
INSERT INTO nou_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Edo ungoi besaungo petedo gogo dimbusera, “Iesu gitijigari nango jo egae.” ");
INSERT INTO nou_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Edo Iesu ungo gido ungoda yei sisira, “Priests da yei mambuwo ungoi ingoda karu atae etita ko karu atiri awa gore.” Setiri ungo mambutero ungoda tamo ando awa ewamei isira. ");
INSERT INTO nou_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Edo embo 10 ainda teda embo da uso tamo ewamei isira awa gido wareregedo engenemburisira. ");
INSERT INTO nou_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Edo umo engenembedo gogo de Mamo jasiga isira. Edo Iesu da tei da baingo dederi edo Iesu da yei da doio sisira. Edo embo engenemburisira awa busu Samaria embo Jew ae ra. ");
INSERT INTO nou_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Edo Iesu mi sisira, “Na embo 10 awodo eteno ewamei etera te embo 9 mo rawari? ");
INSERT INTO nou_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Edo embo 9 engenembari ae etera te embo nati nei embo eiawa umo umosuka Mamo jasiga adi bugira.” ");
INSERT INTO nou_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Edo embo awa awodo setiri Iesu mi uso yei sisira, “Erido mambuio. Iso gebe ari mi etiri imo ewamei etesa.” ");
INSERT INTO nou_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee embobo nenei mi Iesu da yei nganega isera, “Mamo da gitijigari iji mo nonde bugeiri?” Setero Iesu mi mina sisira, “Mamo da gitijigari iji bugari iji awa embo mi mana ungoda dombu mi gadera. ");
INSERT INTO nou_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Edo ungo mi mana sadera, ‘Giu eire edo Giu oure.’ Ainda be awa Mamo da gitijigari iji awa matu ingoda teda bugira.” ");
INSERT INTO nou_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Edo umo awodo sedo Iesu uso ambojimbi da yei sisira, “Amboda ingo awa na Mamo da mei awa embo edo ingode iji da atae etena awa dipapa be adewa awarate na awa mana einda atadena. ");
INSERT INTO nou_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Edo embo nenei mi sadera, ‘Giu umone oure edo giu umone eire,’ awarate ungoda ge awa ambo ambo eove. ");
INSERT INTO nou_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Na God da mei embo isena awa bugari awa teta birigi utu da usasa de jaririgedo ira da awodo ra. Edo utu yei berari da awa janibadira. Edo awodo adira awasedo ingo mi naso bugari awa isaga gadewa. ");
INSERT INTO nou_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Awarate giti awa na memesi nembodiba tambadena edo embo boroko atera amimi na ujo ae adera. ");
INSERT INTO nou_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Edo na engenembadena iji ainde embo awa atadera teta embo Noah da iji de atisera da awodo atadera. ");
INSERT INTO nou_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Umo nembodiba bugae atisira ainde embo de evetu de indido kumbudo ise mina jimba ise edo jimbari da adi sari sise edo Mamo awa kotae be isera. Edo ungo awodo atero Noah umo nga nembodiba da toriri edo umo nembodiba bojetiri edo embo berari ponda awa indido ambujegurisera. ");
INSERT INTO nou_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Edo Lot atisira iji ainde awa embo atima isera awa embo Noah da iji de atima isera da awodo atima isera. Edo ungo daedo indido kumbudo ise ori garori ise buro da ve gogovegurise edo mando ise awa ungo Mamo kotae edo isera. ");
INSERT INTO nou_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Edo Lot Sodom nati doturisira iji ainde aviga vevera de edo riawo teta ga mi wosarago edo embo berari awa evetiri bebetigurisera. ");
INSERT INTO nou_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Edo embo Mamo kotae ari teta embomei amimi isera da awodo iriroro iji ainde na Mamo da Mei bugudo embo isena awa engenembadena. ");
INSERT INTO nou_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Embo ave iji ainde uso mando sa beraga de ainda gaga da anumbedo atadira awa mana wosedo uso mando jo da torido uso rora berari awa badira. Da awodo embo ave uso buro da buro ise atadira awa mana uso mando da engenembadira. ");
INSERT INTO nou_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Edo Lot da aro da ro isiri awa ruvegeove. ");
INSERT INTO nou_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Embo amemi uso wasiri awa busu da ainda soregadi adira awa uso wasiri awa jajovegadira awarate embo amemi na awasedo uso wasiri jajovegadira awa wasiri ewamei tambadira. ");
INSERT INTO nou_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Edo na ingoda yei sena naso bugari iji de embo etoto besi dada mando dada ewadera. Edo nanemi embo da awa burise embo nei awa doadena. ");
INSERT INTO nou_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Edo embo evetu etoto awa ba gia ise atadera. Edo nanemi da awa burise da awa doadena. ");
INSERT INTO nou_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Embo etoto awa buro da buro iriroro nanemi embo da awa burise da awa doadena.” ");
INSERT INTO nou_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Setiri uso ambojimbi mi uso yei nganega isera, “Bada emomo rawainda bugeiri?” Setero Iesu ge ainda be awa unjugurise mina sisira, “Tamo betari rawainda pasido atira ainda ambemoka mane awa dada adera.” ");
INSERT INTO nou_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu mi ungoda yei inia da kiki eiawa sedo ungo atopatari ungo dubo neinde kainde eorase sisira iji berari Mamo da yei sedo gorase. ");
INSERT INTO nou_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Umo kiki eiawa dirisira, “Kasari embo da awa umo Mamo oju ae edo embo nati da atima isera awa sapo ae. ");
INSERT INTO nou_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Edo evetu rori da awa nati ainda atima isira amimi iji berari uso yei bugudo gegeta edo isira edo sedo isira, ‘Na kondade egae naso gitopo embomei mi naso yei biae era.’ ");
INSERT INTO nou_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Edo iji ribori be kasari embo awa evetu awa kondade ari ujo ae edo isira te amboda umo kotisira, ‘Na Mamo oju ae edo ena edo na embo sapo ae edo ena awarate embo mi umo bekuba adera kasari yei da awa na evetu eiawa kondade adena ko umo iji berari naso yei bugudo edo iji berari na euri jaredo ena. ");
INSERT INTO nou_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Edo na evetu eiawa kondade ae adena awa umo iji berari bugudo ira amimi ari na begogo tambadena.’” ");
INSERT INTO nou_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Edo Bada inia kiki eiawa sedo ge ainda be awa sisira, “Embo biae mi ro isira awa kotewo. ");
INSERT INTO nou_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mamo da embo topo awa wasiri biae de dari gaiari de tambudo Mamo da yei tumba de iji de ungo kondade arase gegeta edo era mo Mamo mo ungo mo kondade eita mo adi aeri? Edo umo burigi bugudo ungo kondade eita? ");
INSERT INTO nou_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na ingoda yei sena gebe umo ungo burigi be kondade edo ungo soregadira. Awarate na Mamo da mei bugudo embo isena awa busu da engenembedo bugudo mo embo ge be ari de mi Mamo da yei siriroro tambeni ta?” ");
INSERT INTO nou_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","10","Iesu embo ungo awa ewamei awodo kotise embo nenei awa bebegae kotedo isera ainda yei inia kiki eiawa sisira, “Embo etoto nei awa Pharisee edo nei awa tax bari embo mi Jew embobo da tumondebain ari oro da Mamo da yei ge sadi mambusera. ");
INSERT INTO nou_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Edo Pharisee embo awa umo umosuka derido Mamo da yei sisira, ‘Mamo na imo ategurena ainda be awa na wasiri biae ae embo nenei mi edo era awodo ae. Edo na embo nenei da yei ge busedo rora bae edo na bengono ae edo na wasiri bebegae ae edo na ari bebegae teta tax bari embo emimi edo ira awodo ae. ");
INSERT INTO nou_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Edo pura da da iji etoto na neta edo ena edo na rora berari budo ena awa katabedo edo dombu 10 awodo itido ena edo na dombu da iso yei itido ena.’ ");
INSERT INTO nou_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Awarate tax bari embo awa besaungo derido edo diti utu da ae. Edo umo uso oka da ingo mi dorise sisira, ‘Mamo na jo egae na wasiri biae embo.’” ");
INSERT INTO nou_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Edo Iesu inia kiki awa sedo sisira, “Na ingoda yei sena Mamo mi sisira tax bari embo awa uso mando da mambusira edo umo awa Mamo da dombu da awa ewamei be ra te embo nei awa aera. Edo Mamo mi ge awa sisira ainda be awa embo amemi uso jawo topo awa jigari eradira awa Mamo mi umo awa itari wosadira awarate embo amemi umo umosuka itari wosadira awa Mamo mi embo ainda jawo awa jigari vitadira.” ");
INSERT INTO nou_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Embo nenei mi ungoda kinapeina awa budo Iesu mi uso ingo ungoda beo da itido ewamei arase bugusera. Awarate ambojimbi awa gido dipapa ae isera edo ungoda yei sisera awodo eorase. ");
INSERT INTO nou_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Awarate Iesu kinapeina jawo setiri uso yei bugero embo da yei sisira, “Kinapeina beitigeove ta dowo naso yei purore ko embo ave awa teta kinapeina memeia eiedo amimi Mamo da gitijigari yei da toradera. ");
INSERT INTO nou_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Edo ruvegeove embo ave teta mei kiambu mi ge be edo ira da awa adira awa Mamo da gitijigari yei da toradira.” ");
INSERT INTO nou_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iji da Jew embomei da gitijigari mi Iesu da yei nganega isira, “Atopatari ewamei na rawodo edo wasiri natopo atari beni?” ");
INSERT INTO nou_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Setiri Iesu mi uso yei sisira, “Imo ro edo na embo ewamei sesi? Mamo umo umosuka awa ewamei ra. ");
INSERT INTO nou_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Imo Mamo da agodari ge awa imo gari ra. Amone eire, viro eose edo embo nei daso betore edo bengono eose edo gebusose edo iso ai de iso mamo de awa sapo eio.” ");
INSERT INTO nou_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Setiri embo amimi mina sisira, “Na mei kiambu da tuturo edo bugudo boroko da awa agodari berari eiawa na kera emona.” ");
INSERT INTO nou_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Edo Iesu ge eiawa ingido uso yei sisira, “Rora nei da awa eio. Amone eire. Iso rora berari awa ori edo ganu awa rora ae embobo da itio. Awodo aso awa rora ewagaewa jiwae utu da imo awasedo atadira. Awodo edo awa puio na ambo ambo ase.” ");
INSERT INTO nou_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Awarate embo awa ge awa ingido dubo vevera tambusira ko umo awa rora jiwae embo awasedo. ");
INSERT INTO nou_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Edo Iesu umo dubo vevera iri gido sisira, “Rora jiwae embobo mi Mamo da gitijigari yei da torari awa okain be ra. ");
INSERT INTO nou_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Edo wo nembodiba camel mi ningu toda torari awa okain be ra te rora jiwae embo mi Mamo da gitijigari yei da torari awa okain be okain ra.” ");
INSERT INTO nou_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Edo embo ge awa ingisera amimi Iesu da yei nganega isera, “Amomo gebe ta embo amemi wasiri natopo atari tambeiri?” ");
INSERT INTO nou_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Setero Iesu mi mina sisira, “Ro embo mi ari sago ae awa Mamo mi adira.” ");
INSERT INTO nou_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Edo Peter mi sisira, “Gi. Nango nangoda nati da edo nangoda rora berari dodo imo ambo ambo era.” ");
INSERT INTO nou_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Setiri Iesu mi ungoda yei sisira, “Gebe na ingoda yei sena embo amemi Mamo da gitijigari iji da binga awa sadi sedo uso nati ta aro ta nanonamendi ta ruaimomo ta aimamono ta kinapeina ta awa doadira embo awa umo busu da atise ainda mina awa nembodiba badira. ");
INSERT INTO nou_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Edo amboda umo wasiri natopo atari badira.” ");
INSERT INTO nou_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu uso ambojimbi jawo setiri ungae da dada etero ungoda yei sisira, “Giwo ingodena Jerusalem nati da mambadera ainda ge berari binga sari embobo mi na Mamo da mei embo isena ainda jawo da gaisera awa be adira. ");
INSERT INTO nou_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Edo embo mi na awa embo Jew ae ainda ingo da itadera. Edo embomei emimi na gandubedo edo naso yei wasiri biae edo naso tamo da kosiwa adera. ");
INSERT INTO nou_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Edo ungo mi na vejadera edo na doro betadena awarate iji tamonde atae ari ainda amboda na sekago wasiri de eradena.” ");
INSERT INTO nou_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Edo Iesu umo awodo setiri uso ambojimbi umo ro sira ainda be awa gadi jarisera. Edo uso ge da be awa ungoda yei isage ae isira. ");
INSERT INTO nou_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Edo Iesu Jericho nati aikambu bugutiri embo da diti guba ari mi emboro demo da anumbedo atise benunu sise atisira. ");
INSERT INTO nou_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Edo embo jiwae be umo derigurero javi ingido nganega isira, “Ungo ro eri?” ");
INSERT INTO nou_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Setiri ungoi uso yei sisera, “Iesu Nazareth nati embo awa mambutira.” ");
INSERT INTO nou_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Setero umo gogo dimbudo sisira, Iesu David da orobe na jo egae.” ");
INSERT INTO nou_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Edo umo awodo setiri embo giti da pepeta isera amimi umo isiburise sisera ge do. Awarate umo sekago gogo dimbudo sisira, “David da mei na jo egae.” ");
INSERT INTO nou_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Setiri Iesu ainda petedo embo da yei embo diti guba ari awa uso yei budo purorase sisira. ");
INSERT INTO nou_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Edo embo diti guba ari awa Iesu da yei asusubedo bugiri uso yei nganega isira, “Na iso yei ro anase dipapa esi?” Setiri embo amimi mina sisira, “Bada na sekago yei gari dipapa ena.” ");
INSERT INTO nou_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Setiri Iesu mi uso yei sisira, “Awara iso ge be ari mi etiri ewamei etesa awasedo sekago yei gio.” ");
INSERT INTO nou_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Setiri burigi be embo awa sekago yei gosisira. Edo yei gosise Iesu ambo ambo ise edo umo Mamo jasiga isira. Edo embo jiwae be ro isira awa gido ungoi berari Mamo jasiga isera. ");
INSERT INTO nou_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu Jericho nati da torido edo nati soropu da awodo sembusira edo umo pepeta isira. ");
INSERT INTO nou_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Edo nati ainda embo da tax bari embomei da simba ari embo jawo Zacchaeus awa atima isira. Umo awa rora jiwae embo. ");
INSERT INTO nou_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Edo umo awa embo tupokain awasedo Iesu gadi jarisira ainda be awa embo jiwae be mi uso diti awa gajisera. ");
INSERT INTO nou_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Awasedo umo giti giti sumbudo embo jiwae awa dodo mambudo kotisira Iesu eiedo bugadi ta rora. Kotedo umo ri inda vivitisira Iesu gadi sedo. ");
INSERT INTO nou_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Edo Iesu ainda bugudo diti inda edo Zacchaeus da yei sisira, “Zacchaeus burigi wose ko na boroko awa iso mando da esega adena.” ");
INSERT INTO nou_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Setiri Zacchaeus burigi wosedo umo iaviri nembodiba be ise edo Iesu budo uso mando da mambusira. ");
INSERT INTO nou_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Edo embo berari ro isira awa gido kotari bebegae isera edo Iesu da jawo da kiki dirise sisera, “Embo eiawa embo wasiri biae embo awa esega adi mambira.” ");
INSERT INTO nou_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Awarate Zacchaeus mi erido Bada da yei sisira, “Bada naso ge ingio. Boroko naso kotari awa na naso rora berari awa budo diti etoto itadena. Edo na rora diti da awa budo rora ae embomei ainda itadena. Edo na embo nenei da yei rora da badi gebusena awa sekago uso mina awa derigedo ajigari 4 awodo itadena.” ");
INSERT INTO nou_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Setiri Iesu mi uso yei sisira “Boroko Mamo imo de iso orobe de iso mando da daedo atewosa awa soregetira. Edo imo awa daedo Abraham da orobe ra. ");
INSERT INTO nou_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ko na Mamo da mei bugudo embo isena awa bugudo embo munenegari awa eura edo soregadi bugusena.” ");
INSERT INTO nou_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Edo embo ainda atise ingero Iesu ungoda yei inia kiki nei sisira. Iesu umo Jerusalem nati aikambu bugutiri edo ungoi kotisera Mamo da gitijigari iji awa aikambu etira awa kotisera. ");
INSERT INTO nou_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Awasedo Iesu ungoda yei kiki eiawa sisira, “Embo nembodiba da awa umo busu nei besaun ainda mambudo umo gitijigari da goroba awa budo edo uso busu topo da bugadi sedo sia isira. ");
INSERT INTO nou_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Edo umo mambae giti da uso buro embobo 10 awa jawo setiri uso yei bugero embo dada da gano kopa ari da awodo berari ititisira. Edo umo ganu awa itido ungoda yei sisira, ‘Gano emimi buro edo gano nenei buwo. Edo amboda na engenembane.’ ");
INSERT INTO nou_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Awarate embo uso busu da atima isera awa umo ujo ae edo isera awasedo ungoi umo esega adi ira busu ainde binga sari embobo awa itero mambusera. Mambudo sisera, ‘Nango embo emimi nango gitijigurase ujo ae era.’ ");
INSERT INTO nou_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Awarate embo nembodiba awa ainda atise goroba ari budo edo gitijigari embo isira. Edo uso busu da engenembedo edo buro embobo da yei gano ititisira awa jawo setiri uso yei bugusera. Edo bugero embo da da da yei sisira, ‘Gano iso yei ititisena amimi buro edo gano roinge burasi?’ ");
INSERT INTO nou_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Edo buro embo da awa bugudo sisira, ‘Gitijigari inemi gano kopa ari da ititisesa amimi na buro edo gano kopa ari 10 burisena.’ ");
INSERT INTO nou_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Setiri edo gitijigari mi uso yei sisira, ‘Imo ewamei etesa. Imo awa buro embo ewamei. Imo buro kiambu awa simba ewamei etesa awasedo nanemi imo awa itano nati 10 awodo awa gitijigadesa.’ ");
INSERT INTO nou_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Edo buro embo nei mi bugudo sisira, ‘Gitijigari gano kopa ari da ititisesa amimi na buro edo gano kopa ari 5 nei burana.’ ");
INSERT INTO nou_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Setiri gitijigari mi uso yei sisira, ‘Nanemi imo awa itano nati ingo da awa gitijigadesa.’ ");
INSERT INTO nou_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Setiri edo buro embo nei mi bugudo sisira, ‘Gitijigari iso gano kopa ari da ititisesa amone eire. Bo mi kera edo digido unjugurisena awasedo atevira eire. ");
INSERT INTO nou_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na imo oju isena ko imo awa embo okain awasedo. Edo embo nenei awa iso buro era awasedo imo uredo govedo ae awarate imo indari jiwae budo esa.’ ");
INSERT INTO nou_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Setiri gitijigari mi uso yei sisira, ‘Imo awa buro embo biae. Edo ge inemi setesa naso yei awa nanemi iso yei sekago sadena awa amimi imo bekuba adira. Imo gosesa na awa embo okain edo imo gosesa embo nenei na awasedo buro edo era awasedo na buro jegedo gowae rate na indari jiwae budo ena. ");
INSERT INTO nou_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Awasedo imo ro edo naso gano awa gano atari yei da itaso ataresae isesi? Imo awodo aso na engenembedo bugudo edo gano bajari banesae isesi?’ ");
INSERT INTO nou_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Sedo embo derido atisera ainda yei sisira, ‘Gano kopa ari da awa dodo budo edo buro embo gano kopa ari 10 de ainda itiwo.’ ");
INSERT INTO nou_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Setiri ungoi uso yei sisera, ‘Gitijigari umo matu gano kopa ari 10 betira.’ ");
INSERT INTO nou_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Setero umo mina sisira, ‘Nanemi ingoda yei sena embo amemi rora jiwae budo jingama ari ewamei da adira awa sekago rora nenei badira te embo amemi rora enumbae budo jingama ae adira awa embo nenei mi rora enumbae awa dodo badera. ");
INSERT INTO nou_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Edo naso gitopo embomei awa ungo nanemi ungo gitijigonase ujo ae isera awa budo bugudo naso joda dewo bebetegore.’” ");
INSERT INTO nou_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Edo Iesu inia kiki awa ungoda yei sedo giti giti mambudo Jerusalem nati aikambu bugusira. ");
INSERT INTO nou_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Edo bugudo nati Bethphage de Bethany de awa aikambu edo Olive doriri da edo umo uso ambojimbi etoto giti itari mamborase edo ungoda yei sisira, ");
INSERT INTO nou_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mambuwo nati ingoda dombu da atira ainda. Edo ingo nati da bugudo wo donkey seka awa digari atirari tambadewa. Embo da amemi wo ainda tamo da matu anumbae. Edo wujegedo wo awa budo einda buguwo. ");
INSERT INTO nou_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Edo embo da amemi nganega adira, ro edo ingo wo eiawa wujegurevi awa soro embo ainda sewo, Bada wo eiawa buro da dipapa ira sewo.” ");
INSERT INTO nou_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Setiri ambojimbi etoto awa mambudo wo donkey da mei Iesu mi ro sisira da awodo awa tambusera. ");
INSERT INTO nou_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Edo ungo etoto wo awa wujegurero edo embobo wo ainda totopo mi ungoda yei sisera, “Ingo ro edo wo awa wujegurevi?” ");
INSERT INTO nou_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Setero ambojimbi etoto mi mina sisera, “Bada mi buro adi wo eiawa dipapa ira.” ");
INSERT INTO nou_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sedo edo ungoi wo awa budo Iesu da yei mambusera. Mambero budo ungoda ombari ribori awa wo da gun tamo ainda itido ungoi Iesu kondade etero vivitisira. ");
INSERT INTO nou_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Edo Iesu wo da tamo da anumbedo mambutiri embo mi ungoda ombari ribori mi emboro da besi dirarago isera. ");
INSERT INTO nou_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Edo ungo Olive doriri da demo da wowosise edo Jerusalem nati aikambu ise edo ambojimbi Mamo ategurise edo jasiga isera ainda be awa ungo matu Iesu mi wasiri goroba de neinde kainde etiri getera awasedo. ");
INSERT INTO nou_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Edo ungo Mamo jasiga ise sisera, “Mamo mi gitijigari Mamo da jawo da bugutira awa ewamei are. Edo embo berari de anela utu da ainda awa iaviri ore. Edo ingode Mamo jasiga ore.” ");
INSERT INTO nou_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Edo Pharisee embo nenei embo da teda amimi tini gambari mi Iesu da yei sisera, “Atopatari se iso ambojimbi ge dore.” ");
INSERT INTO nou_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Setero Iesu mi sisira, “Nanemi ingoda yei sena ungo ge doadera awa ganuma ge sadi tuturo adera.” ");
INSERT INTO nou_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu Jerusalem nati aikambu ise gido umo embo embo ji sisira. ");
INSERT INTO nou_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ji sise sisira, “Dubo ewamei ari da emboro awa ingoda yei bugira te ingo mi ujo ae etewa awasedo ingo awa munenegetewa. ");
INSERT INTO nou_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Edo iji bugadira ainde ingoda gitopo mi ingoda nati awa jiroroka adera. Edo jiroroka edo ingoda emboro awa gajadera edo ingo nati dodo mambari sago ae adewa. ");
INSERT INTO nou_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Edo ingoda nati da torido rovi ravi berari usibesi ise edo ingo de ingoda kinapeina de awa doro betadera. Edo ingoda mando ganuma mi berari ititisewa awa ingoda gitopo mi berari usibesi adera. Edo ungoi ganuma berari misadera. Edo berari awa adira ainda be awa Mamo ingo soregadi bugira te ingo umo ujo ae etewa.” ");
INSERT INTO nou_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Edo Iesu Jew embomei da tumondebain ari oro da torido embo berari ori garori ise atisera awa ondetiri bugusera. ");
INSERT INTO nou_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Edo umo ungo ondise ungoda yei sisira, “Jiwari mi sira, naso mando awa benunu sari yei ra te ingo mi etewo bengono embobo da mando awodo etira. ");
INSERT INTO nou_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Edo iji jaige Jew embobo da tumondebain ari oro da Iesu embo atopatido isira. Edo priest gitijijigegari de agodari da atopapotegari de embobo da gitijijigegari de awa emboro eura edo Iesu doro betarase isera. ");
INSERT INTO nou_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Te ungoi emboro tambae isera ainda be awa embo berari Iesu mi ge ro sira berari awa gadi dipapa edo uso yei dengoro era awasedo. ");
INSERT INTO nou_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iji da Iesu Jew embobo da tumondebain ari oro da atopapotise edo binga ewamei awa embo da yei sise atiri priest gitijijigegari de agodari da atopapotegari de Jew embo nembogamo de mi uso yei bugusera. ");
INSERT INTO nou_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bugudo uso yei sisera, “Se gore imo ro awasedo wasiri eiawa esi? Edo iso yei wasiri eiawa asase goroba mo amemi ititisiri?” ");
INSERT INTO nou_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Setero Iesu ungoda ge mina sisira, “Na daedo ingoda yei sedo gari itadi kotena. ");
INSERT INTO nou_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Seu gane embo amemi John da yei goroba embo umo mi ari ewamei arase ititisiri? Embo nei mi goroba awa ititisita mo Mamo mi uso yei goroba ititisiri?” ");
INSERT INTO nou_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Setiri ungo ungosuka besora mina ara isera edo sisera, “Ingode ro seri? Ingode Mamo mi John da goroba awa ititisira sadera awa Iesu mi ingodenaso yei sadira awasedo ingo ro edo John ge be ae isevi sadira? ");
INSERT INTO nou_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te ingode embo mi goroba John da ititisera sadera awa embo jiwae be ingodena awa ganuma mi doro betadera ainda be awa ungo kotedo era John awa binga sari embo be ra.” ");
INSERT INTO nou_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Edo ungo ge awa mina sara edo Iesu da yei mina sisera, “Nango John da goroba amemi ititisiri awa nango gaera.” ");
INSERT INTO nou_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Setero Iesu mi ungoda yei sisira, “Ingo awa sewa awasedo na mana amemi naso goroba itiri wasiri eiawa eni awa mana sadena.” ");
INSERT INTO nou_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu inia kiki eiawa embo da yei sisira, “Embo da mi ve jawo grape awa uso buro da gousira. Govedo setiri embo nenei mi bugudo simba ero, umo busu nei da mambudo iji ribori be atisira. ");
INSERT INTO nou_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Edo amboda be edo sari etiri edo buro topo awa uso tega awa badi sedo uso buro embo awa itiri buro simba edo isira embo ainda yei mambusira. Awarate mambiri buro simba ari embo mi embo awa dedo gaedo edo edo uso yei nei ro itae dotiri sekago buro topo da yei engenemburisira. ");
INSERT INTO nou_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Awasedo buro topo awa sekago buro embo nei itiri mambusira te buro simba ari embo mi buro embo awa ari da awodo dedo gaedo edo uso yei biae edo edo nei ro itae bae sekago itero engenemburisira. ");
INSERT INTO nou_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Awasedo buro topo awa buro embo nei sekago itiri mambusera te buro simba ari embo mi uso yei biae be edo budo warawara etero edo buro pon da wowosisira. ");
INSERT INTO nou_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Edo ungo awodo etero buro topo mi sisira, ‘Na ro eni? Na naso dubo bari mei da awa itano mambadira. Edo itano mambadira awa ungoi umo sapo adera.’ ");
INSERT INTO nou_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Awarate buro simba ari embobo mei awa gido ungo ungosuka sisera, ‘Eiawa buro topo da mei ra. Amboda umo awa buro einda topo adira awasedo ingode doro betari ingodena awa buro einda topo ore.’ ");
INSERT INTO nou_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sedo mei awa buro ponda warawara etero wosetiri detero bebetisira.” Edo Iesu inia kiki awa sedo embo da yei nganega isira, “Buro topo awa embomei ainda yei ro eiri? ");
INSERT INTO nou_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Umo bugudo ungo dari bebetegadera. Edo dari bebetegoro edo buro awa budo embo nenei da yei itari simba adera.” Edo embobo ge awa ingido sisera, “Awodo awa doaso ijegeure.” ");
INSERT INTO nou_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Setero Iesu ungo ditini ise sisira, “Ingo awodo kotadewa awa jiwari einda be awa rori? ‘Ganuma mando itari embomei mi ujo ae isera awa teta mando da tutuvi seka derari inge etira.’ ");
INSERT INTO nou_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Edo embo amemi ganuma ainda tamo da duradera awa bejedo pisoko soina adera. Edo embo ave ganuma emimi uso tamo da wosadira awa jasedo memeia adira.” ");
INSERT INTO nou_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Edo agodari da atopapotegari de priest gitijijigegari de gosisera Iesu umo inia kiki awa sira awa sise awa umo ungo bekuba ira awasedo ungo Iesu bundadi isera te ungo embo oju edo gido ae doturisera. ");
INSERT INTO nou_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Awasedo agodari da atopapotegari de priest gitijijigegari de iji ewamei budo Iesu bundadi simba isera. Edo ungoi embo nenei Iesu da yei itero mambusera. Edo embomei eiawa teta embo ewagaewa inge isera te ungoi Iesu Rome embomei da gitijigari da yei itari dipapa edo gido ge neinde kainde sedo umo wao adi jarisera. ");
INSERT INTO nou_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Edo embomei emimi Iesu da yei sisera. “Atopatari nango gari imo ro sesa edo atopapotesa awa ewamei. Edo imo embo berari awa da awodo simba edo esa. Edo imo Mamo da ge be awa embo nembogambo de embo memeia de da yei atopatido esa. ");
INSERT INTO nou_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Edo nango se gore, ingode Jew embobo awa Rome embobo gitijigari nembodiba da yei takesi itorase ingodenaso agodari mi awara sita mo sae ri?” ");
INSERT INTO nou_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Awarate Iesu umo ungoda sedo gari emboro nei da sera awa gido ungoda yei sisira, ");
INSERT INTO nou_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ganu da eu gane. Edo ganu einda tamo da mo amenda dombu da atiti de edo jawo de ri?” Setiri ungoi mina sisera, “Amone Caesar da atiti de edo jawo de ra.” ");
INSERT INTO nou_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Setero Iesu mi sisira. “Awara ro Caesar da awa uso yei itiwo edo ro Mamo da ri awa uso yei itiwo.” ");
INSERT INTO nou_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Setiri ungo uso ge mina sisira awa gido kove be isera. Edo ungo ainda embo berari da diti da ungoda nganega emboro neinde kainde edo wao ari sago ae isera. ");
INSERT INTO nou_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadducee embobo nenei ungo embo betedo sekago wasiri de eradi ae atopatido isera amimi Iesu da yei bugudo nganega isera, ");
INSERT INTO nou_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Atopatari Moses mi agodari eiawa nango embo gaisira, ‘Embo da betedo aro doadira edo aro awa kinapeina bae edo betari embo ainda aro rori awa uso namendi mi jimbadira. Awodo jimbudo awa ungoi betari embo awasedo kinapeina itadera.’ ");
INSERT INTO nou_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Boroko nangoda ge ingio. Nanonamendi 7 atima isera. Edo namendi bego awa jimbusira te uso aro awa ero ra. ");
INSERT INTO nou_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Edo namendi awa betetiri uso namendi nei mi evetu awa sekago jimbusira te sekago umo kinapeina bae. ");
INSERT INTO nou_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Edo namendi awa bebetisira edo namendi nei mi evetu awa jimbusira te sekago umo kinapeina bae. Edo namendi awa bebetisira. Edo nanonamendi nenei awa dada evetu awa jimbusera edo ungo dada bebetegurisera te evetu awa kinapeina bae. ");
INSERT INTO nou_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Edo nanonamendi berari awa bebetegetero edo ambo be amboda awa evetu awa daedo bebetisira. ");
INSERT INTO nou_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Edo bebetegari embobo sekago wasiri de eradera ainde mo evetu amomo amenda aro ri?” ");
INSERT INTO nou_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Setero Iesu mi mina sisira, “Embo de evetu de boroko busu da atera awa jimbera. ");
INSERT INTO nou_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Awarate Mamo mi embo ewagaewa awa wasiri de sekago erorase sira awa embomei awa wasiri natopo budo awa ungo sekago jimbadi aera. ");
INSERT INTO nou_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ungo awa teta asisi ewagaewa betae atima era da awodo ra. Ungo awa Mamo da kinapeina. Edo ungo betedo wasiri de sekago eradera. ");
INSERT INTO nou_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Edo ro Moses mi sisira awa embo betedo sekago wasiri de eradera ainda ge be awa sisira. Edo Moses mi ri ambae euse atisira ainda ge gaisira ainda sisira, ‘Mamo mi sisira na awa Abraham da Mamo edo Isaac da Mamo edo Jacob da Mamo.’ ");
INSERT INTO nou_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Edo uso ge da be awa eire. Embo ingodena betari kotedo era amone betae ra Mamo mi sira awa ungo awa wasiri de atera awasedo umo awa embo wasiri de da Mamo rate embo betari da Mamo ae ra.” ");
INSERT INTO nou_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Setiri agodari da atopapotegari mi sisera, “Atopatari imo mina sari ewamei setesa.” ");
INSERT INTO nou_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Setero edo ungoda nganega ari sangove isira ainda be awa ungo sekago uso yei nganega ari oju isera awasedo. ");
INSERT INTO nou_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu umo averi awa ari kotorase dipapa edo ungoda yei sisira, “Ro edo ungomi sedo eri soregari embo Mamo mi sisira awa bugadira awa David da orobe ri? ");
INSERT INTO nou_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ingo ro David umo umosuka Ya da gaisira awa ajigedo awa ainda be awa tambadewa. David mi sisira, ‘Mamo mi naso Bada da yei sisira naso ingo be da einda anumbedo atio. ");
INSERT INTO nou_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Atiroso nanemi iso gitopo berari awa budo iso diti da bugano inemi ungo gitijigase.’ ");
INSERT INTO nou_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Edo David awodo sedo Keriso awa Bada sisira mo rawodo edo Keriso mo David da orobe eiri?” ");
INSERT INTO nou_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Edo embo berari Iesu da ge awa ingise atero Iesu uso ambojimbi da yei sisira, ");
INSERT INTO nou_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Agodari da atopapotegari awa diti jimba ewo. Ungo embo mi saboa ise atega orase dipapa edo era awasedo ori garori ari yei da edo ungo ombari digari riribori edo pepeta edo era. ");
INSERT INTO nou_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Edo ungo bondo da mambudo era edo Jew embobo da dada ari oro da mambudo era awa ungo embo nembogamo da anumbari da anumbedo era. Edo embo evetu rorigarori da rora badi sedo gebusedo era. Edo ungo ungoda buria awa apuregadi sedo ungo Mamo da yei ge iji ribori be sarago edo era. Edo embo nenei wasiri bebegae edo era ainda riroga awa Mamo mi itadira te embo mei einda riroga awa Mamo mi nembodiba be nembodiba itadira.” ");
INSERT INTO nou_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu Jew embomei da tumondebain ari oro da atise diti pige page edo embo rora jiwae embobo ungo ungoda ganu awa kando ititisera Jew embobo da tumondebain ari oro da ganu bari tewo da ititero gosisira. ");
INSERT INTO nou_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Edo umo daedo evetu rori rora atae awa umo ganu memeia etoto awa tewo da ititiri gido sisira, ");
INSERT INTO nou_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Na ingoda yei sena evetu rori rora ae uso kando emimi embo nenei da ganu kando itera awa derigetira. ");
INSERT INTO nou_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Edo embo nenei ungoda yei jiwae atira te ungo kiambu itera te evetu rora ae evetu rori eiawa uso ganu berari awa itira. Edo berari itira edo umo indari ori edo indari ganu inono ae etira awasedo uso kando mi embo berari da kando awa derigetira.” ");
INSERT INTO nou_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Embo nenei mi Jew embobo da tumondebain ari oro da ge sisera gari ewamei be ira ainda be awa embo mi Mamo da yei kando ititisera amimi rora ewagaewa mi ganuma awa giro isera. ");
INSERT INTO nou_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Edo ungo ge awodo sero Iesu mi sisira, “Dowo nanemi ingo ro gosewa ainda ge be awa sano gave. Amboda iji bugutira ainde ganuma da nei da tamo da nei da tamo da mana atadera. Ungoi doro berari duradera edo usibesi adira.” ");
INSERT INTO nou_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iesu awodo setiri uso ambojimbi mi sisera, “Rora emomo nanjigo eiri? Edo ro giti bugudo ari nango iji aikambu etira awa geri?” ");
INSERT INTO nou_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Setero Iesu mi mina sisira, “Gido gogo ewo doawo ungo mi ingo gandubeore. Embo jiwae be mi naso jawo da bugarago edo sadera, ‘Namone keriso ra.’ Edo daedo ungomi sadera, ‘Iji re bugira.’ Awarate ungo ambo ambo eove. ");
INSERT INTO nou_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Edo ingo binga biae embo mina dara era awa ingadewa edo binga biae embo mi gitijijigegari awa itoro wosarase jarera awa ingise awa oju eove. Edo wasiri awodo awa giti adira te busu da sangove awa bugae ra.” ");
INSERT INTO nou_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Edo Iesu ge awodo sedo ungoda yei sisira, “Embo yei nei da amimi embo yei nei da ainde da mina dara adera. Edo gitijigari nei da embobo mi gitijigari nei da embo de mina dara adera. ");
INSERT INTO nou_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Edo didira de baimana de edo karu nembogamo de bugadira. Edo daedo utu da ari neinde kainde de wasiri neinde kainde de embo mi matu gae awa adira. Edo embo mi rora eiawa irirari gido awa oju adera. ");
INSERT INTO nou_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Awarate roviravi eiawa ae atirari gitida awa ungo mi imo awa sandido dedo gaedo adera. Edo ungomi imo budo Jew embomei da dada ari yei da mambudo edo gitijijigegari da dombu da imo bekuba adera. Edo ungoi imo bekuba edo atae oro gitijijigegari mi imo gajari oro da itadera. Edo ungomi daedo imo budo busu da gitijijigegari da yei edo nati da gitijijigegari da yei mambadera. Edo rora berari eiawa adera ainda be awa imo na gebe edo esa awasedo. ");
INSERT INTO nou_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Edo rora eiawa iso yei adira edo iji ainde awa binga ewamei awa sadesa. ");
INSERT INTO nou_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Edo dubo vevera eove ingo rawodo edo ungoda bekuba era ainda mina awa sadi evi ko iji awa bugadira ainde awa nanemi ro sadevi awa sano sadewa. Edo nanemi ingoda yei jiro gari itano edo ingoda gitopo mi ingoda ge da mina awa mana sadera. ");
INSERT INTO nou_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Edo aimamo de nanonamendi de orobe de edo otatao de mi ingo awa budo ingoda gitopo da ingo da itadera. Edo ungoi awodo oro ingoda gitopo mi ingo nenei awa doro betadewa. ");
INSERT INTO nou_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Edo embo berari mi ingo ujo ae adera ko ingo awa naso topo edo naso ambojimbi awasedo. ");
INSERT INTO nou_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Awarate ingoda kopiri tu da awa mana munenegadira. ");
INSERT INTO nou_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Goroba edo atiwo ingoda asisi awa soregadi.” ");
INSERT INTO nou_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Iesu mi sisira, “Amboda isoro embobo jiwae mi Jerusalem nati awa jiroroka adera edo iji ainde awa ingo mi gadewa nati usibesi ari iji awa bugira. ");
INSERT INTO nou_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Edo iji ainde embo Judea busu da atima era awa sumbudo dodo doriri da mambore. Edo embo Jerusalem nati nembodiba da joda atima era awa dodo mambore. Edo embo ave nati nembodiba da gaia da atima era awa nati nembodiba da torore. ");
INSERT INTO nou_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Na ingoda yei eiawa sena ainda be awa iji awawa riroga bari iji ra. Riroga bari iji awa bugadira edo iji ainde awa ro jiwari kotopu mi sira awa be adira. ");
INSERT INTO nou_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","O embomei iji ainde evetu gasou de edo aimono ave kinapeina memeia simba eri awa memesi nembodiba tambadera ainda be awa God umo busu einda embobo de tini gambari ira awasedo memesi nembodiba awa bugadira. ");
INSERT INTO nou_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Edo embo bebegae mi kasiwo mi busu einda embo nenei awa dadera. Edo embo bebegae nenei mi busu einda embo nenei awa bundedo budo busu nenei da mamboro ungoda agipo embomei adera. Edo embo Jew ae amimi Jerusalem nati awa usibesi edo patido yise puse adera. Awarate amboda embo Jew ae ainda ungoda Jerusalem nati da gitijigari awa atae adira.” ");
INSERT INTO nou_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Iesu mi sisira, “Amboda iji da kariga da edo damana da joda naso bugari da iwata awa gadewa. Edo busu da ewa orogo mandogo vitadira edo ewa javi jiwae sadira edo iji ainde awa embo berari mi mana mana adera. ");
INSERT INTO nou_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Edo embo ro busu da ira awa gosise edo ungo oju edo ditivi mi ambadera. Edo ungo sise busu da ro bugeiri awa oju adera ainda be awa God mi iji de kariga de damana de dada jigido atevira awa doadira. ");
INSERT INTO nou_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Edo iji ainde na God da mei embo isena awa goroba de edo usasa de poroga da sekago engenembadena. ");
INSERT INTO nou_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Rora berari eiawa adi tuturo adira iji ainde diti inda ewo ko God mi ingo badira iji awa bugira.” ");
INSERT INTO nou_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu mi ungoda yei inia kiki eiawa sisira, “Ri betora de ri nenei de awa kotewo. ");
INSERT INTO nou_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ingo mi gadewa ri mane ainda tuno awa koru kara adera awa gadewa iji ainde ingo gadewa ga iji awa bugira. ");
INSERT INTO nou_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Da awodo ro setena awa adira iji ainde awa ingo gadewa God da gitijigari iji awa aikambu etira. ");
INSERT INTO nou_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Na ingoda yei ge be sena embo boroko atera awa betae atiroro rora berari eiawa adira. ");
INSERT INTO nou_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Edo utu de busu de awa atae adira te naso ge awa atae adi aera. ");
INSERT INTO nou_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Imo indido doae indise edo umo okain indise edo imo rora nenei jiwae embo dubo vevera iriroso edo iji nembodiba awa iso yei teta wao awodo bugadira awasedo imo imosuka gido gogo eio. ");
INSERT INTO nou_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ainda be awa iji nembodiba awa embo berari busu berari da atima era ainda bugadira. ");
INSERT INTO nou_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Edo ro berari bugadira ainda joda edo imo na God da mei bugudo embo isena naso joda deradesa ainde awa iso joda ae sumbae ta kotae sumbae eose ta God manunugurise atio.” ");
INSERT INTO nou_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iji de awa Iesu Jew embomei da tumondebain ari oro da embo atopapotise atima isira te tumba de awa umo doriri jawo Olive da mambudo ainda atima isira. ");
INSERT INTO nou_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Edo sipo be sipo de embo jiwae be mi dada edo uso ge ingido isera. ");
INSERT INTO nou_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ambe bajari siwo jawo yeast awa ambe da itae indari iji awa aikambu isira. Edo bondo einda jawo awa jarusegari bondo ra. ");
INSERT INTO nou_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Edo priest gitijijigegari de agodari da atopapotegari de awa Iesu doro betarase emboro eura isera te ungo oro embo embogo eorase dipapa ae isera ainda be awa ungo oju isera. ");
INSERT INTO nou_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Edo ungo awodo eura ero Satan mi ambojimbi 12 ainda teda Judas Iscariot da jo da totorisira. ");
INSERT INTO nou_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Awasedo Judas mambudo priest gitijijigegari de edo Jew embobo da tumondebain ari oro simba ari embobo da yei rawodo edo Iesu ungoda yei indiga adiri awa sisira. ");
INSERT INTO nou_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Edo ungo uso ge awa ingido jo iaviri ise sisera ungomi uso yei ganu itadera awa sisera. ");
INSERT INTO nou_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Edo Judas ungoda ge awa awara sedo edo iji embo ainda bugae adera iji ewamei awa simba edo ainde gae Iesu ungoda yei indiga adi sisira. ");
INSERT INTO nou_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ambe bajari siwo jawo yeast awa ambe da itae indari iji awa bugiri iji ainde Jew embobo da ari awa jarusegari bondo da wo sheep da mei awa bondo da dedo era. ");
INSERT INTO nou_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Awasedo Iesu Peter de John de itido ungoda yei sisira, “Mambuwo jarusegari bondo sia awo ingode indore.” ");
INSERT INTO nou_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Setiri ungo mi uso yei mina sisera, “Rawainda imo indari sia orase dipapa esi?” ");
INSERT INTO nou_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Setero ungoda yei sisira, “Ingiwo. Ingo nati nembodiba da totorirowo embo da umo utingi da budo bugutima ingo tambadira. ");
INSERT INTO nou_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Edo umo ingo tambudo edo mando da toradira mando ainda umo ambo ambo ewo. Edo umo ambo ondedo mando jo da torido mando topo da sewo, ‘Atopatari mi setira, “Diumba mo rawainda na naso ambojimbi de jarusegari bondo indari mo indeni?” ’ ");
INSERT INTO nou_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sawo unemi ingoda yei diumba inda ainda rora berari sia ari atira awa ari gadewa. Edo ingo diumba ainda torido jarusegari bondo indari awa ingode indorase sedo sia ewo.” ");
INSERT INTO nou_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Setiri ungo dodo nati nembodiba da mambusera edo ro berari Iesu mi sisira awa tambusera. Tambudo ungoi jarusegari bondo indari awa sia isera. ");
INSERT INTO nou_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Edo indari indari iji awa bugiri Iesu indari indari diumba da torido demo mi tendeba tuda ainda anumburisira uso ambojimbi de. ");
INSERT INTO nou_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Edo ungo awodo demo mi anumbedo atero Iesu mi ungo da yei sisira, “Na memesi awa gae atise na ingo berari de dada edo jarusegari bondo indari awa indari dipapa etena. ");
INSERT INTO nou_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Edo na ingoda yei sena na mana sekago bondo eiawa indadena te amboda God mi gitijigadira iji ainde awa bondo be awa indadena.” ");
INSERT INTO nou_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Edo umo awodo sedo Iesu agatu awa budo God ategedo sisira, “Eiawa kumbudo dada edo indiwo. ");
INSERT INTO nou_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Edo na ingoda yei sena na mana sekago ingode grape ngamo awa indadena te amboda God mi gitijigadira iji ainde awa na sekago ingode indadena.” ");
INSERT INTO nou_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Edo umo awodo sedo ambe kumbudo God da yei ategari itido gavedo uso ambojimbi da yei ititisira. Edo ungoda yei ititise sisira, “Eiawa naso tamo awa nanemi ingo awasedo ititena. Edo ambe eiawa indise na kotembu kotembu ewo.” ");
INSERT INTO nou_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Edo umo awodo setiri ungo indido atae etero ungoda yei aga ititisira. Edo umo ungoda yei ititise sisira, “Eiawa naso ororo awa nanemi ingo awasedo jojena amimi ari God da awara sari seka awa be adira. ");
INSERT INTO nou_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Awarate giu embo na indiga sadi aikambu ira awa einda nangae tendeba da atira. ");
INSERT INTO nou_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Edo God mi matu awara etira na God da mei embo isena awa betadena te embo amemi na indiga sadi ira awa esusu biae adira.” ");
INSERT INTO nou_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Setiri ungoi ungosuka mina sara isera ungoda teda mo amemi emomo eiri. ");
INSERT INTO nou_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Edo ambojimbi ungoda teda mo amemi gitijigari eiri awa sedo besora isera. ");
INSERT INTO nou_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ero Iesu mi ungoda yei sisira, “Embo Jew ae awa ungoda gitijijigegari nembogamo mi embo awa goroba de gitijigido era. Embo goroba embobo awa embo mi ungo awa embo ewagaewa sorase dipapa edo era. ");
INSERT INTO nou_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Awarate ingo awa awodo eove ta ingoda teda embo nembodiba awa embo seka awodo are. Edo gitijigari awa teta agipo embo awodo are. ");
INSERT INTO nou_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Seu gane, embo nembodiba mo averi embo tendeba be da anumbedo indira awa umomo embo nembodiba ta ko umo derido indari ititiri awa embo nembodiba ri? Ingo matu gari ra embo ave tendeba da anumbedo indari indira awa embo nembodiba ra. Awarate na ingoda teda awa agipo embo ra. ");
INSERT INTO nou_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Na memesi burewona iji ainde ingo na doae rate nangae atewowa. ");
INSERT INTO nou_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Edo naso Mama mi naso yei goroba ititisira na gitijigari nembodiba anase. Da awodo na ingoda yei goroba ititena. ");
INSERT INTO nou_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Edo nanemi gitijigadena iji ainde ingo awa nangae dada indadewa. Edo ingo rora teta gitijigari da anumba inge ainda anumbedo atise Israel embobo da orobe 12 awa gitijigadewa.” ");
INSERT INTO nou_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesu Simon da yei sisira, “Simon ingio embo mi indari wheat da ve awa budo jasedo pesi pesi eoro edo be yei nei da mambuteuri edo puti yei nei da mambudo ira da awodo Satan mi imo budo jasedo edo pesi pesi adi sedo gosira edo God awara etira. ");
INSERT INTO nou_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Awarate Simon na God imo awasedo manunugetena. Edo na God sedo getena iso tumonda ari awa goroba edo atarase. Amboda imo iso wasiri biae dodo naso yei engenembadesa iji ainde awa iso otatao awa kondade eio na be goroba de ge be ore.” ");
INSERT INTO nou_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Setiri Peter mi mina sisira, “Gitijigari ungoi imo gajari oro da budo mambaderita ko doro betadesita awa na ingae mambadena.” ");
INSERT INTO nou_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Setiri Iesu mi mina sisira, “Kokora egoro tamonde sae atirari boroko imo na bero iji tamonde adesa.” ");
INSERT INTO nou_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iesu mi ungoda yei sisira, “Matu na ingo iteno mambusewa ganu dada ari rora ae sapoia ae edo tei goru ae edo iji ainde ingo rora nenei inono ae isevita?” Setiri ungomi mina sisera, “Awodo aera.” ");
INSERT INTO nou_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Setero Iesu mi ungoda yei sisira, “Awarate boroko embo ave ganu kopa ari rora de sapoia de ri awa mambuse gido budo daga mambare. Edo embo ave kasiwo ae ri awa uso ombari awa ori edo kasiwo da ori are. ");
INSERT INTO nou_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Edo na ingoda yei sena ro jiwari mi naso jawo da sira awa be adira. Edo jiwari mi sira, ‘Ungomi sisera umo awa embo dombu da agodari bejisera ainda teda ra.’ Gebe, ge ungomi sisera naso jawo da ainda be awa etira edo bugira.” ");
INSERT INTO nou_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Setiri edo uso ambojimbi mi sisera, “Gitijigari gi. Kasiwo etoto eire.” Setero Iesu mi mina sisira, “Ge awodo seove.” ");
INSERT INTO nou_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nati nembodiba awa dodo Iesu uso wasiri awodo gido doriri Olive da mambusira. Edo uso ambojimbi daedo mambusera. ");
INSERT INTO nou_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Edo doriri da mambudo yei ainda bugudo Iesu mi ungoda yei sisira, “Bagari mi pature God manunugewo.” ");
INSERT INTO nou_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sedo ungo dodo umo kiambu yisira ingode ganuma pigoro wosedo ira da awodo. ");
INSERT INTO nou_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mambudo Iesu mi sisira, “Mama imo memesi naso yei bugutira awa beitigadi dipapa edo re beitigeio. Awarate naso dipapa awa eose ta iso dipapa awa eio.” ");
INSERT INTO nou_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Edo umo awa siri asisi ewamei utu dodo uso yei bugudo etiri umo goroba isira. ");
INSERT INTO nou_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Edo Iesu jo dadara etiri God goroba berari mi manunugurisira. Edo uso igori teta ororo inge busu da wowosisira. ");
INSERT INTO nou_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Edo God manunugedo atae edo engenembedo uso ambojimbi da yei mambudo ungo ewo ero gosisira. Ungoda dubo vevera nembodiba mi etiri ungo wasi ae isera awasedo ungo ewo isera. ");
INSERT INTO nou_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Edo ungo gido Iesu ungoda yei sisira, “Ingo roedo evevi? Doawo bagari mi ingo pature erido God manunugewo.” ");
INSERT INTO nou_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Edo Iesu ge sise atiri embo diti nembodiba bugusera. Judas ambojimbi 12 da teda amimi gitijigido. Edo Iesu muno adi edo uso yei asusubedo bugusira. ");
INSERT INTO nou_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Awarate Iesu mi sisira, “Judas imo na God da mei embo isena awa muno mi indiga esita?” ");
INSERT INTO nou_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Setiri edo ambojimbi Iesu ga atisera amimi ro adira awa gido sisera, “Gitijigari nangoda kasiwo mi embogo erita?” ");
INSERT INTO nou_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sedo ambojimbi da teda da amimi priest gitijigari nembodiba da agipo ari embo awa dedo dengoro be awa diugurisira. ");
INSERT INTO nou_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Etiri Iesu mi sisira, “Awodo eose.” Sedo embo ainda dengoro awa jigiri edo ewamei isira. ");
INSERT INTO nou_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Edo Iesu priest gitijijigegari de Jew embobo da tumondebain ari oro simba ari embobo da gitijijigegari de umo badi bugusera awa gido ungoda yei sisira, “Namomo embogo da gitijigari embo gido embo mi na eura eri ta? Ro edo ingo isoro gi emi de na badi bugevi? ");
INSERT INTO nou_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Iji berari na ingode Jew embomei da tumondebain ari oro da emona edo ingo na dadi jarae. Awarate boroko umenga da gitijigari awa goroba de gitijijigurira iji einde ingo ingoda wasiri biae awa adewa.” ");
INSERT INTO nou_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Setiri ungoi Iesu sandisera edo ungo mi umo budo priest gitijigari nembodiba da mando da mambusera. Edo Peter besaun amboda Iesu ambo ambo isira. ");
INSERT INTO nou_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Edo embo ri mando arapa soropu da undugurisera. Edo Peter arapa da torido embo ri jiroroka edo anumbedo atisera ainda anumburisira. ");
INSERT INTO nou_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Edo agipo gagara da amimi Peter ri demonda anumbedo atiri gido umo gon edo ditini edo uso yei sisira, “Embo eiawa Iesu ga daedo atima ira.” ");
INSERT INTO nou_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Setiri Peter gagara awa bero edo sisira, “Evetu na umo gaera. ");
INSERT INTO nou_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Edo iji tupo embo da mi Peter gido sisira, “Imo awa embo ounda kondade ari embo ra.” Setiri Peter mi mina sisira, “Embo na awa aera.” ");
INSERT INTO nou_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Edo amboda iji tupo simba ise embo nei mi ge okain sisira, “Na embo eiawa gosena umone Iesu da ambojimbi da teda da ra.” ");
INSERT INTO nou_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Setiri Peter mi mina sisira, “Embo na imo ge sesa awa gaera.” Edo Peter ge awa siri kokora egoro sisira. ");
INSERT INTO nou_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Edo Bada wareregedo Peter gosisira. Edo umo ditini iri Peter Bada mi matu ro uso yei sisira awa kotisira, “Kokora egoro sae atirari boroko imo iji tamonde na bero adesa.” ");
INSERT INTO nou_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Awa kotedo Peter ponda wosedo ji inaka de sisira. ");
INSERT INTO nou_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Edo embo Iesu simba isera amimi umo dedo gaedo edo ganduburisera. ");
INSERT INTO nou_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ungoi uso dombu dogedo uso yei nganega isera, “Imo Mamo da binga sari embo sadesa awa nango se gore embo amemi imo detiri?” ");
INSERT INTO nou_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Edo daedo ungoi isibari ge bebegae uso yei sisera. ");
INSERT INTO nou_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sipo de Jew embobo nembogamo de priest gitijijigegari de edo agodari da atopapotegari de dada etero edo ungoda embo nenei mi Iesu budo ungoda yei mambusera. ");
INSERT INTO nou_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Edo ungomi Iesu da yei sisera, “Nango se gore soregari embo God mi itari bugarase sisira mo embo mo imo ta? Setero unemi mina sisira, “Na ingoda yei sadena awa ingo na ge be adi aera. ");
INSERT INTO nou_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Edo na ingoda yei sedo gari itadena awa ingo mana naso yei mina sadewa. ");
INSERT INTO nou_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Awarate iji tupo tuturo adira ainde na God da mei embo isena awa God goroba jiwae de da ingo be da anumbedo atadena.” ");
INSERT INTO nou_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Setiri ungomi berari sisera, “Imo setesa imo awa God da mei na?” Setero Iesu mi mina sisira, “Ingo ingosuka sewa na awa God da mei na.” ");
INSERT INTO nou_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Setiri ungo ungosuka mina sara isera, “Ingode mana embo nenei eura oro umo bekuba adera ko uso ge topo mi umo umosuka bekuba etiri ingode ingera.” ");
INSERT INTO nou_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Embo berari ainda dada isera amimi erido Iesu budo Pilate da yei mambusera. ");
INSERT INTO nou_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Budo mambudo ungoi Iesu bekuba edo sisera, “Embo emimi nangoda embo da yei ge busise tembevira. Umo umosuka awa gitijigari nembodiba jawo Keriso sise nangoda embobo seuri Rome embobo da gitijigari nembodiba da tax ganu itadi ae sevira. Awasedo nango umo sandido budo iso yei bugera.” ");
INSERT INTO nou_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Setero Pilate mi uso yei sisira, “Imo mo Jew embobo da gitijigari nembodiba ta?” Setiri Iesu mi mina sisira, “Imo imosuka sesa awara.” ");
INSERT INTO nou_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Setiri Pilate mi priest gitijijigegari de embo dombu dombu atisera ainda yei sisira, “Embo eiawa wasiri biae aera.” ");
INSERT INTO nou_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Awarate ungomi sekago sisera, “Judea busu berari da embo da yei umo mambutira awa uso atopatari mi iri embogo tuturo era. Umo Galilee busu da tuturo edo boroko einda bugira.” ");
INSERT INTO nou_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate ge eiawa ingido nganega isira, “Embo emomo Galilee embo ta?” ");
INSERT INTO nou_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Setiri setero gosisira umo Iesu awa busu Herod mi gitijigido ira yei awa embo. Awasedo Pilate mi Iesu awa Herod da yei itiri mambusira umo awa Jerusalem nati da iji ainde awa atisira. ");
INSERT INTO nou_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Edo Herod Iesu gido iaviri isira ko umo Iesu da binga ingido edo boroko ae be umo gari dipapa evira. Umo Iesu mi wasiri ari gadi dipapa edo evira. ");
INSERT INTO nou_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Awasedo Herod Iesu da yei nganega jiwae be isira te Iesu uso ge mina sae. ");
INSERT INTO nou_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Edo Priest gitijijigegari de agodari da atopapotegari de mi erido Iesu goroba de bekuba isera. ");
INSERT INTO nou_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Edo Herod de uso isoro embobo de mi Iesu gandubedo edo umo biae be isera. Edo bo ove ewagaewa de awa uso yei itero ombiri ungomi umo itero sekago Pilate da yei mambusira. ");
INSERT INTO nou_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Edo Herod de Pilate de awa mendo gambae edo isera te iji ainde awa otao isera. ");
INSERT INTO nou_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate mi setiri Priest gitijijigegari de Jew embobo da gitijijigegari nenei de edo embo de dada isera. ");
INSERT INTO nou_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Edo ungo dada etero, Pilate mi ungoda yei sisira, “Ingo embo eiawa budo naso yei bugewa edo setewa umo embo da yei ge busise tembira. Awarate na ingo berari da dombu da umo nganega etena ingoda bekuba etewa awa edo buria da ro tambae etena. ");
INSERT INTO nou_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Edo Herod Iesu sekago ingodenaso yei itiri bugira ainda be awa umo nganega etira te buria da ro tambae edo wasiri biae da ro ari ingomi dawo betadira awa aera. ");
INSERT INTO nou_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Awasedo nanemi sena ungomi umo vejedo edo wujegadera.” ");
INSERT INTO nou_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Edo gaeko jaige jarusegari bondo da wasiri awa ambo ambo edo era. Pilate mi gajari oro da atima ira embo awa embo mi da rawa dipapa edo era awa wujegedo ira. ");
INSERT INTO nou_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Awasedo embo berari mi gogo dimbudo sisera, “Embo awa de betare. Barabbas awa wujegeio nangoda yei bugare.” ");
INSERT INTO nou_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Matu gitida ungoi Barabbas awagajari oro da ititisera ainda be awa unemi etiri embo mi gitijijigegari awa dorisera. Edo umo daedo embo da detiri betisira. ");
INSERT INTO nou_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Edo Pilate Iesu wujegadi dipapa edo embo da yei sisira. ");
INSERT INTO nou_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Awarate ungoi gogo dimbudo mina sisera, “Orega da de. Orega da de.” ");
INSERT INTO nou_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Setero Pilate mi ungoda yei sisira, “Awarate umo ro embo betarase dipapa evi? Wasiri biae ro etiri? Na wasiri biae ro tambae edo ingo mi umo dawo betarase evi? Nanemi sena ungomi umo vejedo edo wujegadira.” ");
INSERT INTO nou_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Awarate ungomi mata gogo nembodiba dimbudo sisera Iesu awa benema mi orega da doro betarase sisera. Edo ungo mi gogo dimbuse atisera amimi Pilate da ge awa papotisera. ");
INSERT INTO nou_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Awasedo Pilate awara sedo sisira ungo ro dipapa era awa dowo ore sisira. ");
INSERT INTO nou_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Edo embo matu gajari oro da ititisera ko umo embogo tuturo edo embo da dorisira awasedo embo awa ungo mi dipapa isera awasedo Pilate mi umo wujegurisira. Edo embo awa wujegedo edo Pilate Iesu awa embobo da yei itiri ungo ro dipapa isera awa adi isera. ");
INSERT INTO nou_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Edo ungo Iesu budo mambuteriko ungoi busu Cyrene embo jawo Simon awa tambusera. Edo umo awa uso nati dodo mambudo nati nembodiba da toradi iri ungoi umo ingo da budo orega awa uso saga da ititisera. Edo ungoi itido setero Iesu da ambo da orega ango edo pepeta isira. ");
INSERT INTO nou_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Edo embo diti nembodiba be Iesu ambo ambo isera. Edo embo evetu nenei Iesu embo ji sisera awa dubo vevera de embo diti nembodiba ungoda teda daedo pusera. ");
INSERT INTO nou_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","29","Edo Iesu ungoda yei wareregedo sisira, “O Jerusalem emboevetu na embo ji seove ta ingoda kinapeina de ingo ingosuka awasedo ji sewo ko iji bugutira ainde embo mi sadera, ‘Evetu ero de edo evetu kinapeina bae isira ainde evetu kinapeina emi gaiae atira ainde awa dubo ewamei ore.’ ");
INSERT INTO nou_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Edo iji ainde awa embo mi doriri da yei sadera, ‘Wosedo nango apuregegae.’ Edo ungomi doriri memeia da sadera, ‘Egae nango iso teda unjugore.’ ");
INSERT INTO nou_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ko na teta ri wasiri de da wasiri biae eiawa era te ko amboda ingo teta ri bebetegari da mo rawodo eri?” ");
INSERT INTO nou_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Edo ungo daedo embo bebegae etoto awa Iesu ga daedo betorase budo mambusera. ");
INSERT INTO nou_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Edo ungo yei jawo agatu ainda bugudo benema mi Iesu orega da dorisera. Awodo edo benema mi embo bebegae etoto awa orega da dorisera da Iesu da ingo be da edo nei awa Iesu da ingo anda da. ");
INSERT INTO nou_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Edo ungo awodo edo atae etero Iesu mi sisira, “Mama ungoda buria kotembedo dogae ko ungoi ro era awa gadi jarise era.” Edo ungo Iesu da ombari awa katabedo badi sedo rora pigedo pipi isera. ");
INSERT INTO nou_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Edo embo ainda derido atisera awa gosise atero Jew embobo da gitijijigegari mi Iesu ganduburise sisera, “Umo embo nenei soregurisira. Edo umo soregari embo Mamo mi itari bugarase sisira awa tamo umo umosuka soregare.” ");
INSERT INTO nou_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Edo isoro embobo daedo umo ganduburisera. Edo uso yei asusubedo bugudo grape da ngamo tokaka awa uso dombu da ujiji edo isera. ");
INSERT INTO nou_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Edo awodo ise sedo isera, “Imo awa Jew embobo da gitijigari nembodiba gido imo imosuka soregeio.” ");
INSERT INTO nou_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Edo ge eiawa Latin ge mi Greek ge mi Hebrew ge mi gaiedo uso orega da inda dorisera, “Eiawa Jew embobo da gitijigari nembodiba ra.” ");
INSERT INTO nou_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Edo embo bebegae etoto esegedo atisera ainda da amimi Iesu da yei biae sedo sisira, “Imo sedo esa imo awa soregari embo Mamo mi itari bugarase sisira awa ra. Edo iso ge awa ge be ta imo imosuka soregurise edo nango de da soregegae.” ");
INSERT INTO nou_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Awarate embo biae nei mi ge awa ingido embo awa isiburise sisira, “Imo bouga buresa da awodo umo burira te imo Mamo oju aera. ");
INSERT INTO nou_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ko ingae na etoto betadena amone awara ainda be awa ingae na awa ingae naso wasiri bebegae matu ewora ainda mina awa burera te embo eiawa wasiri biae da ro aera.” ");
INSERT INTO nou_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sedo Iesu da yei sisira, “Amboda imo gitijigari nembodiba adesa iji ainde na koteio.” ");
INSERT INTO nou_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Setiri Iesu mi uso yei sisira, “Nanemi iso yei sena imo boroko nangae mambudo dubo ewamei ari yei da ainda atadesa.” ");
INSERT INTO nou_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Iji soropuda busu berari umenga isira. Edo umenga edo atiri 3 P.M. etiri sekago iji jani burisira. ");
INSERT INTO nou_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Edo bo nembodiba Jew embobo da tumondebain ari oro da esegari awa keresegedo etoto isira. ");
INSERT INTO nou_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Edo keresegetiri Iesu gogo dimbudo sisira, “Mama iso ingo da naso asisi ititena.” Sedo umo bebetisira. ");
INSERT INTO nou_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Edo isoro embo da gitijigari ro isira awa gido Mamo jasiga ise sisira, “Gebe embo eiawa embo ewamei ra edo buria aera.” ");
INSERT INTO nou_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Edo embo ainda dada isera awa ro isira awa gido ungoda oka dorise ji de ungoda nati da engenemburisera. ");
INSERT INTO nou_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Edo Iesu da otatao de emboevetu de umo ambo ambo ise edo Galilee busu da edo bugusera awa aike dederigedo atise ro isira awa berari gosisera. ");
INSERT INTO nou_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Embo jawo Joseph bugusira. Edo umo awa Jew embobo da nati jawo Arimathea awa embo. Umo awa embo ewamei edo embo umo gebe edo isera edo umo Mamo da gitijigari iji awa simba edo isira. ");
INSERT INTO nou_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Edo umo awa Jew embobo da gitijigari nei rate umo gitijijigegari da ge awa umo ujo ae edo gido umo Pilate da yei mambudo Iesu da tamo badi sedo gosisira. ");
INSERT INTO nou_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Edo Pilate awara setiri Joseph Iesu da tamo itiri wosetiri bo parara mi dogisira. Dogedo gowari meko seka ungoda ingo mi ngambusera ainda ititisira. Edo embo gowari meko awa matu jingama ae. ");
INSERT INTO nou_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Edo iji awa Friday edo Jew embomei da tumondebain ari iji awa tuturo adi aikambu iri gido. ");
INSERT INTO nou_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Edo emboevetu Iesu ambo ambo ise Galilee busu da edo bugusera awa Joseph ga da mambudo embo gowari meko edo Iesu da tamo Joseph mi ititisira awa ungo gosisera. ");
INSERT INTO nou_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Gido ungoda mando da engenembedo joino muno de edo Iesu da tamo da siwo de awa sia isera. Edo ungo tumondebain ari iji de agodari mi sira awa kera edo jango indisera. ");
INSERT INTO nou_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sunday sipo be sipo de emboevetu joino muno de edo siwo de sia isera awa budo embo gowari meko da mambusera. ");
INSERT INTO nou_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mambudo ganuma awa embo nenei mi miminegetero embo gowari meko be demo da atiri gosisera. ");
INSERT INTO nou_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Awasedo ungo totorisera te ungo Bada Iesu da tamo awa tambae. ");
INSERT INTO nou_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Edo ungo ainda mana mana edo derido atero embo etoto ombari parara ombari awa bugudo ungoda demonda dederisera. ");
INSERT INTO nou_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Edo emboevetu awa oju edo diti tuda isera. Edo ungo awodo ero embo etoto mi ungoda yei sisera, “Ro awasedo ingo embo wasiri de atira awa betari da teda eura evi? ");
INSERT INTO nou_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Umo einda atae ra. Umo betedo edo sekago erira. Edo Iesu umo Galilee busu da atise ingoda yei ro sisiri awa kotewo, ‘Ungomi na Mamo da mei awa embo bebegae da ingo da itadera. Edo ungomi na benema mi orega da dadera. Edo na betedo iji tamonde atae ari na sekago wasiri de eradena.’” ");
INSERT INTO nou_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Awodo setero emboevetu uso ge awa kotedo gowari meko be awa dodo mambudo ambojimbi 11 de nenei de da yei mambusera. Mambudo ungo ro berari gosisera awa setero gosisera. ");
INSERT INTO nou_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Edo emboevetu eiawa ambojimbi da yei setero gosisera amone Mary Magdalene de Joanna de James da ai Mary de ra. Edo emboevetu nenei awa daedo ainda ra. ");
INSERT INTO nou_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Awarate ambojimbi emboevetu da ge awa ingido kotisera ge awa busari awasedo ungo ingae isera. ");
INSERT INTO nou_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Awarate Peter erido meko da sumbudo mambudo kukubedo jo gosisira. Edo gido bo umo umosuka gosisira. Gido umo engenembedo mando da mambudo ro isira ainda be awa eura isira. Edo umo mambudo ro isira awa jiro buro ise atisira. ");
INSERT INTO nou_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Iji da ainde embo etoto awa Emmaus nati da mambusera. Edo emboro Jerusalem dodo Emmaus mambari awa 12 Kilometres ra. ");
INSERT INTO nou_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Edo ungo pepeta edo mambuse ungo ungosuka ro isira awa ge mina sara isera. ");
INSERT INTO nou_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Edo ungo ge sero Iesu umo umosuka bugudo ungoda demo da daedo pepeta isira. ");
INSERT INTO nou_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Edo umo daedo pepeta isira te ungo umo embo averi awa gae. ");
INSERT INTO nou_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Edo Iesu mi ungoda yei sisira, “Ingo pepeta ise ingo ge ro ingo ingosuka sevi?” Setiri ungo dubo vevera dombu ise pepetisera. ");
INSERT INTO nou_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Edo dakain da jawo Cleophas mi Iesu da yei sisira, “Esega embobo berari Jerusalem nati da dada ititara awa ro iji tupo iutara ainda binga awa gositara te imo imosuka awa ingae ra?” ");
INSERT INTO nou_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Setero Iesu mi nganega isira, “Binga mo rorae ingo mo ge sevi?” Setiri ungomi mina sisera, “Binga ro Iesu Nazareth nati embo da yei etira awa. Embo eiawa Mamo da binga sari embo ra. Edo embo da dombu da edo Mamo da dombu da umo ge okain de edo wasiri goroba de evira. ");
INSERT INTO nou_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Edo nangoda priest gitijijigegari de babojegari de mi umo gitopo da ingo da itero edo ungo awara sedo edo benema mi orega da detero betetira. ");
INSERT INTO nou_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Edo nango kotewora embo emimi mina itido edo nango Israel embomei soregadira. ");
INSERT INTO nou_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Awa da awa aerate iji tamonde atae etiri nangoda emboevetu nenei mi boroko kove ari binga setero getera. Edo nango binga awa ingido mana mana etera. Edo ungomi setera ungo sipo tu busiri uje kokombo da mambudo edo Iesu da tamo tambae etera. ");
INSERT INTO nou_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Edo engenembedo nangoda yei bugudo setera ungo asisi ewagaewa getero edo setera Iesu awa wasiri de atari setera. ");
INSERT INTO nou_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Edo ungo nangoda yei awa setero nango nenei mi uje da mambudo ro emboevetu mi setera awa tambera te ungo umo gaera.” ");
INSERT INTO nou_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Setero Iesu mi ungoda yei sisira, “O ingo etoto kotari atae ra. Edo ingo ro Mamo da binga sari embo mi sisera awa sasaimbedo ge be edo ewa. ");
INSERT INTO nou_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Soregari embo Mamo mi itari bugarase sisira awa giti awa memesi awa gadira edo amboda uso usasa ari iji awa bugadira.” ");
INSERT INTO nou_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Edo Iesu awa sedo edo ro jiwari mi uso jawo da sira awa ujugadi sedo isira. Edo ge Moses de Mamo da binga sari embobo de mi gaisira ainda tuturo edo kiki berari awa sisira. ");
INSERT INTO nou_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Edo ungo nati rawainda mambutera awa aikambu bugudo Iesu nati awa dodo derigedo mambadi isira. ");
INSERT INTO nou_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Awarate ungo umo doro derigeurase sedo uso yei sisera, “Ongobo etiri edo tumba jijirira awasedo puio ingode atore.” Setero gido umo ungoda nati da daedo atadi totorisira. ");
INSERT INTO nou_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Edo umo tendeba mendo da daedo anumbedo ambe budo God ategurisira. Edo ategedo ambe ngaungedo ungoda yei ititisira. ");
INSERT INTO nou_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Edo umo awodo etiri umo averi awa gosisera te burigi be ungoda diti da nonda yarago isira. ");
INSERT INTO nou_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Edo umo nonda yarago etiri ungo ungosuka mina sara isera, “Ingodena emboro da pepeta ero edo umo jiwari awa ingodenaso yei ujugetira ainde ingodenaso jo awa teta ri mi ewarago etira.” ");
INSERT INTO nou_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Edo ungo awa sedo burigi erido engenembedo Jerusalem nati da mambusera ainda ambojimbi 11 de edo nenei ainda dada edo atisera awa tambusera. ");
INSERT INTO nou_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Edo embo dada edo atero tambusera amimi sise atisera, “Gebe Bada awa erira. Edo umo Simon da yei isaga etira.” ");
INSERT INTO nou_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Edo ungo ge awa ingido edo embo etoto amimi emboro da ungoda yei ro etira awa ujugurisera. Edo ungo daedo Bada ambe ngaungetiri ungo umo gosisera awa ujugurisera. ");
INSERT INTO nou_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Edo ungo awodo sise atero Bada umo umosuka bugudo ungoda teda derido ungoda yei sisira, “Dubo jamo ingoda yei natopo atare.” ");
INSERT INTO nou_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Awarate ungo oju isera ainda be awa ungo kotisera asisi gari ge sisera. ");
INSERT INTO nou_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Awarate unemi ungoda yei sisira, “Ingo ro edo oju evi? Edo ingo ro edo mana mana evi? ");
INSERT INTO nou_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Naso ingo de tei de awa gosise awa giwo amone nanemi ingoda teda atena. Edo ingoda ingo mi jigido gosise ingo gadewa ko asisi awa tamo de vetu de teta ingo gosewa teta na tamo de vetu de eiedo aera.” ");
INSERT INTO nou_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Edo umo awa sedo uso ingo de tei de awa ujiji etiri gosisera. ");
INSERT INTO nou_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iaviri de kove ari mi ungoda jo beda etiri ungo ge be ari sago ae isera. Awasedo Iesu ungo nganega isira, “Ingo einda indari indadewa atita?” ");
INSERT INTO nou_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Setiri ungo uso yei wo sagisera awa ititisera. ");
INSERT INTO nou_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Itero budo ungoda jo da indisira. ");
INSERT INTO nou_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Indido ungoda yei sisira, “Na ingode matu atise ro sisena amone boroko bugira eire. Edo na ingoda yei matu sisena Moses da agodari de Mamo da binga sari embobo da jiwari de ya naso jawo da gagaegurisera awa berari be adira sisena.” ");
INSERT INTO nou_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Edo umo ungoda jiro budo pirigurisira jiwari awa gorase. ");
INSERT INTO nou_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Edo umo ungoda yei sisira, “Jiwari mi eiawa naso jawo da sira, ‘Soregari embo Mamo mi itari bugarase sisira awa memesi tambudo betadira. Edo umo betedo iji tamonde atae ari sekago wasiri de eradira.’ ");
INSERT INTO nou_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Edo jiwari mi daedo sira ungo Jerusalem nati da tuturo edo wasiri bebegae dodo Mamo da yei wareregari edo Mamo mi kotembedo doari awa atopatadera awa jiwari mi sira. ");
INSERT INTO nou_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Awasedo ingo ro gosisewa awa atopapotise atiwo. ");
INSERT INTO nou_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Edo Asisi Kotopu naso Mama mi ingoda yei itadi sisira awa nanemi ingoda yei itane. Awarate ingo mana nati doadewa te ainda atiwo. Amboda Asisi Kotopu utu dodo wosedo ingo goroba mi sirari edo iji ainde awa atopatadi tuturo ave.” ");
INSERT INTO nou_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nati awa dodo Iesu ungo gitijigedo Bethany nati da mambudo uso ingo inda jigido ungo ewamei isira. ");
INSERT INTO nou_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Edo umo ungo ewamei iri God umo budo utu da vivitisira. ");
INSERT INTO nou_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","53","Edo ungo umo tumondebain edo iaviri mi jo ato ae etiri ungo engenembedo Jerusalem nati da mambusera edo ainda Jew embobo da tumondebain ari oro da iji berari Mamo jasiga edo isera. ");
INSERT INTO nou_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Rora berari ae tuturo da Iesu Keriso uso jawo nei God da ge atinatina. Umo God de daedo atinatina. Edo umo umosuka awa God. ");
INSERT INTO nou_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Edo be tuturo da awa umo God ga atinatina. ");
INSERT INTO nou_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Edo God umo awodo rora berari awa isira. Edo rora berari boroko atira awa unemi isira. ");
INSERT INTO nou_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Edo Iesu Keriso wasiri be awa budo atima ira. Edo uso wasiri mi embo da yei usasa itido ira. ");
INSERT INTO nou_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Uso wasiri awa umenga da janibedo ira awa usasa ra. Edo usasa awa mata janiburise atima ira ko umenga mi mana ari ambadira. ");
INSERT INTO nou_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","God uso binga sari embo John itiri embo da yei usasa awa sari gorase bugusira. God umo embo berari mi binga awa ingido ge be orase sedo John itiri bugusira. ");
INSERT INTO nou_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","John umo umosuka awa usasa awa aera. Umo embo da yei usasa awa sari gorase bugusira. ");
INSERT INTO nou_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Amboda embo usasa be awa bugudo busu berari da embobo da yei janiburisira. ");
INSERT INTO nou_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Edo Iesu Keriso bugudo busu da embo da teda atisira. Unemi busu isira edo busu da rora berari de embo de isira te embo umo embo averi awa gaera. ");
INSERT INTO nou_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Umo uso busu topo da bugusira te uso embo topo umo ujo ae isera. ");
INSERT INTO nou_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Awarate embo gebe edo umo budo isera ainda bajari ari itiri edo God da kinapeina edo isera. ");
INSERT INTO nou_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iji ainde ungoda aimono mi ungo ingedo isera edo ungo God da kinapeina ae edo isera. Daedo ungoda ai de mamo de mi ungo oro God da kinapeina orase ae edo isera. Awarate God da goroba mi ungo God da kinapeina isera. ");
INSERT INTO nou_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Edo Iesu Keriso uso jawo nei God da ge embo edo ingodenaso teda atisira. Edo dubo bari de kotembedo doari de gebe de mi uso jo ato ae isira. Edo ingodena uso wasiri da usasa God mi ititisira awa gosisera. Edo God usasa awa uso yei ititisera ainda be awa umo awa uso mei awo da awasedo. ");
INSERT INTO nou_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Edo John Iesu Keriso da jawo da ge sisira edo minonu sisira, “Matu na ingoda seteno gosisewa embo nei bugadira. Edo uso wasiri mi naso wasiri derigurira ainde be awa naso aia na kumbae atiri umo atima isira seteno gosisewa Embo amone awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Edo Iesu Keriso dubo bari kotembedo doari de gebe be mi ingodena berari ewamei etira. Unemi ewamei ari jiwae tamo da tamo da itido ira. ");
INSERT INTO nou_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Edo God uso agodari ingodenaso yei itari dipapa edo Moses ititisira te umo ingodenaso yei dubo bari de kotembedo doari de gebe de itari dipapa edo Iesu Keriso ititisira. ");
INSERT INTO nou_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Edo embo da amemi God gaera awarate uso mei awo da amimi uso Mamo ga atima ira amimi umo ingodenaso yei karigedo ira. ");
INSERT INTO nou_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jew embobo da gitijijigegari Jerusalem nati da atisera amimi priest embobo de priest da kondade ari embobo de awa John da yei umo umo buro ro edo iri awa nganega adi mambusera. ");
INSERT INTO nou_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Edo ungo John nganega isera edo umo gebe awa unjugae rate sisira, “Na awa soregari embo God mi itari bugarase sisira awa aera.” ");
INSERT INTO nou_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Setiri ungoi nganega isera, “Imo mo binga sari embo matu atisira Elijah ta?” Setero umo mina sisira, “Na embo awa aera.” Setiri ungoi nganega isera, “Imo mo God da binga sari embo nango simba ewora awa ta?” Setero mina sisira, “Awa aera.” ");
INSERT INTO nou_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Setiri ungoi sisera, “Imo mo averi awa se gore. Edo embo amemi nango itero bugera awa gadi dipapa era awasedo iso mina sari awa se gore.” ");
INSERT INTO nou_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Setero John mi ro God da binga sari embo Isaiah mi sisira awa ungo da yei sisira, “Na awa dumbari yei da embo atise minonu sadira, ‘Bada da bugari emboro sia ewo. Edo uso emboro ewo dambuderari are.’” ");
INSERT INTO nou_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Setiri edo embo Pharisee embomei itero bugusera amimi John da yei ngnega isira, “Edo imo soregari embo God mi itari bugarase sisira awa ae edo Elijah ta ko binga sari embobo nango simba ewora awa ae mo ro edo imo umo mi embo ewamei edo esi?” ");
INSERT INTO nou_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Setero John mi mina sisira, “Na embo umo mi ewamei edo ena. Edo embo nei bugudo ingoda teda atira te ingo umo gaera. ");
INSERT INTO nou_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Edo iji tupo atae ari umo uso buro ingoda teda tuturo adira. Umo awa embo nembodiba ra te na awa embo nembodiba aera. Edo na awa ewa raro uso tei goru simba eni?” ");
INSERT INTO nou_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eiawa berari Bethany nati da wosedo yari umo Jordan umo be nei da isira. Edo umo ainda John umo umo mi embo ewamei edo isira. ");
INSERT INTO nou_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iji nei John Iesu uso yei bugutiri gido sisira, “Embo oiawa giwo. Umo teta wo sheep da mei mi busu berari da embobo da wasiri biae awasedo betarago adira umone God da mei ra. ");
INSERT INTO nou_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Matu na ingoda yei siutana, ‘Embo nei amboda bugadira. Uso wasiri mi naso wasiri awa derigari ra ainda be awa naso ai na bae atiri umo atima isira.’ Embo amone eire. ");
INSERT INTO nou_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Edo na umo embo averi awa na gaera te na embo umo mi ewamei ise Israel embobo da umo isaga adi bugusena.” ");
INSERT INTO nou_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Edo John embo da yei umo ro gosisira awa sisira, “Na Asisi Kotopu teta ribo inge utu dodo wosedo Iesu da yei anumbetiri gosisena. ");
INSERT INTO nou_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Edona umo gaera te God na umo mi embo ewamei anase itiri bugusena amimi naso yei sisira, ‘Imo Asisi Kotopu mi embo da da yei petari gadesa embo re amimi embo Asisi Kotopu mi ewamei adira gio.’ ");
INSERT INTO nou_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Edo na rora berari awa etiri gido, gido ingoda yei sena embo amone God da mei na. ");
INSERT INTO nou_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iji nei John uso ambojimbi etoto de sekago yei ainda bugusira. ");
INSERT INTO nou_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Edo John Iesu bugutiri gido sisira, “Emone God da mei teta wo sheep da mei mi betarago adira.” ");
INSERT INTO nou_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Edo John da ambojimbi etoto ge awa siri ingido Iesu ambo ambo isera. ");
INSERT INTO nou_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Edo ungo umo ambo ambo ero Iesu wareregedo ungo gido ungoda yei nganega isira, “Ingo ro dipapa evi?” Setiri ungomi mina sisera, “Rabbi ainda be awa atopatari imo nonda atima esi?” ");
INSERT INTO nou_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Setero mina sisira, “Puwo gave.” Awasedo ungo daga mambudo umo rawainda atima isiri awa gido ungo ainda ungae atisera ainda be awa ongobo etiri gido. ");
INSERT INTO nou_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Edo John da ge ingido Iesu ambo ambo isera ainda embo nei awa Andrew, Simon Peter da namendi. ");
INSERT INTO nou_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Umo mambudo uso namendi Simon tambudo sisira, “Nango Iesu Keriso Soregari Embo God mi itari bugarase sisira awa tambera.” ");
INSERT INTO nou_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sedo Simeon budo Iesu da yei bugusira. Edo Iesu umo ditini ise sisira, “Imo awa Simon, John da mei ra te iso jawo awa seka Peter sadera ainda be awa ganuma.” ");
INSERT INTO nou_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sipo nei Iesu Galilee busu da mambadi sedo erido Philip tambudo sisira, “Na ambo ambo eio.” ");
INSERT INTO nou_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Edo Philip awa Bethsaida nati embo ra. Edo Andrew de Peter de awa daedo nati ainda atima isera. ");
INSERT INTO nou_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Edo Philip Nathanael tambudo uso yei sisira, “Nango embo Moses mi agodari da gaisira edo binga sari embobo daedo gaisera embo awa tambera. Umone Iesu ra Joseph da mei na Nazareth nati embo ra.” ");
INSERT INTO nou_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Setiri Nathanael mi nganega isira, “Ingode Nazareth nati da rora ewamei nei tamberi ta?” Setiri Philip mi mina sisira, “Puio gase.” ");
INSERT INTO nou_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Edo Iesu Nathanael gido uso yei bugutiri uso jawo da sisira, “Emone Israel embobo da embo moka ra. Umo embo biae aera.” ");
INSERT INTO nou_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Setiri Nathanael mi uso yei nganega isira, “Imo na rawodo na gari ri?” Setiri Iesu mi mina sisira, “Philip mi imo jawo sae atiri giti da na imo betora utumo da anumbedo ateso jiro mi buro edo getena.” ");
INSERT INTO nou_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Setiri Nathanael mi sisira, “Atopatari imo awa God da mei na edo imo awa Israel embobo da gitijigari nembodiba ra.” ");
INSERT INTO nou_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Setiri Iesu mi sisira, “Na boroko iso yei setena imo betora utumo da ateso getena awa setena. Awasedo imo na gebe esi ta? Amboda wasiri eiawa derigedo nenei irirari gadesa. ");
INSERT INTO nou_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na iso yei gebe sena utu pirigari God da asisi ewagaewa na God da mei embo isena ainda yei vitido wowosiroro gadesa.” ");
INSERT INTO nou_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Iji etoto atae etiri Iesu da ai awa Cana nati da jimbari bondo da mambusira, Galilee busu da. ");
INSERT INTO nou_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Edo bondo susu mi Iesu de uso ambojimbi de awa oru isira awasedo ungoi mambusera. ");
INSERT INTO nou_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Edo jimbari bondo da embo grape be da ngamo awa indero atae etiri Iesu uso ai mi uso yei sisira, “Grape be da ngamo awa atae etira.” ");
INSERT INTO nou_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Setiri Iesu mi uso yei sisira, “Evetu ro anase awa seose ko naso iji awa bugae ra.” ");
INSERT INTO nou_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Setiri Iesu uso ai mi agipo embobo da yei sisira, “Ro awase sadira awa ewo.” ");
INSERT INTO nou_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Edo Jew embobo ungoda mamoumbogo da tamo segari wasiri awa ambo ambo edo isera awasedo utingi berari 6 awa ainda derido atisera. Edo utingi da awa 100 ta 120 litres umo awodo badira. ");
INSERT INTO nou_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Edo Iesu mi agipo embobo da yei sisira, “Utingi eiawa umo mi dimbuwo beda are.” Setiri umo jojetero utingi beda isera. ");
INSERT INTO nou_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Beda etero Iesu mi ungoda yei sisira, “Umo ou einda nenei awa budo jimbari bondo susu da mambuwo.” ");
INSERT INTO nou_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Setiri budo uso yei mambero umo umo wareregedo ri grape be da ngamo isira awa gambudo gosisira. Edo agipo embobo ungo umo rawainda buriseri awa gosisera te bondo susu awa gae awasedo umo jimbari iu awa jawo sedo uso yei sisira, “Embo berari giti ri grape da be da ngamo ewamei awa giti itoro indido era. Edo amboda esega embobo awa jiwae indoro grape ngamo nei kiambu ewamei awa amboda itido era. Awarate imo nangoda yei ri grape ngamo ewamei awa amboda itesa.” ");
INSERT INTO nou_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Edo wasiri nembodiba Cana nati da Galilee busu da Iesu mi isira awa uso wasiri goroba de ari da tuturo ra. Edo umo wasiri goroba de eiawa etiri uso ambojimbi uso wasiri da usasa awa gido umo gebe isera. ");
INSERT INTO nou_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Edo jimbari bondo atae etiri Iesu uso ai de nanonamendi de ambojimbi de Capernaum nati da mambudo iji tupo ainda atisera. ");
INSERT INTO nou_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Edo Jew embobo da jarusegari bondo da iji awa asusuburiri gido Iesu Jerusalem nati da mambusira. ");
INSERT INTO nou_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ainda bugudo umo Jew embobo da tumondebain ari oro da mambudo embo rorou itari wo oxen de sheep de gumbara de ori ero gosisira. Edo umo daedo embo gano mina ita ise ungoda tendeba be da atero gosisira. ");
INSERT INTO nou_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gido esi mi ituka mendo da digido wo mane berari awa ondetiri Jew embobo da tumondebain ari oro awa dodo wowosisera. Edo ganu mina ita isera ainda tendeba jigido kapotegetiri ungoda ganu sibereberega isira. ");
INSERT INTO nou_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Edo embo gumbara ori isira ainda yei sisira, “Budo dodo ponda mambu. Naso Mama da mando awa awo ingoda ori garori ari yei eure.” ");
INSERT INTO nou_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Setiri uso ambojimbi jiwari mi sisira awa kotemburisira. Edo jiwari mi sira, “O God naso dubobari iso oro da awa teta riawo mi naso jo da ewarago ira.” ");
INSERT INTO nou_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Edo umo awa setiri Jew embobo da gitijijigegari mi uso yei mina sedo nganega isera, “Wasiri goroba de ro aso nango gido gebe God mi sira awa inemi nango da tumondebain ari oro da wasiri awodo esa awa nango gebe eri?” ");
INSERT INTO nou_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Setero Iesu mi mina sisira, “Ingo God da oro eiawa arasegadewa awa iji tamonde de jigano sekago eradira.” ");
INSERT INTO nou_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Setiri ungo ge bebegae sise sisera, “Nangoda mamoumbogo gaeko 46 joda Jew embobo da tumondebain ari oro eiawa isera. Edo imo kotesa iji tamonde de inemi sekago jigaso ereita?” ");
INSERT INTO nou_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Awarate oro Iesu sisira awa uso tamo ra. ");
INSERT INTO nou_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Awasedo amboda Iesu bebetisira ainde God mi umo etiri eriri uso ambojimbi uso ge awa kotemburisera. Edo ungo ge eiawa gebe ise edo jiwari awa gebe gosisera. ");
INSERT INTO nou_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Edo Iesu umo Jerusalem atise jarusegari bondo iji de embo jiwae uso wasiri goroba de ira awa gido umo gebe isera. ");
INSERT INTO nou_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Awarate Iesu embo ro kotera awa gido gido umo embo jiwae isera ainde daedo tatae isira. ");
INSERT INTO nou_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Edo umo embo nenei da yei embo rawodo iri awa nganega ae doturisira ainda be awa umo umosuka embo da kotari rawodo iri awa gosira awasedo. ");
INSERT INTO nou_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Embo Nicodemus awa Jew embobo da gitijigari ra. Edo umo awa Pharisee embobo da embo nei na. ");
INSERT INTO nou_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tumba da umo Iesu da yei mambudo uso yei sisira, “Atopatari nango gosera imo awa atopatari God mi itiri bugusesa ko God embo ainde atae awa embo awa mana wasiri goroba de awa mana adira.” ");
INSERT INTO nou_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Edo umo awodo setiri Iesu mi uso yei sisira, “Na iso yei gebe sena embo ave wasiri seka kumbae adira teta embo tini da edo seka bugarago adira embo awa mana God mi umo gitijigadira iji awa gadira.” ");
INSERT INTO nou_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Setiri Nicodemus mi mina sisira, “Edo embo uso ai da tini da sekago torari edo amimi umo sekago bae etita?” ");
INSERT INTO nou_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Setiri Iesu mi mina sisira, “Na iso yei gebe sena embo da ainda ai mi umo tuturo da badira te amboda embo awa Asisi Kotopu da wasiri seka kumbae adira teta embo tini da edo seka bugarago adira awa umo mana God da gitijigari yei da mana toradira. ");
INSERT INTO nou_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Embo da uso aimamo ga mi embo da tamo da wasiri itido era te Asisi Kotopu mi embo da joda toruri umo wasiri seka kumbudo ira. ");
INSERT INTO nou_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Edo na iso yei sena wasiri seka kumbuio teta embo tini da edo seka bugarago adira sena awa kove eose. ");
INSERT INTO nou_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bisara umo yei dipapa ira ainda sumbudo ira edo imo uso javi awa ingesa te imo umo rawainda tuturo edo sumbiri edo yei rawainda mambutiri awa imo gaera. Da awodo Asisi Kotopu wasiri edo ira. Ingodena Asisi Kotopu mi embo nei amenda wasiri seka iteiri awa gaera.” ");
INSERT INTO nou_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Edo umo awodo setiri Nicodemus mi uso yei nganega isira “Wasiri emomo rawodo eiri?” ");
INSERT INTO nou_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Setiri Iesu mi mina sisira, “Imo awa Israel embobo da atopatari nembodiba ra. Edo imo na ro sena mo gadi jaresi ta? ");
INSERT INTO nou_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Edo na iso yei gebe sena ro nango nangoda jiro mi gosera edo nangoda diti mi gosera awa nango ingoda yei sera awarate ingo embo berari awa nangoda binga awa ujo ae ewa. ");
INSERT INTO nou_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Edo na iso yei ro busu da edo ira awa sano imo na gebe ae adesa edo na iso yei ro utu da ira awa sano mo imo rawodo na gebe esi? ");
INSERT INTO nou_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na nasuka God da mei embo isena awa utu dodo busu da wowosisena. Edo amboda na sekago utu da vitadena. ");
INSERT INTO nou_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Edo Israel embobo yei ro atae da atero Moses mi jingabu kevedo ituka da itido jigiri vivitisira da awodo God da mei embo isira awa ungomi jigoro vitadira. ");
INSERT INTO nou_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Edo ungomi umo jigoro vitari embo amemi umo gebe adira awa wasiri natopo atari badera. ");
INSERT INTO nou_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God busu berari da embo dubo be burisira awasedo umo uso mei awo da awa itiri bugusira. Edo embo amemi umo gebe adera awa mana riawo matawa eudo ira ainda toradira te wasiri natopo atari badera. ");
INSERT INTO nou_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God uso mei awa busu berari da embo awa kasarase itae bugae ra te soregarase ititisira. ");
INSERT INTO nou_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Embo ave God da mei gebe edo ira awa God mi mana kasadira te embo ave gebe ae edo era awa God mi matu kasetira ainda be awa embo awa God da mei awo da awa gebe ae etira awasedo. ");
INSERT INTO nou_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Edo kasari bugudo ira ainda be re eire. Usasa busu berari da embo da yei bugusira te embo usasa ujo ae edo umenga da atari dipapa isera ainda be awa ungo iji berari wasiri bebegae edo era awasedo. ");
INSERT INTO nou_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Embo ave wasiri biae edo ira awa usasa ujo ae edo ira edo usasa da purae edo ira ainda be awa embo awa uso wasiri bebegae awa isaga ari ujo ae edo ira awasedo. ");
INSERT INTO nou_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Awarate embo ave ro gebe awa edo ira awa embo awa usaga da bugudo ira edo God mi ro arase dipapa ira awa ira awa embo mi gorase sedo.” ");
INSERT INTO nou_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ainda amboda Iesu uso ambojibi de Judea busu da mambusera. Edo ungo ainda iji tupo atero Iesu umo mi embo ewamei isira. ");
INSERT INTO nou_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Edo Herod John gajari oro da itae atiri John umo mi embo ewamei isira daedo. Edo John umo nati Aenon nati Salim aikambu mambusira ainda be awa umo jiwae atira awasedo. Edo embo John mi ungo umo mi ewamei orase bugudo isera doae. ");
INSERT INTO nou_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Edo John da ambojimbi nenei mi Jew embo de Jew embobo da tei ingo segari da agodari da ge bagisera. ");
INSERT INTO nou_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Awasedo ungoi John da yei mambudo sisera, “Atopatari embo inemi Jordan umo be nei da soregari embo sisesa amimi umo mi embo ewamei ira edo embo berari uso yei mambutera.” ");
INSERT INTO nou_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Setero John mi mina sisira, “Rora berari ro embo da yei bugudo ira awa God mi uso yei itido ira. ");
INSERT INTO nou_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Edo ingo ingosuka gosewa na ingoda yei ro sisena awa na awa soregari embo God mi itari bugarase sisira awa ae rate God mi na uso emboro sia anase itiri bugusena. ");
INSERT INTO nou_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Edo jimbari iu mi evetu jimbira awa evetu awa embo ainda topo ra. Edo jimbari iu ainda otao awa iaviri etira ainda be awa iu awa evetu seka tambira awasedo. Da awodo na iaviri ena ainda be awa embo berari awa Iesu da yei mambutera awasedo. ");
INSERT INTO nou_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Edo umo awa embo nembodiba irirari edo na awa embo kiambu adena. ");
INSERT INTO nou_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Embo da utu dodo busu da wosedo edo embo berari busu da atera awa dodo derigadira ainda be awa embo busu da atira awa rora busu da atira ainda ge awa sedo ira. ");
INSERT INTO nou_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Edo embo utu dodo busu da wosedo edo umo ro utu da gosise edo ingido ira awa sedo ira te embo jiwae be mi uso binga awa ujo ae edo era. ");
INSERT INTO nou_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Edo embo amemi uso binga awa budo era awa God awa ge be awa tambudo era. ");
INSERT INTO nou_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Edo embo ave God mi ituri bugudo era awa God da ge awa sedo ira ko God mi umo awa Asisi Kotopu mi sirido ira awasedo. ");
INSERT INTO nou_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","God mi uso mei dubo budo edo rora berari gitijigarase ititisira. ");
INSERT INTO nou_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Edo embo ave mei ge be adera awa wasiri natopo atari badera te embo ave mei ujo ae adera awa mana wasiri natopo atari badera. Edo umo mei ujo ae adira awa God da tini gambari awa uso yei natopo atadira.” ");
INSERT INTO nou_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pharisee embomei binga ingisera, Iesu mi umo mi embo ewamei iri uso ambojimbi awa jiwae edo John da ambojimbi derigetira awa ingisera. ");
INSERT INTO nou_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Awarate Iesu umo umosuka embo umo mi ewamei ari ae ra te uso ambojimbi mi era. ");
INSERT INTO nou_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Edo Iesu embo mi ro sera awa ingido Judea busu awa dodo engenebedo Galilee busu da mambusira. ");
INSERT INTO nou_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Edo Galilee busu da mambari emboro awa Samaria busu da awodo diugedo mambari ra. ");
INSERT INTO nou_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Edo Iesu umo Samaria busu awa sembuse umo Sychar nati da bugusira. Edo nati eiawa Jacob mi uso mei Joseph da busu ititisira awa aikambu. ");
INSERT INTO nou_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Edo Jacob da umo koto ngambari awa ainda atima isira edo ainda waiko soropu da Iesu yei ribori be pepeta edo bugusira awasedo begogo etiri umo koto ngambari demoda anumburisira. ");
INSERT INTO nou_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Edo Samaria busu evetu da awa umo dimbadi bugiri Iesu mi evetu ainda yei sisira, “Na umo itigae indane.” ");
INSERT INTO nou_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Edo Iesu umo umosuka ainda anumbedo atisira edo uso ambojimbi awa indari ori ari yei da indari ori adi mambusera. ");
INSERT INTO nou_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Edo Iesu evetu ainda yei umo nganega etiri evetu awa kove be isira ainda be awa Jew embomei de Samaria busu embomei de awa gitopo mina ara edo era awasedo. Edo evetu amimi Iesu da yei sisira, “Na awa Samaria busu evetu ra edo imo awa Jew embo ra edo ro edo imo naso yei ge sesi?” ");
INSERT INTO nou_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Setiri Iesu mi mina sisira, “Imo rora kando ewamei God mi iso yei itadi dipapa ira awa gido edo na embo amemi iso yei umo embo seni awa gido re imo naso yei sedo gaso iso yei boroko umo evevegari sago ae umo awa itae etena.” ");
INSERT INTO nou_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Edo Iesu awodo setiri evetu amimi sisira, “Umo koto re tu be tu da ra edo imo umo dimbari rora ae ra. Edo umo evevegari sago ae emomo rawainda besi? ");
INSERT INTO nou_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Edo nangoda umbogo Jacob mi umo koto emone ngambusira. Edo umo de uso memei de uso wo mane de awa umo eiawa indisera. Edo umo inemi itadesa amimi mana Jacob mi nangoda umo ititisira awa derigadira.” ");
INSERT INTO nou_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Edo evetu awa awodo setiri Iesu mi mina sisira, “Embo ave umo eiawa indadera awa sekago umo ujo adira te embo ave umo nanemi itadena awa indadera awa mana umo ujo sekago tambadera. ");
INSERT INTO nou_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Edo umo nanemi itadena amone wasiri natopo atari ra. Edo wasiri natopo atari nanemi itadena amone embo da jo da teta umo uriri iji berari busu tu da vitido ira da awodo ra.” ");
INSERT INTO nou_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Edo Iesu awodo setiri evetu mi sisira, “Atopatari umo awa naso yei itigae. Edo imo umo awa naso yei itadesa awa na mana sekago umo dipapa adena. Edo na umo ujo ae ari gido einda mana sekago umo dimbadi mana bugadena.” ");
INSERT INTO nou_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Edo evetu awa awodo setiri Iesu mi uso yei sisira, “Mambuio iso iu budo sekago einda engenembase.” Setiri evetu amimi sisira, “Na iu aera.” ");
INSERT INTO nou_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Setiri Iesu mi mina sisira, “Imo sesa imo iu ae awa imo gebe setesa ko imo matu iubono da da jimbuse bugudo ingo da isesa edo embo imo boroko daga atesa awa iso iu aera. Awa imo gebe setesa.” ");
INSERT INTO nou_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","20","Edo Iesu awodo setiri evetu mi mina sisira, “Embo na boroko gosena imo awa God da binga sari embo ra. Edo naso Samaria busu da ewowo mamatu awa God doriri einda tumondebain edo isera te ingo Jew embobo mi sedo ewa Jerusalem nati da nango God tumondebain orase sedo ewa.” ");
INSERT INTO nou_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Edo evetu awodo setiri Iesu mi uso yei sisira, “Evetu na gebe eio, iji bugutira ainde embo mi mana God awa dorir einda edo Jerusalem nati da ta awodo tumondebain adera. ");
INSERT INTO nou_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Edo ingo Samaria busu embobo awa ingo ave tumondebain evi awa ingo gae ra te nango Jew embobo awa nango embo ave tumondebain eri awa gosera ainda be awa soregari embo awa Jew embo nei na. ");
INSERT INTO nou_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Awarate iji bugira edo iji amboda bugadira ainde awa embo amemi jo uso berari mi God tumondebain adira awa asisi ungoda mi berari tumondebain adera. Edo embo emone God mi umo tumondebain orase dipapa ira awa ra. ");
INSERT INTO nou_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God awa asisi ewamei ra awasedo embo mi asisi ungoda mi umo tumondebain adera.” ");
INSERT INTO nou_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Edo Iesu awodo setiri evetu mi uso yei sisira, “Na gosena Keriso soregari embo God mi itari bugarase sisira awa bugadira. Edo umo bugudo iji ainde unemi ingodena berari da yei rora berari awa sari gadera.” ");
INSERT INTO nou_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Edo evetu awodo setiri Iesu mi mina sisira, “Embo imo amende sesa amone namona. Na iso yei ge sena embo re awara.” ");
INSERT INTO nou_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Edo Iesu evetu ainda yei awodo siri uso ambojimbi engeneburisera. Edo ungo engenembedo umo evetu ga ge siri gido ungo kove be isera. Te ungo umo ro dipapa isiri edo umo evetu ainda yei ge ro edo siri awa nganega ari ujo ae isera. ");
INSERT INTO nou_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Edo evetu awa uso utingi ainda dodo nati nembodiba da engenembedo mambudo embobo da yei sisira, “Embo da mi na matu ro ewona awa setiri getena pou umo gave. Edo ingo kotewa embo awa God mi soregari embo itari bugarase sisira awa ta rora?” ");
INSERT INTO nou_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Awasedo umo awodo setiri ungoi berari nati nembodiba awa dodo Iesu da yei mambusera. ");
INSERT INTO nou_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Edo evetu awa nati da mambutiri uso ambojimbi mi Iesu da yei sisera, “Atopatari indari indi.” ");
INSERT INTO nou_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Setero umo mina sisira, “Naso indari indadena amone atira te awawa rori awa ingo gae ra.” ");
INSERT INTO nou_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Setiri ambojimbi mi mina sara isera, “Embonei mi uso yei indari budo bugeri ta?” ");
INSERT INTO nou_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sero ge awa ingido Iesu mi ungoda yei sisira, “Na embo amemi itiri bugusena awa kera adena edo unemi ro anase ititisira buro awa atae adena. Edo na awodo adena awa naso indari adira. ");
INSERT INTO nou_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Edo ingo ingosuka sedo ewa, ‘Kariga 4 atae ari iji ainde awa ingodenaso indari sari ari ingode indari be badera.’ Edo ingo awodo sedo ewa te na ingoda yei sena indari buro da awa gido gogo ewo ko indari awa sari edo bawase sia etira. ");
INSERT INTO nou_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Edo indari be sari etira awa teta busu da embo ingo mi naso yei budo bugawase simba edo era da awodo ra. Edo embo amemi dada adira awa mina ewamei badira. Edo umo embomei awa budo naso yei bugari wasiri natopo badera. Edo embo ave gowuri edo embo amemi dada edo ira embo etoto awa iaviri adera. ");
INSERT INTO nou_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Embo mi eiawa sedo era, ‘Embo da mi gowuri edo embo nei mi dada edo ira.’ Ge awa gebe ra. ");
INSERT INTO nou_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nanemi ingo buro da ainda iteno mambewa ingo matu ainda buro ae ra te ainda dada awase iteno mambewa. Embo nenei mi God da ge awawa atopapotisera te ingo amboda bugudo kondade etewo ge ainda be awawa gosisera. Edo ingo awodo isewa awawa teta embo buro da indari dada edo era awodo isewa. ");
INSERT INTO nou_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Edo Samaria busu embo jiwae nati nembodiba ainda atima isera amimi Iesu gebe isera ainda be awa evetu amimi sisira, “Unemi na matu ro ewona awa setiri getena.” ");
INSERT INTO nou_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Awasedo Samaria busu embobo mi Iesu da yei bugudo daedo atarase sisera. Edo ungomi sedo getero Iesu ainda iji etoto atisira. ");
INSERT INTO nou_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Edo embo jiwae Iesu da binga ingido umo gebe isera. ");
INSERT INTO nou_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Edo ungo mi evetu ainda yei sisera, “Nango inemi ro setesa awa gido Iesu awa gebe ae rate nango Iesu awa gebe era awa nango nasuka Iesu da ge ingera amimi gera awa umo awa busu da embobo da soregari embo ra.” ");
INSERT INTO nou_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Edo Iesu iji etoto yei ainda atiko Iesu yei awa dodo busu Galilee da ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Edo umo nati awa doadi ise Iesu mi sisira, “Binga sari embo da busu topo embo awa umo sapo ae edo era.” ");
INSERT INTO nou_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Edo umo Galilee busu da bugiri embo mi umo atega isera ainda be awa ungo Jerusalem jarusegari bondo da mambudo Iesu umo ro bondo iji de etiri gosisera awasedo. ");
INSERT INTO nou_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Edo Iesu umo Galilee busu da edo Cana nati da sekago mambusira nati umo etiri wareregedo grape be da ngamo isira ainda. Edo gitijigari nati ainda esega ira ainda mei awa karu edo betadi aikambu isira. ");
INSERT INTO nou_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Edo gitijigari awa Iesu Judea busu awa dodo Galilee busu da bugutira awa binga ingido Iesu gadi mambusira. Edo umo uso yei mambudo Iesu Capernaum nati da mambudo uso mei betadi aikambu ira awa ari ewamei arase sisira. ");
INSERT INTO nou_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Edo Iesu mi uso yei sisira, “Imo nanemi ari wasiri goroba de ano gae edo imo mana na gebe ae etesa.” ");
INSERT INTO nou_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Setiri gitijigari mi sisira, “Atopatari naso mei betae atira aingo de nangae pogae.” ");
INSERT INTO nou_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Setiri Iesu mi uso yei sisira, “Mambuio iso mei ewamei etira.” Edo Iesu awodo setiri embo awa Iesu da ge awa ge be edo gido umo mambusira. ");
INSERT INTO nou_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Edo embo awa uso nati da mambutiri embo ainda agipo embobo mi umo tambudo sisera, “Iso mei ewamei etira.” ");
INSERT INTO nou_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Setero embo amimi nganega isira iji nonde uso mei ewamei etiri awa nganega isira. Nganega etiri ungoi mina sisera, “Sipe ongobo awodo yauya umo dotiri umo ewamei iutara.” ");
INSERT INTO nou_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Edo mei ainda mamo kotemburisira iji ainda Iesu mi uso yei sisira uso mei ewamei etira awasedo embo ainde uso orobe berari de awa Iesu gebe isera. ");
INSERT INTO nou_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Edo Judea busu awa dodo Galilee busu da bugusira edo Iesu boroko iji einde awa ari wasiri goroba de etoto isira. ");
INSERT INTO nou_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Einda amboda Iesu engenembedo Jerusalem nati da mambusira ainda Jew embobo awa bondo da iji gido bondo ero. ");
INSERT INTO nou_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Edo Jerusalem nati ponda awa puga mi jiroroka ari ra edo be da ainda jawo awa wo sheep da be ra. Edo be demo da awa umo jiroroka ari Hebrew ge mi sedo era Bethesda. Edo umo awa jiroroka ari awa tendeba 5 awodo ra. ");
INSERT INTO nou_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Edo karu embobo jiwae be diti guba ari tei ingo ambari embobo edo embo pepeta ari sago egeregae de awa tendeba ainda paposigedo atima isera. Edo ungo ainda paposigedo simba atima isera umo awa wasiri arase ainda be awa iji dada asisi mi euri awa edo isira. Edo umo wasiri irirari embo amemi umo ainda wosadera awa sekago ewamei adera. ");
INSERT INTO nou_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Edo embo da awa gaeko 38 karu edo atima isira awa ainda pasido atisira. ");
INSERT INTO nou_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Edo Iesu embo awa pasido atiri gosisira edo embo awa gaeko tupo atae karu edo atima isira awasedo uso yei nganega isira, “Imo sekago ewamei adi dipapa esi ta?” ");
INSERT INTO nou_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Setiri karu embo amimi mina sisira, “Atopatari sasaka eiawa wasiri edo ira awa embo mi na kondade oro umo da wosane sae edo era. Edo na wosadi jarono embo nei mi na derigedo edo giti wosedo era.” ");
INSERT INTO nou_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Edo embo awa awodo setiri, Iesu mi uso yei sisira, “Erido iso ewari besi budo edo pepeta eio.” ");
INSERT INTO nou_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Edo Iesu awodo setiri burigi be embo awa ewamei isira. Edo umo ewamei edo uso ewari besi budo pepeta adi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Edo wasiri eiawa isira iji awa Jew embomei da tumondebain ari iji de isira awasedo Jew embobo da babojegari mi Iesu mi etiri ewamei isira embo ainda yei sisera, “Imo iso besi budo pepeta esa amimi nangoda agodari bejetesa ko boroko awa mamaso ari iji ra.” ");
INSERT INTO nou_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Edo ungo awodo setero embo amimi mina sisira, “Embo na etiri ewamei etena amimi naso besi budo pepeta anase setiri ena.” ");
INSERT INTO nou_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Setiri ungomi uso yei nganega isera, “Embo mo amemi eiedo asase setiri?” ");
INSERT INTO nou_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Awarate embo Iesu mi etiri ewamei isira awa Iesu mo averi awa gae ainda be awa Iesu embo jiwae be da teda awasedo. ");
INSERT INTO nou_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Edo amboda Iesu embo awa Jew embobo da tumondebain ari oro da tambudo uso yei sisira, “Naso ge ingio imo awa ewamei edo atesa awasedo iso wasiri biae awa jamo eio. Edo imo iso wasiri biae awa jamo ae adesa awa wasiri biae nembodiba mi iso karu matu awa derigadira.” ");
INSERT INTO nou_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Edo umo awa setiri embo awa dodo mambudo Jew embobo da gitijijigegari da yei mambudo embo amemi umo etiri ewamei isira embo awa Iesu ra sisira. ");
INSERT INTO nou_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Edo umo ungoda yei awa setiri ungoi Iesu buro awa isira tumondebain ari iji de embo etiri ewamei isira awa bekuba isera. ");
INSERT INTO nou_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Awarate Iesu mina ungoda yei sisira, “Naso Mama awa iji berari buro ira awasedo na daedo naso buro awa mana jamo adira.” ");
INSERT INTO nou_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Edo umo awodo setiri Jew embobo da gitijijigegari umo doro betarase dipapa isera ko ungomi sisera umo tumondebain ari iji da wasiri awa ambo ambo ae ira edo ko umo sira God awa uso mamo edo umo sira umo awa God ga da inono na. ");
INSERT INTO nou_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Edo Iesu ungoda bekuba isera ainda mina awa sisira, “Na ingode yei gebe sena mei mana uso kotari buro awa ambo ambo ise adira. Ro uso Mamo mi iri gosira awa umone ira. Ro Mamo mi ira da awodo awa mei da awodo ira. ");
INSERT INTO nou_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Edo Mamo uso mei dubo budo ira awasedo ro umo umosuka ira awa uso mei da yei isaga edo ira. Awarate umo wasiri nenei embo etiri ewamei etira awa derigedo adira awa uso mei mi arase itari bugadira. Edo eiawa irirari gido ingo kove be adewa. ");
INSERT INTO nou_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Edo Mamo bebetegari jigari eroro wasiri de atorase itido ira da awodo mei umo amenda yei wasiri itari dipapa adira ainda itadira. ");
INSERT INTO nou_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Edo Mamo umo umosuka embo kasae ra te uso mei de da embo kasarase goroba ari ititisira. ");
INSERT INTO nou_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Edo Mamo awodo edo ari embo mi mei sapo adera teta ungo Mamo sapo edo era da awodo. Edo embo ave mei sapo ae edo era awa Mamo umo itiri bugusira awa sapo ae edo era. ");
INSERT INTO nou_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na ge be sena, embo ave naso ge ingise amemi na itiri bugusena awa gebe edo ira embo awa gebe ira iji ainde wasiri natopo atari budo ira edo God mi mana umo kasadira. Edo uso asisi awa teta bebetisira da awodo rate boroko wasiri seka bugira. ");
INSERT INTO nou_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na ingoda yei gebe mi sena. Embo de evetu de boroko atera awa teta bebetegari embobo da awodo rate iji bugadira iji ainde ungomi God da mei da ge ingadera. Edo ungo mi uso ge ingise ungo sekago wasiri de eradera. ");
INSERT INTO nou_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Edo Mamo awa wasiri da susu na da awodo Mamo mi uso yei goroba ari itari edo mei awa wasiri itari susu etira. ");
INSERT INTO nou_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mamo mei da yei kasari da goroba awa itira ainda be awa umo awa God da mei awa embo isira. ");
INSERT INTO nou_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","“Edo iji bugutira iji ainde embo bebetegurisera awa uso ge da javi ingido edo ungoda uje dodo eririgadera. Edo iji ainde awa ari gido kove eove. Embo ave ewamei ewora awa erido wasiri de atadera te embo ave biae ewora awa eroro God mi ungo kasadira. ");
INSERT INTO nou_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na naso goroba mi mana buro da ro adena. Edo na embo kasae giti da awa Mamo da yei sedo gido ena. Sedo gido awa kasedo ena. Edo naso kasari awa ewamei na ainda be awa na naso dipapa awa adi jarae rate embo amemi na itiri bugusena amimi dipapa ira awa edo ena. ");
INSERT INTO nou_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Na ingoda yei na rawodo ri awa sadena awa ingo na gebe adi ae ra. ");
INSERT INTO nou_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Awarate embo nei mi ingoda yei na rawodo ri awa gebe siri gosewa awa God ra. Na gosena naso jawo da ro sira amone ge be ra. ");
INSERT INTO nou_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Ingo ingoda agipo embobo John da yei na rawodo ri awa nganega orase itewo mambusera. Awodo da naso ge be awa gosisewa. ");
INSERT INTO nou_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Awarate embo mi naso jawo da ro sira amone inono aera te nanemi ingoda yei na sena John ingoda yei naso jawo da ge sisira amone ge be ra edo ingo na gebe adewa awa God mi ingo soregadira awa ruvegeove sena. ");
INSERT INTO nou_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John ingoda yei ge sisira awa teta usasa nembodiba da awodo ra. Iji tupo ingo iaviri etewa ainda be awa be usasa nembodiba etira awasedo. ");
INSERT INTO nou_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Awarate rora nei mi na rawodo ri awa gebe sedo John da ge awa derigurira. Naso ari wasiri goroba de nanemi ena emimi na averi ena awa isaga ira. Edo wasiri goroba de emimi gebe ira awa Mamo mi na itiri bugusena. ");
INSERT INTO nou_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Edo Mamo na itiri bugusena uso dombu awa ingo gae edo uso ge javi awa ingo ingae rate umo daedo na averi awa be isaga edo ira. ");
INSERT INTO nou_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Awarate ingo God da ge ingae ewa ainda be awa na embo God mi ingoda yei uso binga de itiri bugusena awa ingo ge be ae ewa. ");
INSERT INTO nou_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ingo jiwari awa ajigedo ewa ainda be awa ingo kotewa wasiri natopo atari rawodo badevi awa kotewa. Edo jiwari mi namomo averi awa ujugurira ");
INSERT INTO nou_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Awarate ingo naso yei purirowo nanemi wasiri natopo atari itano bae dodo edo ewa. ");
INSERT INTO nou_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Na embo mina jasiga orase eura ae ra. ");
INSERT INTO nou_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na ingo gari ra. Na gari God da dubo bari awa ingoda jo da atae ra. ");
INSERT INTO nou_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na ingoda yei God da jawo da bugusena te ingo na ujo ae edo ewa. Edo iji amboda embo nei uso jawo topo da bugadira awa ingo mana embo awa ujo ae adewa. ");
INSERT INTO nou_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ingo awa embo mi ingo awa jasiga orase dipapa edo ewa te God mi ingo dipapa arase awa ujo ae edo ewa. Edo ingo ari awodo edo ewa amimi na gebe ae edo ewa. ");
INSERT INTO nou_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Awarate nanemi ingo awa naso Mama da yei bekuba adi ari ge seove. Moses ingo gebe edo ewa embo re amimi ingo bekuba adira. ");
INSERT INTO nou_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Awarate ingo Moses gebe mi gebe ae etewa awa ingo na gebe ae etewa ko Moses awa naso jawo da ge jiusira. ");
INSERT INTO nou_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Edo ingo ro Moses mi gaisira awa ge be ae edo ewa awasedo ingo na ro sena awa gebe ae ewa.” ");
INSERT INTO nou_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Amboda Iesu Galilee umo diuga awa sembusira daedo sedo era Tiberias umo diuga. ");
INSERT INTO nou_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Edo embo jiwae be umo ambo ambo isera ainda be awa ungomi uso ari wasiri goroba de embo karu egeregari etiri ewamei isira awa gido. ");
INSERT INTO nou_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Edo Iesu doriri da vitido uso ambojimbi de anumburisira. ");
INSERT INTO nou_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Edo jarusegari bondo iji awa aikambu isira. ");
INSERT INTO nou_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Edo Iesu diti pigedo embo jiwae be uso yei bugutero gido Philip da yei sisira, “Ingode indari inono da yei rawainda ori oro embo berari eiawa inderi?” ");
INSERT INTO nou_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Edo Iesu umo umosuka ro adiri awa gosisira te umo sedo gari eiawa Philip da yei umo ro adiri awa gadi sedo ititisira. ");
INSERT INTO nou_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Edo Iesu awodo setiri Philip mi mina sisira, “Na kotena ingode indari K200 mi badera amone embo berari emimi indadera awa inono ae ira.” ");
INSERT INTO nou_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Awarate uso ambojimbi nei Andrew Simon Peter da namendi mi sisira, “Mei kiambu da einda ambe ingari 5 edo wo etoto de ra te emo berari eiawa na kotena mei kiambu einda uso indari de inono ae ta rora.” ");
INSERT INTO nou_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Setiri Iesu mi ambojimbi da yei sisira, “Embo sewo anumbore.” Edo sasawa jiwae ainda atima isira awasedo embo berari anumburisera. Embo berari ainda teda awa embobo 5,000 ra. ");
INSERT INTO nou_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Edo embo anumbetero Iesu ambe budo God da yei ategari itido embo berari ainda anumbedo atisera ainda kando isira. Da awodo umo wo kando isira. Edo embo berari indari ungo dipapa isera awa budo inono isera. ");
INSERT INTO nou_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Edo embo berari indido inono etero Iesu mi uso ambojimbi da yei sisira, “Embo mi ito kato indae dotera awa dada ewo. Ingode mana tepo tapo adera.” ");
INSERT INTO nou_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Awasedo ambojimbi erido embo mi indari indae doturigurisera awa dada edo kandia 12 awa beda isera. ");
INSERT INTO nou_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Edo embo mi Iesu mi ari wasiri goroba de isira awa gido ungomi sisera, “Gebe embo emone God da binga sari embo ingode simba ewora awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Edo ungo awa sero Iesu ungo gosisira ungo Iesu ujo ae irirari dodo umo budo oro ungoda gitijigari nembodiba arase era awa gido umo umosuka doriri inda mambusira. ");
INSERT INTO nou_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ongobo etiri uso ambojimbi umo diuga da wosedo nga da vivitigedo Capernaum nati da mambadi dipapa edo gido ungoi umo diuga awa sembadi tuturo isera. Edo tumba jijirisira te Iesu ungoda yei bugae ra. ");
INSERT INTO nou_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Edo iji ainde bisara nembodiba sumbusira edo umo awa teta ewa yawata ari inge isira. ");
INSERT INTO nou_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Edo ambojimbi ungo davedo 5 ta 6 kilometre awodo edo ungomi Iesu gosisera. Umo umo tamo da pepeta edo nga aikambu bugutiri ungo oju isera. ");
INSERT INTO nou_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Edo Iesu mi ungoda yei sisira, “Amone namone oju eove.” ");
INSERT INTO nou_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Setiri ungo awara setero umo nga da vivitisira. Edo umo nga da vivitisira iji ainde amimi ungo busu ungo mambadi dipapa isera awa burisera. ");
INSERT INTO nou_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iji nei embo jiwae be umo be nei da aitsera awa Iesu eura isera. Edo ungo gosisera Iesu uso ambojimbi ainda bugusira awa edo ungo gosisera Iesu uso ambojimbi umo dodo ungoda nga de mambutitara. ");
INSERT INTO nou_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Awarate Tiberias nati embobo nenei da nga awa bugudo umo bengi da yei Bada mi indari budo ategetiri edo embo mi indisera ainda demo da atisera. ");
INSERT INTO nou_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Awasedo embo jiwae mi Iesu ainda gae edo uso ambojimbi ainda gae edo gido ungomi nga da vivitigedo Capernaum nati da Iesu eura adi sedo mambusera. ");
INSERT INTO nou_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Edo ungomi Iesu umo diuga da be nei da gido uso yei sisera, “Atopatari imo nanjigo einda bugutasi?” ");
INSERT INTO nou_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Setero Iesu mi mina sisira, “Na ingoda yei ge be sena ingo na eura ewa ainda be awa nanemi ingoda yei indari iteno indido inono ititawa awasedo. Awarate ingo naso ari wasiri goroba de awa gido na ge be aera. ");
INSERT INTO nou_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Edo indari atae adira awa sedo buro eove ta wasiri natopo atari da indari awa embo buro ewo. Indari eiawa na God da mei embo isena amimi itadena ainda be awa God Mamo mi naso yei eiawa anase goroba ari ititisira.” ");
INSERT INTO nou_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Awasedo ungomi umo nganega isera, “Nango God oro dubo ewamei arase mo buro ro eri?” ");
INSERT INTO nou_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Setero Iesu mi mina sisira, “God mi embo ingoda yei itiri bugusira awa gebe ewo edo buro re awawa God mi awase dipapa ira.” ");
INSERT INTO nou_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Edo umo awodo setiri ungo mi mina sisera, “Ari wasiri goroba de inemi mo ro esi? Nango ari wasiri goroba de gadera awa nango gebe adera. ");
INSERT INTO nou_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nangoda mamoumbogo ari wasiri goroba de awa yei ro erae da gosisera. Ungo ambe indido isera jiwari mi sira awodo, ‘Unemi ambe utu da edo ituri indido isera.’” ");
INSERT INTO nou_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Edo ungo awodo setero Iesu mi sisira, “Na ingoda yei ge be sena ro Moses mi ingoda yei ititisira awa utu da ambe aera. Naso Mama mi utu da ambe be awa itido ira. ");
INSERT INTO nou_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Edo indari God mi itido ira awa embo utu dodo wosedo busu da embo da wasiri itido ira awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Edo Iesu awodo setiri ungo mi uso yei nganega isera, “Atopatari iji berari indari eiawa nangoda yei itido egae.” ");
INSERT INTO nou_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Setero Iesu mi ungoda yei sisira, “Na awa wasiri be da susu da indari ra. Edo embo indari inono indadira awa umo mana beji tambadira da awodo embo ave naso yei puradira awa mana uso jo da beji tambadira. Edo embo ave na gebe adira awa mana umo ujo tambadira. ");
INSERT INTO nou_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Edo na ingoda yei matu seteno gosisewa ingo na gosise atima ewa te na ge be ae edo ewa. ");
INSERT INTO nou_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","38","Embo berari naso Mama mi naso yei ititira awa naso yei puradera. Edo embo ave naso yei puradera awa nanemi mana ujo ae adena ko na utu dodo wowosisena awa ro God mi anase dipapa ira awa adi. Edo na wowosisena naso dipapa awa adi wosae. ");
INSERT INTO nou_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Edo God na ro anase dipapa ira re eire embo berari naso yei ititisira edo nanemi simba anase dipapa ira gaegae edo munene georase. Edo nanemi iji sangove da jigano erido wasiri natopo atari badera. ");
INSERT INTO nou_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Edo naso Mama awa embo ave na uso mei awa gosise edo ge be edo era awa wasiri natopo atari awa borase dipapa edo ira. Edo amone uso dipapa ra nanemi ungo iji sangove da jigano eradera awa.” ");
INSERT INTO nou_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Edo Jew embobo Iesu da yei dumo ge sadi tuturo isera ainda be awa unemi sisira, “Na awa ambe utu da edo wowosisena.” ");
INSERT INTO nou_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Awasedo ungomi sisera, “Embo emone Joseph da mei na. Nango uso ai de mamo de gari ra. Edo rawodo edo umo boroko siri umo utu da edo wosari siri?” ");
INSERT INTO nou_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Setero Iesu mi ungoda yei sisira, “Ingo ingosuka dumo mina ara eove. ");
INSERT INTO nou_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Embo da mana uso goroba mi naso yei puradira te Mamo na itiri bugusena amimi umo jumbadira awa umo naso yei puradira awa iji sangove da awa nanemi umo jigano erido edo wasiri natopo atari badira. ");
INSERT INTO nou_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Edo binga sari embobo mi gaisera, ‘God mi embo berari atopatadira.’ Edo embo berari God mi atopapotira embobo awa ungo uso ge ingadera awa naso yei puradera. ");
INSERT INTO nou_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Edo na embo mi God gari awa sae ra. Na nasuka utu dodo wowosisena awa Mamo gosisena. ");
INSERT INTO nou_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Edo na ingode yei ge be sena embo ave boroko na ge be ira awa wasiri natopo atari burira. ");
INSERT INTO nou_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na awa wasiri da ambe. ");
INSERT INTO nou_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Edo ingoda mamo umbogo yei ro erae da pepeta isera awa God mi indari itido isira awa indido isera te amboda ungo teta embo berari betedo era da awodo bebetisera. ");
INSERT INTO nou_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Awarate ambe nei God mi itiri bugusira awa embo amemi ambe eiawa indadira awa amimi ari umo wasiri natopo atari badira. ");
INSERT INTO nou_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na awa wasiri ainda ambe da be ra awa utu dodo wowosisena. Edo embo ave ambe eiawa indadira awa wasiri de natopo atadira. Naso tamo awa ambe eire edo nanemi busu berari da embo awa soregadi itadena.” ");
INSERT INTO nou_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Edo Iesu awodo setiri edo Jew embobo tini gambari edo ungo ungosuka ge bagisera. Edo sisera, “Rawodo edo embo eiawa uso tamo awa itari ingode nanemi inderi?” ");
INSERT INTO nou_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Edo ungo awodo setero Iesu mi ungoda yei sisira, “Na ingoda yei ge be sena ingo God da mei bugudo embo isira ainda tamo indae edo uso ororo ingo indae awa wasiri natopo atari awa ingoda jo da mana atadira. ");
INSERT INTO nou_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Edo embo ave naso tamo de ororo de indadira boroko wasiri de natopo atadira. Edo iji sangove de nanemi umo jigano erido mata awodo atadira. ");
INSERT INTO nou_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Naso tamo awa indari be edo naso ororo awa umo be ra. ");
INSERT INTO nou_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Edo embo ave naso tamo indido edo ororo indido adira na uso jo da atinono edo umo naso jo da atadira. ");
INSERT INTO nou_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Edo Mamo atira amimi na itiri bugusena. Edo umo atira awa naso wasiri da susu ra. Da awodo embo ave ge be edo ira awa na umo awa embo betadena edo embo ainda yei awa na awa wasiri da susu adena. ");
INSERT INTO nou_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na awa utu da ambe be ra. Edo na awa ambe ingoda mamo umbogo mi indisera awodo ae ra. Ungo ambe awa indido amboda embo betedo era da awodo bebetegurisera awarate embo ave na umo embo betadena awa gebe adira awa wasiri de matawa atadira.” ");
INSERT INTO nou_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu umo Jew embobo da dada ari oro Capernaum nati da awa esega ise embo da yei ge eiawa atopapotisira. ");
INSERT INTO nou_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesu atopatari awa atae etiri uso ambojimbi jiwae be mi sisera, “Uso atopatari awa nango gari sago ae be era. Amemi uso ge eiawa ingeri?” ");
INSERT INTO nou_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Edo uso ambojimbi mi Iesu da yei sae rate Iesu ungo ge gugumo gagumo mina sara isera awa gido ungoda yei sisira, “Ro nanemi setena emimi iri ingo ge jiwae sise edo tini gambari evi ta? ");
INSERT INTO nou_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Edo na God da mei bugudo embo isena awa sekago utu da engenembedo mambano mo ingo mo ro kotae etevi? ");
INSERT INTO nou_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Edo Asisi Kotopu awa wasiri da susu ra. Edo embo da uso goroba mi mana wasiri be awa mana uso yei itadira te ge nanemi ingoda yei setena amimi emboro rawodo edo wasiri be awa badevi awa ujugurira. ");
INSERT INTO nou_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Awarate ingo embo nenei awa ingewa te ge be ae ewa.” Tuturo be tuturo da awa Iesu embo ave ge be adiri edo embo amemi umo indiga sadi iri amone gosisira. ");
INSERT INTO nou_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Edo Iesu ge nei sisira, “God mi embo da awa naso yei jumbari puradira te embo da ainda uso goroba mi mana naso yei puradira awasedo na ingoda yei ge awa setena.” ");
INSERT INTO nou_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Edo Iesu ge awa setiri uso ambojimbi jiwae be dodo wareregedo umo ambo ambo ae isera. ");
INSERT INTO nou_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Awasedo Iesu uso ambojimbi 12 ainda yei sisira, “Edo ingo giwo ingo daedo na ambo ambo ae doevita?” ");
INSERT INTO nou_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Setiri Simon Peter mi mina sisira “Bada nango imo ambo ambo ae doadera mo amenda yei mamberi? Imo awa embo da wasiri edo inemi wasiri natopo atari awa nangoda yei atopatido esa. ");
INSERT INTO nou_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Edo nango imo gebe era edo nango gosera imo awa God da mei buria ae de ra.” ");
INSERT INTO nou_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Edo Peter awodo setiri Iesu mi mina sisira, “Nanemi ingo embo 12 awa jawo seteno edo na ambo ewa te ingo embo da awa Satan da ambojimbi ra.” ");
INSERT INTO nou_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Edo Iesu ge sisira awa Judas de sisira Simon Iscariot da mei ko Judas awa ambojimbi 12 ainda embo nei na edo amboda awa unemi Iesu indiga sadira. ");
INSERT INTO nou_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Amboda Iesu Galilee busu da pepeta ise tembusira. Edo umo Judea busu da pepeta ari ujo ae isira ainda be awa Jew embobo da gitijijigegari awa umo doro betarase dipapa edo isera awasedo. ");
INSERT INTO nou_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Edo umo awodo iri edo Jew embobo da bondo jawo yagara da bondo da iji awa aikambu isira awasedo Iesu uso nanonamendi mi uso yei sisera, “Yei eiawa dodo Judea busu da mambuio edo iso ambojimbi mi imo buro ro esa awa gore. ");
INSERT INTO nou_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Edo embo da ave embo mi umo gorase dipapa edo ira awa uso buro awa unjugari da ae edo ira. Edo imo ari wasiri jiwae eiawa esa awasedo egae busu da embo berari mi imo ro esa awa gore.” ");
INSERT INTO nou_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Edo uso nanonamendi ge awodo sisera ainda be awa ungo umo gebe ae edo isera awasedo. ");
INSERT INTO nou_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Edo Iesu mi ungoda yei sisira, “Naso iji awa bugae ra awarate imo iji nonde mambadevi amone tepo ra. ");
INSERT INTO nou_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Embo de evetu de ingo ujo ae aera te ungo na ujo ae edo era ainda be awa na ungo wasiri biae era awa sedo ena awasedo. ");
INSERT INTO nou_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Awasedo ingo bondo da mambuwo. Na bondo einda mambadi aera ainda be awa naso iji awa bugae awasedo. Amboda awa na mambadena.” ");
INSERT INTO nou_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Edo Iesu awodo sedo umo Galilee busu da atisira. ");
INSERT INTO nou_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Edo Iesu uso nanonamendi bondo da mambero Iesu daedo amboda mambusira te umo isaga da mambae ra te gae unjugari da mambusira. ");
INSERT INTO nou_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Edo Jew embobo da gitijijigegari bondo yei da umo eura ise sisera, “Umo mo rawari?” ");
INSERT INTO nou_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Edo embo jiwae be ainda atisera amimi ungosuka uso jawo da ge dengoro da mina sara edo isera. Edo embo nenei mi sisera, “Umone embo ewamei na.” Awarate embo nenei mi sisera, “Awodo aera umone embo da yei ge busira.” ");
INSERT INTO nou_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Edo ungo ge dengoro da mina sara isera awa ge unjugari da sisera ko ungo Jew embobo da gitijijigegari awa oju isera. ");
INSERT INTO nou_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Edo bondo soropu da Iesu Jew embobo da tumondebain ari oro da embo atapotadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Edo Jew embobo da gitijijigegari uso ge ingido kove be isera. Edo sisera, “Embo eiawa gari mo rawainda burisiri? Edo umo ingodenaso gari eura edo era yei einda bugae ra.” ");
INSERT INTO nou_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Setero Iesu mi mina sisira, “Na ro atopapotena awa naso atopatari aera. God na itiri bugusena amimi jiro gari eiawa naso yei itiri na atopapotena. ");
INSERT INTO nou_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Edo embo ave God ro dipapa ira awa adi dipapa edo era awa na naso gari topo mi atopapoteni ta ko God mi naso yei atopatari eiawa itiri einde be awa gadera. ");
INSERT INTO nou_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Edo embo awa uso kotari awa atopapotira awa embo nenei mi umo jasiga orase dipapa edo ira awarate embo ave atopapotise edo embo mi God jasiga orase dipapa edo ira embo amone ge be embo edo embo ewamei na. ");
INSERT INTO nou_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ingo berari Moses mi agodari ititisira awa gari ra te ingo berari agodari awa kera ae edo ewa. Ro edo ingo na dawo betanase dipapa evi?” ");
INSERT INTO nou_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Edo Iesu awa setiri embo jiwae be mi uso ge mina sisera, “Asisi biae iso jo da atima ira. Amemi imo dadi dipapa eri?” ");
INSERT INTO nou_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","22","Edo ungo awodo setero Iesu mi mina sisira, “Jew embomei da tumondebain ari iji de na ari wasiri goroba de da isena edo iji ainde ingo kove be isewa. Awarate ingo daedo mamaso iji de buro edo ewa. Ingoda mamo umbogo matu Moses atae iji de atima isera amimi tamo da andiso awa diwari da wasiri awa tuturo isera. Edo Moses daedo setiri ingo ingoda memei da tamo da andiso awa didivegurisewa. Edo ingo mamaso iji de ingoda memei da tamo da andiso diwari awa awara sedo ewa. ");
INSERT INTO nou_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Edo ingo tumondebain ari iji de ingoda memei da tamo da andiso diuse edo ingo Moses da agodari bejae sedo ewa mo roedo ingo na tumondebain ari iji de embo eteno ewamei isira awasedo bekuba evi? ");
INSERT INTO nou_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Edo emboro ingo gosewa awodo da kasove ta emboro God mi kotira awodo da kasewo.” ");
INSERT INTO nou_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Edo Jerusalem nati embo nenei mi sisera, “Embo doro betarase jarera amone eire. ");
INSERT INTO nou_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Edo giu umo embo isaga da atopapotira edo embo mi umo beitigadi jarae dodo era. Edo gitijijigegari embo eiawa God mi itari bugarase sisira awa kotise eri ta? Awodo kotise eri ta rora. ");
INSERT INTO nou_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Awarate embo God mi itari bugarase sisira awa bugadira edo iji ainde ingodena uso nati mo rawari awa gadi aera te ingode na uso nati rawari amone gosera.” ");
INSERT INTO nou_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Edo Iesu umo Jew embobo da tumondebain ari oro da atopapotise umo gogo dimbudo sisira, “Ingo na averi edo naso nati rawari mo ingo mo gari ta? Na naso jawo naso topo da bugae ra. Edo embo amemi na itiri bugusena awa ge be ra. ");
INSERT INTO nou_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Edo ingo umo gae ra te na umo gari ra ainda be awa na unemi itiri bugusena embo awa matu ungae atima isena.” ");
INSERT INTO nou_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Setiri ungoi umo sandadi dipapa isera te uso iji bugae awasedo ungo ungoda ingo mi umo jigari awa jarisera. ");
INSERT INTO nou_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Awarate embo jiwae be ainda atisera awa umo ge be edo sisera, “Embo God mi itari bugarase sisira embo eiawa simba edo ewa edo ingo kotewa uso ari wasiri mi embo einda ari wasiri goroba de awa derigeita?” ");
INSERT INTO nou_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Edo Pharisee embobo mi embo jiwae be Iesu da jawo da ge dengoro da mina sara ero gido, priest babojegari mi isoro embobo itero Iesu bundadi mambusera. ");
INSERT INTO nou_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Edo ungo bugero Iesu mi sisira, “Na ingode iji nei riborigo atadena edo ingo dodo na embo amemi itiri bugusena embo ainda yei engenembadena. ");
INSERT INTO nou_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Edo iji ainde ingo na eura adewa te ingo na mana tambadewa ainda be awa na yei rawainda mambadena ainda ingo mana mambadewa.” ");
INSERT INTO nou_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Awa setiri Jew embobo da gitijijigegari mi sisera, “Umo yei rawainda mambari ingodena umo eura edo umotambadi ae orase siri? Edo Jew embo nenei awa yei nenei da edo embo Jew ae ainda nati da atima isera. Edo Iesu mo nati ounda mambudo embo Jew ae awa atopatadi sita? ");
INSERT INTO nou_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Edo umo sira ingo na eura adewa te na mana tambadewa sira. Edo na yei mambadena ainda ingo mana mambadewa sira. Edo umo awodo sira ainda ge be mo rori?” ");
INSERT INTO nou_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Edo bondo da iji sangove awa be iji nembodiba be ra. Edo iji awa bugiri Iesu erido gogo dimbudo sisira, “Embo ave umo ujo adira awa naso yei puma umo indare. ");
INSERT INTO nou_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Edo jiwari mi sira, ‘Embo ave na gebe adira awa umo uriri mata uso jo da vivitise atadira edo umo uso jo da edo jojadira.’” ");
INSERT INTO nou_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Edo Iesu ge awa sisira awa Asisi Kotopu embo da jo da awa sisira. Edo iji ainde God Asisi Kotopu awa itae ra ainda be awa Iesu betae edo God mi umo jigae erae awarate amboda embo ave Iesu ge be adira awa Asisi Kotopu awa badira. ");
INSERT INTO nou_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Edo embo jiwae be ge awa ingido edo embo nenei mi sisera, “Embo emone God da binga sari embo ra.” ");
INSERT INTO nou_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Edo embo nenei mi sisera, “Umone God mi embo itari bugarase sisira embo awa ra.” Awarate embo nenei mi sisera, “God mi embo itari bugarase sisira embo amone Galilee embo ae ra. ");
INSERT INTO nou_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Edo jiwari mi sira embo God mi itari bugarase sisira embo amone David da orobe ra. Edo uso ai mi umone David atima isira nati Bethlehem ainda ainda burisira.” ");
INSERT INTO nou_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Awasedo embo jiwae be Iesu mo averi awa ge da sae edo kotari ewoga kawoga isera. ");
INSERT INTO nou_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Edo embo nenei umo bundari dipapa isera te ungo ungoda ingo mi umo jigari awa sago ae isera. ");
INSERT INTO nou_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Awasedo isoro embobo engenembedo priest babojegari de Pharisee embobo de da yei mambero ungo mi nganega isera, “Roedo umo budo bugae etevi?” ");
INSERT INTO nou_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Setero isoro embobo mi mina sisera, “Embo emone embo nenei awodo ae ra. Edo embo nenei embo emimi ge sira awodo awa sae edo era.” ");
INSERT INTO nou_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Setero Pharisee embobo mi ungoda yei nganega isera, “Embo amimi ingo gandubetira awase ingo embo awa ge be evi ta rora? ");
INSERT INTO nou_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Edo ingo gitijigari da ta Pharisee embo da ta awa embo awa ge be eoro gido evi ta? ");
INSERT INTO nou_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Edo embobo eiawa ungo Moses da agodari gae awasedo God mi ungo kasadira.” ");
INSERT INTO nou_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Edo Nicodemus awa ungoda teda ainda atisira. Edo embo re unemi matu Iesu gadi mambusira. ");
INSERT INTO nou_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Edo unemi ungoda yei sisira, “Ingodenaso agodari mi sira ingode mana embo kasadera edo bekuba adi ra te giti awa umo ro etiri awa gido awodo adera.” ");
INSERT INTO nou_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Setiri ungo mi sisera, “Imo daedo Galilee busu embo teta Iesu inge ta? Imo mambudo jiwari awa ajigedo gio. Edo ajigedo ainda God da binga sari embo da ave awa inge Galilee busu embo awa mana gadesa gio.” ");
INSERT INTO nou_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Embo berari awa ungoda nati da mambusera te Iesu umo awa Olive doriri da mambusira. ");
INSERT INTO nou_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Edo sipo de umo engenembedo Jew embobo da tumondebain ari oro da mambusira. Edo embo jiwae be umo jiroroka edo anumbetero edo umo ungo atopatadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Edo agodari da atopapotigari de edo Pharisee embomei de mi evetu da awa viro iri tambudo budo Iesu da yei bugusera. Edo evetu awa budo bugudo setero evetu awa embo berari da diti da dederisira. ");
INSERT INTO nou_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Edo ungo mi Iesu da yei sisera, “Atopatari evetu eiawa viro iri tambera. ");
INSERT INTO nou_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Edo Moses mi nangoda agodari jivedo sisira evetu ave viro adira awa ungo mi ganuma mi evetu awa doro betarase sisira. Edo ge eiawa imo rawodo kotesi?” ");
INSERT INTO nou_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Edo ungo awa sisera awa ungo Iesu ungoda ge mi wao edo bekuba adi sedo sisera. Awarate Iesu kukubedo uso ingo soro mi busu da kakari isira. ");
INSERT INTO nou_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Edo umo kakari edo atae edo sekago erido ungoda yei sisira embo ave umo wasiri biae ae gido embo awa evetu ounda yei ganuma giti pigare.” ");
INSERT INTO nou_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sedo umo sekago kukubedo busu da kakari isira. ");
INSERT INTO nou_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Edo embobo ge awa ingido embo ogo da tuturo edo sasainbedo da mamba egisera. Edo ungo berari atae mambero evetu awa ainda derido atisira Iesu de daedo. ");
INSERT INTO nou_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Edo Iesu sekago erido evetu ainda yei sisira, “Evetu embo berari rawari? Ungo berari imo bekuba ari sago ae etera edo ungo imo dodo mamberi ta?” ");
INSERT INTO nou_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Setiri evetu mi mina sisira, “Gebe ungo berari da doae na dodo mambera.” Edo evetu awa setiri Iesu mi sisira, “Na daedo mana imo bekuba adena. Mambuio edo sekago wasiri biae eose.” ");
INSERT INTO nou_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu sekago embo da yei ge sise sisira, “Na awa busu berari da embo da usasa ra. Embo ave na ambo ambo adira awa mana umenga da pepeta adira te usasa mi uso emboro awa jatebadira.” ");
INSERT INTO nou_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Edo umo awodo setiri Pharisee embobo mi uso yei sisera, “Imo imosuka imo averi awa sesa te imone ge busesa.” ");
INSERT INTO nou_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Setero Iesu mi sisira, “Na ge busae ra. Edo na ge ro sena awa na nasuka awa sena te na ro sena amone ge be sena ainda be awa na yei rawainda edo bugusena awa na gari edo na yei rawainda mambutena awa na gari rate ingo na yei rawainda edo bugusena edo yei rawainda mambutena awa ingo gaera. ");
INSERT INTO nou_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Edo ingo na ingoda kotari mi kasewa te na boroko mana ingo kasadena. ");
INSERT INTO nou_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Awarate na boroko ingo kasadena awa naso kasari awa ge be ae etira ainda be awa na nasuka kasae ra te naso Mama na itiri bugusena embo amimi nangae atise na kondade ira. ");
INSERT INTO nou_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Edo ingoda agodari mi sira embo etoto ge ro setera awa dada edo awara setera awa ungo ro sera awa ge be ra. ");
INSERT INTO nou_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Edo na embo averi awa be isaga ena edo Mama na itiri bugusena awa daedo na averi awa be isaga ira.” ");
INSERT INTO nou_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Edo umo awodo setiri ungo mi umo nganega isira, “Iso imamo mo rawari?” Setero Iesu mi mina sisira, “Ingo na gae edo ingo naso Mama gae. Awarate ingo na gadewa awa ingo naso Mama daedo gadewa.” ");
INSERT INTO nou_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Edo Iesu umo Jew embobo da tumondebain ari oro da gano itari tewo da demo da derido atopapotise ge emone sisira. Awarate uso betari iji awa bugae gido ungo mi umo bunda doturisera. ");
INSERT INTO nou_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Edo Iesu sekago ungoda yei sisira, “Na mambutena edo ingo mi na eura adewa te na tambae edo wasiri bebegae ise atima betadewa. Edo ingo mana yei na mambutena ainda mana mambadewa. ");
INSERT INTO nou_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Setiri Jew embobo da gitijijigegari mi sisera, “Umo sira ingo mana yei na mambutena ainda mambadewa sira. Edo umo mo ge mo rorae siri? Umo umosuka dedo betadi sita?” ");
INSERT INTO nou_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Edo ungo awa setero Iesu mi mina sisira, “Ingo awa yei tuda ainda embobo ra te na awa yei inda ainda embo ra. Edo ingo awa busu einda embobo ra. Na awa busu einda embo aera. ");
INSERT INTO nou_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Awasedo na ingoda yei setena ingo wasiri bebegae ise atima bebetegawase setena. Edo ingo ge be ae adewa awa na awa embo sena awa namona edo ingoda wasiri bebegae awa ingode daedo atirari ingo betadewa.” ");
INSERT INTO nou_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Edo Iesu awodo setiri ungo mi umo nganega isera, “Imo mo averi?” Setero Iesu mi mina sisira, “Tuturo da edo bugudo boroko na averi awa seono gosewowa awara. ");
INSERT INTO nou_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Edo ingo wasiri bebegae jiwae ewowa edo nanemi ingo kasari katogo ra edo ingo rora jiwae be atopatano gae etewa te na mana adena ainda be awa embo amemi na itiri bugusena awa ge be edo unemi ro sanase sira na awa sena. Na ge nenei mana sadena.” ");
INSERT INTO nou_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Edo ungo Iesu Mamo da jawo da ge sira awa gae. ");
INSERT INTO nou_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Awasedo Iesu mi ungoda yei sisira, “Amboda ingo na God da mei embo isena awa jigawo erari iji ainde ingo na embo sisena embo awa na awa gadewa. Edo iji ainde daedo ingo mi gadewa na naso kotari mi ge sae rate ro Mama mi na atopapotisira awawa na sisena. ");
INSERT INTO nou_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Edo na itiri bugusena embo awa nangae daedo atima ira ainda be awa na iji berari eono umo dubo ewamei edo ira awasedo.” ");
INSERT INTO nou_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Edo embo jiwae be Iesu rovi ravi eiawa siri ingisera awa ge be isera. ");
INSERT INTO nou_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Awasedo Iesu mi Jew embobo umo ge be isera ainda yei sisira, “Ingo naso atopatari kera adewa awa ingo awa naso ambojimbi be adewa. ");
INSERT INTO nou_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Edo ingo ge be awa gadewa edo ge be mi ingo wujegadira. ");
INSERT INTO nou_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Edo Iesu umo awodo setiri ungo mi mina sisera, “Nango awa Abraham da orobe ra. Edo nango awa embo nenei da agipo aera. Edo inemi setesa ge be mi ingo wujegadira ge ainda be mo rori?” ");
INSERT INTO nou_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Edo ungo awodo setero Iesu mi ungoda yei sisira, “Na ingoda yei ge be sena embo ave wasiri biae adira embo amone wasiri biae da agipo embo ra. ");
INSERT INTO nou_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Edo agipo embo awa mana mamo da mando da matawa atadira te mei mi uso mamo da mando da matawa atadira. ");
INSERT INTO nou_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Edo na God da mei mi ingo wujegadena awa ingo nei ro mi jigadi ae tepo mata awodo atadewa. ");
INSERT INTO nou_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Edo na ingo Abraham da orobe awa gosena te ingo na dawo betanase jarewa ainda be awa ingo naso atopatari awa bari ujo ae ise gido. ");
INSERT INTO nou_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Edo na ro naso Mama mi naso yei etiri gosisena awa ingoda yei sedo ena te ingo ingoda imamo mi ro setiri gosisewa awa edo ewa.” ");
INSERT INTO nou_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Edo Iesu umo awodo setiri ungomi uso yei mina sisera, “Nangoda mama ne Abraham na.” Setero Iesu mi mina sisira, “Ingo Abraham da kinapeina be re buro umo ro isira awa ae etewa. ");
INSERT INTO nou_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Edo na ge be God mi na atopapotisira awa sedo ena edo na ingo ge busari awa atopatae rate ingo na dawo betanase jarewa. Abraham wasiri biae da buro eiedo awa aera. ");
INSERT INTO nou_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ingo awa teta ingoda imamo mane mi edo ira da awodo awa ewa.” Edo umo awodo setiri ungo mi mina sisera, “Nango awa God da kinapeina be ra.” ");
INSERT INTO nou_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Setero Iesu mi ungoda yei sisira, “God awa ingoda imamo be gido re ingo na dubo beowa ainda be awa na God da yei dodo einda bugudo edo boroko einda atena. Na nasuka bugadi kotedo bugae rate God mi itiri na bugusena. ");
INSERT INTO nou_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Edo ro edo ingo na ro sena awa gae jarevi? Ingo gadi jarewa ainda be awa ingo gari ujo ae ewa awasedo. ");
INSERT INTO nou_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Edo ingo awa ingoda imamo binei da kinapeina edo ingo unemi ro awase dipapa ira awa adi dipapa ewa. Tuturo da edo bugudo boroko da awa umo awa embo dari betari embo ra. Edo umo iji berari ge busedo ira ainda be awa uso jo da awa ge be awa atae awasedo. Ge bubusegari mi uso jo awa ato ae edo atira awasedo umo iji berari ge busedo ira. Edo unemi iji berari ge busedo ira ainda be awa umo awa ge busari berari da mamo awasedo. ");
INSERT INTO nou_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Awarate na iji berari ingoda yei ge be sedo ena te ingo na ge be ari dipapa ae edo ewa. ");
INSERT INTO nou_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ingoda teda ainda embo da mi na wasiri biae ari seita? Sari katogo aera. Na ingoda yei ge be sena ro edo ingo na ge be ae edo evi? ");
INSERT INTO nou_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Embo ave uso Mamo awa God re iaviri de God da ge ingido ira. Edo ingo awa God da kinapeina ae gido ingo uso ge ingae edo ewa.” ");
INSERT INTO nou_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Edo umo awodo setiri Jew embobo mi Iesu da yei mina sisera, “Imo awa Samaria busu embo ra aumo na. Edo asisi biae iso jo da atima ira.” ");
INSERT INTO nou_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Edo ungo awodo setero Iesu mi ungoda yei mina sisira, “Asisi biae naso jo da atae ra. Na naso Mama sapo edo ena te ingo na sapo ae edo ewa. ");
INSERT INTO nou_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na embo mi na sapo orase eura aerate God mi ari embo mi na sapo adera edo unemi embo na ujo ae adira awa kasadira. ");
INSERT INTO nou_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Edo na ingoda yei ge be sena embo ave naso binga awa kera adira awa mana yei riawo matawa euse atima ira ainda mana mambadira.” ");
INSERT INTO nou_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Edo umo awodo setiri Jew embobo amimi uso yei sisera “Imo ro setesa awa ingido nango boroko getera asisi biae iso jo da atima ira. Abraham bebetisira edo God da binga sari embobo bebetegurisera te imo sesa embo ave naso binga awa kera adira awa mana betadira sesa. ");
INSERT INTO nou_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nangoda mama Abraham bebetisira. Edo imo mana nangoda mama Abraham derigadesa. Edo God da binga sari embobo berari bebetegurisera. Edo imo kotesa God da binga sari embobo awa inemi deriguresa? Imo ro edo jariga eiedo esi?” ");
INSERT INTO nou_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Edo ungo awodo setero, Iesu mi mina sisira, “Na nasuka jariga adena awa naso ge awa tepo ra. Awarate naso Mama ingo mi ingoda God sedo ewa embo amimi na jasiga ira. ");
INSERT INTO nou_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Edo ingo God gae ra te na umo garira. Edo na umo gae sadena awa na ge busadena teta ingo mi ge busewa da awodo. Awarate na umo gari ra edo na uso ge kera edo ena. ");
INSERT INTO nou_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Edo ingoda imamo Abraham awa naso bugari iji awa gido iaviri isira. Edo na bugadena awa gido jo iaviri isira.” ");
INSERT INTO nou_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Edo umo awodo setiri Jew embobo mi uso yei sisera, “Imo iso gaeko awa 50 bae ra edo imo aso nango mi imo ge be orase arago ise imo Abraham gari sesa.” ");
INSERT INTO nou_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Edo ungo awodo setero Iesu mi mina sisira, “Na ingoda yei ge be sena Abraham uso ai mi bae atiri na atima isena.” ");
INSERT INTO nou_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Edo umo awodo setiri ungo mi ganuma budo umo dadi isera te God mi Iesu apuregetiri embo Iesu umo gari sago ae etiri edo embo da teda awodo pepeta edo mambudo Jew embobo da tumondebain ari oro awa doturisira. ");
INSERT INTO nou_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Edo Iesu umo pepeta ise embo da awa uso ai mi diti guba ari burisira awa gosisira. ");
INSERT INTO nou_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Edo Iesu da ambojimbi mi uso yei nganega isera, “Atopatari embo amenda wasiri biae mi etiri embo eiawa diti guba de ai mi burisiri? Uso ai mamo da wasiri biae mi etiri isita ko uso wasiri biae mi etiri umo diti guba ari awodo ai da tini da wowosisiri?” ");
INSERT INTO nou_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Setero Iesu mi mina sisira, “Uso aimamo ga da ta uso wasiri biae mi ae umo ai mi diti guba ari bara. Uso diti guba awa embo mi God da ari wasiri goroba de mi ari ewamei irirari embo mi gorase sedo uso diti re guba isira. ");
INSERT INTO nou_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Edo iji atira ainde ingode embo amemi na itiri buguseni ainda buro awa ore ko tumba bugutira ainde embo mi mana uso buro awa mana adera. ");
INSERT INTO nou_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Edo na busu da atena awa na awa busu berari da embo da usasa ra.” ");
INSERT INTO nou_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Edo Iesu awodo sedo busu da kosiwa edo kosiwa isira amimi Iesu busu etiri bebeta isira. ");
INSERT INTO nou_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Edo ingo soro mi busu bebeta isira awa embo ainda diti da detiri bebeta etiri uso yei sisira, “Mambuio umo diuga jawo Siloam ainda iso dombu segase.” Edo jawo Siloam ainda be awa unemi umo itiri mambusira. Edo embo awa ainda mambudo uso dombu segisira. Edo engenemburise umo sekago yei isaga gosisira. ");
INSERT INTO nou_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Edo uso otatao de embo ungo matu umo benunu siri gosisera amimi nganega isera, “Embo omomo anumbedo atise benunu sedo ira awa ta?” ");
INSERT INTO nou_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Edo ungo awa setero embo nenei mi sisera, “Gebe embo re awara.” Awarate embo nenei mi sisera, “Awodo aera embo amone awa aera awarate umone embo awa inge ira.” Edo ungo awa setero embo amimi mina sisira, “Namone embo awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Edo umo awa setiri ungo mi umo nganega isera, “Rawodo edo iso diti pirigetiri imo yei sekago gosesi?” ");
INSERT INTO nou_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Setero embo amimi mina sisira, “Embo jawo Iesu mi busu davedo naso dombu da gajedo naso yei siutara, ‘Siloam da mambudo iso dombu segeio.’ Awasedo ainda mambudo naso dombu segutana. Edo segedo awa na sekago yei gosena.” ");
INSERT INTO nou_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Edo embo awa awa setiri ungomi umo nganega isera, “Embo amomo boroko rawari?” Setero mina sisira, “Na gaera.” ");
INSERT INTO nou_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ungo mi embo matu dombu guba ari atinatina awa budo Pharisee embobo da yei mambusera. ");
INSERT INTO nou_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Edo Iesu embo busu davedo etiri embo dombu ewamei isira amone Jew embomei da tumondebain ari iji de isira. ");
INSERT INTO nou_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Edo Pharisee embobo mi embo awa nganega isera rawodo edo uso diti pirigetiri umo yei sekago gosiri awa nganega isera. Edo embo amimi ungoda yei sisira, “Unemi naso dombu da busu itiri edo na naso dombu segedo edo na sekago yei gosena.” ");
INSERT INTO nou_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Edo umo awa setiri Pharisee embo nenei mi sisera, “Embo amemi eiedo iutari amone God da embo aera ainda be awa umo ingodenaso tumondebain ari iji da agodari awa kera ae edo ira.” Awarate embo nenei mi sisera, “Umo embo biae re wasiri awodo re mana ae etira.” Edo ungo awodo setero edo Pharisee embobo ungoda ge da awara ae edo kausu kausu isera. ");
INSERT INTO nou_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Awasedo Pharisee embobo mi sekago embo awa nganega isera, “Embo eiawa iso diti etiri pirigetiri imo yei gosesa mo imo embo amo ave sesi?” Setero mina sisira, “Umone binga sari embo God mi itiri bugutara.” ");
INSERT INTO nou_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Awarate Jew embobo da gitijijigegari awa umo ai da tini da edo diti guba ari wosedo edo boroko yei gari awa ungo gebe ae edo setero uso ai mamo ga bugusera. ");
INSERT INTO nou_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Edo ungo bugero nganega isera, “Mei emomo ingoda ta? Edo umo diti guba ari tini da edo wowosisita? Edo rawodo edo umo boroko yei gosira amomo ge be ta?” ");
INSERT INTO nou_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Setero uso ai mamo ga mi mina sisera, “Nango umo nangoda mei awa gosera edo umo tini da edo diti guba ari bugusira awa gosera. ");
INSERT INTO nou_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Awarate nango umo rawodo edo boroko yei gosiri edo uso dombu amemi etiri pirigetiri awa nango gaera. Umone embo ra. Uso yei nganega edo gi gave. Umo umosuka ingoda ge mina awa sadira.” ");
INSERT INTO nou_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Edo uso ai mamo ga eiedo sisera ainda be awa ungo Jew embobo da gitijijigegari awa oju isera. Edo Jew embobo da gitijijigegari mi matu sisera, “Embobo amemi Iesu awa God mi soregari embo itari bugarase sisira awa itari bugari ge sadera awa nango mi embo awa warawara oro Jew embobo da dada ari oro dodo mambadira.” ");
INSERT INTO nou_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Awasedo uso ai mamo ga mi sisera, “Umone embo ra. Nganega edo gi gave.” ");
INSERT INTO nou_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Edo uso ai mamo ga awodo setero, Pharisee embobo mi setero embo diti guba ari ai da tini da edo wowosisira awa totorisira. Edo umo toriri uso yei sisera, “God da dombu da gebe seio. Nango embo amone wasiri biae embo awa gari ra.” ");
INSERT INTO nou_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Edo ungo awa setero embo amimi mina sisira, “Embo awa wasiri biae embo ta wasiri ewamei embo ta awa na gaera. Edo rora da na gosena awa eire matu awa na diti guba ari edo yei gadi jarima isena te boroko na yei gosena.” ");
INSERT INTO nou_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Edo embo awa awodo setiri ungo mi nganega isera, “Iso yei ro iutari? Rawodo edo iso dombu etiri pirigurari?” ");
INSERT INTO nou_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Setero mina sisira, “Na matu ingoda yei siutana te ingo naso ge ingari ujo ae ititawa. Edo ro edo nanemi sekago sano gadi dipapa evi? Awase ingo uso ambojimbi ari dipapa evi ta rora?” ");
INSERT INTO nou_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Edo umo awodo setiri ungo mi umo isibedo uso yei sisera, “Imone embo ainda ambojimbi ra. Nango re Moses da ambojimbi ra. ");
INSERT INTO nou_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Edo nango gosera God Moses da yei ge sisira awarate embo nei eiawa umo rawainda edo bugusiri awa nango gaera.” ");
INSERT INTO nou_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Edo ungo awodo setero embo amimi mina sisira, “Na kove be ena. Ingo umo yei rawainda edo bugusiri awa ingo gae sewa te umo naso diti etiri pirigetira. ");
INSERT INTO nou_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Edo ingodena gari God embo wasiri bebegae edo era ainda ge ingae edo ira te umo embo umo sapo ise ungo ro orase dipapa ira awa edo era ainda ge ingido ira. ");
INSERT INTO nou_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Edo rora berari ae atisira ainda edo bugudo boroko da embo da amemi embo ai da tini da edo diti guba bugari awa sekago yei gari awa embo da amemi gae. ");
INSERT INTO nou_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Awasedo God mi embo eiawa itae bugae re umo mana ari wasiri eiedo awa mana ae etira.” ");
INSERT INTO nou_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Edo umo awodo setiri ungo mi mina sisera, “Imo iso inyei mi burisira iji ainda edo bugudo boroko da imo awa wasiri biae embo ra. Edo imo nango atopatadi jaresi ta?” Edo ungo awa sedo embo awa Jew embobo da dada ari oro da awa ondetero dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Edo Iesu embo awa ondari ge awa ingido embo awa tambudo sisira, “Imo God da mei embo isena awa ge be esi ta?” ");
INSERT INTO nou_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Setiri embo amimi mina sisira, “Atopatari embo emomo averi awa se gido na embo awa ge be ane.” ");
INSERT INTO nou_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Setiri Iesu mi uso yei sisira, “Imo embo amone matu getesa edo iso yei boroko ge sira embo awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Edo Iesu awodo setiri embo awa Iesu da jo da baingo dederi edo sisira, “Bada na ge be ena.” ");
INSERT INTO nou_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Edo embo awa awodo setiri Iesu mi sisira, “Na busu da bugusena awa embo da ungoda gari rawodo ri awa isaga adi. Edo na bugudo ano embo ave ungoda jo da diti guba ari awa gorase. Edo embo ave ungo gari kotera awa ungo diti guba ari awodo awa isaga adena.” ");
INSERT INTO nou_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Edo umo awodo setiri Pharisee embo nenei ainda derido uso ge ingise atisera amimi uso yei nganega isera, “Imo nango diti guba ari awa sesi ta?” ");
INSERT INTO nou_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Setero Iesu mi mina sisira, “Ingo diti guba ari re ingo wasiri biae ari sae etena te ingo mi sewa nango gosera sewa awasedo ingoda wasiri bebegae awa mata awodo ingoda jo da atadira.” ");
INSERT INTO nou_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu mi sisira, “Na ingoda yei ge be sena embo ave wo sheep da ara be da awodo toradi ae rate demo da awodo ririkedo vitadira embo amone bengono embo ra. ");
INSERT INTO nou_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Edo wo sheep simba ari embo be re mangiro da awodo torido ira. ");
INSERT INTO nou_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Edo mangiro pirigari embo mi mangiro pirigedo ira edo wo sheep simba ari embo torido ira. Edo wo sheep ungoda jawo siri ungo mi uso yei bugudo era edo unemi ungo gitijigido budo ponda mambudo ira. ");
INSERT INTO nou_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Edo umo ungo gitijigido ponda bugudo ungoda giti da pepeta edo ira. Edo sheep uso ge javi ingido umo ambo ambo edo era. ");
INSERT INTO nou_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Edo ungo embo da da ge javi ingae edo re ungo mana umo ambo ambo adera ko ungo umo gae awasedo.” ");
INSERT INTO nou_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Edo Iesu inia da kiki eiawa ungoda yei sisira te ungo ro sira ainda be awa gadi jarisera. ");
INSERT INTO nou_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Awasedo Iesu kiki ainda be awa ungoda yei ujugurisira. Edo unemi sisira, “Na ingoda yei ge be sena. Na awa wo sheep da mangiro. ");
INSERT INTO nou_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Edo na bugae ateno embo nenei bugusera awa bengono embobo ra awarate sheep ungoda ge ingae isera. ");
INSERT INTO nou_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na awa mangiro. Embo ave bugudo toradira embo awa God mi soregadira. Edo embo awa torido bugudo ise ewamei ari jiwae be tambadira. ");
INSERT INTO nou_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Edo bengono embo awa bengono adi edo dari betorase edo usibesi adi bugudo ira awarate na awa wasiri uso be jiwae be de da awa itadi bugusena. ");
INSERT INTO nou_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Na awa wo sheep simba ari embo ewamei. Edo sheep simba ari embo ewamei awa uso wasiri awa uso sheep embo itido betadi sia edo ira. ");
INSERT INTO nou_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Awarate buro embo kondade edo ira amone sheep simba ari embo be aera. Edo umo ambe wo buguteuri gido sheep dodo sumbudo mambudo ira. Edo umo sumbudo mamburi ambe wo mi sheep degaburiga eoro dada edo era. ");
INSERT INTO nou_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Edo buro embo kondade edo ira awa sumbudo ira ainda be awa umo gano embo buro ira awasedo ro sheep da yei bugadiri awa umo awa kotaera. ");
INSERT INTO nou_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Na awa sheep simba ari embo ewamei na. Edo na sheep naso topo mo rawari awa na gari edo ungo na gari teta naso Mama umo na gari edo na naso Mama gari awodo. Edo na ungo embo betadi sia etena. ");
INSERT INTO nou_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Edo sheep naso topo nenei awa puga einda jo da atae ra te ponda atera. Edo nanemi mambudo ungo daedo einda budo bugadena. Edo ungo naso ge ingido edo diti da adera edo na sheep simba ari embo mi ungo simba adena. ");
INSERT INTO nou_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Edo Mama na dubo budo ira ainda be awa na betedo sekago eradi sia ena awasedo. ");
INSERT INTO nou_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Edo na awara sae adena awa embo mi mana na doro betadena. Edo na dipapa adena iji ainde nanemi awara sano embo mi na doro betadena. Edo naso betari de naso erari de awa naso topo ra. God mi na ro adena awa setiri gosisena.” ");
INSERT INTO nou_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Edo Iesu awodo setiri Jew embo mi ungo ungosuka kotari neinde kainde edo diti etoto isera. ");
INSERT INTO nou_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Edo embo jiwae be mi sisera, “Asisi biae mi uso jo da atima ira. Edo umone jiro biae ari embo ra. Roedo uso ge ingise atevi?” ");
INSERT INTO nou_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Awarate ungo awodo sero embo nenei mi sisira, “Embo asisi biae uso jo da atadira amone mana ge embo emimi sira awodo awa mana sadira. Edo asisi biae mi mana embo diti guba ari awa ari mana pirigadira.” ");
INSERT INTO nou_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jew embobo da tumondebain ari oro da ewamei ari iji awa bugiri gido Jew embobo berari awa Jerusalem dada isera bondo sia adi. Edo kariga duberi ainde awa jamo jamo ra. ");
INSERT INTO nou_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Edo Iesu awa Jew embobo da tumonde bain ari oro da joda jawo Solomon da yei ainda pepeta isira. ");
INSERT INTO nou_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Edo umo pepeta iri Jew embobo mi umo jiroroka edo uso yei sisera, “Ro edo imo averi awa nangoda yei sae esi? Nango iji roinge inemi saso gadi simba eri? Gebe se gore. Imo mo soregari embo God mi itari bugarase sisira awa ta?” ZL ");
INSERT INTO nou_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Edo ungo awodo setero Iesu mi mina sisira, “Na matu ingoda yei ge sena te ingo na ge be ae edo ewa. Edo na buro edo ena awa naso Mama da goroba mi, iji berari na averi awa isaga edo ira te ingo awa naso sheep ae gido na ge be ae edo ewa. ");
INSERT INTO nou_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Edo naso sheep naso ge javi ingido era. Edo na ungo gari edo ungo na ambo ambo edo era. ");
INSERT INTO nou_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Edo nanemi wasiri mata awa atari itano ungo mata awa atadera. Edo embo mi mana naso ingo da soumbadera. ");
INSERT INTO nou_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Naso Mama ungo naso yei ititisira awa embo berari de rora berari de awa derigurisira. Edo ungo mi mana Mama da ingo da ungo soumbadera. ");
INSERT INTO nou_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Namonde Mama de nango etoto awa da ra.” ");
INSERT INTO nou_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Edo Iesu awodo setiri Jew embobo mi ganuma budo pigedo umo dadi isera. ");
INSERT INTO nou_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Edo Iesu mi ungoda yei sisira, “Rora ewagaewa nanemi anase Mamo mi ititisira awa eteno ingo gosisewa. Naso buro ewamei da rawainda tamo da ingo na ganuma mi dadi evi?” ");
INSERT INTO nou_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Edo umo awodo setiri Jew embobo mi mina sisera, “Nango iso buro ewagaewa awasedo imo ganuma mi dadi aera te imo God isiburesa awasedo era. Imo awa embo ra te imo sesa imo awa God.” ");
INSERT INTO nou_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Edo ungo awodo setero Iesu mi mina sisira, “Ingoda jiwari mi sira God mi embo da yei umo gitijigido ira da awodo gitijigorase goroba ititisira sedo ira. ");
INSERT INTO nou_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Edo ro jiwari mi sira amone ge be mata awodo atari ra awasedo jiwari mi God mi goroba ari umo gitijigido ira da awodo embo uso binga burisera, ainda yei gitijigorase goroba ititisira, ro edo ingo na God isibari ge sevi? Edo Mama na naso buro da sia edo busu da itiri bugusena. Edo unemi sisira na awa God da mei. ");
INSERT INTO nou_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Edo na naso Mama da buro ae adena awa na ge be ae ewo. ");
INSERT INTO nou_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Awarate na naso Mama da buro awa irinono edo ingo na ge be ae adewa awa buro awa ge be awodo ge be ewo. Awodo ge be ise awa ingo gadewa Mama awa nangae aturi edo na awa Mama ga atima ena awa gadewa.” ");
INSERT INTO nou_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Edo Iesu awodo setiri ungomi sekago Iesu sandadi jarisera te umo ungo dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Edo Iesu umo Jordan awa sembudo mambudo yei John umo mi embo ewamei edo isira ainda mambusira. ");
INSERT INTO nou_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Edo umo ainda aturi embo jiwae be mi uso yei bugudo isera. Edo sedo isera, “John ari wasiri goroba de ae rate embo einda jawo da ge sedo isira awa ge be ra.” ");
INSERT INTO nou_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Edo embo jiwae be ainda atisera awa ge be isera. ");
INSERT INTO nou_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Embo da jawo Lazarus awa nati Bethany ainda atintina karu isira. Edo Mary de uso jao Martha de awa daedo nati ainda atima isera. ");
INSERT INTO nou_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mary emone joino muno de Bada da tei da jojedo edo uso kopiri tu mi gainburisira awa ra. Edo karu embo Lazarus awa uso ru ra. ");
INSERT INTO nou_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Edo ru aimono etoto mi Iesu da yei binga itero mambusira, “Bada iso otao dubo be budo esa awa karu etira.” ");
INSERT INTO nou_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Edo Iesu binga awa budo sisira, “Karu einda be awa Lazarus da betari ae ra te karu einda be awa embo de evetu de mi God jasiga adera. Edo karu eiawa bugira awa ari awa embo mi God da mei awa jasiga adera.” ");
INSERT INTO nou_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Edo Iesu Martha de uso jao de Lazarus de awa dubo budo isira. ");
INSERT INTO nou_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Edo Iesu Lazarus karu ari binga awa ingisira te umo yei awa doae ainda atisira. ");
INSERT INTO nou_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Edo iji etoto atae etiri Iesu uso ambojimbi da yei sisira, “Ingode engenembedo Judea busu da mambore.” ");
INSERT INTO nou_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Edo umo awodo setiri uso ambojimbi mi mina sisera, “Iji tupo be Jew embobo mi imo ganuma mi doro betasase ititara. Edo imo ro edo ainda sekago mambadi sesi?” ");
INSERT INTO nou_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Setero Iesu mi sisira, “Iji de waiko janiburirari embo ave emboro da pepeta adera awa mana tei dedo edo duradira. ");
INSERT INTO nou_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Awarate embo emboro da tumbade pepeta adira awa tei dadira ainda be awa tumba awasedo.” ");
INSERT INTO nou_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Edo Iesu awa sedo sisira, “Ingodenaso otao Lazarus awa ewo ira te uso yei mambudo nanemi ano umo eradira.” ");
INSERT INTO nou_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Setiri uso ambojimbi mi mina sisera, “Bada umo ewo ira re umone ewamei adira.” ");
INSERT INTO nou_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu re Lazarus da betari da ge awa sisira awarate ungo kotisera Iesu Lazarus ewo ira sari ge sisera. ");
INSERT INTO nou_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Awasedo Iesu mi ungoda yei isaga sisira, “Lazarus awa bebetara te na uso yei mambae iutana awasedo dubo ewamei ena ingo awa embo ainda be awa eiedo ira amimi ari ingo na ge be adewa. Puwo ingode uso yei mambore.” ");
INSERT INTO nou_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas uso jawo dirugedo sisera dindiga mi ambojimbi da yei sisira, “Ingode daedo mambudo ungae da betore.” ");
INSERT INTO nou_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Edo ungo Bethany nati da bugero edo nati embobo mi ungoda yei sisera Lazarus matu betetiri goutitara. Edo boroko iji 4 atae etiri Iesu bugira. ");
INSERT INTO nou_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Edo Bethany nati awa 3 kilometres edo Jerusalem nati aikambu gido Jew embobo jiwae be sorara da mambusera edo Mary de Martha de kondade adi. ");
INSERT INTO nou_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Edo Iesu bugutira awa sero Martha ingido mando dodo Iesu tambadi mambusira te Mary mando da atisira. ");
INSERT INTO nou_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Edo Martha mi Iesu da yei sisira, “Bada imo einda bugae etesa awa naso ru awa mana betae etira. ");
INSERT INTO nou_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Awarate na gosena boroko God mi uso yei ro embo nganega adesa awa iso yei itadira awa gosena.” ");
INSERT INTO nou_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Edo Martha awodo setiri, Iesu mi uso yei sisira. “Iso ru awa bebetara edo sekago eradira.” ");
INSERT INTO nou_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Edo Iesu awodo setiri Martha mi mina sisira, “Na gosena umo bebetara te iji sangove de awa umo sekago eradira.” ");
INSERT INTO nou_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Edo Martha awodo setiri Iesu mi uso yei sisira, “Na awa sekago erari de edo wasiri de da susu ra. Edo embo ave na ge be adera embo awa betadera te sekago erido wasiri de atadera. ");
INSERT INTO nou_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Edo embo ave wasiri de atise na ge be adira awa wasiri natopo atari awa badira. Edo imo naso ge awa ge be esi ta?” ");
INSERT INTO nou_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Edo Iesu awodo setiri Martha mi mina sisira, “Ge be Bada. Na ge be ena imo awa soregari embo God mi itari bugarase sisira awa ra. Na ge be ena imo awa God da mei embo nango simba edo era awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Edo Martha awodo sedo mando da engenemburisira edo uso jao jawo sisira. Edo gae unjugari da uso yei sisira, “Atopatari bugudo imo gadi simba ira.” ");
INSERT INTO nou_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Edo Mary ge awa ingido erido burigi be Iesu tambadi mambusira. ");
INSERT INTO nou_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Edo Iesu umo nati da enya torae rate Martha umo rawainda tambusiri ainda atisira. ");
INSERT INTO nou_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Edo Jew embobo Mary uso dubo vevera da kondade ise uso mando da daedo atima isera awa umo burigi be erido mambutiri gido umo ambo ambo isera ko ungo kotisera awa Mary awa uje be da ji sadi mambari ge sedo isera. ");
INSERT INTO nou_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Edo Mary Iesu atisira yei ainda bugudo umo gido Iesu da dombu da baingo dederi edo sisira, “Bada imo einda atae etesa awa naso ru awa mana betae etira.” ");
INSERT INTO nou_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Edo Mary de Jew embobo Mary ga bugusera awa berari ji sisera. Edo ungo awodo ji sero Iesu ungo gido uso dubo ji mi ganagurisira. ");
INSERT INTO nou_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Edo umo dubo ji mi ganagetiri ungoda yei nganega isira, “Lazarus, yei rawainda goutitavi?” Setiri ungo mi mina sisera, “Bada po gase.” ");
INSERT INTO nou_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Edo ungo awodo setero Iesu ji sisira. ");
INSERT INTO nou_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Awasedo Jew embobo mi sisera, “Giu Iesu Lazarus be dubo budo ira.” ");
INSERT INTO nou_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Awarate embo nenei mi sisera, “Umo embo diti guba ari awa euri yei sekago gido era. Ro edo Lazarus da betari awa beitigae iutari?” ");
INSERT INTO nou_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Edo Iesu sekago ji mi dubo ganagetiri gido uje be da mambusira. Edo uje awa meko ra edo be awa ganuma nembodiba mi gajisera. ");
INSERT INTO nou_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Edo Iesu mi ungoda yei sisira, “Ganuma awa miminegeu mambare.” Setiri embo bebetisira ainda ru Martha mi sisira, “Bada umo betedo iji 4 atae etira awasedo masa biae mimbadera.” ");
INSERT INTO nou_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Edo Martha awodo setiri Iesu mi uso yei sisira, “Na imo iso yei setena, imo na ge be adesa awa ari wasiri goroba de gadesa. Edo imo awa ruvegetesi ta?” ");
INSERT INTO nou_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Edo Iesu awodo setiri ungo mi ganuma awa miminegetero mambusira. Edo Iesu diti inda edo sisira, “Mama na imo jasiga edo ena ainda be awa imo naso yei dengoro edo esa awasedo. ");
INSERT INTO nou_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Edo na gari imo iji berari naso yei dengoro edo esa te na eiawa sena awa embo berari boroko einda atera amimi inemi na iteso bugusena awa ge be orase sena.” ");
INSERT INTO nou_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Edo Iesu umo awodo sedo atae edo gogo dimbudo sisira, “Lazarus ponda bugu.” ");
INSERT INTO nou_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Edo umo awodo setiri betari embo awa uso tei de ingo de dombu de awa betari gowari bo mi dogari awodo ponda bugusira. Edo umo ponda bugiri Iesu mi ungoda yei sisira, “Bo awa wujegedo dowo mambare.” ");
INSERT INTO nou_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Edo Jew embobo jiwae Mary esega adi bugusera awa Iesu mi ro isira awa gido umo ge be isera. ");
INSERT INTO nou_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Awarate nenei engenembedo Pharisee embobo da yei membudo Iesu mi ro isira awa setero gosisera. ");
INSERT INTO nou_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Edo Pharisee embobo de priest babojegari de Jew embobo da gitijijigegari de dada edo ungo ungosuka sisera, “Ingode ro eri? Embo ari wasiri nembogamo jiwae be ira te ingodenanemi umo wasiri ira eiawa beitigae adera awa embo berari mi umo ge be adera. Edo embo berari mi umo ge be adera awa Rome embobo da gitijijigegari mi Rome embobo mi ingodena gitijigido era amimi isoro embobo itoro bugudo ungo mi ingodenaso tumondebain ari oro awa usibesi edo embo ondero dada adera.” ");
INSERT INTO nou_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Edo embo ainda teda embo jawo Caiaphas priest bajari nembodiba mi sisira, “Ingo kotari bebegae embobo. Eiawa kotewo, ungo mi ingodenaso embo usibesi adera awa biae awasedo embo da mi embo berari awasedo betadira awa ewamei be ra.” ");
INSERT INTO nou_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Edo Caiaphas iji ainde awa priest bajari nembodiba atima isira uso kotari mi ge awa sae ra. Awarate God mi kotari awa uso yei itiri sisira Iesu Jew embobo berari awasedo betadira. ");
INSERT INTO nou_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Daedo ingodena gari Iesu awa God da kinapeina busu berari da sisigaga edo atima era awa ungo mi sekago dada orase betadira. ");
INSERT INTO nou_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Edo iji ainde edo mambutira awa Jew embobo da gitijijigegari Iesu doro betarase kiki dirisera. ");
INSERT INTO nou_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Awasedo Iesu Judea busu da isaga isaga ise tembae ra te yei awa dodo umo nati yei embo atae ainda demonda mambusira nati jawo Ephraim. Edo umo ainda mambudo ainda ambojimbi de daedo dada atima isira. ");
INSERT INTO nou_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Edo Jew embobo da jarusegari bondo awa aikambu isira edo embo jiwae be ungoda nati dodo Jerusalem nati da vivitisera. Edo ungo ainda vitido ungo bondo tuturo ae atiri ungo ungoda wasiri bebegae segari da wasiri awa isera. ");
INSERT INTO nou_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Edo ungo Jew embobo da tumondebain ari oro da dada ise ungoi Iesu bugita awa gadi eura isera. Edo nganega mina ara isera, “Ingo ro kotevi? Umo jarusegari bondo da bugeita? ");
INSERT INTO nou_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Edo priest babojegari de Pharisee embobo de mi sisera embo amemi Iesu rawainda atiri awa gido embo amimi ungo gari gido Iesu sandadi sisera. ");
INSERT INTO nou_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iji 6 atae ari jarusegari bondo adera ainde Iesu Bethany nati da mabusira. Lazarus embo betetiri Iesu mi etiri eririsira awa nati ainda atima isira. ");
INSERT INTO nou_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Edo ungo indari sagetero Martha mi tendeba da ititisira. Edo Lazarus de Iesu de dada ainda anumbedo indari awa indisera. ");
INSERT INTO nou_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Edo Mary mi joino muno ewamei de awa budo bugusira edo uso mina awa nembodiba be awa budo bugudo Iesu da tei da jojisira. Edo jojedo uso jopiri tu mi Iesu da tei awa gainburisira. Edo joino ainda muno ewamei amimi mando berari awa beda isira. ");
INSERT INTO nou_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Edo Iesu da ambojimbi da da teda Judas Iscariot embo amboda Iesu indiga adira amimi sisira, “Roedo evetu eiawa joino eiawa ori edo K300 budo edo gano awa embo rora ae embobo da itae dodo etiri?” ");
INSERT INTO nou_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Edo umo rora ae embo awa be kotae edo ira te gano nenei awa unemi dipapa edo ira. Edo umo ambojimbi da gano sapoia awa unemi simba edo isira te gano nenei awa unemi budo isira. Edo umone bengono embo ra. ");
INSERT INTO nou_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Edo umo awodo setiri Iesu mi sisira, “Evetu awa doio. Evetu awa wasiri ewamei etira edo naso betari da gowari awa sia etira. ");
INSERT INTO nou_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Edo iji jiwae be imo embo rora ae embobo awa kondade adesa te na awa ingae iji tupo be atadena.” ");
INSERT INTO nou_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Edo Iesu Bethany nati da bugiri Jew embobo jiwae be binga awa ingido ungo daedo ainda mambusera. Edo ungo Iesu umo umosuka gadi mambae rate Lazarus embo Iesu mi betetiri etiri eririsira ainde daedo gadi mambusera. ");
INSERT INTO nou_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Edo Jew embobo jiwae be Jew embobo da gitijijigegari awa ambo ambo ae dodo Iesu ge be isera ainda be awa umo Lazarus etiri eririsira awasedo. ");
INSERT INTO nou_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Awasedo priest babojigari Iesu doro betarase kiki dirisera. ");
INSERT INTO nou_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Edo iji nei embo jiwae be jarusegari bondo da bugujegurisera amimi Iesu Jerusalem nati da bugutira ainda binga awa ingisera. ");
INSERT INTO nou_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Awasedo ri papatu budo Iesu tambadi sedo mambusera. Edo ungo Iesu tambadi mambuse ungo mi gogo dimbudo sisera, “Bada Oro. Bada Oro. Bada Oro. Embo bugutira emone God da jawo da bugutira awasedo God mi umo ewamei are. Edo embo emone Jew embobo da gitijigari nembodiba ra God mi umo ewamei are.” ");
INSERT INTO nou_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Edo Iesu wo donkey da mei awa tambudo ainda tamo da anumbedo bugutira. Edo umo awodo isira awa ro jiwari mi arase sisira awa isira. ");
INSERT INTO nou_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Edo jiwari mi Jerusalem nati awa sise sisira, “Zion nati embobo oju eove. Edo giwo ingoda gitijigari nembodiba awa wo donkey da mei da tamo da anumbedo bugutira.” ");
INSERT INTO nou_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Edo iji ainde uso ambojimbi ge ainda be awa gadi jarisera te amboda God Iesu jigiri erido uso gitijigari yei da utu da engenemburisira iji ainde uso ambojimbi ro isira ainda be awa gosisera. ");
INSERT INTO nou_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Edo embo Iesu mi Lazarus embo gowari meko da jawo setiri wasiri de sekago bugiri gosisera embobo amimi ro isira ainda binga awa setero yise puse isira. ");
INSERT INTO nou_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Awasedo embo jiwae be Iesu mi ari wasiri goroba de isira awa ingido ungo Iesu tambadi sedo bugusera. ");
INSERT INTO nou_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Edo Pharisee embobo embo jiwae be awa gido sisera, “Oiawa giu. Embo ingodena doetera. Edo busu berari da embo berari awa umo ambo ambo era.” ");
INSERT INTO nou_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Edo Jew embobo Jerusalem nati da ungoda bondo ero Greece busu embo nenei daedo dada isera tumondebain adi. ");
INSERT INTO nou_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Edo ungo mi Philip Galilee busu embo uso nati Bethsaida ainda yei bugudo sisera, “Embo ewamei, Iesu gari dipapa era.” ");
INSERT INTO nou_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Edo ungo awodo setero Philip mambudo Andrew setiri ungo etoto mi mambudo Iesu da yei sisera. ");
INSERT INTO nou_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Edo ungo Iesu da yei setero Iesu mi mina ungoda yei sisira, “Na God da mei bugudo embo isena awa doro betadena. Edo ungo mi na doro betano God mi na jigari erido na naso gitijigari yei utu da ainda engenembadena. Edo rora berari eiawa adira iji awa aikambu etira. ");
INSERT INTO nou_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Edo na gebe sadena ingo giwo. Na durido betadena teta pisa ve mi busu da durido ira da awodo. Edo na betae atadena awa teta pisa be da umo umosuka awodo awarate na betadena awa naso betari mi ari wasiri mata awa atari awa embo jiwae da yei bugadira. ");
INSERT INTO nou_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Edo embo ave uso wasiri awa iji berari simba adira embo awa betadira awarate embo ave busu da atise uso wasiri topo awa iji berari kotae adira embo awa wasiri mata awa atari awa badira. ");
INSERT INTO nou_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Edo embo ave naso agipo adi dipapa adira embo awa iji berari na ambo ambo are. Edo awodo ise awa na yei rawainda atadena ainda naso agipo embo awa nangae atadira. Edo embo ave na sapo adira awa naso Mama mi embo awa rora jiwae mi ewamei adira.” ");
INSERT INTO nou_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iesu mi sisira, “Naso jo memesi ira na ro seni? Na seni ta Mama memesi iji eiawa doaso naso yei bugure? Awodo aera mana awodo sadena ko na memesi budo betadi bugusena. ");
INSERT INTO nou_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Eiawa nanemi sadena Mama egae embo mi imo jasiga ore.” Edo Iesu awodo setiri ge javi utu da ainda sisira, “Matu eteno embo na jasiga era edo nanemi sekago adena.” ");
INSERT INTO nou_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Edo embo ainda dederigedo atisera amimi ge javi awa ingido sisera, “Nango binga barara da javi ingera.” Edo ungo awodo setero embo nenei mi sisera, “Asisi ewamei mi uso yei ge setira.” ");
INSERT INTO nou_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Awarate Iesu mi ungoda yei sisira, “Ge javi eiawa naso yei sae ra te ingoda yei setira. ");
INSERT INTO nou_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","God mi busu da gitijigari nembogamo wawara adira iji awa bugira. ");
INSERT INTO nou_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Edo ungo mi na orega da jigoro erido busu berari da embo awa jumbano naso yei puradera.” ");
INSERT INTO nou_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Edo Iesu awodo sisira awa uso betari rawodo betadiri awa sisira. ");
INSERT INTO nou_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Awarate embo jiwae be mi be pigedo mina sisera, “Nangoda agodari mi seuri gido era soregari embo God mi itari bugarase sisira awa mata awodo atadira. Edo imo ro edo sesi God da mei embo isira awa ungo mi jigoro erarase sesi? Embo eiawa averi?” ");
INSERT INTO nou_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Edo ungo awodo setero Iesu mi mina sisira, “Iji tupo usasa awa ingode daedo atadira. Edo doawo umenga mi ingo apuregeure ta usasa atira einde usasa da atiwo. Edo awodo ewo ainda be awa embo ave umenga da pepeta ira awa umo yei rawainda mambutiri awa umo gaera awa sedo. ");
INSERT INTO nou_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Na awa usasa awa ra awasedo na ingode atena ainde na ge be ewo. Edo na ge be ise pepeta irirowo usasa mi iji berari ingo awa jiroroka are.” ");
INSERT INTO nou_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Edo Iesu awa sedo umo yei da ungo mi umo gari sago ae ainda mambusira. Edo Iesu ari wasiri nembogamo jiwae be eitri embomei amimi gosisera te ungo umo ge be ae isera. ");
INSERT INTO nou_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Edo ro God da binga sari embo Isaiah mi sisira awa be isira. Edo Isaiah mi sisira, “God, embo amemi binga nango mi era mo ge be eri? Edo amemi God da ari wasiri goroba de awa gido uso binga ge be eri?” ");
INSERT INTO nou_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Edo ge nei Isaiah mi sisira amimi kondade ari nango ungo roedo ge be ae iseri awa gadera. ");
INSERT INTO nou_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Edo Isaiah mi sisira, “Ungo ungoda diti mi georase God mi ungoda diti awa apuregetira. Ungo ungoda jiro mi georase God mi ungoda jiro awa gajetira. Edo God mi sira ‘Ungo mi naso yei wareregadi ae awasedo na mana ungo awa ewamei adena.’” ");
INSERT INTO nou_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah mi eiawa sisira ainda be awa umo God uso gitijigari yei da atima isira ainde Isaiah umo gido umo awa ge sedo isira. ");
INSERT INTO nou_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Edo Jew embobo da babojegari jiwae be Iesu ge be isera te ungo embo nenei da yei sae isera ainda be awa ungo Pharisee embobo mi Jew embobo da dada ari oro da awa wawara oro wowosae isera. ");
INSERT INTO nou_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Edo ungo embo mi ungoda yei doio sorase dipapa isera te God mi ungo doio sarase awa ungo be kotae isera. ");
INSERT INTO nou_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Edo Iesu mi embo da yei minonu sisira, “Embo ave na ge be era embo awa God na itiri bugusena awa ge be ira. ");
INSERT INTO nou_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Edo embo ave na embo averi awa gosira embo awa God na itiri bugusena awa gosira. ");
INSERT INTO nou_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na awa teta usasa awodo busu da wowosisena awasedo embo ave na ge be ira awa umenga da atae ra. ");
INSERT INTO nou_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Edo embo ave naso binga ingise edo kera ae ira awa embo awa nanemi mana kasadena ainda be awa na busu da embo awa kasadi bugae ra te na ungo soregadi bugusena awasedo. ");
INSERT INTO nou_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Edo embo ave na ujo ae ise naso binga bae ira awa embo awa God mi kasadira. Edo iji amboda ge nanemi sena amimi embo awa kasadira. ");
INSERT INTO nou_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na naso kotari mi ge sae ra te Mama na itiri bugusena amimi ro sanase sisira awa sena awasedo ge nanemi setena amimi embo kasadira. ");
INSERT INTO nou_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na gari God da binga mi rawodo edo wasiri mata awa atari badevi awa ujugurira. Edo na God mi ro sanase sisira awa sena.” ");
INSERT INTO nou_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","2","Tumba jijirisira edo ewudo awa Jarusegari Bondo da iji. Edo Iesu uso ambojimbi de anumbedo edo ungoda indari sangove awa dada indisera. Edo Iesu umo gosisira uso iji umo busu dodo uso Mama da yei da mambari iji awa bugira awa gosisira. Edo Satan matu kotari biae Iesu indiga arase awa Judas Iscariot Simon da mei da jiro da itira. Awarate Iesu uso dubo bari uso ambojimbi da awa mata awodo atira. Uso dubo bari ungoda yei awa atae ae ra. ");
INSERT INTO nou_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Edo Iesu umo gosisira uso Mamo mi rora berari awa uso yei ititisira awa gosisira. Edo umo gosisira God mi umo busu da itiri bugusira edo umo utu da engenembadira awa gosisira. ");
INSERT INTO nou_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","5","Awasedo Iesu erido uso bo tamo da awa ujugedo uso ipu da digido umo tewo da jojedo uso ambojimbi da tei segadi tuturo isira. Edo Iesu ungoda tei segedo atae edo bo ipu da didigurisira amimi gainburisira. ");
INSERT INTO nou_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Edo Iesu Simon Peter da yei bugiri Simon Peter mi sisira, “Bada imo naso tei segadi esi ta?” ");
INSERT INTO nou_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Edo Peter awodo setiri Iesu mi uso yei sisira, “Na ro ena awa imo boroko gadi jaresa te amboda gadesa.” ");
INSERT INTO nou_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Edo Iesu awodo setiri Peter mi mina sisira, “Awodo aera. Imo mana naso tei segadesa.” Setiri Iesu mi mina sisira, “Na iso tei segae adena awa imo mana naso ambojimbi adesa.” ");
INSERT INTO nou_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Setiri Peter mi mina sisira, “Awara naso tei segedo edo naso ingo de kopiri de segeio.” ");
INSERT INTO nou_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Edo Peter awodo setiri Iesu mi sisira, “Embo da ave umo matu umo kainya edo edo emboro da pepeta adira awa uso tei segadira awa uso tamo berari awa ewamei adira. Edo ingo ambojimbi berari awodo awa ewagaewa ra te ingoda teda da awa ewamei ae ra. ");
INSERT INTO nou_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu umo embo amemi umo indiga sadira awa matu gosisira awasedo umo sisira ingoda teda embo da awa ewamei ae ra sisira.” ");
INSERT INTO nou_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Edo Iesu ambojimbi da tei segedo atae edo uso bo tamo awa sekago ombudo edo sekago engenembedo uso anumba tendeba giti da ainda mambudo anumburisira. Edo ainda mambudo Iesu ungoda yei sisira, “Na ingoda tei segari da wasiri etena ainda be awa gadi jarewa awa gosena. ");
INSERT INTO nou_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Na awa ingoda atopatari edo gitijigari awasedo ingo na atopatari edo gitijigari sadewa amone awara. ");
INSERT INTO nou_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na awa ingoda atopatari edo gitijigari awarate na ingoda tei segetena teta agipo embo mi ingoda tei segae etira awodo. Edo ingo awa ingosuka tei mina sega ewo. ");
INSERT INTO nou_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Edo ingo nanemi ingoda yei ro etena awa gido da awodo ingosuka mina ara ewo. ");
INSERT INTO nou_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Edo na ingoda yei ge be sena, agipo embo amimi uso bajari awa derigaera edo binga sari embo mi embo amemi umo setiri mambutira embo awa derigaera. ");
INSERT INTO nou_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Edo na ingoda yei matu ujugeteno getewa ro adewa amone awasedo boroko ewo. Edo awodo ise awa dubo ewamei ari nembodiba tambave. ");
INSERT INTO nou_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Edo na eiawa ingo berari ainda yei saera. Edo na ingo dada na ambo ambo awase sisena awa gosena. Edo ro jiwari mi sisira awa be adira. Edo jiwari mi sira, ‘Embo da nangae dada anumbedo edo indari indira embo amimi na indiga sadira.’ ");
INSERT INTO nou_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Edo wasiri awa ae atiri na wasiri awa adira awa sena. Awasedo wasiri awa irirari ingo na soregari embo God mi itari bugarase sisira awa gido ge be adewa. ");
INSERT INTO nou_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Edo na ingoda yei ge be sena embo ave embo nanemi itano bugadira awa badira awa na badira edo embo ave na badira awa God na itiri bugusena awa badira.” ");
INSERT INTO nou_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Amboda Iesu uso jo memesi etiri isaga sisira, “Na ingoda yei gebe sena embo da ingoda teda amimi na indiga adewa.” ");
INSERT INTO nou_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Edo Iesu awodo setiri ambojimbi dombu mina gara isera ainda be awa ungo mana mana isera Iesu mo ge mo amende siri awa. ");
INSERT INTO nou_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Edo embo da ambojimbi da teda Iesu be dubo budo isira awa Iesu da demo da anumbedo atisira. ");
INSERT INTO nou_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Awasedo Simon Peter mi umo babakibedo sisira, “Iesu sedo gi umomo ge mo amende siri awa.” ");
INSERT INTO nou_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Edo Peter awodo setiri ambojimbi da amimi Iesu ga daeneburise Iesu da yei nganega isira, “Bada embo amemi imo mo indiga eiri?” ");
INSERT INTO nou_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Setiri Iesu mi mina sisira, “Na ambe eiawa su da patido edo embo amenda itadena embo amimi na indiga adira.” Edo Iesu awodo sedo ambe be da awa budo su da patido Simon Iscariot da mei Judas da yei ititisira. ");
INSERT INTO nou_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Edo Judas ambe awa betiri Satan uso jo da totorisira. Edo Iesu mi Judas da yei sisira, “Imo ro adi esa awa burigi eio.” ");
INSERT INTO nou_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Edo ambojimbi nenei tendeba be da anumbedo atisera awa Iesu ro edo Judas da yei awodo siri awa ungo gadi jarisera. ");
INSERT INTO nou_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Edo Judas ambojimbi da ganu dada ari rora awa simba edo isira awasedo ambojimbi nenei kotisera awa Iesu Judas mi mambudo bondo da indari nei barase sari ge sisera. Edo kotari nei ungoda yei bugusira awa awasi umo Judas mi embo rora ae embobo da yei ganu itarase sari awodo kotisera. ");
INSERT INTO nou_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Edo Judas ambe awa budo burigi be ponda mambusira. Edo tumba jijirisira. ");
INSERT INTO nou_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Edo Judas mambiri Iesu mi sisira, “God da mei embo isena amimi betedo edo sekago erari iji awa aikambu etira. Edo iji einde God mi uso goroba nembodiba awa isaga adira. ");
INSERT INTO nou_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Uso goroba de uso usasa de mi na God da mei bugudo embo isena awa jiroroka adira. Edo eiawa berari burigi be adira. ");
INSERT INTO nou_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Naso kinapeina na ingode iji tupo be atadena. Edo ingo na gari dipapa adewa te ro Jew embobo da yei sisena awa boroko ingoda yei sena, ingo mana yei na mambadena ainda mana mambadewa. ");
INSERT INTO nou_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Edo boroko na ingoda yei agodari seka ititena amone eire. Dubo mina bara ewo. Na ingo dubo budo ena da awodo dubo mina bara ewo. ");
INSERT INTO nou_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Edo ingo dubo mina bara adewa awa embo berari mi ingo naso ambojimbi awa gadera.” ");
INSERT INTO nou_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Edo Simon Peter mi Iesu da yei nganega isira, “Bada imo yei rawainda mambadi esi?” Setiri Iesu mi mina sisira, “Boroko ingo mana nangae mambadewa te amboda ingo na ambo ambo adewa.” ");
INSERT INTO nou_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Edo Iesu awodo setiri Peter mi nganega isira, “Bada ro edo na boroko imo ambo ambo adi aeri? Na imo awa embo betadi sia etena.” ");
INSERT INTO nou_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Setiri Iesu mi mina sisira, “Imo be na awa embo betadi sia etesi ta? Edo na iso yei gebe sena, kokoro egoro sae atirari imo na iji tamonde bero adesa.” ");
INSERT INTO nou_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu mi uso ambojimbi da yei sisira, “Dubo vevera ise atove. Ingo God gebe edo ewa edo da awodo na gebe ewo. ");
INSERT INTO nou_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Naso Mama da nati da awa mando jiwae be atira edo na awa ainda vitido ingo awa embo yei sia adi ena. Edo eiawa ge busari awa na mana ingoda yei sae etena. ");
INSERT INTO nou_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Edo rora berari ingo embo sia edo na engenembadena. Edo engenembedo nanemi ingo budo mambano edo yei rawainda na atena ainda ingo mata awa atadewa. ");
INSERT INTO nou_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Edo ingo na yei rawainda mambutena awa ingo gari edo ingo rawodo edo ainda mambari ri awa ingo gari.” ");
INSERT INTO nou_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Edo Iesu awodo setiri, Thomas mi uso yei sisira, “Bada nango imo yei rawainda mambutesa awa gae ra. Edo nango rawodo edo emboro mo geri?” ");
INSERT INTO nou_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Setiri Iesu mi sisira, “Na awa Mamo da yei da mambari da emboro ra. Edo na awa embo ge be awa ujugedo ira awa ra. Edo na awa embo wasiri itido ira awa ra. Edo ingo naso yei purae adewa awa ingo mana Mama da yei mambadewa. ");
INSERT INTO nou_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Edo ingo na gadewa da awodo ingo Mama gadewa. Edo boroko tuturo edo ingo umo gosewa edo isaga etira awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Edo Iesu awodo setiri Philip mi uso yei sisira, “Bada awa nangoda yei isaga egae nango re awa simba era.” ");
INSERT INTO nou_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Edo Philip awa setiri Iesu mi mina sisira, “Philip iji ribori be na ingae atewona te imo na awa be gae ra? Embo ave na gosera embo awa Mama gosira. Edo ro edo imo sesi Mama awa nangoda yei isaga egae sesi? ");
INSERT INTO nou_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Philip imo na Mama ga edo Mama awa nangae awa gebe esi ta?” Awa sedo Iesu uso ambojimbi da yei sisira, “Ge nanemi ingoda yei setena awa naso ge aera. Edo Mama awa naso jo da atise edo buro eiawa ira. ");
INSERT INTO nou_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na awa Mama ga edo Mama awa nangae awa gebe ewo. Awarate ingo awa gebe gebe ae edo re ari wasiri nembogamo ena awa gosise gebe ewo. ");
INSERT INTO nou_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Edo na ingoda yei gebe sena embo ave na gebe adera awa ari wasiri goroba de awa daedo adira. Embo ainda ari wasiri goroba de amimi naso ari wasiri goroba de awa derigadira ko na awa Mama da yei mambadena. ");
INSERT INTO nou_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Edo ro naso jawo da sedo gadewa awa nanemi adena. Edo nanemi awodo irinono embo mi God da goroba nembodiba awa gosise umo jasiga adera. ");
INSERT INTO nou_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Edo ro embo naso jawo da sedo gadewa awa nanemi adena.” ");
INSERT INTO nou_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Iesu mi ambojimbi da yei sisira, “Ingo na dubo badewa awa naso ge awa kera adewa. ");
INSERT INTO nou_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Edo na Mama sedo gano unemi kondade embo nei ingoda yei itadira Asisi Kotopu awa. Edo umo ingode daedo mata awa atadira. ");
INSERT INTO nou_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Edo embo nenei busu da atera awa Asisi Kotopu mana badera ainda be awa ungo umo ujo ae era edo mana umo gadera. Awarate ingo umo gari ra, ainda be awa umo ingode daedo atira. Edo ingoda jo da toridoatira. ");
INSERT INTO nou_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ingo awa teta popoiwo awodo mana atadewa te na ingoda yei engenembadena. ");
INSERT INTO nou_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Edo iji tupo atae ari na busu da embo doadena te na ingode daedo atadena. Na awa mata awa atima ena awasedo ingo daedo mata awa atadewa. ");
INSERT INTO nou_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Edo Asisi Kotopu wosadira iji ainde ingo na Mama da yei rawodo atima eni edo Mama rawodo naso yei atima iri edo na ingoda yei rawodo atima eni edo ingo rawodo naso yei atima evi awa gadewa. ");
INSERT INTO nou_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Embo ave naso ge budo kera edo iri embo awa na dubo budo ira. Edo embo ave na dubo budo ira embo awa naso Mama mi dubo badira. Edo na embo awa dubo burise edo uso yei na nanasuka isaga adena.” ");
INSERT INTO nou_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Edo Iesu awa setiri Judas, Judas Iscariot aera amimi uso yei sisira, “Bada ro edo imo nangoda yei isaga adesa te busu da embo neeni da adi ae sesi?” ");
INSERT INTO nou_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Setiri Iesu mi mina sisira, “Embo ave na dubo badira gido awa naso binga kera adira. Edo naso Mama mi umo dubo badira edo naso Mama de namonde uso yei bugudo ungae daedo atadera. ");
INSERT INTO nou_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Edo embo ave na dubo bae edo ira awa naso ge kera ae edo ira. Edo binga ingewa awa naso binga aera te Mamo na itiri bugusena amimi binga awa itira. ");
INSERT INTO nou_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Edo na ingode atise eiawa ingoda yei setena. ");
INSERT INTO nou_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Edo kondade ari embo Asisi Kotopu Mamo mi itari naso jawo da bugadira amimi rora berari awa ingo atopatadira. Edo unemi ari rora berari nanemi ingo atopapote mo na awa kotadewa. ");
INSERT INTO nou_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Na mambae giti da awa nanemi ingo awa jo jamo jamo de atawase ena. Nanemi ingo jo jamo jamo de atawase ena da awodo na jo jamo jamo de atena. Edo busu da embo berari jo jamo jamo mo rawodo awa seni awa ungo gaera. Edo dubo vevera eove. Edo oju eove. ");
INSERT INTO nou_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ingo ingewo na ingoda yei setena, ‘Na mambutena te na ingoda yei engenembadena.’ Edo ingo na dubo badewa re ingo dubo ewamei adewa na Mama da yei mambutena awasedo, ainda be awa naso Mama ga da atadena awa goroba nembodiba de ra. ");
INSERT INTO nou_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Edo rora berari eiawa ae atirari na boroko ingoda yei sena awa adira. Edo amboda adira ingo na ge be adewa. ");
INSERT INTO nou_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Iji tupo simba ise awa na ingoda yei ge sadena ainda be awa Satan busu einda gitijigari de uso embobo de awa bugutera awasedo. Awarate umo naso yei ro ari katogo aera. ");
INSERT INTO nou_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Edo God mi ro anase berari sira awa ena edo busu da embo berari mi awa gido awa na Mamo dubo budo ena awa gadera. Pou ingode yei eiawa dore.” ");
INSERT INTO nou_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu mi sisira, “Na awa teta buro da grape be da vine inge ra. Edo naso Mama awa teta ve gowari edo buro simba ari embo da awodo ra. Edo ingo awa teta vine da papatu inge ra. ");
INSERT INTO nou_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Edo patu da rawa be ae edo ira awa naso Mama mi eregedo ira. Edo papatu berari rawa be edo ira awa unemi kiambu diugeuri edo osiri seka erido edo be jiwae be edo ira. ");
INSERT INTO nou_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Edo ingo na binga seno ingewa awa teta patu diugari edo be jiwae adi ira da awodo ra. ");
INSERT INTO nou_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Edo nangae daedo atiwo edo na ingode daedo atane. Edo ungomi patu da diugedo edo umo umosuka doro atadira awa patu awa mana be adira. Awarate patu awa vine susu de dada adira awa be adira. Edo ingo nangae dada atae adewa awa ingo mana be adewa. ");
INSERT INTO nou_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na awa vine edo ingo awa papatu. Edo embo ave nangae atadira awa na da awodo embo ainga atadena edo umo be adira. Edo na ingode daedo atise edo ingo kondade ae adena awa ingo mana nei ro awa adewa. ");
INSERT INTO nou_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Edo embo ave nangae daedo atae adira awa umo awa teta patu diugedo warawara edo era da awodo adira. Edo ungo mi patu awa pigoro mambudo garasa ari edo amboda ungo mi dungoro ewadira. ");
INSERT INTO nou_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Edo ingo nangae daedo atirowo edo naso ge ingoda jo da atadira awa ingo ro embo naso yei sedo gadewa awa nanemi ingoda yei itadena. ");
INSERT INTO nou_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Edo embo ave naso ambojimbi be awa be jiwae adira. Edo ingo be awodo ise amimi awo embo God jasiga adera. ");
INSERT INTO nou_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Edo Mama na dubo budo ira da awodo na ingo dubo budo ena edo naso dubo bari da mata awodo atadewa. ");
INSERT INTO nou_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na naso Mama da ge awa kera edo uso dubo bari da atima ena da awodo ingo naso ge kera adewa awa naso dubo bari da atadewa. ");
INSERT INTO nou_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Na ingoda yei eiawa sena awa naso iaviri ari awa ingode daedo atare edo ingoda jo awa iaviri mi beda are. ");
INSERT INTO nou_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eiawa naso agodari seka na iji berari ingo dubo budo ena da awodo ingo dubo mina bara ewo. ");
INSERT INTO nou_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Edo embo da uso otatao dubo be budo edo ungo awa embo betadira awa embo ainda dubo bari mi embo nenei da dubo bari awa derigadira. ");
INSERT INTO nou_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Edo ingo na ro awase sena awa adewa awa ingo awa naso otatao. ");
INSERT INTO nou_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Edo iji boroko einde na ingo agipo embobo sewona awa doturena ainda be awa agipo embo awa uso bajari ro ira awa umo gaera. Awa dodo awa na ingo awa otatao sena ainda be awa rora berari ro naso Mama mi na setiri gosisena awa ingoda yei setena. ");
INSERT INTO nou_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ingo mi na buro eiawa anase jawo sae ra te nanemi ingo buro eiawa awase jawo setena. Edo na ingo jawo sedo setena buro awa ewo be jiwae be are edo be nanjigo atae ari katogo ae awa. Edo ingo buro awa ise ro naso jawo da God mi ingo awa embo arase sedo gadewa awa unemi adira. ");
INSERT INTO nou_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Edo eiawa na ingoda yei agodari ititena dubo mina bara ewo.” ");
INSERT INTO nou_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Iesu mi sisira, “Busu da embo mi ingo ujo ae adera edo iji ainde kotewo busu da embo mi na giti ujo ae isera. ");
INSERT INTO nou_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Edo ingo mambudo busu da embo de dada adewa awa ungo ingo mana ujo ae adera te teta otao awodo adera. Awarate nanemi ingo jawo setena edo ingo busu da embo de dada ae etewa awasedo ungo mi ingo ujo ae adera. ");
INSERT INTO nou_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Edo na ingoda yei ro sisena awa kotewo agipo embo mi uso bajari awa derigaera awasedo busu da embo mi na ujo ae edo ungo mi ingo daedo ujo ae adera. Ungo naso ge kera ae etera awa ungo ingoda ge daedo kera ae etera. ");
INSERT INTO nou_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Edo busu da embo mi ingo naso topo awasedo ujo ae adera. Edo ungo mi ingo ujo ae adera ainda be awa ungo na gae awasedo. ");
INSERT INTO nou_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Edo na ungoda yei bugae edo na ungoda yei ge sae re ungo wasiri bebegae embobo awa gae etera te boroko ungo rawodo edo ungoda wasiri bebegae apuregeri? ");
INSERT INTO nou_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Edo embo ave na ujo ae ira awa naso Mama daedo ujo ae ira. ");
INSERT INTO nou_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Edo na ari wasiri goroba de jiwae ungoda jo da ewona edo ari wasiri goroba de embo nenei mi ae awa ewona. Edo na ari wasiri goroba de eiawa ungoda jo da ae doae etena awa ungo wasiri bebegae embo awa mana gae etera. Edo ungo naso ari wasiri goroba de awa gosisera te ungo namonde naso Mama de awa ujo ae edo era. ");
INSERT INTO nou_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Edo ungo na awodo ujo ae edo era awa ungoda agodari mi ro sisira awa be etira. Edo ungoda agodari mi sira, ‘Ro mi ae rate ungo na ujo ae edo era.’ ");
INSERT INTO nou_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Edo kondade ari embo mi euri God awa gebe edo ira embo awa bugadira. Nanemi umo itano umo Mama dodo ingoda yei bugudo naso jawo da ge sadira. ");
INSERT INTO nou_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Edo ingo daedo naso jawo da ge sadewa ainda be awa tuturo da edo bugudo boroko awa ingo na ambo ambo ewowa. ");
INSERT INTO nou_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Gaegae edo ingoda ge be ari naso yei awa atae eurase gido na ingoda yei ro adiri awa sena. ");
INSERT INTO nou_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ungo mi ingo awa Jew embobo da dada ari oro da warawara oro ponda wosadewa. Edo iji bugadira iji ainde embo amemi ingo doro betadewa embo awa kotadira awa umo God kera ari awa kotadira. ");
INSERT INTO nou_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ungo Mamo gae edo ungo na gae awasedo ungo mi eiawa ingoda yei adera. ");
INSERT INTO nou_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Awarate ungo mi ingoda yei eiedo ari iji awa bugadira ainde nanemi eiawa adira awa sisena awa kotadewa awasedo boroko ingoda yei sena. Edo na naso atopatari buro ingoda teda tuturo isena awa naso iji awa ribori awasedo na matu ingoda yei eiawa sae doturisena. ");
INSERT INTO nou_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Boroko awa na embo amemi itiri bugusena ainda yei vitari aikambu etena te ingoda teda da amemi na imo nonda mambutesi nganega ae. ");
INSERT INTO nou_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Awarate na ingo doturena awa seteno getewa edo dubo vevera mi naso jo beda etira. ");
INSERT INTO nou_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na ingoda yei ge be sena na ingo doadena awa ewamei na ainda be awa na inda vitae adena awa Kondade Ari Embo awa ingoda yei bugadi aera. Awarate na vitadena ainde umo ingoda yei itano bugadira. ");
INSERT INTO nou_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Edo Asisi Kotopu mi bugudo unemi embo da yei ungo da ari bebegae da kotari edo ari ewagaewa da kotari edo Mamo da kasari da kotari kotera awa bebegae awa isaga adira. ");
INSERT INTO nou_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Edo ungo ari bebegae kotera awa biae ra ainda be awa ungo na gebe ae edo era awasedo. ");
INSERT INTO nou_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Edo ungo ari ewagaewa kotera awa daedo biae ra ainda be awa na Mama da yei mambadena edo ingo na sekago gadi aera. ");
INSERT INTO nou_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Edo ungo Mamo da kasari kotera awa biae ra ainda be awa Mamo busu einda gitijigari awawa matu kasisira. ");
INSERT INTO nou_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Naso ge jiwae be nenei ingoda yei sadena awa atira te ingo boroko ge awa kotari katogo ae ra. ");
INSERT INTO nou_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Edo asisi ge be sedo ira awa bugudo unemi ge be awa ingoda yei isaga ari gadewa. Umo umosuka ainda ge awa sadi ae ra te ro namonde Mama de mi sadera awa sadira. Edo unemi wasiri ro amboda adiri awa ingoda yei sadira. ");
INSERT INTO nou_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Edo Asisi Kotopu nanemi ro sadena awa ingido ingoda yei sadir amimi ari embo na jasiga adera. ");
INSERT INTO nou_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Edo Mama da gari berari awa naso ra awasedo na setena na ro sadena awa ingoda yei sadira setena.” ");
INSERT INTO nou_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Iesu mi sisira, “Iji tupo atae ari ingo mana na gadewa te iji tupo ainda amboda ingo na sekago gadewa.” ");
INSERT INTO nou_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Edo Iesu awodo setiri uso ambojimbi mi mina sara isera, “Uso ge einda be mo ro ri? Umo ingodenaso yei sira, ‘Iji tupo atae ari ingo na mana gadewa te iji tupo ainda amboda awa ingo na gadewa.’ Edo uso ge Mamo da yei da mambari ainda be mo ro ri? ");
INSERT INTO nou_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Edo iji tupo atae ari ge ainda be mo rori? Nango umo ge ro sira awa gaera.” ");
INSERT INTO nou_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Edo Iesu umo ungo mi uso yei ro nganega edo gadi era awa gido ungoda yei sisira, “Na ingoda yei setena iji tupo atae ari ingo mana na gadewa awarate iji tupo ainda amboda ingo na gadewa setena. Edo ingo ingosuka ge einda be mo rori awa sevita? ");
INSERT INTO nou_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na ingoda yei ge be sena na memesi nembodiba tambutinono ingo ji biae be sadewa te busu da embobo awa dubo ewamei adera. Edo ingo dubo vevera tambadewa te ingoda dubo vevera awa atae ari dubo ewamei mi bugadira. ");
INSERT INTO nou_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Edo evetu mei badi edo ira ainde umo dubo vevera edo ira ainda be awa uso memesi bari iji awa bugira awasedo awarate umo mei budo ira awa umo uso memesi awa ruvegedo edo dubo ewamei edo ira ko umo mei betira wasedo. ");
INSERT INTO nou_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Da awodo ingo boroko dubo vevera ewa awarate na ingo sekago gadena iji ainde awa dubo ewamei nembodiba be embo mi ingoda yei soumbari katogo ae amimi ingoda jo awa beda adira. ");
INSERT INTO nou_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Edo iji awa bugari ingo mana naso yei ro embo sadewa. Na ingoda yei ge be sena ro naso jawo da Mamo da yei ingo embo arase sadewa awa unemi adira. ");
INSERT INTO nou_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Edo bugudo boroko iji einde ingo ro embo naso jawo da sedo gae ra. God da sedo gadewa awa ro embo uso yei sedo gadewa awa badewa. Awodo irirowo dubo ewamei mi ingoda jo awa beda adira.” ");
INSERT INTO nou_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Iesu mi sisira, “Na inia ge mi ingo atopapotemona te iji bugutira ainde inia ge sewona awa dodo na Mamo da jawo da ge isaga ingoda yei sadena. ");
INSERT INTO nou_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Edo iji awa bugari na mana God da yei ingo ro dipapa ewa awa mana sano itadira te ingo ingosuka naso jawo da ingo ro dipapa ewa awa God da yei sadewa ainda be awa Mamo umo umosuka ingo dubo burira awasedo. ");
INSERT INTO nou_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Edo Mamo ingo dubo burira ainda be awa ingo na dubo burewa edo Mamo mi na itari bugusena awa ge be ewa awasedo. ");
INSERT INTO nou_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Edo Mama mi na itiri na busu da bugusena te boroko na busu dodo Mama da yei engenemburena.” ");
INSERT INTO nou_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Edo Iesu awodo setiri uso ambojimbi mi uso yei sisera, “Imo boroko inia ge mi ge sae rate imo ge isaga sesa. ");
INSERT INTO nou_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nango gido era imo imosuka rora berari awa gido inono ari awasedo imo embo da yei nganega ari ae edo esa. Eiawa sedo nango ge be era God mi imo itiri bugusesa.” ");
INSERT INTO nou_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Edo ungo awodo setero Iesu mi mina sisira, “Ingo eiawa ge be evi ta? ");
INSERT INTO nou_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Edo iji aikambu bugira edo iji einde ingo berari ingoda nati da sumbudo mambuse na nasuka doadewa. Awarate na nasuka aera Mama awa nangae atira. ");
INSERT INTO nou_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Edo ingoda yei eiawa seteno getewa awa jo jamo jamo de atawase setena. Edo busu einda dubo vevera de memesi jiwae be de bugadira te goroba ewo ainda be awa nanemi rora berari busu da eiawa jarugetena awasedo.” ");
INSERT INTO nou_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Edo Iesu eiawa sedo atae edo diti utu da edo sisira, “Mama naso iji bugira. Edo na iso mei awa jasiga egae edo nanemi imo jasiga ane. ");
INSERT INTO nou_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Edo inemi naso yei goroba ari iteso edo nanemi embo berari gitijigadena. Embo ave inemi naso yei itesa embobo ainda nanemi wasiri matawa atari itena. ");
INSERT INTO nou_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Edo embo imo awa God da daima ge be awa gido edo na Iesu Keriso embo inemi iteso bugusena awa gae etera amone wasiri matawa atari bari da be re awara. ");
INSERT INTO nou_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Edo na busu da bugudo edo iso goroba awa busu da embo berari da isaga etena. Edo buro ro anase ititisesa amone atae etena. ");
INSERT INTO nou_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mama ingae rora berari ae atise giti da ingae utu da usasa da dada atisena. Edo boroko usasa awa sekago naso yei itigae. ");
INSERT INTO nou_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Edo embo busu da embo berari da teda jawo sedo naso yei ititisesa ainda yei imo awa isaga iutana. Edo ungo awa iso topo awarate inemi ungo awa naso yei iteso edo ungo iso ge kera etera. ");
INSERT INTO nou_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Edo boroko ungo gosera rora berari naso yei bugudo ira awa inemi itido esa. ");
INSERT INTO nou_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Edo binga inemi naso yei ititesa awa nanemi ungoda yei itena. Edo nanemi iteno edo ungo mi betera. Edo ungo gosera awa ge be. Edo na iso yei dodo bugusena. Edo ungo na inemi iteso bugusena awa gebe edo era. ");
INSERT INTO nou_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Edo na ungo awasedo ge sena. Na iso yei ge busu da embo berari awasedo sae ra te na embo inemi naso yei ititisesa awasedo sena. ");
INSERT INTO nou_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Edo ungo berari awa iso topo ra ainda be awa ungo naso topo ra. Edo ungo berari dada rora berari iso nenei ainde awa inemi sekago naso yei da itesa awasedo embo mi na jasiga era. ");
INSERT INTO nou_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Edo boroko na iso yei da bugutena. Edo na busu da atadi aerate ungo awa busu da atadera. Mama Kotopu iso jawo da goroba mi sedo gosena embomei inemi naso yei ititisesa eiawa simba egae aso ungo diti da edo atore teta imo de namo da atima era da awodo. ");
INSERT INTO nou_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Edo na ungode atisena ainde na iso jawo da goroba mi ungo naso yei ititisesa awa simba ewona. Edo nanemi ungo simba eono edo ungo ewamei da atewora. Edo embo da teda embo ungo gosisera Iesu indiga sadira teta jiwari mi sira awodo umo awa munene getira te nenei da ave munenegae ra. ");
INSERT INTO nou_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Edo boroko na iso yei bugutena. Edo na busu da atena einde rora eiawa sena amimi naso iaviri ari mi naso ambojimbi da jo awa beda arase. ");
INSERT INTO nou_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Edo nanemi iso binga awa ungoda yei itena edo busu da embobo da teda ae awasedo teta na awa busu da embobo da embo nei ae awodo. ");
INSERT INTO nou_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na ungo busu da embo da teda awa dodo basase sedo gae rate na iso yei sedo gosena ungo soregegae. ");
INSERT INTO nou_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Edo na awa busu da embobo da embo nei ae da awodo ungo awa busu da embobo da embo nei ae ra. ");
INSERT INTO nou_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Edo iso ge moka awa ungo atopatigae edo ungo ingoda embomei be ore. ");
INSERT INTO nou_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Edo inemi na busu da embo da teda atanase iteso bugusena da awodo nanemi ungo awa busu da embo da teda atorase itena. ");
INSERT INTO nou_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Edo na ungo awasedo na nasuka iso yei itena edo ungo daedo ungo ungosuka iso yei itorase sedo. ");
INSERT INTO nou_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Edo na iso yei ge sena awa ambojimbi eiawa sedo edo daedo ungo amemi ungoda binga ingido na ge be adera awasedo sena. ");
INSERT INTO nou_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Edo na iso yei sedo gosena ungo aso diti da edo dada bundedo atorase. Mama imo awa iji berari nangae atima esa na da awodo ingae daedo dada atima ena da awodo egae ingae na etoto da daedo dada iji berari atore. Edo ungo awodo iriroro busu da embobo mi gosise inemi na iteso bugusena awa ge be ore. ");
INSERT INTO nou_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Edo imo de namo de awa jo da ra. Edo goroba inemi naso yei ititisesa awa nanemi ungoda yei ititena edo ano ungo daedo jo da orase sedo. ");
INSERT INTO nou_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Edo na ungode daedo atena da awodo imo nangae daedo atesa amimi ungo ungoda jo awa dada edo diti da ore. Edo ungo awodo iriroro busu da embobo mi inemi na iteso bugusena awa gore. Edo ungo daedo gadera imo na dubo budo esa da awodo imo ungo dubo budo esa. ");
INSERT INTO nou_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mama na iso yei sedo gosena diti da naso yei ititisesa amimi na yei rawainda atadena ainda ungo atadera. Edo imo busu ae giti da imo na dubo budo edo utu da usasa awa naso yei ititisesa awasedo dogae ungo daedo utu da usasa awa bore. ");
INSERT INTO nou_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Edo Mama ewamei busu da embo imo gae ra te na imo gari ra edo ambojimbi eiawa inemi na iteso bugusena awa ungo gari ra. ");
INSERT INTO nou_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Edo nanemi imo awa ungoda yei isaga etena edo mata awodo isaga ise atadena awodo irinono dubo bari rawa mi na dubo budo esa awa ungoda jo da mata awa atirari edo na awa ungoda jo da mata awa atadi sedo.” ");
INSERT INTO nou_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu awodo God manunugedo atae edo umo yei awa uso ambojimbi de daedo dodo umo Kidron dugoro da awa sembusera. Edo ungo sembudo Iesu uso ambojimbi de buro ainda atisira ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas indiga sari embo awa yei awa rawari awa umo gosisira ko Iesu iji jiwae uso ambojimbi de ainda dada edo isera. ");
INSERT INTO nou_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Awasedo Judas isoro embobo diti da de Jew embobo da tumonde bain ari oro simba ari embobo priest babojegari de Pharisee embobo de mi itero mambusera ainde da awa budo buro ainda mambusira. Edo ungo isoro ge emi de edo goriwo jani buriri ainde da. ");
INSERT INTO nou_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Edo Iesu umo ro uso yei adira awa gido gido embo diti da awa kena yise ungoda yei sisira, “Ingo embo ave eura evi?” ");
INSERT INTO nou_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Edo umo awodo setiri ungo mi mina sisera, “Iesu Nazareth nati embo.” Edo ungo awa setero Iesu mi mina sisira “Namone embo awa ra.” ");
INSERT INTO nou_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Edo Judas indiga sari embo awa ungoda teda ainda atisira. Edo Iesu ungoda yei setiri namone embo awa ra setiri ungo kiambu gun mi yise edo busu da dudurigurisera. ");
INSERT INTO nou_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Edo Iesu sekago ungoda yei nganega isira, “Ingo embo ave eura evi?” Setiri ungo mi mina sisera, “Iesu Nazareth nati embo.” ");
INSERT INTO nou_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Edo ungo awa setero Iesu mi mina sisira, “Na matu ingoda yei seteno getewa namone embo awa ra. Edo ingo na eura ise re embo nenei eiawa dowo mambore.” ");
INSERT INTO nou_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Awasedo ro Iesu mi matu sisira awa be isira. Edo unemi matu sisira, “Mama inemi naso yei diti da itesa awa da rawa jajovegae ra.” ");
INSERT INTO nou_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Edo Simon Peter mi uso kasiwo gorugedo budo priest gitijigari da uso agipo embo jawo Malchus awa dedo uso dengoro be awa diugurisira. ");
INSERT INTO nou_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Edo diugetiri Iesu mi Peter da yei sisira, “Iso kasiwo awa sekago uso goru da iti. Edo kotose na naso Mama mi memesi da aga ititira awa indadi ae awa kotose.” ");
INSERT INTO nou_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Edo isoro embobo diti da ungoda gitijigari de edo Jew embobo da tumondebain ari oro simba ari embobo de mi Iesu sandido bundedo edo umo budo giti Annas da yei mambusera. ");
INSERT INTO nou_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Edo Annas awa priest da gitijigari Caiaphas da uso atogo. ");
INSERT INTO nou_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Edo Caiaphas re embo amimi embo da yei sisira embo da mi embo berari awasedo betadira amone ewamei ra sisira. ");
INSERT INTO nou_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter de ambojimbi nei de Iesu ambo ambo edo mambusera. Edo priest da gitijigari ambojimbi re awa gari awasedo ambojimbi nei awa Iesu ga daedo priest da gitijigari da mando arapa da totorisira. ");
INSERT INTO nou_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Awarate Peter umo ponda ara be demo da atisira. Edo ambojimbi nei priest da gitijigari gari awa ponda sekago mambudo gagara ara be demo da atisira ainda ge sedo Peter budo jo da totorisira. ");
INSERT INTO nou_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Edo ara be pirigedo edo gajedo ari gagara mi Peter da yei sisira, “Imo embo einda ambojimbi nei ta?” Setiri Peter mi mina sisira, “Na awa aera.” ");
INSERT INTO nou_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Edo yei awa jamo jamo etiri gido agipo embobo de isoro embobo ri undugedo edo jiroroka edo ri egise atisera. Edo Peter daedo riawo da mambudo ainda daedo derido ri egise atisira. ");
INSERT INTO nou_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Edo priest da gitijigari nembodiba mi Iesu uso ambojimbi de uso atopatari de awa nganega isira. ");
INSERT INTO nou_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Edo Iesu mi uso yei mina sisira, “Na iji berari unjugae edo embomei da dombu da atopatido emona. Edo Jew embobo Jew embobo da tumondebain ari oro da dada eoro edo na isaga da ge sewona edo Jew embobo da dada ari oro da na iji berari embo atopatido emona. Edo na gae unjugari da atopatae. ");
INSERT INTO nou_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Edo ro edo imo na nganega esi? Embo naso atopatari ingewora awa nganega edo gi gae. Na ro atopapotemona awa ungoda yei nganega edo gi gae. Ungo na ro sewona awa gari ra.” ");
INSERT INTO nou_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Edo Iesu awodo setiri isoro embo da mi Iesu sogo da dorise sisira, “Ge awodo priest da gitijigari da yei seose.” ");
INSERT INTO nou_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Setiri Iesu mi mina sisira, “Na ge biae ro setena awa ge awa embo berari atera einda se awarate naso ge ewamei awa imo ro edo na doresi?” ");
INSERT INTO nou_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Edo Iesu awodo setiri Annas Iesu digari be awa atiri priest da gitijigari nembodiba Caiaphas da yei itiri mambusira. ");
INSERT INTO nou_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Peter awa ainda atise ri egise atisira awasedo ungo mi uso yei sisera, “Nango kotera imo awa Iesu da ambojimbi nei ta rora?” Setero Peter ge busedo sisira, “Na awa aera.” ");
INSERT INTO nou_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Edo umo awa setiri priest da gitijigari da agipo embo da Peter mi dedo dengoro diugurisira ainda orobe da amimi sisira, “Na kotena na imo buro da ungae da gosisenita rora?” ");
INSERT INTO nou_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Edo umo awa setiri Peter mi sisira, “Awodo aera.” Edo Peter awodo siri kokora egoro sisira. ");
INSERT INTO nou_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Edo ungo mi Iesu budo Caiaphas da mando dodo Rome embobo da gitijigari da mando da mambusera. Sipo be sipo de. Edo Jew embobo ungo gitijigari da mando jo da torae isera ainda be awa ungo kotisera ingodena embo Jew ae ainda mando da toradera awa ingodena ingodenaso agodari bejedo edo Jarusegari Bondo awa mana indadera awa ungo awodo kotisera. ");
INSERT INTO nou_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Awasedo Pilate mi pon da bugudo ungoda yei nganega isira, “Embo eiawa wasiri biae ro etiri gido ingo umo budo naso yei da bugevi?” ");
INSERT INTO nou_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Setiri ungo mi mina sisera, “Umo wasiri biae ae re nango mi umo mana budo iso yei da bugae etera.” ");
INSERT INTO nou_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Edo ungo awodo setero Pilate mi ungoda yei sisira, “Ingoda agodari awa atira. Ingoda agodari da awodo awasedo umo budo mambudo kasewo.” Edo umo awa setiri Jew embobo mi mina sisera, “Rome embobo da gitijigari mi nango embo orega da dorase awara sae etira.” ");
INSERT INTO nou_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Edo ungo awa sisera awa ro Iesu mi matu uso betari awa rawodo ri awa sisira awa be isira. ");
INSERT INTO nou_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Edo Pilate sekago gitijigari da mando da torido setiri, ungo mi Iesu budo jo da totorisera. Edo Iesu toriri Pilate mi uso yei nganega isira, “Imo mo Jew embobo da gitijigari nembodiba ta?” ");
INSERT INTO nou_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Edo umo awodo setiri Iesu mi mina sisira, “Imo kotesa sedo gari emomo inemi naso yei itesi ta ko embo nenei mi naso jawo da sero ingido na nganega esi?” ");
INSERT INTO nou_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Edo umo awodo setiri Pilate mi mina sisira, “Na awa Jew embo aera. Iso embo topo de ungoda priest babojegari de mi imo awa naso ingo da itera. Edo imo ro etesi?” ");
INSERT INTO nou_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Edo umo awodo setiri Iesu mi mina sisira, “Na busu da gitijijigegari mi gitijigido era awodo gitijigae ra. Edo na awodo gitijigae etena awa mana naso gitopo mi na Jew embo da ingo da mana itae etera edo naso ambojimbi mi embogo ae etera. Awodo aera. Na awa busu da gitijigadi aera.” ");
INSERT INTO nou_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Edo umo awodo setiri Pilate mi uso yei sedo gosisira, “Imo ge awodo sesa mo imo mo gitijigari ta?” Edo Pilate awodo setiri Iesu mi mina sisira, “Imo ge be setesa. Naso aia mi na betiri busu da embo ge be awa atopatadi bugusena. Edo embo ave ge be ingari dipapa edo era embo awa naso ge ingido ira.” Edo Iesu awodo setiri Pilate mi nganega isira, “Awarate ge be mo rori?” ");
INSERT INTO nou_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate sekago pon da mambudo Jew embobo da yei sisira, “Na embo einda yei wasiri biae da ro tambae etena. Edo embo emone wasiri biae ae embo ra. ");
INSERT INTO nou_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Awarate ingoda wasiri awodo atira awa eire. Gaeko jaige da Jarusegari Bondo da iji de na gajari oro da atima ira embo da awa ingoda yei wujegedo ena. Edo ingo Jew embobo da gitijigari nembodiba awa ingoda yei wujeganase dipapa evi ta?” ");
INSERT INTO nou_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Edo Pilate awodo setiri ungo mi gogo dimbudo uso yei sisera, “Awodo aera nango umo ujo ae era nango Barabbas dipapa era.” Edo Barabbas awa bengono embo edo embo dari betari embo. ");
INSERT INTO nou_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Edo Pilate mi setiri ungo mi Iesu vejisera. ");
INSERT INTO nou_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Edo isoro embobo mi bebe mi gitijigari da beo gobe awodo edo uso beo da ititisera. ");
INSERT INTO nou_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Edo ungo mi umo ombari kokoi ribori awa itero ombiri uso yei sisera, “Jew embobo da gitijigari nembodiba mata awa iji berari atio.” Edo ungo awa sedo uso yei mambudo ingo mi dombu da dorisera. ");
INSERT INTO nou_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Edo Pilate sekago embo jiwae be atisera ainda yei mambudo sisira, “Giwo na umo budo ingoda dombu da bugadi ena te eiawa giwo na umo eura etena te wasiri biae da ro tambae etena. Edo umone embo wasiri biae ae ra.” ");
INSERT INTO nou_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Edo Iesu beo bebe mi gobe isera awa asugedo edo ombari kokoiribori awa ombudo ponda bugusira. Edo umo ponda bugiri Pilate mi ungoda yei sisira, “Giu embo re eire.” ");
INSERT INTO nou_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Edo Pilate awodo setiri priest babojegari de isoro embobo de mi umo gido ungo mi gogo dimbudo sisera, “Benema mi orega da de. Benema mi orega da de.” Edo ungo awodo setero Pilate mi ungoda yei sisira, “Awara ingo ingosuka umo budo mambudo benema mi orega da dewo. Edo na umo eura etena te wasiri biae da tambae etena. Edo umone wasiri biae ae embo ra.” ");
INSERT INTO nou_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Edo umo awodo setiri Jew embobo mi mina sisera, “Unemi sevira umo awa God da mei. Edo nangoda agodari mi sira embo ge awodo sadera awa dewo betore.” ");
INSERT INTO nou_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","9","Edo ungo awodo setero Pilate oju edo sekago kasari yei da torido Iesu da yei sedo gosisira, “Imo yei rawainda edo bugusesi?” Setiri Iesu uso ge mina ro sae isira. ");
INSERT INTO nou_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Edo Pilate mi uso yei sisira, “Na awa gitijigari nembodiba ra te imo naso ge mina sae esa. Edo eia koteio, na naso goroba mi sae etena umo wujegewo edo na daedo sae etena benema mi orega da dewo sae etena.” ");
INSERT INTO nou_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Edo Pilate awodo setiri Iesu mi mina sisira, “God mi iso yei goroba awa itiri imo naso yei awodo awa adesa awasedo embo amemi na iso ingo da itera ainda wasiri bebegae mi iso wasiri biae awa derigetira.” ");
INSERT INTO nou_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Edo Pilate eiawa ingido Iesu wujegadi dipapa isira te Jew embobo mi gogo dimbudo uso yei sisera, “Imo umo wujegadesa awa imo Rome embobo da gitijigari nembodiba da otao aera. Edo embo ave umo umosuka awa gitijigari nembodiba sadira embo awa Rome embobo da gitijigari nembodiba da gitopo ra.” ");
INSERT INTO nou_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Edo Pilate ge awa ingido Iesu budo ponda bugudo kasari embo da anumba da anumburisira. Edo yei awa jawo sedo era yei ganuma dada itari Hebrew ge mi sedo era Gabbatha. ");
INSERT INTO nou_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Edo Jarusegari Bondo adi ewadera ainda iji soropu da. Edo Pilate mi Jew embobo da yei sisira, “Ingoda gitijigari nembodiba re eire.” ");
INSERT INTO nou_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Edo umo awodo setiri ungo mi gogo nembodiba dimbudo sisera, “De betare. De betare. Benema mi orega da de.” Edo ungo awodo setero Pilate mi ungoda yei nganega isira, “Ingo ingoda gitijigari nembodiba eiawa benema mi orega da danase dipapa evi ta?” Setiri priest babojegari mi mina sisera, “Rome embobo da gitijigari nembodiba Caesar awa nangoda gitijigari ra. Nango nei dipapa aera.” ");
INSERT INTO nou_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Edo ungo awodo setero Pilate mi Iesu awa ungoda ingo da ititisira benema mi orega da dorase. Awasedo ungo mi Iesu budo mambusera. ");
INSERT INTO nou_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesu umo umosuka uso orega awa ango edo bugudo yei Hebrew ge mi sedo era Golgotha ainda be awa jiro agatu yei ainda bugusira. ");
INSERT INTO nou_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Edo ainda bugudo ungo mi benema mi Iesu orega da dorisera. Edo ungo daedo benema mi embo etoto awa orega etoto da dorisera embo da Iesu da be nei da edo embo nei Iesu da be nei da edo Iesu awa soropuda isira. Edo awodo edo orega awa busu da dederisera. ");
INSERT INTO nou_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Edo Pilate mi ove jivetiri ungo mi orega inda ititisera. Edo Pilate mi jiusira, “Iesu Nazareth nati embo Jew embobo da gitijigari nembodiba.” ");
INSERT INTO nou_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Edo Jew embobo jiwari eiawa ajigedo gosisera ko yei Iesu benemami orega da dorisera awa nati aikambu awasedo. Edo Pilate ge eiawa Hebrew ge mi Latin Ge mi edo Greek ge mi jiusira. ");
INSERT INTO nou_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Edo Jew embobo da priest babojegari mi Pilate da yei sisera, “Jew embobo da gitijigari nembodiba awodo gaiose te eiedo jiveio, ‘Embo emimi sisira, na awa Jew embobo da gitijigari nembodiba ra.” ");
INSERT INTO nou_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Edo ungo awodo setero Pilate mi mina sisira, “Ro nanemi gaetena awa dowo atare.” ");
INSERT INTO nou_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Edo isoro embobo Iesu benema mi orega da dedo atae edo uso ombari awa burisera. Edo ombari budo keredo diti 4 awodo isera diti da isoro embo da da awasedo. Edo ungo uso sini daedo burisera. Edo eiawa bo memeia mi dada gaiae rate bo da ra. ");
INSERT INTO nou_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Awasedo isoro embo mi ungo ungosuka mina sara isera, “Ingode eiawa keradi aera te ingode pipi gaedo embo amemi beiri awa gore.” Edo ungo awodo isera awa ro jiwari mi sisira awa be isira. Edo jiwari mi sira, “Ungo mi naso ombari awa keredo da da edo burisera edo pipi edo naso sini awa amemi beiri awa gadi isera.” ");
INSERT INTO nou_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Edo Iesu da ai de uso ai da jao Mary, Clopas da aro de Mary Magdalene de awa Iesu da orega demo da dederi gido atisera. ");
INSERT INTO nou_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Edo Iesu uso ai de edo ambojimbi umo dubo budo isira awa ainda derido atero gido uso ai da sisira, “Evetu iso mei eire.” ");
INSERT INTO nou_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Edo umo awodo sedo ambojimbi da yei sisira, “Iso aia eire.” Edo iji ainde tuturo edo ambojimbi mi evetu awa budo uso mando da atarase budo mambudo edo umo simba edo isira. ");
INSERT INTO nou_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesu rora berari awa inono isira awa gido umo sisira, “Na umo ujo ira.” Setiri jiwari awa be isira. ");
INSERT INTO nou_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Edo adego grape ngamo tokaka de awa ainda atisira awa bo da patido ri patu da mendo da itido jigero Iesu da begiti da indarase mambusira. ");
INSERT INTO nou_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Edo Iesu grape ngamo tokaka awa budo sisira, “Atae etira.” Edo umo awa sedo tumo gosugedo bebetisira. ");
INSERT INTO nou_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Edo iji awa Friday edo ungo tamo awa orega da atiroro ungoda tumondebain ari iji eurase ujo ae isera edo daedo ainda be awa Jarusegari Bondo da iji de da awasedo. Awasedo Jew embobo mi Pilate da yei sisera, “Embomei oiawa burigi betorase awa inemi awara saso isoro embobo mi mambudo ungoda tei dedo jorore. Edo ungo awodo oro embobo oiawa burigi betoro ungoda tamo awa orega da awa dodo itoro wosore.” ");
INSERT INTO nou_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Awasedo isoro embobo mi mambudo embo Iesu da be nei da ainda tei etoto awa dedo ereregedo edo embo Iesu da be nei da ainde daedo dedo tei ereregurisera. ");
INSERT INTO nou_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Awarate ungo Iesu da yei da bugudo umo matu bebetisira awa gido gido uso tei dedo eregae doturisera. ");
INSERT INTO nou_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Awarate isoro embo da mi uso gi mi Iesu da demburo da sinegetiri ororo de sasaka de bebesisira. ");
INSERT INTO nou_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Edo embo eiawa etiri gosisira embo amimi awa sisira ingo mi gebe awase. Edo umo ro sisira awa gebe. Edo umo ro sira awa gebe gosira. ");
INSERT INTO nou_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Edo isoro embobo awa etero ro jiwari mi sira awa be isira. Edo jiwari mi sira “Ungomi uso vetu da mana doro eragadira.” ");
INSERT INTO nou_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Edo jiwari nei mi sira, “Embo mi uso demburo da gaisera awa gongon adera.” ");
INSERT INTO nou_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Arimathea nati embo jawo Joseph awa Iesu ambo ambo ari embo ra te umo Jewembobo awa oju edo umo Iesu ambo ambo edo isira awa isaga ari georase edo isira. Edo unemi Pilate da yei mambudo Iesu da tamo orega da awa budo itari wosarase sedo gosisira. Edo Pilate mi awara setiri, Joseph Iesu da tamo orega da awa budo itiri wosetiri mambusira. ");
INSERT INTO nou_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","40","Edo Nicodemus embo tumba de Iesu gadi mambusira embo awa Joseph ga da mambusira. Edo Jew embobo mi siwo muno de ri mu mi isera. Edo embo betari bo siwo einda patido edo embo ainda tamo awa dogedo edo gowadi sedo isera. Edo eiawa ungoda wasiri ra. Awasedo Nicodemus siwo eiawa jiwae be budo mambusira. Edo embo etoto emimi Iesu da tamo awa budo bo awa siwo einda patido edo Iesu da tamo awa bo amimi dogisera. ");
INSERT INTO nou_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Edo Jew embobo mi Iesu dorisera yei ainda demo da awa ri guru ra. Edo ri guru da awa embo gowari meko seka ra. Edo embo gowari meko einda embo da ave gowae atinatina. ");
INSERT INTO nou_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Edo iji awa Jew embobo da mamaso ari iji aikambu isira awasedo ungo Iesu gowari dipapa isera simba adi ae. Edo embo gowari meko awa aikambu gido Iesu ainda ititisera. ");
INSERT INTO nou_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sunday sipo keredo piri Mary Magdalene gowari meko da mambusira. Edo ainda mambudo ganuma nembodiba meko be gajisera awa demo da mambudo atiri gosisira. ");
INSERT INTO nou_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Edo awa gido umo sumbudo Simon Peter de edo ambojimbi nei Iesu mi dubo budo isira ainda yei sisira, “Ungo mi Bada da tamo gowari meko da awa budo mambera. Edo umo yei rawainda iteri awa nango gaera.” ");
INSERT INTO nou_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Edo evetu awa awodo setiri Peter de ambojimbi nei de awa gowari meko da mambusera. ");
INSERT INTO nou_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Edo ungo etoto awa sumbero edo ambojimbi nei mi sumbudo Peter derigedo edo meko da giti bugusira. ");
INSERT INTO nou_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Edo umo kukubedo Iesu da tamo kera isera bo awa gosisira te umo torae doturisira. ");
INSERT INTO nou_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Edo uso gun da awa Simon Peter mi bugudo dambuderari meko da totorisira. ");
INSERT INTO nou_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Edo umo torido bo Iesu kera isera awa ainda pasido atiri gosisira edo uso beo dogisera bo awa atiri gosisira. Edo bo awa bo nei da demo da atae ra te demo da umo umosuka bojegari atiri gosisira. ");
INSERT INTO nou_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Edo ambojimbi nei giti meko da bugusira awa Peter ambo ambo edo totorisira. Edo umo torido gido umo ge be isira. ");
INSERT INTO nou_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Edo matu ro jiwari mi sisira Iesu betedo edo sekago eradira sisira awa matu ungo gae isera. ");
INSERT INTO nou_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Edo ambojimbi sekago nati da engenemburisera. ");
INSERT INTO nou_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Edo Mary awa meko ponda derido ji sise atisira. Edo umo ji sise kukubedo meko jo awa gosisira. ");
INSERT INTO nou_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Edo umo asisi ewamei etoto ombari parara berari edo yei Iesu da tamo atisira ainda da uso kopiri da edo da uso tei da edo atero gosisira. ");
INSERT INTO nou_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Edo umo diti jo da edo gosiri ungo mi nganega isera, “Evetu imo ro edo ji sesi?” Setero unemi mina sisira, “Ungo mi naso Bada budo mambera edo yei rawainda iteri awa na gae ra.” ");
INSERT INTO nou_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Edo Mary awa sedo kaveregedo Iesu ainda derido atiri gosisira te umo Iesu awa umo gae ra. ");
INSERT INTO nou_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Edo Iesu mi evetu ainda yei sisira, “Evetu imo ro edo ji sesi? Edo imo ave eura esi?” Setiri edo Mary umo kotisira awa buro awa simba ari embo awa kotedo uso yei sisira, “Embo ewamei imo umo budo mambesi ta yei rawainda itesi awa segae gido na mambudo umo bane.” ");
INSERT INTO nou_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Edo evetu awa setiri, Iesu mi uso yei sisira, “Mary.” Setiri umo Iesu kena wareregedo Hebrew ge mi sisira, “Rabboni,” ainda be awa “Atopatari.” ");
INSERT INTO nou_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Edo evetu awa awodo setiri Iesu mi uso yei sisira, “Na tamesi eose ko na Mama da yei sekago vitae atena. Awarate imo naso nanonamendi da yei mambudo seio gore, ‘Na sekago embo naso Mama edo ingoda Mamo edo naso God edo ingoda God ainda yei vivitena.’” ");
INSERT INTO nou_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Edo Iesu awodo setiri Mary Magdalene ambojimbi da yei mambudo sisira, “Na Bada getena.” Edo umo awodo sedo uso binga awa ungoda yei sisira. ");
INSERT INTO nou_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Edo Sunday ongobo de ambojimbi dada edo mangiro be dedo atisera ainda be awa ungo Jew embobo da gitijijigegari awa oju edo gido. Edo Iesu bugudo ungoda soropuda dederisira. Edo ainda derido sisira, “Jo jamo jamo de atiwo.” ");
INSERT INTO nou_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Edo umo awa sedo uso ingo de demburo de awa ujiji isira. Edo ambojimbi Bada gido iaviri mi ungoda jo awa beda isira. ");
INSERT INTO nou_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Edo Iesu sekago ungoda yei sisira, “Jo jamo jamo de da atiwo. Edo Mama mi na ititisira da awodo nanemi ingo ititena.” ");
INSERT INTO nou_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Edo umo awa sedo oena ungoda yei pusedo sisira, “Asisi Kotopu buwo. ");
INSERT INTO nou_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Edo ingo embo da wasiri bebegae kotembedo doadewa awa ungoda wasiri bebegae awa atae adira te ingo embo da wasiri bebegae kotembedo doae adewa awa ungoda wasiri bebegae awa atadira.” ");
INSERT INTO nou_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Edo Iesu bugusira iji ainde ambojimbi da Thomas uso jawo dirugurisera dindiga awa ainda daedo atae ra. ");
INSERT INTO nou_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Awasedo ambojimbi nenei mi uso yei sisera, “Nango Bada gositara.” Setero Thomas mi ungoda yei sisira, “Na uso benema mi ingo da dorisera ainda bubuko awa gae adena edo uso bubuko awa jigae adena awa na mana ge be adena. Edo na ingo mi uso demburo da bubuko awa jigae adena awa na ge be adi aera.” ");
INSERT INTO nou_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Edo pura da atae etiri ainda amboda ambojimbi awa sekago mando jo da dada isera. Edo iji einde Thomas awa daedo ainda ra. Edo ungo mangiro be didigurisera te Iesu bugudo ungoda teda dederisira. Edo ainda derido atise ungoda yei sisira, “Jo jamo jamo de atiwo.” ");
INSERT INTO nou_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Edo umo awa sedo Thomas da yei sisira, “Na einda iso ingo mi tamesi edo edo naso ingo gio. Edo awodo edo iso ingo gogorugedo naso demburo jigido gio. Edo mana mana dodo na ge be eio.” ");
INSERT INTO nou_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Setiri Thomas mi sisira, “Imo awa naso Bada edo naso God.” ");
INSERT INTO nou_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Edo Thomas awodo setiri Iesu mi uso yei sisira, “Imo na gosesa awasedo imo na ge be esa. Embo ave na gae rate na ge be edo era awa ungo dubo ewamei edo era.” ");
INSERT INTO nou_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Edo Iesu uso ambojimbi de atise ari wasiri nembogamo jiwae be isira te na eiawa berari einda jiwae ra. ");
INSERT INTO nou_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Edo na ove eiawa jivetena awa ingo Iesu awa God da mei edo umo awa soregari embo God mi itari bugarase sisira awa ge be awase etena. Edo ingo eiawa ge be ise uso jawo da wasiri mata awa atari badewa. ");
INSERT INTO nou_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Amboda iji da umo jirora Tiberias ainda Iesu uso ambojimbi da yei umo umosuka ujiji etiri gosisera. ");
INSERT INTO nou_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Edo eiedo isira. Simon Peter de Thomas uso jawo dirugedo dindiga sisera ainde Nathanael Galilee busu embo uso nati Cana edo Zebedee da memei de edo ambojimbi nenei etoto de awa dada anumbedo atisera. ");
INSERT INTO nou_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Edo Simon Peter mi ambojimbi nenei da yei sisira, “Na wo oiro adi mambadena.” Edo Peter awodo setiri ungo mi uso yei sisera, “Nango ingae da mambadera.” Awasedo ungo berari nga da sirido mambusera te ungo wo beradi tumba da awa jarisera te wo da ro bae isera. ");
INSERT INTO nou_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Edo waiko vitido piri Iesu kora da dederisira te ambojimbi Iesu awa gadi jarisera. ");
INSERT INTO nou_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Edo unemi ungo jawo sedo sisira, “Singa banga ingo wo dimbevi ta?” Setiri ungo mi mina sisira, “Da ro baera.” ");
INSERT INTO nou_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Edo ungo awodo setero unemi ungoda yei sisira, “Ingoda monga awa ingoda ingo be kena nga demo da pigewo edo ainda wo tambadewa.” Setiri ungo ungoda monga pigedo edo monga awa jumbari nga da vitari awa sago ae isira ainda be awa ungo wo jiwae be burisera awasedo. ");
INSERT INTO nou_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Edo Iesu mi ambojimbi da dubo budo isira amimi Peter da yei sisira, “Omone Bada ra.” Edo omone Bada ra ingisira awa Simon Peter umo uso bo tu de isira awasedo uso bo tamo awa budo sekago asugurisira. Edo asugedo umo da kekapuiya isira. ");
INSERT INTO nou_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Edo ambojimbi nenei awa wo monga de awa nga de jumbudo ambo da diga da bugusera. Edo ungo awa kiambu beda go wo oiro isera awasedo. ");
INSERT INTO nou_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Edo ungo poi da vivitigedo riawo ainda eviri gosisera. Edo ri da awa wo de ambe de eviri gosisera. ");
INSERT INTO nou_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Edo Iesu mi sisira, “Wo boroko betewa awa nenei budo pou.” ");
INSERT INTO nou_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Setiri Simon Peter mambudo monga awa jumbiri poi da vivitisira. Edo monga awa wo jiwae be mi ato ae isira ungoda ajigari awa 153 awarate monga diwae isira. ");
INSERT INTO nou_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Edo Iesu mi ungoda yei sisira, “Puwo indari indawe.” Edo umo awodo setiri ambojimbi ungo oju kiambu de umo averi awa nganega ae doturisera ko ungo gosisera umo awa Bada awasedo. ");
INSERT INTO nou_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Awasedo Iesu ungoda yei mambudo ambe ititisira. Edo wo de da awodo isira. ");
INSERT INTO nou_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Edo Iesu betetiri God mi etiri erido iji tamonde umo umosuka ambojimbi da yei isaga isira. ");
INSERT INTO nou_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Edo ungo indari indero Iesu mi Simon Peter da yei sisira, “Simon John da mei iso dubo bari naso yei mo embo nenei da dubo bari naso yei da eiedo aeta?” Setiri Peter mi mina sisira, “Ge be Bada, imo gosesa na imo dubo burena.” Edo umo awodo setiri Iesu mi uso yei sisira, “Naso sheep simba eio.” ");
INSERT INTO nou_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Edo Iesu awodo sedo sekago uso yei sisira, “Simon John da mei imo na dubo buresi ta?” Setiri Peter mi mina sisira, “Gebe Bada imo gosesa na imo dubo burena.” Edo umo awodo setiri Iesu mi uso yei sisira, “Naso sheep simba eio.” ");
INSERT INTO nou_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Edo Iesu awa sedo sekago uso yei sisira, “Simon John da mei, imo na dubo buresi ta?” Setiri Peter dubo vevera isira ko Iesu iji tamonde umo nganega isira, “Imo na dubo buresi ta?” Edo dubo vevera de uso yei sisira, “Bada imo rora berari gari ra edo imo gosesa na imo dubo burena.” Edo Peter awodo setiri Iesu mi uso yei sisira, “Naso sheep simba eio. ");
INSERT INTO nou_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Edo na iso yei ge be sena, imo mei singa atisera iji ainde imo iso sini awa digido edo imo yei rawainda mambadi dipapa edo isesa ainda mambudo isesa. Awarate imo ogo adesa iji ainde imo iso ingo kerere aso embo nei mi imo awa budo imo gitijigido budo imo dipapa ae esa yei ainda mambadira.” ");
INSERT INTO nou_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Edo awa sisira awa Peter umo rawodo betadiri awa sisira. Edo sisira Peter da betari mi God da jawo awa jigari eradira. Edo Iesu awa sedo Peter da yei sisira, “Na ambo ambo eio.” ");
INSERT INTO nou_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Edo Peter wareregedo ambojimbi nei Iesu mi dubo budo isira awa gosisira ambojimbi Iesu da demo da desegedo nganega isira Bada imo mo amemi indiga eiri sisira. ");
INSERT INTO nou_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Edo Peter ambojimbi awa gido Iesu da yei sisira, “Bada embo einda mo ro eiri?” ");
INSERT INTO nou_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Edo Peter awodo setiri Iesu mi mina sisira, “Umo wasiri de atadira awa wasiri de atirari na engenembadena iji awa ta rora. Edo na awodo dipapa adena awa amone naso buro ra. Imo na ambo ambo eio.” ");
INSERT INTO nou_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Awasedo ge awa Iesu ambo ambo ari embobo berari da yei rawusira ambojimbi eiawa betadi aera awa. Awarate Iesu umo betadi aera awodo sae ra. Te umo sisira, “Umo wasiri de atadira awa umo wasiri de atirari na engenembadena iji awa ta rora. Edo na awodo dipapa adena awa naso buro ra.” ");
INSERT INTO nou_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Edo embo re embo amimi wasiri eiawa iri gosisira embo amimi sira. Edo unemi daedo wasiri isira awa gaira. Edo ingodena gosera umo ro sise gaira awa ge be ra. ");
INSERT INTO nou_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu ari wasiri nenei jiwae be isira. Edo embo da mi uso ari wasiri awa berari kiki da jiwae etira awa busu berari awa jiwari jigari inono ae awasedo uso wasiri nenei ainda kiki jiwari sago aera. ");
INSERT INTO nou_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Oarie Theophilus, Naso ove tuturo da na Iesu mi rora berari uso buro tuturo ise isira edo atopapotisira ainda edo mambudo umo God mi budo utu da vivitisira awa gaisena. ");
INSERT INTO nou_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Edo God Iesu umo budo utu da vitae atiri Iesu Asisi Kotopu da goroba mi binga atopatari embobo unemi jawo sisira amimi ro arase sisira awa. ");
INSERT INTO nou_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Edo Iesu betedo sekago erido iji 40 awodo de uso binga atopatari embobo da iji jiwae isaga euri gido isera. Edo umo isaga ise wasiri neinde kainde jiwae be euri gido edo ungo Iesu umo wasiri de atira awa gido isera. Edo ungo umo georo edo umo daedo God da gitijigari iji awa seuri gido isera. ");
INSERT INTO nou_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Edo ungo dada etero ungoda yei sisira, “Jerusalem nati awa dove ta kando naso Mama mi itadi ari seteno gosisewa awa simba ewo. ");
INSERT INTO nou_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John umo mi ingo ewamei isira te iji tupo atae ari God mi ingo Asisi Kotopu mi ewamei adira.” ");
INSERT INTO nou_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Edo Iesu binga atopatari embobo Iesu ga dada edo ungo mi uso yei nganega isera, “Bada imo iji boroko einde aso Israel embobo erido goroba embobo ungo matu atima isera awodo eri ta? ");
INSERT INTO nou_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Setero Iesu mi ungoda yei sisira, “Naso Mama mi rora berari awa arase dipapa ira iji ainde awa adira te unemi iji awa ingoda yei mana isaga sari gadewa. ");
INSERT INTO nou_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Awarate Asisi Kotopu mi ingoda yei bugudo ingo awa goroba mi siradira edo iji ainde ingo mi embo berari awa na awa sawo gadera. Ingo mi embo Jerusalem nati da Judea de Samaria busu de edo busu berari da embobo awa sawo gadera.” ");
INSERT INTO nou_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Edo umo awa setiri ungo berari ditini ise atero God mi umo budo utu da vivitisira. Edo umo kiambu vitiri edo poroga mi umo gajetiri ungo umo gadi jarisera. ");
INSERT INTO nou_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Edo ungo diti inda edo gadi jarise atero embo etoto ombari parara edo bugudo, ungoda demo da dederisera. ");
INSERT INTO nou_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Edo ungo ainda derido atise sisera, “Galilee busu embobo ingo roedo ainda derido edo diti inda edo atevi? Iesu emone God mi ingoda yei budo utu da vitira edo umo vivitiri getewa da awodo engenemburisira.” ");
INSERT INTO nou_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iesu da binga atopatari embobo doriri Olive awa dodo diugedo aikambu awodo Jerusalem nati da engenemburisera. ");
INSERT INTO nou_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Edo ungo Jerusalem nati da torido edo ungo mando atima isera ainda mambusera edo mando inda vivitisera. Edo Iesu da binga atopatari embobo da jawo re eire, Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, Alphaeus da mei James, Simon Zelotes, James da mei Judas de. ");
INSERT INTO nou_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Edo ungo embo evetu de Iesu da ai Mary de Iesu da nanonamendi de iji jiwae God manunugadi sedo dada edo isera. ");
INSERT INTO nou_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Edo iji tupo embo jiwae be Iesu gebe edo isera, ungoda ajigari gano 120 awa dada isera. ");
INSERT INTO nou_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Edo ungo dada etero Peter erido sisira, “Naso nanonamendi matu be matu jiwari mi Judas ro adiri awa gebe sisira. Edo Asisi Kotopu mi David da yei setiri David mi sisira Judas mi embo gitijigido Iesu umo rawainda atira ainda umo bundorase mambadira. ");
INSERT INTO nou_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas awa nangoda embo nei na umo awa Iesu mi nango de buro arase jawo sisira.” ");
INSERT INTO nou_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Edo Judas mi unemi uso wasiri biae mi ganu burisira amimi busu ori isira. Edo Judas busu ainda mambudo durido betetiri uso jo da jombe poporo awa bejutara. Edo umo betutara. ");
INSERT INTO nou_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Edo embo berari Jerusalem nati da awa ro iutara awa ingido busu ainda jawo ungoda ge mi sisera ‘Akeldama’ ainda be awa ‘Embo da betari da ororo da yei.’ ");
INSERT INTO nou_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Edo Peter ge sise sisira, “Judas da jawo da ge sise edo jiwari jawo Psalm mi sisira awa sane, ‘Dowo uso mando awa ro atae are. Edo embo doawo ainda atore.’ Edo Psalm nei mi sira, ‘Dowo embo nei mi uso buro awa budo ore.’ ");
INSERT INTO nou_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Awasedo ingode embo nei da yei Iesu da sekago erari da binga sari buro eiawa embo nei da yei itadera. Edo embo eiawa Iesu ga da John umo umo mi embo ewamei isira ainda tuturo edo bugudo mambudo Iesu utu da vivitisira ainde nango de daedo atevira embo awa ra. Edo embo eiawa nango Iesu ga pepeta edo isera ainde nango de daedo atevira embo awa ra.” ");
INSERT INTO nou_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Awasedo embo ainda atisera amimi embo etoto da jawo awa sisera Joseph Barsabbas uso jawo nei Justus de Matthias de.” ");
INSERT INTO nou_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Edo ungo God manunugedo sisera, “Bada God imo embo berari da kotari gido esa awasedo embo etoto eiawa amemi Judas da buro awa beri awa nangoda yei isaga egae gore. ");
INSERT INTO nou_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Edo embo eiawa Iesu da binga atopatari embo adira. Judas uso buro dodo edo riawo euse natopo atari ainda mambutara awasedo embo emimi uso yei badira.” ");
INSERT INTO nou_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Edo ungo awodo sedo embo etoto da jawo awa ewoga ewoga gaisera edo ou da jo da ititisera. Edo ou awa budo wareregetero Matthias da jawo awa giti wowosisira. Edo awodo edo ungo mi Matthias awa geretero edo umo awa Iesu da binga atopatari embobo 12 ainda embo nei isira. ");
INSERT INTO nou_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Amboda Pentecost da bondo iji awa bugiri Iesu gebe edo isera embobo awa yei ainda dada isera. ");
INSERT INTO nou_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Edo ungo dada etero edo javi utu da teta bisara nembodiba sumbuse sedo ira da awodo awa ingero bugusira. Edo bugudo javi amimi mando ungo atisera awa beda isera. ");
INSERT INTO nou_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Edo javi amimi mando awa beda etiri ungo rora teta ri avewa da awodo gosisera. Edo rora gosisera amimi ewoga ewoga edo embo da da ainda beo da anumburisira. ");
INSERT INTO nou_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Edo awodo edo Asisi Kotopu mi embo dada ainda atisera awa beda isira. Edo Asisi Kotopu mi ungo kondade etiri ge nei ungo gae awa sisera. ");
INSERT INTO nou_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Edo iji ainde Jew embobo jiwae be busu nenei da atima isera awa Jerusalem nati awa bondo iji de esega isera ainda be awa ungo Jew embobo da wasiri awa edo gogo edo ambo ambo edo isera awasedo. ");
INSERT INTO nou_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Edo embo jiwae be javi awa ingido dada isera. Edo ungo kove be isera ainda be awa Iesu ge be ari embobo awa ge sera iji ainde ungo berari dada ungoda ge topo awa ingera awasedo. ");
INSERT INTO nou_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Edo ungo ge awodo ingise sisera, “Embo ge sera eiawa ungo Galilee busu embobo ra edo rawodo edo nango nangoda ge topo mi ge ingeri. ");
INSERT INTO nou_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Nango awa Parthia busu Media busu Elam busu Mesopotamia busu Judea busu Cappadocia busu edo Pontus busu edo Asia busu Phrygia busu Pamphylia busu edo Egypt busu embobo ra. Edo nango nenei awa Cyrene nati Libya busu aikambu atima era. Edo nango nenei awa Rome nati embobo ra. ");
INSERT INTO nou_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Edo nango nenei awa Jew embobo ra te embo nenei awa Jew aera awa wareregedo Jew embobo da wasiri awa ambo ambo era. Nango awa busu neinde kainde embobo ra edo nango nenei awa Crete edo Arabia busu embobo ra te embobo eiawa wasiri nembodiba God mi etira awa sero nango nangoda ge topo mi sero ungoda ge awa ingera.” ");
INSERT INTO nou_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Edo ungo kove be edo mana mana ise mina sara isera, “Einda be mo rori?” ");
INSERT INTO nou_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Awarate embo nenei mi Iesu ge be ari embobo awa gandubedo iro jirise sisera, “Embo oiawa umo okain indido jiro bebegae etera.” ");
INSERT INTO nou_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Edo Peter, Iesu da binga atopatari embobo 12 aindeda gogo dimbudo embo jiwae be da yei sisira, “Ingo embo berari Jerusalem nati da atima ewa edo ingo Judea busu embobo naso ge ingiwo. Edo ingo ingirowo wasiri etira einda be awa ujugano gave. ");
INSERT INTO nou_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ingo kotewa embomein eiawa umo okain indido jiro bebegae ari ge sewa te awodo aera ungo awa umo okain indae ra. Embomei sipo 9 A.M. de ungo mana umo okain indadera. ");
INSERT INTO nou_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wasiri eiawa ro God da binga sari embo Joel mi sisira awa ra. ");
INSERT INTO nou_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Joel mi sisira, ‘God mi sira, “Eiawa nanemi iji sangove de adena. Na naso Asisi Kotopu itano bugudo embo awa amimi beda adira. Ingoda orobe memei de meingagara deawa Asisi Kotopu da goroba mi naso binga awa goroba de minonu sadera. Ingoda memei singa awa ari neinde kainde isaga da gadera edo ingoda embo ogogo awa eturo adera. ");
INSERT INTO nou_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Edo embo de evetu de iji ainde na kera era ainda yei naso Asisi Kotopu awa itadena. Edo umo ungoda yei bugari ungo Asisi Kotopu da goroba mi naso binga awa be goroba de minonu sadera. ");
INSERT INTO nou_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Edo nanemi utu inda edo busu tuda wasiri goroba de jiwae be adena. Edo embo mi ari wasiri goroba de awa gido kove be adera. Edo ungo mi ororo de riawo de umbosi umenga be de awa gadera. ");
INSERT INTO nou_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Edo iji awa umenga adira edo kariga awa teta ororo inge kokoi adira. Edo wasiri eiawa ari edo Bada da iji awa bugadira. Edo iji einde nanemi naso goroba de kasari de awa embo da yei isaga adena. ");
INSERT INTO nou_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Awarate embo amemi sadira, Bada na kondade egae sadira embo awa Bada mi soregadira.” ’ ");
INSERT INTO nou_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel embobo ge eiawa ingiwo. Iesu Nazareth nati embo awa God da goroba mi ari wasiri goroba de euri embo mi gido kove be edo isera. Edo ari wasiri goroba de eiawa Iesu mi ingoda teda atise edo isira amone God da iwata ra awasedo ingo gosise Iesu mi God da buro isira awa gido ewa. ");
INSERT INTO nou_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Edo ingo awara sedo embo bebegae da ingo da Iesu itewo edo orega da benema mi detero umo bebetisira. Awarate ingo isewa awa ro God mi dipapa isira awa isewa ainda be awa God mi matu be matu Iesu ingoda ingo da itadi sedo sia isira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Awarate Iesu betetiri God mi sekago etiri eririsira. Betari da memesi mi Iesu jigido takibari sago ae isira ainda be awa God mi umo wujegurisira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Iesu da jawo da ge sise David mi sisira, ‘Na gosena Bada God awa nangae atima ira. Umo na kondade edo ira. Uso goroba nembodiba mi na gaimbedo ira. ");
INSERT INTO nou_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Awasedo naso jo awa iaviri mi beda etira edo na naso avewa mi iji berari umo jasiga adena. Naso betari iji awa bugadira te iji ainde na mana oju adena ainda be awa imo mana naso asisi awa bebetegari embobo da yei doadesa edo aso iso agipo embo saboa ari uso tamo awa mana betadira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Imo naso yei wasiri matawa atari da emboro awa ujiji eteso getena. Edo inemi naso jo awa iaviri mi siradesa ko imo awa iji berari mata awodo nangae atima esa.’ ");
INSERT INTO nou_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nanonamendi ingodenaso mamoumbogo David da ge isaga sano gave. David umo bebetisira etiri umo gousera. Edo uso uje awa boroko ingodenaso yei boroko atira. ");
INSERT INTO nou_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Edo umo awa binga sari embo ra. Edo God mi uso yei ro adi sisira awa umo gosisira. Edo God mi adi sari David da yei sisira unemi ari David da orobe da mi gitijigari nembodiba adira teta David inge. ");
INSERT INTO nou_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Edo David umo God mi amboda ro adira awa gosisira awasedo umo soregari embo God mi itari bugarase sisira ainda sekago erari awa sisira. Edo uso jawo da ge sise David mi sisira, ‘God mi mana uso asisi awa bebetegari embobo da yei da doadira. Edo uso tamo awa mana betedo sununusadira.’ ");
INSERT INTO nou_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Edo embo Iesu eiawa betetiri God mi sekago jigiri erira. Edo nango umo wasiri de gido ingoda yei wasiri eiawa soro gawase sera. ");
INSERT INTO nou_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Edo God umo Iesu etiri eriri budo uso ingo be da itido edo gitijigarase sedo uso yei goroba ititara. God mi uso yei Asisi Kotopu ititara unemi adi sisira da awodo. Edo Iesu mi nangoda yei Asisi Kotopu itiri wosedo wasiri amimi etiri wasiri berari ingo mi boroko gido edo ingewa awa iutara. ");
INSERT INTO nou_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David umo umosuka utu da teta Iesu mi iutara da awodo edo vitae rate Iesu da jawo da ge sisira, ‘Bada God mi naso Bada da yei sisira naso ingo be da einda anumbedo atio. ");
INSERT INTO nou_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Edo imo einda atiroso nanemi ano iso gitopo embobo awa teta iso tei tuda besi da awodo ore sisira.’ ");
INSERT INTO nou_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Awasedo na ingoda yei isaga minonu sena, ingo Israel embobo, embo eiawa ingo mi benema mi orega da doritawa awa God mi etiri ererara edo umo awa ingodenaso gitijigari nembodiba iutara. Edo God mi embo eiawa soregari embo itari bugarase sisira awa ingodenaso yei isaga iutara.” ");
INSERT INTO nou_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Edo Peter awodo setiri embo ge ingise atisera awa jegigi nembodiba edo Peter de Iesu da binga atopatari embo nenei de da yei sisera, “Nanonamendi nango ro eri?” ");
INSERT INTO nou_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Setero Peter mi ungoda yei sisira, “Wasiri bebegae ingoda awa dodo edo God da yei wareregewo. Edo Iesu Keriso da jawo da umo mi ewamei ari wasiri awa buwo. Edo God mi ingoda wasiri bebegae awa kotembedo doari edo ingo God da kando Asisi Kotopu awa bave ko eiawa God mi adi sisira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Edo unemi embo ave uso yei purorase jawo sira ingo edo ingoda kinapeina da edo embo Jew ae ainda eiawa adi sari sisira.” ");
INSERT INTO nou_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Edo Peter awodo sedo umo sekago ungoda yei iji ribori be ge sisira. Edo sisira, “Riroga nembodiba be awa ingodenaso wasiri bebegae embobo da yei bugutira. Edo doawo riroga eiawa ingoda yei bugure ta God sedo giwo ingo soregare.” ");
INSERT INTO nou_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Edo embo jiwae be Peter da ge ingise atisera awa uso binga awa ge be isera. Edo ungo ge be edo umo mi ewamei ari da wasiri awa burisera. Edo embo Iesu ge be ari embobo da dada isera iji ainde awa ungoda ajigari awa 3,000 ra. ");
INSERT INTO nou_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Edo ungo iji dada yei Iesu da binga atopatari embobo atopatido isera ainda mambudo isera. Edo ungo Iesu mi ungo embo ro ira awa kiki mina dira adi daedo dada edo isera. Edo ungo daedo indari dada indise edo God inono da dada manunugedo isera. ");
INSERT INTO nou_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iesu mi euri uso binga atopatari embobo ari wasiri goroba de edo ari wasiri embo mi matu gae awa edo isera awasedo embo God da yei saboa isera. ");
INSERT INTO nou_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Edo Iesu ge be ari embobo iji berari kiki dada dirido isera. Edo ungo ungoda rora awa kando mina ara edo isera. ");
INSERT INTO nou_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Edo ungo ungoda rovi ravi awa ori edo ganu awa embo rora ae embobo ungoda teda ainda kando edo budo isera. ");
INSERT INTO nou_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Edo iji jaige ungo Jew embobo da tumondebain ari oro da dada edo isera. Edo ungoda mando da embo diti kiambu eiawa dada edo ambe ngaugurisera. Edo ungo ungoda indari awa kando osisa mina ara edo ungo iaviri dada edo isera. ");
INSERT INTO nou_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Edo ungo awodo edo doae rate ungo iji berari God jasiga edo isera. Edo embo berari ungo sapo edo isera. Edo iji jaige Bada God embo soregedo isira. Edo ungo soregeuri ungo Iesu ge be ari embobo da teda torido isera. ");
INSERT INTO nou_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Iji da 3 P.M. ongobo de embo da God manunugari iji awa bugiri Peter de John de awa Jew embobo da tumondebain ari oro da mambusera. ");
INSERT INTO nou_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Edo ungo bugudo be jawo be ewamei awa aikambu ise embo nenei mi embo tei ambari awa ango edo bugetero gosisera. Edo embo eiawa uso ai mi burisira iji ainda edo bugudo boroko awa embo ami pepeta ae. Awasedo iji berari uso otatao mi umo ango edo budo bugudo Jew embobo da tumondebain ari oro be da ainda itoro anumbedo atima isira. Edo umo ainda anumbedo atise embo jo da totororo ganu itorase benunu sedo isira. ");
INSERT INTO nou_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Edo umo Peter de John de totorero gido gano itorase benunu sisira. ");
INSERT INTO nou_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sedo getiri Peter mi umo diti moka da ditini edo uso yei sisira, “Nango gi.” ");
INSERT INTO nou_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Setiri embo tei ambari awa umo kando badira awa kotise ungo gosisira. ");
INSERT INTO nou_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Awarate Peter mi uso yei sisira, “Na ganu ae ra te naso yei ro atiri awa iso yei itadena. Na iso yei sena, Iesu Keriso Nazareth nati embo da jawo da sena erido pepeta eio.” ");
INSERT INTO nou_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Edo Peter awodo sedo embo ainda ingo da jigido embo awa kondade etiri embo awa eradi tuturo isira. Edo umo eririri uso tei de tei akuma da awa goroba isira. ");
INSERT INTO nou_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Edo goroba etero umo burigi be kekepuinya edo dambuderari dederisira. Edo derido pepeta isira. Edo umo Peter de John de da Jew embobo da tumondebain ari oro da mambutero umo pepeta kiambu edo kekapuinya edo vitido wosedo edo pepeta nei kiambugo edo isira awodo ise umo mambusira. Edo umo awodo ise God jasiga isira. ");
INSERT INTO nou_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Edo umo pepeta ise God jasiga iri embo berari umo gosisera. ");
INSERT INTO nou_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Edo umo gido umo benunu embo Jew embobo da tumondebain ari oro be jawo be ewamei da embo anumbedo atima isira awa gosisera. Edo uso yei ro isira awa gido ungo berari kove be edo mana mana isera. ");
INSERT INTO nou_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Embo awa Peter de John de da jigido takibedo edo daedo mambutiri embo berari kove be edo sumbudo ungoda yei da Solomon da gaga sedo era gaga ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Edo Peter Israel embo amimi embobo awa gido ungoda yei sisira, “Israel embobo ari wasiri goroba de eiawa gido roedo ingo kove be evi? Edo ro edo ingo nango ditini evi? Ingo kotewa nango nangoda goroba topo mi edo gari mi etero embo eiawa pepeta ita? ");
INSERT INTO nou_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham de, Isaac de Jacob de edo ingodenaso mamoumbogo nenei de da God mi etiri uso agipo embo Iesu da jawo awa nembodiba etira. Embo re eiawa ingo mi gitijigari da ingo da ititisewa. Edo Pilate mi umo wujegadi dipapa isira te ingo mi Pilate da diti da umo ujo ae isewa. ");
INSERT INTO nou_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Edo umo awa embo ewamei edo wasiri biae ae rate ingo umo ujo ae isewa. Edo umo ujo ae edo ingo mi Pilate mi embo deuri betedo isera embo awa wujegarase sisewa. ");
INSERT INTO nou_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Edo ingo mi embo wasiri mata awa atari da susu awa detewo bebetisira. Awarate umo betetiri God mi umo etiri eririsira. Edo nango umo gosisera awasedo ingoda yei uso sekago erari awa sera. ");
INSERT INTO nou_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Edo nango Iesu ge be etero unemi embo tei ambari awa etiri ewamei etira. Edo ingo ro gosewa awa etira ainda be awa nango uso jawo da ge be etera awasedo. Edo nango Iesu da yei ge be etero unemi embo eiawa etiri ewamei etira. ");
INSERT INTO nou_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Naso nanonamendi na ingode ingoda gitijijigegari de ro Iesu da yei isewa awa gosena edo ingo awodo isewa ainda be awa ingo gae awasedo. ");
INSERT INTO nou_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Edo matu be matu ro God mi uso binga sari embobo da yei gorase sisira soregari embo itari bugarase sisira awa bugudo memesi nembodiba tambadira sisira. Edo matu be matu ungo mi ro minonu sisera awa be iutara. ");
INSERT INTO nou_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Awasedo ingoda wasiri bebegae awa dodo edo God da yei wareregewo. Edo ingo awodo awo God mi ingoda wasiri bebegae awa tupadira. ");
INSERT INTO nou_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Edo umo awodo ari Bada God unemi ingoda yei goroba seka teta embo buro jiwae be ima jango indido goroba ari seka budo ira da awodo bave. Edo Iesu soregari embo God mi itari bugarase sisira awa matu iji da bugutara awarate amboda God mi umo sekago itari bugadira. ");
INSERT INTO nou_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Edo umo awa utu da atadira te amboda rora berari seka adira ainde bugadira edo iji ainde God mi Iesu awa sekago itari bugadira. Edo matu be matu God mi uso binga sari embobo mi eiawa adira awa binga eiawa minonu sorase sisira. ");
INSERT INTO nou_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Edo Moses mi sisira, ‘Bada God mi binga sari embo ingoda yei itari bugadira na itiri bugusena da awodo. Edo binga sari embo emone ingoda embo nei na. Edo umo ge ro sadira awa ingiwo. ");
INSERT INTO nou_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Edo embo ave binga sari embo mi ro sira awa ingae adera awa embo awa God da embo de da ewoga ewoga adera edo atae adera.’ ");
INSERT INTO nou_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Edo God da binga sari embobo berari Samuel de edo binga sari embobo nenei amboda bugusera awa ungo berari mi ingodena atera iji einde ro adira awa minonu sisera. ");
INSERT INTO nou_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Edo rora berari ro ingo mi badewa edo ro adira awa God mi uso binga sari embobo mi sorase sisira. Edo ro God mi ingoda mamo umbogo da yei adi sari sisira awa ingoda yei daedo sisira. Edo God mi Abraham da yei sisira, ‘Nanemi iso orobe awa ewamei adena. Edo ewamei ari nanemi ungoda yei adena amimi busu berari da embobo ewamei adira.’ ");
INSERT INTO nou_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Awasedo God Iesu jigiri eriri giti ingoda yei itiri bugira. Edo unemi iri ingo embo berari ingoda wasiri bebegae awa dodo God da yei wareregurera. Edo awodo ira awa umo ingo ewamei ira.” ");
INSERT INTO nou_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter de John de awa embo da ge sise atero priest babojegari de Jew embobo da tumondebain ari oro simba edo era embobo ainda gitijigari de Sadducee embobo de mi ungoda yei bugusera. ");
INSERT INTO nou_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Edo ungo awa tini gambari nembodiba be isera ko Iesu da binga atopapotegari embo etoto amimi Iesu betedo eririsira da awodo awa embo betedo sekago eradi ari awa atopatari ge awasedo tini gambari isera. ");
INSERT INTO nou_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Edo ungo Peter de John de bundedo gajari oro da ititisera ainda be awa tumba jijirisira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Awarate embo jiwae be binga awa ingido ge be isera. Edo Iesu ge be ari embobo da tega awa nembodiba edo 5,000 isira. ");
INSERT INTO nou_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Edo sipo de Jew embobo da gitijijigegari de embo nembogamo nenei de agodari da atopapotegari de Jerusalem nati da dada isera. ");
INSERT INTO nou_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Edo daedo embomei ainde awa priest da bajari Annas de Caiaphas de John de Alexander de priest babojegari da orobe embo nenei deda dada isera. ");
INSERT INTO nou_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Edo ungomi setero Iesu da binga atopapotegari embobo awa jo da bugusera. Edo ungo embomei ainda jo da derero embomei amimi ungoda yei sisera, “Embo amemi ari wasiri goroba de eiawa awase ititisiri? Edo embo amenda jawo da evi?” ");
INSERT INTO nou_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","10","Setero Peter Asisi Kotopu mi beda ari mi mina ungoda yei sisira, “Ingo Jew embobo da gitijijigegari edo embo nembogamo nenei ingo embo tei ambari eiawa ari wasiri goroba mi etiri ewamei etira awa nganega ewa awa nanemi ari wasiri goroba de awa ujugano gadewa. Edo Israel embobo berari awa dowo eiawa gore. Nazareth nati embo Iesu Keriso da jawo da goroba mi etiri embo eiawa ewamei be ewamei edo ingoda teda derido atira. Iesu Keriso embo ingo mi detewo bebetisira awa God mi etiri eririsira embo amimi embo eiawa etiri ewamei iutara. ");
INSERT INTO nou_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Edo jiwari mi Iesu da jawo da matu be matu sisira, ‘Ingo mando itari embobo mi ganuma ujo ae isewa edo ganuma awa teta mando da tutuvi ganuma mi ari ainda sangove inge iutara.’ ");
INSERT INTO nou_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Edo busu berari da embo da rawa mi ingodena soregari katogo ae be ra. Edo ingode soregari awa Iesu da yei tambadera. Edo Iesu da jawo da goroba God mi embo da yei ititara embo amimi ingodena soregadira.” ");
INSERT INTO nou_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Edo Jew embobo da gitijijigegari Peter de John de oju ae isera awa gido edo ungo Jew embobo da giruma da mambudo jiro gari bae awa gido ungo kove be kove isera. Edo ungo gosisera Peter de John de awa Iesu gosisera awa. ");
INSERT INTO nou_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Edo Jew embobo de gitijijigegari awa ungoda ge mina sari sago ae isera ainda be awa embo tei ambari ewamei isira awa Peter de John de daedo derido atiri umo gosisera awasedo. ");
INSERT INTO nou_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Awasedo ungo mi setero Peter de John de dada ari yei awa doturero edo ungo ungoska ge mina sara edo sisera, “Ingode embobo einda ro eri? Embo berari Jerusalem da nati da atima era awa ungo mi ari wasiri goroba de etera awa gosera. Edo ingode ungo mi ae awa mana sadera. ");
INSERT INTO nou_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Awarate embo nenei mi kiki eiawa georase awa ingode embobo einda yei embo da yei Iesu da jawo da ge sekago seorase awa sadera.” ");
INSERT INTO nou_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Awasedo ungo mi setero Peter de John de sekago totorisera. Torero ungoda yei sisera, “Iesu da jawo da sekago ge seove. Edo daedo Iesu awa embo da yei atopatove.” ");
INSERT INTO nou_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Edo ungo awodo setero Peter de John de mi mina sisera, “Ingo ro kotevi God mi nango ingo kera orase sita mo ko God mi nango umo kera orase siri? ");
INSERT INTO nou_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nango Iesu ro iri gosisera edo ro siri ingisera awasedo nango embo nenei da yei sari awa mana doadera.” ");
INSERT INTO nou_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Edo ungo awodo setero Jew embobo da gitijijigegari mi ge okain sedo ungoda yei sekago sisera, “Sekago Iesu da jawo da ge seorase.” Edo ungo awodo sedo Peter de John de awa wujegurisera. Edo ungo Peter de John de da yei riroga itari sago ae isera ainda be awa embo berari ro isira awa gido God jasiga isera awasedo. ");
INSERT INTO nou_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Edo embo ari wasiri goroba de isira embo awa mei singa aera te uso gaeko awa 40 derigari ra. ");
INSERT INTO nou_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Edo ungo Peter de John de wujegetero ungo mambudo Iesu ge be ari embobo nenei da yei mambudo ro Jew embobo da gitijijigegari de embo nembogamo nenei de mi sisera awa setero gosisera. ");
INSERT INTO nou_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Edo ungo awa setero Iesu gebe ari embobo amimi God manunugurisera. Edo ungo mi sisera, “Bada God inemi utu de busu de isesa edo ewa de ainda jo da ro atera awa isesa. ");
INSERT INTO nou_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Edo Asisi Kotopu mi nangoda umbogo David da yei ge sisesa. Edo imo ge seteso umo iso agipo embo mi sisira, ‘Ro edo Jew embobo ae tini gambari eri? Ro edo embo kiki tepo awodo direri? ");
INSERT INTO nou_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Edo busu berari da gitijijigegari nembogamo dada edo ungo Bada God de soregari embo God mi itari bugarase sisira ainde embogo adi sia isera.’ ");
INSERT INTO nou_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Herod de Pontius Pilate de Jew embobo ae de Jew embobo de nati einda dada isera edo iso agipo embo kotopu embo Iesu inemi itaso bugarase sisesa awa doro betarase kiki dirisera. ");
INSERT INTO nou_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Edo ungo kiki awodo dirisera awarate ungo kiki ro dirisera awa ungo mi ro orase jiro buro isesa awa isera. ");
INSERT INTO nou_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Awasedo Bada God imo ungoda ge bebegae nangoda yei setera awa gosesa. Edo nango iso binga sari da agipo embobo nangoda yei sadi goroba itigae. ");
INSERT INTO nou_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Imo ingo kerere edo embo ewamei ari goroba itigae. Edo iso agipo embo kotopu Iesu da jawo da ari wasiri goroba de edo wasiri embo mi matu gae awa dogae are.” ");
INSERT INTO nou_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Edo ungo God manunugedo atae etero yei ungo dada isera awa yakawo yakawo isira. Edo ungo berari Asisi Kotopu mi beda etiri oju ae sekago God da binga sisera. ");
INSERT INTO nou_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iesu ge be ari embobo awa dada atisera edo ungoda dipapa de kotari de awa dada bundedo teta embo da da dipapa de kotari de inge isira. Edo embo da amemi rora amone naso ra awa sae ra te rora awa ungo berari mi kando edo budo isera. ");
INSERT INTO nou_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Edo Iesu da binga atopatari embobo awa Iesu da erari awa goroba nembodiba de atopatido isera. Edo ungo awodo ero God ungo nembodiba be ewamei isira. ");
INSERT INTO nou_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Edo ungoda teda embo da ave rora ae embo awodo aera ainda be awa ungo kondade mina ara edo isera awasedo. Edo embo ave busu uso topo awa ori edo isira. Edo embo nenei awa ungoda mando awa ori edo isera. Edo ori edo ganu budo isera awa Iesu da binga atopatari embobo da yei itido isera. ");
INSERT INTO nou_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Edo ungoda teda embo da ave rora ro dipapa edo isiri embo awa ganu awa nenei itido isera. ");
INSERT INTO nou_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Awasedo Joseph uso busu awa ori edo ganu awa Iesu da binga atopatari embobo da yei ititisira kando orase. Edo Joseph awa Levi da orobe ra edo uso ai mi umo Cyprus busu da burisira. Edo Iesu da binga atopatari embobo mi uso jawo Barnabas sedo isera, ainda be awa kondade ari embo. ");
INSERT INTO nou_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Embo da jawo Ananias uso aro Sapphira de awa ainda atima isera. Edo ungo ro adi kiki dirido Ananias uso busu topo nenei awa ori edo ganu nenei awa umo embo jijigurise ganu nenei awa Iesu da binga atopatari embobo da yei mambudo ititisira. ");
INSERT INTO nou_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Edo Peter mi uso yei sisira, “Ananias ro edo Satan doteso iso joda torido etiri imo Asisi Kotopu da yei ge busetesi? Imo gano berari God da yei kando adi arago etesa awarate imo busu ori edo gano nenei awa imo embo jigesa. Edo ro edo Satan iso yei awodo eurase beitigae dotesi? ");
INSERT INTO nou_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Edo busu awa ori ae giti da awa busu awa iso topo ra. Edo ori etesa edo gano awa iso topo ra. Ro edo imo iso jo da ari biae eiedo adi kotesi? Imo naso yei ge busae ra te God da yei ge busetesa.” ");
INSERT INTO nou_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Edo Peter awodo setiri Ananias uso ge ingido durido bebetisira. Edo umo betetiri embo berari ge awa ingisera awa oju isera. ");
INSERT INTO nou_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Edo mei singa da amimi bugudo uso tamo kera edo budo pon da mambusira. Mambudo gousera. ");
INSERT INTO nou_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Edo iji tupo simba ise, uso aro totorisira te umo ro isiri awa gae ra. ");
INSERT INTO nou_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Edo Peter mi uso yei sisira, “Se gane gano ingo iu ga mi betewa mo berari nangoda yei itevita?” Setiri evetu amimi mina sisira, “En gano berari awa ingoda yei itera.” ");
INSERT INTO nou_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Edo umo awodo setiri Peter mi uso yei sisira, “Ro edo imo iso iu ga kotari da awa edo Bada God da Asisi Kotopu bagetevi? Edo embo iso iu govetera awa mangiro ponda derido atera. Edo ungo mi imo daedo budo ponda mambadera.” ");
INSERT INTO nou_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Edo Peter awodo setiri evetu awa uso jo da durido bebetisira. Edo mei singa awa torido evetu awa betetiri gido budo ponda mambusera. Edo ponda mambudo uso iu da demo da gousera. ");
INSERT INTO nou_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Edo Iesu gebe ari embobo berari de embo nenei de binga awa ingido oju be isera. ");
INSERT INTO nou_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iesu da binga atopatari embobo embo da teda ari wasiri goroba de jiwae be isera edo wasiri embo nenei mi matu gae awa edo isera. Edo Iesu gebe ari embobo berari awa iji berari Solomon da gaga da dada edo isera. ");
INSERT INTO nou_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Edo embobo Iesu gebe ari embobo sapo edo isera awarete embo Iesu ge be ae edo isera awa kiambu oju edo gido ungo de daedo dada ae edo isera. ");
INSERT INTO nou_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Awarate embo mata Iesu ge be edo isera. Edo embo de evetu de jiwae be awa Iesu ge be edo Iesu ge be ari embobo nenei de dada isera. ");
INSERT INTO nou_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Edo Iesu ge be ari embobo mi ari wasiri goroba de era awa gido embo karu embobo awa baredo mambudo edo emboro da besi didiregedo ainda itido isera edo besi nenei tepo dirido emboro da itido isera. Edo ungo awodo edo isera ainda be awa ungo kotedo isera Peter pepeta irirari uso atiti mi karu embobo apuregarase sedo. ");
INSERT INTO nou_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Edo Jerusalem nati da nati demo da awa embo jiwae be ungoda embo karu egeregari de embo nenei asisi bebegae ungoda jo da atima isera awa budo bugujegurisera. Edo budo bugoro ungo mi eoro ewamei edo isera. ");
INSERT INTO nou_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sadducee embobo jiwae be awa priest babojegari de ainda atisera. Edo ungo de priest babojegari de awa tini gambari isera ainda be awa embo jiwae Iesu gebe ari embobo awa ambo ambo edo isera. Awasedo ungo erido ro adera awa kotisera. ");
INSERT INTO nou_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Edo ungo Iesu da binga atopatari embobo awa bundedo embo da gajari oro da ititisera. ");
INSERT INTO nou_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Awarate tumba de Bada da asisi ewamei mi bugudo gajari oro da be awa pirigurisira. ");
INSERT INTO nou_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Pirigedo Iesu da binga atopatari embobo awa budo ponda bugudo ungoda yei sisira, “Mambudo Jew embobo da tumondebain ari oro da derido embo da yei wasiri seka da ge berari awa sewo gore.” ");
INSERT INTO nou_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Edo asisi ewamei awodo setiri Iesu da binga atopatari embobo ro sisira awa isera. Edo ungo sipo tu busedo piri ungo Jew embobo da tumondebain oro da torido atopatadi tuturo isera. Edo priest bajari de embo ainda daedo atisera amimi setero Jew embobo da gitijijigegari torero ungo berari dada isera. Edo ungo dada edo isoro embobo nenei itero gajari oro da Iesu da binga atopapotegari embobo badi mambusera. ");
INSERT INTO nou_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Awarate isoro embobo gajari oro da mambudo ungo Iesu da binga atopatari embobo tambae isera awasedo ungo engenembedo dada ari yei da bugudo gitijijigegari da yei sisera, “Nango gajari yei da mambera edo mangiro awa be batitibedo digari ra edo gajari oro simba ari embobo awa gajari oro awa edo gogo edo simba ititaro jirira. Awarate ungo mangiro be pirigetero nango berari torido edo embo da ave tambae etera.” ");
INSERT INTO nou_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Edo priest babojegari de Jew embobo da tumondebain ari oro simba ari embobo da gitijigari de ge awa ingido ungo Iesu da binga atopatari embobo awa rawodo eteri awa kotedo ungo mana mana isera. ");
INSERT INTO nou_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Edo awodo ero embo da mi torido bugudo ungoda yei sisira, “Ingewa, embo ingo mi gajari oro da itititawa awa ungo Jew embobo da tumondebain ari oro da embo atopapotera.” ");
INSERT INTO nou_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Awasedo Jew embobo da tumondebain ari oro simba ari embobo da gitijigari awa umo simba ari embo de Iesu da binga atopatari embobo awa badi mambusera. Edo ungo mi Iesu da binga atopapotegari embobo budo sekago buguse ungoda yei usibesi nei ro aera ainda be awa ungo kotisera embo mi ungo ganuma wawara edo deorase sedo oju isera. ");
INSERT INTO nou_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Edo ungo mi Iesu da binga atopatari embobo awa budo bugudo setero ungo Jew embobo da gitijijigegari da dombu da dederigurisera. ");
INSERT INTO nou_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Edo Jew embobo da priest gitijigari mi ungoda yei sisira, “Nango ingoda yei sititara ingo embo einda jawo da embo atopatowase sititara awarate giu ro etewa awa. Edo Jerusalem nati embobo berari awa ingoda atopatari awa ingera. Edo ingo mi Iesu da betari awa nango mi ari ge awa atopapotewa.” ");
INSERT INTO nou_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Edo ungo awodo setero Peter de Iesu da binga atopapotegari embobo nei de mi mina sisera, “Nango God kera adera te embo kera adi aera. ");
INSERT INTO nou_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Edo ingo mi Iesu awa benema mi orega da detewo bebetara te ingodenaso nombu mane da God amimi jigiri ererara. ");
INSERT INTO nou_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Edo jigiri eriri edo goroba de gitijigari yei uso ingo be da ititara. Edo God mi etiri umo awa gitijigari nembodiba edo soregari embo iutara. Edo God Israel embobo da wasiri bebegae awa kotembedo doadi sedo wasiri bebegae dodo God da yei wareregorase iji eiawa itutara. ");
INSERT INTO nou_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Edo nango re eiawa atopapotera. Nango de Asisi Kotopu God mi embo ave umo kera edo era ainda yei itido ira ainde daedo eiawa atopapotera.” ");
INSERT INTO nou_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Edo Jew embobo da gitijijigegari ge awa ingido tini gambari nembodiba be isera awasedo ungo kotisera ingode soro Iesu da binga atopatari embobo eiawa doro betadera. ");
INSERT INTO nou_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Awarate embo da ungoda teda Pharisee embo jawo Gamaliel mi ungoda teda eririsira. Edo umo awa agodari da atopatari embo gari jiwae edo embo umo sapo edo gogo edo isera. Edo unemi setiri embo nenei mi Iesu da binga atopatari embobo awa budo ponda mambusera. ");
INSERT INTO nou_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Edo ungo mambero Jew embobo da gitijijigegari ainda yei, sisira, “Ingo embobo einda yei ro adi ewa awa kotedo gogo ewo. ");
INSERT INTO nou_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Edo iji tupo embo da jawo Theudas awa embo da teda tembuse umo embo nembodiba awodo setiri edo embo 400 awodo ungae da dada isera. Awarate embo mi umo detero betetiri uso ambojimbi dada etero edo uso jawo atae isira. ");
INSERT INTO nou_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Edo amboda Rome embobo da gitijigari mi embo roinge ateri awa ajigurise edo rora ungo topo mo ro rori awa gosiri Galilee busu embo jawo Judas eririsira. Edo embo jiwae be umo ambo ambo isera te embo mi umo detero betetiri uso ambojimbi sisigaga isera. ");
INSERT INTO nou_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Awasedo na ingoda yei sena, embomei eiawa dowo edo ungoda yei ro eove ainda be awa ungo ungoda goroba mi embo da buro edo era awa ungoda buro awa atae adira te ungo God da goroba mi God da buro edo era awa ingo mi patari sago aera. Edo ingo patadi adewa awa ingo God ga da embogo adewa.” Edo umo awodo setiri Jew embobo da gitijijigegari Gamaliel ro sisira, awa isera. ");
INSERT INTO nou_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Edo simba ari embobo da setero Iesu da binga atopatari embobo awa budo totorisera. Edo ungo torero Jew embobo da gitijijigegari mi setero ungo vejisera. Edo ungo awodo edo embo da yei Iesu da jawo awa atopatorase sisera edo ungo wujegurisera. ");
INSERT INTO nou_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Edo Iesu da binga atopatari embobo awa Jew embobo da gitijijigegari awa dodo mambuse yaviri mi jo ato ae isira ainda be awa God mi ungo awa Iesu awasedo memesi borase ititisira edo daedo ungo men gae awasedo. ");
INSERT INTO nou_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Edo iji berari ungo Jew embobo da tumondebain ari oro da edo embo da mando da Iesu soregari embo God mi itari bugarase sisira ainda binga ewamei awa atopatido isera. ");
INSERT INTO nou_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Edo iji amboda Iesu ge be ari embobo da ajigari awa nembodiba iri Greek ge sari Jew embobo de edo Jew nati susu Aramaic ge sedo isera ainde mi ge bagisera. Edo Greek ge sari Jew embobo amimi sisera, “Ganu kando osisa ari iji de ungo ingodenaso rorigarori nenei awa ruvegetera.” ");
INSERT INTO nou_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Awasedo Iesu da binga atopatari embobo 12 amimi setero Iesu ge be ari embobo dada isera. Edo ungo dada etero Iesu da binga atopatari embobo mi ungoda yei sisera, “Nango God da ge sari doadera amone biae ra awasedo nanonamendi ingodenaso teda embo 7 Asisi Kotopu de edo jiro gari mi beda ari awa eura ewo. Edo awo ingode ganu kando ari buro awa ungoda yei itoro ore. ");
INSERT INTO nou_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Edo ingodena awa ingodenaso iji awa ingodena God manunugari de embo atopatari buro de awa adera.” ");
INSERT INTO nou_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Edo ungo awodo setero embo berari awa ro Iesu da binga atopatari embobo mi sisera awa dipapa isera. Awasedo embomei amimi Stephen embo jo goroba de edo Asisi Kotopu mi beda ari de Philip de Prochurus de Nicanor de Timon de Parmenas de Nicolaus Jew embo ae embo Antioch nati embo Jew embobo da wasiri ambo ambo edo isira ainde awa ganu boanda ari buro da ititisera. ");
INSERT INTO nou_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Edo setero embobo 7 awa Iesu da binga atopatari embobo da diti da bugero ungo God manunugedo ingo beo da itido buro eiawa orase ititisera. ");
INSERT INTO nou_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Edo God da atopatari awa rawuse atisira. Edo Iesu ge be ari embobo da ajigari awa babojise atisira. Edo Jew embobo da priest jiwae be Iesu ge be ari embobo isera. ");
INSERT INTO nou_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen embo God mi be ewamei edo gogo isira edo goroba mi beda ari umo embo da teda ari wasiri goroba de embo mi matu gae awa edo isira. ");
INSERT INTO nou_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Awarate Jew embobo da dada ari oro da ainda embobo jawo sedo era wujegari embobo amimi Stephen ga ge bagisera. Edo Jew embobo Cyrene nati embobo de Alexandria nati embobo de Cilicia busu embobo de Asia busu embobo de amimi daedo Stephen ga da besora isera. ");
INSERT INTO nou_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Awarate Asisi Kotopu mi Stephen da yei jiro gari nembodiba de ititisira awasedo umo ge sisira awa embobo amimi uso ge mina sari awa inono ae isera. ");
INSERT INTO nou_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Awarate ungo mi embo nenei da yei ganu itido sisera, “Ingo embo emimi Moses de God de da jawo da ge biae be siri ingewa awa sewo.” ");
INSERT INTO nou_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Edo ungo awa setero embobo emimi ge awodo setero embo de Jew embobo da embo nembogamo de agodari da atopapotegari de tini gambari isera. Edo ungo Stephen da yei bugudo sandido Jew embobo da gitijijigegari nembogamo da yei mambusera. ");
INSERT INTO nou_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Edo awodo edo embo nenei mi Jew embobo da gitijijigegari nembogamo da yei Stephen da jawo da ge busorase budo totorisera. Edo embo nenei emimi sisera, “Embo emimi iji berari ingodenaso tumondebain ari oro kotopu de Moses da agodari de da yei ge biae sedo ira. ");
INSERT INTO nou_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Edo nango ingero sisira, Iesu Nazareth nati embo mi Jew embobo da tumondebain ari oro awa arasegedo edo Moses da iji de edo ingodenaso mamo umbogo da iji de edo bugudo boroko einde wasiri ambo ambo ewora awa budo wareregadira awa sevira.” ");
INSERT INTO nou_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Edo ungo awodo setero edo Jew embobo da gitijijigegari Stephen awa dombu da ditini edo uso dombu awa teta asisi ewamei da dombu inge gosisera. ");
INSERT INTO nou_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Priest gitijigari nembodiba mi Stephen nganega isira, “Imo embobo emimi sera awodo iutasi ta?” ");
INSERT INTO nou_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Setiri Stephen mi mina sisira, “Nanononamendi edo mama mane naso ge ingiwo. Matu be matu Abraham umo busu Mesopotamia ainda atisira edo nati Haran ainda mambae atiri God nembodiba be edo usasa de mi uso yei bugusira. ");
INSERT INTO nou_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Edo God umo uso yei bugudo sisira, ‘Iso nati de edo iso orobe de awa dodo busu nanemi ujugadena ainda mambuio.’ ");
INSERT INTO nou_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Edo God awodo uso yei setiri umo busu Chaldea awa dodo mambudo nati Haran ainda atima isira. Edo Abraham da mamo betetiri umo Haran nati awa dodo God mi busu ingode boroko atera einda budo bugusira. ");
INSERT INTO nou_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Edo iji ainde God eiawa busu uso yei itae ra edo busu nei kiambu itae ra awarate God mi uso yei amboda itadi sari sisira. Edo busu berari eiawa umonde uso orobe de da topo adira. Edo God adi sari sisira iji ainde awa Abraham umo kinapeina ae atima isira. ");
INSERT INTO nou_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Edo eiawa God mi Abraham da yei sisira, ‘Iso orobe awa nati nei embobo da busu da atadera. Edo ungo ainda atise nati nei embobo awa gaeko 400 awodo agipo adera awarate ungo mi iso orobe awa simba biae adera. ");
INSERT INTO nou_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Awarate nanemi amenda agipo adera embobo awa kasadena. Edo nanemi kasano edo iso orobe einda bugudo yei einda na tumondebain adera.’ ");
INSERT INTO nou_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Edo God awodo Abraham da yei sedo wasiri tamo kotopu da mendo da pogo diugari awa ititisira uso adi sari da iwata awasedo. Awasedo Abraham uso aro awa Isaac betiri Abraham Isaac da tamo kotopu da pogo mendo awa diugurisira. Amboda Isaac mi uso mei Jacob da tamo kotopu da pogo mendo da awa diugurisira. Edo Jacob uso memei 12 da da awodo isira amimi ingodenaso mamo umbogo isera. ");
INSERT INTO nou_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Edo Jacob da memei, Joseph uso nanonamendi amimi Joseph da atari ewamei awa gido ungo ji sedo gido ungo mi umo Egypt busu embobo da yei agipo arase ori isera. Awarate God daga atima isira. ");
INSERT INTO nou_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Edo Joseph buria bebegae jiwae gosise aturi God umo ewamei edo isira. Edo Pharaoh Egypt embobo da gitijigari nembodiba da diti da awa Joseph awa embo ewamei awodo gido isira edo God mi Joseph da yei jiro gari nembodiba be ititisira awasedo Pharaoh mi Joseph awa uso kondade ari gitijigari awodo ititisira. Edo itiri Joseph Egypt busu embobo de Pharaoh da rora berari de awa simba isira. ");
INSERT INTO nou_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Edo baimana iji bugusira Egypt busu da edo Canaan busu da edo ingodenaso mamo umbogo Canaan busu da atisera awa indari tambari sago ae etiri memesi nembodiba tambusera. ");
INSERT INTO nou_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Awasedo Jacob Egypt busu da indari atira awa binga ingido uso memei itiri mambusera ingodenaso mamo umbogo awa indari ori orase awarate ungo Joseph gadi jarisera. ");
INSERT INTO nou_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Edo iji etoto ungo Egypt busu da mambusera. Edo ungo iji sangove da esega isera ainde Joseph umo embo averi awa ungoda yei isaga isira. ");
INSERT INTO nou_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Awasedo Joseph binga itiri uso mamo Jacob da yei mambusira edo uso orobe ainda ajigari 75 awa budo Egypt busu da bugarase. ");
INSERT INTO nou_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Edo Jacob binga awa ingido umo Egypt wowosisira edo ainda umo de uso memei de bebetisera. ");
INSERT INTO nou_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Edo ungo bebetero ungo mi ungoda tamo awa budo Shechem nati da mambudo gousera. Edo Abraham mi Hamor da orobe da yei ganu itido embo gowari yei meko to awa matu burisira ainda gousera. ");
INSERT INTO nou_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Edo God Abraham da yei adi sari sisira iji awa aikambu isira edo ingodenaso mamo umbogo da ajigari awa jiwae be isira. ");
INSERT INTO nou_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Edo gitijigari nembodiba nei Joseph matu atima isira awa gae amimi Egypt embobo awa gitijigadi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Edo gitijigari amimi ingodenaso mamo umbogo gandubedo ari bebegae ungoda yei edo isira. Edo unemi setiri ingodenaso mamo umbogo mi ungoda kinapeina memeia awa doro betedo isera. ");
INSERT INTO nou_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Edo iji ainde mei ewamei be Moses awa uso ai da tini da wowosisira. ");
INSERT INTO nou_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Edo uso ai mi umo simba isira te umo uso bajari iji awa kariga tamonde etiri uso ai mi ponda itido betarase doturisira. Edo ainda dotiri Pharaoh da gagara mi kumbudo raro isira edo simba isira teta uso mei topo awodo. ");
INSERT INTO nou_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Edo umo Egypt embobo da giruma da mambudo Egypt embobo da jiro gari awa burisira. Edo umo bajido jiro gari nembodiba be de edo ari ewagaewa ise edo ge ewamei sise amimi umo embo nembodiba isira. ");
INSERT INTO nou_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Edo Moses uso gaeko 40 etiri iji ainde kotisira na naso nanonamendi Israel embobo awa esega adena. ");
INSERT INTO nou_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Edo umo ungo esega ise Egypt embo da mi Israel embo da awa usibesi iri gosisira awasedo umo mambudo umo kondade edo mina Egypt embo awa detiri bebetisira. ");
INSERT INTO nou_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Edo Moses kotisira Israel embobo mi God mi umo kondade ari unemi ungo wujegadira awa gorase kotisira te ungo gae isera. ");
INSERT INTO nou_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Edo iji nei Moses Israel embobo etoto awa embogo ero gido umo ungo ari dubo ewamei be orase isira. Edo ungoda yei sisira, ‘Embomei naso ge ingiu, ingo namendi ga ra ro edo mina dara evi?’ ");
INSERT INTO nou_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Setiri embo wasiri biae isira embo nei da amimi Moses awa miminegetiri demo da yiri uso yei sisira, ‘Embo amemi iso yei nango gitijijigurise edo kasasase goroba ari itero esi? ");
INSERT INTO nou_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Edo imo sipe Egypt embo deteso bebetara da awodo na daso betanase esi ta?’ ");
INSERT INTO nou_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Setiri gido Moses Egypt busu awa dodo sumbudo Midian busu da mambusira. Edo umo ainda atise aro jimbudo memei etoto da mamo isira. ");
INSERT INTO nou_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Edo gaeko 40 atae etiri Moses yei embo atae da doriri Sinai demo da buro iri asisi ewamei mi riawo ewarago ise uso yei isaga isira. ");
INSERT INTO nou_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Edo Moses awa gido kove edo ri aikambu ujugedo gadi mambusira. ");
INSERT INTO nou_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Edo Moses aikambu mambiri Bada God da ge javi mi uso yei sisira, ‘Na awa iso mamo umbogo da God ra Abraham de Isaac de Jacob de da God ra. Edo Moses God da ge javi ingido oju mi tei ingo dadara isira edo Moses ri awa gari ujo ae isira. ");
INSERT INTO nou_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Edo Bada God mi uso yei sisira, ‘Iso tei goru awa kougeio ainda be awa yei imo derido atesa awa busu kotopu awasedo. ");
INSERT INTO nou_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Edo na naso embomei Egypt busu da atera ainda memesi nembodiba awa gosena. Edo ungoda mendo javi awa ingido na ungo soregadi wosetena. Edo puio nanemi imo itano Egypt busu da mambase.’ ");
INSERT INTO nou_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Edo Moses re Israel embo mi ujo ae isera. Edo ungo mi Moses da yei sisera imo amemi nango gitijijigurise edo nango kasase ititisiri sisera. Edo Moses re God mi Israel embobo gitijigido soregarase itiri bugusira embo awa ra. Edo asisi ewamei ri eusira ainda Moses mi gosisira amimi umo kondade isira. ");
INSERT INTO nou_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Edo Moses re Egypt busu da edo Ewa Kokoi da ainda ari wasiri goroba de ungo mi matu gae awa isira edo unemi embomei gitijigiri Egypt busu dodo mambusera awara. Edo gaeko 40 ungo erigi erigi ise yei embo atae da tembusera awara edo Moses re ari wasiri goroba de ungo matu gae awa edo isira awara. ");
INSERT INTO nou_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Edo Moses re Israel embobo da yei sisira God mi binga sari embo na itiri bugusena awodo itari bugadira edo embo amone ingoda embo nei na sisira embo awara. ");
INSERT INTO nou_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Edo Israel embobo yei embo atae da dada etero edo Moses de daedo ainda ungode atisira embo awa ra. Edo umone ingodenaso mamoumbogo de daedo yei embo atae da atisira awara. Edo iji ainde God mi binga matawa atari Moses da yei ititisira awawa ingode namonde ingodenaso mamoumbogo de ingorase. Edo umone doriri Sinai ainda asisi ewamei uso yei ge sisira ainga atisira awara. ");
INSERT INTO nou_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Awarate ingodenaso mamoumbogo Moses kera ari dipapa ae isera edo umo ujo ae edo Egypt busu da engenembadi dipapa isera. ");
INSERT INTO nou_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Awasedo Aaron da yei sisera, ‘ingodenaso ove kevegae tumondebain ore. Edo dogae ungo mi ingode gitijigore. Edo embo Moses ingodena gitijigido Egypt busu dodo budo bugusira awa ingode umo ro etiri awa ingode gae ra.’ ");
INSERT INTO nou_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Edo ungo awodo sedo ove teta wo cow da mei inge awa kewusera. Edo awa edo ove kewari da rorou ititisera edo ungo ungosuka ro isera awasedo bondo isera. ");
INSERT INTO nou_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Awarate God wareregedo ungo dotiri ungo utu da damana tumondebain isera. Edo binga sari embo mi gaisera, ‘Israel embobo ingo gaeko 40 yei embo atae da atise wo dedo rorou edo isewa te ingo naso yei rorou itae ra. ");
INSERT INTO nou_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Edo ingo god Moloch da tumondebain ari mando bo mi ari edo ingoda god Rephan da damana ove kewari de da awa ango edo tembuma edo isewa. Edo ingo ove eiawa tumondebain adi keusewa awasedo nanemi ingo riroga bawase itano Babylon edo busu nenei besaun ainda mambadewa.’ ");
INSERT INTO nou_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Edo ingodenaso mamoumbogo yei embo atae da atise ungo God da tumondebain ari oro bo mi ari awa ango edo temuma isera. Edo mando einda torido God tambudo isera. Edo ungo mando eiawa God mi Moses da yei rawodo orase sisira awodo isera. ");
INSERT INTO nou_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Amboda ungoda mamono betetero ingodenaso mamo umbogo mi tumondebain ari oro bo mi ari awa burisera. Edo ungo Joshua ga da mambusera edo God mi embo ungoda giti da awa onduri mambusera ainda busu budo isera iji ainde ungo tumondebain ari oro bo mi ari awa ango edo tembuse edo isera. Edo Joshua da iji de tuturo edo mambudo David da iji de awa tumondebain ari oro bo mi ari awa ungode daedo atima isira. ");
INSERT INTO nou_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","47","Edo David mi God da yei awa adi God da jo budo David mi God da yei sedo gosisira umo awara sari uso tumondebain ari oro itadi sisira te David da mei Solomon mi God da tumondebain ari oro awa isira. ");
INSERT INTO nou_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Awarate God embo nenei derigedo atima ira awa mando embo da ingo mi edo era ainda atae edo ira. Edo God da binga sari embo mi sisira, ");
INSERT INTO nou_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Bada God mi sira utu awa naso gitijigari da anumba ra edo busu awa naso tei itari yei ra. Edo mando mo rawodo awa naso esi? Edo na atadena mo inono ta? Edo na nasuka utu de busu de awa isena awa ge be ta mo ko?’ ");
INSERT INTO nou_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ingo Israel jariga embobo ingo God da ge moka be awa ingae edo ewa. Edo ingo awa teta embo God gae edo era da awodo ra. Edo God da binga ingoda yei buguteuri awa ingo awa teta dengoro ambubu da awodo edo ewa. Edo ingo Asisi Kotopu beitigurewa teta ingoda mamo umbogo mi matu isera da awodo. ");
INSERT INTO nou_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Edo ingoda mamo umbogo mi God da binga sari embobo berari awa degisera. Edo God da binga sari embobo matu be matu uso agipo embo dagari ae da bugari awa minonu sedo isera awa ungo mi detero bebetegurisera. Edo boroko ingo mi God mi soregari embo itari bugarase sisira embo awa indiga edo detewo betetira. ");
INSERT INTO nou_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Edo ingo mi agodari asisi ewagaewa mi edo gogo edo ingoda yei itero bugusira awawa kumbusewa te ingo awa kera ae etewa.” ");
INSERT INTO nou_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Edo Jew embobo de gitijijigegari Stephen da ge ingise ungo tini gambari mi di vegise tini gambari be isera. ");
INSERT INTO nou_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Awarate Stephen Asisi Kotopu mi beda ari mi diti utu da edo God da usasa janiburiri gosisira. Edo Iesu God da ingo be kena derido atiri gosisira. ");
INSERT INTO nou_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Edo Stephen mi sisira, “Giwo utu pirigetiri Iesu God da ingo be da derido atiri gosena.” ");
INSERT INTO nou_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Edo awodo setiri embo berari gogo nembodiba be tini gambari de dimbudo ingo mi ungoda dengoro awa gagajegurisera. ");
INSERT INTO nou_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Edo ungo berari uso yei sumbudo umo budo nati ponda warawara isera. Edo umo ponda warawara edo umo ganuma mi dadi tuturo isera. Edo Jew embobo da wasiri awodo ra embo amemi embo bekuba adira amimi ganuma giti awa pigadira awasedo ungo ungoda ombari tamo da riribori awa totedo mei singa Saul mi simba arase ititisera. ");
INSERT INTO nou_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Edo ungo ganuma wawara ise atero Stephen mi Iesu da yei sisira, “Bada Iesu naso asisi kumbu.” ");
INSERT INTO nou_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Edo Stephen awodo sedo baingo dederi edo gogo dimbudo sisira, “Badaembomei eiawa wasiri biae eiawa era te ungoda gagi mina itose ta naso yei ro era awa kotembedo doio.” Edo umo awodo sise bebetisira. ");
INSERT INTO nou_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Edo Saul embo mi Stephen detero gido sisira ungo etera awa awara sisira. Edo iji ainde embo mi Iesu gebe ari embobo Jerusalem nati da awa be biae be dedo gaedo isera. Edo Iesu ge be ari embobo berari awa Judea busu da Samaria busu da sisigaga isera te Iesu da binga atopatari embobo awa Jerusalem nati da atisera. ");
INSERT INTO nou_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Edo embo ewagaewa nenei mi Stephen govedo umo embo ji nembodiba sisera. ");
INSERT INTO nou_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Awarate Saul umo Iesu ge be ari embobo da tumonda ari awa ari atae arase jarise ungoda yei bebegae edo isira. Edo Saul mi ungoda mando da torido dada jumburi bugoro Iesu ge be ari embo de evetu de awa gajari oro da ituri torido isera. ");
INSERT INTO nou_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iesu ge be ari embobo sisigaga isera amimi yei berari da mambudo binga ewamei awa atopapotisera. ");
INSERT INTO nou_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Edo Philip Stephen da otao, awa Samaria nati nembodiba da mambudo embo ainda atima isera ainda yei soregari embo God mi itari bugarase sisira awa atopapotisira. ");
INSERT INTO nou_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Edo embo jiwae be umo ro atopapotira awa be ingido gogo isera. Edo ungo uso ari wasiri goroba de gido uso ge awa ingido isera. ");
INSERT INTO nou_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Edo Philip mi seuri asisi bebegae embo jiwae da jo da atima isera awa gogo de ungo dodo ponda bugudo isera. Edo embo tei ingo ambujegari embobo jiwae de gainti jupiti ari embobo de awa ewagaewa edo pepeta edo isera. ");
INSERT INTO nou_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Awasedo Samaria nati nembodiba da embobo awa yaviri nembodiba isera. ");
INSERT INTO nou_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Edo jone sapuri embo da jawo Simon awa nati ainda atima isira edo iji berari umo jone neinde kainde awa euri embo kove be edo isera. Edo umo iji berari umo umosuka awa embo nembodiba awodo sedo isira. ");
INSERT INTO nou_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Edo Samaria nati embobo embo nembogamo edo embo tepo awa uso ge awa dengoro edo isera. Edo ungo mi sisera, “Embo emone ge be embo nembodiba ra God da embo goroba de ra.” ");
INSERT INTO nou_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Edo iji tupo atae be uso jone sapuri mi euri embo kove be edo isera awasedo ungo uso ge awa be ingido gogo edo isera. ");
INSERT INTO nou_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Awarate boroko Philip mi Iesu Keriso da binga ewamei de God mi gitijigadira iji de ainda binga awa setiri gido ungo ge be isera. Ge be edo embo de evetu de umo mi ewamei ari wasiri awa isera. ");
INSERT INTO nou_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Edo Simon umo daedo ge be awodo kotedo umo mi ewamei ari wasiri awa isira. Edo umo Philip ga daedo asusu bedo atise Philip mi ari wasiri goroba de edo isira edo wasiri embo mi matu gae awa edo isira awa gido umo kove be isira. ");
INSERT INTO nou_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Edo Iesu da binga atopapotegari embobo Jerusalem nati da atima isera awa Samaria nati embobo God da ge awa bari binga ingido gido Peter de John de awa itero mambusera. ");
INSERT INTO nou_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Edo ungo bugudo Iesu ge be ari embobo awa Asisi Kotopu borase sedo ungoda jawo da God manunugurisera. ");
INSERT INTO nou_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Edo ungo awa umo mi ewamei ari wasiri awawa Iesu da jawo da kumbusera te da rawainda Asisi Kotopu awa wosae be ra. ");
INSERT INTO nou_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Edo Peter de John de ungoda ingo ungoda kopiri da itero ungo Asisi Kotopu burisera. ");
INSERT INTO nou_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Edo Simon Iesu da binga atopapotegari embobo mi ungoda ingo ungoda kopiri da itero Asisi Kotopu burisera awa gido edo ganu Peter de John de da dombu da itido ungoda yei sisira, “Embo ave naso ingo uso kopiri da itano edo Asisi Kotopu borase sedo goroba eiawa naso yei itigave.” ");
INSERT INTO nou_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Setiri Peter mi uso ge mina sisira, “Imo kotesa imo ganu mi God da kando eiawa ori adesa. Edo imo awodo adesa awa imo de iso ganu de awa riawo euse matawa atari yei ainda mambadesa. ");
INSERT INTO nou_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Edo iso jo awa God da diti da awa awara ae ira awasedo imo awa buro einda kondade ari sago ae ira. ");
INSERT INTO nou_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Edo iso kotari biae eiawa dodo Bada God da yei wareregedo edo iso kotari biae eiawa kotembedo doarase sedo gio. ");
INSERT INTO nou_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Edo na gosena iso jo awa dipapa nembogamo bebegae mi beda ari ra. Edo iso wasiri bebegae mi imo awa digido gogo arira.” ");
INSERT INTO nou_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Edo Peter awodo setiri Simon mi Peter de John de da yei sisira, “Doawo ari bebegae inemi setesa awa naso yei eure ta sedo gosena naso jawo da God manunugegave.” ");
INSERT INTO nou_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Edo ungo Jerusalem nati da mambuse God da binga ewamei awa Samaria busu da nati berari da atopapotisera. ");
INSERT INTO nou_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bada God da asisi ewamei mi Philip da yei sisira, “Iso rora sia edo ijari kena awodo wosedo yeio emboro Jerusalem nati da edo Gaza nati da mambari edo emboro yei embo atae da jo da awodo mambari ainda mambuio.” ");
INSERT INTO nou_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Edo asisi ewamei awodo Philip da yei setiri, Philip sia edo mambusira. Edo iji ainde Ethiopia busu da evetu gitijigari da gayapa simba ari embo awa uso busu topo da sekago engenembedo mambusira. Umo Jerusalem nati da tumondebain adi mambudo edo umo uso nga wo mi jumbudo ira ainde da engenemburira. Edoumo mambuse God da binga sari embo Isaiah mi jiwari jiusira awa ajigurisira. ");
INSERT INTO nou_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Edo umo awa ajiguriri Asisi Kotopu mi Philip da yei sisira, “Mambudo nga wo mi jumbutira ainda demonda atio.” ");
INSERT INTO nou_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Setiri Philip nga ainda sumbudo mambusira edo Ethiopia busu embo awa God da binga sari embo Isaiah da jiwari awa ajiguriri ingisira awasedo Philip mi uso yei sisira, “Imo ro ajiguresa ainda be mo gosesi ta?” ");
INSERT INTO nou_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Setiri Ethiopia busu embo amimi mina sisira, “Embo da amemi jiwari eiawa naso yei ujugae ari mo na rawodo edo geni?” Edo umo awodo sedo Philip da yei sisira, “Imo einda viti nangae anumbase.” ");
INSERT INTO nou_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Edo jiwari da tano umo ajigurisira amimi sisira, “Ungo mi umo budo yisera awa teta ungo mi wo sheep awa dari yei da budo mambarago isera. Edo embo mi wo sheep da mei da tamo tu botu awa diugeoro egoro sae atima era da awodo embo emimi javi da ro ae isira. ");
INSERT INTO nou_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ungo mi umo usibesi isera edo kasari da edo gogo edo itae isera. Edo embo amemi embo umo atima isira iji ainde atima isera ainda wasiri bebegae awa ujugeri? Edo wasiri bebegae amimi etiri umo bebetisira.” ");
INSERT INTO nou_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Edo Ethiopia busu embo nembodiba emimi Philip da yei sisira, “Se gane binga sari embo mo embo mo amende siri? Umo umosuka awa sita ko embo nei awa siri?” ");
INSERT INTO nou_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Setiri Philip mina jiwari tano einda tuturo edo Iesu da binga ewamei awa ujugurisira. ");
INSERT INTO nou_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Edo ungo emboro da wosedo periko umo atisira yei ainda bugusera. Edo ungo ainda bugero Ethiopia busu embo amimi sisira, “Umo eire edo rora ro mi inemi na einda umo mi ewamei adesa awa gajita?” ");
INSERT INTO nou_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Setiri Philip mi mina sisira, “Imo jo iso berari mi ge be adesa awa umo mi ewamei ari wasiri awa badesa.” Setiri Ethiopia busu embo amimi mina sisira, “Na Iesu Keriso awa God da mei awa ge be ena.” ");
INSERT INTO nou_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Edo awodo sedo setiri nga jigari embo awa nga etiri petetiri Ethiopia busu embo de Philip de ungo etoto umo da wowosisera. Edo ungo wosedo Philip umo mi umo ewamei isira. ");
INSERT INTO nou_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Edo ungo umo dodo vitero Bada God da Asisi mi Philip budo mambusira. Edo Ethiopia busu da evetu gitijigari da gayapa simba ari embo Philip sekago gae rate umo uso busu da engenembedo jo yaviri mi uso jo beda edo atiri mambusira. ");
INSERT INTO nou_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Edo Philip awa Ashdod nati da bugusira. Edo dodo umo mambuse nati berari da binga ewamei awa minonu sise mambudo edo Caesarea nati da mambusira. ");
INSERT INTO nou_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Edo eiawa berari iri Saul uso goroba berari budo dada edo Bada da ambojimbi usibesi ise sedo isira unemi ungo berari awa dari betorase. ");
INSERT INTO nou_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Awasedo umo priest babojegari da yei mambudo Jew embobo da dada ari oro Damascus nati da ainda gitijijigegari mi umo sia orase uso yei umo averi awa ove edo itarase sedo gosisira. ");
INSERT INTO nou_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Edo Saul Damascus nati da mambutiko nati aikambu bugiri utu da usasa parara de mi umo jiroroka edo janiburisira. ");
INSERT INTO nou_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Etiri edo Saul busu da durido wosetiri ge javi Saul mi ingisira amimi uso yei sisira, “Saul Saul imo roedo na dedo gaedo esi?” ");
INSERT INTO nou_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Edo ge awodo setiri Saul mi nganega isira, “Bada, imo averi?” Setiri ge javi mi sisira, “Namone Iesu inemi dedo gaedo esa embo awa ra. ");
INSERT INTO nou_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Erido nati da torio edo ainda embo da amimi ro esi awa sari gase.” ");
INSERT INTO nou_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Edo embo nenei Saul ga da mambusera awa petedo kove be edo ge nei da ro sae isera. Edo ungo ge javi ingisera te embo da ave gae isera. ");
INSERT INTO nou_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Edo Saul erido diti pirigurisira te umo diti guba isira awasedo ungo mi umo ingo da jigido budo Damascus nati da totorisera. ");
INSERT INTO nou_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Edo iji tamonde umo yei gae edo nei ro indae atisira. ");
INSERT INTO nou_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iesu ge be ari embo da jawo Ananias awa Damascus nati da atima isira. Edo Ananias eturo iri ainda Bada mi uso yei sisira, “Ananias.” Setiri Ananias mi mina sisira, “Bada na eire.” ");
INSERT INTO nou_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Setiri Bada mi uso yei sisira, “Sia edo emboro jawo Dambu Derari da mambudo edo Judas da mando da Tarsus nati embo jawo Saul awa jawo seio. Edo umone God manunugurise atirari gido imo kove adesa. ");
INSERT INTO nou_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Edo eturo da umo garago isira embo jawo Ananias amimi bugudo Saul yei sekago garase ingo uso kopiri da itira.” ");
INSERT INTO nou_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Edo Bada awodo setiri Ananias mi mina sisira, “Bada embo jiwae mi embo emimi ari wasiri bebegae iso gebe ari embo Jerusalem atera ainda ira awa setero gosana. ");
INSERT INTO nou_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Edo priest babojegari mi umo goroba ari itido itero embo iso jawo sera awa bundadi sedo edo Damascus nati da bugira.” ");
INSERT INTO nou_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Edo Ananias awodo setiri Bada mi uso yei sisira, “Nanemi Paul na kera arase katabetena. Edo unemi naso jawo awa Jew embobo ae de ungoda gitijijigegari nembogamo de edo Jew embobo ungoda jawo nei Israel embobo Israel embobo da yei isaga arase budo demo da itena awasedo uso yei mambuio. ");
INSERT INTO nou_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Edo na nasuka uso yei rora berari naso jawo da awa sedo memesi tambadira awa uso yei ujiji ano gadira awasedo uso yei da mambuio.” ");
INSERT INTO nou_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Edo umo awodo setiri Ananias mambudo mando da torido uso ingo Saul da kopiri da ititisira. Edo ingo ititise uso yei sisira, “Namendi Saul Bada mi na iso yei itiri bugena. Edo Iesu umo umosuka imo Damascus nati da bugadi sedo buguteso iso yei bugutara embo amimi na iso yei itiri bugena. Edo imo yei sekago gasase edo imo Asisi Kotopu mi beda arase itiri na iso yei bugena.” ");
INSERT INTO nou_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Edo Ananias awodo setiri rora wo kauka inge amimi Saul da diti da edo wosetiri umo yei sekago gosisira. Edo Saul umo erido umo mi ewamei ari wasiri awa burisira. ");
INSERT INTO nou_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Edo umo awa budo indari indiri uso goroba sekago bugusira. ");
INSERT INTO nou_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Edo Saul iji tupo ambojimbi Damascus nati da atima isira ainde atisira. Edo simba ae umo Jew embobo da dada ari oro da mambudo Iesu da jawo da atopatadi tuturo isira. Edo umo Iesu awa God da mei awa atopapotisira. ");
INSERT INTO nou_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Edo embo berari uso atopatari ingisera awa be kove be edo sisera, “Embo re emimi Jerusalem nati da embo ave Iesu da jawo sedo era awa deuri betedo era. Edo Iesu ge be ari embobo awa bundedo baredo priest babojegari da yei mambadi sedo einda bugira.” ");
INSERT INTO nou_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Awarate Saul jamo jamo ae mata atopapotise goroba isira. Edo umo Iesu awa soregari embo God mi itari bugarase sisira awa isaga be atopapotisira awasedo Jew embobo Damascus nati da atima isera awa uso ge mina sari sago ae isera. ");
INSERT INTO nou_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Edo iji jiwae atae etiri Jew embobo dada edo Saul doro betarase kiki dirisera awarate Saul ungo ro adi kiki direra awa ingisira. Edo iji de tumba de Saul da gitopo embobo awa nati da puga jiroroka ari da mangiro be awa diti jimba edo isera umo doro betarase simba ise. ");
INSERT INTO nou_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Awarate tumba de Saul da ambojimbi mi kokora kandiga da umo awawa jurugedo nati puga ganuma mi digido jiroroka ari mando inda ainda diumba da awodo itero wowosisira. ");
INSERT INTO nou_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul Jerusalem nati da mambudo ambojimbi de dada adi sedo dipapa isira te ungo umo ambojimbi awa ge be ae isera. Edo ungo berari umo oju isera. ");
INSERT INTO nou_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Awarate Barnabas mi umo kondade edo umo budo Iesu da binga atopatari embobo da yei mambusira. Edo budo mambudo Saul umo emboro da pepeta ise Bada gosisira edo Bada uso yei ge sisira awa ungoda yei ujugurisira. Edo ungoda yei daedo sisira Saul Damascus ainda Bada da jawo da oju ae atopapotisira awa sisira. ");
INSERT INTO nou_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Edo umo awodo setiri Saul daedo atisira. Edo umo ungode daedo atise Jerusalem nati da jiroro ise oju ae Iesu da jawo da atopatido isira. ");
INSERT INTO nou_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Edo umo daedo Greek ge sari Jew embobo de Iesu da jawo da ge sise edo ge kasedo isira te ungo iji budo umo doro betarase awa eura ise atima isera. ");
INSERT INTO nou_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Edo nanonamendi ge eiawa ingido Saul budo Caesarea nati da wosedo Tarsus nati da itero mambusira. ");
INSERT INTO nou_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Edo Iesu ge be ari embobo Judea busu da edo Galilee busu da edo Samaria busu da awa dubo jamo jamo de atisera. Edo Asisi Kotopu mi kondade edo isira edo Iesu ge be ari embobo awa Bada sapo isera awasedo Iesu gebe ari embobo ungoda tumonda ari de ungoda ajigari de awa nembodiba isira. ");
INSERT INTO nou_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter yei berari da teuma isira. Edo iji da umo Iesu gebe ari embo nati Lydda da atima isera awa esega isira. ");
INSERT INTO nou_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Edo Peter ainda mambudo embo jawo Aeneas awa tambusira. Edo Aeneas awa tamo uso berari awa ambari awasedo umo erae be gaeko 8 awodo uso besi da pasido atima isira. ");
INSERT INTO nou_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Edo Peter umo tambudo uso yei sisira, “Aeneas Iesu Keriso mi iri iso tamo awa sekago ewamei ira awasedo erido iso opi bojeio.” Setiri Aeneas iji da amimi eririsira. ");
INSERT INTO nou_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Edo embo berari Joppa nati da edo busu gewoto da ewa be aikambu atima isera awa embo awa gido ungoda jo Bada da yei wareregurisera. ");
INSERT INTO nou_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Edo Joppa nati ainda Iesu ge be ari evetu jawo Tabitha atima isira. Uso jawo Greek ge mi jivedo era awa Dorcas. Edo iji berari umo embo da yei ewamei edo isira edo embo rora ae embobo awa kondade edo isira. ");
INSERT INTO nou_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Awarate iji ainde umo karu edo bebetisira. Edo ungo mi uso tamo awa segedo diumba inda ainda ititisera. ");
INSERT INTO nou_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Edo Joppa nati awa Lydda nati aikambu awasedo ambojimbi Joppa nati da atima isera amimi Peter Lydda nati esega ira awa binga ingido binga embo etoto da yei uso sorase sisera. Edo binga sisera sedo gosera, “Nangoda yei burigi be buguio.” ");
INSERT INTO nou_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Edo Peter binga awa budo sia edo binga budo bugusera embobo etoto ainde da mambusira. Edo umo mando ainda bugiri budo diumba inda ainda budo vivitisera. Edo rori garori berari awa Peter joda itido ji sise Dorcas umo wasiri de atise ombari digari edo isira awa uso yei ujiji edo isera. ");
INSERT INTO nou_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Edo Peter mi setiri ungo yei awa dodo ponda mambusera. Edo ungo mambero Peter baingo dederi edo God manunugurisira. Edo evetu betari da yei wareregedo sisira, “Tabitha eri.” Setiri umo uso diti pirigedo Peter gido erido anumburisira. ");
INSERT INTO nou_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Edo Peter uso ingo da budo kondade etiri eririsira. Edo umo eriri Peter Iesu ge be ari embobo de rori garori de jawo setiri bugero umo wasiri de ungoda yei ititisira. ");
INSERT INTO nou_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Edo binga ari wasiri goroba einda awa Joppa nati embobo berari da ravetiri embo jiwae be Bada ge be isera. ");
INSERT INTO nou_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Edo Peter Joppa nati da iji ribori be wo andiso segari embo da jawo Simon ainda mando ainda atima isira. ");
INSERT INTO nou_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Embo Jew ae uso jawo Cornelius awa Caesarea nati da atima isira. Edo umo awa isoro embobo 100 ainda gitijigari. Edo isoro ari embobo eiawa Italy busu da embogo ari embobo sedo era. ");
INSERT INTO nou_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Edo Cornelius awa umo God sapo edo isira. Umo de uso orobe de God tumondebain edo isera. Edo umo Jew embobo rora egeregae awa kondade nembo be edo isira edo iji berari God manunugedo isira. ");
INSERT INTO nou_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Iji da ongobo soropu da digagara ise God da asisi ewamei totoriri gosisira. Edo torido uso yei sisira, “Cornelius.” ");
INSERT INTO nou_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Setiri Cornelius oju edo asisi ewamei ditini ise sisira, “Embo nembodiba imo ro dipapa esi?” Edo umo awodo setiri asisi ewamei mi mina sisira, “God uso yei ge seso ingira edo rora egeregae embobo da yei ro esa awa gosira edo umo imo ruvegae ra. ");
INSERT INTO nou_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Edo boroko embobo itio Joppa nati da mambudo embo jawo sedo era Simon Peter awa bore. ");
INSERT INTO nou_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wo andiso segari embo jawo Simon ainda mando ewa bengi da ainda atima ira edo uso mando da Peter awa tambadesa.” ");
INSERT INTO nou_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Edo asisi ewamei Cornelius da ge awa sedo mambutiri Cornelius setiri uso agipo embobo etoto de isoro embo da de totorisera. Edo isoro embo eiawa God sapo edo isira edo iji berari Cornelius da dipapa awa simba edo isira. ");
INSERT INTO nou_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Edo Cornelius Anela ro sisira awa ungoda yei setiri getero ungo itiri Joppa nati da mambusera. ");
INSERT INTO nou_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Edo iji nei ungo mambudo Joppa nati aikambu ero iji beo da Peter God manunugadi sedo mando sa da gaga da vivitisira. ");
INSERT INTO nou_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Edo umo beji etiri indari indae etira awa dipapa isira. Edo ungo indari sia ero Peter eturo da garago isira. ");
INSERT INTO nou_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Umo utu pirigetiri gosisira. Edo utu pirigetiri umo rora bo nembodiba awa uso begiti 4 ainda jigari busu da wosarago iri gosisira. ");
INSERT INTO nou_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Edo bo nembodiba ainda jo da awa wo mane pepeta edo isera edo wo akogedo isera edo ri memei ainda atisera. ");
INSERT INTO nou_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Edo Peter awa gosiri ge javi mi uso yei sisira, “Peter erido wo da dedo indio. ");
INSERT INTO nou_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Awarate Peter mi sisira, “Bada, awodo aera. Na mana wo da eiawa indadena. Edo awa naso aera edo wo mane eiawa Jew embobo da agodari mi sira awa bebegae ra. Edo wo mane eiawa bebegae edo dongono de ra.” ");
INSERT INTO nou_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Edo Peter awodo setiri ge javi mi sekago uso yei sisira, “Ro God mi indorase awara sira awa indari bebegae awodo seose.” ");
INSERT INTO nou_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Edo Peter wasiri eiawa iji tamonde gosisira. Edo bo nembodiba awa sekago utu da vivitisira. ");
INSERT INTO nou_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Edo Peter mana mana edo rora gosisira ainda be mo rori awa kotise atisira. Edo rora eiawa berari iri embo Cornelius mi itiri bugusera awa Simon da mando awa tambudo uso mando be da derido atisera. ");
INSERT INTO nou_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Edo ungo derido atise gogo dimbudo sisera, “Esega embo da jawo Simon Peter einda joda atita?” ");
INSERT INTO nou_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Edo Peter rora gosisira ainda be awa gadi jarise atiri Asisi Kotopu mi uso yei sisira, “Gi embo tamonde awa imo embo bugera. ");
INSERT INTO nou_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sia edo ungoda yei woseio. Edo nanemi ungo iteno bugera awasedo jegigi eose ta ungode daedo mambuio.” ");
INSERT INTO nou_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Edo umo awodo setiri Peter wosedo embobo ainda yei sisira, “Namone ingo eura ewa embo awa ra. Edo ingo roedo bugevi?” ");
INSERT INTO nou_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Setiri ge mina sisera, “Isoro embobo da gitijigari Cornelius mi itiri bugera. Edo umo awa embo ewamei edo God tumondebain edo ira edo Jew embobo berari umo sapo nembodiba be edo era. Edo God da asisi ewamei mi uso yei siutara iso ge ingarase edo imo oru ari uso mando esega asase.” ");
INSERT INTO nou_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Edo ungo awa setero Peter mi ungoda yei sisira, “Toriwo edo tumba awasedo einda atave.” Edo sipo nei Peter sia edo embomei ainde mambusira. Edo nanonamendi nenei Joppa nati da atima isera awa daedo mambusera. ");
INSERT INTO nou_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Edo sipo nei ungo Caesarea nati da bugusera ainda Cornelius de uso orobe de otatao de bugorase sisira awa Peter simba ise ainda atisera. ");
INSERT INTO nou_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Edo Peter toradi iri Cornelius umo tambudo uso jo da baingo dederi edo umo tumondebain isira. ");
INSERT INTO nou_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Awarate Peter mi umo kondade etiri eriri uso yei sisira, “Erio ko na awa embo teta imo inge ra.” ");
INSERT INTO nou_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Edo ungo mando da totorise Peter Cornelius da yei ge sise totorisira. ");
INSERT INTO nou_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Edo torido embo jiwae be dada edo atero gido Peter ungoda yei sisira, “Ingo ingosuka gosewa nangoda agodari mi sira Jew embobo awa mana Jew embobo ae awa esega adera edo otao mana adera. Awarate God mi naso yei isaga etira awa na wasiri eiawa ambo ambo ari awa doadena. ");
INSERT INTO nou_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Edo imo na buganase binga iteso mambutara awa na ujo ae aerate bugena. Edo boroko na iso yei sedo gosena imo ro edo na buganase binga itesi?” ");
INSERT INTO nou_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Setiri Cornelius mi mina sisira, “Iji tamonde atae iutara ainde ongobo de na naso mando da atise God manunugurana. ");
INSERT INTO nou_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Edo iji ainde embo da bo parara biribiri ari awa ombudo naso jo da derido siutara, ‘Cornelius God mi iso ge awa ingido edo iso buro ewagaewa awa kotemburara. ");
INSERT INTO nou_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Edo embo da itio Joppa nati da embo jawo Simon Peter awa mambudo soro bugare. Edo umo awa esega embo, wo andiso segari embo da jawo Simon ainda mando ise ewa be da atima ira embo ainda mando da atira.’ ");
INSERT INTO nou_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Awasedo burigi be na imo bugasase embo iteno mambutitara. Edo imo bugeso na iaviri ena. Edo nango berari einda dada edo Bada mi nangoda yei ge ro berari sasase siutara awa saso gadi simba era.” ");
INSERT INTO nou_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Setiri Peter ungoda yei ge sadi tuturo isira, “Na boroko gosena God embo berari awa inono da simba edo ira. ");
INSERT INTO nou_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Edo embo amemi God sapo edo ro ewamei awa edo ira awa God embo awa dipapa edo ira. Uso rorobe rori awa kotae ra. ");
INSERT INTO nou_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Edo ingo binga awa God mi Israel embobo da yei itiri bugusira awa gari ra. Edo binga emone binga ewamei God mi bega Iesu Keriso busu da embo berari da gitijigari ainda yei awodo ititisira. ");
INSERT INTO nou_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Edo ingo gari ra Galilee busu da rora nembodiba tuturo isira edo Israel da busu berari da isira. Edo wasiri isira eiawa John umo mi ewamei ari embo da atopatari amboda isira. ");
INSERT INTO nou_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Edo ingo Iesu Nazareth nati embo awa gari ra. Edo ingo gosewa God mi uso yei Asisi Kotopu de gorobe de ititisira. Edo God awa ungae daedo ra awasedo umo yei berari da tembuse embo berari da yei ewamei adi isira edo embo Satan mi uso goroba mi sandidigari awa euri ewamei edo isera. ");
INSERT INTO nou_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Edo nango awa berari gosisera Jew embobo da busu da edo Jerusalem nati da awa ingoda yei sera. Edo embo ne eiawa benema mi orega da detero bebetisira. ");
INSERT INTO nou_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Awarate umo betetiri iji tamonde atae etiri God mi umo jigiri eririsira. ");
INSERT INTO nou_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Edo umo etiri erido umo embo berari da yei isaga aerate nango umo de indari indero nangoda yei isaga isira awa God mi matu sia edo nango mi ro gosisera awa sadi umo isaga isira. ");
INSERT INTO nou_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Edo umo goroba de nango mi binga ewamei awa embo atopatorase sisira. Edo nango gosera God mi umo embo bebetegari de wawasiri de awa kasarase ititisira awasedo God mi nango mi embo awa umo awa atopatorase sisira. ");
INSERT INTO nou_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Edo God da binga sari embobo berari mi ge sisera embo ave umo ge be adira awa God mi uso jawo da goroba mi embo ainda wasiri biae awa kotembedo doadira.” ");
INSERT INTO nou_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Edo Peter ge sise atiri Asisi Kotopu embo uso ge ingise atisera ainda yei wowosisira. ");
INSERT INTO nou_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Edo Jew embobo Iesu ge be edo isera Joppa nati da atima isera awa Peter ga bugusera awa kove be isera ainda be awa God embo Jew embobo ae de daedo kando Asisi Kotopu awa itira. ");
INSERT INTO nou_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Edo Jew embobo ae ge re neinde kainde embo gae awa sedo edo ungo God jasiga isera. ");
INSERT INTO nou_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Edo Peter mi sisira, “Embo amemi embomei eiawa umo mi ewamei ari wasiri awa beorase beitigaera.” ");
INSERT INTO nou_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Edo Peter awodo sedo setiri ungo mi Iesu Keriso da jawo da ungo umo mi ewamei isera. Edo ungo awodo etero ungo mi Peter daedo iji tupo atarase sedo gosisera. ");
INSERT INTO nou_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iesu da binga atopapotegari embobo de nanonamendi Judea busu da awa binga Jew embobo ae awa God da ge awa betera awa ingisera. ");
INSERT INTO nou_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Edo Jew embobo nenei awa embo Jew egeregae awa Jew embobo da wasiri awa ambo ambo orase dipapa isera awasedo Peter Jerusalem nati da vitiri embomei amimi Peter ga da ge bagisera. ");
INSERT INTO nou_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Edo ungo mi umo tu burise sisera, ‘Imo embo Jew embobo ae awa esega ise edo ungo wasiri tamo kotopu da mendo da andiso diwari awa bae embomei awa ungoda mando da esega ise daedo indari indewosa.” ");
INSERT INTO nou_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Awasedo Peter mi tuturo da edo ro isiri awa ungoda yei sisira. ");
INSERT INTO nou_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Edo Peter ungoda yei sisira, “Na Joppa nati da God manunugurise atise edo eturo arago isena. Edo eturo arago ise edo rora teta bo nembodiba sangove sangove jigido itari wosari inge isira. Edo wosedo naso demo da pepetisira. ");
INSERT INTO nou_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Edo diti jo da isena awa wo pepeta edo ira edo wo akogedo ira edo ri memei mane egeregari awa gosisena. ");
INSERT INTO nou_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Edo na ditini eno ge javi ingisena amimi naso yei sisira, ‘Peter erido dedo indigae.’ ");
INSERT INTO nou_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Awarate nanemi sisena, ‘Bada awodo aera. Edo na indari indapu awa indae ra.’ ");
INSERT INTO nou_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Edo sekago ge javi utu da mi sisira, ‘Ro God mi etiri ewamei etira awa inemi biae awa seose.’ ");
INSERT INTO nou_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Edo iji tamonde eiawa edo bo nembodiba awa utu da sekago vivitisira. ");
INSERT INTO nou_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Edo iji ainde embo tamonde Caesarea nati embo da amimi naso yei itiri bugusera awa bugudo mando na atima isena ainda bugusera. ");
INSERT INTO nou_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bugero Asisi Kotopu mi naso yei sisira embomei eiawa jegigi eose ta daedo mambuio sisira. Edo nanonamendi 6 Joppa nati da atima isera eiawa nangae daedo Caesarea nati da mambudo nango Cornelius da mando da totorisera. ");
INSERT INTO nou_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Edo nango torero Cornelius mi umo asisi ewamei uso mando da derido atiri gosisira awa nangoda yei sisira. Edo anela mi uso yei sisira, ‘Embo da itio mambudo Joppa nati da embo jawo Simon Peter sedo era awa bare. ");
INSERT INTO nou_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Edo unemi God mi embo soregadira ainda emboro awa iso yei ujugadira. Edo imo uso ge ingadesa awa God mi imo de iso orobe de awa soregadira.’ ");
INSERT INTO nou_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Edo umo awodo setiri na ge sadi tuturo eno iji ainde Asisi Kotopu ungoda yei wowosisira teta tuturo da ingodenaso wowosisira da awodo. ");
INSERT INTO nou_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Edo umo wosetiri na Bada mi ro sisira awa kotemburisena, ‘John umo mi embo ewamei ira te God awa Asisi Kotopu mi ingo ewamei adira.’ ");
INSERT INTO nou_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Edo ingodena Iesu Keriso gebe isera iji ainde God mi kando Asisi Kotopu ingodenaso yei ititisira iji ainde ge be isera. Edo God mi ingodenaso yei etiri isaga etira kando da awa embobo Jew ae da yei daedo ititara.” ");
INSERT INTO nou_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Edo ungo Peter mi ge sisira awa ingido tu sumbari awa doturisera. Edo ungo God jasiga ise sisera, “God embobo Jew ae de daedo ungoda wasiri bebegae dodo God da yei wareregorase iji itira. Edo umo ungoda yei wasiri mata awa atari borase iji itira.” ");
INSERT INTO nou_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Embomei mi Stephen awa detero bebetisira iji ainde Iesu ge be ari embobo da yei dedo gaedo ari iji bugusira. Edo iji ainde dedo gaedo ari mi etiri Iesu ge be ari embobo yei berari da sisikakain isera. Edo embo nenei awa yei ribori be mambudo Phoenicia busu da edo Cyprus ingigi da edo Antioch nati da mambusera. Edo ungo yei einda mambudo binga awa Jew embobo da yei sedo isera embo Jew ae ainda yei sae. ");
INSERT INTO nou_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Awarate Iesu ge be ari embobo nenei Cyprus ingigi embobo de Cyrene nati embobo de mi Antioch nati da mambudo binga awa embo Jew ae ainda yei minonu sisera. Edo ungo mi embomei awa Bada Iesu da jawo da binga ewamei awa atopapotisera. ");
INSERT INTO nou_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Edo Bada goroba nembodiba de daedo buro isira edo embo jiwae be ge be edo Bada da yei wareregurisera. ");
INSERT INTO nou_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Edo eiawa isira ainda binga awa Iesu da embo teotopo Jerusalem nati da atima isera amimi ingido gido ungo mi Barnabas Antioch nati da itero mambusira. ");
INSERT INTO nou_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Edo umo ainda mambudo God mi embomei awa ewamei isira awa gido iaviri be isira. Edo ungoda yei esusu ititise sisira, “Ingo ingoda jo berari mi Bada da yei saboa ewo. Edo umo ambo ambo ari awa dove.” ");
INSERT INTO nou_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Edo Barnabas awa embo ewamei na. Edo umo goroba de Iesu ge be edo isira edo uso jo awa Asisi Kotopu mi beda isira. Edo embo jiwae be Bada da yei puma isera awa umo ge be edo isera. ");
INSERT INTO nou_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Edo Barnabas Tarsus nati da Saul eura adi mambusira. ");
INSERT INTO nou_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Edo umo tambudo budo Antioch nati da budo bugusira. Edo ungo etoto nati ainda gaeko da atisera. Edo ungo ainda atise ungo iji berari Iesu da embo topo ainde dada ise embo jiwae be atopatido isera. Edo Antioch nati da ainda tuturo edo Iesu ge be ari embobo awa jawo Christian sisera. ");
INSERT INTO nou_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Edo iji ainde binga sari embobo Jerusalem nati dodo Antioch nati da wowosisera. ");
INSERT INTO nou_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Edo ainda teda embo da jawo Agabus mi erido umo Asisi Kotopu da goroba mi sisira baimana iji awa busu jiwae be da yei bugadira sisira. Edo amboda Claudius awa Rome embobo da gitijigari nembodiba isira iji ainde baimana awa bugusira. ");
INSERT INTO nou_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Awasedo ambojimbi mi sisera, “Ingodena dada ingodenaso yei inono gido ingode ingodenaso nanonamendi Judea busu da atima era awa ingode kondade adera. ");
INSERT INTO nou_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Edo ungo awa sedo Paul de Barnabas de awa itero ganu budo embo Iesu da teotopo ainda gitijijigegari da yei budo mambusera. ");
INSERT INTO nou_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Iji ainde Herod embo Iesu da teotopo awa dedo gaedo adi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Edo setiri ungo mi John da namendi James awa kasiwo mi dorisera. ");
INSERT INTO nou_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Edo Herod da wasiri eiedo emi Jew embobo iaviri etero gido setiri ungo mi Peter bundisera. Edo eiawa isira iji awa Jew embobo ambe bajari siwo yeast ae indido isera iji ainde. ");
INSERT INTO nou_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Edo ungo mi Peter bundedo gajari oro da isoro embobo diti 4 mi simba orase ititisera, isoro embobo diti 4 ainda teda embo 4 mi. Edo Herod umo kotisira awa jarusegari bondo atae ari umo Peter awa ungoda yei arapa da itari kasadera awa kotisira. ");
INSERT INTO nou_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Awasedo isoro embobo umo simba edo gogo isera edo Peter gajari oro da atisira. Awarate embo Iesu da teotopo amimi God Peter kondade arase gido benunu enjegedo sae isera. ");
INSERT INTO nou_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod umo Peter kasadi evira tumba awa Peter isoro embobo etoto da soropu da esi etoto mi digero pasido ewo ise atisira. Edo isoro embobo etoto mangiro be da derido atisera awa gajari oro da mangiro be awa simba edo gogo isera. ");
INSERT INTO nou_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Edo ro arago ise Bada da asisi ewamei bugudo gajari oro jo da deriri usasa jani burisira. Edo asisi ewamei mi Peter budo yakawo yakawo etiri eririsira. Eriri uso yei sisira burigi eri sisira iji ainde ngobu Peter digero atisira awa dudurisira. ");
INSERT INTO nou_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Edo asisi ewamei mi Peter da yei sisira, “Iso sini awa digido edo iso tei goru awa asugeio.” Setiri Peter awodo isira. Etiri asisi ewamei mi sisira, “Iso ombari budo ombudo nangae puio.” ");
INSERT INTO nou_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Setiri Peter asisi ewamei awa ambo ambo edo daga ponda mambusera. Awarate Peter ro ira awa be ira awa umo gaera. Edo umo kotisira awa umo eturo arago ari awa kotisira. ");
INSERT INTO nou_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Edo ungo isoro embobo diti da awa derigedo bugudo diti nei da bugusera. Edo diti awa derigedo edo ungo gajari oro da mangiro emboro nembodiba da bugudo era ainda bugusera. Edo ungo bugero embo da amemi jigae rate umo umosuka ungo embo pirigurisira. Pirigetiri ungo ponda bugudo emboro da pepeta isera. Edo ungo emboro da pepeta ero asisi ewamei Peter doturisira. ");
INSERT INTO nou_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Edo Peter ro uso yei isira awa gido sisira, “Na boroko gosena eiawa ge be ra. Bada mi uso asisi ewamei itiri amimi etiri na Herod da ingo da awa dodo ponda wosetena. Edo anela mi rora ro Jew embobo mi naso yei adi dipapa era awa kondade etiri ae dotera.” ");
INSERT INTO nou_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Edo Peter eiawa gido Mary John Mark da ai da mando da mambusira. Edo embo jiwae be ainda dada edo God manunugurise atisera. ");
INSERT INTO nou_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Edo Peter mangiro ponda taintain detiri agipo gagara jawo Rhoda mi amemi iri awa gadi bugusira. ");
INSERT INTO nou_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Edo umo Peter da ge javi ingido iaviri be isira awasedo mangiro pirigae rate engenembedo sumbudo mambudo embomei ainda yei sisira, “Peter mangiro ponda derido atira.” ");
INSERT INTO nou_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Edo gagara awa awodo setiri ungo mi uso yei mina sisera, “Imo gagara jiro biae ari ra gio.” Setero umo besara ise sisira, “Na ro sena amone gebe ra.” Awasedo ungo mi mina uso yei sisira, “Amone Peter da asisi ra.” ");
INSERT INTO nou_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Edo ungo awodo sise atero Peter taintain dorise atisira. Edo ungo mangiro pirigedo umo ainda atiri gido ungo kove be isera. ");
INSERT INTO nou_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Edo Peter ingo mi ge dorase isira edo Bada mi umo gajari oro da awa emboro rawodo edo budo bugusiri awa ungoda yei ujugurisira. Edo eiawa ujugurise ungoda yei sisira, “Eiawa James de nanonamendi nenei de da yei sewo gore.” Edo Peter awodo sedo ungo dodo umo yei nei da mambusira. ");
INSERT INTO nou_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Edo sipo de isoro embobo Peter de gajari embobo de simba isera amimi ungo ungosuka Peter da yei ro etiri awa mina sara edo ungo mana mana be isera. ");
INSERT INTO nou_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Edo Herod mi umo eura orase setiri isera te umo tambae isera. Edo Herod mi setiri isoro embobo awa nganega edo detero bebetegurisera. Edo eiawa etiri ainda amboda Herod Judea busu dodo Caesarea nati da wowosisira. ");
INSERT INTO nou_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod awa Tyre nati embobo de Sidon nati embobo de da yei tini gambari isira awasedo ungo dada edo Herod gadi mambusera. Giti awa ungo Herod da gitijigari oro simba ari embobo da gitijigari Blastus ainga da ge setero umo ungode daedo otao isira. Edo umo ungode daedo otao etiri ungo Herod gido umo roedo ungode da tini gambari iri awa nganega edo goro doarase mambusera ainda be awa Herod da busu embobo awa ungoda nati embobo da yei indari ori edo isera awasedo. ");
INSERT INTO nou_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Edo awasedo Herod iji da kataburisira ainde umo uso gitijigari da ombari awa ombudo uso gitijigari da anumba da anumbedo embo da yei ge sisira. ");
INSERT INTO nou_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Edo umo embo da yei ge setiri ungo mi gogo dimbudo sisera, “Emone embo mi ge sae rate God mi sira.” ");
INSERT INTO nou_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Edo ungo awa gogo dimbudo setero iji da amimi Bada da uso asisi ewamei mi etiri umo karu isira. Umo karu etiri gangeni mi uso tamo indiri bebetisira. ");
INSERT INTO nou_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Awarate God da ge mata embo da yei rawuse atiri embo jiwae be ge be isera. ");
INSERT INTO nou_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Edo Barnabas de Saul de ungoda buro Jerusalem nati da awa atae etiri ungo mi John Mark budo Antioch nati da engenemburisera. ");
INSERT INTO nou_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Binga sari embobo nenei de atopapotegari embobo de Antioch nati da Iesu da teotopo de da teda atima isera. Edo ungoda jawo re eire Barnabas de Simeon uso jawo nei awa Embo Umenga sedo isera edo Lucius Cyrene nati embo de Manaen embo Herod da orobe da babojisira edo Saul. ");
INSERT INTO nou_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Edo ungo Bada tumondebain ise neta kakana ero Asisi Kotopu mi ungoda yei sisira, “Na awasedo Barnabas de Saul de awa demonda itiwo. Edo demonda itido dowo buro ro orase dipapa ena awa ore.” ");
INSERT INTO nou_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Edo ungo neta edo God manunugedo ingo ungoda kopiri da itido itero mambusera. ");
INSERT INTO nou_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Asisi Kotopu mi ungo itiri mambuse Barnabas de Saul de John Mark ungoda buro kondade arase sedo budo daedo Seleucia nati da wowosisera. Edo ungo Seleucia nati awa dodo nga nembodiba de Cyprus ingigi da sembusera. ");
INSERT INTO nou_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Edo ungo sembudo Salamis nati da bugusera bugudo Jew embobo da dada ari oro da torido God da binga ewamei awa minonu sisera. ");
INSERT INTO nou_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Edo ungo binga ewamei awa Salamis nati embobo da yei minonu sedo ungo ingigi awa sembudo Paphos nati da bugusera. Bugudo ainda kae jingama ari embo jawo Bar-Iesu awa tambusera. Edo kae embo eiawa Jew embo ra amimi embo gandubedo sedo isira umo awa binga sari embo awodo sedo isira. ");
INSERT INTO nou_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Edo umo awa ingigi ainda embobo da gitijigari jawo Sergius Paulus da otao ra. Edo Sergius Paulus awa embo gari jiwae embo ra. Edo unemi God da ge ingadi sedo setiri embo nenei mi Barnabas de Saul de awa budo uso yei bugusera. ");
INSERT INTO nou_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Awarate inja embo uso jawo Greek ge mi Elymas sedo era ujo ae isira. Greek ge Elymas ainda be inja embo. Edo ujo ae edo gitijigari God da ge awa ge be eurase gajadi jarisira. ");
INSERT INTO nou_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Edo Saul umo Paul sedo isera awa Asisi Kotopu mi beda ari mi inja embo awa gongon edo uso yei sisira, “Imo awa Satan da mei ra. Imo awa wasiri ewagaewa da gitopo ra. Edo imo iji berari embo awa iso ari wasiri gebusari berari mi gandubedo esa. Edo imo iji berari Bada da ge be ari awa gebusari da wareregadi sedo jaredo esa. ");
INSERT INTO nou_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Edo Bada mi boroko imo awa uso ingo mi tamesi ari diti guba adesa. Edo imo dombu ambu edo waiko usasa gae iji ribori be atadesa.” Edo burigi be rora teta gosoro inge mi uso diti gajisira edo umenga mi jiroroka isira. Edo umo jiroro jiroro edo embo umo ingo da budo mamborase eura isira. ");
INSERT INTO nou_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Edo gitijigari ro isira awa gido ge be isira. Edo Bada da atopatari mi etiri umo kove be isira. ");
INSERT INTO nou_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul de embo daedo tembuma isera awa Cyprus ingigi da nati Paphos awa dodo nga de Perga nati da busu Pamphylia da mambusera. Awarate ungo ainda mambero John Mark ungo dodo Jerusalem nati da engenembedo mambusira. ");
INSERT INTO nou_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Edo Paul de embo nenei de Perga nati awa dodo Antioch nati da busu Pisidia da mambusera. Edo Jew embomei da tumondebain ari iji de ungo Jew embobo da dada ari oro da torido anumburisera. ");
INSERT INTO nou_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Edo embo Moses da agodari awa tano da ajigedo edo God da binga sari embobo da ove jiwari tano nenei awa ajigedo atae etiri Jew embobo da dada ari oro da gitijijigegari mi ungoda yei binga ititisera. Edo binga ainda sisira, “Nanonamendi ingoda ge mi embo esusu itadi ra gido re nango ingo ungoda yei ge sawase dipapa era.” ");
INSERT INTO nou_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Edo Paul binga awa budo erido embo uso ge ingorase ingo mi wasiri edo umo ge sadi tuturo isira. Edo Paul mi ungoda yei sisira, “Ingo Israel embobo de edo ingo Jew embobo ae de God tumondebain edo ewa naso ge ingiwo. ");
INSERT INTO nou_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel embomei einda God mi matu be ingodenaso mamoumbogo awa uso embo orase kataburisira. Edo ungo teta nati nei embobo awodo Egypt busu da atima isera edo God mi etiri ungo bajido embo nembodiba be isera. Edo God uso goroba nembodiba mi Egypt busu da edo budo bugusira. ");
INSERT INTO nou_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Edo gaeko 40 awodo ungo yei ro atae da erigi erigi ise temboro edo God mi ungo awa teta aimamo mi ungoda kinapeina degowa edoera da awodo edo isira. ");
INSERT INTO nou_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","God mi Canaan busu da embo orobe 7 awa usibesi edo busu awa Israel embobo da yei ititisira. ");
INSERT INTO nou_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Edo gaeko 450 awa kasari embo itcri ungo gitijigido isera. “Edo iji awa atae etiri Samuel binga sari embo awa ungoda gitijigari arase ititisira. ");
INSERT INTO nou_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Edo ainda amboda embo mi gitijigari nembodiba be awa dipapa etero gido God Saul itiri ungoda gitijigari nembodiba isira. Edo Saul awa Kish da mei edo Benjamin da orobe awa gaeko 40 awodo gitijijigurisira. ");
INSERT INTO nou_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Awarate God Saul budo demonda itido David awa itiri gitijigari nembodiba be isira. Edo God mi David da jawo da ge sisira, ‘David Jesse da mei awa embo na dipapa ena awa ra. Edo unemi na umo ro arase dipapa ena awa adira.’ ");
INSERT INTO nou_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Edo Iesu awa gitijigari nembodiba David da orobe awa God mi Israel embobo da soregari embo arase itiri bugusira teta adi sisira da awodo. ");
INSERT INTO nou_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Edo Iesu uso buro tuturo ae atiri John mi Israel embobo berari da yei sisira ungo ungoda wasiri bebegae awa dodo God da yei wareregedo edo umo mi ewamei ari wasiri awa borase sisira. ");
INSERT INTO nou_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Edo John umo uso buro atae adi aikambu ise embo da yei sisira, ‘Ingo kotewa na awa God mi soregari embo itari bugarase sisira awa kotevita? Awarate na awa embo simba ewa embo ewa aera te umo uso bugari iji awa asusubetiri. Edo na awa ewa raro umo kondade edo uso tei goru kougeni?’ ");
INSERT INTO nou_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Naso nanonamendi ingo awa Abraham da orobe ra edo ingo embo nenei Jew egeregae God tumondebain edo ewa ingiwo. God mi soregari binga eiawa ingodena berari ainda yei itiri bugira. ");
INSERT INTO nou_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Edo embo Jerusalem nati da atima era edo ungoda gitijijigegari de awa Iesu awa soregari embo awa ungo gae ra. Edo daedo ungo God da binga sari embobo da ove Jew embomei da tumondebain ari iji berari de ajigedo isera awa ungo gae ra. Awarate ungo mi Iesu kasisera edo God da binga sari embobo mi ro adira sisera awa be ijegurisira. Edo ro ijegurisira awa eire. ");
INSERT INTO nou_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Edo ungo mi wasiri biae da nei ro awa tambae isera ainda be awa umo awa wasiri biae ae de gido awasedo ungo buria da nonda umo dari betari awa ae isera. Awarate ungo Pilate mi umo betarase awa sarase sedo gosisera. ");
INSERT INTO nou_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Edo ungo mi ro ove jiwari mi embo mi uso yei ro orase sisira awa berari edo ungo uso tamo awa orega da awa itero wosetiri budo betari gowari meko da ititisera. ");
INSERT INTO nou_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Awarate umo betetiri God mi umo jigiri eririsira. ");
INSERT INTO nou_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Edo matu embo umo amende Galilee busu da edo pepeta edo Jerusalem nati da mambusera ainda yei umo wasiri de sekago erido iji jiwae be isaga edo isira. Edo embomei emimi ungo mi ro berari gosisera awa boroko Israel embobo da yei sera. ");
INSERT INTO nou_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Awarate nango awa binga ewamei eiawa ingoda yei sadi bugutitara. God mi Iesu awa jigiri eririsira edo umo boroko ingodenaso yei ro adi sari ingodenaso mamoumbogo da yei sisira awa etira. Edo Psalm jiwari embo mi God ro sisira awa Psalm 2 da eiawa sedo sisira, ‘Imo awa naso mei. Boroko na awa iso imamo ra.’ ");
INSERT INTO nou_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Edo God mi ove jiwari ainda joda sisira Iesu betari edo unemi sekago jigari eradira sisira. Edo God awodo sedo Iesu jigiri eririsira edo Iesu mana sekago betadira. Edo God uso sekago erari da ge sisira, ‘Nanemi ari wasiri dagariae be nanemi David da yei adi sisena awa imo awa embo adena.’ ");
INSERT INTO nou_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Edo Psalm jiwari nei mi soregari embo God mi itari bugarase sisira ainda jawo da, God da yei sisira, ‘Inemi mana iso agipo embo ewamei be da tamo awa mana doaso betedo sununusadira.’ ");
INSERT INTO nou_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Edo David atima isira iji ainde umo God mi ro arase dipapa edo isira awa edo isira. Edo umo betetiri ungo mi umo awa uso mamoumbogo da demo da gousera edo uso tamo awa betedo sununusira. ");
INSERT INTO nou_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Awarate embo awa umo bebetisira awa God mi umo awa jigiri eririsira edo uso tamo awa uro da betedo sununusae ra. ");
INSERT INTO nou_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Edo ingo naso nanonamendi berari binga ewamei God mi embo da wasiri bebegae kotembedo doadira awa ingoda yei sena awasedo giwo. Edo God awa wasiri bebegae kotembedo dodo ira ainda be awa Iesu umo ro edo ira awa isira awasedo. Edo wasiri bebegae mi ingo awa bundisira edo Moses da agodari mi ingo awa wujegari katogo ae isira te embo ave Iesu ge be adira awa God mi wujegadira. ");
INSERT INTO nou_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Awasedo ro God da binga sari embobo mi sisera awa ingoda yei eure gido gogo ewo. ");
INSERT INTO nou_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Edo God da binga sari embobo mi sisera, ‘Embo ingo God da binga awa ingise iro jirewa awa God mi kasure ta gido gogo ewo. Edo buro ingo wasiri de atewo ena awa ingo ge be ae ewa. Edo embo da mi naso buro da be awa ujugadira awa ingo mana ge be adewa.’” ");
INSERT INTO nou_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Edo Paul de Barnabas de Jew embobo da dada ari oro awa dodo mambutero embobo mi ungoda yei sisera, “Tumondebain ari iji nei sekago einda bugudo eiawa nei sawo gore. ");
INSERT INTO nou_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Edo embo dada ari yei awa dodo Jew embobo de Jew embobo ae de wareregedo Jew embobo da tumondebain ari wasiri awa ambo ambo isera amimi Paul de Barnabas de ambo ambo isera. Edo Iesu da binga atopapotegari embobo etoto amimi ungo dengoro bagedo sisera, “Ingo berari awa iji berari God da kando awa burise edo God da uso simba ari da iji berari atiwo.” ");
INSERT INTO nou_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Edo Jew embomei da tumondebain ari iji nei embo jiwae be jiwae nati da atima isera awa God da ge ingadi bugusera. Edo roinge awa bugae doturisera. ");
INSERT INTO nou_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Edo Jew embobo embo jiwae be ge ingadi bugusera awa gido ungo tu burise jo da tini gambari isera. Edo jo da tini gambari edo ge ro Paul mi sira pasega sari ge sise uso yei ge bebegae sisera. ");
INSERT INTO nou_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Awarate Paul de Barnabas de ge doae rate ge isaga sedo sisera, “God nango binga eiawa giti ingoda yei sorase setira te ingo uso binga awa ujo ae ewa edo ingo wasiri matawa atari awa bari inono ae ewa. Awasedo nango ingo dodo Jew embobo ae da yei mambadera. ");
INSERT INTO nou_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Edo God mi ove jiwari ainda joda ge sise sisira, ‘Nanemi imo awa Jew embobo ae da usasa itena. Nanemi imo awa naso soregari da emboro awa busu berari da embo da isaga asase itena.’” Edo nango ge eiawa ajigedo gosera umo nangoda yei sisira. ");
INSERT INTO nou_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Edo embo Jew egeregae ge eiawa ingido iaviri be isera “Bada God ro sisira awa ijegurisira.” Edo embo ave God mi wasiri matawa atari borase matu ititisira awa ge be isera. ");
INSERT INTO nou_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Edo yei ainda yei berari da God da ge awa rawusira. ");
INSERT INTO nou_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Awarate Jew embobo mi etero embo nembogamo de embo evetu Jew ae nembogamo de God tumondebain edo isera awa tini gambari isera. Edo ungo tini gambari embo de evetu de emimi etero embobo erido Paul de Barnabas de dedo gaedo adi tuturo isera edo ondetero ungoda yei awa dodo demonda mambusera. ");
INSERT INTO nou_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Edo ungo ondetero Iesu da binga atopapotegari embobo mi ungoda tei janjara awa gajigurisera amimi embo binga awa ujo ae etera awa isaga arase edo ungo yei awa dodo Iconium nati da mambusera. ");
INSERT INTO nou_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Edo ambojimbi Antioch nati da atisera awa iaviri de edo Asisi Kotopu de mi beda isera. ");
INSERT INTO nou_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconium nati ainda Paul de Barnabas de Jew embobo da dada ari oro da torido embo da yei ge sisera. Edo ungo ge setero embo jiwae be Jew embobo de embo Jew ae de awa ge be isera. ");
INSERT INTO nou_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Awarate Jew embobo ge be ari ujo ae isera amimi etero embo Jew ae awa ungoda kotari jo da awa nanonamendi da yei biae isira. ");
INSERT INTO nou_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Edo Iesu da binga atopapotegari embobo awa ainda iji ribori be atise Bada da jawo da ge isaga sedo isera. Edo embobo ainda awa uso kondade ari da binga awa ge be gosisera ainda be awa Bada mi ungoda yei goroba ituri ungo ari wasiri goroba de edo ari wasiri embo mi matu gae awa edo isera. ");
INSERT INTO nou_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Awarate nati embobo awa ro era awa da awa kotae edo isera edo embo nenei awa ro Jew embobo mi ro sera awa adi eoro edo embo nenei awa ro Iesu da binga atopapotegari embobo mi sera awa adi edo isera. ");
INSERT INTO nou_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Edo Jew embobo de embo Jew ae amimi ungoda gitijijigegari de dada edo ainda ge awa dada sedo sisera awa ungo mi Iesu da binga atopapotegari embobo da yei wasiri bebegae edo edo ganuma mi wawara edo doro bebetegorase sisera. ");
INSERT INTO nou_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Edo Iesu da binga atopapotegari embobo ungo ro adi sia era awa ingido ungo oju sumbudo Lystra de Derbe nati de busu Lycaonia da ainda mambudo ainda edo ainda yei demonda jiroroka ari ainda binga ewamei awa atopapotisera. ");
INSERT INTO nou_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra nati da embo da awa tei ambari gido anumbedo atima isira. Edo uso ai mi burisira iji ainda bugudo Paul mane mambusera iji ainde awa umo meani pepeta aera. ");
INSERT INTO nou_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Edo umo anumbedo atise Paul da ge awa ingisira. Edo Paul embo awa gebe ira God mi umo ari ewamei adira awa gido, gido umo embo awa gongon edo gogo dimbudo sisira, “Erido dagaia derio.” Setiri embo awa kekepuinya edo souedo erido pepeta adi tuturo isira. ");
INSERT INTO nou_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Edo embo jiwae be Paul mi ro isira awa gido ungoda Lyaconia ge mi gogo dimbuse sisera, “God mane teta embo inge edo ingodenaso yei wostera.” ");
INSERT INTO nou_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Edo Barnabas da jawo awa ungoda god ove kewari da jawo awa Zeus itido edo Paul da jawo awa ungoda god ove kewari da jawo awa Hermes itido isera ainda be awa embo re Paul mi ge re sisira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Edo god Zeus da uso mando embo mi umo ainda tumondebain edo isera awa nati ponda ainda ititisera. Edo Zeus da priest mi wo de ri wuji de budo nati jiwa da bugusera ainda be awa umo de embo jiwae be de amimi Iesu da binga atopapotegari embobo da yei rorou itadi sedo. ");
INSERT INTO nou_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Edo Barnabas de Paul de ungo ro adi era awa ge ingido ungoda sini bo jigido torere torere isera ainda be awa ungo embomei ro adi era awasedo dubo vevera isera. ");
INSERT INTO nou_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Edo ungo sumbudo embo da teda wosedo gogo dimbudo sisera, “Embomei ingo ro edo eiawa evi? Nango re embo ingo awodo mi binga ewamei eiawa minonu sadi bugutitara. Oro ingo rora be ae eiawa dodo edo God wasiri de utu de busu de edo ainda jo da rora berari atima era awa isira embo ainda yei wareregawase nango re binga ewamei eiawa minonu sera. ");
INSERT INTO nou_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Edo iji matu da awa God mi ungo beitigae dotiri busu berari da embobo awa ungo ro dipapa era awa egeregurisera. ");
INSERT INTO nou_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Awarate embo mi God umo atima ira awa gorase umo iji berari ari wasiri ewagaewa edo ira. Edo unemi ga ituri utu da edo wosedo ira. Edo unemi euri indari ve ungoda gaeko da erido era. Edo unemi ingoda indari itido ira amimi euri ingoda jo awa iaviri mi beda edo ira.” ");
INSERT INTO nou_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Edo Iesu da binga atopapotegari embobo ge awodo sedo embo jiwae be ungoda yei rorou itadi isera awa beitigadi isera. ");
INSERT INTO nou_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Edo Antioch nati busu Pisidia da Jew embobo nenei de Iconium nati Jew embobo awa bugusera. Edo ungo mi embobo ainda awa jo indero ungo berari mi ganuma wawara edo Paul dorisera. Edo ungo kotisera awa Paul betari ge sedo umo jumbudo budo mambudo budo nati pon da mambusera. ");
INSERT INTO nou_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Awarate Iesu ge be ari embobo mi umo jinenebedo dada etero umo sekago erido nati da totorisira. Edo sipo nei umo de Barnabas de Derbe nati da mambusera. ");
INSERT INTO nou_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul de Barnabas de binga ewamei awa Derbe nati embobo da yei atopatetero embo jiwae be Iesu da ambojimbi isera. Edo ungo nati awa dodo Lystra nati da engenemburisera edo ainda edo Iconium nati da mambusera edo ainda edo Antioch nati busu Pisidia da ainda mambusera. ");
INSERT INTO nou_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Edo ungo yei eiawa esega ise ungo embo Iesu ge be edo isera awa atopatido isera embomei ainda dubo bari God da yei edo jao namendi da yei dubo bari awa babojisira. Edo ungo Iesu gebe ise atorase esusu ititisera. Edo Paul de Barnabas de mi embomei ainda yei sisera, “Ingodena God da gitijigari yei da torae atise ingodena God da emboro da pepeta iriroro bouga nembodiba awa ingodenaso yei puradira. ");
INSERT INTO nou_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Edo yei dada ainda teotopo Iesu da roinge ateri ainda embo nenei ungo gitijigarase itido isera. Edo embomei emone Iesu ge be edo isera embobo awa ra. Edo Paul de Barnabas de neta edo God manunugedo edo Bada da simba ari da embomei awa itido isera. ");
INSERT INTO nou_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Edo ungo Pisidia busu awa sembudo busu Pamphylia da bugusera. ");
INSERT INTO nou_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Edo Perga nati embobo da yei binga ewamei awa minonu sedo ungo Attalia nati da wowosisera. ");
INSERT INTO nou_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Edo Attalia nati awa dodo nga de Antioch nati da engenemburisera. Edo nati ainda Paul de Barnabas de esega eoro Iesu da binga atopapotegari embobo nenei mi ungo awa Bada da simba dada itido isera. Edo boroko ungoda buro ro adi mambusera awa atae etiri ungo engenemburisera. ");
INSERT INTO nou_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Edo ungo Antioch nati da bugudo Iesu da teotopo jawo setero ungo berari dada isera. Edo Paul de Barnabas de mi God mi ungoda yei ro isira awa sisera. Edo God mi embobo Jew ae awa ge be orase emboro pirigurisira awa sisera. ");
INSERT INTO nou_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Edo ge be ari embobo de iji ribori be atisera. ");
INSERT INTO nou_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Embo nenei mi Judea busu da edo Antioch nati da bugudo nanonamendi atopapotise ungoda yei sisera, “Ingo Moses da agodari mi sira awodo wasiri tamo kotopu da mendo da andiso awa diugae adewa awa ingo mana soregari da emboro awa mana tamadewa.” ");
INSERT INTO nou_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Setero Paul de Barnabas de ungo de daedo ge einda tamo da ge bagisera. Awasedo embobo ainda mi Paul de Barnabas de Antioch nati embobo nenei awa budo daedo Jerusalem nati da mambudo atopatari eiawa Iesu da binga atopapotegari embobo de embo Iesu da teotopo da gitijijigegari de daedo sedo gorase sisera. ");
INSERT INTO nou_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Edo Iesu da teotopo mi ungo itero ungo Phoenicia de Samaria busu de da awodo sembuse embo aumo embobo Jew ae jiwae awawa ungoda wasiri bebegae awa dodo edo God da yei wareregurisera awa setero gosisera. Edo nanonamendi binga eiawa ingido yaviri be isera. ");
INSERT INTO nou_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Edo ungo Jerusalem nati da bugero Iesu da teotopo de ungoda gitijijigegari de Iesu da binga atopapotegariembobo de mi ungo atega ewamei isera. Edo ungo atega etero Paul de Barnabas de mi ungoda yei God ungoda yei awodo ro isira awa sisera. ");
INSERT INTO nou_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Awarate Pharisee embobo nenei Iesu ge be edo isera amimi erido sisera, “Ungo Moses da agodari kera adi adera gido re ungo tamo kotopu da mendo da andiso diugari da wasiri awa adera.” ");
INSERT INTO nou_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Edo Iesu da binga atopapotegari embobo de embobo Iesu da teotopo da gitijijigegari de dada edo kotari eiawa kasisera. ");
INSERT INTO nou_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Edo kotari eiawa ungosuka iji ribori be kasedo Peter mi erido sisira, “Naso nanonamendi nanemi binga ewamei awa embo Jew ae ainda yei minonu sanase matu be God mi na awa ingoda teda kataburisira awa ingo gosewa. Edo ungo ingido ge be orase God mi eiawa isira. ");
INSERT INTO nou_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Edo God umo embo dada ungoda jo da ro kotera awa gido ira amimi Asisi Kotopu awa embo Jew ae ainda yei ingodenaso yei ititisira da awodo itutara awasedo ingodena gosera God umo embo Jew ae awa ujo ae aera. ");
INSERT INTO nou_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Edo God mi ingo de namonde ungo de awa gari nei nei aera. Edo unemi ungoda jo awa segutara ungo ge be etero gido. ");
INSERT INTO nou_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ingode ingodenaso Jew embobo da agodari kera orase sadera awa ingode bouga nembodiba awa ungoda saga da itadera. Awasedo ro edo Iesu ge be ari embobo da yei bouga nembodiba ungoda saga da itido edo ingo God bagari da itadi dipapa evi? Ingodenaso mamoumbogo ta ingodena awa bouga awodo awa mana ango ae etera. ");
INSERT INTO nou_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Awodo ae ra te ingodenaso gundesega da goroba awa God uso soregari awa uso kando ingodenaso yei da ra kando Iesu Keriso mi budo ingodenaso yei bugusira. Edo God mi embo Jew egeregae awa soregurara teta ingodena soregurira da awodo.” ");
INSERT INTO nou_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Edo Peter ge sedo atae etiri embo berari awa jamo jamo edo Paul de Barnabas de da ge awa ingise atisera. Edo Barnabas de Paul de mi God mi ungoda yei awodo ari wasiri goroba de edo ari wasiri neinde kainde embo mi matu gae awa edo embo Jew ae ainda yei isira awa sisera. ");
INSERT INTO nou_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Edo ungo ge sedo atae etero James mi sisira, “Nanonamendi ge naso eiawa ingiwo. ");
INSERT INTO nou_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon mi ingodenaso yei eiawa ta God uso dubo bari embo Jew ae ainda yei ujiji ira awa setiri gosititara. Edo embo ungoda teda awa budo etiri uso embo topo ititara. ");
INSERT INTO nou_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Edo emone ro God da binga sari embobo mi atopapotisera. Edo ove jiwari mi sisira, ");
INSERT INTO nou_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bada God mi sisira, eiawa edo atae ari, na naso embobo da yei engenembedo David da mando dudurisira awa nanemi sekago mando da ituka memeiya awa dada edo sekago jigano erido teta nanemi matu isena da awodo adira. ");
INSERT INTO nou_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Awasedo embo nenei embo Jew egeregae awa nanemi naso embobo adi jawo setena amimi na eura adera. ");
INSERT INTO nou_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Eiawa Bada God mi matu be matu isaga edo sisira.’” ");
INSERT INTO nou_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Edo James umo jiwari da tano awa sedo uso be mata amimi sisira, “Na eiawa kotena embo Jew ae awa ungoda wasiri bebegae dodo edo God da yei wareregurera awa ingode mana ingodenaso Jew embobo da agodari mi oro buria adera. ");
INSERT INTO nou_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Awarate ingode soro indari awa embo ove kewari da yei rorou itido era awa mana indadera ko indari rorou awodo edo era amone indapu awasedo. Edo daedo ingode agodari eiawa ungo soro gadera ari wasiri bebegae adi ae wo embo da ingo mi tatainya edo era awa indadi ae ororo indadi ae awa sadera. Edo ingode ge eiawa ove edo itoro ungoda yei mambadira. ");
INSERT INTO nou_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Edo Moses da agodari awa tumondebain ari iji berari edo iji ribori be Jew embobo da dada ari oro da ungo mi embo da yei ajigurewora. Edo nati berari da uso ge awa atopapotewora awasedo nango ge nei ro sadi aera.” ");
INSERT INTO nou_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Iesu da binga atopapotegari embobo de Iesu da teotopo da gitijijigegari de edo embo berari Iesu da amimi sisera, “Ingode embo nenei ingodenaso teda katabedo edo Paul de Barnabas de daedo Antioch nati da itoro daedo mambadera. Sedo ungo mi Judas uso jawo sangove awa Barsabbas ainde Silas de awa kataburisera. Edo nanonamendi embo etoto eiawa be sapo edo isera. ");
INSERT INTO nou_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Edo ove ungo mi budo mamborase ititisera re eire. “Oarie nangoda nanonamendi, Nango Iesu da binga atopapotegari embobo de embo Iesu da teotopo da babojegari de edo nanonamendi berari mi nanonamendi Jew ae Antioch nati edo Syria busu da edo Cilicia busu da atima ewa awa ategurera. ");
INSERT INTO nou_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Edo nango embo nenei nangoda teda amimi ingoda yei mambudo ingoda yei sititara ingo agodari ro sira awa adi edo re wasiri tamo kotopu da mendo da andiso diugari da wasiri awa bawase sititara. Edo ungo awodo setero edo amimi etiri ingo mana mana ititawa. Edo nango ungo ingo awodo atopatorase sae ra. ");
INSERT INTO nou_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Awasedo nango dada edo nango berari awara sedo binga sari embobo katabedo ingoda yei ititera giwo. ");
INSERT INTO nou_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Edo binga sari embobo eiawa nangoda otatao etoto dubo budo era Paul de Barnabas de Bada sapo ise iji jiwae be betari aikambu edo isera ainde daedo ingoda yei mambadera giwo. ");
INSERT INTO nou_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Edo Judas de Silas de mi ingoda yei ge nango ro jivera da awa ingoda yei ge da awa sadera giwo. Edo ungode daedo itero mambutera awara giwo. ");
INSERT INTO nou_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Edo Asisi Kotopu de nango de daedo awara sedo nango mana ingoda saga da Jew embobo da agodari awa mana bouga itadera setera giwo. ");
INSERT INTO nou_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Awarate agodari ingo re eiawa kera ewo. Indari ove kewari da yei rorou itido era awa indove, ororo indove, wo embo da ingo mi tatainya edo era awa indove edo viro bengaba ari wasiri awa eove. Edo ingo agodari eiawa kera adewa awa ingo ewamei atadewa giwo. Awara ewamei atiwo. Ingoda nanonamendi Jerusalem nati da.” ");
INSERT INTO nou_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Edo ungo binga sari embobo eiawa itero mambudo ungo Antioch nati da bugudo Iesu gebe ari embobo awa jawo setero ungo dada isera. Edo ungo dada etero ove awa ungoda yei ititisera. ");
INSERT INTO nou_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Edo embomei awa ove awa ajigedo gido ungoda jo awa iaviri mi beda isira ainda be awa ove amimi ungoda goroba ari ititisira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Edo Judas de Silas de ungo awa God da binga sari embobo ra edo iji ribori be nanonamendi da yei ge sisera. Edo ungo nanonamendi da yei ge awodo sise esusu itoro ungoda tumonda ari awa goroba edo isira. ");
INSERT INTO nou_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Edo Iesu gebe ari embo mi ungo Iesu da binga atopapotegari embobo ategorase setero ove gaetero ungoda yei da sekago itero mambusera. ");
INSERT INTO nou_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Awarate Silas ainda atadi dipapa isira. ");
INSERT INTO nou_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Edo Paul de Barnabas de Antioch nati da embo nenei de atise Bada da ge awa minonu sise embo atopatido isera. ");
INSERT INTO nou_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Amboda Paul mi Barnabas da yei sisira, “Ingae engenembedo ingodenaso nanonamendi nati matu ingae Bada da ge atopapotisena awa ingae esega ore. Edo awodo esega ise ungo ewamei ateri ta ko biae ateri awa gadera.” ");
INSERT INTO nou_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Edo Paul awodo setiri Barnabas mi sisira umo John Mark budo daedo mambari dipapa isira. ");
INSERT INTO nou_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Awarate Paul umo John Mark ungo Pamphylia busu da ungo dodo ungo buro da kondade ae mambusira awasedo umo ujo ae isira. ");
INSERT INTO nou_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Edo ungo etoto awodo kotedo ungo etoto ge okain be mina sara edo ewoga ewoga isera. Edo Barnabas Mark budo nga de daedo Cyprus ingigi da mambusira. ");
INSERT INTO nou_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Edo Paul awa Silas mi daga mambarase sisira edo nanonamendi mi ungo awa Bada da simba ari da ititisera. ");
INSERT INTO nou_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Edo Paul Syria busu de Cilicia busu de da sembudo embo Iesu da teotopo awa esusu itiri ungoda tumonda ari awa goroba isira. ");
INSERT INTO nou_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul pepeta edo mambudo Derbe de Lystra nati de ainda bugusira. Edo Iesu ge be ari embo jawo Timothy awa ainda atima isira. Edo uso ai daedo Iesu ge be edo isira. Edo umo awa Jew evetu rate uso mamo awa Greek embo ra. ");
INSERT INTO nou_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Edo nanonamendi berari Iconium nati da Lystra nati da awa Timothy awa embo ewamei sedo isera. ");
INSERT INTO nou_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Edo Paul Timothy budo daga mambadi dipapa edo gido uso tamo kotopu da mendo andiso awa diugurisira. Edo umo awodo isira ainda be awa Jew embobo berari yei ainda atima isera awa uso mamo awa Greek awa ungo berari awa gari awasedo. ");
INSERT INTO nou_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Edo ungo nati berari awa esega ise Iesu ge be edo isera embobo ainda yei agodari Iesu da binga atopapotegari embobo de babojegari Jerusalem nati da atera amimi kera orase sisera awa ungoda yei ujugurisera. Edo agodari awa kera orase sisera. ");
INSERT INTO nou_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Awasedo Iesu ge be ari embobo diti da awa ungoda tumonda ari awa goroba etiri iji berari ungoda ajigari awa nembodiba edo isira. ");
INSERT INTO nou_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Edo ungo pepeta edo mambudo edo Phrygia busu de Galatia busu de ainda pepeta isera ko ungo awa busu nembodiba Asia ainda joda gido ainda be awa Asisi Kotopu mi ungo ainda atopatorase awara sae awasedo. ");
INSERT INTO nou_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Edo ungo mambudo busu Mysia da jiwa da bugudo ungo busu awa sembudo busu Bithinia da torari dipapa isera te Iesu da Asisi mi ungo ainda tororase awara sae isira. ");
INSERT INTO nou_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Awasedo mambudo Mysia busu awa serigedo mambudo Troas nati da wowosisera. ");
INSERT INTO nou_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Edo tumbade Paul eturo arago isira ainda Macedonia busu embo awa erido derido benunu siri gosisira Macedonia busu da sembudo nango kondade eio siri gosisira. ");
INSERT INTO nou_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Edo Paul wasiri eiawa getiri nango iji da amimi erido Macedonia busu da sembadi sia isera ainda be awa nango gosisera God nango embomei ainda yei binga ewamei awa atopatorase jawo sira awasedo. ");
INSERT INTO nou_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Edo Troas nati awa dodo nango nga de Samothrace nati da sembudo eudo sipo de Neapolis nati da sembusera. ");
INSERT INTO nou_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sembudo Philippi nati Macedonia busu da nati nembodiba be ainda mambusera. Edo nati eiawa Rome embobo mi simba edo isera. Edo nango nati ainda iji tupo atisera. ");
INSERT INTO nou_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Edo Jew embomei da tumondebain ari iji de nati awa dodo sasaka beda Jew embobo God manunugadi sedo dada edo isera yei ainda nango mambusera. Edo anumbedo nango embo evetu ainda dada isera ainda yei ge sisera. ");
INSERT INTO nou_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Edo ainda teda evetu da nangoda ge ingisira awa Thyatira nati evetu jawo Lydia ra. Edo umo ganu badi sedo umo bo karako uso mina awa nembodiba awa embo da yei ori edo isira. Edo umo God tumondebain edo isira edo Bada mi uso jiro awa pirigetiri umo Paul mi ro sisira awa dengoro isira. ");
INSERT INTO nou_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Edo ge awa ingido umo de embo uso mando da atima isera awa umo mi ewamei ari wasiri awa burisera. Budo nangoda yei sisira, “Ingo na awa Bada ge be ari evetu awodo kotadewa re puwo naso mando da atave.” Edo unemi setiri jaredo gido nango mambusera. ");
INSERT INTO nou_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Iji da nango God manunugari yei da mambutero agipo gagara awa asisi biae mi umo jingama ise euri ro amboda adiri awa sedo isira gagara amimi nango tambusira. Edo umo embo ungoda yei ro adiri awa sise umo embo anda topo ri ainda yei gano jiwae be budo ititisira. ");
INSERT INTO nou_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Edo umo Paul de nango de ambo ambo ise gogo dimbudo sisira, “Embomei emone God inda atima ira ainda agipo embobo ra. Edo ungo ne God mi ingo soregadira ainda emboro awa ingoda yei minonu sera.” ");
INSERT INTO nou_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Edo gagara awa awodo iji jiwae be isira edo Paul awa ujo ae edo gido wareregedo asisi biae da yei sisira, “Iesu Keriso da jawo da nanemi sena gagara eiawa jingama dodo mambu. Edo Paul umo awodo setiri iji da amimi asisi biae awa umo dodo mambusira. ");
INSERT INTO nou_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Edo gagara awa embo amenda topo ri awa ungoda ganu bari iji awa atae etira awa gido, Paul de Silas de bundedo jumbudo budo ori garori ari yei da Rome embobo da gitijigari da jo da mambusera. ");
INSERT INTO nou_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Edo Rome embobo da kasari embo da diti da sisera, “Embomei eiawa Jew embobo ra edo ungo mi nangoda nati da wasiri bebegae ise tembera. ");
INSERT INTO nou_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Edo ungo nangoda agodari awa atopatae rate wasiri nei awa atopapotera. Edo nango awa Rome embobo ra edo nango mana wasiri eiawa adera edo badera. ");
INSERT INTO nou_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Edo ungo awodo setero embo jiwae be Paul de Silas de da jawo da ge bebegae daedo sisera. Edo kasari embo mi Paul de Silas de da bo sini awa jigido ujugedo keredo edo embobo ainda yei setero ungo mi Paul de Silas de awa ngobu mi vejisera. ");
INSERT INTO nou_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Edo ungo mi Paul de Silas de awa biae be vejedo gajari oro da wawara etero torero gajari oro simba ari embo da, embomei awa edo gogo edo simba arase sisera. ");
INSERT INTO nou_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Edo gajari oro simba ari embo ge awa ingido ungo awa gajari oro diumba soropuda itiri totorisera. Edo itiri torero ungoda tei awa wao ri mi ari ainda joda itido dada bundisira. ");
INSERT INTO nou_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Edo tumba soropu da Paul de Silas de awa God manunugurise jasiga ari ya sise atisera. Edo ungo awodo ero gajari embo nenei awa ungoda ya da javi awa ingise atisera. ");
INSERT INTO nou_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Edo iji ainde didira nembodiba be tuturo edo gajari oro da uso saga de gajari oro de awa budo yakawo yakawo isira. Edo budo yakawo yakawo ise gajari oro da mangiro berari awa pirigetiri edo gajari embobo da tei bundisera awa berari wujegurisira. ");
INSERT INTO nou_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Edo gajari oro simba ari embo gajari oro da mangiro berari awa pirigetiri gido umo kotisira awa gajari embobo berari awa babasegari ge sedo uso kasiwo gorugedo umo umosuka dedo betadi isira. ");
INSERT INTO nou_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Awarate Paul mi gogo dimbudo sisira, “Imo imosuka usibesi eose ta nango berari re atera eire.” ");
INSERT INTO nou_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Edo gajari oro simba ari embo ge awa ingido goriwo embo sisira. Setiri goriwo budo bugusera. Etero sumbudo Paul de Silas de da yei mambudo tei ingo dadara iri ungoda joda baingo dederi isira. ");
INSERT INTO nou_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Edo ungo budo ponda bugudo nganega isira, “Soregari badi sedo mo namomo ro eni?” ");
INSERT INTO nou_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Sedo nganega etiri, ungo mi mina sisera, “Imo Bada Iesu ge be adesa awa God mi imo de iso orobe de awa soregadira.” ");
INSERT INTO nou_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Edo ungo awodo sedo Bada da ge awa umo de edo embo nenei uso mando da atisera ainda yei atopapotisera. ");
INSERT INTO nou_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Edo tumba da amimi gajari oro simba ari embo mi ungo budo mambudo ungoda iso mamatu awa sesegurisira. Edo umo awa etiri Paul de Silas de mi ungo awa umo mi ewamei isera. ");
INSERT INTO nou_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Edo awa etero gajari oro simba ari embo mi Paul de Silas de budo uso mando da mambudo indari itiri indisera. Edo yaviri mi embo ainde uso orobe de da jo awa ato ae be isira ainda be awa ungo boroko God ge be isera awasedo. ");
INSERT INTO nou_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Edo sipo de kasari embo mi agodari embobo awa gajari simba ari embo awa soro Paul de Silas de awa wujegarase itiri mambusera. ");
INSERT INTO nou_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Edo gajari oro simba ari embo mi Paul da yei sisira, “Kasari embo mi imo de Silas de awa wujegorase binga itiri bugira. Awasedo ingo embo etoto jo jamo jamo de mambuwo.” ");
INSERT INTO nou_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Edo embo awa awodo setiri Paul mi agodari embo da yei sisira, “Nango Rome embobo ingodenaso agodari ro bejae awarate ingo nango kasedo gogo ae embo da arapa da vejedo edo gajari oro da gajitara. Edo boroko ungo nango gae unjugari da itoro mamborase sera. Awodo aera ungo awodo mana adera. Edo Rome embobo da kasari embobo awa sewo bugudo ungo ungosuka nango wujegore.” ");
INSERT INTO nou_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Edo ungo awodo setero agodari embobo mi engenembedo mambudo kasari embobo da yei Paul da ge awa sisera. Edo kasari embobo Paul de Silas de awa Rome embobo awa ingido ungo oju isera. ");
INSERT INTO nou_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Awasedo ungo Paul de Silas de da yei mambudo sisera, “Nango ingoda yei biae etera.” Sedo ungo gitijigido gajari oro awa dodo ponda bugudo nati awa dorase sisera. ");
INSERT INTO nou_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Edo Paul de Silas de gajari oro awa dodo Lydia da mando da mambusera edo ainda nanonamendi tambudo ungoda tumonda ari awa goroba arase ge sisera. Edo awodo edo Paul de Silas de nati awa doturisera. ");
INSERT INTO nou_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul de Silas de pepeta edo nati Amphipolis de Apollonia de da joda awodo bugudo Thessalonica nati da bugusera edo ainda Jew embobo da dada ari oro awa derido atisira. ");
INSERT INTO nou_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Edo Paul da wasiri awodo gido Jew embobo da dada ari oro da torido embo atopapotisira. Edo pura jaige tumondebain ari iji tamonde da umo Jiwari Kotopu pirigedo ungoda yei sisira, ");
INSERT INTO nou_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Jiwari Kotopu sisira Soregari Embo God mi itari bugarase sisira amimi memesi nembodiba tambudo betedo sekago wasiri de erarase sisira.” Edo ungoda yei atopapotise sisira, “Embo Iesu ingoda yei atopapotena emone Soregari Embo God mi itari bugarase sisira awara.” ");
INSERT INTO nou_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Edo embo nenei ainda ge ingise atisera awa uso ge awa ge be kotedo gido Paul de Silas de da dada edo ungoda atopatari ambo ambo edo isera. Edo Greek busu embobo jiwae be God tumondebain edo isera edo emboevetu nembogamo de daedo Paul de Silas de dada isera. ");
INSERT INTO nou_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Edo Jew embobo Paul da atopatari buro ainda ji sedo setero gido embo begogo embobo jiwae be tepo emboro da yarago purarago ise atima isera awa dada isera. Edo ungo dada edo embogo adi isera. Edo ungo mi etero nati embobo berari awa ambe pu da awodo edo Jason da mando awa bejadi tuturo isera ainda be awa ungo Paul de Silas de awa budo embo da arapa da itari dipapa edo ungo eura ise isera. ");
INSERT INTO nou_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Awarate ungo Paul de Silas de tambae edo gido Jason de nanonamendi nenei de awa jumbudo budo nati da gitijijigegari da yei mambudo gogo dimbudo sisera, “Embomei emimi ero wasiri bebegae yei berari da bugira. ");
INSERT INTO nou_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Edo ungo nangoda nati da bugudo Jason da mando da atewora. Edo ungo Caesar da agodari awa bejera ainda be awa ungo gitijigari nembodiba nei jawo Iesu atari ge sera.” ");
INSERT INTO nou_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Edo ungo awodo setero embo jiwae be de nati da gitijijigegari de ro adiri awa oju be isera. ");
INSERT INTO nou_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Awasedo Jason de embo nenei de da yei setero ganu ititisera. Edo ungoda yei sisera ungo wasiri biae nei ro ae adera awa amboda ungoda ganu awa sekago ungoda yei itadera sisera. Edo awodo sedo setero dodo mambusera. ");
INSERT INTO nou_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Edo tumba jiriri nanonamendi mi Paul de Silas de awa itero Berea nati da mambusera. Edo ungo ainda bugudo Jew embobo da dada ari oro da mambusera. ");
INSERT INTO nou_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Edo Berea embobo berari Jew embobo da dada ari oro ainda dada edo isera awa Thessalonica embobo aera te awa jo ungoda berari mi binga awa ingido isera. Edo iji berari ungo Paul mi ro sira awa ge be ta awa gadi ungo eura ise jiwari awa ajigedo isera. ");
INSERT INTO nou_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Edo embobo jiwae be ge be isera. Edo daedo Greek busu embobo de emboevetu nembogambo de da ge be isera. ");
INSERT INTO nou_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Awarate Jew embobo Thessalonica nati da awa Paul Berea nati da God da ge awa atopapotira awa ingido ungo nati ainda mambusera. Mambudo embo jawo sedo bagedo etero embo jiwae be Iesu da binga atopapotegari embobo da yei tini gambari isera. ");
INSERT INTO nou_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Awasedo Iesu ge be ari embobo mi Paul embo nei deorase itero ewa da wowosisira te Silas de Timothy de awa Berea nati da atisera. ");
INSERT INTO nou_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Edo embo Paul budo mambusera awa gaga da mambudo Athens nati da mambusera. Edo ungo iji ainde Paul dodo Berea nati da engenemburisera. Edo Paul mi ungoda yei sisira Silas de Timothy de soro uso yei burigi bugorase sisira. ");
INSERT INTO nou_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Edo Paul umo Athens nati da Silas de Timothy de uso yei bugorase simba ise ove kekevegari jiwae be embo mi tumondebain edo isera awa gido umo tini gambari be isira. ");
INSERT INTO nou_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Awasedo Jew embobo da dada ari oro da mambudo torido umo de Jew embobo de embo Jew egeregae God tumondebain edo isera ainde da ge mina sara edo isera. Edo umo daedo rora ori garori ari yei da iji berari mambudo embo ainda bugudo isera ainde daedo ge sedo isira. ");
INSERT INTO nou_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Edo Epicurean embobo nenei Epicurus da atopatari ambo ambo edo isera ainde Stoic embobo nenei Zeno da atopatari ambo ambo edo isera amimi Paul ga da besora mina ara isera. Edo Paul ungode daedo Iesu uso sekago erari da ge awa setiri ungoda embo nenei mi sisera, “Embo jiro biae ari na gore na gore ise tembari embo emomo rorae ingodenaso yei sadi jariri?” Edo embo nenei mi sisera, “Awase umone ingodenaso yei god nei awa sadi jarita rora.” ");
INSERT INTO nou_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Edo doriri ve ro erae ainda jawo Areopagus atima isira edo yei ainda embo dada edo sedo gari nembogamo awa kasedo isera. Edo embomei amimi Paul budo ainda mambusera. Mambero umo embo berari ainda dada isera ainda diti da dederisira. Edo ungo Paul budo ainda mambusera awa edo Paul da yei sisera, “Nango atopatari seka sesa awa ujugaso gadi sedo dipapa era. ");
INSERT INTO nou_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Edo imo ge nei sesa ge seka awasedo nango ge ainda be awa ujugaso gadi sedo dipapa era.” ");
INSERT INTO nou_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Edo Athens nati embobo de nati nei embobo de ainda atima isera awa ungo ingo tei wasiri nei ro ari ujo ae ra te ungo iji berari awa anumbedo ge seka ta ari seka ro bugiri awa sise atari dipapa edo isera. ");
INSERT INTO nou_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Awasedo Paul embo berari Areopagus doriri ainda dada isera ainda diti da derido sisira, “Ingo Athens embobo na gosena god neinde kainde embo nenei mi tumondebain edo era awa sapo edo ewa. ");
INSERT INTO nou_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Edo na ingoda nati jo da pepeta ise tumondebain ari yei gosise ainda teda rorou itari yei tambena. Edo rorou