﻿USE sofia;
DROP TABLE IF EXISTS sofia.notNT_vpl;
CREATE TABLE notNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES notNT_vpl WRITE;
INSERT INTO notNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yamai nasanguenataiguëmiro iripajiropague icharineegui jirai Jesoquirisito. Irirori imatsiguenga David aisati Abaram. ");
INSERT INTO notNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aro jirai itimi Abaram. Ainta itomi ira jitacha Isac. Aisati Isac itomintacari Jacob. Jacob itomintaigari ira Jorá aisati ireintiegui. ");
INSERT INTO notNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jorá ijinantacaro Tamar. Itomintacari Baris aisati Tsara. Baris, iriro iriri Esiromo. Esiromo iriri Aram. ");
INSERT INTO notNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram itomintacari ira Aminarab. Aminarab iriri Nasón. Nasón iriri Saramón. ");
INSERT INTO notNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saramón itomintaari ira Bos. Iniro Bos ojita Rajab. Itomi Bos ijita Oberi. Iniro Oberi jitacha Irot. Oberi iriri Isaí. ");
INSERT INTO notNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Itomi Isaí jitacha David, ira itingomi joríojegui. Cara Abaranquë irooti David ainta icarati 14 sërari. Yaguimintacari Orías David, itomintaari Saromón. ");
INSERT INTO notNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromón iriri Roboam. Itomi Roboam, Abías. Itomi Abías, Asa. ");
INSERT INTO notNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa itomintaari ira Josabá. Itomi Josabá irianti Joram. Itomi Joram, Osías. ");
INSERT INTO notNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osías iriri Joatam. Itomi Joatam jitacha Acás. Acás iriri Esequías. ");
INSERT INTO notNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ira itomi Esequías, Manasés. Itomi Manasés: Amón. Amón iriri Josías. ");
INSERT INTO notNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías itomintaari ira Jeconías aisati ireintiegui. Aro cara Daviriquë irooti Jeconías, ainta 14 sërari. Cara itimi Jeconías, ipocaiguë tojai soraro paniaigacha Babironiaquë, yágaiganaqueri omagaro joríojegui canta Babironiaquë. ");
INSERT INTO notNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aique iconijapë Saratieri itomi Jeconías. Itomi Saratieri irianti Sorobabé. ");
INSERT INTO notNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabé iriri Abió. Itomi Abió: Eriaquim. Eriaquim iriri Asoro. ");
INSERT INTO notNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoro itomintaari Saroco. Itomi Saroco, Aquim. Aquim iriri Erió. ");
INSERT INTO notNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Itomi Erió: Eriasari. Eriasari iriri Matán. Itomi Matán irianti Jacob, ");
INSERT INTO notNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ira tomincari José ojimetsari María. María iniro Jesos Ira aisati jitacha Quirisito Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ainta 14 sërari cara yágaiganaqueri joríojegui canta Babironiaquë irooti cara iboguë Quirisito. ");
INSERT INTO notNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yamai nongomantëmi ati ocanta jirai cara inë Jesoquirisito. Ainta José aisati iinatsari ojita María. Aroque iquengaigaca irágobaguima, carari teraiquerai iraneiro. Iroro cantënguicha poguë María, itasongancaro Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Cara igóquero José cara poguë María iquengasëretaca: “Te onganinate ca poguë. Ainiro oniaguetiri sërari. Quero náguiro. Nojocajironi comanoroni. Quero nocomantiri omatsiguenga. Paniro nanganquero: ‘Nojocajimini yamai’ ”. Irianti caninari José, icoque ingábintsero María, te iraninte iraguipasiguitiro. ");
INSERT INTO notNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iroontita iquianca José irojoquiro, iriguito yoniagapari ironomire Tosorintsi cara iquisaniqueri. Icantasiringapëri: —José, obiro imatsiguenga jirai David, quero pitsorogui cara páguëro María tenta iriro ogaguirone sërari pijinatsari. Ira ojaniquite itasongancaro Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ontsomaaquenica poro Otomi, pijitiri Jesos Irironta agabisaicoquerine imatsiguenga, irojocajineri ora icantagueti te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Antagaisati ocanca nega arota omoncaratima ora icanque Tosorintsi jirai cara isanguenatacaqueri comantantatsiri jitacha Isaías: ");
INSERT INTO notNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ainta omënibaque tsinane te oneiri sërari, ontsomaaqueri Otomi Ira jitënguichane Emanoel. Emanoel ocanti irinibarequë jorío: itsibatacái Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aro icabirica José iquemisanquero ora icomantasiringaqueri ironomire Atingomi. Iátasiquero María, icanquero: —Aro caraquenta nágasantëmi nobangoquë. ");
INSERT INTO notNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Carari terai iraneiro irooti cara ontsomaaqueri Otomi. Cara aroque iboguë ijiqueri Jesos. Aique yágasantëro ijinantacaro. ");
INSERT INTO notNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aro iboguë Jesos canta poeboroquë jitacha Berén cara quibatsiquë jitacha Jorea. Igáantë Eroris itingomi cara Jerosarénquë cara yaretaiga sërari ogótasantiri jonogasati. Ipaniaca jaanta cara iconteti paba. ");
INSERT INTO notNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yosamitaigapëri Jerosaresati: —¿Nega ini yamai ira Itingomi joríojegui? Cara nopaniaca naniaigabaqueri ionogasatite, aro nigóiguë, irirai iboguënguitsi. Yamai nipocasitaiguëri nomanocotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cara iquemocotobëri itingomi jitacha Eroris, iquenganeintasantanaca aisati itsoroganë. Itsorogaiganaque aisati omagaro Jerosaresati. ");
INSERT INTO notNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aique Eroris yapatotaiguëri antagaisati saserirotipague obatatsiri aisati omagaro iraegui ogomeantiro isanguenare Moisés. Aro yosamitaigabaqueri —¿Nega iriboguë ira jitënguichane Quirisito? ");
INSERT INTO notNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yotabitaiguëri: —Cara poeboroquë jitacha Berén yaca quibatsica ojita Jorea. Jirai isanguenatocoqueri ira comantantatsiri jitacha Miqueas: ");
INSERT INTO notNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Aiti Berén cara Joreaquë. Quero itsoinguiro Berén otiomijani poeboro: querootisati ijitiro carantatsiro aronta Berénquë iriboguë Irirosonori, Itingomi omagaro jorío. ");
INSERT INTO notNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aique comanoroni Eroris icaimagantaiguëri cogatsi iraneiri Jesos. Yosamitaiguëri: —¿Ati ocanta cara iconijatomopëmi jonogasati cara piniaigabaqueri ora pigóontacari cara iboguë Itingomi? Pingomantasantina. ");
INSERT INTO notNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aro icomantaiguëri. Aique Eroris igáqueri aisati: —Atsi pijáigue yamai. Pingogaigueri Ira Janequi. Pinetsaigueri atiraca itimi aisati atiraca icanta. Aique popigaima yaca, pingomantaigapëna naro. Nocoguini naneiri naro aisati, nantingomimpëmari. ");
INSERT INTO notNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aique iáiguë, iniaigairi jonogasati ibaqueri irooti cara yaratingopë jonoica pongotsi cara ini Janequi. ");
INSERT INTO notNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cara iniaiguëri jonogasati icaninatasantaiganaque. ");
INSERT INTO notNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Icanaque pongotsiquë, iniaigapëri Ira Janequi aisati María iniro. Aro yobaticagueritotasipari, yamanocotaiguëri, ijitaiguëri Itingomisonori. Aique itatarecoquero itsibogotequë ipasitaigacari maba ora pënatacha tojai: oro, aisati pite casangajengaro. ");
INSERT INTO notNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aique isamaiguë ira maba matsiguenga. Iquisanitaiguë. Aro Tosorintsi icamanaasiringaqueri, icanqueri: —Quero pipiganaja Eroriquë. Popiganajima piguebatsitequë cara basiniatiquë abatsi. Aro iquenantaigaaro basiniati abatsi irooti cara ipaniaca. ");
INSERT INTO notNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aroqueque iátaigai ira ogótasantiri jonogasati aique iquisanique José. Aisati iconijatomopëri ironomire Atingomi irisaanganetsite, icomantasiringapëri icampëri: —José, pingabiritima, páganëri Ira Janequi aisati iniro; pisiganëma cara Ejípitoquë. Pintime irooti cara nongomantaimi, cara popigaima, icoguirininta Eroris Ira Janequi iróguiri. ");
INSERT INTO notNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aro irooti tsitiniriquë iáiguë. Yáganëri Janequi aisati iniro canta Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Canta, itimaigapë irooti cara icamaque Eroris. Aique ipigaigapaa iguebatsitequë. Icanque irooti ora isanguenatocoqueri jirai ira comantantatsiri jitacha Oseas. Atingomi isanguenatacaqueri: Icanque Tosorintsi: “Itimabeta Notomi canta Ejípitoquë. Nacaimairi iripigapaima aisati”. ");
INSERT INTO notNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cara te iripigaima ira ogótasantiri jonogasati, aro igótanë Eroris cara te inguemisantiri. Aro iguisasanotanaca Eroris, igátaiguëri isorarote, icanqueri: —Pijáigue cara Berénquë, pógaigueri antagaisati janequi sërari. Póguiri ira irirai ibogatsi aisati ira agabisatsi pite osarini. Popoguiriaigueri omagaro. Icanque negaca Eroris aroquenta icomantasantapëri ira ogótasantiri jonogasati, ati ocanta iniaiguëri jonogasati. ");
INSERT INTO notNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jirai isanguenatocoquero oca comantantatsiri jitacha Jeremías. ");
INSERT INTO notNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Oquemocoquengani tsinane ocaimëgotasantëri otomijegui tojai piraicoqueri. Iroronta cantaca Iraquel, piraicotaiguëri ojaniquite cara Iramáquë jirai. Te onganinasëretanae yógaiguërinta otomijegui. ");
INSERT INTO notNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Icamaque Eroris. Aro iquisaniqueri José. Iconijatomopëri ironomire Atingomi irisaanganetsite cara Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Icantasiringapëri: —José, atsi yamai pijátaje popiganajima piguebatsitequë. Páganëri Ira Janequi aisati iniro aroquenta icamaque ira cogabitacha iróguirime Janequi. ");
INSERT INTO notNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aro yáganairi Ira Jesos aisati iniro, iáque cara iguebatsitequë imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Cara yaretaja José iquemocopëri Ariquerao itingomi Joreasati. Ariquerao itomi Eroris ógueri. Aro itsorogopëri. Aisati Tosorintsi icamanaasiringaqueri: —Pigamemari Ariquerao. Aro yogaganaca José canta Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Cara yaretaja, itimopë poeboroquë jitacha Nasaret. Aro omoncaraca ora icanque comantantatsiripague jirai: Quirisito Nasaresati. ");
INSERT INTO notNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aro aique iáque Joan baotisatantatsiri cara tera ontimingani cara Joreaquë. Icomantaguetaigapëri imatsiguenga ");
INSERT INTO notNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","icantopiantë: —Pingantaigaima yacaqueroca, pijocajiro ora picantagueti te onganinate, pomasiniatitaje, quero picantaja pibega jirai. Pabentimari Tosorintsi pënibaquenta orequima cara intingomibintaiguëmi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jirai ira Joan isanguenatocoqueri comantantatsiri jitacha Isaías. Icanque Isaías: Ainta ira cajemaquenguitsine cara te ontimingani; inganque: “Coraguetaque Atingomi; págacaninatobëri; pinguemisantasantobëri, piganinatiro paneingomento pibega cara pobetsicoboguitineri irabo itingomi pigatingatineri”. ");
INSERT INTO notNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ora iguitsagare Joan irianti cameyopiti, imatsaguitari imasitsa. Irianti yaagui ira tsiguëriquipague. Aisati itsimiri pitsia. ");
INSERT INTO notNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ipocasitaigapëri tojai Jerosaresati iquemisantaiguëri, aisati omagaro Joreasati, antagaisati ira timaigatsi aronisati nijaaquë jitacha Jorirán. ");
INSERT INTO notNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ainta tojai icampëri: —Aiti nacantaguetiro ora te onganinate. Nocoguini ingábintsena Tosorintsi iragabisaicotajina. Aique ibaotisataiguëri Joan Joriránquë. ");
INSERT INTO notNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aisati iátasitaigabitacari tojai bariseo aisati arosonori saroseo icogabetaigaca imaotisataiguemame, carari iguisatsataigabaqueri Joan icabëri: —Te pinganinataigue, obirojegui aisa picantaigacari marangue. ¿Pairi comantaiguëmi pisigopitanëmaro cara iratsipiriacagaiguëmi Tosorintsi cantaquibi maranguepague cara isigopitaigacaro pamari? ¿Pijitasitaiguemame cara quero itsipiriacaguimiro? ");
INSERT INTO notNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pinintica nomaotisataiguemi, aro caninataque pintimaigue caninasati arota nogótimi pijocasantëroca ora picantagueti te ongomeite pinguemisantasantiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Quero picantaigui: “Naroegui imatsiguenga Abaram. Iroro iniacaninataguëtaiguëna Tosorintsi; quero iguisina”. Pamatobica obiati. Ingoqueca Tosorintsi, imiaguetiro ocaegui mopë imatsiguenga Abaram carari quero pogabisaicotiri iriro, quero iáti Jonocaguitequë irironta jorío imatsiguenga Abaram. Querootisati pabisaicoti obironta imatsiguenga Abaram. ");
INSERT INTO notNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Carari pënibaque inguisaiguëmi Tosorintsi. Picantaigacaro pibega anchato te ine oguitso; iritotëro casintaro, irojoquero tsitsiquë. Aisa picanta obiro te pinguemisantiri Tosorintsi, te pingantineri, irojocaiguëmi Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aroca nogóque ijocajiro matsiguenga ora icantagueti te onganinate, nobaotisatëri nijaaquë. Carari pënibaquenta iribocapë basini sërari, teni aisa ingantina nibega naro. Ibaquina Irironta Natingomisonori, nitsoingaa naronta cantaca iromeraro Iriro. Naro baotisataiguëmi nijaaquë, carari pinguemisanquerica Iriro ogaiguëmirone Caninaro Isëre Tosorintsi inasërequimi. Aisati ingasitígatëri Sharincabeniquë ira tsoengatsi te inguemisantiri. ");
INSERT INTO notNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aroca omposaguiquero antianquero arosa, aique opoteguiquero. Ataquero omasiqui, iroonti oguitso águë oguëro cara ogantaroriquë. Aisati ingantima Atingomi iraniantimari antagaisati matsiguenga. Ingábintsaiguëri ira quemisantaiguërine, irianti cantaguetiro te onganinate irojoqueri tsitsiquë cara te otsibague. ");
INSERT INTO notNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aique iáque Jesos Joriránquë, ipaniaca Garireaquë. Iátasiqueri Joan cara imaotisatobëri. ");
INSERT INTO notNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te iraninte Joan imaotisatobëri, icabëri: —Quero nobaotisatimi. Caninataque pomaotisatina naro Obiati. ¿Pairo picogobiti nomaotisatimi Obironta Natingomisonori? ");
INSERT INTO notNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yotabitanëri Jesos: —Pinintacaguina yamai. Nocogasanti pomaotisatina icocaquinaronta Tosorintsi. Icanque Joan: —Aro nomaotisatëmi. ");
INSERT INTO notNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aro ibaotisatëri nijaaquë. Cara yagatanai Jesos, aique iniobëro Isëre Tosorintsi, opaniaca Jonogaguitequë, pamasobingopë paguëpëri Jesos, ocampari sompaguiti, pinampari. ");
INSERT INTO notNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iriguito iquemaigabaquitiguiri Tosorintsi canta Jonogaguitequë, icanque: —Icari ica Notomi nanintasanotirini. Tojai nacaninabentasantobiqueri. ");
INSERT INTO notNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aique Isëre Tosorintsi páganëri Ira Jesos cara tera ontimingani. Cara, icoque camagari iraniantimari. Icogabeca irantacaquerime Jesos ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cara, itica Jesos 40 cataguiteri, te irapëmate pairoraca. Págasantëri itasegane. ");
INSERT INTO notNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aro iátasiqueri Jesos camagari, iraniantëmari. Icantabepari: —Obirosonorica Itomi Tosorintsi, pomeguiro oca mopëca pan, popero. ");
INSERT INTO notNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yotabitanëri Jesos: —Quero nopeguiro. Ocanti Sanguenari jirai isanguenati comantantatsiri: Te patiro intimantimaro pan matsiguenga, carari intimantëmarotisati Irinibare Tosorintsi cara inguemisanqueroca. ");
INSERT INTO notNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aique yáganëri camagari cara Jerosarénquë. Cara, yoguëri jonoica oquibe pongotsi irasi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aro icantabecari: —Obiroca Itomi Tosorintsi, atsi pomatsecanë osobinta quibatsiquë. Pinguenguero ocanti Sanguenari: Tosorintsi iragáquimiri ironomire irisaanganetsitepague iromisanquemi. Irágaigabaquemi arota quero poparigopë mopëquë. ");
INSERT INTO notNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yotabitanëri Jesos: —Quero picantiri Tosorintsi ora inganque; posamitiri ora icogui inganque. Aisati ocanti Sanguenari: Quero piniantari Pitingomi Iriantinta Pitosorintsite. ");
INSERT INTO notNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aisati yáganëri Jesos camagari jonoquë oquibequë oguitoja. Ijigotëneri omagaro quibatsi, ");
INSERT INTO notNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","icantabecari: —Pinetsaigueri antagaisati timaigatsi quibatsiquë. Aroca pintingominquina naro, pobaticagueritotasiquinaca, aro nomëmiro omagaro, nangantaiguëri antagaisati intaegui cara intingomintaiguëmi iriro. ");
INSERT INTO notNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yotabitanëri Jesos aisati: —Pijáte, jaara, obiro Satanás. Ocantiti Sanguenari negaca: Pintingomintimari paniro Atingomi Irironta Pitosorintsite. Paniro Iriro pomanocoqueri pinguemisanqueri. ");
INSERT INTO notNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aro iátaji camagari ijocanëri. Aique ipocasitaigapëri ironomirepague Tosorintsi irisaanganetsite, imitocotaigapëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cara Jesos iquemocoqueri Joan cara yomianquengani, iáque Jesos cara Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Te intime Nasarequë, carari iáque Caperinaoquë. Caperinao iroonti poeboro onamijaquë oquibe angaare jitacha Garirea. Aisati pini aronisati iguebatsite Saborón aisati irasi Nejatari. ");
INSERT INTO notNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aro omoncaraca ora isanguenatocoque Isaías comantantatsiri jirai cara icanque: ");
INSERT INTO notNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ainta matsiguenga timaigatsi quibatsipaguequë: Saborón aisati Nejatari timatsi onamijaquë angaare jitacha Garirea; aisati aiquero basiniquë angaare oquibeguintesonori; aisa antatinta Jorirán; aisati Garirea canta itimaigui tojai matsiguenga cagarijegui jorío. ");
INSERT INTO notNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jirai icantabetaigacari ibega iraegui timatsi tsitiniriquë tenta irogóigueri Tosorintsi. Iriátaiguëme Sharincabeniquë, carari yamai aisati icantaigari ira timaigatsi cataguiteriquë, aroquenta iquemocotaigabaqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aro iparintaca Jesos iquenguitsatomotaiguëri matsiguenga canta, icantaiguëri: —Pingantaigaima yacaqueroca, pijocajiro ora picantagueti te onganinate, pabentimari Tosorintsi pënibaquenta orequima iragáantane cara intingomibintaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iroontita yanëisigui Jesos cara onamijaquë angaare jitacha Garirea, iniopëri Simón aisati ireinti, Antiris. Simón aisati ijita Peroro. Isiriatasegui simaguitinta ini. ");
INSERT INTO notNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iniopëri Jesos aro icampëri: —Intsome, piguiatanëna. Jirai pitarobacaati pisiriatiri sima carari nomëmi irorai pitarobacaare; pinguemisantacaguinari matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aito cara ijocanëro isiritite, yoguiataiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yogagaiganaca negaqueronta, Jesos iniopëri pite basini, Santiago aisati ireinti, Joan. Iriro pitirooti itomi Sebereo. Yobetsicaigaseguiro irisiriamento cara ibitoquë. Aisati icaimaigapëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aito cara ijocaiganaqueri iriri cara ibitoquë, yoguiataiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iquenagueque Jesos cara Garireaquë; yogomeanti omagaro poeboropaguequë cara yapatoitaiga jorío. Aisati iquenguitsatocotagueantëro iragáantane Tosorintsi cara intingomibintaiguëri matsiguenga. Aisati Jesos yogaguibegajiri tojai janaitatsiripague. ");
INSERT INTO notNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iquemocotaiguëri Jesos omagaro Siriasati. Aro yamaigapëri tojai imatsiguenga janaitaguetatsiri aisati catsibaguetatsiri arota iraguibegajiri. Yamapëri Jesosiquë ira inanca camagari, ira tingaraachari, aisati ira emëngari. Yogaguibegajiri antagaisati. ");
INSERT INTO notNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yoguiataigapëri tojaisonori matsiguenga: Garireasati, Tecaporisisati, Jerosaresati, Joreasati, aisati ira paniacha antatinta Jorirán. ");
INSERT INTO notNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cara Jesos iniaiguëri tojai matsiguenga ira botoibiritaigacari, aro itonganaque oguitojaquë, isobigopë. Ishongaigapari irogomerejegui. ");
INSERT INTO notNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aique yogometaiguëri, icantaiguëri: ");
INSERT INTO notNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Iraganinasëretaiguëri Tosorintsi antagaisati ira cantatsi: “Nantingomintimari Tosorintsi. Nocoguini irojocajinaro ora nacantaguetomotiri quimingari, iragabisaicotajinata tenta nagabisaicotajima naneni”. Aro iragabisaicotajiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Iraganinasëretaiguëri Tosorintsi omagaro ira agasëretaigacha, omagaro ira aragacha. Aro inganinasëretagaiganaqueri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Iraganinasëretaiguëri antagaisati ira te inguengasantima, quero iguisabacaga. Aro Tosorintsi ingábintsasanoiguëri, imëri ora caninaro. ");
INSERT INTO notNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Iraganinasëretaiguëri Tosorintsi omagaro ira cogasantatsi ingante caninasati. Iromitocotaiguëri intime caninasati. ");
INSERT INTO notNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Iraganinasëretaiguëri Tosorintsi antagaisati ira cantaneintëgotiri ira basini. Aisati ingantaneintëgotasantëri irirojegui Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Iraganinasëretaiguëri Tosorintsi omagaro ira quingasëretaigacha caninasati aisati cantatsi caninaro. Aro ironijagaiguëmari iriro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Iraganinasëretaiguëri Tosorintsi antagaisati ira aguimairenqueri quisachari. Aro intomintaiguëmari Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aroca inguisaiguëmi aroquenta picaninataiguë, pinganinasëretaigue. Aro iragasobicaiguëmi Tosorintsi cara igáanti Iriro. ");
INSERT INTO notNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Aisati inganquimica catsimari, irinibatocotimica ora te onganinate, intsoiguëgotimica aroquenta piquemisantaiguëna, pinganinasëretaigue. ");
INSERT INTO notNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jee, pinganinasëretasantaigue: imaiguëmi Tosorintsi ora caninaro cara Jonogaguitequë aisa icanta ipaiguëri comantantatsiri jirai cara iguisaiguëri imatsiguenga. Iroro quero pipëgataguëtari, ingantocoquiminta Tosorintsi caninaro. ");
INSERT INTO notNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Aisati icantaiguëri Jesos: —Pigóiguë obotiatëri ibatsa arota quero isititi. Carari omasangatanëca patiari ora cochotacaguiro, quero ocomeitanai, ojoqueroti sotoquë iranëiro ogatiquengani. Obirojegui posiacaro pibega patiari: poganinataiguiri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Aisati obirojegui picantaro michero yaca quibatsica. Iniaiguëmi matsiguenga ora picantaiguë aisa ocanta iniaiguëro poeboro inatsi oguitojaquë. Quero pimána. ");
INSERT INTO notNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aisati posangueguitetocotaiguëri matsiguenga ora caninaro aisati picantaro michero. Cara poboquerotica, quero pimániro osobica cantiri, carari poguërotica jonoquë arota osangueguitetocotiri omagaro timatsi pongotsiquë. ");
INSERT INTO notNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aisati obirojegui, pintimaigue caninasati arota iraniaiguemi pomatsiguengajegui cara caninasati picantaiga. Aro iraniacaninataiguëri Pabati Ira timatsi Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Përosati yogomeque Jesos: —Teri iroro nopocasite nojocaguimiro cara piquemisantaiguëro isanguenare Moisés aisati isanguenare comantantatsiri. Nipocasique nogometaiguëmiro ora icantasanti. Nomoncaraquero. ");
INSERT INTO notNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Aisonori nangantaiguëmiro oca: otsonguëmaca quibatsi aisati Jonogaguite carari quero pitsonga isanguenare Moisés irooti cara omoncaraquima antagaisati ora icanque. ");
INSERT INTO notNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Queroca piquemisantasantiro isanguenare, aisati aroca pogometiri pomatsiguenga cara quero iquemisantasantiro, quero iniacaninatsantimi Tosorintsi cara iragáantanequë. Carari aroca pinguemisantasantëro omagaro isanguenaque aisati pogometaiguërica pomatsiguenga inguemisantasantiro, aro imëmi Tosorintsi pomitocotaiguëri cara igáanti. ");
INSERT INTO notNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¿Pijitasitaiga Tosorintsi iniacaninataiguëri bariseo aisati ira ogomeantiro Sanguenari? Yamai nongomantaiguëmi, teni iromoncarataiguero ora icocagaigabitari Tosorintsi. Aisati obiro, queroca pabisiri iriro, queroca picaninatasantaigui, quero piáti obiro cara iragáantanequë Tosorintsi cara itingomibintanti. ");
INSERT INTO notNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aisati icanque Jesos: —Pigóiguë icantaiguë jirainisati: “Quero póganti. Aroca póganque, ingasitígatëmi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Carari nongomantaiguëmi Naro: quero piguisaneintiri pomatsiguenga. Aroca pinguisaneinqueri, ingasitígatëmi pitingomi. Aroca pinganqueri: “Te pigóte”, inguisaiguëmi obatacagantatsiripague icarati 71. Quero picantëmatiri pairoraca querota pitsipireiro cara Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Cara pijáqueca ibangoquë Tosorintsi aroca póguëneri pitaquineri pobira cara itagantariquë, carari piquianca aiti ora iguisëgotantimi pomatsiguenga, ");
INSERT INTO notNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","atsi pijocanëri pobira cara, pijátasitiri ira quisëgotimi. Pobetsicobagaima, págacaninatobagaima. Aique popigaima ibangoquë Tosorintsi, póguineri pobira. ");
INSERT INTO notNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aintaca pomatsiguenga irácagantëmi, pobetsicagairi pinguencaguimari. Pingante: “Intsome obetsicobagaima”, queroquerai yáganëmi cara poesitoquë. Aro ira joes iragáqueri soraro: “Páganëri ica”. Aique iromianquemi cara iromingamentoquë. ");
INSERT INTO notNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Aique queroca pipënabentiro antagaisati pirebetiri, quero yomisotocajimi aisati. ");
INSERT INTO notNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Përosati icantaiguëri Jesos: —Pigóiguë icantaiguë jirai: “Quero pintaguetiro tsinane cagaro pijina. Quero pintaguetiri sërari cagari pijime”. ");
INSERT INTO notNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Carari nongomantaiguëmi Naro: pinetseroca tsinane pinebetëmaro, aisati pinguengasëretëro pintëro, aroque pintëro ora te ongomeite. Aroque paguimintimaro pijina. ");
INSERT INTO notNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nosiacagantëmiro: oraca antaquemine piroquisonori ora quimingaro, pijocajiro ora picantagueti te onganinate. Aro pobetsiquiro pisëre aisatime ongantima pinguitsoguirome piroqui, pijoquintirome. Aro quero piáti Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Oraca antaquemine pobacosonori ora te onganinate, pijocajiro ora picantagueti te ongomeite. Aro pobetsiquiro pisëre aisatime ongantima pitotirome pobaco, pijoquintirome. Aro quero piáti Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Aisati ongantingani jirai: “Aroca pingoque pijocajiro pijina, pisanguenatinero pomero ora pijogantaimaro, aro pijoquero”. ");
INSERT INTO notNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Carari nongomantaiguëmi Naro: quero pijoquiro pijina. Aroca pijoquero, aisati págae basini, aroque paguimintëmaro pijinasonori, picantagueti ora te ongomeite. Aisati ira ágairone ora pijoque, aiti irantane ora te onganinate. Aintaca tsinane ojoqueri ojime ágairica basini sërari, aroque ontantopitiri paguimintacari ojimesonori. Iroonti patiro caninataque pijoquiro pijina aroca aguimintëmi, quero basini. ");
INSERT INTO notNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aisati icanë Jesos: —Aisati pigóiguë onganti. Aroca pijoquero, aisati págae basini, aroque paguimintëmaro pijinasonori, picantagueti ngani jirai: “Quero picantasita: ‘Igóque Atingomi nasatironguëro omagaro nacanquimi. Aroca nomatobiquimi, iróguinata’. Aroca pinganque: ‘Igóque nasatironguëro omagaro nacanquimi’, aro pomoncaratima aisonori”. ");
INSERT INTO notNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Carari nongomantaiguëmi Naro: quero picantasitëmata. Quero pinibati: “Aisonorica aiti Jonogaguite, aisa ocanta nanibare, aisonori catingasati nomoncaraquimaro ora nacanquimi”. Nangantaiguëmi Naro: ora Jonogaguite iroonti iragáantomento Tosorintsi. Igóti aisonorica pinibati. ");
INSERT INTO notNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Querootisati pinibati: “Aisonorica aiti quibatsi, aisati aisonori catingasati ora nacanquimi; nomoncaraquimaro”. Carari ora quibatsi iroonti ora yagatiqui Tosorintsi. Igóque pitsoiganica. Querootisati pinibati: “Aisonorica aiti Jerosarén, aisati aisonori nanibatëmi catingasati”. Carari nangantaiguëmi itingomibintaiguëri Atingomi omagaro Jerosaresati. Igóti Iriro aisonorica pinibati. ");
INSERT INTO notNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Querootisati picanti: “Iritoitinata naguisiquë queroca ninibati catingasati”. Nacanquimi te pigóte ati ongantima pingamaque; paniro igóque Tosorintsi. Pintingomintimari Iriro igótinta pitsoiganica. ");
INSERT INTO notNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pinibate catingasati. Quero pitsoiga, querootisati pamatobianti. Caninataque pintëroca pairoraca, pingante: “Jee, nantëro”. Queroca pintiro, pingante: “Quero nantiro”. Aroque. Te onganinate pomitojaiguiro pinibare. ");
INSERT INTO notNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Përosati icanque Jesos: —Pigóiguë ongantingani jirai: “Aroca pinguitsoguëneri iroqui basini, caninataque iripëgaquimi inguitsoguemiro pasi piroqui. Aroca piquëriaitëri pomatsiguenga irai, caninataque iripëgaquimi iriquëriajiquimiro pasi piji”. ");
INSERT INTO notNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Carari nongomantaiguëmi Naro: quero pipëgatari ira quisimi; aroca iranchotangaborotëmica cara poborosonoriquë, popisitaima pomëtiguimari queroca poboro ingapojaboroquemi aisati. ");
INSERT INTO notNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aisati aroca ingoque sërari iráganëmi catingasatiquë joes, ingoque irágopitëmiro pigamisate, pomeri pobasitoro aisati. ");
INSERT INTO notNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aroca iromeratëmi paniro, inganquimi: “Páganënaro oca nasica poro quirometoro”, aro pigabisëneri pite quirometoro. ");
INSERT INTO notNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aroca iromanaquemi pomatsiguenga: “Pomenaro”, aro pomëtiguiri. Aisati aroca inganquimi: “Pomirisitatinaro oca”, aro pomirisitaqueri, quero pometopitari. ");
INSERT INTO notNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Përo icantaiguëri Jesos: —Piquemaiguë cara pomatsiguenga cantaigatsi: “Pingábintseri pomatsiguenga, carari pinguisaneintiri ira quisaneintimi obiro”. ");
INSERT INTO notNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Carari nangantaiguëmi Naro: pinintaigueri omagaro ira quisaneintimi aisati cantasitëgotaguetaiguimi, aisati pomanocotaigueri iraegui cantëgotaguetimi catsimari arota ingábintsaigueri iriro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Cara pingantaiguë negaca, poniagaiguema aisati picantari ibega Tosorintsi, Ira piquemisantaigui, Ira tomintaiguimi. Ainta Iriro canta Jonogaguitequënta, cara yobetsiquiri paba cara yobariaguitetocotaiguineri antagaisati, ira caninari aisati ira te inganinate. Aisati angani, yobariatëneri antagaisati, ira quemisantatsi aisati ira te inguemisante. ");
INSERT INTO notNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aroca pingábintsëri paniro ira cábintsëmi, ¿Pijiqueco iraniacaninatëmi Tosorintsi? ¿Teco aisati ingábintsabacagaiguema ira coigotaiguimi piguireguite, ipagantineri cobeingari cara Iromaquë? ");
INSERT INTO notNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aroca pobetsataigabaquimari paniro pomatsiguenga, ¿Pairo picantaiguë caninari? ¿Teco aisati irobetsatobagaiguema ira cagari jorío, ira te irogóigueri Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pinganinatasanotaiganaque, pingantaiguemari ibega Piri Tosorintsi. Icaninatasanoti Iriro; inintasantaiguëri omagaro matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Aisati icantaiguëri Jesos: —Pigamema. Quero piquemisantomemega arota iraniacaninataiguemi matsiguenga aisonori obiro iroontita pamatobitaigaseguiri. Aroca pomatobitaiguëri negaca, quero iniacaninatimi Pabati Tosorintsi canta Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cara pomasitaiguëmarica pomatsiguenga ira cogatsi pairoraca quero picomantaguetiri basini. Irooti icanque ira quemisantomemegacha. Cara ipirica pairoraca ira coguitiacha, icomantaiguëri antagaisati. Icogui iraniacaninataigueri iriro. Nangantasantaiguëmi oca: iniacaninatabitarica iriro imatsiguenga, quero iniacaninatiri Tosorintsi. Aroque yáguëro iraisati. ");
INSERT INTO notNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Carari cara pomasitaiguëmarica ira cogatsi pairoraca, pomániro. Quero pigótacaguiri basini. ");
INSERT INTO notNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aro quero igóti pomatsiguenga cara pomitocoqueri ira coguitiacha. Carari irogótocoquimi Tosorintsi, imëmiro ora caninari. ");
INSERT INTO notNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Përosati yogomeanti Jesos: —Aisati, cara pomanocotaiguërica Tosorintsi, quero posigari ibega ira quemisantomemegachari. Yamanaigasegui iriro cara yapatoitaiga joríojegui aisati cara abatsiquë arota iraniacaninataigueri imatsiguenga. Aisonori nacantaiguëmi oca: aroque yáguëro iraisati. ");
INSERT INTO notNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Carari cara pomanocotaiguërica Pabati, pinganaque tsomagui, pisitocotanëma, aro pomanocotiri Piri. Iraniaquemi Iriro paniro obiro, iraniacaninatëmi, imëmiro ora caninaro. ");
INSERT INTO notNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aisati cara pomanocotaiguërica, quero pinibatasita aisati picantari ibega ira te irogóigueri Tosorintsi. Inibatasitaiga iriro bero bero bero aronta ijitaigabita inguemaigabaqueri Tosorintsi cara yomitojaiganaquero irinibare. ");
INSERT INTO notNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Quero posigaigari ibega iriro. Igótasanti Tosorintsi antagaisati ora picogaigui cara queroquerai pamaniri. ");
INSERT INTO notNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iroro cara pomanaiguërica Tosorintsi, pomanocotiri cantacha negaca: “Pabati nasiatiegui, ainta Obiro Jonogaguitequë, nocogaigui cara iraniacaninataiguemi omagaro matsiguenga Obironta Natingomisonori. ");
INSERT INTO notNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nocogaigui pigáantasantaiguena yaca quibatsica; aisati nocogaigui nanganque antagaisati ora picocagaiguina. Aisati nocogaigui inganque omagaro matsiguengajegui ora picocagaiguiri aisati ingantaiguëmari iraegui timaigatsi cara Jonogaguitequë icantaigasegui omagaro ora picocagaiguiri. ");
INSERT INTO notNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pomapinintaiguena noperi antagaisati cataguiteri. ");
INSERT INTO notNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aiti nacantomotaguequimi ora te onganinate. Pingábintsasantaiguena, pijocajinaro quero piquengainaro aisa ocanta nojocajineri ora icantaguetomotina matsiguenga ora te onganinate, teni nanguisaneintajiri. ");
INSERT INTO notNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Quero pinintacaguiri camagari cara irantacaguina ora te onganinate. Përosati cara pigáantasantagueti omagaro. Pasintaguitetaro antagaisati. Përosati pitasongantasantagueti Obironta sintsirisonoriguinte. Përosati picobeingaguitetasanti. Aro ocarati, amen”. ");
INSERT INTO notNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aisati icantaiguëri: —Aitosati aroca pijocajineri ira basini ora icantomotaguequimi te onganinate, ingábintsaiguëmi Pabati Tosorintsi Ira timatsi Jonogaguitequë, irojocajimiro aisati ora picantagueti obiro te onganinte, quero iquengaimiro. ");
INSERT INTO notNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Carari queroca pijocajineri pomatsiguenga ora icanquimi te onganinate, querootisati ijocajimiro Atingomi ora picantagueti cagaro caninatatsi. ");
INSERT INTO notNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Përosati yogometaiguëri Jesos: —Cara pititimaca pomanocoqueri Tosorintsi, quero pigótacaguiri basini matsiguenga. Quero aisa picantaigari ibega ira quemisantomemegacha; cara ititopiantaiga iriro, yogasëretomemegaca arota irogóontëmari cara itita, aisati iraniacaninataiguëri matsiguenga. Nacantocotaiguëri oca: aroque yáguëro iraisati. Quero ipiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Carari nacantaiguëmi, cara pititaiguëmaca, caninataque pobetsiquima, pinguibima pibega cara pametaiga. ");
INSERT INTO notNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Aro quero igótocotimi pomatsiguenga cara pitita. Carari irogóquimi Pabati jonoquë, imëmi aisati. ");
INSERT INTO notNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Aisati icantaiguëri Jesos: —Quero pomitojaiguiro ora pasintagueta yaca quibatsica: yaca aiti ora irapë cajiro, aiti basini oraaquima, basini egatanë, aisati ora ingositëmiro cosirinti. Otsonganaquima omagaro. ");
INSERT INTO notNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Carari pingogue iromitojaiguemiro tojai ora pasi përonta cara pinë canta Jonogaguitequë, cara quero yapiro cajiro, quero piraaga, querootisati icositimiro, quero pitsonga. ");
INSERT INTO notNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aitica ora pasintagueta yaca quibatsica, pinguengasëretapinintiroca ora inatsi yaca quibatsica; carari aitica pasi canta Jonogaguitequënta, pinguengasëretapinintirica Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Aiti piroqui ora piniaanta, ora pigóonta. Posiacaro obotagantsi ora poboonta tsitiniriquë, piniantaro. Aroca ocaninatomoquimi, pigóiganaque, ");
INSERT INTO notNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","carari queroca ocaninati, quero pinei, quero pigóti, pitimi tsitiniriquë. Aisa ocanta aroca pinguengasëretapininquero ora te ongomeite, quero pigótiri Tosorintsi, përosati pitimi tsitiniriquë. ");
INSERT INTO notNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Aisati basini icanque Jesos: —Quero picantiro piquemisantiri pite pobatorote. Aisa ocanta aroca pingantineri Tosorintsi omagaro ora icocaquemi quero picantanonta obiati. Aroca pingoque pingantanontima obiati, quero pintineri Tosorintsi. Quero picantiro pite. Aroca pinintasantëri Tosorintsi, quero picogui popobotiri piguireguite. Aisati pinintirica piguireguite, quero piquemisantiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Aisati icanque Jesos: —Yamai nongomantaiguëmi: quero pogasëretocotaro poperi, pomire, piguitsagare, pairorapagueraca. Irironta timaquimine Tosorintsi, ¿Queroco ipaiguimi poperi aisati? ¿Queroco icaaguimi pomanchaqui aisati? ");
INSERT INTO notNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pinetsaigueri tsimiripague, pingueinguema. Teni imanguitanontima, teatisati iráguiro ibanguire iroquero ibangoquë, carari ipagueiguëri Pabati Tosorintsi iraperi antagaisati cataguiteri. Aroca yomisantaiguëri tsimiripague, aisati obirojegui iromisantasantaiguëmi pabisaiguërinta tsimiripague. ");
INSERT INTO notNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aroca pinguengasëretëma, ¿Aroco pomitojaiguëro posarinite? Quero. Pitsipiriasita cara piquengasëreta. ");
INSERT INTO notNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aisati ¿Pairo pogasëretocobiritaro piguitsagare, pairoraca pinguitsagatima? Pinetsaiguero otegapague tobari. Te onguengue. Te onguirique, teatisati ontëmate, ");
INSERT INTO notNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","carari iroro caninarosonori. Jirai itimi Saromón, itingomi joríojegui. Iquitsagata caninasati iguitsagare carari te aisati ingantimaro pibega orapague otega. ");
INSERT INTO notNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tosorintsi aganinatëro otegapague tobari, ora quero ocosamaniti omanapague osiguiricanë, iritaguëro matsiguenga. Cara yoganinatëro otegapague Tosorintsi, ¿Teco iromisantaiguemi obiro aisati; inguitsagataiguëmi? ¿Pairo pitsoingobitaiguëri? ");
INSERT INTO notNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iroro, quero piquengasëretaguëta quero posamita: “¿Pairo nopë? ¿Pairo nóguëma? ¿Pairo nanguitsagaquima?” ");
INSERT INTO notNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aisati icogaiguiro ocapague ira te inguemisante. Quero posigari irirojegui, aroquenta igóquero Pabati Tosorintsi cara Jonogaguitequë ora picogaigui obiro. Iromisanquemi. ");
INSERT INTO notNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pingogue obitsita quemisantasantërine Tosorintsi, pintingomintasantimari, aisati pingogue iraniacaninatimi. Aique imagueiguëmiro ora picoguitiaiga. ");
INSERT INTO notNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iroro, quero piquengasëretaguëta naramani, pairoraca pinganque. Cara orequima naramani, aro pinguenguero. Aiti ora piquengasëreti yamai; te onganinate pigasëretima naramani aisati. ");
INSERT INTO notNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Përosati inibatë Jesos, icanque: —Quero pini joes. Quero picomantëgotiri pomatsiguenga. Aroca pingomantëgotëri: “¡Cara icantagueti iriro ora te onganinate!” aro ingantocoquemi Tosorintsi aisati: “Aiti ora picantagueti obiro”. ");
INSERT INTO notNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aroca pinguisaneinqueri basini, iripëgaquimi obiro inguisaneinquimi aisati. Aisa ocanta pingábintsëri basini, aisati ingábintsëmi obiro. Cara picomantëgotëri basini matsiguenga, aisa inganquima ingomantëgotëmi obiro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aitica picantagueti obiro te ongomeite, quero picantëmatiri pomatsiguenga: “Aiti picantagueti quimingaro”. Nosiacagantëmiro; aitica pairoraca oquibe cara piroquiquë, ¿Caninataqueco piniaquero arosata cara iroquiquë pomatsiguenga? Quero. ");
INSERT INTO notNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Pairo picantobitiri: “Majire pine, nágabitsaquemiroti ora arosata piroquiquë”, carari quero pineiro aitinta oquibe pasi piroquiquë? ");
INSERT INTO notNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tojai picantasita. Obitsita joquërone ora oquibe pasi piroquiquë. Aique piniasantë cara pijocajineri pomatsiguenga ora arosata inaaqueri iroquiquë. Aisati picoguica pingantiri pomatsiguenga irojocajiro ora icantagueti te ongomeite, pobate pijocajiro ora quimingari picantagueti obiro. ");
INSERT INTO notNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Te onganinate pomapinintiri otsiti caninari ibatsa tenta ingarasiatimiri; teatisati onganinate pomapinintiri chancho irapëro caninari mopë catari jitacha périra, queronta icogui yapiro. Iratsicabitëmaro, irojoquero, inguisanaquima, iratsicanëmi. Aisati ocanta ocaninatasanti Irinibare Tosorintsi. Caninataque pinguenguitsatomotaguetiri pomatsiguena, carari aroca inguisaneintocoquemiro tenta iranintaigue inguemisantiro, quero picomantairi aisati. ");
INSERT INTO notNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Aisati icantaiguëri Jesos: —Aroca pomanaqueri Tosorintsi, aro imaiguëmiro. Pomanocotopiantiri, aisa ocanta pingoqueroca pairoraca, aro imaiguëmiro. Aisa ocanta pirequimaca pongotsiquë, pingaimapëri casintaro, “Pisirenaro”, aro irasiriëmiro. Aisati cara përosati pomanocotopiantëri Tosorintsi, imaiguëmiro. ");
INSERT INTO notNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aisonori imaimi Tosorintsi ora pomanocotopiantërira. Aisati cara pingogaiguëca iranetsacaquimiro. Cara pingaimapërica irasitëcoroquë, irasiriëmiro. ");
INSERT INTO notNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aroca iromanaquimi pitomi: “Apati, pomena pan”, querosonori popiri mopë. ");
INSERT INTO notNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aroca iromanaquimi: “Pomena sima najagueni”, quero popiri marangue. ");
INSERT INTO notNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pinetsaigue. Te pinganinatasantaigue obiro, carari pigóiguë pingábintsaiguëri pitomi popabaqueri ora icoguitiaca. Icaninatasanti Tosorintsi, Ira timatsi Jonogaguitequë, igótasanti icábintsaiguëri antagaisati ira manëgotaiguiri. Imaiguëri ora caninaro. ");
INSERT INTO notNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Aisati yogometaiguëri irogomere Jesos, icanque: —Aroca pingogue ingábintsaiguimi matsiguenga, pingábintsaigueri obiro. Pinintica ingantaneintëgotimi iriro, aro pingantaneintëgotiri obiro aisati. Iroro ora isanguenataiguë jirai Moisés aisati omagaro comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Aisati icomantaiguëri matsiguenga Jesos: —Aroca pininti pingapë cara itimi Tosorintsi, pingapë otiomijaniquë omoro. Aiti basini omoro oquibe, aisati basini abatsi oquibe cara te omomirintsite iriáiguë matsiguenga, Carari iraegui quenantaro abatsi oquibe iriáiguë cara Sharincabeniquë, iratsipiriantëquero përosati. ");
INSERT INTO notNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Irari quenantaro otiomijaniquë omoro aisati otiomijani abatsi iraretaiguëma cara Jonogaguitequë. Arosonori quenantaigaro oquibe abatsi, carari arosataanti matsiguenga icaigapë omoroquë otiomijani aisati iquenantaigaro otiomijani abatsi. ");
INSERT INTO notNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Aisati icantaiguëri Jesos: —Pigamemari matobiantatsiri ingomantomemeguëmiro Irinibare Tosorintsi. Ingantabepëmarime ibega oisha; pijitaigabaqueri quero icantimi pairoraca. Carari irianti cantapëmarine ibega secari irianti cobeingarisonori. ");
INSERT INTO notNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pinetsasantaiguero ora icantagueti, ora pigóontëmari icaninatica. ¿Páguëroco oba cara totseisiquë? Teni. ¿Paguëroco igo cara jirinasiquë? Teatisati. Aisati icantaiga matobiantatsiri: tigueti ingantiro caninari. ");
INSERT INTO notNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pigóiguë caninaroca anchato aisati caninaro oguitso. Aisati teca onganinate anchato teatisati ongomeite oguitso. ");
INSERT INTO notNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ora caninaro anchato tigueti ongantima onguimingate oguitso. Aisati ora anchato ora te ongomeite tigueti ongantima onganinate oguitso. ");
INSERT INTO notNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pigóiguëro anchato te onganinate oguitso, otoquero ataquero aisati. ");
INSERT INTO notNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aisati pigóigabaquero ati icantaigapa ira cogatsi irogometimi. Pigóiguë itimica caninasati, aisati irogomepëmiro Irinibare Tosorintsi caninasati. Carari teca intiomotimi caninasati, teatisati irogomeante catingasati. ");
INSERT INTO notNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Aisati icanai basini Jesos: —Aintaca pairiraca cantënane: “Natingomi, Natingomi”, quero iáti cara Jonogaguitequë cara nigáanti Naro. Aintanta inabita inganquina: “Obiro Natingomi, natingomintasantëmi”, carari quero iáti cara nagáantanequë. Irianti játënguitsine Jonogaguitequë iraegui quemisanqueri Pabati aisati icantasantineri ora icocaqueri omagaro. ");
INSERT INTO notNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aiquenta cara nopocaje nongomantëgotaigapëri antagaisati matsiguenga, nanganqueri negaraca iriátë aisati pairoraca inganque. Ainta tojai cantasitënane “Natingomi, nocomantëgotëmi. Aisati nacantaiguëri matsiguenga inancari camagari: ‘Naquemisanquerinta Jesoquirisito Natingomisonori, iroro pijátopitiri ica, pijocanëri’. Aro iátaji, ijocanëri. Aisati nitasonganti Obironta omitocoquena”. ");
INSERT INTO notNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Carari nangantaigapëri: “Teni nogóiguemi. Pijáigue jaanta, tenta pinguemisantasantina. Piquemisantomemegasita. Tojai picantagueigui ora te onganinate. Picantanonta obiati”. ");
INSERT INTO notNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pinetse, aroca pinguemobëro ora nogometaiguëmira pinguianquero, pinguemisanquero ora nococaquimi, pintaiguëro, aro naniacaninataiguëmi. Obiro pingantimari ibega sërari ogótatsiri yobetsiquëro ibango coshobatsariquë. ");
INSERT INTO notNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Opariaque oquibe angani, pipoque jarini omotoncaatapa, ocoguintimatasantapë sintsiri. Carari përosati pini ibango iroronta yobetsiquë coshobatsaroquë. Coshori pongotsi. ");
INSERT INTO notNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Carari teca pinguemobëro ora nogometaiguëmira, te pinguenguero, te pinguemisantiro ora nococaquimi, te pingantiro, aro nangantaiguëmi: obiro ibega sërari te irogóte. Yobetsiquëro ibango cara sibitabatsaroquë. ");
INSERT INTO notNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Opariatapë oquibe angani, pipoque jarini omotoncaatapa, ocoguintimatasantapë sintsiri. Aito cara pitëanë pongotsi catsiguero; páganëro jarini. Itsipiriasicaro ira obetsicabitaro. Aisa onganquima pitsipiriasiquima queroca picantasantiro omagaro ora nococaquimi. ");
INSERT INTO notNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aroque itsonquero Jesos yogometaigabaqueri matsiguenga cara oguitojaquë. Iquenganeintasantaigapëri. Icantobagaiganaca matsiguenga: ");
INSERT INTO notNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","—Tojai igóti Iriro. Teni asi anguemiro cantacha nega. Yogomeanti aisati icantari ibega Atingomi; teni aisati ingantima ira ogomeantiro isanguenare Moisés. ");
INSERT INTO notNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aroqueque icomantanque Jesos cara oguitojaquë, yanongopa. Aro yoguiataiganaqueri arosonori matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aro iátasiqueri poro sërari iribatsasetaga. Yobaticagueritotasipari, yamanopëri: —Natingomi, pinintica piguëtetainaro nobatsagoro. Nigóque picoguica pigaguibegajina. ");
INSERT INTO notNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aro itimagonaguitasitanacari Jesos yotsagaqueri icanqueri: —Nocogui yamai; nagabisaicotajimi. Aito cara opeganaa ora iribatsagoro ibeganaa. ");
INSERT INTO notNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aro igáqueri Jesos, icanqueri: —Quero picomantaguetiri pairiraca, carari pijáte catingasati, poniagapëmari saseriroti, ira nibabintimiri Tosorintsi. Pingantiri: “Nibatsagabeta, carari pinetsena yamai, abisëgotaina”. Aisati pomeri pobira: iróquimiri saseriroti iritaguëneri Tosorintsi cara igáqueri Moisés jirai. Ora irogóontimi cara piquëtetanai. ");
INSERT INTO notNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aro yogaganaca Jesos, aisati ira aguiataiguëri, yaretaigacaro poeboro jitacha Caperinao. Ipocasipëri sërari cagari jorío, irianti Iromasati. Iriro capitán, igátaiguëri 100 soraro. ");
INSERT INTO notNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Icampëri Jesos: —Natingomi, ainta nonamire cara nobangoquë, emëngatëni. Ainta icatsitasantëni. Nocogui pigabisëgotairi. ");
INSERT INTO notNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Icanëri Jesos: —Aro najáque cara, nagaguibegajantiri. ");
INSERT INTO notNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Carari yotabitanëri capitán: —Nigóquimi, Obiro Natingomi caninari; nitsoingaa naati, te nanganinate. Quero piáti nobangoquë. Nigóque aroca patiro pinibate, aro irobegajima. ");
INSERT INTO notNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ainta agátinari, aisati ainta soraro ira nigátaigui naro. Aroca nagáqueri nosorarote: “Pijáte”, aro iriátë. Aroca nanganqueri basini: “Popoque”, aro iribocapë. Aisatica nagáqueri nomeraro: “Pingantiro oca”, aro inganquero. Aisati ocanta pibega Obiro. Omoncaraquima pairoraca pinibati. ");
INSERT INTO notNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aro iquenganeintacari Jesos, icantaiguëri iraegui aguiataiguëri: —Nacantasantaiguimini: tojai iquemisantasanti ica, yabisanaqueri antagaisati joríojegui quemisantatsi. ");
INSERT INTO notNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aiquenta cara igáanti Tosorintsi, iribocaigapë arosonori basiniati matsiguenga paniaigacha omagaroquë quibatsi. Irisobicaigapë intsibataigapëmari nomatsiguengajegui Abaram, aisati Isac, aisati Jacob cara iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Carari quero ipoqui tojai jorío cara tenta inguemisantaigueri Tosorintsi. Icogabeca Iriro iriáigue jorío cara iragáantanequë, carari itsoingaiguëri Iriro jorío. Iroro iragátaguëqueri cara otsitinitasanti. Tojai iratsipiriasantaiguë cara aisati iratsitsiaguitetanë. ");
INSERT INTO notNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aique icanqueri capitán Jesos: —Yamai, pijáte pobangoquë. Aroquenta piquemisanquina noguibegajiri ponamire. Aro irooti ibeganaa ironomire. ");
INSERT INTO notNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cara iáque Jesos ibangoquë Peroro, icanaque iniopëro iraguiro pinariasega osamamentoquë. Ojanaitë ocatsingaeguisigui. ");
INSERT INTO notNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aro yotsagaquero obacoquë, yoguibegajiro. Aito cara ocabiritaja, opëri iraperi. ");
INSERT INTO notNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cara ochapinitanë, iátasitaiguëri, yáganëri tojai matsiguenga ira inanca camagari. Ijocajineri Jesos igamagarite, aisati yogaguibegajiri omagaro janaitaguetatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Icanquero Jesos negaca arota iromoncaraquero ora isanguenatocoqueri jirai comantantatsiri jitacha Isaías: Aiquenta iribocapë Quirisito agabisaicoquerine tojai janaitaguetatsi, tojai ingábintsaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cara yapatobiritaigapari Jesos arosonori matsiguenga, icanqueri irogomere: —Intsome antatinta. ");
INSERT INTO notNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ainta inasegui paniro ogomeantiro isanguenare Moisés, yotsitipari Ira Jesos, icampëri: —Ogomeantatsiri, negaraca pijáque nocoguini naguiatanëmi. ");
INSERT INTO notNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yotabitanëri Jesos: —Aiti imoro somani cara isami, aisati aiti imagosi tsimiripague cara isami, carari te ine nasi nobango cara nanareaquima Naro aronta nopaniaca Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ainta basini irogomere icanqueri: —Natingomi, nocoguini naguiatanëmi, carari pënibaque ingamaque apati. Pinintacaguina natianëri; aique coshoni naguiatanëmi. ");
INSERT INTO notNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yotabitanëri Jesos: —Piguiatina obiro. Ainta tsoengatsiri, ira te inguemisantiri Tosorintsi; iritijairita piri. ");
INSERT INTO notNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aro yotetanaca Jesos pitotsiquë, aisati itsibataiganacari irogomere. ");
INSERT INTO notNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aro inariopa Jesos isamapë. Omanapague coraque pipoque oquibeguinte coguentima, omotoncaatapa, potiatanaca pitotsiquë. Përosati isamasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aro itsorogasantanë irogomerejegui, icabocapëri icanqueri: —¡Natingomi, atsiticoiguëni! ¡Pigabisaicotaiguena! ");
INSERT INTO notNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Icabirica icantaiguëri: —¿Pairo pitsorogobitaiguë? ¿Pairo te pinguemisantobitina? Aique yoguimairentajiro sintsiri coguentima aisati yoguimairenquero angaare aro omairiatasantanai. ");
INSERT INTO notNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Inetsaiguëri Jesos irogomere, iquenganeintasantaiganacari, icantobaca: —¿Ati icanta ica? Inibatë, aro oquemisantasantanëri coguentima aisati angaare. ");
INSERT INTO notNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aro yaretocotaigaca antatinta quibatsiquë jitacha Garara. Cara ainta pite sërari cara itiagani igamaga aroque inantaigacari camagari itonguibocari yotsitipari Jesos. Ira camagari tojai icatsimatacaqueri ira pitirooti sërari. Aro itsorogasantëri imatsiguenga, te inguenaigae cara itiaiguiri igamaga. ");
INSERT INTO notNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Icaimaigapë: —Obiro nigóquimi, Jesos, Obiro Itomi Tosorintsi. ¿Pairo pipocasibiriquina? ¿Naroco pipocasique yamai pitsipiriacagaiguëna? Terai omoncaratima naro cara natsipiriaque canta Sharincabeniquënta. ");
INSERT INTO notNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ainta inaigasegui arosonori chancho yapaisigui. ");
INSERT INTO notNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aro yamanaiguëri Jesos camagari: —Aroca pigabisaicoqueri ica sërarica, pigátaiguena cara chanchoeguiquëra ninampëmari iriro. ");
INSERT INTO notNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesos icantaiguëri: —¡Pijáigue! Aro iáiganaque, inantaigapari ira chanchoegui. Isigaiganaca chancho cara tarangaquë, imatsematseiganaque angaarequë tobotn tobotn tobotn. Itsiticaiganaque ijogataiganaca omagaro chancho. ");
INSERT INTO notNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aro ira omisantiri chancho isigaiganaca cara poeboroquë, icomantagueigapëri imatsiguenga omagaro ora iniaque. Aisati icomantëgotëri sërari ira inantabeca camagari. ");
INSERT INTO notNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aro iátasitaiguëri Jesos tojai Gararasati, icantaigapëri: —Atsi pijáte yamaica. Quero pipocaji yaca aisati. ");
INSERT INTO notNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aro yotetanaca Jesos cara pitotsiquë, iátocoiguë Iriro aisati irogomerejegui cara Caperinaoquë. ");
INSERT INTO notNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yamapëri sërari emëngari te iranëibintsataje, yamëgotantaigacari jatasintsi. Igóque Jesos cara iquemisantaiguëri, icabëri: —Pinganinasërete, nomatsiguenga. Nojocajimiro ora picantagueti te onganinate. Quero iguisëgotaimiro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ainta inasegui irapague ogomeantiro isanguenare Moisés. Icantaneintobaganaca: “Icantocotaguetasitari Tosorintsi Ica”. ");
INSERT INTO notNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Igóque Jesos ora iquenganeintaigaca, icantaiguëri: —¿Pairo picantocobiritaiguëna ora te ongomeite? ");
INSERT INTO notNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aroca nanganque oca: “Yamai noguibegajimi, panëitanae”, ¿Teco pinetsaigabaqueri? Queroca nacantiro, picabíntsátaiguëna. Carari pijitaiguë nacantasita cara nacanqueri: “Nojocajimiro ora picantagueti te onganinate”. ");
INSERT INTO notNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nocogui noniagaiguëmi te nangantasitima. Nopaniaca Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Icanquena Pabati: “Pijocajineri ira cantaguetiro te onganinate; aique quero aguisëgotëtajari ora icantagueti”. Nocogui pigóigue aiti nojocajineri ira cantaguetiro quimingari yaca quibatsica. Aique icanqueri ira emëngari: —Pingabiritima, págairo pijatasi, pijáte pobangoquë. ");
INSERT INTO notNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aro icabiritanaca, iátaji ibangoquë. ");
INSERT INTO notNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Iniaigabaqueri omagaro ira bototaigacha, iquenganeintasantaigaca iniacaninataiguëri Ira Tosorintsi, icantocotaiguëri: —Aisonori icaninatasanti Tosorintsi. Icantocotajiri Ica, cara yogaguibegajiri janaitaguetatsiripague. ");
INSERT INTO notNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aro yogaganaca Jesos cara nisobiqui naro, najita Mateo. Iniopëna cara nocoicotaguetiri nomatsiguenga iguireguite, nomagantairi nogobeingarite canta Iromaquë. Icampëna: —Intsome. Piguiatanëna. Aro nacabiritanaca, noguiatanëri. ");
INSERT INTO notNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aique náganëri cara nobangoquë napaaguëri. Yapaiguë basini nagaimane tojai: irogomere Jesos, aisati ira natsibataiga coigotantatsi iguireguite nomatsiguenga ipagantaiguëri cobeingari Iromaquë, aisati ainta basini ira cantaguetiro te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aro iniaigapëna bariseoegui, yosamitaigapëri irogomere Jesos: —Te ingomeite Ogometimiri. Yapëgotaiguëri coigotantatsiri aisati ira cantaguetaigatsi te onganinate. ¿Pairo icantobica negaca? Icantaguetiro ora te onganinate Iriro. ");
INSERT INTO notNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cara iquemaigabaqueri bariseo Jesos, icanqueri: —Ira cajigatatsi te ingoguiri jompiantatsi, carari ira janaitatsi iriro coguiri. ");
INSERT INTO notNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pijáigue, pinguenguero ora icanti Tosorintsi, jirai isanguenaquero Oseas: Te nongogue póguinari pobira, pitaguinari; iroonti nocogui pingábintseri pitimanamireegui pingantaneintëgotiri. Te iroro nopocasite nangaimaguetiri caninatatsiri, irianti nangaimagueque ira cantaguetiro te onganinate arota ingantaigaima yacaqueroca. ");
INSERT INTO notNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aique ipocasitaiguëri irogomere Joan baotisatantatsiri, yosamitaigapëri Ira Jesos: —Pinetse, nititopianta naroegui aisati bariseo. ¿Pairo te iritibiritaiguema pasi pogomere? ");
INSERT INTO notNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yotabitaigabaqueri Jesos: —Pigóiguë ora ametaiga cara irágantë sërari. Ingaimaiguëri imatsiguenga, irapajaqueri inganinataiganaque omagaro. ¿Pairo te iragasërebiritima igaimane? Carari cara iriátë jaanta ira águërone iina, aro iragasërequima, irititaiguëma. Aisati nacanta Naro, aiquenta najátaje, aro iragasëretocoquina, irititaiguëma nogomere. ");
INSERT INTO notNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aisati pigóiguë cara pigabitëro inaga piguitsagare, páguëro inagasite manchaguintsisite. Aroca pigabitantimaro iroraisite, cara ámanaquima ontisaraanairo oquibe ora inagasite piguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aisati pigóiguë ametaiga eiro oguëro irorai oja oba cara irirai imasiquë oisha. Cara onguëchotanë obaa iritopiganëma imasi, quero paparaata. Quero pairi ogantarone oja oba irinagamasiquë. Igóque cara onguëchotanë oja oba intonganë irinagamasi, oparaatëma obaa. Aisati oca nogometaiguëmi te onganinate ongonaguero ora yametaiga omatsiguenga jirai. ");
INSERT INTO notNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iroontita inibatasegui Jesos, ipocasiqueri itingomi jorío ira omisantiro pongotsi cara yapatotaiga, yobaticagueritotasipari, icampëri: —Yamaica ocamaque nasinto, carari nocogui pijáte cara nobangoquë, potsagatiro piganiatainaro. ");
INSERT INTO notNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aito cara yoguiataiguëri Jesos aisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ainta tsinane piraaseti cosamani ocarati 12 osarini, piátasiqueri Jesos itisitaquë potsagapëri, oquianca: “Aroca notsagaitëri onamiquë iguitsagare, aroje iragaguibegajina”. ");
INSERT INTO notNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aro yapisitanaca Jesos, iniobëro, icabëro: —Pinganinate, nomatsiguenga. Piquemisanquinanta, aroque pibeganaa yamai. Aito cara pibeganaa. ");
INSERT INTO notNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aro iátaji, yaretaigaca ibangoquë itingomi jorío, iniaigapëri arosonori matsiguenga icobëbensiguiro ogamaga irisinto aisati iragaigaca tojai. ");
INSERT INTO notNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aro icantaiguëri Jesos: —Pijáigue. Teni ongame oca piraicotaiguica, pisamini. Icabíntsáigabaqueri Jesos matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cara yomisotocaiguëri iriro Jesos, icanaque tsomagui, yágobagotapëro irisinto itingomi, aro ocabiritanaa. ");
INSERT INTO notNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aique iquemocotaguetaiguëri Jesos antagaisati ira timaguetatsi cara aronisati. ");
INSERT INTO notNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cara yogaganaa Jesos, yoguiataiguëri pite sërari comarajari icaibataigabaqueri icanque: —Obiro imatsiguengasonori David jirainisati, pingantaneintëgotaiguena naro. ");
INSERT INTO notNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Icanaque Jesos pongotsiquë, aisati yoguiataiguëri ira pite comarajari. Yosamitaigabaqueri Jesos: —¿Pijitaiguëna quero naniacagajimi? Yotabitaiganaqueri: —Jee, Natingomi. Nigóiguë naro aro pingantaigainaro piniacagajina caninasati. ");
INSERT INTO notNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aro yotsagaiguëri Jesos iroquiquë. Icantaigabaqueri: —Aro nanganquemi ora pijitobitaiguëna. ");
INSERT INTO notNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aito cara iniasantanai. Aisati icantasantaiguëri Jesos: —Quero picomantiri basinipague: “Iniacagajina Jesos”. ");
INSERT INTO notNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iriro cantënguicha iáiganaque icomantaguetaiganaqueri imatsiguenga icanque: —Iniacagajina Jesos Natingomi. ");
INSERT INTO notNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cara isotocaji pite, yamaigapëri Jesosiquë sërari inancari camagari. Te irinibate. ");
INSERT INTO notNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aro yomisotocajineri igamagarite Jesos inibatagajiri caninasati. Iraegui jorío niaiguëri Jesos iquenganeintasantaigacari icantobagaiganaca: —Jirai te aniaigueri sërari cantacha negaca. ");
INSERT INTO notNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Carari icantaiguë bariseoegui: —Imitocoqueri itingomi camagari; iroro ora igátaguëquineri matsiguenga igamagarite. ");
INSERT INTO notNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aro iquenagueque Jesos omagaro poeboropaguequë. Yogomeantagueque cara yapatotapinintaiga jorío, aisati icomantëgotantaguequero iragáantane Tosorintsi. Aisati yogaguibegajiri tojai janaitatsiripague. ");
INSERT INTO notNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iniaiguëri Jesos arosonori matsiguenga ira botoibiritari icantaneintëgotaiguëri, icanque: —Tojai itsipiriaiguë, ijocaigaca aisati icantaigari ibega oisha ira te irine omisantirine. ");
INSERT INTO notNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aique icanqueri irogomere: —Aisati, icaegui icantaigaro tojai oguitso panguirintsi, carari te irine tojai ira obiguitirone. ");
INSERT INTO notNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pomanocotiri Pitingomi iragátaiguëri tojai comantantatsiri iriáiguë, inguemisantacagaiguëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aique icoigaiguëri Jesos ira irogomere icarati 12. Ipaiguëri itasorintsite ora irojogantaguequimari camagari quimingari. Aisati ipaiguëri iragaguibegajiri iraegui janaitaguetatsi. ");
INSERT INTO notNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ainta irogomere icarati 12. Iritsita Simón aisati ijita Peroro, aisati Antiris ireinti Peroro, aique Santiago itomi Sebereo, aisati Joan ireinti Santiago. ");
INSERT INTO notNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Aique ainta Jeripe aisati Baritoromé; aique Tomás aisati naro najita Mateo ira coigotantatsiri; aique Santiago itomi Arijeo, aisati Tareo; ");
INSERT INTO notNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aique Simón ira nintasantiro ibaísite aisati Joras Cariotisati ira ágagantëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aro igátaiguëri Jesos iraegui irogomere, icantaiguëri: —Quero piáigui basiniatiquë matsiguenga cagari jorío, querootisati piáti cara itimaigui Samariasati. ");
INSERT INTO notNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Caraanti pijáiguë joríojeguiquë ira naniaiguë cantaca oisha te irine omisantaiguërine. ");
INSERT INTO notNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Atiraca pijáiguë pinguenguitsatacaguetiri pomatsiguenga: “Pënibaque orequima cara iragáantëri ira quemisanqueri Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Piguibegajiri ira janaitaguetatsiri, piguëtetairi ira iribatsasetaga, pijocajineri matsiguenga igamagarite. Tojai nacábintsaiguëmi, carari te nongoicotimi. Yamai atsi obirojegui, pingábintsaigueri matsiguenga quero picoicotiri cara pomitocotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Quero páganë piguireguite, ");
INSERT INTO notNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","querootisati páganë pitsaguine, querootisati páganë pite piguitsagare, querootisati pisapatote querootisati pigotiqui. Caninataque imasitaiguëmi poperi ira quemaigabaquemi aisati ora pingogaiguë. ");
INSERT INTO notNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Cara pirequima poeboroquë, pingogopëri quemisantasantatsiri, pintiomotiri iriro irooti cara pigaganëma basiniquë poeboro. ");
INSERT INTO notNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cara pingapë pongotsi, piniacaninatapëri ira timatsi cara, pobetsatapëmari caninasati. ");
INSERT INTO notNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aroca iraniacaninataigabaquemi iriro, pomanocotiri Tosorintsi ingábintseri casintaro pongotsi, carari queroca iniacaninataigabaquemi, quero picantiri Tosorintsi icábintsiri. ");
INSERT INTO notNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Queroca iniacaninatobëmi, querootisati iquemisantobëmi, popotetanaineri pojongabatsari pisapatotequë, aro pigaganëma. Pingantiri: “Tenta pinguemisantobëna, aiquenta iratsipiriacaquemi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aisonori nacantasantaiguëmi: itsipiriaiguëro Soromasati aisati Gomorasati, carari aiquenta cara ingomantëgotaiguëri matsiguenga Tosorintsi iratsipiriacagasantaiguëri iraegui te iraniacaninataigabaquemi. ");
INSERT INTO notNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Përosati icomantaiguëri irogomere Jesos: —Yamai nagátaiguëmi, carari picantari oisha ira nagáque cara cobeingariquë. Tojai iratsipiriacaquemi tsoengatsiri. Pinguengasantaiganaquima, pingante ora caninaro. Quero pitsipiriacaguiri pomatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pigamemari matsiguenga. Irágaiganaquemi catingasati pitingomipaguequë, iratsipiriacagaiguëmi. Aisati irágaiganaquemi matsiguenga cara yapatotaigaca iripasataiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Cara irogóiguëca piquemisanquina, irágaiganaquemi cara itingomipaguequë. Aro pinguenguitsatocoquina pigótacaguinari basiniati matsiguenga cagari jorío ati ongantima nagabisaicotajiri cara inguemisanquena. ");
INSERT INTO notNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Cara irágaiganaquemi quero piquenga quero picanti: “¿Pairoroco nanganqueri?” Irogomeantëmiro Isëre Tosorintsi ora pinganque. Quero pigótasita obirojegui ora pingomantë carari onibataquemi Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aiquenta tojai inguisëgotaiguëna matsiguenga. Paniro irácagantëri ireinti irócagantëri, basini irócagantëri iraisati itomi, aisati basini irócagantaguequeri ira casintaigari. ");
INSERT INTO notNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Piquemisantaiguënanta, inguisaiguëmi matsiguengajegui, carari quero pijoquiro cara piquemisanquina. Aroca përosati pinguemisanquena nagabisaicotaiguëmi nágaiganaquemi cara Jonogaguitequë pintiomotaigapëna. ");
INSERT INTO notNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","—Cara inguisaiguëmica iraegui timatsi patiroquë poeboro, aro pisiganëma, pigaganëma basiniquë poeboro. Aisonori nongomantaiguëmi oca: quero piátagueti omagaroquë poeboro cara itimaiguë joríopague queroquerai nipocaji Naro, Naronta paniënguicha cara Jonogaguitequë, nomatsiguengatapë. ");
INSERT INTO notNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Quero ibatiri ira ogometiri irogomere. Querootisati ibatiri ira meratari iromerataga. ");
INSERT INTO notNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aisati irogomere inganquima ira ogometiri, aisati iromeraro ibega ira meratari. Aro yamai tojai iguisaiguëna omatsiguenga ijitasitaiguëna Naro Berisebó itingomi camagari. Piquemisanquinanta, aisati inguisaiguëmi, irajitasitaiguëmi pairiraca, ");
INSERT INTO notNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","carari quero pitsorogaiguiri. Yamai aiti tojai ora te irogóiguero, carari aiquenta irogóiguë omagaro cara Naro Pitingomi aisati obirojegui nogomere caninari. Aisati irogóiguëro ora icantagueti antagaisati matsiguenga te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yamai patiro nocomantaiguëmi obiro, te irogóiguero tsoengatsiri, carari aiquenta pigótacaqueri. Yamai nimánabecaro, carari aiquenta pingomantasantaiguëri antagaisati oca nacanquimica. ");
INSERT INTO notNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ainta coguënguitsine iróguimi, carari quero pitsorogaiguiri queronta icantimi igátimi cara Sharincabeniquë. Irianti pintsoroque Tosorintsi: ingoqueca Iriro iróguimi aisati iragáquemi Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pinetse, pigóiguë ipimantagani tsimiripague iraagueri matsiguenga, carari teca iranintacaguiri Pabati Tosorintsi quero icami paniro tsimiri. ");
INSERT INTO notNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aisati igótiro atiraca ocarati piguisi, igótasantëro. ");
INSERT INTO notNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pinetse. Tojai pobataiguëri tsimiripague, tojai iquengasëretaiguëmi Tosorintsi. Iroro quero pitsoroguëti. ");
INSERT INTO notNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aroca pinganqueri matsiguenga: “Ira Jesoquirisito Natingomi”, aique cara Jonogaguitequë, nanganqueri Pabati: “Itingominquena iriro, nomatsiguengatacari”. ");
INSERT INTO notNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Carari pinganquerica matsiguenga: “Cagari Jesos Natingomi”, aisati canta Jonogaguitequënta, nanganqueri Pabati: “Tenta intingomintina iriro, iroro te nogótaguëtiri iriro Naro”. ");
INSERT INTO notNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Aisati icanë Jesos: —Quero pijitasita cara nipoque irágacaninatobagaiguëma omagaro matsiguenga. Quero yágacaninatobaga. Nipoque nanganqueri iroonti inguisabacagaiguema. ");
INSERT INTO notNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nipocasique iroonti inguisasëretiri sërari iriri, onguisasëretiro tsinane oniro, onguisasëretiro tsinane aguiro, ");
INSERT INTO notNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","inguisasëretiri sërari imatsiguengasonori. ");
INSERT INTO notNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pigóiguë caninataque pinintaigueri piri aisati piniro, carari caninatasantaque pinintasantina Naro. Queroca pinintasantina Naro, quero naniacaninatimi obiro. Caninataque pinintaiguëri pitomi aisati pisinto, carari caninatasantaque pinintasantina Naro. Queroca pinintasantina Naro, quero naniacaninatimi obiro. ");
INSERT INTO notNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nocogui pingantinaro omagaro ora nongocaquemi irooti cara pingamobiquina. Pinintica piguiatanëna pinguemisantasantina, aro pinatanëro pigorosite, quero picantanonta obiati. Cara inguisatsataiguëmi matsiguenga aroquenta piquemisanquina, queroca popomirintsibentina obiro, quero naniacaninatimi Naro. ");
INSERT INTO notNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aroca pingábintsasantëma obiati yamai, pitsipiriasantanë aiquenta. Carari pinguemisantasantinaca yamai, irooti cara iragamagaiguëmi pomatsiguenga, aiquenta pintiomopëna Jonogaguitequë, pintimasanotapë caninasati. ");
INSERT INTO notNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Antagaisati ira ágacaninataiguëmine obiro, irágacaninatëna Naro aisati. Ira ágacaninatënane Naro, aisati irágacaninatëri Pabati Ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Cara irogóquimica obiro comantëgotëri Tosorintsi, irágacaninataigabaquemi, aro imëri iriro Tosorintsi aisa ocanta imëmi obironta comantantatsiri. Aroca irágacaninatobëmi caninasati obironta caninari, imëri Tosorintsi aisa ocanta imëmi obiro. ");
INSERT INTO notNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aisati cara irogóquimica piquemisanquina, iroro imëgotaguëquimi nija catsingajari, iraniaqueri Tosorintsi imëri aroquenta icábintsabaquemi obiro. Iroro oca yogomequeri irogomere Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aro, cara itsonquero Jesos yogometaiguëri irogomere icarati 12, yogaganaca cara poeboropaguequë. Yogometaguequeri ira timaigatsi cara aisati icomantagueiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aroque yomianquengani Joan cara iromingamentoquë. Yamai cara iquemocoqueri Jesos ora icantagueque, Joan igátaiguëri irogomere: ");
INSERT INTO notNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Pijátasitaigueri Jesos, posamitaigapëri: “¿Obiroco Agabisaicoontatsiri ira noguiaque, basinico naguiaiguë”? ");
INSERT INTO notNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aro yaretaigapari Jesos yosamitaigapëri. Yotabitobëri Jesos: —Popiganajima, pingomantapëri Joan omagaro oca piniaque aisati ora piquemaque. ");
INSERT INTO notNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Pingantiri cara inianai comarajatabetachari, yanëitanai carancaratatsi, ibeganaa iribatsasetaga iquëtetanai; iquemaiganaji maguemitari, icaniatanai camabitachari, iquemisantaigabaquero Caninaro Nibarintsi ira coguitiacha, yogabisaicotaigairi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yoganinasëretaiguëri Tosorintsi iraegui te iritsoenguena, te ingomëtina. ");
INSERT INTO notNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cara ipiganaja irogomere Joan, aique inibatëgotëri Joan Jesos. Yosamitaigabaqueri iraegui botoibiricari; —Cani piátaiguë cara tera ontimingani, piquemisantaiguëri Joan. ¿Pairo piábiritaiguë? Pigóiguërinta iriro caninari sërari, iquemisantasantërinta Tosorintsi. Isintsisëreti. Cagari iriro icantaro choco ora posebati coguentima aiquero yaca aiquero cara. ");
INSERT INTO notNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Pairo piátasitaiguë? ¿Piniaquerico iquitsagaca caninasati? Teni. Pigóiguë cara ira quitsagatacha iguitsagare caninaro sibitaro itimaigui cara ibangoquë itingomi. ");
INSERT INTO notNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pairo piábiritaiguë? ¿Teco pigóiguëri iriro comantanquero Irinibare Tosorintsi? Aisonori ora nangantaiguëmi ibataiguëri basiniegui igomantantatsirite Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Irirori sanguenatëgotënguicha jirai cara ingantocopëna Naro: Icanë Tosorintsi: “Notomi, aiquenta nagáqueri ira obatacaquemine, ingomantaigapëri imatsiguenga: ‘Aique naro coraque Natingomi. Piganinataigueneri paneingomento’ ”. ");
INSERT INTO notNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Nacantasantaiguëmi ora aisonori, ainta tojaisonori comantantatsiri, carari noguibatëri Joan, ira baotisatantatsiri. Irironta ogótasantëri Tosorintsi, ibataiguëri basini matsiguenga. Carari antagaisati imaiguëmari Tosorintsi, intingomintasantaiguëmari, irobatasantaiguëri ira Joan, irogótasantanëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jirai icomantagueque Joan; yamai nocomantaguetaiganaquemi Naro. Iroro pigóontaiganacari Tosorintsi. Yamai icogasantaigui tojai matsiguenga cara iragabisaicotajiri Tosorintsi, inganaque iragáantanequë, intingomintaiguëmari. ");
INSERT INTO notNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Jirai antagaisati comantantatsiri iquenguitsatocotaiguëri Quirisito, aisa icanta Moisés icomantëgotëri. Icantaiguë: “Queroquerai ipoqui Quirisito, irobatacaqueri Erías”. Aique yamai ipoque Joan. Iriro aisati icampari ibega Erías. Pijitaigue cara imoncarapëro Joan Sanguenari. ");
INSERT INTO notNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aitica piguemita ora piquemanta, pinguemisantiro ora nocomantimi. ");
INSERT INTO notNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Aisati icantaiguëri matsiguenga Jesos: —Aisati picantaigari janequipague imaguimpitaigui saatëriquë icanqueri basini: ");
INSERT INTO notNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Natamporatabeca carari te piguiataiguena; nosoncatabitaca carari teatisati piguiatina; nacántatabitaca nogasëretabeca, carari teatisati piragasëretaiguema”. ");
INSERT INTO notNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pinetse, picogaigabitaca ingantaiguërome pomatsiguenga pairoraca picocaqueri. Piniaigabaqueri Joan itica aisati te iróguima piari, aro picantocotaguetasitaigari: “Oo, inancari Joan camagari, iroro ititaguëca”. ");
INSERT INTO notNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aro nopaniaca Naro Jonogaguitequë, nomatsiguengatapë; te natitima, aisati nógacaro piari. Aro picantocoiguëna: “Tojai yapasanti Iriro, aisati Iriro singuitachari, imatsiguengatacari ira coigotantatsi aguireguite aisati itsibataigari ira cantaguetaigatsi ora te onganinate”. Carari igóque Tosorintsi cara icanque Joan caninasati aisati Naro nacanque caninasati antagaisati ora icocaquena; aisati omagaro quemisantina, irogóiguëro caninaro ora icocaquena Pabati. Iroro oca icantaiguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aique icomantëgotaiguëri Jesos ira niaigabitari cara itasonganti carari përosati itsoingaiganaqueri. Icanque: ");
INSERT INTO notNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Tojai pitsipiriaiguë obirojegui, Coraseisati! ¡Tojai pitsipiriaiguë obirojegui, Betsairasati! Tojai piniaigabitëna cara nitasongagueanti, carari te pingantëmatima yacaqueroca, te pinguemisantina. Carari iraniaquiname cara nitasongagueanti Tirosati aisati Sirósati, inguengasëretaiguemame iriro, irojocaiguërome ora icantagueti te onganinate, inguemisantaiguëname, imasiniatiquerome imanchaqui aisati irisobicaiguëme somamoquë arota ironijagaiguemari imatsiguenga cara iragasërequima. ");
INSERT INTO notNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aiquenta, cara ingomantëgotaiguëri Tosorintsi, iratsipiriacagaiguëri ira Tirosati aisati ira Sirósati tojainta te inganinataigue. Carari iratsipiriasantagaiguëmi obirojegui Coraseisati aisati Betsairasati aroquenta piniaigabitobëna cara nitasonganti, carari te pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aisati obirojegui Caperinaosati pijitasitaigabitaca pijáiguë Jonogaguitequë, carari pamatobitaigaca obiati përosatinta pitsoingaiguëna. Iroro pijátaguëque canta osobinta. Iraniaiguërome ira Soromasati omagaro iniaiguëro Caperinaosati, inguengasëretaiguëmame iriro, querome itsongaiguirime jirai Tosorintsi, inëme iboeborote irootime yamai. ");
INSERT INTO notNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aiquenta Tosorintsi iratsipiriacagaiguëri ira Soromasati aisati, carari tojai iratsipiriasanotagaiguëmi obirojegui Caperinaosati. Aroque inibatëri tsoengatsiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aique yamanocoqueri Tosorintsi Jesos, icanqueri: —Pabati, Obiro caninarisonori. Nacarasiaquemi Obironta Itingomi antagaisati Jonogaguitesati aisati omagaro quibatsisati. Ainta cantasitacha: “Nigótasanti naro”, carari pimánopitaiguëri ati picanta Obiro aisati ati ongantima pigabisaicotaiguëri. Irianti pigótacagaiguëri ira quemisanquena ira te inguengasitima igótasantëmi iriro. ");
INSERT INTO notNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Caninataque piganinataiguëri iriro, picoquenta pigótacagaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aroque icanqueri Iriri, aique icantaiguëri imatsiguenga Jesos: —Ira Pabati ipëna omagaro igótacaquina antagaisati. Paniro igótasanotaquina Naronta Itomi; te irogótocotina basini matsiguenga. Teatisati pairi ogótirine Iriro. Paniro nigótiri Naro, Naronta Itomi. Irianti Tosorintsi nigótasantacagaiguëri ira nogometaiguë. ");
INSERT INTO notNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cara pitsipiriaiguëca, aisati cara omomirintsitomoquimi pairoraca, popocasitina Naro, pingomantinaro antagaisati. Aro nangantaneintëgotaiguëmi, nomagoriasëretagaiguëmi arota quero opomirintsitomotaguimi aisati. ");
INSERT INTO notNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pinguemisantina Naro, pingoguiro ora nogomeantane, aro tojai nangábintsaiguëmi nantsibatëmi tenta nanguengasantima Naati. Nanintasantëminta, nomagoriasëretagaiguëmi. Aroca pinguemisanquina aro tojai nangantaneintëgotaiguëmi, nomitocoquemi pabequero pairoraca. ");
INSERT INTO notNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Quero nimeratimi quero nobomirintsitimi, quero natsipiriacaguimi iroonti nomitocotopiantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aro basiniquë sábaro iáiguë Jesos aisati irogomerejegui cara panguirintsisiquë. Itasegaiguë irogomere, yágaiguëro oguitsoterei tirigo yapaiguëro oguitso. ");
INSERT INTO notNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Cara iniaigapëri bariseo, icantaigapëri Ira Jesos: —Pinetseri pogomere. Yamai sábaro iroonti cataguiteri comagoriantague, teni ongomeite yamai irobiguitantimaro. ");
INSERT INTO notNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yotabitobëri Jesos; —¿Teco pinibatapinintiro Sanguenari ora comantëgotaiguëri David aisati ira itsibata cara jirai págaiguëri itasegane? ");
INSERT INTO notNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aro icanaque ibangoquë Tosorintsi, icampëri saseriroti: “Nitasegaiguëni”. Aiti pan ora yobetsiquineri Tosorintsi aique poguëngani catingasatiquë Iriro. Te iranintacagaigueri irapero matsiguengapague; irianti saseriroti paiguiro. Carari icábintsaigabaqueri saseriroti, ipaigabaqueri. Aro yapaigapë David aisati ira itsibata. Yamai te pingante: “Te onganinate irape David”, aro ¿Pairo picantobique yamai: “Te onganinate irape icaegui”? ");
INSERT INTO notNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aisati isanguenaque Moisés: Quero pitarobacaati sábaroquë. Pigóiguë antagaisati sábaroquë iátopianti saseriroti cara ibangoquë Tosorintsi intapinintaiguë, carari te pinguisëgotimari iriro. Piniacaninataiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nacantaiguëmi cara ainta yaca Ira obaquero ibango Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Teco pigóiguero oca Sanguenarica jirai: Icanque Tosorintsi: “Te nongogue póguinari pobira, pitaguinari; iroonti nocogasanti pingantaneintëgotanëri pomatsiguenga”. —Pinguemisanquerome oca icanque Tosorintsi, querome picantocotirime icantagueti te onganinate icaegui nogomere obiguitëro tirigoguitso. ");
INSERT INTO notNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Iroro nocomantëgotaguëquero sábaro pairoraca anganque sábaroquë. ");
INSERT INTO notNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Aro yogaganaca, icaigapëro pongotsi cara yapatotaiga jorío. ");
INSERT INTO notNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ainta sërari camabocori. Aintasati bariseo yosamitobëri Ira Jesos: —¿Caninataqueco piguibegajiri ica camabocorica sábaroquë? Icogaiguë bariseo cara iragaguibegajiri arota ingantocotasiquimari Jesos: “Itarobacaati Jesos sábaroquë, te inganinate tenta inguemisantiro isanguenare Moisés”. ");
INSERT INTO notNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aro yotabitaiguëri Jesos: —Pinetse, aroca sábaroquë imariaque omoroquë poishate, ¿Queroco págairi, pomisotocajiri? Caninataque pingábintsairi. ");
INSERT INTO notNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aroca pingábintsairi oisha sábaroquë, ocaninatasanti angábintsairi matsiguenga sábaroquë. ");
INSERT INTO notNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aique icanqueri ira camabocori: —Pintimagonaguitima pobaco. Aro itimagonaguitanaca, ocaninatanai ibaco pibega basini. ");
INSERT INTO notNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iniaqueri bariseo, iguisaneintaiganaqueri. Iátagueque yosamitobagaigaca: —¿Ati anganqueri Jesos, agamaguëri? ");
INSERT INTO notNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cara igóque Jesos cara icogaiguë iróguiri, yogaganaa yoguiataiganaqueri tojai matsiguenga. Aintasati tojai janaitaguetatsiri ira yogaguibiaguetaji Jesos antagaisati. ");
INSERT INTO notNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aro icantaiguëri: —Quero picomanti: “Yogaguibegajina Jesos”. ");
INSERT INTO notNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cara icanque negaca, imoncaraquero ora icomantëgotëri jirai comantantatsiri jitacha Isaías. Isanguenaquineri Irinibare Tosorintsi cara icanque Iriro: ");
INSERT INTO notNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Pinetseri Quirisito Ira nogoigane inganque antagaisati nococaqueri. Tojai nanintasantiri, tojai naniacaninatëri. Nagáquineri Nasëre coshoni oguëri, omitocoqueri. Ingomantaiguëri basiniati matsiguenga, cagari jorío, ora caninaro aisati ati ongantima ora naganinatantimari omagaro. ");
INSERT INTO notNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Quero ipëgatsataro pairoraca; quero icaimasita; quero iquemacagari matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Quero itsipiriacaguiri agasëretachari ingantaneintëgotëri. Querootisati yamatobitiri ira cogatsi irogótina. Përosati ingábintsantë, irooti cara intingomibintaiguëri antagaisati matsiguenga caninasati. ");
INSERT INTO notNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Irogótocoqueri basiniati matsiguenga cara iragabisaicontë Iriro. Aisati intingomintaigabaquimari Iriro. Iroro oca icantocoqueri Tosorintsi jirai. ");
INSERT INTO notNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aique yamaigapëri Jesos poro sërari inancari camagari; te iranee, teatisati irinibate. Yogaguibegajiri; iniacagajiri aisati inibatagairi. ");
INSERT INTO notNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iquenganeintasantaigacari antagaisati ira niaiguëri. Yosamitobagaigaca: —¿Iriroco Quirisito, imatsiguenga David, Ira oguiaiguë? ");
INSERT INTO notNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Carari yotabitaiganaqueri bariseopague: —Imitocoqueri Berisebó aisati ijita Satanás, itingomi camagarijegui. Iroro ijogantaguëcari camagari Ica. ");
INSERT INTO notNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aro igóque Jesos ora iquengasëretaigaca, yotabitaiganaqueri: —Aroca irógobaguimame matsiguenga timaigatsi quibatsiquë, ¿Queroco ipoguiriobaga? Aisa icanta iraegui timaigatsi poeboroquë; aroca inguisabacagaiguëma quero përosati itimaigui cara. Aisa icanta matsiguenga pongotsiquë; queroca iquengaiga, querootisati itiomotobaga përosati. ");
INSERT INTO notNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tesonori iromitocotina Satanás. Ipëgatina. Pinetse: arome iromitocoquiname Satanás cara nojoqueri jaanta camagari, ¿Queroco itsongabacaga iriati Satanás? ");
INSERT INTO notNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aisati irirome omitocoquinane cara nojoqueri camagari, ¿Iriatisatico camagari omitocotaiguëri pogomere cara ijoqueri camagari iriro? Iriro ogótacagaiguëmi pogomere cara pamatobita obiati. ");
INSERT INTO notNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Carari Iroonti Isëre Tosorintsi omitocoquina cara nojoqueri camagari, ¿Teco iroro pigóontaiguema ainta yaca Tosorintsi, icogabeta iragáante, icogui pintingomintimarime? ");
INSERT INTO notNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Aintaca cogatsi ingositiri sintsiri, ¿Teco iritsita águërine, iraguëshotëqueri? Aique irágopitëri pairorapagueraca queronta ipëgatari casintaro. Querome nagobeiri Satanás, querome nojoquiri camagari. ");
INSERT INTO notNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ira te inguemisantina, iguisaneinquina, irianti iquemisanti Satanás. Aisati ira te iraguiatina, te iromitocotina. ");
INSERT INTO notNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aisati icantaiguëri bariseopague Jesos: —Tosorintsi ingábintsaiguëri antagaisati ira cantaguetiro te onganinate aisati omagaro ira nibataguetasitacha te ongomeite, irojocajineri, quero iguisasëretajiri. Carari quero icábintsiri ira cantëgotaguetasitaro Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nocomantaiguëmi cara nopaniaca Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica, carari ingábintsaiguëri Pabati antagaisati ira nibatocotinane ora te ongomeite. Quero icábintsiri ira cantëgotaguetasitaro Isëre. Quero icábintsiri yamai, querootisati icábintsiri aiquenta. Iroonti iratsipiriacagaiguëri përosati. ");
INSERT INTO notNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Aroca ocaninati anchato, aisati caninaro oguitso; teca onganinate anchato, querootisati ocaninati oguitso. Aroca piniaquero oguitso, ¿Teco pigóte ocaninatica ora anchato? ");
INSERT INTO notNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Obirojegui cantaquibi marangue! Te pingomeitaigue; tigueti ongantima pigóte pinibataigue caninaro inibatinta matsiguenga ora iquengasëretaca. Te onganinate pinguengasëretaiguema, iroro te onganinataguëte ora pinibataigui. ");
INSERT INTO notNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ira caninari sërari iquengasëretapinintiro caninaro, iroro icantaguëtiro ora caninaro. Ira te ingomeite iquengasëretapinintiro ora te onganinate; iroro icantaguëtiro ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aiquenta ingomantëgotaiguëmi Tosorintsi: inguiancagaiguëmiro antagaisati pinibarepague ora pinibatasitaiga yamai. ");
INSERT INTO notNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ocaninatica ora pinibataigui, aro iraniacaninataiguëmi, carari teca onganinate pinibare, inganquemi: “Aiti pinibatagueti te onganinate, tojai pitsipiriaque”. ");
INSERT INTO notNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aique icantaigabitacari bariseopague aisati irapague ogomeantiro Sanguenari: —Ogomeantatsiri, nocogaigui nanetsëmi pitasonguinaro pairoraca arota nogótimi Obiroca Quirisito. ");
INSERT INTO notNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yotabitanëri Jesos: —Te pinganinataigue tojainta pitsoingaiguëri Tosorintsi. Quero nitasongomotaiguimi ora pigóontëname. Aiti ora icanque Jonás: pinguengasëretiro cara yosiguina nibega Naro, aro pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jirai ainta iguibeguinte sima iniguëri ira Jonás omaganiro canianiro. Maba cataguiteri inë isegotoquë aique ijocajiri sotoquë. Aisa nanganquima Naro, nangamaquenica, natiaquima, maba cataguiteri ninë omoroquë quibatsi, aique nangabiritanaima. ");
INSERT INTO notNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aiquenta, cara ingomantëgotaiguëmi Tosorintsi, ingabiritaiguëma Nínebesati ingantocotaiguëmi inganque: “Aiti picantagueiguë obirojegui te onganinate. Jirai naquemisantaigabaqueri ira Jonás nopasiniatica nojocaigairo ora te onganinate, nacantaigaa yacaqueroca. Obirojegui, piniaigabaqueri Agabisaicoontatsiri, tojai ibaqueri ira Jonás Irironta Atingomi, carari te pinguemisantaigabaqueri. Inguisasantaiguëmi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aisati jirai ainta tsinane itingomi omatsiguenga, Sebasati. Cara opaniaca parigoti, oquemocoqueri Saromón cara tojai igóque iriro, aro piátasiqueri jaanta oniopëri oquemisampëri. Yamai aintana Naro obirojeguiquë, nobaqueri Saromón carari te pinguemisantaiguena. Aiquenta, cara Tosorintsi ingomantëgotaiguëri antagaisati matsiguenga, ongabiritanaima ora tsinane Sebasato ongantocotaiguëmi: “Picantasantaguetaiguëro obirojegui te onganinate cara ipocasitaiguëmi Ira Agabisaicoontatsiri, carari te pinguemisantaigabaqueri Iriro. Inguisasantaiguëmi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Obirojegui jorío picantaigari ibega sërari inancari camagari quimingari. Ijocajiri camagari sërari, yogabisaicotaja iriati. Iátagueque igamagarite cara piriaguiteroquë quibatsi. Icogabeca iromagoriaque, carari tigueti iromagoriaque. ");
INSERT INTO notNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aique iquianca; “Nopiganajima nobangoquë, cara sërariquë cara nopaniaca”. Ira sërari icantaro ibango camagari. Aro ipiganaja iniopëro ositaga otarogaga obetsicaga irisobicomento irisomaminto, antagaisati. ");
INSERT INTO notNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aro iátasitaiguëri basini camagari quimingarisonori icarati 7. Icampëri: “Intsome antime nobangoquë”. Aro yagobiaiguëri icasëretaigapëri sërari. Jirai itsipiriaque sërari arosata; yamai inantasantacari camagari. Yogatsitasantaca. Aisa picantaiga obirojegui. Jirai pitsipiriaigabitaca tenta pigóigue. Yamai piniabetobëna carari te pinguemisantina. Iroro pigatsitaguëtaiguëma, pitsipiriasanoiguë. ");
INSERT INTO notNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iroontita iquenguitsati Jesos, icomantaguetaiguëri ira botoibiritaigapari cara pongotsiquë, aro pipocasiqueri iniro Jesos, aisati ireintiegui. Ainta sotoquë, ocaimagantaigapëri. ");
INSERT INTO notNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Icomantëqueri Ira Jesos: —Parepa piniro, aisati pirentijegui. Ainta sotoquë; ocoguini onibatimi. ");
INSERT INTO notNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yotabitanëri Jesos: —¿Pairoroco inato? ¿Pairiroco igueegui? ");
INSERT INTO notNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aro ijigotaiguëri irogomere, icanqueri: —Icaegui nogomere, irianti igueegui, aisati iroontiegui inato. ");
INSERT INTO notNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pairiraca cantatsi ora icocaqueri Tosorintsi Ira timatsi Jonogaguitequë, irianti nomatsiguengasonori: najitaiguëri igue, aisati tsio, aisati inato. ");
INSERT INTO notNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Irooti cataguiteri isotocaji Jesos cara pongotsiquë, iáque cara onamijaquë angaare, isobiaque. ");
INSERT INTO notNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yoguiataiganaqueri irogomere, aisati yapatoibiritaigapari tojai matsiguenga. Iniaquero Jesos pitotsi otsatocotaga; aro yotetanacaro isobiaque. Iraegui matsiguenga përo cara inaiguë onamijaquë. ");
INSERT INTO notNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aro tojai yosiacagantaguecaro quingabaguirentsipague. Icanque: —Iáque panguitatsiri imiongaguitaguequero oguitsopague tirigo iritoganequë. ");
INSERT INTO notNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Opariguitagarantapë arosata oguitso abatsiquë; aique ipogopë tsimiripague, yapapëro oguitso. ");
INSERT INTO notNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Basini oguitso opariguitagarantapë mopësiquë cara te ine tojai quibatsi aropirigasata arosonorinta mopë osobibatsaquë. Omanaanti piabitanaca; ");
INSERT INTO notNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","cara ijonogatapë paba yogasiguiricapëro tenta ine oparipague; aro ocamaguetanai. ");
INSERT INTO notNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aisati basini opariguitapë cara totseisiquë; aro piabitanaca carari pomatobairo totsei, te ine oguitso tirigo. ");
INSERT INTO notNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Basini opariguitagueque cara caninabatsariquë quibatsi, iroro caninatënguitsi. Pianë piquibianë caninasati pinanë oguitsopague. Aiti panguirintsi oguitsotanë ocarati 100, aisati basini ocarati 60, aisati basini ocarati 30 oguitso. ");
INSERT INTO notNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aitica piguemita ora piquemanta, pinguemisantiro ora nacantaiguëmira. ");
INSERT INTO notNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aique yosamitaigapëri irogomere: —¿Pairo pogomebiriantaigari quingabaguirentsi ira basinipague? Te inguemaiguemi ora picantaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yotabitanëri Jesos: —Nocogui pigóigue ati icanta Tosorintsi cara igáanti, carari ira matsiguengapague te nongogue irogóigue irirojegui. ");
INSERT INTO notNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aintaca igótabeca, aro nogótacagasantëri. Carari basinipague, te ingogue inguemisantina, quero iquemaiguina. Quero nogometiri iriro catingasati. Aisati nágabitsaqueri nobegopitëri ora igótabeca. ");
INSERT INTO notNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iroro nogomeantaguëcari quingabaguirentsi nosiacagantineri tenta iraninte irogóigue. Inetsabetaiga carari te iranee, iquemaigabitaca carari te ingueme, te irogótaigabaquero ora nacantaigabitacari. ");
INSERT INTO notNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jirai isanguenaque Isaías comantantatsiri, isanguenatocotaiguëri icaegui matsiguengaca: Icanque Tosorintsi: “Pinguemaigabitëmaro Nanibare, carari quero pigótobëro; pinetsabequima ora noniaguëmira carari quero piniasantaiguiro. ");
INSERT INTO notNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Te pinintaigue pigóigue aisatime pinganquima te ine pisëre; iroro quero piquengasëretaguëta. Tenta pinintaigue pinguemiro, iroro oshabitaguëpëmi piguemita, quero pigóigui. Querootisati piniasanti tenta pinintiro. Queronta pipocasitina, quero nogabisaicotajimi”. —Ocari oca icomantëgotaiguëri jorío jirai. ");
INSERT INTO notNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Carari obiro nogomere piniasantaiguiro ora noniagaiguëmira, piquemisantaiguina, iroro yoganinasëretaguëtaiguëmi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nangantaiguëmiro ora aisonori: icogaigabitaca jirai comantantatsirijegui aisati caninatatsiri iraniaiguërome oca piniaqueca obiro. Icogaigabitaca inguemirome oca piquemaiguëca yamai, carari te iraneina teatisati inguemaiguena. ");
INSERT INTO notNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Aisati icantaiguëri Jesos: —Yamai noniagaiguëmiro quingabaguirentsi irasi panguitatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nocomantëgotëro iragáantane Tosorintsi. Ainta quemaigabitacaro, carari te inguemobëro. Aro ipoque camagari yágabitsaqueri nanibare ora iquengaigabitaca. Iriro aisati icantaro pibega oguitso pariaquenguitsi abatsiquë. ");
INSERT INTO notNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Ainta basini tojai iquemabetobacaro ora nogometiri, icaninabentabecaro, carari cara inguisaneintocoqueri imatsiguenga, te përo cara inguemisantiro nanibare, opomirintsitomotanacari, ijocajiro yomaguisantajiro ora iquemisantabeca tenta irogótasantiro. Aisati icantaro oguitso pariaquenguitsi mopësiquë. ");
INSERT INTO notNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ainta basini tojai iquematsatabecaro nogomeantane, carari iquengasantiro pairoraca inaguetatsi yaca quibatsica, aisati inintasantiro ora yasinta. Iroro te inguemisantaguëtina. Iriro cantaca oguitso pariaquenguitsi totseisiquë ora te onintacaguiro ontojaigue, te ine oguitso. ");
INSERT INTO notNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aintasati basini matsiguenga arosatapague iquemisantasantobëro ora nogometiri. Përosati iquemisanquina, icanque antagaisati nococaqueri. Icantaro pibega oguitso pariaquenguitsi caninabatsaroquë quibatsi, ora tojaiganaquenguitsi. Aiti openguiterei ora inënguitsi oguitso 100, aiti basini cara pinë 60, aisati basini cara ocarati 30 oguitso. Ocari oca yoniagantaro Jesos quingabaguirentsi irasi panguitatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aisati yogomeanti Jesos basiniquë quingabaguirentsi. Icanque: —Nosiacagantaiguëmiro basini. Cara igáanti Tosorintsi ocantari ibega sërari panguitiro caninaro tirigoguitso. ");
INSERT INTO notNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aro tsitiniriquë isamë iriro aisati iratirite. Cara isamaiguë, ipocasiqueri basini quisaneintirira ira panguitatsiri, ipanguitaguequineri irootiquë iritogane oguitso tirigoniro ora cantabitaro tirigo. Aique iátaji. ");
INSERT INTO notNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aiquenta, cara oquibianë tirigo, onguitsotanë, aique ongonijatanë tirigoniro. ");
INSERT INTO notNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aro iniaiguëro iratirite casintaro tirigo, iátasitaiguëri, yosamitëri: “¿Teco caninaquiro tirigoguitso cara pitoganequë? ¿Nega opaniaca ora tirigonirora?” ");
INSERT INTO notNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yotabitaiguëri: “Irianti panguiquinaro ira quisaneintina”. Aique yosamitaiguëri iromeraro: “¿Pairoroco picogui nangantaigue? ¿Caninataqueco nasiajiro?” ");
INSERT INTO notNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Icanque: “Quero yamai. Aiquenta. Aroca pisiajiro yamai pisiajatiguiro tirigo aisati. ");
INSERT INTO notNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ineta yamai. Ongantimata. Aiquenta, cara osamabinguique, nagátaiguëmi: ‘Irotsita picarataguetaje tirigoniro, piguëshotiro páganëro pitaguiro. Aique pobibinguitobëro tirigosonori, poguinaroti cara pongotsiquë’ ”. Iroro yosiacagantaiguineri irogomere Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aiti basini quingabaguirentsi yosiacagantëneri matsiguenga Jesos: —Aisati cara iragáantanequë Tosorintsi ocantaro pibega oguitso mositasa ora ipanguitë sërari cara togantsiquë. ");
INSERT INTO notNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ora mositasaguitso iroonti quiripiquiserosonori, carari oquibianë obaquero basini panguirintsi. Ipocaigapë tsimiripague, yogapëro imagosi otsegopaguequë. ");
INSERT INTO notNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aisati basini, iquenguitsataiguëri Jesos: —Cara itingomibintanti Tosorintsi aisati ocantaro ora piponganta pan. Cara obetsiquëro pan tsinane, águëro tojai opane tirigo, oconaguëro arosata piponganta pan. Aique oponganë antagaisati. ");
INSERT INTO notNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yameca Jesos yogomeantaigari quingabaguirentsi ira botoibiritaigapari. Iroonti quingabaguirentsi inibatantari. ");
INSERT INTO notNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Imoncaracaro Sanguenari cara isanguenaque comantantatsiri: Icanque Tosorintsi: “Tojai nosiacagantëneri matsiguengajegui nongomantaiguëri ora te irogóigue jirai cara nobetsiquëro quibatsi jiraisonori, irooti yamaica”. ");
INSERT INTO notNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aique ijocaiganaqueri Jesos ira botoibiritaigacari, icanaque pongotsiquë cara yosamitaigapëri irogomere: —Nocogaiguë pingomantinaro pairo ocanti ora tirigoniro ora piquenguitsatomotaiguëna. ");
INSERT INTO notNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yotabitanëri Jesos: —Nopaniaca Naro cara Jonogaguitequë, nomatsiguengatapë yaca quibatsica. Naro nosiacari ira panguitiro tirigoguitso. ");
INSERT INTO notNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ora togantsi ocancaro quibatsi cara atimaigui eiro. Ora oguitso caninaro ocantaigari ibegaiga ira quemisanqueri Tosorintsi. Ora tirigoniro osigari ira quemisanqueri camagari. ");
INSERT INTO notNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ira quisaneinqueri panguitatsiri, irianti icantari Satanás. Cara yobiguitanti aisati ocantaro cara otsonquema quibatsi cara nopocaje Naro. Iraegui obiguitatsi irianti ironomire Tosorintsi irisaanganetsite. ");
INSERT INTO notNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pinguenguema. Yapatotaiguëro tirigoniro, itagaiguëro. Aisa ocanta nanganque aiquenta cara otsonquimaca quibatsi. ");
INSERT INTO notNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nagátaiguëri tojai ironomire Tosorintsi, irapatotaiguëri cara nagáantanequë antagaisati cantaguetatsi ora te onganinate aisati basini ira cantacaqueri quimingari. ");
INSERT INTO notNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nojocagantaiguëri cara pamariquë Sharincabeniquë; tojai iratsipiriaiguë canta, tojai iratsitsiaguitetanë. ");
INSERT INTO notNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aique irosangueguitetaiguë antagaisati caninataigatsiri inganquimari ibega paba. Intsibataiguëmari Pabati cara igáanti Jonogaguitequë. Aitica piguemita ora piquemanta, caninataque pinguemisantiro oca nocomantëmica. ");
INSERT INTO notNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Përosati yogomeque Jesos: —Cara igáanti Tosorintsi aisati ocantari ibega tojai quirequi irománaga quibatsiquë. Iniasipari sërari, aito cara iquiaque imánanontanaari iriro aisati, te ingomantëgotiri. Aro iáque, ipimantaguequero omagaro ora yasinta, yamanantë quibatsi cara inasegui quirequi. Yamai icaninabenqueri tojai quirequi. ");
INSERT INTO notNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aisati iragáantane Tosorintsi ocantari sërari manantiri imapënequi shaota caninarisonori ira jitacha périra. ");
INSERT INTO notNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iniopëri paniro, icaninatasanti ipënatasantaca. Inintasantiri, iroro ipimantaguëquero antagaisati ora yasinta, yamanantëri ira imapënequi shaota. ");
INSERT INTO notNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Aisati yoniagaiguëri matsiguenga Jesos. Icanque: —Aisati cara itingomibintanti Tosorintsi ocantaro pibega irisiriamento sërari yágantari sima. Ijocaiguëro angaarequë, inosiquëgotëri yobiriatëgotëri tojai simapague. ");
INSERT INTO notNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Iacaro, aro inosiquëgotaiguëri irisiriamentoquë cara onamijaquë, isobicaiguë, yágaguetaiguëri simapague caninari yoguëri cantiriquë. Ira te inganinate ijoguequeri. ");
INSERT INTO notNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aisa ocanta cara otsonquima quibatsi cara nopocaje Naro. Nagáqueri ironomire Tosorintsi irisaanganetsite ingasiriconiatitaiguëri antagaisati matsiguenga caninataguetatsiri. Aique aisati ingasiriconiatiqueri ira te inganinataigue, ");
INSERT INTO notNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","irojocaiguëri cara Sharincabeniquë cara përosati iratsipiriaiguë aisati iratsitsiaguitetanë. ");
INSERT INTO notNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","¿Piquemaiguëro oca nocomantaiguëmica? Yotabitaiguëri irogomere: —Jee, naquemaiguëro. ");
INSERT INTO notNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aisati icanque Jesos: —Aroca inguemisanquena ira ogomeantiro Sanguenari, irogótanëro tojai. Igóquero ora isanguenatagueque jirai, aisati inguemisanquenaca, irogóque ora nogomeanti Naro yamai. Irogóque ogomeantatsiri ati ocanta cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Itsonque Jesos cara yogomeantaro quingabaguirentsi, aique iáiguë Iriro aisati irogomere, ");
INSERT INTO notNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ipiganaja quibatsiquë cara ipaniaca. Icanaque pongotsiquë cara yapatoitaiga jorío, yogomeantapë. Iquenganeintasantaigabacari ira quemaigabaqueri. Yosaminatobaganaca: —¿Ati icanta cara yogomeanti? ¿Nega opaniaca ora igóque Iriro? ¿Pairo itasongantagueta? ");
INSERT INTO notNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Cagarico Ica, itomi José obetsicaguetatsi mesa, sobicomentotsi? ¿Irorori iniro María? Aisati igóiguëri eiro ireintiegui: Santiago, aisati José, aisati Simón, aisati Joras. ");
INSERT INTO notNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Teco aisati ontime iritsiro eiroeguica? ¿Negaraca opaniaca ora igóque aisati ora icanque? ");
INSERT INTO notNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aro iguisaneintaiguëri, itsoingaiguëri. Iroro icantaguëtaiguëri Jesos: —Ainta quemisantaiguëri quinguitsatiro Irinibare Tosorintsi ira paniacha parigotiquë, carari itsoingaiguëri imatsiguengasonori comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te tojai iritosongaguete Jesos cara Nasarequë. Tojainta itsoingaiguëri imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aique iquemocoqueri Jesos Eroris, itingomi Garireasati. ");
INSERT INTO notNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Icantaiguëri iromeraroegui: —Ira Jesos, iriantijengari Joan baotisatantatsiri. Nógagantabitacari, carari najique icabiritaja aisati, iroro itasongantaguëque. ");
INSERT INTO notNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Aroqueque Eroris yágabitsaqueri iina ireinti jitacha Jeripe; iina ojita Erorías. Icantabecari Joan: —Te ongomeite págabitsatiri iina pirenti. Iroro yágagantaguëqueri Joan Eroris yomianqueri yoguëshotiaqueri sogatsaquë coshotsari. ");
INSERT INTO notNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Icogabeca Eroris iróguirime ira Joan, carari itsorogaiguëri matsiguengajegui. Igóiguë matsiguenga cara Joan icomantëgotëri Tosorintsi. Ijique Eroris: “Aroca nógagantëri, inguisëgotaiguëmari matsiguengajegui”. ");
INSERT INTO notNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aique pareca cataguiteri isantone Eroris. Icaimaguetaiguëri tojai imatsiguenga, yoganinasëretaigapëri. Aro omaninquebintëri osinto Erorías. ");
INSERT INTO notNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iniacaninatobëronta ora tsinane ira Eroris, aro icanquero negaca: —Pairoraca pomanaquina, aro nomëmiro. Igóque Tosorintsi cara quero namatobitimi. ");
INSERT INTO notNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aro ocomantatsaquero oniro, ocantacaquero negaca: —Nocoguini pógagantiri ira Joan baotisatantatsiri, aique pomapënaro ora iguito cara tsibetaquë aique nomëro inato cara ogóque aisonorica icamaque. ");
INSERT INTO notNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yogasëreca itingomi cara icantasanotëro, aisati cara iquemaiguëri antagaisati igaimane ora icantasanotëro irisintotsari. ");
INSERT INTO notNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aro igáqueri soraro irobatëaquintiri Joan cara iromingamentoquë. ");
INSERT INTO notNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aique yamapënero tsibetaquë iguito Joan, ipëro irisintotsari. Iroroque përo oniro. ");
INSERT INTO notNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ira irogomere Joan ipocaiguë, yágaiganaqueri cara iritijaigairi. Aique iáiguë, icomantaigapëri Ira Jesos: —Yogamaguëri Joan Eroris. ");
INSERT INTO notNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cara iquemaque Jesos aroque icamaque Joan, iátacagaiguëri irogomerejegui canta tenta ontimengani. Yotetanaca pitotsi. Aisati cara iquemocotaigabaqueri matsiguengajegui ijocaiganaquero iboeborotepague yoguiataiganaqueri cara onamijaquë. ");
INSERT INTO notNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cara yagatocotaigapë Jesos, iniaigapëri tojai matsiguenga ira aguiaigaseguiri. Tojai icantaneintëgotaigapëri yoguibegaigairi janaitaguetatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aro ochapinitanë cara ipocasitaigapëri irogomere, icantabetaigaari: —Yaca teca ontimingani, aisati aroque ochapinitanë. Yamai pigátaigueri icaegui matsiguengaca iriáiganaque poeboropaguequë iromananteta iraperi. ");
INSERT INTO notNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Icantaiguëri irogomere Jesos: —¿Pairo iratsipiriobitaiguë iriáigae? Pomaigueri obirojegui ora irapaiguë. ");
INSERT INTO notNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yotabitanëri: —Teri ine yaca ora nomaiguëri. Yaca aiti oca pan ocarati pabocorooti aisati pitenianti sima. Quero cotonguiboro. ");
INSERT INTO notNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Icanque Jesos: —Pomenaro yaca. ");
INSERT INTO notNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aique yogasobicaiguëri iraegui matsiguenga cara tobarisiquë. Aique yáguëro Jesos ora pan aisati sima. Inetsanaque jonoquë, icanqueri Iriri: —Pabati, nacarasiatocoquemiro oca noperijeguica popaiguënaca. Aro itibatsaaguequero pan Jesos, yotsatengaiguëri irogomere cara imaiguëri matsiguengajegui ira aguiataiguërira. Aisati yotsatengaigacari sima. ");
INSERT INTO notNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yapaiguë antagaisati, iquemaigaca. Aique yobiitaguetajiro irogomere ora irangarataneegui, iagajiro 12 cantiri. ");
INSERT INTO notNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tojai yapaiguë sërari icarati 5,000, aisati tsinanejegui, aisati ojaniquitejegui. ");
INSERT INTO notNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aique icantaiguëri Jesos: —Nogomere, potetaiguema pitotsiquë, pobataigue antatinta. Aique igátaiguëri ira botoibiritaigari: —Yamai pijáigue pobangojeguiquë. ");
INSERT INTO notNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aro itonganaque Jesos oguitojaquë cara yamanaque, inibatëri Iriri. Ainta Jesos paniro inë cara otsitinitanë. ");
INSERT INTO notNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ora pitotsi aroqueque pinë aganguijaquë, icomatabitacaro irogomerejegui. Te iraretima iroontita omotoncaatasantapa nija aisati poguipigapigatocoqueri coguentima. ");
INSERT INTO notNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cara igogaraaque iáque Jesos aiquero pitotsiquë, yanëiaapë jonoicaa angaare, te iritsitigue. ");
INSERT INTO notNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iniaigabaqueri irogomere, te irogóigueri, itsorogasantaiganaque, icaibaitanë icantobaca: —¡Eeee! ¡Coraque camagari cara iráganacái! ");
INSERT INTO notNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Carari yotabitaigapëri Jesos: —Quero pitsorogaigui. Naanti bocapaatsi, pinganinasëretëgotina. ");
INSERT INTO notNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aro icabëri Peroro: —Obiroca Natingomi, pingaimina najáque nanëiatanë jonoicaa nija irooti cara pinasegui Obiro. ");
INSERT INTO notNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yotabitanëri Jesos: —Omana popogopë. Aro yaguëtanë Peroro, yanëiatanë jonoicaati nija iáque aique cara inasequi Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pënibaque irarequimari cara iniaquero nija omotoncaatapa itsoroganë, iparintanaca itsitiganë. Icaibatanëri: —¡Natingomi, págobaina! ");
INSERT INTO notNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aito cara yacotasitobairi Jesos, yágobagotobairi ira Peroro, icanqueri: —Arosata piquemisanquina, ¿Pairo pitsoingobiquina? ");
INSERT INTO notNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aro yotetaigaaro pitotsi Jesos aisati Peroro. Aro osantocotanai coguentima. ");
INSERT INTO notNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aito cara iraegui inasegatsi pitotsiquë yobaticagueritotasitaiganacari icantaigabaqueri: —Aisonori, Obiro Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aro imontiaiganaja, yaretaigapaa Jenesarequë. ");
INSERT INTO notNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ainta timaigatsi cara, igótobëri Ira Jesos, icomantëgotaiguëri, yotsatengaiguëri imatsiguengajegui. Aro yamapëneri tojai janaitaguetatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yamanocopëri cara iranintacaqueri irotsagataigapëri ogarasiquë iguitsagare. Aro yogaguibegaigairi omagaro ira otsagaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aique iátasitaiguëri Ira Jesos bariseopague aisati ira ogomeantiro isanguenare Moisés. Ipaniaigaca Jerosarénquë. Yosamitaigapëri: ");
INSERT INTO notNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Eiroegui jorío. Ametaiga queroquerai api, anguibocoquima. Iroro yogometaigái omatsiguenga jirai. ¿Pairo te ingantobitaigue negaca pogomerejegui? Yapasitaiga te inguibocotima. Yoguimingataca iriati. ");
INSERT INTO notNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yotabitaiguëri Jesos: —Tojai pomoncaratasitaigaro ora icantasitagueta omatsiguenga jirai, iroro te pinguemisantaguëtiro ora yogometaiguëmi Tosorintsi. ¿Pairo picantobitaiga obirojegui negaca? ");
INSERT INTO notNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Icanque Tosorintsi: Pinguemisantiri piri aisati piniro. Aisati icanque: Ingameta ira cantëgotaguetasitari iriri aisati iniro. ");
INSERT INTO notNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Carari obirojegui, pogometaiguëri pomatsiguenga: “Pingantiri ira casintimi: ‘Quero nomitocotimi. Nomëmime quirequi, nangantaneintëgotëmime carari aroque nacanqueri Tosorintsi nomëri Iriro naguireguite’ ”. ");
INSERT INTO notNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pogometaiguë quero picábintsairi piri. Cara picanque negaca, te pogometiri Irinibare Tosorintsi, teatisati pinguemisantiro. ");
INSERT INTO notNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Picantasitaigabita piquemisantasitabeta. Aisonori icomantëgotaiguëmi ira comantantatsiri Isaías cara isanguenaque jirai: ");
INSERT INTO notNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Icanque Tosorintsi: “Ica matsiguengaca inibatasitëgotina ora caninaro, carari te inguenganeintina. ");
INSERT INTO notNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yamanocotasitina cara yapatotasitaiga; iroonti yogometa irinibare matsiguenga”. ");
INSERT INTO notNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aique Jesos icaimaiguëri ira botoibiritaigari, icantaiguëri: —“Pinguemina, pigóiguero oca nocomantaiguëmica: ");
INSERT INTO notNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ora apaiguë, te oguimingatiro asëre. Iroonti ora inibatasitagueta iroro aguimingasëretacái cara aquianquero quimingaro. ");
INSERT INTO notNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aique iátasiqueri Jesos irogomere, icomantaigapëri: —¿Teco pigóte iguisaneintobitaiguëmiro bariseoegui ora picanqueri? ");
INSERT INTO notNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yotabitaiganaqueri Jesos: —Iriro icantaigaro pibega panguirintsi. Aiquenta irisiabonguitiquëro Pabati jonoquënintaberi antagaisati ora te imanguitiro Iriro. ");
INSERT INTO notNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aro irinaigueta bariseoegui, te irogóigue; aisati icancari sërari comarajari ingatsatobaganëmaca ira basini comarajari. Pitirooti imarigaiganaque omoroquë. ");
INSERT INTO notNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Icanqueri Jesos Peroro: —Teni nanguemimi; pingomantina ora ocanti oca picanquinaca. ");
INSERT INTO notNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Icanqueri Jesos: —¿Teraiquerai pigóte? ");
INSERT INTO notNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Teco pigóte pairoraca opë ojáque asegotoquë aique agabisairo? Te ongantiro pairoraca asërequë. ");
INSERT INTO notNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Cara pinibati pairoraca piquengasëreti; queroca piquenga caninasati, quero picaninasëreti, pinibati ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ora piquenga opaniaca paneingomentoquë: cara piquenganeintaguetiro te ongomeite, cara póganti, cara pintaguetiro tsinane cagaro pijina, aisa cara tsinane ontaguetiri sërari cagari ojime, cara picositanti, cara pitsoiguëgotantagueta, cara picantocotaguetasitari pomatsiguenga, omagaro oca paniacha paneingomentoquë. ");
INSERT INTO notNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Omagaro oca aguimingasëretimi. Iroro te pinganinataguëtaigue, carari aroca popë queroquerai piquibocota querootisati poguimingasëretimi. ");
INSERT INTO notNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Aique iáiguë Jesos aisati irogomerejegui cara Tiroquë aisati Sirónquë. ");
INSERT INTO notNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Piátasiqueri Cananasato, cagaro jorío. Ocampëri: —Natingomi, Obiro imatsiguenga David itingomi jorío jirai. Nocoguini pingábintsena naro aisati nasinto. Inancaro camagari, yogatsitasantëro. ");
INSERT INTO notNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Carari te irotopitiro, imairetanë. Aro icantaiguëri irogomere: —Pingantiro ojátaje, tojainta poguiatacái paserigacái. ");
INSERT INTO notNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Icanquero tsinane Jesos: —Igáquina Pabati nangábintsaigueri joríojegui. Icantaigari ibega oisha ibiaga. ");
INSERT INTO notNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aro pobaticagueritobiripari, ocanqueri: —¡Natingomi, pomitocotina! ");
INSERT INTO notNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yotabitobëro Jesos: —Te onganinate irágopitiri janequi iraperi imaigueri otsiti. Cagarimi obiro jorío. ¿Pairo nomitocobiriquimi? ");
INSERT INTO notNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Potabitanëri: —Aisonori, Natingomi, ora picanque, carari yapiro otsiti opetoqui ora pariaguetatsi imesanequë casintari. ");
INSERT INTO notNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aique icanquero: —Tsinane, caninataque piquemisanquina. Yamai aroque nopabaquemiro ora pamanocoquina. Irooti pabisaicoontanaa osinto. ");
INSERT INTO notNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aro yogagaiganaca Jesos aisati irogomerejegui irooti onamijaquë angaare jitacha Garirea. Aique itongaiganaque, isobicaigapë. ");
INSERT INTO notNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ipocasitaigapëri tojai matsiguenga, yágaiganaquineri tojai janaitaguetatsiri: ainta carancaratatsi, ainta comarajari, ainta ira patebocotatsi, ainta ira te irinibate, aisati tojai basini. Yobaticagueritotaguëpari. Aro Jesos yogaguibegajiri omagaro. ");
INSERT INTO notNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aro iquenganeintasantaigacari matsiguengajegui ira niaiguëri Ira Jesos cara inibatagajiri ira te irinibate, yosebatagaari ira emëngari, yanëitagairi carancaratatsiri, iniacagajiri comarajari. Icantaiguë matsiguenga: —Caninari Tosorintsi, Ira iquemisantaiguë joríojegui. ");
INSERT INTO notNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aique icaimaiguëri irogomere Jesos, icantaiguëri: —Tojai nacantaneintëgotaiguëri antagaisati ira botoibiritaiguëna. Ocarati maba cataguiteri itsibataiguëna, yamai te inae iraperi. Itasegasantaiguë. Yamai aroca nagátaigairi iriáigae, iromagotasantanë queronta yapi, quero yaretaiga ibangopaguequë. ");
INSERT INTO notNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yotabitaiganaqueri irogomere: —Pinetse, yaca teca ontimingani. ¿Nega nágaiguëneri pan ora irapaiguë? Tojaisonorinta matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yosamitëri Jesos: —¿Ati ocarati pan inatsi? Yotabitanëri irogomere: —Ocarati 7, aisati ainta arosataanti sibai. ");
INSERT INTO notNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aro icantaiguëri matsiguenga Jesos: —Pisobicaigue quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aro yáguëro pan aisati sibai, icanqueri Iriri: —Aro nega, Pabati, nacarasiaquemi popabaquinaro oca perintsica. Aique itibatsaaguequero, yotsatengaiguëri irogomerejegui arota cara irotsatianquimaro ira botoitaigacha. ");
INSERT INTO notNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yapaiguë antagaisati, iquemaigaca. Aique yobiitaguetajiro ongarataga, iagajiro cantiri oquibe ocarati 7. ");
INSERT INTO notNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yapaiguë tojai sërari icarati 4,000. Aisati papaiguë tojai tsinane aisati janequi. ");
INSERT INTO notNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aique igátaiganaqueri Jesos, icanqueri: —Yamai pijáigae pobangopaguequë. Aique yotetaiganaja Jesos aisati irogomere pitotsiquë, imontiaiganaca irooti Magararaquë. ");
INSERT INTO notNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aique iátasitaiguëri bariseopague aisati saroseopague; icogaigabitapa iraniantimari Jesos irantacaquerime ora te onganinate. Icantabepari: —Atsi yamai nocogaiguini nanetsemi cara pitasonganti, ora nogóontëmi aroca popaniaca Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yotabitaigabaqueri Jesos: —Pinetsaigue, aroca ochapinitanë piniaquero onguiraaguitetë, ¿Teco pingantaiguë: “Quero oparigui angani”? ");
INSERT INTO notNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aisati cara onguëtaguetanë, piniaqueroca onguiraaguetamanë jonoquë, aisati aitica mingori tsitaro, pingantaiguë: “Yamai omariaque angani”. Pigóiguë ati ocanta jonoquë, omariaqueca angani, carari te pigóigue omoncaraca tojai Sanguenari ora ocanti iribocapë Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Te pinganinataigue tojainta pitsoingaiguëri Tosorintsi. Picogabeca pineina cara natasonganque, carari quero noniaguimiro. Patiro piniaquero aiquenta nanganquimari ibega Jonás. Aique iáque, ijocaiganaqueri ira bariseo aisati saroseo. ");
INSERT INTO notNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aro yaretocotaigaa antatinta Jesos aisati irogomere. Aique irogomere iquengaiguëro pan; yomaguisanquero te iromapëro. ");
INSERT INTO notNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aro icantaiguëri Jesos: —Pigamaiguemaro ora piponganta pan irasi bariseoegui aisati irasi saroseoegui. ");
INSERT INTO notNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aique yosamitobagaigaca irogomere: —¿Pairo icantobicái: “Pigamema ora piponganta pan irasi bariseo”? Tentajengari nomapëro pan. ");
INSERT INTO notNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Igóque Jesos ora iquengaigaca, icantaiguëri: —¿Pairo pijibiritaiguë nacantocoquemiro pan? Patiro arosataanti piquemisantaiguëna. ");
INSERT INTO notNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Terai pigóigue? Cani ocarati pabocorooti pan, carari napaagaiguëri 5,000 sërari. Págaigairo pobiitaguetajiro ora ongarataga. ¿Ati ocarati cantiri pinë? Yotabitanëri: —Ocarati 12. ");
INSERT INTO notNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","—Aisati ocarati 7 pan, aisati nopaguetaiguëri pan sërari icarati 4,000. ¿Ati ocarati pobiitaguetaji cantiriquë oquibe? —Ocarati 7. ");
INSERT INTO notNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Icanque Jesos: —¿Pairo te pigóigue? Te nangueincotiro pan ora peguënguichane cara nacanquemi: “Pigamema ora piponganta pan irasi bariseo aisati saroseo”. ");
INSERT INTO notNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aique igóiguë irogomere te ingantocotiro aisonori ora piponganta pan, iroonti ocantaro pibega irogomeantane bariseoegui aisati irasi saroseoegui. ");
INSERT INTO notNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aique iáiganaque Jesos aisati irogomere cara poeboroquë jitacha Sesárea, ora yobetsiquë Jeripo. Aro yosamitaiguëri irogomere Jesos: —Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë, carari, ¿Pairiraca ijitaiguëna matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yotabitaiguëri: —Aintapague ijitaiguë Obiro Joan baotisatantatsiri. Ainta basini ijitaiguëmi: “Ira Jesos Irianti Erías, ipocaji”. Ainta basini ijiquemi Obiro Jeremías. Aintasati icanque Obiro comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aro yosamitaiguëri: —¿Pairo pijitaiguëna obirojegui? ");
INSERT INTO notNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yotabitanëri Simón aisati ijita Peroro: —Obiro Quirisito Agabisaicoontatsiri ira noguiaiguë. Aisati Obiro Itomi Tosorintsi caniatacagantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Icanqueri Jesos: —Aisonori picanti, Simón itomi Jonás. Te irogometimiro matsiguenga; Irianti oniaguëmiro Pabati cara Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Najitimi Peroro ora popairo ocanti mopë. Nococaquemi pinguemisantacagaiguëri basini matsiguenga tojai cara Naro Itomi Tosorintsi. Irapatoibiritaiguëna. Nangábintsaiguëri querota yagobeiri camagari, querootisati yobiacaguiri cara iquemisanquina. ");
INSERT INTO notNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nomëmiro pinguemisantacaguiri matsiguenga aisa ocanta pisirecoquineri sitëcori arota ingasitapëri Tosorintsi cara igáanti. Queroca iquemisantimi matsiguenga yaca quibatsica, pingantiri cara quero iáti Jonogaguitequë. Aisati inganque Tosorintsi: “Aisonori picanqueri. Tenta inguemisantina, quero nomaguisantineri ora icantagueti te onganinate”. Carari antagaisati ira quemisanquero Irinibare Tosorintsi yaca quibatsica, pingantiri cara iriátë jonoquë cara përosati intiomoqueri Tosorintsi. Aro përosati inguenguemi Tosorintsi, inganque: “Aisonori. Nojocajineri ira quemisanquina ora icantagueti te onganinate, nomaguisantajineri”. ");
INSERT INTO notNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aique Jesos icantaiguëri irogomere: —Quero picomantiri matsiguenga: “Iriro Jesos Irianti Quirisito”. ");
INSERT INTO notNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aique icomantaiguëri irogomere Jesos: —Coraque cataguiteri cara najáque Jerosarénquë. Canta, tojai iratsipiriacagaiguëna ira antiasipari aisati itingomiegui saseriroti aisati ira ogomeantiro isanguenare Moisés. Aisati irógaiguëna, carari ongaraque maba cataguiteri, aro nanganiatanae aisati. ");
INSERT INTO notNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aro yáganëri Peroro casiriconiati, ipëgatsacari: —Natingomi, te onganinate oca picanqueca. Nocoguini quero itsipiriacaguimi, querota picami. ");
INSERT INTO notNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aro yapisitasitanacari Peroro Jesos, icantasanotëri: —Pijáte, picanquina aisati picantari ibega Satanás. Quero pintaguinaro ora te onganinate. Te pigóte ora icocaquina Tosorintsi, iroonti pigóque ora icogui matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aique Jesos icantaiguëri irogomere: —Iranintasantëca pairiraca aguiatanëna inguemisantasantina, iranatanëro igorosite, quero icantanonta iriati, iroonti imomirintsibenquinaro pairoraca nongocaqueri Naro. Aroca iratsipiriacaqueri basini, përosati inguemisantanëna Naro. ");
INSERT INTO notNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ira cogabitacha ingábintsëma yaca quibatsica, tenta iraninte iratsipiriero, aiquenta iratsipiriasantë. Irari quemisantasantënane yaca quibatsica, irooti cara ingamobiquina Naro, aiquenta intiomoquina Jonogaguitequë, intimasantanë caninasati. ");
INSERT INTO notNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aintaca sërari irasintaguetimaro antagaisati ora inatsi yaca quibatsica, cara ingamaque iriátë Sharincabeniquë, ¿Pairo iráque? ¿Teco iratsipiriasiquimaro omagaro? Aroca iriátë Sharincabeniquë, tiguetisonori ingantima iriátë Jonogaguitequë, inganiatanae. ");
INSERT INTO notNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nopaniaca cara Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Aiquenta nopigaima aisati yaca quibatsica, nongobeingatasantapë aisati icanta Pabati icobeingatasanti; intsibataigapëna ironomirepague Pabati irisaanganetsite, aro nongomantëgotaiguëri antagaisati matsiguenga. Nomaiguëri omagaro icanquero ora nococagaiguëri; irianti ira quero iquemisantaiguina, natsipiriacaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aisonori nacantasantaiguëmi, nogomerejegui, aintapague obiroquë ira queroquerai icami iraniaigabajina cara nopocaje Naronta Itingomisonori; noniagaiguëmiro nosangueguitere. ");
INSERT INTO notNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aro pabisanaque 6 cataguiteri cara Jesos itonganaque oquibequë oguitoja. Yágaiganaqueri casiriconiati ira Peroro aisati Santiago aisati Joan ireinti Santiago. ");
INSERT INTO notNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aro ipasiniatitomopëri Jesos. Yosangueborotapë aisati icampari ibega paba. Aisati oquëtatasanotanë iguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aisati iconijatomopëri Moisés aisati Erías, inibatobagobaca Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aro icanqueri Jesos Peroro: —¡Natingomi, caninataque ninaigue yaca! Pinintiroca, nobetsiquëmiro yaca maba pongotsi otiomijani, patiro pasi, aisati basini irasi Moisés, aisati irasi Erías. ");
INSERT INTO notNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iroontita inibatasegui Peroro, paguëtaguëpëri mingori poganguibotaigapëri posangueguitetocopëri. Aro iquemaigabaquero Irinibare Tosorintsi cara mingoriquë, icanque: —Iriro nanintasanti Notomi Ica. Tojai nacaninatasantobiqueri. Pinguemisantaigueri Iriro. ");
INSERT INTO notNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iquemaigabaquero oca irogomere, aro ipariaque yaquitomotaiganaca itsorogasantanë. ");
INSERT INTO notNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ipocasitaiguëri Jesos. Yotsagataiguëri icanqueri: —Pingabiritima, quero pitsorogaigui. ");
INSERT INTO notNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aro icabiritanaa icogabetajari Moisés aisati Erías, te irinaje, Irianti panibani inasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aique cara yanongaiganaca, igáqueri irogomere Jesos icanqueri: —Quero picomanti oca piniaiguëca. Aiquenta cara nangamaque aisati nanganiatanae, aro pingomantaigueri basini matsiguenga. Pingomantëgotina Naro omagaro ora pigótocoquina aisati cara nopaniaca Jonogaguitequë aisati nomatsiguengatapë. ");
INSERT INTO notNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aique yosamitaiguëri irogomere: —Ira ogomeantiro Sanguenari cantatsi: “Iribocapae iritsita Erías cara queroquerai ipoqui Quirisito Ira Agabisaicoontatsi”. ¿Pairo yogomebiriqueri oca? ¿Pairo te iribocobipë Erías? ");
INSERT INTO notNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yotabitaiganaqueri Jesos: —Aisonori icantaiguë: “Ingonijapae Erías, irobetsicaguepë omagaro”. ");
INSERT INTO notNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yamai nocomantaiguëmi cara aroque ipocaji Erías carari te irogótaigabaqueri matsiguenga; tojai itsipiriacagaigabaqueri. Aisati nanganquima Naro, tojai iratsipiriacagaiguëna. ");
INSERT INTO notNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aique igóiguë irogomere cara Jesos inibatëgotëri Joan baotisatantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aro cara yanongopaa osobi, ainta arosonori matsiguenga yapatotaiga. Aro ipocasipëri Jesos sërari, yobaticagueritotaguëpari, icampëri: ");
INSERT INTO notNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Natingomi, pingantaneintëgotinari notomi; tojai itingaraacani, tojai itsipiriaque. Iparigopiantë tsitsiquë irisacanëma; aisati iparigatapininque nijaaquë. ");
INSERT INTO notNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namabitapari yaca pogomerequëca nacantabepari: “Pigaguibegajiri notomi”, carari tigueti ingantiri iragabiairi iragabisaicotajiri. ");
INSERT INTO notNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yotabitanëri Jesos: —¡Te pigóiguero Irinibare Tosorintsi! ¡Terai pinguemisantaiguero obirojegui, terai pinganinataigue! ¿Ati ongantima nantsibataiguëmi nogometasitaiguëmi carari te pigóigue tojainta pitsoingaiguëna? Aique icanqueri casintari janequi: —Atsi pomapënari pitomi. ");
INSERT INTO notNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aro Jesos iguisatsatëri ira camagari, ijoqueri, yogaguibegajiri ira janequi. ");
INSERT INTO notNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aique yosamitaiguëri Jesos irogomere casiriconiati: —¿Pairo te nagabiobitiri nagátiri ira camagari? ");
INSERT INTO notNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Icantaiguëri Jesos: —Teni pigabeiri tenta pinguemisantasantina. Arosataanti piquemisantaiguëri Tosorintsi. Aisonori nacantasantaiguëmi: aroca piquemisantaiguëri pinganqueroca ora oguitoja, “Ogaganëmata canta”, aro ogaganëma. Aisa ocanta mositasaguitso otiomijanisonori oquibianë, aisa ocanta cara pinguemisantaiganaque. Pinguemisantasantaiguëca, pinganqueroca pairoraca nongocaquemi. ");
INSERT INTO notNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Carari pinintica pijoguiri camagari cantacha ica, patiro pingantiro aroca pomanocotasantëri Tosorintsi aisati aroca pititima. ");
INSERT INTO notNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iroontita yanëitaiganaque cara Garireaquë, Jesos icantaiguëri irogomerejegui: —Nopaniaca Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Carari irácagantaiguëna matsiguenga, ");
INSERT INTO notNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","irógaiguëna. Ongaraque maba cataguiteri aro nanganiatanae. Iquemaiguëro irogomere oca nibarintsica, aro yogasëretaiganaca. ");
INSERT INTO notNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aique iáiguë Caperinaoquë Jesos aisati irogomere. Cara ainta ira coigotëri quirequi irobetsicantaguetimaro ibango Tosorintsi. Ipocasiqueri ira Peroro, yosamitapëri: —¿Iripënabentapininquerinico Ira ogometimiri iguireguite arota iraganinatiro ibango Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Icanqueri Peroro: —Jee, iripënabentiri. Cara ipiganaja Peroro cara pongotsiquë, yosamitëri Jesos: —Simón, ¿Pairo piquianca? Irapague itingomi, ¿Pairo icoicotopianti iguireguite? ¿Icoicoquerico imatsiguengasonori? Teca, ¿Iriantico icoicoqueri basiniati matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yotabitanëri Peroro: —Icoicotaiguëri basiniati matsiguenga. Aro icanque Jesos: —Aisonori, te ingoicotiri imatsiguengasonori. Aisa nacanta Naro, te ingoicotina Pabati aroquenta nomatsiguengatacari. ");
INSERT INTO notNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Carari te naninte inguisaneintina ira coigotantatsi quirequi. Yamai pijáte angaarequë, pimate sima. Ira iritsita páguë, pintiguiranguiri, piniaqueri poro quirequi. Páganëri, pomeri ira coigotantatsi quirequi, popënabentina Naro aisati popënabentima obiro. ");
INSERT INTO notNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aique irogomerejegui Jesos iátasitaiguëri, yosamitaiguëri: —Cara igáanti Tosorintsi, ¿Pairi obaquenguitsine? ");
INSERT INTO notNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aro icaimëri janequi Jesos, yogobëri aganguisati, ");
INSERT INTO notNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","icanque: —Aisonori nongomantëmiro oca: pinguengasërete basiniati, pingantiro yacaqueroca. Queroca aisati pincanta ibega janequi, quero pareta cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Teni inguenguema iriati caninari ica janequica. Pairiraca cantëmarine ibega ica janequica iriro obaquenguitsine cara iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pairiraca ágacaninatëri ira cantari janequi iquemisanquinanta, aisati yágacaninatëna Naro. ");
INSERT INTO notNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pairiraca antaquerine janequi quemisanquina ora te onganinate, natsipiriacaqueri. Caninataqueme ingamaque queroquerai intaguiri ora te onganinate, aisa onganquimame iragaguibeintsatsatëgotëneri oquibe mopë itsonoquë, irojoquerime angaarequë ingamaque. ");
INSERT INTO notNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aiti tojai ora quimingari yaca quibatsica, aisati ainta tojai intaqueri basini ora te onganinate, carari iratsipiriasantëro ira antaquerira. ");
INSERT INTO notNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aisati icanque Jesos: —Yamai nosiacagantëmiro. Aroca ontaquimi pobaco ora te onganinate, pijocajiro ora picantagueti quimingari. Aro pobetsiquiro pisëre aisatime ongantima pitotirome pobaco pijoquerome. Aisati piguiti ontaquemiroca te onganinate. Caninataque pinë paboconirobi queroca paguitinirobi cara Jonogaguitequë, arota quero piáti Sharincabeniquë cara pini tsitsi ora te otsibacanete. ");
INSERT INTO notNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aroca ontaquimiro piroqui ora te onganinate, pijocajiro ora quimingari. Pobetsiquiro pisëre aisatime ongantima páguirome pijoquerome piroqui. Caninataque pijáte paoquinirobi cara Jonogaguitequë, querota piátacaguiro pitirooti piroqui cara Sharincabeniquë cara te otsibacanete tsitsi aisati pitsipiriasantë përosati. ");
INSERT INTO notNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Aitosati icanque Jesos: —Aisati, quero pitsoinguiri janequijegui, aintanta ironomire Pabati jonoquë yomisantaiguëri janequi, aisati icomantëgobentaiguiri. ");
INSERT INTO notNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nopaniaca Jonogaguitequë, nomatsiguengatapë. Nipocasiqueri nagabisaicotaigairi ira játaiguënguitsineme Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Aisati icantaiguëri irogomere Jesos: —Nosiacagantëmiro aisati. Aroca ini casintari 100 iroishate, imiaquimaca poro, ¿Queroco ijocaiganaqueri 99 cara tongagariquë, iriátasitëri ingogajantiri iroishate ira peguënquicha poro? ");
INSERT INTO notNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cara iraniajirica, inganinabenqueri iroishate aroquenta iniajiri, pabisëro cara icaninabentaiguiri iraegui te imeguima. ");
INSERT INTO notNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aisa icanta Pabati, te iraninte iriáte Sharincabeniquë paniro janequi. ");
INSERT INTO notNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Aisati icantaiguëri Jesos: —Aroca pigasërequima ingantaguetomoquiminta popiguemisantane ora te onganinate, pijátasitiri casiriconiati pingantiri. Quero picomantiri basini. Aroca inguemisantobëmi, intimaque caninasati, caninataque, págacaninatobagajima aisati. ");
INSERT INTO notNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Queroca iquemisantimi, pijátasitajiri aisati páganëri basini popiguemisantane, paniro queroca pite. Intsibataiguëmi irogóontimarota pairoraca pinganqueri, aisati ingampëri iriro cara inguengasëretaquimari irapiguemisantane. ");
INSERT INTO notNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Queroca iquemisantaigabaquemi, pingomantëgotiri cara yapatotaiga quemisantatsirijegui. Aisati ingamanaaiguëri. Queroca iquemisantaiguiri antagaisati irapiguemisantane, aro pingueincotaigueri ibega tsoengatsiri aroque icantagueque te onganinate. Quero pijitiri quemisantatsiri. Irianti cantacha coigotantatsi quirequi ipagantineri cobeingari Iromasati. ");
INSERT INTO notNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Pairoraca pingantaiguëri yaca quibatsica, irootisati inganqueri aisati Tosorintsi canta Jonogaguitequënta. Pingantaiguërica popiguemisantane cara icantagueti te onganinate, iroro quero pomaguisantaguëtineri, aro irooti inganqueri Tosorintsi. Aroca irobetsicasërequima, pijocajineri pingantaiguëri te ine icantagueti yamai, aisa ocanta ora inganqueri Tosorintsi inguengasëretëmi irojocajineri aisati. ");
INSERT INTO notNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nagatsitaimiro: cara pomanaiguëri Tosorintsi cara Jonogaguitequë obiro aisati basini, aroca pinguengasëretima, aro imaiguëmi Tosorintsi ora pomanaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aisonorinta atiraca irapatotaiguema pite quemisanquinane queroca maba, aisati aintana Naro nantsibataiguëmari. ");
INSERT INTO notNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aique iáque Peroro, yosamitëri Ira Jesos: —Natingomi, nigóque cara ingantaguetomoquinaca te ongomeite nopiguemisantane, caninataque nangábintseri nojocajineri ora icantaguetomoquina, quero nipëgatari. Carari iragatsitainaroca, ¿Ati ongarate nojocobentajiri? ¿Aroco ongarate 7? ");
INSERT INTO notNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yotabitanëri Jesos: —Nangantasanotëmi, quero patiro pijocobentajineri siete, carari tojaisonori pijogopiantaineri përosati; quero pipëgatari. ");
INSERT INTO notNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aisati ora iragáantane Tosorintsi ocantari ibega ibatorote cogatsi cara iripënabentairi iratirite. ");
INSERT INTO notNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Icaimobëri paniro iromeraro, irebetiri tojaisonori quirequi. Icantabepari: “Popënabentajinari naguireguite”. ");
INSERT INTO notNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yotabitanëri: “Tigueti ongantima nopënabentajimi yamai tenta irine quirequi”. Aro igáqueri basini: “Páganëri ica. Pomimantiri. Aisati pomimantiro iina, ianiquite, ora yasinta, omagaro; nágairi quirequi irebetëna”. ");
INSERT INTO notNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aique yobaticagueritocari iromeraro, yamanaqueri: “Nobatorote, quero popimantina. Aiquenta nopënabentajimiri antagaisati”. ");
INSERT INTO notNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aro icantaneintëgotanairi iromeraro ibatorote, icanqueri: “Nangábintsaimi, nojocajimiri ora pirebetëna nomaguisantocotajimiri. Quero nocoicotajimi”. Aro yomisotocajiri. ");
INSERT INTO notNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cara iáque iromeraro, iniopëri irapimeraro irebetiri iriro arosata quirequi. Yágatsonotobëri icanqueri: “Popënabentinari ora pirebetëna”. ");
INSERT INTO notNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aro yobaticagueritotabecari, yamanaqueri: “Quero picoicotinari yamai. Aiquenta nopënabentajimiri antagaisati”. ");
INSERT INTO notNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Carari te ingábintsairi. Yomianqueri iromingamentoquë icanqueri: “Cara popënabentajina, aro nagáqueri cara iromisotocajimi”. ");
INSERT INTO notNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Cara iniaigabaqueri imatsiguenga, yogasëretaigaca. Iátasitaiguëri ibatorote, icomantaigapëri: “Naniaiguëri ira picábintsai cani, te ingábintsante iriro yamai. Yomianqueri irapimeraro irebetërinta iriro arosata”. ");
INSERT INTO notNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aro ibatorote icaimagantairi aisati iromeraro, icabëri: “Te pinganinate obiro. Picanquena: ‘Quero popimantina’, irooti nojogantaimiro ora pirebetëna. Nacábintsasantëmi, carari te pingábintseri irebetimi obiro arosata. ");
INSERT INTO notNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aisati ¿Caninataqueme pingábintserime obiro ira irebetimi arosata, aisati pingantiname naro cara nacábintsëmi”? ");
INSERT INTO notNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aro iguisanaca ipasatëri yomianqueri icanqueri: “Yamaica quero nomisotocajimi irooti cara popënabentajina antagaisati ira pirebetina”. ");
INSERT INTO notNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aisa ocanta queroca picábintsairi ira cantaguetomoquimine te onganinate, queroca pijocajineri, querootisati icábintsaimi Pabati Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aroque icomantagueque Jesos cara Garireaquë. Aique yogagaiganaja Iriro aisati irogomere cara Joreaquë, canta antatinta Joriránquë. ");
INSERT INTO notNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aisati yoguiataiganaqueri tojai matsiguenga. Aintasati tojai janaitaguetatsiri. Yoguibegajiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aisati iátasitaiguëri Jesos bariseopague; icogabeca iraniantëmari irantacaquerime ora te onganinate. Yosamitaigapëri: —¿Caninataqueco irojocajiro iina sërari aitica pairorapagueraca ora te iranintocotiro? ");
INSERT INTO notNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yotabitobëri Jesos: —¿Teco pinibatapinintabetimaro Sanguenari? Jirai Tosorintsi yobetsiquëri ira sërari aisati tsinane. ");
INSERT INTO notNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aisati icanque Tosorintsi: Cara iráquero iina sërari, irojocanëri iriri aisati iniro, irágasantëro iina, intimacaquero casiriconiati. Coshoni iroquero iina, pitirooti inganquima paniro ibatsa. ");
INSERT INTO notNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jirai inabitaca sërari aisati iina; yamai coshoni irogobaquima, intimaiguë inganquima paniro. Iniaiguëri Tosorintsi irianti paniro ibatsa. Ipanirootitaiguëri. Iroro te onganinataguëte irojocobagajima. Querootisati ijocaguiri basini matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aisati yosamitaigapëri bariseo: —¿Aisonori? ¿Pairo isanguenabirique Moisés jirai? Pisanguenatinero pijina pomero ora pijogantaimaro, aro ocaninati pijocajiro. ");
INSERT INTO notNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Icantaigabaqueri Jesos: —Te pinganinasëretaigue, aro icanquemi Moisés cara caninataque pijocajiro pijina. Carari te iranintacaguimi Tosorintsi pijocajiro. Icocaquemi quero pijoquiro. ");
INSERT INTO notNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nacantaiguëmi Naro, aroca pijoquero pijina, aisati págae basini, aroque paguimintëmaro pijinasonori. Patiro aroca aguimintëmi, aro caninataque pijocajiro. Aisati ira agairone tsinane ora ijoque ojime aroque yaguimintacari ojime. ");
INSERT INTO notNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aro icantaiguëri irogomere: —Aique, queroca ocaninati ijocajiro iina, caninataque quero yáganti. ");
INSERT INTO notNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Icanqueri Jesos: —Tigueti ongantima inguemiro antagaisati sërari oca nacantaiguëmica. Paniro inguemaquero ira yogometasanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ainta ira te irágobinte iina. Aintasati basini ira yágaguitsoiti, quero pini iina. Aisati ainta te iraninte iráguiro iina. Icoguini intimasitima arota inganquineri pairoraca ingocaqueri Tosorintsi. Aroca pinguianquero oca piquemaque, aro pinguengasëretëro. ");
INSERT INTO notNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Aique pamapëneri Jesos janequipague, ocantaigapëri: —Poguineri pobaco notomipague, pomanocotiri Tosorintsi arota ingábintseri. Icantaigabaquero irogomere: —Quero paseriguiri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Carari icanqueri Jesos: —Quero picantiri. Nocoguini iribocasitaigapëna janequijegui. Igóiguë iriro intingomintina. Antagaisati icantaigari ibega ica intiomoquina cara itingomibintanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aro yoguëneri ibaco, yamanaque: —Pabati, nanintini pingábintsaigueri icaegui janequipague. Aique iáque Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aro ipocasiqueri oboina sërari yosamitapëri: —Ogomeantatsiri, picaninati. ¿Pairo caninatatsi nanganque naro arota nantimaque përosati canta Jonogaguitequënta? ");
INSERT INTO notNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yotabitanëri Jesos: —¿Pairo picantobiquina Naro caninari? Paniro ini caninari, Irianti Tosorintsi. Carari picoguica pijáte Jonogaguitequë, pingantiro omagaro ora isanguenaque Moisés. ");
INSERT INTO notNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Icanque oboina: —Aiti tojai isanguenaque. ¿Pairo pininti nanganque? Yotabitanëri Jesos: —Quero póganti, quero pintiro tsinane cagaro pijina, quero picositanti, quero pitsoiguëgotari pomatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pinguemisantiri piri aisati piniro quero pipëgatsatari; pinintiri pitimanamitane aisa ocanta cara pininta obiati. ");
INSERT INTO notNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Icanqueri sërari: —Aroque naquemisanquero omagaro oca cara ninë janequi irooti yamai. ¿Paironibani nanganque basini? ");
INSERT INTO notNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Icanqueri Jesos: —Pinintica iraniacaninatimi Tosorintsi, atsi pijáte pomimantiro antagaisati ora pasinta, pomaguetiri ira coguitiaguetacha omagaro opënataga; aique imëmi Tosorintsi ora caninaro cara Jonogaguitequë. Cara pomimantëroca antagaisati, omana piguiatanëna Naro. ");
INSERT INTO notNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cara iquemabecaro oca, iáque oboina yogasëretasantanaca irironta casintaguetasantacha, te iraninte imimantiro. ");
INSERT INTO notNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aro icantaiguëri irogomere Jesos: —Aisonori nacantasantëmi: opomirintsitomocari casintaguetachari iriátë cara itingomibintanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nagatsitaimiro aitosati, opomirintsitomocari cameyo ingue otiomijaniquë omoro quitsapi. Carari omomirintsitomotasantëmari casintachari iriátë cara iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iquemaiguëri irogomere iquenganeintasantaigacari, yosamitobaca: —¿Aisonorico? ¿Pairo inganque matsiguenga cara irabisaicotajima? ");
INSERT INTO notNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesos inetsaiguëri irogomerejegui, icantaiguëri: —Quero icantiro matsiguenga, carari Irianti Tosorintsi inganquero antagaisati. Te omomirintsitomotimari Iriro. ");
INSERT INTO notNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aique icanqueri Peroro: —Pinguengaiguena naroegui, tojai nocogasantaigui naguiataiganaquemi, iroro nojocaigaguëtanëro omagaro nasintaiga. ¿Pairo nágaigae aiquenta? ");
INSERT INTO notNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yotabitanëri Jesos: —Nangantasantaiguëmi aisonori: aronta nopaniaca Jonogaguitequë nomatsiguengatapë, aiquenta nopocaje aisati iroraiquë quibatsi nagáantasantapë antagaisati. Cara nosobiaque nagáantomentoquë, obirojegui aguiataiguëna yamai, aisati pisobicaiguë pigáantomentoquë ocarati 12. Pigáantaiguëri joríojegui. ");
INSERT INTO notNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aroca piguiataiganaquina, quero pitsipiriaro. Aroca pijocaiganaquero pobangopague, pirentipague, pitsiropague, piri, piniro, pitomipague, piguebatsitepague, pairorapagueraca, quero pitsipiriaro. Aroca pijogobitanënaro arosata piguiatëna, imaiguëmi Tosorintsi tojai. Aisati irágaiganaquemi cara Jonogaguitequë cara pintiomoqueri Tosorintsi përosati. ");
INSERT INTO notNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ainta yamai tojai itingomipague yaca quibatsica, carari quero igáanti canta Jonogaguitequë cara panironta Atingomi. Aintasati yamai tojai itsipiriaiguë yaca, imaintaiguëri matsiguenga carari aiquenta imaiguëri Atingomi iromitocoiguëri cara igáanti Iriro. Icaranti yamai carari aiquenta irobaque. ");
INSERT INTO notNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Aisati basini icanque Jesos: —Aisati nongomantaiguëmiro ati icanta Tosorintsi cara igáanti. Ainta casintaro irobasite. Oquëtaguetanë iátasitamanëri sëraripague poeboroquë intarobacaatineri irobasitequë. ");
INSERT INTO notNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iniopëri iraegui cogatsi intarobacaatineri, icampëri: “Pintarobacaatina yamai irooti chopiniquë, aro nomaiguëmiri paniro quirequi ira jitacha tenario”. Icabëri: “Aro, caninataque”. Aique iáiguë itarobacaaquineri irobasitequë. ");
INSERT INTO notNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cara ijonogatapë paba, aisati iátaji casintaro obasi poeboroquë, iniaigapëri basini sobicaigatsi te intarobacaate. ");
INSERT INTO notNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Icampëri: “Pinintica pintarobacaatina yamai cara nobasitequë, nopënabenquimi caninasati”. Yotabitanëri, ");
INSERT INTO notNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Aro”, aique iáque itarobacaaquineri. Aisati catinga paba iátaji poeboroquë itarobacaatacaqueri basini. Aisati cara inëmatanë paba igáqueri basini intarobacaatineri. ");
INSERT INTO notNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aisati pënibaque ochapinitanë iátaji. Iniopëri basini te irante. Yosamitapëri: “¿Pairo te pintarobacaabirite”? ");
INSERT INTO notNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yotabitobëri: “Tenta pairi meratinane”. Icampëri casintaro: “Atsi pijáte pintarobacaatina aisati nobasitequë; pintsibatimari ira obataiguëmi”. ");
INSERT INTO notNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cara ochapinitanë ira casintaro icanqueri ira omisantineri irobasite: “Popatotaigueri iraegui tarobacaataiguëna nobasitequë, popënabentiri. Piguibatëri popënabentiri ira carantënguitsi ipoque. Aique popënabenqueri basini irooti cara popënabentiri ira obapënguitsi naarai coniamaniquë”. ");
INSERT INTO notNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aro ipoque ira tarobacaatënguitsi arosata, ipënabenqueri paniro tenario. ");
INSERT INTO notNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aisa ocanta ipaiguëri ira parintënguicha catinga, aisati ira boquënguitsi cara ijonogatapë paba. Aique icaimaiguëri iraegui parintënguicha coniamaniquë. Iquengaigabitaca iriro iripënabentëri tojai, carari ipënabentaiguëri paniro tenario aisati. ");
INSERT INTO notNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yágaigabaqueri iguireguite, iguisatsatëri ira tarobacaataqueri. ");
INSERT INTO notNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Icantaiguëri: “Ira carantënguitsi itarobacaataiguë arosataanti, carari pipënabentaiguëri iriatisati popaiguëna naro. Naanti niáigamanë cara oquëtaguetamanë, natarobacaatasantaiguë, icatsiringatasantë paba, tojai nomasobitaiguë. Caninataque náguëme basini quirequi”. ");
INSERT INTO notNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Paniro yotabitanë casintaro oba: “Nomatsiguenga, teni nomatobitimi. ¿Teco nangantimi naarai, ‘Nopënabenquemi paniro tenario’, picanquena, ‘Aro’? Aquengaigaca. ");
INSERT INTO notNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yamai, páganëri pasiati, pijáte. Nocoguini nopënabentaiguëri ira carantënguitsi aisa inganquima pibiaca obiro. ");
INSERT INTO notNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Teco onganinate nopasitacarico naguireguite? ¿Piguisaneinquinanico obiro aroquenta nacábintsaiguëri basini?” ");
INSERT INTO notNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nongomantaiguëmi yaca quibatsica iraegui imaintaiguë imatsiguenga, iraguibataiguëri Tosorintsi cara Jonogaguitequë. Irari aguibataigacha yaca quibatsica ingarantaiguë canta. Aintanta tojai matsiguenga icantaigabitari Tosorintsi: “Pinguemisantina”, carari arosataanti ira quemisantaiguëri. Tojai quero iáti Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aique iáiguë Jesos aisati irogomere aiquero Jerosarénquë. Yáganëri casiriconiati irogomere, icomantaigairi: ");
INSERT INTO notNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","19","—Yamai intsomaigue Jerosarénquë. Naro paniacha Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Iroro cantënguicha cara Jerosarénquë irágaiguëna itingomipague saseriroti aisati iraegui ogomeantiro isanguenare Moisés. Ingantaiguëri ira Iromasati: “Páguiri Jesos, póguiri tenta ingomeite”. Irisërontaiguëna, iripasataiguëna, iribëquëgotaiguëna corosiquë carari ongaraque maba cataguiteri nangabiritanaima nanganiatae. ");
INSERT INTO notNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aique piátasiqueri Ira Jesos iina Sebereo, otsibatapari otomi, Joan aisati Santiago. Pobaticagueritotasipari ocampëri: —Nocoguini pingábintsena. ");
INSERT INTO notNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yosamitobëro: —¿Pairo pininti? Potabitapëri: —Aiquenta, cara pigáantë pigáantanequë, nocoque irisobicomoquimi notomi, paniro pobacosonoriquë, ira basini pomatepacoquë. Iromitocotaiguemita cara pintingomibintanque. ");
INSERT INTO notNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Icabëro Jesos tsinane aisati otomi: —Te pigóte pairoraca pomanaquina. Aiquenta natsipiriaque tojai. ¿Teco pintsorogue cara pitsipiriaiguë obiro? Yotabitanëri Santiago aisati Joan: —Teni nontsorogue, nangantaiguëro naro. ");
INSERT INTO notNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aro icanqueri Jesos: —Aisonori pitsipiriaiguë, carari quero nopimiro cara pisobicomoquina aiquenta. Paniro Pabati përine pairiraca tsipaquinane Naro cara nagáantë. ");
INSERT INTO notNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iquemaiguëri basini irogomere icarati 10. Aro iguisaneintobiqueri ira Santiago aisati Joan, aroquenta icogabeca pitirooti irobataiguërime. ");
INSERT INTO notNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iriro cantënguicha Jesos icaimaiguëri irogomerejegui, icantaiguëri: —Pigóiguë ira itingomipague basiniati matsiguenga cagari jorío yametaiga imerataigari imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Carari quero aisati picantaigari ibegaiga iriro. Pinintaiguëca piguibatima obiati, pomitocotaigueri pomatsiguenga pingábintsaguetaigueri, quero pimeratari. ");
INSERT INTO notNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pomitocotaigueri pomatsiguenga pairoraca ininti. Pingantimari ibega iromerataga. ");
INSERT INTO notNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nopaniaca Jonogaguitequë, nomatsiguengatapë arota nomitocotaigueri matsiguenga, quero nimeratari. Aisati nipocasique nangamobitaiguëri antagaisati matsiguenga arota iragabisaicotajiri Tosorintsi cara inguemisantaiguëna Naro. ");
INSERT INTO notNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cara yaretaiga Jesos aisati irogomere Jericóquë. Cara yogagaiganaca, yoguiataiganaqueri abatsiquë tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ainta isobicaigasegui pite comarajari onamiquë abatsi. Icomantaiguëri iriro: —Coraque Jesos. Aro icaibaitanë pitirooti: —¡Natingomi, Obiro imatsiguenga David! ¡Pingantaneintëgotaiguena! ");
INSERT INTO notNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aro iguisatsataigabaqueri ira botoitaigacha icanqueri: —¡Pomairetaigue! Aiquero iáiguë icaimasantaiganaque: —¡Natingomi, pingantaneintëgotina Obironta imatsiguenga David! ");
INSERT INTO notNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iquemaigapëri Jesos, yaratingopë, icaimagantëri, icanqueri: —¿Pairo picogaiguë nanganquemi? ");
INSERT INTO notNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yotabitaiguëri pitirooti: —Natingomi, nanintaiguini piniacagajina. ");
INSERT INTO notNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aro icantaneintëgotaigapëri Jesos, yotsagataiguëri iroquiquë. Aito cara inianai aisati. Aro yoguiataiganaqueri ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aro yaretaigacaro poeboro jitacha Betajajé Jesos aisati irogomerejegui. Pinë Betajajé osobiquë oguitoja jitacha Olibos ora oguitoja catingasatiquë Jerosarén. Aro Jesos igáqueri pite irogomere, ");
INSERT INTO notNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","icanqueri: —Pijáigue catingasati poeboroquë. Cara, piniaquero tsinane boro otsatocotaga, otsibatari itiomijani. Pintsaicotiro pomapëro yaca. ");
INSERT INTO notNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aintaca matsiguenga irosomitobëmica: “¿Pairo pitsaicobiritiro boro?” aro pinganëri: “Icoguironi Atingomi”. Aro inganquemi: “Páganëro”. ");
INSERT INTO notNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Icanque Jesos negaca cara imoncaraquero ora isanguenatocoqueri jirai comantantatsiri jitacha Sacarías. Isanguenaque: ");
INSERT INTO notNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pingomantiri Jerosaresati: “Coraque Pitingomi. Iriro caninarisonori, quero iquenga Iriati. Iqueicotanacari itiomijani boro”. ");
INSERT INTO notNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aique iáque pite irogomere, ");
INSERT INTO notNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","yamapëneri ira pite boro, antiasiporo aisati itiomijani. Yoguëneri iguitsagarepague imiticaraquë, aro iqueicotanacari Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ainta inaigasegui tojai matsiguenga yoguiaiguëri Jesos. Yogaguetaiguëneri iguitsagarepague cara abatsiquë arota iragaticanëro boro. Aisati yogaguetaiguëneri otiomijani otsego anchato aisa icanta icantaigabaquineri itingomi. ");
INSERT INTO notNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ibataiganaqueri tojai matsiguenga aisati yoguiataiganaqueri tojai. Icaimaiganaque: —Ainta Agabisaicoontatsiri, imatsiguenga David. Intsome antingomintobëmari. Intsome aniacaninatobëri. Igáqueri Tosorintsi aroquenta iniacaninatëri Iriro. Caninari Tosorintsi jonoquënintaberi. ");
INSERT INTO notNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aro icanaque Jesos cara Jerosarénquë. Iquenganeintasantëgotobacari Jerosaresati, yosaminatobagaiganaca: —¿Pairi ica? ");
INSERT INTO notNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yotabitaiguëri basini: —Irianti Jesos Nasaresati. Ipaniaca toonquë cara Garireaquë. Iriro comantantatsiri Ira igáque Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Aro icanaque Jesos cara oquibequë pongotsi irasi Tosorintsi, iguisaigapëri antagaisati ira manantatsiri aisati ira pimantatsiri, ijocaigapëri sotoquë. Aisa icanqueri ira campiatiri quirequi aisati ira pimantiri paroma; yotëatapëri imesanepague aisati irisobicomentopague. ");
INSERT INTO notNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Icantaiguëri: —Ocanti Sanguenari: Icanque Tosorintsi: “Caninataque pomanocotaiguena yaca nobangoquë”. Carari obirojegui te pomanocotiri, iroonti picositapinintaigabaqueri ira bocaigatsi iromanocotaigapëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aique ipocasitaiguëri Jesos tojai comarajari aisati tojai carancaratatsiri. Yoguibegaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Cara iniaiguëri itingomi saserirotipague aisati ira ogomeantiro isanguenare Moisés, iguisaneintaiganaqueri Ira Jesos, aroquenta itasorintsitagueque Iriro. Aisati Iriro icaimëgotaiguëri janequi cara oquibequë pongotsi, icantaiguë: —¡Intsome antingomintaiguemari imatsiguenga David! Aro iguisaneintasantaigaca saseriroti, icantaiguëri: ");
INSERT INTO notNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—¿Piquemaqueroco oca icantocotaiguëmi janequi? Te onganinate ijitaiguëmi Itingomi. Yotabitanëri Jesos: —Jee, naquemaiguëri. Teco pinibatiro Sanguenari ora cantatsi: Intingomintaiguëmari Ira Quirisito janequi aisati tsorori janequi ira tsotatsi. Irinibacaninataigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aro iáiguë Jesos aisati irogomere, iáiganaque cara Betaniaquë cara isamaigapë. Ora Betania iroonti poeboro otiomijani. ");
INSERT INTO notNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cara oquëtaguetanai ipigaigaa Jesos aisati irogomere aiquero Jerosarénquë. Cara abatsiquë itaseguë Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Cara onamiquë abatsi iniopëro panguirintsi jitacha iguera. Iátasiquero. Icogabecaro ojito, carari te ine, iroonti osi. Icampë: —Querota basini pinai ojito oca igueraca. Aito cara pisiguiricanë iguera, ocamaque. ");
INSERT INTO notNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iniaiguëro irogomere, iquenganeintaigacaro, yosamitaiguëri Ira Jesos: —¿Ati ocanca pisiguiricasitaca iguera omanapague? ");
INSERT INTO notNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yotabitaiguëri Jesos: —Nacantasantaiguëmini, aroca pinguemisanqueri Tosorintsi, pingantaiguëro aisa nacanta nacanquero iguera. Aisati pinganquerica Pabati: “Pigaganënaro oca oguitojaca, pijoquiro cara angaarequë”, aro inganquimiro. Carari quero pitsoinguiri. ");
INSERT INTO notNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aisatica pinguemisanqueri, inganquimiro pairoraca pomanocoqueri. ");
INSERT INTO notNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aitosati icanaque Jesos cara oquibequë pongotsi irasi Tosorintsi. Iroontita yogomeantasegui, aro iátasitaiguëri itingomipague saseriroti aisati irapague ogomeantiro isanguenare Moisés, yosamitaiguëri: —¿Pairi agáquemi cara pijocaiguëri pimantaigatsiri? ¿Pairi oguëmi cara pijica itingomi? ");
INSERT INTO notNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yotabitaiguëri Jesos: —Aisati Naro, patiro nosamitaiguëmi; aroca potabitaiguëna, aisati nongomantaiguëmi pairi agáquena Naro. ");
INSERT INTO notNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Pairi agáqueri Joan cara ibaotisataiguëri tojai omatsiguenga? ¿Iriroco agáqueri Tosorintsi? ¿Iraco agáqueri matsiguenga? Icantobagaiganaca jorío: —Anganquerica: “Igáqueri Tosorintsi”, aro ingancái: “¿Pairo te pinguemisantobitaigueri Joan?” ");
INSERT INTO notNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Carari aroca anganqueri: “Igáqueri matsiguenga”, aro inguisaigacái omatsiguengapague ijitaiguënta cara igáqueri Joan Tosorintsi cara ingomantagueque. ");
INSERT INTO notNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aro yotabitaiguëri: —Teni nogóigue pairi agáqueri. Icanqueri Jesos: —Aisati Naro, quero nocomantimi pairiraca agáquena nangantaguete ocapague piniaiguëca. ");
INSERT INTO notNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aisati icantaiguëri Jesos: —Yamai nongomantaiguëmiro quingabaguirentsi: ainta sërari aisati piteni itomi. Igáqueri itomi obatatsiri: “Notomi, pijáte yamai pintarobacaate cara obasiquë”. ");
INSERT INTO notNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yotabitanëri: “Quero nantiro”, carari iquianca, aique iáque itarobacaapë. ");
INSERT INTO notNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aisati igáqueri basini itomi: “Notomi, pijáte yamai pinte cara obasiquë”. Yotabitanëri: “Aro, Apa, najáque”. Carari te iriátsatiri. ");
INSERT INTO notNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yamai nosamitaiguëmi: ¿Pairi antasantëneri iriri ora icocaqueri? Yotabitaiguëri: —Ira obatatsi, aroquenta itarobacaaque obasiquë. Aro icantaiguëri Jesos: —Nangantasantaiguimini oca: irobataiguëmi iriáiguë Jonogaguitequë ira coigotantatsi quirequi aisati ora antapinintaguetiri sërari cagari ojime. ");
INSERT INTO notNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ipoque Joan baotisatantatsiri, icomantapëmi ati pingantaiguëma cara pinganinataiguë, carari te pinguemisantobëri. Irianti quemisantaiguëri ira coigotantineri Iromasati piguireguite, aisati oquemisanqueri tsinanepague antaguetaiguiri sërari cagari ojime. Icantaigaa yacaqueroca cara iriáiguë Jonogaguitequë, carari te pomasiniatitima obiro, te piganinataiguema, quero piáti jonoquë. ");
INSERT INTO notNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Aisati icantaiguëri Jesos: —Aiti basini nosiacagantëmiro: pinguemaigabaquero. Ainta sërari panguiquero obasi. Yotanquero. Aisati iquiaque omoro cara iragaticaguitëro oguitso aisati ora irágantëmaro oja. Aisati yobetsiquëro pongotsi oquibiantsa jonoquë ora iranetsantimaro. Aro yogaiguëri omisantineri irobasite, aique iáque jaanta basiniquë quibatsi. ");
INSERT INTO notNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cara omoncaraca cataguiteri cara oragatanë oguitso, igátabecari iromeraro: “Pijáigue, pingampëri ira omisantinaro nobasite imagantaiguenaro nasiati”. Aro iáigabitaca. ");
INSERT INTO notNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Carari ira omisantiro iniaigabaqueri, yágaigabaqueri. Paniro ipasataiguëri, basini yogamagaiguëri, basini ibasegaiguëri mopëquë yoguipigabitacari. ");
INSERT INTO notNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ira casintaro igátaigabitacari basini iromeraro tojai. Aitosati icantaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aique iquengasëretaca ira casintaro: “Yamai nagáqueri notomi. Iraniacaninataigabaqueri iriro”. Aro igáqueri itomi. ");
INSERT INTO notNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Irari omisantineri irobasite iniobëri itomi inibatobaganaca: “Coraque itomi casintaro. Cara ingamaquenica iriri, iriroquerai ágairone obasi. Intsome ógaigabaqueri, águero obasi asintaigaimaro eiroquerai”. ");
INSERT INTO notNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aro yágaigabaqueri, yáganëri sotoquë obasi, yogamagaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cara iribocapë ira casintaro obasi, ¿Pairo inganqueri iraegui omisantaiguineri? ");
INSERT INTO notNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yotabitaiguëri saseriroti: —Cara iriboque, irágaigapëri ira catsimari omisantatsiri, iratsipiriacaqueri, irógaigapëri. Aique irogaiguëri basini omisantineri irobasite, irianti caninari, ira pagantirine iraisati oja oba. ");
INSERT INTO notNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aro icantaiguëri Jesos: —Teco pinibataiguero ora Sanguenari ocanti: Jirai itsoingaiguëro mopë ira obetsiquirori mopëpongo, ijoquero tenta irogóiguero cara icoiguëro Tosorintsi iroonti otingomi mopë, otingomi pongotsi, cantaca otingomipoa. Carari yágairo ora mopë, itingomiantacaro pongotsi. Icaninabenquero Atingomi, iniacaninatëro, icantacagajiri matsiguenga cara irogajiro otingomi mopë. Aisati naquenganeintasantëro naroegui. ");
INSERT INTO notNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iroro nocomantaguëtaiguëmi: quero piniaiguiri Tosorintsi cara igáanti. Irianti jáiguënguitsine Iriroquë basiniati matsiguenga ira quemisanquerine intingomintaiguëmari Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pairiraca pariaquenguitsine yaca mopëca iricarapë itonguiquë; pairiraca otsinaque oca mopëca onganqueri cantaca pibega pojongabatsari. Naanti osigaro ora mopë otingomi nacantocotaiguëmiro; queroca pigótina, pitsipiriaque; queroca piquemisantina, pijáque Sharincabeniquë. Pairiraca comëtobënane iripoguiriaquengani. ");
INSERT INTO notNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aro iquemaigabaqueri Ira Jesos itingomi saseriroti aisati ira ogomeantiro Sanguenari, igóiguë cara Jesos iquenguitsatocotaiguiri irirojegui. ");
INSERT INTO notNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Iguisaneintaigabitacari, icogaigabitaca irácagantërime, carari yomitsorogaiguëri matsiguenga igóiguënta matsiguenga cara aisonori Jesos icomantëgotëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aisati icanque Jesos oca quingabaguirentsica. ");
INSERT INTO notNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Nongomantaiguëmi ati ocanta cara itingomibintanti Tosorintsi. Ainta itingomi yobetsiquëneri itomi cara iráquero iina. Icaimaiguëri tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Igátabecari iromeraro, icaimagantaigabitacari igaimanejegui, carari te iribocaigue. ");
INSERT INTO notNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aisati igátabetajari basini iromeraro icantaiguëri: “Pingantiri nagaimane: ‘Aroque pobetsicaca antagaisati. Yógaiguëri ibaacate aisati iroishate aneri. Popogopë pinganinasëretaigapë’ ”. ");
INSERT INTO notNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Carari te inguemaigabaqueri. Iáiguë atiraca. Iáque paniro cara iritoganequë, iáque basini cara imimantagueantë. ");
INSERT INTO notNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ainta basini ágobëri iragátane icantaigabaqueri catsimari. Aisati yogamagaigabaqueri basini iragátane. ");
INSERT INTO notNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cara igóque itingomi, iguisanaca, igátaiguëri isoraroteegui iboeborotequë. Yogamagaigapëri ira igaimane, aique itagaigapëro ibangopague. ");
INSERT INTO notNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aique icanqueri iromeraro itingomi: “Aroque nobetsiquë omagaro, carari te ingomeite nagaimanejegui, te iriboque. ");
INSERT INTO notNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pijáigue cara abatsipaguequë, pingaimiri matsiguengajegui, pingantiri: ‘Pijáigue ibangoquë atingomi, pinganinasëretëgotineri itomi águënguitsine iina’ ”. ");
INSERT INTO notNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aique iáiguë iromeraropague, icaimaguequeri imatsiguengajegui. Yapatoitaigaca tojai, caninari aisati ira te inganinate. Iagaigaparo pongotsi. ");
INSERT INTO notNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aro iáque itingomi cara irobetsataiguëmari ira bocaigatsi. Iniopëri paniro sërari ira te ingue caninaro iguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yosamitapëri: “Nomatsiguenga, nopaguetaiguëri nagaimane caninaro quitsagarintsipague arota pinguitsagatima caninasati. ¿Pairo te pinguitsagabiritima obiro?” Te irotopitiri. ");
INSERT INTO notNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aro icanqueri iromeraro: “Piguëshotiri ibacoquë aisati iguitiquë, pomisotoguiri sotoquë cara tsitiniriquë. Cara, iraraquima aisati iratsitsiaguitetanë”. ");
INSERT INTO notNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pinguemina: ainta tojai icaimaigabita Tosorintsi carari te inguemisantiri; arosataanti ira icoigaiguë. ");
INSERT INTO notNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aique iáiguë bariseoegui, yosamitobagaigaca: —¿Pairo anganqueri Ira Jesos aniantimari? Aroca angantacaqueri ora te onganinate, aro cara anguisëri. ");
INSERT INTO notNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aro igátaiguëri irogomere aisati ira aguiataiguiri Eroris. Iáiguë icantaigapëri Ira Jesos: —Ogomeantatsiri, nigóiguë aisonori pogomeantiro Irinibare Tosorintsi, aisati poniaguinaro catingasati atiraca ongantima naretaiguëmari Tosorintsi. Te pintsoroguiri pairiraca. ");
INSERT INTO notNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yamai pingomantina pairoraca piquianca Obiro: ¿Caninataqueco omëri Sésar aguireguite? ¿Teco onganinate omagantëri cobeingari cara Iromaquë? ");
INSERT INTO notNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Igóque Jesos cara icogaigabitaca iromatobitirime, irantacaguiri ora te ongomeite. Yosamitaigabaqueri: —¿Pairo picogobiti pomatobitina? Te pinganinate. ");
INSERT INTO notNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Poniaguinari quirequi ira pipënabentiri Iromasati. Aro yamaigapëneri quirequi, ira jitacha tenario. ");
INSERT INTO notNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yosamitëri Jesos: —¿Pairi casintaro oca irosiacagomentoca? ¿Pairi ijita sanguenatëgotënguicha yaca tenarioica, iroonti iripajiro? ");
INSERT INTO notNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yotabitanëri: —Iroonti irasi Sésar nogobeingarite. —Icantaiguëri Jesos: —Aro, pomaigueri Sésar ira icoicoquemi, aisati pomaigueri Tosorintsi ora iraisati, ora icocaquemi Iriro. ");
INSERT INTO notNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iquemaiguëri, iquenganeintasantaiganaca. Aique iáiguë, ijocaiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Irooti cataguiteri iátasitaiguëri Jesos saroseopague, ira ijitasitaiga cara quero icabiritaja igamagaegui. Aro yosamitaigapëri: ");
INSERT INTO notNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ogomeantatsiri, jirai isanguenaque Moisés: Aintaca sërari, carari te irine itomi, aique ingamaqueca, caninataque ireinti irágajiro iina; aroca ontsomaaque itomi, irianti irosiguëma itomi ireintitomaco. ");
INSERT INTO notNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jirai ainta naroeguiquë poro sërari, aisati ireinti icarati 6. Yágabitaro iina, carari te irine itomi. Aique icamaque iriro. Aro iina yágairo ireinti. ");
INSERT INTO notNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aisati icamaque iriro, te irine itomi. Aisati icantaigaca ireintiegui yágaigabitaro tsinane icamaiguë omagaro, teni irinëmate itomi. ");
INSERT INTO notNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aique ocamaque tsinane aisati. ");
INSERT INTO notNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cara ingabiritaigaima, ¿Pairi ágairone? Pinetse, ijinantaigabitaro antagaisati ireintiegui. ");
INSERT INTO notNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aro yotabitanëri Jesos: —Tojai pamatobitaigaca obiatiegui tenta pigóiguero Sanguenari, teatisati pigóiguero itasorintsite irasi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aisonori cara angabiritajima, antimaigae, quero ágai ajina. Antagaisati ira cabiritajachane ingantaiguëmari ibega ironomire Tosorintsi: quero yágai iina. ");
INSERT INTO notNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ingabiritaiguëma omagaro camaigatsiri. ¿Teco pinibatiro ora icanti Tosorintsi jirai? Icanque: ");
INSERT INTO notNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Naro Tosorintsi. Iquemisantina Abaram. Iquemisantina Isac. Iquemisantina Jacob. Te ingante: “Iquemisantabequina”. Aroca iquemisanquerini Tosorintsi Abaram, ainta icaniati Abaram. Aisati caniari Isac aisati Jacob. Tosorintsi Irianti Itosorintsite ira caniatatsi. ");
INSERT INTO notNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cara iquemaigabaqueri tojai matsiguenga, iquenganeintaigaca. Icanque: —Caninasati yogomeanti Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ira bariseo iquemocotaiguëri saroseo, cara caninasati yotabitaiganaqueri saroseopague Jesos yoguimairenqueri. Iroro itsorogaiganaque saroseo cara iraniantaiguëmari aisati. Aro ipocasitaiguëri Jesos bariseopague. ");
INSERT INTO notNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Icogaigabitaca iramasitacaguimarime Jesos irinibarequë. Ainta paniro bariseo ogomeantiro Sanguenari, yosamitëri iriro: ");
INSERT INTO notNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ogomeantatsiri, aiti tojai pogometaguequina Sanguenari. ¿Pairo obatatsi ora anguemisanque? ");
INSERT INTO notNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yotabitanëri Jesos: —Pinintasantiri Atingomi, Irironta Pitosorintsite pomasëretasantimari obiati, përosati pinguengueri, pinguemisantasantiri. ");
INSERT INTO notNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ocari oca iroro obatatsi cara Sanguenariquë. ");
INSERT INTO notNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ora otsibata, ocanti negaca: Pinintiri pitimanamitane pibega cara pininta obiati. ");
INSERT INTO notNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aroca pingantaiguëro oca, aro pomoncarataiguëro antagaisati isanguenare Moisés aisati omagaro isanguenataiguë comantantatsiripague. ");
INSERT INTO notNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Cara përosati yapatoitaigasega bariseopague, yosamitaiguëri Jesos: ");
INSERT INTO notNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Pairo piquengasëretëgotacari Quirisito? ¿Pairi imatsiguengataca? Yotabitaiganaqueri bariseo: —Iriro matsiguengatacari David. ");
INSERT INTO notNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Icantaiguëri Jesos: —Jirai Isëre Tosorintsi osanguenatacaqueri ira David; ijiqueri Quirisito “Natingomi”. Isanguenaque David: ");
INSERT INTO notNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ira Tosorintsi icanqueri Natingomi: “Pisobigue yaca nobacosonoriquëca. Pintsibatina nagáantomentoquë irooti cara nagabeiri antagaisati ira quisaiguëmi, irajitaiguëmi Itingomi”. ");
INSERT INTO notNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Iriroca Quirisito Itingomi David, ¿Pairo pijitobitaiguëri Iriro imatsiguenga David? ¿Pairo te pijitobitaigueri Pitingomi obirojegui aisati? ");
INSERT INTO notNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aro Jesos yoguimairentasantaiguëri bariseo irooti cara te pairi otabitirine. Itsorogaiganaque aro te irosomitaigairi aisati. ");
INSERT INTO notNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aique icantaiguëri Jesos ira imatsiguengajegui aisati ira irogomere. ");
INSERT INTO notNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Iraegui ogomeantiro Sanguenari aisati ira bariseoegui ijitasitaigabita aisati icantaigari Moisés: yogomeantaguequero isanguenare Moisés. ");
INSERT INTO notNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Caninataque pingantaiguero ora yogometaiguëmi, carari quero poguiatiri aroquenta icantasitaigacaro irinibare, tenta ingantiro iriati ora icomantaigabitëmira. ");
INSERT INTO notNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tojai yobomirintsitaiguëmi cara picanquero ora yogometaiguëmi, carari te iromitocotëmatimi iriati. ");
INSERT INTO notNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Antagaisati icantagueti iriro, icantasitaigaro arota iraniacaninataigueri imatsiguenga. Yogasitaro arosata Sanguenari cara ichotaiquë aisati ibacoquë. Aisati yobetsicasitaigacaro oquibesonori ogarasiquë iguitsagarepague arota iraniacaninataigueri matsiguenga, ingantocotaigueri: “Caninari bariseo aisati ira ogomeantiro isanguenare Moisés, iquemisantasantaiguëro”. ");
INSERT INTO notNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aisati cara yapaigui icogasantaiguë intsibataiguëmari itingomipague, aisati cara yapatotaiga jorío icogasanti irisobicomento caninaro. ");
INSERT INTO notNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Icogasantaiguë irobetsataiguemari matsiguengajegui cara opimantagani pairoraca, irobetsataiguemari: “Ogometinari”. ");
INSERT INTO notNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Carari obiro, quero picantari. Quero picogui irajitimi “Ogometinari”, panironta ogometimiri, Naanti. Aisati picantobagaiga, pijitobagaiganaca: “Nopiguemisantane”. ");
INSERT INTO notNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aisati yaca quibatsica, quero pijitasitari piri pairiraca, panironta Piri ini cara Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Querootisati pinintacaguiri irajitimi “Natingomi”, panironta Pitingomi, Irianti Quirisito. ");
INSERT INTO notNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pingoqueca pintingomintima, aro caninataque pobatacaguiri ira basinipague, pomitocotaigueri iriro. ");
INSERT INTO notNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pairiraca quingachane caninari, irajiquima obatatsi, aro Tosorintsi iraguipasiguitëri, inganqueri carantatsiri. Aisati ira carantatsi, inganqueri obatacagantatsiri cara inguemisantasantëri imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Icantaiguëri Jesos: —Obirojegui ogomeantiro Sanguenari aisati obirojegui bariseo, tojai ingasitígataiguëmi Tosorintsi tenta pinintacaguiri pairiraca iraretima cara iragáantanequë Tosorintsi, teatisati pijáigue obiro. ");
INSERT INTO notNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tojai pamatobianti. Aisati tojai ingasitígataiguëmi Tosorintsi aroquenta págabitsaquero obango ogamaimentaga iroontita pamanocotasantasitari Tosorintsi arota iraniacaninataiguemi pomatsiguenga. Tojai iratsipiriacagaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tojai ingasitígataiguëmi. Popomirintsibentaigari basini, pogometaguetaiguëri cara iromatobiantë aisa ingantaiguëmi pibega obiro. Yabisanaquemi iriro. Pamanocotasitaigari Tosorintsi obiro, carari te pingantiro caninaro; aisati yamanocotasantasitaigari pogomere, teatisati ingantiro caninaro. Aisa icantimi, icanquero ora iriátanquima Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ingasitígataiguëmi obirojegui. Aisa pingantimari ibega comarajari oniagasitari imatsiguenga comarajari negaraca pini abatsi. Picantasitaro: “Aroca inganque poro, ‘Iroontita pinë ibango Tosorintsi, pigóontimaro quero namatobitimi’, aro caninasati yamatobiantë. Carari aroca inganque, ‘Iroontita inë oro cara ibangoquë Tosorintsi, pigóontimaro quero namatobitimi’, aro aisonori iromoncaraquero irinibare”. ");
INSERT INTO notNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¿Pairo picantobitaiga negaca? Te pininte pigóigue ora caninari. Ora ibango Tosorintsi ocaninatasanti, aisati ira oro caninari aroquenta poganinatëri ibango Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aisati picantasitaro: “Aroca inganque matsiguenga, ‘Iroontita pinë cara atagantëneri Tosorintsi obira, pigóontimaro quero namatobitimi’, aro caninasati yamatobiantë. Carari aroca inganque, ‘Cara ini obira omapëneri Tosorintsi arota ataquineri, aro pigóontimaro quero namatobitimi’, aro aisonori imoncaraquero irinibare”. ");
INSERT INTO notNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¿Pairo picantobitaiga negaca? Te pininte pigóigue ora caninaro. Ocaninatasanti ora atagantëneri Tosorintsi ibatsa obira. Aisati icaninati ibatsa aroquenta poganinatëri ora atagantineri. ");
INSERT INTO notNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","22","Pinetsaigue. Tojai picantaiguë: “¿Teco ine atagantineri Tosorintsi aisati ora inatsi jonoica?” “¿Teco ine ibango Tosorintsi aisati Iriro tsomaguira?” “¿Teco ine Jonogaguite aisati Iriro sobicatsi cara iragáantomentoquë?” Picantasitaro pairorapagueraca pijitasita caninataque pomatobitaigueri pomatsiguenga. Pijitasita ¿Teco intime Tosorintsi? Aisonori itimi, igóque ora picantagueti, ingasitígataiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Obirojegui ogomeantiro isanguenare Moisés aisati obirojegui bariseo, ingasitígataiguëmi Tosorintsi pamatobiantinta. Pinetse: picantaguetaigabitacari. Aroca páguë quirequi 10, aro pomabaqueri paniro irasi Tosorintsi. Aroca páguë 10 osi pobanguirepague, aro pomabitëmari patiro osi. Carari te pinguengaiguero ora icocagasantaigabitimi Tosorintsi: icogabeca pintimeme caninasati, icogabeca pingantaneintëgotirime pomatsiguenga pingábintserime, icogabeca pinguemisantirime aisati pomoncaratirome pinibare. Caninataqueme pingantaiguerome antagaisati ocapague; aique aroca páguë pairoraca ocarati 10, patiro pomëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Te pigótëmataigue, carari picogabeca pogometaiguerime matsiguenga Irinibare Tosorintsi. Aisonori tojai popomirintsitasantabitacaro ora cagaro icocaquimi Tosorintsi, iroro cantënguicha te pinguengatëmataigueri ora icocagabequimi. ");
INSERT INTO notNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ingasitígataiguëmi obirojegui Tosorintsi tojainta pamatobianti. Piquibasantëro pitasane otisitaquë, carari te pinguibatetiro tsomaguitinina; cara osititeti. Aisa picanta obiro, poganinatasita arota iraniacaninataiguemi matsiguenga, carari te piganinasëretima pisërequë. Përosati picositanti aisati pamatobianti. ");
INSERT INTO notNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Te pigóigue. Aisati picantari ira te iranee. Obitsita quibatequerone tsomaguite, aique quero oquebatsitaji otisitaquë. Aroca piganinasëretëma, aro iraniacaninatëmi aisonori matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Obirojegui, bariseo aisati ogomeantiro isanguenare Moisés, ingasitígataiguëmi Tosorintsi pamatobiantinta. Aisati picantaro yogantari camatsirini, ibotsotiro catari. Ocaninatabitaca sotoquëranti carari tsomagui quimingaro isititi, jagaca itonguiporoqui. ");
INSERT INTO notNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iniacaninatabitacaro matsiguenga ora picantagueti carari te pinganinasërete: tojai pamatobianti aisati tojai pintapinintiro ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Ingasitígataiguëmi Tosorintsi tojainta pamatobianti obirojegui. Jiraisonori pomatsiguenga ógaiguëri ira comantabitari Irinibare Tosorintsi, Ira caninari. Yamai pobetsicaiguëro pongotsipague pinguengantëmari comantantatsiri. Aisati picantasitaiga obirojegui: “Nantimeme naati jirai, quero nóguirime, quero nacantarime nomatsiguenga ógueri”. ");
INSERT INTO notNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Picanque: “Nomatsiguengatacari jirainisati”. Aisonori picantaiguë, irootisatinta pintaiguë cantacha irasi jirainisati. ");
INSERT INTO notNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aisati posigari pomatsiguenga jirai, obirojegui ógueri aisati. Ora iparintaca jirai, picantaiguë obiro yamai. ");
INSERT INTO notNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Picantaigari marangue; pamasiqueri ira basini. Picantaguetasanoti tojaipague ora te onganinate, te pinganinatëmataigue. ¿Pijiqueco quero piáigui Sharincabeniquë? Aisonori pijáiguë canta. ");
INSERT INTO notNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Përosati icanque Jesos: —Aiquenta nagáquemiri basini comantantatsiri, ogótatsiri, aisati ogomeantirone Irinibare Tosorintsi. Nigótaiguëmi, ainta ira pógagantaiguë, basini popëicotaiguëri, popasataiguëri basini cara papatotaiga, aisati pinguisaiguëri basini negaraca iriátagueque. ");
INSERT INTO notNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ainta picantagueti, picogaiguinta pigamagaigueri antagaisati caninatatsiri. Jirai póguëri Abel, aisati basini tojai. Aisati pogamaguëri Sacarías, itomi Berequías, iroontita iquemisantacagabecari imatsiguenga cara ibangoquë Tosorintsi. Pintimaigueme obirojegui jirai, aisati póguërime. Pasi poguiro póganti. ");
INSERT INTO notNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aro Tosorintsi ingasitígatëri omagaro ira cogaigatsi iróguiri basini. Aisati ingasitígatëmi obirojeguinta ógueri. ");
INSERT INTO notNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Joo, obiro Jerosaresati. Tojai pógapinintiri ira quinguitsatocotaiguimiri Tosorintsi, aisati pobasiaqueri mopëquë ira igáquemi. Aisa ocanta tiapa omisantiri ojaniquite itiomijani, ocábintsaiguëri, aisati nocogabeca Naro nangantimaro, nangábintsaiguemime, carari te pinintaigue pinguemisantobëna. ");
INSERT INTO notNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pijitasitaiga Jerosarén caninaro, carari nojocanëmi Naro, aisati irojocanëmi Pabati Tosorintsi quero inomotajimi. ");
INSERT INTO notNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Quero piniaigaina aisati irooti cara piniaigabaquina nopocaje aisati nantingomibintaigapëmi, pingantocotaigabaquena: “Coraque Ira igáque Atingomi. Icaninatasanti Iriro”. ");
INSERT INTO notNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Aique isotocanë Jesos cara ibangoquë Tosorintsi, iáque. Ipocasitaiguëri irogomere, ijigotaiguëneri ibango Tosorintsi aisati pongotsipague otsibataro. ");
INSERT INTO notNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aro icantaiguëri Jesos: —¿Piniaigabitacaro ora pongotsipague? Aisonori nongomantëmi oca: aiquenta irogomeriguetëro antagaisati. Irogaguetajiro. Quero pini yaca pite mopë otsibatobagaa. ");
INSERT INTO notNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aique iáiguë itonganaque oguitojaquë jitacha Olibos. Isobigopë Jesos. Aro comanoroni yosamitaigapëri irogomere: —Pingomantina: ¿Ati ongantima cara irogomeriguetëro orapague pongotsi? ¿Pairo ogótacaquinane ati ongantima cara popogopae? ¿Ati ongantima omoncaraquima antagaisati oca picantaiguënaca? ");
INSERT INTO notNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aique yotabitanëri Jesos: —Arotasha pine quero yamatobitimi. ");
INSERT INTO notNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Iribocaiguë tojai, ingampë: “Naro Quirisito”. Iromatobitaigapëri tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pinguemopiantërota inganque: “Yomanátobacani canta”. Inganque basini: “Aiquenta iromanátobaguima canta jaanta”. Carari quero pogasëreta: tojai irógobaquima, carari queroquerai omoncarata omagaro nacantaiganaquemi. ");
INSERT INTO notNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aiquenta inganquima matsiguenga inguisaiganaqueri basiniati matsiguenga, inguisëgotobagaiguëma irógobaquima. Aitosati iritasegaiguë tojaisonori matsiguenga. Aisati ontojaiganaque janatigantsipague. Tojai osebataguetanëma omagaroguitequë quibatsi. Iratsipiriaiguë matsiguengapague, ");
INSERT INTO notNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","iroro cantënguicha queroquerai yobomirintsitasantiri matsiguengajegui. Aiquenta coraque agabenisonori. ");
INSERT INTO notNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Aisati icomantaiguëri irogomere Jesos: —Aroca irogóiguë matsiguenga piquemisantaiguëna, ingantobitaiguëmiro catsimari, irógarantaiganaquemi, inguisaiganaquemi antagaisati matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ainta tojai irojocajiro cara iquemisantabeca, aique inguisaiguëri ira quemisantatsirisonori, irácagantaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ingonijapë tsoengantatsiri, ingantaigabitëma: “Nanguemisantacagaiguëmi”, carari iromatobitaiguëri antagaisati quemisantabetachari. ");
INSERT INTO notNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tojai ingantaguequero te ongomeite, aisati tojai irojocajiro cara inintobagaigaca. ");
INSERT INTO notNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Carari nagabisaicotajiri antagaisati ira quemisantaiguënane përosati. ");
INSERT INTO notNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pijátagueque antagaisatiquë quibatsi, pingomantaguetaigueri omagaro matsiguenga oca Caninaro Nibarintsica, cara nocogui intingomintaiguena; aique omoncaraquima antagaisati oca nacantaiguëmica. ");
INSERT INTO notNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aisati icomantanque Jesos: —Jirai isanquenaque comantantatsiri jitacha Daniel: Aiquenta ingapë cara ibangoquë Tosorintsi ira quimingarisonori cantaguetasantatsi ora te ongomeite, iraguimingatëro antagaisati. Pigóiguero Sanguenari. Cara piniaiguërica ira nocomantëgoti yamaica inganaque ibangoquë Tosorintsi, ");
INSERT INTO notNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","aroca pitimi cara Jerosarénquë pisigaiganaquima otisipaguequë. ");
INSERT INTO notNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aintabica obiro jonoquë pobango, quero piápanënti tsomagui págapanëntiro ora pasinta; iroonti pisigasantanëma. ");
INSERT INTO notNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aroca pinë pitoganequë, quero pipigasitapanaantaro basini piguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tojai otsipiriaiganaquero tsinane ora pënibatatsi aisati ora tsotagatsi ojaniquite queronta pisigasantanaca. ");
INSERT INTO notNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pomanocotiri Tosorintsi arota quero pisigaiga cataguiteriquë omarigantetetica angani, querootisati cara sábaroquë cara pamagoriaigui. ");
INSERT INTO notNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aitosati icanë Jesos: —Aique tojai iratsipiriasantaiguë matsiguenga. Iratsipiriasanoiguë abisëro ora itsipiriaiguë matsiguenga jiraisonori irooti yamaica, aisati abisëro omagaro inanënguitsine aiquenta. ");
INSERT INTO notNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aroca ongosamanitanëme cara iratsipiriasanoiguë opoguiriaiguëri omagaro matsiguenga ingamaque, carari Tosorintsi ingábintsaiguëri antagaisati quemisanqueri iraegui icoiguë, arota quero ocosamaniti atsipiriagantsi. ");
INSERT INTO notNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aintaca paniro cantatsi: “Iriro Quirisito Ica”, quero piquemisantiri. Aisati inganquemica: “Intsome canta Quirisitoquë”, querootisati poguiatiri. ");
INSERT INTO notNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Coraque iribocapë tojai matobiantatsiri ingampëmi: “Naro Quirisito”. Aisati iribocapë basini inganque: “Naro comantëmirine Tosorintsi”. Tojai iritosongantë, ingoque iromatobitaiguëri tojai matsiguenga, carari quero yamatobitiri ira quemisantasantatsi ira icoiguë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Piquemaquena yamai nocomantaiguëmi atiraca ongantima aiquenta queroquerai ini. ");
INSERT INTO notNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Aroca inganquemi: “Ainta Quirisito cara tera ontimingani”, quero piquemisantiri. Aitosati, aroca inganque: “Ainta tsomagui pongotsi”, quero piquemisantiri. ");
INSERT INTO notNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nopaniaca Jonogaguitequë, nomatsiguengatapë. Cara omabocapái tegotsitanatsi moretatsiri, osangueguitetanëro omagaro jonoquë, aisa nangampaima Naro cara nopogopae quibatsica. Nomabocaigapairi, carari iraniaigabaquina antagaisati. ");
INSERT INTO notNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Atiraca ini igamaga, aito cara imarigasipëri tisoegui. Aisa ocanta tojainta itsoinganti joríojegui, iroro iribocasitaguëtaiguëri tojai matobiantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aisati icomantaiguëri irogomere Jesos: —Aro tojai iratsipiriasantaiguë antagaisati matsiguenga, omomirintsitomotaiguëri. Cara abisanaque atsipiriagantsi, aique intsitinitanë paba, aisati quero iconijaguitetanai manchacori. Aitosati imariaguepë jonogasati, aisati osebatanëma omagaro jonoquë. ");
INSERT INTO notNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aique nongonijapë Naro cara jonoquë, iragasëretocotaigabaquina antagaisati tsoengatsiri. Iraniaigabaquina cara nopogopë mingoriquë. Nosangueguitetaigapëri nongobeingatasanotapë nagáantaiguëri omagaro Naro paniacha Jonogaguitequë, nomatsiguengatapë. ");
INSERT INTO notNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aisati nagátaigapëri nonamireegui intibotë catsiguesonori irapatoitaiguëri antagaisati quemisantaiguëna iraegui igoigane Tosorintsi atiraca itimagueti quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Aisati icantaiguëri irogomere Jesos: —Yamai nosiacagantaiguëmiro anchato jitacha iguera: pinguengasantiro. Cara iroraini otsego, ositanae osi, aro pigóiguë pënibaque osariganaje. ");
INSERT INTO notNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aisa ocanta, cara piniaigabaquero oca nacantaiguëmica yamai, pigóiguë pënibaque orequima cataguiteriquë cara nopogopae. ");
INSERT INTO notNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nanganquemi aisonori: queroquerai icamaigui joríojegui tsoengatsiri cara queroquerai omoncarata oca nocomantaiguëmica. ");
INSERT INTO notNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Omeganëma omagaro ora inatsi jonoquë aisati omeganëma oca quibatsica, carari quero opega nasi nanibare irooti cara omoncaraquima omagaro ora nacantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Aisati icanque Jesos: —Te irogóte pairiraca atiraca ongantima nopocaje Naro. Te irogóigue ironomireegui Tosorintsi. Nipoque, nomatsiguengatapë carari teatisati nogóte Naro. Paniro igóti Pabati. ");
INSERT INTO notNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Jiraisonori, cara itimi Noé, yapapinintaiguë imatsiguenga, isinguitapinintaigaca, yágapinintaiguëro iina, itimabeta aisa ocanta itimaigabitaca omatsiguenga yamai. Te inguemisantaiguëro cara icamanaaigabitacari Noé: “Coraque onangasantapëma”. Aro yotetanaca Noé pitotsiquë, yasitocoqueri. Aique omabocaigacari matsiguenga angani, ponangasantanaca, pitsongaiguëri, itsiticaiganaque. Aitosati inganquima yamai matsiguenga, atiraca ongantima nopocaje Naro, quero iquemisanti, nomabocaigapëmari. Aique iratsipiriaiguë antagaisati tsoengatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aintaca piteni sërari cara togantsiquë, paniro náganë nantsibatanëmari, irari itsipa quero náganëri. ");
INSERT INTO notNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aintaca pite tsinane mitoquirori singui, náganëro paniro nantsibatanëmaro, orari otsipa quero náganëro. ");
INSERT INTO notNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Përosati icanai Jesos: —Piguiaiguena, pinguenguena, tenta pigóigue atiraca ongantima cara nopogopae. ¿Nomabocaigapëmica? ");
INSERT INTO notNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aisa icanta casintaro pongotsi, icositaguetiri. Aroca irogóqueme atiraca ongantima iriboquë cosirinti, ingaguitëme, quero inintacaguiri icositiri. ");
INSERT INTO notNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aisa nacanta Naro. Pinguenguena piguiaiguena. Queroca piquenguina, aro nopocaje nomabocaigapëmi. ");
INSERT INTO notNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pingantimari ibega caninari iromeraro casintari, igótasanti, igáanti basini iromeraro itsipa. Icanqueri ibatorote: “Obiro, pinganquineri basini arota popaaguiri caninasati”. Aique iáque. ");
INSERT INTO notNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Aroca iraniopëri iromeraro cantatsi caninasati, aro ingampëri ibatorote: “Caninasati picantaguetiro ora nococaquemi. Yamai nocogui pomisantasantiro omagaro ora nasinta, nigótinta yamai quero pamatobianti”. Aro inganinasëretë iromeraro. ");
INSERT INTO notNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Carari quero picantari ibega basini iromeraro te inguemisantiri ira ibatorote, inganqueca: “Yamai játaque ira meratinari, querojengari ipigapaa omanapague”, ");
INSERT INTO notNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aro inguisëri basini iromeraro itsipa, ingapojapinintiri, irisinguitopiantëma. ");
INSERT INTO notNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aro ira ibatorote iromabocapëmari iromeraro te ingomeite, tenta iragueiri. ");
INSERT INTO notNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aro ingasitígatapëri, iragáqueri intsibataiguëmari matobiantatsiri. Canta, iragasëretasantëma, iraraquima, iratsitsiaguitetanë. Quero picantari ibega iriro, irari posiguima caninari iromeraro quemisanqueri ibatorote. ");
INSERT INTO notNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Aisati basini icantaiguëri irogomere Jesos: —Yamai nosiacagantëmiro aisati ati ocanta iragáantane Tosorintsi. Aintaca 10 tsinane terai ágante. Ocogaiguë otonguiboquimari ojime otsipa aisati ontsibataiguëmari cara jiesitaquë. Aroque otsitinitanë, aro áganëro omicherotepague. ");
INSERT INTO notNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pabocorooti tsinane ogótatsiri; ora basini pabocorooti te ogóigue. ");
INSERT INTO notNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Oraegui te ogóte páganëro omicherote carari te áganë oja ora obotacagajimarone. ");
INSERT INTO notNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Oraegui ogótatsiri páganëro omicherote aisati páganë oja oboontaimaro. ");
INSERT INTO notNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tenta iriboque omanapague ojime otsipa, opotsiquitaiguë pisamaiganaque. ");
INSERT INTO notNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Aro aganguite oquemaigabaqueri icaimaigapëro: “Coraque pijimetsari, pijáte pitonguiboguintimari”. ");
INSERT INTO notNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Omanapague ocaguitaiganaque 10 tsinane, pobetsicanëro omicheroeguite. ");
INSERT INTO notNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aro ora te ogóte ocantabecaro ogótatsiri pabocorooti: “Pomabaquina arosata oja pasi; otsibaqueca nomicherotepague”. ");
INSERT INTO notNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Potabitaiguëro ogótatsiri: “Quero. Quero cotonguiboro oja naro aisati obiro. Aroca nomëmi naro, aisati otsibacanë nasi nomicherotepague. Pijáigue pomanantanontima pasi obiro”. ");
INSERT INTO notNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Iroontita piáigue omanantaiguë, yareca ojime otsipa. Otsibataigacari cara pongotsiquë iroro pabocorooti tsinane ogótatsiri aisati basini igaimane, icaigapë yapaigapë. Yasitocoigaca sitëcoriquë. ");
INSERT INTO notNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aique paretaigapaa ora tsinane te ogóte, ocantaigabitapaari: “Pisirenaro naro aisati, naniaigapaimi”. ");
INSERT INTO notNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Carari yotabitobëro tsomagui: “Quero. Teni nogóiguemi pairiraca obiro. Te naninte popocasitina yaca”. ");
INSERT INTO notNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pinguengasëretimaro oca nosiacagantëmica. Pigamema, tenta pigóigue atiraca ongantima cara nopigaima. ");
INSERT INTO notNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aitosati icanque Jesos: —Aisati basini nosiacagantëmiro ati ocanta iragáantane Tosorintsi. Aisa ocanta sërari játënguitsine jaanta basiniatiquë quibatsi: queroquerai iáti icaimaiguëri iromeraroegui, icomantaiguëri: “Nanintini pomisantinari naguireguite”. ");
INSERT INTO notNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","—Icanqueri paniro: “Jerica pabocorooti iguibe quirequi tojai iripënaro. Pomisantinari”. Icanqueri basini: “Jerica pite iguibe quirequi tojai iripënaro. Pomisantinari”. Aisati ipabaqueri basini iromeraro paniro iguibe quirequi tojai iripënaro iromisanquineri. Paniro ipëri tojai, irironta ogótasantatsiri. Ira basini ipëri arosata tenta irogótasante. Aro ipaguetanëri, aique iáque canta jaanta basiniquë quibatsi. ");
INSERT INTO notNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ira águëri tojai quirequi iáque yamanantë ipimantë. Yomitojaigasantëneri iguireguite ibatorote, icarati pabocorooti aisati. ");
INSERT INTO notNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aisati itsipa águëri pite iáque, yamanantë, ipimantë, yomitojaigasantëneri, yáguë basini pite. ");
INSERT INTO notNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Irari águëri paniro, iáque iquiaquero omoro, imánaquineri iguireguite ibatorote quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Aiquenta ipigapaa ibatorote, icaimaigapëri iromeraro: “Yamai pomapënari naguireguite”. ");
INSERT INTO notNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ipoque ira águëri pabocorooti, yamapë aisati basini pabacorooti, icanqueri ibatorote: “Jerica piguireguite popanaquina jirai. Namanantë, nopimantë tojai, aro nomitojaiguëri. Jerica basini, aisati icarati pabocorooti”. ");
INSERT INTO notNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Aro icanqueri ibatorote: “Caninataque picantasantëro ora nococaquemi. Cani nopanaquemiri arosata pomisantënari caninasati, yamai nocogui pomisantinari tojai basini. Aisati naninti tojai pinganinatomotina naro”. ");
INSERT INTO notNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Aique ipoque ira águëri pite, yamapë aisati basini pite, icanqueri ibatorote: “Jerica piguireguite popanaquina jirai. Namanantë, nopimantë, tojai nomitojaiganaqueri. Jerica basini, aisati icarati pite”. ");
INSERT INTO notNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Aro icanqueri ibatorote: “Caninataque picanque ora nococaquemi. Cani pomisantënari arosata. Yamai naninti pomisantinari tojai basini. Aisati nocogui tojai pinganinatomotina naro”. ");
INSERT INTO notNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aique ipoque ira ágabitënguicha paniro, icanqueri ira ibatorote: “Nobatorote, nigóquimi obiro, te pingábintsante, notsoroquemi. Najique aroca nomitojaiganaquemirime piguireguite, págabitsaquinari omagaro. Iroro te nomitojaigaguëtiri. ");
INSERT INTO notNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nitiaqueri antagaisati. Jerica naguipigaimiri ira pasi”. ");
INSERT INTO notNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yotabitëri ibatorote: “Te pinganinate. Tojai poperataca. Pigótabeca nocogabeca naro pomitojaiguenarime naguireguite. ");
INSERT INTO notNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Pairo te pomabiritiri ira ogapinintiri quirequi? Pomairime iriro, iripënabentainarime nágantajimarime basini. Iraguipigainarime omagaro nasi”. ");
INSERT INTO notNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aro ibatorote icanqueri basinipague: “Págabitsatiri naguireguite, pomeri ira omisantinari caninasati, aroquenta cani yomitojaiganaqueri pabocorooti iguibe quirequi irooti cara yáguë basini pabocorooti. ");
INSERT INTO notNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iriro nomasantë inomotiri tojai, irari inatsi arosata iriro nágabitsaque. ");
INSERT INTO notNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yamai páganëri ica cara otsitinitasanti cara iraragasëretasantima aisati iratsitsiaguitetanë”. ");
INSERT INTO notNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Aisati icomantë Jesos: —Nopaniaca Jonogaguitequë, nomatsiguengatapë. Aiquenta najátaje, nopigaima aisati. Intsibataigapëna tojai ironomire Tosorintsi irisaanganetsite. Nosobigopë nagáantomentoquë, nantingomibintaigapëri omagaro matsiguengajegui. ");
INSERT INTO notNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nopatotaiguëri antagaisati matsiguenga, negaraca itimagueti. Naro aisati nanganquimari ibega ira casintari ibira inaguiri casiriconiati iroishate aisati igábarate. Aisati Naro ninaqueri casiriconiati ira quemisanquina aisati ira tsoengaiguina. ");
INSERT INTO notNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nanganqueri ira quemisantaiguëna: “Popocaigapë yaca nobacosonoriquëca”. Nanganqueri ira tsoengaiguina: “Popocaigue yaca nomatepacoquëca”. ");
INSERT INTO notNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Aique nongomantaigabaqueri iraegui nobacosonoriquëni: “Omana, inganinatagaiguëmi Pabati. Jiraisonori yobetsiquëmiro iragáantane arota pintiomotaigueri. Yamai pijáigue pingarataigueri. Caninataque irobabintaiguemi. ");
INSERT INTO notNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cara nitaseguë, popëna noperi. Cara nomiretë, popëna nomire. Te pigótaigabitina iroro cantënguicha pobangopaguequë pogasomabaquina. ");
INSERT INTO notNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Te ine nomanchaqui jirai, obiro paiguënaro. Najanaitënti, obiro bocasitaiguëna. Yomianquina cara iromingamentoquë, pipocasitaiguëna picábintsaiguëna”. ");
INSERT INTO notNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aique irosomitaiguëna ira caninataigatsiri: “Natingomi, ¿Atiraca ocanta cara pitaseguë, cara napaagaiguëmi? Teni nanguenguero. ¿Atiraca ocanta cara pomiretë cara nopaiguëmi pomire? ");
INSERT INTO notNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Atiraca ocanta cara nacábintsaiguëmi nobangopaguequë? ¿Atiraca ocanta cara nopabaquemi pomanchaqui? ");
INSERT INTO notNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Atiraca ocanta pijanaitë, aisati yomianquemi, niátasitaiguëmi? Teni nanguengaiguero”. ");
INSERT INTO notNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aro notabitaiguëri: “Aisonori nangantasantaiguëmi: cara picábintsëri paniro quemisanquina, aisati picábintsëna Naro”. ");
INSERT INTO notNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Aique nangantaiguëri ira nomatepacoquëni: “Yamai pijáigue canta Sharincabeniquë, cara tsitsiquë ora te otsibague. Yobetsiquëro Tosorintsi jiraisonori; yobetsiquëneri Satanás, cara iriáiguë camagari, aisati antagaisati ira aguiataiguëri. Yamai pingarataigueri canta iriro aisati obirojegui. ");
INSERT INTO notNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Jirai nitasegabitaca, te pomaiguena noperi. Nomiretabitaca, teatisati pomaiguena nomire. ");
INSERT INTO notNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Naquenagueque, te pomena jatasintsi ora nasamantëma. Te ine nomanchaqui, carari te pomasitaiguenaro Naro. Najanaitë, te popocasitaiguena pinetsaiguena. Cara yomianquena iromingamentoquë teatisati popocasitaiguena”. ");
INSERT INTO notNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aique irosomitaiguëna: “Natingomi, ¿Atiraca naniaigabitëmi cara pitaseguë, cara pomiretë, cara te ine pomanchaqui, cara te ine negaraca pisamë, cara pijanaitë, cara yomianquemi, cara te nomitocotaiguemi”? ");
INSERT INTO notNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aro notabitaiguëri: “Aisonori nangantasantaiguëmi: cara te pingábintseri ira quemisanquina, teatisati pingábintsena Naro”. ");
INSERT INTO notNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aique iraegui nomatepacoquëni iriáiguë cara Sharincabeniquë përosati ingasitígataiguëri Tosorintsi. Irari iraegui caninataigatsi iriáiguë cara Jonogaguitequë, intiomotaigapëna përosati. ");
INSERT INTO notNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tojai icomantanque Jesos, aique icanqueri irogomere: ");
INSERT INTO notNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pigóiguë ongaraque pite cataguiteri omoncaraquima cataguiteri jitacha Pásicoa. Nopaniaca Jonogaguitequë nomatsiguengatapë, carari irácagantaiguëna iribëquëgotagantëna. ");
INSERT INTO notNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aro yapatotaigaca itingomipague saseriroti aisati ira ogomeantiro isanguenare Moisés aisati jorío antiasiparipague. Yapatoitaigaca cara ibangoquë itingomi saseriroti, ira jitacha Caijás. ");
INSERT INTO notNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yosamitobaca: —¿Ati anganqueri cara ágagantëri Jesos agamagaiguëri? ");
INSERT INTO notNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aisati iquengaigaca: —Quero águiri jiesitaquë. Iriro iniacaninataiguë matsiguenga. Aroca águëri inguisaigacái eiroegui. ");
INSERT INTO notNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aique yogaganaca Jesos canta Betaniaquë, Iriro aisati irogomere. Ainta ibangoquë Simón, ira iribatsasebaguitaga jirai. ");
INSERT INTO notNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yapasiguini Jesos aro pipogopë tsinane. Pamëgotasitapëri asaiti casangajengaro ora pënatacha tojai; pinantaro pobetsicagani mopë sibitaro jitacha aribásitoro. Pisataicoquero oshaguëantacari Jesos iguitoquë. ");
INSERT INTO notNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aro iguisëgotaiganacaro irogomere Jesos, icanque: —¿Pairo paparaabiriquero casangajengaro? ");
INSERT INTO notNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Caninataqueme omimantërome casangajengaro águërime tojai quirequi omërime tojai ira coguitiacha omitocotaiguërime. ");
INSERT INTO notNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yotabitaiguëri Jesos: —¿Pairo picantobibiriquero oca tsinaneca? Patiro ocanquinaro caninaro. ");
INSERT INTO notNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Përo cara irine obirojeguiquë ira coguitiachari te irine iguireguite; cara pinintica pomitocotaigueri iriro. Carari quero nini Naro përosati yaca. ");
INSERT INTO notNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ocabëna caninasati. Oshaguëantobënaro queroquerai iteina. ");
INSERT INTO notNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aisonori nangantaiguëmi: aiquenta pinguenagueque omagaroquë quibatsi, pinguenguitsatomotaguetaiguëri matsiguengajegui Caninaro Nibarintsi. Aitosati pingomantëgotiro oca tsinaneca arota irogótocotiro matsiguengajegui. ");
INSERT INTO notNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aique iáque paniro irogomere Jesos. Ijita Joras Cariotisati. Iátasitaiguëri itingomipague saserioti, ");
INSERT INTO notNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","icantaigapëri: —Aroca nágagantëri Jesos, ¿Aro popënabenquina? Yotabitëri: —Jee, nomaiguëmi quirequi. Aro ipaiguëri quirequi iguitso icarati 30. ");
INSERT INTO notNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aique ipigapaa Joras, inetsasantëri Jesos arota irogóontimari atiraca ongantima irácagantëri. ");
INSERT INTO notNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pareca Pásicoa cara yametaiga joríojegui yapaigui pan te ingonaguero ora piponganta. Iátasitaiguëri Jesos irogomere, yosamitaiguëri: —Natingomi, ¿Nega pininti nobetsiquëmiro cara popë Pásicoaquë? ");
INSERT INTO notNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Icantaiguëri Iriro: —Pijáigue cara Jerosarénquë; cara, piniaigapëri matsiguenga, pingantiri: “Icanque Ogometinari: ‘Pënibaque nomoncaraquero omagaro. Nanintini nopaiguë Pásicoaquë cara pobangoquë, Naro aisati nogomerejegui’ ”. ");
INSERT INTO notNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aique iáiguë irogomere, iniaigapëri sërari. Yoniagaigabaqueri ibango cara yobetsiquëro perintsipague asi Pásicoa. ");
INSERT INTO notNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cara otsitinitanë, ipocaiguë Jesos aisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Cara yapaigasegui, icomantë Jesos: —Aisonori nangantaiguëmi, ainta paniro yaca ira ágagantënane. ");
INSERT INTO notNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aro yogasëretaigaca antagaisati, panirootipague yosamitëri: —Natingomi ¿Naroco ágagantëmine? ");
INSERT INTO notNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yotabitaiguëri Jesos: —Irianti ira pëcoquina cara napë noberatotequë. ");
INSERT INTO notNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë yaca quibatsica. Jirai isanguenatocoquina Sanguenariquë, aroque nomoncaraquero omagaro. Irari atsipiriasantërone ira ágagantënane ¡Caninataqueme querome ini iriro, querome itsipireiro! ");
INSERT INTO notNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aique yosamitëri Joras, ira ágagantërine: —Natingomi ¿Naroco ágagantëmine? Yotabitëri Jesos: —Jee, Obiro. ");
INSERT INTO notNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Cara yapaigasegui, Jesos yáguë pan, icarasiaqueri Tosorintsi. Aique itibatsaaguequero, yotsatengaiguëri irogomerejegui. Icantaiguëri: —Jeroca pan osigaro nobatsa. Popaiguero. ¿Teco nangamobitaiguëmi? ");
INSERT INTO notNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aique yáguë irógomento, icarasiaqueri Tosorintsi, ipaiguëri irogomere, icantaiguëri: —Pógaiguemaro obirojegui. ");
INSERT INTO notNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iroro osigaro naraa, ora naraatobitanëneri omagaro matsiguenga cara nangamobitaiguëri. Yamai naraa ocanti irorai Nibarintsi; iroro ingábintsantaiguëmari Tosorintsi cara icanque jirai. Cara irabentaiguëna matsiguenga inguemisanquina, Tosorintsi irojocajineri matsiguenga ora icantagueti te onganinate, quero iquengairo. Nacantaiguëmi yamai arota pigóigue ati ocanta iragabisaicotajiri Tosorintsi antagaisati quemisanquinane. ");
INSERT INTO notNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yamaica quero nógaaro oja oba irooti cara nantsibataiguëmi cara iragáantanequë Pabati. Cara iragáantë Iriro omagaro omasiniatitanë. Aique nóguëmaro iroraia aisati obirojegui. ");
INSERT INTO notNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aroqueque icántataiguë Jesos aisati irogomere, iáiguë cara oguitojaquë jitacha Olibos. ");
INSERT INTO notNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yaretaigaca. Aro icampë Jesos: —Yamaica tsitiniri pijocaiganaquina, cara ocomantëgotëmi Sanguenari: Nóguërica ira omisantiri oisha, aro irisigaiganaquema iroishate, inguenagueque porocague. ");
INSERT INTO notNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Carari nanganiatanae, nobataiguëmi canta Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aro icanqueri Peroro: —Aroca irojocanëmi antagaisati basini icaegui, quero nojoquimi naro. ");
INSERT INTO notNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yotabitanëri Jesos: —Aisonori oca nongomantëmi: yamaica tsitinirica queroquerai icaimi tiapa sërari, ongaraque maba pinganque: “Teni nogótiri Ira Jesos”. ");
INSERT INTO notNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Icanque Peroro: —Aroca nantsibatëmi nangamobiquemi, quero nacanti: “Teni nogótiri Ira Jesos”. Aisati icantaigabitaca omagaro irogomere. ");
INSERT INTO notNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aique iáiguë Jesos aisati irogomere cara Jetsemaníquë. Icanqueri: —Pisobicaigue yaca; najáque Naro cara, nomanocoqueri Pabati. ");
INSERT INTO notNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yáganëri mabani casiriconiati: Peroro aisati piteni itomi Sebereo. Tojai yogasëretasantaca, iquenganeintasantaca. ");
INSERT INTO notNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Icantaiguëri ira yoganë maba Jesos: —Tojai nogasëretasantaca agabenisonori. Pisobicaigue yaca, pingaguite. ");
INSERT INTO notNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aique yogaganaca caraquerora yaquitomopa quibatsiquë. Yamanocopëri Iriri: —Pabati, teni naninte natsipirie, carari quero nacantiro ora nocogabeca Naro, iroonti nanganque ora picocaquena Obiro. ");
INSERT INTO notNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aique ipigasitapaari irogomere. Iniopairi isamaigasegui. Yosamitëri ira Peroro: —¿Teco pabebintsatiro pobotsiquine, te pabetiro pingaguitëmate arosata? ");
INSERT INTO notNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pingaguite, pomaniri Tosorintsi iromitocotaiguemi arota quero picantaguetiro ora te ongomeite. Picogabeta pingantirome ora nococaquemira, carari te pingantiro. ");
INSERT INTO notNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aro ipiganaja yamanaji aisati: —Pabati, picocagasanotënaroca natsipiriero, aro caninataque. Nomoncaraquero antagaisati ora picocaquina. ");
INSERT INTO notNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ipigapaa aisati iniopairi irogomere aitosati isamaigasegui, tojainta ipotsiquitasantë. ");
INSERT INTO notNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aisati iátaji yamanocotajiri Iriri. Irootisati yogatsitairi ora icanqueri naaraiquerai. ");
INSERT INTO notNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ipigasitapaari irogomere, icampairi: —¿Somatsibico? Yamai aroque omoncaraca. Jirai nopaniaca Jonogaguitequë, nomatsiguengatapë. Yamaica irácagantëna ira cagari caninataigatsi. ");
INSERT INTO notNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pingabiritaiguema, intsome ajáte. Coraque ipoque ira ágagantënane. ");
INSERT INTO notNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Cara inibatasegui Jesos, yarepa Joras ira yogometabeta Jesos. Icarataigapëri tojai matsiguenga. Yamaigapë isabirite aisati anchaqui cara igátaiguëri itingomipague saseriroti aisati antiasiparipague. ");
INSERT INTO notNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aroque icomantaiguëri Joras icanque: —Ira nasarapëma Irianti Jesos. Págaiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aique iátasiqueri Jesos Joras, yasarapari, icanque: —¿Aintabi, Ogometinari? ");
INSERT INTO notNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yotabitanëri Jesos: —Nomatsiguenga, ¿Pairo pipocasiti yaca? Aique ipocasitaigapëri antagaisati, yágaiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aro paniro irogomere yáguë isabirite, itoguimitatëri iromeraro itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesos icanqueri: —Pomingairo pisabirite cara poguiroriquë. Antagaisati ira carantobagaro isabirite, ingamantëmaro sabiri iriro aisati. ");
INSERT INTO notNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Teco pigóte nongocaquerica Pabati, iragátaiguënarime tojaisonori ironomire, inguisëcobentina? ");
INSERT INTO notNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Carari arome inguisëcobenquiname, iragabisaicotajiname, quero nomoncaratiro ora ocomantëgotëna Sanguenari. ");
INSERT INTO notNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aique icantaiguëri ira bocasitaiguëri: —¿Pairo pamasibiriquinaro pisabirite aisati anchaqui? ¿Naroco cosirinti? Tojai piniaigabitëna cara nogometaiguimi cara ibangoquë Tosorintsi, te páguina. ");
INSERT INTO notNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Carari páguëna yamai aroquenta omoncaraca ora ocomantëgotëna Sanguenari. Aique ijocaiganaqueri Jesos antagaisati irogomere, isigaguetaiganaca. ");
INSERT INTO notNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aro yágaiganaqueri Ira Jesos ibangoquë Caijás, itingomisonori saserirotipague. Cara, yapatobiritaigari basini itingomipague saseriroti aisati ira ogomeantiro isanguenare Moisés, aisati antiasipari. ");
INSERT INTO notNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yoguiatanëri Peroro icarantanë. Icapë tantotsiquë tsomagui itsibataigacari sorarojegui. Icogui irogóte atiraca inganqueri ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aro itingomipague saseriroti, aisati antiasipari, aisati omagaro itingomipague jorío icarati 71 itsoiguëgotaigacari Jesos arota iróguiri. ");
INSERT INTO notNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ainta tojai tsoiguëgotacarira, carari te inguengaiguema. Aique ipoque pite basini tsoiguëgotantachari ");
INSERT INTO notNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","icantaigapë: —Naquemaqueri cara icanque: “Nogomeriguetëro ibango Tosorintsi; ongaraque maba cataguiteri nobetsicairo aisati”. ");
INSERT INTO notNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aro icabiritanaca itingomi saserirotipague, icanqueri Ira Jesos: —¿Pairo te potapibiritiri? ¿Pairo ojita oca icantocotaiguëmica? ");
INSERT INTO notNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Imairetopitëri Jesos, te irotopitëmatiri. Aique itingomi saseriroti igáqueri: —¿Teco iraneimi Tosorintsi Ira catimanerisonori? Pingomantasantina: ¿Obiroco Quirisito, Itomi Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yotabitëri Jesos: —Jee, Naro. Nopaniaca Jonogaguitequë, nomatsiguengatapë. Aiquenta piniaigaina nosobigopë ibacosonoriquë Tosorintsi sintsirisonoriguinte, aisati piniaigaina cara nopoque mingoriquë, nopigapaima yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aique iguisanaca itingomi saseriroti itisaraanëro imanchaqui, icanque: —Piquemaigabaqueri. Ijitosorintsitasitaca Iriati. ¿Pairo ongogobique basini comantëgotërine? Piquemaiguëri cara icantocotaguetasitari Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Pairo piquianca obirojegui? ¿Pairo anganqueri? Yotabitaiguëri joríojegui: —Iriati cantagantënguicha, caninataque ingamaque. ");
INSERT INTO notNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aro ibasioquiqueri iroquiquë aique ijobaboroqueri iboroquë, icapojaboroqueri. Inchotangaborotëri ");
INSERT INTO notNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","icanqueri: —Jaa, Quirisito, pingomantina: ¿Pairi capojëmi? ");
INSERT INTO notNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ainta isobiaque Peroro saaguiteroquë. Oniaqueri tsinane ironomire itingomi saseriroti, ocanqueri: —Aisati obiro aguiatiri Jesos, Ira Garireasati. ");
INSERT INTO notNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Iquemaiguëri antagaisati cara icanquero Peroro: —Teni nogóte pairoraca picanquina. ");
INSERT INTO notNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Iátabeca cara icabitapa, oniaqueri basini tsinane ironomire itingomi, ocantocoqueri: —Ica aisati yoguiatëri Jesos, Ira Nasaresati. ");
INSERT INTO notNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aisati icanai Peroro: —Teni nogótiri ira posamitëna. Igóque Tosorintsi cara nacanque catingasati. Aroca nontsoiguëma ingasitígatinata. ");
INSERT INTO notNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aique ocosamanitanë arosata, ainta basini icantaiguëri: —Aisonori poguiatiri Ira Jesos. Naquemaiguëmi cara pinibati; obiro Garireasati. ");
INSERT INTO notNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yotabitanëri Peroro: —Tesonori nogótiri sërari ira picantocoquina. Igóque Tosorintsi aisonori nacanquemi. Queroca ninibatimi catingasati, nocogui ingasitígatina Tosorintsi. Irooti cara icaimanë tiapa sërari. ");
INSERT INTO notNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aro iquengairo Peroro ora icanqueri Jesos: “Queroquerai icaimi tiapa sërari, mabataque pinganque: ‘Teni nogótiri Jesos’ ”. Aro isotocanai Peroro iáque iragasantaca. ");
INSERT INTO notNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Oquëtaguetamananaque, iquengaigaca iróguiri Jesos antagaisati itingomipague saseriroti aisati antiasipari jorío. ");
INSERT INTO notNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yoguëshotaiguëri yáganëri cara itimi basiniati itingomi cobeingari, ira jitacha Pirato. ");
INSERT INTO notNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cara igóque Joras, ira ágagantëri Jesos, cara iquengaigaca iróguiri Jesos, iquengasëretabitaca. Yoguipigaineri itingomipague saseriroti aisati antiasipari ira 30 iguitso quirequisonori. ");
INSERT INTO notNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Icantaigapëri: —Jerica piguireguite. Teni onganinate ora nacanque, tenta ingantëmate Jesos ora quimingaro. Notsoigëgotasitacari naro. Yotabitobëri saseriroti: —Jemita ora picanque, iroonti pasi. ");
INSERT INTO notNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aique imionganaineri quirequi cara ibangoquë Tosorintsi, ipiganaja Joras. Aique iáque, yáguë sibitsa isiticanaca iriati. ");
INSERT INTO notNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ira itingomipague saseriroti yágairi iguireguite, icantaiguë: —Te inganinate angábintseri ica quirequica omeri Tosorintsi. Iriantinta ipënabenqueri eiro arota irócagantiri. ");
INSERT INTO notNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aro yosamitobaca: —¿Pairo anganqueri? Iquengaigaca: —Intsome omanantaiguero quibatsi atiantimari ira camatsine ira te aneiri paniacha parigotiquë. Aro yamanantë quibatsi ora yágapinintaigui, inti cobiti. ");
INSERT INTO notNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iroro irooti yamai ojitaguëca oca quibatsica: asi iraraa. ");
INSERT INTO notNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Aro imoncaraquero isanguenare Jeremías: Yágaigairi ira 30 iguitso quirequisonori. Irianti quirequi ipënataca cara yágagantëri Quirisito. Irianti arosata cara yametaiga jorío jirai. Yamanantaiguë quibatsi caninaro asi cobiti. Ira Atingomi agáqueri iromanantëro. Aro isanguenaquero Jeremías jirai. ");
INSERT INTO notNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aro yaratingopë Jesos catingasatiquë basiniati itingomi cobeingari jitacha Pirato. Yosamitobëri iriro: —¿Obiroco itingomi joríojegui? Icanqueri Jesos: —Jee, Naro. ");
INSERT INTO notNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aique cara icomantëgotëri itingomipague saseriroti aisati antiasipari, imairetanë Jesos, te irotopitiri. ");
INSERT INTO notNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Icanqueri Pirato: —¿Teco pinguemiro oca icantocotaiguëmica? ¿Pairo te potapibiritiri? ");
INSERT INTO notNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Carari te irotopitëmatiri. Iquenganeintacari Pirato, te irogóte pairo inganque. ");
INSERT INTO notNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aro antagaisati osarini omoncaraca jiesita cara iquengaigaca joríojegui jiraisonori cara yabisobenqueri ironomire Tosorintsi cara Ejípitoquë. Cara jiesitaquë yameta Pirato iromisotocajiri paniro ira iromingane, ira icoigaiguë jorío. ");
INSERT INTO notNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ainta tojai iromingane. Paniro jitacha Barabás. Irianti ógueri. ");
INSERT INTO notNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cara yapatotaigaca jorío, yosamitaigabaqueri Pirato: —¿Pairi picogaigui nomisotocajimi? ¿Picogaiguico nomisotocajimiri ira Barabás, iraco Jesos nomisotocajimi, aisati ijitaigui Quirisito? ");
INSERT INTO notNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Igótocoqueri Pirato cara iguisagantasitacari Jesos joríojegui tenta iraninte inguemisantiri imatsiguenga. Ijitabeca Pirato inganqueme jorío: “Nocogaigui pomisotocajinari Jesos”. ");
INSERT INTO notNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Isobigasegui Pirato iragáantomentoquë cara yameta iquemaguetiri matsiguenga, ocomantabitapari iina: —Quero pógagantiri Jesos. Icaninati Iriro. Naraningui naquisaniqueri, tojai naqueincoqueri. ");
INSERT INTO notNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Carari itingomipague saseriroti aisati antiasipari jorío iquiancagajiri joríojegui iromanocoqueri Pirato iromisotocajiri ira Barabás aisati irócagantiri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aisati yosamitairi Pirato: —¿Pairi picogaigui nomisotocajimi? Yotabitaiguëri: —Pomisotocajinari ira Barabás. ");
INSERT INTO notNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aique yosamitaiguëri Pirato: —¿Pairo nanganqueri Ira Jesos, aisati ijita Quirisito? Icantaiguëri joríojegui: —¡Popëicotiri! ");
INSERT INTO notNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yotabitaiguëri Pirato: —¿Pairoroco icantagueque te ongomeite ora nopëicobiriqueri? Icaimaiganaque jorío: ¡Popëicotiri! ");
INSERT INTO notNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aro igótanë Pirato itsipiriasica yosamitabitacari tojainta iguisaneinqueri Jesos joríojegui. Aro igáqueri ironomire: —Pomapëna nija. Yamapëneri, iquibococa irogótacaguiri jorío te iraninte irócagantiri Jesos. Icanque: —Teni naninte naro nógagantiri. Pinintaiguica obirojegui, iroonti pasi. Teni naro agáantirine. ");
INSERT INTO notNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yotabitaiguëri matsiguenga: —Nocogasantaiguë ingamaque. Caninataque inguisenata naroegui Tosorintsi aisati caninataque inguiseri notomijegui. ");
INSERT INTO notNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aique yomisotocajiri Barabás. Aisati igáqueri soraro iripasataigueri Jesos, aisa iribëquëgotëri. ");
INSERT INTO notNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aique yágaiganaqueri cara ibangoquë cobeingari, icaimaiguëri tojai basini soraro. ");
INSERT INTO notNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aique yágabitsaqueri imanchaqui, ipëri basini inaga, quiraaquisaamagori. ");
INSERT INTO notNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Imatseiqueri iroonti totsei. Aisati ipëri chocopi, icanqueri: —Pomogotiro oca ocarapi chocopi. Aique ishongaigapari soraro yobaticagueritotomemegapari, isërontaigacari, icantaiguëri: —¡Obiro Natingomi! ¿Aisonorico Obiro itingomi joríojegui? ");
INSERT INTO notNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aisati ijobataiguëri, yágabitsaqueri chocopi ipasataiguëri iguitoquë. ");
INSERT INTO notNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aroqueque icabíntsátaiguëri, aisati yágabitsaqueri quiraaquisaamagori manchaguintsi, icaagobëri iraisati imanchaqui, yágaiganaqueri cara iribëquëgotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aro yágaiganaqueri Jesos. Itonguibocari sërari Sirenesati, ijita Simón. Aro imeratobacari soraro, igáqueri: —Páganëneri igorosite. Aro yáganëneri. ");
INSERT INTO notNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yaretaigaca Górogotaquë ora ocanti osigaro iguito igamaga. ");
INSERT INTO notNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aro ipëtabecari Jesos oja obaa ogonoataga isincana; iniantacaro Jesos, te iraninte iróguimaro. ");
INSERT INTO notNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cara aroque ipëicotaiguëri soraro corosiquë, aique imaguimpibintëqueri imanchaquipague Jesos ipabacaguecaro yotsatiancaro. Aro omoncaraca Sanguenari ora cantatsi: Imaguimpibintaiguëro nomanchaqui ora irogóontëma pairiraca áganërone. ");
INSERT INTO notNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aique isobiaque osobiquë corosi inetsaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aisati yoguëro jonoica corosiquë, isanguenare Pirato. Isanguenaquero pairoraca ipëicobiriqueri. Ocanti: “Iriro Ica Jesos Itingomi joríojegui”. ");
INSERT INTO notNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aisati ipëicotaiguëri pite cosirinti itsibatacari Jesos. Ainta paniro ibacosonoriquë Jesos, basini imatepacoquë. ");
INSERT INTO notNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ainta yabisanaqueri abatsiquë, iniopëri Jesos, icabíntsáigapëri, ipoteguitotaigapa, ");
INSERT INTO notNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","icantaiguëri: —Pogomeriguetiro ibango Tosorintsi, aisati ongaraque maba cataguiteri, pobetsicairo. Atsi yamai pigabisaicotajima Obiati. Obiroca Itomi Tosorintsi piguëtanae corosiquë. ");
INSERT INTO notNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aisati isërontaigacari itingomipague saserirotijegui, aisati iraegui ogomeantiro isanguenare Moisés, aisati bariseoegui aisati antiasipari, icantobaganaca: ");
INSERT INTO notNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Yogabisaicotaiguëri imatsiguenga carari te iragabisaicotima Iriati. Iriroca Itingomi joríojegui, iraguëtanae corosiquë. Nanetsaiguëri, aro nanguemisantaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Itingomintabecari Tosorintsi Iriro. Icanque: “Naro Itomi Tosorintsi”. Nanetsaiguëri aroca iragabisaicoqueri Itomi yamai. ");
INSERT INTO notNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aisa icanqueri ira cosirinti ipëicotacaca icantocotaguetasicari, isërontaigacari aisati. ");
INSERT INTO notNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cara catinga paba otsitinitanë antagaisati quibatsi irooti cara ochapinitanë. ");
INSERT INTO notNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aro icaibatanë Jesos: —Eri, Eri, ¿Irama sabacatani? Ocanti: “Pabati, Notosorintsite, ¿Pairo pijocobitanëna?” ");
INSERT INTO notNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ainta matsiguenga cara iquemaiguëri icantaiguë: —Pinguemiri. Icaimërini Erías comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aro isiganaca poro, yáguë ichomicantaro, yoaquero obaaquë cochori. Yoguëneri chocopiquë itimagonaguitanaca ipëri Jesos iróguimaro. ");
INSERT INTO notNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ainta basini icanque: —Irinita. Quero popiri. Atsi anetserita aroca iribocasitapëri Erías iragabisaicopëri. ");
INSERT INTO notNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aro icaimasantanai Jesos, irooti icamantaca. ");
INSERT INTO notNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Cara icamaque Jesos, aito cara otisaraanaca aganguisati ora yotigantaro ibango Tosorintsi. Iroonti oquibepiriga tera yoguëro arota quero iqui pairiraca. Oparintanaca jonoquë, otisaraanaca irooti osobi. Aitosati posebatanaca quibatsi, moque moque moque, piquëtareaguetanë oquibe mopë. ");
INSERT INTO notNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yasirecotanaca camatsiri, icaniatanai tojai quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aique cara icaniatanai Jesos icabiritanaca iáiguë camabetachari cara Jerosarénquë. Iniaigapairi matsiguenga tojai. ");
INSERT INTO notNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aro ira capitán aisati isorarote inetsaigaseguiri Jesos, cara iquemaigabaquero posebatanaca quibatsi, iniaiguëro cara otsitinitanë, iniaiguëri igamaga cara icabiritanaca, iquenganeintasantaca icantaiguë: —Aisonori, Iriro Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ainta jaqueronta tsinanepague onetsaiguëri Jesos aisati. Opaniaca Garireaquë. Coshoni poguiataiguëri Jesos opapinintaiguëri tojai omitocotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ainta María Magararasato aitosati basini María iniro José aisati Santiago, aisati iniro piteni itomi Sebereo, aisati basini tsinane. Oniaiguëri Jesos cara icamaque. ");
INSERT INTO notNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cara ochapinitanë ipocasiqueri Pirato poro Arimateasati jitacha José. Iriro irogomere Jesos aisati, iquemisanqueri. ");
INSERT INTO notNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yamanopëri Pirato: —Camaque Jesos. Nocoguini pinintacaguina náganëri nomianqueri omoroquë. Aro igáqueri isorarote: —Pinintacaguiri ica iráganëri igamaga Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aique iáque, yáganëri igamaga iponatancari tocoya irorai. ");
INSERT INTO notNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yoguëri omoroquë cara iroraique yomoroque José. Ititiguëro mopë omoroquë, yasitocoontacari. Aro iátaji. ");
INSERT INTO notNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ainta pisobiaque María Magararasato aisati basini María, oniaiguëri cara yomianqueri. ");
INSERT INTO notNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pabisanaque cataguiteri ora jitacha Pásicoa cara ipëicoiguëri Jesos. Oquëtaguetamanë iátasitaiguëri Pirato ira itingomipague saseriroti aisati bariseopague. ");
INSERT INTO notNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Icantaigapëri: —Nogobeingarite, naquengaigairo cara icanque cani ira matobiantatsiri: “Nangamaque, aique ongaraque maba cataguiteri, nanganiatanae”. ");
INSERT INTO notNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yamai nocogaiguë pigátinari soraropague iromisantiro omoro cara yoguëri igamaga. Iranetsasantiro maba cataguiteri arota quero iátasitiri irogomere yágairi igamaga inganque: “Icabiritanaa icaniatanai”. Jirai tojai yamatobianti; yamai aroca iráganëri irogomere, iromatobitasantaiguëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aro Pirato igáqueri isorarote: —Atsi pijáigue, pomisantasanoiguero omoro. ");
INSERT INTO notNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aro iáiguë yasitocotasantëri, itsinetëgotëri yomisantasantëro omoro soraro. ");
INSERT INTO notNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pabisanaque cataguiteri comagoriantague. Oquëtaguetanai, iroonti tominco, tsitiniquerai piáque María Magararasato aisati basini María otsipa piátasiquero omoro cara yoguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Iroguito posebatanaca quibatsi aisati. Ainta ironomire Tosorintsi irisaanganetsite yamasobingopë canta Jonogaguitequënta irooti quibatsiquë, ititigapëro mopë ora yasitocoontabitacari, isobigopëro. ");
INSERT INTO notNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tojai yobariaguiteti aisa ocanta moretatsiri. Oquëtatasanotanë catarisonoriguinte iguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Iniaigabaqueri soraropague, itsorogasantaigabaqueri. Imogomogoatanaca icanaca ingamanëni. ");
INSERT INTO notNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Icampëro tsinane ironomire: —Quero pitsorogaigui. Nigóque pipocasitabecari Jesos, Ira ipëicotaiguë corosiquë. ");
INSERT INTO notNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Teni irinaje yaca. Aroque icaniatanai cara icanque. Jooque, pinetse cara yogabitacari. ");
INSERT INTO notNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pijáigue omanapague pingomantaigapëri irogomere, “Icamabeca Atingomi, yamai aroque icaniatanai. Irobataiguëmi canta Garireaquë. Aro piniaigairi canta”. Aroque nocomantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oquenganeintasantaca tsinane aisati ocaninatasantaiguë. Piáiguë pisigasitaiganacari irogomere arota ongomantaigapëri. ");
INSERT INTO notNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cara abatsiquë, iriguito yoniagaparo Jesos, ibetsataigaparo. Piátasiqueri pobaticagueritotasipari opogopëri iguitiquë. ");
INSERT INTO notNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Icampëro Jesos: —Quero pitsorogaigui. Pijáigue pingomantaigueri nogomere iriáigue canta Garireaquë. Aro iraniaigaina canta. ");
INSERT INTO notNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cara piátaigai tsinane, aisati iátagarantai soraro omisantëro omoro. Iáque poeboroquë icomantaigapëri itingomipague saseriroti ora iniaiguë. ");
INSERT INTO notNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yapatotaiguëri aisati antiasipari, yosamitobaca: —¿Pairo anganque yamai cara quero icomantëgotiri? Aro icaimaiguëri soraro, icantaiguëri: —Jerica quirequi nomaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pingantasitimari matsiguenga: “Cara nisamaigasegui aganguite ipocaiguë irogomere Jesos yáganairi igamaga”. ");
INSERT INTO notNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aroca inguemocotaiguëmi ogobeingarite, pingantiri: “Nisamë”. Nongomantëri naro: “Quero piguisiri soraropague. Teni irisome. Naro cantëri: ‘Pintsoiguema’ ”. ");
INSERT INTO notNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aro yágaiguëri quirequi soraro, icomantasitari matsiguenga carari itsoigani: “Nisamaiguë. Aique ipocaiguë irogomere Jesos yáganairi”. Aro icantobagaiga jorío negaca irooti yamai. ");
INSERT INTO notNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aro iáiguë irogomere Jesos cara Garireaquë. Icarati 11, panibani Joras. Iáiguë cara oguitojaquë ora icomantëri Jesos jirai. ");
INSERT INTO notNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cara iniaigapairi yobaticagueritotasipari, carari ainta porocague ira tsoenguëri. ");
INSERT INTO notNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aro ipocasitaigapëri Jesos, icampëri: —Jirai icanquina Pabati: “Pobatacagasanotiri omagaro Jonogaguitesati pintingomibintasanoiguëri, aisati pobatacagasanoigueri antagaisati quibatsisati”. ");
INSERT INTO notNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yamai pijátagueque omagaro poeboropaguequë, pinguemisantacagaigueri matsiguengajegui, potsatiancagaigueri imegaiguema nogomerejegui. Aroca inguemisanquina Naro, pomaotisataigueri. Ora icocaqueri Pabati imaotisabiritimari Iriro aisati Naro aisati Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pogometaigueri ingantaigue antagaisati ora nocomantaiguëmi Naro. Atiraca pijáte nantsibataiguëmi Naro, coshoni nogaiguëmi përosati irooti cara nopocaje nobatacagantapë. Aro ocarati ora nasanguenaque. Mateo ");
INSERT INTO notNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yamai nongomantëgotëri Jesoquirisito. Iriro Agabisaicoontatsiri, Itomi Tosorintsi. Iroonti Caninaro Nibarintsi ora nongomantëmi. ");
INSERT INTO notNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jirai isanguenaque comantantatsiri jitacha Isaías: Icanë Tosorintsi: “Notomi, nagáqueri nomeraro irobaquemi irobetsicoboguitëmiro pabo. Ingantaiguëri matsiguenga: ‘Pigamaiguemari págacaninatobëri Ira Agabisaicoontatsiri, pinguemisantiri’. ");
INSERT INTO notNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Inguenguitsatacagaiguërini matsiguenga canta tenta ontimingani, ingomantëgotëmi: ‘Coraque Atingomi. Piganinatiro paneingomento pibega cara pobetsicoboguitineri irabo itingomisonori pigatingatiro’ ”. ");
INSERT INTO notNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aroque omoncaraca ora icanque Tosorintsi, aisati ora isanguenaque Isaías jirai. Iconijapë Joan baotisatantatsiri canta tenta ontimingani. Icomantaigapëri imatsiguenga, ibaotisataiguëri. Iquenguitsatacagaiguëri: —Pingantaigaima yacaqueroca, pijocajiro ora picantaguetabeca te onganinate, pomasiniatitaje, quero picantaja pibega jirai. Pomaotisatima. Aro irojocajimiro Tosorintsi ora picantagueti te onganinate, iromaguisanquero, quero iguisaneintajimi. Aisati irogóiguë matsiguenga cara icábintsëmi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aro iátasitaiguëri Joan tojai matsiguenga, Joreasati aisati Jerosaresati, iquemisantaiguëri. Icomantaigapë: —Aiti nacantaguetiro ora te onganinate. Nocoguini ingábintsena Tosorintsi iragabisaicotajina. Aique ibaotisataigabaqueri Joan cara nijaaquë jitacha Jorirán. ");
INSERT INTO notNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ora iguitsagare Joan irianti cameyopiti, imatsaguitari imasitsa. Irianti yaagui ira tsiguëriquipague. Aisati itsimi pitsia. ");
INSERT INTO notNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Icomantaiguëri imatsiguenga: —Aique iribocapë sërari te aisa ingantina nibega naro. Ibaquina Irironta Natingomisonori, nitsoingaa naati naronta cantaca iromeraro Iriro. ");
INSERT INTO notNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naro baotisatantaiguëmiro nija. Irari bocapënguitsine aiquenta irogopëmiro Caninaro Isëre Tosorintsi inasërequimi cara pinguemisantobëri. ");
INSERT INTO notNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Cara yarepa Jesos. Ipaniapa poeboroquë jitacha Nasaret cara Garireaquë, iátasipëri Joan. Ibaotisatobëri Joriránque. ");
INSERT INTO notNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cara icontiatanai Jesos nijaaquë, aito cara iniobëro pasirianaca Jonogaguite pamasobingopëri Caninaro Isëre Tosorintsi ocampari sompaguiti. ");
INSERT INTO notNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aisati oquemobëngani Irinibare Tosorintsi jonoquë icanquë: —Obiro Notomi, nanintasanotanë. Tojai nacaninabentasanotëmi. ");
INSERT INTO notNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aique ora Isëre Tosorintsi páganëri Jesos cara tera ontimingani. ");
INSERT INTO notNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cara, itimaque 40 cataguiteri. Ipocasipëri Satanás icogabeca irantacaguirime Jesos ora te onganinate carari te ingantiro. Aisati ainta cobeingaripague, te iratsiquiri. Aique ipocasitaiguëri ironomirepague Tosorintsi imitocotaigapëri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cara yomianquengani Joan, aique iáque Jesos Garireaquë. Iquenguitsapëro Caninaro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Icanque: —Aroque omoncaraguitepa. Pënibaque orequima iragáantane Tosorintsi cara intingomibintaiguëmi. Pingantaigaima yacaqueroca, pijocajiro ora picantaguetira te onganinate, pinguemisantiro ora Caninaro Nibarintsi. ");
INSERT INTO notNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cara ipanomiatanëro Jesos cara onamijaquë angaare jitacha Garirea, iniopëri Simón aisati ireinti, Antiris. Isiriataigasegui simaguitinta ini. ");
INSERT INTO notNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Icampëri Jesos: —Intsome, piguiatanëna. Jirai pitarobacaati pisiriataiguëri sima carari yamaica nomëmiro irorai pitarobacaare; pinguemisantacaguinari matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aito cara ijocanëro isiritite, yoguiataiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yogagaiganaca canta queronta cara iniopëri Jesos pite basini, Santiago aisati ireinti jitacha Joan. Iriro pitirooti itomi Sebereo. Yobetsicaigaseguiro irisiriamento cara pitotsiquë. ");
INSERT INTO notNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aisati icaimaigapëri Jesos. Aito cara ijocaiganaqueri Sebereo aisati iromeraro cara ibitoquë yoguiataiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aro yaretaigacaro poeboro jitacha Caperinao. Cara cataguiteriquë comagoriantague, iroonti sábaro, icanaque Jesos pongotsiquë cara yapatotaiga joríojegui, yogometaigapëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iquemaigabaqueri iquenganeintasantaiganaca yogometaiguërinta aisa icantari ibega itingomi ogótasantatsiri; Ira Jesos cagari aisa icanta ira ogomeantiro isanguenare Moisés. ");
INSERT INTO notNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Cara yapatotaiga jorío, ainta inasegui sërari inancari camagari. Catsigue icaimasantëri Ira Jesos: ");
INSERT INTO notNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Ongainta! Quero picantaiguina, Jesos Nasaresati. ¿Naroco pipocasique yamai pitsipiriacagaiguëna? Nigóquimi Obiro, Ira Caninari Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Isintsitsaqueri Jesos ira camagari, icanqueri: —Pomairete. Pijátopitiri ica sërarica. ");
INSERT INTO notNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aro ira camagari yoguimogomogoatanëri, icaimanë catsiguesonori iátopitëri. ");
INSERT INTO notNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iniaiguëri joríojegui, iquenganeintasanoiganaca, inibatobaca icantaiguë: —¿Pairo ojita oca? Iroonti iroraisonori ogomeantagantsi. Ica patiro inibatëri ira camagari, aito cara iquemisanqueri iátaji. Tojai itingomintasanti. ");
INSERT INTO notNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aique omanapague iquemocotaiguëri Jesos omagaro Garireasati aisati antagaisati ira timaigatsi jaquerora. ");
INSERT INTO notNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cara isotocaiganaji Jesos aisati irogomere cara pongotsiquë cara yapatotaiga jorío, icaiganaque ibangoquë Simón aisati irasi Antiris. Itsibatanacari Santiago aisati Joan. ");
INSERT INTO notNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ainta ojanaisigui iraguiro Simón, pinariasega osamamentoquë. Icomantëgotëro, icomantaigabaqueri Jesos: —Ocatsiringaeguisigui iraguiro Simón. Pigaguibegajiro. ");
INSERT INTO notNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aro yotsitiparo Jesos, yágobagotëro, yogaratingopëro. Aito cara pabisanajiro ogatsingaeguire, pibeganaa, opaguetaiguëri iraperi. ");
INSERT INTO notNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cara ochapinitanë, icanaque paba, yamaguepëneri tojai janaitaguetatsiri cara Jesosiquë, aisati ira inantagueca camagari. ");
INSERT INTO notNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pënibaque omagaro Caperinaosati yapatotaigaca cara omoroquë ibango Simón cara inasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tojai yogaguibegaguetajiri ira janaitaguetatsi. Aisati igátaiguëri tojai camagari yomisotocajiri, te iranintacaguiri camagari irinibatocotiri igótirinta. ");
INSERT INTO notNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Oquëtaguetanë icabiritamananaca Jesos tsitiniquerai. Iáque paniro cara tera ontimingani yamanocopëri Iriri. ");
INSERT INTO notNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aique icabiritanaca irogomere icogaigabitacari Simón aisati itsipa, iáiganaque, ");
INSERT INTO notNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","iniaigairi, icanqueri: —Icogaiguimini antagaisati matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yotabitanëri Jesos: —Intsome basinipaguequë poeboro aronisati. Naninti nongomantagueiguëri aisati iroronta nipocasique. ");
INSERT INTO notNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aro iátagueque iquenguitsatomotaguequeri matsiguenga cara yapatotaiga jorío yotsatengaguetanëro omagaro poeboropague cara Garireaquë. Aisati ijocaigaineri matsiguenga igamagarite. ");
INSERT INTO notNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aro ainta iribatsasetaga iátasiqueri Jesos yobaticagueritotasipari yamanopëri icanque: —Pinintica, piguëtetainaro nobatsagoro, pigaguibegajina. ");
INSERT INTO notNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aro icantaneintëgotanëri Jesos itimagonaguitanaca ibaco, yotsagaqueri icanqueri: —Nocogui yamai; nagabisaicotajimi. ");
INSERT INTO notNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aito cara opeganaa ora iribatsagoro, iquëtetanai. ");
INSERT INTO notNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Aro igáqueri Jesos: —Quero pairi picomantëmati. Pijáte saserirotiquë, poniaguimari irogóontëmi cara aroque pabisëgotai. Pingantiro ora icanque Moisés: páganëneri saseriroti pobira, iritaguineri Tosorintsi. Aro irogótocotaiguëmi matsiguenga aroque pabisëgotai piquëtetanai. ");
INSERT INTO notNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Carari aiquero piátanëtigue cara icomantëgotëri Jesos. Ipocasitaiguërinta tojaisonori matsiguenga yoticaiguëri Ira Jesos arota quero iqui poeboroquë, caraanti inai cara tera ontimingani. Përosati ipocasitaiguëri matsiguenga ira paniaguitacha poeboropaguequë jaanta. ");
INSERT INTO notNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Aiquenta ipiganaja Jesos cara Caperinaoquë. Aro iquemocotobairi cara ainta pongotsiquë. ");
INSERT INTO notNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aro yapatobiritaigacari tojaisonori matsiguenga, iaguiicaro pongotsi. Aisati sotoquë ishapiicaro omoro arota quero iqui basini. Jesos icomantaguequeri matsiguenga icomantëgotëro Irinibare Tosorintsi ");
INSERT INTO notNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","cara yaretaigapa itsibasati sërari yanatocoigapëri sërari emëngari, ira te iranëibintsate. ");
INSERT INTO notNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Icogaigabitaca iráganëri tsomagui cara inasegui Jesos carari tigueti inguenaque cara ingaaganëri iacaronta pongotsi matsiguenga. Aro itaganëri jonoquë pongotsi yomoroganëro yoguëantaigacari jatasintsi aisati sogatsa catingasatiquë Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesos igótaiguëri cara iquemisantaiguëri yoguiaqueri cara iroguibegajiri ira emëngari, icabëri: —Yamai nomatsiguenga, nojocajimiro ora picantagueti te onganinate; quero iguisëgotaimiro Tosorintsi, quero iquengaimiro. ");
INSERT INTO notNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ainta isobicaigasegui irapague ogomeantiro isanguenare Moisés, iquenganeintaca iriatiegui: ");
INSERT INTO notNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Pairo icantobique negaca ica sërarica? Icantocotaguetasitari Tosorintsi. Quero pairi jocaguetirone ora te onganinate, paniro Tosorintsi icantiro”. ");
INSERT INTO notNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Igónijintasica Jesos ora iquenganeintaiga; yotabitaiganaqueri: —¿Pairo piquenganeintobitaiga cara najitosorintsitasitaca? ");
INSERT INTO notNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Te ongomëtate nanganqueri: “Nojocajimiro ora picantagueti te onganinate, nomaguisantocotimiro”, carari comëtaro nanganqueri: “Pingabiritima, págairo pijatasi panëitanae”. Aroca nanganque: “Pingabiritima panëitanë”, queroca yanëiti, pisërontobitaiguëna. ¿Aisonorico? ");
INSERT INTO notNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yamai noguibegajiri janaitatsiri arota nogótacagaiguëmiro cara icanquina Pabati: “Pijocajineri ira cantaguetiro te onganinate, arota eiro quero aguisëgotëtajari”. Nagabeiro Naronta paniacha Jonogaguitequë nomatsiguengatapë yaca quibatsica. Aro icanqueri emëngari: ");
INSERT INTO notNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Atsi pingabiritima, págairo pijatasi, pijáte pobangoquë. ");
INSERT INTO notNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cara inetsaigaseguiri, icabiritanaca yágairo iatasi isotocanë. Iquenganeintasantaiganaca omagaro botoitachari, icantaiguë: —Caninarisonori Tosorintsi. Yamai aniaiguëro ora te oneingani jirai. ");
INSERT INTO notNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Aro iátaji Jesos cara onamijaquë angaare cara yapatobiripari tojai matsiguenga. Yogometaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aro yabisëmatanë iniopëri Irebí itomi Arijeo. Irebí irianti coigotaguetiri iguireguite imatsiguenga ipagantineri igobeingarite canta Iromaquënta. Icampëri Jesos: —Intsome, piguiatanëna. Aro yaratinganë Irebí, yoguiatanëri. ");
INSERT INTO notNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aique iáque Irebí ibangoquë yapaaguëri Jesos aisati irogomere aisati tojai aguiataiguëri Jesos. Aisati icaimaiguëri tojai coigotantatsiri aisati ira cantaguetiro te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ainta bariseopague ira ogomeantiro isanguenare Moisés iniaiguëri Ira Jesos cara yapëgotaiguëri coigotantatsiri aisati cantaguetatsiri ora te onganinate. Icantaiguëri irogomere Jesos: —Te ingomeite Ogometimiri. Yapëgotaiguëri coigotantatsiri aisati ira cantaguetiro te onganinate. ¿Pairo icantobica negaca? Icantaguetiro Iriro te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cara iquemaigabaqueri Jesos, icantaiguëri: —Ira cajigatatsi te ingoguiri jompiantatsiri carari ira janaitatsi iriro coguiri. Te iroro nopocasite nangaimaguequeri caninatatsiri, irianti nangaimagueque ira cantaguetiro te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cara ititopiantaiga irogomere Joan baotisatantatsiri aisati irogomere bariseo, ipocasitaigapëri Ira Jesos matsiguenga, yosamitapëri: —Ititopiantaiga irogomere Joan aisati irasi bariseo. Ititaiga, yamanocotaiguëri Tosorintsi. Carari pasi pogomere yapaigui aisati yógaiga. ¿Pairo te iritibiritima? ");
INSERT INTO notNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yotabitaigabaqueri Jesos: —Pigóiguë ora ametaiga cara iráque iina sërari. Ingaimaiguëri imatsiguenga, irapajaqueri, inganinataiganaque omagaro. Cara iraretaiguëma, ¿Aroco irititaigapëma? Quero itita iroontita itsibatari ira ágantatsi. ");
INSERT INTO notNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Carari cara iriátë jaanta ira águërone iina, aro irititaiguëma igaimane. ");
INSERT INTO notNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Te ongomeite pinguemisantagarantiro ora yogometaiguimi bariseoegui aisati pingonaguëro nasi nogomeantane. Pigóiguë cara pigabitëro inaga piguitsagare, páguëro inagasite manchaguintsisite. Aroca pigabitantimaro iroraisite, cara ámanaquima ontisaraanaima oquibe ora inagasite piguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aisati pigóiguë ametaiga eiro oguëro irorai oja oba cara iriraimasiquë oisha. Cara onguëchotanë obaa iritopiganëma imasi, quero paparaata. Quero pairi ogantarone oja oba irinagamasiquë. Igóque cara onguëchotanë oja oba intonganë irinagamasi, oparaatëma obaa, aisati iraparaquima imasi. ");
INSERT INTO notNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Cara sábaroquë iquenaiguë Jesos aisati irogomerejegui cara panguirintsisiquë. Ira irogomere yágaiguëro oguitsoterei tirigo. ");
INSERT INTO notNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iniaiguëri bariseo, icantaiguëri Ira Jesos: —Pinetseri pogomere. Jirai isanguenaque Moisés cara quero atarobacaati cara cataguiteriquë comagoriantague. ¿Pairo te inguemisantobitaigueri pogomere? ¿Pairo yobiguibiriquero tirigo yamai sábaroquë? ");
INSERT INTO notNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yotabitaiganaqueri Jesos: —¿Teco pinibatapinintiro Sanguenari ora comantëgotaiguëri David aisati ira itsibata cara jirai págaiguëri itasegane? ");
INSERT INTO notNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aiti pan cara ibangoquë Tosorintsi, ora yobetsiquineri Tosorintsi poguëngani catingasatiquë Iriro. Ora pan iroonti iraperi saseriroti, te iranintacaguiri basini irapero. Carari icanaque David cara ibangoquë Tosorintsi cara inasegui itingomi saseriroti jitacha Abiatar. Ira saseriroti ipabaqueri ira David pan, yapëro David aisati ipaiguëri ira icarataiguira, yapaiguëro aisati iriro. ");
INSERT INTO notNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pinetse, iritsita yobetsiquë Tosorintsi ira matsiguenga. Aique yobetsiquëneri ora cataguiteri comagoriantague. Te irobetsiquëngani matsiguenga asi sábaro. ");
INSERT INTO notNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Iroro nocomantëgotaguëquero sábaro pairoraca anganque cara sábaroquë. ");
INSERT INTO notNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Icanaji Jesos aisati pongotsiquë cara yapatotaiga joríojegui. Tsomagui, ainta sërari camabocori poro ibaco. ");
INSERT INTO notNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ainta matsiguenga inetsaiguëri ira Jesos aroca iragaguibegajiri sábaroquë. Icogaiguë ingantocotaiguëri: “Itarobacaaque Jesos sábaroquë. Te inguemisantiro isanguenare Moisés. Te ingomeite”. ");
INSERT INTO notNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aro Jesos icanqueri ira sërari camabocori: —Atsi paratingue yaca aganguisatiquë cara iraniaiguëmi omagaro. ");
INSERT INTO notNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aique icantaiguëri ira matsiguenga: —Yamai nosamitaiguëmi: ¿Pairo isanguenaque Moisés pairo caninatatsi anganque sábaroquë? ¿Caninataqueco angantiro ora caninaro, oraco angantiro ora te ongomeite? ¿Aganiatiri matsiguenga oraco agamaguëri? Imairetaiganaque. ");
INSERT INTO notNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aro inetsaguetaiguëri Jesos, iguisasërequeri aisati yogasëreca tenta iraninte inguemisantiri. Aro icanqueri sërari ira camabocori: —Pintimagonaguitima pobaco. Aro itimagonaguitanaca. Aito cara ibeganaa ocaninatanai ibaco. ");
INSERT INTO notNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aro isotocaiganaque bariseo cara pongotsiquë cara yapatotaiga joríojegui. Iátasitaiguëri iratirite Eroris, yosamitobaca: —¿Pairoroco anganqueri Jesos, agamaguëri? ");
INSERT INTO notNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Aro iáiganaque Jesos aisati irogomerejegui cara onamijaquë angaare, aisati yoguiataiganaqueri tojai Garireasati, aisati tojai Joreasati, ");
INSERT INTO notNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aisati tojai Jerosaresati, tojai Iromeasati, aisati tojai antatiquerosati, aisati tojai Tirosati aisa Sirósati. Cara iquemocotaiguëri Jesos cara itasonganti, iroro ipocasitobitaigapëri tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesos icanqueri irogomere: —Pomapënaro pitotsi, notetimaro arota quero itsinaquina tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aroquenta yoguibiaguequeri tojai matsiguenga, itsinatsinaitobaca janaitatsiripague, icogaiguë irotsagatiri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ira matsiguenga inantagueca camagari, cara iniaiguëri Jesos yobaticagueritotasipari. Icaimaiguë camagari: —Jesos, Obiro Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aro icantasantaiguëri camagari Jesos: —¿Pairo picomantëcobiriquina? Pomairetaigue, quero picomantëgotina. ");
INSERT INTO notNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aique iáque Jesos cara oguitojaquë, icaimaiguëri irogomere ira icoigaiguë, aro iátasiiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Icoigaiguë icarati 12, icantaiguëri: —Piguiataiguena, pintsibataiguena. Najitaiguëmi nagátane. Aiquenta nagátaguequemi pinguenguitsatomotagueantë. ");
INSERT INTO notNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aisati nagabiaquemi arota pigátaiguëri camagari pijocaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Icoigaiguëri 12: Simón aisati ijiqueri Peroro; ");
INSERT INTO notNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","aisati Santiago itomi Sebereo, aisa Joan ireinti Santiago; ijitaiguëri ira pitirooti Boaneriji ora cantatsi yosiacaro omanarontsi; ");
INSERT INTO notNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","aisati Antiris, Jeripe, Baritoromé, Mateo, Tomás, aisati Santiago itomi Arijeo, Tareo, Simón ira nintasantiro ibaísite; ");
INSERT INTO notNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aisati Joras Cariotisati ira ágagantëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ipigaigapaa pongotsiquë Jesos aisati irogomere. Aitosati yapatobiritaigapari tojai matsiguenga irooti cara te irapabintae Jesos teatisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cara iquemocoqueri imatsiguenga Jesos, iátasitaigabitaari iráganairime ibangosonoriquë. Icantobaca: —Te iraneicotajima Jesos; intsome áganairi. ");
INSERT INTO notNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aisati ipocasitaigapëri Jerosaresati irianti ogomeantiro isanguenare Moisés, icantocotasitaigapari: —Ica sërarica inancari Berisebó aisati ijita Satanás itingomi camagari. Iroro ijogantaguëtari camagari. ");
INSERT INTO notNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aro Jesos icaimaiguëri matsiguenga. Cara ipocaigapë, icantaigabaqueri quingabaguirentsiquë: —¿Atiroco ingantima Satanás irojocajima iriati? Quero icantiro. ");
INSERT INTO notNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aroca irógobaguima matsiguenga timaigatsi quibatsiquë, ¿Queroco itsongabacaga? ");
INSERT INTO notNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aisa icanta matsiguenga pongotsiquë, queroca iquengaiga, querootisati itiomotobaga caninasati. ");
INSERT INTO notNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tesonori iromitocotina Satanás cara nojoguetiri camagari. Ipëgatina. Arome Satanás inguisaiguërime igamagarite, ¿Atiroco ingantima intingomibintaiguëmarime camagarijegui? Querome iquengaiga querome pini iragáantane Satanás. ");
INSERT INTO notNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ira Satanás aisati icantari ibega sërari sintsiri. Aiti ibiane, ichaapite, itongomento, omagaro ora yomisantantaro ibango querota icositiri pairoraca irasi. Carari iribocapëca basini sërari sintsirisonori, irabisapëri isintsire, iragabiapëri, iraguëshotapëri, irágopitapëri irógomento ora yabentabeca, irágopitapëri pairoraca icogui. Carari queroca yoguëshotiquiri quero yágui pairoraca. ");
INSERT INTO notNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aisonori nangantasantaiguëmi cara Tosorintsi irojocaguetajineri matsiguengajegui ora icantagueti te onganinate aisati ora icantasitagueta, quero iguisasëretajiri, ");
INSERT INTO notNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","carari quero icábintsiri ira cantëgotaguetasitaro Isëre Caninaro. Iriátë Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Icanqueri Jesos negaca aroquenta icantocotaguetasicari matsiguenga cara inancari Jesos camagari. ");
INSERT INTO notNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Piátasiqueri iniro Jesos aisati ireinti. Yaratingaigapë sotoquë, icaimagantaiguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tsomagui, isobiaque Jesos yogometaigaseguiri arosonori matsiguenga sobicaigatsi ishongaigacari. Aro icomantaiguëri: —Parepa piniro aisati pirentijegui. Ainta sotoquë; icogaiguini irinibataigapëmi. ");
INSERT INTO notNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yotabitaiganaqueri Jesos: —¿Pairoroco inato? ¿Pairiroco igueegui? ");
INSERT INTO notNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aro inetsaguequeri ira sobicomotaigaseguiri icantaiguëri: —Ocaegui iroro inato, icaegui iriro igueegui. ");
INSERT INTO notNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pairiraca cantatsi ora icocaqueri Tosorintsi, irianti nomatsiguengasonori: najitaiguëri igue, aisati tsio, aisati inato. ");
INSERT INTO notNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aitosati yoniagantaji Jesos cara onamijaquë angaare. Yapatoibiripari tojaisonori matsiguenga irooti yoteantanaca cara pitotsiquë isobiaque. Përo cara inaiguë matsiguenga cara onamijaquë. ");
INSERT INTO notNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tojai yogometaguequeri, yogomeantacaro quingabaguirentsipague. Aro icantaguequeri: ");
INSERT INTO notNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Pinguemaigue: ainta panguitatsiri iáque imiongaguitaguequero oguitsopague tirigo. ");
INSERT INTO notNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Opariguitagarantapë arosata oguitso onamiquë abatsi. Ipocaigapë tsimiripague yapaigapëro oguitso. ");
INSERT INTO notNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Basini tirigoguitso opariguitagarantapë mopësiquë. Te ine tojai quibatsi, aropirigasata arosonorinta mopë osobibatsaquero. Omanaanti piabitanaca; ");
INSERT INTO notNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","cara ijonogatapë paba yogasiguiricapëro tenta ine oparipague. ");
INSERT INTO notNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Basini opariguitë cara totseisiquë; aro piabitanaca tirigo carari ora totsei pogamaguëro tirigo. Te ine oguitso. ");
INSERT INTO notNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aiti basini tirigoguitso pariaquenguitsi caninabatsariquë quibatsi, pianë, piquibianë caninasati, oguitsotasantanë. Aiti panguirintsi oguitsotanë ocarati 30, aisati basini ocarati 60, aisati basini ocarati 100 oguitso. ");
INSERT INTO notNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aitica piguemita ora piquemanta, pinguemisantiro ora nacantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cara iáiganaque matsiguengajegui, ainta Jesos paniro aisati itsibataigari ira aguiataiguëri aisati irogomere icarati 12. Yosamitaiguëri: —¿Pairo ocanti ora posiacagantacái carani? ");
INSERT INTO notNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Icantaiguëri Jesos: —Nocogui pigóigue ati icanta Tosorintsi cara igáanti, ora te ogótingani jirai, carari ira matsiguengapague nogomeantacari quingabaguirentsipague nosiacagantineri tenta iraninte irogóigue. ");
INSERT INTO notNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Inetsabetaigaca carari te iranee, iquemaigabitaca carari te inguemaigue, te irogótaigabaquero ora nacantaigabitacari arota quero ipasiniatitaji querootisati ijocajiro ora icantagueti te onganinate. Iroro quero icábintsaguëtiri Torosintsi. ");
INSERT INTO notNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aisati icantaiguëri Jesos: —¿Teco pinguemaigabaquero oca quingabaguirentsica? ¿Atiroco pingantaiguëma pinguemaiguëro basinipague quingabaguirentsi? ");
INSERT INTO notNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aro noniagaiguëmi ati ocanta iguengabaguire panguitatsiri. Ora oguitso aisati ocantaro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ora pariaquenguitsi abatsiquë ocantari ibega matsiguenga iquemaigabitacaro Irinibare, carari omanapague ipocasiqueri Satanás yágabitsaqueri ora iquemabeca, yomaguisantacaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ora pariaquenguitsi mopësiquë aisa ocantari matsiguenga quemaigabitacaro nanibare. Icaninabentabecaro carari iquemisantabecaro arosata. ");
INSERT INTO notNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yosigaro panguirintsi ora te ine opari omanapague ocamaque. Cara iguisaneintobiqueri imatsiguenga, te përo inguemisantiro nanibare, opomirintsitomotanacari, aro ijocajiro yomaguisantajiro cara iquemisantabeca tenta irogótasantiro. ");
INSERT INTO notNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ora pariaquenguitsi totseisiquë aisati ocantari matsiguenga quemaigabitaro nogomeantane, ");
INSERT INTO notNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","carari iquemisantabecaro arosata. Carari cara iquengasantanëro pairoraca inaguetatsi yaca quibatsica, iquengasantanëri iguireguite inintasantiri, iquengasantanëro inganinabentiro pairoraca icogui inganque, aro yomaguisantanëro Irinibare Tosorintsi, te inguemisantanairo. Te ine oguitso, te ingante ora caninaro. ");
INSERT INTO notNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ora oguitso pariaquenguitsi caninabatsariquë quibatsi, otojaiganaque, aisati ocantaigari matsiguenga porocague iraegui quemisantasantobëro ora nogometiri. Përosati iquemisantanëna, icogui inganque omagaro ora icocaqueri Tosorintsi. Aisa icantaro pibega panguirintsi otojaiganaque openguiterei ora inatsi oguitso ocarati 100, aiti basini cara pinë 60, aisati basini cara ocarati 30 oguitso. ");
INSERT INTO notNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Aisati icantaiguëri Jesos: —Oboqueroca michero, quero oguiro osobiquë cobiti. Querootisati oguiro osobira somamintotsi. Carari oguëroca jonoquë aro ongonijaque pairoraca. ");
INSERT INTO notNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aitica ománocotaga yamai aro ongonijaque aiquenta. Ora te ogótingani yamai ogóquengani aiquenta. ");
INSERT INTO notNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aitica piguemita ora piquemanta, pinguemisantiro ora nacantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aisati icantaiguëri basini: —Yamai pinguengasantiro ora piquemaque. Aroca pigótobëro arosataanti ora nongomantëmi, aisati pingomantiri basini matsiguenga nogomeantane; aroca pigabisëneri ora pigóque, aro tojai nogótacagasantanëmi obiro aisati. ");
INSERT INTO notNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pigóiguë arosata yamai, carari aroca pinguemisantanëna nogótacagasantaiguëmiro nogomeantane. Irari basinipague te ingogue inguemisantina, quero iquemaiguina. Nágabitsaqueri ora iquemabeca, iromaguisanquero. ");
INSERT INTO notNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aisati icanë Jesos: —Cara igáanti Tosorintsi ocantari ibega sërari ipanguitëro oguitso imiongaguitiro cara quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cara isamapë, icabirica pabisanaque tojai cataguiteri. Aro pianë oguitso piquibianë, carari te irogóte casintaro atiraca ocanaca. ");
INSERT INTO notNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Irotsita contepatsine otsoba cara quibatsiquë, aique osi, aique oquibianë opoa, aique ontegatanë onguitsotanë. ");
INSERT INTO notNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cara osamatanë oguitso, aro irobibinguiquero. ");
INSERT INTO notNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aisati icanque Jesos, yosamitaiguëri irogomere: —¿Yamai ati icanta Tosorintsi cara itingomibintiri matsiguenga? ¿Pairo nanganquero nosiacagantiro iragáantane? ");
INSERT INTO notNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Aisati ocantaro pibega oguitso mositasa, iroonti quiripiquirosonori. ");
INSERT INTO notNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Carari omanguitënganica oquibianë, abisëro basinipague panguirintsi. Piquibianë otsegopague, aro pamamegagueta aro ipocasitaiguëro tsimiripague, yogaiguëro imagosipague. ");
INSERT INTO notNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aro tojai Jesos yogomeantaro quingabaguirentsipague, yosiacagantëneri matsiguenga Irinibare Tosorintsi. Aroca iquemobëro arosata, aro arosata yogomequeri. ");
INSERT INTO notNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yameca Jesos yogomeantaigari quingabaguirentsi ira botoibiritaigapari. Iroonti quingabaguirentsi inibatantari. Carari icomantasantaiguëri irogomere casiriconiati ora ocanti quingabaguirentsi. ");
INSERT INTO notNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Irooti cataguiteri cara otsitinitanë, Jesos icantaiguëri irogomere: —Intsome antatinta angaare. ");
INSERT INTO notNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aisati icantaiguëri matsiguenga ira botoibiritaigari onamijaquë: —Yamai atsi pijáigue pobangoquë. Ainta Jesos pitotsiquë. Aro yotetaiganaca irogomere iátocoiguë aiquero antatinta. Aisati yoguiatëgotaiganaqueri basiniquë pitotsipague. ");
INSERT INTO notNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aro ocoguentimapë sintsirisonori, omotoncaatanë nija, potiatanaca pitotsiquë. Pënibaqueme ojaganëmame nija. ");
INSERT INTO notNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ainta Jesos cara otsitíquë pitotsi isamasigui yonaguitosigaro manchaguintsi. Iátasiqueri irogomere, icabocapëri, icantaiguëri: —¡Ogometinari! ¿Pairo te pintsorogobite? ¡Pigabisaicotái! ¡Pënibaque atsiticoiguë! ");
INSERT INTO notNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Icabiritanaca Jesos, icanque: —Omairiatanaeta angaare, osantocotanaeta coguentima. Aito cara osantocotanai coguentima, omairiatasantanai angaare. ");
INSERT INTO notNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aique icanqueri irogomere Jesos: —¿Pairo pitsorogobitaiguë? ¿Pairo terai pinguemisantobitina? ");
INSERT INTO notNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Itsorogasantaiganaque irogomere, iquenganeintasantaigaca, icantobaca: —¿Pairi Ica? Inibatë, oquemisantasantanëri coguentima aisati angaare. Yoguimairenquero. ");
INSERT INTO notNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aro yaretocoiganaca antatinta cara itimaigui Gararasati. ");
INSERT INTO notNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yaguëtanë Jesos cara pitotsiquë. Aro cara itia camatsirini ipaniaca sërari inancari camagari. ");
INSERT INTO notNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Itimi cara itia camatsirini. Te pairi aguëshotantimarine ora coshotsari sogatsa. ");
INSERT INTO notNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aroque tojaitaque yoguëshotapinintaigabitacari imatsiguenga cara iguitiquë aisati ibacoquë carari itimishairo yobëshopiantairo yoguiripijitajiro. Te pairi agabeirine. ");
INSERT INTO notNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Përosati tsitiniriquë aisati cataguiteriquë iátopiantë cara itia camatsirini aisati oguitojapaguequë. Përo cara icaibainteti aisati itobaguecaro mopë. ");
INSERT INTO notNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Iniobëri jaanta Ira Jesos, isigasipari yobaticagueritotasipari, ");
INSERT INTO notNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","icaimapë icampë catsigue: —¿Pairo picantobipëna naro, Jesos Itomi Tosorintsi jonoquënintaberi? Iniaquinanta Tosorintsi, nomanaquemini cara quero pitsipiriacaguina. ");
INSERT INTO notNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Inibatë negaca aroquenta Jesos igáqueri: —Obiro camagari quimingari, pijátopitairi ica sërarica. ");
INSERT INTO notNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aisati yosamitëri Jesos: —¿Pairo pijita? Yotabitanëri: —Tojai najitaiga arosonorinta ninaigui. ");
INSERT INTO notNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Quero pigátaiguina jaanta. Tojai yamanasantobëri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ainta inaigasegui arosonori chancho yapaigasegui cara tongagariquë. ");
INSERT INTO notNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aro ira camagari yamanaiguëri Jesos: —Aroca pijocaiguëna, pigátaiguena cara chanchoeguiquë ninampëmari iriro. ");
INSERT INTO notNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yotabitanëri Jesos: —¡Atsi pijáigue! Aro isotocaiganajiri sërari camagari, inantaigapari ira chanchoegui. Aro isigaiganaca chancho cara tarangaquë, imatsematseiganaque angaarequë tobotn tobotn tobotn. Itsiticaiganaque ijogataiganaca omagaro chancho icarati 2,000. ");
INSERT INTO notNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aro ira omisantaiguiri chancho isigaiganaca icomantagueigapëri imatsiguenga cara poeboroquë aisati togantsipaguequë. Aique iátasitaiguëri Jesos tojai Gararasati iraniaiguëro omagaro atiraca ocanta. ");
INSERT INTO notNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iniaigapëri Ira Jesos aisati ira inabitaca camagari. Ainta isobiaque iguitiquë Jesos, iquitsagasiga, iquengaa caninasati, aisati inibatai caninasati. Aro itsorogaigapë matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ira niaiguëro antagaisati icomantasantaigabaqueri basini ati icanta Jesos yogabisaicoqueri ira inabitaca camagari aisati icomantëgotaiguiri chanchoegui. ");
INSERT INTO notNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aique iraegui Gararasati yamanaiguëri Ira Jesos: —Atsi pijátaje yamai, quero pipocaji yaca aisati. ");
INSERT INTO notNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aro yotetanaa Jesos pitotsiquë. Yamanabecari ira inabitaca camagari: —Nocoguini naguiatanëmi. ");
INSERT INTO notNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Carari te iranintacaguiri Jesos. Icanqueri: —Quero poguiatina, pinëni. Pijátasitiri pomatsiguenga cara pobangoquë, pingomantiri ora icanquemi Tosorintsi tojai icábintsëmi. ");
INSERT INTO notNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aique iáque sërari icomantaguepëri Gararasati antagaisati Tecaporisiquë cara ocarati 10 poeboro ati ocanta cara yogabisaicoqueri Jesos. Iquenganeintasantacari omagaro quemaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aique imontëcotanaa Jesos. Cara yaretaja onamijaquë antatinta, yapatoibiritaigapari onamijaquë tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yarepari sërari jitacha Jairo. Iriro obatacaguiri jorío cara pongotsiquë cara yapatotaiga. Cara iniopëri Jesos yobaticagueritotasipari, ");
INSERT INTO notNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tojai yamanasantapëri: —Pënibaque ongamaque nasinto. Popogopë Obiro pogapënero pobaco arota obeganaima. ");
INSERT INTO notNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aro iátacaqueri Jairo Jesos. Ainta tojai matsiguenga aguiataiganaqueri itsinatsinataiganaqueri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ainta tsinane piraaseti cosamani ocarati 12 osarini, tojai otsipiriaque. ");
INSERT INTO notNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Pipënabentaguetabecari jompiantatsiri omagaro ora pasinta, te aropei te iromitocotëmatiro. ");
INSERT INTO notNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Oquemocotobëri Jesos, aro piátasiqueri itisitaquë Jesos, oquenopë antagaisatiquë matsiguenga, potsagaqueri Jesos cara ocarati iguitsagare, ");
INSERT INTO notNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","oquianca: “Aroca iroonti notsagaitëri onamiquë iguitsagare aroje iragaguibegajina”. ");
INSERT INTO notNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Potsagaqueri, aito cara pibeganaa, aro ocaratanai oraa. ");
INSERT INTO notNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aro igónijinca Jesos cara yogaguibegajiro poro itasorintsitequë. Yapisitaca, yosamitaiguëri matsiguenga: —¿Pairi otsagaitënaro naguitsagare? ");
INSERT INTO notNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yotabitaiganaqueri irogomere: —Ishongaiguëmi tojai matsiguenga itsinatsinataiguëmi. ¿Pairo posamitobiquena: “¿Pairi otsagaitënaro naguitsagare”? ");
INSERT INTO notNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Përosati inetsaguetaiguëri matsiguenga arota iraniaqueri pairiraca otsagaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aro otsoroganë tsinane omogomogoatanaca. Pigóque tigueti ongantima ománanëma, cara igóquero Jesos, aro parepari pobaticagueritotasipari, ocomantëri antagaisati. ");
INSERT INTO notNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Icanquero Jesos: —Nomatsiguenga, aroquenta piquemisanquina nogaguibegajimi. Yamai pijáte pingaigasëretanae, pomagoriasëretanë. ");
INSERT INTO notNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Cara inibasigui Jesos, yarepa iratirite Jairo ipaniaca ibangoquë, icomantapëri: —Aroque ocamaque pisinto. Pitsipiriasica yamai páganëri Ira Ogomeantatsira. ");
INSERT INTO notNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iquemobëri Jesos, yotabitanëri ira obatacaguiri jorío: —Jairo, quero pitsorogui. Patiro pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Te iranintacaguiri quero pairi aguiatirine, irianti ira Peroro, aisati Santiago, aisati Joan ireinti Santiago. ");
INSERT INTO notNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yaretaiganaca ibangoquë Jairo. Iniaigapëri tojai matsiguenga iraicotaiguëro catsiguesonori irisinto Jairo aisati yogasëretocotaigacaro. ");
INSERT INTO notNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aro icanaque Jesos tsomagui, icantaigapëri: —¿Pairo picaibaibiriti? ¿Pairo piraicobiritaiguëro? Teni ongame janequi, pisamini. ");
INSERT INTO notNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Icabíntsátaigabaqueri; aro igátaiguëri antagaisati irisotocaigue sotoquë. Aro yáganëri iri janequi, aisati oniro, aisati irogomere icarati maba, icaiganaque tsomagui cara pinasegui ogamaga irisinto Jairo. ");
INSERT INTO notNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yágobagotapëro obaco Jesos, icanquero: —Tarita, comi. Ocanti: “Janequi, nanganquemi pingabiritima”. ");
INSERT INTO notNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aito cara ocaniatanai, pipigapaa osëre, ocabiritanaa, oparintanaa panëitanai aroquenta pogabisë 12 osarini. Iniaiguëro ira inasegatsi tsomagui, iquenganeintasantaiganaca. ");
INSERT INTO notNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aro icantasantaiguëri Jesos: —Quero picomantëmatiri pairiraca. Pomero operi. ");
INSERT INTO notNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aique iáque Jesos, ipiganaja yaretanaa iguebatsitequë. Yoguiataiganajiri irogomere. ");
INSERT INTO notNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Cara cataguiteriquë ora camagoriantague, icanaque pongotsiquë cara yapatotaiga jorío, yogomeantapë. Iquemaigabaqueri tojai matsiguenga, iquenganeintasantaigacari icantaiganaque: —Ica sërarica, irianti nomatsiguengasonori. ¿Nega opaniaca oca yogomeanti? ¿Nega opaniaca itasorintsite ora itasonganta? ¿Cagarico ira caripintero obetsiquiro mesa, sobicomentotsi, ira otomi María, ireinti Santiago, aisa José, aisati Joras, aisati Simón? ¿Aintasati iritsiroegui otimi yaca poeboroica? Aro itsoingaiguëri, icomëtaigacari, iguisaneintaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Icanëri Jesos: —Ainta quemisantaiguëri ira quinguitsatiro Irinibare Tosorintsi, carari itsoingaiguëri imatsiguengasonori. ");
INSERT INTO notNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tenta inguemisantaigueri cara Nasarequë te tojai iritosongantaguete Jesos cara. Porocagueanti yoguëro ibaco cara janaitatsiriquë, yoguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iquenganeintasantanëri imatsiguenga Jesos tenta inguemisantaigueri. Iquenagueque Jesos poeboropaguequë. ");
INSERT INTO notNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aro yapatotaiguëri irogomere caratatsi 12, igátaguequeri pitenaque, yagobiacagaiguëri irojogantaguequimari camagari. ");
INSERT INTO notNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Icantasantaiguëri: —Nagátaiguëmi yamai, carari quero páganëro pairoraca. Iroonti páganë pigotiqui. Quero páganëro poperi, querootisati pitsaguine, querootisati quirequi. ");
INSERT INTO notNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aisati pisapatote poganëma carari quero páganëro pite piguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aisati icanqueri: —Atiraca pijáiguë, pingapë ibangoquë ira cajemobëmine. Pintiomotiri irooti cara pigaganëma. ");
INSERT INTO notNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aitica poeboro cara te iranintaigue irágacaninataigabaquemi te inguemisantaigabaquemi, popotetanëneri quibatsipane pisapatotequë, aro pigaganëma. Pingantiri: “Tenta pinguemisantobëna, aiquenta iratsipiriacaquemi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aique iquenaguetaiganaque, iquenguitsataguetomotaiguëri matsiguenga: —Pingantaigaima yacaqueroca obirojegui, pijocajiro ora picantaguetira te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tojai igátaiguëri camagari jaara. Aisati itiriantari oguei asaitona tojai ira janaitaguetatsi, yogaguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tojai matsiguenga iquemocotaiguëri Jesos, aisati iquemocoqueri Eroris cobeingari cara Garireaquë. Icanë: —Irirojengari Joan baotisatantatsiri, ira camënguitsi caniatanaatsi. Iroro itasongantaguëti. ");
INSERT INTO notNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Carari icanque basini: —Irianti Erías. Basini icantocotaiguëri Jesos: —Irianti comantantatsiri cantaca ira comantantatsi jirai. ");
INSERT INTO notNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Carari Eroris iquemocoqueri omagaro, icanque: —Irirojengari Joan, ira nibatëacagantabitaca, caniatanaatsi. ");
INSERT INTO notNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Aro jirai Eroris yágabitsaqueri iina ireinti jitacha Jeripe. Iina jitacha Erorías. Icantopiantëri Eroris Joan: —Te ongomeite págabitsatiri iina pirenti. Ocanti isanguenare Moisés: “Quero pinebetaro iina basinipague”. Oguisaneinqueri Joan Erorías, ocogasantabitaca ógagantirime carari te ongantiro tenta iranintacaguiro Eroris ira ojimentaa. ");
INSERT INTO notNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eroris iniacaninatëri ira Joan. Igóqueri Joan caninari, iquemisanqueri Tosorintsi. Te iranintacaguiro Erorías cara ógagantiri. Iquenganeintabitanacari Joan Eroris iquemisantabecari; icogasanti inguemiri carari te inguemisantiri. ");
INSERT INTO notNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aro omoncarapaa cataguitëri cara iquianca Eroris cara inë jirai. Icaimagantaiguëri tojai itingomipague aisati itingomipague soraro aisati basini ira obatacagaiguiri Garireasati. Yapaagaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aro ocanaque osinto Erorías, obairapë. Poganinataiguëri Eroris aisati igaimane. Icantasanotëro Eroris: —Pomanina pairoraca ora pininti. Aro nomëmiro. ");
INSERT INTO notNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cara aisonori iniaquina Tosorintsi, igóque quero namatobitimi, nangantasanotëmi, pairoraca pomanaguetina, aro nomëmiro. Pingoicoquinaca aganguisati nagáantane, aro nomëmiro. ");
INSERT INTO notNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pisotocanai iroro, ocomantëro oniro, ocanquero: —¿Ina, pairo nomanaqueri? Potabitanëro: —Pomaniri ora iguito Joan baotisatantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ocanaji omanapague, ocanqueri Eroris: —Nocoguini yamaica pógagantiri Joan baotisatantatsiri, aique pomabaquinaro tsibetaquë iguito Joan. ");
INSERT INTO notNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Aro tojai yogasëretasantaca cobeingari cara icantasanotëro quero yamatobitiro, aisati aroquenta iquemaiguëri antagaisati igaimane ora icantasanotëro irisintotsari. ");
INSERT INTO notNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aro Eroris igáqueri poro soraro ógantatsiri iriáte omanapague iráquintiro iguito Joan. Iáque cara iromingamentoquë yobatëaqueri ira Joan. ");
INSERT INTO notNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aique yamapënero tsibetaquë iguito Joan, ipëro irisintotsari Eroris. Iroroque opëro oniro. ");
INSERT INTO notNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cara iquemaiguë irogomere Joan, iátasiqueri, yágaiganaqueri igamaga Joan itiajiri. ");
INSERT INTO notNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ipigaigapaa irogomere Jesos. Yapatotaigapa icomantaigapëri antagaisati ora icantaiguë aisati omagaro yogometaiguë. ");
INSERT INTO notNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ainta tojai matsiguenga ira bocasitaigapëri Jesos, aintasati ira pigaiganajacha. Tigueti ingantima irape Jesos aisati irogomere. Aro icantaigabaqueri Jesos: —Intsome casiriconiati arota pomagoriaigue arosata. ");
INSERT INTO notNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aro yotetaiganaja pitotsiquë iátocotaiguë cara tera ontimingani. ");
INSERT INTO notNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Carari iniaigabaqueri matsiguenga cara iáiguë, igótaigabaqueri negaraca iriáiguë. Aro ipaniaigaca poeboropaguequë, isigaiganaca cara onamijaquë, ibataiguëri Jesos aisa irogomere, yaretaigaca teraiquerai iragatocopë Jesos, yoguiaigapëri. ");
INSERT INTO notNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cara yaguëtanë Jesos cara pitotsiquë, iniopëri tojaisonori matsiguenga yapatoibiricari, icantaneintëgotaigapëri inaisiguinta icantaigasega oisha ira te irine ira omisantiri. Aro tojai yogometaigapëri pairoraca. ");
INSERT INTO notNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cara ochapinitanë icantaigapëri irogomere: —Yaca teca ontimingani, aroque ochapinitanë. ");
INSERT INTO notNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yamai pigátaigueri icaegui matsiguenga iriátaguetaje poeboropaguequë aisati togantsipaguequë iromananteta iraperi, tenta ine yaca. ");
INSERT INTO notNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yotabitaiganaqueri Jesos: —Pomaigueri obirojegui ora irapaiguë. Icantaiguëri irogomere: —¿Pairo nangantaiguë? ¿Picogui najáte nomanantë pan ingaraque 200 tenario, nomaguetaiguëri? Querojengari cotonguiboro aguireguite. ");
INSERT INTO notNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yosamitaiguëri Jesos: —¿Ati ocarati inatsi pasiatiegui pan? Atsi pijáte, pinetsero. Cara igóquero irirojegui, icanqueri: —Aiti pabocorooti pan, aisati ainta pite sima. ");
INSERT INTO notNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Icantaiguëri irogomere Jesos: —Pigasobicaigueri antagaisati irisobicagueigue arosatapague cara tobarisiquë. ");
INSERT INTO notNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aro isobicagueiguë. Ainta ira caraquenguitsi 100, aisati basini icarataiguë 50, aisati icantaigaca basinipague. ");
INSERT INTO notNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aique yáguëro Jesos ora pabocorooti pan aisati pite sima, inetsanaque jonoquë, icanqueri Iriri: —Pabati, nacarasiatocoquemiro oca noperijeguica popaiguënaca. Aro itibatsaaguequero pan Jesos, yotsatengaiguëri irogomere arota imaiguëri matsiguengajegui. Aisati yotsatengaigacari sima. ");
INSERT INTO notNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yapaiguë antagaisati, iquemaigaca. ");
INSERT INTO notNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aique yobiitaguetajiro irogomere ora irangarataneegui, iagajiro 12 cantiri. ");
INSERT INTO notNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yapaiguëro pan tojai sërari icarati 5,000. ");
INSERT INTO notNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aique icanque Jesos: —Nogomere, potetaiguema pitotsiquë. Pomontiaiganajima, pobatina antatinta cara Betsairaquë. Yamai nagátaiguëri ira botoibiritaiguina iriáigue ibangopaguequë. ");
INSERT INTO notNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aro igátaiguëri yobetsataiganajari. Aique iáque Jesos oguitojaquë yamanopë, inibataqueri Iriri. ");
INSERT INTO notNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ainta Jesos paniro inë cara otsitinitanë. Ora pitotsi pinë aganguijaquë. ");
INSERT INTO notNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iniaiguëri irogomerejegui icomatabitacaro pitotsi, carari poguipigapigatocoqueri sintsiri coguentima. Aro igogaraaque iáque Jesos aiquero pitotsiquë, yanëiaapë jonoicaa angaarequë, te iritsitigue. Irabisanaquerime, ");
INSERT INTO notNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","carari iniaigabaqueri yanëiaapë jonoicaa nija, icaibaitaiguë icantobaca: —¡Eeee! ¡Coraque camagari cara iráganacái! ");
INSERT INTO notNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Antagaisati iniaigabaqueri, itsorogasantaiganaqueri. Aro yotabitaigapëri Jesos: —Quero pitsorogui. Naanti bocapaatsi, pinganinasëretanëtigue. ");
INSERT INTO notNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aro yotepa Jesos pitotsiquë, itsibataigaari. Aito cara osantocotanai coguentima; iniaiguëro irogomere iquenganeintasantaiganaca. ");
INSERT INTO notNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aisati icanta iniaigabitacaro pan cara itasonguëro Jesos carari te inguengairo. Aisati iniaigabitacari Jesos cara yanëiaquero nija, carari terainta irogótiri Irironta Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aro imontiaiganaja. Yaretaiganaja Jenesarequë. Yoguëshotëgotaigapëro ibito. ");
INSERT INTO notNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cara yaguëtaiganaque, igótobëri Jesos matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Cara igóiguë ainta Jesos aro isigaiganaca icomantobaguetanaca matsiguengajegui poeboropaguequë, yamaigapëri janaitaguetatsiri yamantaguepari jatasintsi. ");
INSERT INTO notNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iquenagueque Jesos poeboropaguequë aisati togantsipaguequë. Negaraca iáque, yamapëri janaitatsiri, yoguëquineri iraganguitëirequë cara iniobëri Jesos yamanaiguëri: —Pinintacaguina notsagaitimiro piguitsagare cara ocarati. Aro yogaguibegajiri antagaisati ira otsagaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aro yapatoibiritaigapari Jesos ira bariseopague aisati ira ogomeantiro isanguenare Moisés. Ipaniaigaca Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iniaigapëri irogomere Jesos cara yapaigui; te inguibocotima. Icantaiguë bariseo: —Caninataque inguibocotaiguema queroquerai yapi arota iraganinasëretima. Cara te inguibocotima, iroonti quimingari ibaco. ");
INSERT INTO notNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yametaiga bariseoegui aisati omagaro joríojegui queroca iquibocotasanta, quero yapi, cara yametaiga jirainisati aisati yogometaiguëri ira jorío. ");
INSERT INTO notNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cara iripigaima cara poeboroquë cara yapatotaiga matsiguenga ipimantagueti pairoraca, queroca iquibocota jorío, quero yapi. Aisati yametaiga inguibopiantiro pairoraca basini: pojo, pachaca, oya, omagaro. ");
INSERT INTO notNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aro ira bariseo aisati ogomeantiro Sanguenari yosamitaiguëri Ira Jesos: —¿Pairo te irometaigabiritimaro pogomere ora yametaiga omatsiguenga jirai? Yapantaigacaro ibaco quimingari. Icantagueti ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yotabitaiganaqueri Jesos: —Obirojegui matobiantatsiri cara aisonori icomantëgotaiguëmi Isaías cara isanguenaque jirai: Icanë Tosorintsi: “Ica matsiguengaca inibatasitëgotina ora caninaro, carari te inguenganeintina. ");
INSERT INTO notNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yamanocotasitina carari yapatotasitaiga; iroonti yogomeantaigui irasi matsiguenga”. ");
INSERT INTO notNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisati icantaiguëri Jesos: —Teni pinguemisantiro ora icanquemi Tosorintsi, pijocasicaro; iroonti piquemisantasica ora yogomeanti matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cara pametaigaro iroonti irasi pomatsiguenga, pitsoingaiguëro ora icanque Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Isanguenaque Moisés: Pinguemisantiri piri aisati piniro. Ingameta ira cantëgotaguetasitari iriri aisati iniro. ");
INSERT INTO notNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Carari obirojegui, pogometaiguëri pomatsiguenga: “Pingantiri ira asintimi: ‘Quero nomitocotimi. Nomëmime quirequi, nangantaneintëgotëmime carari aroque natsita nacanqueri Tosorintsi nopëri Iriro naguireguite’ ”. ");
INSERT INTO notNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Cara picanque negaca, te pinintacaguiri ingábintsairi iriri aisati iniro, ");
INSERT INTO notNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","te pogomeantiro Irinibare Tosorintsi, teatisati pinguemisantiro. Iroonti piquemisantaiguëro ora yametaiga pomatsiguenga jirai aisati pogaganëneri basini. Aitosati aiti tojai ora picanque cantacha nega. ");
INSERT INTO notNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aique Jesos icaimaiguëri ira botobiritaigari, icantaiguëri: —Pinguemina, obirojegui, pigótiro oca nocomantaiguëmica: ");
INSERT INTO notNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","caninataque opaiguero pairoraca queronta poguimingatiro asëre. Orari ora inibatasitagueta iroro aguimingasëretacái cara aquianquero quimingaro. ");
INSERT INTO notNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aitica piguemita ora piquemanta, pinguemisantiro ora nacantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Aro ijocaiganaqueri matsiguenga botoitacha sotoquë, icanaji Jesos pongotsiquë cara yosamitëri irogomerejegui: —Teni nanguemimi; pingomantina ora ocanti picantaiguëri matsiguenga yamai. ");
INSERT INTO notNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yotabitanëri Jesos: —¿Teraico pigóte obirojegui aisati? ¿Teco pigóte pairoraca opë ojáque asegotoquë aique agabisairo? Te ongantiro pairoraca asërequë. Iroro yogomeantaguëque cara antagaisati perintsi caninaro opëro. ");
INSERT INTO notNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aisati icanque: —Ora paniacha iraneingomentoquë matsiguenga, ora iquengagueta, iroro aguimingatëri. ");
INSERT INTO notNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ora iquenga matsiguenga opaniaca tsomagui. Iquenguiro quimingari, aique icanquero te onganinate. Cara intaguetiro tsinane cagaro iina aisati cara tsinane ontaguetiri sërari cagari ojime; cara icositanti; cara yóganti; ");
INSERT INTO notNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cara inebetaro ora irasi basini; cara icantagueti pairoraca te ongomeite; cara yamatobianti; cara inintasanotëtiri ora yasinta basini; cara icantocotaguetasitari basinipague matsiguenga; cara iquengasita caninari iriati; cara te inguengueri Tosorintsi; ");
INSERT INTO notNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","antagaisati ocapague paniacha cara iraneingomentoquë matsiguenga. Iroro oca aguimingataguetiri; carari Tosorintsi iniaqueri matsiguenga cara icantaguetiro quimingari. ");
INSERT INTO notNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Aique iáque Jesos aronisatiquë Tiro. Icanaque pongotsiquë, te iraninte irogótirime matsiguenga, carari tigueti ingantima irománima. ");
INSERT INTO notNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ainta tsinane, ora osinto inancaro camagari. Cara oquemocoqueri Jesos, piátasiqueri pobaticagueritotasipari iguitiquë Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iroro cagaro jorío, opaniaca cara Sirojenisiaquë. Pamanopëri Jesos: —Inancaro nasinto camagari. Pigátajinero. ");
INSERT INTO notNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Icanquero Jesos: —Nipocasique naguibatëri nomatsiguengasonori nomitocoqueri iriro. Caninataque irapeta iritsita janequi. Te ongomeite ágabitsatiri pan janequi arota omionguëneri otsiti itiomijani. ");
INSERT INTO notNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Carari potabitanëri: —Aisonori ora picanque, Natingomi, carari yapiro otsiti opetoqui ora yobariaguetaigui janequi. ");
INSERT INTO notNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Icanquero Jesos: —Caninataque piquemisanquena. Yamai pijátaje. Ira camagari aroque isotocanairo pisinto. ");
INSERT INTO notNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aro pipiganaja obangoquë, oniopairo osinto pinariasega osamamentoquë. Aroque isotocanairo camagari. ");
INSERT INTO notNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aique yogaganaca Jesos, iquenaque Tiroquë, Sirónquë, aisati Tecaporisiquë cara pini 10 poeboro. Yaretaja angaarequë jitacha Garirea. ");
INSERT INTO notNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yamaigapëri poro sërari maguemitari aisati te irinibatasante. Yamanaiguëri Ira Jesos iroguineri ibaco iragaguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ainta tojai matsiguenga. Aro Jesos yáganëri casiriconiati, yomianquineri ibatsapaco cara iguemitaquë. Ijobabococa, yotsaganinequeri ira te irinibate cara ininequë. ");
INSERT INTO notNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aique Jesos inetsanaque cara Jonogaguitequë, yaneingasantanë, icanque: —Epeta. Epeta ocanti pishapiriaguemitatanaima. ");
INSERT INTO notNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aro ishapiriaguemitatanaa, iquemasantanai. Aisati posebatanaa inine, inibatasantanai. ");
INSERT INTO notNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aro icantasantaiguëri Jesos: —Quero picomantëmatiri basinipague matsiguenga. Carari te inguemisantaigueri, aiquero icomantëgotanëri. ");
INSERT INTO notNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ira matsiguenga iquenganeintasantëri Jesos, icantaiguë: —Antagaisati icanque caninari. Iquemacaguiri maguemitari aisati inibatagairi ira te irinibate caninasati. ");
INSERT INTO notNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Basiniquë cataguiteri aisati yapatotaigaa tojai matsiguenga. Te inëmate iraperi. Jesos icaimaiguëri irogomere, icantaiguëri: ");
INSERT INTO notNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Tojai nacantaneintëgotaiguëri icaegui botobiritaiguënaca. Ocarati maba cataguiteri itsibataiguëna, yamai te inae iraperi. Itasegasantaiguëni. ");
INSERT INTO notNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yamai aroca nagátaiguëri iriáigae, iromagotasantanë queronta yapi, quero yaretaigaa ibangopaguequë. Ainta paniacha jaanta. ");
INSERT INTO notNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yotabitaiganaqueri irogomere: —Pinetse, yaca teca ontimingani. ¿Nega nágaiguineri pan ora irapaiguë? Tojaini ini. ");
INSERT INTO notNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yosamitaiguëri Jesos: —¿Ati ocarati pan inatsi? Icantaiguëri irogomere: Siete ocarati. ");
INSERT INTO notNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aro icantaiguëri matsiguenga Jesos: —Pisobicaigue quibatsiquë. Aique yáguëro pan ocarati 7, icanqueri Iriri: —Aro nega, Pabati, nacarasiaquemiro popabaquinaro oca perintsica. Aique itibatsaaguequero yotsatengaiguëri irogomerejegui arota irotsatenguimaro ira bototaigacha. ");
INSERT INTO notNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aintasati arosata isibaite. Icarasiatocoqueri, icantaiguëri irogomere: —Pomaguetaigueri sima aisati. ");
INSERT INTO notNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yapaiguë antagaisati, iquemaigaca. Aique yobiitaguetajiro ongarataga, iagajiro cantiri oquibe ocarati 7. ");
INSERT INTO notNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ainta icarati 4,000 matsiguenga ira paiguënguitsi. Aique igátaigairi yobetsataiganajari Jesos: —Yamai pijáigae pobangopaguequë. ");
INSERT INTO notNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aique yotetaiganaja Jesos aisati irogomere pitotsiquë, imontiaiganaca irooti cara quibatsiquë jitacha Tarimanota. ");
INSERT INTO notNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ipocasitaigapëri bariseopague. Isintsitsapëri, icampëri: —Atsi yamai nocogaiguini nanetsemi cara pitasonganti arota nogótimi aroca popaniaca Jonagaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aro yaneingasantanë Jesos, icantaiguëri: —¿Pairo yamanobitina icaegui matsiguengaca cara natasonganque? Aisonori nangantasantaiguëmi cara quero noniaguëmatiri, quero nitasonganti. ");
INSERT INTO notNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aique iáque ijocaiganaqueri bariseo, yotetaja aisati pitotsiquë iátocotaji antatinta. ");
INSERT INTO notNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yomaguisantanë irogomere iráganëro pan. Patiro yáganë. ");
INSERT INTO notNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Icantaiguëri Jesos: —Pigamaiguemaro ora piponganta pan irasi bariseoegui aisati irasi iratirite Eroris. ");
INSERT INTO notNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aique yosamitobagaigaca irogomere: —¿Pairo icantobicái: “Pigamema ora piponganta pan irasi bariseo”? Tentajengari nomapëro pan. ");
INSERT INTO notNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Igótocotaiguëri Jesos, icanqueri: —¿Pairo pijibiritaiguë nacantocoquemiro pan? ¿Terai pingueme teraisati pigóte ora nacantaiguëmi? ¿Teco pinguengaiguena? ");
INSERT INTO notNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Aiti piroqui, ¿Pairo te piniantobitimaro? Aiti piguemita, ¿Pairo te pinguemantobitimaro? ¿Teco pinguengairo? Cara natibatsaaguequero pabocorooti pan napaagaiguëri 5,000 sërari, ¿Ati ocarati cantiri piagaji ora ongarataga? ");
INSERT INTO notNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yotabitaiganaqueri: —Aro ocarati 12. ");
INSERT INTO notNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Përosati icantaiguëri Jesos: —Aisati aique ocarati 7 pan, aisati nopaguetaiguëri pan matsiguenga icarati 4,000. ¿Ati ocarati pobiitaguetaji cantiriquë oquibe? Icantaiguëri: —Ocarati 7 cantiri. ");
INSERT INTO notNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aro icantaiguëri Jesos: —¿Terai pigóigue cara te nangantocotaiguemiro pan? Nacantocotaiguëmiro irogomeantane bariseo. ");
INSERT INTO notNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Aisati yaretaigaa Jesos aisati irogomere Betsairaquë. Yamaigapëneri comarajari, icantaigapëri: —Potsagatiri piniacagajiri. ");
INSERT INTO notNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aique Jesos yáganëri comarajari ibacoquë icatsatanëri sotoquë poeboro casiriconiati. Ijobaoquiqueri iroquiquë, yoguëneri ibaco Jesos cara comarajariquë. Yosamitëri: —¿Ainta pinei arosata? ");
INSERT INTO notNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Inetsë, yotabitanëri: —Jee, naniabecari sëraripague carari te ingonijataigue caninasati, icantaigacaro pibega anchato, carari yanëitaiguini. ");
INSERT INTO notNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aitosati Jesos yogaineri comarajari ibaco. Aique inetsai, ibeganaa, iniasantai caninasati. ");
INSERT INTO notNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aro igáqueri Jesos: —Quero piáti poeboroquë, quero picomantiri basini, aroonti pijátaje pobangoquë. ");
INSERT INTO notNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Aique iáque Jesos, itsibataiganacari irogomere aiquero poeboroquë jitacha Sesária Jeripo. Cara aganguipoqui abatsi Jesos yosamitaiguëri irogomere: —¿Pairo ijitaiguina matsiguenga Naro? ");
INSERT INTO notNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yotabitaiganaqueri: —Aintapague ijitaiguëmi Obiro Joan baotisatantatsiri. Ainta basini icantaiguë: “Ira Jesos Irianti Erías, ipocaji”. Aintasati ijitaiguëmi Obiro comantantatsiri jirai ipigapaa. ");
INSERT INTO notNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aro yosamitaiguëri: —¿Pairo picantaigui obirojegui? Yotabitanëri Peroro: —Obiro Quirisito Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesos icantasantaiguëri: —Aisonori picanti, carari quero picomantaguetiri matsiguenga cara Naro Quirisito. ");
INSERT INTO notNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aique iparintaca Jesos yogometaiguëri irogomere icantaiguëri: —Pigóiguë nopaniaca Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Yamai pënibaque najáque Jerosarénquë. Cara, iratsipiriacagaigabaquina antiasipari aisati itingomiegui saseriroti aisati ira ogomeantiro isanguenare Moisés. Aisati irógaiguëna, carari ongaraque maba cataguiteri, nanganiatanae aisati. Ocari oca icantabecari catingasati. ");
INSERT INTO notNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aro yáganëri Peroro casiriconiati ipëgatsacari: —Natingomi, te onganinate oca picanqueca. Querota picami. ");
INSERT INTO notNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yapisitasicari Jesos, inetsaiguëri irogomere, isintsitsaqueri Peroro: —Pijáte, picanquina aisati picantari ibega Satanás. Quero pintaguinaro ora te onganinate. Te pigóte ora icocaquina Tosorintsi, iroonti pigóque ora icogui matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aique Jesos icaimaiguëri ira botoibiritaigari aisati irogomere, icantaiguëri: —Iranintasantëca pairiraca iraguiatanëna inguemisantasantina, iranatanëro igorosite, quero icantanonta iriati, iroonti përosati iromomirintsibenquinaro pairoraca nongocaqueri Naro. ");
INSERT INTO notNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ira cogabitacha ingábintsëma yaca quibatsica, tenta iraninte iratsipiriero, aiquenta iratsipiriasantë. Irari quemisantasantënane yaca quibatsica quero ipasiquitina querootisati ipasiquitiro Caninaro Nibarintsi, irooti cara ingamobiquina Naro, aiquenta intiomoquina përosati Jonogaguitequë, intimasantanë caninasati. ");
INSERT INTO notNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aintaca sërari irasintaguetimaro antagaisati ora inatsi yaca quibatsica, aique ingamaque iriátë Sharincabeniquë, ¿Pairo iráque? ¿Teco iratsipiriasiquimaro omagaro? ");
INSERT INTO notNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aroca iriátë Sharincabeniquë, tiguetisonori ine pairoraca ingantima iriáteme Jonogaguitequë, inganiatanaeme. ");
INSERT INTO notNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pairiraca pasiguitëgotina Naro aisati ipasiquitocotiro nanibare yaca quibatsica cara itimaigui tojai tsoengatsiri cantagueantatsiri te onganinate, aisati nopasiquitocoqueri iriro cara nopigaima. Nopigaima nongobeingatasantapë nosangueguitetasantapë aisati icanta Pabati icobeingatasanti yosangueguitetasanti, intsibataigapëna ironomireegui Pabati irisaanganetsite caninari. ");
INSERT INTO notNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aisati icantaiguëri Jesos: —Aisonori nangantasantaiguëmi, nogomerejegui, aintapague obiroquë queroquerai cara picami irooti cara piniaigabaquina nopocaje Naro iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aro pabisanaque 6 cataguiteri cara Jesos itonganaque oquibequë oguitoja. Yágaiganaqueri casiriconiati ira Peroro aisati Santiago aisati Joan. Aro ipasiniatitomoqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Oquetatasanotanë iguitsagare. Teni irine yaca quibatsica inguibiroca quitsagarintsi catarosonori aisa pibega oca. ");
INSERT INTO notNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aisati iconijatomopëri Moisés aisati Erías inibatagaiguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aro icanqueri Peroro: —Ogometinari, caninataque inaigae yaca. Intsome obetsique yaca maba pongotsi otiomijani, patiro pasi, patiro irasi Moisés, aisati basini irasi Erías. ");
INSERT INTO notNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Te irogóte Peroro pairoraca inganque, inibatasita itsorogasantaiganaquenta ira maba. ");
INSERT INTO notNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aito cara omabocapari mingori paguëtaguëpëri, poganguibotaiganaqueri. Aro iquemaiguëro Irinibare Tosorintsi cara mingoriquë, icanque: —Ica Notomi nanintasantiri. Pinguemisantaigueri Iriro. ");
INSERT INTO notNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Iroguito, inetsabetanaa. Te iraniajiri Erías, teatisati Moisés; panibani Jesos inanai. ");
INSERT INTO notNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aique cara yanongaiganaja, icantasantëri irogomere Jesos icantaiguëri: —Quero picomantëgotiro oca piniaiguëca. Aiquenta cara nangamaque aisati nanganiatanae, aro pingomantaigueri basini matsiguenga. Pingomantëgotina Naro omagaro ora pigótocoquina aisati cara nopaniaca Jonogaguitequë aisati nomatsiguengatapë. ");
INSERT INTO notNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aro te ingomantëgotiri, patiro iquengasitanaca, yosaminatobaganaca iriati: —¿Pairo icomanti Jesos cara icanque ingamaque aisati inganiatanae? ");
INSERT INTO notNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aro yosamitaiguëri Ira Jesos: —Ira ogomeantiro Sanguenari cantatsi: “Iribocapae iritsita Erías queroquerai ipoqui Quirisito Ira Agabisaicoontatsi”. ¿Pairo yogomebirique oca? ¿Pairo te iribocobipë Erías? ");
INSERT INTO notNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yotabitaiganaqueri Jesos: —Aisonori icantaiguë: “Ingonijapae Erías, irobetsicaigapëri omagaro”. Carari pinguenguero oca: ¿Pairo isanguenatocobiriquina Naro matsiguengatapënguitsine, natsipiriaquero, aisati iromaintaigabaquina matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yamai nongomantaiguëmi cara aroque ipocaji Erías carari te irágacaninataigabaqueri matsiguenga, icantaiguëri pairoraca ora inintaiguë, itsipiriacagaigabaqueri, yógaiguëri aisa ocanta cara isanguenatococa Sanguenariquë. ");
INSERT INTO notNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cara yanongopaa Jesos, iniaigapëri arosonori matsiguenga. Aintasati irapague ogomeantiro isanguenare Moisés inibataigaseguiri irogomerejegui Jesos icarati 9. ");
INSERT INTO notNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aro iniaigabaqueri Ira Jesos, iquenganeintasantaigabacari. Isigasigaitasipari matsiguengajegui, yobetsataigabacari. ");
INSERT INTO notNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yosamitaigapëri matsiguenga Jesos: —¿Pairo pinibabiritaiguëri nogomere? ");
INSERT INTO notNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yotabitanëri poro sërari: —Ogomeantatsiri, namabitapari notomi inancari camagari. Yomasontiaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cara iráquerica camagari intingaraacaquimari, irobariaqueri quibatsiquë, irisimaresetaganëri ibagantequë; iratsitsiaguitetanë, ingantsirongatanë. Namanabecari pogomere iragátajineri igamagarite carari te iragabeiri. ");
INSERT INTO notNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yotabitaiganaqueri Jesos, icantaiguëri: —¡Te pigóiguero Irinibare Tosorintsi! ¡Terai pinguemisantaiguero obirojegui, terai pinganinataigue! ¿Ati ongantima nantsibataiguëmi natsipiriasita cara nogometasitaiguëmi? Tojai pitsoingaiguëna. Atsi pomapënari pitomi. ");
INSERT INTO notNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Cara yamapëri janequi, itingaraacaganacari camagari, imogomogoataganacari, yotëanëri janequi quibatsiquë, ititigabaguetacaganacari, yosimaresetanëri aisati. ");
INSERT INTO notNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesos yosamitëri iriri: —¿Ati ocanta iparintaca cara icanca nega? Yotabitanëri iriri: —Irinaga jirai cara itiomijaniquerai. ");
INSERT INTO notNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tojai yobarigopiantiri camagari cara tsitsiquë aisati nijaaquë, icogabeca iragamaguerime. Aroca pigabeiro pinganquero pairoraca, aro pingantiro yamaica. Pingantaneintëgotaiganaquina, pomitocotaiguena naro aisati notomi. ");
INSERT INTO notNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Icanqueri Jesos: —¿Pairo picantobiquina: aroca nagabeiro? Atsi obiro. Aroca pinguemisanqueri Tosorintsi, aro inganquimiro pairoraca. ");
INSERT INTO notNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aro icaimanë iriri janequi: —¡Naquemisantabetimi! ¡Nocoguini pinguemisantacagasantina! ");
INSERT INTO notNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iniaque Jesos cara yotsititaigapari tojai matsiguenga, aro isintsitsaqueri camagari, igáqueri: —Obiro camagari mosontitagantatsi aisati maguemitatacagantatsi pisotocanairi, quero pinantajari ica janequica aisati. ");
INSERT INTO notNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aro icaimanë camagari, imogomogoataganacari ira janequi, isotocanai. Iriroque janequi icanacari ibega igamaga. Icantaiguë tojai matsiguenga: —Aroque icamaque. ");
INSERT INTO notNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Carari Jesos yágobagotëri ibacoquë janequi icabiritajiri, yogaratingajiri, ibeganaa. ");
INSERT INTO notNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aique icaiganaque pongotsiquë Jesos aisati irogomerejegui, yosamitaiguëri casiriconiati: —¿Pairo te nagabiobitiri nagátiri ira camagari? ");
INSERT INTO notNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yotabitaiganaqueri Jesos: —Ica irianti basiniati camagari, sintsiri ini. Patiro iriátë aroca pomanocotasantiri Tosorintsi aisati aroca pititima, aro iragabiaquemiri pigátiri jaara. ");
INSERT INTO notNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aique iáiganaque Jesos aisati irogomere, iquenagueque Garireaquë. Te iraninte Jesos irogóte pairiraca negaraca ini Iriro ");
INSERT INTO notNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","yogometaiguirininta irogomere. Icantaiguëri: —Nopaniaca Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Carari irácagantaiguëna matsiguenga, irógaiguëna. Ongaraque maba cataguiteri, aro nanganiatane. ");
INSERT INTO notNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ira irogomere te inguemaigabaquero irogomeantane Jesos, icomëtaigabacaro. Aisati itsorogaiguë irosomitiri pairoraca icanti. ");
INSERT INTO notNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yaretaiganaca Caperinaoquë, icaiganaque pongotsiquë. Jesos yosamitaiguëri irogomere: —¿Pairo pinibatobagopa abatsiquë? ");
INSERT INTO notNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Te irotopitaigueri, imairetaiganaque aroquenta cara abatsiquë inibatobagopa iriati pairi obaquenguitsine irirojeguiquë. ");
INSERT INTO notNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Isobigopë Jesos, icaimaiguëri irogomere icarati 12, icanqueri: —Pairiraca nintatsi irobate, caninataque ingarantanë, iromitocotaigueri antagaisati basini aisa inganquima iromeraro. ");
INSERT INTO notNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Icaimëri poro janequi Jesos. Yogaratianqueri aganguisatiquë irogomerejegui, yabitsinacobëri. Icantaiguëri: ");
INSERT INTO notNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pairiraca ágacaninatërine poro janequi cantacha ica iquemisanquinanta, aisati irágacaninatina Naro. Pairiraca ágacaninatenane, aisati irágacaninatiri Ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Icanqueri Joan: —Ogometinari, naniaiguëri sërari igáqueri camagari iriátopitiri matsiguenga. Icantabequina cara iquemisanquemi inibatantaro popairo, iroro igáantantari camagari. Tenta intsibataiguena naroegui, nacantaiguëri: “Quero pigáantantaro iripajiro Jesos cagaribinta obiro nasiegui”. ");
INSERT INTO notNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yotabitanëri Jesos: —Quero pometopitari. Queroca iguisasitái, iromitococái. Quero icantocotaguetasitina. ");
INSERT INTO notNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Queroca ipëgatái, aisa icancái ibega eiro. ");
INSERT INTO notNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aisati icanqueri Jesos: —Pairiraca pëcoquimine pomire piquemisanquinanta, nangantasantëmi iraniaqueri Tosorintsi imëri iriro aroquenta icábintsabaquemi obiro. ");
INSERT INTO notNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Aisati pairiraca antaquerine janequi quemisanquina ora te onganinate, natsipiriacaqueri. Caninataqueme ingamaque queroquerai intaguiri ora te onganinate, aisa onganquimame iraguëshotëgotanquimari oquibe mopë itsonoquë, irojoqueri angaarequë ingamaque. ");
INSERT INTO notNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nosiacagantëmiro. Aroca ontaquimi pobaco ora te onganinate, pijocajiro ora picantagueti quimingari. Pobetsiquiro pisëre aisatime ongantima pitotirome pobaco pijoquerome. Caninataque pine paboconirobi cara Jonogaguitequë, arota quero piátacaguiro pite pobaco cara Sharincabeniquë cara pini tsitsi ora te otsibacanete, ");
INSERT INTO notNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","aisati cara te ingame oguentiniropague aitosati cara tera otsibacanete tsitsi. ");
INSERT INTO notNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aisati aroca ontaquimi piguiti ora te onganinate pijocajiro ora picantagueti quimingari. Pobetsiquiro pisëre aisatime ongantima pitotirome piguiti pijoquerome. Caninataque pine paguitinirobi cara Jonogaguitequë, arota quero piátacaguiro pitirooti piguiti Sharincabeniquë ");
INSERT INTO notNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","cara te ingame oguentiniropague aitosati cara te otsibacanete tsitsi. ");
INSERT INTO notNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aisatica ontaquimi piroqui ora te onganinate pijocajiro ora quimingari. Pobetsiquiro pisëre aisatime ongantima páguirome pijoquerome piroqui. Caninataque pijáte paoquinirobi cara Jonogaguitequë, querota piátacaguiro pitirooti piroqui cara Sharincabeniquë ");
INSERT INTO notNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","cara te ingame oguentiniropague aitosati cara te otsibacanete tsitsi. ");
INSERT INTO notNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Antagaisati matsiguenga iratsipiriaque yaca quibatsica. Ora atsipiriagantsipague ongatsitëri quemisantatsiri onganquimaro pibega tsitsi, carari aisa oganinatëri osigaro onganinataganëro patiari ora ibatsa cara itaquineri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ocaninati patiari, carari omeganëmaca ora cochotacaguiro, ¿Pairo aguipigapairone ora cochotacaguiro? Aisati obirojegui pingantimaro patiari; aroca págacaninatobaganëma, pintiomotobaguima caninasati, pinguengasëretima caninasati, aro pinguemisantacagaigueri basinipague matsiguenga. Caninataque piniacaninatobaganëma págacaninatobaganëma, pintiomotobaganëina, piganinataguetiri ira basinipague. ");
INSERT INTO notNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aique iáiguë Jesos aisati irogomere, yaretaigapa Joreaquë, imontiaiganacaro ora nija jitacha Jorirán. Aique yapatobiritaigacari tojai matsiguenga. Cara yameta Jesos, yogometaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Iátasitaiguëri Jesos bariseopague; icogabeca iraniantëmari irantacaquerime te onganinate. Yosamitaigapëri: —¿Caninataqueco irojocajiro iina sërari? ");
INSERT INTO notNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yotabitaigabaqueri Jesos: —¿Pairo isanguenataiguëmi Moisés jirai? ");
INSERT INTO notNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Icantaiguëri bariseopague: —Icanque Moisés: “Aroca iritsirishanëmaro iina sërari, irisanguenatënero, ingomantëro: ‘Nocoguini nojocajimi; pijátaje’. Imëro sanguenari ora irojogantëmaro”. ");
INSERT INTO notNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Icantaiguëri Jesos: —Icanque Moisés cara caninataque pijocajiro pijina tenta pinganinataigue. ");
INSERT INTO notNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Carari cara pobetsiquengani antagaisati jirai, Tosorintsi yobetsiquëri ira sërari aisati tsinane. ");
INSERT INTO notNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iroro cara iráquero iina sërari, irojocanëri iriri aisati iniro, ");
INSERT INTO notNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","irágasantëro iina, intimacaquero casiriconiati. Coshoni iroquimaro, ingantajima paniro ibatsa. Jirai inabitaca sërari aisati iina; yamai coshoni irogobaguima, intimaiguë inganguima paniro. Iniaiguëri Tosorintsi irianti paniro ibatsa. Ipanirootitaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iroro te onganinataguëte irojocobagajima. Querootisati ijocaguiri basini matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cara ipigapa Jesos pongotsiquë, yosamitaiguëri irogomere pairo icanti. ");
INSERT INTO notNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Icantaiguëri Jesos: —Aintaca sërari irojocajiro iina, iráque basini tsinane, aroque yaguimintacaro iinasonori ora ijoque jirai. Te inguemisantiro ora icanti Tosorintsi: “Quero pintantopitiro pijinasonori”. ");
INSERT INTO notNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aitosati pairoraca joquërine ojime páguëri basini sërari aisati paguimintari ojimesonori, te onguemisantiri Tosorintsi ora icanque: “Quero pintantopitiri pijimesonori”. ");
INSERT INTO notNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aique yamapëngani itiomijani janequipague cara Jesosiquë, icogaiguë cara irogaguetineri ibaco Jesos iguitopaguequë janequi iromanocotiri ingábintseri Tosorintsi. Carari iniaigabaqueri irogomere, imetaigacari Ira Jesos, icantaigabaqueri, isintsitsaqueri: —Quero paseriguiri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iniaiguëri Jesos iguisatsataiguëri irogomere, icantaiguëri: —Quero picantiri. Nocogui iribocasitaigapëna janequijegui. Igóiguë iriro intingomintina. Antagaisati icantaigari ibega ica intiomoquina cara itingomibintanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aisonori nangantaiguëmi: icaegui janequi inintaiguë intingomintimari Tosorintsi; pairiraca te intingomintimari aisati ingantima ibega janequi, quero yareta cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aique yágobëri janequipague Jesos itsomaguetobëri panirootipague, yoguëneri ibaco iguitoquë yamanocotaiguëri: —Iromitocotimita caninasati Tosorintsi, ingábintsemita. ");
INSERT INTO notNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cara iáque Jesos abatsiquë, isigopa poro sërari yobaticagueritotaguëpari Jesos, yosamitëri: —Caninari Ogomeantatsiri, ¿Pairo nanganque arota përosati nantimanë canta Jonogaguitequë? ");
INSERT INTO notNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yotabitanëri Jesos: —¿Pairo picantobiquina Naro caninari? Paniro ini caninari, Irianti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aroque pigóque ora icanque Tosorintsi cara isanguenaquero Moisés: Quero póganti; quero pintantopitiro pijina; quero picositanti; quero pitsoiguëgotaguetari ira basinipague; quero pamatobianti; pinguemisantiri piri aisati piniro, quero pipëgatsatëmatari. ");
INSERT INTO notNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Icanqueri sërari: —Ogometinari, aroque naquemisanquero omagaro oca cara ninë janequi irooti yamai. ");
INSERT INTO notNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Inetsëri Jesos, ininqueri, icanqueri: —Panibati. Pinintica iraniacaninatimi Tosorintsi, atsi pijáte, pomimantiro antagaisati ora pasinta, pomaguetiri coguitiaguetachari omagaro opënataga; aique imëmi Tosorintsi ora caninaro cara Jonogaguitequë. Cara pomimantëroca antagaisati atsi piguiatapëna Naro. ");
INSERT INTO notNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cara iquemobëro oca icanqueri Jesos yogasëretasantanaca, icomëtanaca iboroquë irironta casintaguetasantacha, aique iátaji tenta iraninte imimantiro ora yasinta. ");
INSERT INTO notNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Inetsagueiguëri irogomere Jesos, icantaiguëri: —¡Opomirintsitomocari casintaguetachari iriátë canta itingomibintanti Tosorintsi! ");
INSERT INTO notNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iquenganeintasantanacaro irogomere ora icanque Jesos. Carari yogatsitairo Jesos icanque: —Obirojegui aisa picantari notomijegui; opomirintsitomocari inganaque pairiraca cara iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nanganquemi: opomirintsitomocari cameyo ingue otiomijaniquë omoro quitsapi, carari omomirintsitomotasantëmari casintachari iriátë cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ocari oca iquemaigabaque irogomere, iquenganeintasantanaca, yosaminatobaganaca: —¿Aisonorico? ¿Pairo inganquima matsiguenga iragabisaicoontima? ");
INSERT INTO notNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesos inetsaiguëri irogomerejegui, icantaiguëri: —Quero icantiro matsiguenga, quero paniro yogabisaicota, carari Irianti Tosorintsi inganquero antagaisati. Te omomirintsitomotimari Iriro. ");
INSERT INTO notNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aique icanqueri Peroro: —Ogometinari, pinguengaiguena naroegui. Nojocaiganaquero omagaro nasintaigabita, noguiataiganaquemi. ");
INSERT INTO notNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yotabitanëri Jesos: —Aisonori nangantaiguëmi: quero pitsipiriaro. Aroca pintingomintina Naro aisati pijocaiganaquero pobango, pirentipague, pitsiropague, piniro, piri, pitomipague, pitoganepague, pijocanëro aronta pinintaiguina Naro piguiatëna aisati piquenguitsatironta nanibare, aro ingantocobentaiguëmi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Aroca pijocopitënaro arosata cara piguiatëna, imaiguëmi Tosorintsi tojai. Págobëro yamai tojai basini pongotsi, tojai pirenti, tojai pitsiro, tojai piniro, pitomi, aisati pitogane; aisati inguisaneintëntimi basiniati matsiguenga. Carari pintiomoquina përosati canta Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ainta yamai tojai itingomipague yaca quibatsica, carari quero igáanti cara Jonogaguitequë cara panironta Atingomi. Aintasati tojai itsipiriaiguë yaca yamai, imaintaiguëri matsiguenga carari aiquenta imaiguëri Atingomi iromitocoiguëri cara igáanti Iriro. Icarantë yamai carari aiquenta irobataje. ");
INSERT INTO notNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iáiganaque Jesos aisati irogomere aiquero Jerosarénquë, itongaiganaque. Jesos ibataiguëri irogomere abatsiquë. Yoguiataiganaqueri, iquenganeintasantaiganaca, aisati itsorogaiganaque. Jesos yáganëri irogomere casiriconiati, icomantaiguëri atiraca inganquengani Jerosarénquë. Icanqueri: ");
INSERT INTO notNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Pinguemina. Yamai ajáiguë Jerosarénquë. Naro paniacha Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Iroro cantënguicha cara Jerosarénquë irágaiguëna itingomipague saseriroti aisati iraegui ogomeantiro isanguenare Moisés. Ingantaiguëri ira Iromasati: “Páguiri Jesos, póguiri tenta ingomeite”. ");
INSERT INTO notNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Irisërontaiguëna, iripasataiguëna, iriobataiguëna, aique irógaiguëna. Carari ongaraque maba cataguiteri nanganiatanae aisati. ");
INSERT INTO notNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aique yotsitipari Jesos Santiago aisati ireinti Joan, pitirooti itomi Sebereo, icantaiguëri: —Ogometinari, nanintaiguini pingantina ora nomanaquimira. ");
INSERT INTO notNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yotabitanëri Jesos: —¿Pairo pininti nanganquemi? ");
INSERT INTO notNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Icantaiguëri: —Aiquenta cara pigáantanequë, nocoguini pinintacaguina poro naro nosobiaque pobacosonoriquë, ica igueca irisobiaque pomatepacoquë. ");
INSERT INTO notNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yotabitaiganaqueri Jesos: —Te pigóigue ora pamanaquena. Aiquenta natsipiriaque tojai. ¿Teco pintsorogue ca pitsipiriaiguë obiro? ");
INSERT INTO notNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Icantaiguëri pitirooti: —Te nontsorogue, nangantaiguëro naro natsipiriobiquimi. Icanqueri Jesos: —Jee, aisonori, aiquenta pigasëretocoquina aisati pitsipiriobiquina. ");
INSERT INTO notNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Carari quero Naro pimirone cara pisobicomoquina aiquenta. Paniro Pabati përine pairiraca tsipaquinane Naro cara nagáantë. ");
INSERT INTO notNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iquemaiguëri basini irogomere icarati 10. Iguisaneintobiqueri ira Santiago aisati Joan, aroquenta icogabeca pitirooti iraguibatimame. ");
INSERT INTO notNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Aro icaimaiguëri irogomerejegui, icantaiguëri: —Pigóiguë ira itingomipague basiniati matsiguenga cagari jorío yametaiga imerataigari imatsiguenga. Aisati ira obatacagantatsiri imerataigari imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Carari quero aisati picantaigari ibegaiga iriro. Pinintaiguëca piguibatima obiati, pomitocotaigueri pomatsiguenga pingábintsaguetaigueri, quero pimeratari. ");
INSERT INTO notNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pinintica piguibatima, pomitocotaigueri pomatsiguenga pairoraca ininti. Pingantimari ibega iromeraro. ");
INSERT INTO notNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nopaniaca Jonogaguitequë, nomatsiguengatapë arota nomitocotaigueri matsiguenga, quero nimeratari. Aisati nipocasique nangamobitaiguëri antagaisati matsiguenga arota iragabisaicotajiri Tosorintsi cara inguemisantaiguëna Naro. ");
INSERT INTO notNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aro yaretaigaca Jericóquë Jesos aisati irogomere. Cara yogagaiganaca, yoguiataiganaqueri abatsiquë tojai matsiguenga. Ainta isobiaque onamiquë abatsi Baritimeo comarajari, itomi Timeo. Ira Baritimeo yamananteanti quirequi imëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cara iquemobëri Jesos Nasaresati, icaimanë icanque: —¡Jesos, imatsiguenga David, pingantaneintëgotina! ");
INSERT INTO notNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aro iguisatsataigabitacari ira botoitaigacha, icantaiguëri: —¡Pomairete! Aiquero iátanëtigue icaimasantanë: —¡Natingomi, pingantaneintëgotina Obironta imatsiguenga David! ");
INSERT INTO notNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yaratingopë Jesos, icaimagantëri, icanque: —Pingaimiri. Aro icaimaiguëri, icantaiguëri: —Pinganinatanë, pingabiritima, icaimimini. ");
INSERT INTO notNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aro ijocanëro iguitsagare icabiritanaca omanapague ipocasiqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Icabëri Jesos: —¿Pairo picogui nanganquemi? Yotabitanëri comarajari icampëri: —Natingomi, nanintini piniacagajina. ");
INSERT INTO notNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Icanqueri Jesos: —Atsi pijátaje. Piniaje yamaica. Aroquenta piquemisanquina cara nagobiajiro piniaje, aro naniacagajimi nogabisaicotajimi. Aito cara iniaanai, yoguiatëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cara pënibaque iraretaiguëma Jerosarénquë, aitisati pite poeboro otiomijani jitacha Betajajé aisati Betania aronisatiquë oguitoja jitacha Olibos, igáqueri Jesos pite irogomere ");
INSERT INTO notNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","icanqueri: —Pobate, pijáigue catingasati poeboroquë irooti cara piniaqueri itiomijani boro itsatocotaga. Iriro teraiquerai ingueicotingani. Pintsaicotiri, pomapëri yaca. ");
INSERT INTO notNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aintaca matsiguenga irosomitobëmica: “¿Pairo pitsaicobiritiri boro?” aro pinganëri: “Icoguirini Atingomi; aiquenta iraguipigairi”. ");
INSERT INTO notNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aique iáiguë irogomere, iniaigapëri boro itsatocotaga omoroquë pongotsi yaratianque cara págaboquiobaga abatsi. Itsaicotanëri. ");
INSERT INTO notNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ainta inasegui matsiguenga, yosamitaigabaqueri: —¿Pairo pitsaicobiritanëri itiomijani boro? ");
INSERT INTO notNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aro yotabitanëri pitirooti ora icabëri naaraiquerai Jesos. Aro inintacagaiguëri matsiguenga iráganëri. ");
INSERT INTO notNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Icatsatanëneri Jesos, yoguëneri iguitsagarepague imiticaraquë boro itiomijani aro iqueicotanacari Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ainta inaigasegui tojai matsiguenga yoguiaiguëri Ira Jesos. Yogaguetaiguëneri iguitsagarepague cara abatsiquë arota iragaticanëro boro. Aisati yogaguetaiguëneri otiomijani otsego anchato aisa icanta icantaigabaquineri itingomi. ");
INSERT INTO notNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ibataiganaqueri tojai matsiguenga aisati yoguiataiganaqueri tojai. Icaimaiganaque: —Tojai icaninatasanti Tosorintsi. Ainta Agabisaicoontatsiri. Igáqueri Tosorintsi aroquenta iniacaninatëri Iriro, icábintsëri. ");
INSERT INTO notNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Irianti imatsiguenga David atingomi jirai. Intsome antingomintobëmari, intsome aniacaninatobëri Irirai Atingomi. Caninari Tosorintsi jonoquënintaberi. ");
INSERT INTO notNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Cara yarepaa Jesos Jerosarénquë, icanaque oquibequë pongotsi irasi Tosorintsi cara yapatotaiga joríojegui, inetsagueque antagaisati. Aroquenta ochapinitanë isotocanai iáque Betaniaquë. Itsibataigacari irogomere caratatsi 12. ");
INSERT INTO notNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cara oquëtaguetanai ipigaigaa Jesos aisati irogomere aiquero Jerosarénquë. Itaseguë Jesos cara abatsiquë. ");
INSERT INTO notNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iniopëro panguirintsi jitacha iguera. Inatsi tojai osi. Iátasiquero, icogabeca ojito, carari te ine. Patiro pinë osi terainta omoncaratima ora oguitsonta iguera. ");
INSERT INTO notNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Icanquero Jesos: —Yamai quero pinai basini ojito oca igueraca. Quero otsimagani ojito aisati. Iquemaiguëri irogomere. ");
INSERT INTO notNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cara yaretaigapaa Jerosarénquë, icanaji Jesos oquibequë ibango Tosorintsi, iniaigapëri iraegui pimantaguetatsiri aisati manantatsiri, iguisaigapëri, ijocaiguëri sotoquë. Aisati ijoqueri ira campiatobagari iguireguite aisati ira pimanqueri paroma; yotëatapëri imesanepague aisati irisobigomentopague. ");
INSERT INTO notNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te iranintacaguiri matsiguenga irágue pairoraca oquibequë pongotsi. ");
INSERT INTO notNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aique Jesos yogometaiguëri ira matsiguenga: —Ocanti Sanguenari: Icanque Tosorintsi: “Nocogasanti iromanocotaiguena omagaro matsiguengapague yaca nobangoca”. Carari obirojegui te pomanocotiri, iroonti picositapinintaigabaqueri ira bocaigatsi iromanocotaigapëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iquemocoqueri Jesos itingomipague saseriroti aisati ira ogomeantiro isanguenare Moisés. Aro icogabeca iróquerime carari itsorogaiguërinta matsiguenga aroquenta iquenganeintasantaigacari Jesos ora irogomeantane. ");
INSERT INTO notNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cara otsitinengatanë, iáiguë sotoquë Jerosarénquë Jesos aisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Oquëtaguetanai, cara ipigaigaa, iniaigapairo iguera ora icanë chopiquerai aroque ocamaque irooti opariquë. ");
INSERT INTO notNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iquianquero Peroro, icanqueri: —Ogometinari, ¡Pinetsero! Ora panguirintsi aroque pisiguiricanë ora picanë chopi, “Quero otsimagani ojito aisati oca igueraca”. ");
INSERT INTO notNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yotabitaiganaqueri Jesos: —Pinguemisantiri Tosorintsi, pisëretimari. ");
INSERT INTO notNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aisonori nangantasantaiguëmi: aroca pinganqueri Pabati: “Pigaganënaro oca oguitojaca, pijoquiro cara angaarequë”, aisati queroca pitsoinguiri, piguiaqueri inganquero, aro inganquimiro. ");
INSERT INTO notNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iroro nangantaguëquemi: pairoraca pomanaqueri Tosorintsi pinguemisantiri, piguiaqueri imëmiro, aro inganquemiro. ");
INSERT INTO notNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cara pomanocoquerica Tosorintsi, piguibate pingábintseri pomatsiguenga, pijocajineri ora icantaguetomotimi te onganinate, arota Ira Piri jonoquënintaberi irojocajimiro ora picantaguetomotiri obiro te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Carari queroca pijocajineri pomatsiguenga ora icanquimi te onganinate, querootisati ijocajimiro Piri ora picantagueti obiro cagaro caninatatsi. ");
INSERT INTO notNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yaretaigapaa Jerosarénquë. Yanëisigui Jesos oquibequë pongotsi irasi Tosorintsi cara yapatotaiga joríojegui. Aro ipocasitaigapëri itingomiegui saseriroti aisati ira ogomeantiro isanguenare Moisés aisati antiasipari. ");
INSERT INTO notNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yosamitaigapëri: —¿Pairi agáquemi cara pijocaiguëri pimantatsiri? ¿Pairi oguëmi cara pijica itingomi? ");
INSERT INTO notNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yotabitaiganaqueri Jesos: —Aisati naro, patiro nosamitaiguëmi; aroca potabitaiguëna, aisati nongomantaiguëmi pairi agáquena Naro. ");
INSERT INTO notNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Pairi agáqueri Joan cara ibaotisataiguëri tojai omatsiguenga? ¿Iriroco agáqueri Tosorintsi? ¿Iraco agáqueri matsiguenga? Pingomantina. ");
INSERT INTO notNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Icantobagaiganaca jorío: —Anganquerica: “Igáqueri Tosorintsi”, aro ingancái: “¿Pairo te pinguemisantobitaigueri Joan?” ");
INSERT INTO notNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Carari aroca anganqueri: “Igáqueri matsiguenga”, aro inguisaigacái omatsiguengapague ijitaiguënta cara igáqueri Joan Tosorintsi ingomantaguete. ");
INSERT INTO notNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aro yotabitaiguëri: —Teni nogóigue pairi agáqueri. Icantaiguëri Jesos: —Aisati Naro, quero nocomantimi pairiraca agáquina nangantaguete ocapague piniaiguë. ");
INSERT INTO notNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aisati iparintaca Jesos iquenguitsataiguëri matsiguenga quingabaguirentsiquë. Yosiacagantineri icantaiguëri: —Ainta sërari ipanguiaque obasi, itantotëro, iquiaque omoro cara iragaticaguitëro oguitso aisati ora irágantëmaro oja. Aisati yobetsiquëro pongotsi oquibiantsa jonoquë ora iranetsantimaro. Aique yogaiguëri omisantineri irobasite. Iquengaigaca cara onguitsotanëca, ira omisantineri iráquero aganguisati oba, aganguisati imagantëneri casintaro. Aique iáque jaanta intimaque cosamani. ");
INSERT INTO notNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cara omoncaraca cara oracanë oguitso oba, igátabecari iromeraro icanqueri: “Pijáte pingampëri ira omisantinaro nobasite imagantaiguenaro nasiati”. ");
INSERT INTO notNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Carari ira omisantiro yágaigabaqueri ipasataigabaqueri. Yoguipiguëri, te imëmatobëri oba. ");
INSERT INTO notNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aique igátabecari basini iromeraro. Iriro aisati ipasataigabaqueri iguitoquë, icabegobëri. ");
INSERT INTO notNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aisati igátabecari basini ira yogamagaigabaque. Ira casintaro igátabecari basini iromeraro tojai. Ainta ipasataigabaque; ainta basini yogamagaigabaque. ");
INSERT INTO notNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Panibani itomi, ira inintasanti. “Irirojengari iraniacaninataigabaque”, icanque. Aro igáqueri itomi. ");
INSERT INTO notNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Irari omisantineri irobasite iniaigabaqueri itomi, inibatobaca: “Irironta itomi casintaro. Cara ingamaquenica iriri, iriroquerai áganairone obasi. Intsome ógaigabaqueri, águero obasi asintaiguemaro eiroquerai”. ");
INSERT INTO notNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aro yágaigabaqueri, yogamagaigabaqueri, ijocaiguëro igamaga sotoquë obasiquë. ");
INSERT INTO notNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Pairo piquengaiga? Cara iribocapë ira casintaro obasi, ¿Pairo inganqueri iraegui catsimari ira omisantaiguineri? Cara iribocapë, irágaigapëri ira catsimari omisantatsiri, iripoguiriaigapëri. Aique irogaiguëri basini omisantainerine irobasite, irianti caninari. ");
INSERT INTO notNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Teco pinibataiguero ora Sanguenari? Ocanti: Jirai itsoingaiguëro mopë ira obetsiquirori mopëpongo, ijoquero tenta irogóiguero cara icoiguëro Tosorintsi iroonti otingomi mopë, otingomi pongotsi, cantaca otingomipoa. Carari yágairo ora mopë itingomiantaaro pongotsi. ");
INSERT INTO notNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Icaninabenquero Atingomi, iniacaninatëro, icantacagajiri matsiguenga cara irogajiro otingomi mopë. Aisati naquenganeintasantëro naroegui. ");
INSERT INTO notNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aro igóiguë itingomi saseriroti aisati ira ogomeantiro Sanguenari aisati antiasipari cara Jesos iquenguitsatocotaiguiri irirojegui. Iguisaneintaigabitacari icogaigabitaca irácagantërime, carari yomitsorogaiguëri matsiguenga igóiguënta matsiguenga cara aisonori Jesos icomantëgotëri Tosorintsi. Aique iátaji joríojegui, ijocaiganaqueri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ira itingomiegui igátaiguëri Jesosiquë bariseopague aisati iratirite Eroris. Icogabeca iramasitacaguirime irinibare arota inguiseri itingomi cobeingari. ");
INSERT INTO notNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iátasitaiguëri Jesos, icampëri: —Ogometinari, nigóiguë aisonori pogomeantiro Irinibare Tosorintsi, aisati poniagantiro catingasati atiraca ongantima aretaiguëmari Tosorintsi. Te pintsoroguiri pairiraca. Yamai pingomantina ora piquianca Obiro: ¿Caninataque omëri Sésar aguireguite? ¿Teco onganinate omagantëri cobeingari cara Iromaquë? ");
INSERT INTO notNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Igóque Jesos cara icogaigabitaca irantacaguirime ora te ongomeite. Yosamitaigabaqueri: —¿Pairo picogobiti pomatobitina? ¿Pairo picogobiti pamasitacaguinaro nanibare? Te pinganinate. Poniaguinari quirequi ira pipënabiantari ogobeingarite Iromasati. ");
INSERT INTO notNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aro yamaigapëneri quirequi ira jitacha tenario. Yosamitëri Jesos: —¿Pairi casintaro oca irosiacagomentoca? ¿Pairi ijita sanguenatëgotënguicha yaca tenarioica, iroonti iripajiro? Yotabitaiganaqueri: —Iroonti irasi Sésar nogobeingarite. ");
INSERT INTO notNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aro icantaiguëri Jesos: —Aro pomaigueri Sésar iraisati, pingantineri ora icocagaiguëmi, pinguemisantiri. Aisati pinguemisantiri Tosorintsi pomaigueri ora iraisati ora icocagaiguëmi Iriro. Iquemaiguëri, iquenganeintasantaiganaca. ");
INSERT INTO notNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Aisati iátasitaiguëri Jesos saroseopague, ira ijitasitaiga cara quero icabiritaja igamaga, quero icaniatanai. Icantaigapëri: ");
INSERT INTO notNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ogomeantatsiri, jirai isanguenataiguëna Moisés: Aintaca sërari, carari te irine itomi, aique ingamaqueca, caninataque ireinti irágajiro iina; aroca ontsomaaque itomi, irianti irosiguëmari itomi ireintitomaco. ");
INSERT INTO notNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jirai ainta sërari aisati ireinti icarati 6. Ira obatatsi yágabita iina, carari te irine itomi. Aique icamaque iriro. ");
INSERT INTO notNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Aro iina yágairo ireinti. Aisati icamaque iriro, te irine itomi. Aisati icantaiga ireintiegui yágaigabitaaro tsinane, icamaiguë omagaro, te irinëmate itomi. Aique ocamaque tsinane aisati, aro ocaraque. ");
INSERT INTO notNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cara ingabiritaiguëma, ¿Pairi ágairone? Pinetse, ijinantaigabitaro antagaisati ireintiegui. ");
INSERT INTO notNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yotabitaiganaqueri Jesos: —Tojai pamatobitaiga obiatiegui tenta pigóiguero Sanguenari, teatisati pigóiguero itasorintsite Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aisonori, cara angabiritajima, antimaigae, quero águiro ajina. Antagaisati cabiritachane ingantaiguëmari ibega ironomire Tosorintsi: quero yágai iina. ");
INSERT INTO notNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ingabiritaiguëma omagaro camaigatsiri. ¿Teco pinibatiro ora icanti Tosorintsi jirai, isanguenaquero Moisés? Tosorintsi icanqueri Moisés cara anchatoquë pamasigatsi: Naro Tosorintsi. Iquemisantina Abaram. Iquemisantina Isac. Iquemisantina Jacob. ");
INSERT INTO notNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Te ingante: “Iquemisantabequina”. Aroca iquemisanqueri Tosorintsi Abaram, ainta icaniati Abaram. Aisati caniari Isac aisati Jacob. Tosorintsi Irianti Itosorintsite ira caniatatsi. Obirojegui yamai picomëtacani. ");
INSERT INTO notNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ainta poro ogomeantiro isanguenare Moisés, iquemaiguëri bariseo aisati saroseo cara yosamitaigapëri Ira Jesos. Aisati iquemaqueri Jesos cara yotabitanëri caninasati. Aro yosamitëri Jesos iriro: —Aiti tojai pogometaguequina Sanguenari. ¿Pairo obatatsi ora anguemisanque? ");
INSERT INTO notNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yotabitanëri Jesos: —Iroro oca obatatsi: Isirael, pinguemaigue obirojegui. Pinguemisantiri Atingomi Irianti Pitosorintsite. Iriro paniro Irirosonori tenta irine basini Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pinintasantiri Tosorintsi Atingomi, pomasëretasantimari obiati, përosati pinguengueri, pinguemisantasantiri, pingantineri antagaisati ora icocaquimi Ira casintimi. ");
INSERT INTO notNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ora otsibatara ocantaro pibega basini, ocanti: Pinintiri pitimanamitane pibega cara pininta obiati. Oca pite iragáantane Tosorintsi iroro obataigatsi. Te ine basini obataiguerone. ");
INSERT INTO notNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ira ogomeantiro Sanguenari icanqueri Jesos: —Jee, aisonori, Ogomeantatsiri, ora picanque. Paniro ini Tosorintsi; teni irine basini. ");
INSERT INTO notNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aisati caninataque anintasantiri, omasëretimari eati, përosati anguengueri, anguemisantiri, angantineri omagaro ora icocacái. Aisati ocanta caninataque anintiri atimanamitane ibega cara aninta eati. Aisonori oca iroro obatatsi, pabisëro cara omëri Tosorintsi oisha. Te ingogasante Iriro ataquineri oisha. ");
INSERT INTO notNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesos iquemaqueri, igótocoqueri ira ogomeantiro Sanguenari cara yotabitanë caninasati, icanqueri: —Pënibaque pintingomintimari Tosorintsi, pënibaque intingomibintëmi obiro. Aique itsorogaiguëri matsiguenga; te aiquero irosomitaigairi aisati Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Cara yogomeantasegui Jesos oquibequë pongotsi cara yapatotaiga joríojegui, yosamitaiguëri: —¿Pairo icantobitaiguë ira ogomeantiro isanguenare Moisés cara “Ira Quirisito imatsiguengasonori David”? ");
INSERT INTO notNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Jirai Isëre Tosorintsi osanguenatacaqueri ira David. Isanguenaque nega: Ira Tosorintsi icanqueri Natingomi: “Pisobigue yaca nobacosonorica. Pintsibatina yaca nagáantomentoquëca irooti cara nagabeiri antagaisati ira quisaiguëmi, irajitaiguëmi Itingomi”. ");
INSERT INTO notNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Aisati David ijitiri Itingomi. ¿Ati ingantima David intingomintobitimari imatsiguengasonori ira boquënguitsine aiquenta? Iriroca Itingomi David, ¿Pairo te pijitobitaigueri Pitingomi obirojegui aisati? Iquemaigabaqueri tojai matsiguenga botoibiritaigari Jesos, icaninabentaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Përosati yogometaiguëri matsiguenga Jesos: —Pigamaiguemari iraegui ogomeantiro isanguenare Moisés. Quero picantaigari ibega iriro. Icogasantaiguë iriro iranëitagueantëmaro imanchaqui caninarosonori aisati oquibeintsa. Aisati icogasantaiguë iriáiguë cara opimantagani pairoraca arota iraniacaninataigueri matsiguenga irobetsatobëmari. ");
INSERT INTO notNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aisati icogaiguë iragasobicaigueri caninaroquë sobigomentotsi cara yapatotaiga jorío. Cara irapatoitima imatsiguenga irapaiguë, icogaiguë irisobicaigue aganguisati intsibataiguëmari itingomipague. ");
INSERT INTO notNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aisati yágabitsaquero obango ogamaimentaga iroontita cosamani yamanocotasitari Tosorintsi arota iraniacaninataigueri matsiguenga. Carari nongomantaiguëmi ira cantatsi negaca iratsipiriasantaiguë irabisaiguëri basini matsiguenga, tojai ingasitígatëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ainta Jesos isobiaque oquibequë pongotsi irasi Tosorintsi. Inetsaiguëri matsiguenga cara yomingaiguëri iguireguite yogantaririquë quirequi ira ipiri Tosorintsi. Ainta casintaguetachari yomingaiguëri tojai quirequi. ");
INSERT INTO notNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aisati iniobëro tsinane ogamaimentaga pomianqueri pite itiomijani iguitso quirequi ira te iripënatima. ");
INSERT INTO notNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Icaimaiguëri irogomere Jesos, icantaiguëri: —Nangantaiguëmi, aisonori ora ogamaimentaga te aisa ongantaiguemari basini ira paiguëri Tosorintsi iguireguite. Arosataanti quirequi opëri iroro, carari Tosorintsi iniacaninatëro pabisaiguëri basini. ");
INSERT INTO notNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iraegui basini paiguëri Tosorintsi arosata ira inomotaiguiri, ainta tojai yoganontaiga. Carari cara opabacari Tosorintsi aisati opëri antagaisati pasinta inomotiro, teni irinaje basini omanantantajima operi. ");
INSERT INTO notNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cara isotocanë Jesos oquibequë pongotsi cara yapatoitaiga joríojegui, poro irogomere icanqueri: —Ogometinari, pinetsero mopëpague ora yobetsicantaro pongotsipague. ¡Oquibeguinte, caninaro! ");
INSERT INTO notNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yotabitanëri Jesos: —¿Piniaigabitacaro ora pongotsipague? Aisonori nongomantëmi oca: aiquenta irogomeriguetaiguëro antagaisati. Quero pini yaca pite mopë otsibatobagaa. ");
INSERT INTO notNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aique iáque Jesos isobigopë oguitojaquë jitacha Olibos. Catingasati pinë ibango Tosorintsi. Aro casiriconiati yosamitaiguëri itsibasati irogomere: Peroro aisati Santiago aisati Joan aisati Antiris: ");
INSERT INTO notNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Pingomantaiguena: ¿Ati ongantima cara irogomeriguetëro orapague pongotsi? ¿Pairo ogótacaquinane cara omoncaraquima antagaisati oca picantaiguënaca? ");
INSERT INTO notNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Icantaiguëri Jesos: —Pigamaiguema arota quero yamatobitaigapëmi pairiraca. ");
INSERT INTO notNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iribocaiguë tojai matsiguenga ingantaigapëmi: “Naro Quirisito”. Iromatobitaigapëri tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pinguemocotaiguëro omanátobagachari; ingantaiguëmi: “Yomanátobacani canta jaanta”. Ira basini irojocaiguëri itingomipague irogaiguëri irirai. Quero iquengaiganaja matsiguengajegui, carari quero pitsorogaigui. Aiquenta onganquima tojai inguisabacaquima, carari queroquerai omoncarata omagaro ora nacantaiganaquemi. ");
INSERT INTO notNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aiquenta inguisaiganaqueri basiniati matsiguenga, inguisëgotobaganëma irógobaquima. Aisati tojai osebataguetanëma quibatsiquë. Aitosati iritasegaiguë tojaisonori matsiguenga omagaroguitequë. Antagaisati oca iroonti omarintanëma, iroro cantënguicha queroquerai yobomirintsitasantiri matsiguengajegui. Aiquenta coraque agabenisonori atsipiriagantsi. ");
INSERT INTO notNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Përosati icomantëri Jesos: —Pigamaiguema obirojegui. Cara irogóiguë matsiguenga piquemisantaiguina irágaiganaquemi cara yapatotaiga, iripasataiguëmi. Aisati irágaiganaquemi catingasatiquë itingomipague aisati cobeingaripague. Pitsipiriaquero oca aroquenta piquemisantaigëna Naro. Pingomantaguetiri iraegui quisaiguëmi. Pingomantëgotina. ");
INSERT INTO notNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nocogui cara queroquerai pabisi omagaro oca atsipiriagantsica, ingomantëgotaguequero Caninaro Nibarintsi antagaisati matsiguengapaguequë ati ongantima nagabisaicotajiri cara inguemisanquina. ");
INSERT INTO notNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cara irágaiganaquemica cara yapatotaiga itingomipague, quero pitsorogui, quero piquenga: “¿Pairoraca nanganqueri?” Ogósëretacaquemi Isëre Tosorintsi ora pinganque, onibataquemi. ");
INSERT INTO notNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aiquenta ira sërari irácagantëri ireinti, irócagantëri. Aisati irácagantëri ira itomi. Ira janequipague irácagantëri ira casintari irócagantëri. ");
INSERT INTO notNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Piquemisantaiguënanta, inguisaiguëmi matsiguengajegui. Carari nagabisaicotajiri antagaisati ira abequerone, ira quemisantaiganaquina përosati. ");
INSERT INTO notNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aisati icomantë Jesos: —Jirai isanguenaque comantantatsiri jitacha Daniel: Aiquenta ingapë cara ibangoquë Tosorintsi ira quimingarisonori cantaguetasantatsi ora te ongomeite, iraguimingatëro antagaisati. Pigóiguëro Sanguenari. Cara piniaiguërica ira nocomantëgoti yamaica inganaque ibangoquë Tosorintsi cara quero iqui pairiraca, aroca pitimi Joreaquë pisigaiganaquima otisipaguequë. ");
INSERT INTO notNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aintabica obiro sotoquë pobangoquë, quero picapanaanti tsomagui págapanaantiro ora pasinta; iroontita pisigasantanëma. ");
INSERT INTO notNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aroca pinë pitoganequë, quero pipigasitapanaantaro basini piguitsagare. ");
INSERT INTO notNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tojai otsipiriaiganaquero tsinane ora pënibatatsira aisati ora tsotagatsi ojaniquite queronta pisigasantanaca. ");
INSERT INTO notNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pomanocotiri Tosorintsi arota quero pisigaiga cataguiteriquë omarigantetetica angani. ");
INSERT INTO notNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aitosati icanë Jesos: —Aique tojai iratsipiriasantaiguë matsiguenga. Iratsipiriasanoiguë abisërone ora itsipiriaiguë matsiguenga jiraisonori irooti yamaica, aisati abisërone omagaro inanënguitsine aiquenta. ");
INSERT INTO notNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aroca ongosamanitanëme cara iratsipiriasanoiguë, opoguiriaguëri omagaro matsiguenga ingamaque, carari Tosorintsi ingábintsaiguëri antagaisati quemisanqueri iraegui icoiguë, arota quero ocosamaniti atsipiriagantsi. ");
INSERT INTO notNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aintaca poro cantatsi: “Iriro Quirisito Ica”, quero piquemisantiri. Aisati inganquemica: “Intsome canta Quirisitoquë”, quero poguiatiri. ");
INSERT INTO notNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Coraque iribocapë tojai matobiantatsiri ingampëmi: “Naro Quirisito”. Aisati iribocapë basini inganque: “Naro comantëgotëmirine Tosorintsi”. Tojai iritosongantë, ingoque iromatobitaiguëri tojai matsiguenga, carari quero yamatobitiri ira quemisantasantatsi ira icoiguë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Pigamaiguema! Aroque nocomantaiguëmi atiraca ongantima aiquenta queroquerai omoncarata. ");
INSERT INTO notNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Aisati icomantaiguëri irogomere Jesos: —Cara abisanaqueca oca atsipiriagantsica, aique intsitinique paba, aitosati quero yobariaguitetanai manchacori, ");
INSERT INTO notNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","imariaguëpë jonogasati, aisati osebatanëma omagaro jonoquë. ");
INSERT INTO notNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aique iraniaigabaquena Naro, Naati nopaniaca jirai Jonogaguitequë nomatsiguengatapë, nopogopë mingoriquë, nongobeingatasanotapë nosangueguitetasanotapë, nantingomibintasantaiguëri omagaro, nagabeiri antagaisati. ");
INSERT INTO notNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aisati nagátaigapëri nonamireegui irapatotaiguëri antagaisati quemisantaiguëna iraegui igoigane Tosorintsi atiraca itimagueti quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Aisati yoniagaiguëri irogomere Jesos: —Yamai nosiacagantaiguëmiro anchato jitacha iguera: pinguengasantiro. Cara iroraini otsego, ositanae osi, aro pigóiguë pënibaque osariganaje. ");
INSERT INTO notNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aisa ocanta, cara piniaigabaquero oca nacantaiguëmica yamai, pigóiguë pënibaque orequima cataguiteriquë cara nopogopae. ");
INSERT INTO notNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nangantasantaiguëmiro oca: queroquerai icamaigui joríojegui tsoengatsiri queroquerai omoncarata oca nocomantaiguëmica. ");
INSERT INTO notNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Omeganëma omagaro ora inatsi jonoquë aisati omeganëma oca quibatsica, carari quero opega nasi nanibare. Omoncaraquima omagaro ora nacantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Aisati icanque Jesos: —Te irogóte pairiraca atiraca ongantima nopocaje Naro. Te irogóigue ironomireegui Tosorintsi. Nipoque, nomatsiguengatapë carari teatisati nogóte Naro. Paniro igótiro Pabati. ");
INSERT INTO notNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pigamematasha, aisati piguiaiguena tenta pigóigue atiraguiteca cara nopigapaima. ");
INSERT INTO notNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nosiacari sërari játatsi canta jaanta. Queroquerai iáti, ingaimëri antagaisati iromeraro, ingomantaguetanëri paniropague pairoraca inganquineri. Aisati iroganëri omisantineri omoro ibango. Inganqueri: “Pigamema, pinetsero”. ");
INSERT INTO notNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Arotasha pinaigue obirojegui nogomere tenta pigóigue atiraca ongantima iraretajima casintaro pongotsi. Te pigóigue iribocapaeca chopiniquë, queroca aganguitequë, queroca coniamaniaquë cara ingaimanë tiapa sërari, queroca naramaniquë. ");
INSERT INTO notNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pigamabentimatasha cara iriguito irarepaima casintaro, caquitatsibi iraniopaimi. ");
INSERT INTO notNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ora yamai nanganquimira aitosati nanganqueri antagaisati: “Pigamematasha”. ");
INSERT INTO notNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aro pitenibati cataguiteri orequima jiesita jitacha Pásicoa cara yapaiguiro joríojegui ora pan te ine piponganta, aisati iquengaigaca cara isotocaiguë Ejípitoquë jiraisonori. Aro yapatotaigaca itingomipague saseriroti aisati ira ogomeantiro isanguenare Moisés icogaigabitaca iromatobitaigueri Jesos arota iráqueri aisati iróguiri. ");
INSERT INTO notNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Icantobagaigaca irirojegui: —Quero águiri jiesitaquë. Iriro iniacaninataigui matsiguenga. Aroca águëri inguisaigacái eiroegui. ");
INSERT INTO notNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Aique yogaganaca Jesos canta Betaniaquë. Cara, ainta Iriro ibangoquë Simón ira iribatsasetabitaga jirai. Yapasigui Jesos cara pipocasipëri tsinane. Pamëgotasitapëri asaiti casangajengaro jitacha náriro ora tojai pipënata. Ora pinanta pobetsicagani mopë sibitaro jitacha aribásitoro. Pisataicoquero, oshaguëguitontapari Jesos iguitoquë. ");
INSERT INTO notNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aintasati basini matsiguenga iguisëgotaiganacaro casangajengaro. Icantobaganaca: —¿Pairo paparaabiriquero casangajengaro? ");
INSERT INTO notNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Caninataqueme omimantërome casangajengaro águërime tojai quirequi 300 tenario omërime tojai ira coguitiacha omitocotaiguërime. Iguisaneintaiganaquero tsinane. ");
INSERT INTO notNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Icantaiguëri Jesos: —Ineta iroro. ¿Pairo picantobiquero oca tsinaneca? Patiro ocanquinaro caninaro. ");
INSERT INTO notNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Përo cara irinaque obirojeguiquë ira coguitiachari te irine iguireguite; cara pinintica pomitocotaiguëri iriro. Carari quero nini Naro përosati. ");
INSERT INTO notNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ocanquinaro caninasati. Oshaguëantobënaro queroquerai iteina. ");
INSERT INTO notNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aisonori nangantaiguëmi: aiquenta pinguenagueque omagaroquë quibatsi, pinguenguitsatomotaguetaiguëri matsiguenga Caninaro Nibarintsi. Aisati pingomantëgotiro oca tsinaneca arota irogótocotiro matsiguengajegui. ");
INSERT INTO notNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aique iáque paniro irogomere Jesos, ijita Joras Cariotisati. Iátasitaiguëri itingomipague saseriroroti, inibatagaigapëri cara irácagantëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iquemaigabaqueri saseriroti, icaninataiganaque iquengaigaca imëri Joras quirequi. Aique ipigapaa Joras, inetsasantëri Jesos arota irogóontëmari atiraca ongantima cara irácagantëri. ");
INSERT INTO notNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pareca Pásicoa cara yametaiga joríojegui yapaigui pan te ingonaguero ora piponganta, aisati cara yóguiri oboina oisha aisa icanta cara icantaigaca jorío jiraisonori Ejípitoquë. Yosamitaiguëri Jesos irogomere: —Natingomi, ¿Nega pininti nobetsiquëmiro cara popë Pásicoaquë? ");
INSERT INTO notNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesos igáqueri pite irogomere: —Atsi pijáte poeboroquë. Cara pitonguibotobëmarica sërari iromëgotapë nija chomoquë, piguiatanëri. ");
INSERT INTO notNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cara ingapë iriro, pinganqueri casintaro pongotsi: “Icanque Ogometaiguinari: ‘Cara pobangoquë, ¿Nega pini cara nopaiguë Pásicoa Naro aisati nogomerejegui?’ ” ");
INSERT INTO notNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ironijagaiguëmiro oquibe coarito jonoquë; aito pobetsiquëro perintsi asi Pásicoa. ");
INSERT INTO notNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aique iáiguë pite cara poeboroquë, iniaigapëri sërari aisa ocanca omagaro cara icantaiguëri Jesos. Aro yobetsicaiguëro Pásicoa. ");
INSERT INTO notNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cara otsitiniguitetanë, yaretaigapa Jesos aisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cara yapaigasegui mesaquë, icantaiguëri Jesos: —Aisonori nangantaiguëmi, ainta paniro yapëgotëna yaca ira ágagantënane. ");
INSERT INTO notNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aro yogasëretaigaca antagaisati, paniropague yosamitëri: —Natingomi, ¿Naroco ágagantëmine? ");
INSERT INTO notNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Icantaiguëri Jesos: —Irianti paniro obirojegui picarati 12. Irianti pëcosiguina cara napë noberatotequë. ");
INSERT INTO notNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë yaca quibatsica. Jirai isanguenatocoquina Sanguenariquë, aroque nomoncaraquero omagaro. Irari atsipiriasantërone ira ágagantënane, ¡Caninataqueme querome ini iriro! ¡Querome itsipireiro! ");
INSERT INTO notNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Cara yapaigasegui, Jesos yáguë pan, icarasiaqueri Tosorintsi, itibatsaaguequero, yotsatengaiguëri irogomerejegui. Icantaiguëri: —Jeroca pan osigaro nobatsa. Popaiguero. ¿Teco nangamobitaiguemi? ");
INSERT INTO notNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aique yáguë irógomento, icarasiaqueri Tosorintsi, ipaguitaiguëri. Antagaisati yógaigacaro. ");
INSERT INTO notNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Icantaiguëri: —Iroro osigaro naraa, ora naraatobitanëneri omagaro matsiguenga cara nangamobitaiguëri. Yamai naraa ocanti irorai Nibarintsi; iroro ingábintsantaiguëmari Tosorintsi. Cara irabentaiguëna, Tosorintsi irojocajineri matsiguenga ora icantagueti te onganinate, quero iquengaineri aitosati. Nacantaiguëmi yamai arota pigóigue atiraca ongantima iragabisaicotajiri Tosorintsi antagaisati quemisanquinane. ");
INSERT INTO notNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yamaica quero nógaaro oja oba aisati irooti cara nantsibataiguëmi cara iragáantanequë Pabati. Cara igáantë Iriro omagaro omasiniatitanë. Aique nóguëmaro iroraia aisati obirojegui. ");
INSERT INTO notNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aroque yapaiguë. Aique icántataiguë Jesos aisati irogomere, iáiguë cara oguitojaquë jitacha Olibos. ");
INSERT INTO notNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Icantaiguëri irogomere Jesos: —Yamai pijocaiganaquina pisigaguetanëma, cara ocanti Sanguenari: Nóguëri ira omisantirine oisha, aro irisigaiganaquima iroishate, inguenagueque porocague. ");
INSERT INTO notNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Carari nanganiatanae, nobataiguëmi canta Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Iriro cantënguicha Peroro icanqueri: —Aroca irojocanëmi antagaisati basini icaegui, quero nojoquimi naro. ");
INSERT INTO notNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yotabitanëri Jesos: —Aisonori nongomantëmi, Peroro. Yamaica tsitinirica queroquerai icaimanai tiapa sërari, ongaraque maba pinganque: “Teni nogótiri Ira Jesos”. ");
INSERT INTO notNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aisati icanatasantë Peroro: —Aroca nantsibatëmi nangamobiquemi, quero nacanti: “Teni nogótiri Ira Jesos”. Aisa icantaiguë antagaisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aique iáiguë yaretaigaca Jetsemaníquë. Jesos icantaigapëri irogomere: —Pisobicaigue yaca; najáque Naro cara, nomanocoqueri Pabati. ");
INSERT INTO notNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aro maba yáganë casiriconiati: Peroro aisati Santiago aisati Joan. Iparintaca Jesos tojai yogasëretasantaca aisati iquenganeintasantaca. ");
INSERT INTO notNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Icanqueri: —Tojai nogasëretasantaca agabenisonori. Pënibaque nangamaque. Pisobicaigue yaca, pingaguite. ");
INSERT INTO notNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Aique yogaganaca cara querora, yaquitomopa quibatsiquë. Yamanocopëri Iriri: —Apa, Pabati, Obiro pinganque omagaro; caninataque pigabisainaro ora bocatsi; teni naninte natsipirie, carari quero nacantiro ora nocogabeca Naro, iroonti nanganque ora picocaquina Obiro. ");
INSERT INTO notNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aique Jesos ipigapaa irogomerequë. Iniopairi isamaigasegui. Yosamitëri ira Peroro: —Simón, ¿Pairo pisamabirique? ¿Teco pabebintsatiro pobotsiquine, te pabetiro pingaguitëmate arosata? ");
INSERT INTO notNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pingaguite, pomaniri Tosorintsi arota iromitocotaiguemi quero picantaguetiro ora te ongomeite. Picogabeta pingantirome ora nococaquemira, carari te pingantiro. ");
INSERT INTO notNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aisati iátaji Jesos. Yamanocotajiri Iriri. Irootisati yogatsitairi ora icanqueri naaraiquerai. ");
INSERT INTO notNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ipigapaa aisati iniopairi irogomere aitosati isamaigasegui, tojainta ipotsiquitasantë. Te irogóiguë irotopitanairi. ");
INSERT INTO notNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aisati iátaji yamanopai maba. Aro ipiganaja Jesos, icantaiguëri irogomere: —¿Somaigatsibico? Atsi pisamaigue yamai. Jirai nopaniaca Jonogaguitequë nomatsiguengatapë. Carari aroque omoncaraca yamai cara irácagantëna ira cagari caninataigatsi. ");
INSERT INTO notNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pingabiritaiguema, intsome ajáte. Coraguitaque ira ágagantënane. ");
INSERT INTO notNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cara inibatasegui Jesos, yarepa Joras ira yogometabeta Jesos. Icarataigapëri tojai matsiguenga. Yamaigapë isabirite aisati anchaqui. Aroque igátaiguëri itingomipague saseriroti aisati ira ogomeantiro isanguenare Moisés aisati antiasiparipague. ");
INSERT INTO notNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aroque icomantaiguëri Joras icanque: —Ira nasarapëma ora pigóontanëmari Iriro Jesos. Páganëri. ");
INSERT INTO notNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aique iátasipëri Jesos Joras, yasarapari, icanque: —¿Aintabi, Ogometinari? ");
INSERT INTO notNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aique ipocasitaigapëri antagaisati ira itsibataigapa Joras, yágaiganaqueri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aro paniro irogomere yáguë isabirite, itoguimitatëri iromeraro itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aro icantaiguëri Jesos: —¿Pairo pamasibiriquinaro pisabirite aisati anchaqui págantanënaro? ¿Pijitaiguëco Naro cosirintsi? ");
INSERT INTO notNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tojai piniaigabitina cara nogometaiguimi cara ibangoquë Tosorintsi, te págaiguena carari aroquenta omoncaraca ora ocomantëgotina Sanguenari. ");
INSERT INTO notNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aique ijocaiganaqueri Jesos antagaisati irogomere, isigaguetaiganaca. ");
INSERT INTO notNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ainta poro oboina sërari yoguiatanëri Jesos. Te inguitsagatema, patiro icanaquero tocoya. Yágaigabitacari iriro matsiguenga ");
INSERT INTO notNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","carari ijocanëro tocoya, isigaganatanaca saacanari. ");
INSERT INTO notNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aique yágaiganaqueri Ira Jesos ibangoquë itingomisonori saseriroti cara yapatobiritaigacari basini itingomipague saseriroti aisati antiasipari aisati ira ogomeantiro ora isanguenare Moisés. ");
INSERT INTO notNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yoguiataiguëri Peroro icarantanë. Icapë tantotsiquë tsomagui itsibataigacari sorarojegui cara yotataiguë tsitsiquë. ");
INSERT INTO notNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aro ira itingomipague saseriroti, aisati antiasipari, aisati omagaro itingomipague jorío icarati 71 icogaigabitaca matsiguenga ingomantëgotëri Jesos ora te onganinate arota irógaigueri. ");
INSERT INTO notNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ainta tojai itsoiguëgotaigabitacari Jesos carari te inguengaiguema. ");
INSERT INTO notNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ainta basini tsoiguëgotantachari icantaiguë: ");
INSERT INTO notNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Cani jirai naquemaiguëri naroegui cara icanë Jesos: “Nogomeriguetairo oca ibangoca Tosorintsi ora yobetsicaiguë matsiguenga. Ongaraque maba cataguiteri, nangabiritajiro basini irorai ora te irobetsiquiro matsiguenga”. ");
INSERT INTO notNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Carari teatisati onguengaiguema irinibare ira comantëgotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aro icabiritanaca itingomi saserirotipague, yosamitëri Ira Jesos: —¿Pairo te potapibiritiri? ¿Pairo ojita oca icantocotaiguëmica? ");
INSERT INTO notNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Përo cara imairetopitëri Jesos, te irotopitëmatiri. Aisati yosamitairi itingomi saseriroti: —¿Obiroco Quirisito Itomi Tosorintsi caninarisonoriguinte? ");
INSERT INTO notNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Icanque Jesos: —Jee, Naro. Nopaniaca Jonogaguitequë, nomatsiguengatapë. Aiquenta piniaigaina nosobigopë ibacosonoriquë Tosorintsi sintsirisonoriguinte, aisati piniajina cara nopoque mingoriquë, nopigapaima yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aito cara iguisanaca itingomi saseriroti itisaraanëro imanchaqui, icanque: —Piquemaigabaqueri. ¿Pairo ongogobique basini comantëgotërine? ");
INSERT INTO notNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Icantocotaguetasitari Tosorintsi. ¿Pairo piquengaiga obirojegui? ¿Pairo anganqueri? Yotabitaiguëri joríojegui; iquengaigaca antagaisati: —Caninataque ingamaque. ");
INSERT INTO notNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aique ijobaboroqueri iboroquë, ibasioquiqueri iroquiquë inchotangaborotëri. Icantaiguëri: —Jaa, pingomantina. ¿Pairi capojëmi? Aisati iromeraroegui itingomi saseriroti inchotangaborotëri. ");
INSERT INTO notNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aintaquerai isobiaque Peroro saaguiteroquë. Pipoque tsinane ironomire itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oniopëri cara yotasigui tsitsiquë. Onetsasantëri ocanqueri: —Aisati obiro aguiatiri Jesos, Ira Nasaresati. ");
INSERT INTO notNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Carari itsoiganaca Peroro: —¡Teni nogótiri! ¡Teni nanguemimi pairoraca picantina! Aro iátabeca Peroro cara icabitapa. Aito cara icaimanë tiapa sërari. ");
INSERT INTO notNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Iroroquerai tsinane onetsiri Peroro aisati. Ocantaiguëri iraegui inaigasegatsi: —Ica sërarica aguiatëri Jesos aisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yotabitanai Peroro: —¡Teni nogótiri! Caraca arosata, ira inaigasegatsi icantaiguëri ira Peroro: —Aisonori obiro tsipataigari irogomere Jesos obironta Garireasati; pinibatinta picantaigari ibegaiga Garireasati. ");
INSERT INTO notNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Icantasanti Peroro: —Te sonori nogótiri sërari ira picantocoquina. Igóque Tosorintsi aisonori nacanquemi. Queroca ninibatimi catingasati, nocogui ingasitígatina Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aito cara yogatsitanai icaimanai tiapa sërari. Aro iquianquero Peroro cara icomantëri Jesos: “Queroquerai icaimanai tiapa sërari, maba pinganque: ‘Teni nogótiri Jesos’ ”. Cara iquengairo ora icanqueri Jesos, iragasantanaca Peroro. ");
INSERT INTO notNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Oquëtaguetamananaque, yapatotaigaca itingomiegui saseriroti aisati antiasiparipague aisati iraegui ogomeantiro isanguenare Moisés. Aisati yapatotaigaca basini obatacagantatsiri icarati 71. Iquengaigaca, yoguëshotaiguëri Ira Jesos, yágaiganaqueri cara Piratoquë, ipaigapëri Pirato ira cobeingari. ");
INSERT INTO notNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yosamitobëri Jesos Pirato: —¿Obiroco Itingomi joríojegui? Yotabitanëri Jesos: —Jee. Naro aisonori ora picanque. ");
INSERT INTO notNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Icantocotaguetasicari Jesos itingomiegui saseriroti, icantaiguë: —Tojai icantagueque ora te ongomeite. Te inganinate Iriro. ");
INSERT INTO notNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aisati yosamitairi Pirato icanqueri Ira Jesos: —¿Pairo te potabitëmatobitiri? Tojai icomantëgotaiguëmi cara picantaguetiro te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Carari te irotopitëmatiri Jesos irooti cara iquenganeintasantanacari Pirato. ");
INSERT INTO notNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aro antagaisati osarini omoncaraca jiesita cara iquengaigaca joríojegui jiraisonori cara yabisobenqueri ironomire Tosorintsi cara Ejípitoquë. Cara jiesitaquë yameta Pirato iromisotocajiri paniro ira yomingui iromingamentoquë, ira icoigaiguë jorío. ");
INSERT INTO notNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ainta iromingane ijita Barabás. Yomianqueri irironta ógueri aisati icantaiguëri imatsiguenga: “Intsome ojocajiri Iromasati ogobeingarite”. ");
INSERT INTO notNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aro yapatotaigaca joríojegui, icocagaiguëri ira Pirato: —Yamaica nocogaiguini pingantinaro ora pameta: pomisotocajiri paniro iromingaga. ");
INSERT INTO notNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yotabitaigabaqueri Pirato yosamitaiguëri: —¿Picogaiguico cara nomisotocajimiri Ira Itingomi joríojegui? ");
INSERT INTO notNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Icanque negaca Pirato aroquenta igóque cara iguisaneintasicari Jesos itingomiegui saseriroti tenta iraninte inguemisantiri Jesos matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Carari itingomiegui saseriroti icantacagaiguëri joríojegui: —Nocogaiguini pomisotogajiri ira Barabás. ");
INSERT INTO notNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aique yosamitaiguëri Pirato: —¿Pairo nanganqueri Ira Jesos Ira pijitaiguë Itingomi joríojegui? ");
INSERT INTO notNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Icantaiguëri catsigue joríojegui: —¡Popëicotiri corosiquë! ");
INSERT INTO notNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Yotabitaiguëri Pirato: —¿Pairo icanque quimingari ora nopëicobiriqueri? Icaimaiganaque jorío catsigue: —¡Popëicotiri! ");
INSERT INTO notNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Icogasanti Pirato iraganinataiguëri matsiguenga. Aro yomisotocajiri Barabás, ipaiguëri joríojegui. Aisati igáqueri soraro iripasataiguëri Jesos aisati iribëquëgotëri. ");
INSERT INTO notNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aique yágaiganaqueri Ira Jesos cara ibangoquë cobeingari, tsomagui, ora jitacha peretorio. Yapatotaiguëri omagaro basini irapisorarote. ");
INSERT INTO notNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aro icaagaigabaqueri Jesos manchaguintsi quiraaquisaamagori. Aisati yobetsiquëneri imatseiro iroonti totsei, imatseiqueri. ");
INSERT INTO notNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aique isërontaigacari, yobetsatomemegaigacari: —¡Obiro Natingomi! ¡Intimeta Itingomi joríojegui! ");
INSERT INTO notNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yágaiguë anchaqui ipasatantaigacari iguitoquë, ijobatopiantaiguëri, yobaticagueritotomemegasitacari, itingomintomemegacari. ");
INSERT INTO notNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cara itsongaiguë icabíntsátaiguëri isërontaigacari, yágabitsaqueri manchaguintsi quiraaquisaamagori, icaagobairi iraisati imanchaqui. Aique yágaiganaqueri cara iribëquëcoiguëri. ");
INSERT INTO notNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Itonguibocari sërari Sirenesati, ijita Simón. Iriro iriri Arijantoro aisati Irojo. Ipaniaca parigoti, iáque Jerosarénquë. Imeratobacari soraro, igáqueri: —Páganëneri igorosite. Aro yáganëneri irooti cara ");
INSERT INTO notNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","yaretaigaca Górogotaquë ora ocanti osigaro iguito igamaga. ");
INSERT INTO notNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aro ipabitacari Jesos oja oba ogonoataga casangajengaro jitacha mira, carari te iróguimaro Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aro ira soraropague ipëicotaiguëri Jesos cara corosiquë, aique imaguimpibintëqueri imanchaqui Jesos ipabacaguecaro yotsatiancaro. ");
INSERT INTO notNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Terai irionogatasante paba cara ipëicoqueri. ");
INSERT INTO notNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Isanguenaquero pairoraca ipëicobiriqueri. Ocanque: “Ica Iriro Itingomi joríojegui”. ");
INSERT INTO notNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aisati ipëicoqueri pite cosirinti itsibatacari Jesos. Ainta paniro ibacosonoriquë Jesos, basini imatepacoquë. ");
INSERT INTO notNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aro omoncaraca Sanguenari ora ocanti negaca: Itsibatacari ira cantaguetiro te onganinate. ");
INSERT INTO notNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ainta abisanaqueri abatsiquë iniopëri Jesos, icabegaiguëri, ipoteguitotaigapa, ");
INSERT INTO notNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","icantaiguëri: —Obiro ogomeriguetirone ibango Tosorintsi, aisati ongaraque maba cataguiteri, pobetsicairo. Atsi yamai pigabisaicotajima Obiati. Cagarimica matobiantatsiri, piguëtajima corosiquë. ");
INSERT INTO notNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aisati isërontaigacari itingomiegui saseriroti aisati iraegui ogomeantiro isanguenare Moisés icantobaca: —Yogabisaicotaiguëri imatsiguenga carari te iragabisaicotima Iriati. ");
INSERT INTO notNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iriroca Itingomi joríojegui, Agabisaicoontatsiri, iraguëtajimata Iriati corosiquë. Nanetsaiguëri, aro nanguemisantaiguëri. Aisa icanca ira cosirinti itsibatancari ipëicoqueri icantocotaguetasicari Ira Jesos, icabegaiguëri aisati. ");
INSERT INTO notNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cara catinga paba otsitiniguitetanë antagaisati quibatsi irooti cara inëmatanë paba ochapinitanë. ");
INSERT INTO notNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Cara ochapinitanë icaibatanë Jesos. —Eroi, Eroi, ¿Irama sabacatani? Ora ocanti: “Pabati, Notosorintsite, ¿Pairo pijocobitanëna?” ");
INSERT INTO notNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ainta matsiguenga cara, iquemaiguëri icantaiguë: —Pinguemobëri. Icaimërini Erías comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aro isiganaca poro, yáguë ichomicantaro, yoaquero obaaquë cochoari. Yoguëneri chocopiquë itimagonaguitanaca ipabitacari Jesos, icanque: —Irinita. Atsi anetseri aroca iribocasitapëri Erías iraguëpëri iragabisaicoqueri. ");
INSERT INTO notNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aro icaimasantanë Jesos, irooti icamantaca. ");
INSERT INTO notNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cara icamaque Jesos, aito cara otisaraanaca aganguisati ora yotigantaro ibango Tosorintsi. Iroonti oquibepiriga tera yoguëro arota quero iqui pairiraca. Oparintaca jonoquë, otisaraaca irooti osobi. ");
INSERT INTO notNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aro ira capitán inetsaseguiri Jesos, ati icanta cara icaibatanë aisati icamaque. Icanque: —Aisonori Ica sërarica Iriro Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aintasati cantaqueronta tsinanepague onetsaiguëri Jesos. Ainta María Magararasato, aitosati basini María iniro Santiago carantatsi aisati iniro José, aisati Saromé. ");
INSERT INTO notNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ocapague tsinane poguiataiguëri Ira Jesos cara Garireaquë, opaiguëri iraperi, tojai omitocoiguëri. Aisati ainta basini tsinanepague aguiataigapëri irooti Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aroque ochapinitanë. Iroro cataguiteri cara yobetsicaiguë jiesita queroquerai pareta sábaro cara imagoriaigui. ");
INSERT INTO notNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aro ipocasiqueri Pirato poro Arimateasati jitacha José. Iriro icarataigui basini obatacagantatsiri icarati 71 cara yapatotaigaca. Iriro iniacaninataiguë matsiguenga aisati yoguiaquero iragáantane Tosorintsi cara intingomibintaiguëri antagaisati matsiguenga. Te intsoroguiri ira cobeingari; ipocasipëri yamanopëri: —Camaque Jesos. Nocogui pinintacaguina náganëri igamaga nomianqueri omoroquë. ");
INSERT INTO notNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Imabocaca Pirato cara aroque icamaque Jesos. Icaimagantëri igapitante soraro, yosamitobëri: —¿Aisonori camaque Jesos? ");
INSERT INTO notNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cara icomantëri capitán Pirato cara aisonori icamaque, ipëri José igamaga Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aique iáque José yamanantëro tocoya caninaro irorai, yoguëpëri igamaga Jesos, iponatancari tocoya, yomianqueri omoroquë ora yomoroquera jirai cara mopëquë, ititiguëro mopë yasitocoontobacari. ");
INSERT INTO notNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Cara yomianqueri igamaga Jesos tsomagui onetsaiguëri María Magararasato aisati basini María iniro José. ");
INSERT INTO notNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pabisanaque cataguiteri comagoriantague aique piáiguë maba tsinane, María Magararasato, María iniro Santiago aisati Saromé. Piáiguë pamanantaiguë casangajengaro arota otiritaiguerime Jesos. ");
INSERT INTO notNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Oquëtaguetanai, iroonti tominco, cara iriraique contepatsi paba, paretaigaca tsinane omoroquë. ");
INSERT INTO notNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Posamitobaca: —¿Pairiraca titigaigacáirone ora mopë yasiantacaro omoro? ");
INSERT INTO notNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ocantaiguë negaca oquibeguintenta mopë. Cara onetsaigapëro oquibe mopë, aroque osiringaja. ");
INSERT INTO notNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aro ocaiganaque tsomagui omoroquë oniopëri oboina sërari isobigasegui obacosonoriquë. Iquitsagata manchaguintsi catarisonori. Oniaigapëri oquenganeintasantaigapa otsorogaiganaque. ");
INSERT INTO notNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Icantaigabaquero: —Quero pitsorogaigui. Nigóque picogaigabitarini Jesos Nasaresati Ira ipëicoiguë corosiquë. Teni irinaje yaca; aroque icaniatanai, icabiritanaa. Pinetse yaca cara yoguëri. ");
INSERT INTO notNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yamai pijáigue pingomantaigapëri irogomerejegui aisati Peroro: “Aique iriátë Jesos cara Garireaquë cara icantaiguëmi jirai, irobataiganaquemi”. ");
INSERT INTO notNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aique pisotogaiganaji maba tsinane omoroquë, pisigaiganaca. Oquenganeintasantanaca, omogomogoataiganaca otsorogaiganaque. Te ongomantëmatiri pairiraca otsorogasantaiguënta. ");
INSERT INTO notNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cara icaniatanai Jesos tomincoquë, irotsita yoniagapaa María Magararasato ora ijoquine ogamagarite icarati 7 jirai cara inantabecaro. ");
INSERT INTO notNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aique piáque ocomantapëri iraegui itsibataiga Jesos cara aroque icabiritaja. Yogasëretaigasega aisati iragaigasega ");
INSERT INTO notNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","cara ocomantaigabitapari: —Caniatanai Jesos Atingomi, naniajiri. Carari te irajitaigabaquero. ");
INSERT INTO notNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aique ipasiniatitanë Jesos cara yoniagapaari pite irogomere yanëitaigasegui abatsiquë iáiguë iritoganequë. ");
INSERT INTO notNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iriro pite ipigaigaa icomantaigapëri ira basini irogomere Jesos. Teatisati irajitaigabaqueri iriro. ");
INSERT INTO notNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aiquenta yoniagaigapaari irogomere icarati 11 cara yapaisigui. Isintsitsataigapëri icanque: —¿Teco nongomantaiguemi nangabiritajima? ¿Pairo te pijitobitina? Picantaigaca te ine pisëre. ¿Pairo te pijitobitaigueri ira niaigaina Naro? ");
INSERT INTO notNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aisati Jesos icantaiguëri irogomere: —Pijáigue antagaisatiquë quibatsi, pingomantëgotaguetinaro omagaro matsiguengajeguiquë oca Caninaroca Nibarintsi cara nacamobiqueri, nacaniatanai. ");
INSERT INTO notNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pairiraca quemisanquerone oca Caninaroca Nibarintsi aisati imaotisatëma, iragabisaicotajiri Tosorintsi. Ira quero iquemisantiri, Tosorintsi iratsipiriacaqueri iriro Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ira quemisanquerine, Tosorintsi oniagaiguëmari itasorintsite. Iragántantaiguëmaro nopairo camagaripague. Irinibaquero irorai nibarintsi. Cara iraniaiguëri imatsiguenga irogóontimaro aisonori ora icomantaiguë. ");
INSERT INTO notNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aisati imogotirica marangue, aroca iratsiquëri, quero icami. Aroca iróguimaro pigantatsiri, querootisati icami. Iroquinerica ibaco janaitatsiri, aro iragaguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iroro oca icantaiguëri irogomere Atingomi Jesos, aique iáque jonoquë. Yogainocanaa isobiaque ibacosonoriquë Tosorintsi, itsibatari Iriri cara itingomibintanti. ");
INSERT INTO notNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aique iátagueque irogomere iquenagueque icomantaguetaiguëri antagaisati matsiguenga aisati icanta Atingomi Jesos. Coshoni yogaiguëri Jesos imitocoiguëri cara itasongagueanti arota irogóte matsiguenga cara aisonori ora icomantagueanti. Aro ocarati ora nasanguenaque. Maricos ");
INSERT INTO notNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","¿Aintabi Tiójiro? Yamai naninti nongomantëgotëmiri Jesoquirisito. Ainta tojai aroque isanguenatocoqueri, icomantëgotëro ora icantagueque Iriro. Iniaiguëri aisati iquemaiguëri, iroro isanguenatocotaguëqueri Quirisito, iquenguitsatocoqueri. Ninibatëro isanguenare aisati nosamitasantaguequeri arota nogótocotasantiri Jesos cara iparintaca irooti yamai. Aroque nigóquero antagaisati. Yamai nagáquemiro, nocoguini pigóte catingasati obiro ora icantagueque Jesos, pigóte teni iromatobitaiguemi ira comantaiguëmi aisati ira sanguenataiguëmiro. ");
INSERT INTO notNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jirai, cara itingomibintanti Eroris cara Joreaquë, ainta saseriroti ijita Sacarías. Iriro imatsiguenga Abías. Icanquineri Tosorintsi cara oquibequë ibango. Ainta iina Sacarías ojita Isabel, aisati imatsiguenga Aarón. ");
INSERT INTO notNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iquemisanti Sacarías, aisati iina. Icantaguequineri Tosorintsi omagaro ora icocaqueri, aisati imatsiguenga iniacaninataiguëri pitirooti. ");
INSERT INTO notNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Te irine itomi, sirabaronta iina. Aisati intiasiparitanë pitirooti. ");
INSERT INTO notNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Aro omoncaraca cataguiteri cara icantaiguëneri Tosorintsi imatsiguenga Abías. Yametaigaro irirojegui iragáqueri paniro saseriroti iritaguëneri Tosorintsi casangajengaro. ");
INSERT INTO notNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Icanqueri Sacarías irapisaserirotite: —Yamai atsi obiro pitaguineri Atingomi casangajengaro. ");
INSERT INTO notNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aro icapë oquibequë ibango Tosorintsi cara Jerosarénquë. Sotoquë ainta inaigasegui tojai bototaigachari yamanaigasegui cara itaquero casangajengaro tsomagui. ");
INSERT INTO notNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Iriguito iconijatomopëri ironomire Tosorintsi irisaanganetsite yaratingopë cara pitagani casangajengaro. Yaratianque imatepacoquë Sacarías. ");
INSERT INTO notNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cara iniobëri Sacarías, iquenganeintasantobacari itsorogobëri, ");
INSERT INTO notNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","carari icampëri: —Sacarías, quero pitsorogui. Tojai pamanopiantëri Tosorintsi. Aroque iquemaquemi: aiquenta ontsomaaqueri otomi pijina. Pijitobëri Joan. ");
INSERT INTO notNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tojai pinganinabenqueri obiro, aisati inganinabentaiguëri tojai pomatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Iraniacaninatëri iriro Tosorintsi iraguibatëri. Quero yóga obaa querootisati pairoraca cochoari. Coshoni ogasantëri Isëre Tosorintsi; cara queroquerai ini coshoni oguëri, inantasantëmari. Përosati ogomequeri. ");
INSERT INTO notNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Inguemisantacagaiguëri tojai jorío imatsiguenga arota intingomintaiguëmari Tosorintsi, casintari antagaisati. ");
INSERT INTO notNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aisati inganquimari ibega Erías, tojainta ogomequeri Isëre Tosorintsi, aisati onganqueri iritosongantë tojai. Irobaqueri Atingomi, ingomantaiguëri imatsiguenga iraguiaigabaqueri, inguemisantaigabaqueri Ira bocatsi aisa icanta imatsiguenga jirai iquemisantaiguëri Tosorintsi. Inganqueri sëraripague inguengasëretaguimari itomi. Irogometaiguëri tsoengatsiripague inguemisantiri Atingomi, inganquero ora caninari. Irobetsicaiguëri imatsiguenga irágacaninataigabaqueri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yosamitobëri Sacarías: —¿Aisonori? ¿Ati nangantima nogótasantë aisonorica oca picomantënaca? Aroque nantiasiparitanë naro, aisati ontiasiporotanë najina. ");
INSERT INTO notNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aro yotabitanairi irisaanganetsite Tosorintsi: —Naro Gabiriel, coshoni noguëri Tosorintsi. Igáquina nongomantëmiro oca Nibarintsica caninatatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aiquenta omoncaraquima omagaro oca nocomantëmica, carari aroquenta pitsoinguëna, yamai nogótacaquimiro pomasontitanë, quero pinibatai irooti cara irinaque pitomi. ");
INSERT INTO notNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cara sotoquë, iquenganeintaigaca tojai jorío, yoguiaigabitacari Sacarías, icantobaca: —Cosamani inasegui tsomagui. ¿Pairo te irisotocobite? ");
INSERT INTO notNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aique isotocopai ibangoquë Tosorintsi. Te irinibataje, ijicoguitetasipaa. Aro igóiguë jorío, icantaiguë: —Ainta ira iniaque tsomagui. Sacarías mosontisonori. ");
INSERT INTO notNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Poro tominco intëneri Tosorintsi cara oquibequë ibango. Aique ipiganaja Sacarías irasiquë ibango. ");
INSERT INTO notNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aique opënibatanë iina, pimánaca obangoquë. Icarati pabocorooti manchacori te osotocaje. ");
INSERT INTO notNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Oquianca ocanque: —Jirai nipasiquique tenta irine notomi, carari quero nipasiquiti aisati. Icábintsëna Natingomi. Iriro caninarisonori. ");
INSERT INTO notNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aroque pogabisë 6 manchacori cara poguë Isabel iina Sacarías. Aro aisati igáqueri Gabiriel Tosorintsi: —Pijáte poeboroquë jitacha Nasaret cara Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pingantiro María, iinatsari José. Iriro imatsiguenga David. Te oniobintiri sërari carari ocogui águiri José. ");
INSERT INTO notNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aro iátasiquero. Yoniagaparo icampëro: —¿Aintabi, María? Naro bocatsi, naniaquemini. Nongomantëmini cara tojai inintasantimi Tosorintsi, tojai icábintsasantëmi, iniacaninatëmi, coshoni yoguëmi. Pobataiguëro antagaisati basini tsinane. ");
INSERT INTO notNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Otsorogobëri María cara inibatapëro negaca. Oquianca: “¿Pairoraca ocanti oca”? ");
INSERT INTO notNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aro icampëro aisati: —María, quero pitsorogui. Aisonori icábintsasantëmi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iroro poguëque. Aiquenta cara iriboganaque Pitomi, pijitiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iriro obaquenguitsine Itingomisonorinta. Aisati Iriro Itomi Tosorintsi jonoquënintaberi. Tosorintsi inganqueri Igobeingarite jorío, imërini iragáantomento David icharine jirai. ");
INSERT INTO notNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Inganqueri Tosorintsi: “Notomi, përosati pintingomibintaiguëri omagaro joríojegui paniaiguënguicha Jacoboquë”. Përosati iragáantë, quero pitsonga iragáantane cara intingomibintaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aro María posamitobëri irisaanganetsite: —¿Ati ongantima oca picanquenaca, terainta naniobintiri sërari? ");
INSERT INTO notNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yotabitanëro: —Inapëmi Isëre Caninaro Tosorintsi. Aisati iritosonquimi Tosorintsi jonoquënintaberi, inapëmi isintsire aisa ocantaro pibega mingori. Iroro ora iribogaguëque Pijaniquite, Iriro caninarisonori Itomi Tosorintsi. Ingantocoqueri: “Icaninatasanti Iriro. Te ingantaguetëmate ora te onganinate Irironta Itomi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aisati pomatsiguenga Isabel antiasiporo, te ogue jirai, yamai opënibatirini otomi aroque 6 manchacori ");
INSERT INTO notNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","tenta ine ora comëtomotimarine Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aro ocanë María: —Iriro Natingomi. Ongonijatomotinata pairoraca icocaquina. Ingocaquinaca nontsomaaqueri Notomi cara picomantëna, aro caninataque. Irooti isaanganai ironomire Tosorintsi iátaji, te oniobairi aisati. ");
INSERT INTO notNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Aro pobetsicaca María. Oquëtaguetanë piáque omanapague aiquero cara Joreaquë. Pitonganaque ");
INSERT INTO notNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","piátasiquero Isabel. Pareca ibangoquë Sacarías. Ocapë oniopëro Isabel, ocampëro: —¿Aintabi? Naniaquemini. ");
INSERT INTO notNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Oquemobëro María Isabel cara pobetsataparo, aro yosebatanaca otomi Isabel tsomagui, pinantasantacaronta Isëre Tosorintsi, pogomequero. ");
INSERT INTO notNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Iroro ora ocantaguëtanë, ocanque: —¡Icantaneintëgotacái Tosorintsi! Icábintsaiguëro omagaro tsinane, carari obiro icábintsasantëmi, pobataiguëro antagaisati tsinane. Aisati icábintsasantëri Pijaniquite. ");
INSERT INTO notNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Obiro iniro Natingomi, Ira Pijaniquite. ¿Pairoroco pipocasibiriquina naro tenta nobatëmate? ");
INSERT INTO notNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Naquemobëmi cara pibetsatapëna; aito cara icaninatanë najaniquite yosebatanaca tsomagui natsaguiquë. ");
INSERT INTO notNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aisati picaninatanë obiro aroquenta piquemisantobëro ora icomantagantëmira Atingomi. Iromoncaraquemiro Irinibare. ");
INSERT INTO notNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aro ocanque María: —Nacantasëretë: “Caninarisonoriguinte Natingomi”. ");
INSERT INTO notNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tojai nacaninabentasantëri Irironta Notosorintsite, Nagabisaicoontatsirite. ");
INSERT INTO notNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","¿Pairo icábintsabiriquina naro? Te nobate, teatisati nogóte, carari iniaquina icábintsasantëna. Iroro irinibatocotaguëquina omagaro matsiguenga yaca quibatsica cara nacaninabentasantëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tojai itasongobenquina Irironta sintsirisonoriguinte. Itasorintsitasanotë, icaninatasanoti; te ingantaguetëmate quimingari. ");
INSERT INTO notNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Përosati icantaneintëgotaiguëri antagaisati ira quemisantiri, ira tingomincari; icantaneintëgotaiguëri omatsiguenga jiraisonori irooti yamai icantaneintëgotaiguëna. ");
INSERT INTO notNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tojai itasongagueanti. Yoguipasiguitëri aguibataigachari ira jitaigacha iriati caninari. ");
INSERT INTO notNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yágabitsataiguëri cobeingaripague ira tingomintaigabitachari. Carari yoguibataiguëri ira te irajicaninatima iriati, inganqueri cobeingari iriro. ");
INSERT INTO notNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yoguemagaiguëri ira tasegabetacha, iroro cantënguicha yágabitsaqueri casintaguetachari ora inomotiri. ");
INSERT INTO notNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Përosati Tosorintsi imitocotaiguëri antagaisati omatsiguenga quemisanqueri, përosati iquengaiguëri, icantaneintëgotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aroque omoncaraca Irinibare, icanquero antagaisati ora icantaiguëri Abaram jirai. Aisati icanquero omagaro ora icantaiguëri imatsiguenga Abaram aisati inganquero përosati. ");
INSERT INTO notNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ocari oca ocanque María. Aro otiomoquero Isabel maba manchacori, aique pipiganaja asiquë obango cara opaniaca. ");
INSERT INTO notNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aro omoncaraca cataguiteri cara otsomaaqueri otomi Isabel. ");
INSERT INTO notNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ocaninatasantanë. Iquemocotaiguëro omatsiguengajegui, icaninabentaiguëro. Icantaiguë: —Icantaneintëgotasantëro Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pabisanaque 7 cataguiteri. Oquëtaguetanai ipocasitaigapëri janequi arota iritotëqueri arosata omasiquë itegui cara yametaiga joríojegui. Aisati icantaigapë itimanamitane: —Caninataque irajitima Sacarías irágapairotajiri iriri. ");
INSERT INTO notNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Orari iniro ocantaigabaqueri: —Quero ijita Sacarías; iroonti irajiquima Joan. ");
INSERT INTO notNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yotabitaiganaquero: —¿Pairo pinintobique pijitiri Joan? Teni irine Joan pomatsiguengaquë. ");
INSERT INTO notNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aro ijigotaqueri Sacarías yosamitëri: —Obiro, ¿Pairo pininti obiro irajitima pitomi? ");
INSERT INTO notNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yacotacaqueri iromapëneri paperi, isanguenataiguëneri: “Aroque ijica Joan”. Aro iquenganeintaigaca imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aito cara inibatagajiri Sacarías Tosorintsi inibatai aisati. Icanque: —Icaninatasanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aro iquenganeintasanotaigacari matsiguenga. Antagaisati timaigatsi tongagaripaguequë cara Joreaquë iquemocotaiguëri Joan itomi Sacarías. ");
INSERT INTO notNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iraegui quemocotaiguëri Joan iquengasëretaiganacari yosamitobaca: —¿Ati icanta ira janequira? ¿Pairo inganque aiquenta? Igóiguë cara icábintsëri Joan Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aique Isëre Tosorintsi pinantasantacari Sacarías, pogomequeri, aro icanque: ");
INSERT INTO notNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Caninataque omagaro matsiguenga iraniacaninatiri Atingomi Otosorintstite omagaro eiro jorío icharineegui Isirael. Itasongobentaigacái. Ipocasitaigacái cara iragabisaicotajái. ");
INSERT INTO notNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jirai David icanquineri Tosorintsi ora icocaqueri. Yamai Tosorintsi igáqueri imatsiguenga David, itasorintsitobianti aisati yogabisaicoonti. ");
INSERT INTO notNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Icanque cara icomantëgotëri jirai comantantatsiripague: ");
INSERT INTO notNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Icanë Tosorintsi: ‘Nagáquemiri Ira agabisaicotaiguëmine, aisati iragabeiri ira quisaiguëmine, irojocaiguëmiri. ");
INSERT INTO notNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nangantaneintëgotaiguëri omagaro imatsiguenga Abaram. Quero nopeicotaro ora nacantasantaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jirai nacanqueri picharineegui Abaram: ");
INSERT INTO notNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Aiquenta irinaiguë tojai quisaigabitëmine, carari nagabisaicotaigaimi. Quero pitsorogaigui pinguemisantaigaina; pinganinabentaiguëna. ");
INSERT INTO notNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Noganinasëretaiguëmi querota picantagueti te onganinate. Naniacaninataiguëmi, përosati pingantaiguë ora nococaquemi irooti cara pingamaiguë” ’ ”. Ocari oca icantasantë Tosorintsi jirai. ");
INSERT INTO notNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yamai, notomi, irogótocoquemi matsiguenga obiro comantëgotërine Tosorintsi jonoquënintaberi. Pobetsiquineri Atingomi arota irágacaninataigabaqueri matsiguenga. Pobaqueri Atingomi obiro, pingomantaiguëri pomatsiguenga irobetsicaiganaquema, iraganinasëretaiguema, iragueiri Atingomi boquënguitsine, irágacaninataigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aisati pogometaiguëri pomatsiguenga irogóigue ati ingantima iragabisaicotaigairi Tosorintsi irojocajineri ora icantagueti te ongomeite arota quero iquengaineri aisati. ");
INSERT INTO notNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Pingomantaiguëri aisonori inintasantacái Tosorintsi, tojai icantaneintëgotacái. Cara icontetapë paba, oquëtaguetanai, pabisanaque tsitiniri. ");
INSERT INTO notNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aisa ocanta cara iribocapë Atingomi cara Jonogaguitequë, irosangueguitetocotaigacái eiro cantaguetatsi te onganinate, iragabisaicocái arota anganinabentaigueri antimaigue caninasati. Quero otsorogajiro agamane. Aroque icanquero oca Sacarías. ");
INSERT INTO notNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aro yogabisë tojai irosarinite Joan, iquibianë. Aiquero iquemisantanëri Tosorintsi. Ijocanëri imatsiguenga itimaque cara tera ontimingani irooti cara cataguiteriquë cara iparintaca iquenguitsatomotaiganaqueri imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Cara aroque inë Joan, ainta cobeingari Iromasati ijita Sésar Agósito. Itingomibintaiguëri omagaro quibatsisati. Icanque cara irisanguenatëgotaguequima antagaisati matsiguenga arota iripënabintiri quirequi impoesito. ");
INSERT INTO notNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Te irisanguenatëgotima jirai. Icanquero cara Quirinio itingomi cara Siriaquë. ");
INSERT INTO notNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aique iáiguë omagaro cara iboeborotequë imatsiguenga jirai, isanguenatocotaigaca. ");
INSERT INTO notNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Itimi José canta poeboroquë jitacha Nasaret cara quibatsiquë jitacha Garirea. Aique iáque itonganaque cara Berénquë cara itimaque David imatsiguenga jirai. Berén pini cara Joreaquë. ");
INSERT INTO notNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yáganëro María iina itsibatanacaro pënibaque ontsomaaque. ");
INSERT INTO notNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cara pinasegui Berénquë, aroque omoncaraca cataguiteri cara ontsomaaque. ");
INSERT INTO notNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Icogabepa José pongotsi, carari tojai matsiguenga iagaigaparo pongotsipague. Aro icanaque cara ibangoquë ibiraegui, cara otsomaaqueri María Ira oguibare Otomi. Oponatancari manchaguintsisite, poguinariaqueri cara cajónquë ora yapantaiga ibiraegui. ");
INSERT INTO notNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ainta inaigasegui aronisatiquë Berén ira omisantaiguiri iroishate tsitiniriquë cara yapaitiro tobarisi. ");
INSERT INTO notNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iroguito poguëtaguetocotasantaiguëri irosangueguitere Tosorintsi. Aisati yoniagaigapari ironomire Atingomi. Itsorogasantaiganaque ira omisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Icampëri irisaanganetsite Tosorintsi: —Quero pitsorogaigui. Nipocasique nongomantaigapëmi Caninaro Nibarintsi ora pinganinasëretantima aisa inganinasëretaiguë omagaro matsiguenga cara inguemaigabaquero. ");
INSERT INTO notNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yamai iboguë cara iboeborotequë David Ira agabisaicotaigaimine. Irianti Quirisito Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iroro pigóontëmari Janequi: cara pijáiguë piniaigapëri oponatancari manchaguintsisite, inariaca cara yapantariquë ibiraegui. ");
INSERT INTO notNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iriguito yoniagaigapari itsibataigapari arosonori basini ironomire Tosorintsi, ipaniaigaca Jonogaguitequë, icantaigapë: —Icaninatasanoti Tosorintsi ");
INSERT INTO notNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ira timatsi Jonogaguitequë. Intsome aniaigueri caninarisonoriguinte. Yaca quibatsica Tosorintsi ingábintsaiguëri iromagoriasëretagaiguëri antagaisati matsiguenga cantaiguëro ora icocagaiguëri, inganqueri intimacagobaguima caninasati. ");
INSERT INTO notNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aique cara iáigai irisaanganetsite Tosorintsi Jonogaguitequë aisati, icantobaca ira omisantaiguiri iroishate: —Intsome cara Berénquë anetsaigueri Ira Agabisaicoontatsiri icomantagantëgotacái Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aito cara iáiganaque omanapague iniaigapëri José aisati María aisati Otomi inariaca cara yapantariquë ibiraegui. ");
INSERT INTO notNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cara iniaigapëri icomantëgotëri Janequi omagaro icantaiguëri irisaanganetsite Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aro iquenganeintasantaigabacari antagaisati quemaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ora María tojai oquengasëretapininquero ora icomantaigapë, te omaguisantiro. ");
INSERT INTO notNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aique ipigaigaca omisantiri iroishate, icantaiguë: —Aisonori icaninatasanoti Tosorintsi. Ocaninati omagaro ora icomantacái; pabisanaque irooti cara yoniagaigacái. Caninari ini Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cara yogabisanë Jesos 7 cataguiteri, oquëtaguetanai itoquengani cara yametaiga joríojegui. Aisati ijitaiguëri Jesos, cara icanquero María irisaanganetsite Tosorintsi jirai. ");
INSERT INTO notNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jirai Tosorintsi isanguenatacaqueri Moisés cara ontsomaaquerica tsinane otomi, 40 cataguiteri ontimaque obangoquë; quero piáti oconoitari quemisantatsiri. Aro imoncaraquero José isanguenare Moisés: cara omoncaraca 40 cataguiteri, yágaiganaqueri Jesos cara Jerosarénquë arota imëri Tosorintsi cara oquibequë ibango, icanque: —Jerica notomi obatatsi. Pairoraca pingocaqueri, nocogui ingantimiro. ");
INSERT INTO notNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ocari oca icanque Tosorintsi isanguenatacaqueri Moisés: Ira obatatsi otomi tsinane irianti irasi Atingomi, intomintëmari. ");
INSERT INTO notNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aisati piáque María omëri Tosorintsi ira icoicoque Iriro Sanguenariquë: pite sompaguiti queroca pite paroma. Omoncaraca omagaro ora ocanque Sanguenari. ");
INSERT INTO notNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ainta itimi Jerosarénquë sërari ijita Simeón. Iquemisantasantëri Tosorintsi aisati itimi caninasati aisati yoguiaqueri Ira Agabisaicoontatsiri, Ira aganinasëretaiguërine antagaisati joríojegui imatsiguenga. Pinancari Simeón Isëre Caninaro Tosorintsi, iquemisantasantëro. ");
INSERT INTO notNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aroque poniaguëri Isëre Caninaro cara quero icami irooti cara iraniobëri Quirisito, Ira iragáque Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Piátacaqueri Simeón Isëre cara ibangoquë Tosorintsi. Ainta, cara icanaque José aisati María inganquineri Jesos ora icoicoque Tosorintsi Sanguenariquë. ");
INSERT INTO notNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Iniobëri Jesos Simeón, iátasiqueri, itsomaabëri, icanqueri Tosorintsi: ");
INSERT INTO notNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","—Picaninatasanoti, Natingomi, casintina. Yamai naniaqueri Ira Agabisaicoontatsiri Ira picantocoquina. Aroque yamai; te naninte nantime yaca aisati. Yamai caninataque najáque Obiroquë. ");
INSERT INTO notNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aisonori, pigáqueri iragabisaicotaigairi omagaro matsiguengapague. ");
INSERT INTO notNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Irosangueguitetocotaiguëri iraegui cagari jorío, irogótacaqueri ora aisonori; aisati iraganinataiguëri joríojegui ira quemisantaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José aisati María iniro Jesos iquemaiguëro ora icantocoqueri Jesos Simeón, iquenganeintasantaiganaca. ");
INSERT INTO notNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Icantocobentaiguëri pitirooti: —Nocogui ingábintsaiguemi Tosorintsi. Aisati icanquero María: —Ica Pitomi igáque Tosorintsi iragabisaicotaiguëri tojai jorío quemisanquerine, carari ainta tojai inguisaneintaiguëri iritsoenguiri; iratsipiriacagaiguëri Iriro. Ipocasique iragabisaicotaigueri omagaro, carari ingonagaiguëma matsiguenga. Ainta inganinabentaigabaqueri, ira basini iripëgatsataigabaquimari: Iriro ogonijatomoquerine ora iquengaiga matsiguenga. Aiquenta tojai piraicoqueri Pitomi. ");
INSERT INTO notNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aisati ainta cara tsinane comantantatsiri ojita Ana. Iroro irisinto Panoel imatsiguenga Aser itomi Jacob jirai. Ontiasiporotasantanë; otimacaqueri ojime 7 osarini cara icamaque; ");
INSERT INTO notNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yamai pinasitaa ora ogamaimentaga 84 osarini basini. Përosati pamanocotiri Tosorintsi cara ibangoquë. Tojai ocaninabenqueri cataguiteriquë aisati tsitiniriquë. Te onguenguero operi. ");
INSERT INTO notNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aique pipoque Ana, oniopëri Jesos, ocarasiatocoqueri Tosorintsi. Aisati ocantocoqueri omatsiguenga Jerosaresati aguiaiguëri Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cara imoncarataiguë José aisati María ora icanque Atingomi Sanguenariquë, ipigaiganaja Garireaquë cara poeboroquë jitacha Nasaret. ");
INSERT INTO notNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aro iquibianë Jesos, isintsitanë, aiquero iátanëtigue igótasantanë, yabisaiguëri basini irapijaneguite. Aisati tojai icábintsasanoqueri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yametaiga José aisati María iátopiantaiguë omagaro osarini cara Jerosarénquë, imoncaraquero cataguiteri Pásicoa cara jirai yabisanaque jonoquë ironomire Tosorintsi, yogabisaicotaiguëri jorío cara Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cara yogabisë Jesos 12 osarini, itsibatari casintari Jerosarénquë cara yametaiga jorío. ");
INSERT INTO notNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aique cara pabisanaque jiesita, ora Pásicoa, ipigaiganaja tojai imatsiguenga carari përosati inë Jesos cara Jerosarénquë. Te irogóte casintari; ");
INSERT INTO notNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ijitaigabitaca itsibataigaari basini imatsiguenga. Patiro cataguiteri yanëiiguë. Cara ochapinitanë icogaigabitacari, ");
INSERT INTO notNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","te iraneiri. Oquëtaguetanë ipigaiganaja Jerosarénquë icogaigabitacari. ");
INSERT INTO notNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Maba cataguiteri te iraniajiri Jesos, aique iniaigairi isobiaque oquibequë ibango Tosorintsi. Itsibataigari ira ogomeantiro isanguenare Moisés, iquemisantaiguëri cara yogomeantagueti, aisati yosamitaiguëri pairoraca. ");
INSERT INTO notNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Antagaisati ira quemaiguëri iquenganeintasantaigacari tojainta igótasanti aisati caninasati yotabitaiganaqueri ogomeantatsiri ora comëtaro. ");
INSERT INTO notNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cara iniaigapëri José aisati iniro, iquenganeintasantacari. Ocanqueri iniro: —Notomi, ¿Pairo picantobitaiguëna negaca? Nocogaigabitëmi naro aisati piri nogasëretocoquemi. ");
INSERT INTO notNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yotabitanëro Jesos: —¿Pairo picogobiquina? ¿Teco pigóte caninataque nantineri Pabati yaca ibangoquëca ora icocaquina Iriro? ");
INSERT INTO notNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Carari te inguemaigue ora icantabecari. ");
INSERT INTO notNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aique iátaji itsibataiganajari cara Nasarequë. Përosati iquemisanqueri iriri aisati iniro, te iripëgatsatëmatimari. Ora iniro oquengasëretëgotacari Otomi antagaisati pigótocoqueri. ");
INSERT INTO notNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aiquero iátanëtigue Jesos igótasantanë, iquibianë. Tosorintsi icábintsasantëri icaninabenqueri, aisati icaninabentaiguëri matsiguengajegui. ");
INSERT INTO notNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jirai ainta cobeingari jitacha Tiberio Sésar ocarati 15 osarini icobeingabintaiguëri Iromasatijegui; igáantëri basini itingomipague: ainta Pontsio Pirato itingomi Joreasati; Eroris itingomi Garireasati; Jeripe, ireinti Eroris, itingomi Itoreasati aisati Taraconitesati; Irisania itingomi Abirenesati; ");
INSERT INTO notNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ainta itingomi saserirotijegui Anás aisati Caijás. Ainta icaegui itingomi, cara inibatë Tosorintsi icanqueri Joan itomi Sacarías: —Pijáte pinguenguitsatomotaigueri pomatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aro iquemisanqueri Joan, iquenagueque cara Joriránquë aisati aronisati, yotsatengaiguëri imatsiguenga icantaiguëri: —Pingantaigaima yacaqueroca, pijocajiro ora picantaguetabeca te onganinate, pomasiniatitaje, quero picantaja pibega jirai. Pomaotisatima. Aro irojocajimiro Tosorintsi ora picantagueti te onganinate, iromaguisanquero, quero iguisaneintajimi. ");
INSERT INTO notNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Imoncaraquero Joan ora jirai isanguenatocoqueri Isaías comantantatsiri: Ainta ira cajemaquenguitsine cara te ontimingani, inganque: “Coraguetaque Atingomi, págacaninatobëri; pinguemisantasantobëri, piganinatiro paneingomento pibega cara pobetsicoboguitineri irabo itingomi, pigatingatiro. ");
INSERT INTO notNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pijaguiro otininapague; quero pimánantaro pairoraca. Pinguiguiro tongagaripague. Pigatingatajiro cara pitigontigoiboguiti abatsi. Pobetsicaineri Atingomi caninasati. Pijocajiro ora picantagueti quimingaro, pobetsicasëretima caninasati arota inganinatapë. ");
INSERT INTO notNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aique omagaro matsiguenga iraniaigabaqueri Agabisaicoontatsiri Ira igáque Tosorintsi”. Aro negaca isanguenaque Isaías. ");
INSERT INTO notNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aique iátasitaiguëri Joan tojai matsiguenga imaotisataiguëmame. Carari icanque Joan: —Te pinganinataigue, obirojegui aisa picantaigacari marangue. ¿Pairi comantaiguëmi pisigopitanëmaro cara iratsipiriacagaiguëmi Tosorintsi cantaca maranguepague cara isigopitaigacaro pamari? ¿Pijitasitimame aroca nomaotisataiguimime quero iguisaiguimi Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pinintica nomaotisataiguemi, aro caninataque pingantaguete caninasati, pintimaigue caninasati, arota nogótimi pijocasantëroca ora te ongomeite, piquemisantasantiri Tosorintsi. Pinetsaigueri iraegui matsiguenga cagari jorío. Iranintiroca Tosorintsi, imiaguetiri imatsiguenga Abaram, carari quero yabisaicoonta irironta imatsiguenga Abaram. Querootisati pabisaicoonta obiatinta imatsiguenga; quero iroro iniacaninataguëtaiguimi. ");
INSERT INTO notNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Carari yamai pënibaque inguisaiguëmi Tosorintsi. Picantaigacaro pibega anchato te ine oguitso; iritotëro casintaro, irojoquero tsitsiquë. Aisa picanta obiro te pinguemisantiri Tosorintsi, te pingantineri, irojocaiguëmi Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aro yosamitapinintaiguëri iraegui quemaiguëri: —¿Pairoraca picogui nangantaigue naroegui? ");
INSERT INTO notNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yotabitaiguëri Joan: —Aitica pite piguitsagare, pomagarantiri coguitiachari patiro. Aitica tojai poperi, pomagarantiri aisati coguitiaro. Pingábintseri. ");
INSERT INTO notNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aisati iátasitaiguëri Joan coigotantatsiri iguireguite imatsiguenga ipagantiri igobeingarite (Sésar) canta Iromaquë. Ipocasique imaotisataiguëma, icantaigapëri ira Joan: —Ogomeantatsiri, ¿Pairoraca nangantaiguë naro? ");
INSERT INTO notNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yotabitaigabaqueri Joan: —Quero picoicotasitari iguireguite pomatsiguenga, irianti páguiri pomoncaratiro ora icanquemi Iromasati. ");
INSERT INTO notNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aisati yosamitaigapëri soraropague icantaiguëri: —Naroegui, ¿Pairoraca nanganque naro? Yotabitaiguëri Joan: —Quero págabitsatiri pairoraca yasinta basini aisati quero picantiri: “Queroca popabaquinaro, nanguisëmi”. Quero pinebetari quirequi, quero picantocotaguetasitari matsiguenga arota pomitsoroguiri imëmiri quirequi. Ira quirequi ipënabintimi pitingomi, antagaini; quero picogui basini. ");
INSERT INTO notNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yoguiaiguëri Quirisito matsiguenga botoibiritaigari Joan, yosamitobaca: —¿Iriroco Joan Agabisaicoontatsiri? ");
INSERT INTO notNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iriro cantënguicha Joan icantaiguëri: —Naro nobaotisataiguëmi nijaaquë, carari pënibaque iribocapë basini teni aisa ingantina nibega naro. Ibaquina Irironta Natingomisonori, nitsoingaa naronta cantaca iromeraro Iriro. Cara iribocapë Iriro irogaiguëmiro Caninaro Isëre inasërequimi oganinasëretëmi; carari ainta obirojeguiquë tsoengatsiri iragátaiguëri Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cara iribocapë Quirisito irapatoitaiguëri quemisantatsirijegui aisati ingasiriconiatiqueri. Ingantaiguëri cantaca casintaro arosa osamataga inganquero. Irapatontëmaro oguitso intianquero, iriboteguitëro, irojoquero omasiqui iritaguëro, iroonti oguitso iroquero cara yogantaroriquë. Aisa icanta Quirisito, iráganëri quemisantatsiri Jonogaguitequë, carari iragáqueri tsoengatsiri iritaguëma përosati Sharincabeniquë, iratsipiriaque përosati cara pini tsitsi pamari ora te otsibacanete. ");
INSERT INTO notNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aro tojai Joan icomantapinintaiguëri matsiguenga ora Caninaro Nibarintsi atiraca ongantima iragabisaicoqueri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aisati Joan icamanaaqueri Eroris itingomi, icanqueri cara icantaguetiro te onganinate cara yágabitsaqueri ireinti iina jitacha Erorías. Aisati isintsitsaqueri cara icantaguetiro tojai basini ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aique iguisaneintanëri Eroris yágagantëri Joan yomianqueri, aiquero iátanëtigue icantaguetanë quimingaro. ");
INSERT INTO notNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Teraiquerai irominguengani Joan, cara ibaotisataiguëri tojai matsiguenga, ibaotisatëri Ira Jesos aisati. Iroontita yamanasegui Jesos, pasirianaca Jonogaguite ");
INSERT INTO notNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","pamasobingopëri Caninaro Isëre Tosorintsi paguëpëri ocampari ibega sompaguiti, pinampari Jesos. Aisati oquemaquengani Irinibare Tosorintsi jonoquë icanque: —Obiro Notomi, nanintasanotëmini. Tojai nacaninabentasanotëmi. ");
INSERT INTO notNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aroque yogabisë Jesos 30 osarini cara iparintaca iquenguitsatomotaiguëri imatsiguenga. Ijitaigabitari itomi José carari Irianti itomitsari José. Jesos imatsiguenga Erí. ");
INSERT INTO notNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Erí itomi Matat. Matat itomi Irebí. Irebí itomi Mériqui. Mériqui itomi Jana. Jana itomi José. ");
INSERT INTO notNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José itomi Matatías. Matatías itomi Amós. Amós itomi Naom. Naom itomi Esiri. Esiri itomi Nagai. ");
INSERT INTO notNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai itomi Maat. Maat itomi Matatías. Matatías itomi Semei. Semei itomi José. José itomi Jorá. ");
INSERT INTO notNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jorá itomi Joanán. Joanán itomi Iresa. Iresa itomi Sorobabé. Sorobabé itomi Saratieri. Saratieri itomi Neri. ");
INSERT INTO notNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri itomi Mériqui. Mériqui itomi Ari. Ari itomi Cosam. Cosam itomi Erimaram. Erimaram itomi Er. ");
INSERT INTO notNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er itomi Josoé. Josoé itomi Erieseri. Erieseri itomi Jorim. Jorim itomi Matat. Matat itomi Irebí. ");
INSERT INTO notNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Irebí itomi Simeón. Simeón itomi Jorá. Jorá itomi José. José itomi Jonam. Jonam itomi Eriaquim. ");
INSERT INTO notNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriaquim itomi Merea. Merea itomi Mena. Mena itomi Matata. Matata itomi Natán. Natán itomi David. ");
INSERT INTO notNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David itomi Isaí. Isaí itomi Oberi. Oberi itomi Bos. Bos itomi Saramón. Saramón itomi Nasón. ");
INSERT INTO notNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasón itomi Aminarab. Aminarab itomi Aram. Aram itomi Arani. Arani itomi Esiromo. Esiromo itomi Baris. Baris itomi Jorá. ");
INSERT INTO notNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jorá itomi Jacob. Jacob itomi Isac. Isac itomi Abaram. Abaram itomi Taré. Taré itomi Nacoro. ");
INSERT INTO notNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacoro itomi Seroco. Seroco itomi Iragao. Iragao itomi Parec. Parec itomi Eberi. Eberi itomi Sara. ");
INSERT INTO notNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sara itomi Cainán. Cainán itomi Arapasat. Arapasat itomi Sem. Sem itomi Noé. Noé itomi Iramec. ");
INSERT INTO notNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Iramec itomi Matosará. Matosará itomi Enoc. Enoc itomi Jaret. Jaret itomi Marereri. Marereri itomi Cainán. ");
INSERT INTO notNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán itomi Enós. Enós itomi Set. Set itomi Arán. Tosorintsi yobetsiquëri ira Arán jiraisonori. ");
INSERT INTO notNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Cara ibaotisataca Jesos, pipocasiqueri Isëre Tosorintsi pinantasantapari. Aro ipaniaca nijaaquë Jorirán piátacaqueri Isëre cara tera ontimingani. ");
INSERT INTO notNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ocarati 40 cataguiteri itimaque cara, te irapëmate. Páguëri oquibe itasegane. Aro ipocasipëri camagari icogabeca irantacaquerime Ira Jesos ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Icampëri: —Obirosonorica Itomi Tosorintsi, pomeguiro oca mopëca pan, popero. ");
INSERT INTO notNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yotabitanëri Jesos: —Quero nacantiro. Ocanti Sanguenari jirai isanguenaquero comantantatsiri: Te patiro intimantimaro pan matsiguenga, carari aisati intimantëmaro cara inguemisanquero omagaro Irinibare ora icanque Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aique yáganëri Jesos camagari jonoquë oquibequë oguitoja. Ijigotëneri omagaro quibatsi cara igáanti itingomipague, icantabecari: ");
INSERT INTO notNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Pinetsero intapague, omagaro nasi. Pinintiroca, nangantaiguëri antagaisati quibatsisati intingomintimi irágacaninatëmi. Irironta nasiati, nomëri pairiraca naninti. ");
INSERT INTO notNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aroca pobaticagueritotasiquina, pintingominquina naro, aro nanganqueri intingomintaiguëmi Obiro omagaro intaegui. Antagasiati irianti pasi. ");
INSERT INTO notNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yotabitanëri Jesos icanqueri ira camagari: —Ocanti Sanguenari: Pintingomintimari paniro Atingomi Irironta Pitosorintsite. Paniro Iriro pomanocoqueri pinguemisantiri. ");
INSERT INTO notNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aique yáganëri camagari Jerosarénquë, yoguëri jonoquë oquibe pongotsi irasi Tosorintsi. Icanqueri: —Obiroca Itomi Tosorintsi, atsi pomatsecanë osobinta quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pinguenguero ocanti Sanguenari: Tosorintsi iragáquemiri irisaanganetsitepague iromisanquemi. ");
INSERT INTO notNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Irágaigabaquemi arota quero poparigui mopëquë. ");
INSERT INTO notNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aisati yotabitanëri camagari Jesos, icanqueri: —Quero picantiri Tosorintsi ora inganque; posamitiri ora icogui inganque. Ocanti Sanguenari: Quero piniantari Pitingomi Irianti Pitosorintsite. ");
INSERT INTO notNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cara itsonque camagari irantacaquerime Jesos ora te ongomeite, igóque tigueti ingantiri, ijocanëri iátaji. Carari iripigaima aiquenta, iragatsitairo. ");
INSERT INTO notNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aro ipiganaja Jesos Garireaquë, pinancari Isëre Tosorintsi, piátacaqueri. Omanapague iquemocotaiguëri iraegui timaigatsi canta. ");
INSERT INTO notNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yogomeantapë pongotsipaguequë cara yapatoitaiga joríojegui. Icaninabentaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Aique iáque Jesos Nasarequë, iboeborotequë cara iquibiaque jirai. Cara yameta, cara sábaroquë icanaque pongotsiquë cara yapatotaiga jorío, yaratianque arota irinibaquineri matsiguenga Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ipëri isanguenare Isaías comantantatsiri. Yaquipariaquero, iniaquero cara isanguenaque: ");
INSERT INTO notNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Pinanquina Isëre Tosorintsi, ipasitënaro. Pigáquina nongomantaguetiri coguitiachari atiraca ongantima iragabisaicotaiguëri Tosorintsi. Aisati pigáquina Isëre Tosorintsi nangantocobintairi antagaisati irasi camagari nagabisaicotajiri, quero intaguiri quimingari aisati. Aisati pagobiacaquina naganinasëretaiguëri iraegui agasëretachari. Aisati pigáquina pagobiacaquina naniacagaigairi comarajari. Aisati nagabisaicotajiri iraegui atsipiriaigatsi. ");
INSERT INTO notNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aisati pigáquina nongomantaguetiri matsiguenga ingábintsaiguëri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aro itsonquero Jesos yapinaguiriquëro Sanguenari, yoguipigairi ipëri, isobiaque. Inetsaiguëri omagaro botoitachari. ");
INSERT INTO notNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesos icantaiguëri: —Yamai nomoncaraquero oca Sanguenarica piquemaiguëca. ");
INSERT INTO notNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iniacaninataiguëri ira quemaiguëri, iquenganeintacaro ora caninatsaro irinibare. Yosamitobaca: —¿Teco iriro itomi José? ");
INSERT INTO notNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aisati icantaigairi Jesos: —Aiquenta pingantaiguëna: “Agaguibegantatsiri, pigaguibegajima Obiro aisati pomatsiguengasonori. Poguibegaigairi matsiguenga cara Caperinaoquë. Atsi yamai pitasongante aisati yaca poboeborotequëca”. ");
INSERT INTO notNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Përosati icanqueri Jesos: —Aisonori nangantaiguëmi pitsoingaiguiri pomatsiguengasonori quinguitsatimiro Irinibare Tosorintsi, carari ira timaigatsi parigotiquë pinganinabentaigabaqueri. Naro nacantari Erías jirai. ");
INSERT INTO notNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pigóiguë ainta pinasegui tojai ogamaimentaga jorío aguebatsitequë cara icomantanque Erías comantantatsiri jirai, cara yamanaque cara quero oparigui angani maba osarini aisati basini aganguisati, cara itasegaiguë matsiguengajegui, ");
INSERT INTO notNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","carari te iragátingani Erías iromitocotaiguero tsinane jorío ogamaimentaga, iroonti igáqueri Tosorintsi cara poeboroquë jitacha Sarépita cara Sirónquë imitocoquero tsinane inabitacha canta, cagaro omatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aisa nacantari Eriseo comantantatsiri. Cara itimi iriro ainta tojai jorío iribatsasetaga, carari te iragaguibegajiri iriro Eriseo. Paniro yogaguibegajiri Siriasati jitacha Naamán, basiniati matsiguenga cagari jorío. ");
INSERT INTO notNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ocari oca iquemaiguë botoitacharijegui, iguisasitaigacari Jesos, icantaiguëri: —¿Picanti cara Tosorintsi te iraninte iromitocotaiguena? ");
INSERT INTO notNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Icabiritaigaca, yágaiguëri Jesos, yágaiganaqueri sotoquë Nasaret cara otserabatsaquë cara pini iboeborote, icogaigabitaca iromiongaiguërime osobinta. ");
INSERT INTO notNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Carari tigueti ingantima irotsagatajiri basini; aro iquenaque aganguisatiquë irirojegui, iátaji. ");
INSERT INTO notNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Aique ipiganaja Jesos Caperinaoquë, cara Garireaquë. Cara sábaroquë yogometaiguëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iquemaigabaqueri iquenganeintasantacari yogometaiguërinta aisa icantari ibega itingomi ogótasantatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Cara yapatoitaiga jorío ainta inasegui sërari inancari camagari quimingari. Catsigue icaimasantëri Ira Jesos: ");
INSERT INTO notNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ongainta! Quero picantaiguina, Jesos Nasaresati. ¿Aroco pipocasique yamai pitsipiriacagaiguëna? Nigóquimi Obiro, Ira caninari Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Isintsitsaqueri Jesos, icanqueri: —Pomairete. Pijátopitairi sërarica. Aro yotëanëri sërari quibatsiquë aganguisatiquë botoitachari, isotogopitanëri, te pairo ingantëmatiri. ");
INSERT INTO notNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Antagaisati itsorogasantë iquenganeintasantacari, inibatobaca, icantaiguë: —¿Pairo ojita oca? Patiro inibatëri camagari iquemisanqueri iátaji. Tojai itingomitasanti, tojai itasonganti. ");
INSERT INTO notNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aro omagaro timaigatsi cara Garireaquë iquemocotaiguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aique isotocanë Jesos pongotsiquë cara yapatoitaiga jorío, icanaque ibangoquë Simón. Ojanaitë iraguiro Simón, ocatsiringaeguisigui. Yamanaigabaqueri: —Pigaguibeganairo. ");
INSERT INTO notNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yotsitiparo Jesos, icanque: —Aro omeganaimata ogatsingaeguire. Aito cara pibeganaa, ocabiritanaa opaguetaiguëri iraperi. ");
INSERT INTO notNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cara icanaque paba, yamaigapëneri Jesos tojai janaitatsiripague, pairoraca óguëri. Aro yoguëneri ibaco iguitoquë paniropague, yogaguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aisati ainta inantaigacari camagari. Cara yomisotocajiri icaimaiguëri camagari igótinta Iriro Agabisaicoontatsiri icantaiguë: —Obiro Itomi Tosorintsi. Carari Jesos yomisotocaigairi camagari, yoguimairentaiguëri tenta iraninte ingomantëgotiri. ");
INSERT INTO notNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Oquëtaguetanë iáque Jesos cara tera ontimingani. Aique icogaiguëri matsiguenga, iniaigairi, icantaiguëri; —Quero piáti. Pintime yaca naroeguica. ");
INSERT INTO notNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Carari icantaiguëri Jesos: —Quero nini yaca. Caninataque najáte. Igáquina Tosorintsi nongomantaguetiri matsiguenga poeboropaguequë cara intingomintaiguemari Tosorintsi pënibaquenta orequima iragáantane. ");
INSERT INTO notNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aro iátagueque Jesos iquenguitsataguetanëro Caninaro Nibarintsi pongotsipaguequë cara yapatoitaiga joríojegui cara Joreaquë. ");
INSERT INTO notNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Basiniquë cataguiteri Jesos iquenguitsatomotaiguëri matsiguenga cara onamijaquë angaare jitacha Jenesaret (aisati ojita Garirea). Arosonorinta matsiguenga itsinatsinaitobaca, aisati itsinatsinataiguëri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iniaque Jesos pite pitotsi cara onamijaquë angaare, carari yaguëtaiganaque casintaro ira siriatatsiri iquibaigairo isiritite. ");
INSERT INTO notNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Aro yotecaro Jesos ibito Simón, icanqueri ingomate arosata. Aro isobiaque pitotsiquë cara angaarequë, yogometaiguëri botoibiritaigabacari onamijaquë. ");
INSERT INTO notNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cara itsonquero Jesos irogomeantane, icanqueri Simón: —Intsome cara aganguijaquë pisiriate. ");
INSERT INTO notNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yotabitanëri Simón: —Ogometinari, nasiriataigabitaca omagaro naraningui, te náguëmate sima, carari Obironta cantëna, naniantaimaro aisati. ");
INSERT INTO notNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aro imiongaigairo irisiriamento yágasantaigairi sima inosiquëgotaiguëri tojaisonori. Iacaro isiritite pënibaque iribëshëgotanë. ");
INSERT INTO notNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Icaimaiguëri basini pitotsiberi yacotaiguëri arota iribocaigapë iromitocotaiguëri. Yaretocotaigapa, yotetaiguëri sima pite pitotsiquë, jagaca, pënibaque otsitiganë. ");
INSERT INTO notNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ocari oca iniaque Simón Peroro, iquenganeintasantaca, yobaticagueritotasicari Jesos, icanqueri: —Natingomi, caninataque pijátaje. Te nanganinate naro, nacantagueti te ongomeite; teni onganinate pintsibatina. ");
INSERT INTO notNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Itsorogasantaiguë Peroro aisati omagaro itsipa cara iniaiguëri tojai sima yágaiguë. ");
INSERT INTO notNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aisati itsorogaiguë Santiago aisati Joan, itomi Sebereo, itarobacaatacaqueri Simón. Aique icanqueri Simón Jesos: —Quero pitsorogui. Aisa pinganquima cara pisiriatiri sima, nocogui yamai pinguemisantacagaiguenari basini matsiguenga, Naronta agabiaquemine. ");
INSERT INTO notNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aro yaretocotaigaa onamijaquë, ijocaiganaquero ibito, irisiriamento, omagaro, yoguiataiganaqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cara icanaque Jesos poeboroquë, iniobëri sërari iribatsasetasantaga. Ibatsaguetanë omagaro, pitsonqueri. Aro yobaticagueritotasipari, yamanopëri icanque: —Natingomi, pinintica, piguëtetainaro nobatsagoro pigaguibegajina. ");
INSERT INTO notNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aro itimagonaguitanaca ibaco Jesos yotsagaqueri, icanqueri: —Nocogui yamai; nagabisaicotajimi. Aito cara opeganaa ora iribatsagoro, iquëtetanai. ");
INSERT INTO notNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Igáqueri Jesos: —Quero pairi picomantëmati. Pijáte saserirotiquë, poniaguimari irogóontëmi cara pabisëgotai. Pingantiro ora icanque Moisés: páganëneri saseriroti pobira, iritaguineri Tosorintsi. Aro irogótocotaiguëmi matsiguenga aroque pabisëgotai piquëtetanai. ");
INSERT INTO notNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Carari aiquero piátanëtigue cara icomantëgotaiguiri Jesos. Ipocasitaiguëri tojaisonori matsiguenga inguemisanquero irogomeantane Jesos aisati arota iragaguibegaigairi janaitatsiripague. ");
INSERT INTO notNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aro iáque Jesos canta tenta ontimingani, yamanaqueri Iriri inibatëri. ");
INSERT INTO notNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Basiniquë cataguiteri iroontita yogomeanti Jesos pongotsiquë, ainta isobicaiguë iquemaiguëri bariseopague aisati ira ogomeantiro isanguenare Moisés ipaniaguetaigaca Garireaquë, Joreaquë, aisati Jerosarénquë. Aisati Jesos yogaguibegaigairi janaitaguetatsiri itasorintsitequë, yagobiaquerinta Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aique ipocaiguë sëraripague yanatocoigapëri sërari emëngari te iranëibintsataje. Icogaigabitaca iráganëri tsomagui cara inasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tigueti inguenacaqueri cara ingaaganëri iacaronta pongotsi matsiguenga. Aro itaganëri jonoica pongotsi yomoroganëro yoguëantaigacari jatasintsi aisati sogatsa catingasatiquë cara inasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesos igótaiguëri cara yoguiaiguëri iragaguibegajiri emëngari, icabëri: —Yamaica, nomatsiguenga, nasetajimiro ora picantagueti te onganinate; quero iguisëgotaimiro Tosorintsi, quero iquengaimiro. ");
INSERT INTO notNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ira ogomeantiro isanguenare Moisés aisati bariseo iquenganeintaigaca icantobaganaca: —¿Pairo ijica Iriati Ica icantocotaguetasitari Tosorintsi negaca? Quero pairi setaguetirone ora te onganinate, paniro Tosorintsi. Ijitosorintsitasitaca Ica. ");
INSERT INTO notNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Igónijinca Jesos ora iquenganeintaigaca; yotabitaiganaqueri: ");
INSERT INTO notNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—¿Pairo piquenganeintobitaiga najitosorintsitasitaca? Te ongomëtate nanganqueri: “Nojocajimiro ora picantagueti te onganinate, nomaguisantocotimiro”, carari comëtaro nanganqueri: “Pingabiritima, págairo pijatasi panëitanae”. Aroca nanganque: “Pingabiritima panëitanae”, queroca yanëiti, pisërontobitaiguëna. ¿Aisonorico? ");
INSERT INTO notNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yamai nogaguibegajiri janaitatsiri arota nogótacagaiguemiro cara icanquena Pabati: “Pijocajineri ira cantaguetiro te onganinate; aique quero aguisëgotëtajari”. Nagabeiro Naronta paniacha Jonogaguitequë nomatsiguengatapë cara niboguë yaca quibatsica. Aro icanqueri emëngari: —Atsi pingabiritima, págairo pijatasi, pijátaje pobangoquë. ");
INSERT INTO notNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aito cara iniaiguëri icabiritanaca, yágairo iatasi, iátaji ibangoquë, icanque: —Aisonori, icaninatasanoti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iquenganeintasantaiganaca omagaro botoitachari, itsorogasantaiganaque aisati, icantaiguë: —Caninarisonori Tosorintsi. Yamai aniaiguëro ora te oneingani jirai. ");
INSERT INTO notNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cara isotocaji Jesos pongotsiquë, iniopëri Irebí, icoicotaguetiri imatsiguenga iguireguite, ipagantiri cobeingari Iromaquë. Icampëri: —Intsome, piguiatanëna. ");
INSERT INTO notNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aro yapabaquëanëro cara isanguenatocotaguequeri quirequi, icabiritanaca, yoguiatanëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aique iáque Irebí ibangoquë yapaaguëri Jesos. Aisati icaimaiguëri tojai coigotantatsiripague aisati basini imatsiguenga. Yapaagaiguëri antagaisati. ");
INSERT INTO notNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aro iniaigapëri bariseopague aisati ira ogomeantiro isanguenare Moisés, yabentaigaca, yosamitaigapëri irogomere Jesos: —¿Pairo pitsipabiritaigacari coigotantatsiripague aisati cantagueantatsiripague? ¿Pairo papaagobiqueri aisati pairo pógagobitaigacari? ");
INSERT INTO notNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yotabitaiganaqueri Jesos: —Ira cajigatatsi te ingoguiri jompiantatsi, carari ira janaitatsi iriro coguiri. ");
INSERT INTO notNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Te iroro nopocasite nangaimaguetiri caninatatsiri, irianti nangaimagueque ira cantaguetiro te onganinate arota irojocajiro, ingantaigaima yacaqueroca. ");
INSERT INTO notNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Icantaigapëri Ira Jesos: —Ititopiantaiga irogomere Joan aisati irasi bariseo. Ititaiga, yamanocotaiguëri Tosorintsi. Carari pasi pogomere yapaigui aisati yógaiga. ¿Pairo te iritibiritima? ");
INSERT INTO notNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yotabitaigabaqueri Jesos: —Pigóiguë ora ametaiga cara iráque iina sërari: ingaimaiguëri imatsiguenga inganinataiganaque omagaro. Cara iraretaiguëma, ¿Aroco irititaigapëma? Quero itita iroontita intsibatëmari ira ágantatsi. ");
INSERT INTO notNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Carari cara iriátë jaanta ira águërone iina, aisati iriáiguë igaimane, aro iragasërequima, irititaiguëma. Aisati Naro, iroontita natsibataigari nogomere, ¿Pairo natitacagobiquimari? Carari cara nangamaquenica, nojocanëri nogomere, aro iragasëretocoquina, irititaiguëma. ");
INSERT INTO notNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aique yosiacagantancari Jesos quingabaguirentsi ora paniacha ora yametaiga matsiguenga carari pogomeque basiniati aisati: —Te ongomeite pinguemisantagarantiro ora yogometaiguimi bariseoegui aique pingonaguëro nasi nogomeantane. Pigóiguë cara pigabitëro inaga piguitsagare, páguëro inagasite manchaguintsisite. Aroca pigabitantimaro iroraisite, cara ámanaquima ontisaraanairo oquibe ora inagasite piguitsagare. ");
INSERT INTO notNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Aisati pigóiguë ametaiga eiro oguëro irorai oja oba cara iriraimasiquë oisha. Cara onguëchotanë obaa iritopiganëma imasi, quero paparaata. Quero pairi ogantarone oja oba irinagamasiquë. Igóque cara onguëchotanë oja oba intonganë irinagamasi, oparaatëma obaa, aisati iraparaquima imasi. ");
INSERT INTO notNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aisati pairiraca óguëmarone obaa inagaa quero icogui yógaro iroraia. Inganque: “Ora inagaa caninajaro, pabisiro ora iroraia”. Aisa ocanta quero piconaguiro nogomeantane aisa irasi jirainisati. Nogometaiguëmi ora irorai carari ainta te iranintobëro, icanque: “Nameitacari irogomeantane omatsiguenga jirai, iroonti caninaro”. ");
INSERT INTO notNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aro basiniquë sábaro iáiguë Jesos aisati irogomerejegui cara panguirintsiquë. Ira irogomere yágaiguëro oguitsoterei tirigo imitoquero ibacoquë yapaiguëro oguitso. ");
INSERT INTO notNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iniaiguëri bariseopague, icantaiguëri ira irogomere: —¿Pairo picantobitaiguëro yamai ora te onganinate? Teni ongomeite pobiguitantimaro sábaro. ");
INSERT INTO notNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yotabitanëri Jesos: —¿Teco pinibatapinintiro Sanguenari ora comantëgotaiguëri David aisati itsibatari cara págaiguëri itasegane? ");
INSERT INTO notNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aiti pan cara ibangoquë Tosorintsi, ora yobetsiquineri Tosorintsi oguëngani catingasatiquë Iriro. Ora pan iroonti iraperi saseriroti, te iranintacaguiri basini irapero. Carari icanaque David cara ibangoquë Tosorintsi, yáguëro ora pan ipëri saseriroti, yapëro iriro aisati ipaiguëri ira icarataiguira, yapaiguëro. ");
INSERT INTO notNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Iroro nocomantëgotaguëquero pairoraca anganque sábaroquë. ");
INSERT INTO notNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Basiniquë sábaro, icanaque Jesos cara pongotsiquë cara yapatotaiga jorío, yogomeantapë. Ainta inasegui sërari camabocori ibacosonori, te osebatima. ");
INSERT INTO notNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aintasati bariseopague aisati ira ogomeantiro isanguenare Moisés, inetsaiguëri Ira Jesos aroca iragaguibegajiri sábaroquë. Icogaiguë ingantocotaiguëri Jesos: “Itarobacaaque Jesos sábaroquë, te inganinate”. ");
INSERT INTO notNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Igóque Jesos ora iquengaigaca bariseopague. Aro icanqueri ira camabocori: —Atsi paratingue yaca aganguisatiquë cara iraniaiguëmi omagaro. Aro icabiritanaca, yaratianque. ");
INSERT INTO notNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Icantaiguëri Jesos: —Yamai nosamitaiguëmi: ¿Pairo isanguenaque Moisés caninatatsi angante sábaroquë? ¿Teco pininte pingantiro ora caninaro oraco te ongomeite? ¿Teco pininte pigaguibegajiri janaitatsiri, pinintinico ingame? ");
INSERT INTO notNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Inetsaiguëri omagaro Jesos. Aique icanqueri sërari: —Pintimagonaguitima. Aro itimagonaguitaca. Aito cara pibeganaa ibaco. ");
INSERT INTO notNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Iraegui ogomeantiro Sanguenari aisati bariseoegui iguisasantaiganaca, yosamitobaca: —¿Pairo anganqueri Jesos, agamaguëri? ");
INSERT INTO notNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Basiniquë cataguiteri iáque oguitojaquë irinibaqueri Tosorintsi. Omagaro tsitiniri yamanasegui. ");
INSERT INTO notNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iquëtaguetëgotë, icaimaiguëri ira aguiataiguiri, icoigaiguëri irogomere icarati 12, aisati ijitaiguëri iragátane. ");
INSERT INTO notNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ijitaiga: Simón (aisati ijiqueri Peroro); aisati Antiris ireinti Peroro; Santiago; Joan; Jeripe; Baritoromé; ");
INSERT INTO notNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo; Tomás; Santiago itomi Arijeo; Simón ira nintasantiro ibaísite; ");
INSERT INTO notNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Joras itomi Santiago; aisati Joras Cariotisati ira ágagantërine Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yanongopaa, yaratingopë cara caninaguiteroquë. Ainta itsibataigari tojai irogomere aisati arosonori matsiguenga Joreasati, Jerosaresati, aisati ira paniaigacha Tiroquë aisati Sirónquë cara onamijaquë oquibe angaare. ");
INSERT INTO notNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ipocasitaiguëri inguemisantaigabaqueri aisati icogaiguë iragaguibegajiri janaitatsiripague. Yoguibegaigairi. Aisati yomisotocaigairi camagaripague yapabaquëacagaigairi tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Antagaisati cogaigatsi irotsagatiri Ira Jesos iniaiguërinta yagobeiro yogaguibegajiri omagaro janaitaguetatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Aro inetsaiguëri irogomere, icantaiguëri: —Iraganinasëretaiguëmi Tosorintsi obiro te pasintima pigóiguinta te pigabisaicotajima obiati. Pintingomintaiguemarica, aro intingomibintaiguëmi obiro. ");
INSERT INTO notNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Cara pitasegaiguë yamai, pinganinatë cara popë pinguemaquema aiquenta. Aisa pingantima, picogasantaiguëca pingantaigue caninasati, iraganinasëretaiguëmi, iragabiaquemi cara pintimaiguë caninasati, iromitocoiguëmi, inguemasëretacaquimi. Iraganinasëretaiguëmi Tosorintsi obiro aragaigacha yamai aroquenta pogasëretaigaca. Picabaiguë aiquenta. ");
INSERT INTO notNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Iraganinasëretaiguëmi Tosorintsi cara inguisëgotaiguëmi matsiguenga, cara irojocaiguëmi cara yapatotaiga, cara ingantocotaguetasitëmi, cara iromaintaiguëmi aroquenta piquemisantaiguëna Naro, Naronta paniacha Jonogaguitequë nomatsiguengatapë cara niboguë yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jee, pinganinasëretasantaiguë: imaiguëmi Tosorintsi ora caninaro cara Jonogaguitequë, iraganinasëretëmi aisa icanta yoganinasëretaiguëri comantantatsiri jirai cara iguisaiguëri imatsiguenga, ipaiguëri iriro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Aisati icantaiguëri Jesos: —Carari obirojegui casintaguetasantacha, pitsipiriaiguë, aroque páguëro pasiati: picaninabentiro pasinta yamai. Carari aiquenta quero ipimiro pairoraca Tosorintsi, pitsipiriaiganaque. ");
INSERT INTO notNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aisati pitsipiriaiganaque obiro piquemaigaca yamai; aiquenta pitasegaiguë. Yamai pijique: “Te nongoguiteimaro pairoraca”. Aiquenta pingoque ingábintsaiguemi Tosorintsi carari quero imitocotimi. Yamai pitsipiriasitaiga cara picabataigui picaninabentaiguëro ora inatsi quibatsica. Yamai picabataiguë; aiquenta piragaiguëma cara iratsipiriacagaiguëmi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Aroca iraniacaninataiguëmi omagaro matsiguenga yamai, pitsipiriaiguë aiquenta. Aisa icanta iniacaninataiguëri jirai iraegui comantantatsiri matobiantatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aisati icantaiguëri Jesos: —Carari nangantaiguëmi obiro quemisantaiguënari: pinintaigueri iraegui quisaiguimi, pingantaigueri caninasati ira quisaneintaiguëmine, ");
INSERT INTO notNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","potabitanëri caninasati ira cantëgotaguetasiquimi, pomanocotaigueri arota ingábintseri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aroca iripasaboroquimi poboroquë, quero pipëgatari pinintacaguiri iripasaborotimi cara querora aisati. Aroca irágopitëmiro pobasitoro, quero piguisiri, pinintacaguiri iráganëro piguitsagare aisati. ");
INSERT INTO notNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aroca iromanaquemi pairoraca, aro pomeri. Aroca irágopitëmiro ora pasinta, quero picoicotiri aisati. ");
INSERT INTO notNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aroca pingoque ingábintsaiguemi matsiguenga, aro pingábintsaigueri iriro. ");
INSERT INTO notNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Aroca pingábintsëri paniro ira cábintsëmi, ¿Pijiqueco iraniacaninatëmi Tosorintsi, ingantocobentëmi? Quero. Igóque cara tsoengatsiri te inguemisante inintaiguëri aisati ira nintiri iriro. ");
INSERT INTO notNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aroca pinganqueri caninasati ira cantëmiro caninasati, ¿Pijiqueco ingábintsëmi? Quero. Aisa icanta icanquero cantagueantatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aroca picogui iraguipigaimiro ora popirisitaqueri basini, ¿Pijiqueco imëmiro pairoraca Tosorintsi? Quero. Aisa icanta icantaiguë tsoengatsiri: ipirisitaqueri ira aguipigairine aisati. ");
INSERT INTO notNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Carari obirojegui, pinintiri ira quisaneintaiguimi; pingantiri caninasati; pomirisitatiri coguitiachari quero pogueiri iraguipigaimiro; aro iraniacaninatëmi Tosorintsi jonoquënintaberi, imasantëmiro ora caninaro, intomintaiguëmi, aisati pingantaiguemari Ira timatsi jonoquë, icábintsaiguëri iraegui te ingarasiatiri aisati iraegui te ingomeite. ");
INSERT INTO notNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pingantaneintëgotaguetiri basini aisa icanta Pabati Tosorintsi icantaneintëgotaguetiri. Përosati yogomeantë Jesos: ");
INSERT INTO notNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Quero picantari joes. Quero picomantëgotiri pomatsiguenga: “¿Pairo icantobiquero negaca? Icantaguetiro ora te onganinate”. Queroca pinibatëgotiri negaca, quero icomantëgotimi Tosorintsi: “Aiti picantagueti obiro”. Quero picantocotaguetasitari basini; aro quero icantocotaguetasitimi obiro. Pijocajineri ora icantaguetimi, pomaguisantineri, aro irojocajimiro obiro Tosorintsi ora picantaguetomotiri Iriro iromaguisantimiro. ");
INSERT INTO notNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pomeri coguitiachari, aro imëmi Tosorintsi ora coguitiomotimi. Quero imichati Iriro, imagantasanotëmi. Aroca arosata pingábintsëri basini, pomabaqueri arosata, aisati arosata ingábintsëmi obiro. Carari aroca tojai pingábintsasantëri basini, aro tojai ingábintsasantëmi obiro. ");
INSERT INTO notNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Përosati yogomeantë Jesos. Inibatantaro quingabaguirentsi: —¿Aroco ingatsatanëri comarajari ira basini comarajari? Quero. ¿Queroco iparigaigui omoroquë pitirooti? ");
INSERT INTO notNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aisati icanta, ira irogomere te irobatiri ira ogometiri, te irabisiri. Aroca irogótasanotanë tojai aisati inganquimari ibega ira ogometiri. ");
INSERT INTO notNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nosiacagantëmiro: aitica pairoraca otiomijani iroquiquë pomatsiguenga, aitisati oquibe pasi piroquiquë, ¿Pairo piniobiquero irasi cara te pigótima aiti oquibe pasi piroquiquë? ¿Pairo piguisëcobiritari pomatsiguenga cara icantagueti, carari te pigóte pabisiri obiro picantaguetasanti? ");
INSERT INTO notNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Pairo picantobitiri: “Majire pine náguëtajimirota ora piroquiquëti”, carari quero pineiro aitinta anchapoa pasiquë piroqui? ¡Pamatobiantë! Pijitabeca picaninatasanti pabisirime pomatsiguenga. Obitsita obetsiquenguichane, pijocajiro anchato ocomarajatacaquemi, aique piniasantanë cara páguëtajineri basini arosata ora iroquiquëti. ");
INSERT INTO notNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Aiti basini yosiacagantaiguëneri matsiguenga Jesos, icanque: —Ora caninaro anchato tigueti ongantima onguimingatë oguitso. Aisati ora anchato te ongomeite tigueti ongantima onganinatë oguitso. ");
INSERT INTO notNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Antagaisati anchato oniantagani oguitso. Aroca aneiro oguitso anchato aro ogóquero ati ocanta anchato aroca caninari. ¿Aroca picogui pamaqui, aroco pijáque porontsiquë? Quero piáti pigóquenta te ine oguitso porontsi. Querootisati pobiguitiro oba cara jirinaquë. Ora anchato onguitsotanë asi poguiro. ");
INSERT INTO notNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aisa icanta, ira caninari sërari iquengasëretapinintiro caninaro, iroro icantaguëtiro ora caninaro. Ira te ingomeite iquengasëretapinintiro ora te onganinate; iroro icantaguëtiro ora te onganinate. Pairoraca iquengasëretaca matsiguenga, irootisati irinibaque. ");
INSERT INTO notNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Pairo picantasibiriquina “Natingomi, Natingomi” carari te pinguemisantiro ora nacantaiguëmi? ");
INSERT INTO notNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aisati icantaiguëri Jesos: —Yamai nosiacagantëmiro ati icanta quemisantinari. Iquemaquero nanibare, icanquero ora nacanqueri nogomequeri. ");
INSERT INTO notNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aisati icantari ibega sërari obetsiquiro ibango. Iquigasiquero tsomagui coshobatsariquë irooti cara yarecaro oquibe mopë osobi. Aro yáguero pongotsipoa yobatiaquero, yomianquero mopëquë yoguëshotancaro. Aro opariaque angani, pipoque jarini omotoncaatapa, posibitasantëro pongotsi, carari te áganëro coshorinta pongotsi. ");
INSERT INTO notNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ira quemëro nanibare carari te inguemisantinaro aisati icancari ibega sërari obetsiquëro ibango sibitabatsariquë, te iritijasantiro pongotsipoa tsomagui. Pipoque jarini omotoncaatapa, posibitasantëro pongotsi, potëanëro páganëro te iraniajiro ibango. ");
INSERT INTO notNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Itsonque Jesos iquenguitsatomotaiguëri matsiguenga, aique iáque Caperinaoquë. ");
INSERT INTO notNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aro ainta soraro Iromasati cagari jorío. Iriro capitán, itingomi 100 soraro. Ijanaitasantë ironomire ira ininti capitán, pënibaque ingamaque. ");
INSERT INTO notNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cara iquemocoqueri Jesos capitán, igátaiguëri obatacaguiri joríopague iriátasitaiguëri Jesos iromanocotiri ironomire iragaguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yaretaigaca jorío yamanopiantaigapëri Jesos: —Caninataque pijátasitiri capitán irironta caninari. Piguibegajineri ironomire. ");
INSERT INTO notNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Inintaigacái eiro jorío; yobetsicacái obango cara apatoitaiga. ");
INSERT INTO notNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aique iáque Jesos yoguiataiganaqueri. Pënibaque irarequima cara itonguibocari basini iragátane capitán. Icomantapëri: —Icanque nagapitante: “Natingomi, quero pitsipiriobitina popoque yaca nobangoquë. Nitsoingaa naro, tenta aisa nangantimi pibega Obiro. Obiro caninari, naro te. ");
INSERT INTO notNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iroro te najátasitaguëtimi. Nocogui pinibatë, irooti piguibegantaimari nonamire. ");
INSERT INTO notNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aintasati agátinari, aisati ainta soraro ira nagátaiguë naro. Aroca nagáqueri nosorarote: ‘Pijáte’, aro iriátë. Aroca nanganqueri basini: ‘Popoque’, aro iribocapë. Aisatica nagáqueri nomeraro: ‘Pingantiro oca’, aro inganquero. Aisa picanta pibega Obiro. Omoncaraquima pairoraca pinibatë.” ");
INSERT INTO notNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iquemobëri Jesos, iquenganeintacari, icantaiguëri iraegui aguiataiguëri: —Nangantasantaiguëmi: tojai iquemisantasantë capitán, yabisaiganaqueri antagaisati joríojegui quemisantatsi. ");
INSERT INTO notNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aique ipigaiganaja iragátane capitán. Cara yaretaiganajaro pongotsi, iniaigapairi ironomire aroqueque ibeganaa, tegotsitatsi. ");
INSERT INTO notNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aique basiniquë cataguiteri iáque Jesos cara poeboroquë jitacha Naín, aisati yoguiataiguëri irogomere aisati basini tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cara yaretaigaca aitoniati, itonguibocari matsiguenga yanatocotaigapëri igamaga iritijërinime. Irianti otomi paniro ogamaimentaga. Itsibataiganacaro tojaisonori otimanamitane icantaneintëgotaigacaro. ");
INSERT INTO notNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iniopëro Jesos Atingomi, icantaneintëgotëro aisati icampëro: —Quero piraga. ");
INSERT INTO notNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yotsitiparo ora págantanacari yotsagaquero. Aro yaratingaiguë ira ágaiganaqueri. Icanque Jesos: —Oboina, nanganquimini, pingabiritima. ");
INSERT INTO notNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aro icabiritanaa isobiaque ira camabitënguicha, inibatë. Aro icanquero iniro Jesos: —Jerica pitomi, caniari. ");
INSERT INTO notNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iniaigabaqueri matsiguenga, itsorogasantaiganaque, icaninabentaiguëri Tosorintsi, icantaiguë: —Icaninatasanti Tosorintsi. Igácáiri comantantatsiri irogomecái Irinibare. Aisonori itasongobencái Tosorintsi, icábintsaigacái cara aquemisantaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aique omagaro timaigatsi Joreaquë aisati omagaro Garireasati iquemocotaiguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aisati irogomere Joan icomantëgotaiguëri Jesos ora itasonganque aisati yogomeantë. Aro Joan icaimaiguëri pite irogomere, ");
INSERT INTO notNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","igáqueri Atingomiquë icanqueri: —Pijátasitiri Jesos, posamitapëri: “¿Obiroco Agabisaicoontatsiri Ira boquënguitsine, basiniatico naguiaiguë”? ");
INSERT INTO notNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aro iáiguë irogomere Joan, icantaigapëri Ira Jesos: —Igátaiguëna Joan baotisatantatsiri nosamitëmi: “¿Obiroco Quirisito Agabisaicoontatsiri Ira nagamaca iriboquë, basinico naguiaque”? ");
INSERT INTO notNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aito cara irooti cataguiteri Jesos yogaguibegaiguëri tojai janaitaguetatsiri; ijocaiguineri ira inancari camagari yogabisaicotajiri; aisati iniacagajiri tojai comarajatabetachari. ");
INSERT INTO notNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aique yotabitaigabaqueri Jesos: —Popiganajima, pingomantaigueri Joan omagaro oca piniaque nacanque aisati ora piquemaquena. Pingantiri cara iniaanai comarajatabetachari; yanëitanai carancaratatsi; ibeganaa iribatsasetaga iquëtetanai; iquemaiganaji maguemitari; icaniatanai camabitachari; iquemisantaigabaquero Caninaro Nibarintsi iraegui te irasintima, yogabisaicotaigairi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yoganinasëretaiguëri Tosorintsi iraegui quemisantaiganaquina, te ingomëtina te iritsoenguina. ");
INSERT INTO notNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cara ipiganaja irogomere Joan, aique Jesos inibatëgotëri iriro. Icantaiguëri matsiguengajegui quemaiguëri: —Cani piátaiguë cara tera ontimingani, piquemisantaiguëri Joan baotisatantatsiri. ¿Pairo piábiritaiguë? ¿Pigóiguërintaco iriro caninari sërari, iquemisantasantërinta Tosorintsi? Isintsisëretë. Cagari iriro cantaro choco cara posebatiro coguentima aiquero yaca aiquero cara. ");
INSERT INTO notNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Pairo piátasitaiguë? ¿Piniaquerico iquitsagaca caninasati? Teni. Pigóiguë cara ira quitsagatacha iguitsagare caninaro sibitaro itimaigui cara ibangoquë itingomi. ");
INSERT INTO notNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pairo piábiritaiguë? ¿Teco pigóiguëri iriro comantanquero Irinibare Tosorintsi? Aisonori nangantaiguëmi ibataiguëri basiniegui igomantantatsirite Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Irirori sanguenatëgotënguicha jirai cara icantocopëna Naro: Icanë Tosorintsi: “Notomi, aiquenta nagáqueri ira obatacaquemine, ingomantaigapëri imatsiguenga: ‘Aique naro, coraque Atingomi. Piganinataiguëneri paneingomento’ ”. ");
INSERT INTO notNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nangantasantaiguëmi ora aisonori, ainta tojaisonori comantantatsiri, carari noguibatëri Joan. Irironta ogótasantëri Tosorintsi, ibataiguëri basini matsiguenga. Carari antagaisati imaiguëmari Tosorintsi, intingomintasantaiguëmari, irobataiguëri ira Joan, irogótasantanëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aisati icanque Jesos: —Antagaisati quemisantaiguëri Joan aisati iraegui coigotantatsiri ibaotisataigaca icantaiguë: “Aisonori, icaninatasanti Tosorintsi cara icocagaiguëna nojocajiro ora nacantaguetaiguë te ongomeite, nomaotisataiguëma”. ");
INSERT INTO notNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Carari irianti bariseoegui aisati iraegui ogomeantiro isanguenare Moisés te iranintaigue ingantineri Tosorintsi ora icocagaiguëri. Teatisati iriátasitaigueri Joan imaotisataigueri. ");
INSERT INTO notNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","¿Pairoraca nosiacagantanquemi? ¿Ati picanta obirojegui? ");
INSERT INTO notNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Aisati picantaigari janequipague imaguimpitaigui saateriquë icanqueri basini: “Natamporatabeca carari te piguiataiguena; nosoncatabitaca carari teatisati piguiatina; nomaninquetabeca carari te pijáigue. Nacántatabitaca nogasëretomemegabitaca, carari teatisati piragasëretaiguema”. ");
INSERT INTO notNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pinetse. Picogaigabitaca ingantaiguerome pomatsiguenga pairoraca picocaqueri. Piniaigabaqueri Joan baotisatantatsiri itica aisati te iróguima piari, aro picantocotaguetasitaigari: “Oo, inancari Joan camagari, iroro ititaguëca”. ");
INSERT INTO notNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aro nopaniaca Naro Jonogaguitequë, nomatsiguengatapë; te natitima, aisati nógacaro piari. Aro picantocoiguëna: “Tojai yapasanti Iriro, aisati Iriro singuitachari, imatsiguengatacari ira coigotantatsi naguireguite aisati itsibataigari ira cantaguetaigatsi ora te onganinate”. ");
INSERT INTO notNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Carari igóque Tosorintsi cara icanque Joan caninasati aisati nacanque Naro caninasati antagaisati icocaquena; aisati omagaro quemisanquenane, irogóiguë caninaro ora icocaquena Pabati. ");
INSERT INTO notNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ainta bariseo jitacha Simón, icaimëri Ira Jesos iribocapë ibangoquë, irapajaqueri. Aro icanaque, yogasobicobëri mesaquë, yapaiguë. ");
INSERT INTO notNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aintasati tsinane antagueantatsiri cara poeboroquë. Oquemocoqueri Jesos cara yapi ibangoquë bariseo, piátasiqueri, páigotanëneri casangajengaro. Ora pinanta pobetsicagani aribásitoro. ");
INSERT INTO notNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Paratingopë itapiiquë Jesos. Piragasantaca, oparintaca oquibantacari ora osengaja oroqui iguitiquë, aro oseguitiantacari oguisi. Pasaraguititanacari aisati pitiriantacari casangajengaro iguitiquë. ");
INSERT INTO notNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iniobëro bariseo, ira pajaqueri Jesos, iquianca: “Irirome comantantatsiri iragátane Tosorintsi, irogótobëro oca tsinaneca iroonti antagueantatsiri quimingaro, poguimingatëri cara potsagaqueri”. ");
INSERT INTO notNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aro icanqueri bariseo Jesos: —Simón, aiti ora nanganquemi. Yotabitanëri bariseo: —Atsi pinibate, Ogometinari. ");
INSERT INTO notNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Icanqueri Jesos: —Nosiacagantëmiro. Ainta sërari ipirisitataguetiri matsiguenga quirequi. Ainta paniro irebetëri 500 tenario; basini irebetëri 50 tenario. ");
INSERT INTO notNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cara te irinaje iguireguite iripënabentairi ibatorote, aro isetaigaineri pitirooti ora irebetaigui. Yamai nosamitëmi: ¿Pairiraca nintasantiri ibatorote, yabisëri basini? ");
INSERT INTO notNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yotabitanëri Simón: —Irirojengari irebetabitacari tojai. Icanque Jesos: —Aisonori. Caninasati potabitanëna. ");
INSERT INTO notNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aro yapisitanaca Jesos inetsëro tsinane, carari përosati inibatëri Simón: —Carani nacapë yaca pobangoquëca, te págacaninatobëna. Te pomabaquinaro nija nanguibantëmaro naguiti. Piniaquero oca tsinaneca. Oquibantënaro osengaja oroqui naguiti, oseguitiantënaro oguisi. ");
INSERT INTO notNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te pasaraborotina cara nametaiga naroegui jorío, carari oca pasarapiantacaro naguiti cara narepa irooti yamaica. ");
INSERT INTO notNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te pishaguëantinaro asaiti naguitoquë, orari oshaguëantëna naguitiquë casangajengaro. ");
INSERT INTO notNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iroro ora nongomantaguëquemi: aroquenta onintasantëna, poniagaca cara aroque isetajinero Tosorintsi ora ocantaguetasanti tojai te onganinate. Carari basini cantatsi: “Te nangantaguete tojai”. Iroro te iranintaguëtina tojai. ");
INSERT INTO notNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aiquero icanquero tsinane Jesos: —Aroque nojocajimiro ora picantagueti te onganinate, yomaguisanquemiro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aro ira igaimanejegui iparintaigaca yosaminatobaca: —¿Pairiraca ijica Ica cara icanque: “Nojocajimiro ora picantagueti te onganinate, yomaguisanquemiro Tosorintsi”? ¿Iriroco jitacha Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesos icanquero tsinane: —Aroquenta piquemisanquina, yogabisaicotajimi Tosorintsi. Yamai pijáte pinganinasëretanë pomagoriasëretanë. ");
INSERT INTO notNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aique iquenaquenaiguë Jesos aisati irogomere poeboropaguequë. Iquenguitsatomotaiguëri matsiguenga ora Caninaro Nibarintsi, icomantëgotëro ati ocanta cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Aisati poguiataiguëri tsinanepague ora ijocajine ogamagarite aisati yogaguibegajiro cara ojanaitagueti. Ainta María aisati ojita Magararasato, inabitacaro ogamagarite icarati 7; ");
INSERT INTO notNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","aintasati Sosana aisati Joana iina Cosa. Ira Cosa imitocoqueri Eroris cobeingari, yomisantineri iguireguite aisati iromeraro aisati ibango. Aintasati basini tsinane poguiataiguëri Jesos. Aintanta oguireguite, omitocotaiguëri Jesos aisati irogomere; opaiguëri ora icogaiga. ");
INSERT INTO notNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yapatoibiritaiganacari Jesos tojai matsiguenga paniaigacha poeboropaguequë. Aro yosiacagantaiguëneri quingabaguirentsiquë, icanque: ");
INSERT INTO notNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Iáque panguitatsiri imiongaguitaguequero oguitsopague tirigo iritoganequë. Opariguitapë arosata oguitso onamiquë abatsi. Yagatiquëro matsiguengapague, aisati ipocaigapë tsimiripague, yapaigapëro oguitso. ");
INSERT INTO notNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Basini tirigoguitso opariguitë cara mopësiquë, piabitanaca; aique pisiguiricanë tenta ine nija, ocamaque. ");
INSERT INTO notNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aiti basini opariguitapë cara totseisiquë. Piabitanaca tirigo aisati totsei, carari ora totsei pogamaguëro tirigo. ");
INSERT INTO notNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Basini opariguitapë caninabatsariquë quibatsi, pianë, piquibianë caninasati, oguitsotasantanë. Aiti 100 oguitso patiro panguirintsiquë. Cara itsonquero quingabaguirentsi, icanque Jesos catsigue: —Aitica piguemita ora piquemanta, pinguemisantiro ora nacantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aique yosamitaiguëri irogomere: —¿Pairo ocanti ora posiacagantacái carani? ");
INSERT INTO notNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yotabitaiganaqueri Jesos: —Nocogui pigóigue ati icanta Tosorintsi cara igáanti, ora te ogotingani jirai, carari ira matsiguengapague quero nocogui igóigui. Iroro nogomeantacari quingabaguirentsiquë nosiacagantëneri tenta iraninte irogóigue. Inetsabetaigaca carari te iranee, iquemaigabitaca carari te inguemaigue, te irogótaigabaquero ora nacantaigabitari. ");
INSERT INTO notNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aique icantaiguëri irogomere Jesos: —Yamai noniagaiguëmi ati ocanti quingabaguirentsi irasi panguitatsiri. Ora oguitso aisati ocantaro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ora pariaquenguitsi abatsiquë ocantari ibega matsiguenga iquemaigabitacaro Irinibare, carari omanapague ipocasitaiguëri camagari yágabitsaqueri ora iquemabeca, yomaguisantacaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ora pariaquenguitsi mopësiquë aisati ocantari matsiguenga quemaigabitaro Nanibare. Icaninabentabecaro carari iquemisantabecaro arosata. Cara icogui camagari irantacaguiri ora te ongomeite, opomirintsitomocari Nibarintsi, ijocajiro. ");
INSERT INTO notNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ora pariaquenguitsi totseisiquë aisati ocantari matsiguenga quemaigabitaro Nanibare, iquemisantabecaro arosata. Carari cara iquengasantanëro pairoraca inaguetatsi yaca quibatsica, iquengasantanëri iguireguite inintasantiri, iquengasantanëro inganinabentiro pairoraca icogui inganque, aro yomaguisantanairo Irinibare Tosorintsi, te inguemisantanairo. Te ine oguitso; te ingante caninasati. ");
INSERT INTO notNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ora pariaquenguitsi caninabatsaroquë quibatsi, otojaiganaque, iroonti aisati ocantaigari matsiguenga iraegui quemisantasantobëro ora nogometiri. Përosati iquemisantanëna, icogui inganquero omagaro ora icocaqueri Tosorintsi. Icantaiguëro pairoraca caninaro, icaninabentaiguëri Tosorintsi. Iriro cantaca panguirintsi cara pinë openguiterei ora inatsi tojai oguitso. ");
INSERT INTO notNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aisati yogomeque Jesos: —Aroca oboquero michero anetsantaiguëmaro, quero oguiro osobiquë cobiti. Querootisa oguiro osobiquë somamintotsi. Oguëroti jonoica arota ongonijatagueque pairoraca. Irootisati nanganque Naro; nocoguini pigótasantiro Nanibare. ");
INSERT INTO notNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pairoraca ománocotaga yamai, ongonijaque aiquenta. Ora te ogótingani jirai, ogóquengani aiquenta; quero pairo pimánëmataja. Pingomantëgotaguetiro Caninaro Nibarintsi ati ocanta iragáantane Tosorintsi cara inguemisanqueri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Iroro yamai pinguemasantiro ora nogometaiguëmi, pinguenguemaro arota pigótasantaiguero. Pigóiguë arosata yamai, carari aroca pinguemisantanëna, nogótasantacagaiguëmiro nogomeantane. Irari basinipague te ingogue inguemisantina, quero iquemaiguina. Nágabitsaqueri ora iquemabeca, iromaguisanquero, ingomëtobëmaro, quero igótëmatiro. ");
INSERT INTO notNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Aique piátasiqueri iniro Jesos, aisati yoguiataiguëro ireintiegui. Yaretaigapa carari tigueti ingantaiguema irinibataigapëri yoticaigabaquerinta arosonori matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Icomantëri matsiguenga: —Arepa piniro, aisati pirentijegui. Ainta sotoquë; icogaiguini irinibataigapëmi. ");
INSERT INTO notNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yotabitaiganaqueri Jesos: —Inato aisati igue iriantiegui quemaigabaquero Irinibare Tosorintsi, iquemisantaiguëro. Icaegui irianti quemisantatsiri nomatsiguengatacari. ");
INSERT INTO notNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Basiniquë cataguiteri yotetaigacaro pitotsi Jesos aisati irogomere, icantaiguëri: —Intsome omontiaiganaquima antatinta angaare. Aro iátocotaiguë, ");
INSERT INTO notNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","páigotanëri coguentima. Inariaca Jesos isamasegui. Omanapague pipoque oquibeguinte coguentima, omotoncaatanë nija, potiatanaca pitotsiquë, pënibaqueme iritsiticoiganaque. ");
INSERT INTO notNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iátasiqueri Jesos, icabocapëri, icantaiguëri: —¡Ogometinari! ¡Ogometinari! ¡Atsiticoiguëni! ¡Pigabisaicotái! Icaguitë Jesos, icanque: —Omairiatanaeta angaare, osantocotanaeta coguentima. Aito cara omairiatasantanai angaare, osantocotanai coguentima. ");
INSERT INTO notNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Icantaiguëri irogomere Jesos: —¿Pairo te pinguemisantobitina? Itsorogasantaiganaque irogomere, iquenganeintasantaigacari icantobaca: —¿Pairi Ica? Inibatë, aro oquemisantasantanëri coguentima aisati angaare. Yoguimairenquero. ");
INSERT INTO notNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ipaniaigaca Garireaquë Jesos aisati irogomere, yaretocotaigapa antatinta Gararaquë. ");
INSERT INTO notNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cara yagatanë, yaguëtanë Jesos, iniobëri Gararasati inancari camagari. Cosamani te inguitsagatima iguitsagare, te intime pongotsiquë, carari itimi cara itia camatsirini. ");
INSERT INTO notNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cara iniopëri Ira Jesos, yobaticagueritotasitobacari, icaimapëri icampë: —¿Pairo pinganquena? Nigóquimi, Jesos, Obiro Itomi Tosorintsi jonoquënintaberi. Quero pitsipiriacaguina. ");
INSERT INTO notNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Icaimë negaca aroquenta igáqueri Jesos iriátabitsatiri sërari. Igóque camagari cara irojoqueri Jesos. Tojai yágapininqueri camagari ira sërari. Aisati tojai yoguëshotapinintaigabitacari imatsiguenga sogatsaquë coshori cara ibacoquë aisati iguitiquë, carari itimishairo yobëshopiantairo te iragabiaigueri. Ira camagari yáganëri cara tera ontimingani. ");
INSERT INTO notNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yosamitëri sërari Jesos: —¿Pairo pijita? Yotabitanëri sërari: —Tojai najita. Icanque tojai aroquenta inantaigacari arosonori camagari. ");
INSERT INTO notNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yamanaiguëri cara quero igátaiguiri iriáiguë omoroquë játaque tsomaguisonori. ");
INSERT INTO notNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ainta inaigasegui arosonori chancho yapaigasegui cara tongagariquë. Aro yamanaiguëri Jesos camagari: —Aroca pijocaiguëna, pigátaiguena cara chanchoeguiquë ninampëmari iriro. Yotabitanëri Jesos: —¡Atsi pijáigue! ");
INSERT INTO notNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aro iátopitaiguëri sërari camagari, inantaigapari ira chanchoegui. Aro isigaiganaca chancho cara tarangaquë, imatsematseiganaque angaarequë tobotn tobotn tobotn. Itsiticaiganaque ijogataiganaca omagaro chancho. ");
INSERT INTO notNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aro ira omisantaiguiri chancho isigaiganaca icomantagueigapëri imatsiguenga cara poeboroquë aisati togantsiquë. ");
INSERT INTO notNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Aique iátasitaiguëri Jesos tojai Gararasati iraniaiguëro omagaro ati ocanta. Iniaigapëri Jesos aisati ira inantabeca camagari. Ainta isobiaque iguitiquë Jesos, iquitsagata, iquengaa inibatë caninasati. Itsorogaigapë matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ira netsaiguëro antagaisati icomantasantaigabaqueri basini ati icanta Jesos yogabisaicoqueri ira inantabeca camagari. ");
INSERT INTO notNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aro omagaro Gararasati itsorogaiguëri Jesos, yamanaiguëri: —Atsi pijátaje yamai, quero pipocaji yaca aisati. Aro yotetanaa Jesos pitotsiquë, pënibaque iriátëgotë, ");
INSERT INTO notNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ira inantabeca camagari yamanabecari Ira Jesos: —Nocoguini naguiatanëmi. Carari te iranintacaguiri Jesos, icanqueri: ");
INSERT INTO notNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Quero pipoqui. Pijátasitiri pomatsiguenga cara pobangoquë, pingomantiri ora icanquemi Tosorintsi tojai icábintsëmi. Aique iáque sërari icomantagueantapë omagaro Gararasati ati ocanta cara yogabisaicoqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aique imontiaigapaa Jesos aisati irogomere. Yoguiaigabaqueri tojai matsiguenga, yágacaninataigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Itonguibocari sërari jitacha Jairo. Iriro obatacaguiri jorío cara pongotsiquë cara yapatotaiga. Yobaticagueritotasipari iguitiquë Jesos, yamanopëri icanqueri: —Intsome nobangoquë. ");
INSERT INTO notNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pënibaque ongamaque nasinto. Ainta paniro irisinto, ocarati osarinite 12. Cara iáigasegui, itsinatsinataiganaqueri matsiguenga tojai. ");
INSERT INTO notNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ainta tsinane piraaseque cosamani ocarati 12 osarini. Pipënabentaguetabecari jompiantatsiri omagaro ora pasinta, te aropei ongantima, te iromitocotëmatiro. ");
INSERT INTO notNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aro piátasiqueri itisitaquë Jesos potsagaqueri cara ocarati iguitsagare. Aito cara pibeganaa, ocaratanai oraa. ");
INSERT INTO notNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aro Jesos yosamitë icanque: —¿Pairi otsagaitënaro naguitsagare? Yotabitaiguëri antagaisati: —Teni pairi otsagatimine. Aique icanqueri Peroro aisati basini tsipacari: —Ogometinari, ishongaiguëmi tojai matsiguenga itsinatsinataiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Carari icanqueri Jesos: —Ainta otsagaquina. Nigónijinca cara pogaguibegajiro natasorintsite. ");
INSERT INTO notNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aro pigóque tsinane cara igóquero Jesos, aro parepari omogomogoatapa, pobaticagueritotasipari ocomantapëri: —Naro otsagaquero piguitsagare; iroro nibegantanaa cara niraaseinteque. ");
INSERT INTO notNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yotabitanëro Jesos: —Nomatsiguenga, aroquenta piquemisanquina nogaguibegajimi. Yamai pijáte pingaigasëretanë, pomagoriasëretanë. ");
INSERT INTO notNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Cara inibasigui Jesos, yaretasipari matsiguenga ipaniaca ibangoquë Jairo, icomantapëri: —Aroque ocamaque pisinto. Pitsipiriasiquima yamai cara páganëri Ira Ogomeantatsira. ");
INSERT INTO notNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iquemobëri Jesos, yotabitanëri: —Quero pitsorogui. Patiro pinguemisantina, aro obeganaima pisinto. ");
INSERT INTO notNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yaretaiganaca pongotsiquë. Icanque Jesos: —Quero picaigui omagaro: irianti Peroro, Joan, Santiago, Jairo aisati oniro ora janaitatsi intsibataiganaquina tsomagui. ");
INSERT INTO notNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iniaiguëri omagaro iraicotaiguëro yogasëretocotaigacaro. Icampëri Jesos: —Quero piraicotiro, teni ongameni, pisamini. ");
INSERT INTO notNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Icabíntsátaigabaqueri, igóiguënta cara ocamasantë. ");
INSERT INTO notNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yágobagotapëro obacoquë Jesos, icaimëro catsigue icanquero: —Janequi, pingabiritima. ");
INSERT INTO notNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aito cara ocaniatanai, pipigaa osëre, ocabiritanaa. Icanque Jesos: —Pomero operi. ");
INSERT INTO notNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iquenganeintasantanaca casintaro janequi ora camabitacha, carari igáqueri Jesos cara quero icomantaguetiri pairiraca ora cantënguicha. ");
INSERT INTO notNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Aique Jesos yapatotaiguëri irogomere icarati 12, yagobiacagaiguëri irojogantaguequimari camagari aisati iragaguibegajiri janaitaguetatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Igátaiguëri: —Pijátaguete pinguenguitsatomotaguetiri matsiguenga ati icanta Tosorintsi cara igáanti aisati piguibegaguetajiri janaitatsiripague. ");
INSERT INTO notNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aisati icantaiguëri: —Quero páganë pairoraca abatsiquë: quero páganë pigotiqui, quero pitsaguine, quero páganë pan, querootisati piguireguite, quero pite piguitsagare. ");
INSERT INTO notNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Atiraca pijáiguë, pingapë ibangoquë ira cajemobëmine. Pintiomotiri irooti cara pigaganëma basiniquë poeboro. ");
INSERT INTO notNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aitica poeboro cara te iranintaigue irágacaninataigabaquemi, te inguemisantaigabaquemi, popotetaineri quibatsipane pisapatotequë, aro pigaganëma. Pingantaigueri: “Tenta pinguemisantobëna, aiquenta iratsipiriacagaiguëmi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aro iátagueque, iquenaguetaiganaque poeboropaguequë, icomantaguetaigapëri imatsiguenga ora Caninaro Nibarintsi atiraca ingantaiguëma iragabisaicotajiri Tosorintsi. Aisati yogaguibegaguetajiri janaitatsiripague. ");
INSERT INTO notNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aique ira cobeingari Eroris cara Garireaquë iquemocoqueri Jesos aisati irogomere, omagaro icantaiguë itasongaguetaiguë. Te irogóte pairoraca inguenguema aintanta cantatsi Jesos Irianti Joan ira yogamaguë Eroris. ");
INSERT INTO notNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ainta basini icanque Irianti Erías iconijapai. Basini icantocotaiguëri Irianti comantantatsiri jirai, caniatajatsi. ");
INSERT INTO notNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Icanque Eroris: —Ira Joan nibatëacagantabitacari naati, carari ¿Pairi Ica naquemocoque itasorintsitasanti? Icogabeca Eroris iraneirime Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aro ipigaigapaa iragátane Jesos, icomantaigapëri antagaisati icantaiguë. Aique Jesos yágaiganaqueri casiriconiati aronisatiquë Betsaira, ");
INSERT INTO notNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","carari igóiguëro matsiguenga, yoguiataiganaqueri tojai. Yágacaninataigabaqueri Jesos, iquenguitsatomotaiguëri ati ocanta iragáantanequë Tosorintsi. Aisati yoguibegajiri janaitaguetatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aro ochapinitanë ipocasitaiguëri irogomere Jesos icarati 12, icantaigabitacari: —Yamai pigátaigueri icaegui matsiguengaca iriátagae poeboropaguequë iromananteta iraperi aisati irisomaigapë. Teni ine perintsi yaca tenta ontimingani. ");
INSERT INTO notNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yotabitaiganaqueri Jesos: —Pomaigueri obirojegui. Icantaiguëri irogomere: —Iroonti inatsi pan pabocorooti aisati pite sima. Tigueti angantima omaigueri iraperi queroca iáti amanantaiguineri. ");
INSERT INTO notNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aintanta tojai matsiguenga, sërari icarati 5,000. Icanqueri irogomere Jesos: —Pigasobicaigueri antagaisati, 50 yaca, 50 cara, 50 canta, aisa icanca omagaro. ");
INSERT INTO notNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aro yogasobicaiguëri omagaro. ");
INSERT INTO notNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aique yáguëro Jesos ora pan aisati sima. Inetsë jonoquë, icanqueri Iriri: —Pabati, nacarasiatocoquimiro oca noperijeguica popaiguinaca. Aro itibatsaaguequero pan Jesos, yotsatengaiguëri irogomere arota imaigueri matsiguengajegui. ");
INSERT INTO notNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yapaiguë antagaisati, iquemaigaca. Aique yobiitaguetajiro irogomere ora irangarataneegui, iagajiro 12 cantiri. ");
INSERT INTO notNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Basiniquë cataguiteri iáque casiriconiati Jesos, yamanaseguiri Iriri. Itsibataigari irogomere. Aro yosamitaiguëri: —¿Pairi ijitaiguëna matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yotabitaiganaqueri irogomere: —Aintapague ijitaiguëmi Obiro Joan baotisatantatsiri. Ainta basini icantaiguë: “Ira Jesos Irianti Erías, ipocaji”. Aintasati ijitaiguëmi comantantatsiri jirai ipigapaa. ");
INSERT INTO notNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aro yosamitaiguëri: —¿Pairo pijitaiguëna obirojegui? Yotabitanëri Peroro: —Obiro Quirisito Agabisaicoontatsiri igáque Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aique icanqueri Jesos: —Queroquerai picomantaguetiri pomatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pigóiguë nopaniaca Naro Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Yamai pënibaque najáque Jerosarénquë. Iratsipiriacagaigabaquina antiasipari aisati itingomiegui saseriroti aisati ira ogomeantiro isanguenare Moisés. Aisati irógaiguëna, carari ongaraque maba cataguiteri, nanganiatanae aisati. ");
INSERT INTO notNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aro icantaiguëri Jesos: —Iranintasantëca pairiraca aguiatanënane inguemisantasantina, iranatanëro igorosite, quero icantanonta iriati, iroontita përosati imomirintsibenquinaro pairoraca nongocaqueri Naro. ");
INSERT INTO notNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ira cogabitacha ingábintsëma yaca quibatsica, tenta iraninte iratsipiriero, aiquenta iratsipiriasantëma. Irari quemisantasantënane yaca quibatsica, irooti cara ingamobiquina Naro, aiquenta intiomoquina Jonogaguitequë, intimasantapë caninasati. ");
INSERT INTO notNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Aintaca sërari irasintaguetimaro antagaisati ora inatsi yaca quibatsica, aique ingamaque iriátë Sharincabeniquë, ¿Pairo iráque? ¿Teco iratsipiriasiquimaro omagaro? ");
INSERT INTO notNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Quero pipasiquitina, querootisati pipasiquitocotinaro nanibare. Nopaniaca Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. Aiquenta najátaje jonoquë. Cara nopigaima, nongobeingatasantapë nosangueguitetasantapë aisati icanta Pabati icobeingatasanti yosangueguitetasanti; intsibataigapëna ironomirepague Pabati irisaanganetsite caninari. Cara nopigaima naguipasiguitaiguëri iraegui pasiguitobitaiguina Naro yamai. ");
INSERT INTO notNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Aisonori nangantasantaiguëmi, nogomerejegui, aintapague obiroquë queroquerai cara picami irooti cara piniaigabaquina nopocaje Naro iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aro pabisanaque 8 cataguiteri, iáque Jesos. Yágaiganaqueri Peroro aisati Joan aisati Santiago, itongaiganaque tongagariquë. ");
INSERT INTO notNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cara yamanasegui Jesos, ipasiniatitanë. Yosangueborotanë porirere, aisati oquëtatasanotanë iguitsagare. ");
INSERT INTO notNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aisati iconijatomopëri pite sërari inibatagaiguëri Jesos, irianti Moisés aisati Erías. ");
INSERT INTO notNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aisati yosangueborotapë porirere iriro pite aisati. Inibatëgotapëro cara ingamaque Jesos aiquenta cara Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ipotsiquitasantaiguë Peroro aisati itsipa, carari icaguitasantanë iniaquero irosangueguitere Jesos aisati iniaigabaqueri basini pite sërari itsibatapari yaratingopë. ");
INSERT INTO notNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cara pënibaque iriáigae pitirooti, icanqueri Jesos Peroro: —¡Ogometinari, caninataque inaigue yaca! Intsome obetsique yaca maba pongotsi otiomijani, patiro pasi, patiro irasi Moisés, aisati basini irasi Erías. Carari te irogóte Peroro ora icanque; inibatasita. ");
INSERT INTO notNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Cara inibatasegui, omabocapari mingori paguëtaguepëri. Cara poganguibotaigapëri mingori, itsorogaiganaque irogomere Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aro iquemaiguëro Irinibare Tosorintsi cara mingoriquë, icantaiguëri: —¡Iriro Ica Notomi nigáqueri nacaninabentasantëri! ¡Pinguemisantaigueri! ");
INSERT INTO notNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cara itsonque inibatë, inetsaigabitaca, te irine Erías teatisati Moisés, Irianti Jesos iniaque. Aro imánaiguëro, te ingomantëmatiri pairiraca; aiquenta ingomantëgotëro. ");
INSERT INTO notNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Oquëtaguetanë yanongopaa, itonguibotaigabacari arosonori matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ainta paniro icaimapëri Jesos, icanqueri catsigue: —Ogomeantatsiri, pinetseri ica notomica, pingantaneintëgotiri. Irianti notomi paniro, ");
INSERT INTO notNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","inancari camagari. Icaimapinintacaqueri, itingaraacacari, yosimaresetëri ibagantequë, itsipiriasantacaqueri teraiquerai irapabaquëajiri. ");
INSERT INTO notNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aroque namanaigabitacari pogomere irojocajinerime notomi igamagarite, carari tigueti ingantima iragabeiri irojocajiri. ");
INSERT INTO notNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yotabitanëri Jesos: —¡Te pigóiguero Irinibare Tosorintsi! ¡Terai pinguemisantaiguero obirojegui, terai pinganinataigue! ¿Ati ongantima nantsibataiguëmi nabetaiguëmi natsipiriasita cara nogometasitaiguëmi? Tojai pitsoingaiguëna. Atsi pomapënari pitomi. ");
INSERT INTO notNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cara yamapëri itomi, imogomogoataganacari camagari, yotëanëri janequi quibatsiquë, itingaraacaganacari. Jesos isintsitsaqueri camagari, igáqueri ijoquineri janequi, yogaguibegasantairi, ipëri iriri. ");
INSERT INTO notNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iquenganeintasantanacari omagaro matsiguenga iniaiguëro. Icantaiguë: —¿Teco itasorintasanoti Tosorintsi, yagobeiri antagaisati? ¡Iriro cobeingari! Cara iquenganeintasantasiigari matsiguenga, icantaiguëri irogomere Jesos: ");
INSERT INTO notNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Pinguengasantiro oca nongomantaiguëmica, quero pomaguisantiro. Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica carari irácagantaiguëna matsiguenga irógaiguëna. ");
INSERT INTO notNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Carari te inguemaigabaquero ora icantabecari Jesos, icomëtaigabacaro tenta iranintacaguiri inguemiro. Aisati itsorogaiguë irosomitiri Jesos: “¿Pairo picanti”? ");
INSERT INTO notNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aique inibatobaganaca icantobaganaca irogomere Jesos pairiraca obaquenguitsine irirojeguiquë. ");
INSERT INTO notNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Igóque Jesos ora iquengaigaca. Yáguëri janequi, yogaratianqueri aganguisatiquë, ");
INSERT INTO notNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","icantaiguëri ira irogomere: —Pairiraca ágacaninatërine ica janequica iquemisanquinanta, aisati irágacaninatëna Naro. Pairiraca ágacaninatënane, aisati irágacaninatiri Ira agáquina. Carari págacaninatërica ira cantacha janequi, pomitocotirica, pingábintsërica, aro Tosorintsi iraniacaninatëmi, iraguibatëmi. ");
INSERT INTO notNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Aique icanqueri Joan: —Ogometinari, cani naniaiguëri sërari igáqueri camagari iriátopitëri matsiguenga. Icantabequina iquemisanquemi, inibatantaro popairo, iroro igáantantari camagari. Tenta intsibataiguena naroegui, nacantaiguëri: “Quero pigáantantaro iripajiro Jesos cagaribinta obiro nasiegui”. ");
INSERT INTO notNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yotabitanëri Jesos: —Quero pometopitari. Queroca iguisasitái, iromitococái ingancái ibega eiro. ");
INSERT INTO notNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aronibati cataguiteri cara iriátae Jesos jonoquë. Aro ipintsatanaca iriátë Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Igáqueri irogomere: —Pobate cara Samariaquë, pobetsiquinaro cara nasamapë. ");
INSERT INTO notNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aro iátabeca, carari igóiguë Samariasati iriátë Jesos Jerosarénquë, quero yoguibegui janaitatsiri Samariaquë, iroro te iranintaguëte irágacaninatobëri, te imeri pongotsi cara irisomapë. ");
INSERT INTO notNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aro ipiganaja irogomere icomantapëri Ira Jesos: —Teni iranintacagái asame Samariasati. Aique pite irogomere, Santiago aisati Joan, yosamitëri: Atingomi, ¿Picogui nomanocotiri Tosorintsi iragáquineri pamari omaniëma Jonogaguitequë, otagopëri Samariasati opoguiriaiguëri? ");
INSERT INTO notNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Inetsaiguëri pitirooti Jesos, isintsitsaqueri, icanqueri: —Teni onganinate anguiseri. Teni pigóigue ati picanta; teni pinganinasërete. ");
INSERT INTO notNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë yaca quibatsica arota nagabisaicotaigueri matsiguenga. Teri iroro nopocasite nagamagaigueri. Aique yogagaiganaca basiniatiquë poeboro. ");
INSERT INTO notNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cara iáigasegui, ipocasipëri Jesos sërari, icampëri: —Ogomeantatsiri, naguiatanëmini negaraca pijáque. ");
INSERT INTO notNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yotabitanëri Jesos: —Aiti imoro somani cara isami, aisati imagosi tsimiripague cara isami, carari te ine nasi nobango cara nanareima Naro caranta nopaniaca Jonogaguitequë, nomatsiguengatapë yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aro Jesos icanqueri basini sërari: —Obiro, intsome, piguiatanëna. Yotabitanëri sërari: —Natingoni, nocoguini naguiatanëmi, carari cara ingamaqueni apati. Pinintacaguina natianëri; aique coshoni naguiatanëmi. ");
INSERT INTO notNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yotabitanëri Jesos: —Piguiatina obiro. Ainta tsoengatsiri, ira te inguemisantiri Tosorintsi; iritijirita piri. Pijáte obiro, pingomantaguetiri matsiguenga ati ocanta iragáantane Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aintasati basini icanqueri: —Natingomi, aisati naro nocoguini naguiatanëmi, carari arotsita najápanaantë nobangoquë nobetsataigapanaantimari nomatsiguengasonori. ");
INSERT INTO notNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Icanqueri Jesos: —Cara irisiabaguitëgotiro isinguine sërari sabiriquë, inetsë cara iricaraque; queroca inetsi iricaraquero ibanguire. Aisa icanta, pairiraca parintachane iraguiatëna Naro, quero iquengaguetajiro ora icantaguetabeca jirai. Queroca yoguiatina përosati, queroca coshoni yogasantina, quero icomeiti iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aique Atingomi icoigaiguëri basini irogomere icarati 70, igátaiguëri pitenaque irobataiguëri Iriro cara poeboropaguequë cara iriátë Jesos aiquenta. ");
INSERT INTO notNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Icantaigabaqueri: —Ainta tojai matsiguenga icogasanti irabisaicotaigue, carari teni irine tojai comantaiguërine Caninaro Nibarintsi iragabisaicoontaiguëmari Tosorintsi. Aisati icantaigaro tojai oguitso panguirintsi, carari teni irine tojai ira obiguitirone. Pomanocotiri Tosorintsi iragátaigueri comantantatsiri iriáiguë inguemisantacagaiguëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yamai nagátaiguëmi, carari picantari itiomijani oisha ira nagáque cara cobeingariquë. Tojai iratsipiriacaquemi tsoengatsiri carari nomisantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Quero páganë quirequi, querootisati pitsaguine, quero páganë basini pisapatote; quero pobetsatobacari ira tonguibotaiguëmine; pabisanaquitiguiri. Pintsatimataiguë cara nigátaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Atiraca ingaimaigabaquemi pisamapë ibangoquë, pingapë tsomagui, aro pobetsatapëmari: “Nocoguini ingábintsaiguemi Tosorintsi, iromagoriasëretagaiguëmi”. ");
INSERT INTO notNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aroca icogui ingábintseri Tosorintsi, iraniacaninataigabaquemi, aro ingábintsaiguëri Tosorintsi iromagoriasëretacaqueri. Carari queroca ininti iquemisanti, quero imagoriasëretaguiri Tosorintsi; paniro obiro ingábintsaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aroca irágacaninatobëmi, përosati pisame ibangoquë irooti cara pijátaje, quero pogagueta pongotsipaguequë. Popero aisati póguimaro ora imabaquemi, caninataquenta iripënabentëngani tarobacaatatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Atiraca pijátaiguë, aroca irágacaninataigabaquemi, popaiguero pairoraca imaiguëmi, ");
INSERT INTO notNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","pigaguibegajiri janaitaguetatsiri, pingomantiri: “Pënibaque intingomibintaigapëmi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Atiraca pijáiguë, queroca yágacaninatobëmi, pijáte abatsiquë, pingomantiri: ");
INSERT INTO notNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pinguemaiguena: nopoteguititaiganaquema pojongamamori arota pigóigue cara icogabeca Tosorintsi intingomibintaiguemi, carari te pinintiri obirojegui. Tenta págacaninataigabaquena, aisa ocanta, te irágacaninatimi Tosorintsi. Carari nogótacagaiguëmi pënibaque intingomibintaigapëmari quemisantiriri Ira igáque Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pigóiguë jirai Tosorintsi iguisaigueri Soromasati, itagaiguëri, ipoguiriaiguëri itsipiriacagaiguëri. Yamaica nangantaiguëmi aiquenta cara ingomantëgotaiguëri matsiguenga, inguisasantaiguëri, iratsipiriasantacagaiguëri ira te inguemisantaigabaquemi; pabisanaquero cara iratsipiriacagaiguëri Soromasati. ");
INSERT INTO notNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aisati icanë Jesos: —¡Tojai pitsipiriaiguë obirojegui Coraseisati! ¡Tojai pitsipiriaiguë obirojegui Betsairasati! Tojai piniaigabitëna cara nitasongagueanti, carari te pingantëmatima yacaqueroca, te pinguemisantina. Carari iraniaquename cara nitasongagueanti Tirosati aisati Sirósati, inguengasëretaiguemame iriro, irojocaiguërome ora icantagueti te onganinate, inguemisantaiguëname, inganaqueme oquibepiriga manchaguintsi tsitaro quipiriro aisati irisobicaiguëme somamoquë arota ironijagaiguemari imatsiguenga cara yogasëretaigaca, icantaigaa yacaqueroca. ");
INSERT INTO notNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aiquenta cara Tosorintsi ingomantëgotaiguëri, iratsipiriacagaiguëri ira Tirosati aisati ira Sirósati tojainta te inganinataigue. Carari iratsipiriasantacagaiguëmi obirojegui Coraseisati aisati Betsairasati aroquenta piniaigabitobëna cara te onganinate, inguemisantaiguëname, inganaqueme oquibepiriga manchaguintsi tsitaro quipiriro aisati irisobicaiguëme s nitasonganti, carari te pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aisati obirojegui Caperinaosati, pijitasitaigabitaca pijáiguë Jonogaguitequë, carari pamatobitaigaca obiati përosatinta pitsoingaiguëna. Iroro pijátaguëque osobinta. ");
INSERT INTO notNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aisati nangantaiguëmi, nogomerejegui, pairiraca quemisantaigabaquemine obirojegui, aisati Naro inguemisantaiguëna. Iraegui tsoengaigabaquemine obiro, aisati iritsoengaiguëna Naro. Ira tsoenguënane Naro, aisati iritsoenguëri Ira agáquina, te inguemisantiri. Yamai, pijátaigue. ");
INSERT INTO notNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aique ipigaigapaa ira iragátane Jesos icarati 70, icaninataigapë, icantaigapëri: —Natingomi, nojogantaigacari popairo camagaripague, isotocaiganaque. ");
INSERT INTO notNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Icantaiguëri Iriro: —Jee, aisonori. Naniaqueri Satanás itingomi camagarijegui cara ijoquengani jonoquë. Nagobiaqueri Naro. ");
INSERT INTO notNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iroro nopaguëtaiguëmi nagabiomento. Aisa ocanta cara pigatiquërica marangue aisati quitoniro carari quero icantëmatimi, aisati pigabiaiguëri camagaripague, inguisaigabitëmi quero icantimi atiraca. ");
INSERT INTO notNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aisonori pigátaiguëri camagari, carari quero picaninataigui aroquenta iquemisantaiguëmi camagaripague, pinganinatasantaiganaque aroquenta pijáiguë Jonogaguitequë cara osanguenatocotaigaca popairo. ");
INSERT INTO notNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aique poganinatasantëri Jesos Caninaro Isëre Tosorintsi, icanqueri Iriri: —Pabati, picaninatasanoti; nacaninabentasantimini Obironta Itingomi antagaisati Jonogaguitesati aisati omagaro quibatsisati. Ainta cantasitacha: “Nigótasanti naro”, carari pimánopitaiguëri ati picanta Obiro aisati ati ongantima pigabisaicotaiguëri. Irianti pigótacagaiguë ira quemisanquena ira te inguengasitima irogótasantëmi iriro. Caninataque piganinataigueri iriro, picoquenta pigótacagaigueri. ");
INSERT INTO notNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aique Jesos icantaiguëri omagaro: —Ira Pabati ipëna antagaisati igótacaquina omagaro. Paniro igótasanotaquina Naronta Itomi; te irogótocotina basini matsiguenga. Teatisati pairi ogótirine Iriro. Paniro nigótiri Naro, Naronta Itomi. Aisati irianti nogometaiguë, nigótasantacagaiguëri Tosorintsi iriro. ");
INSERT INTO notNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aique yapisitaanaca Jesos inetsaiguëri irogomere, icantaiguëri casiriconiati: —Icábintsaiguëmi Tosorintsi, yoganinasëretaiguëmi aroquenta piniasantaiguëro ora noniagaiguëmira. ");
INSERT INTO notNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nangantaiguëmi: icogaigabitaca jirai comantantsirijegui aisati cobeingaripague iraniaiguerome oca piniaqueca obiro. Icogaigabitaca inguemaiguerome oca piquemaiguëca yamai, carari te iraneina teatisati inguemaiguena. ");
INSERT INTO notNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aro yaratianque ogomeantiro isanguenare Moisés, icogabeca ingomëtaguimarime Jesos. Yosamitëri: —Ogomeantatsiri, ¿Pairo nanganque arota najáte Jonogaguitequë, nantimasantapë përosati, quero nacami? ");
INSERT INTO notNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Icanqueri Jesos: —¿Pairo ocanti ora isanguenatacaqueri Moisés Tosorintsi? ¿Pairo pinibati? ");
INSERT INTO notNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yotabitanëri: —Pinintasantiri Tosorintsi Atingomi, pomasëretasantimari obiati, përosati pinguengueri, pinguemisantasantiri. Aisati pinintiri pitimanamitane pibega cara pininta obiati. ");
INSERT INTO notNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Icanqueri Jesos: —Caninataque pinibatë. Aroca pingantiro cantacha nega, aro pintimasantapë Jonogaguitequë përosati. ");
INSERT INTO notNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Carari ira ogomeantiro isanguenare Moisés icoque iraniacaninatirime Jesos. Iroro yosamitaguëqueri: —¿Pairiraca natimanamitane? ");
INSERT INTO notNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aro yotabitanëri Jesos: —Nosiacagantëmiro quingabaguirentsi. Ainta paniro jorío ipaniaca Jerosarénquë yanonganaca iátabeca aiquero poeboroquë jitacha Jericó. Carari aganguisati abatsiquë imabocacari cosirintipague, yágaigabaqueri icositaiguëri omagaro, yágabitsaqueri iguitsagare, ipasataiguëri. Aique ijocaiganaqueri abatsiquë, pënibaque ingamaque. ");
INSERT INTO notNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aro aique iquenopë paniro saseriroti, jorío aisati. Iniopëri ira sërari iramasitaga, aito cara yanamitanëri, te ingantaneintëgotiri. ");
INSERT INTO notNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aisati ipoque basini jorío, imatsiguenga Irebí, iniopëri, yotsitipari, yanamitanëri, teatisati ingantaneintëgotiri. ");
INSERT INTO notNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Carari ainta Samariasati iquenopë, yarepari, inetsapëri, icantaneintëgotëri. ");
INSERT INTO notNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iátasiqueri ijampitancari asaiti aisati obaa cochoari, iponataguequeri. Aique iqueicotacacari imoranequë Samariasati, yáganëri pongotsiquë cara isamaigui quenaigatsiri, yomisantëri. ");
INSERT INTO notNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Oquëtaguetanai, icoque iriátë Samariasati, yáguëri iguireguite pite tenario, ipëri casintaro pongotsi, icanqueri: “Jerica quirequi. Pomisantiri ica janaitatsirica. Yamai najáqueni. Queroca cotonguiboro quirequi, cara nopigaima nopënabenquimiri antagaisati”. Aique iáque. ");
INSERT INTO notNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yamai, pinguengueri maba sërari iniaigapëri ira iramasitaga. ¿Pairi itimanamitane ira itaiguë cosirinti? ");
INSERT INTO notNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yotabitanëri ogomeantiro Sanguenari: —Ira cantaneintëgotapëri. Icanqueri Jesos: —Atsi pijáte yamaica, pingantiro obiati negaca. ");
INSERT INTO notNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aique iquenaque Jesos abatsiquë, yarecaro poeboro cara otimi tsinane ojita Márita. Ocaimobëri obangoquë. ");
INSERT INTO notNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Aintasati irento Márita, ojita María, ora sobicomoqueri iguitiquë Jesos, oquemisanquero irinibare. ");
INSERT INTO notNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Carari opomirica Márita pobetsicaguequineri Jesos pairorapagueraca. Piátasiqueri, ocanqueri: —Natingomi, pinetse paniro naro nobetsiquemiro poperi. Te omitocotina nirento. Atsi pingantiro omitocotina. ");
INSERT INTO notNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yotabitanëro Jesos: —Márita, Márita, pogasëretagueca, popomirintsitaguecaro tojaipague. Ocaninataguetabeca, carari aiti patiro ocaninatasanti, ");
INSERT INTO notNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ora ocoque pirento, oquemisanquina Naro. Quero pairi ágabitsatiro cara otsibatëna Naro. ");
INSERT INTO notNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Basiniquë cataguiteri iáque Jesos casiriconiati yamanaqueri Iriri. Cara itsonque, icanqueri paniro irogomere: —Natingomi, ira Joan yogometaiguëri irogomere cara iromanocotaiguëri Tosorintsi. Yamai nocogui aisa pinganquima Obiro, pogometaiguena nomanocotiri aisati. ");
INSERT INTO notNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Icantaiguëri Jesos: —Cara pomanaiguëri Tosorintsi, pingantaigueri negaca: “Pabati nasiatiegui, ainta Obiro Jonogaguitequë; nocogaigui cara iraniacaninataiguemi omagaro matsiguenga Obironta Atingomisonori. Nocogaigui pintingomibintaiganaquena antagaisati. Aisati nocogui inganque omagaro matsiguengajegui ora picocagaiguëri aisati inganquimari iraegui timaigatsi Jonocaguitequë icantaigasegui omagaro picocagaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pomapinintaiguena noperi antagaisati cataguiteri. ");
INSERT INTO notNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pijocaigainaro ora nacantaguetomoquimi te onganinate, pomaguisantinaro, quero piquengainaro. Pingábintsasantaiguena. Aisa nacanta nacábintsëri ira cantaiguëna ora te ongomeite, te nanguisaneintajiri. Quero pinintacaguiri camagari irantacaguina ora te onganinate”. ");
INSERT INTO notNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aisati icantaiguëri Jesos: —Pinetse, nosiacagantëmiro aisati. Aisati ocanta aroca pijátasiqueri pomatsiguenga aganguite pomaniri pan. Pingampëri: “Nomatsiguenga, pomenaro maba pan. ");
INSERT INTO notNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yamaicasonori yarequina nomatsiguenga, carari te inëmate ora nomëri”. ");
INSERT INTO notNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aique irotopiquimi cara tsomagui, inganque: “Quero paseriguina. Aroque nasiquero sitëcori, nisamaiguini naro, najina, najaniquitepague. Quero nacanta nacabirita yamai cara nomabaquemiro pan”. ");
INSERT INTO notNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nacanquemi: queroca icabiritaja ipimiro irironta pamigote, ingabiritajima imëmiro ora pamanopiantëri arota quero paserigairi basini. ");
INSERT INTO notNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nangantaiguëmi aisa ocanta: pomanopiantiri Tosorintsi pairoraca coguitomotimi, aro imëmiro; pingogopiantiro pairoraca, aro piniaquero; pingaimapininqueri, aro inguemaquemi, irasirëgotëmi. ");
INSERT INTO notNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ira manántatsi imëngani; ira cogatsi iraniaquero; ira cajematsi inguemaquengani imëngani. Iromitococái cara omanaqueri; cara ongooqueri ironijagajái. ");
INSERT INTO notNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Pinetse, aroca iromanaquemi pitomi inganquemi: “Apati, pomena pan”, querosonori popiri mopë. Iromanaquemica: “Pomena sima najagueri”, quero popiri marangue. ");
INSERT INTO notNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Iromanaquemica: “Pomena iguitso tiapa”, quero popiri quitoniro. Quero popiri, iroonti pomasantiri ora icoguitiaca. ");
INSERT INTO notNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pinetsaigue. Te pinganinatasantaigue obiro, carari pigóiguë pingábintsaiguëri pitomi, pomabaqueri ora icoguitiaca. Icaninatasanoti Piri Tosorintsi, Ira timatsi Jonogaguitequë, igótasanti icábintsaiguëri iraisati, imaiguëri Caninaro Isëre ira manëgotaiguiri. ");
INSERT INTO notNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Basiniquë cataguiteri Jesos iniaqueri poro sërari inancari camagari imasontitacaqueri. Ijoquineri camagari, itasongobenqueri sërari, inibatagajiri caninasati. Iniaiguëri matsiguengajegui iquenganeintasantaigacari, ");
INSERT INTO notNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","carari aintapague icantasitaigacari: —Iroonti ijogantari camagari iragabiomento Berisebó itingomi camagarijegui, imitocoqueri Berisebó. ");
INSERT INTO notNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ainta basini tsoenguiri Jesos icanqueri: —Ogomeantatsiri, nocogaiguini nanetsemi pitasonguinaro pairoraca ora nogóontëmi Obiroca Quirisito. ");
INSERT INTO notNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Carari igóque Jesos ora iquengaigaca. Icantaiguëri: —Aroca irógobaguima matsiguenga timaigatsi quibatsiquë, ¿Teco iripoguiriobaguima? Aisa icanta matsiguenga pongotsiquë; queroca iquengaiga, querootisati itiomotobaga përosati. ");
INSERT INTO notNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tesonori iromitocotina Satanás. Ipëgatina. Picanque cara imitocoquina Berisebó cara nojogantari camagari. Arome Satanás inguisaiguërime igamagarite, ¿Atiroco ingantima intingomibintaiguërime camagarijegui? ");
INSERT INTO notNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Irirome omitocoquinane arota nojoquiri camagari, ¿Iriatisatico camagari omitocotaiguëri pomatsiguenga cara ijoqueri camagari iriro? Iriro ogótacagaiguëmine pomatsiguenga cara pamatobita obiati, picantocotaguetasitaiguina. ");
INSERT INTO notNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Carari yagobiacaquina Tosorintsi, iroro nojogantaigari camagaripague ora pigóontëma aroque parequimi yaca obiroquë iragáantane Tosorintsi, icogabeta intingomibintaiguemime. ");
INSERT INTO notNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ira camagari aisati icantari ibega sërari sintsiri, aiti ibiane, ichaapite, itongomento, omagaro ora yomisantantaro ibango querota icositiri pairoraca irasi. ");
INSERT INTO notNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Carari iriboqueca basini sërari sintsirisonori, irabisëpëri isintsire, iragabeiri, irágopitapëri irógomento ora yabentabeca, imaguetaigapëri imatsiguenga pairoraca ingogue. ");
INSERT INTO notNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ira te inguemisantina, te iraguiatina, iguisaquina, iriantinta iquemisanti Satanás. Aisati ira te iromitocotina, te inguemisantacaguinari matsiguenga, iquemisantacaqueri camagari. ");
INSERT INTO notNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Obirojegui jorío picantaigari ibega sërari inancari camagari quimingari. Isotocasitanaari camagari sërari; aro iátagueque igamagarite cara piriaguiteroquë quibatsi. Icogabeca iromagorie carari tigueti ingantiro. Aique iquianca: “Nopiganajima nobangoquë, cara sërariquë cara nopaniaca”. ");
INSERT INTO notNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cara ipigapaa iniopëro pongotsi otarogaga, obetsicaga, ositaga. ");
INSERT INTO notNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aique iáque, icaimaiguëri basini camagari quimingarisonori icarati 7. Aique yagobiaiguëri sërari icasëretaigapairi, inantasantaigapari. Yogatsitasantëri sërari, itsipiriasantacagaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ainta arosonori matsiguenga iquemaiguëri Ira Jesos. Ocaimë paniro tsinane, catsigue ocanqueri Jesos: —Tojai Tosorintsi icábintsasantëro piniro ora tominquemi jirai tsotaquemi. ");
INSERT INTO notNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Carari icanquero Jesos: —Aisonori, carari icábintsasanotaiguëri yoganinasëretaiguëri antagaisati ira quemaigabaquero Irinibare Tosorintsi, iquengasëretëro, iquemisantasantëro. ");
INSERT INTO notNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yapatobiritaigapari Jesos tojai basini matsiguenga. Aique yogometaigabaqueri Jesos, iparintaca icantaiguëri: —Te pinganinataigue tojainta pitsoingaiguëri Tosorintsi; iroro piniantëna: picogaigui natasongomotaiguemi; carari quero nacantajimiro aisati. Pinguengasëretiro ora icanque Jonás cara yosiguina nibega Naro, aro pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Piquemocotaiguëri Jonás jirai, iniguëri omaganiro canianiro iguibeguinte sima. Maba cataguiteri inë tsomagui, aro icomarangairi onamijaquë ora irogóontaigabaquimari Nínebesati cara igáqueri Jonás Tosorintsi. Aisa nacanta Naro: aiquenta pigóontaiguëna cara igáquina Tosorintsi; nangamaque, ongaraque maba cataguiteri nanganiatanae Naronta paniacha Jonogaguitequë, nomatsiguengatapë cara niboguë yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aisati jirai ainta tsinane itingomi omatsiguenga Sebasati. Cara opaniaca parigoti, oquemocoqueri Saromón tojai igóque iriro, aro piátasiqueri jaanta oniopëri oquemisampëri. Yamai ainta Naro obirojeguiquë, nobaqueri Saromón carari te pinguemisantaiguena. Aiquenta, cara Tosorintsi ingomantëgotaiguëri antagaisati matsiguenga, ongabiritanëma ora tsinane Sebasato ongantocotaiguëmi: “Picantasantaguetaiguë obirojegui ora te onganinate cara ipocasitaiguëmi Ira Agabisaicoontatsiri, carari te pinguemisantaigabaqueri. Inguisasantaiguëmi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aisati ingabiritaiguëma Nínebesati ingantocotaiguëmi: “Naquemisantaigabaqueri Jonás, nacantaigaa yacaqueroca nojocaigairo ora nacantaguetaiguë te onganinate, carari picantasantaguetaiguë obirojegui ora te onganinate, te pinguemisantaigabaqueri Agabisaicoontatsiri Ira obaqueri Jonás. Inguisasantaiguëmi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aisati icantaiguëri jorío Jesos: —Aintaca paniro matsiguenga oboquero michero iranetsantëmaro, te iromániro, te iroguiro osobiquë cantiri paquitomosiga, carari iroquero jonoquë arota ogonijaguitetocotiri omagaro timatsi pongotsiquë. ");
INSERT INTO notNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ira cogasantiro ingante pairoraca icocaqueri Tosorintsi, irojocajiro ora quimingari, irogótasantanëro ora icogui Tosorintsi, ingantasantëro. Aisati ingantimari ibega sërari cara iniasanti, te irantibatima pogonijatinerinta omagaro. Carari ira te iranintiro ingante ora icocaqueri Tosorintsi, te irojocajiro ora icantagueti te onganinate, te inguemisante, përosati cara itimi tsitiniriquë. Aisa ingantimari ira te iranee; irantibatanëma tenta ongonijatomotiri pairoraca. ");
INSERT INTO notNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Caninataque pigónijintima piquemisanquerica Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aroca piquemisantasantëri, aro pigótasantanëri, quero pitsoinguëmati, pintimaque cataguiteriquë. Pinganquimaro michero cara pogani jonoquë pogonijaguitetocotiri antagaisati matsiguenga inatsi pongotsiquë. ");
INSERT INTO notNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cara inibatasegui Jesos, icanqueri bariseo: —Intsome ajáte nobangoquë nopaaguëmini. Aro yoguiatëri, yapaaguëri. ");
INSERT INTO notNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te inguibocotima Jesos; iroro iquenganeintaguëca bariseo. ");
INSERT INTO notNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aro icanqueri Atingomi: —Aisonori obirojegui bariseo pametaiga piquibopiantiro pitasane otisitaquë aisati poberatote, carari te pinguibiro quimingaro cara otequë. Ongantaiguëmi pibega obirojegui: piquibococa pobacoquë, carari tsomagui përosati pamatobitaiguëri matsiguenga, picositaiguëri, picantagueti tojai quimingaro. ");
INSERT INTO notNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Te pigóigue obirojegui! Pigóiguë Tosorintsi yobetsiquëmiro pobaco; ¿Teco pigóigue aisati yobetsiquëmiro pisëre ora piquengasëretanta? ");
INSERT INTO notNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pametaiga popasitabitacari ira coguitiachari. Obitsita pobetsiquima pisërequë, aique pingantaneintasantëgotaigueri coguitiachari, pomasitasantimari, aro pingábintsasantiri. Aisati iraniacaninataiguëmi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Obirojegui bariseo, iratsipiriacagaiguëmi Tosorintsi! Aisonori popagarantiri arosata pasiati. Aroca páguë quirequi 10, aro pomagaranqueri paniro irasi Tosorintsi. Aroca páguë 10 osi pobanguirepague, aro pomagaranqueri patiro irasi Tosorintsi. Ocapague caninataque, carari te pinguengaiguero ora icocagasantaigabitëmi Tosorintsi: icogabeca pintimeme caninasati, icogabeca pinguemisantirime Tosorintsi aisati pintinerime. ");
INSERT INTO notNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Obirojegui bariseo, iratsipiriacagaiguëmi Tosorintsi! Picogasantaiguë imaiguemi sobicomentotsi caninaro cara yapatotaiga jorío. Aisati picogasantaiguë irobetsataiguemi matsiguenga cara opimantagani pairoraca, irobetsataiguëmi: “Ogometinari”. ");
INSERT INTO notNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Iratsipiriacagaiguëmi Tosorintsi! Obirojegui aisa picantaro ora yogantari camatsirini, te ine pairoraca ora irogóontëmaro matsiguenga. Yanëitaiganaque matsiguenga jonoica, yoguimingataigaca. ");
INSERT INTO notNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aintasati paniro ogomeantiro isanguenare Moisés, icanqueri: —Ogomeantatsiri, cara pinibatëgotëri bariseo negaca, picantocotaguetasitaiguëna aisati naroegui ogomeantiro isanguenare Moisés. ");
INSERT INTO notNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yotabitanëri Jesos: —Aisati Tosorinti iratsipiriacagaiguëmi obirojegui ogomeantiro isanguenare Moisés. Pobomirintsitaiguëri matsiguenga cara pogometaguetiri tojai, carari te pomitocotëmatiri tenta pinguemisantaiguero pasi pogomeantane. ");
INSERT INTO notNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Iratsipiriacagaiguëmi Tosorintsi pobetsicaiguirotinta pongotsipague pinguengantimari comantantatsiri ira yogamagaiguë pomatsiguenga jirai. ");
INSERT INTO notNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Obirojegui ógaiguëri. Arome pintimaigueme jirai pigamagaiguërime obiro. Pitsipiriasitaigaca yamai cara pobetsicaiguëro pongotsi pinguengantëmari tenta pinguemisantaigueri. ");
INSERT INTO notNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iroro igótocotaiguëmi Tosorintsi icanque: “Nagáquemiri comantantatsiri aisati nagátane. Nigóque pógarantaigabaqueri aisati basini pinguisaiguëri catsimari. ");
INSERT INTO notNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aiti picantagueti picogaiguinta pigamagaigueri omagaro comantantatsiri: pasi poguiro póganti, obiro aisati pomatsiguenga jirai. Naguibitacaiguëmiri cara pógaiguëri antagaisati comantantatsiripague cara iroraini nobetsiquë quibatsi irooti yamai; pógaiguëri obirojegui aisati pomatsiguenga jirainisati. Pintimaigueme jirai, pógaiguërime aisati. ");
INSERT INTO notNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Naguibitacaiguëmiri obirojegui cara pógaiguëri Abel aisati basini tojai. Aisati pogamaguëri Sacarías ira pógaiguë nobangoquë aronisati itagantariquë”. ");
INSERT INTO notNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aisonori iratsipiriacagaiguëmi Tosorintsi, obirojegui ogomeantaiguëro isanguenare Moisés. Pigótaigabitaro Irinibare Tosorintsi. Iroro pogometaguëtaigabitacari pomatsiguenga, pamatobitaiguëri. Te pingogaigue obirojegui pigótiri Tosorintsi, teatisati pinintacagaigueri irogóigueri Iriro pomatsiguenga ira cogasantabitacari iragabisaicotaiguëri Tosorintsi. Poticaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Aro itsonquero Jesos inibataiguëri. Cara isotocaiganaque antagaisati, iguisaneintaigacari Ira Jesos bariseoegui aisati ira ogomeantiro Sanguenari. Yosamitaigabitacari pairoraca; icogabeca irinibatacaquerime Ira Jesos te ongomeite. Icantobaca: —¿Pairoraca anganqueri Ira Jesos aniantëmari? Aroca anibataqueri ora te onganinate, aro anguisasantëri agamaguëri. ");
INSERT INTO notNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aro yapatobiritaigacari Jesos arosonori matsiguenga, yagaticobacaigaca. Iparintaca Jesos icantaiguëri irogomere: —Quero picantaigari bariseoegui, pigamaiguemari iromatobitaiguëmi. Inibati caninasati carari icanquero basiniati, yamatobianti, yoguimingataiganaqueri matsiguenga ira quemisanqueri, icantacaqueri ora te onganinate aisa ocanta ora piponganta pan potsatianquero omagaro pan. ");
INSERT INTO notNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pairoraca ománocotaga yamai, ongonijaque aiquenta. Ora te ogótingani jirai, ogótanëngani aiquenta irogóiguë antagaisati matsiguenga cara yamatobianti bariseo. Quero pairo mánëmatacha. ");
INSERT INTO notNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aisati obirojegui, pairoraca pinibatë yamai pimánabecaro, aiquenta inguemaiguëro matsiguenga. Pairoraca pinibatëri pomatsiguenga casiriconiati tsomagui pobango, aiquenta ongonijatsatae cara yapatotaiga matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yamai nongomantaiguëmi, nomatsiguenga, quero pitsoroguiri ira cogatsi iróguimi. Aroca iróoquemi, iroonti pobatsa iróoque; tigueti ingantimi pisërequë. ");
INSERT INTO notNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nangantaiguëmi, pominguiri Tosorintsi, pomingatsatiri. Ingoqueca, iróoquemi; carari aisati ingoqueca, iragáquemi Sharincabeniquë. Jee, aisonori pintsoroguiri Iriro. ");
INSERT INTO notNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Teco pigóiguë ipimantagani tsimiri iraagueri matsiguenga, te iripënatasantima? Carari igóiguëri Tosorintsi, te iromaguisantiri tsimiri. ");
INSERT INTO notNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aisa ocanta igótasantëmi: igóti atiraca ocarati piguisi. Aroca yomisantaiguëri tsimiripague Tosorintsi, iromisantasantaiguëmi obirojegui. Quero pitsorogui. Pinganinabentiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nangantaiguëmi: pairiraca inganqueri imatsiguenga: “Ira Jesoquirisito Natingomi”, aique cara Jonogaguitequë inguemaiguëna ironomire Tosorintsi cara nanganqueri Pabati: “Itingominquena iriro, nomatsiguengatacari Naro”, Naanti paniacha Jonogaguitequë nomatsiguengatapë cara niboguë yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Carari inganquerica matsiguenga: “Cagari Jesos Natingomi”, aisati nanganqueri Pabati: “Tenta intingomintina iriro, iroro te nogótaguëtiri iriro Naro; cagari nasi”. Inguemaiguëna irisaanganetsite Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë. Carari pairiraca cantëgotaguetasiquinane, aroca inganquima yacaqueroca, iragabiaqueri Tosorintsi ingábintsëri, irojocajineri iromaguisaintairi ora icantagueti te onganinate. Carari quero icábintsiri ira cantëgotaguetasitarone Isëre Caninaro, quero yomaguisantineri, quero ijocajineri përosati queronta oquemisantacagajiri Isëre aroquenta imaintëro. ");
INSERT INTO notNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Cara irágaiganaquemica cara yapatotaiga jorío, aisati iráganëmi catingasatiquë joes aisati itingomi, quero pitsorogaigui, quero pogasëretaiga cara potabitanëri ");
INSERT INTO notNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ogomequeminta Isëre Tosorintsi ora pinibataiguë. Onibataquemi Caninaro Isëre. ");
INSERT INTO notNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Cara yapatotaiga matsiguenga, ainta paniro sërari icanqueri Ira Jesos: —Ogomeantatsiri, atsi pingantiri igue imagarantinaro ora ijocaiganaquena apati cara icamaque. Imeitënaro nasi igue. ");
INSERT INTO notNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yotabitanëri Jesos: —Quero nacantiri cagarinanta joes, ira cantërine caninasati imagaranquemiro. ");
INSERT INTO notNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aique icantaiguëri antagaisati Jesos: —Pigamema, quero picogaigui pasintagueta. Quero pinebetaro ora yasinta basini. Quero ocaninataguimi cara pasintaguequima. ");
INSERT INTO notNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aique yosiacagantëneri quingabaguirentsi: —Ainta sërari casintaguetachari. Cara iritoganequë ipanguitëro tirigo, otojaigasantanë. Yobiguitëro tojai tirigoguitso. ");
INSERT INTO notNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aro iparintaca iquianca: “Teni cotonguiboro nobango asi tirigoguitso jagasantaca. Aiti tojaiquerai. ¿Pairoroco nanganque yamai? ¿Negaraca noguëro nomisantëro? ");
INSERT INTO notNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ajaa, naquianca. Nogomeriguetëro obangopague tirigo, nobetsiquëro iroraipague oquibeguinte, aro noguëro antagaisati natirigote aisati omagaro nasintagueta. ");
INSERT INTO notNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nanganque: ‘Inomoquina tojai, quero nitsonguiro tojai osarini. Yamaica nomagoreaque, nopasantë, nasinguitapininquimaro’ ”. ");
INSERT INTO notNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Carari icanqueri Tosorintsi: “Te pineicotima obiro oshoincoquiminta. Yamaica tsitiniri pingamaque. Aique, ¿Pairi casintaguetajimarone antagaisati ocapague inomoquimi ora picaninabentabeca”? ");
INSERT INTO notNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aisati icanta antagaisati matsiguenga cogatsi irasintasantëma tojai, carari te iraninte ingábintseri Tosorintsi. Caninataque pobetsiquima pintiomoqueri Tosorintsi Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aique icantaiguëri irogomere Jesos: —Nangantaiguëmi: quero pogasëretocotaro poperi, piguitsagare, atiraca páguëro. ");
INSERT INTO notNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Itimacaquimi Tosorintsi; ¿Queroco ipaiguimi poperi, piguitsagare aisati? ");
INSERT INTO notNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pinetsaigueri ira tsimiripague. Teni imanguite, teatisati iráguiro ibanguire iroquero pongotsiquë cara irágopiantaiguëro aiquenta irapapiantëro. Carari ipagueiguëri Tosorintsi iraperi antagaisati cataguiteri. Aroca iromisantaiguëri tsimiripague, aisati obirojegui iromisantasantaiguëmi pabisaiguërinta tsimiripague. ");
INSERT INTO notNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aroca pigasëretima, ¿Aroco pomitojaiguëro posarinite? Quero. Pitsipiriasita cara pogasëreta. ");
INSERT INTO notNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tiguetinta pingantima arosata, ¿Pairo pogasëretocobiritaro basinipague oquibe? ");
INSERT INTO notNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pinetsaiguero otegapague tobari atiraca oquibianë. Te onguengue. Te onguirique, teatisati ontëmate, carari iroro caninarosonori. Jirai itimi Saromón itingomi joríojegui. Iquitsagata caninasati yoganinata carari te aisati ingantimaro pibega orapague otega. Pabisanaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tosorintsi yoganinatëro otegapague tobari ora quero ocosamaniti aronta omanapague osiguiricanë, iritaguëro matsiguenga. Cara yoganinatëro otegapague Tosorintsi, ¿Teco iromisantaiguëmi obiro aisati; inguitsagatacagaiguëmi? ¿Pairo pitsoingobitaiguëri? ");
INSERT INTO notNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Iroro quero piquengasëretaguëta, quero posamita: “¿Pairo nopë? ¿Pairo nóguëma”? ");
INSERT INTO notNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aisati icogaiguëro ocapague ira te inguemisante. Quero posigari irirojegui, aroquenta igóquero Pabati Tosorintsi cara Jonogaguitequë ora picoguitiaiga obiro. Iromisanquemi. ");
INSERT INTO notNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Iroro pingogasantaguëque intingomibintaiguemi, aro imaiguëmi omagaro ora coguitiomoquimine. ");
INSERT INTO notNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Quero pitsorogaigui. Obirojegui picantaigari noishate, Naronta omisantantatsiri. Te pintojaigue, carari inintaiguëmi Pabati Tosorintsi, icaninabentaiguëmi, icogasanti pintingomintaiguemari. ");
INSERT INTO notNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pomimantiro ora pasintagueta, pomaguetiri coguitiaguetachari omagaro opënataga; aique imëmi Tosorintsi ora caninaro cara Jonogaguitequë cara quero yapiro cajiro, quero piraaga, querootisati icositimiro, quero pitsonga. ");
INSERT INTO notNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aitica ora pasintagueta yaca quibatsica, pinguengasëretapinintiro ora inatsi yaca quibatsica; carari aitica pasi Jonogaguitequënta, pinguengasëretapinintiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Aisati icantaiguëri irogomere Jesos: —Pigamaiguemari Pitingomi, pobetsicasantaiguema. ");
INSERT INTO notNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Obirojegui, nogomere, aisati picantaigari iromeraro casintaro pongotsi. Iáque casintaro iraniaqueri imatsiguenga cara iráquero iina. Ainta iromeraro yomisantëneri casintaro pongotsi, yobotaiguëro micheropague, icaguitaiguë. Yoguiaiguëri irooti cara irarepëma, aito cara irasirëgotapairi. ");
INSERT INTO notNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aro inganinatasantaiguë iromeraro igaguitaga cara irarepëma casintari. Nangantaiguëmi: iriati agasobicaigapëri iromeraro, irapajagaigapëri. ");
INSERT INTO notNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aroca iribocapae aganguite, queroca coniamaniquë, jemita: iromeraro igaguitaga inganinabentasantaigabaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aiti basini nongomantëmi: ainta basiniati casintaro pongotsi: aroca irogóque atiraca ongantima iribocapë cosirinti, ingaguitë, iromisantasantëro ibango, quero inintacaguiri icositiri pairoraca. Cara te irogóte atiraca ongantima iriboque cosirinti. ");
INSERT INTO notNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aisati nacantabecari cosirinti, te nongomante atiraca ongantima cara nopocaje. Jirai nopaniaca Jonogaguitequë, nomatsiguengatapë yaca quibatsica. Pënibaque najáque. Aiquenta nopigaima. Aro pinguengaiguena, pobetsiquima, pigamaiguena arota quero nomabocapëmi. ");
INSERT INTO notNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aro icanqueri Peroro: —Natingomi, ¿Pairi picantaiguë oca? ¿Paniroco naroegui, picoguico irogótaiguero omagaro matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yotabitanëri Atingomi: —Aisati picantari ibega iromeraro caninari, igótasanti, iquemisantasantëri ibatorote, icanquineri ora icocaqueri. Ira ibatorote icanqueri imaguetaiguëri basini iromeraropague iraperi. Aique iáque ibatorote. ");
INSERT INTO notNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","Aroca iraniopëri iromeraro antatsi caninasati ora icanëri, ingampëri ibatorote: “Caninasati picantaguequero ora nococaquemi. Yamai nocogui pomisantasantinaro omagaro ora nasinta, nigótinta yamai quero pamatobianti”. Aro inganinasëretë iromeraro. ");
INSERT INTO notNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Irari, aroca irajitabetima iromeraro te ongomeite: “Querojengari ipigaa nobatorote irooti cosamani”, inguisaiguërica itsipa basini iromeraro iripasataiguëri sërari aisati tsinane, iromeratëmari, irapasantë iriro irisinguitopiantëma, ");
INSERT INTO notNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","iripigapëma ibatorote iromabocapëmari tenta iragueiri. Aro irócagantapëri iratsipiriacagopëri, irojocaigapëri cara intsibataiguëmari tsoengatsiri tenta inguemisante. ");
INSERT INTO notNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ira iromeraro igótabecaro ora icocaqueri ibatorote, carari te ingantiro, te irobetsiquima, iripasatacagantasantapëri. ");
INSERT INTO notNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Carari ira te irogótasante ora icocaqueri ibatorote, quero tojai ipasatiri. Quero icocaguiri tojai ira te irogóte. Irari ogótasantatsi, ingocagasantëri tojai. ");
INSERT INTO notNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Aisati icanque Jesos: —Nipocasique yaca quibatsica arota inguisaiguena matsiguenga iribëquëgotaiguena corosiquë. Ainta inguemisantaiguëna, ainta basini quero iquemisantaiguina iratsipiriacagaigueri ira caninabentaiguënane. Inguisabacagobitaiguëna. Nocogabeca abisënguitsineme omanapague. ");
INSERT INTO notNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nigóque inguisaiguëna matsiguenga, irógaiguëna. Nigótironta, nogasëretasantaca yamai. Nocogui nangantiro omanapague. ");
INSERT INTO notNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Quero pijitasita nipocasica irágacaninatobagaiguëma omagaro matsiguenga. Quero yágacaninatobaga. Nipocasique nanganqueri inguisabacagaiguema. ");
INSERT INTO notNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aintaca pabocorooti timaigatsi pongotsiquë inguisabacaguima, quero iquengabiritina. Ingaraque maba, inguisasëretaiguëri pite ira quemisanquinane. Pite inguisasëretaiguëri maba. ");
INSERT INTO notNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nipocasique iroonti inguisasëretiri itomi iriri, aisati inguisasëretiri iriri itomi; onguisasëretobaguima osinto oniro; aisati onguisasëretobaguima eba aguiro. ");
INSERT INTO notNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aisati Jesos icantaiguëri ira botoibiritaigari: —Cara piniaigabaquero oquibe mingori oconijapë aiquero cara icanaque paba, picantaiguë: “Coraguetaque angani”. Aro omariaque. Pigóiguë omariaque cara pitimaigui. ");
INSERT INTO notNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aisati cara onguëtaguetanaeca, picanque: “Quero oparigui”. Aro osariganaque, ongatsiringaguetanë. ");
INSERT INTO notNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Te pinganinate obirojegui; pinibatë patiro carari picanque basiniati. Pigóiguëca omariaque angani, aisati aroca ongatsiringaguetë, ¿Pairoroco te pigóbirite piniantimaro ora piniaiguë icanque Joan baotisatantatsiri, aisati nacanque Naro aisati ora nogometaiguëmi? ");
INSERT INTO notNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aisati ¿Pairo te pingogobite pigóiguero ora aisonori, ora caninari? ");
INSERT INTO notNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aroca inguisabiriquimiri pomatsiguenga quirequi ira pirebetëri, iráganëmica cara joesiquë, piniantasantima pinguenguema cara abatsiquë queroquerai pareta. Pinguenguema atiraca ongantima popënabentajiri ira pirebeti. Aroca iráganëmi cara poesitoquë, ira joes iragáqueri soraro: “Páganëri ica, pomingueri”. Aro iromianquemi cara iromingamentoquë. ");
INSERT INTO notNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nangantaiguëmi: queroca pipënabentiri antagaisati ira pirebetiri, quero yomisotocajimi aisati. ");
INSERT INTO notNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aique iátasitaiguëri Jesos matsiguengapague, icomantaigapëri: —¿Piquemocotaiguëri Garireasati yógagantaiguëri Pirato? Iáigabitaca Jerosarénquë ibangoquë Tosorintsi yógaiguëneri ibira. Carari iguisaigabaqueri Pirato igátaiguëri isorarote yógaiguëri. Iconoataiguëri iraraa Garireasati iraraa ibira yógaiguëneri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yotabitaiganaqueri Jesos: —¿Aroquenta yogamagaiguëri pijitaiguëco ira Garireasati cantasantagueantënguitsi ora te onganinate, yabisaiganaqueri imatsiguenga? ");
INSERT INTO notNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nangantasantaiguëmi: tesonori. Carari queroca pijocajiro ora picantaguetaiguë te ongomeite, queroca picantaigaa yacaqueroca, aro pingantaiguëmari ibega Garireasati camënguitsi, Tosorintsi iripoguiriaiguëmi obirojegui aisati. ");
INSERT INTO notNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aisati piquemocotaiguëri Jerosaresati cani cara oparigatetaiguëri mopëpongo cara Siroéquë, pitsitocaiguëri 18 matsiguenga, icamaiguë. ¿Pairo icamobitaiguë? ¿Pijitaiguëco icantasantaguetaiguë iriro ora te onganinate, yabisaiganaqueri basini Jerosaresati, iroro inintacaguëqueri Tosorintsi pitsitocaiguëri? ");
INSERT INTO notNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nangantaiguëmi: tesonori. Irianti cantaigari omagaro matsiguenga. Aisati obirojegui, queroca pijocajiro ora te ongomeite, queroca picantaigaa yacaqueroca, iripoguiriaiguëmi obirojegui aisati. ");
INSERT INTO notNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aique icanque Jesos, yosiacagantaiguëneri: —Ainta matsiguenga ipanguitëro iguera cara irobasitequë. Piquibiaque caninasati, inetsapiantabitacaro aitica oguitso, iráquerome, carari te onguitsotëmate. ");
INSERT INTO notNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aique icanqueri ira omisantineri: “Maba osarini nocogabecaro oguitso oca igueraca; te naneiro. Pitoguiro iguera, teni ongomeite, otimabeca”. ");
INSERT INTO notNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yotabitanëri omisantiro: “Nobatorote, ineta patiro osarini basini. Nanguiaque quibatsi nongonaguëro itiga pobira; ");
INSERT INTO notNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","aique aroca onguitsotanë, caninataque. Carari queroca pini oguitso, aro notoquero”. ");
INSERT INTO notNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Basiniquë sábaro yogomeantë Jesos cara yapatotaiga joríojegui. ");
INSERT INTO notNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ainta tsinane cara pongotsiquë aro inancaro camagari jirai. Aroque yoanaitëro tojai osarini ocarati 18, iroro poguitaguëca tigueti ongantima aratingue catingasati. ");
INSERT INTO notNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Cara iniaquero Jesos, icaimëro, icanquero: —Obiro, tsinane, nagaguibegajimiro cara poguica. ");
INSERT INTO notNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aro yotsagaquero, irooti pibeganaa, ocatingatanai. Aito cara ocanque catsigue: —Icaninatasanti Tosorintsi, yogabisaicotajina naro. ");
INSERT INTO notNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aique ira obatatsi cara yapatoibiritaigari Tosorintsi jorío iguisaneinqueri Jesos aroquenta yogaguibegajiro tsinane sábaroquë. Icantaiguëri ira matsiguenga: —Aiti 6 cataguiteri cara atarobacaataigui cara caninataque popocaigue iragaguibegajimi. Carari quero pipocasitiri sábaroquë, iroonti cataguiteri comagoriantague. ");
INSERT INTO notNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aique yotabitanëri Atingomi: —Tojai pamatobianti. Pinibatë patiro, picanque basiniati. Pintagueti obirojegui sábaroquë aisati. Pinetse: ¿Teco pintsaicotiri pobaacate aisati pomorane cara páganëri nijaaquë iróquima nija sábaroquë? ");
INSERT INTO notNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Carari cagari pobira oca tsinaneca, iroonti imatsiguenga Abaram. Tojai osarini ocarati 18 yoanaitëro Satanás. ¿Teco onganinatasante angábintsero sábaroquë? ");
INSERT INTO notNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cara inibatë negaca, yoguimairentaiguëri antagaisati quisaneintaiguëri, yoguipasiguitaiguëri. Carari iraegui botoibiritaigari icaninabentaiganaqueri, icantaiguë: —Ocaninatasanti ora icantagueti Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Aique icanque Jesos: —¿Yamai ati ocanta cara itingomibintiri matsiguenga Tosorintsi? ¿Pairo nanganquero nosiacagantëmiro? ");
INSERT INTO notNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aisati ocantaro pibega oguitso mositasa ora imionguë sërari iritoganequë. Pianë, piquibianë tojai, ipocaigapë tsimiripague, yogaigapëro imagosi otsegopaguequë. ");
INSERT INTO notNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aisati icanque Jesos: —¿Pairo nosiacagantëmiro cara igáanti Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aisati ocantaro pibega ora piponganta pan. Cara obetsiquëro pan tsinane, águëro tojai opane tirigo, ongonaguëro arosata piponganta pan. Aique oponganë antagaisati. ");
INSERT INTO notNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aro iátagueque Jesos aiquero Jerosarénquë, iquenagueque poeboropaguequë yogometaigapëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yosamitobëri paniro: —Natingomi, ¿Atiraca ingaraque ira abisaicotajatsine? ¿Aroco ingaraque arosataanti? Icanqueri Jesos: ");
INSERT INTO notNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Nosiacagantëmiro. Aroca pininti pingapë cara itimi Tosorintsi, pomomirintsibentima pingapë otiomijani omoro. Ainta tojai icogasantaigabita iriáiguë Jonogaguitequë, carari quero icantiro yaretaigaro tojai. ");
INSERT INTO notNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aisa icanta casintaro pongotsi, irasitëgotanëma. Aique obirojegui terai pingaigue paratingaiguë sotoquë, pingaimë: “Natingomi, pisirenaro”. Carari irotopitanëmi tsomagui: “Teni nogóiguemi negaraca popaniaca”. ");
INSERT INTO notNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aique pingantaigabitëmari: “Jirai pitsibataiguëna, papëcoiguëna, póigotaiguëna, aisati pogometaiguëna abatsipaguequë noboeborotequë”. ");
INSERT INTO notNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Inganque tsomagui: “Nagatsitaimiro teni nogóiguemi negaraca popaniaca. Pijátopitaiguena; popigaiguema tojainta picantagueti ora te onganinate”. ");
INSERT INTO notNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Canta pijáiguë, pigasëretasantaiguëma, piragasantaiguëma, aisati pitsitsiaguitetaiguë, cara piniaiguëri jaanta ira Abaram, Isac, Jacob aisati omagaro comantantatsiri cara itingomibintaiguëri Tosorintsi, carari obirojegui pijocaga sotoquë queronta picanta piáigui canta. ");
INSERT INTO notNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iribocaigapë arosonori quemisantatsiri paniaigacha cara iconteti paba aisati cara iquiro, aisati toonquë aisati comate, aisati omagaro quibatsipaguequë, irisobicaigapë mesaquë iragáantanequë Tosorintsi, inganinabentaigapëri. ");
INSERT INTO notNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Quero yareta canta tojai itingomipague yaca quibatsica, ira piniacaninataiguë, carari iraretaiguëma tojai ira pomaintaiguë yamai inguemisantaiguënanta. ");
INSERT INTO notNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Irooti cataguiteri ipocaiguë arosata bariseopague. Icantaigapëri Ira Jesos: —Pijáte basiniquë quibatsi. Icoguini Eroris irócagantimi. ");
INSERT INTO notNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Icantaigabaqueri Jesos: —Pijáigue, pingantaigueri ira matobiantatsiri: “Icanque Jesos: ‘Quero nisiga. Nojoquineri matsiguengapague igamagarite, aisati nogaguibegajiri janaitatsiripague; nanganquero negaca yamai, naramani; aisati arosata cataguiteri notsonguëro natarobacaare ora nipocasique yaca’ ”. ");
INSERT INTO notNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aro nanguenagueque yamai, naramani, aisati basini cataguiteri. Caninataque nangame Jerosarénquë aisa nangantaiguëmari ibegaiga comantantatsiripague jirai cara icamaiguë canta. ");
INSERT INTO notNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aisati icanque Jesos: —¡Jerosaresati, Jerosaresati, pógapinintaiguëri comantantatsiri, pibasiaqueri mopëquë ira igáquemi Tosorintsi! Aisa ocanta tiapa omisantaiguëri ojaniquite, ocábintsaiguëri, tojai nocogabeca nopatotaiguemime obirojegui, nanguemisantacagaiguemime, carari te pinintaigue pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pijitasitaiga Jerosarén caninaro, carari nojocanëmi Naro, aisati ijocanëmi Pabati Tosorintsi quero inomotajimi. Yamai nangantaiguëmi quero piniaigaina aisati irooti cara piniaigabaquina nopocaje aisati, nantingomibintaigapëmi, pingantocotaigabaquena: “Coraque Ira igáque Atingomi. Icaninatasanti Iriro”. ");
INSERT INTO notNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Basiniquë sábaro iáque Jesos irapë ibangoquë itingomi bariseo. Inetsaigaseguiri. ");
INSERT INTO notNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ainta cara paniro janaitatsiri, paniriabaguitachari yapaniriagueca omagaro. ");
INSERT INTO notNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aro Jesos yosamitëri bariseoegui aisati ira ogomeantiro isanguenare Moisés, icantaiguëri: —¿Caninataqueco agaguibegajiri janaitatsiri sábaroquë? ¿Queroco? ");
INSERT INTO notNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Imairetasantaiguë irirojegui. Aro yotsagaqueri paniriachari Jesos yogaguibegajiri, igáqueri iriátae. ");
INSERT INTO notNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Icantaiguëri bariseo Jesos: —Aroca sábaroquë imariaque omoroquë pitomi, ¿Queroco págairi omanapague? Imariaqueca pobaacate omoroquë, ¿Queroco págairi irooti sábaroquë? Quero poguei oquëtaguetanaita. ");
INSERT INTO notNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Imairetaiguë tiguetinta ingantima irotopitiri. ");
INSERT INTO notNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aro iniaiguëri Jesos ira igaimanejegui cara yoguibataigaca. Icogabeca irisobicaiguëme inganquima itingomi arota iraniacaninataigueri matsiguenga. Aro icantaiguëri Jesos, yosiacagantaiguëneri: ");
INSERT INTO notNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Cara ingaimëmica jiesitaquë cara iráquero iina sërari, quero pisobigui cara isobicaigui itingomipague tenta pigóte aroca iribocapë itingomi yabisanaquemi obiro. ");
INSERT INTO notNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aique ira cajemaquemi pitirooti obiro inganquemi: “Pingabiritima, pomeri ica nagaimaneca irasi irisobicomento. Pisobigue obiro cara”. Aro popasiquitanë, pijáque pisobiaque cara carantatsiriquë. ");
INSERT INTO notNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Carari cara ingaimëmi, pirequima, pijáte, pisobique carantatsiriquë. Aique, iribocasitëmi ira cajemaquemi, inganquemi: “Omana, nomatsiguenga, pisobigopë yaca itingomiquë”. Iraniaiguëmi igaimanejegui cara mesaquë, irogóiguëmi obiro itingomi. Aro pinganinatanë. ");
INSERT INTO notNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pairiraca quingachane caninari, irajiquima obatatsi, aro Tosorintsi iraguipasiguitëri, inganqueri carantatsiri. Aisati ira carantatsi, iraguibatasantëri iriro Tosorintsi, iraniacaninatëri imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aisati icanqueri Jesos ira cajemaqueri: —Cara pingaimaiguëri matsiguenga pobangoquë, popaagaiguëri catingaquë queroca chopiniquë, quero picaimiri irianti pamigotepague, querootisati pirentipague, querootisati pijitaneegui, querootisati pitimanamire casintaguetachari. Aroca popaaguëri, aro iriro pëgatajimine, irapajagajimi obiro. ");
INSERT INTO notNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Carari caninataque pingaimaigueri ira te irasintaguetima pairoraca, aisati ira camabocori, aisati ira carancara, aisati ira comarajari, omagaro cantacha negaca, ");
INSERT INTO notNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tiguetinta ingantaiguema iripëgatajimi irapajagajimi obiro. Carari aiquenta cara Tosorintsi iraganiataigairi antagaisati quemisantatsiri, iripëgatajimi, imaimi obiro cara picábintsanti yamai. ");
INSERT INTO notNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iquemaqueri Jesos paniro igaimane, icanque: —Inganinasëretë ira papërone pan cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Icanqueri Jesos quingabaguirentsiquë: —Ainta paniro sërari. Yobetsiquëro tojai perintsi, icaimagantaiguëri imatsiguenga iribocaigapë irapaiguë. ");
INSERT INTO notNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aroque pobetsicaca antagaisati. Igátabecari ironomire ingomantaguetaiguëri igaimane: “Moncaraca yamai; pobetsicaca omagaro; popogopë yamaica”. ");
INSERT INTO notNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Carari te ingogaigue iriáigue. Icanque paniro: “Irorai namanantë naguebatsite. Najáque yamai nanetsëro, caninaguiteroca. Pingantinari pobatorote: ‘Quero ipoqui’ ”. ");
INSERT INTO notNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Icanque basini: “Irirai namanantë nobaacate icarati 10. Yamai najátasiqueri naniantëmari iriroca caninari, aroca intarobacaaque caninasati. Pingantiri pobatorote: ‘Quero icanta ipoqui’ ”. ");
INSERT INTO notNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Icanque basini: “Irorai náguë najina; iroro quero niátaguëti”. ");
INSERT INTO notNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Aro ipigapaa ironomire, icomantapëri ibatorote: “Icanquena: ‘Quero niáti, quero napi’ ”. Aro iguisaneinca, igáqueri ironomire: “Omanapague pijáte, pinguenagueque poeboroquë, pomapëri yaca ira te irasintaguetima pairoraca, aisati ira camabocori, aisati carancara, aisati comarajari, omagaro cantacha nega”. ");
INSERT INTO notNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Aique iáque ironomire, icaimaguequeri, yamaigapëri tojai. Icampëri ibatorote: “Casintinari, nocomantëri, ipocaigapë tojai, carari terai otsatenguima mesa; tojaiquerai basini”. ");
INSERT INTO notNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aro icanqueri ironomire ibatorote: “Pijátaguete abatsipaguequë, pomaigapënari yaca irajagopëmaro nobango. ");
INSERT INTO notNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Carari, nanganquemi, quero yapi noperi paniro ira nacaimaigabitaca”. ");
INSERT INTO notNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Arosonori matsiguenga yoguiataiguëri Jesos cara abatsiquë. Yapisitaanaca, icantaiguëri: ");
INSERT INTO notNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Nigóti pinintaiguëri piri, piniro, pijina, pitomi, pirenti, pitsiro, omagaro. Aisati pininta obiati. Caninataque, carari pingogaiguëca piguiatina, caninataque pinintasantaiguena Naro. Queroca pinintasantina, tigueti pingantima pomeguima nogomere. ");
INSERT INTO notNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pairiraca nintatsi iraguiatanëna, imeguima nogomere, iranatanëro igorosite, quero icantanonta iriati. Queroca ipomirintsibentinaro pairoraca nongocaqueri, tigueti ingantima imeguima nogomere. ");
INSERT INTO notNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pairiraca cogatsi irobetsiquë oquibe pongotsi, ¿Teco irotsita inguengue ora opënatëma, irogócoitiri iguireguite aroca cotonguiboro iritsonguëro pongotsi? ");
INSERT INTO notNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aroca imarintëmaro, carari quero cotonguiboro quirequi, quero itsonguiro, iraegui netsërone pongotsi irisëronquimari casintaro. ");
INSERT INTO notNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ingantocotaiguëri: “Iriro yobetsicabitacaro pongotsi; tigueti ongantima iritsonguero”. ");
INSERT INTO notNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aintaca itingomi aisati isorarote icarati 10,000, igótocotobëri basini itingomi ipoque iriro aisati 20,000 isorarote iromanápëri, ¿Teco iritsita cajemaquerine ogótacagantatsiri, irogóontobagobëma inguengaiguëma aroca onganinatë iromanátaigabaqueri, iritsongaigabaqueri? ");
INSERT INTO notNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aroca inguengaiguëma quero yagobeiri, iragátaiguëri iragátane iritonguibotobëmari basini itingomi aisati isorarote icarati 20,000 irosomitobëri pairoraca ingoque arota quero yomanátiri, iripigaigaima caninasati. ");
INSERT INTO notNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Aisati picantaiga obirojegui. Aroca pingoque piguiatanëna, obitsita pinguengasantima ati ocanta omagaro ora pasinta. Pigótasantiro, aro pijocaiganaquero, piguiatasantaiganaquena. Queroca papabaquëajiro, tigueti pingantima pomeguima nogomere. ");
INSERT INTO notNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nococaqueri ira aguiatina quemisanquina inguemisantacaguiri basini matsiguenga irogometiri intime caninasati. Irianti cantaca patiari caninari. Queroca ijocanëro irasi, quero yoguiatina, quero icomeiti, quero icanti ora nococaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Irianti cantaro patiari cara omasangatanë ora cochotacaguiro, quero ocomeiti, ojoquero sotoquë ogatiquëngani. Aitica piguemita ora piquemanta pinguemisantiro ora nocomantëmi. ");
INSERT INTO notNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ipocasitaiguëri Jesos omagaro jorío coigotantatsiri quirequi, ipagantineri Iromasati. Aisati ipocasitaiguëri tojai cantaguetiro quimingari inguemisantaigapëri. ");
INSERT INTO notNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aisati ainta bariseoegui aisati iraegui ogomeantiro isanguenare Moisés iniaiguëri Jesos, icantobaca: —Icanque Jesos ora te onganinate. Yágacaninataiguëri cantaguetatsiri, itsibataigari yapëcoiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aique yosiacagantëneri Jesos, icantaiguëri: ");
INSERT INTO notNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Pinguengaiguëri paniro sërari obirojeguiquë yomisantaiguëri iroishate icarati 100. Aroca imiaquima paniro iroishate, ¿Queroco ijocanëri 99 cara quesiiquë, iriátë ingooqueri ira oisha ibiaga irooti cara iraniopairi? ");
INSERT INTO notNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cara iniopairi, icaninatë, iquiopairi, ");
INSERT INTO notNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ipigapaa ibangoquë, icaimaigapëri imatsiguenga aisati itimanamitane, icampëri: “Intsome anganinasëretanë; ipiaca noishate, nágairi aisati”. ");
INSERT INTO notNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nangantaiguëmi, aisa ocanta inganinasëretasantaiguë cara Jonogaguitequë cara inganquima yacaqueroca paniro cantaguetatsiri ijocajiro ora icantagueti te onganinate. Yabisaiganaqueri cara icaninabentaiguëri tojai matsiguenga caninari te ingantiro quimingari. ");
INSERT INTO notNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Aisati icantaiguëri Jesos: —Aiti basini quingabaguirentsi nosiacagantëmiro: ainta tsinane pasincari iguitso quirequi icarati 10. Aroca imiaquima paniro, ongooguetajiri. Ontsitinitanëca, oboquero michero, otarogasantëro pongotsi; ongooqueri irooti cara oniajiri, ágairi. ");
INSERT INTO notNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Cara págairi, ocaimaiguëri omatsiguenga aisati otimanamitane ocantaigabaqueri: “Intsome anganinasëretanë: ipiaca naguireguite, nágairi aitosati”. ");
INSERT INTO notNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nangantaiguëmi, aisa ocanta inganinabentaiguëri ironomire Tosorintsi irisaanganetsite cara inganquima yacaqueroca paniro cantaguetatsiri, ijocajiro ora icantagueti te onganinate. ");
INSERT INTO notNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aisati icanque Jesos: —Ainta sërari aisati pite itomi. ");
INSERT INTO notNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Icanqueri iriri itomi carantatsiri: “Pabati, pomena yamaica omagaro ora nasintajima naro cara pingamaqueca”. Aro ipaguetaiguëri pite itomi. ");
INSERT INTO notNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cara pabisanaque arosata cataguiteri, itomi carantatsiri yapatotëro antagaisati irasi, iáque canta jaanta basiniatiquë quibatsi, yáganëro iraisati. Canta, te intimopë caninasati; icantaguetiro pairoraca icoganonta, yaparaqueri iguireguite aisati basini yasintabeca. ");
INSERT INTO notNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cara itsonqueri omagaro, canta jaanta itasiataiguë matsiguenga. Aisati ira oboina sigachari itasegasantë. ");
INSERT INTO notNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aique iáque icooqueri matsiguenga timatsi canta, intarobacaaquineri. Ainta paniro, igáqueri ichacaratequë imaigueri iraperi ichanchoneegui. ");
INSERT INTO notNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aisati yapëro oboina ora otaqui iraperi chancho, te inguemina; icogabecaro basini; carari te imeri iriro iraperi. ");
INSERT INTO notNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Aique iquengasëretaca: “Ainta tojai tarobacaatineri apati. Cotonguiboro iraperi antagaisati, yapapinintaiguë te iritsonguero, carari naanti yaca nangamaqueni páguënanta natasegane. ");
INSERT INTO notNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Atsi nopiganajima apatiquë, nangampëri: ‘Pabati, nacantomotaguequeri Tosorintsi aisati obiro. ");
INSERT INTO notNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Teni ongomeite pijitina pitomi yamai tenta nanganinate. Pingantajina pomeraro, nantarobacaatimi pichacaratequë’ ”. ");
INSERT INTO notNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aito cara iparintaca iáque iririquë. Cara aintaquerai jaanta, terai iraretima, inebintobacari iriri, igótobëri, icantaneintëgotëri itomi, isigasitanacari itonguibotobacari, yabitsinacobëri. ");
INSERT INTO notNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Icampëri: “Pabati, nacantaguetomoqueri Tosorintsi aisati obiro tenta nanguemisantimi. Teni ongomeite pijitina pitomi yamai tenta nanganinate...” ");
INSERT INTO notNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Carari iriri igáqueri ironomire: “Omanapague, pomapëneri quitsagarintsi caninarisonori, pinguitsagatiri, poguineri aniyo ibatsapacoquë aisati sapato iguitiquë; ");
INSERT INTO notNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","aisati pomapëri itiomijani baaca aneri, póguineri. Intsome opaigue aisati intsome anganinasërebentiri notomi ");
INSERT INTO notNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","aroquenta ipigapaa. Najitabeca icamaqueni carari cantaca icaniatanaini. Ipiaca carari yamai naniajiri”. Iparintaigaca icaninasëretaiguë, yapaiguë. Përosati icanque Jesos: ");
INSERT INTO notNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Carari ainta itomi obatatsi cara ichacaratequë. Cara yaresërepa iquemaigapëri cara icántataiguë aisati icaninataiguë. ");
INSERT INTO notNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Icaimëri paniro ibimantaga, yosamitëri: “¿Pairo icaninabiritaiguë cara pongotsiquë?” ");
INSERT INTO notNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yotabitanëri: “Ipigapaa pirenti. Yógagantëneri itiomijani baaca aneri yapaiguë. Icaninatasantë piri aroquenta iniobairi itomi caninasati yaretaja”. ");
INSERT INTO notNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iguisanaca ireinti obatatsi, te iraninte ingue pongotsiquë. Carari iquemocoqueri iriri, isotocanë icanqueri: “Omana, notomi, pingapë. Pinganinabentobëri pirenti”. ");
INSERT INTO notNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Carari yotabitanëri, icanqueri: “Tojai osarini nacanquemiro pairoraca picocaquena, te nopëgatsatëmatimi. Carari te pomena naro paniro chibo nopaagaiguëri namigoteegui, nanganinatagaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Carari yamai ipocaji pitomi, yaparatasicari piguireguite itsoncaquero tsinanepague antagueantatsiri, págacaninatobëri póguëneri aneri baaca”. ");
INSERT INTO notNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Icanqueri iriri: “Notomi, përosati pinomoquina. Omagaro nasintagueta iroonti pasi aisati. ");
INSERT INTO notNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Carari caninataque anganinabentiri pirenti. Aisa ocantabeca icamaque, najitabeca quero naniajiri aisati. Carari aisa ocanta icaniatanai, naniajiri. Ipegabeca, yamai naniajiri aisati. Intsome anganinasërebentiri”. ");
INSERT INTO notNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aisati icantaiguëri irogomere Jesos: —Ainta sërari yasintaguetaro tojai. Aintasati iromeraro yomisantineri omagaro irasi ibatorote. Ipoque basini, icomantëgotëri iromeraro cara icositagarantëri casintari. ");
INSERT INTO notNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Icaimëri, yosamitëri: “¿Pairo ojita oca naquemocoquemi? ¿Aisonorico picositagarantëna? Yamai pobetsiquinaro pisanguenare, pomapënaro. Naninti naneiro ora picanque. Quero nanintacaguimi pintainaro pairoraca basini”. ");
INSERT INTO notNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aique iquianca iriro: “Irojoquena nobatorote; quero inintacaguina nantaineri aisati. ¿Pairo nanganque yamai? Te nasintsite nasiabaguite. Aisati nopasiquique cara nomanopiantëri imasitëna quirequi. ");
INSERT INTO notNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ajaa, nigóque ora nanganque. Aique cara irojoquena nobatorote, irágobëna basini ibangopaguequë”. ");
INSERT INTO notNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aro icaimaiguëri paniropague ira irebetiri ibatorote. Icanqueri paniro: “¿Ati icarati pirebetiri nobatorote”? ");
INSERT INTO notNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yotabitanëri: “Narebetëri tojai oguei aseitona, 100 irata”. Icanqueri: “Jeroca pisanguenare jirai. Yamaica pisanguenate cara pirebetiri 50 irata”. ");
INSERT INTO notNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aique icanqueri basini: “Obiro, ¿Ati icarati pirebetiri nobatorote”? Yotabitanëri: “Narebetëri tojai tirigo 100 cantiri”. Icanqueri: “Jeroca pisanguenare jirai. Yamaica pisanguenate cara pirebetiri tirigo 80 cantiri”. ");
INSERT INTO notNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aiquenta cara igóquero ibatorote ati ocanta iromeraro yamatobiqueri, icanque: “Te ongomeite cara yamatobiquina, carari igóti iráquero ora coguitiomotari”. Iraegui tsoengatsiri te inguemisantiri Tosorintsi, igótasantaiguë ati ongantima ingantacaqueri imatsiguenga ora icogui iriro. Yabisaiganaqueri quemisantatsiri tenta irogótasante; te inguengasëretima irobatiri basini. ");
INSERT INTO notNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yamai nangantaiguëmi obirojegui: aintaca piguireguite, pingábintsaigueri ira coguitiacha, pomitocotiri pomeri ora coguitiomotari. Iramigotenquimi, quero yomaguisantiro ora picanqueri. Aique cara pingamaqueca, pijocanëri piguireguite carari irágacaninatobëmi Tosorintsi cara Jonogaguitequë, pintiomotaiguëri caninasati ira picábintsaiguë cara pongotsiquë quero pitsonga. ");
INSERT INTO notNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ira cantatsi caninasati cara Tosorintsi ipëri arosata, aisati irantë caninasati cara imëri tojai. Carari ira matobiantatsi cara ipëri arosata, aisati iromatobiantanë cara imëri tojai. ");
INSERT INTO notNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Carari aroca pingositaguetaiguëro ora yasinta basini yaca quibatsica, aisati pabentaigaro ora pasinta obiro, ¿Pairiroco pëmiro ora caninaro quero pitsonga? Quero pairi. ");
INSERT INTO notNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aroca picositaiguëri iguireguite basini, ¿Pairo imabiritimi Tosorintsi pairoraca caninari, pasiati? ");
INSERT INTO notNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Aintaca ironomitaga, quero icanta iquemisantiri pite ibatorote. Iromaintëri paniro, iraninqueri basini. Aisa ocanta, aroca pingantineri Tosorintsi omagaro ora icocaquemi quero picantanonta obiati. Aroca pingoque pingantanontima obiati, quero pintineri Tosorintsi. Quero picantiro pite. Aroca pinintasantëri Tosorintsi, quero picogui popobotiri piguireguite. Aisati pinintirica piguireguite, quero piquemisantiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aro iquemaiguëri bariseo ora icanque Jesos. Isërontaigacari icogasantinta quirequi bariseoegui. ");
INSERT INTO notNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Icantaiguëri Jesos: —Pijitasitaiga caninari obiatiegui, aisati picogaiguë iraniacaninataiguemi matsiguenga, carari igóquemi Tosorintsi ora piquianca. Te inguenguema Tosorintsi aisa icanta iquengaiga matsiguenga. Ora icaninabentaiguë matsiguenga iniacaninatëro, iniaquero Tosorintsi te onganinatëmate. ");
INSERT INTO notNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jirai ocaninatë inguemisantiro matsiguenga ora isanguenatacaqueri Moisés Tosorintsi, aisati ora iquenguitsatacaqueri comantantatsiri jirai, carari yareca yamaica Joan baotisatantatsiri. Yamai Tosorintsi icocaqueri basiniati. Onganinatasantë yamai inguemisantaigueri Joan matsiguenga intingomintasantëmari Tosorintsi. Yamai icogasantaigui tojai matsiguenga cara iragabisaicotajiri Tosorintsi, inganaque iragáantanequë, intingomintaiguëmari. ");
INSERT INTO notNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Aiquenta omeganëma quibatsi aisati Jonogaguite carari quero opeguëmata isanguenare Moisés. Icogui Tosorintsi përosati ongantima arota pigóontimaro ati ongantima pintimaigue caninasati. ");
INSERT INTO notNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Aintaca sërari irojoquero iina, iráque basini iina, yaguimintacaro iinasonori ora ijoque jirai. Aisati pairiraca ágairone ora ijoque ojime, yaguimintacari ojime cara icantagueti ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Përosati icanque Jesos: —Ainta paniro sërari casintaguetachari, icanaque iguitsagare caninari, catamagorisonori aisati quiraaquisaamagori. Antagaisati cataguiteri icaimaguëri imatsiguenga icantaigui jiesita yapasantaiguë; te ongoguitiomotimari pairoraca. ");
INSERT INTO notNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Carari ainta basini sërari jitacha Irásaro, irojocaga cara omoroquë casintaguetachari. Iribatsasebaguitaga omagaro. ");
INSERT INTO notNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Icogabeca irapërome ora ongarataga yobariaque casintaguetachari. Te inguemima. Te iromitocotiri pairiraca; carari ipocasitaiguëri otsitipague itsotaguepëro iribatsagoro. ");
INSERT INTO notNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Aique icamaque Irásaro, yáganëri ironomire Tosorintsi cara ini Abaram caninaguiteroquë. Aisati icamaque casintaguetachari, itiaca igamaga. ");
INSERT INTO notNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Cara osobiquë itsipiriasantë isërequë, tojai iniacatsigatacaro. Aisati inetsë canta jaanta, iniaiguëri Abaram aisati Irásaro. ");
INSERT INTO notNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Icaimë, icanqueri: “Apa, Abaram, pingantaneintëgotina yaca; pigátiri Irásaro iragaapagotima ibatsapacoquë nijaquë iribocapëta yaca arota iragatsingatinaro nanine aroquenta natsipiriasantë yaca tsitsica”. ");
INSERT INTO notNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Carari yotabitanëri Abaram: “Notomi, pinguenguero ati ocanta jirai cara pitimabeca quibatsiquë. Pitimi caninasati te pairoraca coguitiomotimine. Irari Irásaro tojai itsipiriasantë jirai. Carari yamai icaninatasanti iriro yaca; obiro pitsipiriasantë canta. ");
INSERT INTO notNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aisati aiquero obiroquë aiti otarabi paraguitia játaque osobisonorinta arota pairiraca yaca quero yagobia iáti obiroquë. Querootisati pairiraca canta yagobia ipoqui yaca naroica”. ");
INSERT INTO notNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Icanqueri casintaguetabetachari: “Queroca ipoqui yaca, Apati Abaram, nomanaquemi pigátiri Irásaro cara ibangoquë apati. ");
INSERT INTO notNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Canta, ainta pabocorooti igue. Ingamanaaigapëri, inguemisantacagaiguëri igue Irásaro, imasiniatitaiguëma, arota quero ipocaigapë yaca cara natsipiriasantasegui”. ");
INSERT INTO notNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Icanqueri Abaram: “Aiti isanguenare Moisés aisati irasi comantantatsiri. Caninataque irinibataiguerota inguemisantirota imasiniatitima”. ");
INSERT INTO notNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yotabitanëri: “Quero, Apati Abaram; quero iquemisantiro Sanguenari, carari aroca iriátasitaiguëri camatsiri, inguemisantobëri iriro, ingantaiguëma yacaqueroca imasiniatitima”. ");
INSERT INTO notNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Carari icanqueri Abaram: “Queroca iquemisantiro Sanguenari, querootisati iquemisantobëri camatsiri ira cabiritajachane”. ");
INSERT INTO notNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aique icantaiguëri irogomere Jesos: —Nangantaiguëmi, përosati ini ira antaaqueri imatsiguenga ora te onganinate; carari Tosorintsi ingasitígatëri ira antaaquerine basini. ");
INSERT INTO notNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Caninataqueme ingamaque queroquerai intaguiri ira quemisanquina ora te onganinate, aisa onganquima iraguëshotiaquineri oquibe mopë itsonoquë, irojoqueri angaarequë ingamaque. ");
INSERT INTO notNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pigamema, quero pintaguiri basini ora te ongomeite. Aisati icanqueri Jesos: —Aintaca popiguemisantane icantaguetimi ora te onganinate, pingamanaairi. Aroca irojocajiro ora icantagueti te ongomeite, pijocajineri obiro, pomaguisantineri, quero piquengairo. ");
INSERT INTO notNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aitica patiro cataguiteri ingositëmi, inguisatsatëmi, pairoraca inganquemi, iragatsitapininqueroca tojai, aroca inganquemi: “Nacanquemi ora te ongomeite; iroro nogasëretaguëca. Nojocajiro quero nacantajimiro aisati; pijocajinaro obiro aisati”, aro pijocajineri, pingábintseri, quero piguisiri. ");
INSERT INTO notNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ira iragátane Jesos icantaiguëri Ira Atingomi: —Naquemisantabecari Tosorintsi, carari nocogaiguë pinguemisantasantacagaiguena. ");
INSERT INTO notNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Icanqueri Atingomi: —Pinguemisanqueca arosata, pomaniri Tosorintsi pingantiri irisiabonguititiro ora anchatora, iragaratianquero cara angaarequë, aro inganquemiro. ");
INSERT INTO notNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aisati icantaiguëri irogomere Jesos: —Quero piquenga obiatiegui caninari. Aintaca pomeraro isiabaguitë queroca yomisantimiri pobira, cara iripigaima pobangoquë, ¿Pairo pinganqueri? ¿Pinganquerimeco: “Pingapë omanapague, pisobigopë pope”? ");
INSERT INTO notNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Quero picantiri negaca. Pinganqueri: “Pobetsiquima, pingotina noperi aisati nomire, pomapënaro. Notsonqueroca naro, aro pope obiro, póguima aisati”. ");
INSERT INTO notNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Quero picarasiatiri pomeraro aroquenta icanquero ora picanqueri. ");
INSERT INTO notNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aisati obirojegui picantaigari ibega pomeraro. Cara pitsonguëro antagaisati ora icocagaiguëmi Tosorintsi, caninataque pingantaigue: “Patiro nacanquineri Tosorintsi ora icocaquena. Te inëmate ora nanguenguema naro caninari, naanti iromeraro”. ");
INSERT INTO notNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aisati yogaganaa Jesos, iáque aiquero Jersarénquë, iquenaque Samariaquë aisati Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Cara yarecaro poeboro, itonguibocari sërari iribatsasetaga icarati 10. Yaratingaiguë arosata casiriconiati, te irotsititimari Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Icaimaigabaqueri: —Jesos Ogomeantatsiri, pingantaneintëgotaiguena, pigabisaicotaiguena. ");
INSERT INTO notNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aro iniaiguëri Jesos, icantaiguëri: —Pijátasitaigueri saseriroti, poniagaiguemari. Aique iáiguë. Cara abatsiquë aito ca ibegaiganaja. ");
INSERT INTO notNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aro ainta paniro iribatsasetabitaga, cara igóque aroque ibeganaa, ipigapaa, icaimanë catsigue, “Icaninati Tosorintsi yogaguibegajinanta”. ");
INSERT INTO notNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yobaticagueritotasipari iguitiquë Jesos, yaquitomoca, icarasiapëri Ira Jesos. Irianti Samariasati, ipaniaca Samariaquë jirai. ");
INSERT INTO notNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aique icanque Jesos: —¿Teco ingarate 10 iribatsasetaga ira nogaguibegaji? ¿Atini ira basini 9? ");
INSERT INTO notNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Icari ica cagari jorío, irianti basiniati matsiguenga. ¿Paniroco ica ipigapa inibacaninatëgotëri Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aique icanqueri iribatsasetabitaga: —Pingabiritima, pijátaje yamai. Aroquenta piquemisanquina, iroro nogabisaicotaguëtajimi. ");
INSERT INTO notNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aique yosamitaiguëri Jesos bariseoegui: —¿Ati ongantima orequima iragáantane Tosorintsi? Yotabitaiganaqueri Jesos: —Cara intingomibintëri matsiguenga Tosorintsi, quero pineiro tenta oneingani. ");
INSERT INTO notNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Quero pairi cantatsi: “Iroro oca”, querootisati, “Iroro ora”. Aisonori quero oconijati carari aiti obirojeguiquë. Paniro itingomibintiri Tosorintsi ira quemisanqueri. ");
INSERT INTO notNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aique Jesos icantaiguëri irogomere: —Naro paniënguicha cara Jonogaguitequë nomatsiguengatapë. Quero natsibatimi përosati aiquenta nojocaiganaquemi. Coraque opoque cara pingogaigabitëma piniaigaina patiro cataguiteri basini, carari quero pineina. ");
INSERT INTO notNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aintaca inganquemi: “Ainta Quirisito cara”, aintasati cantëmine: “Ainta yaca”, quero poguiatiri, quero pitsipiriasita piáti cagarinanta Naro. ");
INSERT INTO notNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cara omabocapë tegotsitanatsi moretatsiri, osangueguitetanëro omagaro jonoquë, aisati nangampaima Naro cara nopogopae quibatsica. Nomabocaigapairi matsiguenga, carari iraniaigabaquina antagaisati. ");
INSERT INTO notNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Carari queroquerai nipocaji, Natsita atsipiriaquenguitsine tojai aronta iritsoengaigabaquina icaegui matsiguengaca, inguisaigabaquina. ");
INSERT INTO notNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aisa ocanta jirai cara itimi Noé, itsoingaiguëri Tosorintsi matsiguenga, aisa onganquima cara nopigaima Naro, iritsoengaiguëna omagaro matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cara Noé icamanaaiguëri, ira matsiguenga përosati icantaiga cara yametaiga: yapaiguë, yógaigaca, yágaiguëro iina, yágantacagaiguëro irisinto, përosati icantaiga irooti cara yotetanacaro pitotsi Noé. Aique opariaque oquibeguintesonori angani, ponangasantaca, ongaaretanë omagaro, pipoguiriaiguëri antagaisati tsoengatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aisati icantaiga matsiguenga cara itimi Lot, yapaiguë, yógaigaca, yamanantaiguëro pairoraca, ipimantaiguëro, ipanguitaiguë ibanguire, yobetsicaiguëro pongotsipague, ");
INSERT INTO notNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","carari cara isotocanë Lot cara Soromaquë, irooti cataguiteri Tosorintsi yobariaquineri tsitsi oconogaro asopiri paniacha jonoquë, pipoguiriaiguëri antagaisati Soromasati. ");
INSERT INTO notNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aisa ingantaiguëma matsiguenga cara nopocaje Naro. Iritsoengaiguëna tojaisonori, quero iquengaiguiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aisati cara omoncaraquema cataguiteri cara nopocaje, aintaca paniro jonoica ibangoquë, quero iqui cara iráganëro ora yasinta; aintaca paniro iritoganequë, quero ipigaa ibangoquë. Irisiganëmata. ");
INSERT INTO notNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pinguengaiguero iina Lot, opeganaca patiari cara papisitaanaca. ");
INSERT INTO notNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pairiraca cogabitacha ingábintsëma yaca quibatsica tenta iraninte iratsipiriero, quero iáti Jonogaguitequë, iratsipiriasantëma. Irari quemisantasantënane yaca quibatsica, irooti cara ingamobiquina Naro, aiquenta intiomoquina Jonogaguitequë, intimasantapë caninasati. ");
INSERT INTO notNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yamai nangantaiguëmi: cara nopocaje, intsibatëmari pite sërari irisomë irooti somamintotsiquë. Paniro náganë, ira basini nojocanëri. ");
INSERT INTO notNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Otonongasegueca tirigo pite tsinane; paniro náganë, ora basini nojocanëro. ");
INSERT INTO notNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Irisiabaguetasegueca pite sërari cara togantsiquë. Paniro náganë, irari basini nojocanëri. ");
INSERT INTO notNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yosamitaiguëri irogomere: —Natingomi, ¿Nega onganquima negaca? Icantaiguëri Jesos: —Atiraca ini igamaga, aito cara imarigasipëri tisoegui. Aisa ocanta, atiraca itimi tsoengatsiri, iratsipiriacagaiguëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aisati basiniquë cataguiteri Jesos yogometaiguëri irogomere quingabaguirentsiquë. Icantaiguëri caninataque iromanopiantiri Tosorintsi, quero itsirisharo. ");
INSERT INTO notNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yosiacagantëneri quingabaguirentsi, icantaiguëri: —Ainta poeboroquë ira joes ira te iminguiri Tosorintsi, teatisati ingantaneintëgotiri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aisati ainta irootiquë poeboro tsinane ogamaimentaga. Piátasitopiantëri joes, ocantopiantabitacari: “Pingábintsena pomitocotina; popëgabentina ira quisaneinquina”. ");
INSERT INTO notNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Iritsita te iraninte ingábintsero, carari piátasitopiantëri. Aiquenta iquianca: “Aisonori te nominguiri Tosorintsi teatisati nangábintseri matsiguenga, ");
INSERT INTO notNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","carari paserigapininquina oca tsinaneca. Iroro nomitocotaguëquero, nangábintsëro arota quero pipocasitopiantaina paserigaina aisati”. ");
INSERT INTO notNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Icanque Atingomi: —Pinguengueri ira joes te inganinate, ora icanque. Ipëgabenquero tsinane ogamaimentaga. ");
INSERT INTO notNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Irianti Tosorintsi icaninati. Yamai përosati yamanopiantaiguëri quemisantatsiri, ¿Teco inguemaigueri cara iripëgabintaiguëri? ");
INSERT INTO notNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nangantaiguëmi, quero ocosamaniti cara ingábintsaiguëri iripëgabintaiguëri. Carari cara nopigaima yaca quibatsica, ¿Aroco naniaigapëri quemisantaiguënane iromanocotaiguëri Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aisati Jesos yosiacagantaiguëneri matsiguenga yoguibataiga, iquengaigaca iriati caninari, imaintaiguëri basini. Jesos inibataiguëri oca quingabaguirentsica: ");
INSERT INTO notNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Iáiguë pite sërari cara oquibequë ibango Tosorintsi, yamanaigapë. Paniro ini bariseo, ira basini irianti coigotantatsiri, icoicotaiguëri iguireguite imatsiguenga, ipagantiri igobeingarite Iromaquë. ");
INSERT INTO notNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yaratingopë bariseo, yamanopë icanque negaca: “Tosorintsi, nacarasiaquemini cara te aisa nangantimari ibega basini sërari. Tojai nacaninati naro; te nangantaguete, te aisa nangantimari cosirinti, te nomatobite, te naguimintimaro najina. Teatisati nangantimari ibega ica coigotantatsirica. ");
INSERT INTO notNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nameta omagaro ironisiquë nitita, aisati joebisiquë, te nope, iroonti naquenguimi Obiro. Aisati nopagarantimiro omagaro nágagueti. Náguëca 10, nopabaquemi patiro”. ");
INSERT INTO notNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ira coigotantatsiri yaratingopë cara omoroquë pënibaque te ingue. Te iraniacaninatima iriati; ipasiquique, te iranetse jonoquë, yoguica icanque: “Tosorintsi, pingantaneintëgotina naronta cantagueantatsiri, tenta nanganinate”. ");
INSERT INTO notNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yamai nangantaiguëmi, tojai icantagueti ira coigotantatsiri, carari icábintsëri Tosorintsi, yogabisaicotajiri. Cara ipiganaja ibangoquë, aroque igónijinca iriati cara iniacaninatëri Tosorintsi. Irari bariseo te iraniacaninatiri iriro Tosorintsi, te iragabisaicotiri. Pairiraca quingachane caninari, irajiquima obatatsi, aro Tosorintsi iraguipasiguitëri, inganqueri carantatsiri. Irari carantatsi, te irajitima caninari iriati, Tosorintsi iraguibatasantëri iriro. ");
INSERT INTO notNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aique yamapëngani tsorori janequipague cara Jesosiquë, icogaiguë cara irogaguetineri ibaco Jesos iguitopaguequë janequi, iromanocotiri cara ingábintseri Tosorintsi. Iniaigabaqueri irogomere, imetaigacari Jesos, icantaigabaqueri: —Quero paseriguiri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Carari icaimaiguëri Jesos: —Quero picantiri. Nocoguini iribocasitaigapëna janequijegui. Igóiguë iriro intingomintina. Antagaisati icantaigari ibega ica intiomoquina cara iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aisonori nangantaiguëmi: icaegui janequica inintaiguë intingomintimari Tosorintsi; pairiraca te aisati ingantima ibega janequi, quero pareta cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Basini cataguiteriquë iátasiqueri Jesos paniro itingomi jorío. Icampëri: —Caninari ogomeantatsiri, pingomantina: ¿Pairo nanganque arota nantimaque përosati canta Jonogaguitequë? ");
INSERT INTO notNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yotabitanëri Jesos: —¿Pairo picantobiquina Naro caninari? Paniro ini caninari, Irianti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pigótiro ora iragáantane Tosorintsi ora ipëri Moisés: quero pintiro tsinane cagaro pijina; quero póganti; quero picositanti; quero pitsoiguëgotaguetari ira basinipague; pinguemisantiri aisati pinintiri piri aisati piniro quero pipëgatsatëmatari. ");
INSERT INTO notNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Icanqueri sërari: —Aroque naquemisanquero omagaro oca, nomoncaraquero cara ninë janequi irooti yamai. ");
INSERT INTO notNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iquemaqueri Jesos, icanqueri: —Panibati. Pinintica iraniacaninatimi Tosorintsi, atsi pijáte pomimantiro antagaisati ora pasinta, pomaguetiri ira coguitiaguetachari omagaro opënataga; aique imëmi Tosorintsi ora caninaro cara Jonogaguitequë. Cara pomimantëroca antagaisati, aro piguiatanëna Naro. ");
INSERT INTO notNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cara iquemobëro oca, yogasëretasantanaca irironta casintaguetasantacha, aique iáque tenta iraninte imimantiro. ");
INSERT INTO notNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iniobëri Jesos, icanque: —¡Opomirintsitomocari casintaguetachari iriátë canta itingomibintanti Tosorintsi! ");
INSERT INTO notNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nanganquemi: opomirintsitomocari cameyo ingue otiomijaniquë omoro quitsapi, carari omomirintsitomotasantëmari casintachari iriátë cara igáanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iraegui quemaiguëri yosamitëri: —¿Aisonorico? ¿Pairo inganquima matsiguenga ora iragabisaicoontëma? ");
INSERT INTO notNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Carari yotabitaiganaqueri Jesos: —Quero icantiro matsiguenga yogabisaicota iriati, carari Irianti Tosorintsi inganquero antagaisati. Te omomirintsitomotimari Iriro. ");
INSERT INTO notNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aique icanque Peroro: —Ogometinari, pinguengaiguena naroegui. Nojocaiganaquero omagaro ora nasintaiga, noguiataiganaquemi. ");
INSERT INTO notNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Icanqueri Jesos: —Aisonori nangantaiguëmi: quero pitsipiriaro. Aroca pintingomintimari Tosorintsi, pijocaiguëro pobango, pijina, pirentipague, piri, piniro, pitomipague, pisintopague, ingantocobentaiguëmi Tosorintsi. Aroca pingogasantë intingomibintimi Iriro, iroro pijocaguëquero pairorapagueraca, quero pitsipiriaro. ");
INSERT INTO notNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Aroca pijocanëneri arosata yamai, imaiguëmi tojai yaca quibatsica. Aisati irágaiganaquemi canta Jonogaguitequë pintiomoqueri përosati. ");
INSERT INTO notNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Aique icaimaiguëri irogomere casiriconiati icantaiguëri: —Yamai ajáiguë canta Jerosarénquë. Jirai isanguenatocotaiguëna comantantatsiripague, Naro paniacha Jonogaguitequë nomatsiguengatapë. Yamai omoncaraquima omagaro isanguentocotaiguëna. ");
INSERT INTO notNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ira joríojegui irácagantaiguëna ira basiniati matsiguenga cagari jorío irágobëna. Irisërontaiguëna, iratsipiriacagaiguëna, irijobataiguëna. ");
INSERT INTO notNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aisati iripasataiguëna, aique irógaiguëna. Carari ongaraque maba cataguiteri nanganiatanae aisati. ");
INSERT INTO notNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Te irogóigue irogomere ora icomantëri Jesos tenta inguemaigueri; icomëtaigabacaro. ");
INSERT INTO notNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cara pënibaque irarepëmaro Jericó, Jesos iniopëri comarajari onamiquë abatsi yamanopiantëri matsiguenga imaigueri quirequi. ");
INSERT INTO notNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Iquemaigabaqueri tojai matsiguenga yabisaiganaque, aro yosamitë: —¿Pairi bocatsi? ");
INSERT INTO notNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Icomantaiguëri: —Coraque Jesos Nasaresati. Irabisanaque yaca. ");
INSERT INTO notNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aique icaibatanë comarajari, icanque: —¡Jesos, Obiro imatsiguenga David, pingantaneintëgotina! ");
INSERT INTO notNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iraegui obaqueri Jesos isintsitsataiguëri icantaiguëri: —¡Pomairete! Carari aiquero iátanëtigue icaimasantanë comarajari: —¡Jesos, imatsiguenga David, pingantaneintëgotina! ");
INSERT INTO notNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yaratingopë Jesos, icaimagantëri; cara yarepa, icampëri: ");
INSERT INTO notNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Pairo picogui nanganquemi? Icanqueri: —Natingomi, nanintini piniacagajina. ");
INSERT INTO notNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Icanëri Jesos: —Aro piniaje yamaica. Aroquenta piquemisanquina nagobiajiro cara piniaje aisati, aro naniacagajimi, nogabisaicotajimi. ");
INSERT INTO notNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aito cara inianai, yoguiatëri Ira Jesos, icaninabenqueri Tosorintsi, icanque: —Iniacagajina Tosorintsi; icaninati Iriro. Aisati icanta omagaro matsiguenga iniaiguëri, icanque: —Aisonori, icaninati Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Aique yarepa Jesos Jericóquë iquenaguequero. ");
INSERT INTO notNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ainta ira casintaguetachari jitacha Saqueo, itingomi coigotantatsiripague, icoicotaiguëri iguireguite imatsiguenga ipagantaiguineri igobeingarite Iromasati. ");
INSERT INTO notNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Icogabeca Saqueo iraneiri Jesos, carari te iraneiri iriantinta catsitiini. ");
INSERT INTO notNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Isiganaca ibataiguëri basini matsiguenga tojai, itanë anchatoquë ora jitacha sicómoro arota iraneiri Jesos cara inguenopë. ");
INSERT INTO notNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cara yarepa Jesos, inetsë jonoquë iniopëri Saqueo, icampëri: —Saqueo, piguëpë omanapague. Yamai nocogui nantiomoquemi pobangoquë. ");
INSERT INTO notNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aro yaguëpë omanapague, icanqueri: —Intsome nobangoquë. Aro tojai icaninatanë Saqueo, ");
INSERT INTO notNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","carari iniaiguëri imatsiguenga, yabentaiganaca iguisaneintaiguëri icantobaganaca: —¿Pairo iátasibiriqueri Jesos cara ibangoquë Saqueo tenta inganinate? Icantaguetasanti. ");
INSERT INTO notNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aique yaratianque Saqueo icanqueri Jesos: —Natingomi, nomagarantaguetaiguëri coguitiachari aganguisati antagaisati ora nasinta. Aisati aintaca matsiguenga namatobiqueri nocositëri, naguipigaineri omagaro, aisati nomëri basini. Nocositërica patiro, aro nomairi otsibasati. ");
INSERT INTO notNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Icanqueri Jesos: —Yamaica cataguiteri Tosorintsi yogabisaicotajimi obiro aisati iragabisaicotajiri pomatsiguenga yaca pongotsica. Aisatinta picantari ibega Abaram: piquemisanquero nanibare. ");
INSERT INTO notNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iroro nipocasique, nopaniaca Jonogaguitequë nomatsiguengatapë. Nipocasique nongooque nagabisaicotajiri pairiraca quemisanquinane, ira terai irogótiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ira matsiguenga iquemaiguëri Jesos ora icanqueri Saqueo, yosiacagantëneri quingabaguirentsi aroquenta yareca aronisati Jerosarénquë aisati yoguiaiguëri matsiguenga cara omanapague intingomibintaiguëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aro icantococa Jesos: —Ainta paniro sërari caninari imatsiguenga itingomi, iriátë cosamani parigoti basiniquë quibatsi imeganëma itingomi iriati, aique iripigaima intingomibintaiguëri imatsiguenga iboeborotequë. ");
INSERT INTO notNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Teraiquerai iriáte icaimaiguëri iromeraro icarati 10, ipaguetaiguëri panirootipague paniro iguibe quirequi. Icantaiguëri: “Jerica tojai naguireguite, nomirisitatimiri. Pomanantantimari, pomimante, pomitojaiguenari irooti cara nopigaima”. Aique iáque imeganëma itingomi. ");
INSERT INTO notNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Carari aintapague imatsiguenga te intingomintimari, iguisaneintaigacari, igáqueri sërari iáque icantabepari ira cobeingari: “Teni nanintaigueri ira sërarira intingomibintaiguena naroegui. Quero poguiri natingomiegui”. ");
INSERT INTO notNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Carari ijiqueri itingomi; aique ipigapaa, icaimagantaiguëri iromeraro ira ipaguetaiganaque iguireguite. Yosamitëri panirootipague: “¿Pomitojaiguënari naguireguite?” ");
INSERT INTO notNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aro ipoque ira obaquenguitsi icampëri: “Natingomi, nomitojaiguëmiri piguireguite. Popanaquina paniro. Yamai ainta 10 basini”. ");
INSERT INTO notNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Icanqueri itingomi: “Caninataque. Picanque caninasati ora nococaquemi. Cani nopëmi arosata. Yamai nomëmi 10 poeboro pintingomibintaiguenari matsiguenga cara”. ");
INSERT INTO notNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aique ipoque basini iromeraro icanqueri: “Natingomi, nomitojaiguëmiri piguireguite. Popanaquina paniro; yamai ainta basini pabocorooti”. ");
INSERT INTO notNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Icanqueri: “Caninataque. Pintingomibintaiguenari matsiguenga timaigatsi pabocorooti poeboroquë”. ");
INSERT INTO notNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Aique ipoque basini iromeraro icanqueri: “Natingomi, jerica piguireguite. Noguëmiri caninasati noponatëri nobaaniotequë. ");
INSERT INTO notNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nacanque negaca notsoroquemi nigóquiminta obiro te pingábintsante. Najique aroca nomitojaiguerime piguireguite, págabitsaquinari omagaro. Nigóquimi pobiguiti cara te pomanguite”. ");
INSERT INTO notNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aique yotabitanëri: “Te pinganinate; te pingantiro ora nocacagabequimi. Picantabeca te nangábintsante; nágabitsaquimiri omagaro; nobiguiti cara te nomanguite. Pigótabecaro oca, iroro naguisaneintaguëquimi. ");
INSERT INTO notNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Pairo te pogobitiri naguireguite cara omisantiririquë quirequi? Poguërime cara, aintame yamai aisati basini quirequi imaiguëname ira omisantiriri”. ");
INSERT INTO notNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aique icanqueri ira quemaiguëri: “Págabitsatiri naguireguite, pomeri ira omisantënari 10 quirequi”. ");
INSERT INTO notNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Icantaiguëri: “Carari, Natingomi, aroque ainta tojai iguireguite”. ");
INSERT INTO notNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nangantaiguëmi: pairiraca inomoque tojai, imëngani basini, carari ira te irasintasantima, ira arosata inomotiri irágopitënganiri. Aisa ocanta Irinibare Tosorintsi. Aroca pinguenguero pigótasantëro, oganinasëretëmi. Carari aintaca cantatsi: “Nigóquero antagaisati”, irari ira te ingogue inguemisantina, quero iquemina. Nágabitsaqueri ora iquemabeca, iromaguisanquero. ");
INSERT INTO notNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aisati icanque itingomi: “Yamai, iraegui quisaiguina, te iraninte intingomintina, pomaigapënari yaca pigamagaigueri catingasatiquë naro”. ");
INSERT INTO notNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cara itsonquero quingabaguirentsi Jesos, yogaganaca itonganaque aiquero Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cara pënibaque irarequimaro pite poeboro ora jitacha Betatajé aisati Betania, ora poeboro pini aronisatiquë oguitaja jitacha Olibos, igáqueri pite irogomere, ");
INSERT INTO notNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","icantaiguëri: —Pijáigue catingasati poeboroquë. Cara pinganaque, piniopëri itiomijani boro itsatocotaga. Teraiquerai ingueicotingani. Pintsaicotiri pomapëri yaca. ");
INSERT INTO notNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aintaca matsiguenga irosomitobëmica: “¿Pairo pitsaicobiritiri boro?” aro pinganëri: “Icoguirini Atingomi”. ");
INSERT INTO notNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aique iáiguë iragátane, iniaiguëri aisa ocanta cara icanqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cara itsaicosiguiri, ainta casintari yosamitaigabaqueri: —¿Pairo pitsaicobiritaiguëri noborone? ");
INSERT INTO notNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yotabitaiganaqueri: —Icoguirini Atingomi. —Aro páganëneri. ");
INSERT INTO notNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aro yágaiganaquineri Jesos, yoguëneri iguitsagarepague imiticaraquë boro itiomijani, aro iqueicotanacari Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Negaraca cara inguenaque Iriro, ira matsiguenga yogaguetaiguëneri iguitsagarepague cara abatsiquë arota iragaticanëro boro. ");
INSERT INTO notNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cara iparintaca yanonganaca oguitoja Olibos yoguiataiguëri tojai irogomere. Icaninabentaiguëri icaimaiguë, icantaiguë: —Tojai icaninatasanti Tosorintsi. Tojai naniaiguëro cara itasongobentopiantacái. ");
INSERT INTO notNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ainta Agabisaicoontatsiri. Intsome antingomintobëmari. Intsome aniacaninatobëri. Igáqueri Tosorintsi aroquenta iniacaninatëri Iriro. Caninasati itimi omagaro Jonogaguitesati. Caninari Tosorintsi jonoquënintaberi. ");
INSERT INTO notNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aintasati bariseopague itsibataigari arosonori matsiguenga aguiataiguëri Jesos. Icantaiguë bariseo: —Ogomeantatsiri, piguimairentaigueri matsiguenga ira aguiataiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yotabitaiganaqueri Jesos: —¿Pairo naguimairentobitiri? Caninataque inganinabentaiguena. Iromairetaiguëca irirojegui, Tosorintsi irinibatacaquero mopëpague ontingominquina. ");
INSERT INTO notNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cara pënibaque irarequimaro Jerosarén, Jesos iraicotaiguëri Jerosaresati, icanque: ");
INSERT INTO notNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Yamai nipocasitaigabitëmi. Tojai nocogabeca nantimacagaiguemime caninasati, nagabisaicotaiguemime arota quero iguisaiguimi Tosorintsi, carari te pinintaiguena obirojegui. Pitsoingaigabaquina, yamaica quero pineina nantingomibintaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aiquenta orequima cataguiteri cara ira quisaiguëmine irishongaigapëmi, iroticaiguëmi arota quero pisigaiga, iratsipiriacagaigapëmi, ");
INSERT INTO notNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","irógaigapëmi obirojegui aisati pijaniquite, irogomeriguetëro omagaro pongotsiegui, quero pini yaca pite mopë otsibatobagaja. Ingantaigapëmiro negaca aroquenta nipocasitaigabitëmi, nantingomibintaiguemime, carari te pinguemisantina, te pintingomintaiguena, iroonti pitsoingaiguëna. Iroro aiquenta Tosorintsi iragátaiguëmi tojai soraro iripoguiriaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aique iáque Jesos cara oquibequë ibango Tosorintsi, icanaque, iniaigapëri iraegui pimantaguetatsi aisati manantatsiri, iguisaigapëri ijocaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Icantaiguëri: —Aiti osanguenata jirai, icanque Tosorintsi: Nocogasanti pomanocotaiguena yaca nobangoquë. Carari obirojegui te pomanocotiri, iroonti picositapinintaigabaqueri ira bocaigatsi iromanocotaigapëri Tosorintsi. Aro itsonque ijocaiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Antagaisati cataguiteri yogomeanti Jesos cara ibangoquë Tosorintsi. Carari iguisaneintaiguëri itingomipague saserirotijegui aisati ira ogomeantiro isanguenare Moisés aisati obatatsiri, yosaminatobaganaca: —¿Atiroco anganqueri Jesos, agamagaiguëri? ");
INSERT INTO notNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Carari te irogóigue atiraca inganqueri arosonorinta matsiguenga aguiataiguëri, iquemisantaiguëri itingomintaigacari. ");
INSERT INTO notNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Patiro cataguiteri yogomeanti Jesos cara oquibequë pongotsi irasi Tosorintsi. Cara icomantaigaseguiri matsiguenga atiraca ingantima iragabisaicotaiguëri Tosorintsi, ipocasitaiguëri itingomipague saseriroti aisati ira ogomeantiro isanguenare Moisés aisati antiasipari, ");
INSERT INTO notNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Icantaigapëri: —Pingomantaiguena: ¿Pairiraca agáquemi cara pijocaiguëri pimantatsiri? ¿Pairi oguëmi obiro cara pijica itingomi? ");
INSERT INTO notNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yotabitaiguëri Jesos: —Aisati Naro, patiro nosamitaiguëmi. Pingomantina Naro: ");
INSERT INTO notNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pairi agáqueri Joan cara ibaotisataiguëri tojai omatsiguenga? ¿Iriroco agáqueri Tosorintsi? ¿Iraco agáqueri matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Icantobagaiganaca jorío: —Anganquerica: “Igáqueri Tosorintsi”, aro ingancái: “¿Pairo te pinguemisantobitaigueri Joan?” ");
INSERT INTO notNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Carari aroca anganqueri: “Igáqueri matsiguenga”, aro inguisaigacái icaegui omatsiguengaca, iribasegaigacái mopëquë ijitaiguënta cara igáqueri Joan Tosorintsi ingomantagueantë. ");
INSERT INTO notNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aro yotabitaiguëri: —Teni nogóigue pairi agáqueri. ");
INSERT INTO notNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aique icantaiguëri Jesos: —Aisa Naro, quero nocomantaiguimi pairiraca agáquina nangantagueantë ocapague piniaiguëca. ");
INSERT INTO notNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aisati iparintaca Jesos iquenguitsataiguëri matsiguenga. Yosiacagantëneri icantaiguëri: —Ainta sërari panguiquero obasi, yogaiguëri omisantinerine irobasite. Iquengaigaca cara onguitsotanëca, ira omisantineri iráquero aganguisati oba, imagantëri casintaro aganguisati. Aique iáque jaanta itimaque cosamani. ");
INSERT INTO notNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cara omoncaraca cara oracanë oguitso oba, igátabecari iromeraro icanqueri: “Pijáte, pingampëri ira omisantinaro nobasite imagantaiguenaro nasiati”. Carari ira omisantiro yágaigabaqueri ipasataigabaqueri. Yoguipiguëri, te imëmatiri oba. ");
INSERT INTO notNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aique igátabecari basini iromeraro. Iriro aisati ipasataigabaqueri icantaguetobëri ora catsimaro, yoguipiguëri. Teatisati imaigueri oba. ");
INSERT INTO notNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ira casintaro obasi igátabecari basini iromeraro. Yágaigabaqueri yámasitaigabaqueri ijocaiguëri sotoquë obasi. ");
INSERT INTO notNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aique iquianca casintaro obasi, icanque: “¿Pairo nanganque yamai? Ajaa, nigóti. Nagáqueri notomi, ira nanintasanti. Irirojengari iraniacaninataigabaque”. Aro igáqueri itomi. ");
INSERT INTO notNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ira omisantineri irobasite iniaigabaqueri itomi, inibatobaca: “Irironta itomi casintaro. Cara ingamaquenica iriri, iriroquerai ágairone obasi. Intsome ógaigabaqueri, águirota obasi asintaiguemaro eiroquerai”. ");
INSERT INTO notNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aro yágaigabaqueri, yáganëri sotoquë obasi, yogamagaigabaqueri. Yamai, ¿Pairo pijique inganqueri ira casintaro? ¿Pairo ingantaiguëri ira catsimari? ");
INSERT INTO notNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","¿Teco iriátë iriro, inguisasantaiguëri omisantiro irobasite, iripoguiriaiguëri? Aique irogaiguëri basini caninari ira omisantainerine irobasite. Aro icantaiguë ira quemaiguëri: —¡Querota pini negaca! ");
INSERT INTO notNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Inetsaiguëri Jesos, icantaiguëri: —¿Pijitabeca quero pabisi? ¿Pairoroco ocanti Sanguenari cantatsi: Jirai itsoingaiguëro mopë ira obetsiquirori mopëpongo, ijoquero tenta irogóiguero cara icoiguëro Tosorintsi iroonti otingomi mopë, otingomi pongotsi, cantaca otingomipoa pongotsi? ");
INSERT INTO notNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pairiraca pariaquenguitsine yaca mopëca ocaraaque itongui; pairiraca otsinaque oca mopëca obichaqueri onganqueri pojongabatsari. Naanti osigaro mopë otingomi nacantocotaiguëmiro; queroca pigótina, pitsipiriaque; queroca piquemisantina, pijáque Sharincabeniquë. Pairiraca comëtobënane, iripoguiriaquengani. ");
INSERT INTO notNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aro iquemaigabaqueri Ira Jesos ogomeantiro isanguenare Moisés aisati itingomipague saseriroti, icogaigabitaca irácagantërime igóiguënta cara Jesos iquenguitsatocotaiguiri irirojegui carari te iráguiri itsorogaiguërinta matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Iroro ora inetsaguëqueri jorío ira Jesos, aisati igátaiguëri sërari icanqueri: —Pijáigue, pomatobitiri Ira Jesos. Pingantomemegapëma cara pingoguirome pigóiguero ora aisonori, pingoguirome pinguemisantaiguero, carari pingomëtaguiri irinibare. Aroca ingomëtëma pisiguima pingomantina. Aique naroegui nongomantëri cobeingari arota inguiseri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aique iáiguë. Icantaigapëri Ira Jesos: —Ogomeantatsiri, nigóiguë aisonori pogomeantiro Irinibare Tosorintsi, aisati poniaguinaro catingasati atiraca ongantima aretaiguëmari Tosorintsi. Te pintsoroguiri pairiraca. ");
INSERT INTO notNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yamai nosamitëmi: ¿Caninataqueco omëri Sésar aguireguite? ¿Teco onganinate omagantiri cobeingari cara Iromaquë? ");
INSERT INTO notNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Igóque Jesos cara icogaigabitaca iromatobitirime irantacaguirime ora te ongomeite. Icantaiguëri: —¿Pairo picogobiti pingomëtaguinaro nanibare? ");
INSERT INTO notNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Poniaguinari quirequi ira tenario pipënabentiri Iromasati. Aro yamaigapëneri quirequi ira jitacha tenario. Yosamitaiguëri Jesos: —¿Pairi casintaro oca irosiacagomentoca? ¿Pairi ijita sanguentëgotënguicha yaca tenarioica, iroonti iripajiro? Yotabitanëri jorío: —Iroonti irasi Sésar nogobeingarite. ");
INSERT INTO notNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aro icantaiguëri Jesos: —Aro, pomaigueri Sésar iraisati, pingantineri ora icocagaiguëmi, pinguemisantiri. Aisati pinguemisantasantiri Tosorintsi pomaigueri ora iraisati, ora icocagaiguëmi Iriro. Pintingomintasantimari. ");
INSERT INTO notNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tigueti ingantima ingomëtaguiri Jesos irinibarequë catingasatiquë matsiguengajegui. Iquenganeintasantaigacari jorío cara caninasati yotabitanëri, aro imairetaiguë. ");
INSERT INTO notNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aisati iátasitaiguëri Jesos saroseopague, ira ijitasitaiga cara quero icabiritaja igamaga, quero icaniatanai. ");
INSERT INTO notNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Icantaigapëri: —Ogomeantatsiri, jirai isanguenataiguëna Moisés: Aintaca sërari, carari te irine itomi, aique ingamaqueca, caninataque ireinti irágajiro iina; aroca ontsomaaque itomi, irianti irosiguëma itomi ireintitomaco. ");
INSERT INTO notNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jirai ainta sërari aisati ireinti icarati 6. Ira obatatsi yágabitaca iina, carari te irine itomi. Aique icamaque iriro. ");
INSERT INTO notNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aro iina yágairo ireinti. Aisati icamaque iriro te irine itomi. ");
INSERT INTO notNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aisati icantaigaca ireintiegui yágaigabitaro tsinane, icamaiguë omagaro, teni irinëmate itomi. ");
INSERT INTO notNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aique ocamaque tsinane aisati. ");
INSERT INTO notNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cara ingabiritaigaima, ¿Pairi ágairone? Pinetse, ijinantaigabitaro antagaisati ireintiegui. ");
INSERT INTO notNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Icantaiguëri Jesos: —Aisonori, yaca quibatsica yameta sërari yáguiro iina. Aisati tsinane págui ojime. ");
INSERT INTO notNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Carari cara itimi Tosorintsi, paniro iraretima iraegui iragabisaicoque Tosorintsi yaca quibatsica, iraniacaninataiguëri. Iraganiatairi intiomopëri Tosorintsi carari quero yágai iina. Aisati tsinane, quero págai ojime. ");
INSERT INTO notNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Canta querootisati icamaji, Tosorintsi intomintaiguëmari përosati iraganiataiguëri. Irianti aisati ingantaiguëmari ironomire Tosorintsi irisaanganetsite ira quero icami aisati. ");
INSERT INTO notNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jirai igóque Moisés cara ingabiritaiguëma igamagaegui. Isanguenaque cara yoniagapari Atingomi cara otiomijaniquë anchato otaaga, icampëri: Naro Tosorintsi. Iquemisantina Abaram. Iquemisantina Isac. Iquemisantina Jacob. ");
INSERT INTO notNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pinetse. Te ingante: “Iquemisantabequina”. Aroca iquemisanqueri Tosorintsi Abaram, ainta icaniati Abaram. Aisati caniari Isac aisati Jacob. Tosorintsi Irianti Itosorintsite ira caniatatsi. ");
INSERT INTO notNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aro icantaiguëri ogomeantiro Sanguenari: —Ogometinari, caninaro oca picantaiguëna. ");
INSERT INTO notNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aique itsorogaiguë irosomitaigairi Ira Jesos aisati. ");
INSERT INTO notNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aique icantaiguëri Jesos aisati: —Obirojegui picantaiguë: “Ira Agabisaicoontatsiri imatsiguenga David”. ¿Pairo picantobiti negaca? ");
INSERT INTO notNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Iriati David isanguenatocoqueri Quirisito jirai cara sárimoquë: Ira Tosorintsi icanqueri Natingomi: “Pisobigue yaca nobacosonoriquëca. ");
INSERT INTO notNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Pintsibatina yaca nagáantomentoquëca irooti cara nagabeiri antagaisati ira quisaiguëmi, irajitaiguëmi Itingomi”. ");
INSERT INTO notNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aique yosamitaiguëri Jesos: —Iriroca Quirisito Itingomi David, ¿Pairo pijitobitaiguëri Iriro imatsiguenga David? ¿Pairo te pijitobitiri Pitingomi obirojegui aisati? ");
INSERT INTO notNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Cara iquemisantaigaseguiri Jesos matsiguenga botobiritaigari, icantaiguëri ira irogomere: ");
INSERT INTO notNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Pigamaiguemari ira ogomeantiro isanguenare Moisés. Icogaigui iranëitagueantimaro imanchaqui oquibeintsa; icogasantaiguë iriáiguë cara opimantagani pairoraca arota iraniacaninataigueri matsiguenga; aisati icogaiguë iragasobicaigueri caninaroquë sobicomentotsi cara yapatotaiga jorío. ");
INSERT INTO notNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aisati yágabitsaquero obango ogamaimentaga iroontita cosamani yamanocotasitari Tosorintsi arota iraniacaninataigueri matsiguenga. Carari nongomantaiguëmi ira cantatsi negaca iratsipiriasantaiguë irabisaiguëri basini matsiguenga tojai ingasitígatëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ainta Jesos oquibequë pongotsi irasi Tosorintsi. Inetsaiguëri casintaguetachari cara yomingaiguiri iguireguite yogantaririquë quirequi ipëngani Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aisati iniobëro tsinane ogamaimentaga pomianqueri pite itiomijani iguitso quirequi ira te iripënatima. ");
INSERT INTO notNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Icanque Jesos: —Nangantaiguëmi, aisonori ora ogamaimentaga te aisa ongantaiguemari basini paiguëri Tosorintsi iguireguite. Arosataanti quirequi opëri iroro, carari Tosorintsi iniacaninatëro pabisaiguëri basini. ");
INSERT INTO notNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iraegui basini ipaiguëri Tosorintsi arosata ira inomotaiguiri, aintaquerai tojai yoganontaiga. Carari opabacari Tosorintsi aisati opëri antagaisati pasinsiga inomotiro, teni irinaje basini omanantantajima operi. ");
INSERT INTO notNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Inibatobaganaca irogomere Jesos, icantaiguë: —¿Teco onganinatasante ora ibangora Tosorintsi? Pobetsiquëngani mopëpague oquibe aisati poganinaguetiro, aisati yoganinatancaro ora ipaiguëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Aro icantaiguëri Jesos: —Aiquenta irogomeriguetaiguëro antagaisati ora piniaiguë yamai. Quero pini pite mopë otsibatobagaa; omagaro ogomeriguetëngani. ");
INSERT INTO notNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yosamitaiguëri: —Ogometinari, ¿Atiraca ongantima cara irogomeriguetëro orapague pongotsi? ¿Pairo ogótacaquinane cara omoncaraquima antagaisati picantocotaiguëna? ");
INSERT INTO notNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aisati icantaiguëri irogomere Jesos: —Pigamaiguema arota quero yamatobitaiguimi. Iriboquë tojai matsiguenga ingantaiguëmi: “Naro Quirisito”, aisati “Igáquina Quirisito nongomantëmi pënibaque irarequima Iriro”. Quero piquemisantaiguiri, quero poguiatiri. ");
INSERT INTO notNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pinguemocotaiguëro omanátobagachari; ingantaiguëmi: “Yomanátobagani canta jaanta”. Ira basini irojocaiguëri itingomipague irogaiguëri irirai itingomi. Quero iquengaiganaja matsiguengajegui carari quero pitsorogaigui: aiquenta onganquima tojai inguisabacaquima irógobaquima, carari queroquerai omoncarata omagaro ora nacantaiganaquemi. ");
INSERT INTO notNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aisati nangantaiguëmi: aiquenta matsiguenga inguisaiganaqueri basiniati matsiguenga, inguisëgotobaganëma irógobaquima. ");
INSERT INTO notNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aisati tojai osebataguetanëma quibatsiquë. Aitosati iritasegaiguë tojaisonori matsiguenga omagaroguitequë; ontojaiganaque janatigantsipague; ingamaiguë tojai matsiguenga; intsorogaiganaque omagaro; cara jonoquë iraniaiguëro cobeingaguiteri ora te oneingani jirai. ");
INSERT INTO notNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Përosati icomantaiguëri Jesos: —Carari iritsite quisaguetaiganaquemine, irágaiguëmi, iratsipiriacagaiguëmi, irágaiganaquemi cara pongotsiquë cara yapatotaiga, iromingaiguëmi iromingamentoquë. Irágaiganaquemi catingasatiquë itingomipague inguisatsataiguëmi aroquenta piquemisanquina Naro. ");
INSERT INTO notNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aro pinguenguitsatocotina, ati ongantima nagabisaicotajiri cara inguemisanquina. ");
INSERT INTO notNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Quero pitsoroguiri, quero piquenga: “Aroca iráquena, ¿Pairoroco nanganqueri?” ");
INSERT INTO notNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nogósëretacaquemi Naro ora pinganque. Onibataquemi Isëre Tosorintsi arota quero igóti ipëgatsatimi ira quisaiguëmine. ");
INSERT INTO notNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Irácagantëmi piri aisa piniro aisati pirentipague aisati pitsiropague, aisati irácagantëmi pomatsiguenga, omagaro. Irógarantaguequimi porocague. ");
INSERT INTO notNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Piquemisantaiguënanta, inguisaiguëmi matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aroca iróquemi, quero opega patiro piguisi piguitoquë. Pijáiganaque Jonogaguitequë Tosorintsiquë. Quero atira picantëmata. ");
INSERT INTO notNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Cara iratsipiriacagaiguëmi aroca përosati pinguemisanquina, pintiomoquina Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aisati iquenguitsatomotaiguëri Jesos: —Cara piniaigabaquerica soraro irishongaiguëmaro Jerosarén, aro pigóiguë pënibaque iritsongaiguëro poboeborote. ");
INSERT INTO notNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aique iraegui inasegatsine Joreaquë, irisigaiganaquimata cara otisipaguequë; iraegui inasegatsine Jerosarénquë irisotocaiganaqueta; iraegui inasegatsine togantsiquë quero ipigapaa poeboroquë. ");
INSERT INTO notNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aro omoncaraquima antagaisati ora isanguenaque jirai cara ingasitígataiguëri Tosorintsi omagaro tsoengatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tojai otsipiriaiganaquero tsinane ora pënibatasegatsine aisati tsotagasegatsine ojaniquite queronta pisigasantanaca. Tojaisonori iraniacatsigatëmaro Jerosaresati tojainta ingasitígatasantaiguëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iromanátaigapëri, ingamaiguë tojaisonori jorío. Aisati irágaiganaquengani tojai Jerosaresati parigotipaguequë, iromerataigabaquimari. Ainta basiniati matsiguenga cagari jorío imaniaiguëma basiniatipaguequë quibatsi, intimaigapë Jerosarénquë irooti cara omoncaraquima antagaisati ora icantocoqueri Tosorintsi jirai, irooti cara inganque: “Antagati”. ");
INSERT INTO notNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Përosati icantaiguëri Jesos: —Aique cara pënibaque nopocaje Naro, imasiniatitanë omagaro iraegui jonoquëni: intsitinitanë paba aisa manchacori; imariaguëpë jonogasati. Piniaiguëro ora te oneingani jirai. Antagaisati matsiguenga timaigatsi yaca quibatsica intsorogasanoiganaque cara inguemaigabaquero cara ojigocanëma oquibeguinte angaarepague aisati cara omotoncaatasantanë oquibeguintesonori. ");
INSERT INTO notNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aisati osebatëma omagaro Jonogaguite. Intsorogasanoiganaque antagaisati matsiguenga, ingamëmanataiganaque inguengaiguëma: “¿Pairoraca basini onganquima? ¿Atiraca anganquima eiro?” ");
INSERT INTO notNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aique iraniaigabaquena Naro, Naati nopaniaca jirai Jonocaguitequë nomatsiguengatapë, nopogopë mingoriquë, nongobeingatasanotapë nosangueguitetasanotapë, nantingomibintasantaiguëri omagaro, nagabeiri antagaisati. ");
INSERT INTO notNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cara piniaigabaquero omarintëma ocapague nocomantaiguëmica yamai, pinganinataigue, pinetsaigabaquina; pënibaque nopogopae notsonquemiro nagabisaicotasantaiguëmi, quero pitsipiriaigai aisati. ");
INSERT INTO notNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aitosati icantaiguëri irogomere Jesos: —Aisati nosiacagantëmiro anchato jitacha iguera. Pinetsero iguera aisati omagaro basini anchatopague. ");
INSERT INTO notNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cara iroraini otsego, ositanae osi, aro pigóiguë pënibaque osariganaje. ");
INSERT INTO notNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aisa ocanta, cara piniaigabaquero ocapague nacantocotaiguemica, pigóontëmaro omanapague orequima cara Tosorintsi intingomibintaiguëri matsiguenga yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nangantaiguëmi aisonori: queroquerai icamaigui joríojegui tsoengantatsi queroquerai omoncarata ocapague nocomantaiguëmica. ");
INSERT INTO notNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Omeganëma omagaro inatsi jonoquë aisati omeganëma oca quibatsica, carari quero opega nasi nanibare. Omoncaraquima omagaro ora nacantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aisati icantaiguëri: —Pigamaiguema. Nomabocapaimi. Quero picantiro ora te omitocotimi, quero pisinguitaiga, quero pogasëretocotaguetaro orapague inatsi yaca quibatsica ");
INSERT INTO notNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","arota quero poguipasiguitimi cataguiteri cara nopocaje. Omabocaiguëri omagaro matsiguenga ira te iragamaiguema. ");
INSERT INTO notNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pigamema, pingaguite, pomanocotaigueri Tosorintsi arota iromitocoiguemi pingantiro ora caninaro, pintiomotaigabaquina, arota quero pitsipiriaro omagaro nocomantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aro cara cataguiteriquë yogomeantë Jesos oquibequë pongotsi irasi Tosorintsi; cara ochapinitanë, iáque oguitojaquë jitacha Olibos, itimaque cara. ");
INSERT INTO notNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Oquëtaguetanë iátasitaiguëri matsiguengajegui cara ibangoquë Tosorintsi, icogaiguë inguemisantopiantaigueri. ");
INSERT INTO notNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pënibaque orequima cataguiteripague jitacha Pásicoa cara yapaiguiro joríojegui ora pan te ine piponganta, aisati iquengaigaca cara isotocaiguë Ejípitoquë jiraisonori. ");
INSERT INTO notNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Icogaigabitaca iróguirime Jesos itingomipague saserirotijegui aisati iraegui ogomeantiro Sanguenari, icantobaca: —¿Ati anganqueri ágagantiri Jesos agamagaiguëri? Intsome angantiro comanoroni querota iguisaigái matsiguenga iniacaninatërinta Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aique ira Satanás camagari iátasiqueri Joras Cariotisati, ira yogometabeca Jesos; yagobiopëri yogomequeri irácagantëri Itingomi Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aro Joras iátasiqueri itingomipague saseriroti, icampëri: —Nomitocoquemi págaiguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Icaninatasantaiguë, icantaigabaqueri: —Aro, caninataque. Aroca águëri, aro nomaiguëmiri quirequi. ");
INSERT INTO notNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iquengaigaca. Aro icanque Joras: —Aro. Nanetsëri; aique nongomantaiguëmi ati ongantima págagantëri comanoroni. Quero iniaiguimi matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pareca Pásicoa cara yametaiga joríojegui yóguëri oisha aisati icantaigari ibega jorío jiraisonori Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aro Jesos igátaiguëri Peroro aisati Joan, icanqueri: —Pijáigue, pobetsicaiguero cara opaiguë Pásicoaquë. ");
INSERT INTO notNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yosamitaiguëri pitirooti: —¿Nega pininti nobetsiquëmiro? ");
INSERT INTO notNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Icantaiguëri Iriro: —Cara pirequima Jerosarénquë, piniopëri sërari yáigotëro nija. Piguiatiri irooti pongotsiquë cara inganaque. ");
INSERT INTO notNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aro pingantaiguëri casintaro pongotsi: “Icanque Ogometinari: ‘¿Nega pini cara nopaiguë Pásicoaquë, Naro aisati nogomerejegui?’ ” ");
INSERT INTO notNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ironijagaiguëmiro oquibe coarito jonoquë; aito pobetsiquëro perintsi asi Pásicoa. ");
INSERT INTO notNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aique iáiguë, iniaigapëri sërari aisati omagaro aisa ocanta icantaiguëri Jesos. Yobetsicaiguëro Pásicoa. ");
INSERT INTO notNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aique cara ochapinitanë yaretaigapa Jesos aisati irogomere, isobicaigapë mesaquë yapaigapë. Icanqueri: ");
INSERT INTO notNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","—Tojai nocoque nopaaganaimi oca Pásicoa cara queroquerai nacami ");
INSERT INTO notNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","nangantaiguëminta cara quero napairo aisati irooti cara omoncaraquima omagaro isanguenatocotaiguëna cara intingomibintanque Tosorintsi iragáantanequë. ");
INSERT INTO notNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aro yáguëro ógomentotsi, icarasiaqueri Iriri, icantaiguëri: —Jeroca, pógaiguemaro obirojegui ");
INSERT INTO notNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","nanganqueminta cara quero nógaaro obaa aisati irooti cara iragáantanequë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aique yáguëro pan, icarasiaqueri Tosorintsi, itibatsaaguequero, yotsatengaiguëri irogomerejegui. Icantaiguëri: —Jeroca pan osigaro nobatsa. Popaiguero. ¿Teco nangamobitaiguemi? Nocogui cara popapinintaiguëro pan pinguengasëretapinintaiguëna cara nacamobiquemi. ");
INSERT INTO notNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aro yapaiguëro. Aisa yáguëro ora yóganta obaa, icanque: —Jeroca obaa, pógaiguemaro. Iroro osigaro naraa ora naraatobitanëneri omagaro matsiguenga cara nangamobitaiguëri. Yamai naraa ocanti irorai Nibarintsi; iroro ingábintsantaiguëmari Tosorintsi cara icanque jirai. Cara irabentaiguëna matsiguenga inguemisanquina, Tosorintsi irojocajineri ora icantagueti te onganinate, quero iquengaineri aisati. Cara pógapinintaiguëmaro obaa pinguengasëretaiguena cara nacamobitaiguëmi arota iragabisaicotajimi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yamai ainta yaca yapëgotëna ira ágagantënane. ");
INSERT INTO notNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nopaniaca Naro Jonogaguitequë, nomatsiguengatapë yaca quibatsica. Omoncaraca omagaro isanguenatocoquina jirai Sanguenariquë. Irari atsipiriasantërone ira ágagantënane. ");
INSERT INTO notNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aro iparintaigaca irogomere Jesos yosaminatobaca iriatiegui: —¿Pairiraca ágagantërine? ");
INSERT INTO notNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aique icantobaganaca irogomere Jesos pairiraca obaquenguitsine irirojeguiquë. ");
INSERT INTO notNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Icantaiguëri Jesos: —Pigóiguë cara yametaiga basiniati matsiguenga ira cagari jório itingomintaigacari itingomipague, iriro cantënguicha itingomi merataigari imatsiguenga. Icantasitaigaca: “Nomitocoiguëri natiriteegui”. ");
INSERT INTO notNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Carari quero aisati picantaigari ibegaiga iriro. Pinintica piguibatima obiati, quero piquenga obiati caninari pabisiri basini. Pomitocoigueri pomatsiguenga, pingábintsaguetaigueri, quero pimeratari. ");
INSERT INTO notNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Pairi obatatsi, iraco sobigatsi mesaquë, iraco mapënerine iraperi? Pigóiguë ibaque ira sobigatsi mesaquë, yapi, imeratari iromeraro ira mapënerine iraperi. Carari te nomerataiguemi Naro, Naanti cantaca pomeraro. ");
INSERT INTO notNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Coshoni pogaiguëna jirai, pitsibataiguëna cara yobomirintsitapinincái omatsiguenga; ");
INSERT INTO notNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","aiquenta nomaiguëmi pintingomibintante aisati nacanta aroque ipëna Pabati cara natingomibintanque. ");
INSERT INTO notNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pintsibataiguëna, popëgotaiguëna aisati pógaiguëma canta nantingomibintanque, aisati antingomibintaiguëri omagaro jorío imatsiguenga itomi Jacob icarati 12. ");
INSERT INTO notNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aique icanque Atingomi: —Simón, Simón, icogui Satanás iraniantëmi aisonorica piquemisanquina. Icogui irantacaquemi ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Carari namanocoquemi iromitocotimi Tosorintsi irosintsisërequimi querota pijoquiro cara piquemisanti. Aiquenta, cara pijocajiro ora picantagueti te onganinate, piganinasëretaguetiri popiguemisantane, pomitocotaguetiri, pinguemisantasantacaguiri. ");
INSERT INTO notNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Icanqueri Peroro (Simón): —Natingomi, naguiatëmi përosati. Aroca iromingaiguina, irógaiguinaca aisati, quero nojocanëmi naro. ");
INSERT INTO notNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Icomantëri Jesos: —Nanganquemi, Peroro: yamaica tsitinirica queroquerai icaimi tiapa sërari, ongaraque maba pinganque: “Teni nogótiri Ira Jesos”. ");
INSERT INTO notNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aisati icantaiguëri irogomere Jesos: —Jirai nigátaiguëmi piáiguë piquenguitsatomotagueiguëri matsiguengajegui, nacanquemi: “Quero páganëro pitsaguine, querootisati poperi, querootisati basini pisapatote”. Yamaica nosamitëmi: ¿Pitsipiriaiguë? ¿Aiti coguitiomoquemi? Yotabitaiguëri irogomere: —Tesonori. ");
INSERT INTO notNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aro icanqueri Jesos: —Carari yamai nangantaiguëmi: aitica pitsaguine, páganëro, aisati aitica pomotsirate páganëro. Piguireguite aisati. Teca ine pisabirite, pomimantiro basini piguitsagare pomanante patiro sabiri. ");
INSERT INTO notNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nangantaiguëmi cara omoncaraquima ora isanguenatocoquina jirai Isaías: Itsibatacari ira cantaguetiro ora te onganinate. Aisonori, omagaro isanguenatocotaguequina omoncaraquima. ");
INSERT INTO notNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aique icantaigapëri: —Natingomi, pinetse. Jeroca pite sabiri. Icanque Jesos: —Aroque, antagati, moncaraca. ");
INSERT INTO notNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aique, cara yameta Jesos, iáque oguitojaquë jitacha Olibos. Yoguiataiguëri irogomerejegui. ");
INSERT INTO notNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cara yaretaigapaa, icantaiguëri: —Pingaguitaigue, pomaniri Tosorintsi cara iromitocoiguemi quero picantaguetiro ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aique yogaganaca arosata caraquerora, yobaticagueritotasipa, yamanocopëri Iriri: ");
INSERT INTO notNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Pabati, teni naninte natsipirie, carari quero nacantiro ora nocogabeca Naro, iroonti nanganquero ora picocaquena Obiro. ");
INSERT INTO notNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aique ipocasipëri ironomire Tosorintsi imitocopëri yosintsitëri. ");
INSERT INTO notNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tojai yogasëretasanotaca, itsipiriasëretasantaca, aisati yamanocotasantëri Iriri. Tojai imasobique, opariaatë imasobire quibatsiquë cantaca iraraa. ");
INSERT INTO notNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Icabiritaja, ipigapaa cara isamaigasegui irogomere. Carani yogasëretasantaiga, iroro imagotaguëtaiguë. ");
INSERT INTO notNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Icantaiguëri: —¿Pairo pisamabiritaiguë? Pingabiritaiguema pomanaigue arota quero picantiro ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aintaquerai inibatasegui Jesos cara yaretaigapa tojai matsiguenga. Ibataiguëri Joras, irianti irogomere Jesos, iátasipëri Jesos yasaraboropari. ");
INSERT INTO notNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Icabëri Jesos: —Joras, ¿Págagantënanico cara pasarapëna? ¿Teco pigóte Naro paniacha Jonogaguitequë, nomatsiguengatapë? ");
INSERT INTO notNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aro iniaigabaqueri ira tsipataigari Jesos. Yosamitaiguëri: —Natingomi, ¿Picoguico nopëgabentaiguemi nacarataigueri? ");
INSERT INTO notNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aro paniro irogomere yáguero isabirite itoguimitatobëri iguemitasonori ibimantaga itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Icanqueri Jesos: —¡Aroque, antagati! ¡Quero pintiri basini! Aique yotsagaquineri iguemita, yogaguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesos icantaigabaqueri itingomipague saseriroti aisati ira itingomipague sorarojegui omisantiro ibango Tosorintsi aisati antiasiparipague, icantaiguëri: —¿Pairo pamasibiriquinaro pisabirite aisati anchaqui? ¿Pijiquinanico Naro cosirinti? ");
INSERT INTO notNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Omagaro cataguiteri piniaigabitëna cara nogometaiguimi cara ibangoquë Tosorintsi, te pingantëmatina. Carari omoncaraca yamai págaiguëna aisati iragabianque camagari intingomibintanque arosata. ");
INSERT INTO notNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aique yágaiganaqueri Jesos cara ibangoquë itingomi saseriroti. Yoguiataiguëri Peroro icarantanë panirooti. ");
INSERT INTO notNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yogamataiguëro tsitsi cara saaguiteroquë tsomagui tantotsi. Isobicaigapë, Peroro aisati. ");
INSERT INTO notNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cara isobicasegui Peroro, oniasantëri tsinane obimantaga itingomi saseriroti, ocanque: —Ica aisati yoguiatëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Carari icanquero Peroro: —¡Cagarina naro! ¡Teni nogótiri! ");
INSERT INTO notNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aique arosata, iniaqueri basini, icanque: —Aisati obiro aguiatëri Jesos. Carari icanqueri Peroro: —¡Teni naguiatiri, teni nogótiri! ");
INSERT INTO notNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aique ocosamanitanë arosata, icanëri basini: —Aisonori yoguiatëri ica sërarica, irianti Garireasati. ");
INSERT INTO notNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Carari icanqueri Peroro: —Teni nogóte pairoraca picanquina. Iroontita inibasigui Peroro, irooti cara icaimanë tiapa sërari. ");
INSERT INTO notNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aro inebintanaca Atingomi inetsëri Peroro. Aito cara iquianquero Peroro cara icomantëri Jesos: “Queroquerai icaimi tiapa sërari yamai, mabataque pinganque: ‘Teni nogótiri Jesos’ ”. ");
INSERT INTO notNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aro isotocanai Peroro iragasantaca. ");
INSERT INTO notNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ira omisantaiguiri Jesos isërontaigacari aisati ipasataiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aisati ibasioquiqueri iroquiquë, inchotangaborotëri, icantaiguëri: —Jaa, pingomantina: ¿Pairi capojëmi? ");
INSERT INTO notNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Përosati, tojai icantocotaguetasitaigari, isërontaigacari. ");
INSERT INTO notNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cara oquëtaguetamananaque, yapatotaigaca iraegui antiasipari aisati itingomipague saserirotijegui aisati iraegui ogomeantiro isanguenare Moisés. Yágaiganaqueri Jesos catingasatiquë itingomipague ira obatatsiri icarati 71. ");
INSERT INTO notNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Icantaigabaqueri: —Pingomantaiguena Obiroca Quirisito, Ira Agabisaicoontatsiri. Yotabitaiguëri Jesos: —Aroca nongomantaiguëmi: “Jee, Naro Quirisito”, quero piquemisantina. ");
INSERT INTO notNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aisati nosamitaiguëmica pairoraca ora isanguenatocoquina, quero potabitaiguina. ");
INSERT INTO notNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nopaniaca Jonogaguitequë, nomatsiguengatapë yaca quibatsica. Yamai pënibaque najátaje aisati Jonogaguitequë, nosobigopë cara ibacosonoriquë Tosorintsi Agabiasanotachari. ");
INSERT INTO notNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Icantaiguëri antagaisati jorío: —¿Obiroco Itomi Tosorintsi? Yotabitaiguëri Jesos: —Jee, Naro, cara picantaiguë. ");
INSERT INTO notNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aro yosamitobaca: —¿Pairo ongogobique basini comantëgotërine? Aquemaiguëri omagaro eiro ora icanque Iriati: icantocotaguetasitari Tosorintsi. Ijitosorintsitasita Iriati. ");
INSERT INTO notNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aito cara omagaro jorío obatatsiri yágaiganaqueri Ira Jesos catingasatiquë Pirato, ira cobeingari Iromasati. ");
INSERT INTO notNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aro icomantëgotaigapëri Ira Jesos, itsoiguëgotaigari: —Teni ingomeite Ica. Naniaiguëri cara yamatobitaiguëri nomatsiguengajegui, icantaigabitacari: “Quero popiri cobeingari quirequi”. Aisati icantopianti: “Naro Quirisito, pintingomintina, pinguemisantina Naro”. ");
INSERT INTO notNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yosamitëri Jesos Pirato: —¿Aisonorico? ¿Obiroco Itingomi joríojegui? Yotabitanëri Jesos: —Jee, Naro aisonori ora picanque. ");
INSERT INTO notNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aro Pirato icantaiguëri itingomipague saserirotijegui aisati iraegui ogomeantiro isanguenare Moisés aisati tojai matsiguenga botoitaigacha, icanque: —Ninibatëri Ica sërarica. Te ine pairo ingantaguetëmate ora nangasitígabiriqueri. ");
INSERT INTO notNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Carari icantopiantaiguëri jorío: —Iguisagaigacari ira matsiguengajegui, icantaiguëri: “Intsome ojoquiri ogobeingarite”. Iparintaca cara Garireaquë, yamai yaca aisa icampa, yamatobitaguëpëri tojai. ");
INSERT INTO notNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cara iquemaque Pirato, yosamitëri: —¿Iriroco Garireasati Ica? ");
INSERT INTO notNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yotabitëri: —Jee, Iriro. Icanqueri Pirato: —Aro, atsi páganëri cara Eroriquë igobeingarite Garireasatiegui. Yamai ainta yaca Jerosarénquë; ipoque cani. ");
INSERT INTO notNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aro yágaiganaqueri. Iniobëri Eroris, icaninatanë. Tojai iquemocotopiantëri Jesos itasongantagueque; icogasantë iraneiri. Icogabeca iraneirime cara itasonganti. ");
INSERT INTO notNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Cosamani yosamitaguetabecari Ira Jesos, carari te irotopitiri. ");
INSERT INTO notNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tojai yogatsitapinintaiguë itingomipague saserirotijegui aisati iraegui ogomeantiro isanguenare Moisés, icantaiguë: —Teni inganinate Ica, aiti icantagueti ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aique isërontaigacari Ira Jesos Eroris aisati omagaro isorarote. Irooti iquitsagatacagaigacari caninaro quitsagarintsi icantomemegacari itingomi, isërontobitaigacari. Aique yoguipigaineri Pirato. ");
INSERT INTO notNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jirai iguisabacaga Eroris aisati Pirato, carari yamai iparintacaro yágacaninatobaca, ijocajiro cara iguisabitobaca jirai. ");
INSERT INTO notNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Aique Pirato yapatotaiguëri ira itingomipague saserirotijegui aisati obatacagaiguëri jorío aisati tojai basini matsiguenga, icantaiguëri: ");
INSERT INTO notNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Pinetse, carani pamaigabitënari Ica, picantaiguëna yogometiri matsiguenga cara irojocajina naro aisati basini cobeingari natsipa. Piniaiguë cara nosamitasantëri pairoraca, carari naniacaninatëri, te ine irantane ora te ongomeite. Picantasitaigaca obirojegui. ");
INSERT INTO notNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aisati ira Eroris iniacaninatëri, irooti cara yoguipigainari. Ica te ingantaguete pairoraca ora nógobiqueri. ");
INSERT INTO notNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yamai nopasatagantëri, nomisotoqueri. ");
INSERT INTO notNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Aro antagaisati osarini omoncaraca jiesita cara iquengaigaca joríojegui jiraisonori cara yogabisaicobintëri ironomire Tosorintsi cara Ejípitoquë. Cara jiesitaquë yameta Pirato iromisotocajiri paniro iromingane, ira icoigaiguë jorío. ");
INSERT INTO notNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Carari icaimaiguë omagaro jorío: —¡Pógagantiri Ica; iriroque pomisotocaje Barabás! ");
INSERT INTO notNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yomianqueri ira Barabás irironta ógueri aisati icantaiguëri imatsiguenga: “Intsome ojocajiri Iromasati ogobeingarite”. ");
INSERT INTO notNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Icogabetanta Pirato iromisotocajiri Jesos, icogabeca iraguimairentaiguërime matsiguengajegui, ");
INSERT INTO notNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","carari aiquero iáiguë icaimaiguë: —¡Popëicotiri, popëicotiri! ");
INSERT INTO notNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yogatsitairo Pirato maba icantaiguëri: —¿Pairo icanque ora nopëicobiriqueri? Nosamitaigabitëmi obirojegui aisati nosamitabitacari Iriro. Te ine ora pigótacagaiguëna ora icantagueti te onganinate. Te ine ora nagamagobiqueri. Iroro nopasataguëqueri, nomisotocajiri. ");
INSERT INTO notNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Carari përosati icaimaiganaque: —¡Popëicotiri, popëicotiri! Aiquero icaimasantaiganaque iróoti cara yagobiaiguëri ira Pirato ora icogabeca iriro. ");
INSERT INTO notNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Icantaiguëri: —Aro nanganque ora picocagaiguëna. ");
INSERT INTO notNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yomisotocajineri ira Barabás, ira yomianque jirai aroquenta yogamaguëri matsiguenga aisati icoque irojocajiri igobeingarite. Ipaiguëri Barabás, carari igáqueri isorarote irágaiganaqueri Jesos cara iribëquëgotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aro yágaiganaqueri Jesos iribëquëgotaiguëri. Itonguibocari Sirenesati, ijita Simón, ipaniaca parigoti. Aro imeratobacari soraro iráganëneri Jesos igorosite, yoguiatëri yanatanëneri. ");
INSERT INTO notNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aisati yoguiataiguëri arosonori matsiguenga aisati tojai tsinane, piraicotaiguëri. Aisati pogasëretococari. ");
INSERT INTO notNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Carari inetsaiguëro Jesos, icantaiguëro tsinanepague: —Jerosaresato, quero piraicotina Naro; piraicotaiguema obirojegui, aisati pitomijegui. ");
INSERT INTO notNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aiquenta orequima cataguiteri omomirintsitomotaiguëmi, pitsipiriaiguë. Ingantaiguë matsiguenga: “Onganinasëretë ora tsinane quero pogui ojaniquite, aisa ora quero otsotacagui”. ");
INSERT INTO notNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aique ingantaigabitëma matsiguenga: “Otiopënata taranga, ománaiguenata oguitoja”. ");
INSERT INTO notNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aroca itsipiriacagaiguëna Naro te nangantëmate ora te onganinate, iritiguëmarini iratsipiriasantacaqueri iraegui cantasantatsi tojai te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aisati yágaiganaqueri pite cosirinti iribëquëgotëri, intsibatëmari Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Cara yaretaigaparo oguitoja ojita Carabera, ora ocanti osigaro iguito igamaga, aro ipëicotaigapëri Jesos corosiquë. Aisati ipëicotaiguëri pite cosirinti basiniquë pite corosi, paniro ibacosonoriquë Jesos, ira basini imatepacoquë. ");
INSERT INTO notNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Icanque Jesos: —Pabati, pingábintseri icaegui yogamaguënani, quero piguisiri tenta irogóigue pairoraca icantaiguë. Ira soraropague imaguimpibintëqueri imanchaquipague Jesos ipabacaguecaro yotsatiancaro. ");
INSERT INTO notNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ainta yaratingaiguë tojai matsiguenga inetsaiguëri. Aisati ainta obatacagaiguëri jorío isërontaigacari icantaiguë: —Yogabisaicotaiguëri imatsiguenga. Intsome anetsaigueri aroca iragabisaicoquima Iriati, Iriroca Quirisito Agabisaicoontatsiri, Ira icoiguë Tosorintsi igáqueri. ");
INSERT INTO notNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aisati isërontaigacari soraropague. Iátasiqueri ipapëri obaa cochoari ");
INSERT INTO notNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","icantaiguëri: —¡Obiroca Itingomi joríojegui, pigabisaicotima Obiati! ");
INSERT INTO notNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aiti sanguenari poguëngani igorositequë jonoica iguito Jesos, ocanti: “Icari Ica Irianti Itingomi joríojegui”. Osanguenaca maba nibarintsiquë: irinibarequë guiriego aisati irasi ebereo aisati iratín irinibare Iromasati. ");
INSERT INTO notNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aisati ainta paniro cosirinti ipëicoca aisati itsibatari Jesos, isërontacari icanqueri: —¿Obiroca Quirisito Agabisaicoontatsiri? Atsi yamai pigabisaicotima Obiati, aisati pigabisaicotaiguëna naro pitirooti. ");
INSERT INTO notNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Irari basini cosirinti isintsitsaqueri itsipa, icanqueri: —¿Teco pintsoroguiri Tosorintsi? Aisati obiro, pënibaque pingamaque. ");
INSERT INTO notNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aroquenta ocositagueanti eiroegui acantaguetiro cagaro caninatatsi, iroro ipëicotaguëcái atsipiriaiguë yamai. Irari Ica te ingantëmate ora yógobiqueri. ");
INSERT INTO notNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aisati icanqueri Ira Jesos: —Jesos, Natingomi, pinguenguena cara pirequima pigáantanequë cara pigáanti omagaro, quero pomaguisantina. ");
INSERT INTO notNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yotabitanëri Jesos: —Aisonori nanganquimi, yamaica cataguiteri pintsibatëna canta caninaguiteroquë. ");
INSERT INTO notNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Aroque icatingapë paba cara otsitinitanë omagaro quibatsi irooti cara ochapinitanë. ");
INSERT INTO notNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Itsitinitanë paba, aisati otisaraanaca aganguisati ora yotigantaro oquibe ibango Tosorintsi, ");
INSERT INTO notNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","aito cara icaimanë Jesos, catsigue icanque: —Pabati, yamaica nomëmiro nasëre. Irooti icamantanaca. ");
INSERT INTO notNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ira igapitante sorarojegui icarati 100 iniaqueri Jesos cara icamaque, iniacaninatëri Ira Tosorintsi, icanque: —Icaninatasanti Tosorintsi; aisati Ica camënguitsica. Aisonori Irianti Itomi Tosorintsi caninari, te ingantëmate ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aisati ira botoibiritaigari cara inetsaiguëri Jesos cara ipëicoca, iniaiguëro omagaro, ipigaiganaca yogasëretaigaca. ");
INSERT INTO notNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ainta jaqueronta ira ogóiguëri Jesos inetsaiguë aisati ora tsinanepague tsipataigapari cara ipaniaca Garireaquë, onetsaiguëri aisati. ");
INSERT INTO notNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Aro ainta caninari sërari jitacha José, itentaigacari basini obatatsiri jorío icarati 71 cara yapatotaigaca. ");
INSERT INTO notNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Iriro Arimateasati, te iranintiro cara ipëicotaiguëri Jesos irironta aguiaquero iragáantane Tosorintsi cara intingomibintaiguëri antagasiati matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ira José iátasiqueri Pirato yamanopëri imëri igamaga Jesos arota iromingueri. Aro ipëri. ");
INSERT INTO notNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aique iáque, yoguëpëri igamaga Jesos, iponatancari tocoya, yomianqueri irasiquë iritijomento yomoroquero mopëquë, ora terai iritijantimaro. ");
INSERT INTO notNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iroro cataguiteriquë yobetsicaiguë jorío jiesita; teraiquerai oretima sábaro cara imagoriaiguë. Pënibapë. ");
INSERT INTO notNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ora tsinanepague aguiataiguëri Garireaquë otsibataigapari aisati Jerosarénquë, onetsaiguëri cara itiaqueri omoroquë. ");
INSERT INTO notNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pipigaiganaja obangoquë, pobetsiquëneri casangajengaropague otiritaiguërime igamaga Jesos. Aroquenta pareca sábaro, cara omagoriaiguë cara ocanti isanguenare Moisés. ");
INSERT INTO notNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aique oquëtaguetanai tomincoquë, piáigamanë tsinane cara yomianqueri Jesos, págaiganaque casangajengaropague ora pobetsiquëneri. ");
INSERT INTO notNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cara paretaigapa omoroquë oniaigapëro oquibe mopë aroque otitigaca ora yasintocoontacari Josë Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ocaigabitanaca tsomagui, carari te oneiri igamaga Atingomi Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Iroontita onetsasigabitapaari, oquenganeintasantaca, aitoniati yaratingaigapë pite sërari iquitsagata catarisonoriguinte iguitsagare pobariaguitetasantë. Imabocaparo tsinane, ");
INSERT INTO notNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","otsorogaigabaqueri, poguitasantaigaca. Icantaigapëro: —¿Pairo picogobiqueri Ira caniatatsi yaca cara yomianqueri igamaga camatsiri? ");
INSERT INTO notNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Teni irinaje yaca. Aroque icaniatanai. Pinguenguero ora icanque Jesos jirai cara aintaquerai Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Icantaiguëmi: “Naro paniacha Jonogaguitequë nomatsiguengatapë cara niboguë yaca quibatsica, aiquenta irácagantëna matsiguenga cantagueantatsiri te ongomeite, iribëquëgotaiguëna, aique ongaraque maba cataguiteri, nanganiatanae”. ");
INSERT INTO notNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aro oquengaigairo irinibare Jesos. ");
INSERT INTO notNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pipiganaja poeboroquë ocomantaigapëri irogomere Jesos aisati ocomantagueiguëri basiniegui quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ainta María Magararasato, aisati Joana, aisati basini María iniro Santiago, aintasati basini tsinane. Tojai tsinane ocomantaigabitacari iragátane Jesos, ");
INSERT INTO notNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","carari te inguemisantaigabaquero ora ocomantabitaca tsinane cara icaniatanai Jesos. Ijitaigabitaca ocantasitaiga tsinane te ogóigue. ");
INSERT INTO notNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Paniro Peroro icabiritanaca isiganaca omoroquë, yoguipa, inetsapë tsomagui. Patiro iniopë ora tocoya iponatantabecari Jesos. Aique ipiganaja pongotsiquë, iquenganeintasantaca. ");
INSERT INTO notNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aro irooti cataguiteri iáiguë pite quemisantatsiri cara poeboroquë jitacha Emaos, cosamani 11 quirometoro aiquero Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Cara iquenaigasegui inibatobaca, inibatëgotëri Jesos ati ocanta icantaiguëri matsiguenga, aisati ora icantasantë Iriro. ");
INSERT INTO notNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Cara iáigasegui inibatobaca iquengamotobaca, yotsitipari Jesos, itsibatanacari abatsiquë. ");
INSERT INTO notNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iniaigabitobacari carari Tosorintsi te iranintacaguiri irogótobëri. ");
INSERT INTO notNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aro yosamitëri Jesos: —Cara piquenaigasegui, ¿Pairo picantobitobaca? Irirojegui yaratingaiguë, yogasëretaigaca. ");
INSERT INTO notNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Paniro, ijita Quiriopas, yotabitanëri: —Igóiguë antagaisati Jerosaresati. ¿Obiroco paniro te pigótocotiro? ");
INSERT INTO notNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yosamitëri Jesos: —¿Pairo pinibatëgoti? Icantaiguëri iriro pitirooti: —¿Teco pinguemocotiri Jesos Nasaresati? Caninasati icomantaguetaiguëri matsiguengajegui Irinibare Tosorintsi, aisati itasongagueanti. Iniacaninatëri Tosorintsi, aisati naniacaninataiguëri naroegui. ");
INSERT INTO notNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Irari itingomipague saserirotijegui aisati iraegui obatacagaiguëna yágagantëri, aro yogamagaiguëri ipëicotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Najitaigabitaca Iriro Agabisaicoontatsirite, iragabisaicocái eiro joríojegui. Icantabeca inganiatanae aisati, carari yamai pabisanaque maba cataguiteri cara icamaque. ");
INSERT INTO notNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aintapague tsinane tsipataiguëna, piáigamanë omoroquë, pipigaigapaa omabocapaina cara ");
INSERT INTO notNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ocomantaiguëna te oniaigairi igamaga Jesos, te irinaje. Aisati ocampë cara yoniagaparo ironomire Tosorintsi icanquero cara ainta Atingomi caniari. ");
INSERT INTO notNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aisati ainta naroeguiquë iáiguë cara omoroquë iniaigapëro irooti ora ocanque tsinane, carari te iraniaigairi Iriro. ");
INSERT INTO notNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aique icanqueri Jesos: —¡Te pigótëmataigue; pitsoinguëri comantantatsiri ira quinguitsataiguëmi Irinibare Tosorintsi jirai! Terai pinguemisantiri. ");
INSERT INTO notNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Teco ingantaiguemi cara Iritsita atsipiriaquenguitsine Quirisito Agabisaicoontatsiri ingamaque, aique inganiatanae iriátë Jonogaguitequë? ");
INSERT INTO notNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aro yogometasantaiguëri Sanguenari, yotsateanquero omagaro comantëgotëri Iriro. Iparintacaro isanguenare Moisés, aique yogometaiguëri isanguenare basinipague comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aro yaretaigaaro Emaos, irabisanaqueme Jesos ");
INSERT INTO notNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","carari icantaiguëri itsipa pite: —Quero piáti. Pintiomotina yaca nobangoquë. Aroque ochapinitanë, pënibaque ontsitinitanë. Aro icanaque Jesos pongotsique, itimaque. ");
INSERT INTO notNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cara isobicaiguë mesaquë, yáguëro pan Jesos, icarasiaqueri Tosorintsi, itibatsaaguequero, ipaguetaiguëri itsipa. ");
INSERT INTO notNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aito cara ira pitirooti igóiguëri Irianti Jesos; irooti cara ipegopitanacari. ");
INSERT INTO notNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aique icantobaca pitirooti: —¿Teco onganinatasante icancái cara abatsiquë igótacaganacáiro Sanguenari? Tojai ocancái asërequë, poganinasëretacái. ");
INSERT INTO notNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aito cara icabiritaigaca, ipigaiganaja cara Jerosarénquë. Iniaigapëri ira irogomere Jesos icarati 11 cara yapatoica irirojegui aisati basini quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Irirojegui icantaigabaqueri: —Aisonori icaniatanai Atingomi icabiritaja. Iniajiri Simón. ");
INSERT INTO notNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aique ira pite Emaosati icomantaigapëri icampë: —Aisati naro, naniaigairi canta abatsiquë. Yogometaigapëna caninasati cara niáigasegui carari terai nogótiri. Aique canta pongotsiquë itibatsaaguequero pan ipaiguënaro, irooti nigóontacari. Aito cara ipeganaca. ");
INSERT INTO notNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iroontita icomantaseguiro, Iriguito yoniagaigapari Jesos, yaratingopë aganguisatiquë irirojegui, icantaigapëri: —Quero pitsorogaigui. Pomagoriasëretaigue obirojegui. ");
INSERT INTO notNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Itsorogasantaiguë irirojegui, te irogótaigabaqueri. Ijitaigabitaca iniaigabaqueri sëretsi. ");
INSERT INTO notNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aro icampë Jesos: —¿Pairo pitsorogobitaiguë? ¿Pairo pitsoingobitaiguëna Naanti? ");
INSERT INTO notNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pinetsaiguero nobaco aisati naguiti cara ipëicoquina. Potsagataiguena pigóontëna aisonori Naro bocatsi; aiti nobatsa aisati notongui, te aisa nangantimaro pibega sëretsi. ");
INSERT INTO notNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aique yoniagaigapari ibacoquë aisati iguitiquë. ");
INSERT INTO notNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iniaigabitari icaninabentaigabitari, carari terainta iragabiaigue irajitiri cara icaniatanai. Cara iquenganeintasantaigasega, yosamitaiguëri Jesos: —¿Aiti poperi yaca? ");
INSERT INTO notNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aro ipaiguëri sima iritasitaga. ");
INSERT INTO notNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yáguëri yaaguëri cara inetsaigaseguiri. ");
INSERT INTO notNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aique icantaiguëri: —Pinguengaiguero nanibare ora nocomantaiguëmi cani: “Tojai itsipiriacagaiguëna irógaiguëna, omoncaraquema antagaisati isanguenatocoquina Moisés aisati comantantatsiri, aisati omoncaraquema omagaro isanguenatocoquina David cara sárimoquë”. Yamai omoncaraca. ");
INSERT INTO notNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aique igótacagaiguëri ora ocanti Sanguenaripague, ");
INSERT INTO notNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","icantaiguëri: —¿Teco ongante Sanguenari, “Iratsipiriaque Quirisito Agabisaicoontatsiri ingamaque, ongaraque maba cataguiteri inganiatanae ingabiritajima; ");
INSERT INTO notNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","aique iriáiguë iragátane imarintëma Jerosarénquë ingomantëgotaiguëri matsiguengajeguiquë cara irojocajiro ora icantagueti te ongomeite aroca inguemisantaiguëri Jesos irabentëmari Tosorintsi, aro Tosorintsi irisetaigaineri ora icantaguetomoqueri quimingari quero iquengairo aisati”? ");
INSERT INTO notNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pigóiguëro ocanti negaca Sanguenari. Yamai piniaiguëro cara omoncaraca ora isanguenatocoiguëna jirai. Yamai nocoguini pinguenguitsatocotaiguena. ");
INSERT INTO notNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pinëni yaca Jerosarénquë yamai queronta ocosamaniti cara nagátaiguëmiro ora icantasantaiguëmi Pabati, Iroonti imagantëmi Isëre Tosorintsi inantaigapëmi coshoni ogaiguëmi. Ogabiagagaiguëmi pingantaiguëneri Pabati pairoraca ingocagaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aique Jesos itsibataiganacari irogomere irooti cara Betaniaquë. Cara, itimagonaguitanaca ibaco jonoquë, yamanaqueri Iriri icanque: —Pabati, jerica nogomerejeguica; pingantocobentaigueri, pomitocotaigueri. ");
INSERT INTO notNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Cara icantocobentaseguiri Jesos, aito cara yáguëngani jonoquë yogainocanaca, ipeganaca. ");
INSERT INTO notNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aique irogomere ipigaiganaja Jerosarénquë, icaninabentasantaiguëri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Carari, omagaro cataguiteri iátopiantaiguë cara oquibequë pongotsi irasi Tosorintsi icantaiguë: —Icaninatasanoti Tosorintsi. Aro ocarati ora nasanguenaquemi. Irocas ");
INSERT INTO notNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cara jiraisonoriguinte cara teraiquerai ine quibatsi ainta Quirisito Ira aisati icantaro pibega Irinibare Tosorintsi yoniaganta ati icanta Tosorintsi, aisati itiomoqueri Tosorintsi, Irironta Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cara jiraisonoriguinte itsibatari Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cara jiraisonori yobetsicanëro antagaisati ora inatsi. Teni ine pairoraca ora aniaigui yamai ora te irobetsiquiro Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iriro timagantatsiri caniatacagantatsiri. Ipaguetëri cara intimaiganaque përosati matsiguenga. Aisati Iriro osangueguiteserëtocotiri matsiguenga cara yoniagaigacari Iriro caninarisonori. ");
INSERT INTO notNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iriro aisati icantaro pibega cataguiteri ora osangueguitetaguetiro cara posibitanëro ora tsitiniri. Aisati Quirisito osangueguiteserëtocotaiguiri matsiguenga cara igótacaqueri ora icantagueti te onganinate. Yaca quibatsica aiti tojai ora te onganinate cantaca tsitiniri, carari ora tsitiniri te ogabeiro te ogatsibaquiro ora cataguiteri. ");
INSERT INTO notNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tosorintsi igáqueri ira sërari jitacha Joan. ");
INSERT INTO notNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iroro ipoguëque Joan arota ingomantëgotiri Quirisito Ira osangueguiteserëtocotaiguiri matsiguengajegui arota inguemisantaigueri. ");
INSERT INTO notNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Joan cagari Quirisito. Iroonti ipocobique ingomantëgotiri Quirisito Ira osangueguitetocotiri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iriro cantaca Cataguiterisonori yosangueguitetocotiri antagaisati matsiguenga cara ipoque Iriro yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jiraisonori yobetsiquëro Quirisito antagaisati. Carari cara inasegui yaca quibatsica te irogótaigabaqueri matsiguenga te irágacaninataigabaqueri Itingomi. ");
INSERT INTO notNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ipoque irasiquë iguebatsite, imatsiguengatabitapari joríojequi carari te irágaigabaqueri imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Carari aintapague ágobëri iquemisantobëri. Aito cara itomintaigacari Tosorintsi iniaiguëri caninari aisa icanta iniaqueri caninari Itomi Ira Jesoquirisito. ");
INSERT INTO notNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ira quemisantobëri Quirisito, përosati itimacagajiri Tosorintsi, yogabisaicotajiri. Carari te iragabisaicotajiri Tosorintsi iriantinta quemisantatsi iriri. Quero yogabisaicotaja iriati. Quero yogabisaicotobaga matsiguenga iriati. Paniro iragabisaicotajiri matsiguenga Tosorintsi cara inguemisanqueri Itomi. ");
INSERT INTO notNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ira Quirisito ipaniaca Jonogaguitequë, imatsiguengatasantapë cara otsomaaqueri iniro, itiomotaigapëna naroeguiquë. Naniasantaigabaqueri caninarisonoriguinte. Iriro paniro Itomi Tosorintsi Ira igáque yaca quibatsica. Iriro cábintsasantaigapërine matsiguenga irojocajineri ora icantagueti te onganinate aisati quero iquengairo aroquenta inintasantaigapëri. Aisati patiro inibatiro Iriro ora aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joan icomantëgotëri, icantaiguëri matsiguenga catsigue: —Iriro Ica nacantocoque cani cara nacanque: “Yamai aintana naro yaca. Aiquenta coraque iribocapë Iriro Ira Atingomisonori. Ibaquina Irironta caninarisonoriguinte. Ira te aisati ingantina nibega naro aroquenta irinaga ini Iriro jiraisonoriguinte”. ");
INSERT INTO notNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Irironta caninarisonoriguinte icábintsagueiganacái. Aiquero iátanëtigue icábintsasantaiganacái. Aisati icantaneintëgotacái. ");
INSERT INTO notNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jiraisonori isanquenaquero Moisés ora igáantë Tosorintsi. Carari yamai icábintsasantacái Jesoquirisito aisati ipaigacáiro ora aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Teni pairi neirine Tosorintsi. Paniro ini Itomi itimacaqueri Iriri jiraisonoriguinte. Igótacacái Iriro ati icanta Iriri. ");
INSERT INTO notNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Cara Jerosarénquë igátaiguëri jorío ira saseriroti aisati imatsiguenga Irebí. Ipocasipëri cara inasegui Joan, yosamitaigapëri: —¿Pairibi obiro? ¿Obiroco Quirisito Ira agabisaicoontatsi? ");
INSERT INTO notNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Icomantëgotaca Joan yotabitobëri: —Cagarina naro Quirisito Ira agabisaicoontatsi. Catingasati icantaigabaqueri Joan. ");
INSERT INTO notNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aisati yosamitaiguëri: —¿Pairibi obiro? ¿Obiroco Erías? Icanque Joan: —Cagarina naro Erías. Aique yosamitairi: —¿Obiroco comantantatsiri ira isanguenatocoque Moisés jirai? Yotabitobëri: —Cagarina naro. ");
INSERT INTO notNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aique icantaiguëri saseriroti aisa imatsiguenga Irebí: —¿Pairiroco pijitara obiro? ¿Pairo pinibatëgotëma obiati? Nocogaiguini pingomantëgotima, ora nongomantaigapairi ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Icanque Joan: —Naanti comantantatsiri cara tera ontimingani ira isanguenatocoque Isaías jiraisonori cara icanque comantantatsiri: Pobetsicoboquitineri irabo Atingomi. Ora ocanti piganinatineri paneingomento. ");
INSERT INTO notNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ira osamitaiguëri Joan iriantiegui iragátane bariseo. ");
INSERT INTO notNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yosamitairi aisati: —Cagaribica Quirisito Agabisaicoontatsiri, cagaribica Erías, cagaribica comantantatsiri ira isanguenatocoque Moisés cara jiraisonori; ¿Pairo pobaotisabiritaiguëri matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Joan icantaiguëri: —Naro baotisatantaro nija, carari ainta omatsiguengaquë Ira te pigóigueri. ");
INSERT INTO notNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aiquenta iribocapë. Ira te aisa ingantina nibega naro. Nitsoingaa naati tenta ongomeite nantsibatimari Irironta obaquina. Iriro caninarisonori Natingomi. ");
INSERT INTO notNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Omagaro oca icanquero Joan cara poeboroquë jitacha Betania cara onamijaquë Jorirán aiquero cara iconteti paba. Canta ibaotisataiguëri matsiguenga Joan. ");
INSERT INTO notNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cara oquëtaguetanai Joan iniobëri Jesos ipogopë, aro icomantaiguëri matsiguenga icanque: —¡Pinetsaigabaqueri Ira iragátane Tosorintsi! Aisati icantari ibega itiomijani oisha ira ogamagaigui. Aisati Iriro camobitaiguërine antagaisati matsiguenga irágopitaguetajiri ora icantagueti te onganinate. ");
INSERT INTO notNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iriro nocomantëgotë cani cara nacanque: “Yamai aintana naro yaca. Aiquenta coraque iribocapë Ira obatina Irironta caninarisonoriguinte irinaganta itimatá cara jirasisonoriguinte”. ");
INSERT INTO notNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Teni pigóigueri obiro. Teatisati nogótiri naro carari igáquina Tosorintsi cara nongomantëgotëri Quirisito arota irogóigueri omatsiguenga. Iroro nobaotisatantobitaro nija cara noniaganqueri Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Përosati icomantëgotëri Jesos Joan icanë: —Naniobëro cara paguëpë Isëre Caninaro Tosorintsi aisa ocampari ibega sompaguiti pinampari. ");
INSERT INTO notNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Cara terai nogótiri naro, Ira agáquina nobaotisatantaro nija icanquina: “Cara piniobëro Caninaro Nasëre oguëtasipëri sërari aitosati pinampëmari, Ica sërari Ira baotisatanquimarone Caninaro Nasëre, ora ocanti imëmiroti Nasëre”. ");
INSERT INTO notNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aroque naniaquero. Aro yamai nocomantëgotiri Ica Iriro Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Oquëtaguetanai aintasati inasegui Joan aisati pite irogomere. ");
INSERT INTO notNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iniobëri Ira Jesos cara yabisanaque, icanqueri irogomere Joan: —¡Pinetseri Ira sërarira! Iriro aisati icantari ibega itiomijani oisha igácáiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ira pite irogomere Joan iquemaqueri aro yoguiatanëri Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Cara iniobëri pitirooti Jesos inebintanaca, icabëri: —¿Pairo picogui? Yotabitanëri: —Ogomeantatsiri, ¿Nega pitimi? ");
INSERT INTO notNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yotabitobëri Jesos icanqueri: —Joocaigue pinetsënte. Aique yoguiatëri cara itimiri. Aro inibatobaca irooti cara ochapiniguitetanë. ");
INSERT INTO notNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ainta piteni ira quemisanqueri Joan aique yoguiatanëri Jesos. Paniro ijita Antiris ireinti Simón Peroro. ");
INSERT INTO notNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Iritsita Antiris icoganëri Simón ireinti iniopëri icampëri: —Aroque naniaqueri Ira Quirisito. Quirisito ocanti Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Antiris yáganëri ireinti cara Jesosiquë. Icabëri Jesos ira Simón: —Obiro pijita Simón, itomi Joan. Yamai najitajimi Sejas aisati Peroro oca ocanti mopë. ");
INSERT INTO notNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Oquëtaguetanai ipintsataca Jesos iriátë cara Garireaquë. Aique iniaqueri ira Jeripe, icanqueri: —Piguiatapëna. ");
INSERT INTO notNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ipaniaca Jeripe cara poeboroquë jitacha Betsaira. Aisati Antiris aisa Peroro pitirooti Betsairasati. ");
INSERT INTO notNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aique iáque Jeripe icoqueri Natanael, icanqueri: —Aroque naniaiguëri ira isanguenatocoque Moisés jiraisonori cara isanguenaque ora iragáantane Tosorintsi. Aisati isanguenatocotaiguëri comantantatsirijegui. Iriro Jesos, itomi José Nasaresati. ");
INSERT INTO notNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yotabitobëri Natanael yosamitobëri: —¿Aintaco caninari paniacha Nasarequë? Icanqueri Jeripe: —Jooque pinetsëntiri. ");
INSERT INTO notNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Cara iniobëri Jesos ira Natanael icantocoqueri: —Pinetseri caninari jorío ira te iromatobiante. ");
INSERT INTO notNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aique yosamitëri Natanael Ira Jesos, icanqueri: —¿Pigóquinaco? Icanëri Jesos: —Naniaquemi cara teraiquerai ingaimimi Jeripe, cara pinasegui otabiquë panguirintsi jitacha iguera. ");
INSERT INTO notNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yotabitanairi Natanael: —Ogomeantatsiri, Obiro Itomi Tosorintsi. Obiro Itingomi joríojegui imatsiguenga Isirael jiraisonori. ");
INSERT INTO notNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Icanqueri Jesos: —¿Piquemisanquina aroquenta nocomantëmi naniaquemi cara pinasegui otabiquë iguera? Aiquenta piniobëro basini tojai, aro pinguenganeintasantanëma. ");
INSERT INTO notNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aisonori yamai nocomantaiguëmi nopaniaca Jonogaguitequë nomatsiguengatapë cara niboguë yaca quibatsica. Aiquenta piniobëro Jonogaguite osirianaquima, aisati piniaigabaqueri ironomire Tosorintsi iragainocanëma jonoquë cara Naroquë aisati iraguëpë. ");
INSERT INTO notNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Omoncaraca maba cataguiteri cara yáguëro iina sërari cara poeboroquë jitacha Caná cara Garireaquë. Aintasati pinasegui iniro Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aisati icaimëngani Jesos aisati irogomere cara yapatotaigaca igaimanejegui. ");
INSERT INTO notNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cara pitsoatanaca oja oba aro ocanqueri iniro Jesos: —Tsoatanaca obaa. ");
INSERT INTO notNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yotabitanëro Jesos: —Atsi caraquenta, ina. Terai oretima cataguiteri cara noniaguëmari matsiguenga cara nomitocotagueantëmari natasorintsite. ");
INSERT INTO notNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aro iniro ocanqueri iromeraro ira quitiro obaa: —Pairorapagueraca iragáquemi Jesos, pingantiro. ");
INSERT INTO notNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aiti pinasegui oquibe chomo ocarati 6 ora yogantaro nija ora yoguëtetantagueta jorío. Patiro chomo ojaquima nija 100 iritoro. ");
INSERT INTO notNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aro igáqueri Jesos: —Pijaguiro nija cara chomoquë antagaisati cara ocarati 6. Icanquero. Iagasantëro irooti otseraquë. ");
INSERT INTO notNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aique icanqueri Jesos: —Pinguiate arosata yamai. Páganëneri ira agáantiro jiesita. Aro yáganëneri. ");
INSERT INTO notNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Cara iniantacaro iriro ora nija pegacha obaa, te irogóte negaraca opaniaca. Irianti iromeraro ogóiguëro cara ipiaquero Jesos irironta jagaiguëro nija. Aro ira agáantiro jiesita icaimëri sërari águëro iina ");
INSERT INTO notNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","icabëri: —Ametaigaro eiro cara omagaro poguibatagani iróquimaro ora obaa caninajaro. Aique cara iróquimaca tojai ira igaimane; aro cara imëgotaigueri ora obaa te opënatima tojai. Carari obiro poguëro ora caninajaro obaa irooti yamai. ");
INSERT INTO notNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cara poeboroquë jitacha Caná cara Garireaquë yoguibatëro Jesos itasorintsite. Yoniaganca arota irogóigueri matsiguenga Iriro caninarisonori aisati sintsirisonori. Aro iquemisantaiguëri irogomere Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aique iáque Jesos cara Caperinaoquë. Itsibataro iniro aisati icarataiguëri ireinti aisati irogomere. Cara, itimaiguë arosata cataguiteri. ");
INSERT INTO notNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pënibaque orequima cataguiteri ora jitacha Pásicoa cara iquengapiantaiguiro joríojegui cara jiraisonori isotocaigai Ejípitoquë. Aro iáque Jesos Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iniopëri cara oquibequë pongotsi irasi Tosorintsi ira pimantaiguiri oisha, aisati sërari baaca aisati paroma. Aintasati ira campiatiri quirequi. ");
INSERT INTO notNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yobetsiquëro iripasamento Jesos iroonti sogatsa. Aique ijocaiguëri antagaisati pimantatsiri aisati ibaacate aisati iroishate. Yosibiquero imesane ira campiatiri quirequi yosocaguitëri iguireguite. ");
INSERT INTO notNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Icanqueri pimantatsiri paroma: —¡Páganëri sotora! ¡Quero popimantaguetiri yaca ibangoquëca Pabati Tosorintsi! ");
INSERT INTO notNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aique iquengaigairo irogomere ora Sanguenari cara ocanti: Nocogasanti iraniacaninatiro pobango matsiguenga. Iroro ora inguisanijintaguëquina naro aisati ingoque iróquena. ");
INSERT INTO notNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yosamitaiguëri joríojegui: —¿Pairo poniagaiguëna ora nogóontimi Obiro cara igáquemi Tosorintsi picanquero negaca? ");
INSERT INTO notNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yotabitanëri Jesos: —Pogomeriguetiro oca pongotsica. Cara omoncaraquima maba cataguiteri nobetsicairo aisati. ");
INSERT INTO notNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Icantaiguë jorío: —Tojai osarini ocarati 46 cara pobetsiquëngani oca oquibe pongotsica irasi Tosorintsi. ¿Yamai picanque Obiro pobetsicairo mabanti cataguiteri? ");
INSERT INTO notNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Carari Jesos te irinibatocotiro pongotsisonori oquibe. Iroonti inibatëgotë ibatsasonori aisatinta ocantaro pibega ibango Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iroro cara aroqueque icamaque Jesos icaniatanai, iquengaigairo irogomere oca nibarintsica, aro iquemisantaiguëro Sanguenari aisati iquemisanque ora yogometaiguëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cara Jerosarénquë aiti cataguiteripague jitacha Pásicoa cara yapatotaigaa jorío. Itasorintsitaguetasanotapë Jesos iquemisantacagopëri tojai matsiguenga cara iniaigabaquero iquemisantaigabaquero ora icanque Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Carari te imemari ira matsiguenga igóquerinta ora iquengaigaca omagaro. ");
INSERT INTO notNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Igóque ora iquianca antagaisati matsiguenga. Aro te ingogue basini comantirine ati icanta matsiguenga igóquerinta iraneingomentojeguiquë sërari. ");
INSERT INTO notNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ainta inasegui sërari jitacha Nicoremo. Iriro bariseo. Aisati iriro itingomi jorío. Aintasati basini itingomipague jorío. ");
INSERT INTO notNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cara tsitiniriquë ipocasipëri Jesos Nicoremo, icampëri: —Ogometinari, nigóiguë Obiro iragátane Tosorintsi tenta irineni pairiraca intasorintsitë cantimine pibega Obiro pitasorintsitasanoti queroca itsibatari Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yotabitobëri Jesos icabëri: —Nangantasantëmini, queroca Tosorintsi itimacagajiri matsiguenga yoganiasëretairi, aisati queroca ibogai irirai, quero yareta Jonogaguitequë cara itimi Tosorintsi aisati igáanti Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yosamitëri Nicoremo: —Aroca antiasiparitanë ¿Atiroco anganaima cara iboganaje aisati? ¿Atiroco anganaima cara anganajiro aniro cara iboganaje aisati? ");
INSERT INTO notNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Icomantëri Jesos: —Nangantasantëmini queroca itimacagajiri yoganiasëretairi matsiguenga Tosorintsi cara Irinibarequë aisati Isërequë Tosorintsi, quero iáti Jonogaguitequë cara itimi Tosorintsi aisati cara igáanti Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ira otsomaaque iniro, irianti imatsiguenga sërari. Ira yoganiasëretairi itimacagaji Isërequë Tosorintsi, imatsiguengatacari Tosorintsi aisati. ");
INSERT INTO notNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Quero piquenganeintasanta aisati querootisati omabocaguimi ora nacanquemi: “Panibanibi intimacagajimi Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ora coguentima ocoguentimaguiteti. Piquemobëtiguiro cara ojigocanëma, carari te pigóte negaraca oquenopë, teatisati te pigóte negaraca ojátagueque. Aisati ocantari ibega ira itimacagaji Isërequë Tosorintsi. Pigótocoqueri ira irirai itimacagaji Isërequë carari te pineiro Isëre Tosorintsi tenta oneingani. ");
INSERT INTO notNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aique yosamitairi Nicoremo: —¿Atiroco ocanta oca picanquinaca? ");
INSERT INTO notNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yotabitanëri Jesos icanqueri: —¿Obiro ogomeantatsi cara omatsiguengaquë teco pigótiro oca nacanquimica? ");
INSERT INTO notNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aisonori nanganquimi ninibatëgotëro ora nigóigui. Aisati ora naniaiguë irooti nocomantëgotë. Carari obirojegui teni pinguemisantaigabaquero ora nocomantaiguimi. ");
INSERT INTO notNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Teca pinguemiro cara ninibatëgotaiguëmiro ora inatsi quibatsica, ¿Atirasatico pingantiro cara pinguemobëro cara nanibatëgotëro ora paniënguicha Tosorintsiquë? ");
INSERT INTO notNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Te pairi játatsine Jonogaguitequë. Paniro Naro, Naronta paniënguicha Jonogaguitequë. Nomatsiguengatapë cara niboguë yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jiraisonori Moisés itinaaquero irosiacagomento marangue jonoquë anchapoaquë cara te ontimingani aisa onganquima inganquina nibega Naro cara iribëquëgotëquina jonoquë ");
INSERT INTO notNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","arota pairiraca quemisanquinane iraganiasëretairi intimacagajiri Tosorintsi arota quero iáti Sharincabeniquë, carari përosati cara intiomoquena Jonogaguitequë. Përo icanque Jesos: ");
INSERT INTO notNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Tojaisonorinta Tosorintsi inintasanoiguiri matsiguengajegui, igáquena yaca quibatsica. Naro Itomi paniro. Igáquena arota pairiraca quemisanquinane nantimacagajiri, quero iáti Sharincabeniquë, carari përosati intiomoquena Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tosorintsi teni iroro iragábiritina Naro Itomi yaca quibatsica cara nangasitígataigueri matsiguenga. Igáquena arota nagabisaicoqueri matsiguenga ira quemisanquinane. ");
INSERT INTO notNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Quero icasitígatiri Tosorintsi ira quemisanquina Naro Itomi paniro, carari aroque icomantëgotëri ira te inguemisantina iriátë Sharincabeniquë tenta inguemisantina. ");
INSERT INTO notNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","21","Cara icantagueigui matsiguenga ora te onganinate, icoguini inganquero cara tsitiniriquë. Teni iraninte ingantiro cara cataguiteriquë tenta iraninte iripasiguite cara iraniaiguëri imatsiguenga. Naro aisati nacantaro pibega cataguiteri aronta nopasiquitacaguiri cara nogótacaguiri matsiguenga icantagueigui ora te pojocajenga arota iripasiguitanë. Iroro iguisaneintobitaiguina. Aroque Tosorintsi icomantëgotaiguëri iriro iriátë Sharincabeniquë tenta iranintaigue inguemisantina. Irari ira cantaguetiro ora caninaro irotsitipëna tenta iripasiguiteni. Iroonti icanque caninasati cara imitocoqueri iriro Tosorintsi. Iroro oca icanqueri Jesos ira Nicoremo. ");
INSERT INTO notNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aique iáigai Jesos aisati irogomero cara Joreaquë. Cosamani itimaiguë cara ibaotisataiguëri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aisati Joan ibaotisatantagueque cara poeboroquë jitacha Enón aitoniatiquë basini poeboro jitacha Sarím aronta pini nija tojai. Ipogaigapë matsiguenga ibaotisataigabaqueri Joan ");
INSERT INTO notNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","cara teraiquerai iromingueri Eroris ira Joan. ");
INSERT INTO notNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ipëgatsatobaca irogomere Joan aisati itingomi jorío. Inibatëgotëro cara ati ingantima iraguëtetaima matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ipocasipëri jorío icampëri ira Joan: —Ogometinari, Ira tsipatimi cara onamijaquë Jorirán cara iconteti paba, Ira pinibatëgotë cani, yamai ibaotisatëri matsiguenga. Yoguiataiguëri tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yotabitanëri Joan icanque: —Quero pairi asintachane pairoraca, queroca ipiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Piquemaiguëna obineniati cani nocomantëmi catingasati cara cagarina naro Quirisito Agabisaicoontatsiri. Patiro igáquena Tosorintsi nongomantëgotiri cara teraiquerai ingonijapë Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Naro cantari iramigote ira águëro iina. Iramigote inganinatanë cara inguemobëro irinibare. Nacaninatë naro yamai aroquenta yoguiataiganaqueri Jesos matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aiquero iriátanëtigue Iriro irobatanëna. Carari naro aiquero najátanëtigue nangarantanae. ");
INSERT INTO notNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ira paniacha jonoquë Iriro obatatsi antagaisati. Naro paniacha quibatsica. Ninibatëgotiro ora inatsi quibatsiquë. Quirisito iquenopë Jonogaguitequë. Iriro obatiro antagaisati Irironta Atingomi. ");
INSERT INTO notNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Icomantëgotëro Iriro ora iniaque aisati ora iquemaque cara jonoquë, carari teni inguemisantiri matsiguenga ora icanti Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ira quemisantobërone ora icomanti Quirisito, irogóque cara icanti Tosorintsi ora aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tosorintsi agáqueri Quirisito. Inibatiro Irinibare Tosorintsi aroquenta ipasanoqueri Caninaro Isëre Tosorintsi Ira Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aisati inintasanoqueri Itomi Tosorintsi, iroro ipasanotaguëqueri omagaro arota iragáantaguetiro. ");
INSERT INTO notNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ira quemisanquerine Itomi Tosorintsi intimacagajiri Tosorintsi aisati përosati intiomoqueri cara Jonogaguitequë. Ira te iraninte inguemisantiri Itomi quero itiomotiri, caraanti iriátë Sharincabeniquë aroquenta iguisëri iriro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Ira barisesoegui iquemocoqueri Jesos cara ibaotisataiguëri tojai matsiguenga. Ibatajiri Joan tojaininta irogomere Jesos. Carari te Iriro baotisatantatsine Jesos irianti igáti irogomere imaotisataigueri matsiguenga. Cara igóque Jesos ora icanti bariseo, aro iáigai Jesos aisa irogomere, isotocaiganaji cara Joreaquë, aique iáigai aiquero cara Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Icoque Jesos inguenantaigaimaro abatsi quenacha Samariaquë. ");
INSERT INTO notNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yareca poeboroquë jitacha Sicar aronisati iguebatsitequë José ora ipëri cara jiraisonori iriri jitacha Jacob. ");
INSERT INTO notNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pinasegui iguinare Jacob cara yáguiro nija jirai. Aro imagotë Jesos isobigopë iguinarequë catinga paba. ");
INSERT INTO notNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Aroqueque igáqueri irogomere Jesos iriáiguë poeboroquë iromanantaiguënte perintsi. Aro pipogopë tsinane Samariasato cara onosiquëgotënti nija. Yobetsatobacaro Jesos icabëro: —Pomena nija. ");
INSERT INTO notNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ocanqueri Samariasato: —¿Pairo pamanobiquina nija Obiro jorío? Naanti Samariasato. Ocanque negaca iguisanijintobaganinta joríojegui aisati ira Samariasatiegui. ");
INSERT INTO notNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yotabitanëro Jesos: —Arome pigóque ora icogabeca Tosorintsi imëmi aisati pigóquiname Naro manimiro nija, aro pomanocoquina nija obiro, aro nomëmi nija timacagantatsiri arota pintimanë përosati. ");
INSERT INTO notNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ocanqueri tsinane: —Ogomeantatsiri, teni ine obiro ora páganquimaro nija aisati tsomaguisonorinta pini nija. ¿Nega páguëro ora nija timacagantatsiri ora pomëna cara nantimanë përosati? ");
INSERT INTO notNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacob nomatsiguenga jiraisonori iquiaquinaro oca cara nacaaiguiro ora yóga iriro jirai aisati itomijegui omagaro ibiraegui. Iroonti caninajaro nija. ¿Yamai pijiquenico pomëna basini nija caninajarisonori? ¿Pobaquerinico Obiro Jacob? ");
INSERT INTO notNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yotabitanëro Jesos: —Antagaisati ira ógaro oca nijaca, aisati iromiretae. ");
INSERT INTO notNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Irari óguëmarone nija ora nomëri Naro quero imiretai. Iroronta nija ora nomëri ocontetanëri isërequë onganquima cara picontiati nija. Ongantacaquimari përosati intiomoqueri Tosorintsi cara Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aique ocanqueri tsinane: —Ogomeantatsiri, pomena ora nija timacagantatsiri querota nomiretai, querootisati nipocaji yaca nonosiquëgotai nija. ");
INSERT INTO notNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Icanquero Jesos: —Pijáte pingaimëntiri pijime popocaigapë yaca. ");
INSERT INTO notNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Potabitanëri iroro: —Teni irine najime. Jesos icomantëro icanque: —Aisonori teni irine pijime. ");
INSERT INTO notNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aroque páguë pijime icarati pabocorooti. Irari ira águimi yamai cagari pijime. Aisonori picanque teni irine pijime. ");
INSERT INTO notNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ocanqueri tsinane: —Ogomeantatsiri, ¿Ati picanta cara pigótocoquina? ¿Obiroco comantantatsiri? ");
INSERT INTO notNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jirai yamanocoqueri nomatsiguengajegui Tosorintsi yaca oguitojaica. Obirojegui jorío picantaigui te ongomeite yaca. Picantaigui patiro nomanocotaiguëri canta Jerosarénquë. ¿Nega ocaninati nomanocotaigueri Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yotabitanëro Jesos: —Pinguemisantina, tsinane. Coraque cataguiteri cara quero pamanocotiri Pabati Tosorintsi yaca oguitojaica querootisati pamanocotiri canta Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pamanocotaiguiri obiro Ira te pigóigueri. Naroegui jorío nigóiguiri Ira namanocotaigui Irironta agabisaicoontatsi ipaniaca cara naroeguiquë Irironta jorío. ");
INSERT INTO notNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yamai aroque pareca cataguiteri cara iromanocotasantiri quemisantatsiri aronta omitocotiri Isëre Tosorintsi ogomequeri ora aisonori. Iroronta icogui Pabati Tosorintsi iromaniri antagaisati ira coguiri Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Teni iraneingani Tosorintsi tenta ine ibatsa, iroonti Isëre. Iroronta patiro yamanocotiri isërequë matsiguenga aisati yamanocoontari Irinibarequë Tosorintsi ora aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ocanqueri tsinane: —Nigóque cara iribocapë Agabisaicoontatsiri Ira jitacha Quirisito aisati. Cara iribocapë ingomantagueiguenaro omagaro. ");
INSERT INTO notNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Icanquero Jesos: Naromë Quirisito ira nibatacaguimira. ");
INSERT INTO notNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aito cara yaretaigapa irogomere Jesos. Iquenganeintaiganaca cara inibataseguiro Jesos tsinane, carari te pairi osamitapërine ¿Pairo pinibabiritiro? ");
INSERT INTO notNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aique ojocanëro tsinane ogaamento piáque poeboroquë. Ocomantaguequeri omatsiguenga: ");
INSERT INTO notNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Popocaigapë piniaigueri sërari aroque icomantënaro antagaisati ora nacantagueti. ¿Iriropeera Quirisito? ");
INSERT INTO notNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Isotocaiganaque Samariasati poeboroquë aique iáiguë cara inasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Teraiquerai iraretaigapëmari Samariasati icantopiantëri Jesos irogomere icanqueri: —Ogometinari, pope. ");
INSERT INTO notNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Carari icanqueri Iriro: —Aiti noperi ora te pigóiguero obiro. ");
INSERT INTO notNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aique yosamitobaganaca irogomere icanque: —¿Aintaco matsiguenga mapëneri iraperi? ");
INSERT INTO notNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Icanque Jesos: —Cara aroque opaiguë, teni anguenguero operi. Aisati cara nanganquero Naro aisati notsonquineri ora ininti Tosorintsi Ira agáquina, nanganinatanë. Teni nanguenguero noperi tenta natasegue. ");
INSERT INTO notNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Picantaigui obiro: “Itsibasatinibani manchacori obiguitëma tirigo”, carari nanganquemi Naro: “Pinetsaigueri matsiguenga. Irirojegui cantaca osamatagasonori tirigo panibati obiguitëma. Ira matsiguenga panibati pinguemisantacaguiri”. ");
INSERT INTO notNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ira obiguitiro tirigo irágobëro ora iripënabentëri casintaro. Aisati ira quemisantacaguiri matsiguenga Naro pënabintërine. Ira quemisanquinane përosati intiomoqueri Pabati Tosorintsi cara Jonogaguitequë. Aro inganinaiguë pitirooti ira comantëgotënane aisati ira quemisantacaguirine matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aisonori cara ocanti nibarintsi: “Ira panguitatsi quero iriro águiro. Basiniati águërone”. Ipanguitiro poro matsiguenga oguitso iroonti Irinibare Tosorintsi, carari basini obiguitërone cara inguemisantacaguiri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nigátaiguimi obiro pobiguitaiguero ora ipanguitë basini. Aisa icanta icomantëgotëna basini. Yamai pogometaigueri obiro matsiguenga arota inguemisantina. ");
INSERT INTO notNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Iquemisantaigabaqueri arosonori Samariasati Ira Jesos aroquenta ocomantëgotëri tsinane cara ocanque: “Icomantënaro antagaisati ora nacantagueti”. ");
INSERT INTO notNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iroro icantobitaiguëri Samariasati Ira Jesos icanqueri: —Pintiomotaiganaquina yaca. Aro itimanë Jesos pite cataguiteri. ");
INSERT INTO notNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aro iquemisantaiguëri tojai basini Samariasati aroquenta iquemaigabaqueri Irinenisonori Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Icantaiguëro ora tsinane: —Pinibatëgotëri Jesos obiro carari te najitimi. Yamai naquemisantaiguiri aroquenta naquemaigabaqueri Irineniati Iriro. Nigóiguëri Iriro agabisaicotaiguërine omagaro matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cara pabisanaque pite cataguiteri yogaganaca Jesos irooti cara Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Irineniati cantëgotënguicha Jesos teni iraniacaninataigueri comantantatsiri imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cara yaretanaca Jesos Garireaquë, yágaigabaqueri caninasati aroquenta iniaiguëri Garireasati canta Jerosarénquë cara itasonganti Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aisati yarepaa Jesos cara poeboroquë jitacha Caná cara jirai ipiaquero nija obaa. Ainta iromeraro itingomi ipaniaca Caperinaoquë. Aro ijanaitë itomi. ");
INSERT INTO notNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cara iquemocotobairi Jesos iromeraro itingomi cara ipaniaa Jesos cara Joreaquë irooti Garireaquë, aro iatásiqueri Jesos Canáque, yamanocopëri: —Popogopë nobangoquë pigaguibegajinari notomi. Pënibaque ingamaque. ");
INSERT INTO notNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Icabëri Jesos: —Queroca nitasongantagueti, quero piquemisantaiguina. ");
INSERT INTO notNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yamanocopëri iromeraro itingomi icampëri: —Natingomi, panonganëma omanaque icami najaniquite. ");
INSERT INTO notNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yotabitanëri Jesos: —Popiganajima pobangoquë. Aroque ibeganaa pitomi. Iquemisanquero sërari ora icanqueri Jesos, aro ipiganaja. ");
INSERT INTO notNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cara yanonganaa pënibaque iraretajimaro ibango itonguibotaigacari iromeraro icomantobëri: —Ira pitomi tegotsitanai. ");
INSERT INTO notNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yosamitobëri ati ocanta yaropeique. Yotabitanëri: —Chopi aroque iparique paba pabisanaqueri janatigantsi. ");
INSERT INTO notNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yamai igóque iriri cara ibegaja itomi chopi cara icanqueri Jesos: “Aroque ibeganaa pitomi”. Aito cara iquemisantaiguëri Jesos iriro aisati omagaro imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ainta Jesos itimaji Garireaquë, ipaniaa cara Joreaquë. Ocarati yamai pite cara itasonganque Jesos cara yarepaa Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aique omoncaraca basini cataguiteri cara yapatotaigaa joríojegui, cara itonganaji Jesos aisati Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Cara Jerosarénquë pinasegui ogaare aitoniati omoro cara iquenacaguiri oisha. Irinibarequë jorío ojita Betesita aiti pabocorooti pongotsi. ");
INSERT INTO notNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Cara pongotsiquë ainta inariaiga tojai janaitaguetatsiri, comarajari, carancara, emëngari, omagaro. Yoguiaque cara irosebaaquero nija ");
INSERT INTO notNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ironomire Tosorintsi. Cara yaguëpë irosebaaquero nija, aique pairiraca obaquënguitsine ingaatë irobegajima pairoraca ojita ora óguëri. ");
INSERT INTO notNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ainta inasegui sërari ijanaitë tojaisonori osarini ocarati 38. ");
INSERT INTO notNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Inariaca irisomamintoquë. Iniopëri Jesos igópëri ijanaitë cosamani. Yosamitapëri: —¿Pininti pobegajima? ");
INSERT INTO notNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yotabitobëri janaitatsiri: —Nomatsiguenga, teni irine pairiraca cajaaquinane cara osebaatanëma nija. Iroontita najáque naro irobaquina basini ingaatë. ");
INSERT INTO notNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aro igáqueri Jesos: —Pingabiritima págairo pisamamento panëitanae. ");
INSERT INTO notNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aito ca ibeganaa. Yáganairo irisomaminto, yanëitanai. Ibeganaa sábaroquë. ");
INSERT INTO notNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iroro icantaguëqueri joríopague ira sërari janaitabitacha icanqueri: —Yamai iroonti sábaro. Teni ongomeite páganëro pisamamento. Jiraisonori isanguenaque Moisés ora quero atarobacaantaro eiro cataguiteriquë sábaro iroronta comagoriantague. ");
INSERT INTO notNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yotabitanëri sërari: —Ira aguibegajina igáquina: “Págairo pisamamento panëitanae”. ");
INSERT INTO notNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yosamitaiguëri jorío: —¿Pairo ijita ira agáquimi: “Págairo pisamamento panëitanae”? ");
INSERT INTO notNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Te irogóte pairiraca aguibegajiri aroquenta ipeganaca Jesos cara matsiguengajeguiquë. ");
INSERT INTO notNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aique iniajiri Jesos oguibequë pongotsi irasi Tosorintsi icanqueri: —Pinetse. Aroque pibeganaa. Quero pintaguetaji aisati ora te onganinate arota quero pitsipiriaji agabenisonori. ");
INSERT INTO notNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ipiganaja iriro cara joríojeguiquë icomantaiguëri cara yoguibegajiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iroro iguisanijintaguëqueri jorío Ira Jesos aroquenta itasonganque sábaroquë ora cataguiteri comagoriantague. ");
INSERT INTO notNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Carari icanqueri Jesos: —Pabati Tosorintsi përosati icantiro ora caninari irooti yamai. Aisati nacantari Iriro nacantiro ora caninari. ¿Pairo nojocobiquero cara sábaroquë? ");
INSERT INTO notNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aroquenta Jesos icanque cara Iriro Iriri Tosorintsi cara aisati icantari Tosorintsi, aisatinta itarobacaati Jesos sábaroquë, icogasanotaigabitaca jorío iróguirime Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Icanque Jesos: —Nangantasantëmini Naro Itomi Tosorintsi teni nangantasitima Naro pairoraca. Iroonti nanganque ora icanti Pabati. Ora omagaro icanti Iriro, aisati nanganquero Naronta Itomi. ");
INSERT INTO notNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Inintasanotina Pabati Naronta Itomi. Yoniaguinaro antagaisati ora icanti Iriro. Aisati ironijaguina basini tojai arota pinguenganeintasantaiganaquima. ");
INSERT INTO notNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cara icabiriqueri yoganiatairi Pabati ira camënguitsi, aisa nacantari Naro naganiatairi pairiraca ira naninti. ");
INSERT INTO notNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yamai Pabati teni ingomantëgotaguetiri matsiguenga ora inganque. Ipënaro Naro cara nogóontaiguëmari antagaisati matsiguenga nongomantëgotëri pairoraca ingantaiguë aisati negaraca iriáiguë. ");
INSERT INTO notNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Icanquero Pabati negaca arota omagaro iraniacaninatina caninarina Naronta Itomi aisati icanta iniacaninatiri Pabati. Ira te iraniacaninatina Naro Itomi, teatisati iraniacaninatiri Pabati Ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nangantasantaiguëmini ora aisonori ira quemobërone nasi nanibare aisati inguemisanqueri Pabati Tosorintsi Ira agáquina, përosati intiomoqueri Tosorintsi cara Jonogaguitequë. Quero icasitígatiri Pabati. Jirai iáigabitaca aiquero Sharincabeniquë, carari yamai iriáigae cara Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nangantasantaiguëmini aroque omoncaraca cataguiteri cara iraegui játënguitsineme aiquero Sharincabeniquë yamai cara inguemobëro nanibare aro nantimacaguiri Naronta Itomi Tosorintsi, iriáiguë cara Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aisati nacantari ibega Pabati catimaneri aisati timacagantatsiri, Iriro pënaro natimanë Naati aisati nantimacaguiri matsiguenga Naronta Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aisati itingomiquina ipënaro cara nongomantëgotaiguëri matsiguengajegui ora inganque aronta nopaniaca Jonogaguitequë cara nomatsiguengatasantapë cara niboguë. ");
INSERT INTO notNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Quero piquenganeintasanota cara orequima cataguiteri cara antagaisati igamagaegui inguemobëro nasi nanibare, ");
INSERT INTO notNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aro ingabiritanaima inganiatanae irisotocanë imoropaguequë, ira cantaguetiro caninaro përosati intiomoqueri Tosorintsi Jonogaguitequë. Irari cantaguetiro ora te onganinate nongomantëgotëri antagaisati cara iriáguë Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Teni nangantasitima pairoraca ora nocogui Naro. Iroonti ora inganquina Tosorintsi nongomantëgotaiguëri matsiguenga. Patiro nanganque ora icogui Ira agáquina. Perosa icanqueri jorío Jesos: ");
INSERT INTO notNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Aroca Naati comantëgotënguichane, aro pingantocoquina Naro notsoigani. ");
INSERT INTO notNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ainta basini comantëgotëna. Nigóque ora icomantëgotëna iroonti aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Cani posamitagantëri obirojegui ira Joan; ora icomantaiguëmi iroro aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Carari Naanti Itomi Tosorintsi; jemita ora ingomantëgotëna matsiguenga. Patiro nacanquimiro arota iragabisaicotaigaimi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Joan aisati icantaro pibega obotagantsi cara posangueguitetasanoti. Arosata cataguiteri picaninatomotaiguëri obirojegui. ");
INSERT INTO notNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Irinibare Joan ogótacagaiguëmi cara Naro Itomi Tosorintsi. Aisati ogótasantaguimi ora nacanque Naro cara nitasongobentiri matsiguenga cara igáquina Pabati. Patiro nanganque ora igáque Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aisati Ira agáquina icomantëgotëna carari te pinguemaigabaquero Irinibare teatisati piniaigueri atiraca icanta Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Teni pinguemisantaiguero obiro Irinibare Tosorintsi tenta pinguemisantaiguena Naro cara igáquina Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pinibatasantaiguiro caninasati ora Sanguenari pijiquenta obirojegui ontimacaquemi përosati jonoquë, carari Naanti ocomantëgoti. ");
INSERT INTO notNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Teni pinintaigue pabentina Naro pinguemisantina cara pintiomotaigueri Tosorintsi përosati Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Teni nongogue piniacaninatasitaiguena ");
INSERT INTO notNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","nigóiguëminta obirojegui teni pinintaigueri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nipoque igáquenanta Pabati, carari te pinguemisantaigabaquina. Carari iribocasitimaca ira matobiantatsi, irianti pinguemisantaigabaque. ");
INSERT INTO notNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Teni pinguemisantobinte obirojegui; iroontinta picogaigui piniacaninatobaguima obirojegui matsiguenga. Teni pingogaigue iraniacaninatimi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Quero pijitina Naro comantëgotëmine Pabatiquë. Pijitabeca piquemisanqueri Moisés carari iriati Moisés comantëgotaiguëmine. ");
INSERT INTO notNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arome pinguemisanqueri Moisés, aisati pinguemisantaiguename Naro Naronta isanguenatocoque Moisés. ");
INSERT INTO notNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Carari teca pinguemisantaiguero isanguenare Moisés, ¿Atiroco onganquima pinguemisantaiguëro nasi nanibare? ");
INSERT INTO notNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Itsonquero irinibare Jesos cara Jerosarénquë, aique iátaji cara Garireaquë. Imontianaca angaare jitacha Garirea aisati ojita Tiberias. ");
INSERT INTO notNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yoguiataiguëri tojaisonori matsiguenga iniaiguërinta Jesos cara itasongobenqueri janaitatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Cara pënibaque orequima cataguiteripague ora jitacha Pásicoa cara irapatotaiguëma joríojegui, itongaiganaque oguitojaquë Jesos aisati irogomere isobicaigapë. ");
INSERT INTO notNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iniaigabaqueri Jesos arosonori matsiguenga yoguiataigapëri. Icanqueri ira Jeripe: —¿Nega omanantëneri pan ora irapaiguë? ");
INSERT INTO notNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Icanque Jesos negaca arota iraniantëmari Jeripe. Aroque igóque Jesos ora inganque Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Yotabitanëri Jeripe: —Aroca omanantë pan ora pënatacha 200 tenario, quero cotonguiboro cara irapaiguë omagaro arosata. Paniro tenario yágui ira tarobacaatatsi poro cataguiteri. ");
INSERT INTO notNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Poro irogomere Jesos ijita Antiris ireinti Simón Peroro icanqueri: ");
INSERT INTO notNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ainta yaca janequi sërari yamapë pabocorooti pan aisati pite itiomijani sima, carari quero cotonguiboro tojainta matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Igáqueri irogomere Jesos icanque: —Pigasobicaigueri. Aiti pinasegui caninaro tobarisi tojai. Isobicaiguë sërari cara tobarisiquë icarati 5,000. ");
INSERT INTO notNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yáguëro pan Jesos icarasiaqueri Tosorintsi, aro yotsatengaiguëri ira sobicaigatsi. Aisati ipaguetaiguëri sima. Ora ocarati icogaigui matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cara iquemaigaca omagaro, icanqueri irogomere Jesos: —Pobiitaguetajiro ora ingarataiguë, arota quero omainatëmata. ");
INSERT INTO notNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aro yobiitaguetajiro iagajiro ocarataji 12 cantiri ora angaraquenguicha pan aroquenta iquemaigaca tojaisonori matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Cara iniaiguërinta matsiguenga Ira Jesos cara yomitojaiguëro pan aisati sima itasorintsitequë, aro icanë: —Aisonori Ica Iriro comantantatsiri Ira boquënguitsine yaca quibatsica Ira oguiaiguë cosamani. ");
INSERT INTO notNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Igóque Jesos cara icogaiguë matsiguenga iráganëri inganqueri itingomi. Aro itonganaque Jesos aisati, iáque casiriconiati. ");
INSERT INTO notNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cara ochapinitanë yanongaiganaca irogomere Jesos yagaitanë angaarequë. ");
INSERT INTO notNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yotetaiganaca pitotsiquë iátocoiguë aiquero cara antatinta Caperinaoquë. Aroque otsitinique. Teraiquerai iraretima Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aro oparintanaca omotoncaatanë angaare sintsironta coguentima. ");
INSERT INTO notNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Icomataiganaque pabocorooti quirómetoro cara iniaigabaqueri Jesos yanëiapëro angaare jonoicanti. Itsorogaiganaque irogomere. ");
INSERT INTO notNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Icampëri Jesos: —Naanti. Quero pitsorogaigui. ");
INSERT INTO notNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aique icaninataiganaque yotetaigabajiri Jesos pitotsiquë. Aiguito iniaigaa canta onamijaquë canta iriátëri. ");
INSERT INTO notNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Itimaiguë matsiguengajegui cara yapaiguë pan. Oquëtaguetanë igóiguë teni ine pitotsi. Patiro ora yotetaiganaca irogomere Jesos iátocoiguë, carari Jesos te intsibatanaimari. ");
INSERT INTO notNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Paretaiga basini pitotsipague opaniaca Tiberiaquë aronisati cara yapaiguëro pan matsiguenga cara icarasiabintëro Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Cara igóiguë teni irinaje Jesos irirojeguiquë teatisati irogomere, yotetaiganaca pitotsipaguequë irooti Caperinaoquë cara ingogaigairi Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cara iniaigairi antatinta, yosamitapairi: —Ogometinari, ¿Ati ocanta pipoque yaca? ");
INSERT INTO notNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yotabitanëri Jesos icantaiguëri: —Nangantasantëmini nigóiguëmi teni pingogaiguena cara nitasonganti, carari picogaiguina aroquenta papaiguëro poperi piquemaigaca. ");
INSERT INTO notNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Quero picoguiro perintsi ora peganënguichane, ora pingogue perintsi timagantatsiri ontimacaguimi Jonogaguitequë përosati ora nomëmira Naronta matsiguengatapënguitsi. Ipënaro Pabati Tosorintsi cara nomaiguëmiro irorota timaquimine obirojegui pisërequë. ");
INSERT INTO notNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yosamitaiguëri: —¿Pairo nangantaiguë ora ininti Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yotabitanëri Jesos: —Icoguini Tosorintsi pinguemisantina Naro Irironta agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aique yosamitaigairi: —¿Yamai pairo pitasonguë aisati arota naniobëro nanguemisantimi? ¿Pairo pinti? ");
INSERT INTO notNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Omatsiguenga jirai yapaiguëro iraperi ora jitacha maná cara tera ontimengani. Ocantocoquero Sanguenari: Ipaiguëri Tosorintsi perintsi paniacha jonoquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Icantaiguëri Jesos: Nangantasantëmini, teni iriro paiguemirone Moisés ora perintsi paniacha jonoquë, carari yamai imaiguëmi Pabati perintsi irorosonori paniënguichane jonoquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ora perintsi imaiguëmi Tosorintsi yamai, Irianti sërari Ira masobingopënguitsi cara Jonogaguitequë. Itimacaqueri matsiguenga yaca quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Icantaiguëri matsiguenga Ira Jesos: —Natingomi, përosati pomëntaiguenaro perintsi ora picantocoque. ");
INSERT INTO notNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Icanqueri Jesos: —Naro perintsi timagantatsiri. Cara popë poperi, caraquenta pitasegae aisati. Cara póga nija, caraquenta pomiretae. Carari cara pinguemisantaiguënanica, pinganinasëretanë përosati. Pinguemasëretaiguëmaro ora perintsi paniacha Jonogaguitequë. Naanti cantaca perintsi paniacha jonoquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piniaiguëna obirojegui carari aroque nacanquemi teni pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Antagaisati matsiguenga ira ipina Pabati iribocasitapëna Naro. Pairiraca bocasitapënane coshoni noguëmari quero nojocajiri sotoquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nopaniacanta Jonogaguitequë nanganque ora ininque Ira agáquina. Teni nangante ora nocogui Naro. ");
INSERT INTO notNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ira agáquina ininti quero nobeguëmatiri paniro ira ipëna, carari nangábintsasantëri irooti cara nopocaje naganiatairi najátacaqueri jonoquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ininti Pabati Ira agáquina antagaisati niaiguënane quemisantaiguënane Naro matsiguengatapënguitsi, përosati intiomoqueri Tosorintsi Jonogaguitequë. Cara nopigaima nangabiriqueri náganëri jonoquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yabentaigaca joríojegui aroquenta icanque Jesos: “Naro yamai perintsi paniacha Jonogaguitequë”. ");
INSERT INTO notNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Icantobaca jorío: —¿Cagarico Jesos Ira itomi José? Nigótiri iriri aisati iniro. ¿Pairo icantobique yamai: “Nopaniaca Jonogaguitequë”? ");
INSERT INTO notNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Icantaiguëri Jesos: —Quero pabentaiga. ");
INSERT INTO notNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Quero ipocasitina matsiguenga iriati queroca Iriro agátinarine Pabati Ira agáquina Naro. Aisati nangabiritajiri naganiatairi cara nopocaje aiquenta. ");
INSERT INTO notNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Isanguenataiguë comantantsiripague jirai: Irogometaiguëri Tosorintsi omagaro matsiguenga. Antagaisati ira quemisanquerine Pabati ora yogomequeri iribocasitapëna Naro. ");
INSERT INTO notNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Te pairi neirine Pabati. Paniro Naro aronta nopaniaca Iriroquë. ");
INSERT INTO notNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nangantasantëmini pairiraca quemisanquinane nantimacaqueri cara intiomoqueri Tosorintsi Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","—Naro perintsi timagantatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jirai pomatsiguenga yapaiguëro perintsi jitacha maná cara tera ontimengani. Carari icamaiguë antagaisati. ");
INSERT INTO notNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Oca perintsi ninibatëgotica opaniaca jonoquë, aroca irapëro matsiguenga quero icamaji. ");
INSERT INTO notNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naro perintsi timagantatsiri. Nopaniaca jonoquë aroca irapëro oca perintsica pairiraca matsiguenga intimacaqueri Pabati Tosorintsi përosati. Oca perintsi nomërica iroonti nasi nobatsa. Nomaiguëri matsiguenga arota intimacaganëri iriro përosati. ");
INSERT INTO notNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aique yosamitobaca jorío icanque: —¿Atiroco ingantima Iriro cara imacáiro ibatsa ajaguëri? ");
INSERT INTO notNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Icanqueri Jesos: —Aisonori nangantasantëmini nomatsiguengatapë. Queroca paaguiro nobatsa querootisatica pógaro naraa, quero pitimi Tosorintsiquë tenta pigótiri. ");
INSERT INTO notNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ira jaguërone nobatsa aisati óguëmarone naraa aro intimacaqueri Tosorintsi Jonogaguitequë përosati. Aisati nangabiritajiri naganiatairi cara nopocaje. ");
INSERT INTO notNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nobatsa iroronta perintsisonori aisati naraa iroronta omiretagantsisonori. ");
INSERT INTO notNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ira jaguërone nobatsa aisati óguëmarone naraa inguengasëretina, aro intiomoquina jonoquë. Coshoni iroquina Naro aisati coshoni noguëri iriro. ");
INSERT INTO notNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ira agáquina Pabati Irironta timagantatsi. Naro përosati natiomotiri. Aisa icanta ira jaguënane nantimacaqueri. ");
INSERT INTO notNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ninibatëgotiro perintsi opaniaca jonoquë. Teni aisati ongantimaro pibega perintsi ora yapaiguë pomatsiguenga jiraisonori jitacha maná. Icamaiguë iriro. Carari ira përone oca perintsica ninibatëgotica përosati intimaque Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Antagaisati oca yogomeantëca Jesos inibatëro cara yapatotaiga jorío cara poeboroquë jitacha Caperinao. ");
INSERT INTO notNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aroqueque yogomeantë Jesos, ainta ira aguiatëri icantobaca: —Comëtaro oca nibarintsica. ¿Pairi quemobërone? ");
INSERT INTO notNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Igóque Jesos cara yabentaigacaro icomëtaigabacaro irinibare, yosamitëri: —¿Teco ongomeitomotimi oca? ");
INSERT INTO notNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ati pingantaiganaque aroca piniaigabaquina nagainocanaima cara nopaniaca jirai? ");
INSERT INTO notNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Itimaque matsiguenga aitinta isëre. Queroca pini isëre irianti igamaga. Oca nibarintsica ninibatimica ontimacaquemi përosati jonoquë; cara pinguemisantobëro, Isëre Tosorintsi ontimacaquemi. ");
INSERT INTO notNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Përosati ainta obirojeguiquë ira te inguemisantina. Cara jiraisonori cara irirai parintënguicha igóitacari Jesos ira te inguemisantiri aisati ira ágagantërine. ");
INSERT INTO notNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aisati icanque Jesos: —Iroro nacantaguëtaiguëmi quero ipocasitina matsiguenga irianti. Patiro iromapënarica Pabati iribocasitapëna. ");
INSERT INTO notNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tojai ira aguiataigabitari Jesos aique ijocaiganajiri, te intsibataimari aisati. ");
INSERT INTO notNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aro yosamitaiguëri Jesos ira irogomere icarati 12: —¿Aisatico picogaigui obiro pijáigae? ");
INSERT INTO notNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yotabitanëri Simón Peroro icanqueri: —Natingomi, teni irinaje basini ira naguiataigae. Patiro pasi pinibare ontimacagaiguëna përosati. ");
INSERT INTO notNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Obiro naquemisantaiguë aisati nigóiguimi Obiro caninarisonori Itomi Tosorintsi catimanerisonori. ");
INSERT INTO notNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yotabitanëri Jesos: —Nocoigaiguëmi obiro picarati 12, carari ainta poro obirojeguiquë iromeraro Satanás camagari. ");
INSERT INTO notNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesos inibatëgotëri Joras Cariotisati ira ágagantërine Ira Jesos cara matsiguengaquë catsimari. ");
INSERT INTO notNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aique iátagueque Jesos Garireaquë tenta iraninte iriáte Joreaquë icogaiguininta joríojegui iróqueri canta. ");
INSERT INTO notNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pënibaque orequima basini cataguiteri cara irapatotaiguëma joríojegui. Iquengaiguiro jorío cara jiraisonori isotocaigai Ejípitoquë cara itimaiguë ibangonaeguiquë. ");
INSERT INTO notNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ipocasipëri ireinti Jesos icampëri: —Pijáte canta Joreaquë arota iraniaiguemi pogomere cara pitasonganque canta. ");
INSERT INTO notNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pinintica irogóiguemi matsiguenga quero pitasonganti comanoroni. Poniagaiguemari omagaro matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Icanqueri negaca ireinti tenta inguemisantirini Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Icantaiguëri Jesos: —Terai oretima cataguiteri cara najáque Naro Joreaquë. Obirojegui pijátasiquima basinipague cataguiteri ocaninatomotiminta. ");
INSERT INTO notNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Quero iguisanijintaiguimi obiro matsiguenga, carari Naanti iguisanijintaigui Naronta ogótacagaiguëri ora icantagueti te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pijáigue obirojegui Jerosarénquë. Queroquerai niáti Naro terainta omoncaratima cataguiteri cara najáque. ");
INSERT INTO notNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aroque icanque negaca, përo cara inë Jesos Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cara iáiguë ireinti Jesos cara Jerosarénquë, aique iátaji Iriro comanoroni carari te ironijaguimari matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Cara Jerosarénquë icogaigabitacari Jesos jorío, icantobaca: —¿Atique? ¿Negaraco iquenaque? ");
INSERT INTO notNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tojai matsiguenga inibatëgotaiguiri Jesos. Ainta cantënguitsi: —Iriro caninari. Ainta basini cantënguitsi: —Teni ingomeite. Yamatobiqueri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tojai inibatëgotëri carari te irinibate catingasatiquë ipingaiguërininta itingomipague jorío. ");
INSERT INTO notNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aroque yapatotaigaca jorío cara Jerosarénquë aronibati cataguiteri cara otsonganaquima jiesita. Aro itonganaque Jesos icanaque oquibequë pongotsi irasi Tosorintsi, yogomeantapë. ");
INSERT INTO notNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iquenganeintaiganaca jorío, icantaiguë: —¿Negaraco igóque tojai Ica tenta irisanguenatasanteni? ");
INSERT INTO notNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yotabitaiganaqueri Jesos: —Teni nogomeantasitimaro Naro. Patirontiati nogomeantiro ora icanquina Ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pairiraca nintatsi ingante ora icocaqueri Tosorintsi irogóquero nogomeantane negaraca opaniaca, irasi Tosorintsi iroontico nasiati. ");
INSERT INTO notNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ira nibatocotacha iriati iroro ininti iraniacaninataguimari matsiguenga, irari nibatatsi aisonori patiro ininti iraniacaninatiri matsiguenga Ira agátiri. Ira nibatatsi negaca iriro caninari. Te intsoiguëma. ");
INSERT INTO notNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ipëmiro Moisés ora iragáantane Tosorintsi. ¿Aisonorico? Carari te poro quemisantirone obirojeguiquë. ¿Pairo picogobique pógaiguena Naro? ");
INSERT INTO notNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yotabitaiganaqueri joríojegui: —Teni pineicotajima. Inanquimini camagari. Teni pairi nintatsine iróguimi. ");
INSERT INTO notNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Icanqueri Jesos: —Patiro cara nitasonganque sábaroquë irooti piquenganeintasantantanaca. ");
INSERT INTO notNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Yogometaiguëmi Moisés ora pameta pitoitiri pitomijegui. Yogomeantiro Moisés ora icanque omatsiguenga jiraisonori. Cara sábaroquë pitoitëri pitomi arota pomoncaratiro irogomeantane Moisés, ¿Pairo piguisaneintobitaiguina Naro aroquenta noguibegasantëri janaitatsiri cara sábaroquë? ");
INSERT INTO notNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Quero pinibatëgotiri matsiguenga ora conijatasitacha. Querootisati picomantëgotasitari queroca pigótasantiri. ");
INSERT INTO notNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ainta Jerosaresati icantobaca: —¿Iriroco Ira icogaigui iróguiri? ");
INSERT INTO notNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Pinetseri! Yogometaiguiri antagaisati matsiguenga carari te ingantaigueri pairoraca natingomipague. ¿Aisonorico igóiguiri Iriro Quirisito Ira agabisaicoontatsi? ");
INSERT INTO notNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Carari nigóiguiri Ica negaraca ipaniaca. Cara iribocapë Quirisito quero pairi ogótiri negaraca imaniëma. ");
INSERT INTO notNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Cara oquibequë pongotsi irasi Tosorintsi cara yogomeantasegui Jesos. Yotabitanëri catsigue: —Pijitaigabitaca pigóiguina Naro, aisati pijitaigabitaca pigóiguë negaraca nopaniaca. Carari te nopocasitima. Nipoque igáquinanta Ira aisonori. Teni pigóigueri obiro. ");
INSERT INTO notNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Naro nigótiri aronta nopaniaca cara Iriroquë. Aisati Irironta agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Icogaigabitaca iráquerime carari te pairi águirine terainta omoncaratima cataguiteri cara irágaiguëri. ");
INSERT INTO notNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ainta tojai quemisantaiguëri icanque: —Cara iriboquë Quirisito, ¿Aroco irobapëri Ica sërarica cara itasonganti? ");
INSERT INTO notNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Igóiguë bariseo cara inibatëgotëri matsiguenga Ira Jesos. Iriro aisa itingomi saseriroti agátaiguëri ira omisantiro oquibe pongotsi cara iráqueri Jesus. Yarepari. ");
INSERT INTO notNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Icabëri Jesos: —Arosataanti cataguiteri ninë obiroquë. Aique najátaje cara agáquinariquë. ");
INSERT INTO notNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pingogabetaigaina quero piniajina, queronta piáigui cara ninë. ");
INSERT INTO notNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aique iparintaca yosamitobaca jorío: —¿Atiroco iriátë Ica cara quero aniajiri? ¿Caraco iriátë cara iátagueque jorío jirai iguebatsitequë ira cagari jorío? ¿Cara irogometaiguëri ira cagari jorío? ");
INSERT INTO notNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Pairo ocanti irinibare cara icanque: “Pingogabetaigaina quero piniajina, queronta piáigui cara ninë”? ");
INSERT INTO notNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Cara cataguiteriquë carantatsiri cara yapatotaiga jorío, iroonti cataguiteriquë caninaro, icaimanë Jesos icanë catsigue: —Aintaca paniro imiretasantë isërequë, iribocasitapënata nomëri ora icogui. ");
INSERT INTO notNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cara ocanti Sanguenari, pairiraca quemisanquerine Quirisito, cara iraneingomentoquë ocontiatanëri nija timagantatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesos yosiacagantacaro nija iroonti icomantëgotëro Caninaro Isëre Tosorintsi inantasëretëmari antagaisati ira quemisanqueri Quirisito. Terai oguëpe Isëre Caninaro terainta iragainocanaima Jesos Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ainta inasegui matsiguenga cara iquemobëro irinibare Jesos icanque: Aisonori Ica sërarica Iriro comantantatsiri Ira isanguenatocoque Moisés jiraisonori Ira boquënguitsine. ");
INSERT INTO notNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ainta basini icanque: —Iriro Quirisitosonori. Ainta basini cantënguitsi: —¿Atiroco imaniëma Garireaquë Quirisito? ");
INSERT INTO notNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ocanti Sanguenari Quirisito imatsiguenga David itingomi jorío jiraisonori. Aisati ocanti imaniëma Berénquë iboeborotequë David. ");
INSERT INTO notNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aro ira matsiguenga icasiriconiatibiritaiganacari Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ainta icogaigabitaca iráguirime, carari te pairi cantirine. ");
INSERT INTO notNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ira omisantiro oquibe pongotsi ipigasiiganaja cara agátiririquë, ira bariseo aisati saseriroti. Yosamitaigabajiri bariseo: —¿Pairo te pomabiripëri? ");
INSERT INTO notNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yotabitanëri ira omisantiro pongotsi: —Teni irine sërari nibatatsi ibega Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yosamitairi bariseo: —¿Aisatico obirojegui yamatobitaiguëmi? ");
INSERT INTO notNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Iquemisanquerico itingomi jorío, aisati iquemisanquerico bariseo? Teni. ");
INSERT INTO notNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Carari icaegui matsiguengaca te irogótiro ora isanguenaque Moisés yamai ingasitígatëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ainta Nicoremo ira bocasitëri Jesos jirai. Irianti bariseo. Icanqueri: ");
INSERT INTO notNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Quero acasitígatiri pairiraca queroqueraica icomantëgota. Cara anguemaquerintata aroque ogóqueri pairoraca icanti, aro angasitígatëri. Intsomenta anguemirinta cara ocanti isanguenare Moisés. ");
INSERT INTO notNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Isintsitsaqueri: —¿Aisatico obiro popaniaca Garireaquë? Pinibatasantiro Sanguenari arota pigóte te pairi comantantatsiri paniachane Garireaquë. ");
INSERT INTO notNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aique iátaguetaji panirootipague cara ibangoquë. ");
INSERT INTO notNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Carari aique iáque Jesos oguitojaquë jitacha Olibos. ");
INSERT INTO notNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Oquëtaguetanë ipiganaja oquibequë pongotsi irasi Tosorintsi. Ipocasitaigapëri tojai matsiguenga. Isobiaque Jesos yogometaiguëri. ");
INSERT INTO notNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aro ira bariseo aisati ira ogomeantiro isanguenare Moisés yamaigapëro poro tsinane ora aguimintari ojime. Yamaigapëro yoguëro aganguisatiquë, icampëri Ira Jesos: ");
INSERT INTO notNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Ogometinari, oca tsinane naniaiguëro aique nágaiguëro paguimintasegari ojime. ");
INSERT INTO notNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ora isanguenare Moisés pigátaiguina nobasegaiguëro ora tsinane cantacha negaca. ¿Ati picanti Obiro? ");
INSERT INTO notNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Icantaiguë negaca cara iraniantimari Jesos arota ingantocotasitimari Iriro. Aro yoguitanaca Jesos isanguenabatsatanë quibatsiquë ibatsapacoquë. ");
INSERT INTO notNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Përosati yosamitapininqueri. Aro icabiritanaa Jesos icanqueri: —Aintaca obirojeguiquë pairiraca te ingantaguete ora te onganinate, iritsita miongatëquerone obatatsi mopë. ");
INSERT INTO notNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aisati yoguitanaa Jesos isanguenabatsatanai quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cara iquemobëro irinibare Jesos, aro antagaisati irirojegui igónijinca icantaguetironta ora te ongomeite. Isotocaiganaque bariseo porocague. Iritsita obaquenguitsi antiasiparipague aique isotocaiganaque ira basinipague. Irinibani Jesos, aisati tsinane aisati irogomerejegui. ");
INSERT INTO notNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aique icabiritanaa Jesos yosamitëro: —Tsinane, ¿Atini yamai ira comantëgotëmi? ¿Te pairi baseguimine? ");
INSERT INTO notNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ocanque: —Teni, Natingomi. Teni irinëmataje. Icanquero Jesos: —Querootisati nacasitígatimi Naro. Yamai pijátaje. Quero pogatsitairo ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aisati Jesos yogometajiri irogomere icanqueri: —Naro osangueguitesëretocotasantaguetiri omagaro matsiguenga arota nogótacaguiri ora icantagueti te onganinate. Aisati nacantaro pibega cataguiteri posangueguitetasanotiri iraneingomentoquë matsiguenga. Ira aguiatina quero yanëiti tsitiniriquë. Nosangueguitetocoqueri cara isërequë arota inguemisanquina intiomoquina Jonogaguitequë përosati. ");
INSERT INTO notNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aique icantaiguëri bariseo: —Picomantëgotaca Obiati. Notsoinguëmini. Teni pingantiro ora aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yotabitanëri Jesos: —Aroca nongomantëgotima Naati, nacantiro ora aisonori nigótinta Naro nega nopaniaca aisati nega najáque. Te pigóigue obiro negaraca nopaniaca teatisati pigóigue negaraca najáque. ");
INSERT INTO notNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Obirojegui cantëgoiguina terainta pigóiguero ora aisonori. Teni nangantocotiri pairiraca Naro. ");
INSERT INTO notNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Carari aroca nongomantëgotiri nanganquero ora aisonori quero nacantocotiri paniro Naro. Intsibatëna Pabati Irironta agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Isanguenarequë Moisés ocanti aroca pite sërari inguengaiguema cara ingomantëgotëri matsiguenga, pinguemisantiri. ");
INSERT INTO notNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yamai nacantococa Naro aisati icantocotina Pabati Ira agáquina. Ainta pite. ");
INSERT INTO notNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aique yosamitaiguëri: —¿Nega ini Piri? Yotabitanëri Jesos: —Teni pigótina Naro, teatisati pigótiri Pabati. Aroca pigótiname Naro, arome pigóqueri Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Oca nibarintsica icanquero Jesos cara yogomeantasegui oquibequë pongotsi irasi Torosintsi cara yoguiri joríojegui quirequi. Te pairi águirine terainta omoncaratima cataguiteri cara irágaiguëri. ");
INSERT INTO notNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aisati icantajiri Jesos: —Canta najáque Naro, pingogaigabitëna obirojegui quero piniajina queronta piáti cara najátaje Naro. Pingamaque queroquerai pijoquiro ora picantagueti te onganinate. Quero popasiniatitaji. ");
INSERT INTO notNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yosamitobaca joríojegui: —¿Iragamaguëmanico cara icanque quero iáti eiro cara iriátë Iriro? ");
INSERT INTO notNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Icantaiguëri Jesos: —Obiro timaigatsi yaca osobica. Naro paniacha jonoquë. Obiro paniacha quibatsica. Naro te nomaniema quibatsica. ");
INSERT INTO notNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","¿Teco nongomantimi cara pingamaiguë queroquerai pijoquiro ora picantagueti te onganinate? Queroca piquemisantina Naro aro quero nojocajimiro ora picantagueti te onganinate, aro pijáiguë cara Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yosamitaiguëri jorío: —¿Pairi pijita Obiro? Icanqueri Jesos: —Aroque nocomantëmi jirai. ");
INSERT INTO notNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aiti tojaiquerai nongomantëgotaiguëmi. Igáquina Pabati Tosorintsi nongomantaguequeri matsiguenga ora icanque Pabati ora icanti aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Te irogótaiguero jorío cara Jesos inibatëgotëri Tosorintsi Iriri. ");
INSERT INTO notNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iroro icanqueri Jesos: —Cara popëicoquina corosiquë Naro matsiguengatapënguitsi, aro cara pigóiguëna Naro aisonori. Aisati pigóiguëna teni nangantasitima Naati. Iroonti nacanque ora icanti Pabati ");
INSERT INTO notNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Irironta tsipatina Pabati. Te irioquina paniro përonta cara nacantiro ora ininti Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Cara inibatë Jesos negaca, aro iquemisantaiganaqueri tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aique Jesos icantaiguëri jorío ira quemisanqueri: —Aroca përosati pinguenguero pinguemisantiro nanibare, obiro nogomeresonori. ");
INSERT INTO notNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aique pigótaigabaquero nasi nanibare iroonti irorosonori. Ongantacaquemi arota quero picantagueigui përosati ora te onganinate. Quero imerataimi Satanás quero icantacagajimiro ora quimingaro. Irojocobentajimiro Tosorintsi ora quimingaro. ");
INSERT INTO notNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yotabitaiganaqueri jorío: —Naroegui imatsiguenga Abaram. Te pairi merataiguenane. ¿Pairo picantobique: “Quero imerataina Satanás”? ");
INSERT INTO notNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Icantaiganaqueri Jesos ira jorío: —Nangantasantëmini, antagaisati ira cantaguetiro ora te onganinate irianti iromeraro Satanás. ");
INSERT INTO notNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Atiraca ongantima iraninte, ira meratari iromeraro irioquiri sotoquë, carari itomi casintaro pongotsi përosati irinaque. ");
INSERT INTO notNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Iroro aroca nomasiniatitanaimi Naro Itomi Tosorintsi, quero picantagueigui përosati ora quimingaro. Quero imerataimi Satanás. ");
INSERT INTO notNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nigóiguimi obiro imatsiguenga Abaram, carari piquengaiga pigamagaiguëna tenta pinguemisantobëro nanibare paneingomentoquë. ");
INSERT INTO notNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ninibati Naro ora naneicoqueri Pabati. Picantaigui obirojegui ora icanti pasi piri, piquemaiguëri. ");
INSERT INTO notNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yotabitaiganaqueri jorío: —Nasiati pabati Abaram. Carari icanqueri Jesos: —Obiroca imatsiguengasonori Abaram, pingantaiguero aisa ora icanti Abaram. ");
INSERT INTO notNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Carari yamai picogaigui pigamagaiguëna cara nocomantaiguëmiro ora aisonori ora naquemaque Pabatiquë Tosorintsi. Abaram te ingantiro negaca. ");
INSERT INTO notNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Obirojegui picantaiguiro irootisati ora icanti piri. Aique icantaiganaque jorío: —Naroegui teni ninasitima aisa picanta Obiro pinasita, carari ainta nasi Pabati Irianti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Icanë Jesos: —Irirome piri Tosorintsi aisonori, pinintaiguename Naro, Naronta paniacha Tosorintsiquë. Teni nopocasitima, igáquinani Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Pairo te pinguemobitiro nanibare? Teni pinguemaiguero tenta pingogueni pinguemisantiro. ");
INSERT INTO notNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Obirojegui irasi Satanás. Iriro piri irianti camagari. Picogaigui pinganque ora icogui piri. Iriro ógueri cara jiraisonori. Te irinibatiro ora aisonori imaintirotinta. Itsoigani irasinta icanta. Omagaro tsoigagantsi paniacha Satanásiquë irironta tsoigagari matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Obirojegui aisati picantari ibega iriro. Iroro te pinguemisantaguëtina ninibatironta ora aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Obirojegui yamai ¿Pairi cantënane aiti nacantagueti ora te ongomeite? Aroca ninibatëro ora aisonori, ¿Pairo te pinguemisantobitina? ");
INSERT INTO notNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ira paniacha Tosorintsiquë inguemisantobëro Irinibare Tosorintsi. Te pinguemobëro obirojegui cagarinta obiro iraisati Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aique icantaiganaque jorío: —¿Aisonorico ninibataiguë Obiro Samariasati aisati inanquimi camagari quimingari? ");
INSERT INTO notNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yotabitanëri Jesos: —Teni irinantina camagari. Patirontiati nacanqueri ira matsiguenga iraniacaninataiguëri Pabati, carari picantocotasitaguetina obirojegui ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jemita iraniacaninataiguënata Naro matsiguenga. Irinibatocotinata Tosorintsi ora caninaro. Aisati ingomantëgotaiguëmi Iriro obironta te pingomeitaigue. ");
INSERT INTO notNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nangantasantëmini ora aisonori, ira quemisantiro ora nacanti Naro quero icami isërequë carari përosati intime jonoganta. ");
INSERT INTO notNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Icantaiganaque jorío: —Yamai nigótasanoigui aisonori inanquimi camagari. Icamaiguë Abaram aisati comantantatsirijegui. Carari picanque obiro: “Ira quemisantiro ora nacanti Naro quero icami”. ");
INSERT INTO notNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Obiroco obaqueri Abaram ira camënguitsi? ¿Obiroco obaqueri aisati comantantatsiri iraegui camënguitsi? ¿Obiroco Tosorintsi? ¿Pairiroco pijita Obiati? ");
INSERT INTO notNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yotabitanëri Jesos: —Aroca nanibatëgotëma quero ocomeiti, carari Irianti Pabati inibatëgotinaro ora caninaro. Iriati picantaigabitaca pasi pitosorintsite. ");
INSERT INTO notNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Teni pigóigueri. Naro nigótiri. Arome nanganquimi teni nogótiri Pabati aro Naro tsoenti pibegaiga obirojegui cara pitsoigaiga. Carari aisonori nigótiri naquemisantiro ora icanti Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abaram pomatsiguenga jiraisonori icaninatasanti cara igóque aiquenta nopoque Naro yaca quibatsica. Iquemisanquina icaninasëretë. ");
INSERT INTO notNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Icantaiganaque jorío: —Terai oretima 50 posarinite. ¿Piniaqueri Abaram jiraisonori? ");
INSERT INTO notNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yotabitanëri Jesos: —Nangantasantëmini, cara teraiquerai irine Abaram, ainta ninëta Naro. ");
INSERT INTO notNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aito cara yágaiguëro jorío mopë cara iromiongatëquerime Jesos, carari aroque imánanaca Iriro cara matsiguengaquë, isotocanë oquibequë pongotsi irasi Tosorintsi iátaji. ");
INSERT INTO notNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cara yanëitë Jesos iniaqueri sërari comarajari irinaga icomarajati cara iboguë. ");
INSERT INTO notNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yosamitaiguëri Jesos irogomere: —Ogometinari ¿Pairo icomarajabirique ica sërarica cara iboguë? ¿Icantaguetinico iriri ora te onganinate, oraco iniro, iriatico cantënguitsi ora te ongomeite? ¿Iroro ibogaguëtë comarajari? ");
INSERT INTO notNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yotabitanëri Jesos: —Icomarajatasita. Te ingantaguete ica ora te onganinate, teatisati iriri, teatisati iniro. Icomarajati arota ongonijate itasorintsite Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cara yobariaque paba intarobacaaque matsiguengajegui. Cara ontsitinitanë quero itarobacaati. Aisa nacantaiga naroegui. Yamai natarobacaataigui cataguiteriquë. Natarobacaatineri Ira agáquina. Aiquentata nangamaqueca quero natarobacaapai. ");
INSERT INTO notNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Iroontita ninasegui Naro yaca quibatsica, nosangueguitetocotiri matsiguengajegui. ");
INSERT INTO notNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cara itsonquero Jesos irinibare ijobaque quibatsiquë, yogaabatsaquero aro yáguë arosata yoguëneri iroquiquë comarajari. ");
INSERT INTO notNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Igáqueri: —Yamai pijáte, pinguibaoguitima ogaarequë jitacha Siroé. Siroé ocanti ogátaga. Aique iáque iquibaoguitaa aro ibeganaa, ipigapaa aroque iniaji. ");
INSERT INTO notNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ira itimanamitanepague aisati ira niaiguëri jirai cara yamanopiantanti quirequi, icantocotaiguëri: —¿Cagarico ini sobigatsi yamanopiantanti quirequi? ");
INSERT INTO notNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ainta icanque: —Iriro. Ainta basini icanque: —Cagari. Irianti irosiagueri. Icanë iriro: —Naanti. ");
INSERT INTO notNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yosamitaiguëri: —¿Ati picantaja cara piniaji? ");
INSERT INTO notNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yotabitanëri ira comarajatabetacha: —Ira jitacha Jesos yogaabatsaque quibatsi yoguinaro noroquiquë igáquina: “Pijáte Siroéquë pinguibaoguitaima”. Aro niáque naquibatanta aro nanianai. ");
INSERT INTO notNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yosamitaiguëri: —¿Atini yamai ira niagaimi? Icanque iriro: —Taa. Teni naniajiri. ");
INSERT INTO notNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yágaiganaqueri ira comarajatabetacha cara bariseoquë. ");
INSERT INTO notNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aro iroonti cataguiteri sábaro Ira Jesos yogaabatsaque quibatsi ora yogaguibegantaari comarajari. ");
INSERT INTO notNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Aisati bariseo yosamitaigairi ati icantaja ca inianai. Icanqueri: —Yoguënaro Jesos cajabatsari noroquiquë, aique naquibataa nanianai. ");
INSERT INTO notNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ainta bariseo icanque: —Ira aguibegajimi te aro imaniema Tosorintsiquë itarobacaaquenta sábaroquë. Ainta basini bariseo icanque: —¿Atiroco inganquima iritasongantagueque ira sërari cantaguetatsira te pojocajenga? Aro icasiriconiatitaiganaque bariseo. ");
INSERT INTO notNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Aisati yosamitaigairi sërari comarajatabetacha: —¿Pairo pingantocoqueri obiro yamai iniacagajiminta? Icanque: —Iriro comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Irari joríojegui te iraninte inguemisantaigueri ira comarajatabetacha yamaica aroque inianai. Icaimagantaiguëri iriri aisa iniro. ");
INSERT INTO notNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Yosamitaigabaqueri: —¿Iriro pitomi ica picantocoque cara iboguë comarajari? Ati icantaja iriro yamai cara inianai? ");
INSERT INTO notNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yotabitanëri iriri aisa iniro: —Nigóiguiri ica notomica. Nigóqueri ca iboguë comarajari. ");
INSERT INTO notNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Carari atiraca icantaja yamai cara inianai teni nogóigue naro. Teatisati nogóigue pairiraca niagairi. Posamitaigueri iriro aroquenta iquibiaque cara ingomantëgotëma irineni. ");
INSERT INTO notNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Icanque iriri iniro negaca ipingaiguërinta jorío. Aroque icomantaguetaiguë jorío aroca pairiraca cantëgotërine Jesos Iriro Quirisito, irioquëri cara yapatoita jorío. Querootisati inintacaguiri icai. ");
INSERT INTO notNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iroro icantaguëque iriri aisa iniro: “Aroque iquibiaque. Posamitaigueri iriro”. ");
INSERT INTO notNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aisati icaimaigairi sërari comarajatabetacha icanqueri: —Pingantocotiri Tosorintsi caninarisonori. Nigóiguiri ira sërarira ira aguibegajimi icantagueti ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yotabitanëri iriro: —Teni nogótiri iriroca cantaguetatsira. Patiro nigóque jirai nocomarajatabeta yamai aroque naniaji. ");
INSERT INTO notNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aisati yosamitaigairi: —¿Pairo icanquemi cara iniacagajimi? ");
INSERT INTO notNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Icanque sërari: —Aroque nocomantaiguëmi carari te pinintaigue pinguemina. ¿Pairo picogui basini nongomantëmi? ¿Obiroco nintatsi pingantaiguemari irogomere aisati? ");
INSERT INTO notNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yamai iguisatsatëri jorío: —Obiro irogomere Jesos. Naroegui irogomere Moisés. ");
INSERT INTO notNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nigóiguiri Moisés inibatëri Tosorintsi. Ica te nogóigueri negaraca ipaniaca. ");
INSERT INTO notNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yotabitaiganaqueri sërari: —Naquenganeintasanotanëmi te pigóigue atiraca ipaniaca Ira niagajina noroquiquë. ");
INSERT INTO notNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nigóigui te inguemobëri Tosorintsi ira cantaguetatsi te ongomeite, carari inguemobëri ira quemisanquerine intsoroganëri, aisati inganquero ora icogui Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cara oparintaca quibatsica irooti yamai te pairi niaguirine ira ibogatsi comarajari. ");
INSERT INTO notNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aroca ica sërarica te imaniema Tosorintsiquë, quero itasonganti. ");
INSERT INTO notNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iguisatsataiguëri bariseo: —Teni pingomeite obiro. Picantaguetasanoti ora te ongomeite. Iroro pibogaguëque comarajari. Pijáte. Querootisati picai cara napatotaiga naroegui jorío ibangoquë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesos iquemocoqueri sërari comarajatabetacha aroque ijocaiguëri jorío. Iniajiri yosamitëri: —¿Piquemisantiri obiro Ira paniacha jonoquë matsiguengatapënguitsi? Icanque sërari: ");
INSERT INTO notNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Ogometinari, ¿Pairi ijita? Pingomantinari arota nanguemisantanëri naro. ");
INSERT INTO notNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Icanqueri Jesos: —Yamai aroque piniaqueri. Naromë nibatacaguimica yamai. ");
INSERT INTO notNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aro ira sërari yobaticagueritotanaca icanëri: —Natingomi, naquemisantimi. ");
INSERT INTO notNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aique icanque Jesos: —Iroro nipocasique yaca quibatsica nongomantëgotaigueri matsiguengajegui. Ira comarajasëretatsi tenta irogótiri Tosorintsi, iriro nogótacaqueri ingantajimari naniacagajiri ira comarajatabetachari. Carari ira jitabitacha igótiro omagaro ora aisonori, nobegopitairi ora igótabeca; inganquimari ibega comarajasëretatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ainta bariseo inasegui iquemobëro oca nibarintsica yosamitaiguëri: —¿Atiroco nacantaiga naro? ¿Nocomarajasëretaiguinico? ");
INSERT INTO notNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yotabitanëri Jesos: —Arome pingomarajasëretaigue, querootisatime pini ora picantagueti te onganinate. Carari yamai pijitabetaiga pigóiguiro ora aisonori. Iroro iniaiguëmi Tosorintsi picantaguetasanotomotaiguiri ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Përosati yogomeanti Jesos: —Nangantasantëmini ora aisonori, ira quero iqui omoroquë cara itantota oisha irianti cosirinti, caraantinta iratanë jonoquë tantotsi. ");
INSERT INTO notNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Irari catsi omoroquë irianti omisantaiguiri iroishate. ");
INSERT INTO notNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ira omisantiro sitëcori irasirigotobëtiguiri ira omisantantatsiri. Aisati inguemaibagaqueri oisha irironta casintari cara ingaimantaigapëmari iripajiroquë, iraguiataiganaqueri sotoquë igótironta ora irinibare ira omisantirira. ");
INSERT INTO notNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cara iromisotocaigapëri irobatacaganëri iroishate iraguiataiguëri igótsatironta irinibare. ");
INSERT INTO notNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Irari quero yoguiatiri ira te irogótsatiri. Irisigabitsatanëmari tenta irogótsatironi irinibare. ");
INSERT INTO notNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Icomantaiguëri Jesos oca quingabaguirentsica carari te inguemaigabaquero matsiguenga ora icanqueri. ");
INSERT INTO notNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aisati icanai Jesos: —Nangantasantëmini ora aisonori, Naro nacantaro pibega sitëcori cara icaiguiro oisha. ");
INSERT INTO notNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Antagaisati ira boquënguitsi cara teraique nopoque Naro irianti cosirinti, aisati matobiantatsiri carari iriro te inguemaigabaqueri oisha. ");
INSERT INTO notNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nacantaro sitëcori. Naanti irareantima Tosorintsiquë matsiguenga ira quemisanquinane. Aro iragabisaicoqueri Tosorintsi. Nantsibatëmarinta nomisantëri cara inganaque aisati cara nomisotocanairi aisa icantari oisha cara iromingabaqueri omisantantatsiri aique iraguiatëri sotoquë irapë. ");
INSERT INTO notNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iroonti ipocasique cosirinti ingositëni oisha aisa iragamaguëri iripoguiriaqueri. Carari nipoque Naro nantimasanotaquerini matsiguenga arota inganinatasanotanë. ");
INSERT INTO notNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naro caninari omisantantatsiri. Ira omisantantatsiri ingamobiqueri iroishate aisa Naro nangamobitaiguëri antagaisati ira quemisanquina. ");
INSERT INTO notNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Ira iromeraro omisantantatsiri te iranintiri iromisantasantineri iroishate. Paniro inintiri quirequi iripënabintëri casintari oisha. Cara iraniobëri otsitiniro intsoroganëtiguiri irojocanëri oisha cagarinta irasi irisiganëma. Aro iráqueri otsitiniro oisha iragamaguequeri iromisiaguequeri. ");
INSERT INTO notNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Naro caninari omisantantatsiri. Nigótiri noishateegui aisati igóiguina Naro. Aiquenta nangamobiqueri ira quemisanquinara. Iriro cantaca ibega noishate. Aisa nacanta Naro nigótiri Pabati aisati igótina Naro. ");
INSERT INTO notNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ainta basiniatipague tojai inguemisantaiguëna. Iriro cantaca noishate aisati. Irirojegui nomapëri aitosati, inguemisanquero nanibare, nopatotaiguëri omagaro Naronta paniro iromisantantatsirite. ");
INSERT INTO notNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Përosati yogomeanti Jesos: —Iroro inintasantaguëtina Pabati aronta nangamobiqueri Naneni noishate aisati nanganiatae. ");
INSERT INTO notNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Quero pairi óguinane. Naneni camasibiriquimarine matsiguenga. Aisonori nangamasiquima Naro aisati nanganiatanae. Iroro ora igáquina Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cara iquemaigabaquero jorío nibarintsica, te inguengaiguema icantobitobacari Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ainta icanque: —¿Pairo piquemisantobiqueri inancarinta camagari? Irianti ichabënitaga, intaguetasitaro ora te inguenguema, teatisati iraneicotima. ");
INSERT INTO notNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Carari ainta basini icanque: —Quero inibati sërari icanti negaca aroqueca inancari camagari. ¿Aroco iraniacagajiri camagari ira comarajari? ");
INSERT INTO notNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Cara tsaengaquë tojai jorío yapatotaigaca cara Jerosarénquë cara iquengaiguëro jirai cara yobetsiquëneri ibango Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yanëisigui Jesos oquibequë pongotsi irasi Tosorintsi cara pinasegui omoro ora yobetsiquë Saromón jirai. ");
INSERT INTO notNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ishongaigapari jorío yosamitapëri: —¿Ati ongantima pingomantëgotëma pairiraca pijita? Pingomantaiguena catingasati Obiroca Quirisito Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yotabitaiganaqueri Jesos: —Aroque nocomantabitaguëmi carari te pinguemisante. Aroquesati nitasongantagueque ora igáquina Pabati Tosorintsi carari te pinguemaigue. ");
INSERT INTO notNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Teni pinguemisantaiguena cagariminta noishate. Ira noishate iquemisanquina. ");
INSERT INTO notNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Aisati iquematsatina noishate ira quemisanquina, nigóiguiri Naro, aisati yoguiataiguina. ");
INSERT INTO notNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nomaiguëri përosati intiomotaiguëri Pabati Tosorintsi Jonogaguitequë. Nomisantasantaiguëri. Quero iáti Sharincabeniquë, querootisati pairi ágabitsatinari. ");
INSERT INTO notNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Iraegui ipëna Pabati, Ira obaqueri antagaisati. Iriro sintsirisonoriguinte. Quero pairi ágabitsatirine Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naro aisati Pabati paniro ninaigui. ");
INSERT INTO notNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aito cara yágaigairo mopë jorío cara iromiongatëqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Icanqueri Iriro: —Tojai piniaiguëna cara nitasonganti. Tojai noniagaiguëmiro ora caninaro aroquenta igáquina Pabati. ¿Pairo pininti pobasegobitaiguëna? ");
INSERT INTO notNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yotabitaiganaqueri jorío: —Quero nibasegaiguimi aroquenta picanque caninaro obiro. Orari nobasegobitaiguëmi cara picantocotaguetasitarinta Tosorintsi. Aisati cara pijitaja Tosorintsi Obiantinta matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Icanqueri Jesos: —Jirai Tosorintsi inibatantaro Sanguenari cara icantocoqueri ira jitacha joes: “Obirojegui tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nigóiguiro ora Irinibare Tosorintsi iroonti ora aisonori. Aroca Tosorintsi ijitaiguëri tosorintsipague ira joes, ");
INSERT INTO notNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Iroro pairo picantocobiriquina cara nacantocotaguetasicari Tosorintsi aroquenta nacanque Naro Itomi Tosorintsi? Icasiriconiatiquena Pabati Tosorintsi aisa igáquina yaca quibatsica. ¿Aisatico pingantocoqueri Tosorintsi: “Icantasica cara icanque ‘Obirojegui tosorintsi’ ”? ");
INSERT INTO notNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Queroca nacantiro Naro ora icanti Pabati, quero piquemisantina. ");
INSERT INTO notNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Carari aroca nanganquero, aro pinguemisantiro, queroca piquemisantiro nasi nanibare. Iroro pigóiganaquero përosati ainta Pabati Naroica, aisati Naro aintana Iriroquë. ");
INSERT INTO notNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Aisati icogaigabitaca jorío iráguirime Jesos, carari isigopitanacari. ");
INSERT INTO notNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aique iáque Jesos Joriránquë imontianaca aiquero onamijaquë cara icontetiquero paba. Itimaque cara ibaotisatanti Joan jirai. ");
INSERT INTO notNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ipocasitaiguëri tojai matsiguenga, icantocoqueri: —Te iritosongante Joan, carari aisonori antagaisati ora icomantëgotëri ica sërarica. ");
INSERT INTO notNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Carari canta iquemisantaiguëri Jesos tojai matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ainta poro sërari jitacha Irásaro ijanaitasantë. Itimi Betaniaquë oboeborote iritsiro pite ora jitaigacha María aisati Márita. ");
INSERT INTO notNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Oca María iritsiro Irásaro ira janaitatsi ora tiriqueri casangajengaro iguitiquë Jesos aisati pobiriatantajari oguisi. ");
INSERT INTO notNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Oca pite iritsiro Irásaro pigántëri Jesos ocomantagantëri: —Natingomi, ijanaitasantëni agabenisonori ira pininti pamigote. ");
INSERT INTO notNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iquemobëro nibarintsi Jesos, icanque: —Quero icami përosati. Ijanaitë arota ira matsiguenga iraniacaninataiguëri Tosorintsi caninarisonori aisati irogóiguëna matsiguenga Naro caninari Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ira Jesos inintasantiro Márita aisati María aisati Irásaro, ");
INSERT INTO notNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","carari igótabeca Jesos cara ijanaitasantë Irásaro, përosati itimaque pite cataguiteri cara inasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Aique icanqueri irogomere Jesos: —Intsome aisati Joreaquë. ");
INSERT INTO notNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Icantaiguëri irogomere: —Ogometinari, cani icogaigabitaca jorío canta iróguimime iribasiaquimime. ¿Yamai aisatico pijátaje canta? ");
INSERT INTO notNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Icanqueri Jesos: —Cara irigontepë paba irosangueguitetocotaigapëri matsiguenga. Aroca iranëitë pairiraca cataguiteriquë quero intibata. ");
INSERT INTO notNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Carari caraca iranëique tsitiniriquë irantibaquima tenta ineti iguëtaguiterite. Aisa nacanta Naro quero nacami canta queroquerai pareta cataguiteri cara iróquina. ");
INSERT INTO notNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Icanque negaca. Aitosa icanqueri: —Yamai isamini namigote Irásaro carari najáque nangabacapairi. ");
INSERT INTO notNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aique icantaiguëri irogomere: —Natingomi, isaminica aro irobegajima. ");
INSERT INTO notNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Igóque Jesos cara aroque icamaque Irásaro. Inibatëgotëri cara icanque isamini, carari te inguemaiguero irogomere. Ijique iriro aisonori isamini Irásaro. ");
INSERT INTO notNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aique icanque Jesos catingasati: —Aroque icamaque Irásaro. ");
INSERT INTO notNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Caninataque te nine Naro canta arota pinguemisantasantanëna. Yamai intsome ajáigue canta. ");
INSERT INTO notNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás aisati ijita Tsipari icanqueri irogomere basini: —Intsome eiro arota angamaigue aisati anganquimari Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yaretaiganaca canta Betaniaquë. Icomantaigabaqueri aroque itiaiguëri otsibasati cataguiteri. ");
INSERT INTO notNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aronisatiquë Betania otsibataro Jerosarén maba quirómetoro. ");
INSERT INTO notNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Iroro ipocasitaigapë tojai jorío iraganinataigapëro Márita aisati María aroquenta icamaque ojariri. ");
INSERT INTO notNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cara oquemocotobëri Márita Jesos piáque pitonguibotobacari, iroroque María përoca pinë pongotsiquë. ");
INSERT INTO notNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ocabëri Jesos Márita: —Natingomi, aintamime pinasegue Obiro yaca, querome icami jai. ");
INSERT INTO notNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Carari nigóque naro imëmiro Tosorintsi antagaisati ora pomanaqueri. ");
INSERT INTO notNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Icanëro Jesos: —Ira pijariri aro inganiatanae. ");
INSERT INTO notNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ocanque Márita: —Jee, nigóque cara cataguiteriquë carantatsiri ingabiritaigaima antagaisati ira camënguitsi. ");
INSERT INTO notNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aique icanquero Jesos: —Naro aganiataguetiri ira camatsi nomairi intimaje. Ira quemisantina ingamabequima carari cara aisa inganiatanae. ");
INSERT INTO notNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aisati antagaisati yamai ira caniari iquemisanquina, aroca ingamaque yaca quibatsica, përosati intimanë canta Jonogaguitequënta. ¿Piquemisantiro oca? ");
INSERT INTO notNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Potabitanëri Márita: —Jee, Natingomi. Naquemisantimi Obiro Quirisito. Obiro Agabisaicoontatsiri Itomi Tosorintsi. Noguiaiguëmi cosamani Obiro cara popogopë yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pitsonquero pinibatë Márita, aique piáque ocaimëro María irento, ocanquero comanoroni: —Ainta Ira ogomeantatsi. Icaimagantimini. ");
INSERT INTO notNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Cara oquemobëro María oca, omanapague ocabiritanaca piáque Jesosiquë ");
INSERT INTO notNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","teraquerai iraretima Jesos poeboroquë, përo cara inasegui cara pitonguibotobacari Márita. ");
INSERT INTO notNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aroqueque ipocasitaigapëro jorío arota iraganinatiro iritsiro Irásaro. Cara iniaigabaquero María ocabiritanaca omanapague pisotocanë, ijique cara piáque oraquima cara itiaca Irásaro. Aro yoguiataiganaquero. ");
INSERT INTO notNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Parecari María Jesos pobaticagueritotasipari ocanqueri: —Natingomi, aintamime pinasegue Obiro yaca querome icami jai. ");
INSERT INTO notNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesos iniobëro piragopa aisati iragaigapa jorío itsibataigaparo, icantaneintëgotëro Jesos yogasëretanaca, ");
INSERT INTO notNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","yosamitaiguëri: —¿Nega pitiaqueri? Icantaiguëri: —Natingomi, omana pinetsapëri. ");
INSERT INTO notNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aro iraganaca Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Icantaiganaque jorío: —¡Pinetseri! Inintasantirini. ");
INSERT INTO notNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ainta basini jorío icantaiguë: —Ica iniacagajiri comarajari; ¿Teco ingantiri Irásaro arota quero icami? ");
INSERT INTO notNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aisati icantaneintasantanaca Jesos yotsitipari cara itiaca Irásaro. Iroonti yasitocoontacari mopë. ");
INSERT INTO notNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesos igáqueri jorío icanqueri: —Posibitiro ora mopëra. Ocanë Márita iritsiro Irásarotomaco: —Natingomi, aroquejengari isititë aroquenta ocarati otsibasati cataguiteri cara itiaca. ");
INSERT INTO notNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Carari icanëro Jesos: —¿Teco nangantimi aroca piquemisantina, aro piniaquero itasorintsite Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aito cara yágaiguëro mopë yasirecoqueri. Inetsë Jesos jonoquë yamanocotanëri Iriri: —Pabati, nacarasiaquimini piquemaquinanta. ");
INSERT INTO notNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nigóque përosati piquemina carari ninibabentaiguëri ica matsiguengaca arota inguemisantaiguena aisati irogóigue Obiro agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aroque yamanaqueque icaimëri: —¡Irásaro, pingabiritima pisotogopë! ");
INSERT INTO notNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aito cara isotogopai Irásaro caniari iponataparo tocoya ibacoquë aisati iguitiquë aisa iboroquë iponatapa. Igáqueri matsiguenga Jesos: —¡Pintsaicotiri popabaquëajiri! Aro icantaiguëneri. ");
INSERT INTO notNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ainta arosonori jorío aguiatapëro María. Cara iniaiguëri itasonganti Jesos iquemisantanëri tojai. ");
INSERT INTO notNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ainta basini jorío iáiguë bariseoquë icomantaiguëri antagaisati ora icanque Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aique ira bariseoegui aisati itingomipague saseriroti yapatotaiguëri omagaro itingomiegui jorío. Icantaigabaqueri: —¿Pairo anganqueri Ira sërarira cara itasonganti tojai? ");
INSERT INTO notNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Queroca acantiri pairoraca, omagaro inguemisantaiguëri. Aisati iribocaigapë Iromasati irotëanëro intiboroquero oquibe pongotsi irasi Tosorintsi aisati irágopitaigacáiro aguebatsitejegui. ");
INSERT INTO notNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Paniro jorío jitacha Caijás, iriro obatatsi itingomisonori saseriroti irooti osarini ora iribëquëgotanquimari Jesos. Icanqueri imatsiguenga Caijás: —Te pigóigue obiro pairoraca. ");
INSERT INTO notNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Teatisati pigóigue caninataque cara ingamobitaigacái poro sërari arota quero ipoguiriaigái Iromasati. ");
INSERT INTO notNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Te irinibatiro oca irineni Caijás. Irironta itingomisonori saseriroti, ocantacaqueri negaca Caninaro Isëre Tosorintsi, cara icantocoqueri Jesos ingamobitaiguëri omagaro jorío. ");
INSERT INTO notNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aisati ingamobitaiguëri antagaisati ianiquite Tosorintsi negaraca itimagueti, irapatotaigairi. ");
INSERT INTO notNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yamai iquengaigaca itingomiegui jorío irobetsicaiguëro cara iróqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iroro te iranëitaguëtaje Jesos Jerosarénquë carari isotocanë Joreaquë iáque poeboroquë otiomijani jitacha Eparaín aronisatiquë piriabatsaro cara tera ontimingani. Cara itimaiguë Iriro aisati irogomere. ");
INSERT INTO notNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pënibaque orequima cataguiteripague jitacha Pásicoa. Yametaiga jorío iriáiguë Jerosarénquë iraguëtetima queroquerai pareta Pásicoa. ");
INSERT INTO notNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Icogaigabitacari ira Jesos. Cara ibangoquë Tosorintsi yosaminaitobaca: —¿Pairo piquengaiga? ¿Aro iribocapë Jesos Pásicoaquë? ¿Queroco ipoqui? ");
INSERT INTO notNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aroque icomantaiguë bariseojegui aisati itingomiegui saseriroti aroca irogóque pairiraca negaraca ini Jesos ingomantëgotëri arota irágaigueri jorío. ");
INSERT INTO notNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ocaranibati 6 cataguiteri teraiquerai oretima Pásicoa iáque Jesos poeboroquë ojita Betania cara itimi Irásaro ira camabitënguicha, ira yoganiatai Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yobetsicaiguëneri Jesos ora tojai perintsi. Iriroque Irásaro isobiacaqueri Jesos cara mesaquë. Iroroque Márita pamaigapëneri iraperi. ");
INSERT INTO notNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aique pamapë María ongaraataga casangajengaro jitacha náriro ora pënatacha tojai pitiripëri iguiti Jesos, pobiriatantajari oguisi. Piaingatagueque omagaro pongotsiquë. ");
INSERT INTO notNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aito cara icanque poro irogomere Jesos jitacha Joras Cariotisati. Iriati ira ágagantërine Jesos caraquenta. Icanque Joras: ");
INSERT INTO notNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Pairo te omimantobitiro oca casangajengaro arota águiri 300 tenario? Aique omaiguëri omitocotaguetirime ira coguitiacha. ");
INSERT INTO notNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Joras, tenta iranintiri ira coguitiacha, iroro icantobique negaca irironta cosirinti iriatisati omisantaiguineri omagaro irogomere Jesos itsaguineegui. Caraquesatantata ingositëri quirequi. ");
INSERT INTO notNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Icanqueri Jesos: —Ineta iroro oca. Aroque poguëro casangajengaroca irooti cara nangamaque. Cara queroquerai iteina, pomasangaengatobënaro. ");
INSERT INTO notNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ainta përosati irinaigui ira coguitiachari obirojeguiquë, carari quero përosati ninagaiguimi Naro. ");
INSERT INTO notNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tojai jorío iquemocotaiguëri Jesos cara ainta Betaniaquë. Iáigue cara iraniaqueri Jesos aisati Irásaro ira yoganiatai Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Iroro iquengaigaguëtaca itingomiegui saseriroti iróguiri aisati Irásaro ");
INSERT INTO notNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","aroquenta iniasantëri tojai jorío ira Irásaro, ijocaiganaqueri saseriroti yoguiataiganaqueri Jesos iquemisantaiganaqueri. ");
INSERT INTO notNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tojaisonori jorío yapatotaigapa cara Jerosarénquë ora cataguiteripague jitacha Pásicoa. Oquëtaguetanë iquemocotaigabaqueri Jesos pënibaque irarepëma, ");
INSERT INTO notNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","iáque icarasitëneri ora cantaca chorinasi itonguibotobacari imatacoboguitëneri icaimaiguë catsigue yamanaiguë: —¡Caninarisonori Tosorintsi! ¡Coraguetaque Agabisaicoontatsiri caninari! ¡Igáquinari Tosorintsi! ¡Obirai Natingomiegui! Pigáantë pinganquimari ibega David cara igáanti jiraisonori. Icantaigabaqueri negaca joríojegui. ");
INSERT INTO notNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesos iniaqueri oboina boro iqueicocari cara ocanti Sanguenari jirai: ");
INSERT INTO notNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Quero pitsorogui, obirojegui pitimaigui poeboroquë jitacha Sión. Pinetsaigabaqueri Pitingomi Ira bocatsi iqueicocari oboina boro. ");
INSERT INTO notNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Antagaisati oca te inguemaigabitimaro irogomere Jesos. Aiquentata cara icamaque Jesos icaniatanai yogainocaa cara Iririquë cara yoguibatobëri, aro yamai iquemaiguëro irogomere. Aro igótocotobëri antagaisati oca isanguenatocoqueri jirai. Irooti cara omoncaraca. ");
INSERT INTO notNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ira matsiguenga neiri Jesos cara icaimëri Irásaro yoganiatairi yamai icomantagueantëro ora iniaiguë. ");
INSERT INTO notNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iroro iátaguëque matsiguenga itonguibocari Jesos aroquenta igótocoqueri cara itasonganti. ");
INSERT INTO notNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iniaigabaqueri bariseo cara iátagueque matsiguenga icantobaganaca: —Yamai pinetsabaqueri irobacáini. Yoguiataiguëri omagaro. ");
INSERT INTO notNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Cara Jerosarénquë ipocaigapë arosonori matsiguenga iromanocotaiguërini Tosorintsi. Aintasati guiriego icogaiguë irogótasantiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yotsititaigapari ira Jeripe, Betsairasati ipaniaca cara Garireaquë. Icampëri: —Namigote, nanintaiguini naneiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Iáque Jeripe icomantëri Antiris. Iáiguë pitirooti icomantëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Icabëri Jesos: —Nopaniaca canta jonoquënta. Nomatsiguengatapë. Yamai aroque pareca cataguiteri cara nangamaque nanganiatanae najátaje Jonogaguitequë aisati. Aro iraniacaninatasantaiguëna matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nangantasantëmini ora aisonori, queroca ocami poro oguitso tirigo panguitacha quibatsiquë, quero otojaiganaque patironta inë, carari omanguitëmaca ianë ontojaiganaque. ");
INSERT INTO notNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Eiro aisati angantimaro pibega oguitso tirigo. Ira nintasanotacha iriati icogui intimasante yaca quibatsica, quero iáti Jonogaguitequë. Irari cantaneintëgotiri basini matsiguenga, te inguenguema paniro iriati, aro intimaque Jonogaguitequë përosati. ");
INSERT INTO notNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aintaca nintatsi ingantinaro aisati inguemisanquina iraguiatina negaraca najátacaqueri. Aitosati intiomoquina cara natimi Jonogaguitequë. Inganqueri Pabati Tosorintsi: “Caninataque ora picanque”. ");
INSERT INTO notNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Yamai nogasëretasantanaca. ¿Pairo nanganque? ¿Nomanocoquimanico: “Pabati, pigabisaicotina ora pënibaque natsipiriaquero? Quero nacantiro, iroronta nipocasique quibatsica natsipiriaquineri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pabati, nocogasanti ingantocotimi matsiguengajegui: ‘Caninarisonori Tosorintsi’ ”. Aito cara iquemaibagaquero matsiguenga Irinibare Tosorintsi jonoquë icanque: —Aroque noniagaigacari caninarina. Përosati nangantajiro aisati. ");
INSERT INTO notNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aintapague matsiguenga canta iquemaigabaquitiguiro Irinibare Tosorintsi icanque: —Iroonti tijiringa. Ainta basini cantaigatsi: —Inibatërinijengari ironomire Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yotabitaiguëri Jesos: —Inibatëna Tosorintsi arota pigóiganaque obirojegui iquemina Iriro. Aroque nigótiro Naro. ");
INSERT INTO notNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yamai ingasitígataiguëri Tosorintsi antagaisati te inguemisantina. Aitosati Tosorintsi irioquëri jaara Satanás irironta agáqueri iraegui te inguemisantina. ");
INSERT INTO notNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Intinaiguënaca canta jonoiqueronta, iroro nopatotantaiguëmari antagaisati matsiguenga, iribocasitaiguëna ira quemisanquinane. ");
INSERT INTO notNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cara icanque negaca icomantëgotaca Iriati ingamaque cara corosiquë. ");
INSERT INTO notNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yotabitanëri jorío icanë: —Nigóontacaro Sanguenariquë cara përosati intimaque Quirisito. ¿Pairi picantocoque Obiro Ira paniacha jonoquë aisati imatsiguengatapë intinaaqueri jonoiqueronta? ¿Pairi casintari Ira paniacha jonoquë? ");
INSERT INTO notNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Icanqueri Jesos: —Ora nogometimi yamai aisa ocantaro cataguiteri. Posangueguitetocotimi. Iroontita ninë obiroquë panëiguitetaigue cataguiteriquë queroquerai otsitinitocotaiguimi. Ira anëitatsi tsitiniriquë te irogóte atiraca iriátë. ");
INSERT INTO notNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Naro aisati nacantaro cataguiteri nosangueguitetocotaiguimi. Iroontinta ninë obirojeguiquë, pinguemisantaiguena arota panëiguitete cataguiteriquë. Aro pigóiguëro ora aisonori. Cara itsonquero oca irinibareca, iáque Jesos imánopitaigacari. ");
INSERT INTO notNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tojai itasonganque Jesos catingasatiquë joríojegui, carari te inguemisantaigueri. ");
INSERT INTO notNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Omoncaraca ora isanguenaque jirai Isaías comantantatsiri cara icanque: Natingomi Notosorintsite ¿Pairi quemisanquero nanibareegui? ¿Pairi poniaguë pitasorintsite? ");
INSERT INTO notNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aitosati Isaías isanguenatocoqueri ira te inguemisantaigue inguemabequima icanqueri: ");
INSERT INTO notNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nangantacaquimari quero iniaigui ora icanti Tosorintsi, querootisati icogaigui inquemisantina, querootisati iquenguina, querootisati ipasiniatitaji, querootisati nogabisaicotajiri. ");
INSERT INTO notNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isanguenaquero Isaías negaca aroquenta iniaqueri Jesos caninarisonoriguinte icomantëgotëri. ");
INSERT INTO notNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Carari ainta tojai jorío aitosati ainta itingomi iquemisantabecari Jesos, carari te ingomantomotiri matsiguenga itsorogaiguërinta bariseo. Iquengaigaca: “Inguisaneinquina bariseo, quero inintacaguina naqui cara yapatotaiga nomatsiguenga”. ");
INSERT INTO notNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ira quemisantabetacha icogasanti iraniacaninataiguëri matsiguenga carari te ingogue iraniacaninatiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Icaimë Jesos icanque: —Ira quemisantina Naro, te paniro Naro, aisati iquemisantiri Pabati Ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ira neina Naro, aisati iraniaqueri Ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nosangueguitetocotiri omagaro matsiguenga. Nipocasique Naro yaca quibatsica arota quero yanëitantaigaro tsitiniri ira quemisanquinane. ");
INSERT INTO notNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ainta poropague quemabitacaro nanibare te inguemisantina, quero nacasitígatiri yamai tenta nopoqueni nangasitígatiri matsiguenga. Nipoguini nagabisaicotajiri ira quemisanquinane. ");
INSERT INTO notNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ira te irágobëna Naro teatisati inguemisantobëro nasi nanibare, aiquenta nanibare ongomantëgotëri. Queronta iquemisantiro nanibare ingasitígatëri Tosorintsi cara cataguiteriquë carantatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Teni nanibatasitima iroonti ninibati ora igáquina Pabati. Igáquina Iriro omagaro ora ninibatë aisati ora nogomeantë. ");
INSERT INTO notNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nigóquero ora igáquina Pabati iroonti Nibarintsi timagantatsiri. Iroro patiro ninibati ora igáquina Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Terai oretima Pásicoa cara iquengaigairo jorío cara isotocaigai Ejípitoquë jiraisonori. Igóque Jesos aroque pareca cataguiteri cara irojocanëro quibatsi iriátae Iririquë. Cara inintasantaiguëri quemisantatiri Jesos yaca quibatsica, yamai inintasantasanoiguëri. ");
INSERT INTO notNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Cara yapaigasegui, aroque iquiancacari Satanás ira Joras itomi Simón ipaniaca Cariotiquë cara irácagantëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Igóque Jesos aroque ipëri Iriri omagaro. Aisati igóque ipaniaca Tosorintsiquë aisati yamai iripiganajima jonoquë. ");
INSERT INTO notNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Icabiritanaca mesaquë, isaboquëro imanchaqui, yáguëro oquibiantsa tocoya imatsaguitanacaro, ");
INSERT INTO notNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ishëro nija irabatarioquë, aro iparintaca iquibaguititaguequeri irogomere aique iseantaari tocoyaquë ora imatsaguisiga. ");
INSERT INTO notNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cara pënibaque inguibaguitiqueri Simón Peroro aro yosamitëri Peroro: —Natingomi ¿Pinguibaguitiquinanico naro? ");
INSERT INTO notNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yotabitanëri Jesos: —Yamai teni pinguemiro ora nacanti, aiquenta pinguemaquero. ");
INSERT INTO notNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Carari icanë Peroro: —Naro quero piquibaguititina. Yotabitanëri Jesos: —Queroca naquibaguititimi, quero pini Naroica. ");
INSERT INTO notNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aique icanqueri Simón Peroro: —Natingomi, querori patiro piquibiro naguiti. Aisati pinguibaquina nobacoquë, pinguibaquina naguitoquë. ");
INSERT INTO notNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Icanëri Jesos: —Ira quibacha irirai quero iquibaja omagaro, patiro iguitiquë inguibima aroquenta irinaga yoguëteta. Obirojegui pinaga poguëtetaiga paneingomentoquë carari te antagaisati pinguëtetaigue. ");
INSERT INTO notNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Icanque Jesos: “Teni antagaisati pinguëtetaigue”, aroquenta igóque pairiraca ágagantërine. ");
INSERT INTO notNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aroqueque iquibaguititaiguëri Jesos icairo imanchaqui aisati, isobiaque mesaquë. Yosamitëri irogomere: —¿Pigótaiguëro oca nacantaiguëmica? ");
INSERT INTO notNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pijitaiguina Ogomeantatsiri aisati pijitaiguina Pitingomi. Picantaiguiro ora aisonori Naronta Pitingomi. ");
INSERT INTO notNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aroquenta naquibaguititaiguëmi Naro Ogomeantatsiri aisati Pitingomi, caninataque pinguibaguititobaguima aitosati obirojegui. ");
INSERT INTO notNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Noniaguëmiro ora pingantaiguë aisa pinganquero obirojegui ora nacantaiguëmi yamai. ");
INSERT INTO notNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nangantasantëmini ora aisonori. Ira iromerataga quero ibatiri ira meratari, aisati icanta ira iragátaga quero ibatiri ira agátirira. ");
INSERT INTO notNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Aroca pinguemaquero oca nocomantëmica, aro pinganinataiganaque pinganqueroca. ");
INSERT INTO notNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Teni nanibatëgoiguemi omagaro obiro nigótasantimininta aroquenta nocoiguëmi. Nocoiguëmi arota omoncaratima Sanguenari ora ocanti: Ira pëcoquina pan yamai iguisanëintanaina. Icoque iróguina. ");
INSERT INTO notNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nocomantaiguimiro negaca cara iróquinaca pinguenguero, përosati pinguemisanquina Naantinta Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nangantasantëmini ora aisonori pairiraca ágobërine ira nagáque aitosati irágobënanisati Naro. Ira ágobënane Naro aisati irágobëri Pabati Ira agáquina Naro. ");
INSERT INTO notNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cara inibatë negaca Jesos yogasëretasantanaca icantaiguëri irogomere catingasati: —Aisonori nangantasantëmini, ainta paniro obirojeguiquë ira ágagantënane. ");
INSERT INTO notNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aique inetsabacagaguetanaca irogomere Jesos. Te irogóigue pairiraca ira inibatëgotë Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Paniro irogomere ira inintasanti Jesos yapanamitacagaseguiri. ");
INSERT INTO notNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Peroro ijigotanëri ira panamisiguiri Jesos arota irosomitiri pairiraca ira inibatëgotasegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ira panamisiguiri Jesos inebintasitanacari yosamitëri: —Natingomi, ¿Pairi pinibatëgoti? ");
INSERT INTO notNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yotabitanëri Jesos: —Ira nomë pan nagaatane, iriro ninibatëgoti. Aro yogaatëro pan ipëri Joras Cariotisati itomi Simón. ");
INSERT INTO notNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yágobëro pan Joras aito cara inantanacari Satanás. Aique icanqueri Jesos: —Ora picogui pingantiro, pingantiro omanapague. ");
INSERT INTO notNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iquemabecaro basini irogomere Jesos. Te poro quemasantobërine Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Irironta Joras omisantineri iguireguite irogomerejegui, ainta ijique igáquerini Jesos iromanante Joras ora asi jiesita. Ainta basini ijique igáquerini imëri quirequi ira coguitiachari. ");
INSERT INTO notNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Cara yapëro pan Joras isotocanë, aroque otsitinitanë. ");
INSERT INTO notNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Aroqueque isotocanë Joras, icanque Jesos: —Omanapague yamai iraniacaninataiguëna matsiguenga, ingantocotaiguëna: “Caninarisonori Ira paniacha jonoquë imatsiguengatapë”. Aitosati ingantocotaiguëri Tosorintsi: “Caninarisonori Tosorintsi aroquenta igáqueri Itomi yaca quibatsica”. Aisati yamai ingantocoquina Tosorintsi: “Ira matsiguenga iraniacaninataiguerita Notomi”. ");
INSERT INTO notNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Obirojegui cantaca najaniquite, arosata yamai ninagaiganajimi cara queroquerai niáti. Pingogabetajina, carari cani jirai nocomantaiguëri jorío, aisati yamai nongomantaiguimi obiro: quero piáti cara najáque Naro. ");
INSERT INTO notNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Oca nagáquemi irorai, pinintobaganëma. Aisa nacanta Naro nanintasanotaiguimi, aisati pinintasanotobaguima. ");
INSERT INTO notNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aroca pinintobaganëma, aro antagaisati matsiguenga irogóiguemi obiro nogomerejegui. ");
INSERT INTO notNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Icanëri Simón Peroro yosamitëri Ira Jesos: —Natingomi ¿Nega pijáque? Yotabitanëri Jesos: —Cara najáque quero poguiatina yamai. Aiquenta piguiatapëna. ");
INSERT INTO notNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Icanqueri Peroro: —Natingomi ¿Pairo quero noguiabiritimi yamai? Aroca nangamobiquimi nocoguini naguiatimi. ");
INSERT INTO notNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yotabitanëri Jesos: —¿Aisonori pingamobiquinaca? Nangantasanotëmini aisonori cara queroquerai icaimi tiapa sërari, maba pingantocoquena: “Teni nogótiri”. ");
INSERT INTO notNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aitosati yogometaiguëri irogomere Jesos: —Quero pogaserëtaiganaca. Aroque piquemisanqueri Tosorintsi, yamai pinguemisantaiguena Naro aisati. ");
INSERT INTO notNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Canta itimi Pabati aiti tojaisonori pongotsipague. Queroca pini, nongomantaiguëmiro. Carari yamai najáque nobetsicaiguëmiro canta. ");
INSERT INTO notNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cara najáqueca nobetsicaiguëmiro pongotsi, aique nopigasitaigaantimi Naro nágaiganajimi canta, atiraca ninë obirojegui aitosati pintiomoquina. ");
INSERT INTO notNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pigóiguë obirojegui atiraca najáque, aisati pigóiguëro abatsi. ");
INSERT INTO notNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Icanqueri Tomas: —Natingomi, teni nogóigue atiraca pijáque, ¿Atiroco ongantima ca nogóiguëro abatsi? ");
INSERT INTO notNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yotabitanëri Jesos: —Naro abatsisonori noniaguëmi atiraca ongantima piretaiguëma cara najáque. Aisati noniaguëmiro ora catingasati, aisati nantimacaquimi cara pinguemisanquinanica. Quero pairi játasitirine Pabati Tosorintsi, Naanti iriátanquima cara irarequimari Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Arome pigóquina Naro pigóitëmarime Pabati aisati. Yamai pigóiguëri aroquenta piniaqueri. ");
INSERT INTO notNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Icanqueri Jeripe: —Natingomi, poniagaiguenari Piri, arota nanganinataigae. ");
INSERT INTO notNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yotabitanëri Jesos: —Jeripe, cosamani natsibataiguëmi. ¿Teraico pigóiguena? Ira niaiguëna iniaquerisati Pabati iriro. ¿Pairo pamanobiquina noniagaiguëmiri Pabati? ");
INSERT INTO notNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Teco pinguemina Naro inatsi cara Pabatiquë aisati Ira Pabati inina Naroica? ¿Teco pigóigue Naro aisati nacantari Pabati? Oca nibarintsica ninibataiguimica, teni Naro nibatirone. Ninibatëro ora icanquena Pabati. Ira Pabati Ira inina Naroica Iriro Ira antiro paniro itarobacaare. ");
INSERT INTO notNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pinguemisantina aintana Naro cara Pabatiquë aisati Iriro inina Naro. Teca pinguemisantiro nanibare, pinguenguero cara nitasonganti, aro pinguemisantënaro. ");
INSERT INTO notNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Përosati inibataiguëri irogomere Jesos: —Nangantasantaiguëmini ora aisonori ira quemisanquinane Naro aro inganquero ora nacanti Naro cara nitasonganti Naro. Iritosongasantanë najáqueninta cara Pabatiquë. ");
INSERT INTO notNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Antagaisati pomanaiguëna piquemisanquinaninta Naronta Pitingomi aro nanganquimiro Naro arota ingantocotaiguëri Pabati matsiguenga: “Caninarisonori Tosorintsi ipaigainarinta Itomi”. ");
INSERT INTO notNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nomaiguëmiro pairorapagueraca pomanaiguëna obirojegui piquemisantinaninta Naronta Pitingomi. ");
INSERT INTO notNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Aroca pinintaiguinanica obiro, pinguemisantiro ora nagáantane. ");
INSERT INTO notNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aroca pingantiro, nomanocoqueri Pabati: “Pomagantineri basini Omitocoontatsiri”. Aro imagantaiguëmiro inëmi përosati. ");
INSERT INTO notNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iroonti Caninaro Isëre Tosorintsi ora ogometaiguëmine aisonori. Ira te inguemisantiri Tosorintsi quero yágobëro Isëre Caninaro tenta iraneiro teatisati irogótiro. Carari obiro pigóiguiro aroquenta otsibataiguëmi, aitosati yamai përo cara inaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yamai quero nojocaiganaquimi përosati. Aiquenta nopigaima nantsibataigapaimi. ");
INSERT INTO notNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Caraquesatantata quero iniaigaina matsiguenga, carari aronta nanganiatanae obirojegui piniajina. Përosati pintimaiguë caniarinanta Naro. Naganiataigapaimi përosati. ");
INSERT INTO notNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Cara cataguiteriquë opoque Isëre Caninaro pigóiguë cara ninë Pabatiquë, aisati obirojegui cara Naroquë aisati Naro obirojeguiquë. ");
INSERT INTO notNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ira ogótiro ora nigáantë aisati iquemisantina, inintina aisati, aisati Ira Pabati inintasantiri ira nintina Naro. Aisati naninqueri Naro noniaguëmari iriro. ");
INSERT INTO notNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ira basiniati Joras, cagari Cariotisati, yosamitëri icanqueri: —Natingomi, ¿Pairo poniagobitaiguëna naantijegui, aro quero poniaguiri basiniati matsiguenga? ");
INSERT INTO notNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yotabitanëri Jesos icanëri: —Cara iraninquinaca matsiguenga iriátsaquina ora nacantiri, aro iriro iraninque Pabati. Apa aisa Naro nopogaigapë nantimacagaigapëri. ");
INSERT INTO notNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ira te iranintina teatisati iriátsatina. Oca nibarintsica piquemisantaiguëca obirojegui cagaro nasiati iroonti irasi Pabati Ira agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yamai nocomantaiguëmiro antagaisati oca aintanaquerainta natsibataiguëmi obiro. ");
INSERT INTO notNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cara opogopë Omitocoontatsiri ora jitacha Caninaro Isëre Tosorintsi, iragáquemiro cara nomanaqueri Pabati arota oniagaiguëmiro antagaisati aisati onguiancagaiguëmiro antagaisati ora nacanque. ");
INSERT INTO notNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Përosati icanairi Jesos: —Nimagoriasëreti Naro. Aisati nomaiguëmiro pomagoriasëretaiganaque obiro. Ira te inguemisantina inganinatë arosata yaca quibatsica, carari ora nomëmiro pomagoriasëretaquemi cara paneingomentoquë. Quero pogasëretaiga querootisati pitsorogaigui. ");
INSERT INTO notNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aroque piquemaiguëna cara nacanquemi: “Najátaje aisa nopigaima nantsibataigapaimi aisati”. Aisonorica pinintaiguina pinganinataiganaque cara pigóiguë najátajeni cara Pabatiquë Irironta obatina. ");
INSERT INTO notNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yamai nocomantëmiro negaca arota cara omoncaraquima përosati pinguemisantaiganaque. ");
INSERT INTO notNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yamai quero ninibataigaimi tojai obirojegui aroquenta ipogopë Satanás ira agáqueri iraegui te inguemisantina. Quero ibatina, querootisati yagobeina. ");
INSERT INTO notNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Aro onganquima negaca arota omagaro matsiguenga irogótocotaiguëna nanintasantiri Ira Pabati aisa nantineri ora igátina. Pingabiritaiganaquima intsome. ");
INSERT INTO notNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Përosati icanqueri irogomere Jesos: —Nosiacaro Naro panguirintsi otingomitsa oba. Iriroquerai Ira Pabati aisa icantari ira omisantiro panguirintsi. ");
INSERT INTO notNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iripëshataguequero ora te inantima oguitso. Iroroque ora otsa pinanta oguitso, iritotëro arosata irobetsataguequero arota inasantanë oguitso. ");
INSERT INTO notNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Obirojegui aroque piquëtetantajaro nanibare ora nopaiguëmira. ");
INSERT INTO notNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Coshoni pogaiguina nibega Naro coshoni nogaiguimi. Quero pini oguitso otsapaguequë queroca coshoti pobatsataro otingomitsa. Aitosati picantaro pibega otsa oba. Queroca coshoni pogaiguina quero picantiro ora caninaropague. ");
INSERT INTO notNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Naro otingomitsa oba. Obirojegui otsapague. Ira coshoni yoguina Naro aisati Naro coshoni noguiri iriro inganque tojai caninaro. Queroca coshoni poguina, quero picantëmatiro pairorapagueraca caninaro. ");
INSERT INTO notNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ira quero coshoni yoguina Naro irioquëngani jaara ingasitígatëri Tosorintsi. Ira sërari cantaro pibega otsa ora te inantimaro oguitso, aro iripëshëro osiguiricanë; aro iráguequero iritaguëro. ");
INSERT INTO notNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Aroca obirojegui përosati coshoni pogaiguëna Naro querootisati pomaguisantiro nanibare, pomanina ora picogui, aro nomëmiro. ");
INSERT INTO notNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Cara pingantaiguëro ora caninaro, piniacaguiri matsiguenga iraniacaninatiri Pabati. Aisati pingantaiguëma nogomere caninari. ");
INSERT INTO notNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Përosati icanai Jesos: —Naro nanintasantaiguëmini obirojegui ibeguina Pabati cara inintasanotina Naro. Përo cara coshoni poguina Naro arota pigóigue cara nanintaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pijátsataigueroca ora nigátimi Naro, pigóiguë cara nanintaiguëmini, aisa ocanta naquemisantiro Naro ora igátina Pabati përo cara nacaninati inintinaninta Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iroro ninibataiguëmi negaca arota pinganinasëretasantanë aisa nacanta nacaninati Naro. ");
INSERT INTO notNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yamai nagáiguëmi cara pinintobaganëma aisa nacanta nanintaiguimi obirojegui. ");
INSERT INTO notNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cara ingamobiquerica iramigote ira matsiguenga, iriro inintasanoti. ");
INSERT INTO notNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Obirojegui namigote aroca pinganquero ora nigátimi Naro. ");
INSERT INTO notNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Teni najitaigaimi nomeraro yamai tenta irogótiro iromerataga ora inganque meratari, carari najitaiguëmi namigote aroquenta noniagaiguëmiro antagaisati ora icanquina Naro Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Obirojegui te pingoiguena Naro. Carari Naro nocoigaiguëmi obirojegui aisa nigátaiguëmi pijátaigue pingantiro tojai caninaropague përosati inë. Aique pairorapagueraca pomanocotiri Pabati obironta nasiati, aro imaiguëmiro piquemisantinaninta. ");
INSERT INTO notNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iroro yamai oca nigátimi cara pinintobagaiganaquima. ");
INSERT INTO notNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Përosati icanë Jesos: —Inguisaneinquiminica ira te inguemisante, pinguenguero natsita iguisaneinque cara teraiquerai inguisaneintimi obirojegui. ");
INSERT INTO notNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Iraegui te inguemisantiri Atingomi inintobagaigaca. Querotame piquemisanti obirojegui aisati iranintaiguëmime, carari obirojegui nocoigaiguëmini nágaiguëmi irirojeguiquë nopasiniatitaiguëmi. Iroro iguisaneintaguëtaiguëmi yamai tenta pintsibataiguemarini obiro. ");
INSERT INTO notNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pinguenguero ora nacantaiguëmi cani ira iromerataga quero ibatiri ira meratari. Cara iguisaneinquina Naro matsiguenga aisati inguisaneintaiguëmi obirojegui. Teca inguemisantatsatina Naro querootisati iquemisantatsatimi obiro. ");
INSERT INTO notNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Antagaisati oca aro ingantaiguëmi obironta nasiati. Inguisaneintaiguëmi tenta irogótiri Ira agáquina Naro. ");
INSERT INTO notNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aro nipocasiqueri nocomantaguequeri matsiguenga ora aisonori. Querome nipocasitiri ira te inguemisantina quero iniaiguiri Tosorintsi cara icantomotaguequeri ora te onganinate. Carari yamaica Tosorintsi iniaiguëri cara icantaguetomotasantiri te onganinate. ");
INSERT INTO notNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ira quisaneintina Naro aisati iguisaneintiri Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Querome nitasonganti catingasatiquë irirojegui ora te ingantiro basini matsiguenga, quero iniaiguiri Tosorintsi cara icantaguetomotiri ora te onganinate, carari yamai iniaigabitëna cara nitasonganti përosati iguisaneinquina Naro aisati iguisaneinqueri Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Carari omoncaraca cara isanguenatocoquena comantantatsiri jirai: Iguisaneintasiiguëna te pairo nantabitima. ");
INSERT INTO notNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Cara nagáquemiro Omitocoontatsiri ora jitacha Caninaro Isëre Tosorintsi, Iroro aisonori, omaniëma Pabatiquë aisati ongomantëgotëna Naro. ");
INSERT INTO notNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aisati pingomantëgotaiguëna obirojegui aroquenta pitsibataiguëna cara obirai nacaimaiguë irooti yamai. ");
INSERT INTO notNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Aisati icanque Jesos: —Aroque nocomantaguequimiro oca arota quero pitsoinguiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aiquentata quero inintacaguimi jorío picaigai cara yapatotaiga iriro. Aisati orequima aiquentata cara irógaiguëmi matsiguenga ijique intëneri Tosorintsi caninasati. ");
INSERT INTO notNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Inganquero negaca tenta irogótiri Pabati teatisati irogótina Naro. ");
INSERT INTO notNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nocomantaiguëmiro yamaica arota cara orequimaca cataguiteri, pinguengaigairo ora nacantaiguëmi jirai. Teni nongomantimiro cara jirai aintananta Naro natsibataiguëmi obiro. ");
INSERT INTO notNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Përosati icanai Jesos: —Carari yamai najáqueni cara nantiomopairi Ira agáquena jirai. Quero ini pairiraca osamitënane negaraca najáque. ");
INSERT INTO notNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Carari pogasëretaiganaca cara nocomantëmi cara najátaje. ");
INSERT INTO notNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yamai nongomantaiguëmiro aisonori caninataque cara najátaje. Queroca niátaji quero pipoqui ora omitocotaiguëmine. Carari aroca najátaje, aro nomagantaimiro Naro. ");
INSERT INTO notNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cara opogopë Isëre Tosorintsi onguiancagopëri matsiguenga cara aisonori icantaguetomotiri Tosorintsi ora te ongomeite, aisati oniagapëri ora catingari, aisati ogótacagopëri cara irogóontëmari Tosorintsi ingomantëgotëri matsiguenga pairoraca inganque. Aisati ingomantëgotëri cara iriátë Jonogaguitequë queroca iáti Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ogótacagopëri iriro cantaguetatsiri te onganinate tenta inguemisantinani. ");
INSERT INTO notNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aisati oniagaigapëri matsiguenga cara Naro Caninari aronta najátaje canta íniro Pabati, carari obirojegui quero piniaigaina. ");
INSERT INTO notNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ogótacagopëri cara ingasitígatëri irirojegui Tosorintsi aroquenta icasitígatëri Satanás ira agáiguiri ira te inguemisantiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Arosonori ora nocogui nongomantaiguemi carari obirojegui quero piquemaigabaquero yamaica. ");
INSERT INTO notNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Cara opogopë Isëre Caninaro Tosorintsi Iroro comantaiguëmine omagaro ora aisonori queronta Iroro nibatasitacha. Onganquero antagaisati ora icomantëro Pabati atiraca onganquema aiquentata. ");
INSERT INTO notNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Oniacaninatagaiguëmi Naro Pitingomi aroquenta págaigabaquero ora nasiati aisati oniagaiguëmi obirojegui. Antagaisati ora yogomequero Pabati, irootisati ogometaiguëmi obirojegui. ");
INSERT INTO notNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aisati ora Isëre Caninaro ágobëro ora nasiati ogótacaquimiro Iroronta ogometocoquinane. ");
INSERT INTO notNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Përosati inibatë Jesos: —Caraquesatantata cara quero piniaigaina, caraquentata piniaigaina aisati caranta najátaje cara íniro Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aique yosamitobaguetanaca irogomere Jesos: —¿Pairo oca icantáica Jesos caraquesatantata cara quero aniajiri aique caraquenta aniaigairi? Aisati ¿Pairo ocanti cara iriátë Iririquë? ");
INSERT INTO notNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Pairo ocanti oca nibarintsica caraquentata? Teni anguemaiguero pairoraca inibati Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesos igóqueri cara icogabeca irosomiquerime irogomere aro icanëri: —Aroque nacanquemi caraquesatantata quero piniaigaina carari caraquenta aro piniaigaina. ¿Iroro posaminaitobagaiguëca obirojegui? ");
INSERT INTO notNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nangantasantëmini ora aisonori piraicotaiguëna aisati pigasëretaiguëma carari ira te inguemisante inganinaigabitanëma. Carari obirojegui yamai pigasëretaigabitëma aique pinganinataiganaje. ");
INSERT INTO notNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Obiro aisa picantaro pibega tsinane. Cara ontsomaenica ongatsitasantë aisati ogasëretanëma, carari aroqueca otsomaaqueri otomi quero oquengairo cara ocatsitë carari yamai ocaninatasantanë aroquenta otsomaaqueri otomi. ");
INSERT INTO notNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aisati obirojegui pogasëretaigaca yamai carari Naro nopigaima naniaigaimi, aro pinganinasëretasantaiganaque, quero pairi agasëretacaguimine aisati. ");
INSERT INTO notNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Cara cataguiteriquë quero posamitëmatina. Nangantasantaiguëmini ora aisonori, Ira Pabati aro imëmiro ora pomanaqueri piquemisanquinanta Naro. ");
INSERT INTO notNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Terai obirojegui pomanaigueri pairoraca Naronta Pitingomi. Pomane piquemisanquinaninta aisati págobëroti arota pinganinatasantaiganaque. ");
INSERT INTO notNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Aisati yogomequeri irogomere Jesos: —Nacantaiguëmiro oca quingabaguirentsiquë ora ogomeantatsi, carari orequima cataguiteri cara quero ninibatantaigaimiro quingabaguirentsi. Caraanti catingasati nogometocotaiguëmiri Pabati. ");
INSERT INTO notNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Cara aique pomanaqueri Pabati piquemisantinanta carari Naro quero namaniri Ira Pabati Tosorintsi cara imaiguëmiro obirojegui ora pomanaqueri ");
INSERT INTO notNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","carari Ira Pabati inintaiguëmini pinintaiguinaninta Naro aisati piquemisantaiguina Naro cara nopaniaca Tosorintsiquë. ");
INSERT INTO notNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nisotogopë cara Pabatiquë nipogopë yaca quibatsica, carari yamai nojocanairo quibatsi nopiganajima cara Pabatiquë. ");
INSERT INTO notNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aro icanëri irogomere: —Yamaica pinibataiguëna caninasati. Teni pinibatantimaro quingabaguirentsi. ");
INSERT INTO notNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yamai nigóigui cara pigóque Obiro antagaisati, quero nocogaigai nosamitimi. Iroro ora nigóontaiguëmi cara popaniaca Tosorintsiquë. ");
INSERT INTO notNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yotabitanëri Jesos: —¿Aisonori yamaica piquemisantaiguëna? ");
INSERT INTO notNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yamai orequima cataguiteri, aroque yamaicasonori cara obirojegui pomorocaguetaiganaque jaara panirootipague. Aisati pijocaiganaquina paniro Naro. Carari teni paniro ninë aintasati Pabati yaca Naroica. ");
INSERT INTO notNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yamai nocomantaiguëmiro oca arota pomagoriasëretaigue piquemisantinaninta. Iratsipiriacagaiguëmi ira matsiguengajegui ira te inguemisante yaca quibatsica. Pinganinasëretaiganaque aroquenta nobataiganaqueri irirojegui. ");
INSERT INTO notNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cara itsonquero inibatë Jesos inetsanaque aiquero Jonogaguite icanë: —Pabati, aroque pareca cataguiteri cara inganquina matsiguenga ora picogui Obiro. Yamai pigótacaguiri matsiguenga ora Naro Caninarisonori Pitomi, arota aisati Naro nogótacagaiguëri Obiro Caninarisonori, ");
INSERT INTO notNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","aroquenta pigáquina Naro Itingomi omagaro matsiguenga. Aisati yamai naganiataigairi antagaisati ira picoigaiguë ira popëna. ");
INSERT INTO notNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Obiro Tosorintsi paniro pini. Caninataque irogóiguëmi antagaisati matsiguenga. Aisati caninataque irogóiguëna Naro pigátane, Naro Jesoquirisito. Pairiraca ira ogóquinane Naro aisati irogóquimi Obiro, iriro përosati intiomocái cara Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aroque nitsonquero ora pigáquena nanganque yaca quibatsica arota iraniacaninataiguemi matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pabati, jiraisonoriguinte natiomotimi cara teraiquerai ine quibatsi iniacaninataiguëna omagaro. Yamai nanintini pomainaro nibega cara jirai nantsibatapaimi aisati iraniacaninataina. ");
INSERT INTO notNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Aisati icanë Jesos: —Ica picoigaiguëca popaiguënari yaca quibatsica nigótacaqueri atiraca picanta Obiro. Irirojegui pasi inabita aro popaiguënari cara iquemisantobëro Pinibare. ");
INSERT INTO notNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yamai igóiguë omagaro cara nitasonganti aisati ora nogomequerira omagaro opaniaca cara Obiroquë. ");
INSERT INTO notNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Cara nopaiguëri Pinibare ora popabaquinara, iquemisantaigabaquero igóiganaque yamai cara aisonori nopaniaca Obiroquë igóiganaque aisonori pigáquina Obiro. ");
INSERT INTO notNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Namanocobintiri Naro irirojegui, irari te nomanocotiri ira te irogótina. Namanocobintiri paniro icaegui popaiguinaca irironta pasiatiegui. ");
INSERT INTO notNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Antagaisati ira nasi iriro pasi, ira pasiati iriro nasiati. Iroro iquemisantobitaiguëna aisati iniacaninataiguëna Naronta Itingomi. ");
INSERT INTO notNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naro quero përo cara nini quibatsiquë carari irirojegui përo cara irinaque quibatsiquë. Naro najátajeni Obiroquë nantsibatapaimi. Pabati Caninari, pingábintsaigueri pisintsirequë icaegui popënaca arota inguengasëretaiguema aisati coshoni irogobaquima pibega Obiro aisa Naro aquengasëretanaca coshoni ogobaca. ");
INSERT INTO notNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cara niniquerai quibatsiquë nacábintsantaigacari pisintsire ira popaiguënara. Te pairi pegachane, paniro ira quimingarisonoriguinte ira játënguitsi Sharincabeniquë arota omoncaratima Sanguenari. ");
INSERT INTO notNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Carari yamai najáqueni cara pinasegui Obiro. Yamai cara niniquerainta quibatsica ninibati negaca arota inganinasëretaiganaque nogomere aisati nacanta nacaninati Naro. ");
INSERT INTO notNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naro nogomepëri ora Pinibare carari ira matsiguenga te inguemisante iguisaneinqueri nogomere tenta intsibataiguemarini irirojegui. Irironta nasiati icantina nibega Naro tenta nangantimari ira tsoengatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Te nomanimi páguiri jonoquë carari nomanaquemi pomisantiri arota quero yamatobitiri camagari yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ira nogomere teni aisati ingantimari ira te inguemisante. Icantina nibega Naro te nangantimari ira tsoengatsiri. ");
INSERT INTO notNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pigótacaguiri Pinibare ora aisonori arota inguengasanotantanëmiro cara poganinasëretaigueri cara iriocairo ora te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Obironta agáquina yaca quibatsica, aisati Naro nigáiguëri nogomere arota irogometagueigueri matsiguengajegui ora Pinibare. ");
INSERT INTO notNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Naquengasantimi Naati nomasantimi arota imasantaiguemi iriati nogomere aisonori inguengasantaiguemi irironta pasiati cara inguemisantiro Pinibare ora aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Përosati Jesos yamaniri Iriri: —Nomanocotiri nogomerejeguica carari aisati nomanocotiri antagaisati ira quemisanquerone Pinibare cara ingomantanquero nogomere. ");
INSERT INTO notNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nocogasanti antagaisati irirojegui inguengasëretaiganaquima aisati acanta ibega Eiro aquengasëretaca aisati coshoni ogaca Eiro, Pabati, pibega cara pini Naroquë aisati Obiro cara ninimi Obiroquë, arota coshoni irocái arota ira matsiguengajegui inguemisanquemi cara Obironta agáquina. ");
INSERT INTO notNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Aroque noniagaigacari cara acanta Eiro arota iraniacaninatacái aisati nopacari irirojegui arota nantime iriroquë ninanquimari, pibega Obiro pobabaquina Naro cara pinina Naroquë. Aisati inguengasëretaiganaquima irirojegui arota coshoni irocái Eiro. ");
INSERT INTO notNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aintana Naro irirojeguiquë Obiroquerai aintabi Naroica, arota intsibatobagaiguëma caninasati inguengaiguëma. Aro ira matsiguengajegui iraniaiguëri ica cara iquengaiganaca, irogóiguë cara Obiro agáquina aitosati pinintasantaiguiri icaegui pibeguina Naro cara pinintina. ");
INSERT INTO notNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Cara terai ine quibatsi pinintina. Iroro popaguëtëna cara nosangueguiteti. Yamai, Pabati, nocoguini ira popaiguëna përosati irine Naroica arota iraniaiguena Naronta Itingomi. ");
INSERT INTO notNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pabati Caninarisonori, ira matsiguengajegui te irogótimi carari Naro nigótimi. Aisati igóiguë icaegui nogomereca cara pigáquina Obiro. ");
INSERT INTO notNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nigótacagaiguëri atiraca cara picanta Obiro, aiquero nigótasantacagaiganaqueri cara picanta Obiro cara pinintasantina Naro aisati pinintasantacagaigueri iriro, arota ninantaiganaquimari Naro cara iraneingomentoquë. ");
INSERT INTO notNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cara icaratanë inibatë Jesos isotocaiganaque cara Jerosarénquë Iriro aisati irogomerejegui, cara iáiguë aiquero antatinta nijatini piriatininaro jitacha Serirón. Cara, icaiganaque Iriro aisa irogomere panguirintsisiquë. ");
INSERT INTO notNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Joras ira ágagantëri Jesos aisati igótiro panguirintsisi tojaitaquenta yapatotaiga canta Jesos aisa irogomere. ");
INSERT INTO notNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Cara Joras yarepari Jesos, yamaigapëri soraro aisati ira omisantiro ibango Tosorintsi, ira igáiguë saseriroti aisati bariseo. Yamaigapë irobotanepague aisati irosataamento aisa isabirite aisati anchaqui. ");
INSERT INTO notNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Cara aroquenta igóque Jesos atiraca inganquimara iáque itonguibotobacari yosamitobëri: —¿Pairi picogaigui? ");
INSERT INTO notNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yotabitaiganaqueri: —Ira nocogui Jesos Nasaresati. Jesos yotabitobëri: —Naromë. Aintasati itsibataigapari Joras ira ágagantëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cara icanque Jesos “Naromë”, itëaiganaque itisitaquë, iparigaiganaque irirojegui cara quibatsiquë. ");
INSERT INTO notNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Aisati yosamitaigairi Jesos: —¿Pairi picogaigui? Icantaiganaqueri: —Ira Jesos Nasaresati. ");
INSERT INTO notNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yotabitanëri Jesos: —Aroquemë nocomantaigabitëmi Naro Jesos. Picogaiguinaca Naro, pigátaigairi icaegui nogomere cara iriáigae. ");
INSERT INTO notNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aro ocanca negaca arota omoncaratima ora irinibare Iriati cara icanqueri Iriri: “Ira popaiguënara te pairi pegachane”. ");
INSERT INTO notNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ainta poro irogomere Jesos jitacha Simón Peroro. Yáguëro isabirite itoguimitatëri iromeraro itingomi saseriroti, ira jitacha Máraco. ");
INSERT INTO notNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Carari Ira Jesos igáqueri Peroro: —Pomingairo pisabirite cara poguiroriquë. Iroro agáquina Pabati cara natsipiriaque. ¿Queroco nacantobitiri Iriro? ");
INSERT INTO notNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aique ira soraro aisati igapitante aisati ira omisantiro ibango Tosorintsi yágaiguëri Jesos aique yoguëshobagotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Arotsita yágaiganaqueri ibangoquë Anás. Ira Anás iriconguiri Caijás. Iriro Caijás itingomi saseriroti irooti osarini. ");
INSERT INTO notNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Iriati ira Caijás icomantatsataiguëri cani jorío: “Caninataque poro sërari ira camobiquerine omagaro jorío iragabisaicotaiguëri”. ");
INSERT INTO notNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Peroro yoguiatabitanacari Jesos, aisati itsibatanacari basini irogomere. Ira basinira irogomere igótirinta itingomi saseriroti. Icanaque iriro irooti cara icaaganëngani Jesos iraganguitërequë cara ibangoquë itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Carari Peroro përo cara inë sotoquë. Aique isotogasipairi ira basinira irogomere ira igóti itingomi saseriroti. Inibatapëro ora omisantiro sitëcori cara inganaque Peroro. Aito ca icanaque. ");
INSERT INTO notNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ora omisantiro sitëcori posamitobëri ira Peroro: —¿Cagarico obiro irogomere inta tsomaguininta? Yotabitanëro Peroro: —Cagarina naro. ");
INSERT INTO notNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Arosonorinta catsingaguiteri ira iromeraro saseriroti aisati ira omisantiro ibango Tosorintsi yogamataiguë tsitsi cara irotataiguë. Peroro aisati itsibataigapari cara yotaigasegui ora tsitsi. ");
INSERT INTO notNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ira itingomi saseriroti yosamitëri Jesos: —¿Pairo ijitaiga pogomere? ¿Ati icarati? ¿Pairo pogomequeri? ");
INSERT INTO notNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yotabitanëri Jesos icanëri: —Iquemaiguëna antagaisati matsiguenga cara nogomequeri cara yapatoitaiga jorío aisati cara nogometaiguëri ibangoquë Tosorintsi. Carari tesonori nanibate comanoroni obirojeguiquë. ");
INSERT INTO notNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Pairo posamitobiquina Naro? Posamitaigueri iraegui quemaiguëna. Iriro ogótatsi pairoraca ora nocomantaiguëri. ");
INSERT INTO notNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cara inibatë Jesos negaca, ainta inasegui poro omisantiro ibango Tosorintsi, inchotangaborotëri icanqueri: —¿Aroco picanta pipëgatsatari itingomi saseriroti? ");
INSERT INTO notNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesos yotabitanëri: —Nacanqueroca ora te ongomeite, poniaguinaro. Carari ninibatëca caninasati ¿Pairo pinchotangaborobiriquina? ");
INSERT INTO notNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Aique Anás igáqueri iromeraro: —Piguëshotiguiri. Páganëri cara Caijásiquë itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Iroontita yosamitaiguëri Jesos, iriroquerai Peroro yaratingasegui përosati cara yotaigaseguiro tsitsi. Aro icantaiguëri: —¿Cagarico obiro irogomere ira sërarira aisati? Peroro aisati itsoiganaja icanai: —Cagarina naro irogomere. ");
INSERT INTO notNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ainta iromeraro ira itingomi saseriroti, imatsiguenga ira itoguimitatë Peroro, yosamitëri: —¿Teco naneimi cara pitsibatasegari Jesos cara panguirintsisiquë? ");
INSERT INTO notNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aisati itsoiganaja Peroro icanai: —Teni nogótiri Jesos. Aito cara icaimanë tiapa sërari. ");
INSERT INTO notNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Coniamanisonoriquë ijocaiganaquero ibango Caijás cara yágaiganaqueri Ira Jesos ibangoquë Pirato ora jitacha peretorio. Cagarinta Pirato imatsiguenga, ira joríojegui te ingaigue cara ibangoquë arota quero yoguimingata. Aroca ingaiganaque iroguimingatëma quero yapaigui cara Pásicoaquë cara iquengaiguëro joríojegui cara isotocaigai Ejípitoquë jiraisonori. ");
INSERT INTO notNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Aique isotogopë Pirato cara irinibaiguëri jorío icantaigapëri: —¿Pairo icanque ica sërarica? ");
INSERT INTO notNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yotabitaiganaqueri irirojegui: —Aiti ora intagueque te onganinate. Querome inti ora te onganinate, querome namiri obiroquë. ");
INSERT INTO notNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Icantaiguëri Pirato: —Págaiganaqueri obirojegui pingantaigueri ora ocomantimi isanguenare Moisés. Carari yotabitaiganaqueri jorío: —Teni iranintacaguina Iromasati nógaigueri pairiraca. ");
INSERT INTO notNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aro ocanca cara omoncaraca ora icanque Jesos: “Iribëquëgotaiguëna ira matsiguenga”. ");
INSERT INTO notNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pirato ipiganaja icanaji ibangoquë, aro icaimëri Jesos yosamitëri: —¿Obiroco Itingomi joríojegui? ");
INSERT INTO notNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesos icanëri: —¿Posamitasitina obiati? ¿Aintaco basini comantëmi? ");
INSERT INTO notNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pirato yotabitanëri: —¿Naroco jorío? Yamaigapëmi yaca naroica pomatsiguenga aisati itingomiegui saseriroti. ¿Pairo picanque? ");
INSERT INTO notNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yotabitanëri Jesos: —Cagarina Naro Itingomi yaca quibatsica. Narome Itingomi yaca, arome nagáqueri ira aguiataiguina inguisëcobentaiguename arota quero yágaiguina ira jorío. Naro cantënguicha cagarinanta Naro Itingomi yaca. ");
INSERT INTO notNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aro Pirato icanqueri: —¿Aisonorico obiro Itingomi? Yotabitanëri Jesos: —Naro Itingomi cara picanquina obiro. Iroro nipoguëque. Niboguë yaca quibatsica arota nongomantaigueri matsiguenga caninaro Irinibare Tosorintsi. Antagaisati ira coguiro ora aisonori inguemaquero ora nacanti. ");
INSERT INTO notNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Yosamitëri Pirato: —¿Pairo ojita picanti ora aisonori? Cara icanque Pirato oca isotocanai aisati inibataigairi joríojegui icantaiguëri: —Teni nogótiro pairoraca icantagueque ica sërarica ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Aisati icanqueri Pirato: —Pënibaque orequima Pásicoa cara obirojegui pametaiga nobarataimiri poro iromingaga. ¿Pinintaiguico obirojegui nobarataimiri Itingomi jorío? ");
INSERT INTO notNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aro ira joríojegui icaimaiganaji catsiguesonori icantaiganaque: —¡Ira quero! ¡Pobaratairi Barabás! Ira Barabás irianti cosirinti. ");
INSERT INTO notNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aique ira Pirato yáguëri ira Jesos ipasatagantëri. ");
INSERT INTO notNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ira sorarojegui yobetsiquëneri Jesos imatseiro iroonti totsei, aro imatseitacaqueri iguitoquë. Aisati icaaguëri manchaguintsi quiraaquisaamagori. ");
INSERT INTO notNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aique iásitaigapëri cara inasegui Jesos icantomemegacari: —¿Obiroco Itingomiegui jorío? ¡Intimeta Itingomi jorío! Aisati inchotangaborotaiguëri cara iboroquë Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Aisati Pirato isotogopai cara joríojeguiquë icantaiguëri: —Pinetsaigueri cara nomisotogopëri yaca arota pigóiguë cara te naniatiri pairoraca ora icanque te onganinate. ");
INSERT INTO notNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aito cara isotocanë Jesos imatseiparo totsei icapëro manchaguintsi quiraaquisaamagori. Aro ira Pirato icanqueri joríojegui: —Jerica sërarica. ");
INSERT INTO notNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cara iniaigabaqueri itingomiegui saseriroti aisati ira omisantiro ibango Tosorintsi icaimaiganaque catsigue icantaiguë: —¡Popëicotiri, popëicotiri! Aro Pirato icantaiganaqueri: —Yamai páganëri obirojegui popëicotaigueri obiro tenta naniatirini ora icantagueque te onganinate cara Iriroquë. ");
INSERT INTO notNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Carari ira jorío yotabitaiganaqueri: —Naroeguiquë aiti Sanguenari ogometaiguina caninataque ingame ira jitapënguicha Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cara iquemobëro Pirato oca, itsorogasanotanë. ");
INSERT INTO notNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Aisati icanaji cara peretorioquë, yosamitairi aisati Jesos: —¿Nega popaniaca Obiro? Carari teni irotopitiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aro icanëri Pirato: —¿Pairo te potabitobitina? ¿Teco pigóte Naro itingomi? Cara nocoguica nagántëmi pëicotatsi aisati nocoguica nopabaquëajimi, aro nanganquero. ");
INSERT INTO notNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesos yotabitanëri: —Querome ipimiro Tosorintsi, quero picantëmatina Naro. Obiro picantabequina ora te onganinate carari ira mapëna yaca iriro cantasantëro te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Irooti icogantabitanaca Pirato irapabaquëajirime Jesos. Iroro cantanaacha cara icaimaiganaji jorío: —Aroca popabaquëajiri Ira, te pomatsiguengatimari Sésar. Ira cantasitënguicha: “Naro itingomi”. Iriro Ira quisaneinqueri Sésar pitingomi. ");
INSERT INTO notNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cara iquemobëro Pirato ora inibataiguë jorío, igátaiguëri ira soraro iromisotoqueri Ira Jesos. Yamai iriroque Pirato sobiaquenguitsi iragáantomentoquë jonoica mopë cara yoganinatiro iroro ojita cara irinibarequë ebereo Gabata. ");
INSERT INTO notNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Cara coniamaniquë yobetsicaiguëro Pásicoa, aro icanëri Pirato ira joríojegui: —¡Jerica Pitingomi! ");
INSERT INTO notNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Carari irirojegui icaimaiganaque catsiguesonori: —¡Páganëri! ¡Ingameta! ¡Popëicotiri! Pirato icanëri: —¿Naroco pëquëgotërine Ira Pitingomieguira? Aro ira itingomi saseriroti yotabitanëri: —Naroegui teni irine basini natingomi. Paniro ira Sésar. ");
INSERT INTO notNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aito cara ira Pirato ipaiguëri joríojegui Jesos cara iribëquëgotaiguëri. Irooti cara yágaiganaqueri soraro. ");
INSERT INTO notNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yamai Jesos isotocanë yanatanëro igorosite. Iáque cara oguitojaquë ora ojita Iguito Camatsirini. Aisati irinibarequë ebereo ojita Górogota. ");
INSERT INTO notNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Cara ipëicotaiguëri corosiquë, itsibatacari pite sërari ira ipëicoque aisati cara corosiquë basini. Poro inënguitsi ibacosonoriquë Jesos, basini inë imatepacoquë, carari Ira Jesos Iriro inënguitsi aganguisati. ");
INSERT INTO notNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pirato igáantëneri sanguenari iroquineri jonoica iguitoquë Jesos. Ocanti oca sanguenarica: “Jesos Nasaresati Iriro Itingomi jorío”. ");
INSERT INTO notNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ipëicoqueri Jesos aronisatiquë Jerosarén: iroro ora ipocasitaigaguëtapëri arosonori joríojegui iraniaiguëri. Inibataiguëro jorío ora sanguenari osanguenaca maba nibarintsiquë cara irinibarequë ebereo, aisati guiriego, aisati irinibarequë Iromasati. ");
INSERT INTO notNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Carari ira itingomiegui saseriroti icantaiguëri ira Pirato: —Quero pisanguenatiro: “Itingomi jorío”. Orari pisanguenate: “Icanque Iriro: ‘Naro Itingomi jorío’ ”. ");
INSERT INTO notNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Carari ira Pirato yotabitanëri: —Ora nasanguenaque, ineta. ");
INSERT INTO notNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cara ira soraro itsonqueri ipëicotaiguëri Jesos yágaiguëro ora imanchaqui ipabacaguëcaro icaratinta itsibasati. Aisati yáguëro igamisate ora te ontatima oaga omagatiro. ");
INSERT INTO notNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ira soraro icantobaganaca: —Quero atisaraaiguiro. Intsome omaguimpibintiro arota ogóigue pairiraca áganërone. Yamai aroque imoncaraquero soraro Sanguenari cara ocanti: Ipabacaguetaigacaro nomanchaqui, aisati imaguimpibintëro nagamisate. ");
INSERT INTO notNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Cara aronisati igorositequë Jesos pinaigasegui iniro Jesos aisati irento, aisati María iina Queriojás. Aintasati pinasegui María Magararasato. ");
INSERT INTO notNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ira Jesos cara iniaquero iniro pinasegui cara otsitíquë igorosite otsipasigari poro irogomere ira inintasantë Jesos, icanquero iniro: —Ina, iriro pitomitsari ira. ");
INSERT INTO notNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aro icanqueri ira irogomere: —Iroro pinirotsari ora. Irooti cataguiteriquë ira irogomere yáganairo ibangoquë yomisantëro iniro Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cara igóque Jesos aroque imoncaraquero antagaisati Sanguenari, icanquë: —Nomiretëni. ");
INSERT INTO notNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aiti pinasegui cobiti piagasegaro oja oba cochoari. Aro yogaatëneri chomigatiro cara obaaquë yoguëro chocopiquë ipëri Jesos cara ibagantequë. ");
INSERT INTO notNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Cara ichomicobëro Jesos icanë: —Nitsonquero antagaisati natarobacaare ora igáquina Pabati. Aro imentsononganaca Jesos ipëri Isëre Iriri, icamanë. ");
INSERT INTO notNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iroro cataguiteri cara yobetsicaiguiro jorío Pásicoa. Onguëtaguetanë iroonti sábaro caninaro asi Pasicoa. Tenta iraninte jorío irine igamaga cara corosiquë sábaroquë, iroro ora yamanaguëqueri ira Pirato cara iragáqueri soraro intingaraaguetiri imingaaquë ira pëicotaigasegacha aisati iraguëtaigairi. ");
INSERT INTO notNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aro iátasiqueri soraro itingaraaigapëri imingaaquë ira obasigatsira aisati basini ira itsipasiga Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Cara iniopëri Jesos aroque icamaque; iroro ora te intingaraaguëtiri imingaaquë. ");
INSERT INTO notNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Carari ainta poro soraro yosataantapari irosataamento imeriquiquë. Irooti cara pisotoatanë iraraa aisati nija. ");
INSERT INTO notNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ira comantairo oca iriro neiro isanguenaquero ora aisonori. Yamai igótasantiro iriro aisonori arota obirojegui pinguemisantaiguero cara pinibataiguëro oca Sanguenarica. ");
INSERT INTO notNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aro ocantagueca negaca arota omoncaratima ora Sanguenari cara ocanti: Quero itingaraitiri poro itongui. ");
INSERT INTO notNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aisati ocanti basini Sanguenari: Aro iraniaigairi Quirisito Ira yosataaque. ");
INSERT INTO notNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aique ira José ira paniacha poeboroquë jitacha Arimatea yamanopëri Pirato cara iráganëri igamaga Jesos. José iriro ira aguiatabitari Jesos comanoroni, itsoroquerininta jorío. Aro ira Pirato inintacaqueri ira José. Aro yáganeri igamaga Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Aisati yarepa Nicoremo ira nibaqueri Jesos jirai tsitiniriquë. Yamapë 30 quiro casangajengaro ojita mira aisati ároes. ");
INSERT INTO notNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Aique José aisati Nicoremo yágaiganaqueri igamaga Jesos iponatantaigacari tocoya aisati casangajengaro aronta icantaiguiro iriro cara yametaigaro joríojegui cara itiaiguiri igamaga. ");
INSERT INTO notNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Cara ipëicotaiguëri Jesos aiti panguirintsisi aronisati aiti pinasegui iritijomento irorai terai iritijantimaro. ");
INSERT INTO notNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aro cara itiaqueri Jesos aitoniati pinasegui iritijomento aroquenta pënibaque omarintanëma sábaro. ");
INSERT INTO notNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cara coniamanisonoriquë cataguiteriquë tominco, piáque María Magararasato cara itiaca Jesos, cara terai onguëtaguetasante, oniopëro oquibe mopë aroque pasiriaa. ");
INSERT INTO notNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pisigasanotanaca María Magararasato cara inasegui Simón Peroro aisati inasegui ira irogomere Jesos ira inintasanoti, ocantaigapëri: —Yáguëqueri Atingomi. Teni irinaje cara itiabecariri. Teni nogóte negaraca yogairi. ");
INSERT INTO notNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ira Peroro aisati basini irogomere isotocaiganaque iáiguë cara itiaca Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pitirooti isigaiganaca, carari ira basini irogomere iriro sigasantanënguicha ibatanëri Peroro iritsita arequenguicha. ");
INSERT INTO notNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Inetopisigapëro cara itiaca Jesos iniopëro tocoya aroque papinaguiricaa, carari te ingue. ");
INSERT INTO notNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aique yarepa Simón Peroro icanaque iriro cara itiaca Jesos. Aisati iriro iniopëro ora tocoyatsa aroque papinaguiricaa. ");
INSERT INTO notNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ora tocoya ora yoguëneri iguitoquë casiriconiati pinasegui caninasati. ");
INSERT INTO notNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ira iritsita arepënguicha naarai icanaque iriro yamai. Iniajiro tocoya yamai iquemisanque ");
INSERT INTO notNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","teraiquerainta inguengairo cara ocanque Sanguenari Ira Jesos inganiatanae. ");
INSERT INTO notNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yamai ipigaiganaja pitirooti irogomere Jesos cara ibangoquë. ");
INSERT INTO notNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ora María përo cara pinë sotoquë aronisatiquë iritijomento piraca. Cara piragasega onetopique aiquero tsomagui ");
INSERT INTO notNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","oniaqueri pite ironomire Tosorintsi iquiro catarisonori imanchaqui. Isobiaque cara inabitaca Jesos. Poro inënguitsi cara iguitoquë Jesos, ira basini ironomire inasegui cara iguitiquë. ");
INSERT INTO notNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yosamitëro: —Tsinane, ¿Pairo piraicoque? Iroro ocanqueri: —Niraicoqueri Natingomi yáganënganinta te nogóte negaraca yogairi. ");
INSERT INTO notNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cara pitsonque María pinibatë, papisitanaca aiquero otisitaquë, oniaqueri Jesos carari te ogótiri. ");
INSERT INTO notNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aro yosamitapëro Jesos: —Tsinane, ¿Pairo piraicoque? ¿Pairi picogui? Iroro ojiqueri ira omisantiro panguirintsisi, aro ocanqueri: —¿Obiroco áganairi Natingomi? Pingomantina negaraca pogairi. Nocoguini náganairi naro. ");
INSERT INTO notNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesos icanquero: —¡María! Onetsairi aisati ocanqueri nibarintsiquë jitacha ebereo: —¡Ogometinari! ");
INSERT INTO notNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ira Jesos icampëro: —Popabaquëina terainta najáte cara íniro Pabati. Yamai pijáte pingantaigapëri naguemisantacagane ira quemisantaiguina pingantiri cara aique nogainocanëma cara Pabatiquë nasi aisati pasiegui Piri. Ira Tosorintsi nasi aisati Iriro Pitosorintsite obiro. ");
INSERT INTO notNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aito cara piáque María Magararasato cara ongomantaigapëri ira irogomerejegui ocampëri: —¡Naniajiri Atingomi! Aisati ocomantaiguëri omagaro ora icanquero Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Aro irooti cataguiteri tominco chopiniguite yapatoitaigasega irogomere Jesos. Aro yasitaiguëro sitëcori itsorogaiguërininta joríojegui. Aro iquëgotapëri Jesos yaratingopë aganguisatiquë cara irogomerejeguiquë. Yobetsatapaari icampëri: —Obirojegui, pomagoriasëretaigue. ");
INSERT INTO notNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cara icampëri oca, yoniagaigapaari ibaco aisati cara imeriquiquë cara yosataaqueri soraro. Ira irogomerejegui icaninatasantaiganaji cara iniaigabajiri Itingomi. ");
INSERT INTO notNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aisati yogatsitairi Jesos icantajiri: —Obirojegui, pomagoriasëretaigue. Cara igáquina Pabati Naro jirai, aisati Naro nagátaiguëmini obirojegui yamai. ");
INSERT INTO notNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Irooti cara itasongaiguëri irirojegui icanqueri: —Coraque pinampëmi Caninaro Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ira matsiguenga comantaguetirine Tosorintsi ora icantagueti te onganinate aisati inguemisanquena Naro, pingantiri: “Aroque ijocajimiro yomaguisanquimiro Tosorintsi ora picantaguetomotiri te onganinate. Teni inguisaneintajimi”. Aintaca matsiguenga ira te ingomantaguetiri Tosorintsi ora icanti te onganinate, pingantiri: “Querootisati ijocajimiro Tosorintsi ora picantaguetomotiri te onganinate. Përosati iguisaneinquimi”. ");
INSERT INTO notNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Cara yoniagaigapaari Jesos irogomerejegui te irinasegue Tomás ira jitacha aisati Tsipari. Basiniegui irogomere icomantairi Tomás: —Naniaigairi Ira Atingomi. ");
INSERT INTO notNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Icanque ira Tomás: —Queroca naneiro ibacoquë cara oquenaqueri carabo, queroca nominguiro nobatsapaco, querootisatica nominguiro nobaco cara yosataaqueri soraro, quero naquemisanti. ");
INSERT INTO notNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pabisanaque 8 cataguiteri. Aisati yapatoitaiga antagaisati irogomere Jesos cara pongotsiquë. Aisati yasitocoigasega. Yamaica ainta Tomás itsipaisigari irirojegui. Aisati iquëgotapairi Jesos inasegopë aganguisati irogomerejeguiquë, yobetsatapaari icampëri: —Obirojegui pomagoriasëretaigue. ");
INSERT INTO notNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aique icampëri Tomás: —Pinetsero nobaco. Pominguero pobatsapaco. Aisati pominguero pobaco yaca yosataaquina soraro. Quero pitsoinguina, pinguemisantina. ");
INSERT INTO notNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aique yotabitanëri Tomás: —Obiro Natingomisonori, aisati Obiro Notosorintsite. ");
INSERT INTO notNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesos icanqueri: —Tomás, aroquenta piniaquena yamai, piquemisanquina. Ainta basini ira te iraneina carari iquemisantaiguëna. Inganinatasanoiganaque iriro. ");
INSERT INTO notNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesos itasongasantomotaiguëri irogomere tojai ora te osanguenatima yaca Sanguenarica. ");
INSERT INTO notNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ora itasonganque Jesos osanguenaca yaca Sanguenarica arota obirojegui pinguemisantaigueri Jesos Iriro Quirisito ora ocanti Agabisaicoontatsiri. Iriro Itomi Tosorintsi. Aroca pinguemisanqueri përosati cara pintiomoqueri Iriro Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aique Jesos yoniagapaari aisati irogomere cara onamijaquë angaare jitacha Tiberias. Yoniagapaari negaca. ");
INSERT INTO notNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cara, inasegaigui ira Simón Peroro aisati Tomás ira ijita Tsipari. Aisati Natanael ira paniacha poeboroquë jitacha Caná cara Garireaquë, aisati ira itomijegui Sebereo, aisati pite basini irogomere. ");
INSERT INTO notNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Aro ira Simón Peroro icantaiguëri: —Aique najáque nasiriatëni. Aique icantaiganaque iriro: —Aisati naroegui naguiataiganaquemi. Iáiguë yotetaiganacaro pitotsi, isiriataigabitaca omagaro tsitiniriquë, cara te iráguëmate. ");
INSERT INTO notNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cara pënibaque onguëtaguetanë, Jesos inasegui onamijaquë angaare, carari irogomere te irogóigueri Iriro. ");
INSERT INTO notNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aro Ira Jesos icaimëri: —Janequijegui, ¿Te págaigue sima? Yotabitaiganaqueri irirojegui: —Teni. ");
INSERT INTO notNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aique igáqueri: —Atsi pijoquiro pisiritite aiquero pobacosonoriquë, aro págaiguëri sima. Aro ijocaiguëro. Yamai te iragabiairo intinaajiro isiritite iacaronta sima. ");
INSERT INTO notNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Cara iniaqueri arosonori sima aito icanque ira inintasanoti Jesos: —¡Iriro Atingomi! Cara iquemobë Simón Peroro Iriro Itingomi icanaquero imanchaqui saacanarinta inasegui, imatsecanë cara angaarequë. ");
INSERT INTO notNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Iraegui basini irogomere yaretacaganaaro pitotsi cara onamijaquë inosicaiganaquero isiritite jagacanta sima. Aitoniatinta onamija omoncarata 100 metoro. ");
INSERT INTO notNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cara yaguëtaiganaque quibatsiquë iniaigapëro tsitsi itasisiga paniro sima aisati pan. ");
INSERT INTO notNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesos icantaigabaqueri: —Pomaigapë sima ira pisiriataiguëra yamai. ");
INSERT INTO notNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Peroro yotetanaa pitotsiquë, inosicapëro siriti irooti cara onamijaquë iacaro sima iriantisonori iguibe icarati 153, tojai inabita carari te ontisaraaima siriti. ");
INSERT INTO notNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Aro icantaiguëri Jesos: —Omana popaigapë. Carari te irine poro irogomere ira osamitirine pairiraca ijita, igóiguërinta Iriro Itingomi. ");
INSERT INTO notNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Aique Jesos yáguëro pan ipaiguëri irogomere aisati ipaiguëri sima. ");
INSERT INTO notNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yamai ocarati maba cara yoniagaari irogomerejegui cara aroque icamaque icaniatanai Jesos. ");
INSERT INTO notNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cara itsongaiguë yapë, Jesos yosamitëri Simón Peroro: —Simón itomi Jonás, ¿Pinintasantina Naro pibegaiguiri icaegui? ¿Pinintasanotina obiro? Yotabitanëri Peroro: —Jee, Natingomi, Obiro ogótatsi nanintimi. Icanëri Jesos: —Yamai pingantimari ira omisantiri itiomijani oisha. Pomisantaiguenari ira quemisanquina. ");
INSERT INTO notNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yogatsitairi Jesos yosamitairi: —Simón itomi Jonás, ¿Pinintasantina? Yotabitanëri Peroro: —Jee, Natingomi, Obiro ogótatsi nanintimi. Icanqueri Jesos: —Yamai pomisantinari noishate. ");
INSERT INTO notNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mabatanë yosamitairi: —Simón itomi Jonás, ¿Pinintina? Yamai Peroro yogasëretanaca yosamitërinta ocarati maba aisonorica inintiri. Icanqueri: —Natingomi, Obiro ogótiro antagaisati. Pigóti cara nanintimi. Icanëri Jesos: —Pomisantinari noishate. ");
INSERT INTO notNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nangantasantëmini aisonori, cara jirai oboinaqueraibi piquiro pomanchaqui obineni piátagueque cara negaraca picogui pijáte. Carari cara pintiasiparitanë pintimagonaguitëma ira basini iriro caaguëmirone pomanchaqui aique iráganëmi cara te pininte pijáte. ");
INSERT INTO notNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Aro icanqueri negaca Jesos. Irooti yogomeantari aisati icomantëri atiraca inganquima Peroro cara ingamaquenica, inganqueri matsiguenga iraniacaninatobëri Tosorintsi. Aique Jesos icanëri: —Piguiatapëna. ");
INSERT INTO notNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Cara yapisitaanaca Peroro, iniobëri cara yoguiataiganaqueri ira irogomere inintasanti Jesos. Iriati ira itsipasiga coshoni Ira Jesos cara yapaigasegui cani aisati yosamitëri: “Natingomi, ¿Pairi ijita ira ágagantëmine?” ");
INSERT INTO notNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cara iniobëri Peroro, yosamitëri Ira Jesos: —Natingomi ¿Iriroque ica, ati inganquima? ");
INSERT INTO notNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yotabitanëri Jesos: —Aroca naninque Naro intimaque irooti cara nopigaima Naro, quero pogasëreta obiro. Obiro piguiatapëna. ");
INSERT INTO notNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aique iquemaigabaquero omagaro quemisantatsiri ijitabetaigaca quero icami ira irogomere inintasanoti Jesos. Carari Jesos te ingantiri cara quero icami. Patiro icanqueri: “Aroca naninque Naro intimaque irooti cara nopigaima Naro, quero pogasëreta obiro”. ");
INSERT INTO notNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iriati ica irogomere neiro oca aisati iriatisati sanguenatëro. Eiro ogóiguëro cara icanque aisonori. ");
INSERT INTO notNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Aiti arosonori ora icantagueque Jesos. Arome irisanguenatëro patiropague oca, querome cotonguiboro omagaro quibatsiquë ora sanguenatënguichaneme. Joan ");
INSERT INTO notNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ora noguibatëmi, Tiójiro, nasanguenaquemi jirai. Nocomantëgotëri Jesos antagaisati ora icanque aisa ora yogomeantë cara iparintaca ");
INSERT INTO notNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","irooti cara yogainocanaa cara yáganëri Tosorintsi Jonogaguitequë. Teraiquerai iriáte Jesos jonoquë icoigaguequeri iragátane, icomantaiguëri ora inganque. Icomantancari Isëre Caninaro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Aroqueque icamaque Jesos icaniatanai yoniagaigapaari iragátane. Tojai Jesos yoniagapinintaigaari arota irogóigue cara aisonori icaniatanai; cara ocarati 40 cataguiteri iniaigairi. Aisati yogometaiguëri ora iragáantane Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cara yapaagaiguëri Jesos icanqueri: —Quero piáigui. Pinëni yaca Jerosarénquëca irooti cara imagantëmiro Pabati Isëre Caninaro ora nocomantaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ibaotisatancaro nija Joan, carari yamai arosataanti cataguiteri iroquemiro Caninaro Isëre Tosorintsi obirojeguiquë, inasërepëmi. ");
INSERT INTO notNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ira botoitacha yosamitaiguëri ira Jesos: —Natingomi, jirai aiti iragáantane omatsiguenga Isirael. Yamai te iraniajiri. ¿Yamaica piguipigairo? ");
INSERT INTO notNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yotabitanëri Jesos: —Teni ingogue Pabati pigóiguero ora inganque Iriro. Teatisati pigóte ati ongantima inganquero. Paniro igóti Iriro. ");
INSERT INTO notNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Orari Isëre Caninaro Tosorintsi inanquemi omitocoquemi ogabiaquemi. Iroro pingomantaguetocotaguëquena yaca Jerosarénquëca, aisati Joreaquë, aisati Samariaquë, irooti antagaisatiquë quibatsi. ");
INSERT INTO notNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aroque inibataiguëri Jesos, aique iáque yogainocanaa jonoquë. Ipaniguiaigabaqueri irooti cara isorocanaque mingoriquë te iraniaigabajiri. ");
INSERT INTO notNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iroontinta inetsaigabaqueri Jesos cara yogainocanaa, ainta inapë pite ironomire Tosorintsi icapëro iguitsagare catarosonori ");
INSERT INTO notNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","yosamitapëri icampëri: —¿Aintajeguibi, Garireasati? ¿Pairo pinetsabiriti cara Jonogaguitequë? Iriati Jesos ira yáganë Tosorintsi jonoquë, caraquesatantata iribocapae. Cara iáque aisati ingampaima cara iripigaima. ");
INSERT INTO notNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aro ipigaigapa iragátane cara oguitojaquë jitacha Olibos poro quirometoro irooti Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cara Jerosarénquë yapatoica iragátane Jesos jonoquë pongotsiquë cara itimaiguë. Ainta Peroro, Joan, Santiago, aisati Antiris, Jeripe, Tomás, aisati Baritoromé, Mateo aisati basini Santiago itomi Arijeo, Simón ira nintasantiro ibaísite, aisa Joras imatsiguenga Santiago. ");
INSERT INTO notNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iquengaigaca përosati cara yamanaigui. Itsibataigari ireinti Jesos, aisati María iniro, aisati tsinanepague. ");
INSERT INTO notNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pabisanaque arosataanti cataguiteri. Yapatoica ira quemisantiri Quirisito icarati 120. Yaratianque Peroro cara aganguisatiquë icanë: ");
INSERT INTO notNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Nopiguemisantacagane, aroque omoncaraca ora isanguenaque David jirai, osanguenatacaqueri Isëre Caninaro Tosorintsi. Isanguenatocoqueri Joras ira obatacaganëri ira águëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ira Joras itsibatabitaiguëna cara naquenguitsatomotiri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Aique Joras ipimantëri Jesos yágancari quirequi. Aique iáque ipariaque Joras itsirapë pisotosetanë iramaretsa. Ira basini matsiguenga yágairi iguireguite yamanantancaro quibatsi cara iritijiri camatsiri paniacha jaanta. ");
INSERT INTO notNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iquemocoqueri antagaisati Jerosarésati, aro ijiquero irinibarequë iguebatsite Asérarama ora ocanti quibatsi asi araatsi. ");
INSERT INTO notNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Cara jirai osanguenaca iribiroquë jitacha sárimo: ¡Querotasha pairi timapatsi cara itimirori iriro! Aisati ocanti: Iripëgairita basiniquerai sërari. ");
INSERT INTO notNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Yamai përosati inibatë Peroro: —Ainta matsiguenga tsipataiguëna cara jirai naniaqueri Joan ibaotisatantagueque aisati itsibataiguina iniaqueri Jesos irooti cara icamaque icaniatanai yogainocanaa. Yamai iroro caninatënguitsi nongoiguëri paniro matsiguenga intsibataiguëna cara nongomantëgotëri Jesos cara icaniatanai. ");
INSERT INTO notNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aro iquengaigaca irogaiguëri pite sërari: José aisa ijita Barasabás aisa ijita Jósito, aisati basini sërari ijita Matías. ");
INSERT INTO notNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yamanocoqueri: —Obiro, Natingomi, pigótasantiro iraneingomento antagaisati matsiguenga. Yamai ainta yaca pite sërari. Poniagaiguenari pairi pininti ");
INSERT INTO notNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","pëgairine Joras ira tsipataigabitëna jirai iragátane Jesos aique icantaguetomotimi iáque iraisatiguitequë. ");
INSERT INTO notNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Aro yosocaiguëro mopëquipague ora irogóontëmari pairiraca ingoiguë Tosorintsi. Aro icoiguëri Matías yogaiguëri intsibatëmari iragátane Jesos icarati 11. ");
INSERT INTO notNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Parepa cataguiteri jitacha Pentecosités. Yapatoitaigaca antagaisati ira quemisantiri Quirisito. ");
INSERT INTO notNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Iroguito iquemaigabaquero cantaca coguentima oquibeguinte cara jonoquë. Pipogopë cara inaigasegui pongotsiquë piacaro. ");
INSERT INTO notNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Oconijatomopëri ocamparo pamaminguiro. Ipamagueque antagaisati. ");
INSERT INTO notNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iroonti Isëre Caninaro Tosorintsi. Aisati pinasërepëri antagaisati irirojegui coshoni pogaigapëri. Iparintaiganaca inibaiganaquero basinipague nibarintsi pinibataganërinta Caninaro Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Aroqueque yapatoica cara Jerosarénquë tojainisonori joríojegui ipaniaguetaca jaapaguenta. Ipocasiti iromanaiguëri irinibaqueri Tosorintsi aroquenta iquemisantasantëri. ");
INSERT INTO notNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iquemocotaigapëri iragátane Jesos ira nibataguetatsi. Yapatobiripari. Te irogóigue pairoraca inguenguema cara iquemopëro antagaisati irinibaresonori. ");
INSERT INTO notNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iquenganeintasanotaigapa icampë: —¿Teco irirojegui Garireasati nibatatsica? ");
INSERT INTO notNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Atiraca ocanta naquemaigapë inibataiguëro nasiati nanibare paniropague? ");
INSERT INTO notNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ainta yaca matsiguengapague ipaniaigaca Páratiaquë, aisa Meriaquë, aisa Eránquë, Mesopotamiaquë, Joreaquë, Caparosiaquë, Pontoquë, Asiaquë, ");
INSERT INTO notNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Jirijiaquë, Pampiriaquë, Ejípitoquë, Iribiaquë aronisatiquë poeboro jitacha Sirene. Aintasati Iromasati. ");
INSERT INTO notNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Irirojegui jorío aisati ira aretaigacha quemisantiri Tosorintsi aisa icantari jorío quemisantiri. Aintasati Queretasati aisa Arabiasati. Naroegui naquemaiguëri inibataiguëro nasiatiegui nanibarepague. Icantaiguë inibatëcoiguëri caninarisonori Tosorintsi itasorintsitasanoti. ");
INSERT INTO notNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iquenganeintasantaiganaca antagaisati te irogóigue pairoraca inguenguema. Yosaminaitobaganaca: —¿Pairo ocanti? ");
INSERT INTO notNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ainta basini icabíntsáqueri icanque: —Isinguitaigacani. ");
INSERT INTO notNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yaratinganë Peroro aisati basini iragátane Jesos icarati 11, inibatasantëri catsigue Peroro: —Nomatsiguenga joríojegui, aisati obirojegui timaigatsi yaca Jerosarénquëca, pinguemaiguena ora nongomantëmi yamai. ");
INSERT INTO notNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Icaegui matsiguengaca teni irisinguitima cara piquengaigaca obirojegui terainta irionogate paba. ");
INSERT INTO notNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iroro oca isanguenatocoque jirai Joel comantantatsiri cara isanguenaque: ");
INSERT INTO notNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Icanë Tosorintsi: “Aiquentata nomaiguëri Nasëre Caninaro noguëneri cara matsiguengapaguequë. Ingomantëgotëna Naro pitomijegui aisati pisintojegui. Naro oniaguequerine oboinapague pairorapagueraca. Ira antiasiparipague inguisanitagueque. ");
INSERT INTO notNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aisati noguequeronta Nasëre Caninaro noguëneri ira quemisantina sërari aisa tsinane. Aro ingomantëgotëna. ");
INSERT INTO notNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Cara jonoquë noniagaiguëmiroti ora pinguenganeintasantanquima. Osobica quibatsica noniagaiguëmiroti basiniati pinguenganeintasantanëma: tojaiti iraraa, tairingachari, arosonori catsiaguetaque inanë. ");
INSERT INTO notNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ira paba intsitinitanë aisa ira manchacori inguiraatanë cantaca araatsi cara queroquerai ipoqui Atingomi irogótocotaiguëri omagaro matsiguenga ingomantëgotaigapëri. Iroro cataguiteri cobeingaguiterosonori. ");
INSERT INTO notNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pairiraca abenquimarine Atingomi iromanaqueri aito iragabisaicoqueri”. Aro ocarati ora isanguenaque jirai Joel. Përosati cara inibatë Peroro: ");
INSERT INTO notNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","—Nomatsiguenga joríojegui, pinguemaiguena ora nanganquemi. Yamai yoniaguëmi Tosorintsi cara iniacaninatëri Ira Jesos Nasaresati. Itasongagueantë, icanquero ora te aneiro jirai ora piquenganeintasantantanaca cara itasorintsitantagueque Jesos ora pigóontëmari cara igáqueri Tosorintsi icantaguequero pairoraca. Pigótabecaro obirojegui. ");
INSERT INTO notNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jiraisonori iquianca Tosorintsi, aro igáqueri Itomi ingamaque yaca quibatsica. Obiro ógaiguëri cara popabaqueri ira basiniati matsiguenga catsimari ipëicotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Irari Tosorintsi itinaajiri yoganiatairi aisatitanai. Yamai quero icamaji. ");
INSERT INTO notNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jirai David isanguenatocoqueri: Përosati naneiri Natingomi catingasatiquë naro. Itsibatëna coshoni yoguëna imitocotina ora quero notsorogui. ");
INSERT INTO notNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Iroro nacaninasëretaguëque ninibatëgotëri caninasati. Aitosati nobatsa omagoriaque caninasati ");
INSERT INTO notNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","queronta pijoquinaro nasëre osobiquë, querootisati pinintacaguina pibatsaagui nobatsa naronta piniacaninatë. ");
INSERT INTO notNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Aroque poniaguënaro negaraca cara narequimi carari yamai përosati nantiomoquemi, obiro poganinasëretëna naronta pintsibatëma. Iroro ora isanguenaque David jirai. Përosati inibatai Peroro: ");
INSERT INTO notNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","—Nomatsiguengajegui, nanibatëgotëri David catingasati. Igóiguë eiroegui icamaque David omatsiguengajegui cara jirai, itiaca yaca përosati irooti yamai. ");
INSERT INTO notNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ira David comantantatsiri igótasanti aroque icomantasantëri Tosorintsi icanqueri: —David, aiquenta noguëri Itingomi pigáantomentoquë Irironta pomatsiguengasonori. ");
INSERT INTO notNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","—Teraiquerai intinaajima Jesoquirisito igótocoqueri David inibatëgotëri Quirisito cara inganiatanae. Icanque David quero ojocagani isëre osobiquë, querootisati pibatsaagui ibatsa. ");
INSERT INTO notNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iriati Jesos icabiriqueri yoganiatairi Tosorintsi. Naroegui irogomere Jesos naniaigairi Irineniati. ");
INSERT INTO notNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tosorintsi yoguëri Itomi ibacosonoriquë. Aisati ipëri Isëre Caninaro Iriri icomantasantëri jirai. Yamai antagaisati oca piniaiguëca aisati oca piquemaiguëca ipaiguënaro naroegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Cara terai iriáte Jonogaguitequë David icanque: Tosorintsi icanqueri Quirisito Natingomi: “Pisobique yaca nobacosororiquëca ");
INSERT INTO notNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","irooti cara intingomintaiguëmi ira quisaneinquemi”. ");
INSERT INTO notNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","—Yamaicari nocoguini irogóigueta antagaisati joríojegui Iriati Jesos pipëicotaiguë obirojegui, aroque Tosorintsi icanqueri Atingomi aisa Ira Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cara iquemaguetobëro irinibare Peroro oshabitapëri joríojegui iraneingomentoquë, inibataiganaqueri Peroro aisa basini iragátane Jesos, yosamitaiganaqueri: —Nomatsiguenga, ¿Pairo nangantaiguë? ");
INSERT INTO notNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yotabitaiganaqueri Peroro: —Pingantaigaima yacaqueroca, pabentaiguemari Jesoquirisito, pomaotisabiritaiguemari Iriro arota irojocajimiro Tosorintsi ora picantaguetaigui te onganinate, quero iquengaimiro. Aro coshoni irogaiganajimi ingábintsaigaimi. Aro imasitaiguëmiro Caninaro Isëre aisati. ");
INSERT INTO notNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Imasitëmiro obirojegui, aitosati imasitëmari pijaniquitejegui, aisa antagaisatijegui matsiguenga ira ingaimë Atingomi Otosorintsite. ");
INSERT INTO notNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Iroroca nibarintsi aisa basini tojai icomantaguetiri Peroro icanqueri: —Quero posigajari yamai ica matsiguengaca icantaguetomotiri Tosorintsi ora te onganinate, te inguemisantiri. Pinguemisantiri obiro Tosorintsi arota iragabisaicoquimi irojocajimiro ora pintagueti te onganinate. ");
INSERT INTO notNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aro iraegui quemisanquero irinibare ibaotisataigaca icarati 3,000. Yamai itsibataigacari quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Përosati iquemisantaiguëro ora yogomeantë iragátane Jesos, iquengasëretaigaca, yapatotaigaca, yamanaiguë, itsibatobagaigaca itingaraguequero pan iquengasëretantaigacari Jesos Ira camobiqueri. ");
INSERT INTO notNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iquenganeintasantaiganaquero antagaisati basini matsiguenga itsorogaiganaquero cara itasorintsitagueiguë iragátane Jesos imitocotaiguërinta Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Përosati iquengasëretaiganaca ira quemisantatsi aisati ipaguetobaganaca ora iraisati iriro, te iromichate. ");
INSERT INTO notNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ipimantaguequero ora yasinta quemisantatsiri yotsatengaiguëri ipaguetëri ira coguitiaro pairoraca. ");
INSERT INTO notNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Antagaisati cataguiteri yapatoitopiantaca cara oquibequë pongotsi irasi Tosorintsi. Aisati yapaiguë pan ibangopaguequë. Icaninasëretaiganaque. Aisati caninari iraneingomentojegui. ");
INSERT INTO notNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Inibabentocotaiguiri Tosorintsi: —Icaninatasanoti. Ira Jerosaresatijegui iniacaninataiguëri ira quemisantatsiri. Përosati Tosorintsi yogabisaicoqueri ira irirai quemisanqueri Quirisito. Itsibataigari ira botoibiritari Jesoquirisito. ");
INSERT INTO notNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Chopiniguite iáiguë Peroro aisa Joan itanë cara oquibequë pongotsi irasi Tosorintsi. Iáque iromanaque irinibaqueri Tosorintsi ora yameta joríojegui. ");
INSERT INTO notNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Cara omoroquë jitacha caninaro ainta inasegui paniro sërari carancaratatsi. Te iranëitëmate cara iboguë jirai irooti yamai. Antagaisati cataguiteri iráganëngani cara omoroquë iromanaguequeri ira bocatsi imëri quirequi. ");
INSERT INTO notNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cara iniobëri Peroro aisa Joan cara inganaqueme yamanobëri quirequi icabëri: —Pingantaneintëgotina, pomena quirequi. ");
INSERT INTO notNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Inetsaigapëri Peroro aisati Joan, icampëri: —Pinetsena. ");
INSERT INTO notNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Inetsëri ininti irágobëri pairiraca. ");
INSERT INTO notNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Carari icanë Peroro: —Teni irine nasi naguireguite, teatisati oro. Yamaica iroonti ora inatsi nomëmi. Nanganqueri yamai Jesoquirisito Nasaresati iranëitacagajimita. Pingabiritima panëitanë. ");
INSERT INTO notNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peroro yáguëri ibacosonoriquë imitocoqueri cara iraratinganë. Aito cara osintsitanai iguiti aisati igueroqui. ");
INSERT INTO notNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Omanapague icabiritanaca yanëitasantanai. Itsibatacari pitirooti tsomagui oquibequë pongotsi irasi Tosorintsi. Yanëitanë, imatsematsetanë, inibabentocotajiri: —Caninari Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tojainisonori matsiguenga iniaiguëri cara yanëitasegui inibabentocoqueri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Igóiguëri irironta ira sobigantetatsi cara omoroquë caninaro oquibequë pongotsi irasi Tosorintsi, yamanopiantë quirequi. Iquenganeintasantaigacari matsiguenga. Teni irogóigue atiraca icanca. ");
INSERT INTO notNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cara ibeganaa carancaratabetacha te irapabaquëicotiri Peroro aisati Joan cara isotocanë. Cara omoroquë jitacha iraisati Saromón isigaigapa matsiguenga iquenganeintasanotaigapa. ");
INSERT INTO notNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peroro iniaiguëri matsiguenga yosamitobëri: —Nomatsiguenga ¿Pairo piquenganeintasantobiqueri ica? ¿Pairo pinetsabiritaiguëna? Cagaro natasorintsite noganëiantaari. Querootisati pijitina caninarina naro. ");
INSERT INTO notNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iriro Tosorintsi iquemisanque Abaram jirai, aisati iquemisanqueri Isac aisa Jacob, acharineegui, Iriro oniagaiguëmiri Jesos Itomi Caninarisonori. Obirojegui págagantëri, pitsoingaiguëri catingasatiquë Pirato cara icogabeca iromisotocajiri. Te pinintaigue obirojegui. ");
INSERT INTO notNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pitsoingaiguëri Ira caninatasanotatsiri. Te pomaniri Pirato iromisotocajiri Jesos, irianti picogaiguë iromisotocajimiri ógueri. ");
INSERT INTO notNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pógaiguëri Ira timagantatsiri. Icamaque Jesos cariri icabiritajiri Tosorintsi yoganiatairi. Aisatitanai naniaigabajiri. ");
INSERT INTO notNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iriati Jesos përi isintsire ica sërarica. ¿Teco pigótiri? Iquemisanquerinta Jesos, ica yoguibegajica. ");
INSERT INTO notNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Yamai, nomatsiguenga, nigóti naro te pigóigue obirojegui ora picantaiguë cara pogamagaiguëri Jesos. Teatisati irogóigue pitingomipague. ");
INSERT INTO notNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Aroque Tosorintsi isanguenatacaganëri antagaisati comantantatsiri jirai icomantëgotaiguëri Quirisito cara ingamobicái. ");
INSERT INTO notNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pinguengaiguema arota pomasiniatitanae yamai quero picantaja pibega jirai. Pabentaiguemari Tosorintsi pinguemisantaigueri arota irojocajimiro ora picantagueigui te onganinate. ");
INSERT INTO notNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aro ingábintsaigaimi Tosorintsi intsibatëmi arota iraganinasëretaiguemi. Aisati iragátajimiri Jesos aisati ijita Quirisito Ira Agabisaicoontatsiri Ira icomantëgotaiguë comantantatsiri jirai. ");
INSERT INTO notNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Irinaqueni Jesos canta Jonogaguitequënta irooti cara irobetsicaguequero Tosorintsi antagaisati pairoraca yaca quibatsica. Jirai Tosorintsi isanguenatacaqueri, inibatagaiguëri comantantatsiripague ora inganque Tosorintsi yaca quibatsica. ");
INSERT INTO notNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Paniro comantantatsiri jitacha Moisés isanguenaque jirai: Tosorintsi Itingomisonori iragáquemiri comantantatsiri aisati inganquina nibega naro. Iriro omatsiguenga. Pairoraca ingomantaiguëmi pinguemisantaigabaquitiguiri. ");
INSERT INTO notNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ira quero iquemisantobëri, iriro iripoguiriaiguë iritsonguëmata, quero itsibatari imatsiguenga quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Antagaisati comantantatsiri icomantëgotëro oca piniaiguëca yamai. Iparintaca Samoel aique basini comantantatsiri irooti yamai. Icomantëgotëro omagaro. ");
INSERT INTO notNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aisati obirojegui pomatsiguengatacari ira comantantatsiri jirai. Picharineegui aisati obirojegui iquengaiguëmi Tosorintsi cara icanqueri Abaram: Nangantocobintaiguëri antagaisati matsiguenga yaca quibatsica. Iroro nagátaguëqueri pomatsiguenga iragabisaicotaigaimi obirojegui iraganinasëretaigapëri matsiguengajegui. ");
INSERT INTO notNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tosorintsi yoguibatëri Itomi igáquemiri ingábintsaiguëmi caninasati arota pijoquiro obirojegui ora picantagueti quimingaro, aro iragabisaicotaigaimi. ");
INSERT INTO notNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Iroontita inibataigaseguiri matsiguenga Peroro aisa Joan, iriguito ipocaigapë saserirotijegui aisati saroseoegui aisati itingomi ira omisantiro oquibe pongotsi irasi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iguisanijimpëri inibatobagaigaca: —¿Pairo yogomebiriqueri matsiguenga? Icomantirini inganiatanae igamagapague aroquenta itinaaja Jesos icaniatanai. Teni onganinate oca yogometirica. ");
INSERT INTO notNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aroquenta ochapinitanë, yágagantëri ira Peroro, aisati Joan, aisa ira carancaratabetacha, yomingaiguëri irooti cara onguëtaguetanë. ");
INSERT INTO notNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Carari tojaini ira quemaiguëri Peroro aisa Joan iquemisantaiguëro Irinibare Tosorintsi. Yamai quemisantatsiri icarataigui 5,000 sërari. ");
INSERT INTO notNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Oquëtaguetanai yapatoica Jerosarénquë itingomiegui jorío, antiasipariegui, aisa ira ogomeantiro Sanguenari. ");
INSERT INTO notNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aintasati Anás itingomi saserirotijegui, aisa Caijás, Joan, Arijantoro, antagaisati imatsiguenga itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Icaimagantëri Peroro aisati Joan yogobëri aganguisati, yosamitaigabaqueri: —¿Ati picanqueri ica pogaguibegajica? ¿Pairo picantancari? ¿Pairi agáquemiro cara picanquero negaca? ");
INSERT INTO notNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pinantasantacarinta Peroro Isëre Tosorintsi pinibataqueri caninasati. Aro yotabitanëri Peroro: —Obirojegui itingomi aisati antiasipari, ");
INSERT INTO notNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿Iriroco posamitaiguëna ica carancaratabetachaca icantaneintëgotëri Tosorintsi? Pinetsaigueri tegotsitatsi ini yamai. ¿Picogaiguinico pigóigue atiraca icanca cara ibegaja? ");
INSERT INTO notNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pinguemaiguena. Aisati caninataque inguemaigue antagaisati omatsiguenga. Yogabisaicotajiri Jesoquirisito Nasaresati Ira pipëicotaigabitaca obirojegui, carari itinaajiri Tosorintsi yoganiatairi. ");
INSERT INTO notNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","—Ira Jesos aisa icantaro pibega otingomi mopë cara ijocaiguëro jirai ira obetsiquirori pongotsi. Tosorintsi yoguibatëri Itomi Iriro Itingomisonori, carari obirojegui picantari obetsiquirori pongotsi. Pitsoingaigabaqueri Jesos pipëicotaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Teni irine basini Agabisaicoontatsiri yaca quibatsica ira agabisaicotajáine. Paniro Jesos ipacáiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Inibatasantë catingasati Peroro aisa Joan. Iniaigabaqueri itingomiegui iquenganeintasantanaca inibatobagaigaca: —¿Pairo te intsorogobite pitirooti? Teni irotsatenguiro sanguenari tenta irisanguenatasante. Irianti simaguiti. ¿Nega igóiguëro inibatëro ora icanque negaca? Irirojengari ogomequeri Jesos cara itsibataigacari jirai. ");
INSERT INTO notNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Aintasati ira obegajacha. Iniaigabaqueri itingomiegui te irogóigue irotopitaigueri Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aro igáqueri Peroro aisati Joan aisati ira obegajacha: —Atsi pisotocanë canta. Caraquenta nangaimaigaimi. Aro inibatobagaigaca itingomiegui. ");
INSERT INTO notNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Icantaiguë: —¿Atiroco angantiri ira sërarira? Quero itsoingaiguiri eiro antagaisatinta Jerosaresati igóiguë cara itasonganque. ");
INSERT INTO notNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Teni onganinate cara inguenguitsatomotaguetiri basini matsiguenga. Intsome omitsoroguiri, intsome angantiri: “Quero picomantëgotairi Jesos”. ");
INSERT INTO notNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aisati icaimaigairi iguisatsatëri isintsitsaqueri: —Quero picomantëgotairi aisati Jesos. Querootisati pogometocotajiri. ");
INSERT INTO notNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peroro aisa Joan yotabitaiganaqueri: —Pinguengaiguema obirojegui. ¿Teco iraniaigái Tosorintsi? Pingomantina. ¿Caninataqueco nanguemisantaiguemi obiro; oraco irasi Tosorintsi nanguemisanque? ");
INSERT INTO notNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Quero nojocobintiro, nanganquero ora naniaque aisati ora naquemaque. ");
INSERT INTO notNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yamai yogobeingataiguëri itingomiegui cara igátaigairi. Te iripasabintsatiri aroquenta itsorogaiguëri matsiguengajegui. Icanque matsiguenga: —Caninari Tosorintsi aisati caninari ira quemisantatsiri yoguibegajiri carancaratatsiri. Iroro te iripasataguëtiri. ");
INSERT INTO notNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aroque yogabisë 40 osarini ira carancaratatsi carari itasorintsite Jesos pogabisaicotajiri. ");
INSERT INTO notNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aro itingomiegui yomisotocaigairi Peroro aisa Joan, aique iáiguë cara inaigasegui basini quemisantatsiri. Icomantaguepëri antagaisati ora icanque itingomiegui saseriroti aisati antiasipari. ");
INSERT INTO notNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aroque iquemaigabaqueri, yamanaiguëri Tosorintsi icantaiguë: —Natingomi Tosorintsi, Obiro obetsiquëro Jonogaguite, aisati quibatsi, aisa angaare, antagaisati. Aisati pobetsicaguequeri antagaisati ira inatsi Jonogaguitequë, aisa quibatsiquë, aisa angaarequë. ");
INSERT INTO notNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aisati jirai pogomequeri David ira quemisantimi. Pogomeantacari Pisëre ora isanguenantacaro oca: ¿Pairo iguisaneintaguetobiquimi ira basiniati matsiguenga? ¿Pairo iquengasëretaguebiritiro joríojegui ora te onganinate? ");
INSERT INTO notNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ira itingomiegui iquengaigabitaca icogaigabita iritsonguerime Atingomisonori aisa Ira agabisaicoontatsi. ");
INSERT INTO notNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yaca Jerosarénquë yapatotaigaca arosonori matsiguenga iguisaneintaiguëri Jesos Pitomi caninari. Iriro poguë Agabisaicoontatsiri. Iguisaneintaiguëri Eroris, Pontsio Pirato, joríojegui, aisati basiniati matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jirai pigótiri. Yamai aroque icantaiguëro irirojegui ora piquianca pobetsiquë jirai. Aisati pisëretaca cara ingamobitaiguëna Pitomi Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yamai Natingomi, pinetsaigueri. Icoguini iromitsorogaiguena. Pingantocotina querota notsorogaiguiri përosati nanguenguitsatasantëmiro Pinibare. ");
INSERT INTO notNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pitasorintsitasanote, pigaguibegajiri ira janaitatsi arota irogótiri matsiguenga aisonori Iriro Jesos Pitomi aisati iraniacaninataigueri. ");
INSERT INTO notNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aroqueque itsonque yamanaiguë, aro posebatanaca pongotsi cara inaigasegui. Pinampari Caninaro Isëre Tosorintsi icomantasantanquero aisonori Irinibare Tosorintsi, te intsorogaiganaque. ");
INSERT INTO notNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yamai tojaini icarati quemisantatsiri. Iquengasëretaiganaca. Ipabacaguetanaca ora iraisati, te iromichate. Te paniro cantatsine: —Iroroca nasiati. ");
INSERT INTO notNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Përosati iquenguitsatasantë iragátane Jesos icanque: —Icabiritanaa Atingomi Jesos icaniatanai. Aisati icábintsaiguëri Tosorintsi ira iragátane. Yoganinasëretaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Te paniro tasegatsine. Antagaisatinta yasintagueta togantsipague aisati pongotsipague ipimantaguetiro yágancaro quirequi. Yamapëri, ");
INSERT INTO notNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ipapëri iragátaneegui Jesos irotsatengaguetiri ira coguetatsi paniropague. Icantaneintëgotëri imitocoqueri irapiguemisantacagane. ");
INSERT INTO notNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ainta inasegui paniro sërari jitacha José. Aisati iragátane Jesos ijitaiguëri Berinabé ora ocanti caninatagantatsiri. Ipaniaca oboguesiquë jitacha Chípire. Iriro imatsiguenga Irebí. ");
INSERT INTO notNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ipimantëro iritogane, yamapë iguireguite, ipapëri iragátaneegui Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ainta basini sërari jitacha Ananías aisati Sajira iina ipimantëro iritogane. ");
INSERT INTO notNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iquengaigaca iriro aisa iina yágarantobë aganguisati quirequi, yoguëri. Yáganëri basini Ananías ipapëri iragátane Jesos icampëri: —Jerica quirequi pipënataca cara nopimantëro notogane. ");
INSERT INTO notNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Antagaisati pigótacaqueri Peroro Isëre Caninaro Tosorintsi. Icabëri Peroro: —Ananías, pitsoigani. ¿Pairo pinintacagobiqueri camagari Satanás yamaica inanquimi pineiquë? ¿Pairo pamatobibiritabecaro Isëre Tosorintsi cara págarantobë quirequi, poganontacari aganguisati? ");
INSERT INTO notNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Cagarico pasi pitogane ora popimantëra, cagarico pasi quirequi? ¿Pairo piquengabiritaigaca picanque: “Jerica antagaisati quirequi”? Teni pomatobitina naro, Irianti pamatobitabeca Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iquemobëro Ananías oca nibarintsica, aito ipariganë icamaque. Iquemocotobëtiguirini itsorogasantaiganaque antagaisati. ");
INSERT INTO notNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Aique yobetsicaiguëri oboinapague iponatancari tocoya, yágaiganaqueri itiaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pabisanaque cosamanisata pipogopë iina Ananías, terai ogóte cara aroque icamaque ojime. ");
INSERT INTO notNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yosamitobëro Peroro: —¿Ati icarati quirequi páguë cara popimantaiguëro pitogane? ¿Antagaisatico ica ipapënaca pijime? Oniaqueri Sajira ocampëri: —Jee, antagaisati. ");
INSERT INTO notNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Icabëro Peroro: —¿Pairo piquengabiritaigaca obiro aisa pijime pomatobitaiguëro Isëre Atingomi? Pinetseri ira sëraripaguera. Aroque itiaiguëri pijime. Aisati obiro yamai iráganëmi iritijaiguëmi. ");
INSERT INTO notNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aitosati opariganë Sajira ocamaque iguitiquë Peroro. Cara icaigapë oboina, iniaigapëro aroque ocamaque. Yáganëro itiaquero otsibatapaari ojime. ");
INSERT INTO notNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Aro itsorogasantaiganaque omagaro ira quemëgotëri Ananías aisati iina. ");
INSERT INTO notNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tojai itasongapininti iragátane Jesos imitocoquerinta Tosorintsi. Yoniagaiguëri matsiguenga ora igóontacari Tosorintsi. Iquenganeintasantaiganaca matsiguenga. Yapatotaigaca ira quemisantatsiri cara omoroquë jitacha iraisati Saromón. ");
INSERT INTO notNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Itsorogaiguë matsiguengajegui cara intsibataiguëmari, carari icanque: —Cobeingari ira quemisantiri Jesos, carari aisati caninari. ");
INSERT INTO notNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tojaisonori sërari aisati tsinane quemisantaiguëri Jesoquirisito. Itojaigasanoiganaque quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yogaiguëri ira janaitaguetatsiri cara abatsiquë. Yoguëri jatasintsiquë aronta inguenopë Peroro iromamegapëri arota irobeganaima. ");
INSERT INTO notNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yapatotaigapa tojaini matsiguenga paniacha basinipaguequë poeboro aronisatiquë Jerosarén. Yamaigapëri ira janaitatsiri aisati ira inanca camagari. Yoguibegajiri antagaisati. ");
INSERT INTO notNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aro iguisaneintanaca itingomi saseriroti aisa ira tsipatachari ijita saroseo. ");
INSERT INTO notNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yágagantëri ira iragátane Jesos yomianqueri iromingamentojeguiquë Jerosaresati. ");
INSERT INTO notNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Cara tsitiniriquë yasirianaquineri ironomire Tosorintsi, yomisotocanairi icanqueri: ");
INSERT INTO notNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Pijáigue cara oquibequë pongotsi irasi Tosorintsi. Pinguenguitsataiguero ora nibarintsi timagantatsi. Inguemisanqueroca matsiguenga përosati intimaque Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cara oquëtaguetanë iáiguë cara ibangoquë Tosorintsi yogomeantaguetanë. Iroontita yogomeantaigui, itingomi saseriroti aisa ira itsibata icaimaiguëri yapatotaiguëri ira obatatsiri jorío icarati 71. Irirojegui saseriroti, antiasipari, aisati ira ogomeantiro ora isanguenaque jirai Moisés. Igáqueri iromeraro: —Pijáigue omingamentoquë pomaigapënari yaca ira quemisantiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aique iáiguë iromingamentoquë. Te irinaigue. Aro ipigaigapa icomantaigapë ");
INSERT INTO notNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","icanque: —Naniaigapëro omingamento ositasantaga sitëcori. Ainta ira omisantiro omoroquë. Cara nasiriabeparo te irinaigue tsomagui. ");
INSERT INTO notNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cara iquemaquero oca nibarintsica itingomi ira omisantiro ibango Tosorintsi aisa itingomi saseriroti imabocaca iquenganeintasantaiganaca. Yosamitobaganaca: —¿Ati icanca irirojegui? ¿Nega iáiguë? ¿Atini yamai? ");
INSERT INTO notNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Iriguito yarepa paniro sërari icampë: —Ira sërari pomingaigabitaca ainta yamai tsomagui oquibequë pongotsi irasi Tosorintsi yogometaigapairi matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aique iáque itingomi ira omisantiro oquibe pongotsi aisa iratirite, yamaigapëri caninasati. Te ingantiri catsimari itsorogaiguërinta matsiguenga. Icanque itingomi: —Iribasegaiguënaca mopëquë. ");
INSERT INTO notNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yamapëri ira iragátane Jesos itingomi aisa ira itsibata, yogaiguëri aganguisati obatatsiriquë. Icabëri itingomi saseriroti: ");
INSERT INTO notNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Aroque nacantasantaiguëmi cani: “Quero picomantëgotaigairi Jesos”. Yamai pogometaiguëri omagaro Jerosaresati. Pinibatëgotina: “Irirojegui saseriroti ógaiguëri Jesos”. ");
INSERT INTO notNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Yotabitaiganaqueri Peroro aisa basini iragátane Jesos: —Caninataque nanguemisantaigueri Tosorintsi. Inganqueca matsiguenga ora basiniati, quero naquemisantiri. ");
INSERT INTO notNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Aisonori obirojegui ógaiguëri Jesos. Pipëicotaiguëri corosiquë. Carari icabiritajiri Tosorintsi yoganiatairi, Ira iquemisantaiguë omatsiguenga jirai. ");
INSERT INTO notNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tosorintsi yogainocanëri Ira Jesos. Yoguëri ibacosonoriquë. Yoguëri Itingomi Obatatsiri aisati Agabisaicoontatsiri icoguininta imëri joríojegui cara ingantaigaima yacaqueroca, ingábintsaiguëri Tosorintsi irojocajineri ora icantagueti te onganinate quero iquengairo. ");
INSERT INTO notNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aroque nigótasantëro oca nocomantaiguëmica yamai naniasantaguequero. Aisati ocomantagueti Caninaro Isëre Tosorintsi, Iroro ipëri Tosorintsi antagaisati ira quemisantiri. ");
INSERT INTO notNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cara iquemaigabaquero oca nibarintsica págapëri oshabitapëri iraneingomentoquë itingomiegui, iguisaneintasanoiguëri iragátane Jesos. Icogaigabitanaca iróguirime. ");
INSERT INTO notNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ainta sërari jitacha Gamariel. Iriro bariseo aisati yogomeantiro Sanguenari. Iniacaninataiguëri iriro matsiguenga. Aro yaratianque icanque: —Iráganërita casiriconiati icaegui quemisantirica Jesos. Caraquenta aguipigapairi. Aro yáganëri sotoquë. Aique icanë Gamariel: ");
INSERT INTO notNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","—Nomatsiguenga, pigamaiguema ora pinganquerira icaegui quemisantiri Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jirai iconijapë Téoras ira jitabitënguicha itingomi. Yoguiataiguëri tojai irogomere icarati 400 sërari. Yogamagaiguëri Téoras atingomiegui, yomisigaiganaqueri iratirite iátagueque. Yamai teni nanguemocotajiri. ");
INSERT INTO notNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aique cara isanguenatocotaguequeri antagaisati matsiguenga arota iripënabintëri quirequi impoesito, iconijapë Joras Garireasati. Aisati yoguiataiguëri tojainisonori irogomere. Aisati yogamagaiguëri ira Joras, iátagueque iratirite. ");
INSERT INTO notNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Iroro nocomantaguëtaiguimi yamai caninataque irineta icaegui matsiguengaca. Quero picantaiguiri pairoraca. Iriroca agáqueri matsiguenga ingomantagueque, aro otsonganaquima oca nibarintsica. ");
INSERT INTO notNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Iriroca agáqueri Tosorintsi tigueti pingantiri piguimairentiri. Quero pipëgatsatari Tosorintsi. Cara iquemobëro oca nibarintsica, iquengaiganaca. ");
INSERT INTO notNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Icaimagantaigairi ira iragátane Jesos. Ipogopë. Ipasataigabaqueri, icantasantaiguëri: —¡Quero pinibatëgotaigairi Jesos! ¡Quero pinibatëmati! Aro igátaigairi itingomiegui yomisotocajiri. ");
INSERT INTO notNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iáiguë quemisantatsiri icarati 12 icaninasëretaiganaque aroquenta itsipiriobitaiguëri Jesos ora pasiguitagantsi. ");
INSERT INTO notNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Antagaisati cataguiteri përosati yogomeantaigui cara oquibequë pongotsi irasi Tosorintsi aisati pongotsipaguequë. Icomantëgotaiguiri Jesos icantopiantë: —Iriati Jesos Agabisaicoontatsiri Ira oguiaiguë eiro jirai. ");
INSERT INTO notNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Itojaiganaque quemisantatsiri. Ainta ira nibatatsi guiriego aisati ira nibatatsi ebereo. Yabenca ira nibatatsi guiriego icantaiguë: —Antagaisati cataguiteri cara imitocoonti yotsatengaguetiro perintsi, omatsiguenga ogamaimentaga pitaseguë. Paniro imitocotiro iroonti ora nibatiro ebereo. ");
INSERT INTO notNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aro iragátane Jesos icarati 12 yapatoiqueri antagaisati quemisantatsiri. Icabëri: —Teni ongomeite nojocanëro cara naquenguitsatopiantiro Irinibare Tosorintsi arota nomaguetaiguemiro poperi. ");
INSERT INTO notNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yamai, nopiguemisantane, pingoigaigue 7 matsiguenga omitocoontatsiri ira caninatatsiri, ogótasantatsiri, pinanca Isëre Caninaro Tosorintsi. Pomeri itarobacaare ora imantaguetimiro poperi. ");
INSERT INTO notNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Naroegui përosati cara nomanaiguë aisati cara nongomantagueantiro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Aro iquengaiguëro. Icoigaiguëri Isiteban ira quemisantasanotatsi aisa pinancari Isëre Caninaro Tosorintsi. Aisati icoigaiguëri Jeripe, Porócoro, Nicanor, Timón, Párimenas. Aisati icoiguëri Nicorás Antioquíasati, jirai itsibataigacari jorío iquemisantabecari Tosorintsi, aique iquemisantasantëri. ");
INSERT INTO notNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aique yamaigapëri cara iragátanequë Jesos. Aro yamanocotaigabaqueri yogaiguëneri ibaco iguitoquë. ");
INSERT INTO notNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tojai icarati ira quemaiguëro Irinibare Tosorintsi. Aiquero iáque itojaiganaque quemisantatsiri canta Jerosarénquë. Aisati tojai icarati saseriroti quemisanquero Caninaro Nibarintsi. ");
INSERT INTO notNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tojai icaninasëretasantë Isiteban. Tojai itasongagueanti imitocoquerinta Tosorintsi. Iquenganeintasantaiganaca matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yapatotaigaca matsiguenga jirai ibimantaga, yamai yomisotocajiri, aintasati Sirenesati, Arijantiríasati, Sirisiasati, Asiasati. Irirojegui pëgatsatacari Isiteban. ");
INSERT INTO notNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Teni irogóigue irotopitiri. Igótasanoti Isiteban inibatasantë Iroronta Isëre Caninaro Tosorintsi nibatacaqueri. ");
INSERT INTO notNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aro tojai ira quisaneinqueri ira Isiteban icantaiguëri basini matsiguenga: —Intsome ontsoiguëgotimari Isiteban. Aro nomaiguëmi quirequi. Pinibatëgotiri: “Naquemaqueri Isiteban. Itsoinguëri Moisés icantocoqueri ora te onganinate. Aisati icantocotaguetasitari Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iquemaiguëri joríojegui iguisaneintaiganaca antiasipariegui, aisa ira ogomeantiro Sanguenari, antagaisati. Omanapague ipocasipëri yágaigapëri Isiteban yáganëri itingomieguiquë jorío icarati 71. ");
INSERT INTO notNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aisati igátaiguëri ira tsoiguëgotëmarine inganque: —Naquemaqueri Isiteban icantopiantë: “Teni onganinate ibangoca Tosorintsi. Teatisa ora isanguenaque Moisés. ");
INSERT INTO notNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Irioquëro Jesos oquibeca pongotsi. Aisati imasiniatiquero ora nametaiga ora yogomeantaiguëna Moisés”. ");
INSERT INTO notNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Aique inetsaiguëri Isiteban itingomiegui jorío aisati antagaisati ira sobicaigasegatsi. Inetsasantobëri iboroquë Isiteban caninaro aisa icantaborotari ibega ironomire Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yosamitëri itingomi saseriroti: —¿Aisonori oca icantocotaiguëmica? ");
INSERT INTO notNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yotabitanëri Isiteban: —Nomatsiguenga, aisati natingomiegui, pinguemaiguena. Jirai itimi omatsiguengajegui Abaram canta Mesopotamiaquënta teraiquerai iragaganëma Jaránquë. Canta yoniagapari Tosorintsi Ira caninarisonori. ");
INSERT INTO notNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Icampëri: Pijocanëri pomatsiguenga, pijátaje irooti basiniquë quibatsi ora noniaguëmira. ");
INSERT INTO notNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aique ijocanëro Abaram iguebatsite imatsiguenga. Itsibatari iriri cara iáiguë Jaránquë. Aito icamaque iriri. Aro Iriroquerai Tosorintsi agaganëri Abaram irooti oca quibatsica cara pitimaigui obirojegui yamai. ");
INSERT INTO notNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Terai imeri Tosorintsi oca quibatsica te imëmatiri arosata. Patiro icanqueri: Aiquenta nomëmiro pintimenta yaca. Pingamaqueca obiro, aro intimaiguë pitomijegui yaca. Terai irine itomi Abaram. ");
INSERT INTO notNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aisati icanqueri Tosorintsi: Aiquenta intimaiguë arosonori pitomijegui aisati picharineegui cara iguebatsitequë basiniati matsiguenga, iromerataigabaquimari tojai osarini ongaraque 400 ingantaguequeri ora catsimari. ");
INSERT INTO notNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aique nangasitígataiguëri ira merataiguëmarine. Aro irisotocaigae pomatsiguenga naguipigaigairi yaca quibatsica, inguemisantaiguëna yaca. ");
INSERT INTO notNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nocogui yamai pitotima irogóontima matsiguenga piquemisanquina. Aro iquengaigaca Abaram Tosorintsi. Cara inë itomi Abaram jitacha Isac, pabisanaque 8 cataguiteri itoqueri cara yametaiga joríojegui. Aisa inë itomi Isac jitacha Jacob, itoqueri. Aisati Jacob itomintacari itomi icarati 12, itotaguequeri. ");
INSERT INTO notNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ainta paniro itomi Jacob jitacha José. Iriati ireinti icarati 10 iguisaneinqueri José ipimantaiguëri. Yáganëri matsiguenga canta Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Itsibatari Tosorintsi imitocoqueri icábintsëri, icanqueri ira Baraón itingomi Ejípitosati iniacaninatëri José. Yoguëri Baraón aganguisonoriquë, aisati itingomibiriqueri José cara itingomibintaiguëri antagaisati Ejípitosati aisati imatsiguenga Baraón. ");
INSERT INTO notNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Përosati inibatasegui Isiteban icanë: —Pabisanaque cara pipoque itasegasanoiguë antagaisati Ejípitosati aisa omatsiguenga yaca Canánquëca. Te inae iraperiegui. Canta Ejípitoquë José yoguëro tojai perintsi. ");
INSERT INTO notNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Iquemocoquero perintsi Jacob canta Ejípitoquë. Aro igáqueri acharineegui itomijegui Jacob. Patiro iáiguë. ");
INSERT INTO notNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Cara iáigai aisati, yoniagaigabacari José igóigapëri ireinti. Aisati Baraón itingomi igóigabaqueri imatsiguenga José. ");
INSERT INTO notNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Aique icabëri José: Atsi pijáigue, pingantiri Apati iribocapë yaca aisati antagaisati imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aro iáiguë irooti Ejípitoquë Jacob aisati imatsiguenga icarati 75. Canta, icamaque Jacob aisati canta icamaiguë acharineegui. ");
INSERT INTO notNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aiquenta yágaiganaqueri igamagapague itiaqueri Siquemiquë cara quibatsiquë ora yamanantë Abaram jirai ipimantë itomijegui Emor. ");
INSERT INTO notNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Përosati icanti Isiteban: —Cara aronibati omoncaraquima ora icanqueri Abaram Tosorintsi jirai, itojaiganaque omatsiguenga canta Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Aique ipoque irirai itingomi te irogótiri José. ");
INSERT INTO notNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yamatobitaiguëri omatsiguenga icanqueri cara irojocaigueri itomijegui arota ingame. ");
INSERT INTO notNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aro inë Moisés. Iniacaninatëri Tosorintsi. Maba manchacori iquibianë ibangoquë iriri, iniro pimánopitëri Ejípitosati. ");
INSERT INTO notNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Cara ojocanëri sotoquë oniopëri irisinto Baraón, págairi ocanqueri iriro asi otomi. ");
INSERT INTO notNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yogometasantëri Ejípitosati antagaisati ora igóigui iriro. Catingasati inibati Moisés. Caninasati icantaguetiro pairoraca intagueti. ");
INSERT INTO notNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Aisati icanë Isiteban: —Ora irosarinite Moisés ocarati 40, aro iquianqueri iraniaqueri joríojegui imatsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aique iáque. Iniopëri Ejípitosati iguisasiguiri paniro jorío. Yogamagapëri Moisés ira Ejípitosati; ");
INSERT INTO notNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ijique irogóigueme imatsiguenga cara iriro iragabisaicoontaiguemarime Tosorintsi carari te irogóigue. ");
INSERT INTO notNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Cara oquëtaguetanë iniopëri pite imatsiguenga iguisabacagasega. Icogabeca Moisés iraguimairentirime. Icantabecari: ¿Pairo piguisabacagobita? ¿Cagarico pomatsiguenga? ");
INSERT INTO notNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aro yosibitobëtiguiri ira quisasanoquenguicha, icabëri: ¿Pairi agáquemi obiro yaca pingampëma natingomi? ¿Picoguinico pomerataiguena? ");
INSERT INTO notNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Póguënanico naro pibiaqueri Ejípitosati chopi ira pogamaguë? ");
INSERT INTO notNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Iquemobëro Moisés itsoroganë isiganaca irooti basiniquë quibatsi jitacha Matián. Irooti itimantapa. Canta yágapë iina, inë pite itomi. ");
INSERT INTO notNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","—Pabisanaque 40 osarini itiomoqueri iriconguiri Moisés. Aiti pinasegui piriabatsaro cara aronisatiquë oguitoja jitacha Sinaí. Yomisantëneri Moisés iroishate iriconguiri, iconijatomopëri ironomire Tosorintsi irisaanganetsite cara totseisiquë itairingopa yosiacaro tsitsi carari te otagatima totseisi. ");
INSERT INTO notNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Iquenganeintasantanaca Moisés yotsitiparo totseisi icoque iraniasantiro tsitsi. Iquemobëtiguiro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Icabëri: Naro Tosorintsi; iquemisantina picharine Abarám aisati iquemisantina Isac, aisa iquemisantina Jacob. Aro imogomogoatanaca Moisés itsoroganë te iranetsanajiro. ");
INSERT INTO notNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Aisati icanqueri Tosorintsi: Piguëtiri pisapatote paratianquenta cara quibatsiquë caninaguitero catingasatiquë Naro Pitosorintsite, pinguemisantatsatina. ");
INSERT INTO notNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naniaiguëri pomatsiguenga Ejípitoquë. Naquemaiguëri cara yabentaigaca. Yamai nangábintsaiguërini. Iroro nipocasitaguëqueri. Yamai nagáquemini Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Jirai itsoingaigabitacari ira Moisés icanqueri: “¿Pairi agáquemi pingampëma natingomi?” Iriati Moisés igáque Tosorintsi yamai icanqueri itingomi cara iragabisaicotaiguëri imatsiguenga. Iroro igátaguëqueri ironomire Tosorintsi ira conijatomoqueri totseisiquë. ");
INSERT INTO notNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Iriro Moisés ágaiganaqueri imatsiguenga acharineegui. Itasongobentaiguëri cara Ejípitoquë aisati cara yoguimontiaiganaqueri angaarequë tsonaaro aisati quibatsiquë piriabatsaro. Itasongobentaiguëri 40 osarini. Aisati icanë Isiteban: ");
INSERT INTO notNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","—Iriati Moisés icantaiguëri joríojegui: Tosorintsi agáquemirine comantantatsiri aisa inganquina nibega naro. Iriro pomatsiguenga. Pairoraca ingomantaiguëmira pinguemisantaigabaquitiguiri. ");
INSERT INTO notNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aisati Moisés itentaigari jirai omatsiguenga quibatsiquë piriabatsaro, aisati inibatobaca irisaanganetsite Tosorintsi oguitojaquë jitacha Sinaí. Aisati iriro iquemobëro Irinibare Tosorintsi timagantatsiri ora igóontacari Tosorintsi. Isanguenataigáiro. ");
INSERT INTO notNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Acharineegui te inguemisantiri Moisés itsoingaiguëri. Icogaigabitaca iripigaimame Ejípitoquë. ");
INSERT INTO notNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Iroontita inë Moisés jonoquë oguitoja, icantaiguëri Aarón ireinti Moisés: Nocogaiguini pobetsiquinari basini nobabane irirai irobataiguëna naguiatanëri, tenta nogóigue negaraca ipiaca Moisés ira maigapëna cara Ejípitoquë irooti yaca oguitojaica jitacha Sinaí. ");
INSERT INTO notNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Aro yobetsicaiguëneri yosiacagantëri itiomijani baaca. Ijiqueri ibabane yógaiguëneri itaquineri oisha, icaninasërebiritaiganaqueri ira yobetsicasitaca. ");
INSERT INTO notNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Aro ijocaiganaqueri Tosorintsi iromanocotirita paba, manchacori, aisa jonogasatipague. Jirai isanguenatocoqueri comantantatsiri jitacha Amós: Obirojegui jorío, ¿Teco pógaiguenari oisha cara jirai tojai osarini ocarati 40 canta piriabatsariquë quibatsi? ");
INSERT INTO notNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Teni. Iroonti panataiguëri pobabane Moroc, aisati panataiguëri irosiacagomento jonogasati jitacha Repam, pitirooti posiacagantë pobetsicasitaigari obiro pamanocotasitaigari. Iroro nojocaguëquemi piguebatsitequë, nagátaiguëmi canta jaanta Babiróniaquë. Aroque isanguenaque negaca Amós jirai. ");
INSERT INTO notNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Përosati icanai Isiteban: —Cara piriabatsaroquë quibatsi jirai yanataiguëro omatsiguenga ibango Tosorintsi iroonti tocoya cara yoguëro osanguenataga mopë. Moisés yobetsiquëneri ibango Tosorintsi aisati ocantaro pibega ora icomantasantëri Tosorintsi yoniaguëri. ");
INSERT INTO notNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ora ibango Tosorintsi yágobëro acharineegui cara ipëri Tosorintsi, aique yanataiguëro itsibataigari Josoé cara yágabitsaqueri iguebatsite matsiguenga catsimari. Ijocaiguëri matsiguenga Tosorintsi ipëri iguebatsite acharineegui. Përosa pini pongotsi irooti cara itimi David. ");
INSERT INTO notNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Iniacaninatëri David Tosorintsi. Yamanabetari David: “Pabati Tosorintsi, jirai iquemisantimi Jacob. Obiro Itosorintsite. Yamai nocoguini nobetsiquëmiro caninaro pobango irorai ora pintimantima”. ");
INSERT INTO notNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Carari te irobetsiquineri David. Saromón itomi yobetsiquëneri ibango. ");
INSERT INTO notNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Carari Tosorintsi jonoquënintaberi teni intime pongotsiquë ora yobetsiquë matsiguenga. Aroque icanque comantantatsiri: ");
INSERT INTO notNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Icanë Tosorintsi: “Ora Jonogaguitequë iroro nisobiganta, cagaro yaca quibatsica. ¿Ati pinganquinaro pobetsiquinaro nobango? ¿Nega nomagoriaque? ");
INSERT INTO notNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Teco Naro obetsiquërone antagaisati?” ");
INSERT INTO notNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Te pinguenganeintasëretima obirojegui. Aisati picantari ibega basiniati matsiguenga te irogótiri Tosorintsi. Te pinguemiri Tosorintsi, teatisati pinguemisantiri. Përosati pipëgatsataro Isëre Caninaro. Picantari ibega ira picharineegui ipëgatsataro cara jirai. ");
INSERT INTO notNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Aintaca paniro comantantatsiri te inguisaneintiri picharineegui? Teni. Yogamagaiguëri antagaisati ira comantantatsiri icanque iribocapë Ira Caninarisonori. Yamai aroque ipogopë Iriro Jesoquirisito, págagantaiguëri pógaiguëri obirojegui. ");
INSERT INTO notNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Teni pinguemisantiro Irinibare Tosorintsi obirojegui ora yogometaiguëmi ironomire. Aroque inibatë Isiteban. Itsonquero. ");
INSERT INTO notNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cara iquemaigabaquero irinibare Isiteban oshabitapëri iraneingomentoquë iguisaneintasantanëri itingomiegui jorío, itsicaguitenatanëri. ");
INSERT INTO notNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aro pinancari Isiteban Isëre Tosorintsi, inetsë jonoquë iniaqueri ironomire Tosorintsi. Aisati iniaqueri Jesos yaratingasegui ibacosonoriquë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Icanque Isiteban: —¡Pinetsaigue! Canta Jonogaguitequë naniaqueri Jesos Ira paniacha Jonogaguitequë otsomaaqueri iniro jirai, imatsiguengatasantapë. Naniaqueri yaratianque ibacosonoriquë Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Aro yamai catsigue icaimë itingomi joríojegui ishapiguemitatanaca isigasipari yágaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Yágaiganaqueri sotoquë Jerosarén, ibasiaqueri mopëquë. Ira comantëgotëri Isiteban ijocaiganaquero iguitsagare iguitiquë Saoro oboina sërari omisantëneri iguitsagare. ");
INSERT INTO notNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iroontita ibasegaseguiri, yamanaque Isiteban icanque: —Jesos Natingomi, págobënaro nasëre. ");
INSERT INTO notNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yobaticagueritoca, icaimë catsigue yamanocotajiri ira basiaqueri: —Natingomi, quero poguibitacaiguiri oca icantagueiguëna icaegui ora te onganinate. Aroque icanque Isiteban negaca, irooti icamantaca. Inetsëri Saoro icanque: —Caninataque. Icamaque yamai. ");
INSERT INTO notNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Irooti cataguiteri iparintaigaca joríojegui icantaguequeri catsimari ira botoibiritari Jesoquirisito canta Jerosarénquë. Iátagueque antagaisati, isigaiganaca Joreaquë aisati Samariaquë. Irinibani inaiguënguitsi Jerosarénquë iragátane Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ainta matsiguenga quemisantasantëri Tosorintsi itiaiguëri Isiteban tojai iraicoqueri. ");
INSERT INTO notNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iriroque Saoro përosati icantaguequeri catsimari ira botoibiritari Quirisito. Icogabeta iritsongaiguërime. Icanaque ibangopaguequë quemisantatsiri yágapëri inosicanëri sërari aisati tsinane, yomianqueri cara iromingamentoquë. ");
INSERT INTO notNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ira quemisantatsi iátagueque icomantobaguecaro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jeripe omitocoontatsiri yareca Samariaquë. Icomantëgotapëri Jesoquirisito. ");
INSERT INTO notNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yapatoica matsiguenga iquemaigabaqueri Jeripe ora icomantaguepëri aisa iniaigabaqueri cara itasongampë. ");
INSERT INTO notNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yogabisaicotajiri tojai matsiguenga ira inanca camagari. Icaimaiguë camagarijegui cara isotocaiganaji. Aisati yoguibiaguetajiri tojai emëngari aisati carancaratatsi. ");
INSERT INTO notNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Irooti icaninasëretantaiganaca antagaisati Samariasati. ");
INSERT INTO notNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Cara poeboroquë ainta sërari jitacha Simón. Jirai iriro matsi. Itasongabitaca. Aisati yamatobitaiguëri tojai matsiguenga tojai osarini. Ijitaiguëri iriro itingomi. Antagaisati matsiguenga iquemisanqueri. Iquenganeintasantanëri icantocotaiguëri icanque: —Itasonganti Simón. ¿Iriromë tosoncaguiri Tosorintsi? Intsome antingomintimari. ");
INSERT INTO notNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aro ipogopë Jeripe icomantaguetiri matsiguenga Irinibare Tosorintsi aisa ati ocanta iragáantane Tosorintsi. Aisati icomantëgotëri Jesoquirisito. Ibaotisataigapëri ira quemisantaiguëri Jesos, sërari aisati tsinane. ");
INSERT INTO notNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón aisati iquemisanque ibaotisataca yoguiatëri Jeripe. Iquenganeintasantanaca Simón cara itasonganti Jeripe. ");
INSERT INTO notNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Përosati ini iragátane Jesos Jerosarénquë. Cara iquemocotaigabaqueri ira Samariasati cara aisati iquemisanqueri Jesos, aro igáiguëri Peroro aisati Joan. ");
INSERT INTO notNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Iáiguë canta. Yamanocotaigapëri Samariasati cara coshoni oganëri Isëre Caninaro Tosorintsi, ");
INSERT INTO notNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","terainta iroguineri Tosorintsi Isëre iriroquë. Patiro ibaotisabiritabecari Atingomi Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Aro Peroro aisati Joan oguëneri ibaco iguitojeguiquë, yágasëretobëro Isëre Tosorintsi pinampari. ");
INSERT INTO notNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Cara iniaqueri Simón icabëri ira Peroro: —Jerica quirequi. Nocoguini pogometajinaro natasonganqueni naro nangantimi pibega obiro cara pitasonganti. Nocoguini noguëroca nobaco matsiguengaquë irágasëretantimaro Isëre Tosorintsi iriro. ");
INSERT INTO notNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Icanqueri Peroro: —Pijáte Sharincabeniquë aisati páganëri piguireguite. Pijitasica obiro pomanantëro itasorintsite Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Teni pingantina nibega naro. Igóquimi Tosorintsi te onganinate paneingomento. ");
INSERT INTO notNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Te onganinate ora piquengasëretabitaca. Pingantajima yacaqueroca pijoquiro ora picantagueti te onganinate. Pomaniri Tosorintsi ingábintsaimi, irojocajimirota ora picantagueti te ongomeite. ");
INSERT INTO notNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nigóquimi pomichatasantini, picoguini iraniacaninataiguemi matsiguenga. Aroque pagobiaquemi yamaica ora picantagueti quimingaro. ");
INSERT INTO notNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yotabitanëri Simón: —Pomanocotina naro querota niáti Sharincabeniquë. ");
INSERT INTO notNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aique Peroro aisati Joan icomantanquero Irinibare Atingomi, iquenguitsatocotiro. Iquenaguetanë poeboropaguequë cara Samariaquë, icampëri: —Aroca pinguemisanqueri Jesos, aro irojocajimiro Tosorintsi ora picantagueti te onganinate, iragabisaicotajimi. Cara itsonquero icomantaguequeri ira Samariasati, ipiganaja cara Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Irisaanganetsite Tosorintsi iconijatomopëri Jeripe icampëri: —Pingabiritanëma pijáte irooti poeboroquë jitacha Gasa. Pinguenaque abatsiquë paniacha Jerosarénquë oquenaque piriabatsariquë. ");
INSERT INTO notNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aito icabiritanaca Jeripe iáque. Itonguibocari matsiguenga paniacha Etiopíaquë irágaguitsotaga. Iriro otingomibintë Cantase. Iroro tsinane itingomi Etiopíasati. Yomisantënero oguireguite. Iquemocoqueri Tosorintsi iriro, iátasiqueri canta Jerosarénquë, icoque irogótiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yamai ipigaa isobiaque irisicómentoquë inibataseguiro isanguenare Isaías, comantantatsiri cara jirai. ");
INSERT INTO notNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iroro Isëre Tosorintsi cantëri Jeripe: —Pijáte pitonguibotobëmari irisicómentoquë. ");
INSERT INTO notNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Isigopa Jeripe itonguibocaro iquemaqueri inibatëro isanguenare Isaías. Yosamitapëri: —¿Piquemaquero Sanguenari? ");
INSERT INTO notNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yotabitanëri: —Teni nanguemiro tenta irine ira ogomequenarone. Potetima pisobigopë yaca pogomepëna obiro. ");
INSERT INTO notNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aro isobigopë Jeripe. Ora Sanguenari inibatasegui ocanti: Cara imaireti itiomijani oisha cara yapeitiri, aisa icanta Quirisito imaireti, te irinibate cara ira quisaneinqueri yáganëri yogamagaiguëri aisa icantari ibega oisha cara yogamaguiri. ");
INSERT INTO notNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yógasitacari catsimari. Quero ini itomi aroquenta yóguëri. ");
INSERT INTO notNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yosamitobëri Jeripe Etiopíasati: —Nocoguini pingomantina ¿Pairi isanguenatocoque comantantatsiri? ¿Iriatico comantëgotacha? ¿Basinico iquenguitsatocoti? ");
INSERT INTO notNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Aito iparintaca Jeripe icomantasantëri ora inibatasegui Sanguenariquë. Icomantëgotëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iátocoque abatsiquë irooti cara yarecaro nija. Yosamitëri Etiopíasati icanqueri: —Iroro nija oca. ¿Caninataque nomaotisatëma? ");
INSERT INTO notNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Icanqueri Jeripe: —Piquemisantasantirica Quirisito, caninataque pomaotisatëma. Yotabitanëri: —Jee, naquemisantasantiri Jesoquirisito Iriro Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yogaratianquero irisicómento. Aito yaguëtanë pitirooti itsibatanacari cara nijaaquë. Ibaotisatëri Etiopíasati Jeripe. ");
INSERT INTO notNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ipiganaja irisicómentoquë. Aito isaanganë Jeripe, páganëri Isëre Tosorintsi. Te iraniobairi Etiopíasati. Paniro iátaji icaninasëretanë. ");
INSERT INTO notNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Iriroque Jeripe iconijapë poeboroquë jitacha Asoto. Yogaganaca cara Asotoquë irooti poeboropaguequë. Icomantëgotaguequeri Jesos icanque: —Pinguemisantiri Jesos, aro iragabisaicotajimi Tosorintsi. Irooti, cara yareca Sesareaquë. ");
INSERT INTO notNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Përosati ainta Saoro Jerosarénquë isariacari irócaiguëri antagaisati ira quemisantaiguëri Atingomi Jesoquirisito. Iroro iátaguëque iraniaqueri itingomi saseriroti. ");
INSERT INTO notNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Yamanopëri icampëri: —Nocoguini pomena pisanguenare. Náganëneri canta Tamásicoquë, nomëri ira obatacaguiri jorío cara yapatotaigaca. Pisanguenatinaro pingantiro negaca: “Pomitocotiri Saoro iráguiri antagaisati ira quemisanqueri Jesos, sërari, tsinane, omagaro. Iromapëri yaca Jerosarénquëca”. Aro isanguenaquineri. ");
INSERT INTO notNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Aique iáque Saoro. Pënibaque irarequimaro Tamásico cara iroguito iniobëro Saoro yosangueguitetocopëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ipariganë quibatsiquë, iquemobëro irinibare Jesos: —Saoro, Saoro, ¿Pairo picantobiquinaro catsimari? ");
INSERT INTO notNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yotabitanëri Saoro: —¿Pairi pijita, Natingomi? —Naanti Jesos Ira piguisaneinti. Obiro aisa picantari sërari baaca cara imeratëmanica iripasaqueri casintari. Ira baaca iragaitiguitetabequimari carari iratsipiriopiantë. Aisati obiati casitígatacha cara piguisaneinquina. ");
INSERT INTO notNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Itsoroganë Saoro imogomogoatanaca, icanë: —Natingomi ¿Pairo picogui nanganque naro? Aro icanëri Jesos: —Pingabiritima pijáte Tamásicoquë. Canta, nongomantëmiro ora pinganque. ");
INSERT INTO notNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ira sërari itsibataigapa Saoro iquenganeintaiganaca. Iquemasicaro irinibare, carari te iraneiri ira nibaquenguitsi. ");
INSERT INTO notNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Icabiritanaca Saoro yoquiriabetanaa, te iraniaje. Icatsatanëri ibacoquë irooti Tamásicoquë. ");
INSERT INTO notNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Canta, yogabisë maba cataguiteri te iranee, te irapae, teatisa iróguima nija. ");
INSERT INTO notNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ainta Tamásicoquë quemisantatsiri jitacha Ananías. Iconijatomopëri Atingomi icaimapëri: —¡Ananías! Yotabitanëri Ananías: —¿Pairo, Natingomi? Aintana naro yaca. ");
INSERT INTO notNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Icampëri Atingomi: —Pingabiritima, pijáte cara abatsiquë ora catingapoquiri. Cara ibangoquë Joras pingoguiri sërari jitacha Saoro ira Tárisosati. Ainta yamai yamanini. ");
INSERT INTO notNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aroque noniaguëri cantaca quisanitagantsi carari te irisome, iniaquemi obiro pinganaque poguineri pobaco iriroquë arota iranianae. ");
INSERT INTO notNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Icanqueri Ananías: —Tojai naquemocoqueri ira picomantëna yamai. Icantobiqueri catsimari ira quemisantaiguimi canta Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aisati naquemocoqueri cara igáqueri yaca itingomi saseriroti irágaiguëna antagaisati ira abentaiguëmira. ");
INSERT INTO notNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Icanëri Atingomi: —Pijáte. Aroque nocoiguëri ingomantëgotina joríojeguiquë, aisati basiniatiegui matsiguenga, aisati itingomieguiquë. ");
INSERT INTO notNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aisati noniaguëri cara tojai iratsipiriobiquina. ");
INSERT INTO notNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Aique iáque Ananías. Icapë pongotsiquë cara inasegui Saoro yoguëneri ibaco, icampëri: —Saoro, yamai obiro nopiguemisantane. Igáquina Atingomi Jesos ira conijatatequimi cara abatsiquë cara piquenopë. Igáquina cara aisati naniacagajimi, aisati inampëmi Isëre Caninaro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aito cara oparibentaguitanai ora iroquiquëti cantacha simabentaqui inatabecari, aro iniasantanai. Icabiritanaca Saoro ibaotisataca. ");
INSERT INTO notNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aisati yapasanotanai, isintsitanai. Arosataanti cataguiteri itiomotaiguëri quemisantatsiri canta Tamásicoquë. ");
INSERT INTO notNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Aique icomantëgotëri Jesos pongotsiquë cara yapatoita joríojegui. Icanque Saoro: —Jesos Irianti Itomi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iquenganeintasantaiganaca antagaisati ira quemaiguëri. Yosaminatobagaigaca: —¿Teco iriro tsongaiguërinime ira quemisantatsiri Jerosarénquë? ¿Teco iriro boquënguitsi yaca iraguëshotaiguërime ira quemisantiri Jesos, irágaiganaquerime itingomiquë saserirotijegui? ");
INSERT INTO notNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aiquero otojaiganaque icomantëgotasantëri Jesos Saoro. Iquenganeintasantaiganaca joríojegui Tamásicosati cara igótacagasantaiguëri Saoro. Icanqueri: —Aisonori Iriro Jesos Agabisaicoontatsiri. Ipaniaca Jonogaguitequë. Igáqueri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pabisanaque cataguiteri tojai. Iquengaigaca joríojegui iróguirime Saoro. ");
INSERT INTO notNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Carari Saoro iquemocoqueri. Antagaisati cataguiteriquë aisati tsitiniriquë imaguetabecari jorío cara omoroquë poeboro. Icogaigabitacari Saoro irágobërime irógaiguërime. ");
INSERT INTO notNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Carari tsitiniriquë ira quemisantatsiri yotequeri Saoro oquibequë cantiri yoguëtocoqueri sotoquë oticoro irooti osobinta. Isiganaca. Carari te iraniobairi jorío. ");
INSERT INTO notNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Yaretaja Saoro canta Jerosarénquë. Icogabeca intsibatimarime quemisantatsiri. Iriro te iraninte, itsorogobëtiguiri. Ijitasicari te inguemisante. ");
INSERT INTO notNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Carari yáganëri Saoro Berinabé catingasati iragátanequë Jesos inibabenqueri. Icomantëgotaguequeri Saoro cara abatsiquë iniobëri Atingomi inibatobëri ipasiniatitanai Saoro. Aisati Tamásicoquë iquenguitsatocotasantëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yamai itsibataigari quemisantatsiri cara Jerosarénquë. Perosati iquenguitsatocotasantëri Jesos. Te intsorogue Saoro. ");
INSERT INTO notNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Icomantaiguëri joríopague ira nibatatsi guiriego. Ipëgatsacari icogabeca jorío irógaiguerime Saoro. ");
INSERT INTO notNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cara iquemocoquero quemisantatsiri, yágaiganaqueri Saoro irooti Sesáreaquë. Aique yogabisëri Tárisoquë. ");
INSERT INTO notNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Aique caninasati yapatoibiritari Jesos canta Joreaquë, Garireaquë, aisa Samariaquë. Iquemisantasanotaiguëri Atingomi. Iniacobeingataigacari. Itojaiganaque quemisantatsiri. Poganinasëretaiguëri Isëre Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Iquenaguetanë Peroro basinipaguequë poeboro imitocotaiguëri quemisantatsiri, yareca Iriraquë. ");
INSERT INTO notNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Canta, ainta matsiguenga jitacha Eneas inasegui irisomamintoquë. Iriro emëngari, te iranëite ocarati 8 osarini. ");
INSERT INTO notNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Icampëri Peroro: —Eneas, iragaguibegajimini Jesoquirisito. Pingabiritima pobetsicanëro pisamamento. Aito cara icabiritanaca yanëitanai. ");
INSERT INTO notNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iniaiguëri antagaisati Irirasati aisa Sarósati iquemisantaiguëri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Cara basiniquë poeboro jitacha Jope otimabeta tsinane quemisantatsiri ojita Tabita ora ocanti maniro. Iroro caninaro. Përosati omitocotaguetiri otimanamitane. ");
INSERT INTO notNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aro ojanaitë Tabita ocamaque. Paquibatëro ogamaga poguëro jonoquë pongotsi cara pini sitomencorentsi. ");
INSERT INTO notNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iquemocoqueri ira Peroro. Ira Jopesati igáqueri pite sërari ingaimëntiri Peroro cara Iriraquë ocosamanisatatanë. Icampëri: —Omanapague popogopë. ");
INSERT INTO notNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aro yoguiatëri Peroro omanapague itencari. Yáganëri jonoquë cara pinasegui ogamaga Tabita. Oshongabocaro antagaisati ora ogamaimentaga piraicoquero Tabita. Poniagaigabaqueri Peroro oguitsagarepague ocantaigabaqueri: —Pinetsero oca. Cara terai ongame Tabita pobetsiquinaro antagaisati ocapague. ");
INSERT INTO notNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Yomisotocaiguëro antagaisati Peroro, yobaticagueritopa yamanocopëro. Aique inetsëro ogamaga icampëro: —¡Tabita, pingabiritima! Aro poquirianai, onetsëri Peroro, pisobicanë. ");
INSERT INTO notNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yágobagotairo Peroro icabiriquero, icaimaigairi quemisantatsiri aisati ogamaimentaga. Yoniagaigairi Tabita cara ocaniatanai. ");
INSERT INTO notNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Aro iquemocotaiguëro antagaisati Jopesati. Tojai matsiguenga iquemisanqueri Atingomi. ");
INSERT INTO notNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Cara Jopequë itimaque Peroro tojai cataguiteri ibangoquë Simón masitsiberi. ");
INSERT INTO notNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Canta Sesáreaquë ainta sërari jitacha Coronerio. Iriro capitán itingomi soraro icarati 100 Itariasati. ");
INSERT INTO notNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Iquemisantasantiri Tosorintsi aisati iniacobeingacari. Aisati imatsiguenga quemisantatsi. Tojai imitocoiguëri matsiguenga icábintsaiguëri. Përosati cara yamanopianti. ");
INSERT INTO notNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Aroque ochapinitanë cara iconijatomopëri ironomire Tosorintsi irisaanganetsite icampëri: —Coronerio. ");
INSERT INTO notNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Inetsëntobëri Coronerio itsorogasantanëri yosamitobëri: —¿Pairo ojita, Natingomi? Icampëri: —Iquemaquemi Tosorintsi cara pamanopiantëri. Aisati iniaquemi cara pomitocoiguiri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yamai pigátiri matsiguenga cara Jopequë ingaimëntiri Simón, aisati ijita Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Itimi ibangoquë isometi Simón ira masitsiberi. Aiti ibango onamijaquë angaare. Iriro cantëmine ora pinganque. ");
INSERT INTO notNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cara isaanganai ironomire Tosorintsi ira comantapëri Coronerio, icaimë pite iromeraro aisati paniro isorarote, maba quemisantiri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Icomantaguequeri antagaisati ora iniaque, igáqueri Jopequë. ");
INSERT INTO notNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Itimanë abatsiquë. Oquëtaguetamananaque iquenaque irooti catinga. Pënibaque irarequima Jopequë. Itanë Peroro jonoquë pongotsiquë yamanaque. ");
INSERT INTO notNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Itasegasantë icoque irape Peroro. Iroontita osobira pobetsiquëro perintsi tsinane, iniobëro Peroro ora cantaca quisanitagantsi igaguitaga iriro. ");
INSERT INTO notNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jonoquë yamanasegui Peroro iniabetobacaro paguëpë oquibemaronca tocoya yoguëshotaguequero Tosorintsi yoguëtopiantëro. ");
INSERT INTO notNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ainta yoguëtocoqueri pairiraca quimingaripague: chancho, marangue, saniri, paguitsa, tiso, antagaisati ijiqueri quimingari joríojegui. ");
INSERT INTO notNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aisati Peroro iquemobëro Irinibare Tosorintsi. Ocampëri: —Pingabiritima, Peroro. Póguiri pijagueri. ");
INSERT INTO notNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Carari yotabitanëri Peroro: —Quero naaguiri, Natingomi, irianti quimingari. ");
INSERT INTO notNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aisati icanqueri: —Ira noguëtetai Naro, quero pijitiri quimingari obiro. ");
INSERT INTO notNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Aro pipiganaja tocoya jonoquë, paguëtopiantë, mabataque iniobëro Peroro paguëque aro pogainocanaca. ");
INSERT INTO notNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Iroontita iquianquero Peroro ora iniaque aisati ora iquemobë, yaretaigaca maba sërari iragátane Coronerio. Yosamitëcobempëri nega itimi Simón. Yaretaigapa omoroquë ibango. ");
INSERT INTO notNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Icaimapëri yosamitapëri: —¿Aro itimi Simón yaca aisati ijita Peroro? ");
INSERT INTO notNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Përosati cara iquianca Peroro, aro ocomantëri Isëre Tosorintsi: —Pinetse ainta maba sërari icoguimini. ");
INSERT INTO notNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pingabiritima piguëtanë piguiatanëri aroquenta nigáquemiri Naro. Quero pitsoinguiri. ");
INSERT INTO notNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Yaguëtanë Peroro icabëri sërari: —Naro picogaigui. ¿Pairo pipocasiti? ");
INSERT INTO notNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yotabitaiganaqueri: —Nopaniaca Sesáreaquë. Igátaiguëna Coronerio, igapitante isorarote icarati 100. Iriro caninari. Iniacobeingacari Tosorintsi. Aisati iniacaninatëri iriro joríojegui. Cani iconijatomoqueri ironomire Tosorintsi icanqueri: “Yamai pigátiri matsiguenga iromapëri yaca pobangoquë ira Simón aisati ijita Peroro. Pinguemisantiri cara ingomantëmiro Irinibare Tosorintsi”. ");
INSERT INTO notNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Icabëri Peroro: —Pingapë. Yamai pintimopë yaca. Naramani naguiatëmi. Oquëtaguetanë iáiguë Peroro, iromeraro Coronerio, aisati itsibataigacari quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Otsitinitanë, oquëtaguetanai yaretaigaca Sesáreaquë. Ainta Coronerio aroque yapatotaiguëri ibangoquë tojai imatsiguenga aisati itimanamitane. ");
INSERT INTO notNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Icapë Peroro, yobetsatobacari Coronerio yobaticagueritotasitobacari. ");
INSERT INTO notNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Icabiriqueri Peroro icanqueri: —Pingabiritima. Cagarina naro Tosorintsi. Naanti matsiguenga aisa nacanta pibega obiro. ");
INSERT INTO notNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Inibatobaca pitirooti, icapë Peroro iniopëri tojai matsiguenga botoitachari. ");
INSERT INTO notNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Icantaigapëri: —Naro jorío. Pigóigui obirojegui te iranintacaguina nomatsiguenga nantsibatimari basiniati matsiguenga. Teni iraninte naniaiguemi. Carari yogomequinaro Tosorintsi cara quero najitajiri pairiraca quimingari. ");
INSERT INTO notNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iroro nipoguëpë omanapague cara picaimagantëna. Yamai nosamitapëmi, ¿Pairo picaimagantobiquina? ");
INSERT INTO notNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Yotabitanëri Coronerio: —Cani otsibasati cataguiteri aroque ochapinitanë canoca namanaque yaca nobangoquë, aro naniobëri matsiguenga iquitsagataro catarisonori iguitsagare. ");
INSERT INTO notNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Icampëna: “Coronerio, iquemaquemi Tosorintsi cara pamaniri. Aisati iniaquemi cara pomitocoiguiri matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yamai canta Jopequë pingaimagantiri Simón aisati ijita Peroro. Itiomoqueri basini Simón ira masitsiberi timatsi onamijaquë angaare”. ");
INSERT INTO notNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aito cara nigáqueri nomeraro ingaimëntimi. Yamai caninataque cara pipogopë. Ainta napatoitomocari Tosorintsi. Nocogaiguini yamai pingomantaigapënaro pairoraca igáquemi Atingomi. ");
INSERT INTO notNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Aique iparintaca inibatë Peroro icanque: —Yamai nigótasantë aisonori Tosorintsi te ingasiriconiatitiri matsiguenga antagaisatinta aisati icantaiga nibegaiga naro. ");
INSERT INTO notNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pairiraca niacobeingatiri quemisanqueri Tosorintsi aisati icantaguequero ora caninaro, aro iraniacaninatëri Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Naro jorío. Pigótocotobëro Irinibare Tosorintsi. Yoguibaiguënaro Irinibare icomantaiguëna: “Aroca pinguemisantaiguëri Jesoquirisito caninasati pintimaiguë”. Aitosati pingantina nibiaca naro yamai Irironta Jesoquirisito Itingomi antagaisati matsiguenga. ");
INSERT INTO notNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Piquemocotaigabaquero ora icanque Jesos. Aroqueque Joan iquenguitsatocoqueri: “Pomaotisabiritimari Quirisito”. Aique iparintaca Jesoquirisito icomantaguequeri Garireaquë irooti antagaisatiquë Jorea. ");
INSERT INTO notNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pigótocotobëri Jesos Nasaresati, ati icantacacari. Imitocoqueri Jesos Tosorintsi. Ipasërequeri Isëre aisati ipëri itasorintsite. Irooti iátagueantaca icantaguequero caninaro aisati irooti yoguibegantacari ira inanca camagari, imitocoquerininta Tosorintsi coshoni yoganëri Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Naroegui iragátane Jesos naniaiguëri antagaisati ora icantagueque Jesos iboeborotepaguequë nomatsiguenga aisati canta Jerosarénquë. Aisati naniaiguëri cara yógaiguëri, ipëicotaiguëri corosiquë. ");
INSERT INTO notNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Maba cataguiteri itinaajiri Tosorintsi yoganiatairi yoniagainari. ");
INSERT INTO notNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Te ironijagajimari basini matsiguenga, naantijegui yoniagaa. Naroegui icoigaiguë naniaigairinta cara icaniatai Jesos. Aroque icamasantabitaca, icaniatanai, napaagobairi aisati nógagobaari. ");
INSERT INTO notNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Igáquina nongomantaguequeri matsiguenga: “Yoguëri Jesos Tosorintsi arota ingomantëgotiri antagaisati matsiguenga pairoraca inganque aisati negaraca iriáiguë, ira caniari aisa ira camatsi”. ");
INSERT INTO notNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jirai icomantëgotëri Jesoquirisito antagaisati comantantatsiri icanque: “Pairiraca quemisanquerine Jesos aro ingábintsairi Tosorintsi irojocajineri ora icantagueti te ongomeite, quero iquengaineri aisati”. ");
INSERT INTO notNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Iroontita inibatasegui Peroro, aro pipocasipëri Isëre Tosorintsi pinantaigapari antagaisati ira quemisanquero irinibare Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aro iquenganeintasantanaca ira jorío quemisantatsiri itsibatapa Peroro. Yamai igóque aisati ipëri Isëre Tosorintsi ira basiniati matsiguenga cagari jorío. ");
INSERT INTO notNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Iquenganeintasantacari iquemaiguërinta imatsiguenga Coronerio aisati inibataiguë basiniati nibarintsi. Icantaiguë: —Caninari Tosorintsi. Aro icanti Peroro: ");
INSERT INTO notNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Yágasëretaiguëro Isëre Tosorintsi aisa icantaiguëna nibega naro jirai. ¿Teco caninataque imaotisataiguëma? Icanque jorío ira itsibatapa Peroro: —Jee, caninataque. ");
INSERT INTO notNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Aro ira Peroro icanqueri imatsiguenga Coronerio: —Pomaotisatobitaiguemari Jesoquirisito, ora irogóontaiguëmi matsiguenga cara piquemisantiri Quirisito. Yotabitanëri: —Aro pomaotisataiguena. Ibaotisatobitaigacari Quirisito. Aique yamanaqueri Coronerio: —Pintiomopëna arosataanti cataguiteri pogometaigapëna. ");
INSERT INTO notNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Canta Jerosarénquë iragátane Jesos aisati basini quemisantatsiri iquemocoqueri cara aroque iquemisanqueri Jesos basiniati matsiguenga ira cagari jorío. ");
INSERT INTO notNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cara itonganaji Peroro ipigapaa Jerosarénquë, iguisabiritobëri jorío ira quemisantatsi aisati ijique caninataque iritotima basiniati matsiguenga cara inguemisanque. ");
INSERT INTO notNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Yosamitaigabaqueri: —¿Pairo piábirique canta basiniatiquë matsiguenga? ¿Pairo papaagobiqueri? Picanquero ora te onganinate. ");
INSERT INTO notNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aique Peroro iquenguitsatomotaigapëri antagaisati, icampëri: ");
INSERT INTO notNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ainta ninasegui naro Jopequë. Namanasegui cara naniobëro ora cantacha quisanitagantsi. Oquenopë Jonogaguitequë paguëpë oquibemaronca tocoya yoguëshotaguequero Tosorintsi yoguëquinaro. ");
INSERT INTO notNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nanetsasantobëro. Ainta tsomagui pairiraca quimingaripague: chancho, marangue, secari, tiso — antagaisati najiqueri quimingari. ");
INSERT INTO notNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Aisati naquemobëri Tosorintsi icanquina: “Pingabiritima, Peroro. Póguiri pijagueri”. ");
INSERT INTO notNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nacanë naro: “Quero naaguiri, Natingomi, irianti quimingari”. ");
INSERT INTO notNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Icantajina aisati Tosorintsi: “Ira noguëtetai Naro, quero pijitiri quimingari”. ");
INSERT INTO notNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mabataque yogatsitainaro, aro pogainocanaa Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Aito cara yarepa maba sërari pongotsiquë cara natimaque. Ipaniaca Sesáreaquë icampë: “Igáitënani”. ");
INSERT INTO notNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pigáquina Isëre Tosorintsi: “Piguiatanëri. Quero pitsoinguiri”. Aro niáque. Aisati yoguiataiguëna ica nopiguemisantaneca icarati 6. Nacaigapë ibangoquë ira cajemacagantëna. ");
INSERT INTO notNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Icomantaguetobëna cara iconijatomoqueri ironomire Tosorintsi icampëri: “Pigátiri matsiguenga Jopequë ingaimëntiri Simón aisati ijita Peroro iribocapë yaca. ");
INSERT INTO notNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ingomantëmiroti Irinibare Tosorintsi pabisaicoontëma obiro aisati pomatsiguenga pobangoquë”. ");
INSERT INTO notNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Cara noparintaca nocomantaguetaigapëri, aro pipocasipëri Isëre Tosorintsi pinampari aisa icanquina nibega naroegui cara pipocasipëna jirai. ");
INSERT INTO notNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Naquianquero ora icomantacái jirai Atingomi icanque: “Iroro nija ibaotisatanta Joan, carari obirojegui iroquemiro Isëre Tosorintsi Caninaro”. ");
INSERT INTO notNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jirai cara aquemisantaiguëri Atingomi Jesoquirisito ipaigacáiro igácáiro Isëre Tosorintsi. Yamai aisati ipaiguëri Isëre basiniati matsiguenga. ¿Pairo najica naro cara nopëgatsaquimari Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iquemaigabaquero irinibare Peroro quemisantatsi Jerosaresati, te irinaje yamai pëgatsatimarine Peroro. Iroonti icantaiguë: —Iriro caninari Tosorintsi. Aisonori icoigaiguëri aisati basiniati matsiguenga imasiniatitanae ora iriátantajima Jonogaguitequë. ");
INSERT INTO notNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Aroqueque yogamagaiguëri Isiteban, iparintaigaca icantobiqueri catsimari ira quemisantiri Quirisito. Isiaguetanaca canta jaanta irooti Jenisiaquë, aique Chípirequë, aisati irooti Antioquíaquë. Iátagueque icomantëgotëri Jesos. Paniro iquenguitsatomotaguepëri joríojegui. ");
INSERT INTO notNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Yaretaigaca Antioquíaquë matsiguenga ipaniaca Chípirequë aintasa ipaniaca Sirenequë. Icomantaigapëri matsiguenga guiriego, cagari jorío. Icomantëgotëri Jesos: —Pinguemisantiri Jesos iragabisaicotajimi. ");
INSERT INTO notNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Imitocotasantëri Tosorintsi, aro iquemisantacaqueri tojai matsiguenga cagari jorío, yabentaigacari Atingomi. ");
INSERT INTO notNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ira botoibiritari Quirisito canta Jerosarénquë iquemocotaiguëri, igáqueri Berinabé Antioquíaquë. ");
INSERT INTO notNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yareca Berinabé iniopëri irirai quemisantatsi, igópëri icábintsaiguëri Tosorintsi. Icaninasëretapë, icampëri: —Coshoni poganëri Atingomi. Quero pomaguisantiri. Pinguemisantasantanëri. ");
INSERT INTO notNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Iriro caninari Berinabé. Iquemisantasanotiri Atingomi, aisati pinancari Isëre Tosorintsi. Iroro ora aiquero itojaigaguëtanë quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","26","Aique iáque Berinabé cara Tárisoquë iátasiqueri Saoro. Iniaqueri, yáganairi cara Antioquíaquë. Patiro osarini itimaque pitirooti Berinabé aisati Saoro yogomequeri ira botoibiritari Quirisito. Arosonori matsiguenga ira yogomeque. Cara Antioquíaquë ira quemisantiri Quirisito iritsita jitaiguënguicha quirisitiano, ira iraisati Quirisito. ");
INSERT INTO notNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Iroontita yogometaigaseguiri matsiguenga Berinabé aisati Saoro, ipogaigapë basini comantantatsiri ipaniaca Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Paniro ijita Agabo yaratingopë aganguisatiquë ira quemisantatsiri. Ora Isëre Tosorintsi ocantacaqueri Agabo icampë coraque opoque cara iritasegasanoiguë tojai matsiguenga omagaroguitequë. Aro ocanca cara itingomibintanti itingomi jitacha Caraorio. ");
INSERT INTO notNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aique ira quemisantatsiri Antioquíaquë iquengaigaca imagantaiguëri quirequi irapiguemisantane canta Jerosarénquë. Ira casintachari ipëri tojai, ira te irine tojai iguireguite ipëri arosata. ");
INSERT INTO notNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Aro ipagantëri canta Jerosarénquë. Yáganëri Saoro aisa Berinabé. Ipëri ira omisantiri irapiguemisantane. ");
INSERT INTO notNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ainta itingomi ijita Eroris canta Jerosarénquë yágagantëri atiraca icarati ira quemisantatsiri, cara ingantaguequeri ora catsimari. ");
INSERT INTO notNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yobatëantacari sabiri ira Santiago ireinti Joan. ");
INSERT INTO notNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Cara yoganinasëretaiga joríojegui, asiati Eroris yágagantëri Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Yágagantëri cara yapaisiguiro pan joríojegui ora te ingonaguero piponganta. Oca jiesita jitacha Pásicoa. Aroque yágagantëri Peroro, Eroris yomianqueri iromingamentoquë. Ainta soraro yomisantëri icarati itsibasati coniamaniquë. Ainta basini itsibasati catingaquë. Basini irirai itsibasati soraro chopiniquë, aisa basini itsibasati aganguite. Icogabeca Eroris aroca abisanaque Pásicoa iráganërime Peroro cara yapatoita matsiguenga ironijagantërime. Icogabeca Eroris iranetsaiguërime matsiguenga cara iragamaguërime Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ainta Peroro iromingamentoquë Eroris. Yomisantëri soraro. Ira quemisantatsiri botoibiritari Jesos yamanocobintasantëri Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Irooti tsitiniriquë cara queroquerai yoniaguiri Eroris matsiguengaquë isamasigui Peroro yoguëshosigaro pite sogatsa coshori. Icarasiguiri pite soraro, poro ibacosonoriquë poro imatequë. Ainta basini pite soraro omoroquë. ");
INSERT INTO notNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Iriguito iconijapë irisaanganetsite Tosorintsi yogonijaguitepëro tsomagui, icabocapëri Peroro icampëri: —Pingaguite pingabiritima yamaica. Aro otsaanaca ironeni ora yoguëshosiga ibacoquë aisa iguitiquë. ");
INSERT INTO notNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aisati icampëri ironomire: —Pomatsaguitima coshooti pomanchaquiquë. Poguimari pisapatote. Aro icanquero Peroro. Icanai irisaanganetsite Tosorintsi: —Pogaimaro pomanchaqui ora pobicota. Intsome, piguiatanëna. ");
INSERT INTO notNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Isotocanë Peroro yoguiatanëri ironomire Tosorintsi. Te irogóte iroroca aisonori ora icanque irisaanganetsite, iquisanitasicaroco. ");
INSERT INTO notNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Yabisanaqueri soraro omoroquë, aique basini soraro, te iraniobairi. Yareparo oquibequë sitëcori coshori pasirianaca ironeni isotocanë Peroro. Yáganëri ironomire Tosorintsi irooti cara págaboquiobaga abatsi yoganairi isaanganai te iraniobairi. ");
INSERT INTO notNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Icanë Peroro iquenganaca: —Yamai nigóque. Aisonori igáquinari ironomire Tosorintsi cara iromisotocajina iragabisaicotajina cara icogaigabitaca Eroris aisa joríojegui iróguiname. ");
INSERT INTO notNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iquianca Peroro, iáque cara obangoquë Maria iniro Joan. Joan aisati ijita Maricos. Cara, inaisigui tojai matsiguenga yamanaigasegui. ");
INSERT INTO notNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","14","Itaapëro sitëcori Peroro ton ton ton. Pipogopë onamire María ojita Irore. Oquemobëri pigótsatobëri ora irinibare Peroro ocaninasëretanë. Te osirecotiri. Pisiganëtiga tsomagui ocomantaigapëri matsiguenga: —¡Ainta Peroro sotoquë! ");
INSERT INTO notNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Icantaigabaquero matsiguenga: —¡Teni pineicotima! Iroro ocanatanë: —Jee, aisonori iriro Peroro. Icantaiguë: —Cagari Peroro; irianti ironomire Tosorintsi omisantiri Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Iroontita inibatobagaigaca tsomagui, përosati cara itaapiantëro Peroro sitëcori. Cara yasirecoqueri iniobëri imabocacari. ");
INSERT INTO notNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Icanaque Peroro yacopëri imairetanë. Icomantapairi cara yomisotocajiri Atingomi. Icampëri: —Pingomantiri Santiago aisati ira quemisantatsi. Aique iáque Peroro basiniquë pongotsi. Imánaca. ");
INSERT INTO notNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cara oquëtaguetanë itsorogaiganaque soraro cara icogabetajari Peroro. ");
INSERT INTO notNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Igáantairi Eroris ingogajiri. Te irinaje. Eroris yosamitasantëri isorarote ira omisantëri Peroro. Te. Aro igáqueri basini soraro iróqueri ira omisantabitacari. Aique iáque Eroris cara Joreaquë irooti basiniquë poeboro jitacha Sesárea. ");
INSERT INTO notNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Eroris iguisaneinqueri ira timaigatsi pitequë poeboro jitacha Tiro aisa Sirón. Iriroqueraiegui iquengaiganaca iromanaiguëri Eroris iraniacaninatëri aronta opaniaca tojai iraperi iragáantanequë Eroris. Ipaigapëri quirequi ira Barásito iromeraro Eroris arota irinibabintëri caninasati. ");
INSERT INTO notNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Iquengaigaca cara cataguiteriquë. Cara yaretaigaca matsiguenga, icanaquero Eroris imanchaqui caninari, isobiaque cara iragáantomentoquë inibataigapëri Tirosati aisa Sirósati. ");
INSERT INTO notNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Iparintanaca Tirosati aisa Sirósati icaimanë: —Cagaro irinibare matsiguenga. Iroonti irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aito cara itsirishobitanacari Tosorintsi igáqueri insaanganetsite yoanaitëri Eroris tenta ingomantëgotima cara irianti matsiguenga cagari Tosorintsi. Aito cara yaaganaqueri isitsane icamaque. ");
INSERT INTO notNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yamai otojaiganaque Irinibare Tosorintsi iquemaigabaquero omagaroguitequë. ");
INSERT INTO notNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Aroque itsonquero ora igáquengani Berinabé aisa Saoro cara Jerosarénquë, ipiganaja Antioquíaquë. Yáganëri Joan aisa ijita Maricos. ");
INSERT INTO notNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Cara yapatoibiricari Jesoquirisito Antioquíaquë ainta comantantatsiri aisati ogomeantatsiri. Ainta Berinabé aisa Saoro, Irosio Sirenesati, Simón aisati ijita Tsitari, aisa Manaem itsibatari Eroris itingomi cara iquibiaiganaque pitirooti. ");
INSERT INTO notNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Cara yapatoibiricari Atingomi aisati cara ititaigaca ocanque Isëre Caninaro Tosorintsi: —Poguinari casiriconiati Berinabé aisa Saoro. Nacaimërini nagáqueri ingomantagueantë Nanibare. ");
INSERT INTO notNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Cara itsongaiguë yamanaiguë aisa itsongaiguë cara ititaiga, aro yogaiguëneri ibacojegui iguitoquë Saoro aisa iguitoquë Berinabé. Igátaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Aroqueque pigáiguëri pitirooti Isëre Caninaro Tosorintsi, iáiguë Serosiaquë yotetaigapa oquibequë pitotsi iquenocoque irooti oboguesiquë jitacha Chípire. ");
INSERT INTO notNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yaretaigaca poeboroquë jitacha Saramina yaguëtaigapë. Iparintaigapa icomantagueantapëro Irinibare Tosorintsi cara yapatotaiga joríojegui. Aisati itencari Joan Maricos imitocotaguetiri. ");
INSERT INTO notNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yogagaiganaca irooti poeboroquë jitacha Pajos. Iniaigapëri jorío jitacha Barajesos. Iriro matsi, aisati comantantatsiri matobiantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ira matsi itsibatacari tininti ijita Sérijio Paoro ogótatsiri. Ira tininti icaimagantaiguëri Berinabé aisa Saoro. Icoque inguemobëro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ira matsi, aisati ijita Erimas, ipëgatsatobacari tenta iranintacaguiri inguemisante tininti. ");
INSERT INTO notNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saoro, aisati ijita Paboro, inibatancari Isëre Caninaro Tosorintsi. Inetsasantëri matsi, ");
INSERT INTO notNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","icanqueri: —Obiro matobiantatsiri, cantaguetatsiri, aisa picantari ibega camagari, te pinintëmatiro ora aisonori nibarintsi. ¿Te pingaratëmate cara pitsoinguëro Irinibare Tosorintsi? ");
INSERT INTO notNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yamaica ingasitígatëmini Tosorintsi pingomarajaqueni, cosamani quero piniajiro cataguiteri. Aito cara icomarajatanë matsi. Itsitiniatanë iroquiquë. Icoque pairiraca catsatajirine. ");
INSERT INTO notNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cara iniaqueri tininti, iquenganeintasantanëro Irinibare Tosorintsi. Aito cara iquemisantanëro iriro. ");
INSERT INTO notNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Cara Pajoquë yotetaiganaca Paboro aisa itsipa cara pitotsiquë iquenocoque irooti Pérejequë cara quibatsiquë jitacha Pampiria. Aito ijocanëri Joan. Iriroque pigaacha irooti Jerosarénquë. ");
INSERT INTO notNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yogaganaca Berinabé aisa Saoro irooti basiniquë poeboro aisati ojita Antioquía cara aronisatiquë Pisiria. Ora cataguiteri comagoriantague icanaque pitirooti cara yapatoita jorío, isobigopë. ");
INSERT INTO notNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Cara aroque inibataiguëri matsiguenga ira obatatsi, inibatëro ora isanguenaque Moisés aisa ora isanguenaque comantantaguetatsiri, aro icantaigabaqueri Berinabé aisati Paboro: —Nomatsiguenga, aitica ora pininti pinibatiri ica matsiguengaca, atsi pinguengabaguitomotiri. ");
INSERT INTO notNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aro icabiritanaca Paboro yacopëri matsiguenga imaireitanë icanë: —Nomatsiguenga joríojegui aisati obirojegui quemisantasantiri Tosorintsi, pinguemina. ");
INSERT INTO notNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Itosorintsite Isirael icoigaiguë nomatsiguenga jirai, aisati yomitojaiganaqueri cara itimiquerai Ejípitoquë. Tosorintsi oniagaiguëri Ejípitosatiegui itasorintsite ora yágantajari nomatsiguenga ");
INSERT INTO notNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","irooti canta te ontimingani, iroonti piriabatsaro quibatsi. Te ine anchato tenta ine tojai angani. Itsirishacari Tosorintsi tenta inguemisantaigueri 40 osarini; tojai itsoingaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Aisati Tosorintsi ipoguiriaiguëri basiniati matsiguenga ira nibataiguiro siete basiniati nibarintsi. Yágabitsaqueri iguebatsite, ipaiguëri nomatsiguenga jirai. ");
INSERT INTO notNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Pabisanaque osarini ocarati 450. Ipaiguëri Tosorintsi basinipague itingomi ira comantëgotantatsiri aisati ijita joes irooti cara inë Samoel comantantatsiri ibatacagaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yamanopiantaiguëri Samoel: “Pomaiguenari natingomi”. Ipaiguëri Tosorintsi ira Saol itomi Sis iriro imatsiguenga Benjamín jirai. Itingomibintanque Saol 40 osarini, ");
INSERT INTO notNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","aro yágabitsaqueri Saol Tosorintsi, yoguëri David irirai itingomi joríojegui. Icantocoqueri David Tosorintsi: Naniacaninatëri David itomi Isaí, nanintiri. Inganquero antagaisati ora nongocaqueri, catingasati inguemisanquina. ");
INSERT INTO notNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","—David icharinencari Ira Jesos. Jirai Tosorintsi icomantëri David cara iragáqueri iragabisaicotajiri matsiguenga. Yamai igáqueri Jesos iragabisaicotaigairini Isirael cara icanque Tosorintsi jirai. ");
INSERT INTO notNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Teraiquerai iriboque Jesos, Joan icomantaguequeri joríojegui cara iriocairo ora icantagueti te onganinate inganaima yacaqueroca, imaotisataiguëma. ");
INSERT INTO notNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Cara pënibaque iritsonguëro Joan cara ingomantaguequeri matsiguenga Irinibare Tosorintsi, icanque: “Cagarina naro Agabisaicoontatsiri ira poguiaiguëra. Aique naro coraque iribocapë basini Itingomisonori. Teni aisa nangantimari ibega Iriro. Teni onganinate nantsaitiri isapatotsate. Ibaquina Irironta Itingomisonori, nitsoingaa naronta cantaca iromeraro. Naanti matsiguenga”. ");
INSERT INTO notNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nomatsiguenga, irasiquë itomi Abaram, aisati obirojegui quemisantasantiri Tosorintsi, nongomantaiguëmini aroca anguemisantiri Jesos, aro iragabisaicocái Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","—Ira Jerosaresati aisati itingomipague te irogóigueri Jesos pairiraca ijita Iriro. Teatisati inguemiro Sanguenari ora isanguenataiguë jirai comantantatsirijegui isanguenatocotaiguëri Jesos. Antagaisati cataguiteri comagoriantague inibataigabitaro Sanguenari Jerosaresati carari te inguemiro, te iraneiri Jesos Sanguenariquë. Iroro imoncaraquero Sanguenari cara inibatëcoiguëri Jesos: “Ingameta”. Te irogóigueri. ");
INSERT INTO notNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Cara te ingantëmatiro Jesos ora te onganinate, yamanaiguëri ira Pirato cara irócagantëri. ");
INSERT INTO notNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Aroqueque omoncaraca ora isanguenatocoqueri Jesos, aro ipëicoqueri corosiquë irooti cara icamaque. Yoguëtajiri cara corosiquë yáganëri itiajiri. ");
INSERT INTO notNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Carari Tosorintsi icabiriqueri itinaajiri yoganiatairi. ");
INSERT INTO notNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tojai cataguiteri Jesos iconijatomotaigapairi ira tsipataigari jirai abatsiquë cara iáiguë Garireaquë irooti Jerosarénquë. Yamai ira tsipataigari Jesos jirai iriro comantëgotaiguëri matsiguengaquë. ");
INSERT INTO notNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Naroegui comantaiguëmine yamai Caninaro Nibarintsi cara aroque omoncaraca ora icanqueri Tosorintsi omatsiguenga jirai cara iragáqueri Agabisaicoontatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Naroegui itomijegui jirainisati imoncaraquinaro Tosorintsi ora icantocobintëri Jesos jirai. Cara sárimoquë pite icanque Tosorintsi: Obiro Notomi, yamai notomintëmi najiquimi obiro Notomisonori. ");
INSERT INTO notNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Aisati Tosorintsi icantocoqueri cara ingabiritajiri igamaga arota quero ibatsagui cara icanque: Nomoncaratasantëmiro ora nocomantëri David jirai. ");
INSERT INTO notNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Iroro aisati icantocoqueri Jesos David basiniquë sárimo: Quero pinintacaguina nibatsagui Naronta piniacaninati Pitomi. ");
INSERT INTO notNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Cara iquemisanquero David aisati icanquero ora icocaqueri Tosorintsi, aro icamaque, itiaigairi ira icarati imatsiguenga jirai, ibatsaque. ");
INSERT INTO notNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Carari igamaga Jesos Ira icabirique Tosorintsi yoganiatairi te iribatsague. ");
INSERT INTO notNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","—Nomatsiguenga, nocoguini pigóigue obirojegui ora nongomantaguetaiguëmi, yamai Tosorintsi irojocajimiro ora picantagueti te onganinate pinguemisanquerica Jesos tenta ojocajimiro cara piquemisanquero ora isanguenaque Moisés jirai. ");
INSERT INTO notNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Iraniacaninatërini Tosorintsi pairiraca quemisanquerine Itomi. ");
INSERT INTO notNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Obirojegui, pigamaiguema querota pomoncarataigaro ora isanguenataiguë comantantatsiri cara icantaiguë: ");
INSERT INTO notNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","¡Pinetsaigue, tsoengatsiri! ¡Pinguenganeintasantaiguema, pingamaiguëni pitsongaiguëma! Naronta Tosorintsi natasongantasantëni. Cara piniaiguëro quero piquemisantiro, aisati pairiraca comantabitimirone quero piquemisantiro. ");
INSERT INTO notNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","43","Cara itsonganaquero inibatëro, isotocanë Paboro aisa Berinabé cara yapatoica jorío, yamanaiguëri matsiguenga cara ingomantaigairi aisati cara basiniquë cataguiteri comagoriantague. Arosonori jorío iquemisantiri Tosorintsi aisati matsiguenga ira cagari jorío yoguiataiguëri Paboro aisa Berinabé. Iriroque Paboro aisa Berinabé inibataigairi cara përosati inguemisantaigueri Tosorintsi arota ingábintsaigueri. ");
INSERT INTO notNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Cara basiniquë cataguiteri comagoriantague yapatoica pënibaque omagaro matsiguenga cara poeboroquë arota inguemiro Irinibare Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ijonaqueri jorío cara iniaigabaqueri tojai matsiguenga, aro iguisaneintobiqueri Paboro aisa Berinabé. Aisati ira jorío icantocotaguetasicari Paboro aisa Berinabé itsoiguëgotasitacari. ");
INSERT INTO notNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Te intsorogue Paboro aisati Berinabé, icanqueri: —Noguibatëmi obirojegui jorío nocomantabitëmiro Irinibare Tosorintsi, yamai tenta pinintaigue págobëro pinguemisantobëro, quero pitiomotiri përosati Tosorintsi Jonogaguitequë, yamai najátasitiri basiniatiegui matsiguenga ira cagari jorío. ");
INSERT INTO notNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Naronta igáque Atingomi icanque: Obiro noguë aisa pingantimaro obotagantsi poniagaigueri pigótacagaigueri omagaro potsatenganëri matsiguengapague cara iragabisaicoiguëri Tosorintsi cara inguemisanqueri Itomi jitacha Jesoquirisito. ");
INSERT INTO notNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Cara iquemobëro oca ira cagari jorío, icaninasëretaiganaque icantocobentaiguëro Irinibare Atingomi caninaro. Iquemisantaiguëro antagaisati ira icoigaiguë Tosorintsi intiomoqueri jonoquë. ");
INSERT INTO notNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Aro icomantantaguetiro ora Irinibare Tosorintsi omagaroguitequë quibatsi. ");
INSERT INTO notNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ira joríojegui inibaiguëri ira obataguetatsi cara poeboroquë, aisati inibaiguëro tsinanepague obatatsi ora cogabitacha ogótiri Tosorintsi. Icanqueri jorío cara ingantobitaiguëri ora catsimari ira Paboro aisa Berinabé irooti cara ijocaiguëri. ");
INSERT INTO notNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Cara iáiguë pitirooti ipotetanëneri pojongamamori isapatotequë, icanque: —Tenta pinguemisantiri Tosorintsi, ingasitígataiguemita. Irooti yogagantanaca cara poeboroquë jitacha Iconio. ");
INSERT INTO notNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Irari quemisantatsiri icaninasëretaiganaque aisati pinancari Isëre Caninaro Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Canta Iconioquë icanaque Paboro aisa Berinabé pongotsiquë cara yapatotaiga jorío. Icomantëgotapëri Jesos; iquemisantacaqueri tojai matsiguenga, jorío aisati ira cagari jorío. ");
INSERT INTO notNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ainta jorío, ira te inguemisante, icantocotaguetasicari Paboro aisati Berinabé. Ira jorío botoitëri basiniati matsiguenga iguisaneintacaqueri ira quemisantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tojai cataguiteri itimaque Paboro aisati Berinabé icomantëgotaguetiri Atingomi, te intsorogue. Ira Atingomi imitocoqueri Paboro aisati Berinabé itasongobentaiguëri matsiguenga, ora irogóontaiguëmari matsiguenga cara ingábintsaigairi Tosorintsi. ");
INSERT INTO notNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Te inguengaiguema matsiguenga Iconiosati. Ainta ira aguiaiguëri jorío. Aintasati basini aguiaiguëri ira quemisanqueri Jesos. ");
INSERT INTO notNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Cara icoque jorío aisati basiniati matsiguenga aisati itingomipague iquengaigaca ingantobiquerime catsimari Paboro aisa Berinabé, icogabeca iribasegaiguerime. ");
INSERT INTO notNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Cara iquemocoqueri Paboro aisati Berinabé isiganaca poeboroquë aitoniati jitacha Irísitira aique yogaganaca basiniquë poeboro ojita Térebe, iroro pitirooti poeboro Iricaoniaquë. Aisati iátaiguë basiniquë poeboro aronisati. ");
INSERT INTO notNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Yotsatenganëri matsiguenga icomantaguetanëri Caninaro Nibarintsi. ");
INSERT INTO notNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Canta Irísitiraquë iniopëri isobiaque sërari carancaratatsi te iranëitëmate përosati cara inë irooti cara yarepa Paboro. ");
INSERT INTO notNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Iquemobëri Paboro. Inetsapëri iriro Paboro igótocopëro cara iquemisanqueri Atingomi yoguiaqueri iragaguibegajiri. ");
INSERT INTO notNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Icampëri: —¡Pingabiritima! Aro omanapague icabiritanaca yaratinganë yanëitanë. ");
INSERT INTO notNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Iniaiguëri tojai matsiguenga, igóiguë cara yoguibegajiri Paboro, icaimëgotobëri icantaiguë: —Yamasobingopë nobabane icampari sërari. Inibataiguëri irinibarequë Iricaoniasati. ");
INSERT INTO notNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ira Berinabé ijitaigabaqueri Seos. Iriroque Paboro ijitaigabaqueri Erimes irironta comantantatsiri. ");
INSERT INTO notNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Cara poeboroquë aiti pongotsi irasi Seos ibabane Iricaoniasati. Ainta saseriroti irasi Seos. Yamapë sërari baaca aisati santotega. Itsibataigacari matsiguenga ira saseriroti cara icogaigabitaca iróquinerime baaca Berinabé aisati Paboro. ");
INSERT INTO notNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Iquemocoquero pitirooti iragátane Jesos, itisaraanëro iguitsagare tenta iraninte iriro iróguineri baaca, isigasitanacari cara yapatoica matsiguenga. Icaimaiguëri ");
INSERT INTO notNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","icanque: —Matsiguenga ¿Pairo pintaigui? Cagarina naro pobabane. Naanti matsiguenga aisati nacantaiguimi pibega obirojegui. Ora nipocasiti nongomantaiguëmiro pijoquiro oca picantagueti te onganinate. Aisati pijoquiri pobabane ira cagari Tosorintsi. Pinguemisantaigueri Tosorintsi Ira catimanerisonori Ira obetsiquëro Jonogaguite, aisati quibatsi, angaare, antagaisati ora inaguetatsi, omagaro yobetsiquëro. ");
INSERT INTO notNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jirai yabetaiguëri matsiguenga ira cagari jorío cantaguetiro pairoraca. ");
INSERT INTO notNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Përosati yoniagacari jirai Tosorintsi, aisati yoniagaiguëmi, icábintsaiguëmi, yobariaquemiro angani, ipaiguëmiro poperipague papasanoiguë piquemaiganaca ora picaninasëretantaigaca. ");
INSERT INTO notNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tojai ora icomantaguequeri, pënibaqueme iritaineri ibaacate carari te ingantiro. ");
INSERT INTO notNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Aique ipocaigapë jorío ipaniaca Antioquíaquë aisati Iconioquë. Ijitacagopëri aisonori ira matsiguenga icampëri: —Pigamemari Paboro. Itsoigani. Iriro matobiantatsiri. Intsome obaseguiri. Aro iguisaneinqueri Paboro matsiguenga, ibasegaiguëri ijitaigabitaca yogamagaiguëri. Inosicaiganaqueri igamaga sotoquë poeboro, ijoqueri. ");
INSERT INTO notNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Iátasiiguëri quemisantatsiri ishongopari Paboro irooti cara itinaanaa icabiritanaa ipigapaa poeboroquë. Oquëtaguetanë iátacaqueri Berinabé irooti Térebequë. ");
INSERT INTO notNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Icomantëgotëri Jesos. Tojaini matsiguenga ira iquemisantacaque. Aro ipiganaja Paboro aisati Berinabé Irísitiraquë aique Iconioquë aique Antioquíaquë. ");
INSERT INTO notNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Cara iátagueque pitirooti yapatoiqueri quemisantatsiri icomantasantaigapëri: —Coshoni poguëri Atingomi. Përosa cara pinguemisantasanotiri. Quero pipasiquitiri. Aiquenta tojai pitsipireicobintëri Jesos cara queroquerai pareta Jonogaguitequë. Icomantasantapëri oca, yosintsisëretëri ira quemisantaigatsi. ");
INSERT INTO notNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Aitosati cara yapatoibiricari Quirisito ira quemisantatsiri, Paboro aisati Berinabé yogaigapëri antiasipari ira omisantirine irapiguemisantane. Itica Paboro aisati Berinabé, yamanocoiguëri ira omisa