﻿USE sofia;
DROP TABLE IF EXISTS sofia.norlb_vpl;
CREATE TABLE norlb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES norlb_vpl WRITE;
INSERT INTO norlb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dette er forfedrene til Jesus Kristus, den lovede kongen, som var etterkommer til kong David og Abraham: ");
INSERT INTO norlb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, Isak og Jakob var far til Juda og brødrene hans. Videre fulgte: ");
INSERT INTO norlb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda og Peres, som var tvillingbror til Serah, og moren het Tamar. Så kom: Hesron, ");
INSERT INTO norlb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Amminadab, Naksjon, ");
INSERT INTO norlb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, Boas, og moren het Rahab. Etterpå finner vi: Obed, og moren het Rut, Isai, som ble far til ");
INSERT INTO norlb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kong David. Salomo, som var sønn til Batseba, enken etter Uria. Videre: ");
INSERT INTO norlb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Rehabeam, Abia, Asaf, ");
INSERT INTO norlb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Josafat, Joram, Ussia, ");
INSERT INTO norlb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jotam, Akas, Hiskia, ");
INSERT INTO norlb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manasse, Amos, ");
INSERT INTO norlb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia, som var far til Jojakin og hans brødre, som ble født ved den tiden da folket ble ført bort til fangenskap i Babylon, og Jojakin. ");
INSERT INTO norlb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Etter å ha blitt ført bort til Babylon, fulgte: Sealtiel, Serubabel, ");
INSERT INTO norlb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiud, Eljakim, Asor, ");
INSERT INTO norlb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadok, Akim, Eliud, ");
INSERT INTO norlb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleasar, Mattan, Jakob, ");
INSERT INTO norlb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","og Josef. Josef var mannen til Maria og hun var mor til Jesus Kristus. ");
INSERT INTO norlb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Disse personene utgjør 14 slektledd fra Abraham og fram til kong David, 14 slektledd fra kong David og fram til tiden da jødene ble ført bort til Babylon og 14 slektledd fra epoken i Babylon og fram til Jesus Kristus. ");
INSERT INTO norlb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Da Jesus Kristus ble født, gikk det slik til: Hans mor Maria var trolovet og skulle gifte seg med Josef. Men allerede før de var gift, ble hun med barn ved Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josef, hennes kommende mann, så da ingen annen utvei enn å skille seg fra henne i stillhet. Han ville leve etter Guds bud, men ønsket ikke å skjemme ut Maria offentlig. ");
INSERT INTO norlb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mens han fortsatt grublet på hvordan han skulle løse problemet, viste en Herrens engel seg for ham i en drøm. Engelen sa: ”Josef, du som er etterkommer av kong David, du skal ikke nøle med å gifte deg med Maria, for det barnet hun bærer, er blitt til ved Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hun skal få en sønn, og du skal kalle ham Jesus, for han skal frelse folket sitt fra syndene deres.” ");
INSERT INTO norlb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","På denne måten ble det som Gud hadde forutsagt ved profeten Jesaja, til virkelighet: ");
INSERT INTO norlb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","”Lytt! Den unge jenta skal bli med barn og føde en sønn, og de skal kalle ham Immanuel, som betyr ’Gud er med oss’.” ");
INSERT INTO norlb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Da Josef våknet, gjorde han som engelen hadde gitt beskjed om, og han giftet seg med Maria. ");
INSERT INTO norlb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","De hadde imidlertid ikke noe seksuelt samliv før sønnen var født. Josef ga ham navnet Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus ble født i byen Betlehem i Judea mens kong Herodes regjerte. Etter fødselen kom noen astrologer fra Østen til Jerusalem og spurte: ");
INSERT INTO norlb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","”Hvor er jødenes konge som nylig er født? Vi har sett stjernen hans gå opp i vårt eget land og har kommet for å hylle ham.” ");
INSERT INTO norlb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kong Herodes ble fullstendig vettskremt av spørsmålene deres, og hele Jerusalem begynte å summe av rykter. ");
INSERT INTO norlb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Han kalte derfor sammen folkets øversteprester og de skriftlærde til et møte og spurte dem ut om hvor Messias, den lovede kongen, skulle bli født. ");
INSERT INTO norlb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","”I Betlehem i Judea”, svarte de, ”for Gud har sagt ved profeten Mika: ");
INSERT INTO norlb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","’Du Betlehem i Judas land, du er slett ikke noen ubetydelig by, for en høvding skal komme fra deg, en som blir gjeter for mitt folk Israel.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Da kalte Herodes i hemmelighet astrologene til seg på nytt. Ved dette møtet lyktes det ham å få nøyaktig greie på tidspunktet da de første gangen hadde sett stjernen. Han sa til dem: ");
INSERT INTO norlb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","”Reis til Betlehem og let etter barnet. Når dere har funnet det, må dere komme tilbake og fortelle det til meg. Også jeg vil reise dit og hylle barnet.” ");
INSERT INTO norlb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Etter samtalen med kongen ga astrologene seg av sted. Den stjernen de hadde sett gå opp i sitt eget land, viste seg da på nytt for dem. Den gikk foran dem og stanset over det stedet i Betlehem der barnet var. ");
INSERT INTO norlb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Astrologene ble glade da de fikk se stjernen. ");
INSERT INTO norlb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","De gikk inn i huset og fant barnet og moren Maria. Der falt de på kne og hyllet ham. Så tok de fram skrinene sine og ga barnet gaver. Det var gull, røkelse og myrra. ");
INSERT INTO norlb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Men da de skulle vende tilbake til sitt eget land, reiste de ikke gjennom Jerusalem for å gi rapport til kong Herodes. Gud hadde i mellomtiden advart dem i en drøm, og derfor tok de en annen vei hjem. ");
INSERT INTO norlb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Da astrologene hadde reist sin vei, viste en Herrens engel seg i en drøm også for Josef. Engelen sa: ”Stå opp og dra som flyktning til Egypt med barnet og moren. Bli der til jeg sier i fra, for kong Herodes vil lete etter barnet og forsøke å drepe det.” ");
INSERT INTO norlb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mens det fortsatt var natt, ga Josef seg av sted til Egypt, sammen med Maria og barnet. ");
INSERT INTO norlb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","De bodde der til kong Herodes var død. Gjennom dette ble det som Gud hadde forutsagt hos profeten Hosea, til virkelighet: ”Jeg har ført sønnen min ut av Egypt.” ");
INSERT INTO norlb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes ble rasende da han forsto at astrologene hadde lurt ham. Han sendte soldater til Betlehem med befaling om å drepe alle guttebarn som var to år eller yngre. Ordren gjaldt både i byen og landsbygden i nærheten. Dette hadde sin grunn i at astrologene hadde sagt at stjernen første gangen viste seg for dem to år tidligere. ");
INSERT INTO norlb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gjennom Herodes sin grusomme handling ble det til virkelighet som Gud hadde forutsagt ved profeten Jeremia: ");
INSERT INTO norlb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","”Ett rop ble hørt i Rama, gråt og høylytt klage. Rakel gråter over barna sine og lar seg ikke trøste, for de finnes ikke mer.” ");
INSERT INTO norlb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Da Herodes var død, viste en Herrens engel seg på nytt i en drøm for Josef i Egypt, og sa til ham: ");
INSERT INTO norlb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","”Gjør deg klar, ta med deg barnet og moren og reis tilbake til Israels land, for de som forsøkte å drepe barnet, er døde.” ");
INSERT INTO norlb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josef vendte da straks tilbake til sitt eget land med Maria og barnet. ");
INSERT INTO norlb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Men på veien hjem ble han redd, etter som han fikk vite at sønnen til Herodes, som het Arkelaus, nå hadde blitt konge i Judea. I en annen drøm ble han oppfordret til å reise til Galilea. ");
INSERT INTO norlb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Familien bosatte seg i byen Nasaret. Gjennom dette ble det til virkelighet som Gud hadde forutsagt om Jesus ved profetene: ”Han skal bli kalt en nasareer.” ");
INSERT INTO norlb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Litt seinere begynte døperen Johannes å undervise ute i den jødiske ødemarken. Budskapet hans var: ");
INSERT INTO norlb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","”Vend dere bort fra synden og let etter Gud. Han har kommet for å frelse menneskene og gjøre dem til sitt eget folk!” ");
INSERT INTO norlb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Det var ham Gud talte om ved profeten Jesaja, da han sa: ”En stemme roper i ødemarken: ’Rydd vei for Herren! Gjør stiene rette for ham!’ ” ");
INSERT INTO norlb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johannes hadde klær som var vevd av ull fra kameler. Rundt midjen hadde han et lærbelte. Maten han spiste, var gresshopper og honning fra ville bier. ");
INSERT INTO norlb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Folk fra Jerusalem, fra alle deler av Judea og fra hele Jordandalen, kom ut i ødemarken for å høre ham tale. ");
INSERT INTO norlb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Etter at folket hadde bekjent syndene sine, døpte han dem i elven Jordan. ");
INSERT INTO norlb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Da Johannes så at mange fariseere og sadukeere kom for å bli døpt, talte han strengt til dem og sa: ”Dere ormeyngel, tror dere at dere kan flykte bort fra Guds kommende dom? ");
INSERT INTO norlb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nei, først må dere bevise at dere har vendt dere bort fra synden ved å gjøre det som er rett. ");
INSERT INTO norlb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Innbill dere ikke at dere kan slippe unna. Tenk ikke: ’Vi er trygge, for vi er jøder, og Abraham er vår stamfar.’ Jeg forsikrer dere at det ikke hjelper. Gud kan forvandle disse steinene til jøder! ");
INSERT INTO norlb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dommen henger over dere, øksen har allerede begynt å hogge i trestammen. Hvert tre som ikke bærer god frukt, skal bli hogget ned og kastet på ilden! ");
INSERT INTO norlb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Den som erkjenner syndene sine og vender om til Gud, skal jeg døpe med vann. Men det skal komme en som er større enn meg. Han er så mektig at jeg ikke en gang er verdig til å ta sandalene av føttene hans. Han skal døpe dere med Guds Hellige Ånd og ild. ");
INSERT INTO norlb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Det er han som skal dømme verden. Han står klar til å skille de onde fra dem som følger Guds vilje, på samme måten som bonden skiller agnene fra hveten. Etter at han har renset opp på treskeplassen, skal han samle hveten i laden, men agnene skal han brenne opp i en ild som aldri slokner.” ");
INSERT INTO norlb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesus dro nå fra Galilea og kom til elven Jordan for å bli døpt av Johannes. ");
INSERT INTO norlb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Men Johannes ville ikke døpe ham. Han sa: ”Det kan ikke være riktig. Egentlig er det jeg som burde bli døpt av deg.” ");
INSERT INTO norlb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Men Jesus svarte: ”Gjør det i alle fall, for vi må gjøre alt slik Gud vil ha det.” Da døpte Johannes ham. ");
INSERT INTO norlb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Da Jesus hadde blitt døpt, steg han straks opp av vannet. Himmelen åpnet seg og han så Guds Ånd komme ned som en due og stanset over ham. ");
INSERT INTO norlb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","En stemme fra himmelen sa: ”Dette er min elskede Sønn, han er min glede.” ");
INSERT INTO norlb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jesus ble av Guds Ånd ført ut i ødemarken for at djevelen skulle friste ham. ");
INSERT INTO norlb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","I 40 dager og 40 netter spiste han ingenting, og han ble til slutt sulten. ");
INSERT INTO norlb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Da kom djevelen til ham og sa: ”Lag brød av disse steinene, dersom du virkelig er Guds sønn!” ");
INSERT INTO norlb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Men Jesus sa til ham: ”Nei! Det står i Skriften: ’Menneskene lever ikke av brød alene, men av alle de ordene som er fra Gud.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Litt etter tok djevelen ham med til Guds by, Jerusalem, og stilte ham øverst oppe på tempelmuren. ");
INSERT INTO norlb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Han sa: ”Hopp ned, dersom du virkelig er Guds sønn! Det står i Skriften: ’Gud skal befale sine engler om å beskytte deg. De skal bære deg på hendene sine, så du ikke skader deg mot noen stein.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Men Jesus svarte ham: ”Det står også i Skriften: ’Du skal ikke sette Herren, din Gud, på prøve.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Etter dette tok djevelen ham med seg opp til toppen av et høyt fjell og viste ham all verdens land og herlighet. ");
INSERT INTO norlb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","”Alt dette skal jeg gi deg”, sa han, ”om du bare faller ned og tilber meg.” ");
INSERT INTO norlb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","”Forsvinn, Satan”, svarte Jesus. ”Det står i Skriften: ’Det er Herren, din Gud, du skal tilbe, og bare han skal du tjene.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Da lot djevelen ham være, og engler kom for å tjene Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Da Jesus fikk høre at Johannes hadde blitt kastet i fengsel, dro han fra Judea og vendte tilbake til Galilea. Han slo seg ikke ned i hjembyen sin Nasaret, men flyttet til Kapernaum ved Genesaretsjøen, nær området der de to stammene Sebulon og Naftali bodde. ");
INSERT INTO norlb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Gjennom dette ble det til virkelighet som Gud hadde forutsagt hos profeten Jesaja: ");
INSERT INTO norlb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","”Sebulons land og Naftalis land ute ved sjøen, området bortenfor elven Jordan, øvre Galilea med deres mange forskjellige folk, ");
INSERT INTO norlb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","disse folkene som bodde i mørke fikk se et stort lys. De levde i dødens land, men et strålende lys gikk opp over dem.” ");
INSERT INTO norlb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Fra og med nå av begynte Jesus å tale til folket og sa: ”Forlat syndens vei og vend om til Gud, for han har kommet for å frelse menneskene og gjøre dem til sitt eget folk!” ");
INSERT INTO norlb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","En dag da han gikk langs Genesaretsjøen, fikk han se to brødre: Simon, som ble kalt Peter, og Andreas. De holdt på å kaste not i sjøen, for de var fiskere. ");
INSERT INTO norlb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus ropte til dem: ”Kom og bli disiplene mine, så skal jeg vise dere hvordan dere fisker mennesker i stedet!” ");
INSERT INTO norlb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Straks lot de fiskeutstyret ligge og fulgte ham. ");
INSERT INTO norlb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mens han gikk videre, fikk han se to andre brødre, Jakob og Johannes, sitte i en båt sammen med faren sin, Sebedeus, og gjøre i stand fiskeutstyret. Han ropte på dem også. ");
INSERT INTO norlb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Straks forlot de båten og faren og fulgte ham. ");
INSERT INTO norlb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus gikk omkring i hele Galilea og underviste i synagogene. Hvor han enn kom, fortalte han det glade budskapet om at Gud vil frelse menneskene og gjøre dem til sitt eget folk. Han helbredet alle slags sykdommer og plager hos folket. ");
INSERT INTO norlb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ryktet om miraklene hans spredde seg langt utenfor Galileas grenser. Snart kom det syke mennesker også fra Syria for å bli helbredet. Uansett hvilken sykdom eller lidelse de var rammet av om de var besatt av onde ånder led av krampeanfall eller var lamme, så helbredet han alle. ");
INSERT INTO norlb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Store folkemasser fulgte etter Jesus. Det kom folk fra Galilea, Dekapolis, Jerusalem og hele Judea, og fra andre siden av Jordan. ");
INSERT INTO norlb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","En dag da Jesus så alle folkene som samlet seg, gikk han opp på et fjell sammen med disiplene. ");
INSERT INTO norlb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Der satte han seg og begynte å undervise dem. Han sa: ");
INSERT INTO norlb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","”Lykkelige er de som innser at de trenger Gud, for de skal få være Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Lykkelige er de som sørger, for de skal bli trøstet. ");
INSERT INTO norlb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lykkelige er de ydmyke, for hele verden tilhører dem. ");
INSERT INTO norlb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Lykkelige er de som sulter og tørster etter å gjøre Guds vilje, for de skal bli mettet. ");
INSERT INTO norlb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Lykkelige er de som viser medfølelse, for de skal få medfølelse fra Gud. ");
INSERT INTO norlb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Lykkelige er de som av hele sitt hjerte leter etter Gud, for de skal få se ham. ");
INSERT INTO norlb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Lykkelige er de som aktivt strever etter fred, for de skal bli kalt Guds barn. ");
INSERT INTO norlb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Lykkelige er de som blir forfulgt fordi de gjør Guds vilje, for de skal være Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ja, dere er lykkelige når de håner og forfølger dere og lyver om dere fordi dere er disiplene mine. ");
INSERT INTO norlb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Juble og vær glade, for Gud skal lønne dere. Husk på at profetene som før i tiden bar fram Guds budskap, også ble forfulgt. ");
INSERT INTO norlb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Dere er det saltet som bevarer verden fra forråtnelse. Men hva nytte er det i saltet dersom det har mistet kraften sin? Kan det på nytt bli salt igjen? Nei, det duger ikke til noe annet enn å bli kastet ut og trampet ned av menneskene. ");
INSERT INTO norlb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Dere er det lyset som lyser opp verden. Dere ligner en by som ligger høyt oppe på et fjell. En by på fjellet er synlig for alle. ");
INSERT INTO norlb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Når noen tenner en lampe, vil de ikke dekke over den. Tvert imot så setter de den på et høyt sted slik at den lyser for alle i huset. ");
INSERT INTO norlb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","På samme måten skal lyset fra dere skinne for menneskene, slik at de klart og tydelig kan se det gode dere gjør og hylle Far deres i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tro ikke at jeg har kommet for å oppheve det Gud har sagt i Moseloven og profetene. Nei, jeg har kommet for å oppfylle det og gjøre det til virkelighet. ");
INSERT INTO norlb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jeg forsikrer dere at hvert ord i loven skal gjelde så lenge himmelen og jorden består og fram til alt det Gud har forutsagt, har skjedd. ");
INSERT INTO norlb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Den som bryter det minste lille budet i loven, og lærer andre å gjøre det samme, han skal være minst blant de som får være Guds eget folk. Men den som holder loven og lærer andre å gjøre det samme, han skal være stor blant Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Men jeg advarer dere, om dere ikke lykkes i å følge Guds vilje bedre en det de skriftlærde og fariseerne gjør, da kommer dere slett ikke til å få tilhøre Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Dere har hørt at det står i Moseloven: ’Du skal ikke drepe, og den som dreper noen, skal bli dømt.’ ");
INSERT INTO norlb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Men jeg sier: Det rekker med at du blir sint på noen, da skal du bli dømt. Kaller du en person for idiot, skal du bli stilt for domstolen, og forbanner du noen, venter ilden i helvete på deg. ");
INSERT INTO norlb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Derfor, om du står for alteret i templet for å bære fram et offer til Gud og plutselig kommer til å tenke på at noen har noe imot deg, ");
INSERT INTO norlb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","skal du legge ned offeret ditt foran alteret og gå for å gjøre opp med denne personen. Kom etterpå og bær fram offeret ditt til Gud. ");
INSERT INTO norlb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Dersom noen anklager deg for noe, vær da rask til å inngå forlik med motparten din allerede før dere har nådd fram til domstolen. Ellers overgir han deg kanskje til dommeren, som så igjen lar vakten ta hånd om deg og setter deg i fengsel. ");
INSERT INTO norlb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Og jeg forsikrer deg at du må bli der til du har betalt til siste øre. ");
INSERT INTO norlb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Dere har hørt at det står i Moseloven: ’Du skal ikke være utro i ekteskapet.’ ");
INSERT INTO norlb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Men jeg sier: Den som ser på en kvinne med begjær i blikket har allerede vært utro med henne i sitt hjerte. ");
INSERT INTO norlb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Om ditt høyre øye får deg til å synde, riv det da ut og kast det fra deg. Det er bedre at en del av kroppen din er ødelagt enn at hele deg blir kastet i helvete. ");
INSERT INTO norlb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Om hånden din får deg til å synde, hugg den da av og kast den bort, ja, selv om det skulle ramme din høyre hånd! Det er bedre at en del av kroppen din er ødelagt enn at hele deg kommer i helvete. ");
INSERT INTO norlb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Det står i Moseloven: ’Om noen vil skille seg fra kona si, da kan han gjøre det ved å gi henne en attest som bevis på skilsmissen.’ ");
INSERT INTO norlb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jeg sier: Den som skiller seg fra kona si, uten at hun har vært utro, han blir årsak til at hun virkelig kan være utro. Den som gifter seg med en fraskilt kvinne, gjør at hun er utro. ");
INSERT INTO norlb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Dere har også hørt at det står i Moseloven: ’Du skal ikke bryte en ed som du har sverget, men du skal holde alt som du har lovet innfor Gud.’ ");
INSERT INTO norlb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Men jeg sier: Du skal slett ikke sverge noen eder! Om du sier: ’Jeg sverger ved himmelen,’ har du sverget for Gud, for himmelen er Guds trone. ");
INSERT INTO norlb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Om du sier: ’Jeg sverger ved jorden’, har du sverget for Gud, for jorden er skammelen under føttene hans. Og om du sier: ’Jeg sverger ved Jerusalem’, har du sverget for Gud, for Jerusalem er Guds by. ");
INSERT INTO norlb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Si heller ikke: ’Det setter jeg hodet i pant på!’ for du kan ikke gjøre et eneste hårstrå verken hvitt eller svart. ");
INSERT INTO norlb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Si bare: ’Ja, det vil jeg’ eller ’Nei, det vil jeg ikke’. Det rekker. Tanken om å legge mer autoritet i dine ord ved å sverge kommer fra den onde. ");
INSERT INTO norlb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Dere har hørt at det står i Moseloven: ’Dersom et øye blir skadet, må den skyldige betale med sitt eget øye. Og dersom en tann blir skadet, skal han betale med sin egen tann.’ ");
INSERT INTO norlb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Men jeg sier: Møt ikke vold med vold. Slår noen deg på det ene kinnet, vend da også det annet til ham. ");
INSERT INTO norlb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Blir du stilt for domstolen og de tar fra deg skjorta di, gi dem da yterplagget også. ");
INSERT INTO norlb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Befaler noen deg å bære hans reisegods en mil, bær den da to. ");
INSERT INTO norlb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gi til den som ber deg og vend ikke ryggen til den som vil låne av deg. ");
INSERT INTO norlb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Dere har hørt at det står i Moseloven: ’Du skal elske dine medmennesker og hate dine fiender.’ ");
INSERT INTO norlb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Men jeg sier: Elsk fiendene deres! Be for dem som forfølger dere! ");
INSERT INTO norlb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Da viser dere virkelig at dere er barn til deres Far i himmelen. Han lar solen skinne og regnet falle både på onde og gode, både på de som følger hans vilje, og de som ikke gjør det. ");
INSERT INTO norlb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hva er det som er så ekstra med at dere elsker dem som elsker dere? Det gjør jo tollerne også. ");
INSERT INTO norlb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dersom dere hilser vennlig på vennene deres, men ikke på noen andre, hva er det som er så ekstra med det? Det gjør jo også de som ikke kjenner Gud. ");
INSERT INTO norlb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Derfor skal dere være like gode som deres Far i himmelen, han som er fullkommen god.” ");
INSERT INTO norlb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesus fortsatte: ”Når dere gjør det som er godt, se da til at dere ikke gjør det bare for at menneskene skal legge merke til dere. Ellers har dere ingen lønn i vente fra vår Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Når dere gir en gave til en som er i nød, rop det da ikke ut til andre. Gjør ikke som de falske menneskene som bare later som de er lydige mot Gud. De utbasunerer sine gode gjerninger i synagogene og på gatene for å få ros og ære! Jeg forsikrer dere at de allerede har fått sin lønn. ");
INSERT INTO norlb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Nei, om du hjelper noen, da gjør det med diskresjon. Din venstre hånd skal ikke vite hva den høyre gjør. Da kommer din Far i himmelen, som ser alt, til å lønne deg. ");
INSERT INTO norlb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Når dere ber, da skal dere ikke stå og vise dere fram for andre. Vær ikke som falske mennesker som bare later som om dem er lydige mot Gud. De elsker å be offentlig på gatehjørnene og i synagogenededup$1 der alle kan se dem. Jeg forsikrer dere at de allerede har fått sin lønn. ");
INSERT INTO norlb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nei, når du ber, da gå i stedet inn i ditt rom og lukk døren bak deg. La bønnen din være en hemmelighet mellom deg og din Far i himmelen. Han vet alt og kommer til å lønne deg. ");
INSERT INTO norlb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Rams ikke opp den samme bønnen gang på gang, slik de gjør som ikke kjenner Gud. De tror at bønnen har større sjanse på å bli besvart når de bruker mange ord. ");
INSERT INTO norlb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Vær ikke som dem, for deres Far i himmelen vet akkurat hva dere trenger allerede før dere har bedt ham om det! ");
INSERT INTO norlb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Be i stedet på denne måten: Fader vår, du som er i himmelen! La ditt navn holdes hellig. ");
INSERT INTO norlb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","La ditt rike komme. La din ville skje på jorden som i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gi oss i dag vårt daglige brød. ");
INSERT INTO norlb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Forlat oss vår skyld, som vi og forlater våre skyldnere. ");
INSERT INTO norlb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Led oss ikke inn i fristelse, men frels oss fra det onde. For riket er ditt, og makten og æren i evighet. Amen. ");
INSERT INTO norlb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ja, om dere tilgir dem som har gjort galt mot dere, da skal deres Far i himmelen også tilgi dere. ");
INSERT INTO norlb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Men om dere nekter å tilgi andre, da kommer han ikke til å tilgi dere for det dere har gjort. ");
INSERT INTO norlb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Når dere faster, vis dere da ikke fram for andre. Vær ikke som falske mennesker som bare later som om de er lydige mot Gud. De ser dystre og ustelte ut bare for at folk skal legge merke til at de faster. Jeg forsikrer dere at de allerede har fått sin lønn. ");
INSERT INTO norlb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nei, når du faster, skal du vaske deg og stelle håret ditt akkurat som til vanlig. ");
INSERT INTO norlb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","La fasten være en hemmelighet mellom deg og din Far i himmelen. Han vet alt og kommer til å lønne deg. ");
INSERT INTO norlb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Samle dere ikke rikdom her på jorden, der den mister sin verdi og lett kan bli stjålet. ");
INSERT INTO norlb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Samle dere heller skatter i himmelen, der de beholder sin verdi og er sikre for tyver. ");
INSERT INTO norlb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","For når skatten din finnes i himmelen, da kommer også hjertet ditt og tankene dine til å være der. ");
INSERT INTO norlb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Øyet er kroppens lyskilde. Om øye ditt er friskt, da slipper det lyset inn. ");
INSERT INTO norlb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Om øye ditt er blindt, stenger det lyset ute, og da blir det mørkt i hele ditt indre. Om det lyset du tror å ha i deg er blitt mørke, da er mørket i deg virkelig blitt nattsvart! ");
INSERT INTO norlb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ingen kan tjene to herrer samtidig. Enten kommer han til å hate den første og elske den andre, eller å elske den første og hate den andre. Dere må altså velge. Dere kan ikke tjene Gud og elske pengene samtidig. ");
INSERT INTO norlb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Derfor sier jeg: Bekymre dere ikke for hvordan dere skal orke livet. Hvordan dere skal få mat og drikke eller klær å ha på dere. Visst nok finnes det viktigere saker i livet enn mat og drikke og klær? ");
INSERT INTO norlb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Se på fuglene! De bekymrer seg ikke for hva de skal spise. De sår ikke og høster ikke og samler ikke i forråd, men deres Far i himmelen gir dem nok mat likevel. Er ikke dere mye mer verd for ham enn det fuglene er? ");
INSERT INTO norlb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hva tjener det til å bekymre seg? Kan det forlenge livet deres med en eneste time? Naturligvis ikke! ");
INSERT INTO norlb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Og hvorfor er dere bekymret for klærne? Se på liljene på marken. De arbeider ikke og syr ingen klær. ");
INSERT INTO norlb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Likevel forsikrer jeg dere at selv ikke kong Salomo i all sin prakt var så vakkert kledd som dem. ");
INSERT INTO norlb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Om Gud gir så vidunderlige klær til gresset, som står den ene dagen, men i morgen blir kastet på ilden, skulle han ikke da ordne med klær til dere? Stoler dere fortsatt så lite på Gud? ");
INSERT INTO norlb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Bekymre dere altså ikke for hva dere skal spise og drikke, eller for hva dere skal ha på dere. Gjør ikke som folk som ikke kjenner Gud. De jager etter alt dette og bekymrer seg hele tiden. Deres Far i himmelen vet allerede hva dere trenger. ");
INSERT INTO norlb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Han kommer til å gi dere alt dette, dersom dere først og fremst strever etter å gjøre hans vilje, og dermed at han får bestemme over dere. ");
INSERT INTO norlb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bekymre dere altså ikke for dagen i morgen, men løs problemene den dagen de virkelig dukker opp. En avmålt tid for bekymringer rekker vel mer enn nok?” ");
INSERT INTO norlb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesus fortsatte: ”Dere skal ikke dømme andre, for da blir dere ikke selv dømt. ");
INSERT INTO norlb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gud kommer til å behandle dere på samme måte som dere behandler andre. Den målestokken dere bruker når dere dømmer andre, den kommer Gud til å bruke når han dømmer dere. ");
INSERT INTO norlb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hvorfor henger du deg opp i bagatellmessige svakheter hos dine medmennesker, når du ikke erkjenner dine egne feil som er mye større? ");
INSERT INTO norlb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hvorfor sier du til andre: ’Kom hit så skal jeg åpne øynene på deg slik at du ser feilene dine,’ mens du samtidig er blind for egne feil? ");
INSERT INTO norlb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Du falske menneske som bare later som om du er lydig mot Gud! Først må du rette dine egne feil! Etterpå kan du se klart nok til å hjelpe dine medmennesker med sine. ");
INSERT INTO norlb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Gi ikke Guds budskap til folk som ikke vil lyde ham. Det er som å kaste perler for grisene. De kommer til å trampe på budskapet og etterpå vende seg om og angripe dere. ");
INSERT INTO norlb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Be, så skal dere få. Let, så skal dere finne. Bank på, så skal døren bli åpnet for dere. ");
INSERT INTO norlb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","For alle som ber, de får. Alle som leter, de finner. Og for alle som banker på, skal døren bli åpnet. ");
INSERT INTO norlb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","10","Dere som er foreldre, dere gir vel ikke barnet deres en stein når det ber om brød, eller en orm når det ber om en fisk? Naturligvis ikke! ");
INSERT INTO norlb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Om nå dere som er onde og hardhjertet har forstand til å gi gode gaver til barna deres, skulle da ikke deres Far i himmelen gi gode gaver til dem som ber ham om det? ");
INSERT INTO norlb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dere skal være på samme måten mot andre, som dere vil at de skal være mot dere. Dette er den leveregelen Gud har fortalt om i Moseloven og profetene. ");
INSERT INTO norlb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Den som vil bli frelst, må gå inn gjennom den trange porten. Veien til evig straff er bred, og porten inn dit er vid, og mange er det som velger denne lette veien. ");
INSERT INTO norlb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Men porten til livet er trang, og veien dit inn er smal. Derfor er det få som finner den. ");
INSERT INTO norlb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ta dere i vare for den sorten mennesker som sprer falske budskap om Gud. De kommer til dere forkledd som uskyldige sauer, men er i virkeligheten glupske ulver som vil slite dere i filler. ");
INSERT INTO norlb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dere kan kjenne dem igjen på handlingene deres, på samme måten som dere kjenner igjen trærne og buskene på den sorten frukt de bærer. Ingen plukker jo druer på tornebusker eller fiken på tistler. ");
INSERT INTO norlb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Et godt tre bærer god frukt, og et dårlig tre bærer dårlig frukt. ");
INSERT INTO norlb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Et godt tre kan ikke bære dårlig frukt, og et dårlig tre kan ikke bære god frukt. ");
INSERT INTO norlb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hvert tre som ikke bærer god frukt, blir hogget ned og brent opp. ");
INSERT INTO norlb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","På samme måten som et tre blir kjent igjen på frukten, kan dere altså kjenne igjen menneskene på handlingene deres. ");
INSERT INTO norlb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ikke alle som snakker godt om meg, er disiplene mine. Mange kaller meg ’Herre’, men vil likevel ikke få tilhøre Guds eget folk. Det avgjørende spørsmålet er om de er lydige mot min Far i himmelen eller ikke. ");
INSERT INTO norlb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","På den dagen da dommen faller, skal mange si til meg: ’Herre, Herre! Vi har jo båret fram budskapet fra Gud i navnet ditt, drevet ut onde ånder og gjorde mirakler i navnet ditt.’ ");
INSERT INTO norlb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Da skal jeg si dem sannheten: ’Jeg kjenner dere ikke. Forsvinn herfra! Det dere har gjort, det har dere gjort i den onde sin tjeneste.’ ");
INSERT INTO norlb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Den som hører undervisningen min og handler etter den, er klok. Han ligner på en som bygger huset sitt på fjell. ");
INSERT INTO norlb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Selv om det blir skybrudd og oversvømmelse, og stormen blåser med voldsom kraft mot huset, så raser det likevel ikke sammen fordi det er bygget på fast grunn. ");
INSERT INTO norlb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Men den som hører undervisningen min og ikke handler etter den, er en dåre. Han ligner en som bygger huset sitt på løs sand. ");
INSERT INTO norlb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Når regnet kommer og det blir oversvømmelse, og stormen blåser mot huset, da faller det sammen med et stort brak.” ");
INSERT INTO norlb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Da Jesus hadde avsluttet denne talen, var folket forundret over undervisningen hans. ");
INSERT INTO norlb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Han underviste med innsikt og autoritet, og ikke som deres de skriftlærde. ");
INSERT INTO norlb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Da Jesus gikk ned fra fjellet, fulgte mange etter ham. ");
INSERT INTO norlb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Plutselig nærmet en spedalsk seg og falt ned for ham og ba: ”Herre, om du vil, så kan du gjøre meg frisk.” ");
INSERT INTO norlb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus rakte straks ut hånden og rørte ved mannen og sa: ”Det vil jeg. Du er frisk!” I samme øyeblikk var mannen helbredet fra spedalskheten sin. ");
INSERT INTO norlb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus sa til han: ”Fortell ikke dette til noen, men gå til presten for at han kan undersøke deg. Ta også med deg det offer som Moses har bestemt, slik at alle kan forstå at Gud har helbredet deg.” ");
INSERT INTO norlb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Da Jesus hadde gått inn i Kapernaum, kom en romersk offiser bort til ham og ba om hjelp. ”Herre, tjeneren min ligger lam hjemme og har fryktelige plager”, forklarte han. ");
INSERT INTO norlb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","”Skal jeg bli med og helbrede ham?” spurte Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Men offiseren sa: ”Herre, jeg er ikke verd at du går inn i huset mitt. Si bare et ord, så blir tjeneren min frisk. ");
INSERT INTO norlb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jeg vet det, for jeg har selv overordnede offiserer som gir meg befaling, og jeg har andre soldater som står under meg. Dersom jeg sier til en av dem: ’Gå’, så går han, og til en annen: ’Kom’, så kommer han, og dersom jeg sier til tjenerne mine: ’Gjør dette eller hint’, så gjør de det.” ");
INSERT INTO norlb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus ble svært forbauset og vendte seg mot dem som fulgte han og sa: ”Jeg forsikrer dere at jeg har ikke sett en så sterk tro hos noen blant Israels folk. ");
INSERT INTO norlb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jeg sier dere at mange, lik denne romerske offiseren, skal komme fra jordens tallrike land og bli innbudt sammen med Abraham, Isak og Jakob til festen i Guds nye verden. ");
INSERT INTO norlb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Men mange israelitter, som burde ha vært med blant dem som får være Guds eget folk, skal bli kastet ut i mørket. Der skal de gråte av angst og fortvilelse.” ");
INSERT INTO norlb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus sa til den romerske offiseren: ”Gå hjem. Det skal bli slik som du trodde!” Og i samme øyeblikket ble tjeneren frisk. ");
INSERT INTO norlb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Noe seinere kom Jesus hjem til Peter og fikk se at svigermoren hans lå til sengs med høy feber. ");
INSERT INTO norlb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Han rørte ved hånden hennes, og straks forsvant feberen. Hun sto opp og begynte å lage mat til dem. ");
INSERT INTO norlb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Samme kvelden førte innbyggerne mange besatte mennesker til Jesus. Han drev ut de onde åndene ved bare å snakke til dem og helbredet alle som var syke. ");
INSERT INTO norlb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gjennom disse miraklene ble det som Gud hadde forutsagt ved profeten Jesaja, til virkelighet: ”Han la våre plager på seg selv og tok bort våre sykdommer.” ");
INSERT INTO norlb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Det samlet seg mer og mer folk, og Jesus ba disiplene om å gjøre seg klar til å reise over sjøen til den andre siden. ");
INSERT INTO norlb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","En av de skriftlærde kom bort til ham og sa: ”Mester, jeg vil også følge deg, samme hvor du enn går!” ");
INSERT INTO norlb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus svarte: ”Du må tenke på at revene har hi og fuglene har reir, men jeg, Menneskesønnen, har ingen steder der jeg kan hvile ut.” ");
INSERT INTO norlb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","En annen av disiplene sa: ”Herre, jeg vil gjerne følge deg, men la meg først gå hjem og begrave far min.” ");
INSERT INTO norlb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Da svarte Jesus ham: ”Følg du meg og la de som er åndelig døde begrave sine døde.” ");
INSERT INTO norlb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Senere steg Jesus ombord i en båt og seilte over sjøen sammen med disiplene. ");
INSERT INTO norlb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Plutselig blåste det opp en fryktelig storm med høye bølger som slo inn over båten. Men Jesus sov. ");
INSERT INTO norlb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Disiplene gikk fram og vekket ham og begynte å rope: ”Herre, hjelp oss! Vi synker!” ");
INSERT INTO norlb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Men Jesus svarte: ”Hvorfor er dere redde? Har dere så vanskelig for å tro?” Litt etter reiste han seg opp og snakket med autoritet til vinden og sjøen, og alt ble rolig. ");
INSERT INTO norlb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Disiplene ble helt forundret. ”Hvem er han”, sa de til hverandre, ”etter som til og med vinden og sjøen er lydige mot ham?” ");
INSERT INTO norlb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Da Jesus hadde kommet over på den andre siden av sjøen, til området der gadarenerne bodde, kom to menn imot ham som var besatt av onde ånder. De søkte ly blant gravene og var så voldsomme i sin atferd at ingen kunne ta seg fram den veien. ");
INSERT INTO norlb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","De ropte til Jesus: ”Gå bort fra oss i fred, du Guds sønn! Har du kommet for å pine oss før tiden?” ");
INSERT INTO norlb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Der dette skjedde, gikk en stor flokk griser og rotet i jorden etter røtter. ");
INSERT INTO norlb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Åndene tigget og ba: ”Dersom du driver oss ut, da send oss i det minste inn i griseflokken.” ");
INSERT INTO norlb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus sa: ”Som dere vil, kom dere av sted!” Straks dro de onde åndene fra mennene og for inn i grisene, og hele flokken rutsjet utfor fjellskrenten og druknet i sjøen. ");
INSERT INTO norlb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Røkterne som passet på grisene flyktet. Da de kom til den nærmeste byen, fortalte de alt sammen, også det som hadde skjedd med de besatte. ");
INSERT INTO norlb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Alle i byen gikk ut for å treffe Jesus, og da de kom fram til ham ba de at han måtte forlate området deres. ");
INSERT INTO norlb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Senere steg Jesus ombord i en båt og seilte over til Kapernaum, byen der han bodde. ");
INSERT INTO norlb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Vel framme kom noen til ham med en lam som lå på en båre. Da Jesus så hvor stor tro de hadde, sa han til den lamme: ”Vær ikke lei deg, sønnen min. Jeg har tilgitt syndene dine!” ");
INSERT INTO norlb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Noen av de skriftlærde mumlet da for seg selv: ”Han spotter og gjør seg selv til Gud!” ");
INSERT INTO norlb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Men Jesus visste hva de tenkte og spurte dem: ”Hvorfor tenker dere onde tanker? ");
INSERT INTO norlb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Er det ikke like umulig for et menneske å si til den lamme: ’Reis deg opp og gå’ som å si: ’Jeg tilgir deg syndene dine’?” ");
INSERT INTO norlb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Så vendte han seg til den lamme og sa: ”For å bevise at jeg, Menneskesønnen, har makt til å tilgi synder her på jorden, sier jeg til deg: ’Reis deg opp, ta båren din og gå hjem!’ ” ");
INSERT INTO norlb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Og mannen reiste seg og gikk hjem. ");
INSERT INTO norlb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Da folket så det som skjedde, ble de helt forskrekket. De hyllet Gud for at han hadde gitt en slik makt til mennesker. ");
INSERT INTO norlb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Da Jesus gikk videre, fikk han se en toller som het Matteus, sitte utenfor tollboden sin. ”Kom og bli min disippel”, sa Jesus til ham. Matteus reiste seg og fulgte Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Senere da Jesus og disiplene spiste sammen i hjemmet til Matteus, var også mange av tollerens gamle kolleger blant gjestene, og en del andre ukjente folk. ");
INSERT INTO norlb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseerne var opprørt. ”Hvordan kan mesteren deres synke så dypt at han spiser sammen med tollere og syndere?” spurte de disiplene. Jesus hørte det og sa: ");
INSERT INTO norlb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","”Det er ikke de friske som trenger lege, men de syke. ");
INSERT INTO norlb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gå bort og forsøk å forstå det Gud mener når han sier: ’Jeg vil heller at dere viser hverandre kjærlighet, enn at dere ofrer til meg.’ Min oppgave her på jorden er å føre syndere tilbake til Gud, ikke å ta hånd om dem som allerede følger hans vilje.” ");
INSERT INTO norlb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","En dag kom disiplene til døperen Johannes og spurte Jesus: ”Hvorfor faster ikke disiplene dine, slik vi og fariseerne gjør?” ");
INSERT INTO norlb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus svarte: ”Bryllupsgjestene kan vel ikke sørge og gå sultne uten mat mens brudgommen ennå er hos dem? Men en dag skal han bli tatt fra dem, og da kommer de til å faste. ");
INSERT INTO norlb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Det finnes en tid og plass for alt. Ingen lapper for eksempel et gammelt klesplagg med et stykke nytt tøy som aldri har blitt vasket, for da krymper det nye tøyet og river i stykker plagget, slik at hullet blir enda større. ");
INSERT INTO norlb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ingen øser heller ny vin i gamle skinnsekker, for når vinen gjærer, blir sekkene sprengt og ødelagt, og vinen renner ut. Nei, ny vin blir lagret i nye sekker, for da blir både vinen og sekkene bevart.” ");
INSERT INTO norlb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mens Jesus sa dette, kom en mann som var leder for synagogen og falt ned for han. ”Datteren min er nettopp død”, sa han. ”Kom og legg hendene på henne, så får hun livet tilbake.” ");
INSERT INTO norlb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Da reiste Jesus seg og fulgte med mannen, sammen med disiplene. Men mens de var på vei til hjemmet hans, kom ");
INSERT INTO norlb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","en kvinne, som i tolv års tid hadde lidd av fryktelige blødninger. Hun nærmet seg Jesus bakfra og rørte ved dusken på kappen hans. ");
INSERT INTO norlb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Hun tenkte: ”Om jeg bare får røre ved klærne hans kommer jeg til å bli frisk.” ");
INSERT INTO norlb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Da vendte Jesus seg rundt og fikk se henne: ”Min datter”, sa han, ”vær ikke urolig! Din tro har hjulpet deg.” Og fra dette øyeblikket av var kvinnen frisk. ");
INSERT INTO norlb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Da Jesus kom fram til huset der lederen for synagogen bodde og hørte sørgemusikken og fikk se alle menneskene som gråt høyt og jamret seg, ");
INSERT INTO norlb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","sa han: ”Gå ut herfra. Jenta er ikke død. Hun sover bare.” Da begynte de å hånle mot han. ");
INSERT INTO norlb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Men da folket hadde blitt jaget ut av huset, gikk Jesus inn i rommet der jenta lå, og tok henne i hånden. Straks reiste hun seg opp og var helt frisk. ");
INSERT INTO norlb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ryktet om det fantastiske som hadde skjedd, spredde seg som en løpeild i hele området. ");
INSERT INTO norlb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Da Jesus dro fra hjemmet til jenta fulgte to blinde menn etter han og ropte: ”Jesus, du som skal arve kong Davids trone, ha medfølelse med oss!” ");
INSERT INTO norlb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","De gikk etter ham helt inn i huset der han bodde. Og Jesus spurte dem: ”Tror dere at jeg kan helbrede dere?” ”Ja, Herre”, svarte de. ”Det gjør vi.” ");
INSERT INTO norlb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Da rørte han ved øynene deres og sa: ”Etter som dere tror, skal det også bli slik.” ");
INSERT INTO norlb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Plutselig kunne de se! Jesus advarte dem strengt mot å fortelle dette til noen. ");
INSERT INTO norlb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Til tross for det han sa, var snart ryktet om han ute over hele distriktet. ");
INSERT INTO norlb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Da de to mennene var på vei bort, kom noen til Jesus med en besatt som ikke kunne snakke. ");
INSERT INTO norlb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesus drev ut den onde ånden, og straks kunne mannen snakke. Folket ble helt forundret og sa: ”Aldri før har noe slikt skjedd i Israel!” ");
INSERT INTO norlb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Da fariseerne hørte dette, sa de: ”Han driver ut de onde åndene med hjelp av Satan, som er høvding for de onde åndene!” ");
INSERT INTO norlb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus gikk omkring til alle småplassene og byene og underviste i synagogene. Hvor han enn kom, fortalte han det glade budskapet om at Gud vil frelse menneskene og gjøre dem til sitt eget folk. Han helbredet alle slags sykdommer og plager. ");
INSERT INTO norlb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Da han la merke til alt folket, fikk han medfølelse med dem, De hadde store problemer og visste ikke hvor de kunne få hjelp. De var som sauer uten gjeter. ");
INSERT INTO norlb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","”Høsten er stor, men arbeiderne er få”, sa han til disiplene. ");
INSERT INTO norlb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","”Be derfor den som har ansvaret for innhøstingen, at han sender ut flere arbeidere på feltet.” ");
INSERT INTO norlb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus kalte nå til seg sine tolv nærmeste disipler og ga dem makt til å drive ut onde ånder og helbrede alle slags sykdommer og plager. ");
INSERT INTO norlb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Her er navnene på de tolv disiplene: Simon, som ble kalt Peter, hans bror Andreas, og sønnene til Sebedeus som var Jakob og Johannes, ");
INSERT INTO norlb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartolomeus, Tomas, tolleren Matteus, og sønnen til Alfeus som het Jakob, Taddeus, ");
INSERT INTO norlb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, ”den ivrige” og Judas Iskariot, han som seinere forrådt Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Disse tolv sendte Jesus ut, og han ga befaling til dem og sa: ”Gå ikke til andre folk eller til noen av samaritanene sine byer, ");
INSERT INTO norlb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","men bare til Israels folk som er Guds tapte sauer. ");
INSERT INTO norlb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gå og forkynn, for Gud har kommet for å frelse menneskene og gjøre dem til sitt eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Helbred syke, vekk opp døde, gjør spedalske friske og driv ut onde ånder. Gjør alt uten betaling, for dere har selv fått disse evnene av meg helt gratis. ");
INSERT INTO norlb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ta ingen penger med dere. ");
INSERT INTO norlb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pakk ingen veske for reisen. Ta ikke med ekstra klær eller sko og heller ikke noen vandringsstav. Dere kommer til å få alt det dere trenger, for arbeideren er verd maten sin. ");
INSERT INTO norlb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hver gang dere kommer til et sted eller en by, let da opp noen som tar imot dere og som vil lytte til budskap dere har å fortelle. Stans i huset hans til dere vil fortsette reisen til neste by. ");
INSERT INTO norlb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ønsk familien fred fra Gud når dere stiger inn i huset. ");
INSERT INTO norlb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dersom de er verd å få del i freden hans, vil han gi rikelig av den. Men om de ikke er verd til å få del i freden hans, vil dere beholde den selv. ");
INSERT INTO norlb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tar de ikke imot dere i en by eller i et hjem, gå da bare derfra. Rist støvet fra byen av føttene deres og vær ikke mer bekymret for disse menneskene. ");
INSERT INTO norlb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jeg forsikrer dere at det skal bli lettere på dommens dag for byene Sodoma og Gomorra enn for de stedene som ikke hilser dere velkommen.” ");
INSERT INTO norlb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesus fortsatte: ”Jeg sender dere som sauer inn blant ulver. Vær derfor listige som slanger og troskyldige som duer. ");
INSERT INTO norlb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pass dere for menneskene! Dere kommer til å bli arrestert og trukket for domstolene og bli pisket i synagogene. ");
INSERT INTO norlb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dere skal for min skyld stå anklaget for konger og makthavere og få anledning til å fortelle dem om det dere har hørt og sett. Ja, dere skal fortelle om meg til fremmede folk. ");
INSERT INTO norlb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Når dere blir stilt for domstolen, skal dere ikke behøve å bekymre dere for det dere skal si, for dere skal få de rette ordene i det øyeblikk dere trenger det mest. ");
INSERT INTO norlb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Det er ikke dere som skal snakke, men deres Far i himmelen skal la sin Ånd snakke gjennom dere. ");
INSERT INTO norlb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Brødre skal forråde hverandre og drepe hverandre, og foreldre skal forråde sine egne barn. Barn skal gjøre opprør mot foreldrene sine og ta livet av dem. ");
INSERT INTO norlb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Alle skal hate dere fordi dere tilhører meg. Men den som holder ut til slutten, skal bli frelst. ");
INSERT INTO norlb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Når dere blir forfulgt i en by, skal dere rømme til en annen. Jeg forsikrer dere at jeg, Menneskesønnen, kommer tilbake før dere har rukket over alle byene i Israel! ");
INSERT INTO norlb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Disippelen står ikke over sin mester, og en tjener står ikke over sin herre. ");
INSERT INTO norlb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Disippelen må akseptere at det går med ham som det gikk med mesteren hans, og tjeneren må akseptere at det går med ham som det gikk med herren hans. Om nå jeg, herren i huset, har blitt kalt Satan, da kommer de naturligvis til å si det samme om dere, dere som er medlemmer i min husholdning! ");
INSERT INTO norlb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Men vær ikke redd for de som truer dere, for en dag skal sannheten komme fram. Da skal det som er skjult bli kjent for alle. ");
INSERT INTO norlb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Det jeg sier til dere i mørket, skal dere rope ut i dagslys. Og det jeg hvisker dere i ørene, skal dere rope ut fra taket på husene! ");
INSERT INTO norlb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Vær ikke redde for de som vil drepe dere, men ikke har makt til å gjøre noe mer. Det finnes bare en som har en slik makt at dere trenger å være redd for ham, og det er Gud. Han kan både drepe og siden straffe i helvete. ");
INSERT INTO norlb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ikke en eneste spurv, uansett hvor lite den enn er verd, faller død til jorden uten at deres Far i himmelen vet om det. ");
INSERT INTO norlb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","På hodene deres er til og med hårstråene tellet. ");
INSERT INTO norlb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Vær altså ikke redde! Dere er mer verd for Gud enn alle verdens spurver til sammen. ");
INSERT INTO norlb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Dersom noen åpent bekjenner at han tilhører meg, da skal jeg bekjenne ham for min Far i himmelen at han tilhører meg. ");
INSERT INTO norlb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Men den som åpent fornekter meg, han skal jeg fornekte for min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tro ikke at jeg har kommet for å skape fred på jorden! Nei, snarere tvert imot. ");
INSERT INTO norlb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Jeg kommer til å bli årsak til konflikter, slik at en sønn står imot faren sin, en datter står imot moren sin, og en svigerdatter står imot svigermoren sin. ");
INSERT INTO norlb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","De verste fiendene for mange blir til å finne i deres egne hjem! ");
INSERT INTO norlb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Men dersom dere elsker foreldrene deres høyere enn meg, er dere ikke verdige å tilhøre meg. Dersom dere elsker barna deres høyere enn meg, da er dere ikke verdige å tilhøre meg. ");
INSERT INTO norlb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Den som ikke tar korset opp og følger mitt eksempel med å være beredt til å dø, han kan ikke tilhøre meg. ");
INSERT INTO norlb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ja, den som klamrer seg fast til livet, vil til slutt miste det, men den som mister livet sitt for min skyld, vil redde det. ");
INSERT INTO norlb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Den som tar imot dere, tar imot meg, og den som tar imot meg, tar imot Gud, etter som Gud har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Om dere tar imot en profet fordi han bringer Guds budskap, da kommer dere til å få samme lønnen som profeten. Og om dere tar imot en person som lever etter Guds vilje, fordi han lever for Gud, da skal dere få samme belønning som disse gudfryktige menneskene. ");
INSERT INTO norlb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ja, jeg forsikrer dere at den som gir, om så bare et glass friskt vann til den minste av disiplene mine, fordi denne personen tilhører meg, han skal få lønn for det.” ");
INSERT INTO norlb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Da Jesus hadde gitt sine tolv disipler disse forskriftene, gikk han videre for å undervise og spre budskapet sitt til byene i Galilea. ");
INSERT INTO norlb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Døperen Johannes, som nettopp hadde blitt satt i fengsel, fikk høre om alle miraklene som Jesus Kristus gjorde. Derfor sendte han av sted noen av disiplene sine for å spørre ham: ");
INSERT INTO norlb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","”Er du virkelig den som Gud har lovet å sende oss, eller skal vi vente på en annen?” ");
INSERT INTO norlb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus svarte dem: ”Gå tilbake til Johannes og fortell ham om det dere har hørt og sett: ");
INSERT INTO norlb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","At blinde begynner å se, lamme går, spedalske blir friske, døve hører, døde får liv igjen, og de fattige får høre det glade budskapet. ");
INSERT INTO norlb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Si også til ham: ’Lykkelig er den som ikke tviler på meg.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Da disiplene til Johannes hadde gått, begynte Jesus å tale til folket om Johannes. Han sa: ”Når dere gikk ut til han i ødemarken, hva var det dere ville se? Ville dere se en svak person, lik et gresstrå som svaier hit og dit i vinden? ");
INSERT INTO norlb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Selvfølgelig ikke! Ville dere se en person kledd i vakre klær? Nei, for da hadde det vært bedre om dere hadde gått til et kongelig palass. ");
INSERT INTO norlb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ville dere kanskje se en profet som bar fram Guds budskap? Ja, jeg sier dere at Johannes er mer enn en profet. ");
INSERT INTO norlb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Han er den som Gud forteller om i Skriften når han sier: ’Lytt! Jeg sender min budbærer foran deg, og han skal forberede veien for deg.’ ");
INSERT INTO norlb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jeg forsikrer dere at døperen Johannes har betydd mer enn noe annet menneske som har stått fram offentlig. Likevel kommer den minste blant dem som får være Guds eget folk, til å bety mer enn det Johannes gjorde her på jorden. ");
INSERT INTO norlb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Helt fra den dagen da døperen Johannes begynte å tale til folket og fram til i dag, har Gud med kraft begynt å regjere blant menneskene, selv om det også finnes de som vil få det til å skje med vold. ");
INSERT INTO norlb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","At Gud skulle regjere på jorden, var blitt forutsagt av ham i Moseloven og ved profetene før Johannes begynte oppgaven sin. ");
INSERT INTO norlb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Enten dere tror det eller ikke, så er likevel Johannes den som Gud snakket om da han sa at Elia skulle komme. ");
INSERT INTO norlb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Lytt nøye og forsøk å forstå! ");
INSERT INTO norlb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hva skal jeg si om denne slekten som ikke vil tro? De er som barn som leker på torget og roper til de andre barna: ");
INSERT INTO norlb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","’Vi spilte bryllupsmelodier for dere, men dere ville ikke danse. Vi spilte sørgemusikk for dere, men dere ville ikke gråte.’ ");
INSERT INTO norlb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Akkurat slik reagerer de når det gjelder døperen Johannes og meg. Johannes drikker ikke vin og går ofte uten mat, og da sier de: ’Han er besatt av en ond Ånd.’ ");
INSERT INTO norlb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Men jeg, Menneskesønnen, spiser og drikker, og da beskylder de meg for å fråtse i mat, drikke og leve herrens glade dager sammen med de verste syndere! Men til slutt kommer endelig Gud i sin visdom til å få rett, når de ser resultatet av visdommen hans.” ");
INSERT INTO norlb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesus begynte å anklage de som bodde i byene der han hadde gjort de fleste miraklene sine, etter som de ikke hadde vendt om til Gud. Han sa: ");
INSERT INTO norlb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","”Hvor fryktelig kommer det ikke til å bli for dere som bor i Korasin og Betsaida! For om de miraklene jeg gjorde hos dere, hadde blitt gjort i Tyrus og Sidon, da hadde innbyggerne der angret syndene sine og vendt om til Gud for lenge siden. ");
INSERT INTO norlb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jeg forsikrer dere at på dommens dag skal både Tyrus og Sidon få en mildere straff enn dere! ");
INSERT INTO norlb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Og dere, innbyggerne i Kapernaum, tror dere at dere skal bli opphøyet til himmelen? Nei, ned til helvete skal dere bli styrtet. For om de fantastiske miraklene som jeg gjorde hos dere, hadde blitt utført i Sodoma, da hadde byen eksistert like til denne dagen. ");
INSERT INTO norlb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jeg kan forsikre dere at Sodoma skal slippe lettere unna på dommens dag enn dere!” ");
INSERT INTO norlb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesus ba denne bønnen: ”Jeg takker deg Far, du som er Herre over himmelen og jorden, for at du skjuler sannheten for de som tror seg å være lærde og kloke, men viser sannheten for dem som er ydmyke som et barn. ");
INSERT INTO norlb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ja, Far, slik har du bestemt det.” ");
INSERT INTO norlb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesus fortsatte: ”Min Far i himmelen har overlatt alt til meg. Ingen kjenner Sønnen, uten Far i himmelen, og ingen kjenner Far i himmelen, uten Sønnen og de som Sønnen vil vise han for. ");
INSERT INTO norlb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kom til meg alle dere som er trette og kjemper med problemer og tunge byrder, så skal jeg gi dere hvile. ");
INSERT INTO norlb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Gå inn på mine vilkår og la meg få undervise dere! Jeg er mild og ydmyk. Hos meg finner dere ro for sjelene deres. Jeg legger ingen tunge byrder på dere.” ");
INSERT INTO norlb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","På en hviledag gikk Jesus og disiplene langs noen kornåkrer. Disiplene var sultne og begynte å plukke aks for å spise. ");
INSERT INTO norlb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Noen fariseere fikk se det og protesterte: ”Se hva de gjør! Det er jo forbudt å høste på hviledagen i følge Moseloven.” ");
INSERT INTO norlb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus sa til dem: ”Har dere aldri lest om det kong David gjorde da han og mennene som fulgte han, ble sultne? ");
INSERT INTO norlb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Han gikk inn i Guds hus, og både han og de som var med ham spiste av de spesielle brødene som bare prestene har lov til å spise. De brøt også loven. ");
INSERT INTO norlb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Har dere heller ikke lest i loven at prestene som gjør tjeneste i templet, får arbeide på hviledagen? ");
INSERT INTO norlb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Jeg kan forsikre dere at her finnes en som er større enn templet! ");
INSERT INTO norlb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dersom dere forsto det som menes med ordene: ’Jeg vil heller at dere viser hverandre kjærlighet, enn at dere ofrer til meg’, da ville dere ikke dømme dem som er uskyldige. ");
INSERT INTO norlb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","For jeg, Menneskesønnen, har rett til å avgjøre hva som er tillatt på hviledagen.” ");
INSERT INTO norlb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Litt etter gikk Jesus videre og kom inn i synagogen deres. ");
INSERT INTO norlb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Der fikk han se en mann som hadde en handikappet hånd. Fariseerne spurte ham da: ”Tillater Moseloven at noen kan bli helbredet på hviledagen?” De håpet naturligvis at han skulle svare ”ja”, for da kunne de få noe å anklage ham for. ");
INSERT INTO norlb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Han svarte: ”Om noen av dere har en sau og den faller i en grøft på hviledagen, griper han ikke da inn og drar opp sauen samme dagen? Selvfølgelig gjør han det! ");
INSERT INTO norlb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tenk på hvor mye mer verd et menneske er, enn en sau! Det er altså tillatt å gjøre godt på hviledagen.” ");
INSERT INTO norlb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Så sa han til mannen: ”Rekk fram hånden din.” Da mannen gjorde det, ble hånden frisk, og like sterk som den andre! ");
INSERT INTO norlb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseerne gikk ut og begynte å legge opp planer om hvordan de kunne få Jesus arrestert og drept. ");
INSERT INTO norlb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Da Jesus fikk greie på dette, dro han bort fra stedet der. Mange mennesker fulgte etter ham, og han helbredet alle de som var syke blant dem. ");
INSERT INTO norlb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","For ikke å vekke mistanker om hvem han var, forbød han dem strengt å fortelle om det som skjedde. ");
INSERT INTO norlb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Gjennom dette ble det som Gud hadde sagt ved profeten Jesaja, til virkelighet: ");
INSERT INTO norlb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","”Dette er min utvalgte tjener! Han er min elskede, mitt hjertes glede. Jeg skal fylle ham med min Ånd, og han skal bevise for folket hva som er rettferdighet. ");
INSERT INTO norlb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Han griper ikke til vold eller skriker, stemmen hans skal ikke bli hørt på gatene! ");
INSERT INTO norlb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Han slår ikke ned de svake eller slukker ut det håp som er i ferd med å svinne bort. En dag skal han la rettferdigheten seire. ");
INSERT INTO norlb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Han skal være verdens håp.” ");
INSERT INTO norlb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","De førte til han en besatt som var både blind og stum. Jesus helbredet ham, slik at han kunne se og snakke. ");
INSERT INTO norlb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Folk ble helt forundret og sa: ”Kanskje Jesus likevel er den som skal arve kong Davids trone?” ");
INSERT INTO norlb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Da fariseerne fikk høre om miraklet, sa de: ”Han driver sikkert ut de onde åndene med hjelp av Satan, som er høvding for de onde åndene.” ");
INSERT INTO norlb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus, som forsto hva fariseerne tenkte, sa til dem: ”Et rike som kommer i strid med seg selv, går under, og en by eller en familie som er i innbyrdes konflikt med hverandre, vil snart opphøre å eksistere. ");
INSERT INTO norlb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dersom Satan nå driver ut sine egne onde ånder, da strider han jo mot seg selv. Hvordan skal han da kunne fortsette å styre riket sitt? ");
INSERT INTO norlb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dersom jeg driver ut de onde åndene ved hjelp av Satan, hvilken kraft er det da deres egne tilhengere bruker når de driver dem ut? Kanskje dere selv kan svare på anklagene deres! ");
INSERT INTO norlb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dersom det er med Guds Ånd jeg driver ut de onde åndene, har jo Gud kommet for å regjere blant dere. ");
INSERT INTO norlb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","På denne måten er det: Satan er som en sterk mann. Om noen vil gå inn i huset til den sterke mannen og rane ham for det han eier, da må de først binde ham. Etterpå kan de gå inn og rane hjemmet hans. ");
INSERT INTO norlb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Den som ikke er med meg, er imot meg, og den som ikke hjelper meg i mitt arbeid, han motarbeider meg. ");
INSERT INTO norlb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jeg advarer dere: All synd og spott kan bli tilgitt, men spott mot Guds Hellige Ånd blir ikke tilgitt. Det er en utilgivelig synd. ");
INSERT INTO norlb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Den som sier noe mot meg, Menneskesønnen, kan få tilgivelse, men den som sier noe mot Guds Hellige Ånd, kommer aldri til å bli tilgitt, det være seg i denne verden eller i den kommende. ");
INSERT INTO norlb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Et tre blir kjent igjen på frukten sin. Enten er treet godt og bærer god frukt, eller så er det dårlig og bærer dårlig frukt. ");
INSERT INTO norlb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ormeyngel! Hvordan kan dere som er onde, si noe godt? Munnen uttrykker jo det hjertet er fullt av. ");
INSERT INTO norlb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ordene fra et godt menneske viser den godhet som bor i hjertet, mens ordene fra et ondt menneske avslører det onde hjertet. ");
INSERT INTO norlb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jeg sier dere at på dommens dag skal dere få stå til rette for hvert unyttig ord dere har snakket. ");
INSERT INTO norlb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","De ordene dere nå bruker, skal avgjøre skjebnen for dere da. Enten kommer dere til å bli frikjent ved dem, eller så blir dere dømt ved dem.” ");
INSERT INTO norlb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","En dag kom noen av de skriftlærde sammen med fariseerne, og ba om å få se et tegn som skulle bevise at Jesus virkelig var Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus svarte: ”Denne onde og gudløse slekten krever et tegn, det eneste tegnet de skal få se, er det som skjedde med profeten Jona. ");
INSERT INTO norlb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","På samme måten som Jona var i den store fisken i tre døgn, kommer jeg, Menneskesønnen, til å være i jordens indre i tre døgn. ");
INSERT INTO norlb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Innbyggerne i Ninive skal på dommens dag stå opp fra de døde sammen med dere og dømme dere. De ga opp sin onde livsstil og vendte seg om til Gud da de hørte Jona holde fram Guds budskap. Og her finnes en som er større enn Jona, men dere nekter å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Også dronningen fra Syden skal på dommens dag stige fram som vitne mot denne slekten og dømme den. Hun kom jo helt fra et fjernt land for å høre på visdommen til Salomo. Og her finnes en som er større enn Salomo, men dere nekter å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","Denne onde slekten kommer til å bli rammet av samme skjebnen som mange besatte gjør: Når en ond Ånd blir drevet ut av et menneske, flakker den urolig omkring i ørkenen og leter etter et nytt offer. Om den ikke finner noe, sier den: ’Jeg vender tilbake til det menneske der jeg kom fra.’ Og når den gjør det, finner den hjertet tomt, rent og pyntet. Da leter den etter sju ånder til, enda verre enn seg selv. Sammen tar de kontrollen over mennesket, og det får det langt verre enn det hadde før.” ");
INSERT INTO norlb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Mens Jesus fortsatt talte til folket, kom moren og brødre hans dit og ville snakke med ham, men de stanset utenfor huset. Noen sa til han: ”Moren din og brødrene dine står utenfor og vil treffe deg.” ");
INSERT INTO norlb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Men han svarte: ”Moren min og brødrene mine! Hvem er det?” ");
INSERT INTO norlb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Så pekte han på disiplene og sa: ”Dette er moren min og brødrene mine. ");
INSERT INTO norlb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Hver og en som lyder min Far i himmelen, er broren, og søsteren og moren min!” ");
INSERT INTO norlb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Samme dagen gikk Jesus hjemmefra og satte seg nede ved sjøen for å undervise. ");
INSERT INTO norlb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","Snart hadde det samlet seg så mye folk omkring ham, at han var nødt til å stige om bord i en båt og sitte i den for å tale, mens folket sto på stranden. Han underviste dem ved å fortelle mange bilder, som for eksempel dette: ”En bonde gikk ut på åkeren sin for å så. ");
INSERT INTO norlb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mens han sådde, falt noe av såkornet på veien langs åkeren, og fuglene kom og plukket det i seg. ");
INSERT INTO norlb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Noe korn falt der jorden var steinete og jordlaget tynt. Her vokste plantene raskt opp, ");
INSERT INTO norlb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","men i den hete solen visnet de og døde, etter som røttene satt så grunt i bakken. ");
INSERT INTO norlb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Noe korn falt blant tistlene, og mens tistlene vokste opp, kvalte de kornplantene. ");
INSERT INTO norlb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mestedelen av kornet falt i fruktbar jord og ga 30, 60 og til og med 100 ganger så mye avling som bonden hadde sådd. ");
INSERT INTO norlb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lytt nøye og forsøk å forstå!” ");
INSERT INTO norlb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Disiplene kom seinere til Jesus og spurte: ”Hvorfor forteller du slike bilder som dette for folket?” ");
INSERT INTO norlb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Da forklarte han og sa: ”Dere har fått gaven til å forstå undervisningen min om hvordan Gud vil frelse menneskene og gjøre dem til sitt eget folk, men andre har ikke fått den gaven. ");
INSERT INTO norlb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","De som forstår det jeg sier, skal med tiden forstå enda mer. Men de som ikke forstår noe særlig av det, de skal til slutt miste også den lille innsikten de hadde. ");
INSERT INTO norlb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Det er derfor jeg forteller disse bildene, slik at menneskene skal høre og se, men likevel ikke forstå. ");
INSERT INTO norlb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gjennom dette blir det til virkelighet som Gud har forutsagt hos profeten Jesaja: ’Dere skal høre det jeg sier, men likevel ikke forstå. Dere skal se det jeg gjør, men likevel ikke fatte! ");
INSERT INTO norlb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ja, dette folkets hjerter er så hardt og likegyldig at de ikke kan forstå. Deres hørsel er sløvet, slik at de ikke kan høre, og de har lukket øynene sine, slik at de ikke kan se. Derfor kan de ikke vende om til meg og bli helbredet!’ ");
INSERT INTO norlb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Men dere kan være lykkelige, for øynene deres kan se og ørene deres kan høre. ");
INSERT INTO norlb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jeg forsikrer dere at mange profeter, og andre som fulgte Guds vilje, har lengtet etter å få se og høre det som dere nå får være med om, men de fikk aldri muligheten til det. ");
INSERT INTO norlb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Her er forklaringen om bonden som sådde såkornet i åkeren: ");
INSERT INTO norlb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Den harde veien langs åkeren, der noe av såkornet falt, ligner hjertet til en person som hører budskapet om at Gud vil frelse menneskene og gjøre de til sitt eget folk, men ikke tar det på alvor. Straks er den onde på plass og plukker bort såkornet fra hjertet. ");
INSERT INTO norlb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Det tynne jordlaget er likt hjertet til en person som hører budskapet og tar imot det med ekte glede, ");
INSERT INTO norlb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","men som ikke har dybde i seg, slik at røttene kan utvikle seg. Etter en tid kommer vanskeligheter eller forfølgelser på grunn av troen, da avtar entusiasmen og han forlater troen. ");
INSERT INTO norlb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jorden som var dekket med frø fra tistler, kan bli sammenlignet med en person som hører budskapet, men lar hverdagens bekymringer og begjæret etter å tjene mest mulig penger kvele det han fikk høre. Budskapet får ikke påvirke livet hans. ");
INSERT INTO norlb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Den fruktbare jorden derimot, ligner hjertet til en person som hører til budskapet og forstår det og lar det påvirke hele livet sitt. Han gir en avling som er 30, 60 eller til og med 100 ganger så stor som den mengde såkorn som falt i hjertet hans.” ");
INSERT INTO norlb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dette er et annet bilde som Jesus fortalte: ”Der Gud bestemmer, blir det som når en bonde sådde rent såkorn i åkeren sin. ");
INSERT INTO norlb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","En natt da alle lå og sov, kom fienden hans og sådde ugress blant hveten. Etterpå snek han usett bort. ");
INSERT INTO norlb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Da såkornet begynte å spire og sette i aks, vokste også ugresset opp. ");
INSERT INTO norlb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tjenerne til bonden gikk til ham og sa: ’Herre, åkeren der du sådde det rene såkornet, er full av ugress! Hvor kommer det fra?’ ");
INSERT INTO norlb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","’Det må være en fiende som har vært der’, svarte herren deres. Tjeneren spurte da: ’Skal vi rykke opp ugresset?’ ");
INSERT INTO norlb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","’Nei’, sa han, ’da kommer dere til å skade hveten samtidig. ");
INSERT INTO norlb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","La begge deler vokse sammen til det blir tid for å høste. Når tiden er inne, skal jeg si til høstfolkene: Skill bort ugresset og bunt det sammen, slik at det kan bli brent opp. Etterpå kan dere samle inn hveten i mitt forrådskammer.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus fortalte også dette bildet for dem: ”Der Gud bestemmer, blir det som når en gartner sår et sennepsfrø i hagen. Det er det minste av alle frøene, ");
INSERT INTO norlb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","men når det har vokst opp, er det størst blant krydderplantene. Det blir til et tre der fuglene kan komme og bygge reir i grenene.” ");
INSERT INTO norlb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Han fortalte også et annen bilde: ”Der Gud bestemmer, blir det som når en kvinne blander gjær i deigen mens hun baker. Hun tar bare en liten smule gjær og blander den inn i en stor mengde mel og elter alt sammen. Over tid virker gjæren i hele deigen.” ");
INSERT INTO norlb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Alt dette fortalte Jesus til folket ved å bruke bilder. Ja, han talte bare til dem gjennom bilder. ");
INSERT INTO norlb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ved dette ble det virkelig som Gud hadde forutsagt ved sin profet: ”Jeg skal tale i bilder, jeg skal fortelle hemmeligheter som er gjemt fra verdens skapelse av.” ");
INSERT INTO norlb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Litt etter dro Jesus fra folket og gikk til huset der han bodde. Der ba disiplene om at han måtte forklare bildet om ugresset og hveten for dem. ");
INSERT INTO norlb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","”Det skal jeg gjøre”, sa han. ”Jeg, Menneskesønnen, er den som sår det rene såkornet. ");
INSERT INTO norlb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Åkeren er verden, og såkornet representerer de menneskene som tilhører Gud og er hans eget folk. Ugresset er de som tilhører den onde. ");
INSERT INTO norlb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Fienden, som sådde ugresset blant hveten, er djevelen. Høsttiden er verdens ende, og høstfolkene er englene. ");
INSERT INTO norlb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Som når ugresset blir skilt fra hveten og brent opp, slik skal det være ved tidenes slutt. ");
INSERT INTO norlb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jeg, Menneskesønnen, skal sende ut englene mine, og de skal rense Guds verden. De skal ta bort alle dem som lokker menneskene til synd og gjør det som er ondt. ");
INSERT INTO norlb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","De onde skal bli kastet i den brennende ovnen. Der skal de gråte av angst og fortvilelse. ");
INSERT INTO norlb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","De som følger Faderens vilje, skal lyse som solen i den nye verden der deres Far i himmelen regjerer. Lytt nøye og forsøk å forstå!” ");
INSERT INTO norlb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus fortalte enda flere bilder. Han sa: ”Der Gud bestemmer, blir det som når en mann oppdager en skatt i en åker. I sin iver graver han ned skatten igjen og går og selger alt han eier for å kunne kjøpe åkeren, for at skatten kan bli hans. ");
INSERT INTO norlb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Der Gud bestemmer, blir det også som når en kjøpmann er på jakt etter kostbare perler. ");
INSERT INTO norlb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Når han oppdager en ekstra verdifull perle, går han av sted og selger alt han eier for å kunne kjøpe den. ");
INSERT INTO norlb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Der Gud bestemmer, blir det også som når noen kaster not ut i sjøen for å fange fisk av forskjellige slag, både spiselige og uspiselige. ");
INSERT INTO norlb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Når noten er full drar de den opp på stranden og setter seg ned og sorterer fisken. De spiselige fiskene samler de i en korg, men de andre kaster de fra seg. ");
INSERT INTO norlb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Slik skal det bli ved tidenes slutt. Englene skal komme og skille de onde menneskene fra de som følger Guds vilje. ");
INSERT INTO norlb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Etterpå blir de onde kastet i den brennende ovnen. Der skal de gråte av angst og fortvilelse. ");
INSERT INTO norlb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Har dere forstått alle disse bildene?” ”Ja”, sa de, ”det har vi.” ");
INSERT INTO norlb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Da sa han: ”Det betyr at hver person som kjenner til Skriften, og nå hører til det folk som Gud regjerer over, i fortsettelsen kan fortelle om både den nye og den gamle måten å tjene Gud på.” ");
INSERT INTO norlb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Da Jesus hadde fortalt alle disse bildene, dro fra han stedet. ");
INSERT INTO norlb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Han kom litt etter til hjembyen sin Nasaret. Der underviste han i synagogen. Han overrasket alle med sin visdom og miraklene sine. ");
INSERT INTO norlb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","”Hvordan er dette mulig?” undret folket. ”Dette er jo bare sønnen til snekkeren. Vi kjenner moren hans, Maria, og brødrene hans Jakob, Josef, Simon og Judas. ");
INSERT INTO norlb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Alle søstrene hans bor jo her. Hvor har han fått alt dette fra?” ");
INSERT INTO norlb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Og de irriterte seg over ham. Da sa Jesus til dem: ”En profet som bringer Guds budskap, blir anerkjent over alt, bortsett fra i sin egen hjemby og i sin egen familie.” ");
INSERT INTO norlb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Siden de ikke trodde på ham gjorde han bare noen få mirakler der. ");
INSERT INTO norlb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Etter en tid fikk kong Herodes høre alt det folk fortalte om Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Han sa da til tjenerne sine: ”Det må være døperen Johannes som har stått opp fra de døde. Det er derfor han kan gjøre slike mirakler.” ");
INSERT INTO norlb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes hadde nemlig under press fra kona si, Herodias, arrestert Johannes og latt ham binde og kaste i fengsel. Herodias hadde først vært gift med Filip, som var bror til kongen. ");
INSERT INTO norlb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Johannes hadde sagt rett ut til Herodes: ”Det er ikke tillatt for deg å leve sammen med henne.” ");
INSERT INTO norlb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helst hadde Herodes ønsket å drepe Johannes, men han var redd for folket, som mente at Johannes var en profet som bar fram Guds budskap. ");
INSERT INTO norlb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Men da Herodes feiret sin fødselsdag, danset datteren til Herodias for gjestene. Og Herodes ble helt fortryllet over dansen hennes. ");
INSERT INTO norlb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Han sverget på at han ville gi henne hva hun enn ba om. ");
INSERT INTO norlb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Moren fikk henne til å si: ”Jeg vil ha hodet til døperen Johannes på et fat.” ");
INSERT INTO norlb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kongen ble svært sjokkert, men på grunn av det løfte han hadde gitt, og etter som han ikke ville ta tilbake det han hadde sagt i påhør av gjestene, ga han befaling om at hun skulle få kravet oppfylt. ");
INSERT INTO norlb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Derfor ble Johannes halshugget i fengslet. ");
INSERT INTO norlb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","De la hodet hans på et fat og ga det til jenta, som i sin tur bar det til moren sin. ");
INSERT INTO norlb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Etterpå kom disiplene til Johannes og hentet kroppen og begravde den. Senere gikk de til Jesus og fortalte det som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Da Jesus fikk høre det som hadde skjedd, drog han med båt til en avsides plass for å være for seg selv. Folket i byene fikk imidlertid greie på det og fulgte etter til fots langs sjøen. ");
INSERT INTO norlb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Da Jesus steg ut av båten og fikk se alt folket som hadde samlet seg, følte han sympati med dem, og han helbredet de som var syke. ");
INSERT INTO norlb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","På kvelden kom disiplene bort til ham og sa: ”Det er allerede seint, og det finnes ikke noe å spise her i ødemarken. Send folket av sted for at de kan gå til byene i nærheten og kjøpe mat.” ");
INSERT INTO norlb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Men Jesus svarte: ”Det trenger de ikke. Dere kan selv gi dem mat!” ");
INSERT INTO norlb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","”Skal vi?”, utbrøt de. ”Vi har jo bare fem brød og to fisker!” ");
INSERT INTO norlb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","”Gi det dere har til meg”, sa han. ");
INSERT INTO norlb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Så ba han folket å slå seg ned i gresset. Han tok de fem brødene og de to fiskene, så opp mot himmelen og takket Gud. Han brøt brødene i biter og ga dem til disiplene, som delte ut til folket. ");
INSERT INTO norlb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Alle spiste og ble mette, og da de samlet sammen det som var igjen, ble det tolv fulle kurver. ");
INSERT INTO norlb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Det var omkring 5 000 menn som hadde spist, i tillegg til kvinner og barn. ");
INSERT INTO norlb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Straks etter dette ba Jesus disiplene om å sette seg i båten og reise i forveien over til andre siden av sjøen. Selv stanset han igjen for å se at folket kom seg på hjemvei. ");
INSERT INTO norlb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Da han hadde gjort det, gikk han opp på fjellet for å be. Der var han alene til det ble kveld. ");
INSERT INTO norlb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","I mens hadde disiplene kommet i vanskeligheter langt ute på sjøen. Det blåste opp, og de hadde store problemer med å ta seg over til den andre siden etter som det var motvind. ");
INSERT INTO norlb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Straks før det begynte å lysne, kom Jesus gående til dem på vannet. ");
INSERT INTO norlb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Da disiplene fikk se ham gå på sjøen, ble de livredde. De trodde det var et spøkelse, og skrek av redsel. ");
INSERT INTO norlb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Men Jesus snakket straks til dem og sa: ”Ro dere ned, det er jeg. Vær ikke redde.” ");
INSERT INTO norlb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Da ropte Peter: ”Herre, om det virkelig er deg, da kan du vel si at jeg får komme til deg på vannet.” ");
INSERT INTO norlb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","”Javisst”, sa Jesus. ”Kom!” Peter klatret over båtripen og begynte gå på vannet mot Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Da han stirret mot de høye bølgene, ble han lammet av redsel og begynte å synke. ”Redd meg, Herre!” skrek han. ");
INSERT INTO norlb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Og straks rakte Jesus ut hånden og grep tak i ham. ”Er troen din så liten?” sa Jesus. ”Hvorfor tvilte du?” ");
INSERT INTO norlb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Etterpå steg de i båten, og i samme øyeblikk la vinden seg. ");
INSERT INTO norlb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","De som var i båten, falt ned for Jesus og sa: ”Du må være Guds sønn!” ");
INSERT INTO norlb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Da Jesus og disiplene hadde reist over sjøen, gikk de i land ved Gennesaret. ");
INSERT INTO norlb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Der ble Jesus straks kjent igjen av folket på stedet. De sendte bud til hele distriktet for å spre nyheten om hans ankomst. Snart kom folk dit med alle sine syke. ");
INSERT INTO norlb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","De ba om at de i det minste måtte få røre ved dusken på kappen hans. Og alle som gjorde det, ble friske! ");
INSERT INTO norlb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Senere kom noen fariseere og noen av de skriftlærde fra Jerusalem for å diskutere med Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","”Hvorfor bryter disiplene dine de gamle jødiske reglene?” spurte de. ”De vasker ikke hendene før de spiser.” ");
INSERT INTO norlb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Han svarte: ”Hvorfor bryter dere selv Guds bud ved å følge egne regler? ");
INSERT INTO norlb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gud sier for eksempel: ’Vis respekt for foreldrene dine’, og: ’Den som forbanner foreldrene sine, skal bli dømt til døden.’ ");
INSERT INTO norlb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Men dere påstår at dere slett ikke behøver å respektere foreldrene eller ta hånd om dem når de blir gamle. Dersom dere bare gir pengene som en gave til templet i stedet, påstår dere at alt er i sin skjønneste orden. På den måten gjør dere Guds klare befaling ugyldig ved å følge egne regler. ");
INSERT INTO norlb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dere er falske mennesker som bare later som om dere er lydige mot Gud! Profeten Jesaja hadde rett da han bar fram Guds budskap om dere og sa: ");
INSERT INTO norlb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","’Dette folket ærer meg med ordene sine, men de nekter å være lydige mot meg. ");
INSERT INTO norlb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Deres tilbedelse er verdiløs, for de budene de lærer, er menneskene sine egne regler og ikke Guds bud.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Så kalte Jesus til seg folket og sa: ”Lytt til det jeg sier og forsøk å forstå: ");
INSERT INTO norlb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dere blir ikke uverdige for Gud på grunn av det dere spiser og stapper i munnen! Det er det dere sier, det som kommer ut av munnen, som gjør dere uverdige!” ");
INSERT INTO norlb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Da gikk disiplene bort til ham og sa: ”Vet du at du irriterte fariseerne med det du sa?” ");
INSERT INTO norlb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus svarte: ”Hver plante som ikke er plantet av min Far i himmelen, skal bli rykket opp med roten, ");
INSERT INTO norlb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ikke bry dere om fariseerne. De er blinde ledere som veileder andre blinde. Når en blind leder en blind, faller begge i samme grøften.” ");
INSERT INTO norlb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter ba at Jesus måtte forklare hva han mente med at ingen blir uverdige for Gud på grunn av det de spiser. ");
INSERT INTO norlb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","”Forstår heller ikke dere det jeg mener?” spurte Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","”Innser dere ikke at det dere spiser, bare passerer gjennom magen og kommer ut igjen? ");
INSERT INTO norlb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ordene dere sier kommer derimot fra hjertet. Derfor er det dette som gjør menneskene uverdige for Gud. ");
INSERT INTO norlb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Fra hjertet kommer onde tanker, mord, utroskap i ekteskapet, seksuell løssluppenhet, tyveri, løgn og sladder. ");
INSERT INTO norlb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Det er slikt som gjør menneskene uverdige. Ingen blir uverdig for Gud ved å spise uten først å ha vasket hendene.” ");
INSERT INTO norlb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus dro fra Galilea og til distriktet rundt byene Tyrus og Sidon. ");
INSERT INTO norlb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","En kanaaneisk kvinne fra området der kom til ham og ropte: ”Herre, du som skal arve kong Davids trone, ha medfølelse med meg. Min datter er besatt av en ond Ånd, og den plager henne støtt og stadig.” ");
INSERT INTO norlb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus svarte henne ikke med et ord. Disiplene kom derfor og sa til ham: ”Send henne bort, hun forfølger oss jo med ropene sine.” ");
INSERT INTO norlb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Han sa til kvinnen: ”Jeg har fått i oppgave å hjelpe Israels folk, Guds tapte sauer.” ");
INSERT INTO norlb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kvinnen kom nærmere og falt på kne og ba ham på nytt: ”Herre, hjelp meg!” ");
INSERT INTO norlb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus svarte: ”Det er ikke rett å ta brødet fra barna og kaste det til hundene.” ");
INSERT INTO norlb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","”Det er sant, Herre”, sa hun, ”men til og med hundene har rett til å spise de smulene som faller fra bordet til herrene deres.” ");
INSERT INTO norlb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","”Kvinne”, sa Jesus til henne, ”troen din er sterk. Du skal få det du ber om.” Og i samme øyeblikk ble datteren hennes helbredet. ");
INSERT INTO norlb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus vendte nå tilbake til Genesaretsjøen og gikk opp på en fjellskråning i nærheten og satte seg der. ");
INSERT INTO norlb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Snart hadde det samlet seg en stor folkemasse omkring ham. De hadde med seg handikappede, utviklingshemmede, blinde, stumme og mange andre. De la dem foran Jesus, og han helbredet dem. ");
INSERT INTO norlb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Folk var helt forundret, for de stumme begynte å snakke, utviklingshemmede ble friske, handikappede gikk, og blinde kunne se! Alle hyllet Israels Gud. ");
INSERT INTO norlb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Senere kalte Jesus på disiplene og sa: ”Jeg har stor medfølelse med folket. De har nå vært her i tre dager og har ikke noe å spise. Jeg vil ikke sende dem sultne bort, for da vil kanskje noen svime av langs veien på grunn av utmattelse.” ");
INSERT INTO norlb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Disiplene svarte: ”Hvor skal vi få nok mat til alle her i ødemarken?” ");
INSERT INTO norlb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus spurte dem: ”Hvor mye mat har dere?” ”Sju brød og noen små fisker”, svarte de. ");
INSERT INTO norlb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesus ba folket å slå seg ned på marken. ");
INSERT INTO norlb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Han tok de sju brødene og fiskene og takket Gud. Så brøt han dem i biter og ga til disiplene, som i sin tur delte dem ut til folket. ");
INSERT INTO norlb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Alle spiste og ble mette. Da de samlet sammen restene som var til overs, ble det sju fulle kurver. ");
INSERT INTO norlb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Det var 4 000 menn som hadde spist. I tillegg kom kvinner og barn. ");
INSERT INTO norlb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Etterpå ba Jesus folket om å gå hjem. Selv steg han ombord i en båt og seilte over sjøen til Magadan. ");
INSERT INTO norlb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseerne og saddukeerne kom til Jesus, og forlangte at han skulle gi dem et tegn fra Gud som bevis på hvem han var. ");
INSERT INTO norlb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Men han svarte: ”Dere er flinke til å tyde de tegnene dere ser på himmelen: Om himmelen er rød når kvelden kommer, da vet dere at det blir fint vær på morgenen. Om himmelen er rød og skyet på morgenen, da vet dere at det snart blir uvær. Nå vil dere altså at himmelens Gud skal vise dere et tegn, likevel forstår dere ikke de tingene som skjer midt foran øynene på dere. ");
INSERT INTO norlb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Denne onde og gudløse slekten vil se tegn fra Gud. Det eneste tegnet de kommer til å få se, er det som skjedde med Jona.” Så dro Jesus fra dem og gikk derfra. ");
INSERT INTO norlb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Da de var på vei over til den andre siden av sjøen, oppdaget disiplene at de hadde glemt å ta med seg brød. ");
INSERT INTO norlb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus sa da til dem: ”Ta dere i vare for den gjæren som fariseerne og saddukeerne sprer.” ");
INSERT INTO norlb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","”Hva mener han?” spurte disiplene hverandre. De trodde at han sa dette fordi de hadde glemt å ta med seg brød. ");
INSERT INTO norlb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Da Jesus hørte de diskutere dette, sa han til dem: ”Så svak tro dere har! Hvorfor er dere så urolige for at dere ikke har noe brød? ");
INSERT INTO norlb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Forstår dere fortsatt ingenting? Husker dere ikke den gangen jeg mettet mer enn 5 000 personer med fem brød, og hvor mange kurver dere da fikk til overs? ");
INSERT INTO norlb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Husker dere ikke den andre gangen da jeg mettet mer enn 4 000 personer med sju brød, og hvor mange kurver dere da fikk til overs? ");
INSERT INTO norlb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hvordan kan dere tro at jeg snakket om brød? Jeg sier på nytt til dere: Ta dere i være for den gjæren som fariseerne og saddukeerne sprer om seg.” ");
INSERT INTO norlb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Da forsto de endelig at han med ”gjær” mente den falske undervisningen til fariseerne og saddukeerne, og at det var den han advarte dem mot. ");
INSERT INTO norlb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Da Jesus kom til området rundt Cæsarea Filippi, spurte han disiplene: ”Hvem sier folk at jeg, Menneskesønnen, er?” ");
INSERT INTO norlb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","De svarte: ”Noen sier døperen Johannes, noen sier Elia og andre Jeremia eller en av de andre profetene som før i tiden bar fram Guds budskap.” ");
INSERT INTO norlb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Da spurte han dem: ”Hvem tror dere at jeg er?” ");
INSERT INTO norlb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter svarte: ”Du er Messias, den lovede kongen, Sønn til den Gud som er og blir.” ");
INSERT INTO norlb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","”Du kan virkelig kjenne deg lykkelig, Simon, sønn av Jonas”, sa Jesus, ”for min Far i himmelen har selv vist deg dette. Ingen kan på egen hånd få innsikt i den saken. ");
INSERT INTO norlb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Du er Peter, en klippe, og på denne klippe vil jeg bygge min menighet. Helvetes krefter skal ikke kunne beseire den. ");
INSERT INTO norlb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jeg skal gi deg nøklene inn til Guds nye verden. Du skal få i oppdrag å fortelle menneskene at Gud har erklært dem skyldige, men du skal også fortelle dem at de har blitt fri fra sin skyld.” ");
INSERT INTO norlb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Han forbød disiplene å si til andre at han var Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Etter dette begynte Jesus å snakke åpent ut med disiplene om at han skulle gå til Jerusalem, og alt som skulle skje der. Han forklarte at folkets ledere, øversteprestene og de skriftlærde, ville gjøre det slik at han måtte lide mye og til slutt bli drept, men at han på den tredje dagen skulle stå opp fra de døde igjen. ");
INSERT INTO norlb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter tok ham da til siden, protesterte og sa: ”Gud kommer til å ta hånd om deg, Herre! Dette skal aldri skje med deg!” ");
INSERT INTO norlb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Men Jesus vendte seg mot Peter og sa: ”Gå bort fra meg, Satan! Du forsøker å få meg til å synde, for det du tenker, er mennesketanker og kommer ikke fra Gud.” ");
INSERT INTO norlb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesus sa til disiplene: ”Om noen vil bli disiplene mine, da kan han ikke lenger tenke på seg selv, men han må følge mitt eksempel og være beredt til å dø. ");
INSERT INTO norlb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ja, den som klamrer seg fast til livet, vil til slutt miste det, men den som mister livet sitt for min skyld, vil finne det. ");
INSERT INTO norlb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hvilken gevinst får et menneske om det blir gitt hele verden i hendene, men samtidig mister det evige livet? Alle pengene i hele verden kan ikke hjelpe et menneske til å få livet tilbake. ");
INSERT INTO norlb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jeg, Menneskesønnen, skal komme i min Fars herlighet med mine engler og dømme hvert enkelt menneske for det de har gjort. ");
INSERT INTO norlb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Men tro meg: Noen av dere som nå står her, skal ikke dø før de har sett meg, Menneskesønnen, komme med kongelig makt.” ");
INSERT INTO norlb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seks dager seinere tok Jesus med seg Peter, Jakob og broren hans Johannes, til toppen av et høyt fjell. Der kunne de være for seg selv. ");
INSERT INTO norlb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Utseende hans forandret seg mens de så på, ansiktet lyste som solen, og klærne ble blendende hvite. ");
INSERT INTO norlb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","De fikk se Moses og Elia stå og snakke med Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Da sa Peter til Jesus: ”Herre, dette er et fantastisk sted å være på. Om du vil, kan jeg bygge tre hytter, en til deg, en til Moses og en til Elia.” ");
INSERT INTO norlb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Akkurat i det han sa dette, ble de omsluttet av en lysende sky, og en stemme fra skyen sa: ”Dette er min elskede Sønn, han er min glede. Lytt til ham!” ");
INSERT INTO norlb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Da disiplene hørte stemmen, ble de fryktelig redde og kastet seg med ansiktet ned mot jorden. ");
INSERT INTO norlb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Men Jesus gikk bort og rørte ved dem. ”Reis dere opp”, sa han, ”og vær ikke redde!” ");
INSERT INTO norlb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Da de så opp, var det ingen andre der enn Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","På vei ned fra fjellet sa Jesus strengt til dem: ”Ikke fortell til noen om det dere har sett, før jeg, Menneskesønnen, har stått opp fra de døde.” ");
INSERT INTO norlb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Da spurte disiplene han: ”Hvorfor påstår de skriftlærde at Elia må vende tilbake før Messias, den lovede kongen, kommer?” ");
INSERT INTO norlb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus svarte: ”De skriftlærde har rett. Elia må først komme og sette alt i rette skikk. ");
INSERT INTO norlb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Faktum er at han allerede har kommet, men ingen kjente ham igjen, og de behandlet ham dårlig. På samme måten skal de også la meg, Menneskesønnen, få lide.” ");
INSERT INTO norlb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Da forsto disiplene at han snakket om døperen Johannes. ");
INSERT INTO norlb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Da de hadde kommet ned fra fjellet og møtte folket igjen, kom det fram en mann og falt på kne for Jesus og sa: ");
INSERT INTO norlb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","”Herre, ha medfølelse med sønnen min! Han får grusomme krampeanfall og lider mye. Han faller ofte i ilden eller i vannet. ");
INSERT INTO norlb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Jeg tok ham med til disiplene dine, men de kunne ikke helbrede ham.” ");
INSERT INTO norlb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","”Dere er håpløse mennesker som ikke vil tro!” utbrøt Jesus. ”Hvor lenge skal jeg være hos dere? Hvor lenge skal jeg holde ut med dere? Ta gutten hit til meg.” ");
INSERT INTO norlb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus snakket strengt til den onde ånden, og den forlot gutten. Fra det øyeblikket var han frisk. ");
INSERT INTO norlb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Da Jesus og disiplene var alene igjen, spurte de Jesus: ”Hvorfor kunne ikke vi drive ut den onde ånden?” ");
INSERT INTO norlb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","”Fordi dere har så liten tro”, svarte Jesus. ”Jeg forsikrer dere, om troen deres bare var så stor som et sennepsfrø, ville dere kunne si til dette fjellet: ’Flytt deg dit bort’, og det ville gjøre det. Ikke noe ville være umulig for dere.” ");
INSERT INTO norlb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Da de igjen var samlet i Galilea, sa Jesus til dem: ”Jeg, Menneskesønnen, skal bli forrådt og utlevert til menneskene, ");
INSERT INTO norlb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","og de kommer til å drepe meg. Men på den tredje dagen skal jeg stå opp fra de døde igjen.” Da ble disiplene fulle av sorg og sterkt bedrøvet. ");
INSERT INTO norlb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Da de hadde vendt tilbake til Kapernaum, kom noen funksjonærer som krevde inn tempelskatten, bort til Peter og spurte: ”Betaler ikke mesteren deres tempelskatt?” ");
INSERT INTO norlb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter svarte: ”Jo, visst gjør han det.” Så gikk han inn i huset for å snakke med Jesus om dette. Men før han fikk en sjanse til å si noe, spurte Jesus ham: ”Hva tror du, Simon? Krever kongene på jorden toll og skatt av sitt eget folk eller av de fremmed folkene som de har erobret?” ");
INSERT INTO norlb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","”Av fremmed folk naturligvis”, svarte Peter. ”Da slipper altså den som er medborger å betale skatt”, sa Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","”Men vi skal ikke gi dem noe å anklage oss for. Gå derfor ned til stranden og kast ut en fiskekrok og åpne munnen på den første fisken du får. Da kommer du til å finne en sølvmynt som rekker til skatt for oss begge to. Ta den og betal til funksjonærene.” ");
INSERT INTO norlb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Litt seinere kom disiplene bort til Jesus og spurte hvem som er den største blant dem som får være Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Da ropte Jesus på et lite barn og stilte det midt blant dem ");
INSERT INTO norlb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","og sa: ”Jeg forsikrer dere, om dere ikke forandrer dere og blir som små barn, da kommer dere slett ikke til å få tilhøre Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Den som gjør seg liten og ydmyk som dette barnet, han er den største blant dem som får være Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Og den av dere som tar imot et slikt barn fordi det tilhører meg, han tar imot meg. ");
INSERT INTO norlb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dersom noen leder vill en av disse små som tror på meg, og får han til å synde, da ville det være bedre for den personen å få en stor stein surret til halsen sin og bli kastet i havet. ");
INSERT INTO norlb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ulykken skal ramme verden på grunn av all ondskapen deres! Menneskene kommer alltid til å bli fristet av synd, men ulykken skal ramme det menneske som frister andre. ");
INSERT INTO norlb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Om hånden eller foten din får deg til å synde, da hugg den av og kast den fra deg. Det er bedre å få et evig liv sammen med Gud og heller savne den ene hånden eller foten, enn å bli kastet i helvetes ild med både hender og føtter i behold. ");
INSERT INTO norlb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Og om øye ditt får deg til å synde, da riv det ut og kast det fra deg. Det er bedre å få et evig liv sammen med Gud og heller savne et øye, enn å bli kastet i helvetes ild med begge øynene i behold. ");
INSERT INTO norlb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Pass på at dere ikke forakter en eneste av disse små, for jeg sier dere at englene deres alltid har adgang til min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","La meg bruke et bilde: Om en mann har 100 sauer og plutselig oppdager at en av dem har gått seg vill, hva tror dere han da gjør? Overlater han ikke de 99 andre til seg selv i fjellet, og gir seg av sted for å lete etter den ene som har forsvunnet? ");
INSERT INTO norlb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jo, og når han endelig har funnet den, kan jeg fortelle dere at han gleder seg mer over den ene sauen, enn over de 99 andre som aldri var på villstrå. ");
INSERT INTO norlb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","På samme måten vil ikke deres Far i himmelen at en eneste av disse små skal gå tapt.” ");
INSERT INTO norlb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesus fortsatte: ”Dersom en troende har handlet galt mot deg, da gå personlig til ham for å diskutere det onde han har gjort. Lytter han på deg og bekjenner at han har handlet galt, da har du vunnet tilbake din troende bror. ");
INSERT INTO norlb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dersom han ikke hører på deg, kan du hente en eller to personer som sammen med deg kan være vitner til det som blir sagt. Det blir krevd to eller tre vitner for at en sak skal bli avgjort rettferdig. ");
INSERT INTO norlb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nekter han fortsatt å høre på deg, skal du ta saken opp i menigheten. Og om menigheten da gir deg rett, men han ikke vil akseptere det, da skal du behandle ham som en toller eller som en annen gudløs person. ");
INSERT INTO norlb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jeg sier dere at dere skal få i oppdrag å fortelle mennesker at Gud har erklært dem skyldige, men også gjøre kjent at de er satt fri fra skyld. ");
INSERT INTO norlb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jeg sier dere at alt det som to av dere her på jorden blir enige å be om, det skal dere få av min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","For der to eller tre av mine er samlet, der er jeg midt iblant dem.” ");
INSERT INTO norlb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Da kom Peter bort til ham og spurte: ”Herre, hvor mange ganger må jeg tilgi et menneske som handler galt mot meg? Rekker det med sju ganger?” ");
INSERT INTO norlb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","”Nei”, svarte Jesus. ”Du skal tilgi 70 ganger sju ganger!” Og så tilføyde han: ");
INSERT INTO norlb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","”Der Gud bestemmer, blir det som i denne fortellingen: En konge ville skaffe seg oversikt over regnskapene til tjenerne sine. ");
INSERT INTO norlb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Da han begynte granskningen, viste det seg at en av dem var skyldig flere milliarder. ");
INSERT INTO norlb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Etter som tjeneren ikke kunne betale pengene tilbake, ga kongen befaling om at han skulle bli solgt, han selv, kona hans, barna og alt han eide, alt for at gjelden kunne bli betalt på den måten. ");
INSERT INTO norlb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tjeneren kastet seg fortvilt ned for føttene til kongen og ba: ’Gi meg bare litt tid, så skal jeg betale alt sammen.’ ");
INSERT INTO norlb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Da fikk kongen medfølelse, løslot ham og avskrev gjelden hans. ");
INSERT INTO norlb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Men da tjeneren gikk fra forsoningsmøtet, møtte han en annen tjener som skyldte ham en sum penger som tilsvarte tre månedslønner. Han tok kvelertak på ham og forlangte pengene tilbake. ");
INSERT INTO norlb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Arbeidskameraten hans falt da ned for han og sa: ’Gi meg bare litt tid, så skal jeg betale.’ ");
INSERT INTO norlb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mannen ville ikke vente, men gikk bort og ordnet det slik at tjeneren ble satt i fengsel til hele gjelden var betalt. ");
INSERT INTO norlb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Da de andre tjenerne fikk greie på dette, ble de opprørte og sinte. De gikk til kongen og fortalte det som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kongen kalte da til seg mannen som han hadde ettergitt alt, og sa: ’Din kalde og kyniske usling! Her avskrev jeg den store gjelden din bare fordi du ba meg om det. ");
INSERT INTO norlb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Burde ikke du også i din tur hatt like stor medfølelse med din arbeidskamerat, som jeg hadde med deg?’ ");
INSERT INTO norlb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Så lot den sinte kongen fangevokterne sine ta hånd om mannen til han betalte alt han var skyldig. ");
INSERT INTO norlb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","På samme måten skal min Far i himmelen gjøre med dere, om dere ikke av et helt hjerte tilgir medmenneskene deres.” ");
INSERT INTO norlb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Da Jesus hadde avsluttet denne talen, dro fra han Galilea og begynte gå sørover på østsiden av elven Jordan mot Judea. ");
INSERT INTO norlb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Store folkemasser fulgte ham, og han helbredet de syke. ");
INSERT INTO norlb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Noen fariseere kom for å diskutere med Jesus og forsøkte å få ham til å si noe som de kunne bruke mot han, og spurte: ”Anser du at en mann har rett til å skille seg fra kona si av hvilken som helst årsak?” ");
INSERT INTO norlb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","”Leser dere ikke Skriften?” svarte Jesus. ”I den står det jo at Gud fra begynnelsen av skapte menneskene til mann og kvinne, og ");
INSERT INTO norlb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","at mannen skal forlate foreldrene sine og holde seg til kona si, slik at de to blir ett. ");
INSERT INTO norlb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","De er altså ikke lenger to, men skal være ett. Og det som Gud har forent, skal ikke menneskene skille.” ");
INSERT INTO norlb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Da spurte de: ”Hvorfor bestemte da Moses at en mann kan skille seg ved å skrive ut en attest som bevis på skilsmissen, og at han etterpå kan sende kvinnen fra seg?” ");
INSERT INTO norlb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus svarte: ”Moses kjente til menneskets harde og onde hjerte. Det var derfor han tillot å skille seg. Gud hadde ikke tenkt seg det slik fra begynnelsen av. ");
INSERT INTO norlb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jeg sier dere at den mannen som skiller seg fra kona si uten at hun har vært utro, og han seinere gifter seg med en annen, han er utro.” ");
INSERT INTO norlb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Da sa disiplene: ”Om det er på denne måten, da er det bedre å ikke gifte seg i det hele tatt.” ");
INSERT INTO norlb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Men Jesus svarte: ”Alle kan ikke ta til seg undervisningen min om ekteskapet, men bare de som får hjelp av Gud. ");
INSERT INTO norlb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Når det gjelder det å ikke gifte seg, er det slik at noen blir født uten mulighet til seksuell aktivitet, andre har blitt kastrert av mennesker, og det finnes også noen som frivillig lever i avholdenhet og avstår fra å gifte seg for bedre å kunne tjene Gud. Den som kan ta til seg undervisningen min, skal gjøre det.” ");
INSERT INTO norlb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","De kom med små barn til Jesus for at han skulle legge hendene på dem og be. Men disiplene jaget dem bort. ");
INSERT INTO norlb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Da sa Jesus: ”Send dem ikke bort! La barna komme til meg, for alle som vil tilhøre Guds eget folk må bli som de.” ");
INSERT INTO norlb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Så la han hendene på barna og ba for dem. Etterpå gikk han derfra. ");
INSERT INTO norlb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","En ung mann kom og spurte Jesus: ”Mester, hva godt skal jeg gjøre for å få evig liv?” ");
INSERT INTO norlb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","”Hvorfor spør du meg om det som er godt?” svarte Jesus. ”Det finnes bare en som virkelig er god, og det er Gud. Evig liv kan du få dersom du holder budene hans.” ");
INSERT INTO norlb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","”Hvilke av budene?” spurte mannen. Jesus svarte: ” ’Du skal ikke drepe. Du skal ikke være utro i ekteskapet. Du skal ikke stjele. Du skal ikke lyve eller vitne falskt. ");
INSERT INTO norlb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Vis respekt for foreldrene dine. Du skal elske dine medmennesker som deg selv!’ ” ");
INSERT INTO norlb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","”Alle disse budene holder jeg allerede”, svarte den unge mannen. ”Hva mer må jeg gjøre?” ");
INSERT INTO norlb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus sa til ham: ”Om du virkelig vil bli fullkommen, da må du gå og selge alt du eier og gi pengene til de fattige, da skal du få en skatt i himmelen. Kom etterpå og følg meg.” ");
INSERT INTO norlb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Men da den unge mannen hørte dette, gikk han skuffet bort, for han var svært rik. ");
INSERT INTO norlb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Da sa Jesus til disiplene: ”En ting er sikkert: Det er nesten umulig for en rik person å få tilhøre Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ja, jeg sier dere at det er lettere for en kamel å komme gjennom et nåløye, enn for en rik å underordne seg Gud, slik at han får tilhøre Guds eget folk.” ");
INSERT INTO norlb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Denne påstanden gjorde disiplene helt forskrekket, og de sa: ”Hvem i all verden kan da bli frelst?” ");
INSERT INTO norlb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus så på dem og sa: ”Ingen, menneskelig sett, men for Gud er alle ting mulig.” ");
INSERT INTO norlb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Da sa Peter til ham: ”Vi har forlatt alt for å følge deg. Kommer vi til å få noe igjen for det?” ");
INSERT INTO norlb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","”Ja”, svarte Jesus. ”Jeg forsikrer dere at når jeg, Menneskesønnen, setter meg på min kongelige trone for å regjere i Guds nye verden, da skal også dere som har fulgt meg, få sitte på tolv troner og styre over Israels tolv stammer. ");
INSERT INTO norlb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hver og en som forlater hus eller søsken eller foreldre eller barn eller hjemstedet for å følge meg, han skal få mangedobbelt igjen og få evig liv som arv. ");
INSERT INTO norlb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mange som i dag har lav status, skal bli blant de fremste i Guds nye verden, mens andre, som i dag er betydningsfulle, må holde seg i bakgrunnen.” ");
INSERT INTO norlb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus fortsatte: ”Der Gud regjerer, blir det som i denne fortellingen: En jordeier gikk tidlig på morgenen ut for å leie arbeidere til vingården sin. ");
INSERT INTO norlb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Som betaling ble han enig med dem om en normal daglønn, og arbeiderne gikk til vingården. ");
INSERT INTO norlb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Klokken ni gikk jordeieren igjen ut og fikk se noen andre menn stå på torget uten å ha noe å gjøre. ");
INSERT INTO norlb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Også dem sendte han av sted til vingården og lovet at han ved dagens slutt skulle betale det som var rimelig. ");
INSERT INTO norlb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Midt på dagen, og ved tretiden på ettermiddagen, gjorde han det samme. ");
INSERT INTO norlb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Klokken fem, en time før arbeidsdagen var slutt, var han der igjen. Også da sto noen menn ledige på torget. Han spurte dem: ’Hvorfor har dere ikke arbeidet i hele dag?’ ");
INSERT INTO norlb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","’Fordi ingen har leid oss’, svarte de. ’Da kan dere gå av sted og arbeide sammen med de andre i vingården min’, sa han til dem. ");
INSERT INTO norlb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Da kvelden kom, ba jordeieren formannen sin om å kalle på arbeiderne for å gi dem lønnen. Han fikk befaling om å begynne med de som hadde kommet sist. ");
INSERT INTO norlb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","De mennene som begynte å arbeide klokka fem, kom da fram, og hver og en fikk en hel daglønn. ");
INSERT INTO norlb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Da de som var leid først kom for å få sin lønn, trodde de naturlig nok at de skulle få mye mer. Men de fikk det samme beløpet. ");
INSERT INTO norlb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Da begynte de å protestere: ’Disse dagdrivere har bare holdt på en time og likevel betaler du dem like mye som oss, til tross for at vi har arbeidet hele dagen i den intense varmen.’ ");
INSERT INTO norlb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","’Min venn’, svarte han, ’jeg har ikke handlet galt mot deg. Kom vi ikke overens om en normal daglønn? ");
INSERT INTO norlb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ta den og gå. Jeg tenker å gi alle lik lønn. ");
INSERT INTO norlb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Har jeg ikke rett til å gjøre det jeg vil med mine egne penger? Eller blir du misunnelig for at jeg er sjenerøs?’ ");
INSERT INTO norlb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Slik skal de som i dag har lav status være blant de fremste i Guds nye verden, mens andre, de som i dag er betydningsfulle, må holde seg i bakgrunnen.” ");
INSERT INTO norlb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Da Jesus var på vei til Jerusalem, samlet han sine tolv disipler rundt seg og sa til dem mens de gikk: ");
INSERT INTO norlb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","”Vi er nå på vei til Jerusalem. Der kommer jeg, Menneskesønnen, til å bli forrådt og utlevert til øversteprestene og de skriftlærde. De skal dømme meg til døden ");
INSERT INTO norlb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","og overgi meg til de romerske myndighetene. Romerne kommer i sin tur til å håne og piske meg og henrette meg ved å spikre meg fast til et kors, men på den tredje dagen skal jeg stå opp fra de døde igjen.” ");
INSERT INTO norlb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Litt seinere kom moren til Jakob og Johannes, sønnene til Sebedeus, bort til Jesus sammen med sine to sønner og falt på kne for å be om noe. ");
INSERT INTO norlb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","”Hva vil du?” undret han. Hun svarte: ”Jeg vil at du skal la mine sønner få sitte på hedersplassene nærmest deg når du skal regjere som konge, en på høyre side og en på venstre.” ");
INSERT INTO norlb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Men Jesus sa: ”Dere vet ikke hva dere ber om!” Og så vendte han seg mot Jakob og Johannes og spurte: ”Kan dere holde ut de fryktelige lidelsene som jeg må holde ut?” ”Ja”, svarte de. ”Det kan vi!” ");
INSERT INTO norlb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Da sa Jesus til dem: ”Dere kommer nok til å få lide akkurat som jeg, men jeg har ingen rett til å bestemme hvem som skal sitte på min høyre og på min venstre side. De plassene er reservert for dem som min Far i himmelen velger ut.” ");
INSERT INTO norlb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Da de ti andre disiplene hørte det Jakob og Johannes ba om, ble de opprørt. ");
INSERT INTO norlb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Men Jesus samlet dem og sa: ”I denne verden opptrer kongene som tyranner, og herskerne har all makt over dem som står under dem. ");
INSERT INTO norlb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Slik skal det ikke være blant dere. Den av dere som vil være leder, må være de andre sin tjener. ");
INSERT INTO norlb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Den som vil være den første blant dere, må være de andre sin slave. ");
INSERT INTO norlb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Følg mitt eksempel. Jeg, Menneskesønnen, har ikke kommet for å bli betjent, men for selv å tjene andre. Jeg har kommet for å gi livet mitt og kjøpe menneskene fri fra slaveriet deres under synden.” ");
INSERT INTO norlb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","På vei mot Jerusalem gikk Jesus og disiplene gjennom byen Jeriko. Da de dro fra byen, fulgte mye folk med. ");
INSERT INTO norlb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Akkurat da satt to blinde menn ved kanten av veien. Da de fikk høre at Jesus kom gående, begynte de å rope: ”Herre, du som skal arve kong Davids trone, ha medfølelse med oss!” ");
INSERT INTO norlb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Folket forsøkte å få dem til å holde stille, men de ropte bare enda høyere: ”Herre, du som skal arve kong Davids trone, ha medfølelse med oss!” ");
INSERT INTO norlb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Da Jesus hørte dette, stanset han, kalte dem til seg og spurte: ”Hva vil dere jeg skal gjøre for dere?” ");
INSERT INTO norlb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","”Herre”, sa de, ”at vi kan få se!” ");
INSERT INTO norlb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Da fikk Jesus medfølelse for dem, og rørte ved øynene deres. Straks kunne de se! Etterpå fulgte de med ham. ");
INSERT INTO norlb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesus og disiplene nærmet seg Jerusalem og var kommet utenfor byen Betfage ved Oljeberget. Han sendte to av disiplene i forveien ");
INSERT INTO norlb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","og sa: ”Gå inn i byen dere kommer til. Der skal dere få øye på et esel som står bundet med et føll ved siden av seg. Løs dem og ta dem med hit. ");
INSERT INTO norlb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dersom noen spør hva dere holder på med, skal dere bare si: ’Herren har bruk for dem’. Da vil straks den som spør, gi dere lov til å ta dyrene med.” ");
INSERT INTO norlb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gjennom dette ble det som Gud har forutsagt i profeten Sakarja, til virkelighet: ");
INSERT INTO norlb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","”Si til innbyggerne i Jerusalem: ’Se, kongen deres kommer til dere, ydmyk og ridende på et esel, ja, på en eselfole!’ ” ");
INSERT INTO norlb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","De to disiplene gjorde som Jesus hadde anvist dem. ");
INSERT INTO norlb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","De tok eselet og føllet med til ham, la kappene sine på eslene, og Jesus satte seg på det ene og red av sted mot byen. ");
INSERT INTO norlb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mange i folkemassen bredde kappene sine ut som en matte foran ham. Andre skar kvister fra trærne og strødde på veien. ");
INSERT INTO norlb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Alt folket, både de som gikk foran Jesus, og de som fulgte etter, ropte: ”Vi hyller degdu som skal arve kong Davids trone! Vi ærer deg du som er sendt av Herren! Alle i himmelen hyller deg!” ");
INSERT INTO norlb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","I hele Jerusalem ble det stort oppstyr da han red inn, og folket spurte: ”Hvem er han?” ");
INSERT INTO norlb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Folkemassen svarte: ”Det er profeten Jesus fra Nasaret i Galilea.” ");
INSERT INTO norlb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Senere gikk Jesus inn på tempelplassen og drev ut kjøpmennene og kundene deres. Han veltet bordene til dem som vekslet penger og rev ned hyllene til dem som solgte duer. ");
INSERT INTO norlb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Han sa til dem: ”Gud har sagt i Skriften: ’Mitt hus skal være et sted der menneskene kan be.’ Men dere har latt det bli ’et oppholdssted for tyver og kjeltringer’.” ");
INSERT INTO norlb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nå kom det mange blinde og lamme bort til ham på tempelplassen, og han helbredet dem. ");
INSERT INTO norlb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Da øversteprestene og de skriftlærde så alle de merkelige miraklene, og til og med hørte at små barn ropte til Jesus: ”Vi hyller deg, du som skal arve kong Davids trone”, ble de opprørt og spurte ham: ”Hører du ikke hva barna roper?” ");
INSERT INTO norlb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","”Jo”, svarte Jesus. ”Men leser dere ikke Skriften? Der står det: ’Til og med de små barna synger lovsanger til deg!’ ” ");
INSERT INTO norlb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Da dro han fra dem og gikk ut av byen mot Betania, der han stanset over for natten. ");
INSERT INTO norlb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Neste morgen var Jesus på vei tilbake til Jerusalem, og han ble sulten. ");
INSERT INTO norlb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Han fikk øye på et fikentre ved veien og gikk bort for å se om det var det fiken på det. Men det var bare løv uten frukt. Da sa han til treet: ”Du skal aldri mer bære frukt!” Straks visnet fikentreet. ");
INSERT INTO norlb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Disiplene ble sjokkert og spurte: ”Hvordan kan det ha seg at fikentreet visnet så brått?” ");
INSERT INTO norlb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Da sa Jesus til dem: ”Jeg forsikrer, om dere virkelig tror og ikke tviler, da kan dere også gjøre som jeg med dette fikentreet, ja, mer enn som så. Dere kan til og med si til dette fjellet: ’Opp med deg og kast deg selv i havet’, og det kommer til å gjøre det. ");
INSERT INTO norlb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dere kan få hva som helst dere ber om i bønnene deres dersom dere bare tror.” ");
INSERT INTO norlb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Da Jesus hadde kommet til tempelplassen og holdt på å undervise der, kom øversteprestene og lederne i folket fram til ham. De forlangte å få vite med hvilken rett han foretok seg alt det han gjorde, og hvem som hadde gitt ham oppdraget. ");
INSERT INTO norlb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","”Det skal jeg straks si dere”, sa Jesus, ”dersom dere først svarer på et annet spørsmål. ");
INSERT INTO norlb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Da døperen Johannes døpte, var det på Guds befaling eller ikke?” De begynte straks å diskutere med hverandre og sa: ”Om vi sier at det var på Guds befaling, da kommer han til å spørre oss hvorfor vi ikke trodde på ham. ");
INSERT INTO norlb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Men om vi påstår at Gud ikke hadde sendt Johannes, da kommer vi til å få problemer med folket. Alle sier at Johannes var en profet som bar fram Guds budskap.” ");
INSERT INTO norlb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Til slutt svarte de unnvikende: ”Vi vet ikke.” Da sa Jesus til dem: ”I så tilfelle sier heller ikke jeg hvem som har gitt meg i oppdrag å gjøre det jeg gjør.” ");
INSERT INTO norlb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","”Hva sier dere om dette?” fortsatte Jesus. ”En mann hadde to sønner. En dag sa han til den ene: ’I dag kan du gå ut og arbeide i vingården.’ ");
INSERT INTO norlb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","’Det vil jeg ikke’, svarte sønnen. Etter en stund forandret han mening og gikk likevel. ");
INSERT INTO norlb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Litt etter sa faren til den andre: ’Gå ut, du også’, og han svarte: ’Ja, visst, far, det skal jeg gjøre.’ Men han gikk aldri. ");
INSERT INTO norlb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hvilken av disse to var lydige mot faren sin?” De svarte: ”Den første naturligvis.” Da forklarte Jesus hva han mente med det han sa: ”Jeg forsikrer dere at tollere og prostituerte skal få tilhøre Guds eget folk, men ikke dere. ");
INSERT INTO norlb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Døperen Johannes kom og viste dere hvordan dere skal leve etter Guds vilje, men dere trodde ikke på ham. Tollerne og de prostituerte derimot gjorde som han sa. Men til tross for at dere så dette, angret dere ikke og begynte å tro på budskapet hans.” ");
INSERT INTO norlb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","”Jeg skal fortelle et annet bilde for dere”, sa Jesus. ”En jordeier plantet en vingård. Han bygget en mur rundt den og gravde en fordypning i bakken der de kunne presse saften av druene. Han bygget også et vakttårn. Så forpaktet han bort vingården til noen dyrket druer mens han selv reiste langt bort. ");
INSERT INTO norlb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Da det ble tid til å høste avlingen, sendte han noen tjenere til de som produserte vinen for å hente den delen av avlingen som var hans. ");
INSERT INTO norlb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Men de overfalt tjenerne. De mishandlet en, drepte en annen og steinet en tredje. ");
INSERT INTO norlb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Da sendte jordeieren andre tjenere, men det samme skjedde med dem. ");
INSERT INTO norlb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Til slutt sendte eieren sin egen sønn. Han tenkte: ’Sønnen min vil de vel i det minste ha respekt for.’ ");
INSERT INTO norlb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Men da de som leide vingården fikk se sønnen, sa de til hverandre: ’Her kommer han som skal arve hele vingården. Kom så dreper vi ham og legger selv beslag på den!’ ");
INSERT INTO norlb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","De fanget sønnen, slepte han ut av vingården og drepte ham.” ");
INSERT INTO norlb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","”Hva tror dere eieren gjør med disse svindlerne når han kommer tilbake?” spurte Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Øversteprestene og lederne i folket svarte: ”Han kommer helt sikkert til å drepe dem, og etterpå forpakter han bort vingården til andre som holder avtalen og gir ham sin del av avlingen som betaling når høsttiden kommer.” ");
INSERT INTO norlb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Da sa Jesus til dem: ”Har dere aldri lest det som står i Skriften: ’Den steinen som ikke var brukbar for bygningsmennene, har blitt selve hjørnesteinen. Herren har valgt den ut, og den er perfekt i våre øyne!’ ");
INSERT INTO norlb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Det jeg mener å si med dette er at de privilegier dere har som Guds folk, skal bli tatt fra dere og gitt til alle som følger Guds vilje. ");
INSERT INTO norlb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Den som snubler mot denne steinen, blir skadet, men den som steinen faller på, blir fullstendig pulverisert.” ");
INSERT INTO norlb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Da øversteprestene og fariseerne hørte det Jesus fortalte, forsto dem at det var de selv han snakket om. ");
INSERT INTO norlb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Derfor ville de straks arrestere ham, men de var redde for folket, som mente at Jesus var en profet som bar fram Guds budskap. ");
INSERT INTO norlb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus fortalte et nytt bilde for dem. Han sa: ");
INSERT INTO norlb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","”Der Gud regjerer, blir det som i denne fortellingen: En konge forberedte en stor bryllupsfest for sønnen sin. ");
INSERT INTO norlb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Han innbød mange gjester, og da forberedelsene var ferdige sendte han tjenere ut for å si til dem som var innbudt at tidspunktet var inne for å komme. Men alle takket nei. ");
INSERT INTO norlb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Da sendte han andre tjenere for å si til dem: ’Alt er klart, oksene og kalvene er slaktet. Skynd dere å komme!’ ");
INSERT INTO norlb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Men gjestene som han hadde bedt, var ikke interessert. Hver og en fortsatte med sitt, den ene med sin bondegård, den andre med sine forretninger. ");
INSERT INTO norlb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Noen grep til og med kongens tjenere, mishandlet og drepte dem. ");
INSERT INTO norlb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Da ble kongen sint og sendte ut sin armé, henrettet morderne og brente ned byene deres. ");
INSERT INTO norlb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Så sa han til tjenerne sine: ’Bryllupsfesten er ferdig, men de gjestene som jeg innbød, er ikke verd å få del i festen. ");
INSERT INTO norlb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gå derfor ut på gatehjørnene og be alle dere ser, til bryllupet.’ ");
INSERT INTO norlb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tjenerne gjorde som han sa og tok med seg alle de kunne finne, både onde og gode, og festsalen ble fylt med gjester. ");
INSERT INTO norlb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Da kongen kom innfor å hilse på gjestene, la han merke til en mann som ikke hadde på seg klær som passet for anledningen. ");
INSERT INTO norlb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","’Min venn’, spurte han, ’hvordan kan du være her uten å ha på deg klær som passer for bryllupet?’ Men mannen kunne ikke svare. ");
INSERT INTO norlb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Da sa kongen til tjenerne sine: ’Bind hendene og føttene hans og kast ut i mørket utenfor. Der skal de gråte av angst og fortvilelse.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesus avsluttet med disse ordene: ”Mange er innbudt av Gud, men få takker ja og vil tilhøre ham.” ");
INSERT INTO norlb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fariseerne gikk sin vei for å pønske ut en måte å få Jesus til å si noe som de kunne arrestere ham for. ");
INSERT INTO norlb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Til slutt sendte de noen av mennene sine sammen med kong Herodes sine tilhengere, og lot dem si til Jesus: ”Mester, vi vet at du alltid er ærlig. Du sier rett ut det som er Guds vilje og lar deg ikke påvirke av noen. ");
INSERT INTO norlb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Si oss nå om det er rett eller galt å betale skatt til den romerske keiseren. Hva mener du?” ");
INSERT INTO norlb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus visste hva de var ute etter. ”Dere er falske mennesker som bare later som om dere er lydige mot Gud!” ropte han. ”Hvorfor forsøker dere å lure meg? ");
INSERT INTO norlb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Vis meg en mynt, samme typen som dere betaler skatt med.” De ga ham en romersk mynt, ");
INSERT INTO norlb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","og han spurte dem: ”Hvem sitt bilde er dette, og hvem sin signatur står under bildet?” ");
INSERT INTO norlb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","”Keiserens”, svarte de. ”Da så”, sa han, ”gi keiseren det som er hans. Men det som tilhører Gud, det skal dere gi til Gud.” ");
INSERT INTO norlb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dette svaret overrasket dem i den grad at de gikk sin vei og lot ham være i fred. ");
INSERT INTO norlb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Samme dagen kom noen av saddukeerne til Jesus. De påstår at de døde ikke kan stå opp igjen, og derfor spurte de ham: ");
INSERT INTO norlb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","”Mester, Moses har sagt: ’Dersom en mann dør barnløs, da skal hans bror gifte seg med enken og passe på at den døde får en sønn som kan arve ham.’ ");
INSERT INTO norlb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nå hadde vi faktisk en familie blant oss med sju brødre. Den eldste av brødrene giftet seg og døde barnløs. Derfor giftet bror nummer to seg med enken. ");
INSERT INTO norlb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Men han døde også barnløs. Da giftet bror nummer tre seg med henne. Slik fortsatte det til hun hadde vært gift med de alle sju. ");
INSERT INTO norlb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Så døde også kvinnen til slutt. ");
INSERT INTO norlb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hvem blir hun kona til når de døde står opp igjen? Alle sju har jo vært gift med henne!” ");
INSERT INTO norlb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus svarte: ”Dere tar helt feil, etter som dere verken forstår Skriften eller kjenner Guds kraft. ");
INSERT INTO norlb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Når de døde står opp igjen, skal det ikke finnes noen som gifter seg. Alle kommer til å være som englene i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Men når det gjelder de dødes oppstandelse, har dere aldri lest det Gud har sagt til dere i Skriften: ");
INSERT INTO norlb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","’Jeg er Abrahams, Isaks og Jakobs Gud’. Gud er ikke en gud for døde, men for de levende.” ");
INSERT INTO norlb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Da folket hørte dette, ble de helt forundret over undervisningen hans. ");
INSERT INTO norlb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Da fariseerne fikk høre at Jesus hadde stoppet munnen på saddukeerne, samlet de seg. ");
INSERT INTO norlb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","En av dem, en skriftlærd, forsøkte å teste Jesus ved å stille spørsmål: ");
INSERT INTO norlb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","”Mester, hvilket er det viktigste av budene i Moseloven?” ");
INSERT INTO norlb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus svarte: ” ’Du skal elske Herren, din Gud, av hele ditt hjerte, av hele din sjel og av hele din forstand.’ ");
INSERT INTO norlb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dette er det første budet og også det viktigste. ");
INSERT INTO norlb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Det nest viktigste ligner på det første: ’Du skal elske dine medmennesker som deg selv.’ ");
INSERT INTO norlb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Disse to budene sammenfatter alt det som Gud har sagt i Moseloven og ved profetene.” ");
INSERT INTO norlb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mens fariseerne var samlet rundt Jesus, passet han på å stille dem et spørsmål: ");
INSERT INTO norlb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","”Hva mener dere om Messias, den lovede kongen? Hvem er han etterkommer av?” De svarte: ”Han er etterkommer av kong David.” ");
INSERT INTO norlb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","”Hvorfor kaller da David ham ’Herre’, når han snakker under innflytelse av Guds Ånd?” spurte Jesus. ”David sa jo: ");
INSERT INTO norlb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","’Gud sa til min Herre: Kom og sett deg på min høyre side for å regjere, til jeg har lagt dine fiender under føttene dine.’ ");
INSERT INTO norlb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mener dere virkelig at David skulle kalle en av sine etterkommere for Herre?” ");
INSERT INTO norlb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Men de kunne ikke svare, og fra den dagen av våget ingen å stille flere spørsmål til Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Senere talte Jesus til folket og disiplene og sa: ");
INSERT INTO norlb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","”Disse skriftlærde og fariseere ser det som oppgaven sin å forklare alle budene i Moseloven. ");
INSERT INTO norlb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Derfor skal dere lyde og følge det de sier, men ta dere i vare så dere ikke følger deres praktiske liv, for de snakker gjerne, men praktiserer slett ikke sine egne ord. ");
INSERT INTO norlb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","De stiller umulige krav mot dere, men gjør ikke noe for å hjelpe dere til å oppfylle dem. ");
INSERT INTO norlb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Alt de gjør, gjør de for å vise seg fram. De går omkring med ekstra brede bønneremmer på armene og setter lange minnedusker på kappene sine for å vise at de er lydige mot Gud. ");
INSERT INTO norlb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","De elsker å sitte på hedersplassene ved bordet under festmåltidene, og i gudstjenestene tar de plassene på fremste rekken. ");
INSERT INTO norlb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","De vil gjerne bli hilst med respekt på torget og bli kalt ’mester’ av folket. ");
INSERT INTO norlb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Men la aldri noen opphøye dere og kalle dere ’mester’, for bare en er deres læremester. Dere er alle søsken og står på samme nivået. ");
INSERT INTO norlb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kall heller ikke noen her på jorden for ’Far’, for bare en er deres Far, og det er Gud i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","La ingen kalle dere ’lærer’, for bare en er deres lærer, og det er Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Den som vil bli betydningsfull blant dere, må bli tjener for de andre. ");
INSERT INTO norlb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Den som opphøyer seg selv, skal bli ydmyket, men den som ydmyker seg selv, skal bli opphøyet.” ");
INSERT INTO norlb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jesus fortsatte: ”Ulykken skal ramme dere skriftlærde og fariseere, dere som er falske mennesker og bare later som om dere er lydige mot Gud. Dere hindrer andre fra å gjøre Guds vilje, slik at de ikke får tilhøre Guds eget folk. Selv kommer dere aldri til å bli regnet med blant dem. ");
INSERT INTO norlb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ja, ulykken skal ramme dere, dere som bare later som om dere er lydige mot Gud! Dere kan reise over hav og land for å få noen til å tro på Gud, men etterpå gjør dere den arme stakkaren til et helvetes barn, dobbelt verre enn dere selv. ");
INSERT INTO norlb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ulykken skal ramme dere, dere som er blinde ledere! Dere påstår at om noen sverger ’ved Guds tempel’, ja, så betyr det ingenting, for den eden har dere lov til å bryte. Men om noen sverger ’ved gullet i templet’ da er det forpliktende! ");
INSERT INTO norlb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Blinde dårer! Hva er det viktigste, gullet, eller templet som tilhører Gud og derfor gjør gullet hellig? ");
INSERT INTO norlb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Dere sier også at om noen sverger ’ved alteret’ da betyr det ingenting, men om noen sverger ’ved gavene på alteret’ da er det forpliktende! ");
INSERT INTO norlb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Blinde dårer! Hva er størst, gaven på alteret, eller alteret som tilhører Gud og derfor gjør gaven hellig? ");
INSERT INTO norlb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Når dere sverger ’ved alteret’, sverger dere både ved alteret og ved alt som er på det. ");
INSERT INTO norlb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Når dere sverger ’ved templet’, sverger dere både ved templet og ved den Gud som bor i det. ");
INSERT INTO norlb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Når dere sverger ’ved himmelen’, sverger dere ved Guds trone og ved Gud selv. ");
INSERT INTO norlb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ja, ulykken skal ramme dere, dere skriftlærde og fariseere, som bare later som om dere er lydige mot Gud. Dere gir Gud en tiendedel av den minste urt blant krydderplantene, som mynte, dill og karve, men dere bryr dere ikke om det som er langt viktigere: Rettferdighet, barmhjertighet og troskap. Visst skal dere gi Gud en tiendedel av alt, men ikke glem det som er det aller viktigste. ");
INSERT INTO norlb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Dere blinde ledere! Dere siler bort myggen, men svelger kamelene. ");
INSERT INTO norlb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ulykken skal ramme dere, dere skriftlærde og fariseere, som bare later som om dere er lydige mot Gud! På utsiden er dere like sterilt rene som de beger og fat dere vasker så grundig før dere drikker og spiser av dem. Men innvendig stinker livet av griskhet og begjær. ");
INSERT INTO norlb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Blinde fariseere! Se først til at dere får det rett med Gud på innsiden, for da vil også utsiden bli ren og fin. ");
INSERT INTO norlb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Uykken skal ramme dere, dere skriftlærde og fariseere! Dere viser fram en fin fasade, men dere er som hvitmalte graver. De er vakre på utsiden, men innvendig er de fylt med skjelettene fra døde kropper, smuss og råttenskap. ");
INSERT INTO norlb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dere gjør alt for at menneskene skal tro at dere følger Guds vilje, men i virkeligheten er dere fulle av falskhet og synd. ");
INSERT INTO norlb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ja, ulykken skal ramme dere, dere skriftlærde og fariseere, som bare later som om dere er lydige mot Gud! Dere bygger monumenter over profetene som bar fram Guds budskap, og dere smykker gravene til dem som fulgte Guds vilje. ");
INSERT INTO norlb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Og dere sier: ’Dersom vi hadde levd på forfedrenes tid, da ville vi aldri ha drept noen profeter.’ ");
INSERT INTO norlb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Men når dere sier dette, medgir dere at dere er etterkommere til dem som myrdet profetene. ");
INSERT INTO norlb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Så fortsett bare med å gå i fotsporene til forfedrene deres, og gjør ferdig det de startet på! ");
INSERT INTO norlb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Slanger, ormeyngel! Hvordan skal dere kunne unngå å bli dømt til helvede? ");
INSERT INTO norlb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jeg sender dere profeter som bærer fram Guds budskap, og visemenn og lærere som forklarer Skriften for dere. En av dem kommer dere til å drepe og spikre fast til et kors. Andre kommer dere til å piske til blods i synagogene deres og forfølge fra by til by. ");
INSERT INTO norlb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","På grunn av dette skal dere få stå til rette for alle mordene på dem som fulgte Guds vilje, helt fra Abel til Sakarja, som var sønn til Barakia, han dere myrdet mellom templet og alteret. ");
INSERT INTO norlb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ja, jeg forsikrer dere at alle disse dommene skal ramme denne slekten som ikke vil tro. ");
INSERT INTO norlb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Å, dere Jerusalems innbyggere, dere som dreper profetene og steiner andre som Gud sender til dere med budskapet sitt. Hvor ofte har jeg ikke ønsket å samle dere, som når en høne samler kyllingene sine under vingene, men dere lot meg ikke gjøre det. ");
INSERT INTO norlb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nå får dere selv ta hånd om deres tempel som blir lagt øde. ");
INSERT INTO norlb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ja, jeg sier dere, nå får dere ikke se meg igjen før dere roper: ’Vi ærer deg, du som er sendt av Herren.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Da Jesus gikk ut fra templet og var på vei bort, kom disiplene til ham og lurte på om han ikke syntes de storslåtte tempelbygningene var praktfulle. ");
INSERT INTO norlb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Han svarte: ”Tro meg, alt dette som dere nå ser, kommer til å bli jevnet med jorden. Stein skal ikke bli tilbake på stein.” ");
INSERT INTO norlb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Litt seinere satt Jesus på skråningen av Oljeberget og var alene med disiplene. De kom bort til ham og spurte: ”Når skal dette skje? Hva blir tegnet som viser at du kommer, og at tidenes slutt nærmer seg?” ");
INSERT INTO norlb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus sa til dem: ”Vær på vakt så ingen lurer dere. ");
INSERT INTO norlb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mange skal komme i navnet mitt og påstå at de er Messias, den lovede kongen, og de skal lede mange vill. ");
INSERT INTO norlb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dere kommer til å få høre om krig og trussel om krig, men la dere ikke skremme. Det må bli krig, men det betyr ikke at slutten er kommet. ");
INSERT INTO norlb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Folk og land skal reise seg mot hverandre, og det blir sultekatastrofer og jordskjelv på det ene stedet etter det andre. ");
INSERT INTO norlb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Men dette er bare begynnelsen på de veene som skal komme. ");
INSERT INTO norlb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Myndighetene kommer til å torturere og drepe dere, og alle folk skal hate dere for at dere tilhører meg. ");
INSERT INTO norlb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mange av dere kommer til å fornekte troen og forråde og hate hverandre. ");
INSERT INTO norlb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Andre vil lære falske budskap om Gud og forsøke å føre mange vill. ");
INSERT INTO norlb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mens ondskapen og lovløsheten øker over alt, kommer kjærligheten til å bli kald hos de fleste. ");
INSERT INTO norlb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Men den som holder ut til slutten, skal bli frelst. ");
INSERT INTO norlb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Det glade budskapet om at Gud vil frelse menneskene og gjøre dem til sitt eget folk, skal bli spredd i hele verden, slik at alle folk får høre det. Så skal slutten komme. ");
INSERT INTO norlb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","En dag skal det skje som Gud har sagt ved profeten Daniel. Dere skal få se et motbydelig avgudsbilde stå på det stedet som tilhører Gud. Den som leser dette, skal nøye legge merke til hvert ord. ");
INSERT INTO norlb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Da må de som er i Judea, rømme opp i fjellene. ");
INSERT INTO norlb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","De som er oppe på taket må ikke gå inn i huset for å pakke. ");
INSERT INTO norlb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","De som er ute på åkeren må ikke løpe hjem for å hente klær. ");
INSERT INTO norlb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Stakkars de kvinnene som er gravide når denne tiden kommer, og stakkars de mødrene som ammer barna sine! ");
INSERT INTO norlb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Be at dere ikke må rømme om vinteren eller på hviledagen. ");
INSERT INTO norlb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Denne katastrofen skal bli så vanskelig at verden aldri før har opplevd noe tilsvarende, og heller ikke kommer til å oppleve det igjen. ");
INSERT INTO norlb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ja, dersom ikke denne tiden ble forkortet, vil ikke et eneste menneske overleve. Men nå vil tiden bli forkortet, etter som Gud vil skåne dem som takker ja til innbydelsen hans om å tilhøre ham. ");
INSERT INTO norlb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Om noen da sier til dere: ’Nå har Messias, den lovede kongen, kommet. Her er han’, eller: ’Der er han’, så ikke tro på de! ");
INSERT INTO norlb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mange skal komme og påstå at de kan frelse verden, og mange skal holde fram falske budskap om Gud, og de skal gjøre store mirakler og tegn for om mulig å bedra også dem som tilhører Gud. ");
INSERT INTO norlb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Men husk på at jeg har advart dere! ");
INSERT INTO norlb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Får dere altså høre et rykte om at Messias, den lovede kongen, har kommet igjen og er ute i ørkenen, da bry dere ikke om å gå for å se etter. Og sier noen at han har skjult seg et eller annet sted, ikke tro på det! ");
INSERT INTO norlb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","For akkurat som når lynet flammer over himmelen fra øst til vest, slik skal det være når jeg, Menneskesønnen, kommer igjen. ");
INSERT INTO norlb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Det skal være like tydelig som når gribbene sirkler og samler seg rundt den døde kroppen til byttet. ");
INSERT INTO norlb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Så fort denne trengselstiden er slutt, kommer solen til å bli formørket og månen skal slutte å lyse. Stjernene skal bli slynget ut av sine baner, og kreftene i universet skal bli rokket. ");
INSERT INTO norlb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Da skal mitt, Menneskesønnen, sitt tegn vise seg på himmelen, og alle folk på jorden skal jamre seg og klage. De skal få se meg, Menneskesønnen, komme på himmelens skyer med makt og stor herlighet. ");
INSERT INTO norlb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Til lyden av gjallende trompeter skal jeg sende ut mine engler til alle verdenshjørner, slik at de når hele jorden. De skal samle alle dem som har takket ja til Guds innbydelse om å tilhøre han.” ");
INSERT INTO norlb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesus fortsatte å gjøre seg forstått ved å bruke et nytt bilde. Han sa: ”Lær av fikentreet. Når sevjen stiger i grenene og løvet begynner å springe ut, da vet dere at sommeren snart er her. ");
INSERT INTO norlb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","På samme måten kan dere vite at jeg ganske snart kommer igjen, når dere ser alt dette begynner å skje. ");
INSERT INTO norlb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jeg forsikrer dere at denne slekten skal ikke gå under før alt dette skjer. ");
INSERT INTO norlb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Himmelen og jorden skal forsvinne, men mine ord skal bli til evig tid. ");
INSERT INTO norlb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ingen vet hvilken dag eller time slutten kommer, ikke en gang englene, eller Guds sønn. Bare Far i himmelen alene vet det. ");
INSERT INTO norlb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Når jeg, Menneskesønnen, kommer igjen, skal verden være like sorgløs som på den tiden da Noah levde. ");
INSERT INTO norlb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Dagene før den store oversvømmelsen slo til, spiste, drakk og giftet folket seg. Alt var akkurat som vanlig, helt til den dagen da Noah gikk inn i arken. ");
INSERT INTO norlb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ingen ante noe som helst før den voldsomme oversvømmelsen druknet alle sammen. Ja, slik kommer det også til å være når jeg, Menneskesønnen, kommer tilbake. ");
INSERT INTO norlb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Da skal to menn arbeide sammen på åkeren: Den ene bli tatt med, den andre bli latt tilbake. ");
INSERT INTO norlb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","To kvinner skal male korn på den samme handkvernen: Den ene blir tatt med, den andre bli latt tilbake. ");
INSERT INTO norlb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hold dere altså våkne og beredt, for dere vet ikke hvilken dag Herren deres kommer! ");
INSERT INTO norlb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","La meg bruke et eksempel: Dersom huseieren visste hvilket klokkeslett på natten tyven tenkte å komme, da ville han selvfølgelig holde seg våken og hindre ham fra å bryte seg inn. ");
INSERT INTO norlb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Vær beredt også dere, for jeg kommer igjen når dere minst av alt venter det. ");
INSERT INTO norlb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tenk dere også et bilde av en klok og pålitelig tjener som av herren sin har fått i oppgave å passe på at de andre tjenerne får mat når de skal ha det. ");
INSERT INTO norlb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Lykkelig er denne tjeneren dersom herren hans kommer hjem og får se at han gjør akkurat det han skal. ");
INSERT INTO norlb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jeg lover dere at en slik trofast tjener vil få ansvaret for alt herren hans eier. ");
INSERT INTO norlb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Men dersom det er en upålitelig tjener som sier til seg selv: ’Herren min kommer ikke på en stund ennå,’ og så ");
INSERT INTO norlb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","begynner han å mishandle de andre tjenerne, lever livets glade dager og drikker seg full sammen med andre. ");
INSERT INTO norlb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Da skal herren hans helt plutselig komme en dag han slett ikke venter det. ");
INSERT INTO norlb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Herren hans skal drepe ham og gi ham samme skjebne som dem som bare later som om de er lydige mot Gud. Der skal de gråte av angst og fortvilelse.” ");
INSERT INTO norlb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus fortsatte: ”Når Gud kommer for å regjere over alle folk, skal det bli som i denne fortellingen: Ti unge jenter som var brudepiker ved et bryllup, tok sine oljelamper og gikk ut for å møte brudgommen. ");
INSERT INTO norlb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Fem av dem var kloke og tok med seg krukker med ekstra olje til lampene sine. De andre fem var uforstandige og glemte å ta med olje. ");
INSERT INTO norlb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Da brudgommen drøyde med å komme, ble de trette og la seg ned for å sove. ");
INSERT INTO norlb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Men ved midnatt ble de vekket av et rop: ’Brudgommen kommer! Kom ut og hils ham velkommen!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Alle jentene skyndte seg straks opp og gjorde i stand lampene sine. ");
INSERT INTO norlb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Men de fem som ikke hadde ekstra olje, tigget og ba om at de med ekstraforsyning måtte dele med dem fordi lampene deres hadde sloknet. ");
INSERT INTO norlb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Da svarte de andre: ’Vi har ikke så mye olje at det rekker både til dere og oss. Gå av sted til dem som selger olje og kjøp det dere trenger!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Men mens de var borte og kjøpte olje, kom brudgommen. De som var beredt, fikk da følge med ham inn til bryllupsfesten, og porten ble stengt. ");
INSERT INTO norlb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Etter en stund kom også de fem andre tilbake og stilte seg utenfor porten og ropte: ’Herre, Herre, du må åpne for oss!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Men da ropte han tilbake: ’Gå deres vei! Jeg kjenner dere ikke!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hold dere derfor våkne og var beredt, for dere vet ikke hvilken dag eller time jeg kommer tilbake. ");
INSERT INTO norlb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Når jeg kommer igjen, blir det nemlig som i denne fortellingen om en mann som reiste til utlandet: Mannen samlet tjenerne sine og ga dem i oppdrag å forvalte formuen hans mens han var borte. ");
INSERT INTO norlb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Til den ene ga han fem sekker med mynter av gull, til den andre to sekker og til den tredje en sekk, alt etter som de var dyktige. Etterpå reiste han. ");
INSERT INTO norlb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tjeneren som hadde fått fem sekker med mynter, begynte straks å kjøpe og selge og tjente snart fem sekker til. ");
INSERT INTO norlb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Han som hadde fått to sekker med mynter, gjorde det samme og tjente to sekker til. ");
INSERT INTO norlb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Men den som bare hadde fått en sekk med mynter gikk og gravde et hull i jorden og gjemte pengene til herren sin for at de skulle ligge trygt forvart uten noen risiko. ");
INSERT INTO norlb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Etter en lang tid kom herren deres tilbake fra reisen og kalte inn tjenerne. Han ba dem avlegge regnskap for det de hadde gjort med pengene. ");
INSERT INTO norlb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Den tjeneren som hadde fått fem sekker med mynter av gull, kom og ga ham ti sekker tilbake og sa: ’Herre, du ga meg fem sekker med mynter. Her har jeg tjent fem til.’ ");
INSERT INTO norlb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","’Bra!’, sa herren hans. ’Du er en god og pålitelig tjener. Du har trofast forvaltet den summen du fikk. Derfor skal du få ansvaret for mye mer. Kom inn og del gleden med meg!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Så kom den tjeneren fram som hadde fått to sekker med mynter av gull, og han rapporterte: ’Herre, du ga meg to sekker med mynter til å forvalte, og jeg har tjent to til.’ ");
INSERT INTO norlb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","’Bra!’, sa herren hans. ’Du er en god og pålitelig tjener. Du har trofast forvaltet den summen du fikk. Derfor skal du få ansvaret for mye mer. Kom inn og del gleden med meg!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Til sist kom den tjeneren fram som bare hadde fått en sekk med mynter, og han sa: ’Herre, jeg vet at du er en streng mann. Du høster der du ikke har sådd og samler der du ikke har plantet. ");
INSERT INTO norlb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Derfor våget jeg ikke å gi meg inn i noen forretninger. Jeg gravde bare ned pengene i jorden for ikke å ta noen risiko. Her får du dem tilbake!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Herren svaret ham: ’Du er en lat og udugelig tjener! Når du visste at jeg tenkte å kreve mer tilbake enn du hadde fått, ");
INSERT INTO norlb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","burte du jo i det minste ha satt pengene mine inn i banken. Da hadde jeg fått renter på dem. ");
INSERT INTO norlb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta fra ham pengene og gi dem til tjeneren som har ti sekker med mynter. ");
INSERT INTO norlb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","For den som bruker rett det han har fått, han skal få mer, og han skal leve i overflod. Men den som ansvarsløst bruker det han har fått, skal bli tatt ifra til og med det lille han har. ");
INSERT INTO norlb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kast den udugelige tjeneren ut i mørke utenfor. Der skal han gråte av angst og fortvilelse.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus fortsatte: ”Når jeg, Menneskesønnen, kommer i kongelig makt sammen med alle mine engler, da skal jeg sette meg på tronen for å regjere. ");
INSERT INTO norlb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Alle folk skal samle seg om meg, og jeg skal dele dem i to grupper, slik en gjeter gjør når han skiller sauene fra geitene. ");
INSERT INTO norlb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sauene skal jeg plassere på min høyre side og geitene på min venstre. ");
INSERT INTO norlb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Da skal jeg, kongen, si til dem som står på min høyre side: ’Kom alle dere som min Far i himmelen har frelst for evigheten. Gå inn i den nye verden som helt fra jordens skapelse av har blitt gjort i stand til dere. ");
INSERT INTO norlb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Jeg var sulten, og dere ga meg mat. Jeg var tørst, og dere ga meg vann. Jeg var en fremmed, og dere åpnet hjemmet deres for meg. ");
INSERT INTO norlb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jeg var naken, og dere ga meg klær. Jeg var syk, og dere tok hånd om meg. Jeg var i fengsel, og dere besøkte meg.’ ");
INSERT INTO norlb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Da kommer de som har fulgt Guds vilje til å stille spørsmålet: ’Herre, når så vi deg sulten og ga deg mat, eller tørst og ga deg noe å drikke? ");
INSERT INTO norlb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Når så vi deg som fremmed og var deg til hjelp, eller naken og ga deg klær? ");
INSERT INTO norlb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Når så vi deg syk eller i fengsel og besøkte deg?’ ");
INSERT INTO norlb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kongen skal svare dem: ’Jeg forsikrer dere at når dere gjorde dette mot en av mine minste brødre og søstrer, da gjorde dere det mot meg!’ ");
INSERT INTO norlb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Etter dette skal kongen vende seg mot dem som står på hans venstre side og si: ’Gå bort fra meg alle dere som er dømt til å bli straffet. Gå bort til den evige ilden som har blitt gjort i stand til djevelen og englene hans. ");
INSERT INTO norlb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Jeg var sulten, men dere ga meg ingen mat. Jeg var tørst, men dere ga meg ikke noe å drikke. ");
INSERT INTO norlb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jeg var fremmed, men dere nektet å gi meg husrom. Jeg var naken, men dere ga meg ingen klær. Jeg var syk og i fengsel, men dere besøkte meg ikke.’ ");
INSERT INTO norlb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Da kommer også de til å stille spørsmålet: ’Herre, har vi noen ganger sett deg sulten eller tørst, eller at du var en fremmed, eller at du var naken eller syk eller i fengsel uten at vi var deg til hjelp?’ ");
INSERT INTO norlb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Og kongen skal svare dem: ’Jeg forsikrer dere at når dere nektet å hjelpe noen av mine minste, da nektet dere også å hjelpe meg.’ ");
INSERT INTO norlb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Disse skal gå bort til evig straff, men de som fulgte Guds vilje, skal leve evig.” ");
INSERT INTO norlb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Da Jesus hadde avsluttet denne talen, sa han til disiplene: ");
INSERT INTO norlb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","”Som dere vet, begynner påskehøytiden om to dager. Da skal jeg, Menneskesønnen, bli utlevert og spikret fast til et kors.” ");
INSERT INTO norlb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","I mens samlet øversteprestene og folkets ledere seg i palasset til øverstepresten Kaifas ");
INSERT INTO norlb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","for å diskutere hvordan de i hemmelighet kunne arrestere Jesus og drepe han. ");
INSERT INTO norlb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","”Men”, sa de til hverandre, ”ikke under selve påskehøytiden, for da kan det lede til oppløp og demonstrasjoner.” ");
INSERT INTO norlb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus var en dag i Betania for å hilse på Simon, som før hadde vært spedalsk. ");
INSERT INTO norlb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mens de satt sammen og spiste, kom en kvinne bort til Jesus med en flaske kostbar olje, som hun helte over hodet hans. ");
INSERT INTO norlb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Disiplene ble opprørt og sa: ”Hvilket sløseri med pengene! Oljen er jo verd en formue. Hun kunne heller ha solgt den og gitt pengene til de fattige!” ");
INSERT INTO norlb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus merket hva de snakket om og sa: ”Hvorfor kritiserer dere henne? Hun har gjort en god gjerning mot meg. ");
INSERT INTO norlb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","De fattige kommer dere alltid til å ha iblant dere, men meg kommer dere ikke til å ha hos dere særlig lenge til. ");
INSERT INTO norlb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ved å helle denne oljen over meg har hun forberedt begravelsen min. ");
INSERT INTO norlb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Faktum er at over alt i verden der budskapet om meg blir gjort kjent, vil de også fortelle om dette som hun gjorde. På den måten vil alltid historien huske henne.” ");
INSERT INTO norlb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Etter denne hendelsen gikk Judas Iskariot, en av Jesus sine tolv disipler, til øversteprestene ");
INSERT INTO norlb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","og spurte: ”Hvor mye vil dere betale meg dersom jeg overgir Jesus til dere?” Øversteprestene ga ham da 30 sølvmynter. ");
INSERT INTO norlb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Fra da av søkte Judas etter en passende anledning til å forråde Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","På den første dagen i påskehøytiden kom disiplene og spurte Jesus: ”Hvor vil du at vi skal ordne med påskemåltidet?” ");
INSERT INTO norlb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus svarte: ”Gå inn i Jerusalem og let opp en spesiell mann og si til ham: ’Vår Mester sier: Den tiden Gud har bestemt for meg, har nå kommet. Nå vil jeg spise påskemåltidet i ditt hus sammen med disiplene mine.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Disiplene hans gjorde da som han hadde sagt, og ordnet med påskemåltidet der. ");
INSERT INTO norlb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Da kvelden kom, slo Jesus og disiplene hans seg ned ved bordet. ");
INSERT INTO norlb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mens de spiste, sa han: ”Jeg skal si som sannheten er: En av dere kommer til å forråde meg.” ");
INSERT INTO norlb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Da ble de svært bedrøvet, og en etter en spurte de: ”Det er vel ikke jeg, Herre?” ");
INSERT INTO norlb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Han svarte: ”Den som dypper sitt brød i fatet sammen med meg, han er det. ");
INSERT INTO norlb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","For jeg, Menneskesønnen, må dø, akkurat som Gud har forutsagt i Skriften. Men ulykken skal ramme det menneske som forråder meg. Det hadde vært bedre for den personen om han aldri var blitt født.” ");
INSERT INTO norlb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Da spurte Judas, han som skulle forråde ham: ”Mester, det er vel ikke meg du mener?” Jesus svarte: ”Du har selv sagt det.” ");
INSERT INTO norlb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mens de spiste, tok Jesus et brød, takket Gud for det, brøt det i biter, ga det til disiplene og sa: ”Ta dette og spis, for dette er kroppen min.” ");
INSERT INTO norlb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Etterpå tok han et beger vin, takket Gud, ga begeret til dem og sa: ”Drikk av dette alle sammen, ");
INSERT INTO norlb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","for dette er blodet mitt, som bekrefter den nye pakten mellom Gud og mennesker. Mitt blod skal bli ofret slik at mange kan få tilgivelse for syndene sine. ");
INSERT INTO norlb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jeg forsikrer dere at fra og med nå av skal jeg ikke drikke vin igjen, før den dagen min Far i himmelen regjerer, og jeg drikker den nye vinen i hans kommende verden.” ");
INSERT INTO norlb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Da de til slutt hadde sunget lovsangen sammen, gikk de ut til Oljeberget. ");
INSERT INTO norlb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Der sa Jesus til dem: ”I natt kommer dere alle til å forlate meg, for Gud sier i Skriften: ’Jeg skal drepe gjeteren, og sauene i flokken skal bli spredd.’ ");
INSERT INTO norlb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Men når jeg har stått opp fra de døde, skal jeg gå foran dere til Galilea og treffe dere der.” ");
INSERT INTO norlb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter innvendte og sa: ”Selv om alle andre forlater deg, så skal aldri jeg gjøre det.” ");
INSERT INTO norlb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Men Jesus sa til ham: ”Jeg forsikrer deg, allerede før hanen rekker å gale i morgen tidlig, skal du tre ganger ha fornektet at du kjenner meg.” ");
INSERT INTO norlb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Da sa Peter: ”Om jeg så må dø med deg, skal jeg aldri fornekte deg!” Og alle de andre disiplene sa det samme. ");
INSERT INTO norlb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Deretter gikk Jesus med disiplene til et sted som ble kalt Getsemane. Der sa han til dem: ”Sett dere her mens jeg går et stykke bort og ber.” ");
INSERT INTO norlb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Han tok bare med seg Peter og Sebedeus sine to sønner, som het Jakob og Johannes. Jesus ble nå grepet av fortvilelse og dødsangst. ");
INSERT INTO norlb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Han sa til dem: ”Jeg er nær ved å bryte sammen av fortvilelse. Bli her og våk sammen med meg.” ");
INSERT INTO norlb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Så gikk han litt lengre bort, kastet seg ned på jorden og ba: ”Far i himmelen, om det er mulig, så la meg slippe de lidelsene som venter. Men la det bli som du vil, ikke som jeg vil.” ");
INSERT INTO norlb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Etter en tid gikk han tilbake til sine tre disipler og fant dem sovende. Da sa han til Peter: ”Klarte dere ikke å holde dere våkne en eneste time for min skyld? ");
INSERT INTO norlb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Våk og be, så ikke fristelsene skal vinne seier over dere. Dere vil så gjerne, men menneskelig begrensning gjør det vanskelig for dere.” ");
INSERT INTO norlb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Så gikk han fra dem og ba samme bønnen for andre gangen: ”Far i himmelen, dersom det er mulig, så la meg slippe lidelsene som venter, men la din vilje skje, ikke min.” ");
INSERT INTO norlb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Da han kom tilbake til disiplene, så han at de igjen hadde sovnet. Det var umulig for dem å holde øynene åpne. ");
INSERT INTO norlb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Han lot de derfor være, gikk bort og ba for tredje gangen med de samme ordene. ");
INSERT INTO norlb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Så gikk han tilbake til disiplene og sa: ”Ja, dere sover og hviler dere fortsatt. Men nå har tidspunktet kommet som Gud har bestemt at jeg, Menneskesønnen, skal bli utlevert til onde mennesker. ");
INSERT INTO norlb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Reis dere opp, nå går vi herfra! Her kommer han som skal forråde meg.” ");
INSERT INTO norlb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mens Jesus snakket, kom Judas, en av Jesu disipler, sammen med en stor flokk menn som var bevæpnet med sverd og køller. De var sendt ut av øversteprestene og folkets ledere. ");
INSERT INTO norlb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Forræderen hadde kommet overens med dem om et tegn og sagt: ”Den mannen som jeg hilser med et kyss, han er det, han skal dere fange.” ");
INSERT INTO norlb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas gikk rett bort til Jesus og sa: ”God kveld, Mester!” og ga ham et velkomstkyss. ");
INSERT INTO norlb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus svarte: ”Min venn, gjør det du har kommet for å gjøre.” Og straks stormet de andre fram og grep Jesus og holdt ham fast. ");
INSERT INTO norlb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","En av de mennene som var med Jesus, trakk da sverdet sitt og hogg øret av tjeneren til øverstepresten. ");
INSERT INTO norlb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Men Jesus sa til ham: ”Stikk sverdet tilbake i sliren. De som bruker vold, kommer selv til å falle som offer for vold. ");
INSERT INTO norlb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Innser du ikke at jeg kunne be min Far i himmelen om å sende mer enn tolv armeer med engler for å beskytte oss, og han ville straks gjøre det? ");
INSERT INTO norlb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Men hvordan skulle det som Gud har forutsagt i Skriften da kunne bli virkelighet? Han har jo sagt at alt dette må skje.” ");
INSERT INTO norlb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Så vendte Jesus seg til flokken og sa: ”Er jeg en så farlig forbryter at dere er tvunget til å bevæpne dere med sverd og køller for å fange meg? Hvorfor arresterte dere meg ikke på tempelplassen? Hver dag satt jeg der og underviste uten at dere grep meg. ");
INSERT INTO norlb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Men alt dette har skjedd for at det som Gud har forutsagt i skriftene til profetene, skal bli virkelighet.” I samme øyeblikket løp alle disiplene fra ham og flyktet. ");
INSERT INTO norlb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","58","De som hadde arrestert Jesus, førte ham nå til øverstepresten Kaifas sitt palass. Der hadde de skriftlærde og folkets ledere samlet seg. Peter fulgte etter på avstand og klarte å ta seg helt inn på gårdsplassen. Han slo seg ned sammen med tjenerne for å se hva som skjedde med Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Inne i huset forsøkte øversteprestene og hele Det jødiske rådet å finne falske vitneforklaringer som kunne felle Jesus og holde som bevis for å få ham dømt til døden. ");
INSERT INTO norlb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Til tross for at det var det mange som var villige til å vitne falskt, kunne de ikke finne noe å anklage ham for. Til slutt presterte to menn å fortelle: ”Vi har hørt denne mannen si: ’Jeg kan rive ned Guds tempel og bygge det opp igjen på tre dager.’ ” ");
INSERT INTO norlb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Da reiste øverstepresten seg og sa til Jesus: ”Vil du ikke svare? Har du sagt dette eller ikke?” ");
INSERT INTO norlb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Men Jesus tidde. Da sa øverstepresten: ”Innfor den levende Gud krever jeg at du snakker ut med oss om du er Messias, den lovede kongen, Guds sønn.” ");
INSERT INTO norlb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus svarte: ”Det er du selv som kaller meg dette. Men jeg forsikrer dere at etter dette skal dere få se meg, Menneskesønnen, sitte på Guds høyre side og regjere, og dere skal få se meg komme på himmelens skyer.” ");
INSERT INTO norlb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Da slet øverstepresten i stykker klærne sine og ropte: ”Han har spottet Gud! Vi trenger ingen flere vitner. Dere har selv hørt ham spotte. ");
INSERT INTO norlb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hvilken dom skal han få?” De ropte tilbake: ”Han må dø!” ");
INSERT INTO norlb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","De begynte å spytte Jesus i ansiktet og slo ham med knyttede never. Noen ga ham også ørefiker og sa: ");
INSERT INTO norlb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","”Du som er Messias, den lovede kongen, vis nå at du er en profet. Avslør med Guds hjelp hvem av oss som slo deg.” ");
INSERT INTO norlb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mens alt dette pågikk, satt Peter ute på gårdsplassen. En tjenestejente kom da bort til han og sa: ”Du var vel også sammen med denne Jesus fra Galilea!” ");
INSERT INTO norlb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peter protesterte for alle og sa: ”Jeg vet ikke en gang hva du prater om.” ");
INSERT INTO norlb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Så gikk han ut i porten. Der fikk en annen tjenestejente øye på han. ”Denne mannen var sammen med Jesus fra Nasaret”, sa hun til dem som sto rundt dem. ");
INSERT INTO norlb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter nektet igjen, ja, han til og med bannet og sa: ”Jeg kjenner ikke denne mannen.” ");
INSERT INTO norlb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Etter en stund kom noen bort til ham og sa: ”Vi vet at du er en av disiplene. Det kan vi høre på dialekten din, du må jo komme fra Galilea.” ");
INSERT INTO norlb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peter bannet igjen og forsikret dyrt og hellig: ”Jeg kjenner ikke denne mannen.” I samme øyeblikk gol hanen. ");
INSERT INTO norlb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Plutselig kom Peter til å huske på det Jesus hadde sagt: ”Før hanen galer har du fornektet meg tre ganger.” Og han gikk ut og gråt i bitter fortvilelse. ");
INSERT INTO norlb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tidlig neste morgen samlet alle øversteprestene og folkets ledere seg igjen. De bestemte at de ville forsøke å få Jesus henrettet. ");
INSERT INTO norlb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","De bandt Jesus, førte han bort og overlot ham til Pilatus, som var romersk landshøvding. ");
INSERT INTO norlb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Da Judas, han som hadde forrådt Jesus, så at de hadde dømt ham til døden, angret han på det han hadde gjort. Han gikk tilbake til øversteprestene og folkets ledere med de 30 sølvmyntene og sa: ");
INSERT INTO norlb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","”Jeg har syndet, for jeg har forrådt et uskyldig menneske.” ”Jaha, og hva har det med oss å gjøre?” svarte de. ”Det er vel ditt problem.” ");
INSERT INTO norlb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Da kastet Judas pengene på gulvet i templet og gikk bort og hengte seg. ");
INSERT INTO norlb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Men øversteprestene samlet sammen pengene og sa: ”Vi kan ikke legge dem i offerkisten, etter som Moseloven forbyr oss å ta imot penger som er betalt for et mord.” ");
INSERT INTO norlb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Etter en lang diskusjon bestemte de seg i stedet for å kjøpe åkeren til en pottemaker, som etter dette er blitt brukt som gravplass for fremmede som dør under opphold i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Det er derfor denne åkeren fortsatt blir kalt ”Blodåkeren”. ");
INSERT INTO norlb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Og gjennom dette ble det til virkelighet som Gud hadde forutsagt ved profeten Jeremia: ”De tok de 30 sølvmyntene, den prisen som han ble verdsatt til av Israels folk, ");
INSERT INTO norlb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","og kjøpte åkeren av en pottemaker, slik som Herren ga meg befaling om.” ");
INSERT INTO norlb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus ble nå stilt fram for Pilatus, den romerske landshøvdingen. Og Pilatus spurte ham: ”Er du jødenes konge?” Jesus svarte: ”Det er du selv som kaller meg dette.” ");
INSERT INTO norlb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Men da øversteprestene og folkets ledere begynte å anklage ham, sto Jesus helt taus. ");
INSERT INTO norlb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","”Hører du ikke det de anklager deg for?” undret Pilatus. ");
INSERT INTO norlb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Men til stor forbauselse for landshøvdingen svarte ikke Jesus på et eneste spørsmål. ");
INSERT INTO norlb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ved påskehøytiden brukte alltid landshøvdingen å frigi en fange, hvem som helst som jødene ville ha fri. ");
INSERT INTO norlb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nettopp nå satt det en virkelig beryktet forbryter i fengslet. Han het Barabbas. ");
INSERT INTO norlb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Da folket samlet seg utenfor huset til Pilatus denne morgenen, spurte han dem: ”Hvem skal jeg slippe fri, Barabbas, eller Jesus som blir kalt Messias, den lovede kongen?” ");
INSERT INTO norlb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus visste nemlig inderlig vel at de religiøse lederne bare hadde overlatt Jesus til ham fordi de var misunnelige på ham. ");
INSERT INTO norlb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mens Pilatus satt på dommersetet, fikk han en beskjed fra kona si, som advarte ham: ”La denne uskyldige mannen være i fred, for jeg har hatt noen fryktelige mareritt i natt for hans skyld.” ");
INSERT INTO norlb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Men øversteprestene og folkets ledere hadde overtalt folket til å kreve at Barabbas skulle bli satt fri og at Jesus skulle bli drept. ");
INSERT INTO norlb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Da Pilatus for andre gangen spurte: ”Hvem av disse to skal jeg slippe fri?” ropte folket: ”Barabbas!” ");
INSERT INTO norlb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","”Hva skal jeg da gjøre med Jesus som blir kalt Messias?” undret Pilatus. ”Få han spikret fast på et kors!” skrek de. ");
INSERT INTO norlb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","”Men hva ondt har han gjort?” spurte Pilatus. Da ropte de enda høyere: ”Få ham spikret fast på et kors!” ");
INSERT INTO norlb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Da Pilatus til slutt innså at ingenting hjalp, og at folket når som helst kunne sette i gang et oppløp, ba han om et fat med vann. Så vasket han hendene sine i påsyn av folkemassen og sa: ”Jeg er uskyldig i denne mannens død. Ansvaret er deres!” ");
INSERT INTO norlb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Folket skrek tilbake: ”Vi og våre barn tar på oss ansvaret!” ");
INSERT INTO norlb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Da ga Pilatus etter og løslot Barabbas, men Jesus lot han piske og overlot ham etterpå til soldatene sine for at de skulle føre ham bort og spikre ham fast på korset. ");
INSERT INTO norlb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","De romerske soldatene førte først Jesus til huset der landshøvdingen holdt til. Hele vaktstyrken ble kalt sammen. ");
INSERT INTO norlb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","De tok klærne av Jesus, satte på ham en rød soldatkappe. ");
INSERT INTO norlb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Så laget de en krone av torner som de presset fast rundt hodet hans, og stakk en stav, som skulle forestille et kongespir, i høyre hånden hans og falt på kne og hånte han. ”Leve jødenes konge!” ropte de. ");
INSERT INTO norlb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","De spyttet på ham og tok staven og slo ham i hodet. ");
INSERT INTO norlb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Da de til slutt hadde blitt lei av å håne ham, tok de kappen av ham og kledde ham i hans egne klær og førte ham bort for å spikre ham fast på korset. ");
INSERT INTO norlb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","På veien til stedet der henrettelsen skulle skje, støtte soldatene på en mann fra Kyréne, som het Simon. Han tvang de til å bære korset til Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Da de kom ut til stedet som ble kalt for Golgata, som betyr Hodeskallen, ");
INSERT INTO norlb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ga soldatene vin som var blandet med galle til Jesus. Men da han merket hva det var ville han ikke drikke det. ");
INSERT INTO norlb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Da de hadde spikret Jesus fast på korset, delte de klærne hans mellom seg ved loddtrekning. ");
INSERT INTO norlb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Etterpå satte de seg ned for å holde vakt over ham. ");
INSERT INTO norlb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Over hodet til Jesus hadde de satt opp en plakat for å vise hva han ble anklaget for, og teksten lød: ”Dette er Jesus, jødenes konge”. ");
INSERT INTO norlb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sammen med Jesus ble også to forbrytere spikret faste på hvert sitt kors, en på hver side av han. ");
INSERT INTO norlb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","De som gikk forbi stedet der henrettelsen skjedde, hånte Jesus, ristet på hodet og sa: ");
INSERT INTO norlb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","”Var det ikke du som skulle rive ned templet og bygge det opp igjen på tre dager? Dersom du er Guds sønn, da hjelp deg selv og stig ned fra korset!” ");
INSERT INTO norlb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Øversteprestene, de skriftlærde og folkets ledere moret seg på hans bekostning. ");
INSERT INTO norlb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","”Han var god til å hjelpe andre”, sa de, ”men seg selv kan han ikke hjelpe! Skulle han liksom være Israels konge? Ja, dersom han stiger ned fra korset, da skal vi tro på ham! ");
INSERT INTO norlb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Han stoler på Gud. Nå får Gud frelse ham og bevise at han elsker ham. Han har jo sagt at han er Guds sønn.” ");
INSERT INTO norlb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","På samme måten ble han hånet av de to forbryterne som hadde blitt spikret fast på hvert sitt kors sammen med ham. ");
INSERT INTO norlb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Da klokka var tolv, ble det plutselig mørkt over hele landet, og mørket varte helt fram til klokka tre. ");
INSERT INTO norlb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Da klokka var omkring tre, ropte Jesus med kraftig stemme: ”Eli, Eli, lema sabaktani?”, det betyr: ”Min Gud, min Gud, hvorfor har du forlatt meg?” ");
INSERT INTO norlb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Noen av dem som sto der misforsto ham og trodde at han ropte på Elia. ");
INSERT INTO norlb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","En av dem sprang raskt fram og fylte en svamp med sur vin, satte den på en pinne og holdt den opp så han kunne drikke. ");
INSERT INTO norlb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Men de andre sa: ”La ham være, så får vi se om Elia kommer og redder han.” ");
INSERT INTO norlb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Men Jesus ropte på nytt med kraftig stemme og sluttet å puste. ");
INSERT INTO norlb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Samtidig revnet forhenget som hang foran Det aller helligste rommet i templet, i to deler fra toppen og helt ned. Jorden ristet, og fjellgrunnen slo sprekker slik at ");
INSERT INTO norlb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","gravene åpnet seg, og mange døde menn og kvinner som tilhørte Gud, ble levende igjen. ");
INSERT INTO norlb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","De dro fra sine graver, og da Jesus hadde stått opp fra de døde, gikk de inn i Guds by, Jerusalem, og viste seg for mange. ");
INSERT INTO norlb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Den romerske offiseren og soldatene som holdt vakt, ble fryktelig redde da de så jordskjelvet og alt som skjedde. De ropte: ”Denne mannen var virkelig Guds sønn.” ");
INSERT INTO norlb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Noen kvinner sto et lite stykke borte fra stedet der henrettelsen fant sted, og så alt som skjedde. Det var de kvinnene som hadde fulgt Jesus fra Galilea for å hjelpe ham. ");
INSERT INTO norlb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Blant dem var Maria Magdalena og Maria som var mor til Jakob og Josef, og moren til Sebedeus sine sønner, som het Jakob og Johannes. ");
INSERT INTO norlb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","På kvelden kom Josef, en rik mann fra Arimatea, som også hadde blitt en disippel av Jesus. ");
INSERT INTO norlb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Han gikk til Pilatus og ba om å få ta hånd om kroppen til Jesus. Pilatus ga befaling om at den skulle bli overlatt til ham. ");
INSERT INTO norlb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef tok kroppen, svøpte den i rent lintøy ");
INSERT INTO norlb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","og la den i en grav, som han nylig hadde fått hogget ut i fjellet til seg selv. Så rullet han en stor stein foran inngangen til graven og dro fra stedet. ");
INSERT INTO norlb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Både Maria Magdalena, og den andre Maria, ble værende igjen og satt i nærheten av graven. ");
INSERT INTO norlb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Neste dag, som var hviledagen, kom øversteprestene og fariseerne til Pilatus ");
INSERT INTO norlb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","og sa: ”Vi har kommet i tanker om at denne løgneren en gang sa at han skulle bli levende igjen etter tre dager. ");
INSERT INTO norlb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gi derfor befaling om at graven blir bevoktet i tre dager, slik at disiplene ikke kommer og stjeler kroppen og etterpå sier til alle at han har stått opp fra de døde. For da vil vi få et enda større problem å hanskes med.” ");
INSERT INTO norlb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus svarte: ”Jeg skal gi dere vakter. Så kan dere bevokte graven så godt dere kan.” ");
INSERT INTO norlb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","De gikk av sted og forseglet graven og plasserte vakter for å beskytte den fra inngrep utenfra. ");
INSERT INTO norlb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tidlig på søndagsmorgenen, dagen etter hviledagen, gikk Maria Magdalena og den andre Maria ut i morgendemringen for å passe på graven. ");
INSERT INTO norlb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Da ble det plutselig et voldsom jordskjelv, for en Herrens engel steg ned fra himmelen og rullet bort steinen og satte seg på den. ");
INSERT INTO norlb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ansiktet hans lyste som lynet, og klærne hans var hvite som snø. ");
INSERT INTO norlb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Da vaktene fikk se ham, ble de så vettskremte at de falt til jorden og lå som døde. ");
INSERT INTO norlb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Men engelen snakket til kvinnene og sa: ”Vær ikke redde! Jeg vet at dere leter etter Jesus, han som ble henrettet på et kors. ");
INSERT INTO norlb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Men han er ikke her. Han har blitt levende igjen, akkurat som han sa. Kom og se der kroppen hans lå. ");
INSERT INTO norlb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Skynd dere å fortelle til disiplene at han har stått opp fra de døde, og at han går i forveien for dem til Galilea for å treffe dem der. Dette er budskapet mitt.” ");
INSERT INTO norlb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kvinnene dro straks fra graven. De var forskremte, men samtidig glade og sprang for å fortelle disiplene det engelen hadde sagt. ");
INSERT INTO norlb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Da kom plutselig Jesus mot dem og hilste på dem. De gikk fram til ham og grep om føttene hans og tilba ham. ");
INSERT INTO norlb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesus sa til dem: ”Vær ikke redde! Gå og si til brødrene mine at de skal gi seg på vei til Galilea. Der skal de få se meg.” ");
INSERT INTO norlb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mens kvinnene var på vei fra graven, sprang noen av de vaktene som hadde stått der, til øversteprestene og fortalte det som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Øversteprestene diskuterte da saken med folkets ledere og ga vaktene en stor sum penger ");
INSERT INTO norlb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","og sa: ”Si at disiplene til Jesus kom midt på natten og stjal kroppen mens dere sov. ");
INSERT INTO norlb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dersom landshøvdingen får høre om det, skal vi ordne opp med ham. Dere trenger ikke å bekymre dere.” ");
INSERT INTO norlb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldatene tok derfor pengene og gjorde som det ble sagt til dem. Snart spredde dette ryktet seg blant jødene, som tror på det den dag i dag. ");
INSERT INTO norlb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","De elleve disiplene gikk nå til det fjellet i Galilea der Jesus hadde sagt at de skulle treffe ham igjen. ");
INSERT INTO norlb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Da de fikk øye på ham, tilba de ham, men noen tvilte fortsatt. ");
INSERT INTO norlb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Da gikk Jesus bort til dem og sa: ”Jeg har fått all makt i himmelen og på jorden. ");
INSERT INTO norlb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gå derfor ut til alle folk og gjør dem til mine disipler. Døp dem til fellesskap med Far i himmelen, Sønnen og Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Lær dem å leve på den måten jeg har underviste dere om. Og husk på at jeg alltid er med dere, helt til tidenes slutt.”");
INSERT INTO norlb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Her begynner det glade budskapet om Jesus Kristus, den lovede kongen, Guds sønn. ");
INSERT INTO norlb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Gud hadde forutsagt ved profeten Jesaja da han skrev: ”Lytt! Jeg sender min budbærer foran deg, han skal rydde veien for deg. ");
INSERT INTO norlb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","En stemme roper i ødemarken: ’Rydd vei for Herren! Gjør stiene rette for ham!’ ” ");
INSERT INTO norlb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Og nå viste denne budbæreren seg. Det var døperen Johannes. Han levde i ødemarken og underviste folk om at de kunne få syndene sine tilgitt dersom de vendte seg bort fra det onde, søkte Gud og lot seg døpe. ");
INSERT INTO norlb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mennesker fra hele Judea og Jerusalem gikk ut i ødemarken for å høre hva han hadde å si. Da de hadde bekjent syndene sine, døpte han dem i elven Jordan. ");
INSERT INTO norlb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johannes hadde klær som var laget av hår fra kamelene, og rundt midjen bar han et lærbelte. Maten han spiste, var gresshopper og honning fra ville bier. ");
INSERT INTO norlb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Han talte til folket og sa: ”Snart kommer en mann som er større enn meg. Han er så mektig at jeg ikke en gang er verdig til å bøye meg ned og løste opp remmene på sandalene hans. ");
INSERT INTO norlb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jeg døper dere med vann, men han skal døpe dere med Guds Hellige Ånd!” ");
INSERT INTO norlb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mens Johannes holdt på å døpe, dro Jesus fra hjembyen sin, Nasaret i Galilea. Han kom til elven Jordan og ble døpt av Johannes. ");
INSERT INTO norlb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Da Jesus steg opp av vannet, fikk han se himmelen åpne seg og Guds Ånd dale ned over ham som en due. ");
INSERT INTO norlb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","En stemme fra himmelen sa: ”Du er min elskede Sønn, du er min glede.” ");
INSERT INTO norlb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Straks etter dette førte Guds Ånd Jesus ut i ødemarken. Der oppholdt han seg i 40 dager og ble fristet av Satan. Han levde blant de ville dyrene, og englene tjente ham. ");
INSERT INTO norlb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Da kong Herodes litt seinere satte Johannes i fengsel, gikk Jesus tilbake til Galilea for å spre det glade budskapet fra Gud. ");
INSERT INTO norlb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Han sa: ”Tiden er kommet da Gud vil frelse menneskene og gjøre dem til sitt eget folk. Vend dere bort fra synden, vend om til Gud og tro på det glade budskapet!” ");
INSERT INTO norlb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","En dag da Jesus gikk langs Genesaretsjøen, fikk han se Simon og broren hans Andreas stå og kaste not i sjøen. De var fiskere. ");
INSERT INTO norlb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus ropte: ”Kom og bli disiplene mine, så skal jeg lære dere å fiske mennesker!” ");
INSERT INTO norlb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","De gikk straks fra fiskeutstyret sitt og fulgte ham. ");
INSERT INTO norlb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Da han gikk litt lenger langs stranden, fikk han se sønnene til Sebedeus, Jakob og Johannes. De satt i en båt og gjorde i stand garna sine. ");
INSERT INTO norlb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Han kalte også på dem, og de forlot faren Sebedeus og mannskapet hans for å bli med Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus og disiplene kom til byen Kapernaum. Da det ble hviledag, gikk de til synagogen der Jesus underviste folket. ");
INSERT INTO norlb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Alle var overrasket over undervisningen hans, for han lærte med autoritet, og ikke som de skriftlærde. ");
INSERT INTO norlb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","I synagogen var det denne dagen en mann som var besatt av en ond Ånd. Han begynte å skrike mot Jesus: ");
INSERT INTO norlb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","”Hva har du med oss å gjøre, Jesus fra Nasaret? Har du kommet for å ta knekken på oss? Jeg vet hvem du er, du Guds Hellige tjener!” ");
INSERT INTO norlb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Men Jesus snakket strengt til den onde ånden og sa: ”Ti! Far ut av ham!” ");
INSERT INTO norlb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Da begynte ånden å rykke og slite i mannen og for ut av ham med et voldsomt skrik. ");
INSERT INTO norlb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Folket som var i synagogen, ble helt forskrekket, begynte å diskutere med hverandre og stilte spørsmål: ”Hva er dette for en ny lære? Hvilken makt! Til og med de onde åndene lyder det han sier!” ");
INSERT INTO norlb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ryktet om ham gikk som en løpeild over hele Galilea. ");
INSERT INTO norlb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Da Jesus og disiplene hadde forlatt synagogen, gikk de hjem til Simon og Andreas, sammen med Jakob og Johannes. ");
INSERT INTO norlb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Der lå svigermoren til Simon syk med høy feber. Dette fortalte de straks til Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Han gikk da bort til henne, tok henne i hånden og reiste henne opp. Feberen forlot henne, og hun sto opp og laget mat til gjestene. ");
INSERT INTO norlb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","På kvelden, etter at solen hadde gått ned, kom de til ham med alle som var syke og besatte. ");
INSERT INTO norlb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Hver eneste innbygger i Kapernaum hadde samlet seg utenfor døren. ");
INSERT INTO norlb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus helbredet mange syke som led av ulike slags sykdommer, og han drev ut mange onde ånder. Men han forbød åndene å si noe etter som de visste hvem han var. ");
INSERT INTO norlb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Neste morgen, lenge før det lysnet, gikk Jesus bort til en skjermet plass for å kunne be i ro og fred. ");
INSERT INTO norlb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon og de andre skyndte seg ut for å finne ham. ");
INSERT INTO norlb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Da de hadde funnet ham sa de: ”Alle spør etter deg.” ");
INSERT INTO norlb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Men han svarte: ”Vi må gå til de andre byene her i nærheten, slik at jeg kan spre budskapet mitt også der. Det er derfor jeg er kommet hit.” ");
INSERT INTO norlb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","I tiden som fulgte, gikk de over hele Galilea og talte budskapet i synagogene og drev ut mange onde ånder. ");
INSERT INTO norlb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","En gang kom en spedalsk mann og falt ned på kne for ham og ba: ”Om du vil, da kan du gjøre meg frisk.” ");
INSERT INTO norlb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus ble grepet av medfølelse, rakte ut hånden, rørte ved ham og sa: ”Det vil jeg. Du er frisk!” ");
INSERT INTO norlb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Straks forsvant spedalskheten, og mannen var frisk. ");
INSERT INTO norlb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus sendte ham av sted og sa strengt til ham: ");
INSERT INTO norlb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","”Ikke fortell dette til noen, men gå til presten og la han undersøke deg. Ta med deg det offeret som Moses har bestemt at de som blir friske fra spedalskhet, skal gi. Da vil alle forstå at Gud har helbredet deg.” ");
INSERT INTO norlb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Men mannen gikk straks av sted og fortalte til alle han møtte, at han hadde blitt frisk. Jesus kunne ikke vise seg åpent lenger i noen by, men måtte holde seg diskré ute i ødemarken. Likevel fant folk ham, og kom til ham fra alle kanter. ");
INSERT INTO norlb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Noen dager seinere kom Jesus på nytt til Kapernaum. Nyheten om at ham var kommet, spredde seg raskt i byen. ");
INSERT INTO norlb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Snart var huset der han bodde, så fullt av folk at de sto langt ute på gaten og tråkket på hverandre. Han talte til dem om budskapet fra Gud. ");
INSERT INTO norlb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Da kom fire menn bærende på en lam mann som lå på en liggematte. ");
INSERT INTO norlb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","De klarte ikke å trenge seg inn på grunn av folkemassen, og kunne derfor heller ikke komme fram til Jesus. De laget hull i taket over der han satt. Gjennom åpningen firte de ned liggematten med den lamme mannen. ");
INSERT INTO norlb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Da Jesus så hvor stor tro de hadde, sa han til den lamme: ”Min sønn, jeg har tilgitt syndene dine!” ");
INSERT INTO norlb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Men noen av de skriftlærde som satt der, mumlet for seg selv: ");
INSERT INTO norlb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","”Hvordan kan han snakke på denne blasfemiske måten og spotte Gud? Det er jo bare Gud som kan tilgi synder.” ");
INSERT INTO norlb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus forsto i sin Ånd hva de tenkte, og sa til dem: ”Hvorfor tenker dere at dette er å spotte? ");
INSERT INTO norlb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Er det ikke like umulig for et menneske å si til den lamme: ’Reis deg opp, ta liggematten og gå’ som å si: ’Jeg tilgir deg syndene dine’?” ");
INSERT INTO norlb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Så vendte han seg mot den lamme og sa: ”For å bevise at jeg, Menneskesønnen, har makt til å tilgi synder her på jorden, så sier jeg til deg: ’Reis deg opp, ta liggematten og gå!’ ” ");
INSERT INTO norlb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Da reiste mannen seg, rullet straks sammen liggematten og gikk ut, rett foran øynene på de sjokkerte tilskuerne som hyllet Gud og ropte: ”Aldri før har vi sett noe slikt!” ");
INSERT INTO norlb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Så fortsatte Jesus langs Genesaretsjøen. Store folkemasser kom til ham, og han underviste dem. ");
INSERT INTO norlb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mens han dro fram, fikk han se Levi, som var sønn til Alfeus, sitte ved tollboden. ”Kom og bli min disippel”, sa Jesus til ham. Levi reiste seg og fulgte Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Senere da Jesus og disiplene spiste sammen i huset til Levi, hadde mange av Levis gamle kolleger i tolletaten blandet seg med gjestene. Også noen andre ukjente folk var på plass i selskapet. Mange av disse hadde begynt å følge Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Da de skriftlærde og fariseerne så Jesus i dette selskapet, sa de til disiplene: ”Er han virkelig falt så dypt at han spiser sammen med tollere og syndere?” ");
INSERT INTO norlb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus hørte det som ble hvisket, og sa: ”Det er ikke de friske som trenger lege, men de syke. Min oppgave her på jorden er å føre syndere tilbake til Gud, ikke å ta hånd om de som allerede gjør Guds vilje.” ");
INSERT INTO norlb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Disiplene til døperen Johannes og fariseerne$1 fastet regelmessig. En dag kom noen og spurte Jesus hvorfor ikke disiplene hans fastet, siden dette var vanlig både hos Johannes og fariseerne. ");
INSERT INTO norlb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus svarte: ”Bryllupsgjestene kan da vel ikke faste og gå sultne mens brudgommen ennå er hos dem? Nei, så lenge brudgommen er sammen med dem, kan de ikke faste. ");
INSERT INTO norlb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Men den dagen han blir tatt fra dem, da kommer de til å faste. ");
INSERT INTO norlb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Alt har sin rette tid! Ingen lapper for eksempel et gammelt klesplagg med et stykke nytt tøy som aldri har blitt vasket. Da vil det nye tøyet krympe og rive i stykker plagget, slik at hullet blir enda større. ");
INSERT INTO norlb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Heller ikke slår noen ny vin i gamle vinsekker, for når vinen gjærer, vil sekkene bli sprengt og alt blir ødelagt, både vinen og sekkene. Nei, ny vin slår de i nye skinnsekker som tåler trykket.” ");
INSERT INTO norlb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","En gang da det var hviledag, gikk Jesus og disiplene langs en kornåker. Mens de gikk, nappet disiplene en håndfull aks for å spise. ");
INSERT INTO norlb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Noen av fariseerne sa da til Jesus: ”Hvorfor gjør de dette? Det er jo forbudt etter Moseloven å høste på hviledagen.” ");
INSERT INTO norlb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Men Jesus svarte dem: ”Har dere aldri lest hva kong David og mennene hans gjorde den gangen da Abjatar var øversteprest, og de ble sultne og ikke hadde noe å spise? David gikk inn i Guds hus og spiste av det spesielle brødet som bare prestene hadde lov til å spise. Han lot også mennene sine spise det. Dette var jo også et slags brudd mot loven.” ");
INSERT INTO norlb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Så sa Jesus til fariseerne: ”Husk på at hviledagen ble skapt for menneskene sin skyld, og ikke menneskene for hviledagen sin skyld. ");
INSERT INTO norlb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Derfor har jeg, Menneskesønnen, rett til å avgjøre hva som er tillatt på hviledagen.” ");
INSERT INTO norlb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","En annen gang gikk Jesus inn i en synagoge. Der satt det en mann som hadde en handikappet hånd. ");
INSERT INTO norlb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Etter som det var hviledag, holdt fariseerne skarpt øye med Jesus. Skulle han våge å helbrede hånden til mannen på hviledagen? I så tilfelle ville de få noe å anklage ham for. ");
INSERT INTO norlb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus sa til mannen med den handikappede hånden: ”Reis deg og kom fram til meg.” ");
INSERT INTO norlb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Så spurte han fariseerne: ”Hva er tillatt å gjøre på hviledagen i følge Moseloven? Skal vi gjøre godt eller skal vi gjøre ondt? Skal vi redde liv eller skal vi ta liv?” Men ingen ville svare ham. ");
INSERT INTO norlb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Da så han på dem med sinne i blikket, dypt bedrøvet over den likegyldigheten de hadde for menneskelig nød. Til mannen sa han: ”Rekk fram hånden din.” Da mannen gjorde det, ble hånden frisk og normal igjen! ");
INSERT INTO norlb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Men fariseerne dro fra synagogen og begynte straks å legge planer sammen med tilhengerne til kong Herodes, om å få Jesus arrestert og drept. ");
INSERT INTO norlb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesus og disiplene trakk seg nå tilbake til stranden ved Genesaretsjøen. Mye folk fra Galilea, Judea, Jerusalem og Idumea, og fra den andre siden av Jordan og helt borte fra Tyrus og Sidon, fulgte ham. Ryktet om alle miraklene hans hadde spredd seg vidt og bredt omkring, og folket strømmet nå til for å se hva som foregikk. ");
INSERT INTO norlb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesus ba disiplene om å få tak i en båt og legge den klar i tilfelle folkemassen kom til å presse ham ut i vannet. ");
INSERT INTO norlb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mange hadde blitt helbredet denne dagen, og de syke presset på fra alle kanter for å røre ved ham. ");
INSERT INTO norlb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Da mannen som var besatt av onde ånder, fikk øye på han falt han ned ved føttene hans og ropte: ”Du er Guds sønn!” ");
INSERT INTO norlb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Men Jesus forbød åndene å avsløre hvem han var. ");
INSERT INTO norlb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Senere gikk Jesus opp på et fjell og tok med seg noen av dem han hadde valgt ut. Da de var samlet rundt ham, ");
INSERT INTO norlb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","valgte han tolv av dem for å følge ham, og for å bli sendt ut med budskapet til folket. ");
INSERT INTO norlb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Han ga dem makt til å drive ut onde ånder. ");
INSERT INTO norlb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","De tolv han hadde valgt, var: Simon, som han ga navnet Peter, ");
INSERT INTO norlb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeus sine sønner som het Jakob og Johannes, og som han kalte ”tordensønnene”, ");
INSERT INTO norlb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filip, Bartolomeus, Matteus, Tomas og Jakob, sønnen til Alfeus, Taddeus og Simon ”seloten” ");
INSERT INTO norlb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","og Judas Iskariot, han som seinere forrådte Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Da Jesus kom tilbake til huset der han bodde, begynte folk å samle seg på nytt. Snart var huset så fullt at verken Jesus eller disiplene fikk tid til å spise. ");
INSERT INTO norlb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Da familien hans fikk høre dette, gikk de dit for å ta hånd om ham. ”Han er gått fra vettet!” sa de. ");
INSERT INTO norlb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Men de skriftlærde som hadde kommet fra Jerusalem, sa: ”Han er besatt av Satan, høvdingen over de onde ånder. Det er derfor de onde åndene er lydige mot ham.” ");
INSERT INTO norlb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus kalte da til seg disse mennene og forklarte saken ved å illustrere med et bilde. Han sa: ”Hvordan kan Satan drive ut sine egne onde ånder? ");
INSERT INTO norlb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Et rike som kommer i strid med seg selv, går jo under. ");
INSERT INTO norlb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Og en familie der medlemmene strider mot hverandre, opphører snart å eksistere som en enhet. ");
INSERT INTO norlb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dersom Satan strider mot seg selv, da kan han ikke fortsette å styre riket sitt. Da er det snart ute med han. ");
INSERT INTO norlb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nei, nå skal dere høre hvordan det er: Satan er som en sterk mann. Vil noen gå inn i huset til den sterke mannen og rane ham for det han eier, da må de først binde ham. Etterpå kan de gå inn i huset og rane verdiene hans. ");
INSERT INTO norlb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","En ting vil jeg at dere skal ha klart for dere: Menneskene kan få tilgivelse for alle slags synder, til og med hån og spott mot Gud, uansett hvor grovt de enn spotter. ");
INSERT INTO norlb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Men den som håner og spotter Guds Hellige Ånd, kan aldri få tilgivelse. Det er en utilgivelig synd.” ");
INSERT INTO norlb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Dette sa han fordi de påsto at han gjorde miraklene sine ved Satans kraft og ikke i kraften fra Guds Ånd. ");
INSERT INTO norlb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Nå kom moren til Jesus og brødrene hans til det overfylte huset der han underviste. Etter som de selv ikke kunne komme inn, sendte de bud til ham og ba ham å komme ut. De som satt rundt Jesus, sa til han: ”Moren din og brødrene dine står utenfor og vil treffe deg.” ");
INSERT INTO norlb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Men han svarte: ”Moren min og brødrene mine! Hvem er det?” ");
INSERT INTO norlb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Han så på dem som satt rundt seg og sa: ”Dette er moren min og søsknene mine. ");
INSERT INTO norlb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Hver og en som gjør Guds vilje, er min bror og min søster og moren min.” ");
INSERT INTO norlb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Noe seinere begynte Jesus på nytt å undervise nede ved sjøen. Folkemassen som samlet seg rundt ham var så stor at han ble tvunget til å stige om bord i en båt og sitte i den ute på vannet mens han talte til folket som sto på stranden. ");
INSERT INTO norlb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Han underviste dem ved å fortelle mange bilder, som for eksempel dette. Han sa: ");
INSERT INTO norlb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","”Lytt! En bonde gikk ut på åkeren sin for å så. ");
INSERT INTO norlb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Da han sådde, falt noe av såkornet på veien langs åkeren, og fuglene kom og spiste det opp. ");
INSERT INTO norlb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Noe korn falt der jorden var steinete og jordlaget tynt. Plantene vokste raskt opp, ");
INSERT INTO norlb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","men i den steikende solen visnet de og tørket bort, etter som røttene var grunne. ");
INSERT INTO norlb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Andre korn falt blant tistlene. Da tistlene vokste opp, kvalte de kornplantene slik at de ikke ga noen avling. ");
INSERT INTO norlb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mest korn falt i den fruktbare jorden og vokste opp og ga rik avling. Noe ga 30, 60 og til og med 100 ganger så mye som den mengden såkorn som hadde blitt sådd.” ");
INSERT INTO norlb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesus sa: ”Lytt nøye og forsøk å forstå!” ");
INSERT INTO norlb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Da Jesus seinere var alene med disiplene og de andre som fulgte ham, spurte de: ”Hva betyr dette som du fortalte?” ");
INSERT INTO norlb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Han svarte: ”Dere har fått gaven til å forstå undervisningen min om hvordan Gud vil frelse menneskene og gjøre dem til sitt eget folk. De som ikke tilhører Guds eget folk, oppfatter dette bare som bilder, ");
INSERT INTO norlb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","for at ’de skal se hva jeg gjør, men likevel ikke fatte, og høre hva jeg sier, men likevel ikke forstå, og derfor kan de ikke vende om til Gud og få syndene sine tilgitt.’ ");
INSERT INTO norlb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dersom dere nå ikke forstår dette bildet om såkornet, hvordan skal dere da kunne skjønne de andre bildene mine? ");
INSERT INTO norlb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Det bonden sår, er budskapet fra Gud. ");
INSERT INTO norlb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Den harde veien, der noe av såkornet falt, ligner hjertet til det menneske som hører budskapet, men som snaut nok har hørt det til ende før Satan kommer og forsøker å få den som lyttet, til å glemme alt sammen. ");
INSERT INTO norlb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Den grunne og steinete jorden er lik hjertet til det menneske som hører budskapet og tar imot det med ekte glede, ");
INSERT INTO norlb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","men som ikke har særlig dybde i seg slik at røttene kan utvikle seg. Etter en tid, når vanskelighetene eller forfølgelsene dukker opp på grunn av troen, da avtar entusiasmen, og den som tok imot, forlater troen. ");
INSERT INTO norlb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jorden som var dekket av tistler, kan sammenlignes med det menneske som hører budskapet, ");
INSERT INTO norlb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","men lar de daglige bekymringene, lengselen etter å tjene mange penger og begjæret etter andre ting, få komme inn i hjertet og kvele budskapet, slik at det til slutt ikke påvirker livet i det hele tatt. ");
INSERT INTO norlb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Den fruktbare jorden ligner hjertet til et menneske som hører budskapet, tar det til seg og lar det påvirke hele livet. Disse som hører og tar imot, gir en avling som er 30, 60 eller til og med 100 ganger så stor mengde korn som ble sådd i hjertets gode jord.” ");
INSERT INTO norlb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Videre sa Jesus: ”Ingen tar fram en lampe og hvelver en eske over den eller setter den under en stol. Tvert imot! En lampe setter alle høyt og fritt, slik at den kan gi lys og være til nytte. ");
INSERT INTO norlb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","På samme måten skal alt som nå er skjult, en dag bli ført fram i lyset og være synlig for alle. ");
INSERT INTO norlb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Lytt nøye og forsøk å forstå! ");
INSERT INTO norlb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pass på at de ordene dere får høre, leder til handling. For jo mer dere omsetter ordene til praksis, desto mer kommer dere til å forstå hva jeg snakker om. ");
INSERT INTO norlb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ja, den som forstår undervisningen min, skal med tiden forstå mer og mer. Men den som forstår lite, skal til slutt miste også den minimale innsikten han hadde.” ");
INSERT INTO norlb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus fortalte også et annet bilde. Han sa: ”Der Gud regjerer, blir det som når en bonde strør ut såkornet sitt på åkeren. ");
INSERT INTO norlb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mannen sover og våkner, og alt etter som dagene går, begynner såkornet å gro og spire uten hans hjelp. ");
INSERT INTO norlb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Det er jorden som får såkornet til å gro. Først trenger spirene seg fram, så blir aksene formet, og til slutt er hveten moden. ");
INSERT INTO norlb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Da kommer bonden med sin sigd og høster hveten, etter som tiden til å høste er kommet.” ");
INSERT INTO norlb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus sa: ”Hvordan kommer det til å bli der Gud regjerer? Hvilket bilde skal jeg bruke? ");
INSERT INTO norlb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Jo, der Gud regjerer, blir det som når noen sår et sennepsfrø. Til tross for at sennepsfrøet er det minste av alle frø, vokser det opp og blir større enn alle andre krydderurter, og får så store greiner at fuglene kan bygge reir og finne ly mellom bladene.” ");
INSERT INTO norlb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus brukte titt og ofte slike bilder som dette for at folket skulle forstå, i den grad de nå var i stand til å forstå. ");
INSERT INTO norlb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ja, han talte faktisk aldri uten å fortelle noen bilder, men når han seinere ble alene med disiplene forklarte han bildene for dem. ");
INSERT INTO norlb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Da det ble kveld, sa Jesus til disiplene: ”Kom, nå drar vi over til den andre siden av sjøen.” ");
INSERT INTO norlb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","De trakk seg unna folket og reiste over sjøen i den båten der Jesus allerede satt. Flere andre båter fulgte også med. ");
INSERT INTO norlb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Da de hadde kommet et stykke ut, blåste det opp en voldsom storm. Høye bølger slo inn i båten slik at den nesten ble fylt med vann. ");
INSERT INTO norlb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mens dette skjedde, lå Jesus og sov akter i båten med hodet på en pute. Disiplene vekket ham og ropte fortvilt: ”Mester, merker du ikke at vi holder på å synke?” ");
INSERT INTO norlb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Da reiste han seg opp og snakket strengt til vinden og sjøen og sa: ”Ti! Bli stille!” Straks la sjøen seg, og det ble blikk stille. ");
INSERT INTO norlb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Så spurte han disiplene: ”Hvorfor er dere redde? Har dere fortsatt vanskelig for å tro?” ");
INSERT INTO norlb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Forskrekket sa de til hverandre: ”Hvem er han? Til og med vinden og sjøen er lydige mot ham.” ");
INSERT INTO norlb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","De kom over til den andre siden av sjøen, til området rundt Gerasenerlandet. ");
INSERT INTO norlb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Da Jesus steg ut av båten, løp en mann mot ham. Han holdt til blant de døde i gravhulene og var besatt av en ond Ånd. ");
INSERT INTO norlb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mannen var så vill at det ikke var mulig å binde ham på noen måte. ");
INSERT INTO norlb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Flere ganger hadde det blitt forsøkt å binde ham på hender og føtter. Hver gang hadde han slitt lenker og fotjern i stykker. Ingen var sterke nok til å rå med ham. ");
INSERT INTO norlb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dag og natt holdt han til blant gravene eller virret omkring oppe i fjellene og skrek og kuttet seg selv med skarpe steiner. ");
INSERT INTO norlb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mannen hadde allerede fått øye på Jesus da han var langt borte og kom nå stormende til og falt ned for ham. ");
INSERT INTO norlb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","”Gå bort fra meg Jesus, du den høyeste Guds sønn! For Guds skyld, du må ikke pine meg!” skrek han av all kraft. ");
INSERT INTO norlb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Grunnen til utropet var at Jesus like før hadde sagt: ”Far ut av mannen, du onde Ånd.” ");
INSERT INTO norlb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus spurte ham: ”Hva heter du?” Mannen svarte: ”Jeg heter legion, for vi er mange.” ");
INSERT INTO norlb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Gang på gang ba de onde åndene at Jesus ikke måtte jage dem bort fra området. ");
INSERT INTO norlb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Samtidig som dette skjedde, gikk en stor flokk griser og rotet i jorda etter røtter på fjellskrenten nær sjøen. ");
INSERT INTO norlb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","De onde åndene tigget og ba: ”Send oss av sted til grisene, så kan vi fare inn i dem”, ");
INSERT INTO norlb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Det lot Jesus dem få lov til. Da for de onde åndene ut av mannen og inn i grisene. Hele flokken på omkring 2 000 griser, styrtet utfor den bratte skråningen og druknet i sjøen. ");
INSERT INTO norlb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Røkterne som passet på grisene, sprang til den nærmeste byen og stedene rundt den og fortalte alt sammen. Folket gikk av sted for å finne ut hva som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","Da de kom fram til Jesus, fikk de se mannen som hadde hatt de onde åndene i seg sitte der, påkledd og fullt normal. Skrekkslagne hørte de på mens øyenvitnene fortalte om hvordan den besatte mannen hadde blitt satt fri, og hva som hadde skjedd med grisene. ");
INSERT INTO norlb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Da ba folket om at Jesus måtte forlate området deres. ");
INSERT INTO norlb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mens Jesus steg i båten, spurte mannen som hadde vært besatt, om at han kunne få å bli med. ");
INSERT INTO norlb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Men Jesus ville ikke ta ham med. ”Gå heller hjem til din familie og dine venner”, sa han, ”og fortell for alle hvilket stort mirakel Herren har gjort med deg. La dem få vite hvordan han hadde medfølelse med deg og kom deg til hjelp.” ");
INSERT INTO norlb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Da gikk mannen av sted og fortalte i hele Dekapolis om miraklet som Jesus hadde gjort med ham. Alle ble helt forundret da de hørte fortellingen hans. ");
INSERT INTO norlb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Da Jesus hadde dratt tilbake til andre siden av sjøen, samlet mye folk seg rundt ham. Mens han var der på stranden, ");
INSERT INTO norlb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","kom lederen for synagogen til ham. Han het Jairus. Så fort han fikk øye på Jesus, kastet han seg fortvilt ned for føttene hans ");
INSERT INTO norlb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","og sa: ”Den lille jenta mi holder på å dø. Jeg ber deg, kom og legg hendene på henne, slik at hun blir frisk igjen.” ");
INSERT INTO norlb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Straks ble Jesus med ham, og mye folk fulgte med og presset på fra alle kanter. ");
INSERT INTO norlb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","I folkemassen var en kvinne som i tolv års tid hadde lidd av blødninger. ");
INSERT INTO norlb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hun hadde store plager og var blitt behandlet av mange leger. Til tross for at hun hadde brukt opp alt hun eide på legebesøk og medisiner for å bli frisk, hadde hun ikke blitt bedre. Heller til det verre. ");
INSERT INTO norlb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nå hadde hun hørt om alle de merkelige miraklene som Jesus gjorde. Derfor presset hun seg fram i folkemassen bak Jesus og rørte ved kappen hans. ");
INSERT INTO norlb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","For hun tenkte at dersom hun bare fikk røre ved klærne hans, så ville hun bli frisk. ");
INSERT INTO norlb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Og så snart hun rørte ved ham, stanset blødningene, og hun kjente at hun var fri fra lidelsen sin. ");
INSERT INTO norlb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus merket i det samme at det gikk ut en kraft fra ham. Han vendte seg rundt og spurte: ”Hvem rørte ved klærne mine?” ");
INSERT INTO norlb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Disiplene sa til ham: ”Folk trenger deg jo fra alle kanter, selvfølgelig må noen ha rørt ved deg!” ");
INSERT INTO norlb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Men Jesus så seg omkring for å få greie på hvem som hadde gjort det. ");
INSERT INTO norlb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kvinnen ble forskrekket, etter som hun visste hva som hadde skjedd med henne. Hun kom skjelvende fram og falt ned for Jesus og fortalte hvordan alt hadde gått til. ");
INSERT INTO norlb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Da sa Jesus til henne: ”Min datter, troen din har hjulpet deg. Gå i fred. Du er satt fri fra lidelsen din.” ");
INSERT INTO norlb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mens Jesus fortsatt snakket med kvinnen, kom noen med beskjed fra hjemmet til Jairus og meldte til faren: ”Jenten din er død. Det har ingen hensikt at du bryr Mesteren lenger.” ");
INSERT INTO norlb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Men Jesus tok ikke notis av ordene deres, men sa til Jairus: ”Ikke vær redd! Fortsett bare å tro.” ");
INSERT INTO norlb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Lenger framme lot han bare Peter, Jakob og Johannes følge med helt fram. ");
INSERT INTO norlb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Da de kom fram til Jairus sitt hjem, så Jesus at huset var fullt av mennesker som høylytt gråt og klaget. ");
INSERT INTO norlb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Han gikk inn til dem og sa: ”Hvorfor gråter dere og er så opprørte? Jenten er ikke død, hun sover bare!” ");
INSERT INTO norlb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Da begynte de å hånle mot ham, men ha jaget alle sammen ut og tok med seg faren og moren til jenta, sammen med de tre disiplene, og gikk inn i rommet der jenta lå. ");
INSERT INTO norlb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Så tok han jenta i hånden og sa til henne: ”Talita kumi!” Ordene betyr: Lille jente, jeg sier deg: Reis deg opp! ");
INSERT INTO norlb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jenten, som var tolv år gammel, reiste seg straks opp og begynte å gå omkring. Foreldrene gned seg i øynene av forskrekkelse. ");
INSERT INTO norlb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus forbød dem å fortelle til noen om det som hadde skjedd. Etterpå ba han at de måtte gi jenta noe å spise. ");
INSERT INTO norlb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Etter dette utrolige miraklet dro Jesus fra stedet og kom til hjembyen sin Nasaret, sammen med disiplene. ");
INSERT INTO norlb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Da det ble hviledag, gikk han til synagogen for å undervise, og mange ble overrasket over visdommen hans, og de miraklene han gjorde med folk som han la hendene på. ”Hvor har han alt dette fra?” sa de. ");
INSERT INTO norlb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","”Han er jo bare en vanlig snekker, Maria sin sønn, bror til Jakob, Joses, Judas og Simon, og søstrene hans bor også midt iblant oss.” Mange ble irriterte og sinte på ham. ");
INSERT INTO norlb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Da sa Jesus: ”En profet som bringer Guds budskap, blir anerkjent over alt, bortsett fra i sin egen hjemby, blant sine slektninger og i sin egen familie.” ");
INSERT INTO norlb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Etter som folket i Nasaret ikke trodde på ham, kunne han ikke gjøre noen mirakler der. Han helbredet bare noen få syke ved å legge hendene på dem. ");
INSERT INTO norlb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Han var forskrekket over at folket ikke ville tro på ham. Noe seinere dro Jesus rundt i byene i distriktet og underviste. ");
INSERT INTO norlb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Han kalte til seg sine tolv disipler og sendte dem ut to og to og ga dem makt til å drive ut onde ånder. ");
INSERT INTO norlb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Han sa til dem at de ikke skulle ta med seg noe annet på veien enn sin vandringsstav. De fikk ikke ta med mat, ingen veske, ingen penger, og ikke ekstra sko eller klær. ");
INSERT INTO norlb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","”Når dere blir tilbudt å overnatte hos noen, stans da hos dem til dere skal fortsette til neste by”, sa han. ");
INSERT INTO norlb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","”Dersom folket på et sted ikke vil ta imot dere eller høre på dere, gå da bare videre og ikke vær mer bekymret for dem. Rist støvet fra dette stedet av føttene som et tegn på at innbyggerne selv må ta ansvaret for det de har gjort.” ");
INSERT INTO norlb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Disiplene gikk nå av sted. Over alt der de kom, oppfordret de folket til å forlate syndens vei og vende om til Gud. ");
INSERT INTO norlb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","De drev ut mange onde ånder og salvet mange syke med olje og helbredet dem. ");
INSERT INTO norlb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Snart fikk også kong Herodes høre snakk om Jesus, etter som ryktet om ham spredde seg over alt. Folk sa: ”Det er døperen Johannes som har stått opp fra de døde. Det er derfor han kan gjøre slike mirakler.” ");
INSERT INTO norlb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Men noen sa: ”Jesus er Elia.” Andre sa: ”Han er virkelig en profet som bringer Guds budskap, akkurat som profetene før i tiden.” ");
INSERT INTO norlb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","”Nei”, sa Herodes, ”det er Johannes, han som jeg lot halshugge. Han har stått opp fra de døde.” ");
INSERT INTO norlb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes hadde nemlig arrestert Johannes og latt ham binde og kaste i fengsel. Grunn til dette var kona til Herodes som het Herodias. Hun hadde først vært gift med Filip, som var bror til kongen. Til tross for dette hadde likevel Herodes giftet seg med henne. ");
INSERT INTO norlb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johannes hadde sagt rett ut til ham: ”Det er ikke tillatt for deg å leve sammen med kona til din bror.” ");
INSERT INTO norlb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Derfor hatet Herodias ham og ville drepe Johannes, men Herodes var imot dette. ");
INSERT INTO norlb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Innerst inne hadde han respekt for Johannes og ville beskytte ham, for han visste at Johannes var en god mann som levde etter Guds vilje. Hvert gang han hørte Johannes, kjente han seg usikker og visste ikke riktig hva han skulle tro. Han lyttet gjerne til det Johannes hadde å si. ");
INSERT INTO norlb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Til slutt fikk i alle fall Herodias sin sjanse. Herodes feiret sin fødselsdag og stilte opp med en fest for hoffolket, offiserene og de fremste mennene i Galilea. ");
INSERT INTO norlb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Og mens festen pågikk, kom datteren til Herodias inn og danset. Kong Herodes og gjestene hans ble svært begeistret, og kongen sa til jenta: ”Be meg om hva du vil, og jeg skal gi deg det.” ");
INSERT INTO norlb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Og så sverget han i påhør av gjestene og gjentok: ”Ja, hva du så enn ber om, det skal du få, om det så er halvdelen av mitt rike.” ");
INSERT INTO norlb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hun gikk da ut og spurte moren sin hva hun skulle be om. Moren svarte: ”Be om døperen Johannes sitt hode!” ");
INSERT INTO norlb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jenten skyndte seg tilbake til kongen og sa: ”Jeg vil ha hodet til døperen Johannes på et fat, nå straks!” ");
INSERT INTO norlb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kongen ble svært lei deg, men på grunn av løftet sitt, og etter som han ikke ville ta tilbake det han hadde sagt i påhør av gjestene, lot han henne få det som hun ville. ");
INSERT INTO norlb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Han ga derfor befaling til en av livvaktene sine om å gå for å hente døperen Johannes sitt hode. Mannen gikk av sted til fengslet og halshogg Johannes ");
INSERT INTO norlb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","og kom tilbake med hodet hans på et fat. Han ga det til jenta, som i sin tur bar det til moren sin. ");
INSERT INTO norlb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Da disiplene til Johannes hørte det som hadde skjedd, kom de og hentet kroppen hans og begravde Johannes. ");
INSERT INTO norlb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","De tolv disiplene som Jesus hadde sendt ut, kom nå tilbake fra reisene sine. De rapporterte om alt det de hadde gjort og undervist folket om. ");
INSERT INTO norlb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Etter som det var så mye folk rundt dem at de ikke fikk tid til å spise, foreslo Jesus: ”Kom så trekker vi oss bort til et øde sted der dere kan hvile dere litt.” ");
INSERT INTO norlb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Og de dro sin vei med båt til et øde sted. ");
INSERT INTO norlb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mange så at de reiste sin vei og skyndte seg til fots rundt sjøen. Der møtte de Jesus igjen da han steg i land på andre siden. ");
INSERT INTO norlb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus steg ut av båten og fikk se alle menneskene som hadde samlet seg. Han fikk medfølelse med dem, for de var som sauer uten gjeter. Derfor tok han seg tid og underviste dem lenge og vel om det de så sårt trengte å vite. ");
INSERT INTO norlb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Fram mot kvelden kom disiplene til ham og sa: ”Det er allerede seint, og det finnes ikke noe å spise her i ødemarken. Send folket av sted, slik at de kan gå til byene og gårdene i nærheten og kjøpe mat.” ");
INSERT INTO norlb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Men Jesus sa: ”Dere kan selv gi dem mat!” ”Hvordan da?” spurte disiplene. ”Det ville jo koste en formue å kjøpe mat til alle sammen.” ");
INSERT INTO norlb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","”Hvor mye mat har dere?” spurte han. ”Gå og se etter.” De kom tilbake og rapporterte at det var fem brød og to fisker. ");
INSERT INTO norlb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Jesus ba dem da å si til folket at de skulle sette seg ned i grupper på 50 eller 100 personer der det var grønt gress på bakken. ");
INSERT INTO norlb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Han tok de fem brødene og de to fiskene, så opp mot himmelen og takket Gud for maten. Etterpå brøt han brødene i biter og ga hver av disiplene litt brød og fisk, som de igjen skulle gi videre til folket. ");
INSERT INTO norlb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Alle spiste og ble mette. ");
INSERT INTO norlb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Til slutt samlet de opp tolv kurver fulle med brød og fisk. ");
INSERT INTO norlb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Det var 5 000 menn som hadde spist, og i tillegg kom kvinnene og barna. ");
INSERT INTO norlb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Straks etter dette ba Jesus disiplene om å sette seg i båten og dra i forveien til Betsaida på den andre siden av sjøen. Selv stanset han igjen for å se at folket begynte på hjemveien. ");
INSERT INTO norlb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Da han hadde fått folket av sted, gikk han opp på et fjell for å be. ");
INSERT INTO norlb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Utpå kvelden var disiplene fortsatt langt ute på sjøen i båten sin. Jesus, som nå var alene på land, ");
INSERT INTO norlb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","så hvordan de slet med årene etter som de hadde fått motvind. Like før det begynte å lysne kom Jesus gående mot disiplene på vannet. ");
INSERT INTO norlb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Men da de så ham gå på vannet, skrek de av redsel. De trodde det var et spøkelse. ");
INSERT INTO norlb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Alle så Jesus og ble livredde. Jesus snakket straks til dem og sa: ”Ro dere ned, det er meg. Vær ikke redde.” ");
INSERT INTO norlb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Så steg han opp i båten til dem, og i samme øyeblikk la vinden seg. Disiplene var helt forundret. ");
INSERT INTO norlb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","De hadde ennå ikke fattet hvem Jesus var og hadde vanskelig for å tro til tross for det store miraklet kvelden før, da hele folket hadde fått brød å spise. ");
INSERT INTO norlb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Da Jesus og disiplene hadde dratt over sjøen, kom de til Gennesaret og gikk i land. ");
INSERT INTO norlb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Så snart de steg ut av båten, kjente folket Jesus igjen. ");
INSERT INTO norlb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","De sprang rundt i hele området for å spre nyheten om at han var der. Folk begynte å bære syke mennesker som lå på liggematter til stedene der de hørte at Jesus befant seg. ");
INSERT INTO norlb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ja, over alt der han kom, på småsteder, byer og gårder, bar de ut i fri luft dem som var syke og ba om at de syke i det minste kunne få røre ved dusken ytterst på kappen hans. Og alle som gjorde det, ble friske! ");
INSERT INTO norlb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","En dag kom noen fariseere og skriftlærde fra Jerusalem for å stille spørsmål til Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","De la merke til at flere av disiplene spiste brød uten først å ha vasket hendene. ");
INSERT INTO norlb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jødene, og særlig fariseerne, følger spesielle regler som de har arvet fra forfedrene. De spiser aldri uten først å ha vasket hendene. ");
INSERT INTO norlb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Når de kommer hjem fra markedsplassen, må de alltid vaske seg før de rører noe mat. Det finnes også mange andre tradisjoner som de er nøye med å følge, som for eksempel å skylle krus, kar og kobberkjeler. ");
INSERT INTO norlb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fariseerne og de skriftlærde spurte derfor Jesus: ”Hvorfor holder ikke disiplene dine seg til våre gamle jødiske regler? De spiser jo uten først å ha vasket hendene.” ");
INSERT INTO norlb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus svarte: ”Dere er falske mennesker som bare later som om dere er lydige mot Gud! Profeten Jesaja hadde rett da han bar fram Guds budskap om dere og sa: ’Dette folket ærer meg med ordene sine, men de nekter å være lydige mot meg. ");
INSERT INTO norlb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Deres tilbedelse er verdiløs, for det de lærer, er menneskelige regler og ikke Guds bud.’ ");
INSERT INTO norlb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Ja, dere bryr dere ikke om Guds bud og erstatter dem med egne menneskelige regler. Syns dere det er en god måte å følge Guds bud på? ");
INSERT INTO norlb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses ga dere for eksempel disse budene fra Gud: ’Vis respekt for foreldrene dine’, og: ’Den som forbanner foreldrene sine, skal bli dømt til døden.’ ");
INSERT INTO norlb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Dere påstår at dere slett ikke trenger å respektere foreldrene deres, eller ta hånd om dem når de blir gamle, dersom dere bare i stedet gir pengene som foreldrene skulle hatt, som en gave til templet. ");
INSERT INTO norlb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Da gjør dere Guds konkrete befaling ugyldig ved å følge egne tradisjoner. Dette er bare ett av eksemplene. Det finnes mange, mange flere.” ");
INSERT INTO norlb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus kalte folket til seg og sa: ”Hør alle sammen og forsøk å forstå det jeg sier. ");
INSERT INTO norlb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dere blir ikke uverdige innfor Gud på grunn av det dere spiser og stapper i munnen. Det er ordene deres, tankene og handlingene, det som springer ut fra dere, som gjør at dere blir uverdige.” ");
INSERT INTO norlb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Da Jesus hadde forlatt folkemassen og var kommet hjem igjen, spurte disiplene hva han mente med det han nettopp hadde sagt. ");
INSERT INTO norlb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","”Forstår heller ikke dere det?” spurte han. ”Innser dere ikke at det dere spiser, aldri kan gjøre dere uverdige innfor Gud? ");
INSERT INTO norlb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maten har ikke noe med forholdet til Gud å gjøre, den passerer bare gjennom magen og kommer ut igjen.” På denne måten forklarte Jesus at all mat er godkjent av Gud og tillatt å spise. ");
INSERT INTO norlb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Og han la til: ”Det som gjør et menneske uverdig innfor Gud, er det som springer ut fra menneskets indre, fra hjertet. ");
INSERT INTO norlb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Fra hjertet kommer onde tanker, seksuell løssluppenhet, tyveri, mord, utroskap i ekteskapet, egoisme, ");
INSERT INTO norlb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ondskap, bedrageri, et vilt og umoralsk liv, misunnelse, sladder, hovmod og all annen uforstand. ");
INSERT INTO norlb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Alt dette kommer innefra, og det er det som gjør et menneske uverdig innfor Gud.” ");
INSERT INTO norlb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus dro nå fra Galilea og gikk til distriktet ved byen Tyrus. Der fant han et hus å innlosjere seg i. Han forsøkte å holde hemmelig at han var kommet, men det var umulig. ");
INSERT INTO norlb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","En mor med en datter som var besatt av en ond Ånd, fikk høre om ham og oppsøkte ham straks. Kvinnen kastet seg ned for føttene til Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Hun ba om at han måtte sette jenta fri fra den onde ånden. Denne kvinnen var ikke jøde, men kom fra distriktet bortenfor. ");
INSERT INTO norlb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus sa derfor til henne: ”Først må jeg hjelpe mine egne barn som er jødene. Det er ikke rett å ta brødet fra barna og kaste det til hundene.” ");
INSERT INTO norlb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hun svarte: ”Det er sant, Herre, men til og med hundene som ligger under bordet, får spise de smulene som barna lar ligge igjen.” ");
INSERT INTO norlb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","”Svaret ditt viser hvor sterk tro du har”, sa han. ”Gå hjem, for den onde ånden har forlatt datteren din!” ");
INSERT INTO norlb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Da hun kom hjem, lå jenta rolig i sengen, og den onde ånden var borte. ");
INSERT INTO norlb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Fra Tyrus gikk Jesus videre til byen Sidon, og derfra tilbake til Genesaretsjøen om Dekapolis. ");
INSERT INTO norlb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Der kom noen til han med en døv mann, som også hadde vanskelig for å snakke. De ba at Jesus måtte legge hendene på ham og helbrede ham. ");
INSERT INTO norlb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus førte ham da litt unna folkemassen, satte fingrene i ørene hans, tok spytt og rørte ved tungen hans. ");
INSERT INTO norlb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesus så opp mot himmelen, sukket dypt og sa: ”Effata!” som betyr: Lukk deg opp! ");
INSERT INTO norlb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Straks kunne mannen høre helt perfekt, og han snakket klart og tydelig. ");
INSERT INTO norlb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus forbød folket å fortelle om det som hadde skjedd. Men jo mer han nektet, desto mer spredde de nyheten vidt og bredt. ");
INSERT INTO norlb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","De syntes det var så helt utrolig, og de sa: ”Alt han gjør, er helt fantastisk! Han får til og med de døve til høre og de stumme til å snakke.” ");
INSERT INTO norlb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","På nytt var mye folk samlet, og de hadde ikke noe å spise. Jesus ba da disiplene komme bort til seg og sa: ");
INSERT INTO norlb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","”Jeg føler sterkt med folket. De har vært hos meg i tre dager og har ikke noe å spise. ");
INSERT INTO norlb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Dersom jeg sender dem hjem uten at de har fått mat, kan de besvime av utmattelse langs veien. Noen av dem bor jo langt herfra.” ");
INSERT INTO norlb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Disiplene svarte: ”Hvor skal vi få tak i nok mat til alle disse menneskene her i ødemarken?” ");
INSERT INTO norlb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus spurte: ”Hvor mange brød har dere?” ”Sju”, svarte de. ");
INSERT INTO norlb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Da ba Jesus folket å slå seg ned på bakken. Han tok de sju brødene, takket Gud for maten og brøt dem i biter. Bitene ga han til disiplene, som i sin tur delte dem ut til folket. ");
INSERT INTO norlb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","I tillegg hadde de noen små fisker. Jesus takket Gud også for dem og ba disiplene å dele ut. ");
INSERT INTO norlb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Alle spiste og ble mette. Da de til slutt samlet sammen det som var til overs, ble det sju fulle kurver. ");
INSERT INTO norlb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Det var omkring 4 000 personer til stede. Etterpå sendte Jesus folket hjem. ");
INSERT INTO norlb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Han steg ombord i en båt og dro til distriktet ved Dalmanuta sammen med disiplene. ");
INSERT INTO norlb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Da fariseerne fikk vite at Jesus var der, kom de for å diskutere med ham. De forlangte at han skulle gi dem et tegn fra Gud som bevis på hvem han var. ");
INSERT INTO norlb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus ble dypt skuffet da han hørte dette og sukket: ”Hvorfor må denne slekten se tegn for å kunne tro? Nei, jeg forsikrer dere at Gud skal ikke la dere få se noe tegn.” ");
INSERT INTO norlb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Så dro han fra dem og steg i båten igjen og dro over til den andre siden av sjøen. ");
INSERT INTO norlb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Disiplene oppdaget nå at de hadde glemt å skaffe seg mat før de dro. Et eneste brød var alt de hadde med seg i båten. ");
INSERT INTO norlb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus begynte å advare dem og sa: ”Ta dere nøye i vare både for fariseerne$1 og kong Herodes sin deig som ligger og gjærer.” ");
INSERT INTO norlb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","”Hva mener han?” spurte disiplene hverandre. De trodde han sa dette fordi de hadde glemt å ta med seg brød. ");
INSERT INTO norlb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Da Jesus hørte dem diskutere dette, sa han: ”Hvorfor er dere så urolige for at dere ikke har brød med dere? Forstår dere fortsatt ingenting? Er dere så trege til å fatte? ");
INSERT INTO norlb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Dere har øyne å se med og ser likevel ingenting, og øre å høre med og hører likevel ingenting. Har dere glemt ");
INSERT INTO norlb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","at jeg mettet mer enn 5 000 personer med bare fem brød? Hvor mange fulle kurver med rester plukket dere opp den gangen?” ”Tolv”, sa de. ");
INSERT INTO norlb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","”Da jeg mettet mer enn 4 000 personer med sju brød, hvor mange kurver fikk dere da til overs?” ”Sju”, svarte de. ");
INSERT INTO norlb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesus sa: ”Forstår dere fortsatt ingenting?” ");
INSERT INTO norlb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Da de kom over til Betsaida, førte de en blind mann til Jesus og ba at han måtte røre ved mannen og helbrede han. ");
INSERT INTO norlb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus tok da den blinde mannen ved hånden og førte ham ut av byen. Der spyttet han på øynene hans og la hendene sine på ham. ”Kan du se noe?” spurte Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mannen så seg omkring. ”Ja”, sa han, ”jeg ser folk. Men de ser ut som trær som går omkring!” ");
INSERT INTO norlb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Da la Jesus hendene sine på mannens øyne en gang til. Og nå ble mannen helt helbredet og kunne se igjen, og han så alle ting klart som dagen. ");
INSERT INTO norlb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Senere sendte Jesus mannen hjem med denne henstillingen: ”Gå ikke inn i byen på veien hjem.” ");
INSERT INTO norlb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus og disiplene dro fra Galilea og gikk nordover til byene rundt Cæsarea Filippi. Mens de gikk langs veien, spurte han: ”Hvem sier folk at jeg er?” ");
INSERT INTO norlb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","”Noen sier at du er døperen Johannes”, svarte disiplene, ”noen sier at du er Elia, og andre at du er en annen av profetene som før i tiden bar fram Guds budskap.” ");
INSERT INTO norlb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Da spurte han: ”Hvem tror dere at jeg er?” Peter svarte: ”Du er Messias, den lovede kongen.” ");
INSERT INTO norlb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Men Jesus forbød dem strengt å snakke med noen om dette. ");
INSERT INTO norlb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Etter dette begynte Jesus å undervise disiplene om at han, Menneskesønnen, måtte lide mye. Han forklarte at folkets ledere, øversteprestene og de skriftlærde ville ta avstand fra ham og stå bak at han ble drept, men at han etter tre dager skulle stå opp igjen fra de døde. ");
INSERT INTO norlb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Dette sa han helt åpent. Peter dro han da til sides og begynte å protestere. ");
INSERT INTO norlb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus vendte seg om og så bort mot disiplene og sa strengt til Peter: ”Gå bort fra meg, Satan! Det du nå tenker, er mennesketanker og kommer ikke fra Gud.” ");
INSERT INTO norlb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Så kalte han disiplene til seg og ba folket å komme. Og han sa til dem: ”Om noen vil bli disiplene mine, da kan han ikke lenger tenke på seg selv, men må følge mitt eksempel og være beredt til å dø. ");
INSERT INTO norlb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ja, den som klamrer seg fast til livet, skal til sist miste det, men den som mister livet sitt for min skyld for å spre budskapet om meg, han skal berge det. ");
INSERT INTO norlb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hva vinner et menneske om hele verden blir gitt ham, dersom han samtidig mister det evige livet? ");
INSERT INTO norlb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ingen penger i hele verden kan hjelpe et menneske til å få livet tilbake. ");
INSERT INTO norlb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Den som innfor vår tids gudløse og syndige mennesker skammer seg over meg og budskapet mitt, han skal jeg, Menneskesønnen, skamme meg over når jeg vender tilbake til min Fars herlighet sammen med englene hans.” ");
INSERT INTO norlb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus sa: ”Tro meg: Noen av dere som står her, kommer ikke til å dø før de har sett Gud komme med kongelig makt.” ");
INSERT INTO norlb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seks dager seinere tok Jesus med seg Peter, Jakob og Johannes til toppen av et høyt fjell, der de kunne være for seg selv. Der forandret utseendet hans seg mens de så på. ");
INSERT INTO norlb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Klærne hans ble blendende hvite, ja, hvitere enn noe rensemiddel i verden kan gjøre med klær. ");
INSERT INTO norlb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","De fikk se Elia og Moses stå og snakke med Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Da sa Peter til Jesus: ”Mester, dette er et fantastisk sted å være på! La oss bygge tre hytter, en til deg, en til Moses og en til Elia!” ");
INSERT INTO norlb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Han visste ikke hva han skulle si, for han var helt forvirret, akkurat som de andre disiplene. ");
INSERT INTO norlb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Det kom en sky som senket seg over dem, og en stemme fra skyen sa: ”Dette er min elskede Sønn. Lytt til ham!” ");
INSERT INTO norlb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Men da disiplene så seg omkring, var plutselig Moses og Elia borte, og de var alene tilbake med Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Da de gikk ned fra fjellet, ga Jesus dem streng beskjed om å ikke fortelle til noen det de hadde sett, før han, Menneskesønnen, hadde stått opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Derfor holdt de dette for seg selv, men snakket ofte med hverandre om hva Jesus mente da han sa: ”Stå opp fra de døde”. ");
INSERT INTO norlb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Disiplene spurte Jesus: ”Hvorfor påstår de skriftlærde at Elia må vende tilbake før Messias, den lovede kongen, kommer?” ");
INSERT INTO norlb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus svarte: ”De skriftlærde har rett. Elia må først komme og sette alt i rett skikk. Likevel har Gud forutsagt i Skriften at jeg, Menneskesønnen, må lide og bli hånet av alle. Hvordan kan dette ha seg? ");
INSERT INTO norlb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jeg sier dere at Elia allerede har kommet, og menneskene behandlet han dårlig, akkurat slik det står om ham i Skriften.” ");
INSERT INTO norlb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Da de hadde kommet ned fra fjellet, fikk de se en stor folkemasse som hadde samlet seg rundt de andre disiplene. Noen skriftlærde holdt på å diskutere. ");
INSERT INTO norlb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Da folket fikk se Jesus komme gående, ble de gledelig overrasket og sprang fram til ham for å hilse. ");
INSERT INTO norlb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Han spurte: ”Hva er det dere diskuterer?” ");
INSERT INTO norlb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","En mann i folkemassen sa: ”Mester, jeg har tatt sønnen min hit for at du skulle helbrede ham. Han er besatt av en ond Ånd som gjør ham stum. ");
INSERT INTO norlb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hver gang ånden går til angrep, slår den gutten til jorden og får ham til å fråde om munnen og skjære tenner, og han blir helt stiv. Jeg ba disiplene dine om å drive ut denne onde ånden, men de klarte det ikke.” ");
INSERT INTO norlb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","”Dere skeptiske mennesker som ikke vil tro!” utbrøt Jesus. ”Hvor lenge må jeg være hos dere? Hvor lenge må jeg tåle dere? Kom hit med gutten til meg.” ");
INSERT INTO norlb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","De kom fram med gutten og da han fikk se Jesus, begynte ånden å rykke og slite i ham. Han falt til jorden og kastet seg fram og tilbake med fråde rundt munnen. ");
INSERT INTO norlb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","”Hvor lenge har han hatt det på denne måten?” spurte Jesus faren. Han svarte: ”Helt siden han var liten. ");
INSERT INTO norlb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Og den onde ånden får han ofte til å falle i ilden eller i vannet for at han skal dø. Ha medfølelse med oss og hjelp oss, om du kan!” ");
INSERT INTO norlb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","”Om jeg kan?” svarte Jesus. ”Alt er mulig for den som tror.” ");
INSERT INTO norlb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","”Jeg tror”, utbrøt faren. ”Hjelp min vantro!” ");
INSERT INTO norlb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus så nå at folk kom løpende fra alle kanter. Derfor snakket han strengt til den onde ånden og sa: ”Du stumme og døve Ånd, jeg befaler deg å fare ut av gutten og kom aldri mer tilbake!” ");
INSERT INTO norlb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ånden skrek ukontrollert og begynte å rykke og slite i gutten, men for til slutt ut av ham. Gutten lå helt livløs på jorden, og mange begynte mumle: ”Han er død.” ");
INSERT INTO norlb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesus tok ham i hånden og hjalp ham opp. Da reiste han seg. ");
INSERT INTO norlb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Senere kom Jesus til huset der han bodde, og ble alene med disiplene. De spurte ham: ”Hvorfor kunne ikke vi drive ut den onde ånden?” ");
INSERT INTO norlb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus svarte: ”Denne slags Ånder kan bare bli drevet ut ved bønn.” ");
INSERT INTO norlb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Så dro Jesus og disiplene fra området og gikk gjennom Galilea. Han forsøkte å unngå all oppmerksomhet, ");
INSERT INTO norlb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","etter som han fortsatt hadde mye å undervise disiplene om. Han forklarte: ”Jeg, Menneskesønnen, skal bli forrådt og utlevert til menneskene, og de kommer til å drepe meg, men etter tre dager skal jeg stå opp fra de døde igjen.” ");
INSERT INTO norlb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","De forsto ikke hva han mente med dette. Ingen våget heller å spørre ham. ");
INSERT INTO norlb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","De kom nå til Kapernaum, og da de hadde gått inn i huset der de skulle bo, spurte han: ”Hva snakket dere om på veien?” ");
INSERT INTO norlb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","De skammet seg for å svare, for de hadde diskutert hvem av dem som var den største. ");
INSERT INTO norlb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Da satte han seg ned og ba disiplene om å komme til seg, og han sa: ”Den som vil være størst, må gjøre seg minst, bli ydmyk og være tjener for alle.” ");
INSERT INTO norlb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Han tok et lite barn og stilte det midt iblant dem, la armen om barnet og sa: ");
INSERT INTO norlb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","”Den som tar imot et slikt barn fordi det tilhører meg, han tar imot meg. Og den som tar imot meg, han tar imot Gud, etter som Gud har sendt meg.” ");
INSERT INTO norlb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Johannes, en av disiplene, sa til Jesus: ”Mester, vi så en mann som drev ut onde ånder i navnet ditt, men etter som han ikke tilhørte vår gruppe, så forsøkte vi å stoppe ham.” ");
INSERT INTO norlb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Da sa Jesus til Johannes: ”La han holde på. Ingen som gjør mirakler i navnet mitt, kan sånn helt plutselig begynne å snakke dårlig om meg etterpå. ");
INSERT INTO norlb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Den som ikke er mot oss, han er for oss. ");
INSERT INTO norlb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ja, jeg forsikrer dere, om noen bare gir dere et glass vann å drikke fordi dere tilhører meg, Kristus, da skal han få sin lønn for det.” ");
INSERT INTO norlb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesus fortsatte: ”Om noen leder vill en av disse små som tror på meg, og får han til å synde, da var det bedre for den personen å bli kastet i havet med en stor stein surret til halsen. ");
INSERT INTO norlb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Om hånden din får deg til å synde, da hogg den av. Det er bedre å få et evig liv sammen med Gud og heller savne den ene hånden, enn å ha begge hendene i behold og havne i helvete, der ilden aldri slokner. ");
INSERT INTO norlb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Og om foten din får deg til å synde, da hogg den av. Det er bedre å få et evig liv sammen med Gud og heller savne den ene foten, enn å ha begge føttene i behold og bli kastet i helvete. ");
INSERT INTO norlb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Om ditt øye får deg til å synde, da riv det ut. Det er bedre å komme til Guds nye verden og være enøyd, enn å ha begge øynene i behold og bli kastet i helvete, ");
INSERT INTO norlb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","der ormene ikke dør, og ilden aldri slukner. ");
INSERT INTO norlb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Alle som følger meg, må bli renset gjennom lidelsens ild. ");
INSERT INTO norlb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Den som er villig til å følge meg hva det enn måtte koste, han blir det saltet som bevarer verden fra forråtnelse. Hvilken nytte har vi av saltet dersom det har mistet sin kraft? Kan noen få det til å bli salt igjen? Nei! Se derfor til at dere ikke mister saltets virkekraft, og lev i fred med hverandre.” ");
INSERT INTO norlb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus dro fra Galilea, gikk sørover mot Judea og kom inn i området øst for Jordan. Store folkemasser samlet seg rundt ham på nytt. Som vanlig underviste han alle som ville høre. ");
INSERT INTO norlb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Noen fariseere kom for å diskutere med Jesus og forsøkte å få ham til å si noe som de kunne sette ham fast for. De spurte: ”Mener du at en mann har rett til å skille seg fra kona si?” ");
INSERT INTO norlb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus svarte: ”Hvilke regler ga Moses dere om skilsmisse?” ");
INSERT INTO norlb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","De svarte: ”Han bestemte at det eneste en mann trenger å gjøre, er å skrive ut en attest som bevis på skilsmissen. Da kan han sende kvinnen fra seg.” ");
INSERT INTO norlb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","”Hvorfor ga Moses denne regelen?” fortsatte Jesus. ”Jo, fordi han kjente deres harde og onde hjerter. ");
INSERT INTO norlb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Det var ikke slik Gud hadde tenkt det fra begynnelsen av. Gud skapte menneskene til mann og kvinne. ");
INSERT INTO norlb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Derfor skal mannen forlate foreldrene sine og holde seg til kona si. ");
INSERT INTO norlb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","De to skal være ett. De er altså ikke lenger to, livet deres er ett. ");
INSERT INTO norlb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Det Gud har forent, skal ikke menneskene skille.” ");
INSERT INTO norlb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Noe seinere da de kom inn i huset der de bodde, ville disiplene vite mer om dette. ");
INSERT INTO norlb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Han sa: ”Den mannen som skiller seg fra kona si og gifter seg med en annen, han er utro. ");
INSERT INTO norlb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Og dersom en fraskilt kvinne gifter seg på nytt med en annen, da er hun utro.” ");
INSERT INTO norlb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Noen foreldre kom til Jesus med små barn for at han skulle røre ved dem og be for dem. Men disiplene jaget barna bort. ");
INSERT INTO norlb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus så det som skjedde og ble sint: ”Send dem ikke fra oss”, sa han til disiplene. ”La barna komme til meg, for alle som vil tilhøre Guds eget folk, må bli som disse barna. ");
INSERT INTO norlb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ja, jeg forsikrer dere at den som ikke blir som et lite barn, kommer slett ikke til å få tilhøre Guds eget folk.” ");
INSERT INTO norlb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Så tok han barna i favnen, la hendene på dem og ba sin Far i himmelen om å gi dem alt godt. ");
INSERT INTO norlb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Da han skulle gå videre, kom en mann løpende og falt på kne for ham og sa: ”Gode Mester, hva skal jeg gjøre for å få evig liv?” ");
INSERT INTO norlb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","”Hvorfor kaller du meg god?” spurte Jesus. ”Det finnes bare en som er god, og det er Gud. ");
INSERT INTO norlb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hans bud kan du allerede: ’Du skal ikke drepe. Du skal ikke være utro i ekteskapet. Du skal ikke stjele. Du skal ikke lyve eller vitne falskt. Du skal ikke bedra noen for det som er hans. Vis respekt for foreldrene dine.’ ” ");
INSERT INTO norlb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","”Mester”, svarte mannen, ”alle disse budene har jeg holdt helt siden jeg var ung.” ");
INSERT INTO norlb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus ble fylt av kjærlighet til mannen, så på ham og sa: ”Det er bare en ting til du må gjøre. Alt det du eier må du gå og selge og gi pengene til de fattige. Da skal du få en skatt i himmelen. Kom så og følg meg.” ");
INSERT INTO norlb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Da mannen hørte dette mørknet ansiktet hans i bitter skuffelse, og han gikk bedrøvet bort, for han var svært rik. ");
INSERT INTO norlb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus så seg rundt, henvendte seg til disiplene og sa: ”Hvor vanskelig er det ikke for den som har mye penger, å få tilhøre Guds eget folk!” ");
INSERT INTO norlb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesus så at disiplene ble forskrekket over det han sa, og fortsatte: ”Ja, hvor vanskelig er det ikke å få tilhøre Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Det er faktisk lettere for en kamel å komme gjennom et nåløye enn for en rik å underordne seg Gud, slik at han får tilhøre Guds eget folk.” ");
INSERT INTO norlb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Denne påstanden gjorde disiplene enda mer ute av seg, og de sa til hverandre: ”Hvem i all verden kan da bli frelst?” ");
INSERT INTO norlb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus så på dem og sa: ”Ingen, menneskelig sett. Men for Gud er alle ting mulig. Han kan frelse hvem som helst.” ");
INSERT INTO norlb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Da sa Peter til ham: ”Vi har forlatt alt for å følge deg.” ");
INSERT INTO norlb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","”Ja”, svarte Jesus, ”og jeg forsikrer dere at hver og en som forlater hus, søsken, foreldre, barn eller gårder for å følge meg på grunn av troen på det glade budskapet, ");
INSERT INTO norlb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","han skal få mangedobbelt igjen. Han skal få hus, søsken, mødre, barn og gårder allerede her i tiden mens forfølgelsene står på. Og i tillegg skal han få evig liv i den kommende verden. ");
INSERT INTO norlb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mange som i dag har lav status, skal være blant de fremste i Guds nye verden, mens andre, som her var betydningsfulle, der må holde seg i bakgrunnen.” ");
INSERT INTO norlb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","De var nå på vei til Jerusalem, og Jesus gikk fremst i flokken. Disiplene og alle de øvrige som gikk i følge med ham, var oppskaket og fylt av angst. Jesus samlet sine tolv disipler og begynte enda en gang å forklare alt som skulle skje med ham. ");
INSERT INTO norlb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","”Vi er på vei til Jerusalem”, sa han. ”Der kommer jeg, Menneskesønnen, til å bli forrådt og utlevert til øversteprestene og de skriftlærde. De kommer til å dømme meg til døden og overgi meg til de romerske myndighetene. ");
INSERT INTO norlb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Romerne vil håne meg og spytte på meg, piske meg og til sist drepe meg. Men etter tre dager skal jeg stå opp fra de døde igjen.” ");
INSERT INTO norlb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Da gikk Jakob og Johannes, som var sønnene til Sebedeus, fram til ham og sa: ”Mester, vi vil be deg om en ting.” ");
INSERT INTO norlb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","”Hva da?” spurte han. ");
INSERT INTO norlb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","De sa: ”La oss få sitte på hedersplassene nærmest deg når du begynner å regjere som konge, en på høyre siden og den andre på venstre.” ");
INSERT INTO norlb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Men Jesus sa til dem: ”Dere vet ikke hva dere ber om! Klarer dere virkelig å gå gjennom det jeg må gå gjennom? Kan dere holde ut de fryktelige lidelsene som jeg må holde ut?” ");
INSERT INTO norlb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","”Ja”, svarte de. ”Det kan vi!” Da sa Jesus: ”Dere kommer nok til å gå gjennom de samme tingene som jeg, og lide akkurat som jeg, ");
INSERT INTO norlb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","men jeg har ingen rett til å bestemme hvem som skal sitte på min høyre og på min venstre side. De plassene er reservert for dem som min Far i himmelen velger ut.” ");
INSERT INTO norlb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Da de ti andre disiplene hørte det Jakob og Johannes hadde bedt om, ble de opprørt. ");
INSERT INTO norlb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Men Jesus samlet alle og sa: ”I denne verden opptrer kongene som tyranner, og herskerne har all makt over folket som står under dem. ");
INSERT INTO norlb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Slik må det ikke være blant dere. Den av dere som vil være leder, han må være de andre sin tjener. ");
INSERT INTO norlb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Den som vil være den første, han må være slave for alle. ");
INSERT INTO norlb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Følg mitt eksempel. Jeg, Menneskesønnen, har ikke kommet for å bli betjent, men for å tjene andre. Jeg har kommet for å gi livet mitt og kjøpe menneskene fri fra deres slaveri under synden.” ");
INSERT INTO norlb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","På veien mot Jerusalem kom Jesus og disiplene til byen Jeriko. Da de igjen var på vei ut fra byen sammen med en stor folkemasse, satt en blind tigger ved kanten av veien. Han het Bartimeus og var sønn til Timaios. ");
INSERT INTO norlb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Da Bartimeus fikk høre at det var Jesus fra Nasaret som kom, begynte han rope: ”Jesus, du som skal arve kong Davids trone, ha medfølelse med meg!” ");
INSERT INTO norlb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Folk forsøkte å få ham til å holde munn, men han ropte bare enda høyere: ”Du som skal arve kong Davids trone, ha medfølelse med meg!” ");
INSERT INTO norlb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Da Jesus hørte dette, stanset han og sa: ”Be ham komme hit!” De ropte da på den blinde mannen og sa: ”Ro deg ned. Reis deg og kom, Jesus vil møte deg.” ");
INSERT INTO norlb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeus kastet kappen av seg, spratt opp og kom fram til Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","”Hva vil du at jeg skal gjøre for deg?” spurte Jesus. ”Mester”, sa Bartimeus, ”jeg vil så inderlig gjerne se igjen!” ");
INSERT INTO norlb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Da sa Jesus til ham: ”Gå! Din tro har helbredet deg.” Og straks kunne mannen se! Etterpå fulgte han Jesus på veien. ");
INSERT INTO norlb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Da de nærmet seg Jerusalem og kom til byene Betfage og Betania, som ligger ved Oljeberget, sendte Jesus to av disiplene i forveien og ");
INSERT INTO norlb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","sa: ”Gå inn i byen som ligger rett foran dere. Der skal dere straks finne et ungt esel som står bundet, et dyr som ingen har ridd på ennå. Ta eselet og kom hit med det. ");
INSERT INTO norlb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dersom noen spør hva dere holder på med, så skal dere bare si: ’Herren har bruk for det, men han sender snart eselet tilbake.’ ” ");
INSERT INTO norlb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","De to disiplene la i vei og fant det unge eselet som sto bundet ved porten til et hus i bygaten. Mens de holdt på å løse det, ");
INSERT INTO norlb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","sa noen som sto der: ”Hva holder dere på med? Vil dere ta eselet?” ");
INSERT INTO norlb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Disiplene svarte som Jesus hadde sagt, og da fikk de ta det. ");
INSERT INTO norlb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","De førte eselet til Jesus. Disiplene la kappene sine på det og Jesus satte seg opp og red av sted mot byen. ");
INSERT INTO norlb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mange mennesker bredte kappene sine ut som en løper foran ham, andre strødde grønne kvister fra trærne på veien. ");
INSERT INTO norlb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Både de som gikk foran Jesus, og de som kom etter, ropte: ”Vi hyller deg! Vi ærer deg som er sendt av Herren! ");
INSERT INTO norlb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Vi ærer deg som skal regjere som vår stamfar David gjorde! Alle i himmelen hyller deg!” ");
INSERT INTO norlb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus red inn i Jerusalem og gikk opp til tempelplassen. Der gikk han rundt og så nøye på alt. Etter som det alt var seint på ettermiddagen, gikk han snart tilbake til Betania sammen med disiplene. ");
INSERT INTO norlb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Neste morgen, da de var på vei fra Betania, ble Jesus sulten. ");
INSERT INTO norlb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Han fikk se at det litt lenger framme sto et fikentre med grønt løv og gikk dit for å se om han kunne plukke fiken. Men det var bare blader, etter som det var alt for tidlig på året til å være frukttid. ");
INSERT INTO norlb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Da sa Jesus til treet: ”Aldri mer skal noen spise frukt fra deg!” Disiplene hørte det han sa. ");
INSERT INTO norlb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Da de kom fram til Jerusalem, gikk Jesus inn på tempelplassen og drev ut kjøpmennene og kundene deres. Han veltet bordene til dem som vekslet penger og raserte benkene til dem som solgte duer. ");
INSERT INTO norlb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Han stoppet dem som forsøkte å bære handelsvarer over tempelplassen. ");
INSERT INTO norlb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesus underviste og sa: ”Har ikke Gud sagt i Skriften: ’Mitt hus skal være et sted der alle folk kan be?’ Men dere har latt det bli ’et oppholdssted for tyver og kjeltringer’.” ");
INSERT INTO norlb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Da øversteprestene og de skriftlærde fikk høre det han hadde gjort, begynte de å legge planer for hvordan de kunne bli kvitt ham. Men de var redde for ham, etter som hele folket var mektig imponert over undervisningen hans. ");
INSERT INTO norlb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","På kvelden dro Jesus og disiplene fra byen. ");
INSERT INTO norlb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Da de neste morgen gikk forbi fikentreet igjen, så disiplene at det hadde visnet fra roten av. ");
INSERT INTO norlb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter kom plutselig til å huske på det Jesus hadde sagt til treet dagen før, og han utbrøt: ”Mester, har du sett på maken? Fikentreet som du forbannet, har visnet!” ");
INSERT INTO norlb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Da sa Jesus til disiplene: ”Dere må stole fullt og helt på Gud. ");
INSERT INTO norlb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jeg forsikrer dere, om dere virkelig tror av et helt hjerte og ikke tviler, da kan dere si til dette fjellet: ’Løft deg opp og kast deg i havet’, og det kommer til å bli slik. ");
INSERT INTO norlb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ja, jeg forsikrer dere, om dere bare tror, da kan dere be om hva som helst, og dere skal få det! ");
INSERT INTO norlb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Men når dere ber til Gud, da skal dere først tilgi dem som dere er sinte på. Når dere gjør det, skal dere selv få tilgivelse for syndene av vår Far i himmelen.” ");
INSERT INTO norlb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","De kom nå tilbake til Jerusalem. Mens Jesus gikk omkring på tempelplassen, kom øversteprestene, de skriftlærde og folkets ledere bort til ham. ");
INSERT INTO norlb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","De forlangte å få vite hvilken rett han hadde til å gjøre alt det han gjorde, og hvem som hadde gitt ham dette oppdraget. ");
INSERT INTO norlb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","”Det skal jeg snart fortelle dere”, sa Jesus, ”dersom bare dere først svarer meg på et annen spørsmål: ");
INSERT INTO norlb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Da døperen Johannes døpte, var det på Guds befaling eller ikke? Svar meg på det!” ");
INSERT INTO norlb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","De begynte straks å diskutere med hverandre og sa: ”Om vi sier at det var på Guds befaling, da kommer han til å spørre hvorfor vi ikke trodde på han. ");
INSERT INTO norlb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kanskje vi kunne forsøke å argumentere for at Gud ikke hadde sendt ham?” Nei, det våger vi ikke, for da kan folket bli brysomme. Alle var jo overbeviste om at Johannes hadde vært en profet som bar fram Guds budskap. ");
INSERT INTO norlb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Derfor svarte de til slutt: ”Vi vet ikke.” Da sa Jesus: ”I så tilfelle sier heller ikke jeg hvem som har gitt meg i oppdrag å gjøre det jeg gjør.” ");
INSERT INTO norlb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Litt etter begynte Jesus å tale til folket ved å bruke bilder. Han sa: ”En mann plantet en vingård. Han bygget en mur rundt den og gravde en grop i bakken der han kunne presse druene. Han bygget også et vakttårn. Senere forpaktet han vingården bort til noen som dyrket vin mens han selv reiste ut av landet. ");
INSERT INTO norlb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Da det ble tid for å høste avlingen, sendte mannen en av tjenerne sine til de som dyrket vinen for å hente den delen av årets høst som var hans. ");
INSERT INTO norlb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Men forpakterne gikk løs på tjeneren, mishandlet ham og sendte ham tomhendt tilbake. ");
INSERT INTO norlb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eieren sendte da en annen av tjenerne sine, men det samme skjedde på nytt. De slo ham i hodet og forulempet ham. ");
INSERT INTO norlb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Neste tjener som han sendte drepte de. Ja, alle utsendingene som eieren sendte, mishandlet de eller slo i hjel. ");
INSERT INTO norlb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Til slutt var det bare en eneste igjen å sende. Det var eierens egen elskede sønn. Som den siste muligheten sendte han sønnen sin, for han tenkte: ’Han vil de vel i alle fall ha respekt for.’ ");
INSERT INTO norlb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Men forpakterne sa til hverandre: ’Her kommer han som skal arve hele vingården. Kom så dreper vi ham og tar vingården selv!’ ");
INSERT INTO norlb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Så gikk de løs på sønnen, drepte ham og kastet kroppen hans utenfor vingården.” ");
INSERT INTO norlb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","”Hva tror dere eieren gjør når han får greie på det som har skjedd?” spurte Jesus. ”Jo, han møter selv opp og dreper de onde forpakterne og gir etterpå vingården til andre. ");
INSERT INTO norlb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Har dere ikke lest følgende sted i Skriften: ’Den steinen som ikke var brukbar for bygningsmennene, har blitt gjort til selve hjørnesteinen. ");
INSERT INTO norlb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Herren har valgt den ut, og den er praktfull å se på!’ ” ");
INSERT INTO norlb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","De religiøse lederne ville arrestere Jesus straks, etter som de forsto at det var dem han siktet til i sin fortelling, men de var redde for folket. Derfor dro de seg unna og forsvant. ");
INSERT INTO norlb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","De religiøse lederne sendte nå noen fariseere og tilhengere av kong Herodes for å lure Jesus til å si noe som de kunne sette ham fast for. ");
INSERT INTO norlb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","De kom og sa: ”Mester, vi vet at du alltid er ærlig. Du spør ikke etter hva folk mener og tenker, men sier oss rett ut det som er Guds vilje. Si oss nå om det er rett eller galt å betale skatt til den romerske keiseren. Skal vi gjøre det eller skal vi ikke?” ");
INSERT INTO norlb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus forsto at de bare lot som om de ville lyde Gud, og sa: ”Hvorfor forsøker dere å lure meg? Kom hit med en romersk mynt så jeg får se på den.” ");
INSERT INTO norlb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","De ga ham en mynt, og han spurte: ”Hvem sitt bilde er dette, og hvem sin signatur står under bildet?” ”Keiseren sitt”, svarte de. ");
INSERT INTO norlb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","”Da så”, sa han, ”gi keiseren det som er hans. Men det som tilhører Gud, det må dere gi til Gud.” De ble helt forundret over svaret hans. ");
INSERT INTO norlb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Noen sadukeere kom til Jesus. Sadukeerne påstår at de døde ikke kan stå opp igjen, og derfor spurte de: ");
INSERT INTO norlb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","”Mester, i Moseloven står det at om en mann dør og etterlater seg kona si som enke og har ingen barn, da skal hans bror gifte seg med enken og passe på at den døde får en sønn som kan føre arven videre. ");
INSERT INTO norlb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nå var det en familie med sju brødre. Den eldste giftet seg, men døde uten å etterlate seg noe barn. ");
INSERT INTO norlb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Derfor giftet bror nummer to seg med enken, men snart døde også han uten å etterlate seg noe barn. Med den tredje gikk det på samme måten, og slik fortsatte det helt til hun hadde vært gift med alle sju uten å få barn. Til sist døde også kvinnen. ");
INSERT INTO norlb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Når de står opp fra de døde, hvem sin kone blir hun da? Alle sju har jo vært gift med henne!” ");
INSERT INTO norlb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus svarte: ”Dere forstår verken Skriften eller Guds kraft. Det er derfor dere tar så skammelig feil. ");
INSERT INTO norlb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Når de døde står opp igjen, kommer de ikke til å gifte seg, men de blir som englene i himmelen. ");
INSERT INTO norlb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Men når det gjelder de dødes oppstandelse, har dere aldri lest i Mosebøkene om den brennende tornebusken der Gud sier til Moses: ’Jeg er Abrahams, Isaks og Jakobs Gud.’ ");
INSERT INTO norlb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gud er ikke en gud for døde, men for de levende. Dere tar fullstendig feil.” ");
INSERT INTO norlb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","En av de skriftlærde som sto og lyttet til diskusjonen, var mektig imponert over svaret Jesus hadde gitt, og spurte derfor: ”Hvilket er det viktigste av alle budene?” ");
INSERT INTO norlb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus svarte: ”Det viktigste budet er: ’Lytt, Israel! Herren vår Gud, Herren er en. ");
INSERT INTO norlb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Du skal elske Herren, din Gud, av hele ditt hjerte, av hele din sjel, av hele din forstand og av hele din kraft.’ ");
INSERT INTO norlb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Det nest viktigste budet er: ’Du skal elske dine medmennesker som deg selv!’ Ikke noe bud er viktigere enn disse to.” ");
INSERT INTO norlb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Den skriftlærde svarte: ”Mester, du har rett. Det er sant at det bare finnes en Gud og ingen annen. ");
INSERT INTO norlb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Og jeg vet at vi skal elske Gud av hele vårt hjerte, av hele vår forstand og av hele vår kraft, og at vi skal elske våre medmennesker like høyt som oss selv. Dette er viktigere enn å ofre brennoffer på alteret i templet, og viktigere enn andre slags offer som Moseloven krever.” ");
INSERT INTO norlb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Da Jesus hørte hvor klokt mannen svarte, sa han: ”Du er ganske nære på å bli frelst og få tilhøre Guds eget folk.” Etter dette våget ingen å komme med flere spørsmål. ");
INSERT INTO norlb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Da Jesus seinere underviste folket på tempelplassen, spurte han: ”Hvorfor påstår de skriftlærde at Messias, den lovede kongen, er en etterkommer av kong David? ");
INSERT INTO norlb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David har jo selv sagt under inspirasjon av Guds Hellige Ånd: ’Gud sa til min Herre: Kom og sett deg på min høyre side for å regjere, til jeg har lagt dine fiender under føttene dine.’ ");
INSERT INTO norlb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mener dere virkelig at David skulle kalle en av sine etterkommere for Herre?” Måten Jesus argumentere på, tiltalte folket, og de lyttet gjerne til ham. ");
INSERT INTO norlb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Han fortsatte sin undervisning, og sa: ”Ta dere i være for de skriftlærde som elsker å gå omkring i side kapper og gjerne vil bli hilst med respekt på torget. ");
INSERT INTO norlb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ved gudstjenestene tar de plassene på fremste benk, og de elsker å sitte på hedersplassene under festene. ");
INSERT INTO norlb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Men i sin griskhet unnslår de seg ikke for å bedra hjelpeløse enker for eiendelene deres, mens de later som om de leve etter Guds vilje ved å be lange bønner når andre hører på. Derfor kommer Gud til å straffe dem desto hardere.” ");
INSERT INTO norlb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus gikk og satte seg rett mot offerkisten i templet. Han fulgte med når folk kom og la sine penger i den. Mange som var rike la store beløp. ");
INSERT INTO norlb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Men så kom det en fattig enke og la to koppermynter som nesten ikke var verd noen ting. ");
INSERT INTO norlb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Da kalte Jesus til seg disiplene og sa: ”Tro meg, denne fattige enken la mer i offerkisten enn alle de andre. ");
INSERT INTO norlb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","De ga bare en liten del av sin overflod, men hun som er så fattig, la alt det hun eide, i offerkisten, alt hun hadde å leve av.” ");
INSERT INTO norlb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Da Jesus noe seinere dro fra templet, sa en av disiplene: ”Mester, se disse fantastiske bygningene! Se, hvilke enorme steiner de er bygget av!” ");
INSERT INTO norlb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus svarte: ”Alle disse bygningene som dere nå ser i sin prakt, kommer til å bli jevnet med jorden, ikke en stein skal bli tilbake på stein.” ");
INSERT INTO norlb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Senere satt han på skråningen opp mot Oljeberget og så rett mot templet. Peter, Jakob, Johannes og Andreas var alene sammen med ham, og de spurte: ”Når skal dette du snakket om skje? Fortell oss mer om det. Hva blir tegnet som viser at den tiden er kommet som Gud har bestemt for alt det du snakker om?” ");
INSERT INTO norlb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Da sa Jesus: ”Vær på vakt så ingen lurer dere. ");
INSERT INTO norlb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mange skal komme i mitt navn og påstå at de er Messias, den lovede kongen, og de skal lede mange vill. ");
INSERT INTO norlb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Når dere får høre om krig eller trussel om krig, la dere ikke da skremme. Det må bli krig, men det betyr ikke at slutten er kommet. ");
INSERT INTO norlb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Folk og land vil reise seg mot hverandre. Det blir jordskjelv på det ene stedet etter det andre, og det blir sultekatastrofer. Dette er bare begynnelsen på de veene som skal komme. ");
INSERT INTO norlb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Vær på vakt! De vil arrestere dere og trekke dere for domstolene, og dere vil bli mishandlet i synagogene. For min skyld vil dere bli anklaget for konger og makthavere og få anledning til å fortelle om det dere har hørt og sett. ");
INSERT INTO norlb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Det glade budskapet om meg må bli spredd til alle folk før tiden er slutt. ");
INSERT INTO norlb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Når dere blir trukket for domstolene, skal dere ikke være bekymret for hva dere skal si. Si bare det som er naturlig for dere, for dere skal få de rette ordene når tiden er inne, og dere må forklare dere. Det er ikke dere som snakker, men Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Søsken vil forråde hverandre og bli årsak til drap. Foreldre vil forråde sine egne barn. Barn vil gjøre opprør mot foreldrene sine og ta livet av dem. ");
INSERT INTO norlb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Alle vil hate dere fordi dere tilhører meg. Men den som holder ut til slutten, skal bli frelst. ");
INSERT INTO norlb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Når dere ser ’det motbydelige avgudsbildet’ stå i templet, den som leser dette skal nøye legge merke til hvert ord, da må de som er i Judea, rømme opp i fjellene. ");
INSERT INTO norlb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Den som er oppe på taket, må ikke gå inn i huset for å pakke. ");
INSERT INTO norlb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Den som er ute på åkeren, må ikke løpe hjem for å hente klærne sine. ");
INSERT INTO norlb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Stakkars de kvinnene som er gravide når denne tiden kommer, og stakkars de mødrene som ammer barna sine! ");
INSERT INTO norlb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Be om at dere ikke trenger rømme om vinteren. ");
INSERT INTO norlb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Denne prøvelsens tid vil bli så hard at ikke noe tilsvarende har skjedd fra den dagen da Gud skapte verden og til nå. Det vil heller ikke komme noe lignende seinere. ");
INSERT INTO norlb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ja, om Herren ikke hadde grepet inn og forkortet denne tiden, da ville ikke et eneste menneske ha overlevd. Men nå har Gud forkortet tiden, etter som han vil skåne dem som takker ja til innbydelsen om å tilhøre ham. ");
INSERT INTO norlb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Dersom noen da sier til dere: ’Nå er Messias, den lovede kongen, kommet. Her er han’, eller: ’Der er han’, da må dere ikke tro ham! ");
INSERT INTO norlb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mange vil komme og påstå at de kan frelse verden, og mange vil holde fram falske budskap om Gud, og de vil gjøre merkelige mirakler og tegn for om mulig å bedra dem som tilhører Gud. ");
INSERT INTO norlb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Vær på vakt! Husk på at jeg har advart dere i forveien! ");
INSERT INTO norlb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Når denne lidelsens tid er over, kommer solen til å bli formørket og månen vil slutte å lyse. ");
INSERT INTO norlb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Stjernene skal bli slynget ut av sine baner, og universets krefter blir rokket. ");
INSERT INTO norlb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Da skal de få se meg, Menneskesønnen, komme i skyene med stor makt og herlighet. ");
INSERT INTO norlb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jeg skal sende ut mine engler til alle verdenshjørner, nært og fjernt over hele jorden, og samle inn hver og en som har takket ja til Guds innbydelse om å tilhøre ham.” ");
INSERT INTO norlb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jesus fortsatte med å undervise ved å fortelle et bilde. Han sa: ”Lær av fikentreet. Når sevjen stiger i grenene og løvet begynner å springe ut, da vet dere at sommeren snart er her. ");
INSERT INTO norlb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","På samme måten kan dere vite at jeg ganske snart vil komme igjen når dere ser alt dette skje. ");
INSERT INTO norlb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jeg forsikrer dere, denne slekten skal ikke gå under før alt dette skjer. ");
INSERT INTO norlb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Himmel og jord skal forsvinne, men mine ord skal aldri i evighet bli borte. ");
INSERT INTO norlb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ingen vet hvilken dag eller time slutten kommer, ikke en gang englene eller Guds sønn. Bare Far i himmelen vet det. ");
INSERT INTO norlb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Vær derfor beredt og hold dere våkne, etter som dere ikke kjenner tiden som Gud har bestemt. ");
INSERT INTO norlb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Når jeg kommer tilbake, blir det som når en mann har reist til utlandet. Før han reiser overlater han ansvaret for huset til tjenerne sine. Hver og en får oppgavene sine, og portvakten har fått befaling om å holde seg våken og være beredt. ");
INSERT INTO norlb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vær altså beredt og hold dere våkne, for dere vet ikke når husets herre kommer tilbake! Kanskje blir det på kvelden, eller ved midnatt, eller like før morgendemringen, eller tidlig på morgenen. ");
INSERT INTO norlb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","La han ikke komme helt uforberedt over dere og finne dere sovende. ");
INSERT INTO norlb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Det jeg sier til dere gjelder for alle mennesker: Vær beredt på at jeg kommer igjen!” ");
INSERT INTO norlb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nå var det bare to dager igjen til påskehøytiden skulle begynne. Øversteprestene og de skriftlærde søkte fortsatt etter en anledning til i all hemmelighet å arrestere Jesus og drepe ham. ");
INSERT INTO norlb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","”Men”, sa de til hverandre, ”ikke under selv påskehøytiden, for da kan det føre til opprør.” ");
INSERT INTO norlb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Da Jesus var i Betania, stakk han innom Simon, en mann som før hadde vært spedalsk. Mens de spiste sammen, kom en kvinne fram med en flaske aromatisk, kostbar olje. Kvinnen brøt toppen av flasken og hellet hele innholdet over hodet på Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dette irriterte noen av gjestene. ”Har du sett en slik sløsing med oljen”, sa de til hverandre. ");
INSERT INTO norlb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","”Denne oljen var jo verdt nesten en årslønn. Tenk om hun heller hadde solgt den og gitt pengene til de fattige!” De begynte å skjelle henne ut. ");
INSERT INTO norlb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus sa: ”La henne være i fred! Hvorfor kritiserer dere henne på denne måten? Hun har gjort en god gjerning mot meg. ");
INSERT INTO norlb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","De fattige vil dere alltid ha iblant dere, og dere kan hjelpe dem så ofte og mye dere bare vil, men meg kommer dere ikke til å ha særlig lenge til hos dere. ");
INSERT INTO norlb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Denne kvinnen har gjort alt det hun kunne, og har som en forberedelse salvet meg med olje til begravelsen min. ");
INSERT INTO norlb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Faktum er at over alt i verden der budskapet om meg blir spredd, vil også historien om det hun gjorde mot meg, bli husket.” ");
INSERT INTO norlb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Etter denne begivenheten gikk Judas Iskariot, en av de tolv disiplene, til øversteprestene for å forråde Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Øversteprestene ble svært glade og lovet ham penger for angiveriet. Judas begynte straks å lete etter en passende anledning til å forråde Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","På den første dagen i påskehøytiden, den dagen da påskelammet ble slaktet, spurte disiplene Jesus: ”Hvor vil du at vi skal gå for å ordne med påskemåltidet for deg?” ");
INSERT INTO norlb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesus sendte da to disipler av sted og forklarte: ”Gå inn i Jerusalem. Der vil dere møte en mann som bærer en vannkrukke på hodet. Følg etter ham. ");
INSERT INTO norlb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Si til eieren av huset der mannen går inn: ’Vår Mester spør etter rommet der han kan spise påskemåltidet sammen med disiplene sine?’ ");
INSERT INTO norlb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Huseieren vil da ta dere med en trapp opp til et stort rom der det allerede er dekket på bordet. Gjør i stand måltidet vårt der.” ");
INSERT INTO norlb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","De to disiplene gikk av sted til byen og fant alt slik Jesus hadde sagt, og de ordnet med påskemåltidet. ");
INSERT INTO norlb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","På kvelden kom Jesus med sine tolv disipler til stedet. ");
INSERT INTO norlb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mens de spiste, sa han: ”Jeg skal si dere som sant er: En av dere kommer til å forråde meg. En av dere som nå spiser ved samme bordet som meg, vil gjøre det.” ");
INSERT INTO norlb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Da ble de bedrøvet, og en etter en spurte de Jesus: ”Det er vel ikke meg?” ");
INSERT INTO norlb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Han svarte: ”Det er en av dere tolv, han som dypper brødet i fatet sammen med meg.$1 ");
INSERT INTO norlb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","For jeg, Menneskesønnen, må dø, akkurat slik som Gud har forutsagt i Skriften, men ulykken vil ramme det mennesket som forråder meg! Det hadde vært bedre for den personen om han aldri var født!” ");
INSERT INTO norlb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mens de spiste, tok Jesus et brød, takket Gud for maten, brøt det i biter, ga til hver og en og sa: ”Ta dette, for dette er kroppen min.” ");
INSERT INTO norlb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Etterpå tok han et beger vin, takket Gud og ga det til hver og en. Alle drakk av vinen. ");
INSERT INTO norlb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Han sa: ”Dette er blodet mitt som bekrefter den nye pakten mellom Gud og menneskene, blodet som blir ofret for alle. ");
INSERT INTO norlb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jeg forsikrer dere at fra nå av skal jeg ikke drikke jordisk vin igjen før den dagen Gud regjerer, og jeg drikker den nye vinen i hans kommende verden.” ");
INSERT INTO norlb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Da de til slutt hadde sunget lovsangen sammen, gikk de ut til Oljeberget. ");
INSERT INTO norlb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Der sa Jesus: ”Dere kommer alle til å forlate meg, for Gud sier i Skriften: ’Jeg skal drepe gjeteren, og sauene vil bli spredd.’ ");
INSERT INTO norlb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Men når jeg har stått opp fra de døde, skal jeg gå i forveien for dere til Galilea og treffe dere der.” ");
INSERT INTO norlb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Da sa Peter: ”Selv om alle de andre forlater deg, så skal ikke jeg gjøre det!” ");
INSERT INTO norlb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus sa til ham: ”Jeg forsikrer deg, allerede før hanen rekker å gale to ganger i morgen tidlig, vil du tre ganger ha nektet for at du kjenner meg.” ");
INSERT INTO norlb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter ga seg ikke, men forsikret på nytt: ”Om jeg så må dø med deg, vil jeg aldri fornekte deg!” Det samme sa alle de andre. ");
INSERT INTO norlb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","De kom nå til det stedet som ble kalt Getsemane. Der sa Jesus til disiplene: ”Sett dere her mens jeg går bort og ber”. ");
INSERT INTO norlb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Han tok bare med seg Peter, Jakob og Johannes. Jesus ble grepet av frykt og angst. ");
INSERT INTO norlb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Han sa til de tre: ”Jeg er nær ved å bryte sammen av fortvilelse. Bli her og våk sammen med meg.” ");
INSERT INTO norlb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Så gikk han litt lenger bort og falt ned på jorden. Han ba til sin Far i himmelen om å få slippe den fryktelige stunden som ventet ham, om det var mulig. ");
INSERT INTO norlb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","”Far, Far i himmelen”, sa han, ”alt er mulig for deg. La meg slippe denne lidelsen som venter. La det likevel bli som du vil, ikke som jeg vil.” ");
INSERT INTO norlb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Etter en tid kom han tilbake til de tre disiplene sine og fant dem sovende. ”Simon”, sa han til Peter, ”sover du? Klarte du ikke å holde deg våken en eneste time? ");
INSERT INTO norlb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Våk og be så ikke fristelsen vinner seier over dere. Dere vil så gjerne, men menneskelig begrensning gjør det vanskelig for dere.” ");
INSERT INTO norlb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Så gikk han på nytt bort og ba med de samme ordene. ");
INSERT INTO norlb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Da han kom tilbake til de tre disiplene, så han at de igjen hadde sovnet. Det var umulig for dem å holde øynene åpne, og de visste ikke hva de skulle svare ham. ");
INSERT INTO norlb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Da han for tredje gangen kom tilbake, sa han: ”Ja, dere sover og hviler fortsatt. Men nå er det nok! Nå har tidspunktet kommet som Gud har bestemt at jeg, Menneskesønnen, skal bli utlevert til onde mennesker. ");
INSERT INTO norlb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Reis dere, stå opp, nå går vi herfra! Han som skal forråde meg kommer.” ");
INSERT INTO norlb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mens Jesus ennå snakket, kom Judas som var en av hans tolv disipler, sammen med en gjeng mennesker som var bevæpnet med sverd og køller. De var sendt ut av øversteprestene, de skriftlærde og folkets ledere. ");
INSERT INTO norlb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Forræderen hadde blitt enig med dem om et avtalt tegn og sagt: ”Den mannen som jeg hilser med et kyss, han er det. Ham skal dere fange og føre bort under vakthold.” ");
INSERT INTO norlb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Så snart Judas hadde kommet dit, gikk han bort til Jesus. ”Mester”, sa han, og ga ham et velkomstkyss. ");
INSERT INTO norlb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Da grep folkene Jesus og holdt ham fast. ");
INSERT INTO norlb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Men en av disiplene dro sverdet sitt og hogg øret av øverstepresten sin tjener. ");
INSERT INTO norlb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus spurte dem: ”Er jeg en så farlig forbryter at dere var nødt til å bevæpne dere med sverd og køller for å fange meg? ");
INSERT INTO norlb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hvorfor arresterte dere meg ikke på tempelplassen? Hver dag har jeg vært sammen med dere og undervist uten at dere har grepet meg. Alt dette har skjedd for at det som Gud hadde forutsagt om meg i Skriften, skulle bli virkelighet.” ");
INSERT INTO norlb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","I dette øyeblikket ga alle disiplene opp og flyktet fra Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","En ung mann, som bare hadde et linklede rundt seg, fulgte etter Jesus. De forsøkte da å fange ham, ");
INSERT INTO norlb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","men han gjorde seg fri fra linkledet og flyktet naken bort. ");
INSERT INTO norlb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","De førte Jesus til øverstepresten sitt hus. Innen kort tid var alle øversteprestene, folkets ledere og de skriftlærde samlet. ");
INSERT INTO norlb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter fulgte etter på avstand og klarte å ta seg helt inn på gårdsplassen. Der slo han seg ned blant tjenerne og varmet seg ved bålet som var tent opp. ");
INSERT INTO norlb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Inne i huset forsøkte øversteprestene og hele Det jødiske rådet å finne vitneforklaringer som kunne felle Jesus og være nok til å få ham dømt til døden. Men de fant ingen. ");
INSERT INTO norlb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mange vitnet falskt, men vitnene snakket hele tiden mot hverandre. ");
INSERT INTO norlb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Til sist kom noen fram med denne falske påstanden: ");
INSERT INTO norlb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","”Vi har hørt ham si: ’Jeg skal rive ned templet som er bygget av mennesker, og på tre dager skal jeg bygge opp et annet uten menneskelig hjelp!’ ” ");
INSERT INTO norlb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Heller ikke på dette punktet stemte vitnemålene deres over ens. ");
INSERT INTO norlb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Øverstepresten sto nå opp foran rådet og sa til Jesus: ”Hvorfor svarer du ikke? Har du sagt dette eller ikke?” ");
INSERT INTO norlb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Men Jesus tidde og svarte ham ikke med ett eneste ord. Da stilte øverstepresten enda et spørsmål: ”Er du Messias, den lovede kongen, Guds sønn?” ");
INSERT INTO norlb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","”Ja, det er jeg”, svarte Jesus, ”og dere skal få se meg, Menneskesønnen, sitte ved Guds høyre hånd og regjere, og dere skal få se meg komme på himmelens skyer.” ");
INSERT INTO norlb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Da slet øverstepresten i stykker klærne sine og ropte: ”Det er ikke bruk for flere vitner. Dere har selv hørt at han spotter Gud. Hvilken dom skal han få?” Da stemte alle for at han skulle bli dømt til døden. ");
INSERT INTO norlb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Senere begynte noen å spytte på ham, og de satte bind for øyne hans og slo ham i ansiktet med knyttnevene. ”Vis at du er en profet som kan avsløre hemmeligheter ved Guds hjelp”, ironiserte de. Og vaktene ga ham ørefiker. ");
INSERT INTO norlb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","I mens ventet Peter nede på gårdsplassen. En av tjenestejentene til øverstepresten kom og fikk øye på Peter som satt og varmet seg ved bålet. Hun satte øynene i ham og sa: ”Du var vel også sammen med han der Jesus fra Nasaret?” ");
INSERT INTO norlb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Men Peter protesterte og sa: ”Jeg vet ikke en gang hva du prater om!” Litt etter gikk Peter ut i den ytre gården. Akkurat i det øyeblikket gol hanen. ");
INSERT INTO norlb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Etter en stund fikk den samme tjenestejenta øye på Peter og sa på nytt til dem som sto rundt: ”Han er også en av dem!” ");
INSERT INTO norlb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Men Peter nektet også denne gangen. Litt seinere sa de som sto der til Peter: ”Jo, visst, du er en av dem. Du kommer også fra Galilea.” ");
INSERT INTO norlb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peter bannet og lovet dyrt og hellig: ”Jeg kjenner ikke denne mannen som dere prater om!” ");
INSERT INTO norlb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I samme øyeblikk gol hanen for andre gangen. Plutselig kom Peter til å huske på det Jesus hadde sagt til ham: ”Før hanen galer to ganger, skal du ha fornektet meg tre ganger.” Og han begynte å gråte. ");
INSERT INTO norlb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tidlig neste morgen samlet øversteprestene, folkets ledere og de skriftlærde, hele Det jødiske rådet seg for å drøfte saken videre om Jesus. De bandt Jesus, førte ham bort og overlot ham til Pilatus, som var den romerske landshøvdingen på den tiden. ");
INSERT INTO norlb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus spurte Jesus: ”Er du jødenes konge?” Han svarte: ”Det er du selv som kaller meg dette.” ");
INSERT INTO norlb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Øversteprestene anklaget Jesus for en rekke forskjellige forbrytelser, og Pilatus spurte ham: ”Hvorfor sier du ingenting? Du hører jo alt det de anklager deg for!” ");
INSERT INTO norlb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Til Pilatus sin store forbauselse svarte ikke Jesus med ett eneste ord. ");
INSERT INTO norlb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ved påskehøytiden brukte alltid Pilatus å frigi en fange etter ønske fra folket, samme hvem jødene ville ha fri. ");
INSERT INTO norlb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nettopp nå satt det en mann fengslet som het Barabbas. Han hadde sammen med noen andre blitt dømt for drap under et politisk opprør. ");
INSERT INTO norlb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Folket begynte å samle seg rundt Pilatus for å be ham gjøre som han alltid pleide. ");
INSERT INTO norlb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","”Er det jødenes konge dere vil at jeg skal slippe fri?” spurte Pilatus. ");
INSERT INTO norlb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Han visste mer enn godt at øversteprestene bare hadde overlatt Jesus til ham fordi de var misunnelige på ham. ");
INSERT INTO norlb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Øversteprestene hisset nå opp folket og fikk dem til å kreve at Barabbas skulle bli satt fri i stedet for Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus spurte på nytt: ”Hva skal jeg da gjøre med denne mannen som dere kaller jødenes konge?” ");
INSERT INTO norlb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","”La ham bli spikret fast på et kors!” ropte de tilbake. ");
INSERT INTO norlb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","”Men hva ondt har han gjort?” spurte Pilatus. Da skrek de enda høyere: ”La ham bli spikret fast på et kors!” ");
INSERT INTO norlb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Til slutt ga Pilatus etter og løslot Barabbas, etter som han ville gjøre folket til lags. Dette innebar at Jesus ble overlatt til å bli pisket og etterpå utlevert til soldatene for at de skulle føre ham bort og spikre ham til korset. ");
INSERT INTO norlb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","De romerske soldatene førte først Jesus inn på gårdsplassen utenfor huset til landshøvdingen. Der var hele vaktstyrken blitt kalt sammen. ");
INSERT INTO norlb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","De kledde på han en rød kappe og laget en krone av torner som de presset ned rundt hodet hans. ");
INSERT INTO norlb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","Så slo de Jesus i hodet med en stav, spytte på han, falt på kne og lot som om de hyllet han. ”Leve jødenes konge”, ropte de. ");
INSERT INTO norlb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Til slutt når de hadde blitt lei av å håne han, tok de av han den røde kappen og kledde han i hans egne klær og førte Jesus bort for å spikre han fast på korset. ");
INSERT INTO norlb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","På veien til stedet der henrettelsen skulle skje, støtte soldatene på Simon fra Kyréne, han var far til Aleksander og Rufus. Tilfeldigvis var han på vei fra landsbygda inn til Jerusalem, og de tvang ham til å bære korset for Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Soldatene førte Jesus til det stedet som ble kalt Golgata og som betyr Hodeskallen. ");
INSERT INTO norlb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Der ga de ham vin blandet med myrra, men han nektet å drikke det. ");
INSERT INTO norlb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Etter hvert spikret de Jesus fast på korset og delte klærne hans mellom seg ved å kaste lodd om plaggene. ");
INSERT INTO norlb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Klokken var omkring ni på morgenen da de spikret ham til korset. ");
INSERT INTO norlb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Over ham hadde de satt opp en plakat med teksten: ”Jødenes konge”, for å vise hva han var anklaget for. ");
INSERT INTO norlb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Samtidig med Jesus ble også to forbrytere spikret fast, hver på sitt kors. En på hver side av Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","De som gikk forbi stedet der henrettelsen hadde skjedd, hånte Jesus, ristet på hodet og sa: ”Var det ikke du som kunne rive ned templet og bygge det opp igjen på tre dager? ");
INSERT INTO norlb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hjelp deg selv nå og stig ned fra korset.” ");
INSERT INTO norlb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Til og med øversteprestene og de skriftlærde gjorde seg lystige på hans bekostning og fleipte til hverandre. ”Han var jo så veldig god til å hjelpe andre”, sa de, ”men seg selv han kan ikke hjelpe! ");
INSERT INTO norlb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Skulle han liksom være Messias, Israels lovede konge? Ja, om han nå stiger ned fra korset, da skal vi nok tro ham!” Også de som hadde blitt spikret fast på sine kors sammen med Jesus, hånte ham. ");
INSERT INTO norlb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Da klokka var tolv, ble det plutselig mørkt over hele landet. Mørket varte helt fram til klokka tre. ");
INSERT INTO norlb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Da klokka var rundt tre ropte Jesus med kraftig stemme: ”Eloi, Eloi, lama sabaktani?” som betyr: ”Min Gud, min Gud, hvorfor har du forlatt meg?” ");
INSERT INTO norlb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Noen av de som sto i nærheten, misforsto det han sa og trodde at han ropte på Elia. ");
INSERT INTO norlb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","En av dem sprang bort og fylte en svamp med sur vin og satte den på en stang og holdt den opp så han kunne få drikke. ”La oss se om Elia kommer og tar ham ned”, sa han. ");
INSERT INTO norlb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Men Jesus ropte høyt og sluttet å puste. ");
INSERT INTO norlb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","I samme øyeblikk revnet forhenget som henger foran Det aller helligste rommet i templet i to deler, fra toppen og helt ned. ");
INSERT INTO norlb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Da den romerske offiseren som sto nær korset, så på hvilken måte Jesus døde, ropte han: ”Denne mannen var virkelig Guds sønn!” ");
INSERT INTO norlb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Noen kvinner sto litt lenger unna fra stedet der henrettelsen skjedde og så alt som forgikk. Blant dem var Maria Magdalena, Maria, hun som var mor til Jakob den yngre og Joses og Salome. ");
INSERT INTO norlb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","De hadde fulgt Jesus og hjulpet han mens ham var i Galilea. Nå sto de der sammen med mange andre kvinner som var kommet i følge med Jesus opp til Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Alt dette skjedde på fredagen, forberedelsesdagen, altså dagen før hviledagen. Da kvelden nærmet seg, ");
INSERT INTO norlb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","var Josef fra Arimatea modig nok så han gikk til Pilatus for å be om å få ta hånd om kroppen til Jesus. Josef var et respektert medlem av Det jødiske rådet, en mann som med iver ventet på at Gud skulle begynne å regjere blant menneskene. ");
INSERT INTO norlb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus hadde vanskelig for å tro at Jesus allerede var død. Derfor kalte han til seg den romerske offiseren for å spørre ham om det var tilfelle. ");
INSERT INTO norlb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Da offiseren bekreftet at Jesus virkelig var død, fikk Josef tillatelse til å ta hånd om kroppen hans. ");
INSERT INTO norlb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josef gikk straks av sted og kjøpte lintøy. Etterpå tok han Jesus ned fra korset, svøpte han i tøyet og la ham i en grav som var hogget ut i fjellet. Etter dette rullet han den store steinen på plass foran inngangen til graven. ");
INSERT INTO norlb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Både Maria Magdalena og Maria, Joses mor, så hvor han la Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","På lørdagskvelden, etter at hviledagen var over, kjøpte Maria Magdalena, Salome og Maria som var Jakob sin mor, aromatiske oljer for å gå og salve kroppen til Jesus. ");
INSERT INTO norlb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tidlig søndags morgen, like før solen sto opp, gikk de ut til graven. ");
INSERT INTO norlb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Underveis spurte de seg: ”Hvem skal rulle bort steinen fra inngangen for oss?” ");
INSERT INTO norlb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Men da de kom fram, så de at steinen, som var svært tung, allerede var rullet bort. ");
INSERT INTO norlb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","De gikk inn i den åpne graven, og på høyre siden satt en ung mann kledd i en lang hvit drakt. Kvinnene ble svært forskrekket. ");
INSERT INTO norlb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Den unge mannen sa: ”Vær ikke redde. Dere leter etter Jesus fra Nasaret, han som ble henrettet på et kors. Han har stått opp og er blitt levende igjen. Han er ikke her. Se, dette er stedet der kroppen hans ble lagt. ");
INSERT INTO norlb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gå nå og si til disiplene, og spesielt til Peter, at Jesus skal gå i forveien for dem til Galilea. Der skal de få se ham, akkurat som han sa før han døde.” ");
INSERT INTO norlb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kvinnene sprang skjelvende bort fra graven. De var så sjokkerte at de ikke våget å fortelle til noen om det de hadde vært vitne til. Etter dette fortalte de helt kort om alt det de hadde fått befaling om til Peter og de andre som var med ham. Senere sendte Jesus disiplene ut fra øst til vest med budskapet. Dette er det Hellige og udødelige budskapet om frelse og evig liv. Ja, dette er sant! ");
INSERT INTO norlb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Det var tidlig søndag morgen, dagen etter hviledagen, da Jesus sto opp fra de døde. Den første personen han viste seg for, var Maria Magdalena. Hun var den kvinnen som han hadde satt fri fra sju onde ånder. ");
INSERT INTO norlb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria gikk og fortalte det til dem som hadde fulgt Jesus og som nå sørget og gråt. ");
INSERT INTO norlb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Da de fikk høre at han levde og hadde vist seg for henne, trodde de ikke på det. ");
INSERT INTO norlb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Senere viste Jesus seg for to av disiplene mens de var på veien fra Jerusalem og ut på landsbygden. Først kjente de ham ikke igjen, etter som utseendet hans var forandret. ");
INSERT INTO norlb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Da de litt etter forsto hvem han var, skyndte de seg av sted og fortalte det til de andre. Ingen trodde på dem! ");
INSERT INTO norlb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Litt seinere viste han seg for sine elleve disipler mens de spiste sammen. Han spurte hvorfor de hadde så vanskelig for å tro, og hvorfor de så hardnakket nektet å stole på dem som hadde sett ham etter at han hadde stått opp fra de døde? ");
INSERT INTO norlb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Han sa: ”Gå ut i hele verden og spre budskapet om meg til alle menneskene. ");
INSERT INTO norlb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Den som tror og blir døpt, skal bli frelst, men den som nekter å tro, skal bli dømt. ");
INSERT INTO norlb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Og jeg skal gi kraft til dem som tror, slik at de kan gjøre mirakler og tegn. De skal drive ut onde ånder i navnet mitt, og de skal få evne til å snakke nye språk. ");
INSERT INTO norlb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","De skal uten risiko kunne hanskes med slanger, de skal ikke bli skadet selv om de drikker noe giftig og de skal legge hendene på de syke og gjøre dem friske.” ");
INSERT INTO norlb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Da Herren Jesus hadde sagt dette, ble han tatt opp til himmelen og satte seg ved Guds høyre hånd for å regjere. ");
INSERT INTO norlb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Disiplene gikk ut over alt og forkynte for menneskene, og Herren var med og bekreftet budskapet gjennom de miraklene som fulgte med virksomheten.");
INSERT INTO norlb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Kjære Teofilus! Mange har allerede skrevet om Jesus og hans liv og alt som har skjedd iblant oss. Deres fortellinger bygger på det vi har hørt fra øyenvitnene som var med fra begynnelsen av, og som siden spredde budskapet om Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nå vil også jeg skrive ned alt i sin sammenheng for deg. Jeg har gått nøye gjennom alle fakta helt fra begynnelsen av. ");
INSERT INTO norlb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Det har jeg gjort for at du skal forstå at du kan stole på alle opplysningene du har fått. Her er fortellingen min: ");
INSERT INTO norlb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Da Herodes var konge i Judea, var det en prest der som het Sakarja. Han tilhørte Abia sin avdeling blant prestene. Kona hans Elisabet var en slektning av Aron, han som var stamfar til alle prester blant Israels folk. ");
INSERT INTO norlb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakarja og Elisabet var begge nøye med å være lydige mot Herren Gud og følge alle hans bud og forskrifter. ");
INSERT INTO norlb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dessverre hadde de ingen barn, for Elisabet kunne ikke få barn. Begge hadde nå blitt gamle. ");
INSERT INTO norlb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","En dag da det arbeidslaget som Sakarja var en del av, tjente som prester i templet, kastet de som vanlig lodd om hvem som skulle få gå inn og tenne røkelse for Herren Gud. Loddet falt på Sakarja. ");
INSERT INTO norlb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mens ofringen pågikk sto folket utenfor på tempelplassen og ba. ");
INSERT INTO norlb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Plutselig, mens Sakarja var opptatt med oppgaven, fikk han se en engel fra Herren stå til høyre for alteret. Han ble fryktelig redd. ");
INSERT INTO norlb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Men engelen sa: ”Vær ikke redd, Sakarja! Jeg har kommet for å fortelle deg at Herren vil svare på bønnene dine. Du og din kone Elisabet skal få en sønn. Du skal kalle ham Johannes. ");
INSERT INTO norlb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hans fødsel vil gjøre dere svært glade og lykkelige. Mange andre skal også glede seg over hans fødsel. ");
INSERT INTO norlb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Han skal bli en av Herrens store tjenere. Vin eller sterke drikker skal han aldri smake, og han skal bli fylt med Guds Hellige Ånd før han er født. ");
INSERT INTO norlb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Han skal få mange blant Israels folk til å vende om til Herren, deres Gud. ");
INSERT INTO norlb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Han vil bli en mann av samme kraftfulle natur og Ånd som Elia var, og han skal bli en forløper til Messias, den lovede kongen, og forberede folket på ankomsten hans. Han skal lære fedrene å elske barna sine, og hjelpe de opprørske til å gjøre som Herren vil.” ");
INSERT INTO norlb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakarja sa til engelen: ”Hvordan kan jeg være sikker på at dette virkelig kommer til å skje? Jeg er jo en gammel mann, og Elisabet kan ikke lenger få barn.” ");
INSERT INTO norlb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Da sa engelen: ”Jeg er Gabriel, og jeg står foran Guds trone. Det er han som har sendt meg til deg med denne glade nyheten. ");
INSERT INTO norlb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Men etter som du ikke trodde på meg, skal du bli stum og ikke kunne snakke før barnet er født. For det jeg har sagt, skal bli virkelighet på den tiden Gud har bestemt.” ");
INSERT INTO norlb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Utenfor sto folket og ventet på at Sakarja skulle komme ut, og de begynte å lure på hvorfor han drøyde så lenge. ");
INSERT INTO norlb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Da han endelig kom ut, kunne han ikke snakke, men de forsto av faktene han laget, at han måtte ha sett et syn der inne. ");
INSERT INTO norlb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Da Sakarja hadde avsluttet sin tjeneste i templet dro han hjem igjen. ");
INSERT INTO norlb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Like etterpå ble kona hans, Elisabet, gravid og holdt seg borte fra folk i fem måneder. ");
INSERT INTO norlb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","”Tenk så god Herren er”, jublet hun. ”Han har latt meg bli gravid, slik at jeg slipper å gå skamfull over å ikke ha fått noe barn.” ");
INSERT INTO norlb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Da Elisabet var gravid i sin sjette måned, sendte Gud engelen Gabriel til en ung jente i byen Nasaret i Galilea. ");
INSERT INTO norlb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Navnet hennes var Maria, og hun var trolovet med en mann som het Josef, som tilhørte etterkommerne av kong David. ");
INSERT INTO norlb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Engelen Gabriel viste seg nå for henne og sa: ”Jeg hilser deg, Maria! Herren fryder seg over deg, og han er med deg!” ");
INSERT INTO norlb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria ble virkelig forskrekket og undret seg på hva engelen kunne mene. ");
INSERT INTO norlb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Men engelen sa: ”Vær ikke redd, Maria! Gud har noe godt i vente for deg. ");
INSERT INTO norlb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Du skal bli gravid og føde en sønn, og du skal kalle ham Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Han skal være stor og bli kalt Guds sønn. Herren Gud skal gjøre ham til konge, for han skal arve sin stamfar Davids trone. ");
INSERT INTO norlb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Han skal regjere over Israels folk for evig, og hans kongsmakt skal aldri ta slutt.” ");
INSERT INTO norlb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Da spurte Maria engelen: ”Men hvordan skal jeg kunne bli gravid? Jeg har jo ikke vært sammen med noen mann.” ");
INSERT INTO norlb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Engelen svarte: ”Guds Hellige Ånd skal komme over deg, og Guds kraft skal omslutte deg. Derfor skal det barnet som du føder være hellig og bli kalt Guds sønn. ");
INSERT INTO norlb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Din slektning Elisabet venter også barn, og det til tross for sin høye alder. Hun, som de sa var steril, er nå i sin sjette måned! ");
INSERT INTO norlb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ingen ting er umulig for Gud!” ");
INSERT INTO norlb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria sa: ”Jeg vil være lydig mot Herren Gud og tjene ham. La det bli som du har sagt.” Etter dette forsvant engelen. ");
INSERT INTO norlb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Noen dager seinere skyndte Maria seg av sted til Elisabet. Hun dro opp til den byen som lå i fjellene Judea der Sakarja bodde, og gikk inn i huset og hilste. ");
INSERT INTO norlb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Da Elisabet hørte Maria sin hilsen, sparket barnet i magen hennes, og hun ble fylt av Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Høyt ropte hun til Maria: ”Gud har gitt deg det mest vidunderlige en kvinne kan få, og all velsignelse har han gitt til barnet ditt. ");
INSERT INTO norlb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Vilken ære det er at moren til min Herre kommer på besøk. ");
INSERT INTO norlb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","I samme øyeblikk som du hilste på meg, og jeg hørte stemmen din, sparket barnet av glede i magen min. ");
INSERT INTO norlb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Du kan være lykkelig som stolte på Herren Gud, for han skal innfri løftet sitt til deg.” ");
INSERT INTO norlb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria svarte: ”Jeg vil hylle Herren av hele hjertet mitt! ");
INSERT INTO norlb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Jeg jubler over Gud, han som frelste meg! ");
INSERT INTO norlb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Han har vendt sin oppmerksomhet mot meg, og lar en svak kvinne få tjene ham. Fra denne stund skal menneskene i alle tider fortelle om min lykke. ");
INSERT INTO norlb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Han, den hellige og mektige, har gjort fantastiske ting for meg. ");
INSERT INTO norlb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Han viser evig medfølelse med alle dem som tilber ham. ");
INSERT INTO norlb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hans makt er stor, han er full av kraft! De stolte og selvsikre bøyer han. ");
INSERT INTO norlb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Herskere styrter han ned fra tronen deres, men de ydmyke opphøyer han. ");
INSERT INTO norlb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Han metter de sultne med sine gaver, men de rike driver han bort med tomme hender. ");
INSERT INTO norlb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Han hjelper folket sitt Israel! Han glemmer ikke det løfte han ga til forfedrene våre, ");
INSERT INTO norlb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","for han lovet vår stamfar Abraham og etterkommerne hans alltid å være god mot dem.” ");
INSERT INTO norlb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ble værende hos Elisabet omkring tre måneder og vendte da tilbake til hjemmet sitt. ");
INSERT INTO norlb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ventetiden for Elisabet var nå slutt, og tiden for å føde var kommet. Hun fikk en gutt. ");
INSERT INTO norlb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nyheten om hvordan Herren Gud hadde vært god mot henne spredde seg raskt blant naboer og slektninger, og alle gledet seg på hennes vegne. ");
INSERT INTO norlb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Da gutten var åtte dager gammel, samlet alle slektningene og vennene seg for å være med i seremonien da de omskar gutten. Alle trodde at han skulle få navnet Sakarja etter faren sin. ");
INSERT INTO norlb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Men Elisabet sa: ”Nei, han skal hete Johannes.” ");
INSERT INTO norlb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","”Hvorfor det?” spurte de. ”Det finnes jo ingen annen i slekten din som heter det.” ");
INSERT INTO norlb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","De vendte seg mot faren og forsøkte ved hjelp av tegn og fakter å spørre ham hva han mente om navnet. ");
INSERT INTO norlb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Da ba ham om noe å skrive på, og til alles forbauselse skrev han: ”Han skal hete Johannes.” ");
INSERT INTO norlb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","I samme øyeblikk kunne Sakarja snakke igjen, og han begynte å hylle og tilbe Gud. ");
INSERT INTO norlb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Alle som bodde i nærheten, ble helt forskrekket, og nyheten om hva som hadde skjedd, spredde seg i fjellbygdene i Judea. ");
INSERT INTO norlb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","De som hørte om det som hadde skjedd husket det godt og spurte seg etter som tiden gikk: ”Hva kommer det til å bli av dette barnet når han vokser opp? Herren Gud er med ham på en spesiell måte.” ");
INSERT INTO norlb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Og Sakarja, som var far til barnet, ble fylt av Guds Hellige Ånd og bar fram et budskap fra Gud med disse ordene: ");
INSERT INTO norlb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","”La oss hylle Herren, Israels Gud, for han kommer til folket sitt og setter det fri. ");
INSERT INTO norlb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Han sender oss en mektig frelser fra sin tjener kong Davids slekt, ");
INSERT INTO norlb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nøyaktig som han for lenge siden lovet ved profetene sine, ");
INSERT INTO norlb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","en som kan frelse oss fra våre fiender, ja, frelse oss fra alle som hater oss. ");
INSERT INTO norlb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Gud har vært god mot forfedrene våre, og han holder sitt Hellige løfte til Abraham: ");
INSERT INTO norlb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","At vi skal bli satt fri fra våre fiender og få tjene Gud uten frykt, ");
INSERT INTO norlb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","og at vi skal få tilhøre Gud og være skyldfri innfor ham for evig. ");
INSERT INTO norlb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Og du, min lille sønn, du skal bli kalt en Guds profet, for du skal holde fram Guds budskap fra Herren og rydde vei for ham. ");
INSERT INTO norlb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Du skal vise hans folk at frelsen er kommet, og at de kan få tilgivelse for syndene sine. ");
INSERT INTO norlb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","På grunn av Guds kjærlighet og omsorg for oss, skal et lys komme ned til oss fra det høye og skinne for alle som lever i mørke og dødens frykt. Dette lys skal lede oss på fredens vei.” ");
INSERT INTO norlb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Johannes vokste opp og ble åndelig sterk. Han holdt til ute i ødemarken til den dagen da han skulle begynne å forkynne for folket i Israel. ");
INSERT INTO norlb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","På denne tiden hadde den romerske keiseren ved navn Augustus gitt befaling om at alle innbyggerne i Romerriket skulle registreres i manntallet for å betale skatt. ");
INSERT INTO norlb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Det var den første skatteregistreringen, og den ble gjort da Kvirinius var landshøvding i Syria. ");
INSERT INTO norlb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hver og en måtte reise til hjembyen sin for å registrere seg der. ");
INSERT INTO norlb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Etter som Josef tilhørte slekten til kong David, måtte han reise fra byen Nasaret i Galilea til Betlehem i Judea, som var kong Davids by. ");
INSERT INTO norlb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Han tok med seg Maria, som han var trolovet med, og som nå ventet barn. ");
INSERT INTO norlb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mens de var i Betlehem, kom tiden da hun skulle føde, ");
INSERT INTO norlb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","og hun fødte sitt første barn, en gutt. Hun svøpte han i myke remser av tøy og la ham i krybben som var beregnet på dyrene, for det var det ikke plass for dem inne i vertshuset. ");
INSERT INTO norlb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Samme natten var noen gjetere ute og voktet sauene sine på beitemarkene utenfor byen. ");
INSERT INTO norlb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Da sto det plutselig en engel fra Herren Gud foran dem, og Herrens herlighet lyste omkring dem. De ble fryktelig redde, ");
INSERT INTO norlb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","men engelen beroliget alle og sa: ”Vær ikke redde! Jeg kommer til dere med en stor glede som gjelder hele folket, og som skal gjøre alle glade! ");
INSERT INTO norlb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","I natt er han som skal frelse dere, blitt født i Betlehem. Han er Messias, den lovede kongen, Herren. ");
INSERT INTO norlb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dere skal kjenne ham igjen på det at han er svøpt i remser av tøy og ligger i en krybbe.” ");
INSERT INTO norlb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Plutselig var engelen omgitt av et mektig kor av engler fra himmelen som hyllet Herren Gud og sang: ");
INSERT INTO norlb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","”Ære til Gud i himmelen, og fred på jorden til dem som gjør Gud glad.” ");
INSERT INTO norlb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Da englene hadde dratt tilbake til himmelen, sa gjeterne til hverandre: ”Kom! Vi må gå til Betlehem og se det fantastiske som har skjedd, og som Herren har latt oss få vite om!” ");
INSERT INTO norlb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Så sprang de inn til byen, og fant Maria og Josef og det nyfødte barnet som lå i krybben. ");
INSERT INTO norlb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Da de hadde sett barnet, fortalte de til alle det engelen hadde sagt om den nyfødte. ");
INSERT INTO norlb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Alle som hørte dette, undret seg over fortellingen til gjeterne. ");
INSERT INTO norlb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria la hvert ord på sitt minne og tenkte ofte på det. ");
INSERT INTO norlb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Gjeterne dro tilbake til beitemarkene og hyllet og æret Gud for alt det de hadde fått se og høre. Fra begynnelse til slutt var det nøyaktig som engelen hadde fortalt. ");
INSERT INTO norlb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Åtte dager seinere, da gutten skulle bli omskåret, fikk han navnet Jesus. Det var dette navnet engelen hadde gitt ham før moren var blitt gravid. ");
INSERT INTO norlb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Da tiden kom for at foreldrene i tråd med Moseloven, skulle foreta det vanlige renselsesoffer, tok de Jesus med til templet i Jerusalem for å bære ham fram for Herren Gud. ");
INSERT INTO norlb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Herren har jo sagt i sin lov at dersom kvinnens første barn er en gutt, da skal han tilhøre Herren. ");
INSERT INTO norlb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Samtidig bar foreldrene fram offeret, som i tråd med loven skulle være et par turtelduer eller to unge duer. ");
INSERT INTO norlb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","På denne tiden bodde det en mann som het Simeon, i Jerusalem, en god mann som levde etter Guds vilje og var fylt av Guds Hellige Ånd. Med iver ventet han på at Israels redningsmann skulle komme. ");
INSERT INTO norlb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Guds Hellige Ånd hadde gjort det klart for ham at han ikke skulle dø før han hadde sett Messias, den kongen som Herren Gud hadde lovet å sende. ");
INSERT INTO norlb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Akkurat denne dagen hadde Guds Ånd minnet Simeon om å gå til templet. Da Maria og Josef kom for å bære fram Jesus for Herren Gud på den måten som loven forlangte, ");
INSERT INTO norlb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","var Simeon allerede på plass. Han tok barnet i armene sine, takket Gud og sa: ");
INSERT INTO norlb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","”Herre, nå kan jeg dø i fred, slik som du har lovet! ");
INSERT INTO norlb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","For nå har jeg med egne øyne sett ham som du har bestemt til frelse for verden. ");
INSERT INTO norlb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Han er det lys som skal gjøre deg synlig for alle folk og gi ære til folket ditt Israel.” ");
INSERT INTO norlb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josef og Maria var grepet av det han sa om Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon ba Gud om å gi familien alt godt og sa til Maria: ”Mange i Israel kommer til å støte bort dette barnet, og det vil bli deres ulykke. Men for mange skal han bli til stor glede. Han skal være et tegn som folket strides om. ");
INSERT INTO norlb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ja, også du skal få lide, du skal kjenne det som om noen har stukket deg i hjertet. Men alt dette vil avsløre det som virkelig skjuler seg i det indre hos menneskene.” ");
INSERT INTO norlb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","En gammel kvinne, som het Hanna og som Gud hadde gitt evner til å holde fram budskap fra ham, var også i templet. Hun var datter til Fanuel fra Asjers stamme. Hun hadde vært gift i sju år da hun var ung, men hennes mann døde, og nå var hun 84 år. Hun dro aldri fra templet, men var der dag og natt og tjente Gud ved bønn og faste. ");
INSERT INTO norlb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nettopp da Simeon snakket med Maria og Josef, kom Hanna dit og begynte å takke og hylle Gud. Hun fortalte om Jesus for alle som ventet på at Jerusalem skulle bli satt fri. ");
INSERT INTO norlb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Da foreldrene hadde gjort alt det som Herren Gud krever i loven, vendte de tilbake til hjembyen sin Nasaret i Galilea. ");
INSERT INTO norlb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Der vokste den lille gutten opp og ble sterk. Han var uvanlig klok for sin alder, og Gud var med ham. ");
INSERT INTO norlb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Foreldrene til Jesus brukte hvert år å reise til Jerusalem for å delta i påskehøytiden. ");
INSERT INTO norlb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Da Jesus var tolv år, dro de dit som vanlig. ");
INSERT INTO norlb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Etter at festen var over og de skulle reise hjem, stoppet Jesus alene i Jerusalem, uten at foreldrene visste om det. ");
INSERT INTO norlb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Foreldrerne gikk en hel dag uten å savne ham, for de trodde at han var sammen med sine venner i reisefølget. Fram mot kvelden begynte de å spørre etter ham blant slektninger og venner. ");
INSERT INTO norlb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Da de ikke kunne finne ham noe sted, vendte de tilbake til Jerusalem for å lete etter ham der. ");
INSERT INTO norlb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","47","Etter å ha lett i tre dager, fant de ham til slutt i templet der han satt mitt blant de religiøse lærerne og diskuterte vanskelige spørsmål. Alle som hørte måten han ordla seg på, undret seg over hans intelligens og kloke svar. ");
INSERT INTO norlb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Foreldrene hans visste ikke hva de skulle tro, og Maria sa: ”Men Jesus, hvordan kunne du gjøre dette mot oss? Din far og jeg har vært så redde, og vi har lett etter deg over alt!” ");
INSERT INTO norlb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","”Hvorfor har dere lett etter meg?” svarte han. ”Visste dere ikke at jeg måtte være i min Fars hus, i templet?” ");
INSERT INTO norlb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Men de forsto ikke hva han mente. ");
INSERT INTO norlb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Senere fulgte han med hjem til Nasaret og var lydig mot foreldrene. Moren hans tenkte ofte på det som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus ble eldre og klokere for hver dag og var elsket av både Gud og mennesker. ");
INSERT INTO norlb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiden var kommet til det femtende regjeringsåret for den romerske keiseren Tiberius. Pontius Pilatus var landshøvding i Judea, Herodes var landsfyrste over Galilea, hans bror Filip var landsfyrste i Iturea og Trakonitis, og Lysanias hersket over Abilene. ");
INSERT INTO norlb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas og Kaifas var øversteprester. På denne tiden kom det et budskap fra Gud til Johannes, sønnen til Sakarja, som levde ute i ødemarken. ");
INSERT INTO norlb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Johannes dro til distriktet nær elven Jordan. Over alt underviste han folket om at de kunne få syndene sine tilgitt dersom de tok avstand fra synden, vendte seg om til Gud og lot seg døpe. ");
INSERT INTO norlb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dette hadde Gud forutsagt i det profeten Jesaja skrev i sin bok: ”En stemme roper i ødemarkent: ’Rydd vei for Herren! Gjør stiene rette for ham! ");
INSERT INTO norlb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Fyll dalene, senk alle fjell og høyder! Rett ut svingene og jevn ut de grunne og steinete veiene! ");
INSERT INTO norlb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Da skal alle mennesker få se Guds frelse.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mennesker i stort antall kom nå til Johannes for å bli døpt. Han talte strengt til dem og sa: ”Ormeyngel! Tror dere at dere kan unnslippe Guds kommende dom? ");
INSERT INTO norlb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nei, først må dere bevise at dere virkelig har vendt dere bort fra synden ved å gjøre det som er rett og riktig. Innbill dere ikke at dere kan slippe bort ved å tenke: ’Vi er trygge, for vi er jøder, og Abraham er vår stamfar.’ Jeg forsikrer dere at det ikke hjelper. Gud kan forvandle disse steinene her til jøder! ");
INSERT INTO norlb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dommen henger over hodet på dere, øksen har allerede begynt å hugge i trestammen. Hvert tre som ikke bærer god frukt skal bli hogget ned og kastet på ilden!” ");
INSERT INTO norlb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Da spurte folket: ”Hva vil du at vi skal gjøre?” ");
INSERT INTO norlb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Han svarte: ”Den som har to skjorter, skal gi bort den ene til den som ingen har. Og den av dere som har mat, skal gi til dem som er sultne.” ");
INSERT INTO norlb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Til og med tollere kom for å bli døpt, og de spurte: ”Hvordan kan vi vise at vi har sluttet å synde?” ");
INSERT INTO norlb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","”Gjennom det å være ærlige”, svarte han. ”Krev ikke mer i skatt enn det som de romerske myndighetene har gitt befaling om.” ");
INSERT INTO norlb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","”Og vi da, hva skal vi gjøre?” spurte noen soldater. Johannes svarte: ”Tving ikke til dere penger ved å bruke trusler og vold, men vær fornøyd med den lønnen dere har.” ");
INSERT INTO norlb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hele folket ventet på at Messias, den lovede kongen, snart skulle komme. Nå spurte de seg om det kunne være Johannes som var oppfyllelsen på det gamle løftet? ");
INSERT INTO norlb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Men Johannes svarte alle: ”Jeg døper dere med vann, men snart kommer en som er større enn meg. Han er så mektig at jeg ikke en gang er verdig til å løse opp remmene på sandalene hans. Han skal døpe dere med Guds Hellige Ånd og ild. ");
INSERT INTO norlb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Det er han som skal dømme verden. Han står ferdig til å skille de onde fra dem som følger Guds vilje, på samme måten som bonden når han skiller agnene fra hveten. Etter at han har renset opp på plassen der de tresker kornet, skal han samle hveten i laden, men agnene skal han brenne opp i en ild som aldri slokner.” ");
INSERT INTO norlb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","På mange forskjellige måter formante Johannes folket gjennom budskapet han bar fram. ");
INSERT INTO norlb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Johannes rettet også sterk kritikk mot Herodes, herskeren i Galilea. Særlig for hans forhold til Herodias, som var kona til broren hans, og for alt det andre onde han gjorde. ");
INSERT INTO norlb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Derfor fikk Herodes seinere satt Johannes i fengsel. På denne måten fikk han lagt enda en ny ond gjerning til den lange listen av misgjerninger han fra før av hadde pådratt seg. ");
INSERT INTO norlb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mye folk kom nå til Johannes for å bli døpt. Jesus kom også og lot seg døpe. Da Jesus etter dåpen sto der og ba, åpnet himmelen seg. ");
INSERT INTO norlb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Synlig senket Guds Hellige Ånd seg ned over ham i form av en due, og en stemme fra himmelen sa: ”Du er min elskede Sønn, du er min glede.” ");
INSERT INTO norlb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Jesus var rundt 30 år da han begynte å undervise folket og gjøre mirakler. Han ble ansett for å være sønnen til Josef. Far til Josef, og forfedrenes hans lenger tilbake hadde denne rekkefølgen: Eli, Mattat, Levi, Melki, Jannai, Josef, Mattatia, Amos, Nahum, Esli, Naggai, Ma`at, Mattatia, Sjimi, Josek, Joda, Johanan, Resa, Serubabel, Sealtiel, Neri, Melki, Addi, Kosam, Elmadam, Er, Josva, Elieser, Jorim, Mattat, Levi, Simeon, Juda, Josef, Jonam, Eljakim, Melea, Manna, Mattata, Natan, David, Isai, Obed, Boas, Salmon, Naksjon, Amminadab, Admin, Arni, Hesron, Peres, Juda, Jakob, Isak, Abraham, Tarah, Nakor, Serug, Re`u, Peleg, Eber, Salah, Kenan, Arpaksad, Sem, Noah, Lamek, Metusalah, Enok, Jered, Mahalael, Kenan, Enosj, Set. Set var sønn til Adam som ble skapt av Gud. ");
INSERT INTO norlb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Da Jesus kom tilbake fra elven Jordan, var han fylt av Guds Hellige Ånd. Ånden førte ham ut i ødemarken. ");
INSERT INTO norlb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Der ble han fristet av djevelen i 40 dager. I hele denne tiden spiste han ingenting, og ble til slutt sulten. ");
INSERT INTO norlb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Da sa djevelen til ham: ”Skap brød av disse steinene, dersom du nå er Guds sønn!” ");
INSERT INTO norlb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus svarte: ”Nei! Det står i Skriften: ’Menneskene lever ikke av brødalene.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Da førte djevelen ham opp på et høyt fjell og lot han i et øyeblikk skue ut over alle land i verden. ");
INSERT INTO norlb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Han sa: ”Jeg skal gi deg makten i verden og overdra all herligheten som finnes i den til deg. Alt dette er mitt, og jeg kan gi det til hvem jeg vil. ");
INSERT INTO norlb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Dersom du bare faller ned og tilber meg, skal det bli ditt.” ");
INSERT INTO norlb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus svarte: ”Det står i Skriften: ’Det er Herren, din Gud, du skal tilbe, og bare ham du skal tjene.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Da tok djevelen ham med til Jerusalem og stilte han øverst oppe på tempelmuren og sa: ”Hopp ned, dersom du virkelig er Guds sønn! ");
INSERT INTO norlb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Det står i Skriften: ’Gud skal befale sine engler å beskytte deg. ");
INSERT INTO norlb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","De skal bære deg på hendene, slik at du ikke skader deg mot noen stein.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus svarte: ”Det står også i Skriften: ’Du skal ikke sette Herren, din Gud, på prøve.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Da djevelen hadde fristet ham på alle måter, holdt han seg borte fra ham for en tid. ");
INSERT INTO norlb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Etter dette vendte Jesus tilbake til Galilea, fylt av Guds Ånd og kraft, og snart snakket folk om ham over alt. ");
INSERT INTO norlb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Han underviste i synagogene, og alle hyllet ham. ");
INSERT INTO norlb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Da han kom til Nasaret, byen der han hadde vokst opp, gikk han som vanlig til synagogen$1 på hviledagen. Han reiste seg for å lese fra Skriften. ");
INSERT INTO norlb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","De rakte ham profeten Jesaja sin bok. Han åpnet den og fant det stedet der det står: ");
INSERT INTO norlb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","”Herrens Ånd er over meg, for han har valgt meg ut for å bringe et gledens budskap til de fattige. Han har sendt meg å proklamere frihet for dem som er fanget, for å gi de blinde synet sitt, for å sette fri de diskriminerte ");
INSERT INTO norlb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","og rope ut en frelsens tid fra Herren.” ");
INSERT INTO norlb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Så rullet han sammen skriftrullen og leverte den til tjeneren og satte seg ned for å undervise. Alle i synagogen hadde øynene sine vendt mot ham og ventet med spenning på hva han ville si. ");
INSERT INTO norlb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Da forklarte han: ”I dag er dette stedet i Skriften blitt virkelighet, rett for øynene på dere.” ");
INSERT INTO norlb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Alle som lyttet, snakket vel om ham og undret seg over de vidunderlige ordene han bar fram. ”Hvordan kan dette ha seg?” sa de til hverandre. ”Han er jo bare sønnen til Josef.” ");
INSERT INTO norlb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Da sa han: ”Dere vil sikkert minne meg på ordspråket: ’Lege, leg deg selv!’ og sier til meg: ’Gjør de samme miraklene her i hjembyen din som vi har hørt at du gjorde i Kapernaum.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Han fortsatte: ”Jeg vet godt at ingen profet som bærer fram Guds budskap, blir akseptert i sin egen hjemby. ");
INSERT INTO norlb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tenk på profeten Elia. Jeg forsikrer dere at det var mange jødiske enker som trengte hjelp på hans tid, for det hadde ikke regnet på tre og et halvt år, og det var en fryktelig sultekatastrofe i landet. ");
INSERT INTO norlb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Men Elia ble ikke sendt til noen av dem, men fikk hjelpe en enke i Sarepta nær Sidon. ");
INSERT INTO norlb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tenk også på profeten Elisja, som helbredet syreren Na`aman, til tross for at det var mange jødiske spedalske som trengte hjelp.” ");
INSERT INTO norlb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Folket i synagogen ble rasende da de hørte dette. ");
INSERT INTO norlb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","De stormet opp og drev Jesus ut av byen, helt til kanten av det fjellet som byen var bygget på. De ville dytte ham utfor stupet. ");
INSERT INTO norlb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Men han gikk tvers gjennom folkemassen og dro bort. ");
INSERT INTO norlb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Noe seinere kom Jesus til Kapernaum i Galilea. Der underviste han folket i synagogen på hviledagen. ");
INSERT INTO norlb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","De var forbløffet over undervisningen hans, for han talte med makt og myndighet. ");
INSERT INTO norlb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","I synagogen var det denne dagen en mann som var besatt av en ond Ånd. Han begynte å rope: ");
INSERT INTO norlb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","”Hva har du med oss å gjøre, Jesus fra Nasaret? Har du kommet for å ta knekken på oss? Jeg vet hvem du er, du Guds Hellige tjener!” ");
INSERT INTO norlb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Men Jesus sa strengt til den onde ånden: ”Ti stille! Far ut av ham!” den onde ånden kastet mannen i gulvet foran øyne på alle og for så ut av ham uten å skade ham. ");
INSERT INTO norlb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Folket i synagogen ble forskrekket og begynte å diskutere seg i mellom: ”Hva er det med ordene til denne mannen? For en makt og myndighet de har! Han befaler de onde åndene å forlate sine offer, og straks farer de ut.” ");
INSERT INTO norlb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Og ryktet om ham spredde seg som en løpeild i hele distriktet. ");
INSERT INTO norlb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Så dro Jesus fra synagogen og gikk hjem til Simon. Svigermoren til Simon lå syk i høy feber, og alle ba at Jesus måtte helbrede henne. ");
INSERT INTO norlb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Da gikk han fram, bøyde seg ned over henne og ga befaling om at feberen skulle forlate henne. Straks ble hun fri feberen. Hun sto opp og begynte å lage mat til gjestene. ");
INSERT INTO norlb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","På kvelden, da solen holdt på å gå ned, kom alle i byen med sine syke til Jesus. Han la hendene på hver og en og helbredet de ulike sykdommene. ");
INSERT INTO norlb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mange ble også satt fri fra onde ånder, og da åndene for ut, ropte de: ”Du er Guds sønn!” Men han snakket strengt og forbød at de skulle si hvem han var, etter som de visste at han var Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tidlig neste morgen gikk Jesus videre, bort til et øde sted. Folket begynte å lete etter ham over alt. Da de til slutt fant ham, gjorde de alt de kunne, for å overtale ham til å stanse lenger i Kapernaum. ");
INSERT INTO norlb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Men han sa: ”Jeg må også gå til de andre byene for å spre det glade budskapet om at Gud vil frelse menneskene og gjøre alle til sitt eget folk. Det er derfor jeg har blitt sendt ut.” ");
INSERT INTO norlb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Han fortsatte med å tale til folket i synagogene i Judea. ");
INSERT INTO norlb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","En dag da Jesus sto ved Genesaretsjøen, presset folket på for å høre Guds budskap. ");
INSERT INTO norlb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Han fikk da se to tomme båter som noen fiskere hadde forlatt ved stranden mens de skyllet garna sine. ");
INSERT INTO norlb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Han steg om bord i en av båtene og ba Simon, han som eide den, å ro litt ut fra land. Mens han satt i båten, talte han til folket på land. ");
INSERT INTO norlb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Da han hadde sluttet å tale, sa han til Simon: ”Ro ut på dypt vann og kast ut noten, slik at dere får den fisken dere trenger!” ");
INSERT INTO norlb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","”Herre”, sa Simon, ”vi har arbeidet hardt i hele natt og har likevel ikke fått noe. Men etter som det er du som sier dette, skal vi forsøke på nytt.” ");
INSERT INTO norlb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Da de gjorde det, fikk de så mye fisk at noten holdt på å revne! ");
INSERT INTO norlb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Da vinket de på hjelp fra sine kamerater for å få dem ut med den andre båten, og snart var begge båtene så fulle med fisk at de holdt på å synke. ");
INSERT INTO norlb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Da Simon til slutt fattet hva som hadde skjedd, falt han på kne for Jesus og sa: ”Herre, gå fra meg! Jeg er en synder. Jeg kan ikke være i din nærhet.” ");
INSERT INTO norlb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Både han og de andre i båten hadde blitt helt forskrekket da de så hvor mye fisk de hadde fått. ");
INSERT INTO norlb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kompanjongene hans, som het Jakob og Johannes og var sønnene til Sebedeus, var like forskrekket. Jesus sa til Simon: ”Vær ikke redd! Fra nå av skal du fange mennesker i stedet!” ");
INSERT INTO norlb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Da de hadde rodd båtene i land, gikk de fra alt for å følge Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","En annen gang, da Jesus besøkte en by, møtte han en mann som var alvorlig angrepet av spedalskhet. Da mannen fikk se Jesus kastet han seg til jorden foran han og ba: ”Herre, om du vil, da kan du gjøre meg frisk.” ");
INSERT INTO norlb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus rakte ut hånden og rørte ved ham og sa: ”Det vil jeg. Du er frisk!” Straks forsvant spedalskheten. ");
INSERT INTO norlb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus forbød mannen å fortelle til noen det som hadde skjedd. Han sa: ”Gå i stedet til presten og la ham undersøke deg. Ta også med det offeret som Moses har bestemt at spedalske skal gi når de er blitt friske. Da kommer alle til å forstå at Gud har helbredet deg.” ");
INSERT INTO norlb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ryktet om Jesus spredde seg bare raskere og raskere. Et stort antall mennesker kom for å høre på ham og bli helbredet fra sykdommene sine. ");
INSERT INTO norlb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Derfor trakk han seg ofte bort til øde steder for å be. ");
INSERT INTO norlb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","En dag Jesus underviste, satt noen av fariseerne og de skriftlærde blant dem som lyttet. De hadde kommet fra byene i hele Galilea og Judea, og også fra Jerusalem. Guds kraft var over Jesus slik at han kunne helbrede. ");
INSERT INTO norlb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Da kom noen menn bærende på en båre der det lå en lam mann. De forsøkte å brøyte seg vei i folkemassen for å komme bort til Jesus, men de klarte ikke å ta seg fram. Derfor gikk de opp på taket og tok bort noen takstein og firte båren med den lamme mannen ned, rett foran Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Da Jesus så hvor stor tro de hadde, sa han til den lamme: ”Min sønn, jeg har tilgitt syndene dine.” ");
INSERT INTO norlb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","”Hva er dette for en fyr som spotter Gud på dette viset?” tenkte fariseerne og de skriftlærde. ”Det er jo bare Gud som kan tilgi synder.” ");
INSERT INTO norlb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus forsto hva de tenkte og sa: ”Hvorfor tenker dere at dette er å spotte Gud? ");
INSERT INTO norlb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Er det ikke like umulig for et menneske å si til den lamme: ’Reis deg opp og gå’ som det er å si ’Jeg tilgir deg syndene dine?’ ” ");
INSERT INTO norlb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Så vendte han seg til den lamme og sa: ”For å bevise at jeg, Menneskesønnen, har makt til å tilgi synder her på jorden, sier jeg deg: ’Reis deg opp, ta båren din og gå hjem!’ ” ");
INSERT INTO norlb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","26","Og straks reiste seg mannen opp, rett foran øynene på folket som var mer enn forbløffet. Mannen tok båren sin og gikk hjem, mens han hele tiden hyllet Gud. Alle som så det, ble helt forskrekket. Så begynte de å hylle Gud og gjentok gang på gang: ”Det vi har sett i dag, er helt utrolig, ja, virkelig helt utrolig!” ");
INSERT INTO norlb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Da Jesus seinere dro fra byen, fikk han se en toller som het Levi sitte utenfor tollboden. ”Kom og bli min disippel”, sa Jesus til ham. ");
INSERT INTO norlb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Uten å nøle reiste Levi seg, dro fra alt og fulgte Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi ordnet seinere til en fest for Jesus i huset sitt. Da de spiste sammen, deltok mange av kollegene til Levi som jobbet i tolletaten blant gjestene. Det var også mange andre gjester. ");
INSERT INTO norlb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseerne, og spesielt de skriftlærde blant dem, ble svært sinte og sa til disiplene: ”Hvordan kan dere synke så dypt at dere spiser sammen med tollere og syndere?” ");
INSERT INTO norlb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus svarte: ”Det er ikke de friske som trenger lege, men de som er syke. ");
INSERT INTO norlb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Min oppgave her på jorden er å føre syndere tilbake til Gud, ikke å ta hånd om dem som allerede følger hans vilje.” ");
INSERT INTO norlb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","De religiøse lederne anklaget også Jesus for en annen sak. De sa: ”Disiplene til døperen Johannes faster og ber regelmessig, og det gjør også disiplene til fariseerne. Men dine, de spiser og drikker og nyter livet i fulle drag!” ");
INSERT INTO norlb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Da svarte Jesus: ”Dere vil vel ikke pålegge bryllupsgjestene å gå fastende og sultne mens brudgommen er hos dem? ");
INSERT INTO norlb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Men en dag vil han bli tatt fra dem, og i tiden etter den dagen vil de nok faste. Det finnes tid og sted for alt.” ");
INSERT INTO norlb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus fortalte to eksempler som illustrerte dette: Han sa: ”Ingen river løs en bit tøy fra et nytt plagg som enda ikke er krympet, for å sy den på et gammelt plagg. Da blir jo først det nye plagget ødelagt, og for øvrig vil lappen krympe og dermed rive i stykker plagget som er gammelt. ");
INSERT INTO norlb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Og ingen heller ny vin i gamle skinnsekker, for når vinen gjærer, blir sekkene sprengt og ødelagt, og vinen renner ut. ");
INSERT INTO norlb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nei, ny vin må fylles i nye sekker. ");
INSERT INTO norlb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Men ingen som har drukket av den gamle vinen, har særlig lyst på den nye. Den gamle gylne årgangen er best, sier de.” ");
INSERT INTO norlb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","En hviledag, da Jesus og disiplene gikk langs noen kornåkrer, nappet disiplene av noen aks og gned mellom hendene for å kunne spise kornet. ");
INSERT INTO norlb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Men noen av fariseerne sa: ”Hvorfor gjør dere dette? Det er jo forbudt i Moseloven å høste på hviledagen.” ");
INSERT INTO norlb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Da svarte Jesus: ”Har dere aldri lest hva kong David gjorde da han og mennene hans ble sultne? ");
INSERT INTO norlb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Han gikk inn i Guds hus og spiste av det spesielle brødet som bare prestene har lov til å spise av og delte også ut til de andre. Dette var jo også et brudd på loven.” ");
INSERT INTO norlb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Videre sa Jesus til fariseerne: ”Jeg, Menneskesønnen, har rett til å avgjøre hva som er tillatt på hviledagen.” ");
INSERT INTO norlb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","En annen hviledag underviste Jesus i synagogen. Der satt det en mann som var handikappet i sin høyre hånd. ");
INSERT INTO norlb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","De skriftlærde og fariseerne holdt skarpt oppsyn med Jesus. Ville han våge å helbrede hånden til mannen på hviledagen? I så tilfelle ville de få noe å anklage ham for. ");
INSERT INTO norlb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus forsto godt hva de tenkte. Derfor sa han til mannen med den handikappede hånden: ”Reis deg og kom fram så alle kan se deg.” Mannen gjorde som Jesus sa. ");
INSERT INTO norlb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Så vendte Jesus seg til fariseerne og de skriftlærde og sa: ”La meg få spørre dere om en ting: Hva er tillatt å gjøre på hviledagen i følge Moseloven? Skal vi gjøre godt eller skal vi gjøre ondt? Skal vi redde liv eller skal vi drepe noen?” ");
INSERT INTO norlb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Etter tur satte han øynene i en etter en av tilskuerne, og sa til mannen: ”Rekk hånden din fram.” Da mannen gjorde det, ble hånden normal igjen! ");
INSERT INTO norlb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Motstanderne av Jesus ble rasende og begynte å prate med hverandre om hvordan de kunne få ryddet ham av veien. ");
INSERT INTO norlb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Noen dager seinere gikk Jesus opp på et fjell for å be. Han ba hele natten. ");
INSERT INTO norlb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Da det lysnet av dag, kalte han sammen disiplene og valgte ut tolv til å bli hans nærmeste disipler. ");
INSERT INTO norlb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Det var: Simon, som han ga navnet Peter, Simon sin bror Andreas, Jakob, Johannes, Filip, Bartolomeus, ");
INSERT INTO norlb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matteus, Tomas, sønnen til Alfeus som het Jakob, Simon, som ble kalt ”den ivrige”, ");
INSERT INTO norlb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jakob sønnen sin Judas og Judas Iskariot, han som seinere forrådte Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Da Jesus hadde kommet ned fra fjellet sammen med sine tolv utvalgte disipler, stanset de på en stor slette. Der hadde mange av disiplene fra den videre kretsen samlet seg. En stor folkemasse fra hele Judea og Jerusalem og fra kysten nær Tyrus og Sidon ");
INSERT INTO norlb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","hadde kommet for å høre ham og for å bli helbredet fra sykdommene sine. Jesus drev ut mange onde ånder. ");
INSERT INTO norlb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Alle forsøkte å røre ved ham, etter som det gikk ut en kraft fra ham som gjorde folk friske. ");
INSERT INTO norlb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Han vendte seg til disiplene og sa: ”Lykkelige er dere som innser at dere er fattige, for dere skal få være Guds eget folk! ");
INSERT INTO norlb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lykkelige er dere som nå sulter, for dere skal bli mettet. Lykkelige er dere som nå gråter, for dere skal få smile og le. ");
INSERT INTO norlb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ja, dere er lykkelige når de hater dere, tar avstand fra dere, håner dere og taler dårlig om dere fordi dere er disipler av meg, Menneskesønnen. ");
INSERT INTO norlb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gled dere når dette skjer! Ja, dans av glede, for Gud skal lønne dere. Husk på at profetene som før i tiden bar fram Guds budskap, ble like dårlig behandlet av forfedrene. ");
INSERT INTO norlb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Men ulykken vil ramme dere som er rike, for dere har allerede tatt ut gledene deres. ");
INSERT INTO norlb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ulykken vil ramme dere som nå er mette, dere vil måtte gå sultne. Ulykken vil ramme dere som nå ler, for dere vil måtte sørge og gråte. ");
INSERT INTO norlb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ja, ulykken vil ramme dere som det nå blir snakket godt om. Husk på at de profetene som før i tiden opptrådte med falske budskap om Gud, ble populære og behandlet godt av forfedrene. ");
INSERT INTO norlb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Men til dere som vil høre på det jeg sier, har jeg dette å fortelle: Elsk fiendene deres. Gjør godt mot dem som hater dere. ");
INSERT INTO norlb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Be om at Gud skal gi alt godt til dem som forbanner dere, og be om at han skal hjelpe dem som håner dere. ");
INSERT INTO norlb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Slår noen deg på det ene kinnet, da vend også det andre til! Vil noen ta ditt yterplagg, da la ham også få skjorten. ");
INSERT INTO norlb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gi til alle som ber deg, og om noen tar det som er ditt, da krev det ikke tilbake. ");
INSERT INTO norlb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Dere skal behandle andre slik som dere vil at de skal behandle dere. ");
INSERT INTO norlb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Dersom dere bare elsker dem som elsker dere, er dere da verd noe ekstra ros og ære for det? Selv onde mennesker elsker jo dem som gir kjærlighet tilbake. ");
INSERT INTO norlb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Dersom dere gjør godt mot dem som gjør godt mot dere, er det noe så ekstra med det? Det gjør jo de onde menneskene også! ");
INSERT INTO norlb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dersom dere låner ut penger til dem som kan betale tilbake, er det noe som dere bør takkes så veldig ydmykt for? Selv onde mennesker låner jo ut til sine venner om de bare får pengene sine igjen. ");
INSERT INTO norlb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nei, elsk fiendene deres og gjør godt mot dem. Lån ut pengene deres uten å bekymre dere for om dere får de tilbake. Da vil Gud lønne dere. Dere handler da som ekte barn av Gud, for han er selv god også mot dem som er utakknemlige og onde. ");
INSERT INTO norlb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vis samme medfølelse mot dine medmennesker som deres Far i himmelen gjør, han som har medfølelse med alle. ");
INSERT INTO norlb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Døm ikke andre. Da skal dere ikke selv bli dømt. Erklær ingen skyldige. Da skal ikke Gud erklære dere som skyldige. Vær beredt å tilgi. Da skal dere selv få tilgivelse. ");
INSERT INTO norlb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dersom dere gir, kommer dere til å få. Ja, dere kommer til å få tilbake mer enn dere ga, et breddfullt mål, godt presset og ristet, slik at mye får plass. For det målet dere bruker på andre, det kommer Gud til å bruke på dere.” ");
INSERT INTO norlb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus illustrerte hva han mente ved å fortelle to bilder. Han sa: ”Hvilken mening er det i at en blind leder en annen blind? Begge kommer til å falle i samme grøften. ");
INSERT INTO norlb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Og en disippel står ikke over sin mester, men når han er fullt utlært, kan han bli like dyktig som sin mester. ");
INSERT INTO norlb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hvorfor henger du deg opp i de små svakhetene som du ser hos andre, når du ikke erkjenner dine egne feil som er mye større? ");
INSERT INTO norlb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hvorfor sier du til andre: ’Kom hit så skal jeg åpne øynene på deg slik at du kan se feilene dine’, når du samtidig er blind for dine egne synder? Du falske menneske som bare later som om du er lydig mot Gud! Rett først dine egne feil! Etterpå kan du se klart og forsøke å hjelpe dine medmennesker. ");
INSERT INTO norlb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Et godt tre kan aldri bære dårlig frukt, og et dårlig tre kan aldri bære god frukt. ");
INSERT INTO norlb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vi kjenner treet igjen på den frukten det bærer. Ingen finner fiken på tistler eller druer på tornebusker. ");
INSERT INTO norlb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","På samme måten viser ordene fra et godt menneske den godhet som finnes i hjertet, mens ordene fra et ondt menneske avslører den ondskap som finnes i dette menneske. Munnen sier det hjertet er fullt av. ");
INSERT INTO norlb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Hvorfor kaller dere meg ’Herre’, når dere likevel ikke er lydige mot meg? ");
INSERT INTO norlb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Den som kommer til meg og hører undervisningen min og handler etter den, hvem han er lik skal jeg kort og klart fortelle dere. ");
INSERT INTO norlb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Han ligner en mann som vil bygge seg hus. Han graver så dypt at han kan legge grunnmuren på fast fjell. Når elven flommer over og vannet kaster seg mot huset, da står det fast, etter som det er bygget på sikker grunn. ");
INSERT INTO norlb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Men den som hører og ikke handler, han ligner en mann som bygger huset sitt direkte på jorden uten å grave noe fundament. Og når elven kaster seg mot huset, faller det straks sammen med en kjempesmell.” ");
INSERT INTO norlb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Da Jesus hadde sluttet å tale til folket, gikk han inn i byen Kapernaum. ");
INSERT INTO norlb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Der var det en romersk offiser som hadde en tjener han syntes svært godt om. Nå var tjeneren syk og lå for døden. ");
INSERT INTO norlb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Da offiseren fikk høre snakk om Jesus, sendte han noen av lederne blant jødene til ham for å be ham komme og helbrede tjeneren. ");
INSERT INTO norlb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","De kom fram til Jesus og ba med iver at han måtte følge med og hjelpe mannen. ”Om noen fortjener din hjelp, så er det han”, sa de. ");
INSERT INTO norlb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","”Han elsker vårt folk og har til og med bygget synagogen til oss!” ");
INSERT INTO norlb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Da fulgte Jesus med. Før han kom fram til huset, sendte offiseren noen venner for å si til ham: ”Herre, stans der du er, jeg er ikke verdig til at du går inn i hjemmet mitt. ");
INSERT INTO norlb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Derfor våget jeg heller ikke selv å komme til deg. Men si bare et ord, så blir tjeneren min frisk. ");
INSERT INTO norlb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jeg vet det, for jeg har selv overordnede offiserer som gir meg befaling. På den andre siden har jeg soldater som i rang er under meg igjen. Dersom jeg sier til en av dem: ’Gå’, så går han, og til en annen: ’Kom’, så kommer han. Og om jeg sier til tjenerne mine: ’Gjør dette, eller det der’, ja, så gjør de det.” ");
INSERT INTO norlb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus ble forbauset og vendte seg mot folket som fulgte med ham og sa: ”Jeg forsikrer dere at ikke en gang blant Israels folk har jeg sett en så sterk tro.” ");
INSERT INTO norlb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Da offiseren sine venner kom tilbake til huset, så de at tjeneren var helt frisk. ");
INSERT INTO norlb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Da Jesus og disiplene gikk inn i byen Nain, fulgte en stor mengde mennesker etter. ");
INSERT INTO norlb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","De nærmet seg byporten og møtte et gravfølge. Den døde var eneste sønnen og moren hans var enke. Mange sørgende fra byen deltok med henne i følget. ");
INSERT INTO norlb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Da Herren Jesus så enken, ble han fylt av medfølelse og sa: ”Gråt ikke!” ");
INSERT INTO norlb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Så gikk han fram til båren og la hånden på den, og de som bar den stanset. ”Unge mann”, sa Jesus, ”reis deg opp!” ");
INSERT INTO norlb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Da satte den døde seg opp og begynte å snakke til dem som sto rundt båren. Jesus ga ham til hans mor. ");
INSERT INTO norlb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Folket ble helt forskrekket over det de hadde sett, og de hyllet Gud og sa: ”En stor profet har vist seg blant oss og har båret fram Guds budskap”, og: ”Gud har kommet for å hjelpe folket sitt”. ");
INSERT INTO norlb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Fortellingen om det Jesus hadde gjort, spredde seg over hele Judea og nådde til og med utenfor landets grenser. ");
INSERT INTO norlb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Disiplene til døperen Johannes fikk snart høre snakk om alt det som Jesus gjorde. Da de fortalte det til Johannes, ");
INSERT INTO norlb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sendte han to av disiplene sine til Herren Jesus for å spørre: ”Er du virkelig den som Gud har lovet å sende oss, eller skal vi vente på en annen?” ");
INSERT INTO norlb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","22","Da de to disiplene nådde fram til Jesus, holdt han akkurat på å helbrede folk fra sine sykdommer, lidelser og fra onde ånder. Han gjorde også at flere blinde kunne se igjen. Da utsendingene fra Johannes stilte sine spørsmål som Johannes ville ha svar på, sa Jesus: ”Gå tilbake til Johannes og fortell det dere har sett og hørt: At blinde begynner å se, lamme går, spedalske blir friske, døve hører, døde får liv igjen, og de fattige får høre det glade budskap. ");
INSERT INTO norlb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Si også til ham: ’Lykkelig er den som ikke tviler på meg.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Da utsendingene fra Johannes hadde gått, begynte Jesus å tale til folket om Johannes. Han sa: ”Da dere gikk ut til ham i ødemarken, hva var det dere ville oppnå å se? Ville dere se en svak mann, lik et gresstrå som svaier hit og dit for vinden? ");
INSERT INTO norlb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Selvsagt ikke! Ville dere se en mann kledd i vakre klær? Nei, menn som går omkring i kostbare klær og lever i luksus finner vi i palassene. ");
INSERT INTO norlb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ville dere kanskje se en profet som bar fram Guds budskap? Ja, jeg sier dere at Johannes er mer enn en profet. ");
INSERT INTO norlb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Han er den som Gud omtaler i Skriften når han sier: ’Lytt! Jeg sender min budbærer foran deg, og han skal forberede veien for deg.’ ");
INSERT INTO norlb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jeg forsikrer dere at døperen Johannes har betydd mer enn noe annet menneske. Likevel kommer den minst betydningsfulle blant dem som får være Guds eget folk, til å bety mer enn det Johannes gjorde her på jorden. ");
INSERT INTO norlb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Alle som hørte Johannes tale, var enige om at det Gud forlangte av dem var riktig, og de lot seg døpe av Johannes. Ja, til og med tollerne ble døpt. ");
INSERT INTO norlb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Men fariseerne og de skriftlærde forkastet Guds plan og nektet å la Johannes døpe dem. ");
INSERT INTO norlb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ja, hva skal jeg si om denne slekten som ikke vil tro?” fortsatte Jesus. ”Hva skal jeg sammenligne den med? ");
INSERT INTO norlb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","De er som barn som leker på torget og roper til hverandre: ’Vi spilte bryllupsmelodier for dere, men dere ville ikke danse. Vi spilte sørgemusikk for dere, men dere ville ikke gråte.’ ");
INSERT INTO norlb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","På samme måte reagerer dere når det gjelder døperen Johannes og meg. Johannes drikker ikke vin og spiser ikke brød, og da sier dere: ’Han er besatt av en ond Ånd.’ ");
INSERT INTO norlb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Men jeg, Menneskesønnen, spiser og drikker, og da beskylder dere meg for å fråtse i mat, drikke og leve sammen med de verste syndere! ");
INSERT INTO norlb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Men den som er klok, innser at Gud i sin visdom alltid har rett.” ");
INSERT INTO norlb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","En av fariseerne, som het Simon, innbød Jesus hjem til seg. Jesus takket ja til innbydelsen. Da de hadde slått seg ned for å spise, ");
INSERT INTO norlb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","fikk en prostituert høre at han var der. Hun gikk da dit med en flaske aromatisk olje. ");
INSERT INTO norlb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Da hun kom inn i huset, stilte hun seg ved føttene til Jesus. Hun gråt til føttene var våte av tårene, så tørket hun føttene hans med håret sitt, kysset dem og salvet dem med olje. ");
INSERT INTO norlb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Da verten, som var fariseer, så det som skjedde, tenkte han med seg selv: ”Dersom Jesus virkelig hadde vært en profet, da hadde han med Guds hjelp forstått hva slags kvinne dette er. Han ville ha avslørt at hun er en prostituert.” ");
INSERT INTO norlb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus visste hva han tenkte og sa: ”Simon, jeg har noe å si til deg.” Simon svarte: ”Si det, Mester.” ");
INSERT INTO norlb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus fortalte da et bilde: ”En mann lånte ut penger til to personer. Den ene fikk et større beløp som utgjorde mer enn en vanlig års lønn. Den andre lånte bare en månedslønn. ");
INSERT INTO norlb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ingen av dem kunne betale tilbake, så han gikk med på å avskrive gjelden.” Jesus spurte Simon: ”Hvem av de to tror du vil elske ham mest etter dette?” ");
INSERT INTO norlb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","”Jeg antar at det var han som skyldte ham mest”, svarte Simon. ”Ja, det er helt riktig”, sa Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Så vendte Jesus seg mot kvinnen og sa til Simon: ”Ser du denne kvinnen som står her? Da jeg kom inn i huset ditt, brydde du deg ikke om å gi meg vann slik at jeg kunne vaske støvet av føttene mine, men hun har vasket føttene mine med tårene og tørket dem med håret sitt. ");
INSERT INTO norlb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Du ga meg ikke noe velkomstkyss da jeg kom, men hun har kysst føttene mine uten å holde opp helt siden hun kom inn. ");
INSERT INTO norlb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Du salvet ikke hodet mitt med olje som vertskapet bruker å gjøre, men hun har salvet føttene mine med aromatisk olje. ");
INSERT INTO norlb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Simon, min venn, alle syndene hennes er tilgitt. Det er derfor hun viser så stor kjærlighet. Men den som har fått lite tilgitt, viser lite kjærlighet.” ");
INSERT INTO norlb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesus til kvinnen: ”Jeg tilgir deg syndene dine.” ");
INSERT INTO norlb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Da sa mennene rundt bordet til hverandre: ”Hvem er denne mannen, som til og med tilgir synder?” ");
INSERT INTO norlb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesus sa til kvinnen: ”Din tro har hjulpet deg. Gå i fred.” ");
INSERT INTO norlb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Etter dette ga Jesus seg ut på reise til forskjellige steder og byer i Galilea. Over alt fortalte han det glade budskapet om at Gud vil frelse menneskene og gjøre dem til sitt eget folk. Med på reisen hadde han sine tolv nærmeste disipler, ");
INSERT INTO norlb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","og noen kvinner som hadde blitt fri fra onde ånder og sykdommer. Disse kvinnene var: Maria Magdalena, som Jesus hadde satt fri fra sju onde ånder. ");
INSERT INTO norlb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Videre var det Johanna, som var kona til forvalteren Kusas hos kong Herodes, Susanna, og mange andre som støttet Jesus og disiplene med sine egne penger. ");
INSERT INTO norlb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","En dag da mye folk hadde kommet til Jesus fra de forskjellige byene, fortalte han dette bildet: ");
INSERT INTO norlb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","”En bonde gikk ut på åkeren sin for å så. Da han sådde, falt noe av såkornet på veien langs åkeren. Folk trampet på det, og fuglene kom og spiste det opp. ");
INSERT INTO norlb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Noe korn falt på den harde og steinete bakken. Det begynte å gro raskt, men visnet ganske fort etter som det ikke var nok fuktighet i jorden. ");
INSERT INTO norlb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Noe falt blant tistlene. Etter som tistlene vokste opp samtidig, kvalte de kornplantene. ");
INSERT INTO norlb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Men det meste av kornet falt i den fruktbare jorden. Det vokste opp og ga 100 ganger så mye korn som den mengden som hadde blitt sådd.” Jesus ropte ut til folket: ”Lytt nøye og forsøk å forstå!” ");
INSERT INTO norlb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Disiplene spurte Jesus hva dette bilde betydde. ");
INSERT INTO norlb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Han svarte: ”Dere har fått gaven til å forstå undervisningen min om hvordan Gud vil frelse menneskene og gjøre dem til sitt eget folk. De andre får bare høre disse bildene, for at ’de skal se hva jeg gjør, men likevel ikke se, og høre hva jeg sier, men likevel ikke forstå.’ ");
INSERT INTO norlb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Dette er forklaringen på bildet: Sæden som bonden sår, er Guds budskap. ");
INSERT INTO norlb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Den harde veien, der noe av såkornet falt, ligner hjertet hos et menneske som hører budskapet, men ikke tar det på alvor. Snart kommer djevelen og tar bort såkornet fra hjertet og hindrer personen i å tro og bli frelst. ");
INSERT INTO norlb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Den harde steinete bakken ligner hjertet hos et menneske som hører budskapet og tar imot det med ekte glede, men ikke har dyp jord i seg slik at røttene kan utvikle seg. Denne personen vet at det han hørte er sant, og tror en tid, men så fort han blir utsatt for prøvelser, gir han opp troen. ");
INSERT INTO norlb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jorden som var dekket av tistler, kan bli sammenlignet med en person som hører budskapet og tror på det, men som etter en tid lar det bli kvalt av livets bekymringer, eller av høy inntekt og stor nytelse, slik at budskapet slett ikke påvirker livsstilen. ");
INSERT INTO norlb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Men den fruktbare jorden ligner et menneske som hører budskapet og gjemmer det i et godt og ærlig hjerte. Gjennom langvarig utholdenhet lar mennesket budskapet få påvirke hele livet. ");
INSERT INTO norlb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Når noen tenner en lampe, gjemmer de den ikke under en eske eller setter den under en benk. Tvert imot så setter de lampen høyt og fritt, slik at alle som kommer inn, kan se lyset. ");
INSERT INTO norlb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","På samme måten skal alt som nå er skjult en dag bli ført fram i lyset og bli synlig for alle. ");
INSERT INTO norlb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Vær derfor nøye med hvordan dere hører og pass på at det budskap dere får høre, utvikler seg til handling. For den som forstår det jeg sier, skal med tiden forstå enda mer. Og den som ikke forstår, skal til slutt miste også den lille innsikten han trodde han hadde.” ");
INSERT INTO norlb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mor til Jesus og brødrene hans kom en gang for å prate med ham, men de kunne ikke komme inn i huset der han underviste, etter som det var fullt av folk. ");
INSERT INTO norlb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Noen sa da til ham: ”Din mor og brødrene dine står utenfor og vil treffe deg.” ");
INSERT INTO norlb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Men han svarte: ”Min mor og søsknene mine, det er alle dem som hører Guds budskap og er lydige mot det.” ");
INSERT INTO norlb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","23","En dag sa Jesus til disiplene: ”Kom, så drar vi over til andre siden av sjøen.” De steg i båten og ga seg av sted. Under overfarten la Jesus seg ned i båten og sovnet. Plutselig feide voldsomme stormkast ned fra høydedragene over sjøen. Båten begynte å bli fylt av vann, slik at de virkelig var ille ute. ");
INSERT INTO norlb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Da gikk disiplene fram og vekket ham og begynte å rope: ”Herre, Herre, vi synker!” Da Jesus våknet, ga han befaling om at vinden og bølgene skulle roe seg, og det ble blikk stille! ");
INSERT INTO norlb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesus spurte disiplene: ”Hvordan står det egentlig til med troen hos dere?” Glade og forskrekket sa de til hverandre: ”Hvem er han, etter som til og med vinden og bølgene er lydige mot ham?” ");
INSERT INTO norlb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Da de kom over til området rundt Gerasenerlandet, tvers over sjøen fra Galilea, la de til land. ");
INSERT INTO norlb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","En mann fra byen der kom mot Jesus da han steg ut av båten. Han hadde lenge vært besatt av onde ånder og levde hjemløs og naken blant gravhulene. ");
INSERT INTO norlb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Så snart han fikk se Jesus, begynte han å skrike og kastet seg ned for ham og ropte høyt: ”Gå fra meg, Jesus, du som er den høyeste Guds sønn! Jeg ber deg, du må ikke plage meg!” ");
INSERT INTO norlb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","For Jesus hadde nettopp gitt befaling om at den onde ånden skulle fare ut av mannen. Den onde ånden hadde hatt mannen i sin makt i lang tid. Familie og venner hadde forsøkt å binde ham med kjettinger, satte lenker på føttene og forsøkt å låse ham inne. Han hadde slitt seg løs fra alt og blitt drevet ut i ødemarken av den onde ånden. ");
INSERT INTO norlb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus spurte nå: ”Hva heter du?” Mannen svarte: ”Legion”, for han var besatt av mange onde ånder. ");
INSERT INTO norlb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Åndene ba Jesus om ikke å sende dem ned i avgrunnen. ");
INSERT INTO norlb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Samtidig som dette skjedde, gikk det en stor flokk griser og rotet etter mat på fjellet over sjøen. De onde åndene ba Jesus om å få fare inn i grisene, og Jesus tillot dem å gjøre det. ");
INSERT INTO norlb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Da forlot de onde åndene mannen og for inn i grisene. Hele griseflokken rutsjet utfor fjellskrenten og ned i sjøen og druknet. ");
INSERT INTO norlb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Da gjeterne som passet på grisene, så det som skjedde, sprang de først til den nærmeste byen og til flere byer i nærheten og fortalte alt sammen. ");
INSERT INTO norlb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","36","Folket dro da ut for å finne ut hva som egentlig hadde skjedd. Da de kom der Jesus var, fikk de se mannen som hadde vært besatt, sitte helt rolig ved føttene til Jesus, påkledd og fullstendig normal. Skrekkslått hørte de øyenvitnene fortelle om hvordan den besatte mannen hadde blitt satt fri. ");
INSERT INTO norlb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Men det som skjedde, hadde skremt opp innbyggerne i Gerasenerlandet, og de ba at Jesus måtte forlate deres distrikt. Derfor steg han i båten og dro tilbake til den andre siden av sjøen igjen. ");
INSERT INTO norlb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mannen som hadde vært besatt, ba om å få å følge med Jesus, men Jesus sendte ham fra seg og sa: ");
INSERT INTO norlb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","”Gå tilbake til din familie og fortell hvilket mirakel Gud har gjort for deg.” Da gikk mannen av sted og fortalte for alle i hele byen om det store miraklet som Jesus hadde gjort for ham. ");
INSERT INTO norlb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Da Jesus kom tilbake, tok folket imot ham på stranden, for alle ventet på ham. ");
INSERT INTO norlb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","En mann som het Jairus, kom fram og kastet seg ned for Jesus. Han var forstander for synagogen på stedet, og nå ba han Jesus om å følge med ham hjem. ");
INSERT INTO norlb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Hans eneste barn, en jente på tolv år, holdt på å dø. Jesus fulgte straks med Jairus, og på veien presset folket på fra alle kanter. ");
INSERT INTO norlb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","I folkemassen var det en kvinne som hadde lidd av blødninger i tolv år og ikke var blitt frisk, til tross for at hun hadde brukt opp alt hun eide på legehjelp. ");
INSERT INTO norlb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kvinnen nærmet seg nå Jesus bakfra og rørte ved dusken på kappen hans. Straks stanset blødningen! ");
INSERT INTO norlb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","”Hvem rørte ved meg?” spurte Jesus. Da alle tidde, sa Peter: ”Mester, det er jo så mange som dytter og presser fra alle kanter.” ");
INSERT INTO norlb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus sa til ham: ”Nei, det var noen som med vilje og vitende rørte ved meg, for jeg kjente at det gikk ut en kraft fra meg.” ");
INSERT INTO norlb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Da kvinnen forsto at Jesus hadde lagt merke til det hun gjorde, kom hun skjelvende fram og falt ned for ham. Hun fortalte hvorfor hun hadde rørt ved ham og at hun straks hadde blitt frisk. ");
INSERT INTO norlb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","”Min datter”, sa han til henne, ”troen din har hjulpet deg. Gå i fred.” ");
INSERT INTO norlb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mens Jesus fortsatt snakket med kvinnen, kom det en utsending fra hjemmet til Jairus og meldte til faren: ”Jenta di er død. Det er ingen vits i at du bryr Mesteren lenger.” ");
INSERT INTO norlb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Da Jesus hørte det som hadde skjedd, sa han til Jairus: ”Vær ikke redd! Bare tro, så skal hun bli bra igjen!” ");
INSERT INTO norlb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Da de kom fram til huset, lot ikke Jesus andre følge med inn enn Peter, Jakob, Johannes og faren og moren til den lille jenta. ");
INSERT INTO norlb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Innenfor var det fullt av mennesker som gråt og holdt klagesang over jenta. Jesus sa: ”Ikke gråt! Hun er ikke død, hun sover bare!” ");
INSERT INTO norlb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Da begynte folket å hånle mot Jesus, for de visste jo at hun var død. ");
INSERT INTO norlb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesus tok hånden hennes og sa høyt: ”Jente, stå opp!” ");
INSERT INTO norlb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Straks vendte livet tilbake i henne, og hun reiste seg opp! Jesus sa at de skulle gi henne noe å spise. ");
INSERT INTO norlb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hennes foreldre ble overlykkelige, men Jesus forbød at de skulle fortelle til noen om det som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","En dag kalte Jesus sammen sine tolv disipler og ga dem makt til å drive ut alle slags onde ånder og kraft til å helbrede sykdommer. ");
INSERT INTO norlb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Etterpå sendte han dem ut for å fortelle at Gud vil frelse menneskene og gjøre dem til sitt eget folk, og for å helbrede syke. ");
INSERT INTO norlb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Han sa: ”Ta ikke med dere noe på veien, ingen vandringsstav eller veske, ikke mat eller penger, og ingen ekstra klær. ");
INSERT INTO norlb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Når dere har blitt tilbudt å overnatte hos noen, stans da til dere vil fortsette til neste by. ");
INSERT INTO norlb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dersom innbyggerne i en by ikke vil ta imot dere eller vil høre på dere, gå da bare videre og vær ikke mer bekymret for dem. Rist støvet fra byen av føttene deres som et tegn på at de selv får ta ansvaret for det de har gjort.” ");
INSERT INTO norlb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Disiplene begynte å gå fra by til by og spredde det glade budskapet og helbredet syke. ");
INSERT INTO norlb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Da kong Herodes fikk høre snakk om alle miraklene som Jesus gjorde, ble han urolig og visste ikke hva han skulle tro. Noen sa at det var døperen Johannes som hadde stått opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Noen mente at det var Elia som viste seg. Andre igjen sa at en eller annen av profetene, som før i tiden bar fram Guds budskap, hadde stått opp igjen. ");
INSERT INTO norlb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes sa: ”Jeg tillot å halshugge Johannes. Tenk om denne mannen som jeg hører så mye om viser seg å være Johannes?” Og han forsøkte å få møte Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","De tolv disiplene som Jesus hadde sendt ut, kom nå tilbake fra reisen sin og rapporterte om alt de hadde gjort. Jesus, sammen med de andre, trakk seg bort til byen Betsaida. ");
INSERT INTO norlb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Folket fikk greie på hvor han gikk og fulgte etter. På nytt tok han imot folket og talte til dem om at Gud vil frelse menneskene og gjøre dem til sitt eget folk. Han helbredet alle som trengte hjelp. ");
INSERT INTO norlb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Da det begynte å bli kveld, kom de tolv disiplene og sa: ”Send folket av sted, slik at de kan gå til byene og gårdene her i nærheten, kjøpe seg mat og ordne et eller annet sted å sove. På dette øde stedet finnes det ingen mulighet.” ");
INSERT INTO norlb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus svarte: ”Dere kan selv gi dem mat!” ”Hvordan skal det gå til?” undret de. ”Alt vi har, er fem brød og to fisker. Mener du virkelig at vi skal gå og kjøpe mat nok så det rekker til alle disse folkene?” ");
INSERT INTO norlb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Det var omkring 5 000 menn, og i tillegg kom kvinner og barn. ”Bare be dem om å slå seg ned i grupper på 50 personer”, svarte Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Disiplene gjorde som han sa og lot alle sette seg. ");
INSERT INTO norlb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Så tok Jesus de fem brødene og de to fiskene, så opp mot himmelen og takket Gud for maten. Etterpå brøt han brødene og fiskene i biter og ga til disiplene for at de skulle gi videre til folket. ");
INSERT INTO norlb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Alle spiste og ble mette. Da de til slutt samlet opp det som var til overs, ble det tolv fulle kurver. ");
INSERT INTO norlb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","En gang da Jesus hadde trukket seg tilbake for å be, og disiplene var med han, spurte han: ”Hvem sier folket at jeg er?” ");
INSERT INTO norlb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","”Noen sier at du er døperen Johannes”, svarte de, ”og noen at du er Elia. Andre sier at du er en eller annen av profetene, de som før i tiden bar fram Guds budskap og som nå har stått opp fra de døde.” ");
INSERT INTO norlb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Da spurte han: ”Hvem tror dere at jeg er?” Peter svarte: ”Du er Messias, den kongen som Gud har lovet å sende.” ");
INSERT INTO norlb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesus ga da streng befaling om at de ikke skulle snakke med noen om dette. ");
INSERT INTO norlb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Han forklarte: ”Jeg, Menneskesønnen, må lide mye. Folkets ledere, øversteprestene og de skriftlærde kommer til å ta avstand fra meg og passe på at jeg blir drept, men på den tredje dagen skal jeg stå opp fra de døde.” ");
INSERT INTO norlb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Så sa han til folket: ”Om noen vil bli disiplene mine, kan han ikke lenger tenke på seg selv, men han må følge mitt eksempel og alltid være beredt til å dø. ");
INSERT INTO norlb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ja, den som klamrer seg fast til livet, vil til sist miste det. Den som mister livet sitt for min skyld, han vil redde det. ");
INSERT INTO norlb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hva vinner et menneske om det blir gitt hele verden, dersom det samtidig mister det evige livet? ");
INSERT INTO norlb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Den som skammer seg over meg og over de ordene jeg sier, han skal jeg, Menneskesønnen, være skamfull over den dagen jeg vender tilbake i min og min Fars herlighet sammen med englene hans. ");
INSERT INTO norlb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tro meg: Noen av dere som står her i dag, kommer ikke til å dø før dere har sett Gud i hans kongelige makt.” ");
INSERT INTO norlb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Omkring en uke seinere tok Jesus med seg Peter, Jakob og Johannes og gikk opp på et fjell for å be. ");
INSERT INTO norlb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mens han ba, forandret ansiktet hans seg, og klærne ble blendende hvite. ");
INSERT INTO norlb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Så viste det seg to menn som sto og snakket med ham. Det var Moses og Elia. ");
INSERT INTO norlb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Også de strålte av et himmelsk lys, og snakket om hvordan Jesus i tråd med Guds plan ville dø i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter og de to andre hadde vært så trette at de sovnet mens Jesus ba. Nå våknet de og fikk se Jesus stå der omstrålet av lys sammen med de to mennene. ");
INSERT INTO norlb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Da Moses og Elia gjorde seg klar til å forlate Jesus, sa Peter til Jesus: ”Mester, dette er et fantastisk sted å være på! La oss bygge tre hytter, en til deg og en til Moses og en til Elia!” Han var så forvirret at han ikke helt visste hva han sa. ");
INSERT INTO norlb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mens han snakket, ble de innhyllet i en sky som senket seg over dem. De ble helt forskrekket. ");
INSERT INTO norlb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Så hørte de en stemme fra skyen som sa: ”Dette er min Sønn, min utvalgte. Lytt til ham.” ");
INSERT INTO norlb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Da stemmen hadde stilnet, sto Jesus alene igjen. Disiplene holdt det de hadde sett for seg selv. De fortalte det ikke til noen før langt seinere. ");
INSERT INTO norlb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Neste dag, da de kom ned fra fjellet, ble de møtt av en stor folkemasse. ");
INSERT INTO norlb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","En mann ropte til Jesus: ”Mester, hjelp sønnen min, han er mitt eneste barn. ");
INSERT INTO norlb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rett som det er blir han angrepet av en ond Ånd. Da skriker han og vrir seg i kramper så fråden står om munnen. Når anfallet endelig er over, har ånden nesten tatt knekken på ham. ");
INSERT INTO norlb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jeg ba disiplene dine om å drive ut den onde ånden, men de klarte det ikke!” ");
INSERT INTO norlb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","”Dere er håpløse mennesker som ikke vil tro!” utbrøt Jesus. ”Hvor lenge må jeg være blant dere og holde ut med dere? Kom hit med sønnen din.” ");
INSERT INTO norlb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mens gutten var på vei til Jesus, dyttet den onde ånden ham i bakken og slet og rykket voldsomt i ham. Jesus ga befaling om at ånden skulle forlate gutten. Han helbredet ham og ga ham til faren. ");
INSERT INTO norlb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Alle som var til stede ble helt overveldet over Guds ubegrensede makt og veldige kraft. Mens folket fortsatt sto forundret og tenkte på alt han gjorde, sa Jesus til disiplene: ");
INSERT INTO norlb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","”Lytt nøye, og husk på det jeg nå sier: Jeg, Menneskesønnen, skal bli forrådt og overgitt i menneskers hender.” ");
INSERT INTO norlb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Men disiplene forsto ikke det han snakket om. Den virkelige betydningen av det Jesus forutsa, var skjult for dem, og de våget ikke spørre hva han mente. ");
INSERT INTO norlb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Disiplene begynte nå å diskutere med hverandre om hvem av dem som var den største. ");
INSERT INTO norlb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus forsto hva som rørte seg i tankene deres. Derfor tok han et barn og stilte det ved siden av seg. ");
INSERT INTO norlb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Han sa: ”Den som tar imot dette barnet fordi det tilhører meg, han tar imot meg! Og den som tar imot meg, han tar imot Gud, etter som Gud har sendt meg. Den som sier at han selv er liten og ubetydelig, han er den største.” ");
INSERT INTO norlb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Johannes, en av disiplene, sa: ”Mester, vi så en mann som drev ut onde ånder i ditt navn, men etter som han ikke var i følge med oss, forsøkte vi å stoppe ham.” ");
INSERT INTO norlb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Da sa Jesus til Johannes: ”La ham holde på med sitt, for den som ikke er mot dere, han er for dere.” ");
INSERT INTO norlb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tiden hadde nå kommet da Gud bestemte at Jesus skulle vende tilbake til himmelen. Jesus besluttet derfor å begynne på veien mot Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","En dag sendte han noen disipler i forveien for å ordne med overnatting i en samaritansk by. ");
INSERT INTO norlb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Men etter som Jesus var på vei mot Jerusalem, ville de ikke ha noe med ham å gjøre. ");
INSERT INTO norlb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Da begge disiplene, som var Jakob og Johannes, fikk greie på det som hadde skjedd, ble de opprørte og sa: ”Herre, skal vi befale at ild må falle ned fra himmelen og brenne opp byen?” ");
INSERT INTO norlb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesus vendte seg om og irettesatte dem. ");
INSERT INTO norlb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Så gikk de videre til en annen by. ");
INSERT INTO norlb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mens de gikk langs veien, sa en mann til Jesus: ”Jeg vil følge deg hvor du enn går.” ");
INSERT INTO norlb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus svarte: ”Du må forstå en ting, revene har hi og fuglene har reir, men jeg, Menneskesønnen, har ingen stedet der jeg kan hvile ut.” ");
INSERT INTO norlb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Til en annen mann de møtte, sa Jesus: ”Kom og bli min disippel!” Men han svarte: ”La meg først få gå hjem og begrave min far.” ");
INSERT INTO norlb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Da sa Jesus: ”La de som er åndelig døde, begrave sine døde. Din oppgave er å spre budskapet om at Gud vil frelse menneskene og gjøre dem til sitt eget folk.” ");
INSERT INTO norlb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","En annen sa: ”Ja, Herre, jeg skal komme, men la meg først få ta avskjed med dem der hjemme.” ");
INSERT INTO norlb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Da sa Jesus til ham: ”Den som gjør seg klar for å arbeide, men etterpå lar seg lokke bort fra arbeidet av andre, han kan ikke tjene Gud.” ");
INSERT INTO norlb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Herren Jesus valgte seg nå ut 72 disipler. Han sendte dem i forveien, to og to, til alle de stedene og byene som han seinere planla å besøke. ");
INSERT INTO norlb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Før de ga seg av sted, sa han: ”Høsten er stor, men arbeiderne er få. Be derfor om at den som har ansvaret for å høste inn avlingen, må sende ut flere arbeidere på feltet. ");
INSERT INTO norlb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gå nå, og husk at jeg sender dere som lam inn blant ulver. ");
INSERT INTO norlb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ta ikke med dere noen penger, ingen veske og ingen ekstra sko. Ta vel vare på tiden og ikke stans underveis for å prate. ");
INSERT INTO norlb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Når dere kommer inn i et hus, så skal dere først ønske familien fred fra Gud. ");
INSERT INTO norlb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Om de da fortjener å få del i Guds fred, da vil Gud gi av sin fred. Dersom de ikke fortjener det, da får dere selv beholde den freden dere ønsket dem. ");
INSERT INTO norlb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bli værende i dette hjemmet og la dem by dere på mat. Dere skal ikke nøle når noen viser dere gjestfrihet, for arbeideren er verd lønnen sin. Ikke flytt fra hus til hus. ");
INSERT INTO norlb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Når dere kommer inn i en by og folket hilser dere velkommen, skal dere takke ja når de byr dere på mat. ");
INSERT INTO norlb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Helbred de syke og si til folket: ’Gud har kommet for å frelse menneskene og gjøre dem til sitt eget folk.’ ");
INSERT INTO norlb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dersom dere kommer til en by der de ikke vil ta imot dere, da gå ut på gatene og si: ");
INSERT INTO norlb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","’Dere har dømt dere selv. Til og med støvet fra gatene deres vil vi riste av føttene våre. En sak skal dere ha klart for dere, og det er at Gud har kommet for å gjøre menneskene til sitt eget folk.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","”Jeg forsikrer dere”, fortsatte Jesus, ”at til og med byen Sodoma skal slippe billigere unna på dommens dag enn disse stedene som ikke vil hilse dere velkommen. ");
INSERT INTO norlb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ja, hvor fryktelig skal det ikke bli for dem som bor i Korasin og Betsaida! For dersom de miraklene som jeg har gjort hos dere, hadde blitt gjort i Tyrus og Sidon, da hadde menneskene der angret syndene sine og vendt om til Gud for lenge siden. ");
INSERT INTO norlb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jeg forsikrer dere at på dommens dag skal både Tyrus og Sidon få en mildere straff enn dere! ");
INSERT INTO norlb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Og dere, innbyggerne i Kapernaum, tror dere at dere skal bli opphøyd til himmelen? Nei, ned til helvete skal dere bli styrtet.” ");
INSERT INTO norlb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Så sa han til disiplene: ”Den som hører på dere, han hører på meg, og den som avviser dere, han avviser meg. Men den som avviser meg, han avviser Gud, etter som Gud har sendt meg.” ");
INSERT INTO norlb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Da de 72 disiplene seinere kom tilbake, kunne de med glede fortelle: ”Herre, til og med de onde åndene var lydige mot oss når vi drev dem ut i ditt navn.” ");
INSERT INTO norlb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","”Ja”, sa han til dem, ”jeg så Satan falle ned fra himmelen som en lyn! ");
INSERT INTO norlb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Og jeg har gitt dere makt til å trampe på slanger og skorpioner for å knuse dem, og makt over alle fiendens krefter. Ikke noe skal kunne skade dere. ");
INSERT INTO norlb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Men det viktigste er ikke at de onde åndene er lydige mot dere, man at navnene deres er skrevet opp i himmelen.” ");
INSERT INTO norlb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I samme øyeblikk ble Jesus fylt av glede gjennom Guds Hellige Ånd og sa: ”Jeg takker deg Far, du som er Herre over himmelen og jorden, for at du skjuler sannheten for dem som tror seg å være så lærde og kloke, men viser den heller for dem som er som barn. Ja, Far i himmelen, slik har du selv ordnet den saken.” ");
INSERT INTO norlb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesus fortsatte: ”Min Far i himmelen har overlatt alt til meg. Ingen vet hvem Sønnen er, med unntak av Far i himmelen, og ingen vet hvem Far i himmelen er, med unntak av Sønnen og de menneskene som Sønnen vil vise ham for.” ");
INSERT INTO norlb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Så vendte han seg spesielt mot sine tolv nærmeste disipler og sa: ”Dere kan være lykkelige som har fått se og oppleve alt dette. ");
INSERT INTO norlb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jeg sier dere at mange profeter som bar fram Guds budskap, og mange konger, har ønsket å se og høre det som dere nå får være med om, men de fikk aldri oppleve det.” ");
INSERT INTO norlb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","En dag kom en skriftlærd for å teste Jesus ved å stille spørsmål. Han sa: ”Mester, hva skal et menneske gjøre for å få evig liv?” ");
INSERT INTO norlb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus svarte: ”Hva sier Moseloven om dette? Hva lærer budene?” ");
INSERT INTO norlb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mannen svarte: ” ’Du skal elske Herren, din Gud, av hele ditt hjerte, av hele din sjel, av hele din kraft og av hele din forstand’, og: ’Du skal elske dine medmennesker som deg selv.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","”Det er riktig!” sa Jesus. ”Gjør det så skal du få leve!” ");
INSERT INTO norlb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Men mannen, som gjerne ville vise hvor nøye han var med å følge Guds vilje, spurte Jesus: ”Hvem skal egentlig bli regnet som mine medmennesker?” ");
INSERT INTO norlb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Da svarte Jesus med en fortelling. Han sa: ”En jøde, som var på vei fra Jerusalem til Jeriko, ble overfalt av ransmenn. De slet av han klærne, mishandlet ham og dro fra ham halvdød. ");
INSERT INTO norlb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tilfeldigvis kom en prest forbi. Da han så mannen ligge der, gikk han bare videre uten å hjelpe. ");
INSERT INTO norlb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Etter en stund kom en tempeltjener til åstedet. Han gjorde akkurat det samme som presten. Til tross for at han så mannen ligge der, gikk han bare videre uten å hjelpe. ");
INSERT INTO norlb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Da kom en samaritan. Han var også på reise, og da han så mannen som var mishandlet, ble han fylt av medfølelse. ");
INSERT INTO norlb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Samaritanen gikk fram til den skadde, slo olje og vin over sårene og forbandt skadene. Så løftet han mannen opp på sitt esel og førte ham til en vertshus der han våket over ham hele natten. ");
INSERT INTO norlb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Neste dag, da han måtte reise videre fra vertshuset, betalte han verten et beløp som tilsvarer lønn for to dager, og sa: ’Vær så snill og ta hånd om mannen, og om regningen blir større enn dette, skal jeg betale resten når jeg kommer tilbake.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesus spurte den skriftlærde: ”Hvem av disse tre mener du oppførte seg som et sant medmenneske mot mannen som var blitt mishandlet?” ");
INSERT INTO norlb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","”Den som viste medfølelse naturligvis”, svarte den skriftlærde. Da sa Jesus: ”Nettopp! Gå av sted og gjør det samme, du også.” ");
INSERT INTO norlb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Da Jesus og disiplene fortsatte reisen sin mot Jerusalem, kom de til en by der de ble invitert hjem til en kvinne som het Marta. ");
INSERT INTO norlb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta hadde en søster som het Maria, og hun slo seg straks ned på gulvet og lyttet til det Herren Jesus hadde å si. ");
INSERT INTO norlb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta var stresset og tenkte mest på det hun skulle servere gjestene. Derfor gikk hun fram til Jesus og sa: ”Herre, er det ikke urettferdig at min søster bare setter seg ned og hører mens jeg må gjøre alt arbeidet selv? Si til henne at hun skal komme og hjelpe meg.” ");
INSERT INTO norlb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Men Herren sa til henne: ”Kjære Marta, du har så mange og store bekymringer for alt mulig! ");
INSERT INTO norlb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Men egentlig finnes det bare en sak som virkelig er viktig, og Maria har oppdaget hva dette gjelder. Den delen har jeg ikke tenkt å ta fra henne.” ");
INSERT INTO norlb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","En gang stanset Jesus på et sted for å be. Da han var ferdig, kom en av disiplene til ham og sa: ”Herre, lær oss å be, slik som døperen Johannes lærte disiplene sine å be.” ");
INSERT INTO norlb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Da sa Jesus: ”Slik kan dere formulere bønnen: Far i himmelen! La ditt navn holdes hellig. La ditt rike komme. La din vilje skje på jorden Som i himmelen. ");
INSERT INTO norlb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gi oss hver dag vårt daglige bråd. ");
INSERT INTO norlb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tilgi oss våre synder, for også vi tilgir hver den som har syndet mot oss. Og led oss ikke inn i fristelse.” ");
INSERT INTO norlb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Så fortsatte Jesus med å undervise om bønn ved å fortelle forskjellige bilder. Han sa: ”Tenk deg at du går til en venn midt på natten og banker på hos ham og sier: ’Kan du låne meg tre brød. En av vennene mine har nettopp kommet på besøk, og jeg har ikke noe å by ham.’ ");
INSERT INTO norlb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kanskje vennen da svarer inne fra huset: ’Ikke forstyrr meg! Døren er allerede låst, og vi har gått og lagt oss. Barna kan våkne om jeg står opp. Jeg kan ikke hjelpe deg denne gangen.’ ");
INSERT INTO norlb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Men om du likevel fortsetter å banke, så forsikrer jeg deg at han kommer til å stå opp og gi deg alt du trenger. Kanskje gjør han det ikke fordi du er vennen hans, men heller fordi han skal slippe å skjemme seg ut. ");
INSERT INTO norlb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Det er det samme med bønnen: Be, så skal dere få. Let, så skal dere finne. Bank på, og døren skal bli åpnet. ");
INSERT INTO norlb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","For alle som ber, de får, og alle som leter, de finner. Og for hver den som banker på, skal døren bli åpnet. ");
INSERT INTO norlb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","Du som er far, du gir vil ikke barnet ditt en orm når det ber om en fisk, eller en skorpion når det ber om et egg? Naturligvis ikke! ");
INSERT INTO norlb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dersom nå dere som er onde og hardhjertet, har forstand til å gi gode gaver til barna deres, skulle da ikke deres Far i himmelen gi sin Hellige Ånd til dem som ber ham om det?” ");
INSERT INTO norlb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","En annen gang satte Jesus fri en mann fra en ond Ånd som hadde gjort ham stum. Da den onde ånden for ut, begynte mannen å snakke. Folk ble helt forundret. ");
INSERT INTO norlb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Noen sa: ”Han driver ut de onde åndene ved hjelp av Satan, som er de onde åndene sin øverste leder!” ");
INSERT INTO norlb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Andre forlangte at han skulle gi dem et tegn fra Gud som bevis på at hans virksomhet ble drevet i Guds kraft. ");
INSERT INTO norlb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus forsto hva de var ute etter, og sa derfor: ”Dere vet jo at et rike der innbyggerne kommer i innbyrdes strid med hverandre snart vil gå under og bli lagt øde. ");
INSERT INTO norlb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Om det nå skulle være slik som dere sier, at Satan gir meg kraft til å drive ut de onde åndene, da kjemper han jo mot seg selv. Hvordan skal han da kunne fortsette å styre riktet sitt? ");
INSERT INTO norlb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Dersom jeg driver ut de onde åndene ved hjelp av Satan, hvilken kraft er det da deres egne tilhengere bruker når de driver ut åndene? Kanskje de heller skal svare på disse anklagene? ");
INSERT INTO norlb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dersom det er med Guds kraft jeg driver ut de onde åndene, da har jo Gud begynt å regjere blant dere. ");
INSERT INTO norlb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","På denne måten er det: Satan er som en sterk mann som vokter huset sitt med våpen. Da kan ingen stjele noe fra ham. ");
INSERT INTO norlb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Det er først når en som er sterkere dukker opp og beseirer ham som vokter huset og tar våpene fra ham, at noen kan røve eiendelene hans. ");
INSERT INTO norlb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Den som ikke er med meg, er imot meg, og den som ikke hjelper meg i mitt arbeid, han motarbeider meg.” ");
INSERT INTO norlb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Så forklarte Jesus: ”Når en ond Ånd blir drevet ut av et menneske, da flakker den urolig omkring i ørkenen og leter etter et nytt offer. Finner den ingen, sier den: ’Jeg vender heller tilbake til det mennesket jeg kom fra.’ ");
INSERT INTO norlb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Og når den gjør det, finner ånden et hjerte som er rent og velstelt. ");
INSERT INTO norlb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Da leter den opp sju ånder til som er enda verre enn den selv. Sammen tar de kontrollen over mennesket, og det får det langt verre enn det hadde før.” ");
INSERT INTO norlb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mens han talte, ropte en kvinne i folkemassen: ”Lykkelig er den kvinnen som har født og ammet deg.” ");
INSERT INTO norlb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Han svarte: ”Si i stedet: Lykkelige er de som får høre Guds budskap og som tar være på det.” ");
INSERT INTO norlb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Fra alle kanter presset nå folket seg på, og Jesus talte til dem og sa: ”Denne slekten er en ond slekt som ikke vil tro. De krever tegn. Det eneste tegnet som de skal få, er det som skjedde med Jona. ");
INSERT INTO norlb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Det Jona fikk være med på, beviste for innbyggerne i Ninive at Gud hadde sendt ham. På samme måten skal det som jeg, Menneskesønnen, må gå gjennom, bevise for denne slekten at Gud har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dronningen fra landet i sør skal på dommens dag stige fram som vitne mot denne slekten og dømme den, for hun kom fra et fjernt land for å lytte til visdommen Salomo hadde. Men her finnes en som er større enn Salomo, og dere nekter å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Også innbyggerne i Ninive skal på dommens dag stå opp fra de døde sammen med dere og dømme dere, for de ga opp sitt onde liv og vendte seg til Gud da de hørte Jona preke Guds budskap. Men her finnes en som er større enn Jona, og dere nekter å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Når dere tenner en lampe, skjuler dere den ikke i et hjørne av rommet eller dekker over den. Dere setter den slik at alle som kommer inn, kan se lyset. ");
INSERT INTO norlb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ditt øye er kroppens lampe. Dersom øye ditt er friskt, slipper det inn lyset. Men dersom øye ditt er ødelagt, stenger det lyset ute, slik at det blir mørkt i ditt indre. ");
INSERT INTO norlb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Se derfor til at det lyset som du tror du har, i virkeligheten ikke er mørke. ");
INSERT INTO norlb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dersom alt i deg er lys og ingen del ligger i mørke, da vil ditt indre bade i lys som når en lampe lar stråleglansen flomme.” ");
INSERT INTO norlb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Mens Jesus holdt på å tale til folket, passet en av fariseerne på å be ham hjem til måltid, og Jesus fulgte med. Da han kom inn, slo han seg ned ved bordet uten først å vaske seg slik den jødiske skikken krever. Dette forskrekket fariseeren. ");
INSERT INTO norlb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Da vendte Herren Jesus seg til ham og sa: ”På utsiden er dere fariseere like blankpusset som beger og fat som dere vasker så nøye før dere drikker og spiser av dem. Men innvendig er dere fulle av griskhet og ondskap. ");
INSERT INTO norlb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Forstår dere ikke at Gud har skapt både utsiden og innsiden? ");
INSERT INTO norlb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nei, ta det som er i begrene deres og på fatene og gi det til de fattige, så vil også det indre hos dere bli rent for Gud. ");
INSERT INTO norlb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ulykken vil ramme dere fariseere! Dere gir Gud en tiendedel av den minste lille krydderplante, som mynte og karve og av alle grønsaker, men bryr dere ikke om å elske Gud og være rettferdige mot andre. Visst skal dere gi Gud en tiendedel av alt, men glem ikke det som er det aller viktigste. ");
INSERT INTO norlb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ulykken vil ramme dere fariseere, som elsker å sitte på de fremste plassene under gudstjenestene og bli hilst med respekt på torget! ");
INSERT INTO norlb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ulykken vil ramme dere, for dere er som gjengrodde graver som folk tramper på uten å legge merke til noe. Uten å vite om det kommer mennesker i kontakt med ondskapen deres.” ");
INSERT INTO norlb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","”Mester”, sa en mann i forsamlingen, en av de skriftlærde, ”når du taler på denne måten, krenker du også oss.” ");
INSERT INTO norlb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","”Ja, ulykken vil ramme dere skriftlærde også”, sa Jesus, ”for dere stiller umulige krav til folket, men gjør ikke noe for å hjelpe dem til å oppfylle det dere krever. ");
INSERT INTO norlb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ulykken vil ramme dere som reiser gravmonumenter over de profetene som bar fram Guds budskap, og som forfedrene deres myrdet! ");
INSERT INTO norlb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dere identifiserer dere med forfedrene og synes de gjorde rett, og dere ville selv ha gjort det samme. De drepte profetene, og dere bygger gravmonumenter over dem. ");
INSERT INTO norlb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Derfor har Gud i sin visdom sagt: ’Jeg skal sende profeter som bærer fram budskapet mitt, og andre som er disiplene mine. Noen vil de drepe, og andre vil de forfølge.’ ");
INSERT INTO norlb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Derfor skal også denne slekten stå til rette for drapene på alle de profetene som er drept siden verdens skapelse, ");
INSERT INTO norlb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","helt fra Abel til Sakarja, han som ble myrdet mellom alteret og templet. Ja, jeg sier dere at denne slekten som ikke vil tro, skal bli stilt til rette for alt sammen. ");
INSERT INTO norlb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ulykken vil ramme dere skriftlærde, som på grunn av undervisningen dere driver, stenger folket ute fra sannheten om Gud. Dere har ikke selv forstått den sannheten som kan frelse dere, og dere hindrer andre i å lære den å kjenne.” ");
INSERT INTO norlb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Fariseerne og de skriftlærde ble rasende, og da han gikk derfra, begynte de å overøse ham med spissfindige spørsmål. ");
INSERT INTO norlb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Hensikten var å få han til å si noe som de kunne arrestere ham for. ");
INSERT INTO norlb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","I mens hadde folk samlet seg i tusentall, slik at de holdt på å trampe hverandre ned. Jesus vendte seg først til disiplene og advarte dem: ”Ta dere i vare for læren til fariseerne, den som sprer om seg som gjæren i en deig. De er falske mennesker som bare later som om de er lydige mot Gud. ");
INSERT INTO norlb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","En dag skal sannheten komme fram. Da skal det som er skjult, bli kjent for alle. ");
INSERT INTO norlb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Det som er blitt planlagt i det skjulte, skal komme fram i lyse dagen. Det som er hvisket i ørene til noen, skal bli ropt ut fra taket på husene! ");
INSERT INTO norlb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Til dere som er vennene mine, sier jeg: Vær ikke redd for dem som vil drepe dere, men som etterpå ikke kan gjøre mer skade. ");
INSERT INTO norlb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jeg forsikrer dere at det finnes bare en som har en slik makt at vi alle bør frykte ham, og det er Gud. Han har makt både til å drepe og etterpå kan han kaste i helvete. ");
INSERT INTO norlb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Men ikke en eneste spurv, hvor lite den enn er verdt, er glemt av Gud. ");
INSERT INTO norlb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","På hver av dere er til og med hårstråene tellet. Dere skal altså ikke bekymre dere! Dere er mer verdt for Gud enn alle spurvene i hele verden. ");
INSERT INTO norlb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jeg forsikrer dere, om noen åpent bekjenner at han tilhører meg, Menneskesønnen, da skal jeg for Guds engler bekjenne at han tilhører meg. ");
INSERT INTO norlb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Men den som åpent fornekter meg, han vil selv bli fornektet for Guds engler. ");
INSERT INTO norlb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Det er slik at mennesker som sier noe imot meg, Menneskesønnen, kan få tilgivelse, men den som spotter Guds Hellige Ånd, kommer aldri til å bli tilgitt. ");
INSERT INTO norlb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Når de trekker dere for domstolene i synagogene, og dere blir forhørt av makthavere og dommerne, da skal dere ikke være bekymret for hvordan dere skal forsvare dere eller for hva dere skal si. ");
INSERT INTO norlb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Guds Hellige Ånd vil i samme øyeblikk la dere få vite nøyaktig hva dere skal si.” ");
INSERT INTO norlb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Da ropte noen i folkemassen: ”Mester, si til min bror at han skal dele arven fra vår far med meg.” ");
INSERT INTO norlb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Men Jesus svarte: ”Min venn, hvem har satt meg til dommer, slik at jeg skal avgjøre tvister mellom dere?” ");
INSERT INTO norlb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Så sa han til alle: ”Ta dere i være for pengebegjæret! Om et menneske har aldri så mye penger, vil det aldri kunne kjøpe seg det evige livet.” ");
INSERT INTO norlb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","For å understreke hva han mente, fortalte han et bilde. Han sa: ”En rik bonde hadde fått en kjempeavling. ");
INSERT INTO norlb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lagrene var så overfylte at det ikke gikk å få inn mer, og han gikk derfor og spekulerte på hva han skulle gjøre. ");
INSERT INTO norlb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Til slutt sa han: ’Nå vet jeg det, jeg river ned de gamle lagrene og bygger nytt og større. Da får jeg plass både til avlingen og alt det andre jeg eier. ");
INSERT INTO norlb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Så kan jeg slå meg til ro og si til meg selv: Du har samlet så mye at det rekker i mange år. Nå kan du koble av! Spis, drikk og vær glad!’ ");
INSERT INTO norlb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Men Gud sa til mannen: ’Din dåre, allerede i natt skal du dø! Hvem skal da få alt det du har spart deg opp?’ ");
INSERT INTO norlb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Slik går det for den som samler seg rikdom på jorden, men er fattig i Guds øyne.” ");
INSERT INTO norlb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus vendte seg igjen til disiplene og sa: ”Derfor sier jeg dere: Bekymre dere ikke for hvordan dere skal klare livet, hvordan dere skal få mat å spise og klær å ha på dere. ");
INSERT INTO norlb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Det finnes viktigere saker i livet enn mat og klær. ");
INSERT INTO norlb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Se på ravnene! De bekymrer seg ikke for hva de skal spise. De verken sår, høster, eller skaffer seg forrådskammer og lagerplass, men Gud gir dem likevel mat. Er ikke dere mye mer verd for han enn det fuglene er? ");
INSERT INTO norlb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hva tjener det til å bekymre seg? Kan det forlenge livet med en eneste time? Naturligvis ikke! ");
INSERT INTO norlb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dersom dere nå ikke en gang kan klare å gjøre så lite med antall levedager, hvorfor bekymrer dere da for alt det andre? ");
INSERT INTO norlb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Se på liljene hvordan de vokser. De arbeider ikke og skaper ingen klær. Likevel forsikrer jeg dere at ikke en gang kong Salomo i all sin prakt var så vakkert kledd som de. ");
INSERT INTO norlb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dersom nå Gud gir så vidunderlige klær til gresset, som står i dag på marken og i morgen blir kastet på bålet, skulle han ikke da ordne med klær til dere? Stoler dere fortsatt så lite på Gud? ");
INSERT INTO norlb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ikke driv å gruble på hva dere skal spise og drikke. Ikke vær bekymret for slikt. ");
INSERT INTO norlb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gjør ikke som folk i verden som ikke kjenner Gud. De jager etter alt dette og bekymrer seg hele tiden. Deres Far i himmelen vet allerede hva dere trenger. ");
INSERT INTO norlb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Han vil gi dere alt dette med glede, dersom dere først og fremst ser til at han får regjere blant dere. ");
INSERT INTO norlb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Vær altså ikke redde for framtiden, dere som er min lille flokk av disipler. Deres Far i himmelen har besluttet at dere skal få være hans eget folk. ");
INSERT INTO norlb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Selg det dere eier og gi til de fattige. Dere samler dere da en skatt i himmelen, i en lommebok som aldri blir slitt ut. Der er skatten sikkert oppbevart. Ingen kan stjele den og den beholder alltid sin verdi. ");
INSERT INTO norlb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Dersom skatten deres finnes i himmelen, vil også hjertet og tankene deres være der. ");
INSERT INTO norlb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Vær alltid beredt og klar til å tjene. ");
INSERT INTO norlb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Vær som tjenere som venter på at herren deres skal komme hjem fra en bryllupsfest. De holder seg våkne og beredt slik at de raskt kan åpne døren for sin herre når han banker på. ");
INSERT INTO norlb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","En ekstra belønning venter dem som er beredt når herren kommer. Ja, jeg forsikrer dere at han vil selv gjøre seg klar til å tjene, og han vil la dem som er beredt, få slå seg ned ved bordet for å spise mens han selv serverer dem. ");
INSERT INTO norlb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kanskje kommer han ikke før ved midnatt eller til og med like før morgendemringen. Men en ekstra belønning venter dem som er beredt. ");
INSERT INTO norlb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","La meg ta et annet eksempel: Dersom huseieren visste når tyven tenkte å forsøke seg på innbrudd, da ville han selvfølgelig hindre ham i å bryte seg inn. ");
INSERT INTO norlb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Vær også dere beredt, for jeg, Menneskesønnen, kommer tilbake når dere minst av alt venter det.” ");
INSERT INTO norlb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter spurte: ”Herre, snakker du nå bare til oss, eller gjelder dette også for alle?” ");
INSERT INTO norlb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesus svarte med et bilde og sa: ”Jeg snakker til hver og en som er lik en klok og pålitelig tjener, og som av herren sin har fått i oppgave å passe på at de andre tjenerne får mat slik de skal ha. ");
INSERT INTO norlb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Lykkelig er den tjeneren om herren kommer hjem og får se at han gjør det han skal. ");
INSERT INTO norlb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jeg lover dere at en slik trofast tjener vil få ansvaret for alt herren eier. ");
INSERT INTO norlb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Men om tjeneren sier til seg selv: ’Min herre kommer sikkert ikke på en stund ennå’, og så begynner å mishandle de andre tjenerne, og selv lever han livets glade dager og drikker seg full. ");
INSERT INTO norlb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","En dag da han slett ikke venter det, kommer herren hans helt plutselig. Da vil herren hans henrette ham, og la ham dele straff med dem som nekter å være lydige mot Gud. ");
INSERT INTO norlb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Den tjeneren som kjenner sin herres vilje og likevel ikke følger den eller bryr seg om det herren har gitt befaling om, han skal få strengere straff. ");
INSERT INTO norlb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Men den som ikke er klar over at han handler galt, han vil få en mildere straff. Jo større oppgave en tjener har fått, desto mer kommer det til å bli krevd av ham, etter som ansvaret hans er større. ");
INSERT INTO norlb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jeg har kommet for å tenne en ild på jorden, og jeg ønsker at min oppgave var sluttført. ");
INSERT INTO norlb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Men mye lidelse venter meg, og jeg er sterkt plaget før alt er over. ");
INSERT INTO norlb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tror dere at jeg har kommet for å skape fred på jorden? Nei, heller snarere strid og splittelse! ");
INSERT INTO norlb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dersom fem personer bor i et hjem, vil de i fortsettelsen komme til å leve i strid. Tre kommer til å ta parti for meg og to imot meg, eller kanskje tvert om. ");
INSERT INTO norlb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Far og sønn, mor og datter, svigermor og svigerdatter vil alle være imot hverandre.” ");
INSERT INTO norlb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Så vendte Jesus seg mot folket og sa: ”Når dere ser skyene tørne seg opp i vest, sier dere: ’Nå blir det regn.’ Og slik blir det. ");
INSERT INTO norlb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Når det blåser vind fra sør, sier dere: ’I dag blir det fryktelig varmt!’ Og slik blir det. ");
INSERT INTO norlb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dere er falske mennesker som bare later som om dere er lydige mot Gud! Dere har så lett for å tyde de tegnene dere ser på himmelen og i naturen, men de tingene som utspiller seg rett for øynene på dere, kan dere ikke forstå. ");
INSERT INTO norlb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hvorfor avgjør dere ikke selv hva som er rett? ");
INSERT INTO norlb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Om noen anklager deg for ikke å ha betalt tilbake en gjeld, og du er på veien med din motpart til domstolen, da forsøk å bli enig med ham før dere er nådd fram. Ellers vil han kanskje dra deg for dommeren, som etterpå lar sin betjent ta hånd om deg og sette deg i fengsel. ");
INSERT INTO norlb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jeg forsikrer deg at du må bli der til du har betalt alt det du er skyldig.” ");
INSERT INTO norlb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Samtidig kom noen og fortalte til Jesus at landshøvdingen Pilatus hadde drept flere jøder fra Galilea mens de ofret i templet i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus spurte: ”Tror dere at disse var større syndere enn andre folk i Galilea? Var det derfor de måtte lide? ");
INSERT INTO norlb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nei! Men jeg forsikrer dere at dersom dere ikke slutter å synde og vender om til Gud, vil også dere miste livet. ");
INSERT INTO norlb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Og hvordan var det med de 18 ofrene som døde da tårnet i Siloa raste ned over dem? Var de større syndere enn alle andre i Jerusalem? ");
INSERT INTO norlb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nei! Men jeg forsikrer dere at dersom dere ikke slutter å synde og vender om til Gud, vil også dere miste livet.” ");
INSERT INTO norlb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Så fortalte Jesus et bilde for å illustrere det han hadde sagt: ”En mann plantet et fikentre i hagen sin. Med jevne mellomrom kom han for å se om det var noe frukt på treet, men han ble alltid like skuffet. ");
INSERT INTO norlb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Til sist ba han gartneren sin om å hugge det ned. ’Jeg har ventet i tre år, og det har ennå ikke blitt en eneste fiken på det!’ sa han. ’Det er bedre at jeg planter andre trær i stedet.’ ");
INSERT INTO norlb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Men gartneren ba: ’Herre, gi det en sjanse til. La det stå dette året også, så skal jeg stelle det og gi det skikkelig med gjødsel. ");
INSERT INTO norlb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kanske blir det fiken på det neste år. Om ikke, så hugger jeg det ned.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","En hviledag da Jesus underviste i synagogen, ");
INSERT INTO norlb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","var det en kvinne der som var handikappet på grunn av en ond Ånd. Hun hadde gått med krum rygg i 18 år og kunne ikke rette seg opp. ");
INSERT INTO norlb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Da Jesus fikk se henne, kalte han på henne og sa: ”Kvinne, du er fri fra din sykdom!” ");
INSERT INTO norlb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Så la han hendene på henne, og straks rettet hun opp ryggen og begynte å hylle Gud. ");
INSERT INTO norlb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Men lederen for synagogen ble sint over at Jesus helbredet henne på hviledagen. ”Det finnes seks dager i uken da alle kan arbeide”, sa han til folket. ”Dere kan komme og bli helbredet på hverdagene, men ikke på hviledagen!” ");
INSERT INTO norlb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Da svarte Jesus: ”Nå er dere falske og bare later som om dere er lydige mot Gud! Finnes det en eneste av dere som ikke arbeider på hviledagen? Dere løser jo oksene og eslene deres fra krybben og leier dem ut så de får vann? ");
INSERT INTO norlb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Men her har vi en jødisk kvinne som Satan har holdt bundet i 18 år, og så vil dere hindre henne fra å bli løst fra sin pine bare fordi det er hviledag!” ");
INSERT INTO norlb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Det fikk fiendene hans til å gå skamfull bort, men folket gledet seg over de store miraklene som han gjorde. ");
INSERT INTO norlb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus sa: ”Hvordan er det når Gud regjerer? Hvordan skal jeg beskrive det? ");
INSERT INTO norlb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jo, det er som når en mann sår et lite sennepsfrø i hagen sin. Det vokser og blir til et tre, og fuglene bygger reir mellom grenene. ");
INSERT INTO norlb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Der Gud regjerer, blir det også som når en kvinne blander gjær i deigen sin når hun baker. Hun tar bare litt gjær og blander det inn i en stor mengde mel og elter det sammen. Så påvirker gjæren hele den store deigen.” ");
INSERT INTO norlb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","På vei mot Jerusalem gikk Jesus innom flere bygder og byer og underviste. ");
INSERT INTO norlb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Noen spurte ham: ”Herre, er det bare noen få som blir frelst?” Jesus sa til folket: ");
INSERT INTO norlb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","”Den som vil bli frelst, må gå inn gjennom den trange porten. Gjør alt dere kan for å komme inn gjennom den. Sannheten er at mange skal forsøke, men ikke lykkes. ");
INSERT INTO norlb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Når husets herre har reist seg og låst porten, er det for seint. Dersom dere da står utenfor og banker og roper: ’Herre, åpne for oss!’ da skal han svare: ’Jeg kjenner dere ikke.’ ");
INSERT INTO norlb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kanske sier dere da: ’Men vi har jo spist og drukket sammen med deg. Og du gikk rundt på våre gater og underviste!’ ");
INSERT INTO norlb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Men han skal svare: ’Har jeg ikke allerede sagt at jeg ikke kjenner dere eller vet hvor dere kommer fra! Forsvinn herfra, dere som er onde mennesker!’ ");
INSERT INTO norlb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja, dere skal gråte av angst og fortvilelse når dere blir stengt ute fra Guds nye verden, og ser Abraham, Isak og Jakob innenfor sammen med alle profetene som bar fram Guds budskap. ");
INSERT INTO norlb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Folkene fra alle jordens land skal komme og være med på festen i Guds nye verden. ");
INSERT INTO norlb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Da skal de som i dag har lav status, være blant de fremste, mens andre som i dag blir regnet å være betydningsfulle, må holde seg i bakgrunnen.” ");
INSERT INTO norlb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nå kom noen fariseere til ham og sa: ”Røm straks bort herfra, for Herodes har planer om å drepe deg!” ");
INSERT INTO norlb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus svarte: ”Hils til den reven og si at jeg driver ut onde ånder og helbreder syke i dag og i morgen, og at jeg på den tredje dagen når målet mitt. ");
INSERT INTO norlb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ja, i dag, i morgen og i overmorgen skal jeg fortsette min reise, for en profet som bærer fram Guds budskap, kan ikke bli drept noe annet sted enn i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Åh, dere innbyggere i Jerusalem, som dreper profetene og steiner andre som Gud sender til dere med budskapet sitt. Hvor ofte har jeg ikke ønsket å samle dere på samme måte som når en høne samler kyllingene sine under vingene, men dere lot meg ikke gjøre det. ");
INSERT INTO norlb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nå får dere selv ta hånd om templet deres. Ja, jeg sier at dere vil ikke få se meg igjen før dere sier: ’Vi ærer deg som er sendt av Herren.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","En hviledag var Jesus bedt hjem på mat til en fariseer som var medlem i Det jødiske rådet. De fulgte nøye med ham. ");
INSERT INTO norlb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Det var nemlig en mann der som led av alvorlig hevelse i kroppen. Plutselig stilte mannen seg foran Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus vendte seg da til fariseerne og de skriftlærde og spurte: ”Tillater Moseloven å helbrede noen på hviledagen?” ");
INSERT INTO norlb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Men de nektet å svare. Da rørte Jesus ved den syke mannen og helbredet ham og lot ham gå. ");
INSERT INTO norlb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Så sa han: ”Hva gjør dere selv på hviledagen? Dersom noen av dere har et barn eller kanskje en okse som ramler i en brønn, drar dere ikke da straks opp den som falt i brønnen? Ja, selv om det skulle være på en hviledag!” ");
INSERT INTO norlb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dette kunne de ikke svare noe på. ");
INSERT INTO norlb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Da Jesus så at gjestene forsøkte å sikre seg plassene nærmest vertskapet mens de tok plass ved bordet, ga han dette rådet: ");
INSERT INTO norlb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","”Dersom du blir invitert til bryllup, bør du ikke streve etter å få de fremste plassene. Det kan jo komme noen som er mer ansett enn du, ");
INSERT INTO norlb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","og da vil verten si: ’Kan du være så snill og overlate plassen din til denne gjesten.’ Da må du sjenert lete opp en plass lengst nede ved festbordet. ");
INSERT INTO norlb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Gjør i stedet slik som dette. Velg en plass lengst nede. Når da verten kommer og ser deg, vil han kanskje si: ’Min venn, det finnes en bedre plass her framme til deg!’ Da kommer du til å bli æret i alle gjestenes påsyn. ");
INSERT INTO norlb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","For den som opphøyer seg selv, vil bli ydmyket. Den som derimot ydmyker seg selv, vil bli opphøyd.” ");
INSERT INTO norlb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Så vendte Jesus seg til fariseeren som hadde invitert ham, og sa: ”Når du innbyr til fest, skal du ikke bare be vennene dine eller søsken eller slektninger eller rike naboer, for da blir din eneste belønning at de inviterer deg tilbake. ");
INSERT INTO norlb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nei, invitere i stedet dem som er fattige og handikappet, lamme og blinde. ");
INSERT INTO norlb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Etter som de ikke kan invitere deg tilbake, vil Gud lønne deg for det du gjorde, den dagen han vekker opp de døde og belønner dem som fulgte hans vilje.” ");
INSERT INTO norlb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","En mann som satt ved bordet og hørte dette, sa: ”Lykkelig er den som får komme til festen i Guds nye verden.” ");
INSERT INTO norlb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus svarte med en fortelling. Han sa: ”En mann ordnet en stor fest og innbød mange gjester. ");
INSERT INTO norlb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Da tiden for festen var inne, sendte han av sted tjenerne sine til dem som var innbudt, for å si: ’Alt er klart, velkommen til festen.’ ");
INSERT INTO norlb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Men alle kom med unnskyldninger. En sa: ’Jeg har nettopp kjøpt en gård og må gå for å inspisere den. Tilgi at jeg ikke kan komme!’ ");
INSERT INTO norlb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","En annen sa: ’Det går dessverre ikke. Jeg har nettopp kjøpt fem par okser og vil gjerne se hva de duger til.’ ");
INSERT INTO norlb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","En tredje ba om unnskyldning og sa: ’Jeg har nettopp giftet meg. Du forstår sikkert at jeg ikke kan komme.’ ");
INSERT INTO norlb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Da tjenerne etter en stund kom tilbake og fortalte det de hadde sagt, ble herren hans sint og ga befaling om at han straks skulle gå ut på alle gatene og smugene i hele byen og hente dem som var fattige og handikappet, blinde og lamme. ");
INSERT INTO norlb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tjenerne kom tilbake og sa: ’Herre, vi har gjort som du ga befaling om, men fortsatt finnes det plasser igjen.’ ");
INSERT INTO norlb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Da sa mannen til tjenerne sine: ’Gå ut over alt på veiene og stiene der dere oppfordrer alle til å komme, slik at huset mitt kan bli fullt. ");
INSERT INTO norlb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Jeg sier er at ingen av dem som jeg første gangen innbød, skal få være med på festen.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesus var omgitt av et stort antall mennesker, og han vendte seg mot dem og sa: ");
INSERT INTO norlb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","”Den som kommer til meg, må elske meg mer enn noen andre, mer enn foreldre, kone eller mann, barn og søsken, ja, til og med mer enn selve livet, ellers kan han ikke være disippelen min. ");
INSERT INTO norlb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Den som ikke følger mitt eksempel og er beredt til å dø, kan ikke være disippelen min. ");
INSERT INTO norlb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dere må kalkulere hva det koster. La meg forklare dette med et bilde: Om noen av dere vil bygge et tårn, vil han ikke da først sette seg ned og regne ut om han har nok penger til å fullføre bygget? ");
INSERT INTO norlb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jo, selvfølgelig, ellers vil han kanskje ikke komme lenger enn til grunnmuren, og da blir han ledd ut av alle. ");
INSERT INTO norlb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","’Se på denne mannen’, vil folk si med et hånflir: ’Han begynte å bygge, men pengene tok slutt før han var ferdig!’ ");
INSERT INTO norlb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tenk også på dette bilde: En konge planla å dra ut i krig mot en annen konge. Setter han seg ikke først ned og overveier om hæren hans på 10 000 mann er sterk nok til å beseire den fienden som kommer imot ham med 20 000 mann? ");
INSERT INTO norlb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Viser det seg å være umulig, sender han i stedet ut forhandlere for å be om fred, mens fiendens hær fortsatt er langt unna. ");
INSERT INTO norlb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ingen kan altså bli disiplene mine, dersom de ikke er beredt til å gi opp alt de eier, for min skyld. ");
INSERT INTO norlb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Den som er beredt til å følge meg, samme hva det enn vil koste, han blir som saltet som bevarer verden fra forråtnelse. Men til hvilken nytte er salt dersom det mister sin kraft? Kan da noen få det til å bli salt igjen? ");
INSERT INTO norlb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nei, det duger ikke verken til forbedring av jorden eller til å bli kastet på gjødselhaugen. Det må fjernes helt. Lytt nøye og forsøk å forstå!” ");
INSERT INTO norlb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tollere og andre syndere som var beryktet, kom ofte for å høre på når Jesus talte. ");
INSERT INTO norlb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dette irriterte fariseerne og de skriftlærde som kritiserte Jesus for at han hadde omgang med så tvilsomme mennesker. Ja, han til og med spiste sammen med dem. ");
INSERT INTO norlb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Da forklarte Jesus sine motiver ved å fortelle et bilde. Han sa: ");
INSERT INTO norlb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","”Om noen av dere har 100 sauer og plutselig oppdager at han mangler en av dem, vil han ikke da forlate de 99 andre i ødemarken og lete etter den som er forsvunnet til han finner den? ");
INSERT INTO norlb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jo, og når han finner den, blir han glad og bærer sauen hjem på skuldrene sine. ");
INSERT INTO norlb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Etterpå samler han vennene og naboene sine for at de også kan glede seg over at han har funnet igjen sauen han hadde mistet. ");
INSERT INTO norlb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jeg forsikrer dere at på samme måten kommer de til å glede seg mer i himmelen over en eneste synder som vender om til Gud, enn over 99 som allerede følger Guds vilje og ikke trenger å vende tilbake til Gud.” ");
INSERT INTO norlb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesus brukte også et annet eksempel: ”Om en kvinne har ti verdifulle sølvmynter og mister en av dem, vil hun ikke da tenne en lampe og feie gulvene i hele huset og lete i hver krik og krok til hun finner den? ");
INSERT INTO norlb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Etterpå samler hun sine venner og naboer for at de skal glede seg med henne? ");
INSERT INTO norlb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","På samme måten gleder Guds engler seg over hver eneste synder som vender om til Gud.” ");
INSERT INTO norlb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus fortalte videre et tredje bilde. Han sa: ”En mann hadde to sønner. ");
INSERT INTO norlb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Den yngste sa til faren: ’Jeg vil ha min del av arven nå i stedet for å vente til du dør.’ Faren gikk med på å dele sin eiendom mellom sønnene. ");
INSERT INTO norlb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Noen dager seinere hadde den yngste sønnen solgt alt han eide, og så ga han seg på vei til et fremmed land. Der levde han et vilt og umoralsk liv og gjorde snart slutt på alle pengene sine. ");
INSERT INTO norlb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","En alvorlig sultekatastrofe rammet landet, og han begynte å lide nød. ");
INSERT INTO norlb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","I sin fortvilelse ba han en bonde om å få jobb, og mannen sendte ham ut for å holde vakt over grisene sine. ");
INSERT INTO norlb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Til slutt var han så sulten at han bare lengtet etter å få spise av maten til grisene, men ingen ga ham noe. ");
INSERT INTO norlb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Endelig innså han hvor dum han hadde vært og sa til seg selv: ’Hjemme hos far har de ansatte mat i overflod, og her holder jeg på å sulte i hjel! ");
INSERT INTO norlb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jeg går hjem til far og sier: Far, jeg har syndet både mot Gud og deg. ");
INSERT INTO norlb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jeg er ikke verd å bli kalt din sønn lenger, men la meg i det minste få arbeide som en av dine tjenere.’ ");
INSERT INTO norlb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Og så gikk han veien hjem til sin far. Mens sønnen ennå var langt borte, så faren ham og ble fylt av kjærlighet og medfølelse. Han sprang imot sønnen sin og kastet seg om halsen på han og kysset ham. ");
INSERT INTO norlb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sønnen utbrøt: ’Far, jeg har syndet både mot Gud og deg. Jeg er ikke lenger verd til å bli kalt din sønn.’ ");
INSERT INTO norlb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Men faren sa til tjenerne: ’Skynd dere! Ta fram mine fineste klær og ha dem på ham. Sett en ring på fingeren hans og sko på føttene! ");
INSERT INTO norlb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Hent gjøkalven og slakt den, for nå skal vi spise og ha en kjempefest. ");
INSERT INTO norlb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sønnen min var død, men er blitt levende igjen. Han var tapt, men er kommet tilbake til meg igjen.’ Så begynte festen og gleden. ");
INSERT INTO norlb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Imens hadde den eldre sønnen vært ute på åkeren. Da han nå nærmet seg huset, hørte han på lang avstand lyden av musikk og dans. ");
INSERT INTO norlb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Forskrekket spurte han en av tjenerne hva det var de feiret. ");
INSERT INTO norlb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tjeneren svarte: ’Broren din har kommet tilbake, og faren din har slaktet gjøkalven og ordnet med en fest for å feire at han har kommet hjem i god behold.’ ");
INSERT INTO norlb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Da ble den eldre sønnen rasende og ville ikke gå inn i huset. Faren gikk ut og forsøkte å overtale ham til å komme inn, ");
INSERT INTO norlb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","men han svarte: ’I alle disse årene har jeg arbeidet hardt og aldri noen gang har jeg nektet å gjøre det du har bedt meg om. Likevel har du ikke gitt meg et eneste kje for at jeg kunne ha fest sammen med vennene mine. ");
INSERT INTO norlb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Men nå kommer denne døgenikten hjem, han som har gjort slutt på pengene dine sammen med prostituerte, og da feirer du det med å slakte gjøkalven!’ ");
INSERT INTO norlb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Ro deg ned, sønnen min,’ sa faren til ham. ’Du og jeg er alltid sammen, og alt jeg eier er ditt. ");
INSERT INTO norlb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Men nå må vi være glade og feire det som har skjedd, for broren din var død, men er blitt levende igjen. Han var tapt, men er kommet tilbake til meg igjen.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus fortalte også et annet bilde, men denne gangen bare for disiplene. Han sa: ”En rik mann hadde en forvalter som drev forretningene hans, men ryktet begynte å gå om at mannen satte pengene hans over styr. ");
INSERT INTO norlb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Arbeidsgiveren kalte derfor mannen til seg og sa: ’Hva er det jeg hører om deg! Legg fram regnskapet, for jeg tenker å gi deg oppsigelse i jobben.’ ");
INSERT INTO norlb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Forvalteren tenkte da med seg selv: ’Hva skal jeg nå gjøre dersom jeg må slutte som forvalter? Grave grøfter orker jeg ikke og å tigge skammer jeg meg over. ");
INSERT INTO norlb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Men jeg har en idé som kan gi meg mange venner den dagen jeg må forlate jobben min.’ ");
INSERT INTO norlb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","Som tenkt som gjort! Han ba om et møte med dem som skyldte arbeidsgiveren penger, og begynte å forhandle med en etter en. Den første spurte han: ’Hvor mye er du skyldig?’ ’100 fat olivenolje’, svarte mannen. Da sa forvalteren: ’Her er gjeldsbrevet du har skrev under på. Riv det i biter og skriv ut et nytt på 50 fat i stedet.’ ");
INSERT INTO norlb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Så spurte han neste mann: ’Og hvor mye skylder du?’ ’100 tønner hvete’, svarte han. ’Her’, sa forvalteren, ’ta gjeldsbrevet ditt og skriv 80 tønner i stedet!’ ");
INSERT INTO norlb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Den rike mannen var nødt til å innrømme at den uærlige forvalteren hans hadde vært smart. Og det er faktisk slik at denne verdens mennesker er mer smarte mot hverandre, enn de som tilhører Gud. ");
INSERT INTO norlb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ja, det rådet skal jeg gi dere, at det å bruke pengene sine til å hjelpe andre kan føre til at dere blir hilst velkommen til Guds evighet den dagen pengene her har mistet sin verdi. ");
INSERT INTO norlb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bare den som er ærlig i de daglige forhold, vil være ærlige når det gjelder større bestemmelser. Fusker noen i det lille, vil de også fuske i stort. ");
INSERT INTO norlb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dersom dere er upålitelige i spørsmål om penger, hvem vil da la dere ta hånd om de virkelige verdiene? ");
INSERT INTO norlb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dersom dere ikke er til å stole på når det gjelder pengene til andre, hvem vil da betro dere sine egne penger å forvalte? ");
INSERT INTO norlb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ingen kan tjene to herrer samtidig. Enten vil han hate den første og elske den andre, eller elske den første og hate den andre. Dere må altså velge. Dere kan ikke tjene Gud samtidig som dere elsker pengene.” ");
INSERT INTO norlb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Da fariseerne hørte dette, kritiserte de Jesus, for de var svært glade i penger. ");
INSERT INTO norlb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus sa: ”Dere gjør alt for at folket skal tro at dere følger Guds vilje, men Gud vet hvor onde dere er. Og det som gjør inntrykk på folket, er gjerne slikt som Gud hater.” ");
INSERT INTO norlb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesus sa også: ”Fram til den dagen da døperen Johannes begynte å tale til folket, var det ordene som er skrevet ned i Moseloven og profetene som var folkets veivisere. Etter denne tiden blir nå det glade budskapet spredd om at Gud vil frelse menneskene og gjøre dem til sitt eget folk. Alle presser på for å få være med. ");
INSERT INTO norlb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Men det betyr ikke at loven har sluttet å gjelde. Nei, så lenge himmelen og jorden består, vil hvert ord i loven være gyldig. ");
INSERT INTO norlb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Fortsatt gjelder det at den mannen som skiller seg fra kona si og gifter seg på nytt med en annen, han er utro. Og den som gifter seg med en kvinne som er skilt, gjør at hun er utro.” ");
INSERT INTO norlb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus fortalte: ”Det var en gang en rik mann som var flott kledd og hver dag levde i luksus og overflod. ");
INSERT INTO norlb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","På samme tiden lå en tigger som het Lasarus, ved porten hans full av sår. ");
INSERT INTO norlb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasarus håpet å få noen matrester fra bordet til den rike mannen, og hundene kom og slikket sårene hans. ");
INSERT INTO norlb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Til slutt døde tiggeren og ble ført av englene til Abraham, til det stedet der ingen lidelse finnes. Den rike mannen døde også og ble begravd. ");
INSERT INTO norlb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Da han slo opp øynene sine, var han i helvete, der han ble uhyggelig plaget. Langt borte fikk han se Abraham, og Lasarus som satt ved siden av ham. ");
INSERT INTO norlb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","’Far Abraham’, ropte han. ’Ha medfølelse med meg! Send Lasarus hit for å dyppe fingeren i vann for å leske tungen min. Jeg blir så fryktelig plaget i disse flammene.’ ");
INSERT INTO norlb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Men Abraham sa til ham: ’Min sønn, husk på at du i din tid på jorden hadde alt du ønsket deg, mens Lasarus ikke hadde noe. Nå er han her for å bli trøstet, mens du blir plaget. ");
INSERT INTO norlb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dessuten finnes det en stor avgrunn som skiller mellom oss. Ingen kan komme herfra og ta seg over til dere. Heller ikke kan noen komme over fra dere til oss.’ ");
INSERT INTO norlb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Da sa den rike mannen: ’Far Abraham, send ham i det minste ");
INSERT INTO norlb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","til mine fem brødre for å advare dem mot dette stedet med så mye pine, slik at de slipper å komme hit når de dør.’ ");
INSERT INTO norlb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham sa: ’De kan høre på det Gud har sagt i Moseloven og ved profetene.’ ");
INSERT INTO norlb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Den rike mannen svarte: ’Nei, far Abraham, det bryr de seg ikke om. Men om noen kommer til dem fra de døde, da vender de om til Gud!’ ");
INSERT INTO norlb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Men Abraham sa: ’Dersom de ikke vil høre på det som Gud har sagt i Moseloven og profetene, vil de heller ikke bli overbevist selv om noen står opp fra de døde.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","En dag advarte Jesus disiplene og sa: ”Det vil alltid finnes noe som frister menneskene til å synde. Men ulykken vil ramme den som frister andre. ");
INSERT INTO norlb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ja, det ville være bedre for ham å bli kastet i havet med en tung kvernstein bundet til halsen, enn at han skal leve videre og få mulighet til å føre noen vill av disse som med et barns tillit tror på meg. ");
INSERT INTO norlb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jeg advarer dere! Dersom noen har handlet galt, skal du vise til rette den det gjelder, og tilgi personen dersom han angrer seg. ");
INSERT INTO norlb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ja, selv om noen handler galt mot deg sju ganger samme dagen, og så sju ganger angrer seg og ber om tilgivelse, skal du tilgi.” ");
INSERT INTO norlb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","En dag sa disiplene til Herren Jesus: ”Vi skulle gjerne hatt større tro. Fortell oss hvordan vi kan få det.” ");
INSERT INTO norlb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","”Mer tro?”, svarte Herren. ”Om troen deres bare var så stor som et sennepsfrø, da ville dere kunne si til morbærtreet der borte: ’Rykk deg av egen kraft opp med røttene og kast deg i havet!’ Og det ville være lydig mot det dere sier.” ");
INSERT INTO norlb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesus sa også: ”Tenk dere at dere har en tjener som kommer hjem etter å ha pløyd på åkeren eller passet sauene. Da sier dere ikke til ham: ’Slå deg først ned ved bordet og spis.’ ");
INSERT INTO norlb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nei, dere sier: ’Gjør i stand kveldsmaten til meg og varte meg opp mens jeg spiser. Etterpå kan du selv spise og drikke.’ ");
INSERT INTO norlb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dere ville heller ikke takke tjeneren, for han har jo bare gjort det han fikk beskjed om. ");
INSERT INTO norlb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Det samme gjelder dere. Når dere har gjort alt dere har fått beskjed om, da skal dere si: ’Vi er vanlige, enkle tjenere, vi har bare gjort plikten vår.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","På sin videre reise mot Jerusalem kom Jesus til grensen mellom Galilea og Samaria. ");
INSERT INTO norlb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Der gikk han inn i en by, og plutselig kom ti spedalske imot han. De stanset et stykke borte ");
INSERT INTO norlb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","og ropte: ”Herre Jesus, ha medfølelse med oss!” ");
INSERT INTO norlb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Da iakttok han dem og sa: ”Gå til prestene og la de undersøke dere!” Og mens de var på vei dit, ble de friske! ");
INSERT INTO norlb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","En av dem kom tilbake til Jesus da han så at han var blitt frisk, og han ropte høyt og hyllet Gud. ");
INSERT INTO norlb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Så kastet han seg ned for Jesus med ansiktet mot jorden og takket ham. Denne mannen var fra Samaria. ");
INSERT INTO norlb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus spurte da: ”Var det ikke ti i alt som ble friske? Hvor er de andre ni? ");
INSERT INTO norlb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Er det bare denne fremmede som har kommet tilbake for å takke Gud?” ");
INSERT INTO norlb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Han sa til mannen: ”Reis deg opp og gå. Din tro har hjulpet deg.” ");
INSERT INTO norlb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","En dag spurte fariseerne Jesus om når Gud ville gi dem en konge som kunne regjere. Jesus svarte: ”Gud selv regjerer allerede blant menneskene, men ikke på en slik måte at noen kan se det med sine fysiske øyne. ");
INSERT INTO norlb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ingen kan si: ’Her er kongen vår’, eller: ’Der er kongen vår’. Nei! Gud regjerer i dere.” ");
INSERT INTO norlb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Litt etter forklarte han dette nærmere for disiplene og sa: ”Det skal komme en tid da dere lengter etter å få oppleve en eneste dag sammen med meg, Menneskesønnen, i Guds nye verden, men dere skal ikke få det. ");
INSERT INTO norlb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Noen vil si til dere: ’Han har kommet igjen. Der er han’, eller: ’Her er han’. Men ikke tro på det og ikke gå dit. ");
INSERT INTO norlb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","For når jeg, Menneskesønnen, virkelig kommer igjen, blir det like tydelig som når lynet flerrer over himmelen og lyser opp hele horisonten. ");
INSERT INTO norlb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Men før dette hender, må jeg lide mye og bli avvist av denne slekten som ikke vil tro. ");
INSERT INTO norlb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Når jeg, Menneskesønnen, kommer igjen, vil verden være like sorgløs som på den tiden da Noah levde. ");
INSERT INTO norlb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Da spiste, drakk og giftet de seg. Alt var akkurat som til vanlig, helt til den dagen da Noah gikk inn i arken, og den voldsomme oversvømmelsen kom og druknet alle sammen. ");
INSERT INTO norlb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","På samme måten var det på tiden da Lot levde. Menneskene holdt på med sine daglige sysler. De spiste, drakk, kjøpte, solgte, plantet og bygget. ");
INSERT INTO norlb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Alt var normalt helt til den morgenen da Lot dro fra Sodoma. Da regnet det ild og svovel fra himmelen og drepte alle sammen. ");
INSERT INTO norlb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Akkurat på samme måten blir det når jeg, Menneskesønnen, kommer igjen. ");
INSERT INTO norlb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Den dagen må den som er oppe på taket og har sine eiendeler inne i huset, ikke gå innfor å pakke. Den som er ute på åkeren, må ikke ta omveien hjem. ");
INSERT INTO norlb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Husk på det som skjedde med kona til Lot! ");
INSERT INTO norlb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Den som klamrer seg fast til livet, vil miste det, men den som mister livet for Guds skyld, skal redde det. ");
INSERT INTO norlb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ja, den natten skal to personer sove i samme seng. Den ene bli tatt med, den andre bli latt tilbake. ");
INSERT INTO norlb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","To kvinner skal male mel på samme kvernen. Den ene blir tatt med, den andre bli latt tilbake.” ");
INSERT INTO norlb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Da spurte disiplene: ”Herre, når kommer dette til å skje?” Jesus svarte: ”Det skal være like tydelig som når gribbene kretser over den døde kroppen.” ");
INSERT INTO norlb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","En gang, da Jesus ville vise disiplene hvor viktig det alltid er å be og ikke gi opp, fortalte han dette bildet for dem: ");
INSERT INTO norlb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","”I en by var det en dommer, en ond mann som ikke viste respekt verken for Gud eller mennesker. ");
INSERT INTO norlb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","I samme byen var det også en enke som titt og ofte kom til ham og sa: ’Hjelp meg til å få det jeg skal ha av min motpart.’ ");
INSERT INTO norlb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","I lang tid brydde ikke dommeren seg om henne, men til slutt begynte hun å gå ham på nervene. Da sa han til seg selv: ’Visst nok bruker jeg ikke å vise respekt verken for Gud eller mennesker, men denne kvinnen gjør meg helt forstyrret. Det er best jeg ser til at hun får det hun har rett på. Jeg er trøtt på stadige maset hennes!’ ” ");
INSERT INTO norlb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Så sa Herren Jesus: ”Når til og med en så ond og urettferdig mann som denne dommerne kan gi seg, ");
INSERT INTO norlb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","tror dere ikke da at Gud mye mer vil gi retten til dem som tilhører ham, når de ber dag og natt? ");
INSERT INTO norlb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jo, jeg forsikrer dere at han ikke vil la dem vente. Men spørsmålet er: Kommer jeg, Menneskesønnen, til å finne noen som tror, den dagen jeg kommer igjen?” ");
INSERT INTO norlb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","En annen gang vendte Jesus seg til noen som skrøt av at de alltid fulgte Guds vilje og som så ned på andre folk. Jesus fortalte et bilde for dem, og sa: ");
INSERT INTO norlb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","”To menn gikk til templet for å be. En av dem var fariseer, den andre var toller. ");
INSERT INTO norlb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseeren sto for seg selv og ba: ’Takk Gud for at jeg ikke er en synder som alle andre, og spesielt ikke som tolleren der borte! Jeg bedrar ikke noen, jeg stjeler ikke fra andre, jeg er ikke utro i ekteskapet mitt, ");
INSERT INTO norlb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","jeg faster to ganger i uken, og jeg gir en tiendedel til Gud av alt jeg tjener.’ ");
INSERT INTO norlb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Men tolleren sto på lang avstand og våget ikke en gang å løfte blikket mot himmelen, men slo hendene for brystet i fortvilelse og ropte: ’Gud, tilgi meg, jeg er en synder!’ ");
INSERT INTO norlb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jeg sier dere,” fortsatte Jesus, ”at det var han, og ikke fariseeren, som gikk hjem skyldfri innfor Gud! For den som opphøyer seg selv, skal bli ydmyket, men den som ydmyker seg selv, skal bli opphøyet.” ");
INSERT INTO norlb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Noen foreldre kom bort til Jesus med sine små barn for at han skulle røre ved dem og be for dem. Men disiplene fikk se det og jaget dem bort. ");
INSERT INTO norlb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Da kalte Jesus til seg barna og sa til disiplene: ”Ikke jag dem bort. La barna komme til meg, for alle som vil tilhøre Guds eget folk, må bli som dem. ");
INSERT INTO norlb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ja, jeg forsikrer dere at den som ikke blir som et lite barn, kommer slett ikke til å få tilhøre Guds eget folk.” ");
INSERT INTO norlb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","En betydningsfull mann, medlem i jødenes råd, spurte Jesus: ”Gode mester, hva skal jeg gjøre for å få evig liv?” ");
INSERT INTO norlb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","”Hvorfor kaller du meg god?” spurte Jesus. ”Det finnes bare en som er god, og det er Gud. ");
INSERT INTO norlb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Og budene hans kan du allerede: ’Du skal ikke være utro i ekteskapet. Du skal ikke drepe. Du skal ikke stjele. Du skal ikke lyve eller vitne falskt. Vis respekt for foreldrene dine.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mannen svarte: ”Alle disse budene har jeg holdt helt siden jeg var ung.” ");
INSERT INTO norlb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Da sa Jesus til ham: ”Det er bare en ting til du må gjøre: Selge alt du eier og gi pengene til de fattige. Da skal du få en skatt i himmelen. Kom etterpå og følg meg.” ");
INSERT INTO norlb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Da mannen hørte dette, gikk han bedrøvet bort, for han var svært rik. ");
INSERT INTO norlb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus fulgte ham med øynene da han gikk og sa til disiplene: ”Hvor vanskelig er det ikke for den som har mye penger, å få tilhøre Guds eget folk! ");
INSERT INTO norlb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Det er lettere for en kamel å komme seg gjennom et nåløye enn for en som er rik, til å underordne seg Gud, slik at han får tilhøre Guds eget folk.” ");
INSERT INTO norlb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","De som hørte dette, utbrøt: ”Hvem i all verden kan da bli frelst?” ");
INSERT INTO norlb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus svarte: ”Ingen, menneskelig sett. Men for Gud er alle ting mulig!” ");
INSERT INTO norlb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Da sa Peter: ”Vi har forlatt alt det vi eide, for å følge deg.” ");
INSERT INTO norlb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","”Ja”, svarte Jesus, ”og jeg forsikrer dere at hver og en som forlater hus, kone eller mann, søsken, foreldre og barn for å få tilhøre Guds eget folk, ");
INSERT INTO norlb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","han skal få mangedobbelt igjen allerede her i tiden, og evig liv i den kommende verden.” ");
INSERT INTO norlb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus samlet sine disipler omkring seg og sa: ”Vi er nå på vei til Jerusalem, og der skal alt det som Gud har latt profetene skrive om meg, Menneskesønnen, bli til virkelighet. ");
INSERT INTO norlb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jeg vil bli forrådt og utlevert til de romerske myndighetene og kommer til å bli hånet og mishandlet. De vil spytte på meg, ");
INSERT INTO norlb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","piske meg og til slutt drepe meg. På den tredje dagen skal jeg igjen stå opp fra de døde.” ");
INSERT INTO norlb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Men disiplene fattet ingenting. Den reelle betydningen i det Jesus forutsa, var skjult for dem. Derfor skjønte de ingenting. ");
INSERT INTO norlb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","36","På veien mot Jerusalem nærmet Jesus seg byen Jeriko sammen med mye folk. Det satt en blind mann ved veien og tigget. Mannen hørte folket komme forbi og spurte nysgjerrig om hva som sto på. ");
INSERT INTO norlb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Da han fikk høre at det var Jesus fra Nasaret som kom, ");
INSERT INTO norlb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","begynte han å rope: ”Jesus, du som skal arve kong Davids trone, ha medfølelse med meg!” ");
INSERT INTO norlb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Folket som gikk foran Jesus, forsøkte å få ham til tie stille, men han ropte bare enda høyere: ”Du som skal arve kong Davids trone, ha medfølelse med meg!” ");
INSERT INTO norlb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesus hørte dette og stanset. Han sa til folket at de skulle lede mannen fram til ham. Og han spurte ham: ");
INSERT INTO norlb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","”Hva vil du at jeg skal gjøre for deg?” ”Herre”, ba mannen, ”jeg vil så gjerne se igjen!” ");
INSERT INTO norlb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Da sa Jesus til ham: ”Du skal se igjen! Din tro har helbredet deg.” ");
INSERT INTO norlb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Og straks kunne mannen se! Så fulgte han etter Jesus og hyllet Gud, og alle som så det, æret Gud. ");
INSERT INTO norlb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus kom litt etter inn i Jeriko og gikk gjennom byen. ");
INSERT INTO norlb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Der bodde det en mann som het Sakkeus. Han var sjef for tollerne ved den romerske tollstasjonen, og en svært rik mann. ");
INSERT INTO norlb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakkeus ville gjerne få et glimt av Jesus, men han var for kort til å se over folkemassen. ");
INSERT INTO norlb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Derfor sprang han i forveien og klatret opp i et morbærtre nær veien for å kunne se Jesus bedre. ");
INSERT INTO norlb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Da Jesus etter en stund kom fram til treet, så han opp mot Sakkeus og ropte: ”Sakkeus! Skynd deg ned, i dag vil jeg bli bedt med hjem til deg!” ");
INSERT INTO norlb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Da skyndte Sakkeus seg ned og overlykkelig tok han imot Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dette irriterte folket, og de mumlet forarget: ”Hvorfor skal han gå hjem til en slik ond og uærlig mann?” ");
INSERT INTO norlb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Men Sakkeus sto fram og forklarte for Jesus: ”Herre, jeg skal gi halvdelen av det jeg eier til de fattige. Og om jeg har presset for mye toll av noen, skal jeg betale det tilbake med fire ganger så mye!” ");
INSERT INTO norlb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus sa til ham: ”I dag har frelsen kommet til deg og din familie, og du har blitt et ekte barn av Abraham. ");
INSERT INTO norlb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","For jeg, Menneskesønnen, har kommet for å lete opp og frelse det som var fortapt.” ");
INSERT INTO norlb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","De som sto rundt, lyttet nøye på det Jesus sa. Etter som de nå var ganske nær Jerusalem, passet han på å korrigere misforståelsen som var utbredd i folket, om at han skulle begynne å regjere som konge så snart han kom til Jerusalem. Han fortalte et nytt bilde for dem: ");
INSERT INTO norlb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","”En mann av kongelig slekt ga seg av sted på en lang reise for å bli kronet til konge og etterpå vende tilbake. ");
INSERT INTO norlb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Før han reiste, kalte han til seg ti av tjenerne sine og betrodde hver av dem en sum penger som de skulle forvalte. Han sa: ’Dere skal satse disse pengene på noe som gir meg inntekter. Jeg er snart tilbake.’ ");
INSERT INTO norlb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Men landsmennene hans hatet ham, og i protest sendte de en delegasjon etter ham for å fortelle at de ikke ville ha han til konge. ");
INSERT INTO norlb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Til tross for motstanden ble han noe seinere kronet til konge og kom tilbake til landet sitt. Da kalte han til seg de ti tjenere som han hadde gitt pengene og ville ha greie på hvor mye de hadde tjent på sine forretninger. ");
INSERT INTO norlb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Den første mannen kom og rapporterte om en enorm fortjeneste. ’Herre, de pengene jeg fikk å forvalte, har tidoblet’ seg, sa han. ");
INSERT INTO norlb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","’Bra!’, utbrøt kongen. ’Du er en pålitelig tjener. Du har vist at du kan ta ansvar for lite. Derfor vil du nå få ansvaret over ti byer.’ ");
INSERT INTO norlb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Neste mann kunne også gi rapport om fortjeneste, fem ganger så stor som den opprinnelige summen. ");
INSERT INTO norlb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Da sa herren hans til ham: ’Du skal få ansvar over fem byer.’ ");
INSERT INTO norlb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Men en av tjenerne leverte bare tilbake den summen han hadde fått fra begynnelsen, og forklarte: ’Jeg har oppbevart pengene uten å ta noen risiko, innpakket i et stykke tøy. ");
INSERT INTO norlb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jeg var redd for deg, herre, etter som du er en streng mann som tar ut det som ikke er ditt og som høster det du ikke har sådd.’ ");
INSERT INTO norlb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Da svarte kongen: ’Dine ord avslører deg. Du er en lat tjener! Om du visste at jeg var så streng, og at jeg tenkte å kreve tilbake mer enn du hadde fått, ");
INSERT INTO norlb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","hvorfor satte du ikke da pengene mine i banken, for da hadde jeg i det minste fått rente?’ ");
INSERT INTO norlb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Så vendte han seg til de andre som sto der: ’Ta pengene fra ham og gi dem til den mannen som tidoblet summen han fikk.’ ");
INSERT INTO norlb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","’Men herre’, sa de, ’han har jo allerede nok!’ ");
INSERT INTO norlb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","’Det stemmer’, sa kongen. ’Men jeg forsikrer dere at den som forvalter rett det han har fått, han skal få mer, mens den ansvarsløse skal bli tatt ifra også det lille han har. ");
INSERT INTO norlb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Og fiendene mine, de som ikke ville ha meg til konge, de skal dere føre bort og henrette for meg.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Da Jesus hadde avsluttet denne fortellingen, ledet han reisefølget videre mot Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","De kom nær byene Betfage og Betania ved Oljeberget, og han sendte av sted to av disiplene ");
INSERT INTO norlb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","og sa: ”Gå til byen som ligger rett framfor dere. Vel inne i byen vil dere finne et ungt esel som står bundet, et dyr som ingen har ridd på ennå. Løs eselet og lei det hit. ");
INSERT INTO norlb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dersom noen spør hvorfor dere tar eselet, skal dere bare si: ’Herren har bruk for det.’ ” ");
INSERT INTO norlb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","De to disiplene gikk da av sted og fant eselet stå på plassen akkurat som Jesus hadde sagt. ");
INSERT INTO norlb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Da de holdt på å løse det, kom eierne og spurte: ”Hva gjør dere? Hvorfor tar dere eselet?” ");
INSERT INTO norlb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","De svarte: ”Herren har bruk for det.” ");
INSERT INTO norlb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","De tok eselet og førte det til Jesus. Kappene sine la de på ryggen til eselet og hjalp Jesus opp. ");
INSERT INTO norlb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Da han kom ridende, bredde folket ut kappene sine som en løper foran ham. ");
INSERT INTO norlb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","De nærmet seg det stedet der skråningen ned fra Oljeberget begynner, satte alle i gang med å rope, synge og hylle Gud for alle de uforklarlige miraklene Jesus hadde gjort. ");
INSERT INTO norlb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","”Leve kongen! Vi ærer deg som er sendt av Herren!”, jublet de. ”Gud har sluttet fred med oss! Ære til Gud i det høye!” ");
INSERT INTO norlb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Men noen fariseere i folkemassen sa til ham: ”Mester, si til disiplene dine at de ikke skal rope på denne måten.” ");
INSERT INTO norlb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Da svarte han: ”Jeg forsikrer dere at dersom disse tier, vil steinene rope i stedet!” ");
INSERT INTO norlb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Da de kom nærmere Jerusalem, og byens skjønnhet strålte fram rett foran ham, brast Jesus i gråt. ");
INSERT INTO norlb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","”Tenk om du i dag hadde forstått hvordan du kunne få fred”, sa han. ”Men nå er det for seint, freden er utenfor rekkevidde. ");
INSERT INTO norlb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Det skal komme en tid da fiendene dine beleirer deg, omringer deg og angriper deg fra alle hold. ");
INSERT INTO norlb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","De skal jevne deg med jorden, og innbyggerne blir drept. Ja, det skal ikke bli stein tilbake på stein, fordi du ikke tok imot den anledningen som Gud ga deg.” ");
INSERT INTO norlb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Inne i byen gikk Jesus opp på tempelplassen og drev bort kjøpmennene som holdt til der. ");
INSERT INTO norlb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Han ropte til dem: ”Gud har sagt i Skriften: ’Mitt hus skal være et sted der folket kan be.’ Men dere har gjort det til ’et oppholdssted for tyver og kjeltringer’.” ");
INSERT INTO norlb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Etter dette underviste han hver dag på tempelplassen. Øversteprestene, de skriftlærde og alle folkets ledere forsøkte å finne en måte å rydde ham av veien på. ");
INSERT INTO norlb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","De visste ikke hvordan de skulle gå fram, for han var avholdt av hele folket, og alle ville høre på ham. ");
INSERT INTO norlb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","En dag da Jesus underviste folket på tempelplassen og talte til dem om det glade budskapet fra Gud, kom øversteprestene, de skriftlærde og folkets ledere bort til ham. ");
INSERT INTO norlb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","De forlangte å få vite hvilken rett han hadde til å gjøre alt det han gjorde, og hvem som hadde gitt ham dette oppdraget. ");
INSERT INTO norlb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","”Det skal jeg snart si dere”, sa Jesus, ”dersom bare dere først svarer meg på et annet spørsmål. ");
INSERT INTO norlb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hva mener dere om dette: Var døperen Johannes sin dåp fra Gud eller ikke?” ");
INSERT INTO norlb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","De begynte straks å diskutere med hverandre og sa: ”Dersom vi sier at det var på Guds befaling, da kommer han til å spørre hvorfor vi ikke trodde på ham. ");
INSERT INTO norlb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Men om vi sier at Gud ikke hadde sendt ham, da kommer folket til å steine oss. De er jo helt overbevist om at Johannes var en profet som bar fram Guds budskap.” ");
INSERT INTO norlb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Derfor svarte de til slutt: ”Vi vet ikke.” ");
INSERT INTO norlb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Da sa Jesus: ”I så tilfelle sier heller ikke jeg hvem som har gitt meg i oppdrag å gjøre det jeg gjør.” ");
INSERT INTO norlb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesus vendte seg til folket og fortalte et bilde for dem. Han sa: ”En mann plantet en vingård og forpaktet den ut til noen som dyrket druer mens han selv reiste til utlandet og var borte i mange år. ");
INSERT INTO norlb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Da tiden for å høste var inne, sendte han en av tjenerne sine til forpakterne for å hente den delen av avlingen som var hans. Men de overfalt tjeneren og sendte ham tomhendt tilbake. ");
INSERT INTO norlb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Eieren sendte da en annen tjener, det samme gjentok seg med ham. Han ble mishandlet, forulempet og ble sendt bort uten å ha fått noe. ");
INSERT INTO norlb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Også en tredje tjener ble sendt, men også ham skamslo de og jaget bort. ");
INSERT INTO norlb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Hva skal jeg gjøre?’ sa eieren. ’Jo, nå vet jeg det! Jeg sender min egen elskede sønn. Han må de vel ha respekt for.’ ");
INSERT INTO norlb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Men da forpakterne fikk se sønnen, sa de til hverandre: ’Her kommer han som skal arve hele vingården. Kom så dreper vi ham og legger selv beslag på den!’ ");
INSERT INTO norlb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","De dro sønnen ut av vingården og drepte ham.” ”Hva tror dere eieren gjør med disse forpakterne?” spurte Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","”Jo, han vil selv komme dit, og da henretter han de kriminelle bøllene og gir vingården til andre.” Da folket hørte dette, protesterte de høylytt: ”Nei! Det kommer aldri til å skje!” ");
INSERT INTO norlb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Men Jesus møtte blikket deres og sa: ”Hva betyr det som står i Skriften: ’Den steinen som ikke var brukbar for bygningsmennene, den har blitt til selve hjørnesteinen.’ ");
INSERT INTO norlb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Den som snubler på denne steinen, blir skadet, og den som denne steinen faller på, blir fullstendig knust.” ");
INSERT INTO norlb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Øversteprestene og de skriftlærde ville arrestere Jesus direkte, etter som de forsto at det var dem han siktet til i sin fortelling, men de var redde for folket. ");
INSERT INTO norlb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mens myndighetene holdt Jesus under oppsikt og ventet på sin anledning, sendte de noen menn som skulle late som om de var nøye med å følge Guds vilje, men i virkeligheten var de ute etter å ta Jesus for noe de kunne arrestere ham for. De ville etterpå overgi ham til de romerske myndighetene. ");
INSERT INTO norlb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","”Mester”, sa de til ham. ”Vi vet hvor ærlig du er når du underviser. Du gir ikke etter for det andre mener og tenker, men sier rett ut det som er Guds vilje. ");
INSERT INTO norlb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Fortell oss nå om det er rett eller galt å betale skatt til den romerske keiseren?” ");
INSERT INTO norlb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesus gjennomskuet den listige falskheten deres og sa: ");
INSERT INTO norlb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","”Vis meg en romersk mynt. Hvem sitt bilde er det på den, og hvem sin signatur står under?” ”Keiseren”, svarte de. ");
INSERT INTO norlb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","”Da så”, sa han, ”gi keiseren det som er hans. Men det som tilhører Gud, det skal dere gi til Gud.” ");
INSERT INTO norlb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","De klarte altså ikke å sette ham fast for noe av det han sa mens folket hørte på. Tvert imot var de så overrasket over svarene hans, at de ble helt tause. ");
INSERT INTO norlb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Noen saddukeere oppsøkte ham. Det er de som påstår at de døde ikke skal stå opp igjen, og derfor spurte de: ");
INSERT INTO norlb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","”Mester, i Moseloven står det at om en mann dør barnløs, da skal broren hans gifte seg med enken og passe på at den døde får en sønn som kan gi ham etterkommere. ");
INSERT INTO norlb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nå var det en familie med sju brødre. Den eldste giftet seg og døde barnløs. ");
INSERT INTO norlb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Da giftet bror nummer to seg med enken, men heller ikke han fikk noen barn. ");
INSERT INTO norlb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","På samme måten gikk det med den tredje, og så fortsatte det til alle sju hadde vært gift med henne og var døde uten å etterlate seg noen barn. ");
INSERT INTO norlb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Til slutt døde også kvinnen. ");
INSERT INTO norlb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hva skal skje med henne når de døde står opp igjen? Hvem sin kone blir hun da? Alle sju har jo vært gift med henne!” ");
INSERT INTO norlb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Jesus svarte saddukeerne: ”Det er bare her på jorden at menn og kvinner gifter seg. De som er verdige til å være med i den kommende verden, etter at de har stått opp fra de døde, kommer ikke til å gifte seg. ");
INSERT INTO norlb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","De skal heller ikke dø, men blir som englene. De er Guds barn, for de har stått opp fra de døde til et nytt liv. ");
INSERT INTO norlb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","At de døde står opp beviser Moses når han forteller om hvordan Gud viste seg for ham i den brennende tornebusken. Han kaller Gud for Abrahams, Isaks og Jakobs Gud. ");
INSERT INTO norlb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gud er altså ikke en gud for døde, men for levende. Alle mennesker er levende for ham.” ");
INSERT INTO norlb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","”Det var bra svart, Mester”, sa noen av de skriftlærde som sto der. ");
INSERT INTO norlb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Og nå våget ingen å stille flere spørsmål til ham. ");
INSERT INTO norlb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus spurte: ”Hvordan kan dere påstå at Messias, den lovede kongen, er etterkommer av kong David? ");
INSERT INTO norlb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David selv skrev jo i Salmenes bok: ’Gud sa til min Herre: Kom og sitt på min høyre side for å regjere, ");
INSERT INTO norlb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","til jeg har lagt dine fiender som en skammel under føttene dine.’ ");
INSERT INTO norlb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mener dere virkelig at David ville kalle en av sine etterkommere for Herre?” ");
INSERT INTO norlb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mens folket lyttet, vendte Jesus seg mot disiplene og sa: ");
INSERT INTO norlb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","”Ta dere i vare for de skriftlærde, som elsker å gå omkring i lange kapper og gjerne vil bli hilst med respekt på torget. Ved gudstjenestene tar de plassene på fremste rekke, og de elsker å sitte på hedersplassene under festene. ");
INSERT INTO norlb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","I sin griskhet bedrar de hjelpeløse enker og tar alt de eier, mens de later som om de lever etter Guds vilje ved å be lange bønner når andre kan høre på. Derfor kommer Gud til å straffe dem desto hardere.” ");
INSERT INTO norlb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mens Jesus sto i templet, så han de rike som la gavene sine i offerkisten. ");
INSERT INTO norlb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Da kom det en fattig enke fram og la ned to koppermynter. ");
INSERT INTO norlb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Da sa han: ”Tro meg, denne fattige enken ga mer enn alle de andre. ");
INSERT INTO norlb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","De tok bare litt av sin overflod og la i offerkisten. Hun derimot, som er så fattig, la alt det hun hadde å leve av i kisten.” ");
INSERT INTO norlb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Noen av disiplene begynte nå å snakke om templet med alle sine vakre steiner og kostbare gaver som folket hadde gitt. ");
INSERT INTO norlb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jesus sa: ”Det drøyer ikke lenge før alt det dere her ser, skal bli jevnet med jorden, stein skal ikke bli tilbake på stein.” ");
INSERT INTO norlb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","”Mester, når skal dette skje?” spurte de forskrekket. ”Hva blir tegnet som viser at det begynner å skje?” ");
INSERT INTO norlb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Han svarte: ”Vær på vakt så ingen lurer dere! Mange vil komme i mitt navn og påstå at de er Messias, den lovede kongen. De vil si: ’Slutten er nær.’ Ikke tro på det de sier! ");
INSERT INTO norlb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Og når dere får høre om krig og uroligheter, skal dere ikke bli grepet av panikk. Det må først bli krig, det betyr ikke at slutten er kommet. ");
INSERT INTO norlb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Folk og land vil reise seg mot hverandre. ");
INSERT INTO norlb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Det blir kraftige jordskjelv, epidemier og sultekatastrofer på det ene stedet etter det andre. Fryktelige ting skal skje, og store tegn vil vise seg på himmelen. ");
INSERT INTO norlb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Men før alt dette skjer, vil myndighetene ta dere til fange og forfølge dere. Dere vil bli stilt for domstolene i synagogene og kastet i fengsel. Dere vil bli stilt fram for makthavere og konger fordi dere tilhører meg. ");
INSERT INTO norlb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dette gir dere samtidig en sjanse til å fortelle om den troen dere har fått. ");
INSERT INTO norlb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Planlegg derfor ikke i forveien hva dere skal si når de anklager dere. ");
INSERT INTO norlb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jeg skal gi dere de rette ordene, ja, dere skal få visdom og klarsyn, slik at ingen av motstanderne kan svare tilbake. ");
INSERT INTO norlb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Dere vil til og med bli angitt av dem som står dere nærmest, av foreldrene, søsken, slektninger og venner, og noen av dere kommer til å bli drept. ");
INSERT INTO norlb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Alle vil hate dere fordi dere tilhører meg. ");
INSERT INTO norlb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Men Gud skal beskyttet dere. Ikke et hårstrå på hodet skal gå tapt. ");
INSERT INTO norlb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Stå fast og hold ut, så skal dere vinne det evige livet. ");
INSERT INTO norlb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Den dagen dere ser Jerusalem omringet av armeer, da vet dere at ødeleggelsen av byen er nær. ");
INSERT INTO norlb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Da må de som er i Judea, rømme opp i fjellene. De som er i Jerusalem, må forlate byen så fort som mulig, og ingen som er utenfor byen, må gå inn i den. ");
INSERT INTO norlb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Da har tiden kommet for Guds dom. Alt det som Gud har forutsagt i Skriften vil bli virkelighet. ");
INSERT INTO norlb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Stakkers de kvinnene som er gravide når denne tiden kommer, og stakkars de mødrene som ammer barna sine! Det vil bli stor nød i landet, og Guds sinne vil ramme folket. ");
INSERT INTO norlb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mange vil bli brutalt drept, og resten vil bli ført bort som fanger til all verdens land. Jerusalem skal bli okkupert av fremmede folk, som vil ha kontroll over byen til Gud gjør slutt på deres regjeringstid. ");
INSERT INTO norlb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Merkelige tegn vil vise seg i solen, månen og stjernene. På jorden vil folkene bli grepet av angst og uro når hav og flodbølger drønner. ");
INSERT INTO norlb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Menneskene vil gå under av redsel og skrekk for det som vil ramme verden, for universets krefter vil bli rokket. ");
INSERT INTO norlb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Da skal de få se meg, Menneskesønnen, komme på skyene med makt og stor herlighet. ");
INSERT INTO norlb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Men når dere ser alt dette skje, da rett dere opp og fatt mot, for da er befrielsen nær.” ");
INSERT INTO norlb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus fortsatte å forklare det han mente ved å bruke et nytt bilde. Han sa: ”Legg merke til fikentreet, eller hvilken som helst annen sort tre. ");
INSERT INTO norlb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Når bladene begynner å springe ut, vet dere at sommeren snart er her. ");
INSERT INTO norlb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","På samme måten kan dere vite at Guds nye verden snart er her, når dere ser tegnene skje. ");
INSERT INTO norlb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Jeg forsikrer dere at denne slekten skal ikke gå under før alt dette skjer. ");
INSERT INTO norlb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Himmelen og jorden skal forsvinne, men mine ord skal gjelde for evig tid. ");
INSERT INTO norlb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Vær på vakt, slik at dere ikke blir sløvet av festing og rus, eller blir opptatt med hverdagens bekymringer. I så fall kommer jeg tilbake og vil overraske dere, og dere blir fanget som i en snare. ");
INSERT INTO norlb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Vær alltid beredt. Be om at dere må få kraft til å styre unna de vanskelighetene som venter, slik at dere kan møte meg, Menneskesønnen, uten frykt.” ");
INSERT INTO norlb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","På dagene gikk Jesus til tempelplassen for å undervise, og folkemassene samlet seg allerede tidlig på morgenen for å høre ham. Hver kveld dro fra han byen og gikk ut til Oljeberget og overnattet der. ");
INSERT INTO norlb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nå nærmet påskehøytiden seg. ");
INSERT INTO norlb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Øversteprestene og de skriftlærde søkte fortsatt etter en måte å bli kvitt Jesus på. Men de ville drepe han i all hemmelighet, etter som de var redde for reaksjonen fra folket. ");
INSERT INTO norlb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Da for Satan inn i Judas Iskariot, han som var en av Jesu tolv disipler. ");
INSERT INTO norlb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas gikk til øversteprestene og offiserene ved tempelvakten for å diskutere hvordan han kunne overgi Jesus til dem. ");
INSERT INTO norlb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","De ble svært glade og tilbød ham en sum penger, ");
INSERT INTO norlb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","noe han straks aksepterte. Fra det øyeblikket av søkte han etter en anledning til å forråde Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Så kom den første dagen i påskehøytiden, den dagen da påskelammet skulle bli slaktet. ");
INSERT INTO norlb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus sendte to av disiplene, Peter og Johannes, av sted og sa: ”Gå og gjør i stand påskemåltidet, slik at vi kan spise det sammen.” ");
INSERT INTO norlb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","”Hvor vil du at vi skal ordne det til?” spurte de. ");
INSERT INTO norlb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Han svarte: ”Når dere kommer inn i Jerusalem, vil dere straks støte på en mann som bærer en vannkrukke på hodet. Følg etter ham til det huset der han går inn i. ");
INSERT INTO norlb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Si til mannen som eier huset: ’Vår Mester undrer seg på hvor det rommet er der han kan spise påskemåltidet sammen med disiplene sine.’ ");
INSERT INTO norlb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Da vil mannen ta dere med opp en trapp til et stort rom der det allerede er dekket. Gjør i stand måltidet der.” ");
INSERT INTO norlb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","De gikk av sted og fant at alt var akkurat slik som Jesus hadde sagt, og de ordnet med påskemåltidet. ");
INSERT INTO norlb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Da det seinere var tid for å spise påskemåltidet, slo Jesus og hans tolv disipler seg ned ved bordet. ");
INSERT INTO norlb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Han sa: ”Jeg har lengtet så inderlig etter å få spise dette påskemåltidet med dere før mine lidelser begynner. ");
INSERT INTO norlb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","For jeg sier dere at nå kommer jeg ikke til å spise det før vi skal feire den fullkomne påsken i Guds nye verden.” ");
INSERT INTO norlb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Han tok et beger vin, og da han hadde takket Gud for vinen, sa han: ”Ta dette og del det mellom dere. ");
INSERT INTO norlb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Jeg forsikrer dere at fra og med nå skal jeg ikke drikke vin igjen, før Gud regjerer i sin nye verden.” ");
INSERT INTO norlb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Etter dette tok han et brød, og da han hadde takket Gud for det, brøt han det i biter og ga det til disiplene og sa: ”Dette er kroppen min som skal bli ofret for dere. Dette måltid skal feires til minne om min lidelse og død.” ");
INSERT INTO norlb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Etter måltidet tok han på samme måten begeret med vinen og sa: ”Dette beger er den nye pakten mellom Gud og menneskene, en pakt som blir inngått ved at blodet mitt blir ofret for dere. ");
INSERT INTO norlb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Men her ved bordet finnes en mann som kommer til å forråde meg, og det til tross for at han spiser sammen med meg. ");
INSERT INTO norlb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","For jeg, Menneskesønnen, må dø. Det er en del av Guds plan. Men ulykken vil ramme det mennesket som forråder meg!” ");
INSERT INTO norlb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Da begynte disiplene å spørre hverandre om hvem i all verden som kunne finne på noe slikt. ");
INSERT INTO norlb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Etter en stund gikk disiplene i stedet over til å diskutere hvem av dem som var å anse som den største. ");
INSERT INTO norlb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Da sa Jesus: ”I denne verden opptrer konger og makthavere som tyranner, og vil på toppen av det hele bli hyllet som ’folkets beskytter’! ");
INSERT INTO norlb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Men slik må det ikke være blant dere. Den av dere som vil være den største, skal være minst av alle. Den som vil være leder, skal være de andre sin tjener. ");
INSERT INTO norlb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","I denne verden blir den som spiser ved bordet, regnet som større enn den som tjener ved bordet. Men følg mitt eksempel. Jeg er som en tjener blant dere. ");
INSERT INTO norlb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","Men en dag skal dere som har vært trofaste mot meg i disse fryktelige dagene, få den samme kongelige makten av meg som jeg har fått av min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Da skal dere få spise og drikke ved mitt bord i den nye verden. Dere skal få sitte på troner og dømme Israels tolv stammer. ");
INSERT INTO norlb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, min venn, Satan har krevd å få teste dere for å se om troen er ekte hos dere. ");
INSERT INTO norlb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jeg har bedt for deg at du ikke fullstendig skal miste troen. Når du har angret og vendt om til meg igjen, da skal du styrke troen hos brødrene dine.” ");
INSERT INTO norlb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon Peter svarte: ”Herre, jeg er beredt til både å gå i fengsel og å dø for deg.” ");
INSERT INTO norlb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus sa: ”Peter, jeg sier deg, før hanen rekker å gale i morgen tidlig, kommer du tre ganger til å fornekte at du kjenner meg.” ");
INSERT INTO norlb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus spurte: ”Da jeg sendte dere ut og dere verken hadde penger, bagasje eller ekstra klær med dere, manglet dere da noe?” ”Nei, ingenting”, svarte de. ");
INSERT INTO norlb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","”Men nå”, sa han, ”skal dere ta med dere både penger og bagasje. Dersom dere ikke har noe sverd, da må dere selge klærne og kjøp et. ");
INSERT INTO norlb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","For jeg forsikrer dere at disse ordene i Skriften vil bli virkelighet ved det som skjer med meg: ’Han ble regnet som en forbryter’. Ja, alt som Gud har forutsagt om meg, vil nå bli sluttført.” ");
INSERT INTO norlb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","”Herre”, svarte de, ”vi har to sverd.” ”Det rekker”, sa Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus dro fra byen sammen med disiplene og gikk som vanlig til Oljeberget. ");
INSERT INTO norlb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Der sa han til dem: ”Be til Far i himmelen slik at fristelsene ikke vinner seier over dere.” ");
INSERT INTO norlb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Selv gikk han et lite stykke lenger bort og falt på kne og ba: ");
INSERT INTO norlb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","”Far i himmelen, om det er mulig, da la meg slippe de lidelsene som venter, men la det bli som du vil, ikke som jeg vil.” ");
INSERT INTO norlb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","En engel fra himmelen viste seg og ga ham ny kraft. ");
INSERT INTO norlb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Angsten tiltok, og han ba så intensivt at svetten hans falt tung til jorden som dråper av blod. ");
INSERT INTO norlb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Til slutt reiste han seg og gikk tilbake til disiplene og oppdaget at de hadde sovnet utmattet av sorg. ");
INSERT INTO norlb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Da sa han: ”Hvordan kan dere sove nå! Reis dere og be om at fristelsene ikke må vinne seier over dere.” ");
INSERT INTO norlb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mens Jesus fortsatt, snakket kom en stor flokk menn ledet av Judas, en av de tolv nærmeste disiplene, for å lete etter Jesus. Judas gikk fram til Jesus for å gi ham et velkomstkyss. ");
INSERT INTO norlb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Men Jesus sa: ”Judas, hvordan kan du forråde meg, Menneskesønnen, med et kyss?” ");
INSERT INTO norlb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Da de andre disiplene forsto hva som holdt på å skje, spurte de: ”Herre, skal vi forsvare oss? Vi har jo våre sverd!” ");
INSERT INTO norlb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Og en av dem slo til mot øverstepresten sin tjener og hogg det høyre øret av ham. ");
INSERT INTO norlb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Men Jesus sa: ”Ikke noe mer vold!” Så rørte han ved øret til mannen og leget ham. ");
INSERT INTO norlb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesus vendte seg til øversteprestene, offiserene ved tempelvakten og folkets ledere som hadde kommet dit for å fange ham, og sa: ”Er jeg en så farlig forbryter at dere var tvunget til å bevæpne dere med sverd og køller for å fange meg? ");
INSERT INTO norlb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hvorfor arresterte dere meg ikke på tempelplassen? Dag etter dag var jeg sammen med dere der uten at dere rørte meg. Nå er det tid for dere til å handle, nå har mørkets makter fått fritt spillerom.” ");
INSERT INTO norlb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Da grep de Jesus og førte ham til øverstepresten sitt hus. Peter fulgte med på avstand. ");
INSERT INTO norlb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Inne på gårdsplassen gjorde de opp en ild for å varme seg og satte seg rundt den. Peter slo seg ned midt iblant de andre. ");
INSERT INTO norlb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","En tjenestejente la merke til ham i lysskinnet og begynte å se nærmere på ham. Til slutt sa hun: ”Denne mannen var også sammen med Jesus!” ");
INSERT INTO norlb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peter protesterte og sa: ”Nei, jeg kjenner ikke den mannen.” ");
INSERT INTO norlb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Etter en stund fikk en annen øye på ham og sa: ”Du er jo også en av dem!” ”Nei, det er jeg ikke”, svarte Peter. ");
INSERT INTO norlb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Omtrent en time seinere var det en tredje som påsto: ”Jeg er sikker på at denne fyren er en av disiplene til Jesus, han er jo fra Galilea.” ");
INSERT INTO norlb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Men Peter sa: ”Hva prater du om? Jeg forstår ikke hva du mener.” Akkurat som han sa dette, gol hanen. ");
INSERT INTO norlb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","I samme øyeblikk vendte Herren Jesus seg om og så på Peter. Plutselig kom Peter til å huske hva Herren hadde sagt til ham: ”Før hanen galer i morgen tidlig, skal du fornekte meg tre ganger.” ");
INSERT INTO norlb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Han gikk ut fra gårdsplassen og gråt i dyp fortvilelse. ");
INSERT INTO norlb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Mennene som holdt vakt over Jesus, begynte nå å håne ham. De satte bind for øyne hans, slo ham og sa: ”Vis oss at du er en profet! Avslør ved Guds hjelp hvem som slo deg.” ");
INSERT INTO norlb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","De forulempet ham på det verste. ");
INSERT INTO norlb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tidlig neste morgen samlet Det jødiske rådet seg, det vil si folkets ledere, øversteprestene og de skriftlærde. De hentet Jesus og stilte ham for rådet, ");
INSERT INTO norlb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","og spurte ham: ”Er du Messias, den lovede kongen? Si oss som det er!” Han svarte: ”Dersom jeg sier ja, da vil dere ikke tro meg. ");
INSERT INTO norlb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Og om jeg begynner å spørre dere om noe, da vil dere ikke svare meg. ");
INSERT INTO norlb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Men fra nå av kommer jeg, Menneskesønnen, til å sitte på Guds høyre side og regjere sammen med ham som har all makt.” ");
INSERT INTO norlb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Opprørt skrek alle sammen: ”Påstår du altså at du er Guds sønn?” Jesus svarte: ”Det er dere selv som kaller meg det.” ");
INSERT INTO norlb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Da skrek de igjen: ”Vi trenger så visst ingen flere vitner. Nå har vi hørt ham selv si det.” ");
INSERT INTO norlb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hele Det jødiske rådet brøt opp og førte Jesus til Pilatus, som var den romerske landshøvdingen. ");
INSERT INTO norlb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Der begynte de straks å anklage ham og si: ”Denne mannen leder folket vårt vill. Han påstår at vi ikke skal betale skatt til den romerske keiseren, og han gir seg ut for å være Messias, den lovede kongen.” ");
INSERT INTO norlb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Da spurte Pilatus ham: ”Er du jødenes konge?” Jesus svarte: ”Det er du selv som kaller meg dette.” ");
INSERT INTO norlb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus vendte seg da til øversteprestene og folket og sa: ”Jeg kan ikke finne at denne mannen er skyldig i noen forbrytelse.” ");
INSERT INTO norlb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Men de forsterket anklagen og sa: ”Han egger opp folket til opprør mot staten med den undervisningen han driver over hele landet, fra Galilea og helt hit til Jerusalem.” ");
INSERT INTO norlb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Da Pilatus hørte dette, spurte han: ”Er mannen fra Galilea?” ");
INSERT INTO norlb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Da han fikk greie på at dette stemte, sendte han Jesus til Herodes, kongen over Galilea, som akkurat da befant seg i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes ble svært glad over å få treffe Jesus. Han hadde hørt mye om ham og håpet å få se at han gjorde et mirakel. ");
INSERT INTO norlb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes stilte spørsmål på spørsmål til Jesus, men Jesus svarte ham ikke. ");
INSERT INTO norlb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","I mens sto øversteprestene og de skriftlærde der og fortsatte med sine grove anklager. ");
INSERT INTO norlb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Til slutt begynte Herodes og soldatene hans å håne og gjøre narr av Jesus. De satte på ham en kongelig kappe og sendte ham tilbake til Pilatus. ");
INSERT INTO norlb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Fra den dagen av ble Herodes og Pilatus venner med hverandre. Før hadde de vært fiender. ");
INSERT INTO norlb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nå kalte Pilatus sammen øversteprestene, medlemmene i Det jødiske rådet og folket. ");
INSERT INTO norlb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Han sa: ”Dere har ført denne mannen til meg og anklaget ham for å lede et opprør mot den romerske staten. Jeg har nøye forhørt ham om disse tingene i deres egen nærhet og finner ham ikke skyldig i anklagene dere fører mot ham. ");
INSERT INTO norlb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes har kommet til det samme resultat og har derfor sendt ham tilbake hit. Ingenting som denne mannen har gjort, gir meg noen anledning til å dømme ham til døden. ");
INSERT INTO norlb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Derfor vil jeg bare la ham piske og etterpå slippe ham fri.” ");
INSERT INTO norlb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Da begynte hele folkemassen å skrike: ”Drep han, og slipp i stedet Barabbas fri!” ");
INSERT INTO norlb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas satt i fengsel for mord og for å ha ledet et opprør i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Enda en gang forsøkte Pilatus å diskutere med dem for han ville gjerne slippe Jesus fri. ");
INSERT INTO norlb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Men de ropte uten stans: ”Spikre ham fast på et kors, spikre ham fast på et kors!” ");
INSERT INTO norlb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","For tredje gangen spurte Pilatus: ”Hva ondt har han gjort? Jeg har ikke funnet noen grunn til å dømme ham til døden. Jeg kommer bare til å piske ham og siden la ham gå.” ");
INSERT INTO norlb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Men folket skrek høyt uten å holde opp at Jesus skulle bli spikret fast på et kors. Til slutt fikk ropene deres overtaket, og Pilatus resignerte. ");
INSERT INTO norlb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Han gjorde som folket forlangte og satte Barabbas fri, han som var anklaget for opprør og mord. Men Jesus overlot han til soldatene sine, slik at folket kunne få viljen sin med ham. ");
INSERT INTO norlb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","På veien til stedet der henrettelsen skulle skje, grep soldatene fatt i en mann fra Kyréne som het Simon. Han var på vei til Jerusalem fra landsbygden, og de tvang ham til å ta korset på seg og bære det etter Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","En stor folkemasse fulgte etter Jesus. Blant de andre var mange sørgende og gråtende kvinner. ");
INSERT INTO norlb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus vendte seg til dem og sa: ”Jerusalems døtre! Gråt ikke over meg, men gråt over dere selv og barna deres. ");
INSERT INTO norlb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Det kommer en tid, da de skal si: ’Lykkelige er de barnløse, de kvinnene som aldri har født barn eller diet noen.’ ");
INSERT INTO norlb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Da skal menneskene si til fjellene og høydene: ’Fall over oss og skjul oss.’ ");
INSERT INTO norlb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","For om de gjør på denne måten mot meg som er det grønne treet, hva vil ikke da skje med dere som er det tørre treet?” ");
INSERT INTO norlb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","To forbrytere ble også ført ut for å bli henrettet sammen med Jesus. Da de kom til det stedet som blir kalt ”Hodeskallen”, ble alle tre spikret fast på hvert sitt kors. De hengte Jesus i midten med en forbryter på hver side. ");
INSERT INTO norlb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Han ba med disse ordene: ”Far i himmelen, forlat disse menneskene, for de vet ikke hva de gjør.” Soldatene kastet terning om klærne hans og delte dem mellom seg. ");
INSERT INTO norlb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Folkemassen sto og så på, og medlemmene i Det jødiske rådet flirte av ham og hånte ham. ”Han var litt av en mester til å hjelpe andre”, sa de. ”Nå kan han vel hjelpe seg selv, dersom han da virkelig er Messias, den utvalgte kongen som Gud har lovet å sende.” ");
INSERT INTO norlb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Også soldatene hånte ham. De rakte sur vin til ham for at han kunne drikke ");
INSERT INTO norlb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","og ropte til ham: ”Dersom du nå er jødenes konge, da hjelp deg selv!” ");
INSERT INTO norlb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Det var nemlig satt opp en plakat over Jesus der det sto: ”Dette er jødenes konge”. ");
INSERT INTO norlb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","En av forbryterne som hang ved siden av Jesus, hånte ham også og sa: ”Er det ikke du som er Messias, den lovede kongen? Bevis det nå ved å redde både deg selv og oss!” ");
INSERT INTO norlb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Men den andre forbryteren irettesatte ham og sa: ”Har du ikke respekt for Gud enda du nå skal dø? Vi får det vi fortjener, vi har blitt dømt for våre forbrytelser, men denne mannen har ikke gjort noe galt.” ");
INSERT INTO norlb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Så sa han: ”Jesus, husk på meg den dagen du regjerer i Guds nye verden.” ");
INSERT INTO norlb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus svarte: ”Jeg forsikrer deg at du allerede i dag skal være med meg i paradiset.” ");
INSERT INTO norlb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Klokken var nå rundt tolv på dagen. Da ble det plutselig mørkt i hele landet, helt fram til klokka tre. ");
INSERT INTO norlb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Solen ble fullstendig formørket, og forhenget foran Det aller helligste rommet i templet, revnet i to deler. ");
INSERT INTO norlb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Samtidig ropte Jesus med kraftig stemme: ”Far i himmelen, i dine hender overgir jeg min Ånd”. Med disse ordene sluttet han å puste. ");
INSERT INTO norlb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Den romerske offiseren, som så det som skjedde, hyllet Gud og sa: ”Han må virkelig ha vært en mann som levde etter Guds vilje.” ");
INSERT INTO norlb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Da folket, som hadde samlet for å se på henrettelsen, så det som skjedde, slo de seg for brystet i sorg og forferdelse og gikk hjem. ");
INSERT INTO norlb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Men alle vennene hans, også de kvinnene som hadde fulgt med ham fra Galilea, sto på avstand og så alt sammen. ");
INSERT INTO norlb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Nå var det en mann som het Josef og var medlem i Det jødiske rådet. Han var en god mann som levde etter Guds vilje, ");
INSERT INTO norlb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","og han hadde ikke støttet de andre religiøse lederne sin beslutning og handling. Han var fra byen Arimatea i Judea og ventet med iver på at Gud skulle begynne å regjere blant menneskene. ");
INSERT INTO norlb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Denne Josef gikk til Pilatus og ba om å få ta hånd om kroppen til Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Han tok seinere ned kroppen fra korset og svøpte den i lintøy og la den i en ny, ubrukt grav, som var hogget ut i fjellet. ");
INSERT INTO norlb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Alt dette skjedde seint på fredagen, like før hviledagen skulle begynne. ");
INSERT INTO norlb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kvinnene som hadde fulgt med Jesus fra Galilea, gikk etter Josef og så hvor han la kroppen i graven. ");
INSERT INTO norlb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Senere gikk de hjem og gjorde i stand en salve av urter og oljer for å kunne stelle kroppen til Jesus. Men da solen gikk ned og det ble hviledag, holdt de seg i ro, slik som det er bestemt i Moseloven. ");
INSERT INTO norlb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tidlig på søndag morgenen, mens solen var i ferd med å gå opp, gikk kvinnene til graven med salven de hadde gjort i stand. ");
INSERT INTO norlb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Der fikk de se at steinen som hadde dekket åpningen, var blitt rullet til siden. ");
INSERT INTO norlb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Da de gikk inn i graven, kunne de ikke finne kroppen til Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kvinnene sto helt forvirret og visste ikke hva de skulle tro. Plutselig viste det seg to menn i skinnende hvite klær. ");
INSERT INTO norlb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kvinnene ble forskrekket og bøyde seg med ansiktet mot jorden. Mennene spurte: ”Hvorfor leter dere blant de døde etter han som er levende? ");
INSERT INTO norlb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Han er ikke her. Han er blitt levende igjen. Husker dere ikke det han sa til dere da han ennå var i Galilea? ");
INSERT INTO norlb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","At han, Menneskesønnen, vil bli utlevert til onde mennesker og bli henrettet på et kors, men at han på den tredje dagen skulle stå opp igjen fra de døde?” ");
INSERT INTO norlb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Da husket de på at Jesus hadde sagt dette. ");
INSERT INTO norlb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","De skyndte seg av sted for å fortelle disiplene og alle de andre det som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kvinnene som hadde gått til graven, var Maria Magdalena, Johanna, og Maria, som var mor til Jakob, og flere andre. Alle fortalte den samme fantastiske historien til de elleve som Jesus hadde valgt seg ut til disipler. ");
INSERT INTO norlb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mennene syntes det hørtes ut som tomt snakk og trodde ikke på det. ");
INSERT INTO norlb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peter tok seg likevel det bryet og sprang av sted til graven for å se etter. Da han bøyde seg ned og så inn i gravkammeret, så han ikke noe annet enn lintøyet som lå der. Forundret over det som hadde skjedd, gikk han fra graven. ");
INSERT INTO norlb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Samme dagen var to av disiplene på vei til byen Emmaus, som ligger drøyt en mil fra Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","De gikk og samtalte med hverandre om alt det som hadde skjedd de siste dagene. ");
INSERT INTO norlb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Plutselig, mens de gikk der og snakket, kom Jesus selv og slo følge med dem. ");
INSERT INTO norlb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Selv om de så ham, var det et eller annet som hindret dem fra å kjenne ham igjen. ");
INSERT INTO norlb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","”Hva er det dere går her og diskuterer så ivrig?” undret han. Da stanset de brått opp og så på ham med sorg i blikket. ");
INSERT INTO norlb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","En av mennene, han som het Kleopas, svarte: ”Du må være den eneste som har vært i Jerusalem og ikke har hørt om det som har skjedd der de siste dagene.” ");
INSERT INTO norlb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","”Hva er det som har skjedd?” fortsatte Jesus. ”Dette med Jesus fra Nasaret”, sa de. ”Han var en profet som var helt fantastisk til å gjøre tydelig Guds budskap for alle. Og han gjorde store mirakler ved Guds kraft og var høyt elsket av både Gud og mennesker. ");
INSERT INTO norlb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Men øversteprestene og medlemmene i Det jødiske rådet arresterte ham og utleverte ham til romerne, som dømte ham til døden og spikret ham fast på et kors. ");
INSERT INTO norlb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Vi håpet så inderlig at han skulle være den som kunne sette fri Israel! I dag er det tredje dagen siden alt dette skjedde. ");
INSERT INTO norlb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nå er vi helt i sjokk, for noen av kvinnene i vår gruppe gikk nemlig ut til graven tidlig på morgenen i dag. ");
INSERT INTO norlb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Da de kom tilbake fortalte de at kroppen til Jesus ikke lenger var å finne der. De hadde sett engler som sa at han var levende! ");
INSERT INTO norlb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Noen i gruppen vår løp derfor dit for å se etter, og faktum er at kroppen var borte. Akkurat som kvinnene hadde sagt, men Jesus så de ikke noe til.” ");
INSERT INTO norlb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Da sa Jesus: ”Tenk så lite dere skjønner! Hvor vanskelig dere har for å tro på det som Gud har forutsagt ved profetene sine. ");
INSERT INTO norlb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Har han ikke gjort kjent at Messias, den lovede kongen, måtte gå gjennom disse lidelsene og etterpå bli æret og opphøyd?” ");
INSERT INTO norlb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Så siterte han avsnitt for avsnitt av det som Moses og alle profetene hadde skrevet. Han forklarte hva Gud hadde sagt om Messias i alle bøkene som er samlet i Skriften. ");
INSERT INTO norlb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","På dette tidspunktet var de nesten kommet fram til byen Emmaus, og det så ut som om Jesus hadde tenkt å gå videre. ");
INSERT INTO norlb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","De stoppet ham og ba innstendig: ”Stans over natten hos oss. Det begynner jo allerede å bli mørkt.” Da fulgte Jesus med dem hjem. ");
INSERT INTO norlb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Da de hadde slått seg ned ved bordet for å spise, tok han brødet og takket Gud for maten, brøt brødet i biter og rakte det til de andre. ");
INSERT INTO norlb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Plutselig ble øynene deres åpnet, og de kjente ham igjen. Men i samme øyeblikk var han borte. ");
INSERT INTO norlb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","De sa til hverandre: ”Ja visst, kjente vi det ikke som ild som brant i oss, da han snakket til oss på veien og forklarte Skriften for oss?” ");
INSERT INTO norlb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Uten å miste et sekund skyndte de seg tilbake til Jerusalem der disiplene og de andre som fulgte Jesus, var samlet. ");
INSERT INTO norlb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Disse tok imot mennene med ordene: ”Herren har virkelig stått opp! Han har vist seg for Peter!” ");
INSERT INTO norlb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Da fortalte de to disiplene som kom fra Emmaus, om hvordan Jesus hadde vist seg for dem på veien, og hvordan de hadde kjent ham igjen da han brøt brødet. ");
INSERT INTO norlb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mens de fortsatt holdt på å fortelle, sto Jesus plutselig midt iblant dem og sa: ”Fred være med dere alle.” ");
INSERT INTO norlb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Men de ble fryktelig redde og trodde at det var et spøkelse. ");
INSERT INTO norlb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","”Hvorfor er dere redde?” spurte Jesus. ”Hvorfor tviler dere på at det er jeg? ");
INSERT INTO norlb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Se på hendene mine og føttene mine! Dere kan selv se at det er jeg. Kjenn på meg! Dersom jeg var en Ånd, da ville jeg jo ikke ha noen kropp.” ");
INSERT INTO norlb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mens han snakket, viste han hendene og føttene sine. ");
INSERT INTO norlb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Fortsatt var de tvilende og fylt av en blanding av glede og forbauselse. Da spurte han: ”Har dere noe å spise?” ");
INSERT INTO norlb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","De ga ham en bit stekt fisk. ");
INSERT INTO norlb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Den spiste han mens de så på. ");
INSERT INTO norlb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Han sa til disiplene: ”Kan dere ikke huske at jeg forklarte, mens jeg ennå var hos dere, at alt som Gud hadde forutsagt om meg i Skriften, både i Moseloven, hos profetene og i salmene, måtte bli til virkelighet?” ");
INSERT INTO norlb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Så hjalp han dem til å forstå Skriften. Han sa: ”Dette er det Gud som har forutsagt: ’Messias, den lovede kongen, skal lide og dø. Men på den tredje dagen skal han igjen bli levende. ");
INSERT INTO norlb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Og ved at han tar på seg straffen menneskene hadde fortjent, skal hver og en som angrer syndene sine og tror på ham, få tilgivelse. Dette tilbudet skal bli spredd til alle folk, og har altså sin begynnelse i Jerusalem.’ ");
INSERT INTO norlb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Alt dette skal dere fortelle videre til andre. ");
INSERT INTO norlb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jeg skal sende Guds Ånd til dere, akkurat som min Far i himmelen har lovet. Dere skal bli her i Jerusalem til Ånden er kommet og har fylt dere med kraft fra Gud.” ");
INSERT INTO norlb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Senere tok Jesus med seg disiplene ut av byen og gikk et stykke mot Betania. Der løftet han hendene mot himmelen og ba Gud om å gi dem alt godt. ");
INSERT INTO norlb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mens han ba for alle sine, dro han fra dem og ble tatt opp til himmelen. ");
INSERT INTO norlb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Disiplene falt på kne og tilba ham og vendte så tilbake til Jerusalem fylt av en enorm glede. ");
INSERT INTO norlb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","De var stadig i templet og hyllet Gud.");
INSERT INTO norlb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ved tidenes begynnelse var allerede Ordet. Ordet var hos Gud, og Ordet var Gud. ");
INSERT INTO norlb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Han var hos Gud allerede ved tidenes begynnelse. ");
INSERT INTO norlb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gud lot ham skape alt som finnes til. Det finnes ikke noe som ikke har blitt skapt av ham. ");
INSERT INTO norlb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Alt liv kommer fra ham, og livet hans er lyset for menneskene. ");
INSERT INTO norlb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hans lys skinner i mørket, og mørket kan aldri slokke det. ");
INSERT INTO norlb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gud sendte døperen Johannes ");
INSERT INTO norlb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","for å fortelle om lyset, slik at alle kunne begynne å tro på grunn av budskapet hans. ");
INSERT INTO norlb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Johannes var ikke lyset. Han var bare den som skulle gjøre lyset kjent. ");
INSERT INTO norlb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Det sanne lyset, han som er hele menneskehetens lys, skulle nå komme inn i verden. ");
INSERT INTO norlb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Men til tross for at Gud hadde betrodd ham å skape verden, så kjente ikke verden ham igjen da han kom. ");
INSERT INTO norlb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ikke en gang i hans eget land og blant hans eget folk tok de imot ham. ");
INSERT INTO norlb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Men alle de som tok imot ham, ga han retten til å bli Guds barn. Ja, alle som tror på ham, får den samme retten. ");
INSERT INTO norlb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","De blir født på nytt, men ikke gjennom noen fysisk fødsel som et resultat av menneskelige følelser og handlinger. Nei, de blir født av Gud selv. ");
INSERT INTO norlb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Og Ordet ble menneske og levde blant oss her på jorden. Vi så hans herlighet, den herlighet som den eneste Sønnen har fått fra sin Far i himmelen. Gjennom Sønnen har vi lært å kjenne Far i himmelen og hans kjærlighet og tilgivelse. ");
INSERT INTO norlb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Døperen Johannes talte om Sønnen og ropte til folket: ”Det var ham jeg talte om da jeg sa: ’Han som kommer etter meg, betyr mer enn jeg, for han var til før jeg ble til.’ ” ");
INSERT INTO norlb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ja, han var fylt av kjærlighet og tilgivelse, og gang på gang har vi fått oppleve hans godhet mot oss. ");
INSERT INTO norlb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses ga oss loven. Det er ved Jesus Kristus, den lovede kongen, som vi har lært å kjenne Gud og hans kjærlighet og tilgivelse. ");
INSERT INTO norlb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ingen har noen gang sett Gud, men hans eneste Sønn, som selv er Gud og er nær Far i himmelen, han har vist oss hvem han er. ");
INSERT INTO norlb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","De religiøse lederne sendte prester og tempeltjenere fra Jerusalem for å spørre døperen Johannes om han var Messias, den lovede kongen. Johannes forklarte åpent og ærlig: ”Nei, jeg er ikke Messias.” ");
INSERT INTO norlb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","”Hvem er du da?” spurte de. ”Er du Elia?” ”Nei”, svarte han. ”Er du profeten som skulle komme og holde fram Guds budskap?” ”Nei”, svarte han. ");
INSERT INTO norlb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Da sa de: ”Fortell oss hvem du er! Noe svar må vi kunne gi til dem som har sendt oss. Hva sier du om deg selv?” ");
INSERT INTO norlb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Johannes svarte ved å sitere det Gud har sagt om ham ved profeten Jesaja. Han sa: ”Jeg er en stemme som roper i ørkenen: ’Gjør veien rett for Herren!’ ” ");
INSERT INTO norlb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","De som var blitt sendt ut av fariseerne, ");
INSERT INTO norlb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","spurte ham: ”Hvorfor døper du folk dersom du verken er Messias eller Elia eller den profeten som Gud skulle sende?” ");
INSERT INTO norlb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johannes svarte: ”Jeg døper dere med vann, men midt iblant dere står en som dere ikke kjenner. ");
INSERT INTO norlb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Han er den som kommer etter meg, og han er så mektig at jeg ikke en gang er verdig til å knytte opp remmene på sandalene hans.” ");
INSERT INTO norlb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dette skjedde i Betania, en by på den andre siden av elven Jordan der Johannes døpte. ");
INSERT INTO norlb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Neste dag fikk døperen Johannes se Jesus komme mot seg, og han sa: ”Der er Guds lam, han som tar bort synden hos menneskene. ");
INSERT INTO norlb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Det var om ham jeg talte da jeg sa: ’Etter meg kommer en som betyr mer enn jeg, for han var til før jeg ble til.’ ");
INSERT INTO norlb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jeg visste ikke på forhånd hvem han var, men jeg er kommet for å døpe med vann, slik at Israels folk skal se hvem han er.” ");
INSERT INTO norlb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johannes fortalte: ”Jeg så Guds Ånd komme ned fra himmelen som en due og bli over han. ");
INSERT INTO norlb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jeg visste ikke på forhånd hvem han var, men da Gud sendte meg for å døpe med vann, sa han til meg: ’Når du ser Ånden komme ned og bli over en person, da vet du at han er den som døper med min Hellige Ånd.’ ");
INSERT INTO norlb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jeg så at dette skjedde, og derfor kan jeg vitne om at han er Guds sønn.” ");
INSERT INTO norlb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Dagen etter sto døperen Johannes der igjen med to av disiplene. ");
INSERT INTO norlb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Da Jesus kom gående forbi så Johannes på han og sa: ”Der er Guds lam!” ");
INSERT INTO norlb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","De to disiplene til Johannes hørte dette og begynte å følge etter Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus vendte seg om og så at de fulgte etter ham, og han spurte: ”Er det noe dere vil?” De svarte: ”Rabbi, som betyr mester, hvor bor du?” ");
INSERT INTO norlb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus sa: ”Kom, bli med meg og se.” De gikk med ham til det stedet der han bodde. Klokken var rundt fire på ettermiddagen da de fulgte med, og de ble hos ham til kvelden. ");
INSERT INTO norlb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Den ene av de to som hadde hørt det Johannes sa, og seinere fulgt etter Jesus, var Andreas, Simon Peter sin bror. ");
INSERT INTO norlb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Det første Andreas etterpå gjorde var å lete opp sin bror Simon. Da han fant ham, sa han: ”Vi har funnet Messias, den lovede kongen”. Messias betyr den som er salvet. ");
INSERT INTO norlb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Han tok med seg broren til Jesus. Jesus så på Simon og sa: ”Du er Simon, sønn av Johannes. Du skal få navnet Peter, som betyr klippen.” ");
INSERT INTO norlb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Dagen etterpå tenkte Jesus å gå til Galilea. Da møtte han Filip og sa til han: ”Kom og bli min disippel.” ");
INSERT INTO norlb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip var fra Betsaida, som var Andreas og Peter sin hjemby. ");
INSERT INTO norlb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip gikk for å lete opp Natanael og sa til ham: ”Vi har funnet den mannen som Moseloven og profetene skriver om. Han heter Jesus og er sønn til Josef fra Nasaret.” ");
INSERT INTO norlb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","”Nasaret!” utbrøt Natanael. ”Kan det komme noe godt fra Nasaret?” ”Kom og undersøk selv”, svarte Filip. ");
INSERT INTO norlb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Da Jesus så Natanael nærme seg, sa han: ”Se der, her kommer en ærlig og oppriktig mann, en ekte israelitt.” ");
INSERT INTO norlb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","”Hvordan kan du kjenne meg?” undret Natanael. Jesus svarte: ”Jeg så deg under fikentreet før Filip fant deg.” ");
INSERT INTO norlb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Da utbrøt Natanael: ”Mester, du er Guds sønn, Israels konge!” ");
INSERT INTO norlb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus sa til ham: ”Tror du dette bare fordi jeg sa at jeg så deg under fikentreet? Du kommer til å få større bevis enn som så. ");
INSERT INTO norlb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jeg forsikrer at dere skal få se himmelen åpen og Guds engler stige ned og stige opp over meg, Menneskesønnen.” ");
INSERT INTO norlb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","To dager seinere ble det holdt et bryllup i byen Kana i Galilea. Maria, mor til Jesus, var der. ");
INSERT INTO norlb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus og disiplene var også innbudt. ");
INSERT INTO norlb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Midt under bryllupsfesten tok vinen slutt. Maria gikk da til Jesus og fortalte ham dette. ");
INSERT INTO norlb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","”La meg være i fred, mor”, svarte han. ”Den tiden som Gud har bestemt til å gjøre kjent hvorfor jeg er kommet, er ennå ikke inne.” ");
INSERT INTO norlb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mor hans sa til tjenerne: ”Gjør nøyaktig det han sier til dere.” ");
INSERT INTO norlb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","I huset var det seks store krukker hogget i stein. De ble brukt ved de jødiske seremoniene for renselse og rommet omkring 100 liter hver. ");
INSERT INTO norlb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","8","Jesus sa nå til tjenerne: ”Fyll krukkene med vann”, og da alle seks var helt fulle, sa han: ”Slå opp litt og gi det til verten for bryllupet.” Tjenerne gjorde som han sa. ");
INSERT INTO norlb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Verten smakte på vannet, som nå hadde blitt forandret til vin. Etter som han ikke visste hvor det kom fra, bare tjenerne kjente til det, kalte han på brudgommen og sa: ");
INSERT INTO norlb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","”Dette er en utsøkt vin. Du gjør virkelig ikke som alle andre og venter med den dårlige vinen til gjestene begynner bli påvirket. Du har spart den beste vinen til slutt.” ");
INSERT INTO norlb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gjennom dette miraklet i Kana i Galilea viste Jesus for første gang offentlig sin guddommelige makt, og disiplene ble overbevist om at han var sendt av Gud. ");
INSERT INTO norlb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Etter bryllupet gikk Jesus til Kapernaum sammen med sin mor, sine brødre og disiplene. De stanset der noen dager. ");
INSERT INTO norlb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Da den jødiske påskehøytiden nærmet seg, gikk Jesus til Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","På tempelplassen fikk han se kjøpmennene som solgte okser, sauer og duer, og de som satt og vekslet penger. ");
INSERT INTO norlb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesus surret seg en pisk av tau og drev alle selgerne ut fra tempelplassen sammen med sauene og oksene. Han raste pengestablene til vekslerne og veltet bordene deres, ");
INSERT INTO norlb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Så gikk han bort til mennene som solgte duer og sa: ”Ta med alt dere har dratt inn og forsvinn herfra! Gjør ikke huset til min Far i himmelen om til en markedsplass!” ");
INSERT INTO norlb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Da kom disiplene til å huske at det står i Skriften: ”Omsorgen for ditt hus skal brenne som en ild i meg.” ");
INSERT INTO norlb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","De religiøse lederne sa til Jesus: ”Om Gud virkelig har gitt deg i oppdrag å gjøre dette, da må du bevise det ved å gjøre et mirakel.” ");
INSERT INTO norlb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","”Det skal jeg gjøre”, svarte Jesus. ”Riv ned dette templet, og jeg skal bygg det opp igjen på tre dager.” ");
INSERT INTO norlb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","”Hva!” ropte de. ”Det tok 46 år å bygge dette templet, og du påstår at du kan gjenreise det på tre dager.” ");
INSERT INTO norlb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Men det templet som Jesus snakket om, var hans egen kropp. ");
INSERT INTO norlb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Da han seinere sto opp fra de døde, kom disiplene til å huske på at han hadde sagt dette, og de trodde på det som Gud hadde forutsagt i Skriften og på det budskapet de hadde hørt fra Jesus selv. ");
INSERT INTO norlb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Takket være de miraklene han gjorde i Jerusalem i påskehøytiden, begynte mange å tro at han virkelig var sendt av Gud. ");
INSERT INTO norlb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Jesus stolte ikke på noen, for han kjente så altfor godt til deres innerste tanker. Ingen behøvde å fortelle ham om hvor upålitelige menneskene kan være. ");
INSERT INTO norlb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","En kveld etter mørkets frembrudd kom en mann som het Nikodemus for å snakke med Jesus. Han var fariseer og medlem i Det jødiske rådet. ”Mester”, sa han, ”vi vet at Gud har sendt deg for å undervise oss. Ingen kan gjøre slike mirakler som du gjør dersom Gud ikke er med ham.” ");
INSERT INTO norlb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus svarte: ”Jeg forsikrer deg at den som ikke blir født på nytt, får aldri oppleve hva det betyr å tilhøre Guds eget folk.” ");
INSERT INTO norlb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","”Bli født på nytt!” utbrøt Nikodemus. ”Hva mener du? En voksen person kan vel ikke en gang til komme inn i sin mors mage og bli født på nytt?” ");
INSERT INTO norlb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus svarte: ”Jeg forsikrer deg at den som ikke blir født av vann og Ånd, får slett ikke tilhøre Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mennesker kan føde fram fysisk liv, men Guds Ånd føder fram åndelig liv. ");
INSERT INTO norlb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ikke vær forundret over at jeg sier at menneskene må bli født på nytt. ");
INSERT INTO norlb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Guds Ånd er som vinden. Ingen kan si hvor den kommer fra eller hvor den tar veien, men alle kan høre at den suser, og vi kan se virkningen den gjør. Slik er det også når et menneske blir født av Guds Ånd.” ");
INSERT INTO norlb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","”Men hvordan er dette mulig?” spurte Nikodemus. ");
INSERT INTO norlb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus svarte: ”Du er en jødisk lærer som blir både rost og æret og likevel forstår du ikke dette. ");
INSERT INTO norlb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jeg forsikrer deg at det vi sier, er slikt vi vet og har sett, og likevel tror dere oss ikke. ");
INSERT INTO norlb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Men om dere ikke tror når jeg forteller om de ting som skjer her på jorden, hvordan skal dere da kunne tro når jeg sier noe om det som skjer i himmelen? ");
INSERT INTO norlb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ingen mennesker har vært i himmelen, bortsett fra jeg, Menneskesønnen, som har kommet derfra. ");
INSERT INTO norlb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","På samme måten som Moses hengte opp slangen som var laget av kopper i ørkenen, slik må jeg, Menneskesønnen, bli løftet opp, ");
INSERT INTO norlb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","for at alle som tror på meg, skal få evig liv. ");
INSERT INTO norlb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gud elsket jo menneskene så høyt at han ga sin eneste Sønn, for at alle som tror på ham, ikke skal gå fortapt, men ha evig liv. ");
INSERT INTO norlb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Det var ikke for å dømme noen at Gud sendte sin sønn til verden, men Sønnen kom hit for å frelse hver enkelt. ");
INSERT INTO norlb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Alle som tror på Sønnen, blir ikke dømt. Men de som ikke tror på ham, er allerede dømt, etter som de ikke tror på Guds eneste Sønn. ");
INSERT INTO norlb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Grunnen til at de blir dømt er at da lyset fra himmelen kom ned til jorden, viste det seg at menneskene elsket mørket høyere enn lyset fordi handlingene deres var onde. ");
INSERT INTO norlb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Den som gjør det som er ondt, han hater lyset. Han holder seg borte fra lyset, slik at syndene hans ikke skal bli avslørt. ");
INSERT INTO norlb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Den derimot som gjør det som er rett, han trekkes mot lyset for at alle skal se at han gjør det som Gud vil.” ");
INSERT INTO norlb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jesus reiste fra Jerusalem sammen med disiplene, men de stanset en tid i Judea og døpte der. ");
INSERT INTO norlb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Samtidig døpte også Johannes. Han holdt til ved Ainon, nær Salim. Der var det rikelig med vann. Mange mennesker kom til ham for å bli døpt. ");
INSERT INTO norlb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dette var før Johannes hadde blitt satt i fengsel. ");
INSERT INTO norlb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","En dag kom det en jødisk mann til disiplene av Johannes og begynte å diskutere om forskjellige seremonier for renselse. ");
INSERT INTO norlb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Johannes sine disipler gikk da til han og sa: ”Mester, den mannen som var sammen med deg på den andre siden av elven Jordan, han som du fortalte om til folket, han døper også. Og nå går alle til ham i stedet for å komme til oss.” ");
INSERT INTO norlb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johannes svarte: ”Dersom alle går til ham, er det fordi at Gud lar det skje. ");
INSERT INTO norlb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Dere vet selv at jeg klart og tydelig har sagt til dere at jeg ikke er Messias, den lovede kongen. Jeg er sendt ut for å forberede veien for ham. Det er hele min oppgave. ");
INSERT INTO norlb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Folket blir dratt mot ham på samme måten som bruden blir dratt mot sin brudgom. Brudgommens venn blir glad av å stå og høre stemmen til brudgommen. Jeg er brudgommens venn, og nå er gleden min fullkommen. ");
INSERT INTO norlb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Det er som det skal være at folket hører mer og mer på ham, og mindre og mindre på meg. ");
INSERT INTO norlb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Han har kommet ned fra himmelen og er derfor større enn alle andre. Jeg er født her på jorden, og min forstand er begrenset til det jordiske. ");
INSERT INTO norlb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Han har kommet ned fra himmelen og forteller om det han har sett og hørt, og likevel tror ingen på det han sier. ");
INSERT INTO norlb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Den som tror på det han sier, han erkjenner at Gud taler sannhet. ");
INSERT INTO norlb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Denne mannen, som er sendt av Gud, bringer Guds budskap. Gud har fylt ham med sin Ånd. ");
INSERT INTO norlb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Far i himmelen elsker Sønnen og har gitt ham makt over alle ting. ");
INSERT INTO norlb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Den som tror på Guds, sønn har evig liv. Den som nekter å være lydig mot Sønnen, han mister det evige livet, og blir fortsatt under Guds dom.” ");
INSERT INTO norlb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Fariseerne fikk nå høre at Jesus vant flere disipler enn Johannes og døpte flere, skjønt det var ikke Jesus selv som døpte, men disiplene. Jesus dro derfor fra Judea og reiste tilbake til Galilea. ");
INSERT INTO norlb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","På veien dit ble han tvunget til å reise gjennom Samaria. ");
INSERT INTO norlb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Etter en tid kom han til byen Sykar som ligger nær den jordteigen som Jakob ga sønnen sin Josef. ");
INSERT INTO norlb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Der ligger også Jakobs brønn. Etter som det var mitt på dagen og Jesus var trøtt av den lange reisen, satte han seg ved brønnen. ");
INSERT INTO norlb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Da kom en samaritansk kvinne for å hente vann. Jesus ba henne: ”Gi meg litt å drikke.” ");
INSERT INTO norlb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Han var alene akkurat da, for disiplene hadde gått inn i byen for å kjøpe mat. ");
INSERT INTO norlb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kvinnen ble svært forbauset, for jødene ville ikke ha noe med samaritanene å gjøre. Hun sa: ”Du som er jøde, hvorfor spør du en samaritansk kvinne om vann?” ");
INSERT INTO norlb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus svarte: ”Dersom du visste hvilken fantastisk gave Gud har i bakhånd for deg, og dersom du forsto hvem jeg er, da ville du i stedet ha spurt meg, og jeg ville ha gitt deg levende vann.” ");
INSERT INTO norlb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","”Men, herre, du har jo verken tau eller bøtte”, sa hun, ”og brønnen er dyp. Hvor skal du få levende vann fra? ");
INSERT INTO norlb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Du er vel ikke større enn vår stamfar Jakob som ga oss denne brønnen? Kan du gi meg bedre vann enn det som han, sønnene og husdyrene hans drakk av?” ");
INSERT INTO norlb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus svarte: ”Den som drikker av dette vannet, blir snart tørst igjen. ");
INSERT INTO norlb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Men den som drikker av det vannet jeg gir, blir aldri tørst igjen, for mitt vann blir en uuttømmelig kilde i ham som sprudler fram og gir evig liv.” ");
INSERT INTO norlb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","”Herre”, sa kvinnen. ”Gi meg av det vannet, slik at jeg aldri mer blir tørst og kan slippe å gå ut hit for å hente vann.” ");
INSERT INTO norlb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus sa: ”Gå og hent mannen din.” ");
INSERT INTO norlb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","”Jeg har ingen mann”, svarte kvinnen. ”Du har rett”, sa Jesus. ”Du har levd sammen med fem menn, og den du nå lever med, er ikke din mann. Der holdt du deg til sannheten.” ");
INSERT INTO norlb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","”Herre”, sa kvinnen. ”Du må være en profet, etter som du med Guds hjelp kan avsløre noe slikt. ");
INSERT INTO norlb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Si meg hvorfor dere jøder påstår at Jerusalem er det eneste stedet der vi kan tilbe Gud, mens vi som er samaritaner, sier at vi skal tilbe på dette fjellet der forfedrene våre alltid har tilbedt?” ");
INSERT INTO norlb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Jesus forklarte: ”Tro meg, det kommer en dag da ingen lenger behøver å diskutere om det er på dette fjellet eller i Jerusalem vi skal tilbe vår Far i himmelen. Det er ikke spørsmålet om hvor vi tilber som er det viktigste, heller hvordan vi skal tilbe. Virkelig tilbedelse er ekte og inspirert av Guds Ånd. Det er slik Gud vil at vi skal tilbe ham, etter som Gud er Ånd. Og det kommer en dag, ja, den er allerede her, da menneskene skal tilbe Gud på denne måten. Men dere som er samaritaner, vet lite om ham som dere tilber. Vi jøder derimot kjenner ham godt, for frelsen kommer fra jødene.” ");
INSERT INTO norlb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kvinnen sa: ”Ja, jeg vet at Messias, den lovede kongen, en gang skal komme, og når han kommer, vil han forklare alt for oss.” ");
INSERT INTO norlb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus sa til henne: ”Det er jeg, han som du snakker med.” ");
INSERT INTO norlb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","I samme øyeblikk kom disiplene tilbake. De ble mer enn overrasket da de så at han snakket med en kvinne, men ingen spurte ham hvorfor han snakket med henne eller hva de pratet om. ");
INSERT INTO norlb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kvinnen satte igjen sin vannbøtte ved brønnen og gikk tilbake til byen og sa til alle: ");
INSERT INTO norlb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","”Kom så får dere treffe en mann som var i stand til å si meg alt det jeg har gjort! Jeg undrer meg på om han ikke må være Messias, den lovede kongen.” ");
INSERT INTO norlb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Folket strømmet ut fra byen for å treffe Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Imens ville disiplene gi Jesus noe å spise. ");
INSERT INTO norlb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Men han sa: ”Jeg har mat som dere ikke kjenner til.” ");
INSERT INTO norlb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Disiplene sa da til hverandre: ”Kan noen ha kommet hit og gitt ham mat?” ");
INSERT INTO norlb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Da forklarte Jesus: ”Min mat er å gjøre hans vilje som har sendt meg og å fullføre det oppdraget han har gitt meg. ");
INSERT INTO norlb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Dere sier at kornet ikke er modent før om fire måneder. Men jeg sier: Se dere omkring. Åkrene har allerede lysnet i fargen og er modne for skuronnen. ");
INSERT INTO norlb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","De høstfolkene som fører mennesker til evig liv skal få god lønn. Tenk hvilken glede som venter både den som sår og den som høster! ");
INSERT INTO norlb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","For her gjelder ordspråket: En sår og en annen høster. ");
INSERT INTO norlb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jeg har sendt dere ut for å høste der dere ikke har sådd. Andre har utført arbeidet, og dere skal få lønn for strevet dere har hatt.” ");
INSERT INTO norlb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mange samaritaner fra byen Sykar hadde blitt overbeviste om at Jesus var sendt av Gud da de hørte kvinnen si: ”Han var i stand til å si meg alt det jeg har gjort.” ");
INSERT INTO norlb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Da de kom ut til ham, ba de om at han måtte stanse i byen, og han ble der i to dager. ");
INSERT INTO norlb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Da de fikk høre ordene fra hans egen munn, var det enda flere som begynte å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","De sa til kvinnen: ”Nå er det ikke lenger det du fortalte oss som får oss til å tro. Nei, nå har vi selv hørt ham og forstått at han virkelig er den som skal frelse menneskene.” ");
INSERT INTO norlb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Etter to dager fortsatte Jesus til Galilea. ");
INSERT INTO norlb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Han hadde selv sagt at en profet som bringer Guds budskap blir respektert over alt, bortsett fra på sitt eget hjemsted. ");
INSERT INTO norlb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nå tok galileerne imot ham med åpne armer, etter som de hadde vært i Jerusalem under påskehøytiden og sett alle miraklene hans. ");
INSERT INTO norlb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mens han reiste rundt i Galilea, kom han også tilbake til byen Kana, der han en gang hadde forandret vann til vin. En mann i den kongelige tjenesten hadde på denne tiden en sønn som lå alvorlig syk i byen Kapernaum. ");
INSERT INTO norlb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Da mannen fikk høre at Jesus hadde kommet fra Judea og var i Galilea, gikk han til Kana for å treffe Jesus. Han ba ham om å følge med til Kapernaum for å helbrede gutten hans som lå døende. ");
INSERT INTO norlb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus spurte: ”Kan dere virkelig ikke tro på meg dersom dere ikke til stadighet får se mirakler?” ");
INSERT INTO norlb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Men mannen ba: ”Herre, kom før gutten min dør.” ");
INSERT INTO norlb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Da sa Jesus til han: ”Gå hjem igjen. Sønnen din lever.” Og mannen trodde på det Jesus sa og gikk hjem. ");
INSERT INTO norlb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mens han fortsatt var på veien ble han møtt av tjenerne sine som meldte at gutten levde og var frisk. ");
INSERT INTO norlb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Han spurte ved hvilken tid på dagen gutten hadde begynt bli bedre, og de svarte: ”I går ettermiddag rundt klokka ett forsvant plutselig feberen.” ");
INSERT INTO norlb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Da forsto faren at det hadde skjedd i samme øyeblikk som Jesus hadde sagt til ham: ”Din sønn lever.” Og tjenestemannen og alle i huset hans begynte å tro på Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dette var det andre miraklet Jesus gjorde, og han gjorde det mens han var på vei fra Judea til Galilea. ");
INSERT INTO norlb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Litt seinere gikk Jesus til Jerusalem for å delta i en av de jødiske høytidene. ");
INSERT INTO norlb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Inne i byen, nær Saueporten, var det en dam som på arameisk blir kalt Betesda, og den har fem bueganger. ");
INSERT INTO norlb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mange lamme og blinde og andre som var handikappet lå i disse buegangene og ventet på at vannet skulle komme i bevegelse. ");
INSERT INTO norlb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","En Herrens engel steg nemlig nå og da ned i dammen og rørte opp vannet. Den første som steg ned i dammen etter at vannet var blitt rørt opp, ble frisk, samme hvilken sykdom han enn led av. ");
INSERT INTO norlb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","En av dem som lå der, var en mann som hadde vært lam i 38 år. ");
INSERT INTO norlb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Da Jesus så han og fikk vite at han hadde vært syk så lenge, spurte han mannen: ”Vil du bli frisk?” ");
INSERT INTO norlb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","”Herre, det er nok umulig”, sa mannen. ”Jeg har ingen som kan hjelper meg ned i dammen når vannet kommer i bevegelse. Mens jeg ennå er på vei, rekker noen andre ut i vannet før meg.” ");
INSERT INTO norlb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Da sa Jesus til ham: ”Reis deg opp, ta liggematten din og gå!” ");
INSERT INTO norlb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Straks ble mannen frisk, og han rullet sammen liggematten og gikk av sted. Dette skjedde på hviledagen. ");
INSERT INTO norlb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Derfor protesterte de religiøse lederne. De sa til mannen som var blitt helbredet: ”Du får ikke lov til å arbeide på hviledagen. Det er forbudt å bære liggematten din!” ");
INSERT INTO norlb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mannen svarte: ”Han som gjorde meg frisk sa til meg at jeg skulle ta liggematten og gå.” ");
INSERT INTO norlb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Da spurte de: ”Hvem sa til deg at du skulle bære liggematten?” ");
INSERT INTO norlb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Men han visste det ikke, for Jesus hadde forsvunnet fra stedet etter som det samlet seg mye folk. ");
INSERT INTO norlb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Senere møtte Jesus mannen i templet og sa til ham: ”Nå er du frisk. Ikke synd mer, for at det ikke skal hende deg noe verre.” ");
INSERT INTO norlb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mannen gikk til de religiøse lederne og fortalte at det var Jesus som hadde gjort ham frisk. ");
INSERT INTO norlb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Fra og med nå begynte de religiøse lederne å forfølge Jesus. De mente han hadde arbeidet på hviledagen$1 ved å helbrede en syk mann. ");
INSERT INTO norlb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus sa: ”Min Far i himmelen er uavbrutt i arbeid og derfor arbeider også jeg.” ");
INSERT INTO norlb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Da ble de religiøse lederne enda mer ivrige etter å drepe ham. Ikke bare gjorde han ugyldig Guds befaling om å hvile på den sjuende dagen, men i tillegg snakket han om Gud som sin far. Gjennom dette hadde han jo gjort seg lik med Gud. ");
INSERT INTO norlb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus sa: ”Jeg forsikrer dere at Sønnen kan ikke gjøre noe av seg selv. Han gjør bare det som han ser sin Far i himmelen gjøre. Det Far i himmelen gjør, det gjør også Sønnen. ");
INSERT INTO norlb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Far i himmelen elsker Sønnen og viser ham alt det han gjør. Han skal la Sønnen gjøre enda større mirakler, så store at alle blir forbløffet. ");
INSERT INTO norlb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sønnen skal gi evig liv til hvem han vil, på samme måten som Far i himmelen vekker opp døde og gir dem liv. ");
INSERT INTO norlb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Far i himmelen har overlatt retten til å dømme til Sønnen. ");
INSERT INTO norlb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Alle skal ære Sønnen på samme måten som de ærer Far i himmelen. Men om dere nekter å ære Sønnen, da ærer dere heller ikke Far i himmelen som har sendt ham. ");
INSERT INTO norlb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jeg forsikrer dere at den som hører budskapet mitt og tror på ham som har sendt meg, han har evig liv. Han kommer ikke til å bli dømt for syndene sine, men har allerede gått over fra døden til det evige livet. ");
INSERT INTO norlb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ja, jeg forsikrer dere at det kommer en dag, ja den er faktisk allerede her og nå, da de døde skal høre Guds sønns stemme. De som hører den, skal få liv. ");
INSERT INTO norlb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Far i himmelen har liv i seg selv, og han har også gitt Sønnen liv i seg selv. ");
INSERT INTO norlb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Han har gitt meg rett til å dømme alle mennesker, etter som jeg er Menneskesønnen. ");
INSERT INTO norlb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bli ikke forskrekket. Det kommer en dag da alle som ligger i sine graver, skal høre min stemme. ");
INSERT INTO norlb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","De skal stå opp fra de døde. De som har gjort det gode, skal få evig liv, og de som har gjort det onde, skal bli dømt. ");
INSERT INTO norlb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jeg kan ikke gjøre noe av meg selv. Jeg dømmer ikke før jeg har lyttet til min Far i himmelen. Dommen min er rettferdig, etter som jeg ikke dømmer etter min egen vilje, men etter hans vilje som har sendt meg.” ");
INSERT INTO norlb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jesus fortsatte: ”Om jeg sier hvem jeg er, uten at noen bekrefter det jeg sier, da beviser det ingenting. ");
INSERT INTO norlb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Det finnes en som kan vitne om hvem jeg er, og det er døperen Johannes, og jeg kan forsikre at det han sier om meg, er sant. ");
INSERT INTO norlb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Dere sendte selv folk til ham for å høre da han fortalte sannheten om meg. ");
INSERT INTO norlb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jeg har ikke noe behov for å høre det menneskene mener om meg, men jeg forteller dette for at dere skal tro på meg og bli frelst. ");
INSERT INTO norlb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johannes var et skinnende lys som lyste klart en tid, og dere kunne glede dere i hans lys. ");
INSERT INTO norlb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ja, Johannes fortalte hvem jeg er. Men det finnes et enda sterkere bevis på hvem jeg er. Det er undervisningen min og mine mirakler. De inngår i det oppdraget som min Far i himmelen ga meg å fullføre. De beviser at han har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ja, min Far i himmelen har selv fortalt hvem jeg er, men dere har ikke hørt stemmen hans eller sett ansiktet hans. ");
INSERT INTO norlb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Dere har ikke tatt imot budskapet hans, for dere tror ikke på meg, han som min Far i himmelen har sendt. ");
INSERT INTO norlb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Dere studerer i Skriften, etter som dere tror at den gir dere evig liv. Men til tross for at det nettopp er i Skriften Gud forteller hvem jeg er, ");
INSERT INTO norlb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","så nekter dere å komme til meg for å få evig liv. ");
INSERT INTO norlb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Jeg strever ikke etter å bli æret av dere, for jeg vet at dere ikke elsker Gud. ");
INSERT INTO norlb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jeg har blitt sendt hit av min Far i himmelen, og dere nekter å ta imot meg. Men om noen opptrer på egen hånd, da tar dere imot ham. ");
INSERT INTO norlb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Det eneste dere er interessert i, er å bli æret av hverandre. Dere bryr dere ikke om dere blir godkjent av ham som er den eneste sanne. Gud. Synes dere det er noe rart at dere ikke kan tro! ");
INSERT INTO norlb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Det er ikke jeg som en dag skal anklage dere for min Far i himmelen. Nei, det skal Moses gjøre! Dere tror at dere skal bli reddet ved å følge Moseloven. ");
INSERT INTO norlb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Dersom dere virkelig trodde på det Moses har skrevet, da ville dere også tro på meg, for det er meg han har skrevet om. ");
INSERT INTO norlb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Etter som dere ikke tror på det han har skrevet, tror dere heller ikke på det jeg sier.” ");
INSERT INTO norlb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Senere dro Jesus over til den andre siden av Genesaretsjøen, som også blir kalt Tiberiassjøen. ");
INSERT INTO norlb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","En stor folkemasse fulgte etter ham over alt der han gikk, for de hadde sett at Jesus helbredet de syke. ");
INSERT INTO norlb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus gikk nå opp på et fjell og satte seg der med disiplene. ");
INSERT INTO norlb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Det var dagene før påske, som er jødene sin store høytid. ");
INSERT INTO norlb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Da Jesus så seg omkring og merket at mange hadde fulgt etter ham, vendte han seg til Filip og sa: ”Filip, hvor kan vi kjøpe brød slik at alle disse menneskene får noe å spise?” ");
INSERT INTO norlb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Dette sa han for å teste Filip. Selv var han helt klar over hva han ville gjøre. ");
INSERT INTO norlb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip svarte: ”Det ville koste en formue og likevel vil ikke alle bli mette.” ");
INSERT INTO norlb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","En annen av disiplene, Andreas, som var bror til Simon Peter, sa: ");
INSERT INTO norlb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","”Det finnes en gutt her som har fem kornbrød og to fisker, men det forslår lite til så mange.” ");
INSERT INTO norlb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Da sa Jesus: ”Si til alle at de skal sette seg.” Det vokste mye gress der, og alle slo seg ned. Det var omkring 5 000 menn. I tillegg kom kvinner og barn. ");
INSERT INTO norlb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus tok brødene, takket Gud og delte ut til folket. Etterpå ga han alle av fiskene, så mye de ville ha. ");
INSERT INTO norlb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Da alle hadde spist seg mette, sa han til disiplene: ”Nå kan dere samle sammen det som er blitt til overs, slik at ikke noe går til spille.” ");
INSERT INTO norlb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","I utgangspunktet var det fem kornbrød, men etter at de hadde samlet opp restene som var til overs, ble det tolv fulle kurver! ");
INSERT INTO norlb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Da det gikk opp for folket hvilket stort mirakel som hadde skjedd, ropte de: ”Han må være profeten som Gud skulle sende til verden med sitt budskap!” ");
INSERT INTO norlb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Da Jesus forsto at folket tenkte å tvinge ham til å følge med for at de kunne gjøre ham til konge over Israel, trakk han seg unna. Han gikk høyere opp i fjellet og søkte ensomheten der. ");
INSERT INTO norlb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Om kvelden gikk disiplene ned til sjøen og ventet på ham. ");
INSERT INTO norlb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Da det ble helt mørkt og Jesus fortsatt ikke hadde kommet tilbake, steg de i en båt for å dra over til Kapernaum på den andre siden av sjøen. ");
INSERT INTO norlb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Det drøyde ikke lenge før det begynte blåse kraftig. Bølgene gikk høyere og høyere. ");
INSERT INTO norlb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Da de hadde rodd omkring en halv mil, fikk de plutselig se Jesus komme gående på vannet og nærme seg båten! De ble fryktelig redde. ");
INSERT INTO norlb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesus ropte til dem og sa: ”Det er meg, vær ikke redde.” ");
INSERT INTO norlb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Da lot de ham stige inn i båten. I samme øyeblikk var båten framme der de skulle. ");
INSERT INTO norlb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Neste morgen oppdaget folket som var igjen på den andre siden av sjøen, at Jesus ikke var der lenger. De visste at det bare hadde vært en båt der og at Jesus ikke hadde fulgt med i den da disiplene dro fra stedet. ");
INSERT INTO norlb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Snart kom flere mindre båter fra byen Tiberias og la til i nærheten av det stedet der Herren Jesus hadde bedt bordbønnen, og alle hadde spist seg mette. ");
INSERT INTO norlb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Etter som folket så at verken Jesus eller disiplene var der, steg de i båtene og seilte over sjøen til Kapernaum for å lete etter ham. ");
INSERT INTO norlb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Da de fant ham på den andre siden av sjøen, spurte de: ”Mester, når kom du hit?” ");
INSERT INTO norlb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus svarte: ”Jeg skal si som sant er: Dere kommer ikke til meg fordi dere så meg gjøre et mirakel, men fordi jeg ga dere mat så dere ble mette. ");
INSERT INTO norlb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Strev ikke bare etter den daglige maten, men strev heller for å få del i den maten som kan gi dere evig liv. Det er den maten som jeg, Menneskesønnen, kan gi dere. For Gud, Far i himmelen, har sendt meg nettopp i den hensikt.” ");
INSERT INTO norlb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Da spurte de: ”Hva vil Gud at vi skal gjøre?” ");
INSERT INTO norlb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus svarte dem: ”Gud vil at dere skal tro på ham som Gud har sendt til jorden.” ");
INSERT INTO norlb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","De svarte: ”Du må vise oss et tegn dersom du vil at vi skal tro at Gud har sendt deg. Hva kan du gjøre for tegn? ");
INSERT INTO norlb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ta Moses som eksempel, han ga forfedrene våre brød hver dag da de gikk i ørkenen. Det står i Skriften: ’Han ga dem brød fra himmelen.’ ” ");
INSERT INTO norlb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Men Jesus svarte: ”Jeg forsikrer dere at det ikke var Moses som ga folket brødet, men min Far i himmelen. Og nå tilbyr han det sanne brødet fra himmelen til dere. ");
INSERT INTO norlb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Det sanne brødet fra Gud er det som har kommet ned fra himmelen og gir evig liv til menneskene.” ");
INSERT INTO norlb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","”Herre”, sa de, ”gi oss det brødet hver dag!” ");
INSERT INTO norlb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Da svarte Jesus: ”Jeg er det brødet som gir evig liv. Den som kommer til meg, skal aldri mer bli sulten. Og den som tror på meg, skal aldri mer bli tørst. ");
INSERT INTO norlb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Men som jeg allerede har sagt dere, så tror dere ikke på meg til tross for at dere har sett meg. ");
INSERT INTO norlb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Alle de mennesker som min Far i himmelen gir meg, de kommer til meg, og jeg vil aldri vise noen bort. ");
INSERT INTO norlb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jeg har ikke kommet ned fra himmelen for å gjøre min egen vilje, men for å gjøre viljen til ham som har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hans vilje er at jeg ikke skal miste en eneste av dem som han har gitt meg, men at jeg skal vekke dem opp til evig liv på den dagen Gud skal dømme alle mennesker. ");
INSERT INTO norlb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ja, det er min Fars vilje at alle som ser Sønnen og tror på ham, skal ha evig liv. Jeg skal vekke dem opp den dagen Gud skal dømme alle mennesker.” ");
INSERT INTO norlb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Folket irriterte seg over at Jesus hadde sagt: ”Jeg er det brødet som har kommet ned fra himmelen.” ");
INSERT INTO norlb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","De sa: ”Dette er jo bare Jesus, sønnen til Josef. Vi kjenner foreldrene hans. Hvordan kan han da påstå at han har kommet ned fra himmelen?” ");
INSERT INTO norlb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Men Jesus svarte: ”Det har ingen hensikt at dere irriterer dere over dette. ");
INSERT INTO norlb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ingen kan søke meg dersom ikke min Far i himmelen, han som har sendt meg, drar ham til meg. Men den som kommer til meg, vil jeg vekke opp til evig liv den dagen Gud skal dømme alle mennesker. ");
INSERT INTO norlb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Gud lot profeten Jesaja skrive: ’De skal alle bli underviste av Gud.’ Den som hører til min Far i himmelen og lærer av ham han kommer til meg. ");
INSERT INTO norlb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Men ingen har noen gang sett Far i himmelen. Det er bare jeg som har sett ham, etter som jeg har kommet fra Gud. ");
INSERT INTO norlb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jeg forsikrer dere at den som tror på meg, har evig liv! ");
INSERT INTO norlb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jeg er det brød som gir liv. ");
INSERT INTO norlb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Deres forfedre spiste brød i ørkenen, og de døde som alle andre. ");
INSERT INTO norlb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Det brødet som kommer ned fra himmelen, virker slik at den som spiser av det, ikke dør. ");
INSERT INTO norlb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jeg er det levende brødet som har kommet ned fra himmelen. Den som spiser av dette brødet, kommer til å leve i evighet. Brødet jeg skal gi dere, er kroppen min. Jeg gir den for at menneskene skal få evig liv.” ");
INSERT INTO norlb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Folket begynte da å diskutere med hverandre og sa: ”Hvordan skal han kunne gi oss kroppen sin å spise?” ");
INSERT INTO norlb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus sa på nytt: ”Jeg forsikrer dere, om dere ikke spiser av min, Menneskesønnen sin, kropp og drikker av blodet mitt, da kan dere ikke få evig liv. ");
INSERT INTO norlb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Den som spiser av kroppen min og drikker av blodet mitt, har evig liv, og jeg vil vekke ham opp den dagen Gud skal dømme alle mennesker. ");
INSERT INTO norlb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","For kroppen min er den sanne mat, og blodet mitt er den sanne drikke. ");
INSERT INTO norlb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Den som spiser av kroppen min og drikker av blodet mitt, skal leve med meg og jeg med ham. ");
INSERT INTO norlb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Min Far i himmelen har sendt meg, og jeg lever på grunn av hans livgivende kraft. På samme måten skal den som spiser av meg, få del i min livgivende kraft. ");
INSERT INTO norlb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jeg er det brødet som har kommet ned fra himmelen. Det er ikke likt det brødet som forfedrene spiste, for de døde som alle andre. Men den som spiser av meg, det sanne brødet, han skal leve i evighet.” ");
INSERT INTO norlb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Dette sa Jesus da han underviste i synagogen i Kapernaum. ");
INSERT INTO norlb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Til og med mange av disiplene som hørte ham, sa: ”Nå går han for langt! Hvem kan holde ut med å høre at han snakker på denne måten?” ");
INSERT INTO norlb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus visste godt at disiplene irriterte seg på det han hadde sagt. Derfor sa han: ”Får dette dere til å miste troen på meg? ");
INSERT INTO norlb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Hvordan skal dere da reagere når dere får se meg, Menneskesønnen, vende tilbake til himmelen? ");
INSERT INTO norlb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Det er bare Guds Ånd som kan gi evig liv. Ikke noe menneske kan få til noe slikt. Det jeg nylig sa, ble formidlet ved Guds Ånd, derfor gir det dere liv. ");
INSERT INTO norlb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Men det er noen av dere som ikke tror på meg.” Jesus visste fra begynnelsen av hvem som ikke trodde og hvem den personen var som skulle forråde ham. ");
INSERT INTO norlb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Han fortsatte: ”Det var derfor jeg sa at ingen kan komme til meg dersom ikke min Far i himmelen gir det som gave.” ");
INSERT INTO norlb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Da Jesus hadde sagt dette, dro mange disipler seg unna ham og ville ikke lenger ha med ham å gjøre. ");
INSERT INTO norlb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Da vendte Jesus seg til sine tolv nærmeste disipler og spurte: ”Vil også dere forlate meg?” ");
INSERT INTO norlb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter svarte: ”Herre, til hvem skulle vi gå? Bare du har det budskap som gir evig liv, ");
INSERT INTO norlb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","og vi tror og vet at du er Guds hellige tjener.” ");
INSERT INTO norlb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Da sa Jesus: ”Jeg har selv valgt ut dere tolv, og likevel er en av dere en djevel.” ");
INSERT INTO norlb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Den han siktet til, var Judas, sønn til Simon Iskariot, som seinere skulle forråde ham til tross for at han var en av de tolv nærmeste disiplene. ");
INSERT INTO norlb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Etter dette gikk Jesus fra by til by i Galilea. Han ville holde seg borte fra Judea, etter som de religiøse lederne der var ute etter å drepe ham. ");
INSERT INTO norlb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Snart var det tid for løvhyttefesten. ");
INSERT INTO norlb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Brødrene til Jesus oppfordret ham til å gå til Judea og delta i høytiden. De sa: ”Du burde forlate Galilea og gå til Judea, slik at tilhengerne dine får se alle miraklene du gjør. ");
INSERT INTO norlb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Du kommer aldri til å bli berømt dersom du gjemmer deg i en avkrok på denne måten. Dersom du kan gjøre disse merkelige miraklene, da bør du vise det fram for all verden.” ");
INSERT INTO norlb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","For heller ikke brødrene hans trodde på ham. ");
INSERT INTO norlb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus svarte: ”Det rette tidspunktet for å reise er ikke ennå kommet for meg, men dere kan dra når som helst. ");
INSERT INTO norlb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ingen har grunn til å hate dere, men meg hater de på grunn av at jeg stadig minner lederne om deres synd og ondskap. ");
INSERT INTO norlb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gå dere av sted til Jerusalem. Det er ikke rette tiden for meg ennå å gå til denne høytiden, gjentok han.” ");
INSERT INTO norlb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Så ble han alene tilbake i Galilea. ");
INSERT INTO norlb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Da brødrene hadde gitt seg av sted til høytiden i Jerusalem, gikk Jesus etter i hemmelighet. Han unngikk å bli gjenkjent av folk. ");
INSERT INTO norlb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","De religiøse lederne forsøkte å få tak i ham under høytiden og spurte om noen hadde sett han. ");
INSERT INTO norlb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Derfor snakket folket i smug om ham. Noen sa: ”Han er et godt menneske”, mens andre sa: ”Nei, han bedrar folket.” ");
INSERT INTO norlb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ingen hadde mot nok til å snakke åpent om ham. Alle var redde for de religiøse lederne. ");
INSERT INTO norlb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Da halve høytiden allerede var over, gikk Jesus opp til templet og begynte å undervise. ");
INSERT INTO norlb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","De religiøse lederne ble forskrekket da de hørte visdommen hans. De sa: ”Hvordan kan han vite så mye til tross for at han aldri har vært elev hos noen av våre religiøse lærere?” ");
INSERT INTO norlb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Da svarte Jesus: ”Det jeg lærer bort, er ikke mine egne tanker, men Guds, etter som det er han som har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dersom noen virkelig vil gjøre Guds vilje, vil han forstå om læren min er fra Gud eller om det bare er mine egne tanker. ");
INSERT INTO norlb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Den som framfører sine egne tanker, vil ha æren selv, men den som gir æren til den som har sendt ham, er en troverdig person som taler sannhet. ");
INSERT INTO norlb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Dere har fått Moseloven. Hvorfor følger dere ikke da loven? Dere vil jo drepe meg!” ");
INSERT INTO norlb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Folket svarte: ”Du er besatt av en ond Ånd! Det er vel ingen som vil drepe deg.” ");
INSERT INTO norlb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Jesus svarte: ”Jeg gjorde noe som virkelig forskrekket dere, da jeg helbredet en mann på hviledagen. Arbeider dere ikke selv hver gang dere lyder Moseloven i punktet om omskjærelsen? Ut fra det avsnittet omskjærer dere guttene på hviledagen. Moses, eller rettere sagt forfedrene deres, bestemte at omskjærelsen skal bli gjort på den åttende dagen etter fødselen. Dette gjelder også om den åttende dagen faller på en hviledag. Dersom det nå er tillatt å omskjære noen på hviledagen, hvorfor skal da jeg bli dømt for at jeg helbredet noen på hviledagen? ");
INSERT INTO norlb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dere skal ikke dømme etter hvordan saker og ting ser ut på overflaten, men fell en rettferdig dom ut fra en dypere innsikt i saken.” ");
INSERT INTO norlb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Noen blant dem som bodde i Jerusalem, sa til hverandre: ”Er det ikke denne mannen som våre ledere vil drepe? ");
INSERT INTO norlb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Her står han helt åpent fram og underviser, og ingen sier noe til ham. Har kanskje medlemmene i Det jødiske rådet blitt overbevist om at han virkelig er Messias, den lovede kongen? ");
INSERT INTO norlb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Men hvordan skulle han kunne være det? Vi vet jo hvor denne mannen ble født. Når Messias kommer, da skal ingen vite hvor han kommer fra.” ");
INSERT INTO norlb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus ropte med høy røst der han sto og underviste i templet: ”Ja, dere kjenner meg og vet hvor jeg kommer fra. Likevel var det ikke mitt eget påfunn å komme, men jeg kommer på oppdrag av en som er troverdig, en som dere ikke kjenner. ");
INSERT INTO norlb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Men jeg kjenner ham, for jeg kommer fra han, og han har sendt meg.” ");
INSERT INTO norlb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","De religiøse lederne var klare til straks å fange Jesus, men ingen rørte ham. Tidspunktet var ennå ikke kommet som Gud hadde bestemt at han skulle bli tatt til fange. ");
INSERT INTO norlb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mange blant folket begynte å tro på ham og sa: ”Han må være Messias, den lovede kongen! Hvem ellers kan gjøre slike mirakler som han gjør!” ");
INSERT INTO norlb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Da fariseerne fikk vite at folket snakket om Jesus i smug, sendte de øversteprestene og noen menn av tempelvakten ut for å fange ham. ");
INSERT INTO norlb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus talte til folket og sa: ”Jeg kommer bare til å bli hos dere en kort tid. Snart vil jeg vende tilbake til ham som har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dere skal lete etter meg, men ikke finne meg. Der jeg er, dit kan dere ikke komme.” ");
INSERT INTO norlb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","De religiøse lederne ble forskrekket over denne påstanden og sa til hverandre: ”Hvor tenker han å ta veien, etter som vi ikke kan finne han? Vil han rømme landet og begynne å undervise blant jødene som bor i andre land, eller vil han undervise andre folk? ");
INSERT INTO norlb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hva mener han når han sier: ’Dere skal lete etter meg, men ikke finne meg, for der jeg er, dit kan dere ikke komme’?” ");
INSERT INTO norlb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","På den siste dagen, som var høydepunktet under løvhyttefesten, ropte Jesus til folket: ”Dersom noen er tørst, kom da til meg og drikk! ");
INSERT INTO norlb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Gud har lovet i Skriften, at strømmer av levende vann skal flyte fram fra det innerste hos dem som tror på meg.” ");
INSERT INTO norlb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Med levende vann mente han Guds Ånd, som alle de som trodde på ham, skulle få. Ånden hadde ikke kommet ennå, etter som Jesus ikke hadde vendt tilbake til sin herlighet i himmelen. ");
INSERT INTO norlb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Da folket hørte ham si dette, sa noen: ”Han må være profeten som skal holde fram Guds budskap.” ");
INSERT INTO norlb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Andra sa: ”Han er Messias, den lovede kongen.” En tredje gruppe sa: ”Nei, det kan ikke være ham. Messias skal vel ikke komme fra Galilea! ");
INSERT INTO norlb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Har ikke Gud sagt i Skriften at Messias skal tilhøre kong Davids slekt og komme fra Betlehem, byen der David bodde?” ");
INSERT INTO norlb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Folket hadde altså delte meninger om ham. ");
INSERT INTO norlb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Noen ville også arrestere ham, men ingen rørte ham. ");
INSERT INTO norlb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tempelvaktene, som hadde blitt sendt ut for å fange han, vendte nå tilbake til øversteprestene og fariseerne som spurte: ”Hvorfor tok dere ham ikke med hit?” ");
INSERT INTO norlb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Vaktene svarte: ”Vi har aldri hørt noe menneske tale som ham!” ");
INSERT INTO norlb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","”Har dere også blitt villedet?” hånte fariseerne. ");
INSERT INTO norlb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","”Finnes det noen i Det jødiske rådet eller noen av fariseerne som tror at Gud har sendt ham? ");
INSERT INTO norlb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","At folkemassen gjør det, det er så sin sak, for de kjenner ikke loven, og er en forbannet hop.” ");
INSERT INTO norlb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Da protesterte Nikodemus, det medlemmet i Det jødiske rådet som tidligere om natten hadde oppsøkt Jesus. Han sa: ");
INSERT INTO norlb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","”Er det lovlig å dømme et menneske skyldig før det er blitt holdt rettssak?” ");
INSERT INTO norlb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","De svarte: ”Er du også fra Galilea, etter som du forsvarer ham? Les i Skriften så får du se at ingen profet kommer fra Galilea.”  ");
INSERT INTO norlb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Senere gikk alle hjem, hver og en til sitt. ");
INSERT INTO norlb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus gikk ut til Oljeberget. ");
INSERT INTO norlb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tidlig neste morgen var han tilbake i templet, og snart samlet mye folk seg rundt ham. Han satte seg ned for å undervise. ");
INSERT INTO norlb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mens han snakket, kom de skriftlærde og fariseerne slepende med en kvinne som hadde blitt tatt på fersk gjerning da hun var utro mot mannen sin, og de stilte henne opp foran Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","De sa: ”Mester, denne kvinnen ble avslørt mens hun var utro mot mannen sin. ");
INSERT INTO norlb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moseloven sier at hun skal bli steinet. Hva sier du?” ");
INSERT INTO norlb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Det de egentlig var ute etter, var å få ham til å si noe de kunne anklage ham for, men Jesus bøyde seg bare ned og skrev i sanden med fingeren. ");
INSERT INTO norlb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Da de fortsatte med å kreve et svar, så han til slutt opp og sa: ”Dersom dere tenker å steine henne, da vil jeg at den av dere som aldri har syndet, skal kaste den første steinen.” ");
INSERT INTO norlb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Så bøyde han seg på nytt ned og fortsatte å skrive i sanden. ");
INSERT INTO norlb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Da snek de religiøse lederne seg bort en etter en. De eldste forsvant først. Da det hadde gått en stund, var det bare kvinnen som alene sto igjen foran Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus så opp og sa til henne: ”Hvor tok de som anklager deg veien? Var det ingen som dømte deg?” ");
INSERT INTO norlb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","”Nei, Herre”, svarte hun. Da sa Jesus: ”Jeg tenker heller ikke å dømme deg. Gå nå, men synd ikke mer.” ");
INSERT INTO norlb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus talte til folket og sa: ”Jeg er lyset for menneskene. Den som blir min disippel, skal slippe å leve i åndelig mørke, for i ham finnes det lyset som leder til evig liv.” ");
INSERT INTO norlb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseerne sa da: ”Nå taler du igjen om deg selv uten at noen bekrefter det du sier. Slikt språk beviser ingenting!” ");
INSERT INTO norlb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus svarte: ”Selv om ingen bekrefter det jeg sier om meg selv, så snakker jeg sant. For jeg vet hvor jeg kommer fra og hvor jeg går hen. Men dere vet ikke hvor jeg kommer fra og hvor jeg går hen. ");
INSERT INTO norlb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Dere dømmer på menneskelig vis, men jeg dømmer ingen. ");
INSERT INTO norlb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dersom jeg dømmer, da er min dom rettferdig, etter som jeg ikke står alene. Han som har sendt meg, er med meg. ");
INSERT INTO norlb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","I deres egen lov er det skrevet at dersom to vitner bekrefter de samme opplysningene, står de fast som bevis. ");
INSERT INTO norlb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jeg er det ene vitnet, og min Far i himmelen som har sendt meg, er det andre.” ");
INSERT INTO norlb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","”Hvor er far din?” spurte de. Jesus svarte: ”Dere vet ikke hvem jeg er, og derfor vet dere heller ikke hvem min Far i himmelen er. Dersom dere kjente meg, ville dere også kjenne ham.” ");
INSERT INTO norlb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dette sa Jesus da han underviste i templet, mens han oppholdt seg nær plassen der tempelkisten står. Ingen grep ham etter som tidspunktet som Gud hadde bestemt for at han skulle bli tatt til fange, ennå ikke var kommet. ");
INSERT INTO norlb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus sa seinere til de religiøse lederne: ”Jeg går bort, og dere kommer til å lete etter meg, men dere vil dø uten å få tilgivelse for syndene deres. Dit jeg går, kan dere ikke komme.” ");
INSERT INTO norlb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","De religiøse lederne sa: ”Vil han ta sitt eget liv etter som han sier: ’Dit jeg går, kan dere ikke komme’?” ");
INSERT INTO norlb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus sa: ”Dere kommer fra det jordiske, og jeg kommer fra det himmelske. Dere tilhører denne verden, jeg tilhører den ikke. ");
INSERT INTO norlb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Det var derfor jeg sa at dere vil dø uten å få tilgivelse for syndene deres, for dersom dere ikke tror at jeg er den jeg er, da får dere ikke tilgivelse for syndene deres.” ");
INSERT INTO norlb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","”Hvem er du da”, spurte de. Han svarte: ”Jeg er den som jeg alltid har sagt at jeg er. ");
INSERT INTO norlb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jeg har mye å si om dere og mye å dømme dere for, men jeg gjør det ikke. Mitt oppdrag er å fortelle alle mennesker om det jeg har hørt av ham som har sendt meg, og han snakker sant.” ");
INSERT INTO norlb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Fortsatt forsto de ikke at han snakket om sin Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Da sa Jesus: ”Når dere har løftet meg opp, Menneskesønnen, kommer dere til å forstå at jeg er den jeg er og at jeg aldri gjør noe av meg selv, men bare sier det som min Far i himmelen har lært meg. ");
INSERT INTO norlb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Han som har sendt meg, er med meg. Han har ikke latt meg bli alene, for jeg gjør alltid det han vil.” ");
INSERT INTO norlb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Da Jesus sa dette, var det mange som begynte å tro at han var sendt av Gud. ");
INSERT INTO norlb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesus sa til dem av folket som begynte å tro at han var kommet fra Gud: ”Dersom dere virkelig vil bli disiplene mine, må dere leve etter det jeg har lært dere. ");
INSERT INTO norlb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gjør dere det, kommer dere til å lære Gud å kjenne, og han vil sette dere fri.” ");
INSERT INTO norlb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","De sa: ”Vi stammer fra Abraham og har aldri vært slaver under noen. Hvorfor sier du da at Gud skal sette oss fri?” ");
INSERT INTO norlb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus svarte: ”Jeg forsikrer dere at dere er slaver under synden hver eneste en. ");
INSERT INTO norlb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","En slave får ikke bli i familien for alltid, men en som er sønn hører alltid til i familien. ");
INSERT INTO norlb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dersom jeg, Sønnen, får sette dere fri fra slaveriet deres, blir dere virkelig fri. ");
INSERT INTO norlb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jeg vet at dere stammer fra Abraham, men likevel forsøker noen av dere å drepe meg, etter som budskapet mitt ikke har nådd inn i hjertene deres. ");
INSERT INTO norlb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Jeg forteller dere det jeg selv har sett hos min Far i himmelen, men dere følger de rådene dere har fått fra ham som er deres far.” ");
INSERT INTO norlb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","”Vi har Abraham til far”, forklarte de på nytt. ”Nei”, sa Jesus, ”for dersom dere var barn av Abraham, da ville dere gjøre de gjerningene som Abraham gjorde. ");
INSERT INTO norlb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nå forsøker dere i stedet å drepe meg, etter som jeg har fortalt det sanne budskapet som jeg har hørt fra Gud. Det ville aldri Abraham ha gjort. ");
INSERT INTO norlb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nei, dere handler på samme viset som han som er deres virkelige far.” De svarte: ”Vi er ikke født utenfor ekteskap. Vår virkelige far er Gud selv.” ");
INSERT INTO norlb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Men Jesus sa: ”Dersom Gud var far deres, da ville dere elske meg, for jeg har kommet til dere fra Gud. Det var ikke mitt eget påfunn å komme, men Gud har gitt meg oppdraget mitt og har sendt meg hit. ");
INSERT INTO norlb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hvorfor forstår dere ikke det jeg sier? Jo, fordi dere nekter å høre på budskapet mitt. ");
INSERT INTO norlb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dere er barn til djevelen, og dere elsker å gjøre som han vil. Han var en morder fra begynnelsen av og har aldri sagt noe som er sant. Nei, han er tvers i gjennom falsk. Når han lyver, avslører han det som bor i ham, for han har alltid løyet, og han er den som er far til alle løgner. ");
INSERT INTO norlb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jeg sier sannheten, og derfor nekter dere å tro på meg. ");
INSERT INTO norlb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Finnes det noen av dere som kan bevise at jeg har syndet? Hvorfor tror dere ikke på meg, til tross for at jeg sier sannheten? ");
INSERT INTO norlb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Den som har Gud til sin far, tar imot Guds budskap. Når dere nå nekter å ta imot budskapet mitt, da beviser det at dere ikke har Gud til far.” ");
INSERT INTO norlb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Folket som hørte dette, ropte i sinne til Jesus: ”Du er ikke noe annet enn en samaritan som er besatt av en ond Ånd!” ");
INSERT INTO norlb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus svarte: ”Nei, jeg er ikke besatt. Jeg ærer min Far i himmelen, men dere håner meg. ");
INSERT INTO norlb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jeg er ikke ute etter å bli æret, det finnes en som vil ære meg, og det er han som avgjør om jeg har rett eller ikke. ");
INSERT INTO norlb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jeg forsikrer dere at den som lever i tråd med min lære, skal aldri dø!” ");
INSERT INTO norlb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Da sa folket: ”Nå vet vi at du er besatt av en ond Ånd. Til og med Abraham døde, og også profetene som bar fram Guds budskap. Og enda sier du at alle de som lever i tråd med din undervisning, skal ikke dø. ");
INSERT INTO norlb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Du mener altså at du er større enn vår stamfar Abraham? Og større enn profetene, som også døde? Hvem tror du egentlig at du er?” ");
INSERT INTO norlb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Da svarte Jesus: ”Dersom jeg opphøyer og ærer meg selv, da betyr mitt skryt ingenting. Men det er min Far i himmelen som opphøyer og ærer meg, han som dere påstår er deres Gud. ");
INSERT INTO norlb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Likevel kjenner dere ham ikke, men jeg kjenner ham. Dersom jeg sa noe annet, ville jeg være en like stor løgner som dere er. Men det er sant at jeg kjenner ham og alltid er lydig mot ham. ");
INSERT INTO norlb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Deres stamfar Abraham gledet seg til å få se meg komme. Og han fikk se meg og ble glad.” ");
INSERT INTO norlb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Folket sa: ”Du er ikke en gang 50 år, hvordan kan du da ha sett Abraham?” ");
INSERT INTO norlb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus svarte: ”Jeg forsikrer dere at jeg er og var til før Abraham ennå var født!” ");
INSERT INTO norlb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Da tok de opp steiner for å kaste på ham, men Jesus forsvant derfra og dro fra templet. ");
INSERT INTO norlb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mens Jesus gikk langs veien, fikk han se en mann som var født blind. ");
INSERT INTO norlb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Disiplene spurte: ”Mester, hvorfor ble denne mannen født blind? Kommer det av at han selv har syndet, eller av at hans foreldre har syndet?” ");
INSERT INTO norlb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus svarte dem: ”Han er slett ikke straffet på grunn av syndene sine. Men etter som han er født blind, kan Gud helbrede ham og vise sin kraft, ");
INSERT INTO norlb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Derfor må vi skynde oss å gjøre det oppdraget vi har fått fra han som har sendt meg. Snart blir det natt, og da kan ingen arbeide. ");
INSERT INTO norlb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Men så lenge jeg er hos menneskene, er jeg lyset deres.” ");
INSERT INTO norlb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesus spyttet på jorden og gjorde en deig av leire som han strøk på øynene til den blinde mannen. ");
INSERT INTO norlb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jesus sa til mannen: ”Gå og vask deg i Siloadammen”. Siloa betyr sendt ut. Han gikk da av sted og vasket seg. Da han kom tilbake, kunne han se. ");
INSERT INTO norlb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Naboene hans og andre som bare hadde sett han som tigger, spurte hverandre: ”Var det ikke han som før satt og tigget?” ");
INSERT INTO norlb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","”Jo, det er det”, sa noen, mens andre sa: ”Nei, det er ikke ham. Han er bare lik ham.” Tiggeren sa: ”Visst er det jeg.” ");
INSERT INTO norlb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Da spurte de ham: ”Hva har skjedd? Hvordan kan det ha seg at du ser?” ");
INSERT INTO norlb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mannen svarte: ”Han som heter Jesus, gjorde en deig av leire og strøk den på øynene mine. Etterpå sa han at jeg skulle gå til Siloadammen og vaske meg. Da jeg hadde gjort det, kunne jeg se!” ");
INSERT INTO norlb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","De spurte ham: ”Hvor er Jesus nå?” ”Det vet jeg ikke,” svarte mannen. ");
INSERT INTO norlb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Da tok folket med seg mannen som hadde vært blind, til fariseerne. ");
INSERT INTO norlb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Etter som det var på en hviledag Jesus hadde laget deigen og gitt mannen synet, vakte det diskusjon. Da fariseerne spurte hvordan det kunne ha seg at han hadde fått synet, ");
INSERT INTO norlb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","fortalte han historien enn gang til: ”Han strøk en deig av leire på øynene mine, og da jeg vasket meg, kunne jeg se.” ");
INSERT INTO norlb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Noen av fariseerne sa: ”Denne mannen kan ikke være sendt av Gud etter som han arbeider på hviledagen.” Andre sa: ”En synder kan vel ikke gjøre slike mirakler?” Så begynte de å diskutere med hverandre. ");
INSERT INTO norlb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Etter en tid vendte fariseerne seg til mannen som hadde vært blind, og spurte: ”Hva sier du selv om ham? Det var jo du som fikk synet ditt.” Mannen svarte: ”Han må være en profet.” ");
INSERT INTO norlb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mange religiøse ledere tvilte på at mannen som var blitt helbredet, hadde vært blind i det hele tatt. De sendte bud på foreldrene hans ");
INSERT INTO norlb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","og spurte: ”Er dette sønnen deres? Ble han født blind? Dersom det er sant, hvordan kan det da ha seg at han nå ser?” ");
INSERT INTO norlb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Foreldrene svarte: ”Det er sønnen vår, og vi vet at han ble født blind. ");
INSERT INTO norlb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Men hvordan han nå kan se, det vet vi ikke, og heller ikke vet vi hvem som har helbredet ham. Spør ham selv. Han er gammel nok til å svare på spørsmålene dere måtte ha.” ");
INSERT INTO norlb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Dette sa de fordi de fryktet de religiøse lederne. De hadde allerede bestemt at den som bekjente Jesus som Messias, den lovede kongen, skulle bli ekskludert fra Den jødiske menigheten. ");
INSERT INTO norlb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","For andre gangen kalte fariseerne til seg mannen som hadde vært blind, og sa til ham: ”Lov innfor Gud at du sier oss sannheten. Vi vet at denne Jesus er en synder.” ");
INSERT INTO norlb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Han svarte: ”Om han er en synder eller ikke, det vet ikke jeg. Det eneste jeg vet er at jeg som før var blind nå kan se.” ");
INSERT INTO norlb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","De spurte ham enda en gang: ”Hva gjorde han med deg? Hvordan gikk han fram da du fikk synet ditt?” ");
INSERT INTO norlb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mannen svarte: ”Det har jeg jo allerede fortalt. Hvorfor hører dere ikke etter? Vil dere også bli disiplene hans etter som dere ønsker å høre historien en gang til?” ");
INSERT INTO norlb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Da forbannet de ham og sa: ”Det er du som er disippelen hans. Vi er disiplene til Moses. ");
INSERT INTO norlb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Vi vet at Gud har talt til Moses, men hvor i all verden denne fyren kommer fra, det vet ikke vi.” ");
INSERT INTO norlb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","”Dette er underlig”, svarte mannen. ”Han ga meg synet mitt, og enda vet ikke dere hvor han kommer fra. ");
INSERT INTO norlb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Men at Gud ikke hører på syndere, det vet vi. Han hører på dem som tilber ham og gjør hans vilje. ");
INSERT INTO norlb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aldri før har vi hørt snakk om noen som har helbredet en som var født blind. ");
INSERT INTO norlb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Om denne mannen ikke var sendt av Gud, da ville han ikke kunne gjøre noe slikt.” ");
INSERT INTO norlb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","”Du er en synder tvers igjennom!”, ropte de. ”I tillegg forsøker du å undervise oss.” Så ekskluderte de mannen fra menigheten. ");
INSERT INTO norlb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus fikk snart høre at de hadde ekskludert mannen fra Den jødiske menigheten. Da han møtte mannen igjen, spurte han: ”Tror du på Menneskesønnen som Gud skulle sende?” ");
INSERT INTO norlb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mannen svarte: ”Herre, si meg hvem han er, slik at jeg kan tro på ham.” ");
INSERT INTO norlb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus sa: ”Du har sett ham. Det er han som snakker med deg.” ");
INSERT INTO norlb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Da falt mannen ned foran Jesus og sa: ”Jeg tror, Herre.” ");
INSERT INTO norlb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus sa: ”Jeg har kommet til verden for å avsløre syndene hos menneskene. De som innser at de er blinde, skal begynne å se, men de som mener om seg selv at de kan se, de skal bli avslørt som blinde.” ");
INSERT INTO norlb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Noen fariseere som sto der, spurte da: ”Mener du at vi skulle være blinde?” ");
INSERT INTO norlb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus svarte: ”Om dere var blinde, ville dere være uten synd. Men dere påstår nå at dere kan se, og derfor er og blir dere skyldige.” ");
INSERT INTO norlb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus fortsatte: ”Jeg forsikrer dere at den som ikke går inn gjennom porten til saueflokken, men i stedet sniker seg inn en annen vei, han er en tyv og forbryter. ");
INSERT INTO norlb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gjeteren går inn gjennom porten. ");
INSERT INTO norlb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Portvakten åpner porten for ham, og sauene kjenner stemmen hans. Han vet navnet på hver sau og roper på den enkelte og leder alle ut på beite. ");
INSERT INTO norlb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Når han har sluppet ut sauene, går han foran, og de følger etter fordi de kjenner stemmen hans igjen. ");
INSERT INTO norlb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","De ville aldri følge en fremmed, men flykte bort, etter som de ikke kjenner stemmen til den ukjente.” ");
INSERT INTO norlb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","De som hørte Jesus fortelle dette bildet, forsto ikke hva han mente. ");
INSERT INTO norlb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Han forklarte derfor innholdet og sa: ”Jeg forsikrer dere at jeg er porten inn til sauene. ");
INSERT INTO norlb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Alle som har kommet foran meg, er tyver og forbrytere, men sauene lyttet ikke til dem. ");
INSERT INTO norlb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jeg er porten. Den som går inn gjennom meg, han skal bli frelst. Han skal bli en av sauene mine og kan gå inn og ut og finne beite på grønne gressmarker. ");
INSERT INTO norlb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tyven kommer bare for å stjele, slakte og ødelegge. Men jeg har kommet for å gi liv, og liv i overflod. ");
INSERT INTO norlb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jeg er den gode gjeteren. Den gode gjeteren gir livet sitt for sauene. ");
INSERT INTO norlb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Den som bare er innleid som tilfeldig avløser, rømmer sin vei når han ser ulven komme. Han forlater sauene, etter som han ikke er deres virkelige gjeter, og sauene ikke er hans. Så angriper ulven sauene og splitter flokken. ");
INSERT INTO norlb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Den innleide avløseren har ingen omsorg for sauene. ");
INSERT INTO norlb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jeg er den gode gjeteren, og jeg kjenner sauene mine. De kjenner meg ");
INSERT INTO norlb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","på samme måten som min Far i himmelen kjenner meg, og jeg kjenner ham. Jeg gir livet mitt for sauene. ");
INSERT INTO norlb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jeg har også andre sauer, som ikke hører til denne flokken. Også de skal jeg lede, og de skal høre stemmen min. Da skal det bli en saueflokk og en gjeter. ");
INSERT INTO norlb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Min Far i himmelen elsker meg, derfor gir jeg livet mitt for seinere å ta det tilbake. ");
INSERT INTO norlb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ingen kan ta livet mitt fra meg, men jeg gir det frivillig. Jeg har rett til å gi livet mitt når jeg vil, og jeg har makt til å ta det tilbake. Det er det oppdraget jeg har fått av min Far i himmelen.” ");
INSERT INTO norlb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Da han sa dette, begynte folket mer enn noen gang å diskutere med hverandre. ");
INSERT INTO norlb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mange sa: ”Han er besatt av en ond Ånd og fullstendig sinnssyk. Hva tjener det til å høre mer på ham?” ");
INSERT INTO norlb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Andre sa: ”Nei, slik taler ikke den som er besatt av en ond Ånd. Kan en ond Ånd virkelig helbrede dem som er blinde?” ");
INSERT INTO norlb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","På denne tiden startet festen som blir feiret til minne om innvielsen av templet i Jerusalem. Det var vinter. ");
INSERT INTO norlb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus spaserte rundt i den delen av templet som ble kalt Salomos buegang. ");
INSERT INTO norlb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","De religiøse lederne omringet ham og spurte: ”Hvor lenge til vil du holde oss i spenning? Dersom du er Messias, den lovede kongen, da si det åpent ut.” ");
INSERT INTO norlb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus svarte: ”Jeg har allerede snakket om dette med dere, men dere vil ikke tro det jeg sier. De miraklene min Far i himmelen har sendt meg for å gjøre, beviser hvem jeg er. ");
INSERT INTO norlb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dere tror meg ikke, etter som dere ikke hører til saueflokken min. ");
INSERT INTO norlb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mine sauer kjenner stemmen min, og jeg kjenner sauene, og de følger meg. ");
INSERT INTO norlb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jeg gir hver enkelt evig liv, og de skal aldri noen gang gå fortapt. Ingen skal ta dem fra meg. ");
INSERT INTO norlb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Min Far i himmelen har gitt dem til meg. Han har større makt enn noen andre, derfor kan ingen ta dem fra meg. ");
INSERT INTO norlb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jeg og min Far i himmelen er ett.” ");
INSERT INTO norlb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Da tok de religiøse lederne på nytt opp steiner for å kaste på ham. ");
INSERT INTO norlb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus sa: ”Dere har sett mange mirakler som min Far i himmelen har sagt at jeg skal gjøre. For hvilket av disse miraklene tenker dere å steine meg?” ");
INSERT INTO norlb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","De svarte: ”Det er ikke for noen mirakler vi vil steine deg, men fordi du spotter. Du, som er et vanlig menneske, påstår at du er Gud.” ");
INSERT INTO norlb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Da sa Jesus: ”Står det ikke i deres egen lov at Gud sa: ’Jeg sier at dere er guder’? ");
INSERT INTO norlb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Skriften, som ikke kan bli satt ut av kraft, kaller menneskene som fikk ta imot Guds budskap, for guder. ");
INSERT INTO norlb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hvorfor kaller dere det da for spott når jeg sier: ’Jeg er Guds sønn’. Er jeg ikke den som min Far i himmelen har sendt til verden med en unik oppgave? ");
INSERT INTO norlb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Dersom jeg ikke gjør de miraklene som min Far i himmelen vil at jeg skal gjøre, da trenger dere ikke å tro på meg. ");
INSERT INTO norlb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Men dersom jeg gjør miraklene, da må dere i det minste tro på miraklene, selv om dere ikke vil tro på meg. Da vil dere snart bli overbevist om at min Far i himmelen er i meg og jeg i ham.” ");
INSERT INTO norlb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Igjen forsøkte de å fange ham, men han klarte å komme seg unna. ");
INSERT INTO norlb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesus gikk enda en gang av sted til plassen på den andre siden Jordan, der døperen Johannes først hadde døpt. Der oppholdt han seg en stund. ");
INSERT INTO norlb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Det var mange mennesker som kom etter ham. De sa til hverandre: ”Johannes gjorde ingen mirakler, men alt han sa om Jesus var sant.” ");
INSERT INTO norlb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mange begynte å tro at Jesus var sendt av Gud. ");
INSERT INTO norlb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","En mann som het Lasarus, lå syk. Han bodde i Betania sammen med sine søstrer Maria og Marta ");
INSERT INTO norlb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Det var søsteren hans Maria, som hadde salvet Herren Jesus med aromatisk olje og tørket føttene hans med håret sitt. ");
INSERT INTO norlb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","De to søstrene sendte nå et nødrop til Jesus og sa: ”Herre, vennen din Lasarus er syk.” ");
INSERT INTO norlb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Da Jesus hørte dette, sa han: ”Sykdommen hans vil ikke lede til døden, men den skal tvert om vise Guds herlighet, slik at jeg, Guds sønn, blir opphøyd og æret gjennom dette.” ");
INSERT INTO norlb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Til tross for at Jesus var glad i Marta, Maria og Lasarus, ");
INSERT INTO norlb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","drøyde han ytterligere to dager der han var. ");
INSERT INTO norlb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Først da sa han til disiplene: ”La oss gå tilbake til Judea.” ");
INSERT INTO norlb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Disiplene protesterte: ”Mester, for bare noen dager siden forsøkte de religiøse lederne i Judea å steine deg. Vil du virkelig gå dit igjen?” ");
INSERT INTO norlb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus svarte: ”Det er dagslys tolv timer om dagen. De som nytter dagen til reisene sine, snubler ikke, for lyset skinner for alle. ");
INSERT INTO norlb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","De derimot som gjør reisene sine i mørke, de snubler etter som ikke lyset får slippe til.” ");
INSERT INTO norlb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Han sa: ”Vår venn Lasarus sover, men nå vil jeg gå og vekke ham.” ");
INSERT INTO norlb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Disiplene trodde at Jesus snakket om naturlig søvn og sa: ”Så bra! Dersom han sover, blir han snart frisk.” Men Jesus mente at Lasarus var død. ");
INSERT INTO norlb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Derfor sa Jesus rett ut: ”Lasarus er død. ");
INSERT INTO norlb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Og for deres skyld er jeg glad at jeg ikke var der, for døden hans vil hjelpe dere å tro på meg. Nå må vi gå til ham.” ");
INSERT INTO norlb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, som ble kalt Tvillingen, sa da til de andre disiplene: ”Kom, la oss følge med, så kan vi dø sammen med ham.” ");
INSERT INTO norlb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Da Jesus kom fram til Betania, fortalte de til ham at Lasarus allerede hadde ligget fire dager i graven. ");
INSERT INTO norlb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania lå bare noen kilometer fra Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mange menneskene hadde kommet fra hovedstaden for å trøste Marta og Maria i sorgen deres. ");
INSERT INTO norlb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Da Marta nå hørte at Jesus var på vei, gikk hun ut for å møte ham, mens Maria stanset hjemme. ");
INSERT INTO norlb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta sa til Jesus: ”Herre, dersom du hadde vært her, da hadde ikke broren min behøvd å dø. ");
INSERT INTO norlb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Likevel vet jeg at Gud vil gi deg hva du enn ber ham om.” ");
INSERT INTO norlb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus svarte: ”Din bror skal bli levende igjen.” ");
INSERT INTO norlb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta sa: ”Ja, jeg vet at han skal bli levende igjen den dagen alle døde blir vekket opp til et nytt liv og Gud skal dømme menneskene.” ");
INSERT INTO norlb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus sa til henne: ”Jeg er den som vekker opp de døde og som gir dem livet på nytt. Den som tror på meg, skal leve, selv om han dør. ");
INSERT INTO norlb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Han får evig liv fordi han tror på meg, og han skal aldri noen sinne dø. Tror du dette, Marta?” ");
INSERT INTO norlb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","”Ja, Herre”, svarte hun. ”Jeg tror at du er Messias, den lovede kongen og Guds sønn, som skulle komme til verden.” ");
INSERT INTO norlb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hun gikk fra Jesus og dro hjem igjen. Der tok hun Maria til siden og hvisket til henne: ”Jesus er her og vil treffe deg.” ");
INSERT INTO norlb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Da Maria hørte det, reiste hun seg straks opp og gikk ut for å møte ham. ");
INSERT INTO norlb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus hadde stanset utenfor byen på den plassen der Marta hadde møtt ham. ");
INSERT INTO norlb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Da alle som var i huset for å trøste Maria, så at hun skyndte seg ut, trodde de at hun ville gå til graven for å gråte der Lasarus lå. De fulgte etter henne. ");
INSERT INTO norlb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Da Maria kom fram til Jesus, falt hun ned ved føttene hans og sa: ”Herre, dersom du hadde vært her, da hadde ikke broren min behøvd å dø.” ");
INSERT INTO norlb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Da Jesus så hvordan hun gråt og sørget og hvordan de andre som fulgte med henne, også sørget og gråt, ble han heftig opprørt og skalv mens han spurte: ");
INSERT INTO norlb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","”Hvor har dere begravd ham?” De sa: ”Kom og se.” ");
INSERT INTO norlb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus begynte å gråte. ");
INSERT INTO norlb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","De som sto rundt, sa da: ”Se så høyt han elsket ham.” ");
INSERT INTO norlb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Men noen sa: ”Han kunne helbrede en blind, hvorfor kunne han ikke også ha passet på at ikke Lasarus måtte å dø?” ");
INSERT INTO norlb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Enda en gang ble Jesus opprørt. Han gikk til graven, som var en grotte med en stein foran åpningen. ");
INSERT INTO norlb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus sa: ”Rull bort steinen.” Men Marta, søsteren til den døde, protesterte: ”Lukten kommer til å være fryktelig, for han har vært død i fire dager.” ");
INSERT INTO norlb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus sa til henne: ”Sa jeg ikke til deg at dersom du tror på meg, skal du få se Guds herlighet?” ");
INSERT INTO norlb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","De rullet da steinen bort. Jesus så opp mot himmelen og sa: ”Far i himmelen, takk for at du har hørt meg. ");
INSERT INTO norlb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Selv vet jeg at du alltid hører meg, men av hensyn til alle som står her, sier jeg det likevel, slik at de kan tro at du har sendt meg.” ");
INSERT INTO norlb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Han ropte med kraftig stemme: ”Lasarus, kom ut!” ");
INSERT INTO norlb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasarus kom ut inntullet i liksvøpet og med ansiktet dekket av et tørkle. Jesus sa: ”Ta av ham svøpet og la ham gå.” ");
INSERT INTO norlb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mange av dem som var sammen med Maria og hadde sett det Jesus gjorde, begynte nå å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Men noen gikk også til fariseerne og rapporterte det Jesus hadde gjort. ");
INSERT INTO norlb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Da kalte øversteprestene og fariseerne sammen hele Det jødiske rådet for å diskutere situasjonen. De sa: ”Hva skal vi gjøre? Denne mannen gjør jo mange mirakler. ");
INSERT INTO norlb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dersom vi lar ham fortsette, begynner snart hele folket å tro på ham. Da kommer den romerske armeen til å ødelegge templet og utslette folket vårt.” ");
INSERT INTO norlb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","En av dem, Kaifas, som var øversteprest det året, sa da: ”Nå er dere desorientert og dumme! ");
INSERT INTO norlb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Selvfølgelig kan vi ikke la hele folket gå til grunne. Det er bedre for alle at ett menneske dør for at hele folket kan bli reddet.” ");
INSERT INTO norlb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Dette sa ikke Kaifas av seg selv. Nei, etter som han var øversteprest dette året, lot Gud ham forutsi at Jesus skulle dø for hele det jødiske folket, ");
INSERT INTO norlb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ja, ikke bare for det, men også for å samle og forene alle Guds barn som finnes spredt over hele verden. ");
INSERT INTO norlb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Fra den stunden av var de religiøse lederne fast bestemt på å drepe Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Derfor gikk ikke Jesus lenger åpent omkring i Judea, men trakk seg bort til utkanten av ørkenen, til byen Efraim, der han oppholdt seg sammen med disiplene. ");
INSERT INTO norlb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Den jødiske påskehøytiden nærmet seg. Mange tilreisende fra alle distriktene kom til Jerusalem flere dager i forveien for å gå gjennom seremoniene for renselse før påsken begynte. ");
INSERT INTO norlb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","De ville gjerne treffe Jesus, og mens de besøkte templet, spurte de hverandre: ”Hva tror dere? Har han ikke tenkt å komme til påskehøytiden?” ");
INSERT INTO norlb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Øversteprestene og fariseerne hadde gitt befaling om at den som visste hvor Jesus holdt hus, straks måtte melde fra om det. De ville arrestere ham. ");
INSERT INTO norlb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seks dager før påskefeiringen begynte, kom Jesus tilbake til Betania der Lasarus bodde. Lasarus var mannen som Jesus hadde vekket opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Det ble ordnet med et festmåltid til ære for Jesus. Marta serverte, og Lasarus var en av dem som spiste sammen med Jesus ved bordet. ");
INSERT INTO norlb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Da tok Maria en flaske aromatisk, kostbar nardusolje og salvet føttene til Jesus og tørket med håret sitt. Hele huset ble fylt av duften fra oljen. ");
INSERT INTO norlb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iskariot, den av disiplene som seinere skulle forråde Jesus, sa da: ");
INSERT INTO norlb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","”Denne oljen var jo nesten verd like mye som lønnen for et helt år. Hvorfor solgte hun den heller ikke i stedet og ga pengene til de fattige?” ");
INSERT INTO norlb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dette sa han ikke fordi han brydde seg om de fattige, men fordi han var en tyv. Han var kasserer for den felles pengebeholdningen Jesus og disiplene hadde, og han brukte å underslå penger fra den. ");
INSERT INTO norlb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus svarte: ”La henne være i fred! Hun sparte denne oljen slik at den kunne bli brukt som forberedelse for begravelsen min. ");
INSERT INTO norlb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","De fattige vil dere alltid ha iblant dere, men meg kommer dere ikke til å ha iblant dere særlig lenge til.” ");
INSERT INTO norlb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Da folket fikk høre at Jesus var der, kom de for å treffe ham. Noen kom også for å se Lasarus, mannen som han hadde vekt opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Øversteprestene bestemte seg da for å drepe Lasarus også, ");
INSERT INTO norlb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","etter som flere og flere jøder tok avstand fra lederne og i stedet begynte å tro på Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Neste dag spredde nyheten seg over hele Jerusalem om at Jesus var på vei inn i byen. En stor folkemasse som var kommet for å feire påske, ");
INSERT INTO norlb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tok palmegrener og gikk ut på veien for å møte ham. De ropte: outing, ”Vi hyller deg! Vi ærer deg som er sendt av Herren, du som er Israels konge!” ");
INSERT INTO norlb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus fant et ungt esel og satte seg på det og red av sted mot byen, akkurat som Gud hadde forutsagt i Skriften: ");
INSERT INTO norlb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","”Vær ikke redde, dere Jerusalems innbyggere. Se, deres konge kommer til dere, ridende på en eselfole.” ");
INSERT INTO norlb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Disiplene forsto ikke i dette øyeblikket rekkevidden av det Gud hadde forutsagt om Jesus i Skriften, og at det ble virkelighet ved det som skjedde. Da Jesus hadde vendt tilbake til sin herlighet i himmelen, kom de til å huske hva Gud hadde forutsagt. ");
INSERT INTO norlb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Alle som hadde vært med da Jesus vekte opp Lasarus fra de døde, hadde fortalt folket det Jesus hadde gjort. ");
INSERT INTO norlb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Dette fantastiske miraklet var hovedårsaken til at så mange gikk ut for å møte ham. ");
INSERT INTO norlb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseerne sa til hverandre: ”Ingen ting hjelper! Hvert eneste menneske løper jo etter ham!” ");
INSERT INTO norlb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Blant dem som hadde kommet til Jerusalem for å feire påske, var det også noen grekere. ");
INSERT INTO norlb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","De kom til Filip, han som var fra Betsaida i Galilea, og sa: ”Min herre, vi ville så gjerne treffe Jesus.” ");
INSERT INTO norlb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip gikk da og snakket om dette med Andreas. Sammen gikk de og fortalte det til Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus svarte: ”Den tiden er nå kommet som Gud har bestemt at jeg, Menneskesønnen, skal vende tilbake til den herligheten som var min i himmelen. ");
INSERT INTO norlb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Sannheten er at jeg må dø på samme måte som et hvetekorn som faller i jorden og dør. Dersom hvetekornet ikke dør, blir det fortsatt bare det ene kornet. Om det derimot dør, da gir det en stor avling. På samme måten vil min død gi liv til mange. ");
INSERT INTO norlb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Den som elsker livet sitt mer enn noe annet, vil miste det, men den som er villig til å miste livet sitt, skal redde det og få evig liv. ");
INSERT INTO norlb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Dersom noen vil ha meg til Herre, da må han følge meg. Tjenerne mine må være der jeg er. Den som har meg til Herre, skal bli æret av min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","I dette øyeblikket er jeg fylt av angst. Men jeg kan ikke be: ’Far i himmelen, redd meg fra den fryktelige timen som venter meg’. Det er jo for denne avgjørende stunden jeg er kommet. ");
INSERT INTO norlb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Far i himmelen, pass på at du blir opphøyd og æret!” Da hørte de en stemme fra himmelen som sa: ”Gjennom dine mirakler er jeg allerede blitt opphøyd og æret, og jeg skal igjen bli det gjennom din død og oppstandelse.” ");
INSERT INTO norlb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Da folket som sto rundt hørte stemmen, trodde de at det var torden, mens andre sa at det måtte være en engel som hadde snakket til ham. ");
INSERT INTO norlb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus sa: ”Stemmen ble hørt for deres skyld, ikke for min. ");
INSERT INTO norlb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tiden er nå kommet da denne verden skal bli dømt, for nå skal Satan, som er høvding i denne verden, bli overvunnet. ");
INSERT INTO norlb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Når jeg har blitt løftet opp fra jorden, skal jeg dra alle til meg.” ");
INSERT INTO norlb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Dette sa han for å gjøre det klart for alle hvordan han skulle dø. ");
INSERT INTO norlb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","”Skal du dø?” protesterte folket. ”Vi har lært at det står i Skriften at Messias, den lovede kongen, skal leve i evighet. Dersom du nå er Messias, Menneskesønnen som det står om i Skriften, hvorfor må du da bli løftet opp? Er det en annen Menneskesønn du snakker om?” ");
INSERT INTO norlb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus svarte: ”Mitt lys vil bare lyse for dere en kort tid til. Gå i mitt lys mens dere kan, slik at ikke mørket får makt over livet deres. Den som går i mørket, går seg vill. ");
INSERT INTO norlb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tro på meg som er lyset mens dere fortsatt har sjansen til det, da vil dere bli barn av lyset.” Da Jesus hadde sagt dette, gikk han bort og skjulte seg. ");
INSERT INTO norlb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Til tross for alle miraklene Jesus hadde gjort, var det mange blant folket som ikke trodde at han var sendt av Gud. ");
INSERT INTO norlb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dette faktum bekreftet forutsigelsen som Gud lot profeten Jesaja uttale om Jesus: ”Herre, hvem trodde på det vi fikk høre, og for hvem har Herren vist makten sin til å frelse?” ");
INSERT INTO norlb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Folket kunne helt enkelt ikke tro, for Jesaja hadde også fortalt: ");
INSERT INTO norlb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","”Gud har forblindet øynene deres, slik at de ikke kan se, og har gjort hjertene deres harde og likegyldige, slik at de ikke kan forstå. Derfor kan de ikke vende om til meg og bli helbredet.” ");
INSERT INTO norlb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Dette kunne Jesaja si etter som Gud lot ham se den herlighet Jesus hadde i himmelen, og det var om Jesus han skrev. ");
INSERT INTO norlb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Likevel var det mange, til og med i Det jødiske rådet, som trodde at Jesus var sendt av Gud. De våget bare ikke å bekjenne det åpent, etter som de var redde at fariseerne skulle ekskludere dem fra Den jødiske menigheten. ");
INSERT INTO norlb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","De ville heller bli akseptert av mennesker enn av Gud. ");
INSERT INTO norlb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus ropte til folket: ”Dersom dere tror på meg, da tror dere i virkeligheten på ham som har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Den som ser meg, han ser også ham som har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jeg er kommet som et lys til verden, for at ingen som tror på meg, skal bli i mørket. ");
INSERT INTO norlb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Om noen hører min lære og ikke vil å følge den, da dømmer ikke jeg ham. Jeg er ikke kommet for å dømme menneskene, men for å frelse. ");
INSERT INTO norlb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nei, den som nekter å tro på meg og ikke tar imot budskapet mitt, han skal bli dømt av de sannhetene jeg har undervist om når dagen kommer og Gud dømmer alle. ");
INSERT INTO norlb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Det jeg taler, er ikke mine egne tanker, men kommer fra min Far i himmelen. Han som har sendt meg, har bestemt det jeg skal si til dere. ");
INSERT INTO norlb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jeg vet at budskapet hans gir evig liv. Derfor forteller jeg det han vil at jeg skal si dere.” ");
INSERT INTO norlb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Påskehøytiden skulle snart begynne. Jesus visste at den tiden som hans Far i himmelen hadde bestemt, nå var kommet. Han skulle forlate jorden og vende tilbake til sin Far i himmelen. Jesus ga derfor et siste bevis på hvor høyt han elsket disiplene. ");
INSERT INTO norlb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus og disiplene var samlet for å spise sammen. Djevelen hadde allerede gitt Judas, han som var sønn til Simon Iskariot, den tanken at han skulle forråde Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus visste at Far i himmelen hadde gitt alt over i hans hånd, og at han selv var kommet fra Gud og skulle vende tilbake til Gud. ");
INSERT INTO norlb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jesus reiste seg fra bordet, tok av seg kappen og bandt et håndkle om livet. ");
INSERT INTO norlb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Han helte vann i et fat og begynte å vaske disiplene sine føtter og tørke dem med håndkleet som han hadde bundet om seg. ");
INSERT INTO norlb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Da han kom til Simon Peter, sa Simon til ham: ”Herre, du skal ikke vaske føttene mine.” ");
INSERT INTO norlb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Da svarte Jesus: ”Akkurat nå forstår du ikke det jeg gjør, men det kommer en dag du skal skjønne meningen med det.” ");
INSERT INTO norlb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","”Nei”, protesterte Peter, ”aldri i livet om du skal vaske føttene mine!” Jesus sa til ham: ”Dersom jeg ikke gjør deg ren, kan du ikke tilhøre meg.” ");
INSERT INTO norlb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Da ropte Peter: ”Herre, vask ikke bare føttene mine, men også hendene og hodet.” ");
INSERT INTO norlb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus sa til ham: ”Den som har badet, trenger bare få føttene vasket for å være ordentlig ren. Dere er rene, men det gjelder ikke alle.” ");
INSERT INTO norlb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus visste nemlig hvem som skulle forråde ham. Det var derfor han sa at ikke alle var rene. ");
INSERT INTO norlb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Da Jesus hadde vasket føttene deres, tok han på seg kappen igjen og tok plass ved bordet. Han spurte dem: ”Forstår dere det jeg har gjort med dere? ");
INSERT INTO norlb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Dere kaller meg Mester og Herre, og det gjør dere rett i, for det er nettopp det jeg er. ");
INSERT INTO norlb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Dersom nå jeg, som er deres Herre og Mester, har vasket føttene deres, da er også dere skyldige i å vaske føttene til hverandre. ");
INSERT INTO norlb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jeg har gitt dere et eksempel til å følge: Gjør som jeg har gjort mot dere. ");
INSERT INTO norlb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jeg forsikrer dere at en tjener står ikke over sin herre, og en utsending står ikke over han som har sendt ham. ");
INSERT INTO norlb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Når dere nå vet dette, da er dere lykkelige dersom dere også praktiserer det.” ");
INSERT INTO norlb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jesus fortsatte: ”Jeg snakker ikke om dere alle. Jeg kjenner dere som jeg har valgt ut til mine nærmeste disipler, men det må bli til virkelighet som Gud har forutsagt i Skriften: ’Den som spiste sammen med meg, han har vendt seg mot meg.’ ");
INSERT INTO norlb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jeg sier det allerede nå, for at når det skjer, skal dere kunne tro at jeg er den jeg er. ");
INSERT INTO norlb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jeg forsikrer dere at den som tar imot dem som jeg sender, han tar imot meg. Og den som tar imot meg, han tar imot Gud, etter som Gud har sendt meg.” ");
INSERT INTO norlb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Da Jesus hadde sagt dette, ble han opprørt i sitt innerste og utbrøt: ”Jeg skal si dere som sant er: En av dere kommer til å forråde meg!” ");
INSERT INTO norlb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Disiplene så på hverandre og undret seg over hvem han mente. ");
INSERT INTO norlb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","En av disiplene, han som Jesus elsket, satt nærmest Jesus ved bordet. ");
INSERT INTO norlb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter gjorde derfor tegn til ham om å spørre Jesus hvem han snakket om. ");
INSERT INTO norlb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Disippelen bøyde seg da mot Jesus og spurte: ”Herre, hvem er det?” ");
INSERT INTO norlb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus svarte: ”Det er ham som får den biten brød som jeg nå dypper i fatet.” Han dyppet biten og ga det til Judas, som var sønn til Simon Iskariot. ");
INSERT INTO norlb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","I samme øyeblikk som Judas fikk brødet, for Satan inn i ham. Jesus sa: ”Skynd deg, gjør det du skal!” ");
INSERT INTO norlb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ingen av de andre ved bordet forsto hvorfor Jesus sa det på denne måten til Judas. ");
INSERT INTO norlb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Noen trodde at han ba ham å gå ut og kjøpe det de trengte til påskehøytiden eller at han skulle gi noe til de fattige. Det var Judas som var kasserer for den felles pengebeholdningen de hadde. ");
INSERT INTO norlb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Da Judas hadde fått brødet, reiste han seg straks og gikk ut. Og det var natt. ");
INSERT INTO norlb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Så snart Judas hadde gått, sa Jesus: ”Jeg, Menneskesønnen, skal nå vende tilbake til herligheten min i himmelen, og Gud skal bli opphøyd og æret ved det som hender meg. ");
INSERT INTO norlb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ja, Gud skal ganske snart la meg vende tilbake til herligheten min. ");
INSERT INTO norlb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mine kjære barn, jeg skal bare være hos dere en kort tid til. Etterpå vil dere lete etter meg uten å finne meg, etter som jeg går til et sted der dere ikke kan komme. Det var det samme jeg sa til de religiøse lederne. ");
INSERT INTO norlb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jeg gir dere instruks om noe nytt: At dere skal elske hverandre. Ja, elske hverandre like mye som jeg har elsket dere. ");
INSERT INTO norlb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Gjennom det at dere elsker hverandre skal menneskene skjønne at dere er disiplene mine.” ");
INSERT INTO norlb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter spurte Jesus: ”Herre, hvor går du?” Jesus svarte: ”Dit jeg går, kan du ikke følge med nå, men seinere skal du følge meg.” ");
INSERT INTO norlb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter undret: ”Hvorfor kan jeg ikke følge med nå? Jeg er beredt til å dø for deg.” ");
INSERT INTO norlb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Da svarte Jesus: ”Dø for meg, sier du? Jeg forsikrer deg at før hanen rekker å gale i morgen tidlig, har du nektet tre ganger på at du kjenner meg!” ");
INSERT INTO norlb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus sa: ”Vær ikke urolige, men stol på Gud og stol på meg. ");
INSERT INTO norlb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","I huset til min Far i himmelen finnes det mange rom. Jeg går nå i forveien for å gjøre i stand et sted til dere. Stol på at dette stemmer etter som det er jeg som sier det til dere. Når alt er ferdig, skal jeg komme tilbake og hente dere, slik at også dere kan være der jeg er. ");
INSERT INTO norlb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nå vet dere hvor jeg går, og dere kjenner veien som fører dit.” ");
INSERT INTO norlb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas sa: ”Herre, vi har fortsatt ingen anelse om hvor du går. Hvordan kan vi da kjenne veien?” ");
INSERT INTO norlb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus svarte: ”Jeg er veien til Far i himmelen, og jeg har vist hvem han virkelig er. Jeg er den som gir liv. Ingen kan komme til Far i himmelen uten ved meg. ");
INSERT INTO norlb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dersom dere har lært å kjenne meg, da skal dere også lære å kjenne min Far i himmelen. Dere kjenner ham allerede og har sett ham.” ");
INSERT INTO norlb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip sa: ”Herre, vis oss Far i himmelen, så skal vi være fornøyd.” ");
INSERT INTO norlb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus svarte: ”Vet du ikke hvem jeg er, Filip, og det til tross for at jeg har vært hos dere så lenge? Den som har sett meg, har sett Far i himmelen. Hvorfor ber du da om å få se ham? ");
INSERT INTO norlb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tror du ikke at jeg er i min Far i himmelen, og at min Far i himmelen er i meg? Når jeg snakker med dere, da er det ikke mine egne tanker jeg kommer med. Nei, det er min Far i himmelen som er i meg og handler gjennom meg. ");
INSERT INTO norlb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tro på meg når jeg sier at jeg er i min Far i himmelen, og at min Far i himmelen er i meg. Tro det i det minste på grunn av de miraklene dere har sett skje gjennom meg. ");
INSERT INTO norlb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jeg forsikrer dere at den som tror på meg, skal gjøre de samme miraklene som jeg har gjort. Ja, til og med enda større, for jeg går for å være hos min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Dere som tilhører meg, kan be om hva som helst, og jeg skal gjøre det, slik at Far i himmelen blir opphøyd og æret på grunn av det som Sønnen gjør for dere. ");
INSERT INTO norlb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ja, dersom dere ber om noe i navnet mitt, da skal jeg gjøre det.” ");
INSERT INTO norlb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesus fortsatte: ”Dersom dere elsker meg, da er dere lydige mot det jeg har bedt dere om å gjøre. ");
INSERT INTO norlb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jeg skal be min Far i himmelen om å sende dere en annen Hjelper, en som for alltid skal være hos dere. ");
INSERT INTO norlb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dette er Guds egen Ånd som forklarer sannheten om ham. De som ikke tror på Gud, kan ikke ta imot ham, for de ser han ikke og kjenner han heller ikke. Men dere kjenner ham, etter som han er hos dere nå og kommer til å være i dere. ");
INSERT INTO norlb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nei, jeg skal ikke forlate dere som foreldreløse barn, men jeg vil komme til dere. ");
INSERT INTO norlb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Om kort tid kan ingen her i verden se meg lenger, men dere skal se meg, for jeg skal bli levende igjen. Gjennom det skal dere også få liv. ");
INSERT INTO norlb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Når jeg har stått opp fra de døde, skal dere forstå at jeg er i min Far i himmelen, og at dere er i meg, og jeg i dere. ");
INSERT INTO norlb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Den som har hørt mine befalinger og er lydige mot det jeg sier, han elsker meg, og den som elsker meg, vil bli elsket av min Far i himmelen, og jeg vil elske han og vise meg for ham.” ");
INSERT INTO norlb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas, ikke Judas Iskariot, men den andre disippelen med samme navn, sa da til ham: ”Herre, hvorfor vil du bare vise deg for oss og ikke for alle?” ");
INSERT INTO norlb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus svarte: ”Dersom noen elsker meg, da lever han i tråd med undervisningen min, og da vil min Far i himmelen elske ham, og min Far i himmelen og jeg vil komme til ham og bli hos ham. ");
INSERT INTO norlb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Den som ikke elsker meg, lever ikke i tråd med undervisningen min. Husk på at budskapet dere har fått høre fra meg, er ikke mine egne tanker, men det kommer fra min Far i himmelen som har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Jeg sier dere dette mens jeg fortsatt er hos dere. ");
INSERT INTO norlb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Men når min Far i himmelen har sendt dere Hjelperen, sin Hellige Ånd, som skal være hos dere i mitt sted, da skal Hjelperen lære dere alt og minne dere om alt som jeg har lært dere. ");
INSERT INTO norlb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jeg etterlater meg en gave, og det er fred. Dere skal få av min fred, den freden som ingen her i verden kan gi dere. Derfor skal dere ikke være urolige og redde. ");
INSERT INTO norlb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Husk på at jeg sa til dere: ’Jeg går bort, men jeg skal komme tilbake til dere.’ Dersom dere virkelig elsker meg, vær da glade over at jeg kan gå til min Far i himmelen, for min Far i himmelen er større enn jeg. ");
INSERT INTO norlb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dette har jeg fortalt til dere før det skjer, slik at dere kan tro på meg når det om ikke lenge vil skje. ");
INSERT INTO norlb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Jeg kan ikke snakke med dere så mye lenger, for Satan, høvdingen i denne verden, nærmer seg. Han har ingen makt over meg, ");
INSERT INTO norlb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","men jeg skal gjøre det som min Far i himmelen har bestemt skal skje med meg. Det skjer for at menneskene skal forstå at jeg elsker min Far i himmelen. Kom, nå går vi fra dette stedet.” ");
INSERT INTO norlb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesus sa: ”Jeg er den sanne vinstokken, og min Far i himmelen er gartneren. ");
INSERT INTO norlb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Han skjærer bort hver gren på meg som ikke bærer frukt. De grenene som bærer frukt, beskjærer han, slik at de kan bære enda mer frukt. ");
INSERT INTO norlb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Dere er allerede forandret gjennom det budskapet dere har fått høre fra meg. ");
INSERT INTO norlb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Fortsett derfor å bli i meg, så skal jeg være i dere. En gren kan ikke bære frukt dersom den ikke har sitt feste i vinstokken. På samme måten kan ikke livet deres bære frukt om dere ikke blir i meg. ");
INSERT INTO norlb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja, jeg er vinstokken, og dere er grenene. Dersom noen blir i meg og jeg i ham, da bærer han mye frukt, men uten meg kan dere ikke gjøre noe. ");
INSERT INTO norlb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Den som ikke bli i meg, han blir kastet bort på samme måten som en vissen gren. Alle grenene som har visnet, blir kastet på bålet og brent opp. ");
INSERT INTO norlb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dersom dere blir i meg og budskapet mitt blir i dere, da kan dere be om hva dere vil, og dere skal få det. ");
INSERT INTO norlb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","De som virkelig er mine disipler bærer mye frukt, ved det blir min Far i himmelen opphøyd og æret. ");
INSERT INTO norlb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jeg har elsket dere på samme måten som min Far i himmelen har elsket meg. Bli derfor værende i min kjærlighet. ");
INSERT INTO norlb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Dersom dere er lydige mot det jeg har gitt befaling om, blir dere i min kjærlighet. På samme måten blir jeg i kjærligheten til min Far i himmelen siden jeg gjør det han har gitt meg befaling om. ");
INSERT INTO norlb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Dette har jeg sagt til dere for at min glede skal fylle dere, slik at gleden deres blir fullkommen. ");
INSERT INTO norlb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dette er min befaling: At dere skal elske hverandre på samme måten som jeg har elsket dere. ");
INSERT INTO norlb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Det største beviset noen kan gi på sin kjærlighet, er at han ofrer livet for vennene sine. ");
INSERT INTO norlb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Dere er vennene mine dersom dere gjør det jeg befaler dere. ");
INSERT INTO norlb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jeg kaller dere ikke lenger tjenere, for en tjener får ikke greie på det herren hans tenker å gjøre. Fra og med nå av er dere vennene mine, for jeg har sagt dere alt som min Far i himmelen har latt meg få vite. ");
INSERT INTO norlb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Dere har ikke valgt å følge meg, men det er jeg som har valgt ut dere til en unik oppgave. Dere skal gå ut i verden og bære frukt som blir stående for evig. Da vil Far i himmelen gi dere alt dere ber ham om fordi dere tilhører meg. ");
INSERT INTO norlb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ja, dette er min befaling til dere: At dere skal elske hverandre.” ");
INSERT INTO norlb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesus fortsatte: ”Når menneskene hater dere, skal dere huske på at de har hatet meg før de begynte å hate dere. ");
INSERT INTO norlb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dersom dere hadde tilhørt denne verden, ville menneskene elske dere, etter som dere da ville vært en av dem. Nå tilhører dere ikke denne verden, etter som jeg har innbudt dere til å være borgere av en annen verden. Derfor hater menneskene dere. ");
INSERT INTO norlb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Husk på det jeg sa til dere: ’En tjener står ikke over sin herre.’ Dersom de har forfulgt meg, kommer de også til å forfølge dere. Men har de levd i tråd med undervisningen min, kommer de også til å rette seg etter det dere sier. ");
INSERT INTO norlb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Menneskene vil forfølge dere fordi dere tilhører meg, og fordi de ikke kjenner Gud, han som har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Dersom jeg aldri hadde kommet og sagt sannheten, ville alle vært uskyldige. Nå har de ingen unnskyldning for syndene sine. ");
INSERT INTO norlb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Den som hater meg hater også min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Dersom jeg ikke hadde utført større mirakler enn det som andre har gjort iblant dere, ville alle vært uskyldige. Nå hater de både meg og min Far i himmelen, og det til tross for at de har sett disse miraklene. ");
INSERT INTO norlb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gjennom dette blir det som står skrevet om meg i loven til virkelighet: ’De har hatet meg uten grunn.’ ");
INSERT INTO norlb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jeg vil sende Hjelperen til dere, Guds Ånd, han som gjør sannheten om Gud synlig. Hjelperen vil komme til dere fra Gud, vår Far i himmelen, og når han kommer, skal han fortelle dere om meg. ");
INSERT INTO norlb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Også dere må fortelle andre om meg, for dere har vært med meg fra begynnelsen. ");
INSERT INTO norlb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Dette har jeg sagt til dere for at dere ikke skal miste troen på meg. ");
INSERT INTO norlb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dere kommer til å bli ekskludert fra Den jødiske menigheten, ja, det skal gå så langt at de som dreper dere, tror at de tjener Gud ved handlingene sine. ");
INSERT INTO norlb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Denne tragiske misforståelsen beror på at de aldri har lært å kjenne min Far i himmelen, og heller ikke meg. ");
INSERT INTO norlb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jeg sier dere dette nå, for at dere den dagen det skjer, skal huske at jeg advarte dere. Jeg har ikke sagt dette til dere tidligere siden jeg inntil nå har vært hos dere.” ");
INSERT INTO norlb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesus fortsatte: ”Nå går jeg til ham som har sendt meg, og ingen av dere spør hvor jeg går. ");
INSERT INTO norlb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dere er altfor bedrøvet og fulle av sorg over det jeg har fortalt dere. ");
INSERT INTO norlb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sannheten er at det er best for dere at jeg går bort, for ellers kan ikke Hjelperen, Guds Ånd, komme til dere. Når jeg har gått bort, skal jeg sende ham til dere. ");
INSERT INTO norlb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Når Guds Ånd kommer, skal han vise menneskene at de er syndere, at jeg er skyldfri innfor Gud og at Guds dom vil ramme. ");
INSERT INTO norlb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Syndere er de fordi de ikke tror på meg. ");
INSERT INTO norlb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","At jeg er skyldfri innfor Gud viser seg ved at Far i himmelen opphøyer meg til å regjere med ham, slik at dere ikke kan se meg mer. ");
INSERT INTO norlb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Guds dom rammer hver og en som gjør synd, det forstår vi når vi ser at Gud har dømt Satan, som er høvding i denne verden. ");
INSERT INTO norlb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Det er mye jeg ennå ville si dere, men dere kan ikke forstå det nå. ");
INSERT INTO norlb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Når Guds Ånd kommer, skal han vise dere hele sannheten om Gud. Han vil ikke holde fram sine egne tanker, men fortelle det han hører av meg. Han vil la dere få kjennskap til det som kommer til å skje i framtiden. ");
INSERT INTO norlb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Videre vil han opphøye og ære meg, for alt han lar dere få vite, har han fått fra meg. ");
INSERT INTO norlb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Alt som min Far i himmelen har, det tilhører meg. Derfor kan jeg si at alt Guds Ånd lar dere få vite, har han fått fra meg. ");
INSERT INTO norlb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Snart ser dere meg ikke lenger. Like plutselig skal dere få se meg igjen.” ");
INSERT INTO norlb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Noen av disiplene spurte da hverandre: ”Hva mener han egentlig når han sier at vi snart ikke skal se ham lenger. Og at vi like plutselig skal få se ham igjen? Hva kan det bety når han sier at han går til sin Far i himmelen? Hvor snart skal dette skje? Vi fatter ingenting av det han sier.” ");
INSERT INTO norlb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus visste at de ville spørre ham, og sa: ”Dere undrer dere på hva jeg mente da jeg sa at dere ganske snart ikke skulle se meg lenger? Og at dere like snart skal få se meg igjen. ");
INSERT INTO norlb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ja, jeg forsikrer dere at dere kommer å gråte og klage over det som skal skje med meg, men mange skal bli glade. Dere skal sørge, men sorgen vil bli vendt til glede når dere ser meg igjen. ");
INSERT INTO norlb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Det blir som når en kvinne føder sitt barn. Mens forløsningen står på, har hun det smertefullt. Men når hun har født sitt barn, glemmer hun smerten og gleder seg bare over at et lite menneske er blitt født til verden. ");
INSERT INTO norlb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Dere har det også vanskelig nettopp nå, men jeg skal treffe dere igjen, og da skal dere bli glade. Ingen kan ta fra dere den gleden. ");
INSERT INTO norlb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Den dagen trenger ingen å spørre meg om noe som helst. Jeg forsikrer dere at fra den dagen skal Far i himmelen gi dere alt dere ber om fordi dere tilhører meg. ");
INSERT INTO norlb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dere har bedt før, men aldri fordi dere tilhørte meg. Nå skal dere be i mitt navn, og dere skal få. Gleden deres skal bli full og hel. ");
INSERT INTO norlb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Alt dette har jeg fortalt dere i bilder, men det kommer en tid da jeg vil snakke åpent og klart til dere uten bilder. Da skal dere få vite mer om min Far i himmelen. ");
INSERT INTO norlb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Den dagen skal dere be til Far i himmelen, og han skal svare dere fordi dere tilhører meg. Jeg trenger ikke å be for dere. ");
INSERT INTO norlb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Min Far i himmelen elsker dere, fordi dere har elsket meg og tror at jeg er kommet fra Gud. ");
INSERT INTO norlb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ja, jeg er kommet til verden fra min Far i himmelen, og jeg skal forlate verden for å vende tilbake til ham.” ");
INSERT INTO norlb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Da sa disiplene: ”Endelig snakker du i klare meldinger, og ikke i bilder. ");
INSERT INTO norlb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nå forstår vi at du vet alt før noen har stilt et eneste spørsmål til deg. Derfor tror vi at du er kommet fra Gud.” ");
INSERT INTO norlb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus svarte: ”Nå endelig tror dere. ");
INSERT INTO norlb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Den dagen kommer, ja, den er allerede her, da dere vil bli spredd og vende tilbake til hvert sitt og etterlate meg alene. Ikke en gang da vil jeg være alene, for min Far i himmelen er hos meg. ");
INSERT INTO norlb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Dette har jeg fortalt dere for at dere skal ha fred på grunn av fellesskapet med meg. Her på jorden kommer dere til å møte mange sorger og skuffelser, men vær ikke urolige, jeg har overvunnet de onde kreftene i verden.” ");
INSERT INTO norlb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Da Jesus hadde sagt dette, så han opp mot himmelen og sa: ”Far i himmelen, den tiden har nå kommet som du har bestemt. La din Sønn vende tilbake til sin herlighet, slik at du blir opphøyd og æret. ");
INSERT INTO norlb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Du har jo gitt ham makt over alle mennesker, slik at han kan gi evig liv til alle dem som du har gitt ham. ");
INSERT INTO norlb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Evig liv betyr å lære deg å kjenne, den eneste sanne Gud som er virkelig, og meg, Jesus Kristus, som du har sendt til jorden. ");
INSERT INTO norlb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Jeg har opphøyet og æret deg her på jorden ved å fullføre det oppdraget du har gitt meg. ");
INSERT INTO norlb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","La meg derfor, kjære Far i himmelen, bli opphøyd og æret ved at jeg får tilbake den herlighet jeg hadde hos deg før verden ble skapt. ");
INSERT INTO norlb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Du har gitt meg noen til disipler fra denne verden, og jeg har vist dem hvem du er. De var dine hele tiden, men du ga dem til meg, og de har levd i tråd med læren min. ");
INSERT INTO norlb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nå vet de at alt som du har gitt til meg, er en gave fra deg. ");
INSERT INTO norlb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Det budskapet jeg fikk fra deg, har jeg levert videre, og de har tatt imot det og har forstått at jeg er kommet ned til jorden fra deg. Ja, de er helt overbevist om at du har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Jeg ber ikke for alle verdens mennesker, men for dem som du har gitt meg, etter som de tilhører deg. ");
INSERT INTO norlb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ja, alle som du har gitt meg, tilhører deg. Dersom de tilhører deg, da tilhører de meg. Ved disse skal min herlighet bli synlig for menneskene. ");
INSERT INTO norlb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Jeg forlater nå verden og kommer til deg, men de blir tilbake i verden. Far i himmelen, du som er hellig, bevar alle disse som du har gitt meg. La dem bli i ditt fellesskap, slik at de kan leve i fullkommen enhet, på samme måten som du og jeg er ett. ");
INSERT INTO norlb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mens jeg var hos de, bevarte jeg dem i ditt fellesskap. Jeg vernet alle, slik at ingen av dem gikk fortapt, bortsett fra den ene som var dømt til å gå evig fortapt, slik at det Gud hadde forutsagt i Skriften, skulle bli virkelighet. ");
INSERT INTO norlb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nå vender jeg tilbake til deg. Dette sier jeg mens jeg ennå er i verden, for at de skal kjenne min fullkomne glede. ");
INSERT INTO norlb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jeg har brakt budskapet ditt videre. Menneskene i verden har hatet dem, fordi de ikke tilhører denne verden, på samme måten som heller ikke jeg tilhører den. ");
INSERT INTO norlb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jeg ber ikke at du skal ta dem bort fra denne verden, men at du skal bevare dem fra det onde. ");
INSERT INTO norlb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","De tilhører ikke denne verden, liksom jeg ikke tilhører den. ");
INSERT INTO norlb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hjelp alle til å være lydig mot ditt sanne budskap, slik at de kan leve fullt og helt for deg. ");
INSERT INTO norlb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","På samme måten som du sendte meg til verden, sender jeg dem ut i verden. ");
INSERT INTO norlb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","For deres skyld overgir jeg livet mitt som et offer til deg, slik at de også kan overgi livene sine til deg, gjennom det å følge ditt sanne budskap. ");
INSERT INTO norlb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Men jeg ber ikke bare for dem, men også for alle som i framtiden begynner å tro på meg på grunn av budskapet deres. ");
INSERT INTO norlb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Far i himmelen, jeg ber om at de skal leve i fullkommen enhet, på samme måten som du og jeg er ett. La dem være i oss, på samme måten som du er i meg og jeg er i deg, slik at menneskene kan tro at du har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Den herligheten du ga til meg, har jeg gitt til dem, slik at de kan leve i fullkommen enhet på samme måte som du og jeg er ett. ");
INSERT INTO norlb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jeg skal være i dem og du i meg, slik at deres enhet blir total. Da skal verden forstå at du har sendt meg og at du elsker dem like mye som du elsker meg. ");
INSERT INTO norlb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Far i himmelen, jeg vil at alle dem som du har gitt meg, skal være sammen med meg, slik at de kan se den herligheten du ga meg, etter som du elsket meg allerede før verden ble skapt. ");
INSERT INTO norlb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Far i himmelen, du som alltid handler rett, menneskene i verden kjenner deg ikke, men jeg kjenner deg, og disiplene mine vet at du har sendt meg. ");
INSERT INTO norlb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jeg har hjulpet dem til å lære deg å kjenne. Jeg skal fortsette med å hjelpe dem, slik at de kan elske hverandre på samme måten som du har elsket meg, og slik at jeg kan være ett med dem.” ");
INSERT INTO norlb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Da Jesus hadde avsluttet sin bønn, gikk han ut sammen med disiplene til den andre siden av Kedrondalen. Der lå det en hage som de gikk inn i. ");
INSERT INTO norlb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, han som forrådt Jesus, kjente også til dette stedet, etter som Jesus ofte hadde vært der med disiplene. ");
INSERT INTO norlb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas tok nå med seg en gruppe romerske soldater og en del av tempelvakten. De var sendt ut av øversteprestene og fariseerne og kom med brennende fakler, lykter og våpen til hagen. ");
INSERT INTO norlb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","5","Jesus visste nøyaktig hva som skulle skje med ham. Derfor gikk han fram til dem og spurte: ”Hvem leter dere etter?” De svarte: ”Jesus fra Nasaret.” Da varte Jesus: ”Det er jeg.” Judas, han som forrådt ham, sto der sammen med de andre. ");
INSERT INTO norlb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Da Jesus sa: ”Det er jeg”, rygget alle tilbake og falt til jorden. ");
INSERT INTO norlb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Han spurte på nytt: ”Hvem leter dere etter?” De svarte: ”Jesus fra Nasaret.” ");
INSERT INTO norlb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Da sa Jesus: ”Jeg har jo allerede sagt dere at det er jeg. Dersom det er meg dere leter etter, så la de andre gå.” ");
INSERT INTO norlb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Med disse ordene gikk det i oppfyllelse det som Jesus hadde sagt: ”Jeg har ikke mistet en eneste av dem som du har gitt meg.” ");
INSERT INTO norlb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Peter trakk det sverdet han hadde tatt med seg, og hogg høyre øre av tjeneren til øverstepresten. Navnet på tjeneren var Malkos. ");
INSERT INTO norlb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Da sa Jesus til Peter: ”Sett sverdet tilbake i sliren. Skulle jeg snike meg unna de lidelsene som min Far i himmelen har bestemt at jeg må gå i gjennom?” ");
INSERT INTO norlb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Den romerske offiseren, soldatene og de jødiske tempelvaktene fanget nå Jesus og bandt ham. ");
INSERT INTO norlb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Først tok de ham med til Annas, han var svigerfar til Kaifas, som var øversteprest dette året. ");
INSERT INTO norlb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Det var Kaifas som hadde sagt til de religiøse lederne at det var best om det ene menneske døde for at folket ellers kunne bli reddet. ");
INSERT INTO norlb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter fulgte etter sammen med en av de andre disiplene. Denne disippelen kjente øverstepresten og fikk på grunn av det tillatelse til å komme inn på gårdsplassen utenfor huset til øverstepresten. Samtidig førte de Jesus dit. ");
INSERT INTO norlb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter sto igjen utenfor porten. Den disippelen som kjente øverstepresten, gikk ut og snakket med en tjenestejente som sto vakt ved porten, slik at Peter også fikk følge med inn. ");
INSERT INTO norlb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jenta i porten spurte da Peter: ”Er ikke du også en av disiplene til denne mannen?” Peter svarte: ”Nei, det er jeg ikke.” ");
INSERT INTO norlb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tjenstefolket og tempelvaktene sto rundt et bål som de hadde tent opp siden det var kjølig. Peter stilte seg der sammen med de andre og varmet seg. ");
INSERT INTO norlb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Øverstepresten stilte nå spørsmål til Jesus om disiplene hans og om hva han lærte. ");
INSERT INTO norlb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus svarte: ”Alle kjenner til undervisningen min, for jeg har hele tiden snakket åpent i synagogene og i templet. Der samlet alle jødene seg. Jeg har ikke sagt noe i hemmelighet, alt har skjedd offentlig. ");
INSERT INTO norlb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hvorfor spør du meg om dette? Spør heller dem som har hørt meg undervise. De vet hva jeg har sagt!” ");
INSERT INTO norlb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","En blant tempelvaktene som sto der, ga Jesus en ørefik og sa: ”Svarer du øverstepresten på denne måten?” ");
INSERT INTO norlb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Men Jesus sa: ”Har jeg sagt noe som ikke var riktig, så si meg hva det var. Eller slår du for at noen sier sannheten?” ");
INSERT INTO norlb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hannas sendte Jesus bundet til øverstepresten Kaifas. ");
INSERT INTO norlb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Peter sto fortsatt ved bålet og varmet seg. Noen spurte ham: ”Er ikke du også en av disiplene?” Peter protesterte og sa: ”Nei, det er jeg ikke.” ");
INSERT INTO norlb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Da sa en av tjenerne til øverstepresten, en slektning til den mannen som Peter hadde hugget øret av: ”Jo visst, jeg så deg der ute i hagen sammen med Jesus?” ");
INSERT INTO norlb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter nektet enda en gang. I samme øyeblikket gol hanen. ");
INSERT INTO norlb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tidlig på morgenen ble Jesus ført fra øverstepresten Kaifas til huset der den romerske landshøvdingen holdt til. De religiøse lederne som hadde ført ham dit, gikk ikke selv inn i huset. De ville ikke bli uverdige i Guds øyne, for da kunne de ikke være med å spise påskemåltidet. ");
INSERT INTO norlb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilatus, som var landshøvding, gikk derfor ut til dem og spurte: ”Hva er det dere anklager denne mannen for?” ");
INSERT INTO norlb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","De svarte: ”Vi ville aldri ha kommet med ham til deg om han ikke hadde vært en forbryter.” ");
INSERT INTO norlb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Da sa Pilatus: ”Om han er en vanlig forbryter, kan dere dømme ham etter deres egen lov.” Men de religiøse lederne sa: ”Vi vil ha ham henrettet, og det har vi ikke fullmakt til å gjøre på egen hånd.” ");
INSERT INTO norlb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ved dette ble det som Jesus hadde sagt til virkelighet da han avslørte på hvilken måte han skulle dø. ");
INSERT INTO norlb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus gikk nå inn i huset igjen og kalte til seg Jesus og spurte: ”Er du jødenes konge?” ");
INSERT INTO norlb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus svarte: ”Er det du selv som vil vite det, eller har andre fortalt dette om meg til deg?” ");
INSERT INTO norlb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus sa: ”Jeg er vel ingen jøde! Ditt eget folk og øversteprestene har ført deg hit. Hva har du gjort?” ");
INSERT INTO norlb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Da svarte Jesus: ”Jeg regjerer ikke i denne verden. Dersom jeg hadde gjort det, da hadde disiplene mine kjempet for at jeg ikke skulle bli tatt til fange av de religiøse lederne. Men nå regjerer jeg over et annet slags rike.” ");
INSERT INTO norlb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus spurte igjen: ”Så du er altså en konge?” Jesus svarte: ”Det er du selv som kaller meg konge. Men jeg har blitt født og har kommet hit til verden for å fortelle om det som er sant. Alle som elsker sannheten, hører det jeg sier.” ");
INSERT INTO norlb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Da sa Pilatus: ”Hva er sannhet?” Etterpå gikk han ut til folket igjen og sa: ”Jeg finner ham ikke skyldig i noe. ");
INSERT INTO norlb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Men det er tradisjon for at jeg hver påske setter fri en fange til dere. Om dere vil, kan jeg derfor slippe jødenes konge fri.” ");
INSERT INTO norlb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Men de ropte tilbake: ”Nei! Ikke ham, men Barabbas!” Barabbas var en forbryter. ");
INSERT INTO norlb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Da ga Pilatus befaling til at Jesus skulle bli pisket. ");
INSERT INTO norlb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldatene laget en krone av tornekratt og satte den på hodet hans og kledde på ham en høyrød kappe. ");
INSERT INTO norlb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","De gikk fram til ham og sa: ”Leve jødenes konge”, og så slo de ham i ansiktet. ");
INSERT INTO norlb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Senere gikk Pilatus igjen ut og sa til folket: ”Nå sender jeg ham ut til dere, slik at dere skal forstå at jeg ikke finner ham skyldig i noe.” ");
INSERT INTO norlb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Da Jesus kom ut med tornekronen og den mørkerøde kappen på seg, sa Pilatus: ”Her er mannen!” ");
INSERT INTO norlb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Da øversteprestene og tempelvaktene fikk se ha, begynte de å rope: ”La ham spikres fast på et kors, spikre ham fast på et kors!” Pilatus sa: ”Dere får selv ta ham og spikre ham fast. Jeg finner han ikke skyldig i noe.” ");
INSERT INTO norlb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Men de religiøse lederne svarte: ”I følge vår lov skal han dø, for han har gitt seg ut for å være Guds sønn.” ");
INSERT INTO norlb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Da Pilatus hørte dette, ble han virkelig redd. ");
INSERT INTO norlb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Han førte Jesus inn i huset på nytt og spurte ham: ”Hvor kommer du fra?” Men Jesus svarte ham ikke. ");
INSERT INTO norlb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","”Vil du ikke svare meg?” spurte Pilatus. ”Vet du ikke at jeg har makt både til å gi deg fri og til å la deg blir spikret fast på et kors?” ");
INSERT INTO norlb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus svarte: ”Du ville ikke ha noen som helst makt over meg om du ikke hadde fått den av Gud. Derfor har de som overlot meg til deg, gjort seg skyldige i en større synd.” ");
INSERT INTO norlb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Da forsøkte Pilatus å finne en måte å frigi Jesus på, men folket ropte: ”Dersom du setter han fri, er du ikke keiserens venn. Den som gjør seg til konge, gjør egentlig opprør mot keiseren.” ");
INSERT INTO norlb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Da Pilatus hørte det de sa, førte han Jesus ut til dem på nytt og satte seg på dommersete på det stedet som ble kalt Steingården, og som på arameisk heter ”Gabbata”. ");
INSERT INTO norlb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Klokken var nå rundt tolv på dagen, og det var fredag, som kalles forberedelsesdagen før påskehøytiden. Pilatus sa til jødene: ”Her har dere kongen deres.” ");
INSERT INTO norlb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Folket skrek: ”Bort med ham. La ham spikres fast på et kors!” Da spurte Pilatus: ”Skal jeg virkelig henrette kongen deres på et kors?” Men øversteprestene svarte: ”Vi har ingen annen konge enn keiseren.” ");
INSERT INTO norlb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Da resignerte Pilatus og overlot Jesus til soldatene for at de skulle føre ham bort og la ham spikres fast på et kors. Soldatene tok ham med seg. ");
INSERT INTO norlb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesus ble tvunget til selv å bære korset sitt til det stedet som ble kalt Hodeskallen, som på arameisk heter ”Golgata”. ");
INSERT INTO norlb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Der spikret de ham og to andre menn fast på hvert sitt kors. Jesus hengte de i midten og de to andre på hver sin side av ham. ");
INSERT INTO norlb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus hadde fått skrevet en plakat som ble satt opp på korset. Der sto det: ”Jesus fra Nasaret, jødenes konge”. ");
INSERT INTO norlb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Teksten var skrevet både på arameisk, latin og gresk. Etter som stedet der Jesus ble henrettet, lå nær byen, var det mange som leste plakaten. ");
INSERT INTO norlb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Øversteprestene gikk da til Pilatus og forlangte: ”Få endret teksten fra dette med ’Jødenes konge’ til ’Han har sagt: Jeg er jødenes konge.’ ” ");
INSERT INTO norlb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Men Pilatus svarte: ”Det jeg skrev, det skrev jeg! Ikke noe som helst skal bli endret.” ");
INSERT INTO norlb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Da soldatene hadde spikret Jesus fast på korset, tok de klærne hans og delte i fire hauger, en for hver av vaktene. Men da de kom til kjortelen, viste det seg at den var vevd i et sammenhengende stykke uten sømmer. ");
INSERT INTO norlb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Derfor sa de: ”Det er dumt å skjære den i stykker. Vi kaster heller lodd om hvem som skal få den.” Gjennom dette ble det som Gud hadde forutsagt i Skriften, til virkelighet: ”De delte mine klær mellom seg og kastet lodd om min klesdrakt.” Ja, det var nøyaktig det soldatene gjorde. ");
INSERT INTO norlb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nær korset der Jesus hang, sto moren hans. Tanten hans, som var gift med Klopas og het Maria, var også sammen med Maria Magdalena. ");
INSERT INTO norlb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Da Jesus så moren sin stå der ved siden den disippelen som han elsket, sa han til henne: ”Mor, la ham være som sønnen din.” ");
INSERT INTO norlb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Så sa han til disippelen: ”La henne være som moren din!” Fra den dagen av lot disippelen henne bo hjemme hos seg. ");
INSERT INTO norlb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus visste at oppdraget hans nå var sluttført. For at det som Gud hadde forutsagt i Skriften skulle bli virkelighet, sa han: ”Jeg er tørst.” ");
INSERT INTO norlb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Noen dyppet da en svamp i en krukke fylt med sur vin som sto der. De festet den på en stilk fra isopplanten og rakte den opp til munnen hans. ");
INSERT INTO norlb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Da Jesus hadde smakt på vinen, sa han: ”Det er fullbrakt.” Så bøyde han hodet og sluttet å puste. ");
INSERT INTO norlb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jødene ville ikke at de døde kroppene skulle henge på korset til neste dag som var hviledagen. Dessuten var det en spesiell merkedag siden det var påske. Derfor ba de Pilatus om å gi befaling til at de skulle knuse skjelettene på dem som var spikret fast på korsene. Da kunne kroppene bli tatt ned. ");
INSERT INTO norlb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soldatene kom og knuste skjelettet på de to mennene som hadde blitt spikret opp på sine kors samtidig som Jesus. Først den ene mannen sine bein, så den andre. ");
INSERT INTO norlb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Men da de kom fram til Jesus, så de at han allerede var død. Derfor knuste de ikke noen ben i kroppen hans. ");
INSERT INTO norlb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","En av soldatene nøyde seg i stedet med å stikke et spyd opp i siden hans. Da rant det blod og vann ut. ");
INSERT INTO norlb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Det finnes en som kan stå fram som vitne om dette, etter som han så det med egne øyne. Han vet at det han sier er sant, og han har fortalt dette for at dere skal tro. ");
INSERT INTO norlb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dette skjedde for at det som Gud hadde forutsagt i Skriften, skulle bli virkelighet: ”Ikke et eneste ben i kroppen hans skal bli knust.” ");
INSERT INTO norlb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","På et annet stedet har Gud sagt: ”De skal se opp til han som de har gjennomstukket”. ");
INSERT INTO norlb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Josef fra Arimatea, en som av frykt for de religiøse lederne hadde vært en hemmelig disippel av Jesus, ba Pilatus om å få ta ned kroppen til Jesus. Pilatus lot ham få gjøre det, og Josef gikk da og tok kroppen ned. ");
INSERT INTO norlb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, den mannen som først hadde kommet til Jesus om natten, var også med. Han hadde med seg en blanding av myrra og aloe som veide omkring 30 kilo. ");
INSERT INTO norlb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","De to mennene svøpte kroppen til Jesus inn i tøy av lin sammen med den aromatisk blandingen. Dette var slik som de brukte å gjøre ved jødiske begravelser. ");
INSERT INTO norlb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Plassen der Jesus ble spikret fast på korset, lå nær en hage. Der var det en ny grav som aldri hadde vært brukt. ");
INSERT INTO norlb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Etter som hviledagen snart skulle begynne, og graven lå så nær, la de Jesus i den. ");
INSERT INTO norlb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tidlig på søndag morgenen, som er dagen etter hviledagen, mens det ennå var mørkt, kom Maria Magdalena til graven og oppdaget at steinen var rullet bort fra inngangen. ");
INSERT INTO norlb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hun sprang da straks fra stedet og begynte å lete etter Simon Peter og den disippelen som Jesus elsket og sa: ”De har flyttet Herren Jesus fra graven, og vi vet ikke hvor de har lagt ham.” ");
INSERT INTO norlb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Peter og den andre disippelen sprang av sted til graven for å se etter. Den andre disippelen sprang fortere enn Peter og kom først fram. ");
INSERT INTO norlb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Han bøyde seg ned og så inn i graven. Der så han lintøyet ligge, men han gikk ikke inn. ");
INSERT INTO norlb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Litt etter kom Simon Peter, og han gikk inn i graven. Han så også lintøyet som lå der. ");
INSERT INTO norlb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","I tillegg lå også det svøpet som hadde dekket hodet på den døde. Det var rullet sammen og lå for seg selv. ");
INSERT INTO norlb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Da gikk også den andre disippelen inn, han som hadde kommet først til graven. Han så og trodde. ");
INSERT INTO norlb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Før dette hadde de ikke skjønt det Gud hadde forutsagt i Skriften om at Jesus måtte dø og så bli levende igjen. ");
INSERT INTO norlb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Etterpå gikk de to disiplene hjem. ");
INSERT INTO norlb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Men Maria sto og gråt utenfor graven. Hun bøyde seg framover og så inn i graven. ");
INSERT INTO norlb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Da fikk hun se to hvitkledde engler som satt der kroppen til Jesus hadde ligget. En ved hodeplassen og en ved fotenden. ");
INSERT INTO norlb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Englene spurte henne: ”Hvorfor gråter du?” Hun svarte: ”De har tatt bort Herren min. Nå vet jeg ikke hvor de har lagt ham.” ");
INSERT INTO norlb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Da hun hadde sagt dette, så hun seg om og fikk øye på en som sto der, men at det var Jesus skjønte hun ikke. ");
INSERT INTO norlb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus spurte henne: ”Hvorfor gråter du? Hvem leter du etter?” Hun trodde det var gartneren og svarte: ”Dersom det er du som har båret ham bort, da si meg hvor du har lagt ham, slik at jeg kan hente ham.” ");
INSERT INTO norlb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus sa til henne: ”Maria.” Straks vendte hun seg mot ham og utbrøt: ”Rabbuni!” Det er arameisk og betyr mester. ");
INSERT INTO norlb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus sa: ”Ikke rør meg, for jeg har ennå ikke vendt tilbake til min Far i himmelen. Men gå til brødrene mine og si at jeg skal vende tilbake til min Far i himmelen og deres Far i himmelen, til min Gud og deres Gud.” ");
INSERT INTO norlb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdalena gikk da til disiplene og fortalte at hun hadde sett Herren Jesus, og hun fortalte alt han hadde sagt. ");
INSERT INTO norlb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Dette skjedde på søndagen, som er den første dagen i uken. Samme kvelden samlet disiplene seg bak låste dører av frykt for de religiøse lederne. Plutselig sto Jesus midt iblant dem og sa: ”Fred være med dere alle!” ");
INSERT INTO norlb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Så viste han hendene sine og siden sin. Gleden gikk ut over alle grenser da disiplene fikk se Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus sa igjen: ”Fred være med dere! På samme måten som min Far i himmelen har sendt meg, sender jeg nå dere.” ");
INSERT INTO norlb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Så pustet han på dem og sa: ”Ta imot Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jeg gir dere i oppdrag å fortelle alle mennesker at Gud har tilgitt syndene deres, men også å fortelle med dypt alvor at det går an å stelle seg slik at de ikke får noen tilgivelse.” ");
INSERT INTO norlb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","En av disiplene, han som het Tomas og ble kalt Tvillingen, hadde ikke vært sammen med de andre da Jesus kom. ");
INSERT INTO norlb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Disiplene sa til ham: ”Vi har sett Herren Jesus.” Men Tomas svarte: ”Dersom jeg ikke får se skaden etter spikrene i hendene hans og får ta på sårene med fingrene mine, og om jeg ikke får røre ved såret i siden hans med hendene mine, da kan jeg ikke tro.” ");
INSERT INTO norlb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Neste søndag var disiplene igjen samlet. Denne gangen var Tomas sammen med de andre. Til tross for at dørene var låste, sto Jesus plutselig midt iblant dem og sa: ”Fred være med dere!” ");
INSERT INTO norlb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Han sa til Tomas: ”Her er hendene mine. Ta på sårene med fingrene dine. Se, her er siden min. Ta på såret med hendene dine. Ikke tvil lenger, men tro!” ");
INSERT INTO norlb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Da utbrøt Tomas: ”Min Herre og min Gud.” ");
INSERT INTO norlb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus sa til ham: ”Nå tror du fordi du har sett meg. Lykkelige er dem som ikke har sett meg, men likevel tror.” ");
INSERT INTO norlb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Disiplene fikk se Jesus gjøre mange andre mirakler i tillegg til dem som er skrevet ned i denne boken. ");
INSERT INTO norlb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","De som står her, er skrevet ned for at dere skal tro at Jesus er Messias, den lovede kongen og Guds sønn, og for at dere skal få liv i ham ved å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Senere viste Jesus seg igjen for disiplene ved Genesaretsjøen. Det skjedde på denne måten: ");
INSERT INTO norlb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","En gruppe som besto av Simon Peter, Tomas, han som ble kalt Tvillingen, Natanael fra Kana i Galilea, Jakob og Johannes, som var sønnene til Sebedeus, og to andre disipler var sammen ved sjøen. ");
INSERT INTO norlb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Da sa Simon Peter til de andre: ”Jeg tar meg en tur ut og fisker”. De andre svarte: ”Vi blir også med.” De steg ombord i båten og dro ut på sjøen, men de fikk ikke en eneste fisk hele natten. ");
INSERT INTO norlb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Da det ble morgen, sto Jesus på stranden, men de forsto ikke at det var ham. ");
INSERT INTO norlb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus ropte ut over sjøen: ”Går det bra, mine venner? Har dere fått noe fisk?” ”Nei”, svarte de. ");
INSERT INTO norlb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Da sa han: ”Kast noten ut på høyre side av båten, da vil dere få fisk.” De fulgte rådet hans, og nå fikk de så mye fisk at de ikke maktet å dra inn noten! ");
INSERT INTO norlb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Den disippelen som Jesus elsket, sa til Peter: ”Det er Herren Jesus.” Da Simon Peter hørte at det var Herren, knyttet han ytterklærne om seg, for han hadde nesten ikke noe på seg. Han hoppet i vannet og svømte i land. ");
INSERT INTO norlb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","De andre disiplene kom etter med båten som slepte noten med fiskene i. De var omkring 100 meter fra stranden. ");
INSERT INTO norlb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Da de kom i land, så de at Jesus hadde gjort opp et bål og holdt på å grille fisk og steke brød over glørne. ");
INSERT INTO norlb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus sa: ”Hent noen av fiskene som dere nettopp har fått.” ");
INSERT INTO norlb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Da hoppet Simon Peter ombord i båten og hjalp de andre med å dra noten i land. Det var 153 store fisker i noten. Til tross for at den var så full, hadde den ikke revnet. ");
INSERT INTO norlb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus sa til disiplene: ”Kom hit og spis.” Ingen av dem våget å spørre hvem han var, men alle skjønte at det måtte være Herren. ");
INSERT INTO norlb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus gikk fram og serverte dem av brødet og fisken. ");
INSERT INTO norlb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dette var tredje gangen som Jesus viste seg for disiplene etter at han hadde stått opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Da de hadde spist, sa Jesus til Simon Peter: ”Simon, sønn av Johannes, elsker du meg mer enn de andre gjør?” ”Ja, Herre”, svarte Peter, ”du vet at jeg elsker deg.” ”Gi da mat til mine lam”, sa Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus spurte for andre gangen: ”Simon, sønn av Johannes, elsker du meg?” ”Ja, Herre”, sa Peter, ”du vet at jeg elsker deg.” ”Vær da gjeter for mine sauer”, sa Jesus. ");
INSERT INTO norlb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","For tredje gangen spurte Jesus ham: ”Simon, sønn av Johannes, elsker du meg?” Peter ble lei seg over at Jesus på nytt måtte spørre om han elsket ham, men han svarte: ”Herre, du vet alt. Du vet at jeg elsker deg.” Da sa Jesus: ”Gi da mat til sauene mine. ");
INSERT INTO norlb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jeg skal si deg som sant er: Da du var ung, kunne du gjøre deg i stand og dra dit du selv ville. Men når du blir gammel, skal du strekke ut hendene dine, og andre vil gjøre deg i stand og føre deg dit du ikke vil.” ");
INSERT INTO norlb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Dette sa Jesus for å vise hva slags død Peter skulle opphøye og ære Gud med. Jesus sa til han: ”Følg meg.” ");
INSERT INTO norlb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter vendte seg nå rundt og fikk se at den disippelen som Jesus elsket, fulgte etter ham. Det var han som under det siste måltidet med Jesus hadde lent seg inn mot Jesus og spurt hvem som skulle forråde ham. ");
INSERT INTO norlb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Da Peter fikk se disippelen, spurte han Jesus: ”Hva kommer til å skje med ham?” ");
INSERT INTO norlb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Men Jesus svarte: ”Dersom jeg vil at han skal leve til jeg kommer igjen, så påvirker ikke det din situasjon. Se bare til at du følger meg.” ");
INSERT INTO norlb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","På grunn av dette utsagnet spredde det seg et rykte blant de troende om at denne disippelen ikke skulle dø. Men Jesus sa aldri til Peter at disippelen ikke skulle dø. Han sa bare: ”Dersom jeg vil at han skal leve til jeg kommer igjen, så påvirker ikke det din situasjon.” ");
INSERT INTO norlb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Det er denne disippelen som har sett alle tingene som skjedde, og som har skrevet det ned i denne boken. Vi vet at det han forteller, er sant. ");
INSERT INTO norlb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus gjorde også mye annet. Om alle de tingene som skjedde skulle bli skrevet ned, ja, da tror jeg ikke at hele verden ville romme det antall bøker som da måtte bli skrevet!");
INSERT INTO norlb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kjære Teofilus! I min første bok fortalte jeg for deg om alt som Jesus gjorde og lærte ");
INSERT INTO norlb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","helt fram til den dagen da han ble tatt opp til himmelen. Etter at han hadde lidd, var død og stått opp fra de døde, viste han seg for de mennene han hadde valgt ut som sine spesielle utsendinger. Han beviste på mange måter for dem at han levde. I 40 dager viste han seg for dem og fortalte om Guds plan for å frelse menneskene og gjøre dem til sitt eget folk. Gjennom Guds Hellige Ånd ga han en rekke råd og befalinger. ");
INSERT INTO norlb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ved en anledning, da han spiste sammen med sine utsendinger, sa han: ”Ikke reis fra Jerusalem før min Far i himmelen har sendt det han har lovet, det som jeg allerede har snakket med dere om. ");
INSERT INTO norlb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Døperen Johannes døpte med vann, men om noen få dager skal dere bli døpt med Guds Hellige Ånd.” ");
INSERT INTO norlb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","En annen gang da de var samlet, spurte utsendingene Jesus: ”Herre, er det nå du vil sette fri Israel og la oss bli et mektig land igjen?” ");
INSERT INTO norlb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Han svarte: ”Det tidspunktet bestemmer min Far i himmelen, det er ikke noe som dere får vite. ");
INSERT INTO norlb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Men når Guds Hellige Ånd kommer over dere, skal dere få kraft, og dere skal fortelle for alle om meg, både i Jerusalem, i Judea, i Samaria og over hele jorden.” ");
INSERT INTO norlb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Straks etter ble han løftet opp mot himmelen. Mens de sto og stirret etter ham forsvant han i en sky. ");
INSERT INTO norlb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","De forsøkte å få et siste glimt av ham, men plutselig sto to hvitkledde menn blant dem. ");
INSERT INTO norlb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","De sa: ”Dere menn fra Galilea, hvorfor står dere og ser opp mot himmelen? Jesus har blitt tatt opp fra dere og har vendt tilbake til himmelen, men en dag vil han komme tilbake på samme måten som han for opp!” ");
INSERT INTO norlb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Da alt dette skjedde, oppholdt Jesu utsendinger seg på Oljeberget, som ligger en snau kilometer fra Jerusalem. Nå vendte de tilbake dem til byen. ");
INSERT INTO norlb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","De gikk opp på det rommet i andre etasjen der de brukte å treffe hverandre. Det var Peter, Johannes, Jakob, Andreas, Filip, Tomas, Bartolomeus, Matteus, Jakob, som var sønn til Alfeus, Simon, som også ble kalt seloten, og Judas, som var sønn til Jakob. ");
INSERT INTO norlb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Alle disse ba titt og ofte sammen. Flere kvinner, blant andre Maria, moren til Jesus, brukte også å komme dit, det samme gjorde brødrene til Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Noen dager seinere var omkring 120 troende samlet. Peter reiste seg opp og sa: ");
INSERT INTO norlb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","”Kjære søsken, for lenge siden forutsa Guds Hellige Ånd ved kong David det som skulle skje med Judas, han som viste veien for dem som arresterte Jesus. Nå har det som var forutsagt i Skriften, blitt virkelighet. ");
INSERT INTO norlb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Som dere vet var Judas en av oss. Han var valgt ut til å være en av de nære utsendingene for Jesus akkurat som oss. ");
INSERT INTO norlb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Men han ble en forræder. For de pengene han fikk for sviket, kjøpte han en åker. Det endte med at han falt hodestups, slik at kroppen sprakk og innvollene hans veltet ut. ");
INSERT INTO norlb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nyheten om måten han døde på spredde seg raskt blant alle i Jerusalem. De kalte stedet for Hakeldama på arameisk, noe som betyr ’Blodåkeren’. ");
INSERT INTO norlb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","David skriver i Salmenes bok: ’La hjemmet hans bli øde, ingen skal bo der mer’, og: ’La hans oppgave bli overtatt av en annen.’ ");
INSERT INTO norlb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Derfor må vi nå velge en annen som kan ta plassen i stedet for Judas. En som sammen med oss kan fortelle at Herren Jesus har stått opp fra de døde. La oss velge en person som har vært med oss hele den tiden mens vi var sammen med Herren. En som har vært med helt fra den dagen da Jesus ble døpt av døperen Johannes og fram til dagen da han ble tatt opp til himmelen.” ");
INSERT INTO norlb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","De foreslo da to menn: Josef Barsabbas, som også ble kalt Justus, og Mattias. ");
INSERT INTO norlb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hele gruppen samlet seg i bønn, og sa: ”Herre, du kjenner hjertene hos hvert menneske. Vis oss hvem av disse to du har valgt ut. ");
INSERT INTO norlb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","La ham bli din utsending i stedet for Judas som svek oppdraget sitt, og nå har gått til stedet der han hører hjemme.” ");
INSERT INTO norlb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Så trakk de lodd. Loddet falt på Mattias, som ble valgt til Jesu utsending sammen med de andre elleve. ");
INSERT INTO norlb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Da dagen for pinse kom, sju uker etter at Jesus var stått opp fra de døde, var alle de troende samlet. ");
INSERT INTO norlb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Plutselig hørte de et brus fra himmelen, som lyden av en veldig storm. Det fylte hele huset der de var samlet. ");
INSERT INTO norlb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Noe som så ut som ild, viste seg. Det delte seg og satte seg på hver enkelt av dem. ");
INSERT INTO norlb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Alle ble fylt av Guds Hellige Ånd og begynte å snakke i andre språk som Ånden ga dem. ");
INSERT INTO norlb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mange hengivne jøder fra ulike land bodde i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Da de hørte lyden, kom de løpende for å se hva som sto på. Forskrekket fikk de høre sine egne språk bli snakket! ");
INSERT INTO norlb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","De var helt forundret og sa: ”Hvordan kan dette ha seg? Alle disse er jo fra Galilea? ");
INSERT INTO norlb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Likevel hører vi dem snakke på våre egne språk. ");
INSERT INTO norlb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vi er partere, medere og elamitter, vi kommer fra Mesopotamia, Judea, Kappadokia, Pontos, provinsen Asia, ");
INSERT INTO norlb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frygia, Pamfylia, Egypt og fra distriktet rundt Kyréne i Libya. Vi er tilreisende fra Roma, både jøder og slike som har konvertert til jødedommen. ");
INSERT INTO norlb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Vi er kretere og arabere. Likevel hører vi alle fortelle om Guds mektige mirakler på våre egne språk!” ");
INSERT INTO norlb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","De sto forvirret midt oppe i det hele og visste ikke hva de skulle tro. De spurte hverandre: ”Hva kan dette bety?” ");
INSERT INTO norlb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Andre i folkemassen sa ironisk: ”Phø, de er vel bare blitt litt fulle!” ");
INSERT INTO norlb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Da steg Peter fram sammen med de andre elleve utsendingene og begynte å tale høyt og tydelig til folket. Han sa: ”Hør på meg dere som er jøder, og alle som ellers bor i Jerusalem! ");
INSERT INTO norlb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Noen av dere sier at disse mennene er fulle. Det er ikke sant. Folk drikker seg vel ikke fulle klokka ni på morgenen? ");
INSERT INTO norlb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nei, det dere nettopp har fått se, er det som ble forutsagt for lenge siden. Det Gud sa ved profeten Joel: ");
INSERT INTO norlb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","’I den siste tiden for denne verden vil jeg la min Ånd komme over alle mennesker. Sønnene og døtrene deres skal holde fram budskap fra meg, unge menn skal se syner og gamle skal ha drømmer. ");
INSERT INTO norlb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja, min Ånd vil komme over alle tjenerne mine, både menn og kvinner. De vil holde fram budskap fra meg. ");
INSERT INTO norlb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jeg vil la merkelige tegn vise seg oppe på himmelen og nede på jorden: Blod og ild og røykskyer. ");
INSERT INTO norlb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Solen skal bli mørk og månen blodrød før Herrens store og vidunderlige dag kommer. ");
INSERT INTO norlb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hver og en som tilber Herren skal bli frelst.’ ");
INSERT INTO norlb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Lytt til det jeg sier, alle dere israelitter! Ved å gi Jesus fra Nasaret kraft til å utføre de mest fantastiske mirakler og tegn viste Gud at det var han som hadde sendt ham til verden. Dette kjenner dere til. ");
INSERT INTO norlb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","På en måte gjennomførte dere selv den planen som Gud hadde lagt, da dere med hjelp fra fremmede som lever uten Moseloven, spikret Jesus fast på et kors og drepte ham. ");
INSERT INTO norlb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Gud løste ham fra dødens veer og lot ham bli levende igjen, etter som det var umulig for døden å holde ham i sitt grep. ");
INSERT INTO norlb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kong David sa om Jesus: ’Jeg vet at Herren alltid er med meg. Jeg vakler ikke, for han står ved min side. ");
INSERT INTO norlb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Derfor er hjertet mitt fylt av gled. Jeg roper ut hans pris, og kroppen min hviler i trygghet. ");
INSERT INTO norlb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Du vil ikke forlate meg og la meg havne blant de døde, eller la din Hellige tjener gå til grunne. ");
INSERT INTO norlb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Du viser meg veien til livet, og lar meg få oppleve gleden av å være i din nærhet.’ ");
INSERT INTO norlb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kjære venner! Det var ikke om seg selv David sa dette. For dere vet like godt som jeg at David døde og ble begravd, og at graven hans fortsatt er iblant oss. ");
INSERT INTO norlb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Han var en profet som bar fram Guds budskap. David visste at Gud hadde lovet at en av etterkommerne hans skulle være Messias, den lovede kongen, og få sitte på hans trone. ");
INSERT INTO norlb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David kom med Guds forutsigelse om at Messias skulle stå opp fra de døde da han sa: ’Han vil ikke gå fra meg og la meg bli blant de døde. Han vil ikke la din Hellige tjener gå til grunne.’ ");
INSERT INTO norlb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Forutsigelsen handlet altså om Jesus. Alle vi som står her, har selv sett og kan vitne om at Gud virkelig vakte Jesus opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gud har opphøyet Jesus og satt ham på sin høyre side for at han skal regjere. Han har akkurat som Gud vår Far hadde lovet, fått ta imot Guds Hellige Ånd, den samme Ånd som nå har kommet over oss. Det er dette dere ser og hører i dag. ");
INSERT INTO norlb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David for aldri opp til himmelen. Derfor snakket han ikke om seg selv da han sa: ’Gud sa til min Herre: Kom og sett deg på min høyre side for å regjere ");
INSERT INTO norlb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","til jeg har lagt dine fiender som en skammel for føttene dine!’ ");
INSERT INTO norlb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Hele Israel må klart forstå at Gud har gjort Jesus til Herre og konge, denne Jesus som dere henrettet på et kors.” ");
INSERT INTO norlb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Da folket hørte Peter tale på denne måten, gikk det rett til hjertene på dem. De spurte Peter og de andre utsendingene: ”Brødre, hva skal vi gjøre?” ");
INSERT INTO norlb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter svarte: ”Vend om fra synden og søk Gud! La dere alle bli døpt til fellesskap med Jesus Kristus, så skal dere få tilgivelse for syndene. Dere skal få Guds Hellige Ånd som gave. ");
INSERT INTO norlb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dette løfte fra Gud gjelder dere og etterkommerne deres. Ja, det gjelder alle over hele jorden som takker ja til Herren, vår Guds, innbydelse om å tilhøre ham.” ");
INSERT INTO norlb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter fortsatte en lang stund med å tale, og han oppfordret alle: ”Pass på at dere slipper unna den straffen som venter dem som ikke vil tro.” ");
INSERT INTO norlb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","De som trodde på det Peter sa, lot seg kort tid etter døpe. Den dagen økte antallet troende med omkring tre tusen personer! ");
INSERT INTO norlb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","De troende samlet seg regelmessig for å bli undervist av Kristi utsendinger. De hadde fellesskap med hverandre brøt brødet og ba sammen. ");
INSERT INTO norlb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Folket hadde dyp respekt for de troende, for utsendingene utførte mange mirakler. ");
INSERT INTO norlb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Alle de troende var støtt og stadig samlet og hadde alt felles. ");
INSERT INTO norlb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","De solgte det de eide og delte med hverandre, alt etter som hver enkelt hadde behov. ");
INSERT INTO norlb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Hver dag møtte de hverandre i templet. I hjemmene kom de sammen for å bryte brødet og spise i fellesskap. Deres glede og takknemlighet var grenseløs. ");
INSERT INTO norlb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","De hyllet Gud dag og natt. Hele folket holdt av de troende. Hver dag lot Herren Jesus gruppen vokse ved at flere og flere ble frelst. ");
INSERT INTO norlb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","En ettermiddag gikk Peter og Johannes til templet for å delta i den daglige bønnen som var klokka tre. ");
INSERT INTO norlb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Da fikk de se en mann som ble båret dit. Han hadde vært lam fra fødselen av. Hver dag plasserte de ham ved den tempelporten som gikk under navnet Fagerporten. Der kunne han tigge av dem som gikk inn i templet. ");
INSERT INTO norlb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Da Peter og Johannes var på vei inn, ba han om penger. ");
INSERT INTO norlb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter og Johannes stanset et øyeblikk og møtte blikket hans, og Peter sa bestemt: ”Se på oss!” ");
INSERT INTO norlb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Da så mannen opp, etter som han trodde han skulle få noe. ");
INSERT INTO norlb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Men Peter sa: ”Vi har ingen penger, men jeg har noe annet å gi deg! Gjennom kraften fra Jesus Kristus fra Nasaret, befaler jeg deg å stå opp og gå!” ");
INSERT INTO norlb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peter tok den lamme i høyre hånden og reiste ham opp. Da han gjorde det, ble mannen frisk i føttene og anklene. ");
INSERT INTO norlb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Han reiste seg med et rykk og begynte å gå fram og tilbake! Så fulgte han med inn i templet. Der gikk og hoppet han om hverandre og hyllet Gud. ");
INSERT INTO norlb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Alle som var i templet, så ham gå omkring og hylle Gud. ");
INSERT INTO norlb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Da de oppdaget at det var den lamme tiggeren som brukte å sitte ved Fagerporten, ble de helt forskrekket. ");
INSERT INTO norlb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tiggeren holdt seg hele tiden nær Peter og Johannes. Alle i templet stimlet sammen i Salomos buegang. De tråkket nesten ned hverandre for å se mannen. ");
INSERT INTO norlb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter så straks sin sjanse og begynte å tale til folkemassen. Han sa: ”Israelitter, hvorfor er dere så forskrekket over det som har skjedd? Hvorfor stirrer dere på oss? Tror dere at vi ved vår egen kraft og godhet har fått denne mannen på beina? ");
INSERT INTO norlb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nei, det er Abrahams, Isaks og Jakobs Gud, våre forfedres Gud, som har gjort dette for å opphøye og ære sin tjener Jesus. Det var han dere utleverte til landshøvdingen Pilatus og svek, og det til tross for at Pilatus gjerne ville ha satt ham fri. ");
INSERT INTO norlb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dere svek ham som var hellig og uten skyld, og forlangte i stedet at en morder skulle bli satt fri. ");
INSERT INTO norlb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dere drepte ham som gir menneskene liv, men Gud har vekket ham opp fra de døde. Dette har vi selv sett og kan vitne om. ");
INSERT INTO norlb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ved tro på den kraften som er i Jesus, har denne mannen nå blitt helbredet. Dere vet jo alle at han før var helt lam. Troen på Jesus har gjort ham fullstendig frisk, noe som alle kan se. ");
INSERT INTO norlb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kjære venner! Jeg vet godt at både dere og lederne deres utleverte Jesus fordi dere ikke forsto bedre. ");
INSERT INTO norlb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ved det som skjedde, har Gud latt det han forutsa hos profetene, bli virkelighet: At Messias, den kongen han lovet oss, måtte lide. ");
INSERT INTO norlb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Derfor er det på tide å vende om til Gud, slik at dere får tilgivelse for syndene. ");
INSERT INTO norlb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Da skal en fantastisk tid med hvile og lindring komme. Gud skal sende Jesus, kongen deres, tilbake til dere. ");
INSERT INTO norlb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Han må bli i himmelen inntil alt som Gud fra tidenes begynnelse har snakket om ved sine egne profeter, har blitt virkelighet. ");
INSERT INTO norlb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses sa for eksempel: ’Herren er Gud, han vil la en profet lik meg stå fram blant deres eget folk. Lytt nøye til ham. ");
INSERT INTO norlb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Hver og en som ikke hører på denne profeten, skal bli utryddet av folket.’ ");
INSERT INTO norlb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Etter dette har alle profetene, fra Samuel og framover, båret fram Guds budskap om det som skjer i dag. ");
INSERT INTO norlb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dere er etterkommere av disse profetene, og Guds løfter som ble gitt til forfedrene, gjelder også for dere. Gud inngikk en pakt med stamfaren deres Abraham, og sa: ’Gjennom dine etterkommere skal alle folk i verden få del i min godhet.’ ");
INSERT INTO norlb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gud lot altså sin Sønn komme til jorden. Han sendte ham først til dere som er israelitter, etter som Gud ville gi dere alt godt og få dere til å vende om fra ondskapen.” ");
INSERT INTO norlb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mens Peter og Johannes fortsatt talte til folket, kom prestene og offiseren ved tempelvakten og noen av saddukeerne bort til dem. ");
INSERT INTO norlb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","De var i sterk affekt over at de lærte folket og påsto at Jesus var blitt levende igjen, og at menneskene kan stå opp fra de døde fordi Jesus har stått opp. ");
INSERT INTO norlb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","De grep Peter og Johannes og satte dem i fengsel over natten, etter som det alt hadde blitt kveld. ");
INSERT INTO norlb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mange som hadde lyttet til utsendingene, begynte å tro på budskapet. Antallet troende hadde nå økt til omkring 5 000 menn. I tillegg kom kvinner og barn. ");
INSERT INTO norlb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dagen etter samlet de øverste myndighetene seg i Jerusalem, sammen med folkets ledere og de skriftlærde. ");
INSERT INTO norlb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Øverstepresten Annas deltok også. Det samme gjorde Kaifas, Johannes, Aleksander og alle de øvrige fra slektene til øversteprestene. ");
INSERT INTO norlb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","De hentet Peter og Johannes og spurte: ”Ved hvilken kraft og på hvem sitt oppdrag har dere gjort dette?” ");
INSERT INTO norlb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Da ble Peter fylt av Guds Hellige Ånd og svarte: ”Ærede myndighet og ledere for folket! ");
INSERT INTO norlb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Dere vil i dag spørre oss ut om en god gjerning mot en handikappet mann, og dere vil vite på hvilken måte han ble helbredet. ");
INSERT INTO norlb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Derfor vil jeg uten omsvøp forklare, både for dere og alle i Israel, at det er i kraften fra Jesus Kristus fra Nasaret denne mannen står fullstendig frisk for øynene på dere. Dere spikret Jesus fast på et kors, men Gud vakte ham opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Det er han Skriften forteller om når det står: ’Den steinen som ikke var brukbar for bygningsmennene, den har blitt selve hjørnesteinen.’ ");
INSERT INTO norlb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Frelsen finnes hos ham! Ja, det finnes ingen andre i hele verden som kan frelse noen av oss.” ");
INSERT INTO norlb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Da lederne så hvor frimodige Peter og Johannes var, og visste at de bare var vanlig enkle folk uten høyere utdannelse, ble de helt forskrekket. Det eneste lederne kjente til, var at de hadde vært sammen med Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Etter som mannen sto frisk ved siden av Peter og Johannes, kunne de ikke si imot. ");
INSERT INTO norlb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Derfor ble de skysset ut av retten mens lederne begynte en intern diskusjon med hverandre. ");
INSERT INTO norlb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","De sa: ”Hva skal vi gjøre med disse personene? Vi kan jo ikke nekte for at de har gjort et stort mirakel. Alle i Jerusalem vet om det allerede. ");
INSERT INTO norlb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kanskje kan vi klare å hindre at de sprer ideene sine. Vi truer dem og sier at dersom de en gang til taler til folket om Jesus, da vil de virkelig ligge dårlig an.” ");
INSERT INTO norlb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","De kalte så Peter og Johannes inn igjen og ga befaling om at de aldri mer skulle tale eller undervise om Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peter og Johannes svarte: ”Tenk selv i gjennom det dere kommer med. Tror dere at Gud vil at vi skal lyde dere mer enn ham? ");
INSERT INTO norlb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nei, vi kan ikke la være å fortelle om alt det fantastiske som vi har sett og hørt.” ");
INSERT INTO norlb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Rådet truet da enda en gang, men til slutt var de nødt til å slippe dem. De visste ikke hvordan de kunne straffe dem uten at det ble uroligheter. Alle hyllet Gud for det miraklet som hadde skjedd. ");
INSERT INTO norlb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mannen som var blitt helbredet, hadde vært lam i over 40 år! ");
INSERT INTO norlb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Så snart Peter og Johannes var frie, søkte de opp de andre troende og fortalte det øversteprestene og folkets ledere hadde sagt. ");
INSERT INTO norlb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Da de hørte dette, begynte alle i fellesskap å rope høyt til Gud, og sa: ”Herre, du som har skapt himmelen, jorden, havet og alt som er til. ");
INSERT INTO norlb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Du lot din Hellige Ånd tale ved vår stamfar kong David, din tjener, og sa: ’Hvorfor gjør folkene opprør? Hvorfor legger de planer som ikke fører fram? ");
INSERT INTO norlb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jordens konger gjør seg beredt til strid, makthaverne har sammensverget seg mot Herren og den han har gjort til konge.’ ");
INSERT INTO norlb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ja, det er virkelig dette som har skjedd i denne byen. Kong Herodes og landshøvdingen Pontius Pilatus, romerne og hele Israels folk, alle har gått sammen mot din Hellige tjener Jesus, som du har gjort til konge. ");
INSERT INTO norlb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","De har gjort nøyaktig det som du i din makt planla for lenge siden. ");
INSERT INTO norlb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Herre, du hører hvordan de truer oss. Hjelp nå alle som tror på deg, slik at de uten frykt kan fortsette å fortelle om deg. ");
INSERT INTO norlb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Vis din makt og helbred de syke, la mirakler og tegn skje ved kraften fra din Hellige tjener Jesus.” ");
INSERT INTO norlb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Da de sluttet å be, ristet huset der de var samlet. Alle ble fylt av Guds Hellige Ånd og fortsatte å spre Guds budskap uten frykt. ");
INSERT INTO norlb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Alle de troende elsket hverandre og var enige om alt. Ingen gjorde krav på at det han eide, var hans eget, men alle delte med hverandre. ");
INSERT INTO norlb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostlene talte med stor kraft om at Jesus hadde stått opp fra de døde. Gud var god mot de troende. ");
INSERT INTO norlb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ingen manglet noe. Alle som eide jord eller hus, solgte det. ");
INSERT INTO norlb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","De overlot pengene til utsendingene som delte ut til hver og en, alt etter de behov den enkelte hadde. ");
INSERT INTO norlb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","En mann som het Josef, solgte en åker han eide, og ga pengene til de som var utsendinger for Kristus. Han tilhørte Levi stamme og kom fra Kypros. Apostlene kalte ham for Barnabas, som betyr ”den som oppmuntrer”. ");
INSERT INTO norlb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","En annen mann, som het Ananias, solgte en eiendom sammen med kona si Saffira. ");
INSERT INTO norlb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Men han overlot bare en del av salgsbeløpet til utsendingene. Sammen hadde Saffira og Ananias blitt enige om å beholde resten av pengene for seg selv. ");
INSERT INTO norlb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Da sa Peter: ”Ananias, hvorfor har du sluppet Satan inn i hjertet ditt? Hvordan kunne du finne på å påstå at dette var hele beløpet, når du visste at du hadde stukket unna en del? Du har løyet for Guds Hellige Ånd! ");
INSERT INTO norlb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Jordstykket var jo ditt, og du kunne selge det eller beholde det alt etter som du ville. Når du nå hadde solgt, var det din sak å bestemme hvor mye du ville gi. Hvordan kunne du gjøre noe slikt? Det var ikke for oss du løy, men for Gud.” ");
INSERT INTO norlb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Da Ananias hørte disse ordene, falt han død om på gulvet. Alle som hørte om det som skjedde, ble lamslått av redsel. ");
INSERT INTO norlb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Noen yngre menn kom og svøpte ham inn og bar ham ut og begravde ham. ");
INSERT INTO norlb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Omkring tre timer seinere kom kona til Ananias dit, uten å vite hva som hadde skjedd med mannen. ");
INSERT INTO norlb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter spurte henne: ”Disse pengene som dere ga oss, var det hele beløpet dere fikk for jordstykket?” ”Ja”, svarte hun, ”det var det.” ");
INSERT INTO norlb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Da sa Peter: ”Hvordan kunne du og mannen din bli enige om å gjøre noe slikt, tenk å forsøke å lyve for Guds Ånd? De skrittene du nettopp nå hører nærme seg utenfor døren, det er skrittene til de mennene som har begravd mannen din. Nå skal de også bære deg ut.” ");
INSERT INTO norlb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","I samme øyeblikk falt hun sammen foran Peter og døde. Da de unge mennene kom inn og fikk se at hun var død, bar de også henne ut og begravde henne ved siden mannen hennes. ");
INSERT INTO norlb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hele menigheten, og alle andre som hørte om dette, var rystet og sjokkert. ");
INSERT INTO norlb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Utsendingene gjorde mange merkelige mirakler blant folket. De troende møtte hverandre regelmessig på det stedet i templet som ble kalt Salomos buegang. ");
INSERT INTO norlb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ingen andre våget å blande seg med dem, men folket hadde stor respekt for de troende. ");
INSERT INTO norlb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Flere og flere begynte å tro på Herren Jesus, både menn og kvinner. ");
INSERT INTO norlb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Da de hørte om miraklene som utsendingene gjorde, bar de ut syke på gatene og la dem på liggematter og bårer for at i det minste skyggen fra Peter kunne falle på dem når han gikk forbi. ");
INSERT INTO norlb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Til og med fra byene og småstedene rundt Jerusalem kom det mange. De tok med seg syke og personer som var besatt av onde ånder, og alle ble helbredet. ");
INSERT INTO norlb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Øverstepresten og tilhengerne hans, som var saddukeere, ble misunnelige da de så alt utsendingene gjorde. ");
INSERT INTO norlb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Derfor fikk de arrestert og fengslet dem. ");
INSERT INTO norlb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Men om natten kom en engel fra Herren og åpnet portene til fengslet og slapp dem ut, og han sa: ");
INSERT INTO norlb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","”Gå og still dere fram i templet og fortell alt om det nye livet for folket.” ");
INSERT INTO norlb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Utsendingene var lydige mot oppfordringen. Tidlig på morgenen gikk de til templet og begynte å undervise. Imens kalte øverstepresten og hans nærmeste menn sammen Det jødiske rådet, det vil si alle de religiøse og politiske lederne i Israel. De sendte bud til fengslet for å hente utsendingene. ");
INSERT INTO norlb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Men da tjenerne kom til fengslet, var ikke utsendingene der. Mannen vendte tilbake til rådet og rapporterte: ");
INSERT INTO norlb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","”Portene til fengslet var låste og vaktene sto utenfor, men da vi åpnet, var det ingen der.” ");
INSERT INTO norlb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Da offiseren ved tempelvakten og øversteprestene hørte dette, ble de forskrekket og undret seg over hva som kunne ha skjedd. ");
INSERT INTO norlb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","På samme tid kom noen og fortalte at de mennene som de hadde fengslet, nå sto i templet og underviste folket. ");
INSERT INTO norlb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Offiseren gikk dit sammen med vaktene og hentet utsendingene, men uten vold, for de var redde for å bli lynsjet av folket. ");
INSERT INTO norlb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Da utsendingene ble stilt fram for Det jødiske rådet, begynte øverstepresten å forhøre dem og sa: ");
INSERT INTO norlb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","”Vi forbød dere strengt å tale eller undervise om denne mannen. Likevel har dere fylt hele Jerusalem med undervisningen deres. Dere anklager oss for å ha drept ham!” ");
INSERT INTO norlb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter og de andre utsendingene svarte: ”Det er viktigere å være lydig mot Gud enn å være lydig mot mennesker. ");
INSERT INTO norlb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Våre forfedres Gud vakte Jesus opp fra de døde, etter at dere hadde hengt ham på et kors og drept ham. ");
INSERT INTO norlb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ja, Gud har opphøyet ham og satt ham på sin høyre side for at han skal regjere. Han har gjort ham til en høvding som frelste oss ved å ta straffen for våre synder på seg, slik at Israels folk kan vende om til Gud og få tilgivelse. ");
INSERT INTO norlb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Vi har selv sett dette skje og kan vitne om at det er sant. Det kan også Guds Hellige Ånd bekrefte, den Ånd han gir til alle som lyder ham.” ");
INSERT INTO norlb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Da medlemmene i rådet hørte dette, ble de rasende og ville drepe utsendingene. ");
INSERT INTO norlb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Da grep en av fariseerne i rådet inn, han het Gamaliel og var en skriftlærd som hele folket respekterte. Han reiste seg og ba om at utsendingene skulle bli ført ut av retten en stund. ");
INSERT INTO norlb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Så vendte han seg til sine kolleger og sa: ”Israelitter, tenk dere nøye om før dere gjør noe med disse mennene! ");
INSERT INTO norlb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bråkmakere kommer og går. For et tid siden var det en tvilsom type ved navn Teudas, som ga seg ut for å være noe. Han hadde rundt regnet 400 mann som sluttet seg til ham. Men da han ble drept, spredde tilhengerne seg til alle kanter og bevegelsen døde ut. ");
INSERT INTO norlb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","På den tiden da skatteregistreringen fant sted, dukket Judas fra Galilea opp. Han fikk med seg mange tilhengere, men også han ble drept, og alle som fulgte ham ble spredd. ");
INSERT INTO norlb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Derfor foreslår jeg at dere lar disse mennene være i fred og tillater at de går herfra. Dersom det de holder på med bare er menneskelige påfunn, da vil det hele snart renne ut i sanden. ");
INSERT INTO norlb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dersom bevegelsen derimot er fra Gud, da kan dere likevel ikke stoppe den. Vær på vakt at dere ikke kjemper mot selveste Gud!” ");
INSERT INTO norlb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Medlemmene i rådet aksepterte forslaget hans. De kalte utsendingene inn og nøyde seg med å la dem bli pisket. Etterpå la de på nytt ned forbud mot at de skulle undervise om Jesus, og så fikk de gå. ");
INSERT INTO norlb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Men utsendingene dro fra retten lykkelige over at Gud hadde vurdert at de var verdige til å bli vanæret på grunn av troen på Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Hver dag fortsatte de å undervise både i templet og i hjemmene. Til alle spredde de det glade budskapet om at Jesus er Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Antallet utsendinger økte raskt på denne tiden. Det oppsto en del misnøye blant de troende. De gresktalende jødene anklaget de innfødte jødene for å diskriminere enkene deres ved den daglige utdelingen av mat. ");
INSERT INTO norlb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Utsendingene kalte derfor alle inn til et møte og sa: ”Vår hovedoppgave er å spre Guds budskap og ikke å skjøtte utdelingen av mat. ");
INSERT INTO norlb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","La oss derfor, kjære søsken, velge ut sju respekterte menn, som er fylte av Guds Ånd og som passer for denne oppgaven. Så kan de skjøtte utdelingen av mat og andre praktiske oppgaver. ");
INSERT INTO norlb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Vi kan heller disponere tiden vår til bønn og spre budskapet fra Gud.” ");
INSERT INTO norlb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Alle syntes dette var et fornuftig forslag. De valgte ut følgende personer: Stefanus, en mann som var fylt av tro og Guds Hellige Ånd, Filip, Prokorus, Nikanor, Timon, Parmenas og Nikolaus fra Antiokia, en mann som hadde konvertert til jødedommen og nå trodde på Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Disse sju ble ført fram for utsendingene, som innvieet dem til denne oppgaven ved å be og legge hendene på dem. ");
INSERT INTO norlb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Budskapet om Jesus spredde seg nå til flere og flere. Antallet utsendinger i Jerusalem økte kraftig, og en mengde prester begynte også å tro. ");
INSERT INTO norlb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus var fylt av Guds kjærlighet og kraft, og han gjorde merkelige mirakler og tegn blant folket. ");
INSERT INTO norlb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","En dag begynte noen menn fra den synagogen som ble kalt ”De frigitte”, å diskutere med Stefanus. Dette var jøder fra Kyréne og Alexandria og fra provinsene Kilikia og Asia. ");
INSERT INTO norlb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ingen av dem kunne hevde seg mot Stefanus som argumenterte med en visdom som var gitt ham av Guds Ånd. ");
INSERT INTO norlb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","De overtalte derfor noen menn i all hemmelighet til å lyve om Stefanus og påstå at de hadde hørt ham snakke nedsettende om Moses og Gud. ");
INSERT INTO norlb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","På det måten klarte de å de hisse opp både folket, lederne og de skriftlærde. De grep Stefanus og stilte ham fram for Det jødiske rådet. ");
INSERT INTO norlb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Der fortsatte de falske vitnene med å si: ”Denne mannen snakker hele tiden negativt om templet, og han angriper Moseloven. ");
INSERT INTO norlb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Vi har selv hørt ham si at denne Jesus fra Nasaret skal ødelegge templet og bryte ned de tradisjonene vi har fått fra Moses.” ");
INSERT INTO norlb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mens dette pågikk, så alle i retten skarpt på Stefanus. De merket at ansiktet hans fikk en glans som hos en engel. ");
INSERT INTO norlb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Øverstepresten spurte Stefanus: ”Er disse anklagene sanne?” ");
INSERT INTO norlb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefanus svarte: ”Kjære brødre og ledere i folket vårt! Hør etter det jeg vil si! Vår mektige og vidunderlige Gud viste seg for vår stamfar Abraham, da han bodde i Mesopotamia før han hadde flyttet til Karan. ");
INSERT INTO norlb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Gud sa til ham: ’Gå ut fra ditt land og dine slektninger og gå til det landet som jeg skal lede deg til.’ ");
INSERT INTO norlb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Derfor flyttet Abraham fra landet til kaldeerne og bosatte seg i Karan. Der bodde han til faren hans var død. Siden førte Gud ham videre til det landet der dere nå bor. ");
INSERT INTO norlb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gud ga ham ingen jord, ikke et eneste lite område, men han lovet at hele landet til slutt skulle tilhøre Abraham og etterkommerne hans. Dette til tross for at Abraham på den tiden ikke hadde noen barn. ");
INSERT INTO norlb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gud sa også til ham at etterkommerne hans skulle bo i et fremmed land og bli slaver og være undertrykket i 400 år. ");
INSERT INTO norlb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","’Men jeg skal straffe det folket som gjør dem til slaver’, sa Gud, ’og etter dette skal de forlate det fremmede landet og tilbe meg på dette stedet.’ ");
INSERT INTO norlb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Gud ga Abraham instruksjoner om at alle gutter i hver familie skulle bli omskåret. Det var et tegn på at de aksepterte den pakten Gud hadde inngått med Abraham. Da Abraham sin sønn som het Isak, var født, ble han omskåret på den åttende dagen. Isak ble seinere far til Jakob, og Jakob ble far til de tolv sønnene som bli regnet som våre stamfedre. ");
INSERT INTO norlb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Disse stamfedrene, altså sønnene til Jakob, var misunnelige på broren sin som het Josef. De solgte Josef som slave til Egypt, men Gud var med ham. ");
INSERT INTO norlb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Først reddet han Josef ut av alle vanskelighetene og lot ham bli en høyt aktet og mektig medarbeider hos farao som var konge i Egypt. Deretter ga Gud Josef en slik visdom at farao utnevnte ham til å styre hele Egypt og ta hånd om den kongelige forvaltningen. ");
INSERT INTO norlb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Etter et tid ble det sultekatastrofer og store lidelser i Egypt og Kanaan, der forfedrene våre bodde. Folket vårt manglet mat. ");
INSERT INTO norlb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Da fikk Jakob høre at det fortsatt var såkorn i Egypt. Derfor sendte han sine sønner dit for å kjøpe såkorn, først en gang og så en gang til. ");
INSERT INTO norlb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","På den andre reisen til Egypt avslørte Josef for dem hvem han var, og brødrene ble presentert for farao. ");
INSERT INTO norlb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Noe seinere sendte Josef bud etter faren sin Jakob og hele slekten hans for at de skulle komme til Egypt. Til sammen var de 75 personer. ");
INSERT INTO norlb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Så kom Jakob til Egypt og ble der til han døde, både han og sønnene hans. ");
INSERT INTO norlb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kroppene deres ble ført til Sikem og ble begravd i den graven som Abraham kjøpte av Hemors sønner. ");
INSERT INTO norlb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nå nærmet det seg den tiden da Gud skulle innfri løftet sitt til Abraham. Folket vårt hadde vokst kraftig og blitt et stort folk i Egypt. ");
INSERT INTO norlb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Men på denne tiden fikk Egypt en ny konge, en som ikke kjente til Josef. ");
INSERT INTO norlb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Denne kongen var grusom mot folket vårt og forsøkte ved list å kvitte seg med alle gjennom å tvinge forfedrene våre til å sette ut sine nyfødte barn, slik at de skulle dø. ");
INSERT INTO norlb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","I denne tiden ble Moses født. Han var et uvanlig vakkert barn. Foreldrene hans skjulte ham hjemme i tre måneder. ");
INSERT INTO norlb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Til slutt ble han for stor til å gjemme bort. De ble tvunget til å sette ham ut. Da ble han funnet av datteren til farao. Hun adopterte gutten som sin egen sønn. ");
INSERT INTO norlb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses fikk den beste utdannelsen noen kunne få i Egypt. Han var handlekraftig og snakket med stor myndighet. ");
INSERT INTO norlb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Da Moses var 40 år, begynte han å gruble over sine røtter og ville lete opp sitt eget folk, israelittene, for å hjelpe dem. ");
INSERT INTO norlb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ved et besøk han gjorde blant sine, fikk han se en egypter som mishandlet en israelitt. Han skyndte seg og kom israelitten til hjelp og hevnet seg ved å drepe egypteren. ");
INSERT INTO norlb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses trodde at folket skulle forstå at Gud hadde sendt ham for å sette alle fri, men det gjorde de ikke. ");
INSERT INTO norlb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Neste dag fikk han øye på to israelitter som hadde røket opp i slagsmål. Han forsøkte å mekle mellom dem og sa: ’Dere er jo brødre! Hvorfor vil dere skade hverandre?’ ");
INSERT INTO norlb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Men de som hadde startet slagsmålet, dyttet Moses unna og spurte: ’Hvem har satt deg til leder og dommer over oss? ");
INSERT INTO norlb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tenker du å drepe meg som du drepte egypteren i går?’ ");
INSERT INTO norlb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Da Moses hørte at det han hadde gjort, var kjent, flyktet han fra Egypt og levde som fremmed i landet Midjan. Der ble han far til to sønner. ");
INSERT INTO norlb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Da han 40 år seinere oppholdt seg i ørkenen, nær fjellet Sinai, viste en engel seg for ham i en brennende tornebusk. ");
INSERT INTO norlb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ble svært forbauset over det han så, og da han gikk nærmere for å undersøke hva det var, ropte Herren til ham: ");
INSERT INTO norlb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","’Jeg er dine forfedres Gud, Abrahams, Isaks og Jakobs Gud.’ Da skalv Moses av frykt og våget ikke å se opp. ");
INSERT INTO norlb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Herren sa til ham: ’Ta av deg sandalene, for du står på hellig jord. ");
INSERT INTO norlb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Jeg har sett lidelsene som mitt folk treller under i Egypt og hørt ropene deres. Nå har jeg kommet for å sette dem fri, og jeg sender deg tilbake til Egypt.’ ");
INSERT INTO norlb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Gud sendte altså tilbake den samme mannen, som folket før hadde avvist med ordene: ’Hvem har satt deg til leder og dommer over oss?’. Gjennom engelen som viste seg i tornebusken, ble han valgt ut til leder og redningsmann. ");
INSERT INTO norlb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses fikk ved hjelp av mirakler og tegn lede folket ut av Egypt, gjennom Rødehavet og ørkenen i 40 år. ");
INSERT INTO norlb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Det var Moses som bar fram Guds budskap til israelittene og sa: ’Gud skal la en profet lik meg stå opp for dere av deres eget folk.’ ");
INSERT INTO norlb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Det var også Moses som fikk snakke med en engel på fjellet Sinai og formidle engelen sitt budskap til folket da de var i ørkenen. Han fikk ta imot Guds lov, budskapet som gir liv, og overgi det til oss. ");
INSERT INTO norlb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Men forfedrene våre satte seg opp mot Moses og ville vende tilbake til Egypt. ");
INSERT INTO norlb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","De sa til Aron, som var bror til Moses: ’Lag guder til oss som kan lede oss, for denne Moses som førte oss ut av Egypt, ser ut til å ha forsvunnet.’ ");
INSERT INTO norlb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Så laget de en avgud i form av en kalv og ofret til den, glade over det de selv hadde skapt i menneskelig klokskap. ");
INSERT INTO norlb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Da ga Gud opp folket og lot dem tjene solen, månen og stjernene som sine guder! I profetene sin bok sier Gud: ’Var det meg dere ofret til i de 40 årene i ørkenen, dere Israels folk? ");
INSERT INTO norlb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nei, dere drasset omkring på avgudene deres, teltet til Molok og stjernen til Romfa, bilder som dere selv gjorde for å kunne tilbe. Derfor skal jeg fordrive dere til et land bortenfor Babylon.’ ");
INSERT INTO norlb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","På reisen gjennom ørkenen hadde forfedrene våre med seg vitnesbyrdets telt. Teltet var laget nøyaktig etter det forbilde som Gud hadde vist Moses. ");
INSERT INTO norlb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Det gikk siden i arv til forfedrene våre. Da Josva erobret landet fra folkene som Gud drev bort, tok de med seg teltet inn i det nye landet. Det ble siden brukt helt til kong Davids tid. ");
INSERT INTO norlb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Gud hadde i sin godhet valgt ut David til å tjene ham, og David ba om å få bygge et tempel for Israels Gud, ");
INSERT INTO norlb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Det ble sønnen hans Salomo som fikk gjøre det. ");
INSERT INTO norlb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Likevel bor ikke den Høyeste i bygninger som menneskene har laget. Gud sier jo i profeten Jesaja: ");
INSERT INTO norlb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","’Himmelen er min trone, og jorden er min foteskammel. Kan du bygge et tempel til meg som er bedre enn dette? sier Herren. Kan du gi meg et sted der jeg kan bo? ");
INSERT INTO norlb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Jeg har jo skapt både himmelen og jorden.’ ");
INSERT INTO norlb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Dere gjenstridige skapninger, som nekter å høre på det Gud sier. Dere er som de verste gudsfornektere! Alltid gjør dere motstand mot Guds Hellige Ånd, akkurat som forfedre deres gjorde. ");
INSERT INTO norlb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Si meg navnet på en eneste profet som bar fram Guds budskap og ikke ble forfulgt av forfedrene deres. De drepte til og med dem som forutsa at den Rettferdige skulle komme, han som dere nå har forrådt og myrdet. ");
INSERT INTO norlb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dere var med vilje og vitende ulydige mot Moseloven, til tross for at dere fikk den overrakt fra englenes hender.” ");
INSERT INTO norlb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Da de religiøse lederne hørte dette, ble de så rasende på Stefanus at de freste av sinne. ");
INSERT INTO norlb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stefanus, som var fylt av Guds Hellige Ånd, så opp mot himmelen og fikk se Guds herlighet og Jesus som sto ved Guds høyre hånd. ");
INSERT INTO norlb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stefanus sa: ”Jeg ser himmelen åpen og Jesus, Menneskesønnen, stå ved Guds høyre hånd!” ");
INSERT INTO norlb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Da skrek de høyt og holdt seg for ørene. Så kastet de seg over Stefanus. ");
INSERT INTO norlb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","De slepte ham ut av byen for å steine ham. De som anklaget ham, vrengte av seg kappene sine og la dem foran føttene på en ung mann som het Saulus. ");
INSERT INTO norlb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mens steinene haglet over Stefanus, ba han: ”Herre Jesus, ta imot min Ånd.” ");
INSERT INTO norlb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Så falt han på kne og ropte: ”Herre, du må ikke anklage dem for denne synden!” Med disse ordene hengende i luften drepe de ham. ");
INSERT INTO norlb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Også Saulus syntes det var rett at de drepte Stefanus. Samme dagen brøt det ut en alvorlig forfølgelse av de troende. Den rammet hele menigheten i Jerusalem. Alle bortsett fra utsendingene ble spredd over hele Judea og Samaria. ");
INSERT INTO norlb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Noen troende menn i den dypeste sorg rakk å begrave Stefanus. ");
INSERT INTO norlb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulus var mer enn grusom i sin forfølgelse av de troende. Han brøt seg inn i hus etter hus, slepte ut menn og kvinner og satte dem i fengsel. ");
INSERT INTO norlb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","De troende som hadde blitt spredd, reiste omkring og fortalte de glade nyhetene om Jesus over alt der de kom. ");
INSERT INTO norlb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip, for eksempel, reiste til hovedstaden i Samaria og fortalte folket der at Jesus er Kristus, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mange lyttet oppmerksomt på det han hadde å si når de så de store miraklene han gjorde. ");
INSERT INTO norlb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mange onde ånder ble drevet ut og forlot sine offer under høye skrik. Mange som hadde vært lamme, eller handikappet på andre måter, ble helbredet. ");
INSERT INTO norlb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Dette utløste stor glede i byen. ");
INSERT INTO norlb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","I byen var det også en mann som het Simon. Han hadde drevet med trolldom i mange år og hadde stort innflytelse over folket i Samaria. Han påsto seg å være noe stort. ");
INSERT INTO norlb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Alle, både rike og fattige, sa om ham: ”Han er en gud, det er Den store kraften som viser seg i ham.” ");
INSERT INTO norlb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","På grunn av trolldommen var alle tilhengere av ham. ");
INSERT INTO norlb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Men nå begynte folket i stedet å tro på Filip og budskapet om Jesus Kristus, at Gud ville gjøre menneskene til sitt eget folk. Mange menn og kvinner lot seg døpe. ");
INSERT INTO norlb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Også Simon kom til tro og ble døpt. Han fulgte Filip over alt der han gikk, og han var forbløffet over de tegn og mirakler som Filip gjorde. ");
INSERT INTO norlb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ryktet om at folket i Samaria hadde begynt tro på budskapet om Jesus, nådde også Jerusalem. Apostlene sendte derfor Peter og Johannes dit. ");
INSERT INTO norlb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Straks begynte de å be for alle som nylig var kommet til tro, at de måtte få Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","For Guds Ånd hadde ennå ikke kommet og fylt noen av dem, men de var bare døpt i navnet til Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peter og Johannes la nå hendene på hver enkelt, og de fikk Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Da Simon så at de fikk Guds Ånd ved at utsendingene la hendene på hodene deres, tilbød han utsendingene penger og sa: ");
INSERT INTO norlb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","”La meg også få denne makten, slik at mennesker får Guds Hellige Ånd når jeg legger hendene på dem.” ");
INSERT INTO norlb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peter svarte: ”Både du og pengene dine skal gå til grunne for alltid, dersom du tror at du kan kjøpe Guds gave for penger! ");
INSERT INTO norlb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Du har ikke noe med dette å gjøre, for din innstilling til Gud er helt feil. ");
INSERT INTO norlb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vend om fra din ondskap og be til Herren Jesus, så kanskje han tilgir deg dine lumske planer. ");
INSERT INTO norlb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Jeg ser at du fortsatt sitter fast i avgudsdyrkelse og ikke har forlatt din onde måte å tenke på.” ");
INSERT INTO norlb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Da ropte Simon: ”Be for meg til Herren, slik at jeg ikke bli rammet av dette fryktelige!” ");
INSERT INTO norlb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Etter at Peter og Johannes hadde spredd budskapet om Herren Jesus i hovedstaden i Samaria, og bekreftet for folket at de selv hadde sett og hørt alt det de fortalte, vendte de tilbake til Jerusalem. På veien stanset de i flere av byene i Samaria for å fortelle de glade nyhetene om Jesus også der. ");
INSERT INTO norlb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","En engel fra Herren viste seg nå for Filip og sa til ham: ”Gå sørover, langs veien i ørkenen som går mellom Jerusalem og Gaza”. ");
INSERT INTO norlb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip var lydig og gikk straks av sted. På veien kom en høy embetsmann, som arbeide ved hoffet hos Kandake, den etiopiske dronningen. Han hadde ansvaret for skattkamrene hos dronningen, og hadde reist til Jerusalem for å tilbe i templet. ");
INSERT INTO norlb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nå var han på vei tilbake i vognen sin. Han satt og leste høyt fra profeten Jesaja. ");
INSERT INTO norlb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Da sa Guds Ånd til Filip: ”Gå bort til vognen og hold deg nært den!” ");
INSERT INTO norlb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip skyndte seg bort, og da han hørte mannen lese det Gud hadde forutsagt ved profeten Jesaja, spurte han: ”Forstår du det du leser?” ");
INSERT INTO norlb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","”Nei”, svarte mannen. ”Hvordan skulle jeg kunne det, når ingen forklarer det for meg?” Så ba han Filip stige opp i vognen og sette seg ved siden av ham. ");
INSERT INTO norlb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Det stedet i Skriften han nettopp hadde lest, var dette: ”Slik som en sau blir ført bort for å slaktes, eller som et lam som står stille når det blir klippet, på samme vis åpnet han ikke sin munn. ");
INSERT INTO norlb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Han ble sjikanert og dømt urettferdig. Hvem kan fortelle om etterkommerne hans, når livet hans blir rykket bort fra jorden?” ");
INSERT INTO norlb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mannen spurte Filip: ”Sa profeten Jesaja dette om seg selv eller om noen andre?” ");
INSERT INTO norlb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ut fra dette skriftstedet begynte Filip å forklare de glade nyhetene om Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mens de reiste langs veien, kom de til et sted med vann. Da sa den etiopiske mannen: ”Se, her finnes vann! Kan jeg bli døpt?” ");
INSERT INTO norlb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Så ga han befaling om å stanse vognen. Sammen steg de ned i vannet, og Filip døpte ham. ");
INSERT INTO norlb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Da de kom opp av vannet, rykket Guds Ånd plutselig Filip bort, og mannen så ham ikke mer. Han fortsatte reisen sin glad og lykkelig. ");
INSERT INTO norlb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip hadde blitt forflyttet til byen Asjdod, og han dro fra by til by og fortalte de glade nyhetene om Jesus på sin vei fram til Cæsarea. ");
INSERT INTO norlb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulus var fortsatt fylt av hat og mordlyst mot alle som var disiplene til Herren Jesus. En dag gikk han til øverstepresten i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Der ba han om å få med seg dokumenter adressert til synagogene i Damaskus, for at han kunne få fullmakt til å arrestere alle i Damaskus som fulgte Jesusveien, både menn og kvinner. Han ville føre dem som fanger til Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Da han reiste av sted og nærmet seg Damaskus, ble han plutselig omsluttet av en sterk stråleglans fra himmelen. ");
INSERT INTO norlb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Han falt til jorden og hørte en stemme som sa: ”Saulus! Saulus! Hvorfor forfølger du meg?” ");
INSERT INTO norlb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Han spurte: ”Hvem er du, herre?” Stemmen svarte: ”Jeg er Jesus, han som du forfølger! ");
INSERT INTO norlb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Reis deg opp og gå inn i byen og vent der, så vil du får vite hva du skal gjøre.” ");
INSERT INTO norlb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mennene som var sammen med Saulus, sto helt tause av overraskelse. De hørte lyden av stemmen, men så ingen. ");
INSERT INTO norlb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Da Saulus litt etter litt reiste seg fra jorden, merket han at han ikke kunne se. De var nødt til å leie ham inn i Damaskus. ");
INSERT INTO norlb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","I tre dager var han helt blind, og verken spiste eller drakk i denne perioden. ");
INSERT INTO norlb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","I Damaskus bodde en disippel som het Ananias. Nå snakket Herren til ham i et syn og sa: ”Ananias!” ”Ja, Herre!” svarte han. ");
INSERT INTO norlb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Da sa Herren: ”Gå bort til den gaten som har navnet: Den rette gaten. Finn huset til Judas og spør etter en mann som heter Saulus fra Tarsus. Han er i bønn til meg nettopp nå. ");
INSERT INTO norlb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","I et syn har jeg vist ham at en mann som heter Ananias, skal komme inn og legge hendene på ham, for at han kan få synet sitt igjen!” ");
INSERT INTO norlb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","”Men Herre!” utbrøt Ananias. ”Jeg har hørt om alt det onde denne mannen har gjort mot de troende i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Vi vet at han har dokumenter med seg fra øversteprestene, som gir ham fullmakt til å arrestere alle her i Damaskus som tilber deg!” ");
INSERT INTO norlb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Herren Jesus sa: ”Gå, og gjør som jeg sier, for jeg har valgt ut Saulus til å være mitt redskap. Han skal gjøre meg kjent for mange forskjellige folk og makthavere, og også for Israels folk. ");
INSERT INTO norlb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Og jeg vil vise ham hvor mye han må lide for meg.” ");
INSERT INTO norlb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Da gikk Ananias dit og fant Saulus. Han la hendene på ham og sa: ”Saulus, min bror, Herren selv, Jesus, han som viste seg for deg på veien, har sendt meg for at du skal få ditt syn tilbake og bli fylt av Guds Hellige Ånd.” ");
INSERT INTO norlb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","I samme øyeblikk var det som om tykke skjell falt fra øynene til Saulus, og han kunne se igjen! Straks reiste han seg opp og lot seg døpe. ");
INSERT INTO norlb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Da han hadde spist, fikk han kreftene tilbake. Saulus stanset igjen noen dager hos utsendingene i Damaskus. ");
INSERT INTO norlb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Straks begynte han å gå rundt i synagogene og undervise om at Jesus virkelig er Guds sønn. ");
INSERT INTO norlb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Alle som hørte ham ble forskrekket og spurte: ”Var det ikke han som i Jerusalem forsøkte å drepe alle som tilber Jesus? Ryktet sa at han var på vei hit for å arrestere de troende og føre dem som fanger til øversteprestene?” ");
INSERT INTO norlb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulus talte med stadig større kraft, og jødene i Damaskus hadde ingen argumenter å sette imot når han beviste at Jesus er Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Etter en tid hadde de religiøse lederne fått nok og forsøkte å gjøre slutt på Saulus. ");
INSERT INTO norlb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulus fikk greie på planene deres. De holdt vakt ved byens porter både dag og natt for å kunne drepe ham. ");
INSERT INTO norlb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","En natt tok noen av de troende og firte ham ned i en korg fra en åpning i bymuren. ");
INSERT INTO norlb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus vendte nå tilbake til Jerusalem, men da han forsøkte å slutte seg til disiplene der, var de reserverte mot ham. Ingen våget helt å stole på at han virkelig hadde blitt en disippel. ");
INSERT INTO norlb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas tok ham med til utsendingene og fortalte for dem hvordan Saulus på veien hadde sett Herren Jesus og hvordan han hadde snakket til ham. Etterpå hadde Saulus med stort mot undervist om Jesus i Damaskus. ");
INSERT INTO norlb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Etter dette aksepterte de Saulus, og han gikk ut og inn hos dem i Jerusalem. Han spredde budskapet om Herren Jesus uten den minste frykt. ");
INSERT INTO norlb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Han talte også til de gresktalende jødene og diskuterte med dem. Det drøyde ikke lenge før de gjorde seg opp planer om å drepe ham. ");
INSERT INTO norlb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Da de troende fikk greie på dette, tok de med seg Saulus til Cæsarea og sendte ham videre til hans hjemby som var Tarsus. ");
INSERT INTO norlb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Menighetene fikk nå være i fred i hele Judea, Galilea og Samaria. Medlemmene ble stadig sterkere, og alle levde i lydighet og respekt for Herren. Gjennom Guds Hellige Ånds styrke og hjelp kom også mange nye mennesker til tro. ");
INSERT INTO norlb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter reiste nå fra sted til sted for å besøke menighetene. På en av reisene sine kom han også til de troende i byen Lod. ");
INSERT INTO norlb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Der møtte han en mann som het Æneas, som var lam og hadde vært nødt til å ligge på en liggematte i åtte år. ");
INSERT INTO norlb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter sa til ham: ”Æneas! Jesus Kristus helbreder deg. Reis deg opp og rull liggematten din sammen!” I samme øyeblikk reiste Æneas seg opp. ");
INSERT INTO norlb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Alle som bodde i Lod og på Saronsletten, så ham seinere gå frisk og sunn omkring, og de begynte å tro på Herren Jesus! ");
INSERT INTO norlb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","I byen Joppe bodde det blant disiplene en kvinne som het Tabita, på gresk blir navnet Dorkas. Hun hadde gjort mye godt mot andre mennesker og spesielt mot de fattige. ");
INSERT INTO norlb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","På denne tiden ble hun syk og døde. Vennene hennes stelte henne for begravelsen og la henne i et rom som var en trapp opp. ");
INSERT INTO norlb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Da disiplene hørte at Peter var i Lod, som lå like i nærheten, sendte de av sted to menn for å be ham komme til Joppe så fort som mulig. ");
INSERT INTO norlb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peter fulgte straks med, og da han kom dit, tok de han med opp trappen der Tabita lå. Rommet var fylt av gråtende enker. De viste Peter de skjortene og kappene Tabita hadde sydd mens hun ennå levde. ");
INSERT INTO norlb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter ba alle å forlate rommet. Så falt han på kne og ba, og etter en stund vendte han seg mot den døde og sa: ”Tabita, reis deg opp!” Da slo hun opp øynene sine, og da hun fikk se Peter, satte hun seg opp. ");
INSERT INTO norlb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter rakte henne hånden og hjalp henne opp på føttene. Så ropte han på de troende og enkene og lot dem komme innfor å se henne stå der lys levende. ");
INSERT INTO norlb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nyheten om det som hadde skjedd, spredde seg i hele byen, og mange begynte å tro på Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter stanset derfor et tid i Joppe og bodde hos Simon, en mann som arbeidet med å garve skinn. ");
INSERT INTO norlb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","I Cæsarea bodde en romersk offiser som het Kornelius, og han var kaptein for Den italiske bataljonen. ");
INSERT INTO norlb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Han, og alle i huset hans, tilba Israels Gud og var nøye med å være lydige mot ham. Kornelius ga store gaver til de fattige blant jødene og ba regelmessig til Gud. ");
INSERT INTO norlb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","En ettermiddag da han ba, klokka var omkring tre, fikk han i et syn se en Guds engel komme mot ham og si: ”Kornelius”. ");
INSERT INTO norlb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Skrekkslagen stirret Kornelius på engelen og spurte: ”Hva vil du, herre?” Engelen svarte: ”Gud har hørt bønnene og sett gavene dine til de fattige. ");
INSERT INTO norlb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Send nå av sted noen menn til Joppe og hent den mannen som heter Simon Peter. ");
INSERT INTO norlb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Han bor i et hus nede ved havet hos en mann som arbeider med å garve skinn og heter Simon.” ");
INSERT INTO norlb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Så snart engelen hadde forsvunnet, kalte Kornelius på to av tjenerne sine og en soldat, som også trodde på Gud. ");
INSERT INTO norlb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Han fortalte alt som hadde skjedd og sendte dem av sted til Joppe. ");
INSERT INTO norlb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Neste dag ved middagstiden nærmet mennene seg Joppe. Samtidig gikk Peter opp på takterrassen øverst på huset for å be. ");
INSERT INTO norlb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Etter en stund ble han sulten og ba om å få noe å spise, men mens maten ble gjort i stand, fikk han se et syn. ");
INSERT INTO norlb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Han så himmelen åpen, og noe som lignet en stor duk ble senket ned på jorden. Duken var festet i sine fire hjørner. ");
INSERT INTO norlb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Den inneholdt alle slags dyr, både av den typen som flyr og slike som lever på land. ");
INSERT INTO norlb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","En stemme sa til ham: ”Reis deg opp, slakt og spis!” ");
INSERT INTO norlb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","”Nei, aldri, Herre”, svarte Peter. ”Jeg har aldri spist noe som Gud har forbudt i Moseloven.” ");
INSERT INTO norlb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Igjen hørte han stemmen som sa: ”Dersom Gud har gjort noe tillatt, må ikke du behandle det som forbudt.” ");
INSERT INTO norlb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Det samme synet ble gjentatt tre ganger, og så ble duken trukket opp til himmelen. ");
INSERT INTO norlb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter var svært forvirret. Hva kunne synet bety? I samme øyeblikk kom mennene som Kornelius hadde sendt av sted. De hadde spurt seg fram til huset og sto nå utenfor porten. ");
INSERT INTO norlb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","De ropte: ”Er det her Simon Peter bor?” ");
INSERT INTO norlb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter var fortsatt opptatt med å gruble over synet da Guds Ånd sa til ham: ”Tre menn har kommet hit for å treffe deg. ");
INSERT INTO norlb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gå ned og ta imot dem som er kommet og bli med dem. Vær ikke urolig, for det er jeg som har sendt dem.” ");
INSERT INTO norlb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Da gikk Peter ned og møtte mennene og sa: ”Det er jeg som er Simon Peter. Er det noe spesielt dere vil meg?” ");
INSERT INTO norlb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Da fortalte de: ”Vi er sendt hit av den romerske offiseren Kornelius. Han tilber Israels Gud og tar på alvor å være lydig mot ham. Han er avholdt av alle jødene. Nå har en engel fra Gud sagt til ham at han skulle sende bud etter deg, slik at han kan få greie på det du har å si.” ");
INSERT INTO norlb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter bød dem da inn og lot dem bli der natten over. Neste dag tok han med seg noen troende fra Joppe og fulgte med mennene. ");
INSERT INTO norlb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Dagen etterpå kom de fram til Cæsarea, der Kornelius ventet på ham. Han hadde samlet alle slektningene sine og nærmeste venner for at de skulle få treffe Peter. ");
INSERT INTO norlb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Da Peter steg inn i huset, falt Kornelius på kne for ham og tilba ham. ");
INSERT INTO norlb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peter dro ham opp og sa: ”Reis deg opp! Jeg er et vanlig menneske akkurat som du!” ");
INSERT INTO norlb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Så snakket de med hverandre og gikk sammen inn i det rommet der de andre var samlet. ");
INSERT INTO norlb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peter sa til alle: ”Som dere vet, er det forbudt for meg som jøde å ha omgang med noen fra et annet folk og besøke hjemmet deres på denne måten. Men Gud har vist meg at jeg aldri skal nedvurdere et annet menneske og anse det som uverdig i Guds øyne. ");
INSERT INTO norlb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Derfor fulgte jeg med uten til å protestere da dere sendte bud etter meg. Si meg nå hva det er dere vil.” ");
INSERT INTO norlb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelius svarte: ”For tre dager siden, da jeg som vanlig ba her hjemme ved tretiden på ettermiddagen, sto plutselig en mann kledd i skinnende klær foran meg. ");
INSERT INTO norlb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Han sa til meg: ’Kornelius, Gud har hørt bønnene og sett gavene dine til de fattige. ");
INSERT INTO norlb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Send nå noen menn av sted til Joppe og hent hit en mann som heter Simon Peter. Han bor i et hus nede ved havet, hos en mann som heter Simon og som arbeider med å garve skinn.’ ");
INSERT INTO norlb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Derfor sendte jeg straks bud etter deg, og jeg er svært takknemlig for at du ville komme. Nå er vi alle samlet her for Herren Gud og venter med iver på å høre hva han har gitt deg i oppdrag å si!” ");
INSERT INTO norlb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Da svarte Peter: ”Jeg ser nå helt klart at Gud behandler alle folk likt. ");
INSERT INTO norlb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Han er villig til å ta imot hvert menneske som tilber ham og som lever i tråd med hans vilje. Det er det samme hvilket folk den enkelte tilhører. ");
INSERT INTO norlb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dere har sikkert hørt om de glade nyhetene som har blitt meddelt Israels folk, at de kan få fred med Gud ved Jesus Kristus som er Herre for alle. ");
INSERT INTO norlb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Dere kjenner til det som skjedde etter at døperen Johannes sto fram og begynte å tale til folket, hvordan det hele startet oppe i Galilea og så spredde seg over hele Judea. ");
INSERT INTO norlb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dere kjenner til at Gud fylte Jesus fra Nasaret med sin Hellige Ånd og ga ham kraft til den oppgaven han fikk, og at Jesus gikk omkring og gjorde godt og helbredet alle som var fanget i djevelens makt. Alt var mulig for Jesus etter som Gud var med ham. ");
INSERT INTO norlb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Vi som ble valgt ut til å bli Jesus sine nære disipler, har selv sett alt det han gjorde, både rundt i landet og i Jerusalem. Vi kan vitne om at dette virkelig har skjedd. Denne mannen hengte de på et kors og henrettet ham. ");
INSERT INTO norlb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","På den tredje dagen vakte Gud ham opp fra de døde. Gud lot ham vise seg etter oppstandelsen. ");
INSERT INTO norlb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ikke for hele folket, men bare for oss som Gud på forhånd hadde valgt ut til å spre budskapet om Jesus. Det var sammen med oss Jesus spiste og drakk etter at han hadde stått opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Han sendte oss av sted for å fortelle folk alle steder at han er den som har fått oppdraget fra Gud til å være dommer over alle, både levende og døde. ");
INSERT INTO norlb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Alle profetene som har båret fram Guds budskap om ham, har fortalt at hver og en som tror på ham skal få syndene sine tilgitt gjennom det han har gjort for oss.” ");
INSERT INTO norlb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mens Peter enda talte, kom plutselig Guds Hellige Ånd og fylte alle som lyttet til budskapet hans. ");
INSERT INTO norlb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","De troende jødene som hadde kommet dit sammen med Peter, ble forskrekket over at Guds Hellige Ånd hadde kommet over alle disse menneskene. De hadde trodd at Guds Ånd bare var en gave til jødene. ");
INSERT INTO norlb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Men nå rådde det ikke lenger noen tvil om saken, for de hørte alle tale fremmede språk og hylle Gud. ");
INSERT INTO norlb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Da spurte Peter: ”Er det noen her som synes det er galt at vi døper, nå når de har fått Guds Hellige Ånd på samme måte som vi?” ");
INSERT INTO norlb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Så lot han medarbeiderne sine døpe alle, etter som de hadde fått fellesskap med Jesus Kristus. Kornelius ba at Peter måtte stanse hos dem noen dager. ");
INSERT INTO norlb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Snart fikk utsendingene og de andre troende i Judea høre at også andre folk hadde tatt imot budskapet om Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Da Peter kom tilbake til Jerusalem, begynte de troende jødene å anklage ham og si: ");
INSERT INTO norlb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","”Hvorfor har du besøkt slike som ikke er jøder? Du har til og med spist sammen med dem.” ");
INSERT INTO norlb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Da fortalte Peter det som hadde skjedd. Han sa: ");
INSERT INTO norlb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","”En dag, da jeg var i byen Joppe, kom Guds Ånd over meg mens jeg ba og jeg fikk se et syn. Jeg så noe som lignet en stor duk bli senket ned fra himmelen. Duken var festet i sine fire hjørner og kom helt ned til meg. ");
INSERT INTO norlb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Da jeg undersøkte den nærmere, fikk jeg se at den inneholdt alle slags ville og tamme dyr, både slike som flyr og slike som lever på land. ");
INSERT INTO norlb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jeg hørte en stemme si: ’Peter, reis deg opp, slakt og spis.’ ");
INSERT INTO norlb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Jeg svarte: ’Nei, aldri, Herre. Jeg har aldri spist noe som Gud har forbudt i Moseloven.’ ");
INSERT INTO norlb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Men stemmen fra himmelen hørte jeg på nytt, som sa: ’Dersom Gud har gjort noe tillatt, skal ikke du behandle det som forbudt.’ ");
INSERT INTO norlb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Dette skjedde tre ganger, og så ble alt sammen dratt opp til himmelen igjen. ");
INSERT INTO norlb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","I samme øyeblikk kom tre menn til huset der vi var. De hadde blitt sendt fra Cæsarea for å hente meg. ");
INSERT INTO norlb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Guds Ånd sa til meg at jeg skulle følge med uten å bekymre meg for at de ikke var jøder. Disse seks mennene fra menigheten i Joppe fulgte også med meg, og vi kom hjem til den mannen som hadde sendt delegasjonen til Joppe. ");
INSERT INTO norlb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mannen fortalte at en engel hadde vist seg for ham hjemme i huset og sagt til ham: ’Send bud til Joppe og hent Simon Peter. ");
INSERT INTO norlb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Han har noe å fortelle som kan frelse både deg og de andre i huset ditt.’ ");
INSERT INTO norlb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jeg rakk ikke mer enn å begynne å tale, før Guds Hellige Ånd kom og fylte alle, akkurat som den fylte oss den første tiden. ");
INSERT INTO norlb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Da husket jeg at Herren Jesus hadde sagt: ’Johannes døpte dere med vann, men dere skal bli døpt med Guds Hellige Ånd.’ ");
INSERT INTO norlb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Etter som Gud ga alle disse fremmede den samme gaven som han ga til oss jøder som tror på Herren Jesus Kristus, hva kunne da jeg gjøre med det?” ");
INSERT INTO norlb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Da de andre hørte dette, var det slutt på innvendingene deres. De begynte å hylle Gud og sa: ”Tenk at Gud også har gitt andre folk sjansen til å vende seg bort fra synden og få evig liv.” ");
INSERT INTO norlb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","De troende fra Jerusalem, som hadde blitt spredd under den forfølgelsen som startet etter Stefanus sin død, hadde nå kommet helt til Fønikia, Kypros og Antiokia. De hadde underveis spredd budskapet om Jesus bare til jødene. ");
INSERT INTO norlb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Noen av de troende, som var fra Kypros og Kyréne, reiste til Antiokia. De fortalte de glade nyhetene om Herren Jesus Kristus også til noen som ikke var jøder. ");
INSERT INTO norlb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gud ga dem kraft, slik at et stort antall mennesker kom til tro og begynte å følge Herren. ");
INSERT INTO norlb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ryktet om dette nådde etter en tid menigheten i Jerusalem som straks sendte Barnabas dit. ");
INSERT INTO norlb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Da han kom fram til Antiokia og fikk se det Gud i sin godhet hadde gjort i byen, ble han glad og oppfordret de troende til å holde seg til Herren Jesus av hele sitt hjerte. ");
INSERT INTO norlb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas var en god mann, fylt av Guds Hellige Ånd og sterk i troen. Derfor fikk han være med å vinne enda flere for Herren. ");
INSERT INTO norlb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Etter dette reiste Barnabas videre til Tarsus for å lete opp Saulus. ");
INSERT INTO norlb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Da han hadde funnet ham, tok han Saulus med tilbake til Antiokia. Der stanset de i menigheten et helt år og underviste et stort antall mennesker. Det var i Antiokia at disiplene for første gangen fikk navnet kristne. ");
INSERT INTO norlb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","På denne tiden kom noen personer dit fra Jerusalem. Gud hadde gitt dem evner til å holde fram budskapet fra ham. ");
INSERT INTO norlb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","En som het Agabus, ble drevet av Guds Ånd til å reise seg opp i et møte og forutsi at en alvorlig sultekatastrofe ville ramme hele Romerriket. Den inntrådte i regjeringstiden til keiser Claudius. ");
INSERT INTO norlb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Disiplene i Antiokia besluttet derfor å sende hjelp til de troende i Judea. Hver og en skulle gi så mye han hadde råd til. ");
INSERT INTO norlb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","De samlet sammen gavene og overlot alt til Barnabas og Saulus, som fikk i oppdrag å overlevere gavene til lederne i menighetene i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Omtrent på samme tiden begynte kong Herodes å arrestere og å mishandle flere av medlemmene i menigheten. ");
INSERT INTO norlb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Han lot Jakob, som var bror til Johannes, bli halshugget med sverd. ");
INSERT INTO norlb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Da han så at de religiøse lederne var tilfreds med dette, arresterte han også Peter. Dette skjedde samtidig som påskehøytiden ble feiret. ");
INSERT INTO norlb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Etter arrestasjonen satte han Peter i fengsel og lot fire vaktskift med fire mann i hvert skift bevokte ham. Herodes hadde tenkt at når påsken var over, skulle han føre Peter fram for folket og la de dømme ham. ");
INSERT INTO norlb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mens Peter var kastet i fengslet, ba menigheten intenst om at Gud skulle bevare ham. ");
INSERT INTO norlb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Natten før han skulle bli stilt for retten, lå Peter og sov, lenket fast mellom to soldater, og utenfor celledøren var det andre soldater som voktet fengslet. ");
INSERT INTO norlb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Da ble cellen plutselig fylt av lys, og en engel fra Herren sto der. Engelen støtte Peter i siden, vekket ham og sa: ”Reis deg opp, kvikt!” I samme øyeblikk falt lenkene fra hendene til Peter. ");
INSERT INTO norlb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Engelen fortsatte: ”Ta på deg beltet og sandalene”. Mens Peter gjorde det, sa engelen: ”Bra, svøp nå kappen om deg og følg meg.” ");
INSERT INTO norlb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter fulgte med engelen ut av cellen, men han trodde hele tiden at det var et syn og ikke noe som skjedde i virkeligheten. ");
INSERT INTO norlb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","De passerte først en vaktpost og så en til, og var til slutt framme ved jernporten som førte ut til byen. Porten åpnet seg for dem helt av seg selv, det var bare å gå rett ut! Da de hadde gått nedover gaten et lite stykke, var plutselig engelen borte! ");
INSERT INTO norlb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Da Peter hadde roet seg litt, sa han til seg selv: ”Dette må likevel være virkelighet! Herren sendte virkelig sin engel og reddet meg fra Herodes, og fra alt det som jødene hadde ventet skulle ramme meg.” ");
INSERT INTO norlb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Da han var helt seg selv igjen, gikk han hjem til Maria, som var mor til Johannes Markus. Der var hele huset fullt av troende som ba til Gud. ");
INSERT INTO norlb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter dundret på porten, og en jente som het Rode, kom for å låse opp. ");
INSERT INTO norlb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Da hun kjente igjen Peter sin stemme, ble hun så glad at hun glemte å åpne. I stedet sprang hun inn i huset igjen og fortalte til alle at Peter sto utenfor på gaten. ");
INSERT INTO norlb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","”Du er fullstendig fra sans og samling”, ropte de. Men hun ga seg ikke, og de sa: ”Det er kanskje hans engel.” ");
INSERT INTO norlb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","I mens fortsatte Peter å dundre på døren. Da de endelig åpnet og så at det virkelig var ham, ble de fra seg av overraskelse. ");
INSERT INTO norlb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Han ga tegn om at de skulle være stille og fortalte hvordan Herren hadde ført ham ut av fengslet. Til slutt sa han: ”La Jakob og de andre i menigheten få vite hva som har skjedd”, og så gikk han videre til et annen sted. ");
INSERT INTO norlb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Da morgenen kom, ble det stor oppstandelse blant soldatene i fengslet. Ingen kunne fatte hva som hadde skjedd med Peter. ");
INSERT INTO norlb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Da Herodes sendte bud etter Peter og ikke fikk tak i ham, satte han i verk forhør av vaktene og dømte samtlige til døden. Etter dette dro Herodes fra Judea og ned til Cæsarea for å bo der. ");
INSERT INTO norlb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Innbyggerne i Tyrus og Sidon, som var avhengige av å bli supplert med mat fra Herodes sitt distrikt, hadde gjort Herodes sint. Forholdet hadde lenge vært spent mellom dem. De sendte derfor en felles delegasjon til Herodes for å be om fred. De lyktes med å få kongens kammerherre Blastus på sin side. ");
INSERT INTO norlb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","De fikk løfte om å treffe Herodes. På den fastsatte dagen tok Herodes på seg den kongelige kappen, satte seg på troen og talte til dem. ");
INSERT INTO norlb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Folket hyllet ham og ropte: ”Det er en gud som taler og ikke noe menneske!” ");
INSERT INTO norlb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","I samme øyeblikk lot Herren en engel gjøre Herodes syk, etter som Herodes tok imot tilbedelse fra mennesker i stedet for å gi Gud æren. Han ble spist opp av ormer og døde. ");
INSERT INTO norlb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Budskapet om Jesus spredde seg til flere og flere. Mange mennesker kom til tro. ");
INSERT INTO norlb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Siden Barnabas og Saulus hadde fullført oppdraget sitt i Jerusalem vendte de tilbake til Antiokia og tok Johannes Markus med seg. ");
INSERT INTO norlb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","I menigheten i Antiokia var det profeter som bar fram budskap fra Gud, og andre som underviste. Det var: Barnabas, Simeon, som også ble kalt ”den svarte”, Lukius fra Kyréne, Manaen, som var pleiebror til fyrst Herodes, og Saulus. ");
INSERT INTO norlb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","En gang da disse mennene tilba Herren og fastet, sa Guds Hellige Ånd: ”Velg ut Barnabas og Saulus til en spesiell oppgave som jeg har valgt dem ut for.” ");
INSERT INTO norlb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Da de hadde fastet og bedt ytterligere en gang, la de hendene på de to og sendte dem ut på oppdraget. ");
INSERT INTO norlb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Etter at Barnabas og Saulus var blitt sendt ut av Guds Hellige Ånd, reiste de ned til Seleukia og seilte over til Kypros. ");
INSERT INTO norlb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Den første byen de kom til, het Salamis. Der fant de fram til de jødiske synagogene og talte til folket om Jesus. Johannes Markus fulgte med som medarbeider. ");
INSERT INTO norlb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","De reiste fra by til by på hele øya og talte. Til slutt kom de til Pafos. Der møtte de en jødisk trollmann som het Barjesus. Han påsto at han kunne bringe budskap fra Gud. ");
INSERT INTO norlb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Han brukte ofte å besøke den romerske landshøvdingen Sergius Paulus, som var en svært klok og forstandig mann. Landshøvdingen ba nå Barnabas og Saulus hjem til seg, etter som han ville høre budskapet om Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Men trollmannen, som også ble kalt Elymas, motarbeidet dette og forsøkte å hindre landshøvdingen fra å tro. ");
INSERT INTO norlb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Da ble Saulus, som også ble kalt Paulus, fylt av Guds Hellige Ånd. Han satte øynene i trollmannen og sa: ");
INSERT INTO norlb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","”Du djevelens sønn, full av bedrageri og falskhet, en fiende til alt som er godt, vil du aldri slutte med å forvrenge budskapet om Herren Jesus? ");
INSERT INTO norlb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Men nå har Herren bestemt at du skal bli straffet. Du skal bli totalt blind en tid.” I samme øyeblikk senket det seg tåke og mørke over trollmannen. Hjelpeløs begynte han å gå omkring og lete etter noen som kunne holde ham i hånden og føre ham fram. ");
INSERT INTO norlb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Da landshøvdingen så det som skjedde, begynte han å tro. Han var helt forundret over det han hadde fått lære om Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus og følget hans reiste fra Pafos og seilte til Perge i provinsen Pamfylia. Der forlot de Johannes Markus og reiste tilbake til Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Barnabas og Paulus fortsatte til Antiokia, en by i provinsen Pisidia. Da det ble hviledag, gikk de til synagogen for å være med på gudstjenesten. ");
INSERT INTO norlb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Etter den vanlige opplesningen av Moseloven og profetene, snudde forstanderne for synagogen seg mot Paulus og Barnabas og sa: ”Brødre, om dere har noe å bidra med som kan være oss til hjelp, så kom fram og si det!” ");
INSERT INTO norlb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Da reiste Paulus seg, ga tegn til alle om å være stille og sa: ”Israelitter, og alle andre her som tilber Gud! Hør på meg! ");
INSERT INTO norlb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israels Gud valgte seg ut forfedrene våre til å være hans eget folk. Han lot dem bli et stort folk mens de bodde som fremmede i Egypt. I sin tid førte han folket ut derfra på en mektig måte og reddet dem fra slaveriet. ");
INSERT INTO norlb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","I 40 år hadde Gud tålmodighet mens de gikk i ørkenen. ");
INSERT INTO norlb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Han utryddet sju folk i Kanaan og ga landet deres til israelittene. ");
INSERT INTO norlb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Alt dette tok omkring 450 år. Etter det lot han forskjellige dommere herske over folket, fram til den tiden da profeten Samuel styrte Israel. ");
INSERT INTO norlb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Folket tigget om å få en konge, og Gud ga dem Saul, som var sønn av Kis, en mann av Benjamins stamme. Han regjerte i 40 år. ");
INSERT INTO norlb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Men Gud avsatte ham og lot David bli konge i stedet. Gud sa om ham: ’Jeg har funnet David, Isais sønn, en mann som følger min vilje. Han vil gjøre alt det jeg sier til ham.’ ");
INSERT INTO norlb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Gud lovet kong David at en av etterkommerne hans skulle bli en frelser for Israels folk. Det er dette som nå har blitt virkelighet. Jesus er den som frelser oss. ");
INSERT INTO norlb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Før Jesus trådte fram, forberedte døperen Johannes Israels folk ved å oppfordre alle til å forlate synden, vende om til Gud og la seg døpe. ");
INSERT INTO norlb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Da oppgaven til Johannes nærmet seg slutten, sa han: ’Jeg er ikke den personen som Gud har lovet for å frelse dere. Han kommer etter meg, og han er så mektig at jeg ikke en gang er verdig til å knytte opp remmene på sandalene hans.’ ");
INSERT INTO norlb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Hør etter det jeg sier, dere som er etterkommere av Abraham, og alle andre som tilber Gud! Denne frelse gjelder oss alle. ");
INSERT INTO norlb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Folket i Jerusalem og lederne deres forsto ikke hvem Jesus var. De skjønte ikke at han var den som Gud talte om ved profetene, til tross for at de hadde hørt profetene sitt budskap bli lest hver uke på hviledagen. Derfor dømte de ham til døden, og gjennom det som skjedde, ble det til virkelighet som Gud hadde forutsagt. ");
INSERT INTO norlb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ja, til tross for at de ikke kunne finne noen gyldig grunn til å henrette ham, ba de Pilatus om å drepe ham. ");
INSERT INTO norlb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Da de hadde sluttført alt som står i Skriften når det gjelder Jesu død, tok de ham ned fra korset og la ham i en grav. ");
INSERT INTO norlb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Men Gud vakte ham opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jesus viste seg mange ganger i de følgende dagene for dem som hadde fulgt ham fra Galilea til Jerusalem. Det er disse som nå forteller om ham for Israels folk. ");
INSERT INTO norlb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Nå har turen kommet til dere. Vi er her for å fortelle de glade nyhetene om at Gud, nettopp i våre dager, har innfridd løftet sitt til forfedrene ved å vekke Jesus opp fra de døde. Det er om ham den andre salmen i Salmenes bok forteller, når den sier: ’Du er min sønn. I dag har jeg blitt din Far.’ ");
INSERT INTO norlb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","For Gud hadde lovet at Jesus skulle stå opp fra de døde og aldri mer behøve å dø. Det forklarte han med ordene: ’Jeg skal innfri mitt Hellige og pålitelige løfte og gi dere alt det gode jeg lovet David.’ ");
INSERT INTO norlb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Det løfte han tenkte på, var dette: ’Du skal ikke la din Hellige tjener gå til grunne.’ ");
INSERT INTO norlb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dette løfte handler ikke om David, for da David hadde tjent folket i trå med Guds vilje, døde han, ble begravd, og kroppen hans gikk til grunne. ");
INSERT INTO norlb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nei, det handler om en annen, en som Gud vakte opp fra de døde, der kroppen ikke gikk til grunne. ");
INSERT INTO norlb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mine venner, hør etter på det jeg har å si! Det er ved denne mannen, Jesus, som dere kan få tilgivelse for syndene deres. ");
INSERT INTO norlb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Alle som tror på ham, blir skyldfri innfor Gud, noe dere aldri kunne oppnå gjennom det å følge Moseloven. ");
INSERT INTO norlb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Derfor må dere passe nøye på. Ikke la dere bli rammet av det Gud advarer dere mot ved profetene: ");
INSERT INTO norlb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","’Pass nøye på, dere som håner sannheten. Dere vil undre dere og bli til intet. Jeg vil gjøre noe stort i deres tid, noe som dere ikke kommer til å tro den dagen de forteller det for dere.’ ” ");
INSERT INTO norlb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Da gudstjenesten var over og Paulus og Barnabas dro fra synagogen, ba folket at de måtte komme tilbake neste uke på hviledagen, slik at de kunne få høre mer. ");
INSERT INTO norlb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mange jøder, og andre som tilba Israels Gud, passet på å holde seg nær Paulus og Barnabas som talte til dem og oppfordret: ”Fortsett å leve fast forankret i Guds godhet og tilgivelse.” ");
INSERT INTO norlb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","På hviledagen en uke seinere, kom nesten hele byen for å høre budskapet om Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Da de religiøse lederne så alt folket, ble de misunnelse og begynte å håne Paulus og latterliggjøre alt han sa. ");
INSERT INTO norlb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paulus og Barnabas svarte uten å nøle: ”Dere jøder skulle være de første som fikk sjansen til å høre budskapet om Herren Jesus, men etter som dere avviser tilbudet og gjør dere selv uverdige til det evige livet, så vender vi oss nå til andre folk. ");
INSERT INTO norlb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Det er også det Herren har gitt oss befaling om, for det står i Skriften: ’Jeg har gjort deg til et lys for alle folk, for at du skal frelse alle på hele jorden.’ ” ");
INSERT INTO norlb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Da de som ikke var jøder, hørte dette, ble de svært glade og hyllet budskapet om Herren Jesus. Alle som var utsett til evig liv, begynte å tro. ");
INSERT INTO norlb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","De glade nyhetene om Herren spredde seg i hele området. ");
INSERT INTO norlb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Men de religiøse lederne hisset opp de høytstående kvinnene som tilba Israels Gud. De ledende mennene i byen satte i gang en forfølgelse mot Paulus og Barnabas og drev dem bort fra området. ");
INSERT INTO norlb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Begge ristet da støvet fra byens gater av føttene sine og bekymret seg ikke mer for innbyggerne, men fortsatte til byen Ikonium. ");
INSERT INTO norlb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Disiplene ble fylt av glede og Guds Hellige Ånd. ");
INSERT INTO norlb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","I byen Ikonium skjedde det samme. Paulus og Barnabas gikk til synagogen og talte til folket med slik kraft at mange, både jøder og de som ikke var jøder, kom til tro. ");
INSERT INTO norlb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Men de jødene som ikke ville tro, hisset opp innbyggerne i byen som ikke var jøder ved å snakke dårlig om Paulus og Barnabas. ");
INSERT INTO norlb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Til tross for det stanset de en lenger tid og talte åpent og uten frykt om Herren Jesus, etter som de stolte på at han ville beskytte dem. Herren Jesus ga dem kraft til å gjøre mirakler og tegn som et bevis på at budskapet hans om kjærlighet og tilgivelse var sant. ");
INSERT INTO norlb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Folket i byen delte seg i to grupper: Noen holdt med de religiøse lederne, andre holdt med utsendingene. ");
INSERT INTO norlb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6","Etter en tid fikk Paulus og Barnabas greie på at jødene sammen med sine ledere, også de som ikke var jøder, hadde blitt enige om å mishandle og steine Paulus og Barnabas. De flyktet derfor til byene Lystra og Derbe i provinsen Lykaonia. Der dro de omkring i hele området ");
INSERT INTO norlb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","og fortalte de glade nyhetene om Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mens Paulus og Barnabas var i Lystra, møtte de en mann som hadde vært handikappet fra fødselen av, og som aldri hadde kunne gå. ");
INSERT INTO norlb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mannen satt og lyttet da Paulus talte, og da Paulus så på ha, forsto han at mannen hadde begynt å tro, og at han kunne bli helbredet. ");
INSERT INTO norlb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Derfor ropte Paulus til ham: ”Reis deg opp og stå på beina dine!” Straks hoppet mannen opp og begynte å gå. ");
INSERT INTO norlb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Da folket så det Paulus hadde gjort, ropte de høyt på sitt eget språk: ”Gudene har blitt mennesker og kommet ned til oss!” ");
INSERT INTO norlb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","De trodde at Barnabas var den greske guden Zevs, og at Paulus var Hermes, etter som det var han som førte ordet. ");
INSERT INTO norlb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Presten i zevstemplet, som lå i utkanten av byen, kom med okser og blomsterkranser, som han og folket ville ofre til utsendingene foran byens port. ");
INSERT INTO norlb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Men da det gikk opp for Barnabas og Paulus hva som var i ferd med å skje, rev de i stykker kappene sine og rutsjet rett inn i folkemassen og ropte: ");
INSERT INTO norlb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","”Kjære venner, hva er det dere finner på? Vi er vanlige mennesker akkurat som dere! Vi har kommet til dere for å fortelle de glade nyhetene at dere ikke lenger trenger å vende dere til disse hjelpeløse gudene. I stedet kan dere nå tilbe den Gud som lever, han som har skapt himmelen og jorden og havet og alt som finnes i tilværelsen. ");
INSERT INTO norlb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Fram til nå har Gud latt folkene fortsette å be til forskjellige guder. ");
INSERT INTO norlb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Likevel har Gud gjennom alt det gode han gjør, jevnt og trutt gitt sine bevis på at han er til. Det er han som har gitt dere regn og gode avlinger, slik at dere har fått mat og kunne glede dere.” ");
INSERT INTO norlb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ved å markere dette klarte Paulus og Barnabas i siste sekund å hindre folket fra å ofre til dem. ");
INSERT INTO norlb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Litt seinere kom noen jøder fra Antiokia og Ikonium og klarte å vende folket mot Paulus og Barnabas. Folket steinet Paulus, slik at de trodde han var død. De slepte ham ut av byen. ");
INSERT INTO norlb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Men da disiplene samlet seg rundt ham, reiste han seg opp og gikk på nytt inn i byen. Neste dag gikk han videre til byen Derbe sammen med Barnabas. ");
INSERT INTO norlb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Også i Derbe fortalte Paulus og Barnabas de glade nyhetene om Jesus, og mange mennesker begynte å tro. Senere vendte de tilbake til byene Lystra, Ikonium og Antiokia. ");
INSERT INTO norlb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Der styrket de disiplene. De oppmuntret dem til å holde fast ved troen til tross for alle forfølgelsene, og sa: ”Vi som er Guds folk, får oppleve mange vanskeligheter, men en dag skal vi være med ham i hans nye verden.” ");
INSERT INTO norlb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulus og Barnabas så seg ut ledere for menigheten på hvert sted. De fastet og ba til Herren Jesus at han skulle beskytte dem som nylig hadde begynt å tro på ham. ");
INSERT INTO norlb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Så reiste Paulus og Barnabas tilbake gjennom provinsene Pisidia og Pamfylia. ");
INSERT INTO norlb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","De kom til byen Perge på reisen. Der talte de til folket om Jesus. Etter det fortsatte de til havnebyen Attalia. ");
INSERT INTO norlb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","De tok en båt over til Antiokia i Syria. Det var i denne byen menigheten hadde overlatt Paulus og Barnabas til Gud og hans beskyttelse. Senere hadde de sendt de to av sted på det oppdraget som nå var avsluttet. ");
INSERT INTO norlb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Da de hadde kommet, kalte de sammen hele menigheten og fortalte alt Gud hadde satt dem i stand til å utrette, og hvordan han også hadde gitt andre enn jødene sjansen til å tro. ");
INSERT INTO norlb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","De stanset en ganske lang tid hos de troende i Antiokia. ");
INSERT INTO norlb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mens Paulus og Barnabas var i Antiokia, kom noen personer fra Judea. De begynte å lære de troende at de ikke kunne bli frelst dersom de ikke fulgte den jødiske tradisjonen med omskjærelse slik det står i Moseloven. ");
INSERT INTO norlb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Men Paulus og Barnabas motsa det de lærte. Det førte til mange harde diskusjoner og mye strid. Til slutt bestemte derfor de troende at de skulle la Paulus og Barnabas, og noen i tillegg, reise opp til Jerusalem for å drøfte spørsmålene med utsendingene og lederne i menigheten der. ");
INSERT INTO norlb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","De utrustet dem for reisen og lot dem reise av sted. På veien stanset de i Fønikia og Samaria og fortalte de troende at også mange som ikke var jøder, hadde vendt seg til Gud. Dette gjorde de troende svært begeistret. ");
INSERT INTO norlb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Da de kom fram til Jerusalem, ble de hjertelig mottatt av menigheten, utsendingene og lederne. Paulus og Barnabas fortalte om det Gud hadde utrettet gjennom deres forkynnelse. ");
INSERT INTO norlb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Da reiste noen menn seg, de hadde vært fariseere før de ble disipler, og påsto at alle troende menn som ikke var jøder, måtte bli omskåret, og at de måtte kreve at alle fulgte Moseloven. ");
INSERT INTO norlb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Disiplene og lederne i menighetene holdt et eget møte om dette spørsmålet. ");
INSERT INTO norlb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Etter en lang diskusjon reiste Peter seg og sa: ”Brødre, dere vet alle at Gud for lenge siden så seg ut meg til å fortelle de glade nyhetene om Jesus for andre enn jøder, slik at de også kunne tro. ");
INSERT INTO norlb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Gud, som kjenner tankene til menneskene, har vist at han tar imot alle ved å gi dem sin Hellige Ånd på samme måte som han ga den til oss. ");
INSERT INTO norlb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gud har ikke gjort noen forskjell mellom oss og dem, men har akseptert alle fullt og helt da de vendte om og begynte å tro. ");
INSERT INTO norlb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hvorfor stiller dere spørsmål om det Gud har gjort? Hvorfor krever dere at disse disiplene skal lyde en lov som både vi og forfedrene våre har hatt vanskelig for å holde? ");
INSERT INTO norlb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nei, vi tror at alle, både vi og de, blir frelst ved vår Herre Jesu kjærlighet og tilgivelse, den som ingen har gjort seg fortjent til.” ");
INSERT INTO norlb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Etter dette ble det slutt på diskusjonen, alle lyttet til Barnabas og Paulus da de fortalte om alle miraklene og tegnene som Gud hadde utrettet blant andre folk. ");
INSERT INTO norlb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Da de hadde snakket ferdig, reiste Jakob seg og sa: ”Brødre, hør på meg. ");
INSERT INTO norlb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Peter har fortalt oss hvordan det skjedde første gangen en gruppe mennesker som ikke er jøder, takket ja til Guds innbydelse om å tilhøre ham. ");
INSERT INTO norlb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Andre folk vender om til Gud, noe som stemmer godt overens med det budskap Gud bar fram ved profetene. Det står for eksempel: ");
INSERT INTO norlb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","’Jeg vil vende tilbake og bygge opp Davids falne hus. Jeg vil reise opp det som ligger i ruiner. ");
INSERT INTO norlb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Da kan alle mennesker søke Herren, ja, alle folk som jeg har innbudt for å tilhøre meg. Det er Herren som sier dette, som gjorde alt ");
INSERT INTO norlb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","kjent for lenge siden.’ ");
INSERT INTO norlb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jeg mener derfor at vi ikke skal sette en masse krav til folkene som vender seg til Gud. ");
INSERT INTO norlb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Det rekker med at vi skriver og understreker at de skal la være å spise mat som er ofret til avgudene, at de skal avholde seg fra seksuell løssluppenhet og ikke spise kjøtt fra kvalte dyr eller noe annet som fortsatt har blodet i seg. ");
INSERT INTO norlb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","I Moseloven blir alt undervist gjennom alle tider, og hver uke på hviledagen leser de fra den i de jødiske synagogene.” ");
INSERT INTO norlb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Utsendingene og lederne besluttet, sammen med hele menigheten, at de skulle sende noen representanter til Antiokia sammen med Paulus og Barnabas for å fortelle resultatet av drøftingene. De personene som ble valgt ut, var to av lederne i menigheten: Judas, som ble kalt Barsabbas og Silas. ");
INSERT INTO norlb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Slik lød brevet de fikk med seg: ”Fra utsendingene og lederne i menighetene i Jerusalem, til de troende som ikke er jøder i Antiokia, Syria og Kilikia. Vi hilser dere hjertelig! ");
INSERT INTO norlb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Vi har fått vite at noen fra vår menighet har skapt uro og forvirring blant dere med sin undervisning. Disse personene var ikke sendt ut av oss. ");
INSERT INTO norlb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Vi har derfor enstemmig besluttet å velge to offisielle representanter og sende dem til dere sammen med våre elskede brødre Barnabas og Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Disse to har våget livene sine for vår Herre Jesus Kristi skyld. ");
INSERT INTO norlb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Våre representanter, Judas og Silas, kommer til å fortelle mer om det vi har besluttet, i dette spørsmålet. ");
INSERT INTO norlb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Guds Hellige Ånd og vi har besluttet ikke å kreve noe annet av dere enn at dere lar være å spise mat som er ofret til avgudene, at dere ikke spiser kjøtt fra kvalte dyr eller noe annet som fortsatt har blodet i seg, og at dere avholder dere fra seksuell løssluppenhet. Dersom dere nøye følger dette, handler dere rett. Vi ønsker dere alt godt!” ");
INSERT INTO norlb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","De fire mennene reiste straks til Antiokia. Der kalte de sammen alle de troende til et stort møte og overleverte brevet. ");
INSERT INTO norlb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Da menighetens ledere hadde lest brevet, ble alle svært glade over denne oppmuntrende beskjeden. ");
INSERT INTO norlb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas og Silas, som begge hadde fått evner av Gud til å holde fram budskapet fra ham, talte lenge til menigheten og oppmuntret og styrket medlemmene i troen. ");
INSERT INTO norlb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Da de hadde vært der en tid, reiste Judas og Silas tilbake til sin menighet. Menigheten i Antiokia ønsket dem fred fra Gud. ");
INSERT INTO norlb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus og Barnabas stanset i Antiokia, der de sammen med mange andre underviste og spredde budskapet om Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Etter en tid sa Paulus til Barnabas: ”Synes ikke du også at vi burde reise tilbake til alle de stedene der vi har talt budskapet om Herren Jesus, for å se hvordan det går med de troende?” ");
INSERT INTO norlb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas var enig med ham og foreslo at de skulle ta med seg Johannes Markus. ");
INSERT INTO norlb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Men Paulus var helt uenig i dette, etter som Johannes Markus hadde reist fra dem i Pamfylia og ikke blitt med videre i arbeidet deres. ");
INSERT INTO norlb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","De ble faktisk så ueinge i dette spørsmålet at de skilte lag. Barnabas tok med seg Johannes Markus og seilte til Kypros. ");
INSERT INTO norlb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus derimot valgte Silas som medarbeider. Etter at de troende hadde overlatt dem til Herren Jesus og hans beskyttelse, ");
INSERT INTO norlb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","reiste de gjennom Syria og Kilikia for å oppmuntre menighetene der. ");
INSERT INTO norlb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus og Silas kom først til Derbe og så til Lystra. Der møtte de en disippel som het Timoteus. Han var en ung mann, sønn til en kristen jødinne som var gift med en mann som ikke var jøde, og altså far til Timoteus. ");
INSERT INTO norlb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","De troende i Lystra og Ikonium hadde bare godt å si om Timoteus. ");
INSERT INTO norlb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus ville derfor at han skulle bli med på reisen deres. Av hensyn til jødene i området omskar han Timoteus før de reiste videre, etter som alle visste at far hans ikke var jøde. ");
INSERT INTO norlb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","De reiste fra by til by og fortalte om det utsendingene og lederne i menighetene i Jerusalem hadde besluttet når det gjaldt troende fra andre folk, og hvilke regler de skulle følge. ");
INSERT INTO norlb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Menighetene ble styrket i troen, og for hver dag økte antallet på de troende. ");
INSERT INTO norlb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulus og følget hans reiste nå gjennom Frygia og Galatia, etter som Guds Hellige Ånd hadde sagt at de ikke skulle spre budskapet om Jesus i provinsen Asia denne gangen. ");
INSERT INTO norlb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Da de etter en tid kom fram til grensen mot Mysia, tenkte de å gå nordover mot Bitynia, men Jesu Ånd tillot dem ikke å reise dit. ");
INSERT INTO norlb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","De fortsatte derfor gjennom Mysia og kom til byen Troas. ");
INSERT INTO norlb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Der fikk Paulus se et syn om natten. Han så en mann fra Makedonia stå og rope på ham: ”Kom over til Makedonia og hjelp oss.” ");
INSERT INTO norlb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Derfor bestemte vi oss straks for å reise over til Makedonia, etter som vi forsto at Gud ville at vi skulle fortelle de glade nyhetene om Jesus også der. ");
INSERT INTO norlb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Vi gikk ombord i en båt som lå i Troas og seilte rett over til øya Samotrake og neste dag videre til Neapolis. ");
INSERT INTO norlb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Så fortsatte vi til Filippi, som er en romersk koloni og en av de viktige byene i Makedonia. Der stanset vi i flere dager. ");
INSERT INTO norlb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Da det ble hviledag, gikk vi ut av byen og ned til en elvebredd, der vi trodde de brukte å samle seg for å be på hviledagen. Vi satte oss ned og snakket med kvinnene som var kommet dit. ");
INSERT INTO norlb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","En av dem het Lydia. Hun kom fra byen Tyatira og handlet med purpurstøy. Hun var ikke jødinne, men tilba Israels Gud. Mens hun nå lyttet til oss, åpnet Herren Gud hjertet hennes, slik at hun tok imot alt som Paulus sa. ");
INSERT INTO norlb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hun lot seg døpe sammen med alle i huset sitt, og etterpå sa hun: ”Nå når dere ser at jeg virkelig tror på Herren Jesus, da må dere komme og bo hos meg.” Hun ga seg ikke før vi gjorde som hun sa. ");
INSERT INTO norlb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Da vi en dag var på vei til stedet der de brukte å be, møtte vi en slavejente som var besatt av en ond Ånd. Hun kunne spå mennesker og sopte inn mye penger til eierne sine. ");
INSERT INTO norlb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Jenten fulgte etter og ropte til Paulus og oss andre: ”Disse mennene er tjenere av den høyeste Guden og har kommet for å vise dere veien til frelse.” ");
INSERT INTO norlb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dette gjentok seg hver eneste dag, helt til Paulus en dag ble så irritert at han snudde seg om og sa til den onde ånden i henne: ”I kraften fra Jesus Kristus befaler jeg deg å fare ut av henne.” Straks forlot den onde ånden henne. ");
INSERT INTO norlb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Da eierne hennes så at de ikke lenger kunne tjene penger på jenta, grep de Paulus og Silas og slepte dem for byretten som holdt til på torget. ");
INSERT INTO norlb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","De førte Paulus og Silas fram for de romerske dommerne og sa: ”Disse jødene snur opp ned på hele byen. ");
INSERT INTO norlb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","De lærer folket å gjøre slikt som er imot den romerske loven.” ");
INSERT INTO norlb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Hele folkemassen begynte å angripe Paulus og Silas. Dommerne ga befaling om at de skulle kle av dem og slå dem med pisken. ");
INSERT INTO norlb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","De ble slått hardt og etterpå kastet i fengsel. Fangevokteren fikk befaling om å holde streng vakt over dem. ");
INSERT INTO norlb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Han tok derfor ingen sjanser, men plasserte dem i den innerste cellen. Der låste han fast føttene deres i en solid trestokk. ");
INSERT INTO norlb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Omkring midnatt satt Paulus og Silas og ba og sang lovsanger til Gud, mens de andre fangene lyttet. ");
INSERT INTO norlb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Da kom det plutselig et jordskjelv, som var så kraftig at fengslet ristet helt ned i grunnmuren. I samme øyeblikk sprang alle dørene opp, og lenkene falt av fangene. ");
INSERT INTO norlb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Da våknet fangevokteren. Da han fikk se at alle dørene til fengslet sto vidt åpne, trodde han at fangene hadde rømt og dro sverdet sitt for å ta sitt eget liv. ");
INSERT INTO norlb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Paulus ropte til ham: ”Stopp! Ikke gjør deg noe farlig! Alle sammen er her!” ");
INSERT INTO norlb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Da ba den vettskremte fangevokteren om lys og løp inn og kastet seg på kne foran Paulus og Silas. ");
INSERT INTO norlb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Så førte han dem ut av cellen og spurte: ”Hva skal jeg gjøre for å bli frelst?” ");
INSERT INTO norlb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","De svarte: ”Tro på Herren Jesus, så skal du bli frelst, både du og din familie.” ");
INSERT INTO norlb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Paulus og Silas fortalte budskapet om Herren Jesus for fangevokteren og hele familien hans. ");
INSERT INTO norlb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Fangevokteren tok straks hånd om dem og vasket sårene deres, til tross for at det var midt på natten. Og før natten var over, hadde hele familien latt seg døpe! ");
INSERT INTO norlb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Etterpå tok fangevokteren med seg Paulus og Silas opp til hjemmet sitt og bød på mat. Både han og familien var overlykkelige over at de hadde kommet til tro på Gud. ");
INSERT INTO norlb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Neste morgen sendte dommerne sine medarbeidere til fengslet for å meddele at mennene skulle slippes fri. ");
INSERT INTO norlb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Fangevokteren fortalte dette til Paulus og sa: ”Dommerne har besluttet til å gi dere fri, så nå trenger dere ikke å sitte her lenger. Gå i fred!” ");
INSERT INTO norlb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paulus svarte: ”Å, nei! Så lett kommer de ikke fra det! Uten lov og rett har de pisket oss offentlig og satt oss i fengsel til tross for at vi er romerske borgere. Og nå vil de at vi skal forlate fengslet i hemmelighet. Aldri! Be dem komme hit og selv sette oss fri.” ");
INSERT INTO norlb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Medhjelperne fortalte da dette til dommerne. Da de hørte at Paulus og Silas var romerske borgere, ble de skremt. ");
INSERT INTO norlb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Straks kom de til fengslet og begynte å unnskylde seg. De førte dem ut og bønnfalt dem om å forlate byen. ");
INSERT INTO norlb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulus og Silas gikk først til huset der Lydia bodde. Der møtte de alle de troende og oppmuntret dem. Deretter reiste de videre. ");
INSERT INTO norlb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus og Silas tok nå veien gjennom byene Amfipolis og Apollonia og kom til Tessaloniki, der jødene hadde en synagoge. ");
INSERT INTO norlb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulus gikk som vanlig dit, og i tre uker på rad talte han til folket på hviledagene. ");
INSERT INTO norlb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ved hjelp av Skriften forklarte han at Messias, den lovede kongen, måtte lide og stå opp fra de døde, og han beviste at Jesus er denne kongen. ");
INSERT INTO norlb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mange av dem som lyttet ble overbeviste og holdt seg til Paulus og Silas. Blant dem var en stor gruppe som ikke var jøder, men tilba Israels Gud. Også et antall betydningsfulle kvinner begynte å tro. ");
INSERT INTO norlb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Men de religiøse lederne ble misunnelige og samlet en flokk pøbler fra gaten og dro i gang et oppløp som skapte uroligheter i byen. De marsjerte fram mot huset til Jason, for å hente Paulus og Silas og dra dem ut til folkemassen. ");
INSERT INTO norlb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Da de ikke fant de to, slepte de i stedet Jason, og noen andre troende ut, og tok disse med til dommerne i byen og skrek: ”Paulus og Silas har snudd opp ned på hele verden, og nå er de her og steller i stand bråk. ");
INSERT INTO norlb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason har sluppet dem inn i huset sitt. Alle disse er skyldige i forræderi mot keiseren, for de påstår at det er en annen som er konge, en som heter Jesus.” ");
INSERT INTO norlb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Både dommerne og folket i byen ble bekymret over disse anklagene. ");
INSERT INTO norlb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jason og de andre ble ikke sluppet fri før de hadde betalt kausjon. ");
INSERT INTO norlb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Samme natten passet de troende på at Paulus og Silas ble sendt videre til byen Berøa. Og så fort de var kommet dit, la de veien til den jødiske synagogen. ");
INSERT INTO norlb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Folkene i Berøa var mer åpne for nye ideer enn de hadde vært i Tessaloniki. De lyttet mer enn gjerne til budskapet, og studerte hver dag i Skriften for å kontrollere at det Paulus og Silas sa, virkelig stemte. ");
INSERT INTO norlb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Resultatet ble at mange begynte å tro. Blant dem var flere høytstående kvinner og menn som ikke var jøder. ");
INSERT INTO norlb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Da jødene i Tessaloniki fikk greie på at Paulus spredde budskapet om Jesus også i Berøa, kom de etter og skapte uro og bråk blant folket også der. ");
INSERT INTO norlb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Derfor handlet de troende raskt og sendte Paulus ned til kysten, men både Silas og Timoteus ble værende igjen. ");
INSERT INTO norlb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","De som førte Paulus ned til kysten, seilte seinere med ham helt til Aten. Etter det vendte de tilbake til Berøa, og meldte til Silas og Timoteus at Paulus ønsket at de skulle skynde seg å følge etter ham. ");
INSERT INTO norlb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mens Paulus ventet på Silas og Timoteus, så han seg omkring i Aten. Han ble dypt rystet over alle avgudsbildene han oppdaget over alt i byen. ");
INSERT INTO norlb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Som vanlig besøkte han synagogen og talte til jødene, og de grekerne som tilba Israels Gud. Dessuten talte han hver dag på torget til alle som tilfeldigvis var der. ");
INSERT INTO norlb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Han diskuterte også med noen av filosofene, både epikureere og stoikere. Men da Paulus fortalte dem om Jesus og sa at han hadde stått opp fra de døde, sa noen: ”Hva er dette for slags underlige ideer han har snappet opp? Hva mener han?” Andre sa: ”Han forsøker å prakke på oss en fremmed religion.” ");
INSERT INTO norlb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","De førte ham med seg opp til Areopagos og sa: ”Kom og fortell mer for oss om denne nye religionen. ");
INSERT INTO norlb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Det er jo ganske merkelige ting du har å fortelle. Si oss hva dette handler om.” ");
INSERT INTO norlb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","En slik utspørring var ikke uvanlig, for både atenerne og de utlendingene som bodde der, brukte all sin tid til å diskutere de siste ideer og trender i tiden. ");
INSERT INTO norlb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulus stilte seg altså opp foran Areopagos og sa: ”Atenere, jeg har lagt merke til at dere er sterkt religiøse. ");
INSERT INTO norlb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mens jeg har spasert omkring her, har jeg sett mange altere. Ett av dem hadde mottoet: ’Til en ukjent gud’. Og det er denne guden jeg vil fortelle dere om, han som dere har tilbedt uten å vite hvem det er. ");
INSERT INTO norlb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Den Gud som har skapt verden og alt som finnes i den, han er Herre både over himmelen og jorden. Han bor ikke i noe tempel som er bygget av mennesker. ");
INSERT INTO norlb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Menneskene kan ikke tilfredsstille behovene hans, etter som han ikke har noen! Det er jo han selv som lar oss leve og puste, og som fyller alle våre behov. ");
INSERT INTO norlb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Han skapte alle folk og riker fra et eneste menneske og spredde dem ut over hele jordens overflate. Han bestemte hvor lenge rikene skulle eksistere og staket ut grensene som skiller dem fra hverandre. ");
INSERT INTO norlb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Hans hensikt med alt dette var at menneskene skulle lete etter Gud og kanskje finne veien til ham. Men han er ikke langt borte fra noen av oss. ");
INSERT INTO norlb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Det er jo i han vi lever og rører oss og eksisterer slik som noen av deres egne diktere sier: ’Vi kommer fra ham.’ ");
INSERT INTO norlb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Dersom det altså er sant at vi kommer fra ham, da kan jo ikke Gud være en gjenstand, noe som menneskene har laget av sølv eller gull eller har hugget ut i stein. ");
INSERT INTO norlb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","I lang tid har Gud hatt overbærenhet med den uvitenheten menneskene er begrenset av, men nå krever han at alle skal forlate avgudene og vende om til ham. ");
INSERT INTO norlb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Gud har nemlig satt fast en dag da han skal dømme verden med rettferdighet gjennom en mann som han i forveien har bestemt for denne oppgaven. Det har han bevist for alle mennesker ved å la denne mannen stå opp fra de døde.” ");
INSERT INTO norlb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Da de hørte at Paulus talte om en person som hadde stått opp fra de døde, begynte noen å le, men andre sa: ”Vi vil høre mer om dette en annen gang.” ");
INSERT INTO norlb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Da diskusjonen var over, gikk Paulus fra dem. ");
INSERT INTO norlb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Noen atenere slo seg sammen med ham og begynte å tro. Blant dem var Dionysios, en mann som var medlem av Areopagosrådet, og en kvinne som het Damaris og noen til. ");
INSERT INTO norlb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Senere reiste Paulus fra Aten og kom til Korint. ");
INSERT INTO norlb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Der ble han kjent med en jøde som het Akvilas. Han var født i provinsen Pontos, men hadde nylig kommet fra Italia sammen med kona si Priskilla, etter som keiser Claudius hadde utvist alle jødene fra Roma. ");
INSERT INTO norlb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulus fant fram til Akvilas og Priskilla og bodde og arbeidet sammen med dem. De drev håndverk med lærvarer, akkurat som han selv hadde erfaring fra. ");
INSERT INTO norlb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Hver uke på hviledagen gikk Paulus til synagogen og forsøkte å overbevise både jøder og dem som ikke var jøder. ");
INSERT INTO norlb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Etter at Silas og Timoteus var kommet fra Makedonia, konsentrerte Paulus seg helt om å snakke til jødene og vitne om at Jesus er Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Da jødene sa imot ham og hånte ham, børstet Paulus symbolsk støvet av kappen sin og sa: ”Dere får selv ta ansvar for handlingene deres. Jeg har gjort det jeg kunne. Fra og med nå av tenker jeg å vende meg til andre folk.” ");
INSERT INTO norlb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Så forlot Paulus synagogen og gikk i stedet til et hus som var eid av en mann som het Titius Justus. Han var ikke jøde, men tilba Israels Gud. Huset hans lå vegg i vegg med synagogen. ");
INSERT INTO norlb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Forstanderen for synagogen het Krispus. Både han og hele familien hans begynte å tro på Herren Jesus. Mange andre i Korint som hørte Paulus, begynte også å tro og lot seg døpe. ");
INSERT INTO norlb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","En natt viste Herren Jesus seg for Paulus i et syn og sa: ”Vær ikke redd! Fortsett bare med å fortelle om meg. La dem ikke skremme deg til taushet. ");
INSERT INTO norlb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Jeg er med deg. Ingen kommer til å skade deg, for det er mange som tilhører meg i denne byen.” ");
INSERT INTO norlb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paulus stanset ett og et halvt år i Korint og underviste om Guds budskap. ");
INSERT INTO norlb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Da Gallio var blitt landshøvding over provinsen Akaia, gikk jødene til angrep på Paulus og førte ham til landshøvdingen for å bli dømt. ");
INSERT INTO norlb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","De anklaget Paulus og sa: ”Han lokker menneskene til å dyrka Gud på en måte som er i strid med Moseloven.” ");
INSERT INTO norlb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Før Paulus rakk å forsvare seg, vendte Gallio seg mot jødene og sa: ”Hør etter, dere jøder! Dersom tilfellet gjaldt noen forbrytelser eller andre onde ting som de hadde gjort, da skulle jeg gjerne hørt på dere. ");
INSERT INTO norlb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Men skal dere bare krangle om noen ord og personer i deres interne lov, da kan dere sannelig ta hånd om dette selv. Jeg vil ikke være dommer i slike spørsmål.” ");
INSERT INTO norlb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Så jaget han dem bort fra domstolen. ");
INSERT INTO norlb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Da kastet folkemassen seg over Sostenes, en av forstanderne for synagogen, og mishandlet ham rett foran dommersetet. Men Gallio brydde seg ikke om oppstyret. ");
INSERT INTO norlb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus stanset en tid i Korint etter at dette skjedde. Så tok han avskjed med de troende og seilte tilbake til Syria. Med på reisen hadde han også Priskilla og Akvilas. Paulus hadde like før dette besøkt Kenkreæ, der han i tråd med jødisk skikk hadde klippet håret sitt for å innfri et løfte til Gud. ");
INSERT INTO norlb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Da de var kommet til havn i byen Efesos, skilte Paulus lag med Priskilla og Akvilas. Han gikk til synagogen for å diskutere med jødene. ");
INSERT INTO norlb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Folket i synagogen ba ham stanse noen dager, men han svarte: ");
INSERT INTO norlb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","”Jeg kan dessverre ikke gjøre det. Men om Gud vil, kommer jeg tilbake til dere en annen gang.” Så gikk han ombord igjen og dro fra Efesos. ");
INSERT INTO norlb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Da båten kom til byen Cæsarea, gikk Paulus i land og fortsatte opp til Jerusalem for å hilse på menigheten. Senere reiste han videre til Antiokia. ");
INSERT INTO norlb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Da han hadde vært der en tid, vendte han tilbake til provinsene Galatia og Frygia og besøkte alle disiplene og oppmuntret og styrket dem. ");
INSERT INTO norlb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","I mens hadde en jøde som het Apollos, kommet til Efesos. Han var fra Alexandria og en svært god taler som kjente godt til Skriften. ");
INSERT INTO norlb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apollos hadde fått høre om Herren Jesu vei, og han talte med stor entusiasme og underviste rett og riktig om Jesus. Men han kjente bare til den dåpen som døperen Johannes underviste om. ");
INSERT INTO norlb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Da Priskilla og Akvilas en dag fikk høre ham i synagogen der han med stort mot talte til folket, ble de med ham hjem og forklarte nærmere hva det betyr å følge Guds vei. ");
INSERT INTO norlb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Etter en tid ville Apollos seile over til provinsen Akaia, og de troende i Efesos oppmuntret ham. Han fikk med seg et brev der de ba disiplene i Akaia om å hilse ham velkommen. Da han kom dit, ble han til stor hjelp for de som Gud i sin godhet hadde latt komme til tro. ");
INSERT INTO norlb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Etter som han var så dyktig i å tolke Skriften, kunne han med stor kraft sette jødene til veggs i diskusjonene og bevise at Jesus virkelig er Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mens Apollos var i Korint i provinsen Akaia, kom Paulus fram til Efesos etter reisen gjennom innlandet. Der møtte han noen troende og spurte dem: ");
INSERT INTO norlb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","”Fikk dere Guds Hellige Ånd da dere kom til troen?” ”Nei”, svarte de, ”vi har aldri hørt snakk om Guds Hellige Ånd.” ");
INSERT INTO norlb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","”Men på hvilken måte er dere da døpt?” spurte han. De svarte: ”Vi er døpt med den dåpen som døperen Johannes underviste om.” ");
INSERT INTO norlb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Da forklarte Paulus at Johannes sin dåp var en dåp som viste at de hadde forlatt synden og vendt om til Gud, men at Johannes også underviste at de skulle tro på Jesus, han som kom etter ham. ");
INSERT INTO norlb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Da de hørte dette, lot de seg døpe til fellesskap med Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Da Paulus la hendene på dem, kom Guds Hellige Ånd over alle. De begynte å tale i fremmede språk og holde fram budskap fra Gud. ");
INSERT INTO norlb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Til sammen var det omkring tolv menn i gruppen. ");
INSERT INTO norlb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","9","I tre måneders tid underviste Paulus regelmessig i synagogen. Han talte åpent med stort mot, og forsøkte å overbevise alle om at Gud ville frelse og gjøre dem til sitt eget folk. Men noen avviste budskapet hans. De ville ikke tro, men hånte Jesu vei i påhør av alle i synagogen. Derfor sluttet Paulus å gå til synagogen, og han holdt de troende borte fra denne møteplassen. De samlet seg i stedet i Tyrannus auditorium, der Paulus underviste hver dag. ");
INSERT INTO norlb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Dette pågikk i to års tid, slik at alle i provinsen Asia, både jøder og de som ikke var jøder, fikk høre budskapet om Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Gud ga Paulus kraft til å gjøre uvanlige mirakler. ");
INSERT INTO norlb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Noen tok til og med tørklær og klesplagg som hadde vært i berøring med kroppen hans, og la på de syke. Da de gjorde det, forsvant sykdommene, og de onde åndene forlot dem som var besatt. ");
INSERT INTO norlb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","En gruppe jøder som var åndemanere og reiste fra by til by og drev ut onde ånder, fikk det for seg at de skulle uttale Herren Jesu navn over dem som var besatt. De tenkte ut en formel som lød slik: ”Jeg befaler deg å komme ut, ved den Jesus som Paulus snakker om!” ");
INSERT INTO norlb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Det var sju menn, alle sønner til den jødiske øverstepresten Skevas, som forsøkte seg på dette. ");
INSERT INTO norlb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Men da de uttalte formelen, svarte den onde ånden dem: ”Jeg kjenner Jesus og jeg vet hvem Paulus er, men hvem er så dere?” ");
INSERT INTO norlb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Så kastet den besatte mannen seg over dem og slo løs slik at de var nødt til å rømme nakne og forslåtte ut av huset. ");
INSERT INTO norlb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ryktet om det som hadde skjedd, spredde seg i hele Efesos både til jøder og dem som ikke er jøder. Alle i byen ble forskrekket og hyllet Herren Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","19","Mange av de troende, som før hadde praktisert trolldom, bekjente det de hadde vært med om. De plukket fram sine svartebøker og brente dem offentlig. Noen regnet ut at bøkene var verd omkring 50 000 daglønninger. ");
INSERT INTO norlb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Alt som skjedde, påvirket mange så sterkt at budskapet om Herren Jesus spredde seg vidt og bredt omkring, og flere og flere begynte å tro. ");
INSERT INTO norlb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Etter alt dette bestemte Paulus seg for først å seile over havet og deretter foreta en lang reise gjennom provinsene Makedonia og Akaia og videre til Jerusalem. ”Til sist må jeg også besøke Roma”, sa han. ");
INSERT INTO norlb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Men hans første oppgave var å sende Timoteus og Erastus, to av sine medarbeidere, i forveien til Makedonia. Imens stanset han selv en tid i provinsen Asia. ");
INSERT INTO norlb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","På denne tiden ble det stor uro i Efesos på grunn av budskapet om Jesu vei. ");
INSERT INTO norlb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Den som startet bråket, var sølvsmeden Demetrius, en mann som tjente store penger på å produsere små kopier av templet til gudinnen Artemis i Efesos. Han hadde for øvrig mange ansatte håndverkere. ");
INSERT INTO norlb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrius kalte sammen sine ansatte til et møte med andre som hadde tilsvarende produksjon. Han grep ordet og sa: ”Dere vet at det er takket være denne produksjonen at vi er blitt rike. ");
INSERT INTO norlb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nå har dere alle sett og hørt hvordan denne Paulus har fått mange til å tro at guder som er laget av menneskelige hender, ikke er noen guder. Det er ikke bare her i Efesos folk endrer sin innstilling, men i hele provinsen Asia. ");
INSERT INTO norlb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Naturligvis kommer dette til å påvirke våre forretninger negativt. Det som bekymrer meg mest, er at templet til den store gudinnen Artemis kan komme til å miste sin anseelse. Ja, kanskje Artemis selv kommer til å bli glemt, denne mektige gudinnen som blir dyrket, ikke bare i provinsen Asia, men i hele verden.” ");
INSERT INTO norlb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Da de hørte dette, ble de rasende og begynte å rope: ”Stor er efeserne sin Artemis!” ");
INSERT INTO norlb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Det drøyde ikke lenge før folk begynte å samle seg, og snart var hele byen i opprør. De grep Gaius og Aristark, to makedonier som var reisekamerater med Paulus, og slepte dem til friluftsteateret i byen. ");
INSERT INTO norlb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus ville da gå inn på teateret, men de troende hindret ham. ");
INSERT INTO norlb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Noen medlemmer av rådet i byen, som var Paulus sine venner, sendte også bud at han ikke måtte risikere livet ved å gå inn. ");
INSERT INTO norlb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Inne på teateret ropte og skrek alle om hverandre. Alt var et eneste stort kaos, og de fleste visste ikke en gang hvorfor de hadde kommet dit! ");
INSERT INTO norlb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Etter en stund sendte jødene fram en mann som het Aleksander, for å forklare situasjonen. Noen i folkemassen begynte å skrike gode råd til ham. Han ga tegn til folket om å være stille og forsøkte å holde en forsvarstale. ");
INSERT INTO norlb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Da folket forsto at Aleksander var jøde, begynte alle å rope igjen, og i to timer skrek de i kor: ”Stor er efesernes Artemis! Stor er efesernes Artemis!” ");
INSERT INTO norlb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Til slutt klarte i alle fall sorenskriveren i byen å roe folkemassen ned så pass at han kunne tale til dem. ”Innbyggere i Efesos”, sa han, ”alle vet at Artemis tempel finnes her og at Efesos er sentrum for tilbedelsen av den store gudinnen. Dette er stedet hvor bildet av henne falt ned til oss fra himmelen. ");
INSERT INTO norlb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Det er aldri noen som har stilt spørsmål ved dette, så ta det helt med ro. Gjør ikke noe som dere kommer til angre på. ");
INSERT INTO norlb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Disse mennene som dere har ført hit, har verken stjålet noe fra templet eller snakket dårlig om gudinnen. ");
INSERT INTO norlb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dersom Demetrius og håndverkerne hans har noe å anklage dem for, da har vi domstoler som tar hånd om slikt, og landshøvdinger som kan ta opp saken. La alt gå den lovlige veien. ");
INSERT INTO norlb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Dersom det finnes klager i andre spørsmål, så kan de bli tatt opp i den lovlige folkeforsamlingen. ");
INSERT INTO norlb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Slik vi nå driver på, er det til og med risiko for at vi blir anklaget for opprør, etter som det ikke var noen grunn til å sette i gang disse urolighetene. Dersom de romerske myndighetene krever en forklaring, så har vi ingen god grunn å komme med.” ");
INSERT INTO norlb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Med disse ordene fikk han folkemassen til å løse seg opp og gå hver til sitt. ");
INSERT INTO norlb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Da alt var blitt rolig i Efesos, kalte Paulus sammen disiplene og oppmuntret dem. Så tok han avskjed og begynte reisen over til Makedonia. ");
INSERT INTO norlb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Der dro han fra sted til sted og oppmuntret de troende. Da han kom fram til Hellas, ");
INSERT INTO norlb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","stanset han i tre måneder. Han sto klar til å seile videre til Syria da han fikk greie på at noen jøder la planer om å drepe ham. Han forandret derfor reiseruten og dro tilbake gjennom Makedonia. ");
INSERT INTO norlb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","En gruppe menn skulle reise med ham til Syria og videre til Jerusalem. Det var Sopatros, som var sønn av Pyrrus fra Berøa, Aristark og Sekundus fra Tessaloniki, Gaius fra Derbe, Timoteus samt Tykikus og Trofimus fra provinsen Asia. ");
INSERT INTO norlb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Han lot disse seile i forveien over til Troas og ba dem vente på oss der. ");
INSERT INTO norlb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Etter påskehøytiden gikk vi andre ombord på et skip i Filippi, og fem dager seinere møtte vi dem i Troas, der vi stanset en uke. ");
INSERT INTO norlb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","På søndagen, da vi hadde samlet oss for sammen å bryte brødet, talte Paulus til de troende. Etter som han skulle reise fra Troas neste dag, holdt han på helt til midnatt. ");
INSERT INTO norlb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Rommet i øvre etasjen der vi var samlet, var opplyst av mange oljelamper. ");
INSERT INTO norlb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","En ung mann som het Eutykus, hadde satt seg i vinduet. Da Paulus talte så lenge, gikk det ikke bedre til enn at han sovnet og falt ned fra tredje etasjen og døde. ");
INSERT INTO norlb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus sprang da ned, la seg over ham og tok ham i armene sine og sa: ”Ikke vær redd, han lever!” ");
INSERT INTO norlb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Så gikk alle opp igjen og brøt brødet og spiste sammen. Etterpå fortsatte Paulus å tale ytterligere en stund, ja, det rakk faktisk å bli morgen før han til slutt forlot dem. ");
INSERT INTO norlb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Den unge mannen som hadde falt ut av vinduet, ble ført hjem i beste velgående, noe som selvfølgelig var til stor lettelse for alle. ");
INSERT INTO norlb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulus tok landeveien over til byen Assos, mens vi andre seilte rundt med båt. ");
INSERT INTO norlb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Da vi etter en tid møtte han i Assos, tok vi ham ombord og seilte ned til Mitylene. ");
INSERT INTO norlb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Videre passerte vi øya Kios neste dag. Dagen etter la vi til ved øya Samos og nådde en dag seinere fram til byen Milet. ");
INSERT INTO norlb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","17","Paulus hadde bestemt seg for ikke å reise til Efesos denne gangen, til tross for at byen lå i nærheten. Han ville ikke bli heftet i provinsen Asia, etter som han ville rekke fram til Jerusalem for å kunne feire pinsehøytiden der. Da vi kom fram til Milet, sendte han en beskjed til lederne i menighetene i Efesos og ba dem komme ned til skipet for å treffe ham. ");
INSERT INTO norlb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Da de hadde møtt opp, sa han: ”Dere vet om alt jeg har gjort helt fra den dagen da jeg først satte mine føtter i provinsen Asia. ");
INSERT INTO norlb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Uten å tenke på meg selv har jeg tjent Herren Jesus. Det har jeg gjort til tross for de sorger og prøvelser som rammet meg gjennom alt jødene gjorde mot meg. ");
INSERT INTO norlb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Jeg har aldri nølt med å tale om det som kunne være til nytte for dere, men jeg har undervist dere både offentlig og i hjemmene. ");
INSERT INTO norlb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jeg har alvorlig formant både jøder og dem som ikke er jøder, til å vende om til Gud og tro på vår Herre Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Men nå blir jeg drevet av Guds Ånd til å reise tilbake til Jerusalem. Veien går dit til tross for at jeg ikke aner hva som venter meg der. ");
INSERT INTO norlb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Det eneste jeg vet, er at Guds Hellige Ånd i by etter by har minnet meg om at fengsel og lidelse kan ligge foran meg. ");
INSERT INTO norlb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Men for meg er ikke livet noe verdt, dersom jeg ikke får bruke det til å fullføre den oppgave som Herren Jesus har gitt meg. Helt til livets slutt vil jeg spre det glade budskapet om Guds kjærlighet og tilgivelse. ");
INSERT INTO norlb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nå vet jeg at dere aldri kommer til å få se meg igjen, alle dere som jeg har besøkt og undervist om hvordan dere kunne bli Guds eget folk. ");
INSERT INTO norlb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Derfor vil jeg i dag si dere at jeg ikke er skyldig om noen av dere går evig fortapt. ");
INSERT INTO norlb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Jeg har jo uten å nøle meddelt dere hele Guds plan om frelse. ");
INSERT INTO norlb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Pass nå nøye på hvordan dere selv lever, og ta godt være på de menneskene som Guds Hellige Ånd har satt dere til ledere for. Vær gjetere for Guds menighet, den flokken som han har kjøpt med sin egen Sønns blod. ");
INSERT INTO norlb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Jeg vet at når jeg forlater dere, vil det komme glupske ulver og trenge seg inn blant dere, og de kommer ikke til å skåne flokken. ");
INSERT INTO norlb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Noen av dere kommer selv til å forvrenge sannheten og forsøke å få egne tilhengere blant disiplene. ");
INSERT INTO norlb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Vær derfor på vakt! Husk på at jeg i tre år personlig har undervist hver og en av dere, og at jeg dag og natt med tårer har formant dere. ");
INSERT INTO norlb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Jeg ber nå om at Gud skal ta hånd om dere. Ikke glem budskapet hans om kjærlighet og tilgivelse. La det veilede dere, slik at troen blir sterkere og sterkere, og dere får del i den arven som venter på dem som tilhører Gud. ");
INSERT INTO norlb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Dere vet at jeg aldri har krevd å få penger eller klær av dere. ");
INSERT INTO norlb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Jeg har med egne hender forsørget både meg selv og mine medarbeidere. ");
INSERT INTO norlb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Jeg ville gjennom egne handlinger vise at vi gjennom hardt arbeid skal skaffe mulighet til å hjelpe de fattige og ikke falle menigheten til byrde. Husk på det Herren Jesus sa: ’Vi blir lykkeligere av å gi enn å få.’ ” ");
INSERT INTO norlb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Da Paulus avsluttet talen, falt han på kne og ba. ");
INSERT INTO norlb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mennene begynte å gråte høyt og omfavnet og kysset ham. ");
INSERT INTO norlb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Det som bedrøvet dem aller mest, var at han sa at de aldri mer ville se hverandre her i livet. Til slutt fulgte alle ham ned til skipet. ");
INSERT INTO norlb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Etter at vi skilte lag med lederne for menigheten i Efesos, seilte vi rett ned til øya Kos. Neste dag nådde vi øya Rhodos og fortsatte derfra til byen Patara. ");
INSERT INTO norlb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Der fant vi et skip som skulle til Fønikia i provinsen Syria, og vi gikk ombord og seilte av sted. ");
INSERT INTO norlb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Etter en tid fikk vi Kypros i sikte og passerte sør for øya med kurs mot Syria. Vi kom til byen Tyrus, for der skulle skipet losse lasten. ");
INSERT INTO norlb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Mens dette sto på, gikk vi i land og fant fram til disiplene og stanset hos dem en uke. De ble ledet av Guds Ånd til å advare Paulus mot å fortsette til Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Da uken hadde gått, vendte vi på tross av advarslene tilbake til skipet. Alle de troende, også kvinner og barn, fulgte med oss ut av byen og ned til stranden. Der ba vi sammen og tok avskjed med hverandre. ");
INSERT INTO norlb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Vi gikk om bord, og de andre vendte hjem til sitt. ");
INSERT INTO norlb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nesten uten opphold kom vi til Ptolemais. Der hilst vi også på de troende, men stanset bare en dag. ");
INSERT INTO norlb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Så fortsatte vi til Cæsarea, der vi bodde hos Filip. Han var stadig opptatt med å spre det glade budskapet om Jesus. Filip var en av de første sju medarbeiderne til disiplene. ");
INSERT INTO norlb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Han hadde fire ugifte døtre, som alle hadde fått evner av Gud til å tale profetisk. ");
INSERT INTO norlb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","11","Under besøket som varte i flere dager, kom en mann fra Judea for å treffe oss. Han het Agabus. Også han hadde fått evner av Gud til å tale profetisk. Han tok beltet til Paulus og bandt sine egne føtter og hender med det og sa: ”Guds Hellige Ånd sier: ’På denne måten skal eieren av dette belte bli bundet av jødene i Jerusalem og bli utlevert til romerne.’ ” ");
INSERT INTO norlb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Vi som hørte dette, både reisekameratene og de troende på stedet, forsøkte på alle måter å overtale Paulus til ikke å fortsette til Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Men han sa: ”Hvorfor gråter dere og gjør det vanskelig for meg? Jeg er beredt, ikke bare til å bli fengslet i Jerusalem, men også å dø for Herren Jesu skyld.” ");
INSERT INTO norlb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Vi forsto da at han ikke hadde noen planer om å bøye av. Vi roet oss og sa: ”La det bli som Herren vil.” ");
INSERT INTO norlb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Etter disse dagene hos Filip gjorde vi oss klare og fortsatte mot Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Noen av disiplene i Cæsarea fulgte med oss et stykke og viste oss veien til Mnason sitt hus der vi fikk bo. Mnason kom fra Kypros, og var en av de første som begynte å tro på Jesus. ");
INSERT INTO norlb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Da vi kom fram til Jerusalem, ble vi hilst hjertelig velkommen av de troende. ");
INSERT INTO norlb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Dagen etter at vi hadde kommet, tok Paulus oss med hjem til Jakob. Der samlet også de andre lederne i menighetene seg. ");
INSERT INTO norlb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Etter at vi hadde hilst, fortalte Paulus smått og stort om arbeidet sitt og om hvordan Gud hadde brukt ham for å nå ut til andre folk. ");
INSERT INTO norlb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Da lederne i menighetene hørte dette, hyllet de Gud. Men etter en stund sa de: ”Du vet, kjære bror, at mange tusen jøder har kommet til tro her, og de er alle nøye med å følge Moseloven. ");
INSERT INTO norlb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nå har et rykte blitt spredd i Jerusalem om at du lærer de jødene som bor blant andre folk, at de ikke behøver å følge Moseloven. Du skal også ha sagt at de ikke behøver å omskjære sine sønner eller å følge våre jødiske tradisjoner. ");
INSERT INTO norlb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Noe må derfor bli gjort, for de kommer sikkert til å få greie på at du er her. ");
INSERT INTO norlb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Vårt forslag går ut på dette: Her er det fire menn som har gitt et løfte til Gud. ");
INSERT INTO norlb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ta dem med til templet og gå sammen med dem og foreta seremonien for renselse. Betal etterpå utgiftene slik at de også kan klippe håret, slik det er påbudt i loven. Da forstår alle at ryktene om deg er falske, og at du selv følger Moseloven. ");
INSERT INTO norlb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Når det gjelder troende fra andre folk, står vi fast ved vår beslutning. Det eneste vi krever av dem er det vi skrev om i vårt brev: At de ikke skal spise mat som blir ofret til avguder, at de ikke skal spise kjøtt fra kvalte dyr eller noe annet som fortsatt har blod i seg, og at de skal avholde seg fra seksuell løssluppenhet.” ");
INSERT INTO norlb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","27","Paulus syntes forslaget hørtes bra ut, og neste dag tok han mennene med seg og foretok seremonien for renselse sammen med dem. Senere gikk han til templet og meldte offentlig fra om at renselsestiden skulle være slutt om sju dager og at et offer da ville bli båret fram for hver og en av de fire mennene. Like før de sju dagene var slutt, fikk noen jøder fra provinsen Asia øye på Paulus i templet og hisset opp folket mot ham. De grep tak i ham og ");
INSERT INTO norlb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","skrek: ”Israelitter! Hjelp oss! Her er den mannen som over alt i verden, og til alle i vårt folk, lærer stikk i strid med Moseloven og templet. Nå har han til og med tatt med noen som ikke er jøder, inn i templet og gjort dette hellige stedet uverdig.” ");
INSERT INTO norlb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mannen hadde tidligere på dagen sett Paulus nede i byen sammen med Trofimus fra Efesos, og de trodde derfor at Paulus hadde tatt ham med seg til templet. ");
INSERT INTO norlb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Det drøyde ikke lenge før hele byen var i opprør og kom løpende. De slepte Paulus ut av templet, og portene ble straks stengt bak ham. ");
INSERT INTO norlb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Folket tenkte å drepe ham, men kommandanten ved den romerske garnisonen fikk vite at hele Jerusalem var i opprør. ");
INSERT INTO norlb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Derfor rykket han raskt ut med soldatene og offiserene sine. Da folkemassen fikk se soldatene, sluttet de å mishandle Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kommandanten gikk straks fram og arresterte Paulus og ga befaling om at han skulle bli bundet med doble kjettinger. Han spurte folkemassen hvem Paulus var og hva han hadde gjort. ");
INSERT INTO norlb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Blant folket skrek noen det ene, mens andre sa noe helt annet. Kommandanten kunne ikke i forvirringen få klarhet i hva de mente. Han ga derfor befaling om at Paulus skulle bli tatt med til den romerske festningsborgen. ");
INSERT INTO norlb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Folket fulgte etter helt fram og ropte: ”Drep ham, drep ham!” Da de kom fram til trappen, ble folkemassen så voldsom at soldatene måtte løfte Paulus opp på skuldrene for å beskytte ham. ");
INSERT INTO norlb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","I det Paulus skulle bli ført inn i festningsborgen, sa han til kommandanten: ”Får jeg si noen ord til deg?” ”Kan du gresk?” undret kommandanten forbauset. ");
INSERT INTO norlb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","”Er ikke du den egypteren som satte i gang et opprør for noen år siden og tok med seg 4 000 bevæpnete rebeller ut i ørkenen?” ");
INSERT INTO norlb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","”Nei”, svarte Paulus, ”jeg er en jøde fra Tarsus i Kilikia, borger av en stor og viktig by. Jeg ber derfor om at du lar meg tale til folket.” ");
INSERT INTO norlb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kommandanten ga ham da sin fullmakt, og Paulus gjorde tegn til folket fra toppen trappen at han hadde noe å si. Da alle hadde roet seg, begynte han å tale til dem på arameisk. ");
INSERT INTO norlb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Han sa: ”Kjære søsken og dere som er ledere for folket, hør etter på det jeg har å si til mitt forsvar.” ");
INSERT INTO norlb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Da de hørte at Paulus talte på deres eget språk, ble de enda mer stille. ");
INSERT INTO norlb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Han fortsatte: ”Jeg er jøde, født i byen Tarsus i Kilikia, men oppvokst her i Jerusalem. Jeg hadde Gamaliel som lærer og ble undervist om mye rett og riktig i Moseloven og alle våre tradisjoner. Min ekstreme fanatisme i livet var å kjempe for Gud, slik som også dere forsøker å gjøre. ");
INSERT INTO norlb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Jeg forfulgte og ville drepe alle som fulgte Jesu vei. Jeg lot både menn og kvinner bli bundet og satt i fengsel. ");
INSERT INTO norlb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Dette kan øverstepresten og alle medlemmene i Det jødiske rådet bevitne. Det var også de som ga meg brev adressert til synagogene i Damaskus, for at jeg skulle fengsle menneskene der og føre dem til Jerusalem, hvor de kunne bli straffet. ");
INSERT INTO norlb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Da jeg var på veien til Damaskus, ved middagstiden, og nærmet meg byen, ble jeg plutselig innhyllet av et sterkt lys fra himmelen. ");
INSERT INTO norlb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Jeg falt til jorden og hørte en stemme som sa: ’Saulus, Saulus, hvorfor forfølger du meg?’ ");
INSERT INTO norlb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Jeg spurte da: ’Hvem er du, herre?’ og han svarte: ’Jeg er Jesus fra Nasaret, han som du forfølger.’ ");
INSERT INTO norlb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","De som var med meg, så lyset, men forsto ikke stemmen som snakket til meg. ");
INSERT INTO norlb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Jeg spurte da: ’Hva skal jeg gjøre, Herre?’ Herren svarte: ’Reis deg opp og gå til Damaskus. Der vil du få vite hvilken oppgave jeg har valgt deg ut til.’ ");
INSERT INTO norlb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Det sterke lyset hadde gjort meg blind, og derfor måtte jeg bli ledet inn til Damaskus av mine ledsagere. ");
INSERT INTO norlb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","I Damaskus bodde det en mann som het Ananias. Han var en hengiven jøde og nøye med å følge Moseloven. Derfor var han også godt ansett blant alle jøder i Damaskus. ");
INSERT INTO norlb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Denne mannen kom til meg, stilte seg ved siden meg og sa: ’Saulus, min bror, du skal få ditt syn tilbake!’ Og i samme øyeblikk kunne jeg se. ");
INSERT INTO norlb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Så sa han til meg: ’Våre forfedres Gud har valgt deg ut til å kjenne hans vilje og til å se den Rettferdige og høre stemmen hans. ");
INSERT INTO norlb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nå skal du vitne for alle mennesker og fortelle det du har sett og hørt. ");
INSERT INTO norlb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tvil ikke, men tilbe Jesus og la deg straks døpe slik at du blir vasket ren fra syndene dine.’ ");
INSERT INTO norlb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Senere, da jeg hadde kommet tilbake til Jerusalem og en dag sto og ba i templet, fikk jeg se et syn. ");
INSERT INTO norlb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Jeg så Herren Jesus som sa til meg: ’Skynd deg, forlat straks Jerusalem, for folket her kommer ikke til å tro på det du forteller om meg.’ ");
INSERT INTO norlb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","’Men, Herre’, innvendte jeg, ’de kjenner meg jo. De vet at jeg i hver eneste synagoge har fengslet og pisket dem som trodde på deg. ");
INSERT INTO norlb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Da Stefanus ble drept, han som fortalte om deg til alle, sto jeg ved siden av og mente at de handlet rett. Jeg voktet til og med klærne til dem som steinet ham!’ ");
INSERT INTO norlb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Herren Jesus sa til meg: ’Dra bort fra Jerusalem, for jeg vil sende deg langt av sted til andre folk!’ ” ");
INSERT INTO norlb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Fram til dette punktet i Paulus sin tale hadde folket lyttet rolig, men nå begynte de å rope: ”Drep ham! Pass på at han forsvinner fra jordens overflate! Han har ingen rett til å leve!” ");
INSERT INTO norlb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Folkets rop ble villere og villere. De slet av seg kappene sine og kastet jord opp i luften. ");
INSERT INTO norlb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kommandanten tok derfor Paulus inn i festningsborgen og ga befaling om at de skulle piske ham til han tilsto sine forbrytelser, slik at de fikk greie på hvorfor folkemassen var så rasende. ");
INSERT INTO norlb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Da de surret Paulus fast for å piske ham, sa han til en offiser som sto der: ”Er det tillatt å piske en romersk borger som ikke er dømt for noe?” ");
INSERT INTO norlb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Da offiseren hørte dette, gikk han til kommandanten og sa: ”Hva er det du tenker å gjøre? Denne mannen er jo romersk borger!” ");
INSERT INTO norlb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Da gikk kommandanten til Paulus og spurte: ”Er det sant at du er romersk borger?” ”Ja”, svarte Paulus, ”det er jeg.” ");
INSERT INTO norlb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","”Det er jeg også”, mumlet kommandanten, ”og det kostet meg veldig mange penger!” ”Jeg ble det i fødselen”, svarte Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Soldatene som skulle ha pisket og forhørt ham, trakk seg raskt tilbake da de hørte at Paulus var romersk borger. Kommandanten selv ble forskrekket, etter som det var han som hadde gitt befaling om at Paulus skulle bli bundet og pisket. ");
INSERT INTO norlb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Neste dag satte kommandanten Paulus fri fra fengslet og ga befaling om at øversteprestene og Det jødiske rådet skulle samle seg. Han førte Paulus ned fra festningsborgen og stilte han for Det jødiske rådet for å få greie på hva bråket handlet om. ");
INSERT INTO norlb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Da Paulus kom inn, så han medlemmene i rådet rett i øynene og sa: ”Brødre, jeg har alltid levd livet mitt med god samvittighet for Gud.” ");
INSERT INTO norlb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Da ga øverstepresten Ananias befaling om at de som sto nærmest Paulus, skulle slå ham over munnen. ");
INSERT INTO norlb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulus sa til han: ”Gud skal slå deg, du som har sunket ned i en slik dobbelmoral! Her sitter du for å dømme meg etter Moseloven, og så bryter du selv loven ved å befale at de skal slå meg.” ");
INSERT INTO norlb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","De som sto ved siden av Paulus, sa da til ham: ”Hvordan våger du å forulempe Guds øversteprest?” ");
INSERT INTO norlb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","”Tilgi meg brødre”, svarte Paulus, ”jeg visste ikke at han var øversteprest. Det står i Skriften: ’Du skal ikke forbanne den som er leder for folket ditt.’ ” ");
INSERT INTO norlb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Hva Paulus derimot visste, var at noen av medlemmene i rådet var saddukeere, mens andre var fariseere. Derfor ropte han: ”Brødre, jeg er fariseer liksom alle mine forfedre. Og jeg blir stilt for retten her i dag fordi jeg tror at de døde står opp igjen.” ");
INSERT INTO norlb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Dette delte straks rådet i to grupper som begynte å krangle med hverandre. ");
INSERT INTO norlb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saddukeerne tror nemlig ikke at de døde står opp igjen eller at det finnes engler eller ånder. Fariseerne derimot tror på alt dette. ");
INSERT INTO norlb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Alle i rådet skrek i munnen på hverandre, og noen av de skriftlærde fra partiet til fariseerne stilte seg opp og forsvarte Paulus. ”Vi kan ikke se at denne mannen har gjort noe galt”, protesterte de høylytt. ”Kanskje en Ånd eller en engel virkelig har snakket til ham.” ");
INSERT INTO norlb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Krangelen ble bare verre og verre, og mennene rykket og slet i Paulus fra alle kanter. Til slutt fikk kommandanten gitt befaling til soldatene om å ta med Paulus og føre ham til festningsborgen, etter som han var redd for at de skulle slite ham i filler. ");
INSERT INTO norlb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Da det seinere var blitt natt, viste Herren Jesus seg for Paulus og sa: ”Vær ikke redd! På samme måten som du har fortalt om meg her i Jerusalem, skal du også fortelle om meg i Roma.” ");
INSERT INTO norlb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Neste morgen samlet mer enn 40 jødiske menn seg og sverget på at de verken skulle spise eller drikke før de hadde drept Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","De gikk til øversteprestene og folkets ledere og sa: ”Vi har sverget en ed og lovet at vi verken skal spise eller drikke før vi har drept Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Be derfor kommandanten om at han lar Paulus bli stilt for rådet igjen. Si til ham at dere vil undersøke tilfellet nærmere, så kan vi drepe ham når han er på vei hit.” ");
INSERT INTO norlb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Paulus sin søstersønn fikk greie på planene deres og gikk til festningsborgen og fortalte alt for Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Straks kalte han til seg en offiser og sa: ”Ta med denne unge mannen til kommandanten. Han har noe viktig å fortelle ham.” ");
INSERT INTO norlb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Offiseren gikk da til kommandanten og forklarte: ”Fangen Paulus kalte på meg og ba meg ta med denne unge mannen til deg. Han har visst noe å fortelle deg.” ");
INSERT INTO norlb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kommandanten tok ham da ved armen og førte ham til siden og spurte: ”Hva er det du har å fortelle?” ");
INSERT INTO norlb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Søstersønnen til Paulus forklarte straks: ”Jødene har blitt enige om å be deg sende Paulus ned til deres råd i morgen, slik at de kan undersøke tilfellet nærmere. ");
INSERT INTO norlb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ikke la dem få det som de vil, for mer enn 40 menn ligger gjemt i et bakhold for å drepe Paulus. De har sverget at de verken skal spise eller drikke før han er død. De har allerede gjort seg klare og venter bare på at du skal gi ditt ja.” ");
INSERT INTO norlb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kommandanten advarte ham og sa: ”Ingen må få vite at du har fortalt meg dette”, og så lot han mannen gå. ");
INSERT INTO norlb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kommandanten kalte på to av offiserene sine og sa: ”Kall ut 200 soldater som står klare til å marsjere til Cæsarea klokka ni i kveld sammen med 200 spydkastere og 70 ryttere. ");
INSERT INTO norlb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Gi Paulus en hest å ri på og pass på, at han kommer fram til landshøvdingen Feliks i god behold.” ");
INSERT INTO norlb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Han skrev følgende brev til landshøvdingen: ");
INSERT INTO norlb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","”Fra Claudius Lysias, til den høyt ærede landshøvdingen Feliks. Beste hilsen! ");
INSERT INTO norlb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Denne mannen har blitt arrestert av jødene. De skulle nettopp til å drepe ham da jeg sendte ut soldater for å redde ham. Etterpå har jeg fått vite at han er romersk borger. ");
INSERT INTO norlb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Jeg førte ham ned til Det jødiske rådet for å få greie på hva de anklaget ham for. ");
INSERT INTO norlb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Jeg forsto snart at det bare var noen interne stridsspørsmål som hadde med deres religiøse lover å gjøre, og ikke noe som bør bli straffet med fengsel eller døden. ");
INSERT INTO norlb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Senere fikk jeg ved en anledning greie på at de planla å drepe han, og jeg besluttet derfor å sende ham til deg. Jeg har også formant motstanderne hans til å legge fram anklagene sine for deg.” ");
INSERT INTO norlb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Samme natten tok soldatene Paulus og førte ham til den romerske militærforlegningen Antipatris slik de hadde fått befaling om. ");
INSERT INTO norlb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Neste morgen fortsatte de 70 rytterne med ham til Cæsarea, mens de øvrige mennene vendte tilbake til festningsborgen i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Da de kom fram til Cæsarea, overlot de brevet til landshøvdingen Feliks og førte Paulus inn til han. ");
INSERT INTO norlb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Landshøvdingen leste brevet og spurte Paulus hvilken provins han kom fra. ”Fra Kilikia”, svarte Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","”Bra”, sa landshøvdingen, ”jeg skal ta opp saken din når de som anklager deg kommer hit.” Så ga han befaling om at Paulus skulle bli anbrakt i fengslet som lå i palasset til kong Herodes. ");
INSERT INTO norlb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Fem dager seinere kom øverstepresten Ananias og noen av de religiøse lederne sammen med advokaten Tertullus til Cæsarea for å anklage Paulus for landshøvdingen. ");
INSERT INTO norlb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Da Paulus ble ført inn, begynte Tertullus å legge fram anklagene. Slik lød prosedyren hans: ");
INSERT INTO norlb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","”Høyt ærede Feliks! Det er takket være deg at vi jøder kan leve i fred og trygghet. Du har også sett til at vårt folk på alle måter har fått det bedre. Dette er vi alle uendelig takknemlige for. ");
INSERT INTO norlb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Jeg vil ikke ta for mye av tiden din, men jeg ber deg være så vennlig å høre etter på meg mens jeg i korthet legger fram våre anklager. ");
INSERT INTO norlb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Vi har funnet at denne mannen sprer uro og elendighet blant jødene over alt i verden. Han er leder for sekten til nasaréerne. ");
INSERT INTO norlb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Han har til og med forsøkt å skjende templet. Det var derfor vi arresterte ham. ");
INSERT INTO norlb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Dersom du forhører ham, kan du selv få bekreftet at våre anklager er sanne.” ");
INSERT INTO norlb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","De andre jødene samtykket og sa at alt som Tertullus hadde prosedert var riktig. ");
INSERT INTO norlb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Landshøvdingen gjorde tegn til Paulus at det var hans tur til å forklare seg. Han begynte sin tale: ”Jeg vet at du har vært dommer for dette folket i mange år. Det føler jeg som en fordel og trygghet når jeg nå skal forsvare meg. ");
INSERT INTO norlb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Du kan lett kontrollere at det ikke er mer enn tolv dager siden jeg kom til Jerusalem for å be i templet. ");
INSERT INTO norlb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Du kan også få bekreftet at jeg i denne tiden ikke har diskutert med noen eller har stelt til uroligheter, det være seg i templet, i synagogene eller ute på gatene. ");
INSERT INTO norlb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Det finnes heller ikke fnugg av bevis for at jeg skulle ha gjort alt dette som disse mennene anklager meg for. ");
INSERT INTO norlb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Jeg erkjenner at jeg tilhører den gruppen som følger Jesu vei, den gruppen som de kaller en sekt. Gjennom dette tjener jeg våre forfedres Gud, og jeg tror på alt som Gud har sagt i Moseloven og det profetene har skrevet. ");
INSERT INTO norlb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Jeg tror, akkurat som disse mennene, at Gud en dag skal la alle stå opp fra de døde, noen til evig straff, noen til evig liv. ");
INSERT INTO norlb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Derfor gjør jeg mitt beste for alltid å ha en ren samvittighet for Gud og mennesker. ");
INSERT INTO norlb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Etter å ha vært borte fra byen i flere år, vendte jeg tilbake til Jerusalem med penger for å hjelpe jødene og for å ofre til Gud. ");
INSERT INTO norlb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Det var i templet de fikk øye på meg. Jeg holdt nettopp på å avslutte seremonien for renselse. Det var ikke noen folkemasse rundt meg, og ikke antydning til uro. ");
INSERT INTO norlb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Noen jøder fra provinsen Asia var der. Det var egentlig de som burde stått her i dag dersom de mente å ha noe å anklage meg for. ");
INSERT INTO norlb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Når de ikke er her, må du ta til takke med å høre hva de som er på plass, har å anklage meg for. De kan fortelle hvilken forbrytelse Det jødiske rådet fant meg skyldig til. ");
INSERT INTO norlb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Jeg tror ikke de har noe annet å anklage meg for enn det som jeg høyt og tydelig ga uttrykk for da jeg sto foran dem: ’Jeg står her for retten i dag på grunn av troen min på at døde står opp igjen!’ ” ");
INSERT INTO norlb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks, som visste en hel del om Jesu vei, utsatte rettsforhandlingene og sa: ”La oss vente til kommandanten Lysias kommer hit fra Jerusalem. Da skal jeg dømme i saken.” ");
INSERT INTO norlb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Han sendte Paulus tilbake til fengslet, og sa til vaktene at de skulle behandle ham mildt. De fikk også befaling om å la vennene til Paulus besøke ham, og at de kunne gi ham alt han trengte. ");
INSERT INTO norlb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Noen dager seinere kom Feliks, som var landshøvding, tilbake sammen med sin kone som het Drusilla, og var jødinne. Han ba om å få Paulus hentet, fordi han ville at han skulle fortelle mer om troen på Jesus som Messias, den lovede kongen. ");
INSERT INTO norlb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Da Paulus begynte å snakke om å leve etter Guds vilje, om å avstå fra enkelte ting, og om at Gud en dag vil dømme alle mennesker, ble Feliks redd og sa: ”Dette holder for i dag. Nå kan du gå. Når jeg har god tid, skal jeg sende bud etter deg igjen.” ");
INSERT INTO norlb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feliks sendte virkelig bud på Paulus gang etter gang for å snakke med ham. Det var nok helst for at han håpet at Paulus skulle bestikke ham. ");
INSERT INTO norlb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Slik fortsatte det i to år. Da sluttet Feliks som landshøvding og fikk en etterfølger som het Porkius Festus. Etter som Feliks ville holde seg godt inne med jødene, lot han Paulus bli igjen i fengslet da han sluttet som landshøvding. ");
INSERT INTO norlb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tre dager etter at Festus hadde kommet til Cæsarea for å begynne sin tjeneste som landshøvding, reiste han til Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Der ble han oppsøkt av øversteprestene og noen betydningsfulle jøder som på nytt tok opp anklagene mot Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","De ba også om at Festus skulle vise sin godhet mot jødene ved å la Paulus bli ført tilbake til Jerusalem. Deres egentlige plan var å overfalle og drepe Paulus på veien. ");
INSERT INTO norlb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus svarte at Paulus satt i fengsel i Cæsarea, og at han snart skulle dit selv. ");
INSERT INTO norlb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","”Derfor”, fortsatte han, ”må lederne deres heller følge meg dit for å anklage ham, dersom han nå har gjort noe galt.” ");
INSERT INTO norlb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Vel en uke seinere vendte Festus tilbake til Cæsarea. Følgende dag satte han seg på dommersetet og ga befaling om at Paulus skulle bli ført inn. ");
INSERT INTO norlb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Da Paulus kom inn, ble han omringet av jødene som hadde kommet fra Jerusalem. De nærmest slynget ut sine mange og sterke anklager mot ham. Likevel kunne de ikke bevise en eneste en av påstandene. ");
INSERT INTO norlb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulus nektet alt og sa: ”Jeg har ikke brutt den jødiske loven eller gjorde noen forbrytelse mot templet eller snakket nedsettende om den romerske keiseren.” ");
INSERT INTO norlb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Da spurte Festus, som ville holde seg til venns med jødene: ”Er du villig til å reise til Jerusalem og la deg bli dømt av meg der oppe?” ");
INSERT INTO norlb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","”Nei!” svarte Paulus. ”Jeg er romersk borger og derfor er det i den romerske domstolen jeg skal bli dømt. Jeg har ikke gjorde noe galt mot jødene, og det vet du godt selv. ");
INSERT INTO norlb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Dersom jeg har gjort noe som fortjener døden, da er jeg beredt til å dø. Dersom jeg er uskyldig, da har verken du eller noen andre rett til å overgi meg til disse mennene for at de kan drepe meg. Jeg ber om å bli dømt ved den keiserlige domstolen i Roma.” ");
INSERT INTO norlb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus diskuterte dette med sine rådgivere og svarte: ”Du har bedt om å få bli dømt ved den keiserlige domstolen, derfor skal du få reise til Roma.” ");
INSERT INTO norlb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Noen dager seinere kom kong Agrippa og Berenike til Cæsarea på et høflighetbesøk til den nye landshøvdingen. ");
INSERT INTO norlb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","De stanset i flere dager, og Festus passet på å ta opp saken om Paulus med kongen. Han sa: ”Det finnes en fange her som heter Paulus, og som Feliks har etterlatt til meg. ");
INSERT INTO norlb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Da jeg var i Jerusalem, kom de jødiske øversteprestene og folkets ledere til meg med en anklage mot ham. De ba om at jeg måtte passe på å få ham dømt. ");
INSERT INTO norlb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Jeg fortalte da at romerne ikke har for vane å utlevere noen før han har blitt stilt for retten. Den anklagede skal ha mulighet til å møte dem som anklager ham, og alle skal ha anledning til å forsvare seg. ");
INSERT INTO norlb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Da de religiøse lederne kom hit til Cæsarea, tillyste jeg rettsforhandlingene allerede neste dag og ga befaling om at Paulus skulle bli ført inn. ");
INSERT INTO norlb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Men anklagene mot ham var noe helt annet enn det jeg hadde ventet meg. ");
INSERT INTO norlb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","De gjaldt bare noen stridsspørsmål i deres interne religion og om en mann som het Jesus, som er død, men som Paulus påstår lever! ");
INSERT INTO norlb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Jeg ble forvirret og visste ikke hva jeg skulle gjøre i dette tilfellet. Derfor spurte jeg Paulus om han var villig til å reise til Jerusalem og stå for domsstolen der. ");
INSERT INTO norlb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Paulus ba i stedet om å få bli her. Han ville heller vente og bli dømt ved den keiserlige domstolen. Derfor har jeg gitt befaling om at han skal sitte i fengslet her til jeg kan sende ham til Roma.” ");
INSERT INTO norlb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Da sa kong Agrippa: ”Jeg skulle selv ønske å høre denne mannen.” Festus svarte: ”Det skal vi ordne. Du kan få treffe ham allerede i morgen!” ");
INSERT INTO norlb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Neste dag kom kong Agrippa og Berenike i full uniform til domsstolen sammen med de høye offiserene og byens ledende menn. Festus ga befaling om at Paulus skulle bli ført inn. ");
INSERT INTO norlb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Han sa: ”Kong Agrippa, og alle dere andre som er samlet her i dag. Dette er den mannen som jødene både her og i Jerusalem vil straffe med døden. ");
INSERT INTO norlb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Etter min oppfatning har han ikke gjort noe som fortjener dødsstraff. Han har bedt om å få bli dømt ved den keiserlige domstolen, og derfor har jeg besluttet å sende ham til Roma. ");
INSERT INTO norlb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Rullebladet hans vet jeg ikke mye om, men vil rapportere til min øverste leder, keiseren. Det finnes rett og slett ikke noen virkelige anklager mot denne mannen. Jeg har nå stilt ham fram for dere, og spesielt for deg, kong Agrippa, slik at du kan avhøre ham og etterpå si meg hva jeg skal skrive i rapporten. ");
INSERT INTO norlb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Det virker jo ikke særlig logisk å sende en fange til den keiserlige domstolen uten å ha noe å anklage ham for!” ");
INSERT INTO norlb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kong Agrippa sa til Paulus: ”Hva har du å si til ditt forsvar? Vær så god, ordet er ditt.” Da løftet Paulus hånden til en hilsen og begynte på sin forsvarstale. Han sa: ");
INSERT INTO norlb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","”Kong Agrippa, jeg er svært glad for at jeg får svare deg på de anklagene jødene har mot meg. ");
INSERT INTO norlb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Jeg vet at du er ekspert på jødiske skikker og stridsspørsmål. Derfor ber jeg deg om å høre på meg med tålmodighet! ");
INSERT INTO norlb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Som alle jøder godt vet, fikk jeg en grundig jødisk oppdragelse helt fra min tidligste barndom, først i Tarsus, og seinere i Jerusalem. ");
INSERT INTO norlb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Jødene kjenner meg fra lang tid tilbake. Dersom de bare vil erkjenne det, vet de veldig godt om at jeg har levd som en ekte fariseer og fulgt den strengeste retningen i vår religion. ");
INSERT INTO norlb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Jeg står nå anklaget fordi jeg tror at Gud skal innfri det løfte han ga til forfedrene våre. ");
INSERT INTO norlb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dette løfte håpet Israels tolv stammer å få se oppfylt ved at de dag og natt tjente ham! Det er altså, kong Agrippa, helt inkonsekvent av jødene å påstå at det er en forbrytelse å tro på dette løftet. ");
INSERT INTO norlb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Hvorfor skal det være så vanskelig å tro at Gud kan vekke opp døde? ");
INSERT INTO norlb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Tidligere trodde jeg selv at det var min plikt å gå så hardt som mulig fram mot dem som tror på Jesus fra Nasaret. ");
INSERT INTO norlb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Jeg arresterte mange av de troende i Jerusalem ved hjelp av den fullmakten jeg hadde fått av øversteprestene. Jeg stemte for at de skulle bli dømt til døden. ");
INSERT INTO norlb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mange ganger brukte jeg tortur i synagogene for å få troende til å forbanne Jesus. Jeg var en så bitter motstander at jeg til og med forfulgte troende langt borte i fremmede land. ");
INSERT INTO norlb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","En dag var jeg på vei til Damaskus i et slikt ærende, utrustet med fullmakt og utsendt av øversteprestene. ");
INSERT INTO norlb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Da fikk jeg ved middagstiden se et lys fra himmelen. Det var sterkere enn solen, og både jeg og mine ledsagere ble hyllet inn i lysglansen. ");
INSERT INTO norlb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Vi falt alle til jorden, og jeg hørte en stemme som snakket til meg på arameisk og sa: ’Saulus, Saulus, hvorfor forfølger du meg? Du skader bare deg selv ved å trasse min vilje.’ ");
INSERT INTO norlb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","’Hvem er du, herre?’ spurte jeg. Herren svarte: ’Jeg er Jesus, han som du forfølger. ");
INSERT INTO norlb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Reis deg opp! Jeg har vist meg for deg, for at du skal bli tjeneren min og fortelle alle om det du har sett i dag og alt jeg vil vise deg i framtiden. ");
INSERT INTO norlb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Jeg skal redde deg både fra jødene og andre folk. Ja, jeg skal sende deg til folk som ikke er jøder. ");
INSERT INTO norlb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Du skal åpne øynene deres, slik at de vender om fra mørket til lyset, fra Satans makt til Gud. Ved å tro på meg skal de få tilgivelse for syndene sine og bli regnet med blant dem som tilhører Gud.’ ");
INSERT INTO norlb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Derfor, kong Agrippa, måtte jeg være lydig mot dette synet fra himmelen. ");
INSERT INTO norlb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Først forkynte jeg for dem som bodde i Damaskus og Jerusalem, så fortsatte jeg i hele Judea og gikk videre til andre folk. Over alt oppfordret jeg alle til å forlate syndens vei, vende om til Gud og vise sin forvandling gjennom gode gjerninger. ");
INSERT INTO norlb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Det var derfor jødene arresterte meg i templet og forsøkte å drepe meg. ");
INSERT INTO norlb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Men Gud beskyttet meg, slik at jeg fortsatt lever og kan fortelle om Jesus både for fine mennesker og vanlige folk. Likevel er det ikke noe nytt jeg kommer med. Det jeg snakker om, hadde Gud forutsagt ved profetene og Moses for lenge siden. ");
INSERT INTO norlb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Gud forutsa at Messias, den lovede kongen, måtte lide og bli den første som sto opp fra de døde. Han skulle føre lyset fram både til jøder og andre folk.” ");
INSERT INTO norlb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Da Paulus hadde kommet så langt i sin forsvarstale, ble han plutselig avbrutt av landshøvdingen Festus som ropte: ”Paulus, du er helt fra sans og samling! All lærdommen din har gjort deg fullstendig sinnssyk!” ");
INSERT INTO norlb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulus svarte: ”Nei, høyt ærede Festus, jeg er ikke sinnssyk. Jeg forteller sannheten, rolig og fornuftig. ");
INSERT INTO norlb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kong Agrippa kjenner godt til alle disse spørsmålene. Jeg snakker åpent ut, for jeg er sikker på at disse begivenhetene er kjente for ham. De foregikk jo ikke i noen avkrok av verden! ");
INSERT INTO norlb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kong Agrippa, tror du på det Gud har forutsagt ved profetene? Ja, jeg vet at du gjør det.” ");
INSERT INTO norlb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Da sa Agrippa til ham. ”Holder du på lenger nå, så kommer du til å gjøre også meg til en kristen.” ");
INSERT INTO norlb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulus svarte: ”Enten det går fort eller tar tid, så ønsker jeg til Gud at ikke bare du, men alle som hører meg her i dag, vil bli som jeg, bare uten disse lenkene.” ");
INSERT INTO norlb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kongen, landshøvdingen Berenike og alle de andre reiste seg. ");
INSERT INTO norlb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Da de gikk ut, sa de til hverandre: ”Denne mannen har ikke gjort noe som fortjener dødsstraff eller fengsel.” ");
INSERT INTO norlb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Kong Agrippa sa til Festus: ”Han kunne blitt satt fri, dersom han ikke hadde bedt om å bli dømt ved den keiserlige domstolen i Roma.” ");
INSERT INTO norlb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tiden kom da vi skulle reise til Italia. Paulus og noen andre fanger ble overlevert til en offiser som het Julius, ved Den keiserlige bataljon. ");
INSERT INTO norlb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Med på reisen hadde vi også Aristark fra Tessaloniki i Makedonia. Vi gikk ombord på et skip i Adramyttium og seilte av sted. Skipet skulle seile innom flere steder langs kysten av provinsen Asia. ");
INSERT INTO norlb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Dagen etter la vi til i byen Sidon. Offiseren Julius var vennlig innstilt mot Paulus og lot ham gå i land for å besøke venner og nyte godt av gjestfriheten deres. ");
INSERT INTO norlb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Da vi dro fra Sidon, fikk vi motvind og seilte derfor i le av Kypros. ");
INSERT INTO norlb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Etter det var vi ute på åpent hav og passerte provinsene Kilikia og Pamfylia før vi la til i byen Myra i provinsen Lykia. ");
INSERT INTO norlb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Der fant offiseren et egyptisk skip fra Alexandria som skulle til Italia og som tok oss ombord. ");
INSERT INTO norlb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","I flere dager gikk nå seilturen tungt, etter som vinden sto imot oss. Da vi til slutt nærmet oss øya Knidos, la kapteinen om kursen og seilte rett sørover til vi rundet neset ved Salmone og kom inn i le sjø ved øya Kreta. ");
INSERT INTO norlb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Der klarte vi å kjempe oss fram langs kysten og kom etter en tid til stedet som blir kalt Godhavn nær byen Lasea. ");
INSERT INTO norlb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Vi hadde mistet mye tid, og været holdt på å bli farlig for lange sjøreiser, etter som det allerede var seint på høsten. Paulus advarte derfor offiseren og mannskapet ");
INSERT INTO norlb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","og sa: ”Mine venner, det kommer til å bli store problemer om vi fortsetter reisen. Både skipet og lasten vil gå tapt, og vi kommer til å risikere våre egne liv!” ");
INSERT INTO norlb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Men offiseren som var ansvarlig for fangene, hørte mer på kapteinen og de som eide skipet, enn på Paulus. ");
INSERT INTO norlb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Etter som Godhavn ikke var noen god havn for vinteropplag, syntes de fleste av mannskapet at de skulle seile videre til Føniks og der ta landligge over vinteren. Dette var en god havn lenger vest på Kreta, og som var åpen mot nordvest og sørvest. ");
INSERT INTO norlb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nå begynte det å blåse svak vind fra sør. De trodde derfor at reisen til Føniks skulle bli enkel. Altså lettet de anker og begynte å seile tett inn mot kysten av Kreta. ");
INSERT INTO norlb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","15","Det drøyde ikke lenge før været plutselig slo om. En voldsom storm, den blir kalt nordoststormen, feide ned fra øya og drev skipet med seg ut på åpne havet. Mannskapet forsøkte å snu inn mot land, men klarte det ikke og ble tvunget til å la skipet drive for vinden. ");
INSERT INTO norlb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Til slutt kom vi i le bak en liten øy som het Klauda. Med store problemer kunne vi da få ombord skipsbåten som vi hadde på slep. ");
INSERT INTO norlb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Da vi hadde heist den opp, surret vi skipet med tau for å styrke skroget. Sjømennene var redde for at skipet skulle drive mot sandbankene ved Syrtebukten. Derfor firte de ned storseilet og lot skipet drive. ");
INSERT INTO norlb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Da stormen neste dag fortsatte å rase, begynte mannskapet å kaste lasten overbord. ");
INSERT INTO norlb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Den tredje dagen kastet de også utrustningen på skipet over bord og alt annet som var løst. ");
INSERT INTO norlb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","I flere døgn så vi verken solen eller stjernene og kunne ikke navigere. Stormen fortsatte med uforminsket styrke. Til slutt regnet vi med at alt håp var ute. ");
INSERT INTO norlb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Over lenger tid hadde ingen spist. Til slutt gikk Paulus til mannskapet og soldatene og sa: ”Dere skulle ha hørt på meg allerede fra begynnelsen av og tatt landligge på Kreta over vinteren. Da hadde dere sluppet alle disse problemene og det store tapet. ");
INSERT INTO norlb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Men ikke gi opp håpet! Ingen av oss kommer til å dø, bare skipet vil gå tapt. ");
INSERT INTO norlb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","I natt kom nemlig en engel til meg fra den Gud som jeg tilhører og som jeg tjener. ");
INSERT INTO norlb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Han sa: ’Vær ikke redd Paulus. Du skal stilles for retten hos keiseren. For øvrig har Gud lovet å redde livet til alle dem som seiler sammen med deg.’ ");
INSERT INTO norlb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Gi derfor ikke opp! Jeg stoler på Gud. Alt skal gå akkurat som han har sagt. ");
INSERT INTO norlb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Vi kommer til å drive i land på en øy.” ");
INSERT INTO norlb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Da vi hadde drevet omkring på Adriaterhavet i fjorten stormnetter, oppdaget sjøfolkene midt på natten at vi nærmet oss land. ");
INSERT INTO norlb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","De loddet dybden og oppdaget at den var mindre enn 40 meter. Etter en liten stund målte de dybden til snaut 30 meter. ");
INSERT INTO norlb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","De var redde for at skipet skulle gå på skjærene og kastet ut fire ankere fra akterstavnen. Utålmodig ventet de på at det skulle bli morgen. ");
INSERT INTO norlb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Noen av sjøfolkene forsøkte å rømme skipet. De låret skipsbåten på vannet og sa at de måtte legge ut ankere også fra baugen. ");
INSERT INTO norlb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Da advarte Paulus offiseren og soldatene og sa: ”Vi kommer til å dø alle sammen, dersom disse sjøfolkene ikke blir ombord.” ");
INSERT INTO norlb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Da kappet soldatene tauene og lot skipsbåten drive av sted. ");
INSERT INTO norlb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Straks før det begynte å lysne, oppfordret Paulus på nytt alle om å spise. ”Dere har ikke rørt mat på to uker”, sa han. ");
INSERT INTO norlb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","”Pass på å få i dere litt mat, slik at dere orker anstrenngelsene! Vær ikke redde, ikke et hårstrå på hodene deres kommer til å bli krummet!” ");
INSERT INTO norlb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Han tok et brød, takket Gud, brøt av en bit og spiste. ");
INSERT INTO norlb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Straks kjente alle seg bedre til motes og begynte å spise de også. ");
INSERT INTO norlb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Det var 276 personer om bord. ");
INSERT INTO norlb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Da alle hadde spist seg mette, kastet mannskapet hvetelasten overbord for å gjøre skipet lettere. ");
INSERT INTO norlb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Da det lysnet av dag, kjente de ikke igjen kysten de så, men de merket seg en bukt med en sandstrand og ville forsøke å sette skipet på grunn der. ");
INSERT INTO norlb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","De kappet trossene og lot ankrene falle. Så surret de løs roret, heiste framseilet og satte kursen mot stranden. ");
INSERT INTO norlb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Men skipet støtte på en grunne. Baugen satte seg bom fast, mens akterstavnen begynte å bli brutt i stykker av de voldsomme brenningene. ");
INSERT INTO norlb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Soldatene besluttet da å drepe alle fangene for at ingen skulle svømme i land og rømme. ");
INSERT INTO norlb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Men offiseren ville redde Paulus og hindret at planen ble gjennoført. Han ga befaling om at alle som kunne svømme, først skulle hoppe overbord og ta seg i land. ");
INSERT INTO norlb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Resten skulle forsøke å buksere seg inn til land ved å flyte på planker og vrakrester fra det knuste skipet. På denne måten klarte alle å redde seg opp på stranden. ");
INSERT INTO norlb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","2","Da alle hadde kommet velberget i land, fikk vi greie på at øya het Malta. Befolkning på øya var svært vennlige mot oss og tente et bål på stranden der alle kunne varme seg. Det hadde begynt å regne og var kaldt. ");
INSERT INTO norlb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulus hjalp til med å samle kvist. Mens han kastet et fang på ilden, ble han plutselig bitt av en slange. Den hadde blitt lokket fram av varmen og hogg seg fast i hånden hans. ");
INSERT INTO norlb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Da innbyggerne fra øya så slangen henge i hånden, sa de til hverandre: ”Han er sikkert en morder! Det må han være siden han ble reddet fra havet, men nå blir drept av rettferdighetens gudinne.” ");
INSERT INTO norlb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paulus ristet bare av seg slangen inn i ilden og var like uskadd. ");
INSERT INTO norlb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Alle ventet at hånden skulle hovne opp eller at han plutselig skulle falle død om. Da de hadde ventet lenge og vel og ikke noe av det skjedde, forandret de oppfatning og sa at han måtte være en gud. ");
INSERT INTO norlb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nær stranden der vi kom i land, var det en stor eiendom som tilhørte Publius, som var den fremste mannen på øya. Han hilste oss vennlig velkommen og ga oss mat og husrom i tre dager. ");
INSERT INTO norlb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Samtidig som vi var der, lå far til Publius syk i feber og alvorlig dysenteri. Paulus gikk inn og ba for mannen, la hendene på ham og helbredet ham. ");
INSERT INTO norlb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Etter dette kom alle syke på øya til Paulus og ble helbredet. ");
INSERT INTO norlb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","De viste sin takknemlighet ved å overøse oss med gaver. Da det var tid for oss til å seile av sted, kom folk ombord med alt mulig som vi kunne trenge for reisen. ");
INSERT INTO norlb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Det drøyde tre måneder etter skipsbruddet før vi seilte fra Malta. Denne gangen reiste vi med skipet ”Tvillinggudene” fra Alexandria. Skipet hadde ligget i vinteropplag på øya. ");
INSERT INTO norlb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Først la vi til i Syrakus på Sicilia, der vi stoppet i tre dager. ");
INSERT INTO norlb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Derfra seilte vi direkte til Reggio. En dag seinere fikk vi sydlig vind, og kom etter to dager fram til Puteoli. ");
INSERT INTO norlb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Der fant vi noen troende. De ba oss om å bli hos dem en uke. Det gjorde vi før vi fortsatte landeveien mot Roma. ");
INSERT INTO norlb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","De troende i Roma hadde hørt at vi var under veis. De første møtte oss allerede ved Forum Appii. Flere sluttet seg til følget da vi kom til Tres Tabernæ. Da Paulus så de troende, takket han Gud og fikk nytt mot. ");
INSERT INTO norlb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Til slutt kom vi fram til Roma. Paulus fikk lov til å bo i et privat hus sammen med den soldaten som voktet ham. ");
INSERT INTO norlb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tre dager etter ankomsten kalte Paulus til seg lederne blant jødene. Da alle var samlet, sa han: ”Brødre, jeg ble arrestert i Jerusalem og utlevert til de romerske myndighetene. Dette til tross for at jeg ikke har gjort noe galt mot vårt folk eller brutt noen av tradisjonene fra forfedrene våre. ");
INSERT INTO norlb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romerne stilte meg for domstolen og ville frifinne meg etter som de ikke fant noen grunn til å dømme meg til døden. ");
INSERT INTO norlb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Men jødene protesterte mot beslutningen deres. Derfor ble jeg nødt til å be om å bli dømt ved den keiserlige domstolen. Hensikten er slett ikke på noen måte å anklage mitt eget folk. ");
INSERT INTO norlb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Dette er altså bakgrunnen for at jeg har bedt dere komme hit i dag, slik at vi kan lære hverandre å kjenne. Jeg vil fortelle dere at jeg er bundet med disse lenkene fordi jeg tror at Israels håp, Messias, den lovede kongen, allerede er kommet.” ");
INSERT INTO norlb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","De svarte: ”Vi har ikke fått noen negative rapporter om deg! Det har heller ikke kommet noe brev fra Judea om deg, og ingen av dem som har kommet fra Jerusalem, har hatt noe galt å si om deg. ");
INSERT INTO norlb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Tvert imot, vi vil gjerne vite hva du tror på. Det eneste vi vet om denne nye retningen, er at den støter på motstand over alt.” ");
INSERT INTO norlb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","De ble enige om å treffe hverandre på nytt en annen dag. Da anledningen kom, samlet enda flere folk seg der Paulus bodde. Han begynte tidlig på morgenen og holdt på til sene kvelden med å fortelle og undervise om Guds plan for å frelse menneskene og gjøre alle til sitt eget folk. Ved hjelp av Moseloven og profetene forsøkte han å overbeviste dem om hvem Jesus var. ");
INSERT INTO norlb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Noen begynte å tro, mens andre nektet. ");
INSERT INTO norlb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Etter en heftig diskusjon gikk hver til sitt. Paulus ga et siste ord med på veien: ”Guds Hellige Ånd hadde rett da den ved profeten Jesaja sa: ");
INSERT INTO norlb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","’Gå og si til dette folket: Dere skal høre det jeg sier, men likevel ikke forstå. Dere skal se hva jeg gjør, men likevel ikke fatte! ");
INSERT INTO norlb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ja, hjertet til dette folket er så hardt og likegyldig at det ikke kan forstå. Hørselen deres er svekket, slik at de ikke kan høre. Øynene deres er lukket, slik at de ikke kan se. Derfor kan de ikke vende om til meg og bli helbredet!’ ");
INSERT INTO norlb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Dere må ha det klart for dere at Gud også vil frelse andre folk enn jødene. Og de kommer til å ta imot frelsen.” ");
INSERT INTO norlb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulus bodde to år i det huset han hadde leid. Han tok imot alle som kom på besøk. ");
INSERT INTO norlb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Åpent underviste han om Herren Jesus Kristus og Guds plan for å frelse menneskene og gjøre alle til sitt eget folk. Ingen forsøkte å hindre ham.");
INSERT INTO norlb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","2","Hilsen fra Paulus, som er Jesu Kristi tjener. Jeg er valgt ut av Gud for å være hans utsending og spre det glade budskapet som han for lenge siden lovet oss ved profetene sine i den Hellige Skriften. ");
INSERT INTO norlb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Dette er det glade budskapet om hans Sønn, Jesus Kristus, vår Herre. Han kom til verden som et menneske og ble født inn i slekten til kong David. Jesus Kristus var ikke bare menneske. Samtidig var han Guds sønn, noe som Gud på en mektig måte ga bevis på ved å la sin Hellige Ånd reise ham opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesus Kristus har gitt meg den forretten å få være hans utsending og fortelle alle folk om det han har gjort, slik at de kan begynne å tro og lyde ham. Gjennom dette livet kan alle gi Gud ære. ");
INSERT INTO norlb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Blant dem som har fått innbydelsen for å høre Jesus Kristus til, er også dere. ");
INSERT INTO norlb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Til alle dere som bor i Roma, som er elsket av Gud og har takket ja til innbydelsen hans om å tilhøre ham. Jeg ber om at Gud, vår Far, og Herren Jesus Kristus, vil vise dere godhet og fylle dere med fred. ");
INSERT INTO norlb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Først av alt vil jeg si at jeg takker Gud for dere alle på grunn av det Jesus Kristus har gjort. Jeg takker Gud, etter som de over alt snakker om den troen dere har. ");
INSERT INTO norlb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Gud selv vet at jeg stadig ber for dere. Det er ham jeg tjener av hele hjertet mens jeg sprer det glade budskapet om Guds sønn. ");
INSERT INTO norlb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","En ting jeg alltid ber om, er at jeg en dag må få muligheten til å reise til dere, om Gud vil. ");
INSERT INTO norlb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Jeg lengter etter å treffe dere og dele alt godt med dere som Gud ved sin Ånd vil gi oss, slik at dere blir styrket i troen. ");
INSERT INTO norlb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Eller rettere sagt: Slik at jeg kan oppmuntre dere, og dere meg, gjennom den tro vi har felles. ");
INSERT INTO norlb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Jeg vil at dere skal vite, kjære søsken, at jeg flere ganger har tenkt å komme til dere, for at troen skal få det samme gode resultat hos dere, som den har fått hos andre folk. Alltid er det blitt noe som hindret meg i å komme. ");
INSERT INTO norlb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Det inngår i oppdraget mitt å nå ut til folk, både i vår kultur og i andre kulturer, både til dem som er velutdannet og til vanlig enkle mennesker. ");
INSERT INTO norlb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Derfor vil jeg gjerne komme til dere i Roma, slik at jeg kan spre det glade budskapet også der. ");
INSERT INTO norlb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Jeg skammer meg ikke for det glade budskapet om Jesus. Det handler om Guds kraft til å frelse hver og en som tror. Jødene var de første som fikk høre budskapet, men det gjelder for alle folk. ");
INSERT INTO norlb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Det glade budskapet gjør klart at vi gjennom helhjertet å tro på Jesus, kan bli skyldfri innfor Gud. Det står i Skriften: ”Den som tror, blir skyldfri innfor Gud og får leve.” ");
INSERT INTO norlb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Gud viser fra himmelen sitt sinne mot alle mennesker som lever i synd og ondskap, og som hindrer andre fra å kjenne til sannheten om ham. ");
INSERT INTO norlb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","De blir straffet fordi de ikke vil lyde Gud til tross for at de allerede kjenner til det vi kan vite om ham. Gud har vist hvem han er. ");
INSERT INTO norlb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Helt siden verden ble skapt har menneskene kunne se Guds grenseløse makt og forstå at han virkelig er Gud. De kan ikke med sitt blotte øye oppdage egenskapene hans, men de kan forstå hvem Gud er gjennom å betrakte alt han har skapt. Derfor finnes det ingen unnskyldning for dem som ikke vil lyde Gud! ");
INSERT INTO norlb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Til tross for at menneskene kjente Gud, nektet de å tilbe ham som Gud og takke ham. I stedet henga de seg til egne fantasier om tilværelsen. Deres forvirrede sinn ble fylt av et åndelig mørke. ");
INSERT INTO norlb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","De påsto seg å være kloke, men endte i stedet i den komplette dårskap. ");
INSERT INTO norlb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","I stedet for å tilbe Gud, han som har all makt og aldri kan dø, tilba de avguder, bilder av vanlige dødelige mennesker og alle slags dyr, både slike som flyr og slike som lever på land. ");
INSERT INTO norlb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Gud lot folkene følge sine egne begjær. De utførte motbydelige og skammelige seksuelle handlinger med hverandre. ");
INSERT INTO norlb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","I stedet for å tro på Gud, han som er sannheten, valgte de å tro på løgn og bedrag. De tilba og tjente det skapte i stedet for Skaperen. Han er den som skal bli hyllet for evig. Ja, dette er sant! ");
INSERT INTO norlb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Etter som de trodde på løgn og bedrag, lot Gud dem hengi seg til homoseksuelle aktiviteter. Til og med kvinnene byttet ut sin naturlige seksualitet og tilfredsstilte sine behov med hverandre. ");
INSERT INTO norlb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mennene sluttet å ha naturlige seksuelle forhold til kvinner og begynte å bli tent av begjær til hverandre, slik at de utførte skammelige handlinger med andre menn. På denne måten ble de selv årsaken til den rettferdige straffen de fikk for sin ondskap. ");
INSERT INTO norlb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ja, etter som de ikke brydde seg om å kjenne Gud, lot Gud dem få følge sine egne onde tanker, slik at de gjorde det de ikke skulle ha gjort. ");
INSERT INTO norlb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Menneskene ble fylt av all slags ondskap, umoral, egoisme, hat, misunnelse, mordlyst, aggresjon, svik og ond vilje. ");
INSERT INTO norlb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ja, de sladrer og lyver om andre. De håner Gud. De er storsnutet, arrogante og skrytende. De finner stadig nye måter til å gjøre det som er ondt, de er ulydige mot foreldrene sine. ");
INSERT INTO norlb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","De tenker aldri på andre, men bryter stadig løftene sine, etter som de mangler både kjærlighet og medfølelse. ");
INSERT INTO norlb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","De vet at Gud en dag skal straffe dem med døden for det de gjør, men likevel fortsetter de. Ikke nok med det: De roser også andre som lever på dette viset. ");
INSERT INTO norlb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Selv om Gud en dag vil straffe menneskene, har du ingen rett til å dømme andre, hvem du enn er. Om du dømmer en annen for det han gjør, da dømmer du jo samtidig deg selv, etter som du handler på samme måten som han. Det finnes ingen unnskyldning for deg som dømmer! ");
INSERT INTO norlb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Vi vet at Gud har rett når han dømmer dem som lever på denne måten. ");
INSERT INTO norlb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Men du som dømmer dine medmennesker, du tror vel ikke at Gud bare skal dømme de andre, og ha overbærenhet med deg når du handler på samme måten? ");
INSERT INTO norlb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Du skal ikke undervurdere Gud, når han på grunn av sin godhet og sin tålmodighet ikke straffer deg! Innser du ikke at han ved sin godhet vil få deg til å vende om til ham? ");
INSERT INTO norlb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Dersom du gjenstridig nekter å vende om til Gud, da gjør du din straff verre på dommens dag, for på den dagen skal det vise seg at Gud dømmer alle rettferdig. ");
INSERT INTO norlb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Da skal hver og en få lønn etter sine gjerninger. ");
INSERT INTO norlb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Gud skal gi evig liv til dem som uten å bli trette fortsetter å gjøre det gode og søker herlighet, ære og udødelighet sammen med Gud. ");
INSERT INTO norlb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Men han skal i sitt sinne straffe dem som bare tenker på seg selv, og som i stedet for å gjøre det som er rett, lever i ondskap. ");
INSERT INTO norlb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Nød og angst skal ramme hvert mennesker som gjør det onde. Dette gjelder jødene, som først fikk høre Guds budskap, men også alle andre folk. ");
INSERT INTO norlb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","På samme måten skal herlighet, ære og fred bli gitt til hver og en som gjør det gode. Det skal bli gitt til jødene, som først fikk høre Guds budskap, men også til alle andre folk. ");
INSERT INTO norlb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Gud behandler alle likt. ");
INSERT INTO norlb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Gud skal straffe alle folk for syndene deres, også om de ikke kjenner til Moseloven som Gud ga til jødene. Men han skal også straffe jødene for syndene deres, etter som de har fått loven. ");
INSERT INTO norlb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Det rekker nemlig ikke å bare kjenne teoretisk til loven for å bli skyldfri innfor Gud. Vi må også følge den. ");
INSERT INTO norlb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Bare jødene har fått Guds lov skriftlig. Men når andre folk, uten å kjenne til loven, likevel lyder det som står i den, da forstår vi at de vet forskjell på godt og ondt. ");
INSERT INTO norlb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","De viser ved handlingene sine at loven er skrevet i hjertene deres. Deres samvittighet reagerer alt etter om de handler rett eller galt. ");
INSERT INTO norlb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","At det er slik, vil vise seg den dagen da Jesus Kristus på Guds befaling skal dømme oss alle etter våre innerste tanker og motiv. Dette er det budskapet jeg har fått fra Gud. ");
INSERT INTO norlb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Dere som er jøder, stoler på den loven dere har fått fra Gud. Dere er stolte over det spesielle forholdet dere har til ham. ");
INSERT INTO norlb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Dere sier at dere kjenner Guds vilje og vet hvordan alle bør handle, etter som dere har fått lære dere det som står i Moseloven. ");
INSERT INTO norlb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Dere sier at dere kan peke ut Guds vei for de blinde og være et lys for dem som lever i åndelig mørke. ");
INSERT INTO norlb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Dere vil veilede uforstandige og undervise de umodne. Deres tro på loven har gitt dere den fullkomne kunnskapen om det som er rett og galt. ");
INSERT INTO norlb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ja, dere underviser andre, men ikke dere selv! Dere sier til andre at de ikke skal stjele, men dere er selv tyver. ");
INSERT INTO norlb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Dere sier at det er galt å være utro i ekteskapet, men dere er selv utro. Dere sier at de ikke skal tilbe avguder, men dere plyndrer avgudstemplene for å tjene penger. ");
INSERT INTO norlb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Dere er stolte over å ha Moseloven, men bringer skam over Gud ved å bryte den. ");
INSERT INTO norlb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Det står i Skriften: ”Andre folk håner Gud på grunn av dere.” ");
INSERT INTO norlb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Dere jøder som tror dere holder paktene med Gud ved å omskjære sønnene deres, dere har bare nytte av denne seremonien dersom dere samtidig lyder hele Moseloven. Dersom dere ikke gjør det, da er dere ikke noe bedre enn andre folk, som ikke omskjærer sønnene sine. ");
INSERT INTO norlb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Om noen fra et annet folk lyder loven, skulle ikke da den personen få det privilegiet å tilhøre Guds eget folk? ");
INSERT INTO norlb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Jo, og på dommens dag skal de som ikke er omskåret rent fysisk, men likevel følger loven, anklage dere jøder, dere som omskjærer sønnene deres og har fått loven, men ikke følger den. ");
INSERT INTO norlb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Alle som kaller seg jøder, tilhører altså ikke Guds eget folk. Det har ikke noe med den fysiske omskjærelsen å gjøre. ");
INSERT INTO norlb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nei, den som vil tilhøre Guds eget folk, må ha et rett forhold til Gud. Det virkelige tegnet på dem som tilhører Guds folk, altså den virkelige omskjærelsen, er ikke det bokstavelige, fysiske inngrepet som Moseloven beskriver, men det handler om at Guds Ånd får forvandle hjertet. Og den som har gjennomgått en slik forvandling, blir æret av Gud, ikke av mennesker. ");
INSERT INTO norlb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Hvilken fordel er det å være jøde? Finnes det noen verdi i den jødiske seremonien å omskjære sønner? ");
INSERT INTO norlb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ja, å være jøde er en enorm fordel. Den fremste grunnen er at det var jødene som fikk Guds budskap for å spre det videre til andre. ");
INSERT INTO norlb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","At visse jøder på et seinere tidspunkt ga opp troen på Gud, det forandrer ingenting. Skulle Gud bryte løftene sine, bare fordi disse menneskene ikke holdt det de hadde lovet? ");
INSERT INTO norlb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Selvfølgelig ikke! Selv om hvert eneste menneske lyver, så snakker Gud alltid sant. Det står i Skriften: ”De skal se at du har rett i alt du sier, og at du vinner seier når de anklager deg.” ");
INSERT INTO norlb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","”Men”, sier noen, ”det må være bra for Gud dersom vi handler galt, for da forstår alle at han handler rett. Derfor er det også urettferdig at han straffer oss.” Ja, slik tenker noen mennesker. ");
INSERT INTO norlb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Nei, Gud er ikke urettferdig! Hvordan skulle han da kunne dømme menneskene? ");
INSERT INTO norlb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Noen sier kanskje: ”Hvorfor skal jeg bli kalt for en synder og bli dømt? Det er jo bra for Gud om jeg lyver, for da ser alle klart og tydelig at han snakker sant. Da kommer alle til å ære ham.” ");
INSERT INTO norlb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Men tenker de på denne måten, da kunne de like gjerne si: ”Jo mer vi synder, desto bedre, for da kommer Gud til å bli æret for sin godhet!” Noen påstår at det er på denne måten jeg underviser, men de som snakker slik, skal få den straffen de fortjener. ");
INSERT INTO norlb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Hva har vi nå kommet fram til? Er vi jøder bedre enn andre? Nei, slett ikke, for jeg har allerede forklart at alle mennesker uten unntak er syndere enten det er jøder eller ikke. ");
INSERT INTO norlb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Det står i Skriften: ”Ikke noe menneske er skyldfri innfor Gud, ikke et eneste. ");
INSERT INTO norlb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ikke noen er forstandig, ingen søker Gud. ");
INSERT INTO norlb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Alle har vendt ham ryggen, alle er like fulle av synd. Ingen gjør det som er rett, ikke en eneste. ");
INSERT INTO norlb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Deres prat er motbydelig og råtten, lik stanken fra en åpen grav. De lyver og bedrar. Deres ord er som giften fra huggormen. ");
INSERT INTO norlb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Alt de sier, er fylt av forbannelser og bitterhet. ");
INSERT INTO norlb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","De er raske å gripe til vold og død, ");
INSERT INTO norlb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","hvor de enn drar fram etterlater de seg nød og elendighet. ");
INSERT INTO norlb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","De kjenner ikke til den veien som leder til fred. ");
INSERT INTO norlb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","De kommer ikke på den tanken å vise respekt for Gud.” ");
INSERT INTO norlb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Selvfølgelig gjelder Moseloven for jødene. Hensikten med loven er at ingen skal ha noen unnskyldninger å komme med, og at alle mennesker skal bli dømt av Gud. ");
INSERT INTO norlb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ingen kan noen gang stå skyldfri innfor Gud gjennom det å holde alt som står i loven. Nei, loven kan bare få oss til å innse at vi er syndere. ");
INSERT INTO norlb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Men nå har Gud vist oss en annen vei til å bli skyldfri innfor ham enn gjennom det å holde alt som står i Moseloven. Denne veien har Gud hele tiden vist oss i Moseloven og profetene. ");
INSERT INTO norlb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Vi kan bli skyldfri for Gud gjennom å tro på Jesus Kristus. Dette gjelder alle, hvem vi enn er. ");
INSERT INTO norlb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Alle har syndet og mistet fellesskapet med Gud, han som kan frelse oss. ");
INSERT INTO norlb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Men nå har han gitt oss en mulighet som vi ikke fortjener. Han har vist oss nåde og latt oss bli skyldfri innfor ham gjennom å la Jesus Kristus kjøpe oss fri fra vårt slaveri under synden. ");
INSERT INTO norlb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Gud lot Jesus ofre sitt blod, og han tok straffen for syndene våre på seg for at alle som tror, skal få tilgivelse. Gud ville gjennom dette vise hvor fullkommen god og rettferdig han er. I sin store tålmodighet lot han straffen vente for de syndene som menneskene gjorde for lenge siden. I vår egen tid lot han Jesus dø, og han tok straffen vår. Ja, Gud viste sin godhet ved å la oss bli skyldfrie dersom vi tror på Jesus. ");
INSERT INTO norlb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Har vi da noe å skryte av når det gjelder vårt forhold til Gud? Nei, slett ikke, for det er ikke gjennom våre gode gjerninger vi har blitt forsonet med Gud, men gjennom troen. ");
INSERT INTO norlb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Vi er nemlig fullt overbevist om at menneskene blir skyldfri innfor Gud på grunn av troen, og ikke ved at de forsøker å holde alt som står i Moseloven. ");
INSERT INTO norlb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ellers ville jo Gud bare være Gud for jødene. Sikkert nok er han Gud for alle folk? Ja, selvfølgelig er han Gud for alle, ");
INSERT INTO norlb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","etter som det bare finnes en Gud. Han lar alle mennesker bli skyldfri innfor ham gjennom det at de tror. Det gjelder både jøder og andre folk. ");
INSERT INTO norlb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Når vi sier at troen er så viktig, betyr da det at vi kan være likegyldige til Moseloven? Nei, tvert imot! Gjennom det å tro på Jesus respekterer vi det som står i loven. ");
INSERT INTO norlb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Hvilken erfaring hadde Abraham, som var stamfar for Israels folk, av å bli frelst gjennom tro? ");
INSERT INTO norlb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Var det på grunn av gode gjerninger Gud aksepterte han? Ja, i så tilfelle kunne han virkelig vært stolt over seg selv. Men det var ikke derfor han ble regnet skyldfri innfor Gud. ");
INSERT INTO norlb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Hva står det i Skriften? Jo, at ”Abraham trodde på Gud, og derfor ble regnet som skyldfri innfor Gud”. ");
INSERT INTO norlb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Den som arbeider, får ikke sin lønn som en gave, men som betaling for det han har utrettet. ");
INSERT INTO norlb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Den som blir erklært skyldfri innfor Gud på grunn av troen, får det ikke som betaling for noe han har utrettet. ");
INSERT INTO norlb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Derfor beskriver også kong David hvor lykkelig det mennesket er som uten å fortjene det blir regnet som skyldfri innfor Gud. Han skriver: ");
INSERT INTO norlb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","”Lykkelig er den som har fått tilgivelse for sin ulydighet og fått synden sin strøket bort! ");
INSERT INTO norlb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ja, lykkelig er den som Herren ikke lenger anklager for synd.” ");
INSERT INTO norlb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Men nå er spørsmålet: Gjelder denne lykken bare for jødene, de som holder Guds pakt ved å omskjære sine sønner. Gjelder den også andre folk? La oss vende tilbake til Abraham. Jeg sa før at det var på grunn av troen at Abraham ble regnet som skyldfri innfor Gud. ");
INSERT INTO norlb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Når ble han da skyldfri? Var det etter at han hadde blitt omskåret, eller var det før? Svaret er at Gud aksepterte ham før han ble omskåret. ");
INSERT INTO norlb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Seremonien med å omskjære alle menn var et tegn på at Abraham ved troen hadde blitt skyldfri innfor Gud allerede før han ble omskåret. Gjennom dette ble han en åndelig far for alle som tror, også om de ikke omskjærer sine sønner. ");
INSERT INTO norlb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abraham ble også en åndelig far for sitt eget folk som omskjærer sønnene, men han er bare deres åndelige far dersom de har samme slags tro som han hadde før han ble omskåret. ");
INSERT INTO norlb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Det var altså ikke fordi Abraham var lydig mot loven at han fikk løftet om at etterkommerne hans skulle arve hele jorden. Nei, han fikk løftet fordi troen hadde gjort ham skyldfri innfor Gud. Hans etterkommere skulle få løftet oppfylt gjennom å tro på Gud, akkurat som Abraham. ");
INSERT INTO norlb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","De som forsøker bli skyldfrie ved å være lydig mot Moseloven, kan ikke være Abrahams etterkommere. Da ville troen være uten mening, og løftet ville ikke gjelde. ");
INSERT INTO norlb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Husk på at lovens krav er så høye at alle blir dømt av den. Å ha en lov betyr også at vi kan overtre den. ");
INSERT INTO norlb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Derfor er troen det viktigste! Guds løfte var en fri gave til alle Abrahams etterkommere, både til dem som har fått Moseloven og til dem som bare har samme slags tro som Abraham. Han er en åndelig far for alle som tror. ");
INSERT INTO norlb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Gud sier i Skriften: ”Jeg har gjort deg til far for mange folk.” I Guds øyne er han vår far, for han trodde på den Gud som gjør de døde levende og får ting til å skje som ikke før var mulig. ");
INSERT INTO norlb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Når Gud lovet Abraham at han skulle bli far til mange folk, da trodde Abraham på Gud. Dette til tross for at det menneskelig sett ikke var noe håp om at han kunne bli far. Men Gud hadde sagt: ”Dine etterkommere skal bli så mange at det ikke er mulige å telle dem.” ");
INSERT INTO norlb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Derfor fortsatte Abraham å tro til tross for at han var omkring 100 år gammel og uten kraft i kroppen, og til tross for at kona Sara ikke kunne få barn og i tillegg var rent for gammel. ");
INSERT INTO norlb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Nei, Abraham tvilte aldri på Guds løfte, for troen ga ham styrke, og han æret Gud. ");
INSERT INTO norlb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Han var helt overbevist om at Gud kan gjøre hva som helst når han har lovet det. ");
INSERT INTO norlb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Derfor ble han regnet som skyldfri innfor Gud. ");
INSERT INTO norlb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Sannheten om at han ”ble regnet som skyldfri innfor Gud”, ble ikke skrevet bare med tanke på Abraham. ");
INSERT INTO norlb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Den gjelder også for oss. Vi skal også bli regnet som skyldfrie etter som vi tror på Gud, han som vakte opp vår Herre Jesus fra de døde. ");
INSERT INTO norlb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Herren Jesus ble utlevert for å dø for syndene våre, og ble vakt opp igjen for at vi skulle bli skyldfrie innfor Gud. ");
INSERT INTO norlb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Når vi nå har blitt skyldfri innfor Gud ved å tro, har vi fred med Gud gjennom det vår Herre Jesus Kristus har gjort for oss. ");
INSERT INTO norlb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","På grunn av troen har Gud i sin godhet tilgitt oss. Ja, vi bygger nå vårt liv på Guds tilgivelse, og kan med stolthet og glede se fram til den dagen da vi får ta del i Guds herlighet. ");
INSERT INTO norlb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Vi gleder oss ikke bare over dette, men også over de lidelsene vi må gå gjennom. Vi vet at lidelsene gjør oss utholdende. ");
INSERT INTO norlb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Utholdigheten gjør oss faste i troen, slik at vi konstant klamrer oss til håpet om at vi til slutt blir frelst for evig. ");
INSERT INTO norlb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Dette håpet om frelse kommer ikke til å gå over i skuffelse, for vi vet hvor sterkt Gud elsker oss. Han har gitt oss sin Hellige Ånd som fyller våre hjerter med kjærlighet. ");
INSERT INTO norlb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Mens vi ennå var hjelpeløse og svake, da kom Kristus. Han innfant seg på det tidspunktet som var i tråd med Guds plan, og døde for alle oss som ikke brydde oss om Gud. ");
INSERT INTO norlb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Snaut nok er det vel noen som ville ofre livet sitt selv for et menneske som lever rett? Muligens ville noen ta på seg å dø for en som var god tvers i gjennom. ");
INSERT INTO norlb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Men Gud beviste hvor sterkt han elsket oss, ved at Kristus døde for oss, ennå mens vi, var syndere. ");
INSERT INTO norlb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Da vi nå har blitt skyldfri innfor Gud ved at Jesus ofret sitt blod for oss, kan vi være helt trygge på at han også vil frelse oss fra å bli dømt av Gud. ");
INSERT INTO norlb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Vi var Guds fiender, men ble forsonet med ham gjennom det at Sønnen tok straffen vår da han døde. Derfor kan vi, nå når vi er Guds venner, også være trygge på at Sønnen vil frelse oss fra evig straff, etter som han sto opp fra de døde. ");
INSERT INTO norlb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ikke nok med det, vi gleder oss over det fellesskap vi har med Gud allerede nå, et fellesskap som ble mulig gjennom at vår Herre Jesus forsonet oss med Gud og gjorde oss til vennene hans. ");
INSERT INTO norlb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Gjennom det ene mennesket, som var Adam, kom synden inn i hele menneskeslekten. Straffen for synden var at Adam måtte dø. Etter den dagen dør alle mennesker, etter som alle har syndet. ");
INSERT INTO norlb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ja, menneskene syndet lenge før jødene hadde fått Moseloven. Til tross for at det ikke var noen lov å bryte, ");
INSERT INTO norlb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","døde alle menneskene som levde i tidsperioden mellom Adam og Moses. De døde selv om de ikke hadde vært direkte ulydige mot Guds befaling, slik som Adam hadde vært. Adam hadde en viss likhet med Jesus, han som skulle komme seinere, og likevel var det en skarp kontrast mellom de to. ");
INSERT INTO norlb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","For det er en enorm forskjell mellom et menneske som synder, og Gud, som i sin godhet tilgir. Likheten består i at det var et menneske alene som gjennom sin synd gjorde det slik at alle måtte dø. Og at det var et menneske alene, Jesus Kristus, som gjorde det slik at Gud ga alle den tilgivelsen vi ikke fortjener. Denne frie gaven, som Gud i sin godhet ga oss, er uendelig mye større. ");
INSERT INTO norlb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Det er også stor forskjell mellom konsekvensene av den ene mannen sin synd og Guds fri gave, tilgivelsen. Synden til den ene mannen førte til at alle menneskene ble dømt til å dø, mens synden hos alle mennesker førte til at Gud viste oss nåde og tilga oss. ");
INSERT INTO norlb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Det er sant at det ene menneske sin synd gjorde at døden fikk makt over alle mennesker. Men det er like så sant at det ene menneske, Jesus Kristus, har gjort det slik at livet dominerer i alle som tar imot Guds frie gave. Gud lar oss i sin grenseløse godhet bli skyldfri innfor ham, dersom vi tar imot tilgivelsen hans. ");
INSERT INTO norlb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ja, den ene syndige handlingen av Adam gjorde det slik at alle mennesker ble dømt til å dø, mens den ene rette handlingen av Kristus gjorde det slik at alle kan bli tilgitt av Gud og få leve. ");
INSERT INTO norlb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Gjennom det at det ene menneske var ulydig mot Gud, ble vi alle syndere. På samme måten skal vi, ved at det ene menneske var lydig mot Gud, bli skyldfri innfor ham. ");
INSERT INTO norlb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Gud ga oss Moseloven for klart å vise at menneskene ikke følger hans vilje. Men da det sto klart at menneskene stadig bryter Guds lov, viste det seg også at hans godhet er uendelig stor, etter som han tilgir. ");
INSERT INTO norlb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Før hersket jo synden over alle mennesker og førte døden inn i verden. Nå overtar i stedet Guds kjærlighet og tilgivelse makten, ved at Jesus Kristus, vår Herre, og gjør oss skyldfri innfor Gud og gir oss evig liv. ");
INSERT INTO norlb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Hva betyr da dette? Skal vi fortsette å synde, slik at Gud kan vise sin godhet og tilgi oss gang på gang? ");
INSERT INTO norlb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Nei, selvfølgelig ikke! Synden har jo ikke lenger noen makt over oss. Hvordan kan vi da fortsette å synde? ");
INSERT INTO norlb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Vet dere ikke at alle vi som har blitt døpt inn i fellesskapet med Jesus Kristus, også døde sammen med ham da vi ble døpt? ");
INSERT INTO norlb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ja, gjennom dåpen er vi både døde og begravd sammen med ham. På samme måten som Kristus ble vakt opp fra de døde ved sin Fars store makt, får også vi nå leve et nytt liv. ");
INSERT INTO norlb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Om vi altså har blitt fullt og helt forent med Kristus gjennom det å dø sammen med ham, da skal vi også bli levende igjen sammen med ham. ");
INSERT INTO norlb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Vi vet at vårt gamle ego ble spikret fast på korset sammen med ham, for at synden skulle miste makten over oss. Derfor er vi ikke lenger slaver under synden. ");
INSERT INTO norlb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Den som er død, kan jo ikke bli lokket til å synde. ");
INSERT INTO norlb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Men om vi døde sammen med Kristus, da skal vi også leve i fellesskap med ham. Dette tror vi på. ");
INSERT INTO norlb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Vi vet at Kristus har stått opp fra de døde og aldri mer vil dø. Døden har ikke lenger noen makt over han. ");
INSERT INTO norlb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Han døde for å knuse syndens makt, en gang for alle. Nå lever han for å ære Gud. ");
INSERT INTO norlb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Gjennom fellesskapet med Jesus Kristus er dere døde i forhold til synden og kan nå leve for å ære Gud. Det er slik dere skal se på dere selv. ");
INSERT INTO norlb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","La altså ikke synden få makt over deres dødelige kropper, slik at dere gir etter for kroppens begjær. ");
INSERT INTO norlb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Pass på at dere ikke bruker deres kropper i det ondes tjeneste ved å synde, men la Gud bruke deres kropper i tjeneste for det gode, slik at dere ærer ham. Dere har jo gått over fra død til liv. ");
INSERT INTO norlb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Synden skal ikke lenger styre dere, slik den gjorde da dere i egen kraft forsøkte å leve opp til kravet i Moseloven. Dere har blitt løst fra lovens krav gjennom det at Gud i sin godhet har tilgitt dere. ");
INSERT INTO norlb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Hva betyr da dette? Er vi fri til å synde, etter som Gud har tilgitt oss og i sin godhet satt oss fri fra kravet i Moseloven? Nei, naturligvis ikke! ");
INSERT INTO norlb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Innser dere ikke at dere selv kan velge hvem som skal ha makt over dere? Velger dere å bli slaver under synden, kommer det til å lede til død. Velger dere derimot å være lydig mot Gud, da blir dere skyldfri innfor ham. ");
INSERT INTO norlb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Jeg takker Gud for dere! Dere som en gang var slaver under synden, valgte av et helt hjerte å være lydig mot den undervisningen om Jesus som dere har fått høre. ");
INSERT INTO norlb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nå er dere fri fra synden, og har blitt Guds slaver i tjeneste for det gode. ");
INSERT INTO norlb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Jeg bruker bildet av slavene, etter som dette er lett å forstå. Tidligere lot dere kroppen deres være slave under umoralske begjær, slik at dere gjorde det som stred mot Guds vilje og ble mer og mer ulydige mot ham. La nå i stedet kroppen bli Guds slave, slik at dere kan gjøre det som er godt og leve fullt og helt for ham. ");
INSERT INTO norlb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Da dere var slaver under synden, ble dere komplett likegyldige i forholdet om hva som var rett og galt. ");
INSERT INTO norlb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Hva ble resultatet? Selvfølgelig, at dere gjorde slikt som dere nå skammer dere over, etter som dere vet at det leder til døden. ");
INSERT INTO norlb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Nå har dere blitt fri fra syndens makt og er blitt Guds slaver. Resultatet blir at dere lever helt og fullt for Gud og til slutt får evig liv. ");
INSERT INTO norlb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Syndens lønn er døden, men Guds gave er evig liv sammen med Jesus Kristus, vår Herre. ");
INSERT INTO norlb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Dere vet sikkert, kjære søsken, at lovene i et samfunn bare bestemmer over et menneske så lenge det lever. Dere kjenner selv til våre jordiske lover. ");
INSERT INTO norlb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","La meg bruke et bilde: Når en kvinne gifter seg, er hun på grunn av loven bundet til mannen så lenge han lever. Dersom mannen dør, er hun ikke lenger bundet til ham, men er fri fra loven som regulerer ekteskapet. ");
INSERT INTO norlb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Dersom hun går til en annen mens mannen hennes ennå lever, da er hun utro i ekteskapet. Dersom mannen hennes dør, er hun fri fra loven og kan leve med en annen, uten å være utro mot sin første mann. ");
INSERT INTO norlb_vpl VALUES ("RM7_4","075_7_4