﻿USE sofia;
DROP TABLE IF EXISTS sofia.nop_vpl;
CREATE TABLE nop_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nop_vpl WRITE;
INSERT INTO nop_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mebineŋ tububihila Bepaŋdi kunum eŋ kwet yehitubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kwet adi giyoŋgiyoŋeeŋ eŋ hamap hakuk. Kaŋ mambip wapumdi ime wapum fuliŋgoŋ hinek mambipnit u kufulaŋa hakuk. Kaŋ Wapum’walaŋ Munabulidi ime foloniŋgoŋ wole-kumuŋkumuŋeeŋ hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kaŋ Bepaŋdi indiŋ yoguk, “Hautawek!” yobune hautaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kaŋ Bepaŋ adi hauta kaune utumbaune hauta eŋ mambip yehidaneguk. ");
INSERT INTO nop_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tiŋa hautadok wou hadapmo yoguk eŋ mambipdok wou bufa yoguk. Unduŋ tulune kwet bufaaŋ heleune melenai 1 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kaŋ Bepaŋ adi indiŋ yoguk, “Ime lekiŋgoŋ ginaŋ kamehep fafaŋeniŋ niŋ mintaaŋ wendigoŋ ime danewek.” ");
INSERT INTO nop_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Unduŋ yobune ime lekiŋgoŋ kamehep wapum mintaaŋ ime daneune fukuniŋ wohiŋkade loguk eŋ fukuniŋ komaŋkade hakuk, kaŋ lekiŋgoŋ hamap mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kaŋ Bepaŋdi wou hamap wapum yoguk. Unduŋ tulune kwet bufaaŋ heleune melenai 2 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kaŋ Bepaŋdi indiŋ yoguk, “Kunum falipmeŋ ime dambek niŋkadegoŋ wooŋ bopneune kwet silidawek.” Yobune undugoŋ mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kaŋ Bepaŋdi siliŋ wondok wou kwet yoguk, eŋ imeŋgwaŋ wapum wondok wou luhi yoguk. Unduŋ tiŋa kaune utumba tuguk. ");
INSERT INTO nop_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kaŋ Bepaŋdi yoguk “Kwet foloŋ nemenemek duhuŋa labiiŋ u kadoŋa labuneŋ, nanaŋe, yuwoiyuwoi, wowoŋgimiŋ youlihinit hogohogok, eŋ bem heki, kilikihik namandap molomolom kadoŋa labuneŋ.” Yobune undugoŋ hinek mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kwetdi yehininiŋineune nanaŋe, yuwoiyuwoi, wowoŋgimiŋ mebimebi eŋ bem mebimebi youli hinit hogohogok labugiŋ, folonamandap molomolom labugiŋ. Kaŋ Bepaŋdi kaune utumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kaŋ kwet bufaaŋ heleune melenai 3 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Kaŋ Bepaŋdi indiŋ yoguk, “Kunum ginaŋ hauta mintaneŋ. Tiŋa adikuyeŋgoŋ hadapmo eŋ bufa yehidaneyaneeŋ. Tiŋa yeyaneeŋ e gwi mele eŋ duhuduhu nai eŋ gulet nai diniŋ fek tiŋa kunumneniŋ hauta tiŋa hautayaneeŋ.” Yobune undugoŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bepaŋdi unduŋ tiŋa kudup hauta wapumnit lufom yehitubumintaguk, hauta wapumgoŋdi hadapmo timeŋ tiŋa kadokooŋ hatidok, eŋ hauta wapum niŋ gwehegweheyeŋgoŋdi bufa kadokooŋ hatidok yapmeguk. Tiŋa yeguk e hinantilamek maaŋ yehitubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Adi kwet tubuhautadok ");
INSERT INTO nop_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","eŋ bufa dut hadapmo yabudokooŋ bufa eŋ hadapmo yehidanedok kunum foloŋ yapmeguk. Unduŋ tiŋa Bepaŋdi kaune utumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Unduŋ tulune kwet bufaaŋ heleune melenai 4 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Tubune Bepaŋdi indiŋ yoguk, “Ime maaneŋ ime diniŋ kale mebimebi mintaaŋ imeŋgwaŋ tokiune waliwali wapum mintawek. Eŋ bagi heki adi hamap foloŋ wole yawaneeŋ.” Yobune mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bepaŋdi luhi kale kakahi gili eŋ nemek hatihati hinit mebimebi ime maaneŋ waliwali hinit hakiiŋ eŋ bagi papalihinit mebimebi, yehitubumintaaŋ yabuune utumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kaŋ Bepaŋdi indiŋ yoŋa yehikahaŋneguk, “Hidi youlinit tiŋa kisaŋ ulihakaaŋ imeŋgwaŋ wapum tokidapmaneeŋ eŋ bagi heki adi kwet foloŋ ulihakaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Unduŋ yolune kwet bufaaŋ heleune melenai 5 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dapmaune Bepaŋdi indiŋ yoguk, “Kwetdi nemek mebimebi namandap molomolom yehitubumintawek, kale mimihi, eŋ miŋgembet, kaleŋgiŋgiŋ eŋ kale moihi mebimebi.” Yobune undugoŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bepaŋ adi kale mimihi mebimebi eŋ kale moihi mebimebi tiŋa miŋgembet eŋ kaleŋgiŋgiŋ mebimebi unduŋku tubumintadapmaaŋ kaune utumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kaŋ Bepaŋ adi indiŋ yoguk, “Agaŋ! Indi meeniŋ indi inde indihigoŋ yehitubumintanim! Kaŋ adi luhi kale, hamap foloŋ bagi hatiiŋ eŋ kale mimihi eŋ kale moihi hogohogok tiŋa miŋgembet, kaleŋgiŋgiŋ heki kwet foloŋ kayohik kohohikdi yaliŋa uŋambuŋat tiiŋ wapum eŋ molom tiŋa yabudokoneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kaŋ biyagoŋ kuyoŋ, Bepaŋ adi meeniŋ ne undiniŋgoŋ tubumintaguk. Me eŋ tam yehitubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tiŋa yehikahaŋneeŋ indiŋ yeniŋguk, “Wapmihi hiyenit tiŋa ulihakaaŋ kwet tokiŋa kadokoneeŋ. Tiŋa luhi kale eŋ hamap foloŋ bagi hatiiŋ eŋ kwet foloŋ kale hatiiŋ eŋ kaleŋgiŋgiŋ heki hogohogok wapum eŋ molom tiyemiŋa yabudokoneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Bepaŋdi unduŋ yoŋa indiŋ yeniŋguk, “Nu hiditok nanaŋe iŋak hamulat: yuwoiyuwoi, bem gimiŋ, kahak heki eŋ nemenemek youlinit labiiŋ. ");
INSERT INTO nop_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Eŋ kale kwet foloŋ hatiiŋ eŋ hamap ginaŋ bagi hatiiŋ eŋ miŋgembet, tiŋa kaleŋgiŋgiŋ heki munabut hinit yehitubumintaŋit adi’walaŋ nanaŋe adi yupaaŋ, kilihikit heki kamelat.” Kaŋ undugoŋ hinek mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kaŋ Bepaŋ adi nemek tubumintaguk i yabune momooŋ hinek tuguk. Kaŋ kwet kotigoŋ bufaaŋ heleune melenai 6 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Unduŋ tiŋa yeguk e, kunum eŋ kwet yakaat adi bomboŋ mohok molomolom tuwolit tuwolit hinek tiulidokoyemdapmaaŋ yapmeguk. ");
INSERT INTO nop_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kaŋ melenai 7 uŋoŋ adi Bepaŋdi kwanaiŋiŋ tubudapmaaŋ kwanai hogohogok tuguk wondok nadiŋa hakweledok gulet ikuk. ");
INSERT INTO nop_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Unduŋ tiŋa Bepaŋ ne nemenemek hogohogok tubumintaaŋ melenai 7 uŋoŋ hakule tuguk doktiŋa nai u uŋgoniŋ yoŋa kahaŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yoŋ adi kunum kwet tuwolit tuwolit hinek tiulidokoyemdapmaaŋ yapmeguk wondininŋ mede kahat. Wapum Bepaŋ adi kunum eŋ kwet yehitubumintagukneŋ ");
INSERT INTO nop_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","uŋoŋ bem be kilihikit mebimebi kwet foloŋ mu kadoŋa labugiŋ. Woŋ adi Wapum Bepaŋdi yobune gwi nemu ukuk eŋ kwanai diniyeti titindok meeniŋ nemu yehitubumintaŋit doktiŋa unduŋ mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nai uŋaniŋ adi kwet maaneŋniŋ mundi wapum hinek labuŋa looŋ udaneeŋ fooŋ kwet tubukwelemaguk. ");
INSERT INTO nop_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kaŋ Wapum Bepaŋ adi kwet moŋgola kahigaliŋa me niŋ momooŋ hinek tutumbaaŋ timei ginaŋneŋ hatihati diniŋ munabut fedidahimimbune me u munabut tiŋa kaikaaŋ pilakuk. ");
INSERT INTO nop_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kaŋ Wapum Bepaŋ adi mele labulabuneŋkade Edeŋ kwetneŋ bem giminiŋ fiye niŋ yetiŋa me tubumintaguk u uŋgoŋ nagi wooŋ kameguk. ");
INSERT INTO nop_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tiŋa Wapum Bepaŋ adi kwet nindapmaune kwet foloŋ bem mebimebi momohi kadoŋa labugiŋ. Tiŋa bem gimiŋ momohi hinek yabuŋa nadigalika tiŋa moŋgola nanandok undihi mintagiŋ. Bem gimiŋ fiye lekiŋgoŋ hinek adi hatihati fafaŋeniŋ diniŋ bem eŋ kedem be kadakaniŋ tubutakale diniŋ bemdi kadoŋa labuŋa yakumuk. ");
INSERT INTO nop_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ime wapum niŋ adi Edeŋ bem gimiŋ fiye ginaŋ labuŋa bem gimiŋ fiye tubukwelematauyeeŋ fooŋ wooŋ daneeŋ taŋeniŋ 4 mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Taŋeniŋ niŋ diniŋ wou Pison. Wondi Hawila kwet kelemadidapmalak. Uŋoŋ gol muneeŋ hatak. ");
INSERT INTO nop_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Kwet uŋoŋ gol muneeŋ hatak adi tuwaaŋiŋ loloŋnit. Eŋ uŋgoŋ bem niŋ gumamuŋiŋ munduŋ momooŋ moŋgokiŋ eŋ kawade fafaŋeniŋ niŋ wou oniks hatak. ");
INSERT INTO nop_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ime taŋeniŋ niŋ wou Gihon adi Kus kwet kelemadilak. ");
INSERT INTO nop_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Eŋ taŋeniŋ niŋ adi wou Taigilis wondi Asilia kwet mele labulabuneŋkade fooŋ ulak. Eŋ taŋeniŋ niŋ adi Yufeletis. ");
INSERT INTO nop_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kaŋ Wapum Bepaŋ adi me nagila wooŋ Edeŋ bem gimiŋ fiye ginaŋ kwanai tiŋa kadokodok kameguk. ");
INSERT INTO nop_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kameŋ indiŋ yokwambundaaŋ niŋguk, “Bem gimiŋ fiye ginaŋ bem folooŋ hinit yaliwiiŋ adi’walaŋ folooŋ u kedem moŋgola naluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Iŋgoŋ oŋ, bem niŋ kedem be kadakaniŋ mebi tubutakale diniŋ mindipmuŋ uyadi mu nawaaŋ hinek. Fiit nawaaŋ adi nai uŋaniŋgoŋ hinek-ku kumumbaaŋ oŋ.” ");
INSERT INTO nop_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tiŋa Wapum Bepaŋ adi niŋ indiŋ yoguk, “Me adi nehogok hatibune tuwot mu tilak. Ale, nu adi undiningoŋ tubulodaŋiŋ niŋ tubumintawit.” ");
INSERT INTO nop_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wapum Bepaŋ adi unduŋ yoŋa kale mimihi eŋ kale moihi eŋ bagi hogohogok kwetdi tutumbaaŋ medi wouhik dediŋ yenimbek u kanadi tibene me’walaŋkade yanagila uguk. Kaŋ medi wouhiye yobihila yobek uŋakoŋ hakwambundadok yoguk. ");
INSERT INTO nop_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Unduŋ tubune me adi kale mimihi eŋ kale moihi eŋ bagi hogohogok adi wouhiye yededapmaguk. Iŋgoŋ ne undiniŋgoŋ tubulodaŋiŋ adi nemu tubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Unduŋ doktiŋa Wapum Bepaŋdi me tubugweheyeune domo kisaŋ dahakuk. Kaŋ gaga kitiliniŋ tamali kwelikoŋ foloŋ gomdi kameheguk. ");
INSERT INTO nop_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tiŋa Wapum Bepaŋ adi me diniŋ gaga tamakuk wondigoŋ tam niŋ tubumintaaŋ nagila me’walaŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nagila uune medi kaŋ yoguk, “Yoŋ adi biyagoŋ hinek kitiline eŋ gomne! Adi adi me’walaniŋ moŋgokuk doktiŋa wou ‘tam’ ninindok.” ");
INSERT INTO nop_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Unduŋ doktiŋa me adi miŋbeu biyabuŋa tamuŋiŋ’walaŋkade wooŋ kadiwaak. Unduŋ tiŋa adi sigihik be, bee welehik kiulune kubugoŋ tubune hatideemeek. ");
INSERT INTO nop_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Memalam adi wanakaŋ hambiyek hatigumuk iŋgoŋ meeka mu tugumuk. ");
INSERT INTO nop_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Wapum Bepaŋ adi nemek hatihatihinit behepneŋ hatidok yehitubumintaguk ala miŋgembet adi me yalamut molo doktiŋa noli’walaŋ nadinadi yalakapmeŋ lohinakaguk. Ala miŋgembet adi tam indiŋ yoŋa ninadiguk. “Bepaŋdi bem gimiŋ fiye ginaŋ bem heki yakiiŋ adi’walaŋ folooŋ mu nanandok be haniŋguk?” ");
INSERT INTO nop_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kaŋ tamdibo miŋgembet indiŋ niŋguk, “Indi yadi bem gimiŋ fiye ginaŋ bem hogohogok yaliwiiŋ adi’walaŋ mindipmuŋ kedem nanandok ninindapmaŋit, ");
INSERT INTO nop_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","eŋ bem gimiŋ fiye lekiŋgoŋ bem niŋ yatak wondiniŋ mindipmuŋ adi naaŋ be honeeŋ kumundeemitneŋ yoŋa Bepaŋdi kamehep tinimguk.” ");
INSERT INTO nop_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kaŋ miŋgembetdi tam indiŋ niŋguk, “Mooŋ ale! Hidi mu kumundemek. ");
INSERT INTO nop_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bepaŋ adi agaŋ nadilak, hidi bem gimiŋ u naaŋ dauhik tombune ne undiniŋ tiŋa kedem be kadakaniŋ diniŋ mebi nadidakaledemek.” ");
INSERT INTO nop_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Unduŋ yobune tam adi bem u kaŋ indiŋ nadisuguk, “bem gimiŋ u yadi momooŋ hinek nanandok tiŋa undigoŋ momooŋ hinek kalat, eŋ nadinadi tubumintadok tuwolit hinek” yoŋa nadiune utumbaguk. Unduŋ tige tige bem gimiŋ u tomŋa naguk. Naaŋele noli yohoidok mimbune adi maaŋ naguk. ");
INSERT INTO nop_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nalune dauhik tomguk. Tombune nehi hambiyek hatigumuk u kagumuk. Unduŋ tiŋa mooŋkaŋ bem hapmuŋ bateyehidi tebikufulaŋa hatigumuk. ");
INSERT INTO nop_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Agaŋ mele womaaŋ kwelemalune Wapum Bepaŋ adi bem gimiŋ fiye ginaŋ hati yaulune gigilitŋiŋ nadigumuk. Nadiŋa me eŋ tamuŋiŋ adi Wapum Bepaŋdok munta tiŋa bem gimiŋ fiye ginaŋ bem ginaŋ ginaŋ hebihakumuk. ");
INSERT INTO nop_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Unduŋ tulune Wapum Bepaŋdi me indiŋ kutniŋguk, “Du de?” ");
INSERT INTO nop_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kaŋ yoguk, “Du bem gimiŋ fiye ginaŋ yautobune nadiŋa hambiyek hatiŋat doktiŋa munta tiŋa hebihatat.” ");
INSERT INTO nop_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kaŋ adibo yoguk, “Hambiyek hatilaŋ u nediyeŋ ganiŋak? Du bem mindip mu nanandok ganiŋa yokwambudagut u nobu naweŋ?” ");
INSERT INTO nop_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kaŋ medi yoguk, “Tam nukut hatidok yoŋa namguŋ adi bem gimiŋ nambune naŋat.” ");
INSERT INTO nop_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kaŋ Wapum Bepaŋdi tam indiŋ niŋguk, “Du maŋgaŋde unduŋ tiŋaŋ?” Kaŋ tamdibo yoguk, “Miŋgembetdi nalamulune naŋat.” ");
INSERT INTO nop_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kaŋ Wapum Bepaŋdi miŋgembet indiŋ niŋguk, “Du unduŋ tiŋaŋ doktiŋa kale mimihi eŋ kale moihi adi’walaniŋ du kubugoŋ haaki tigamulat. Ale du kwet foloŋ hatibaaŋ tuwot kabakedi kwet umeumet tiŋa hatibaaŋ eŋ nanaŋege adi kwet kilabut naluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kaŋ du eŋ tam hidi’walaŋ lekiŋgoŋhik ginaŋ kwihita fafaŋeniŋ kamewit wondi miŋgembet du’walaŋ kobuligeye eŋ tam’walaŋ kobuliŋiye lekiŋgoŋhik ginaŋ hali lowaak. Ala hatigane tam’walaŋ kobulidi miŋgembet du’walaŋ mebige yalifilidawaak. Kaŋ dubo kayoŋ yehihiliŋiŋ sifilifiliyewaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tamdok adi indiŋ niŋguk, “Mihi welenit hatilune folofigita tomboyoula gambaat. Eŋ wapmihi yanagikiiŋ nai ginaŋ adi folofigita kisaŋ nadige nadige yeheŋeluwaaŋ. Iŋgoŋ oŋ, yohoge adi walagedi kahile hinek tuluwaaŋ, kaŋ adibo du gabudoko tuluwaak.” ");
INSERT INTO nop_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adamdok adi indiŋ niŋguk, “Du tamge’walaŋ mede tilooŋ yeŋaŋ e bem gimiŋ mu nanandok hinek yokwambundagamgut u naŋaŋ, ala du’walaŋ yom doktiŋa kwet i haaki timilat. Ale du helemahelemaŋ folofigita kwanai tiŋa nanaŋege tubumintaluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Dininoutge ginaŋ adi kilihikit moihi eŋ noli dendem hinitdi labaneeŋ. Kaŋ du yadi uŋaniŋ nanaŋege moŋgola hinaluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mimindi kisaŋ gomuŋa nanaŋege tubumintaaŋ nahatigane kwetdi gehitubumintaŋit ale kotigoŋ udaneeŋ kwet foloŋ fowaaŋ! Kwetdi gehitubumintagut doktiŋa kotigoŋ udaneŋ kwet yagilaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kaŋ me adi tamuŋiŋ wou Ewa youkuk. Adigoŋ tububihila kwet foloŋ meeniŋ mintayam hogohogok indi’walaŋ meekinik tuguk. ");
INSERT INTO nop_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kaŋ Wapum Bepaŋ adi kale gitnemdi dahidahi tibineeŋ memalam tinahukuyembune hatigumuk. ");
INSERT INTO nop_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Wapum Bepaŋ adi unduŋ tiŋa indiŋ yoguk. “Hidige! Me adi agaŋ inde indihigoŋ tiŋa kedem eŋ kadakaniŋ diniŋ mebi nadilak. Ale, tiyaugene kohoŋ kihiwale hatihati fafaŋeniŋ diniŋ bem gimiŋ tomuŋa naaŋ kwet foloŋ yagigi hatibaaneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Wapum Bepaŋ adi unduŋ yoŋa me niŋkulune Edeŋ bem gimiŋ fiye bikabuŋa fooŋ uguk. Kwetdi tubumintaŋit adi ne dininout tibene fooŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Wapum Bepaŋdi memalam unduŋku tiŋa yehikeleune fougumuk. Kaŋ Edeŋ bem gimiŋ fiye diniŋ mele labulabuneŋkade Kelobim niŋ kambiyakuk, eŋ mik noŋ kudup mabemnit kameune wondi uŋat buŋat tiŋa hatihati fafaŋeniŋ bem diniŋ talik tehep tuguk. ");
INSERT INTO nop_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam adi tamŋiŋ Ewa dut hatibune mihiwele tiŋa Kain nagikuk. Nagila indiŋ yoguk, “Bepaŋdi nehitubulodaune mihi niŋ mintanamulak.” ");
INSERT INTO nop_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kaŋ mindaŋkade kwayaŋ Abe nagikuk. Kaŋ Abe adi bedinaditomŋa meme eŋ dompa yabudokoguk. Kain adi me dininout kwanai tiŋa hatiluguk. ");
INSERT INTO nop_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Unduŋ tiŋa hatigane Kain adi fiye ginaŋniŋ nanaŋe heki moŋgola bopneeŋ Bepaŋ muni hemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kaŋ Abe adi maaŋ dompa taamuhi kobuhidi mihiniŋ biyegiŋ uŋaniŋ niŋ ula dobuŋa galiki moŋgola Bepaŋdok muni heguk. Kaŋ Wapumdi Abe ne be, bee muniŋiŋdok nadiune utumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Eŋ Kaindok adi ne be, bee muni hegukdok nadihaŋinda tuguk. Unduŋ tubune Kain adi kisaŋ kwihitaune namanda kadakaniŋgoŋ hinek diweguk. ");
INSERT INTO nop_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Unduŋ tuguk kaŋ Wapumdi Kain indiŋ niŋguk, “Maŋgoŋde kwihitaaŋ namandake kadakaniŋgoŋ diwelaŋ? ");
INSERT INTO nop_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Du kedem hatibune nadigambene utumbawaak. Kedem mu hatibaaŋ adi kadakaniŋdi talik fofoŋ ginaŋ hebiyale dutok-ku womgambaak. Kadakaniŋdi gabudokodok hinek-ku nadilak oŋ. Ale, du yadi kadakaniŋdok kamehep timimbaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hatigane Kaindi kwayaŋ Abe indiŋ niŋguk, “Buune kade ude.” Yobune ugumuk wooŋ kade ginaŋ hatigumuk, hatigane Kaindi tububihila pilali kwayaŋ Abe ula ulukumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kaŋ Wapumdi Kain indiŋ ninadiguk, “Kwayage Abe daŋgoŋ hatilak?” Adibo yoguk, “Nu mu nadilat. Kwayane nube kadokolat ale?” ");
INSERT INTO nop_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Unduŋ yobune Wapumdi yoguk, “Du maŋgoŋ tiŋaŋ? Kwayage buune naŋgatŋiŋ kwet foloŋ kwatneŋak wendi kobulabulaye tinambune nadilat. ");
INSERT INTO nop_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Unduŋ doktiŋa haaki du foloŋ kamelat. Kwetdi kotigoŋ du mu gehitubulodaluwaak. ");
INSERT INTO nop_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Diniyeti kwanai tibaaŋ iŋgoŋ kwetdi duhuduhuŋiŋ diniŋ galiki kahile tibaak. Unduŋ tubune du momoŋ tiŋa kwet uŋaŋbo hatiŋ uŋaŋbo hatiŋ tiluwaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Unduŋ nimbune Kaindibo Wapum indiŋ niŋguk, “Kibikooŋ namulaŋ u nadiwene mulabumuŋ hinek tilak. ");
INSERT INTO nop_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Du kamiŋ dininout kwet kameheŋa nehikelekutaŋ doktiŋa nu du bikabuŋa momooŋ wooŋ uŋaŋbo uŋaŋbo hebihatiluwaat. Kaŋ meeniŋ niŋdi nehitubumintaaŋ nulukumuneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kaŋ Wapumdibo yoguk, “Unduŋ adi mooŋ, nediyeŋdi Kain ulukumumbaak adi’walaŋ kibikoŋ adi kunakunat 7 wondok tuwolit kalakapmeeŋ wapumgoŋ mimindok.” Unduŋ yoŋa Kain sigiŋ foloŋ fek niŋ timiŋguk, nebek niŋdi kaŋ mu utneeŋ yoŋa unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaŋ Kain adi Wapum hebeŋ foloŋ hatigukdi wabiŋa wooŋ kwet niŋ wou Nod u Edeŋ kwet mele labulabuneŋkade uŋaŋ hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaŋ Kain adi taamuŋiŋ dut hatibune mihiwele tiŋa Enoko nagikuk. Ala Kain adi yokwet wapumniŋ yobune mintaguk kaŋ yokwet wondiniŋ wou mihiŋiŋ diniŋ wou Enoko youkuk. ");
INSERT INTO nop_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoko’walaŋ mihi niŋ mintaguk wou Ilad. Kaŋ Ilad’walaŋ mihi niŋ mintaguk wou Mehuyael. Kaŋ Mehuyael diniŋ mihi niŋ mintaguk wou Metusael. Kaŋ Metusael diniŋ mihi niŋ mintaguk wou Lamek. ");
INSERT INTO nop_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek adi tam lufom yanagikuk, tam niŋ diniŋ wou Ada, eŋ niŋ diniŋ wou Sila. ");
INSERT INTO nop_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada adi mihiwele tiŋa Yabali nagikuk. Yabali adi kale gitnemdi yot mamaŋ eŋ kale makau yabudoko kwanai wondiniŋ mebi tububihikuk. ");
INSERT INTO nop_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabali kwayaŋ wou adi Yubali. Adi adi bai fedifedit, eŋ manaŋ kumbet fedifedit eŋ gita uut tububihikuk. ");
INSERT INTO nop_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Kaŋ Siladibo mihiwele tiŋa mihi niŋ nagikuk wou Tubali-Kein adi kwanai bomboŋ bolons eŋ ain hekidi tutumbaguk, unduŋ doktiŋa Tubali-Keindi bolons eŋ ain hekidi nemenemek tutumbadok mebi tububihikuk. Tubal-Kein wiwi diniŋ wouye Nama. ");
INSERT INTO nop_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Hatigane nai niŋde Lamek adi tamuŋiyat yeniyehihamaneeŋ indiŋ yeniŋguk, “Ada eŋ Sila, hidi magihik kameeŋ medene nadideemek! Tamuneyat, nu’walaŋ kap walem nadidahi tidemek. “Biyagoŋ hinek, meeniŋdi nutubukadakaune ukut. “Eŋ mekuyadi nulune ulukumuŋgut.” ");
INSERT INTO nop_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","“Kain ulaak adi kibikoŋ kunakunat 7 moŋgolaak eŋ Lamek nu nulaak adi kibikoŋ kunakunat 77, wapumgoŋ hinek moŋgolaak.” ");
INSERT INTO nop_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam adi kotigoŋ tamuŋiŋgut hatibune mihiwele tiŋa mihi niŋ nagikuk. Kaŋ indiŋ nadiŋa wou Set youkuk. “Kaindi Abe ukuk doktiŋa aditok kayoŋkoŋ Bepaŋ’walaniŋ youli niŋ busuwanamulak.” ");
INSERT INTO nop_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kaŋ Set adi maaŋ undugoŋ mihi niŋ mintamimbune wou Enosi youkuk. Nai uŋaniŋgoŋ hinek metamdi tububihila Wapum gikiŋgoŋ timiŋa wou nintilooŋ niutumbagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yoŋ adi Adam diniŋ yalakiŋiye ulihaka-talabugiŋ diniŋ youkudip. Bepaŋdi Adam tubumintaguk nai uŋaniŋ ne undiniŋgoŋ hinek tubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Adi adi maaniŋ eŋ taamuniŋ yehitubumintaaŋ meeniŋ yeniŋa kahaŋ tiyemguk. ");
INSERT INTO nop_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kaŋ Adam adi hatitalabulune guletŋiŋ 130 tulune mihiŋiŋ niŋ ne’walaŋ namandap agaŋ ne undiniŋgoŋ hinek mintaguk. Kaŋ wou Set youkuk. ");
INSERT INTO nop_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam adi Set mintaguk uŋaniŋ tomboyoula gulet 800 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam adi unduŋ tiŋa hatitalogane guletŋiŋ 930 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set adi guletŋiŋ 105 tulune adi’walaŋ mihiŋiŋ Enos mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set adi Enos mintaguk uŋaniŋ tomboyoula gulet 807 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set adi unduŋ tiŋa hatitalogane guletŋiŋ 912 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos adi guletŋiŋ 90 tulune adi’walaŋ mihiŋiŋ Kenan mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos adi Kenan mintaguk uŋaniŋ tomboyoula gulet 815 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos adi unduŋ tiŋa hatitalogane guletŋiŋ 905 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan adi guletŋiŋ 70 tulune adi’walaŋ mihiŋiŋ Mahalale mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan adi Mahalale mintaguk uŋaniŋ tomboyoula gulet 840 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan adi unduŋ tiŋa hatitalogane guletŋiŋ 910 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalale adi guletŋiŋ 65 tulune adi’walaŋ mihiŋiŋ Yalet mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalale adi Yalet mintaguk uŋaniŋ tomboyoula gulet 830 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalale adi unduŋ tiŋa hatigane guletŋiŋ 895 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yalet adi guletŋiŋ 162 tulune adi’walaŋ mihiŋiŋ Inok mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yalet adi Inok mintaguk uŋaniŋ tomboyoula gulet 800 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yalet adi unduŋ tiŋa hatigane guletŋiŋ 962 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inok adi guletŋiŋ 65 tulune adi’walaniŋ mihiŋiŋ Metusela mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Inok adi Bepaŋdut kifolok hinek tiŋa hatigumuk. Inok adi Metusela mintaguk uŋaniŋ tomboyoula gulet 300 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Inok adi unduŋ tiŋa hatilune guletŋiŋ 365 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Adi Bepaŋdut kifolok hinek tiŋa hatigane liwe tuguk. Biyagoŋ kuyoŋ, adi Bepaŋ negoŋ nagikuk. ");
INSERT INTO nop_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela adi guletŋiŋ 187 tulune adi’walaniŋ mihiŋiŋ Lamek mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusela adi Lamek mintaguk uŋaniŋ tomboyoula guletŋiŋ 782 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela adi unduŋ tiŋa hati ulune gulet 969 tubune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek adi guletŋiŋ 182 tulune adi’walaniŋ mihiŋiŋ niŋ mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mintaune indiŋ yoŋa wou Noa youkuk, “Bepaŋ adi kwet haaki timiŋguk kaŋ folofigita kwanai tihatiyane mihi yendi nihitubukwelemawaak!” ");
INSERT INTO nop_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek adi Noa mintaguk uŋaniŋ tomboyoula gulet 595 hatilune wabiŋiŋ eŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek adi unduŋ tiŋa hatigane guletŋiŋ 777 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa adi gulet 500 hatilune adi’walaŋ mihiŋiye 3 mintamiŋgiŋ, wouhiye Sem, Ham eŋ Yafet. ");
INSERT INTO nop_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Meeniŋdi kwet foloŋ kisaŋ ulihakalune wabihiye maaŋ fe mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Nai uŋaniŋ Bepaŋ’walaŋ mihiŋiyedi meeniŋ’walaŋ wabihiye folonamandaphik momohi yabunadigalika tigiŋ. Unduŋ tiŋa yegiŋ e yabusilodagiŋ indigoŋ tuwot taamuhiye yehiŋegiŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kaŋ Wapumdi indiŋ yoguk, “Nu’walaŋ munabutdi meeniŋ foloŋ yagigi mu halaak. Meeniŋ adi kwetdi tutumbagut, adi folooŋ gitnemnit doktiŋa kwet foloŋ hatihatiŋiŋdi kotigoŋ gulet 120 mu kalakapmewaak.” ");
INSERT INTO nop_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Nai uŋaniŋ adi Bepaŋ’walaŋ mihiŋiye adi kwet foloŋ tamdut kiula hatibune meeniŋ kakahi gili hinek mintaaŋ wouhiye gigit loloŋnit hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kaŋ nai uŋaniŋ Bepaŋdi kwet foloŋ diweeŋ metam hogohogok tififile mebimebi kisaŋ tigiŋ yabuguk. Tiŋa welehik ginaŋ nemek hogoli titindok hogok nadisuyagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Unduŋ tubune Wapum adi kwet foloŋ meeniŋ maŋgoŋde yehitubumintagut yoŋa nadimulahuda tuguk. ");
INSERT INTO nop_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Unduŋ doktiŋa Wapumdi indiŋ yoguk, “Meeniŋ yehitubumintagut hogohoghok yehitubuliwe tibene liwedapmaŋ tineeŋ. Kwet foloŋ kotigoŋ mu hatineeŋ. Kale eŋ kaleŋgiŋgiŋ eŋ bagi eŋ nemenemek wanakaŋ hogohogk liwedapmaneeŋ.” Kaŋ Wapum ne adi maŋgoŋde yehitubumintagut yoŋa welemulap wapum nadiguk. ");
INSERT INTO nop_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noa kubugoŋ adi Bepaŋdi kaune utumba hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Yoŋ adi Noa’walaŋ mede kahat. Adi kubugoŋdi meeniŋ lekiŋgoŋhik ginaŋ hatiŋale titiŋ didimeniŋ tuluguk, unduŋ tiŋa Bepaŋdut kifolok hinek tugumuk. ");
INSERT INTO nop_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Kaŋ adi’walaŋ mihiŋiye 3 wohiye Sem, Ham eŋ Yafet. ");
INSERT INTO nop_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Eŋ meeniŋ noli kwet foloŋ hatigiŋ adi adi Bepaŋ namanda foloŋ kadakaniŋ kaka tubune kadakaniŋdi kwet tokidapmaŋ tiŋa hakuk. ");
INSERT INTO nop_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Unduŋ tubune Bepaŋdi kwet kaune kadaka hinaka tuguk. Tiŋa kwet foloŋ me diniŋ hatihati eŋ titiŋhik kaune fifile eŋ giyoŋgiyoŋeeŋ tubudapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Unduŋ doktiŋa Bepaŋdi Noa indiŋ niŋguk, “Nu yadi kwet foloŋ metam’walaŋ nai dapmandok nadikwambundalat. Adi adi kadakaniŋ tubune fifile eŋ gioŋgioŋe tubune kwet agaŋ kadaka hinek tilak doktiŋa nu tubuliwe tibit. ");
INSERT INTO nop_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Unduŋ doktiŋa du bem miminiŋ fofooŋ fiŋa wondi muwage wapum tutumbawaaŋ. Tiŋa yewaaŋ e muwage wapum tutumbaaŋ dobu dobu titaune yotmaaŋ fee mintaneeŋ. Kaŋ maaneŋkade be sigineŋkade nipmekdi gali hafiyeune tehewaak. ");
INSERT INTO nop_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Muwage tuwolitŋiŋ adi indiniŋ tibaaŋ. Kweheyeniŋ e 450 fit, eŋ batei e 75 fit eŋ koloŋ e 45 fit, undiniŋ tutumbawaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Eŋ kii namokopŋiŋ e, 18 insis wendok tuwolit tubudapmawaaŋ. Talik fofoŋŋiŋ adi muwage gagayeŋ kamewaaŋ. Falikŋiŋ e, lufomkulitniŋ kiwahiŋ tutumbawaaŋ. Kainiŋ hinek e niŋ, lekiŋgoŋ niŋ agaŋ wohiŋ bokineŋ hinek niŋ unduŋ tutumbawaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kaŋ nu yobene ime gabuŋ wapum bediŋa buŋa kwet foloŋ nemek hatihati hinit kunum falipmeŋ halaak hogohogok yehitubukadaka-dapmawaak. Nemenemek hatihati diniŋ munabutnit hatiiŋ hogohogok kadakadapmawaak. ");
INSERT INTO nop_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Dukut adi folokfolok folooŋ hinek tilat. Du yadi muwage foloŋ looŋ hatibaaŋ. Du da eŋ tamge eŋ mihige nabugeye adi wanaŋ dukut muwage foloŋ looŋ hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Eŋ nemenemek hatihatinit kwet foloŋ hatiiŋ liwedapmaneneŋ doktiŋa lufom lufom maaniŋ taamuniŋ yeheŋeune muwage foloŋ wanaŋ loneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bagi mebimebi eŋ kale mebimebi, miŋgembet be kaleŋgiŋgiŋ mebimebi adi’walaniŋ lufom lufom buŋa dukut wanakaŋ muwage ginaŋ looŋ youlidok hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tiŋa nanaŋe nanandok u be u hatak tuwolit ugamali bopneeŋ muwage maaneŋ boiwaaŋ. Kaŋ wondi da be, bee kale bagi heki hide’walaŋ hatihati ulihiwaak.” ");
INSERT INTO nop_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kaŋ Noa adi Bepaŋdi yoguk wondok tuwot maŋiŋ tubulodaaŋ undugoŋ hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kaŋ Wapumdi Noa indiŋ yoŋa niŋguk. “Da eŋ wapmihigetam wanakaŋ hogohogok muwage foloŋ lodapmaneŋ. Meeniŋ hogohogok hatiiŋ adi’walaŋ lekiŋgoŋhik ginaŋ du kubugoŋ me didimeniŋ hatilaŋ doktiŋa gabene utumbalak. ");
INSERT INTO nop_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Ale kwet foloŋ hatihati hinit diniŋ youli dapmawaakneŋ doktiŋa du kale walahi adi’walaniŋ maanihi eŋ taamuhi 7, 7, tuwolit tuwolit eŋ kale geŋgeŋnit adi lufom, lufom, unduŋ yanagila bagi heki maaŋ undugoŋ mebimebi 7, 7, maaniŋ eŋ taamuniŋ yanagilune dukut muwage gineŋ loneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kaŋ nu melenai 7 dapmaune yobene kwet foloŋ gwi sifo wapum ula yalune hadapmo 40 eŋ timiŋ 40 tibaak. Uŋoŋ kwet foloŋ nu nemenemek hatihati hinit yapmegut hogohogok yehitubuliwedapmawaat.” ");
INSERT INTO nop_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kaŋ Noa adi Wapum’walaŋ maŋiŋ mede tagimneeŋ undugoŋ tubudapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa adi guletŋiŋ 600 hatilune wahiŋkade kwet foloŋ ime gabuŋ wapum buguk. ");
INSERT INTO nop_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ime gabuŋ wapum agaŋ beene tulune Noa nenee eŋ tamuŋiŋ eŋ mihiŋiŋnabu adi wanakaŋ muwage foloŋ lodapmagiŋ. Ime gabuŋ wapumdi mu nihiŋewek yoŋa unduŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Unduŋ tulune kale walahi eŋ geŋgeŋhinit eŋ bagi eŋ miŋgembet, kaleŋgiŋgiŋ, maaniŋ taamuniŋ, ");
INSERT INTO nop_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","lufom, lufom, kwet foloŋ itowiiŋ hogohogok buŋa Noadut muwage foloŋ logiŋ. Bepaŋdi Noa nindidimeguk wondok tuwot hinek logiŋ. ");
INSERT INTO nop_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Agaŋ melenai 7 hinek-ku dapmalune ime gabuŋ wapum kwet foloŋ busuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa’walaŋ gulet nai 600 wondiniŋ muyakipŋiŋ 2 wondiniŋ melenai 17 nai uŋaniŋ ime eŋ luhi dombuŋaleeŋ komaŋ duŋaniŋ bediŋa labulune wahiŋniŋ ime diniŋ talik taŋakiyeune ");
INSERT INTO nop_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","gwi sifo miiŋ hinek ula halune hadapmo 40 eŋ timiŋ 40 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kaŋ nai uŋaniŋgoŋ hinek Noa malam eŋ mihiŋiye Sem, Ham tiŋa Yafet eŋ tamuhiye adi wanakaŋ hogohogok muwage ginaŋ lodapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tiŋa kale mimihi eŋ moihi mebimebi tuwolit tuwolit, miŋgembet be kaleŋgiŋgiŋ, mebimebi kwet ginaŋ itouwiiŋ, eŋ bagi mebimebi papali hinit ");
INSERT INTO nop_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","lufom, lufom, hogohogok maaniŋ taamuniŋ tuwolit tuwolit adi hogohogok Noadut lodapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nemek hatihatinit nemu bikabuŋit. Bepaŋdi Noa nindakaleguk wondok tuwolit lodapmagiŋ. Lodapmalune Wapumdi talik teheŋa talik fofoŋ fakaŋkade youkilitiguk. ");
INSERT INTO nop_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Unduŋ tulune ime gabuŋ kakaŋ hinek busuwaune melenai 40 wondok tuwot ime heki adi bediŋa loge loge muwage kwehene tiŋa loune kwet bikabuŋa ime foloŋ folooniŋ loguk. ");
INSERT INTO nop_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kaŋ ime wapuhi kisaŋ bediŋa bateyeŋ kwetkwet kufuladapmaune muwage adi ime foloŋ folooniŋgoŋ uŋat buŋat tihatiguk. ");
INSERT INTO nop_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tiŋa ime heki adi dombuŋaleeŋ loge loge kwebobe kweheyehi yaliwiiŋ wanaŋ yehikufuladapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Imedi kweboboe boki 20 fit wondok tuwot kalakapmeeŋ loguk. ");
INSERT INTO nop_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Unduŋ tubune kwet foloŋ nemek hatihati hinit liwedapmaguk, bagi, kale mimihi, kale moihi, kaleŋgiŋgiŋ, miŋgembet heki kwet foloŋ itowagiŋ hogohogok, eŋ meeniŋ wanaŋ kumuŋdapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","23","Kwet foloŋ nemek hatihati hinit hogohogok meeniŋ be kale heki be, kaleŋgiŋgiŋ be, bagi heki yehitubuliwedapmaguk. Noa eŋ adut muwage maaneŋ hatigiŋ adi hogok biyabuguk. ");
INSERT INTO nop_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kaŋ ime wapuhi adi kwet foloŋ dombuŋale looŋ hatune melenai 150 dapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nai uŋaniŋ Bepaŋ adi Noadok nadisuŋale kale heki adut muwage foloŋ hatigiŋ aditok maaŋ nadisuguk. Unduŋ tiŋa yobune sububa wapum fedilune ime wapum adi ulapmaaŋ foguk. ");
INSERT INTO nop_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kaŋ koom ime heki imembuhum ginaŋniŋ tawahila labugiŋ eŋ kunum ime dobuhep dilitombune foguk u maaŋ Bepaŋdi kamehep tiyembune naŋgale silida tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Unduŋ tubune kwet foloŋ ime heki adi hahathik ginaŋ kotigoŋ ulapmaaŋ fooŋ hali uune imeŋgwaŋ wapum ulapmaaŋ foguk. Melenai 150 hinek-ku dapmaune ulapmaaŋ foguk. ");
INSERT INTO nop_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ulapmaaŋ folu folu muwagedi muyakip 7 wondiniŋ melenai 17, nai uŋoŋ Alalat kweboboe niŋ foloŋ loŋ ulodiŋa ikuk. ");
INSERT INTO nop_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Hatigane ime ulapmaaŋ fofoyeune muyakip 10 wondiniŋ melenai kubugoŋ nai uŋaniŋ kweboboe boki tububihila mintataugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Unduŋ tubune melenai 40 dapmaguk kaŋ Noadi yot diwetom diniŋ yeme dilitomuŋa ");
INSERT INTO nop_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","bagi kalaŋkatak kameune fouguk. Fooŋ wooŋ folooniŋgoŋ woleeŋ uŋambuŋat tiŋa hatilune kwetfoloŋ ime silidaguk. ");
INSERT INTO nop_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kaŋ hatitauyeŋ Noadi butigili niŋ kameune uguk, kwet foloŋ ime agaŋ be silidahinekalak be dediŋ wondiniŋ mebi nadiwene unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Imedi kougoŋ toki tiŋa hakuk doktiŋa butigilidi woleeŋ uŋat buŋat tige tige ikwele titindok kwet mooŋ lohikaaŋ kotigoŋ udaneŋ Noa’walaŋ buguk. Kaŋ Noadi kohoŋ kihiwali butigili nagila muwage maaneŋ dahiguk. ");
INSERT INTO nop_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Kaŋ kotigoŋ melenai 7 woom hatihatiyeeŋ butigili woŋ negoŋ kameune uguk. ");
INSERT INTO nop_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Nai uŋaniŋ tebele hinek bitigili adi kotigoŋ udaneŋ bene bem oliwa hapmuŋ goŋgoŋ niŋ sikwali tiŋa busuwaguk! Unduŋ tubune Noadi indiŋ nadiguk. Ime agaŋ naŋgadapmaaŋ foune kwet silidalak. ");
INSERT INTO nop_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Kaŋ kotigoŋ melenai 7 woom hatihatiyeeŋ butigili niŋbo kameune uguk. Adi adi wooŋ kotigoŋ mu udaneeŋ busuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa’walaŋ gulet nai 601 wondiniŋ muyakip kubugoŋ diniŋ melenai kubugoŋ tulune ime wapum kwet foloŋ hakuk u silidadapmaguk. Kaŋ Noadi muwage diniŋ namakop widikula kaguk. Agaŋ biyagoŋ hinek kwet foloŋ ime agaŋ silidadapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kaŋ muyakip 2 wondiniŋ melenai 27 uŋoŋ adi kwet agaŋ siliŋ hakuk. ");
INSERT INTO nop_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kaŋ Bepaŋdi Noa indiŋ yoŋa niŋguk, ");
INSERT INTO nop_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Da eŋ tamge eŋ mihinabugeye hidi muwage maaneŋ bikabuŋa fakaŋ foneŋ. ");
INSERT INTO nop_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tiŋa undugoŋ kale be bagi be miŋgembet eŋ kaleŋgiŋgiŋ heki dukut wanaŋ muwage ginaŋ hatiiŋ yeniŋkulune fakaŋ fodapmaneŋ. Tiŋa minta ulihakaaŋ kwet tokidapmaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Unduŋ yobune Noa eŋ taamuŋiŋ eŋ mihiŋiŋ nabuŋiye, ");
INSERT INTO nop_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","tiŋa kale hogohogok eŋ bagi eŋ miŋgembet, kaleŋgiŋgiŋ hogohogok folonamandaphik tuwolit tuwolit muwage maaneŋ bikabuŋa fakaŋ fogiŋ. ");
INSERT INTO nop_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Fakaŋ fodapmaune Noadi Wapumdok kawade moŋgo bopneeŋ alata tutumbaaŋ kale mimihi eŋ bagi mebimebi yehidaneeŋ bopneeŋale Bepaŋdok muni hemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kaŋ Wapum adi munduŋ momooŋ nadiŋa weleŋ ginaŋ indiŋ nadiguk, “Nu kwet foloŋ nemek hatihati hinit u meeniŋ doktiŋa kotigoŋ mu yehitubuliwewaat. Meeniŋ adi wapmihi hatiŋale welehikdi nadisu kwanai hogoli tomboyoutnit tihatiiŋ. Unduŋ doktiŋa nu yadi meeniŋ doktiŋa nemek hatihati hinit kotigoŋ mu yehitubuliwewaat.” ");
INSERT INTO nop_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tiŋa indiŋ tomboyoula yoguk, “Kwet diniŋ nai hali lowaak tuwot diniyeti eŋ fiyegilaka, sububa eŋ kudut, mele nai eŋ gwi mulum, hele eŋ bufa, unduŋ be unduŋ tomboyoutnit hali wooŋ halaak.” ");
INSERT INTO nop_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kaŋ Bepaŋdi Noa eŋ mihiŋiye indiŋ yoŋa kahaŋ tiyemiŋguk, “Hidi minta-ulihaka tiŋa kwet tokidapmaŋ tineeŋ. ");
INSERT INTO nop_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Eŋ kale bagi heki adi adi hiditok munta tiŋa momoyau taneeŋ. Kale hogohogok eŋ bagi heki eŋ kaleŋgiŋgiŋ kwet umeumet tihatiiŋ eŋ luhi kale adi wanakaŋ hidi kohohik foloŋ boidapmalat. ");
INSERT INTO nop_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tiŋa kudiyuwoi koom nanaŋehik hamgut undugoŋ kobuk kale heki hatihatihiŋit maaŋ nanaŋehik hamulat. ");
INSERT INTO nop_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Iŋgoŋ oŋ, nemek kubugoŋ, kale naŋgatnit adi mu nayaneeŋ! Tiŋa indiŋ nadineŋ. ");
INSERT INTO nop_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Hide’walaŋ naŋgathik diniŋ kibikoŋ adi nagoŋ hinek tibidapmaluwaat. Meeniŋ hatihatihik diniŋ kibikoŋ kale heki foloŋ, be meeniŋ foloŋ, be naŋgat dikihiye foloŋ, u yadi nagoŋ hinek tibidapmaluwaat. ");
INSERT INTO nop_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Meeniŋ adi nebek niŋ’walaŋ folonamandap mooŋ, Bepaŋ na indiniŋgoŋ tubumintaŋit doktiŋa meeniŋ nediyeŋ meeniŋ naŋgat kwatnewaak adi’walaŋ naŋgat adi kibimaaŋ meeniŋdigoŋ kwatnedok. ");
INSERT INTO nop_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Hidi yadi youlinit tiŋa ulihaka tineeŋ. Tiŋa hidi’walaŋ yalakihiye fe hinek mintaaŋ kwet ikilitineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bepaŋdi unduŋ yoŋa Noa eŋ mihiŋiye indiŋ yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nu kamiŋ hide be, bee yalakihiye hidut mede yofolok fafaŋeniŋ tilat. ");
INSERT INTO nop_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Tiŋa undugoŋ nemek hatihati hinit hogohogok hidigut muwage ginaŋ bikabuŋa fakaŋ fogiŋ adi maaŋ, bagi eŋ kale moihi eŋ kale mimihi hogohogok ");
INSERT INTO nop_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","hiditok wanaŋ yofolok fafaŋeniŋ tilat, doktiŋa ime gabuŋ wapumdi kotigoŋ busuwaaŋ kwet foloŋ nemek hatihati hinit eŋ kwet nenee fana kotigoŋ mu tibaak!” ");
INSERT INTO nop_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Tiŋa Bepaŋ adi tomboyoula yoguk, “Nu adi kamiŋ hidi eŋ nemek hatihati hinit hogohogok hiditok yofolok fafaŋeniŋ tilat. Wondiniŋ fekne kwembeke kudi hamap foloŋ i kamelat. Wondi yofolokne diniŋ fek tiliwaak. ");
INSERT INTO nop_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Nu’walaŋ mane mede tagimneeŋ gwi mulukwaŋ bopneeŋ tiulidokolune nu’walaŋ fek u mulukwaŋ ginaŋ mintaune ");
INSERT INTO nop_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nu yofolok fafaŋeniŋ tilat wondok nadisuluwaat. Kaŋ ime gabuŋ wapumdi kwet diniŋ nemek hatihati hinit fana kotigoŋ mu tibaak. ");
INSERT INTO nop_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tiŋa nu kwembeke kudi uku mulukwaŋ ginaŋ mintaaŋ yalaak tuwot kakiyondaaŋ kwet diniŋ nemek hatihati hinit hiditok yofolok fafaŋeniŋ tugut u nadisuluwaat.” ");
INSERT INTO nop_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Bepaŋdi unduŋ yoŋa tomboyoula Noa indiŋ niŋguk, “Kwet foloŋ me hidigut yofolok fafaŋeniŋ tugut wondiniŋ fek e kwembeke kudi kamelat uŋakoŋ hinek.” ");
INSERT INTO nop_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Yoŋ adi Noa’walaŋ mihiŋiye muwage maaneŋ bikabuŋa fakaŋ fogiŋ adi’walaŋ wouhiye Sem, Ham eŋ Yafet. Ham adi adi Kanaaŋ diniŋ beu. ");
INSERT INTO nop_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ala me heki lufomkulitniŋ yuku yendi Noa’walaŋ mihiŋiye hinek. Adi’walaŋ yalakidi ulihakaaŋ mowoŋa kwetkwet tuwot udapmaaŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa adi dininout molo doktiŋa wain hewe tibibihikuk. ");
INSERT INTO nop_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ala hatigane wain ime tutumbaaŋ naguk. Nage nage nadinadiŋiŋ filune tinahukut fiyakula hogok dahakuk. ");
INSERT INTO nop_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kaŋ Ham Kanaaŋ diniŋ beudi beu Noa’walaŋ mebi kanadi tiŋa fooŋ wooŋ daliyat mede kahat tiyemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kaŋ Sem eŋ Yafet adi u nadiŋa yegumuk e haule niŋ tiŋa nili fukufukuŋ yaliŋa haule tiŋa looŋ kaluaŋhik foloŋ mulaŋa sigisigi behik’walaŋ yot ginaŋ fooŋ behik hambiyek dahakuk u mu kaŋ kufulamiŋgumuk. ");
INSERT INTO nop_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ala kougoŋ Noa adi wain imedi ulune damo kauleeŋ dahakukdi sukuleeŋ pilali mihidi kudi mu titiŋ timiŋguk wondiniŋ mede kahat nadiŋa indiŋ yoguk, ");
INSERT INTO nop_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“Haakidi Kanaaŋ adi foloŋ lowaak. Kaŋ adi fofoŋnit hatiŋa daliyat’walaŋ tipilapilaye kwanai tuluwaak.” ");
INSERT INTO nop_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Unduŋ yoŋa indiŋ tomboyoula yoguk, “Wapum Bepaŋnedi Sem kahaŋ timimbaak, tubune Kanaaŋ adi, adi’walaŋ tipilapilaye mihi hatibaak!” ");
INSERT INTO nop_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Unduŋ yoŋa tomboyoula indiŋ yoguk, “Bepaŋnedi Yafet tibilodaune ulihaka tibaak. Unduŋ tiŋa Sem’walaŋ yalakiŋiye dut hatiyaneeŋ, eŋ Kanaaŋ adi adi tipilapilaye tiyemiluwaak.” ");
INSERT INTO nop_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ime gabuŋ wapum dapmaune Noa adi tomboyoula gulet 350 hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa adi unduŋ tiŋa hatige hatige guletŋiŋ 950 dapmaune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Yoŋ adi Noa mihiŋiye Sem, Ham eŋ Yafet adi’walaŋ mede kahat. Ime gabuŋ wapum dapmaune mindaŋkade Noa mihiŋiye’walaŋ mihiwoi mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet adi’walaŋ mihiŋiye diniŋ wouhiye habet indiŋ: Gome, Magok, Madai, Yawan, Tubali, Mesek eŋ Tilas. ");
INSERT INTO nop_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Agaŋ Gome’walaŋ mihiŋiye diniŋ wouhiye youhabet indiŋ Askenasi, Lifat eŋ Togama. ");
INSERT INTO nop_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Agaŋ Yawan mihiŋiye’walaŋ wouhiye youhabet indiŋ: Elisa, Tasis, Kitim eŋ Lodanim. ");
INSERT INTO nop_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Uŋaniŋ meeniŋ daneeŋ bop molomolom, mede molomolom, naŋgat diki molomolom eŋ wouhik wapum molomolom unduŋ daneeŋ ime luhi gagayeŋ kwet hali ulak uŋandiŋ wooŋ hati taugiŋ. Yafet’walaŋ yalakiŋiye adi unduŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham’walaŋ mihiŋiye diniŋ wouhiye habet indiŋ: Kus, Misilaim, Put eŋ Kanaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Agaŋ Kus’walaŋ yalakiŋiye diniŋ wouhiye youhabet indiŋ: Seba, Hawila, Sabta, Lama eŋ Sabteka. Eŋ Lama’walaŋ mihiŋiyat lufom adi’walaŋ wouhiyat e indiŋ: Seba eŋ Dedaŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus’walaŋ yalakiŋiŋ adi Nimlot mintaguk. Adi kuyeŋ kwet foloŋ mapme loloŋit hatihati u tububihikuk. ");
INSERT INTO nop_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Eŋ Wapumdi saŋiniŋ mimbuune fafaŋe tiŋa kale kaliŋ yawooŋ kale mohok widihiluguk doktiŋa metamdi me niŋ wou nintilonene indiŋ niyagiŋ, Me Nimlotdi Wapum’walaŋ saŋiniŋ foloŋ kale yakidituguk dabugoŋ hinek eie! ");
INSERT INTO nop_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimlot adi mapme hatigukneŋ yobune tububihila yokwet wapuhi indiŋ mintataugiŋ. Babilon, Elek, eŋ Akat, yokwet wapuhi i hogohogok adi Babiloniya kwetneŋ ila ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Uŋaniŋ Asilia kwetneŋ wooŋ yobune uŋoŋ maaŋ yokwet wapuhi indiŋ mintagiŋ: Niniwe, Lehobot, Kala ");
INSERT INTO nop_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","eŋ Lesen woondi Niniwe eŋ Kala adi’walaŋ baŋamhik ginaŋ itak. Yokwet wondi wapum hinek tilak. ");
INSERT INTO nop_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Agaŋ Misilaim adi’walaŋ yalakiŋiye bop hatiiŋ indigoŋ tuwot wouhiye indiŋ hatak. Ludihi, Anamihi, Lehabihi, Nafituhi, ");
INSERT INTO nop_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patalusihi, Kafatolihi eŋ Kasiluhi. Adi’walaŋ lekiŋgoŋ foloŋ Filisitiahi adi adi ulihaka tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Agaŋ Kanaaŋ adi’walaŋ mihi tuwo adi Sidon eŋ adi’walaŋ sigineŋ mintaguk adi Het tiŋa mebop noli indiŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebusahi, Amolahi, Gilgasahi, ");
INSERT INTO nop_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwahi, Akahi, Sinihi, ");
INSERT INTO nop_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Awadahi, Semalahi eŋ Hamatahi. Bop unduŋ mintaugiŋ. Unduŋ mintatawooŋ mindaŋkade Kanaaŋ’walaŋ yalakiŋiye adi mowoŋa kwetkwet indiŋ hatitaugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Sidon, Gilakade uŋaniŋ eŋ uge uge Gasa kwetneŋ usuwalak. Agaŋ Sodom, Gomola, Adma uŋaniŋ eŋ uge uge Lasa usuwalak unduku hatitaugiŋ oŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kaŋ yoŋ adi Ham’walaŋ mihiŋiŋ laŋiye mintaulihakaaŋ wouhik wapum molomolom, eŋ medehik molomolom, eŋ kwethik molomolom unduŋ daneeŋ mowoŋa hati taugiŋ diniŋ kahat. ");
INSERT INTO nop_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet dali biyeniŋ Sem, Ebe’walaŋ yalakiŋiye diniŋ dadahik. ");
INSERT INTO nop_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem’walaŋ mihiŋiye mintagiŋ adiniŋ youhabet: Elam, Asu, Afakisat, Lut eŋ Alam. ");
INSERT INTO nop_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alam’walaŋ mihiŋiye: Usi, Huli, Gede eŋ Mesak. ");
INSERT INTO nop_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Afakisat adi adi Sela diniŋ beu. Agaŋ Sela adi Ebele diniŋ beu. ");
INSERT INTO nop_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebele adi mihiŋiŋyat lufom mintagumuk. Mihiŋiŋ niŋ wou Pelek youkuk. Woŋ adi mebi indiŋ, adi’walaŋ nai ginaŋ kwet wapum daneguk. Eŋ adi’walaŋ kwayaŋ diniŋ wou adi Yoktam youkuk. ");
INSERT INTO nop_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktam’walaŋ yalakiŋiye indiŋ mintagiŋ. Almoda, Selap, Hasamawe, Yela, ");
INSERT INTO nop_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadolam, Usal, Dikla, ");
INSERT INTO nop_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO nop_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofil, Hawila eŋ Yobap. Meheki i hogohogok adi Yoktam’walaŋ mihiŋiye. ");
INSERT INTO nop_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Adi yokwet hatigiŋ adi mele labulabuneŋkade kwet haŋgi haŋgi Mesaniŋ tububihila hatibune uge uge Sefala kwetneŋ dapmalak. ");
INSERT INTO nop_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sem’walaŋ yalakiŋiye adi wouhik wapum molomolom, medehik molomolom unduŋ daneeŋ mowoŋa hatitaugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Noa mihiŋiye’walaŋ yalakihiye unduŋ ulihakaaŋ naŋgat tali molomolom tububihila ugiŋ wondok tuwolit youhabiyetafoŋit. Indiŋ hinek mintaguk ime gabuŋ wapum busuwaguk dapmaune sigineŋ meeniŋ bop mohok kwetkwet hatitaugiŋ adi adi’walahi-ku ulihakagiŋ tilak. ");
INSERT INTO nop_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Kwetkwet meeniŋ hogohogok medehik kubugoŋ hogok hakuk. Eŋ nemek wouwou u wanakaŋ kubugoŋ halune yonadiyagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Unduŋ tiŋa adi mele labulabuneŋkade uge uge Babiloniya kwetneŋ gutuŋ wapum niŋ tubumintaaŋ uŋoŋ yokwet maaŋ itougiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tiŋa indiŋ yonadigiŋ. “Ale! Indi namaŋ wene bopneeŋ kugaliŋa kudup ginaŋ mohinek hene dakwambundawaak.” Ala namaŋ dakwambunda tigiŋ wondi yot mamandok kawadehik tuguk. Eŋ kwet maaneŋniŋ nawaŋ wondi galikiliti tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kaŋ yogiŋ. “Ale! indi yokwet wapum niŋ maaŋ yot kweheyeniŋ niŋ bebeli-bebelinit matalonene yot kiidi kunum wehemilaak. Unduŋ tiŋa wotnenik gigit wapuhi tiŋa kwetkwet mu daneeŋ mowoneem.” ");
INSERT INTO nop_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Unduŋ yoŋa yokwet wapum tububihila magiŋ eŋ yot kweheyeniŋ mayagiŋ u Wapumdi kanadi tibene foguk. ");
INSERT INTO nop_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Tiŋa Wapumdi yoguk, “Biyagoŋ adi mebop kubugoŋ eŋ medehik maaŋ kubugoŋ doktiŋa kwanai i tububihikiŋ. Eŋ nemek titindok yohabet tineeŋ u tubumulahuda mu tineeŋ. Woŋ adi tomboyoula titalooŋ folooŋ tubumintaneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ale! Indi fooŋ medehik tubufifile tinene medehik fifile tubune kedem mu nadidakaleneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wapum adi unduŋ yoŋa uŋaniŋ yehidaaneune kwetkwet udapmagiŋ. Unduŋ tiŋa yegiŋ e yokwet wapum magiŋ u wabi tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Unduŋ doktiŋa yokwet wiyale mowogiŋ wondiniŋ wou Babile yogiŋ. Inde’walaŋ mede foloŋ e “mede tubufifile mintaguk”. Wapumdi yokwet uŋgoŋ hinekku meeniŋ kwetkwet medehik tubufifileyembuune nedigut mede kiyonadi tigiŋ indigoŋ tuwolit molomolom daneeŋ kwetkwet mowoŋa udapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yoŋ adi Sem’walaŋ mede kahat tiŋa yalakiŋiye’walaŋ wohiye habet. Sem adi guletŋiŋ 100 tulune adi’walaŋ mihi niŋ mintaguk. Wou Afakisat. Adi adi ime gabuŋ wapum naŋgakuk uŋaniŋ hatitalolune gulet lufom dapmaune mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Kaŋ Sem adi Afakisat mintaguk uŋaniŋ tomboyoula gulet 500 hatiguk kaŋ wabiŋiŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kaŋ Afakisat adi guletŋiŋ 35 tubune adi’walaŋ mihiŋiŋ Sela mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Kaŋ Afakisat adi Sela mintaguk uŋaniŋ tomboyoula gulet 403 hatibuune wabiŋiŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kaŋ Sela adi guletŋiŋ 30 tulune adi’walaŋ mihiŋiŋ Ebele mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Kaŋ Sela adi Ebele mintaguk uŋaniŋ tomboyoula gulet 403 hatibuune wabiŋiŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kaŋ Ebele adi guletŋiŋ 34 tulune adi’walaŋ mihiŋiŋ Pelek mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Kaŋ Ebele adi Pelek mintaguk uŋaniŋ tomboyoula gulet 430 hatibuune wabiŋiŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kaŋ Pelek adi guletŋiŋ 30 tulune adi’walaŋ mihiŋiŋ Leu mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Kaŋ Pelek adi Leu mintaguk uŋaniŋ tomboyoula gulet 209 hatibuune adi’walaŋ wabiŋiŋ mihiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kaŋ Leu adi guletŋiŋ 32 tulune mihiŋiŋ Seluk mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Kaŋ Leu adi Seluk mintaguk uŋaniŋ tomboyoula gulet 207 hatibuune adi’walaŋ wabiŋiŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seluk adi guletŋiŋ 30 tulune adi’walaŋ mihiŋiŋ Naho mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Kaŋ Seluk adi Naho mintaguk uŋaniŋ tomboyoula gulet 200 hatibuune wabiŋiŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naho adi guletŋiŋ 29 tulune adi’walaŋ mihiŋiŋ Tela mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Kaŋ Naho adi Tela mintaguk uŋaniŋ tomboyoula gulet 119 hatibuune adi’walaŋ wabiŋiŋ mihiŋiye noli maaŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kaŋ Tela adi gulet 70 tulune adi’walaŋ mihiŋiye indiŋ mintamiŋgiŋ: Abalam, Naho eŋ Halan. ");
INSERT INTO nop_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Yoŋ adi Tela’walaŋ mede kahat. Adi mihiŋiye Abalam, Naho eŋ Halan mintagiŋ. Halan’walaŋ mihiŋiŋ Loti mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Halan adi adi beu Tela hogok hatilune Kaldea yoli kwelineŋ Ul yokwetneŋ uŋgoŋ kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kaŋ Abalam dut Naho adi tam yanagikumuk. Abalam adi tamŋiŋ Salai nagikuk, eŋ Naho adi Halan’walaŋ wabiŋiŋ Milika tamŋiŋ nagikuk. Halan adi wabiŋiyat lufom hatigumuk, Milika eŋ Isika. ");
INSERT INTO nop_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salai adi adi tam kafi, wapmihinit mokit hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kaŋ Tela adi mihiŋiŋ Abalam eŋ laaŋ Loti Halan mihiŋiŋ kuyoŋ eŋ nabuŋiŋ Salai, Abalam’walaŋ tamuŋiŋ, unduŋ yanagila Kanaaŋ kwetneŋ unene Kaldea kwetneŋ Ul yokwet u bikabuŋa talik tububihikiŋ. Uge uge talik lekiŋgoŋ Halan kwetneŋ usuwaaŋ uŋgoŋ itougiŋ. ");
INSERT INTO nop_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela adi gulet 205 hatiŋa Halan kwetneŋ uŋgoŋ kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kaŋ Bepaŋdi Abalam niŋguk, “Du kwake mebi eŋ magemageye eŋ yokekwake biyabudapmaaŋ nuku kwet niŋ ganindakalewit uŋoŋ wooŋ hatibaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kaŋ nu kahaŋ tigambene yalakigeye fee mintaulihaka tubune du’walaŋ woho gigitdi hautadapmawaak. Kaŋ du da ye wahu kahaŋ wondiniŋ mebi tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nebek niŋdi du gehikahaŋneneeŋ adi adi kibi nubo adi yehikahaŋnewaat eŋ nebek niŋdi ganisilone tineeŋ adi adi kibi nubo yenisilone tibaat. Tiŋa du’walaniŋ kahaŋdi kwetkwet metam wanakaŋ tokidapmayembaak.” ");
INSERT INTO nop_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kaŋ Abalam adi Wapum diniŋ mede tagimneeŋ talik tububihila ulune Loti adi takaliŋa wanaŋ noŋgoŋ ugumuk. Abalam adi guletŋiŋ 75 tubune Halan kwet bikabuŋa uguk. ");
INSERT INTO nop_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Adi tamuŋiŋ Salai eŋ dali diniŋ mihi Loti eŋ adi’walaŋ tipilapilaye eŋ bomboŋŋiŋ wanaŋ moŋgolune Kanaaŋ kwetneŋkade uge uge kwet uŋaŋ usuwagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Usuwaaŋ dapmaaŋ ugiŋ uge uge Sekem yokwetneŋ usuwagiŋ. Uŋoŋ adi me kwehiwahi’walaŋ bem muŋgohom niŋ dokoniŋgoŋ yobune yatuguk. Nai uŋaniŋ adi Kanaaŋ metam adi kwet wondiniŋ molom hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kaŋ Wapumdi Abalam mintamiŋa yoguk, “Biyagoŋ kuyoŋ, kwet yoŋ adi yalakigeye yembaat.” Kaŋ Abalam adi Wapumdi mintamiŋa mede niŋguk doktiŋa kwet uŋgoŋ Wapumdok alata niŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Tiŋa kotigoŋ kwet haŋgineŋkade looŋ uge uge Betele yokwet mele fofoŋneŋkade ikuk eŋ Ai yokwet mele labulabuneŋkade ikuk uŋgoŋ houle yot maguk. Tiŋa Abalam adi uŋgoŋ Wapum alata niŋ timiŋa wou nintilooŋ niutumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Tiŋa kotigoŋ pilaliŋa Negep kwetneŋkade uguk. ");
INSERT INTO nop_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kanaaŋ kwet wapumneŋ uŋoŋ mele wapum yalune map wapum mintaguk doktiŋa Abalamdi Isip kwetneŋkade nai muniniŋ hatibene uŋoŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ala Isip kwet tubudulaaŋ tamuŋiŋ Salai indiŋ niŋguk, “Nadilaŋ be? Du adi tam folonamandapge momooŋ hinek u nu kaule mu tilat. ");
INSERT INTO nop_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isip me adi gabuŋa indiŋ yoneŋ, ‘Biyagoŋ hinek, ya tamuŋiŋ ne’walaŋ’ yoŋa nulukumuŋ tineeŋ eŋ du adi bigabune hatibaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Unduŋ doktiŋa indiŋ yobaaŋ, ‘Nu adi adi’walaŋ wiwi’ unduŋ yobaaŋ kaŋ adi dutok tiŋa nu kedem binabuune hatibaat.” ");
INSERT INTO nop_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ala Abalam adi agaŋ Isip kwetneŋ usuaune Isip me adi tam diniŋ folonamandapŋiŋ momooŋ hatibune kagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tiŋa Felo’walaŋ me wapuhi adi Felo’walaŋ bop ginaŋ hatiŋa tam aditok yogalika kisaŋ tigiŋ. Tiŋa tam u nagila Felo’walaŋ yolineŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kaŋ Felo adi Salai doktiŋa Abalam siloŋ kisaŋ timiŋa, dompa, makau, doŋki eŋ tipilapilaye metam eŋ kamele fee hinek mintoiguk. ");
INSERT INTO nop_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Iŋgoŋ oŋ, Wapum adi Abalam tamuŋiŋ Salai doktiŋa Felo meŋimeŋiye yagit folofigita kisaŋ yemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Unduŋ tubune Felodi Abalam kutnimbune buune indiŋ ninadiguk, “I maŋgoŋ kudi tinamuŋguŋ? Adi tamune unduŋ maŋgoŋde mu naniŋguŋ? ");
INSERT INTO nop_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Adi witne unduŋ maŋgoŋde yobune tam i nutok tibek yoŋa yotneneŋ nagi logut? Pilap hinek tamge nagila momooŋ tiŋa u!” ");
INSERT INTO nop_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Unduŋ yoŋa Felodi memikŋiye yeniŋkulune Abalam ne eŋ tamuŋiŋ eŋ bomboŋhik tiulidokoyemiŋa yapmeune kwehite ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abalam ne eŋ tamuŋiŋ eŋ bomboŋŋiŋ tiŋa Loti wanaŋ Isip kwetneniŋ udaneŋ buŋa Negep kwetneŋ usuwagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abalam adi dompa makau tiŋa gol eŋ siliwa fee hinek ilimiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kaŋ Abalam adi Negeb kwetneniŋ Betele yokwetneŋkade ipilat tita uge uge koom kwaha Betele yokwet eŋ Ai yokwet lekiŋgoŋhik ginaŋ ne houle yot magukneŋ uŋgoŋ usuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tiŋa biyagoŋ hinek koom kwaha alata tugukneŋ uŋgoŋ Wapum wou nintilooŋ niutumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Agaŋ Loti adi maaŋ Abalam dut hatiŋale dompa makauŋiye fee mintamiŋgiŋ. Eŋ houle yot maaŋ fee ilimiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ala wanawanaŋ itoudok kwetdi tuwolithik mu tuguk. Kalehiye fee ulihakagiŋ doktiŋa kwet kubugoŋ itoudok tuwot mu tuguk. ");
INSERT INTO nop_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Unduŋ doktiŋa Abalam’walaŋ kale yabudokoyagiŋ eŋ Loti’walaŋ kale yabudokoyagiŋ heki yeŋ kwet doktiŋa ulitawa ulitawa tubumintagiŋ. Nai uŋaniŋ adi Kanaaŋhi eŋ Pelesihi adi maaŋ kwet uŋgoŋ itouwagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Unduŋ doktiŋa Abalamdi Lotidok indiŋ niŋguk, “Indi adi yabet ala inde’walaŋ lekiŋgoŋnik foloŋ be kale yabudokonimiiŋ adi’walaŋ lekiŋgoŋ foloŋ ulitawa ulitawa halune tuwot mu tibek. ");
INSERT INTO nop_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ala dauge diweeŋ kwet wapum hali ulak u mu be kalaŋ? Ale mowodim. Du ye kohonik kapmadineŋkade wee yobeŋ kaŋ nu kohonik didimeniŋneŋkade wit. Bee du didimeniŋneŋkade wee yobeŋ kaŋ nu ye kapmadineŋkade wit.” ");
INSERT INTO nop_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Unduŋ yobune Loti dadiyeeŋ diweeŋ kaguk Yodan kwet gutuŋ imenit eŋ duhuduhu mohinek hakuk u kaŋ nadiune Wapum’walaŋ bem gimiŋ fiye nabugoŋ hinek tuguk eŋ Isip kwet nabugoŋ hali uyeŋ Sowa yokwet wapumneŋ usuwalak. Woŋ adi Wapumdi Sodom eŋ Gomola yokwet mu yehitubukadakagukneŋ Yodan kwet adi undiniŋku hakuk oŋ. ");
INSERT INTO nop_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kaŋ Loti adi Yodan kwet gutuŋ u kahileeŋ mele labulabuneŋkade Yodande uguk. Nai uŋaniŋgoŋ hinek me yabet wanaŋ hatiyagumuk u daneeŋ mowogumuk. ");
INSERT INTO nop_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Kaŋ Abalam adi Kanaaŋ kwetneŋ uŋgoŋ hatiguk. Eŋ Loti adi kwet gutuneŋ yokwet wapuhi ilawagiŋneŋ lekiŋgoŋhik ginaŋ houle yotŋiŋ Sodom yokwet gagayeŋ maaŋ itouluguk. ");
INSERT INTO nop_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Nai uŋaniŋ Sodomhi metam adi hogohi hinek. Adi adi kadakaniŋ fuliŋgoŋ tiŋa Wapum sigilulum hinek timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loti adi Abalam bikabuŋa ulune Wapumdi Abalam indiŋ niŋguk. “Du da yataŋneŋ uŋgoŋ yali dauge diweune kwet wohiŋkade eŋ komaaŋkade eŋ mele labulabuneŋkade eŋ fofoŋneŋkade wek. ");
INSERT INTO nop_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Kwet kalaŋ hogohogok woŋ, uyadi du eŋ yalakigeye hiditok hinek hafafaŋedok yofafaŋelat. ");
INSERT INTO nop_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tiŋa yalakigeye yehitubuulihakawene kisaŋ ulihakaune kunakunathik kwet kilabut hatak wondok tuwolit tibaak. Kaŋ kwet kilabut kunakunatdok tuwot mu tilak doktiŋa me nediyeŋ kwet kilabut kedem kunalaak adi du’walaŋ yalakigeye kedem yehikunalaak. Moŋ adi moŋ. ");
INSERT INTO nop_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Du pilat tiŋa kwet koloŋŋiŋ eŋ dabekŋiŋ yaliŋa dapmataweŋ. Biyagoŋ kuyoŋ, kwet u dutok gamulat.” ");
INSERT INTO nop_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kaŋ Abalam adi houleŋiŋ yot wiyali ipilat tita uge uge Hebulon yokwetneŋ Mamele adi’walaŋ bem muŋgohom fiye gagayeŋ houleŋiŋ yot maune ikuk. Tiŋa uŋgoŋ itouŋale Wapumdok alata niŋ tutumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Babiloniya niŋ mapme Amalafe, eŋ Elasa niŋ mapme Alioko, eŋ Elam niŋ mapme Kedo-Laome, eŋ Goim niŋ mapme Tidali, ");
INSERT INTO nop_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","adi heki yeŋ mapme 5 indiŋ dut mindobu tigiŋ: Sodom niŋ mapme Bela, eŋ Gomola niŋ mapme Bilisa, eŋ Adama niŋ mapme Sinaba, eŋ Seboim niŋ mapme Semebe, eŋ Bela niŋ mapme Sowa. ");
INSERT INTO nop_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mapme hogohogok adi Sidim kwet gutuneŋ mindobu titindok yofolok tiŋa bopnegiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Mapme 5 adi gulet 12 wondok tuwot mapme Kedo-Laome’walaŋ falipmeŋ hatiŋa tipilapilaye timiŋgiŋ. Ala gulet 13 foloŋ sigilulum timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kaŋ gulet kunakunat 14 foloŋ Kedo-Laome eŋ mapme adut hatigiŋ adi buŋa Asitelo-Kalanaim yokwetneŋ Lefaim me widihigiŋ, uŋaniŋ buŋa Ham yokwetneŋ Suŋim me widihigiŋ, uŋaniŋ buŋa Kiliatim gutuneŋ Emim me widihigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Uŋaniŋ buŋa Seili haŋgi foloŋ Holite me widihi yahakali tauge uge Elapalaŋ yokwetneŋ kwet fileŋ magineŋ usuagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tiŋa uŋaniŋ uge uge Eŋmisipa kwetneŋ usuwagiŋ. Usuwaaŋ Amalekhi kwet uŋaŋ hatigiŋ u widihiŋa me Amolihi Hasasoŋ-Tama yopmaŋhi maaŋ widihigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Kaŋ Sodom niŋ mapme, Gomola niŋ mapme, Adama niŋ mapme, Seboim niŋ mapme, eŋ Bela niŋ mapme adi adi Sidim gutuneŋ mik tinene ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Usuwaŋ fukuniŋ yakiŋ eŋ fukuniŋ adi Elam niŋ mapme Kedo-Laome, eŋ Goim niŋ mapme Tidali, eŋ Babiloniya niŋ mapme Amalafe, eŋ Elasa niŋ mapme Alioko adi yakiŋ. Fukuniŋ 4 eŋ fukuniŋ 5 unduŋ yakiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidim gutuneŋ adi kwet nawaŋ diniŋ bom fee hinek yali ugiŋ. Kaŋ memik heki adi Sodom eŋ Gomolahi mapme widihi yahakaliune momoune memikhiye noli bom ginaŋ maaŋ fogiŋ eŋ noli momooŋ kwet haŋgi haŋgi maugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Unduŋ tubune memik heki adi Sodom eŋ Gomola yokwetneŋ fooŋ bomboŋ eŋ nanaŋe moŋgodapmaaŋ maugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Unduŋ tiŋa yegiŋ e Abalam dali diniŋ mihi Loti Sodom yokwetneŋ itouluguk nagila bomboŋŋiŋ wanaŋ moŋgola ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Me niŋ mik ginaŋ mu kumuŋgukdi weneŋgeila buŋa wooŋ Hibuluniŋ me Abalam mikdiniŋ mede kahat timiŋguk. Nai uŋaniŋ Abalam adi Amoliniŋ me wou Mamele adi’walaŋ muŋgohom fiye ginaŋ itouluguk. Itouŋa Mamele noliŋiyat Esikola eŋ Aneladut me hekinolit momooŋ tiŋa hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ala Abalam adi adi mihiŋiŋ kohoŋ tawadi ibiŋa nagila ugiŋ wondiniŋ mede kahat nadiŋa uŋaniŋgoŋ pilap hinek mewoi ne’walaŋ kayoŋbop ginaŋ mintagiŋ eŋ mik titindok mebi agaŋ nadiyagiŋ me 318 yanagilune memik yahakaliŋa ugiŋ. Uge uge Dan yokwetneŋkade usuagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tiŋa Abalam adi meŋiye yehidaneeŋ bop bop yapme tauguk. Unduŋ tubudapmaaŋ timiŋ me mikŋiye tobogoŋ busuwayemiŋa widihi yahakali tauge uge Hoba yokwetneŋ Damasiko wohiŋkade usuwagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Usuwaaŋ bomboŋ wanakaŋ yolom moŋgodapmaguk. Tiŋa mihiŋiŋ Loti ne eŋ bomboŋŋiŋ eŋ tamwoi eŋ metam eŋ bomboŋhik wanakaŋ moŋgodapmaaŋ yehitubuudanedapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abalam adi Kedo-Laome eŋ mapme noliŋiye widihi yahakalitawooŋ udaneeŋ bulune Sodom niŋ mapme adi pilali Sawe gutuŋ wou niŋ Mapme heki’walaŋ gutuŋ, uŋaŋ kimindewene uguk. ");
INSERT INTO nop_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kaŋ Mapme Salemniŋ, Bepaŋ Loloŋit’walaŋ siloŋ hemiŋ diniŋ kwanai me wapum hatiguk, Melikisedekdi Abalamdok belet eŋ wain ime moŋgolimiŋa uguk. ");
INSERT INTO nop_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Tiŋa kahaŋ timiŋa mede indiŋ yoguk. “Bepaŋ Loloŋnitdi Abalam kahaŋ timimbaak. Kunum Kwet tubumintaguk adi kuyoŋ. ");
INSERT INTO nop_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ala Bepaŋ Loloŋnit nintilooŋ niutumbadok. Adigoŋ hinek memikgeye kohoge ginaŋ boiguk.” Kaŋ Abalam adi nemek hogohogok ten ginaŋniŋ kubugoŋ kubugoŋdok tuwolit daneeŋ miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Unduŋ tulune Sodom niŋ mapme adi Abalam indiŋ yoŋa niŋguk, “Metam adi natok nambeŋ eŋ bomboŋ hogohogok adi dutok tibek.” ");
INSERT INTO nop_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Unduŋ yobune Abalamdibo Sodom mapme indiŋ niŋguk, “Wapum Bepaŋ Loloŋnit hinek, Kunum Kwet Molom adi’walaŋ wou foloŋ yofafaŋelat. ");
INSERT INTO nop_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Nu houle tibine tibine tawa be kayoŋ namokop tubukiliti tawaŋiŋ be nemek kambaŋgit kabe u be u nemu hinek moŋgolit. Ti du indiŋ yobaaneŋ, ‘Nu Abalam bomboŋ miŋgut kaŋ bomboŋ mohoknit tilak.’ ");
INSERT INTO nop_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Unduŋ doktiŋa nu’walaŋkade adi mewoi yanagi ugut adi muni nagiŋ u hogok hatak. Eŋ, me heki nukut ugumun Anela, Esikola eŋ Mamele adi hogokdi nemek tuwolithik moŋgotneeŋ u hogok.” ");
INSERT INTO nop_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kaŋ nai uŋaniŋ Wapumdi yagamadi ginaŋ nabugoŋ mintamiŋa niŋguk, “Abalam du munta mu tibeŋ. Nu adi yahehewege, eŋ kibikoŋ wapum hinek mintagambune wohoge gigit loloŋnit hinek tibaak.” ");
INSERT INTO nop_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abalamdibo indiŋ yoguk, “Wapum Bepaŋ, du maŋgoŋ nambene nanilaŋ? Nu wapmihinenit mokit. Hogok itoulat doktiŋa Eliesa Damasiko yopmaniŋ adi nemenemek u kedem yabukahileeŋ moŋgolaak.” ");
INSERT INTO nop_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Unduŋ yoŋa tomboyoula indiŋ yoguk. “Nadilaŋ be? Du wapmihi nemu namuŋguŋ doktiŋa biyagoŋ kuyoŋ, tipilapilayenedi nu’walaŋ kohone diki yabukahilewaak.” ");
INSERT INTO nop_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Unduŋ yolune Wapum’walaŋ mede indiŋ mintamiŋguk, “Adi adi du’walaŋ kohoge diki mu yabukahilewaak. Mooŋ. Da’walaŋ mihige hinek mintawaakdi yabukahilewaak.” ");
INSERT INTO nop_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Unduŋ yoŋa fakaŋ nagila fooŋ niŋguk. “Du dadiyeeŋ kunumneŋ dauge diweune loune hinantilamek yabeŋ. U kedem be kunaleŋ?” Tiŋa niŋguk, “Biyagoŋ kuyoŋ, yalakigeye adi wondok tuwolit mintaulihakaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Unduŋ yobune Abalamdi Wapum nadisukilitimiŋguk. Unduŋ tubune Bapaŋdi nadiune me didimeniŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Tiŋa indiŋ niŋguk, “Biyagoŋ kuyoŋ, Wapum Yaweh hatilat nuku kwet i gambene Ul yokwetneŋ Kaldea kwetneniŋ ganagila bugut.” ");
INSERT INTO nop_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ingoŋ oŋ Abalamdi yoguk, “O Wapum Yaweh, nu kwet i kahilewaat u mebi dediŋ foloŋ nadisukiliwit?” ");
INSERT INTO nop_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Unduŋ yobune niŋguk, “Du wooŋ makau taamuniŋ niŋ guletŋiŋ 3 tuguk eŋ meme taamuniŋ eŋ dompa maaniŋ niŋ gulethik 3 tuguk eŋ bagi bitigilii eŋ bagi mihiniŋ nimaaŋ yabuŋa moŋgola buŋa nambeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abalamdi moŋgola buŋa lekiŋgoŋ hinek ulitawaaŋ faki fukufukuŋ habiye tauguk. Bagi hogok adigili mu ulitawaguk. ");
INSERT INTO nop_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kaŋ kalaŋkatak hekidi buŋa nemek munduŋnit u nanee tubune Abalamdi yahakali tuguk. ");
INSERT INTO nop_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Unduŋ tiŋa mele fowe tulune Abalam adi domo kisaŋ nadiŋa dahatune mambip fuliŋgoŋdi kufulaune munta kisaŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Unduŋ tulune Wapumdi Abalam indiŋ niŋguk, “Du indiŋ nadifafaŋeweŋ. Yalakigeye adi kwet niŋ aditok gigit mu yoŋit uŋaŋ hogok buŋambu wooŋ hatineeŋ. Tiŋa kwet molohiyedi yehididiŋene tubune tipilipilaye kwanai tiyem hatilune gulet 400 dapmawaak. ");
INSERT INTO nop_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Eŋ tipilapilaye kwanai tiyemineeŋ mebop adi adi kibi nubo kibikoŋ wobuyembaat. Eŋ yalakigeye adi adi bomboŋ mohok hinit uneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Da adi baha papageye adi’walaŋ hatikwele kwetneŋ fowaaŋ. Du hatihinakaaŋ gawada hinek tiŋa kumumbune gehiweneneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eŋ yalakigeye adi Amolihi metam’walaŋ kadakaniŋdi maniŋgoŋ mu tokilak dotiŋa uŋgoŋ hatitalolune ulihakahik nai 4 tubune udaneeŋ buneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kaŋ mele foune bufa hinakalune mupmuk kulufe eŋ kamaŋ kudup mabemnit mintaaŋ kale faki fukufukuŋ hakiŋ lekiŋgoŋhik ginaŋ dapmaaŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mele nai uŋaniŋ Yawehdi indiŋ yoŋa Abalamdut yofolok tugumuk. “Isip kwet diniŋ imeneniŋ tububihila uge uge Yufeletis ime wapum ginaŋ dapmalak. Biyagoŋ kuyoŋ, kwet u yalakigeye yemdok yokwambundalat. ");
INSERT INTO nop_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kenihi, Kenisihi, eŋ Kadomihi, ");
INSERT INTO nop_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitihi, Pelisihi eŋ Lefaimhi, ");
INSERT INTO nop_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amolihi, Kanaaŋhi, Gigasahi eŋ Yebusihi adi’walaŋ kwetku du’walaŋ yalakigeye yembaat. ");
INSERT INTO nop_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abalam tamuŋiŋ Salai adi kafi hatiŋa wapmihi nemu nagikuk. Ala Isip niŋ tipilapilaye wabiŋiŋ niŋ hatiguk wou Haga. ");
INSERT INTO nop_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ala Salaidi Abalam indiŋ niŋguk, “Nadilaŋ be? Bepaŋdi welene kameheune wapmihi mu yanagitat doktiŋa du tipilapilaye wabinedut hatibuune mihi neeŋ tubumintanambaak.” Yobune Abalamdi Salai diniŋ mede nadiguk. ");
INSERT INTO nop_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ala Abalam adi Kanaaŋ kwetneŋ hatilune gulet 10 dapmaguk nai uŋaniŋ Salai Abalam tamuŋiŋdi Isipniŋ tipilapilaye wabiŋiŋ Haga nagila yohoi Abalamdok mimbuune tamuŋiŋ nagikuk. ");
INSERT INTO nop_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kaŋ Haga adi Abalamdut hatiŋa agaŋ mihiwelenit tuguk. Unduŋ tiŋa agaŋ mihiwelenit tilat yoŋa tam bombooŋgiŋiŋdok nadiune fofoŋnit tuguk. ");
INSERT INTO nop_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Unduŋ tubune Salaidi Abalam indiŋ niŋguk, “Nu meeka tilat yoŋ adi yom du’walaŋ. Biyagoŋ, nagoŋ tipilapilaye wabine gambene tamge unduŋ nagila noŋgoŋ hatigumuk. Kaŋ adi mihiwelenit tilat yoŋa nutok nadinambune fofoŋnit tilak. Unduŋ tubune lekiŋgoŋnik foloŋ mede mintaaŋ hatak u yadi Wapum negoŋ yodapmawaak.” ");
INSERT INTO nop_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Unduŋ yobune Abalamdi Salai mede indiŋ niŋguk, “Tipilapilaye wabi adi adi du kohoge foloŋ hatilak. Ale unduŋ be unduŋ timimbene kedem timimbeŋ.” Unduŋ yobune Salaidi Haga kato tiŋa not mu timimbune momoŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Momoŋ ulune Wapum diniŋ aŋelodi kwet fiileŋ Sulu talik gagayeŋ ime dawi itakneŋ uŋoŋ kaguk. ");
INSERT INTO nop_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kaŋ indiŋ yoŋa ninadiguk, “Haga, Salai diniŋ tipilapilaye wabi, du diŋaniŋ bulaŋ tiŋa diŋandiŋ uluweŋ?” Adibo yoguk, “Nu tam bomboŋgine Salai kasukuleeŋ momolat.” ");
INSERT INTO nop_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kaŋ Wapum’walaŋ Aŋelodibo niŋguk, “Du kotigoŋ udaneeŋ wooŋ tam bomboŋgige’walaŋ falipmeŋ kwelemaŋgoŋ eŋ baigoŋ hatibaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Tiŋa Wapum’walaŋ Aŋelodi indiŋ tomboyoula niŋguk, “Nu yalakigeye yehitubuulihakawene kisaŋ ulihakaune kunakunathik kunatdok baniŋ tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Wapum’walaŋ aŋelodi kotigoŋ tomboyoula indiŋ niŋguk, “Du mihiwelenit hatilaŋ. Ala hatigane mihi niŋ nagilaaŋ, nagila wou Ismael yobaaŋ. Wapum adi kobulabulayege nadiŋak. ");
INSERT INTO nop_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mihi adi doŋki moiŋ koŋgolondaaŋ nabugoŋ hatibaak. Unduŋ tiŋa meeniŋ hogohogok memik tiyembaak. Kaŋ adibo kibimaaŋ mik timiyaneeŋ. Eŋ kwayaŋye dut itouŋale adut welekubugoŋ mu tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Wapumdi Haga mede niŋguk doktiŋa mindaŋkade wondok nadisuŋa Wapum wou indiŋ niŋguk, “Bepaŋ, du’walaŋ namandake foloŋ miŋgoŋ hatibe nabulaŋ. U biyagoŋ nu hati nabulak adigoŋ hinek kagut.” ");
INSERT INTO nop_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Unduŋ doktiŋa ime koŋ wondiniŋ wou indiŋ youkuk: Hatihati molomdi hati nabulak adi’walaŋ ime daawi. Ala ime dawi woŋ adi Kades eŋ Belet lekiŋgoŋhik foloŋ hatak. ");
INSERT INTO nop_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ala hatigane Hagadi Abalamdok mihi niŋ nagilimimbune Abalamdi wou Ismael youkuk. ");
INSERT INTO nop_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abalam adi agaŋ guletŋiŋ 86 tulune Ismael mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abalam adi guletŋiŋ 99 tulune Wapumdi mintamiŋa indiŋ niŋguk, “Nu Bepaŋ, Saŋiniŋ Molom. Nu’walaŋ namandatne foloŋ didimeniŋ hatiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kaŋ nu dukut yofolok tiŋa gehitubuulihakawene kisaŋ ulihakawaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Unduŋ yobune Abalam adi mulelem tiŋa namanda kwet foloŋ tubuwopmobula dahakuk. Kaŋ Bepaŋdi indiŋ niŋguk, ");
INSERT INTO nop_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nadilaŋ be? Nu dukut yofolokne tilat. Du adi meeniŋ bop mohok adi’walaŋ behik tiŋa hatibaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ale du woho Abalam kotigoŋ mu yodok. Adi Abalaham, woho koobuli unduŋ yodok. Biyagoŋ kuyoŋ, nu meeniŋ bop mohok adi’walaŋ behik gapmelat. ");
INSERT INTO nop_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yalakigeye kisaŋ ulihakadok yokwambundawene meeniŋ bop mohok tineeŋ. Tiŋa meeniŋ du’walahi nolidi mapme mintatauneŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kaŋ du eŋ yalakigeye hidi’walaŋ Bepaŋ hatidok yofolokne tubukwambundawene du eŋ yalakigeye kougoŋ mintatauneŋ indi’walaŋ lekiŋgoŋnik foloŋ hali wooŋ halaak fafaŋeniŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Biyagoŋ kuyoŋ, kwet buŋambu hatilaŋ Kanaaŋ kwet wapum i du eŋ yalakigeye hidi moŋgola yabukahileune hiditok gigit hafafaŋedok hambaat. Tiŋa hidi’walaŋ Bepaŋhik tiŋa hatibaat.” ");
INSERT INTO nop_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kaŋ Bepaŋdi Abalaham indiŋ maaŋ niŋguk, “Du adi yofolokne u momooŋ hinek kadokooŋ kamehatibaaŋ, du eŋ yalakigeye hidi yofolok komi kobuli wanaŋ kame hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Du eŋ yalakigeye hidi yofolokne hatak u gitagaŋ hinek indiŋ kadokoneeŋ. Mewoi hogohogok hatiiŋ hidi sigihik diki foloŋ fek dobudapmaneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Fek titiŋ adi sigihik diki gitnem dobuneeŋ unduŋ tiŋa feknit tineeŋ. Unduŋ tubune lekiŋgoŋnik foloŋ yofolok mintaguk hatak wondiniŋ fek tibaak. ");
INSERT INTO nop_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Hide’walaŋ yalakihiye bop mintatauneŋ tuwot mihihiye mintahalune melenai 8 tubune sigihik diki gitnem dobuyemaneeŋ. Hide’walaŋ yohineŋ mintagiŋ be niŋkadehi, eŋ muneeŋdi yehituwaneeŋ adi’walaŋ maaŋ dobuyemaneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Undugoŋ hinek yohineŋ mintaneeŋ be niŋkadehi muneeŋdi yehituwaneeŋ adi’walaŋ sigihik foloŋ maaŋ fek tineeŋ. Yofoloknedi hidi’walaŋ foloohik foloŋ hali wooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Me niŋ adi yofolokne kelekula sigiiŋ diki ginaŋ fek mu tiŋa hogok hatibaak adi adi yofolok mede ulihiŋa kelekulune hidi’walaŋ bop bihabuŋa ne hogok hatibaak.” ");
INSERT INTO nop_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Tiŋa Bepaŋdi tomboyoula Abalaham indiŋ niŋguk, “Tamge Salai adi’walaŋ wou Salai kotigoŋ mu niluwaaŋ adi Salah niluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nu adi kahaŋ timiŋa adi’walaniŋ mihi niŋ gambaat. Biyagoŋ hinek nu Salah kahaŋ timimbene adi’walaniŋ meeniŋ bop mohok mintaaŋ hatineeŋ. Eŋ metam’walaŋ mapmehiye adi adi’walaniŋ mintaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Unduŋ yobune Abalaham adi namanda kwet foloŋ tubuwopmobula gegeŋ indiŋ nadisuguk, “Me niŋ adi guletŋiŋ 100 tubune mihi niŋ kedem be mintamimbek? Tiŋa Salah adi guletŋiŋ 90 tugukdi eyaŋ niŋ kedem be nagilaak?” ");
INSERT INTO nop_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abalaham adi unduŋ tiŋa Bepaŋ indiŋ niŋguk, “Du nadiweŋ kaŋ Ismaeldi kedem du’walaŋ kahaŋ ginaŋ tuwot mube hatibek ale!” ");
INSERT INTO nop_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kaŋ Bepaŋdibo yoguk, “Mooŋ hinek, tamge Salahdi mihi niŋ nagilaak, adi’walaŋ wou Aisak youlaaŋ. Kaŋ nubo adut yofolok fafaŋeniŋ tibene yofolok wondi yalakiŋiyedut hali wooŋ hatuwaak. ");
INSERT INTO nop_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Eŋ Ismaeldok maaŋ agaŋ nadigamulat. Nadilaŋ be? Nu adi kahaŋ timimbene yalakiŋiye kisaŋ ulihakaneeŋ. Adi’walaŋ yalakiŋiye ginaŋ mapme 12 mintaneeŋ. Tiŋa nadimimbene mebop mohok tiŋa hatibaak. ");
INSERT INTO nop_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Iŋgoŋ oŋ, yofolokne adi Aisakdut tubukilitiwaat adi adi Salahdi gulet niŋ wohiŋ gweleŋdok nai indiineŋku nagilaak.” ");
INSERT INTO nop_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Bepaŋ adi Abalahamdut mede yonadi unduŋ tubudapmaaŋ pilale Abalaham bikabuŋa loguk. ");
INSERT INTO nop_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Lolune Abalaham adi mihiŋiŋ Ismael eŋ tipilapilayeŋiye yolineŋ mintagiŋ eŋ muneeŋdi yehituwagiŋ eŋ me hogohogok yolineŋ hatigiŋ u yanagila Bepaŋdi yodakaleguk u takaliŋa me hogohogok sigihik diki gitnem dobuŋa fek tiyemguk. ");
INSERT INTO nop_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abalaham adi guletŋiŋ 99 tubune ne’walaŋ sigiŋ diki foloŋ fek tuguk. ");
INSERT INTO nop_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Eŋ mihiŋiŋ Ismael adi adi guletŋiŋ 13 tubune sigiŋ diki foloŋ fek timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abalaham dut mihiŋiŋ Isimael adi melenai uŋaniŋgoŋ sigihik diki foloŋ fek tiŋit. ");
INSERT INTO nop_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Eŋ tipilapilayeŋiye hogohogok eŋ ne’walaŋ yolineŋ mintagiŋ be me noli’walaŋ muneeŋdi yehituwaŋit adi melenai kubugoŋ uŋgoŋ sigihik diki foloŋ fek tiyemdapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Heleŋniŋ Abalaham adi mele lekiŋgoŋ tubune mele fafaŋeniŋgoŋ diwelune Mamele’walaŋ muŋgohom fiye ginaŋ houle yotŋiŋ yeme foloŋ itune Wapumdi mintamiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Adi ikane dadiyeeŋ dawi diweune uune me nalum lufomkulitniŋ yalune yabuŋa boho tuguk. Tiŋa pilale weneŋgeila wooŋ yabuguk. Yabuŋa namanda kwet foloŋ tubuwopmobula indiŋ yoguk, ");
INSERT INTO nop_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Me Bomboŋgine, du tipilapilaye mege nutok nadinambune utumbalak kaŋ mu nalakapmeŋ weŋ. ");
INSERT INTO nop_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yobene ime tiŋa buune kayohik youtela bem yooŋneŋ uŋgoŋ fooŋ ikweleneŋ. ");
INSERT INTO nop_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kaŋ nuye wooŋ belet kabe niŋ tiŋa beene nakilitiŋa uneene kaŋ uneŋ. Tipilapilayehik kada nu’walaŋ buŋit doktiŋa deti hogok habukabaleeŋ halene uneŋ.” Yobune adibo yogiŋ, “Kedem ale, yolaŋ undugoŋ tibeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Unduŋ yobune Abalaham adi pilap hinek houle yot maaneŋ fooŋ Salah indiŋ niŋguk, “Pilap hinek palaua gigit maliŋ lufomkulitniŋ gila miŋobuŋa belet heweŋ.” ");
INSERT INTO nop_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Unduŋ niŋa Abalaham ne pilap wooŋ makau mihiniŋ kobuli kwelemaŋgoŋ niŋ tubumintaaŋ wooŋ tipilapilaye mihi nimbu adi pilap pilap hinek ula dobu heguk. ");
INSERT INTO nop_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kaŋ Abalahamdi nom tapatŋiŋ eŋ imeŋiŋ eŋ makau dobu heguk u wanaŋ moŋgola buŋa yemiŋguk. Kaŋ adi ila nalune Abalaham ne bem yooŋneŋ uŋgoŋ yamadi yakuk. ");
INSERT INTO nop_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kaŋ meheki adi indiŋ ninadigiŋ, “Tamge Salah adi daŋgoŋ hatak?” Kaŋ yoguk, “Adi yot maaneŋ hatak.” ");
INSERT INTO nop_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kaŋ Wapumdibo yoguk, “Nu gulet wohiŋkade nai indiineŋgoŋ kotigoŋ buŋa gabaat. Nai uŋaniŋ Salah adi eyaŋ niŋ toboŋa ilaak.” Salah adi talik yeme gagayeŋ hebiyali magi kametnadi tuguk. ");
INSERT INTO nop_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abalaham eŋ Salah adi agaŋ gulet fee hatitalabuŋa agaŋ metam gawadahi tugumuk. Doktiŋa Salah adi wapmihi yanagitdok tuwot mu tuguk. ");
INSERT INTO nop_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Unduŋ doktiŋa Salah adi weleŋ maaneŋ indiŋ nadiŋa gegeguk. “Nu adi foloone agaŋ sipaka tuguk, eŋ bomboŋgine adi maaŋ agaŋ me gawadaaŋ hinek, undihidi doti dediŋ tiŋa mihiwele tiŋa eyaŋ nagilaat?” ");
INSERT INTO nop_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kaŋ Wapumdi Abalaham ninadiŋa niŋguk, “Salah adi maŋgoŋde indiŋ yoŋa gegelak? Nu agaŋ tam gawadaaŋ tugutdi kedem be mihiwele tiŋa eyaŋ nagilaat? ");
INSERT INTO nop_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Wapum adi nemek wondok be wondok tubumalahuda be tibek? Nu gulet wohiŋkade nai indiineŋgoŋ kotigoŋ udaneŋ baat. Nai uŋaniŋ adi Salah adi mihinit hatibaak.” ");
INSERT INTO nop_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Unduŋ yobune Salah adi munta tiŋa kamehebiŋa yoguk, “Nu mu gegeŋat.” Iŋgoŋ oŋ, adi yoguk, “Biyagoŋ hinek, du agaŋ gegeŋaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mewoi adi ikane pilaleŋa Sodom yokwetneŋkade unene ugiŋ. Kaŋ Abalaham adi talipmeŋ yapmewene wanaŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","18","Uŋale uŋale Wapum adi weleŋdi indiŋ nadisuguk, “Abalaham’walaŋ yalakiŋiye adi mebop fee hinek eŋ fafaŋehi titindok eŋ adi’walaŋ kahaŋdi kwetkwet meeniŋ hatitawiiŋ adi’walaŋkade meŋeŋa tokiyemdok unduŋ yofafaŋegut. Ale nu nemek tibe nadilat u Abalaham maŋgoŋde kamehebimimbit? ");
INSERT INTO nop_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nu biyagaŋ kuyoŋ indiŋ yoŋa kahilegut. Adigoŋ yalakiŋiye eŋ kayoŋbopŋiye adi Wapum nu’walaŋ talik yenindidimeeŋ uŋgoniŋ eŋ didimeniŋ hatidok yenindakalewaak. Unduŋ tubune Wapum nu Abalaham nemek timindok gigit niŋgut u folooŋ kedem tubumintawaat.” ");
INSERT INTO nop_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Wapumdi unduŋ yoŋa yoguk, “Sodom eŋ Gomolahi metam adi’walaŋ kadakaniŋ uyadi mulabumuŋ hinek hatak. Unduŋ halune metam didimehi’walaŋ kobulabulayedi nu’walaŋkade bulak. ");
INSERT INTO nop_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ale nu fooŋ kawit. Adi biyagoŋ kobulabulaye tobune nu’walaŋkade loguk undugoŋ biyagoŋ hinek be tiiŋ. Wondiniŋ mebi nadihinakadok nadilat.” ");
INSERT INTO nop_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kaŋ meyat lufom adi udaneeŋ Sodom yokwetneŋkade ulune Wapum adi Abalahamdut uŋgoŋ muniniŋ yakuk. ");
INSERT INTO nop_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kaŋ Abalaham adi Wapum’walaŋ hebeŋ ginaŋ wooŋ yale yoguk, “Du biyagoŋ hinek kube meeniŋ kedehi eŋ kadakahi wanakaŋ yehitubuliwedok yolaŋ? ");
INSERT INTO nop_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Yokwet wondiniŋ maaneŋ meeniŋ didimehi 50 nobu hatibune du aditok tiŋa yokwet u kedem mu be bikabeŋale? ");
INSERT INTO nop_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ala unduŋ hinek mu tiluwaaŋ. Du meeniŋ didimehi eŋ hogohi wanaŋ yehitubuliweune didimeniŋ eŋ hogoli adi namandap kubugoŋ tideemekneŋ ale unduŋ mu tibeŋ. Du adi kwet wapum yendiniŋ yodapma hatilaŋdi kwanaige didimeniŋgoŋ tibeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kaŋ Wapumdibo yoguk, “Nu Sodom yokwetneŋ meeniŋ didimehi 50 nobu yabit adi aditok tiŋa noli hogohogok wanaŋ biyabit.” ");
INSERT INTO nop_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kaŋ Abalahamdi niŋa yoguk, “Nu adi kwet munamunam eŋ kwam undiniŋdi fiit gigine tiŋa Wapumne, du mede ganilat. ");
INSERT INTO nop_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Meeniŋ didimehi 50 ganilat ala adi’walaniŋ 5 yolohi nobu tibeŋ unduŋ tiŋa 5 heki doktiŋa yokwet wapum maaŋ be tubuliweweŋ?” Yobune yoguk, “Nu adi 45 yabuŋa yokwet u mu tubukadawit.” ");
INSERT INTO nop_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kaŋ Abalaham adi kotigoŋ tomboyoula indiŋ yoŋa niŋguk, “Be meeniŋ 40 hogok nobu yabeŋ?” Adibo yoguk, “Nu 40 aditok tiŋa mu tibit.” ");
INSERT INTO nop_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kaŋ Abalahamdi yoguk, “Nu mede kotigoŋ tomboyoula yobene Wapumne du nadinambune mu kadakawek. Meeniŋ 30 hogok nobu yabeŋ.” Adibo yoguk, “Nu 30 yabuŋa mu tibit.” ");
INSERT INTO nop_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kaŋ Abalahamdi yoguk, “Nu Wapumne dukut yonadi titindok gigine tiŋat, meeniŋ 20 hogok nobu yabeŋ?” Wapumdi yoguk, “Nu 20 yabuŋa yokwet mu tubuliwewit.” ");
INSERT INTO nop_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kaŋ Abalahamdi yoguk, “O Wapumne, nu nai kubugoŋ hinek tomboyoula yobit doktiŋa mu nadikadakanambeŋ. Meeniŋ 10 hogok nobu yabuŋa dediŋ tibeŋ?” Adibo yoguk, “Nu 10 heki doktiŋa yokwet u mu tubukadawit.” ");
INSERT INTO nop_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Wapum adi Abalahamdut mede unduŋ yodapmaaŋ uguk. Kaŋ Abalaham adi yolide udaneeŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tebele tulune aŋelo yakat adi Sodom yokwetneŋ usuagumuk. Kaŋ Loti adi Sodom yokwet diniŋ gimbisaŋ yeme, bop kwetneŋ ila yabugene pilale wooŋ hebehik foloŋ duwokineeŋ mulelem tiyemiŋa yoguk, ");
INSERT INTO nop_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Bomboŋgineyat, hidi kamiŋ timiŋ tipilapilayehik me nu’walaŋ yopmaŋ looŋ kayohik youtela uŋgoŋ itemek. Ala heleune haloŋ haniŋ talik kotigoŋ tomboyoula udemek.” Adibo yogumuk, “Mooŋ. Indi kamiŋ timiŋ adi fakaŋ yawaliweŋ deitim.” ");
INSERT INTO nop_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Adi unduŋ yobune Lotidi yeniŋgigine tulu tulu fiit yolineŋ logumuk. Kaŋ yoli tiulidokoyemiŋa belet haguwonit mokit heyembuune nagumuk. ");
INSERT INTO nop_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Meyat adi domo mu deitune Sodomhi me wapuhi tiŋa me kuya fee hinekdi buŋa Loti yoli kelemadi yali ");
INSERT INTO nop_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Loti indiŋ kutniŋgiŋ, “Kamiŋ timiŋ meyat du’walaŋ yokeneŋ bumuk adi de? Yanagila foune yehitubukadakanim.” ");
INSERT INTO nop_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kaŋ Loti adi fakaŋ foŋ talik yeme fakaŋkade tehekilitiyemguk. ");
INSERT INTO nop_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Tiŋa yoguk, “Notneye, nemek hogoli undiniŋ mu tineŋ. ");
INSERT INTO nop_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","I nadineŋ, nu’walaŋ wabineyat lufom hatiyamuk adi adi medut mu hatigumuk. Ale nu adi yanagifowene unduŋ be unduŋ tiyemine nadiŋa kedem tiyemineŋ. Kubugoŋ adi meyat lufom adi adi nemek nemu hinek tiyemineŋ. Adi adi agaŋ nu’walaŋ yotneneŋ yanagila yabudokolat.” ");
INSERT INTO nop_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Adibo fafaŋegoŋ toŋa yogiŋ, “Du tabaweŋ!” Toŋa niŋgiŋ, “Du adi indi’walaŋ kwetneŋ buŋambu buŋa hatilaŋdi indi kube ninindidimewene yolaŋ. Indi meyat u nemek tiyemdok yomun u kalakapmeeŋ datok tigamunim ala nadiŋa ha yoluwaaŋ.” Adi unduŋ toŋa Loti kohoŋ foloŋ honeeŋ hamane tikulaŋa yot yeme ubulagine kutnene tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Iŋgoŋ oŋ, meyat lufom yot maaneŋ hakumukdi kohohik kihiwaale Loti hamaneune yot maaneŋ foune talik yeme tehekilitigumuk. ");
INSERT INTO nop_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Unduŋ tiŋa yegumuk e me wapum kuyaniŋ dauhik yehitubusipmakaune talik yeme mu kaŋ lohi tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kaŋ meyat adi Loti indiŋ niŋgumuk, “Nokeye be yapmageye be mihige wabigeye u yenimbune yokwet i bikabuŋa momoneŋ. ");
INSERT INTO nop_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Kaŋ indi yokwet i tubuliwe tidim. Yokwet yendiniŋ kadakaniŋ doktiŋa kobulabulayedi Wapum’walaŋ losuwaguk. Doktiŋa Wapumdi yokwet i tubuliwedok niniŋkulune bumut.” ");
INSERT INTO nop_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kaŋ Loti adi wooŋ wabiŋiŋyat diniŋ me gigit u yemiŋgiŋ adi indiŋ yeniŋguk. “Pilap hinek pilale momoŋ udemek. Wapum adi yokwet i agaŋ tubuliwe tibene tilak.” Meyat adi mede yofiliyaŋ binek tilak yoŋa nadigumuk. ");
INSERT INTO nop_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Hele miiŋ dobulune aŋelo yakatdi Loti gehiŋgehiŋ tomiŋa yogumuk. “Meeniŋ iŋahi’walaŋ kadakaniŋ doktiŋa kumumbaaneŋ ale pilali tamge eŋ wabigeyat i yanagilune momoŋ uneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kaŋ Loti adi nadibediŋa yatulune aŋelo yakat adi Wapumdi Loti hogok kedem hatidok yeniŋguk doktiŋa Loti eŋ tamŋiŋ eŋ wabiŋiyat kohohik foloŋ yehihamaneeŋ fougiŋ wooŋ yotkwet gagayeŋ yapmeeŋ ");
INSERT INTO nop_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","niŋdi indiŋ niŋguk, “Du maaŋ kadakawaaneŋ ale pilap hinek momoŋ weŋ! Ala uŋale uŋale fambakaneeŋ mu diweweŋ, eŋ Yodan gutuneŋ iŋoŋ ikwele mu tibeŋ! Kadakawaaneŋ doktiŋa haŋgi foloŋ momoŋ loweŋ.” ");
INSERT INTO nop_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Iŋgoŋ oŋ, Lotidi indiŋ yeniŋguk, “Bomboŋgineyat, unduŋ mooŋ ale. ");
INSERT INTO nop_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Hidi tipilapilayehik nu siloŋ tobogoŋ tinamuŋa nehitubulodamuk. Nu adi haŋgi foloŋ kedem mu momoŋ lowit. Uŋoŋ mulabumuŋ wondi neheune kumumbaatneŋ. ");
INSERT INTO nop_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nadilaŋ be? Yokwet kuyaniŋ gu itakneŋ, uŋgoŋ nadinambune wooŋ hebihalit.” ");
INSERT INTO nop_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Adibo niŋguk, “Du yolaŋ wondok kedem nadigamulat ale yokwet yolaŋ u mu tubukadawit. ");
INSERT INTO nop_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Du talipmeŋ ulune nemek nemu tibit ale kedem weneŋgeila wooŋ yokwet maaneŋ uhebeŋ.” Unduŋ doktiŋa yokwet wondiniŋ wou Sowa youkiŋ. ");
INSERT INTO nop_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loti adi Sowa yopmaŋ usualune nai uŋaniŋgoŋ mele labusuaguk. ");
INSERT INTO nop_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kaŋ nai uŋaniŋgoŋ Wapumdi yodapmaune Sodom eŋ Gomola kawade mindip kudupnit kwaneune gwi nabugoŋ maaŋ ");
INSERT INTO nop_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","kwet gutuneŋ uŋoŋ yokwet wapmuhi ila ugiŋ eŋ meeniŋ hogohogok eŋ kilihikit be bem yali ugiŋ u wanaŋ daaŋ daliwedapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kaŋ Loti tamŋiŋ adi adi fambakeneŋ diweeŋ hakane nai uŋaniŋgoŋ kawade fafaŋeniŋ yagila feleŋ nabugoŋ tiŋa yakuk. ");
INSERT INTO nop_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kaŋ haniŋ Abalaham adi pilaleŋa wooŋ kwet kwe Wapum hebeŋ ginaŋ yaleŋa mede yonadi tugumukneŋ uŋgoŋ wooŋ yale ");
INSERT INTO nop_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom eŋ Gomola ikumuk kwet gutuŋ uŋandiŋ diweune uune kudige wapum gouyeniŋ hinek loune kaguk. ");
INSERT INTO nop_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Indiŋ kuyoŋ Bepaŋ adi Yodan gutuneŋ yokwet wapuhi ila ugiŋ u ula hegukneŋ Abalahamdok nadisuŋa Loti folofigita wapum ginaŋniŋ nagila kamehebiŋa yokwet hogoli hatiguk u ula heguk. ");
INSERT INTO nop_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti adi Sowa yokwetneŋ hatidok munta tiŋa wabiŋiŋyat yanagila kwet haŋgi foloŋ looŋ kawade mage niŋ ginaŋ itougiŋ. ");
INSERT INTO nop_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Uŋoŋ itouŋale Mokdi deleeŋ Wene u indiŋ niŋguk, “Betnik adi agaŋ me gawadaaŋ hinek. Tiŋa undigoŋ kwet iŋoŋ me nemu hatiiŋ ale me nediyeŋ indigut hatiŋa kwetkwet mediniŋ titiŋ u tinimbaak. ");
INSERT INTO nop_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ale indi betnik niŋgiginedene wain ime naaŋ nadibubuyeeŋ dahatune adut deitim, adi’walaniŋ yalaki mintanimdok.” ");
INSERT INTO nop_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nai uŋaniŋ timiŋ behik wain ime mimbune naaŋ nadibubuyeeŋ dahatune mok adi kabup looŋ beudut deikuk. Ala deila pilali uguk u behikdi kabe nemu nadiguk. ");
INSERT INTO nop_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Heleune Mokdi Wene niŋguk, “Nadilaŋ be nu kwe timiŋ baŋdut deikut. Ale indi kamiŋ timiŋ betnik wain ime mindene naaŋ nadinadi tubufilune dubo looŋ betnikdut deileŋ. Unduŋ tiŋa indi betnik’walaniŋ yalaki yanagitene indi’walaŋ naŋgat dikinik diniŋ youli kaipmuŋ halaak.” ");
INSERT INTO nop_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Unduŋ yoŋa wabiyat adi nai uŋaniŋ behik wain ime mimbune naaŋ nadibubuyeune Wenedibo looŋ beudut deikuk. Ala deila pilali uguk uye beudi kabe nemu nadiguk. ");
INSERT INTO nop_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Unduŋ tiŋa Loti wabiŋiyat adi behikdut deila mihiwele tugumuk. ");
INSERT INTO nop_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ala wabi Mokdi mihiwele tiŋa mihi niŋ nagikuk adi’walaŋ wou Moab youkuk. Adi adi koobuk indinde Moab metam hatiiŋ adi’walaŋ dadahik. ");
INSERT INTO nop_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kaŋke Wenedi undugoŋ mihi niŋ nagikuk. Adi’walaŋ wou Ben-Ami youkuk. Adi adi kobuk indinde Amon metam hatiiŋ adi’walaŋ dadahik. ");
INSERT INTO nop_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Kaŋ Abalaham adi Mamele’walaŋ bem muŋgohom fiye wabiŋa Negeb kwetneŋ Kades eŋ Sulu lekiŋgoŋhik foloŋ Gela yokwet ikukneŋ uŋaŋ hogok buŋambu hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Tiŋa tamŋiŋ Salahdok “witne” yoguk. Kaŋ Gela niŋ mapme Abimelekdi tipilapilaye meŋiŋ niŋ niŋkulune wooŋ Salah nagila adi’walaŋ yolineŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Unduŋ tubune Bepaŋdi domo ginaŋ Abimelek mintamiŋa indiŋ niŋguk, “Du tam u nagilaŋaŋ doktiŋa kumuŋdok gigit tilaŋ. Maŋgoŋde tam woŋ adi me niŋ’walaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek adi tam wondut nemu hatiguk doktiŋa indiŋ yoguk, “Wapum, du mebop didimehi indi nihitubukadakawene be yolaŋ? ");
INSERT INTO nop_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abalaham adi indiŋ naniŋguk, ‘Adi witne’ eŋ tamdi maaŋ yoŋak, ‘Adi witne’. Doktiŋa nu nemek tiŋat wooŋ adi agaŋ walane walaniŋ tiŋat. Eŋ kohone maaŋ walaniŋ.” ");
INSERT INTO nop_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kaŋ Bepaŋdi domo ginaŋ indiŋ niŋguk, “Du nemek u walage walaniŋ halune tiŋaŋ u nu maaŋ nadilat. Ala woŋ adi nugoŋ honewaaŋneŋ yoŋa kamehegamuŋat kaŋ mu kadakaŋaŋ. ");
INSERT INTO nop_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ale indidegoŋ du me u tamuŋiŋ tubuudanemimbeŋ, adi polofet hatilak doktiŋa adi dutok tiŋa ninadi kwanai tibek. Eŋ, du tam u mu tubuudanemimbeŋ adi biyagoŋ hinek da eŋ magemageye hidi adi kumuŋdapmaŋ tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kaŋ Abimelek adi haniŋ hinek pilali kwanai kadoko meŋiye yehibopneeŋ mede u hogohogok yenindapmaune kisaŋ muntagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Unduŋ tiŋa Abimelekdi Abalaham nihamaneŋ indiŋ ninadiguk, “Du maŋgoŋ tinamguŋ? Nu maŋgoŋ kadakaniŋ tigamugut doktiŋa nu eŋ manemaneye indi foloŋ folofigita kamenimiŋaŋ? Du nutok nemek mu titiŋ hinek tinamuguŋ.” ");
INSERT INTO nop_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Tiŋa tomboyoula Abalaham indiŋ ninadiguk, “Du dediŋ nadiŋa unduŋ tinamguŋ?” ");
INSERT INTO nop_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kaŋ Abalahamdibo niŋguk, “Nu indiŋ nadisuŋa nemek u tugut. Me kwet iŋahi adi Bepaŋ gikiŋgoŋ mu timiiŋ. Doktiŋa nu tamne doktiŋa nulukumuneeneŋ. ");
INSERT INTO nop_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tiŋa undigoŋ adi adi biyagoŋku witne, batne’walaŋ wabiŋiŋ. Mane’walaŋ wabiŋiŋ mooŋ. Iŋgoŋ oŋ, adi agaŋ tamne tuguk. ");
INSERT INTO nop_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ala Bepaŋdi nanimbune batne yoli bikabuŋa kwet gitipmuŋ ginaŋ bugut nai uŋaniŋ nu indiŋ niŋgut, ‘Yokwet uŋoŋ be uŋoŋ usuwaaŋ nu nabukahileeŋ indiŋ yoluwaaŋ adi adi witne.’” ");
INSERT INTO nop_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Unduŋ yobune Abimelekdi dompa makau eŋ tipilapilaye metam yanagila wooŋ Abalahamdok boimiŋguk. Tiŋa yeguk e tamuŋiŋ Salah maaŋ tubuudanemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Unduŋ tiŋa Abalaham indiŋ niŋguk, “Nadilaŋ be, kwatne namandake foloŋ yuku hali ulak. Ala da uŋoŋ be uŋoŋ hatibene nadiŋa kedem hatiluwaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Tiŋa Salah maaŋ indiŋ niŋguk, “Nadilaŋ be, magemageyedi nadigambune fowaakneŋ eŋ adi’walaŋ namandahik ginaŋ meekaŋgoŋ hatibaaneŋ yoŋa nu wife siliwa faki wan tausen milat. Kaŋ metamdi nadigambune du yomgenit mokit tilaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Bepaŋ adi Abalaham tamuŋŋiŋ Salah doktiŋa Abimelek’walaŋ yolineŋ tamwoi hatigiŋ hogohogok meeniŋ ulihaka talik kameheyembune kafi tubudapmagiŋ. Unduŋ doktiŋa Abalaham adi Bepaŋ ninadiune Bepaŋdi Abimelek eŋ tamŋiŋ tiŋa adi’walaŋ tipilapilaye tam heki yalakihiye mintadok talik kotigoŋ dilitomyemguk. ");
INSERT INTO nop_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Kaŋ Wapum adi Salah’walaŋkade me nalum wooŋ mede yokiliti timiŋguk undugoŋ tiŋa tubulodaguk. ");
INSERT INTO nop_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kaŋ Abalaham adi agaŋ me gawadaŋ hinek tulune Bepaŋ adi nai niŋguk uŋgoŋ hinek Salah adi mihiwele tiŋa mihi niŋ nagikuk. ");
INSERT INTO nop_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Kaŋ Abalaham adi Salahdi mihi nagikuk adi’walaŋ wou Aisak youkuk. ");
INSERT INTO nop_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Unduŋ tiŋa yeguk e Abalaham adi mihiŋiŋ Aisak mintaaŋ hatune melenai 8 dapmaune Bepaŋdi nindidimeguk unduŋ tiŋa mihiŋiŋ’walaŋ folooŋ diki foloŋ Yudahi’walaŋ fek dobuguk. ");
INSERT INTO nop_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nai uŋaniŋ Abalaham adi agaŋ guletŋiŋ kunakunat 100 tulune mihiŋiŋ Aisak mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nai uŋaniŋ Salah adi indiŋ yoguk, “Bepaŋ adi mihi nagitdok nehetubulodaune walane ginaŋ nadifo wapum tiŋa gegelat. Ala metam hogohogok mede kahat i nadineeŋ adi maaŋ nukut nadifoneem.” ");
INSERT INTO nop_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tiŋa tomboyoula indiŋ yoguk, “Nediyeŋ Abalaham indiŋ nimbe tuguk ‘Salah adi wapmihi nomyout tiyembaak’? Iŋgoŋ oŋ, adi me gawadaaŋ hinek tulune nu mihi nagilimiŋgut.” ");
INSERT INTO nop_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ala Aisak adi agaŋ bedinaditom tuguk. Bedinaditom tiŋa nom wabiguk, melenai uŋgoŋ hinek Abalaham adi nadifo tiŋa muni hinaŋ wapum tuguk. ");
INSERT INTO nop_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Nai uŋaniŋ Ismael dut Aisak adi lopne tugumuk tiŋa Ismaeldi Aisak kisaŋ tilamula kagegeune Salah adi u kaŋ nadiune tuwot mu tuguk. ");
INSERT INTO nop_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Doktiŋa Abalaham indiŋ niŋguk, “Tipilapilaye tam eŋ mihiŋiŋ maaŋ yeniŋkuleŋ. Tipilapilaye tam adi’walaŋ mihi dut nu’walaŋ mihi Aisak adi kougoŋ indi’walaŋ yotkwet be bomboŋnik hogohogok wondok molom mu tideemek.” ");
INSERT INTO nop_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kaŋ Abalaham adi mede i nadiŋa mihiŋiŋ Ismael doktiŋa nadiune tuwot mu tubune welemulap wapum hinek nadiguk. ");
INSERT INTO nop_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Iŋoŋ oŋ Bepaŋ adi Abalaham indiŋ niŋguk, “Du mihi eŋ tipilapilaye tam doktiŋa welemulap kisaŋ mu nadiweŋ. Salahdi mede ube u yolak u kedem nadiweŋ. Ala kougoŋ hatigene Aisak’walaŋ yalakiŋiyedi du’walaŋ woho kame hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kaŋ tipilipilaye tam adi’walaŋ mihi maaŋ du’walaŋ yalaki doktiŋa kahaŋ timimbene adi’walaŋ yalakiŋiye maaŋ mintaulihakaaŋ mebop fee tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kaŋ Abalaham adi haniŋ pilaleŋa nanaŋe dumuŋ eŋ ime ye ime tout kale gitnemdi tigiŋ gineŋ giyemiŋguk, unduŋ tiŋa mihi tiŋalooŋ bobok timiŋa yeniŋkulune ugumuk. Wooŋ Beasiba kwetneŋ kwet fiileŋ uŋoŋ nehi hogok nadifiit tiŋa uŋaŋ bo it uŋaŋ bo it tihatigumuk. ");
INSERT INTO nop_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ala imehik agaŋ dapmaguk, kaŋ Haga adi mihi bem sisip kabe niŋ yakuk wondiniŋ yooŋ ginaŋ uŋgoŋ kameguk. ");
INSERT INTO nop_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Tiŋa ne weneŋgeila uyeŋ ikuk. Ala woŋ adi tebe mihiniŋ fiyagilune wooŋ malak wondok tuwolit. Adi adi indiŋ nadiŋa unduŋ tuguk. “Nu mihi kamadi ilene daune foloŋ mu kumumbek”, yoŋa unduŋ tuguk. Adi kwatnaŋgoŋ kabe unduŋku uyeŋ ilaŋa maat ila kokuk. Kaŋ mihi adi maaŋ maat wapum kokuk. ");
INSERT INTO nop_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kaŋ Bepaŋ adi kunum ginaŋ hatiŋale mihidi maat kobulabulaye hatuguk u nadiguk. Tiŋa Bepaŋ’walaŋ aŋeloŋiŋdi tam u indiŋ kutiniŋguk, “Haga! Du maŋgoŋ tilaŋ? Du munta mu tibeŋ. Mihi adi dahale maat kolune Bepaŋdi nadilak. ");
INSERT INTO nop_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ale du wooŋ tubupilaliŋa kohoŋ foloŋ honeweeŋ. Biyagoŋ hinek, nu tubulodawene adi’walaŋ yalakiŋiye adi meeniŋ bop fee mintaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Unduŋ tiŋa Bepaŋdi Haga’walaŋ dawi tubutombune ime bom niŋ kaguk. Kaŋ wooŋ ime tout kale gitnemdi tigiŋ gineŋ gitokiŋa buŋa mihi u miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Unduŋ tiŋa Bepaŋ adi mihi wondut hatiŋa kadokoune mihi u bediguk. Ismael adi kwet fiileŋ hatiŋa bediŋa kidit molo tuguk. ");
INSERT INTO nop_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ala adi unduŋ tiŋa Palan kwet fiileŋ uŋgoŋ itoulune miiŋdi tamuŋiŋ Isip kwetneniŋ nagilimiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nai uŋaniŋ Abimelekdut memikŋiye’walaŋ talitimeŋ Filiko adi Abalaham indiŋ niŋgumuk, “Bepaŋ adi dukut hatibune nemenemek hogohogok tihatilaŋ. ");
INSERT INTO nop_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Unduŋ doktiŋa du kamiŋ Bepaŋ namanda foloŋ na eŋ wapmihineye eŋ yalakineye yalaŋ niniŋa nilamut mu tuluwaaŋ, wondok mede yofafaŋeweŋ. Eŋ nu menot momooŋ tigamulugut undugoŋ dubo na eŋ kwet iŋoŋ buŋambu buŋa hatilaŋ doktiŋa meeniŋ kwet iŋoŋ hatiyam indi hogohogok menot tinimuluwaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abalahamdibo yoguk, “Nu unduŋ titindok yofafaŋelat.” ");
INSERT INTO nop_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Unduŋ tiŋa Abalahamdibo Abimelek kwanai meŋiyedi ime bom niŋ kaka yolom tigiŋ wondok Abimelekdi tubuudanemindok yeniŋgigine tuguk. ");
INSERT INTO nop_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Iŋgoŋ oŋ Abimelek adi yoguk, “U nediyeŋ tuguk nu mu nadilat. Du kom mu naniŋguŋ, nu kamiŋ kubugoŋ nadilat.” ");
INSERT INTO nop_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kaŋ Abalahamdi kale dompa eŋ makau yanagila buŋa Abimelekdok bopnemiŋguk unduŋ tiŋa meyat lufom adi menot momooŋ hatidok yofolok tugumuk. ");
INSERT INTO nop_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","U tubudapmaaŋ Abalahamdi dompa taamuhi momohi hinek 7 yehidaneeŋ molomgoŋ boiguk. ");
INSERT INTO nop_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kaŋ Abimelekdi yabuŋa indiŋ yonadiguk, “Maŋgoŋde dompa taamuhi momohi 7 daneeŋ bop molomgoŋ boiŋaŋ?” ");
INSERT INTO nop_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Yobune Abalahamdi indiŋ yoguk, “Dompa taamuhi 7 boiŋat yoŋ adi du kedem yabukahileeŋ metam bop ginaŋ ime bom yoŋ adi Abalaham negoŋ hinek weneguk unduŋ yodakaleweŋ.” ");
INSERT INTO nop_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Me wapuhiyat lufom adi unduŋ yoŋa menothik mu wiyatdok yofolok fafaŋeniŋ tugumuk. Unduŋ doktiŋa yokwet wondiniŋ wou Beasiba yogiŋ. ");
INSERT INTO nop_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Beasiba yokwetneŋ mede yofolok tubudapmaŋ Abimelek eŋ Filiko memik heki’walaŋ talitimeŋ adi udaneŋ Filistihi nehi’walaŋ kwehineŋ ugumuk. ");
INSERT INTO nop_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kaŋ Abalaham adi Bepaŋ hatihati fafaŋeniŋ molom adi’walaŋ wou foloŋ bem muŋgohom youli niŋ Beasiba kwetneŋ uŋgoŋ yetiguk. ");
INSERT INTO nop_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Unduŋ tiŋa yeguk e Abalaham adi Filistihi’walaŋ kwehineŋ nai kweheyeniŋ buŋambu itouguk. ");
INSERT INTO nop_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nemenemek hogohogok u dapmaune Bepaŋ adi Abalaham mebiŋiŋ nadidok niŋkamanda tiŋa yoguk, “Abalaham!” Adibo yoguk, “Nu yoŋ eeŋ.” Yobune adibo yoguk, ");
INSERT INTO nop_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","“Du mihige kubugoŋ Aisak walagedi hinek kahilelaŋ, adi kuyoŋ Molia kwetneŋ nagila wooŋ kweboboe niŋ ganindidimewitneŋ uŋoŋ nutok muni henambaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Unduŋ niŋguk kaŋ kwet heleune haniŋ hinek Abalaham adi doŋkiŋiŋ foloŋ kumoise kameeŋ kwanai meŋiyat lufom eŋ mihiŋiŋ Aisak yanagikuk. Tiŋa muni hehendok kudup tuwolit ulitawaaŋ moŋgola pilali Bepaŋdi kwet yenindakalegukneŋkade tububihila ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Uge uge melenai lufomkulitniŋ tubune Bepaŋdi kwet yogukneŋ usuwaaŋ Abalaham adi dadiyeeŋ Bepaŋdi kwet yoguk hinek u kabe kwatnaaŋgoŋ halune kaguk. ");
INSERT INTO nop_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Kaŋ kwanai meyat indiŋ yeniŋguk, “Hidi iŋgoŋ hale donki kadokodemek. Nu ye mihidut gwaŋ wooŋ Bepaŋ niutumbaaŋ ninadi kwanai tiŋa bu habudim.” ");
INSERT INTO nop_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Unduŋ yoŋa Abalaham adi muni hehendok kudup sibi tiŋalooŋ mihiŋiŋ Aisak foloŋ kameguk. Tiŋa ne ye kudupdelet eŋ tahak moŋgokuk. Unduŋ tiŋa noŋgoŋ ugumuk. ");
INSERT INTO nop_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Uŋale uŋale Aisakdi beu Abalaham niŋguk. “Mebaŋ?” Unduŋ yobune beudibo yoguk, “Woe, mihine nu yoŋ.” Aisakdibo yoguk, “Kudupdelet eŋ kaipmuŋ agaŋ moŋgo bamut. Iŋgoŋ oŋ, muni hehendok dompa mihiniŋ diŋak?” ");
INSERT INTO nop_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abalahamdibo yoguk, “Bepaŋ ne kougoŋ dompa muni hehendok niŋ tiulidokonimbek.” Unduŋ yoŋa wanaŋ ugumuk. ");
INSERT INTO nop_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Uyeŋ Bepaŋdi kwet yeniŋgukneŋ uŋgoŋ usuwaaŋ Abalahamdi alata niŋ tutumbaguk. Tubudapmaaŋ kudup alata foloŋ habiyeeŋ mihiŋiŋ Aisak ibidokooŋ tiŋa looŋ alata foloŋ kudup ginaŋ kameguk. ");
INSERT INTO nop_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Unduŋ tiŋa mihiŋiŋ ulene kohoŋ kihiwale tahak honeguk. ");
INSERT INTO nop_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Iŋgoŋ oŋ, Wapum’walaŋ aŋeloŋiŋdi kunum foloŋ hatiŋa indiŋ kutiniŋguk, “Abalaham! Abalaham!” Adibo yoguk, “Nu yoŋ eeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Yobune adibo yoguk, “Du kohoge mihi foloŋ mu kameweŋ. Eŋ nemek nemu timimbeŋ. Nu kamiŋ du’walaŋ mebige agaŋ nadilat. Du biyagoŋ hinek Bepaŋ gikiŋgoŋ timilaŋ. Tiŋa yeŋaŋ e, mihige kubugoŋ hinek e nutok muni henamdok mooŋ yoŋa mu kahileŋaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Unduŋ yobune Abalaham adi fakaleeŋ diweeŋ dompa maaniŋ niŋ keleu ye bem kabe kikiŋnit ginaŋ geyam tiŋa yalune kaguk. Abalaham adi u kaŋ wooŋ dompa maaniŋ u ula buŋa mihiŋiŋdok kibikooŋ dompadi muni heguk. ");
INSERT INTO nop_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Unduŋ doktiŋa Abalahamdi kwet wondiniŋ wou “Wapumdi Tiulidokonimbek” yoguk. Kaŋ nai indidegoŋ adi indiŋ yoiŋ “Wapum’walaŋ tuwai foloŋ tiulidokonimbek.” ");
INSERT INTO nop_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kaŋ Wapum diniŋ aŋelo adi kotigoŋ Abalaham indiŋ kutiniŋguk ");
INSERT INTO nop_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Wapumdi yolak, ‘Nu na’walaŋ wotnane foloŋ yofafaŋelat. Du nemek u tiŋa yeŋaŋ e mihige kubugoŋ hinek nutok muni hehendok mooŋ yoŋa kahile mu tiŋaŋaŋ, ");
INSERT INTO nop_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","doktiŋa kibi nubo kahaŋ wapum hinek tigambaat tiŋa yalakigeye yehitubuulihakawene fee hinek kunum foloŋ hinantalamek ikiiŋ wondok tuwolit be ime luhi magineŋ kiŋ ikiiŋ wondok tuwot ulihakaneeŋ. Unduŋ tiŋa yalakigeyedi memikhiye’walaŋ yohikwehik yolom moŋgotneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Eŋ yalakigeye’walaŋ kahaŋdi kwetkwet metam mohok hatitawiiŋ adi maaŋ yehikahaŋnewaak. Woŋ adi du nu’walaŋ mede tiloloŋ tiŋaŋ doktiŋa folooŋ unduŋ mintawaak.’” ");
INSERT INTO nop_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abalaham yamihiŋit adi unduŋ tihatigane udaneeŋ wooŋ kwanai meŋiyat yabune yohite Beasibade ugiŋ. Wooŋ Abalaham adi Beasiba uŋgoŋ itouluguk. ");
INSERT INTO nop_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mindaŋkade Abalaham adi mede kahat indiŋ nadiguk, “Naho tamuŋiŋ Milika adi maaŋ kwayage Nahodok mihiŋiye yanagikuk.” ");
INSERT INTO nop_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mihiŋiŋ tuwo wou Usi. Eŋ kwayaŋ mona wou Busi, eŋ gik Kemuel (adi adi Alam beu) ");
INSERT INTO nop_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","tiŋa hawa Keset, kasok Haso, kandok Pilidasi eŋ kwayahiyat Yitlap tiŋa Betuel. ");
INSERT INTO nop_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ala Betuel adi adi Lebeka beu. Milika adi Abalaham kwayaŋ Naho adi’walaŋ mihiŋiye 8 yanagikuk. ");
INSERT INTO nop_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Eŋ tamŋiŋ noli Leumadi mihiŋiye 4 yanagikuk. Wohiye indiŋ: Teba, Gaham, Tahas eŋ Maaka. ");
INSERT INTO nop_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Salah adi guletŋiŋ 127 hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Tiŋa Salah adi Kanaaŋ kwetneŋ Kiliat Aba yokwet wou noli Hebulon yoyagiŋ uŋgoŋ hinek hatiŋa kumuŋguk. Kumumbune Abalaham adi bulaaniŋgoŋ nadiŋa makunum tibene haule yot Salah’walaŋ dabaŋ hakukneŋ foguk. ");
INSERT INTO nop_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Makat kobulabuye tubudapmaaŋ fooŋ uguk. Wooŋ Hitaithi metam indiŋ yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nu adi hidi’walaŋ kwetneŋ iŋoŋ buŋa hogok eŋ buŋambu hatilat doktiŋa hidi kwet niŋ nambune tuwaaŋ dabaŋne tiŋa wooŋ wenefulawit.” ");
INSERT INTO nop_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kaŋ Hitaithi metam adi Abalaham indiŋ niŋgiŋ, ");
INSERT INTO nop_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Me wapum, i nadiweŋ. Du adi kwet iŋoŋ Bepaŋ’walaŋ me loloŋnit hatilaŋ doktiŋa indi’walaŋ kwetneŋ iŋoŋ me weneŋ kwet momooŋ tutumbaŋit ginaŋ hinek dabaŋge kedem wenefulaweŋ. Indi dutok kwet kamehep mu tigamunim.” ");
INSERT INTO nop_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Unduŋ yobune Abalaham adi pilaleŋa Hitaithi metam mulelem tiŋa duwokine tiyemuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Unduŋ tiyemiŋa indiŋ yeniŋguk, “Hidi dabaŋne kwet iŋoŋ wenefuladok nadiiŋ doktiŋa hanindakalewene nadineŋ. Hidi kedem be nehitubulodaaŋ Efelon, Soha mihiŋiŋ nimbune ");
INSERT INTO nop_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","adi kwetŋiŋ dikineŋ kawade mage wamutom tigiŋ, wou Makpela yoiŋ, tuwaŋiŋ wondok tuwolit dedigoŋdok hinek u kedem namandahik foloŋ nanimbune tuwaaŋ dabaŋne wenewit.” ");
INSERT INTO nop_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kaŋ Efelon adi adi uŋgoŋ yolineŋ Hitaithi metam feedi buŋa bop wapum tiŋa ikiŋneŋ uŋgoŋ ikuk ala mede u nadiŋa pilaleŋa Hitaithi metam namandahik ginaŋ yaleŋa Abalaham indiŋ yoŋa niŋguk, ");
INSERT INTO nop_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Me Wapum, unduŋ mooŋ ale. Yobe nadiweŋ. Biyagoŋ kuyoŋ, notneye hogohogok wanaŋ ila nadilune hewehewe u hogok gamulat eŋ hewehewe ginaŋ kawade mage hatak u maaŋ ganindapmalat ale dabaŋge kedem wenefulaweŋ.” ");
INSERT INTO nop_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abalaham adi kotigoŋ metam kwehiwahi duwokeneyemiŋa ");
INSERT INTO nop_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Efelon indiŋ nimbune wanakaŋ nadigiŋ, “U kedem yolaŋ ala kedem be nadinambeŋ? Nu kwetdok tuwaŋiŋ gambene fiit moŋgoleŋ kaŋ nu dabaŋne wenefulawit.” ");
INSERT INTO nop_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Unduŋ yobune Efelondi Abalaham indiŋ niŋguk, ");
INSERT INTO nop_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Me Wapum ganimbe nadiweŋ. Kwet faki kabeniŋdok tuwaŋiŋ siliwa muneeŋ 400dok tuwolit tilak iŋgoŋ wondok male yagigi yodim. Du fiit dabaŋge kedem wenefulaweŋ.” ");
INSERT INTO nop_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Biyagoŋ kuyoŋ, Abalaham adi adi tuwaŋiŋ diniŋ tuwolit u nadiune tuwot tubune nemek mulabuhi boikaboika tiiŋ foloŋ boikaaŋ, nai uŋaniŋ bomboŋ kibikibi titiŋ diniŋ mede yofafaŋe hakuk wondok tuwolit takaliŋa muneeŋ silwa 400 miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Abalaham adi unduŋ tubune Efelon’walaŋ hewehewe Mamele yokwet mele labulabuneŋkade Makpela gutuneŋ hakuk eŋ kawade mage eŋ bem heki uŋaŋ yakiŋ hogohogok u ");
INSERT INTO nop_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hitaithi metam eŋ me nalum bugiŋ wanaŋ yali kalune Abalahamdok gigit tubudapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Biyagoŋ kuyoŋ, Abalaham adi tamuŋiŋ Salah dabaŋ u Makpela hewehewe ginaŋ kawade mage ginaŋneŋ wenefulaguk. Makpela hewehewe adi Mamele yokwet wou noli Hebulon yogiŋ woŋ adi guŋandiŋ Kanaaŋ kwetneŋ hakuk. ");
INSERT INTO nop_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Unduŋ tubune Hitaithi metam adi hewehewe eŋ kawade mage u wanaŋ Abalahamdok bikabumimbune adi’walaŋ me weneŋ kwet tuguk. ");
INSERT INTO nop_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abalaham adi gulet fee hatiŋa me gawadaaŋ hinek tuguk. Kaŋ Wapum adi taali mebimebi ginaŋ kahaŋ fee timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Biyagoŋ kuyoŋ, unduŋ tubune Abalahamdi kwanai meŋiye’walaŋ talitimeŋhik yot be kale bomboŋ eŋ nemenemek hogohogok diniŋ kadoko hatiguk, u indiŋ niŋguk, “Du kohoge baane falipmeŋ kameeŋ ");
INSERT INTO nop_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Wapum kunum eŋ kwet adi’walaŋ Bepaŋ namanda foloŋ indiŋdok yofafaŋeweŋ. Nu Kanaaŋhi’walaŋ lekiŋgoŋ ginaŋ hatilat adi’walaŋ wabi niŋ nagila mihine mu mimbaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mooŋ, du mihinedok tam tubumintawe nadiŋa na’walaŋ mintaminta kwetneŋ eŋ na’walaŋ naŋgat dikineye hatiineŋ wooŋ adi’walaniŋ tam niŋ nagila buune mihine Aisakdi tamuŋiŋ nagilaak.” ");
INSERT INTO nop_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kwanai medibo ninadiguk, “Tam wondi nukut kwet iŋoŋ mu bubundok yobune dediŋ tibaat? Mihige kedem be da’walaŋ yoke mebineŋ nagila waat?” ");
INSERT INTO nop_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Unduŋ yobune Abalahamdibo yoguk, “Mooŋ hinek yolat. Du mihine kwet uŋoŋ mu nagila waaŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Wapum, kunum diniŋ Bepaŋ, adi kuyeŋ batne’walaŋ kwet eŋ yokwet mebi bikabudok naniŋa nanagilune kwet iŋoŋ bugut. Adi mede yokwambunda hinek tiŋa naniŋguk. Biyagoŋ kuyoŋ, kwet yoŋ adi yalakigeye yembaat. Biyagoŋ kuyoŋ, Wapum adigoŋ mihinedok tam kwet uŋaniŋ tubumintadok aŋeloŋiŋ niŋkulune talitimeŋ tiŋa ganagila waak. ");
INSERT INTO nop_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kaŋ tam adi gahakaliŋa bubundok lakata tubune mede yofolokgedi folooŋnit mokit tibaak. Eŋ mihine adi fiit uŋoŋ mu nagila waaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Unduŋ yobune kwanai medi kohoŋ Abalaham baaŋ hapmeneŋ kameeŋ yokwambundaguk. ");
INSERT INTO nop_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Unduŋ tiŋa yeguk e bomboŋgiŋiŋ’walaŋ kamele 10 yeheŋeguk eŋ bomboŋ mohok moŋgokuk noli tuwahik loloŋnit moŋgola tiulidokooŋ Alam Nahalaimde uguk. Uge uge yokwet wapum Naho uŋgoŋ usuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Usuwaaŋ kale kamele heki ime bom niŋ mebiyeŋ yokwet wapum gagayeŋ uŋgoŋ yameune lemila fooŋ ikiŋ. Ala woŋ adi tebele tamwoidi ime gigit yawagiŋ nai ginaŋ usawaaŋ yakiŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Uŋgoŋ yaliŋa ninadi indiŋ tuguk, “O Wapum, bomboŋgine Abalaham’walaŋ Bepaŋ, du talik bulat yendiniŋ folooŋ bomboŋgine Abalaham siloŋ timimbeŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ala nu yek ime mebiyeŋ iŋgoŋ yatuwene metam yohiwahi’walaŋ wabihiyedi ime gitnene buneŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kaŋ nu wabihem niŋ ime toutge nambune ime nawit unduŋ nimbene nadiŋa adibo yobek, ‘Naweŋ kaŋ kamelegeye maaŋ ime yembene naneŋ.’ Unduŋ yobek kaŋ nu indiŋ nadiwit, ‘Biyagoŋ kuyoŋ, wabihem yoŋ e tipilapilaye mege Aisakdok tiulidokoguŋ.’ Unduŋ nadiwit. Eŋ du bomboŋginedok siloŋ tobogoŋ timilaŋ u maaŋ nadiwit.” ");
INSERT INTO nop_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ninadi u mu tubudapmalune Lebeka adi ime toutŋiŋ beemiŋa buguk. Lebeka adi adi Betuel wabiŋiŋ eŋ adi adi Milka diniŋ mihiŋiŋ, Abalaham kwayaŋ Naho’walaŋ tamuŋiŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Wabi woŋ adi folonamandapŋiŋ momooŋ hinek. Me niŋdut hatififile mu tuguk. Adi adi miiŋbeudut gitagoŋ hatiguk. Wabi adi fooŋ imeŋiŋ tout ginaŋ ime gila kotigoŋ labuguk. ");
INSERT INTO nop_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Labulune kwanai me adi pilap wooŋ niŋguk, “Imege tout nambeŋ kaŋ imekabe neeŋ nawit.” ");
INSERT INTO nop_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Unduŋ nimbune wabidibo yoguk, “Wapumne, kedem naweŋ” yoŋa ime tout tiŋafooŋ kohoŋ foloŋ honeeŋ mimbune naguk. ");
INSERT INTO nop_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Wabi adi kwanai me ime mimbune naaŋ natoki tuguk kaŋ yoguk, “Kamelegeyedok maaŋ ime giyembene natoki tineŋ.” ");
INSERT INTO nop_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Yoŋa ime diki muwage maliŋ ginaŋ kwatnedapmaaŋ ime kotigoŋ gilene ime foloŋ foguk. Unduŋ tubune kamele hogohogok wanaŋ ime nadapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kaŋ kwanaime adi mede kabup yale nemek mintaguk u kanadi tuguk tiŋa nadiune uŋgoniŋ hinek tuguk. Tiŋa indiŋ nadisuguk, “Wapum adi kwanaine kahaŋnenambek be mooŋ u nadidakalewit.” ");
INSERT INTO nop_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamele heki ime naaŋ natoki tubune me wondi timembem goldi tutumbagiŋ niŋ eŋ haluntuk maaŋ goldi tutumbagiŋ lufomnikoŋ tuwahik wapum loloŋnit hinek u dihiŋa miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Tiŋa yoguk, “Du nedi’walaŋ wabi u nanimbeŋ. Eŋ indi baha’walaŋ yopmaŋ kedem be deitnim?” ");
INSERT INTO nop_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Adibo yoguk, “Nu Betuel wabiŋiŋ. Betuel adi adi Milka eŋ Naho’walaŋ mihihik.” ");
INSERT INTO nop_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Unduŋ yoŋa tomboyoula indiŋ yoguk, “Kamele heki’walaŋ kilihikit eŋ nanaŋe fee itnimiiŋ eŋ hidi deitdok yot maaŋ baŋam tuwot hatak.” ");
INSERT INTO nop_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kaŋ me adi duwokeneeŋ Wapum niutumbaaŋ indiŋ ninadiguk, ");
INSERT INTO nop_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Biyagoŋ kuyoŋ, bomboŋgine Abalaham adi’walaŋ Wapum Bepaŋ adi welekwelemanit hatiŋa mede yofolokŋiŋ diniŋ folooŋ bomboŋgine kamehep mu timiŋguk doktiŋa nintilooŋ niutumbadok. Wapum adi didimeniŋgoŋ hinek nanindidimeŋ nanagilune buge buge bomboŋgine’walaŋ naŋgat diki’walaŋ yohineŋ busuwaŋat.” ");
INSERT INTO nop_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kaŋ wabi adi weneŋgeila wooŋ miiŋ’walaŋ yolineŋ usuwaaŋ nemek hogohogok mintaguk wondok mede kahat timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Kaŋ Lebeka’walaŋ wiwi niŋ hatiguk wou Labandibo me ime foloŋ yakuk kawene weneŋgeila uguk. ");
INSERT INTO nop_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Woŋ adi indiŋ. Laban adi wiwi’walaŋ timembem eŋ haluntuk goldi tutumbaŋit u yabuguk eŋ medi mede yoguk u wiwidi kahat tuguk u nadiŋa uŋaniŋgoŋ uguk. Me nalum adi adi kameleŋiyedut ime gagayeŋ uŋgoŋ yatune wooŋ kaguk. ");
INSERT INTO nop_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kaŋ niŋguk, “Wapumdi gehikahaŋneguk du kedem beŋ. Iŋoŋ maŋgoŋde yataŋ? Nu yot agaŋ tiulidokoŋat eŋ kamele hekidi ipilat titindok kwet maaŋ kedem hatak.” ");
INSERT INTO nop_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Yobune yopmande looŋ me adi kamele heki foloŋ ise heki fiyakuyemulune kamele heki’walaŋ ise eŋ nanaŋehik moŋgola buŋa boiyemiŋgiŋ. Tiŋa mewoi adut ugiŋ adi kayohik youtetdok ime maaŋ gila boiyemiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","U tubudapmaaŋ mindaŋ nanaŋe boigiŋ. Iŋgoŋ e adi indiŋ yoguk, “Nu nanaŋe pilap mu nawit. Timeŋ adi welene ginaŋ mede hatak u hanimbene nadineŋ kaŋ nawit.” Yobune Labandi yoguk, “Unda kedem ale yobune nadinim.” ");
INSERT INTO nop_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kaŋ yoguk, “Nu adi Abalaham’walaŋ tipilapilaye me. ");
INSERT INTO nop_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Wapumdi bomboŋgine kahaŋ timiŋguk kaŋ nai indinde adi adi me loloŋnit tuguk. Nemek indiŋ kale mebimebi, makau, silwa eŋ gol, tipilapilaye me eŋ tipilapilaye tam, kamele eŋ doŋki kisaŋ mintoi tuguk. ");
INSERT INTO nop_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Agaŋ bomboŋgine tamuŋiŋ adi tam gawadaaŋ tuguk iŋgoŋ fiit bombogine’walaŋ mihi niŋ nagikuk. Kaŋ Abalaham adi nemenemekŋiŋ hogohogok u aditok mindapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tiŋa nu mede yofafaŋeŋiŋ indiŋ u folooŋ hinek titindok nanifafaŋeguk. ‘Du adi Kanaaŋhi me kwehineŋ hatilat wabihiye adi’walaniŋ mihinedok tamuŋiŋ mu nagilaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Adi baatne’walaŋ yolikwelineŋ eŋ naŋgat dikineye adi’walaniŋ mihinedok tam niŋ tubumintawaaŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Kaŋ nu bomboŋgine indiŋ ninadigut, ‘Tam u nukut mu bubundok yobune dediŋ tibaat.’ ");
INSERT INTO nop_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Kaŋ kibi indiŋ naniŋguk, ‘Nu Wapum namanda foloŋ hatilat adi aŋeloŋiŋ niŋkulune dukut hatiŋa gehitubulodaune naŋgat dikineye eŋ batne’walaŋ yolineŋ mihinedok tamuŋiŋ niŋ kedem tubumintawaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Du unduŋ tibaaŋ kaŋ mede yofolok diniŋ folooŋ mintaune tuwot tibaak. Be naŋgat dikineye’walaŋ usuaune tam mu gamdok yobune yofolokge folooŋnit mokit tubune nadibedi mu tibaaŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ala nu kamiŋ ime gitnaŋ tiineŋ busuwaaŋ indiŋ yoŋat, ‘O Wapum, bomboŋgine Abalaham’walaŋ Bepaŋ, du kwanai tibe bulat u nehitubulodaweŋ kaŋ folooŋ mintawekdok ganilat. ");
INSERT INTO nop_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nu ime gagayeŋ yuku yalit ala wabihem niŋ ime gile bek kaŋ nimbit, “Ime toutge nambeŋ kaŋ imekabe neeŋ nawit.” ");
INSERT INTO nop_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Nu unduŋ nimbene kibikooŋ indiŋ udaneŋ nanimbek, “Naweŋ kaŋ kamelegeye maaŋ giyembe naneŋ.” Biyagoŋ kuyoŋ, unduŋ yobek kaŋ aditegoŋ yobit Wapumdi bombooŋgine mihiŋiŋdok tam tiulidokoŋak iŋaakoŋ.’” ");
INSERT INTO nop_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Nu walane ginaŋ unduŋ nadisudapmaaŋ yatuwene Lebeka adi ime gilene ime tout beemiŋa ime foloŋ wooŋ ime gilaŋak. Kaŋ nu indiŋ niŋat, ‘Ime nambune nawit.’ ");
INSERT INTO nop_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Unduŋ yobene uŋaniŋgoŋ adibo ime tout honeeŋ yoŋak ‘Tiŋa na! Kaŋ kamelegeye maaŋ giyembene naneŋ.’ Unduŋ yobune naŋat kaŋ adi kamele ime yemiŋak. ");
INSERT INTO nop_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Dapmaune ninadiŋat, ‘Du nedi’walaŋ wabiŋiŋ?’ Adibo yoŋak, ‘Nu Betuel wabiŋiŋ eŋ adi adi Naho eŋ Milka’walaŋ mihihik.’ Unduŋ nanimbune timembem timei foloŋ kameŋat eŋ haluntuk kohoŋ foloŋ dahimiŋat. ");
INSERT INTO nop_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Biyagoŋ kuyoŋ, unduŋ tiŋa Wapum bomboŋgine’walaŋ Bepaŋ duwokenemiŋa ninadiŋa niutumbaŋat. Biyagoŋ kuyoŋ, adigoŋ hinek bomboŋgine’walaŋ kwayaŋ diniŋ laaŋ, Abalaham’walaŋ mihiŋidok tam nagitdok talik didimeniŋ hinek nanagila buguk. ");
INSERT INTO nop_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Agaŋ hidibo nanineŋ. Hidi bomboŋgine wele kwelema timiŋa wele nadifo tubumintamineŋ, be dediŋ? Mooŋ kaŋ u maaŋ nanineŋ kaŋ nu talii nolibo keleŋ kawit.” ");
INSERT INTO nop_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Unduŋ yobune Laban eŋ Betuel adi indiŋ niŋgumuk, “Nemek yoŋ adi Wapum’walaniŋ doktiŋa indi mede unduŋ be unduŋ kedem be kadakaniŋ u tuwot mu yodim. ");
INSERT INTO nop_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebeka adi agaŋ du’walaŋ habake ginaŋ yatak. Ale kedem nagila uune bomboŋgige’walaŋ mihiŋiŋdi tamuŋiŋ nagilaak. Kaŋ Wapumdi yodakaleguk wondok tuwot hinek tibaak.” ");
INSERT INTO nop_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abalaham tipilapilaye meŋiŋ adi mede u nadiŋa Wapum duwokenemiŋa namanda tubuwopmobuŋa nintiloguk. ");
INSERT INTO nop_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tiŋa pilaliŋa bomboŋ eŋ nemenemek silwa be goldi tutumbagiŋ eŋ houle dahidahi heki u dihiŋa Lebekadok miŋguk eŋ nemek noli tuwahik loloŋnit u wiwi eŋ miiŋdok siloŋ tiyemguk. ");
INSERT INTO nop_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Unduŋ tiŋa ne eŋ mewoi adut bugiŋ adi nanaŋe ime nagiŋ. Nadapmaaŋ timiŋ kubugoŋ uŋgoŋ deikiŋ. Haniŋ pilali yoguk, “Agaŋ naniŋkulune talipmeŋ tabe bomboŋgine kawene maawit.” ");
INSERT INTO nop_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Iŋgoŋ e wiwi eŋ miiŋ adibo yogumuk, “Wabi ye iŋgoŋ muniniŋ melenai 10 be yali kedem nipmeeŋ uneeŋ?” ");
INSERT INTO nop_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kaŋ tipilapilayedibo yeniŋguk, “Hidi mu nihitubukibidaneŋ. Wapumdi nemek nadiŋa bugut agaŋ nehitubulodaŋak ale naniŋkulune talipmeŋ tabe bomboŋgine kawene mawit.” ");
INSERT INTO nop_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kaŋ miiŋ wiwidibo yogumuk, “Unduŋ ale wabi nebo kutinine buŋa debek yobu kanim.” ");
INSERT INTO nop_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Yoŋa Lebeka kutnimbune buune ninadigiŋ, “Du me yendut weŋ be?” Kaŋ adibo yoguk, “Nu agaŋ wit.” ");
INSERT INTO nop_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Unduŋ yobune adi wiwihik Lebeka kameune uguk. Meeniŋ indiŋdi adut ugiŋ Lebeka’walaŋ tipilipilaye wabi, agaŋ Abalaham’walaŋ tipilapilaye me eŋ mewoi adut ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kaŋ Lebeka meŋimeŋiye adi Lebeka yokahaŋ timiŋa indiŋ niŋgiŋ, “O witnik, du kedem ulihakawaaŋ tiŋa meeniŋ tausen tausen adi’walaŋ meehik tibaaŋ. Eŋ, yalakigeye adi memikhiye dut mindobuŋa yohik kwehik yolom moŋgotneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Unduŋ tiŋa Lebeka eŋ tipilapilayeŋiye adi agaŋ tiulidokooŋ kamelehik foloŋ looŋ Abalaham’walaŋ kwanai me dut ugiŋ. Kwanai me adi Lebeka nagila yokwet bikabuŋa ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisak adi nai uŋaniŋ ime niŋ wou Bea Lahai Loi indi’walaŋ mede foloŋ “Hatihati molomdi hati nabulak,” ime wondiniŋ dawineŋ ugukdi ha buguk ala adi adi Negep uŋoŋ itouluguk. ");
INSERT INTO nop_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ala tebele hogok talik yauhauhaule tibene uguk. Wooŋ dadiyeeŋ kamele heki buune yabuguk. ");
INSERT INTO nop_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Lebekadi maaŋ dadiyeeŋ diweeŋ Aisak kaguk. Kaŋ kamele bikabuŋa tatakula foguk. ");
INSERT INTO nop_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Tiŋa tipilapilaye me ninadiguk. “Hewehewe ginaŋ gu nedigoŋ medi indi nibe bulak.” Yobune tipilapilaye medi yoguk, “Woŋ adi bomboŋgine.” Unduŋ yobune Lebeka adi nehi’walaŋ titiŋ unduŋ houle yaŋamuŋdi tiŋa looŋ namada kufulaguk. ");
INSERT INTO nop_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kaŋ tipilapilaye me adi nemenemek tuguk wondiniŋ mede kahat u Aisak timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Kaŋ Aisak adi Lebeka miiŋ Salah’walaŋ houle yotneŋ nagila looŋ tamŋiŋ nagila kahileeŋ not timiŋguk. Unduŋ tiŋa weleŋ kwelemaune miindok bulaniŋgoŋ nadi hatiguk u wabiguk. ");
INSERT INTO nop_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abalaham adi hatigane kotigoŋ tam niŋ nagikuk, wou Ketula. ");
INSERT INTO nop_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kaŋ adi mihiŋiye indiŋ yanagikuk: Simlan, Yoksan, Medan, Midian, Isbak eŋ Sua. ");
INSERT INTO nop_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan’walaŋ mihiŋiyat indiŋ mintamiŋgumuk: Seba eŋ Dedaŋ. Kaŋ Dedaŋ’walaŋ mihiye adi indiŋ mintagiŋ: Asulim, Letusim eŋ Leunim. ");
INSERT INTO nop_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian mihiŋiye adi indiŋ mintagiŋ: Efa, Efel, Hanok, Abida, eŋ Elda. Meeniŋ hogohogok yoŋ adi Ketula’walaŋ yalakiŋiye. ");
INSERT INTO nop_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abalaham adi muneeŋ bomboŋ eŋ nemenemek hogohogok halimguk u agaŋ mihiŋiŋ Aisakdok mindapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Iŋgoŋ oŋ adi kaipmuŋ hatiŋale tamuŋiye noli’walaŋ mihiwoi adi adi hogok siloŋ tiyemiŋa yeniŋkulune Aisak bikabuŋa kwet mele labulabuneŋkade wooŋ itowagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abalaham adi guletŋiŋ 175 hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Adi adi hatige hatige me gawadaaŋ hinek tiŋa nadifonit kumuŋguk. Kumuŋa mamaŋpapaŋiye kumuŋgiŋ adut tomboyoukuk. ");
INSERT INTO nop_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kumumbune mihiŋiyat Aisakdut Ismael adi Makpela kawade mage ginaŋ wenefalagumuk. Kawade mage woŋ adi Mamele gagayeŋ Efelon, Soha Hitait niŋ mihiŋiŋ’walaŋ hewehewe ginaŋ hakuk. ");
INSERT INTO nop_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Biyagoŋ kuyoŋ, hewehewe woŋ e Abalahamdi Hitaithi’walaŋ tuwaguk. Uŋgoŋ Abalaham eŋ taamuŋiŋ Salah yehiwenegiŋ. ");
INSERT INTO nop_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abalaham kumumbune mindaŋkade Bepaŋdi mihiŋiŋ Aisak kahaŋ timiŋguk. Aisak adi adi ime niŋ wou Bea Lahai Loi uŋaŋ itouluguk. ");
INSERT INTO nop_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Yoŋ adi Ismael Abalaham mihiŋiŋ Salah’walaŋ tipilapilaye tam Haga Isip niŋdi Abalahamdok nagikuk adi’walaŋ mede kahat. ");
INSERT INTO nop_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael mihiŋiye mintagiŋ indigoŋ tuwot habiyeŋ youkiŋ. Mihiŋiŋ tuwo wou Nebayot, agaŋ Kedal, Adibel, Mibsam ");
INSERT INTO nop_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","eŋ Misima, Duma, eŋ Masa, ");
INSERT INTO nop_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad eŋ Tema, Yetul, Napis eŋ Kedema. ");
INSERT INTO nop_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Biyagoŋ kuyoŋ, meheki u Ismael’walaŋ mihiŋiye ala wouhiye adi yohikwehik eŋ houle yothik itougiŋ wondok tuwolit yoyagiŋ. Adi meeniŋ bop hatitaugiŋ indigoŋ mapmehiye 12 hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Eŋ Ismael naiŋiŋ diniŋ mebi adi indiŋ. Adi adi hatige hatige guletŋiŋ 137 tubune kumuŋa mamaŋpapaŋiye kumuŋgiŋdut tomboyoukuk. ");
INSERT INTO nop_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Adi’walaŋ yalakiŋiye adi Hawil eŋ Sulu lekiŋgoŋhik ginaŋ eŋ Isip kwet gagayeŋ ala Asiliya kwetneŋ weene uŋgoŋ uundok biyagoŋ kuyoŋ, naŋgat dikihiye adi’walaŋ kwet gagayeŋ hatiyagiŋ. Iŋgoŋ menot momooŋgoŋ mu tiyagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Yoŋ adi Abalaham’walaŋ mihiŋiŋ Aisak’walaŋ mede kahat. ");
INSERT INTO nop_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisak adi guletŋiŋ 40 tubune tamuŋiŋ Lebeka nagikuk. Lebeka adi Betuel wabiŋiŋ. Betuel adi adi Alam niŋ me eŋ Padan Alam kwetneniŋ. Lebeka wiwi adi Laban. Adi adi me Alamniŋ. ");
INSERT INTO nop_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisak tamuŋiŋ Lebeka adi kafi hatiguk doktiŋa Aisak adi tamŋiŋ tubulodaaŋ Bepaŋ ninadi tuguk. Kaŋ Wapum adi ninadiŋiŋ nadiguk, kaŋ tamuŋiŋ Lebeka adi mihiwele tuguk. ");
INSERT INTO nop_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kaŋ ŋakŋak lufom adi meehik weleŋ ginaŋ hali kipaŋkipaŋ tubune nadiŋa indiŋ yoguk, “U maŋgoŋde unduŋ mintanamulak?” Unduŋ yoŋa Wapum ninadiguk, ");
INSERT INTO nop_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","kaŋ Wapumdibo niŋguk, “Meeniŋ bop wapum lufom du’walaŋ walage maaneŋ hakamuk. Ala meeniŋ bop lufom du’walaŋ maaneŋ hakamuk woŋ adi kougoŋ yehidane titindok. Mebop niŋdi bop niŋ yalakapmeeŋ loloŋnit tineeŋ. Eŋ, biyeniŋdi kwayaŋ tipilpilaye timimbaak.” ");
INSERT INTO nop_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Wapmihi yanagi yanagit nai ginaŋ weleŋ ginaŋneŋ mihi katap yakat hakumuk. ");
INSERT INTO nop_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mihi tuwo adi folooŋ giminiŋ eŋ dahidahi dumuniŋnit undiniŋ mintaguk, doktiŋa wou Esau youkiŋ. ");
INSERT INTO nop_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kaŋ kwayaŋ mintaguk, adi adi kohoŋdi Esau’walaŋ kayoŋ yahihiliŋiŋ foloŋ honeŋ hakuk doktiŋa wou Yakobo youkiŋ. Aisak adi guletŋiŋ 60 tulune Lebekadi mihiŋiyat yanagikuk. ");
INSERT INTO nop_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kaŋ mihiyat adi hatigane bediŋa Esau adi kidit molo tiŋa kale behepneŋ yauyau diniŋ mebi mohinek nadiguk. Unduŋ tiŋa behepneŋ kaka yauluguk. Yakobo adi me kwelemaaŋ ala yopmaŋgoŋ hatiluguk ");
INSERT INTO nop_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisak adi behepneŋ kaledok nadigalika tuluguk doktiŋa weleŋdi Esau kahile tuluguk. Eŋ Lebeka adi Yakobo weleŋdi kahile hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Heleŋniŋ Yakobo adi hinaŋ hatiguk. Kaŋ Esau adi behepneŋ yauge yauge map kisaŋ nadiŋa busuwaaŋ gweheye tiŋa ");
INSERT INTO nop_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yakobo indiŋ niŋguk, “Nemek giminiŋ i neeŋ pilap nambune nawe. Nu map kisaŋ hinek nadilat.” Unduŋ doktiŋa wou niŋ Edom yogiŋ. ");
INSERT INTO nop_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kaŋ Yakobodibo yoguk, “Mihi tuwo diniŋ kahaŋ u nutok nambeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yobune Esaudibo mede indiŋ tubuudanemiŋguk, “Yakalaŋ! Yoŋ adi map kisaŋ nadiŋa agaŋ kumuŋ tibe tilat. Mihi tuwo diniŋ kahaŋdi maŋgoŋ momooŋ tinambaak? ");
INSERT INTO nop_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iŋgoŋ oŋ Yakobodi yoguk, “Timeŋ yofolok hinek tinambune gabuŋa.” Yobune agaŋ Esaudi Mihi tuwo diniŋ kahaŋ u Yakobodok titindok yofolok fafaŋeniŋ tiŋa Yakobodi nemek giminiŋ heguk wondok tuwaŋiŋ miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Kaŋ Yakobo adi Esau belet eŋ kahak giminiŋ heguk u mimbune naguk. Nadapmaaŋ pilale uguk. Esau adi unduŋ tiŋa mihi tuwo diniŋ kahaŋ u sigilulum tuguk. ");
INSERT INTO nop_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Hatigane kwet uŋaŋ map wapum kotigoŋ mintaguk. Kom Abalaham hatigukneŋ niŋ mintaguk. Yoŋ adi niŋ. Unduŋ doktiŋa Aisak adi Filistiahi’walaŋ mapme wou Abimelek, Gela yokwetneŋ ituguk adi’walaŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kaŋele Wapumdi mintamiŋa yoguk, “Du Isip kwetneŋ mu uluwaaŋ. Kwet niŋ nu ganindidimewitneŋ uŋaŋ wooŋ hatibaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kwet uŋoŋ buŋambu hatilune nu dukut hatiŋa kahaŋ tigambaat. Biyagoŋ kuyoŋ, kwet u hogohogok adi du eŋ yalakigeye hambaat. Unduŋ tibene baha Abalaham mede yofolok fafaŋeniŋ timiŋgut u folooŋnit tibaak. ");
INSERT INTO nop_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Tiŋa yalakigeye yehikahaŋnewene mintaulihaka tubune kunakunathik kunum foloŋ hinantalamek ilawiiŋ wondok tuwolit tibaak. Eŋ yalakigeye’walaŋ kahaŋdi meeniŋ kwetkwet tuwot tokiyembaak. Yalakigeye’walaŋ kahaŋdi kwetkwet metam mohok hatitawiiŋ adi maaŋ yehikahaŋnewaak. ");
INSERT INTO nop_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Woŋ adi Abalahamdi mede tiloloŋ tinamuguk eŋ yodakalene didimeniŋgoŋ takaliguk, eŋ yofafaŋene eŋ mede yodapmaŋne eŋ yodokone wanakaŋ hogohogok nadiŋa yahakeleguk doktiŋa unduŋ tibaat.” ");
INSERT INTO nop_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Unduŋ doktiŋa Aisak adi Gela uŋoŋ itouguk. ");
INSERT INTO nop_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kaŋ me yokwet uŋahidi tamŋiŋdok ninadigiŋ kaŋ adibo yoguk, “Tam woŋ adi witne.” Lebeka adi folonamandapŋiŋ momooŋ hinek doktiŋa adi tamune yodok munta tuguk. Unduŋ yobene me iŋahidi Lebekadok tiŋa nulukumuŋ tineeneŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisak adi uŋaŋ hatigane heleŋniŋ tamuŋiŋ Lebeka toboŋa siŋgoŋgome tuguk. Kaŋ Filistiahi’walaŋ mapme Abimelek adi yoli maaneŋ yali sububa moŋgotdok yot tubutom tigiŋneŋ diweeŋ yabuguk. ");
INSERT INTO nop_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Yabuŋa Aisak kutinimbune uune niŋguk, “Lebeka adi tamge yoŋ! Maŋgoŋde adi witne yoguŋ?” Yobu nadiŋa niŋguk, “Biyagoŋ nu aditok tiŋa nulune kumumbaatneŋ yoŋa muntaaŋ yogut.” ");
INSERT INTO nop_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kaŋ Abimelekdi yoguk, “Du nemek mulabumuŋ hinek tinimguŋ. Nu’walaŋ mehinekneye niŋdi tamge tubukadakagambe tuguk binek indi dutok tiŋa yom wapum hekiyanim.” ");
INSERT INTO nop_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Unduŋ yoŋa Abimelekdi meeniŋ hogohogok mede munte indiŋ yeniŋguk, “Nebek niŋdi me ne be, bee tamuŋiŋ nemek mu titiŋ niŋ tiyembaak adi adi kumuŋ tibaak.” ");
INSERT INTO nop_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisak adi nanaŋe youli kwet uŋoŋ yetiguk kaŋ gulet wondiniŋ maaneŋgoŋ duhuduhu wapum mintaune moŋgotnaguk. Wapumdi kahaŋ timimbune unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Me u pilap hinek bomboŋnit tuguk. Eŋ adi’walaŋ bomboŋ tomboyoulaŋa feefee tuguk. Kaŋ adi me bomboŋnit tuguk. ");
INSERT INTO nop_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Biyagoŋ kuyoŋ, adi dompa makau fee hinek eŋ tipilapilayeŋiye fee yanagila hatiguk. Unduŋ tubune Filistiahi me adi u kaŋ menot mu timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Unduŋ tiŋa yegiŋ e ime bom hogohogok beu’walaŋ tipilapilaye medi koom beu Abalaham’walaŋ nai ginaŋ dobugiŋ u Filistiahi medi kwet kilabut walikadahiune tokigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tiŋa Abimelekdi Aisak indi niŋguk. “Indi binibiŋa weŋ. Du’walaŋ saŋiniŋdi indi nilakapme tilak.” ");
INSERT INTO nop_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Unduŋ doktiŋa Aisak adi yokwet u bikabuŋa Gela gutuneŋ houle yotŋiŋ maaŋ uŋoŋ itouluguk. ");
INSERT INTO nop_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aisak adi ime bom beu Abalaham’walaŋ nai ginaŋ dobugiŋ u kotigoŋ dilitomtauguk. Beu Abalaham kumumbune Filistiahidi kwet kilabut walikadahiŋa tehegiŋ u wene kikula ime kotigoŋ yehitubumintagiŋ. Unduŋ tiŋa wouhiye koom Beudi yeniŋguk uŋaakoŋ tubukaikaaŋ yeniŋguk. ");
INSERT INTO nop_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisak’walaŋ kwanai medi bom niŋ Gela gutuneŋ uŋoŋ dobuŋa ime kwelemaaŋ niŋ tubumintagiŋ iŋgoŋ e ");
INSERT INTO nop_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gelahi’walaŋ kale yabudoko hekidi ime indi’walaŋ yoŋa Aisak kwanai meŋiyedut tosiwe tigiŋ doktiŋa ime u wou Aisakdi Esek yoguk. ");
INSERT INTO nop_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Unduŋ tubune Aisak kwanai meŋiyedi gigineeŋ ime bom nimaaŋ dobugiŋ e wondok maaŋ tosiwe tigiŋ. Unduŋ tigiŋ kaŋ wou Sitnah youkuk. ");
INSERT INTO nop_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kaŋ adi u bikabuŋa wooŋ nimaaŋ dobugiŋ nai uŋaniŋ tosiwe mu tigiŋ doktiŋa wou Lehobot youkuk. Woŋ adi mebi indiŋ yoŋa youkuk. Wapumdi kwet iŋoŋ hatidok nadinimilak. Ala kwet iŋoŋ hatiŋa ulihakaneem. ");
INSERT INTO nop_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Uŋoŋ hatigane Beasibade loguk. ");
INSERT INTO nop_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Timiŋ uŋaniŋ Wapumdi mintamiŋa yoguk, “Nu baha Abalaham’walaŋ Bepaŋ ale munta mu tibeŋ. Nu dukut hinek hatilat. Nu kahaŋ tigambaat tiŋa kwanai mene Abalaham aditok tiŋa yalakigeye yehitubuulihakawaat.” ");
INSERT INTO nop_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Unduŋ yoguk kaŋ Aisak adi alata niŋ tutumbaaŋ Wapum niutumbaguk. Unduŋ tiŋa houle yotŋiŋ maaŋ uŋgoŋ itouguk. Kwanai meŋiye adi uŋoŋ ime bom niŋ dobugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nai ninde mapme Abimelek eŋ noliŋiŋ Ahusat eŋ memikŋiye diniŋ talitimeŋ Fikoli adut Gela kwetneniŋ busuwagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Busuaune Aisakdi indiŋ yeniŋguk, “Hidi maŋgande nu’walaŋkade biiŋ? Hidi adi not mu tinamuŋa nahakali tubune bugut.” ");
INSERT INTO nop_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Adibo yogiŋ, “Indi Wapumdi dukut hatilak u biyagoŋ hinek kaŋ indiŋ yogumun, ‘Indi lekiŋgoŋnik foloŋ mede yofolok niŋ tiŋa yokwambundanene halune hatiyaneem.’ ");
INSERT INTO nop_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Indi du nemek kadakaniŋ nemu tigamuŋa mohinek tigamuŋa kwelemaŋgoŋ gapmene buguŋ. Undungoŋ dubo nemek kadaakaniŋ nemu tinimbaaŋ. Biyagoŋ kuyoŋ, du Wapumdi kahaŋ tigamulak.” ");
INSERT INTO nop_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Unduŋ yobune Aisakdi muni hinaŋ tiyembune nanaŋe ime nagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kwet heleune haniŋ mede yokwambudaaŋ yofolok tigiŋ. Unduŋ tiŋa Aisakdi yapmeune yohite kwelemaŋgoŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nai uŋaniŋgoŋ Aisak kwanai meŋiyedi buŋa ime bom dobugiŋ wondok mede kahat timiŋa indiŋ niŋgiŋ, “Indi ime tubumintamun.” ");
INSERT INTO nop_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Yobune ime wondiniŋ wou Siba yoguk. Unduŋ doktiŋa nai indidegoŋ yokwet wou Beasiba yoiŋ. ");
INSERT INTO nop_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau adi guletŋiŋ 40 tubune Hitait niŋ wou Beli adi’walaŋ wabi wou Yudit u tamuŋiŋ nagikuk. Tiŋa Hitait niŋ me wou Elon, adi’walaŋ wabiŋiŋ Basema maaŋ nagikuk. ");
INSERT INTO nop_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Tamyat adi’walaŋ titiŋdi Aisakdut Lebeka wele bulaniŋgoŋ tubumintayemgumuk. ");
INSERT INTO nop_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kaŋ Aisak adi hatigane me gawadaŋ tiŋa dawi gweheye hinek tubune nemek kedem mu yabuŋa mihiŋiŋ biyeniŋ kutniŋa niŋguk, “Mihine.” Adibo yoguk, “Nu yoŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisakdibo yoguk, “Nu agaŋ me gawadaaŋ tilat tiŋa kumuŋ naine mu nadilat. ");
INSERT INTO nop_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Unduŋ doktiŋa du kale kaliŋ diniŋ bomboŋ tebe miŋ eŋ mihiniŋ moŋgola behepneŋ wooŋ kale neeŋ utnambeŋ. ");
INSERT INTO nop_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Tiŋa kobaŋ na dibek nawe nadilat undiniŋ hinambeŋ kaŋ naaŋke kahaŋ tigamgidibaaŋ kumumbaat.” ");
INSERT INTO nop_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Lebeka adi kabup yale magi kametnadi tulune Aisak adi mihiŋiŋ biyeniŋ dut mede yonadi tugumuk. Agaŋ Esau adi kale kaliŋ behepneŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Kaŋ Lebekadi mihiŋiŋ Yakobo indiŋ niŋguk, “Nadilaŋ be? Nu bahadi dake Esau indiŋ nimbune nadiŋat. ");
INSERT INTO nop_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Du kale niŋ tinam buŋa nanaŋe kobaaŋ henambune naaŋke Wapum’walaŋ namanda foloŋ kahaŋ tigamgidibaaŋ kumumbaat. ");
INSERT INTO nop_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ale mihine, yoŋ adi ganindidimewene nadiŋa mede tiloloŋ tibeŋ. ");
INSERT INTO nop_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Du indidegoŋ pilap wooŋ meme mihiniŋ maahi lufom moŋgola buŋa nambeŋ, kaŋ nu bahadok nanaŋe kobaaŋ hemimbit. ");
INSERT INTO nop_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kaŋ du bahadok timiŋa loweŋ kaŋ naaŋke kahaŋ tigamgidibaaŋ kumumbaak.” ");
INSERT INTO nop_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobodibo miiŋ Lebeka indiŋ niŋguk, “Nadiweŋ. Datne Esau adi folooŋ dumuniŋ nit, eŋ nu adi foloone gumoi. ");
INSERT INTO nop_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ala batnedi nobu nehinabek? Tiŋa nadiwek e nu tikamanda timilat unduŋ nehitubumintaaŋ kahaŋ tinamdok wabiŋa haaki tinambek kube.” ");
INSERT INTO nop_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Miiŋdibo niŋguk, “Mihine. Haaki u biune nutok tibek. Du adi pilap wooŋ nemek ganilat u tibeŋ. Pilap wooŋ moŋgola bu nam!” ");
INSERT INTO nop_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Unduŋ yobune mihi adi wooŋ moŋgokuk moŋgola buŋa miiŋdok miŋguk, kaŋ miiŋdi nanaŋe kobaaŋ beudi nawe nadilak undiniŋ heeŋ tiulidokomiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Lebeka adi unduŋ tiŋa mihiŋiŋ biyeniŋ’walaŋ dahidahi niŋ ne’walaŋ yolineŋ hatuguk u tiŋa mihiŋiŋ kuyaniŋ Yakobo dahimiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Miiŋ adi unduŋ tiŋa kohoŋ eŋ kodi gumoi u meme gitnemdi kufulaguk. ");
INSERT INTO nop_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Miiŋ adi unduŋ tiŋa nanaŋe kobaaŋ eŋ belet tiulidokoguk u mihiŋiŋ Yokobo kohoŋ foloŋ boimiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobo adi beu’walaŋkade wooŋ yoguk, “Baatne.” Aisakdibo yoguk, “Woe, mihine. Du nedigoŋ?” ");
INSERT INTO nop_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobodibo beu niŋguk, “Nu Esau mihige biyeniŋ, nu mede yoŋaŋ wondok tuwolit tiŋat ale du pilale ila kalene naaŋ kahaŋ tinambeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aisakdi mihiŋiŋ ninadiguk, “Mihine, du dediŋ tiŋa pilap tubumintaŋaŋ?” Kibibo niŋguk, “Du’walaŋ Wapum Bepaŋdi pilap tubumintanamuŋak.” ");
INSERT INTO nop_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kaŋ Aisakdi Yakobo niŋguk, “Mihine, yamaŋgoŋ buune Esau biyagoŋ be yoŋa gohone gabit.” ");
INSERT INTO nop_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo adi beu Aisak habeeŋ foloŋ uguk. Uune hone nadiŋa yoguk, “Maŋiŋ malap adi Yakobo’walaŋ maŋiŋ malap, iŋgoŋ kohoŋ adi Esau’walaŋ kohoŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Adi kohoŋ dumuniŋnit doktiŋa mu nadidakaleguk. Unduŋ tiŋa kahaŋ timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Tubudapmaaŋ indiŋ ninadiguk, “Du biyagoŋ hinek mihine Esau be?” Adibo yoguk, “Nu adigoŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kaŋ adibo yoguk, “Mihine, kalege neeŋ moŋgotnambune nawit, naaŋke kahaŋne gambit.” Yakobo adi moŋgola wooŋ miŋguk kaŋ Aisakdi naguk, naune wain ime maaŋ mimbune naguk. ");
INSERT INTO nop_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Tiŋa beu Aisakdi niŋguk, “Mihine, na itatneŋ iŋgoŋ buŋa siŋgoŋgome tinambeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kaŋ Yakobo adi wooŋ siŋgoŋgome tuguk. Unduŋ tubune beu Aisak adi dahidahiŋiŋ diniŋ munduŋ nadiŋa kahaŋ timiŋa yoguk, “Wa mihine diniŋ munduŋ adi behep munduŋ undiniŋ. Wapumdi behep kahaŋ tuguk ukuyoŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","“Bepaŋ adi kunum mentok eŋ kwet diniŋ galiki tiŋa haŋgom eŋ wain duhuduhu wapum siloŋ tigambaak. ");
INSERT INTO nop_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","“Eŋ meeniŋ kwetkwet adi tipilapilaye tigamuneeŋ. Eŋ meeniŋ bop mohok adi du’walaŋkade duwokeneneŋ. Du daake kwayageye bomboŋgi tiyembaaŋ. Kaŋ maaŋge’walaŋ yalakiŋiye adi duwokinegamuneeŋ. Du haaki tigamuneŋ adi haaki tiyemdok. Eŋ du kahaŋ tigamuneeŋ adi adi kahaŋ tiyemdok.” ");
INSERT INTO nop_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Agaŋ Aisak adi Yakobo kahaŋ timimbune dapmaune Yakobo adi beu kweli biŋa uguk. Ulune Esau adi behepneŋ ugukdi udaneŋ busuaguk. ");
INSERT INTO nop_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Adibo undugoŋ kale heeŋ beudok tiŋalooŋ niŋguk, “Baatne, du pilali mihige nu’walaŋ kale naaŋ kahaŋ tinambeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kaŋ beu Aisakdibo niŋguk, “Kei, du nedigoŋ!?” Kaŋ adibo yoguk, “Nu mihige tuwo biyeniŋ, Esau.” ");
INSERT INTO nop_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisak adi sukule tiŋa boho hinek tiŋa yoguk, “Kaŋ du mu labune kale ula tilabuŋa nambune naaŋ kahaŋ timiŋat u nedi? Kahaŋ woŋ adi aditok fafaŋeniŋ halaak!” ");
INSERT INTO nop_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau adi beu’walaŋ mede unduŋ nadiŋa makat kisaŋ kolaŋa beu niŋguk, “O Mebaŋ, nu maaŋ fiit kahaŋ tinambeŋ!” ");
INSERT INTO nop_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ingoŋ oŋ beudi yoguk, “Kwayage ne yalaŋ naniŋa du’walaŋ kahaŋ moŋgolaŋak!” ");
INSERT INTO nop_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Yobune Esaudi yoguk, “Yopo hinek wou Yakobo yogiŋ, adi adi nalamut tubune nai lufom agaŋ tilak! Adi koom tuwo biyeniŋ diniŋ kahaŋ u nolom moŋgokuk agaŋ kamiŋ kahaŋne moŋgolaŋak.” U yodapmaŋ kotigoŋ yonadiguk. “Nutok kahaŋ neembe binamuŋaŋ?” ");
INSERT INTO nop_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisakdibo Esau indiŋ niŋguk, “I nadiweŋ. Adi me bomboŋgi tigamdok nindapmaŋat. Eŋ dalikwayaŋiye adi adi tipilapilaye timindok yoŋat, haŋgom eŋ wain u maaŋ aditogoŋ yoŋat. Unduŋ doktiŋa mihine kada, dutok maŋgoŋ gambit?” ");
INSERT INTO nop_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaudibo beu niŋguk, “O Mebaŋ, kahaŋ kubugoŋ hogok nemube hakamulak? Mebaŋ, nu maaŋ kahaŋ tinambeŋ!” Unduŋ yoŋa Esau maat wapum kookuk. ");
INSERT INTO nop_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Unduŋ tubune beu Aisakdi mede indiŋ niŋguk, “Du adi kwet galiki mu hatakneŋ eŋ kunum mentok mu malakneŋ yoke kwake undineŋ itouluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Du adi mik kwadigedi nanaŋege tubumintagambaak. Kaŋ kwayage tipilapilaye timimbaaŋ, tiŋa indiŋ mintawaak. Du fafaŋe tiŋa gigine nobu tibaaŋ adi adi’walaŋ mulabumuŋ boboke ginaniŋ dilitelewaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau adi adi beudi Yakobo kahaŋ timiŋguk wondok tiŋa Yakobo nadikadaka timiŋguk. Tiŋa weleŋ ginaŋ indiŋ nadisuguk, “Baatne’walaŋ kobulabulaye nai dula tilak ale u dapmaune nu kwayane Yakobo ulukumuŋ tibaat.” ");
INSERT INTO nop_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kaŋ Lebeka adi mihiŋiŋ biyeniŋ’walaŋ mede u nimbihilune nadiŋa mihiŋiŋ mona nihamaneŋ mede indiŋ niŋguk, “Nadilaŋ be? Dake Esau adi kwihita wapum tiŋa kibikooŋ gulukumuŋ tibene yolak? ");
INSERT INTO nop_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ale, mihine indiŋ yobene nadiweŋ. Du pilap pilali momooŋ witne Laban Halan yokwetneŋ hatilak adi’walaŋ weŋ. ");
INSERT INTO nop_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tiŋa adut nai yagigi hatilune dake’walaŋ nadikwihita kwelemawaak. ");
INSERT INTO nop_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kwelemaune du nemek timiŋaŋ u kauleune nu dutok mede kame gambene nadiŋa udaneeŋ baaŋ. Hidi maŋgoŋde nai kubugoŋ wanaŋ liwenamundeemek?” ");
INSERT INTO nop_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebeka adi unduŋ yoŋa Aisak indiŋ niŋguk, “Nu adi Hitait tamyat dut hatidok adi foloone gulida tilak. Ala tiyaugane Yakobodibo Hitait me adi’walaŋ wabi kwet iŋahi kuyoŋ nagilaak adi nu dediŋ tiŋa itouluwaat.” ");
INSERT INTO nop_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Lebekadi unduŋ yobune Aisakdi Yakobo nihamaneeŋ kahaŋ timiŋa mede indiŋ niŋguk, “Du Kanaaŋ kwetniŋ wabiwoi adi’walaniŋ tamge mu nagilaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ale pilale Padan-Alam kwetneŋ maaŋge’walaŋ beu Betuel adi’walaŋ weŋ. Uŋoŋ maaŋge’walaŋ wiwi me Laban’walaŋ wabiŋiye hatiiŋ adi’walaniŋ niŋ tamge nagilaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bepaŋ Saŋiniŋ Molom adi gehitubulodaaŋ kahaŋ tigambune minta-ulihakaaŋ meeniŋ bop fee mintaneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kaŋ adigoŋ da eŋ yalakigeye hidi wanaŋ Abalaham’walaŋ kahaŋdi siloŋ tihambaak. Unduŋ tubune Bepaŋdi kwet miŋguk buŋambu hatilaŋ u kedem hinek kahilewaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisakdi Yakobo unduŋ niŋa niŋkulune adi Padan-Alam kwetneŋ Laban kawene uguk. Laban adi Alam niŋ, me Betuel’walaŋ mihi eŋ Yakobo eŋ Esau mehik Lebeka’walaŋ wiwi. ");
INSERT INTO nop_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ala Aisak adi Yakobo kahaŋ timiŋa tamŋiŋ niŋ tubumintadok Padan-Alam kwetneŋ niŋkulune uguk. Tiŋa kahaŋ timiŋa mede indiŋ niŋguk, “Du Kanaaŋ tamwoi adi’walaniŋ tamge mu nagilaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Unduŋ niŋguk doktiŋa Yakobo adi miiŋbeu’walaŋ mede tiloloŋ tiŋa Padan-Alam kwetneŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kaŋ Esau adi adi nemek u nadiguk eŋ beu Aisak adi Kanaaŋhi tamwoidok nadiune tuwot mu tuguk u maaŋ kanadi tiŋa ");
INSERT INTO nop_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Abalaham mihiŋiŋ Ismael adi’walaŋ wooŋ wabiŋiŋ Mahalat, Nebayot’walaŋ wiwi uku tamŋiŋ nagilaŋa tamŋiŋyat komihi dut tomboyoukuk. ");
INSERT INTO nop_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo adi Beasiba yokwet bikabuŋa Halan yokwetneŋ wene uguk. ");
INSERT INTO nop_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Talik baniŋ kwet fiileŋ ulune mele foune kwet bufa tuguk. Kaŋ kwet uŋoŋ kawade fee ikiŋ ala kawade niŋ tiŋa mebi poop kameeŋ domo deikuk. ");
INSERT INTO nop_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Deilaŋa lihine tiŋa talolo niŋ kaguk, adi mebidi kwet foloŋ youkilitiŋa yakuk, eŋ boki yeŋ looŋ kunum youdihiŋa yakuk. Kaŋ hayabulune Bepaŋ’walaŋ aŋelo heki yeŋ talolo foloŋ loloŋ fofoŋ tigiŋ! ");
INSERT INTO nop_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kaŋ Wapum ne adi pilap hinek talolo bokineŋ yaleŋa indiŋ yoguk, “Nu Wapum, baha papage Abalaham eŋ Aisak adi’walaŋ Bepaŋ. Kwet dahataŋ woŋ uye da eŋ yalakigeye hiditok hambaat. ");
INSERT INTO nop_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Eŋ yalakigeye adi mintaulihaka tige tige kwet foloŋ kwam dukwa hatak wondok tuwolit tineeŋ. Tiŋa du ulihakaaŋ kwet fukufukuŋ woihiŋkade eŋ komaaŋkade dane popohineeŋ wooŋ kahilewaaŋ. Tiŋa undugoŋ da eŋ yalakigeye hidi’walaŋ kahaŋdi meeniŋ kwetkwet tokiyembaak. ");
INSERT INTO nop_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nadilaŋ be, nu dukut hatibaat tiŋa kwet daŋgoŋ hatibaaŋ tuwot hatiŋa gabudokowaat. Tiŋa hatigane ganagilene kwet iŋoŋ kotigoŋ udaneeŋ baaŋ. Nu adi bigabu mu tibaat, dukut helemahelemaŋ hatiluwene nemek mintagamdok ganifafaŋelat u folooŋnit tibaak.” ");
INSERT INTO nop_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kaŋ Yakobo adi sukuleeŋ pilale yoguk, “Wapum adi biyagoŋ kwet iŋoŋ hinek hatilak. Nu adi hogok binek hatak yogut.” ");
INSERT INTO nop_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tiŋa munta tiŋa indiŋ yoguk, “Yakeii! Kwet yoŋ adi uŋgoniŋ hinek! Biyagoŋ hinek! Bepaŋ’walaŋ yoli kweli, eŋ kunum diniŋ talik yeme.” ");
INSERT INTO nop_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Heleune haniŋ hinek Yakobo adi pilaliŋa kawade mebi poop kameeŋ deikuk u tubupilale koloŋ kambiyale ime wahu munduŋnitdi yougomguk. ");
INSERT INTO nop_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Unduŋ tiŋa yokwet wou Betele yoguk. Kom kwaha adi yokwet wou Lus yoyagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Unduŋ tiŋa Yakobo adi mede yofolok indiŋ tuguk, “Bepaŋ, du nukut hatibaaŋ, tiŋa talik hati uluwene nabuulidoko tibaaŋ. Tiŋa kumone miiŋdok nanaŋe eŋ foloonedok tinahukut tubumintanambaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Unduŋ hati tinamtalolune foloone kunilit batne’walaŋ yolineŋ baat adi Wapum du nu’walaŋ Bepaŋ tinambaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kaŋ kawade fek kambiyatat yendi du’walaŋ yot tibaak. Eŋ nemenemek nambaaŋ hogohogok woŋ adi daneeŋ ten ten boiŋa dutok ten kubugoŋ tubuudanegamuluwaat.” ");
INSERT INTO nop_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo adi helebufa fee uge, uge meeniŋ mele labulabuneŋkade hatiyagiŋ adi’walaŋ kwehineŋ usuaguk. ");
INSERT INTO nop_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ugane dadiyeeŋ dawi diweune uune hewehewe ginaŋ ime bom niŋ kaguk. Uŋoŋ dompa bop lufomkulitniŋdi hakiŋ. Biyagoŋ kuyoŋ, meeniŋ yohi kwehi uŋahi adi ime bom uŋaniŋ gilaŋa kalehiye yehitoiyagiŋ. Ime bom mamineŋ adi kawade wapumdi kufulaune ituguk. ");
INSERT INTO nop_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ala ime uŋoŋ adi dompa makau bop mohomohok wanaŋ yeheŋeeŋ buŋa bopneeŋ kawade u liliweneeŋ ime giyembune nadapmaune kotigoŋ teheyagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ala Yakobodi kale yabudoko heki yeninadiguk, “Notneye hidi diŋahi?” Adibo yogiŋ, “Indi Halanhi.” ");
INSERT INTO nop_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kaŋ yeninadiguk, “Hidi Naho mihiŋiŋ Laban nadiiŋ be?” Adibo yogiŋ, “Eŋ, uŋgoŋ nadiyam.” ");
INSERT INTO nop_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kaŋ yeninadiŋa yoguk, “Adi kedem be hatilak?” Adibo yogiŋ, “Kedeem hatilak, ala wabiŋiŋ Lesel adi beu’walaŋ dompa makau yanagila kougoŋ bulak.” ");
INSERT INTO nop_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobodibo yoguk, “Mele wohiŋ gwalaŋ itak maaŋ be kaiŋ, dompa makau yopmaŋ yapmedok nai mu tilak. Ale ime giyemiŋa yapmeune kotigoŋ wooŋ kilihikit naneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kaŋ adibo yogiŋ, “Kale bop noli mu bulune unduŋ kedem mu tinim. Wanaŋ budapmaune adigili kawade bom mamineŋ itak u liliweneeŋ kale mihihi ime yemiyam.” ");
INSERT INTO nop_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo adi mewoidut mede yonadi ya tulune uŋaniŋgoŋ Lesel adi beu’walaŋ dompa makau yanagila busuaguk. Adi adi wabidi kwanai u tuluguk. ");
INSERT INTO nop_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kaŋ Yakobo adi kokooŋ Laban’walaŋ wabi Lesel eŋ kokooŋ’walaŋ kale maaŋ yabuŋa wooŋ bom mamineŋ kawade kwehene tikameeŋ kokooŋ Laban’walaŋ dompaŋiye ime giyemguk. ");
INSERT INTO nop_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Dapmaune Lesel siŋgoŋgomeeŋ tububihila maat wapum kokuk. ");
INSERT INTO nop_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Unduŋ tiŋa Yakobo adi Lesel beu’walaŋ naŋgat diki eŋ Lebeka’walaŋ mihiŋiŋ unduŋ niŋguk. Kaŋ Lesel adi Yakobo bikabuŋa kiyane wooŋ beu Laban mede kahat timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kaŋ Laban adi wiwi diniŋ mihi Yakobo adi’walaŋ mede kahat nadiŋa weneŋgeila wooŋ kaaŋ toboŋa siŋgoŋgomeeŋ nagila yolineŋ loguk. Kaŋ Yokobodi mede kahatŋiŋ didimeniŋgoŋ hinek Laban niŋguk. ");
INSERT INTO nop_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kaŋ Labandibo niŋguk, “Du adi nu’walaŋ gom eŋ naŋgat hinek.” Kaŋ Yakobo adi muyakip kubugoŋ adut hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labandi Yakobo niŋguk, “Du naŋgatne diki iŋgoŋ maŋgoŋde kwanai tuwanit mokit tinambaaŋ. Ale tuwaŋiŋ maŋgoŋ moŋgotdok nadilaŋ u kedem nanimbeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban adi wabiŋiŋyat lufom hatigumuk. Wabiŋiŋ mok wou Lea eŋ wabiŋiŋ wene Lesel. ");
INSERT INTO nop_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ala Lea’walaŋ dawi adi haŋandaaŋ, eŋ Lesel adi folooŋ namandap momooŋ hinek. ");
INSERT INTO nop_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Unduŋ dokiŋa Yakobo adi weleŋ Leseldok nadiguk. Unduŋ doktiŋa indiŋ yoguk, “Nu wabige wene Lesel aditok tiŋa gulet 7 kwanai hogok tigambaat.” ");
INSERT INTO nop_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kaŋ Labandibo yoguk, “Adi me gitipmuŋdok mu miŋa dutok gamdok adi nadiwene kedem eŋ tuwot hinek tilak. Ale nukut hatibaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Unduŋ doktiŋa Yakobo adi Lesel nagitok nadiŋa gulet 7 tipilapilaye kwanai hogok tihatiguk. Tiŋa Leseldok mohinek nadiguk doktiŋa gulet fee u nadiune melenai lufomkabe nabugoŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Unduŋ tiŋa Yakobodi Laban niŋguk, “Kwanai naine agaŋ tubudapmagut ale tamne nambeŋ nu agaŋ adut deile nadilat.” ");
INSERT INTO nop_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Unduŋ yobune Laban adi nanaŋe kale nanaŋe he bopneeŋ meeniŋ uŋahi yeniyehemaneune buŋa kale nanaŋe eŋ ime nagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ala agaŋ kwet bufaune Laban adi wabiŋiŋ mok Lea nagila looŋ Yakobodok miŋguk. Kaŋ Yakobo adi Leadut deikumuk. ");
INSERT INTO nop_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban adi unduŋ tiŋa yeguk e Leadok tipilapilaye tam e Silpa miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Heleune haniŋ kaguk kei! Yadi Lea boyoŋ! Unduŋ kaŋ Yakobodi Laban niŋguk, “Du maŋgoŋ tinamuŋaŋ? Nu adi Leseldok tipilapilaye kwanai tigamgut! Kaŋ du maŋgoŋde nalamut tiŋaŋ?” ");
INSERT INTO nop_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kaŋ Labandibo yoguk, “Yokwet iŋoŋ wabi biyeniŋdi hogok hatilune wabi wene me foloŋ mu yapmeyam. ");
INSERT INTO nop_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Wabi’walaŋ kwanai muniniŋ sondadok tuwolit u tubudapmawaaŋ. Kaŋ indi wabi wene maaŋ gamneem. Kaŋ du aditok tiŋa gulet 7 tipilapilaye kwanai kotigoŋ tibaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kaŋ Yakobo adi undugoŋ tuguk. Yakobo adi Lea dut hatibune sonda niŋ tubune Labandi wabiŋiŋ Leselbo miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Unduŋ tiŋa Laban adi wabiŋiŋ Leseldok tipilapilaye tam niŋ miŋguk wou Bilha. ");
INSERT INTO nop_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobo adi tamŋiŋ Lesel nagila adut bo deikumuk. Unduŋ tiŋa adi Lesel weleŋdi kahile hinek tuguk. Eŋ Lea adi weleŋdi kahile hinek mu tuguk. Unduŋ tiŋa Yakobo adi Leseldok tiŋa gulet 7 Laban’walaŋ tipilapilaye kwanai kotigoŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Wapumdi Lea kaguk e yohoidi weleŋdi kahile mu tiluguk kaŋ wapmihi mintadok talii dilitomiŋguk. Eŋ, Lesel adi kafi hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea adi mihiwele tiŋa mihi niŋ nagikuk. Tiŋa indiŋ yoŋa wou Luben youkuk, “Wapumdi bulaniŋgoŋ tibene nabuguk. Nai indinde yohone adi weleŋdi nabukahilewaak.” ");
INSERT INTO nop_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea adi mihiwele kotigoŋ tiŋa mihi niŋ nagila yoguk, “Wapum adi nu nabukahile mu tiiŋ, unduŋ nadiŋa mihi i maaŋ namguk.” Unduŋ doktiŋa wou Simeon youkuk. ");
INSERT INTO nop_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea adi kotigoŋ mihiwele tiŋa mihi niŋ nagila yoguk, “Kamiŋ yohone adi nukut kadiwaak. Maŋgoŋde nu mihiŋiye lufomkulitniŋ yanagilimiŋgut.” Unduŋ yoŋa wou Lewi youkuk. ");
INSERT INTO nop_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea adi mihiwele kotigoŋ tiŋa mihi nagila yoguk, “Kamiŋ adi Wapum wou nintilowit.” Unduŋ yoŋa wou Yuda youkuk. Unduŋ tiŋa wapmihi yanagi-yanagit wabiguk. ");
INSERT INTO nop_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lesel adi Yakobo wapmihi nemu nagilimiŋguk u kaŋ dalidut goliŋgoliŋ tubumintaguk. Unduŋ tiŋa Yakobo niŋguk, “Wapmihi neeŋ nambeŋ, eŋ mooŋ adi nu kumuŋ tibit!” ");
INSERT INTO nop_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Unduŋ yobune Yakobo adi Lesel kwihita timiŋa yoguk, “Bepaŋdi wapmihi yanagitdok taali tehep tigambune nu dediŋ tiŋa tubumintagambit?” ");
INSERT INTO nop_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kaŋ Leseldibo yoguk, “Unduŋ yolaŋ ale nu’walaŋ tipilapilaye tam Bilha nagila hatibune mihi niŋ mintaune nutok nagila wapmihi bomboŋnit tibaat.” ");
INSERT INTO nop_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Unduŋ yoŋa tipilapilaye tam Bilha Yakobo’walaŋ tam titindok nindapmaune ");
INSERT INTO nop_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Yakobodi nagila hatibuune mihiwele tiŋa Yakobo’walaŋ mihi niŋ nagikuk. ");
INSERT INTO nop_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Unduŋ tubune Leseldibo yoguk, “Bepaŋ adi nadinambune tuwot tubune medene nadiŋa mihi niŋ siloŋ tinamulak.” Unduŋ yoŋa wou Dan youkuk. ");
INSERT INTO nop_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Lesel’walaŋ tipilapilaye tam adi kotigoŋ mihiwele tiŋa Yakobo mihi nimaaŋ nagilimiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Unduŋ tubune Leseldibo yoguk, “Datnedut gigine kwanai tiŋa fafaŋelat.” Unduŋ yoŋa mihi wou Naftali youkuk. ");
INSERT INTO nop_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leadibo u kaŋ ne wapmihi yanagitdok taali agaŋ teheguk nadiŋa tipilapilaye tam Silpa nagila wooŋ Yakobodok tam miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lea’walaŋ tipilapilaye tam Silpa adi mihiwele tiŋa Yakobodok mihi niŋ nagikuk. ");
INSERT INTO nop_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nagilune Leadi “wele momooŋ” yoŋa wou Gad youkuk. ");
INSERT INTO nop_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lea’walaŋ tipilapilaye tam Silpa Yakobodok mihi nimbo nagilimimbune lufom tugumuk. ");
INSERT INTO nop_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Unduŋ tubune Leadi yoguk, “Nu nadifo hinek tilat. Tamwoi adi nadifo naniyaneeŋ.” Unduŋ yoŋa wou Ase youkuk. ");
INSERT INTO nop_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Haŋgom uut nai tubune Luben adi kade gineŋ wooŋ haguwo niŋ tam kafi hatiiŋ yehitubulodaune wapmihinit titindok u yabuŋa moŋgola buŋa miiŋ Leadok miŋguk. Kaŋ Leseldi indiŋ niŋguk, “Mihigedi haguwo moŋgola bu gamuŋak u noli nutok kedem be nambeŋ?” ");
INSERT INTO nop_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Adibo yoguk, “Yohone nolom nagila weŋ u nadilodaaŋ be buŋa mihine’walaŋ haguwo u maaŋ moŋgole ya yolaŋ!” Leseldibo yoguk, “Kedeem ale mihige’walaŋ haguwo wondiniŋ tuwaŋiŋ Yakobo adi kamiŋ timiŋ dukut deitemek.” ");
INSERT INTO nop_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ala Yakobo adi kwanai tiyauge tebele yopmande bulune Leadi wooŋ kaŋ niŋguk, “Du adi kamiŋ nukut deitim. Mihine’walaŋ haguwodi agaŋ gehituwaŋat.” Unduŋ doktiŋa timiŋ woŋ e Lea dut deikumuk. ");
INSERT INTO nop_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bepaŋ adi Lea’walaŋ mede nadiguk. Kaŋ Lea adi mihiwele tiŋa Yakobodok mihi nimaaŋ nagilune kunakunatŋiŋ 5 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kaŋ Lea adi indiŋ yoguk, “Bepaŋ adi tipilapilaye tam yohonedok miŋgut doktiŋa kibibo namulak.” Unduŋ yoŋa wou Isaka youkuk. ");
INSERT INTO nop_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea adi mihiwele kotigoŋ tiŋa Yakobodok mihi nimaaŋ nagilune kunakunatŋiŋ 6 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Kaŋ Leadi yoguk, “Bepaŋ adi siloŋ momooŋ tinambune yohone’walaŋ mihiŋiye 6 yanagikut, doktiŋa nakat didimeniŋgoŋ hatibaak.” Unduŋ yoŋa wou Sebulon youkuk. ");
INSERT INTO nop_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mindaŋ wabi niŋ nagila wou Dina youkuk. ");
INSERT INTO nop_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Agaŋ Bepaŋdi Lesel nadimiŋa wapmihi yanagitdok weleŋ dilitomguk. ");
INSERT INTO nop_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Kaŋ Lesel adi mihiwele tiŋa mihi niŋ nagikuk, tiŋa yoguk, “Bepaŋ adi meekane liliwenekutnamulak.” ");
INSERT INTO nop_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Unduŋ yoŋa wou Yosep youkuk, tiŋa yoguk, “Bepaŋ adi fiit mihi noli maaŋ nambaak.” ");
INSERT INTO nop_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kaŋ Lesel adi Yosep nagilune Yakobodi Laban indiŋ niŋguk, “Nu agaŋ nameune yotne kwatnede mawit. ");
INSERT INTO nop_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Tamneyat eŋ wapmihineye aditok tipilapilaye kwanai agaŋ tuwot tigamgut ale nanindapmaune yanagila mawiit. Tiŋa tipilapilaye kwanai dediŋ tigamtalabut u da nadilaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Iŋgoŋ e Labandibo niŋguk, “Iŋgoŋ nobu hatidok nadikaŋ kedem nukut iŋgoŋ hatiyaneem. Nu indiŋ nadilat. Du nukut hatilaŋ doktiŋa Bepaŋdi kahaŋ tinambune duhu duhu wapum mintanamlak.” ");
INSERT INTO nop_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Laban adi tomboyoula yoguk, “Kwanaige diniŋ tuwaŋiŋ yobeŋ kaŋ gehituwawit.” ");
INSERT INTO nop_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobodibo yoguk, “Nu kwanai dediŋ tigamgut eŋ dompa makaugeye yabudokowene dediŋ tigiŋ u da nadilaŋ. ");
INSERT INTO nop_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kom nu mu bugutneŋ lufom kabe itougamgiŋ. Nai indidegoŋ adi kisaŋ mintaulihaka tigamgiŋ hatiiŋ. Kaŋ nu kwanai tuluwene Wapumdi nemek momooŋ tigamguk. Nai indide adi nu na’walaŋ wapmihine tam aditok tiŋa kwanai tiŋa yehitubulodadok nadilat.” ");
INSERT INTO nop_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kaŋ Labandi ninadiguk, “Maŋgoŋ gambit yoŋa nanilaŋ?” Yakobodi mede indiŋ tubuudaneeŋ niŋguk, “Du nemek nemu nambeŋ. Nu mede nadisulat u yobene nadiune tuwot nobu tibek adi dompa makaugeye kotigoŋ hati yabudokoluwaat. ");
INSERT INTO nop_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ala nadinambeŋ kaŋ kalegeye bop bop yabutawooŋ youbutombutom, eŋ kudikudi hinit u yabuŋa yehidaneeŋ yehikelekulit, dompa mihiniŋ gouyehi, eŋ meme mihiniŋ youbutombutom hinit yabuŋa unduŋ tibit. Kaŋ kale undihi adi nu kwanai tilat wondiniŋ tuwane. ");
INSERT INTO nop_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kaŋ nemek tilat wondiniŋ mebi adi kougoŋ dakalewaak. Ala du hatigane tuwane kawene buŋa meme baŋam ginaŋ youbutombutom hinit mookit wanaŋ yatneeŋ, eŋ dompa baŋam ginaŋ gouyehi hogok mooŋ noli maaŋ yalune yabuŋa yobaaŋ. ‘Noli woŋ adi kubo tigiŋ yobaaŋ.’” ");
INSERT INTO nop_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kaŋ Labandibo yoguk, “U nadiwene tuwot tilak. Yolaŋ undugoŋ titindok.” ");
INSERT INTO nop_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Unduŋ yoŋa Laban melenai uŋaniŋgoŋ wooŋ meme maahi kudikudi youbutombutom hinit, eŋ meme kudikudi youbutombutom hinit, eŋ fafau gouyeniŋ lekiŋgoŋ lekiŋgoŋ hinit, eŋ dompa mihihi gouyehi yanagila mihiŋiye kohohik ginaŋ boidapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Unduŋ tiŋa Yakobo bikabuŋa melenai lufomkulitniŋ uge uge kwet kwatnaŋgoŋ ususaguk. Kaŋ Yakobodi Laban’walaŋ dompa mohok noli hatiyabudokoguk. ");
INSERT INTO nop_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Kaŋ Yakobo adi ŋaso, eŋ bem noli wondi kuyaŋ kobuhi diniŋa gitnem uŋaniŋ uŋaniŋ dobu kelemadiŋa kibidalune maaŋ fafau u miŋgoŋ mintaune kudikudinit tuguk. ");
INSERT INTO nop_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Unduŋ tiŋa kuyaŋ kibidatnit u dompa heki ime nane buune habehik foloŋ ime maliŋ ginaŋ kapmaune foluguk. ");
INSERT INTO nop_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Uyadi dompa hekidi ime nane buŋale maahidi tam tuat tagiŋ doktiŋa unduŋ tuguk. Kaŋ kale heki adi kuyaŋ hakukneŋ unduŋ tiŋa mihiniŋ kudikudi eŋ youbutombutom hinit undihi yehitubumintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kaŋ Yakobo adi dompa mihihi yehidaneŋ yehibopneune Laban’walaŋ kale bop mohok kudikudi hinit, eŋ gouyehi adi’walaŋkade dauhik ya diwegiŋ. Adi unduŋ tiŋa netok bop niŋ molomgoŋ boiŋa Laban’walaŋdut mu yehikiukuk. ");
INSERT INTO nop_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kaŋ kale fafaŋehi yeŋ tam tuwat tubune yabuŋa Yakobodi kale namandahik ginaŋ kuyaŋ ime maliŋ ginaŋ dahiune foluguk. Uyadi kale hekidi tam tuwat tiŋale kuyaŋ kudikudinit u kakandok yoŋa unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kaŋ gweheyehidi tam tuwat tagiŋneŋ kuyaŋ kudikudinit ime gineŋ mu kameluguk. Unduŋ doktiŋa kale gweheyehi adi Labandok tigiŋ. Eŋ fafaŋehi adi Yakobodok tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Biyagoŋ kuyoŋ me woŋ adi unduŋ tiŋa bomboŋ mohoknit tuguk, eŋ kale, eŋ tipilapilaye metam, eŋ kamele, eŋ doŋki fee mintamiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laban mihiŋiyedi mede yogiŋ u Yakobo’walaŋ magi ginaŋ foguk. Mede indiŋ, “Yakobo adi betnik’walaŋ nemenemek hogohogok moŋgodapmaguk. Biyagoŋ kuyoŋ, nemek betnik netok gigit hakuk u bumbut moŋgola me bomboŋnit tuguk.” ");
INSERT INTO nop_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kaŋ Yakobodi Laban’walaŋ namanda eŋ titiŋ kanadi tubune koom menot timiŋa tuluguk nabugoŋ mu tuguk. ");
INSERT INTO nop_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Unduŋ tubune Wapumdi Yakobo indiŋ niŋguk, “Udaneeŋ baha papageye’walaŋ kwehineŋ waaŋ. Kaŋ nu dukut hatibaat.” ");
INSERT INTO nop_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Unduŋ yobune Yakobo adi kale heki hatiyagineŋ uŋgoŋ hale tamŋiyat Leseldut Leadok mede kameyemguk. ");
INSERT INTO nop_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Tamyat buune yeniŋguk, “Nu behik’walaŋ titiŋ kawene koom tinamguk nabugoŋ mu tilak. Iŋgoŋ batne’walaŋ Bepaŋ adi nukut hatilak. ");
INSERT INTO nop_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Hidi agaŋ nadiyamuk. Nu behik’walaŋ kwanai fafaŋe tiŋa tihatilat. ");
INSERT INTO nop_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Iŋgoŋ oŋ behik adi tuwane namdok nalamula tiŋa loŋat foŋat tubune nai 10 tuguk. Tiŋa bomboŋne nolom moŋgola nehitubufigitawaakneŋ yoŋa Bepaŋdi kamehep timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kale youbutombutom hinit u dutok yobune kale hogohogok youbutombutom hinit mintagiŋ. Agaŋ kudikudi hinit u tuwage yobune kale hogohogok adi mihiniŋ kudikudinit mintadapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Unduŋ tubune Bepaŋ adi behik’walaŋ kale undihi lom moŋgodapmaaŋ nutok namdapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Kale maahi adi tam tuat tigiŋ nai uŋaniŋ lihine ginaŋ daune diweeŋ nemek indiŋ kagut. Dompa, eŋ meme maahidi tam tuat tigiŋ adi’walaŋ sigihik adi kudikudi hinit eŋ youbutombutom hinit hogohogok. ");
INSERT INTO nop_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kaŋ Bepaŋ’walaŋ aŋelodi indiŋ naniŋguk, ‘Yakobo!’ Kaŋ nubo yogut, ‘Nu yoŋ eeŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kaŋ yoguk, ‘Du dadiyeeŋ dauge diweeŋ kaweŋ. Dompa, eŋ meme maaniŋdi tamuhi tam tuwat tiyemiŋ adi adi kudikudi hinit, eŋ youbutombutom hinit hogohogok. Kaŋ nu Labandi nemek tigamguk u agaŋ kaŋ nadidapmalat. ");
INSERT INTO nop_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nu Betele yokwet wondiniŋ Bepaŋ. Du kwet uŋgoŋ hinek kawade niŋ wahu munduŋ imedi yougomuŋa mede yofolok niŋ tinamguŋ. Pilap indidegoŋ pilat. Tiŋa yokwet i bikabuŋa da’walaŋ yoke kwakeneŋ naŋgatge mamaŋneŋ udaneeŋ weŋ.’” ");
INSERT INTO nop_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kaŋ Leseldut Lea adi Yakobo mede indiŋ tubuudanemiŋgumuk. “Indi betnik’walaŋ kohoŋ diki inditok gigit yoŋit u neembe hatak? ");
INSERT INTO nop_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Adi’walaŋ hebeŋ foloŋ buŋambu nabugoŋ mu be hatiyamut, ale? Adi adi nihikelekula inditok tuwaŋiŋ moŋgola agaŋ tubudapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Unduŋ doktiŋa Bepaŋdi betnik bomboŋ lom moŋgokuk hogohogok woŋ adi agaŋ indi eŋ wapmihiniye inditok gigit tilak. Unduŋ doktiŋa Bepaŋdi ganiŋdidimeguk tuwot tibeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Unduŋ yobune Yakobo adi pilale tamŋiye eŋ wapmihiŋiye kamele foloniŋ yapmeguk. ");
INSERT INTO nop_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Tiŋa dompa makauŋiye eŋ bomboŋŋiŋ noli Padan-Alam kwetneŋ hatiŋele tubumintaguk u moŋgodapmaaŋ Kanaaŋ kwetneŋ beu Aisak kawene udaneeŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Nai uŋaniŋ Laban adi dompaŋiye dumuniŋ dobuyembene uguk. Kaŋ Lesel adi beu’walaŋ yabap welewele bepaŋ yalayalaŋ kuboneŋ timauguk. ");
INSERT INTO nop_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo adi momowene Alamniŋ me Laban mu nimbuhilaŋa tilamut tuguk. ");
INSERT INTO nop_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Unduŋ tiŋa pilali nemenemek hogohogok adi’walaŋ gigit u kimahapneeŋ momooŋ mauguk. Momooŋ uge uge Yufeletis ime meŋeŋa wooŋ Gilead kweboboeneŋkade uguk. ");
INSERT INTO nop_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kaŋ melenai lufomkulitniŋ dapmaune Laban indiŋ niŋgiŋ, “Yakobo agaŋ momooŋ mauguk.” Unduŋ nimbune nadiŋa ");
INSERT INTO nop_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","naŋgat dikiŋiye yanagila mele 7 yahakalitawooŋ Gilead kwet haŋgi foloŋ ungoŋ usuwaaŋ yabugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Bepaŋ adi me Alamniŋ wou Laban timiŋ lihine ginaŋ mintamiŋa indiŋ niŋguk, “Du Yakobo mede unduŋ be unduŋ yoŋa nintobaaneŋ ala nadinadiŋele yobeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yokobo adi kwet haŋgi foloŋ uŋgoŋ houle yot maaŋ wanaŋ deikiŋ. Kaŋ Laban tiŋa meŋimeŋiye adi yabuhila adi maaŋ uŋgoŋ houle yot maaŋ ikiŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Tiŋa Labandi Yakobo indiŋ niŋguk, “Du maŋgoŋ kudi tinamguŋ? Tiŋa nalamulaŋa wabineyat mik ginaŋ memik heki yehitehiŋa yanagi yawiiŋ nabugoŋ yanagila buguŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Tiŋa maŋgoŋde nalamula kabup momooŋ buguŋ? Nanimbune nadiŋa muni hinaŋ tiŋa kap miyeeŋ gamewe beŋ oŋ! ");
INSERT INTO nop_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Du adi wabineyat yehisiŋgoŋgomedok mu nadinamguŋ. Du kudi kauleeŋ hinek tuguŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kaŋ yoŋ adi nemek ube u kaka tigamdok saŋiniŋ mu lohigut, iŋgoŋ oŋ, baha’walaŋ Bepaŋdi timiŋ nanihep tiŋa indiŋ yoŋak, ‘Du Yakobo mede unduŋ be unduŋ yoŋa nintobaaneŋ ala nadinadiŋale yobeŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Du baha papageye yabene mohinek nadiŋa momooŋ buguŋ wa kedem ala kubugoŋ adi nu’walaŋ yabap welewelene maŋgoŋde kubo tiguŋ?” ");
INSERT INTO nop_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Kaŋ Yakobodi Laban mede indiŋ tubuudaneeŋ niŋguk, “Nu wabigeyat nolom moŋgolaaneŋ yoŋa munta tugut. ");
INSERT INTO nop_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Eŋ yabap welewele wondok mu nadilat. Du nedi’walaŋ liineŋ yabap welewelege tubumintaweŋ adi adi mu hatibaak. Nemek boi hatilat u naŋgat dikiniye’walaŋ namandahik foloŋ lohiŋa yabeŋ.” Yakobo adi Leseldi yabap welelwele u tuguk u mu nadiguk. ");
INSERT INTO nop_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kaŋ Laban adi Yakobo, eŋ Lea, eŋ tipilapilaye tam adi’walaŋ houle yotneŋ loguk iŋgoŋ yabap weleweleŋiŋ u mu tubumintaguk. Unduŋ tiŋa Lea’walaŋ yopmaŋneniŋ labuŋa wooŋ Lesel’walaŋ yolineŋ foguk. ");
INSERT INTO nop_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Uluguk kaŋ Lesel adi yabap welewele u pilap tiŋa kamele’walaŋ kumoise ginaŋ dahiŋa folooniŋ looŋ wihila ikuk. Kaŋ Laban adi yot maaneŋ looŋ mooŋ lohi kaguk. ");
INSERT INTO nop_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Lesel adi beu yalaŋ indiŋ niŋguk, “Bomboŋgine, du kwihita mu tibeŋ, muyakip yagit tilat doktiŋa nu du’walaŋ dauge foloŋ tuwot mu pilalit.” Laban adi nemenemek agaŋ yabudapmaguk iŋgoŋ yabap welewele hogok mu tubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kaŋ Yakobo Labandok kwihita kisaŋ timiŋa nintoŋa indiŋ niŋguk, “Nu maŋgoŋ kadakaniŋ eŋ mulabumuŋ tigamgut doktiŋa nula nahakililaŋ? ");
INSERT INTO nop_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Yoŋ adi nemenemekne hogohogok wiya loŋiloŋineeŋ kadapmaŋaŋ. Ale da’walaŋ nemek neeŋ nobu tubumintaweŋ kaŋ naŋgat dikiniye’walaŋ dauhik ginaŋ kameune adi u kaŋ indi’walaŋ mede yodapmaneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Nu dukut hatibene gulet 20 dapmalak. Kaŋ dompa eŋ memegeye adi mihiniŋ biyegiŋ kadaka be kumuŋ nemu tigiŋ, eŋ du’walaŋ dompa maaniŋ nemu ula hinagut. ");
INSERT INTO nop_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Biyagoŋ kuyoŋ, dompa mihihi kamo moiŋdi idikadakagiŋ u yanagila du’walaŋ mu bugut, na kibikoŋ boilugut. Kaŋ du yadi timiŋ be hedepmo kubo tagiŋ wondiniŋ tuwaŋiŋ kamendok naniŋgigineluguŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Nu yadi hedepmo mele fafaŋeniŋ diweune gweheye tulugut eŋ timiŋ sububa doktiŋa domo kaipmuŋ hatulugut. ");
INSERT INTO nop_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nu yadi gulet 20 wapum yokeneŋ tipilapilaye kwanai tugut. Gulet 14 wabigeyat doktiŋa tugut, eŋ gulet 6 kalegeye doktiŋa tugut. Du yadi tuwane tiŋaloŋ tiŋafoŋ tinambune naiŋiŋ 10 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Biyagoŋ kuyoŋ, batne’walaŋ Bepaŋ, Abalaham’walaŋ Bepaŋ, eŋ Aisakdi gikiŋgoŋ timiluguk adi nukut mu hati binek du hambep kohom balim hinek napmeune bee tugut. Bepaŋ adi bulaniŋgoŋ eŋ folofigita kwanaine kanadi tiŋa timiŋ medene yodapmaŋak.” ");
INSERT INTO nop_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Kaŋ Labandi Yakobo mede indiŋ tubuudaneeŋ niŋguk, “Wabiyat, eŋ wapmihi, eŋ dompa makau, eŋ nemek yabulaŋ hogohogok yoŋ adi nu’walaŋ. Ala yoŋ adi wabineyat, eŋ wapmihi yanagikiŋ adi adi kamiŋ maŋgoŋ kedem niŋ tiyembene tuwot tibek? ");
INSERT INTO nop_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ale pilap yofolok niŋ tidim, tiŋa kawadedi fek niŋ kambiyatim wondi lekiŋgoŋnik foloŋ yali mebinik ninimbuhila ninindidimeluwaak.” ");
INSERT INTO nop_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Unduŋ yobune Yakobodi kawade niŋ tiŋa koloŋ fek kambiyakuk. ");
INSERT INTO nop_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Tiŋa naŋgat dikiŋiye indiŋ yeniŋguk, “Hidi kawade ugamale buŋa bopneneŋ.” Unduŋ yenimbune adi kawade ugamale buŋa bopneune kawade bop gagayeŋ uŋgoŋ ilaŋa muni nagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Unduŋ tiŋa Laban adi kawade bop wondok wou Yega Sahaduta yobune Yakobodi wou Galeed yoguk. ");
INSERT INTO nop_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kaŋ Labandi yoguk, “Kamiŋ kawade bop yendi indi’walaŋ mebinik ninimbuhila ninindidimeluwaak.” Unduŋ doktiŋa wou Galeed yogiŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Eŋ kawade fek hinek wondok Labandi indiŋ yoŋa wou Misipa yoguk, “Wapum adi daneeŋ molomolom hatiyane hati nibidokoluwaak. ");
INSERT INTO nop_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Du wabineyat menot mu tiyembaaŋ ee mu nadiluwene tam noli maaŋ yanagila indiŋ nadiwaaŋ Bepaŋ adi hatinibilak.” ");
INSERT INTO nop_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Unduŋ tiŋa Labandi tomboyoula Yakobo indiŋ niŋguk, “Nadiweŋ, kawade bop eŋ kawade fek lekiŋgoŋnik foloŋ kambiyalat ");
INSERT INTO nop_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","wondi indi’walaŋ yodakalenik itune nu mik kwadi tigamuŋa du’walaŋ hatihati ginaŋ mu foluwaat, eŋ dubo nu mik kwadi tinamŋa fek i kelelahula nu’walaŋkade mu buluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Biyagoŋ kuyoŋ, Abalaham eŋ Naho adi’walaŋ Bepaŋdi indi’walaŋ mede yodapmaluwaak.” Kaŋ Yakobo adi adi beu Aisakdi Bepaŋ gikiŋgoŋ timiluguk adi wou foloŋ yofolok fafaŋeniŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Unduŋ tiŋa kwet haŋgi foloŋ muni hinaŋ tiŋa kale nanaŋe hebopneeŋ naŋgat dikiŋiye yeniyehemaneune buŋa muni naaŋ haŋgi foloŋ uŋgoŋ deikiŋ. ");
INSERT INTO nop_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ala kwet heleune Laban adi wabiŋiŋ laaŋiye yehisiŋgoŋgomeeŋ kahaŋ tiyemguk. Unduŋ tiyemiŋa biyabuŋa yolide udaneŋ mauguk. ");
INSERT INTO nop_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kaŋ Yakobo adi maaŋ undugoŋ yolide uguk. Wooŋ Bepaŋ’walaŋ aŋelo hekidut talipmeŋ kimindegiŋ. ");
INSERT INTO nop_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kaŋ Yakobodi yabuŋa yoguk, “Yoŋ adi Bepaŋ’walaŋ memikŋiye’walaŋ hamuhe!” Unduŋ yoŋa kwet wondiniŋ wou Mahanaim yoguk. ");
INSERT INTO nop_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Biyagoŋ kuyoŋ, Yakobo’walaŋ dali Esau adi Sea kwet u Edom kwet wapumneŋ uŋoŋ itouluguk. Ala Yakobo adi tipilapilaye me yehidaneŋ yameune koom ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Tiŋa indiŋ yeniŋguk, “Hidi bomboŋgine Esau indiŋ nineeŋ, Tipilapilayege Yakobo adi indiŋ yolak. ‘Nu kwet kwatnaŋgoŋ Labandut hati-talabugut ");
INSERT INTO nop_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","tiŋa nu dompa makau, doŋki, tipilapilaye metam yabukahilegut. Doktiŋa, bomboŋgine, du me not tinamben yoŋa mede i kamewene ulak.’” ");
INSERT INTO nop_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kaŋ tipilapilaye me adi wooŋ udaneŋ buŋa Yakobo indiŋ niŋgiŋ, “Indi dake Esau agaŋ kamun. Adi agaŋ talipmeŋ gabene me 400dut bulak.” ");
INSERT INTO nop_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobo adi munta kisaŋ tiŋa welemulap wapum hinek nadiguk. Unduŋ doktiŋa meeniŋiye, eŋ dompa makauŋiye, eŋ kameleŋiye yehidaneune bop lufom tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Woŋ adi indiŋ yoŋa tuguk, “Esau adi bop niŋ udihiluwek kaŋ bop niŋ kedem momoŋ uneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Unduŋ tiŋa Yakobo adi indiŋ yoŋa Bepaŋ ninadiguk, “O Wapum, batne papane Abalaham eŋ Aisak’walaŋ Bepaŋ, biyagoŋ kuyoŋ, du indiŋ naniŋguŋ. Du yoke mebineŋ eŋ naŋgat dikigeye hatiineŋ udaneŋ uune nu gehitubulodawaat. ");
INSERT INTO nop_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Du tipilapilaye mege fofoŋnit nu siloŋ tobogoŋ tinamuŋa yofolokge didimeniŋ keleeŋ nehitubulodaguŋ. Nu adi kuyaŋne hogok maliŋa Yodan ime i meŋeŋa ugut. Yoŋ adi kisaŋ ulihakaaŋ buŋa daneeŋ bop lufom tilat. ");
INSERT INTO nop_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ale du yahehewenamuŋa datne’walaŋ kohoŋ ginaŋniŋ nehikibidaleŋ. Adi buŋa na eŋ wapmihineye eŋ meehiye wanaŋ nindihikumumbaakneŋ yoŋa muntalat. ");
INSERT INTO nop_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Biyagoŋ kuyoŋ, dagoŋ hinek indiŋ yoguŋ. Nu gabudokooŋ kahaŋ tigamuŋa yalakigeye yehitubuulihakawene kiŋ luhi ginaŋ ikiiŋ wondok tuwot tineeŋ, woŋ adi bop wapum hinek doktiŋa kunakunatdok tuwot mu tilak.” ");
INSERT INTO nop_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Unduŋ yoŋa nai uŋaniŋ Yakobo adi timiŋ domo deikuk. Heleune nemenemek tubumintamiŋguk u noli dali Esau welemomooŋ timindok indiŋ daneguk. ");
INSERT INTO nop_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Meme taamuniŋ 200 eŋ maaniŋ 20, agaŋ dompa taamuniŋ 200 eŋ maaniŋ 20, ");
INSERT INTO nop_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamele nom kahikiiŋ mihiniŋnit 30, eŋ makau taamuhi 40, eŋ maahi 10, agaŋ doŋki tamuhi 20 eŋ maahi 10. ");
INSERT INTO nop_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nemek woŋ e bop molomolom tipilapilaye meŋiye yemiŋa yoguk, “Hidi talitimeŋ tinamuŋa kale bop molomolom yanagila uneŋ, bop kubugoŋ adi mu uneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Eŋ timeŋ uguk adi indiŋ niŋguk, “Datne Esaudi gehitubumintaaŋ ganinadiwek, ‘Du needi’walaŋ tipilapilaye me eŋ daŋgoŋ weŋ eŋ nemek timeŋ ulak i nedi’walaŋ?’ ");
INSERT INTO nop_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Unduŋ ganinadiune indiŋ yobeŋ, ‘U yadi tipilapilayemege Yakobodi bomboŋgine Esau du siloŋ tigamdok kameune bulak, tiŋa nadilaŋ be, ne adi mindaŋ bulak.’” ");
INSERT INTO nop_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Biyagoŋ kuyoŋ, kale bop yabudoko kunakunat 2, eŋ kale bop yabudoko kunakunat 3, eŋ kale bop noli yabudokooŋ ugiŋ adi hogohogok mede uŋakoŋ yenindapmaaŋ yoguk, “Hidi Esaudut kimindeŋa unduŋ nineŋ. ");
INSERT INTO nop_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tiŋa indiŋ tomboyoula yoneŋ, ‘I nadiweŋ, tipilapilaye mege Yakobo adi mindaŋ bulak.’” Yakobo adi indiŋ nadisuŋa unduŋ tuguk. Wele nadifodok siloŋ boiwene uune Esaudi yabuŋa weleŋ kwelemalune wooŋ kawene menot tinambek. ");
INSERT INTO nop_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Unduŋ nadisuŋa wele nadifodok siloŋ boiune timeŋ ugiŋ. Ne adi timiŋ kwet daŋgoŋ houle yot maaŋ ikiŋneŋ uŋgoŋ deikuk. ");
INSERT INTO nop_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kaŋ Yakobo adi kwet mu helehautalune mambimambipde pilaliŋa tamŋiyat eŋ tipilapilaye tam lufom eŋ mihiŋiye 11 u yanagila Yabok ime wohiŋgoŋ foloŋ meŋegiŋ. ");
INSERT INTO nop_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Adi wapmihiŋiŋ tam yehitubulodaune meŋedapmaune bomboŋŋiŋ hogohogok moŋgola looŋ ime fokolok boidapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakobo ne adi ime fokolok udaneeŋ looŋ hakuk. Hatune me niŋ mintaune adut kiwobu tulune helemiŋ dobuguk. ");
INSERT INTO nop_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Kaŋ me wondi Yakobo’walaŋ saŋiniŋ ula tiŋa fofondok mooŋ tikaaŋ baaŋ kahipuhindaguk. Unduŋ tubune Yakobo adi me woondut kiwobu tulune Yakabo gadiŋiŋ teleguk. ");
INSERT INTO nop_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Unduŋ tiŋa me woondi indiŋ niŋguk, “Helegap kamelak ale binaabeŋ.” Kaŋ Yakobodi mede indiŋ tubuudanemiŋguk, “Hogok adi mu bigaabit, kahaŋ tinambeŋ kaŋ bigaabit.” ");
INSERT INTO nop_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kaŋ me wondi ninadiguk, “Du woho needigoŋ?” Yobune adibo yoguk, “Yakobo.” ");
INSERT INTO nop_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kaŋ yoguk, “Du’walaŋ woho Yakobo wabiŋa Isilae yodok. Biyagoŋ kuyoŋ, du Bepaŋdut eŋ meeniŋdut kiwobu tiŋa wanaŋ fafaŋeŋaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kaŋ Yakobodibo ninadiguk, “Mu yolaŋ! Du’walaŋ woho needigoŋ?” Adibo yoguk, “Du maŋgoŋde wootnaanedok yonadilaŋ?” Unduŋ yoŋa uŋgoŋ kahaŋ timimiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Unduŋ doktiŋa Yakobodi kwet u wou Peniel yoguk. Woŋ adi indiŋ yoŋa yoguk, “Nu Bepaŋ namandatnedi kika kika hinek tumut iŋgoŋ e hatihatine mu tubuliweŋak.” ");
INSERT INTO nop_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Unduŋ tiŋa Peniel kwet u bikabu ulune mele labuguk. Yakobo adi gaadiŋiŋ teleguk doktiŋa kayoŋ taŋ tiŋa uguk. ");
INSERT INTO nop_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kaŋ me woondi Yakobo baaŋ kahipuhiindaguk doktiŋa Isilae me adi kale baaŋ diniŋ sulusulu baaŋ foloŋ gaaliŋa yatak u mu nayagiŋ eŋ indindegoŋ maaŋ mu naiŋ. ");
INSERT INTO nop_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kaŋ Yakobo adi dawi diweune uune Esau eŋ meeŋiye 400di bulune yabuguk. Yabuŋa wapmihi yehidaaneeŋ Lea eŋ Lesel eŋ tipilapilaye tam lufom adut yapmeguk. ");
INSERT INTO nop_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Tiŋa tipilapilaye tamyat adi wapmihihiyedut timeŋ yapmeguk, agaŋ Lea eŋ wapmihiŋiye, eŋ Lesel eŋ Yosep adi e mindaŋ hinek yapmeguk. ");
INSERT INTO nop_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nee adi timeŋ wooŋ mulelem timiŋa pilalune nai 7 tubune dali’walaŋ usuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kaŋ Esau adi weneŋgeila Yakobo kawene uguk wooŋ toboguk. Tobooŋa kohoŋ boboli foloŋ kuumaaŋ siŋgoŋgomeguk. Unduŋ tiŋa maat kookumuk. ");
INSERT INTO nop_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Unduŋ tiŋa Esau dawi diweeŋ wapmihi tam yabuguk yabuŋa yoguk, “I neediyeŋ dukut biiŋ?” Yakobodibo yoguk, “Biyagoŋ kuyoŋ. Bepaŋdi welesiloŋŋiŋ doktiŋa tipilapilayemege nu siloŋ tinamguk.” ");
INSERT INTO nop_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Unduŋ yobune tipilapilaye tamyat eŋ wapmihihiye buŋa mulelem timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Adi’walaŋ sigineŋ Lea eŋ wapmihiŋiyedi buŋa mulelem timiŋgiŋ. Mindaŋ hinek Yosep eŋ Lesel adi maaŋ buŋa mulelem timiŋgumuk. ");
INSERT INTO nop_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Kaŋ Esaudi indiŋ yonadiguk. “Me eŋ kale bop talipmeŋ uune yabuŋat u maŋgoŋ titindok yolaŋ.” Yakobodibo mede indiŋ tubuudaneguk, “Bombooŋgine, du yabuŋa menot tinambeŋ yoŋa boiŋat.” ");
INSERT INTO nop_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaudibo yoguk, “Kwayane, nu na’walaŋ fee hatinamiiŋ, unduŋ doktiŋa nemek hakaamulak u daatok halek.” ");
INSERT INTO nop_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kaŋ Yakobodibo yoguk, “Mooŋ, du nutok nadinambuune utumbaune siloŋne u fiit moŋgoleŋ. Du menot tinamŋa mik mu tinamuŋaŋ kaŋ gaabeene namandake Bepaŋ’walaŋ namanda nabugoŋ tiŋak. ");
INSERT INTO nop_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ale siloŋ tigamuŋat u kedem moŋgoleŋ. Bepaŋ adi welesiloŋŋiŋ doktiŋa siloŋ tinamguk doktiŋa fee hinek hatnamlak.” Unduŋ yoŋa gigine tubune fiit moŋgokuk. ");
INSERT INTO nop_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Unduŋ tiŋa Esaudi yoguk. “Agaŋ ale pilalune une, nu gehitubulodawene udim.” ");
INSERT INTO nop_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Iŋgoŋ e, Yakobodibo niŋguk, “Bombooŋgine, du agaŋ nadilaŋ. Wapmihi adi kuyahi hogohogok. Eŋ dompa makau mihihi adi nom naiŋ. Unduŋ doktiŋa melenai kubugoŋ pilap uundok yeniŋgiginewe wooŋ gweheye tiŋa kumuneeneŋ. ");
INSERT INTO nop_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Unduŋ doktiŋa bombooŋgine du kedem koom weŋ. Kaŋ nu adi kale eŋ wapmihi saŋiniŋhikdok tuwolit ulune yamaadi yale wene uge uge du hatilaŋneŋ Sea yokwetneŋ usuwawaat.” ");
INSERT INTO nop_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kaŋ Esaudi yoguk, “Unduŋ yolaŋ ale mewoi nukuut hatiiŋ i neeŋ yamewene gehitubuloodaŋ hanagila uneŋ.” Yakobodibo yoguk, “U maŋgoŋde? Nu yadi not momooŋ tinambeŋdok hogok yolat.” ");
INSERT INTO nop_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kaŋ Esau adi nai uŋaniŋ udaneŋ wooŋ Sea yokwetneŋ usuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakobo adi adi Sukot yokwetneŋ wooŋ yoli uŋoŋ maguk, tiŋa kaleŋiye’walaŋ yohalaŋ maaŋ mayemguk. Unduŋ tiŋa yokwet u wou Sukot yoguk. ");
INSERT INTO nop_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakobo adi Padan Alamniŋ folooŋ kwelemaaŋgoŋ udaneŋ buge buge Sekem yokwetneŋ, Kanaaŋ kwet wapumneŋ busuwaaŋ yokwet gagayeŋ itouguk. ");
INSERT INTO nop_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tiŋa Sekem beu’walaŋ mihiŋiye adi’walaŋ kwet muneeŋ 100di tuwaŋ houle yot uŋgoŋ maaŋ itouguk. ");
INSERT INTO nop_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Unduŋ tiŋa uŋgoŋ alata niŋ tutumbaaŋ wou indiŋ yoguk, Bepaŋ adi Isilae’walaŋ Bepaŋ. ");
INSERT INTO nop_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leadi Yakobodok wabi niŋ nagikuk wou Dina, adi heleŋ yohiwahi wabi noliŋiye yabene uguk. ");
INSERT INTO nop_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kaŋ kwet uŋaniŋ me bombooŋgi Hiwaitniŋ me Hamoa adi’walaŋ mihi Sekem adi wabi u kaguk tiŋa nagila wooŋ adut deila tubukadakaguk. ");
INSERT INTO nop_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tiŋa weleeŋdi kahileeŋ menot timiŋa mede momooŋ niŋguk. ");
INSERT INTO nop_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tiŋa beu Hamoa indiŋ niŋguk, “Du wabi i tamne titindok mede kwanai tibeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo adi wabiŋiŋ tubukadakaŋit wondiniŋ mede kahat agaŋ nadiguk iŋgoŋ mihiŋiye adi kale yabudoko tine ugiŋ doktiŋa mede u hogok kameune hakuk. ");
INSERT INTO nop_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kaŋ Sekem beu Hamoa adi Yakobodut mede yodok uguk. ");
INSERT INTO nop_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kaŋ Yakobo mihiŋiye adi tebele kwanai ginaniŋ busuwaaŋ Sekemdi wihik tubukadakaaŋ Isilaehi’walaŋ lekiŋgoŋhik foloŋ kudi meekaŋgoŋ tuguk mede kahat u nadiŋa welehik kadakaune kwihita tigiŋ. Biyagoŋ kuyoŋ, adi adi nemek mu titindok tuguk. ");
INSERT INTO nop_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamoa adi adi indiŋ yeniŋguk, “Mihine Sekem adi weleeŋdi kahile hinek tilak doktiŋa fiit nadimimbuune tamŋiŋ nagilek. ");
INSERT INTO nop_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kaŋ indiguut hekinamuŋit tiyaneem, hidi wabihiye nimiŋa kibi hidibo indi’walaŋ wabiniye yeheŋeyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Unduŋ tiŋa indut itouŋa hidi maaŋ kwet yendok moloom tineeŋ. Unduŋ doktiŋa kwet iŋoŋ kwanai tiŋa iŋgoŋ fafaŋeniŋ itouyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kaŋ Sekem adi Dina beu eŋ wiwiye indiŋ yeniŋguk, “Hidi fiit nadinamuneŋ! Tiŋa yoneŋ wondok tuwolit hambit. ");
INSERT INTO nop_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Hidi tam tuwaŋiŋ tiŋa looŋ kale bomboŋ feedok yoneŋ iŋgoŋ oŋ, nu wondok tuwolit kamewit. Ale wabi woŋ adi nam hinek tineŋ kaŋ nagilit.” ");
INSERT INTO nop_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kaŋ Sekem adi wiihik Dina tubukaadaka tuguk doktiŋa Yakobo mihiye adi Sekem eŋ beu Hamoa medehik tubuudaneyemŋa yalaŋ e indiŋ yeniŋgiŋ, ");
INSERT INTO nop_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Indi me niŋ sigiiŋ diki gitnem mu dobukukuk adi wiitnik mu mineem. Nemek undiniŋ woŋ adi indi’walaŋkade meekaŋgoŋ tilak. ");
INSERT INTO nop_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Unduŋ dotiŋa indiŋ tubune nadihamunee tuwot tibek. Hidi indi tiyam unduŋ tiŋa me hogohogok sigihik diki gitnem dobukutneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Unduŋ tubune wabiniye kedem hamuneem, eŋ indi maaŋ hidi’walaŋ wabihiye kedem yanagitnee. Unduŋ tiŋa hidiguut tomboyoulaŋa mebop kubugoŋ tineem. ");
INSERT INTO nop_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Eŋ mede wobu tiŋa mede haniyam i mu tiŋa folohik ginaŋ fek mu tineeŋ adi wabinik nagila yokwet i bikabuŋa niŋkade uneem.” ");
INSERT INTO nop_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kaŋ Hamol eŋ mihiŋiŋ Sekem adi medehik nadiune tuwot tuguk. ");
INSERT INTO nop_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Kaŋ Sekem adi unduŋ nadibedi mu tuguk, biyagoŋ kuyoŋ, adi Yakobo wabiŋiŋ kahiloda hinek tuguk eŋ meeŋimeeŋiye adi Sekemdok nadiune loloŋnit tuguk. ");
INSERT INTO nop_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kaŋ Hamol eŋ mihiŋiŋ Sekem adi yohikwehineŋ udaneeŋ wooŋ bop yotneŋ looŋ me uŋaahi indiŋ yeniŋgumuk, ");
INSERT INTO nop_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Me yoŋ adi kwelemaahi doktiŋa kwetnineŋ hatiŋila kwanaihik titindok yenindapmaneem. Kwet wapum hogok haale ulak ale tuwot hatineeŋ. Unduŋ tiŋa indi wabihiye kedem yeheŋeneem. Eŋ kibi indibo wabiniye aditok yemineem. ");
INSERT INTO nop_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Adi adi nemek indiŋdok hogok nadinimiŋa iŋoŋ indiguut hatiŋa indiguut kiula bop kubugoŋ tiŋa hatidok yoiŋ. Nehi sigihik diki gitnem dobukut tigiŋ undugoŋ indi’walahi me hogohogohok indi maaŋ unduŋ titindok niniŋit. ");
INSERT INTO nop_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Unduŋ tinene dompa makauhiye eŋ bomboŋhik hogohogok u maaŋ inditok tineeŋ. Unduŋ doktiŋa yenindapmanee indut itouyaneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kaŋ me yohiwaahi hogohogok adi Hamol eŋ mihiŋiŋ Sekem medehik nadiune tuwot tubune sigihik diki gitnem dobukukiŋ. ");
INSERT INTO nop_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Unduŋ tiŋa mewoi adi melenai lufomkulitniŋ folofigita nadi haakiŋ. Kaŋ biyagoŋ kuyoŋ, Yakobo mihiŋiyat Simeoŋ eŋ Lewi, Dina’walaŋ wiiyat adi mik diniŋ noŋ maŋiŋ kweheyehi moŋgola looŋ me kwehi waahi widihidapmaŋ tugumuk. ");
INSERT INTO nop_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamoa eŋ mihiŋiŋ Sekem wanaŋ widihikumuŋa Dina Sekem’walaŋ yolineŋ ikuk woodi tiŋa fooŋ nagila ugumuk. ");
INSERT INTO nop_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Kaŋ Yakobo’walaŋ mihiwoi nolidi wooŋ me widihikumuŋ tigiŋ adi’walaŋ bomboŋ eŋ yokwet wondiniŋ bomboŋ kubo tigiŋ. Woŋ adi wiihik tubukadakagiŋ doktiŋa unduŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tiŋa dompa makau eŋ donkihiye yopmaŋ hatigiŋ eŋ kwanai ginaŋ hatigiŋ u bumbut yanagidapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Unduŋ tiŋa bomboŋhik eŋ wapmihitam u wanaŋ yanagila ugiŋ. Biyagoŋ hinek yopmaŋ nemek hakuk hogohogok u kubo moŋgodapmaaŋ moŋgola maugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Unduŋ tubune Yakobodi Simeoŋdut Lewi indiŋ yeniŋguk, “Hidi kwet molohiye Kanaaŋ eŋ Pelisait me adi’walaŋ namandahik foloŋ nu’walaŋ wootnene tubukadakaaŋ kotigoŋ wohiŋkade nemek wapum moŋgolune loŋak. Nu adi mewoine lufom kabe hatiiŋ, ala adi kitubuloda tiŋa buŋa nindihiune nu eŋ maanemaaneye kadaka hinek tinim.” ");
INSERT INTO nop_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Kaŋ adibo yogumuk. “Kaŋ dediŋ! Adi wiitnik talik tam nabugoŋ mube timiŋguk ale!” ");
INSERT INTO nop_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kaŋ Bepaŋdi Yakobo indiŋ niŋguk, “Pilap hinek tiulidokooŋ Betele yokwetneŋ looŋ uŋoŋ itouluwaaŋ. Biyagoŋ hinek, daake Esaudok muntaaŋ momoolune Bepaŋdi mintagamguk uŋgoŋ Bepaŋdok alata niŋ tutumbamimbaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Unduŋ nimbuune Yakobodi meeŋimeeŋiye eŋ me adut hatiyagiŋ adi indiŋ yenindapmaguk, “Hidi’walaŋ lekiŋgoŋhik ginaŋ welewele bepaŋ yalayalaŋ beehatiiŋ u beekulune uune sigihik tubuwalandaaŋ dahidahihik walaniŋ kadahineŋ. ");
INSERT INTO nop_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Unduŋ tiŋa pilale Betele yopmaŋde loneŋ. Nu gooliŋgooliŋ ginaŋ hatiluene nadinamuŋa nehitubulodaŋ talipmeŋ yahehewe tinamguk, Bepaŋ aditok alata niŋ tutumbamimbaat.” ");
INSERT INTO nop_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Unduŋ yenimbuune nemek welewele bepaŋ yalayalaŋ eŋ maagisuwaŋ heki u beeŋa buŋa Yakobo mimbuune Sekem yokwet gagayeŋ bem muŋgohom niŋ yakuk wondiniŋ mebineŋ wenefulaguk. ");
INSERT INTO nop_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Unduŋ tiŋa pilale logiŋ. Kaŋ yokwet maagi maagi ila ugiŋ adi Bepaŋdok munta tiŋa deeti Yakobo eŋ mihiye udihi yahakalineetigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Biyagoŋ kuyoŋ, Yakobo eŋ meeŋimeeŋiye neet hatiyagiŋ adi Kanaaŋ kwetneŋ Lus yopmaŋ Betele uŋoŋ wanakaŋ hogohogok usuwagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Usuwaaŋ Yakobo adi alata niŋ tutumbaaŋ wou El Betele youkuk. Biyagoŋ kuyoŋ, adi dalidok muntaaŋ momooŋ ulune Bepaŋdi uŋgoŋ mintamiŋguk doktiŋa unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kaŋ Lebeka’walaŋ tubuloda tam wou Debola adi uŋgoŋ kumumbuune Betele yokwet hapmeeneŋ bem muŋgohom mebiyeŋ wenefulagiŋ. Unduŋ tiŋa bem wou Allom Bakut yoguk indi’walaŋ mede foloŋ kobulabulaye muŋgohom. ");
INSERT INTO nop_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kaŋ Yakobo adi Paddan-Alam kwetneniŋ busuwaaŋ hatilune Bepaŋdi kotigoŋ mintamiŋa kahaŋ timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Tiŋa indiŋ niŋguk, “Du woho Yakobo, ala Yakobo kotigoŋ mu yodok adi Isilae yodok.” Unduŋ yoŋa Isilae yoguk. ");
INSERT INTO nop_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Tiŋa Bepaŋdi tomboyoula niŋguk. “Nu Bepaŋ saŋiniŋ moloom, du fee mintaaŋ ulihaka tibaaŋ, eŋ du mebop kubugoŋ mooŋ meeniŋ bop mohok mintatauneeŋ. Tiŋa undugoŋ mapme heki adi du’walaŋ folooge ginaniŋ mintaneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kaŋ Abalaham eŋ Aisak kwet yemgut u dutok gambaat. Eŋ kougoŋ yalakigeye mintaaŋ hatineeŋ adi maaŋ yembaat.” ");
INSERT INTO nop_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kaŋ Bepaŋ adi Yakobodut yale mede yonadi tugumuk kwet uŋgoŋ yakaane loguk. ");
INSERT INTO nop_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Unduŋ tubune Yakobo adi Bepaŋdi kwet yale mede niŋgukneŋ uŋgoŋ kawade niŋ tiŋa fek kambiyale wondok foloŋ siloŋ muni boiŋa ime wahu munduŋnitdi yougoomguk. ");
INSERT INTO nop_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Unduŋ tiŋa Bepaŋdi kwet yale mede niŋguk wondiniŋ wou Betele yoguk. ");
INSERT INTO nop_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Unduŋ tiŋa Beteleniŋ pilaliŋa kotigoŋ ugiŋ. Taalik wooŋ Efalat ususadok kabe tamaigoŋ hatuune Lesel adi mihi nadiguk. Tiŋa tubumulahuda tuguk. ");
INSERT INTO nop_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mihi nagitdok tubumulahuda hinek tubune tam mihi uloloŋ timiŋgukdi indiŋ niŋduk, “Du munta mu tibeŋ. Mihi noli maaŋ nagitaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kumumbeene munabudapmandok tiŋale mihi wou Ben-Oni youla kumuŋguk. Iŋgoŋ oŋ beu adi wou Benyamin youkuk. ");
INSERT INTO nop_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Biyagoŋ kuyoŋ Lesel kumumbuune Efalat talipmeŋ wenegiŋ (yokwet wou noli Betlehem). ");
INSERT INTO nop_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kaŋ Yakobo adi Lesel sitŋiŋ ginaŋ kawade niŋ fek kambiyakuk. Kawade woondi Lesel sit ŋiŋ diniŋ fek ikukdi itak. ");
INSERT INTO nop_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kaŋ Isilae adi talik kotigoŋ tomboyoula uge uge Migola Edel yot kweheyeniŋ guŋaandiŋ usuaaŋ houle yotŋi maguk. ");
INSERT INTO nop_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tiŋa kwet uŋoŋ itoulune Luben adi beudi tiplapilaye tam niŋ tamŋiŋ nagikuk wou Bilha yolineŋ looŋ adut deikumuk. Kaŋ Isilae adi u nadiŋa kwihita-tuguk. Yakobo adi mihiŋiye 12: ");
INSERT INTO nop_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea mihiye: Me tuwo Luben, Simeon, Lewi, Yuda, Isaka eŋ Sebulun. ");
INSERT INTO nop_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Lesel mihiŋiye: Yosep eŋ Benyamin. ");
INSERT INTO nop_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Lesel’walaŋ tipilaye tam Bilha’walaŋ mihiŋiye: Dan eŋ Naftali. ");
INSERT INTO nop_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea’walaŋ tipilapilaye tam Silpa’walaŋ mihiŋiye: Gad eŋ Ase. Yoŋ adi Yakobo mihiŋiye Paddan-Alam kwetneŋ hatilune mintamiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo adi Mamele kwetneŋ beu yolineŋ Kiliat Aba wou noli Hebulon ungoŋ wosuwaguk. Biyagoŋ kuyoŋ, Abalaham eŋ Aisak adi yokwet uŋgoŋ itougumuk. ");
INSERT INTO nop_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisak adi guletŋiŋ 180 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Adi hatige hatige me gawadaaŋ hinek tiŋa kumuŋa beu papaaŋiyedut tomboyoukuk. Kaŋ mihiŋiyat Esau eŋ Yakobodi wenefulagumuk. ");
INSERT INTO nop_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Yoŋ adi Esau, wou noli Edom, adi’walaŋ mede kahat, tiŋa adi yalakiŋiye’walaŋ wouhik habet. ");
INSERT INTO nop_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau adi tamŋiye Kanaaŋhi wabiheem lufomkulitniŋ yeheŋeguk. Niŋ e Ada Hitaitniŋ me Elon adi’walaŋ wabiŋiŋ, eŋ noli e Hiwaitniŋ me Sebeoŋ mihiŋiŋ Ana’walaŋ wabiŋiŋ wou Oholibama, ");
INSERT INTO nop_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","tiŋa niŋ e Isimael’walaŋ wabiŋiŋ, wou Basemat, Nebayot’walaŋ wiwi. ");
INSERT INTO nop_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Kaŋ Adadi Elifas nagikuk, Basematdi Leguel nagikuk, ");
INSERT INTO nop_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","eŋ Oholibama adi adi Yeusi, Yalam eŋ Kola yeheŋeguk. Biyagoŋ kuyoŋ, Esau’walaŋ mihiŋiye Kanaaŋ kwetneŋ unduŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kaŋ Esau adi tamŋiye eŋ wapmihiŋiye eŋ metam noli adi’walaŋ yolineŋ itouyagiŋ, eŋ bomboŋ hogohogok, eŋ dompa makau eŋ nemenemekŋiŋ noli Kanaaŋ kwetneŋ hatiŋa yehitubumintaguk u moŋgodapmaaŋ kwayaŋ Yakobo bikabuŋa Sea kwet mauguk. ");
INSERT INTO nop_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kale bomboŋhik fee doktiŋa wanakaŋ itoudok nadiune mulahudaguk, tiŋa makauhiye maaŋ fee doktiŋa buŋambu kwetneŋ hatigumuk u aditok tuwolit mu tuguk. ");
INSERT INTO nop_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Biyagoŋ kuyoŋ, Esau wou noli Edom adi unduŋ tiŋa Sea kwet haŋgi haŋgi uŋoŋ wooŋ itouluguk. ");
INSERT INTO nop_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Kaŋ yoŋ adi Esau’walaŋ yalakiŋiye Edom me Sea kwet haaŋgi haaŋgi uŋoŋ looŋ itouyagiŋ adi’walaŋ mede kahat. ");
INSERT INTO nop_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau yalakiŋiye’walaŋ wouhik habet indiŋ hinek hatak. Yoŋ adi Esau dut Ada mihihik wou Elifas. Agaŋ Esau dut Basema mihihik Leuel. ");
INSERT INTO nop_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas mihiŋiye adi indiŋ: Teman, Omal, Sefo, Gatam eŋ Kenas. ");
INSERT INTO nop_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esau mihiŋiŋ Elifas adi tam niŋ wou Timna hogok nagila hatibuune mihi nagilimiŋguk wou Amalek. Kaŋ yoŋ adi Esau tamŋiŋ Ada adi’walaŋ laaŋiye. ");
INSERT INTO nop_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Yoŋ adi Leuel mihiŋiye: Nahat, Sela, Sama, eŋ Misa. Adi adi Esau tamŋiŋ Basema’walaŋ laaŋiye. ");
INSERT INTO nop_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau tamŋiŋ Oholibama, Ana wabiŋiŋ eŋ Sibeoŋ laaŋ, adi Yeus, Yalam, eŋ Kola yanagikuk. ");
INSERT INTO nop_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Yoŋ adi Esau yalakiŋiyedi me loloŋ hinit mintaaŋ hatigiŋ. Esau’walaŋ mihi biyeniŋ Elifas adi’walaŋ mihiŋiye me loloŋnit hatigiŋ wouhiye indiŋ: Teman, Omal, Sefo, Kenas, ");
INSERT INTO nop_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kola, Gatam eŋ Amalek. Yoŋ adi Elifas mihiŋiye Edom kwetneŋ me loloŋ hinit hatigiŋ. Adi adi Ada’walaŋ laaŋiye. ");
INSERT INTO nop_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau mihiŋiŋ Leuel’walaŋ mihiŋiyedi me loloŋnit hatigiŋ wouhiye indiŋ: Nahat, Sela, Sama eŋ Missa. Adi adi Leuel’walaŋ yalakiŋiyedi Edom kwetneŋ me loloŋnit hatigiŋ. Ala adi adi Basemat’walaŋ laaŋiye. ");
INSERT INTO nop_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau tamŋiŋ Oholibama adi’walaŋ miihiŋiye indiŋdi me loloŋnit hatigiŋ: Yeus, Yalam eŋ Kola. Oholima adi adi Ana’walaŋ wabiŋiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Yoŋ adi Esau (wou noli Edom) adi’walaŋ yalakiŋiye adi me loloŋnit hatigiŋ diniŋ habet. ");
INSERT INTO nop_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Eŋ yoŋ adi Sea mihiŋiye Holait me kwet uŋoŋ itouyagiŋ: Lotan, Sobal, Sibeon, Anah, ");
INSERT INTO nop_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Esel eŋ Disan. Sea Edom niŋ me’walaŋ mihiŋiye indiŋdi me loloŋnit hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan mihiŋiye: Holi eŋ Hemam. Timna adi Lotan’walaŋ wiwi. ");
INSERT INTO nop_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal mihiŋiye: Alwan, Manahat, Ebal, Sefo eŋ Onam. ");
INSERT INTO nop_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon mihiŋiye: Aia eŋ Ana. Ala Ana adi kougoŋ hatigane kwet himintaaŋ ginaŋ beu Sibeon’walaŋ doŋki yanagila nanaŋe ime kaliŋ hatiyaugaane ime daawii niŋ kudut labulak tubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana’walaŋ wapmihiŋiye: Dison, eŋ Oholibama Ana’walaŋ mihiŋiŋ wabiŋiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison’walaŋ mihiŋiye: Hemdan, Esban, Itlan eŋ Kelan. ");
INSERT INTO nop_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esel mihiŋiye: Bilhan, Sawaan eŋ Akan. ");
INSERT INTO nop_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan mihiŋiye: Us eŋ Alan. ");
INSERT INTO nop_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Me loloŋhiŋit yoŋ adi Holaithi: Lotan, Sobal, Sibeon, Anah, ");
INSERT INTO nop_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Esel eŋ Disan. Me loloŋhiŋit wouhiye mintaŋak yoŋ adi mebop fee hatitaugiŋ indigoŋ tuwot mintaaŋ hatiŋa Sea kwetneŋ Holait heki yabulidokogiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Maapme kwanai woŋ adi Isilaehidi mu tububihituune Edomhidi timeŋ tububihila kwanainegiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beol mihiŋiŋ Bela adi Edomhi’walaŋ mapme tuguk. Yokwet wapumŋiŋ wou Dinhaba. ");
INSERT INTO nop_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela kumumbuune Selah mihiŋiŋ Yobap adibo kwelikoŋ tiŋa mapme ikuk (Selah adi Boslaniŋ.) ");
INSERT INTO nop_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab kumumbuune Teman kwetneniŋ me wou Husan adibo kwelikooŋ tiŋa mapme ikuk. ");
INSERT INTO nop_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husan kumumbuune Bedad mihiŋiŋ Hadad Midienhi Moab haŋgi foloŋ widihi kwaaneguk adibo kwelikooŋ tiŋa mapme ikuk. Adi’walaŋ yokwet wapum wou Awit yogiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad kumumbuune Maslekaniŋ me Samla adibo kwelikooŋ tiŋa mapme ikuk. ");
INSERT INTO nop_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla kumumbuune Lehobot ime foloŋ ikagiŋ uŋaniŋ meniŋ wou Saul adibo kwelikooŋ tiŋa mapme ikuk. ");
INSERT INTO nop_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul kumumbuune Akbo mihiŋiŋ Baal-Hanan adibo kwelikooŋ tiŋa mapme ikuk. ");
INSERT INTO nop_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbo mihiŋiŋ Baal-Hanan kumumbuune Hadaddibo kwelikooŋ tiŋa mapme ikuk. Adi’walaŋ yokwet wapum wou Pau. Eŋ tamŋiŋ wou Mehetabel, Matled wabiŋiŋ, Matled adi Mesahab wabiŋiŋ. ");
INSERT INTO nop_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Kaŋ yoŋ adi Esau’walaŋ yalakiŋiyedi me loloŋnit tiŋa metam bop hatitaugiŋ tuwot yabuulidokogiŋ: Timna, Alwa, Yetet, ");
INSERT INTO nop_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO nop_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mipsa, ");
INSERT INTO nop_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel eŋ Ilam. Yoŋ adi Edomhi’walaŋ mebop itouŋa ugiŋ indigoŋ tuwot me loloŋnit ilaŋa yabuulidokotaugiŋ. Biyagoŋ hinek, yoŋ adi Esau Edomniŋ’walaŋ yalakiŋiye. ");
INSERT INTO nop_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo adi beudi Kanaaŋ kwet daŋgoŋ itoulugukneŋ uŋgoŋ itouguk. ");
INSERT INTO nop_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yoŋ adi Yakobo’walaŋ mede kahat. Yosep adi guletŋiŋ 17 tubune daliyedut dompa yabudoko kwanai tigiŋ. Biyagoŋ kuyoŋ, adi mekuya doktiŋa beu’walaŋ tamŋiyat Bilha eŋ Silpa adi’walaŋ mihihiyedut dompa yabudokoguk. Ala daliyedi maŋgoŋ kedem be hogoli tagiŋ u yabuŋa wooŋ behik nimbihit tuguk. ");
INSERT INTO nop_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isilae adi Yosep weleeŋdi kahile hinek tuluguk. Eŋ mihiŋiye noli adi wahiwahiŋgoŋ yabukahileeluguk. Isilae adi agaŋ me gawadaaŋ hinek tulune Yosep mintaguk doktiŋa weleeŋdi kahile hinek tuluguk. Unduŋ tiŋa yeguk e dahidahi kudikudinit houle momooŋ hinekdi tibineeŋ miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kaŋ daliye adi behikdi Yosep weleeŋdi kahile hinek tilak unduŋ kaŋ nadiŋa Yosepdok nadikadaka timiyagiŋ. Unduŋ tiŋa Yosepdut mede momooŋgoŋ mu toyagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nai niŋde Yosep adi lihine tiŋa daliye yeniŋguk. Yeenimbuune daliye adi kwihita kisaŋ hinek tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Adi indiŋ yeniŋguk, “Hidi maagihik mohinek kameeŋ lihine tiŋat i nadineŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Indi pandiŋ kwanai ginaŋ wooŋ pandiŋ ibi ibi tumun. Ala deebek tiŋa nu’walaŋ pandiŋ ibidi pilali koloŋ didimeniŋ yalak, eŋ hidi’walaŋdi pilale nu’walaŋ yakelemaadi tiŋa nu’walaŋ yalaŋakneŋkade duwookene tiŋa yaliŋit.” ");
INSERT INTO nop_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kaŋ daliyedi u nadiŋa yogiŋ, “Be dukuyembe loloŋnit tiŋa indi niibidokowaaŋ? Biyagoŋ hinek kube du mapme tiŋa niibiulidokowaaŋ?” Yosep adi lihine tiŋa mede yoguk wondok tiŋa daliye adi Yosepdok kwihita kisaŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Agaŋ nai nimbo lihine tiŋa daliye indiŋ yeniŋguk, “Lihine nimaaŋ tiŋat ale yobee nadineŋ. Lihine tiŋa kawene mele muyakip eŋ hinantilamek 11 adi nu duwokene tinamuŋit.” ");
INSERT INTO nop_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yosep adi lihine i daliye eŋ beehik yenimbuune nadiŋa beu adi nintoo tiŋa yoguk, “U maŋgoŋ lihine undiniŋ tiŋaŋ? Maaŋge eŋ naa eŋ daakeye indi biyagoŋ hinek kube du’walaŋ habaake foloŋ duwookeneŋ namandatnik kwet foloŋ tubuwopmoobutneem?” ");
INSERT INTO nop_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Daliye adi welehik gouye tuguk. Iŋgoŋ oŋ, beu adi nemenemek nadiguk u weleeŋ ginaŋ kabup nadidaheŋa boikwambundaaŋ hatiluguk. ");
INSERT INTO nop_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Agaŋ daliye adi behik’walaŋ kale yabudokoneene Sekemde ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Unduŋ doktiŋa Isilae adi Yosep indiŋ niŋguk, “Du agaŋ nadilaŋ daakeye adi Sekem gwaaŋ kale yabuulidoko tiiŋ. Ale buune ganiŋkuleene wooŋ yabeŋ.” Yosepdibo yoguk, “Oo u kedem.” ");
INSERT INTO nop_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Unduŋ yobune beudi indiŋ niŋguk, “Wooŋ dakeye kedem be hatiiŋ yabunadi tibeŋ eŋ kale heki maaŋ yabunadi tubudapmaaŋ buŋa mede kahat tinambuune nadiwaat.” Unduŋ niŋa Hebulon kwet gutuŋneniŋ niŋkulune uguk. ");
INSERT INTO nop_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sekem kwetneŋ usuwaaŋ daliye yolohi hatilune me niŋdi tubumintaaŋ ninadiguk, “Du maŋgoŋ lohilaŋ?” ");
INSERT INTO nop_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Adibo yoguk, “Nu daatneye yolohilat. Du kedem be daŋgoŋ hatiŋa kale yabuulidoko tiiŋ nanimbuune wooŋ yabit?” ");
INSERT INTO nop_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Me woondibo yoguk, “Adi iŋoŋ agaŋ wabiŋa ugiŋ. Nu indiŋ yoyagiŋ nadigut, ‘Indi Dotan de une.’ Alee uŋaŋ wooŋ yabeŋ.” Unduŋ doktiŋa Yosep adi mindaŋ yahakaleŋa wooŋ Dotan gagayeŋ yabuguk. ");
INSERT INTO nop_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Iŋgoŋ e adi yamaaŋgoŋ mu uguk kougoŋ kwatnaaŋgoŋ ulune daliyedi agaŋ kakiyodaaŋ uut titindok yofolok tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Lihine molo i maŋgoŋ bulak! ");
INSERT INTO nop_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Buune ula tobo tikutnene ime bom koomiineŋ fowek. Kaŋ indiŋ yonim kale fafaŋeniŋ miknit hinek niŋdi sikumuŋguk. Unduŋ tineene lihineŋiŋ diniŋ mebi dakalewaak.” ");
INSERT INTO nop_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Luben adi mede u nadiŋa kwayaŋiyedi Yosep mu ulukumuŋdok nadiŋa mooŋ yoguk. Luben adi indiŋ yoguk, “Haatihaatiŋiŋ mu tubuliwedok. ");
INSERT INTO nop_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Eŋ naŋgatŋiŋ mu kwaatnewek. Kwet fiileŋ boom siliiŋ ikiiŋneŋ iŋaŋ kuumanee fowek, eŋ ulukumuŋ adi mu titindok.” Luben adi indiŋ nadiguk kougoŋ kabup haman tibene labuune nagila beu’walaŋ wit. ");
INSERT INTO nop_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ala agaŋ Yosep busuwalat be yoguk e de! buŋa honeŋ dahidahiŋiŋ kudikudinit houle momooŋdi tibineemiŋgiŋ u kwihikulimiŋa ");
INSERT INTO nop_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","nagila wooŋ tobooŋa tukulune ime bom koomii ime silida tuguk siliineŋ foguk. ");
INSERT INTO nop_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Unduŋ tiŋa nanaŋe naneene fooŋ ikiŋ. Ilaŋa dauhik diweune uune Ismaelhi me bomboŋ kibikibi tineene Gilead yokwet bikabuŋa bugiŋ. Kamelehik foloŋ ime wahu munduŋnit eŋ bem gumamum eŋ nemek nanaŋe tubukobadok mehe heki undihi tiyoula tiulidokooŋ kamelehik foloŋ boiŋa moŋgola Isip kwetneŋ kibikibi tineene ugiŋ adi yabugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda adi pilale noliŋiye indiŋ yeniŋguk, “Indi kwayanik ulukumuŋa naŋgatŋiŋ youfulaŋa folooŋ maŋgoŋ moŋgotneem. ");
INSERT INTO nop_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ale pilap buune Ismaelhi yemineene tuwaaŋiŋ fukut nimineŋ. Eŋ ulukumuŋ adi mu tinim. Maŋgoŋde adi adi naŋgatnik diki, eŋ kwayanik, eŋ mehinek kubugoŋ.” Unduŋ yobune noliŋiye adi wele kubugoŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ala agaŋ Midienhi me bomboŋ hinit busuaune daliye wooŋ Yosep hamaneune labuune nagi wooŋ Ismaelhi me yemiŋa tuwaaŋiŋ fukut kunakunat 20 silwadok yogiŋ. Kaŋ Ismaelhi adi tuwaaŋ nagila Isipde ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Luben adi kougoŋ wooŋ Yosep bom ginaŋ be hatak yoŋa lohiguk iŋgoŋ e mooŋ. Unduŋ kaŋ mooŋ kaŋ Luben adi dahdahiŋiŋ kwihiŋa ulibaginekulaŋa ");
INSERT INTO nop_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","kwayaŋiye haakiŋneŋ wooŋ yoguk, “Mihi adi bom ginaŋ mu hatak! Nu diŋaandiŋ wooŋ kawit?” ");
INSERT INTO nop_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Unduŋ tiŋa mooŋkaŋ meme maaniŋ niŋ ulaŋa naŋgatŋiŋdi Yosep’walaŋ dahidahi foloŋ yougoombuune ");
INSERT INTO nop_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","naŋgatnit tubune tiŋa behik’walaŋ ugiŋ. Wooŋ yalaŋ indiŋ niŋgiŋ, “I baigoŋ kakoloodiweeŋ. Tiyauge mihige Yosep’walaŋ dahidahi nobu? Indi gwaaŋ tubumintaaŋ tiŋa baam.” ");
INSERT INTO nop_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakobo adi mihiŋiŋ Yosep’walaŋ dahidahi u kakiyondaaŋ yoguk, “Biyagoŋ hinek ya mihine’walaŋ dahidahi kudikudinit. Nemek kale fafaŋeniŋ eŋ miknitdi sikumuŋa sibulaaginekut tiŋak!” ");
INSERT INTO nop_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Unduŋ yoŋa Isilae adi dahidahiŋiŋ ulalagine kulaŋa bulaaniŋgoŋ diniŋ dahidahi dahiŋa mihiŋiŋ doktiŋa maat kobulabulaye melenai fee tuguk. ");
INSERT INTO nop_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wapmihiŋiye hogohogok buŋa niŋkwelemanim yo tigiŋ iŋgoŋ medehik mu nadiyemguk. Adi adi unduŋ yoguk, “Nu yadi mihinedok bulaaniŋgoŋ nadiŋa maat kobulabulaye tige tige kumumbaat.” Unduŋ yoŋa Yosep beu adi aditok tiŋa kobulabulaye tuguk. ");
INSERT INTO nop_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Isilae adi unduŋ tulune nai uŋaniŋgoŋ Midienhi adi Yosep nagila wooŋ Isip kwetneŋ me niŋ wou Potifa adut tuwagiŋ. Potifa adi mikme Felo ne kadokoyagiŋ, adi’walaŋ talitimeŋhik. ");
INSERT INTO nop_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nai uŋaniŋ Yuda adi kwayaŋiye biyabuŋa wooŋ Adulam yokwetneŋ me niŋ wou Hila adiguut hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ala uŋoŋ hatiŋa Kanaaŋniŋ me niŋ wou Sua adi’walaŋ wabiŋiŋ kaŋ tamŋiŋ nagilaŋa adiguut hatigumuk. ");
INSERT INTO nop_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kaŋ tam u mihiwele tiŋa mihi niŋ nagilune wou Ea youkuk. ");
INSERT INTO nop_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kaŋ hatigane kotigoŋ mihiwele tiŋa mihi iŋgoŋ nagila wou Onan youkuk. ");
INSERT INTO nop_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kootigoŋ mihiwele tiŋa mihi niŋbo nagila wou Sela youkuk. Mihi woŋ adi Kesip yokwetneŋ hatiŋa nagikuk. ");
INSERT INTO nop_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kaŋ Yuda adi hatigane mihiŋiŋ biyeniŋ Ea-dok tam niŋ nagilimiŋguk wou Tama. ");
INSERT INTO nop_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mihi biyeniŋ adi kadakaniŋ fuliŋgoŋ tuguk doktiŋa Wapumdi aditok nadiune tuwot mu tuguk doktiŋa yobune kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Unduŋ tubune Yudadi Onan indiŋ niŋguk, “Du daake tam kahat guut hatiŋa tam kahat heki’walaŋ mede yofafaŋe hatak u takaliŋa daakedok yalaki yehitubumintawaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kaŋ Onan adi indiŋ nadisuuguk, “Nu yalaki yehitubumintawene naatok gigit mu tineeŋ.” Unduŋ yoŋa dalidok yalaki mu yehitubumiintdok nadisuguk. Unduŋ tiŋa tam’walaŋ uluguk tuwot meeniŋ imeŋiŋ giineŋ kwatneluguk. ");
INSERT INTO nop_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Unduŋ hogok tulutulu Wapum adi nadikadakaaŋ yobune adi maaŋ kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kaŋ Yudadi nabuŋiŋ Tama indiŋ niŋguk, “Du wooŋ baha yolineŋ tam kahat hatilune mihine Sela bediwaak.” U yadi indiŋ nadisuŋa yoguk. Sela adi tiyaugaane daliyat kumuŋgumuk unduŋ kumumbaakneŋ unduŋ nadisuŋa yoguk. Kaŋ Tama adi wooŋ beu’walaŋ yolineŋ hatiluguk. ");
INSERT INTO nop_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ala hatigane kougoŋ Sua’walaŋ wabiŋiŋ Yuda’walaŋ tamŋiŋ kumuŋguk. Kaŋ mat kobulabulaye nai dapmaune noliŋiŋ Hila Adulamniŋ adut Timna kwetneŋ dompaŋiye dumuniŋhik dobukukiŋ yabudeene ugumuk. ");
INSERT INTO nop_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kaŋ Tama adi mede indiŋ niŋgiŋ, “I nadi. Nabuge adi dompaŋiye dumuniŋhik doobeene Timna yokwetneŋ loolak.” ");
INSERT INTO nop_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Unduŋ nadiŋa tam kahat diniŋ mut u dilitele kameeŋ. Houle yaŋaamuŋdi namanda tumukuk. Tiŋa wooŋ Timna talipmeŋ yokwet niŋ ikuk wou Enaim, uŋoŋ wooŋ yokwet gagayeŋ foikuk. Woŋ adi Sela agaŋ me wapum bediguk iŋgoŋ Tamadi wooŋ heemiŋdok mu niŋdapmagiŋ doktiŋa unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kaŋ Yuda adi wooŋ kaŋ nadiune talik tam binek yo nadiguk. Tama adi namanda houle yaŋaamuŋdi mukufulaaŋa wooŋ ikuk doktiŋa mu kadakaleguk. ");
INSERT INTO nop_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kaŋ adi talik beheepneŋ fooŋ wooŋ kaŋ yoguk, “Kedeem be nadinambeŋ kaŋ nu duguut deitim?” Biyagoŋ kuyoŋ, adi nabuŋiŋdi ituguk mu kaŋ niŋguk. Kaŋ Tamadibo yoguk, “Nukut deitok nadigambeene maŋgoŋ nambeŋ?” ");
INSERT INTO nop_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yobune Yudadibo yoguk, “Nu meme mihiniŋ niŋ kamegambene baak.” Yobune Tamadibo yoguk. “Mede yofafaŋe diniŋ fek maŋgoŋ nambuune kame hatiluwene busuwawaak.” ");
INSERT INTO nop_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yobune Yudadibo yoguk, “Yofolok diniŋ fek maŋgoŋ gambit nadiŋa yolaŋ?” Tamdibo yoguk, “Da’walaŋ mede yodapmaŋ fek kudinit eŋ tawaŋiŋ eŋ kuyaŋge kohoge foloŋ kameyataŋ, u nambeŋ.” Kaŋ nemek yoguk indigoŋ tuwot miŋa adut deikuk. ");
INSERT INTO nop_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Deilune agaŋ mihiwele tuguk. Unduŋ tiŋa pilale wooŋ haule yaŋaamuŋ u kwihikula tam kahat mutŋiŋ u kotigoŋ tiŋa mukuk. ");
INSERT INTO nop_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kaŋ hatigane Yudadi noliŋiŋ, Adulam yopmaŋniŋ adi Yuda’walaŋ yofolok diniŋ fek u beemiŋa bubundok meme mihiniŋ miŋa niŋkulune uguk. Adi adi wooŋ tam u lohi tuguk. ");
INSERT INTO nop_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tiŋa meeniŋ yeninadiŋa yoguk, “Taalik tam Enaim talik foloŋ ikuk adi de?” Adibo yogiŋ, “Taalik tam niŋ iŋoŋ nemu buune kagumun.” ");
INSERT INTO nop_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Unduŋ yobune Yuda’walaŋkade kotigoŋ udaneeŋ wooŋ niŋguk, “Nu tam u mu kagut. Eŋ meeniŋ yohiwahi adi indiŋ naniŋgiŋ, ‘Taalik tam niŋ iŋoŋ nemu buŋa hatiguk.’” ");
INSERT INTO nop_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kaŋ Yudadibo yoguk, “Mede mintawaakneŋ ale nemek u fiit biyabune uŋgoŋ halimineeŋ. Meeniŋ nolidi nadinimbuune hogohi tibaakneŋ yoŋa nu meme mihiniŋ agaŋ kamewene nagi uguŋ iŋgoŋ du tam u mu kaguŋ.” ");
INSERT INTO nop_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kaŋ muyakip lufomkulitniŋ dapmaune Yuda mede kahat indiŋ timiŋgiŋ, “Nabuge siloda kwanai tiyaugane mihiwele tilak.” Kaŋ Yudadibo yoguk, “U nagila buune kudupdi heneene dakumumbaak.” ");
INSERT INTO nop_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Unduŋ yobune nagila ulune nabuŋiŋdi me’walaŋkade mede indiŋ kameune uguk, “Nemek yendiniŋ moloomdi nabuune mihiwelenit tugut. Ale du kaweŋ mede yodapmaŋ fek kudinit ee tawaŋiŋ eŋ kuyaŋ heki u needi’walaŋ?” ");
INSERT INTO nop_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kaŋ Yuda adi yali yabuhohoŋeŋ yabukiyondaŋ yoguk, “Adi mede biyagoŋ yolak. Nemek hogohogok u nu’walaŋ. Nu yom tiŋa niŋkuleene mihine Sela’walaŋ mu uguk.” Unduŋ yoŋa tam woondut kotigoŋ mu hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kaŋ hatigane wapmihi mintaminta nai tubune mihiyat katap mintagumuk. ");
INSERT INTO nop_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Agaŋ mintadok tulune timeŋ mihi niŋ’walaŋ kohoŋdi fosuwaguk. Kaŋ tam mihi uloloŋ tugukdi tawa giminiŋ tiŋa kohoŋ ginaŋ folokeneguk. Waa indiŋ yoŋa tuguk, “Biyagoŋ kuyoŋ, adi timeŋ mintaguk.” ");
INSERT INTO nop_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ŋakŋaak woondi kohoŋ kotigoŋ hamatiŋa loune kwayaŋdi mintaguk. Kaŋ tam mihi ulolooŋ tugukdi indiŋ yoguk, “Kei! Du deeti dake kalakapmeeŋ timeŋ mintaŋaŋ?” Unduŋ doktiŋa wou Peles youkiŋ. ");
INSERT INTO nop_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kaŋ mindaŋkade dali kohoŋ foloŋ tawa giminiŋ ibidokoŋit adi mintaguk. Adi’walaŋ wou Sela youkiŋ. ");
INSERT INTO nop_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yosep agaŋ nagila Isip kwetneŋ fogiŋ. Kaŋ Isip niŋ me niŋ wou Potifa adi adi Felo’walaŋ me wapme, mikme Felo ne kadokoyagiŋ adi’walaŋ talitimeŋ, ala Ismaelhi nagila uune tuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Wapum adi Yosepguut hatiguk doktiŋa Yosepdi nemek tubune kedem hogok tuguk. Kaŋ bombooŋgiŋiŋ’walaŋ yolineŋ hatidok nadimimbuune tuwot tuguk. ");
INSERT INTO nop_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","4","Kaŋ Yosep adi kwanai tuluguk u yadi Wapumdi adut hatiŋa tubulodaune kwanai tuguk u kedem hogohogok tuguk. Bombooŋgiŋiŋdi Yosep kwanaiŋiŋ kaŋ nadiune tuwot tubune yot diniŋ kwanai eŋ kwanai metam hogohogok adi yabudokodok niindapmaguk. Eŋ Potifa’walaŋ nemenemek u adi’walaŋ kohoŋ foloŋ kamedapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yot bomboŋ eŋ nemenemek halimiŋguk u yabudokodok nindapmaguk nai uŋaandiŋgoŋ Yosep doktiŋa Wapumdi Isipniŋ me’walaŋ nemenemek hogohogok kahaŋ timiŋguk. Wapum’walaŋ wahu kahaŋdi Potifa’walaŋ nemenemek yopmaŋ eŋ kwanai ginaŋ tokidapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Unduŋ doktiŋa Potifa adi Yosep kohoŋ foloŋ nemenemekŋiŋ boidapmaaŋ Yosepdok wele lufom mu tuguk. Nee adi kwanai ginaŋ yaugaane buŋa nanaŋe hogok naluguk. Yosep adi me folooŋnit eŋ folooŋnamandapŋiŋ momooŋ hinek, ");
INSERT INTO nop_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","doktiŋa kabe hatihatiyeeŋ bombooŋgiŋiŋ’walaŋ tamdi Yosep kasiloda hatiguk. Unduŋ tihatigane heleeŋ niŋ indiŋ niŋguk, “Du buune nu’walaŋ gulup ginaŋ noŋgoŋ deitim.” ");
INSERT INTO nop_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Iŋgoŋ Yosep adi mooŋ yoguk. Tiŋa indiŋ niŋguk, “Bombooŋgine adi yopmaŋ nemek ikiiŋ wondok nadibedi mu tilak. Adi adi nutok welelufom mu tiŋa nemenemekŋiŋ hogohogok nu yabudokodok nanindapmaaŋ kohone foloŋ boiguk. ");
INSERT INTO nop_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Yot yendiniŋ maaneŋ nebek niŋdi nu nalakapmeeŋ loloŋnit mu tilak. Bomboŋgine adi nemek niŋ kamehep mu tinamguk. Agaŋ du kubugoŋ. Du yadi ne’walaŋ tamŋiŋ. Ale nu dediŋ tiŋa titiŋ hogoli u tiŋa Bepaŋ’walaŋ weleeŋ tubukadakawit.” ");
INSERT INTO nop_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Uŋaaniŋgoŋ tububihila helemaŋ helemaŋ Potifa tamŋiŋ adi Yosep mede uŋaakoŋ niluguk iŋgoŋ Yosep adi tam wondi’walaŋ gulup ginaŋ noŋgoŋ deitok nemu uguk, be adut nemu hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ala heleeŋ niŋ kwanai metam noli adi yopmaŋ nemu haakiŋ. Kaŋ Yosep adi kwanaiŋiŋ tibene yopmaŋ loguk. ");
INSERT INTO nop_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kaŋ tam wondi dahidahiŋiŋ foloŋ hooneŋ niŋguk, “Buune wooŋ gulup ginaŋ noŋgoŋ deitim!” Iŋgoŋ Yosep adi dahidahiŋiŋ tam kohoŋ foloŋ kwihikula momooŋ fakaŋde uguk. ");
INSERT INTO nop_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yosep adi dahidahiŋiŋ tam kohoŋ foloŋ kwihikula momooŋ fakaŋde fouluguk kaaŋ ");
INSERT INTO nop_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tam adi metam yot uŋaŋ kwanaineyagiŋ kutiyeniŋguk tiŋa indiŋ yeniŋguk, “I kaneŋ! Potifa adi Hibulu me niŋdi kadakaniŋ tinimdok nagila buŋa kamenimguk. Adi nukuut deitim yoŋa labuune kwakwayeŋat. ");
INSERT INTO nop_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kwakwayewene nadiŋa dahidahiŋiŋ kwihiŋa nu hatilatneŋ kameeŋ momooŋ fakaŋ fouŋak!” ");
INSERT INTO nop_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Unduŋ yeniŋa Yosep’walaŋ dahidahi uŋgoŋ kameune hatuune Yosep bomboŋgiŋiŋ buguk. ");
INSERT INTO nop_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Busuwaune mede kahat uŋaakoŋ timiŋa yoguk. “Hibulu kwanai me nagila buguŋ adi kadakaniŋ tinambene labuŋak. ");
INSERT INTO nop_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kaŋ nu kwakwayewene dahdahiŋiŋ nu’walaŋ habaatne foloŋ kwihi tukulaŋa momooŋ fakaŋde fouŋak.” ");
INSERT INTO nop_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kaŋ bombooŋgiŋiŋ adi tamŋiŋdi kwanai mege adi unduŋ tinamŋak yoŋa mede kahat timimbuune nadiŋa kisaŋ kwihitaguk. ");
INSERT INTO nop_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kwihitaŋa Yosep nagila yot fafaŋeniŋ ginaŋ mapme’walaŋ kwanai tiŋa yom tubune yapmeune ikagiŋ adut kameune uŋgoŋ itouluguk. ");
INSERT INTO nop_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kaŋ Wapum adi Yosepdut hatiŋa yot fafaŋeniŋ ginaŋ me hatigiŋ adi’walaŋ kadokome tubulodaguk. Kaŋ adi Wapum doktiŋa Yosepdok nadiune utumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Unduŋ doktiŋa yot fafaŋeniŋ diniŋ kadoko wapum adi Yosepdi me yot fafaŋeniŋ ginaŋ hatigiŋ hogohogok wanaŋ yabudokodok nindapmaguk. Kaŋ adi nemenemek hogohogok u Yosepdi yenindidimeune tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Unduŋ tubune me yot fafaŋeniŋ kadoko adi Yosepdi kwanai ube u titindok mede yoguk u tomboyoula nemu yoluguk. Woŋ adi Wapumdi Yosepdut hatiŋa tubulodaune nemenemek tubune utumbadapmaŋ tuluguk doktiŋa unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Nemek i mintaguk sigiineŋ mapme diniŋ wain ime tutumba diniŋ talitimeŋ eŋ belet heheŋ diniŋ talk timeŋ adi kwanaihik tubukadakagumuk. ");
INSERT INTO nop_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Unduŋ tubune biyagoŋ hinek Felo adi kwanai meŋiyat wain kadoko eŋ belet heheŋ diniŋ kadoko aditok kwihitayemguk. ");
INSERT INTO nop_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Unduŋ doktiŋa yobune ne’walaŋ mik me heki diniŋ talitimeŋ’walaŋ yolineŋ yot fafaŋeniŋ ginaŋ yapmegiŋ. Yosep maaŋ yot uŋgoŋ deitouluguk. ");
INSERT INTO nop_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ala yot fafaŋeniŋ diniŋ kadokodi Yosep adi yabudokodok niŋdapmaguk. Kaŋ adi nai muniniŋ yot fafaŋeniŋ ginaŋ hatigumuk. ");
INSERT INTO nop_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Tiŋa timiŋ kubugoŋ niŋ foloŋ lihine wanaŋ tugumuk. Ala lihine molomoloom tugumuk eŋ lihine u mebinit tugumuk. Biyagoŋ kuyoŋ, Isipniŋ mapme’walaŋ wain ime kodoko eŋ belet heheŋ diniŋ kadoko adi unduŋ tugumuk. ");
INSERT INTO nop_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ala kwet heleune Yosepdi adi’walaŋ yohineŋ looŋ bulaaniŋgoŋ namandap ila diweeune yabuguk. ");
INSERT INTO nop_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yabuŋa yeninadiguk, “Hidi kamiŋ deetiŋa bulaaniŋgoŋ namandap ikaamuk?” ");
INSERT INTO nop_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yobune niŋgumuk, “Indi lihine tumut, tiŋa me neediyeŋ mebi ninimbek yoŋa lohiyamut.” Kaŋ Yosepdi yoguk, “Lihine diniŋ mebi adi Bepaŋdi hogok nadilak iŋgoŋ fiit yobune nadiwit.” ");
INSERT INTO nop_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kaŋ wain ime kadokodi lihine tuguk wondiniŋ mede kahat timiŋa yoguk, “Nu ye indiŋ kaŋat. Habaatne foloŋ wain mebi niŋ mintaune kaŋat. ");
INSERT INTO nop_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tiŋa taŋeeniŋ lufomkulitniŋ mintalune wowoŋ niŋ maaŋ youkuk. Tiŋa undugoŋ folooŋ mintaaŋ gimindaŋak. ");
INSERT INTO nop_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kaŋ nu yadi Felo’walaŋ ime utnaŋ kohoonedi hooneeŋ yale mindipmuŋ gimihi moŋgola kahileene imeeŋiŋ ime utnaŋ ginaŋ foune tiŋa Felo kohoŋ ginaŋ kamewene hooneŋak.” ");
INSERT INTO nop_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kaŋ Yosepdibo niŋguk, “Woondiniŋ mebi indiŋ. Taŋeeniŋ lufomkulitniŋ woondi melenai lufomkulitniŋ wondok tuwolit. ");
INSERT INTO nop_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ala melenai lufomkulitniŋ tubune dapmaune Felodi ganindapmaaŋ kwanaige ginaŋ kotigoŋ gapmewaak, kaŋ du koom wain kadoko hatiŋa Felo wain ime miluguŋ undugoŋ kotigoŋ tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Unduŋ tiŋa nadifo foloŋ hatiŋale nu kadaa maaŋ nadinamuŋa Felo nimbaaŋ. Unduŋ tiŋa nehitubulodaune, yot i bikabuŋa fooŋ waat. ");
INSERT INTO nop_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Naadilaŋ be! Nu Kanaaŋ kwetneniŋ kubo nanagikiŋ eŋ iŋoŋ maaŋ undugoŋ nemek kadakaniŋ nemu tibene hogok hinehinek yot fafaŋeniŋ ginaŋ napmegiŋ.” ");
INSERT INTO nop_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Unduŋ tubune belet heheŋ diniŋ talitimeŋ adi Yosepdi lihine diniŋ mebi momooŋ hinek yodakaleŋak unduŋ kaŋ indiŋ niŋguk, “Nu maaŋ lihine indiŋ tiŋat. Nu boondiboondi lufomkulitniŋ belet nit mebine foloŋ udieŋat. ");
INSERT INTO nop_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kaŋ bondibondi wohiŋ ilaŋak wondiniŋ maaneŋ Felo’walaŋ belet kobaaŋ mebimebi ituune bagi hekidi buŋa naŋit.” ");
INSERT INTO nop_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Unduŋ yobune Yosepdi indiŋ tubuudaneeŋ niŋguk, “Wondiniŋ mebi indiŋ. Bondibondi lufomkulitniŋ adi melenai lufomkulitniŋdok tuwolit iŋgoŋ. ");
INSERT INTO nop_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ala melenai lufomkulitniŋ dapmaune Felodi yobune bem fuloŋ gehitehikapmaneeŋ kaŋ bagi hekidi folooge goom nadapmaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ala agaŋ melenai lufomkulitniŋ dapmaune Felo mintamintaŋiŋ nai foloŋ kwanai meŋiyedok hinaŋ muni tiyemguk. Unduŋ tiŋa kwanai meŋiye namandahik foloŋ wain kadoko taali timeŋ eŋ belet heheŋ taali timeŋ adi’walaŋ mede yodapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tiŋa wain kadoko diniŋ talitimeŋ adi ime utnaŋiŋ kotigoŋ mimindok niŋguk. Kwanaiŋiŋ komii uŋaakoŋ hinek kotigoŋ miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Eŋ belet heheŋ diniŋ talitimeŋ adi Yosepdi yeniŋguk undugoŋ hinek tehikapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kaŋ wain kadoko diniŋ talitimeŋ adi Yosepdok mu nadisuuguk. Adi yadi kaule tiŋa hatiguk. ");
INSERT INTO nop_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Hatigane gulet lufom dapmaune Felo adi lihine niŋ tuguk. Felo adi lihine ginaŋ ime wapum Nael gagayeŋ yakuk. ");
INSERT INTO nop_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Adi ime Nael gagayeŋ yale yabulune makau 7 moomoohi goom gaaliki hinit ime ginaniŋ labusuwaaŋ kilihikit yanagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Yanalune mindaŋ makau 7 iŋgoŋ noli maaŋ ime ginaniŋ labugiŋ, adi adi hogohi kigitahi. Adi labuŋa makau moomoohi goom gaaliki hinit adi’walaŋ gagayeŋ yakiŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Yaaleŋa makau hogohi kigitahidi moomoohi goom gaalikit hinit yehinakukiŋ. Felo adi unduŋ kaŋ sukuleguk. ");
INSERT INTO nop_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Felo adi damo kotigoŋ fooŋ deila lihine nimbo tuguk. Woŋ adi indiŋ. Haŋgom kwedei kubugoŋ labuŋa yakuk eŋ folooŋ adi 7 moomoohi eŋ tokitokilehi. ");
INSERT INTO nop_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mindaŋ haŋgom kitili nimbo labuguk adi’walaŋ folooŋ 7 iŋgoŋ alaa, adi yadi maniunedi yehifedilune folooŋ momooŋgoŋ mu mintagiŋ, tumut hogok. ");
INSERT INTO nop_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ala haŋgom hogohi, tumut hogokdi folooŋ hinit tokitokileehi yehikumuyegiŋ. Felo adi unduŋ lihineeŋ sukuleeŋ pilaakuk. ");
INSERT INTO nop_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Haaniŋ Felo lihine tuguk wondok nadibediŋa me mebi nadinadi eŋ mebi tubutakale me heki mede kameyembuune bugiŋ kaŋ Felo adi lihine tuguk wondok mede kahat tiyemguk. Iŋgoŋ e adi’walaniŋ nebek niŋdi lihine wondiniŋ mebi mu niŋguk. ");
INSERT INTO nop_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Unduŋ tubune mapme’walaŋ ime utnaŋ kadokoluguk adi Felo indiŋ niŋguk, “Nu kamiŋ yomne nadibihitat. ");
INSERT INTO nop_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Felo, yakalaŋ! Du koom kwanaimegeye inditok kwihita tiŋa belet heheŋ diniŋ talik timeeŋ eŋ nu indi yot fafaŋeniŋ ginaŋ nipmeguŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nai uŋaniŋ indi lihine tugumut. Tiŋa lihine tugumut u mebinit. ");
INSERT INTO nop_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kaŋ nai uŋaniŋ Hibulu me kuya niŋ yot fafaŋeniŋneŋ indigut noŋgoŋ hatigumun. Adi mik me diniŋ talitimeŋ tubulodaluguk. Biyagoŋ kuyoŋ adi lihine tugumut u nindeene nadiŋa mebi niniŋguk. Tiŋa lihine tugumut tuwolit mebi molomoloom ninindakaleguk. ");
INSERT INTO nop_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ala mebi ninindaleguk wondok tuwolit nemek folooŋ mintaguk. Nu kwanaine ginaŋ kotigoŋ namegiŋ eŋ belet heheŋ diniŋ kadoko adi tehikapma tigiŋ.” ");
INSERT INTO nop_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Kaŋ Felodi Yosep bubundok yobune uŋaniŋgoŋ yot fafaŋeniŋ ginaŋniŋ nagila bugiŋ. Tiŋa kii dumuniŋ dobu kulimiŋa dahidahi koobuli dahiŋa Felo’walaŋ namanda ginaŋ uguk. ");
INSERT INTO nop_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Usuaune Felodi indiŋ niŋguk, “Nu lihine tiŋat. Woondiniŋ mebi me niŋdi nemu yobihila naniŋak. Dutok adi indiŋ yobune nadiŋat. Du yadi lihine tiŋa ganimbuune lihine diniŋ mebi kedem yodakaleelaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Unduŋ nimbuune Yosepdibo Felo indiŋ tubuudaneeŋ niŋguk, “Nu naa hogohogok dediŋ tiŋa tibit. Bepaŋ adigili Felo du mede momooŋ kedem ganimbek.” ");
INSERT INTO nop_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kaŋ Felodi Yosep indiŋ niŋguk, “Nu Nael ime gagayeŋ yalaŋat ");
INSERT INTO nop_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kaŋ makau 7 moomoohi goom gaalikihinit imeginaniŋ labuŋa yale kilihikit naaŋit. ");
INSERT INTO nop_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kaŋ mindaŋ makau 7 iŋgoŋ hogohi eŋ kigitahidi labuŋit. Nu Isip kwetneŋ iŋoŋ makau undihi nemu yabugut. ");
INSERT INTO nop_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kaŋ makau hogohi adi makau 7 moomoohi eŋ goom gaalikihinit u yehinagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Yehi nadapmagiŋ iŋgoŋ kabak kabe nemu tigiŋ. Kom dibek hogohi eŋ kigitahi undihigoŋ yakiŋ. Nu lihine unduŋ tiŋa sukuleŋat.” ");
INSERT INTO nop_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Kootigoŋ deilaŋa lihine kotigoŋ indiŋ tiŋat. Haŋgom niŋ labuŋa yalak, mebi kubugoŋ eŋ folooŋ adi 7 momohi eŋ kakahi. ");
INSERT INTO nop_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mindaŋ haŋgom mebi niŋ labuguk umaaŋ folooŋ 7 iŋgoŋ alaa, sububa maniunedi feedilune sigene tiŋa folooŋ yolihaapmuŋ hogok. ");
INSERT INTO nop_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ala yolihaapmuŋ hogokdi folooŋ momooŋ u kumuyeguk. Kaŋ wondok tiŋa nadinadi me yenimbeene nebek niŋdi mebi mu nanilak.” ");
INSERT INTO nop_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kaŋ Yosepdi Felo indiŋ niŋguk, “Felo! Du lihine lufom tiŋaŋ wondiniŋ mebi kubugoŋ hogok. Biyagoŋ kuyoŋ, Bepaŋ adi kudi niŋ titindok ganimbihitak. ");
INSERT INTO nop_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ale makau moomoohi 7 woondi gulet 7 tilak, agaŋ haŋgom moomoohi 7 woondi gulet 7 iŋgoŋ tilak. Unduŋ doktiŋa lihine lufomuk adi mebi kubugoŋ tilak. ");
INSERT INTO nop_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Makau hogohi 7 mindaŋ labuŋit woŋ adi gulet 7 wondok tuwolit. Tiŋa haŋgom folooŋ yolihaapmuŋ hogok sububa maaniunedi feedikwambudaguk woŋ adi fiye kadaka halune map wapum gulet 7 wondok tuwot halaak.” ");
INSERT INTO nop_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Biyagoŋ kuyoŋ, nu woondegoŋ nadisuŋa Felo agaŋ indiŋ ganiŋat. Bepaŋ adi nemek tibee nadilak u Felo du ganimbihitak. ");
INSERT INTO nop_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ale nadilaŋbe? Yoŋ adi Isip kwetneŋ gulet 7 nanaŋe duhu duhu wapum mintawaak. ");
INSERT INTO nop_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ala nanaŋe duhu duhu nai dapmaune nanaŋe map wapum hinek mintaaŋ hatuune gulet 7 iŋgoŋ dapmawaak. Nai uŋaniŋ duhu duhudok kaule tiŋa fiye kadaka halu nanaŋe map kisaŋ tubudapmaneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Duhu duhu adi agaŋ kaule tineeŋ uyadi map fuliŋgoŋ hinek mintaaŋ halaak doktiŋa unduŋ tineeŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Felo du lihine mebi kubugoŋ nai lufom kaaŋaŋ wondiniŋ mebi indiŋ. Biyagoŋ kuyoŋ, Bepaŋ adi nemek u pilap mintadok yokwambundaguk hatak.” ");
INSERT INTO nop_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Unduŋ doktiŋa Felo, du me niŋ nadidakalenit eŋ nadisu fuliŋgoŋnit tubumintaaŋ Isip kwet wapum i kadokodok nindapmaweŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tiŋa du yokwet tuwot talitimeŋ yapmeune adi gulet 7 duhu duhu nai ginaŋ nanaŋe mintawaak tuwot bop 5 uŋaniŋ kubugoŋ moŋgola boiune hogok itneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Adi nai wondiniŋ maaneŋ pandiŋ eŋ haaŋgom mintawaak tuwot ugamaali bopneeŋ du’walaŋ woho foloŋ boiune dumuŋ itneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Unduŋ tubune haaŋgoom eŋ pandiŋ wondi fiye kadaka halu map wapum gulet 7 halaak wondok mebit dumuŋ itneeŋ. Unduŋ doktiŋa Isip kwetneŋ map wapum mintaaŋ halaakneŋ meeniŋdi nanaŋe map doktiŋa mu kadakaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Felo eŋ me wapuhiŋiye adi mede yodakale eŋ yohabet wondok nadiune utumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Doktiŋa Felodi yeninadiguk, “Indi me niŋ Bepaŋ’walaŋ munabuli me i halimilak undiniŋgoŋ niŋ tuwot mu tubumintanim.” ");
INSERT INTO nop_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mooŋ lohi kaŋ Felodi Yosep indiŋ niŋguk, “Bepaŋdi mede hogohogok u ganimbuhidapmaguk doktiŋa me nadinadinit eŋ nadidakalenit du indiniŋgoŋ noli nemu hatilak. ");
INSERT INTO nop_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Biyagoŋ kuyoŋ, unduŋ doktiŋa du nu’walaŋ yot eŋ nememeemek wondok kadoko wapum gameelat. Unduŋ doktiŋa nu’walaŋ metam adi du’walaŋ mede tiloloŋ taneeŋ. Maapme iitdok kumupoopne kubugoŋ adi gikiŋgoŋ timimbaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Unduŋ yoŋa Felodi Yosep indiŋ niŋguk, “Naadilaŋ be? Biyagoŋ kuyoŋ nu Isip kwet wapum wondiniŋ kadoko wapum gapmeelat.” ");
INSERT INTO nop_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Felo adi unduŋ yoŋa mapme’walaŋ mede yodapmaŋ fek mapme kudinit u ne’walaŋ kohoŋ foloŋ ikuk kwihiŋa ti Yosep kohoŋ foloŋ dahiune loguk. Eŋ dahidahi momooŋ hinek niŋ dahimiŋguk eŋ fukut momooŋ goldi tigiŋ niŋ homoginemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Unduŋ timiŋiŋa yobune ne’walaŋ kaali namba 2 foloŋ looŋ ulune meeniŋdi koom uŋale indiŋ yoŋa kutigiŋ, “Mulelem timineŋ!” Biyagoŋ kuyoŋ unduŋ timiŋa Isip kwet wapum wondiniŋ kadoko wapum hatidok nindapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Unduŋ tiŋa Felodi Yosep indiŋ niŋguk, “Nu Felo iŋgoŋ oŋ, du mu nadilune meeniŋ Isiphi adi nehi nadigoŋ tiŋa nemek nemu tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Unduŋ yoŋa Felodi Yosep wou koobuli Isip mede foloŋ Safenat-Panea youkuk. Unduŋ tiŋa yeguk e On yopmaŋniŋ me siloŋ muni heeluguk wou Potifela, adi’walaŋ wabi Asinati mimbuune tamŋiŋ nagikuk. Unduŋ tiŋa Yosep adi Isip kwet diniŋ me wapum hatiŋa keleemaadiŋa kadokoluguk. ");
INSERT INTO nop_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ala Yosep adi guletŋiŋ 30 tubune Isipniŋ mapme Felo adi’walaŋ namanda foloŋ mintaguk. Unduŋ tiŋa Felo bikabuŋa kaaliŋiŋ kale wosi hekidi hamaneune Isip kwet wapum wanaŋ keleemaadidapmaaŋ yawooŋ kadokoguk. ");
INSERT INTO nop_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Gulet 7 maaneŋ kwet uŋaŋ duhu duhu wapum mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kaŋ Yosep adi gulet 7 wondiniŋ maaneŋ pandiŋ eŋ haaŋgoom fee mumuyeŋ mintaguk u ugamaale bopneeŋ boiune yokwet wapum ila ugiŋneŋ udapmaguk. Biyagoŋ kuyoŋ, adi yokwet wapum tuwot yawooŋ dininout haale uguk uŋaniŋ pandiŋ eŋ haaŋgom ugamaaliŋa yopmaŋ bopnetauguk. ");
INSERT INTO nop_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosep adi unduŋ tiŋa pandiŋ eŋ haaŋgoom u ime luhi gagayeŋ kiŋ hatak undiniŋ ilune ugamale bopneune kunakunatdok tuwot u kalakapmeune hogok kauleeŋ tinadahi fiit tuguk. ");
INSERT INTO nop_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kaŋ map mu mintalune Yosep’walaŋ mihiŋiŋyat lufom mintagumuk. On yopmaŋniŋ siloŋdok muni heheŋ me Potifela’walaŋ wabi Asinatidi yanagikuk. ");
INSERT INTO nop_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kaŋ Yosep adi mihiŋiŋ tuwo aditok indiŋ yoŋa wou Manase youkuk, “Bepaŋdi nehitubulodaune wele bulaaniŋgoŋne eŋ baatne’walaŋ yolidok kaule tugut.” ");
INSERT INTO nop_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mihiŋiŋ mona’walaŋ wou adi indiŋ yoŋa Efilaim yoguk, “Bepaŋdi kwet iŋoŋ folofigita ginaŋ hatibene nadisuunamŋa mihi tubumintanamguk.” ");
INSERT INTO nop_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Agaŋ Isip kwet duhu duhu wapum gulet 7 haale labuguk u dapmaune ");
INSERT INTO nop_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","gulet 7 map nai tububihila mintaguk. Biyagoŋ kuyoŋ, Yosepdi yoguk wondok tuwolit mintaguk. Unduŋ tubune kwetkwet nanaŋedok map wapum hatuune Isip kwet wapumneŋ nanaŋedok baniŋ mu tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Agaŋ Isip kwetneŋ maaŋ fiye kadaka tububihila mintaune metam adi map tiŋa Felo’walaŋ wooŋ nanaŋedok nimbulabulaye tigiŋ. Kaŋ Felodibo Isiphi metam indiŋ yeniŋguk, “Hidi Yosep’walaŋ uneŋ kaŋ adi dediŋ hanimbek wondok tuwot tineŋ.” ");
INSERT INTO nop_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Fiye kadaka haluune map wapumdi kwetkwet tokidapmaaŋ hakuk. Unduŋ mintaune Yosepdi nanaŋe tinauliibi yot talik dilitomyembuune tuwaaŋ moŋgokiŋ. Unduŋ tulune Isip kwetneŋ map wapum hinek mintaguk. ");
INSERT INTO nop_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Unduŋ tubune meeniŋ kwetkwet nanaŋe tuwaneene Isip kwetneŋ ugiŋ. Woŋ adi kwetkwet fiye kadakadi mulabuda hinek tuguk doktiŋa unduŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Kaŋ Yakobo adi Isip kwetneŋ nanaŋe kedem tuwadok unduŋ nadiŋa mihiŋiye indiŋ yeniŋguk, “Hidi maŋgoŋde nadikabaleeŋ hatiiŋ? ");
INSERT INTO nop_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isip kwetneŋ nanaŋe kedem tuwadok yobune nadilat. Ale hidi uŋoŋ wooŋ tuwaaŋ moŋgola buneŋ. Tiyauge indi nanaŋe map kisaŋ tineemneŋ alaa.” ");
INSERT INTO nop_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kaŋ Yosep daliye ten adi nanaŋe tuwaneene Isip kwetneŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Biyagoŋ kuyoŋ Yosep’walaŋ kwayaŋ Benyamin adi yadi beudi daliyedut mu uundok nadisuuŋa kahile tubune hakuk. Tiyauge kwet fiileŋ haulune nemek figitaaŋ niŋ mintamimbaakneŋ yoŋa unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kaŋ Isilae Mihiŋiye adi Kanaaŋhi me noli nanaŋe tuwaneene ugiŋ adut noŋgoŋ ugiŋ. Uge uge usuwagiŋ. Biyagoŋ hinek Kanaaŋ kwetneŋ maaŋ fiye kadaka wapum hakuk. ");
INSERT INTO nop_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosep adi Isip kwet diniŋ kadoko me wapum hatiŋila kwetkwet me nanaŋe tuwaneene bulune nanaŋe yembuune kibikooŋ muneeŋ miŋgiŋ. Unduŋ tulune daliyedibo busuwaŋ duwookeneeŋ namandahik kwet foloŋ tubuwopmoobut timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kaŋ Yosep adi daliye agaŋ yabukiyondaguk. Iŋgoŋ mebiŋiŋ kameheebi tiŋa mede fafaŋeniŋgoŋ yeniŋa indiŋ yeninadiguk, “Hidi diŋahi yeŋ biiŋ?” Adibo yogiŋ, “Kanaaŋ kwetneniŋ ala nanaŋe tuwaneene baam.” ");
INSERT INTO nop_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosep adi daliye agaŋ yabukiyodaguk iŋgoŋ adi kibi mu kakiyondagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kaŋ Yosep adi koom kwaha aditok lihine tuguk u nadisuguk. Tiŋa indiŋ yeniŋguk, “Hidi yadi bolik titiŋ me. Hidi yadi indi’walaŋ kwet kanadi tiŋa kwet faakii daŋgoŋ momooŋgoŋ mu kadokoyam undihi kanadiku tineene buŋit oŋ.” ");
INSERT INTO nop_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Adibo yogiŋ, “Bombooŋgi, unduŋ mooŋ ale! Tipilapilayemegeye indi yadi nanaŋe tuwaneene bumun. ");
INSERT INTO nop_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Indi yadi me kubugoŋ diniŋ mihiŋiye hogohogok. Indi yalaŋ me mooŋ. Eŋ boolik mu tiyam.” ");
INSERT INTO nop_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Adibo yeniŋguk, “Mooŋ, hidi yadi indi’walaŋ kwet faakii daŋgoŋ hogok hatak uku kanadi tineene buŋit.” ");
INSERT INTO nop_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yobune adibo yogiŋ, “Tipilapilayemegeye indi 12 hatigumun. Tiŋa indi hekidalit me kubugoŋ diniŋ mihiŋiye ala indi Kanaaŋhi. Kwayanik dikineŋ hinek adi beudut halumuk. Eŋ kwayanik noli adi yadi koom kwaha daambek fiikuk.” ");
INSERT INTO nop_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kaŋ Yosepdibo yeniŋguk, “Nu agaŋ haniŋat, hidi yadi boolik titiŋ me. ");
INSERT INTO nop_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Unduŋ doktiŋa medehik diniŋ mebi dakalewaak. Nu Felo’walaŋ wou foloŋ yofafaŋeeŋ hanilat. Kwayahik dikineŋ hinek mu nobu busuwawaak adi hidi kwet i bikabuŋa kotigoŋ yohikwehineŋ mu uneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Unduŋ doktiŋa hidi’walaniŋ niŋ niŋkulune wooŋ kwayahik dikineŋ nagila baak. Eŋ noli hogohogok hidi yadi yot fafaŋeniŋ ginaŋ itneeŋ. Kaŋ nu medehik diniŋ mebi didimeniŋgoŋ nadidakalewaat. Unduŋ tiŋa mede yoiŋ u kawene yalaŋ nobu tibaak adi hidi boolik titiŋ me hanimbaat. U Felo’walaŋ wou foloŋ yofafaŋelat.” ");
INSERT INTO nop_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Unduŋ yoŋa wanakaŋ hogohogok yot fafaŋeniŋ ginaŋ yapmeune melenai lufomkulitniŋ uŋoŋ itougiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ala agaŋ melenai lufomkulitniŋ tubune Yosepdi indiŋ yeniŋguk, “Nu Bepaŋ gikiŋgoŋ timilat doktiŋa hidi hehifiyakutdok nobu nadiyaneŋ kaŋ indiŋ tineŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Hidi yalaŋ mu yoiŋ kaŋ hidi’walaniŋ me kubugoŋdi yot fafaŋeniŋneŋ iŋgoŋ bikabuune ilune noli hogohogok hidi noohiye nanaŋe map kisaŋ tineeneŋ doktiŋa pandiŋ eŋ haŋgom beeŋa uneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tiŋa kwayahik dikineŋ nagila buune mede biyagoŋ yoiŋ unduŋ nadiŋa bihabeene hatineeŋ.” Kaŋ daliye adi Yosepdi yoguk undugoŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tiŋa nehigoŋ uŋgoŋ kiyonadi tiŋa indiŋ yogiŋ, “Biyagoŋ kuyoŋ, nemek yoŋ adi kwayanik titiŋ hogoli timiŋgumun doktiŋa mintanimulak. Adi munabukadeŋa ninimbulabulaye tulune indi nadikabale tiŋa bikabune uguk. Ale woondegoŋ tiŋa kibikooŋ nemek mulabumuŋ i mintanimlak.” ");
INSERT INTO nop_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kaŋ Lubendi indiŋ yeniŋguk, “Nu agaŋ haniŋgut! Hidi mihi kada u nemek hogoli mu timineŋ. Iŋgoŋ hidi medene nadikabaleeŋ tigiŋ wondoktiŋa kibikooŋ mintalak u agaŋ kaŋ nadiiŋ. Naŋgatŋiŋ diniŋ yomdok kibikooŋ mintanimlak.” ");
INSERT INTO nop_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Biyagoŋ kuyoŋ, adi yadi Yosepdi medenik agaŋ nadilak u mu nadigiŋ. Yosep adi yadi daliyedut mede yonadi tibene me niŋdut mede yotubutakale tuguk. ");
INSERT INTO nop_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Unduŋ tiŋa Yosep adi daliye biyabuŋa wooŋ maat kookuk. Unduŋ tiŋa kotigoŋ udaneŋ wooŋ adut mede mede toguk. Tiŋa yobune Simeon lekiŋgoŋhik ginaŋ yakuk hamane tiŋa wooŋ yakalune dauhik folooŋgoŋ kohoŋ ibigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Tiŋa yobune pandiŋ eŋ haaŋgoom likhik ginaŋ dahitoki tiyemiŋgiŋ tiŋa muneeŋhik kotigoŋ likhik maŋiŋ ginaŋ kadahiyemgiŋ. Tiŋa talipmeŋ wooŋ map nadiŋa nanandok dumuŋ maaŋ dahiyemdok yoguk kaŋ undugoŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kaŋ adi nanaŋe likhik doŋkihiye foloŋ moŋgolooŋ boiŋa agaŋ tububihila ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Uge uge bufaune nalum yot niŋ ginaŋ usuwaaŋ me niŋdi doŋkiŋiŋ nanaŋe mimbeene lik maŋiŋ fiyakula kaguk, be muneeŋŋiŋ lik ginaŋ uŋgoŋ dahigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Biyabgoŋ kuyoŋ, adi unduŋ kaŋ dali kwayaŋiye yeniŋguk, “Ai! Deebek tiŋa muneeŋne kotigoŋ likne maŋiŋ ginaŋ kotigoŋ dahinamuŋit. Lik maŋiŋ ginaŋ i itak oŋ!” Yobune adi boho tiŋa kikakika tiŋa yogiŋ, “Bepaŋdi dediŋ tinimilak.” ");
INSERT INTO nop_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kaŋ adi Kanaaŋ kwetneŋ behik Yakobo wooŋ kaŋ nemek mintayemiŋguk wondiniŋ mede kahat wanakaŋ hogohogok tubudapmaaŋ niŋgiŋ. Tiŋa niŋgiŋ, ");
INSERT INTO nop_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Kwet umun wondiniŋ me bombooŋgi adi mede fafaŋeniŋ eŋ wapum hinek niniŋguk. Tiŋa inditok boolik titiŋ me niniŋa yot fafaŋeniŋ ginaŋ nipmeguk. ");
INSERT INTO nop_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Unduŋ tinimbuune indiŋ niŋgumun, ‘Indi yadi me kwelemaahi eŋ boolik mu tiyam. ");
INSERT INTO nop_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Indi me heki dalit 12, beetnik’walaŋ mihiŋiye. Ala kubugoŋdi koom kwaha fiikuk eŋ kwayanik kuyaniŋ hinek adi yadi Kanaaŋ kwetneŋ beetnik dut hatilak.’ ");
INSERT INTO nop_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Unduŋ yoneene kwet wondiniŋ me bombooŋgi adi indiŋ niniŋguk. ‘Hidi me kwelemahi be dediŋ adi mebihik indiŋ tubune habuŋa nadidakalewaat. Ale hidi’walaniŋ me kubugoŋdi iŋgoŋ hatilune noli hidi mehimehiye nanaŋe map tineeneŋ doktiŋa nanaŋe moŋgola uneŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ala hatigane kotigoŋ buneene kwayahik kuyaniŋ u maaŋ nagila buneeŋ. Kaŋ hidi boolik titiŋ me mooŋ me kwelemahi hatiiŋ wondiniŋ mebi dakalewaak. Unduŋ tubune daahik tubuudanehambene hidi kwet iŋoŋ uŋat buŋat tineene kaakaa tiyaneeŋ.’” ");
INSERT INTO nop_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Kaŋ adi lik molomoloom pandiŋ kwaatneelune muneeŋ yawenit maaŋ foune yabuŋa bohoo tigiŋ. Unduŋ tiŋa mewoi nehi be behik adi muneeŋ yawe folooŋ hinit yabuŋa munta nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kaŋ behik Yakobodi indiŋ yeniŋguk, “Hidi mihineye noloom-moŋgodapmaiŋ. Yosep agaŋ fiikuk, Simeon iŋgoŋ mu hatinamulak. Kaŋ yoŋ adi Benyamin maaŋ nagila unee yoiŋ. Doktiŋa nu bulaaniŋgoŋ wapum hinek nadilat.” ");
INSERT INTO nop_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Unduŋ yobune Lubendibo niŋguk, “Mu nagikambaat kaŋ wondok kibikooŋ nu’walaŋ mihineyat lufom u udihikumumbaaŋ. Unduŋ doktiŋa adi fiit nu’walaŋ kohoone foloŋ kameweŋ. Kaŋ nu kedem kotigoŋ nagikambaat.” ");
INSERT INTO nop_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Adibo yoguk, “Mihine adi hidut mu waak. Dali agaŋ kumuŋguk doktiŋa adi neehogok kadaa hatinamulak. Hidi talik uneeneŋ uŋoŋ nemek mulabumuŋ niŋ mintamimbaak adi nu guhakatnenitdi bulaaniŋgoŋ tiŋa hatigane kumumbaat wondiniŋ yom adi hidi foloŋ halaak.” ");
INSERT INTO nop_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kanaaŋ kwetneŋ nai yagigi hinek fiye kadaka wapum hakuk. ");
INSERT INTO nop_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Isip kwetneniŋ nanaŋe moŋgo bugiŋ u naune dapmaune behikdi indiŋ yeniŋguk, “Hidi kotigoŋ nanaŋeenik tuwaneene uneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yobune Yudadi indiŋ niŋguk, “Me woŋ adi mede yofafaŋe indiŋ tinimguk, ‘Hidi yadi kwayahik kuyaniŋnit mookit nu’walaŋ namandatne foloŋ mu mintaneeŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ale du kwayanik adi indut wanakaŋ uundok nindapmaweŋ adigili kedem wooŋ nanaŋe tuwagamuneem. ");
INSERT INTO nop_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Adi kame kibida haleŋ adi me woondi indiŋ yoguk doktiŋa mu unim, ‘Hidi yadi kwayahik kuyaniŋnit mookit nu’walaŋ namandatne foloŋ mu mintaneeŋ.’” ");
INSERT INTO nop_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yobune Isilaedibo yoguk, “Hidi maŋgoŋ tineene waleene sibila kwayahik diniŋ mebi me u nimbihikiŋ?” ");
INSERT INTO nop_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yobune adibo yogiŋ, “Me woondi indee eŋ meenimeeniye hiditok wanakaŋ nininadiŋa yoguk, ‘Beehik hatilak be? Eŋ kwayahik kuyaniŋ neembe hatilak?’ Unduŋ yobune hatiyam indigoŋ tuwot nindapmagumun. Kaŋ adi kwayahik nagi buneeŋ unduŋ yobek u indi mu nadigumun.” ");
INSERT INTO nop_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kaŋ Yudadi beu Isilae adi indiŋ niŋguk, “Mihi adi nu kohoone foloŋ kameune tiulidokooŋ pilale uneem. Kaŋ indi be du be wapmihiniye be indi wanakaŋ mu kumuneem. Kedeem hatineem. ");
INSERT INTO nop_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nu adi’walaŋ kweli kooŋ tibene udaneeŋ baakdok yofafaŋeelat. Ala mu nobu nagila, udaneeŋ buŋa habaake foloŋ kamewaat wondiniŋ yom adi nu foloŋ halune hatige hatige kumumbene dapmawaak. ");
INSERT INTO nop_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Indi wondok wele lufom mu tiyanim binek adi uŋat buŋat tinene nai lufom binek agaŋ tiluwek.” ");
INSERT INTO nop_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kaŋ beehik Isilae adi indiŋ yeniŋguk, “Taalii unduŋ titindok nobu hatuwek kaŋ hidi indiŋ tineeŋ. Kwet iŋoŋ nemek mintalak uŋaaaniŋ noli yabudakaleeŋ momohi u moŋgola likhik ginaŋ kadahiŋa wooŋ me u siloŋ timineeŋ. Ime wahu munduŋnit, simiŋkupuk gaaliki, bem gumamuum, bem mindip eŋ ŋaaso. ");
INSERT INTO nop_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Agaŋ muneeŋ koobuli eŋ koom nanaŋe lik maŋineŋ kadahi hambuune moŋgo bugiŋ u wanaŋ moŋgo uneeŋ. Waa nebek nadibubuye binek tiŋa tuguk. ");
INSERT INTO nop_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Unduŋ tiŋa kwayahik maaŋ nagila me adi’walaŋ kotigoŋ uneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Bepaŋ saŋiniŋ moloomdi me ad’walaŋ weleeŋ tubukwelemaune daahik eŋ Benyamin yeniŋkulune udaneeŋ buneeŋ. Biyagoŋ kuyoŋ, nu wapmihineye nobuniŋ nolom-bedapmaune kaŋ wapmihiŋit mokit undugoŋ hatibaat.” ");
INSERT INTO nop_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kaŋ mewoi adi unduŋ tiŋa muneeŋ koomii koobuli wanaŋ beegiŋ eŋ Benyamin maaŋ nagila Isipde uge uge Yosep’walaŋ usuagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Usuaune Yosepdi Benyamin daliyedut uune kaŋ kwanai meŋiŋ indiŋ niŋguk, “Yanagila yopmaŋ yapmeweŋ tiŋa kale dobuheeŋ nanaŋe he bop tibeŋ kaŋ mewoi adi mele leekiŋ diniŋ nanaŋe u nukut noŋgoŋ nanim.” ");
INSERT INTO nop_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Unduŋ nimbuune me woondi Yosepdi yoguk wondok tuwot tuguk. Tiŋa mewoi yanagila yopmaŋ yapmeguk. ");
INSERT INTO nop_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kaŋ adi Yosep yolineŋ yapmegiŋ doktiŋa munta kisaŋ tiŋa yogiŋ, “Kom bugumuneŋ liknik maŋiŋ ginaŋ muneeŋ kotigoŋ dahinimgiŋ ale muneeŋ wondok tiŋa iŋaŋ nipmeiŋ. Indi iŋoŋ hatneene labuŋa nihitehiŋa tipilapilaye me tuwaanit mookit nipmeneeŋ, eŋ kale dooŋkiniye kubo niloom moŋgotneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Unduŋ yoŋa Yosep’walaŋ yot kadoko hatiguk me u talik yemeŋ yatuune indiŋ niŋgiŋ, ");
INSERT INTO nop_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“O bombooŋginik, indi koom nanaŋe tuwane bugumun. ");
INSERT INTO nop_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ala udaneŋ uge uge yot deikumuneŋ usuwaaŋ liknik dilitoomŋa kagumun be muneeŋnik lik maŋineŋ uŋgoŋ kadahi nimgiŋ unduŋ yabuŋa boho tugumun. ");
INSERT INTO nop_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Unduŋ tiŋa yemun e muneeŋ kobuli maaŋ moŋgola bumun. Neediyeŋ liknik ginaŋ kadahiguk u indi mu nadiyam.” ");
INSERT INTO nop_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kaŋ adibo yoguk, “U kedem ale munta mu tineŋ. Biyagoŋ kuyoŋ hidee eŋ beehik’walaŋ Bepaŋdi likhik ginaŋ nemek wapum hamuŋguk. Eŋ muneeŋhik adi kedem busuaune yabugut.” Unduŋ yoŋa Simeon nagila fooŋ yemguk. ");
INSERT INTO nop_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tiŋa Yosep yolineŋ yanagila looŋ kayohik youtetdok ime giyemguk, tiŋa doŋkihiye nanaŋe yemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kaŋ adi Yosepdi bubundok woomŋale aditok siloŋ timindok nemek moŋgo bugiŋ u ha kunadaanegiŋ. Biyagoŋ kuyoŋ adi nanaŋe uŋaŋ nanandok yogiŋ u agaŋ nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ala Yosep busuaune nemek siloŋ timinee moŋgo bugiŋ u moŋgola looŋ miŋa adi’walaŋ habeen foloŋ duwookeneeŋ namandahik tubuwopmoobut tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Adi yadi yeninadiŋa yoguk, “Behik me gawadaŋdok yogiŋ adi dediŋ hatilak?” ");
INSERT INTO nop_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yobune yogiŋ, “Biyagoŋ kuyoŋ, tipilapilayege, beetnik, me gawadaŋ adi kedem hatilak.” Unduŋ niŋa mulelem tiŋa namandahik tubuwopmobut timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kaŋ adi dadiyeeŋ kwayaŋ Benyamin kaŋ yoguk, “Kwayahik kuyaniŋdok yogiŋ iŋaakoŋ be?” Tiŋa yoguk, “Mihi kadaa, Bepaŋ adi momooŋ tigamuŋa gabudokoluwaak.” ");
INSERT INTO nop_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosep adi unduŋ yoŋa pilap hinek ne’walaŋ yoli maaneŋ foguk. Adi kwayaŋ kaŋ bulaaniŋgoŋ kisaŋ nadiŋa makat kokotdegoŋ tiŋa unduŋ tuguk. Tiŋa uŋaŋ kookuk. ");
INSERT INTO nop_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tiŋa namanda youteela kotigoŋ fooŋ fafaŋeŋ yoguk, “Nanaŋe kameneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Tiŋa adi nanaŋe neehogok miŋa daliye adi maaŋ nehi hogok yemuŋa Isiphi maaŋ nehi hogok yemgiŋ. Biyagoŋ kuyoŋ Isip me adi Hibulu medut nanaŋe wanaŋ nanandok kamehep hatuguk. Isiphi adi wondok nadiune nemek maadimaadikegoŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Biyagoŋ kuyoŋ Yosep adi fukuniŋ ilune daliye adi fukuniŋ me tuwodi tububihila ilune mintagiŋ indigoŋ tuwolit ilune wooŋ kwayahik kuyaniŋdi iheguk. Kaŋ adi nemek u kaŋ bohoo tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Tiŋa Yosepdi yobune ne’walaŋ nanaŋe faalek ginaŋniŋ naanaŋe moŋgola yemgiŋ. Tiŋa nolidok kubugoŋ kubugoŋ boiyemgiŋ, eŋ Benyamindok adi 5, 5 unduŋ boigiŋ. Kaŋ daliye adi Yosepdut nanaŋe eŋ wain ime wanaŋ naaŋ wele momooŋ nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Kaŋ Yosepdi yot kadokoŋiŋ indiŋ niŋguk, “Du me saŋiniŋhikdok tuwolit nadiŋa pandiŋ likhik ginaŋ gidahiyembeŋ. Tiŋa yeweŋ e muneeŋhik u yek likhik maŋiŋ ginaŋ molomoloom pandiŋ wohiŋ foloŋ kadahiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ime utnaŋne siliwadi tutumbagiŋ uyadi kwayahik dikineŋ hinek adi’walaŋ lik ginaŋ pandiŋ muneeŋdut wanaŋ dahiweŋ.” Kaŋ agaŋ Yosepdi yoguk wondok tuwot tubudapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ala heleune mewoi eŋ kale dooŋkihiye wanaŋ yapmeune ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ulune nai mu kweheyeune Yosepdi yot kadokoŋiŋ indiŋ niŋguk, “Mewoi pilap hinek yahakaliŋa ulaŋ! Wooŋ yabuŋa indiŋ yenimbeŋ, ‘Hidi yadi nemek kedem tihamkabaune hidi kibi titiŋ hogoli timiŋa ");
INSERT INTO nop_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ime utnaŋŋiŋ siliwadi tutumbagiŋ u kubonemiŋit? Biyagoŋ kuyoŋ bombooŋgine adi ime utnaŋ wondigoŋ ime nalak. Tiŋa uŋaakoŋ kame hatiŋa kigili mede yolak. Iŋgoŋ e, hidiyadi kudi kadakaniŋ hinek timiŋit.’” ");
INSERT INTO nop_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kaŋ adi wooŋ yabuŋa mede uŋaakoŋ yeniŋguk. ");
INSERT INTO nop_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kaŋ adibo mede kibi indiŋ niŋgiŋ, “Bomboŋginik adi maŋgoŋde mede undiniŋ ninilak? Indi yadi titiŋ undihi mu tiyam. ");
INSERT INTO nop_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Indi koom muneeŋ liknik maŋneŋ muneeŋ yabugumun u ye kwatnaŋgoŋ Kanaaŋ kwetneniŋ tubuudaneŋ moŋgo bugumun. Unduŋ doktiŋa deetiŋa bomboŋgige’walaŋ yolineniŋ siliwa be gol kubo tineetumun? ");
INSERT INTO nop_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tipilapilayegeye needi’walaŋ tubumintaweŋ adiyadi kumuŋ tibek. Kaŋ noli indi tipilapilayegeye tineem.” ");
INSERT INTO nop_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Adibo yoguk, “Biyagoŋ kuyoŋ yoiŋ undugoŋ hinek mintawek. Biyagoŋ hinek needi’walaŋ lik ginaŋ tubumintanim adi tipilapilayene tibek, eŋ noli hidiyadi kedem hogok wooŋ hatineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Unduŋ yoŋa mewoi adi likhik kale dooŋki foloŋ woodigiŋ pilap kiteleeŋ moŋgofooŋ tawa lik mahik folokenehep tigiŋ u fiyakula molomoloom yamaadiyakiŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kaŋ adi tububihila me tuwo’walaŋ lik dihiguk tiŋa lik hogohogok dihitauuyeŋ kwayahik kuyaniŋ’walaŋ dihiune dapmaguk. Ime utnaŋ adi Benyamin’walaŋ liiginaŋ tubumintaguk. ");
INSERT INTO nop_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","U tubumintaune me hekidalit adi dahidahihik ulalaagineeŋ likhik moŋgola doŋki foloŋ boiŋa kotigoŋ udaneeŋ Yosep yolineŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yosep adi yopmaaŋgoŋ hatilune Yuda eŋ dali kwayaŋiye adi wooŋ kaŋ mulelem tiŋa adi mebiyeŋ namandahik tubuwopmoobut tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Kaŋ Yosepdi indiŋ yeniŋguk, “Hidi maŋgoŋ kudi tiŋit? Me niŋ nu indiniŋdi kigili mede yoŋa mebihik miiŋgoŋ tubumintawek aditok kaule be tiŋit?” ");
INSERT INTO nop_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kaŋ Yudadi indiŋ yoguk, “Bomboŋginik, du maŋgoŋ medebo ganinim bee Bepaŋdi tipilapilayegeye indi’walaŋ kadakaniŋ agaŋ miiŋgoŋ tubumintaguk doktiŋa maŋgoŋ mede folooŋbo yoŋa ganineene tuwot tibek? I nadiweŋ. Biyagoŋ kuyoŋ bombooŋginik, indi agaŋ du’walaŋ kwanai megeye tiyam, indi inde eŋ me likŋiŋ ginaŋ ime utnaŋ tubumintaŋaŋ adi maaŋ wanakaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kaŋ adibo yoguk, “Unduŋ mooŋ, adi tobo me needi’walaŋ lik ginaŋ ime utnaŋ ilaŋaak adi hogokdi nu’walaŋ tipilapilayemene hatibaak. Nooli hogohogok hidi kedem kwelemaaŋgoŋ beehik wooŋ kaneŋ.” ");
INSERT INTO nop_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Unduŋ yobune Yudadi pilap hinek looŋ indiŋ niŋguk, “O bombooŋgine, du yadi Felo netok tuwolit hatilaŋ iŋgoŋ fiit nu namandake foloŋ mede yobene nadiŋa kwihita mu tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Bombooŋginik, du tipilapilaye megeye indiŋ nininadiguŋ, ‘Hidi beehik be, bee kwayahik kuyaniŋ neembe hatilak?’ ");
INSERT INTO nop_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kaŋ indi bomboŋginik du indiŋ ganiŋgumun. ‘Indi beetnik uŋgoŋ hatilak, ala me gawadaaŋ tiŋa hatilune kwayanik kuyaniŋ niŋ mintaguk. Nee’walaŋ dali biyeniŋ kumuŋ tuguk. Mehikdi biyagoŋ hinek meyat lufom hogok yanagikuk ala adi hogok hatilak, unduŋ doktiŋa beudi kahile hinek tilak.’ ");
INSERT INTO nop_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kaŋ du ye tipilapilaye megeye indiŋ niniŋguŋ., ‘Hidi kwayahik nagila buune kawaat’ ");
INSERT INTO nop_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","kaŋ indi bombooŋginik, du indiŋ ganiŋgumun, ‘Mihi woondi beu tuwot mu bikaabaak, nobu bikaabaak adi beu kumumbaakneŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kaŋ du indiŋ nininguŋ, ‘Kwayahik kuyaniŋ mu baak adi hide hogok nu’walaŋ namandatne foloŋ mu mintaneeŋ hinek.’ ");
INSERT INTO nop_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Biyagoŋ kuyoŋ indi usuwaaŋ tipilapilayemege beetnik kaŋ du’walaŋ mede uŋaakoŋ hinek nimbuhikumun. ");
INSERT INTO nop_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kaŋ hatigane beetnikdi indiŋ niniŋguk, ‘Hidi kotigoŋ nanaŋeenik tuwane uneŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Unduŋ yobune indibo indiŋ niŋgumun, ‘Indi adi indee hogok mu unim. Kwayanik kuyaniŋ wanaŋ unim ninimbeŋ wondok kedem unim. Adinit mookit adi me wondiniŋ habeeŋ foloŋ mu usuwanim.’ ");
INSERT INTO nop_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Unduŋ yoneene beetnikdi indiŋ niniŋguk, ‘Tamnede mihineyat lufom hogok yeheŋeguk u hidi agaŋ nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kaŋ niŋ adi binabuŋa fiilune indiŋ yogut, “Adi yadi kale moihidi sibulaagibulaagit tuguk doktiŋa mu kagut eŋ indidegoŋ maaŋ mu kalat.” ");
INSERT INTO nop_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ala i hatilak adi maaŋ noloom tubuune nemek niŋ mintamimbuune nu guhakatnenitdi bulaaniŋgoŋ tiŋa kumumbaat wondok kibikooŋ kadakaniŋ hidi foloŋ lowaak.’ ");
INSERT INTO nop_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Unduŋ doktiŋa biyagoŋ hinek nu mihi adinit mookit tipilapilaye mege beetnik adi’walaŋ usuwawene weleeŋdi mihi u kahile hinek tilak doktiŋa ");
INSERT INTO nop_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","biyagoŋ hinek mihi u lohiŋa uŋaniŋgoŋ kumumbaak. Indi unduŋ nobu tineem adi betnikdi bulaniŋgoŋ tiŋa kumumbaak wendiniŋ yom inditok tibaakneŋ. ");
INSERT INTO nop_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Unduŋ doktiŋa tipilapilaye mege nu mihi aditok kibikooŋ titindok baatne yofolok indiŋ timiŋgut. ‘Nu munobu nagila udaneeŋ baat woondiŋ kibikooŋ yom adi du’walaŋ namandake foloŋ heki hatige hatige kumumbene dapmawaak.’ ");
INSERT INTO nop_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Unduŋ doktiŋa yoŋ adi tipilapilaye mege nu yadi mihidok kibikooŋ bomboŋgine dutok tipilapilaye hatigamdok nadinamŋa mihi u bikaabeŋ kaŋ daliyedut udaneeŋ wek. ");
INSERT INTO nop_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nu mihi adinit mookit baatne’walaŋ deeti udaneŋ wit? Nu baatne nemek undiniŋ mintamimbuune kakaŋdok munta hinek nadilat.” ");
INSERT INTO nop_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Kaŋ Yosep adi bulaaniŋgoŋ kisaŋ nadiŋa meeniŋ keleemadiŋa yakiŋ u indiŋ yeniŋguk, “Meeniŋ i yeniŋkulune fodapmaneŋ!” Unduŋ yobune Isiphi hogohogok adi fodapmaune Yosepdi daliye ne’walaŋ mebiŋiŋ yeniŋguk. ");
INSERT INTO nop_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tiŋa makat kakaŋ koola toobuune Isiphi metamdi nadigiŋ, eŋ metam Felo’walaŋ yolineŋ hatigiŋ adi maaŋ nadidapmagiŋ ");
INSERT INTO nop_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Unduŋ tiŋa Yosepdi daliye indiŋ yeniŋguk, “Nu Yosep! Baatne hatilakbe?” Kaŋ daliye adi sukuleeŋ bohoo kisaŋ tiŋa mahik gaaliune mede map yakiŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Unduŋ tubune Yosepdi daliye indiŋ yeniŋguk, “Hidi bubuyeeŋ yamaaŋgoŋ yatneŋ!” Kaŋ daliye adi wooŋ yamaŋgoŋ yalune indiŋ yoguk, “Nu kwayahik Yosep, biyagoŋ hinek me Isiphi kohohik foloŋ napmeeŋ nu’walaŋ tuwaaŋiŋ moŋgokiŋ nu iŋaakoŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ale munta mu tineŋ eŋ bulaaniŋgoŋ kisaŋ mu nadineŋ. Biyagoŋ kuyoŋ tuwaane moŋgola me Isip kohohik foloŋ napmegiŋ adi nu hehitubulodawene kedem hatidok Bepaŋdi napmeune koom bugut. ");
INSERT INTO nop_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yoŋ adi fiye kadaka nai halune gulet lufom agaŋ tilak. Tiŋa diniyeti bee moŋgotna yout mu tiŋa hogok indigoŋ hatiyaneene gulet 5 dapmawaak. ");
INSERT INTO nop_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Wapmihi tamhiye adi pilap mu liweneeŋ eŋ hidi’walahi metam feedi mu kumuŋa kaipmuŋ tomboyoula hatidok Bepaŋdi biyagoŋ hinek timeŋ napmeune bugut. ");
INSERT INTO nop_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ale hidi mooŋ, Bepaŋdi napmeune bugut. Adigoŋ Felo’walaŋ beu tiŋa yoli kadokoŋila Isip kwet wapum yendiniŋ me bombooŋgi hatidok napmeguk. ");
INSERT INTO nop_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Unduŋ doktiŋa pilap hinek wooŋ baatne nineŋ, ‘Mihige Yosep adi dutok mede indiŋ yolak, “Bepaŋdi Isip kwet hogohogok wondiniŋ me bombooŋgi napmeguk, ale du nadihimihimile mu tiŋa pilap hinek pilale nu’walaŋkade baaŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tiŋa na itoulatneŋ Goseŋ kwetneŋ yamaaŋgoŋ itouluwaaŋ. Du daa eŋ mihige laageye eŋ kale dompa makaugeye tiŋa nemenemek hakaamulak hogohogok wanakaŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Du uŋoŋ itoulune gabudokoluwaat. Woŋ adi fiye kadakadi gulet 5 tomboyoula halune daa be bee maagemaageye eŋ nemenemek hatigamiiŋ hogohogok hidi hambeep hinek tineeneŋ doktiŋa unduŋ tibaaŋ.”’” ");
INSERT INTO nop_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Unduŋ yoŋa indiŋ tomboyoula mewoi yeniŋguk, “Nu nagoŋ hinek hidut mede yonadi tilat u yadi hide dauhikdi hinek nabiiŋ, tiŋa kwayane Benyamindi maaŋ kalak. ");
INSERT INTO nop_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tiŋa Isip kwetneŋ kwanai loloŋnit namuŋgiŋ kaŋ tihatilat ube bee nemek noli kanadi tigiŋ u wanaŋ baatne mede kahat timineeŋ. Tiŋa pilap hinek nagila buneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Unduŋ yoŋa kwayaŋ Benyamindut kitoboo tiŋa makat kookumuk. ");
INSERT INTO nop_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Unduŋ tiŋa daliye hogohogok wanaŋ yobooŋa makat kobulabulaye tiyemguk. Unduŋ tiyembuune daliye adi kwayahik Yosepdut mede mede togiŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Unduŋ tubune Felo’walaŋ yolineŋ mede indiŋ usuaguk, Yosep’walaŋ daliye buŋit. Mede u Felo eŋ tipilapilaye metamŋiyedi nadiŋa wele momooŋ nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tiŋa Felodi Yosep indiŋ niŋguk, “Dakeye indiŋ yenimbeŋ, ‘Hidi nanaŋeehik kale woosi foloŋ boiŋa Kanaaŋ kwetneŋ kotigoŋ udaneeŋ wooŋ ");
INSERT INTO nop_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","beehik eŋ wapmihi tamhiye yanagila nu’walaŋkade buneeŋ. Kaŋ Isip kwetneŋ duhuduhu wapum hatak uŋaakoŋ hinek hambeene kwet uŋoŋ diniŋ nanaŋe kale hatak u naneeŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Du adi indiŋ yenimbeŋ yoŋa ganilat. ‘Hidi wapmihi tam doktiŋa Isiphi kaali woosidi yehemaaneiŋ u yehemaaneeŋ wooŋ behik nagi buneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Tiŋa undugoŋ nemenemekhik nolidok nadibedi mu tineeŋ. Isip kwet wapumneŋ nemek folooŋ momooŋ hinek mintalak uyek hiditok gigit tibaak.’” ");
INSERT INTO nop_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kaŋ Isilae mihiŋiye adi undugoŋ hinek tigiŋ. Tiŋa Yosep adi Felodi yoguk tuwot kaali eŋ talik foloŋ dumuŋ nakilitiŋa uundok wanaŋ yemguk. ");
INSERT INTO nop_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Tiŋa guletdok dahidahi molomoloom kubukubugoŋ yemguk eŋ Benyamindok adi guletdok dahidahi 5 eŋ siliwa muneeŋ 300 miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Unduŋ tiŋa yeguk e beudok adi donki 10 foloŋ Isiphi nemek momohi aditok tiulidokogiŋ eŋ donki taamuhi 10 foloŋ pandiŋ, bomboŋ noli eŋ talik buŋila nanandok dumuŋ belet heki umaaŋ boiune beeŋa ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Unduŋ tiŋa daliye yeniŋkula indiŋ yeniŋguk, “Hidi talipmeŋ uŋila tosiwe mu tineŋ.” ");
INSERT INTO nop_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Daliye Isip bikabuŋa uge uge Kanaaŋ wosuwaŋ behik Yakobo kaŋ mede kahat indiŋ timiŋgiŋ, ");
INSERT INTO nop_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“Yosep adi kaipmuŋ hatilak, biyagoŋ kuyoŋ adi Isip kwet diniŋ me bombooŋgi hatilak!” Iŋgoŋ e, beehik adi medehik nadiune folooŋ mu tubune wele kwaambuŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Unduŋ hatulune adi gigine tiŋa Yosepdi mede yeniŋguk tuwolit niŋdapmagiŋ. Kaŋ Yosepdi beu nagila uundok kaali wosidi yehihamantiiŋ kameemiŋguk u busuwaune beehik Yakop adi u kaŋ welemomooŋ hinek nadiguk. ");
INSERT INTO nop_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tiŋa yoguk, “Kedeem hinek mihine Yosep kaipmuŋ hatilak, tigaane nu mu kaŋ kumumbaatneŋ ale pilap wooŋ kawaat.” ");
INSERT INTO nop_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Kaŋ Isilae adi ne’walaŋ nemenemek hogohogok tiulidokooŋ moŋgodapmaaŋ Isipde moŋgola uguk. Wooŋ Beasiba yopmaŋ usuwaaŋ Beu Aisak’walaŋ Bepaŋ muni heemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kaŋ Bepaŋdi timiŋ lihine foloŋ Isilae indiŋ niŋguk, “Yakop, Yakop!” Adibo yoguk, “Nu yoŋ eeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kaŋ yoguk, “Nu baha’walaŋ Bepaŋ. Ale du Isipde wene munta mu tibeŋ. Nu uŋoŋ gehitubulodawene kisaŋ ulihakaaŋ me bop wapum fee tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nu dukut Isip kwetneŋ noŋgoŋ wooŋ hatibaat, hatigane kotigoŋ gehitubuudanewaat. Yosep negoŋ kohoŋdi dauge tiŋafooŋ kufulaawaak.” ");
INSERT INTO nop_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Unduŋ nimbuune Yakop adi Beasiba bikabuŋa pilalune mihiŋiye beehik eŋ wapmihihiye eŋ taamuhiye wanakaŋ kale wosidi kaali hamaneyagiŋ foloŋ yapmeune logiŋ. Biyagoŋ kuyoŋ, Felodi Yakop nagitdok kale wosidi kaali hamaneyagiŋ kameune buguk foloŋ logiŋ. ");
INSERT INTO nop_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Tiŋa yalakihiye eŋ nemenemek Kanaaŋ kwetneŋ hatilune mintayemgiŋ kaleehiye u wanaŋ moŋgola uge uge Isip kwetneŋ usuwagiŋ. Yakop eŋ yalakiŋiye hogohogok ");
INSERT INTO nop_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","mihiŋiŋ wabiŋiye eŋ laaŋiye wanaŋ hogohogok Isip kwetneŋ yanagila uguk. ");
INSERT INTO nop_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Kaŋ yoŋadi Isilae yalakiŋiye Isip kwetneŋ usuwagiŋ adi’walaŋ wouhik habet. Yakop mihiŋiye hinek: Luben Yakop mihiŋiŋ tuo. ");
INSERT INTO nop_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Luben mihiŋiye: Hanok, Pallu, Heslon eŋ Kami. ");
INSERT INTO nop_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon mihiŋiye: Yemuel, Yamin, Ohad, Yakin, Sohar, eŋ Shaul. Kanaaŋ tam’walaŋ mihi. ");
INSERT INTO nop_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi mihiŋiye: Gelson, Kohat, eŋ Melat. ");
INSERT INTO nop_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda mihiŋiye: Elo, Onan, Sila, Peles tiŋa Sela. Iŋgoŋ oŋ, Elo eŋ Onan adi Kanaaŋ kwetneŋ kumuŋgumuk. Peles mihiŋiyat: Heslon eŋ Hamul. ");
INSERT INTO nop_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka mihiŋiye: Tola, Pua, Yasup eŋ Simlon. ");
INSERT INTO nop_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulun mihiŋiye: Seled, Elon eŋ Yaleel. ");
INSERT INTO nop_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yoŋ adi Leadi Padan Alam kwetneŋ hatiŋila Yakopdok yanagilimiŋguk. Wabiŋiŋ Daina maaŋ. Kunakunathik kiulune 33 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad mihiŋiye: Sephon, Haggi, Suni, Esbon, Eli, Alodi eŋ Aleli. ");
INSERT INTO nop_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ase mihiŋiye: Imna, Iswa, Iswi eŋ Belia. Wihik Sela. Belia mihiŋiye: Hebe eŋ Makiel. ");
INSERT INTO nop_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Yakop’walaŋ wapmihi 16 yoŋ adi Silpadi yanagikuk. Silpa adi Labandi wabiŋiŋ Leadok tipilapilaye wabi miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakop taamuŋiŋ Lesel’walaŋ mihiŋiyat: Yosep, eŋ Benyamin. ");
INSERT INTO nop_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosep mihiŋiyat: Manase eŋ Eflaim adi yadi Isip kwetneŋ mintagumuk. Isipniŋ me loloŋnit Potifela adi’walaŋ wabiŋiŋ Asenat yanagikuk. ");
INSERT INTO nop_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin mihiŋiye: Bela, Beke, Asbel, Gela, Naaman, Ehi, Los, Mupim, Hupim eŋ Ad. ");
INSERT INTO nop_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yakop’walaŋ mihiŋiye 14 yoŋ adi Leseldi yanagikuk. ");
INSERT INTO nop_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan mihiŋiŋ: Husin. ");
INSERT INTO nop_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali mihiŋiye: Yasiel, Guni, Yesel, eŋ Silem. ");
INSERT INTO nop_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakop’walaŋ mihiŋiye 7 yoŋ adi Bilhadi yanagikuk. Bilha adi Labandi wabiŋiŋ Leseldok tipilapilaye wabiŋiŋ miŋguk. ");
INSERT INTO nop_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Metam Yakob ne’walaŋ yalakiŋiye mintagiŋ hogohogok yehikunatneene 66 tuguk. Yakop mihiŋiye’walaŋ tamhiye’walaŋ kunakunat adi iŋaŋ mu tomboyouliŋit. ");
INSERT INTO nop_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yosep’walaŋ mihiyat Isip kwetneŋ mintagumuk adi lufom hogok. Biyagoŋ hinek Yakop’walaŋ meeŋimeeŋiye Isip kwetneŋ budapmagiŋ kunakunathik 70. ");
INSERT INTO nop_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Taalipmeŋ uŋila Yakop adi Yuda niŋkulune Yosep nimbeene timeŋ uguk. Adi wooŋ nimbuune Goseŋ kwetneŋ wek yoŋa unduŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosep adi yobune kalis tiulidokomimbuune looŋ beu Isilae kawene Goseŋ kwetneŋ uguk. Wooŋ kaŋ tobooŋa kisaŋ kookuk. ");
INSERT INTO nop_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kaŋ Isilaedi Yosep indiŋ niŋguk, “Du kaipmuŋ hatilune gabulat doktiŋa kedem walane lodaune kumumbaat.” ");
INSERT INTO nop_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kaŋ Yosepdi daliye eŋ beu’walaŋ meeŋimeeŋiye indiŋ yeniŋguk, “Nu Felo wooŋ kaŋ indiŋ nimbit, ‘Datneye eŋ baatne’walaŋ meeŋimeeŋiye adi Kanaaŋ kwetneŋ hatigiŋ ala nu’walaŋkade bugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tiŋa adi yadi dompa yabudoko tiŋila makau kwanai maaŋ tiiŋ. Unduŋ doktiŋa dompa eŋ makauhiye wanaŋ yanagila bugiŋ.’ ");
INSERT INTO nop_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kaŋ Felodi hanihehamaneŋ, ‘Hidi maŋgoŋ kwanai tiiŋ’ ");
INSERT INTO nop_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","haninadiune indiŋ nineeŋ, ‘Tipilapilayegeye indi yadi beetniye dabugoŋ. Ala kuyahineeŋgoŋ kale kwanai tububihila tugumundi tiyam.’ Hidi unduŋ yoneŋ kaŋ Gosen kwetneŋ hatidok hanindapmawek. Isiphi me dompa makau kwanai tiiŋ meeniŋ undihidok adi nadiyembuune maadimaadikeeŋgoŋ tilak.” ");
INSERT INTO nop_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosep adi unduŋ yoŋa wooŋ Felo indiŋ niŋguk, “Baatne eŋ daatneye eŋ kale makauhiye eŋ nemenemekhiye hogohogok wanaŋ budapmaiŋ Goseŋ kwetneŋ hatiiŋ.” ");
INSERT INTO nop_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Tiŋa daliye walahi 5 yehidaaneeŋ Felo namanda foloŋ yapmeune yakiŋ. ");
INSERT INTO nop_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kaŋ Felodi Yosep daliye indiŋ yeninadiguk, “Hidi maŋgoŋ kwanai tiŋila hatiiŋ?” Unduŋ yeninadiune indiŋ niŋgiŋ, “Tipilapilayemegeye indi beetniye adi undihigoŋ dompa yabudoko kwanai tiyam.” ");
INSERT INTO nop_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tiŋa tomboyoula Felo indiŋ niŋgiŋ, “Indi yadi kwet iŋoŋ hogok buŋambu hatineene bugumun. Kanaaŋ kwetneŋ fiye kadaka wapum hinek hatak doktiŋa tipilapilayemegeye indi dompaniye adi nanaŋe map tigiŋ. Unduŋ doktiŋa tipilapilayemegeye indi Gosen kwetneŋ hatidok yoyam.” ");
INSERT INTO nop_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kaŋ Felodi Yosep indiŋ niŋguk, “Baha daakeye adi du’walaŋkade kedem bugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tiŋa du adi’walahi me kale kwanai tiŋa nadihinakiŋ neŋnobu nadiyemilaŋ kaŋ yehidaneeŋ nu’walaŋ kale yabudokodok yapmewaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Unduŋ tiŋa mindaŋ Yosepdi beu Felo titiŋeneune kakaŋdok nagila loguk. Kaŋ Yakopdi Felo kahaŋ timiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kaŋ Felodi Yakop ninadiguk, “Du guletge deedigoŋ?” ");
INSERT INTO nop_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakopdi Felo mede indiŋ tubuudanemiŋguk, “Kwet foloŋ buŋambu hatihati naine gulet 130 agaŋ dapmaguk. U nai muniŋgoŋ iŋgoŋ oŋ folofigita eŋ bulaaniŋgoŋnit. Tiŋa baatne eŋ papaneye’walaŋ kwet foloŋ buŋambu hatihatihik diniŋ gulet nai kweheyehi iŋgoŋ nu wondok tuwolit mu tubumintalat.” ");
INSERT INTO nop_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakop adi unduŋ yoŋa Felo kahaŋ timiŋa uguk. ");
INSERT INTO nop_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosep adi beu daliye yokwet tubuminta yemiŋa Isip kwet diniŋ faakiiniŋ nehitok gigit titindok yenindapmaguk. Kwet woŋ adi momooŋ hinek. Felodi yoguk wondok tuwot hinek Lamesesi kwet yemguk. ");
INSERT INTO nop_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Tiŋa Yosep adi beu daliye eŋ beu diniŋ meeŋimeeŋiye hogohogok eŋ wapmihihiyedok tuwolit nanaŋe daneyemguk. ");
INSERT INTO nop_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kaŋ kwetkwet belet eŋ nanaŋe lohigiŋ. Biyagoŋ hinek fiye kada wapum halune Isip eŋ Kanaaŋ kwetneŋ meeniŋ hatigiŋ adi nanaŋe map kisaŋ tiŋa kumuŋ gweheye tiŋa tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosep adi yadi Isip eŋ Kanaaŋ kwetneŋ nanaŋedok muneeŋ moŋgo bugiŋ hogohogok u moŋgola bopneguk. Tiŋa muneeŋ u Felo’walaŋ yolineŋ moŋgola uguk. ");
INSERT INTO nop_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Unduŋ titauuyeŋ Isip eŋ Kanaaŋ kwetneŋ wanaŋ muneeŋ dapmaune meeniŋdi Yosep’walaŋ buŋa yogiŋ, “Du nanaŋe nimbeŋ! Indi maŋgoŋde dauge foloŋgoŋ kumunim ale unduŋ niibikabaleeŋ hataŋ? Biyagoŋ hinek muneeŋnik agaŋ dapmaguk.” ");
INSERT INTO nop_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yobune Yosepdibo yoguk, “Muneeŋhik nobu dapmawek kaŋ kaleehik moŋgola buneŋ, kaŋ nu wondok kibikooŋ nanaŋe hambit.” ");
INSERT INTO nop_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Unduŋ yobune adi kaleehiye wosi, dompa, makau eŋ doŋki moŋgola buune kibi nanaŋe yemguk. Gulet wondok adi unduŋ tiŋa kale hekidi sidokoune nanaŋe yemtoiguk. ");
INSERT INTO nop_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Gulet u dapmaune gulet niŋ foloŋ kotigoŋ buŋa niŋgiŋ, “Bombooŋginik, indi du’walaŋ namandake foloŋ mebinik deeti kame heebinim. Muneeŋ agaŋ dapmaguk eŋ kaleenik hogohogok agaŋ dutok gigit tubudapmaguk. Unduŋ doktiŋa inde eŋ diniyetidok kwetnik hogok hatnimilak. ");
INSERT INTO nop_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Indi inde bee kwetnik u maŋgoŋde dauge foloŋ kadakanim? Unduŋ doktiŋa indi inde bee diniyeti kwetnik nanaŋedok nihituaune Felodok tipilapilaye kwanai timineem. Indi kumuŋ liwe tineene kwet hogok halaakneŋ ale nanaŋe youli nimbuune fiye diniyeti tineem.” ");
INSERT INTO nop_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Unduŋ yobune Yosepdi Isip kwetneŋ fiye diniyeti kwet hogohogok tuwadapmaune Felodok gigit tubudapmaguk. Fiye kadaka wapum hinek halune map kisaŋ tigiŋ tiŋa Isiphi feedi diniyeti kwethik tuwadok yodapmagiŋ kaŋ kwet u Felodok tubudapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tiŋa Yosepdi Isip kwet fukuŋ fukuŋ, wohiŋkade eŋ komaaŋkade meeniŋ hatitaugiŋ hogohogok Felo’walaŋ tipilapilaye kwanai titindok yeheŋedapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Me bepaŋ yalayalaŋ kwanai me heki’walaŋ kwet hogok adi mu tuwaguk. Adi yadi Felo’walaniŋ tuwahik moŋgokagiŋ, doktiŋa Felodi kwanaihikdok tuwaŋiŋ yemluguk woondi nanaŋeehik sidokoluguk. Unduŋ doktiŋa kwehik tuwadok mu yodapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kaŋ Yosepdi metam indiŋ yeniŋguk, “Nu kamiŋ hidee eŋ kwehik hehituwawene Felodok tubudapmaiŋ. Ale nanaŋe youli i moŋgola diniyeti tineŋ. ");
INSERT INTO nop_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ala folooŋ mintaune ugamaali bop 5 tilat yeŋke bop kubugoŋ e Felodok kameyaneeŋ eŋ hidetok e bop 4 moŋgokaneeŋ. Woŋ adi kwanai diniyeti kotigoŋ tubune mintaune hidee eŋ mehimehiye eŋ wapmihihiye hide nanandok unduŋ tiyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Adibo yogiŋ, “Du hatihatinik doktiŋa nihitubulodalaŋ, ale indi hatineem tuwot bomboŋginik du niibiune kedebaune Felo tipilapilaye timineem.” ");
INSERT INTO nop_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yosep adi unduŋ tiŋa Isip me kwehineŋ yodoko mede indiŋ kameune hakukdi hatak. Nanaŋe heki ugamale 5 bopneeŋ uŋaniŋ 1 e Felodok boiyaneeŋ. Me bepaŋ yalayalaŋ’walaŋ heheŋ tiyagiŋ heki’walaŋ kwehik hogok Felodok gigit mu tuguk. ");
INSERT INTO nop_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Unduŋ mintaune Isilae me adi biyagoŋ hinek Gosen kwetneŋ hogok itouyagiŋ. Tiŋa kwet u kahileeŋ mintaulihaka kisaŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Kaŋ Yakop adi Isip kwetneŋ gulet 17 tomboyoula hatibuune guletŋiŋ 147 dapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Unduŋ tubune kumuŋ naiŋiŋ dulaune mihiŋiŋ Yosep nihamaneune buune indiŋ niŋguk, “Du wele momooŋ eŋ siloŋ tinambeene kaŋ indiŋ tibaaŋ. Kohoge baane faalipmeŋ kameeŋ yofolok tinambeŋ. Du Isip kwetneŋ iŋoŋ mu nehiwenewaaŋ. ");
INSERT INTO nop_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nu ye baatne papaneye yehitomboyoula kumumbeene Isip kwetneniŋ nanagila wooŋ adi’walaŋ meweneŋ kwetneŋ nehiwenewaaŋ.” Adibo yoguk, “Yolaŋ wondok tuwot tibaat.” ");
INSERT INTO nop_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kaŋ yoguk, “Yofolok tinambeŋ.” Kaŋ yofolok timiŋguk. Kaŋ Yakop adi kuyaŋ foloŋ mali kwambundaaŋ ilaŋa Bepaŋ niutumbaguk. ");
INSERT INTO nop_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hatigane Yosep mede kahat indiŋ timiŋgiŋ, “Nadilaŋbe? Baha yagit tilak.” Kaŋ mihiŋiyat Manase eŋ Efilaim yeheŋeune ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kaŋ Yakop niŋgiŋ, “Abe nadilaŋ! Mihige Yosep gaabe buŋak.” Kaŋ Yakop adi fafaŋeeŋ gulupŋiŋ bikabuŋa pilale ikuk. ");
INSERT INTO nop_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Tiŋa Yosep indiŋ niŋguk, “Bepaŋ, Saŋiniŋ Moloom adi Kanaaŋ kwet wapumneŋ, Lusi yokwetneŋ uŋoŋ mintanamuŋa nehikahaŋneeŋ ");
INSERT INTO nop_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","indiŋ naniŋguk, ‘Naadilaŋbe? Nu gehikahaŋnewene kisaŋ ulihakawaaŋ. Tiŋa du me bop wapum fee tibaaŋ kaŋ yalakigeye adi kwet i yembeene aditok hinek fafaŋeniŋ halaak.’ ");
INSERT INTO nop_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Unduŋ doktiŋa nu Isip kwetneŋ mu buluwene mihigeyat lufom mintagumuk adi yadi nutok gigit tideemeek. Efelaim eŋ Manase adi yadi Luben eŋ Simeon hatinamaamuk aditok tuwolit hatinamdeemek. ");
INSERT INTO nop_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kaŋ wabige mihigeye mindaŋ mintagamneeŋ adi datok gigit hatigamuneeŋ. Adi kwet yenindapmaŋitneŋ uŋgoŋ hatineeŋ. Ala adi yadi nehi’walaŋ wouhik mu mintawaak. Dahiyat’walaŋ wouhik hogok miiŋgoŋ mintawaak. ");
INSERT INTO nop_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nu yadi Mesopotamia kwetneniŋ buge buge Efalata yokwet tubudulaluwene Lesel Kanaaŋ kwetneŋ kumumbuune Efalata yokwetneŋ Betelehem kuyoŋ uŋgoŋ wenefulagut.” ");
INSERT INTO nop_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Tiŋa Isilae adi Yosep mihiŋiyat yabuŋa yonadiguk, “Meyat i needigoŋ?” ");
INSERT INTO nop_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kaŋ Yosepdi beu indiŋ niŋguk, “Mihineyat kwet iŋoŋ hatiluwene biyagoŋ hinek Bepaŋdi namguk.” Adibo yoguk, “Yeenimbuune budemek kaŋ yehikahaŋnewit.” ");
INSERT INTO nop_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Isilae adi agaŋ me gawadaaŋ hinek tuguk doktiŋa dawi sububa tuguk, unduŋ doktiŋa nemek kedemgoŋ mu yabukiyondaguk. Tiŋa yenimbuune hebeeŋ foloŋ wooŋ yalune yobooŋa yehisiŋgoŋgomeguk. ");
INSERT INTO nop_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Tiŋa Yosep indiŋ niŋguk, “Nu namanadaake kotigoŋ kawaat u mu nadisugut, iŋgoŋ ya Bepaŋdi nadinambuune yalakigeyat maaŋ yabulat.” ");
INSERT INTO nop_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kaŋ Yosepdi baaŋ foloŋniŋ yeheŋeŋ fooŋ kwet foloŋ yambiyale duwookeneeŋ namanda kwet foloŋ tubuwopmobut tuguk. ");
INSERT INTO nop_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Unduŋ tiŋa Yosep adi kohoŋ didimeniŋdi Efalaim nagila Isilae’walaŋ kohoŋ kapmaadineŋkade kameguk, agaŋ kohoŋ kapmadidi Manase nagila Isilae’walaŋ kohoŋ didimeniŋneŋkade kameguk. ");
INSERT INTO nop_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kaŋ Isilaedi kohoŋ kikalakapmeŋ kihiwaleŋa kohoŋ didimeniŋ mona Efalaim mebi foloŋ kameguk. Eŋ kohoŋ kapmaadi e tuo Manase mebi foloŋ kameguk. ");
INSERT INTO nop_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Unduŋ tiŋa yehikahaŋneeŋ indiŋ yoguk, “Baatne papaneyat Abalaham eŋ Aisak adi Bepaŋ’walaŋ namanda foloŋ hatigumuk. Bepaŋ adigoŋ hinek kahaŋ tiyembek. Fologfigita mebimebi ginaŋniŋ nehitubulodaguk, ");
INSERT INTO nop_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Aŋelo woondi mihiyat i yehikahaŋneune nu’walaŋ wotnanedi adi foloŋ haali wooŋ halaak. Tiŋa baatne papaneyat Alalaham eŋ Aisak adi’walaŋ wouhik maaŋ. Kaŋ mihiyat adi kwet foloŋ kisaŋ ulihakadeemeek.” ");
INSERT INTO nop_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kaŋ Yosep adi beudi kohoŋ didimeniŋ Efalaim’walaŋ mebi foloŋ kameguk u kaune tuwot mu tubune beu’walaŋ kohoŋ Efalaim’walaŋ mebi foloŋ hakuk kwehene tiŋa Manase’walaŋ mebi foloŋ kamewit yoŋa tuguk ");
INSERT INTO nop_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","tiŋa yoguk, “Mebaŋ unduŋ mooŋ! Mihi tuo adi iŋak ale kohoge didimeniŋ adi adifoloŋ kameweŋ.” ");
INSERT INTO nop_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Iŋgoŋ Beu adi mooŋ niŋa yoguk, “Mihine, nu agaŋ nadilat. Nu nadihinaka tilat Manase adi maaŋ me loloŋnit hatibaak eŋ adi’walaŋ yalakiŋiye adi meeniŋ bop wapum fee tineeŋ. Ala kwayaŋdi kabe kalakapmewaak tiŋa adi’walaŋ yalakiŋiyedi meeniŋ bop mohok fefe tiŋa hatineeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Unduŋ yoŋa melenai uŋaniŋgoŋ yehikahaŋneeŋ yoguk, “Hidi’walaŋ wouhik foloŋ yofolok tiyaneeŋ Isilae me adi yokahaŋ tineene indiŋ yoyaneeŋ. Bepaŋ adi Efelaim eŋ Manase yehikahaŋneguk wondok tuwolit tihambaak.” Biyagoŋ kuyoŋ adi unduŋ tiŋa yeguk e Efilaim Manasedok me wapum kameguk. ");
INSERT INTO nop_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Isilae adi unduŋ tiŋa Yosep indiŋ niŋguk, “Nu adi agaŋ kumuŋdok naine dula tilak. Bepaŋ adi hidut hatige hatige hanagilune dadahiye kwehineŋ kotigoŋ udaneŋ uneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Biyagoŋ kuyoŋ nu kwet haaŋgi niŋ Amolihi tebedi eŋ kwaadidi widihi yahakaliŋa yoloom tigut uye dutok hogok tomboyoula gamulat.” ");
INSERT INTO nop_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nai niŋde Yakop adi mihiŋiye yeniyeheemaaneeŋ indiŋ yoguk, “Hidi bopneneŋ, kaŋ kougoŋ hatitaloneeneŋ nemek mintahambaak wondok mede hanimbit. ");
INSERT INTO nop_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mihineye, hidi bopnedapmaneŋ, tiŋa beehik Isilae nu’walaŋkade maagihik kametnadineŋ!” ");
INSERT INTO nop_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Luben du mihine tuo. Biyagoŋ hinek du yadi saŋiniŋ eŋ fafaŋene diniŋ folooŋ timeŋ mintaguŋ. ");
INSERT INTO nop_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Du yadi imedi kiula fafaŋeniŋgoŋ miŋoobu taulak undiniŋ. Du baha nu’walaŋ gulup foloŋ loguŋ tiŋa yeguŋ e nai uŋaniŋ gulup u tubugeŋgeŋ tuguŋ. Unduŋ doktiŋa me wapum loloŋnit mu hatibaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon eŋ Lewi, hidi yadalit. Miikhikdi folofigita kwanai tilak. ");
INSERT INTO nop_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Walanedi hidi’walaŋ bop ginaŋ mu tomboyoulaat. Hidi kwihita foloŋ me widihikumuŋgumuk eŋ weleehik be maagihik youhep tiŋa kale makau yehitubufigitagumuk doktiŋa wotnegigitdi adi’walaŋ nadihebet mu ulihiwaak. ");
INSERT INTO nop_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Naadikadakahikdi weleehik kudupdalak doktiŋa haaki timiŋdok, eŋ kwihitahik wapum umaaŋ. Nu Yakop’walaŋ kwet foloŋ hehiulitawawaat, eŋ Isilae me heki’walaŋ lekiŋgoŋhik gineniŋ hehidaanewaat.” ");
INSERT INTO nop_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, du yadi daake kwayagedi ganiutumba tiyaneeŋ. Kohoge adi memikgeye’walaŋ koodihik foloŋ halaak. Baha’walaŋ mihiŋiye adi du’walaŋkade duwookeneneeŋ. ");
INSERT INTO nop_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, du yadi kale layon mihiniŋ nabugoŋ. O mihine, du kale molo, kale utnaŋ tihatiŋa bediguŋ. Du kale layon maaniŋ mihiniŋ undiniŋ fooŋ hakweleelaŋ tiŋa undugoŋ layon tamuniŋ undiniŋ. Neediyeŋ galaamut kedem tibek? ");
INSERT INTO nop_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Maapme diniŋ kuyaŋ woŋ adi Yuda’walaŋ kayoŋ bop mu bikabuŋa waak. Eŋ talitimeŋ hatihati u yadi kayogedi yalidihiŋa ilaaŋ. Kaŋ moloomge saŋiniŋ gamulakdi busuwaune kwetkwet meeniŋ hogohogok mede tiloloŋ timineeŋ. ");
INSERT INTO nop_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Du doŋkige miiŋ wain mebi foloŋ tehilaŋ eŋ doŋkige mihiniŋ wain taŋeeniŋ foloŋ tehilaaŋ. Du houlege wain ime ginaŋ youteetaŋ. Eŋ dahidahige wain kiliki diniŋ ime ginaŋ fulaalaŋ. ");
INSERT INTO nop_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Dauge kiliki wain fee nalaŋ doktiŋa gimindalak. Eŋ mage kitili noom doktiŋa fafau tilak.” ");
INSERT INTO nop_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebuloŋ, du yadi imeŋguwaŋ gagayeŋ itouluwaaŋ. Du yadi muwage ime foloŋ yawiiŋ adi wooŋ yali bomboŋ be meeniŋ boiŋ eŋ moŋgokiiŋ kwet undiniŋ u uge uge fekŋiŋ Sidon kwetneŋ usuwalak.” ");
INSERT INTO nop_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isaka, du yadi doŋki fafaŋeeŋ. Kale dompa eŋ makau gimbahaŋ lekiŋgoŋ ginaŋ deitoulaŋ. ");
INSERT INTO nop_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Haatikulege diniŋ hamuhe u kobaaŋ. Eŋ dahat tuguŋ kwaake woŋ adi kedem. Du unduŋ kaŋ bomboŋ moŋgoleene kaluaŋge kihiwaale gigine tiŋa kwanai wondok tipilapilaye kwanai tuguŋ.” ");
INSERT INTO nop_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan, du yadi Isilae mebop noli hatiiŋ undiniŋgoŋ. Du nokeye’walaŋ medehik nadiŋa yodapmalaŋ. ");
INSERT INTO nop_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Du yadi miŋgembet mimimŋit eŋ muhabo undiniŋ tiŋa kale wosi kayoŋ yahihili foloŋ siune kale wosi foloniŋ ila haulak adi sigisigi mafaiŋa maaŋ ulaak.” ");
INSERT INTO nop_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“O Wapum, nu tubukedebakedebagedok woomhatilat.” ");
INSERT INTO nop_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad, du yadi memikgeyedi helemahelemaŋ gula gahakaliiŋ. Kaŋ dubo kayohik ginaŋ teteliŋgoŋ wooŋ widihilaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ase, du yadi nanaŋe kale duhuduhu hinek hakaamulak doktiŋa nanaŋe heki kobaahi hinek u daane tibaaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali, du yadi kale hamap ginaŋ hatiiŋ undiniŋ. Du kuyeŋ kap momooŋ toobihitaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosep, du yadi bem taŋeniŋ foloŋ mindipmuŋ fee undiniŋ. Bem yoŋ kabe foloŋ mindipmuŋ fee nit ime gagayeŋ yalune taŋeniŋ adi gimbisaŋ lahula taŋambai tilak. ");
INSERT INTO nop_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Me tebe molo heki adi mikdok busuwaaŋ wele youyout tigamuŋa tebehik fiyagikiŋ iŋgoŋ ");
INSERT INTO nop_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","da’walaŋ tebe adi yadi fiit waliwali mu tiŋa yakuk. Eŋ kohogedi maaŋ mu giyakuk. Du Isilai’walaŋ kadoko me eŋ kawade hakat adi’walaŋ wou foloŋ ulodiguŋ doktiŋa Yakop nu’walaŋ Saŋiniŋ Moloomdi gehitubulodaguk. ");
INSERT INTO nop_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Baha, nu’walaŋ Bepaŋ adi gehitubukilitiguk adigoŋ gehitubulodawaak. Bepaŋ Saŋiniŋ Moloom adi ulolooŋ tigamguk adigoŋ gehitubulodawaak. Adi kunumneniŋ duhuduhudi kahaŋ tigambaak. Adi kwet maaneŋ ime kainiŋ dumuŋ hatak wondi kahaŋ tigambaak. Tiŋa wapmihi mintaminta eŋ nom wanakaŋ kahaŋ tigambaak. ");
INSERT INTO nop_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Baha nu’walaŋ kahaŋ adi kwebobe waaniŋ itak undiniŋ u kalakapmeŋ kwebobe fafaŋeniŋ diniŋ kwet gaaliki umaaŋ kalakapme hinek tilak. Kahaŋ u hogohogok u yadi Yosep dufoloŋ hatneeŋ. Biyagoŋ kuyoŋ, daakeye lekiŋgoŋhik ginaŋniŋ gabukahileeŋ gehitiulidokooŋ ganagiliŋit, du foloŋ halaak.” ");
INSERT INTO nop_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin, du yadi kamo miknit hinek. Du yadi haniŋ kale kelekeleye tiŋa nalaŋ. Eŋ timiŋ adi nanaŋe kale diki hatak u daaneelaŋ.” ");
INSERT INTO nop_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Biyagoŋ hinek, mewoi i hogohogok adi Isilae mebop 12. Adi hinek kuyoŋ behikdi kahaŋ tiyemguk. Biyagoŋ kuyoŋ molomoloom yenikahaŋ tiŋa kahaŋ tiyemiŋguk. ");
INSERT INTO nop_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Unduŋ tiŋa mede yenindoko tiŋa indiŋ yeniŋguk, “Nu maanemaneye koomihi’walaŋ wene hidi baatne papaneye adi hakiiŋneŋ uŋgoŋ nehiwenefalaaneeŋ. Woŋ adi Kanaaŋ kwetneŋ Mamele mele labulakneŋkade kwet faakii wou Makpela, Hitaitniŋ meniŋ wou Efelon adi’walaŋ hewehewe fiye ginaŋ kawade mage hatakneŋ uŋoŋ nehiweneneeŋ. Hewehewe fiye woŋ adi Hitaitniŋ me wou Efelon adi’walaŋ ala Abalahamdi meeniŋ kumuhi yehiwenefalaadok tuwaguk. ");
INSERT INTO nop_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abalaham eŋ tamŋiŋ Sala uŋgoŋ yehiwenefalagiŋ, eŋ Aisak eŋ tamŋiŋ Lebeka yehiwenefalagiŋ, ala nubo Lea uŋgoŋ wenefalagut. ");
INSERT INTO nop_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Hewehewe fiye eŋ kawade mage woŋ adi Hitaithi’walaŋ tuwaŋit.” ");
INSERT INTO nop_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Biyagoŋ hinek, Yakop adi mihiŋiye mede unduŋ yeniŋkilitiŋa yenindidimedapmaaŋ kayoŋyat lufomnikoŋ yehihamaneune loune kumuŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yakop kumumbuune Yosepdi beu tobooŋa koola siŋgoŋgomeguk. ");
INSERT INTO nop_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Unduŋ tiŋa tipilapilaye meŋiye eŋ haguo meŋiye adi beu’walaŋ sigiŋ gitnem pilap mu bitakadok haguwo goomindok yeniŋguk. Kaŋ adi Yakop haguwo goomiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kwanai u hatitulune melenai 40 tuguk. Nai yagigi undugoŋ tagiŋ. Kaŋ metam Isiphi adi Yakopdok makunum melenai 70 tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Makunum dapmaune Yosepdi Felo meeŋimeeŋiye indiŋ yeniŋguk, “Hidi nutok nemek momooŋ niŋ tinamunee nadiiŋ kaŋ nutok kibikooŋ Felo indiŋ nineeŋ, ");
INSERT INTO nop_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Baatne adi indiŋ nifafaŋedok yoguk, “Nu kumumbeene dabaaŋne Kanaaŋ kwetneŋ kawade ginaaŋniŋ naatok waamukut, uŋgoŋ nehiwenewaaŋ.” Nu wondok-ku tiŋa wooŋ baatne wenefalaŋa kotigoŋ bubundok yolat.’” ");
INSERT INTO nop_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kaŋ Felodibo yoguk, “Kedeem yolaŋ undugoŋ tibeŋ. Tiŋa medege yofafaŋe tuguŋ undugoŋ wooŋ baha wenefalaaweŋ.” ");
INSERT INTO nop_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kaŋ Yosep adi beu wenefalaawene uguk. Kaŋ Felo tipilapilaye meŋiye eŋ talitimeŋhiye eŋ Isiphi me loloŋnit adi maaŋ wanaŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Tiŋa Yosep eŋ Isilae neehi’walaŋ wapmihitam eŋ mehimehiye wanakaŋ hogohogok udapmagiŋ. Wapmihi kuyakuya eŋ kale makau heki hogok adi Gosen kwetneŋ uŋgoŋ biyabuune hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kalis eŋ meeniŋ kale wosi foloŋ yawagiŋ adi maaŋ ugiŋ. Unduŋ doktiŋa metam fee hinek ugiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kaŋ adi uge uge Goleŋ Atadi kwet, Yodan ime gagayeŋ uŋgoŋ usuwaaŋ makaham kakaaŋ tooŋa kisaŋ kookiŋ. Unduŋ tiŋa Yosep adi beu doktiŋa kobulabulaye melenai 7 tuguk. ");
INSERT INTO nop_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Unduŋ doktiŋa Kanaaŋhi uŋoŋ itouyagiŋdi yabunadiŋa yogiŋ, “Woŋ adi Isiphi kuyeŋ makunum tiiŋ oŋ.” Unduŋ yoŋa kwet wondok wou Abe Misilaim yogiŋ, eŋ nai indidegoŋ uŋaakoŋ yoiŋ, ala kwet woŋ adi Yodan ime guŋaandiŋ hatak. ");
INSERT INTO nop_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yakop mihiŋiye adi ne yodakaleguk wondok tuwot tigiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Adi Kanaaŋ kwetneŋ tiŋa wooŋ Mamele kwetneŋ mele labulakneŋkade Makpela kwetneŋ kawade mage hakuk, Abalahamdi Hitaitniŋ me Efelon adi’walaniŋ me yehiweneŋdok tuwagukneŋ wenefalagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosep adi beu wenefulaŋa ne eŋ daliye eŋ noliŋiye hogohogok adut beu wenefalane noŋgoŋ ugiŋ ala kotigoŋ udaneeŋ Isipde udapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yosep daliye adi beehik kumumbuune kaŋ yogiŋ, “Tiyauge Yosep adi nemek kadakaniŋ timiŋgumun hogohogok wondok kibibo nemek mulabumuŋ neeŋ tinimbaakneŋ ala!” ");
INSERT INTO nop_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Unduŋ yoŋa adi’walaŋkade mede indiŋ kameune uguk, “Bahadi kumumbe tiŋila indiŋ ninindakaleguk, ");
INSERT INTO nop_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Yosep indiŋ nineeŋ, “Dakeye indi kadakaniŋ hogoli hinek tigamgumun wendiniŋ yom u fiit liliwenekutnimbaaŋ.” ‘Unduŋ doktiŋa yuku ganinadiyam oŋ, baha diniŋ Bepaŋ adi’walaŋ tipilapilaye heki hatiyam doktiŋa yomnik fiit liliwenekulaaŋ.” Kaŋ Yosepdi mede u nadiŋa makat kookuk. ");
INSERT INTO nop_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kaŋ daliye nehibo Yosep’walaŋ hebeŋ ginaŋ wooŋ namandahik tubuwopmobula yogiŋ, “Indi yadi tipilapilayegeye.” ");
INSERT INTO nop_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Unduŋ tubune Yosepdi yeniŋguk, “Munta mu tineŋ! Nu Bepaŋ kwelineŋ mu yatat! ");
INSERT INTO nop_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Hidi biyagoŋ mulabumuŋ mintanamdok nadiŋa tigiŋ. Iŋgoŋ Bepaŋ adi tubuudaneune nemek momooŋ mintaguk. Meeniŋ fee’walaŋ hatihatihik kedebadok nadiune unduŋ mintaguk u nai indidegoŋ miiŋgoŋ kayam. ");
INSERT INTO nop_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Unduŋ doktiŋa munta mu tineŋ. Nu hide eŋ wapmihihiye wanakaŋ habudokooŋ hamtoiwaat.” Unduŋ yeniwihiŋa yeniŋkwelemaguk. ");
INSERT INTO nop_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosep ne eŋ beu’walaŋ kayoŋ bopŋiye Isip kwetneŋ hatigiŋ. Yosep adi guletŋiŋ 110 dapmaguk. ");
INSERT INTO nop_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Unduŋ hatiŋa dadaŋiye Efalaim’walaŋ laŋiye mintaune yabuguk. Tiŋa Manase’walaŋ mihiŋiŋ Makili wapmihiŋiye maaŋ yoboguk. ");
INSERT INTO nop_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kaŋ Yosepdi dali kwayaŋiye indiŋ yeniŋguk, “Nu ya agaŋ kumumbaat. Bepaŋ adi yadi habudokooŋ hehitubulodawaak. Tiŋa kwet iŋaniŋ hanagila heheŋeŋ wooŋ kwet Abalaham, Aisak eŋ Yakop yenifafaŋegukneŋ uŋoŋ hamewaak.” ");
INSERT INTO nop_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Unduŋ yoŋa Yosepdi Isilae mihiŋiye adi Bepaŋ’walaŋ namanda foloŋ mede yokwambundamindok yeniŋguk. Indiŋ yoguk, “Bepaŋdi hanagilaak nai uŋaniŋ kitiline wanaŋ tiŋa uneeŋ.” ");
INSERT INTO nop_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kaŋ Yosep adi guletŋiŋ 110 kaŋ kumuŋguk. Kumumbune sigiŋ gitnem pilap mu bitakadok haguwodi gomina Isip kwetneŋ kumuŋ bogit niŋ ginaŋ dahiŋa kameune hakuk. ");
INSERT INTO nop_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Me nediyeŋdi me kadakahi’walaŋ mede mu tagimnelak tiŋa undugoŋ me kadakaniŋ titiŋ heki’walaŋ talik mu kelelak, be me Bepaŋ nimpekit tiiŋ heki gut ipilat mu tilak adi yadi Bepaŋdi kahaŋ timimbune nadifo hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Me woŋ adi Yahwe’walaŋ Yodoko Medeŋiŋ wendok nadigalika hinek tilak, doktiŋa timiŋ be hadapmo adi uŋgoŋ hati nadituwat tilak. ");
INSERT INTO nop_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Me woŋ adi bem niŋ ime gagayeŋ yetigiŋ undiniŋ. Adi naiŋiŋ foloŋgoŋ hinek folooŋ folak, tiŋa undugoŋ hapmuŋ kumuhaŋinda mu tiiŋ. Nemenemek tilak hogohogok u momooŋ hinek mintalak. ");
INSERT INTO nop_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Me kadakahi adi undihi moŋ. Mokoŋ hinek. Adi yadi figifigi sububadi fedikutak undihi. ");
INSERT INTO nop_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Unduŋ doktiŋa me kadakahi adi yadi Bepaŋdi nai wapum foloŋ mede nadinadi kwanai tibaak uŋaniŋ tuwot mu saŋindaneeŋ. Tiŋa me kadakaniŋ titiŋ heki adi yadi me didimehi’walaŋ lekiŋgoŋhik gineŋ mu hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Yahwe adi me didimehi’walaŋ titiŋhikdok nadiune tuwot tilak. Iŋgoŋ me kadakaniŋ tiiŋ heki adi yadi liwedapmaŋ tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Maŋgoŋde tiŋa mebop noli adi foko titiŋdok mede yofolok tiiŋ? Dediŋ doktiŋa metam i kadakaniŋ titiŋdok mede yofolokenefit indiŋ tiiŋ? ");
INSERT INTO nop_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Me mapme kwetkwet hatiiŋ hogohogok adi mikdok tiulidoko tubudapmaiŋ. Kaŋ me talitimeŋ heki adi Yahwe ne tiŋa me metamŋiye yabudokodok tubumintaguk u yehitifofoŋdok bop tiŋa talik lohiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Adi indiŋ yoiŋ, “Indi kohonik nemek fafaŋeniŋdi youkilitigumuk i kahibulaginekuyemnim. Indi tawa fafaŋeniŋdi nihi-ibikilitigumuk i fiyakutnim.” ");
INSERT INTO nop_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Bepaŋ adi kunum gineŋ ne’walaŋ mapme popŋiŋ foloŋ ila yabugege tiŋa yenimpekit tilak. ");
INSERT INTO nop_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Unduŋ tiŋa yelak e’, weleŋ gouyeune mede saŋiniŋnit hinek yenilak. Eŋ gibitaŋ kwihitaune adi wendoktiŋa munta kisaŋ hinek tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Tiŋa indiŋ yenilak, “Nu me i nagoŋ me mapme mintadok nindapmagut. Tiŋa nagoŋ Saiyon kweboboene foloŋ hatidok niŋgut.” ");
INSERT INTO nop_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Me mapmedi indiŋ yolak, “Nu kamiŋ Yahwedi mede yofafaŋelak u yohautawit. Adi indiŋ yofafaŋelak, ‘Du biyagoŋ hinek na’walaŋ mihine. Nu kamiŋ tububihila du’walaŋ baha tilat. ");
INSERT INTO nop_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Naninadiune mebop noli hogohogok gamdapmawene du kwet wanakaŋ hogohogok u kadokodapmawaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Du kohoge saŋiniŋnit wendi yabudokowaaŋ. Tiŋa metamdi kwet kabot ulitawaune pupuheneeŋ kuyahi kuyahi tiiŋ wendok tuwot tiyembaaŋ.’” ");
INSERT INTO nop_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Unduŋ doktiŋa me mapme heki hidi magi kametnadi momooŋgoŋ tiŋa titiŋhik tubudidimeneŋ. Eŋ kwetfoloŋdok talitimeŋ hatiiŋ hidi mede u kanadiŋila hatineŋ. ");
INSERT INTO nop_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Hidi Yahwedok munta timiŋa adi’walaŋ hebeŋ gineŋ hatineŋ. Munta timiŋila nadifo maaŋ tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Hidi mihiŋiŋ’walaŋ hebeŋ gineŋ hatiŋila siŋgoŋgome tineŋ. Adi yadi kwihita pilap tilak, unduneŋ doktiŋa tiyaugene nadikwihitahambune kumuneeneŋ. Me nediyeŋ Bepaŋ nadisukilitimiŋa adi yahehewe timindok yoŋa adi’walaŋkade wooŋ galilak adi yadi Bepaŋdi kahaŋ timimbune nadifo kedem tilak. ");
INSERT INTO nop_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Yahwe, memikneye fee hinek mintaaŋ nehitubu-kadakaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Tiŋa indiŋ naniiŋ, “Bepaŋ adi tuwot mu gehitubu-lodawek.” ");
INSERT INTO nop_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Iŋgoŋ oŋ, medehik wendi folooŋ mu tilak. Yahwe, du kubugoŋdi mik diniŋ kweletalak unduŋ tiŋa yahenamulaŋ. Du kubugoŋdi nehitubu-lodaune yalakapmeŋ tilat. Du kubugoŋdi welemulapne ulatifooŋ nehitubu-lodaune saŋiniŋnit yatat. ");
INSERT INTO nop_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Nu Yahwedi nehitubu-lodadok kutiniŋgut. Kaŋ ne’walaŋ kweboboe uŋgoniŋ foloŋ haliŋa kutikutine nadiŋa nehitubu-lodaguk. ");
INSERT INTO nop_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Nu adi damo deila agaŋ deikauleeŋ hakut. Iŋgoŋ oŋ, Yahwedi nabudokolak doktiŋa kotigoŋ sukuleeŋ pilali hatilat. ");
INSERT INTO nop_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Memik 10 tausen unduŋdi nehi-kelemadidapmaiŋ, iŋgoŋ nu aditok munta mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Yahwe, du beŋ. Bepaŋne, du buŋa nehitubu-lodaweŋ. Du memik tinamiiŋ mahik geŋ foloŋ kisaŋ hinek widihiŋa yehitubu-mekalaŋ, tiŋa me hogohi’walaŋ mahik kitili ugolokuyemulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yahwe, du kubugoŋdi unduŋ tiŋa kotigoŋ ninigitaŋ kaŋ nemek niŋdi nemu nihitubu-kadakalak. Du’walaŋ kahaŋgedi metamgeye foloŋ haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Bepaŋ, du nehitubu-lodaune fafaŋe tilat. Doktiŋa kutiganimbene kutikutine nadiweŋ. Nu koom welemulap kisaŋ tibe nehitubu-lodaguŋ. Du siloŋ tobogoŋ tinamuŋa yonadine nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Me heki, hidi nai dedigoŋ wotnenegigit yotifo tineeŋ? Nai dedigoŋ nemenemek hogohi wendok nadigalika tineeŋ? Be nai dedigoŋ titiŋ yalayalaŋ keleneeŋ? ");
INSERT INTO nop_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Hidi mede i momooŋgoŋ hinek nadineŋ. Me nediyeŋ Yahwe hebeŋ foloŋ hatiiŋ adi yadi netok hinek yabukahilelak. Nu adi helemahelemaŋ kutinimbe kutikutine nadinamulak. ");
INSERT INTO nop_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Hidi Bepaŋdok munta tiŋa kadakaniŋ mu taneeŋ. Gulup foloŋ deihaliŋila mede yendok nadituwatuwaleyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Hidi Yahwedi dumuŋ hemundumunduŋe dedihigoŋ titiŋdok nadilak undihigoŋ hinek heyaneeŋ. Unduŋ tiŋa adi hogok nadisukilitimiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Metam feedi indiŋ yoiŋ, “Indi nemenemek fofohi beŋa kedem nadifo tinim. Yahwe, du siloŋ tobogoŋ tiŋa nihitubu-lodaweŋ.” ");
INSERT INTO nop_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Metam undihidi dininahik gineŋ wit gut waindi folooŋ fee mintaune nadifo tiiŋ. Iŋgoŋ nadifo du welene gineŋ tubumintaguŋ wendi adi’walaŋ nadifohik u kalakapme tilak. ");
INSERT INTO nop_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Yahwe, du kubugoŋdi nabudokoune momooŋ hatilat. Unduŋ doktiŋa damo deikaule tilatneŋ nai uŋaniŋ nemek niŋdok munta nemu tilat. ");
INSERT INTO nop_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Yahwe, koyonedok magi kametnadi tibeŋ. Tiŋa yonadine nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Du Mapme tiŋa Bepaŋne, du hogok ganinadilat. Du kutikutine nadinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yahwe, nu adi haniŋ indigoŋ tuwot ganinadilat. Eŋ helemahelemaŋ mele labune yonadi kwanai gibita tilat, wendi dutok siloŋ tigamulat. Unduŋ tiŋa yonadine tubu-udanenambeŋdok woomulat. ");
INSERT INTO nop_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Bepaŋ, du titiŋ hogohidok nadiune utumba mu tilak. Me kadakaniŋ titiŋ heki adi du mu gehitubu-dulaaŋ hatidok. ");
INSERT INTO nop_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Du me fokohinit biyabune namandake foloŋ tuwot mu yatneeŋ. Du me kadakaniŋ tiiŋ heki yabukwihita tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Du adi yalaŋ-me heki yehitubu-liwe tubu-dapmalaŋ. Eŋ me widihi kumuŋ tiiŋ heki be me tikamanda tiiŋ, metam undihi sigilulum tiyemulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Iŋgoŋ welegedi hinek nabukahilelaŋ. Unduŋ doktiŋa yokeneŋ kedem wit. Yoke uŋgoniŋ gineŋ uŋoŋ wooŋ mulelem tigamuŋa wohoge ganiutumbait. ");
INSERT INTO nop_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Yahwe, memik heki nehitubu-kadaka tine tiiŋ, ale kayone tubudidimeune du’walaŋ titiŋ fofooŋ uŋak takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Memikneye heki adi yadi mede biyagoŋ-kabe nemu yoiŋ. Adi yadi metam yehitubu-kadakadok hogok hati yoiŋ. Eŋ mahik adi meyotneŋ mekoŋ dobune yatak undihi. Unduŋ doktiŋa metam feedi adi’walaŋ titiŋhik keleneŋ yoŋa mede yogaligalike hati tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Bepaŋ, mede foloŋ yapmeŋ kibikoŋhik tubu-udaneyemiŋa nehi’walaŋ nadinadi hogohi wendi yehitubu-kadakaweŋ. Adi gabuhaŋinda tiŋa kadakaniŋ fee tiiŋ, unduŋ doktiŋa namandake foloŋ hatiiŋ u yehikelekulune wooŋ kweetniŋ hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Iŋgoŋ metam nediyeŋ du yahehewe tiyemdok nadiŋa buŋa dukut galiiŋ adi yadi nadifo tineŋ. Welehik gineŋ nadifo pilalune nadifo kap toneŋ. Metam nediyeŋ welehikdi gabukahile hinek tiiŋ adi momooŋgoŋ hinek yabudokolaŋ. Adi kedem gibitaŋ nadifooŋ wohoge ganintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Yahwe, du metam medege takalihinakaiŋdok kahaŋ momooŋ hinek tiyemilaŋ. Tiŋa du mik diniŋ kweletalak nabugoŋ tiŋa yaheyemilaŋ. Unduŋ tiŋa yabudokoune momooŋ hinek hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Yahwe, du kwihita tiŋa nu mu nanintobeŋ be welege kadakaune nehitubu-didimewene kaŋ nemek malabumuŋ hinek mu tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Yahwe, nu saŋiniŋne dapmahinakaune saŋiniŋ lohilat. Doktiŋa du siloŋ tobogoŋ tinamuŋa kotigoŋ saŋiniŋ nambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Nu welemulap kisaŋ hinek tilat. Kaŋ Yahwe, du dediŋ doktiŋa nai kweheyeniŋ hinek binabulaŋ? ");
INSERT INTO nop_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Yahwe, du me siloŋ tobogoŋ titiŋdi kedem buŋa nehitubu-lodaaŋ kotigoŋ nanagilune mu kumumbit. ");
INSERT INTO nop_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Me kumuŋ tigiŋ heki adi du kotigoŋ mu nadigamiiŋ, tiŋa adi kwet hakiiŋneŋ uŋoŋ adi wohoge mu ganintiloiŋ. ");
INSERT INTO nop_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Nu kuti kobulabulayeŋ tigetige saŋiniŋne dapmalak. Timiŋ indigoŋ tuwot makat kotiwene dautilitiliknedi kwet damodeitat u tubu-mendadapmaŋ tilak. Tiŋa undugoŋ makat gibita kotiwene mebi uloloŋne mendadapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Memikneyedi fee tubune wendoktiŋa makat hakotat. Tiŋa daune bediune nemenemek tuwot mu yabulat. ");
INSERT INTO nop_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Me titiŋ hogohi tiiŋ, hidi binabuŋa ut. Yahwe adi makat kotat i agaŋ nadinamulak. ");
INSERT INTO nop_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Nu Yahwedi nehitubu-lodadok kutniŋgut, kaŋ adi kutikutine nadiŋa yonadine agaŋ tubu-udanelak. ");
INSERT INTO nop_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Memikneye adi malabumuŋ wapum hinek tubumintaneeŋ. Tiŋa meka tiŋa moŋ kaŋ muntaaŋ pilap hinek uŋoŋdibek momogiyondaaŋ uhebineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Yahwe Bepaŋne, nu memikneye doktiŋa du’walaŋkade buŋa hebihatat. Doktiŋa nehitubu-lodaaŋ kotigoŋ nanagilune me nulukumuŋ tine nehikeleiŋdi mu nehitubu-kadakaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Be dambek niŋ nanagila wooŋ laiondi metam yehisibulaginelak unduŋ nehitubu-kadakaune nediyeŋbo yoŋa nehitubu-lodawek. ");
INSERT INTO nop_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Yahwe Bepaŋne, nu me notne tikamanda timiŋa mede yalaŋ nenobu nimbit, ");
INSERT INTO nop_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","be memikne kadakaniŋ nenobu timimbit kaŋ kedem yomne eŋ kadakaniŋne wendok kibikoŋ ");
INSERT INTO nop_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","memik heki kedem biyabune buŋa nehikeleeŋ nohoneneŋ. Tiŋa nehitubu-kadakaaŋ foloone gitnem tukulune kwetfoloŋ kedem halek. ");
INSERT INTO nop_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Yahwe, du kwihitaaŋ pilali memik tinamiiŋ yehitubu-kadakaweŋ. Bepaŋne, du titiŋ didimeniŋdok nadilaŋ doktiŋa pilali nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Du kunum gineŋ mapme kumopopge foloŋ ila metam hogohogok yenimbune buŋa yamaiŋgoŋ gehitubu-dulaaŋ bopneune yabudokoluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Yahwe, du metam hogohogok’walaŋ titiŋhik kameka tilaŋ. Unduŋ doktiŋa nu titiŋ didimeniŋ hogok tiŋa kadakaniŋ nemu tilat wendok nadiŋa nehitubu-lodaune mede kwanai foloŋ fafaŋeeŋ yali yalakapme tibit. ");
INSERT INTO nop_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Bepaŋ, du adi didimeniŋ hinek. Du metam hogohogok’walaŋ nadinadihik eŋ welehik kameka tilaŋ. Unduŋ doktiŋa me kadakahi’walaŋ titiŋ kadakahi u yehitubu-fidapmaŋ tibeŋ. Unduŋ tiŋa me didimehi u kedem yehitubu-lodaune fafaŋe tiŋa yatneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Bepaŋ adi kweletalak dabugoŋ tiŋa yahehewe tinamulak. Metam nediyeŋdi adi’walaŋ medeŋiŋ takaliiŋ heki adi yadi yehitubu-loda tilak. ");
INSERT INTO nop_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Bepaŋ adi mede nadinadi kwanai didimeŋgoŋ tilak. Tiŋa helemahelemaŋ me kadakaniŋ titiŋ heki adi yadi yabukwihitaaŋ kibikoŋhik tubu-udaneyemilak. ");
INSERT INTO nop_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Me kadakahidi wele tubutakale mu tubune kaŋ Bepaŋ adi miknoŋŋiŋ iutumba tilak, tiŋa tebeŋiŋ tehiŋa mik titiŋdok tiulidoko tilak. ");
INSERT INTO nop_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Adi tebe kandam maŋiŋ mikit u tiulidokoyem tiŋa hatak. Adi me heki u widihikumuŋdok tebe kaŋguma heki agaŋ tiulidokooŋ woomulak. ");
INSERT INTO nop_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Metam nadinadi kadakahi nadisuhebet tubune welehik gineŋ hatak adi folooŋ kadakaniŋ tubumintaiŋ. Adi malabumuŋ titiŋdok tiulidoko tiŋa helemahelemaŋ yalaŋ fee hinek yoiŋ. ");
INSERT INTO nop_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Adi me noli yohonedok kwetfoloŋ koŋ dobiiŋ. Iŋgoŋ nehigoŋ koŋhik gineŋ uŋgoŋ maaŋ foneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Nehi uŋgoŋ malabumuŋ gineŋ foneeŋ, eŋ me nolidok mik-kwadi tiyemdok hatitulune wendigoŋ nehitok udaneyembaak. ");
INSERT INTO nop_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Yahwe adi didimeniŋ hinehinek doktiŋa nu adi kap toŋa Yahwe Loloŋnit hinek wou nintilooŋ niutumbalat. ");
INSERT INTO nop_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Yahwe, du Wapumnik, kwetkwet wohogedi loloŋnit hinek hatak. Wohogegigitdi kunum foloŋ tokidapmaŋ tiŋa hatak. ");
INSERT INTO nop_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Dagoŋ memik heki eŋ me du’walaŋ medegedok sigilulum timiiŋ hekidok talik kamehep fafaŋeniŋ tiyemdok nadilaŋ doktiŋa wapmihi kuyahi maaŋ du wohoge ganintiloloŋdok yenindidimelaŋ. ");
INSERT INTO nop_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Nu kunum kameguŋ eŋ muyakip tiŋa bamholiŋa heki boiguŋ ikiiŋ u yabuŋa indiŋ nadilat: ");
INSERT INTO nop_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Me indi dedihigoŋ hinek doktiŋa inditok nadinimilaŋ? Indi maŋgoŋ biyagoŋ doktiŋa du momooŋ hinek nibudokolaŋ. ");
INSERT INTO nop_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Du nihitutumbaaŋ da’walaŋ hebeke foloŋ fofoŋhinit nipmeguŋ. Tiŋa ninintiŋalooŋ wotninikgigit loloŋnit nimguŋ. ");
INSERT INTO nop_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Du nemenemek hogohogok u yehitubu-mintaaŋ yabudokodok ninindapmaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Nemenemek indi’walaŋ hebetnik gineŋ hatiiŋ adi indiŋ: Dompa, makau tiŋa kale hogohogok behepneŋ hatiiŋ ");
INSERT INTO nop_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","tiŋa bagi eŋ pisi tiŋa undugoŋ imeŋgwaŋ maaneŋ kaleŋgiŋgiŋ hatiiŋ hogohogok wanakaŋ. ");
INSERT INTO nop_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Yahwe, du Wapumnik, kwetkwet wohogedi loloŋnit hinek hatak. ");
INSERT INTO nop_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Yahwe, nu welenedi hinek ganiutumbaluwaat. Tiŋa du nemenemek hogohogok momooŋ tuguŋ wondok metam yenihautaluwaat. ");
INSERT INTO nop_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Nu dutok tiŋa kap tonadifo tuluwaat. Nu kap toŋa Bepaŋ loloŋnit wohoge ganintilooŋ ganiutumbaluwaat. ");
INSERT INTO nop_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Memikneye adi du saŋiniŋhik ulatifolaŋ doktiŋa momoŋ wooŋ kumuŋdapmaŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Du me mede nadinadi dabugoŋ kumopop foloŋ ila mede yodapmandapmaŋ kwanai didimeŋgoŋ tilaŋ doktiŋa du titiŋne kamekaaŋ nehitubu-lodaune mede gineŋ fafaŋeeŋ yolat. ");
INSERT INTO nop_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Du me mu nadigamiiŋ tiŋa me hogohi agaŋ mede foloŋ yapmeeŋ yehitubu-kadakadapmaguŋ tiŋa wohiye agaŋ tumolokukuŋ doktiŋa metamdi kotigoŋ-kabe nemu nadiyemneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Memik a yehitubu-kadakaguŋ doktiŋa adi undugoŋ hatiyaneeŋ. Bepaŋ, du memik heki’walaŋ yohik kwehik agaŋ wiyapupuhenekuyemguŋ, doktiŋa adi undugoŋ hatiyaneeŋ. Nebek niŋdi kotigoŋ nemu nadiyembaak. ");
INSERT INTO nop_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Yahwe adi Mapme hatigukdi hatilak. Adi kwelineŋ ila mede nadinadi titiŋdok agaŋ yodapmalak. ");
INSERT INTO nop_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Adi metam hogohogok yabudokolak tiŋa Yodoko Medeŋiŋ adi didimehi hogok. Tiŋa titiŋŋiŋ didimeniŋ foloŋ metam hogohogok’walaŋ titiŋhik kamekaaŋ yodapmaŋ tibaak. ");
INSERT INTO nop_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Wapum adi yooŋ fafaŋeniŋ. Unduŋ doktiŋa nebek niŋdi memikŋiye dut malabumuŋ tubumintaaŋ kaŋ momoŋ tiŋa adi’walaŋkade uluwaak. Be malabumuŋ mintahambune adi’walaŋkade wooŋ hebi hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Yahwe, du metam du’walaŋkade biiŋ hekidok sigilulum mu tiyemilaŋ. Unduŋ doktiŋa metamdi nadigamneeneŋ nai uŋaniŋ du nadisukilitigamneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Yahwe adi Saiyon yokwet wapumneŋ uŋoŋ Me Mapme loloŋnit itak, doktiŋa kap toŋa wou nintiloneeŋ. Tiŋa kwanai wapum tuguk u metam hogohogok yenihautaune nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Wapum adi me nohiye widihikumuŋgiŋ diniŋ kadakaniŋhik uŋgoŋ hati nadiyemilak. Adi folofigita nadiiŋ’walaŋ kutikutihik nadidok magi kamehep mu tilak. Adi yadi toboniŋ yehitubu-lodaaŋ me nediyeŋ kadakaniŋ tiyemiiŋ hekidok kibikoŋ tubu-udaneyemilak. ");
INSERT INTO nop_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Yahwe, du memik hekidi malabumuŋ eŋ folofigita namiiŋ u kaŋ siloŋ tobogoŋ tinambeŋ. Kaŋ nu agaŋ kumuŋdok muniniŋ tubu-dulalat gineniŋ kotigoŋ nehitubu-lodaaŋ nanagilune kedem hatiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Wendoktiŋa du nemenemek tuguŋ wondok kahat tiŋa wohoge ganintiloit. Nu Saiyon yokwet wapum yeme foloŋ yali nadifo tiŋa du kotigoŋ nanagikuŋ wondok yohautawit. ");
INSERT INTO nop_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Metam mu nadigamiiŋ hekidi indi maaŋ fonene ninigitdok yoŋa koŋ niŋ dobugiŋ, iŋgoŋ toboniŋ nehigoŋ fooŋ yadiweiŋ. Tiŋa undugoŋ nihonedok yoŋa begep ibigiŋ iŋgoŋ toboniŋ nehi widihiguk. ");
INSERT INTO nop_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yahwe adi ne’walaŋ titiŋŋiŋ u mede nadinadi kwanai foloŋ miŋgoŋ tubumintalak. Me hogohi adi me noli yehitubu-kadakadok nemek noli tigiŋ, iŋgoŋ tubu-udaneeŋ nehi uŋgoŋ yehitubu-kadakaguk. ");
INSERT INTO nop_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Me hogohi eŋ mebop noli Bepaŋ sigilulum timiiŋ heki hogohogok adi wanakaŋ kumuhi hakiiŋneŋ uŋoŋ wanakaŋ udapmaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Helemahelemaŋ Bepaŋ adi me fofoŋhinitdok nadikaule mu tiyemilak. Unduŋ doktiŋa malabumuŋhinit adi yehitubu-lodadok yoŋa hogok woomhafit mu tiiŋ. Adi Bepaŋ nadisukilitimiŋa woomimbune yehitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Yahwe, du kwetfoloŋ memetam mu biyabune gabuhaŋindaneŋ. Du pilali me mu nadigamiiŋ u yanagila buŋa mede foloŋ yapmeeŋ titiŋhik kamekaaŋ yodapmaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Yahwe, du fafaŋeniŋgoŋ yehiwidihiune hehele tiŋa fiyebulabulap tiŋa nehitok indiŋ nadineeŋ, “Indi kwetfoloŋ me, Yahwe’walaŋ saŋiniŋdok tuwot mooŋ.” Yehitubu-munta tubune metam adi nehitok nadiune fofoŋnit tibek. ");
INSERT INTO nop_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Yahwe, du maŋgoŋde binabuŋa kweetniŋgoŋ wooŋ yataŋ? Eŋ nai kadakaniŋ gineŋ maŋgoŋde namandake kufulahebi tilaŋ? ");
INSERT INTO nop_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Me hogohi adi foko tiŋa me fofoŋhinit yehitubu-kadakadok yehikeleiŋ. Adi me noli yehitubu-kadakadok nadihebet tigiŋ wondi yakaleeŋ nehi widihiwaak. ");
INSERT INTO nop_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Me hogoli adi titiŋŋiŋ hogoli wendok foko tiyaulak. Tiŋa nemenemek fee yabunadigalika tilak. Unduŋ tiŋa Wapum sigilulum timiŋa yosilone timilak. ");
INSERT INTO nop_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Me hogoli adi na nemenemek hogohogok agaŋ nadidapmalat yoŋa Bepaŋdok munta mu tilak. Unduŋ doktiŋa indiŋ yolak, “Kadakaniŋne wendok kibikoŋ tuwot mu tubu-udanenambaak.” ");
INSERT INTO nop_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Me hogolidi nemenemek tilak kaŋ momooŋ mintalak. Iŋgoŋ Wapum’walaŋ nadinadiŋiŋ-kabe nemu kaŋ nadilak. Tiŋa adi yadi memikŋiyedok yenimpekit tilak. ");
INSERT INTO nop_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Adi indiŋ nadilak, “Na fafaŋe tiŋa yatat doktiŋa nemek niŋdi tuwot mu nehitifowek. Tiŋa undugoŋ malabumuŋ tuwot mu mintanambaak.” ");
INSERT INTO nop_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Tiŋa helemahelemaŋ me noli yehitubu-kadakadok yosilone tiyemilak. Tiŋa undugoŋ yehitubu-munta titiŋdok mede yalayalaŋ yenilak. Tiŋa kadakaniŋ be malabumuŋ mebimebi tubumintadok pilap hinek yolak. ");
INSERT INTO nop_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Me woŋ adi me momohi buune widihi-kumuŋdok nadiŋa yokwet maaneŋ kabup hebihatilak. Tiŋa undugoŋ hebihali me gweheyehi u yehitubu-kadakadok woomyemilak. ");
INSERT INTO nop_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Adi yadi me fiyewakahi buune yohonedok laiondi yoli ginaneŋ woomhatak wendok tuwot hebihali woomyemilak. Ala buŋa begepŋiŋ gineŋ foune widihilak. ");
INSERT INTO nop_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Adi me fafaŋeeŋ doktiŋa kabup ila mik hewoom tiŋa me gweheyehi yehitiŋafooŋ widihiŋa widihigagaye tilak. ");
INSERT INTO nop_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Me hogoli wendi indiŋ nadilak, “Bepaŋ adi titiŋnedok nadibedi mu tilak. Adi dawi agaŋ teheguk doktiŋa tuwot mu nabek.” ");
INSERT INTO nop_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Ale Yahwe, du beŋ. Bepaŋ, du me u tubu-kadakaweŋ, tiŋa me malabumuŋhinitdok kaule mu tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Me hogolidi du sigilulum tigamuŋa weleŋ gineŋ indiŋ nadigamulak. “Adi kadakaniŋnedok kibikoŋ tuwot mu tubu-udanenambek.” ");
INSERT INTO nop_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Iŋgoŋ oŋ, du adi me hogohi diniŋ titiŋhik agaŋ kanadilaŋ. Tiŋa undugoŋ metamdok folofigita be malabumuŋ yemiiŋ u maaŋ agaŋ yabunadilaŋ, tiŋa malabumuŋhik yehitubu-lodadok tiulidokooŋ woom tilaŋ. Eŋ me fiyewakahi tiŋa me gweheyehi nediyeŋ du’walaŋkade biiŋ u yehitubu-lodalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Du me hogohi’walaŋ saŋiniŋhik be titiŋhik hogohi u tubu-liwedapmayembune kotigoŋ nemu tubumintaune kawaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yahwe adi Mapme loloŋnit hatigukdi hatilak. Unduŋ doktiŋa metam nediyeŋ adi mu nadisukilitimiiŋ adi yadi kwelineŋ yehikele-kudapmaŋ tibaak. ");
INSERT INTO nop_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","18","Yahwe, du metam gweheyehi fofoŋhinit heki’walaŋ yonadihik nadiyemiŋa welehik tubukilitibeŋ. Tiŋa du kondiŋahi eŋ metam malabumuŋhinit’walaŋ kutikutihik nadiyembeŋ. Du yehitubu-lodaune mede gineŋ fafaŋe tineŋ. Kaŋ metam kwetfoloŋ nai muniŋgoŋ-kabe hatineŋdi kadakaniŋ kotigoŋ mu tiyemneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Nu Yahwedi yahehewe tinambek yoŋa adi’walaŋkade bulat. Kaŋ du tububuyebe tiŋa bagi niŋdi momoŋ tiŋa ulak wendok tuwot momoŋ kweboboe foloŋ lowit yo nanilaŋ? ");
INSERT INTO nop_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Biyagoŋ hinek, me hogohi adi me didimehi yalamdok mambip gineŋ tebe kaŋgumahik sumuyeyekeeŋ tebesithik hamane-dindineeŋ woomyemiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Metam hogohogokdi titiŋ fofohi biyabudapmaune metam didimehi adi dediŋ buyo tineŋ? ");
INSERT INTO nop_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Yahwe adi Siloŋyot uŋgoniŋ gineŋ hatak. Adi yadi kunum gineŋ Mapme loloŋnit ilaŋa kwetkwet metam hogohogokdi maŋgoŋ tiiŋ u ila kanadidapmalak. ");
INSERT INTO nop_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yahwe adi me didimehi be me hogohi wanakaŋ yabunadi tilak. Tiŋa metam Yodoko Medeŋiŋ sigilulum timiiŋdok adi weleŋdi yabukwihita hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Wendoktiŋa tuwahik diniŋ kibikoŋ kudup-mebem ime dabugoŋ kwatneune fooŋ me hogohi u yehidalak. ");
INSERT INTO nop_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Yahwe ne adi titiŋ didimeniŋ hogok tilak. Unduŋ doktiŋa metam didimehi adi yabukahile hinek tilak. Ale metam nediyeŋ Bepaŋ’walaŋ medeŋiŋ takalineeŋ adi yadi namanda kaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Nai indinde me fofooŋ nemu hatilak. Tiŋa nai indinde me didimeniŋ maaŋ undugoŋ nemu hatibune kalaŋ. Unduŋ doktiŋa, Yahwe, du nihitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Metam hogohogok nohiyedok yalaŋ yeniiŋ, eŋ tikamanda tiyemiŋa yenihohoket tiyemiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Yahwe, du me mede yohohoke tiyawiiŋ heki’walaŋ mahik kameheyembeŋ. Eŋ me foko tiŋa sigitiŋalo mede yoiŋ heki’walaŋ maaŋ mahik teheyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Meheki undihidi indiŋ yoiŋ, “Indi nediyeŋ nibudokolak ale? Indi maŋgoŋ yone nadiŋa kaŋ inde nadiyam tuwolit yonim. Nebek niŋdi tuwot mu kamehenimbek.” ");
INSERT INTO nop_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Yahwedi indiŋ yolak, “Metamdi me fofoŋhinit yenintifo tiiŋ eŋ malabumuŋhinit adi folofigita nadiŋa kobulabulaye tiiŋ. Wendoktiŋa nu buŋa hatihati kulemaŋdok nadigigine tiŋa woom hatiiŋ u yembit.” ");
INSERT INTO nop_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yahwe’walaŋ yofafaŋe medeŋiŋ adi biyagoŋ hinek tiŋa medeŋiŋ adi momooŋ hinek silwa kudup gineŋ nai 7 unduŋ heune daaŋ fafau niyaniyaŋ hinek tilak wendok tuwolit. ");
INSERT INTO nop_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Me hogohi adi kwetkwet yaudapmaŋ tiiŋ. Kaŋ metam hogohogokdi titiŋ hogoli u nadiune titiŋ fofooŋ tubu-dapmalak. Unduŋ doktiŋa Yahwe, du nibiulidokoweŋ. Tiŋa helemahelemaŋ momooŋgoŋ hinek nibudokoune me hogohidi tuwot mu nihitubu-kadakaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Yahwe, nai deniŋ kotigoŋ nadinambaaŋ? Be agaŋ binabudapmaŋ hinek-kube tilaŋ? Be nai dedigoŋ hinek sigilulum tinambaaŋ? ");
INSERT INTO nop_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Nai deniŋ hinek folofigitane dapmawaak? Be helebufa dedigoŋ hinek welemulap nadiwaat? Be nai dedigoŋ hinek binabune memikneyedi nehitifoneeŋ? ");
INSERT INTO nop_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","O Yahwe, Bepaŋne, nutok nadinamuŋa yonadine nadiweŋ. Tiŋa kotigoŋ nehitubu-kilitiune kumuŋ mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Unduŋ tubune memikneyedi indiŋ tuwot mu yoneŋ, “Agaŋ yalitifooŋ kalakapmemun.” Du mu binabeŋ, toboniŋ nehitubu-lodaune memikneyedi naniŋgege tiŋa nadifo tuwot mu tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Du welegedi hinek nabukahilelaŋ u helemahelemaŋ unduŋ hinek nadisukilitilat. Tiŋa du kotigoŋ nanagilaaŋ doktiŋa nu nadifo tilat. ");
INSERT INTO nop_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Yahwe negoŋ momooŋ hinek tinamguk doktiŋa nu kap toŋa nadifooŋ wou nintiloit. ");
INSERT INTO nop_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Me nadinadihinit mokit kaulehi, adi nehi welehik gineŋ indiŋ yoiŋ, “Bepaŋ nemu hatilak.” Me undihi adi me hogohi. Adi yadi titiŋhik madimadikeŋgoŋ tiiŋ. Nebek niŋdi titiŋ momooŋ nemu tilak. ");
INSERT INTO nop_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yahwe adi kunum foloŋ hali diweune foune metam nadinadi fuliŋgoŋhinit ne’walaŋkade nenobu baneŋ, unduŋ yoŋa yabunadi tilak. ");
INSERT INTO nop_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Iŋgoŋ mokoŋ. Metam hogohogok wanakaŋ talik fofooŋ u bikabudapmaŋ tiiŋ. Adi’walaaniŋ kubugoŋ-kabe niŋdi titiŋ didimeniŋ-kabe nemu tilak. Mokoŋ hinek. Adi hogohogok kadakaniŋ gineŋ fodapmaaŋ me kadakahi hogok mintadapmaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Yahwedi indiŋ yolak, “Me kadakaniŋ tiiŋ heki yoŋ adi nadinadihinit mokit bidak? Adi yadi metamneye nadibedinit mokit hogok yehitubu-kadakafit tiiŋ. Tiŋa naninadi-kabe nemu tiiŋ.” ");
INSERT INTO nop_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Unduŋ doktiŋa Bepaŋdi metam nediyeŋ medeŋiŋ takaliiŋ heki adigut halaak, kaŋ me heki u munta kisaŋ hinek tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Me hogohi, hidi me fofoŋhinitdi nemek kedem tinene nadihebet tiiŋ kaŋ tubufiit tiyemiŋa yehitubu-gweheye tine tiiŋ. Iŋgoŋ oŋ, Yahwedi yabu-ulidoko tilak. ");
INSERT INTO nop_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Nu adi indiŋ hinek nadilat. Yahwedi Saiyonniŋ me niŋ kameune buŋa Isilaehi metam kotigoŋ yanagilaak. Bepaŋdi metamŋiye yehitubu-lodaaŋ kotigoŋ yanagilune momooŋ hatineeŋ. Biyagoŋ hinek, Jekop’walaŋ yalakiŋiye adi welemomooŋ nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Yahwe, me nediyeŋdi du yokeneŋ kedem hatibek? Be me nediyeŋdi da’walaŋ kweboboege uŋgoniŋ foloŋ Saiyon uŋoŋ looŋ itouwek? ");
INSERT INTO nop_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Me nediyeŋdi nemenemek hogohogok gineŋ Bepaŋ’walaŋ nadinadiŋiŋ takalilak, tiŋa helemahelemaŋ titiŋ didimeniŋ tilak, eŋ helemahelemaŋ mede biyagoŋ hogok yolak. Adiyeŋ kedem yokeneŋ hatibek. ");
INSERT INTO nop_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Adi me yalaŋ yeniŋa yenintifo mu tilak, eŋ me noliŋiyedok nemek kadakaniŋ mu tiyemilak, tiŋa undugoŋ mede yalaŋ yotuwatuwale mu tiyaulak. ");
INSERT INTO nop_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Adi me Bepaŋdi sigilulum tiyemulak u yabuhaŋinda hinek tilak, iŋgoŋ me Yahwe medeŋiŋ tagimneiŋ adi yadi wohiye yenimbelolak. Tiŋa adi nemek malabumuŋ niŋdi ulatifolak iŋgoŋ wendok nadibedi mu tiŋa mede yofafaŋe tuguk undugoŋ hinek tagimneeŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Adi noliŋiye nadiyembune muneeŋ hogok tobogoŋ beiŋ. Ala nai muneeŋ toboniŋ dibek beiŋ undugoŋ tubu-udanemiiŋ kaŋ adi tomboyoula nimaaŋ mimiŋdok mu yenilak. Be me yomhinit mokit mede foloŋ yapmedok muneeŋ foloŋ tuwot mu nihohokeneiŋ. Me nediyeŋ titiŋ undihi tiiŋ heki adi tuwot mu gweheyeneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Bepaŋ, nu du’walaŋkade hebihale bulat doktiŋa nabudokoweŋ. ");
INSERT INTO nop_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Nu Yahwe indiŋ nilat, “Du Wapumne. Nemenemek kedehi hogohogok hatnamiiŋ yoŋ adi du’walaŋ kohoge foloŋ hogok budapmalak.” ");
INSERT INTO nop_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Bepaŋ’walaŋ metamŋiye adi momohi hogok, wendoktiŋa nu adigut hatidok nadifo tilat. ");
INSERT INTO nop_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Metam gililikeeŋ bepaŋ yalayalaŋ heki’walaŋkade udapmaiŋ adi yadi malabumuŋ fee mintayembaak. Nu adi adut tomboyoula dumuŋ heheŋ mu tibaat, tiŋa undugoŋ adi’walaŋ bepaŋ yalayalaŋhiye u tuwot mu yeniutumbawaat. ");
INSERT INTO nop_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Nu nemenemek noli nimaaŋgoŋ nemu nadiyemilat, Yahwe du hogok hinek gabukahilelat. Tiŋa nemenemekdok baniŋ tilat kaŋ tuwot hinek namulaŋ. Wendoktiŋa hatihatine adi du kohoge foloŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Biyagoŋ hinek, nu nemenemek hogohogok momohi i moŋgotat u du’walaŋkade bulak. Eŋ yabene momooŋ hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Yahwe kubugoŋdi naninehitubu-didime tilak. Kaŋ timiŋ welene maaneŋ nadinadidi mintaaŋ titiŋ didimeniŋ titiŋdok nanindidimelak. Unduŋ doktiŋa Wapum wou nintiloit. ");
INSERT INTO nop_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Yahwe adi yamaiŋgoŋ hatilak u helemahelemaŋ hati nadilat. Adi yamaiŋgoŋ hatiŋila saŋiniŋ namulak. Unduŋ doktiŋa nemek niŋdi tuwot mu nehitubu-muntawek. ");
INSERT INTO nop_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Welene gineŋ adi momooŋ hinek nadilat, kaŋ munabulinedi adi nadifo tilak. Wendoktiŋa nu nemek niŋdok munta mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Du welegedi nabukahile hinek tilaŋ, unduŋ doktiŋa du binabune meyotneŋ uŋoŋ tuwot mu halaat. Be du da’walaŋ mehinekge koŋ gineŋ tuwot mu bikabune hali bitakawaak. ");
INSERT INTO nop_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Du dagoŋ hatihati diniŋ talik nanindidimelaŋ. Tiŋa du hatilaŋneŋ adi nadifodi tokiŋa hatak. Tiŋa undugoŋ nehitubu-loda tilaŋ doktiŋa welene gineŋ adi nadifodi helemahelemaŋ tokooŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Yahwe kutibulabulayene nadiweŋ. Nu didimeŋgoŋ hatilatdi nadibedine du’walaŋkade tiŋa bulat. Nu yonadi yalayalaŋ mu tilat, biyagoŋ hinek tilat doktiŋa nadinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Du titiŋ didimeniŋ u agaŋ nadilaŋ doktiŋa me toboniŋ’walaŋ mede ulatifowit. ");
INSERT INTO nop_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","4","Du welene agaŋ kaŋ nadidapmalaŋ. Du agaŋ timiŋ buŋa welene diniŋ mebi kanadidapmaŋ tiŋaŋ, nai uŋaniŋ agaŋ kaŋaŋ, nadinadi hogoli nemu hatnamulak. Nu me nolidi mede kadakahi yoiŋ unduŋ mu yolat. Nu adi medege hogok honefafaŋeeŋ mik-kwadi u sigilulum tiyemilat. ");
INSERT INTO nop_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Tiŋa helemahelemaŋ adi du’walaŋ talik hogok didimeniŋgoŋ kelelat, eŋ kayonedi talik bikabuŋa fai-kabe nemu folak. ");
INSERT INTO nop_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Bepaŋ, du yonadine nadiŋa tubu-udanelaŋ. Unduŋ doktiŋa du hogok ganinadilat. Ale du magike kametnadi tiŋa yonadine nadinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Unduŋ tiŋa welegedi nibukahile hinek tilaŋ u miŋgilaŋgoŋ tubumintanimbeŋ. Tubulodanik Momooŋ, indi memikniye yabu-hebi tiŋa buŋa gehitubu-dula tiŋa hakam. ");
INSERT INTO nop_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ale da dauge mindipmuŋ kadokolaŋ undugoŋ hinek nabudokoweŋ. Unduŋ tiŋa pupup hekidi wapmihiye papalihikdi yehikufulaiŋ unduŋ nehikufulahebeŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Memik heki agaŋ nulukumuŋdok nadiŋa nehikelemadi tiiŋ. Unduŋ doktiŋa undugoŋ tinambune me hogohidi mu nehitubu-kadakaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Adi me nolidok bulaniŋgoŋ-kabe nemu nadiyemiiŋ. Adi yadi nehitok hogok nadiŋa nehi wohiye yotilo hogok gibitaŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Adi kayoŋ talikne keletabubuyeŋ agaŋ nehikelemadiiŋ. Nai niŋ mintaune nohoneeŋ nulukumuŋdok woom tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Adi yadi laion hekidi kale yohonedok woom tiŋa hakiiŋ wondok tuwot hinek hadiweiŋ. Tiŋa undugoŋ laion pamaladi hebihali hadiweiŋ wondok tuwot woomhakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yahwe, du buŋa memikneye widihiŋa yehimoŋgofoweŋ. Eŋ miknoŋge tiŋa widihiŋa me kadakaniŋ titiŋ heki’walaŋ kohohik gineniŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Biyagoŋ, Yahwe, du saŋiniŋgedi nehitubu-lodaweŋ, kaŋ mehinekdi tuwot mu nehitubu-liweneŋ. Me nemenemek kwetfoloŋ iŋoŋ dapmaneeŋdok nadinadi hatiiŋ’walaŋ kohohik gineniŋ kotigoŋ nanagileŋ. Du kadakaniŋhikdok kibikoŋ tubu-udaneyemdok agaŋ tiulidokolaŋ. Ale agaŋ da dediŋ tiyemdok nadilaŋ unduŋ tiyembeŋ. Dediŋ tiyembeŋ undugoŋ tomboyoula wapmihiye tiŋa yalakihiye tiyembaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Iŋgoŋ nu adi me didimeeŋ doktiŋa kougoŋ adi gabu hinek tibaat. Nu damo deila sukuleeŋ pilali nadiwit, du nukut hatilaŋ unduŋ gabuŋa nadifo hinek tibit. ");
INSERT INTO nop_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Yahwe, du kubugoŋdi saŋiniŋne, wendoktiŋa welenedi gabukahile hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yahwe adi kadokone, tiŋa adigoŋ gimbahaŋne fafaŋeniŋ. Wapumdi momooŋ hinek nabudokolak, tiŋa adigoŋ hebi-itne kwet tilak kaŋ kedem hatilat. Wapum adi kweletalak wondok tuwolit tiŋa yahehewe tinamulak. Adi kotigoŋ nanagila nabudokodok saŋiniŋ halimilak. ");
INSERT INTO nop_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Nu Yahwe ninadiwene adi nehitubu-lodaune memikneyedi tuwot mu nehitubu-kadakaneŋ. Wendoktiŋa adi wou nintiloit. ");
INSERT INTO nop_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Kumuŋnedi tawa niŋdi nehi-ibikilitiiŋ wendok tuwot nehitubu-dulalak. Kaŋ memikneyedi mik tinamiiŋ adi imeŋgwaŋdi buŋa nehikufulalak undiniŋ nabugoŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Muniniŋ agaŋ kumumbit, kaŋ tawa niŋdi nehi-ibikilitiiŋ wendok tuwot tibek. Kaŋ bom adi nehikumuyedok woomhat tilak. ");
INSERT INTO nop_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Kaŋ nu welemulap nadiŋa Yahwe kutnimbulabulaye tilat. Nu Wapumne ninadiwene adi kedem nehitubu-lodawek. Adi yadi yolineŋ haliŋa medene diniŋ woliniŋ hogok nadiwek. Kaŋ yonadinedi magi gineŋ mintaune nadiwek. ");
INSERT INTO nop_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Wendoktiŋa Wapum adi kwihita tilak. Tiŋa yobune kwet kenim tilak, eŋ kweboboe hapmeneŋ kwet daŋiniŋ hakiiŋ tibitim kisaŋ hinek tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Timei ginaneŋ mupmuk labulak. Kaŋ kudumebem maŋiŋ gineŋ labulak wendi nemek fee yehidalak. ");
INSERT INTO nop_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Adi mulukwaŋ liliwenekula foune mulukwaŋ gouyeniŋdi kayoŋ hapmeneŋ kamehep tilak. ");
INSERT INTO nop_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Adi aŋelo foloŋ ilune woleeŋ bulak. U adi sububa papali bagi heki’walaŋ undiniŋ, ala Bepaŋ foloniŋ uŋgoŋ ilune nagila pilap hinek woleeŋ bulak. ");
INSERT INTO nop_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Adi ne uŋgoŋ yobune mambipdi tumulune hatak. Tiŋa undugoŋ gwi mulukwaŋ mambipnit wendi kelemadidapmaune hatak. ");
INSERT INTO nop_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Kaŋ filimpit tiŋa sifo muŋkulap toŋa kwet tubu-hautalak. Eŋ kudup gut gwi munilit munilit wondi mulukwaŋ gouyeniŋ u youbulagineeŋ maaŋ foyamuk. ");
INSERT INTO nop_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yahwe adi kunum foloŋ hali mulukwaŋdi tawaaŋ muŋkulap tolak unduŋ kutifiyelak. Kaŋ metamdi Bepaŋ loloŋnit’walaŋ kutifiyeŋiŋ diniŋ maŋiŋ woliniŋ nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Tiŋa memik heki filimpitdi tebe wele fiyagila yalambune momopupuheneiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Yahwe, du me kadakahi yenintolaŋ, woŋ adi sububa fafaŋeniŋ hinek niŋdi buŋa yehifedi-liliwenekutak wondok tuwolit hinek. Kaŋ imeŋgwaŋ kainiŋ hinek kwet hatak u miŋgilaŋgoŋ mintalak, eŋ kwet diniŋ daŋiniŋdi maaŋ undugoŋ mintadakale hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Wapum adi kunum foloŋ hali kohoŋ kihiwalune foune nohonelak. Nu adi me niŋ ime fuliŋ gineŋ fooŋ kumuŋdok tilak undiniŋ. Iŋgoŋ Bepaŋdi kotigoŋ nanagitak. ");
INSERT INTO nop_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Tiŋa adigoŋ me nutok mu nadinamiiŋ eŋ nutok memik kisaŋ hinek tinamiiŋ heki’walaŋ kohohik gineniŋ kotigoŋ nanagitak. Meheki weŋ’walaŋ saŋiniŋhikdi nu’walaŋ saŋiniŋne kalakapme tilak. ");
INSERT INTO nop_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Koom nai hogoli niŋ mintaune mik tinamne nehikelegiŋ, iŋgoŋ oŋ, Yahwedi nabudokoguk. ");
INSERT INTO nop_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Adi unduŋ tiŋa nabudokoune memik heki yabuhebi tiŋa momo-ugut. Adi weleŋdi nabukahile hinek tilak doktiŋa kotigoŋ nanagikuk. ");
INSERT INTO nop_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Nu titiŋ didimeniŋ takalilat wendok tuwolit Yahwedi momooŋ hinek tinamulak. Tiŋa undugoŋ, nu yom nemu tugut unduŋ doktiŋa Yahwedi kahaŋ momooŋ hinek tinamulak. ");
INSERT INTO nop_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Nu Yahwe’walaŋ Yodoko Medeŋiŋ didimeŋgoŋ kelelat. Nu kudi kadakaniŋ tiŋa Bepaŋne nemu bikabugut. ");
INSERT INTO nop_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Nu helemahelemaŋ Yodoko Medeŋiŋ didimehi wondok nadiŋa medeŋiŋdok sigilulum mu timilat. ");
INSERT INTO nop_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Adi agaŋ nadilak, nu nemek nemu tibe kadakaguk. Tiŋa undugoŋ nu kadakaniŋ tibaatneŋ yoŋa fafaŋe tugut. ");
INSERT INTO nop_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Unduŋ doktiŋa Yahwedi titiŋne didimeniŋ wendoktiŋa nadiŋa momooŋ hinek nabudokolak. Maŋgande, adi agaŋ nadinamulak, nu yomnenit mokit. ");
INSERT INTO nop_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Bepaŋ, du biyagoŋ hinek medege tagimneeŋ me nediyeŋ du gehikelehinakalak u tubulodalaŋ. Tiŋa undugoŋ me nediyeŋ didimeniŋ hatiŋa yom nemu tilak, adi yadi momooŋ timilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Du metam nediyeŋ welehik momohidok adi momooŋ tiyemilaŋ. Eŋ metam nediyeŋ kadakaniŋ tiiŋ adi yadi memik tiyemilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Metam nediyeŋ nehitok nadiune fofoŋ tilak undihi adi kotigoŋ yanagitaŋ, eŋ metam nediyeŋ nehitok nadiune loloŋ tilak aditok adi toboniŋ nadiyembune fofoŋnit tilak. ");
INSERT INTO nop_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Yahwe negoŋ hautane, doktiŋa Bepaŋne negoŋ mambipne liliwenekutnamulak. ");
INSERT INTO nop_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Bepaŋ negoŋ memikneye widihi yehikele titiŋdok saŋiniŋ namulak. Tiŋa undugoŋ saŋiniŋhik tubugweheyeyemdok saŋiniŋ namulak. ");
INSERT INTO nop_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Bepaŋ’walaŋ titiŋ adi momooŋ hinek tiŋa didimeniŋ hogok. Wendoktiŋa adi nemek niŋ titiŋdok yofafaŋelak undugoŋ tubune mintalak. Metam nediyeŋ memik fiyeŋ doktiŋa momoŋ Yahwe’walaŋkade wiiŋ adi yadi momooŋ hinek yabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Yahwe kubugoŋdi Bepaŋ hinek. Adi kubugoŋdi gimbahaŋnik. ");
INSERT INTO nop_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Tiŋa adigoŋ talik yaulatneŋ saŋiniŋ namuŋa nabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Adi nehitubu-lodaaŋ kwet hamham gineŋ yaudok kayone kale moiŋdi yawiiŋ wendok tuwot tubu-kilitiune momooŋ hinek yaulat. Tiŋa kweboboe foloŋ hayauluwene momooŋ hinek nabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Adi mik titiŋdok nanindidimeeŋ tebe miŋ fafaŋeniŋ dediŋ hamaneeŋ tubu-gweheyedok u maaŋ nanimbune tilat. ");
INSERT INTO nop_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Wapum, du nabudokooŋ saŋiniŋgedi nehitubu-lodaaŋ kotigoŋ nanagikuŋ. Du kubugoŋdi nehitubu-lodaune metam namandahik foloŋ me wotnenegigitnit tugut. ");
INSERT INTO nop_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Du talikne yali yaudok tubu-hamandanamguŋ doktiŋa kayone yahihili mu bideneguk. Tiŋa undugoŋ mu maaŋ nukuk. ");
INSERT INTO nop_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Nu memikneye yehikeleeŋ yohonelat. Tiŋa pilap mu udaneeŋ bulat. Mokoŋ. Nu widihidapmaŋ hinek tiŋa udaneeŋ bulat. ");
INSERT INTO nop_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Unduŋ tiyembene adi kotigoŋ tuwot mu pilakiiŋ, nu widihiliwewene adi wabiŋa kayone foloŋ baigoŋ deihakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Memikneye gut mik titiŋdok dagoŋ saŋiniŋ namulaŋ. Tiŋa dagoŋ nehitubu-lodaune adi mulelem tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Da’walaŋ saŋiniŋge doktiŋa memikneye sigilulum tinamuŋa momoiŋ. Nu memik tinamiiŋ u widihikumuŋ tilat. ");
INSERT INTO nop_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Nebek neeŋ yehitubu-lodawek yoŋa kutiiŋ, iŋgoŋ nebek niŋdi nemu yehitubu-lodaiŋ. Kaŋ Yahwe kutiniiŋ, iŋgoŋ adi maaŋ undugoŋ adi’walaŋ kutikutihik mu nadiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Nu yehitubu-kadakawene sububadi kwam yehifedikutak dabugoŋ tiiŋ. Tiŋa undugoŋ memik heki talipmeŋ dagik yalilat wendok tuwot yehiyali-moŋgofolat. ");
INSERT INTO nop_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Du nehitubu-lodaune me fokohinitdi mu nehitubu-kadakagiŋ. Dagoŋ metam mu nadigamiiŋ heki’walaŋ me mapme napmeguŋ. Kaŋ metam mu nadiyemilat hekidi buŋa kwanai tinamgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Me kweetniŋhi buŋa mulelem tinamiiŋ, tiŋa medene nadiŋa pilap hinek tagimneiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Adi saŋiniŋhik lohiŋa hehele kisaŋ tiiŋ, unduŋ tiŋa moŋ kaŋ hebi-it kwethik gimbahaŋ fafaŋeniŋnit u bikabuŋa buŋa nu hebetne foloŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yahwe adi hatilak, adigoŋ helemahelemaŋ saŋiniŋ namulak. Wendoktiŋa wou nintilolat. Bepaŋ adi Tubulodane wendoktiŋa wougigitŋiŋ niŋa tilolat. ");
INSERT INTO nop_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Negoŋ nehitubu-lodaaŋ kibibo memik tinamiiŋ yehibefolak. Adi kubugoŋdi metam Bepaŋ mu nadisukilitimiiŋ heki hebetneneŋ yapmelak. ");
INSERT INTO nop_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Wapum, dagoŋ nehitubu-lodaune memik hekidi mu nehitubu-kadakaiŋ. Biyagoŋ hinek, Wapum, du dagoŋ nehitubu-lodaune mik gineŋ fafaŋeŋ memikneye yehimoŋgofolat. Du nehitubu-lodaune mikme fafaŋehidi mu nulukumiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","O Yahwe, wendoktiŋa nu mebop noli mu nadisukilitigamiiŋ heki lekiŋgoŋhik gineŋ ganintiloit, eŋ kap nadifonit hinek toŋa wohoge yotiloit. ");
INSERT INTO nop_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Wapumdi Dewit, nu mapme nehitubu-dakaleguk. Tiŋa helemahelemaŋ nehitubu-lodaune mik gineŋ fafaŋe tilat. Adi nu nabukahile hinek tilak, undugoŋ yalakineye kougoŋ mintaneeŋ maaŋ undugoŋ yabukahile hinek tibaak. ");
INSERT INTO nop_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Wapum adi loloŋnit tiŋa saŋiniŋnit u kunumdi yobihitak kaŋ, kaŋ nadiyaam. Eŋ kunum foloŋ nemek boiguk hogohogok wendi kwanai momooŋ tuguk u yobihitak. ");
INSERT INTO nop_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Helemahelemaŋ hadapmodi maaŋ netok yobihitak. Kaŋ timiŋdi maaŋ ne’niŋ mebi yobihitak. ");
INSERT INTO nop_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Helebufa adi mahiknit mokit doktiŋa mede tuwot mu yodemek. Indi adi’walaŋ mahik mede nemu nadiyam. ");
INSERT INTO nop_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Iŋgoŋ helebufadi metam kwetkwet yenindidimeyamuk. Kaŋ medehikdi kwetkwet udapmalak. Kunum foloŋ Bepaŋdi meledok yoholaŋ niŋ mamiŋguk. ");
INSERT INTO nop_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Meledi labu diwelak adi me niŋdi tam kobugoŋ tiŋa yotmaaŋ bikabuŋa welenadifonit fooŋ bulak undiniŋ. Me kiyane tiiŋdi kiyane titiŋdok tiulidoko tiiŋ wondok tuwolit meledi nadifo tiŋa talik halimilak u kelelak. ");
INSERT INTO nop_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Mele adi kunum dikineŋ tububihila labuŋa wooŋ dikineŋ folak. Nemek niŋdi adi’walaŋ kudutŋiŋ gineŋ tuwot mu hebihalek. ");
INSERT INTO nop_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yahwe’walaŋ Yodoko Medeŋiŋ adi didimeniŋ doktiŋa hatihati kobuli nimilak. Yahwe’walaŋ mede woŋ adi nemek indi nadisukiliti titiŋdok uŋakoŋ. Wendigoŋ metam nadinadidok baniŋ tiiŋ nadinadi yemilak. ");
INSERT INTO nop_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yahwe adi mede momohi hinek ninintubu-didimelak. Kaŋ mede wendigoŋ welenadifo tubumintanimilak. Yahwe’walaŋ Yodoko Mede adi waliniŋ doktiŋa wendigoŋ nadinadi momooŋ nimilak. ");
INSERT INTO nop_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Me Yahwe gikiŋgoŋ timilak adi yadi titiŋ momooŋ tilak. Kaŋ titiŋ momooŋ woŋ adi dapmandapmaŋnit mokit. Yahwe adi titiŋ dediŋ titiŋdok hogohogok u ninindapmalak, mede woŋ adi biyagoŋ tiŋa didimeniŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Bepaŋ’walaŋ mededi gol kalakapme tilak. Gol momooŋ hinehinek u kalakapmeŋ tilak doktiŋa indi mede u nadigalika hinek tinim. Eŋ Wapum’walaŋ Yodoko Mededi simiŋkupuk diniŋ kobaŋiŋ u kalakapme tilak. ");
INSERT INTO nop_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Yodoko Medegedi kwanai-mege nutok nadinadi namuŋa nanindidime tilak. Nu adi Yodoko Medege tagimneeŋ takalilat, wendoktiŋa kibikoŋ ipilatne gineŋ nemenemek momooŋ tinamulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Nediyeŋ ne’walaŋ kadakaniŋŋiŋ u kedem nadidapmawek? U tuwot mokoŋ. Unduŋ doktiŋa, Baŋ Bepaŋ, kadakaniŋ tugut hogohogok, nadilat be mu nadilat, u tumolokutnambeŋ, tiŋa nehiyoutelune namandake foloŋ me didimeniŋ hatibit. ");
INSERT INTO nop_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Nu kwanai-mege, doktiŋa momooŋgoŋ nabudokoune foko mu tibit. Du binabune foko diniŋ nadinadidi mu nabudokowek. Unduŋ tubune nu didimeniŋgoŋ hatiŋa kadakaniŋ nadikabeleeŋ nemu tibaat. ");
INSERT INTO nop_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Yahwe, nu mede yoyone be titiŋnedi namandake foloŋ didimeŋgoŋ mintadok nadilat. Yahwe, du kubugoŋdi Hebiit Kwetne tiŋa Tubulodane. ");
INSERT INTO nop_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Wapum adi malabumuŋ minta-gamulune kedem gehitubu-lodaluwaak. Jekop’walaŋ Bepaŋdi kedem gabudokoluwaak. ");
INSERT INTO nop_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Adi yoli uŋgoniŋ gineŋ Saiyon uŋoŋ hali kedem gehitubu-kilitiŋa gehitubu-lodawaak. ");
INSERT INTO nop_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Eŋ siloŋ timiluwaaŋ hogohogok u kedem yabukahileluwaak, tiŋa dumuŋ hemundumunduŋe timiluwaaŋ u adi nadiune utumba hinek tuluwaak. ");
INSERT INTO nop_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Bepaŋdi du maŋgoŋdok nadilaŋ hogohogok u kedem gambaak. Tiŋa maŋgoŋ kwanai hogohogok titiŋdok nadihebet tuguŋ u kedem gehitubu-lodaune tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Du mik gineŋ fafaŋewaaŋ kaŋ indi wendoktiŋa nadifo tiŋa kap walem toŋa Bepaŋnik wou nintiloneem. Ale Yahwedi yonadige hogohogok kedem nadigambaak. ");
INSERT INTO nop_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Kobuk agaŋ nadilat. Yahwe negoŋ me mapme napmeguk, tiŋa nehitubu-lodaune mik gineŋ fafaŋelat. Adi yolikweli momooŋ kunum foloŋ uŋoŋ hali yonadine nadilak. Tiŋa undugoŋ adi ne’walaŋ saŋiniŋŋiŋdi nehitubu-lodaune mik gineŋ fafaŋe tilat. ");
INSERT INTO nop_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Me nolidi wosi heki foloŋ be mik diniŋ kalis heki foloŋ saŋiniŋhik uŋoŋ beiŋ. Iŋgoŋ indi adi Yahwe Bepaŋnik’walaŋ saŋiniŋŋiŋ foloŋ hogok wooŋ ulodikilitiyam. ");
INSERT INTO nop_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Metam hogohogok adi gweheyeeŋ kadakadapmaneeŋ. Iŋgoŋ indi adi toboniŋ fafaŋe tiŋa pilali yatneem. ");
INSERT INTO nop_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yahwe, du nihitubu-lodaune indi fafaŋe tineem. Wapum, du Mapmenik. Ale nihitubu-lodadok kutiganiyane nadiŋila nihitubu-lodaluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Yahwe, me mapme adi du saŋiniŋ milaŋ doktiŋa nadifo tilak. Adi du tubulodaune mik gineŋ fafaŋelak wendoktiŋa nadifo gibitaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Adi weleŋdi maŋgoŋdok nadiguk u agaŋ miŋguŋ. Du unduŋ tiŋa yeguŋ e’, yonadiŋiŋ nadilakata tiŋa mu wabiguŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Tiŋa du adi’walaŋkade buŋa kahaŋ momooŋ hinek timiŋguŋ. Unduŋ timiŋa mapme kuluŋ golnit u mokomiŋguŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Tiŋa hatihati mimiŋdok ganinadiune miŋguŋ. Kaŋ du hatihatiŋiŋ tomboyoulimimbune nai wahaniŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Du tubulodaguŋ kaŋ wougigitnit tilak. Eŋ wou loloŋnit tiŋa saŋiniŋ u dagoŋ miŋguŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Eŋ kahaŋgedi adigut haliwooŋ halaak. Tiŋa du adigut hatiŋa weleŋ gineŋ nadifo tubumintaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Yahwe, Wapum Loloŋnit hinek, me mapmedi du nadisukilitigamulak. Du adi welegedi hinek me mapme kahilelaŋ, wendoktiŋa adi fafaŋe tiŋa yalaak. ");
INSERT INTO nop_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Du adi memikgeye hogohogok wanaŋ yohonefafaŋewaaŋ. Unduŋ tiŋa me nediyeŋ adi gabukwihita tiiŋ u yanagila yot fafaŋeniŋneŋ yapmewaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Du dagoŋ miŋgilaŋgoŋ mintadakaleeŋ kudup fafaŋeniŋdi yehidaliwelak unduŋ yehidaliwewaaŋ. Biyagoŋ hinek, Yahwe’walaŋ kwihitaŋiŋdi yehitubukadakaaŋ kudup dabugoŋ yehidadapmawaak. ");
INSERT INTO nop_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Du wapmihihiye hogohogok wanakaŋ widihikumundapmaŋ tibaaŋ. Kaŋ wapmihihiye-kabe kwetfoloŋ iŋoŋ hogok nemu hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Adi kadakaniŋ tigamdok yonadi tiŋa mede yohebet tineeŋ iŋgoŋ yohebethikdi folooŋ mokit tibaak. ");
INSERT INTO nop_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Du tebe kandamdi didimeniŋgoŋ yemhihiŋe tubune kasukuleeŋ udaneeŋ momoneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yahwe, du saŋiniŋge uŋgoniŋ hinek wendok nadiŋa ganintiloyam! Tiŋa undugoŋ du titiŋgedi uŋgoniŋ hinek doktiŋa kap toŋa ganintiloyam. ");
INSERT INTO nop_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Bepaŋne, Bepaŋne, du maŋgoŋde binabulaŋ? Be maŋgandok tiŋa mu nehitubu-lodalaŋ? Be maŋgoŋdok tiŋa kutibulabulayene mu nadilaŋ? ");
INSERT INTO nop_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Bepaŋ, nu hadapmo kutiganilat, iŋgoŋ du mu nadinamulaŋ. Tiŋa undugoŋ timiŋ adi hakulenit mokit hakutiganilat. ");
INSERT INTO nop_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Iŋgoŋ du adi titiŋ momooŋ eŋ didimeniŋ diniŋ Bepaŋ. Du mapme uŋgoniŋ ilune Isilaehidi ganintiloiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Koom mamani-papaniye adi du nadisukilitigamgiŋ. Adi nadisukilitigamgiŋ doktiŋa yehitubu-lodaune memik heki yehitifogiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Adi nadisukilitigamuŋa welemulap mu tigiŋ. Eŋ du ganinadigiŋ kaŋ memik heki’walaŋ kohohik gineniŋ yanagikuŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Iŋgoŋ nu adi meeniŋ dabugoŋ mooŋ, nu adi miŋgembem nabugoŋ. Metamdi nabuhaŋindaaŋ nanintifooŋ sigilulum tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Metam hogohogok nu nabuŋa adi nanimpekit tiiŋ, eŋ mabelap tiŋa mebiguguŋ tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Adi indiŋ yoiŋ, “Du Yahwe nadisukilitimilaŋ. Iŋgoŋ dediŋdok tiŋa adi kotigoŋ mu gehitubu-lodaaŋ ganagitak?” ");
INSERT INTO nop_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Bepaŋ, dagoŋ maŋ’walaŋ weleŋ gineniŋ momooŋ hinek nabudokoune mintagut. Tiŋa eyaŋ-kabe gineŋ maaŋ nabudokoguŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Nu tububihila maŋdi nanagikuk, nai uŋaniŋ du foloŋ ulodiŋa hatigut. Du adi maŋdi nanagikuk nai uŋaniŋ tububihila Bepaŋne hatiguŋdi hatilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","I agaŋ malabumuŋ tububihila mintanamulak doktiŋa du mu binabeŋ. Nu nehitubu-lodadok nebek noli nemoŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Memikneye adi makau maahi nabugoŋ nehikelemadiiŋ. Adi yadi makau maahi fafaŋehi mikhinit Basan kwetneŋhi nabugoŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Adi yadi laiondi maŋiŋ dilitomuŋa kale nanaŋdok mahaŋ tolak, wondok tuwot nehitubu-kadaka tinene woomhat tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Saŋiniŋne adi ime kwetfoloŋ kweheune fooŋ liwelak, wondok tuwot dambek udapmalak. Kaŋ kitiline tomboyout tiŋa haliwiiŋ hogohogok u diliteledapmaŋ tiiŋ. Kaŋ welene maaneŋ nemenemek dambek liwedapmaune saŋiniŋ eŋ nadinadi lohilat. ");
INSERT INTO nop_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Tiŋa mane silidaune mebelemne looŋ mane hapmeneŋ galiŋa hatak. Kaŋ du binabune kumumbe tilat. ");
INSERT INTO nop_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Me kadakahi adi kamo hekidi kale moiŋ yehikelemadiiŋ nabugoŋ nehikelemadiiŋ. Tiŋa kayone kohone youtom tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Kitiline hogohogok miŋgilaŋgoŋ mintadapmalak. Kaŋ meheki woŋ adi malabumuŋ u minta-nambune nabuŋa nadifo tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Adi tinahukutne daneeŋ moŋgokiiŋ, tiŋa undugoŋ nediyeŋ fafaŋeeŋ dahidahine wahiniŋ tibek yoŋa kat kukiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Yahwe, du binabuŋa wooŋ kweetniŋ mu haleŋ. Tubulodane Momooŋ, kamiŋ maaŋ pilap buŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Du kotigoŋ nanagilune adi tuwot mu nulukumuneŋ. Du nehitubu-lodaune kamo nabugoŋ heki wendi mu nulukumuneŋ, kaŋ kaipmuŋ hatiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Laiondi kale moihi yehisiŋa nalak wondok tuwolit nehinane tiiŋ. Tiŋa undugoŋ adi yadi makau moihi nabugoŋ unduŋ haliŋa keleuhikdi nedene tiiŋ. Unduŋ doktiŋa du adi kohohik gineniŋ kotigoŋ nehikibidaleŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Du unduŋ tibeŋ kaŋ nu metamneye du kwanai saŋiniŋnit tuguŋ u yenihautait. Adi ganiutumbadok bopneune nu adi’walaŋ lekiŋgoŋhik gineŋ wooŋ wohoge yotiloluwaat. ");
INSERT INTO nop_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Nu indiŋ yobit. “Bepaŋ’walaŋ metamŋiye, hidi wou nintiloneŋ. Jekop’walaŋ me yalakiŋiye, hidi Yahwe wou nintiloneŋ. Biyagoŋ, Isilaehi, hidi gikiŋgoŋ timiŋa niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Adi me fiyewakahi sigilulum mu tiyemilak. Be malabumuŋ tiŋa folofigitahikdok nadiune nemek haŋindaaŋ mu tilak. Adi biyabuŋa kweetniŋ mu hatilak, wendoktiŋa ninadiiŋ kaŋ yonadihik u nadiyemulak.” ");
INSERT INTO nop_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Youtumbadok bop wapum mintaluwaakneŋ du maŋgoŋ tuguŋ wendok yohautaaŋ wohoge ganintiloluwaat. Tiŋa siloŋ koom titiŋdok yofafaŋegut u metam gikiŋgoŋ tiiŋ heki namandahik foloŋ tibit. ");
INSERT INTO nop_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Metam fiyewakahi adi yadi nanaŋe natoki tineŋ. Kaŋ Yahwe’walaŋ metamŋiye adi wou nintiloneŋ. Kaŋ Bepaŋdi kahaŋ tiyembune nadifo foloŋ hatiŋa wooŋ hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","28","Kwetfoloŋ metam hogohogok Bepaŋ doktiŋa adi’walaŋkade buneeŋ. Yahwedi mapme ilaŋa metam hogohogok yabudokolak, unduŋ doktiŋa adi hogok niutumbaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Kwetkwet me fokohinit adi hinamuni tiŋa mulelem timiŋa niutumbaneeŋ. Kwetfoloŋ metam hogohogok kumuŋ tigiŋ be kaipmuŋ hatiŋa kougoŋ kumuneeŋ, adi wanakaŋ mulelem tiŋa Bepaŋ niutumbaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Metam kougoŋ mintaneeŋ heki adi Bepaŋ’walaŋ kwanai tineeŋ. Adi metam kougoŋ mintaneeŋ Bepaŋ’walaŋ kahat tiyembune nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Metam u mu mintagiŋ, ala kougoŋ mintaune indiŋ yenineeŋ, “Bepaŋdi metamŋiye kotigoŋ yanagikuk.” ");
INSERT INTO nop_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Yahwedi dompa kadoko me nabugoŋ nabudokolak, unduŋ doktiŋa nemek niŋdok baniŋ tuwot mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Negoŋ nadinambune kilihikit momooŋ foloŋ fooŋ dahakulemalat. Kaŋ nanagilune ime kuyahineŋ wooŋ ime naaŋ hakule tilat. ");
INSERT INTO nop_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Adi wougigitŋiŋ doktiŋa saŋiniŋ gitipmuŋ namulak. Tiŋa nanagilune talik momooŋ takalilat. ");
INSERT INTO nop_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Bepaŋ, nu kwet hogolineŋ be mambip gineŋ yauŋa du nukut hatilaŋ u agaŋ nadilat doktiŋa munta mutibit. Be undugoŋ tuwot mu kadakawit. Maŋgande, nu gabene du dompa kadoko hekidi kuyaŋ mali yawiiŋ u hone yataŋ. Wendoktiŋa welene kulema tilak. ");
INSERT INTO nop_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Du nanaŋe momooŋ hinek u memikneye heki’walaŋ namandahik foloŋ miŋgilaŋgoŋ tiulidokonambune nabiiŋ. Tiŋa nalum me loloŋnit wendok tuwot katinanimbune buŋa dakat ilene momooŋ hinek nabudokolaŋ. ");
INSERT INTO nop_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Yahwe, nu kaipmuŋ hatiluwene du helemahelemaŋ welegedi hinek nabukahile hinek tiŋa momooŋ hinek nabudokoluwaaŋ. Unduŋ tubune nu helemahelemaŋ du yokeneŋ uŋgoŋ hatiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Kwet tiŋa adi foloŋ nemenemek hatak hogohogok u Yahwe’walaŋ hogok. Eŋ yokwet hali ulak tiŋa metam hogohogok u maaŋ adi’walaŋ hogok. ");
INSERT INTO nop_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Adi ime kaiŋ halune kwet wahiŋ tutumbaguk. Tiŋa kwet daŋiniŋ hakilitiŋiŋ ime lekiŋgoŋ kameguk. ");
INSERT INTO nop_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Unduŋ doktiŋa me nediyeŋdi Yahwe’walaŋ kweboboe foloŋ kedem lowek? Be me nediyeŋdi yoli uŋgoniŋ gineŋ kedem fowek? ");
INSERT INTO nop_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Me nediyeŋ titiŋŋiŋ be nadinadiŋiŋdi momohi eŋ me nediyeŋ bepaŋ yalayalaŋ mu yeniutumbalak, tiŋa undugoŋ me nediyeŋ yalaŋ medeŋiŋdi fafaŋedok kohodidim mu tilak. Me undiniŋ adi hogokdi kedem Bepaŋ kweboboeŋiŋ foloŋ lowaak eŋ yoli uŋgoniŋ gineŋ fowaak. ");
INSERT INTO nop_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Yahwedi me undihidok adi kahaŋ tiyembaak. Tiŋa kotigoŋ yanagila me didimehi yenimbaak. ");
INSERT INTO nop_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Metam undihidi Bepaŋ’walaŋkade wiiŋ, adi Jekop’walaŋ Bepaŋ tubudulaŋila yamaiŋgoŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Yeme heki, hidi dilitombut. Yeme komihi hinek, hidi dilitomhamanda tineŋ, kaŋ Mapme Loloŋnit adi kedem labek. ");
INSERT INTO nop_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Mapme Loloŋnit u nedigoŋ? Woŋ adi Yahwe kuyoŋ. Adi yadi Saŋiniŋ Molom, doktiŋa mik gineŋ fafaŋe tilak. ");
INSERT INTO nop_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Yeme heki, hidi dilitombut. Yeme komihi hinek, hidi dilitomhamanda tineŋ, kaŋ Mapme Loloŋnit adi kedem labek. ");
INSERT INTO nop_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Mapme hauta holiholiŋenit u nedigoŋ? Woŋ adi Yahwe, kunumnehi mikme heki’walaŋ wapum, adi kuyoŋ. Adi kubugoŋdi Mapme hauta holiholiŋinit. ");
INSERT INTO nop_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Yahwe, nu yonadine kamewene du’walaŋkade ulak. ");
INSERT INTO nop_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Du kubugoŋdi Bepaŋne. Nu du kubugoŋ hogok nadisukilitigamulat, unduŋ doktiŋa nehitubu-lodaweŋ. Tiyaugene nu hogok nadisukilitifit tiŋa meka tubumintawaatneŋ, doktiŋa du memikneye mu biyabune nehitiŋafooŋ nadifoneŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Du me nadisukiliti tigamiiŋ heki biyabune hogok nadisukilitifit mu tiiŋ. Mokoŋ. Eŋ me foko tiŋa bolik tinamiiŋ adi yadi kedem nehi titiŋ hogohi tiiŋ u yabunadiŋa meka tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Yahwe, du titiŋge momohi u nanindidimeweŋ, kaŋ nu titiŋge u didimeŋgoŋ takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Tiŋa titiŋ didimeniŋ dediŋ takaliŋa hatidok nadilaŋ u nanindidimeweŋ. O Bepaŋne, du kubugoŋdi kotigoŋ nanagitaŋ, doktiŋa helemahelemaŋ du nehitubu-lodadok yoŋa woomhatilat. ");
INSERT INTO nop_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Yahwe, du siloŋ tobogoŋ tuguŋdi tilaŋ, eŋ welegedi hinek metamgeye yabukahileguŋdi yabukahilelaŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Unduŋ doktiŋa Bepaŋ, nu mekuya hatiŋa kadakaniŋ tugut be nemek mu nadidakaleeŋ yogut be tibe kadakaguk, yomne hogohogok u tumolokutnambeŋ. Yahwe, du momooŋ hinek, doktiŋa welegedi nabukahile hinek tiŋa welesiloŋ tobogoŋ tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yahwe adi didimeeŋ tiŋa momooŋ. Unduŋ doktiŋa metam kadakaniŋ tiiŋ heki u yanagila ne’walaŋ talik didimeniŋ yenindidimelak. ");
INSERT INTO nop_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Kaŋ metam nediyeŋ nehitok nadiune foune adi hebeŋ gineŋ hatiŋa titiŋ didimeniŋ takaliiŋ, adi maaŋ undugoŋ talikŋiŋ didimeniŋ foloŋ yanagitak. ");
INSERT INTO nop_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Yahwe adi undumbo undumbo mu nadilak, adi yadi metam nediyeŋ yofolok medeŋiŋ u nadiŋa kamehatiiŋ eŋ Yodoko Medeŋiŋ takaliŋa hatiiŋ adi yadi weleŋdi hinek yabukahilelak. ");
INSERT INTO nop_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Yahwe, du wohoge loloŋnit doktiŋa yofolok medege takaliŋa kadakaniŋne tumolokutnambeŋ. Du adi Bepaŋ undiniŋ doktiŋa yom noli hogohogok u maaŋ tumolokut-namdapmaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Metam nediyeŋ Yahwe gikiŋgoŋ timiŋa hatiiŋ, adi yadi Bepaŋdi talik didimeniŋ u yenindidimeune takalineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Metam undihi adi momooŋ hinek hatineeŋ, kaŋ yalakihiyedi maaŋ undugoŋ kwetfoloŋ iŋoŋ momooŋ hinek hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Metam nediyeŋ Yahwe gikiŋgoŋ timiŋa niutumbaiŋ adi hogok Yahwedi not momooŋ tiyemiŋa yofolok medeŋiŋ yenintubu-kaika tilak. ");
INSERT INTO nop_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Nu helemahelemaŋ Yahwedi nehitubu-lodawek yoŋa aditok dau diwe tilat. Kaŋ adi kubugoŋdi nemek nehitubu-kadaka tine tiiŋ gineniŋ nanagitak. ");
INSERT INTO nop_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Ale Bepaŋ, nu na hogok haliŋa saŋiniŋ lohilat, doktiŋa du kotigoŋ buŋa siloŋ tobogoŋ tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Tiŋa welemulap tilat hogohogok u liliwene-kutnambune welene kulemawek. Tiŋa undugoŋ nehitubu-lodaune malabumuŋdi mu nehitifowek. ");
INSERT INTO nop_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Nu folofigita eŋ malabumuŋ gineŋ hatat u kaŋ nadiŋa kadakaniŋne hogohogok tumolokutnambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Du memikneye yabeŋ. Adi fee mumuyeŋ hinek tiŋa nabukwihita kisaŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Unduneŋ doktiŋa kotigoŋ nanagila momooŋgoŋ nabudokoweŋ. Kaŋ memikneyedi mu nehitifooŋ nehitubu-mekaneŋ. Du kubugoŋdi nabudokolaŋ doktiŋa du’walaŋkade bulat. ");
INSERT INTO nop_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Nu du nadisukilitigamulat doktiŋa titiŋ didimeniŋ eŋ momooŋ tilat u yabunadiŋa nabudokoluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Bepaŋ, du metamgeye, Isilaehi hogohogok wanakaŋ yanagileŋ, kaŋ malabumuŋdi mu yehitifowek. ");
INSERT INTO nop_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Yahwe, nu du hogok nadisukilitigamulat tiŋa titiŋ didimeniŋ tiŋat wondoktiŋa nu mede gineŋ yale me didimeniŋ nanimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","3","Yahwe, du welegedi nabukahile hinek tilaŋ doktiŋa helemahelemaŋ nehitubu-lodaune mede biyagoŋ takalilat. Unduŋ doktiŋa du titiŋne hogohogok u kanadidapmaŋ tibeŋ. Tiŋa welene eŋ nadinadine diniŋ mebi kameka tiŋa nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Nu adi me hogohi dut mu yaulat eŋ me yalaŋ yoiŋ heki dut maaŋ undugoŋ mu yaulat. ");
INSERT INTO nop_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Nu adi me kadakaniŋ tiiŋ u yabukwihita tilat. Unduŋ tiŋa me kadakahi adi yabuŋa sigilulum tiyemiŋa yaulat. ");
INSERT INTO nop_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Nu kadakaniŋnenit mokit nabunadiweŋdok kohone youtela altage kelemadiŋa ganiutumbalat. ");
INSERT INTO nop_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Nu unduŋ tiŋa ganiutumbadok kap niŋ gibitaŋ tolat, eŋ du titiŋ momohi tuguŋ u yohautalat. ");
INSERT INTO nop_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yahwe, nu adi welenedi du yoke u kahilehinaka tilat, uŋoŋ adi saŋiniŋge uŋgoniŋdi hatak. ");
INSERT INTO nop_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Du me kadakaniŋ tiiŋ heki dut mu nehitomboyouleŋ. Tiŋa me mik-kwadi tiŋa nohiye widikumiiŋ heki gut mu nehitubu-kadakaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Me heki woŋ adi kadakaniŋ helemahelemaŋ tiiŋ. Adi me noli muneeŋ foloŋ yenihohoket tubune metam noli kadakaniŋ tiyemiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Iŋgoŋ nu adi titiŋ didimeniŋ tilat. Unduŋ doktiŋa siloŋ tobogoŋ tiŋa kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Unduŋ tinambune nemek niŋdi tuwot mu nehitubu-kadakawek, mooŋ. Fafaŋe tiŋa yatat. Yahwe, metam youtumbadok bopneune nu adi lekiŋgoŋhik gineŋ wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Yahwe adi hautane, tiŋa nehitubu-loda maaŋ adigoŋ tilak. Wendoktiŋa neditokbo yoŋa muntawit? Yahwedi hati nabudokolak, unduŋ doktiŋa nu nemek niŋdok munta tuwot mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Me kadakahi adi nehitubu-kadakadok nehikeleeŋ nehitubu-dulayaneeŋ iŋgoŋ nemek niŋ foloŋ yalitigiyam tiŋa mayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Be mikme bop wapumdi buŋa nehikelemadiyaneeŋ iŋgoŋ nu wendok munta mu tuluwaat. Memik heki mik titiŋdok bunambune nu momoŋ tuwot mu tuluwaat, Bepaŋ hogok nadisukilitimiŋa fafaŋe tiŋa yatuwaat. ");
INSERT INTO nop_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Nu nemek kubugoŋ niŋ undugoŋ hinek titiŋdok nadiŋa Yahwe ninadigut adi indiŋ! Nu kaipmuŋ hatitalowaat indigoŋ tuwot Yahwe yolineŋ hatiluwaat. Adi momooŋ hinek doktiŋa kaŋ nadiwene utumba hinek tilak. Ale ninadiwene talik momooŋ nanindidimewek. ");
INSERT INTO nop_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Nemek malabumuŋ mintanambe tubune nai uŋaniŋ nanagila yolineŋ nehikamehebiluwaak. Tiŋa taliyeme momooŋ hinek tehekwambundaluwaak. Unduŋ tubune adi’walaŋ saŋiniŋ gineŋ hatiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Tiŋa memik heki nehikelemadi taneeŋ u widihidapmaaŋ yehimoŋgofoluwaat. Unduŋ tiŋa kakaliŋa nadifooŋ yolineŋ dumuŋ hemiluwaat. Eŋ walem kap toŋa wou nintiloluwaat. ");
INSERT INTO nop_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yahwe, nu kutiganimbe nadiŋa siloŋ tobogoŋ tiŋa kutibulabulayene u tubu-udaneluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Yahwe, dagoŋ indiŋ yoguŋ, “Nolohiŋa nabuneeŋ.” Unduŋ dokti walanedi indiŋ yolak, “Biyagoŋ hinek, Wapum, du’walaŋ namandake kakaŋdok hinek lohiwit.” ");
INSERT INTO nop_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Ale du sigilulum mu tinambeŋ. Bepaŋ, dugoŋ nehitubu-lodalaŋ. Kaŋ nu adi kwanai-mege, unduŋ doktiŋa kwihita tinamuŋa nehikelekut mu tibeŋ. Du nai fee hinek nehitubu-lodalaŋ, unduŋ doktiŋa mu binabeŋ. Tiŋa undugoŋ nu binabuŋa momoŋ mu tiŋa weŋ. ");
INSERT INTO nop_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Maŋ baŋ adi sigilulum tinamdemeek, iŋgoŋ fiit Yahwedi nabudokoluwaak. ");
INSERT INTO nop_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Yahwe, nu maŋgoŋ titiŋdok nadinamulaŋ u kedem nanindidimeweŋ. Nu memikne fee hatiiŋ, unduneŋ doktiŋa talik didimeniŋ gineŋ kedem nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Du binabune memik hekidi mu nohoneneŋ. Adi yadi mede yalaŋ naniŋa nehikeleyawiiŋ. Unduŋ tiŋa nehitubu-kadakadok mede miŋgoŋ yoiŋ. ");
INSERT INTO nop_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Biyagoŋ hinek, nu indiŋ nadisukilitilat. Kougoŋ kwetfoloŋ iŋgoŋ Yahwedi metamŋiye momooŋ tiyembaak u daunedi kawaat. ");
INSERT INTO nop_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Du nadisukiliti tiŋa woom yatune Yahwedi buŋa gehitubu-lodawaak. Du welemulap mu tibeŋ, du Yahwe hogok nadisukilitimiŋa woom yaleŋ. ");
INSERT INTO nop_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Yahwe, du kubugoŋdi nehitubu-lodalaŋ, unduŋ doktiŋa kutiganilat. Ale du kutibulabulayene nadiweŋ. Magike kauleŋ nabugoŋ mu tibeŋ. Eŋ du yonadine mu nadiweŋ woŋ adi nu me kumuŋa ugiŋ meyotneŋ hakiiŋ wendok tuwolit tibit. ");
INSERT INTO nop_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Nu nehitubu-lodadok yoŋa kutiganimbene du kutibulabulayene nadiweŋ. Nu kohone du yoke uŋgoniŋneŋkade kwehene-moŋgolooŋ ganinadilat. ");
INSERT INTO nop_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Unduŋ doktiŋa me hogohi tiŋa me kadakaniŋ tiiŋ heki dut mu nehikelekulaaŋ. Tiŋa undugoŋ me mahik foloŋ mede momomomooŋ yoiŋ, iŋgoŋ welehik maaneŋ nadinadi hogohidi fotokooŋ hatak undihi dut mu nehitomboyoulaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Meheki i kadakaniŋ dediŋ tigiŋ wondok tuwolit da nadilaŋ wondok tuwot gibitaŋ tubu-udaneyembeŋ. Kadakaniŋ dibek tigiŋ undugoŋ malabumuŋ wondok tuwot yembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Adi Yahwe’walaŋ kwanaiŋiŋ wapum eŋ nemenemek hogohogok tuguk u mu nadiiŋ. Unduŋ doktiŋa yehitubu-kadakaaŋ yehitubu-fidapmaŋ tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Nu Yahwe kutnimbulabulaye tibene agaŋ nadinamuŋak doktiŋa adi wou nintilowit. ");
INSERT INTO nop_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Bepaŋ ne kubugoŋdi nabudokooŋ yahehewe tinamulak. Wendoktiŋa nu adi hogok nadisukilitimilat. Tiŋa undugoŋ, Yahwedi hogok nehitubu-lodalak wendoktiŋa nu nadifo timilat. Tiŋa welemomooŋ nadimiŋa kap toŋa wou nintilowit. ");
INSERT INTO nop_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yahwe adi metamŋiye’walaŋ saŋiniŋhik. Eŋ me mapmeŋiŋ maaŋ undugoŋ kadoko tiŋila tubulodalak. ");
INSERT INTO nop_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Bepaŋ, du metamgeye yehitubu-lodaweŋ. Tiŋa metam datok yoŋa yabukahileguŋ u kahaŋ tiyembeŋ. Unduŋ tiŋa dagoŋ kadoko mehik hatiŋa helemahelemaŋ momooŋgoŋ yabudokoluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Kunum foloŋ aŋelo heki, hidi Yahwe wou nintiloneŋ. Yahwe’walaŋ wougigitŋiŋ eŋ saŋiniŋŋiŋdok gikiŋgoŋ tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Yahwe wougigitŋiŋ nintiloneŋ, tiŋa uŋgoniŋ haliŋa adi hogok niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yahwe’walaŋ medeŋiŋ woliniŋdi imeŋgwaŋ wapum foloŋ uune nadidapmaŋ tiiŋ. Yahwe adi wougigitnit doktiŋa muŋkulap tolak wendok tuwot kutifiyelak. Kaŋ medeŋiŋdi imeŋgwaŋ wapum foloŋ uune metam feedi nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yahwedi kuti tilak adi saŋiniŋnit. Metam hogohogok adi Yahwedi kuti tilak u nadiune beweniŋgoŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yahwe’walaŋ kutikutidi bem sida heki u yehi-ulitawalak. Bem sida kakahi woŋ adi Lebanonhi. ");
INSERT INTO nop_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Tiŋa undugoŋ medeŋiŋ wendi Lebanonhi’walaŋ kweboboe u yehimahamulune makau mihiniŋ heki nabugoŋ tatakut-tatakut tiiŋ. Kaŋ kweboboe Hemon adi maaŋ undugoŋ makau maaniŋ pamala nabugoŋ tatakutak. ");
INSERT INTO nop_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yahwe’walaŋ kutikuti wendi mulukwaŋ gineŋ filimfitak. ");
INSERT INTO nop_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Eŋ kutikutiŋiŋdi Kedes kwet fiileŋ u timahamutak. ");
INSERT INTO nop_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yahwedi kutifiyeune kale moiŋ mihiniŋ biyeiŋ. Eŋ kutikutiŋiŋ wendi bem baaniŋ yehibideneune hapmuŋ bulonelak. Kaŋ Bepaŋ’walaŋ yolineŋ wanakaŋ hogohogokdi indiŋ kutiiŋ. “Yahwe adi wougigitnit.” ");
INSERT INTO nop_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yahwe adi mapme hatiŋa imeŋgwaŋ wapum u kadokolak. Adi yadi mapme dapmandapmaŋnit mokit hatilak. ");
INSERT INTO nop_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yahwe adi metamŋiyedok saŋiniŋ yemilak. Tiŋa kahaŋ tiyemilak kaŋ welekulema tubumintaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Yahwe, du kotigoŋ nanagilune memik hekidi mu nehitiŋafooŋ nadifogiŋ dokti wohoge yotilowit. ");
INSERT INTO nop_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Yahwe, du Bepaŋne, nu nehitubu-lodadok ganinadiwene agaŋ kedem nehitubu-kedebaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Yahwe, nu agaŋ kumuŋ tibe tugut iŋgoŋ kotigoŋ nehitubu-pilakuŋ. Nu me kumuhi yohikwehineŋ fofoŋdok tubudulagut, iŋgoŋ kotigoŋ hatihati namguŋ. ");
INSERT INTO nop_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Unduŋ doktiŋa Yahwe’walaŋ metam hogohogok, hidi welemomooŋ nadimiŋa kap toŋa wou uŋgoniŋ nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Adi kwihita-kabe nai muniniŋ hogok tilak. Adi inditok nadinimilak doktiŋa helemahelemaŋ kwetfoloŋ iŋoŋ hatiyane momooŋ tinimilak. Timiŋ nai muniŋgoŋ hogok dauge meeniŋ kedem foluwaak, iŋgoŋ haniŋ pilap hinek nadifo kotigoŋ tubumintaluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Nu koom momooŋ hinek hatiŋa indiŋ yogut, “Nemek niŋdi tuwot mu nehitifowaak.” ");
INSERT INTO nop_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Yahwe, du yot fafaŋeniŋ niŋ kweboboe foloŋ yatak nabugoŋ nehitubu-kilitiune yakut. Iŋgoŋ du sigilulum tinamuŋa wooŋ hakuŋ nai uŋaniŋ muntadi kisaŋ hinek nehitifoguk. ");
INSERT INTO nop_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Unduŋ doktiŋa, Yahwe, nu kutiganilat. Tiŋa nehitubu-lodaweŋ yoŋa fafaŋeeŋ ganinadilat. ");
INSERT INTO nop_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Nu nobu kumumbene maŋgoŋ momooŋ kedem mintawek? Be kumuŋa meyotneŋ wene wendi nebek kedem be tubulodawek? Me kumuŋ tigiŋ hekidi kedembe ganiutumbaneeŋ? Adi du helemahelemaŋ momooŋ tiyemilaŋ u kedem be yohautaneeŋ? U tuwot mooŋ. ");
INSERT INTO nop_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Yahwe, siloŋ tobogoŋ tiŋa nadinambeŋ. Yahwe, unduŋ tiŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Du welemulapne liliwenekulaŋa nehitubu-lodaune kap miyeeŋ tonadifo tugut. Koom adi meeniŋ kumumbune kobulabulaye tiyamdok tuwolit tugut. Iŋgoŋ du bulaniŋgoŋne u tubufambekeneune welenedi nadifo tubumintaguk. ");
INSERT INTO nop_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Wendoktiŋa nu mane tuwot mu tehewit. Nu adi kap toŋa wohoge ganintiloit. Yahwe, du Bepaŋne, wendoktiŋa nu helemahelemaŋ welemomooŋ nadigamuŋa ganiutumbaluwaat. ");
INSERT INTO nop_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Yahwe, nabudokoweŋ yoŋa du’walaŋkade bulat. Unduŋ doktiŋa binabune memik hekidi mu nehitifooŋ nehitubu-mekaneŋ. Du didimeniŋ, doktiŋa kotigoŋ nanagileŋdok ganinadilat! ");
INSERT INTO nop_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Du nadinamuŋa pilap hinek nanagileŋ. Du adi hebi-it kwetne, kawade mage dabugoŋ. Unduŋ doktiŋa yahehewe tinamuŋa kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Biyagoŋ hinek, du kubugoŋdi hebi-it kwetne tiŋa yahehewene. Da koom medege yofafaŋeguŋ undugoŋ tiŋa nabudokooŋ talikom tiŋa nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Da kubugoŋdi nu’walaŋ saŋiniŋ. Unduŋ doktiŋa nabudokoweŋ, kaŋ memik hekidi nohonedok begep ibinamgiŋ wendi mu nulek. ");
INSERT INTO nop_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Nu munabuline kohoge gineŋ kamelat. Yahwe, mede biyagoŋ diniŋ Bepaŋ, du malabumuŋ gineniŋ kotigoŋ nanagikuŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Nu adi du hogok nadisukilitigamuŋa me bepaŋ yalayalaŋ yeniutumbaiŋ heki yabukwihita tilat. ");
INSERT INTO nop_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Du welegedi hinek nabukahileeŋ malabumuŋ mintanamgiŋ hogohogok u yabunadiŋa nehitubu-lodaguŋ. Unduŋ doktiŋa nu welemomooŋ nadiŋa nadifo tilat. ");
INSERT INTO nop_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Du memik heki mu biyabune nohonegiŋ. Du nehitubu-lodaune momooŋ hinek hatilat. ");
INSERT INTO nop_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Yahwe, nu malabumuŋ gineŋ hatat ale du siloŋ tobogoŋ tinambeŋ. Nu makat kokekoke daune agaŋ bedi tilak. Tiŋa undugoŋ foloone maaŋ agaŋ gweheyedapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Na’walaŋ welemulapnedi nehitifohinaka hinek tilak. Nu makat gibitaŋ kotat doktiŋa hatihatine dapmaŋdok tilak. Tiŋa malabumuŋnedi wapum hinek, unduŋ doktiŋa saŋiniŋne fodapmaŋ tilak. Kaŋ kitiline hogohogok gweheye tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Memikneye adi nanimpekit tiiŋ, eŋ manemaneye adi medehaki naniiŋ, kaŋ notneye adi nutok munta kisaŋ tiiŋ. Nu talipmeŋ buluwene metam adi nabuŋa momoŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Meeniŋ agaŋ kumiiŋ kaŋ kaule tiyemam unduŋ, metamdi nu nadikaule tinamiiŋ. Tiŋa undugoŋ nu adi kwet kabotdi tawaune beyakukiiŋ wendok tuwolit. ");
INSERT INTO nop_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Nu nadiwene memik feedi mede hamahamap yoiŋ, adi nehitubu-munta titiŋdok unduŋ tiiŋ. Adi kadakaniŋ tinamuŋa nulukumuŋ titiŋdok wendok bopneeŋ mede yodobu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Iŋgoŋ Yahwe, nu adi du hogok nadisukilitigamulat, tiŋa du Bepaŋne ganilat. ");
INSERT INTO nop_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Helemahelemaŋ du kohoge foloŋ hatilat. Ale tiyaugene me mik tinamuŋa nehikeleiŋ hekidi nehitubu-kadakaneeneŋ ale du kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Nu da’walaŋ kwanai-mege doktiŋa siloŋ tobogoŋ tinamuŋa kotigoŋ nanagila nabunadifo tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yahwe, du nehitubu-lodaweŋ yoŋa kutiganilat. Du memik heki biyabune fafaŋe mu tineŋ. Adi yadi toboniŋ kadaka tineŋ. Adi yadi kedem kumuŋa kumuhi’walaŋ yohikwehineŋ uneŋ, uŋoŋ wooŋ mahik teheŋa hatneŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Me yalaŋ-me heki adi foko tiŋa me didimehi yenimpekit tiŋa medehaki yeniiŋ. Unduŋ doktiŋa du yehitubu-kadakaune mahik galihep hinek tibek. ");
INSERT INTO nop_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Du adi kwanai momooŋ hinek tiŋa me nediyeŋ gikiŋgoŋ tigamiiŋ heki u yehitubu-lodalaŋ. Tiŋa me yehitubu-lodadok yoŋa du’walaŋkade biiŋ adi momooŋ hinek yabudokolaŋ. Kaŋ metam hogohogokdi du momooŋ tiyemulaŋ u agaŋ kaŋ nadigamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Du metam u da hataŋneŋ yamaiŋgoŋ uŋgoŋ yapme-hebilaŋ kaŋ me widihi-kumuŋdok yohebet tiiŋ heki adi tuwot mu widihiiŋ. Unduŋ tiŋa da hebeke gineŋ yapme-hebilaŋ kaŋ me hogohi’walaŋ medehakidi mu yehitiŋafolak. ");
INSERT INTO nop_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yahwe wou nintiloloŋdok! Adi weleŋdi hinek nabukahilelak. Doktiŋa memik hekidi nehikelemadiŋa nehitubu-kadaka tine tiiŋ iŋgoŋ adi’walaŋ saŋiniŋŋiŋdi nehitubu-kilitiune kedem hatilat. ");
INSERT INTO nop_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Wapum, nu koom agaŋ binek nehikelekulaŋ yoŋa munta tiŋa du gehitubu-dulaaŋ yamaiŋgoŋ mu bugut. Iŋgoŋ du kutibulabulayene nadinamuŋa nehitubu-lodaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Yahwe’walaŋ memetam, hidi welehikdi hinek Yahwe kahileyaneeŋ. Metam nediyeŋ adi keleiŋ adi yadi momooŋ hinek yabudokolak. Iŋgoŋ metam nediyeŋ foko tiiŋ aditok adi tuwaŋiŋ kibikoŋ yemilak. ");
INSERT INTO nop_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Metam Yahwe nadisukilitimiiŋ, hidi fafaŋe tiŋa yalune welehikdi mu gweheyeeŋ helemahelemaŋ saŋiniŋnit hatuwaak. ");
INSERT INTO nop_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Bepaŋdi me niŋ’walaŋ yomŋiŋ bimiŋa kadakaniŋŋiŋ tumolokulimimbune adi yadi biyagoŋ hinek Bepaŋ’walaŋ kahaŋ kahileeŋ nadifo tilak. ");
INSERT INTO nop_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Tiŋa Yahwedi indiŋ yodapmalak, me yoŋ adi yomnit mokit, tiŋa undugoŋ titiŋ yalaŋ mu takaliŋa tilak. Unduŋ yobune me u wendoktiŋa Bepaŋ’walaŋ kahaŋ moŋgola nadifo kedem tibek. ");
INSERT INTO nop_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Nu kadakaniŋne mu yobihikut nai uŋaniŋ timiŋ be hadapmo adi makat koyone hogok tulugut. Wendoktiŋa foloone gweheyedapmaŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Timiŋ be hadapmo adi kohoge malabumuŋdi kisaŋ hinek nehikamedihiguŋ. Unduŋ tubune welene diniŋ gibibem silida hinek tuguk. Uyadi mele fafaŋeniŋ yagigi diweune nemenemek dasilidadapmalak wendok tuwot. ");
INSERT INTO nop_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Kaŋ nu kadakaniŋne ganimbihikut, tiŋa titiŋ hogohine u mu boihebigut. Nu adi toboniŋ kadakaniŋne hogohogok Yahwe nimbihikut. Nu yobihidapmawene du kadakaniŋne diniŋ yom tumolokutnamguŋ. ");
INSERT INTO nop_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Unduŋ doktiŋa metam nediyeŋ du gehikeleiŋ, adi yadi malabumuŋ mintayembune du ganinadiyaneeŋ. Kaŋ ime bediŋa gabuŋ wapum tibaakdi adi mu yehiwehemilaak. ");
INSERT INTO nop_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Da kubugoŋdi hebiit kwetne, tiŋa undugoŋ nabudokoune malabumuŋdi mu nehitifowek. Da kubugoŋdi malabumuŋ gineŋ kotigoŋ nanagitaŋ, wendoktiŋa kap gibitaŋ tolat. ");
INSERT INTO nop_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Wapumdi indiŋ yolak, “Nu mohinek gehititiŋeneeŋ talik deŋak takalidok u ganindidimewit. Unduŋ tiŋa malabumuŋ gineŋ gabu-ulidokowit. ");
INSERT INTO nop_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Du doŋki tiŋa wosi dabugoŋ mu tibeŋ. Adi nadinadihinit mokit. Unduŋ doktiŋa ain niŋ tawa fafaŋehi wendi mahik gineŋ kameeŋ tawa yehimaneune talik deŋandiŋ uuŋdok u yenindidimelak. Eŋ unduŋ mu tiyembune woŋ adi du’walaŋ nadinadige tuwot mu takalidemeek.” ");
INSERT INTO nop_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Me hogohidok adi malabumuŋ fee kedem mintayembek. Iŋgoŋ metam nediyeŋ Yahwe nadisukilitimiiŋ adi yadi siloŋ tobogoŋ tiyemiŋa momooŋ hinek yabudokowek. ");
INSERT INTO nop_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Metam didimehi, hidi Yahwedi nemek momooŋ tihamguk wendok welemomooŋ nadiŋa nadifo tineŋ. Metam hogohogok Bepaŋ namanda foloŋ didimeniŋ hatiiŋ, hidi nadifo tiŋa baham toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Metam didimehi, hidi Yahwedi nemenemek hogohogok tuguk wendok nadifo tineŋ. Metam Bepaŋ’walaŋ medeŋiŋ didimeniŋgoŋ takaliiŋdi wou nintiloune utumba hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Kulele ulune mede momooŋ tobune Yahwe wou niutumbaneŋ. Gita tawaŋiŋ 10 u ulune aditok mede momooŋ tomimbek. ");
INSERT INTO nop_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Kap kobuli hinek tomineŋ, tiŋa gita ulune mede momooŋ hinek toneŋ, kaŋ nadifo diniŋ kakali maaŋ tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Yahwe’walaŋ mede adi biyagoŋ hogohogok. Adi yadi titiŋ didimeniŋ titiŋdok yofafaŋeguk hogohogok u tubune folooŋnit tubu-dapmalak. ");
INSERT INTO nop_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Bepaŋ adi titiŋ didimehi hogohogok eŋ yodapmaŋ didimehidok hogok yabunadifo tilak. Eŋ Yahwe’walaŋ siloŋ tobogoŋdi kwetkwet hakilidapmalak. ");
INSERT INTO nop_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yahwedi yobune kunum heki mintagiŋ, tiŋa mele muyakip eŋ bamholiŋa u adi’walaŋ maŋiŋ mede-de mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Adi me niŋdi ime kabot gineŋ gilune fotokolak wondok tuwot imeŋgwaŋ hogohogok beŋa kwet kubugoŋ gineŋ bopneguk, eŋ imeŋgwaŋ fuliŋmamaŋ u henaulibi yotneŋ boihebiguk. ");
INSERT INTO nop_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Kwetkwet metam hogohogok Yahwe kaŋ hehele tiŋa gikiŋgoŋ timineŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Maŋgande, adigoŋ mede hogok yobune kwet i mintaguk. Tiŋa undugoŋ mede saŋiniŋnit hinek yobune nemenemek mintadapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Yahwedi mebop noli’walaŋ nadihebethik u dobu-uyali tubufit tiyemilak. Tiŋa adi nemek niŋ titiŋdok mede yofolok tiiŋ u talik teheyembune tuwot mu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Iŋgoŋ oŋ, Yahwe’walaŋ yohebetŋiŋ adi dapmandapmaŋnit mokit haliwooŋ halaak. Weleŋ gineŋ nadihebet hatak u meeniŋ bop indigoŋ kwetkwet hatitawiiŋ’walaŋ gineŋ folooŋ tubumintalak. ");
INSERT INTO nop_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Metam adi Yahwedi Bepaŋhik hatilak, adi Bepaŋ’walaŋ kahaŋ kahileiŋ doktiŋa nadifo kedem tineŋ. Biyagoŋ hinek, metam agaŋ netok gigit yoŋa yabukahileguk adi nadifo kedem tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yahwe adi kunum foloŋ hali diweune foune metam kwetfoloŋhi hogohogok yabudapmalak. ");
INSERT INTO nop_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Adi me mapme iit kwelineŋ ilaŋa diweune foune kwetfoloŋ metam yabudapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Negoŋ metamdok nadinadi tubumintayemilak, tiŋa titiŋ dediŋ tiiŋ hogohogok u agaŋ yabunadidapmalak. ");
INSERT INTO nop_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Me mapme niŋ adi mikmeŋiye fee hatiiŋ iŋgoŋ tuwot mu tubulodaneŋ, be mikme niŋ adi saŋiniŋŋiŋ wapum wendi tuwot mu tubulodahinakawek. ");
INSERT INTO nop_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Mik wosi heki adi mikme yehitubu-lodaune mik gineŋ fafaŋe tuwot mu tineŋ. Wosi fafaŋeniŋdi mikme mik gineŋ gweheyeiŋ kotigoŋ tuwot mu yahaŋewek. ");
INSERT INTO nop_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Iŋgoŋ indiŋ nadineŋ, metam nediyeŋdi Yahwedok gikiŋgoŋ timiiŋ, tiŋa welehikdi kahile hinek tiiŋ, adi yadi Yahwedi yabudokolune namanda foloŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Unduŋ doktiŋa yabudokoune tuwot mu kumiiŋ. Eŋ fiye kadaka nai gineŋ nanaŋedok baniŋ tiiŋ kaŋ yabudokoune kaipmuŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Unduŋ doktiŋa indi Yahwedi nihitubu-lodadok woomam. Adi kubugoŋdi kweletalaknik tiŋa nihitubu-loda tilak. ");
INSERT INTO nop_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Indi adi wou uŋgoniŋ u nadisukilitiyam, unduŋ doktiŋa aditok nadifo timiyam. ");
INSERT INTO nop_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O Yahwe, indi du nihitubu-lodaweŋ yoŋa dutok nadikunakunale hati-tiyam, ale siloŋ tobogoŋgedi indigut haliwooŋ hatuwaak. ");
INSERT INTO nop_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Nu Yahwe helemahelemaŋ niutumbaluwaat, kaŋ ninadifonedi mane gineŋ tomboyoutnit hatuwaak. ");
INSERT INTO nop_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Nu Yahwedi nehitubu-lodaguk wendok nadiŋa wou nintilowit, kaŋ metam fofoŋhinit malabumuŋ gineŋ hatiiŋ, adi u nadiŋa welemomooŋ nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Nukut Yahwe wougigitŋiŋ yotubuhautanim, tiŋa indi wanakaŋ wou nintiloloye tinim. ");
INSERT INTO nop_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Nu Yahwedi nehitubu-lodawek yoŋa ninadigut, kaŋ yonadine nadinamguk. Unduŋ tiŋa welene gineŋ munta hakuk u liliwenekutnamguk. ");
INSERT INTO nop_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Metam Wapum nadisukilitimiiŋ, adi yadi nadifo tiŋa nadisukilitihik wondok meka mu tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Nu kada, Yahwe ninadiwene yonadine nadiŋa, malabumuŋ gineniŋ nehikibidakuk. ");
INSERT INTO nop_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Biyagoŋ kuyoŋ, metam Yahwe’walaŋ hebeŋ gineŋ hatiŋa gikiŋgoŋ timiiŋ heki adi yadi aŋeloŋiyedi adigut yamaiŋgoŋ yehikelemadi tiŋa yabu-ulidoko tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yahwe adi momooŋ hinek, unduŋ doktiŋa hidi hide kanadi tiŋale Wapum adi momooŋ u kedem nadidakaleneŋ. Me nediyeŋ adi hebeŋ gineŋ wooŋ hebihatilak adi Bepaŋdi kahaŋ timimbu nadifo kedem tibek. ");
INSERT INTO nop_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Yahwe’walaŋ metamŋiye, didimehi eŋ nadisukilitihinit, hidi Wapum hebeŋ gineŋ hatiŋa gikiŋgoŋ timiyaneeŋ. Metam adi’walaŋ hebeŋ gineŋ hatiiŋ heki adi nemek niŋdok baniŋ nemu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laion pamala adigili kale nanaŋedok map tiŋa gweheye tiiŋ. Eŋ metam nediyeŋ Yahwe kutnilohi tiiŋ heki adi nemek momohidok baniŋ mu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","O wapmihiwoi, hidi buŋa magi kametnadi tubune Yahwe hebeŋ gineŋ gikiŋgoŋ timiŋa hatihati wendok hanindidime tibit. ");
INSERT INTO nop_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Me nediyeŋdi hatihati kweheyeniŋgoŋ hatidok nadisulak, be melenai feegoŋ hatitaloŋila nemenemek nanadifo tihatidok nadilak? ");
INSERT INTO nop_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ala du unduŋ hatidok nadikaaŋ, medehaki mu yoluwaaŋ eŋ mede yalaŋ maaŋ mu yoluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Du titiŋ hogohi u sigilulum tiyemiŋa titiŋ fofohi u hogok keleeŋ tuluwaaŋ. Du adi metam nolidut welekubugoŋ tiŋa titiŋ fofooŋ uŋakoŋ hogok fafaŋe tiŋa takaliluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yahwe adi metam didimehi’walaŋkade dau diwe tilak, unduŋ tiŋa yonadihik nadiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Iŋgoŋ Yahwe adi metam kadakaniŋ titiŋ hekidok sigilulum tiyemilak. Unduŋ tubune kumumbu metamdi nadikaule tiyemdok unduŋ tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Metam didimehi adi Yahwe ninadi tiiŋ kaŋ yonadihik nadiyemilak. Unduŋ tiŋa malabumuŋhik gineniŋ yehitubu-lodaaŋ yanagitak. ");
INSERT INTO nop_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yahwe adi metam welemulaphinit yehitubu-dulaaŋ yamaiŋgoŋ uŋgoŋ hatilak, tiŋa adi yadi metam nadikunakunalehik gweheye tilak undihi u yehitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Me didimeniŋ’walaŋkade malabumuŋ mebimebi mintamilak, iŋgoŋ Yahwedi tubulodaune malabumuŋdi mu tubugweheyeiŋ. ");
INSERT INTO nop_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Wapum adi kunilit wanakaŋ hinek kadokolak, kaŋ kitiliŋiŋ-kabe nemu gololak. ");
INSERT INTO nop_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Nemek kadakaniŋ mebimebidi me hogohi widihi-kumuneeŋ, kaŋ me nediyeŋdi me didimehidok mik tiyemilak adi yadi Wapumdi kibikoŋ malabumuŋ hinek timimbaak. ");
INSERT INTO nop_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Yahwe adi kwanai-meŋiye kumuŋ gineniŋ kotigoŋ yanagitak kaŋ kaipmuŋ hatiiŋ, ale metam nediyeŋdi adigoŋ yabudokoune hatiiŋ unduŋ nadisukilitiiŋ heki adi yadi tuwot mu yehitubu-kadakawaak, mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Yahwe, me nutok kwihita tinamiiŋ u yeninto tibeŋ, tiŋa me nediyeŋ mik tinamiiŋ u mik tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Mik diniŋ bomboŋ eŋ kweletalakge u moŋgola buŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Bohom tiŋa miknoŋge beŋa me nehikele tiiŋ u yahep tiyembeŋ. Nu gehitubu-lodaaŋ ganagilit unduŋ kedem nanimbune nadiwit. ");
INSERT INTO nop_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Meheki nulukumuŋ tine tiiŋ u mik gineŋ yehitubu-malabudaune meka tineŋ. Adi nehitubu-kadakadok mede yofolok tiiŋ, doktiŋa du yehikeleeŋ yehitubu-giyonda hinek tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yahwe, sububadi bem hapmuŋ kumuhi fedila beyakutak wendok tuwot aŋelogedi me hogohi u yehikelehapene bekulek. ");
INSERT INTO nop_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Aŋelogedi yehikeleune mambip gineŋ wooŋ yalisulukeneeŋ maaŋ widihiwaak. ");
INSERT INTO nop_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Nu nemek nemu tiyemgut, iŋgoŋ adi nu nehitubu-kadakadok yoŋa siyoŋ tehinamuŋa woom hakiiŋ. Tiŋa undugoŋ nu maaŋ fofoŋdok yoŋa koŋ niŋ dobugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Iŋgoŋ mu naditumbaaŋ hatune da nadiune malabumuŋ u nehi foloŋ lowek. Siyoŋ nutok tehinamgiŋ u nadiune toboniŋ nehi uŋgoŋ foneŋ, eŋ koŋ dobunamgiŋ u nadiyembune nehi uŋgoŋ maaŋ foneŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Yahwe adi unduŋ tubune nu nadifo timimbit. Tiŋa nehitubu-lodaaŋ nanagilune wendoktiŋa welemomooŋ hinek nadimimbit. ");
INSERT INTO nop_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Unduŋ tiŋa nu Yahwe welenedigoŋ hinek niutumbaaŋ indiŋ yobit, “Nebek niŋ du indiniŋ nemoŋ. Du me gweheyehi momooŋ hinek yehitubu-lodalaŋ. Kaŋ me fafaŋeŋgoŋ tiiŋ hekidi tuwot mu yehitubu-kadakaiŋ. Eŋ me fafaŋehi adi nemenemekhik tuwot mu yolom moŋgokiŋ.” ");
INSERT INTO nop_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Nu nemek kadakaniŋ nemu tugut iŋgoŋ yalaŋ-me hekidi hogok naniŋfit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Nu kibi titiŋ momooŋ tiyemilat, iŋgoŋ kibi adi titiŋ hogoli tinamiiŋ. Unduŋ doktiŋa welemulap nadilat. ");
INSERT INTO nop_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Iŋgoŋ oŋ, adi yagit tigiŋ kaŋ nu bulaniŋgoŋ nadiŋa tinahukut bulaniŋgoŋ diniŋ tinahukukut. Eŋ nanaŋe kameheŋa hali malabumuŋ tubumintagut. Unduŋ tiŋa duwokeneeŋ hali ninadi kwanai hatugut. ");
INSERT INTO nop_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Ninadi indiŋ adi notne be datnedok tiŋa tibit adi kedem. Tiŋa talik ulat adi me niŋdi miŋ kumumbune bulaniŋgoŋ nadiŋa makat kotak wondok tuwot nu bulaniŋgoŋ nadiŋa makat hakotugut. ");
INSERT INTO nop_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Iŋgoŋ nu’walaŋkade malabumuŋ mintaguk, kaŋ nai uŋaniŋ adi yadi nadifo tiŋa bopnegiŋ. Bopneeŋ nutok mede yofilifilim tinamgiŋ. Me noli mu nadiyemilat adi yadi mede kadakahi tomboyoutnit hogok naniŋfit tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Adi mede yopekit kisaŋ hinek tiŋa malabumuŋ namgiŋ. Tiŋa welehikdi mu nabukahileeŋ mahik sikiliti tiŋa kwihitaŋgoŋ nabugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Wapum, du maŋgoŋde biyabune hatiiŋ? Du kotigoŋ nanagilune adi tuwot mu nehitubu-kadakaneŋ. Adi yadi laiondok tuwolit tiŋa nulukumuŋdok tiiŋ doktiŋa adi’walaŋ kohohik gineniŋ kotigoŋ nehikagiyaleŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Du unduŋ tubune nu metambop wapum lekiŋgoŋhik gineŋ ganiutumbawaat. Biyagoŋ hinek-ku metambop wapum lekiŋgoŋhik gineŋ wohoge ganintilowaat. ");
INSERT INTO nop_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Me noli mik hogok tinamfit tiiŋ, doktiŋa tiyaugene biyabune nehitifooŋ nalakapmeŋdok nadifo tineeneŋ ala. Adi hogok nabukwihitafit tiiŋ, unduŋ doktiŋa biyabune nu’walaŋ malabumuŋ wondok nadifo mu tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Adi menot tiŋa hatidok mede-kabe nemu yoiŋ. Adi yadi toboniŋ meeniŋ yokwet gineŋ momooŋ itowiiŋ u yehitubu-kadakadok mede hogok yoiŋ. Tiŋa undugoŋ, adi yadi me momohi yalaŋ yeniŋkamandaaŋ yehitubu-kadakadok wondok bop tihatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Adi kutifiyeeŋ mede naniŋfit indiŋ tiiŋ, “Biyagoŋ hinek, du titiŋ kadakahi tubune gabugumun.” ");
INSERT INTO nop_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Yahwe, du meheki u agaŋ yabuŋa nadilaŋ, doktiŋa mage mu teheŋa haleŋ. Wapum, du binabuŋa wooŋ kweetniŋgoŋ mu haleŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Du Bepaŋ, tiŋa Wapumne. Du pilali buŋa nehitubu-lodaweŋ. Pilali yali medene fafaŋewekdok ulihiŋa yohautaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yahwe, du adi Bepaŋne, du adi titiŋ didimeniŋ hogok tilaŋ. Du nehitubu-lodaune memikneyedi nu titiŋ didimeniŋ takalilat unduŋ u nadineŋ. Tiŋa biyabune nu malabumuŋ gineŋ hatat wondok nabuŋa nadifo adi mu tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Du biyabune nehi uŋgoŋ indiŋ adi mu yoneŋ, “Kedem hinek nemek titiŋdok yogumun u agaŋ tiyam.” Tiŋa undugoŋ, biyabune indiŋ adi mu yoneŋ, “Indi agaŋ tubukadakayam.” ");
INSERT INTO nop_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Adi malabumuŋ mintanamulak wendok nadifo tiiŋ, doktiŋa du yehitubu-mekaaŋ yehitubu-giyonda tibeŋ. Adi yadi nutok nadiune fofoŋnit titiŋdok nadiŋa nehi wohiye yobeloiŋ, unduŋ doktiŋa yehitubu-mekaŋ wohiye yehimoŋgofoweŋ. ");
INSERT INTO nop_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Iŋgoŋ meeniŋ nediyeŋdi nu me didimeniŋ unduŋ nanimbeŋ nadiiŋ, adi yadi kedem nadifo tiŋa kakaliŋa welemomooŋ foloŋ hatineŋ. Tiŋa helemahelemaŋ indiŋ kedem yoyaneeŋ, “Yahwe adi loloŋnit hinek, doktiŋa kwanai-meŋiŋdi momooŋ hinek hatidok nadimilak.” ");
INSERT INTO nop_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Unduŋ doktiŋa nu titiŋge didimeniŋ wendok yohautawit, tiŋa wohoge helemahelemaŋ timiŋ eŋ hadapmo ganintiloluwaat. ");
INSERT INTO nop_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Kadakaniŋdi me hogoli weleŋ maaneŋ nihohoket tilak. Me undiniŋdi Bepaŋdok munta-kabe nemu tilak. Mokoŋ hinek. Adi yadi Bepaŋ agaŋ sigilulum hinek timilak. ");
INSERT INTO nop_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Adi ne uŋgoŋ indiŋ nadilak, “Na me loloŋnit doktiŋa Bepaŋ adi kadakaniŋ tugut u tuwot mu yehitubu-mintawaak, tiŋa mede gineŋ tuwot mu napmewaak.” ");
INSERT INTO nop_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Helemahelemaŋ me weŋ maŋiŋ foloŋ adi mede kadakahi tiŋa mede yalaŋ hogokdi labulak. Unduŋ doktiŋa kotigoŋ titiŋ fofooŋ titiŋdok nadinadi-kabe nemu halimilak. ");
INSERT INTO nop_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Timiŋ damo deitdok gulupŋiŋ foloŋ deihali adi kadakaniŋ maŋgoŋ titiŋdok wendok nadihebet hati tilak. Adi talik hogoli hogok kelelak, unduŋ doktiŋa titiŋ hogoli sigilulum tuwot mu timilak. ");
INSERT INTO nop_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Yahwe, du’walaŋ welesiloŋge adi loloŋnit hinek. Kameka titiŋdok tuwot mooŋ. Fekŋiŋdi looŋ kunum foloŋ dapmalak. Eŋ mede yofafaŋeguŋ u biyagoŋ hinek keleŋ tilaŋ, u maaŋ undugoŋ loloŋnit hinek, looŋ mulukwaŋ hatakneŋ uŋgoŋ dapmalak. ");
INSERT INTO nop_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Eŋ titiŋ didimeniŋge maaŋ undugoŋ kweboboe nabugoŋ loloŋnit hinek. Du mede nadinadi kwanaige tilaŋ adi imeŋgwaŋ fuliŋmamaŋ wondok tuwolit, indi nadidakaledok tuwot mooŋ. Yahwe, du kubugoŋdi kale hogohogok eŋ meeniŋ yabudokoune hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Bepaŋ, welegedi nibukahile hinek tilaŋ, woŋ adi nemek uŋgoniŋ hinek. Indi wendok hogok nadiyam. Metam hogohogok adi pupup mihiniŋdi wooŋ meehik papaliŋiŋ gineŋ hebihakiiŋ wondok tuwot du’walaŋkade wooŋ hebihakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Du yokeneŋ adi nanaŋe mohok fe, doktiŋa metamdi nanaŋedok baniŋ mu tiiŋ. Duhuduhu momooŋ wendi ime nabugoŋ wodiune metamdi gitnaŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Du nemenemek hogohogok’walaŋ hatihati diniŋ mebi. Tiŋa undugoŋ hauta diniŋ mebi u maaŋ dugoŋ, unduŋ doktiŋa dugoŋ hauta nimilaŋ kaŋ indi kedem hatiyam. ");
INSERT INTO nop_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Helemahelemaŋ metam nediyeŋ du nadigamiiŋ adi welesiloŋ tiyemiŋa yabukahile hinek tuluwaaŋ. Tiŋa me didimehi yehitubu-lodaune adi momooŋ hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Du me fokohinit biyabune mu nehikeleneeŋ. Tiŋa undugoŋ, biyabune mu nehikelekutneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","U yabuneŋ. Me hogohi adi yehibekulu kwetfoloŋ maaŋ fogiŋ. Adi kotigoŋ mu pilatneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Du me kadakahidi titiŋ dediŋ tiiŋ wendok nadibedi mu tibeŋ. Du me kadakaniŋ tiiŋ heki’walaŋ nemenemekhik doktiŋa hogok nadikadakafit mu tiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Nai muniniŋ-kabe hinek me hogohi adi kilihikitdi sigeneiŋ unduŋ, eŋ bem hapmuŋdi kumuŋa makwaneiŋ wendok tuwot kadakaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Du Yahwe hogok nadisukilitimiŋa titiŋ didimeniŋ hogok tibeŋ. Du unduŋ tiŋa helemahelemaŋ kwakeneŋ uŋoŋ kulemaŋgoŋ hatiŋa titiŋ didimeniŋ momooŋgoŋ keleeŋ tuluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Du Yahwedok nadifo timimbune adibo welege gineŋ maŋgoŋdok hinek nadiluwaaŋ u kedem gamuluwaak. ");
INSERT INTO nop_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Du hatihatige Yahwe kohoŋ foloŋ kameweŋ. Unduŋ tiŋa nadisukiliti hinek timimbune adi kedem gehitubu-lodawek. ");
INSERT INTO nop_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Tiŋa titiŋge momooŋ u meledi hautalak unduŋ miŋgilaŋgoŋ tubuhautawaak. Tiŋa undugoŋ titiŋge momooŋ u mele lekiŋgoŋ folooŋ hinek hautalak wendok tuwolit metam namandahik foloŋ tubudakale-hinakaune kaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Du Yahwe hebeŋ foloŋ wo tubu-dulaaŋ kulemaŋgoŋ hatiŋa woomimbune adi kedem gehitubu-lodawek. Du me titiŋhik dediŋ tiŋa bomboŋ fee moŋgokiiŋ u yabuŋa nadigalika mu tibeŋ. Be me titiŋ hogohidok nadihebet tiŋa tubune mintaiŋ wendok nadibedi mu tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Du kwihita mu tiluwaaŋ, tiŋa welege bikabune kudup mu daluwaak. Titiŋ hogohi wendi gehimaneune kadakaniŋ tibaaneŋ ala, nemek hogohi undihidok welege yout adi mu tuluwaak. ");
INSERT INTO nop_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Me hogohi adi yadi yehililiwene-kudapmaŋ tibaak. Eŋ metam nadisukiliti tiŋa Yahwedi yehitubu-lodadok woomiiŋ adi yadi kwehik kahileeŋ momooŋ hinek hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Nai mu kweheyelune me hogohi adi liwe-dapmaŋ tineeŋ. Adi yabudok yohikwehineŋ diwewaaŋ iŋgoŋ nemu yabaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Kaŋ metam nehi’walaŋ wohikgigitdok nadiune fofoŋnit tubune fofoŋnit hatineeŋ adi yadi Bepaŋdi kwet hogohogok u aditok yembaak. Kaŋ adi uŋoŋ kulema tubumintaaŋ iutumbaaŋ duhuduhunit hatiŋa nadifo tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Me hogoli adi me fofooŋ u tubukadaka titiŋdok nadilak. Unduŋ doktiŋa kaŋ kwihikwihileŋgoŋ nadilak. ");
INSERT INTO nop_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Iŋgoŋ Wapum adi nai niŋ mintawaakneŋ uŋaniŋ me hogohi adi fidapmaŋ tineeŋ u agaŋ nadilak. Unduŋ doktiŋa Wapum adi yabuŋa gege tilak. ");
INSERT INTO nop_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Me hogohi adi miknoŋhik wodibe labiiŋ, eŋ tebehithik yehimanekiŋgineeŋ me fiyewakahi be me fofoŋhinit u yalamkumune tiiŋ. Tiŋa undugoŋ metam titiŋ didimeniŋ tiiŋ u widihi-kumuŋ titiŋdok tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Iŋgoŋ oŋ, miknoŋhikdi udaneeŋ nehi’walaŋ kabahik uŋakoŋ youtombaak, eŋ tebehik hogohogok uligolodapmaŋ tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Me didimeniŋ hatilak’walaŋ bomboŋŋiŋ lufomgoŋ-kabe ilimiiŋ wondi me hogohi’walaŋ bomboŋhik mohok fee u yalakapme-dapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Maŋgande, Yahwedi me hogohi’walaŋ saŋiniŋhik yolom-bedapmaŋ tibaak. Eŋ me didimehi hogok adi kedem yabudokooŋ yehi-ulihiwaak. ");
INSERT INTO nop_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Metam welehik walaniŋ hinek adi yadi Yahwedi momooŋ hinek yabudokolak. Tiŋa kwet aditok yemilak woŋ adi aditok haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Nai kadakaniŋ gineŋ adi yadi malabumuŋ mu tubumintaneeŋ. Be fiye kadaka tiŋa map wapum mintawaak iŋgoŋ adi nanaŋedok baniŋ mu tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Iŋgoŋ me kadakahi adi kadaka-dapmaŋ tineeŋ. Eŋ Yahwe mik timiiŋ heki adi yadi wowoŋgimiŋdi mintaaŋ kotigoŋ kumuŋgolopmalak unduŋ tineeŋ, be mupmukdi nai muniniŋ-kabe looŋ liwelak unduŋ liweneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Me kadakaniŋ adi nemek niŋ belak u kibikoŋ nemu tubu-udanelak. Iŋgoŋ me fofooŋ adi siloŋ momooŋ tiŋa metam nolidok nemek fee yemilak. ");
INSERT INTO nop_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Metam Wapumdi yeniŋkahaŋ tilak adi yadi kwehineŋ momooŋ hinek hatineeŋ. Iŋgoŋ metam haki tiyemilak adi yadi yehikelekut tubune uneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yahwedi metam deŋandiŋ uuŋdok u yenindidimeeŋ yahaŋelak. Adi me niŋ’walaŋ titiŋŋiŋ kaŋ nadiune utumba binek tilak, woŋ adi didimeniŋ hatidok saŋiniŋ milak. ");
INSERT INTO nop_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Me u maaŋ utak iŋgoŋ kadakadapmaŋ hinek mu tilak. Yahwedi kohoŋ foloŋ honeeŋ tubulodaaŋ hamaneune kotigoŋ pilali yatak. ");
INSERT INTO nop_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Nu mekuyane gineŋ hatitalabubuyeŋ agaŋ gawada tilat, nai uŋaniŋ Bepaŋdi me didimeniŋ sigilulum nemu timimbune kagut. Be undugoŋ, me didimeniŋ’walaŋ wapmihiŋiyedi map tiŋa nanaŋedok nayo nemu tubune yabugut. ");
INSERT INTO nop_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Helemahelemaŋ me didimeniŋ adi metam nolidok siloŋ tobogoŋ tiyemiŋa nemenemek fee yemilak. Kaŋ wapmihiŋiye yabuŋa nadiune u kahaŋ momooŋ niŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Unduŋ doktiŋa notne, du titiŋ kadakahi hogohogok u sigilulum tiyemiŋa titiŋ fofohi u hogok tiluwaaŋ. Unduŋ tiŋa kwetfoloŋ iŋoŋ hatiŋa wooŋ hatibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Bepaŋ adi titiŋ didimeniŋdok hogok nadilak. Adi yadi metamŋiye tuwot mu biyabune fitneeŋ. Yahwe adi helemahelemaŋ metam didimeniŋ hatiiŋ u hogok yabudokolak. Iŋgoŋ me hogohi’walaŋ wapmihihiye adi kadakadapmaŋ hinek tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Metam didimehi adi Bepaŋdi kwet yemguk u kahileneeŋ, tiŋa uŋgoŋ hatiŋa wooŋ hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Me didimeniŋ adi nadinadiŋiŋ momooŋ doktiŋa mede kedehi hogok yolak. Tiŋa undugoŋ, titiŋ didimehidok hogok yolak. ");
INSERT INTO nop_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Bepaŋ’walaŋ Yodoko Mededi weleŋ gineŋ hatak, unduŋ doktiŋa Bepaŋ takaliŋa Yodoko Mede u mu bikabulak. ");
INSERT INTO nop_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Me hogoli adi kabup hebi-hali me didimeniŋ u dediŋ tiŋa ulukumumbit yoŋa hakakuwat tilak. ");
INSERT INTO nop_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Iŋgoŋ Yahwedi me didimeniŋ u tuwot mu bikabune me hogolidi ulukumumbek. Be me hogolidi me didimeniŋ u mede gineŋ kamewek, iŋgoŋ Wapumdi me hogoli u nadimimbune mede gineŋ tuwot mu fafaŋewek. ");
INSERT INTO nop_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Du Yahwe nadisukilitimiŋa adi’walaŋ titiŋ takaliweŋ. Unduŋ tibeŋ kaŋ nadigamuŋa kwet gamuŋa me loloŋnit gapmeune kahilewaaŋ. Unduŋ tiŋa yabune me kadakahi yehililiwene-kulaak. ");
INSERT INTO nop_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Nu me kadakaniŋ kawene saŋiniŋŋiŋdi loloŋnit, Lebanon kwetneŋ uŋoŋ kweledi lohinakaaŋ bem noli yalakapme tiŋa yatak, wondok tuwolit tiŋa metam yalakapme-dapmaŋ hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Kuŋgoŋ oŋ, kougoŋ mindaŋkade uŋandiŋ yauŋa kawene adiye kotigoŋ uŋoŋ mu hatilak. Kaŋ nobu kait yoŋa diweyaulat iŋgoŋ mu kalat. ");
INSERT INTO nop_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Du me didimeniŋ kaweŋ, tiŋa me momooŋdi nemek kadakaniŋ nemu tuguk u kaŋ nadiweŋ. Me unduhi adi metam noli dut kulemaŋgoŋ hatiiŋ. Adi’walaŋ yalakiŋiye adi undugoŋ hatiŋa wooŋ hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Iŋgoŋ me kadakaniŋ tiiŋ heki yadi Wapumdi yehitubu-kadakadapmaŋ tilak. Eŋ yalakihiye adi liwedapmaŋ tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Yahwe negoŋ me didimehi u yehitubu-lodaaŋ kotigoŋ yahaŋelak. Malabumuŋ mintalak kaŋ negoŋ yabu-ulidokolak. ");
INSERT INTO nop_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Yahwedi yehitubu-lodawek yoŋa adi’walaŋkade wiiŋ. Unduŋ doktiŋa adi yehitubu-lodaaŋ me hogohi kohohik gineniŋ kotigoŋ yehikagiyatak, kaŋ momooŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Yahwe, du kwihita tiŋila mu nanintobeŋ. Du welege kudup daune nemek malabumuŋ mu tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Du tebegedi fiyagila nalamuŋaŋ, eŋ kohogedi nula tukulune maaŋ foŋat. ");
INSERT INTO nop_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Du kwihita tinamulaŋ, doktiŋa nu folofigita wapum gineŋ hatat. Kadakaniŋne doktiŋa yagit malabumuŋ hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Yomnedi foloone foloŋ looŋ nehikufula tilak. Kaŋ yom wendi bomboŋ moŋgole malabudaiŋ wendok tuwot hinek nehitubu-malabudalak. ");
INSERT INTO nop_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Wede foloone foloŋ ikiiŋ adi bitaka tiŋa tabut tiiŋ. Na titiŋ hogoli hinek tugut doktiŋa u mintanamulak. ");
INSERT INTO nop_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Welemulap wapum hinek nadiŋa agaŋ kadaka tilat. Doktiŋa helemahelemaŋ bulaniŋgoŋ nadiŋa makat hati-kotat. ");
INSERT INTO nop_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Foloone foloŋ adi kudup daaŋ nibune nadiyam undiniŋ kudup dadapmaune, yagit malabumuŋ hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Nu nemek niŋdi nehinalitifooŋ napme-hatak wendok tuwot gweheyedapmaaŋ fooŋ hatat. Tiŋa welene gineŋ moŋ hinek nadiŋa koyone ha-tilat. ");
INSERT INTO nop_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Wapum, welenedi maŋgoŋdok hinek nadilat u agaŋ nadilaŋ, eŋ koyone tilat u miŋgoŋ nadilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Siyotne goŋgomeŋdi pitpit tubune saŋiniŋne agaŋ dapmahinaka tilak. Eŋ yagit tibe namandatne haŋinda tilak. ");
INSERT INTO nop_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Notneye eŋ manemaneye, adi yadi wedene doktiŋa nu hatatneŋ yamaiŋgoŋ uŋoŋ bubuŋdok adi moŋ nadiiŋ. Kaŋ na’walaŋ naŋgat dikineye hinekdi maaŋ undugoŋ nu hatatneŋ uŋoŋ mu biiŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Me nulukumuŋ titiŋdok nadiiŋ adi yadi nohonedok yoŋa begep ibitehinamuŋa hakiiŋ. Eŋ me nehitubu-figita titiŋdok tiiŋ heki nehigoŋ nehitubu-kadaka titiŋdok yoiŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Iŋgoŋ, nu adi magitne kauleeŋ dabugoŋ magi kametnadi mu tugut, eŋ me bubuyeŋ dabugoŋ mede mu yogut. ");
INSERT INTO nop_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Nu adi me niŋ, mede tuwot mu nadiwek wendok tuwot. Unduŋ doktiŋa nu mede toboniŋ mu tubu-udaneyemgut. ");
INSERT INTO nop_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Iŋgoŋ nu adi Yahwe dutok hogok woomgamuŋa nadisugamulat. Wapum, du Bepaŋne, unduŋ doktiŋa du dagoŋ medene tubu-udanenambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Yonadi indiŋ tilat, “Du memikneye biyabune yofitet tinamuŋa nadifo mu tineŋ. Be malabumuŋ mintanambune nabuŋa biyabune foko tiŋa nadifo mu taneeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Maŋgoŋde, ya agaŋ mandifaidok naine muniniŋ tulune folofigita helemahelemaŋ nadilat. ");
INSERT INTO nop_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Nu yomne ganimbihila kadakaniŋ tugut wendoktiŋa bulaniŋgoŋ nadilat. ");
INSERT INTO nop_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Memikneye hogohogok adi yadi kedehi tiŋa fafaŋehi. Tiŋa me feedi memik hogok tinamfit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Nu titiŋ momooŋ tiyemilat iŋgoŋ oŋ, kibi toboniŋ adi titiŋ hogoli tinamiiŋ. Nu titiŋ momooŋ keleeŋ tilat, kaŋ adi wendoktiŋa nadiŋa memik tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Yahwe, du mu binabeŋ. Bepaŋne, du binabuŋa wooŋ kweetniŋ mu haleŋ. ");
INSERT INTO nop_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Yahwe, du kubugoŋdi nehitubu-lodaaŋ kotigoŋ nanagitaŋ. Du pilap hinek nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Nu indiŋ yogut, nu titiŋne tuluwaat hogohogok u nadiŋila tiluwaat. Tiyaugene medene yoyo gineŋ kadakaniŋ tibaatneŋ ala. Me hogohidi nu hatuwaatneŋ yamaiŋgoŋ uŋoŋ hatune yabuŋa nu mane teheŋa mede mu yoluwaat. ");
INSERT INTO nop_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Iŋgoŋ oŋ, nu mane teheŋa mede mu yogut, unduŋ tiŋa nemek momooŋ niŋ yodok iŋgoŋ mu yogut kaŋ welenedi kisaŋ hinek malabudaguk. ");
INSERT INTO nop_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Unduŋ tiŋa welemulap nadigut. Tiŋa undugoŋ, wendok uŋgoŋ hanadiliwene welene kisaŋ hinek figitaguk. Unduŋ tiŋa nu indiŋ yogut, ");
INSERT INTO nop_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Yahwe, kaipmuŋ hatidok guletne dedigoŋ hakiiŋ? Eŋ nai deniŋ hinek kumumbaat? U nanimbune hatihatine muniŋgoŋ-kabe u kedem nadidakalewit.” ");
INSERT INTO nop_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Nu’walaŋ hatihatine muniŋgoŋgoŋ hinek kamenamguŋ. Du dauge foloŋ nu’walaŋ naine woŋ adi nemek fiit nabugoŋ. Meeniŋ hogohogok hatihatinik adi me niŋdi maŋiŋ gineŋ munabut tubune mundi labuŋa pilap liwelak wendok tuwolit. ");
INSERT INTO nop_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Meeniŋ hogohogok hatihatinik adi bem woliniŋŋiŋdi kwetfoloŋ yooŋ tubumintaaŋ pilap liwelak wondok tuwolit. Adi bomboŋ fee moŋgotdok nadiŋa kwanaimiŋ tiiŋ. Iŋgoŋ kwanaimiŋ u hogok tifit tiiŋ. Meeniŋdi bomboŋ fee hinek moŋgola bopneiŋ, iŋgoŋ nediyeŋdi moŋgolaak u mu nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Iŋgoŋ oŋ, Wapum, nu i maŋgoŋdok woombit? Nu du kubugoŋ nadisugamuŋa du nehitubu-lodaweŋ yoŋa woomgamulat. ");
INSERT INTO nop_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Du nehitubu-lodaaŋ kotigoŋ nanagila kadakaniŋne hogohogok u tumolokutnambeŋ. Tiŋa me kaulehi nadiyembune nanimpekit mu tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Du da nemek u tinamuŋaŋ, unduŋ doktiŋa nu mede mu yoŋa mane tehep tiŋa halit. ");
INSERT INTO nop_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Du malabumuŋ nambune muniniŋ agaŋ kumumbe tugut. Unduŋ doktiŋa kotigoŋ mu nehitubu-kadakaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Du me niŋ nintoŋa yelaŋ e’ kadakaniŋŋiŋdok kibikoŋ tubu-udanemilaŋ. Unduŋ tiŋa dindilakidi haule sitomsitom tubune kadaka tilak unduŋ, adi nemenemek nadigalika tilak hogohogok u liliwenekulimindapmaŋ tilaŋ. Biyagoŋ hinek meeniŋ hogohogok hatihatinik adi mundidi manik gineŋ labuŋa pilap liwelak wendok tuwolit. ");
INSERT INTO nop_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Yahwe, yonadine nadiweŋ. Kutinadinedok magi kametnadi momooŋgoŋ tibeŋ. Nu du’walaŋkade kutinadi tibene magike tehep mu tibeŋ. Da-ku agaŋ nadilaŋ oŋ, nu adi dukut kwetfoloŋ iŋoŋ nai muniniŋ-kabe hinek hatilat. Nu adi mamane-papaneye nabugoŋ. Adi yadi kwetfoloŋ iŋoŋ nai muniŋgoŋgoŋ-kabe hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Du malabumuŋ kotigoŋ mu nambeŋ. Binabune kotigoŋ welemomooŋ nadiwit. Unduŋ tiŋa mindaŋkade kedem kumuŋa kwet i bikabudapmawaat. ");
INSERT INTO nop_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Nu Yahwedi nehitubu-lodawek yoŋa kulemaŋgoŋ hali woomgut, kaŋ adi magi kametnadi tiŋa yonadine nadinamguk. ");
INSERT INTO nop_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Adi nehitubu-lodaaŋ koŋ fuliŋmamaŋ kadaka hinehinek titiŋdok gineniŋ nehimaneune labugut. Tiŋa undugoŋ kwet dagidagik gineŋ fooŋ kwambundaaŋ yakut gineniŋ nehitamati kawade foloŋ napmeguk, kaŋ kotigoŋ yalikiliti-hinakaaŋ yaulat. ");
INSERT INTO nop_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Adi Bepaŋnik nintilooŋ niutumbadok kap kobuli niŋ mane foloŋ kameguk. U meeniŋ feedi nadiŋa gikiŋgoŋ tineeŋ, unduŋ tiŋa moŋ kaŋ Yahwe hogok nadisukilitimineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Me nediyeŋ Yahwe nadisukilitimilak adi Bepaŋdi kahaŋ timilak doktiŋa nadifo tilak. Tiŋa me undiniŋ adi me sigitiŋalo tiiŋ heki mu yehikelelak, eŋ bepaŋ yalayalaŋ mu yeniutumbalak. ");
INSERT INTO nop_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Yahwe Bepaŋne, du kwanai momohi fee hinek tiŋa nihitubu-lodaguŋ tiŋa inditok nadihebet momohi fee hinek tiulidokonimilaŋ. Wendi’walaŋ kunakunatŋiŋdi loloŋnit hinek. Meeniŋ niŋ dutok tuwolit kamekaaŋ yodok tuwot mokoŋ. Nu u yodakaleeŋ yohautaaŋ kahatŋiŋ yodapmaitdok tuwot mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Dumuŋ mebimebi gamdok be hegamdok adi moŋ nadilaŋ. Tiŋa kale kunilit dumuŋ heheŋ eŋ kadakaniŋ bibiŋdok siloŋ titiŋ wendok adi undugoŋ moŋ nadilaŋ. Iŋgoŋ magitnedi mede nadinadidok adi kedem kameeŋ tubutomguŋ. ");
INSERT INTO nop_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Unduŋ doktiŋa indiŋ yolat, “Nu agaŋ bulat. Du’walaŋ pepa bilibetnit gineŋ nutok mede indiŋ youkiŋ, ");
INSERT INTO nop_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","‘Bepaŋne, nu du’walaŋ nadinadige hinek takalidok nadilat, eŋ Yodoko Medegedi welene maaneŋ hatuwaak.’” ");
INSERT INTO nop_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Yahwe, nu metamgeye bophik gineŋ du titiŋge didimeniŋ tiŋa kotigoŋ ninigikuŋ wondok mede momooŋ u yohautagut. Wapum, du agaŋ nadilaŋ. Nu mane tehep mu tiŋa helemahelemaŋ yohautaluwaat. ");
INSERT INTO nop_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Du tutumba kwanai tuguŋ diniŋ mede u welene gineŋ kamehebi mu tiŋa hatat. Du mede yofafaŋeguŋ hogohogok u didimeŋgoŋ hinek keleeŋ kotigoŋ ninigitaŋ u agaŋ yohautagut. Eŋ du metam hogohogok welegedi yabukahile tiŋa titiŋ biyagoŋ hogok takalilaŋ, u maaŋ metam youtumba tinene buŋa bopneiŋneŋ kamehebi mu tilat. Mokoŋ. U maaŋ yohautalat. ");
INSERT INTO nop_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Yahwe, du helemahelemaŋ welegedi nabukahile hinek tilaŋ, u agaŋ nadilat. Unduŋ doktiŋa welekulemage u mu kahileweŋ. Du welegedi nehikahileeŋ medege biyagoŋ hogok takalilaŋ, titiŋ unduŋ tiŋa helemahelemaŋ nabudokolaŋ ");
INSERT INTO nop_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Malabumuŋ fee mintanamiiŋ u nu yokunalitdok tuwot mokoŋ. Titiŋ hogohi tugut wendi agaŋ nehikufula hinek tubune dau diwediwe momooŋgoŋ mu tilat. Kadakaniŋne fee hinek wendi kine hapmuŋ’walaŋ yokunatŋiŋ u kalakapme-dapmaŋ tilak. Unduŋ tubune saŋiniŋ lohilat. ");
INSERT INTO nop_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Yahwe, du kotigoŋ kedem nanagileŋ. Wapum, du pilap buŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Me nolidi nulukumuŋ tine tiiŋ. Ale du yehimoŋgo-foune nadigiyondaaŋ meka tineŋ. Me noli adi nu’walaŋ malabuhinedok nadifo tiiŋ. Ale du yehikele-kulune kotigoŋ uneŋ, kaŋ nadiyembune wohiyehinit mokit fofoŋhinit mintaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Meheki i nanimpekit tiiŋ, doktiŋa yehitubu-meka hinek tibeŋ, kaŋ adi nehi’walaŋ titiŋhik u kaŋ boho tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Iŋgoŋ metam du’walaŋkade wiiŋ heki adi yadi welemomooŋ kedem nadiŋa dutok nadifo tineŋ. Metam hogohogok da kotigoŋ yahaŋeguŋ kaŋ adi kwanaige tuguŋ u kaŋ nadigalika tiiŋ, adi yadi helemahelemaŋ indiŋ kedem yoyaneeŋ, “Yahwe adi loloŋnit hinek.” ");
INSERT INTO nop_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Bepaŋ, nu adi gweheyeŋ, tiŋa nu na nemek niŋ tibitdok tuwot mokoŋ. Iŋgoŋ oŋ, du nutok kaule mu tuguŋ. Unduŋ doktiŋa pilap hinek nu’walaŋkade iŋgoŋ beŋ. Bepaŋne, da kubugoŋdi nehitubu-lodaaŋ kotigoŋ nanagitaŋ. Unduŋ doktiŋa du nai tubukweheye adi mu tibeŋ, pilap hinek nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Me nediyeŋ me fofoŋhinitdok nadiyemiŋa yehitubu-lodalak, adi yadi kibibo adi’walaŋkade malabumuŋ mintamimbune Yahwedi kedem tubulodawaak. Unduŋ doktiŋa adi Bepaŋ’walaŋ kahaŋ kahileeŋ nadifo kedem tilak. ");
INSERT INTO nop_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Adi yadi Bepaŋdi kadokooŋ hatihatiŋiŋ tubukilitimimbune hatiluwaak. Unduŋ tiŋa kahaŋ timimbune kwelineŋ momooŋ hatibaak. Kaŋ Yahwedi memikŋiye tuwot mu biyabune tubukadakaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Me u yagit mintamiluwaak kaŋ Yahwedi kedem kadokoluwaak, tiŋa yagit gineniŋ tubukedebaaŋ kotigoŋ tubulodaune saŋiniŋnit tuluwaak. ");
INSERT INTO nop_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Kaŋ nu indiŋ yolat, “Yahwe, nu dauge gineŋ kadakaniŋ tugut. Iŋgoŋ du fiit siloŋ tobogoŋ tinamuŋa nehitubu-kedebaweŋ.” ");
INSERT INTO nop_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Iŋgoŋ memikneyedi nutok tiŋa welehik kadakaune indiŋ yoiŋ, “Detiŋa pilap kumumbune aditok nadikaule timiyanim aŋ.” ");
INSERT INTO nop_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Me noli buŋa nabuŋa mede hogok naniŋfit tiiŋ. Unduŋ tiŋa yagit hogoli dediŋ tilat u nadiŋa fowooŋ yagitne diniŋ kahat u tiŋa yotuwatuwale tiyawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Me nu nabukwihita tiiŋ heki adi yadi nutok mede nehi uŋgoŋ mede hamahamap foloŋ yonadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Adi indiŋ yoiŋ, “Nemek hogolidi agaŋ honeguk, doktiŋa kotigoŋ tuwot mu pilalaak. Adi kumuŋ tibaak.” ");
INSERT INTO nop_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Nu notne niŋ, adi na’walaŋ notne momooŋ hinehinek, adi na-gut nanaŋe noŋgoŋ nayamut. Iŋgoŋ adi maaŋ kayoŋ kwehene-tilooŋ nalidok tilak. ");
INSERT INTO nop_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Yahwe, du siloŋ tobogoŋ tinamuŋa nehitubu-kedebaweŋ kaŋ nubo memikneye kibibo titiŋ dediŋ tigiŋ u tubu-udaneyembit. ");
INSERT INTO nop_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Memik hekidi mu nehitubu-kadakaneŋ, woŋ adi biyagoŋ hinek du nabukahile tilaŋ, unduŋ nadiwit. ");
INSERT INTO nop_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Nu didimeŋgoŋ hatibe nabuguŋ, wendoktiŋa nabudokolaŋ. Unduŋ tiŋa nanagilune wooŋ hebeke gineŋ uŋgoŋ hatiŋa wooŋ hatibaat fafaŋeniŋ. ");
INSERT INTO nop_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Indi Isilaehi’walaŋ Bepaŋ, Yahwe wou nintilonim! Kaŋ tomboyoula undugoŋ tubune haliwooŋ halaak dapmandapmaŋnit mokit! U biyagoŋ! ");
INSERT INTO nop_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Kale moihi adi imedok nadiŋa kiyaneeŋ ime-kabe wodiiŋneŋ uŋoŋ wiiŋ. Bepaŋ, wondok tuwot nu maaŋ du gehitubu-dulaaŋ hatidok hinek nadilat. ");
INSERT INTO nop_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Bepaŋ, du adi Bepaŋ hatihatinit, unduŋ doktiŋa nu adi me mahik galiune imedok nadiiŋ unduŋ welenedi hinek gabukahile tilat. Bepaŋ, nai deniŋ hinek du’walaŋkade wooŋ ganiutumbawaat? ");
INSERT INTO nop_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Helemahelemaŋ meeniŋdi indiŋ naniiŋ, “Bepaŋge daŋ hatak?” Wendoktiŋa nu helemahelemaŋ makat hogok kotat. Kaŋ timiŋ be hadapmo adi daune meeniŋdi nanaŋene tilak. ");
INSERT INTO nop_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Nai momooŋ koom hatiyagumun u nadisuŋa welebulaniŋgoŋ nadilat. Nu koom metam fe-gut hatiŋa talikom tiyemiŋa yahaŋewene Bepaŋ’walaŋ yolineŋ wagiŋ. Uŋoŋ wooŋ tonadifooŋ Bepaŋ niutumbadok kap heki toyagumun. Nai uŋaniŋ adi indi hogohogok wanakaŋ bopneeŋ niutumbayagumun. ");
INSERT INTO nop_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Maŋgande tiŋa helemahelemaŋ welemulap tilat? Maŋgande tiŋa welenedi kulemaŋgoŋ mu hatak? Nu Bepaŋ hogok nadisukilitimiŋa woomimbene adi kedem nehitubu-lodawek. Adi Bepaŋne, doktiŋa adigoŋ nehitubu-lodalak. Wendoktiŋa nu wou kotigoŋ niutumbawit. ");
INSERT INTO nop_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Welebulaniŋgoŋdi kisaŋ hinek nehitiŋafolak, doktiŋa Baŋ, Bepaŋ, nu kotigoŋ du nadigamulat. Nu Jodankade eŋ Hemon kweboboeneŋ tiŋa Misa kweboboeneŋ, uŋoŋ hali kotigoŋ nadigamulat. ");
INSERT INTO nop_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Ime kawade hambeŋ gineŋ beemkulune imeŋgwaŋdi imeŋgwaŋ niŋ kutnilak. Hidige! Ime giyonda wapum tilak undugoŋ malabumuŋdi nehikufulalak! ");
INSERT INTO nop_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Iŋgoŋ oŋ, hadapmo Yahwedi welesiloŋ tinamulak u miŋgilaŋgoŋ kalat. Doktiŋa timiŋ niutumbaaŋ kap tomimbit, tiŋa Bepaŋ hatihati namulak ninadi tibit. ");
INSERT INTO nop_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Bepaŋ adi saŋiniŋ namulak, doktiŋa nu indiŋ nilat, “Du maŋgande nadikaule tinamulaŋ? Eŋ maŋgande binabune memik hekidi nehitiŋafoune nu welemulap tilat?” ");
INSERT INTO nop_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Helemahelemaŋ memik hekidi medehaki indiŋ naniiŋ, “Bepaŋge daŋ hatak?” Mede yoŋ adi bohom nabugoŋ foloone foloŋ youlune kumuŋdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Maŋgande tiŋa helemahelemaŋ welemulap tilat? Maŋgande tiŋa welenedi kulemaŋgoŋ mu hatak? Nu Bepaŋ hogok nadisukilitimiŋa woomimbene adi kedem nehitubu-lodawek. Adi Bepaŋne, doktiŋa adigoŋ nehitubu-lodalak. Wendoktiŋa adi wou kotigoŋ nintiloit. ");
INSERT INTO nop_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Bepaŋ, me sigilulum tigamiiŋ heki adi nehitifofoŋdok mede gineŋ napmeiŋ. Du nehitubu-lodaaŋ medehik hogohi u dobuliliwenekuyembune nu titiŋ didimeniŋ tilat u kaŋ nadineŋ. Adi yadi yalaŋ-me heki tiŋa titiŋhik adi didimehi mooŋ. Ale du nehitubu-lodaaŋ adi’walaŋ kohohik gineniŋ kotigoŋ nehikagiyaleŋ. ");
INSERT INTO nop_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Du kubugoŋdi nu’walaŋ Bepaŋne, unduŋ doktiŋa me hogohi yabu-momoŋ tiŋa du’walaŋkade wooŋ hebihatat. Kaŋ du maŋgoŋde nadikaule tinamulaŋ? Tiŋa undugoŋ, dediŋ doktiŋa memikneyedi nehitifooŋ welemulap kisaŋ hinek namiiŋ? ");
INSERT INTO nop_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Dagoŋ hinek medege biyagoŋ tiŋa nadinadige kameune buŋa talik nanindidimewek, kaŋ nu Saiyon, da’walaŋ kweboboege foloŋ didimeŋgoŋ wooŋ du yot hatilaŋneŋ uŋgoŋ wit. ");
INSERT INTO nop_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Nu nehitubu-lodalaŋ kaŋ nu welemomooŋ nadiŋa nadifo tilat, unduŋ doktiŋa nu Bepaŋ du’walaŋ altage gineŋ wit. Du Bepaŋne, unduŋ doktiŋa nu gita ula kap toŋa du wohoge hogok ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Dediŋ doktiŋa helemahelemaŋ welemulap hogok tilat? Dediŋ doktiŋa welene yout tilak? Nu Bepaŋ nadisumiŋa woomimbene adi kedem nehitubu-lodawek. Adi yadi Bepaŋne, wendoktiŋa negoŋ nehitubu-lodalak. Unduŋ doktiŋa nu wou kotigoŋ nintiloit. ");
INSERT INTO nop_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Bepaŋ, du koomkwaha mamani-papaniye hatigiŋ nai uŋaniŋ nemenemek saŋiniŋnit hinek titauguŋ wendiniŋ kahat tinimgiŋ u kobuk inde nadihinakayam. ");
INSERT INTO nop_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Du dagoŋ metam noli kwehineŋgoŋ hatigiŋ u yehikeledapmaguŋ, tiŋa mamani-papaniyedok kwet yemguŋ kaŋ adi uŋgoŋ hati-fafaŋegiŋ. Du metam noli yehitubu-kadakaguŋ, iŋgoŋ mamani-papaniye adi momooŋ hinek tiyembune metam fee mumuyeŋ ulihakagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Mamani-papaniyedi kwet u kahilegiŋ, u nehi mik tigiŋ doktiŋa mokoŋ, be mik gineŋ fafaŋeeŋ memikhiye widihi yehikelegiŋ u nehi’walaŋ saŋiniŋhik gineŋ mokoŋ. Da yabukahile hinek tuguŋ, unduŋ doktiŋa adigut haliŋa hautayemguŋ. Eŋ da’walaŋ saŋiniŋgedi yehitubu-lodaune mik gineŋ fafaŋegiŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Du Mapme tiŋa Bepaŋne. Dagoŋ yolaŋ kaŋ Jekop’walaŋ metamŋiyedi mik gineŋ fafaŋe tiŋa memikhiye widihi yehikeleiŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Da’walaŋ saŋiniŋge foloŋ memik heki u yehikelekukam. Tiŋa undugoŋ, du indigut hatilaŋ kaŋ indi memik tinimiiŋ heki u yehikeleyam. ");
INSERT INTO nop_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Nu tebene bomboŋ itnamiiŋ, iŋgoŋ wondi mik gineŋ tuwot mu nehitubu-lodaneŋ, unduŋ nadisulat. Miknoŋne hatnamulak, iŋgoŋ wondi maaŋ undugoŋ mik gineŋ tuwot mu nehitubu-lodawek. ");
INSERT INTO nop_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Da kubugoŋdi nihitubu-lodaune memikniyedi tuwot mu nihibefogiŋ. Unduŋ tiŋa meheki neeŋdi indi nibuŋa kwihitaŋgoŋ nadinimiiŋ heki u mik tiyemiŋa yehitubu-meka tuguŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Bepaŋ, indi helemahelemaŋ wohoge ganintiloyam. Tiŋa undugoŋ helemahelemaŋ welemomooŋ nadigamuŋa ganiutumba taneem. ");
INSERT INTO nop_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Iŋgoŋ nai indinde dediŋ doktiŋa sigilulum tiŋa binibulaŋ? Unduŋ tiŋa mikmeniye dut kotigoŋ mikde mu ulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Du unduŋ tubune indi memikniye u yabuŋa momone adi nemenemenik u nehitok moŋgokiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Du binibune dompa widihikumuŋ titiŋdok nabugoŋ tiyam. Tiŋa nihikelekulune kwetnik bikabuŋa metam noli’walaŋ lekiŋgoŋhik gineŋgineŋ wooŋ hatitawam. ");
INSERT INTO nop_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Du metamgeye tipilapilaye kwanai tuwaŋit mokit titiŋdok nadiŋa muneeŋ fofoŋnit-kabe hinek yobune metambop nolidi nihituwaaŋ ninigikiŋ. Kaŋ du muneeŋ wapum mu moŋgotaŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Du unduŋ tinimguŋ kaŋ metam yamaiŋgoŋ hatiiŋdi ninimpekit tiiŋ. Kaŋ metam nolidi maaŋ nibugege tiŋa mede mekahi niniiŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Du metam wele youyout tiyembune indi wotninik foloŋ mede mekahi yoiŋ. Tiŋa indi’walaŋkade nemek mintalak wendok gibitaŋ gegeiŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Meeniŋdi nanimpekit tiŋa mede kadakahi naniiŋ, eŋ nu memik heki yabulat kaŋ titiŋ kadakahi tubu-udanenamiiŋ. Unduŋ doktiŋa nu helemahelemaŋ nadiwe tuwot mu tubune meka tilat. ");
INSERT INTO nop_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Nemenemek u mintanimilak iŋgoŋ oŋ, Bepaŋ, indi dutok nadikaule mu tigamam, be indigut mede yofolok tuguŋ u kelekut mu tiyam. ");
INSERT INTO nop_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Indi du sigilulum mu tigamgumun, be du’walaŋ talikge u mu bikabugumun. ");
INSERT INTO nop_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Iŋgoŋ du kale moihi’walaŋ kwehineŋ nihitubu-kadakalaŋ. Tiŋa mambip gouyeniŋ hinek wendi nihitumutaŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Bepaŋnik, indi du nadikaule binek tigamuŋa, bepaŋ yalayalaŋ heki yeninadiyanim adi du agaŋ nadiliweŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Du me indi’walaŋ nadinadi hogohogok welenik maaneŋ hebihadapmalak u agaŋ miŋgoŋ nadidapmalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Indi du’walaŋ metam hatiyam doktiŋa nibukwihita tiŋa helemahelemaŋ nindihikumuŋ tiiŋ. Adi nibiiŋ kaŋ indi adi dompa widihikumuŋdok nabugoŋ undihi diweyaam. ");
INSERT INTO nop_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Wapum, pilat! Du damo maŋgoŋde deihataŋ? Pilataŋ! Du helemahelemaŋ sigilulum mu tinimiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Du maŋgoŋde namandake kufulahebi tiŋa wooŋ kweetniŋ hataŋ? Indi folofigita nadiyam be malabumuŋ hekiyam wendok adi nadikaule mu tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Indi kwetfoloŋ maaŋ fooŋ me dabahi nabugoŋ dahakam. ");
INSERT INTO nop_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Bepaŋ, du welesiloŋge doktiŋa pilali buŋa nihitubu-lodaaŋ kotigoŋ ninigileŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Mede momohi nadinadine gineŋ hakiiŋ. U kap foloŋ tubumintaaŋ me mapmedok youlimimbit. Mabelemne adi me kudi momohi youkiiŋ heki’walaŋ kundifiŋ (pen) nabugoŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Du adi me momooŋ, nebek niŋ du indiniŋ nemoŋ. Mage foloŋ adi kulema mede hogok mintalak. Bepaŋdi kahaŋ momooŋ tigamgukdi tigamulak. ");
INSERT INTO nop_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Du me mapme saŋiniŋgenit hinek. Eŋ tinahukutge adi beweniŋgoŋ hinek, tiŋa wohogegigitdi loloŋnit hatak. Ale miknoŋge tiŋa mik titiŋdok tiulidoko tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Du adi mapme uŋgoniŋ hinek, eŋ wohogegigitnit. Du helemahelemaŋ mede biyagoŋ eŋ titiŋ didimeniŋ yehi-ulihiluwaaŋ. Du adi mik fafaŋe tiŋa tubune me kadakahi adi dutok munta kisaŋ hinek tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Bohomge adi maŋiŋhinit wendi memik heki kisaŋ yedetomulak. Du me noli mik fafaŋe tiŋa widihiune adi wabiŋa du’walaŋ hebeke foloŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Bepaŋdi du mapme hatidok ganindapmaguk doktiŋa saŋiniŋge haliwooŋ halaak. Du metamgeye titiŋ didimeniŋ foloŋ hogok yabudokolaŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Du adi titiŋ didimeniŋdok adi nadiune utumba tilak, eŋ titiŋ hogohidok adi nadikwihita tilaŋ. Unduŋ doktiŋa Bepaŋ, da’walaŋ Bepaŋgedi mapme wapum hatidok ganindapmaaŋ nadifo diniŋ wahu munduŋdi gedegomguk wendi mapme nokeye yedegomgiŋ u yalakapme tilak. ");
INSERT INTO nop_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Dahidahige adi haguwo munduŋ momohi mel, alo tiŋa kasiya’walaŋ munduŋhikdi hogok kutak. Me mapme’walaŋ yoli adi tehindilendilene uŋgoniŋ uŋgoniŋ kale (elefan) maŋiŋdi tutumbagiŋ wendi tinahukulimiŋgiŋ, tiŋa du nadifo titiŋdok baiwagim tokudikudile tigambune nadifo tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Kaŋ me mapme heki’walaŋ wabihiye adi tam wohiyenit gut du yokeneŋ hakiiŋ. Kaŋ tam wapme adi kohoge didimeniŋneŋkade yatak. Adi yadi kwet wapum Ofili uŋoŋ gol tutumbagiŋ u tinahukula yatak. ");
INSERT INTO nop_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Tamkuya me mapme hemindok tilaŋ, du nu’walaŋ medene hogok baigoŋ nadihinakaweŋ. Du metamgeye tiŋa da’walaŋ magemageye hinek u kauleyem tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Mapme adi folonamandapge momooŋ doktiŋa gabuŋa nadigalika tibek. Adi yadi me wapumge, unduŋ doktiŋa adi’walaŋ medeŋiŋ tagimneluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Taiyahi metam adi siloŋ moŋgokamuŋa buneeŋ. Kaŋ me bomboŋ mohokhinitdi menot tigamunene bomboŋ mowodi buneŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Me mapme tamŋiŋ adi folonamandap momooŋ hogok, wendi ne’walaŋ yotmaaŋ gineŋ hatilak. Tiŋa tinahukutŋiŋ adi tawa golnit wendi tibinegiŋ u tinahukutak. ");
INSERT INTO nop_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Dahidahiŋiŋ woŋ adi kudikudinit. Tamkuya u agaŋ nagila me mapme’walaŋ wiiŋ. Kaŋ tamkuya noliŋiye adi maaŋ keletawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Adi welemomooŋ nadiŋa nadifooŋ me mapme yoli wapumneŋ foiŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Me mapme, du mihigeye fee mintaaŋ papageye diniŋ kayoŋkoŋ yabukahileneeŋ. Du saŋiniŋ yemiŋa yenindapmaune adi kwetkwet metam hogohogok yabudokoneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Nu wohoge yohautawene metam hogohogok kougoŋ mintaŋ hatineeŋ adi helemahelemaŋ du nadigamuneeŋ. Kaŋ wendoktiŋa metam hogohogok adi du wohoge ganintiloneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Bepaŋ adi hebiitnik kwet tiŋa adigoŋ helemahelemaŋ saŋiniŋ nimilak. Adi malabumuŋ mintanimbune nihitubu-lodadok nadiŋa nihitubu-dulaaŋ yamaiŋgoŋ hatilak. ");
INSERT INTO nop_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Unduŋ doktiŋa indi nemek niŋdok munta mu tiyaneem. Kenim tiŋa kwet kedem tawawek, be kweboboe kedem golooŋ maaŋ imeŋgwaŋ lekiŋgoŋ foneŋ. ");
INSERT INTO nop_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Kaŋ imedi undugoŋ kedem muhila gigilit toŋa faik labek, eŋ imeŋgwaŋdi undugoŋ kedem muhila wooŋ kweboboe youlune waliwali tibek. Indi nemek undihi mintaune wendoktiŋa munta mu titiŋdok. ");
INSERT INTO nop_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Bepaŋ yolikweli uŋgoniŋ gineŋ ime wapum niŋ hatak wondiniŋ ime dawi fee labuŋa woditaune Wapum Loloŋnit wahiŋ hatilak adi’walaŋ yolikwelineŋ nadifo mintalak. ");
INSERT INTO nop_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Bepaŋ adi yokwet maaneŋ uŋoŋ hatilak, doktiŋa yokwet u tuwot mu kadakawaak. Bepaŋdi helehelede tubulodawaak. ");
INSERT INTO nop_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Kwetkwet metam hogohogok adi pilali mindobu tiŋa mapmehiye bunit kadakadapmaiŋ. Kaŋ Bepaŋdi gibita kutifiyeune kwet-ku wabiŋa ime nabugoŋ yagelelak. ");
INSERT INTO nop_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yahwe, Saŋiniŋ Molom adi indigut hatilak. Eŋ Jekop’walaŋ Bepaŋŋiŋ adi indi’walaŋ hebiitnik kwet. ");
INSERT INTO nop_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Pilap buneŋ! Buŋa Yahwedi kwanai tuguk i yabuneŋ. Biyagoŋ kuyoŋ, hidi buŋa nemenemek kwetfoloŋ saŋiniŋnit tilak u yabuneŋ. ");
INSERT INTO nop_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Adi kwetkwet mik hatak u tubukulemalak. Unduŋ tubune wooŋ kwet dikineŋ dapmalak. Tiŋa tebe miŋ wobugolokut tiŋa bohom yaligololak. Eŋ kweletalak kudup kulaheune daiŋ. ");
INSERT INTO nop_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Adi indiŋ yolak, “Hidi mik wabiŋa indiŋ nadiut! Bepaŋ folooŋ hinek hatilat u nadidakaleneŋ. Biyagoŋ kuyoŋ, kwetkwet adi nu kubugoŋdi loloŋnit hatilat, kaŋ metam hogohogok adi nu’walaŋ hebetne gineŋ hatidapmaiŋ.” ");
INSERT INTO nop_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yahwe, Saŋiniŋ Molom adi indigut hatilak. Eŋ Jekop’walaŋ Bepaŋŋiŋ adi indi’walaŋ hebiit kwetnik. ");
INSERT INTO nop_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Metam hogohogok, hidi nadifo tiŋa kohopapa utneŋ! Hidi nadifo tiŋa kap wapum toŋa Bepaŋ nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Indi Yahwe Loloŋnitdok munta tiŋa gikiŋgoŋ timinim. Adi Mapme Loloŋnitdi metam hogohogok kwetfoloŋ hatiiŋ u yabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Adi metam noli hogohogok yanagibefodapmaaŋ indi’walaŋ hebetnineŋ yapmeune indi yabudokoyam. ");
INSERT INTO nop_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Bepaŋ negoŋ inditok yoŋa kwet i kahileeŋ inditok gigit yodapmaaŋ nimguk. Bepaŋdi Jekop’walaŋ yalakiŋiye inditok welesiloŋ tinimguk, doktiŋa indi kwetnik yendok nadifo tiyaneem. ");
INSERT INTO nop_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Bepaŋ kunum foloŋ loguk. Yahwedi loguk nai uŋaniŋ memetam adi nadifo tiŋa kakaliŋa bai maaŋ fedikiŋ. ");
INSERT INTO nop_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Indi Bepaŋ nintilooŋ kap tominim, indi mapmenik nintilooŋ kap tominim. ");
INSERT INTO nop_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Bepaŋdi mapme ilaŋa kwet wapum i hatak i kaulidokolak. Wendoktiŋa indi kap toŋa nintilonim. ");
INSERT INTO nop_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Bepaŋ adi mapme ilaŋa metambop hogohogok yabudokolak. Tiŋa undugoŋ Bepaŋ adi mapme kumopopŋiŋ foloŋ ilune tuwot tilak. ");
INSERT INTO nop_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Metambop hatiiŋ’walaŋ talitimeŋ heki adi metam Abalaham’walaŋ Bepaŋ keleiŋ heki dut bopneiŋ. Mikme heki’walaŋ saŋiniŋhik u Bepaŋ’walaŋ kohoŋ gineŋ hatak. Adi yadi mapme loloŋnit. ");
INSERT INTO nop_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Yahwe adi wougigitnit. Unduŋ doktiŋa indi Bepaŋ’walaŋ kweboboe uŋgoniŋ foloŋ lonim, looŋ wooŋ adi’walaŋ yolikweli wapumneŋ fooŋ wou niŋatilonene foloniŋ hinek looŋ halek. ");
INSERT INTO nop_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Bepaŋ’walaŋ kweboboe woŋ adi momooŋ hinek, tiŋa kweheyeniŋ gwaŋ lohinakaaŋ yatak. Metam hogohogok kwetfoloŋ hatiiŋ adi yadi kweboboe Saiyondok nadigalika tiiŋ. Kaŋ kweboboe u yadi mapme loloŋnit’walaŋ yot mebi. ");
INSERT INTO nop_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Bepaŋdi yokwet wapum maaneŋ uŋoŋ hali metam mik nai gineŋ yehitubu-lodalak, unduŋ doktiŋa metamdi adigut galiŋa momooŋ hinek hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Koom mapme hekidi Saiyon mik timine wanakaŋ buŋa bopneeŋ yokwet wapum u tubudulagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Iŋgoŋ yokwet wapum u kaŋ boho tigiŋ. Unduŋ tiŋa muntaaŋ momoŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Adi hehele gibitaŋ tigiŋ, unduŋ tiŋa tamwoidi wapmihi yahaŋenene folofigita nadiiŋ unduŋ folofigita kisaŋ hinek nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Bepaŋdi nadiune sububa wapum mele labulabuneŋkade fedila buŋa yokwet wapum Tasishi’walaŋ muwage heki yehitubu-kadaka tilak. ");
INSERT INTO nop_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Indi koom Bepaŋdi nemek noli tuguk wondiniŋ kahat nadigumun, kaŋ kobuk i kotigoŋ undugoŋ tubune kayam. Indi Yahwe’walaŋ yokwet wapum gineŋ hakam. Bepaŋnik adi saŋiniŋ hogohogok diniŋ Bepaŋ, doktiŋa nemek u tubune kayam. Bepaŋ adi yokwetŋiŋ wapum u tubufafaŋeune haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Bepaŋ, indi adi du’walaŋ Siloŋyotge maaneŋ haliŋa du helemahelemaŋ welegedi dapmadapmaŋnit mokit nibukahilelaŋ u hanadi-tuwatuwaleyam. ");
INSERT INTO nop_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Kwetkwet metam hogohogok adi wohoge ganintiloiŋ. Metam hogohogok kwetkwet hatitawiiŋ adi yadi wohogegigit doktiŋa nadifo tiiŋ. Du adi metam hogohogok titiŋ didimeniŋ gineŋ hogok yabudokolaŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Wendoktiŋa metam hogohogok Saiyon kweboboe foloŋ hatiiŋ adi nadifo kedem tineŋ. Du metam hogohogok titiŋhik didimeŋgoŋ hinek yabunadiŋa mede yodapmalaŋ. Unduŋ doktiŋa Judahi’walaŋ yokwet wapuhi ila wiiŋneŋ metam hatiiŋ hogohogok adi nadifo kedem tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Hidi Saiyon kweboboe foloŋ yauneŋ, yauŋa yokwet wapum wondiniŋ gimbahaŋ fafaŋeniŋ u kelemadiŋa gimbahaŋ ki foloŋ mik fok yot fafaŋehi tigiŋ u kunatneŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Hidi Saiyon’walaŋ gimbahaŋŋiŋ kawadedi tutumbagiŋ u momooŋgoŋ kaŋ nadineŋ, tiŋa yoli fafaŋehi u maaŋ yabunadineŋ. Ala meeniŋ kougoŋ mintaneeŋ u kedem yenimbune nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Indiŋ kedem yenineeŋ, “Bepaŋ nibudoko tilak yoŋ adi Bepaŋnik dapmandapmaŋnit mokit hatilak. Adi helemahelemaŋ talitimeŋ tinimiŋa talik ninindidimeluwaak.” ");
INSERT INTO nop_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Metam hogohogok, hidi i nadineŋ. Metam hogohogok kwetfoloŋ hatiiŋ, hidi magi kametnadi baigoŋ hinek tiŋa medene nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Me wohiyehinit tiŋa me wohiyehinit mokit, be me muneeŋ bomboŋhinit tiŋa me fiyewakahi, hidi mede i momooŋgoŋ hinek nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Nadinadi fuliŋgoŋ hamdok mede momooŋ hanimbit. ");
INSERT INTO nop_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Nu timeŋ yoyout mede yobit. Unduŋ tiŋa gita ule mede tobune yoyout mede diniŋ mebi hanimbit. ");
INSERT INTO nop_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","6","Meeniŋdi indiŋ nadiiŋ, muneeŋ bomboŋdi saŋiniŋ nimbek, unduŋ nadiŋa bomboŋhik mohok wendok mede yohautaiŋ. Meheki wendi nehitubu-kadakanene tiiŋ, iŋgoŋ nu me heki wendok munta tuwot mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Indi a nadiyam, nebek niŋ nene uŋgoŋ muneeŋdi tuwot mu tuwawek. Be hatihatiŋiŋ tuwawe nadiŋa Bepaŋdok muneeŋ tuwot mu mimbek. Mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","9","Maŋgande, me kotigoŋ yehituwaaŋ yahaŋeyahaŋe diniŋ tuwaŋiŋ adi loloŋnit hinek. Meeniŋdi Bepaŋ tuwaune nadiyembune kumuŋ mu tiŋa kaipmuŋ hatiŋa wooŋ hatidok, talik u nemu hatak. ");
INSERT INTO nop_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Indi i kanim, me nadinadihinit adi maaŋ kumiiŋ, eŋ me nadinadihinit mokit tiŋa me bubuyehi adi maaŋ undugoŋ kumiiŋ. Meheki woŋ adi muneeŋ bomboŋhik biyabudapmaaŋ uune me nolidi beneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Koom adi meheki u kwehiknit, iŋgoŋ nai indinde adi meyotdi yohikwehik fafaŋeniŋ tubune hatiŋa wooŋ hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Wotninikgigitdi kumuliwe titiŋdok tuwot mu kamehemimbaak. Indi adi kale hekidi kumuliweiŋ undugoŋ kumuliweneem. ");
INSERT INTO nop_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Nemek undiniŋ adi me nehitok hogok nadiiŋ be nemenemekhik iyemiiŋ foloŋ ulodikilitiŋa hatiiŋ heki’walaŋkade mintayembaak. Me undihi adi nadinadihinit mokit. Me nemenemek moŋgokiiŋ heki adi yadi nadifo hogok tifit tiiŋ, adi maaŋ undugoŋ kumuneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Bepaŋdi me heki u dompa hekidi kumiiŋ, unduŋ kumuŋa me agaŋ kumuŋa ugiŋ heki’walaŋ yohikwehineŋ uuŋdok yodapmaguk. Kaŋ Kumuŋdi yabudoko me dabugoŋ yabudokowaak. Yohik momohi biyabuneeŋ, nai uŋaniŋ foloohik bitaka tibaak, kaŋ me kumuhi yohikwehineŋ hatneeŋ, kaŋ me didimehidi nemek u mintayemguk u kaŋ nadiŋa fafaŋe tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Iŋgoŋ Bepaŋdi kotigoŋ nanagilune me kumuhi’walaŋ yokwet diniŋ saŋiniŋdi tuwot mu nohonekiliti halaak. ");
INSERT INTO nop_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Nebek niŋdi muneeŋ bomboŋ mohoknit tiŋa, yoli wapum maaŋ nemenemekŋiŋ momomomooŋ yehitubumintaaŋ tubune, du wendoktiŋa nadibedi mu tuluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Da-ku a nadilaŋ, adi kougoŋ kumumbaak nai uŋaniŋ nemek-kabe nemu tiŋa waak! ");
INSERT INTO nop_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Kaipmuŋ hatiŋila nai uŋaniŋ nemenemek wendok nadifo tuluguk. Adi kwanai fafaŋeŋ tiŋa nemenemek fee moŋgolune mehekidi indiŋ niyagiŋ, “Me woŋ adi me momooŋ.” ");
INSERT INTO nop_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Iŋgoŋ oŋ, adi yadi kumuŋa mamaŋ-papaŋ heki dut mele hautaŋiŋ mu kaiŋneŋ uŋoŋ hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Wotninikgigitdi kumuŋ titiŋdok tuwot mu kamehenimbaak. Indi adi kale hekidi kumiiŋ undugoŋ kumuneem. ");
INSERT INTO nop_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Bepaŋ adi saŋiniŋ molom, adigoŋ Yahwe, doktiŋa indiŋ yoŋa kwet wapum i hatakneŋ metam hatiiŋ hogohogok, mele labulabuneŋkade tububihila wooŋ mele fofoŋ tilakneŋkade kutiyehimanelak. ");
INSERT INTO nop_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Bepaŋ adi Saiyon uŋoŋ yokwet momooŋ tiŋa uŋgoniŋ hinek gineŋ uŋoŋ hatilak. Kaŋ hautaŋiŋdi miŋgilaŋgoŋ mintalak. ");
INSERT INTO nop_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Bepaŋnik adi agaŋ bulak, iŋgoŋ adi kabup mu bulak. Mokoŋ. Adi yadi kudup nemenemek dadapmaŋ titiŋdok wendi talikom timilak, eŋ fifiŋgobutdi tumulune bulak. ");
INSERT INTO nop_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Adi metamŋiye’walaŋ titiŋhik diniŋ mebi didimeŋgoŋ kanadi tilak u sigiyakadi tidemeek yoŋa kunum gut kwet kutiyenilak. ");
INSERT INTO nop_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Bepaŋdi indiŋ yolak, “Metamneye hidi nutok dumuŋ hemundumunduŋe tinamuŋa nukut kifolok tugumun. Hidi buŋa nukut bopneneŋ.” ");
INSERT INTO nop_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Kunumdi indiŋ yohautalak, “Bepaŋ adi didimeniŋ hinek, tiŋa ne kubugoŋdi mede nadinadi kwanai tilak.” ");
INSERT INTO nop_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Bepaŋdi indiŋ yolak, “Metamneye, hidi indiŋ nadineŋ. Isilaehi hidi mede foloŋ hapmewit, nu kubugoŋdi Bepaŋ hinek tiŋa undugoŋ hidi’walaŋ Bepaŋhik. ");
INSERT INTO nop_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Nu adi hidi dumuŋ heiŋ be kale kudup foloŋ hemundumunduŋe tiiŋ wendoktiŋa mu hanintolat. ");
INSERT INTO nop_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Nu adi hidi’walaŋ gimbahaŋhik gineŋ makau maaniŋ be meme maaniŋ mu yanagitdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Kale moihi behepneŋ hatiiŋ be makau kweboboe hogohogok foloŋ hatiiŋ adi yadi na’walaŋ hogohogok. ");
INSERT INTO nop_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Eŋ bagi moihi be kale tiŋa kaleŋgiŋgiŋ yupaneŋ hatiiŋ hogohogok u maaŋ na’walaŋ hogok. ");
INSERT INTO nop_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","“Kwet wapum yendok foloŋ nemenemek hakiiŋ hogohogok woŋ adi na’walaŋ hogok. Unduŋ doktiŋa nu map nadiŋa hidi tuwot mu haninadiwit. ");
INSERT INTO nop_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Nu makau gomŋiŋ maaŋbe nalat? Be meme naŋgatŋiŋ maaŋbe silotnalat? U mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Hidi naniutumba tineŋ, kaŋ wendi siloŋ tinamiiŋ tibek. Tiŋa nemek siloŋ titiŋdok yofafaŋegiŋ hogohogok u Bepaŋ loloŋnit nutok hogok siloŋ tinamneŋ. ");
INSERT INTO nop_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Hidi unduŋ tineŋ, ala malabumuŋ mintahambune kaŋ nu kedem kutinaniyaneeŋ. Kaŋ nu kedem hehitubu-lodaluwaat, kaŋ hidi nu wotnene nanintiloneeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Iŋgoŋ Bepaŋdi me kadakahidok adi indiŋ yenilak, “Hidi dediŋ doktiŋa nu’walaŋ Yodoko Medene u folooŋbo yooŋ kilikibo yooŋ tiiŋ? Tiŋa undugoŋ, dediŋ doktiŋa folofolokne diniŋ mede hogok yofit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Hidi adi nu hehitubu-didimedok moŋ yoŋa helemahelemaŋ mane mede ukiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Hidi adi kubome heki yabuŋa adigut menot momooŋ tiiŋ. Tiŋa metam kikabi tiiŋ hekidut yauŋa kefifile tiyawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Hidi adi helemahelemaŋ medehaki tiŋa mede yalaŋ yoiŋ. ");
INSERT INTO nop_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Tiŋa hidi dahiye be kwayahiye yenimunumunuŋe tiŋa yalaŋ yoŋa yeniŋkadaka tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Hidi unduŋ tiiŋ kaŋ nu mede nemu yolat, doktiŋa nu adi hide nabugoŋ unduŋ yoŋa nadiiŋ. Iŋgoŋ mokoŋ hinek. Nu adi kamiŋ namandahik foloŋgoŋ hanintoŋa hanindidimelat. ");
INSERT INTO nop_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Metam sigilulum tinamiiŋ, hidi mede i nadihinaka hinek tineŋ. Hidi undiniŋ hogok hati tineeŋ adi hehitubu-kadaka tibaat, kaŋ nebek niŋdi kotigoŋ tuwot mu hanagilaak. ");
INSERT INTO nop_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Me nediyeŋ naniutumba tilak adi yadi siloŋ tinamulak, tiŋa wotnene nanintilolak. Ale nu adi metam nediyeŋ medene tagimneiŋ heki adi hogok kotigoŋ yanagilaat.” ");
INSERT INTO nop_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Bepaŋ, du welegedi hinek nabukahilelaŋ, unduŋ doktiŋa siloŋ tobogoŋ tinambeŋ. Du’walaŋ siloŋ tobogoŋ adi wapum hinek hakamulak, wendoktiŋa kadakaniŋne hogohogok wanakaŋ tumolokutnambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Tiŋa nehiyoutewalandaune titiŋ hogohidi nu foloŋ mu hakaneeŋ. Kadakaniŋ u beyakutnambune waliniŋ mintait. ");
INSERT INTO nop_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Nu kadakaniŋnedok kaule mu tilat. Nu maŋgoŋ kadakaniŋ tugut u uŋgoŋ hatinadilat. ");
INSERT INTO nop_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Dauge foloŋ kadakaniŋ tugut, u du dauge foloŋgoŋ tugut, tiŋa welege tubukadakagut. Unduŋ doktiŋa du titiŋ didimeniŋ tiŋa mede gineŋ napmeeŋ kadakaniŋnedok kibikoŋ tubu-udanenamulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Du agaŋ nadilaŋ, maŋ weleŋ gineŋ tububihila kadakaniŋnit mintagut. Tiŋa maŋdi nanagikuk u kadakaniŋ bumbut nanagikuk. ");
INSERT INTO nop_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Nu welenedi hinek du gehikeledok nadinamulaŋ. Unduŋ doktiŋa nadinadige momooŋ fuliŋ u nanindidimeweŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Du kadakaniŋne tumolokulune waliniŋ mintait. Nehiyoutelune haule fafau youtetne diweiŋ u kalakapme tiŋa waliniŋ hinek mintawit. ");
INSERT INTO nop_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Nehitubu-lodaune kotigoŋ welenadifo tubumintait. Biyagoŋ hinek kadakaniŋnedok kibikoŋ agaŋ nehitifofoŋ hinek tiŋa tubu-udanenamuŋaŋ. Kaŋ yoŋ adi agaŋ kotigoŋ welenadifo tibe nadilat. ");
INSERT INTO nop_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Unduŋ doktiŋa du kadakaniŋne hogohogok tumolokutnambeŋ, tiŋa kadakaniŋne u kotigoŋ mu yabeŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Bepaŋ, du welene gitipmuŋ waliniŋ tutumbaweŋ. Tiŋa titiŋ momooŋ diniŋ munabut u nehitubu-kaikaune du hogok gehikelewit. ");
INSERT INTO nop_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Du hebeke gineniŋ mu nehikelekuleŋ, tiŋa Munabulige uŋgoniŋ mu nolomtibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Du koom kadakaniŋ gineniŋ nehikibidali nanagikuŋ kaŋ nadifo tugut, nadifo u kotigoŋ tubukaikanambeŋ. Eŋ medege takalidok weleyouyout tinambeŋ. Tiŋa nehitubu-kilitibune undugoŋ tiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Unduŋ tiŋale metam kadakaniŋ tiiŋ heki u du’walaŋ titiŋ momooŋ u yeniŋtitiŋenewe kaneeŋ. U kaŋ kotigoŋ udaneeŋ du’walaŋkade buneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Bepaŋ, du kubugoŋdi kotigoŋ nanagitaŋ, wendoktiŋa siloŋ tobogoŋ tinamuŋa mu nulukumumbeŋ. Unduŋ tibeŋ kaŋ nu titiŋ didimeniŋ tilaŋ wendok yohautaaŋ kap fee tobit. ");
INSERT INTO nop_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Wapum, du mamne taŋakiyeune manedi didimeŋgoŋ yohautaaŋ wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Du kale moŋgola buŋa dumuŋ hemundumunduŋe tigamdok u moŋ nadilaŋ. Nu kale ula kudup foloŋ hewene dadapmaŋ tibek iŋgoŋ du wendok maaŋ nadifo mu tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Unduŋ doktiŋa Bepaŋ, nu natok nadiwene fofoŋnit tubune du’walaŋ hebeke foloŋ welemulap tilat. Wondi siloŋ tigamulat. Nu agaŋ nadilat, du adi me nediyeŋ kadakaniŋŋiŋdok tiŋa malabumuŋ nadiŋa netok nadiune fofoŋnit tilak, aditok adi sigilulum mu timilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","O Bepaŋ, da nadilaŋ unduŋ tiŋa Saiyonhi metamdok titiŋ momooŋ tiyembeŋ. Tiŋa Jelusalem diniŋ gimbahaŋ u kotigoŋ tutumbayembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Kaŋ du nai uŋaniŋ siloŋ didimehi eŋ momohi tigamneem wendok nadiune utumba tibaak. Indi kale kudupdi dadapmandok u maaŋ hegamneem. Eŋ makau maaniŋ u altage foloŋ dumuŋ hemundumunduŋe tigamneem. ");
INSERT INTO nop_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Me saŋiniŋnit, du datok nadiune loune Bepaŋ’walaŋ metamŋiyedok titiŋ kadakaniŋ tiyemguŋ wendok-kube mede wapum toŋa ya-nadifolaŋ? Adi yadi Bepaŋdi helemahelemaŋ siloŋ tobogoŋ tiyemiŋa yabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Du adi yalaŋ-me, medege adi tahak mikit hinekdi me niŋ dobulaŋ nabugoŋ. Helemahelemaŋ adi metam noli yehitubu-kadakadok hogok nadilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Du adi titiŋ momooŋdok mu nadiŋa titiŋ hogolidok hogok nadilaŋ. Tiŋa undugoŋ mede biyagoŋ yodok mu nadiŋa mede yalaŋ yodok hogok nadilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Du adi yalaŋ-me hinek, unduŋ doktiŋa me yehitubu-kadaka titiŋdok mede hogok yodok nadilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Unduŋ doktiŋa Bepaŋdi gehitubu-kadakadapmaŋ tibaak. Tiŋa iit hatihatige gineniŋ gehitamabeemkulune waaŋ. Unduŋ tiŋa gehitubu-liwedapmaune du kwetfoloŋ kotigoŋ tuwot mu hatibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Me didimehidi du’walaŋkade nemek u mintaune kaŋ munta tineeŋ. Tiŋa gabugegeeŋ indiŋ yoneeŋ, ");
INSERT INTO nop_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“I kaneŋ, me i Bepaŋdi tubulodaaŋ saŋiniŋ mu mimiŋdok nadiguk. Adi yadi nadisuŋiŋ fafaŋeniŋ adi muneeŋ bomboŋ gineŋ hakuk, tiŋa titiŋ hogolidi tubulodaune kedem hatidok unduŋ nadiguk.” ");
INSERT INTO nop_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Iŋgoŋ nu adi undiniŋ mooŋ. Nu yadi bem olif nabugoŋ Bepaŋ yolineŋ yali duhuduhunit tilat. Nu Bepaŋdi helemahelemaŋ weleŋdi hinek nabukahile tilak u agaŋ nadisukilitilat. ");
INSERT INTO nop_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Bepaŋ, du helemahelemaŋ nehitubu-lodalaŋ doktiŋa nu du ganiutumbaluwaat, dapmadapmaŋnit mokit. Tiŋa metamgeye namandahik foloŋ wohoge ganintilooŋ indiŋ yobit, “Bepaŋ adi titiŋ momooŋ hinek tilak.” ");
INSERT INTO nop_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Me nadinadihinit mokit kaulehi, adi nehi welehik gineŋ indiŋ yoiŋ, “Bepaŋ nemu hatilak.” Me undihi adi me hogohi. Adi yadi titiŋhik kadakahi madimadikeŋgoŋ tiiŋ. Nebek niŋdi titiŋ momooŋ nemu tilak. ");
INSERT INTO nop_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Bepaŋ adi kunum foloŋ hali diweune foune metam nadinadi fuliŋgoŋhinitdi adi’walaŋ mebiŋiŋ nadidok gigine nenobu taneŋ, unduŋ yoŋa yabunadi tilak. ");
INSERT INTO nop_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Iŋgoŋ mokoŋ. Metam hogohogok wanakaŋ talik fofooŋ u bikabudapmaŋ tiiŋ. Adi’walaaniŋ kubugoŋ-kabe niŋdi titiŋ didimeniŋ-kabe nemu tilak. Mokoŋ hinek. Adi hogohogok kadakaniŋ gineŋ fodapmaaŋ me kadakahi hogok mintadapmaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Bepaŋdi indiŋ yolak, “Me kadakaniŋ tiiŋ heki yoŋ adi nadinadihinit mokit bidak? Adi yadi metamneye nadibedinit mokit hogok yehitubu-kadakafit tiiŋ. Tiŋa naninadi-kabe nemu tiiŋ.” ");
INSERT INTO nop_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Unduŋ doktiŋa Bepaŋdi memik tiyemiŋa yehikelekulaak. Unduŋ tubu adi hehele tiŋa munta kisaŋ hinek tineeŋ. Bepaŋdi widihipupuheneune nebek niŋdi tuwot mu yehiwenefulaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Nu adi indiŋ hinek nadilat. Bepaŋdi Saiyonneniŋ me niŋ kameune buŋa Isilaehi metam kotigoŋ yanagilaak. Bepaŋdi metamŋiye yehitubu-lodaaŋ kotigoŋ yanagilune momooŋ hatineeŋ. Biyagoŋ hinek, Jekop’walaŋ yalakiŋiye adi welemomooŋ nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Bepaŋ, da’walaŋ saŋiniŋge gineŋ me hogohi’walaŋ kohohik gineniŋ kotigoŋ nanagit hinek tibeŋ! Da’walaŋ saŋiniŋge loloŋnit wendi nehitubu-lodaaŋ nu’walaŋ mede u didimeŋgoŋ yodapmaune folofoloknit mokit halit. ");
INSERT INTO nop_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Bepaŋ, du yonadine nadiweŋ, tiŋa magi kametnadi tiŋa medene nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Me gifoko heki agaŋ busuwaaŋ nunutdok tiiŋ. Meheki woŋ adi metam noli yehitubu-kadakafit tiiŋdi nu nulukumune tiiŋ. Meheki wendi Bepaŋdok nadiune adi nemek fiit nabugoŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Iŋgoŋ nu adi Bepaŋ negoŋ nehitubu-lodalak. Biyagoŋ hinek, Wapum negoŋ nabudokoune kedem hatilat. ");
INSERT INTO nop_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Bepaŋdi memikneyedok malabumuŋ kedem yembek. Adi kudi kadakaniŋ tinamgiŋ, kudi undigoŋ hinek Bepaŋdi kibibo nehitok tubu-udaneeŋ tiyembek. Bepaŋ, du mu binabulaŋ, du da memik heki u kedem yehitubu-liweweŋ. ");
INSERT INTO nop_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Yahwe, nu adi siloŋ tigamdok nadigalika hinek tilat. Du adi momooŋ hinek, doktiŋa nu ganiutumba hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Da nehitubu-lodaguŋ kaŋ malabumuŋ hogohogok mintanamgiŋ wondi mu nehitifogiŋ. Kaŋ du memikneye yehitubu-kadakaguŋ u kagut. ");
INSERT INTO nop_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Bepaŋ, du yonadine u nadi hinek tibeŋ! Katibulabulaye tibene sigilulum mu tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Nadibedinedi nehitubu-kadaka tibene tilak, doktiŋa du yonadine momooŋgoŋ nadiŋa medene tubu-udaneweŋ. ");
INSERT INTO nop_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Memik heki adi nehitubu-kadaka titiŋdok mede fafaŋeŋgoŋ toiŋ. Me kadakahi wendi nehitifofoŋ tiiŋ doktiŋa welemulap kisaŋ hinek nadilat. Adi malabumuŋ gibitaŋ namiiŋ, tiŋa kwihikwihileŋgoŋ tiŋila memik kisaŋgoŋ hinek tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Kaŋ nu aditok munta kisaŋ hinek tiyemiŋa, kumuŋ tibitneŋ yoŋa hehele tilat. Kaŋ wendi welene tubumalabuda hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Unduŋ tiŋa munta kisaŋ tibene foloone heheledapmaŋ tilak. Kaŋ muntadi nehitifohinaka tilak. ");
INSERT INTO nop_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Kaŋ nu indiŋ yolat, “Nu adi butigili hekidi papalihinit hatiiŋ, deti undugoŋ tilit yoŋa nadilat. Unduŋ tiŋa woleeŋ wooŋ kwet niŋ tubumintaaŋ uŋgoŋ ila hali hakule titiŋdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nu adi kweetniŋ hinek woleeŋ wooŋ kwet fiileŋ uŋgoŋ hatibaat. ");
INSERT INTO nop_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Nu pilap hinek woleeŋ wooŋ hebihatdok kwet neeŋ tubumintait, tiŋa fifiŋgobut dut gwi muŋkulap’walaŋ naihik foloŋ kedem kabup hebihatibaat.” ");
INSERT INTO nop_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Meeniŋ yokwet wapum maaneŋ mik kaka tiyaune yabulat. Unduŋ doktiŋa, Wapum, du medehik kedem tubugiyondaaŋ yehitubu-liwedapmaŋ tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Hadapmo be timiŋ adi looŋ yokwet wapum wendiniŋ gimbahaŋ foloniŋ hati yawiiŋ. Eŋ yokwet wapumneŋ uŋoŋ metamdi yom eŋ malabumuŋ fee tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Yokwet wapum maaneŋ uŋoŋ me nolidi pilali metam yehitubu-kadakaaŋ nemenemek noli maaŋ yehitubu-kadakatawiiŋ. Tiŋa talik gagayeŋ be bopkwetneŋ meeniŋ noli yeniyehimoŋgofoiŋ, unduŋ tiŋa nemenemekhik kuboneyemdok tikamanda maaŋ tiyemiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Memik niŋdi binek nanimpekit tibetik uyadi welemulap nadiŋila fiit hatibetit. Eŋ memik niŋdi naniŋfoko tiŋa gigine tubune kaŋ woŋ adi momoŋ tiŋa wooŋ niŋkade hebihatiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Iŋgoŋ yoŋ adi me notne momooŋ, tiŋa me notne na’walaŋ hinehinekdigoŋ kudi i tilak. ");
INSERT INTO nop_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Koom adi noŋgoŋ yauŋa mede yonadi wanakaŋ momooŋ hinek tagumut, tiŋa undugoŋ metam noli dut Bepaŋ yolineŋ noŋgoŋ wagumun. ");
INSERT INTO nop_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Memikneye adi titiŋ kadakahidi welehik gineŋ eŋ yohik maaneŋ kilidapmaŋ tilak. Unduŋ doktiŋa adi yadi pilap kumuneŋdok nadilat. Kaipmuŋ hatiiŋneŋ nai indidegoŋ yeniŋkulune me kumuhi’walaŋ yohikwehineŋ fogidibaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Iŋgoŋ nu adi Yahwedi nehitubu-lodawek yoŋa ninadilat, doktiŋa negoŋ nehitubu-lodaaŋ kotigoŋ nanagilek. ");
INSERT INTO nop_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Nu malabumuŋnedok koyone haniŋ-timiŋ, mele lekiŋgoŋ eŋ bufali tibene Bepaŋ’walaŋkade ulak. Kaŋ adi yonadine u nadilak. ");
INSERT INTO nop_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Mik wapum gineŋ wene memik feedi mik tinamiiŋ, iŋgoŋ Bepaŋdi nabudokooŋ kotigoŋ nanagila bulak. ");
INSERT INTO nop_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Koomkwaha Bepaŋ adi Mapme hatiguk, eŋ kobuk maaŋ adigoŋ Mapme hatilak. Wendoktiŋa negoŋ yonadine nadinamuŋa memik heki mik gineŋ fafaŋe tiŋa widihidapmaŋ tibaak. Adi Bepaŋ gikiŋgoŋ mu timiiŋ doktiŋa nemek niŋdi nemu yaheheweyemiŋa yehitubu-lodawaak. ");
INSERT INTO nop_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Me notne adi koom me noliŋiye dut mede yofolok tigiŋ u bikabuŋa noliŋiye mik tiyemulak. ");
INSERT INTO nop_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Maŋiŋ foloŋ adi mede kobaŋ hinek yolak, iŋgoŋ oŋ, weleŋ gineŋ adi memik tinamulak. Medeŋiŋdi welekulema tubumintalak nabugoŋ, iŋgoŋ mede u yadi miknoŋ maŋiŋnit hinek doktiŋa nihidobu tilak. ");
INSERT INTO nop_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Malabumuŋ hogohogok hekilaŋ u Yahwe kohoŋ foloŋ boiweŋ, kaŋ adi hekiŋa saŋiniŋ kedem gambaak. Adi me didimehi biyabune nemek niŋdi tuwot mu yehitubu-kadakawaak. ");
INSERT INTO nop_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Iŋgoŋ Bepaŋ, du adi me widihikumuŋ tiiŋ eŋ yalaŋ-me heki, adi yadi yehikelekut tubune meyot gineŋ fooŋ liwe tineeŋ. Naihik mu dapmalune kumuneeŋ. Iŋgoŋ nu adi du hogok nadisukilitigambaat. ");
INSERT INTO nop_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","O Bepaŋ, du siloŋ tobogoŋ tinambeŋ. Meheki adi nehikeleeŋ nukut mik tiiŋ, eŋ helemahelemaŋ memik heki adi kadakaniŋ tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Memik heki adi haniŋ tububihila wooŋ tebele dapmalak u nukut mik tiiŋ. Meeniŋ feedi nu mik tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Bepaŋ, Saŋiniŋ Molom, nu nemek niŋdok munta tilatneŋ, nai uŋaniŋ adi du hogok nadisukilitigamulat. ");
INSERT INTO nop_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Nu Bepaŋ nadisukilitimiŋa adi’walaŋ medeŋiŋ yofolok tuguk wendok nadilat. Unduŋ doktiŋa nu adi Bepaŋ wou nintilolat. Nu adi Bepaŋ nadisukilitimilat, doktiŋa nemek niŋdok munta tuwot mu tilat. Ale meeniŋdi maŋgoŋ tinamneŋ? Tuwot mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Nemenemek nu tibe tilat woŋ adi memikneyedi tubukadaka hogok tiiŋ. Helemahelemaŋ adi nu nehitubu-kadakadok talik lohiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Meheki woŋ adi wanakaŋ wooŋ bopneeŋ hebi-hakiiŋ. Adi nulukumuŋ tinene nadiiŋ doktiŋa talik deŋandiŋ yaulat u baigoŋ ha-nabukuwat tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Bepaŋ, adi titiŋhik kadakaniŋ tiiŋ doktiŋa du kibibo kisaŋ widihikadakaweŋ. Tiŋa metambop wondok kwihita tiyemiŋa widihiliwe tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Nu malabumuŋ hekiŋa moŋ hinek nadiŋa makat ha-kotat, u da-ku agaŋ nadilaŋ. Kaŋ du wendok uŋgoŋ nadiŋila pepage gineŋ agaŋ youlune foguk. ");
INSERT INTO nop_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Bepaŋ, nu du agaŋ nadigamulat. Du nu nehitubu-lodawene nadilaŋ, doktiŋa nu ganinadiwaat, nai uŋaniŋ memik heki yehikeleune momoŋ uneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Nu Yahwe nadisukilitimiŋa medeŋiŋ yofolok tuguk wendok nadilat. Wondoktiŋa wou nintilolat. Biyagoŋ hinek, nu medeŋiŋ yofafaŋe tuguk wendok nadiŋa wou nintilolat. ");
INSERT INTO nop_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Nu Yahwe nadisukilitimilat doktiŋa nemek niŋdok munta tuwot mu tibit. Ale meeniŋdi maŋgoŋ tinamneŋ? Tuwot mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","13","Bepaŋ, nu koom nemek titiŋdok gigit yogut u folooŋ agaŋ tibit. Du kotigoŋ nanagikuŋ kaŋ nu mu kumuŋgut. Dagoŋ nehitubu-lodaguŋ kaŋ nu yali tiŋgawaŋgawaŋe tiŋa mu maaŋ nukuk. Wendoktiŋa Bepaŋ, nu adi helemahelemaŋ dukut hatilat. Tiŋa undugoŋ, du’walaŋ hatihati fafaŋeniŋ diniŋ hauta gineŋ hatiluwaat. Unduŋ doktiŋa ganiutumba hinek tiŋa youtumbane diniŋ fek u dumuŋ hegambaat. ");
INSERT INTO nop_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Bepaŋ, du siloŋ tobogoŋ tinambeŋ. Du siloŋ tobogoŋ tinambeŋ, kaŋ nu wooŋ dugut uŋgoŋ hebihatiluwaat. Pupup mihiniŋdi meehik’walaŋ papaliŋiŋ gineŋ fooŋ kabup hebihakiiŋ unduŋ, nu dukut adi momooŋ hinek hatilat. Nu adi undugoŋ hatitawene nemek nehitubu-kadakadok tilak u dapmandok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Nu adi Bepaŋ loloŋnit hinehinekdi nehitubu-lodawek yoŋa kutinilat. Kaŋ nu maŋgoŋdok baniŋ tilat hogohogok u tuwot hinek namulak. ");
INSERT INTO nop_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Adi kunum foloŋ hali yonadine nadiŋa nehitubu-lodaaŋ nanagilek. Adi me nehitubu-kadaka titiŋdok welehik kudup daune tiiŋ u yenintoŋa yenihep tibek. Bepaŋ adi helemahelemaŋ weleŋdi nibukahile titiŋdok yofafaŋeguk wondok kaule mu tilak. Mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Nu adi me laion nabugoŋ, meeniŋ yehinanaŋdok woom tiŋa hakiiŋ heki’walaŋ lekiŋgoŋhik foloŋ deihatat. Mahik adi mokop tiŋa bohom fimikimikiyenit hinek dabugoŋ undihi. Eŋ mebelemhik adi miknoŋ maŋiŋ imikimikiyenit hinek nabugoŋ undihi. ");
INSERT INTO nop_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Bepaŋ, nu adi metamdi wohoge ganintiloune kunum kalakapmeeŋ lohinakaaŋ halekdok nadilat. Kwetkwet wanakaŋ da’walaŋ saŋiniŋge u miŋgilaŋgoŋ hinek tubudakalehinakaweŋ, kaŋ metam hogohogok wanakaŋdi wohogegigit u kedem nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Memikneye adi nohonedok yoŋa begep ibiŋa tehiune hatak. Unduŋ doktiŋa malabumuŋ wapumdi nehitifo-hinakalak. Nu maaŋ fowit yoŋa talitne foloŋ koŋ niŋ dobugiŋ. Iŋgoŋ nu uŋoŋ mu maaŋ fogut, adi toboniŋ nehigoŋ koŋ wendok gineŋ maaŋ fogiŋ. ");
INSERT INTO nop_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Bepaŋ, nu welene gineŋ du nadisukiliti hinek tigamulat. Biyagoŋ hinek, nu du hogok nadisukiliti-gamulat. Unduŋ doktiŋa kap toŋa wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Nu damo wabi tiŋa pilalit. Tiŋa gita eŋ kulele heki uŋak ulit. Helemiŋ dobulune ulene mede toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Wapum, nu metambop noli’walaŋ lekiŋgoŋhik gineŋ ganiutumbawit. Nu metam hatitawiiŋ indigoŋ tuwot yaudapmaaŋ wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Du welegedi nibukahile hinek tilaŋ. Indi titiŋ momooŋge u kameka tinim yoŋa kamekanim adi fekŋiŋdi logeloge kunum foloŋ gwaŋ dapmawek. Du mede yofafaŋeguŋ hogohogok u helemahelemaŋ takalilaŋ. Indi du helemahelemaŋ nemek momooŋ tinimilaŋ u kunakayanim binemek woŋ adi looŋ mulukwaŋ ikiiŋneŋ uŋgoŋ youkaliwek. ");
INSERT INTO nop_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Bepaŋ, nu adi metamdi wohoge ganintiloune kunum kalakapmeeŋ lohinakaaŋ halekdok nadilat. Kwetkwet wanakaŋ da’walaŋ saŋiniŋge u miŋgilaŋgoŋ hinek tubudakalehinakaweŋ, kaŋ metam hogohogok wanakaŋdi wohogegigit u kedem nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Me talitimeŋ wapuhi, hidi mede yodapmaŋ kwanai tiŋila mede didimeŋgoŋ be yoiŋ? Hidi meheki’walaŋ medehik kameka didimeniŋgoŋ-kube tiiŋ? ");
INSERT INTO nop_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Unduŋ mu tiiŋ, hidi’walaŋ nadinadihik adi kadakaniŋ titiŋdok gineŋ hogok udapmalak. Hidi adi unduŋ tiŋale metam kwetkwet hatitawiiŋ yehitubu-kadakatawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Me kadakahi adi hatihatihik wanakaŋ hogohogok talik fai gineŋ udapmaiŋ. Adi yadi yalaŋ mede kuyahi-kabe minta tigiŋneniŋ tububihila yotalabubuyeŋ agaŋ gawada tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Medehik adi miŋgembet heki’walaŋ upmuŋ hogoli undihi. Adi yadi miŋgembet mimimnit bubuyeŋ niŋdi mede mu nadilak undihi, magihik youkaule tiŋa hakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Adi magihik youkaule tiiŋ doktiŋa me noli’walaŋ yokulema mede tuwot mu nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Bepaŋ, du me kadakahi u yehitubu-kadaka hinek tibeŋ. Yahwe, adi yadi laion miknit hinek undihi, unduŋ doktiŋa mahik kitili mikit u ugolokuyemiŋa tamakudapmaŋ tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Adi yadi imedi wodiŋa wooŋ kwet gineŋ liweŋila naŋgatak, undugoŋ hinek liweneŋ. Meeniŋdi kilihikit yaliune sigeneeŋ kumiiŋ, undugoŋ hinek yehiyaliweŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Adi yadi gikambotdi kwetfoloŋ kumuŋa bitakaiŋ wendok tuwot kadakaneŋ. Eŋ eyaŋdi miŋ weleŋ gineŋ kumumbune dabaŋ nagitak, kaŋ hauta mu kalak undugoŋ hinek kumuneŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Me niŋdi bem-kabe kuyaniŋ niŋ pilap hinek fidokolak undugoŋ hinek Bepaŋdi pilap hinek yehitubu-kadakalak. Adi kaipmuŋ hatilune Bepaŋdi yabukwihitaaŋ gilem nabugoŋ yehibeyakulune wiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Me kadakaniŋ titiŋ heki adi Bepaŋdi kadakaniŋhikdok kibikoŋ tubu-udaneyembune metam didimehidi u yabuŋa nadifo tineeŋ. Me didimehi adi kayohik me kadakahi’walaŋ naŋgathik gineŋ youtetneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Kaŋ meeniŋ nolidi indiŋ yoneeŋ, “Bepaŋdi me didimehidok tuwaŋiŋ momooŋ hinek yemilak. Biyagoŋ hinek, Bepaŋ adi hatilak, doktiŋa metam hogohogok wanakaŋ titiŋhikdok mede nadinadi kwanai tiŋila kameka tilak.” ");
INSERT INTO nop_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Bepaŋne, du me mikneye kohohik gineniŋ kotigoŋ nehikibidali nanagit hinek tibeŋ. Du nabu-ulidokoweŋ kaŋ adi mu nehitubu-kadakaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Du me kadakahi kohohik gineniŋ nehikibidaleŋ, unduŋ tiŋa me heki menaŋgat nanaŋ tiiŋ heki’walaŋ kohohik gineniŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","U yabeŋ, adi yadi nu nulukumundok kabup woomhakiiŋ. Me kadakahi uyadi me mik molo heki, adi yadi nukut mik titiŋdok bopneiŋ. Yahwe, nu kadakaniŋ nemu tiyemilat. ");
INSERT INTO nop_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Yodoko Medege u kahaŋinda mu tilat. Tiŋa undugoŋ, nu nemek nemu tibene kadakaguk. Iŋgoŋ adi yadi nukut mik titiŋdok pilap hinek wooŋ woomnamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Yahwe, Saŋiniŋ Molom, pilap hinek buŋa nehitubu-lodaweŋ. Isilaehi’walaŋ Bepaŋ, du meheki i yabeŋ. Du pilap buŋa metambop hogohogok i malabumuŋ yembeŋ, du aditok bulaniŋgoŋ adi mu nadiyembeŋ. Du metambop titiŋ momooŋ titiŋdok yokamandaaŋ wooŋ titiŋ hogohi titiŋdok nadiiŋ, adi hekidok adi kibikoŋhik tubu-udane hinek tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Adi timiŋ kotigoŋ udaneeŋ buŋa yokwet wapum diniŋ gimbahaŋ kelemadiŋa kamo hekidi tombulumbulume tiiŋ unduŋ toyawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","U nadiweŋ. Medehik adi hogoli hinehinek, miknoŋ niŋ maŋiŋnit nabugoŋ. Iŋgoŋ nehi adi indiŋ yoiŋ, “Nebek nemu nadinimilak ale.” ");
INSERT INTO nop_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Iŋgoŋ Yahwe, du adi yabugege tilaŋ, tiŋa metambop hogohogok u yenimpekit tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Da kubugoŋdi saŋiniŋ namuŋa nabudokolaŋ. Bepaŋ, nu memik heki yabu-momoŋ tiŋa du’walaŋkade bulat, du kubugoŋdi hebihat kwetne tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Bepaŋ adi nabukahile hinek tilak, doktiŋa adi negoŋ buŋa nehitubu-lodawek. Adi nu binabune hogok yakawene negoŋ memikneye yehibefooŋ yalakapmewaak. ");
INSERT INTO nop_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Bepaŋ, metamneye adi nemek i maŋgoŋde tiŋa mintalak u kaule tineeneŋ, doktiŋa memikneye u mu widihikumumbeŋ. Wapum, du adi indi’walaŋ yahehewenik, ale da’walaŋ saŋiniŋgedi memik heki yehikelekula yehitubu-kadakaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Helemahelemaŋ, adi yadi kadakaniŋ titiŋdok hogok yoiŋ. Ale biyabune nehi’walaŋ fokohik doktiŋa malabumuŋ hekineŋ. Adi yadi helemahelemaŋ yalaŋ mede yoiŋ, tiŋa du wohoge foloŋ medehaki yoiŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Du wondoktiŋa nadikadakayemiŋa widihikumumbeŋ. Me kadakahi u yehitubu-liwedapmaŋ hinek tibeŋ. Du unduŋ tibeŋ kaŋ metam hogohogokdi indiŋ nadineŋ: Du Bepaŋ, Isilaehi’walaŋ Mapme hatilaŋ eŋ kwetkwet diniŋ Mapme. ");
INSERT INTO nop_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Adi timiŋ kotigoŋ udaneeŋ buŋa yokwet wapum diniŋ gimbahaŋ kelemadiŋa kamo hekidi tombulumbulume tiiŋ unduŋ toyawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Nanaŋedok nadiŋa woŋambuŋat tiiŋ, ala welehik mu tokilak kaŋ uŋgoŋ hali mede wapum toiŋ. ");
INSERT INTO nop_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Iŋgoŋ nu adi saŋiniŋge wapum wendok yobihila kap gineŋ tobit. Nu koom malabumuŋ mebimebi mintanambune dagoŋ yahehewe tinamuŋa nabudokoguŋ. Wendok nadiŋa nu helemahelemaŋ haniŋ timiŋ kap wapum toluwaat. ");
INSERT INTO nop_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Bepaŋ, da kubugoŋdi saŋiniŋne, wendoktiŋa nu kap toŋa wohoge ganintiloit. Bepaŋ, du adi nabukahile hinek tilaŋ, tiŋa undugoŋ, hebihatnedok kwet adi da kubugoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Bepaŋ, du nibukwihita tiŋa binibuguŋ kaŋ mik gineŋ fafaŋe mu tugumun. Iŋgoŋ kamiŋ kotigoŋ buŋa nihitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Du kwetnik i tiŋa mahamut tuguŋ. Unduŋ tiŋa kwet agaŋ tubutawaguŋ kaŋ ginaŋ yatak. Kaŋ kobuk kwet i agaŋ kadakadapmawe tilak, unduŋ doktiŋa kotigoŋ tutumbaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Metamgeye inditok malabumuŋ fee hinek nimguŋ. Woŋ adi da wain ime nimbune naaŋ nadibubuye tugumun nabugoŋ. ");
INSERT INTO nop_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Du fek niŋ kwehene-tiloweŋ, kaŋ me du’walaŋ hebekeneŋ hatiiŋdi u kaŋ memikhiye yabu-momoŋ buŋa uŋoŋ busuwaaŋ kulemaŋgoŋ hatneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Du nibukahile hinek tilaŋ, doktiŋa yonadinik u nadinimiŋa da’walaŋ saŋiniŋge loloŋnit wendi kotigoŋ ninigileŋ, kaŋ indi kulemaŋgoŋ kedem hatinim. ");
INSERT INTO nop_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Bepaŋ adi yolineŋ hali indiŋ yolak, “Nu mik gineŋ agaŋ fafaŋeeŋ yalakapmegut, doktiŋa Sekemhi’walaŋ kwet eŋ Sukomhi’walaŋ kwet gutuŋ u metamneyedok daneyemtawit. ");
INSERT INTO nop_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","“Gileat dut Manase adi natok. Eŋ Ifeleim adi mik mebimokopne fafaŋeniŋ. Kaŋ Juda adi mapme kuyaŋne. ");
INSERT INTO nop_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","“Iŋgoŋ Moaphi tiŋa Idomhi adi tipilapilaye kwanai tinamneeŋ. Tiŋa Filistiahi dut mik tiŋa yalakapmegut doktiŋa nadifooŋ kakali tilat.” ");
INSERT INTO nop_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Bepaŋ, yokwet wapum gimbahaŋ fafaŋeniŋnit gineŋ uŋoŋ nediyeŋdi nanagila wek? Be Idomde nediyeŋdi nanagila wek? ");
INSERT INTO nop_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Bepaŋ, du agaŋ sigilulum be tinimguŋ? Du mikmeniye kotigoŋ tuwot mube yehitubu-lodaweŋ? ");
INSERT INTO nop_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Meeniŋdi nihitubu-lodaneŋ iŋgoŋ wondi nemek nemu tibek. Wendoktiŋa dagoŋ kedem nihitubu-lodaune memikniye dut mik tinim. ");
INSERT INTO nop_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Bepaŋdi nihitubu-lodawek woŋ, indi mik gineŋ fafaŋe tiŋa widihidapmanim. Bepaŋ negoŋ memikniye u kedem yehiyalifilidawek. ");
INSERT INTO nop_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Bepaŋ, kutikutine du’walaŋkade ulak u nadiweŋ. Magike baigoŋ kametnadiŋa yonadine nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Nu yotne-kwetne bikabuŋa wooŋ kweetniŋ hali welemulap kisaŋ hinek nadilat. Unduŋ doktiŋa du nehitubu-lodaweŋ yoŋa kutiganilat. Du nanagila kwet niŋ hebihat titiŋdokneŋ weŋ, kaŋ memik hekidi tuwot mu nehitubu-kadakaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Du dagoŋ momooŋ hinek nabu-ulidokolaŋ, tiŋa undugoŋ du dagoŋ yahehewene fafaŋeniŋ. Unduŋ doktiŋa memik hekidi tuwot mu nehitubukadakaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Nadinambune du yokeneŋ uŋgoŋ hatiŋa wooŋ hatibaat. Tiŋa undugoŋ pupup mihiniŋdi miŋ papaliŋiŋ gineŋ fooŋ hebihatak undugoŋ, du gehitubu-dulaaŋ hebeke gineŋ kulemaŋgoŋ hatidok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Bepaŋ, nemenemek hogohogokdok yofolok tiŋa ganiŋgut u da-ku agaŋ nadiguŋ. Du metam wohoge ganintiloiŋdok yemulaŋ undugoŋ nemenemek nutok u agaŋ namguŋ. ");
INSERT INTO nop_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Du mapme’walaŋ hatihatiŋiŋ tomboyoulune gulet fee hatiŋa wooŋ hatibaak. ");
INSERT INTO nop_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Bepaŋ, du nadimimbune namandake foloŋ mapme dapmandapmaŋnit mokit hatiluwaak. Du kanadigalika tiŋa helemahelemaŋ momooŋ hinek kadokoluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Du unduŋ tubune nu helemahelemaŋ yofolok koom dukut tugut u yehikeleluwaat, unduŋ tiŋa helemahelemaŋ wohoge ganintilooŋ kap toluwaat. ");
INSERT INTO nop_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Nu adi Bepaŋ kubugoŋ nadisukilitimilat, tiŋa adi nehitubu-lodadok woomilat. ");
INSERT INTO nop_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Adi kubugoŋdi nabudokooŋ nehitubu-lodalak. Tiŋa undugoŋ adi kubugoŋdi yahehewene fafaŋeniŋ. Unduŋ doktiŋa nu mik gineŋ tuwot mu gweheyewit. Mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Hidi mik tinamuŋa nehitubu-kadakadok tiiŋ woŋ adi wabi hinek tineeŋ. Be hidi gimbahaŋ niŋdi dokobulaginelak unduŋ nehitubu-kadakadok-kube tiiŋ? ");
INSERT INTO nop_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Nu adi wotnegigitnit, iŋgoŋ hidi adi wotnegigit u tubukadaka tiiŋ. Eŋ yalaŋ mededok adi nadiune utumba tilak. Eŋ Bepaŋdi kahaŋ tinamdok mede momooŋ yoiŋ, iŋgoŋ welehik maaneŋ adi indiŋ nadiiŋ, “Bepaŋdi tubukadaka tibek nadiyam.” ");
INSERT INTO nop_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Nu adi Bepaŋ kubugoŋ nadisukilitimilat, tiŋa adi nehitubu-lodadok nadikunakunale tiŋa woomilat. ");
INSERT INTO nop_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Adi kubugoŋdi nabudokooŋ nehitubu-lodalak. Tiŋa undugoŋ adi kubugoŋdi gimbahaŋ fafaŋeniŋne. Unduŋ doktiŋa nu mik gineŋ tuwot mu gweheyewit. Mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Bepaŋ ne kubugoŋdi kotigoŋ nanagila wotnegigit namulak. Adi yadi nabudoko fafaŋeniŋ hinek tilak. Bepaŋ adi gimbahaŋne fafaŋeniŋ doktiŋa memik hekidi tuwot mu nehitubu-kadakaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Bepaŋ kubugoŋdi hebihat kwetnik, unduŋ doktiŋa metamneye hidi helemahelemaŋ adi hogok nadisukilitimiyaneeŋ. Unduŋ tiŋa malabumuŋhik be nadinadihik u adi hogok nimbihikaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Kwetfoloŋ me adi yadi maguhuguhut wondok tuwolit. Me wohiyehinit be wohiyehinit mokit adi wanakaŋ undugoŋ nemek fiit nabugoŋ. Indi adi’walaŋ malabumuŋhikdok kameka tinim woŋ, adi yadi loŋgoŋ hinek. Adi’walaŋ malabumuŋhikdi maguhuguhut diniŋ malabumuŋ gut kameka tubune tuwolit mu tibek. ");
INSERT INTO nop_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Hidi indiŋ mu nadineŋ, “Mik titiŋ eŋ bomboŋ kubo titiŋ wooŋ adi titiŋ momooŋ, doktiŋa wendigoŋ nihitubu-lodaune me muneeŋ bomboŋhinit tinim.” Hidi muneeŋ bomboŋhikdi fee tubune wondi saŋiniŋnik tilak unduŋ yoŋa mu nadiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Nai fee nadiwene Bepaŋdi indiŋ yolak, “Nu Bepaŋ, nu saŋiniŋne wapum hinek. ");
INSERT INTO nop_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Tiŋa helemahelemaŋ welenedi metam hogohogok yabukahilelat.” Wapum, du adi metam hogohogok indi titiŋnik dediŋ tiyam wendok tuwolit tuwaŋiŋ nimulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Bepaŋ, du nu’walaŋ Bepaŋne. Nu du gabudok gigine kwanai tilat. Me niŋdi kwet siliŋ ime mokitneŋ hali maŋiŋ galiune imedok nadilak wendok tuwot, munabulinedi dukut hatidok hinek nadilak. Eŋ foloonedi maaŋ undugoŋ nadilak. ");
INSERT INTO nop_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Nu adi yoke uŋgoniŋ gineŋ uŋoŋ gabit, kaŋ du da’walaŋ saŋiniŋge loloŋnit tiŋa ipilatge gineŋ filimpipitnit u nanimbune kawit. ");
INSERT INTO nop_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Kwetfoloŋ iŋoŋ hatihati hatak u momooŋ, iŋgoŋ du’walaŋ welesiloŋge wendi kalakapmeeŋ timeŋ hinek tilak. Wondoktiŋa wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Nu ganiutumbaaŋ wohoge ganintilooŋ hatigene kumumbaat. Tiŋa kohone kwehene-belooŋ ganinadi tibit. ");
INSERT INTO nop_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Meeniŋdi nanaŋe kobahi tuwot hinek natokiŋa hakiiŋ wendok tuwot, munabuline adi kedem hinek hatak. Kaŋ manedi nadifo kap toŋa wohoge ganintilolat. ");
INSERT INTO nop_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Gulupne foloŋ deihali dutok hogok ha-nadilat. Eŋ timiŋ u maaŋ dutok hogok ha-nadiluwene helemiŋ dobulak. ");
INSERT INTO nop_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Dagoŋ helemahelemaŋ nehitubu-lodaluguŋ doktiŋa unduŋ tilat. Nu pupup mihiniŋdi miŋ papaliŋiŋ gineŋ hebihatak unduŋ, yamaiŋgoŋ gehitubu-dulaaŋ hali nadifo kap ha-tolat. ");
INSERT INTO nop_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Munabulinedi du gehikahileeŋ gehifolokenelak. Eŋ kohoge didimeniŋdi nehiulihilak. ");
INSERT INTO nop_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Kaŋ me nulukumuŋdok tiiŋ heki adi yadi me kumuhi yohikwehineŋ uneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Adi mik gineŋ kumuneeŋ, kaŋ kamo moihidi foloohik dabaŋ u naneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Iŋgoŋ mapme nu adi Bepaŋ dutok nadifo tibaat. Meeniŋ du gehikeledok da woho foloŋ yofolok tigiŋ heki adi yadi nadifo hinek tineŋ. Iŋgoŋ me yalaŋ-me heki’walaŋ mahik adi tehep tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Bepaŋ, nu malabumuŋne wapum hinek, unduŋ doktiŋa du yonadine kedem nadinambeŋ. Nu memik hekidok munta tilat, ale du nehitubu-lodaweŋ kaŋ adi tuwot mu nulukumuneŋ. ");
INSERT INTO nop_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Me kadakahi adi nu nehitubu-kadakadok talik lohiiŋ, tiŋa nu nunutdok bop tiiŋ. Unduŋ doktiŋa napmehebiŋa nabudokoune adi nemek kadakaniŋ nemu tinamneŋ. ");
INSERT INTO nop_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Meeniŋ’walaŋ medehik adi imikimikiyeune miknoŋ nabugoŋ nehidobu tilak. Medehakihik adi me niŋdi tebe kandam tebehit foloŋ youhiŋa hamanedindineune meeniŋ ha-kahohoŋelak wendok tuwolit hinek. ");
INSERT INTO nop_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Adi hebihali me momohidok tebe kandam ha-fiyagiyemiiŋ. Adi munta mu tiiŋ, doktiŋa pilap hinek fiyagikiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Adi titiŋ hogohi u titiŋdok nehi uŋgoŋ kitubukiliti tiiŋ. Adi begep kwet deŋandiŋ ibiŋa me noli yohonedok wendok yonadi tiiŋ. Tiŋa adi indiŋ nadiiŋ, “Nebek nemu nibek ale.” ");
INSERT INTO nop_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Adi titiŋ kadakahi tinene mede yofolok tiŋa indiŋ yoiŋ, “Indi titiŋ kadakaniŋ niŋ titiŋdok talik agaŋ tubumintamun. Nebek me niŋdi nemek u tine tam u tuwot mu tubumintawek.” Kwetfoloŋ me indi meeniŋ nadinadihik be welehik gineŋ tuwot mu kadapmanim. ");
INSERT INTO nop_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Iŋgoŋ Bepaŋ adi tebe kandamŋiŋdi yalambune pilap hinek kumuŋa liwe tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Me niŋ tubukadakadok mede tiulidokogiŋ wondoktiŋa kibibo Bepaŋdi tubu-udaneyembune nehi’walaŋ mede yohebethik wondigoŋ yehitubukadakalak. Kaŋ metamdi yabugegeeŋ mebiguguŋ tiyemiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Bepaŋdi unduŋ tubu-udaneyembune metam hogohogok adi Bepaŋdok munta timineeŋ. Unduŋ tiŋa Bepaŋdi nemek u tuguk wendok mede yonadi tineeŋ, tiŋa helemahelemaŋ wendok uŋgoŋ hati nadiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Metam didimehi hogohogok adi Yahwedok nadifo tiyaneeŋ, tiŋa nemek hogoli u kaŋ momoŋ wooŋ adi’walaŋkade hebihakaneeŋ. Tiŋa metam didimehi hogohogok adi yadi Wapum wou nintiloyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Bepaŋ, indi Saiyon uŋoŋ wooŋ wohoge yotilonene utumba tilak. Kaŋ nemenemek hogohogok titiŋdok yofafaŋegumun u folooŋ tinene utumba hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Du indi’walaŋ yonadinik nadinimilaŋ, unduŋ doktiŋa metam hogohogok indi du’walaŋkade unim. ");
INSERT INTO nop_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Indi kadakaniŋnikdok nadiŋa unduŋ tinim. Yomnikdi nihibefohinaka hinek tilak iŋgoŋ oŋ, du kadakaniŋnik tumolokutnimilaŋ u agaŋ nadiyam. ");
INSERT INTO nop_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Meeniŋ dagoŋ yehitubu-dakaleŋila yahaŋeune yokeneŋ wiiŋ, adi yadi nadifo kedem tineŋ. Yokeneŋ uŋoŋ adi nemek fofohi fee hakiiŋ. Unduŋ doktiŋa indi youtumba yotge gimbahaŋ maaneŋ uŋoŋ haliŋa welemomooŋ hinek nadiyam. ");
INSERT INTO nop_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Bepaŋ, da kubugoŋdi yonadinik nadiŋa kotigoŋ ninigitaŋ kaŋ indi momooŋ hakam. Du kotigoŋ ninigitdok kwanai tuguŋ u nemek folooŋ hinek. Kaŋ metam kweetniŋ kwet wapum haliulak indigoŋ eŋ luhi gagayeŋ haliwiiŋ indigoŋ tuwot du kubugoŋ nadisukilitigamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Da’walaŋ saŋiniŋgedi kweboboe i nadiune mintaaŋ waaniŋ kwehik foloŋ uŋgoŋ yaliwiiŋ. Du saŋiniŋge adi loloŋnit hinek. ");
INSERT INTO nop_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Da kubugoŋdi nadiune imeŋgwaŋ wapum giyondaaŋ muhila mede tolak u kulemaaŋ fooŋ hatak, eŋ metamdi mede foloŋ kisiwe tiŋa kinintifo tiiŋ u tubukulemalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Kwetkwet memetam adi du nemenemek tilaŋ u kaŋ nadiune uŋgoniŋ hinek tubune munta tiiŋ. Kaŋ mele labulabuneŋkade wooŋ mele fohebilakneŋkade adi nemenemek tuguŋ hogohogok u nadiŋa kakali nadifonit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Du kwet momooŋ hinek kadokolaŋ, wondiniŋ folooŋ gwi nadiune maaŋ kwet tubukulemalak. Kaŋ kwetdi galikit tubumintaune nanaŋe duhuduhu kedem mintalak. Bepaŋ, du ime boiguŋ u naŋgat mu tiiŋ. Wondigoŋ tubune nanaŋe fee mintaune meeniŋdi moŋgo-henaŋ tiiŋ. Kwanai u dagoŋ tuguŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Dagoŋ nadiune diniyeti kwetneŋ gwi wapum malak, kaŋ imedi kwet maaneŋ hatak. Hali kwet tubukulemaune nanaŋe momooŋ hinek labiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Du momooŋ hinek tinimiŋa nanaŋe fee hinek tubumintanimilaŋ. Du kwet daŋgoŋ ulaŋneŋ uŋoŋ maaŋ nanaŋe mohok momohi fee mintaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Kwet gutuŋ kabekabe kilihikitnit u makau eŋ dompa hekidi kiliŋa haliwiiŋ. Kaŋ tuwai kabekabe adi nadifo tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Dompa bop wapumdi kwet kilihikitnit haliulak indigoŋ tuwot kilidapmaŋ tiŋa haliwiiŋ. Kaŋ kwet kubali, gutuŋ kabekabe haliwiiŋ hogohogok tuwot pandiŋ eŋ haŋgomdi labu kilidapmaŋ tiŋa hatak. Kaŋ nemenemek hogohogok adi kakaliŋa nadifo kap toiŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Kwetfoloŋ metam hogohogok, hidi Bepaŋ nintilooŋ kakaliŋa nadifo tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Wougigitŋiŋ nintiloune foloniŋgoŋ hinek gwaŋ looŋ halek, kaŋ kap toŋa wougigitŋiŋ yotubuhautaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Indi Bepaŋ indiŋ ninim, “Du nemenemek tilaŋ hogohogok woŋ adi uŋgoniŋ hinehinek. Eŋ saŋiniŋge adi loloŋnit hinek, doktiŋa memikgeye adi dutok munta kisaŋ hinek tiŋa namandake foloŋ mulelem tigamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","“Kwetfoloŋ memetam hogohogok adi du ganiutumbaiŋ. Tiŋa kap tonadifo tigamuŋa kakaliŋa wohogigit yotilooŋ kap toiŋ.” ");
INSERT INTO nop_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Hidi buŋa Bepaŋdi nemek tuguk i kaneŋ. Adi metam’walaŋ lekiŋgoŋhik foloŋ nemenemek uŋgoniŋ hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Adi imeŋgwaŋ u yobune kwet siliŋ mintaguk, kaŋ mamahi-papahiye adi kwet wendok foloŋ yalitauyeŋ ime wapum u meŋeŋa fokolok logiŋ. Unduŋ doktiŋa aditok welenadifo nadiminim. ");
INSERT INTO nop_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Adi saŋiniŋŋiŋ wapum hinek, eŋ mapme dapmandapmaŋnit mokit hatilak. Tiŋa undugoŋ, metamdi maŋgoŋ kabekabe tiiŋ hogohogok u wanakaŋ hinek yabunadidapmalak. Unduneŋ ala, tiyaugene nebek niŋdi Bepaŋ nimpekit be niŋkadaka mu taneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Metambop wanakaŋ hogohogok hidi Bepaŋnik niutumbaneŋ, kaŋ youtumbahik diniŋ gigilitŋiŋdi mintaune nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Adigoŋ nibudokoune kaipmuŋ hatiyam, eŋ nihitubu-lodalak kaŋ mu kadakayam. ");
INSERT INTO nop_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","O Bepaŋ, du silwa kudup gineŋ heune dagweheyeeŋ datilitiliyelak kaŋ geŋgeŋŋiŋ makwaneune silwa hogokdi walandaaŋ fafau hinek mintalak, wendok tuwot hinek indi nihimahamuka mahamuka tuguŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Du begepge gineŋ nihoneeŋ malabumuŋ wapum foloonik foloŋ kameguŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Du binibune memik hekidi nihiyali-befohinaka tigiŋ. Kaŋ indi kudup eŋ imegabuŋ gineŋ hatigumun, iŋgoŋ fiit kotigoŋ ninigila labuŋa yokwet fofooŋ gineŋ nipmeguŋ. ");
INSERT INTO nop_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Nu dumuŋ kunilit dadapmaŋ titiŋdok beŋa du yokeneŋ wooŋ siloŋ tigambit, siloŋ u titiŋdok agaŋ koom yofafaŋegut uŋakoŋ tigambit. ");
INSERT INTO nop_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Koom malabumuŋ maaneŋ hatiŋila nemek niŋ gamdok yogut uŋakoŋ gambit. ");
INSERT INTO nop_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Nu kale galikihinit kawade-bubu foloŋ heeŋ siloŋ tigambit. Eŋ dompa maahi hegambit, kaŋ siloŋ wendiniŋ munduŋ momooŋ nadiweŋ. Eŋ makau maaniŋ tiŋa meme u beŋa siloŋ tigambit. ");
INSERT INTO nop_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Metam hogohogok Bepaŋ’walaŋ hebeŋ foloŋ hatiiŋ, hidi buŋa nu’walaŋ mede nadineŋ. Kaŋ nu Bepaŋdi nemenemek hogohogok tiŋa nehitubu-lodaguk wendok hanimbit. ");
INSERT INTO nop_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Nu koom nehitubu-lodawek yoŋa gibitaŋ kutiniŋgut. Unduŋ doktiŋa nu kap toŋa wou nintiloloŋdok tiulidoko tugut. ");
INSERT INTO nop_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Iŋgoŋ welenedi titiŋ hogohi wendok nadigalikaaŋ yabukahileeŋ boihatibit adi Wapumdi ninadine tuwot mu nadinambek. ");
INSERT INTO nop_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Iŋgoŋ Bepaŋ adi agaŋ magi kametnadi tuguk. Biyagoŋ hinek, yonadine agaŋ nadinamguk. ");
INSERT INTO nop_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Nu Bepaŋ niutumbalat. Adi yonadine nadiŋa sigilulum mu tinamulak. Tiŋa undugoŋ, nutok siloŋ tobogoŋ tinamulak u mu kameheguk. ");
INSERT INTO nop_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Bepaŋ, du siloŋ tobogoŋ tiŋa kahaŋ tinimbeŋ. Du diweune foune nibuŋa momooŋ tinimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Unduŋ tubune metam hogohogok adi titiŋge u kaŋ nadiŋa du kubugoŋdi kotigoŋ kedem yanagilaaŋ unduŋ u kedem nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Bepaŋ, nu adi metam hogohogokdi dutok nadifo tiŋa wohoge ganintiloneŋdok nadilat. Biyagoŋ, kwetkwet hatitawiiŋ hogohogok wanakaŋ hinek ganiutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Du titiŋ didimeniŋ tiŋa mede yodapmaŋ kwanai tilaŋ, tiŋa undugoŋ da kubugoŋdi metam yabu-ulidokoune talik momooŋ takaliiŋ. Wendoktiŋa metam hogohogok adi welemomooŋ nadiŋa kap toŋa nadifo kedem tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Bepaŋ, nu adi metam hogohogokdi dutok nadifo tiŋa wohoge ganintiloneŋdok nadilat. Biyagoŋ, kwetkwet hatitawiiŋ hogohogok wanakaŋ hinek ganiutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Bepaŋ adi indi’walaŋ Bepaŋnik, unduŋ doktiŋa kahaŋ tinimguk. Kaŋ kwetnineŋ duhuduhu momooŋ mintanimilak. ");
INSERT INTO nop_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Biyagoŋ hinek, Bepaŋdi nihikahaŋnegukdi nihikahaŋnelak, wendoktiŋa metam kwetkwet hatiiŋ hogohogokdi aditok gikiŋgoŋ timiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Bepaŋ adi pilap kedem bek, buŋa memikŋiye yehililiwenekulek. Meeniŋ Bepaŋdok mik timiiŋ adi yadi Bepaŋ kaŋ momoŋ tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Sububadi mupmuk fedikulune udapmalak, wendok tuwot Bepaŋdi memikŋiye yehililiwenekulek. Kale hinambaŋ kudup foloŋ henene datilitiliyeŋ imeŋiŋ boukula daliwelak wendok tuwot, metam hogohi adi Bepaŋ namanda foloŋ kadakaaŋ foneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Iŋgoŋ me didimehi adi nadifo tiŋa Bepaŋ dawineŋ welemomooŋ nadineeŋ. Tiŋa nadifo loloŋnit hinek tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Indi Bepaŋ wou nintiloloŋdok kap tonim. Adi yadi mulukwaŋ foloŋ looŋ ila yaulak. Talikŋiŋ tubudidimemineŋ. Adi’walaŋ wou adi Yahwe. Indi adi’walaŋ namanda foloŋ nadifo tiŋa kakali tinim. ");
INSERT INTO nop_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Bepaŋ adi ipilatŋiŋ gineŋ hali wapmihi kondiŋahi yabudokolak. Tiŋa undugoŋ tam kahat heki yehitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Eŋ me be tam nohik mokit nehi hogok hinek hatiiŋdok yot yemilak, kaŋ adi kulemaŋgoŋ hatiiŋ. Eŋ me yot fafaŋeniŋneŋ hakiiŋ u yehitubu-lodaune fooŋ wooŋ yohikwehineŋ kedem hatiiŋ. Iŋgoŋ me gifoko heki adi wooŋ kwet hogoli simintaneŋ hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Bepaŋ, du koom metamgeye talitimeŋ tiŋa yanagilune kwet fiileŋ wanaŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Bepaŋ, nai uŋaniŋ du buguŋ doktiŋa kwet tibitim tubune gwi wapum ukuk. Biyagoŋ hinek, Isilaehi’walaŋ Bepaŋ, du agaŋ buguŋ doktiŋa Sainai kweboboe adi tibitim tuguk. ");
INSERT INTO nop_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Bepaŋ, du gwi sifoge dilitombune ulaŋa kwet himintaŋ u tubukulemaguk. Eŋ da’walaŋ magemageye gweheye hinek tulune yehitubuhaikaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Kaŋ memetamgeye adi kwet uŋoŋ yokwet tiŋa ikiŋ. Du me fiyewakahidok momooŋ tiyemiŋa nanaŋe tiŋa nemek noli yemguŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Wapumdi metamŋiyedok welemomooŋ mede yeniŋguk, kaŋ tamwoi feedi mede u wooŋ yohautagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Mede u indiŋ, “Mapme heki tiŋa mikmehiye adi wanakaŋ hogohogok agaŋ momodapmaaŋ uŋit.” Kaŋ tamwoi yokwet gineŋ uŋoŋ hakiŋ, adiyeŋ adi mewoidi mik gineŋ bomboŋ begiŋ u danegiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Tamwoi adi silwa tiŋa gol u beŋa tinahukula bagi momooŋ hinek niŋ folooŋ adi silwa kudiŋiŋdi diweiŋ undiniŋ, eŋ papaliŋiŋ adi gol kudiŋiŋdi diweiŋ undihi, momohi hogok diweeŋ yakiŋ. Iŋgoŋ dediŋ doktiŋa me noli adi dompa heki’walaŋ gimbahaŋhik gineŋ uŋgoŋ haliŋa mik gineŋ mu yehitubu-lodagiŋ? ");
INSERT INTO nop_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Bepaŋ saŋiniŋ molomdi Salimon kweboboe foloŋ mapme heki yehikelekulune momopupuhenegiŋ kaŋ yabune gwi munilit munilit maguk. ");
INSERT INTO nop_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Basan kweboboe adi kweboboe wapum hinek, doktiŋa tuwaiŋiŋ fee hinek haliwiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Kweboboe tuwaige fee haliwiiŋ, du maŋgande Bepaŋ ne iitdok yoŋa kweboboe kahileguk u kaŋ nadihaŋinda tilaŋ? Yahwe adi helemahelemaŋ kweboboe wendok foloŋ hatiluwaak. ");
INSERT INTO nop_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Wapum adi Sainai kweboboe bikabuŋa buŋa yoli uŋgoniŋ gineŋ hatak. Adi mikmeŋiye mik diniŋ kali fafaŋehi tausen fee hinek dut buŋa hakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Bepaŋdi metam hogohogok yot fafaŋeniŋneŋ hakiiŋ u yahaŋedapmaaŋ kweboboe kweheyeniŋ hinek foloŋ gwaŋ loiŋ. Me gifoko heki mik timiŋgiŋ adi maaŋ siloŋ timiiŋ. Yahwe Bepaŋ adi kweboboe wendok foloŋ uŋgoŋ hatibaak. ");
INSERT INTO nop_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Indi Wapum wou nintilonim. Melenai indigoŋ tuwot indi’walaŋ malabumuŋnik hekilak. Bepaŋ ne kubugoŋdi nihitubu-lodaaŋ kotigoŋ ninigitak. ");
INSERT INTO nop_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Inde’walaŋ Bepaŋnik negoŋ nihitubu-lodalak kaŋ kedem hinek hatiyam. Tiŋa Yahwe, Wapumnik, negoŋ nihitubu-lodalak kaŋ kumuŋ mu tiyam. ");
INSERT INTO nop_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Bepaŋdi memikŋiye kihik ulitawa tibaak. Eŋ nediyeŋ gigine tiŋa kadakaniŋ uŋgoŋ hatibaak adi Bepaŋdi demei kitili utawa tibaak. ");
INSERT INTO nop_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Wapum, adi indiŋ yolak, “Nu memikhiye Basan uŋoŋ hakiiŋ u kotigoŋ yahaŋewene buneŋ. Adi imeŋgwaŋ kainiŋ hinek gineŋ duwaŋ hakiiŋ iŋgoŋ fiit kotigoŋ yanagilene buneŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","“Kaŋ hidi memikhiye u kisaŋ yehitubu-kadakaaŋ kedem welemomooŋ nadineŋ. Kaŋ hide’walaŋ kamohiyedi memik heki’walaŋ naŋgathik u himbitnakut tineŋ.” ");
INSERT INTO nop_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Bepaŋ, mapmene, metam hogohogok adi gabune mik gineŋ fafaŋe tiŋa widihidapmaaŋ nadifo titabulaŋ. Tiŋa metam wanakaŋ hinekdi gabune da yoke uŋgoniŋ gineŋ folaŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Me kap toiŋ heki adi koom uune, me gita ulune mede todok heki adi mindaŋ buune tamkuyahi tambalin ukiiŋ heki adi lekiŋgoŋ yali wiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Kap indiŋ toiŋ, “Bepaŋ’walaŋ metam indi agaŋ buŋa bopneyam, ale Bepaŋ wou nintilonim. Isilae’walaŋ yalakiŋiye indi Yahwe wou nintilonim.” ");
INSERT INTO nop_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Benjamin’walaŋ mebop-kabe adi koom wiiŋ. Kaŋ Judahi’walaŋ talitimeŋhiye tiŋa Judahi memetam adi Benjamin heki yehikeletawiiŋ. Kaŋ Sebulon tiŋa Naftalihi’walaŋ talitimeŋhiye adi mindaŋ biiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Bepaŋ, du saŋiniŋge miŋgoŋ tubudakaleune kanim. Du koom saŋiniŋ wendigoŋ nihitubu-lodaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Mapme heki adi siloŋ tigamdok bomboŋ moŋgola yokeneŋ Jelusalem uŋoŋ wiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Du Isip kale moiniŋ nabugoŋ dagik gineŋ fo-hatak u kedem nintobeŋ. Du metambop noli makau maahi wele tiiŋ be makau pamala wele tiiŋ u maaŋ yenintobeŋ. Yenintoŋa halu-haluu dutok mulelem tigamuŋa silwahik u dutok gamneŋ. Du metam mik tubupilatdok gigine kwanai tiiŋ heki u yehikelekulune momo-pupuheneneŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Isiphi’walaŋ mapmedi kwanai-meŋiye wapuhi yapmeune Jelusalemde wooŋ du’walaŋ medege nadineeŋ. Kaŋ Itiopiahi adi kohohik kwehene-belooŋ ganinadi tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Metambop noli, hidi maaŋ Bepaŋdok kap tomineŋ, unduŋ tiŋa wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Adi yadi kunum gineŋ uŋgoŋ hatilak. Kunum woŋ adi koomkwaha tububihila hakukdi hatak. U nadineŋ, Bepaŋ adi saŋiniŋnit hinek kutilak. ");
INSERT INTO nop_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Metam hogohogok hidi Bepaŋ’walaŋ saŋiniŋŋiŋ wapum hinek wendok yobihitneŋ. Adi yadi Isilaehi’walaŋ mapme. Indi yadi saŋiniŋŋiŋ wapum u kunum gineŋ uŋoŋ kayam. ");
INSERT INTO nop_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Isilaehi’walaŋ Bepaŋ adi yoli uŋgoniŋ gineŋ hatak wendoktiŋa indi yadi Bepaŋdok munta timinim. Adi yadi metamŋiyedok saŋiniŋ wapum hinek yemilak. Bepaŋ wou nintilonim. ");
INSERT INTO nop_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","O Bepaŋ! ime agaŋ labuŋa koditne foloŋ hinek itak ale nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Nu ime dagik wapum gineŋ folat. Uŋoŋ kwet fafaŋeniŋ niŋ yalikilitiŋa yalitdok nemoŋ. Tiŋa ime fuliŋmamaŋ gineŋ foliwene imegabuŋdi buŋa nehikufulawe tilak. ");
INSERT INTO nop_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Nu kutige kutige koditne hahakaleune agaŋ gweheye tilat. Tiŋa Bepaŋdi nehitubu-lodawek yoŋa daune diwege diwege daukukut tilat. ");
INSERT INTO nop_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Memik hogok tinamfit tiiŋ heki’walaŋ kunakunathikdi mebine dumuniŋ kalakapmedapmaŋ tilak. Memikneye adi yalaŋ mede hogok naniŋfit tiŋa nulukumuŋ titiŋdok fafaŋe kwanai tiiŋ. Tiŋa undugoŋ, nu adi’walaŋ nemek nemu kubonegut iŋgoŋ yalaŋ yoŋa naniŋgigineune na’walaŋ bomboŋne yemilat. ");
INSERT INTO nop_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Bepaŋ, du agaŋ nadinamulaŋ, nu me didimeniŋ mooŋ. Kadakaniŋne du namandake foloŋ hebihat mu tilak. ");
INSERT INTO nop_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","O Yahwe, Saŋiniŋ Molom, metam dutok woomuŋa nadikunakunale tiiŋ adi nutok tiŋa meka tineeneŋ ala nehitubu-lodaweŋ. Isilaehi indi’walaŋ Bepaŋ, metam du ganiutumbaiŋ hekidi nu’walaŋ malabumuŋ doktiŋa adi meka mu tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Nu du gehikelelat, unduŋ doktiŋa meeniŋdi nanimpekit tiŋa nehitubu-meka tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Datneyedi nabiiŋ kaŋ nu adi me gitipmuŋ nabugoŋ tilat, eŋ na’walaŋ naŋgat dikineyedi nabiiŋ kaŋ nu adi me niŋkadeniŋ unduŋ tilat. ");
INSERT INTO nop_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Nu du’walaŋ yokedok tiŋa welene kudup daaŋ dahihinek tilak. Kaŋ du ganiŋkadakaaŋ medehaki ganiiŋ u buŋa nu foloŋ lolak. ");
INSERT INTO nop_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Nu dauge foloŋ natok nadiwe fofoŋnit tubune nanaŋe kamehep tilat. Iŋgoŋ oŋ, metamdi naniŋkadakaaŋ medehaki naniiŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Nu bulaniŋgoŋ diniŋ bomboŋ tinahukutat kaŋ metamdi medehaki naniŋa nanimpekit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Meeniŋ wawalineŋ bop tiŋa nu naniwoliwolike tiiŋ. Kaŋ me ime fafaŋeniŋ naaŋ nadibubuye tiiŋ heki adi nutok kap hogohi tonamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Iŋgoŋ oŋ, Yahwe, nu adi du ganinadilat. Ala nai niŋ, Bepaŋ da kameguŋneŋ, uŋaniŋ yonadine tubu-udanenambaaŋ. Maŋgande, welegedi hinek nabukahilelaŋ doktiŋa kotigoŋ nanagitdok yofafaŋe tuguŋ, u yalaŋ mooŋ, u biyagoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Du ime dagidagik gineniŋ kotigoŋ nanagilune nu uŋoŋ mu wopmabula fiilit. Da nabudokoune memik hekidi mu nehitubu-kadakaneŋ, be ime fuliŋgoŋ wondi tuwot mu nehikumuyewek. ");
INSERT INTO nop_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Du binabune imegabuŋdi mu nula-nehihamanti wek, be binabune ime fuliŋgoŋ wendok gineŋ fiile meyotneniŋ koŋdi mu nehikumuyewek. ");
INSERT INTO nop_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Yahwe, du helemahelemaŋ welegedi hinek nabukahilelaŋ, woŋ adi momooŋ hinek, doktiŋa yonadine tubu-udanenambeŋ. Tiŋa undugoŋ, siloŋ tobogoŋ tinamulaŋ unduŋ doktiŋa kedem buŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Nu kwanai-mege, unduŋ doktiŋa du namandake kufulahebi mu tibeŋ. Nu adi malabumuŋne wapum, unduŋ doktiŋa yonadine pilap hinek tubu-udanenambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Du yamaiŋgoŋ buŋa kotigoŋ nanagileŋ. Memikneye kohohik gineniŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Du me nutok medehaki naniiŋ u agaŋ yabunadilaŋ. Tiŋa undugoŋ memikneye nehitubumekaaŋ nadinambune fofoŋnit tilat u maaŋ agaŋ yabunadilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Mede kadakahi wondi nadinadine tubukadakalak tiŋa welemulap kisaŋ hinek namulak. Kaŋ wondoktiŋa saŋiniŋne dapmaune saŋiniŋ lohilat. Meeniŋ nolidi nutok bulaniŋgoŋ neeŋbe nadinamneŋ yoŋa nadigut, iŋgoŋ nebek niŋdi nutok bulaniŋgoŋ nemu nadiguk. Be meeniŋ nolidi mede momohi neeŋbe nanimbune welekulema tubumintait yoŋa nadigut, iŋgoŋ u maaŋ moŋ iŋgoŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Nanaŋe map tilat kaŋ haguwo upmuŋnit namiiŋ. Eŋ mane galiune ime buukaaŋ namiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Unduŋ doktiŋa hinamunidok bopneune kaŋ begepdi kale utak wendok tuwot, be koŋ niŋ gineŋ maaŋ foiŋ wendok tuwot nadifo nai u tubutakaleune nai kadakaniŋ mintayemdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Dauhik tubusububaune dau diwe koti tuwot mu taneeŋ. Eŋ sigihik wobugenimbaune koloŋ didimeniŋ tuwot mu yakaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Kwihitage u adi foloŋ kwaneweŋ, eŋ welege kudup dalak wendi adi foloŋ looŋ yehitubu-liwe tibek. ");
INSERT INTO nop_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Yokwet adi hatiiŋ u meeniŋ mokit hamap kedem halaak, eŋ yohineŋ uŋoŋ meeniŋ kaipmuŋ nemu halaak hinek. ");
INSERT INTO nop_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Du me koom kadakaniŋhik doktiŋa widihitubu-didime tuguŋ u me kadakahi woŋdibo widihitubu-figita tiiŋ. Eŋ kumundegoŋ widihiguŋ u kotigoŋ me kadakahidibo yeniŋfoko tubune folofigita nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Unduŋ doktiŋa du adi’walaŋ kadakaniŋhik u nadikaule adi mu tiyembeŋ. Tiŋa biyabune da’walaŋ metamgeye hatihati dapmandapmaŋnit mokit hatiiŋ adi’walaŋ baŋamhik gineŋ adi mu hinek foneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Tiŋa wohiye hatihati fafaŋeniŋ diniŋ pepa foloŋ hatak u tumolokut tiyembeŋ. Unduŋ tiŋa adi’walaŋ wohiye u metam didimehi’walaŋ wohiye gut mu kameweŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Iŋgoŋ nu adi folofigita eŋ welemulap gineŋ hatat. Ale Bepaŋ, du kotigoŋ nanagila nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Nu kap toŋa Bepaŋ wou nintilowit, tiŋa welemomooŋ nadimiŋa niutumbaaŋ wougigitŋiŋ yotubuhautawit. ");
INSERT INTO nop_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Biyagoŋ hinek, nu makau folooŋnit Yahwedok hemundumunduŋe timimbene nadinambune utumba tilak, iŋgoŋ kap toŋa niutumbaaŋ wougigitŋiŋ yohauta tibe u kaune utumba hinehinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Memetam malabumuŋ nadiiŋ adi u kaŋ nadifo tineŋ. Kaŋ metam Bepaŋ niutumbaiŋ heki adi saŋiniŋ koti kedem moŋgotneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Yahwe adi metam nemenemekdok baniŋ tiiŋ heki’walaŋ yonadihik nadiyemilak, tiŋa undugoŋ metamŋiye folofolok fafaŋeniŋ gineŋ hakiiŋdok nadikaule mu tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Kunumkwet eŋ imeŋgwaŋ tiŋa pisi be nemenemek maaneŋ hatiiŋ hogohogok, hidi wanakaŋ Bepaŋ wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Maŋgande, Bepaŋ adi Saiyonhi metam hogohogok memik kohohik gineniŋ kotigoŋ yanagilaak, tiŋa Judahi’walaŋ yokwet wapuhi kotigoŋ yehitubu-pilalaak. Unduŋ tubune Bepaŋ’walaŋ metam hogohogok adi yokwet wapuhi gineŋ uŋoŋ kulemaŋgoŋ hatiŋa kwet u yabukahile-dapmaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Bepaŋ tipilapilayeŋiye’walaŋ yalakihiyedi kwet u kahileneeŋ, eŋ metam Bepaŋdok nadigalika tiiŋ heki adi kwet uŋakoŋ kahileeŋ hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Bepaŋ, du kotigoŋ kedem nanagileŋ. Yahwe, du pilap buŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Me nolidi nulukumuŋ tine tiiŋ. Ale du yehimoŋgofoune nadigiyondaaŋ meka tineŋ. Me noli adi nu’walaŋ malabumuŋnedok nadifo tiiŋ. Ale du yehikelekulune kotigoŋ uneŋ, kaŋ nadiyembune wohiyehinit mokit fofoŋhinit mintaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Meheki i nanimpekit tiiŋ, doktiŋa yehitubu-meka hinek tibeŋ, kaŋ adi nehi’walaŋ titiŋhik u kaŋ boho tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Iŋgoŋ metam du’walaŋkade wiiŋ heki adi yadi welemomooŋ kedem nadiŋa dutok nadifo tineŋ. Metam hogohogok da kotigoŋ yahaŋeguŋ, kaŋ adi kwanaige tuguŋ u kaŋ nadigalika tiiŋ, adi yadi helemahelemaŋ indiŋ yoyaneeŋ, “Bepaŋ adi loloŋnit hinek.” ");
INSERT INTO nop_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Bepaŋ, nu adi gweheyeŋ tiŋa nu na nemek niŋ tibitdok tuwot mokoŋ. Unduŋ doktiŋa pilap hinek nu’walaŋkade iŋgoŋ beŋ. Yahwe, da kubugoŋdi nehitubu-lodaaŋ kotigoŋ nanagitaŋ. Unduŋ doktiŋa du woomhat mu tibeŋ, adi pilap hinek nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Yahwe, du nabudokoweŋ yoŋa du’walaŋkade bulat. Unduŋ doktiŋa memik heki biyabune mu nehitubu-mekaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Du adi didimeniŋ hinek, unduŋ doktiŋa memik heki’walaŋ kohohik gineniŋ nanagileŋ. Eŋ yonadine nadiŋa kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Du adi gimbahaŋ fafaŋeniŋ nabugoŋ, eŋ yot fafaŋeniŋ nabugoŋ maaŋ. Nu uŋoŋ fooŋ halene nabudokoweŋ, maŋgande, da kubugoŋdi hebihat kwetne tiŋa yahehewene. ");
INSERT INTO nop_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Bepaŋne, du me hogohi’walaŋ kohohik gineniŋ nanagileŋ. Adi yadi wombuŋolohi tiŋa titiŋhik kadakaniŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Yahwe, nu adi du hogok nadisukilitigamulat. Me kuyane gineŋ tububihila nadikunakunale-gamgutdi nadikunakunalegamulat. ");
INSERT INTO nop_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Maŋdi nanagikuk nai uŋaniŋ tububihila nabudokoguŋdi nabudoko-tabubuyeeŋ kobuk i busuwalaŋ. Kaŋ nu adi du’walaŋ kohoge foloŋ hogok hatitabulat. Unduŋ doktiŋa nu wohoge helemahelemaŋ ganintiloluwaat. ");
INSERT INTO nop_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Metam feedi nu’walaŋ hatihatine gineŋ nemek mintagiŋ u kanadi tigiŋ, tiŋa du kubugoŋdi fafaŋeniŋ hinek nabudokolaŋ u nadidakalegiŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Helemahelemaŋ ganintilooŋ wohogegigit yohautaaŋ ganiutumbalat. ");
INSERT INTO nop_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Nu kobuk agaŋ gawada tiŋa saŋiniŋne maaŋ agaŋ folak, unduneŋ ale du tiyaugene sigilulum tiŋa mu binabuluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Memik heki adi nulukumuŋdok yoŋa bopneeŋ mede yodobu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Adi indiŋ yoiŋ, “Bepaŋ agaŋ bikabuŋak, kaŋ adi tubulodadok nebek nemu hatak doktiŋa kedem keleeŋ honenim.” ");
INSERT INTO nop_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Unduneŋ doktiŋa Bepaŋ du binabuŋa kweetniŋ mu haleŋ. Bepaŋne, du pilap hinek buŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Meheki nehikele tiiŋ heki u yehimoŋgofooŋ yehitubu-kadaka tibeŋ. Tiŋa undugoŋ nehitubu-kadaka tine tiiŋ heki u yehitubu-giyondaaŋ yehitubu-mekahinaka tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Iŋgoŋ nu adi helemahelemaŋ du hogok nadisukilitigamuŋa nehitubu-lodaweŋ yoŋa woom hatilat. Unduŋ doktiŋa nu adi wohoge ganintilohinaka tibit. ");
INSERT INTO nop_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Nu du titiŋ didimeniŋ tuguŋ u metam yenihautawit. Nu adi du nemek tuguŋ hogohogok wendiniŋ mebi mu nadidakalehinakalat, iŋgoŋ fiit helemahelemaŋ adi kotigoŋ nanagikuŋ wendok yeniluwaat. ");
INSERT INTO nop_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Yahwe Bepaŋ, nu du’walaŋ saŋiniŋge wendok nadiŋa wohoge ganintilowit. Tiŋa mede indiŋ yohautawit, “Wapum hogokdi didimeniŋ.” ");
INSERT INTO nop_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Bepaŋ, nu kuyanineŋ tububihila nanindidimeguŋdi nanindidimelaŋ, kaŋ nu adi du nemek momohi-momohi tuguŋ wendok uŋgoŋ hati yohautalat. ");
INSERT INTO nop_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Kaŋ kobuk ya agaŋ kine hapmuŋ gwahakat tilak, iŋgoŋ Bepaŋ, du mu binabeŋ. Du nukut hatibune nu metam mindaŋ mintaneeŋ heki u du’walaŋ saŋiniŋgedok yenihautawe nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Bepaŋ, titiŋge didimeniŋ adi kwetkwet tuwot kilidapmaaŋ hatak, tiŋa undugoŋ meeniŋ namandahik foloŋ miŋgilaŋgoŋ hatak. Du kwanai wapum hinek tuguŋ. Nebek niŋdi Bepaŋ dutok tuwolit nemoŋ hinek. Du kubugoŋdi yalakapmedapmaŋ tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Du malabumuŋ mebimebi tubumintanamguŋ. Iŋgoŋ kotigoŋ nehitubu-kilitibaaŋ u agaŋ nadilat. Woŋ adi meyotneŋ halene kotigoŋ nanagitaŋ wondok tuwolit tibaak. ");
INSERT INTO nop_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Unduŋ tiŋa wotnegigit tubuhautawaaŋ, eŋ kotigoŋ welekulema tubumintanambaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Nu gita ulaŋa wohoge ganintilowaat. Bepaŋne, du adi mu binabulaŋ eŋ medege adi biyagoŋ hogok, unduŋ doktiŋa nu wohoge ganintiloit. Isilaehi’walaŋ Bepaŋ, du adi titiŋ momooŋ eŋ titiŋ didimeniŋ hogok tilaŋ. Wendoktiŋa nu gita ulaŋa kap toŋa wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Nu gita ulene mede momooŋ tobune nadifo tiŋa kakali tibit. Du kotigoŋ nanagikuŋ doktiŋa nu kap manedi hogok mu togambit. Mokoŋ. Nu adi welene eŋ nadinadine bunit togambit. ");
INSERT INTO nop_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Du me nehitubu-kadaka tine tigiŋ heki u yehimoŋgofooŋ yehitubu-meka tuguŋ. Unduŋ doktiŋa nu helemahelemaŋ metam du’walaŋ titiŋge didimeniŋ wendok yeniluwaat. ");
INSERT INTO nop_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Bepaŋ, du me mapme titiŋ didimeniŋge u momooŋgoŋ nindidimeweŋ. Kaŋ adi mede nadinadi kwanai didimeŋgoŋ tuluwaak. Du adi mede nadinadi kwanai didimeŋgoŋ hinek tilaŋ, wendok tuwot me mapme i maaŋ tubulodaune mede nadinadi kwanai didimeŋgoŋ hinek tuluwaak. ");
INSERT INTO nop_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Unduŋ tiŋa metamgeye be metam fiyewakahi titiŋ didimeniŋ tiŋa yabudokoluwaak. ");
INSERT INTO nop_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Du yadi kwanaihik tineeneŋ nemenemek momohi tubumintayembaaŋ. Tiŋa metam yehitubu-lodaune adi titiŋ didimeniŋ keleeŋ taneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Me mapmedi me fiyewakahi’walaŋ malabumuŋhik u kedem tubudidimeluwaak, be me nemenemekdok baniŋ tiiŋ u kedem yehitubu-lodaluwaak. Tiŋa undugoŋ me noli yehitubu-kadakadok tiiŋ me undihi u maaŋ yehimoŋgofoluwaak. ");
INSERT INTO nop_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Mele muyakipdi hautalune metamgeyedi wendok tuwot ganiutumbayaneeŋ. Unduŋ hati titaulune nai dapmawaak. ");
INSERT INTO nop_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Du me mapme tubulodaune me momooŋ mintawaak, kaŋ titiŋŋiŋdi gwi maune dinina gineŋ nanaŋe momooŋ labiiŋ undiniŋ tibaak. ");
INSERT INTO nop_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Adi’walaŋ naiŋiŋ gineŋ metam adi titiŋ didimeniŋ hogok keleeŋ hatineeŋ. Eŋ muyakip hadiwe tulune nemenemek momohi u kedem mintawaak. ");
INSERT INTO nop_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Adi me mapme hatiŋa imeŋgwaŋ yamaiŋgoŋ haliwooŋ kweetniŋ hadapmalakneŋ metam hogohogok u wanakaŋ yabudokowaak. Eŋ adi’walaŋ kwetŋiŋ diniŋ fek adi Yufeletis ime foloŋ tububihilune wooŋ kwetkwet udapmawaak. ");
INSERT INTO nop_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Metam kwet simintaneŋ hatiiŋ adi mapme wendok mulelem timineeŋ. Kaŋ memikŋiye adi kwetfoloŋ maaŋ kwam naneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Kaŋ Spein diniŋ me mapme tiŋa imeŋgwaŋ gineŋ kwet kambaŋgit ila wiiŋ diniŋ me mapme heki adi siloŋ timineeŋ. Eŋ Alabiyahi’walaŋ me mapme tiŋa Itiopiahi’walaŋ me mapme adi takis aditok moŋgola buneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Me mapme hogohogok aditok mulelem timineeŋ. Kaŋ metam hogohogokdi adi’walaŋ kwanai tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Adi me fiyewakahidi yehitubu-lodadok kutiniiŋ kaŋ yehitubu-lodalak. Be metam nemenemekdok baniŋ tiiŋ, kaŋ nebek niŋdi nemu yehitubu-lodaiŋ u negoŋ yehitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Adi metam saŋiniŋhinit mokit fiyewakahi hatiiŋdok bulaniŋgoŋ nadiyemilak. Tiŋa metam nemenemekdok lohilohi tiiŋ heki aditok hatihati tubumintayemilak. ");
INSERT INTO nop_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Kaŋ memik heki adi yalaŋ yoŋa kisaŋ hinek yehitubu-kadakaaŋ yehimoŋgofofoŋdok tiiŋ iŋgoŋ kotigoŋ yahaŋelak. Biyagoŋ hinek, Bepaŋdi me fiyewakahi weleŋdi hinek yabukahilelak, tiŋa adi’walaŋ kumuŋhik woŋ adi nadiune nemek haŋaniŋgoŋ mu tilak. ");
INSERT INTO nop_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Me mapme adi nai kweheyeniŋ kedem hatibaak, kaŋ Alabiyahidi gol kedem mineeŋ. Eŋ Bepaŋdi momooŋ timindok metamdi ninadi kwanai tineeŋ, kaŋ Bepaŋdi helemahelemaŋ momooŋ timiluwaak. ");
INSERT INTO nop_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Pandiŋ tiŋa nanaŋe noli Lebanon uŋoŋ duhuduhu mintalak undugoŋ hinek metam’walaŋ dininahik gineŋ mintawek. Kaŋ yokwet wapumneŋ metam mohok kilihikitdi kwetkwet mintalak wendok tuwot mintaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Kaŋ metamdi mapme wou tuwot mu kauleneeŋ, adi meledi labu diweluwaak indigoŋ tuwot me mapme wou nintiloyaneeŋ. Kaŋ metam hogohogokdi Bepaŋ ninadiune me mapmedok momooŋ timilak unduŋ tiŋa yehikahaŋneeŋ momooŋ tiyembek. ");
INSERT INTO nop_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Yahwe’walaŋ wou nintilonim, Isilaehi’walaŋ Bepaŋ. Ne kubugoŋdi nemenemek uŋgoniŋ hogohogok u tilak. ");
INSERT INTO nop_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Wou momooŋ u dapmandapmaŋnit mokit nintiloloŋdok. Biyagoŋ hinek, wougigitŋiŋdi kwetkwet kedem udapmawek. U biyagoŋ. ");
INSERT INTO nop_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Jesi mihiŋiŋ Dewit’walaŋ ninadiŋiŋ agaŋ iŋgoŋ budapmalak. ");
INSERT INTO nop_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Bepaŋ adi Isilaehidok momooŋ tiyemilak, eŋ metam welehik geŋgeŋnit mokit, walahi hinekdok maaŋ undugoŋ momooŋ tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Iŋgoŋ muniniŋ nu agaŋ kadakaniŋ gineŋ mawene tiŋat. Nu adi kayone yalisulukeneeŋ maaŋ nule tiŋak wendok tuwot nadisukilitine bikabe tiŋat. ");
INSERT INTO nop_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Nu me fokohinit’walaŋ bomboŋhik u yabunadigalika tiŋat, tiŋa me hogohi’walaŋ hatihatihik fofooŋ wendoktiŋa unduŋ tiŋat. ");
INSERT INTO nop_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Adi yadi foloohik gineŋ folofigita nemu nadiiŋ. Adi yadi me fafaŋehi, tiŋa foloohik adi kedehi hogok. ");
INSERT INTO nop_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Adi yadi nemek niŋdok lohilohi be malabumuŋ mebimebi nemu mintayemiiŋ. Meeniŋ noli malabumuŋ mebimebi mintayemiiŋ, iŋgoŋ adi yadi nemek undihi nemu mintayemiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Unduŋ doktiŋa adi nehitok nadiune loloŋ tilak u metamdi miŋgoŋ kakaŋdok nadifo tiiŋ. Unduŋ tiŋa me noli hogok widihifit tiŋa yehitubu-kadakaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Welehik eŋ nadinadihik gineŋ adi kadakaniŋ mebimebi titiŋdok nadigalika tiiŋ u ha-tubumintaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Adi yadi meeniŋ noli yenimpekit tiŋa aditok adi titiŋ kadakaniŋ tiyemdok yoiŋ. Adi yadi foko hinek tiŋa metam noli yehitubu-kadakadok talik lohiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Bepaŋ kunum gineŋ hatilak aditok medehaki niiŋ. Unduŋ tiŋa nehi wohiye yotilooŋ metam kwetfoloŋ hatiiŋdi adi’walaŋ nadinadi takalineŋ yoŋa yeniŋgigine tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Kaŋ Bepaŋ’walaŋ metamdi me gifoko heki’walaŋ medehik nadigalikaaŋ adi’walaŋ medehik uŋak nadisukilitiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Me kadakahi wendi indiŋ yoiŋ, “Bepaŋ adi nemek indi tam i tuwot mu nadiwek. Bepaŋ loloŋnit hinek adi indi’walaŋ titiŋnik tubumintadok talik nemu halimilak.” ");
INSERT INTO nop_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Me kadakahi adi indihi. Adi nemenemehik tuwot, iŋgoŋ kotigoŋ tomboyoula nemenemek noli maaŋ ha moŋgokiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Nu adi nadinadiŋila hatibene welenedi kadakaniŋnit mokit momooŋ hatak. Unduŋ tiŋa kadakaniŋ nemu tugut. U tugut u nemek folooŋ mokit hogok tifit be tugut? ");
INSERT INTO nop_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Kaŋ maŋgande, Bepaŋ, du folofigita helebufa namulaŋ, tiŋa haniŋ hogohogok malabumuŋ namulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Nu me nolidi mede yoiŋ undugoŋ binek yolit woŋ adi metamgeye walanedi yabukahile mu tilit. ");
INSERT INTO nop_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Nu nadibedi tiŋa nemek wendiniŋ mebi tubumintait yoŋa tilat. Iŋgoŋ kwanaimiŋ hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Bepaŋ, nu tikatika tiŋa uge uge yoke uŋgoniŋ gineŋ folat. Tiŋa du yoke uŋgoniŋ maaneŋ uŋoŋ haliŋa nadinadine dakaleune me kadakahidok maŋgoŋ hinek mintayembaak u agaŋ nadilat. ");
INSERT INTO nop_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Dagoŋ nadiyembune adi talik sulukeneŋ gineŋ yawiiŋ. Eŋ dagoŋ tilaŋ kaŋ adi kisaŋ hinek maaŋ widihikadakalak. ");
INSERT INTO nop_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Adi pilap hinek kadakaiŋ, doktiŋa adi’walaŋ kumuŋhik wendi hogoli hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Wapum, adi yadi me niŋdi timiŋ lihine tilak ala haniŋ lihine u dambek fiila ulak undihi. Ala du pilalune adi lihine dabugoŋ liwe tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Nai uŋaniŋ nadinadine pilalune welene adi agaŋ moŋ hinek nadiŋat. ");
INSERT INTO nop_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Unduŋ tiŋa nadinadine tehedapmaune, nu du’walaŋ titiŋge u mu nadidakalelat. Tiŋa namandake foloŋ titiŋne tilat u yadi kale moiŋ nadinadinit mokitdok tuwolit tilat. ");
INSERT INTO nop_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Iŋgoŋ nu helemahelemaŋ dukut hatilat kaŋ du kohone didimeniŋ foloŋ honelaŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Du adi talik didimeŋgoŋ yaudok mede momooŋ nanilaŋ, ala kougoŋ nanagilune dukut kunum gineŋ hatidemeet. ");
INSERT INTO nop_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Kunum foloŋ nebek noli nimaaŋgoŋ be hatiŋa nabudokolak? Nebek noli nemoŋ, da kubugoŋ hogok. Unduŋ doktiŋa Bepaŋ, nu adi gabuŋa nadigalika tilat. Nu dutok hinek nadilat unduŋ e nemenemek kwetfoloŋ diniŋ yendok unduŋ hinek mu nadilat. ");
INSERT INTO nop_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Foloone be nadinadinedi saŋiniŋ mokit tubune kaŋ, Bepaŋ du da kubugoŋdi saŋiniŋne tibeŋ. Unduŋ tiŋa du nukut hatibune nu helemahelemaŋ tuwot hinek tiŋa hatiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Biyagoŋ hinek, metam du sigilulum tigamiiŋ heki adi liwedapmaŋ hinek tineeŋ. Kaŋ meeniŋ koom du gehikelegiŋ, iŋgoŋ kobuk agaŋ bigabugiŋ, adi heki adi yehitubu-kadaka tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Iŋgoŋ nu adi gehitubu-dula hinek tiŋa yamaiŋgoŋ hatat, u adi momooŋ hinek. Yahwe Bepaŋ, nu wooŋ hebihat titiŋdok kwetne adi da kubugoŋ. Kaŋ nu du nemenemek hogohogok tuguŋ u yohautawit. ");
INSERT INTO nop_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Bepaŋ, du maŋgoŋde sigilulum tinimilaŋ? Metam dompageye inditok kwihita helemahelemaŋ-kube tiluwaaŋ? ");
INSERT INTO nop_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Du metamgeye inditok kotigoŋ nadinimbeŋ. Du koomkwaha indi da’walaŋ metamgeye hinek yoŋa nibukahileguŋ. Dagoŋ nihituwaguŋ kaŋ indi du’walaŋ mebop mintaaŋ hatiyam. Du koom Saiyon kweboboe foloŋ indi gut hatiguŋ u kotigoŋ nadisuweŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Memikniyedi Siloŋyotneŋ nemenemek hogohogok u yehitubu-kadakadapmaŋ tigiŋ. Ale du buŋa nemek i kadakaaŋ haliulak i kaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Memikgeye adi du yoke uŋgoniŋ u kahileeŋ hali gibitaŋ kakaliŋa nemek kaka tigiŋ. Adi du’walaŋ nemenemek u bekula wendok kibikoŋ nemek nehi’walaŋ fekhikhinit uŋak boigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Adi me behepneŋ wooŋ kudup ulitawa tiiŋ nabugoŋ, du yoke uŋgoniŋ’walaŋ bem heki u finaŋgondi fitubukadaka taugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Palaŋ kudikudihinit fiŋa ulaugiŋ u memik hekidi finaŋgon eŋ kwadi wapuhidi beŋa ubulaginetaugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Adi yoke uŋgoniŋ u kudup kulahegiŋ. Adi titiŋ hogoli hinek tiŋa kwet momooŋ da hatidok kahileguŋ u tubukadakagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Adi yadi nihibefofoŋ hinek titiŋdok nadigiŋ doktiŋa Bepaŋ’walaŋ bopyot hogohogok indi’walaŋ kwetnineŋ yali ugiŋ hogohogok u wanaŋ kulahedapmaŋ titaugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Da titiŋge uŋgoniŋ diniŋ fek nimguŋ hogohogok uyadi agaŋ beyakudapmagiŋ. Kaŋ kobuk polofet nemu hatinimilak. Tiŋa indi’walaaniŋ nebek niŋdi malabumuŋ i nai deniŋ hinek dapmawaak u maaŋ mu nadilak. ");
INSERT INTO nop_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Bepaŋ, nai dedigoŋ hinek memikniye adi ninimpekit tihatineeŋ? Adi helemahelemaŋ du wohoge yotifooŋ ganiŋkadaka kube tiyaneeŋ? ");
INSERT INTO nop_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Maŋgoŋde tiŋa du indi nihitubu-lodadok mu nadilaŋ? Du maŋgoŋde nibukabeleŋ saŋiniŋge kahilelaŋ? ");
INSERT INTO nop_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Iŋgoŋ Bepaŋ, du koomkwaha tububihila mapmenik hatiguŋdi kobuk maaŋ undugoŋ hatinimilaŋ. Tiŋa nai fee hinek mik gineŋ nihitubu-lodaune mu nihitubu-kadakagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Da’walaŋ saŋiniŋge gineŋ imeŋgwaŋ wapum u ulopmadiune imedi dombuŋgolooŋ fukufukuŋ looŋ yakumuk. Unduŋ tiŋa Isiphi imeŋgwaŋ diniŋ pisi wapuhi nabugoŋ bugiŋ u yehitubu-kadakadapmaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Unduŋ tiŋa yeguŋ e’, Isiphi’walaŋ talitimeŋhik u fowa mebi nabugoŋ ulitawaguŋ, unduŋ tiŋa folooŋ u kale kwet fiileŋ kiŋ hogok foloŋ itougiŋdok yembune nagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Dagoŋ nadiguŋ kaŋ ime kuyahi kwetfoloŋ sila labuŋa woditaugiŋ. Eŋ dagoŋ nadiune ime wapuhi hahali u naŋgat tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Dagoŋ yoguŋ kaŋ hauta tiŋa mambip mintagumuk, eŋ mele dut muyakip foloniŋ iitdok nadiyemguŋ indigoŋ tuwot ikamuk. ");
INSERT INTO nop_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Tiŋa kwetkwet haliulak indigoŋ fekhik tuwotuwot hinek kamekwambundaguŋ kaŋ hatak. Unduŋ tiŋa gulet indigoŋ tuwot gwi nai eŋ mele nai kameguŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Yahwe, du kaule mu tibeŋ. Memikgeye adi ganimpekit hati tiiŋ. Adi yadi me bubuyehi nadinadihinit mokit nabugoŋ, doktiŋa dutok adi nadigambune nemek fiit nabugoŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Metamgeye adi saŋiniŋhinit mokit. Unduneŋ doktiŋa du tiyaugene mu binibiluwaaŋ, du unduŋ nobu tibeŋ adi memik heki yendi nihitubu-kadaka hinek-ku tineŋ oŋ. Memik heki adi metamgeye indi kisaŋ hinek nihitubu-kadakaiŋ. Unduŋ doktiŋa fiit du inditok nadikaule adi mu tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Indi’walaŋ kwetnineŋ adi meeniŋdi mik hogok kaka tiŋa wooŋ hebihatiiŋ. Unduŋ doktiŋa du koom indi gut yofolok tuguŋ u kotigoŋ nadisuweŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Du me kadakahi u biyabune meeniŋ noli yehiyali-moŋgofohinaka hinek adi mu tineŋ. Du me fiyewakahi nemenemekdok baniŋ tiiŋ u yehitubu-lodaweŋ, kaŋ adi wohoge kedem ganintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Bepaŋ, dubo pilaleŋ ale, pilali memik heki u yabeŋ. Me fokohinit u helemahelemaŋ ganimpekit tiiŋ ale dubo u nadisuweŋ! ");
INSERT INTO nop_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Memikgeye adi yadi mede wapum toŋgiyondaaŋ medehaki ganiiŋ. Adi yadi helemahelemaŋ kutifiyeyat hogok ya-tiiŋ. Ale Bepaŋ, du yadi titiŋhik wendok kaule adi mu tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Bepaŋ, indi welemomooŋ nadigamuŋa helemahelemaŋ ganiutumbayam. Unduŋ tiŋa indi wohogegigit u yohautayam, tiŋa nemenemek momooŋ tuguŋ wendok maaŋ kahat tiyam. ");
INSERT INTO nop_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Bepaŋ adi indiŋ yolak, “Nu mede nadinadi kwanai titiŋdok nai u agaŋ yodapmawene hatak. Kaŋ nu mede nadinadi kwanai tibaat woŋ adi fai nemu tibaat, didimeniŋgoŋ hinek tibaat. ");
INSERT INTO nop_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","“Kwet tiŋa metam wendok foloŋ hatiiŋ, adi yadi kedem yehimahamulak. Iŋgoŋ kwet kainiŋ hinek haulolooŋ tilak woŋ adi na honeeŋ halene fafaŋe tiŋa halaak. ");
INSERT INTO nop_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","“Nu me gifoko heki indiŋ yeniŋgut, ‘Hidi foko mu tineŋ.’ Eŋ me kadakahidok indiŋ yeniŋgut, ‘Hidi hide’walaŋ wohiyedok nadiune loloŋnit mu tibek. ");
INSERT INTO nop_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Hidi hide’walaŋ saŋiniŋhikdok nadifo mu tineŋ. Tiŋa undugoŋ, hidi mede wapum toŋa nanimpekit adi mu tineŋ.’” ");
INSERT INTO nop_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Metam’walaŋ titiŋhik kameka titiŋdok kwanai woŋ adi mele labulakneŋkade be mele fohebilakneŋkade, be kwet fiileŋ mu mintalak. ");
INSERT INTO nop_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Bepaŋ ne hogokdi titiŋnik kameka tilak. Adi negoŋ me noli nadiyembune fofoŋnit tiiŋ, eŋ me nolidok nadiyembune loloŋnit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Wapum adi kohoŋ foloŋ ime gitnaŋ tout niŋ honeeŋ itak. Uŋoŋ kwihitaŋiŋ diniŋ wain ime fafaŋeniŋ hinekdi tokiŋa itak. U kweheune me kadakahi hogohogok adi u silotnaaŋ silotnadapmaŋ hinek tiiŋ. Wondok tuwolit hinek metam kadakahi adi yadi Bepaŋdi mede nadinadi kwanai tibaakneŋ uŋoŋ wooŋ tuwot mu saŋindaneeŋ, mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Iŋgoŋ nu adi helemahelemaŋ Jekop’walaŋ Bepaŋ u miŋgilaŋgoŋ yotubuhautaluwaat. Unduŋ tiŋa wou nintilooŋ kap mohok tomiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Bepaŋdi me kadakahi’walaŋ saŋiniŋhik u yolom-moŋgolaak, eŋ me didimehidok adi toboniŋ saŋiniŋ wapum hinek yembaak. ");
INSERT INTO nop_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Judahi adi Bepaŋ nadimihinaka tiiŋ. Kaŋ Isilaehi adi wougigitŋiŋ u yotiloiŋ. ");
INSERT INTO nop_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Yoli adi Jelusalem uŋoŋ yatak. Kaŋ ne yadi Saiyon kweboboe foloŋ uŋoŋ itoulak. ");
INSERT INTO nop_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Adi kwet uŋoŋ memik heki’walaŋ tebe kaŋguma, kweletalak eŋ miknoŋhik wobugolokuyemilak. Bepaŋdi mik bomboŋhik hogohogok u agaŋ yehitubu-kadakadapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Bepaŋ, du yadi wohogegigitnit, tiŋa mapme loloŋnit hinek. Du kweboboe wapuhi waaniŋ uŋgoŋ yakiiŋ u yalakapme tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Mikmehiye fafaŋehi’walaŋ nemenemehik momohi u agaŋ yolombegiŋ. Kaŋ mikme heki u agaŋ kumuŋgiŋ, doktiŋa mik bomboŋ moŋgoyemdok me nemoŋ. ");
INSERT INTO nop_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Jekop’walaŋ Bepaŋ, du agaŋ gibitaŋ yenintoguŋ, kaŋ wosi tiŋa me wosi foloŋ ikiŋ adi wanakaŋ kwetfoloŋ maaŋ kumuŋa haliugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Iŋgoŋ Bepaŋ, meeniŋ fee adi dutok munta tiiŋ, ale du aditok kwihita binek tubune, me nediyeŋdi yoŋa du namandake foloŋ yalek? ");
INSERT INTO nop_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Du kunum foloŋ hali metam hogohogok mede gineŋ yapmeguŋ. Tiŋa medehik yodapmaŋdok pilali yakuŋ. Tiŋa metam me nolidi kadakaniŋ tiyemgiŋ u yehitubu-lodaguŋ. Unduŋ tubune kwetfoloŋ metam hogohogok adi munta tiŋa mede mokit kabup hinek haliugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Me hekidi kwihita tiiŋ, iŋgoŋ wendiniŋ folooŋ metam nolidi wohoge ganintiloneŋ. Kaŋ metam mik gineŋ mu kadakaneeŋ heki adi du gehitubu-dulaaŋ mulelem tigamuŋa ganiutumbaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Du Yahwe Bepaŋge maŋgoŋ mimiŋdok yofafaŋeguŋ u mimbeŋ. Metam hogohogok adi siloŋhik beŋa wooŋ aditok siloŋ timineŋ. Adi yadi Saŋiniŋ Molom doktiŋa nemenemek kwetfoloŋ hatiiŋ hidi aditok gikiŋgoŋ timiŋa munta timineŋ. ");
INSERT INTO nop_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Adi yadi mapme foko tiiŋ heki u yehimoŋgofofoŋ tilak. Tiŋa mapme kwetfoloŋhi kisaŋ hinek yehitubu-muntalak. ");
INSERT INTO nop_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Nu Bepaŋdi nadinambek yoŋa gibitaŋ kutifiyelat. Kaŋ adi kutibulabulayene u nadilak. ");
INSERT INTO nop_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Malabumuŋ mintanamulak nai uŋaniŋ nu Wapum ninadilat. Helemahelemaŋ timiŋ kohone belooŋ ninadi kwanai tilat iŋgoŋ welekulema mu tubumintalat. ");
INSERT INTO nop_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Nu Bepaŋdok nadihatiŋa welebulaniŋgoŋ tubumintalat. Tiŋa uŋgoŋ tomboyoula nadihatiŋa agaŋ gweheye tilat. ");
INSERT INTO nop_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Bepaŋdi kaipmuŋ napme halune damo mu deitat. Unduŋ tiŋa nadibedi tiŋa mede yodok kwanaimiŋ tilat. ");
INSERT INTO nop_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Nu nai momohi koom hatiyagumun wendok hanadilat. Tiŋa undugoŋ gulet agaŋ dapmaaŋ ugiŋ wendok maaŋ hanadisulat. ");
INSERT INTO nop_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Timiŋ adi nadinadi kwanai fuliŋgoŋ hinek tilat. Nadinadi kwanai tomboyoula tiŋa wooŋ moŋ kaŋ na uŋgoŋ indiŋ yonadilat, ");
INSERT INTO nop_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Wapum adi agaŋ sigilulum binek tinamguk? Tiŋa kotigoŋ mu binek nabukahilewaak? ");
INSERT INTO nop_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Weleŋdi hinek nibukahileguk u agaŋ binek biguk? Tiŋa mede yofafaŋeŋiŋ u maaŋ agaŋ binek bikabune foguk? ");
INSERT INTO nop_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Bepaŋ adi kwihita binek tinimiŋa siloŋ tobogoŋ mu tinimilak? Be kwihitaŋiŋ wendi siloŋ tobogoŋ u kamehelak?” ");
INSERT INTO nop_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Nu unduŋ nadiŋa indiŋ yolat. “Bepaŋ loloŋnit adi kotigoŋ mu nehitubu-lodalak. Wendoktiŋa nu welemulap tilat.” ");
INSERT INTO nop_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Yahwe, nu kotigoŋ kwanaige wapum wondok nadisulat. Biyagoŋ, nu du koom kudi wapuhi wapuhi tuguŋ wendok nadiwit. ");
INSERT INTO nop_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Nemenemek hogohogok tuguŋ wondok nadiwit. Tiŋa kwanai saŋiniŋhinit tuguŋ u maaŋ nadiwit. ");
INSERT INTO nop_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Bepaŋ, du titiŋge adi uŋgoniŋ tiŋa didimeniŋ hogok. Bepaŋ yalayalaŋ niŋdi dukut noŋgonoŋgoŋ nemu tilak Mokoŋ hinek. Du kubugoŋdi yalakapmedapmaŋ tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Bepaŋ, du kubugoŋdi kunum diniŋ kudi saŋiniŋnit tilaŋ. Eŋ koom metam hogohogok saŋiniŋge tubumintaune kagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Tiŋa undugoŋ da’walaŋ saŋiniŋgedi metamgeye kotigoŋ yanagikuŋ. Adi yadi Jekop tiŋa Josep’walaŋ yalakihiye. ");
INSERT INTO nop_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Bepaŋ, koom ime heki du gabuŋa munta tigiŋ, kaŋ imeŋgwaŋ wapuhi fuliŋmamaŋ adi hehele tiŋa tibitim tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Mulukwaŋdi gwi wapum tubumintaune maguk kaŋ muŋkulap toŋa filimpit tubune hautaŋiŋdi kwetkwet udapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Dagoŋ nadiune muŋkulapdi fifiŋgobut gut kiulaŋa toguk. Kaŋ filimpit tubune hautaŋiŋdi kwetkwet udapmaguk, unduŋ tubune kwet adi tiŋati mahamulune tibitim tuguk! ");
INSERT INTO nop_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Talikge adi imeŋgwaŋ lekiŋgoŋ foloŋ uŋgoŋ hakuk. Kaŋ du uŋgoŋ yauguŋ. Iŋgoŋ kayoŋ yaliyauguŋ kayoŋkayoŋ nemu kagumun. ");
INSERT INTO nop_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Du adi dompa kadoko dabugoŋ hinek talitimeŋ tiŋa metamgeye yanagikuŋ. Tiŋa Moses dut Alon kwanai uŋakoŋ yembune talitimeŋ tiŋa yabudokooŋ yanagikumuk. ");
INSERT INTO nop_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Metamneye, hidi medene yodakalelat u momooŋgoŋ hinek nadineŋ. Hidi nu mede yobe tilat wendok magi kametnadi fofooŋgoŋ tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Nu adi yoyout mede yobit, eŋ nemenemek komi kabup hebihalibulak wendok maaŋ kahat tihambit. ");
INSERT INTO nop_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Koom mamani-papaniyedi nemek wondok agaŋ ninimbune magi kametnadi tiŋa nadigumun. ");
INSERT INTO nop_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Indi wapmihiniye mu yeniŋa mede u yalihefula adi mu tineem. Adi toboniŋ yalakiniye tomboyoula mintaneeŋ u Yahwe’walaŋ saŋiniŋŋiŋ wapum eŋ kwanai saŋiniŋnit tuguk eŋ kunumneniŋ kudi tuguk u mede kahat tiyemne nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Bepaŋdi Isilaehi metamdok Yodoko Medeŋiŋ yemguk. Tiŋa Jekop yalakiŋiyedi takalidok yoŋa mede yeniŋguk. Adi koom mamaŋ-papaŋ heki indiŋ yeniŋguk, “Hidi wapmihihiye nu’walaŋ Yodoko Medene i momooŋgoŋ hinek yenindidimeyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Unduŋ tineeŋ doktiŋa wapmihi-bop mindaŋ mintaneeŋ adi maaŋ nadineeŋ, ala adibo yakaleeŋ wapmihihiye yenineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Unduŋ tineeŋ doktiŋa adi maaŋ Bepaŋ nadisukilitimineeŋ, tiŋa adi nemenemek hogohogok tuguk u nadikaule tuwot mu tineeŋ. Unduŋ tiŋa adi’walaŋ Yodoko Medeŋiŋ hogohogok u kedem yehikeleneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Tiyaugene mamahi-papahiyedok tuwolit mintaneeneŋ ala. Mamaŋ-papaŋ heki adi foko tiŋa Bepaŋ’walaŋ medeŋiŋ kahaŋinda tigiŋ, unduŋ tiŋa Bepaŋ nadisukilitimiŋ hinek mu tigiŋ, eŋ medeŋiŋ maaŋ undugoŋ helemahelemaŋ hinek mu takaliyagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Koom Ifeleimhi adi tebe bohom tiŋa tiulidokogiŋ. Iŋgoŋ mik pilalune toboniŋ momoŋ tiŋa ugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Adi yadi Bepaŋ dut yofolok tigiŋ u mu takaligiŋ, tiŋa undugoŋ Yodoko Medeŋiŋ takalidok adi nadilakata tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Adi yadi Bepaŋdi nemenemek tuguk be kunumneniŋ kudi dauhik foloŋgoŋ tubune yabugiŋ u agaŋ kaule tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Isip kwetneŋ kwet gutuŋ niŋ wou Soan, uŋoŋ Bepaŋdi kunumneniŋ kudi niŋ tubune mamani-papaniye adi dauhikdi hinek kagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Bepaŋdi imeŋgwaŋ ulitawaune fukufukuŋ looŋ yalune Isilaehi metam yanagilune lekiŋgoŋ uŋgoŋ bugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Hadapmo adi mulukwaŋ gineŋ hali talitimeŋ tiyemguk, eŋ timiŋ adi kudup hautaŋiŋ gineŋ hali talitimeŋ tiyemguk. ");
INSERT INTO nop_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Adi kwet fiileŋ uŋoŋ kawade heki upupuheneune ime kwet kainiŋneniŋ sila labuŋa woditaune nagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Adi yobune ime kawade gineniŋ labuŋa ime wapuhi behepneŋ wodiŋa wiiŋ nabugoŋ wodiŋa uguk. ");
INSERT INTO nop_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Iŋgoŋ adi yadi Bepaŋ loloŋnitdok kadakaniŋ hati timiyagiŋ. Adi kwet fiileŋ uŋoŋ hatiŋila foko hati-timiyagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Adi Bepaŋ tikamanda timindok nadiŋa unduŋ tagiŋ. Adi nanaŋe dediniŋdok hinek nadiyagiŋ uŋak yembek yoŋa gibitaŋ kutiniyagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Adi Bepaŋ nimpekit tiŋa indiŋ yoyagiŋ, “Kwet fiileŋ iŋoŋ Bepaŋdi nanaŋe mohok tuwot hinek kedembe nimbek? ");
INSERT INTO nop_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Koom kawade foloŋ ulune ime wapum u biyagoŋ wodiguk. Iŋgoŋ nanaŋe tiŋa kale u kedem-kube nimbek?” ");
INSERT INTO nop_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Unduŋ yoŋa tobune Yahwe adi medehik u nadiŋa kwihita tuguk. Doktiŋa kudup kameune Isilaehi’walaŋ foguk. Tiŋa kwihita kisaŋ hinek tiyemguk. ");
INSERT INTO nop_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Adi mu nadisukilitimiŋgiŋ, tiŋa undugoŋ adi yehitubu-lodaune momooŋ hatidok nadiŋa tuguk wendok maaŋ mu nadisukilitigiŋ, doktiŋa unduŋ tiyemguk. ");
INSERT INTO nop_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Iŋgoŋ fiit yobune kunum dilitomguk. ");
INSERT INTO nop_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Kaŋ yobune mana kwetfoloŋ maaŋ foune moŋgola nagiŋ. Adi kunumneniŋ nanaŋe yembune nagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Unduŋ doktiŋa adi aŋelo heki’walaŋ nanaŋe nagiŋ. Bepaŋdi nanaŋe tuwot hinek yembune natoki tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Kaŋ mindaŋ mele labulabuneŋkade yobune sububa wapum fedikuk, eŋ ne’walaŋ saŋiniŋŋiŋ gineŋgoŋ yobune sububa saut-kade maaŋ fedikuk. ");
INSERT INTO nop_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Kaŋ negoŋ yobune bagi mohok fee mumuyeŋ kwamdok tuwolit, eŋ kiŋ luhineŋ ikiiŋdok tuwolit wendi adi’walaŋ lekiŋgoŋhik gineŋ maaŋ fotelegiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Bepaŋ ne nadiune bagi hekidi maaŋ fooŋ metamdi yot maaŋ ila ugiŋ lekiŋgoŋhik gineŋ fogiŋ, eŋ seli-yot haliugiŋ u kelemadidapmaŋ tiŋa hakiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Kaŋ metamdi u beŋa henaŋ tuwot hinek nadigiŋ. Bepaŋdi nemek yemdok nadiŋa kutiniŋgiŋ u uŋakoŋ yemguk. ");
INSERT INTO nop_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Kaŋ uŋakoŋ hati-nagiŋ. Iŋgoŋ mu nadapmalune, ");
INSERT INTO nop_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","nai uŋaniŋgoŋ Bepaŋdi kwihita tiyemiŋa me fafaŋehi u widihikumuŋ tuguk, Isilaehi’walaŋ mekuya momohi. ");
INSERT INTO nop_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Bepaŋ adi kunumneniŋ kudi fee tuguk, iŋgoŋ metamdi yabuhaŋindaaŋ tomboyoula kadakaniŋ fee tiŋila Bepaŋ mu nadisukilitimiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Wendoktiŋa Bepaŋdi meeniŋ mahik foloŋ munabut tubune sububadi labuŋa pilap hinek fitak wondok tuwolit pilap hinek yehitubu-liwe tuguk. Adi pilap hinek yehitubu-kadakaune kumuŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Bepaŋdi noli widihi-kumuŋguk, kaŋ nai uŋaniŋ me noli welehik tubutakaleeŋ adi’walaŋkade buŋa ninadi kwanai gibitaŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Nai uŋaniŋ Bepaŋdi yahehewe tiyemiŋa momooŋ hinek yabudokolak eŋ Bepaŋ loloŋnit hinek adi momooŋ yehitubu-lodalak u kotigoŋ naditomgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Iŋgoŋ u yalaŋ timiŋa niŋkamanda tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Unduŋ tiŋa adi’walaŋ medeŋiŋ mu takaligiŋ, eŋ adigut yofolok tigiŋ u bikabugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Iŋgoŋ Bepaŋ adi metamŋiyedok siloŋ tobogoŋ tiyemiŋa kadakaniŋhik tumolokula mu yehitubu-kadakaguk. Nai fee hinek kwihitaŋiŋ u fiit honekilitiŋa hali nadikwihita mu tiyemiluguk. ");
INSERT INTO nop_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Aditok indiŋ nadiyemiluguk, adi yadi nemek fafaŋehi mokoŋ, adi yadi meeniŋ, tiŋa undugoŋ adi yadi sububadi fedila buŋa dapmaaŋ ulak undihi. ");
INSERT INTO nop_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Nai fee hinek kwet fiileŋ uŋoŋ Bepaŋ’walaŋ medeŋiŋ nadihaŋinda timiŋgiŋ. Unduŋ timimbune adi nai fee hinek welemulap nadiluguk. ");
INSERT INTO nop_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Adi Bepaŋ tikamanda timindok nadiŋa nemek tagiŋ uŋakoŋ tiyakaleeŋ kotigoŋ tagiŋ. Unduŋ tiŋa Isilaehi’walaŋ Bepaŋ Uŋgoniŋ weleŋ tubukadakayagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Adi Bepaŋ saŋiniŋŋiŋ loloŋnit, tiŋa memik heki’walaŋ kohohik gineniŋ yehitubu-lodaaŋ kotigoŋ yanagikuk u mu naditomgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Isip kwetneŋ kwet gutuŋ niŋ wou Soan, uŋoŋ kunumneniŋ kudi fee tuguk. ");
INSERT INTO nop_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Bepaŋdi ime nadiune naŋgat yageleune Isiphi adi ime tuwot mu nagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Tiŋa bubugaim eŋ hawom mohok fee nadiune adi’walaŋkade ugiŋ. Wooŋ bubugaimdi yehisigiŋ eŋ hawom hekidi yohikkwehik tubukadakagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Eŋ Bepaŋdi kaleŋgiŋgiŋ tiŋa gwatak yeniŋkulune buŋa dininahik gineŋ nemenemek labugiŋ u nadapmaŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Tiŋa undugoŋ negoŋ nadiune gwi ais nabugoŋ wondi maaŋ wain tawahik u yehitubu-kadakagiŋ, eŋ nadiune aisdi bem gimiŋ fik u yehitubu-kadaka tuguk. ");
INSERT INTO nop_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Tiŋa nadiune gwi ais nabugoŋ maaŋ makauhik u widihikumuŋdapmaŋ tuguk, eŋ filimpitdi dompahiye widihikumuŋ-dapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Adi kwihita kisaŋgoŋ hinek tiyemiŋa gibitaŋ yehitubu-kadakaguk. Unduŋ tiŋa aŋelo fafaŋehi yapmeune wooŋ yehitubu-kadakagiŋ kaŋ adi malabumuŋ wapum nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Adi kwihita tiyemiŋa mu biyabuguk. Mokoŋ. Adi toboniŋ nadiune yagit wapumdi yohoneune kumuŋ fotaba tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Eŋ Isiphi’walaŋ tuwo biyeniŋ hogohogok u widihikumuŋdapmaŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Unduŋ tiŋa dompa kadoko me nabugoŋ talitimeŋ tiŋa metamŋiye yanagikuk. Tiŋa kwet fiileŋ uŋoŋ talik yenindidimeeŋ yahaŋeguk. ");
INSERT INTO nop_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Adi momooŋ hinek tiŋa yahaŋeguk, doktiŋa adi munta mu tigiŋ. Iŋgoŋ memikhiye adi imeŋgwaŋdi yehikumuyeguk. ");
INSERT INTO nop_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Adi yahaŋeune ne’walaŋ kweli uŋgoniŋ gineŋ bugiŋ, kweboboe woŋ adi ne’walaŋ saŋiniŋŋiŋ gineŋ fafaŋeeŋ kahileguk. ");
INSERT INTO nop_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Adi metamŋiye bugiŋ kaŋ metam noli uŋoŋ hatigiŋ u yehikelekukuk. Unduŋ tiŋa kwet u Isilaehi mebopdok daneyemtauguk. Unduŋ tiŋa yohik hogohogok u metamŋiyedok yembune yohikwehineŋ kulemaŋgoŋ itougiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Iŋgoŋ Isilaehi adi Bepaŋ Saŋiniŋ Molom u tikamanda timiŋa foko timiŋgiŋ. Unduŋ tiŋa Yodoko Medeŋiŋ u mu takaligiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Adi yadi mamahi-papahiyedi koom tigiŋ wendok tuwot foko tiŋa medeŋiŋdok nadilakata tigiŋ. Adi yadi tebemiŋ gembugolohi nabugoŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Adi bepaŋ yalayalaŋ heki’walaŋ welewele eŋ altahik tutumbaune Bepaŋ adi wendoktiŋa kwihita tuguk. ");
INSERT INTO nop_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Bepaŋ adi titiŋhik u kaŋ kwihita kisaŋ hinek tiyemguk, unduŋ doktiŋa Isilaehi adi sigilulum tiyemiŋa biyabudapmaŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Unduŋ tiŋa Sailo uŋoŋ Bepaŋ’walaŋ Siloŋyot selidi magiŋ u bikabu tuguk. Yot wendok foloŋ adi metam’walaŋ lekiŋgoŋhik gineŋ hatiguk. ");
INSERT INTO nop_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Unduŋ tiŋa memik heki biyabune buŋa yofolok bogit u tiŋa ugiŋ. Bogit wendok gineŋ adi ne’walaŋ saŋiniŋŋiŋ tiŋa namanda diniŋ hauta wapum u kayagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Adi metamŋiye yabukwihita tiŋa biyabune memikhiyedi buŋa widihi-kumuŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Mekuya adi mik gineŋ kumuŋdapmagiŋ, doktiŋa tamkuyadi yohohiye titiŋdok me nemu hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Memik hekidi Siloŋyot diniŋ talitimeŋ heki u miknoŋdi widihi-kumuŋgiŋ, kaŋ tamhiye adi yohohiyedok bulaniŋgoŋ nadigiŋ iŋgoŋ e, makat mu kokiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Kaŋ Wapum adi me niŋdi damo gineniŋ pilatak nabugoŋ pilakuk, eŋ me fafaŋeeŋ niŋdi wain ime fee naaŋ kakali yaulak wendok tuwot tuguk. ");
INSERT INTO nop_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Adi memik heki gut mindobuŋa kotigoŋ yehikeleune ugiŋ. Unduŋ tiŋa yehikalakapme hinek tubune adi mekadapmaaŋ mik kotigoŋ mu tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Tiŋa adi yadi Josep’walaŋ yalakiŋiyedok moŋ nadiyemiŋa yeniŋkelekut tuguk. Tiŋa undugoŋ Ifeleim’walaŋ yalakiŋiye maaŋ adi yabukahile mu tuguk. ");
INSERT INTO nop_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Adi yadi tobo Juda’walaŋ yalakiŋiye tiŋa Saiyon kweboboe, ne weleŋdi kahile tilak, adi netok gigit yofafaŋeguk. ");
INSERT INTO nop_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Adi yoli uŋgoniŋ kweboboe wendok foloŋ maguk, tiŋa yoli u tubufafaŋeune kunumdi fafaŋeniŋ hatak eŋ kwet i kamekwambundaguk kaŋ hatak wondok tuwot fafaŋeeŋ yatak. ");
INSERT INTO nop_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Bepaŋdi tipilapilaye-meŋiŋ Dewit adi dompa hati yabudokolune nagila metamŋiye yabudokodok yoŋa kahileguk. ");
INSERT INTO nop_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Unduŋ tiŋa Isilaehi’walaŋ mapme kameguk, kaŋ Bepaŋ metamŋiye yabudoko kwanai tuluguk. ");
INSERT INTO nop_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dewit adi kwanaiŋiŋdok hogok nadinadi tiŋa momooŋ hinek yabudokoluguk. Unduŋ tiŋa talitimeŋ momooŋ hatiguk. ");
INSERT INTO nop_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Bepaŋ, me nadisukilitihinit mokit adi agaŋ indi’walaŋ kwetnineŋ iŋoŋ bugiŋ, buŋa metamgeye inditok mik tinimiiŋ. Adi datok yoŋa yoke uŋgoniŋ maguŋ u tubukadaka tigiŋ, kaŋ yoke uŋgoniŋ u geŋgeŋnit tilak. Unduŋ tiŋa Jelusalem adi tubukadaka hinek tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Adi metamgeye eŋ kwanai-megeye widihikumuŋgiŋ, kaŋ bagi kalaŋkatak tiŋa kale moihidi foloohik dabaŋ u nagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Memik hekidi metamgeye widihi-kumumbune naŋgathikdi kwatneeŋ Jelusalem maaneŋ ime nabugoŋ wodiŋa uguk. Kaŋ uŋoŋ foloohik dabaŋ beŋa wooŋ yehiwenefuladok nebek nemu hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Metam-bop indi itowamneŋ yamaiŋgoŋ itowiiŋ heki adi nibugegeeŋ ninimpekit tiŋa mede kadakahi niniiŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Yahwe, du inditok kwihitanimiŋa nai kweheyeniŋ undugoŋ be hatibaaŋ? Kwihitagedi kudup dalak unduŋ daaŋ kumuŋ mu tibaak be? ");
INSERT INTO nop_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Du adi toboniŋ metambop du’walaŋkade wooŋ mulelem mu tigamuŋa ganiutumbaaŋ sigilulum tigamiiŋ, metam undihidok adidili kwihita tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Metambop adi kuyeŋ metamgeye indi nindihikumuŋgiŋ, tiŋa kwetnik nimguŋ u tubukadaka hinek tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Du tiyaugene mamani-papaniyedi koom kadakaniŋ tigiŋ wondok kibikoŋ nobuniŋ malabumuŋ i tubu-udanenimuliweŋ. Indi saŋiniŋnik agaŋ fofoye tilak, unduŋ doktiŋa du fiit siloŋ tobogoŋ tinimiŋa saŋiniŋ pilap nimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Bepaŋ, du da kubugoŋdi nihitubu-lodaaŋ kotigoŋ hati ninigitaŋ. Ale wohogegigitdok nadiŋa nihitubu-lodaweŋ. Kotigoŋ ninigila kadakaniŋnik hogohogok u wanakaŋ tumolokutnimbeŋ, kaŋ indi wohoge ganintilonim. ");
INSERT INTO nop_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Dediŋ doktiŋa mebop nolidi indiŋ nininadiiŋ, “Bepaŋhik deŋgoŋ hatak?” Adi kwanai-megeye widihikumuŋgiŋ, unduŋ doktiŋa dubo kibibo naŋgathik diniŋ tuwaŋiŋ metambop noli u yehitubu-kadakaune gabunimdok woomam. ");
INSERT INTO nop_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Du me yot fafaŋeniŋneŋ hakiiŋ’walaŋ makat koyonehik u nadiyembeŋ. Unduŋ tiŋa memik hekidi me agaŋ kumuŋ titiŋdok yenindapmagiŋ u saŋiniŋge uŋgoniŋdi yehitubu-lodaaŋ kotigoŋ yanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Memik heki woŋ adi medehaki ganiŋgiŋ. Unduŋ doktiŋa Wapum, dubo kibibo titiŋhik kadakaniŋ wendok kibikoŋ nai 7 wondok tuwot tubu-udaneyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Du unduŋ tibeŋ kaŋ metamgeye hogohogok, da’walaŋ dompageye nabugoŋ hatiyam, indi helemahelemaŋ welemomooŋ nadiŋa ganiutumbayaneem. Kaŋ yalakiniyedibo tomboyoula wohoge yotiloune dapmandapmaŋnit mokit haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","2","O Isilaehi’walaŋ Kadoko, du talitimeŋ tinimiŋa dompa bopgeye ninigitaŋ, du kutikutinik nadinimbeŋ. Mapme kumopop foloŋ aŋelo heki yalakapmeeŋ looŋ itaŋ, du Ifeleim eŋ Benjamin tiŋa Manase mebop indi miŋgilaŋgoŋ mintanimiŋa saŋiniŋge tubumintaune kanim. Unduŋ tiŋa kotigoŋ nihitubu-lodaaŋ ninigilune memikniyedi mu nihitubu-kadakaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Bepaŋ, kotigoŋ ninigilune du’walaŋkade unim. Tiyaugene kadakaneemneŋ doktiŋa siloŋ tobogoŋ tiŋa nihitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Yahwe, Saŋiniŋ Molom, du maŋgande metamgeye nai kweheyeniŋ hinek kwihitanimiŋa yonadinik mu nadinimilaŋ? ");
INSERT INTO nop_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Unduŋ tinimbune indi makunum gibitaŋ tiyam, kaŋ daunik meeniŋdi nanaŋe maliŋ toki tilak. ");
INSERT INTO nop_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Du mebop noli magimagi itowiiŋ biyabulaŋ kaŋ buŋa nindihiŋa kwetnik nilombeiŋ. Tiŋa memikniyedi ninimpekit tiŋa niniŋgege tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Saŋiniŋ Molom, du kotigoŋ ninigilune du’walaŋkade unim. Tiyaugene kadakaneemneŋ doktiŋa siloŋ tobogoŋ tiŋa nihitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Du koom Isip kwetneŋ wain youli kobuli niŋ dabugoŋ unduŋ ninigila buŋa metambop kwet iŋoŋ hatitaugiŋ hogohogok u yehikeleeŋ adi’walaŋ kwehikoŋ gineŋ indi ninigila wain wele unduŋ yetiguŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Du kwet tutumbanimguŋ, kaŋ indi’walaŋ kokoinikdi kwet gineŋ fohinakaŋ kwetkwet udapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Kaŋ taŋeniŋnikdi kweboboe yehikufuladapmaaŋ bem wapuhi sida u maaŋ yehikufulagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Eŋ taŋeniŋnikdi kohoŋkohoŋ tiŋa tomboyoulune Meditelenien imeŋgwaŋ wapumneŋ eŋ Yufeletis imeneŋ uŋoŋ wooŋ hadapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Iŋgoŋ du dediŋ doktiŋa gimbahaŋnik ubulaginekukuŋ? Da unduŋ tuguŋ doktiŋa nai indinde metamdi talipmeŋ yauŋila wain folooŋ kubo tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Eŋ makaye moiŋ maaniŋdi buŋa yehitilifagihiune maaŋ kwetfoloŋ ikiiŋ kaŋ kale moihi nolidi buŋa naiŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Bepaŋ, Saŋiniŋ Molom, du kotigoŋ inditok nadinimbeŋ. Du kunum foloŋ haliŋa diweune foune nibilaŋ, indi adi waingeye dabugoŋ hakam. Unduŋ doktiŋa buŋa nihitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Du da buŋa wain youli kobuli yetiguŋ lolak i tubulodaaŋ saŋiniŋ mimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Memikniyedi nihifidokooŋ kudup gineŋ nihikulahegiŋ. Unduŋ doktiŋa nadikwihitayemiŋa yehitubu-kadaka tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Iŋgoŋ indi adi datok yoŋa nibukahileguŋ, tiŋa undugoŋ nihitubu-ulihakaune bop wapum mintane saŋiniŋ nimguŋ. Wendoktiŋa nihitubu-lodaaŋ nibudokoweŋ. ");
INSERT INTO nop_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Unduŋ tinimbune indi du kotigoŋ mu bigabuneem. Du nihitubu-lodaune hatiŋila yonadinik kamene du’walaŋkade uune wohoge ganintilooŋ hatiyaneem. ");
INSERT INTO nop_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Yahwe, Saŋiniŋ Molom, du kotigoŋ ninigilune du’walaŋkade unim. Tiyaugene kadakaneemneŋ doktiŋa siloŋ tobogoŋ tiŋa nihitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Bepaŋ adi saŋiniŋnik doktiŋa nadifooŋ baham tominim. Jekop’walaŋ Bepaŋŋiŋdok kap tomiŋa wou nintiloloŋ titiŋdok. ");
INSERT INTO nop_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Kap tububihila toŋila tambalin utneŋ, eŋ gita kulele maaŋ ulune mede momooŋ toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Bepaŋ’walaŋ hinamuni titiŋ diniŋ muyakip gitipmuŋ tububihila labulakneŋ be muyakip u kumundok beemlabu tilakneŋ, hinamuni tububihitne timeŋ adi bai feditdok. ");
INSERT INTO nop_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Yodoko Mede woŋ adi Isilaehi indi’walaŋ. Jekop’walaŋ Bepaŋŋiŋdi Yodoko Mede u nimguk. ");
INSERT INTO nop_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Koom Bepaŋdi Isiphi mik tiyemguk, nai uŋaniŋ Isilaehi inditok Yodoko Mede u nimguk. Nu me niŋ’walaŋ maŋiŋ mede nadilat, iŋgoŋ u nebek’walaŋ maŋiŋ mede hinek u mu nadikiyondalat. ");
INSERT INTO nop_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Adi indiŋ yolak, “Nu nemek hogohogok malabuhi kaluwaŋhik foloŋ hakiiŋ u agaŋ dilitelekuhamulat. Unduŋ tihambene hidi kwanai diniŋ bondibondi biyabune kwetfoloŋ foiŋ. ");
INSERT INTO nop_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","“Hidi malabumuŋ gineŋ hali kutinaniŋgiŋ, kaŋ nu hehitubu-lodaaŋ kotigoŋ hanagikut. Nu kwetne hebiniŋ gwi muŋkulap gineŋ haliŋa yonadihik nadiŋa tubu-udanehamgut. Hidi koom Meliba-kwet ime wodiŋa ugiŋneŋ uŋoŋ hatibune nadisukilitihik kanadidok tihamgut. ");
INSERT INTO nop_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","“Metamneye, nu munte mede hanimbit. Isilaehi, hidi adi nu’walaŋ medene nadi hinek tineŋdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","“Hidi adi metambop noli’walaŋ bepaŋhik u mu yeniutumbayaneeŋ. Tiŋa undugoŋ bepaŋ yalayalaŋdok mulelem timiŋa mu niutumbayaneeŋ. Hidi adi nu hogok mulelem tinamuŋa naniutumbayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","“Nu kubugoŋ hogokdi Bepaŋhik tiŋa Yahwe. Nu nagoŋ Isipniŋ hanagilene bugiŋ. Hidi mahik dilitombune nanaŋe hamtoki tibit. ");
INSERT INTO nop_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Iŋgoŋ metamneye adi medene nadidok lakata tigiŋ. Biyagoŋ hinek, Isilaehi adi medene takalidok lakata tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","“Wendoktiŋa biyabene nehi’walaŋ welekwambuŋhik uŋakoŋ takaliŋa nemenemek nehi nadinadi gwaŋ titaugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","“Nu adi metamneyedi nu’walaŋ medene nadi hinek tineŋdok nadilat. Tiŋa indiŋ maaŋ nadilat, Isilaehi adi nu’walaŋ nadinadine helemahelemaŋ takaliyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","“Adi unduŋ tubune yabuŋa, nubo pilap hinek memikhiye yehimoŋgofowit, tiŋa memikhiye gut mindobuŋa widihidapmaŋ hinek tibit. ");
INSERT INTO nop_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","“Metam nu nabukwihita tiiŋ heki adi yadi munta kisaŋ hinek tiŋa mulelem tinamneeŋ. Kaŋ helemahelemaŋ kibikoŋhidok malabumuŋ yemiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","“Iŋgoŋ hidi adi nanaŋe momooŋ hinek hamdok tilat, tiŋa simiŋkupuk behepneniŋ hambene naaŋ welehik toki hinek tibek.” ");
INSERT INTO nop_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Kunum foloŋ bop wapum gineŋ Bepaŋ adi loloŋnit hinek tilak. Tiŋa bepaŋ yalayalaŋ heki adi bop tubune Bepaŋdi nadinadiŋiŋ yohautaaŋ yodapmalak. ");
INSERT INTO nop_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Adi indiŋ yolak, “Hidi adi mede nadinadi kwanai didimeŋgoŋ mu tiŋa mede mu yotubudidimeiŋ. Hidi detiŋa me kadakahi yehiulihi tiŋa yayem tiiŋ? ");
INSERT INTO nop_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","“Hidi adi me fiyewakahi tiŋa wapmihi kondiŋahi u yehitubu-lodayaneeŋ. Tiŋa meeniŋ malabumuŋ gineŋ hali iutumba mu tiiŋ, aditok adi titiŋ didimeniŋ hogok tiyemaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","“Metam iutumba mu tiŋa nemenemekdok baniŋ tiiŋ, adi yadi me kadakahi heki’walaŋ kohohik gineniŋ kotigoŋ yahaŋeyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","“Hidi adi nadinadihinit mokit, tiŋa hidi adi kaulehi hinek. Hidi hide mambip gineŋ hati yawiiŋ, doktiŋa metam kwetkwet adi titiŋ didimeniŋ mu takaliŋa bikabune fodapmalak.” ");
INSERT INTO nop_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Unduŋ doktiŋa nu adi indiŋ yolat, “Hidi adi bepaŋ. Hidi adi Bepaŋ loloŋnit’walaŋ wapmihiŋiye. ");
INSERT INTO nop_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","“Iŋgoŋ hidi adi kwetfoloŋ medi kumuiŋ undugoŋ kumuneeŋ. Eŋ hatihatihik adi mapme wapmihiŋiye’walaŋ hatihatihikdi dapmalak undugoŋ dapmawaak.” ");
INSERT INTO nop_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Bepaŋ, du adi bubuŋ hinek tiŋa metam hogohogok kwetfoloŋ iŋoŋ hatiiŋ u yabudokoweŋ. Metam hogohogok wanakaŋ u da’walaŋ hogok. ");
INSERT INTO nop_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Bepaŋ, du mage teheŋa kabup mu haleŋ. Tiŋa kulemaŋgoŋ hogok hafit adi mu tibeŋ. Bepaŋ, du kabup gitagoŋ adi mu haleŋ! ");
INSERT INTO nop_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Memikgeye mik tubupilakiiŋ gu yabeŋ. Me du gabukahile mu tiiŋ heki adi foko tigamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Adi kabup hebihali metamgeye yehitubu-kadakadok mede yofolok ha-tiiŋ. Du metamgeye yabukahileeŋ momooŋ yabudokolaŋ iŋgoŋ memik heki adi kabup bopneeŋ yehitubu-kadakadok yofafaŋe tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Tiŋa indiŋ yoiŋ, “Unim ale, indi wooŋ Isilaehi yehitubu-liwedapmahinaka tinim, kaŋ metamdi Isilaehi kotigoŋ mu nadiyemiŋa kauleyem tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Adi mik tigamdok welekubugoŋ tiŋa tiiŋ. Tiŋa adi wanakaŋ bopneeŋ indi nihibefofoŋdok tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","7","Mebop indiŋdi kwanai u tine tiiŋ, Idomhi, Ismaelhi eŋ Moaphi, Hakilihi eŋ Gebalhi, Amonhi eŋ Amelekhi, Filistiahi tiŋa Taiyahi. Adi wanakaŋ bopneeŋ mik tinimiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Eŋ Asiliyahidi maaŋ adigut wooŋ kiukiiŋ. Mebop fafaŋehi woŋ adi Lot’walaŋ yalakiŋiye yehitubu-lodaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Du koom Kison ime wapumneŋ uŋoŋ Midianhi mik tiyemiŋa talitimeŋhiyat Sisela gut Yabin, aditok kudi tiyemguŋ, undugoŋ hinek aditokbo tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Nai uŋaniŋ Endol yokwet wapumneŋ uŋoŋ yehitubu-kadakaguŋ kaŋ foloohik kwetfoloŋ gwaŋ hali wooŋ bitakagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Du koom Olep tiŋa Siyep uŋoŋ tiyemguŋ wendok tuwolit hinek memikhiye diniŋ talitimeŋhiyedok tiyembeŋ. Eŋ Seba tiŋa Salmuna uŋoŋ tuguŋ undugoŋ hinek me talitimeŋhiye u yehimoŋgofofoŋ tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Me heki u indiŋ yogiŋ, “Indi Bepaŋ’walaŋ kwet metamŋiyedok yemguk u kahilene indetok kwetnik tibek.” ");
INSERT INTO nop_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Bepaŋne, du me heki u kwam nabugoŋ beŋa yakulune udapmaneŋ. Be sububadi bem hapmuŋ kumuhi feedi beŋa kutak nabugoŋ beŋa yakulune uneŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Kudupdi ipaŋ dalak, kaŋ kweboboe ipaŋnit adi gibitaŋ dawetik. ");
INSERT INTO nop_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Wondok tuwot hinek du nadiweŋ kaŋ gwi wapum maaŋ mebop u yehikeleune momoŋ uneŋ. Tiŋa undugoŋ, nadiweŋ kaŋ fifiŋgobutdi adi’walaŋkade fedila uune munta tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Yahwe, du yehimoŋgofohinaka tibeŋ, kaŋ adi mekahinakaaŋ wabiŋa du gehikeledok nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Yehibefooŋ widihidapmaune adi helemahelemaŋ munta hogok taneeŋ. Unduŋ tiŋa yehitubu-mekaune mekanit hatigene kumuŋ tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Du unduŋ tibeŋ kaŋ adi indiŋ u kedem naditomneŋ, du kubugoŋ hogokdi Yahwe eŋ Bepaŋ Loloŋnit hinek, tiŋa da kubugoŋdi kwetkwet hogohogok u kadokolaŋ. ");
INSERT INTO nop_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Yahwe, Saŋiniŋ Molom, du’walaŋ Siloŋyot adi momooŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Nu adi munabulinedi du’walaŋ yot wawalige gineŋ uŋgoŋ hatidok nadilak. Doktiŋa welene eŋ folonedi kap toŋa Yahwe hatihatinit dutok nadifo tilat. ");
INSERT INTO nop_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Yahwe, Saŋiniŋ Molom, du adi mapme tiŋa Bepaŋne. Gwendilikdi yolikweli tubumintalak eŋ bubukiyapdi ulihaka tibene biyagoŋ hinek du’walaŋ alta tubudulaaŋ yot suneŋ yoli malak. ");
INSERT INTO nop_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Metam du’walaŋ Siloŋyotneŋ hatiiŋ heki adi momooŋ tiyembune welemomooŋ nadiiŋ, tiŋa helemahelemaŋ kap toŋa wohoge ganintiloiŋ. ");
INSERT INTO nop_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Metam nediyeŋ du’walaŋkade ulodikilitiŋa Saiyon kweboboe foloŋ loloŋdok hinek nadigalika tiiŋ, du adi momooŋ tiyembune helemahelemaŋ nadifo kedem taneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Adi kwet gutuŋ siliŋ eŋ kubali hali ulakneŋ uŋoŋ wiiŋ, kaŋ kwet uŋoŋ adi ime dawi mohok fee mintatawiiŋ. Ala haniŋ gwi ulune imeguŋguŋ mintaaŋ ilawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Meeniŋ uŋoŋ uŋila saŋiniŋ tomboyoutnit beiŋ. Adi Saiyon wosuwaaŋ Bepaŋ Loloŋnit, bepaŋ yalayalaŋ yalakapmedapmaŋ tilak, adi’walaŋ namanda foloŋ mintaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Yahwe, Saŋiniŋ Molom, du yonadine nadinambeŋ. Jekop’walaŋ Bepaŋ, du magike kametnadi tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Mapmenik u kaneŋ. Adi yadi mik nai foloŋ kweletalakdi mikme heki yahehewe tiyemilak wondok tuwolit adi yahehewe tinimiŋa momooŋ hinek nibudokolak. Wapum, du dagoŋ mapme hatidok nindapmaguŋ, ale dagoŋ momooŋ timimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Nu yokeneŋ melenai kubugoŋ unduŋ binek halene, wendi melenai hogohogok noli 1 tausen u yalakapmedapmaŋ hinek tilak. Nu adi Bepaŋne’walaŋ yoli yeme foloŋ yayatdok nadilat. Eŋ me hogohi yohineŋ hahatdok adi lakata tilat. ");
INSERT INTO nop_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Yahwe adi yahehewenik tiŋa undugoŋ adi yadi hautanik. Adi nihikahaŋneeŋ momooŋ tinimiŋa ninimbeloloŋ tilak. Titiŋ didimeniŋ tiiŋ adi titiŋ momooŋ tiyemdok lakata mu tilak. ");
INSERT INTO nop_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Yahwe, Saŋiniŋ Molom, metam du nadisukilitigamiiŋ adi momooŋ tiyembune helemahelemaŋ nadifo tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Yahwe, du kwekeneŋ kotigoŋ welekulema tubumintaguŋ. Tiŋa Isilaehi indi kotigoŋ momooŋ hinek nihitubu-lodalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Du metamgeye indi’walaŋ kadakaniŋnik tumolokutnimiŋa kadakaniŋ tugumun wendiniŋ yomnik binimilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Koom adi kwihita tinimguŋ, iŋgoŋ kobuk nai indide adi kotigoŋ kwihita mu tilaŋ. Biyagoŋ, koom adi inditok tiŋa welege kudup daguk, iŋgoŋ kobuk nai indide adi mooŋ. ");
INSERT INTO nop_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Bepaŋ Tubulodanik, du kotigoŋ ninigilune du’walaŋkade bunim. Kaŋ du fiit inditok nadikwihita mu tinimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Inditok kwihita helemahelemaŋ tinimiluwaaŋ be dediŋ? Tiŋa undugoŋ, kwihitage mu dapmawaak be? ");
INSERT INTO nop_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Du hatihatinik kotigoŋ tubukilitibeŋ, kaŋ metamgeye indi nadifo tiŋa wohoge ganintilonim. ");
INSERT INTO nop_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Yahwe, du helemahelemaŋ welegedi nibukahile tilaŋ u miŋgilaŋgoŋ tubumintaune kanene kotigoŋ ninigileŋ. ");
INSERT INTO nop_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Nu Yahwe Bepaŋdi mede yolak u magi kametnadi tilat. Adi indiŋ nadinimilak. Indi titiŋ kaulehi koom tugumuneŋkade mu unene nibuŋa adi kedem welekulema tubumintanimbek yolak. ");
INSERT INTO nop_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Biyagoŋ hinek, metam nediyeŋ niutumbaaŋ adi’walaŋ nadinadi takaliiŋ adi kotigoŋ yahaŋedok agaŋ tiulidoko tiŋa woom hatak. Ala kotigoŋ ninigilaak kaŋ ne’walaŋ hauta holiholiŋedi kwetnineŋ haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Kaŋ nai uŋaniŋ Bepaŋdi nibukahile hinek tibaak kaŋ indi adi’walaŋ mede helemahelemaŋ baigoŋ hinek nadiŋa tiloloŋ tiyaneem. Unduŋ tiŋa didimeŋgoŋ hatiŋa welekulema tubumintaaŋ iit fofooŋ tineem. ");
INSERT INTO nop_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Kwetfoloŋ metam indi titiŋ momooŋ tubupilatneem, kaŋ Bepaŋ kunum gineniŋdi nadinimbune didimehi tineem. ");
INSERT INTO nop_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Yahwedi nihitubu-lodaune iit momooŋ tineem, tiŋa nemenemek hogohogok tineem u momooŋ mintaneeŋ. Kaŋ kwetnineŋ maaŋ undugoŋ nanaŋe duhuduhu mintawaak. ");
INSERT INTO nop_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Wapumdi nadiune metam adi titiŋ didimeniŋ takalineeŋ, woŋ adi ne baakdok talik tiulidoko timineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Yahwe, nu na nemek niŋ tibitdok saŋiniŋne nemu hatak. Unduŋ doktiŋa du yonadine nadiŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Nu du’walaŋ kwanai-megedi dukut kadiŋa hatidok nadilat. Unduŋ doktiŋa du kotigoŋ nehitubu-lodaaŋ nanagilune kumuŋ tuwot mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Du dagoŋ nu’walaŋ Bepaŋne. Unduŋ doktiŋa du fiit siloŋ tobogoŋ tinambeŋ. Nu adi melenai indigoŋ tuwot hadapmo be timiŋ u du hogok ganinadilat. ");
INSERT INTO nop_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Wapum, nu hatihatine du’walaŋ kohoge foloŋ kamelat, unduŋ doktiŋa du kwanai-mege nu welene gineŋ nadifo tubumintaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Wapum, du momooŋ hinek tiŋa kadakaniŋnik tumolokutnimilaŋ. Tiŋa metam du ganinadiiŋ heki adi yadi welegedi hinek yabukahile tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Yahwe, du yonadinedok magi kametnadi momooŋgoŋ tibeŋ. Nehitubu-lodaweŋ yoŋa kutiganilat, ale du kutikutine u nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Nu kutiganimbene du nehitubu-loda tilaŋ, wendoktiŋa malabumuŋ mintanamulak kaŋ du hogok ganinadilat. ");
INSERT INTO nop_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Wapum, bepaŋ nebek niŋ du indiniŋ nemoŋ, da kubugoŋdi yalakapmedapmaŋ tilaŋ. Tiŋa undugoŋ, nebek me niŋdi du kwanai tilaŋ wendok tuwot tibekdok nemoŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Metambop hogohogok da yehitubu-mintaguŋ adi wooŋ mulelem tigamneeŋ, unduŋ tiŋa wohoge ganintiloneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Maŋgande, da kubugoŋdi saŋiniŋge loloŋnit. Tiŋa undugoŋ da kubugoŋdi nemek momohi momohi mebimebi tilaŋ. Da kubugoŋdi Bepaŋ folooŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Yahwe, du nu titiŋ dediŋ hinek tibit nadilaŋ u momooŋgoŋ hinek naninehi-titiŋeneune, u kaŋ nu helemahelemaŋ du’walaŋ nadinadige hogok takaliluwaat. Nanindidimeune nu du kubugoŋ hogok nadigamuluwaat, tiŋa du’walaŋ kwanaige helemahelemaŋ tuluwaat. ");
INSERT INTO nop_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Bepaŋ Wapumne, nu welenedi ganiutumba loloŋnit hinek tilat, tiŋa wohogegigit helemahelemaŋ ganintiloluwaat. ");
INSERT INTO nop_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Du helemahelemaŋ welegedi nabukahile hinek tilaŋ. Du kumuŋ gineniŋ nehitubu-lodaaŋ kotigoŋ nanagikuŋ, kaŋ nu me kumuhi’walaŋ yohikwehineŋ mu ugut. ");
INSERT INTO nop_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Bepaŋ, me fokohinit adi buŋa nukut mik tine tiiŋ. Me kadakahi eŋ koŋgolondahi adi toboniŋ bopneeŋ nulukumundok tiiŋ. Adi yadi du’walaŋ medege mu nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Iŋgoŋ Wapum, bulaniŋgoŋ eŋ siloŋ tobogoŋdi du’walaŋkade tokiŋa hatak, kaŋ du kwihita pilap mu tilaŋ. Du nibukahile hinek tilaŋ, unduŋ doktiŋa medege yoyakaleeŋ undubo yooŋ undubo yooŋ mu tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Kotigoŋ udaneeŋ nu’walaŋkade buŋa bulaniŋgoŋ nadinambeŋ. Nu adi maanedi koom tuguk unduŋ du’walaŋ kwanai tilat, unduŋ doktiŋa nehitubu-kilitiŋa kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Yahwe, du welegedi nabukahile hinek tilaŋ u fek niŋ tubune kawit. Kaŋ me mik tinamiiŋ heki adi da nehitubu-lodaaŋ naniŋkulemalaŋ u kedem kaŋ nadineŋ. Tiŋa adi nehi’walaŋ titiŋhik u kanadiŋa meka tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Bepaŋ adi kweboboe uŋgoniŋ foloŋ yokwet wapum tutumbaguk. ");
INSERT INTO nop_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Yahwe adi Isilae kwetneŋ yokwet noli ila ugiŋ u yabukahile tuguk, iŋgoŋ Jelusalem adi kanadigalika hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Bepaŋ yolikweli wapum diniŋ metam, hidi indiŋ nadineŋ. Bepaŋ adi nemek loloŋnit eŋ momomomooŋ tihamulak wondok metam feedi youtumba tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Bepaŋdi indiŋ yolak, “Metambop nediyeŋ medene takaliiŋ u yehikunali, Isiphi gut Babilonhi maaŋ yehikunalit. Tiŋa undugoŋ, Filistiahi tiŋa Taiyahi eŋ Itiopiahi adi maaŋ undugoŋ Jelusalemhi yenimbit. ");
INSERT INTO nop_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","“Nu Jelusalemdok adi indiŋ yobit, ‘Woŋ adi metam hogohogok’walaŋ yohikwehik.’ Bepaŋ Loloŋnit na Jelusalem tubufafaŋewene fafaŋeniŋ undugoŋ halaak.” ");
INSERT INTO nop_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Yahwe adi metambop noli’walaŋ wohiye youlaak, tiŋa yehikiula Jelusalemhi metam dut noŋgoŋ yehikunalaak. ");
INSERT INTO nop_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Kaŋ metam Jelusalem uŋoŋ hatineeŋdi kap toŋa nadifo tiŋa miyeneeŋ. Tiŋa indiŋ yoneeŋ, “Jelusalem, nemenemek momohi u du’walaŋkade hadapmalak.” ");
INSERT INTO nop_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Yahwe Bepaŋ, du nehitubu-lodalaŋ eŋ kotigoŋ nanagitaŋ. Hadapmo nehitubu-lodaweŋ yoŋa kutiganilat, tiŋa undugoŋ timiŋ maaŋ ganinadi tilat. ");
INSERT INTO nop_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Yonadine nadiweŋ, tiŋa nehitubu-lodadok kutiganilat u nadinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Malabumuŋ fee hinek mintanambune wendogoŋ tiŋa muniniŋ agaŋ kumundok tilat. ");
INSERT INTO nop_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Nu me nolidi kumuŋ tine tiiŋ wendok tuwot, saŋiniŋne hogohogok agaŋ dapmahinaka tilak. ");
INSERT INTO nop_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Nu binabune me kumuhi dut hatat. Nu adi me nolidi me niŋ ulukumuŋa tukulune meyotneŋ hatak undiniŋ. Nu adi me agaŋ nadikaule tiyemiŋa kotigoŋ tuwot mu yehitubu-lodalaŋ nabugoŋ. ");
INSERT INTO nop_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Du agaŋ nehitukulune koŋ fuliŋmamaŋ gineŋ folat, tiŋa kwet mambipnit hinek gineŋ duwaŋ hatat. ");
INSERT INTO nop_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Kwihitagedi imeŋgwaŋ wapum nabugoŋ nehikufula tiŋa nehitifohinaka tilak. ");
INSERT INTO nop_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Dagoŋ tubune notneye adi sigilulum tinamgiŋ. Dagoŋ tilaŋ kaŋ nu kadakadapmaŋ hinek tibene nabuŋa munta kisaŋ hinek tiiŋ. Wendi kamehenamulak doktiŋa tuwot mu momoŋ wit. ");
INSERT INTO nop_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Nu malabumuŋ hekiŋa daune kadakaune dau diwediwe momooŋgoŋ mu tilat. Unduŋ tiŋa helemahelemaŋ, Yahwe, du nehitubu-lodaweŋ yoŋa kohone kwehene-belooŋ yonadi kwanai tilat. ");
INSERT INTO nop_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Du meeniŋ agaŋ kumuŋ tiiŋ u yehitubu-lodadok kunumneniŋ kudi maaŋbe tilaŋ? Meeniŋ kumuhi adi pilali ganiutumba maaŋbe tiiŋ? ");
INSERT INTO nop_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Meeniŋ agaŋ meyotneŋ koŋ gineŋ deihakiiŋdi du adi welegedi yabukahile hinek tilaŋ wendok maaŋbe yohautaiŋ? Be meeniŋ kadaka titiŋdok kwetneŋ hakiiŋdi momooŋ tiyemguŋdok maaŋbe yohautaiŋ? ");
INSERT INTO nop_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Meeniŋ meyotneŋ hakiiŋ adi kunumneniŋ kudi tilaŋ u maaŋbe kaiŋ? Kaŋ meeniŋ kadakadok kwetneŋ hakiiŋ adi du’walaŋ titiŋge momooŋ u maaŋbe kaiŋ? ");
INSERT INTO nop_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Yahwe, nu du nehitubu-lodaweŋ yoŋa kutiganilat. Helemahelemaŋ haniŋ hogohogok du ganinadilat. ");
INSERT INTO nop_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Kaŋ Yahwe, du maŋgande sigilulum tinamulaŋ? Tiŋa undugoŋ, maŋgande namandake kufulahebi tiŋa wooŋ hataŋ? ");
INSERT INTO nop_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Me kuyane gineniŋ tububihila labuŋa kobuk i hatilat, woŋ adi folofigita hogok nadige nadige agaŋ kumuŋ tibe nadilat. Du malabumuŋ kisaŋ hinek nambune wendi kitiline agaŋ tubugweheye tilak. ");
INSERT INTO nop_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Kwihitage wapum hinek wondi nehikufula tilak. Du kisaŋgoŋ hinek nulaŋa nehitubu-kadakadapmaŋ tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Du hadapmo be timiŋ adi unduŋ hogok tinamulaŋ. Kaŋ ime gabuŋ tiŋa kwetkwet hefula tilak unduŋ malabumuŋ hogohogokdi nehikelemadi tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Du unduŋ tubune me notneye momohi adi binabu tiiŋ. Kaŋ mambip gineŋ hogok hatilat. ");
INSERT INTO nop_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Yahwe, nu helemahelemaŋ welegedi nibukahile hinek tilaŋ wondok kap toluwaat. Tiŋa undugoŋ medege didimeŋgoŋ hinek takaliŋa faki-kabe nemu bikabulaŋ wondok maaŋ dapmandapmaŋnit mokit yohautawene metam ulihakaŋ hatitauneeŋ indigoŋ tuwot hali wooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nu agaŋ nadilat, du welegedi nibukahilelaŋ u waaniŋ hali wooŋ halaak. Medege didimeniŋ u bikabu-kabe nemu tubune kunumdi waaniŋ uŋgoŋ fafaŋeŋ hatak wondok tuwot hatak. ");
INSERT INTO nop_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Du indiŋ yoguŋ, “Nu me niŋ agaŋ tubudakaleeŋ adigut mede yofolok tugumut. Nu kwanai-mene Dewitdok mede yofafaŋe tiŋa indiŋ niŋgut, ");
INSERT INTO nop_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Me mapme kwanai adi du’walaŋ yalakigeye ulihakaŋ hatitaloneeŋ adi hogokdi hatiyaneeŋdok ganilat.’” ");
INSERT INTO nop_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Yahwe, aŋelo kunum foloŋ hatiiŋ adi du kudi tuguŋ wendok youtumbaaŋ wohoge yotiloiŋ. Tiŋa undugoŋ du mede yofafaŋeguŋ hogohogok u didimeŋgoŋ hinek takalilaŋ doktiŋa bophik gineŋ ganintiloiŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Yahwe, kunum foloŋ nebek niŋ dutok tuwolit nemoŋ. Eŋ aŋelo niŋdi dutok tuwolit nemoŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Aŋelo talitimeŋ heki adi Bepaŋ du gikiŋgoŋ tigamiiŋ. Eŋ aŋelo mohok noli du gehikelemadi tiiŋ adi dutok nadiune beweniŋgoŋ tubune gikiŋgoŋ tigamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Yahwe, Saŋiniŋ Molom, nebek niŋ du saŋiniŋge loloŋnit undiniŋ nemoŋ. Du helemahelemaŋ medege didimeŋgoŋ takalilaŋ, tiŋa undubu yoŋ undubu yoŋ adi mu tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Du imeŋgwaŋ saŋiniŋnit kadokolaŋ. Eŋ ime giyondaaŋ pilatak kaŋ tubukulemaune kulemaŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Du Isip’walaŋ saŋiniŋ wapum u ubulagineeŋ tubukadakadapmaŋ tuguŋ. Unduŋ tiŋa saŋiniŋge wapum wendi memikgeye yehimoŋgofooŋ yehikelepupuheneguŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Kunum gut kwet adi da’walaŋ hogok. Du kwet kameeŋ nemenemek wendok foloŋ hadapmaiŋ u maaŋ boiguŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Kwet wahiŋkade be kumaŋkade u dagoŋ yehitubu-mintaguŋ. Kweboboe Tabo gut Hemon adi nadifo tiŋa kap toŋa wohoge youtumbayamuk. ");
INSERT INTO nop_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Wapum, du’walaŋ saŋiniŋge adi wapum hinek, eŋ saŋiniŋge u yadi loloŋnit hinek. ");
INSERT INTO nop_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Du mapme ila titiŋ didimeniŋ gineŋ metam yabudokolaŋ. Tiŋa mede nadiŋa yodapmaŋ kwanai didimeŋgoŋ hogok tilaŋ. Tiŋa undugoŋ, metam hogohogok yabukahile tiŋa medege didimeŋgoŋ takaliŋa undubo yooŋ undubo yooŋ mu tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Metam kap toŋa ganiutumba tiiŋ, tiŋa hebeke foloŋ hatibune titiŋge fofooŋ hinekdi hauta nabugoŋ yehitubu-hautalak, adi yadi nadifo kedem tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Adi yadi du titiŋ momooŋ tiyemguŋ wendok nadiŋa melenai indigoŋ tuwot, hadapmo be timiŋ adi nadifo tiŋa wohoge yotiloloŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Du kubugoŋdi indi’walaŋ saŋiniŋnik loloŋnit. Wondoktiŋa siloŋ tobogoŋ tiŋa nihitubu-lodaune mik gineŋ fafaŋe tiyam. ");
INSERT INTO nop_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Yahwe, du dagoŋ me nibudokodok tubudakaleguŋ. Du adi Isilaehi indi’walaŋ Bepaŋ, tiŋa titiŋ momooŋ eŋ titiŋ didimeniŋ hogohogok diniŋ Bepaŋ maaŋ. Dagoŋ Isilaehi inditok mapme nimguŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Koomkwaha polofetgeye damo gineŋ mintayemiŋa indiŋ yeniŋguŋ, “Me fafaŋeniŋ niŋ ki foloŋ mapme’walaŋ mebi mokop tehindilendileŋnit mokomiŋgut, metamneye’walaaniŋ niŋ tubudakaleŋa me loloŋnit kambiyakut. ");
INSERT INTO nop_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Biyagoŋ kuyoŋ, nu tipilapilaye-mene Dewit tubumintagut. Unduŋ tiŋa yegut e ime wahu munduŋnit uŋgoniŋdi mapme iitdok yougomgut. ");
INSERT INTO nop_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Kohonedi helemahelemaŋ honefafaŋeeŋ nagila hatiŋa kadokoluwaak. Kohone folooŋdi saŋiniŋ miluwaak. ");
INSERT INTO nop_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Memik niŋdi adi talamulaŋa mu ulatifowaak. Eŋ me kadakaniŋ titiŋ niŋdi fafaŋeeŋ tuwot mu tiŋa fowaak. ");
INSERT INTO nop_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Memikŋiye hebeŋ foloŋ widihidadagiyewaat. Eŋ adi kakwihitaneeŋ adi yadi yehiwenemadit tibaat. ");
INSERT INTO nop_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Nu’walaŋ welesiloŋ eŋ siloŋ tobogoŋ adut hatuwaak. Eŋ nu’walaŋ wotnene foloŋ saŋiniŋ moŋgola yatuwaak. ");
INSERT INTO nop_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Nu tubulodawene kweli kadokowaak adi Meditelenien imeŋgwaŋneniŋ tububihila wooŋ ime wapum Yufeletis uŋgoŋ wosuwawaak. ");
INSERT INTO nop_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Kaŋ adi kutinaniŋa indiŋ yoluwaak, ‘Du Batne eŋ Bepaŋne. Dagoŋ helemahelemaŋ nabudokooŋ nehitubu-lodalaŋ.’ ");
INSERT INTO nop_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Kaŋ nu adi mihine biyeniŋ nindapmaaŋ kwetfoloŋ mapme heki’walaŋ loloŋnit kamewaat. ");
INSERT INTO nop_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Siloŋ tobogoŋnedi tubukilitiŋa nagila hatiluwaat. Eŋ yofoloknedi fafaŋeniŋ halimiluwaak. ");
INSERT INTO nop_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Nu yalakiŋiye yehitubu-ulihakawene yeuli dapmandapmaŋnit mokit hatuwaak. Tiŋa nu mapme kweli tubukilitiwene kunumdi hatak wondok tuwot ituwaak. ");
INSERT INTO nop_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“Yalakiŋiye adi yadi Yodoko Medene wabiŋa mede yenindidime tilat u mu nobu takalineeŋ ");
INSERT INTO nop_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","tiŋa undugoŋ medene yofafaŋe tilat ulatifofoŋ nobu tineŋ ");
INSERT INTO nop_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","adi yadi tahi kwadidi yehitubu-didimewaat. Eŋ kadakaniŋhikdok tiŋa yehitubu-figitawaat. ");
INSERT INTO nop_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Eŋ ne adi siloŋ tobogoŋne mu lomtibaat. Be siloŋne folooŋ u mu tubufilimimbaat. ");
INSERT INTO nop_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Nu yofolokne mu fiyakulaat, eŋ manedi mede yofafaŋe tugut u mu wiyakulaat. ");
INSERT INTO nop_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Nu na’walaŋ uŋgoniŋ hatihatine foloŋ kame ulodiŋa nai kubugoŋ yofafaŋe tugut wondi hahat fafaŋeniŋ. Nu Dewit yalaŋ nemu nimbaat. ");
INSERT INTO nop_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Adi’walaŋ yalakiŋiye adi liwe mu tineeŋ. Eŋ mapme kwanaiŋiŋ adi namandatne foloŋ mele itak wondok tuwolit haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Muyakip kameŋit itak aditok tuwot itouluwaak. Kunum halaak tuwot iwamatawaak.” ");
INSERT INTO nop_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Yofolok unduŋ tuguŋ iŋgoŋ yoŋ adi agaŋ wabiŋa mapme tubumintaguŋ u nadikwihita timilaŋ. Ime wahu munduŋnit youlimiŋguŋ aditok tiŋa kwihitadi walage fotoki tilak. ");
INSERT INTO nop_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Tipilapilaye mege dut yofolok tugumuk u wiyakutaŋ. Tinahukutŋiŋ tehindilendileŋnit u tikulimimbune maaŋ kwam tuguk. ");
INSERT INTO nop_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Du kawade gimbahaŋŋiŋ wiyakulimiŋguŋ. Yoli kweli fafaŋeniŋ wiyapupuheneguŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Metam yaudapmaŋ tiiŋ hogohogok adi bomboŋŋiŋ kubo timiiŋ. Noliŋiye yamaŋgoŋ itowiiŋdi gikiŋgoŋ mu timiŋa nimpekit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Memikŋiye nadiyembune fafaŋeŋ yalitifooŋ tonadifo tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Yakee, miknoŋŋiŋ mimim tubugenimbamiŋguŋ, unduŋ timiŋa yeguŋ e mik maaneŋ mu tubulodaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Mapme saŋiniŋŋiŋ lomtiguŋ. Kumopopŋiŋ tehindilendileŋnit tapmetikukuŋ kaŋ kwetfoloŋ maaŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Nadifo foloŋ hatihati naiŋiŋ tubumuniŋgoŋ timiŋa folomeka eŋ bulaniŋgoŋ kamemiŋguŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","O Yahwe, du hebi hatige hatige nai deniŋ mintawaaŋ? Kwihitage diniŋ kudupmebem u deniŋ kumuŋa kulemawaak? ");
INSERT INTO nop_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","O Wapum, hatihatinik diniŋ nai muniniŋ hatak u mu nadilaŋ be? Meeniŋ hogohogok kumuŋ tiyam wondok nadisuweŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Nediyeŋ hatitalogeloge kumuŋ kalakapmewaak? Eŋ nedi’walaŋ hatihatidi kumuŋ yokwet diniŋ saŋiniŋ ulatiŋafooŋ hatibaak. ");
INSERT INTO nop_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Yahwe, du nai indidegoŋ mu nibukahilelaŋ be? Du koomkwaha Dewit nukut mede yofolok biyagoŋ tinamguŋ wondiniŋ folooŋ de? ");
INSERT INTO nop_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","O Wapum, tipilapilayege nanimpekit tiiŋ u maaŋbe nadilaŋ? Metam mu nadisukilitigamiiŋ adi nanimpekit tiŋa nanisilone tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","O Yahwe, mede wondegoŋ nehitubu-meka tiiŋ. Unduŋ tiŋa ime wahu munduŋnit nedegomguŋ nu talik hati yauluwene folomeka tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Yahwe, helemahelemaŋ hati niutumbadok. U biyagoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Wapum, du yadi yotnik dabugoŋ hinek. Mamani-papaniye adi du foloŋ hatigiŋ, kaŋ kobuk indi maaŋ du foloŋgoŋ iŋgoŋ hatiyam. ");
INSERT INTO nop_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Bepaŋ dapmandapmaŋnit mokit, du koomkwaha hatiguŋdi tomboyoula kougoŋ hatiŋa wooŋ hatibaaŋ. Kweboboe hogohogok mu mintagiŋ, eŋ nemenemek kwetfoloŋ iŋoŋ ikiiŋ hogohogok u mu yehitubu-mintaŋila du da koomkwaha uŋgoŋ hatiguŋ. ");
INSERT INTO nop_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Du dagoŋ tilaŋ kaŋ metam adi kumuŋa kotigoŋ kwet yageleiŋ. Kaŋ du indiŋ yolaŋ, “Metam kwetfoloŋ hatiiŋ, hidi adi kumuŋa kotigoŋ kwet yageleneeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Du’walaŋ nadinadi gineŋ gulet 1 tausen woŋ adi nadilaŋ kaŋ melenai kubugoŋ wondok tuwolit tilak. Tiŋa wendi melenai kwegoŋ-kabe pilap hinek wooŋ dapmaguk unduŋ nabugoŋ tilak. Tiŋa undugoŋ, woŋ adi mikme hekidi timiŋ mik-fok nai muniniŋ-kabe ya-tiiŋ wendok tuwot. ");
INSERT INTO nop_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Du ime gabuŋ tiŋa meeniŋ widihi-beŋa uune kumiiŋ, wendok tuwot metam yehililiwenekutaŋ. Adi yadi lihine nabugoŋ nai muniniŋ-kabe hinek hatiiŋ. Tiŋa undugoŋ adi yadi kilihikit kobuligoŋ haniŋ labusuwaaŋ yatak, ");
INSERT INTO nop_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","yali wapum tiŋa wowoŋnit tilak. Iŋgoŋ tebele kotigoŋ kumuŋa sigenelak wondok tuwolit. ");
INSERT INTO nop_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Du inditok kwihita tinimilaŋ, unduŋ doktiŋa indi nihitubu-kadaka tilaŋ. Du inditok tiŋa welege kudup dalak, unduŋ doktiŋa indi munta kisaŋ hinek tam. ");
INSERT INTO nop_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Du indi’walaŋ titiŋ kadakaniŋnik hogohogok u agaŋ yabudapmalaŋ. Eŋ kadakaniŋ kabup tam hogohogok u agaŋ beŋa miŋgilaŋgoŋ boiŋa yabudapmalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Du’walaŋ kwihitagedi indi’walaŋ kwetfoloŋ hatihatinik diniŋ nai u dobunimilak. Indi nai kubugoŋ hinek munabula fedikut tiyam, wendok tuwolit, biyagoŋ hinek nainikdi pilap hinek dapmalak. ");
INSERT INTO nop_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Indi hatiyam kaŋ wooŋ guletnik 70 uŋgoŋ dapmalak. Eŋ saŋiniŋnit hatiŋa adi kedem hatine wooŋ guletnik 80 dapmalak. Gulet u hatitabam hogohogok woŋ adi kwanaimiŋ tiŋa malabumuŋ tubumintayam. Ala gulet wendi pilap dapmaiŋ kaŋ indi maaŋ agaŋ nai uŋaniŋgoŋ wam. ");
INSERT INTO nop_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Du’walaŋ kwihitage diniŋ saŋiniŋ u me nediyeŋdi kamekaaŋ nadilak? Be metamdi du’walaŋ kwihitage doktiŋa munta kisaŋ tiiŋ u me nediyeŋdi nadilak? ");
INSERT INTO nop_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Du didimeŋgoŋ nihititiŋeneune kwetfoloŋ iŋoŋ nai kweheyeniŋ mu hatineem u didimeŋgoŋ nadidakalenim. Unduŋ tiŋa indi nadidakalenit kedem hatiyaneem. ");
INSERT INTO nop_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Yahwe, welege kudup undugoŋ be ha-daluwaak? Du kwanai-megeye inditok bulaniŋgoŋ nadinimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Du helemahelemaŋ welegedi hinek nibukahile tilaŋ, doktiŋa wendi haniŋ hogohogok indigoŋ tuwot welenik kedem tubukilitiluwaak. Wendoktiŋa indi kaipmuŋ hatiyaneem tuwot nadifo tiŋa welemomooŋ nadiyaneem. ");
INSERT INTO nop_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Timentimeŋ malabumuŋ nimguŋ. Iŋgoŋ kobuk adi koom malabumuŋ nimtabuguŋ wendok kibikoŋ nihitubu-lodaune indibo nadifo tinim. Gulet fee hinek hogoli hatigumun, doktiŋa gulet hogohi u dibek hatigumun wendok tuwot hinek nadifo tubuminta-nimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Du kwanai-megeye inditok da’walaŋ kwanaige saŋiniŋnit u kedem tubune kanim. Du kwanaige saŋiniŋnit momohimomohi u yalakiniyedok kedem tubune kaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Yahwe, du Bepaŋnik, indi siloŋ tobogoŋ tinimiŋa momooŋ tinimbeŋdok nadiyaam. Kaŋ indi nemenemek hogohogok tinene momooŋ mintawek. Biyagoŋ hinek, indi nemenemek tiyam hogohogok u du kedem tubufafaŋeweŋ kaŋ momooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Me nediyeŋ Bepaŋ Loloŋnitdi kadokodok nadiŋa adi’walaŋkade uune Bepaŋ Saŋiniŋ Molomdi kadokoune hatilak, adi Yahwedok indiŋ nimbek, ");
INSERT INTO nop_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","“Dagoŋ yahehewe tinamuŋa momooŋ hinek nabudokolaŋ, tiŋa da kubugoŋdi Bepaŋne hatilaŋ. Unduŋ doktiŋa du kubugoŋ nadisukilitigamulat.” ");
INSERT INTO nop_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Biyagoŋ hinek, Bepaŋdi gehitubu-lodaune nemek gehitubu-kadakadok kabup hebihakiiŋ wendi tuwot mu gehitubu-kadakaneeŋ. Tiŋa undugoŋ, gabu-ulidokoune yagit hogohi fafaŋehi hinek tuwot mu mintagamneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Adi pupup tamuniŋdi wapmihiŋiye papalidi yehikufulalak wondok tuwolit hinek gehikufulaluwaak. Du Wapum’walaŋ papaliŋiŋ gineŋ hebihalune momooŋ hinek gabudokoluwaak. Adi gabudokodok yalaŋ mu yolak, unduŋ doktiŋa du me kweletalak gut galiŋa yakiiŋ wendok tuwot Wapum’walaŋkade wooŋ galiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Du timiŋ nemek mikhinitdok munta mu tiluwaaŋ. Be hadapmo nemek maŋiŋ miknit niŋdi pilap hinek mintaaŋ gehitubu-kadakawaakneŋ yoŋa munta mu tiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Du yagit kadakaniŋdi timiŋ mintagambaakneŋ yoŋa munta mu tiluwaaŋ. Be hadapmo munabuli hogolidi pilap hinek mintagamuŋa gehitubu-kadakawaakneŋ yoŋa munta mu tuluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Me 1 tausendi du halaaŋneŋ yamaiŋgoŋ uŋgoŋ binek kumuneeŋ, be me 10 tausendi kohoge didimeniŋneŋkade binek kumuneeŋ, iŋgoŋ nemek miknit hogoli wendi mu gehitubu-kadakaluwaak. ");
INSERT INTO nop_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Da daugedi hinek yabune Bepaŋdi me kadakaniŋ titiŋ hekidok kibikoŋhik tubu-udaneyembaak. ");
INSERT INTO nop_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Du nemek kadakahi gineŋ doktiŋa Yahwe’walaŋkade uune Bepaŋ loloŋnit hinek adi hogokdi gabudokolak, ");
INSERT INTO nop_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","wendoktiŋa nemek hogolidi du foloŋ tuwot mu mintagamuluwaak. Eŋ yagit hogolidi du yokeneŋ mu mintaluwaak. ");
INSERT INTO nop_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Wapumdi aŋelo hekidok kwanai-mede yembune daŋgoŋdaŋgoŋ waaŋ u adi kedem gabudokoyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Tiŋa kawadedi kayoge youlaakneŋ doktiŋa adi kohohikdi gehitiloneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Kaŋ du adi laion eŋ miŋgembet miknit eŋ laion pamala tiŋa miŋgembet wapuhi hinek u yehiyaliwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Bepaŋdi indiŋ yolak, “Metam nediyeŋ welehikdi hinek nabukahileiŋ adi yadi kotigoŋ yanagilaat. Tiŋa metam nediyeŋ nu hogok hinek nadinamiiŋ adi yadi momooŋ hinek yabudokoluwaat. ");
INSERT INTO nop_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Adi naninadiune yonadihik nadiyemiluwaat. Eŋ malabumuŋ mintayemiluwaakneŋ nu adigut hatiluwaat. Unduŋ tiŋa kotigoŋ yanagila wohikgigit momooŋ yemiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Tiŋa wendok tuwahik adi hatihatihik tomboyouyemiluwaat. Unduŋ tiŋa kotigoŋ yanagilene nakat noŋgoŋ hatiyaneem.” ");
INSERT INTO nop_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Yahwe, du Bepaŋ Loloŋnit hinek, welemomooŋ nadigamuŋa ganiutumba tibene wendi utumba hinek tibek. Tiŋa undugoŋ kap toŋa wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Tiŋa helemahelemaŋ haniŋ-haniŋ welegedi hinek nabukahilelaŋ u yohautaluwaat, eŋ helemahelemaŋ timiŋ indigoŋ tuwot yofafaŋe tuguŋ indigoŋ didimeniŋ hinek keleeŋ nabudokolaŋ wendok yohautaluwaat. ");
INSERT INTO nop_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Nu gita eŋ kulele ulene mede momooŋ tobune wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Nu du kwanai saŋiniŋnit tuguŋ wendok nadiŋa welemomooŋ nadilat, tiŋa nadifooŋ kap tolat. ");
INSERT INTO nop_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Yahwe, du kwanai tilaŋ adi kaŋ nadiwe uŋgoniŋ hinek tilak. Eŋ nadinadige adi fuliŋmamaŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Me nadinadihinit mokit tiŋa me bubuyehi adi yadi nemek i tuwot mu nadidakaleneŋ. ");
INSERT INTO nop_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Metam hogohi adi kilihikitdi momooŋ labiiŋ undihi kedem mintaneeŋ, kaŋ metam kadakaniŋ tiiŋ heki adi metam bomboŋhinit tiŋa iutumba kedem tineeŋ, iŋgoŋ oŋ, du yehitubu-liwedapmaŋ tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Maŋgande, Yahwe, du kubugoŋdi mapme loloŋnit hatilaŋdi hatibaaŋ dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Indi agaŋ nadiyaam, me nediyeŋ du mik tigamiiŋ adi yadi kumuŋ tineeŋ, eŋ me kadakaniŋ titiŋ heki adi yadi yehiyalimoŋgofofoŋ tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Du saŋiniŋ wapum hinek namguŋ woŋ adi makau maahi moihi’walaŋ saŋiniŋhik wondok tuwolit. Tiŋa undugoŋ du momooŋ hinek tinamulaŋ doktiŋa nu nadifo tilat. ");
INSERT INTO nop_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Nu memikneye yehitubu-kadakaguŋ u daunedi agaŋ kagut, eŋ me hogohi’walaŋ makat koyonehik u agaŋ magitnedi nadigut. ");
INSERT INTO nop_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Metam didimehi adi bem kalipdi folooŋ momohi hinek foiŋ wendok tuwolit hinek mintaneeŋ, tiŋa Lebanonhi’walaŋ bem sidadi wapuhi tiiŋ wondok tuwot tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Kaŋ adi yadi bem agaŋ Yahwe’walaŋ yolineŋ yetigiŋ yakiiŋ unduŋ tilak. Adi yadi Bepaŋnik’walaŋ yolineŋ momooŋ hinek loiŋ. ");
INSERT INTO nop_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Adi agaŋ sigida tiiŋ iŋgoŋ oŋ, folooŋ adi tomboyoula minta hogok tiiŋ. Tiŋa undugoŋ kumuŋ mu tiiŋ, adi fafaŋe tiŋa yakiiŋ. Kaŋ hapmuŋhikdi maaŋ undugoŋ kaipmuŋ hakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Titiŋ unduŋ foloŋ Yahwe ne adi didimeniŋ hinek u yobihilune kaiŋ. Adi fafaŋe tiŋa nabudokolak, tiŋa adi yadi yomŋiŋnit mokit. Mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yahwe adi tinahukut beweniŋgoŋ tiŋa Mapme saŋiniŋnit itak. Adi kwet i koom dibek tububihila mintaaŋ hakuk uŋakoŋ tubu-fafaŋeune hatak. ");
INSERT INTO nop_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Yahwe, du nemenemek hogohogok mu mintagiŋneŋ dibek hatiguŋ undiniŋgoŋ hatiguŋdi hatilaŋ, tiŋa undugoŋ Mapme dapmandapmaŋnit mokit hatilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","O Yahwe, imeŋgwaŋ fuliŋmamaŋ adi gibitaŋ muhila mede toiŋ. Adi muhila mede wapum hinek toiŋ. ");
INSERT INTO nop_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Iŋgoŋ Yahwe, du kunum foloŋ ilaŋa saŋiniŋge wapum wendi nemenemek hogohogok u yabudokolaŋ. Tiŋa du’walaŋ saŋiniŋge wapum wendi imeŋgwaŋ giyondaaŋ muhila mede tolak u kalakapme tilak. Ime giyondaaŋ muhila labuŋa luhineŋ kulaŋa mede wapum tolak. Iŋgoŋ imeŋgwaŋ wapum weŋ’walaŋ saŋiniŋdi Wapum’walaŋ saŋiniŋ wendok tuwot mooŋ. ");
INSERT INTO nop_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Eŋ du’walaŋ Yodoko Medege adi hakukdi hatak fafaŋeniŋ. Yahwe, biyagoŋ hinek, du’walaŋ yoke adi uŋgoniŋ hakukdi hatak, eŋ haliwooŋ halaak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Yahwe, du Bepaŋ doktiŋa metam kadakaniŋhinitdok kibikoŋ malabumuŋ didimeniŋgoŋ yembeŋ. Unduŋ tiŋa kwihitage u tubumintaune kaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Agaŋ mu pilataŋ! Kwet diniŋ mede yodapmandapmaŋ, du pilali me foko tiiŋ hekidok kibikoŋ titiŋhik wendok tuwolit tubu-udaneyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Me kadakahidi titiŋhikdok nadifo nai dedigoŋ hinek tineŋ? Yahwe, nai dedigoŋ hinek hayemilak? ");
INSERT INTO nop_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Nai dedigoŋ hinek hayembune me hogohi adi kadakaniŋ tigiŋ wendok foko tiŋa nadifo tineeŋ? ");
INSERT INTO nop_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Yahwe, adi yadi metamgeye yehimoŋgofooŋ malabumuŋ wapum hinek yemiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Adi yadi tam kahat eŋ wapmihi kondiŋahi eŋ metam niŋkadehi indi’walaŋ kwetnineŋ iŋoŋ hatiiŋ u widihi kumuŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Unduŋ tiŋila indiŋ yoiŋ, “Yahwe adi tuwot mu nibilak. Eŋ Isilaehi’walaŋ Bepaŋ adi nemek i tiyam wendok nadibedi mu tilak.” ");
INSERT INTO nop_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Metamneye, hidi detiŋa kudi kauleŋ unduŋ tiiŋ? Bubuyehi hidi, nai deniŋ nadinadihinit tineeŋ? ");
INSERT INTO nop_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Bepaŋdi magitnik tutumbaguk, unduŋ doktiŋa adi tuwot mube nadiwek? Tiŋa undugoŋ, Bepaŋdi daunik tutumbaguk, unduŋ doktiŋa adi tuwot mube diwetomuŋa kawek? ");
INSERT INTO nop_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Adi metambop yenindokodokoyelak, unduŋ doktiŋa yehitubu-didime tuwot mube tibek? Tiŋa undugoŋ, adi yadi metam hogohogok’walaŋ henalehik, unduŋ doktiŋa adi nadinadinit mokit be? ");
INSERT INTO nop_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Yahwe adi metam hogohogok’walaŋ nadinadihik u agaŋ nadidapmalak. Unduŋ doktiŋa nadinadihik u kudige nabugoŋ liwelak, u agaŋ nadilak. ");
INSERT INTO nop_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Yahwe, du me niŋ nindokodokoyeŋ Yodoko Medege nintubudidime tubune me u Bepaŋ’walaŋ kahaŋ kaŋ nadifo kedem tibek. ");
INSERT INTO nop_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Du indiŋ doktiŋa unduŋ tilaŋ: adi malabumuŋ mu minta-mimbune kulemaŋgoŋ hatikulema tilune me kadakahi adi koŋ gineŋ foneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Maŋgande, Yahwe adi metamŋiye tuwot mu biyabek. Biyagoŋ hinek, adi metamŋiye netok gigit tigiŋ adi sigilulum tuwot mu tiyembek. ");
INSERT INTO nop_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Kaŋ mindaŋkade mede nadinadi me mede kwanai tineeneŋ mede agaŋ didimeŋgoŋ hogok yodapmaneeŋ. Kaŋ metam didimehi adi u kaune tuwot hinek tibaak. ");
INSERT INTO nop_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Nediyendi nehitubu-lodaaŋ me kadakahi yehimoŋgofoguk? Eŋ nediyeŋdi nehitubu-lodaaŋ me yom tiiŋ u yehikelekukuk? ");
INSERT INTO nop_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Yahwedi mu binek nehitubu-lodawe tuguk binek adi agaŋ pilap hinek meyotneŋ gwaŋ dahatit. ");
INSERT INTO nop_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Nu indiŋ nadigut, “Kayone agaŋ sulukeneto tilak, ala agaŋ maaŋ nutuwek.” Iŋgoŋ oŋ, Yahwe, du nutok bulaniŋgoŋ hinek nadinamuŋa nohoneune nu kadakaniŋ gineŋ mu maaŋ nutak. ");
INSERT INTO nop_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Tiŋa undugoŋ, nu welemulap nadiŋa nemenemekdok nadinadi fee tilat, kaŋ dagoŋ welene tubukulemaaŋ nadifo tubuminta-namulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Du adi talitimeŋ kadakahi dut mu kwanainelaŋ. Meheki woŋ adi yodoko mede indiŋ kameiŋ, metam adi kadakaniŋ kedem titiŋdok. ");
INSERT INTO nop_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Adi yadi me momooŋ tubukadakadok bopneeŋ yofolok tiiŋ, tiŋa undugoŋ, me yom nemu tiiŋ iŋgoŋ widihikumuŋ titiŋdok nadiŋa mede gineŋ hogok yapmefit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Iŋgoŋ Yahwedi fafaŋe hinek tiŋa nehitubu-lodalak. Bepaŋnedi momooŋ hinek nabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Adi titiŋ kadakahi fee hinek tigiŋ, unduŋ doktiŋa kibibo yomhidok toboniŋ tubu-udaneyembek. Adi kadakaniŋhik u nadisuŋa widihi-kumuŋ tibek. Yahwe Bepaŋnikdi yehitubu-kadakadapmaŋ tibek. ");
INSERT INTO nop_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Hidi but! buune kap toŋa Yahwe wou nintilonim. Indi Bepaŋ saŋiniŋŋiŋ loloŋnitdi yahehewe tinimiŋa kotigoŋ ninigitak, wendoktiŋa kap toŋa nadifo tinim. ");
INSERT INTO nop_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Indi yamaiŋgoŋ wotubudulaaŋ niutumba timinim, tiŋa nadifooŋ nintiloloŋdok kap heki neeŋ tominim. ");
INSERT INTO nop_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Maŋgande, Yahwe adi Bepaŋ Saŋiniŋnit, tiŋa undugoŋ adi yadi Mapme Saŋiniŋnit eŋ bepaŋ yalayalaŋ hogohogok yalakapmedapmaŋ tiŋa looŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Kawade mage ginaŋ fogefoge daŋgoŋ dapmalakneŋ, eŋ kweboboedi logeloge daŋgoŋ dapmalakneŋ, kwet hogohogok u Bepaŋdi yabudokodapmalak. ");
INSERT INTO nop_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Kwet gut imeŋgwaŋ u negoŋ yehitubu-mintaguk, unduŋ doktiŋa negoŋ yabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Hidi but! buune duwokineeŋ niutumbanim. Yahwe negoŋ nihitutumbaguk. Unduŋ doktiŋa wooŋ mulelem timinim. ");
INSERT INTO nop_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Adi negoŋ Bepaŋnik. Adi negoŋ metamŋiye dompa nabugoŋ nibudokolak, tiŋa nanaŋe nimtei tilak. Unduŋ doktiŋa kamiŋ hidi adi’walaŋ maŋiŋ mede nadiŋa takalineŋ. ");
INSERT INTO nop_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Wapumdi indiŋ yolak, “Hidi koom mamahi-papahiyedi Meliba tiŋa Masakwet fiileŋ uŋoŋ tigiŋ unduŋ, welekwambuŋ mu taneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","“Adi kudi saŋiniŋnit tugut u kakabeleŋila kwet fiileŋ uŋoŋ hali nalamut tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","“Nu gulet 40 wendok tuwot metam bop u yabuŋa nadiwene madimadikeŋgoŋ tuguk. Wendogoŋ tiŋa indiŋ yogut, ‘Welehikdi nu mu nehikeleiŋ. Helemahelemaŋ adi nu talik yenindidimelat u mu takaliiŋ.’ ");
INSERT INTO nop_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","“Unduŋ doktiŋa kisaŋ hinek nadikadakayemiŋa mede yofafaŋe indiŋ tugut, ‘Biyagoŋ hinek, nu hatikule kwet hamdok yofafaŋegutneŋ uŋoŋ tuwot mu usuwaneeŋ hinek.’” ");
INSERT INTO nop_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Hidi Yahwedok kap kobuli tomineŋ. Metam hogohogok kwetfoloŋ hatiiŋ hidi Yahwedok kap tomineŋ. ");
INSERT INTO nop_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Yahwedi kotigoŋ ninigikuk. Unduŋ doktiŋa kap toŋa wou nintiloneŋ! Indi melenai tuwot indigoŋ wendok nadiŋa metam yenihautayaneem. ");
INSERT INTO nop_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Hidi metam hogohogok wougigitŋiŋ yenihautaneŋ. Kwanai wapuhi momohi tuguk u metam hogohogok yenimbihitneŋ. ");
INSERT INTO nop_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Yahwe adi wougigitnit. Unduŋ doktiŋa wou niŋatilone foloniŋgoŋ halek. Indi aditok hogok gikiŋgoŋ timiyaneem. Eŋ bepaŋ yalayalaŋ hekidok adi gikiŋgoŋ mu tiyemdok. ");
INSERT INTO nop_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Bepaŋ yalayalaŋ metam noli’walaŋ woŋ adi bepaŋ biyagoŋ mooŋ. Yahwe ne kunum tiŋa nemenemek uŋoŋ hakiiŋ u yehitubu-mintaguk. ");
INSERT INTO nop_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Yahwe adi wougigitnit tiŋa Mapme loloŋnit itak. Tiŋa adi yoli uŋgoniŋ hinek gineŋ uŋoŋ nemenemek hakiiŋdi adi’walaŋ saŋiniŋŋiŋ eŋ tinahukutŋiŋ beweniŋgoŋ u wendi yobihikiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Metam kwetkwet hatiiŋ, hidi hogohogok saŋiniŋŋiŋ eŋ wougigitŋiŋ nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Hidi Yahwe wougigitŋiŋ nintiloneŋ. Tiŋa siloŋ timindok nemek neeŋ moŋgola Siloŋyotneŋ foneŋ. ");
INSERT INTO nop_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Metam hogohogok kwetkwet hatiiŋ, hidi Yahwedok heheleeŋ Wapum Uŋgoniŋ, hauta holiholiŋenit hatilak, niutumbayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Hidi metam hogohogok indiŋ yenineŋ, “Yahwe adi Mapme loloŋnit! Adigoŋ kwet tubufafaŋeune waliwali mu tiŋa hatak. Adi kougoŋ titiŋ didimeniŋ tiŋa metam hogohogok medehik nadiŋa yodapmawaak.” ");
INSERT INTO nop_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Kunum kwet, hidi nadifo tidemek. Imeŋgwaŋ wapum tiŋa nemenemek imeŋgwaŋ maaneŋ hakiiŋ, hidi ime giyondaaŋ muhilaŋa mede tobune baham toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","13","Dinina tiŋa nemenemek dinina gineŋ uŋoŋ hakiiŋ hogohogok hidi nadifo tineŋ. Yahwe adi buŋa kwet wapum i kadokowaak doktiŋa bem heki behepneŋ yakiiŋ adi nadifo tiŋa kap toneeŋ. Yahwe adi metam hogohogok titiŋ didimeniŋ tiŋa yabudokowaak. Eŋ mede biyagoŋ hogok yoŋa mede nadinadi kwanai tibaak. ");
INSERT INTO nop_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yahwe adi Mapme itak! Wendoktiŋa kwet du nadifo tibeŋ! Eŋ kwet kambaŋgit imeŋgwaŋ lekiŋgoŋ haliwiiŋ hidi maaŋ welemomooŋ nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Adi yadi mulukwaŋ gut mambipdi tumulune haliŋa titiŋ didimeniŋ tiŋa metam yehitubu-didimeeŋ ha yabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Kudupdi talitimeŋ timiŋa memikŋiye yehidalak. ");
INSERT INTO nop_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Wapum’walaŋ hautadi filimpit tiŋa kwetkwet tubuhautaune kwetdi u kaŋ hehele tilak. ");
INSERT INTO nop_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yahwe adi kwet hogohogok diniŋ Wapum. Unduŋ doktiŋa adi buune kweboboe heki adi bitakaaŋ fooŋ dagidagik tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Eŋ kunumdi adi’walaŋ titiŋŋiŋ didimeniŋ u yobihitak. Kaŋ metam hogohogokdi Wapum loloŋnit’walaŋ hautaŋiŋ filimpipitnit u kaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Metam bepaŋ yalayalaŋ yeniutumbaaŋ wohiye yenimbeloiŋ adi yadi yehitubu-meka tilak. Kaŋ bepaŋ yalayalaŋ heki adi Yahwedok mulelem timiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Saiyonhi metam hogohogok eŋ Juda yokwet wapuhi, adi Yahwe du mede nadinadi kwanai tilaŋdok nadifo tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Yahwe, du Bepaŋ Saŋiniŋ Molom. Du kubugoŋdi kwetkwet kadokolaŋ. Du wohogegigitnit, tiŋa undugoŋ bepaŋ yalayalaŋ heki yalakapmedapmaŋ tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Yahwe adi weleŋdi hinek metam nediyeŋ kadakaniŋ yabukwihita tiiŋ u yabukahile tilak. Adi yadi metamŋiye didimehi momooŋ hinek yabudokooŋ me hogohi’walaŋ kohohik gineniŋ kotigoŋ yanagitak. ");
INSERT INTO nop_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Bepaŋ adi metam didimehidok hauta yemilak. Kaŋ welehik maaneŋ nadifo mintalak. ");
INSERT INTO nop_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Metam didimehi, hidi Yahwedi nemenemek tuguk wendok nadiŋa nadifo tineŋ. Bepaŋ adi momooŋ hinek eŋ titiŋ didimeniŋ hogok tilak. Unduŋ doktiŋa wondok welemomooŋ nadimiŋa niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Yahwe adi nemenemek momohi tuguk. Unduŋ doktiŋa indi kap kobuli tominim. Adi saŋiniŋŋiŋ eŋ titiŋŋiŋ uŋgoniŋ wendoogoŋ tiŋa mik gineŋ fafaŋeeguk. ");
INSERT INTO nop_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yahwe adi mik gineŋ fafaŋeeguk wendok agaŋ yohautaguk. Ala Isilaehi metam yahaŋegukneŋ nai uŋaniŋ saŋiniŋŋiŋ tubumintaune metambop nolidi kagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Adi mede yofolok tuguk wendoktiŋa helemahelemaŋ Isilaehi yabukahileeŋ bulaniŋgoŋ nadiyemiŋa mu biyabuguk. Kwetkwet metam hogohogok Bepaŋnikdi mikgineŋ fafaŋeeŋ kotigoŋ ninigikuk u agaŋ kaŋ nadidapmaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Unduŋ doktiŋa metam hogohogok hidi kap tonadifo Yahwedok timineŋ. Welenadifo kap toŋa Yahwe wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Gita ulaŋa kap toŋa Yahwe wou nintiloneŋ. Gita ulune medeŋiŋ momooŋ hinek tobek. ");
INSERT INTO nop_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Yahwe adi Mapme, doktiŋa bai eŋ manaŋ fedila nadifooŋ baham toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Eŋ imeŋgwaŋ tiŋa nemenemek imeŋgwaŋ gineŋ hatiiŋ, hidi gibitaŋ kakalineŋ. Kaŋ kwet tiŋa metam eŋ nemenemek hogohogok kwetfoloŋ hatiiŋ, hidi kap toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Ime wapum, ime miiŋ, hidi kohopapa utneŋ. Kaŋ kweboboe heki, hidi Yahwe namanda foloŋ kap toŋa nadifo tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Maŋgande, adi buŋa kwetkwet kadoko-dapmawaak. Tiŋa Mapme loloŋnit ila titiŋ didimeniŋ helemahelemaŋ tiŋa metam hogohogok yabudokoluwaak. ");
INSERT INTO nop_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yahwe adi Mapme itak, doktiŋa metambop noli adi hehele tiiŋ. Adi yadi mapme kumopopŋiŋ foloŋ aŋelo heki yalakapmeeŋ looŋ itak, kaŋ kwet wapum i tibitim tilak. ");
INSERT INTO nop_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Yahwe adi Saiyon uŋoŋ saŋiniŋnit hatilak, tiŋa mebop hogohogok wanakaŋ yabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Metam hogohogokdi nadimimbune adi kubugoŋdi mapme loloŋnit tiŋa wougigitnit tilak. Kaŋ wougigitŋiŋ u nintiloneŋ. Adi yadi uŋgoniŋ. ");
INSERT INTO nop_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Mapme fafaŋeniŋ, du adi titiŋ didimeniŋdok hogok nadilaŋ. Du Isilaehi metam inditok titiŋ didimeniŋ tiŋa momooŋ nimguŋ kaŋ takaliyam. Tiŋa undugoŋ da nemenemek yofafaŋeguŋ u takaliŋa titiŋ didimeniŋ hogok tiŋa nibiulidokolaŋ. ");
INSERT INTO nop_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Hidi Yahwe Bepaŋnik, adi’walaŋ wou hogok nintiloneŋ. Hidi yamaiŋgoŋ wooŋ niutumbaneŋ. Adi yadi titiŋ momooŋ tiŋa didimeniŋ diniŋ Bepaŋ. Adi yadi uŋgoniŋ. ");
INSERT INTO nop_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moses dut Alon adi Yahwe’walaŋ Siloŋyot diniŋ talitimeŋ hatigumuk. Eŋ Samuel adi maaŋ mebop Bepaŋ ninadiyagiŋ’walaŋ nohik. Kaŋ adi ninadihik wanaŋ nadiyemdapmaaŋ yehitubu-lodaluguk. ");
INSERT INTO nop_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Adi mulukwaŋ wapum gineŋ haliŋa mede yeniŋguk. Kaŋ adi Yodoko Mede Bepaŋdi yemguk u takaligiŋ. ");
INSERT INTO nop_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","O Yahwe Bepaŋnik, du yonadihik nadiŋa kibibo yeniŋguŋ. Du yom bibiŋ Bepaŋ hatilaŋ, iŋgoŋ oŋ kadakaniŋhikdok kibikoŋ yeniŋguŋ. ");
INSERT INTO nop_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Yahwe Bepaŋnik wou nintilonim, tiŋa kweboboeŋiŋ uŋgoniŋ foloŋ uŋoŋ hali niutumbanim. Yahwe Bepaŋnik adi uŋgoniŋ. ");
INSERT INTO nop_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Metam hogohogok kwetkwet hatiiŋ, hidi Yahwedok nadifo tiŋa kap toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Hidi Yahwe welemomooŋ nadimiŋa niutumbaneŋ. Eŋ yamaiŋgoŋ wo-tubudulaaŋ nadifo kap tomineŋ. ");
INSERT INTO nop_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Hidi indiŋ yohautaneŋ. Yahwe kubugoŋdi Bepaŋ hinek. Adigoŋ nihitubu-mintaguk, unduŋ doktiŋa indi adi netok gigit hatiyam. Memetamŋiye indi adi dompaŋiye dabugoŋ. ");
INSERT INTO nop_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Indi adi’walaŋ Siloŋyotneŋ fofoŋdok niutumba tiŋa fonim. Eŋ yoli maaneŋ fooŋ wou nintilonim. Unduŋ tiŋa niutumbaaŋ wougigitŋiŋ nintilo tinim. ");
INSERT INTO nop_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Maŋgande, Yahwe adi titiŋ momooŋ hogok tilak. Tiŋa helemahelemaŋ weleŋdi hinek nibukahilelak. Adi yadi helemahelemaŋ medeŋiŋ yofafaŋeguk u baigoŋ didimeniŋgoŋ hinek takalilak. ");
INSERT INTO nop_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Yahwe, du siloŋ tobogoŋ tinimilaŋ tiŋa titiŋ didimeniŋ hogok keleeŋ mede yodapmalaŋ wendok kap tobit. Tiŋa undugoŋ, Wapum, nu dutok hogok nadiŋa kap tobit. ");
INSERT INTO nop_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Nu adi titiŋ didimeniŋ hogok takaliwit. Kaŋ Wapum, du deniŋ hinek buŋa nehitubu-lodawaaŋ? Nu adi yotneneŋ titiŋ didimeniŋ hogok tiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Nu titiŋ kadakahi be nemenemek madimadikehi adi mu yabudok nadilat. Nu adi me Bepaŋ sigilulum timiiŋ heki’walaŋ titiŋhikdok adi nadiwene tuwot moŋ hinek tilak. Nu adi adigut tuwot mu yauluwaat. ");
INSERT INTO nop_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Nu adi yalaŋ talik mu takaliluwaat, unduŋ tiŋa titiŋ kadakahidok adi mu nadiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Nu adi me nediyeŋ meeniŋ nolidok kabup yeniwoliwolike tiyemilak u tubukadaka hinek tiluwaat. Unduŋ tiŋa me gifoko heki adi tuwot mu biyabene hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Nu adi me Bepaŋ hogok baigoŋ takaliiŋ yabukahilewene adi hogokdi nu yotneneŋ nakat hatiyaneem. Tiŋa me titiŋ didimeniŋ hogok tiiŋ heki adi hogokdi nu’walaŋ kwanai taneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Me yalaŋ mede yoiŋ heki adi yadi nu yotne wapumneŋ uŋoŋ mu hatiyaneeŋ. Tiŋa undugoŋ, me yalaŋ talik foloŋ yokamehebi tiiŋ heki adi yadi nukut tuwot mu hatidok. Mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Helemahelemaŋ me kadakahi indi’walaŋ kwetnineŋ iŋoŋ adi yehitubu-kadaka hogok tiluwaat. Nu adi me titiŋ kadakaniŋ tiiŋ heki u yehikelekulene adi Yahwe’walaŋ yokwetŋiŋ wapumneŋ iŋoŋ mu hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Yahwe, yonadine nadinambeŋ. Nehitubu-lodaweŋdok kutibulabulayene du’walaŋ kamewe ulak, doktiŋa fiit nadinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Malabumuŋdi mintanambune kaaŋ, du nai uŋaniŋ kibidaaŋ binabu mu tuluwaaŋ. Fit yonadine nadinamuluwaaŋ. Kutibulabulayene kamewe du’walaŋkade uune kaŋ pilap hinek nehitubu-lodaluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Hatihatine adi kudigedi muniniŋ looŋ liwe tilak wondok tuwolit. Eŋ foloone adi kudut hinek, kudupdi daaŋ nibune nadiyam wondok tuwolit. ");
INSERT INTO nop_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Welene adi kilihikit fidokone sigeneŋ kumiiŋ wondok tuwolit. nehinalitifolak. Wendoktiŋa nanaŋe nanaŋdok mu nadilat. ");
INSERT INTO nop_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Nu folofigita nadiŋa gibitaŋ yonelat. Kaŋ foloone adi agaŋ kigita hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Nu adi kalaŋkatak niŋdi kwet fiileŋ hatilak wondok tuwolit na hogok hatat. Eŋ yokwet niŋ tubukadakaiŋ kaŋ kwetbelebele hogok halune bagi muŋgoŋdi ila diwelak wondok tuwolit hatat. ");
INSERT INTO nop_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Be gulupne foloŋ hatat, iŋgoŋ damo deikuli mu tiŋa hogok hadiwelat. Nu na hogok bagi niŋdi yot ki foloŋ ila diwelak nabugoŋ bulaniŋgoŋ hatat. ");
INSERT INTO nop_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Kaŋ hadapmo be timiŋ adi memikneye adi naniŋkadaka tiiŋ. Tiŋa nanimpekit tiŋa yeiŋ adi wotnene yoŋa haki tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","Du nutok kwihita wapumgoŋ hinek tinamulaŋ, kaŋ nu kudufuluŋdi nanaŋene tilak. Eŋ dautilitiliknedi imene tout gineŋ foune ime gut wanaŋ silotnalat. Du nemek geŋgeŋhinit gilem gineŋ beyakukam wele nehitikukuŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Hatihatine adi tebele daune meledi saŋiniŋnit mokit gweheyeŋ diweeŋ fohebilak wondok tuwolit. Tiŋa undugoŋ nu adi kilihikit kumuŋ sigene tiiŋ undiniŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Iŋgoŋ Yahwe, du adi Mapme dapmandapmaŋnit mokit hatilaŋ. Unduŋ doktiŋa metam hogohogok mindaŋ tomboyoula mintati uneeŋ adi yadi du nadidapma-gamuneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","I agaŋ du’walaŋ nai tilak, doktiŋa Saiyon yokwetdok welege goloune siloŋ tobogoŋ tiŋa tubulodaweŋ. Welebulaniŋgoŋ nadimiŋa tubulodadok nai agaŋ iŋakoŋ mintalak. ");
INSERT INTO nop_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Saiyon yokwet u agaŋ tubukadakagiŋ, iŋgoŋ kwanai-megeye adi yadi welehikdi hinek kahileiŋ. Tiŋa undugoŋ, yokwet u tubukadakaaŋ wiyapupuhene-hinaka tigiŋ, iŋgoŋ adi yadi welehikdi aditok golohinakalak. ");
INSERT INTO nop_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Metam hogohogok adi Yahwedok munta tiŋa adi’walaŋ hebeŋ foloŋ hadapmaneeŋ. Kaŋ kwetfoloŋ me mapme hogohogok adi’walaŋ saŋiniŋŋiŋ doktiŋa munta tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Kougoŋ Yahwedi Saiyon yokwet kotigoŋ tubupilalaak, nai uŋaniŋ saŋiniŋŋiŋ tubumintaune kaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Tiŋa metamŋiye koom sigilulum tiyemguk adi’walaŋ yonadihik nadiyembaak. Tiŋa yonadihik tineeŋ u kotigoŋ sigilulum mu tiyembaak. ");
INSERT INTO nop_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Ale indi nemenemek hogohogok Yahwedi tuguk u pepa foloŋ youdapmane halaak, ala kougoŋ yalakiniyedi kahat u kedem nadiŋa wou nintiloneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Indi kudiye indiŋ youtnim, “Yahwe adi yoli-kweli uŋgoniŋ gineŋ hali kwediwe tubune foguk. Adi kunum gineŋ hali kwediwe tubune kwetfoloŋ foguk. ");
INSERT INTO nop_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Kaŋ me yot fafaŋeniŋneŋ yapmefit tubune hali malabumuŋhikdok kutibulabulaye tigiŋ u nadiguk. Eŋ me kumuŋdok yenindapmagiŋ heki u yehitubu-lodaaŋ yanagikuk.” ");
INSERT INTO nop_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Unduŋ doktiŋa Jelusalem uŋoŋ metamdi Yahwe wou yohautaaŋ Saiyon kweboboe foloŋ niutumba tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Kwanai woŋ adi metam hogohogok tiŋa me mapmehiye wanakaŋ buŋa bopneeŋ Yahwe niutumbaneeŋneŋ uŋoŋ tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Nu hatihatine diniŋ nai kougoŋ hatilune Yahwedi saŋiniŋne ulatifooŋ nehitubu-gweheyeguk. Unduŋ tinamguk doktiŋa nu nai kweheyeniŋ tuwot mu hatibaat. ");
INSERT INTO nop_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Unduŋ nadiŋa Bepaŋ indiŋ ninadigut, “Bepaŋne, du hatiguŋdi hatilaŋ. Eŋ nu adi gawada mu tugut, nu adi mekuya kougoŋ hatilat. Unduŋ doktiŋa hatihatine pilap mu nolomtibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","“Du koomkwaha kwet i tubumintaguŋ kaŋ hakukdi hatak. Tiŋa kohogedi kunum tiŋa nemenemek uŋoŋ ikiiŋ u yehitutumbaguŋ. ");
INSERT INTO nop_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Kwet gut kunum adi liwedemeek, iŋgoŋ da yadi hatibaaŋ. Adi yadi hauledi buba tiŋa kadakaiŋ unduŋ tidemeek. Tubune du beyakulune liwe tidemeek. ");
INSERT INTO nop_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","“Iŋgoŋ du yadi heleŋde undiniŋbo undiniŋbo mu yagitaŋ. Du yadi dibek hatiguŋ undiniŋgoŋ hinek hatilaŋ. Eŋ du’walaŋ hatihatigedi dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Wendoktiŋa du wapmihiniye yabudokoune kedem hatineeŋ. Eŋ tomboyoula yalakihiye kougoŋ mintaneeŋ u maaŋ yabudokoune helemahelemaŋ dakat wanakaŋ hinek hatiyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Welenedi Yahwe niutumbawit. Foloone hogohogokdi Yahwe wou uŋgoniŋ u nintilowit. ");
INSERT INTO nop_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Welenedi Yahwe wou nintiloit, tiŋa nemenemek momooŋ tinamguk u kaule mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Adi kadakaniŋne hogohogok tumolokutnamuŋa yagit folofigitane hogohogok liliwenekutnamulak. ");
INSERT INTO nop_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Kumuŋdok tilat gineniŋ Wapumdi kotigoŋ nanagitak. Tiŋa weleŋ wapumdi nutok kameeŋ siloŋ tobogoŋ tinamulak. ");
INSERT INTO nop_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Kwetfoloŋ hatilat indigoŋ tuwot Wapumdi nemenemek momohi tuwot hinek namtoko tilak. Unduŋ tubune nu kotigoŋ mekuya yageleeŋ kalaŋkatakdok tuwolit tiŋa saŋiniŋnit hatilat. ");
INSERT INTO nop_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Metam gweheyehi nadiyembune fofoŋnit tubune malabumuŋ yemfit tiiŋ adi Yahwedi kwanai didimeniŋ tiŋa yehitubu-lodalak. Tiŋa kotigoŋ yehitubu-kaikaune kedem hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Adi nemenemek titiŋdok hogohogok u timeŋ Moses nimbune nadiguk. Kaŋ mindaŋ Isilaehidi kwanai saŋiniŋnit tuguk u kagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yahwe adi inditok bulaniŋgoŋ kisaŋ hinek nadiŋa helemahelemaŋ siloŋ tobogoŋ tinimilak. Adi yadi kwihita pilap mu tilak, adi yadi toboniŋ weleŋdi nibukahile tilak. ");
INSERT INTO nop_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Adi nibukwihitafit mu tilak. Eŋ kwihita siyogigi mu tilak. ");
INSERT INTO nop_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Indi adi kadakaniŋnik diniŋ tuwaŋiŋ nimdok molomolom hinek iŋgoŋ oŋ, mu nimilak. Tiŋa undugoŋ indi kadakaniŋ fee tugumun kaŋ kibikoŋ malabumuŋ wapum tubu-udanenimdok iŋgoŋ oŋ, adi unduŋ mu tilak. ");
INSERT INTO nop_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Metam nediyeŋ aditok gikiŋgoŋ timiiŋ, adi yadi kunumdi kwet bikabuŋa foloniŋ hinek gwaŋ hatak wondok tuwot weleŋdi yabukahile hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Kwet mele labulabu tilak be kwet mele fohebi tilak, adi yamaiŋgoŋ kikakika mu ti hakamuk. Mokoŋ. Adi kweetniŋ, molomolom hakamuk. Wondok tuwot hinek Bepaŋdi kadakaniŋnik tumolokulune kweetniŋ hinek gwaŋ wooŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Me niŋdi wapmihiŋiŋdok momooŋ timilak, undugoŋ hinek Yahwedi metam nediyeŋ aditok gikiŋgoŋ timiiŋdok undugoŋ momooŋ tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Adi kwetdi moŋgola nihitutumbaguk doktiŋa agaŋ nadinimilak indi adi kwam hogok. ");
INSERT INTO nop_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Metam indi’walaŋ hatihatinik adi, kilihikit nabugoŋ. Doktiŋa wowoŋgimiŋ hekidi sigeneeŋ golopmaiŋ wondok tuwot indi maaŋ nai muniniŋ-kabe hatiŋa pilap kumuyam. ");
INSERT INTO nop_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Sububadi wowoŋgimiŋ fedilune waliwali tiŋa makwaneiŋ kaŋ meeniŋdi kotigoŋ mu yabiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Iŋgoŋ oŋ, Yahwe adi metam nediyeŋ aditok gikiŋgoŋ timiiŋ, adi hekidok helemahelemaŋ siloŋ tobogoŋ tiyemilak. Tiŋa yalakihiye mindaŋ mintaiŋ adi maaŋ momooŋ tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Eŋ nediyeŋdi Wapum’walaŋ yofolok eŋ Yodoko Medeŋiŋ tagimneeŋ keleiŋ adi yadi siloŋ tobogoŋ tiyemilak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yahwe adi kunum gineŋ mapme iit kwetŋiŋ foloŋ itak. Eŋ ne kubugoŋdi nemenemek hogohogok diniŋ mapme tilak. ");
INSERT INTO nop_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Yahwe’walaŋ aŋelo hogohogok saŋiniŋhik loloŋnit hinek, hidi adi medeŋiŋdok magi kametnadi tiiŋ, tiŋa maŋiŋ mede takaliiŋ. Unduŋ doktiŋa hidi Wapum wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Yahwe’walaŋ kwanai-meŋiye, hidi kunum gineŋ haliŋa adi’walaŋ nadinadiŋiŋ takaliiŋ, hidi Yahwe wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Nemenemek hogohogok Yahwedi hehitubu-mintaguk kwetkwet haliwiiŋ kaŋ negoŋ hidi’walaŋ mapme itak, hidi Yahwe wou nintiloneŋ. Kaŋ nu welenedi undugoŋ niutumbawit. ");
INSERT INTO nop_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Welenedi Yahwe niutumbawit! Yahwe, du Bepaŋne, du adi loloŋnit hinek. Tiŋa du adi Mapme loloŋnit hinek eŋ wohogigitnit. ");
INSERT INTO nop_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Du adi hautadi folooge mukufuladapmaaŋ hataŋ. Tiŋa kunum adi haule yehitubu-bateyeyam nabugoŋ tububateyeune hatak. ");
INSERT INTO nop_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Tiŋa yoke adi mulukwaŋ yalakapmeeŋ foloniŋ gimiŋgimiŋ hinek gwaŋ maguŋ. Eŋ mulukwaŋdi kalisge kali wilihinit wosidi yehimaneiŋ undiniŋ nabugoŋ tilak. Kaŋ sububadi ganagila yaulak. ");
INSERT INTO nop_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Du sububa niŋkulune medege tiŋa yaulak. Kaŋ filimpit tiŋa hauta tilak woŋ adi kwanai-mege. ");
INSERT INTO nop_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Du kwet i kwelineŋ dibek kameguŋ undugoŋ fafaŋeŋ hatak, adi kweli bikabu-kabe nemu tilak. Mokoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Du imeŋgwaŋ wapum kameune kwet kufulaguk, kaŋ imedi kweboboe yehikufulaguk. ");
INSERT INTO nop_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Iŋgoŋ mindaŋ ime nintobune naŋgali foguk. Tiŋa undugoŋ gibitaŋ kutifiyeune imeŋgwaŋdi nadihakene momoŋ uguk. ");
INSERT INTO nop_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Imeŋgwaŋ wapum adi kweboboe bikabuŋa kwet gutuneŋ foguk. Da imeŋgwaŋdi daŋ halaak nadiguŋ wondok tuwot undugoŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Da fek kamemiŋguŋ. Kaŋ imeŋgwaŋ wapum u fek mu lahutak. Wendoktiŋa imeŋgwaŋdi kwet i kotigoŋ mu kufulalak. ");
INSERT INTO nop_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Dagoŋ nadilaŋ kaŋ kweboboe yaliwiiŋ lekiŋgoŋhik foloŋ kubali gineŋ ime sikiiŋ, sila labuŋa wodiŋa wooŋ kwet gutuneŋ wiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Kale moihi adi ime uŋakoŋ naiŋ, eŋ doŋki heki adi maaŋ ime uŋakoŋ naiŋ, kaŋ mahik kotigoŋ mu galilak. ");
INSERT INTO nop_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Eŋ bagi hekidi maaŋ yohik bem ime gagayeŋ yakiiŋ wendok foloŋgoŋ maiŋ, tiŋa bem taŋeniŋ foloŋ ila medehik toiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Du kunum gineŋ hali gwi kameune fooŋ kweboboe foloŋ malak, kaŋ du’walaŋ kahaŋgedi kwet wapum i tokidapmalak. ");
INSERT INTO nop_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Dagoŋ nadilaŋ kaŋ kilihikit labiiŋ kaŋ makau hekidi naiŋ, eŋ nemenemek metam indi diniyetiyam u maaŋ nadilaŋ kaŋ looŋ folooŋ mintaiŋ kaŋ behenaŋ tiyam. ");
INSERT INTO nop_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Eŋ wain tutumbaaŋ naaŋ nadifo tiyam, tiŋa bem olif meniŋŋiŋ galikit u namandatnik foloŋ hafiyeeŋ waliniŋ diweyaam. Eŋ nanaŋe nakilitiŋa saŋiniŋhinit tiyam. ");
INSERT INTO nop_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Gwi maune bem Lebanon uŋoŋ yakiiŋ adi kokoihikdi ime kedem hinek hamaneiŋ. Bem sida heki adi Yahwe ne’walaŋ hinek, u koom negoŋ yetiguk. ");
INSERT INTO nop_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Bagi heki adi bem sida foloŋ yohik uŋgoŋ maiŋ. Eŋ kowaŋ heki adi kwele foloŋ yohik maiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Kaŋ meme moihi adi kweboboe foloŋ hatiiŋ, eŋ daumeŋ heki adi kawade mage ginaneŋ hebihakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Du muyakip kameguŋ kaŋ adi gulet indigoŋ tuwot muyakip nai yobihitak, eŋ mele adi nai deniŋ tebeledaune fohebidok u agaŋ nadilak. ");
INSERT INTO nop_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Dagoŋ nadiguŋ kaŋ mambip mintaguk, unduŋ doktiŋa mambip tilak kaŋ kale moihi hogohogok adi tali yawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Kaŋ laion pamala adi kale du yemilaŋ u yehisiŋa nanaŋdok mahaŋ gibita toŋa yawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Ala mele labulak kaŋ kotigoŋ momoŋ wooŋ kawade mage gineŋ foiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Kaŋ metamdibo pilali wooŋ kwanaihik tihatibune wooŋ bufalak. ");
INSERT INTO nop_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Yahwe, du yadi nemenemek fee hinek tutumbaguŋ. Du adi nadinadige loloŋnit hinek doktiŋa nemenemek hogohogok i tutumbaguŋ. Kaŋ nemenemek hogohogok kwetfoloŋ iŋoŋ kilidapmaaŋ hatak u da yobune mintadapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Imeŋgwaŋ adi wapum kakaŋ hinek, kaŋ pisi wapuhi eŋ kuyahi tiŋa nemek noli maaneŋ hakiiŋ, u indi kunadapmanimdok tuwot mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Kaŋ muwage wapuhi adi imeŋgwaŋtabe uŋgoŋ woŋambuŋat tiiŋ, eŋ pisi wapuhi yapmeguŋ adi maaŋ ime gineŋ yauŋila tatakut tatakut tiyawiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Nemenemek hogohogok adi map tiŋa du nanaŋe nai foloŋgoŋ yembeŋ yoŋa woom hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Kaŋ dagoŋ nanaŋe yemilaŋ kaŋ natoki tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ala du sigilulum tiyemilaŋ kaŋ adi munta tiiŋ, eŋ munabuthik yolom tilaŋ kaŋ adi kumuŋa kotigoŋ kwet yageleiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Dagoŋ munabut fedidahiyembune adi kaipmuŋ hatiiŋ. Tiŋa undugoŋ dagoŋ nadilaŋ kaŋ nemenemek gitipmuhi kwetfoloŋ iŋoŋ mintaaŋ labiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Yahwe’walaŋ wougigitŋiŋ adi dapmandapmaŋnit mokit hatuwaak. Eŋ Yahwe ne adi nemenemek hogohogok tutumbaguk wendok nadifo tibek. ");
INSERT INTO nop_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Adi kwet kaune kwet adi tibitim tilak, eŋ kohoŋdi kweboboe wehemilune kweboboe foloŋ mupmuk labulak. ");
INSERT INTO nop_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Nu kaipmuŋ hatiŋa Yahwedok kap fee tomiluwaat. Nu mu kumuŋa kaipmuŋ hatiŋila Bepaŋne wou nintilooŋ kap heki tomiŋa hatigene kumumbene dapmawaak. ");
INSERT INTO nop_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Negoŋ nadifo tubumintanamulak, unduŋ doktiŋa nu’walaŋ nadituwatuwale i kedem nadiŋa nadigalika tibek. ");
INSERT INTO nop_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Yahwe, du metam kadakaniŋ titiŋ heki hogohogok u kedem yehitubu-kadakaweŋ. Nu adi me hogohi u liwehinaka tineŋdok nadilat. Welenedi Yahwe niutumbawit! Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Yahwe welemomooŋ nadimiŋa niutumbaneŋ, tiŋa wougigitŋiŋ yotubuhautaneŋ. Tiŋa undugoŋ kwanai wapuhi uŋgoniŋ hinek tuguk wendok kwetkwet metam hogohogok yenihautaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Kap tomiŋa wou nintiloneŋ, tiŋa nemenemek hogohogok uŋgoniŋ tuguk u yohautaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Indi Wapumdok gigit hatiyam, unduŋ doktiŋa aditok nadifo tinim. Eŋ metam nediyeŋ Yahwe hebeŋ foloŋ wotubudulaaŋ hati niutumbaiŋ, adi nadifo kedem tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Yahwe’walaŋkade unene nihitubu-lodawek. Kaŋ hebeŋ foloŋ wotubudulaaŋ uŋgoŋ hatiyaneem, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Hidi Wapum’walaŋ kwanai-meŋiŋ Abalaham’walaŋ yalakiŋiye, eŋ me Bepaŋdi me kahileguk Jekop, adi’walaŋ yalakiŋiye, hidi kudi wapuhi uŋgoniŋ hinek eŋ kunum diniŋ kudi tuguk u kotigoŋ nadisuneŋ. Tiŋa undugoŋ me kadakahidok tuwahik kibikoŋ kadakaniŋ hinek yemguk u maaŋ nadisuneŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yahwe adi Bepaŋnik. Adi’walaŋ yodapmandapmaŋ medeŋiŋ adi metam hogohogok kwetkwet hatiyam inditok wanakaŋnik. ");
INSERT INTO nop_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Yofolok tuguk u tubukilitiune haliwooŋ halaak, kaŋ medeŋiŋ yofafaŋe tuguk u metam bop wapum kougoŋ mintaneeŋ wendok tuwot haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Yofolok i koom Abalaham dut tuguk, ala Aisakdok adi mede yofafaŋe tuguk. ");
INSERT INTO nop_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Yahwedi yofolok i Isilaehi gut tuguk, kaŋ yofolok i dapmandapmaŋnit mokit hatak. Yofolok i Jekop metamŋiye gut tubukaikaguk, ala yofolok yoŋ adi mu dapmawaak. ");
INSERT INTO nop_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Adi Jekop indiŋ niŋguk, “Kanahan kwet u gambe da tiŋa metamgeye hiditok gigit tibaak.” ");
INSERT INTO nop_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Koom Bepaŋ’walaŋ metam adi lufom-kabe hinek hatigiŋ. Unduŋ doktiŋa Kanahan kwetneŋ uŋoŋ adi metam buŋambu unduŋ hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Adi kwet dambek kubugoŋ mu ikagiŋ, adi yadi kwet uŋaŋbo it, uŋaŋbo it tiyawagiŋ. Adi unduŋ tiyauŋila me mapme niŋ’walaŋ kwet gineŋ uŋaŋbo ila kotigoŋ pilali wooŋ mapme niŋ’walaŋ kwet gineŋ uŋaŋbo it unduŋ tiyawagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Iŋgoŋ Wapumdi mebop noli biyabune mu yehitubu-kadakayagiŋ. Tiŋa undugoŋ mapme hekidi kadakaniŋ mu tiyemdok yeniŋkamehep tiyemguk. ");
INSERT INTO nop_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Unduŋ tiŋa indiŋ yeniŋguk, “Kwanaine tinamdok metamneye yehidaneeŋ yabukahilegut u hidi mu yehitubu-kadakaneŋ. Be polofetneye u maaŋ undugoŋ mu yehitubu-kadakaneŋ.” ");
INSERT INTO nop_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Yahwedi nadiune kwehineŋ fiye kadaka wapum mintaguk, kaŋ nanaŋe map tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Iŋgoŋ adi Josep kameune talikom tiyemiŋa Isip kwetneŋ uguk. Adi Josep tuwadok yogiŋ kaŋ me nolidi tuwaaŋ nagiwooŋ tipilapilaye-me tuwaŋit mokit kameune hati kwanaineyemguk. ");
INSERT INTO nop_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Kaŋ yot fafaŋeniŋneŋ kamegiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Undugoŋ halune wooŋ kougoŋ maŋgoŋ mintawaak yoguk u folooŋ mintaguk. Kaŋ Yahwe’walaŋ mededi Josep’walaŋ medeŋiŋ biyagoŋ hinek tubudakaleguk. ");
INSERT INTO nop_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Kaŋ Isiphi’walaŋ me mapmedi me niŋ niŋkulune wooŋ Josep yot fafaŋenineŋ niŋkulune fouguk. ");
INSERT INTO nop_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Kaŋ me mapmedi Josep gapmanŋiŋ diniŋ talitimeŋ kameguk. Unduŋ kameguk doktiŋa Josep adi Isiphi’walaŋ kadokome wapum hatiguk. ");
INSERT INTO nop_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Adi me mapme’walaŋ kwanai-meŋiye me loloŋhinit u timeŋ tiŋa yabudokoluguk tiŋa undugoŋ mebop mapmedok nadinadi miyagiŋ yeniyehitubu-didime titiŋdok saŋiniŋ halimiŋguk. ");
INSERT INTO nop_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Kaŋ mindaŋkade Jekop adi wooŋ Isip kwetneŋ uŋoŋ buŋambu itouguk. ");
INSERT INTO nop_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Kaŋ mindaŋ Yahwedi metamŋiye yehikahaŋneune wapmihihiye fee hinek minta-ulihakagiŋ. Tiŋa yehitubu-lodaune adi’walaŋ saŋiniŋhikdi memikhiye’walaŋ kalakapmeguk. ");
INSERT INTO nop_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Adi negoŋ nadiune Isiphidi metamŋiye mik tiyemgiŋ, tiŋa Isiphidi kudi kadakahi mu titiŋ u tiyemgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Mindaŋ Wapumdi kwanai-meŋiŋ Moses tiŋa Alon kwanai-meŋiŋ yehikahileeŋ yehitubu-dakaleguk, adi yapmeune Isipde ugumuk. ");
INSERT INTO nop_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Kaŋ adi Bepaŋ’walaŋ mebi kakaŋ kwanai eŋ Bepaŋ kunumneniŋ’walaŋ kudi uŋgoniŋ hinek Isip uŋoŋ tugumuk. ");
INSERT INTO nop_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Bepaŋdi nadiune kwehineŋ mambip wapum mintaguk, iŋgoŋ Isiphi adi medeŋiŋ mu nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Adi yobune imehik hogohogok naŋgatnit tubudapmagiŋ, kaŋ ime diniŋ kale hogohogok kumuŋdapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Eŋ hawom mohok fee mumuyeŋ mintaaŋ me mapme yoli wapum be yohikwehik u kilidapmaŋ tugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Bepaŋdi yobune bubugaim gut muntilikdi fee mumuyeŋ hinek mintaaŋ kwetkwet eŋ yokwet gineŋ tuwot kilidapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Adi kwehineŋ uŋoŋ filimpit tubune gwi mindip maguk. ");
INSERT INTO nop_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Wondi bem kilik, wain eŋ fik yehitubu-kadakaguk, eŋ bem noli maaŋ yehidakumuŋtaugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Adi mede hogok yobune gwatak mohok fee mumuyeŋ mintagiŋ, kunakunathik loloŋnit hinek me niŋdi kunatdok tuwot mooŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Kaŋ adi kwet uŋoŋ diniŋ nemenemek hapmuŋhinit hogohogok u nadapmagiŋ, eŋ dininahik gineŋ yuwoi-yuwoi be nanaŋe hogohogok u maaŋ nadapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Tiŋa Bepaŋdi Isiphi’walaŋ mihi tuwo hogohogok u widihikumun-dapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Kaŋ mindaŋ Isilaehi yanagilune Isip bikabuŋa ugiŋ. Adi Isiphi’walaŋ fukuthik gol be silwadi momooŋ hinek tutumbayagiŋ u moŋgodapmaaŋ ugiŋ, tiŋa undugoŋ adi’walaaniŋ nebek niŋdi nemu kadakaguk. Adi yadi wanakaŋ kunilit hinek kedem hadapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Isiphi adi Isilaehidok munta kisaŋ tiyemgiŋ, unduŋ doktiŋa mawagiŋ kaŋ yabuŋa nadifo tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Bepaŋdi yobune mulukwaŋ niŋ foloniŋ yobune mintaaŋ hali metamŋiye yooŋ tiyemguk, eŋ timiŋ adi yobune kudupmebem niŋ daŋeŋa hautayemguk. ");
INSERT INTO nop_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Nanaŋedok ninadigiŋ kaŋ bagi gwediwik boiyembu buune widihi henagiŋ, eŋ kunum nanaŋe mana kahaŋnit kwatneyembu natoki tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Adi nadiune kawade wapum tawaune ime sila labuguk, tiŋa kwatneeŋ kwet fiileŋ kiŋ tabe ime behepneŋ wodiiŋ wendok tuwolit wodiŋa uguk. ");
INSERT INTO nop_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Adi koom kwanai-meŋiŋ Abalahamdok mede yofafaŋe tuguk u kaule mu tiŋila uŋgoŋ hati nadilak. ");
INSERT INTO nop_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Unduŋ doktiŋa metamŋiye yanagilune ugiŋ. Memetam woŋ adi agaŋ netok gigit yehidaneeŋ yabukahileguk, metam wondi kakali tiŋa nadifooŋ maugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Kwet metambop noli’walaŋ u aditok yemguk, tiŋa nadiyembune wooŋ metambop noli’walaŋ dininahik u nehitok yabukahilegiŋ. ");
INSERT INTO nop_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Isilaehidi adi’walaŋ maŋiŋ mede be Yodoko Medeŋiŋ wanakaŋ hinek tagimneneŋdok unduŋ tiyemguk. Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Yahwe niutumbaneŋ! Adi helemahelemaŋ titiŋ momooŋ tilak, eŋ weleŋdi hinek dapmandapmaŋnit mokit nibukahilelak. Unduŋ doktiŋa indi adi welemomooŋ nadimiŋa niutumbanim. ");
INSERT INTO nop_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Adi nemek wapuhi wapuhi tuguk wendok me nediyeŋdibo yoŋa kahat tibek? Tiŋa undugoŋ, me nediyeŋdi kedem adi’walaŋ titiŋŋiŋ momooŋ hinek wendok tuwolit wou nintilowek? ");
INSERT INTO nop_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Me nediyeŋdi adi’walaŋ medeŋiŋ takaliŋa titiŋ didimeniŋ helemahelemaŋ tiiŋ, adi yadi Bepaŋdi kahaŋ tiyembune nadifo kedem tiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Yahwe, du metamgeye yehitubu-lodawaaŋneŋ nai uŋaniŋ nu maaŋ nadinambaaŋ. Ala adi yehitubu-lodaaŋ kotigoŋ yanagiliŋila, nu maaŋ kotigoŋ nanagilaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Nu adi metamgeyedi bomboŋ duhuduhunit iutumbaune adigut nadifo titiŋdok nadilat. Indi du’walaŋ metamgeye hatiyam doktiŋa nadifo tiŋa ganiutumbayaneem. ");
INSERT INTO nop_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Indi koom mamani-papaniyedi tigiŋ unduŋ, kadakaniŋ agaŋ tumun. Indi titiŋ kadakaniŋ mebimebi tumun. ");
INSERT INTO nop_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Isip uŋoŋ mamani-papaniye adi du kwanai wapuhi tuguŋ u mu nadidakalegiŋ. Du nai fee hinek yehitubu-lodaguŋ, doktiŋa du adi yabukahile hinek tilaŋ u agaŋ nadigiŋ. Iŋgoŋ oŋ, wendok agaŋ kaule tigiŋ, tiŋa Imeŋgwaŋ Giminiŋneŋ uŋoŋ wosuwaaŋ Bepaŋ Saŋiniŋ Molom, du foko tigamgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Iŋgoŋ Wapum adi saŋiniŋŋiŋ loloŋnit u tubune kaneŋ nadiguk, doktiŋa adi gigitmede agaŋ koom yeniŋguk u takaliŋa yehitubu-lodaaŋ kotigoŋ yanagilune kadaka mu tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Adi Imeŋgwaŋ Giminiŋ u mede gibitaŋgoŋ hinek nimbune imeŋgwaŋ u naŋgakuk, kaŋ metam yahaŋeune kwet siliŋ tabe uŋgoŋ wooŋ imeŋgwaŋ fokolok logiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Adi me mik tiyemgiŋ heki’walaŋ kohohik gineniŋ kotigoŋ yahaŋeguk. Adigoŋ yehitubu-lodaune memik hekidi mu yehitubu-kadakagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Iŋgoŋ imeŋgwaŋdi memik heki u yehikufula-dapmaŋ tuguk. Kaŋ nebek-kabe niŋdi kaipmuŋ nemu hakuk. ");
INSERT INTO nop_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Wapum adi unduŋ tubune metamŋiye adi gigitmedeŋiŋ yeniŋguk u nadisukilitigiŋ, tiŋa kap toŋa niutumbagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Iŋgoŋ pilap hinek Wapumdi nemek tuguk u agaŋ kaule tigiŋ. Unduŋ tiŋa timeŋ Bepaŋ’walaŋ medeŋiŋdok woom mu tagiŋ, adi nehi’walaŋ nadinadi takaliyagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Ala kwet fiileŋ uŋoŋ welehikdi nanaŋe fofohidok nadigalika tiŋa Bepaŋ talamut tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Adi Bepaŋ nemek wendok niŋgiŋ kaŋ yemguk, tiŋa undugoŋ nadiune yagit wapum maaŋ mintayemguk. ");
INSERT INTO nop_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Adi kwet fiileŋ uŋgoŋ hatiŋila me nolidi Moses dut Alon, Yahwe ne’walaŋ kwanai-meŋiyat’walaŋ kwanaihik u kaŋ nadigalika tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Unduŋ doktiŋa kwet tawaune Datan dut Abilam tiŋa mebophiye adi kwet tawagukneŋ uŋgoŋ fodapmaune kwetdi yehikumuyeguk. ");
INSERT INTO nop_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Kaŋ kudupmebemdi fooŋ me nediyeŋ adi yehikelegiŋ metam hogohi u yehidakumuŋguk. ");
INSERT INTO nop_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Adi Holep kweboboe foloŋ uŋoŋ hali goldi makau tutumbagiŋ, tiŋa bepaŋ yalayalaŋ u wotubudulaaŋ mulelem timiŋa niutumbagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Adi yadi makau kilihikit nanaŋ tiiŋ heki’walaŋ welewele tutumbaaŋ mulelem timiŋa niutumbagiŋ. Titiŋ unduŋ tiŋa Bepaŋ wougigitŋiŋ ulatifogiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Bepaŋ adi Isip uŋoŋ kwanai saŋiniŋnit hinek tuguk, tiŋa Isilaehi Isiphi’walaŋ kohohik gineniŋ yehitubu-lodaaŋ kotigoŋ yahaŋeguk. Iŋgoŋ Isilaehi adi nadikaule timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Bepaŋ adi kwanai wapuhi-wapuhi loloŋnit hinek Isip uŋoŋ tuguk, eŋ Imeŋgwaŋ Giminiŋneŋ uŋoŋ nemek beweniŋgoŋ hinek tubune metamdi u kaŋ boho tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Iŋgoŋ kaule timiŋgiŋ doktiŋa Bepaŋdi metamŋiye yehitubu-kadaka titiŋdok yoguk. Iŋgoŋ Bepaŋ ne me niŋ kahileeŋ kwanai-meŋiŋ nindapmaguk, Moses adi Bepaŋ namanda foloŋ yali Isilaehi yehitubu-lodaaŋ Bepaŋ weleŋ kudup daguk u tubukulemaguk, kaŋ mu yehitubu-kadakaguk. ");
INSERT INTO nop_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Adi Bepaŋdi gigitmede yeniŋguk u mu nadisukilitigiŋ doktiŋa kwet momooŋ u welehikdi kahile hinek mu tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Adi seli yothik gineŋ hali Yahwedok nadimimbune tuwot mu tuguk, kaŋ adi’walaŋ medeŋiŋ mu nadimiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Kaŋ Bepaŋdi mede yofafaŋe hinek tiŋa yoguk. Metam u kwet fiileŋ uŋoŋ kumuŋdapmaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Eŋ yalakihiye kougoŋ mintaneeŋ heki adi yehikelekulune wooŋ metambop noli’walaŋ lekiŋgoŋhik gineŋ hatineeŋ, tiŋa kwet niŋkade uŋoŋ kumuneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Mindaŋkade Peo yokwetneŋ uŋoŋ bepaŋ yalayalaŋ Bal aditok gigit titiŋdok yoŋa mulelem timiŋa niutumbagiŋ. Unduŋ tiŋa bepaŋ hatihatinit mokitdok dumuŋ hemiŋgiŋ u nagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Unduŋ tigiŋ kaŋ Bepaŋdi kwihitaaŋ kibibo nadiune yagit hogoli wapum hinekdi adi’walaŋkade mintayemguk. ");
INSERT INTO nop_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Iŋgoŋ Finiasdi pilali me yom tigiŋ heki u yomhidok kibikoŋ malabumuŋ tubu-udaneyemguk kaŋ yagit hogoli u biyabuguk. ");
INSERT INTO nop_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Kaŋ wendoktiŋa hali buune kobuk indi hatiyam, indi adi’walaŋ titiŋŋiŋ didimeniŋ u nadisuyam, kaŋ kougoŋ-kougoŋ metam hogohogokdi naditomboyoula tiŋa uneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Isilaehi adi Meliba imeneŋ uŋoŋ hali Bepaŋ weleŋ tubukadakaune kwihita tuguk, kaŋ metam’walaŋ yomhik doktiŋa Mosesdi nemek tubukadakaguk. ");
INSERT INTO nop_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Metamdi Moses weleŋ tubukadakaune kwihitaaŋ mede hogok kaka yofit tuguk. ");
INSERT INTO nop_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Adi Yahwedi mebop kwehiwahi nadisukilitihinit mokit u widihikumuŋ-dapmaŋdok yeniŋguk, unduŋ mu tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Isilaehi adi toboniŋ metambop Bepaŋ mu niutumbayagiŋ hekidut hekimalam tiŋa adi’walaŋ titiŋhik hogohi u takaligiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Unduŋ tiŋa bepaŋ yalayalaŋ mulelem tiyemiŋa yeniutumbagiŋ, kaŋ wondoktiŋa Bepaŋdi yehitubu-kadaka tuguk. ");
INSERT INTO nop_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Adi yadi nehi’walaŋ mihihiye eŋ wabihiye u widihiŋa bepaŋ yalayalaŋdok dumuŋ heyemgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Adi nehi’walaŋ mihihiye eŋ waabihiye widihikumuŋgiŋ. Wapmihi adi nemek yom nemu tigiŋ, iŋgoŋ hogok widihikumuŋa Kanahanhi’walaŋ bepaŋ yalayalaŋdok siloŋ timiŋgiŋ. Kaŋ naŋgathikdi kwet u tubukadakaune Bepaŋ namanda foloŋ geŋgeŋnit tuguk. ");
INSERT INTO nop_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Unduŋ tiŋila nehi maaŋ Bepaŋ namanda foloŋ geŋgeŋhinit mintagiŋ. Unduŋ tiŋa Bepaŋ sigilulum timiŋa adi’walaŋ yofolok mu takaligiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Kaŋ Yahwe adi wendoktiŋa kwihita tiŋa metamŋiye yabune madimadikeŋgoŋ hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Unduŋ doktiŋa biyabune metambop nolidi yabudokogiŋ. Unduŋ tubune memik heki’walaŋ kohohik gineŋ hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Kaŋ memik hekidi malabumuŋ fee hinek yemgiŋ. Unduŋ tiŋa adi’walaŋ saŋiniŋhikdi yabudokoune malabumuŋnit hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Nai fee hinek Yahwedi metamŋiye yehitubu-lodaguk, iŋgoŋ adi yadi nehi’walaŋ nadinadi keleeŋ foko tiŋa Wapum’walaŋ medeŋiŋ kelehapenekula kadakaniŋ fee tigiŋ doktiŋa widihiŋa yehitifohinaka tuguk. ");
INSERT INTO nop_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Iŋgoŋ adi Yahwe ninadiyagiŋ kaŋ adi yonadihik u nadiyemiluguk, tiŋa adi momooŋgoŋ hinek mu hatibune yabuŋa bulaniŋgoŋ nadiyemiluguk. ");
INSERT INTO nop_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Welesiloŋ tiyemiŋa kotigoŋ adut yofolok tuguk u nadisuluguk. Unduŋ tiŋa moŋ kaŋ wabiŋa nadinadiŋiŋ kotigoŋ fambekeneliguk. ");
INSERT INTO nop_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Kaŋ adibo memik Isilaehi kwanaimiŋ gineŋ yapmeeŋ yabudokoyagiŋ heki’walaŋ nadinadihik tubufambekeneune Isilaehidok bulaniŋgoŋ nadiyemgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Yahwe Bepaŋnik, du metambop noli’walaŋ kohohik gineniŋ nihikibidali kotigoŋ ninigileŋ. Unduŋ tiŋa ninigilune kotigoŋ inde’walaŋ kwetnineŋ unim. Unduŋ tubune indi du Bepaŋ titiŋ momooŋ eŋ didimeniŋ hogok tilaŋ, du nadigamnim. Unduŋ tiŋa nadifo foloŋ ganiutumbaaŋ wohoge uŋgoniŋ u yotilonim. ");
INSERT INTO nop_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Yahwe niutumba titiŋdok. Isilaehi’walaŋ Bepaŋ kobuk nai indidegoŋ nintiloloŋdok eŋ tomboyoula nintiloune haliwooŋ halaak, dapmandapmaŋnit mokit! Kaŋ metam hogohogok wanakaŋ indiŋ yoneŋ, “U biyagoŋ!” Yahwe niutumba titiŋdok! ");
INSERT INTO nop_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Yahwe adi momooŋ hinek doktiŋa welemomooŋ nadimiŋa niutumbanim. Adi weleŋdi hinek dapmandapmaŋnit mokit nibukahilegukdi nibukahilelak. ");
INSERT INTO nop_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Yahwedi memik heki’walaŋ kohohik gineniŋ hehikibidali hanagikuk. Wendoktiŋa metam hogohogok indi wanakaŋ Wapum wou nintilonim. ");
INSERT INTO nop_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Adi Judahi niŋkade wooŋ hatigiŋ, mele labulabuneŋkade eŋ mele fofoŋneŋkade be kwet wahiŋkade eŋ kwet kumaŋkade, hidi wanaŋ hanagikuk. ");
INSERT INTO nop_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Kaŋ noliyeŋ kwet fiileŋ yokwet wapum wooŋ kahileeŋ iitdok talik lohigiŋ, ");
INSERT INTO nop_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","tiŋa undugoŋ nanaŋe eŋ ime map tiŋa agaŋ kadakanim yoŋa nadibedi tigiŋ, ");
INSERT INTO nop_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","adi malabumuŋ gineŋ unduŋ hatiŋila Yahwe kutnimbulabulayeune ne kubugoŋdi nadiyemiŋa momooŋ hinek yehitubu-lodaguk. ");
INSERT INTO nop_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Tiŋa adigoŋ talik yenindidimeeŋ yanagila wooŋ yokwet wapum niŋ gineŋ yapmeune itowiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Wapum adi weleŋdi hinek yabukahilegukdi yabukahilelak doktiŋa titiŋ momooŋ hinek tiŋa helemahelemaŋ yehitubu-lodalak. Unduŋ doktiŋa adi Yahwe kedem welemomooŋ nadimiŋa niutumbayaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Metam ime map tiiŋ adi ime tuwot hinek yembune nahaikaiŋ, eŋ metam nanaŋe map tiiŋ adi nanaŋe tuwot hinek yembune natoki tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","11","Kaŋ metam noli adi Bepaŋ, Saŋiniŋ Molom loloŋnit, sigilulum timiŋa medeŋiŋ mu takaligiŋ wendoktiŋa yot fafaŋeniŋ mambip wapumnit gineŋ tawa fafaŋeniŋdi yehitehiune halune malabumuŋ yemgiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Adi folofigita kwanai gibitaŋ tiŋa gweheyeeŋ maaŋ kwetfoloŋ gwaŋ halune me yehitubu-lodadok nebek nemoŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Adi malabumuŋ gineŋ unduŋ hatiŋila Yahwe kutnimbulabulayeune ne kubugoŋdi nadiyemiŋa momooŋ hinek yehitubu-lodaguk. ");
INSERT INTO nop_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Wapum ne kubugoŋdi unduŋ tiyemiŋa tawa fafaŋeniŋ u dobukuyemguk, tiŋa yot fafaŋeniŋ mambip wapumnit gineniŋ yanagikuk. ");
INSERT INTO nop_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Wapum adi weleŋdi hinek yabukahilegukdi yabukahilelak doktiŋa titiŋ momooŋ hinek tiŋa helemahelemaŋ yehitubu-lodalak. Unduŋ doktiŋa adi Yahwe kedem welemomooŋ nadimiŋa niutumbayaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Tiŋa undugoŋ yot fafaŋeniŋ diniŋ yeme fafaŋehi, momohi hinek tutumbagiŋ u ubulaginekutak, eŋ yeme sumuhep aindi tiiŋ u wobugolokutak. ");
INSERT INTO nop_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Metam noli kadakaniŋ tigiŋ doktiŋa yagit tubumintagiŋ. Eŋ titiŋ hogohi wendogoŋ tiŋa malabumuŋ mintayemguk. ");
INSERT INTO nop_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Kaŋ nanaŋe tuwot mu naaŋ agaŋ kumuŋdok muniniŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Adi malabumuŋ gineŋ unduŋ hatiŋila Yahwe kutnimbulabulayeune ne kubugoŋdi nadiyemiŋa momooŋ hinek yehitubu-lodaguk. ");
INSERT INTO nop_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Unduŋ tiŋa medeŋiŋ kameune wooŋ yehitubu-kedebaguk. Tiŋa kumuŋdok tigiŋ gineniŋ kotigoŋ yehitutumbaaŋ yanagikuk. ");
INSERT INTO nop_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Wapum adi weleŋdi hinek yabukahilegukdi yabukahilelak doktiŋa titiŋ momooŋ hinek tiŋa helemahelemaŋ yehitubu-lodalak. Unduŋ doktiŋa adi Yahwe kedem welemomooŋ nadimiŋa niutumbayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Tiŋa undugoŋ dumuŋ hemiŋa niutumbayaneeŋ. Tiŋa kap toŋa metam hogohogok Wapumdi titiŋ momooŋ tiyemguk u yohautayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Me noli muneeŋhik kwanai muwage wapuhi foloŋ yauŋa tagiŋ. Adi metam’walaŋ bomboŋhik beŋa boiyemyawagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Adi Yahwedi kudi wapuhi fee tubune kagiŋ. Kudi u uŋgoniŋ hinek imeŋgwaŋ foloŋ tubune kagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Wapumdi yobune sububa saŋiniŋnit hinek wendi ime fedigiyondaaŋ beŋa foloniŋgoŋ kula uguk. ");
INSERT INTO nop_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Unduŋ tiŋa muwage heki u imedi yanagi beŋa foloniŋgoŋ looŋ kotigoŋ biyabune fowooŋ ime maaneŋ duwaŋ fohebidegoŋ tagiŋ. Unduŋ tubune me muwage foloŋ yawagiŋ adi yadi saŋiniŋhik fodapmaune agaŋ dapmanim hogok nadiŋa ikagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Me heki u muwage deti yehitubu-didimeneŋ. Nehinile me ime fafaŋehi naaŋ tububuye yawiiŋ unduŋ madabubuyeŋ tiyaugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Adi malabumuŋ gineŋ unduŋ hatiŋila Yahwe kutnimbulabulayeune ne kubugoŋdi nadiyemiŋa momooŋ hinek yehitubu-lodaguk. ");
INSERT INTO nop_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Wapumdi yobune sububa wabiune ime giyondaguk u kulemaaŋ fooŋ hakuk. ");
INSERT INTO nop_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Kaŋ me heki u imeŋgwaŋ kulemaaŋ fohalune kaŋ nadifo tigiŋ. Unduŋ tiŋa Wapumdi yanagilune wooŋ yokwet daŋ une ugiŋneŋ wosuwagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Wapum adi weleŋdi hinek yabukahilegukdi yabukahilelak doktiŋa titiŋ momooŋ hinek tiŋa helemahelemaŋ yehitubu-lodalak. Unduŋ doktiŋa adi Yahwe kedem welemomooŋ nadimiŋa niutumbayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Bepaŋ’walaŋ metamŋiyedut bopneyaneeneŋ wougigit yohautayaneeŋ. Be talitimeŋ hekidut bopneyaneeneŋ undugoŋ, adi lekiŋgoŋhik foloŋ wou nintiloyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Wapum adi ime wapuhi yehitubu-naŋgadapmaŋ tuguk, kaŋ ime kuyahi kwet gineŋ labiiŋ u maaŋ naŋgadapmaŋ tigiŋ kaŋ kwet silidadapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Metamdi kadakaniŋ tubune Wapumdi wendok kibikoŋ kwet galikit u yobune dawaŋ daguk kaŋ kwet uŋoŋ nemek nemu labiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Wapum adi kwet simintaneŋ yobune ime fee wodigiŋ unduŋ tubune kwet simintaaŋ u wabiŋa imenit tuguk. ");
INSERT INTO nop_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Unduŋ tiŋa metam nanaŋedok map tigiŋ u yahaŋeune yohikwehik uŋgoŋ tiŋa itougiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Tiŋa nanaŋehik eŋ wainhik diniyeti tubune folooŋ fee mintaune moŋgotnagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Wapum adi metamŋiye yehikahaŋneune wapmihi fee minta ulihaka tigiŋ, eŋ makauhik maaŋ undugoŋ minta-ulihaka tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Eŋ memikhiyedi mik gineŋ folofigita yemiŋa yehitiŋafooŋ yehitubu-mekagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Unduŋ tubune Wapumdi kibibo memikhiye yahaŋeeŋ kwet fiileŋ yapmeune talik lohi hatigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Kaŋ me fiyewakahi hogohi hatigiŋ adi yadi toboniŋ momooŋ hinek yehitubu-lodaguk. Kaŋ wapmihihiyedi dompa bop wendok tuwot minta-ulihakagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Metam didimehidi u kaŋ nadifo tiiŋ. Eŋ metam hogohi adi u kaŋ mede-kabe nemu yoiŋ. Mahik galiune hogok kabup hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Metam nadinadi fuliŋhinit hidi nemenemek hogohogok u nadihinakaneŋ. Tiŋa Yahwe adi weleŋdi hinek nibukahilegukdi nibukahilelak u nadinadiŋila hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Bepaŋ, nu welene gineŋ du nadisukiliti hinek tigamulat. Biyagoŋ hinek nu du hogok nadisukiliti-gamulat. Unduŋ doktiŋa kap toŋa wohoge ganintiloit. Nu welene tubukaikaaŋ Yahwe niutumbawit. ");
INSERT INTO nop_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Tiŋa gita eŋ kulele heki uŋak ulit. Helemiŋ dobulune ule mede toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Yahwe, nu metambop noli’walaŋ lekiŋgoŋhik gineŋ ganiutumbawit. Nu metam hatitawiiŋ indigoŋ tuwot yaudapmaaŋ wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Du welegedi fafaŋeniŋgoŋ hinek nibukahilelaŋ. Indi titiŋ momooŋge u kameka tinim yoŋa kamekanim adi fekŋiŋdi logeloge kunum foloŋ gwaŋ dapmawek. Du helemahelemaŋ mede yofafaŋeluguŋ u didimeŋgoŋ takaliŋa momooŋ tinimilaŋ u kunakanim binemek fekŋiŋdi looŋ mulukwaŋ ikiiŋneŋ uŋgoŋ dapmaluwek. ");
INSERT INTO nop_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Bepaŋ, nu adi metamdi wohoge ganintiloune foloniŋgoŋ hinek gwaŋ hahatdok nadilat. Kwetkwet wanakaŋ da’walaŋ saŋiniŋge u miŋgilaŋgoŋ hinek tubudakale-hinakaweŋ, kaŋ metam hogohogok wanakaŋdi wohogegigit u kedem nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Du nibukahile hinek tilaŋ, doktiŋa yonadinik u nadinimiŋa da’walaŋ saŋiniŋge loloŋnit wendi kotigoŋ ninigileŋ, kaŋ indi kulemaŋgoŋ kedem hatinim. ");
INSERT INTO nop_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Bepaŋ adi Siloŋyotneŋ hali indiŋ yolak, “Nu mik gineŋ agaŋ fafaŋe hinek tugut, doktiŋa Sekemhi’walaŋ kwet eŋ Sukomhi’walaŋ kwet gutuŋ u metamneyedok daneyemtawit. ");
INSERT INTO nop_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gileat dut Manase adi natok. Eŋ Ifeleim adi mik mebimokopne fafaŋeniŋ undiniŋ. Kaŋ Juda adi mapme kuyaŋne undiniŋ. ");
INSERT INTO nop_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Iŋgoŋ Moaphi tiŋa Idomhi adi tipilapilaye kwanai tinamneeŋ. Tiŋa Filistiahi dut mik fafaŋe tiŋa widihidapmagut doktiŋa nadifooŋ kakali tilat.” ");
INSERT INTO nop_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Bepaŋ, yokwet wapum gimbahaŋ fafaŋeniŋnit gineŋ uŋoŋ nediyeŋdi nanagila wek? Be Idomde nediyeŋdi nanagila wek? ");
INSERT INTO nop_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Bepaŋ, du agaŋ sigilulum be tinimguŋ? Du mikmeniye kotigoŋ tuwot mube yehitubu-lodaweŋ? ");
INSERT INTO nop_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Meeniŋdi nihitubu-lodaneŋ iŋgoŋ wondi nemek nemu tibek. Wendoktiŋa dagoŋ kedem nihitubu-lodaune memikniye dut mik tinim. ");
INSERT INTO nop_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Bepaŋdi nihitubu-lodawek woŋ, mik gineŋ fafaŋe hinek tinim. Bepaŋ negoŋ memikniye u yehimoŋgo-fowek. ");
INSERT INTO nop_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Bepaŋ, nu du hogok ganintilolat. Unduŋ doktiŋa fiit yonadine nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Maŋgande, me hogohi tiŋa yalaŋ-me heki adi memik tinamuŋa naniwoliwolike tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Adi mede kadakaniŋ hinek mebinit mokit hogok naniŋfit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Nu adi meheki u yabukahile hinek tiŋa yehitubu-lodadok yonadi kwanai tilat, iŋgoŋ adi yadi mik tinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Nu titiŋ momooŋ tiyemilat, iŋgoŋ adi kibi toboniŋ titiŋ hogoli tinamiiŋ. Nu adi meheki u yabukahile hinek tilat, iŋgoŋ adi yadi nabukwihita tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Me kadakaniŋ niŋ nindapmaune memikne’walaŋ mede nadinadi kwanai tiŋa medeŋiŋ kameka tibek. Kaŋ ne’walaŋ memikŋiŋ niŋdi mede gineŋ kedem kamewek. ");
INSERT INTO nop_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Me mede nadinadi kwanai tibek adi me u yomŋiŋ kedem tubumintamiŋa kameune yot fafaŋeniŋneŋ fowek. Tiŋa undugoŋ, ninadi kwanai tibek u me mede nadinadi medi nadiune u maaŋ kadakaniŋ unduŋ tibek. ");
INSERT INTO nop_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Nu adi me u pilap hinek kumumbune ");
INSERT INTO nop_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","wapmihiŋiye adi behik mokit eŋ tamŋiŋdi yohoi mokit unduŋ hatineŋdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Eŋ wapmihiŋiye adi yaufit tiŋa nayo kwanai tiyaneeŋ. Kaŋ me niŋdi yot hogoli gineŋ itouneeŋ iŋgoŋ fiit yehikelekulune fooŋ uneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Memik u me nolidi nemek miŋgiŋ kaŋ toboniŋ mu nobu tubu-udaneyembek, kaŋ meheki adi kedem buŋa kweli be nemek noli u maaŋ kedem moŋgotneŋdok nadilat. Kaŋ metam yokwet niŋkadehidi nemenemek hogohogok adi tuwadok nadiŋa kwanai tuguk u kedem moŋgodapmaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Nebek niŋdi me wendok momooŋ adi mu timimbek nadilat. Be nebek niŋdi wapmihi behiknit mokit yoŋa bulaniŋgoŋ adi mu nadiyembek. ");
INSERT INTO nop_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Nu adi wapmihiŋiye adi kumuŋ tineŋdok nadilat, kaŋ metam mindaŋ mintaneeŋdi me wendi’walaŋ wou kotigoŋ mu nadineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Nu adi Yahwedi me weŋ’walaŋ mamaŋ-papaŋyedi koom kadakaniŋ tigiŋ u nadisuwekdok nadilat. Unduŋ tiŋa me weŋ miŋ’walaŋ kadakaniŋŋiŋ u mu tumolokulimimbek. ");
INSERT INTO nop_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Yahwe adi kadakaniŋhikdok helemahelemaŋ nadisuluwaak, kaŋ metamdi adi’walaŋ metambopŋiyedok nadikauledapmaŋ tiyemneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Me woŋ adi metam nolidok momooŋ nemu tiyemguk. Adi yadi me fiyewakahi eŋ me nemenemekdok baniŋ tagiŋ eŋ me welemulap nadiyagiŋ, adi heki adi memik tiyemiŋa widihikumuŋ tiluguk. ");
INSERT INTO nop_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Koom adi me nolidi kadaka titiŋdok medehaki yeniluguk. Iŋgoŋ oŋ, kobuk adi toboniŋ negoŋ kadakawek. Adi Bepaŋdi metam noli momooŋ tiyemdok mu ninadiluguk. Unduŋ doktiŋa adi maaŋ Bepaŋ’walaŋ kahaŋŋiŋ u tuwot mu kahilewek. ");
INSERT INTO nop_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Helemahelemaŋ adi meeniŋ nolidi kadaka kedem titiŋdok yenisilone tuluguk, doktiŋa medeŋiŋ wendi netok tinahukutŋiŋ unduŋ timilak. Mede wendi ime nabugoŋ folooŋ maaneŋ sinintawek, eŋ kitiliŋiŋ gineŋ buhumeŋ nabugoŋ sinintaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Tiŋa undugoŋ, medeŋiŋ wendi dahidahi nabugoŋ tinahukulimimbek, tiŋa kiyegelep nabugoŋ gadiŋiŋ foloŋ youkilitiluwaak. ");
INSERT INTO nop_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Memikneyedi mede kadakaniŋ hinek u naniiŋ. Unduŋ doktiŋa, Yahwe, du talik unduŋ foloŋ kibikoŋ malabumuŋ kedem yembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Iŋgoŋ Bepaŋ Wapumne, du adi gigitmede agaŋ koom yoguŋ undugoŋ tiŋa nehitubu-lodaweŋdok nadilat. Du adi momooŋ tiŋa helemahelemaŋ nabukahilelaŋ, unduŋ doktiŋa nehitubu-lodaaŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Nu adi me fofoŋnit tiŋa fiyewakaŋ, nebek niŋdi not tinamuŋa nehitubu-lodadok moŋ, doktiŋa welene gineŋ nadiwene tuwot mu tilak. ");
INSERT INTO nop_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Nu adi tebele meledi fohebilune wolinikdi liwe tilak undugoŋ hinek hatihatinedi liwedok tilak. Tiŋa undugoŋ nu adi gwatak niŋ sububadi fedikulune ulak undiniŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Nu nanaŋe mu naaŋ kamehep tiŋa halene, muune adi saŋiniŋnit mokit tiiŋ. Unduŋ tiŋa kigita tibene kitiline hogohogok adi gweheyedapmaŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Kaŋ metamdi nabuŋa nanimpekit tiiŋ, tiŋa mebiguguŋ tiŋa nabugege tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Yahwe Bepaŋne, du adi helemahelemaŋ nabukahile hinek tilaŋ. Unduŋ doktiŋa nehitubu-lodaaŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Unduŋ tiŋa du dagoŋ nehitubu-lodaaŋ kotigoŋ nanagitaŋ u miŋgilaŋgoŋ tubudakaleune memikneyedi u kaŋ nadidakaleneŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Adi Bepaŋdi nehitubu-kadakawek u kedem yoneŋ, iŋgoŋ oŋ, du adi toboniŋ momooŋ tinambeŋ. Du me kadakaniŋ tinamiiŋ heki u yehimoŋgofoweŋ, kaŋ kwanai-mege nu welemomooŋ nadiwitdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Nu adi memikneyedi meka hinek tineŋdok nadilat. Adi mekadapmaŋ unduŋ tubune metamdi kedem yabuneŋ. ");
INSERT INTO nop_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Iŋgoŋ nu adi mede wapum toŋa Yahwe niutumbait. Eŋ metamdi mulelem tiŋa niutumbadok bopnelune nu adi’walaŋ lekiŋgoŋhik gineŋ wou nintilowit. ");
INSERT INTO nop_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Maŋgande, adi yadi me fiyewakahi yehitubu-lodaaŋ yabudokolak. Unduŋ doktiŋa metamdi mede gineŋ yapmeeŋ kumuŋ titiŋdok tuwot mu yenineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Yahwedi nu’walaŋ wapumne indiŋ niŋguk, “Du kohone didimeniŋneŋkade itune memikgeye kayoge falipmeŋ yapmewaat.” ");
INSERT INTO nop_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Yahwe adi Saiyon uŋoŋ hali nadigambune yokwet fee yabudokowaaŋ. Tiŋa indiŋ yolak. “Memikgeye maaŋ yabudokoweŋ.” ");
INSERT INTO nop_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Du memikgeye gut mik titiŋdok uune metamgeye adi maaŋ nadifo tiŋa dukut noŋgoŋ wooŋ gehitubu-lodayaneeŋ. Unduŋ tiŋa Bepaŋ’walaŋ kweboboe foloŋ loneŋ. Timiŋ indigoŋ tuwot kilihikit adi bamholiŋa mitnekdi tubuhaikaune saŋiniŋ gitipmuŋ belak, wondok tuwot du maaŋ undugoŋ helemahelemaŋ saŋiniŋ gitipmuŋ beluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yahwe adi dutok mede yofafaŋe indiŋ tuguk, “Du adi Siloŋyot diniŋ Talitimeŋ Wapum Melikisedek adi nabugoŋ dapmandapmaŋnit mokit hatiluwaaŋ.” Wapum adi undubo yooŋ undubo yooŋ mu tilak, unduŋ doktiŋa medeŋiŋ yolak undugoŋ biyagoŋ tibaak. ");
INSERT INTO nop_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Wapum adi dukut yali gehitubu-kilitilak. Ala adi weleŋ gouye tilakneŋ nai uŋaniŋ me mapme heki gut mindobuŋa yehiwidihiŋa widihidapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Adi metam nadisukilitihinit mokit heki’walaŋ yomhidok kibikoŋ tubu-udaneyembaak, tiŋa mik kwetneŋ uŋoŋ meeniŋ fee widihikumumbaak. Adi kwetkwet me mapme heki yehimoŋgofowaak. ");
INSERT INTO nop_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Unduŋ tibaak kaŋ du wooŋ ime talik gagayeŋ wodilak u naaŋ saŋiniŋ tiŋa mik gineŋ fafaŋe tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Yahwe niutumbanim! Nu welenedi metamŋiye lekiŋgoŋhik foloŋ welemomooŋ nadimiŋa wou niutumbait. ");
INSERT INTO nop_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Yahwe adi kwanai momooŋ hinek tilak, kaŋ metam nediyeŋ Wapum’walaŋ kwanaiŋiŋ kanadiune momooŋ hinek tilak, adi yadi kwanaiŋiŋ u kaŋ nadidakale hinek titiŋdok nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Nemenemek hogohogok tilak wendi wougigit tubuhautalak, kaŋ wendoktiŋa metamdi gikiŋgoŋ timiiŋ. Eŋ titiŋŋiŋ didimeniŋ woŋ adi dapmandapmaŋnit mokit haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Yahwe adi metamŋiye nadinadihik tubukaikaune adi kwanai momooŋ uŋgoniŋ hinek tuguk u tuwot mu kauleneeŋ. Wapum adi helemahelemaŋ momooŋ tinimiŋa siloŋ tobogoŋ tinimilak. ");
INSERT INTO nop_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Metam nediyeŋ aditok gikiŋgoŋ timiiŋ, metam undihidok adi nanaŋe yemilak. Eŋ metamŋiye gut yofolok tuguk u mu bikabulak. ");
INSERT INTO nop_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Tiŋa undugoŋ, metambop noli’walaŋ kwet u metamŋiyedok yemilak, kwanai unduŋ foloŋ saŋiniŋŋiŋ tubumintaune kaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Adi’walaŋ titiŋ adi didimeniŋ tiŋa mede yofafaŋe tuguk hogohogok u didimeniŋgoŋ takalidapmalak. Indi wendoktiŋa kedem nadisukilitiŋa Yodoko Medeŋiŋ hogohogok u takaliyaneem. ");
INSERT INTO nop_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Bepaŋ adi titiŋ biyagoŋ eŋ didimeniŋ tiŋale Yodoko Medeŋiŋ u yoguk, uyadi dapmandapmaŋnit mokit haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Adi memetamŋiye kadakaniŋ gineniŋ yehifiyakula adut yofolok niŋ tuguk, woŋ adi dapmandapmaŋnit mokit hakukdi hatak. Wapum adi uŋgoniŋ tiŋa saŋiniŋŋiŋ maaŋ uŋgoniŋ. ");
INSERT INTO nop_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Me niŋdi nadinadi me mintawe nadiŋa kaŋ Yahwe gikiŋgoŋ timiluwaak. Maŋgande, adi yadi metam nediyeŋ adi’walaŋ medeŋiŋ nadiŋa takaliiŋ aditok hogok nadinadi momohi yemilak. Unduŋ doktiŋa indi niutumba dapmandapmaŋnit mokit taneem. ");
INSERT INTO nop_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Yahwe niutumbaneŋ! Me nediyeŋ Wapum gikiŋgoŋ timiŋa Yodoko Medeŋiŋdok nadifo tiŋa yehikelelak, adi yadi Bepaŋdi kahaŋ timimbune nadifo kedem tibek. ");
INSERT INTO nop_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Adi’walaŋ wapmihiŋiye adi metam’walaŋ lekiŋgoŋhik foloŋ me saŋihi eŋ wohiyenit hatineeŋ, kaŋ Bepaŋdi me weŋ’walaŋ yalakiŋiye kahaŋ tiyembaak. ");
INSERT INTO nop_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Wapmihiŋiye adi muneeŋ bomboŋ duhuduhunit hatineeŋ, eŋ titiŋ momooŋŋiŋdi dapmandapmaŋnit mokit haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Mambip hatak, iŋgoŋ hautadi hautaaŋ me momohi yehitubu-lodalak. Me momooŋ adi metam nolidok siloŋ tobogoŋ eŋ welekulema tiyemiŋa didimeniŋ hatilak. ");
INSERT INTO nop_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Me siloniŋ niŋ adi metam siloŋ tobogoŋ tiyemilak tiŋa kwanaiŋiŋ didimeniŋgoŋ hinek tilak, adi yadi Bepaŋdi kahaŋ timimbune nadifo kedem tibek. ");
INSERT INTO nop_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Me momooŋ adi nemek niŋ gineŋ tuwot mu gweheyeeŋ malak, kaŋ metamdi me undiniŋ u nadikaule mu timiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Adi malabumuŋ niŋ mintalak kaŋ wondi’walaŋ gigitŋiŋ nadiŋa munta mu tilak. Adi yadi Yahwe hogok fafaŋeniŋ hinek nadisukilitimilak. ");
INSERT INTO nop_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Adi nemenemekdok nadibedi be munta mu tilak. Eŋ memik heki mik gineŋ gweheye tineeŋ u agaŋ nadiŋale hatilak. ");
INSERT INTO nop_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Adi yadi me fiyewakahidok bomboŋ fee yemilak. Eŋ titiŋŋiŋ fofooŋ adi dapmandapmaŋnit mokit hatak. Unduŋ doktiŋa yokwet maaneŋ wougigitŋiŋdi looŋ halune wondoktiŋa wou nintiloneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Me kadakahi adi u kaŋ nadikadaka tiiŋ. Adi me momooŋ wendok nadikwihita timiŋa mindaŋ toboniŋ nehigoŋ dambek fila udapmaiŋ. Unduŋ tiŋa nemek fofooŋ kahiledok woomiiŋ u mu kahileneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Yahwe niutumbaneŋ! Yahwe’walaŋ kwanai-meŋiye, hidi wou nintiloneŋ! ");
INSERT INTO nop_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Indi hogohogok wanakaŋ wou nintilonene dapmandapmaŋnit mokit haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Mele tububihila labuŋa wooŋ fohebilakneŋkade metam hogohogok indi Yahwe wou nintilonim. ");
INSERT INTO nop_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yahwe adi metambop indigoŋ tuwot yabudokolak, kaŋ wougigitdi kunum foloŋ nemenemek yalakapmedapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Nebek niŋdi Yahwe Bepaŋnikdok tuwolit nemoŋ. Adi yadi lohinakaaŋ hatilak. ");
INSERT INTO nop_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Adi diweune foune kunumkwet wanakaŋ yabulak. ");
INSERT INTO nop_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Adi me fiyewakahi yehitubu-lodaune hatihatihik utumba tilak. Tiŋa undugoŋ me nemenemekdok baniŋ tiiŋ u gilem kwetneŋniŋ yahaŋeeŋ yehitubu-lodalak undiniŋ. ");
INSERT INTO nop_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Unduŋ tiŋa yanagila metamŋiye’walaŋ talitimeŋ heki gut yehitomboyoutak. ");
INSERT INTO nop_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Tiŋa undugoŋ tamwoi wapmihi mu yanagikiiŋ u yehitubu-lodaune wapmihi fee yahaŋeiŋ. Unduŋ tiŋa tamwoi adi nadifo tiiŋ. Yahwe niutumbanim! ");
INSERT INTO nop_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Koom Isilaehi adi Isip bikabuŋa ugiŋ. Jekop’walaŋ yalakiŋiye adi metambop noli’walaŋ yokwet u bikabuŋa ugiŋ. ");
INSERT INTO nop_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Unduŋ tiŋa nai uŋaniŋ Judahi adi Wapum’walaŋ metamŋiye uŋgoniŋ hatigiŋ, eŋ Isilaehi yabukahileeŋ yabudokodok yofafaŋeguk. ");
INSERT INTO nop_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Imeŋgwaŋ Giminiŋ adi u kaŋ momoŋ tiŋa uguk, eŋ Jodan ime adi woditau mu tiŋa hogok kwambunda tiŋa hakuk. ");
INSERT INTO nop_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Kaŋ kweboboe wapuhi-wapuhi adi sukuleeŋ meme nabugoŋ tatakut-tatakut tigiŋ, kaŋ tuwai kabekabe heki adi muntaaŋ dompa mihiniŋ nabugoŋ tatakuyau tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Imeŋgwaŋ, maŋgoŋ mintagambune momoŋ tiŋa uguŋ? Jodan ime, dediŋ doktiŋa mu woditauguŋ? ");
INSERT INTO nop_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Kweboboe heki, hidi dediŋ doktiŋa sukuleeŋ meme nabugoŋ tatakut tatakut tigiŋ? Tuwai kabekabe, hidi dediŋ doktiŋa muntaaŋ dompa mihiniŋ nabugoŋ tatakuyaugiŋ? ");
INSERT INTO nop_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Kwet, du kamiŋ Wapum buune hehele tibeŋ. Jekop’walaŋ Bepaŋ agaŋ buŋa gehitubu-dulalak ale hehele tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Adigoŋ yobune kawade gineŋ ime dawi mintalak, eŋ kweboboe diniŋ kawade gineŋ ime wapum wodilak. ");
INSERT INTO nop_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Yahwe, du helemahelemaŋ yofolok tuguŋ u didimeniŋgoŋ takaliŋa nibukahile hinek tiŋa binibu mu tilaŋ. Wendoktiŋa indi adi du wohoge hogok ganintilonim. Eŋ inde’walaŋ wotninik adi mu yotilonim. ");
INSERT INTO nop_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Dediŋ doktiŋa metambop nolidi indiŋ nininadiiŋ, “Bepaŋhik daŋgoŋ hatak?” ");
INSERT INTO nop_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Bepaŋnik kunum foloŋ hatilak. Adi yadi nemek niŋ titiŋdok nadilak woŋ adi undugoŋ hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Metambop noli adi bepaŋ yalayalaŋhik adi gol tiŋa silwadi tutumbagiŋ. Woŋ adi me kohohikdi hogok tutumbagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Bepaŋ yalayalaŋ adi mahiknit, iŋgoŋ adi mede tuwot mu yoiŋ. Tiŋa undugoŋ, dauhiknit iŋgoŋ dau diwe tuwot mu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Adi magihiknit, iŋgoŋ mede tuwot mu nadiiŋ. Tiŋa undugoŋ, adi yadi timehiknit, iŋgoŋ munduŋ tuwot mu suŋgutnadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Adi kohohiknit, iŋgoŋ nemek tuwot mu yohoneiŋ. Eŋ kayohiknit, iŋgoŋ talik tuwot mu yawiiŋ. Tiŋa adi yadi kodihik gineŋ mede folooŋ nemu labuŋa mintaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Me nediyeŋdi bepaŋ yalayalaŋ u yehitutumbagiŋ, adi tiŋa metam nediyeŋdi bepaŋ yalayalaŋ u nadisukilitiyemiiŋ, adi yadi nehi maaŋ undugoŋ bepaŋ yalayalaŋ hekidok tuwolit mintaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Isilaehi metam, hidi adi Yahwedi hehitubu-lodaaŋ habudokolak. Unduŋ doktiŋa adi nadisukilitimineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Yahwe ne kubugoŋdi hehitubu-lodaaŋ habudokolak, unduŋ doktiŋa Alon’walaŋ metam bop, hidi adi Yahwe’walaŋkade wooŋ ulodineŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Yahwe ne kubugoŋdi hehitubu-lodaaŋ habudokolak, unduŋ doktiŋa metam nediyeŋ aditok gikiŋgoŋ timiiŋ, hidi yadi adi foloŋ wooŋ ulodineŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yahwe adi helemahelemaŋ inditok nadilak, unduŋ doktiŋa kahaŋ tinimiluwaak. Tiŋa undugoŋ, Isilaehi eŋ Bepaŋ’walaŋ Siloŋyot diniŋ talitimeŋ heki, adi maaŋ undugoŋ yehikahaŋneluwaak. ");
INSERT INTO nop_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Metam hogohogok nediyeŋdi Yahwedok gikiŋgoŋ timiiŋ, wohiyehinit be wohiyehinit mokit wanakaŋ yehikahaŋneluwaak. ");
INSERT INTO nop_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Nu adi Yahwedi hidi tiŋa yalakihiye kougoŋ mintaneeŋ, hiditok wapmihi fee hamuluwaakdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Yahwedi kunum dut kwet yehitubu-mintaguk, adigoŋ kedem hehikahaŋnewek. ");
INSERT INTO nop_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Kunum adi Yahwe Bepaŋne yolikweli hogok, eŋ kwet adi kedem metam inditok nimguk. ");
INSERT INTO nop_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Metam kumuŋ tiiŋ heki adi yohikwehineŋ wiiŋ, unduŋ doktiŋa adi yadi Yahwe wou mu nintiloiŋ. ");
INSERT INTO nop_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Iŋgoŋ metam kaipmuŋ hatiyam indi adi Wapum nai indidegoŋ tububihila niutumbane haliwooŋ halaak, dapmandapmaŋnit mokit. Yahwe wou nintiloloŋ titiŋdok! ");
INSERT INTO nop_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Yahwe adi kutikutine nadinamulak, unduŋ doktiŋa welenedi kahile hinek tilat. Biyagoŋ hinek, adi yonadine nadinamulak. ");
INSERT INTO nop_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Adi kutikutine hogohogok u nadidapmalak. Unduŋ doktiŋa nu kaipmuŋ hatibaat indigoŋ tuwot adi ninadiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Kumuŋdi tawa nabugoŋ nehi-ibiguk. Nu adi me kumuhidi hakiiŋ kwet u nadisuŋa munta kisaŋ tugut, tiŋa nadibedi kisaŋ hinek tugut. ");
INSERT INTO nop_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Unduŋ tiŋa moŋ kaŋ Yahwe indiŋ kutiniŋgut, “Yahwe, nu tiyaugene kumumbaatneŋ ale kotigoŋ nanagileŋ.” ");
INSERT INTO nop_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yahwe adi siloŋ tobogoŋ tiŋa momooŋ hinek tinimilak. Bepaŋnik adi inditok welebulaniŋgoŋ nadinimilak. ");
INSERT INTO nop_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Yahwe adi me nediyeŋ nehi’niŋ hatihatihik tubulodadok kwanaimiŋ tiiŋ u yehitubu-lodalak. Tiŋa koom nehitubu-kadaka tine tigiŋ kaŋ adigoŋ nanagikuk. ");
INSERT INTO nop_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Yahwedi momooŋ hinek tinamguk doktiŋa nai indide welekulema tubumintalat. ");
INSERT INTO nop_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Yahwe, du munabuline kumuŋ gineniŋ kibidakuŋ Unduŋ tiŋa dagoŋ daune tilitilikne tubusilidaaŋ nabudokoune mu gweheyeeŋ magut. ");
INSERT INTO nop_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Wendoktiŋa nu kwetfoloŋ hatibaat indigoŋ tuwot Yahwe gut hatibaat. ");
INSERT INTO nop_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Malabumuŋ wapum hinekdi nehitiŋafohinakaguk, iŋgoŋ fiit Yahwe nadisukilitimiŋa ninadigut. ");
INSERT INTO nop_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Tiŋa muntaaŋ indiŋ yogut, “Metam hogohogok adi yalaŋ-metam.” ");
INSERT INTO nop_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Yahwe adi momooŋ hinek tinamguk. Ale nu wendok kibikoŋ maŋgoŋ timimbit? ");
INSERT INTO nop_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Nu wain tout niŋ siloŋ titiŋdok tiŋa wit wendi Bepaŋdi kotigoŋ nanagikuk wendok fek tibek. Unduŋ tiŋa Yahwedi kotigoŋ nanagikuk wendoktiŋa niutumbait. ");
INSERT INTO nop_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Metamŋiye buŋa bopneune nu adi’walaŋ namandahik foloŋ maŋgoŋ mimiŋdok yofolokenegut u mimbaat. ");
INSERT INTO nop_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Yahwe’walaŋ metam nadisukilitinit adi ne’walaŋ namanda foloŋ nemek loloŋnit hinek, unduŋ doktiŋa adi’walaaniŋ kubugoŋ niŋdi kumumbune wendok nadiune haŋaniŋgoŋ mu tilak. ");
INSERT INTO nop_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Yahwe, nu kwanai-mege, nu adi du’walaŋ kwanai koom maŋdi tiluguk unduŋ tilat. Du kubugoŋdi tawa nehi-ibikilitiguk u fiyatnamguŋ. ");
INSERT INTO nop_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Nu welemomooŋ nadigamuŋa siloŋdok dumuŋ momooŋ hegambit, tiŋa yonadinedi dutok siloŋ tigambit. ");
INSERT INTO nop_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Agaŋ koom yofafaŋegut, doktiŋa kamiŋ adi agaŋ nemek titiŋdok ganiŋgut u metamgeye namandahik foloŋ tibit. ");
INSERT INTO nop_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Yahwe, nu siloŋ i du yoke maaneŋ Jelusalem uŋoŋ tibit. Indi Yahwe niutumbanim! ");
INSERT INTO nop_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Kwetkwet metam hogohogok hidi Yahwe niutumbaneŋ. Metam hogohogok wanakaŋ noŋgoŋ nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Adi yadi weleŋdi nibukahile tuguk u fafaŋeniŋ hatak. Tiŋa adi yadi medeŋiŋ didimeŋgoŋ hinek takaliŋa mu binibilak, dapmandapmaŋnit mokit. Unduŋ doktiŋa Yahwe niutumbanim! ");
INSERT INTO nop_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Yahwe adi momooŋ tinimilak doktiŋa welemomooŋ nadimiŋa niutumbanim, adi helemahelemaŋ weleŋdi hinek nibukahilelak. ");
INSERT INTO nop_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Isilaehi indi indiŋ yonim, “Adi helemahelemaŋ weleŋdi hinek nibukahilelak.” ");
INSERT INTO nop_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Bepaŋ’walaŋ Siloŋyot diniŋ talitimeŋ heki adi maaŋ undugoŋ yoneŋ, “Adi helemahelemaŋ weleŋdi hinek nibukahilelak.” ");
INSERT INTO nop_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Eŋ metam nediyeŋ Yahwedok gikiŋgoŋ timiiŋ heki, adi maaŋ undugoŋ yoneŋ, “Adi helemahelemaŋ weleŋdi hinek nibukahilelak.” ");
INSERT INTO nop_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Nu malabumuŋ mintanambune Yahwe ninadiwene adi yonadine nadiŋa malabumuŋne u nolomtuguk. ");
INSERT INTO nop_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Yahwedi nukut hatilak, wendoktiŋa nu munta mu tilat. Nebek niŋdi nemek niŋ tinambekdok tuwot mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Yahwedi nehitubu-lodalak, doktiŋa negoŋ memikneye yehiyali-befoune yabit. ");
INSERT INTO nop_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Nemek niŋ momooŋ adi indiŋ, indi mehinek foloŋ mu ulodidok, adi Yahwe hogok nadisukilitimindok. ");
INSERT INTO nop_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Tiŋa undugoŋ, indi me mapme be talitimeŋ heki foloŋ mu ulodidok, adi Yahwe hogok nadisukilitimindok. ");
INSERT INTO nop_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Memik feedi nehikelemadigiŋ, iŋgoŋ oŋ, nu Yahwe’walaŋ saŋiniŋŋiŋ foloŋ yehitubu-liwegut. ");
INSERT INTO nop_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Adi kwetkwet nehikelemadi tiŋa hakiŋ iŋgoŋ oŋ, Yahwe’walaŋ saŋiniŋŋiŋ foloŋ yehitubu-liwe tugut. ");
INSERT INTO nop_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Adi muŋgohomuk heki dabugoŋ buŋa nehikelemadigiŋ iŋgoŋ oŋ, Yahwe’walaŋ saŋiniŋŋiŋ foloŋ yehitubu-liwedapmaŋ tugut. Kaŋ ipaŋdi daaŋ pilap kumulak wondok tuwot pilap kumuŋdapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Adi nukut mindobu tiŋa agaŋ nehitifofoŋdok hinek tigiŋ iŋgoŋ oŋ, Yahwedi nehitubu-lodaguk. ");
INSERT INTO nop_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Yahwe negoŋ saŋiniŋne eŋ youtumbane. Tiŋa negoŋ nehitubu-lodaguk. ");
INSERT INTO nop_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Bepaŋ’walaŋ metamdi mik gineŋ fafaŋe tiŋa memikhiye yehitiŋafooŋ baham toiŋ. Tiŋa indiŋ kutiiŋ, u nadiweŋ. “Yahwe’walaŋ saŋiniŋŋiŋdi hogok nemek u tilak. ");
INSERT INTO nop_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Adi’walaŋ saŋiniŋŋiŋ wapumdi nihitubu-lodaune mik gineŋ fafaŋeeŋ widihidapmayam.” ");
INSERT INTO nop_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Nu adi kumuŋ mu tibaat, mokoŋ. Nu adi toboniŋ kaipmuŋ hatiŋa Yahwedi nemenemek tuguk u kahat yohautawaat. ");
INSERT INTO nop_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Yahwe adi nehitubu-didimewene malabumuŋ kisaŋ hinek namguk, iŋgoŋ mu binabune kumuŋgut. ");
INSERT INTO nop_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Yahwe’walaŋ Siloŋyot diniŋ yeme dilitombune fooŋ wou niutumbawit. ");
INSERT INTO nop_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Yoŋ adi Yahwe’walaŋ yeme, ale metam didimehi hogokdi kedem foneŋ. ");
INSERT INTO nop_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Yahwe, du yonadine nadiŋa nehitubu-lodaune kedem hatilat, doktiŋa ganiutumbalat. ");
INSERT INTO nop_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Yot mamaŋ me hekidi taka fofooŋ niŋ moŋ yoŋa tukukiŋ, iŋgoŋ mindaŋkade taka kobumuŋ mintaguk. ");
INSERT INTO nop_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Yahwe negoŋ kudi uŋgoniŋ u tubune mintaune kanene momooŋ hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Yahwe adi melenai momooŋ nimilak, doktiŋa indi welemomooŋ nadiŋa nadifo tinim. ");
INSERT INTO nop_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Yahwe, du kotigoŋ ninigileŋ yoŋa ganinadiyam. Ale du nihitubu-lodaune nemenemek hogohogok tinene momooŋ mintawek. ");
INSERT INTO nop_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Me i Yahwe wou gineŋ bulak, Bepaŋdi kahaŋ timimbek! Indi Yahwe Siloŋyotŋiŋ gineŋ kahaŋ tihamam. ");
INSERT INTO nop_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yahwe ne kubugoŋ Bepaŋ hinek. Tiŋa adigoŋ momooŋ hinek nibudokoguk. Unduŋ doktiŋa bem taŋeniŋ wobu beŋa wooŋ alta kelemadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Du Bepaŋne, doktiŋa welemomooŋ nadigamuŋa ganiutumbalat. Du Bepaŋne, doktiŋa wohoge ganintiloit. ");
INSERT INTO nop_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Yahwe adi momooŋ hinek tinimilak unduŋ doktiŋa welemomooŋ nadimiŋa niutumbaneŋ. Adi weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Me nediyeŋ yomhinit mokit didimehi hatiŋa Yahwe’walaŋ Yodoko Mede takaliiŋ, adi yadi Bepaŋdi yehikahaŋneune nadifo kedem tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Me nediyeŋ Bepaŋ’walaŋ medeŋiŋ takalihinakaiŋ heki adi yadi Bepaŋdi yehikahaŋneune nadifo kedem tineŋ. Adi nadinadihik kunilitdi Bepaŋ’walaŋ kwanai titiŋdok nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Biyagoŋ hinek, adi yadi yom mu tiiŋ, adi yadi Bepaŋ’walaŋ titiŋ hogok takaliiŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Du Yodoko Medege hogohogok u nimguŋ, tiŋa didimeŋgoŋ hinek yehikeledok niniŋguŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Nu adi du’walaŋ medege helemahelemaŋ fafaŋeŋ takalidok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Ale nu du’walaŋ Yodoko Medege hogohogok takaliwaat, wendoktiŋa meka tuwot mu tibaat. ");
INSERT INTO nop_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Nu du’walaŋ titiŋge didimeniŋ wendok nadinadi kwanai tiŋa welenedi didimeniŋ halune nai uŋaniŋ kedem wohoge ganintilowaat. ");
INSERT INTO nop_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Nu du’walaŋ Yodoko Medege hogohogok u yehikeledok nadilat, unduŋ doktiŋa du mu binabeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Dediŋ tiŋa mekuya adi hatihatiŋiŋdi walaniŋ hinek tibek? Adi yadi du’walaŋ medege takaliŋa kedem momooŋ hatibek. ");
INSERT INTO nop_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Nu welene kunilit hinekdi du’walaŋ kwanai titiŋdok nadilat, unduŋ doktiŋa nehitubu-lodaune Yodoko Medege mu biyabit. ");
INSERT INTO nop_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Nu du’walaŋ medege u welene eŋ nadinadine gineŋ kamewene hatak. Unduŋ doktiŋa dutok kadakaniŋ tuwot mu tigambit. ");
INSERT INTO nop_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Yahwe, nu wohoge ganintilolat, ale du Yodoko Medege hogohogok didimehi u nanindidimeweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Nu metam hogohogok Yodoko Mede da niniŋguŋ u yenihautalat. ");
INSERT INTO nop_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Nu adi du’walaŋ medegedok nadifo tiŋa takalilat. Iŋgoŋ muneeŋ bomboŋdok adi nadifo unduŋ hinek mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Nu adi du maŋgoŋ titiŋdok nadilaŋ u baigoŋ hinek nadilat, tiŋa du mede talii nimguŋ u kameka tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Nu adi Yodoko Medegedok nadiwene utumba hinek tilak. Doktiŋa mede u kaule tuwot mu tibaat. ");
INSERT INTO nop_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Kwanai mege nu momooŋ hinek tinambeŋdok nadilat. Unduŋ tubune nu kaipmuŋ hatiŋa medege kedem takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Du nadinadine tubutombune mede momohi momohi Yodoko Mede gineŋ hali wiiŋ u kedem nadihinakait. ");
INSERT INTO nop_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Nu kwetfoloŋ iŋoŋ buŋambu hogok hatilat, unduneŋ doktiŋa da’walaŋ Yodoko Medege kamehebi mu tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Helemahelemaŋ welenedi du’walaŋ titiŋ didimeniŋ titiŋdok map tilak. ");
INSERT INTO nop_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Du adi me sigitiŋalo tiiŋ heki eŋ me Yodoko Medege sigilulum timiŋa nehi’walaŋ nadinadi keleiŋ, adi yadi yenintoŋa yomhidok kibikoŋ yemilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Nu du’walaŋ Yodoko Medege kelelat doktiŋa adi nanimpekit tiŋa medehaki naniiŋ. Ale du biyabune mede undihi mu nanineŋdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Talitimeŋ heki adi bopneeŋ nulukumuŋdok talik lohiiŋ. Iŋgoŋ nu adi kwanai-mege hatilat, unduŋ doktiŋa fiit helemahelemaŋ du’walaŋ Yodoko Medege didimeniŋ wendok hogok nadiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Du nanintubu-didime tilaŋ wendi welemomooŋ tubumintanamulak, kaŋ medegedi nanindidime tilak. ");
INSERT INTO nop_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Nehinalitifooŋ kwam foloŋ napmeune hatat. Unduŋ doktiŋa da koom yofafaŋeguŋ undugoŋ tiŋa nehitubu-pilaliŋa saŋiniŋ nambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Nu titiŋne hogohogok u agaŋ yobihidapmagut. Kaŋ du mede toboniŋ agaŋ tubu-udanenamguŋ. Tiŋa da’niŋ talikge nanindidimeweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Da’niŋ Yodoko Medege u takalidok nanindidimeweŋ, kaŋ nu du’walaŋ medege momohi momohi u nadikaule mu tiŋa uŋgoŋ hati nadikuwat tuluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Welemulap nadiŋa gweheye hinek tilat, doktiŋa da yofafaŋeguŋ unduŋ tiŋa nehitubu-fafaŋeweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Tiŋa dagoŋ nabudokoune du’walaŋ talikge u mu bikabaat. Adi toboniŋ titiŋ momooŋ tiŋa Yodoko Medege nanindidimeluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Nu du didimeniŋgoŋ gehikeledok mede yokiliti tugut. Tiŋa helemahelemaŋ Yodoko Medegedok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Yahwe, nu adi mede da naniŋguŋ uŋakoŋ honekilitiŋa takalilat. Du binabune nemek niŋdi mu nehitubu-mekawaak. ");
INSERT INTO nop_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Du nadinadine tububedilaŋ doktiŋa medegedi yodakalelak undugoŋ, pilap hinek takalidok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Yahwe, du Yodoko Medege momooŋgoŋ nanindidimeune nu helemahelemaŋ takaliluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Yodoko Medege diniŋ mebi miŋgilaŋgoŋ tubumintaune kaŋ tagimneeŋ takaliwit. Tiŋa welenedi hinek kahilehinakawit. ");
INSERT INTO nop_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Nu adi Yodoko Mededi nadifo tubuminta-namulak. Unduŋ doktiŋa nanindidimeeŋ nanagilune Yodoko Medege diniŋ talik kelewit. ");
INSERT INTO nop_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Du weleyouyout tinambune du’walaŋ medege takalidok nadigalika tibit. Tiyaugene welenedi nemenemek hogohogokdok nadigalika tibaakneŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Ale nehitubu-lodaune nemenemek hogohi u sigilulum tiyembit. Kaŋ du momooŋ tinamdok yofafaŋeguŋ undugoŋ tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Du me nediyeŋ gikiŋgoŋ tigamiiŋ hekidok mede yofafaŋe tiyemilaŋ. Unduŋ doktiŋa medege yofafaŋe u tagimneeŋ kwanai-mege nu maaŋ undugoŋ tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Du mede didimeŋgoŋ hinek yodapmalaŋ, doktiŋa Yodoko Mede lahula meka tibaatneŋ ale nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Du adi titiŋge didimeniŋ hinek doktiŋa hatihati namulaŋ. Wendoktiŋa Yodoko Medege hogohogok u takalidok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Yahwe, welegedi nabukahile hinek tilaŋ u miŋgilaŋgoŋ tubumintaune kawit, tiŋa medege yofafaŋe tuguŋ undugoŋ tiŋa kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Nu medege nadisukiliti hinek tilat, doktiŋa nehitubu-lodaune me medehaki naniiŋ hekidok mede toboniŋbo tubu-udaneyembit. ");
INSERT INTO nop_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Nu medege didimeŋ wondok nadikunakunale tilat, unduŋ doktiŋa wendi nehitubu-kilitibune helemahelemaŋ du’walaŋ medege biyagoŋ hogok yohautaluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Tiŋa Yodoko Medege helemahelemaŋ takaliluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Nu medege u takalidok nadilat, unduŋ doktiŋa titiŋ hogohidi mu nehitehinapme hatneŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Nu du’walaŋ medege u me mapme heki yenimbit. Nu u tibit wendoktiŋa meka tuwot mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Nu Yodoko Mede heki yendok nadigalika tilat, wendoktiŋa Yodoko Medege u yehikeledok adi welemomooŋ nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Nu adi Yodoko Medegedok adi nadiwene momooŋ hinek tubune welene wapumdi wendok nadilat. Eŋ medege adi nadikaule mu tiŋa helemahelemaŋ uŋgoŋ hati nadikuwatuwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Du koom kwanai-mege nutok yofafaŋe tuguŋ, kaŋ yofafaŋege wendi nehitubu-lodaune nadikunakunale hati tilat. Wendoktiŋa du mede yofafaŋege u kotigoŋ nadikaikaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Tiŋa undugoŋ malabumuŋ mintanamulakneŋ yofafaŋe medege wendi welekulema tubumintanamulak, tiŋa hatihati namulak. ");
INSERT INTO nop_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Me sigitiŋalo tiiŋ hekidi mede yopekit hogohi tinamiiŋ, iŋgoŋ nu wendoktiŋa Yodoko Medege mu bikabulat. ");
INSERT INTO nop_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Yahwe, nu mede koom yodapmaguŋ hogohogok wendok nadilat, kaŋ wendi naniŋkulemaŋ saŋiniŋ namulak. ");
INSERT INTO nop_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Nu yabene me hogohidi Yodoko Medege u lahulune wendoktiŋa kwihita tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Nu yotne kwetne bikabuŋa kweetniŋ haliŋa Yodoko Medege u kap foloŋ tubutakaleeŋ tolat. ");
INSERT INTO nop_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Yahwe, nu timiŋ du nadisugamuŋa Yodoko Medege takalilat. ");
INSERT INTO nop_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Nu helemahelemaŋ Yodoko Medege takaliwene wendi welemomooŋ tubumintanamulak. ");
INSERT INTO nop_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Yahwe, kwetfoloŋ nemek hogohogok kedem daneeŋ moŋgola yabukahileneeŋ. Nu adi du hogok gabukahileluwaat. Wendoktiŋa mede yofafaŋe indiŋ tilat, nu adi medege hogohogok u yehikeleluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Du siloŋ tobogoŋ tinamdok yofafaŋeguŋ u tinambeŋ yoŋa welenedi hinek ganinadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Nu na’walaŋ hatihatine u kanadiŋa biŋa du’walaŋ mede talii u takalidok yofafaŋelat. ");
INSERT INTO nop_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Nu woom mu tiŋa pilap hinek du’walaŋ Yodoko Medege takalilat. ");
INSERT INTO nop_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Me hogohidi nanagila nehi’walaŋ titiŋhik hogohi gineŋ uuŋdok kweleyouhep tinamiiŋ, iŋgoŋ nu adi Yodoko Medegedok nadikaule mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Nu timiŋ lekiŋgoŋ sukuleeŋ pilali du mede nadinadi kwanaige didimeniŋgoŋ tilaŋ wendok nadiŋa wohoge ganintilolat. ");
INSERT INTO nop_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Nu adi mebop nediyeŋdi dutok gikiŋgoŋ tiiŋ eŋ du’walaŋ Yodoko Medege takaliiŋ adut hatilat. ");
INSERT INTO nop_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Yahwe, du welege hinekdi kwetfoloŋ metam hogohogok yabukahilelaŋ. Unduŋ doktiŋa Yodoko Medege hogohogok u naninehi-titiŋeneweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Yahwe, du yofafaŋe medege tagimnehinakaaŋ kwanai-mege nutok titiŋ momooŋ hinek tinamguŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Nu Yodoko Medegedok nadisukiliti hinek tilat. Unduŋ doktiŋa nadinadi fuliŋgoŋ u nambeŋ eŋ kwanai momooŋ titiŋdok nadinadi maaŋ nambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Du yomnedok kibikoŋ mu tubu-udanenamulune nu talikge bikabuŋa talik hogoli kelelugut. Iŋgoŋ kobuk adi du’walaŋ medege takalilat. ");
INSERT INTO nop_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Du adi momooŋ, unduŋ doktiŋa momooŋ hinek tinamulaŋ. Wendoktiŋa Yodoko Medege momooŋgoŋ hinek naninehitubu-didimeweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Me sigitiŋalo tiiŋ hekidi naniwoliwolike tiŋa mede yalaŋ fee hinek naniiŋ. Iŋgoŋ nu adi nemek niŋdok nemu nadilat. Mokoŋ. Nu adi Yodoko Medege u hogok takalilat. ");
INSERT INTO nop_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Me heki woŋ adi nadinadihik kedehi nemoŋ. Iŋgoŋ nu adi Yodoko Medegedi welemomooŋ tubumintanamulak. ");
INSERT INTO nop_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Kedem hinek malabumuŋ namguŋ, kaŋ wendigoŋ Yodoko Mede hogohogok u nanindidimeguk. ");
INSERT INTO nop_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Muneeŋ wapum adi kedem, iŋgoŋ wendok nadiwe fofoye tilak. Eŋ mage mededok adi nadiwene folooŋ hinek eŋ loloŋnit tilak. ");
INSERT INTO nop_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Dagoŋ nehitutumbaguŋ, tiŋa momooŋ hinek nabudokolaŋ. Unduŋ doktiŋa nadinadine tubutombune du’walaŋ Yodoko Medege hogohogok u kedem kunatnadiwit. ");
INSERT INTO nop_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Nu du’walaŋ yofafaŋe medege u nadisukiliti tilat, unduŋ doktiŋa metam dutok gikiŋgoŋ tigamiiŋ heki adi nabuŋa nadifo tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Yahwe, nu yodapmandapmaŋ medege didimeniŋ hogohogok u agaŋ nadilat. Du yadi nu’walaŋ titiŋne tubudidimedok hinek nadilaŋ, doktiŋa malabumuŋ namulaŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Du kwanai-mege nu helemahelemaŋ welegedi hinek nabukahileeŋ welene tubukilitidok yofafaŋeguŋ, ale kamiŋ undugoŋ tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Nu Yodoko Medegedok adi nadigalika hinek tilat, ale welekulema tinambune hatihati kedem kahilewit. ");
INSERT INTO nop_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Me sigitiŋalo tiiŋ heki adi yalaŋ naniŋkamandaaŋ mede foloŋ napmeiŋ. Ale du titiŋhik wendoktiŋa yehitubu-meka tibeŋ. Iŋgoŋ nu adi helemahelemaŋ Yodoko Medege hogohogok wendok nadiluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Me nediyeŋdi dutok gikiŋgoŋ tigamiiŋ eŋ me nediyeŋ du’walaŋ Yodoko Medege nadiiŋ, adi hogokdi kedem nu’walaŋkade buneŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Nehitubu-lodaune du’walaŋ Yodoko Medege hogohogok u takalihinaka tibit. Unduŋ tiŋa titiŋnedok meka tuwot mu tibit. ");
INSERT INTO nop_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Nu kotigoŋ nanagileŋ yoŋa woomge woomge agaŋ gweheyehinaka tilat. Iŋgoŋ medege adi nadisukiliti tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Nu mede yofafaŋe tuguŋ u folooŋ deniŋ hinek mintawaak yoŋa ha-diwege diwege daune agaŋ gweheye tilak. Kaŋ indiŋ yolat, “Nai deniŋ hinek welene tubu-kulemawaak?” ");
INSERT INTO nop_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Nu adi haule agaŋ buba tubune beyakula nadikaule tiiŋ nabugoŋ agaŋ kadaka hinek tilat. Iŋgoŋ nu adi Yodoko Medege hogohogok u kaule mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Nai dedigoŋ hinek woombaat? Eŋ nai deniŋ hinek me kadakaniŋ tinamiiŋ u yehitubu-kadakawaaŋ? ");
INSERT INTO nop_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Me sigitiŋalo tiiŋ heki adi yadi Yodoko Medege mu takaliiŋ. Adi yadi nu nohonedok yoŋa nemek titiŋ kabukabup tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Du’walaŋ Yodoko Medege hogohogok adi biyagoŋ, doktiŋa indi nadisukilitiyam, iŋgoŋ me kadakaniŋ tinamiiŋ hekidigoŋ yalaŋ naniiŋ. Unduŋ doktiŋa nehitubu-lodaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Muniniŋ agaŋ nulukumune-tiŋit, iŋgoŋ nu Yodoko Medege bikabu mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Du welegedi hinek helemahelemaŋ nabukahilelaŋ, unduŋ doktiŋa momooŋgoŋ nabudokoweŋ. Unduŋ tinambune nu Yodoko Medege hogohogok u kedem takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Yahwe, medege adi dapmandapmaŋnit mokit haliwooŋ halaak. Kunum gineŋ adi fafaŋeniŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Du medege yofafaŋe tuguŋ u helemahelemaŋ didimeŋgoŋ hinek takalilaŋ undugoŋ hinek takaliune dapmandapmaŋnit mokit haliwooŋ halaak. Eŋ kwet wapum kameguŋ i kweli-kabe nemu bikabuŋa hakuk, undugoŋ fafaŋeniŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Nemenemek hogohogok woŋ adi da yoguŋ wendok tuwot hali buŋa hakiiŋ. Tiŋa nemenemek hogohogok woŋ adi da’walaŋ kwanai tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Yodoko Medegedok nadigalika mu tibe tugut binek, du dagoŋ nehitubu-kadakaune agaŋ kumumbe tugut. ");
INSERT INTO nop_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Nu Yodoko Medege mu biyabit, maŋgande, uŋakoŋ yehikelelat doktiŋa nehitubu-lodaune kaipmuŋ hatilat. ");
INSERT INTO nop_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Nu adi da’walaŋgoŋ, unduŋ doktiŋa kotigoŋ nanagileŋ. Nu adi helemahelemaŋ medege takalidok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Me hogohi adi nulukumuŋ titiŋdok woomnam tiiŋ. Iŋgoŋ nu adi Yodoko Medegedok nadikaule mu tiŋa uŋgoŋ hati nadikuwat tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Nu agaŋ nadilat, nemenemek momohi adi dapmandapmaŋnit. Iŋgoŋ da’walaŋ Yodoko Mede adi kamekadok tuwot mooŋ. Adi yadi dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Nu welenedi hinek Yodoko Medege kahile tilat. Kaŋ timiŋ be hadapmo adi wendok hogok hati nadikuwatat. ");
INSERT INTO nop_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Yodoko Medegedi helemahelemaŋ nukut hatak, doktiŋa nehitubu-lodaune me nadinadinit mintaaŋ memikneye yalakapmeŋ tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Tiŋa nu helemahelemaŋ medege biyagoŋ wendok hati nadikuwatat, unduŋ doktiŋa nu nadinadi momohi hinek belat. Unduŋ tiŋa henaleneye yalakapmedapmaŋ tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Tiŋa undugoŋ nu adi Yodoko Medege didimeniŋ u takalilat, wendoktiŋa nu’walaŋ nadinadidi me talitimeŋ gawadahi’walaŋ nadinadihik yalakapme tilak. ");
INSERT INTO nop_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Nu adi du’walaŋ medege hogok takalidok nadilat, wendoktiŋa titiŋ hogohi u yabuŋa momoŋ tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Du dagoŋ medege hogohogok u nanindidimeguŋ, wendoktiŋa mede u mu bikabulat. ");
INSERT INTO nop_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Nu simiŋkupuk nawene koditne gineŋ koba tilak, iŋgoŋ oŋ, du’walaŋ medege wendi koba u kalakapme hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Yodoko Medegedi nadinadi momooŋ hinek namulak, kaŋ wendoktiŋa titiŋ hogohidok adi nadikwihita tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Du medege adi kamaŋdok tuwolit, wendoktiŋa hautaaŋ nabudokoune talik kadakaleeŋ yaulat. ");
INSERT INTO nop_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Nu du’walaŋ medege didimehi hogohogok u yehikeledok yofafaŋe hinek agaŋ tugut. Unduŋ doktiŋa wabi adi mu tiŋa dibek yogut hinek undugoŋ tibaat. ");
INSERT INTO nop_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Yahwe, i nadiweŋ. Folofigita wapum hinekdi kisaŋ nehitiŋafolak. Ale du medege yofafaŋeguŋ undugoŋ tiŋa nehitubu-lodaune kaipmuŋ hatibit. ");
INSERT INTO nop_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Yahwe, nu ganinadi foloŋ uŋgoŋ ganiutumba tilat. Ale du youtumbane u nadinambeŋ, tiŋa medege momooŋgoŋ hinek naninehitubu-didimeweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Nu helemahelemaŋ hatihatinedi dapmandok tubudula tilak. Iŋgoŋ Yodoko Medegedok adi kaule mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Me hogohi adi nohonedok begep ibinamiiŋ, iŋgoŋ nu adi medege bikabu mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Yodoko Mede u siloŋ tinambune nutok hinek hatnamuluwaak. Medege wendi welenadifo tubumintanamulak. ");
INSERT INTO nop_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Nu Yodoko Medege hogohogok u yehikeleluwaat yogut, doktiŋa undugoŋ tiŋa hatitauyeeŋ kumumbene dapmawaak. ");
INSERT INTO nop_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Nu adi du gehikelekamanda tiiŋ me undihidok adi nadikwihita tiyemulat. Iŋgoŋ du’walaŋ Yodoko Medegedok adi welenedi kahile hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Du kubugoŋdi nabu-ulidokoŋila yahehewe tinamulaŋ. Kaŋ nu adi du mede yofafaŋe tuguŋ wendok hati nadikunakunalelat. ");
INSERT INTO nop_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Metam kadakaniŋhinit, hidi binabuneŋ. Nu adi Bepaŋne’walaŋ Yodoko Mede hogok takalidok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Du nehitubu-kilitibune kaipmuŋ hatibaat, medege yofafaŋe unduŋ tuguŋ, doktiŋa nu yofafaŋege u nadisukilitilat. Ale du saŋiniŋ u nambeŋ, kaŋ nu’walaŋ nadikunakunalenedi folooŋ mokit mu tibek. ");
INSERT INTO nop_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Kohone foloŋ honeune nu kedem hatibit. Tiŋa helemahelemaŋ du’walaŋ medegedok magi kametnadi tiŋa takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Du adi metam hogohogok Yodoko Medege bikabu tiiŋ hekidok adi sigilulum tiyemilaŋ. Adi’walaŋ nadihebethik yalayalaŋ u folooŋnit mokit tilak. ");
INSERT INTO nop_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Du metam kadakahidok adi nadiyembune gilem nabugoŋ tilak, unduneŋ doktiŋa nu adi yodakale medegedok nadigalika tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Nu dutok tiŋa muntaaŋ foloone hehele tilak. Tiŋa undugoŋ, mede yodapmandapmaŋgedok maaŋ nadiŋa munta tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Nu adi titiŋ momooŋ eŋ didimeniŋ tugut. Ale du binabune memik hekidi kadakaniŋ mu tinamneŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Du kwanai-mege yakadi timiŋa tubulodadok mede yofafaŋe tibeŋ. Tiŋa me sigitiŋalo tiiŋ heki u biyabune malabumuŋ mu namuneŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Nu nehitubu-lodaaŋ kotigoŋ nanagitdok yofafaŋeguŋ, wendoktiŋa woomge woomge agaŋ lakata tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Du welegedi hinek nabukahileeŋ da’walaŋ yodakale medege hinek uŋak nanindidimeweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Nu da’walaŋ kwanai-mege, unduŋ doktiŋa nadinadi fuliŋgoŋ nambune nu du’walaŋ medege kedem nadiwit. ");
INSERT INTO nop_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Metam adi du’walaŋ Yodoko Medege lahut tiiŋ. Unduŋ doktiŋa, Yahwe, da nadilaŋ unduŋ tiyembeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Nu adi welenedi hinek Yodoko Medege kahile tilat. Nu adi muneeŋ (gol) momooŋ tiŋa loloŋnit wendok adi kedem nadilat, iŋgoŋ du’walaŋ medege wendok adi momooŋ hinek nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Unduŋ doktiŋa nu adi du’walaŋ medege hogohogok u takalilat. Eŋ talik hogohidok adi sigilulum tiyemilat. ");
INSERT INTO nop_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Medege adi momooŋ hinek, wendoktiŋa wanakaŋ hogohogok welenedi hinek yabukahileeŋ yehikelelat. ");
INSERT INTO nop_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Du medege yodakaleune hautaaŋ metam hauta tubumintayemulak. Tiŋa mede wendi me nadinadi mokit nadinadi fuliŋgoŋ milak. ");
INSERT INTO nop_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Yodoko Medege takalidok welene yout tubune koloŋgoŋ yatilat. ");
INSERT INTO nop_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Du buŋa metam welehikdi gabukahile hinek tiiŋ aditok tiyemilaŋ undugoŋ nu maaŋ siloŋ tobogoŋ tinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Du koom yofafaŋeguŋ undugoŋ tiŋa nabudokoune nu kadakaniŋ mu tibit. Tiŋa du kadakaniŋ u mu bikabune nehitiŋfooŋ nehitubu-kadakawek. ");
INSERT INTO nop_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Du kotigoŋ nanagilune me nanintifo tiiŋ heki adi mu nehitubu-kadakaneŋ. Kaŋ nu du’walaŋ medege kedem takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Nehitubu-dulaaŋ yamaiŋgoŋ hatiŋa Yodoko Medege hogohogok u nanindidimeeŋ nehikahaŋneweŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Metamdi du’walaŋ Yodoko Medege mu takaliiŋ, wendoktiŋa makat gibitaŋ kolene dautilitiliknedi ime nabugoŋ dokomalak. ");
INSERT INTO nop_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Yahwe, du adi didimeniŋ hinek. Kaŋ Yodoko Medegedi maaŋ undugoŋ didimeniŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Yodoko Mede nimilaŋ hogohogok woŋ adi didimehi tiŋa momohi hogok. ");
INSERT INTO nop_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Memikneye adi du’walaŋ medegedok-kabe nemu nadiiŋ. Unduŋ doktiŋa welene kudup dalak. ");
INSERT INTO nop_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Yofafaŋe medege biyagoŋ hinek, u agaŋ kaŋ nadigut. Unduŋ doktiŋa kwanai-mege nu adi yofafaŋe medegedok adi nadiŋa nadigalika tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Nu adi me fiit doktiŋa metamdi nanimpekit tiiŋ. Iŋgoŋ nu Yodoko Medege mu bikabulat. ");
INSERT INTO nop_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Titiŋ didimeniŋge adi dapmandapmaŋnit mokit hakukdi hatak, kaŋ Yodoko Medege adi biyagoŋ hinek. ");
INSERT INTO nop_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Malabumuŋ fee mintanamiiŋ, iŋgoŋ nu adi Yodoko Medegedok nadifo tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Medege adi didimeniŋ, dapmandapmaŋnit mokit. Doktiŋa nehitubu-lodaune u nadidakaleeŋ kaipmuŋ kedem hatibaat. ");
INSERT INTO nop_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Yahwe, nu welenedi hinek du ganinadilat, ale du yonadine tubu-udaneweŋ, kaŋ nu du’walaŋ medege hogohogok u takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Nu kutiganilat, doktiŋa du kotigoŋ nanagileŋ, kaŋ du’walaŋ Yodoko Medege heki u kedem yehikelewit. ");
INSERT INTO nop_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Nu helehauta mu tulune nehitubu-lodaweŋdok nadiŋa ganinadiŋat. Tiŋa undugoŋ, nu adi yofafaŋe medegedok adi nadikunakunale hati tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Nu timiŋ damo mu deitat. Nu adi helemahelemaŋ medege wendok hogok hati nadikuwatat. ");
INSERT INTO nop_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Yahwe, du helemahelemaŋ welegedi nabukahile hinek tilaŋ doktiŋa yonadine nadinamulaŋ. Ale titiŋ didimeniŋ keleeŋ mede yodapmalaŋ undugoŋ tiŋa nehitubu-lodaune kaipmuŋ hatibit. ");
INSERT INTO nop_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Me nadinadihik hogohi nu nehitubu-kadakadok tiiŋ heki adi yamaiŋgoŋ biiŋ. Adi yadi du’walaŋ Yodoko Medege mu takaliiŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Iŋgoŋ Yahwe, du adi nehitubu-dula tiŋa yamaiŋgoŋ hatilaŋ, eŋ Yodoko Medegedi adi biyagoŋ hogohogok. ");
INSERT INTO nop_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Koomkwaha uŋoŋdibek du’walaŋ medege i nadigut. Eŋ medege adi da nadiguŋ wendok tuwot dapmandapmaŋnit mokit hatak. ");
INSERT INTO nop_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Nu du’walaŋ Yodoko Medegedok nadikaule mu tilat. Unduŋ doktiŋa du malabumuŋne i kaŋ liliwenekutnamuŋa kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Du mede yofafaŋe tuguŋ undugoŋ tiŋa nehitubu-lodaaŋ kotigoŋ nanagila hatihati nambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Me hogohi adi yadi du’walaŋ Yodoko Medege didimeniŋ mu keleiŋ, unduŋ doktiŋa du me hogohi u kotigoŋ mu yehitubu-lodaaŋ yabudokoluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Yahwe, du’walaŋ siloŋ tobogoŋge adi wapum hinek. Unduŋ doktiŋa du kotigoŋ nanagitdok yoguŋ, ale dibek yoguŋ unduŋ tibeŋ nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Metam feedi titiŋ hogohi tinamuŋa memik tinamiiŋ, iŋgoŋ nu adi medege biyagoŋ hinek u mu bikabulat. ");
INSERT INTO nop_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Nu adi metam du’walaŋ medege mu takaliŋa nadisuhik uŋoŋ mu kameiŋ doktiŋa yabuŋa kwihita tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Du nu nabeŋ. Nu adi du’walaŋ medegedok nadigalika hinek tilat. Kaŋ du adi welegedi nabukahile hinek tilaŋ, unduŋ doktiŋa kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Yodoko Medege diniŋ mebi adi mede biyagoŋ hogohogok. Wendoktiŋa Yodoko Medege didimehi woŋ adi dapmandapmaŋnit mokit haliwooŋ hatneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Talitimeŋ wapuhi adi nemek mebinit mokit kadakaniŋ hogok tinamfit tiiŋ. Iŋgoŋ nu adi du’walaŋ medege wendok muntaaŋ gikiŋgoŋ timilat. ");
INSERT INTO nop_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Nu yofafaŋe medegedok nadifo loloŋnit hinek tilat, woŋ adi me niŋ muneeŋ bomboŋ mohok tubumintaaŋ nadifo tilak wondok tuwolit. ");
INSERT INTO nop_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Nu adi mede yalaŋdok nadikwihita tiŋa welene kadaka tilak. Nu adi welenedi Yodoko Medegedok hogok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Du mede nadinadi kwanai tilaŋneŋ mede didimehi hogok yolaŋ, wendoktiŋa nu melenai kubugoŋ indigoŋ tuwot nai 7 ganiutumbalat. ");
INSERT INTO nop_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Metam du’walaŋ Yodoko Medegedok nadigalika hinek tiiŋ, adi yadi kedem hatiiŋ. Doktiŋa nemek niŋdi yehitifowekdok tuwot moŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Yahwe, nu da titiŋ dediŋ tibit naniŋguŋ undugoŋ tiŋale kotigoŋ nanagitdok wendok woom tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Nu welenedi hinek Yodoko Medegedok nadilat, unduŋ doktiŋa Yodoko Medege hogohogok u yehikelelat. ");
INSERT INTO nop_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Nu dediŋ hatilat u agaŋ da nabunadidapmalaŋ. Unduŋ doktiŋa Yodoko Medege hogohogok be yodakale medege hogohogok u yehikeledapmaŋ tilat. ");
INSERT INTO nop_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Yahwe, nehitubu-lodadok kutiganilat ale nadinambeŋ. Tiŋa koom nadinadi fofooŋ namdok yoguŋ u nambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Eŋ yonadinedok magi kametnadi tibeŋ, tiŋa koom kotigoŋ nanagitdok mede yofafaŋe tuguŋ undugoŋ tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Du Yodoko Medege hogohogok momooŋ hinek nanindidimelaŋ, doktiŋa nu wohoge helemahelemaŋ ganintiloluwaat. ");
INSERT INTO nop_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Yodoko Medege hogohogok adi didimehi, unduŋ doktiŋa nu Yodoko Mededok kap tobit. ");
INSERT INTO nop_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Nu adi du’walaŋ Yodoko Medege takalilat, unduŋ doktiŋa du adi helemahelemaŋ nu nehitubu-lodadok tiulidoko tiŋa woomuluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Yahwe, du kotigoŋ nanagileŋ yoŋa welenedi du’walaŋkade kobulabulaye tilak. Kaŋ Yodoko Medegedi nadifo tubumintanamulak. ");
INSERT INTO nop_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Du hatihati nambeŋ, kaŋ nu wohoge ganintilowit. Tiŋa undugoŋ medegedi nehitubu-lodawekdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Nu dompadi fiit tiiŋ wondok tuwolit, talik fofooŋ u agaŋ bikabugut. Unduŋ doktiŋa du buŋa kwanai-mege nu nolohiŋa nabeŋ. Nu adi Yodoko Medegedok nadikaule mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Nu malabumuŋ gineŋ hali Yahwe ninadiwene adi yonadine agaŋ nadiguk. ");
INSERT INTO nop_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Indiŋ ninadigut, “Yahwe, yalaŋ-me heki adi yalaŋ naniŋa naniwoliwolike tineeneŋ ale nehitubu-lodaweŋ.” ");
INSERT INTO nop_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Yalaŋ-me heki, hidi Bepaŋdi dediŋ hinek tihambaak? Tiŋa undugoŋ yalaŋhikdok kibikoŋ dediŋ hinek tihambaak? ");
INSERT INTO nop_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Kibikoŋ adi mikme heki’walaŋ tebe kaŋguma maŋiŋnit wondi halambaak, eŋ kudupdelet mimihi hinek dadaŋhinit weŋ hehiyouhewaak! ");
INSERT INTO nop_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Mesek kwetneŋ be Kedahi’walaŋ baŋamhik gineŋ kaulehi gut hatiiŋ, undugoŋ hinek hidi’walaŋ lekiŋgoŋhik gineŋ iŋoŋ maaŋ kedemgoŋ hinek mu itoulat. ");
INSERT INTO nop_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Metam kulema mu hahatdok yoiŋ adut itawene nai kweheyeniŋ hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Nu adi kulemaŋgoŋ hatidok yolat, kaŋ adi yadi toboniŋ mik titiŋdok hogok nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Nu me nehitubu-lodadok deŋandiŋ bek? Unduŋ nadiŋale kweboboe gineŋgineŋ uŋgoŋ ha-diwelat. ");
INSERT INTO nop_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Yahwe, kunum kwet yobune mintagumuk adi hogokdi nehitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Me gabudoko tilak adi damo nemu deitak, unduŋ doktiŋa bigabune nemek niŋdi tuwot mu gehitubu-gweheyewek. ");
INSERT INTO nop_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","I nadiweŋ, adi damo deimbakap be damo-kabe nemu deitak. Mokoŋ hinek. Adi yadi Isilaehi yabudokolak. ");
INSERT INTO nop_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yahwedi gabu-ulidoko tilak. Eŋ yahehewe tigamuŋa dukut noŋgoŋ yamaiŋgoŋ uŋgoŋ hatilak. ");
INSERT INTO nop_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Hadapmo meledi tuwot mu gehidawaak, eŋ timiŋ muyakipdi tuwot mu gehitubu-kadakawaak. ");
INSERT INTO nop_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yahwedi gabu-ulidokoune nemek hogohidi tuwot mu gehitubu-kadakaneeŋ. Eŋ negoŋ mohinek hati gabudokoluwaak. ");
INSERT INTO nop_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Du yoke bikabuŋa dambek uluwaaŋ, be kotigoŋ buluwaaŋ, u Yahwedi helemahelemaŋ hati gabudokoluwaak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","“Buune Yahwe yolineŋ unim,” unduŋ nanimbune welemomooŋ hinek nadigut. ");
INSERT INTO nop_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Kaŋ ya agaŋ busuwamun, Jelusalem gimbahaŋ maaneŋ yakam. ");
INSERT INTO nop_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jelusalem yokwet wapum u nemenemek kotigoŋ beŋa tomboyoulune momooŋ hogok diweŋ yatak. ");
INSERT INTO nop_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Koom dediŋ titiŋdok yofafaŋeeŋ yeniŋguk, wendok tuwot Isilaehi mebop adi iŋgoŋ buŋa Yahwe welemomooŋ nadimiŋa niutumbaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Kaŋ Isilaehi’walaŋ mapmedi iitdok kweli adi uŋoŋ hatak. Kaŋ uŋoŋ ila metam’walaŋ medehik nadiŋa yotubudidime kwanai tilak. ");
INSERT INTO nop_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Kulemadi Jelusalem yokwetneŋ hahatdok Bepaŋ ninadineŋ. Indiŋ ninadidok, “Nebek niŋ Jelusalem kaŋ weleŋdi nadigalika tibaak, adi yadi kulema momooŋ tubumintawaak. ");
INSERT INTO nop_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Metam hogohogok Jelusalem gimbahaŋ maaneŋ itawiiŋ aditok kulema eŋ iit momooŋ mintayembek.” ");
INSERT INTO nop_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Nu manemaneye tiŋa notneyedok nadiyemiŋa Jelusalem indiŋ nilat, “Kulemadi dukut halek.” ");
INSERT INTO nop_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Nu Yahwe Bepaŋnik’walaŋ Siloŋyotŋiŋdok nadilat. Unduŋ doktiŋa ninadiwene Jelusalemhi, hidi momooŋ hinek minta ulihaka tiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Yahwe, du kunum gineŋ mapme pop foloŋ mapme itaŋ, doktiŋa nu diwewene du’walaŋkade lolak. ");
INSERT INTO nop_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Tipilapilaye me adi me wapumŋiŋ’walaŋ nadinadi gineŋ hatilak, kaŋ tipilapilaye tamkuya adi maaŋ undugoŋ tam wapumŋiŋ’walaŋ nadinadi gineŋ hatilak. Kaŋ indi maaŋ undugoŋ Yahwe Bepaŋnik, du’walaŋkade hogok diwenene loune hatiyanene da welesiloŋ tinimbaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Metam adi inditok nadinimbune nemek fiit nabugoŋ hogohi tiyam. Unduŋ doktiŋa Yahwe, du welesiloŋ tinimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Nai kweheyeniŋ hinek me muneeŋ bomboŋhinitdi inditok nadinimbune fofoŋnit tubune ninimpekit tiiŋ. Kaŋ me gifoko heki adi nibulakata tiŋa kwihikwihileŋgoŋ hogok tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Isilaehi, hidi yonadi i tubu-udaneneŋ. Yahwedi mu nihitubu-lodawe tuguk binek dediŋ tanim? ");
INSERT INTO nop_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","3","Biyagoŋ hinek-ku, koom metamdi nibukwihitaŋ mik tinimgiŋ, iŋgoŋ oŋ, Yahwedi nihitubu-lodaguk. Mu nihitubu-lodawe tuguk binek adi memik hekidi nibukwihitaŋ nihitubu-kadakane tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Indi yadi ime gabuŋdi tilak wondok tuwolit memik hekidi nihibeŋa nihitubu-kadakane tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Eŋ ime gabuŋ saŋiniŋnitdi nemenemek youhefulalak unduŋ nabugoŋ tinimne tigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Iŋgoŋ oŋ, Yahwedi memik heki mu biyabune nihitubu-kadakagiŋ, doktiŋa welemomooŋ nadimiŋa Yahwe niutumbanim. ");
INSERT INTO nop_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Me niŋdi bagidok begep ibimilak, kaŋ buŋa ukahilam tiŋa woleeŋ ulak, wendok tuwolit hinek indi begep siyoŋŋiŋdi mu nihiyoukilitiŋa nipme hatak. Mokoŋ, begekak kufiyagila yalune indi agaŋ biyabuŋa momoŋ wam. ");
INSERT INTO nop_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Yahwedi yobune kunum kwet mintagumuk, negoŋ nihitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Metam Yahwe nadisukilitimiiŋ, adi yadi Saiyon kweboboe undihi. Kweboboe woŋ adi waliwali-kabe nemu tiŋa yakukneŋ uŋgoŋ fafaŋeŋ yatak. ");
INSERT INTO nop_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Kweboboe hekidi Jelusalem kelemadiŋa yali wiiŋ, undugoŋ hinek Yahwedi metamŋiye dapmandapmaŋnit mokit yehikelemadiŋa yabudokoluwaak. ");
INSERT INTO nop_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Bepaŋ metamŋiye’walaŋ kwet u helemahelemaŋ me hogohidi mu kadokoyaneeŋ. Adi unduŋ nobu tubune woŋ adi Bepaŋ’walaŋ metamŋiye maaŋ titiŋ hogohi tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","O Yahwe, metam du’walaŋ Yodoko Medege takaliiŋ, metam momohi u yehikahaŋneweŋ. ");
INSERT INTO nop_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Metam hogohi, kadakaniŋhik diniŋ kibikoŋ tubu-udaneyemiŋale metam du’walaŋ titiŋge mu takaliiŋ adi maaŋ undugoŋ malabumuŋ yembaaŋ. Eŋ Isilae kayoŋbop, hidi’walaŋkade kulema haliwooŋ halaak! ");
INSERT INTO nop_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Yahwedi kotigoŋ ninigila Jelusalem-de buune lihine tiŋa yalaŋ binek yoŋa nadiyam wendok tuwot nadigumun. ");
INSERT INTO nop_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Indi wendoktiŋa gibita gegeeŋ kap tonadifo tugumun. Kaŋ metam Bepaŋ mu nadimiŋgiŋdi indiŋ yogiŋ, “Yahwe adi kwanai wapum hinek tiŋa Isilaehi yehitubu-lodaguk.” ");
INSERT INTO nop_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Biyagoŋ hinek, Yahwe adi kwanai wapum hinek tiŋa nihitubu-lodaguk. Unduŋ doktiŋa welemomooŋ hinek nadiyam. ");
INSERT INTO nop_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Yahwe, du kotigoŋ nihitubu-lodaaŋ ninigileŋ. Woŋ adi imedi naŋgalune yuwa hogok hakiiŋ, ala gwi ulune imedi yuwa gineŋ dombuŋgolooŋ hali wiiŋ wendok tuwot. ");
INSERT INTO nop_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Metam makat kola diniyeti tiiŋdi kougoŋ nanaŋe kitaune nadifo tiŋa kap tonadifo tiŋila moŋgotnaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Biyagoŋ hinek, metam diniyetidok nanaŋe youli moŋgola makat kola wiiŋ. Iŋgoŋ mindaŋkade adi nanaŋe kita tineeŋ u moŋgola nadifo kap toŋa buneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Yahwedi yot mu nobu maune, yot mamaŋme heki adi kwanai hogok tifit tineŋ. Be Yahwedi yokwet wapum niŋ mu kadokoune, yokwet wapum kadoko me heki adi hogok kadoko tifit tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Muneeŋ gut nanaŋe doktiŋa haniŋ timiŋ pilali tububihila kwanaimiŋ tane tane wooŋ bufa tilak. Indi tiyaugene kwanaimiŋ hogok tifit tineemneŋ ala. Bepaŋ adi metam weleŋdi yabukahilelak hekidok hatikule yemilak. ");
INSERT INTO nop_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Yahwe adi momooŋ hinek tinimiŋa siloŋ niŋ tinimilak, u yadi wapmihi. Tiŋa undugoŋ, woŋ adi Bepaŋ’walaaniŋ kahaŋ momooŋ buune moŋgokam. ");
INSERT INTO nop_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Me naŋgat kaipmuŋ adi mihiŋiye hogok, woŋ adi mikme niŋ’walaŋ kohoŋ gineŋ tebe gumeŋ mohok yohoneeŋ yatak wondok tuwolit hinek. ");
INSERT INTO nop_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Me mihiŋiye fee adi yadi nadifo kedem tibek. Maŋgande, adi memikŋiŋ gut mede gineŋ yali mede tubune mihiŋiyedi tubulodaune mede gineŋ mu gweheyeeŋ fafaŋe tibaak. ");
INSERT INTO nop_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Metam nediyendi Yahwedok gikiŋgoŋ timiŋa adi’walaŋ nadinadiŋiŋ takalilaŋ, du yadi Bepaŋdi gehikahaŋnelak doktiŋa nadifo kedem tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Tiŋa undugoŋ, kwanaige diniŋ folooŋ tuwolit mintaune baniŋ mu tuluwaaŋ. Unduŋ tiŋa nemenemek hogohogok tibaaŋ u momooŋ hogok mintaune nadifo tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Kaŋ tamge adi bem olif kobaŋdi folooŋ folak wendok tuwot wapmihi fee yehitubu-mintawaak. Kaŋ wapmihi feedi bem gimiŋ kwetfoloŋ maaŋ kadoŋa labiiŋ wondok tuwolit yoke kuduhuluŋ u kelemadiŋa itneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Me nediyeŋ Yahwe gikiŋgoŋ timiŋa medeŋiŋ takalilak, adi yadi biyaku talik unduŋ foloŋ kahaŋ timilak. ");
INSERT INTO nop_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Yahwedi Saiyon uŋoŋ kedem kahaŋ tigambek. Du kwetfoloŋ iŋoŋ hatibaaŋ indigoŋ tuwot, hatiŋila kawaaŋ, nemenemek Jelusalem uŋoŋ momooŋ hogok mintawaak. ");
INSERT INTO nop_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Du adi unduŋ tiŋa nai kweheyeniŋ hatiŋa dadageye yabaaŋ. Eŋ Isilae kayoŋbop, hidi’walaŋkade kulema haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Isilae, du naŋgat-kaipmuŋ gineniŋ hatitalabuŋa kobuk i hatilaŋ kaŋ memikgeyedi dediŋ hinek gehitubu-kadakatalabiiŋ, wendok kahat tinimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Kaŋ du indiŋ yolaŋ, “Nu tububihila naŋgat kaipmuŋ hatitalabuŋa kobuk i hatilat, kaŋ memikneyedi nehitubu-kadakatalabugiŋ iŋgoŋ tuwot mu nalakapmegiŋ. ");
INSERT INTO nop_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Tahidi kisaŋ hinek nehinuhitnadiune sigine gitnem dokodoko tiŋa kulune wededi tahi kwelikoŋdok tuwolit kweheyehi mintaaŋ haliwiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Iŋgoŋ Yahwe adi didimeniŋ molom, doktiŋa me hogohi’walaŋ kohohik gineniŋ nehitubu-lodaaŋ kotigoŋ nanagitak. Kaŋ nu kotigoŋ tipilapilaye-me tuwaŋit mokit mu hatilat.” ");
INSERT INTO nop_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Nu adi indiŋ nadilat. Me Saiyondok mik timiiŋ heki u yehitiŋafooŋ widihi yehikelene kotigoŋ yohikwehineŋ uneŋ. ");
INSERT INTO nop_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Adi yadi kilihikit yot nonou foloŋ kadoŋa labiiŋ ala mu tamakutune nehi kumuŋgweheyeeŋ foiŋ, undihi hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Kilihikit kumuŋgweheyeiŋ u nebek me niŋdi nemu ibidokooŋ moŋgola ulak. Mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Eŋ metam nediyeŋ adi hakiiŋneŋ uŋoŋ wooŋ yalakapme kaŋ “Yahwedi momooŋ tihambek,” be “Yahwe’walaŋ wou gineŋ kahaŋ tihamam,” unduŋ mu yeniyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Yahwe, nu welemulap tiŋa kutiganilat. ");
INSERT INTO nop_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Ale Yahwe du kutibulabulayene nadiweŋ. Tiŋa nehitubu-lodadok kutikuti bulak u nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Du kadakaniŋnik nobu kunalune me nediyeŋdi du’walaŋ mede gineŋ kedem fafaŋeŋ yalek? ");
INSERT INTO nop_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Iŋgoŋ du adi kadakaniŋnik tumolokut tinimilaŋ, wendoktiŋa indi adi dutok gikiŋgoŋ tigamaneem. ");
INSERT INTO nop_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Nu adi Yahwedi nehitubu-lodadok hinek nadiŋa woomulat. Tiŋa medeŋiŋ nadikunakunale hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Nu adi Wapumdok woomilat, tiŋa adigoŋ hinek nehitubu-lodadok nadilat. Kaŋ wondi me heki timiŋ mik fok hatiŋa hele pilap tiliwek yoŋa nadiiŋ u kalakapme tilak. ");
INSERT INTO nop_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Isilaehi, indi adi Yahwedi nihitubu-lodadok nadikunakunale hinek tinim. Maŋgande, helemahelemaŋ weleŋdi nibukahile hinek tilak. Tiŋa undugoŋ indi kadaka titiŋdok mu nadinimilak doktiŋa helemahelemaŋ nihitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Adi memetamŋiye Isilaehi indi kotigoŋ ninigilaak. Tiŋa kadakaniŋnik tumolokutnimbaak. ");
INSERT INTO nop_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Yahwe, nu foko tiŋale natok nadiwene loloŋ tuluguk, u agaŋ wabidapmagut. Tiŋa undugoŋ, nemek wapuhidok be nemek noli nadidakale mu tilat wondok nadigigine adi mu tilat. ");
INSERT INTO nop_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Nu welenedi kulemaune momooŋ hinek hatat. Eyaŋdi miŋ kohoŋ foloŋ deihatak, wondok tuwolit hatat. Kaŋ walanedi maaŋ kulemaŋgoŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Isilaehi metam, hidi Yahwedok nadikunakunale timiiŋ u undugoŋ nadimiŋa hatiyaneeŋ, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Yahwe, du Dewit ne be malabumuŋ hogohogok nadiguk u adi nadikaule mu timimbaaŋ. ");
INSERT INTO nop_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Isilaehi’walaŋ Bepaŋ saŋiniŋnit, du Dewitdi dukut mede yofolok tuguk u nadisuweŋ. ");
INSERT INTO nop_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Adi indiŋ yoguk, “Nu yotne maaneŋ adi mu fowit, eŋ falikne foloŋ adi mu deilit. ");
INSERT INTO nop_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Nu adi hakule tiŋa damo mu deilit. ");
INSERT INTO nop_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Timeŋ adi Isilaehi’walaŋ Bepaŋ saŋiniŋnitdok yoli niŋ mamimbene uŋoŋ hatibuneke mindaŋ kaŋ kedem hakule tibaat.” ");
INSERT INTO nop_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Indi Betelehem gwaŋ hali nadigumun. Yahwe’walaŋ yofolok bogit agaŋ Yalihi’walaŋ kwetneŋ busuwalak. Kaŋ Yalihi’walaŋ kwetneŋ wooŋ folooŋ kagumun. ");
INSERT INTO nop_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Tiŋa indiŋ yoyam, “Yahwe yolineŋ unim ale, wooŋ mapme iit kwelineŋ wotubudulaaŋ hebeŋ foloŋ mulelem timinim.” ");
INSERT INTO nop_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Yahwe, da tiŋa yofolok bogit, hidi buŋa Siloŋyot gineŋ iŋoŋ hatemek. Yofolok bogit woŋ adi du’walaŋ saŋiniŋge diniŋ fek. ");
INSERT INTO nop_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Siloŋyot diniŋ talitimeŋ heki yehitubu-lodaune helemahelemaŋ titiŋ didimeniŋ hogok taneeŋ. Kaŋ wondi tinahukuthik momooŋ tiyembek. Kaŋ metamgeye adi nadifo tiŋa kakalineŋ. ");
INSERT INTO nop_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Yahwe, du kwanai-mege Dewitdok nadiweŋ, da mapme tubudakaleguŋ doktiŋa sigilulum mu timimbeŋ. ");
INSERT INTO nop_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Yahwe, du koom Dewitdok gigitmede biyagoŋ hinek niŋguŋ. U kotigoŋ mede yoyakale adi mu tilaŋ. Indiŋ niŋguŋ, “Nu du’walaŋ mihigeye’walaaniŋ niŋ mapme tubumintawaat. ");
INSERT INTO nop_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Tiŋa noli indiŋ, mihigeye hogohogokdi yofolokne takaliŋa Yodoko Mede yemgut u maaŋ takalineeŋ, wendok kedem mihigeye’walaŋ yalakihiyedi hogok kougoŋkougoŋ bunit mapme mintatauneeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Yahwedi Saiyon yokwet kakaŋ u agaŋ netok kahileguk. Tiŋa uŋgoŋ hatidok yoguk. ");
INSERT INTO nop_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Tiŋa undugoŋ indiŋ yolak, “Yokwet u agaŋ na mapme mintaaŋ uŋoŋ hatidok kahilegut. Yokwet wapumneŋ uŋoŋ helemahelemaŋ hatiluwaat, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Nu Saiyondok nemenemek tuwot hinek mimbene metamdi nemek niŋdok baniŋ tuwot mu tineeŋ. Tiŋa metam hambeep hatiiŋ hekidok nanaŋe yemtoki tibaat. ");
INSERT INTO nop_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Nu Siloŋyot diniŋ talitimeŋ heki na’walaŋ hatihati fafaŋeniŋdi tinahukuyemuluwaat. Kaŋ Saiyonhidi kap toŋa nadifooŋ baham kakaliyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Nu Dewit’walaaniŋ yalaki niŋ nagila yokwet u kaulidokodok mapme loloŋnit hinek kambiyalaat. Kaŋ adi’walaŋ mebop u na yabu-ulidokowene kwanai wendok gweheye mu tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Memikŋiye adi toboniŋ yehitubu-meka tibaat. Eŋ metam ne yabudoko tibaak adi yadi momooŋ hinek mintaaŋ saŋiniŋnit hatineeŋ.” ");
INSERT INTO nop_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Bepaŋ’walaŋ metamdi ipilathik gineŋ welekubugoŋ tiŋa me hekinolit hatihati wondi nemek momooŋ hinek. Unduŋ tiŋa welekulema foloŋ kedem hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Titiŋ undiniŋ adi olif mindip diniŋ galiki momooŋdi Alon mebi foloŋ yougomiŋgiŋ kaŋ siyabiŋiŋ gineŋ fowooŋ tinahukutŋiŋ kweheyeniŋ tabe foguk wondok tuwolit hinek. ");
INSERT INTO nop_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Welekubugoŋ diniŋ titiŋ adi bamholiŋa mitnekdi Hemon kweboboe foloŋ maaŋ wooŋ Saiyon kweboboe heki foloŋ malak wondok tuwot. Yahwedi kwet wondegoŋ yofafaŋeeŋ kahaŋneguk, tiŋa hatihati dapmandapmaŋnit mokit yemguk. ");
INSERT INTO nop_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Yahwe’walaŋ kwanai-meŋiye hogohogok adi’walaŋ Siloŋyot gineŋ timiŋ kwanaineiŋ heki, hidi buŋa Yahwe niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Siloŋyot gineŋ kohohik kwehene-belooŋ ninadiŋa wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Yahwe, kunum kwet yehitubu-mintaguk, Saiyon uŋoŋ hatilak, adi kedem hehikahaŋnewek. ");
INSERT INTO nop_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Yahwe niutumbaneŋ! Wapum wou nintiloneŋ. Yahwe’walaŋ kwanai-meŋiye hogohogok, hidi niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Hidi Yahwe Bepaŋnik’walaŋ Siloŋyot maaneŋ be wawaliweŋ yakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Adi momooŋ hinek tinimilak doktiŋa wou niŋatiloneŋ. Tiŋa undugoŋ, siloŋ tobogoŋ hinek tinimilak doktiŋa youtumba kap mohok toŋa wou niŋatilonim. ");
INSERT INTO nop_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Yahwedi Jekop adi netok hinek kahileguk. Unduŋ doktiŋa Isilaehi adi Bepaŋ ne’walaŋ metamŋiye hinek. ");
INSERT INTO nop_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Yahwe adi wougigitnit, bepaŋ yalayalaŋ yalakapmedapmaŋ hinek tiŋa lohinakaaŋ hatak, u agaŋ nadilat. ");
INSERT INTO nop_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Yahwe adi kunum foloŋ be kwetfoloŋ be imeŋgwaŋ gineŋ be imeŋgwaŋ kainiŋ hinek gineŋ nemek niŋ tibit yoŋa u kedem tibetik. ");
INSERT INTO nop_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Adigoŋ nadiune gwi uutdok mulukwaŋ kwetkwet buŋa bopnelak, kaŋ filimfila muŋkulap toŋa gwi malak. Eŋ sububa maaŋ tinaulibiŋiŋ gineniŋ fiya yakulune kwetkwet udapmalak. ");
INSERT INTO nop_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Isip uŋoŋ Isiphi’walaŋ mihi tuwo hogohogok eŋ kale maaniŋ biyehi u wanakaŋ widihikumuŋguk. ");
INSERT INTO nop_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Isip uŋoŋ Bepaŋ kunumneniŋ’walaŋ kudi mebimebi tiŋa mapme eŋ kwanai-meŋiye malabumuŋ yemguk. ");
INSERT INTO nop_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Wapum adi yokwet wapuhi fee yehitubu-kadakaaŋ mapme fafaŋehi widihikumuŋguk. ");
INSERT INTO nop_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Amohi’walaŋ mapme Sihon ulukumuŋguk, eŋ Basanhi’walaŋ mapme Ok tiŋa Kanahan kwetneŋ uŋoŋ mapme hatitaugiŋ hogohogok u wanakaŋ negoŋ widihikumuŋdapmaguk. ");
INSERT INTO nop_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Unduŋ tiŋa mapme kumuŋ tigiŋ heki’walaŋ kwet hogohogok u metamŋiye Isilaehidok yemguk. ");
INSERT INTO nop_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Yahwe, metam hogohogokdi du Bepaŋ u helemahelemaŋ nadigamaneeŋ. Kaŋ metam hogohogok mindaŋ mintaneeŋ heki adi maaŋ undugoŋ nadiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Yahwe adi metamŋiye’walaŋ medehik ulihiŋila kwanai-meŋiyedok bulaniŋgoŋ nadiyembaak. ");
INSERT INTO nop_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Metambop noli adi silwa tiŋa gol-di bepaŋ yalayalaŋ tutumbaiŋ. Bepaŋ yalayalaŋ u metam nehi kohohikdi yehitutumbaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Bepaŋ yalayalaŋ heki u mahikhinit, iŋgoŋ mede tuwot mu yoiŋ. Tiŋa undugoŋ dauhikhinit iŋgoŋ oŋ, dau diwediwe mu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Eŋ magihikhinit iŋgoŋ mede nemu nadiiŋ, tiŋa undugoŋ munabut maaŋ mu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Me bepaŋ yalayalaŋ yehitutumbaaŋ nadisukilitiyemiiŋ, adi yadi nehi maaŋ undihigoŋ hinek mintadok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Isilaehi metam hogohogok, hidi Yahwe wou nintiloneŋ. Bepaŋ’walaŋ Siloŋyot diniŋ talitimeŋ, hidi wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Lewi’walaŋ mebop, hidi Yahwe wou nintiloneŋ. Metam Yahwedok gikiŋgoŋ timiiŋ, hidi maaŋ wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Metam Saiyon uŋoŋ itowiiŋ, hidi Yahwe wou nintiloneŋ. Adi yadi Jelusalem uŋgoŋ hatilak. Yahwe niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Yahwe adi momooŋ hinek tinimilak doktiŋa indi Wapum welemomooŋ nadimiŋa niutumbanim. Adi weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Indi Yahwe welemomooŋ nadimiŋa niutumbanim. Adi kubugoŋdi bepaŋ yalayalaŋ yalakapmedapmaŋ tilak. Eŋ adi weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Indi Yahwe welemomooŋ nadimiŋa niutumbanim. Adi kubugoŋdi wapuhi’walaŋ Wapum hatilak. Eŋ adi weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Ne kubugoŋdi kunum saŋiniŋ diniŋ kudi wapuhi wapuhi tilak. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Ne’walaŋ nadinadiŋiŋ fuliŋgoŋ gineŋ kunum tiŋa nemenemek uŋoŋ hakiiŋ u boiguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Ne kubugoŋdi kwet wahiŋ kameeŋ ime kaiŋ boiguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Adigoŋ mele muyakip boiguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Adigoŋ nadiune meledi hadapmo kadokolak. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Adigoŋ nadiune muyakip tiŋa bamholiŋadi timiŋ kadokoiŋ. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Adigoŋ Isiphi’walaŋ mihihiye tuwo hogohogok widihikumuŋdapmaguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Negoŋ Isilaehi yanagilune Isip bikabuŋa bugiŋ. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Ne’walaŋ saŋiniŋŋiŋ gineŋ yanagilune bugiŋ. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Negoŋ nadiune Imeŋgwaŋ Giminiŋ u tawaaŋ fukuŋ fukuŋ ugumuk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Negoŋ talitimeŋ tiŋa metamŋiye yanagilune kwet siliŋ foloŋ ugiŋ. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Adigoŋ nadiune Isiphi’walaŋ me mapme tiŋa mikmeŋiye ime nadilaaŋ kumuŋgiŋ. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Adigoŋ metamŋiye timeŋ tiyembune kwet fiileŋ simintaneŋ ugiŋ. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Negoŋ me mapme saŋiniŋhinit widihi yehikeleguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Tiŋa adigoŋ me mapme wohikgigitnit u widihikumuŋguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Adigoŋ Sihon, Amohi’walaŋ me mapme ulukumuŋguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Tiŋa undugoŋ Ok, Basanhi’walaŋ me mapme ulukumuŋguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Unduŋ tiŋa me mapme heki’walaŋ kwehik u metamŋiyedok siloŋ tiyemguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Adi kwet u Isilaehi metamŋiye ne niutumbaiŋ aditok yemguk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Adi memikniyedi nihitiŋafo tubune adi nadikaule mu tinimilak. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Tiŋa memik heki’walaŋ kohohik gineniŋ kotigoŋ ninigikuk. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Adigoŋ nemenemek hatihatihinit hogohogok nanaŋe yemtoi tilak. Eŋ weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Unduŋ doktiŋa indi kunumneniŋ Bepaŋ welemomooŋ nadimiŋa niutumbanim. Adi yadi weleŋdi hinek nibukahilelak, dapmandapmaŋnit mokit. ");
INSERT INTO nop_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Indi Babilon kwetneŋ ime woditawiiŋ ime gaga-gaga itouŋa Saiyondok nadiŋa makunum tugumun. ");
INSERT INTO nop_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Tiŋa gita hekinik bem taŋeniŋ kufoloŋgoŋ hakiiŋneŋ uŋgoŋ yehitebinene wodigiŋ. ");
INSERT INTO nop_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Kaŋ memik tinimiŋa ninigilune kwanaimiŋ kwetneŋ bugumun hekidi indiŋ niniŋgiŋ, “Indi welemomooŋ nadinimdok kap toneŋ, eŋ Saiyon diniŋ kap niŋ toneŋ.” ");
INSERT INTO nop_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Yokwet noli’walaŋ gineŋ iŋoŋ dediŋ tiŋa Yahwe’walaŋ kap tonim? U tuwot mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Nu Jelusalem, dutok kaule nobuniŋ tigamuŋa kaaŋ, gita adi kotigoŋ tuwot mu ulit. ");
INSERT INTO nop_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Jelusalem, nu du nemek niŋdok nadiwene loloŋnit hinek tilak unduŋ e, dutok mu nadigamuŋa, be nadikaule tigamuŋa, koditne kwambundaune kap kotigoŋ tuwot mu tobit. ");
INSERT INTO nop_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Yahwe, du Idomhidi mik tinimiŋa kudi dediŋ hinek tiŋa Jelusalem kahilegiŋ u kotigoŋ nadisuweŋ. Medehik indiŋ yogiŋ u maaŋ nadisuweŋ, “Jelusalemhi’walaŋ yot hogohogok ubulagineeŋ yehitubu-kadakadapmaŋ titiŋdok.” ");
INSERT INTO nop_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Babilon, du adi gehitubu-kadaka hinek titiŋdok. Du kibi dediŋ tinimguŋ, wondok tuwot me kibikoŋ tubu-udanegamdok adi yadi nadifo tibaak. ");
INSERT INTO nop_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Me wendi wapmihigeye kuyahi-kabe u yahaŋe beŋa kawade foloŋ yehi-ugagayewaak. ");
INSERT INTO nop_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Yahwe, nu welenedi hinek ganiutumbalat. Tiŋa bepaŋ yalayalaŋ heki’walaŋ dauhik foloŋ kap toŋa du wohoge ganintilolat. ");
INSERT INTO nop_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Du mede yofafaŋeguŋ hogohogok u didimeniŋgoŋ keleeŋ welegedi hinek nibukahileeŋ nibudokolaŋ. Tiŋa wohoge be medege yotiloune nemenemek hogohogok yalakapmedapmaune kagumun. Unduŋ doktiŋa nu yoke uŋgoniŋneŋkade diwewene uune mulelem tiŋa wohoge ganintilolat. ");
INSERT INTO nop_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Nu du’walaŋkade kutinadiwe du kutinadine u agaŋ nadiŋa tubu-udanenamguŋ, tiŋa da’walaŋ saŋiniŋgedi nehitubu-kilitiune saŋiniŋnit tugut. ");
INSERT INTO nop_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Kwet wapum i hatak foloŋ me mapme hogohogok hatiiŋ adi mede yofafaŋege u agaŋ nadigiŋ, wendoktiŋa wohoge ganintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Tiŋa undugoŋ, du wohogegigit adi loloŋnit doktiŋa du maŋgoŋ tuguŋ u yobihila kap toneŋ. ");
INSERT INTO nop_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Yahwe, du lohinakaaŋ loloŋnit hinek hatilaŋ, iŋgoŋ fiit metam nehitok nadiune fofoŋ tilak aditok uŋgoŋ nadiyemilaŋ. Eŋ me sigitiŋalo tiŋa nehitok nadiune loloŋ tilak heki adi du gabuhebi tineŋdok tuwot moŋ. ");
INSERT INTO nop_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Malabumuŋ fee mintanamulakneŋ nai uŋaniŋ du nabudokoune nu kedem hatilat. Tiŋa memik hekidi kwihita tinamiiŋ, iŋgoŋ du yahehewe tinamuŋa mik tiyemilaŋ. Unduŋ tiŋa da’walaŋ saŋiniŋge foloŋ kotigoŋ nanagitaŋ. ");
INSERT INTO nop_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Yahwe, du nemek titiŋdok yofafaŋeguŋ woŋ adi undugoŋ hinek tibaaŋ. Tiŋa welegedi hinek nabukahile tilaŋ, dapmandapmaŋnit mokit, ale kwanaige tububihila tuguŋ u tubune dapmawaak. ");
INSERT INTO nop_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Yahwe, du welene agaŋ kakolodiŋa nabunadidapmalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Nemenemek hogohogok tilat u du agaŋ nadidapmalaŋ. Tiŋa undugoŋ kweetniŋ hataŋ iŋgoŋ oŋ, nadinadine hogohogok wanakaŋ hinek kaŋ nadihinakalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Hadapmo kwanai tilat eŋ timiŋ damo deitat u du agaŋ nabulaŋ. Tiŋa titiŋne hogohogok u agaŋ kaŋ nadidapmalaŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Maŋgoŋ mede yobe nadilat u du agaŋ koom nadilaŋneŋ yolat. ");
INSERT INTO nop_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Du da’walaŋ saŋiniŋgedi nehitubu-lodaaŋ, fukuŋ be fukuŋ hatikili tiŋa nabu-ulidokolaŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Du nadinamdapmahinaka tilaŋ. Tiŋa du’walaŋ nadinadige momooŋ hinek wendi nalakapmeeŋ lohinaka hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Deŋandiŋbo yoŋa wooŋ Munabulige bikabit? Be du gabuhebiŋa momoŋ wooŋ daŋgoŋ hebihalit? ");
INSERT INTO nop_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Nu kunum foloŋ binek looŋ hatibit, u du maaŋ uŋgoŋ hatilaŋ. Be nu wooŋ me dabahi’walaŋ yohikwehineŋ hatibit, u du maaŋ uŋgoŋ hatilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Be woleeŋ kwet kweetniŋ mele labulakneŋkade wit, be wooŋ kwet kweetniŋ mele folakneŋkade hatibit, ");
INSERT INTO nop_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","iŋgoŋ du uŋgoŋ hatiŋila nehitubu-lodaaŋ talitimeŋ tiŋa nanagitaŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Be mambip indiŋ nimbit, “Mambip, du nehitumuhebeŋ,” eŋ “Hauta, nehikelemadiŋa hautalaŋ, du mambip tibeŋ,” ");
INSERT INTO nop_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","iŋgoŋ oŋ, du’walaŋkade adi mambip u kalaŋ kaŋ mambip mu tilak, eŋ timiŋ adi hadapmo nabugoŋ hautaaŋ hatak. Du’walaŋkade mambip dut hauta adi namandap molomolom mu tamuk. ");
INSERT INTO nop_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Foloone dikidiki hali ulak hogohogok u da kubugoŋdi tutumbaguŋ. Unduŋ tiŋa maane’walaŋ weleŋ maaneŋ yehikiulune mintagut. ");
INSERT INTO nop_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Nu gikiŋgoŋ tigamuŋa nadigambene uŋgoniŋ hinek tilak, doktiŋa welemomooŋ nadigamuŋa wohoge ganintilolat. Nemenemek hogohogok tilaŋ u yadi momooŋ tiŋa uŋgoniŋ hinek. Wendok adi welene gineŋ hinek duŋgoŋ nadiŋa nadihinaka hinek tilat. ");
INSERT INTO nop_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Maane’walaŋ weleŋ maaneŋ kabup hebihali baigoŋ baigoŋ ha-mintagut, kaŋ nai uŋaniŋ du uŋgoŋ ha-nabulune kitiline mintaaŋ tomboyoukiŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Maanedi mu nanagitune du agaŋ koom nabunadiguŋ. Tiŋa undugoŋ kwetfoloŋ iŋoŋ mu mintaluwene melenai dedigoŋ hinek kwetfoloŋ iŋoŋ hatibaat u agaŋ koom pepage gineŋ youkuŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Bepaŋ, nu du’walaŋ nadinadige u tuwot mu nadidakalewit. Nadinadige adi wapum hinek, nu nadidakalewitdok talik nemu hatnamulak. ");
INSERT INTO nop_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Du nemenemek nadilaŋ u kunalene wondi’walaŋ kunakunatdi kiŋ luhineŋ ikiiŋ’walaŋ kunakunathik u kalakapme tibek. Nu damo gineniŋ sukuleeŋ pilali dukut noŋgoŋ hatilat. ");
INSERT INTO nop_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Bepaŋ, nu indiŋ nadilat, me kadakahi adi widihikumuŋ tibeŋ. Kaŋ me koŋgolondahi adi kedem binabuŋa uneŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Me heki woŋ adi medehaki ganiiŋ. Tiŋa undugoŋ mede hogohi mebimebi yoŋa wohoge tubukadakaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Yahwe, metam mik tigamiiŋ adi yadi kibi nubo mik tiyemulat. Tiŋa me nadihaŋinda tigamuŋa foko tiiŋ heki adi yabuŋa nadikadaka tilat. ");
INSERT INTO nop_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Biyagoŋ hinek-ku, nu metam undihi adi welenedi yabukwihita tilat. Metam undihi adi yabene memikneye unduŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Bepaŋ, welene gineŋ diwedapmaaŋ nadinadine dediŋ hinek hakiiŋ u kanadi tibeŋ. Nadinadine hogohogok kakolodiŋa nadidapmaweŋ. ");
INSERT INTO nop_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Tiyaugene mede yalaŋdi nadinadine gineŋ hatneeneŋ doktiŋa momooŋgoŋ hinek nabukolodiweŋ. Unduŋ tiŋa nanagilune hatihati momooŋ dapmandapmaŋnit mokit diniŋ talik uŋak takaliwit. ");
INSERT INTO nop_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Yahwe, du nehitubu-lodaweŋ kaŋ me hogohidi mu nehitubu-kadakaneŋ. Eŋ momooŋgoŋ nabudokoune me koŋgolondahidi memik mu tinamneŋ. ");
INSERT INTO nop_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Helemahelemaŋ adi yadi titiŋ hogohi titiŋdok hogok nadiiŋ. Unduŋ tiŋa metam lekiŋgoŋhik gineŋ mik-kwadi tubumintaiŋ. ");
INSERT INTO nop_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Medehik yoiŋ adi kudupnit hinek, miŋgembet miknit maŋiŋ nabugoŋ, eŋ me yeniŋkadaka titiŋdok mede adi miŋgembet mimimnit’walaŋ upmuŋ maŋiŋ gineŋ hatak unduŋ hayemilak. ");
INSERT INTO nop_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Yahwe, du momooŋgoŋ hinek nabudokoune me hogohi’walaŋ saŋiniŋhikdi mu nehitifowek. Tiŋa undugoŋ nabu-ulidokoune me koŋgolondahidi nehitubu-kadakadok yoiŋ iŋgoŋ nemek nemu tinamneŋ. ");
INSERT INTO nop_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Me gifoko heki adi siyoŋ folokene kamenamuŋa fook ha-tiiŋ. Tawa u fafaŋeniŋ hinek, ala nu wooŋ siyoŋ gineŋ kale hekidi foyakiiŋ unduŋ foyalit yoŋa talitne foloŋ tehiŋa hakiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Nu Yahwe indiŋ nilat, “Du Bepaŋne. Yahwe, nehitubu-lodaweŋ yoŋa kutiganilat.” ");
INSERT INTO nop_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Yahwe, Bepaŋne eŋ nu’walaŋ yahehewe fafaŋeniŋ, koom memikniye gut mik tugumunneŋ dagoŋ momooŋ hinek nabudokoguŋ. ");
INSERT INTO nop_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Yahwe, me hogohidi nemek bedok nadiiŋ, u aditok mu yembeŋ. Adi nemek kadakaniŋ titiŋdok mede yofolok tiiŋ, u mu biyabune tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Memikneye biyabune mik gineŋ mu nehitifoneŋ. Nu nehitubu-liwedok mede kwihitaŋgoŋ yoiŋ, ale nutok nemek tinamdok yoiŋ u tubu-udaneyembune nehitok wek. ");
INSERT INTO nop_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Kedem be kudup sigihi hinek dadaŋhinit u biyabune maaŋ foloohik foloŋ foneŋ. Unduŋ tiŋa yehisilone bekulune koŋ fuliŋ gineŋ fooŋ kotigoŋ tuwot mu labuneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Metam nolidi me noli mede gineŋ hogok yapmefit tiiŋ. Metam undihi u biyabune mede foloŋ fafaŋe tuwot mu taneeŋ. Tiŋa nemek kadakaniŋ hinekdi me koŋgolondahidok mintayemiŋa yehitubu-liwedapmaŋ hinek titiŋdok nadilat. ");
INSERT INTO nop_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Meeniŋ nolidi metam hambeep hatiiŋ be metam nemenemekdok baniŋ tiiŋ u momooŋgoŋ mu tiyemiiŋ, kaŋ Yahwe du da mede gineŋ yehi-ulihiŋa yehitubu-lodalaŋ u agaŋ nadilat. ");
INSERT INTO nop_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Biyagoŋ hinek, metam didimehi adi du’walaŋ wohoge ganintilooŋ helemahelemaŋ dukut hebeke foloŋ hatiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Yahwe, du pilap hinek nehitubu-lodaweŋ yoŋa du ganinadilat. Nu du kutiganilat, unduŋ doktiŋa du yonadine u nadinambeŋ. ");
INSERT INTO nop_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Kaŋ yonadi tilat wondi mupmuk munduŋ momooŋ unduŋ du’walaŋkade lowek, eŋ kohone kwehene-beŋalooŋ ninadilat wondi wahu munduŋ unduŋ tibek. ");
INSERT INTO nop_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Yahwe, du mane momooŋgoŋ kadokoweŋ, tiŋa medene yoyodok u maaŋ kakuwaleŋ. ");
INSERT INTO nop_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Du walane bikabune kadakaniŋ titiŋdok koloŋ adi mu yalek. Tiyaugene me hogohi dut bopneeŋ nemek kadakahi noli tibaatneŋ doktiŋa du mu binabeŋ. Tiŋa undugoŋ, bepaŋ yalayalaŋ yeniutumba diniŋ hinamunihik gineŋ waatneŋ doktiŋa mu binabeŋ. ");
INSERT INTO nop_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Nu adi me titiŋ hogohi tiiŋ wendok Bepaŋdi kibikoŋ tubu-udaneyembek yoŋa helemahelemaŋ ninadilat. Unduŋ doktiŋa me undihidi nanintiloune medehik mu nadiwit. Iŋgoŋ me didimeniŋdi welesiloŋ tinamuŋa nanintoŋa nehitubu-didimewek, woŋ adi kedem. ");
INSERT INTO nop_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Me nolidi me hogohi u yanagila yehitubu-kadakaiŋ, kaŋ nai uŋaniŋ indiŋ u nadidakaleiŋ, Bepaŋ’walaŋ medeŋiŋ adi biyagoŋ hinehinek. ");
INSERT INTO nop_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Kaŋ meheki weŋ’walaŋ kitilihik adi me niŋdi kudup golotneŋ utawahipihipik-kabe tiŋa kupupuheneune hakiiŋ wondok tuwolit beŋa mekoŋ mamineŋ kupupuheneune hali uneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Yahwe Bepaŋne, du mu binabune kumumbit. Nu du’walaŋkade diwewene uune hati nadisukilitigamulat, unduŋ doktiŋa momooŋgoŋ hinek nabudokoweŋ. ");
INSERT INTO nop_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Da nehikwalaneune me hogohidi begep ibinamiiŋ wendi mu nulek. ");
INSERT INTO nop_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Me hogohi u nadiyembune nehi begep ibiiŋ wendigoŋ yehiwidihiwek. Iŋgoŋ nu adi nemek niŋdi mu nehitubu-kadakaune kedem hatibit. ");
INSERT INTO nop_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Nu Yahwedi nehitubu-lodawek yoŋa gibita kutinilat. Eŋ nehitubu-lodawek yoŋa gigine tiŋa ninadilat. ");
INSERT INTO nop_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Nu welemulap nadilat be malabumuŋ mintanamulak hogohogok u nimbihitat. ");
INSERT INTO nop_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Welenedi gweheyehinaka tilak, nai uŋaniŋ Wapum du dediŋ tibit u agaŋ nadidapmalaŋ. Nu talitne giyoki foloŋ nohonedok yoŋa begep uŋgoŋ ibinamiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Nu diwewene woŋambuŋat tilak, kaŋ nebek niŋdi nehitubu-lodawekdok nemu kalat. Eŋ nebek niŋdi yahehewe tinambekdok nemu kalat. Be nebek niŋdi nabudoko nemu tilak. ");
INSERT INTO nop_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Yahwe, da kubugoŋdi nehitubu-lodaweŋ yoŋa kutiganilat. Du kubugoŋdi yahehewene. Unduŋ doktiŋa metam nolidi kwetfoloŋ nemek hogohogok kedem daneeŋ moŋgola yabukahileneeŋ. Iŋgoŋ nu adi kaipmuŋ hatibaat tuwot, du hogok gabukahileluwaat. ");
INSERT INTO nop_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Welenedi malabuda hinek tilak doktiŋa nehitubu-lodaweŋ yoŋa kutiganilat. Me kadakaniŋ tinamiiŋ heki adi fafaŋe hinek tiiŋ, kaŋ nu me heki u fafaŋeeŋ yalakapmedok tuwot mokoŋ. Unduŋ doktiŋa du kubugoŋdi kedem adi’walaŋ kohohik gineniŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Du titiŋ momooŋ hinek tiŋa malabumuŋ gineniŋ kotigoŋ nanagileŋ, wendoktiŋa metamgeyedi bop taneeneŋ wohoge ganintiloluwaat. ");
INSERT INTO nop_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Yahwe, du yonadine nadinambeŋ. Magi kametnadi tiŋa kobulabulayene nadiweŋ. Du titiŋ didimeniŋ hogohogok tilaŋ, tiŋa mede yofafaŋeguŋ hogohogok didimeniŋgoŋ kelelaŋ, doktiŋa yonadine nadiweŋ. ");
INSERT INTO nop_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Kwanai mege nu mede foloŋ napmeeŋ mu nabukolodiweŋ. Maŋgande, nebek niŋdi du dauge foloŋ yomnit mokit me didimeŋ nemu hatilak. ");
INSERT INTO nop_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Memiknedi nehikeleeŋ agaŋ nehitiŋafohinaka hinek tuguk. Tiŋa mambip gineŋ napmeeŋ nehifolokeneguk, kaŋ me agaŋ koom kumuŋgiŋ nabugoŋ hatat. ");
INSERT INTO nop_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Unduŋ doktiŋa munta kisaŋ tibene munabuline gweheye tilak. ");
INSERT INTO nop_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Nu nemek koom mintagiŋ wendok hanadilat. Tiŋa undugoŋ du nemek hogohogok tuguŋ be kwanaige momohi tuguŋ u maaŋ hati nadituwatuwale tilat. ");
INSERT INTO nop_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Nu ganinadi tiliwene welene adi meledi kwet dahimintaune tawa-piŋpaŋ tilak wondok tuwolit dutok nadilak. ");
INSERT INTO nop_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Yahwe, nu nadisukilitine agaŋ gilaŋgilaŋ tilak doktiŋa yonadine nadiweŋ. Tiyaugene kumuŋa wooŋ me kumuhi’walaŋ yohikwehineŋ waatneŋ, doktiŋa du namandake kufulahebi mu tibeŋ. ");
INSERT INTO nop_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Nu du nadisukilitigamulat, unduŋ doktiŋa nehitubu-lodaune nu helemahelemaŋ helehelede welegedi nabukahile hinek tilaŋ u nadisuluwaat. Nu adi du hogok ganinadilat, unduŋ doktiŋa talik nanindidimeune kaŋ keleit. ");
INSERT INTO nop_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Yahwe, du nabudokoweŋ yoŋa du’walaŋkade bulat. Ale du memikneye kohohik gineniŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Du Bepaŋne doktiŋa nu du’walaŋ nadinadi takalidok nehititiŋeneweŋ. Tiŋa munabulige momooŋ u kameune buŋa talik momooŋ foloŋ nanagilek. ");
INSERT INTO nop_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Yahwe, du mede yofafaŋe dibek tuguŋ undugoŋ tiŋa hatihatine kotigoŋ kaulidokoweŋ. Da’walaŋ kedem doktiŋa malabumuŋ gineniŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Nu du’walaŋ kwanai-mege doktiŋa welegedi hinek nabukahilelaŋ. Unduŋ doktiŋa du memik be me nehitubu-kadaka tiiŋ heki u yehiwidihikumuŋ tilaŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Yahwedi yahehewe tinamulak doktiŋa niutumbalat. Tiŋa negoŋ mik titiŋdok naninehititiŋenelak, eŋ mik wapum gineŋ mik titiŋdok maaŋ nehitiulidokolak. ");
INSERT INTO nop_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Adi negoŋ nabu-ulidokooŋ yahehewe tinamulak, eŋ adi negoŋ kotigoŋ nanagitak tiŋa adi negoŋ hebi-itne kwet. Nu adi nadisukilitimilat doktiŋa nadinambune momooŋ hatilat. Kaŋ metam noli hogohogok adi yapmeune buŋa nu’walaŋ hebetne foloŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Yahwe, metam indi dedihigoŋ hinek doktiŋa inditok nadinimilaŋ. Indi adi nemek fiit nabugoŋ ale maŋgande inditok nadibedi tilaŋ? ");
INSERT INTO nop_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Metamdi munabut nai kubugoŋ tinene maguhuguhut labu bu-ulak, indi adi wondok tuwolit. Eŋ hatihatinik adi melenai kubugoŋ gineŋ wolinikdi mintaaŋ uyeŋ fiitak, wondok tuwolit muniŋgoŋgoŋ-kabe hinek. ");
INSERT INTO nop_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Yahwe, du kunum dilitomuŋa foweŋ, fooŋ kweboboe heki foloŋ kohoge kameune mupmuk labuneŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Filimpit nadimimbune hautaŋiŋdi memik heki yehitubu-pupuheneune momoŋ uneŋ. Eŋ tebe kandamge fiyagiyembune momoŋ uneŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Kohoge kihiwalune foune ime fuliŋmamaŋ gineniŋ nehimaneune ime u bikabuŋa labit. Unduŋ tiŋa me niŋkadehi’walaŋ saŋiniŋhik gineniŋ kotigoŋ nanagileŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Meheki ya biyagoŋ mu yoiŋ, yalaŋ yoŋa Bepaŋ dawineŋ kohodidim tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Bepaŋ, nu kamiŋ kap kobuli tobit, tiŋa gita ulaŋa kap togambit. ");
INSERT INTO nop_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Du mapme heki mik gineŋ yehitubu-lodalaŋ kaŋ fafaŋe tiiŋ, unduŋ tiŋa kwanai-mege, Dewit, nu kotigoŋ nanagitaŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Memik kadakaniŋ hinek tinamiiŋ heki’walaŋ kohohik gineniŋ kotigoŋ nanagileŋ. Tiŋa undugoŋ, me niŋkadehi’walaŋ kohohik gineniŋ kotigoŋ nanagileŋ. Adi biyagoŋ mu yoiŋ, adi yalaŋ yoŋa Bepaŋ dawineŋ kohodidim tiiŋ ");
INSERT INTO nop_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Bem hekidi saŋiniŋhinit loiŋ, wondok tuwolit mihiniyedi maaŋ mekuyahik gineŋ undugoŋ hinek mintadok nadiyam. Kaŋ waabiniye adi mapme’walaŋ yoli wapum diniŋ taka welewele momooŋdi tinafukulimiiŋ wondok tuwolit hinek mintadok nadiyam. ");
INSERT INTO nop_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Dininanik gineŋ nanaŋe duhuduhudi kedem mintaune hinaulibinik yot gineŋ maaŋ undugoŋ nanaŋedi toki titiŋdok nadiyam. Kaŋ dompa heki adi maaŋ undugoŋ mihiniŋ fee mumuyeŋ biyeneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Eŋ makau heki maaŋ undugoŋ mihiniŋ fee mintaneeŋ, kaŋ adi’walaaniŋ niŋdi hogoli mintaaŋ kumuŋ-kabe nemu tibaak. Kaŋ indi’walaŋ taliknik gineŋ uŋoŋ me be tam niŋdi malabumuŋ be folofigita doktiŋa koyone adi mu titiŋdok. ");
INSERT INTO nop_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Metambop nediyeŋ nemenemek momooŋ unduŋ mintayemiiŋ adi yadi nadifo kedem tineeŋ. Eŋ metam nediyeŋ Yahwe adi Bepaŋhik unduŋ nadimiiŋ adi maaŋ undugoŋ nadifo kedem tiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Bepaŋ eŋ Mapmene, nu wohogegigit yohautawit, eŋ welemomooŋ nadigamuŋa ganiutumba adi dapmandapmaŋnit mokit tuluwaat. ");
INSERT INTO nop_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Nu helemahelemaŋ welemomooŋ nadigamuŋa ganiutumba tuluwaat, tiŋa undugoŋ wohoge adi dapmandapmaŋnit mokit ganintilowene haliwooŋ halaak. ");
INSERT INTO nop_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Yahwe adi wougigitnit doktiŋa wou nintilonene foloniŋgoŋ hatuwaak. Adi’walaŋ wougigitŋiŋ loloŋnit u indi nadidakale hinek tinimdok tuwot mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Bepaŋ, du nemenemek tuguŋ wendok metam kobuk hatiiŋdi metambop kougoŋ mintaneeŋ u yenihautaune wohoge ganintiloneeŋ. Tiŋa kwanai wapuhi tuguŋ wendok kahat tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Metamdi da’walaŋ wohogegigit tiŋa saŋiniŋge uŋgoniŋ wendok yoyaneeŋ, kaŋ na adi kwanai momohi momohi tuguŋ wendok nadikaule mu tiŋa uŋgoŋ hati nadikuwatat. ");
INSERT INTO nop_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Metam adi du kwanai saŋiniŋnit tuguŋ wendok kahat tiyaneeŋ, kaŋ nu adi du’walaŋ wohogegigit u yohautaluwaat. ");
INSERT INTO nop_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Adi titiŋge momohi wendok kahat yoyaneeŋ eŋ titiŋge didimeniŋ wendok kap toyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Yahwe adi kwihita pilap mu tilak, kulemadi weleŋ gineŋ tokooŋ hatak. Unduŋ doktiŋa fiit nadikulemaaŋ siloŋ tobogoŋ tinimilak. ");
INSERT INTO nop_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Adi metam hogohogokdok momooŋ tiyemilak, tiŋa nemenemek boiguk hogohogok aditok nadikulema tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Yahwe, nemenemek hogohogok yehitubu-mintaguŋ adi wohoge ganintiloneŋ, kaŋ memetamgeye adi welemomooŋ nadigamuŋa ganiutumba tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Du’walaŋ hatihati fafaŋeniŋ diniŋ wougigit hautanit wendok yoneŋ eŋ saŋiniŋgedi loloŋnit hinek wendok kahat tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Unduŋ tubune metam hogohogokdi du kwanai wapuhi tuguŋ u kedem nadineŋ, eŋ dagoŋ Mapme wohogegigitnit hatilaŋ u maaŋ nadineŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Dagoŋ Mapme hatiŋa metam hogohogok u helemahelemaŋ yabudokoluwaaŋ. Yahwe adi gigitmede yofafaŋeguk u didimeŋgoŋ hinek yehikelelak, unduŋ tiŋa kubugoŋ-kabe nemu bikabulak. Adi yadi nemenemek tilak hogohogok wendi siloŋ tobogoŋ tubumintalak. ");
INSERT INTO nop_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Adi yadi memetam malabumuŋhinit u yehitubu-lodalak, eŋ metam gweheye tiŋa fofoŋhinit tiiŋ heki u yehitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Nemenemek hatihatihinit hogohogok adi dau diwediwe tubune Wapum nanaŋe yemilak’walaŋkade hogok ulak, kaŋ nai foloŋgoŋ negoŋ nanaŋe yemilak. ");
INSERT INTO nop_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Adi nemenemek tuwot hinek yemtoi tubune nemek niŋdok baniŋ mu tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Yahwe adi titiŋ didimeniŋ takalilak, tiŋa nemenemek hogohogok tilak u nadikulema foloŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Metam nediyeŋ welehikdi hinek kahileeŋ kutiniiŋ, adi yadi yehitubu-dula tiŋa adut yamaiŋgoŋ uŋgoŋ hatilak. ");
INSERT INTO nop_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Metam nediyeŋ aditok gikiŋgoŋ timiiŋ, adi yadi nemek niŋdok baniŋ tiiŋ kaŋ momooŋ hinek yehitubu-lodalak. Tiŋa kobulabulayehik nadiŋa kotigoŋ yahaŋelak. ");
INSERT INTO nop_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Metam nediyeŋ welehikdi adi kahilehinaka tiiŋ adi yadi momooŋ hinek yabudokolak. Iŋgoŋ oŋ, metam titiŋ hogohi tiiŋ heki adi yehitubu-kadaka tibaak. ");
INSERT INTO nop_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Nu helemahelemaŋ Yahwe niutumbaluwaat. Kaŋ nemenemek hogohogok hehitubu-mintaguk, hidi maaŋ undugoŋ helemahelemaŋ wou uŋgoniŋ u dapmandapmaŋnit mokit nintiloyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Yahwe niutumbait! Nu welenedi hinek Yahwe niutumbait! ");
INSERT INTO nop_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Kwet foloŋ iŋoŋ hatitalowaat indigoŋ tuwot niutumbaluwaat. Tiŋa kap toŋa Bepaŋne wou nintilooŋ hatitauyeeŋ kumumbaat. ");
INSERT INTO nop_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Du mapme heki be kwetfoloŋ me mu nadisukiliti-yemiluwaaŋ. Adi tuwot mu gehitubu-lodaaŋ ganagitneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Adi kumuŋa agaŋ kotigoŋ kwet yageleiŋ. Kaŋ nai uŋaniŋ nemenemek hogohogok titiŋdok yogiŋ u tuwot mu tineeŋ. ");
INSERT INTO nop_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Nebek niŋ Jekop’walaŋ Bepaŋdi tubulodalak, adi welemomooŋ nadiŋa nadifo tibaak. Me wondi Yahwe Bepaŋŋiŋ nadikunakunale tilak doktiŋa adi’walaŋ kahaŋ kahilelak. ");
INSERT INTO nop_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Bepaŋdi kunum kwet eŋ imeŋgwaŋ tiŋa nemenemek hogohogok uŋoŋ hadapmaiŋ u yehitubu-mintaguk. Tiŋa undugoŋ Bepaŋ adi gigitŋiŋ mede hogohogok u helemahelemaŋ takalilak. ");
INSERT INTO nop_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Metam memikhiye’walaŋ yalaŋhik doktiŋa malabumuŋnit hatiiŋ adi yadi Bepaŋdi titiŋ didimeniŋ tiŋa yehitubu-lodalak. Tiŋa metam nanaŋe map tiiŋ u nanaŋe yemtoi tilak. Yahwedi metam kwanai fafaŋeniŋ tuwaŋit mokit hati tigiŋneniŋ kotigoŋ yahaŋelak. ");
INSERT INTO nop_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Unduŋ tiŋa me dauhik sipmakahi u yehitubu-lodaune dau diwediwe tiiŋ, eŋ metam malabumuŋ gineŋ hakiiŋ u malabumuŋhik liliwenekuyemilak. Yahwe adi metamŋiye didimehi u yabukahile hinek tilak. ");
INSERT INTO nop_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Adi metam niŋkadehi indi’walaŋ kwetnineŋ iŋoŋ hatiiŋ u maaŋgoŋ yehitubu-lodalak. Tiŋa undugoŋ tam kahat, eŋ wapmihi kondiŋahi u maaŋgoŋ yehitubu-lodalak. Iŋgoŋ me kadakahidi maŋgoŋ niŋ tinim yoŋa tiiŋ woŋ adi toboniŋ yehitubu-giyonda tilak. ");
INSERT INTO nop_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Yahwe adi mapme dapmandapmaŋnit mokit hatibaak. Saiyonhi memetam, hidi’walaŋ Bepaŋhik adi mapme dapmandapmaŋnit mokit hatibaak. Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Yahwe niutumbanim! Maŋgande, adi yadi Bepaŋnik doktiŋa kap toŋa wou nintilonim. Adi’walaŋ wougigit yotilo u yadi titiŋ didimeniŋ eŋ momooŋ wendoktiŋa undugoŋ timinim. ");
INSERT INTO nop_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Yahwe adi Jelusalem kotigoŋ tubupilalune yatak. Kaŋ metam yanagilune wooŋ kwanai fafaŋeniŋ tuwaŋit mokit hati tigiŋneniŋ kotigoŋ yanagilune biiŋ. ");
INSERT INTO nop_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Adi unduŋ tiŋa metam nediyeŋ welemulap tiŋa nadimalabuda tiiŋ heki u yehitubu-lodalak. Eŋ wedehik u ibi-utumba tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Adi bamholiŋa dedigoŋ itneeŋ u komtegoŋ nadihabiyeŋ boiguk, tiŋa wohiye molomolom yenilak. ");
INSERT INTO nop_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Wapumnik adi wougigitnit tiŋa saŋiniŋŋiŋ loloŋnit. Indi adi’walaŋ nadinadiŋiŋ kameka tuwot mu tinim. ");
INSERT INTO nop_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Adi yadi me nediyeŋ nehitok nadiune fofoŋnit tiiŋ u nadiyembune loloŋ tilak, eŋ metam hogohi adi toboniŋ kwet dut yehiyalifagihi tilak. ");
INSERT INTO nop_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Yahwedok kap tomiŋa niutumbanim, gita utnene Bepaŋdok mede momooŋ tomineŋ. ");
INSERT INTO nop_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Adigoŋ nadiune kunum foloŋ mulukwaŋ mintalak, tiŋa adigoŋ nadiune gwi kwetfoloŋ maaŋ kilihikit tuwai kabekabe foloŋ ilawiiŋ u yehitubu-haikalak. ");
INSERT INTO nop_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Tiŋa undugoŋ kale heki hogohogokdok nanaŋe yemilak, eŋ kalaŋkatak mihiniŋdi mede toiŋ kaŋ aditok maaŋ undugoŋ nanaŋe yemilak. ");
INSERT INTO nop_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Wapum adi wosi fafaŋehi eŋ mikme fafaŋehi aditok nadifo mu tilak. Mokoŋ. ");
INSERT INTO nop_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Wapumdi metam nediyeŋ netok gikiŋgoŋ timiiŋ, adi yabunadifo tilak. Biyagoŋ hinek, nediyeŋ Yahwe’walaŋ siloŋ tobogoŋ dapmandapmaŋnit mokit wendok nadikunakunale tiiŋ, aditok adi nadifo tiyemilak. ");
INSERT INTO nop_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","O Jelusalem, Yahwe niutumbaweŋ! O Saiyon, Bepaŋge niutumbaweŋ! ");
INSERT INTO nop_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Adigoŋ gimbahaŋ diniŋ yeme wapuhi u tubufafaŋelak, tiŋa metamgeye yehikahaŋnelak. ");
INSERT INTO nop_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Tiŋa undugoŋ adigoŋ kwehik kadokooŋ fiyehik gineŋ nanaŋe duhuduhu tubumintahambune natoki tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Adi mede niŋ binek yolak, u pilap hinek kwetfoloŋ fooŋ mintalak. ");
INSERT INTO nop_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Adi gwi munilit munilit (snow) u yeniŋkulune maaŋ fooŋ kwet kufuladapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Eŋ gwi mindip (ais) woŋ adi kawade kuyahikuyahi wendok tuwot maaŋ kwet tubusububadapmaŋ tilak, kaŋ nebek niŋdi subumuŋ u kelekufali fafaŋeŋ yalekdok tuwot moŋ. ");
INSERT INTO nop_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Kaŋ mindaŋ kotigoŋ yolak kaŋ gwi mindip (ais) maaŋ fooŋ kwet kufulaŋa hatak u ime yagelelak. Kaŋ negoŋ yobune sububa fedilune ime wodilak. ");
INSERT INTO nop_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Adi metamŋiyedok mede yenilak. Yenindakale mede tiŋa Yodoko Mede u Isilaehidok yenilak. ");
INSERT INTO nop_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Adi metam nolidok unduŋ mu tiyemilak. Kaŋ adi’walaŋ Yodoko Medeŋiŋ mu nadiiŋ. Unduŋ doktiŋa indi Yahwe niutumbanim! ");
INSERT INTO nop_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Yahwe niutumbaneŋ! Nemenemek wahiŋ kunum foloŋ hakiiŋ, hidi Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Aŋelo heki hogohogok, hidi niutumbaneŋ! Kunum foloŋ mikme hatiiŋ hogohogok, hidi niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Mele dut muyakip, hidi niutumbademek! Kaŋ hinantilamek heki, hidi maaŋ niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Kunum foloniŋ gimiŋgimiŋ lohinakaaŋ hataŋ, du niutumbaweŋ! Ime kunum gineŋ hataŋ, du niutumbaweŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Nemek hogohogok i negoŋ yobune mintagiŋ, unduŋ doktiŋa Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Adi kwehik dibek yeniŋa-uguk indigoŋ tuwot hakiiŋ, unduŋ doktiŋa mede wobu tuwot mu tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","8","Kwetfoloŋhi, hidi Yahwe niutumbaneŋ! Imeŋgwaŋ fuliŋmamaŋ gineŋ pisi wapuhi eŋ nemenemek maaneŋ uŋoŋ hatiiŋ tiŋa mulukwaŋ gineŋ filim fitak eŋ gwi mindip maiŋ be mulukwaŋ tiŋa fifiŋgobut, Wapum’walaŋ maŋiŋ mede tagimneiŋ, hidi niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","10","Kweboboe wapuhi tiŋa tuwai kuyahi, bem gimiŋ mimihi tiŋa bem hoŋneŋ yakiiŋ, kale mimihi eŋ kale moihi, kale heki welehikdi kwetfoloŋ umeumet tiŋa hatiiŋ eŋ bagi heki, hidi Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","12","Mapme heki tiŋa metam hogohogok, gapman heki tiŋa talitimeŋ noli wanakaŋ hogohogok, eŋ mekuyahi tiŋa tamkuyahi, eŋ gawadahi tiŋa wapmihi, hidi hogohogok wanakaŋ Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Biyagoŋ hinek, wanakaŋ hogohogok Yahwe niutumbaneŋ! Adi’walaŋ wougigitŋiŋdi metam hogohogok wohohikgigit u yalakapmedapmaŋ tilak. Wougigit loloŋnit wondi kunum kwet yalakapmedapmaŋ tilak. ");
INSERT INTO nop_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Adi kayoŋbopŋiye wohohikgigit yenintilooŋ tubufafaŋeguk. Unduŋ doktiŋa Isilaehi, weleŋdi hinek yabukahilelak, adi niutumbaiŋ. Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Yahwe niutumbaneŋ! Kap kobuli tomineŋ. Metam nediyeŋ helemahelemaŋ adi keleiŋ, hidi niutumbadok bopneŋila niutumbaaŋ kap toyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Isilaehi metam, hidi Bepaŋdi hapmeguk wendok welemomooŋ nadineŋ. Saiyonhi metam, hidi mapmehidok nadifo tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Kap miyeeŋ wou niutumbaneŋ. Wagim eŋ tambalin tiŋa gita ulaŋa wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Yahwe adi weleŋdi hinek metamŋiye yabukahileeŋ yabunadifo tilak. Unduŋ doktiŋa metam nediyeŋ nehitok nadiune fofoŋ tilak, adi yadi wohiye yenintiloune fafaŋe hinek tiiŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Bepaŋ’walaŋ metamŋiye adi agaŋ fafaŋe hinek tiiŋ wendoktiŋa nadifo tiiŋ. Unduŋ doktiŋa hinamuni tiŋa nadifo kap toyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Adi miknoŋ maŋiŋ mikit hinek kedem beŋa kakaliŋa Bepaŋdok nadifo tineŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Unduŋ tiŋa metambop noli gut kedem mindobuŋa kisaŋ yehitubu-kadakaaŋ yehimoŋgofoneŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Unduŋ tiŋa memikhiye’walaŋ mapme heki eŋ talitimeŋhiye u tawa fafaŋehi wendi yehifolokenekilitineŋ. ");
INSERT INTO nop_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Bepaŋdi yoguk undugoŋ tiŋa mebop hatitawiiŋ u kadakaniŋhikdok kibikoŋ kwanaimiŋ yemneeŋ. Unduŋ tiŋa Bepaŋ’walaŋ metamŋiyedi kedem fafaŋe tineeŋ. Yahwe niutumbanim! ");
INSERT INTO nop_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Yahwe niutumbanim! Bepaŋ Siloŋyotneŋ niutumbanim! Kunum gineŋ saŋiniŋŋiŋ wapum hatak, indi wendoktiŋa nadifooŋ nintilonim! ");
INSERT INTO nop_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Adi kwanai wapuhi wapuhi tuguk, wendoktiŋa indi niutumbanim! Adi loloŋnit eŋ wougigitŋiŋdi lohinakaaŋ hatak. ");
INSERT INTO nop_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Bai wapuhi fedila niutumbaneŋ, eŋ gita heki ulune mede momooŋ tobune niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Tambalin ula kap miyeeŋ niutumbaneŋ, eŋ gita utneŋ eŋ bai feditneŋ, tiŋa wou nintiloneŋ. ");
INSERT INTO nop_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Muwage youlune gigilit tobune Yahwe niutumbaneŋ. Muwage u gibitaŋ youlune mede wapum tobune niutumbaneŋ. ");
INSERT INTO nop_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Nemenemek hatihatihinit hogohogok, hidi Yahwe niutumbaneŋ! Yahwe niutumbaneŋ! ");
INSERT INTO nop_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yoŋ adi mebop indiŋdi mintatalabubuyeeŋ Jesu Kilistodi Abalaham’walaŋ yalakiŋiŋ Dewit’walaaniŋ gineŋ mintaguk wendiniŋ youhebet. ");
INSERT INTO nop_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalaham adi Aisak beu. Kaŋ Aisak adi Jekop beu. Kaŋ Jekop adi Juda tiŋa kwayaŋiye’walaŋ behik. ");
INSERT INTO nop_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kaŋ Juda adi Peles dut Sala’walaŋ behik, eŋ adi mehik Tema. Kaŋ Peles adi Hesolon beu. Kaŋ Hesolon adi Lam beu. ");
INSERT INTO nop_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Kaŋ Lam adi Aminadap beu. Kaŋ Aminadap adi Nason beu. Kaŋ Nason adi Salmon beu. ");
INSERT INTO nop_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Kaŋ Salmon adi Boas beu, eŋ miŋ e Lehap. Kaŋ Boas adi Obet beu, eŋ miŋ e Lut. Kaŋ Obet adi Jesi beu. ");
INSERT INTO nop_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Kaŋ Jesi adi mapme Dewit’walaŋ beu. Kaŋ Dewit adi Solomon beu, miŋ e koom Yulaiya hemiŋguk. ");
INSERT INTO nop_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Kaŋ Solomon adi Liyaboam beu. Kaŋ Liyaboam adi Abaisa beu. Kaŋ Abaisa adi Asa beu. ");
INSERT INTO nop_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Kaŋ Asa adi Yehosafat beu. Kaŋ Yehosafat adi Yolam beu. Kaŋ Yolam adi Usaia beu. ");
INSERT INTO nop_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Kaŋ Usaia adi Yotam beu. Kaŋ Yotam adi Ahas beu. Kaŋ Ahas adi Hesekiya beu. ");
INSERT INTO nop_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kaŋ Hesekiya adi Manase beu. Kaŋ Manase adi Amon beu. Kaŋ Amon adi Josaiya beu. ");
INSERT INTO nop_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kaŋ Josaiya adi Yekonaiya hekikwayaŋit adi behik. Nai uŋaniŋ Bepaŋdi Isilaehi metam biyabune Babilonhidi widihiŋa yanagila Babilonde ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isilaehi adi kadakaniŋ tubune Bepaŋdi biyabune Babilonhi yahaŋeune uŋoŋ wooŋ hatiŋila Yekonaiya adi Siyatiyel beu hatiguk. Kaŋ Siyatiyel adi Selababel beu. ");
INSERT INTO nop_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Kaŋ Selababel adi Abiyut beu. Kaŋ Abiyut adi Eliyakim beu. Kaŋ Eliyakim adi Eso beu. ");
INSERT INTO nop_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Kaŋ Eso adi Sedok beu. Kaŋ Sedok adi Akim beu. Kaŋ Akim adi Eliyut beu. ");
INSERT INTO nop_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Kaŋ Eliyut adi Eliyesa beu. Kaŋ Eliyesa adi Matan beu. Kaŋ Matan adi Jekop beu. ");
INSERT INTO nop_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kaŋ Jekop adi Josep beu, kaŋ Josep adi Maliya yohoi. Kaŋ Maliyadi Jesu mihi nagikuk, Kilisto niiŋ. ");
INSERT INTO nop_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Unduŋ doktiŋa mebop indiŋ mintatalabugiŋ: Abalaham’walaaniŋ tububihila mintatalabubuyeeŋ Dewit mintaguk u kunakunathik 14. Kaŋ Dewit’walaaniŋ tububihila mintatalabubuyeeŋ Isilaehi yahaŋeune Babilon kwetneŋ hatigiŋ u maaŋ kunakunathik 14 iŋgoŋ. Kaŋ nai uŋaniŋ tububihila mintatalabuŋa bubuyeeŋ Kilisto mintaguk u maaŋ undugoŋ kunakunathik 14 gineŋ iŋgoŋ dapmalak. ");
INSERT INTO nop_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesu Kilisto adi talik indiŋ foloŋ mintaguk. Miŋ Maliya adi Josepdok tam gigit yofolokeneune molomolom hatilune Uŋgoniŋ Munabulidi miŋ-ikilitimimbune mihiwele ikuk. ");
INSERT INTO nop_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kaŋ Josep adi me didimeniŋ hatiguk doktiŋa undiniŋ kanadiŋa indiŋ nadisuguk, “Nu Maliya mu tubumekait, unduŋ doktiŋa yofolok hatak iŋgoŋ fiit kabup bikabit.” ");
INSERT INTO nop_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Adi unduŋ hanadisulune Wapum’walaŋ aŋelo niŋdi damo gineŋ mintamiŋa indiŋ niŋguk, “Josep, Dewit’walaŋ yalaki, du tamge Maliya nagitdok nadibedi mu tibeŋ, mihiwele woŋ adi Uŋgoniŋ Munabuli’walaŋ. ");
INSERT INTO nop_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ala mihi u mintaune wou adi Jesu yobaaŋ, adi kuyendi metamŋiye kadakaniŋ diniŋ folok gineniŋ yehifiyali yanagilaak.” ");
INSERT INTO nop_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nemenemek hogohogok mintaguk u polofet niŋdi Wapum’walaŋ maŋiŋ mede tiŋa indiŋ youkuk, wendok tuwot tagimneeŋ mintaguk, ");
INSERT INTO nop_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“I nadineŋ, tamkuya niŋ me dut nemu hatiŋa mihiwele ila mihi niŋ nagilaak kaŋ wou Imanuwel nineeŋ.” (Inde’walaŋ mede foloŋ: Bepaŋdi indut hatilak.) ");
INSERT INTO nop_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kaŋ Josep adi damo gineniŋ pilaliŋa Wapum’walaŋ aŋelodi mede niŋguk u tagimneeŋ welekubugoŋ tiŋa Maliya u ne’walaŋ tamŋiŋ unduŋ nadiune dapmaune nagila yolineŋ loguk. ");
INSERT INTO nop_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Unduŋ tiŋa tamŋiŋ dut nemu hatibune mihi u mintaguk. Kaŋ Josepdi wou Jesu youkuk. ");
INSERT INTO nop_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helotdi mapme wapum hatiguk nai uŋaniŋ Jesu adi Betelehem yopmaŋ, Judiya kwetneŋ uŋoŋ mintaguk. Kaŋ nai uŋaniŋ nadinadime bamholiŋa yabunadi tagiŋ heki adi mele labulabuneŋkade bugiŋ buŋa Jelusalem uŋoŋ busuwaaŋ indiŋ yonadigiŋ, ");
INSERT INTO nop_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Judahi’walaŋ mapme niŋ ŋakŋak mintaguk u deŋgoŋ hatak? Indi bamholiŋaŋiŋ kanadiŋa mulelem timiŋa niutumbane bam.” ");
INSERT INTO nop_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Unduŋ yobune me mapme Helot tiŋa Jelusalemhi adi u nadiŋa boho tiŋa welemulap maaŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Unduŋ tiŋa moŋ kaŋ Helotdi Siloŋyot diniŋ talitimeŋ eŋ Yodoko Mede diniŋ henale heki kutiyenimbune buŋa bopneune Kilisto yokwet deŋgoŋ mintadok yogiŋ yoŋa yeninadiguk, kaŋ indiŋ niŋgiŋ, ");
INSERT INTO nop_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Betelehem yopmaŋ, Judiya kwetneŋ, wendegoŋ polofet niŋdi indiŋ youkuk: ");
INSERT INTO nop_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betelehem yokwet, Judiya kwetneŋ, du Judiya kwet diniŋ yokwet mebi fofoŋnit mokoŋ. Du’walaaniŋ kuyeŋ talitimeŋ wapum niŋ mintaaŋ Isilaehi metamneye yabu-ulidokooŋ talitimeŋ tiŋa yanagilaak.’” ");
INSERT INTO nop_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mede unduŋ yobune nadiŋa Helotdi nadinadime kweetniŋhi bugiŋ u kabup kutiyenimbune nehi hogok buŋa bopnegiŋ kaŋ bamholiŋa nai deniŋ hinek mintaune kagiŋ wendok yeninadiguk. ");
INSERT INTO nop_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tiŋa indiŋ yeniŋa yeniŋkulune Betelehemde ugiŋ, “Hidi kedem ale uneŋ, wooŋ ŋakŋak u baigoŋ hinek lohiŋa tubumintaaŋ kaŋ buŋa nanimbune nubo wooŋ undugoŋ mulelem timiŋa niutumbait.” ");
INSERT INTO nop_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Me mapmedi unduŋ yenimbune tububihila ugiŋ. Kaŋ bamholiŋa yohikwehineŋ dibek kaŋ tububihila kelegiŋ, wendigoŋ timeŋ tiŋa yanagilune ugiŋ wooŋ yot ŋakŋak hakukneŋ uŋgoŋ kwambundaaŋ ikuk. ");
INSERT INTO nop_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kaŋ adi bamholiŋa u kaŋ welehik gineŋ nadifo tigiŋ u loloŋnit. ");
INSERT INTO nop_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Unduŋ tiŋa yot maaneŋ looŋ mihi tiŋa miŋ Maliya yabuŋa mulelem timiŋa niutumbagiŋ, tiŋa lihik dihiŋa gol tiŋa wahu munduŋ tuwaŋŋiŋ loloŋnit eŋ haguwo munduŋ momooŋ u beŋa siloŋ timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kaŋ Bepaŋdi damo gineŋ kotigoŋ Helot kakaŋ mu uneŋ yeniheune wabiŋa talik gitipmuŋ niŋ keletauyeeŋ yohite ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nadinadi me heki adi udaneeŋ ulune timiŋ uŋaniŋgoŋ Wapum’walaŋ aŋelodi damo gineŋ Josep mintamiŋa indiŋ niŋguk, “Pilali mihiyamit yanagila momoŋ Isipde uneŋ. Uŋoŋ wooŋ nutok woom hatineeŋ, ala nu yokwet u biŋa bubuŋdok yobe nadiŋa kedem biŋa buneeŋ. Nadilaŋ be? Helot adi mikmeŋiye yapmeune wooŋ mihi u lohi gigineeŋ tubumintaaŋ ulukumundok yolak.” ");
INSERT INTO nop_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Unduŋ yobune Josep adi timiŋ pilali mihiyamit yanagilune momoŋ Isipde ugiŋ, uŋoŋ wooŋ hatilune Helot kumuŋguk. ");
INSERT INTO nop_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nemek unduŋ mintaune polofet niŋdi Wapum’walaŋ maŋiŋ mede tagimneeŋ mede niŋ indiŋ yoguk u biyagoŋ mintaguk, “Mihine Isip kwetneŋ hatibune kutinimbe buguk.” ");
INSERT INTO nop_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nadinadi me mele labulabuneŋkade bugiŋ heki adi Helot talamut tiŋa uune adi mebihik kanadiŋa gibita kwihitaguk. Unduŋ tiŋa adibo mikmeŋiye yeniŋkulune wooŋ Betelehem yokwet wapumneŋ be yokwet kuyaniŋ kuyaniŋ yamaŋgoŋ ila ugiŋ indigoŋ wooŋ eyaŋ-me hogohogok gulethik lufom yalune folak u wanakaŋ widihikumuŋdapmagiŋ. Nemek u mintaguk adi mebi indiŋ: Nadinadi me bugiŋ hekidi bamholiŋa nai deniŋ hinek mintaguk u yogiŋ kaŋ nadiguk wendoktiŋa bamholiŋa mintaguk nai u kanadiŋa wapmihi gulethik lufom yalune folak u yobune widihikumuŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kaŋ nai uŋaniŋ polofet Jelemaiyadi Wapum’walaŋ maŋiŋ mede tagimneeŋ mede indiŋ yoguk u folooŋ mintaguk: ");
INSERT INTO nop_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lama yokwetneŋ uŋoŋ kutikuti niŋ mintalak, maham gigit. Leseldi mihiŋiye doktiŋa makat koyone tubune tubukulemadok kwanaimiŋ tiiŋ. Mihiŋiye-kabe hogok nemu hakiŋ, kumuŋdapmaŋ tigiŋ doktiŋa unduŋ tilak.” ");
INSERT INTO nop_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helot kumuŋguk kaŋ Wapum’walaŋ aŋelodi Josep damo gineŋ Isip uŋoŋ mintamiŋa indiŋ niŋguk, ");
INSERT INTO nop_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mihi ulukumune yogiŋ heki agaŋ kumuŋit, unduŋ doktiŋa du pilali tiulidokooŋ mihiyamit yanagila kotigoŋ Isilae kwetneŋ uneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Unduŋ yobune pilali mihiyamit yanagilune Isilaede ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Udaneeŋ ugiŋ wooŋ Josep adi mede indiŋ nadiguk: “Akelao adi beu Helot’walaŋ kwelikoŋ tuguk. Judiya kwet diniŋ mapme itak.” Unduŋ nadiŋa uŋoŋ wooŋ hatidok munta kisaŋ tuguk. Unduŋ doktiŋa Bepaŋdi damo gineŋ nindidimeune Galili kwetneŋ uguk. ");
INSERT INTO nop_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wooŋ yokwet niŋ wou Nasalet uŋoŋ yolikweli tiŋa itouguk. Kaŋ polofet heki’walaŋ mede indiŋ hatak u biyagoŋ mintaguk, “Nasaletniŋ me nineeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gulet debek agaŋ ulune nai niŋde Jon Imeyout Tububihit adi Judiya kwetneŋ uŋoŋ mintadakaleeŋ kwet fiileŋ uguk. Wooŋ hatiŋa mede indiŋ yohautaluguk, ");
INSERT INTO nop_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Uŋgoniŋdi nihitubu-dulalak doktiŋa welehik tubutakaleneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jondegoŋ Bepaŋdi polofet Aisaiya maŋiŋ gineŋ mede indiŋ yoguk, “Me niŋ kwet fiileŋ indiŋ kutilak: Wapumdok tiulidoko tineŋ, tiŋa talik figumotaaŋ iminneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon tinahukutŋiŋ adi kale kamel diniŋ dumuniŋdi tigiŋ, eŋ kiyegelepŋiŋ adi kale gitnemdi tigiŋ wendi gadiŋiŋ foloŋ youkilitiluguk. Nanaŋeŋiŋ adi gwatak dut simiŋkupuk naaŋ hatiguk. ");
INSERT INTO nop_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kaŋ Jelusalem yokwetneŋ be Judiya kwet wapum maaneŋ be Jodan ime magimagi fukuniŋ be fukuniŋ yokwet ila ugiŋ indigoŋ metam mohok tamali kanene utelegiŋ. ");
INSERT INTO nop_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tiŋa kadakaniŋhik yofiyalu Jodan ime gineŋ Imeyout tiyemguk. ");
INSERT INTO nop_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kaŋ Falisi tiŋa Sadusi heki maaŋ Imeyout tinene bugiŋ kaŋ yeniŋguk, “Hidige! Miŋgembet miknit diniŋ yalakiŋiye, hidi! Hidi Bepaŋ’walaŋ kwihita mintaune momonim be yo tiiŋ? ");
INSERT INTO nop_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kadakaniŋhik agaŋ sigilulum tiyemiiŋ habudok kwanaiŋiŋ taneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tiŋa hidegoŋ Abalaham’walaŋ yalakiŋiye mu yoneŋ. Nu biyagoŋ hinek hanilat. Bepaŋ adi kedem yobune kawade yendi yalakiŋiye mintaneŋ. ");
INSERT INTO nop_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Finaŋgondi bem kiliki momooŋgoŋ mu foiŋ u mebi fiyapmaaŋ kudup gineŋ yakutdok woom hatak. ");
INSERT INTO nop_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nu adi wele tubutakale tineŋdok ime hogok youhamulat, iŋgoŋ me niŋ mindaŋ bulak adi yadi Uŋgoniŋ Munabuli dut kudupdi youhambaak. Adi loloŋnit, nu nalakapme tilak. Tiŋa nu aindiniŋdi tipilapilaye timindok tuwot moŋ. ");
INSERT INTO nop_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Adi agaŋ yohumuŋnit buŋa nanaŋe yotŋiŋ tutumbawaak. Tiŋa nanaŋe nanaŋdok u daneeŋ yopmaŋ boiwaak eŋ figifigi u yohumuneeŋ wali wooŋ kudup gineŋ heune dawaak.” ");
INSERT INTO nop_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nai uŋaniŋ Jesu adi Galili kwetneŋniŋ Jodan ime foloŋ wooŋ Jondi Imeyout timiŋdok niŋguk. ");
INSERT INTO nop_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kaŋ Jon adi nadimalabudaaŋ indiŋ niŋguk, “Nu aindiniŋdi du ime youkambitdok tuwot moŋ. Toboniŋ du youtnambune kedem didimewek.” ");
INSERT INTO nop_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Unduŋ yobune Jesudibo niŋguk, “Nadibedi mu tibeŋ! Nu ganilat undugoŋ tibeŋ kaŋ titiŋ didimeŋ keleeŋ tidene polofet heki’walaŋ mededi yolak wendok tuwot mintawek.” Unduŋ yobune Jondi welekubugoŋ tiŋa nadimiŋguk. ");
INSERT INTO nop_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Imeyout timindapmaune nai uŋaniŋgoŋ labulabuŋale kalune kunum dilitombune Uŋgoniŋ Munabulidi butigili wele tiŋa fooŋ folooŋ foloŋ ikuk. ");
INSERT INTO nop_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kaŋ yali nadilune kunum maaneŋniŋ mede indiŋ mintaguk, “I adi na’niŋ mihine hinek, welenedi hinek kahilelat. Nu aditok nadimimbe utumba hinek tilak.” ");
INSERT INTO nop_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kaŋ Jesu nai uŋaniŋgoŋ Sadaŋdi tikamanda timimbune mebiŋiŋ dakaledok yoŋa Uŋgoniŋ Munabulidi nagilune kwet fiileŋ uguk. ");
INSERT INTO nop_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesu adi uŋoŋ wooŋ helebufa 40 nanaŋe kamehep tiŋa map hatiguk, ");
INSERT INTO nop_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","doktiŋa map hanadilune me tikamanda molom adi mintamiŋa niŋguk, “Du Bepaŋ mihiŋiŋ biyagoŋ nobu hatiliweŋ kaŋ kawade i yenimbune nanaŋe yageleneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Unduŋ nimbune Jesudi yoguk, “Yodoko Mededi indiŋ yolak, ‘Mehinek adi nanaŋedok hogok mu hatidok. Bepaŋ’walaŋ medeŋiŋ bulak tuwot nadidahiŋa hatidok.’” ");
INSERT INTO nop_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Unduŋ yobune kotigoŋ nagila Jelusalem Siloŋyot ki foloŋ logumuk. Looŋ Sadaŋdi niŋguk, ");
INSERT INTO nop_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Du Bepaŋ mihiŋiŋ biyagoŋ nobu hatiliweŋ kaŋ iŋaniŋ tatakula kwetfoloŋ foweŋ. Yodoko Mededi indiŋ yolak doktiŋa ganilat, ‘Bepaŋ adi aŋeloŋiye yapmeune buŋa gehitubu-lodaaŋ gabudokoneŋ.’ Tiŋa indiŋ maaŋ yolak, ‘Adi kohoŋgoŋ gitagoŋ ganagi fooŋ gapmeune kawadedi kayoge-kabe nemu youlek.’” ");
INSERT INTO nop_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Unduŋ yobune Jesudibo niŋguk, “Yodoko Mededi indiŋ maaŋ yolak, ‘Du Wapumge Bepaŋ tikamanda mu timimbeŋ.’” ");
INSERT INTO nop_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Unduŋ yobune Sadaŋdi kotigoŋ nagila looŋ kweboboe kweheyeniŋ foloŋ yali kwetkwet nemenemek hogohogok hatak u nimbune saŋiniŋhik kaguk, kaŋ niŋguk, ");
INSERT INTO nop_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Du mulelem tiŋa naniutumbaweŋ kaŋ kedem nemenemek hogohogok u dutok gambit.” ");
INSERT INTO nop_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Unduŋ yobune Jesudibo niŋguk, “Sadaŋ, du tabaweŋ! Yodoko Mededi indiŋ yolak, ‘Wapumge Bepaŋ hogok niutumbaaŋ mulelem timiluwaaŋ.’” ");
INSERT INTO nop_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Unduŋ nimbune Sadaŋ adi bikabuŋa uguk, kaŋ aŋelo hekidi buŋa tubulodagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jon agaŋ yot fafaŋeniŋneŋ kameune hatak, gigit unduŋ nadiŋa Jesu adi Galili kwetneŋ uguk. ");
INSERT INTO nop_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Unduŋ tiŋa Nasalet yokwet bikabuŋa wooŋ Kafanaum uŋoŋ itouguk. Yokwet u imeŋgwaŋ gagayeŋ, Sebulon eŋ Naftali kwetneŋ uŋoŋ hakuk. ");
INSERT INTO nop_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Unduŋ tubune polofet Aisaiyadi Bepaŋ’walaŋ maŋiŋ mede tagimneeŋ indiŋ yoguk u folooŋ mintaguk: ");
INSERT INTO nop_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon eŋ Naftali kwetneŋ, Galili Imeŋgwaŋ gagayeŋ tiŋa Jodan Ime magimagi, eŋ Galilihi noli Judahi’walaŋ feknit mokit uŋoŋ hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mebop u mambip gineŋ hatiiŋ adi hauta wapum kaiŋ. Eŋ mambip gineŋ itowiiŋ adi hautayembaak.” ");
INSERT INTO nop_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nai uŋaniŋ Jesudi tububihila mede indiŋ yohautaguk, “Bepaŋ’walaŋ Hatihati Uŋgoniŋdi hehitubu-dulalak doktiŋa kadakaniŋhik sigilulum tiyemaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ala heleniŋ Jesu Galili Ime magi hogok wooŋ me yadalit niŋ yabuguk, Saimon, wou noli Pita, tiŋa kwayaŋ Endulu. Adi me pisi moŋgomoŋgot yakat doktiŋa imeŋgwaŋ gineŋ umbenhik kukut hati tugumuk. Kaŋ wooŋ yehitubu-mintaaŋ yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Buŋa nu nehikeledemek kaŋ metam yahaŋedok hanindidimewit.” ");
INSERT INTO nop_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Unduŋ yenimbune nai uŋaniŋgoŋ umbenhik uŋgoŋ biyabuŋa Jesu kelegumuk. ");
INSERT INTO nop_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kaŋ kabe-muniniŋ uuyeŋ kotigoŋ meyadalit iŋgoŋ nimaaŋ yehitubu-mintaguk, Jems tiŋa kwayaŋ Jon. Adi Sebedi mihiŋiyat, ala behik dut muwagehik foloŋ hali umbenhik hati kaulidokolune yehitubu-mintaguk. ");
INSERT INTO nop_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tiŋa Jesudi me yadalit u maaŋ kutiyenimbune muwage be behik wanakaŋ uŋgoŋ biyabuŋa Jesu kelegumuk. ");
INSERT INTO nop_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kaŋ Jesu adi Galili kwetneŋ Judahi’walaŋ bopyot yaliugiŋ indigoŋ tuwot yaudapmaaŋ Hatihati Uŋgoniŋ diniŋ Mede Momooŋ yohauta kwanai tiyauguk. Tiŋa undugoŋ me yagit folofigitahinit yehitubu-kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Unduŋ tubune gigitŋiŋdi Siliya kwetneŋ hautadapmaune nadiŋa metam yagit folofigitahinit be yabaphinit be me kumuŋkaika tagiŋ be me kayohik kohohik kumuhi yanagila adi’walaŋkade uune yehitubu-kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Unduŋ tubune Galili kwetneŋhi be yokwet 10 ila ugiŋ uŋahi be Jelusalem yokwetneŋhi be Judiya kwetneŋhi be Jodan fukuniŋ be fukuniŋ metam fee hinekdi bopneeŋ Jesu kelegiŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesudi metam fee hinek yabuŋa kweboboe foloŋ looŋ ilune mihiŋiye buŋa hebeŋneŋ ikiŋ ");
INSERT INTO nop_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kaŋ Mede Momooŋ indiŋ yeniŋa yenindidimeguk. ");
INSERT INTO nop_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Me nehitok nadiune welehik gineŋ fiyewakahi tilak adi yadi Bepaŋdi kahaŋ tiyemulak. Hatihati Uŋgoniŋ kunum gineŋ hatak u metam undihidok gigit tilak. Wendoktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Me welehikdi makat kobulabulaye tiiŋ adi yadi Bepaŋdi kahaŋ tiyemiŋa welehik tubukulemawaak. Wendoktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Me nehitok nadiune fofoŋnit tubune Bepaŋ hebeŋ foloŋ kulemaŋgoŋ hatiiŋ, adi Bepaŋdi kahaŋ tiyembune kwet wapum i aditok gigit tilak. Wendoktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Me nediyeŋ Bepaŋ hebeŋ foloŋ metam didimehi mintaaŋ hatidok nanaŋe imedok map tiyam dabugoŋ tiiŋ, adi Bepaŋdi kahaŋ tiyemiŋa tuwot hinek yemtokiwaak. Wendoktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Me nediyeŋ menohiyedok welekulema tiyemiiŋ adi Bepaŋdi kahaŋ tiyemiŋa welekulema tiyembaak. Unduŋ doktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Me welehik walaniŋ adi Bepaŋdi kahaŋ tiyembune Bepaŋ kaneeŋ. Wendoktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Me kulemadok kwanai tiiŋ adi Bepaŋdi kahaŋ tiyemiŋa wapmihiŋiye yenimbaak. Wendoktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Me Bepaŋ’walaŋ nadinadi keleeŋ kwanai tubune me nolidi folofigita yemiiŋ adi Bepaŋdi kahaŋ tiyemiŋa ne’niŋ Hatihatiŋiŋ Uŋgoniŋ u aditok yembaak. Wendoktiŋa aditok adi nadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Hidi nu nehikeleune me nolidi mede kadakaniŋ haniŋa fidihiŋa yalaŋ mede hanineeŋ wendok nadibedi mu tineeŋ. Bepaŋdi kahaŋ tihambaak doktiŋa habunadiwene utumba tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tiŋa kougoŋ kunum foloŋ nemek tuwaŋiŋ loloŋnit moŋgotneeŋ wendok nadifo tineŋ. Koom Bepaŋ’walaŋ polofet hatigiŋ adi maaŋ undugoŋ tiyemgiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Hidi adi metam diniŋ feleŋ. Iŋgoŋ feleŋdi kadakaaŋ koba mokit tubune nemek nemu tibetiŋaŋ. Unduŋ doktiŋa talipmeŋ kwehekulune metamdi uŋgoŋ yaliŋa woŋambuŋat tinetiŋit. ");
INSERT INTO nop_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Tiŋa undugoŋ hidi adi metam’walaŋ hauta. Yokwet niŋ binek kweboboe foloŋ itak adi hebihat tuwot mu tilak. ");
INSERT INTO nop_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tiŋa undugoŋ hidi kamaŋ galiŋa kufula mu tiiŋ, tobo galiŋa tiŋa foloniŋgoŋ kameune itak, ila metam yot maaneŋ deipilat tiiŋ u hauta yemilak. ");
INSERT INTO nop_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wendok tuwot hidi’walaŋ hautadi metam yehitubu-hautaluwaak. Kaŋ adi hidi titiŋhik kedem u kaŋ nadiu utumbaune Behik kunum gineŋ hatilak u niutumbayaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Hidi tiyaugene nu Yodoko Mede tiŋa polofet heki’walaŋ mede yotubufit tibene fogut mu yoyaneeŋ. Nu adi toboniŋ tagimnewene folooŋ mintadok fogut. ");
INSERT INTO nop_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nu biyagoŋ hinek hanimbit, kunumkwetdi haliulune Yodoko Mededi undugoŋ haliwaak. Tiŋa undugoŋ Yodoko Mede faki-kabe nemu filaak be diki-kabe nemu bikabuneeŋ, mokoŋ. Yodoko Mede adi undugoŋ hali uune nemenemek mintadok yoŋit wendi folooŋ mintadapmawaak. ");
INSERT INTO nop_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Unduŋ doktiŋa nebek niŋdi Yodoko Mede faki-kabe niŋ yotubufila noliŋiye maaŋ undugoŋ titiŋdok yenindidimewaak adi Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Uŋgoniŋ gineŋ me wounit mokit hatibaak. Eŋ nebek niŋdi tagimneeŋ noli maaŋ undugoŋ titiŋdok yeniŋgigine tibaak adi Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Uŋgoniŋ gineŋ me loloŋnit hatibaak. ");
INSERT INTO nop_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Unduŋ doktiŋa hanimbene nadineŋ. Hidi Yodoko Mede henale eŋ Falisi heki’walaŋ titiŋhik u kalakapme tiŋa titiŋ fofooŋ tineeŋ wendok Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ kahileneeŋ, eŋ unduŋ mu tineeŋ adi Hatihati Uŋgoniŋ tuwot mu kahileneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Hidi mamahi-papahiyedok mede indiŋ yeniŋgiŋ u agaŋ nadiiŋ, ‘Du me widihikumuŋ mu tuluwaaŋ. Nebek niŋdi unduŋ tubune kaŋ nagila mede gineŋ kameŋdok.’ ");
INSERT INTO nop_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Iŋgoŋ oŋ, nu adi indiŋ hanilat, nebek niŋdi me noliŋiŋdok nadikwihita tilak adi mededok gigit. Be me niŋ noliŋiŋ nimpekit be nisuwambat tilak adi talitimeŋ bopdok gigit. Eŋ me niŋdi noliŋiŋdok me kauleŋ nimbaak woŋ adi me u kudupdok gigit. ");
INSERT INTO nop_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Unduŋ doktiŋa du bomboŋ siloŋ titiŋdok u alta foloŋ boidok binek tiŋa me noke dut lekiŋgoŋhik foloŋ nadikadaka hatak, ");
INSERT INTO nop_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","u nadiŋa siloŋdok bomboŋ alta tubudulaaŋ boiŋa wooŋ me noke dut mede tubudidimeluwaaŋ. Tubudidimedapmaaŋ buŋa mindaŋkade kedem siloŋdok bomboŋ u alta foloŋ boiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tiŋa undugoŋ nebek niŋdi mede gineŋ gapmewene ganagila uune hide hogok talipmeŋ uŋila mede yotubudidime tidemeek. Eŋ moŋ adi ganagila me mede yodapmandapmaŋ’walaŋ uune adibo ganindapmaune me kumondulum heki’walaŋ kohohik foloŋ gapmeune kumondulum hekidi ganagila yot fafaŋeniŋneŋ gapmeneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nu biyagoŋ hinek ganilat, du uŋoŋ hatiŋa hogok mu fooŋ baaŋ, me noke’walaŋ kibikoŋ wobudapmahinakaaŋ kedem fooŋ baaŋ.” ");
INSERT INTO nop_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mamahi-papahiyedok mede indiŋ yeniŋgiŋ, ‘Memalam hidi kikabi mu tidemeek.’ ");
INSERT INTO nop_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nu adi indiŋ hanilat, Me niŋdi tam niŋ kanadigalika tilak adi ne’walaŋ tamŋiŋ agaŋ weleŋdi bikabuŋak yodok. ");
INSERT INTO nop_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Unduŋ doktiŋa dauge didimeniŋdi kadakaniŋ gineŋ ganagilune kaŋ kidila tikukut tiluwaaŋ. Dauge lufomnikoŋ kunilit boihatigene kudupdok gigit tibaaneŋ, doktiŋa dauge fukuniŋ kedem kiditdok. ");
INSERT INTO nop_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Be kohoge didimeŋdi kadakaniŋ tubune kaŋ kohoge u fidokooŋ tukukut tiluwaaŋ. Folooge kunilit boihatigene kudup gineŋ fowaaŋneŋ doktiŋa kohoge fukuniŋ fidoko tukula hatiluwaaŋ.” ");
INSERT INTO nop_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mede komi indiŋ maaŋ hatak, ‘Me nediyeŋ tamŋiŋ bikabe nadiŋa tam u kudi youla miŋa kelekutuwaak.’ ");
INSERT INTO nop_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iŋgoŋ nu adi indiŋ hanilat, nebek niŋdi tamŋiŋ kefifile nemu tubune hogok kelekufit tibaak, adi yadi tam u malabumuŋ wapum hekimimfit tibaak. Unduŋ tubune hatigene tam u me gitipmuŋ niŋ tibaak woŋ adi tam u hekimalam hatihati diniŋ yodoko u lahula kefifile tilak tibaak. Kaaŋ me niŋ adi tam agaŋ yohoidi kelekut tuguk u nagilaak, me woŋ adi hekimalam hatihati diniŋ yodoko u lahula kefifile tilak tibaak.” ");
INSERT INTO nop_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mamahi-papahiye mede niŋ indiŋ yeniŋgiŋ, ‘Du mede yalaŋ yofafaŋedok Bepaŋ dawi foloŋ mu yoluwaaŋ.’ Be ‘du nemek u biyagoŋ nobu tibene yofafaŋeeŋ kaŋ Wapum namanda foloŋ tubune dapmaluwaak.’ ");
INSERT INTO nop_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iŋgoŋ nu adi indiŋ hanilat, Bepaŋ dawi foloŋ mede yofafaŋe u wabidapmaŋ tineeŋ. Tiŋa undugoŋ kunum gineŋkade kohodidim tiŋa mede yofafaŋe titiŋ u maaŋ wabi iŋgoŋ tineeŋ, maŋgoŋde kunum woŋ adi Bepaŋ’walaŋ kumopopŋiŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Be kwet honeeŋ mede yofafaŋe maaŋ mu taneeŋ, maŋgoŋde kwet woŋ adi Bepaŋdi kayoŋ uŋgoŋ kameeŋ ikula tilak. Be Jelusalem yokwet wou yoŋa mede yofafaŋe mu taneeŋ, maŋgoŋde woŋ adi Mapme Wapum’walaŋ yokwet. ");
INSERT INTO nop_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tiŋa undugoŋ kihik foloŋ uŋoŋ kamekaaŋ mede yofafaŋe mu titiŋdok, maŋgoŋde hidi yobune kihik hapmuŋ faufaudi gouyeniŋ tuwot mu mintawek, be gouyeniŋdi fafau tuwot mu mintawek. ");
INSERT INTO nop_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Unduŋ doktiŋa mede biyagoŋ yoŋa kaŋ agaŋ biyagoŋ hogok yoyaneeŋ, eŋ yalaŋ yoŋa kaŋ yalaŋ didimeŋgoŋ yoyaneeŋ. Eŋ mede mindaŋ tomboyoula yoiŋ woŋ adi yalaŋ-me’walaaniŋ bulak.” ");
INSERT INTO nop_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mede niŋ indiŋ yogiŋ u agaŋ nadigiŋ, ‘Nebek niŋdi dauge yousupmakaune kaŋ kibi maaŋ dawi yousupmaka timiluwaaŋ, be nebek niŋdi mage kitili yougoloune kaŋ kibi maaŋ maŋiŋ kitili yougolomiluwaaŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iŋgoŋ nu adi indiŋ hanilat, Me nolidi nemek niŋ tihambune kaŋ kibikoŋ mu tubu-udaneyaneeŋ. Unduŋ doktiŋa nebek niŋdi fauge foloŋ ulune kaŋ fambekeneeŋ kotigoŋ fauge fukuniŋ maaŋ mimbune utuwaak. ");
INSERT INTO nop_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Be nebek niŋdi mede gineŋ gapmeeŋ dahidahi wahiniŋ mimiŋdok yobune kaŋ dahidahi noli kainiŋ tuluwaaŋ u maaŋ miluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Be nebek niŋdi adut talik muniniŋ uuŋdok ganimbune kaŋ du tomboyoula kabe-kweheyeniŋgoŋ uluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Be nebek niŋdi nemek niŋdok ganinadiune kaŋ miluwaaŋ, tiŋa nemek du’walaŋ muniniŋ behatidok yobune kamehep mu timiluwaaŋ.” ");
INSERT INTO nop_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mede niŋ indiŋ yogiŋ u agaŋ nadigiŋ, ‘Me nokeye not tiyemiŋa memikgeye memik tiyemiluwaaŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Iŋgoŋ nu adi indiŋ hanilat. Memikhiye yabukahileeŋ menot tiyemaneeŋ eŋ me kadakaniŋ tihamiiŋ hekidok Bepaŋ ninadiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Unduŋ tiŋa Behik kunum gineŋ hatilak adi’walaŋ wapmihi folooŋ hinek mintaaŋ hatineeŋ. Adi kuyendi yobune meleŋiŋdi me hogohi be fofohidok wanakaŋ labu hautalak, tiŋa undugoŋ yobune me didimehi be me kadakaniŋ titiŋ hekidok gwi utak. ");
INSERT INTO nop_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hidi metam kibi momooŋ tihamiiŋ aditok hogok kibibo momooŋ nobu tiyemineeŋ adi wendok tuwaŋiŋ deti moŋgotneeŋ? Unduŋ adi me takis moŋgomoŋgot heki adi undugoŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Be hidi menohiye hogok nobu yeniutumbaiŋ woŋ adi hidi me biyagoŋ mu hatiiŋ. Me Bepaŋ mu nadisukilitimiiŋ adi undugoŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Unduŋ doktiŋa hidi adi Behik kunum gineŋ didimeniŋ hatilak undugoŋ hidi maaŋ didimeŋ hatiyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Hidige! Titiŋ fofooŋhik u metamdi haniutumbadok yoŋa metam dauhineŋ mu taneeŋ. Unduŋ tineeŋ adi Behik kunum gineŋ hatilakdi wendok tuwaŋiŋ nemu hambaak. ");
INSERT INTO nop_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Unduneŋ doktiŋa hidi fiyewakahidok nemek momooŋ tiyemne kaŋ kutihauta tiŋa mu yemaneeŋ. Yalaŋ-me heki adi metamdi yeniutumbaneŋ yoŋa bopyotneŋ eŋ yowawali foloŋ siloŋ kwanai tiiŋ. Wendok indiŋ hanimbe nadineŋ, adi tuwahik agaŋ uŋakoŋ moŋgolu dapmalak. ");
INSERT INTO nop_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Unduŋ doktiŋa du siloŋ tibene kaŋ metamdi mu nadiune da hogok kabup tuluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kaŋ titiŋge fofooŋ wendi kabup hatuwaak. Kaŋ Baha nemek kabup kanadi tilakdi wendok kibikoŋ tuwaŋiŋ gambaak.” ");
INSERT INTO nop_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Hidi ninadi kwanai tinene kaŋ yalaŋ-me hekidi tiiŋ unduŋ mu taneeŋ. Adi yadi metamdi yabune uŋgoniŋ titiŋdok yoŋa bopyotneŋ eŋ yowawali foloŋ ninadi kwanai tiiŋ. Nu biyagoŋ hinek hanilat, metamdi yabunadiune uŋgoniŋ tilak kaŋ tuwaŋiŋ agaŋ uŋakoŋ moŋgolune dapmalak. ");
INSERT INTO nop_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Unduneŋ doktiŋa hidi ninadi tinene kaŋ yohik maaneŋ fooŋ yeme youkilitiŋa Behik kabup hatilak dut yonadi taneeŋ. Kaŋ Behik nemek kabup kanadi tilakdi folooŋ tubumintahamuluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hidi ninadi tine kaŋ mede folooŋbo kilikibo mu yoyaneeŋ. Unduŋ adi me nadisukilitihinit mokitdi tiiŋ. Adi yadi unduŋ ninene yonadinik nadinimbek yoŋa undugoŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Unduŋ doktiŋa hidi yadi, adi tiiŋ unduŋ mu taneeŋ. Behik adi mu ninadilune maŋgoŋdok baniŋ tiiŋ u agaŋ kaŋ nadilak. ");
INSERT INTO nop_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Unduŋ doktiŋa hidi yadi indiŋ ninadiyaneeŋ: Kunum Betnik, du’walaŋ woho uŋgoniŋ hinek u ganintiloloŋ tinene hatuwaak. ");
INSERT INTO nop_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Unduŋ doktiŋa du buŋa welenik tuwot be kwet tuwot Wapumnik tinimbeŋ. Kunum foloŋ du’walaŋ mede tiloloŋ hatak undugoŋ kwetfoloŋ indi’walaŋ maaŋ mintawek. ");
INSERT INTO nop_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Du kamiŋ nanaŋe tuwolitnik nimbeŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Indi me noli’walaŋ kadakaniŋ dikihik biyemne nibuŋa dubo indi’walaŋ kadakaniŋnik tumolokutnimiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tikamanda gineŋ mu nipmeweŋ. Adi toboniŋ kadakaniŋ gineniŋ nihikibidaleŋ. Du me mapme folooŋ hinekdi saŋiniŋ eŋ hauta molom hatiguŋdi hatiluwaaŋ fafaŋeniŋ.” ");
INSERT INTO nop_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Hidi me noli’walaŋ yomhik biyembune Behik kunum gineŋ hatilakdi undugoŋ hidi’walaŋ yomhik bihamuluwaak. ");
INSERT INTO nop_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Eŋ hidi me noli’walaŋ yomhik uŋgoŋ kameeŋ hatibune habuŋa Behikdi undugoŋ hidi’walaŋ yomhik uŋgoŋ kamehambune hahamuluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Tiŋa hidi nanaŋe kamehep tiŋa kaŋ me nadisukiliti yalayalaŋ tiiŋ heki dabugoŋ bulaniŋgoŋ namandap mu diweyaneeŋ. Adi yadi metam nolidi nanaŋe kamehep tiŋit yabunadineŋ yoŋa undugoŋ diweeŋ yawiiŋ. Indiŋ hanimbe nadineŋ, me undihi adi koti tuwahik nemu beneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hidi nanaŋe kamehekaaŋ mutam namandap, imehik gomuŋa, silim youla yawaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Unduŋ tubune metamdi nanaŋe kameheŋa hatiiŋ u tuwot mu habukiyondayaneeŋ. Behik kabup hatilakdi hogok habuŋa nadiluwaak. Tiŋa nemenemek kabup kanadilakdi kedem tuwaŋiŋ hamuluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Hidi kwet diniŋ muneeŋ bomboŋ mu hati tiyoukaneeŋ. Woŋ adi dindilaki hekidi sitomsitom tihamuneeŋ be kubome hekidi kubonehamuneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Unduŋ doktiŋa kunum diniŋ bomboŋ tiyoulaŋa kunum gineŋ boiune ihamuneeŋ. Unduŋ tineeŋ kaŋ bomboŋ kunum gineŋ ihamuneeŋ u dindilaki hekidi sitomsitom mu tineeŋ, be kubome hekidi tuwot mu kubonehamuneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kaŋ welehik be nadisuhik adi bomboŋhik itneneŋ uŋgoŋ hatuwaak.” ");
INSERT INTO nop_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Dauhik adi foloohik diniŋ hauta, ala dauhikdi kedem halune foloohikdi hauta gineŋ hatibetik, ");
INSERT INTO nop_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","eŋ dauhikdi sipmakaune foloohik adi mambipnit hatibetik. Eŋ welehik’walaŋ dauhik u sipmakaune mambip kisaŋ tihambune youtidiwe tihatineeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Me niŋ adi bomboŋgi lufomdok kwanai tuwot mu tibek. Adi nolidok nadigalika timiŋa noli nadilakata timimbek, tiŋa noli gut wooŋ galiŋa noli sigilulum timimbetik. Unduŋ doktiŋa hidi Bepaŋ’walaŋ kwanai maaŋ eŋ muneeŋ bomboŋ kwanai maaŋ adi tuwot mu kiulaŋa taneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Unduŋ doktiŋa indiŋ hanimbe nadineŋ: Hidi nanaŋe ime nakilitiŋa hatidok be foloohik tinahukut timindok wendok nadibedi mu taneeŋ. Hatihatidi nemek folooŋ tilak, be nanaŋedi nemek folooŋ tilak? Foloohikdi nemek folooŋ tilak, be tinahukuthikdi nemek folooŋ tilak? ");
INSERT INTO nop_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bagi heki u yabuneŋ, adi nanaŋe diniyeti nemu tiiŋ, eŋ nanaŋe tiyout mu tiiŋ, adi yadi Kunum Betnikdi nanaŋe yemtoi tubune naaŋ hatiiŋ. Hidi yadi undihi moŋ. Hiditok adi nadihambune loloŋnit hinek tubune momooŋ hinek tihamulak. ");
INSERT INTO nop_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Hidi nadibedi tiŋa hatihatihik diki kedembe tomboyoutneŋ? ");
INSERT INTO nop_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Unduŋ doktiŋa hidi tinahukutdok maŋgoŋde nadibedi tiiŋ? Wowoŋ gimiŋ behepneŋ ikiiŋ u yabuneŋ, adi dinina kwanai be tinahukut kaliŋ mu tiiŋ, ");
INSERT INTO nop_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","iŋgoŋ adi Mapme Solomon’walaŋ tinahukut fofooŋ hinek tuluguk u kalakapmeŋ hinek tiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wowoŋ gimiŋ kobuk mintaaŋ haloŋ mele diweune daaŋ sigeneeŋ golopmaŋ tiiŋ adi Bepaŋdi tinahukut fofooŋ unduŋ tiyemulak. Undugoŋ hinek hidi maaŋ momooŋ hinek tihamuluwaak. U kaŋ hidi deti nadisukiliti gilaŋgilaŋ tiiŋ? ");
INSERT INTO nop_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Unduŋ doktiŋa helemahelemaŋ maŋgoŋ nanim be maŋgoŋ tinahukutnim yoŋa welemulap mu taneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Unduŋ adi metam Bepaŋ mu nadisukilitimiiŋdi wondegoŋ nadibedi hinek tiiŋ, iŋgoŋ hidi adi Behikdi nemekdok nadiiŋ u agaŋ nadilak. ");
INSERT INTO nop_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Unduŋ doktiŋa hidi yadi timentimeŋ Bepaŋ’walaŋ Hatihati Kobuli eŋ adi’walaŋ titiŋ didimeniŋdok gigine tiŋa lohiyaneeŋ kaŋ nemek noli hogohogok woŋ adi kedem hamuluwaak. ");
INSERT INTO nop_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Unduŋ doktiŋa hidi nai haloŋ wendok nadibedi mu taneeŋ, haloŋ diniŋ malabumuŋ woŋ adi nai wendiniŋ nemek. Mele nai indigoŋ malabumuŋhik woŋ adi nai molomolom mintalak.” ");
INSERT INTO nop_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Hidi me noli’walaŋ titiŋhik kanadiŋa yenimpekit mu taneeŋ. Unduŋ tubune Bepaŋdi hide maaŋ undugoŋ tihamuluwaak. ");
INSERT INTO nop_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bepaŋ adi mebihik nadidapmalak doktiŋa hidi me noli tali dediŋ gineŋ yenimpekit taneeŋ wondok tuwot kibibo Bepaŋdi mede gineŋ hapmeluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Du maŋgoŋde noke dawi gineŋ figifigi kaŋ da’walaŋ dauge gineŋ kwet muŋ wapum fooŋ ihelak u mu kadakalelaŋ? ");
INSERT INTO nop_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kwet muŋ wapum dauge gineŋ iheune noke indiŋ deti nimbeŋ: ‘Notne, nadiune figifigi dauge gineŋ ihelak u kelepenekulit.’ ");
INSERT INTO nop_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yalaŋ-me du. Da’walaŋ dauge gineŋ kwet muŋ itak u timeŋ kelepenetukula diwedakaleeŋ kedem noke’walaŋ dawi gineŋ figifigi u kelepenekulimimbeŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Hidi weleŋdok nemek momohi u kamodok mu yemaneeŋ, be nemek momohi u makayedok mu yakuyemaneeŋ. Adi yadi nemek undihi hogok kayohikdi yehiyaliŋa udaneeŋ hide iŋakoŋ hehisineeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Jesudi mede unduŋ yoŋa indiŋ tomboyoula yeniŋguk, “Yonadi tiiŋ adi folooŋ moŋgokiiŋ doktiŋa hidi gigine tiŋa yonadiyaneeŋ. Lohi tiiŋ adi folooŋ tubumintaiŋ doktiŋa gigine tiŋa lohiyaneeŋ. Yeme foloŋ youtnadiiŋ adi yeme dilitomyemulak doktiŋa gigine tiŋa yeme youtnadiyaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nebek me wapmihihinit hidi mihihikdi nanaŋedok hanimbune kawade kedembe mineŋ? ");
INSERT INTO nop_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Be pisidok hanimbune miŋgembet kedembe mineŋ? ");
INSERT INTO nop_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hidi kadakaniŋ titiŋdi wapmihihiye nanaŋe fofohi yemiiŋ iŋgoŋ Kunum Behik adi halakapme-dapmalakdi nemek wendok be wendok ninadi tubune kedem hamuluwaak. ");
INSERT INTO nop_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Unduŋ doktiŋa hidi metam nolidi titiŋ dediniŋ tihamdok nadiiŋ, undugoŋ hinek hidi maaŋ aditok tiyemaneeŋ. Mede yendi Yodoko Mede tiŋa polofet heki’walaŋ mede yehikiudapmaŋ tilak.” ");
INSERT INTO nop_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Hidi taliyeme gidaneŋ foneeŋ, taliyeme hamaŋ tiŋa talik wapum woŋ adi kudup fafaŋeŋ dalakneŋkade ulak, kaŋ meeniŋ feedi utalik wiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kaŋ yeme gidaŋ tiŋa talik kuyaniŋ u kwet fofooŋneŋkade ulak, kaŋ meeniŋ lufomgoŋdi utalik wiiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Polofet yalayalaŋ heki gineŋ ala nadiŋa hatiyaneeŋ. Adi sigihineŋ adi dompa namandap yageleeŋ biiŋ, iŋgoŋ welehik maaneŋ adi kamo moihi. ");
INSERT INTO nop_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Unduŋ doktiŋa hidi hide uŋgoŋ kikadoko momooŋgoŋ hinek tiŋa hatiyaneeŋ. Me undihi adi nehi’walaŋ titiŋhikdi yobihilune kedem yabukiyondayaneeŋ. Hidi bim u ŋaso foloŋ mu yedeyapmaiŋ, be kopi u haut foloŋ mu tomiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bem fofohi foloŋ mindipmuŋ fofohi mintaiŋ eŋ bem hogohi foloŋ mindipmuŋ hogohi mintaiŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bem fofohi foloŋ mindipmuŋ hogoli tuwot mu mintawetik, be bem hogohi foloŋ mindipmuŋ fofohi tuwot mu mintawetik. ");
INSERT INTO nop_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Unduŋ doktiŋa bem mindipmuŋ momooŋ mu tubumintaiŋ u fiyapmaaŋ kudup kula heiŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Unduŋ doktiŋa hidi polofet yalayalaŋ u nehi’walaŋ titiŋhik gineŋ uŋgoŋ kedem yabukiyondayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Wapumne, wapumne naniiŋ, hidi hogohogok wanakaŋ kunum gineŋ mu udapmaneeŋ. Me nediyeŋ Batne kunum gineŋ hatilak adi’walaŋ maŋiŋ mede tagimnewaak adi hogokdi kunumkwet kahilewaak. ");
INSERT INTO nop_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Metam yehidanedok nai wapum foloŋ metam feedi indiŋ nanineeŋ, ‘Wapumnik! indi du wohoge gineŋ Mede Momooŋ yohautagumun, tiŋa undugoŋ du wohoge gineŋ yabap yeniŋkukumun eŋ du wohoge gineŋ kudi wapuhi wapuhi uŋgoniŋ hinek tugumun!’ ");
INSERT INTO nop_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iŋgoŋ nai uŋaniŋ indiŋ yenimbaat, ‘Nu hidi mu nadihamulat. Me kadakaniŋ titiŋ heki hidi tabaut!’” ");
INSERT INTO nop_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Me nediyeŋ medene i nadiŋa takaliwaak, adi yadi me nadinadinit niŋdi yot kawade foloŋ maguk undiniŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","U maune yatune gwi sububa wapum tiŋa ime gabuŋ tuguk iŋgoŋ mu mandafaiguk, maŋgoŋde adi kawade foloniŋ maguk doktiŋa fafaŋeŋ yakuk. ");
INSERT INTO nop_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Eŋ me nediyeŋ medene i nadikabeleeŋ mu takaliwaak, adi yadi me bubuyeŋ niŋdi yoli ime gagayeŋ kiŋ foloŋ maguk undiniŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","U maune yatune gwi sububa wapum eŋ ime gabuŋ wapum saŋiniŋnit wendi buŋa tubumandafaiune maaŋ golomunumunuŋe tuguk.” ");
INSERT INTO nop_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu adi mede unduŋ yodapmaune metam bop wapum ikiŋ adi mede u nadiŋa boho tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Adi Yodoko Mede henale heki yalakapme hinek tiŋa mede molomdi fuluŋgoŋ hinek yoguk doktiŋa metamdi nadiune uŋgoniŋ hinek tuguk. ");
INSERT INTO nop_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu kweboboe bikabuŋa foune metam feedi bopneeŋ keletaugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kaŋ me niŋ wede hakinit adi wooŋ Jesu hebeŋ foloŋ mulelem timiŋa tubulodadok yoŋa indiŋ niŋguk, “Da nadilaŋ, nehitubu-lodawe kaŋ kedem nehitubu-kedebaweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Unduŋ yobune Jesudi kaŋ kohoŋ kihiwali honeeŋ niŋguk, “Kedem nadigamulat ale walandaweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Unduŋ nimbune nai uŋaniŋgoŋ folooŋ walandaguk kaŋ indiŋ niheguk, “Metam mu yenimbihileŋ. Siloŋyot diniŋ talitimeŋ’walaŋ didimeŋgoŋ weŋ kaŋ gabunadiwek. Kaŋ metamdi gabuŋa agaŋ kedebaŋaŋ unduŋ gabunadineŋdok weŋ, wooŋ koom Mosesdi yoguk unduŋ Bepaŋdok kale dumuŋ hemundumunduŋe timimbeŋ. Kaŋ nemek mintaŋak u kedem kaŋ nadineŋ.” ");
INSERT INTO nop_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesu adi Kafanaum yokwet maaneŋ folune mikme’walaŋ talitimeŋ niŋ adi buŋa Jesu indiŋ ninadiguk, ");
INSERT INTO nop_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Wapum, tipilapilaye-mene yagit malabumuŋ tiŋa folooŋ sumbandaune waliwali mu tiŋa folofigita kisaŋ hanadilak.” ");
INSERT INTO nop_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Unduŋ nimbune Jesudi yoguk, “Nu kedem wooŋ tubukedebait.” ");
INSERT INTO nop_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Unduŋ yobune mikme heki’walaŋ talitimeŋdi indiŋ tubu-udaneguk, “Wapum, nu me loloŋnit bale nu yotneneŋ weŋ. Kedem ale iŋgoŋ yali mede hogok yobeŋ kaŋ tipilapilaye-mene kedem kedebawek. ");
INSERT INTO nop_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nu na maaŋ me wapum diniŋ falipmeŋ hatilatdi mikme uneŋ yenimbe wiiŋ, be buneŋ yenimbe biiŋ, be tipilapilaye-meneye nemek u tineŋ yenimbene tiiŋ doktiŋa ganilat.” ");
INSERT INTO nop_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Unduŋ yobune Jesudi mede u nadiŋa boho tiŋa metam keletaugiŋ indiŋ yeniŋguk, “Nu biyagoŋ hinek hanilat. Nu Isilaehi hidi’walaaniŋ nadisukiliti indiniŋ nemu kagut. Unduŋ doktiŋa indiŋ hanilat. ");
INSERT INTO nop_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Metam fee kwetkwet mele labulabuneŋkade be mele fofoŋneŋkade buŋa bopneeŋ Abalaham, Aisak eŋ Jekop heki dut Bepaŋ’walaŋ Hatihati Kobuli gineŋ noŋgoŋ ila hinamuni tineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kaŋ metam koom netok yoŋa yabukahileguk iŋgoŋ mu nadisukilitimiiŋ adi yadi yeniŋkulune fakaŋ fooŋ mambip gineŋ hatiŋa kobulabulaye tiŋa masiŋkilip toyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Unduŋ yenindapmaaŋ mikme diniŋ talitimeŋ u indiŋ niŋguk, “Kedem ale weŋ, nadisukilitigedi nemek mintawek nadiŋaŋ undugoŋ hinek mintagambek.” Jesudi unduŋ nilune nai uŋaniŋgoŋ hinek tipilapilaye-meŋiŋ kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kaŋ Jesu adi Pita yolineŋ looŋ kalune Pita yapmaŋ tam adi yagit tiŋa folooŋ kudup daune deihakuk. ");
INSERT INTO nop_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Undiniŋ kaŋ kohoŋ foloŋ honeune kedebaguk. Tam u kedebaaŋ pilali Jesudok nanaŋe tiulidokomiŋguk. ");
INSERT INTO nop_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mele fohebilune metam yabaphinit fee yanagila bugiŋ, kaŋ Jesudi mede gineŋ hogok yeniŋkulune yabap heki meeniŋ biyabuŋa fooŋ bu utelegiŋ, eŋ metam noli yagit folofigitahinit u maaŋ yohoneeŋ yehitubu-kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Unduŋ tubune Polofet Aisaiyadi Bepaŋ’walaŋ maŋiŋ mede tagimneeŋ indiŋ yoguk u folooŋ mintaguk: “Negoŋ yagit folofigitanik bekudapmaguk.” ");
INSERT INTO nop_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Metam mohok feedi buŋa Jesu kelemadiune yabuŋa mihiŋiyedi muwage neeŋ tiŋa buune ime fokolok loloŋdok yeniŋguk. ");
INSERT INTO nop_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kaŋ uuŋdok yatulune Yodoko Mede henale niŋdi Jesu hebeŋ foloŋ wooŋ niŋguk, “Henale, nu du dambedambek waaŋ kaŋ wondok tuwot gehikeleyawaat.” ");
INSERT INTO nop_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Unduŋ yobune Jesudibo niŋguk, “Kamo moiŋ heki adi kawade ginaneŋ ikiiŋ eŋ bagi heki adi yohineŋ ikiiŋ, iŋgoŋ Me Kobumuŋ adi hakula titiŋdok kweli nemoŋ.” ");
INSERT INTO nop_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kaŋ mihiŋiye’walaaniŋneŋ niŋdi niŋguk, “Wapum, nadiune timeŋ wooŋ batne wenefulaŋa bit.” ");
INSERT INTO nop_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yobune Jesudi indiŋ niŋguk, “Dabaŋ u biune dabahi noliyedi wenefulaneŋ, du yadi buŋa nu nehikeleweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Unduŋ yoŋa muwage foloŋ loune mihiŋiye maaŋ noŋgoŋ looŋ ila ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ulune fifiŋgobut wapum tubune ime giyondaaŋ buŋa muwagehik gineŋ foguk. Kaŋ Jesu adi damo hadeikuk. ");
INSERT INTO nop_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ala mihiŋiyedi Jesu talamsukuleeŋ indiŋ niŋgiŋ, “Wapum, indi agaŋ ime gineŋ wopmabutne tam ale pilap nihitubu-lodaluweŋ!” ");
INSERT INTO nop_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nimbune sukuleeŋ yeniŋguk, “Munta maŋgoŋde tiiŋ. Hidi nadisukilitihik maŋgoŋde gilaŋgilaŋ tilak?” Unduŋ yeniŋa pilali yali sububa dut ime yenintoŋa yeniheune gitagoŋ kulemaaŋ hakumuk. ");
INSERT INTO nop_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kaŋ mihiŋiye adi u kaŋ boho tiŋa indiŋ yogiŋ, “Me i dediniŋgoŋ doktiŋa sububa dut imedi medeŋiŋ nadiyamuk?” ");
INSERT INTO nop_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesu adi imeŋgwaŋ fukuniŋ Gadalahi’walaŋ kwetneŋ wosuwaguk. Wosuwaune meyat lufom yabaphinit meyotneŋ hakumukdi fooŋ bumiŋgumuk. Meyat u fafaŋe gibita tagumuk doktiŋa metam adi utalik woŋambuŋat mu tagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ala Jesu kaŋ yakawe toŋa indiŋ niŋgumuk, “Bepaŋ mihiŋiŋ, du maŋgoŋ tinimbe bulaŋ? Nai mu tulune deti folofigita kwanai gehiŋgehiŋ nimbeŋ?” ");
INSERT INTO nop_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kaŋ makaye mohok kweetniŋgoŋ-kabe uŋgoŋ yabudokooŋ heyemagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ala yabap hekidi Jesu nimbulabulayeeŋ indiŋ ninadigiŋ, “Niniŋkule kaŋ niniŋkulune looŋ makaye welehik maaneŋ fonim.” ");
INSERT INTO nop_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Unduŋ yogiŋ kaŋ Jesudi yeniŋguk, “Fooŋ buŋa wiiŋ!” Yenimbune adi meeniŋ gineniŋ fooŋ buŋa looŋ makaye welehik maaneŋ fogiŋ. Kaŋ makaye heki kigoŋkula wooŋ maham gineŋ tatakula ime gineŋ fooŋ ime naaŋ nadilali kumuŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kaŋ me makaye yabudokoyagiŋ hekidibo momoŋ yokwet wapumneŋ looŋ makaye heki’walaŋ kahat eŋ meyat yabaphinit yakat’walaŋ kahat u metam wanakaŋ tiyemdapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","U tiyembune nadiŋa metam hogohogok wanakaŋ faŋkalap tiŋa Jesu kanene fogiŋ. Fooŋ kaŋ kwehik u bikabuŋa uuŋdok niŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kaŋ Jesu adi kotigoŋ muwage foloŋ looŋ ime meŋeŋa fukuniŋ ne yolikweli wapumneŋ wosuwaguk. ");
INSERT INTO nop_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wosuwalune me niŋ kayoŋ kohoŋ kumuhi falik foloŋ kameeŋ nagila bugiŋ. Kaŋ Jesudi nadisukilitihik kanadi bilateŋ me kayoŋ kohoŋ kumuhi u indiŋ niŋguk, “Mihine, du munta mu tibeŋ. Kadakaniŋge agaŋ tumolokutat.” ");
INSERT INTO nop_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Unduŋ yobune Yodoko Mede henale heki adi nehi uŋgoŋ kiyonadi tiŋa indiŋ yogiŋ, “Me i dediniŋgoŋ doktiŋa Bepaŋ’walaŋ kwelikoŋ tilak?” ");
INSERT INTO nop_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kaŋ Jesu adi nadisuhik u agaŋ kaŋ yeniŋguk, “Hidi nadisu hogohi undihi maŋgoŋde tiiŋ? ");
INSERT INTO nop_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mede loŋgoŋ dediŋ yodok: Kadakaniŋge tumolokutat, be pilali weŋ? ");
INSERT INTO nop_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Unduŋ yoiŋ doktiŋa Me Kobumuŋ nu kwetfoloŋ iŋoŋ kadakaniŋ bibiŋdok saŋiniŋne hatnamulak u tibe kaneŋ.” Unduŋ yeniŋa me kayoŋ kohoŋ kumuhi u indiŋ niŋguk, “Pilali gulupge moŋgola yokede weŋ.” ");
INSERT INTO nop_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Unduŋ nimbune nai uŋaniŋgoŋ pilali gulupŋiŋ moŋgola yolide mauguk. ");
INSERT INTO nop_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Unduŋ tubune metam bop uŋoŋ hakiŋ adi u kaŋ boho tigiŋ, tiŋa Bepaŋdi saŋiniŋ undiniŋ meeniŋ kohoŋ foloŋ kameguk yoŋa Bepaŋ niutumbagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Unduŋ tiŋa Jesu adi wooŋ takis muneeŋ moŋgomoŋgot me niŋ wou Matiyu adi kwanai yotneŋ itune kaŋ niŋguk, “Nehikeleweŋ.” Unduŋ nimbune Matiyu adi pilali Jesu keleeŋ uguk. ");
INSERT INTO nop_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Unduŋ tiŋa looŋ Matiyu yolineŋ nanaŋe ila nalune me takis muneeŋ moŋgomoŋgot fee eŋ metam kadakaniŋ titiŋ noli wanakaŋ buŋa Jesu tiŋa mihiŋiye yehitomboyoula nanaŋe noŋgoŋ ila nagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Unduŋ tubune Falisi hekidi u kaŋ Jesu mihiŋiye indiŋ yeninadigiŋ, “Henalehik detiŋa me takis muneeŋ moŋgomoŋgot heki tiŋa metam kadakaniŋ titiŋ dut nanaŋe noŋgoŋ naiŋ?” ");
INSERT INTO nop_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Unduŋ yonadigiŋ kaŋ Jesudibo medehik u nadiŋa indiŋ yeniŋguk, “Haguwo me adi metam kedehi mu yehitubu-lodalak. Adi metam yagithinit yehitubu-lodalak. ");
INSERT INTO nop_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hidi uneŋ wooŋ mede indiŋ hatak u mebi baigoŋ hinek kanadi tineŋ, ‘Bepaŋ adi me nohiyedok welehikdi hinek yabukahileeŋ siloŋ tiyemdok nadilak, eŋ kale hemundumunduŋe timiŋdok adi moŋ nadilak.’ “Nu adi me fofohi loloŋnit yehitubu-lodadok mu bugut. Nu adi me kadakaniŋ titiŋ yehitubu-lodawene bugut.” ");
INSERT INTO nop_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kaŋ nai uŋaniŋ Jon Imeyout Tububihit mihiŋiye adi Jesu’walaŋ buŋa mintaaŋ indiŋ ninadigiŋ, “Indi tiŋa Falisi heki indi yadi nanaŋe kameheŋa map hatiyam, kaŋ dediŋ doktiŋa du mihigeye adi nanaŋe kamehep tiŋa hogok-kabe nemu hatiiŋ?” ");
INSERT INTO nop_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Unduŋ ninadigiŋ kaŋ Jesudibo indiŋ yeniŋguk, “Me kohokukut titiŋdok adi hinamuni gineŋ uŋgoŋ hatune me nanaŋe nanadifodok buneŋ adi nanaŋe kamehep kedembe tineŋ? U tuwot moŋ. Hatigene me wapumhik yolom nagilune kedem nanaŋe kameheŋa map hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Nebek niŋdi haule kobuli dobuŋa dahidahi komi foloŋ tuwot mu tibinegaliwek. Unduŋ tubune adi haule kobulidi hamaneune dahidahi komi u hamaŋgoŋ bulaginewek. ");
INSERT INTO nop_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Be nebek niŋdi wain ime gitipmuŋ tutumbaaŋ kale gitnemdi ime tout tibineyagiŋ uŋolok komi gineŋ tuwot mu ugolowek. Unduŋ tubune adi waindi tout komi tubutawaaŋ kwatnewaakneŋ doktiŋa wain kobuli adi tout kobuli gineŋ hogok ugolodok.” ");
INSERT INTO nop_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu adi mede u yayenilu bopyot diniŋ kaulidoko me niŋdi buŋa hebeŋ foloŋ mulelem timiŋa ninadiguk, “Waabine kobugoŋ kumulak, ale buune nukut wooŋ kohoge folooŋ foloŋ kameweŋ kaŋ kaikaaŋ pilalek.” ");
INSERT INTO nop_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Unduŋ ninadiune Jesu pilali noŋgoŋ uune mihiŋiye maaŋ pilali noŋgoŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ulune tam niŋ muyakip yagit tomboyoutnit ti hatibune gulet 12 tuguk, adi Jesu sigineŋ wooŋ dahidahiŋiŋ diki wehemikuk. ");
INSERT INTO nop_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tiŋa weleŋ maaneŋ indiŋ nadiguk, “Dahidahiŋiŋ hogok wehemitat yendi kedem nehitubu-kedebawek.” ");
INSERT INTO nop_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Unduŋ nadilune Jesudi udaneeŋ kaŋ niŋguk, “Waabine, du munta mu tibeŋ, nadisukilitigedi gehitubu-kedebalak.” Unduŋ nimbune nai uŋaniŋgoŋ hinek kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kaŋ Jesu adi wooŋ bopyot diniŋ kaulidoko me yolineŋ looŋ yabulune metam makat ila kokiŋ, kaŋ yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Hidi hogohogok fooŋ bu udapmaneŋ. Waabi i kumuŋ mu tiŋak, adi yadi damo deitak.” Unduŋ yobune adi kagege tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kaŋ yenimbune fooŋ udapmaune dabaŋ hakukneŋ fooŋ waabi u kohoŋ foloŋ honeune kaikaaŋ pilakuk. ");
INSERT INTO nop_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Unduŋ tubune gigit wendi kwetkwet hautadapmaguk. ");
INSERT INTO nop_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesu adi kwet u bikabuŋa ulune meyat lufom dauhik sipmakahiyat adi Jesu indiŋ kutiniŋa keletaugumuk, “Dewit’walaŋ yalaki, inditok bulaniŋgoŋ nadiweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kaŋ Jesu adi wooŋ yopmaŋ loguk kaŋ meyat u hebeŋ gineŋ ugumuk, uune yeninadiguk, “Hidi nu kedem hehitutumbait unduŋ hinek-kube nadisukilitiyamuk?” Unduŋ yeniŋguk kaŋ niŋgumuk, “Eeŋ, undugoŋ hinek nadiyamut.” ");
INSERT INTO nop_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Unduŋ yobune Jesudi meyat dauhik foloŋ wehemila yeniŋguk, “Nadisukilitihik diniŋ folooŋ undugoŋ mintahambek.” ");
INSERT INTO nop_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Unduŋ yenimbune nai uŋaniŋgoŋ dauhik tombune diwedakalegumuk. Kaŋ Jesudi metam noli mu yenimbihitemek yoŋa moŋ hinek yeniheguk. ");
INSERT INTO nop_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iŋgoŋ oŋ, adi u nadikabeleeŋ wooŋ gigit u yohautaune kisaŋ hautaguk. ");
INSERT INTO nop_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Meyat ulune me niŋ yabapdi tububuyeune mede mu yoluguk u nagila Jesu hakukneŋ bugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kaŋ Jesudi yabap u kelekulimimbune fooŋ uune me u mede yoguk. Kaŋ metam bop wapumdi u kaŋ boho tiŋa indiŋ yogiŋ, “Indi Isilae kwetneŋ nemek indiniŋ koom nemu mintaune kagumun.” ");
INSERT INTO nop_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kaŋ Falisi hekidi Jesudok indiŋ niŋgiŋ, “Me i yabap heki’walaŋ wapumhikdi tubulodaune yabap yeniŋkuyaulak.” ");
INSERT INTO nop_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu adi unduŋ tiŋila yokwet wapuhineŋ be yokwet kuyahineŋ wanakaŋ yaudapmaguk. Eŋ Judahi’walaŋ bopyot indigoŋ tuwot fodapmaaŋ Bepaŋ hebeŋ gineŋ Hatihati Kobuli diniŋ Mede Momooŋ yeniŋa uguk, eŋ metam yagit folofigitahinit maaŋ yehitubu-kedebayauguk. ");
INSERT INTO nop_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tiŋa metam bop wapum yabuguk adi nadinadihik giyondahi. Nedi’walaŋ deŋandiŋ wooŋ kedebadok, u maaŋ mu nadigiŋ. Dompa uŋamo kadoko mokitdi tiiŋ undihi, u yabuŋa welebulaniŋgoŋ nadiyemguk. ");
INSERT INTO nop_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tiŋa mihiŋiye indiŋ yeniŋguk. “Nanaŋe bedok fee kitaiŋ, iŋgoŋ nanaŋe bebedok kwanai-medi lufomgoŋ tilak. ");
INSERT INTO nop_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Unduŋ doktiŋa hidi dinina molom ninadiune kwanai-me noli maaŋ yehitubu-mintaune kwanaiŋiŋ gineŋ uneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesudi mihiŋiye 12 yenimbu buune yabap yehikelekutdok be wede haki tiŋa yagit folofigitahinit yehitubu-kedebadok saŋiniŋ yemguk. ");
INSERT INTO nop_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposel 12’walaŋ wohiye adi indiŋ: Timeŋ Saimon, wou noli Pita, tiŋa kwayaŋ Endulu, eŋ Jems Sebedi mihiŋiŋ eŋ kwayaŋ Jon. ");
INSERT INTO nop_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Tiŋa Filip eŋ Batolomi, tiŋa Tomas eŋ Matiyu takis muneeŋ moŋgomoŋgot tuluguk, eŋ Jems Alifiya mihiŋiŋ eŋ Tadiyas. ");
INSERT INTO nop_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Tiŋa Saimon Selot eŋ Judas Kaliotniŋ, adi hatigene Jesu bolik timiŋguk. ");
INSERT INTO nop_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aposel 12 u indiŋ yeniŋa yeniŋkukuk, “Hidi me Bepaŋ’walaŋ feknit mokit’walaŋ kwetneŋ mu uneŋ, eŋ Samaliyahi’walaŋ yokwet ila wiiŋneŋ uŋoŋ mu yauneŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Hidi adi Isilaehi dompa noli moile tiŋa hatiiŋ adi’walaŋkade hogok kwanaineneŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uŋoŋ yauŋila gigitmede indiŋ yenihautayauneeŋ, ‘Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Uŋgoniŋdi hehitubu-dulalak.’ ");
INSERT INTO nop_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Unduŋ yeniŋila me yagit folofigitahinit yehitubu-kedebaneeŋ. Dabahi yehitubu-pilatneeŋ, eŋ wede hakihinit yehitubu-walandaneeŋ, eŋ yabap yeniŋkelekut tineeŋ. “Kwanai u titiŋdok saŋiniŋ adi tuwaŋit mokit, hogok hamulat doktiŋa u hogok tiyauneeŋ, hehituwa adi mu tineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tiŋa unene muneeŋ be ");
INSERT INTO nop_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","lihik be dahidahi lufom be kayoŋnamokop be kuyaŋ adi mu moŋgotneeŋ. Mokoŋ hinek. Kwanai me heki adi kwanai tiiŋ doktiŋa yabudokooŋ yemtoi titiŋdok. ");
INSERT INTO nop_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Yokwet daŋ wosuwayaneeŋ indigoŋ tuwot timeŋ metam uŋahi mebihikdok yonadi taneeŋ. Me nedi’walaŋ mebi momooŋ nadiŋa kaŋ adigut itouŋa kameeŋ waneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yot maaneŋ fooŋ indiŋ yeniyaneeŋ, ‘Kulema hidut halek.’ ");
INSERT INTO nop_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kaŋ me yot molohiyedi momooŋ binek tihambune kaŋ yokahaŋ tiyemiŋa waneeŋ. Eŋ yot molohiyedi momooŋ mu tihambune kaŋ yokahaŋ mede u yolom beŋa yawaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tiŋa yokwet niŋ gineŋ uune metam mu haniutumbaaŋ medehik mu nadiŋa tubune kaŋ yokwet u biŋa kayohik foloŋ figifigi uŋgoŋ ulumamaŋeu foune yawaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Indiŋ nadineŋ! Bepaŋ’walaŋ nai wapum mintawaakneŋ Bepaŋdi mede yodapmaune yokwet uŋahidok malabumuŋ wapumgoŋ mintayembaak eŋ Sodom dut Gomola’walaŋ malabumuŋhikdi loŋgoŋ tibaak.” ");
INSERT INTO nop_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“I nadineŋ. Dompa heki kamo moiŋ gineŋ wiiŋ unduŋ dabugoŋ haniŋkutat ala nadinadiŋale uneŋ. Unduŋ doktiŋa hidi miŋgembet nabugoŋ gitagoŋ hatineeŋ, tiŋa undugoŋ butigili wele kulemaŋgoŋ didimeniŋ hatineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nadinadiŋila yauneeŋ, me noli hanagila mede gineŋ hapmeneeŋ, eŋ bopyotneŋ hanagila fooŋ hehiwihitnadineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“U, hogok mu tihamuneeŋ, hidi nu’walaŋ mihineye hatineeŋ doktiŋa hanagila me mapme loloŋhinit be me wapuhi’walaŋ uune adi namandahik foloŋ yali mede kwanai tineeŋ. Unduŋ tihambune hidi uŋgoŋ fafaŋeŋ yali adi namandahik foloŋ be me Judahi’walaŋ feknit mokit namandahik foloŋ Mede Momooŋ yohautaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Be hanagila me mapme wapuhi’walaŋ uune mede dediŋ yonim yoŋa nadibedi mu taneeŋ. Nai uŋaniŋgoŋ Uŋgoniŋ Munabulidi mede dediŋ yodok u welehik maaneŋ kameeŋ hehitubu-lodaune yoneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kaŋ mede yoneeŋ wendi hide yoiŋ mu tibaak, adi Behik’walaŋ Munabuli welehik maaneŋ hatak adi’walaŋ mede unduŋ tibaak. ");
INSERT INTO nop_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kaŋ me noli nehi’walaŋ kwayahiye be dahiye bolik tiyembune widihikumuneeŋ, be behiyedi wapmihiye bolik tiyembune widihikumuneeŋ be wapmihidi mehim-behiye’walaŋ mede wobuŋa bolik tiyembune widihikumuneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“Tiŋa metam hogohogok nutok tiŋa hidi habukwihita tineeŋ. Iŋgoŋ nebek niŋ adi fafaŋe tiŋa hatibune dapmandapmaŋdok naiŋiŋ tibaak adi yadi Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Kobuli kahilewaak. ");
INSERT INTO nop_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tiŋa undugoŋ indiŋ nadineŋ, yokwet niŋ gineŋ binek uune fidihihehikele tubune kaŋ yokwet u bikabu tiŋa yawaneeŋ. Tiŋa indiŋ maaŋ nadineŋ, hidi kwanaihik Isilae maaneŋ yokwet hali ulakneŋ uŋoŋ mu tubudapmalune Me Kobumuŋ adi koti baak. ");
INSERT INTO nop_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Pepayot wapmihi niŋdi henaleŋiŋ kalakapme mu tilak. Be tipilapilaye-me adi wapumŋiŋ kalakapme mu tilak. ");
INSERT INTO nop_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Unduŋ doktiŋa wapmihidi kwanai tiŋa uuyeŋ nadinadiŋiŋdi henaledok tuwolit tubumintaune tuwot tibek. Be tipilapilaye-medi bomboŋgiŋiŋdok tuwolit tubune u maaŋ kedem. Yot molom nintubukadakaaŋ Sadaŋ niiŋ doktiŋa wapmihiŋiye maaŋ nemek kisaŋgoŋ tiyemneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Hidi meeniŋdok munta mu taneeŋ, nemek tumut gineŋ hatak u naininde miŋgoŋ mintadakalewaak, eŋ nemek kabup yonadiiŋ u naininde miŋgoŋ nadidapmaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Unduŋ doktiŋa nemek niŋ nu hidetok hogok hanilat woŋ adi miŋgoŋ yohautayaneeŋ, be mede hamahamap foloŋ hanilat woŋ adi yowawali foloŋ yali yohautayaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Hidi nebek sigihik gitnem hogok ulukumuŋa munabulihik ulukumuŋdok saŋiniŋ lohilak aditok munta mu taneeŋ. Hidi munta timindok adi Bepaŋ uŋak. Adi yadi sigihik be munabulihik wanakaŋ yenindapmaune kudup gineŋ fofoŋdok saŋiniŋ halimilak. ");
INSERT INTO nop_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Bagi nandip-kabe lufom u muneeŋ giminiŋdi kedem tuwawetiŋ. Iŋgoŋ Behikdi nadiune kubugoŋ-kabe nemu kumuŋa malak. ");
INSERT INTO nop_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Be meeniŋ hidi’walaŋ kihik hapmuŋ yokunat dedigoŋ u agaŋ nadidapmalak doktiŋa munta mu taneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hidi adi bagi nandip-kabe u yalakapme tiiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nebek niŋdi metam namandahik foloŋ nu wotnene miŋgoŋ yohautaune kaŋ kibi maaŋ nubo kunum gineŋ Me Baŋ namanda foloŋ adi’walaŋ wou miŋgoŋ yohautawaat. ");
INSERT INTO nop_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Eŋ nebek niŋdi metam namandahik foloŋ nu wotnene yokamehebi tubune kaŋ nu maaŋ undugoŋ kunum gineŋ Me Baŋ namanda foloŋ me u mu nadimilat yobaat.” ");
INSERT INTO nop_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tiŋa nu kwetfoloŋ iŋoŋ kulema tubumintadok fogut unduŋ mu yoŋa nadiyaneeŋ. Nu yadi mik tubumintaaŋ metam yehiulitawawene fogut. ");
INSERT INTO nop_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Unduŋ doktiŋa me yabet adi kikakwihita tidemeek, eŋ waabi yamit adi maaŋ kikakwihita tidemeek, eŋ yanabuŋit adi maaŋ kikakwihita tidemeek. ");
INSERT INTO nop_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eŋ me niŋ adi ne’walaŋ wapmihi-tamdigoŋ mik timineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nebek niŋ weleŋ wapum mimbeudok kameeŋ nutok weleŋdi hinek mu nabukahilewaak adi yadi nutok gigit mu tibaak. Be nebek niŋ weleŋ wapum wapmihiŋiyedok kameeŋ nutok weleŋdi hinek mu nabukahilewaak adi undugoŋ nutok gigit mu tibaak. ");
INSERT INTO nop_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Be nebek niŋ koloŋdabekŋiŋ mu bemŋa nehikelewaak adi maaŋ undugoŋ nutok gigit moŋ. ");
INSERT INTO nop_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nebek niŋdi hatihatiŋiŋ netok kahilewaak adi fiit timimbaak. Eŋ nebek niŋdi nutok nadiŋa kwanaine tihatibaak adi Hatihati Kobuli tubumintawaak.” ");
INSERT INTO nop_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nebek niŋdi yolineŋ hanihamaneune loneeŋ, adi nutok tinamiiŋ tibaak. Be nutok tinamneeŋ u Me napmeune fogutdok timiiŋ unduŋ tibaak. ");
INSERT INTO nop_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kaŋ nebek niŋdi polofet u polofet hatilak yoŋa yolineŋ nihamaneune lowaak adi tuwaŋiŋ polofet’walaŋ wendok tuwolit moŋgolaak. Be nebek niŋdi me niŋ me didimeŋ hatilak doktiŋa nihamaneune yolineŋ lowaak adi tuwaŋiŋ me didimeniŋ’walaŋ wendok tuwolit moŋgolaak. ");
INSERT INTO nop_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tiŋa indiŋ nadineŋ. Nebek niŋdi fofoŋnit niŋ nu’niŋ mihine yoŋa ime subumuŋ hogok gilimimbune nawaak, adi yadi biyagoŋ hinek tuwaŋiŋ bewaak.” ");
INSERT INTO nop_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu adi mihiŋiye 12 mede unduŋ yenindidimedapmaaŋ yokwet noli Galili kwetneŋ ila ugiŋ uŋoŋ yenindidime kwanai tiŋa Mede Momooŋ yoyo tibene uguk. ");
INSERT INTO nop_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kaŋ Jon adi yot fafaŋeniŋneŋ hali Jesudi kwanai tubune gigitŋiŋ nadiŋa mihiŋiye yeniŋkulune ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wooŋ indiŋ ninadigiŋ, “Du Jondi me niŋ bubuŋdok yoguk u du-kube? Be nolidok woomuneem?” ");
INSERT INTO nop_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Unduŋ yobune Jesudi indiŋ yeniŋguk, “Hidi udaneeŋ uneŋ. Wooŋ nemenemek mintaune kanadi tiiŋ u Jon nimbune nadiwek. ");
INSERT INTO nop_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Me dauhik sipmakahidi diwetom tiiŋ, kayohik kadakahidi talik yawiiŋ, wede hakihinitdi walandaiŋ, be magihik kaulehidi mede nadiiŋ, eŋ kumuhidi koti kaikaiŋ, agaŋ fiyewakahidi Mede Momooŋ nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Me nediyeŋ nu’walaŋ titiŋne kaŋ nadikadaka mu tilak adi Bepaŋdi kaune utumba tilak.” ");
INSERT INTO nop_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon mihiŋiye udaneeŋ ulune Jesudi metam Jondok indiŋ yeniŋguk, “Hidi kwet fiileŋ ugiŋ u maŋgoŋ kanene ugiŋ? Hidi baniŋgip sububadi fedilu uŋambuŋat tilak ube kane ugiŋ? ");
INSERT INTO nop_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Be me tinahukut kinonom tilak undiniŋbe kane ugiŋ? Me tinahukut unduhi tinahukukiiŋ adi me mapme yohineŋ hogok hatiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Be polofet niŋ kane ugiŋ? Indiŋ hanimbe nadineŋ. Hidi me wooŋ kagiŋ adi yadi polofet noli yalakapme tilak, tiŋa adi yadi me uŋgoniŋ hinek. ");
INSERT INTO nop_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aditegoŋ Yokudip Mededi indiŋ yolak, ‘Nu kwanai-mene kamewene timeŋ wooŋ talik dobui tigambaak.’” ");
INSERT INTO nop_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Unduŋ yoŋa tomboyoula indiŋ yeniŋguk, “Indiŋ hanilat. Metam hogohogok kwetfoloŋ mintagiŋ nebek niŋdi Jon Imeyout Tububihit mu kalakapmelak, iŋgoŋ nebek niŋ Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Kobuli gineŋ fofoŋnit-kabe hatilakdi Jon kalakapmeeŋ loloŋnit tilak. ");
INSERT INTO nop_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon Imeyout Tububihitdi tububihila kwanai tuguk nai uŋaniŋ Bepaŋ’walaŋ Hatihati Kobuli diniŋ Mede Momooŋ u saŋiniŋnit tububihila mintagukdi mintati bulak. Kaŋ me nediyeŋ gigine kwanai tiiŋ hekidi Hatihati u kahileiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Polofet heki tiŋa Moses adi wanakaŋ kigili mede youkudip foloŋ eŋ yohauta gineŋ titabubuyeeŋ Jon’walaŋ nai gineŋ tubudapmagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Unduŋ doktiŋa hidi mede i nadine kaŋ kedem nadineŋ. Ilaija bubuŋdok yogiŋ u Jon buguk uŋakoŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nebek niŋ adi nadidakalewe kaŋ magi baigoŋ kametnadiŋa nadiwek.” ");
INSERT INTO nop_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Metam kobuhi i maŋgoŋdok tuwolit kamekaaŋ yenimbit? Adi yadi wapmihidok tuwolit. Wapmihi adi yowawaliweŋ bopneeŋ haliŋa nohiyedok indiŋ yeniiŋ, ");
INSERT INTO nop_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Indi kap momooŋ togumun iŋgoŋ nadifo mu tigiŋ, be kap bulaniŋgoŋ togumun iŋgoŋ makat mu kokiŋ!’ ");
INSERT INTO nop_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon Imeyout Tububihit adi buŋa nanaŋe kamehep tiŋa ime fafaŋeniŋ maaŋ mu naguk kaŋ ‘Me yabapnit’ niŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kaŋ Me Kobumuŋ adi buŋa nanaŋe ime naune kaŋ indiŋ yoiŋ, ‘Me i nanaŋe molo tiŋa ime fafaŋeniŋ nanaŋ tilak doktiŋa adi yadi me takis muneeŋ moŋgomoŋgot eŋ me kadakahi’walaŋ nohik.’ “Metam kobuhidi unduŋ yoiŋ iŋgoŋ Bepaŋ’walaŋ nadisuhebet adi negoŋ folooŋnit tubune mebiŋiŋ mintadakalelak.” ");
INSERT INTO nop_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesu adi yokwet indigoŋ yauŋa kunumneniŋ kudi tiyauguk iŋgoŋ metamdi kudi u yabuŋa welehik mu tubutakalegiŋ, doktiŋa nai uŋaniŋ kisaŋ yabutoŋa indiŋ yeniŋguk. ");
INSERT INTO nop_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Hidige! Kolasinhi tiŋa Besaidahi, hidi’walaŋ uŋoŋ kudi tugut u Saidon dut Taiya uŋoŋ binek tibe tugut adi metam uŋahidi kobulabulaye tiŋa kadakaniŋhik sigilulum tiyemne tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Unduŋ doktiŋa kougoŋ nai wapum mintawaakneŋ hidi’walaŋ malabumuŋdi adi’walaŋ kalakapme tibaak. ");
INSERT INTO nop_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Tiŋa Kafanaumhi, hidi hidetok nadiune loloŋ tilak, iŋgoŋ oŋ, hidi yadi hamdok gigit. Hidi’walaŋ kwetneŋ iŋoŋ kudi mintaguk u Sodom kwetneŋ uŋoŋ mintawe tuguk binek yokwet u mu kadakawe tuguk. Nai indidegoŋ momooŋ hatuwek. ");
INSERT INTO nop_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Unduŋ doktiŋa indiŋ nadineŋ, kougoŋ nai wapum mintawaakneŋ hidi’walaŋ malabumuŋ mintawaak adi Sodomhi’walaŋ kalakapmeeŋ mintahambaak.” ");
INSERT INTO nop_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nai uŋaniŋ Jesudi mede indiŋ yoguk, “O Me Baŋ, kunumkwet diniŋ Wapum, du nemenemek i me nadinadihinit be nadidakalehinit’walaŋkade kamehebi tuguŋ. Tiŋa me nadinadihikdok nadiune wapmihidok tuwolit tilak aditok adi miŋgoŋ taŋakiyeyembu kaiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Me Baŋ, da unduŋ mintadok yokwambundaaŋ nadifo tuguŋ wondok tuwot mintalak doktiŋa nadifo tiŋa ganiutumbalat. ");
INSERT INTO nop_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nu Batnedi nemenemek agaŋ namdapmaguk tiŋa adi kubugoŋdi nadinamulak. Nebek noli nemoŋ. Kaŋ nebek niŋdi Me Baŋ mu nadimilak, Mihidi hogok nadimilak. Tiŋa meeniŋ Mihidi yehidanelak adi-hogok yenindakaleune nadidakaleiŋ. ");
INSERT INTO nop_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Me malabumuŋ tinatagibemŋa nadimalabudaaŋ gweheye tiiŋ, hidi nu’walaŋkade buune hehitubu-lodaaŋ kulema hambit. ");
INSERT INTO nop_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nu adi me kulemaŋ eŋ welene maaŋ kulemaŋ ale nu’walaŋ kwanai tiŋa mebine nadidakaleune welehik kulemawek. ");
INSERT INTO nop_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nu’walaŋ isene u kulemaŋ eŋ nemek beemdok hamulat uyadi loŋgoŋ.” ");
INSERT INTO nop_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tiŋa mindaŋkade Sabat foloŋ Jesu adi mihiŋiye dut wit fiye gineŋ talik ugiŋ. Uŋila mihiŋiye adi map nadiŋa wit folooŋ wootitiila kaipmuŋ nagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kaŋ Falisi hekidi yabuŋa nadiune tuwot mu tubune Jesu indiŋ niŋgiŋ, “Yodoko Medenikdi Sabat foloŋ kwanai mu titiŋdok yolak kaŋ mihigeye adi maŋgoŋde unduŋ tiiŋ?” ");
INSERT INTO nop_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Unduŋ yobu Jesudibo yeniŋguk, “Hidi Dewit tiŋa meŋiyedi map nadiŋa tigiŋ u mube kunali nadiiŋ? ");
INSERT INTO nop_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewit adi wooŋ Bepaŋ’walaŋ Siloŋyotneŋ fooŋ Bepaŋdok belet uŋgoniŋ yoŋa kamegiŋ u tiŋa naaŋ meŋiye yembune nagiŋ. Kaŋ Yodoko Medenikdi unduŋ mu titiŋdok yoŋit, adi Siloŋyot diniŋ talitimeŋdi hogok nanaŋdok yoŋit. ");
INSERT INTO nop_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Be Siloŋyot diniŋ talitimeŋ heki’walaŋ Yodoko Mede hatak u mube kunatnadiiŋ? Talitimeŋ heki Sabat foloŋ kwanai mu titiŋdok yoŋit adi u lahula Siloŋyotneŋ kwanai tubune wendi yom mu tilak. ");
INSERT INTO nop_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Nu indiŋ hanimbene nadineŋ. Me niŋ namandahik foloŋ yatak adiyeŋ Siloŋyot kalakapmelak. ");
INSERT INTO nop_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bepaŋ’walaŋ Youkudip Mede gineŋ mede niŋ indiŋ yolak, ‘Bepaŋ adi kale hemundumunduŋe timindok adi moŋ nadilak, adi yadi me noli siloŋ tiyemdok nadilak.’ Hidi mede u nadiyaneŋ binemek adi me yomhinit mokit yeniŋtofit mu taneŋ. ");
INSERT INTO nop_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Me Kobumuŋ adi Sabat maaŋ kadokolak.” ");
INSERT INTO nop_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Unduŋ yodapmaaŋ nai uŋaniŋgoŋ wooŋ Judahi’walaŋ bopyotneŋ foguk ");
INSERT INTO nop_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","kaŋ me niŋ kohoŋ kumuŋ tuguk adi uŋgoŋ ikuk. Kaŋ mehekidi Jesu mede gineŋ deti kamenim yoŋa indiŋ niŋkamandagiŋ, “Yodoko Medenikdi dediŋ yolak. Sabat foloŋ meeniŋ kedem be yehitubu-kedebadok, be dediŋ?” ");
INSERT INTO nop_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kaŋ Jesudibo indiŋ tubu-udaneyemguk, “Hidi’walaaniŋ nebek niŋ dompaŋiŋ Sabat foloŋ koŋ gineŋ binek fowek, kaŋ Sabat foloŋ doktiŋa kedembe bikabune uŋgoŋ halek? ");
INSERT INTO nop_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dompadi nemek folooŋ mu tilak, meeniŋ adi nemek uŋgoniŋ hinek, unduŋ doktiŋa Yodoko Mededi Sabat foloŋ me yehitubu-loda kedem titiŋdok yolak.” ");
INSERT INTO nop_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Unduŋ yoŋa me kohoŋ kumuŋ u niŋguk, “Kohoge kihiwaleŋ.” Nimbune kohoŋ kihiwali utumbahinakaune fukuniŋ dabugoŋ tuguk. ");
INSERT INTO nop_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Unduŋ tubune Falisi heki adi u kaŋ wooŋ Jesu uutdok yohebet tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kaŋ Jesu adi mede u nadiŋa yokwet u bikabuŋa kwet niŋkade uguk. Kaŋ metam feedi keletaune yagithinit yehitubu-kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tiŋa Jesudi kwanai u tuguk, u metam noli mebiŋiŋ mu yenindok yoŋa yenihep tuguk. ");
INSERT INTO nop_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kaŋ Bepaŋdi polofet Aisaiya maŋiŋ gineŋ mede indiŋ yoguk u folooŋ mintaguk, ");
INSERT INTO nop_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“I na’walaŋ tipilapilaye-me, adi nagoŋ tubudakalegut. Adi kanadigalika tilat, tiŋa welenedi hinek kahile tilat. Unduŋ doktiŋa Uŋgoniŋ Munabuline ugolomimbene metam fekhinit mokit titiŋ didimeniŋdok Mede Momooŋ yenihautawaak. ");
INSERT INTO nop_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Adi tosiwe tiŋa kutifiye mu tibaak, be mede yowawaliweŋ miŋgoŋ mu yohautawaak. ");
INSERT INTO nop_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Adi yadi yat koliknit filodokokut mu tibaak. Be kudupdelet datumutumule tilak u bikabune mu kumumbaak. Adi unduŋ titaulune titiŋ didimeniŋdi fafaŋedapmawaak. ");
INSERT INTO nop_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kaŋ metam fekhinit mokit hogohogok, adi wou gineŋ welehikdi nadisukilitiŋa nemek kedem mintayembaak wendok nadisuŋa gigine tiŋa woomiyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nai uŋaniŋ me niŋ yabapdi tubukadakaune dawi sipmaka tuguk, tiŋa undugoŋ mede maaŋ mu yoluguk u nagila Jesu’walaŋ ugiŋ. Uune Jesudi tubukedebaune mede yoŋa dau diwe tuguk. ");
INSERT INTO nop_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kaŋ mebop kakaŋ yakiŋ adi u kaŋ boho tiŋa yogiŋ, “Dewit mihiŋiŋ iŋakoŋ bidak?” ");
INSERT INTO nop_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Unduŋ yogiŋ kaŋ Falisi hekidibo u nadiŋa yeniŋgiŋ, “Yalaŋ mu yoneŋ ale wabiut. Me i yabap heki’walaŋ wapumhik Belisibudi tubulodaune yabap yeniŋkuyaulak.” ");
INSERT INTO nop_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iŋgoŋ Jesu adi nadinadihik u kanadiŋa indiŋ yeniŋguk, “Kwet wapum niŋ adi utawaaŋ bop molomolom tiŋa mindobuneŋ kaŋ kwet u pilap kadakawek. Be hekinolit niŋ adi daneeŋ molomolom hatiŋa mindobu tubune lekiŋgoŋhik foloŋ utawa utawa hali kadakawek. ");
INSERT INTO nop_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sadaŋ’walaŋ mebopdi utawaaŋ bop lufom tiŋa mindobu tubune adi’walaŋ kwanai deti saŋiniŋnit halek? ");
INSERT INTO nop_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Hidi nu Sadaŋdi saŋiniŋ nambune yabap yehikelelat yoiŋ, ale nu undugoŋ nobu tilit kaŋ me hide’walahi adi maŋgoŋ saŋiniŋdi yehitubu-lodaune yabap yehikeleiŋ? Hidi yalaŋ yoiŋ doktiŋa hide’walaŋ me nohiyedi mebihik tubudakaleiŋ. ");
INSERT INTO nop_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nu adi Bepaŋ’walaŋ Munabulidi nobu nehitubu-lodaune yabap heki yehikelelit kaŋ hidi Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Kobulidi agaŋ hehitubu-dulalak u agaŋ mintadakalelak. ");
INSERT INTO nop_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nebek niŋ me fafaŋeniŋ’walaŋ yoli ubulagineeŋ bomboŋ kubo tibe nadiŋa timeŋ me u tawa tiŋa ibikilitiune halune yoli kedem ubulaginewek. ");
INSERT INTO nop_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nebek niŋ menot mu tinamulak adi mik tinamulak, be nebek niŋdi mu nehitubu-lodaaŋ kwanaine kadokolak adi metamneye yehitubu-pupuhene tilak. ");
INSERT INTO nop_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tiŋa indiŋ hanilat. Nebek niŋdi kadakaniŋ tibaak, be me noli niŋkadaka tibaak, adi Bepaŋdi kadakaniŋŋiŋ kedem bimimbaak. Iŋgoŋ nebek niŋdi Uŋgoniŋ Munabuli niŋkadaka tibaak adi kadakaniŋŋiŋ mu bimimbaak. ");
INSERT INTO nop_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tiŋa nebek niŋdi Me Kobumuŋ niŋkadaka tibaak adi kadakaniŋŋiŋ kedem tumolokulimimbaak. Iŋgoŋ nebek niŋdi Uŋgoniŋ Munabuli niŋkadaka tibaak adi kadakaniŋŋiŋ hogok kameune haliwooŋ halaak fafaŋeniŋ.” ");
INSERT INTO nop_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesudi tomboyoula indiŋ yoguk, “Bem niŋdok miminiŋ yokaaŋ mindipmuŋdok maaŋ momooŋ yoyaneeŋ. Be bem niŋdok moiniŋ yokaaŋ mindipmuŋdok maaŋ hogoli yoyaneeŋ. Bem diniŋ mebi kilikidi tubudakalelak. ");
INSERT INTO nop_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hidi adi miŋgembet diniŋ yalaki doktiŋa mede momooŋ detiŋa yoneŋ? Welehik maaneŋ dediniŋ hatak wendok tuwot mahikdi yobihitak. ");
INSERT INTO nop_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Me momooŋ adi weleŋ gineŋ nemek momooŋ hatak u miŋgoŋ yobihitak, eŋ me hogoli adi weleŋ maaneŋ nemek hogoli hatak u miŋgoŋ yobihiletik. ");
INSERT INTO nop_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Indiŋ hanimbe nadineŋ. Mede hogohi u mu nadidakaleeŋ hogok yofit tiiŋ wendok kibikoŋ kougoŋ nai wapum foloŋ Bepaŋdi hanindapmawaak. ");
INSERT INTO nop_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Medege yolaŋ wendigoŋ mebige yobihilune ganagitdok, be medege yolaŋ wendigoŋ mebige yobihilune bigabudok.” ");
INSERT INTO nop_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Unduŋ yenimbu Yodoko Mede henale noli tiŋa Falisi hekidibo indiŋ niŋgiŋ, “Henale, du Bepaŋ’walaaniŋ biyagoŋ nobu foweŋ kaŋ kudi neeŋ tubune saŋiniŋge kanim.” ");
INSERT INTO nop_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Unduŋ yogiŋ kaŋ yeniŋguk, “Metam kobuhi hidi kadakaniŋ titiŋdigoŋ kunum gineniŋ kudi titiŋdok naniiŋ. Iŋgoŋ kudi gitipmuŋ nemoŋ. Kudi adi koom polofet Jona’walaŋ mintaguk undugoŋ mintaune kaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Koom Jonadi helebufa lufomkulitniŋ pisi wapum weleŋ maaneŋ hakuk undugoŋ Me Kobumuŋ adi maaŋ koŋ maaneŋ helebufa lufomkulitniŋ halaak. ");
INSERT INTO nop_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nai wapum mintaune mede nadinadi halaakneŋ Niniwehidi mintaaŋ hidi’walaŋ mebihik yobihilune tuwaŋiŋ beneeŋ. Maŋgoŋde, adi koom Jonadi Bepaŋ’walaŋ mede yohautaune metam adi u nadiŋa welehik tubutakalegiŋ. Iŋgoŋ Me niŋ hebehik foloŋ yatak adi Jona kalakapme tilak. ");
INSERT INTO nop_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Tiŋa Sebahi’walaŋ Tam Wapme loloŋnit adi yolikweli biŋa pilali Mapme Solomondi mede nadisu-fuliŋgoŋ tiŋa yoguk u nadiwene uguk. Ale indiŋ hanimbe nadineŋ. Kobuk hebehik foloŋ yatak adi Solomon kalakapme tilak doktiŋa Bepaŋ’walaŋ nai wapum foloŋ Sebahi’walaŋ Tam Wapme adi pilali metam kobuhi hidi’walaŋ mebihik yobihilune kadakaniŋhik diniŋ kibikoŋ beneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Unduŋ yoŋa tomboyoula indiŋ yeniŋguk, “Yabap adi me niŋ weleŋ gineniŋ labuŋa wooŋ kwet ime moŋ gineŋ, kwet fiileŋ hakule titiŋdok kwet lohitaulak. ");
INSERT INTO nop_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Lohitawooŋ moŋ lohikaaŋ indiŋ yobetik, ‘Kotigoŋ wooŋ yotneneŋ fowit.’ Unduŋ yoŋa udaneeŋ wooŋ kalune yot u molomnit mokit yohumuŋ tiŋa tutumbaaŋ biŋit ");
INSERT INTO nop_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","unduŋ kaŋ kotigoŋ wooŋ yabap kadakahi hinek 7 yanagila buŋa uŋgoŋ noŋgoŋ fooŋ itounetiŋit. Unduŋ tubune me u koom yabap kubugoŋdi fomimbu hatiguk undiniŋ u wabiŋa agaŋ kisaŋ hinek kadakawetik. Undugoŋ hinek, metam kobuhi kadakaniŋ titiŋ hidi’walaŋ mintawaak.” ");
INSERT INTO nop_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu adi mede unduŋ hayenilune miŋ kwayaŋiye adi mede ninene bugiŋ, buŋa fakaŋ yakiŋ. ");
INSERT INTO nop_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kaŋ me niŋdi niŋguk, “Maŋge kwayageye mede ganine fakaŋ woomgamiiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Unduŋ yobune Jesudibo indiŋ niŋguk, “Maane kwayaneye nedigoŋ?” ");
INSERT INTO nop_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Unduŋ yoŋa mihiŋiye yakiŋneŋkade kohodidim youla indiŋ yoguk, “Nu maane kwayaneye adi iŋak. ");
INSERT INTO nop_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Metam nediyeŋ Batne kunum gineŋ hatilak’walaŋ maŋiŋ mede nadiŋa takaliiŋ adi yadi nu’walaŋ maaneye, kwayaneye eŋ witneye.” ");
INSERT INTO nop_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mele nai wendegoŋ Jesu adi yopmaniŋ fooŋ buŋa wooŋ imeŋgwaŋ magineŋ ikuk. ");
INSERT INTO nop_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kaŋ metam feedi wooŋ bopneune yabuŋa muwage niŋ foloŋ looŋ ikuk. Kaŋ metam bop wapum adi kiŋ foloŋ bopneeŋ yakiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kaŋ yoyout mede foloŋ mede mebimebi fee yeniŋguk. Tububihila indiŋ yoguk, “I nadineŋ, me dinina molo niŋ adi nemek yeuli yetibe moŋgola uguk. ");
INSERT INTO nop_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Moŋgo wooŋ sayoli kilik kukam unduŋ kukuk. Kulune noli talipmeŋ magiŋ kaŋ bagi hekidi kunatnagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Noli kwet kawadenit foloŋ maaŋ kwet wahiŋgoŋ doktiŋa pilap kadogiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iŋgoŋ kokoi fuluŋgoŋ mu fogiŋ doktiŋa mele diweeŋ kawade dafafaŋeune kumuŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kaŋ noli haŋginep maaneŋ maaŋ labugiŋ iŋgoŋ haŋginepdi hefulagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Noli kwet galikit foloŋ magiŋ adi kedem labuŋa folooŋ fee duhugiŋ. Tiŋa kwedei niŋ diniŋ folooŋ 100, kwedei niŋ diniŋ 60, kwedei niŋ diniŋ 30. Unduŋ mintagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Nebek niŋ adi nadidakalewe kaŋ magi baigoŋ kametnadiŋa nadiwek.” ");
INSERT INTO nop_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mede unduŋ yobune Jesu ne’niŋ mihiŋiyedi hebeŋ gineŋ buŋa indiŋ ninadigiŋ, “Du maŋgoŋde mede yoyout hogok tiŋa yenilaŋ?” ");
INSERT INTO nop_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kaŋ Jesudibo indiŋ yeniŋguk, “Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Kobuli diniŋ mede hebiniŋ hatak u Bepaŋdi agaŋ hanimbihitak, eŋ me noli adi mokoŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Iŋgoŋ nebek niŋ adi nemek miŋgiŋ u boiŋa hatibune kaŋ tomboyoulimimbune duhuduhunit tibaak, eŋ nebek niŋ adi nemek miŋgiŋ u mu kame hatibune kaŋ lomtubune hogok hatiluwaak. ");
INSERT INTO nop_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Nu indiŋ nadiŋa yoyout mede hogok yenilat. Adi kanim yo kaiŋ iŋgoŋ tuwot mu kadakaleiŋ, eŋ nadinim yoŋa nadiiŋ iŋgoŋ tuwot mu nadidakaleiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kaŋ Aisaiyadi mede indiŋ yoguk u folooŋ mintalak: ‘Magihikdi nadinadi hogok u nadineeŋ, eŋ welehikdi hinek nadidakale adi mu tineeŋ. Dauhikdi diwediwe u diweneeŋ, iŋgoŋ kadakale adi tuwot mu tineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Metam yoŋ adi welehik kwambumuŋ eŋ magihik adi agaŋ youkaulegiŋ, eŋ dauhik agaŋ tubusupmakagiŋ. Unduŋ doktiŋa dauhikdi nemek tuwot mu kadakaleiŋ, eŋ magihikdi mede tuwot mu nadidakaleiŋ, eŋ welehikdi nemek nemu nadidakale-hinakaiŋ. Unduŋ doktiŋa welehik mu tubutakaleune nu detiŋa yehitubu-kedebawit.’ ");
INSERT INTO nop_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Bepaŋdi habunadiune utumba tilak doktiŋa hehitubu-lodaune dauhikdi kadakaleiŋ eŋ magihikdi nadidakaleiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nu biyagoŋ hanilat. Koom woŋ, polofet heki tiŋa metam didimehi adi nemek hidi kobuk kaiŋ i kanim yoŋa gigine tigiŋ iŋgoŋ mu kagiŋ. Tiŋa nemek hidi kobuk nadiiŋ u nadinim yoŋa gigine tigiŋ iŋgoŋ mu nadigiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Unduŋ yoŋa tomboyoula indiŋ yeniŋguk, “Dinina molo diniŋ yoyout mede yoŋat wendiniŋ mebi indiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Me nediyeŋ Mede Momooŋ nadilak iŋgoŋ weleŋ gineŋ mu kamehatilak, adi yadi me kadakaniŋdi buŋa weleŋ gineŋ mede yeuli u kuboneeŋ beŋa ulak. Me woŋ adi yeuli moŋgola wooŋ kulune talipmeŋ magiŋ kaŋ bagi hekidi nagiŋ wendok tuwolit. ");
INSERT INTO nop_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kaŋ kiliki kawade foloŋ magiŋ woŋ adi me nediyeŋ Mede Momooŋ kedem nadigalikaaŋ kamehatilak ");
INSERT INTO nop_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","iŋgoŋ kokoi fuluŋgoŋ hinek mu foguk doktiŋa Mede Momooŋ foloŋ yayat diniŋ mede be mik-kwadi mintaune munta tiŋa Mede Momooŋ sigilulum timilak. ");
INSERT INTO nop_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kaŋ haŋginep gineŋ magiŋ woŋ adi me nediyeŋ Mede Momooŋ nadinadi u kedem tilak iŋgoŋ nadinadiŋiŋ wapum adi nemek kwetfoloŋ iŋoŋ liwewaak wendok hatak. Tiŋa me muneeŋ bomboŋnit mintadok nadilak doktiŋa nadinadiŋiŋ wendigoŋ Mede Momooŋ diniŋ galikitŋiŋ u ulatifoune nadiune folooŋ mokit tilak. ");
INSERT INTO nop_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kaŋ me nediyeŋ kwet galikit gineŋ magiŋ undiniŋ hatiiŋ adi yadi Mede Momooŋ welehik gineŋ hinek nadidahiŋa folooŋ tubumintaiŋ. Adi yadi kitili niŋ foloŋ 100, niŋ foloŋ 60, niŋ foloŋ 30, unduŋ mintataulak.” ");
INSERT INTO nop_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesudi yoyout mede kotigoŋ nimaaŋ indiŋ tomboyoula yeniŋguk, “Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ adi me niŋdi dininaŋiŋ gineŋ nanaŋe mimihi diniyetilak wendok tuwot kamekaaŋ yobit. ");
INSERT INTO nop_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Adi nanaŋe youli mimihi yetiguk ala bufaune metam hogohogok damo deihatune memikŋiŋdi buŋa nanaŋe youli moihi u mimihi baŋamneŋ uŋgoŋ yetititauguk. ");
INSERT INTO nop_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kaŋ nanaŋe mimihi u labuŋa wapuhi tiŋa folooŋ titiŋdok titaulune youli moihi yetiguk u maaŋ agaŋ labuŋa mintadakalegiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kaŋ kwanai-meŋiyedi u kaŋ buŋa indiŋ ninadigiŋ, ‘Bomboŋgi, du fiyege gineŋ nanaŋe mimihi hogok yetiguŋ, iŋgoŋ nanaŋe moihi u deŋandiŋ buŋa yakiiŋ?’ ");
INSERT INTO nop_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Unduŋ ninadiune adibo yoguk, ‘Woŋ adi nebek memiknedi yetiguk.’ “Unduŋ yobune adibo kotigoŋ indiŋ ninadigiŋ, ‘Unda kedembe wooŋ tamali moŋgoyakutnim?’ ");
INSERT INTO nop_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Unduŋ yogiŋ kaŋ bomboŋgihikdi indiŋ yeniŋguk, ‘Nanaŋe moihi tamakam yoŋa mimihi tamatneneŋ doktiŋa biyabune uŋgoŋ yatneŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ala kougoŋ folooŋ mintaune yabudidimeeŋ nanaŋe moŋgotnadok nai foloŋ me nanaŋe moŋgomoŋgot heki yenimbene wooŋ moihi u tamali ibidokooŋ beyakulune kudup gineŋ daneeŋ. Kaŋ mimihi nanaŋdok u moŋgola buŋa yopmaŋ bopneneeŋ.’” ");
INSERT INTO nop_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Unduŋ yoŋa yoyout mede nimaaŋ indiŋ tomboyoula yeniŋguk, “Bepaŋ’walaŋ Hatihati Kobuli adi mastat kilik undiniŋ. Ala me niŋdi tiŋa wooŋ fiyeŋiŋ gineŋ yetilak. ");
INSERT INTO nop_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kiliki woŋ adi kuyaniŋ kabe, kiliki noli yetiyam wendok tuwolit moŋ. Iŋgoŋ mindaŋ mastatdi looŋ wapum tiŋa nemenemek noli yetiyam u yalakapme tiŋa yalune bagi heki adi buŋa taŋeniŋ foloŋ uŋgoŋ deipilat tiiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Koti tomboyoula yoyout mede nimaaŋ indiŋ yeniŋguk, “Bepaŋ’walaŋ Hatihati Kobuli adi tam niŋdi belet tububedidok haguwo u palawa dut miŋobuŋa bikabune hali bedi tilak undiniŋ.” ");
INSERT INTO nop_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu adi metam mede didimeŋgoŋ be miŋgilaŋgoŋ hogok mu yeniluguk. Adi yoyout mede foloŋ kameeŋ yeniluguk. ");
INSERT INTO nop_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Unduŋ tubune polofetdi indiŋ yoguk u folooŋ mintaguk, “Mane gineŋ adi yoyout mede hogok mintaune yobaat. Mede hebiniŋ kwet tububihila mintagukneniŋ halilabu hatak u yohautawaat.” ");
INSERT INTO nop_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesu adi unduŋ yodapmaaŋ metam yapmeune ulune yolineŋ loguk. Kaŋ mihiŋiye adi looŋ indiŋ ninadigiŋ, “Du dinina gineŋ nanaŋe mimihi yetibune nanaŋe moihi maaŋ labugiŋ, yoyout mede unduŋ yoŋaŋ wendiniŋ mebi kedembe ninimbeŋ?” ");
INSERT INTO nop_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Unduŋ ninadiune yeniŋguk, “Me nanaŋe momohi yetilak woŋ adi Me Kobumuŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Eŋ dinina woŋ adi kwet wapum hali ulak wanakaŋ. Kaŋ nanaŋe youli mimihi woŋ adi metam kunumdok gigit hatiiŋ. Eŋ nanaŋe youli moihi woŋ adi me hogoli’walaŋ metamŋiye. ");
INSERT INTO nop_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mikme nanaŋe moihi yetiguk woŋ adi Sadaŋ. Eŋ moŋgotnadok nai woŋ adi nai wapum, kaŋ kwanai-me adi aŋelo heki. ");
INSERT INTO nop_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nanaŋe moihi tamali ibidokooŋ bekulune kudup gineŋ daneeŋ u nai wapum foloŋ mintawaak. ");
INSERT INTO nop_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nai uŋaniŋ Me Kobumuŋdi aŋeloŋiye yeniŋkulune kwetkwet wooŋ nemenemek metam yalamut tubune kadakaniŋ tiiŋ be metam kadakaniŋ titiŋ heki u wanakaŋ hogohogok yanagi bopneeŋ ");
INSERT INTO nop_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kudup wapum gineŋ beyakulune foneeŋ. Uŋoŋ fooŋ folofigita nadiŋa mahik sikilitiŋa makat kobulabulaye tineeŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kaŋ metam didimehi adi yadi Behik’walaŋ kwet kulemaŋ gineŋ wooŋ meledi diwehautalak nabugoŋ diwehautayaneeŋ. “Nebek niŋ adi nadidakalewe kaŋ magi baigoŋ kametnadiŋa nadiwek.” ");
INSERT INTO nop_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Unduŋ yoŋa indiŋ tomboyoula yoguk, “Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ adi muneeŋ bogit niŋ dinina gineŋ wenefulagiŋ undiniŋ. Kaŋ me niŋdi u katubumintaaŋ nadifo tiŋa kotigoŋ uŋgoŋ kufulaŋa wooŋ nemenemekŋiŋ hogohogok tuwadok boiune tuwaune muneeŋ u beŋa wooŋ dinina u tuwaguk. ");
INSERT INTO nop_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ adi me niŋdi fukut tuwawene kiyauguk undiniŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ala wooŋ fukut momooŋ hinek niŋ tubumintaaŋ wooŋ nemenemekŋiŋ hogohogok tuwadok boiune tuwaune muneeŋ beŋa wooŋ fukut u tuwaguk.” ");
INSERT INTO nop_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Unduŋ yoŋa indiŋ tomboyoula yoguk, “Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ adi umben ime gineŋ kameune halune ime diniŋ kale uŋgoniŋ uŋgoniŋ bufolak undiniŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ala umben u ime diniŋ kale mebimebidi fotokoune tiŋa wooŋ giineŋ wenekula kale nanaŋdok heki u beŋa kabot wapum gineŋ kadahigiŋ. Eŋ kale mu nanaŋdok heki u beyakulune ime gineŋ fogiŋ. ");
INSERT INTO nop_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kwet i dapmawaakneŋ nemek unduku mintawaak oŋ. Aŋelo hekidi kwetkwet udapmaaŋ metam nadisukilitihinit lekiŋgoŋhik gineŋ metam hogohi hogohogok u yanagila ");
INSERT INTO nop_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kudumebem wapum gineŋ yakulune foneeŋ. Uŋoŋ fooŋ folofigita nadiŋa mahik sikilitiŋa masiŋkilip tiŋa kobulabulaye tihatiyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Unduŋ yodapmaaŋ yeninadiguk, “Hidi u hanilat hogohogok u abe nadidakaleiŋ?” Unduŋ yeninadiune yogiŋ, “Eeŋ, agaŋ nadidakaleyam.” ");
INSERT INTO nop_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Unduŋ yobune yeniŋguk, “Yodoko Mede henale niŋdi Bepaŋ’walaŋ Hatihati Uŋgoniŋ diniŋ mebi nadidakalelak, adi yadi me yot molom dabugoŋ. Yot molom adi metamdi kaneŋ yoŋa tinaulibi yotŋiŋ maaneŋ fooŋ bomboŋ komi be kobuli moŋgo fooŋ boilak undiniŋ.” ");
INSERT INTO nop_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu adi yoyout mede unduŋ yodapmaaŋ kwet u bikabuŋa yolikwelide uguk. ");
INSERT INTO nop_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Uŋoŋ wooŋ Judahi’walaŋ bopyotneŋ fooŋ Mede Momooŋ yenindidimeune metam adi u nadiŋa boho tiŋa indiŋ yogiŋ. “Nadinadi wapum tiŋa kudi titiŋ uŋgoniŋ hinek i daŋ beŋak? ");
INSERT INTO nop_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Indi me i agaŋ nadimiyam, adi yadi kamunda mihiŋiŋ eŋ miŋ adi Maliya, kaŋ kwayaŋiye wohiye adi Jems, Josep, Saimon eŋ Juda. ");
INSERT INTO nop_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tiŋa wiwiye indegut noŋgoŋ hatiyam. Iŋgoŋ adi nemenemek hogohogok i daŋ beguk?” ");
INSERT INTO nop_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Unduŋ yoŋa kahaŋinda tiŋa nadilakata timiŋgiŋ. Unduŋ tigiŋ kaŋ Jesudi indiŋ yeniŋguk, “Polofet adi metam kwet niŋkadehi kahaŋinda mu tiiŋ iŋgoŋ yolikwelineŋ meŋimeŋiye nehi adi kahaŋinda tiiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Metam uŋahi adi mu nadisukilitimiŋgiŋ doktiŋa adi’walaŋ uŋoŋ kudi fee mu tuguk. ");
INSERT INTO nop_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nai uŋaniŋ Galilihi’walaŋ me mapme Helot adi Jesu’walaŋ gigitŋiŋ nadiguk. ");
INSERT INTO nop_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","U nadiŋa talitimeŋ noliŋiye indiŋ yeniŋguk, “Woŋ adi Jon Imeyout Tububihit. Adi kotigoŋ kumuŋ gineniŋ kaikaaŋ pilakuk doktiŋa kudi saŋiniŋnit hinek tilak.” ");
INSERT INTO nop_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mede u hogok yofit mu tuguk. Adi koom dali Filip’walaŋ tamŋiŋ Helodiya lom nagikuk. Kaŋ Jondi niŋguk, “Du tam u nagikuŋ woŋ adi yom tuguŋ.” Unduŋ hogok nilu nilu Helotdi kwihitaaŋ mikmeŋiye yenimbune wooŋ Jon nagila buŋa tawa fafaŋeniŋdi ibidokooŋ yot fafaŋeniŋneŋ kamegiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kaŋ Helotdi Jon ulukumuŋdok nadisuguk, iŋgoŋ metamdi polofet niyagiŋ dokti metamdok muntaaŋ wabiguk. ");
INSERT INTO nop_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ala Helot’walaŋ mintaminta nai foloŋ metam buŋa bopneeŋ itune Helodiya waabiŋiŋ adi buŋa namandahik foloŋ kap momooŋ hinek miyeune Helotdi kanadiune utumbaune indiŋ niŋguk, ");
INSERT INTO nop_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“Nu Bepaŋ dawineŋ biyagoŋ hinek yofafaŋelat, du nemek niŋdok nadiŋa nanimbune kedem gambit.” ");
INSERT INTO nop_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kaŋ miŋdi nadinadi miŋa niŋgigineune buŋa indiŋ yoguk, “Jon Imeyout Tububihit’walaŋ mebi maliŋ foloŋ kobuk yuku kameeŋ tibu namuliweŋ!” ");
INSERT INTO nop_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Unduŋ yobune bulaniŋgoŋ wapum nadiŋa welemulap tuguk, iŋgoŋ moŋ deti nimbek, agaŋ Bepaŋ be metam namandahik foloŋ mede yofafaŋe tuguk doktiŋa fiit nadimiŋguk. ");
INSERT INTO nop_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tiŋa yobune mikmeŋiyedi wooŋ Jon yot fafaŋeniŋneŋ hakuk u kodi udokooŋ ");
INSERT INTO nop_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mebi maliŋ foloŋ kameeŋ tiŋa bu waabi u miŋgiŋ. Kaŋ adibo tiŋa wooŋ miŋdok mimbune kaŋ nadihakale tuguk. ");
INSERT INTO nop_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kaŋ Jon mihiŋiyedi wooŋ sigiŋ gitnem u bemŋa wooŋ wenefulagiŋ. Unduŋ tiŋa wooŋ Jesu mede kahat timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesu adi Jon’walaŋ mede kahat unduŋ nadiŋa kwet u bikabuŋa muwage niŋ foloŋ looŋ imeŋgwaŋ fokolok losuwaaŋ kwet fiileŋ nehogok hatibe uguk. Kaŋ metam adi u nadiŋa yohikwehik biyabuŋa imeŋgwaŋ gaga tabe keleeŋ wooŋ wosuwagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kaŋ muwage gineniŋ tatakula fooŋ metam bop wapum u yabuŋa weleŋ goloune bulaniŋgoŋ nadiyemiŋa metam yagithinit u yehitubu-kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Unduŋ hati tulune mele udaneune tebeledaguk, kaŋ mihiŋiyedi wooŋ niŋgiŋ, “I kwet fiileŋ hatnene agaŋ tebele tilak, ale metam yeniŋkulune yokwet gineŋ wooŋ nanaŋe tuwanaŋ tineŋ.” ");
INSERT INTO nop_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Unduŋ yogiŋ kaŋ yeniŋguk, “Maŋgoŋde uneŋ yoŋa yeniŋkukiiŋ? Hidi hide nemek nanaŋdok neeŋ yembu naneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Unduŋ yenimbune yogiŋ, “Indi adi belet yawe kohofukuŋ eŋ pisi lufom hogok boihakam.” ");
INSERT INTO nop_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Unduŋ yogiŋ kaŋ yeniŋguk, “Unda u moŋgola nu’walaŋ iŋgoŋ buneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Unduŋ yoŋa metam yenimbune kilihikit momooŋ foloŋ fooŋ ilaugiŋ. Kaŋ belet yawe kohofukuŋ eŋ pisi lufomuk u moŋgola dadiyeeŋ kunum foloŋ diweeŋ Bepaŋ niutumbaaŋ metam daneyemdok yoŋa wobuŋa mihiŋiye yembune daneeŋ metam yemtaune nagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kaŋ metam hogohogok naaŋ tuwot tubune mihiŋiyedi nadikidiki u bondibondi 12 kadahitokogiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Me kale nanaŋe u nagiŋ adi yokunathik 5 tausen, eŋ tamwoi tiŋa wapmihi adi mu yehikunakiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Unduŋ tiŋa nai uŋaniŋgoŋ Jesudi mihiŋiye yeniŋkulune nehi hogok imeŋgwaŋ fukuniŋ lone muwage foloŋ looŋ timeŋ ila ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kaŋ adi metam yeniŋkulune udapmaune nehogok tuwai foloŋ looŋ Bepaŋ ninadi hatuguk. Unduŋ hati tulune bufaune nehogok uŋgoŋ hatiguk. ");
INSERT INTO nop_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kaŋ nai uŋaniŋ muwage adi imeŋgwaŋ lekiŋgoŋ hinek uguk. Kaŋ fifiŋgobutdi adi ugiŋneŋkade fedila buŋa ime tubugiyondaaŋ muwagehik u tiloŋafoŋat kisaŋ tiyemguk. ");
INSERT INTO nop_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Unduŋ tubune ila ulune helehelede Jesu adi ime tabe foloniŋgoŋ yalitawooŋ yehitubu-dulaguk. ");
INSERT INTO nop_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kaŋ mihiŋiye adi u kaŋ munta kisaŋ tiŋa saŋiniŋhik gweheyeune yogiŋ, “Ya momolokdi bulak.” Yoŋa yakawe kisaŋ togiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yakawe totigiŋ kaŋ Jesudi yeniŋkulemaaŋ yeniŋguk, “Fafaŋe tiŋa itneŋ. Nagoŋ bulat ale munta mu tineŋ.” ");
INSERT INTO nop_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Unduŋ yobune Pitadi yoguk, “Wapum, biyagoŋ hinek dagoŋ nobu buluweŋ kaŋ yobune ime tabe foloniŋgoŋ yalitawooŋ gabit.” ");
INSERT INTO nop_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Unduŋ yobune Jesudi yoguk, “Kedem ale beŋ.” Unduŋ yobune Pita adi muwage gineniŋ fooŋ imeŋgwaŋ tabe Jesu yakukneŋkade uguk. ");
INSERT INTO nop_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kedem uguk iŋgoŋ sububa wapum fedila ime tubugiyondaune u kaŋ muntaaŋ ime maaneŋ fowe tiŋa moŋ kaŋ katiŋa yoguk, “Wapum, nehitubu-lodaluweŋ!” ");
INSERT INTO nop_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Unduŋ katibune Jesudi pilap hinek wooŋ kohoŋ foloŋ honeeŋ niŋguk, “Nadisukilitige gilaŋgilaŋ, du maŋgoŋde welelufom tilaŋ?” ");
INSERT INTO nop_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Unduŋ niŋa muwage foloŋ logumuk kaŋ sububa wapum buguk u wabiŋa kulemaguk. ");
INSERT INTO nop_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Unduŋ tubune Jesu mihiŋiye noli muwage foloŋ ikiŋ adi Jesu hebeŋ foloŋ mulelem timiŋa nintilooŋ indiŋ niŋgiŋ, “Du biyagoŋ hinek Bepaŋ mihiŋiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Unduŋ tiŋa imeŋgwaŋ u meŋeŋa ime fokolok Genesalet kwetneŋ kiŋ foloŋ losuwagiŋ, ");
INSERT INTO nop_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","kaŋ metam adi Jesu kakiyondaaŋ mede kameu yokwet magimagi ila ugiŋ indigoŋ tuwot udapmaune metam yagithinit yahaŋeeŋ bugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Buŋa Jesu dahidahiŋiŋ diki hogok honeeŋ kedebadok ninadigiŋ. Kaŋ metam nediyeŋ dahidahiŋiŋ diki honegiŋ adi kedeba-utumba tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nai uŋaniŋ Falisi tiŋa Yodoko Mede henale Jelusalemhi noli adi Jesu’walaŋ buŋa indiŋ ninadigiŋ, ");
INSERT INTO nop_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dediŋ doktiŋa mihigeye adi wapuhiniye’walaŋ titiŋhik diniŋ yodoko u lahukiiŋ? Tiŋa nanaŋe nanaŋdok kohohik mu youtewalandaaŋ hogok naiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Unduŋ ninadiune Jesudi indiŋ yeniŋguk, “Kaŋ hidi maŋgoŋde hide’walaŋ mahik mede tagimneeŋ Bepaŋ’walaŋ maŋiŋ mede lahukiiŋ? ");
INSERT INTO nop_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bepaŋ’walaŋ mede indiŋ hatak, ‘Du maŋge baha’walaŋ mahik mede tagimneluwaaŋ.’ Tiŋa noli maaŋ indiŋ, ‘Nebek niŋdi mimbeu medehaki yenimbune kaŋ ulukumuŋ titiŋdok.’ ");
INSERT INTO nop_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Unduŋ hatak iŋgoŋ hidi adi indiŋ yoiŋ, ‘Nebek niŋdi miŋ be beu indiŋ nimbetik: Nemek du gamuŋa gehiulihidok u agaŋ Bepaŋdok siloŋ timilat, ");
INSERT INTO nop_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","adi unduŋ kedem yoŋa mimbeu mu yehitubu-lodaluwaak.’ Hidi unduŋ tiŋa Bepaŋ’walaŋ mede yotubufit tiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yalaŋ-me hidi! Koom polofet Aisaiyadi hiditok-ku mede biyagoŋ hinek indiŋ yoguk, ");
INSERT INTO nop_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mebop heki yeŋ-adi mahikdi hogok naniutumbaaŋ welehikdi mu nabukahileiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tiŋa Bepaŋ’walaŋ mede yoŋa kwetfoloŋ me’walaŋ mede keleŋila nu naniutumbaiŋ wondi folooŋnit mokit tilak.’” ");
INSERT INTO nop_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Unduŋ tiŋa Jesudi metambop wapum noli maaŋ kutiyenimbune buŋa bopneune indiŋ yeniŋguk, “Nu mede i hanimbene nadiŋa nadidakale hinek tineŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nemek mahik gineŋ folak wendi kadakaniŋ mu tilak, nemek toboniŋ mahik gineŋkade labulak wendi kadakaniŋ tilak.” ");
INSERT INTO nop_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Unduŋ yoguk kaŋ mihiŋiyedi wooŋ niŋgiŋ, “Falisi heki adi du mede yoŋaŋ u nadiŋa nadikadaka tigamŋit, u maaŋbe nadilaŋ?” ");
INSERT INTO nop_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Unduŋ yobune yeniŋguk, “Bem hogohogok batne kunum foloŋ hatilakdi mu yetiguk u tamali beŋa yakut titiŋdok. ");
INSERT INTO nop_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hidi me undihidok nadibedi mu tineŋ, adi dauhik sipmakahi doktiŋa dausipmik heki’walaŋ talitimeŋhiye. Me niŋ dawi sipmakaŋ adi noliŋiŋ niŋ dawi sipmakaŋ tuwot mu nagila talik nindidimeeŋ udemek. Unduŋ tiŋa wooŋ adi ham gineŋ noŋgoŋ mademek.” ");
INSERT INTO nop_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kaŋ Pitadi indiŋ niŋguk, “Yoyout mede niniŋaŋ wendiniŋ mebi maaŋ ninimbune nadinim.” ");
INSERT INTO nop_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yobune Jesudi yoguk, “Kei! Be hidi maaŋ undugoŋ nadisuhinit mokit hatiiŋ! ");
INSERT INTO nop_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mede i deti mu nadidakaleiŋ? Mahikdi nemek naune maaneŋ foune kabahikdi daneune taliineŋ fooŋ dapmaaŋ ulak. ");
INSERT INTO nop_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Eŋ nemek welehik maaneŋniŋ mahik gineŋ labulak wendi kadakaniŋ tilak. ");
INSERT INTO nop_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kadakaniŋ indihi: Nadisu hogohi, mehinek widihikumuŋ, hekimalam kikabi, metam kefifile, siloda, kubo, yalaŋ mede, mede hogohi yoŋa Bepaŋ nimpekit titiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nemenemek wendi hehitubu-kadakalak. Eŋ kohohik mu youtela nanaŋe benaiŋ wendi mu hehitubu-kadakalak.” ");
INSERT INTO nop_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kaŋ Jesu adi kwet u bikabuŋa kwet wapum Taiya dut Saidon yokwet ikumukneŋ uguk. ");
INSERT INTO nop_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Uŋoŋ wooŋ hatilune me Kanahanhi Judahi’walaŋ feknit mokit hatiyagiŋneniŋ tam niŋdi buŋa kutnimbulabulayeeŋ yoguk, “Wapum, du Dewit’walaŋ yalakidi nutok tiŋa bulaniŋgoŋ nadiweŋ. Nu waabine yabapdi fomiŋa helemahelemaŋ kisaŋ hinek tubukadakalak.” ");
INSERT INTO nop_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Unduŋ yobune Jesudi u nadiŋa mede toboniŋ nemu tubu-udanemiŋguk. Unduŋ tubune mihiŋiyedibo niŋgiŋ, “Tam siginineŋ i katiŋa nihikelelak i niŋkulune wek.” ");
INSERT INTO nop_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Unduŋ niŋgiŋ kaŋ yeniŋguk, “Nu adi Isilaehi dompa fiit tigiŋ hekidok hogok napmeune bugut.” ");
INSERT INTO nop_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Unduŋ yolune tam u buŋa hebeŋ gineŋ mulelem timiŋa ninadiguk, “Wapum, du fiit nehitubu-lodaweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Unduŋ yobune Jesudi indiŋ niŋguk, “Wapmihi’walaŋ nanaŋe yolom beŋa kamo yehitoine tuwot mu tibek.” ");
INSERT INTO nop_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Unduŋ yobune mede toboniŋ indiŋ tubu-udanemiŋguk, “Wapum, u biyagoŋ yolaŋ, iŋgoŋ kamo heki adi molohiyedi falikhik foloŋ nanaŋe natubumaŋ tubune munamunam uŋakoŋ fiit naiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Unduŋ yobune niŋguk, “O tam, nadisukilitige wapum hinek! Ale nemek mintagamdok nadi yolaŋ undugoŋ hinek mintagambek.” Unduŋ yolune nai uŋaniŋgoŋ waabiŋiŋ kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kaŋ Jesu adi kwet u bikabuŋa kotigoŋ udaneeŋ buŋa Galili imeŋgwaŋneŋ busuwaguk. Busuwaaŋ looŋ tuwai foloŋ itune metam bop wapumdi adi’walaŋkade bumiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Adi me kayohik hogohi eŋ me kohohik gweheyehi tiŋa bubuyehi eŋ metam yagit folofigitahinit eŋ dauhik sipmakahi yanagila buŋa Jesu hebeŋ foloŋ bopneune yehitubu-kedebadapmaguk. ");
INSERT INTO nop_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kaŋ bubuyehidi mede yogiŋ eŋ kayohik kadakahidi talik yaugiŋ eŋ kohohik gweheyehidi fafaŋegiŋ eŋ dauhik sipmakahidi diwedakale tigiŋ. Kaŋ metam adi u yabuŋa boho tiŋa Isilaehi’walaŋ Bepaŋ niutumbagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesudi mihiŋiye yehibopneeŋ yeniŋguk, “Metam i nukut buŋa hatibune helebufa lufomkulitniŋ tilak, kaŋ nanaŋehik agaŋ dapmaune map tubu yabuŋa bulaniŋgoŋ nadiyemilat. Nu hogok hinek yeniŋkulene wooŋ talipmeŋ nanaŋedok map tiŋa daukukut tineeneŋ yoŋa nadibedi tilat.” ");
INSERT INTO nop_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Unduŋ yeniŋguk kaŋ mihiŋiyedi indiŋ yogiŋ, “Kwet fileŋ indineŋ nanaŋe deŋgoŋ tubumintaaŋ metam bop wapum indiniŋ yemnene natoki tineŋ?” ");
INSERT INTO nop_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Unduŋ nimbune adibo yeninadiguk, “Hide’walaŋ belet dedigoŋ boihakiiŋ?” Kaŋ adibo yogiŋ, “7 hogok tiŋa pisi-kabe lufomgoŋ.” ");
INSERT INTO nop_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","U nadiŋa metam yenimbune kwetfoloŋ fooŋ ila ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kaŋ adi belet 7 tiŋa pisi u moŋgola Bepaŋ niutumbaaŋ wobuŋa mihiŋiye yembune adibo beŋa metam yembune nagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Metam hogohogok wanakaŋ naaŋ tuwot tigiŋ. Kaŋ nanaŋe nadikidiki tigiŋ u Jesu mihiŋiyedi beŋa bondibondi 7 kadahitokogiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nanaŋe u nagiŋ me yokunathik 4 tausen, eŋ tam tiŋa wapmihi adi mu yehikunakiŋ. ");
INSERT INTO nop_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Unduŋ tiŋa metam yeniŋkulune uune Jesu adi mihiŋiye dut muwage gineŋ looŋ wooŋ Magadan kwetneŋ ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kaŋ Falisi tiŋa Sadusi heki adi Jesu’walaŋ buŋa talamula indiŋ yogiŋ, “Du Bepaŋ’walaaniŋ biyagoŋ nobu foweŋ kaŋ kudi neeŋ tubune saŋiniŋge kanim.” ");
INSERT INTO nop_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Unduŋ yogiŋ kaŋ yeniŋguk, “Hidi tebele mele fohebiwene tiŋila giminiŋ diwelak kaŋ yoiŋ, ‘Haloŋ meleyaŋ yalek.’ ");
INSERT INTO nop_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Be haniŋ fooŋ kaune kunum gouyeŋ kwet mambimambip hatubune yoiŋ, ‘Gwi ulek.’ Hidi kunum foloŋ nai dediniŋ helewek be helelak u kedem kakiyondaaŋ yoiŋ, iŋgoŋ nai yendok mebi mu kanadiiŋ? ");
INSERT INTO nop_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Metam kobuhi hidi kadakaniŋ titiŋdigoŋ kunum gineniŋ kudi tibe kakaŋdok naniiŋ. Iŋgoŋ kudi gitipmuŋ nemoŋ. Kudi adi koom Jona’walaŋ mintaguk undugoŋ mintaune kaneeŋ.” Jesu adi unduŋ yeniŋa biyabuŋa uguk. ");
INSERT INTO nop_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mihiŋiye adi belet nemu moŋgola Jesu dut ime fokolok losuwaaŋ kougoŋ naditomgiŋ. Kaŋ Jesudi indiŋ yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Hidi Falisi tiŋa Sadusi heki’walaŋ belet tububedidok haguwo gineŋ ala nadinadiŋale hatiyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Unduŋ yenimbu nehi uŋgoŋ kiyonadi tiŋa indiŋ yogiŋ, “Indi belet nemu moŋgo bumun doktiŋa unduŋ ninilak.” ");
INSERT INTO nop_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kaŋ Jesudi maŋgoŋdok kiyonadigiŋ u agaŋ nadiŋa yeniŋguk, “Nadisukilitihik kuyaniŋ-kabe hidi! Hidi maŋgoŋde belet kauleeŋ biyabuŋa buŋit wendok yonadiiŋ? ");
INSERT INTO nop_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mede i mube nadidakaleiŋ? Nu kudi tugut u agaŋ kaulebe tiiŋ? Nu belet 5-di me 5 tausen yemtoi tibe naaŋ tuwot tubune nadikidiki bondibondi dedigoŋ yehitubu-tokogiŋ? ");
INSERT INTO nop_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nu belet yawe 7-di me 4 tausen yemtoi tibe naaŋ tuwot tubune nadikidiki bondibondi dedigoŋ yehitubu-tokogiŋ? ");
INSERT INTO nop_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nu adi beletdok mu haniŋat, kaŋ hidi detiŋa mu nadidakaleŋit? Nu adi Falisi tiŋa Sadusi heki’walaŋ belet tububedidok haguwo gineŋ ala nadinadiŋale hatidok wendok hanilat.” ");
INSERT INTO nop_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Unduŋ yenimbu mihiŋiye adi kougoŋ naditomuŋa yogiŋ, “O, adi yadi belet tububedidok haguwo wendok mu yoŋak, adi Falisi tiŋa Sadusi heki diniŋ mede yoyo tiŋa titiŋhik wendok nadiŋa yoŋak.” ");
INSERT INTO nop_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesu tiŋa mihiŋiye adi Sisaliya Filipai yokwet u tubudulaŋila mihiŋiye indiŋ yeninadiguk, “Metamdi Me Kobumuŋ, nutok dediŋ naniiŋ?” ");
INSERT INTO nop_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kaŋ adibo niŋgiŋ, “Nolidi Jon Imeyout Tububihit yoiŋ eŋ nolidi Ilaija yoiŋ, eŋ nolidi Jelemaiya yoiŋ, kaŋ nolidi polofet niŋ unduŋ yoiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Unduŋ yobune nehibo yeninadiguk, “Kaŋ hidi hide nutok dediŋ naniiŋ?” ");
INSERT INTO nop_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Unduŋ yeninadiune Pitadi yoguk, “Du adi Kilisto, Bepaŋ Hatihatinit’walaŋ Mihiŋiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Unduŋ yobune Jesudi niŋguk, “Saimon Jon mihiŋiŋ, Bepaŋdi gabunadiune utumba tilak, nadinadi yoŋ adi kwetfoloŋ me’walaniŋ mu tiŋa yolaŋ, yoŋ adi kunum batnedi ganindakaleguk. ");
INSERT INTO nop_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Unduŋ doktiŋa ganimbe nadiweŋ. Du wohoge Pita, doktiŋa nu kawade hakat wondok foloŋ kayoŋbopneye yapmewene kumuŋ fafaŋeŋ diniŋ saŋiniŋdi mu yehitubu-kadakawaak. ");
INSERT INTO nop_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tiŋa undugoŋ nu Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ diniŋ yeme youdilitom hogohogok u gambit, doktiŋa du kwetfoloŋ iŋoŋ yokamehep kwanai tuluwaaŋ u kunum foloŋ maaŋ undugoŋ hinek mintaluwaak, be kwetfoloŋ iŋoŋ yodapmandapmaŋ kwanai tuluwaaŋ kaŋ kunum foloŋ maaŋ undugoŋ hinek mintaluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Unduŋ tiŋa mihiŋiye u adi Kilisto hatilak u nebek nemu yenimbihilune nadidok yoŋa yeniŋkamehep tuguk. ");
INSERT INTO nop_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nai uŋaniŋ tububihila mihiŋiye nemek mintamimbaak wendok indiŋ yenimbihikuk. Jelusalem uŋoŋ uune Siloŋyot diniŋ talitimeŋ wapum heki eŋ Yodoko Mede henale heki tiŋa Judahi’walaŋ me wapuhi noli adi medeŋiŋ mu nadiŋa folofigita wapum miŋa ulukumuneeŋ, iŋgoŋ helebufa lufomkulitniŋ dapmaune kotigoŋ kumuŋ gineniŋ kaikaaŋ pilalaak. ");
INSERT INTO nop_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kaŋ Pitadi Jesu ne hogok nagila wooŋ indiŋ niheguk, “Wapum, Bepaŋdi gehitubu-lodaune nemek undiniŋ mu hinek mintagambaak.” ");
INSERT INTO nop_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Unduŋ nimbune udaneeŋ niŋguk, “Sadaŋ, du tabaweŋ! Du talik kamehep tinamulaŋ. Du mede yolaŋ woŋ adi Bepaŋ’walaŋ mede moŋ, woŋ adi kwetfoloŋ me’walaŋ hogok.” ");
INSERT INTO nop_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Unduŋ yoŋa Jesudi tomboyoula mihiŋiye indiŋ yeniŋguk, “Nebek niŋdi nu nehikelewene nadiŋa ne’walaŋ weleŋ diniŋ be sigiŋ diniŋ nadinadi wabidapmaaŋ helemahelemaŋ koloŋdabekŋiŋ bemŋa nu nehikeleluwaak. ");
INSERT INTO nop_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nebek niŋdi hatihatiŋiŋ netok kahilewaak, adi hatihatiŋiŋ filimimbaak. Eŋ nebek niŋdi nutok tiŋa hatihatiŋiŋ bikabaak, adi hatihati tubumintawaak. ");
INSERT INTO nop_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Me niŋ adi Bepaŋ sigilulum timiŋa kwetfoloŋ diniŋ bomboŋdok nadigalika kisaŋ tubune munabuliŋiŋ kumumbune undiniŋgoŋ kotigoŋ deti tubumintawaak? ");
INSERT INTO nop_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nadiiŋ be! Me Kobumuŋ adi Beu’walaŋ hauta wapumnit tiŋa aŋeloŋiye dut wanakaŋ buneeŋ. Nai uŋaniŋgoŋ titiŋhik diniŋ tuwolit indigoŋ kibikoŋ tubu-udaneyembaak. ");
INSERT INTO nop_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nu biyagoŋ hinek hanilat. Metam i ikiiŋ noli adi kumuŋ mu tiŋa hogok hatilune Me Kobumuŋ adi mapme loloŋnit miŋgilaŋgoŋ mintaune kaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jesu adi melenai 6 hatiŋa Pita, Jems agaŋ kwayaŋ Jon adi hogok yanagila kweboboe kweheyeniŋ niŋ foloŋ logiŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Looŋ hali kalune Jesu namanda uŋgoniŋ tuguk. Tiŋa namanda adi meledi diwehautalak wendok tuwot hautaguk, tiŋa tinahukutŋiŋ adi hauta nabugoŋ fafau niyaniyaŋ hinek diweguk. ");
INSERT INTO nop_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Unduŋ tubune yakalune nai uŋaniŋgoŋ Moses tiŋa Ilaijadi maaŋ uŋgoŋ mintaaŋ Jesu dut mede yonadi ya tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kaŋ Pitadi Jesu indiŋ niŋguk, “Wapum, kedem hinek indi maaŋ iŋgoŋ hakam. Ale nadiune yoholaŋ lufomkulitniŋ mawit, noli dutok, noli Mosesdok eŋ noli Ilaijadok.” ");
INSERT INTO nop_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Unduŋ yayolune nai uŋaniŋgoŋ mulukwaŋ fafau niyaniyaŋ hinek niŋdi fooŋ yehitumukuk. Kaŋ mulukwaŋ gineŋ mede niŋ indiŋ mintaune nadigiŋ, “Yadi na’walaŋ Mihine hinek, welenedi kahilelat. Tiŋa aditok nadiwe utumba tilak. Ale hidi adi’walaŋ medeŋiŋ nadimiyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mihiŋiye adi mede u nadiŋa muntaaŋ maaŋ fooŋ namandahik kwetfoloŋ tubuwopmobula hehele ha-tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kaŋ Jesudi yamaiŋgoŋ buŋa yohoneeŋ yeniŋguk, “Hehele wabiŋa pilatneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Unduŋ yenimbune pilali dadiyeeŋ nebek noli uŋoŋ nemu kagiŋ. Jesu ne hogok yalune kagiŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Unduŋ tiŋa kweboboe bikabuŋa foŋila Jesudi indiŋ yeniheŋa yeniŋguk, “Hidi nemek uŋgoniŋ hinek kaŋit i nebek nemu nimbihila hatibune Me Kobumuŋ adi kumuŋ gineniŋ kotigoŋ kaikaaŋ pilalaak.” ");
INSERT INTO nop_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Unduŋ yenimbune mihiŋiyedibo ninadigiŋ, “Maŋgoŋde Yodoko Mede henale hekidi Ilaija timeŋ baak yoiŋ?” ");
INSERT INTO nop_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yonadiune yeniŋguk, “Ilaija adi biyagoŋ timeŋ buŋa nemenemek tiulidokowaak. ");
INSERT INTO nop_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Iŋgoŋ indiŋ hanimbe nadineŋ. Ilaija adi agaŋ buŋa hatiguk iŋgoŋ metamdi mu kadakaleŋa nemek nehi nadinadi hogok takaliŋa kaka timiŋgiŋ. Undugoŋ hinek Me Kobumuŋ maaŋ timineeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kaŋ mihiŋiyedi Jon Imeyout Tububihitdok yolak unduŋ nadigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kweboboe bikabuŋa metam bop wapum hakiŋneŋ fosuwaune me niŋdi buŋa Jesu hebeŋ gineŋ mulelem timiŋa yoguk, ");
INSERT INTO nop_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Wapum, du mihinedok bulaniŋgoŋ nadiweŋ. Adi helemahelemaŋ kumuŋkaika kisaŋ tiŋa kudup foloŋ eŋ ime gineŋ maaŋ folak. ");
INSERT INTO nop_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Unduŋ doktiŋa mihigeye’walaŋ nagila bene tubukedebanim yo tiŋit iŋgoŋ mu tubukedebaŋit.” ");
INSERT INTO nop_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Unduŋ yobune Jesudi indiŋ yenintoguk, “Gweheye bilakenehi hidi, detiŋa nadisukilitihik kuyaniŋ-kabe! Nai dedigoŋ hidut hatiŋa hanimbe nadisukilitineeŋ? Mihi u nagila iŋgoŋ but!” ");
INSERT INTO nop_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Unduŋ yenimbune nagila bugiŋ kaŋ Jesudi yabap hogoli u niŋkulune mihi u bikabuŋa labuŋa uguk, kaŋ nai uŋaniŋgoŋ mihi u utumbaguk. ");
INSERT INTO nop_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kaŋ mihiŋiye adi nehi hogok hinek wooŋ Jesu indiŋ ninadigiŋ, “Indi dediŋ doktiŋa yabap hogoli u niŋkelekutdok kwanaimiŋ tumun?” ");
INSERT INTO nop_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Unduŋ ninadigiŋ kaŋ yeniŋguk, “Hidi nadisukilitihik gilaŋgilaŋ. Nu biyagoŋ hinek hanilat. Nadisukilitihik-kabe mastat kilik undiniŋ halune kweboboe i kedem nineŋ, ‘Du kwet i tabaaŋ wooŋ gwaŋ yat.’ Unduŋ nimbune kedem wek. Hidi nemek niŋ titiŋdok tuwot mu tubumalabudaneŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yabap undihi yehikelekutdok talik noli nemoŋ. Talik kubugoŋ adi nanaŋe kameheŋa ninadi kwanai tiŋa kedem yehikelekutdok.” ");
INSERT INTO nop_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hatigene Galili kwetneŋ uŋoŋ Jesu mihiŋiye buŋa bopnegiŋ kaŋ indiŋ yeniŋguk, “Me Kobumuŋ adi kwetfoloŋ me’walaŋ kohohik foloŋ kameune ");
INSERT INTO nop_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ulukumuneeŋ kaŋ helebufa lufomkulitniŋ dapmaune kotigoŋ pilalaak.” Unduŋ yobune mihiŋiye adi welebulaniŋgoŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hatigene Jesu tiŋa mihiŋiye kotigoŋ udaneeŋ Kafanaum yokwetneŋ bulune me Siloŋyot diniŋ takis muneeŋ moŋgomoŋgot tagiŋ hekidi buŋa Pita indiŋ ninadigiŋ, “Du henalege Siloŋyotdok takis muneeŋ maaŋbe kamelak?” ");
INSERT INTO nop_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kaŋ Pitadibo yeniŋguk, “Eeŋ, uŋgoŋ kamelak.” Unduŋ yeniŋa Pita yot maaneŋ fooŋ mede nemu nilune Jesudigoŋ tububihila niŋguk, “Saimon, du dediŋ nadilaŋ? Kwetfoloŋ diniŋ mapme heki adi takis muneeŋ nedi’walaŋ moŋgokiiŋ? Nehi’walaŋ mehimehiye’walaŋ be metam niŋkadehi’walaŋ?” ");
INSERT INTO nop_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Unduŋ ninadiguk kaŋ Pitadi niŋguk, “Niŋkadehi’walaŋ.” Kaŋ Jesudibo niŋguk, “U biyagoŋ yolaŋ, doktiŋa nehi mehimehiye adi takis muneeŋ mu kukiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Iŋgoŋ tiyaugene inditok tiŋa nadikadakanimneeneŋ doktiŋa du weŋ wooŋ imeŋgwaŋ magineŋ yali tawa kupmakupma tibeŋ, tiŋa pisi timeŋ hamaneweŋ u tiŋa maŋiŋ taŋakiyeeŋ maaneŋ muneeŋ niŋ halek kaŋ uŋakoŋ tiŋa wooŋ inditok takis kameweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nai uŋaniŋ Jesu mihiŋiye adi Jesu’walaŋ wooŋ indiŋ ninadigiŋ: “Nediyeŋ Bepaŋ’walaŋ Hatihati Kobuli gineŋ me loloŋnit hinek hatilak?” ");
INSERT INTO nop_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Unduŋ yogiŋ kaŋ Jesudi wapmihi-kabe niŋ nimbune buguk kaŋ nagila lekiŋgoŋhik foloŋ kameune yalune yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Nu biyagoŋ hinek hanilat. Hidi hidetok nadiune foune wapmihi-kabedok tuwolit mu tiŋa hatineeŋ adi Bepaŋ hebeŋ foloŋ Hatihati Uŋgoniŋ gineŋ uŋoŋ mu foneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Eŋ nebek niŋdi mihi-kabe yendok tuwolit tiŋa netok nadiune fofoŋnit tubune noliye’walaŋ hebehik gineŋ hatibaak adiyeŋ kunum foloŋ Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ hatakneŋ uŋoŋ me loloŋnit hatibaak. ");
INSERT INTO nop_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tiŋa nebek niŋdi nutok nadiŋa wapmihi-kabe indiniŋ momooŋ timiluwaak adi nu tinamuluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nebek niŋdi wapmihi kuyahi-kabe nu nadisukilitinamiiŋ u yehitubu-gweheyeune kadakaniŋ tineeŋ me uyadi kawade bigim, malabumuŋdi kodi foloŋ tehikapmaaŋ imeŋgwaŋ gineŋ tapmetukulune fooŋ ime silotnaaŋ kumuŋ tubune adi tuwot tibek. ");
INSERT INTO nop_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yakaiŋ! Metam wanakaŋ hogohogok kadakaniŋ mebimebi mintayemulak. Iŋgoŋ me nediyeŋ kadakaniŋ titiŋdok weleyouyout tiyemulak adi moniŋ. Adi yadi kibikoŋ dediniŋgoŋ hinek timineeŋ! ");
INSERT INTO nop_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Unduŋ doktiŋa kohogedi be kayogedi kadakaniŋ tubune kaŋ u udokokut tuluwaaŋ, unduŋ tiŋa kohotuŋgum be kayotuŋgum hatigene Hatihati Kobuli kedem kahilewaaŋ. Eŋ unduŋ mu tiŋa kayoge kohoge lufomnikoŋ kunilit boi hatibaaŋ adi kwet kadakaniŋ gineŋ fooŋ kudupdok gigit tibaaŋ. ");
INSERT INTO nop_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Be daugedi kadakaniŋ tubune kaŋ fukuniŋ kidikut tuluwaaŋ, unduŋ tiŋa dausipmik hatigene Hatihati Kobuli kedem kahilewaaŋ. Eŋ unduŋ mu tiŋa dauge lufomnikoŋ kedehi diwe hatibaaŋ adi kwet kadakaniŋ gineŋ fooŋ kudupdok gigit tibaaŋ.” ");
INSERT INTO nop_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hidi wapmihineye kuyahi-kabe i momooŋ tiyemaneeŋ, tiŋa nadiyembune fofoŋhinit mu tuluwaak. Nu wendok indiŋ hanimbe nadineŋ: Aŋelohiye kunum foloŋ hatiiŋ adi wapmihineye kuyahi-kabe yendok Batne kunum gineŋ hatilak adi namanda foloŋ helemahelemaŋ mintamiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Me Kobumuŋ adi me fiit tigiŋ yolohiŋa yehitubu-mintaaŋ yanagile buguk. ");
INSERT INTO nop_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kaŋ hidi dediŋ nadiiŋ? Me niŋ dompaŋiŋ 100 ala kubugoŋ niŋ filune bikabu be tibek? Be dompaŋiŋ 99 u uŋgoŋ biyabuŋa kubugoŋ niŋ fiilek ube lohiyawek? Nu biyagoŋ hinek hanimbit, adi u lohiŋa lohihinakawek. ");
INSERT INTO nop_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tiŋa lohiyaugeyauge tubumintaaŋ nagila 99 wendok nadifo niŋ mebit tiyembek, iŋgoŋ kubugoŋ fikukneniŋ kaŋ nagilek aditok adi gibitaŋ nadifowek. ");
INSERT INTO nop_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Undugoŋ hinek Behik kunum gineŋ hatilakdi maaŋ wapmihiŋiye’walaaniŋ lekiŋgoŋhik foloŋ kubugoŋ-kabe nemu fitdok nadilak.” ");
INSERT INTO nop_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Me noke niŋdi binek kadakaniŋ tigambune du wooŋ kaŋ hide hogok hinek hali nintubudidimeluwaaŋ. Unduŋ tubune adi medege nobu nadiŋa kulemaune kaŋ kedem nadimimbune dapmaune menot tigamuluwaak. ");
INSERT INTO nop_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Eŋ medege mu nadiune kaŋ me kubugoŋ be lufomuk unduŋ yanagilune wooŋ noŋgoŋ mebiŋiŋ kanadiŋa nintubudidime taneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Uŋoŋ maaŋ medehik mu nobu nadiune kaŋ kayoŋbop heki’walaŋ kohohik foloŋ kameyaneeŋ. Kaŋ kayoŋbop’walaŋ mede maaŋ mu nadiune nadimimbune me u nadisukilitinit mokit, me takis moŋgomoŋgot tiiŋ heki wendok tuwolit tuluwaak. ");
INSERT INTO nop_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Indiŋ hanimbe nadineŋ: Hidi kwetfoloŋ iŋoŋ yokamehep kwanai tubune kunum gineŋ maaŋ undugoŋ hinek mintaluwaak, be kwetfoloŋ iŋoŋ yodapmandapmaŋ kwanai tubune kunum gineŋ maaŋ undugoŋ hinek mintaluwaak. ");
INSERT INTO nop_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tiŋa nimaaŋ indiŋ tomboyoula yobe nadineŋ: Hidi’walaaniŋ nebek lufomdi nemek niŋdok welekubugoŋ tiŋa ninadiune Batne kunum gineŋ hatilakdi kedem nadiyemiluwaak. ");
INSERT INTO nop_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Eŋ me lufomuk be lufomkulitniŋdi nutok tiŋa bopneune nu adi’walaŋ lekiŋgoŋhik gineŋ hatiluwaat.” ");
INSERT INTO nop_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesudi mede unduŋ yobune Pitadibo Jesu’walaŋ buŋa niŋguk. “Wapum, nu me notne niŋdi kadakaniŋ tinambune yomŋiŋ u nai dedigoŋ bimiluwaat? Nai 7 unduŋ bimimbene tuwot be tibek?” ");
INSERT INTO nop_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ninadiune Jesudibo niŋguk, “7 hogok adi moŋ, adi 70 bop 7 wendok tuwot bimiluwaaŋ. ");
INSERT INTO nop_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Unduŋ doktiŋa, Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Uŋgoniŋ adi yendok tuwot kamekaaŋ hanimbit. “Me mapme niŋdi tipilapilayeŋiye muneeŋ kibikoŋ tubu-udanemindok kutiyenimbune bugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kaŋ me niŋ nagila bugiŋ adi muneeŋ kibikoŋ tubu-udanedok halimiŋguk adi kunakunatŋiŋ 20 miliyen kina. ");
INSERT INTO nop_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kaŋ adi muneeŋ wapum u tubu-udanemindok baniŋ tubune me mapme wendi me weŋ ne tiŋa wapmihiŋiŋ tam be yoli tiŋa nemenemekŋiŋ hogohogok u me niŋdi yehituwadapmaune muneeŋ kibikoŋ uŋaniŋ bedok yoguk. ");
INSERT INTO nop_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Unduŋ yobune tipilapilaye-me adi mapme hebeŋ gineŋ mulelem tiŋa hali indiŋ nimbulabulayeguk, ‘Me bomboŋgine, du binabune kedembe muneeŋ u baigoŋbaigoŋ wobuŋa uuyeŋ wobudapmawaat.’ ");
INSERT INTO nop_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Unduŋ nimbulabulayeune mapme u weleŋ goloune fiit nadimiŋa me u kibikoŋŋiŋ bimiŋa bikabune fo uguk. ");
INSERT INTO nop_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Unduŋ timimbune yopmaŋneniŋ fooŋ buŋa wooŋ tipilapilaye-me noliŋiŋ niŋ tubumintaaŋ kodi foloŋ gibitaŋ bem kahila niŋguk, ‘Muneeŋne mu tubu-udanenamulaŋ!’ Me u koom adi’walaŋ 10 kinaŋiŋ miŋguk iŋgoŋ toboniŋ mu tubu-udanemiŋguk doktiŋa unduŋ timiŋguk. ");
INSERT INTO nop_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Unduŋ nimbune me noliŋiŋ hebeŋ gineŋ mulelem timiŋa indiŋ nimbulabulayeguk, ‘Notne, du binabune nu’walaŋ kibikoŋ hatak u baigoŋ wobugambit.’ ");
INSERT INTO nop_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Unduŋ nimbulabulayeguk iŋgoŋ me u medeŋiŋ mu nadimiŋa yobune indiŋ niŋa nagi wooŋ yot fafaŋeniŋneŋ dahigiŋ. ‘Kibikoŋge wobudapmaaŋ kedem fooŋ baaŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Kaŋ tipilapilaye nolidi nemek mintaguk u kaŋ nadiune welehik gineŋ tuwot mu tubune wooŋ mapme mede kahat timiŋgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kaŋ adi u nadiŋa tipilapilaye-me u kotigoŋ kutinimbune buune niŋguk, ‘Du tipilapilaye-me hogoli, du nanimbulabulayeŋaŋ kaŋ nadibulagitaaŋ kibikoŋ wobunamdok wapum u bigamuŋat. ");
INSERT INTO nop_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kaŋ du maŋgoŋde nokedok bulaniŋgoŋ mu nadimiŋa bikabuŋaŋ?’ ");
INSERT INTO nop_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Unduŋ yoŋa weleŋ gouyeune kumondulum heki’walaŋ kohohik foloŋ kameeŋ yeniŋguk, ‘Kisaŋ utubufigitaaŋ kwanaimiŋ mimbune hatitalooŋ kibikoŋŋiŋ wobudapmaune kaŋ bikabuneeŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Hidi nohiyedok kadakaniŋ bibiŋ welehikdi hinek mu tubune kaŋ Batne kunum gineŋ hatilakdi undugoŋ kadakaniŋhik mu bihamuluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu adi mede unduŋ yodapmaaŋ Galili kwet bikabuŋa Judiya kwetneŋ, Jodan ime fukuniŋ guŋandiŋ loguk. ");
INSERT INTO nop_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Loune metambop wapum hinekdi kelegiŋ. Kaŋ kwet uŋoŋ hatiŋila metam yagithinit yehitubu-kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kaŋ Falisi noli adi tikamanda timine buŋa indiŋ ninadigiŋ, “Yodoko Medenikdi me niŋ adi ne nadinadiŋiŋde tamŋiŋ kelekutdok kedembe yolak be dediŋ? U ninimbu nadinim.” ");
INSERT INTO nop_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Unduŋ yogiŋ kaŋ yeniŋguk, “Hidi Yodoko Mede indiŋ hatak u mube kunali nadiiŋ? Bepaŋ adi nemenemek yehitubu-mintaŋila me tiŋa tam maaŋ yehitubu-mintaguk. ");
INSERT INTO nop_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yehitubu-mintaaŋ indiŋ yoguk, ‘Wendoktiŋa me niŋ adi mimbeu biyabuŋa tamŋiŋ’walaŋkade wooŋ galiŋa adi welehik be sigihikdi kubugoŋ mintaaŋ hatidemeek.’ ");
INSERT INTO nop_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Unduŋ doktiŋa adi molomolom moŋ, adi agaŋ kubugoŋ mintaaŋ hatiyamuk. Bepaŋdi yehikiukuk doktiŋa meeniŋdi tuwot mu yehidanedok.” ");
INSERT INTO nop_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Unduŋ yeniŋguk kaŋ adibo yogiŋ, “Kaŋ maŋgoŋde Mosesdi tam bikabudok nadiŋa mede pepa foloŋ youla miŋa niŋkelekutdok yoguk?” ");
INSERT INTO nop_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Unduŋ yonadigiŋ kaŋ Jesudi yeniŋguk, “Hidi welehik fafaŋehi tiŋa mede nadinadi mu tiiŋ doktiŋa Mosesdi mebihik u nadihamuŋa yoguk. Koom tububihit gineŋ adi talik unduŋ nemu hakuk. ");
INSERT INTO nop_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Unduŋ doktiŋa indiŋ hanimbe nadineŋ. Nebek niŋdi tamŋiŋ hogok bikabufit tiŋa tam gitipmuŋ nagilaak adi yofolokhik fafaŋeŋ u ulopmadiwaak doktiŋa kefifile diniŋ malabumuŋ hekiwaak. Be tamdi kefifile tubune yohoidi bikabaak uyadi tam diniŋ yom tibaak.” ");
INSERT INTO nop_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Unduŋ yobu mihiŋiyedibo niŋgiŋ, “Memalam kedem titiŋdok iŋgoŋ titiŋ undiniŋ maaŋ hatakneŋ doktiŋa tam mu tiŋa hogok kedem hatidok.” ");
INSERT INTO nop_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yobune Jesudi yeniŋguk, “Mede yoŋ adi wanakaŋ hogohogokdok mu tilak. Bepaŋdi wendok saŋiniŋ yemguk adi hogokdi nadidahi tineŋ. ");
INSERT INTO nop_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Me noli adi ulihaka mu titiŋdok fiyewakahi undihigoŋ mintaiŋ, eŋ noli adi meeniŋdi yehitubu-fiyewakaiŋ, kaŋ noli adi Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ hatak wendok nadiŋa tam mu tiŋa hatiiŋ. Me nediyeŋ wendok saŋiniŋ halimilakdi mede i nadidahi tibek.” ");
INSERT INTO nop_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Metam noli adi wapmihiye Jesudi kohoŋ kihik foloŋ kameeŋ ninadi tibek yoŋa yanagila bugiŋ. Kaŋ mihiŋiyedi yenihep tigiŋ, ");
INSERT INTO nop_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","kaŋ Jesudi yeniŋguk, “Wapmihi biyabune nu’walaŋkade buneŋ. Kamehep mu tiyemineŋ. Bepaŋ’walaŋ hebeŋ foloŋ Hatihati Uŋgoniŋ hatak uyadi wapmihi undihidegoŋ.” ");
INSERT INTO nop_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Unduŋ yoŋa kohoŋ kihik foloŋ kameguk. Unduŋ tiŋa kwet u bikabuŋa kwet niŋ uguk. ");
INSERT INTO nop_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kaŋ mekuya niŋdi buŋa Jesu indiŋ ninadiguk. “Henale, nu titiŋ momooŋ dediŋ tiŋa hatihati dapmandapmaŋnit mokit u kahilewaat?” ");
INSERT INTO nop_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yobune indiŋ niŋguk, “Du maŋgoŋde nemek momooŋdok naninadilaŋ? Momooŋ diniŋ molom adi kubugoŋ hatilak. Ale du hatihati dapmandapmaŋnit mokit kahilewe nadiŋa kaŋ Yodoko Mede hogok keleluwaaŋ.” ");
INSERT INTO nop_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kaŋ me wendibo yoguk, “Yodoko Mede dendok yolaŋ?” Unduŋ ninadiune Jesudi yoguk, “Du me widihikumuŋ mu tuluwaaŋ, hekimalam hidi kefifile mu tiyaneeŋ, du kubo mu tuluwaaŋ, du menolidok yalaŋ mu yeniluwaaŋ, ");
INSERT INTO nop_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","du maaŋge baha’walaŋ mede tiloloŋ tuluwaaŋ tiŋa datok nadilaŋ undugoŋ nokedok nadimiluwaaŋ.” ");
INSERT INTO nop_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Unduŋ yobune me wendi indiŋ niŋguk, “U hogohogok u agaŋ keleeŋ titabulat, kaŋ nemek noli nimaaŋgoŋ neeŋbe hatak?” ");
INSERT INTO nop_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Unduŋ yonadiguk kaŋ Jesudi niŋguk, “Du me didimeniŋ hinek mintadok nadiŋa kaŋ weŋ, wooŋ bomboŋge tuwadok boiune tuwaune muneeŋ u fiyewakahidok yembeŋ. Unduŋ tibeŋ kaŋ nemenemek momohi kunum gineŋ uŋgoŋ boigambu itneeŋ. Ale unduŋ tiŋa buŋa nu nehikeleweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Unduŋ nimbune me u muneeŋ bomboŋ wapum hinek halimiŋguk doktiŋa mede u nadiŋa welemulap tiŋa uguk. ");
INSERT INTO nop_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Me u uune Jesudi mihiŋiye indiŋ yeniŋguk. “Biyagoŋ hinek hanimbit. Me muneeŋ bomboŋhinitdi Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ u kahiledok kwanaimiŋ tiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nemek wendegoŋ kotigoŋ indiŋ hanimbit. Kale kameldi buŋi ginaneŋ fofoŋdok kwanaimiŋ mu tibek, iŋgoŋ me muneeŋ bomboŋhinit adi Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ kahiledok u kwanaimiŋ wapumgoŋ hinek tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kaŋ mihiŋiye adi mede u nadiŋa boho kisaŋ tiŋa nadigiyondaaŋ yogiŋ, “Kaŋ nediyeŋ kahilewaak?” ");
INSERT INTO nop_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Unduŋ yobune Jesudi yabuhohoŋe tiŋa yoguk, “U meeniŋdi titiŋdok tuwot moŋ, iŋgoŋ Bepaŋ’walaŋkade adi nemek ube u titiŋdok adi kwanaimiŋ mu tilak.” ");
INSERT INTO nop_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Unduŋ yeniŋguk kaŋ Pitadibo indiŋ yoguk, “I kaweŋ, indi nemenemek hogohogok biyabudapmaaŋ du gehikeleyam, kaŋ hatigene wendok kibikoŋ maŋgoŋ beneem?” ");
INSERT INTO nop_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Unduŋ yonadiune Jesudi indiŋ yeniŋguk, “Nu biyagoŋ hinek hanimbit, hatigene nemenemek kaikaaŋ kobuli mintaminta naiŋiŋ foloŋ Me Kobumuŋ adi iitŋiŋ kwet tehindilendilenenit eŋ filimpipitnit foloŋ ilune nu nehikeleeŋ yaugiŋ heki hidi maaŋ mapme’walaŋ kumopop 12 foloŋ uŋoŋ ila Isilaehi metam bop 12 hatiiŋ hogohogok u yabudokoneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Tiŋa nediyeŋ nutok tiŋa yoli be dali kwayaŋiye, be wiwiye, be mimbeu be wapmihi-tam be dininaŋiŋ biŋa baak, adi kibikoŋ tuwaŋiŋ wapum loloŋnit hinek bewaak, tiŋa wahiŋkade hatihati dapmandapmaŋnit mokit kahilewaak. ");
INSERT INTO nop_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iŋgoŋ nai indide timeŋ tiŋa loloŋhinit hatiiŋ feedi kougoŋ fofoŋhinit hatineeŋ, kaŋ fofoŋhinit hatiiŋ feedi kougoŋ loloŋhinit hatineeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ adi me kwanai molom niŋdi wain kwanaiŋiŋdok kwanai-me yolohiwene haniŋ timiŋ fooŋ uguk wendok tuwot. ");
INSERT INTO nop_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wooŋ me noli yehitubu-mintaaŋ yanagila mele kubugoŋ wendok kwanai tubune tuwaŋiŋ 50 toya 50 toya yemdok u yenimbihilune nadiune tuwot tubune kwanai kwetneŋ yeniŋkulune ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kaŋ 9 kilok tulune kotigoŋ wooŋ me noli yowawaliweŋ hogok hatifit tubune yabuŋa yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Nu wain fiyene gineŋ kwanai uŋgoŋ hatak, ale wooŋ kwanaineune habuŋa tuwaŋiŋ tuwolit kedem hambit.’ ");
INSERT INTO nop_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Unduŋ yenimbune nadiŋa wain fiyeŋiŋ gineŋ ugiŋ. Kaŋ 12 kilok tiŋa 3 kilok foloŋ me noli maaŋ yehitubu-mintaaŋ yeniŋkulune ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kaŋ 5 kilok tulune wooŋ me noli hogok hatiliweliweŋ tulune yehitubu-mintaaŋ yeniŋguk, ‘Hidi dediŋ doktiŋa mele nai wapum i hogok hinek hatibune wooŋ tebeledalak?’ ");
INSERT INTO nop_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Yenimbu yogiŋ, ‘Indi nebek niŋdi kwanai nemu nimŋak doktiŋa hogok hakam.’ ");
INSERT INTO nop_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Unduŋ yogiŋ kaŋ yeniŋkula yoguk, ‘Wain fiyene gineŋ kwanai uŋgoŋ hatak ale wooŋ kwanaineneŋ.’ Me kwanai molom unduŋ hatitulune wooŋ tebele hinek tuguk, kaŋ me yabudoko me u indiŋ niŋguk, ‘Me kwanai-me heki kutiyenimbu buune yehituwaweŋ, timeŋ tububihila me mindaŋ buŋit yehituwatauyeŋ me timeŋ buŋit heki mindaŋ hinek yehituwaweŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Unduŋ niŋguk doktiŋa tububihila me mindaŋ bugiŋ yenimbu buune melenai u kwanainegiŋ wendok 50 toya 50 toya yehituwatauguk. ");
INSERT INTO nop_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kaŋ me timentimeŋ bugiŋ heki adi tuwaŋiŋ adi beiŋ u kabek yalakapmeeŋ nimbek binek yoŋa nadigiŋ, iŋgoŋ kadoko medi me noli begiŋ wendok tuwot hinek 50 toya 50 toya yemguk. ");
INSERT INTO nop_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kaŋ u kaune tuwot mu tubune wooŋ kwanai molom indiŋ niŋgiŋ, ");
INSERT INTO nop_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Me mindaŋ buŋit heki yoŋ adi kwanai wapum mu tiŋit. Kaŋ indi adi haniŋ timiŋ uŋoŋdibek tububihila kwanainemundi kwanaine hatnene mele foloonik foloŋ uŋgoŋ daaŋ foŋak, kaŋ dediŋ doktiŋa tuwaŋiŋ me mindaŋ buŋit heki yemiŋaŋ wendok tuwolit hinek nimilaŋ?’ ");
INSERT INTO nop_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Unduŋ yobune kwanai molomdi adi’walaaniŋ me niŋ indiŋ niŋguk, ‘Me notne, nu mu gehitubu-kadakalat. Nu melenai kubugoŋ yendok tuwaŋiŋ ganimbihile nadiune tuwot tiŋak kaŋ buŋa kwanaineŋaŋ. Ale muneeŋge beŋa wabiŋa u. ");
INSERT INTO nop_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nu adi me mindaŋ buŋit tiŋa du hiditok tuwahik adi wanakaŋ undihi yakiŋgoŋ hamdok nadiwe utumbaŋak. ");
INSERT INTO nop_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","I na’walaŋ nemek doktiŋa nemek u be u tibit yoŋa tuwot mu tibit be? Be siloŋ tiyemiŋat wendoktiŋa yabunadikadaka be tilaŋ?’ ");
INSERT INTO nop_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Undugoŋ hinek mindaŋdi timeŋ tineeŋ kaŋ timeŋdi mindaŋ tineeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu adi Jelusalemde loŋila mihiŋiye yanagi wooŋ nehi hogok yehibopneeŋ yeniŋguk ");
INSERT INTO nop_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nadiiŋbe, ya agaŋ Jelusalemde loyam. Uŋoŋ Me Kobumuŋ bolik timimbune me Siloŋyot diniŋ talitimeŋ, tiŋa Yodoko Mede henale heki’walaŋ kohohik foloŋ lowaak. Loune kumuŋdok nindapmaaŋ ");
INSERT INTO nop_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Loma me heki’walaŋ kohohik foloŋ kameune adi nimpekit tiŋa kiyegelepdi utubukadakaaŋ koloŋdabek foloŋ ukambiyalune yali kumumbaak. Kaŋ helebufa lufomkulitniŋ hali kotigoŋ kaikaaŋ pilalaak.” ");
INSERT INTO nop_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nai uŋaniŋ Sebedi mihiŋiyat adi mehikdi yanagila Jesu’walaŋ wooŋ mulelem tiŋa nemek niŋdok ninadiguk. ");
INSERT INTO nop_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kaŋ Jesudibo tubu-udaneeŋ ninadiguk, “Du maŋgoŋdok nadilaŋ?” Unduŋ ninadiune adibo yoguk, “Du nai indidegoŋ yokilitibeŋ ala kougoŋ Mapme Wapum mintadakalewaaŋ nai uŋaniŋ mihineyat yanagila niŋ kohoge didimeniŋneŋkade eŋ niŋ kohoge kapmadineŋkade yapmeune itemeek.” ");
INSERT INTO nop_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Unduŋ yobune Jesudi niŋguk, “Hidi nemek u mebi mu nadidakaleeŋ hogok yofit tiiŋ.” Unduŋ yoŋa meyat indiŋ yeninadiguk, “Hidi nu ime buukaaŋ nawaat u kedembe nademeek?” Kaŋ adi yogumuk “Eeŋ, indi kedem nademeet.” ");
INSERT INTO nop_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Unduŋ yobu Jesudi yeniŋguk, “Nu ime buukaaŋ nawaat u biyagoŋ nademeek, iŋgoŋ hidi’walaaniŋ nediyeŋ nu kohone didimeniŋneŋkade eŋ kohone kapmadineŋkade iitdok u nu tuwot mu hanindapmawit. Woŋ adi Bepaŋ ne meeniŋ yabukahileeŋ gigit uyemguk adi kahileneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kaŋ me nohiye 10 adi mede u nadiŋa meyatdok nadikadaka tiyemgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kaŋ Jesudi yenimbune buŋa bopneune indiŋ yeniŋguk, “Me nadisukilitihinit mokitdi mapme ila metam nadiyembu foune tipilapilaye kwanai titiŋdok yeniŋgigine tiiŋ. Kaŋ me loloŋhinit adi me fofoŋhinit yehimoŋgofooŋ me bomboŋgi tiiŋ, hidi a nadiiŋ. ");
INSERT INTO nop_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Iŋgoŋ hidi adi unduŋ mu tineeŋ. Hidi’walaaniŋ nediyeŋ loloŋnit tibe nadiŋa kaŋ noli hogohogok hidi’walaŋ lekiŋgoŋhik foloŋ me fofoŋnit hatiŋa tipilapilaye kwanai tuluwaak. ");
INSERT INTO nop_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Eŋ niŋdi talitimeŋ tibe nadiŋa kaŋ noliŋiye’walaŋ tipilapilaye-me hatiluwaak. ");
INSERT INTO nop_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Me Kobumuŋ adi maaŋ undugoŋ, kwetfoloŋ iŋoŋ tipilapilaye timindok mu foguk, adi tobo metamdok tipilapilaye tiyemiŋa hatihatiŋiŋdi yehituwawene foguk.” ");
INSERT INTO nop_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesu tiŋa mihiŋiye adi Jeliko bikabuŋa ulune metambop wapumdi yehikelegiŋ. ");
INSERT INTO nop_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kaŋ meyat dauhik sipmakahiyat adi tali gagayeŋ ila nadiune yogiŋ, Jesu buŋa ulak. Yobune gibitaŋ indiŋ kutigumuk, “Wapum, du Dewit’walaŋ yalakidi inditok bulaniŋgoŋ nadiweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaŋ metamdi kabup itemek yoŋa yenihep tigiŋ. Iŋgoŋ adi toboniŋ gigine tiŋa wapumgoŋ hinek kutiŋa indiŋ yogumuk, “Wapum, du Dewit’walaŋ yalakidi inditok bulaniŋgoŋ nadiweŋ.” ");
INSERT INTO nop_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kaŋ Jesu adi talipmeŋ uŋgoŋ yali yenimbu buune yeninadiguk, “Hidi maŋgoŋ tihambit yoŋa kutinaniyamuk.” ");
INSERT INTO nop_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Unduŋ yeninadiune indiŋ niŋgumuk, “Wapum, nihitubu-lodaune diwedakale tidim yoŋa kutiganiyamut.” ");
INSERT INTO nop_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Unduŋ yobune Jesudi yabuŋa bulaniŋgoŋ nadiyemiŋa dauhik foloŋ yeheune nai uŋaniŋgoŋ dauhik diwetomgumuk. Unduŋ tiŋa Jesu keletaugumuk. ");
INSERT INTO nop_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesu tiŋa metambop wapum ugiŋ wooŋ Jelusalem tubudulagiŋ. Tiŋa Oliwa Tuwai gagayeŋ uŋoŋ yokwet niŋ hakuk wou Betefage. Uŋoŋ wosuwaaŋ Jesudi mihiŋiye’walaaniŋ meyat lufom yeniŋkula indiŋ yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Hidi udemek wooŋ yokwet niŋ halekneŋ doŋki miŋmihiniŋ niŋ yehitehiŋit yalune yabuŋa uŋakoŋ yehifiyaliŋa yahaŋeeŋ budemek. ");
INSERT INTO nop_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hidi unduŋ tidemek kaŋ nebek neeŋ haninadiune kaŋ indiŋ nindemek ‘Wapumdi yendok yolak.’ Unduŋ yobune bihambune yanagila budemek.” ");
INSERT INTO nop_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nemek uyadi hogok mu mintaguk. Polofetdi koom mede niŋ indiŋ yoguk wendiniŋ folooŋ mintaguk. ");
INSERT INTO nop_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saiyonhi metam indiŋ yenineŋ, Mapmehik buhamulak u kaneŋ. Adi weleŋ kulemaŋdi doŋki foloŋ ila bulak. Doŋki mihiniŋ kobulidi hekiŋa bulak.” ");
INSERT INTO nop_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kaŋ meyat adi Jesu’walaŋ maŋiŋ mede tagimneeŋ ");
INSERT INTO nop_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","doŋki miŋmihiniŋ yanagila buune dahidahi wahiniŋ kwihiŋa beŋa doŋki sigiŋ foloŋ iune Jesu looŋ ikuk. ");
INSERT INTO nop_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaŋ metam fee hinekdi dahidahi wahiniŋ kwihiŋa beŋa tali foloŋ gulup itaugiŋ, kaŋ nolidi wowoŋgimiŋ eŋ bem hapmuŋ heki beŋa kula ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kaŋ metambop wapum timeŋ mindaŋ tiŋa indiŋ yoŋa kakaligiŋ, “Dewit yalakiŋiŋ nintilonim! Me i Wapum wou gineŋ bulak, Bepaŋdi kahaŋ timimbek! Bepaŋ kunum gineŋ nintilonim!” ");
INSERT INTO nop_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kaŋ Jelusalem yokwet maaneŋ foune metam uŋahi hogohogok boho tiŋa yogiŋ, “Me i nediyeŋ buune indiŋ toiŋ?” ");
INSERT INTO nop_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Unduŋ yobune metam adut bugiŋdi yeniŋgiŋ, yoŋ adi Polofet Jesu, Galili maaneŋ yokwet wapum Nasaletniŋ bulak.” ");
INSERT INTO nop_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Unduŋ tiŋa Siloŋyot diniŋ hamuhe gineŋ muneeŋ bomboŋ kibikibi hatigiŋ u Jesudi fooŋ yehikele-pupuheneeŋ muneeŋ falik eŋ butigili tuwadok boiŋa ikiŋ u kumopophik udakuyemiŋa yeniŋguk, ");
INSERT INTO nop_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“Youkudip gineŋ Bepaŋ’walaŋ mede indiŋ hatak, ‘Nu yotne u yadi ninadi yot unduŋ yoneeŋ.’ Iŋgoŋ hidi unduŋ tubune kubome heki’walaŋ hebihathik kwet dabugoŋ tilak!” ");
INSERT INTO nop_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tiŋa uŋgoŋ hatune me dauhik sipmakahi eŋ kayohik hogohi adi’walaŋkade uune yehitubu-kedebaguk. ");
INSERT INTO nop_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Unduŋ tubune Siloŋyot diniŋ talitimeŋ tiŋa Yodoko Mede henale heki adi kudi momooŋ tuguk u kagiŋ, agaŋ wapmihidi Siloŋyotneŋ niutumbaaŋ indiŋ togiŋ u maaŋ nadigiŋ, “Nintilonim. Dewit’walaŋ yalakidi bunimilak.” ");
INSERT INTO nop_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Adi wendowendok tihake nadigouyeeŋ Jesu indiŋ niŋgiŋ, “Du ganiutumbaaŋ mede debek yoiŋ u maaŋbe nadilaŋ?” Kaŋ Jesudi yoguk, “Agaŋ nadilat. Kaŋ hidi Yodoko Mede gineŋ indiŋ hatak u mu binek kunakiŋ. ‘Bepaŋdi wapmihi-kabe tiŋa eyaŋ nom naiŋ adi’walaŋ welehik tubulodaune mahik gineŋ dutok youtumba mintalak.’” ");
INSERT INTO nop_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Unduŋ yoŋa biyabuŋa Jelusalem yokwetneŋniŋ fooŋ buŋa wooŋ Betani yokwetneŋ loguk. Kaŋ bufaune uŋgoŋ deikuk. ");
INSERT INTO nop_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ala haniŋ kotigoŋ Jelusalemde uŋila map nadiguk. ");
INSERT INTO nop_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tiŋa talipmeŋ uŋoŋ bem fik niŋ yakuk kaŋ mebineŋ wooŋ folooŋ nenobu yoŋa diweguk e moŋ, adi hapmuŋ hogok. Unduŋ kaŋ bem u indiŋ niŋguk, “Du foloŋ kotigoŋ kiliki nemu mintaneeŋ, mokoŋ hinek ganihelat.” Kaŋ nai uŋaniŋgoŋ bem fik u sigeneeŋ foguk. ");
INSERT INTO nop_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kaŋ mihiŋiyedi bem fik u kaŋ boho tiŋa yogiŋ, “Bem fik i detiŋa pilap hinek sigeneeŋ folak?” ");
INSERT INTO nop_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kaŋ Jesudi yeniŋguk, “Nu biyagoŋ hinek hanimbit. Hidi welelufom mu tiŋa nadisukiliti hinek tiŋa hatineeŋ woŋ, kudi bem fik foloŋ mintaŋak undiniŋ hogok mu tineeŋ, hidi kweboboe gu maaŋ indiŋ nineeŋ. ‘Du kweke u bikabuŋa tatakula imeŋgwaŋ gineŋ fo!’ Unduŋ nimbune mahik kedem tagimnewaak. ");
INSERT INTO nop_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tiŋa undugoŋ nadisukilitihinit hinek hatiŋa nemek niŋdok ninadiune kedem mintahamuluwaak.” ");
INSERT INTO nop_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Unduŋ tiŋa wooŋ Siloŋyot diniŋ hamuhe gineŋ fooŋ Mede Momooŋ yeniyeniŋ ha-tulune Judahi’walaŋ me wapuhi eŋ Siloŋyot diniŋ talitimeŋ wapuhi adi wooŋ indiŋ ninadigiŋ, “Du nediyeŋdi kwanai i titiŋdok saŋiniŋ gamuŋa ganindapmaune tilaŋ?” ");
INSERT INTO nop_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Unduŋ ninadigiŋ kaŋ Jesudibo indiŋ tubu-udaneyemguk. “Nu mede-kabe kubugoŋ hinek haninadiwit, kaŋ u tubu-udaneune habuŋa nubo nediyeŋdi kwanai i titiŋdok saŋiniŋ namuŋa nanindapmaune maŋiŋ mede tagimneeŋ kwanai i tilat wendok hanimbit. ");
INSERT INTO nop_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon Imeyout kwanai tuguk u neeŋdi nindapmaguk. Bepaŋdi be, be kwetfoloŋ medi nindapmagiŋ?” Unduŋ yeninadiune adi mede toboniŋ dediŋ tubu-udanenim yoŋa nehi uŋgoŋ kiyonadi tigiŋ: “Indi Bepaŋ yonim adi indiŋ ninimbek, ‘Kaŋ hidi maŋgoŋde medeŋiŋ mu nadisukilitigiŋ?’ ");
INSERT INTO nop_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tiŋa undugoŋ metam hogohogokdi Jondok polofet niiŋ doktiŋa kwetfoloŋ me yonene adi dediŋ tinimneneŋ.” ");
INSERT INTO nop_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Unduŋ yonadibediŋa moŋ kaŋ “Mu nadiyam” niŋgiŋ. Kaŋ Jesudibo yeniŋguk, “Hidi mu yobihikiiŋ doktiŋa nu undugoŋ neeŋ nanindapmaune kwanai i tilat u maaŋ mu hanimbit.” ");
INSERT INTO nop_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ale hidi dediŋ nadiiŋ? Me niŋ adi mihiŋiyat lufom hatigumuk. Ala timeŋ wooŋ tuwoŋiŋ indiŋ niŋguk, ‘Du kamiŋ wooŋ wain fiye gineŋ kwanai tibeŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Kaŋ yoguk, ‘Na mu wit.’ Iŋgoŋ fiit mindaŋ nadikulemaaŋ wooŋ kwanaineguk. ");
INSERT INTO nop_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Kaŋ mindaŋ behikdi kwanai-mede uŋakoŋ kuyaniŋŋiŋbo niŋguk. Kaŋ adi ‘Kedem tibit’ youtumba-kamandaaŋ wabi tiŋa hakuk. ");
INSERT INTO nop_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Agaŋ hidi dediŋ kanadiiŋ. Mihi dendi beu’walaŋ maŋiŋ mede tagimneguk?” Kaŋ adibo yogiŋ, “Me biyeniŋŋiŋdi.” Kaŋ Jesudi yeniŋguk, “Nu biyagoŋ hinek hanilat, me takis moŋgomoŋgot heki tiŋa talitam heki adi halakapmeeŋ Bepaŋ’walaŋ Hatihati Uŋgoniŋ kahileiŋ. ");
INSERT INTO nop_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Maŋgoŋde, Jon Imeyout Tububihit adi hidi’walaŋ iŋoŋ buŋa talik momooŋ hanintubudidimeguk, iŋgoŋ hidi u kaŋ sigilulum timiŋgiŋ. Kaŋ me takis moŋgomoŋgot heki tiŋa talitam hekidi u kanadisukilitiŋa kelegiŋ. Iŋgoŋ unduŋ tubune hidi mindaŋ u yabuŋa hidetok bulaniŋgoŋ nadiŋa medeŋiŋ-kabe nemu nadimiŋgiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nu yoyout mede niŋ yobe nadineŋ. Kwet molom niŋ adi wain fiye tiŋa gimbahaŋ ibikelemadi tuguk. Unduŋ tiŋa wain folooŋ yalifilifiliyedok bom niŋ dobuŋa maliŋ tutumbaguk. Unduŋ tiŋa me looŋ yali fook titiŋdok falik ibiguk. Unduŋ tubudapmaaŋ wain fiyeŋiŋ me noli yenimbu kadokoune ne niŋkade uguk. ");
INSERT INTO nop_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ala agaŋ folooŋ moŋgomoŋgotdok nai tubune aditok nenobu boineŋ yoŋa kwanai-meŋiye yeniŋkulune ugiŋ. ");
INSERT INTO nop_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kaŋ me wain fiye kadoko tigiŋ heki adi kwanai-meŋiye u yehiŋa me noli beem ula silonekulune uguk, eŋ noli ula ulukumuŋ tigiŋ, kaŋ noli kawadedi beem ukiŋ. ");
INSERT INTO nop_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kaŋ fiye molom adi u nadiŋa gigineeŋ me koom yapmeguk wendok tuwot moŋ, kabe-feegoŋ yapmeune ugiŋ. “Kaŋ adi maaŋ yehiŋa beŋa me noli koom tiyemgiŋ undugoŋ tiyemgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kaŋ mindaŋ ne’niŋ mihiŋiŋ hinek indiŋ nadiŋa kameune uguk. ‘Na’niŋ mihine hinek wosuwawek kaŋ momooŋ timineŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Iŋgoŋ oŋ, me fiye kadokome heki adi u kaŋ indiŋ yonadigiŋ. ‘Adi kuyendi hatigene wain fiye i kahilewaak! Unduŋ doktiŋa ulukumuŋa wain fiye i indetok kahilenim.’ ");
INSERT INTO nop_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Unduŋ yoŋa nagila gimbahaŋ fatnak kameeŋ ulukumuŋgiŋ.” ");
INSERT INTO nop_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesu adi unduŋ yenindapmaaŋ indiŋ yeninadiguk, “Me fiye molom adi buŋa fiye kadokome heki u dediŋ tiyembaak?” ");
INSERT INTO nop_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Unduŋ yoguk kaŋ yogiŋ, “Nemek kadakaniŋ hinek tigiŋ doktiŋa kibi maaŋ undugoŋ tiyembaak. Tiŋa fiyeŋiŋ gineŋ kadokome momohi yapmewaak kaŋ folooŋ mintaune tomuŋa daneeŋ faki netok miyaneeŋ.” ");
INSERT INTO nop_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Unduŋ yogiŋ kaŋ Jesudi tomboyoula indiŋ yeniŋguk. “Hidi Youkudip gineŋ mede indiŋ hatak u mube kunali nadiiŋ? ‘Yot mamaŋme hekidi taka fofooŋ niŋ moŋ yo tukukiŋ, iŋgoŋ taka u mindaŋkade taka kobumuŋ mintaguk. Wapumdi kudi u tubune kanene uŋgoniŋ hinek tilak.’ ");
INSERT INTO nop_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Unduŋ doktiŋa hanimbene nadineŋ. Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ u holom moŋgola me gitipmuŋdok yembune adi folooŋ yehitubu-mintaneeŋ. ");
INSERT INTO nop_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Me nediyeŋ taka kobumuŋ wendok foloŋ maaŋ ulaak adi umunumunuke tibaak. Eŋ taka kobumuŋ wendi me niŋ folooŋ foloŋ maaŋ utubukadakaaŋ ufilifiliye hinek tibaak.” ");
INSERT INTO nop_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yoyout mede unduŋ yobune Siloŋyot diniŋ talitimeŋ tiŋa Falisi heki adi u nadikiyondaaŋ yogiŋ. “Ya inditok-ku yolak oŋ.” ");
INSERT INTO nop_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Unduŋ yoŋa honeeŋ uutdok nadisugiŋ iŋgoŋ oŋ, metamdi Jesu polofet niyagiŋ doktiŋa aditok muntaaŋ wabigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesu adi tomboyoula yoyout mede niŋ indiŋ yoguk, ");
INSERT INTO nop_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bepaŋ’walaŋ hebeŋ gineŋ Hatihati Uŋgoniŋ adi mapme niŋdi indiŋ tuguk wendok tuwot. Mapme wendi mihiŋiŋdok tam miŋa hinamuni titiŋdok kale nanaŋe tiulidokoguk. ");
INSERT INTO nop_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tiulidokodapmaaŋ kwanai-meŋiye yeniŋkulune me medenai koom kameyemguk u yahaŋene ugiŋ. Wooŋ yeniŋgiŋ iŋgoŋ moŋ yoŋa wabi hakiŋ, ");
INSERT INTO nop_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","kaŋ kwanai-meŋiye noli kotigoŋ yeniŋkula indiŋ yeniŋguk, ‘Hidi uneŋ wooŋ me nai tiyemgut heki u yenineŋ. Nu nemenemek agaŋ tiulidokoŋat tiŋa kale makaune kakahi u yenimbene dobuheŋit, tiŋa nemenemek agaŋ tiulidokoŋit, doktiŋa buune memetam u yehikiulaŋa nanadifo tinim.’ ");
INSERT INTO nop_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Unduŋ yobune wooŋ yeniŋgiŋ iŋgoŋ adi u nadilakataaŋ me niŋ dinina kwanaiŋiŋde mauguk, kaŋ me noli adi muneeŋŋiŋ kwanai tibene mauguk, ");
INSERT INTO nop_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","kaŋ noliyeŋ medenai tiŋa ugiŋ heki u yohoneeŋ widihiŋa, widihikumuŋ tigiŋ. ");
INSERT INTO nop_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kaŋ me mapme adi u nadiŋa weleŋ gouyeune mikmeŋiye yeniŋkulune wooŋ me mik tigiŋ heki u widihikumuŋa yohikwehik wanakaŋ kula hedapmaŋ tiyemgiŋ. ");
INSERT INTO nop_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kaŋ me mapmedi kwanai-meŋiye nolibo kutiyeniŋa yeniŋguk, ‘Muni agaŋ tiulidokoŋat, iŋgoŋ me nai tiyemgut adi kudi kadakaniŋ tubune kawe tuwot mu tilak. Unduŋ doktiŋa adi mu buneŋ, ");
INSERT INTO nop_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ale hidi wooŋ yokwet wapuhi diniŋ tali giyoki haliulak tuwot wooŋ meeniŋ neeŋ yehitubu-mintaaŋ yahaŋeune budapmaŋ tineŋ.’ ");
INSERT INTO nop_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Kaŋ kwanai-meŋiye adi tali giyoki haliuguk indigoŋ tuwot wooŋ me fofohi be hogohi u hogok kaka yanagilune buŋa bopyot u fotokiŋa ikiŋ. ");
INSERT INTO nop_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kaŋ mapmedi fooŋ me nalum bugiŋ heki u yabuŋa uguk, uuyeŋ me niŋ hinamuni diniŋ tinahukut mu tiŋa bu ikuk kaŋ niŋguk, ");
INSERT INTO nop_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Du detiŋa tinahukut hogoli tiŋa labu itaŋ?’ ");
INSERT INTO nop_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Unduŋ ninadiune me u mede toboniŋ mu tubu-udaneeŋ hogok ikuk. Kaŋ Mapmedi kwanai-meŋiye indiŋ yeniŋguk, ‘Hidi me i kayoŋ kohoŋ tawadi ibikilitiŋa tobo tukulune mambip gineŋ uŋoŋ fooŋ koyoneeŋ masiŋkilip hatitoluwaak.’ ");
INSERT INTO nop_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nadiiŋ be? Bepaŋ adi meeniŋ fee yeniyehimanelak iŋgoŋ lufomgoŋ yabukahilelak.” ");
INSERT INTO nop_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesudi unduŋ yenimbune Falisi heki adi wooŋ bopneeŋ mede tali dediŋ foloŋ kameeŋ niŋkam