﻿USE sofia;
DROP TABLE IF EXISTS sofia.nod_vpl;
CREATE TABLE nod_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nod_vpl WRITE;
INSERT INTO nod_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","นี้​เป๋น​บันทึก​ราย​จื้อ​ป้อ​อุ๊ย​แม่​หม่อน​ของ​พระเยซู​คริสต์ ผู้​ตี้​เป๋น​ลูกหลาน​ของ​กษัตริย์​ดาวิด​ใน​ผะกุ๋น​อับราฮัม ");
INSERT INTO nod_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","อับราฮัม​เป๋น​ป้อ​อิสอัค อิสอัค​เป๋น​ป้อ​ยาโคบ ยาโคบ​เป๋น​ป้อ​ยูดาห์ ตึง​หมู่​น้อง​บ่าว​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ยูดาห์​เป๋น​ป้อ​เปเรศ​กับ​เศราห์ แม่​จื้อ​ทามาร์ เปเรศ​เป๋น​ป้อ​เฮสโรน เฮสโรน​เป๋น​ป้อ​ราม ");
INSERT INTO nod_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ราม​เป๋น​ป้อ​อัมมีนาดับ อัมมีนาดับ​เป๋น​ป้อ​นาโชน นาโชน​เป๋น​ป้อ​สัลโมน ");
INSERT INTO nod_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","สัลโมน​เป๋น​ป้อ​โบอาส แม่​จื้อ​ราหับ โบอาส​เป๋น​ป้อ​โอเบด แม่​จื้อ​รูธ โอเบด​เป๋น​ป้อ​เจสซี ");
INSERT INTO nod_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","เจสซี​เป๋น​ป้อ​ดาวิด​ผู้​เป๋น​กษัตริย์ ดาวิด​เป๋น​ป้อ​ซาโลมอน แม่​ของ​ซาโลมอน​เกย​เป๋น​เมีย​ของ​อุรียาห์​มา​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ซาโลมอน​เป๋น​ป้อ​เรโหโบอัม เรโหโบอัม​เป๋น​ป้อ​อาบียาห์ อาบียาห์​เป๋น​ป้อ​อาสา ");
INSERT INTO nod_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","อาสา​เป๋น​ป้อ​เยโฮชาฟัท เยโฮชาฟัท​เป๋น​ป้อ​โยรัม โยรัม​เป๋น​ป้อ​อุสซียาห์ ");
INSERT INTO nod_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","อุสซียาห์​เป๋น​ป้อ​โยธาม โยธาม​เป๋น​ป้อ​อาหัส อาหัส​เป๋น​ป้อ​เฮเซคียาห์ ");
INSERT INTO nod_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","เฮเซคียาห์​เป๋น​ป้อ​มนัสเสห์ มนัสเสห์​เป๋น​ป้อ​อาโมน อาโมน​เป๋น​ป้อ​โยสิยาห์ ");
INSERT INTO nod_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","โยสิยาห์​เป๋น​ป้อ​เยโคนิยาห์ ตึง​หมู่​น้อง​บ่าว​คน​อื่น﻿ๆ ของ​เขา ใน​เวลา​นั้น​หมู่​จาว​ยิว​ถูก​บังคับ​ไป​เป๋น​เชลย​ตี้​ประเทศ​บาบิโลน ");
INSERT INTO nod_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","หลัง​จาก​เหตุก๋ารณ์​นั้น​แล้ว เยโคนิยาห์​ก็​มี​ลูก​จื้อ​เชอัลทิเอล เชอัลทิเอล​เป๋น​ป้อ​เศรุบบาเบล ");
INSERT INTO nod_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","เศรุบบาเบล​เป๋น​ป้อ​อาบียุด อาบียุด​เป๋น​ป้อ​เอลียาคิม เอลียาคิม​เป๋น​ป้อ​อาซอร์ ");
INSERT INTO nod_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","อาซอร์​เป๋น​ป้อ​ศาโดก ศาโดก​เป๋น​ป้อ​อาคิม อาคิม​เป๋น​ป้อ​เอลีอูด ");
INSERT INTO nod_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","เอลีอูด​เป๋น​ป้อ​เอเลอาซาร์ เอเลอาซาร์​เป๋น​ป้อ​มัทธาน มัทธาน​เป๋น​ป้อ​ยาโคบ ");
INSERT INTO nod_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ยาโคบ​เป๋น​ป้อ​โยเซฟ ตี้​เป๋น​ผัว​นาง​มารีย์ แม่​ของ​พระเยซู ตี้​ฮ้อง​กั๋น​ว่า​พระคริสต์ ");
INSERT INTO nod_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ย้อน​จาอั้น​ตั้งแต่​อับราฮัม​ลง​มา​จ๋น​เถิง​กษัตริย์​ดาวิด​นับ​ได้​สิบ​สี่​เจ้น​คน ถ้า​นับ​ต่อ​จาก​ดาวิด​ลง​มา​จ๋น​เถิง​ต๋อน​ตี้​ถูก​บังคับ​ไป​เป๋น​เชลย​ตี้​ประเทศ​บาบิโลน ก็​นับ​ได้​แหม​สิบ​สี่​เจ้น​คน ตั้งแต่​ถูก​บังคับ​ไป​เป๋น​เชลย​จ๋น​เถิง​พระคริสต์​ก็​นับ​ได้​แหม​สิบ​สี่​เจ้น​คน ");
INSERT INTO nod_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","เรื่องราว​ตี้​พระเยซู​คริสต์​มา​เกิด​นั้น​เป๋น​จาอี้​คือ มารีย์​ตี้​เป๋น​แม่​ของ​พระเยซู​ได้​หมั้น​กับ​โยเซฟ​ไว้​แล้ว แต่​ก่อน​ตี้​ตึง​สอง​จะ​อยู่​กิ๋น​ตวย​กั๋น ป๋ากฏ​ว่า​มารีย์​มาน​เหีย​ก่อน​โดย​ฤทธิ์​เดช​ของ​พระวิญญาณ​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","โยเซฟ​กู้​หมั้น​ของ​มารีย์​นั้น​กึ๊ด​ใจ๋​จะ​ยกเลิก​ก๋าน​หมั้น​กับ​นาง แต่​เขา​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม​บ่﻿อยาก​หื้อ​นาง​อับ​อาย จึง​กะ​จะ​ยกเลิก​โดย​บ่﻿หื้อ​ใผ​ฮู้​เรื่อง​นี้ ");
INSERT INTO nod_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","หลังจาก​ตี้​โยเซฟ​กึ๊ด​จะ​เยียะ​จาอั้น ทูตสวรรค์​ของ​พระเจ้า​องค์​นึ่ง ก็​เข้า​ฝัน​โยเซฟ​บอก​ว่า “โยเซฟ​ลูก​หลาน​ของ​กษัตริย์​ดาวิด​เหย บ่﻿ถ้า​กั๋ว​ตี้​จะ​ฮับ​มารีย์​มา​เป๋น​เมีย​เน่อ ย้อน​ว่า​หละอ่อน​ใน​ต๊อง​ของ​นาง​นั้น เกิด​ขึ้น​จาก​ฤทธิ์​เดช​ของ​พระวิญญาณ​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","มารีย์​จะ​เกิด​ลูก​ป้อจาย เมื่อ​เกิด​มา​แล้ว​หื้อ​ตั้ง​จื้อ​ว่า ‘เยซู’ ย้อน​ว่า​ต้าน​จะ​จ้วย​คน​ของ​ต้าน​หื้อ​รอด​ป๊น​บาป​โต้ษ” ");
INSERT INTO nod_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","เรื่อง​ตึง​หมด​นี้ เกิด​ขึ้น​เปื้อ​จะ​เป๋น​ไป​ต๋าม​ตี้​พระเจ้า​ได้​อู้​ผ่าน​ตาง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“จะ​มี​แม่ญิง​สาว​บริสุทธิ์​คน​นึ่ง​มาน แล้ว​ก็​เกิด​ลูก​ป้อจาย คน​ตังหลาย​จะ​ฮ้อง​ต้าน​ว่า​อิมมานูเอล” แป๋​ว่า “พระเจ้า​อยู่​กับ​เฮา” ");
INSERT INTO nod_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","เมื่อ​โยเซฟ​ตื่น​ขึ้น​มา ก็​ได้​เยียะ​ต๋าม​ตี้​ทูตสวรรค์​ของ​พระเจ้า​สั่ง​ไว้ คือ​ฮับ​มารีย์​มา​เป๋น​เมีย​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","แต่​บ่﻿ได้​มี​อะหยัง​กับ​นาง​จ๋น​เต๊า​ฮอด​มารีย์​เกิด​ลูก แล้ว​โยเซฟ​ก็​ฮ้อง​จื้อ​ลูก​คน​นั้น​ว่า “เยซู” ");
INSERT INTO nod_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","พระเยซู​เกิด​ตี้​หมู่บ้าน​เบธเลเฮม​ใน​แคว้น​ยูเดีย ใน​สมัย​ของ​กษัตริย์​เฮโรด​เมื่อ​ลูน​มา​มี​หมู่​โหราจ๋ารย์ ลุก​ตัง​วันออก​เตียว​ตาง​มา​ตี้​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ถาม​ว่า “หละอ่อน​คน​นั้น ตี้​เกิด​มา​เป๋น​กษัตริย์​ของ​จาว​ยิว​อยู่​ตี้​ไหน หมู่​เฮา​ฮู้​ว่า​ต้าน​เกิด​มา​แล้ว ย้อน​หัน​ดาว​ตี้​แสดง​เถิง​ก๋าน​เกิด​ของ​ต้าน​ป๋ากฏ​ขึ้น​มา​ตัง​วันออก ก็​ปา​กั๋น​เตียวตาง​มา​ตี้​นี่​เปื้อ​นมัสก๋าน​ต้าน” ");
INSERT INTO nod_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","เมื่อ​กษัตริย์​เฮโรด​ได้​ยิน​จาอั้น ก็​ตุ๊ก​อก​ตุ๊ก​ใจ๋​ขนาด หมู่​จาว​กรุง​เยรูซาเล็ม​ก็​ปา​กั๋น​ตุ๊ก​ใจ๋​ตวย ");
INSERT INTO nod_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","กษัตริย์​เฮโรด​ฮ้อง​หมู่​หัวหน้า​ปุโรหิต​ตึง​หมู่​ธรรมาจ๋ารย์ มา​จุมนุม​กั๋น​ถาม​ว่า “พระคริสต์​จะ​เกิด​ตี้​ไหน” ");
INSERT INTO nod_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","หมู่​เขา​ตอบ​ว่า “ตี้​หมู่บ้าน​เบธเลเฮม​ใน​แคว้น​ยูเดีย ย้อน​ว่า​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​เขียน​ไว้​ว่า ");
INSERT INTO nod_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘หมู่​บ้าน​เบธเลเฮม​ใน​แผ่นดิน​ยูดาห์ บ่﻿ใจ้​หมู่บ้าน​สะ​เล็ก​สะ​หน้อย​ใน​หมู่​เมือง​ต่าง﻿ๆ ใน​แผ่นดิน​ยูดาห์​เน่อ ย้อน​ว่า​จะ​มี​เจ้านาย​คน​นึ่ง​ออก​มา​จาก​หมู่​เจ้า ตี้​จะ​มา​เป๋น​ผู้นำ​ตี้​เอา​ใจ๋​ใส่​จาว​อิสราเอล คน​ของ​เฮา’ ” ");
INSERT INTO nod_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","กษัตริย์​เฮโรด​ก็​เจิญ​หมู่​โหราจ๋ารย์​มา​ปะ​กั๋น​อย่าง​ลับ﻿ๆ แล้ว​อู้​กั๋น ถาม​เกี่ยว​กับ​ดาว​แก่น​นั้น​ป๋ากฏ​ขึ้น​มา​เมื่อ​ใด ");
INSERT INTO nod_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","เมื่อ​ฮู้​แล้ว​ก็​หื้อ​หมู่​โหราจ๋ารย์​ไป​ตี้​หมู่บ้าน​เบธเลเฮม​สั่ง​ว่า “ไป​เซาะ​หา​หละอ่อน​คน​นั้น​หื้อ​ดี﻿ๆ เต๊อะ เมื่อ​ปะ​แล้ว ขะใจ๋​ปิ๊ก​มา​บอก​เฮา​เวย﻿ๆ เปื้อ​เฮา​จะ​ไป​นมัสก๋าน​ต้าน​ตวย” ");
INSERT INTO nod_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","แล้ว​หมู่​โหราจ๋ารย์​ก็​ลา​ออก​ไป ดาว​แก่น​ตี้​ต้าน​เกย​หัน​ใน​ตัง​วันออก​นำ​หน้า​หมู่​เขา​ไป จ๋น​มา​หยุด​ตั๊ด​สถาน​ตี้ ตี้​หละอ่อน​คน​นั้น​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","เมื่อ​หมู่​โหราจ๋ารย์​หัน​ดาว​แก่น​นั้น ก็​ดี​อก​ดี​ใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","หมู่​เขา​ปา​กั๋น​เข้า​ไป​ใน​บ้าน​หลัง​นั้น ก็​ปะ​หละอ่อน​กับ​แม่​คือ​มารีย์ ก็​กราบ​ไหว้​กับ​นมัสก๋าน​แล้ว​เปิด​หีบ​สมบัติ​เอา คำ กำยาน มดยอบ​ออก​มา​ถวาย เป๋น​ของขวัญ​หื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","แล้ว​พระเจ้า​เตื๋อน​หมู่​โหราจ๋ารย์​ใน​ความ​ฝัน บ่﻿หื้อ​ปิ๊ก​ไป​หา​กษัตริย์​เฮโรด​แหม หมู่​เขา​ก็​ใจ๊​เส้น​ตาง​ตัง​อื่น เปื้อ​ปิ๊ก​ไป​บ้าน​เมือง​ของ​ตั๋วเก่า ");
INSERT INTO nod_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","เมื่อ​หมู่​โหราจ๋ารย์​ปิ๊ก​ไป​แล้ว ทูตสวรรค์​ของ​พระเจ้า​องค์​นึ่ง​มา​เข้า​ฝัน​โยเซฟ​บอก​ว่า “ลุก​ขึ้น ปา​สอง​แม่​ลูก​หนี​ไป​อยู่​ตี้​ประเทศ​อียิปต์ เถิง​แล้ว​หื้อ​อยู่​ตี้​หั้น จ๋น​กว่า​เฮา​จะ​บอก​หื้อ​ปิ๊ก​มา​แหม​ใหม่ ย้อน​ว่า​กษัตริย์​เฮโรด​ก่ำลัง​จะ​ส่ง​คน​มา​ตวย​ฆ่า​ลูก” ");
INSERT INTO nod_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","โยเซฟ​ก็​ลุก​ขึ้น​ปา​ลูก​กับ​มารีย์​ออก​เตียวตาง​ไป​ประเทศ​อียิปต์​ใน​คืน​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","หมู่​เขา​ปา​กั๋น​อยู่​ตี้​ประเทศ​อียิปต์​จ๋น​กษัตริย์​เฮโรด​ต๋าย ก็​เป๋น​ไป​ต๋าม​กำ​ตี้​พระเจ้า​ได้​บอก​ไว้​ผ่าน​ตาง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์​ว่า “เฮา​ได้​ฮ้อง​ลูก​ของ​เฮา​ออก​มา​จาก​ประเทศ​อียิปต์” ");
INSERT INTO nod_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","เมื่อ​กษัตริย์​เฮโรด​ฮู้​ว่า​ต้าน​โดน​หมู่​โหราจ๋ารย์​จุ​ก็​โขด​ขนาด จึง​สั่ง​หื้อ​ทหาร​ไป​ฆ่า​หละอ่อน​ป้อจาย​อายุ​สอง​ขวบ​ลง​มา​กู้​คน​ตี้​อยู่​ใน​หมู่​บ้าน​เบธเลเฮม ตึง​ต๋ำ​หมู่​บ้าน​ใก้﻿ๆ หั้น ย้อน​ว่า​กษัตริย์​เฮโรด​กึ๊ด​ว่า​เป๋น​เวลา​สอง​ปี๋​ผ่าน​มา​แล้ว​ตี้​หมู่​โหราจ๋ารย์​ได้​หัน​ดาว ");
INSERT INTO nod_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","เรื่อง​นี้​เกิด​ขึ้น​จาอี้ ก็​เป๋น​ไป​ต๋าม​ตี้​พระเจ้า​ได้​อู้​ผ่าน​คน​จื้อ​เยเรมีย์ ตี้​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ได้ยิน​เสียง​คน​ใน​หมู่​บ้าน​รามาห์ เป๋น​เสียง​ไห้​เสียง​หุย ย้อน​ความ​เสียใจ๋​ขนาด คือ​เสียง​นาง​ราเชล​ไห้﻿ๆ หุย﻿ๆ เรื่อง​ลูก​ตังหลาย​ของ​นาง ใผ​มา​อู้​เล้าโลม​จาใด​นาง​ตึง​บ่﻿ยอม​ฟัง ย้อน​ว่า​ลูก​ตังหลาย​ของ​นาง​บ่﻿มี​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","หลังจาก​กษัตริย์​เฮโรด​ต๋าย​แล้ว ทูตสวรรค์​ของ​พระเจ้า​ได้​เข้า​ฝัน​โยเซฟ​ต๋อน​อยู่​ใน​ประเทศ​อียิปต์​บอก​ว่า ");
INSERT INTO nod_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ลุก​ขึ้น หื้อ​ปา​สอง​แม่​ลูก​ปิ๊ก​ไป​ตี้​แผ่นดิน​อิสราเอล บ่าเดี่ยว​นี้​คน​ตี้​ต้องก๋าน​จะ​ฆ่า​ลูก​ได้​ต๋าย​ไป​หมด​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","โยเซฟ​ก็​ลุก​ขึ้น​ปา​ลูก​กับ​แม่​ปิ๊ก​ไป​ตี้​แผ่นดิน​อิสราเอล​แหม​ใหม่ ");
INSERT INTO nod_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","แต่​เมื่อ​โยเซฟ​ฮู้​ว่า​อารเคลาอัส​ได้​ขึ้น​เป๋น​กษัตริย์​ปกครอง​แคว้น​ยูเดีย แตน​กษัตริย์​เฮโรด​ป้อ​ของ​เขา ก็​กั๋ว​บ่﻿ก้า​ปิ๊ก​เข้า​ไป​ใน​แคว้น​ยูเดีย แต่​ใน​ความ​ฝัน​โยเซฟ​ได้​กำ​เตื๋อน​จาก​พระเจ้า​ว่า หื้อ​เตียว​ตาง​ไป​ตี้​แคว้น​กาลิลี​แตน ");
INSERT INTO nod_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","โยเซฟ​ปา​ครอบครัว​ไป​อยู่​ตี้​เมือง​นาซาเร็ธ กำ​ตี้​พระเจ้า​เกย​อู้​ผ่าน​มา​ตาง​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ก็​เกิด​ขึ้น​แต๊​ว่า “คน​ตังหลาย​จะ​ฮ้อง​ต้าน​ว่า จาว​นาซาเร็ธ” ");
INSERT INTO nod_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","หลาย​ปี๋​ผ่าน​มา ยอห์น​ผู้​หื้อ​บัพติศมา​บอก​คน​ใน​ดินแดน​ทุรกั๋นดาร​ใน​แคว้น​ยูเดีย ");
INSERT INTO nod_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ว่า “กลับใจ๋​จาก​บาป​เน่อ ย้อน​ว่า​แผ่นดิน​สวรรค์​ใก้​เข้า​มา​แผว​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​อู้​เถิง​ยอห์น​คน​นี้​ว่า “มี​เสียง​ฮ้อง​เอิ้น​ของ​คน​นึ่ง​ใน​ดินแดน​ทุรกั๋นดาร​ว่า ‘เกียม​ใจ๋​หื้อ​พร้อม สำหรับ​ก๋าน​เข้า​มา​ของ​องค์​พระ​ผู้​เป๋น​เจ้า จง​แป๋ง​หน​ตาง​ซื่อ﻿ๆ หื้อ​พระองค์’ ” ");
INSERT INTO nod_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ยอห์น​อยู่​ใน​ดินแดน​ทุรกั๋นดาร เขา​ใจ๊​จีวิต​อย่าง​เรียบ​ง่าย นุ่ง​เสื้อผ้า​ตี้​แป๋ง​จาก​ขน​อูฐ มี​สายฮ้าง​หนัง​มัด​แอว​แบบ​เดียว​กับ​เอลียาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ใน​สมัย​โบราณ กิ๋น​จั๊กแต๋น​กับ​น้ำเผิ้ง​ป่า​เป๋น​อาหาร ");
INSERT INTO nod_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","คน​จ๋ำนวน​นัก​จาก​กรุง​เยรูซาเล็ม ใคว่​แคว้น​ยูเดีย ตึง​ต๋ำ​แถว​แม่น้ำ​จอร์แดน​ปา​กั๋น​มา​ฟัง​ยอห์น​เตสนา ");
INSERT INTO nod_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","เมื่อ​หมู่​เขา​สารภาพ​บาป​แล้ว ยอห์น​ก็​หื้อ​หมู่​เขา​ฮับ​บัพติศมา​ใน​แม่น้ำ​จอร์แดน ");
INSERT INTO nod_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","แต่​เมื่อ​ยอห์น​หัน​หมู่​ฟาริสี​กับ​หมู่​สะดูสี​หลาย​คน​ปา​กั๋น​มา​เปื้อ​จะ​ฮับ​บัพติศมา ยอห์น​ว่า​หื้อ​หมู่​เขา​ว่า “หมู่​จ้าด​งู​ปิ๊ด ใผ​เตื๋อน​หื้อ​หมู่​เจ้า​หลบ​หนี​จาก​ก๋าน​ลงโต้ษ​ของ​พระเจ้า ตี้​ก่ำลัง​จะ​มา​เถิง ");
INSERT INTO nod_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","เยียะ​หื้อ​ผ่อ​กำ​ลุ​ว่า หมู่​เจ้า​มี​จีวิต​ตี้​กลับใจ๋​จาก​บาป​แล้ว​แต๊﻿ๆ ก่อน​ตี้​มา​ฮับ​บัพติศมา ");
INSERT INTO nod_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","บ่﻿ดี​กึ๊ด​เอา​คน​เดียว​ว่า ‘หมู่​เฮา​บ่﻿ต้อง​ถูก​ลงโต้ษ ย้อน​ว่า​หมู่​เฮา​เป๋น​ลูก​หลาน​ต๋านเต๊า​ของ​อับราฮัม’ เฮา​จะ​บอก​หื้อ​ฮู้​ว่า พระเจ้า​จะ​เยียะ​หื้อ​บ่าหิน​หมู่​นี้​ก๋าย​เป๋น​ลูก​หลาน​ของ​อับราฮัม​ก็​ได้​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","มุย​ได้​เกียม​แน​ไว้​ตี้​ปื๊น​เก๊าไม้​แล้ว เก๊าไม้​กู้​เก๊า​ตี้​เกิด​หน่วย​บ่﻿ดี​จะ​ถูก​ตัด แล้ว​ขว้าง​ใส่​ใน​ก๋อง​ไฟ ");
INSERT INTO nod_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“เฮา​หื้อ​หมู่​เจ้า​ฮับ​บัพติศมา​ด้วย​น้ำ​เปื้อ​หื้อ​หัน​ว่า หมู่​เจ้า​กลับใจ๋​จาก​บาป​แล้ว​แต๊﻿ๆ แต่​จะ​มี​ผู้​นึ่ง​มา​เมื่อ​ลูน​เฮา ตี้​ยิ่งใหญ่​เหลือ​เฮา แม้แต่​จะ​ติ้ว​เกิบ​หื้อ​พระองค์ ตั๋ว​เฮา​ยัง​บ่﻿สมควร​ตี้​จะ​เยียะ​จาอั้น​เลย พระองค์​จะ​หื้อ​เจ้า​ตังหลาย​ฮับ​บัพติศมา​ด้วย​พระวิญญาณ​บริสุทธิ์ กับ​ด้วย​ไฟ ");
INSERT INTO nod_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","พระองค์​เหมือน​จาวนา มือ​ของ​พระองค์​ก๋ำ​ผาก​หะ​ข้าว​ไว้ แล้ว​พระองค์​จะ​สะสาง​ตะราง​ตี๋​ข้าว​จ๋น​ใคว่ จะ​เก็บ​ข้าว​เต้ง​ไว้​ใน​หลองข้าว ส่วน​ข้าว​ลีบ​ก็​จะ​เอา​ไป​เผา​ไฟ​ตี้​บ่﻿ฮู้จัก​ดับ” ");
INSERT INTO nod_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ใน​ต๋อน​นั้น​พระเยซู​เตียวตาง​จาก​แคว้น​กาลิลี มา​หา​ยอห์น​ตี้​แม่น้ำ​จอร์แดน​เปื้อ​ขอ​ฮับ​บัพติศมา ");
INSERT INTO nod_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","แต่​ยอห์น​บ่﻿ยอม​เยียะ​หื้อ อ้าง​ว่า “พระองค์​ต้อง​เป๋น​คน​หื้อ​บัพติศมา​แก่​ข้าพเจ้า บ่﻿ใจ้​ข้าพเจ้า​เป๋น​คน​หื้อ​บัพติศมา​พระองค์” ");
INSERT INTO nod_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","แต่​พระเยซู​ตอบ​ยอห์น​ว่า “ใน​เตื้อ​นี้ หื้อ​เป๋น​จาอี้​ไป​ก่อน ย้อน​ว่า​หมู่​เฮา​เปิง​ดี​เยียะ​กู้​อย่าง​ต๋าม​ตี้​พระเจ้า​ต้องก๋าน” ยอห์น​ก็​หื้อ​บัพติศมา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","เมื่อ​พระเยซู​ฮับ​บัพติศมา​แล้ว ก็​ผด​ขึ้น​มา​จาก​น้ำ แล้ว​ฟ้า​สวรรค์​ก็​แหวก​ออก พระองค์​หัน​พระวิญญาณ​ของ​พระเจ้า​มี​ฮูปฮ่าง​เหมือน​นกก๋าแก๋​ลง​มา​อยู่​บน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","แล้ว​มี​เสียง​จาก​ฟ้า​สวรรค์​ว่า “ต้าน​ผู้​นี้​เป๋น​ลูก​ตี้​เฮา​ฮัก เฮา​เปิงใจ๋​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","แล้ว​พระวิญญาณ​ก็​ปา​พระเยซู​เข้า​ไป​อยู่​ใน​ดินแดน​ทุรกั๋นดาร เปื้อ​หื้อ​มาร​มา​ลองใจ๋​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","หลัง​จาก​พระเยซู​บ่﻿กิ๋น​ข้าว​มา​ได้​เป๋น​เวลา​สี่​สิบ​วัน​สี่​สิบ​คืน​แล้ว พระองค์​ก็​ใค่​อยาก​กิ๋น​ข้าว ");
INSERT INTO nod_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","มาร​ก็​มา​อู้​กับ​พระองค์​ว่า “ถ้า​ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า หื้อ​สั่ง​บ่าหิน​หมู่​นี้​เป๋น​เข้าหนมปัง​แล่” ");
INSERT INTO nod_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","พระเยซู​ตอบ​มาร​ว่า “พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘คน​เฮา​จะ​เลี้ยง​จีวิต​ด้วย​อาหาร​อย่าง​เดียว​บ่﻿ได้ แต่​ต้อง​เลี้ยง​จีวิต​โดย​ถ้อยกำ​ตี้​ออก​มา​จาก​ปาก​ของ​พระเจ้า​กู้​กำ​ตวย’ ” ");
INSERT INTO nod_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ต่อ​จาก​นั้น​มาร​ก็​ปา​พระเยซู​ไป​กรุง​เยรูซาเล็ม ปา​ขึ้น​ไป​อยู่​บน​หลังคา​พระวิหาร ");
INSERT INTO nod_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","แล้ว​บอก​พระองค์​ว่า “ถ้า​ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า​แต๊﻿ๆ ก็​หื้อ​โดด​ลง​ไป​แล่ ย้อน​พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘พระเจ้า​จะ​สั่ง​หื้อ​ทูตสวรรค์​มา​ปกปัก​ฮักษา​ต้าน เอา​มือ​ฮับ​ต้าน​ไว้​บ่﻿หื้อ​ตี๋น​ไป​ตุ๊บ​ใส่​บ่าหิน’ ” ");
INSERT INTO nod_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","พระเยซู​ตอบ​มาร​ว่า “แต่​พระคัมภีร์​มี​เขียน​ไว้​เหมือน​กั๋น​ว่า ‘ห้าม​ลองดี​องค์​พระผู้เป๋นเจ้า พระเจ้า​ของ​เจ้า’ ” ");
INSERT INTO nod_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ต่อไป​มาร​ปา​พระเยซู​ขึ้น​ไป​บน​ดอย​ตี้​สูง﻿ๆ หื้อ​พระองค์​ผ่อ​ความ​จ๋ำเริญ รุ่งเรือง​ของ​อาณาจักร​ตึง​หมด​ใน​โลก​นี้ ");
INSERT INTO nod_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","มาร​บอก​พระเยซู​ว่า “ถ้า​ต้าน​กราบ​ไหว้​นมัสก๋าน​เฮา เฮา​จะ​ยก​ตึง​หมด​นี้​หื้อ” ");
INSERT INTO nod_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","พระเยซู​อู้​กับ​มาร​ว่า “ไอ่​ซาต๋าน​ไป​ไก๋﻿ๆ บ่าเดี่ยว​นี้ พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘หื้อ​นมัสก๋าน​องค์​พระผู้เป๋นเจ้า พระเจ้า​ของ​เจ้า กับ​ฮับใจ๊​พระองค์​ผู้​เดียว​เต้าอั้น’” ");
INSERT INTO nod_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","แล้ว​มาร​ก็​ละ​พระเยซู​ไป หมู่​ทูตสวรรค์​ก็​มา​ผ่อกอย​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","เมื่อ​พระเยซู​ฮู้​ข่าว​ว่า​ยอห์น​โดน​ยับ​ขัง​คอก พระองค์​ก็​ปิ๊ก​ไป​แคว้น​กาลิลี ");
INSERT INTO nod_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ไป​เถิง​เมือง​นาซาเร็ธ แล้ว​ลวด​ไป​อยู่​เมือง​คาเปอรนาอุม ตี้​อยู่​ฮิม​ฝั่ง​ทะเลสาบ​กาลิลี​ใน​เขต​แดน​ของ​เศบูลุน​กับ​นัฟทาลี ");
INSERT INTO nod_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“คน​ใน​ดินแดน​เศบูลุน​กับ​ดินแดน​นัฟทาลี ตี้​อยู่​ตาง​ไป​ทะเลสาบ​กาลิลี ตัง​วันตก​ของ​แม่น้ำ​จอร์แดน เป๋น​ดินแดน​ของ​แคว้น​กาลิลี​ตี้​คน​ต่างจ้าด​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","คน​ตี้​อยู่​ใน​ความ​มืด​ได้​หัน​แสง​แจ้ง​ตี้​ยิ่งใหญ่​แล้ว คน​ตี้​อยู่​ปื๊น​ฮ่ม​เงา​แห่ง​ความ​ต๋าย​นั้น แสง​สว่าง​ก็​ได้​ส่อง​มา​เถิง​หมู่​เขา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ตั้งแต่​นั้น​มา​พระเยซู​ก็​ตั้ง​เก๊า​บอก​ว่า “หื้อ​กลับใจ๋​จาก​บาป​เหีย ย้อน​ว่า​แผ่นดิน​สวรรค์​ใก้​เข้า​มา​แผว​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","วัน​นึ่ง​ต๋อน​ตี้​พระเยซู​ก่ำลัง​เตียว​อยู่​ฮิม​ฝั่ง​ทะเลสาบ​กาลิลี ก็​หัน​ใส่​คน​หา​ป๋า​สอง​คน​ปี้น้อง คน​อ้าย​จื้อ​ซีโมน​ตี้​ฮ้อง​แหม​จื้อ​ว่า​เปโตร กับ​น้อง​บ่าว​จื้อ​อันดรูว์ หมู่​เขา​ก่ำลัง​ต้อด​แห​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","พระองค์​ก็​อู้​กับ​หมู่​เขา​ว่า “ตวย​เฮา​มา​เป๋น​สาวก​เฮา​เต๊อะ เฮา​จะ​สอน​หื้อ​ต้าน​เซาะ​หา​คน​เหมือน​เซาะ​หา​ป๋า” ");
INSERT INTO nod_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ตึง​สอง​คน​ก็​สวะ​แห แล้ว​ปา​กั๋น​ตวย​พระองค์​ไป​ตัน​บาด​ตัน​บ้วง ");
INSERT INTO nod_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","เมื่อ​พระองค์​เตียว​ต่อ​ไป​แหม​น่อย ก็​หัน​แหม​สอง​คน​ปี้น้อง คือ ยากอบ​กับ​ยอห์น ตึง​สอง​คน​เป๋น​ลูกบ่าว​ของ​เศเบดี ก่ำลัง​ซ่อม​แห​กับ​ป้อ​ของ​เขา​ใน​เฮือ แล้ว​พระองค์​ก็​ฮ้อง​สอง​คน​ปี้น้อง​นี้​มา ");
INSERT INTO nod_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ยากอบ​กับ​ยอห์น​ก็​ละ​เฮือ​กับ​ลา​ป้อ​แล้ว​ตวย​พระเยซู​ไป​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","พระเยซู​เตียวตาง​ไป​ใคว่​แคว้น​กาลิลี เปื้อ​เตสนา​สั่ง​สอน​ใน​ธรรมศาลา​ของ​จาว​ยิว กับ​บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า​หื้อ​คน​ฮู้ ป๋าย​บ่﻿ปอ​ยัง​ฮักษา​คน​เป๋น​พยาธิ​ต่าง﻿ๆ หื้อ​หาย​ตวย ");
INSERT INTO nod_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","เยียะ​หื้อ​จื้อ​เสียง​ของ​พระองค์​ดัง​ไป​ใคว่​ประเทศ​ซีเรีย หมู่​คน​ก็​ปา​คน​ตังหลาย​ตี้​เป๋น​พยาธิ​ต่าง﻿ๆ มา​หา​พระองค์ อย่าง​คน​ตี้​เจ็บ​ป่วย​นัก คน​โดน​ผี​เข้า คน​เป๋น​ลม​บ้า​หมู คน​เป๋น​ง่อย พระองค์​ก็​ได้​ฮักษา​หมู่​เขา​จ๋น​หาย​กั๋น​หมด​กู้​คน ");
INSERT INTO nod_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","พระเยซู​ไป​ตัง​ใด คน​จ๋ำนวน​นัก​ก็​ตวย​พระองค์​ไป มี​ตึง​คน​ตี้​มา​จาก​แคว้น​กาลิลี แคว้น​ทศบุรี กรุง​เยรูซาเล็ม แคว้น​ยูเดีย ตึง​ดินแดน​ตัง​วันออก​ของ​แม่น้ำ​จอร์แดน​ตวย ");
INSERT INTO nod_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","เมื่อ​พระเยซู​หัน​หมู่​คน​ตวย​มา​เป๋น​จ๋ำนวน​นัก พระองค์​ก็​ขึ้น​ไป​บน​ดอย แล้ว​นั่ง​อยู่​ตี้​หั้น หมู่​สาวก​ก็​เข้า​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","พระองค์​ตั้งเก๊า​เตสนา​สั่ง​สอน​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“คน​ใด​ตี้​ตุ๊กยาก​ตาง​ฝ่าย​วิญญาณ พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข ย้อน​ว่า​เขา​ได้​เป๋น​คน​ของ​แผ่นดิน​สวรรค์​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","คน​ใด​เป๋น​ตุ๊ก​โศกเศร้า พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข ย้อน​ว่า​เขา​จะ​ได้​ฮับ​ก๋าน​เล้าโลม​ใจ๋​จาก​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","คน​ใด​มี​จิตใจ๋​อ่อนน้อม พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข ย้อน​ว่า​เขา​จะ​ได้​ฮับ​แผ่นดิน​โลก​เป๋น​มรดก ");
INSERT INTO nod_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","คน​ใด​ใค่​เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​พระเจ้า​นัก​เหลือ​สิ่ง​อื่น﻿ๆ พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข ย้อน​ว่า​เขา​จะ​ได้​อิ่ม​อก​อิ่ม​ใจ๋ ");
INSERT INTO nod_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","คน​ใด​มี​ใจ๋​เมตต๋า พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข ย้อน​ว่า​พระเจ้า​จะ​เมตต๋า​อินดู​เขา ");
INSERT INTO nod_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","คน​ใด​มี​ใจ๋​บริสุทธิ์​หมดใส​จงฮัก​ภักดี​ต่อ​พระเจ้า​แต๊﻿ๆ พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข ย้อน​ว่า​เขา​จะ​ได้​หัน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","คน​ใด​สร้าง​ความ​สงบ​สุข พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข ย้อน​ว่า​พระเจ้า​จะ​ถือ​ว่า​เขา​เป๋น​ลูก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","คน​ใด​โดน​ค่ำ​ย้อน​เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​พระเจ้า พระเจ้า​โผด​หื้อ​คน​นั้น​เป๋น​สุข เขา​ได้​เป๋น​คน​ของ​แผ่นดิน​สวรรค์​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“เมื่อ​ใด​หมู่​ต้าน​โดน​ดู​ถูก​ดู​แควน โดน​ค่ำ ถูก​ใส่ฮ้าย​ตี้​บ่﻿เป๋น​เรื่อง​แต๊ ย้อน​ติดต๋าม​ตวย​เฮา พระเจ้า​โผด​หื้อ​หมู่​ต้าน​เป๋น​สุข ");
INSERT INTO nod_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","จง​จื้นจม​ยินดี​เต๊อะ ย้อน​ว่า​พระเจ้า​มี​รางวัล​อัน​ยิ่งใหญ่​ไว้​ใน​สวรรค์​สำหรับ​หมู่​ต้าน​แล้ว หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​สมัย​เก่า​ก่อน ก็​โดน​ค่ำ​จาอี้​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ต้าน​ตังหลาย​เผียบ​เหมือน​เกื๋อ​สำหรับ​คน​ใน​โลก​นี้​ถ้า​เกื๋อ​จ๋าง​ไป​เหีย จะ​เยียะ​หื้อ​เก็ม​แหม​ตึง​บ่﻿ได้ บ่﻿มี​ประโยชน์​อะหยัง​แหม​ต่อไป เอา​ขว้าง​หื้อ​คน​ย่ำ​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ต้าน​ตังหลาย​เผียบ​เป๋น​ความ​เป่งแจ้ง​สำหรับ​คน​ใน​โลก​นี้ เมือง​ตี้​แป๋ง​ไว้​บน​ดอย​จะ​เอา​ซ่อน​บ่﻿หื้อ​คน​หัน​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","เผียบ​เหมือน​เมื่อ​ต๋าม​โกม​ไฟ ก็​บ่﻿มี​ใผ​เอา​ถัง​มา​ควบ​ไว้​เหีย แต่​จะ​เอา​โกม​นั้น​ตั้ง​ไว้​บน​ตั่ง เปื้อ​จะ​ส่อง​แจ้ง​เฮื่อฮ่าม​หื้อ​คน​ตังหลาย​ใน​เฮือน​นั้น​ได้​หัน​ถี่﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","หมู่​ต้าน​ก็​เหมือน​กั๋น จง​ส่อง​แจ้ง​ออก​ไป​หื้อ​คน​ตังหลาย​ได้​หัน เปื้อ​เมื่อ​หมู่​เขา​ได้​หัน​ก๋าน​ดี​ตี้​ต้าน​ตังหลาย​เยียะ ก็​จะ​สรรเสริญ​พระเจ้า​พระบิดา​ของ​ต้าน ผู้​ตี้​อยู่​ใน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“จะ​ไป​กึ๊ด​ว่า​เฮา​มา​ยกเลิก​บท​บัญญัติ​ของ​โมเสส กาว่า​มา​ยกเลิก​กำสอน​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​เขียน​ไว้ เฮา​บ่﻿ได้​มา​ยกเลิก​ของ​หมู่​นั้น​เน่อ แต่​มา​เยียะ​หื้อ​ครบ​ถูกต้อง​ต๋าม​ตี้​เขียน​ไว้​นั้น ");
INSERT INTO nod_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เมื่อ​ฟ้า​กับ​ดิน​ยัง​มี​อยู่ จะ​บ่﻿มี​อักษร​ตั๋ว​ใด​กาว่า​ขีด﻿ๆ นึ่ง​จะ​สูญหาย​ไป​จาก​บท​บัญญัติ จ๋น​กว่า​กู้​สิ่ง​กู้​อย่าง​ใน​บท​บัญญัติ​นั้น​จะ​สำเร็จ​ครบ​ถ้วน ");
INSERT INTO nod_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ย้อน​จาอั้น​คน​ใด​บ่﻿เยียะ​ต๋าม​บท​บัญญัติ​ข้อ​เล็ก﻿ๆ หน้อย﻿ๆ ยัง​แอกขะแตก​สอน​คน​อื่น​หื้อ​เยียะ​เหมือน​ตั๋ว​เก่า​แหม คน​นั้น​จะ​ได้​จื้อ​ว่า​เป๋น​คน​เล็ก​หน้อย​ตี้​สุด​ใน​แผ่นดิน​สวรรค์ แต่​ถ้า​คน​ใด​ตึง​สอน​ตึง​ได้​เยียะ​ต๋าม​บท​บัญญัติ​นั้น คน​นั้น​จะ​ได้​จื้อ​ว่า​เป๋น​คน​ยิ่ง​ใหญ่​ใน​แผ่นดิน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","เฮา​จะ​บอก​หื้อ​ฮู้​ว่า ถ้า​ต้าน​ตังหลาย​บ่﻿เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​พระเจ้า​นัก​เหลือ​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี ต้าน​จะ​เข้า​แผ่นดิน​สวรรค์​บ่﻿ได้​เลย ");
INSERT INTO nod_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ต้าน​ตังหลาย​เกย​ได้​ยิน​กำสอน​ของ​โมเสส​ตี้​สอน​คน​ใน​สมัย​โบราณ​ว่า ‘ห้าม​ฆ่า​คน’ ถ้า​ใผ​ฆ่า​คน คน​นั้น​จะ​ถูก​ตัดสิน​ลงโต้ษ​ต๋าม​บท​บัญญัติ ");
INSERT INTO nod_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","แต่​เฮา​บอก​ต้าน​ตังหลาย​ว่า ถ้า​ใผ​โขด​หื้อ​ปี้น้อง​ของ​ตั๋ว คน​นั้น​จะ​ถูก​ตัดสิน​ลงโต้ษ ถ้า​ใผ​ด่า​ปี้น้อง​ว่า ‘ไอ่​สึ่ง​ตึง’ ก็​จะ​ถูก​ปา​ขึ้น​ศาล​ของ​สภา​จาว​ยิว ถ้า​ใผ​ด่า​ปี้น้อง​ว่า ‘ไอ่​ง่าว’ คน​นั้น​จะ​ได้​ฮับ​โต้ษ​เถิง​ตก​หม้อหน้าฮก ");
INSERT INTO nod_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“ย้อน​จาอั้น​ถ้า​ต้าน​เอา​เครื่อง​ปู่จา​มา​เถิง​แต้น​ปู่จา​แล้ว แต่​กึ๊ด​ได้​ว่า​ปี้น้อง​โขด​หื้อ​ต้าน​ใน​สิ่ง​ตี้​ต้าน​ได้​เยียะ​ไป ");
INSERT INTO nod_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","หื้อ​ต้าน​วาง​เครื่อง​ปู่จา​นั้น​ไว้​หั้น แล้ว​ขะใจ๋​ปิ๊ก​ไป​คืนดี​กับ​ปี้น้อง​คน​นั้น​เหีย​ก่อน แล้ว​ปิ๊ก​มา​ถวาย​ของ​ปู่จา​แก่​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ถ้า​เป๋น​ถ้อย​เป๋น​ความ​กับ​ใผ​คน​ใด หื้อ​ขะใจ๋​อู้​ตกลง​กั๋น​เวย﻿ๆ ใน​หละหว่าง​ก๋าง​ตาง​ตี้​ก่ำลัง​เตียว​ไป ก่อน​ตี้​ก่ำลัง​จะ​ขึ้น​ศาล ถ้า​บ่﻿จาอั้น​คน​ตี้​เป๋น​คน​ฟ้อง​จะ​มอบ​ต้าน​หื้อ​ผู้​พิพากษา แล้ว​ผู้​พิพากษา​จะ​มอบ​ต้าน​หื้อ​นาย​กุม​คอก นาย​กุม​คอก​ก็​จะ​เอา​ต้าน​ไป​ขัง​คอก​ไว้​เหีย ");
INSERT INTO nod_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ต้าน​จะ​ออก​จาก​คอก​ตึง​บ่﻿ได้ จ๋น​กว่า​จะ​จ่าย​ก้า​ปรับ​จ๋น​ครบ​กู้​บาท​กู้​สตางค์​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ต้าน​ตังหลาย​ฮู้​กำ​ตี้​โมเสส​ได้​สอน​ไว้​ว่า ‘ห้าม​เป๋น​จู๊​ผัว​เมีย​เปิ้น’ ");
INSERT INTO nod_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","แต่​เฮา​จะ​บอก​ต้าน​ว่า ถ้า​ต้าน​ผ่อ​แม่ญิง​แล้ว​กึ๊ด​ใน​ตาง​บ่﻿ดี ต้าน​ก็​ได้​หลง​ผิด​เป๋น​จู๊​ตาง​ใจ๋​กับ​แม่ญิง​คน​นั้น​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ย้อน​จาอั้น​ถ้า​แก่นต๋า​เบื้อง​ขวา​ของ​ต้าน เยียะ​หื้อ​ต้าน​เป๋น​บาป ก็​หื้อ​ควัด​ต๋า​เผิก​นั้น​ขว้าง​ไป​เหีย ย้อน​ว่า​ถ้า​เสีย​อวัยวะ​ไป​อย่าง​นึ่ง ก็​ยัง​ดี​เหลือ​มี​ตึง​เนื้อ​ตึง​ตั๋ว​ครบ​หมด แต่​ต้อง​ตก​หม้อหน้าฮก ");
INSERT INTO nod_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ถ้า​มือ​เบื้อง​ขวา​ของ​ต้าน​เยียะ​หื้อ​ต้าน​เป๋น​บาป หื้อ​ตัด​มือ​เบื้อง​นั้น​ขว้าง​ไป​เหีย ย้อน​ว่า​ถ้า​เสีย​อวัยวะ​ไป​อย่าง​นึ่ง ก็​ยัง​ดี​เหลือ​มี​ตึง​เนื้อ​ตึง​ตั๋ว​ครบ​หมด​แต่​ต้อง​ถูก​ส่ง​ลง​หม้อหน้าฮก ");
INSERT INTO nod_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“โมเสส​ก็​ได้​สอน​ตวย​ว่า ‘ถ้า​ใผ​คน​ใด​จะ​ละ​เมีย ก็​หื้อ​เขียน​ใบหย่า​หื้อ​เมีย​เหีย’ ");
INSERT INTO nod_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","แต่​เฮา​บอก​ต้าน​ตังหลาย​ว่า ป้อจาย​คน​ใด​ละ​เมีย​ย้อน​สาเหตุ​อื่น﻿ๆ นอกจาก​ป้อจาย​ไป​เล่นจู๊ ก็​เยียะ​หื้อ​เมีย​ผิด​เรื่อง​ก๋าน​ล่วง​ประเวณี​เมื่อ​มี​ผัว​ใหม่ ป้อจาย​คน​ใด​ตี้​มา​แต่งงาน​กับ​แม่ญิง​คน​นี้ ก็​ผิด​เรื่อง​ก๋าน​ล่วง​ประเวณี​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ต้าน​ตังหลาย​เกย​ได้ยิน​กำ​สอน​ของ​โมเสส ตี้​สอน​คน​ใน​สมัย​โบราณ​ว่า ‘ห้าม​หื้อ​เสีย​กำ​สาบาน​แต่​หื้อ​เยียะ​ตวย​ต๋าม​กำ​สาบาน ตี้​ได้​ถวาย​แก่​องค์​พระผู้เป๋นเจ้า​นั้น’ ");
INSERT INTO nod_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","แต่​เฮา​บอก​ต้าน​ตังหลาย​ว่า บ่﻿ดี​สาบาน​เลย ถ้า​สาบาน​โดย​อ้าง​เถิง​สวรรค์​ก็​เหมือน​อ้าง​เถิง​พระเจ้า ย้อน​ว่า​สวรรค์​เป๋น​ตี้​พระเจ้า​นั่ง​ปกครอง​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","กาว่า​บ่﻿ดี​สาบาน​โดย​อ้าง​เถิง​โลก​นี้​ใน​กำ​สาบาน ย้อน​ว่า​โลก​นี้​ก็​เป๋น​ตี้​ฮอง​ตี๋น​ของ​พระเจ้า กาว่า​โดย​อ้าง​เถิง​กรุง​เยรูซาเล็ม​ใน​กำ​สาบาน ย้อน​ว่า​กรุง​เยรูซาเล็ม​ก็​เป๋น​กรุง​ของ​พระ​มหา​กษัตริย์ อ้าง​จาอี้​ก็​เหมือน​อ้าง​เถิง​พระเจ้า​ตวย ");
INSERT INTO nod_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","กาว่า​จะ​ใจ๊​หัว​ของ​ตั๋ว​เก่า​เป๋น​ประกั๋น​ใน​กำ​สาบาน​ก็​เยียะ​บ่﻿ได้ ย้อน​ว่า​ผม​บน​หัว​ของ​ต้าน แม้​แต่​เส้น​เดียว​ก็​ยัง​บ่﻿มี​ปั๋ญญา​เยียะ​หื้อ​ดำกิก กาว่า​หงอก​ขาว​เผือะ​ขาว​เผือก​ได้​เลย ");
INSERT INTO nod_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ถ้า ‘ใจ้’ ก็​บอก​ว่า ‘ใจ้’ ถ้า ‘บ่﻿ใจ้’ ก็​บอก​ว่า ‘บ่﻿ใจ้’ อู้​มอกอี้​ปอ​แล้ว อู้​นัก​เหลือ​นี้​ก็​มา​จาก​มาร ");
INSERT INTO nod_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ต้าน​ตังหลาย​ฮู้​กำ​ตี้​โมเสส​ได้​อู้​ไว้​ว่า ‘เอา​แก่น​ต๋า​ส้าย​แก่น​ต๋า เอา​เขี้ยว​ส้าย​เขี้ยว’ ");
INSERT INTO nod_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","แต่​เฮา​บอก​ต้าน​ตังหลาย​ว่า บ่﻿ดี​แก้แค้น​คน​ตี้​เยียะ​ผิด​เยียะ​ฮ้าย​ต่อ​ต้าน ถ้า​ใผ​คน​ใด​ตบ​แก้ม​เผิก​ขวา​ของ​ต้าน ก็​หื้อ​บิ่น​แก้ม​เผิก​ซ้าย​หื้อ​เขา​ตบ​แหม ");
INSERT INTO nod_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ถ้า​ใผ​คน​ใด​ก็​ต๋าม​ไป​ฟ้อง​ศาล​เปื้อ​ลู่​เอา​เสื้อ​ของ​ต้าน​เป๋น​ก้า​ไหม ก็​หื้อ​ต้าน​ถอด​เสื้อ​คุม​แถม​เขา​ไป​แหม​ผืน ");
INSERT INTO nod_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ถ้า​ทหาร​คน​ใด​เข​หื้อ​ต้าน​แบก​ของ​ของ​เขา เตียว​ตวย​ก้น​เขา​ไป​ไก๋​นึ่ง​กิโลเมตร หื้อ​ต้าน​ยอม​แบก​ของ​นั้น​เตียว​ต่อ​ไป​แหม​นึ่ง​กิโลเมตร​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ถ้า​ใผ​มา​ขอ​ของ​อะหยัง​จาก​ต้าน​ก็​หื้อ​เขา​ไป ถ้า​มี​ใผ​มา​ขอ​ยืม​อะหยัง​จาก​ต้าน ก็​จะ​ไป​บิ่น​หลัง​ต๋ำ​เขา​คน​นั้น​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ต้าน​ตังหลาย​ฮู้​กำ​ตี้​โมเสส​ได้​อู้​ไว้​ว่า ‘จง​ฮัก​เปื้อน​บ้าน​ของ​ต้าน แล้ว​หื้อ​จัง​ศัตรู๋’ ");
INSERT INTO nod_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","แต่​เฮา​บอก​ต้าน​ตังหลาย​ว่า​จง​ฮัก​ศัตรู๋​ของ​ต้าน หื้อ​อธิษฐาน​เผื่อ​คน​ตี้​ค่ำ​หมู่​ต้าน​ตวย ");
INSERT INTO nod_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ถ้า​ต้าน​ตังหลาย​เยียะ​จาอี้​แล้ว ก็​แสดง​ว่า​ต้าน​เป๋น​ลูก​แต๊﻿ๆ ของ​พระบิดา​ตี้​อยู่​ใน​สวรรค์ ย้อน​ว่า​พระองค์​ก็​เยียะ​หื้อ​ตะวัน​ส่อง​แจ้ง​หลึ​แจ้ง​หลึ้ง​ตึง​คน​บ่﻿ดี​กับ​คน​ดี ก็​หื้อ​ฝน​ตก​ลง​มา​ใส่​ตึง​คน​ตี้​เยียะ​ดี​ตึง​คน​ตี้​เยียะ​ฮ้าย​เหมือน​กั๋น​หมด​กู้​คน ");
INSERT INTO nod_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ถ้า​ต้าน​ตังหลาย​ฮัก​ก้า​คน​ตี้​ฮัก​ต้าน​ต้าน​จะ​ได้​รางวัล​อะหยัง ย้อน​ว่า​แม้​แต่​คน​เก็บ​ภาษี ก็​ยัง​ฮัก​คน​ตี้​ฮัก​เขา​เหมือน​กั๋น​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ถ้า​ต้าน​เอา​ก้า​อู้​ตั๊กตวาย​หมู่​ญาติ​ปี้น้อง​เปื้อน​ฝูง​ของ​ตั๋ว​เก่า​อย่าง​เดียว​เต้าอั้น ต้าน​จะ​ดี​เหลือ​คน​อื่น﻿ๆ จาใด ย้อน​ว่า​คน​ตี้​บ่﻿ฮู้จัก​พระเจ้า​ก็​เยียะ​อย่าง​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ย้อน​จาอั้น​หื้อ​เป๋น​คน​ดี​พร้อม​กู้​อย่าง เหมือน​พระบิดา​ของ​ต้าน​ตี้​อยู่​ใน​สวรรค์​เป๋น​ผู้​ดี​พร้อม​กู้​อย่าง ");
INSERT INTO nod_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“หละวัง​หื้อ​ดี​เน่อ ห้าม​แต่ง​เยียะ​ความ​ดี​ตัง​ศาสนา เปื้อ​อวด​คน​อื่น​เต้าอั้น ย้อน​ว่า​ถ้า​เยียะ​จาอั้น ต้าน​จะ​บ่﻿ได้​ฮับ​รางวัล​สัก​อย่าง​จาก​พระบิดา​ของ​ต้าน​ตี้​อยู่​ใน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ย้อน​จาอั้น เมื่อ​ใด​ก็​ต๋าม​ตี้​ต้าน​จ้วย​เหลือ​คน​ตุ๊ก​คน​จ๋น ก็​ห้าม​เยียะ​เหมือน​กับ​หมู่​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ตี้​หูม​เป่า​แก​ใน​ธรรมศาลา กาว่า​ต๋าม​หน​ตาง เปื้อ​จะ​หื้อ​คน​ยกยอ​ปอปั้น​เขา เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า หมู่​เขา​ก็​ได้​ฮับ​รางวัล​เรียบร้อย​แล้ว จะ​บ่﻿มี​รางวัล​จาก​พระเจ้า​เลย ");
INSERT INTO nod_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ต๋อน​ตี้​หื้อ​ตาน​นั้น ห้าม​หื้อ​ใผ​ฮู้ เหมือน​กับ​มือ​ซ้าย​หื้อ​ตาน​แต่​บ่﻿หื้อ​มือ​ขวา​ฮู้ ");
INSERT INTO nod_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","เปื้อ​ว่า​ก๋าน​หื้อ​ตาน​ของ​ต้าน​นั้น จะ​เป๋น​ความ​ลับ แล้ว​พระบิดา​ของ​หมู่​ต้าน ผู้​ตี้​หัน​สิ่ง​ตี้​หมู่​ต้าน​ลัก​เยียะ ก็​จะ​โผด​หื้อ​รางวัล​แก่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“เมื่อ​ต้าน​อธิษฐาน ก็​ห้าม​เยียะ​เหมือน​หมู่​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ตี้​ซอบ​ยืน​อธิษฐาน​ใน​ธรรมศาลา กับ​ต๋าม​หนตาง เปื้อ​อวด​หื้อ​คน​อื่น﻿ๆ หัน เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า หมู่​เขา​ได้​ฮับ​รางวัล​ของ​เขา​ไป​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ส่วน​ต้าน​ต๋อน​ตี้​จะ​อธิษฐาน ก็​หื้อ​เข้า​ไป​ใน​ห้อง หับ​ปะตู๋ แล้ว​อธิษฐาน​ต่อ​พระบิดา​ของ​ต้าน​ตี้​ผ่อ​บ่﻿หัน แล้ว​พระองค์​ผู้​ตี้​หัน​สิ่ง​ตี้​ต้าน​ลัก​เยียะ ก็​จะ​โผด​หื้อ​รางวัล​แก่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“แล้ว​ต๋อน​ตี้​ต้าน​อธิษฐาน​อยู่​นั้น ก็​ห้าม​อู้​หลื้ม​เก่า​หลื้ม​ใหม่ เหมือน​คน​ตี้​บ่﻿ฮู้จัก​พระเจ้า​เยียะ​กั๋น ย้อน​ว่า​หมู่​เขา​กึ๊ด​ว่า​ถ้า​เยียะ​จาอั้น​แล้ว หมู่​เขา​ก็​จะ​ได้​ฮับ​กำตอบ​จาก​ก๋าน​อธิษฐาน​นั้น ");
INSERT INTO nod_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ห้าม​เยียะ​เหมือน​กับ​คน​หมู่​นั้น​เน่อ ย้อน​ว่า​พระบิดา​ฮู้​แล้ว​ว่า​ต้าน​ต้องก๋าน​อะหยัง​พ่อง ก่อน​ตี้​ต้าน​จะ​อ้า​ปาก​ขอ ");
INSERT INTO nod_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“​ตั้งแต่​นี้​ต่อ​ไป​หื้อ​ต้าน​ตังหลาย​อธิษฐาน​จาอี้​ว่า ‘​ข้า​แต่​พระบิดา​ของ​ข้า​พระองค์​ตังหลาย​ผู้​ตี้​อยู่​ใน​สวรรค์ ขอ​หื้อ​นาม​ของ​พระองค์​เป๋น​ตี้​นับถือ ");
INSERT INTO nod_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ขอ​หื้อ​แผ่นดิน​ของ​พระองค์​มา​ตั้ง​อยู่ ขอ​หื้อ​คน​ตังหลาย​เยียะ​ตวย​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์​ใน​โลก​นี้​เหมือน​อย่าง​เดียว​กั๋น​ตี้​เยียะ​ใน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ขอ​โผด​หื้อ​ข้า​พระองค์​ตังหลาย​มี​อาหาร​กิ๋น​ใน​วัน​นี้ ");
INSERT INTO nod_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ขอ​โผด​ยก​โต้ษ​บาป​ของ​ข้า​พระองค์​ตังหลาย เหมือน​กับ​ตี้​ข้า​พระองค์​ตังหลาย​ยกโต้ษ​หื้อ​คน​อื่น​ตี้​เยียะ​บ่﻿ดี​ต่อ​ข้า​พระองค์​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","แล้ว​ขอ​บ่﻿หื้อ​ปา​ข้า​พระองค์​ตังหลาย​เข้า​ไป​หา​ก๋าน​ลองใจ๋ แต่​ขอ​จ้วย​หื้อ​ป๊น​จาก​สิ่ง​บ่﻿ดี​’ ");
INSERT INTO nod_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ย้อน​ว่า​ถ้า​หมู่​ต้าน​จะ​ยกโต้ษ​หื้อ​คน​ตี้​เยียะ​บ่﻿ดี​แก่​ต้าน พระบิดา​ของ​ต้าน​ตี้​อยู่​ใน​สวรรค์​ก็​จะ​โผด​ยกโต้ษ​หื้อ​ต้าน​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","แต่​ถ้า​ต้าน​บ่﻿ยอม​ยกโต้ษ​บาป​หื้อ​คน​อื่น พระบิดา​ของ​ต้าน​ก็​จะ​บ่﻿ยอม​โผด​ยกโต้ษ​บาป​ของ​ต้าน​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“เมื่อ​ต้าน​ถือ​อด​อาหาร​เตื้อ​ใด​ก็​ต๋าม ห้าม​แป๋ง​หน้าหมอง​ต๋องเศร้า เหมือน​หมู่​คน​หน้า​ซื่อ​ใจ๋​ก๊ด​เยียะ​กั๋น หมู่​เขา​บ่﻿ซ่วย​หน้า​ล้าง​ต๋า บ่﻿หวี​ผม​หื้อ​ผ่อ​เหมือน​บ่﻿สบาย เปื้อ​ใค่​หื้อ​คน​ตังหลาย​หัน​ว่า​เขา​ก่ำลัง​ถือ​ศีล​อด​อาหาร​อยู่ แล้ว​ยกยอ​ปอปั้น​เขา แต่​เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า หมู่​เขา​ได้​ฮับ​รางวัล​เรียบร้อย​แล้ว จะ​บ่﻿มี​รางวัล​จาก​พระเจ้า​เลย ");
INSERT INTO nod_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","แต่​เมื่อ​ใด​ตี้​ต้าน​ตังหลาย​ถือ​ศีล​อด​อาหาร​อยู่ ขอ​หื้อ​ซ่วย​หน้า​ล้าง​ต๋า กับ​หวี​ผม​เหมือน​ตี้​เกย​เยียะ​ตึง​วัน ");
INSERT INTO nod_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","เปื้อ​จะ​บ่﻿หื้อ​ใผ​ฮู้​เลย​ว่า​ต้าน​ก่ำลัง​ถือ​ศีล​อด​อาหาร​อยู่ แต่​พระบิดา​ผู้​ตี้​ผ่อ​บ่﻿หัน จะ​หัน​สิ่ง​ตี้​ต้าน​ลัก​เยียะ ก็​จะ​หื้อ​รางวัล​แก่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ห้าม​เอา​ก้า​เก็บ​ฮอม​ทรัพย์​สมบัติ​ไว้​หื้อ​ตั๋ว​ใน​โลก​นี้ เซิ่ง​ขี้​เมี่ยง​กาว่า​แมง​จะ​มา​ขบ​กิ๋น​เยียะ​หื้อ​ทรัพย์​สมบัติ​เสีย​หาย​ได้ กาว่า​ตี้​ขโมย​จะ​มา​ลัก​เอา​ไป​ได้ ");
INSERT INTO nod_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","แต่​หื้อ​เก็บ​ฮอม​ทรัพย์​สมบัติ​ไว้​ใน​สวรรค์ ตี้​ขี้เหมี้ยง​กับ​แมง​จะ​มา​ขบ​กิ๋น​เยียะ​หื้อ​ทรัพย์​สมบัติ​เสียหาย กาว่า​ขโมย​เข้า​บ้าน​ลัก​เอา​ไป​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ย้อน​ว่า​ทรัพย์​สมบัติ​ของ​ต้าน​อยู่​ตี้​ไหน จิตใจ๋​ของ​ต้าน​ก็​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“แก่นต๋า​เผียบ​เหมือน​โกม​ไฟ​ส่อง​แจ้ง​ใน​ตั๋ว​ของ​คน​เฮา ถ้า​แก่นต๋า​ของ​ต้าน​ดี​ตึง​เนื้อ​ตึง​ตั๋ว​ก็​เป่งแจ้ง​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","แต่​ถ้า​แก่นต๋า​ของ​ต้าน​บ่﻿ดี​ตึง​เนื้อ​ตึง​ตั๋ว​ก็​มืด​ไป​หมด แล้ว​ถ้า​กึ๊ด​ว่า​ตั๋ว​ต้าน​เป่งแจ้ง​แต่​แต๊﻿ๆ เป๋น​ความ​มืด ความ​มืด​นั้น​จะ​มืด​นัก​เหลือ​นั้น​ขนาด​ไหน ");
INSERT INTO nod_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“บ่﻿มี​ใผ​จะ​ฮับ​ใจ๊​เจ้านาย​สอง​คน​พร้อม​กั๋น​ได้ ย้อน​ว่า​เขา​จะ​จัง​นาย​คน​นึ่ง แล้ว​ก็​ฮัก​นาย​แหม​คน​นึ่ง กาว่า​เขา​ก็​จะ​ซื่อสัตย์​กับ​นาย​คน​นึ่ง​แต่​จะ​ดู​ถูก​ดู​แควน​นาย​แหม​คน​นึ่ง เจ้น​เดียว​กั๋น​ต้าน​จะ​ฮับใจ๊​พระเจ้า​แล้ว​จะ​ฮับใจ๊​เงินคำ​พร้อม​กั๋น​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ย้อน​จาอั้น​เฮา​ขอ​บอก​ต้าน​ตังหลาย​ว่า บ่﻿ถ้า​ฮ้อนใจ๋​จี้​วี้​จ้อ​หว้อ​เกี่ยวกับ​จีวิต​ว่า จะ​เอา​อะหยัง​มา​กิ๋น เอา​อะหยัง​มา​ดื่ม กาว่า​เป๋น​ห่วง​เรื่อง​ของ​ตั๋ว​ว่า​จะ​เซาะ​หา​เสื้อผ้า​ตี้​ไหน​มา​นุ่ง ย้อน​ว่า​จีวิต​สำคัญ​นัก​เหลือ​ของ​กิ๋น กับ​ตั๋ว​ของ​คน​เฮา​ก็​สำคัญ​นัก​เหลือ​ผ้า​นุ่ง​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","แหงน​ผ่อ​นก​ตี้​บิน​อยู่​บน​ฟ้า​ลอ มัน​บ่﻿ได้​หว่าน​บ่﻿ได้​เก็บ​เกี่ยว แล้ว​ก็​บ่﻿ได้​เอา​ข้าว​สะสม​ไว้​ใน​หลองข้าว แต่​พระบิดา​ของ​ต้าน​ตี้​อยู่​ใน​สวรรค์ เลี้ยง​นก​หมู่​นั้น​ไว้ แล้ว​หมู่​ต้าน​ลอ มี​ก้า​นัก​เหลือ​นก​หมู่​นั้น​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ใน​หมู่​ต้าน มี​ใผ​พ่อง​ตี้​ฮ้อนใจ๋ แล้ว​ต่อ​จีวิต​ตั๋ว​เก่า​หื้อ​ยาว​ออก​ไป​แหม​สัก​หน้อย​นึ่ง​ได้ ");
INSERT INTO nod_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“แล้ว​เป๋น​อะหยัง​เถิง​เป๋น​ห่วง​เรื่อง​ผ้า​นุ่ง แยง​ผ่อ​ดอกไม้​ต๋ำ​โต้ง​ต๋ำ​นา​ลอ​ว่า งอก​งาม​ขึ้น​มา​ได้​จาใด มัน​บ่﻿ได้​เยียะ​ก๋าน บ่﻿ได้​ปั่น​ฝ้าย ");
INSERT INTO nod_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","แต่​เฮา​จะ​บอก​หื้อ​ต้าน​ตังหลาย​ฮู้​ว่า ขนาด​กษัตริย์​ซาโลมอน​ตี้​นับ​ว่า ร่ำรวย​นัก​ขนาด ก็​ยัง​ใส่​เสื้อผ้า​บ่﻿งาม​เต้า​ดอกไม้​หมู่​นี้​สัก​ดอก​เดียว ");
INSERT INTO nod_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ถ้า​พระเจ้า​แต่งหย้อง​ดอก​หญ้า​ต๋ำ​โต้ง​ต๋ำ​นา เซิ่ง​อยู่​ได้​วัน​นี้​วัน​เดียว ตก​แหม​วัน​ก็​จะ​ถูก​ก๋ำปือ​เข้า​ก๋องไฟ จาอั้น​แล้ว​พระองค์​ก็​จะ​แต่งหย้อง​หมู่​ต้าน​นัก​เหลือ​นั้น​แหม โอ หมู่​ต้าน​มี​ความ​เจื้อ​หน้อย​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ย้อน​จาอั้น​บ่﻿ถ้า​ฮ้อนใจ๋​ว่า ‘จะ​มี​อะหยัง​กิ๋น​พ่อง​ก่อ’ ‘จะ​มี​อะหยัง​ดื่ม​พ่อง​ก่อ’ กาว่า ‘จะ​มี​อะหยัง​มา​นุ่ง​พ่อง​ก่อ’ ");
INSERT INTO nod_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ย้อน​ว่า​คน​ตี้​บ่﻿ฮู้จัก​พระเจ้า​ก็​ปา​กั๋น​เซาะ​หา​สิ่ง​หมู่​นี้ แต่​พระบิดา​ของ​ต้าน​ตังหลาย​ตี้​อยู่​ใน​สวรรค์ ฮู้​ดี​อยู่​แล้ว​ว่า​สิ่ง​หมู่​นี้​จ๋ำเป๋น​สำหรับ​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","แต่​สิ่ง​ตี้​สำคัญ​ตี้​สุด​สำหรับ​หมู่​ต้าน ก็​คือ​หื้อ​เซาะ​หา​แผ่นดิน​ของ​พระเจ้า​ก่อน กับ​เยียะ​ตวย​ต๋าม​ความ​ต้องก๋าน​ของ​พระเจ้า แล้ว​พระองค์​จะ​เตื่อม​แถ้ง​สิ่ง​ตี้​จ๋ำเป๋น​ตึง​หมด​นี้​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ย้อน​จาอั้น​ก็​บ่﻿ต้อง​ฮ้อน​ใจ๋​เรื่อง​วัน​พูก วัน​พูก​ก็​มี​เรื่อง​ฮ้อน​ใจ๋​สำหรับ​วัน​พูก​อยู่​แล้ว วัน​ใด﻿ๆ ก็​มี​ปั๋ญหา​ปอ​สำหรับ​วัน​นั้น​อยู่​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“บ่﻿ดี​ตัดสิน​คน​อื่น แล้ว​พระเจ้า​จะ​บ่﻿ตัดสิน​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ย้อน​ว่า​ต้าน​ตังหลาย​จะ​ตัดสิน​คน​อื่น​จาใด พระเจ้า​ก็​จะ​ตัดสิน​ต้าน​ตังหลาย​จาอั้น เผียบ​เหมือน​ต้าน​ใจ๊​ต๋าง​แก่น​ใด​ตวง​หื้อ​คน​อื่น พระเจ้า​ก็​จะ​ใจ๊​ต๋าง​แก่น​นั้น​ตวง​หื้อ​ต้าน​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“เป๋น​จาใด​ต้าน​ผ่อ​หัน​ขี้ฝุ่น​ตี้​อยู่​ใน​ต๋า​ปี้น้อง​ของ​ต้าน แต่​ไม้​ตึง​ดุ้น​อยู่​ใน​ต๋า​ตั๋ว​เก่า​ผ่อ​บ่﻿หัน ");
INSERT INTO nod_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","เป๋น​จาใด​ต้าน​อู้​กับ​หมู่​ปี้น้อง​ของ​ต้าน​ว่า ‘หื้อ​เฮา​เขี่ย​ขี้ฝุ่น​ออก​จาก​ต๋า​ของ​เจ้า​เนาะ’ แต่​ตี้​ไหน​ได้​มี​ไม้​ตึง​ดุ้น​อยู่​ใน​ต๋า​ตั๋ว​เก่า ");
INSERT INTO nod_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","คน​หน้า​ซื่อ​ใจ๋​ก๊ด หื้อ​จั๊ก​ไม้​ตึง​ดุ้น​ออก​จาก​ต๋า​ตั๋ว​เก่า​เหีย​ก่อน แล้ว​จะ​ได้​ผ่อ​หัน​ถี่﻿ๆ ก่อน​ตี้​จะ​ไป​เขี่ย​ขี้ฝุ่น​ออก​จาก​ต๋า​ของ​ปี้น้อง​ได้ ");
INSERT INTO nod_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ห้าม​เอา​ของ​ศักดิ์สิทธิ์​ยื่น​หื้อ​หมา กับ​บ่﻿ดี​เอา​ไข่​มุก​โจ้ง​หื้อ​หมู ย้อน​ว่า​หมา​กับ​หมู​จะ​เอา​ตี๋น​ซอก​ย่ำ​ของ​หมู่​นั้น​หื้อ​จ๋ม​ปื๊น​ตี๋น​ของ​มัน ป๋าย​บ่﻿ปอ​จะ​งว้าย​ปิ๊ก​มา​ขบ​ตวย ");
INSERT INTO nod_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“จง​ขอ​แล้ว​จะ​ได้ จง​เซาะ​แล้ว​จะ​ปะ จง​ฮ้อง​ตี้​ปะตู๋​แล้ว​จะ​เปิด​หื้อ ");
INSERT INTO nod_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ย้อน​ว่า​กู้​คน​ตี้​ขอ​ก็​จะ​ได้ กู้​คน​ตี้​เซาะ​ก็​จะ​ปะ กู้​คน​ตี้​ฮ้อง​ตี้​ปะตู๋​ก็​จะ​เปิด​หื้อ​เขา ");
INSERT INTO nod_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“มี​ใผ​ใน​หมู่​ต้าน​ถ้า​ลูก​ขอ​ของ​กิ๋น จะ​เอา​บ่าหิน​ยื่น​หื้อ​กิ๋น​แตน​กา ");
INSERT INTO nod_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","กาว่า​ถ้า​ลูก​ของ​ต้าน​ขอ​ป๋า จะ​เอา​งู​ปิ๊ด​หื้อ​จาอั้น​กา ");
INSERT INTO nod_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ย้อน​ว่า​ต้าน​ตังหลาย​ตี้​เป๋น​คน​บาป​ยัง​ฮู้จัก​เอา​ของ​ดี﻿ๆ หื้อ​ลูก แล้ว​พระบิดา​ตี้​อยู่​ใน​สวรรค์​จะ​บ่﻿เอา​ของ​ดี﻿ๆ นัก​เหลือ​นั้น​หื้อ​กับ​คน​ตี้​ขอ​จาก​พระองค์​กา ");
INSERT INTO nod_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","หื้อ​เยียะ​ต่อ​คน​อื่น​อย่าง​ตี้​ต้าน​ต้องก๋าน​หื้อ​คน​อื่น​เยียะ​ต่อ​ต้าน นี่​เป๋น​ความหมาย​ของ​บท​บัญญัติ​ของ​โมเสส กับ​เป๋น​กำ​สอน​ของ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“หื้อ​เข้า​ไป​ตาง​ปะตู๋​กีด ย้อน​ว่า​ปะตู๋​ใหญ่​กับ​หน​ตาง​โล่ง​กว้าง​เตียว​สบาย จะ​ปา​ไป​เถิง​ความ​ฉิบหาย แล้ว​ก็​มี​คน​จ๋ำนวน​นัก​เตียว​ไป​ตัง​นี้ ");
INSERT INTO nod_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ส่วน​ปะตู๋​ตี้​กีด​กับ​หนตาง​ตี้​เตียว​ยาก จะ​ปา​ไป​เถิง​จีวิต แล้ว​ก็​มี​คน​จ๋ำนวน​หน้อย​ตี้​เซาะ​ปะ ");
INSERT INTO nod_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“หื้อ​หละวัง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตั๋ว​ป๋อม ตี้​มา​หา​ต้าน​ตังหลาย​ใน​สภาพ​เป๋น​เหมือน​แกะ แต่​ตัง​ใน​ใจ๋​นั้น​ตี้​แต๊​เป๋น​เหมือน​หมาป่า​ขี้​สวก​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ต้าน​จะ​ฮู้จัก​เขา​ได้​ดี​ก็​ผ่อ​ตี้​ก๋าน​เกิด​ผล​จาก​ก๋าน​งาน​ของ​เขา มี​ใผ​พ่อง​เก็บ​หน่วย​องุ่น​ได้​จาก​เก๊าไม้​ตี้​มี​หนาม กาว่า​เก็บ​หน่วย​บ่าเดื่อ​จาก​เก๊า​หญ้า​ตี้​มี​หนาม ");
INSERT INTO nod_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ก็​อย่าง​เดียว​กั๋น​เก๊าไม้​ตี้​ดี​ก็​จะ​ออก​หน่วย​ดี ส่วน​เก๊าไม้​ตี้​บ่﻿ดี​ก็​จะ​ออก​หน่วย​ตี้​บ่﻿ดี ");
INSERT INTO nod_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","เป๋น​ไป​บ่﻿ได้​ตี้​เก๊าไม้​ดี​จะ​ออก​หน่วย​บ่﻿ดี กาว่า​เก๊าไม้​บ่﻿ดี​จะ​ออก​หน่วย​ดี​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","เก๊าไม้​กู้​เก๊า​ตี้​ออก​หน่วย​บ่﻿ดี ก็​จะ​ถูก​ปั้ม​ขว้าง​แล้ว​เผา​ไฟ​เหีย ");
INSERT INTO nod_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ย้อน​จาอั้น​ต้าน​จะ​ฮู้​ได้​จาใด​ว่า​คน​ตี้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​นั้น เป๋น​ตั๋ว​แต๊ กาว่า​ตั๋ว​ป๋อม ก็​หื้อ​ผ่อ​ตี้​ก๋าน​เกิด​ผล​จาก​ก๋าน​งาน​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“บ่﻿ใจ้​กู้​คน​ตี้​ฮ้อง​เฮา​ว่า ‘องค์​พระผู้เป๋นเจ้า’ แล้ว​จะ​ได้​เข้า​ใน​แผ่นดิน​สวรรค์ แต่​คน​ตี้​เยียะ​ตวย​ต๋าม​ความ​ต้องก๋าน​ของ​พระบิดา​ตี้​อยู่​ใน​สวรรค์​เต้าอั้น จะ​เข้า​ไป​ใน​แผ่นดิน​นั้น​ได้ ");
INSERT INTO nod_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","เมื่อ​วัน​ตัดสิน​ลงโต้ษ​บาป​มา​แผว​นั้น ก็​จะ​มี​คน​เป๋น​จ๋ำนวน​นัก​อู้​กับ​เฮา​ว่า ‘องค์​พระผู้เป๋นเจ้า หมู่​ข้า​พระองค์​ตังหลาย​ได้​อ้าง​จื้อ​ของ​พระองค์​ต๋อน​ตี้​ก่ำลัง​เยียะ​หน้า​ตี้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์ กับ​ได้​อ้าง​จื้อ​ของ​พระองค์​ต๋อน​ไล่​ผี​ออก ตึง​ได้​ออก​จื้อ​ของ​พระองค์​ต๋อน​ตี้​เยียะ​ก๋าน​อัศจ๋รรย์​หลาย​อย่าง​บ่﻿ใจ้​กา’ ");
INSERT INTO nod_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","แต่​เฮา​จะ​บอก​หมู่​ต้าน​ซื่อ﻿ๆ ว่า ‘เฮา​บ่﻿เกย​ฮู้จัก​หมู่​เจ้า​สัก​เตื้อ เจ้า​เป๋น​คน​เยียะ​บ่﻿ดี ขะใจ๋​ปา​กั๋น​หนี​ไป​หื้อ​ป๊น​หน้า​เฮา​เหีย’ ");
INSERT INTO nod_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ย้อน​จาอั้น​กู้​คน​ตี้​ได้ยิน​กำสอน​หมู่​นี้​ของ​เฮา​แล้ว​เยียะ​ตวย ก็​เผียบ​เหมือน​คน​หลวก​แป๋ง​เฮือน​ของ​ตั๋ว เอา​ตี๋น​เสา​เฮือน​จ่อม​หล่อม​ลง​ใน​หิน​เลิ็ก เปื้อ​เอา​หิน​เป๋น​ฐาน​ของ​เฮือน​นั้น ");
INSERT INTO nod_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ต๋อน​ฝน​ตก​หนัก​น้ำ​ก็​ไหล​แฮง กับ​มี​ลมหลวง​ปั๊ด​ตั้ง​เฮือน​ซ้ำ​แล้ว​ซ้ำ​แหม แต่​เฮือน​หลัง​นั้น​ก็​บ่﻿โก้น​หลุ​แหลว​ลง​มา ย้อน​ว่า​ได้​ฝัง​ตี๋น​เสา​ของ​เฮือน​ลง​บน​ปื๊น​หิน​อย่าง​มั่นคง​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","แต่​สำหรับ​คน​ตี้​ได้​ฟัง​แล้ว​บ่﻿เยียะ​ตวย​กำ​สอน​หมู่​นี้​ของ​เฮา เขา​ก็​เผียบ​เหมือน​คน​ง่าว​แป๋ง​เฮือน​อยู่​บน​ปื๊น​ทราย ");
INSERT INTO nod_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ต๋อน​ฝน​ตก​หนัก​น้ำ​ก็​ไหล​แฮง กับ​มี​ลม​แฮง​ปั๊ด​ตั้ง​เฮือน​ซ้ำ​แล้ว​ซ้ำ​แหม แล้ว​เฮือน​นั้น​ก็​โก้น​ลง​แหลว​หมด นับ​เป๋น​ความ​ฉิบหาย​อย่าง​ใหญ่​หลวง​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","เมื่อ​พระเยซู​อู้​กำ​เผียบ​หมู่​นี้​จบ​แล้ว จาว​บ้าน​จาว​เมือง​ตังหลาย​ก็​ปา​กั๋น​งืด​ใน​กำสอน​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ย้อน​ว่า​พระองค์​สอน​อย่าง​ผู้​ตี้​มี​สิทธิ​อำนาจ​แต๊﻿ๆ บ่﻿เหมือน​หมู่​ธรรมาจ๋ารย์ ");
INSERT INTO nod_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","เมื่อ​พระเยซู​เตียว​ลง​มา​จาก​ดอย​แล้ว ก็​มี​คน​เป๋น​หมู่​ใหญ่​ติดต๋าม​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ต๋อน​นั้น​มี​คน​นึ่ง​เป๋น​ขี้ตู้ด มา​คุกเข่า​ไหว้​ต่อ​หน้า​พระองค์ อู้​ว่า “พระองค์​เจ้า​ข้า ถ้า​พระองค์​ใค่​จ้วย​ข้าพเจ้า​หื้อ​หาย ข้าพเจ้า​ก็​จะ​หาย​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","พระเยซู​ก็​ยื่น​มือ​ไป​หยุบ​ป้อจาย​คน​นั้น​แล้ว​อู้​ว่า “เฮา​ใค่​จ้วย จง​หาย​โรค​เต๊อะ” แล้ว​เขา​ก็​หาย​เป๋น​ขี้ตู้ด​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","พระเยซู​สั่ง​เขา​ว่า “ห้าม​เล่า​เรื่อง​นี้​หื้อ​ใผ​ฟัง​เน่อ แต่​หื้อ​ไป​แสดง​ตั๋ว​ต่อ​ปุโรหิต แล้ว​เอา​เครื่อง​ปู่จา​ไป​ถวาย​ต๋าม​กำสั่ง​ของ​บท​บัญญัติ​ของ​โมเสส เปื้อ​แสดง​หื้อ​คน​ตังหลาย​ฮู้​ว่า​เจ้า​หาย​โรค​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ต๋อน​ตี้​พระเยซู​เตียว​เข้า​ไป​ใน​เมือง​คาเปอรนาอุม มี​นายร้อย​ทหาร​โรมัน​คน​นึ่ง​เข้า​มา​อ้อนวอน เปื้อ​ขอ​ความ​จ้วยเหลือ​จาก​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","อู้​ว่า “ต้าน​ครับ คน​ฮับใจ๊​ของ​ข้าพเจ้า​เป๋น​ง่อย​ลุก​บ่﻿ได้ นอน​อยู่​ตี้​บ้าน​เขา ตุ๊ก​ลำบาก​นัก​ขนาด” ");
INSERT INTO nod_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","พระเยซู​บอก​นายร้อย​คน​นั้น​ว่า “เฮา​จะ​ไป​โผด​ฮักษา​เขา​หื้อ​หาย” ");
INSERT INTO nod_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","แต่​เขา​บอก​พระองค์​ว่า “ต้าน​ครับ ข้าพเจ้า​บ่﻿ดี​ปอ​ตี้​จะ​หื้อ​ต้าน​ลอด​เข้า​มา​ใน​จายคา​เฮือน​ของ​ข้าพเจ้า​เน่อ ขอ​ต้าน​สั่ง​กำเดียว​เต้าอั้น คน​ฮับใจ๊​ของ​ข้าพเจ้า​ก็​จะ​หาย​จาก​พยาธิ​ตี้​เขา​เป๋น ");
INSERT INTO nod_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ข้าพเจ้า​อยู่​ใต้​วินัย​ของ​ทหาร กับ​มี​ทหาร​อยู่​ใต้​บังคับ​ของ​ข้าพเจ้า​ตวย ข้าพเจ้า​สั่ง​คน​นึ่ง​ว่า ‘ไป’ เขา​ก็​ไป สั่ง​คน​นึ่ง​ว่า ‘มา’ เขา​ก็​มา ข้าพเจ้า​บอก​คน​ฮับใจ๊​ว่า ‘เยียะ​อัน​นี้​เน่อ’ เขา​ก็​เยียะ” ");
INSERT INTO nod_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","เมื่อ​พระเยซู​ได้ยิน​กำ​อู้​กำ​จ๋า​จาอั้น ก็​งืด​ใน​ความ​เจื้อ​ของ​นายร้อย จึง​อู้​กับ​คน​ตี้​ติดต๋าม​ว่า “เฮา​บอก​ความ​จริง​หื้อ​ต้าน​ตังหลาย​ฮู้​ว่า เฮา​บ่﻿เกย​ปะ​ใผ​คน​ใด​ใน​ประเทศ​อิสราเอล​ตี้​มี​ความ​เจื้อ​นัก​ขนาด​นี้​มา​ก่อน​เลย ");
INSERT INTO nod_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","เฮา​บอก​ต้าน​ตังหลาย​หื้อ​ฮู้​ว่า จะ​มี​คน​จ๋ำนวน​นัก​มา​จาก​ตัง​วันออก​กับ​ตัง​วันตก เปื้อ​มา​ฮ่วม​กับ​อับราฮัม อิสอัค​ตึง​ยาโคบ​กิ๋น​เลี้ยง​ฉลอง​กั๋น​ใน​แผ่นดิน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","แต่​คน​ตี้​น่า​จะ​ได้​เข้า​ไป​อยู่​ใน​แผ่นดิน​นั้น จะ​ต้อง​ถูก​ไล่​เหิบ​ออก​ไป​อยู่​ใน​ตี้​มืด ตี้​มี​เสียง​คน​ไห้​หุย​ขบ​เขี้ยว​เกี๊ยว​กาง​อย่าง​เจ็บ​ปวด” ");
INSERT INTO nod_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","แล้ว​พระเยซู​ก็​บอก​กับ​นายร้อย​คน​นั้น​ว่า “ปิ๊ก​ไป​บ้าน​ของ​ต้าน​ก่อน​เต๊อะ ส่วน​เรื่อง​ตี้​ต้าน​ต้องก๋าน​นั้น​ก็​จะ​เป๋น​ไป​ต๋าม​ตี้​ต้าน​เจื้อ” เวลา​เดียว​กั๋น​นั้น​คน​ฮับใจ๊​ก็​หาย​เป๋น​ปกติ ");
INSERT INTO nod_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","เมื่อ​พระเยซู​เข้า​ไป​ใน​เฮือน​ของ​เปโตร ก็​หัน​แม่​เมีย​ของ​เขา​บ่﻿สบาย​เป๋น​ไข้​นอน​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","พระองค์​ก็​หยุบ​มือ​ของ​นาง นาง​ก็​หาย​จาก​ไข้ แล้ว​นาง​ลุก​ขึ้น​ฮับใจ๊​ผ่อกอย​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","เมื่อแลง​วัน​นั้น​หมู่​คน​ปา​กั๋น​เอา​หลาย​คน​ตี้​โดน​ผี​เข้า​มา​หา​พระเยซู พระองค์​ก็​ใจ๊​กำ​อู้​ขับ​ไล่​ผี​หื้อ​ออก​จาก​คน​หมู่​นั้น แล้ว​ยัง​ได้​ฮักษา​คน​เจ็บป่วย​กู้​คน​หื้อ​หาย​ตวย ");
INSERT INTO nod_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","สิ่ง​ตี้​ได้​เกิด​ขึ้น​นี้​ก็​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​อู้​ไว้​ว่า “พระองค์​ได้​ฮับ​เอา​ความ​เจ็บป่วย​ของ​หมู่​เฮา​ไป​เหีย กับ​แบก​พยาธิ ของ​เฮา​ไว้” ");
INSERT INTO nod_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","เมื่อ​พระเยซู​หัน​คน​เข้า​มา​แวด​พระองค์​เป๋น​หมู่ พระองค์​จึง​สั่ง​สาวก​ปา​ข้าม​ไป​แหม​เผิก​นึ่ง​ของ​ทะเลสาบ ");
INSERT INTO nod_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ต๋อน​นั้น​มี​ธรรมาจ๋ารย์​คน​นึ่ง เข้า​มา​อู้​กับ​พระองค์​ว่า “ต้าน​อาจ๋ารย์ ต้าน​ไป​ตาง​ใด ข้าพเจ้า​ขอ​ตวย​ต้าน​ไป​ตาง​นั้น” ");
INSERT INTO nod_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","พระเยซู​บอก​เขา​ว่า “หมาไน​ยัง​มี​ฮู​อยู่ นก​ใน​อากาศ​ยัง​มี​ฮัง​นอน แต่​เฮา​ผู้​เป๋น​บุตรมนุษย์​ยัง​บ่﻿มี​ตี้​จะ​ซุก​หัว​นอน” ");
INSERT INTO nod_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","มี​สาวก​แหม​คน​นึ่ง​บอก​พระองค์​ว่า “พระองค์​เจ้า​ข้า หื้อ​ข้าพเจ้า​ปิ๊ก​ไป​ฝัง​ศพ​ป้อ​ก่อน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","พระเยซู​ตอบ​เขา​ว่า “ตวย​เฮา​มา​ก่อน ปล่อย​หื้อ​คน​ต๋าย​ฝัง​คน​ต๋าย​เอา​คน​เดียว” ");
INSERT INTO nod_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","เมื่อ​พระเยซู​ลง​เฮือ​แล้ว หมู่​สาวก​ก็​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ตันใด​นั้น​ก็​มี​ลมหลวง ตึง​ฝน​ตึง​ลม​แฮง​เกิด​ขึ้น​ใน​ทะเลสาบ คลื่น​ปั๊ด​เอา​น้ำ​เข้า​ใน​เฮือ​จ๋น​เต๋ม แต่​พระเยซู​ก็​ยัง​นอน​หลับ​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","หมู่​สาวก​เข้า​มา​ฮ้อง​พระเยซู​ตื่น บอก​ว่า “พระองค์​เจ้า​ข้า ขะใจ๋​จ้วย​กำ​เต๊อะ หมู่​เฮา​ก่ำลัง​จะ​จ๋ม​น้ำ​ต๋าย​กั๋น​หมด​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","พระเยซู​ก็​อู้​กับ​หมู่​เขา​ว่า “กั๋ว​เยียะ​หยัง มี​ความ​เจื้อ​หน้อย​แต๊﻿ๆ” แล้ว​พระองค์​ก็​ลุก​ขึ้น​มา​ห้าม​ลมหลวง​ตึง​คลื่น​ใหญ่ แล้ว​ลม​กับ​คลื่น​ก็​หยุด​เลย ");
INSERT INTO nod_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","หมู่​สาวก​ก็​ปา​กั๋น​งืด​อู้​กั๋น​ว่า “ต้าน​ผู้​นี้​เป๋น​ใผ​กั๋น ขนาด​ลม​หลวง​กับ​คลื่น​แฮง​ก็​ยัง​เจื้อ​ฟัง​ต้าน” ");
INSERT INTO nod_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","เมื่อ​ปา​กั๋น​ข้าม​ทะเลสาบ​มา​เถิง​แหม​เผิก​ใน​เขต​ของ​จาว​กาดารา ก็​มี​สอง​คน​ตี้​โดน​ผี​เข้า ออก​มา​จาก​อุโมงค์​ฝัง​ศพ เข้า​มา​หา​พระองค์ สอง​คน​นี้​สวก​ขนาด​จ๋น​บ่﻿มี​ใผ​ก้า​เตียว​ก๋าย​เข้า​ไป​ใก้​ต๋ำ​หมู่​หั้น ");
INSERT INTO nod_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ป้อจาย​สอง​คน​นั้น​เอ็ก​ปั๊ด​ใส่​พระเยซู​ว่า “ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า มา​ยุ่ง​กับ​หมู่​เฮา​เยียะ​หยัง ต้าน​ต้องก๋าน​มา​ทรมาน​หมู่​เฮา​ก่อน​เวลา​ตี้​พระเจ้า​ก๋ำหนด​ไว้​แล้ว​จาอั้น​กา” ");
INSERT INTO nod_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","จาก​ตี้​หั้น​บ่﻿ปอ​ไก๋​เต้าใด มี​หมู​หมู่​ใหญ่​ก่ำลัง​เซาะ​หา​กิ๋น​อยู่​ต๋ำ​หมู่​หั้น ");
INSERT INTO nod_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ผี​ตี้​เข้า​สอง​คน​นั้น​อ้อนวอน​พระองค์​ว่า “ถ้า​ต้าน​จะ​ไล่​หมู่​ข้า​ออก​ไป​แต๊﻿ๆ ขอ​หื้อ​หมู่​ข้า​ไป​เข้า​ใน​หมู​หมู่​นั้น​แตน​เหีย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","พระเยซู​ก็​สั่ง​ผี​หมู่​นั้น​ว่า “ออก​ไป” แล้ว​หมู่​ผี​ก็​ออก​จาก​ป้อจาย​สอง​คน​นั้น​ไป​เข้า​ใน​หมู่​หมู​แตน แล้ว​หมู​ตึงหมด​ก็​ปา​กั๋น​ล่น​ลง​หน้าผา​จิ๊ง ลง​ไป​ใน​ทะเล แก๊น​น้ำ​ต๋าย​กั๋น​หมด ");
INSERT INTO nod_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ส่วน​หมู่​คน​เลี้ยง​หมู​ปา​กั๋น​ล่น​หนี​เข้า​ไป​ใน​เมือง แล้ว​เล่า​เรื่อง​ตี้​เกิด​ขึ้น​ตึงหมด​หื้อ​คน​ตังหลาย​ฟัง ตึง​เล่า​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​กับ​ป้อจาย​สอง​คน​ตี้​โดน​ผี​เข้า​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","คน​ตึง​เมือง​นั้น​ก็​ปา​กั๋น​ออก​มา​หา​พระเยซู เมื่อ​ปะ​พระองค์​แล้ว ก็​ปา​กั๋น​อ้อนวอน​ขอ​หื้อ​พระองค์​ออก​ไป​จาก​เขตแดน​ของ​หมู่​เขา​เหีย ");
INSERT INTO nod_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","พระเยซู​ก็​ลง​เฮือ​ข้าม​ทะเล​สาบ​ปิ๊ก​ไป​เมือง​คาเปอรนาอุม​ตี้​เป๋น​ตี้​อยู่​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","มี​คน​ปา​กั๋น​หาม​คน​ง่อย​นอน​อยู่​ตี้นอน​คน​นึ่ง​มา​หา​พระเยซู เมื่อ​พระองค์​หัน​ความ​เจื้อ​ของ​หมู่​เขา ก็​อู้​กับ​คน​ง่อย​ว่า “ลูก​เหย สบาย​ใจ๋​เต๊อะ บาป​ของ​เจ้า​ได้​โผด​ยก​หื้อ​แล้ว​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","เมื่อ​หมู่​ธรรมาจ๋ารย์​บาง​คน​ได้ยิน​จาอั้น​ก็​กึ๊ด​ใน​ใจ๋​ว่า “คน​นี้​ก่ำลัง​อู้​หมิ่น​ประมาท​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","พระเยซู​ฮู้​กำกึ๊ด​ใน​ใจ๋​ของ​หมู่​เขา ก็​ถาม​ว่า “เป๋น​จาใด​หมู่​ต้าน​จึง​กึ๊ด​บ่﻿ดี​ใน​ใจ๋​จาอี้ ");
INSERT INTO nod_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","อัน​ใด​จะ​ง่าย​เหลือ​กั๋น ตี้​จะ​ว่า ‘บาป​ของ​เจ้า​ได้​โผด​ยก​แล้ว’ กาว่า ‘ลุก​ขึ้น​เตียว​ไป​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","แต่​เปื้อ​ว่า​ต้าน​ตังหลาย​จะ​ฮู้​ว่า บุตรมนุษย์​มี​สิทธิ​อำนาจ​ใน​โลก​ตี้​จะ​โผด​ยก​โต้ษ​บาป​ได้” แล้ว​พระองค์​ก็​อู้​กับ​คน​ง่อย​นั้น​ว่า “ลุก​ขึ้น​แบก​ตี้นอน​ปิ๊ก​ไป​บ้าน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","คน​ง่อย​นั้น​ก็​ลุก​ขึ้น แล้ว​เตียว​ปิ๊ก​บ้าน ");
INSERT INTO nod_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","เมื่อ​จาว​บ้าน​จาว​เมือง​หัน​จาอั้น กู้​คน​ก็​เก๋งกั๋ว แล้ว​ปา​กั๋น​สรรเสริญ​พระเจ้า ตี้​ยอม​หื้อ​คน​มี​สิทธิ​อำนาจ​เยียะ​จาอั้น​ได้​ตวย ");
INSERT INTO nod_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","เมื่อ​พระเยซู​ออก​จาก​ตี้​หั้น​มา​แล้ว ก็​หัน​ป้อจาย​คน​นึ่ง​จื้อ​มัทธิว​นั่ง​อยู่​ตี้​ด่าน​เก็บ​ภาษี พระองค์​บอก​เขา​ว่า “ตวย​เฮา​มา​เต๊อะ” มัทธิว​ก็​ลุก​ขึ้น​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ต๋อน​ตี้​พระเยซู​กับ​หมู่​สาวก​กิ๋น​ข้าว​อยู่​ใน​บ้าน​ของ​มัทธิว คน​เก็บ​ภาษี​กับ​คน​บาป​หลาย​คน​ก็​เข้า​มา​ฮ่วม​กิ๋น​ข้าว​ตวย ");
INSERT INTO nod_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","เมื่อ​หมู่​ฟาริสี​หัน​จาอั้น ก็​อู้​กับ​หมู่​สาวก​ของ​พระเยซู​ว่า “เป๋น​จาใด​อาจ๋ารย์​ของ​หมู่​ต้าน มา​นั่ง​กิ๋น​ข้าว​ฮ่วม​กับ​คน​เก็บ​ภาษี​ตึง​คน​บาป​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","เมื่อ​พระเยซู​ได้ยิน​จาอั้น ก็​ตอบ​ว่า “คน​อยู่​ดี​สบาย แข็งแฮง บ่﻿ต้องก๋าน​หมอ แต่​คน​ตี้​บ่﻿สบาย​ต้องก๋าน​หมอ ");
INSERT INTO nod_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","หื้อ​ปิ๊ก​ไป​เฮียน​พระคัมภีร์​ข้อ​นี้​หื้อ​ดี﻿ๆ ตี้​พระเจ้า​บอก​ว่า ‘เฮา​ต้องก๋าน​ความ​เมตต๋า บ่﻿ใจ้​ต้องก๋าน​สัตว์​มา​ปู่จา’ ย้อน​เฮา​บ่﻿ได้​มา​เปื้อ​ฮ้อง​หา​คน​ตี้​กึ๊ด​ว่า​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม แต่​มา​เปื้อ​ฮ้อง​หา​คน​บาป” ");
INSERT INTO nod_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ส่วน​สาวก​ของ​ยอห์น​ผู้​หื้อ​บัพติศมา มา​ถาม​พระเยซู​ว่า “หมู่​เฮา​ตึง​หมู่​ฟาริสี​ถือ​ศีล​อด​อาหาร แต่​เป๋น​จาใด​สาวก​ตังหลาย​ของ​ต้าน​บ่﻿เยียะ​พ่อง” ");
INSERT INTO nod_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","พระเยซู​ก็​ตอบ​เป๋น​กำเผียบ​ว่า “เมื่อ​เจ้าบ่าว​ยัง​อยู่ เปื้อน﻿ๆ ของ​เขา​จะ​เป๋น​ตุ๊ก​โศกเศร้า​ได้​จาใด แต่​จะ​มี​วัน​นึ่ง​ตี้​เจ้าบ่าว​จะ​ถูก​เอา​ไป​จาก​หมู่​เขา เถิง​ต๋อน​นั้น​หมู่​เขา​ก็​จะ​ปา​กั๋น​ถือ​ศีล​อด​อาหาร ");
INSERT INTO nod_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“บ่﻿มี​ใผ​เอา​ผ้า​ใหม่​ไป​ปะ​เสื้อผ้า​เก่า​เน่อ ย้อน​ว่า​ผ้า​ใหม่​ตี้​ปะ​ไป​นั้น​เมื่อ​หด​ก็​จะ​จั๊ก​เสื้อผ้า​ผืน​เก่า​ปุด​นัก​เหลือ​เก่า ");
INSERT INTO nod_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","กับ​บ่﻿มี​ใผ​เอา​เหล้า​องุ่น​หมัก​ใหม่﻿ๆ ใส่​ถง​หนัง​เก่า ย้อน​ว่า​เหล้า​องุ่น​หมัก​ใหม่​นั้น​จะ​เยียะ​หื้อ​ถง​หนัง​เก่า​แตก เหล้า​องุ่น​ก็​ฮั่ว​ออก​มา​หมด ถง​แก่น​นั้น​ก็​จะ​ใจ๊​บ่﻿ได้ แต่​เปิง​ดี​ตี้​จะ​เอา​เหล้า​องุ่น​หมัก​ใหม่​ใส่​ใน​ถง​หนัง​ใหม่ แล้ว​เหล้า​องุ่น​กับ​ถง​หนัง​ใจ๊​ได้​ตึง​สอง” ");
INSERT INTO nod_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ต๋อน​ตี้​พระเยซู​ก่ำลัง​อู้​กำ​เผียบ​อยู่​นั้น ก็​มี​นาย​ธรรมศาลา​ของ​จาว​ยิว​คน​นึ่ง เข้า​มา​คุกเข่า​ไหว้​ต่อ​หน้า​พระองค์​อู้​ว่า “ลูกสาว​ของ​ข้าพเจ้า​ต๋าย​บ่﻿ปอ​เมิน​มา​นี่ ขอ​พระองค์​โผด​ไป​วาง​มือ​บน​ตั๋ว​ของ​เขา ลูกสาว​ของ​ข้าพเจ้า​ก็​จะ​ปิ๊ก​เป๋น​ขึ้น​มา​แหม​ใหม่” ");
INSERT INTO nod_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","พระเยซู​ตึง​หมู่​สาวก​ของ​พระองค์​ก็​ตวย​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ต๋อน​นั้น​ก็​มี​แม่ญิง​คน​นึ่ง​เป๋น​โรค​เลือด​ตก​บ่﻿หยุด​มา​สิบ​สอง​ปี๋​แล้ว ตุ๊ก​ทรมาน​เหลือ​ขนาด แม่ญิง​คน​นี้​ลักมอบ​มา​ตัง​หลัง​พระเยซู แล้ว​ก็​หยุบ​ตี๋น​เสื้อ​คุม​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ย้อน​นาง​กึ๊ด​ใน​ใจ๋​ว่า “ถ้า​ได้​หยุบ​ตี๋น​เสื้อ​คุม​ของ​พระองค์​เต้าอั้น เฮา​ก็​จะ​หาย​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ส่วน​พระเยซู​งว้าย​หลัง​ปิ๊ก​มา​หัน​ใส่​ก็​อู้​กับ​นาง​ว่า “ลูก​เหย สบาย​ใจ๋​ได้​แล้ว​เน่อ ความ​เจื้อ​ของ​เจ้า​เยียะ​หื้อ​เจ้า​หาย​โรค​แล้ว” แล้ว​นาง​ก็​หาย​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","เมื่อ​พระเยซู​เตียว​มา​แผว​เฮือน​ของ​นาย​ธรรมศาลา ก็​หัน​หมู่​คน​ปา​กั๋น​เป่า​ปี่​เป่า​แน​เล่น​เพลง​งาน​ศพ กับ​คน​จ๋ำนวน​นัก​เยียะ​เสียง​ดัง​วุ่น​วะ​วุ่น​วาย ");
INSERT INTO nod_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","พระเยซู​ก็​ไล่​คน​หมู่​นั้น​ว่า “ออก​ไป​หื้อ​หมด หละอ่อน​แม่ญิง​คน​นี้​ยัง​บ่﻿ต๋าย​เตื้อ​ลอ ก่ำลัง​นอน​หลับ​อยู่​บ่﻿ดาย” คน​ตังหลาย​ก็​ใค่หัว​ใส่​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","หลัง​จาก​ไล่​คน​หมู่​นั้น​ออก​ไป​หมด​แล้ว พระเยซู​ก็​เข้า​ไป​ใน​ห้อง​แล้ว​ก๋ำ​มือ​หละอ่อน​ไว้ หละอ่อน​ก็​ลุก​ขึ้น​มา ");
INSERT INTO nod_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","เรื่อง​ตี้​เกิด​ขึ้น​นี้​ก็​เล่าลือ​อู้​กั๋น​ไป​ใคว่​แคว้น​นั้น ");
INSERT INTO nod_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","เมื่อ​พระเยซู​ออก​มา​จาก​เฮือน​ของ​นาย​ธรรมศาลา ก็​มี​คน​ต๋า​บอด​สอง​คน​ตวย​มา ฮ้อง​เอิ้น​เสียง​ดัง​ว่า “ต้าน​ผู้​เป๋น​บุตร​ของ​กษัตริย์​ดาวิด เหย ขอ​โผด​อินดู​หมู่​เฮา​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","เมื่อ​พระเยซู​เข้า​ไป​ใน​เฮือน​แล้ว คน​ต๋า​บอด​ตึง​สอง​คน​ก็​ตวย​เข้า​ไป พระองค์​ถาม​เขา​ว่า “ต้าน​ตึง​สอง​เจื้อ​ว่า​เฮา​จะ​เยียะ​หื้อ​ต๋า​ของ​ต้าน​ผ่อ​หัน​ได้​จาอั้น​กา” คน​ต๋าบอด​สอง​คน​นั้น​ตอบ​ว่า “ต้าน​ครับ เฮา​เจื้อ​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","พระเยซู​เอา​มือ​จิ​ตี้​แก่นต๋า​ของ​คน​ตึง​สอง อู้​ว่า “หื้อ​เป๋น​ไป​ต๋าม​ตี้​ต้าน​เจื้อ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","แล้ว​เขา​ตึง​สอง​คน​ก็​ผ่อ​หัน พระเยซู​เตื๋อน​เขา​ว่า “ห้าม​บอก​เรื่อง​นี้​หื้อ​ใผ​คน​ใด​ฮู้” ");
INSERT INTO nod_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","แต่​เมื่อ​เขา​ตึง​สอง​ไป​แล้ว ก็​เล่า​เรื่อง​ตี้​เกิด​ขึ้น​เกี่ยว​กับ​พระองค์​หื้อ​คน​อื่น​ใน​แคว้น​นั้น​ฮู้​จ๋น​ใคว่​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ต๋อน​ตี้​ป้อจาย​ตี้​หาย​ต๋า​บอด​สอง​คน​นั้น​ออก​ไป​จาก​ตี้​หั้น มี​คน​ปา​ป้อจาย​ตี้​โดน​ผี​เข้า​มา​หา​พระเยซู ผี​ได้​เยียะ​หื้อ​เขา​เป๋น​ใบ้ ");
INSERT INTO nod_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","เมื่อ​พระเยซู​ไล่​ผี​นั้น​ออก​ไป​แล้ว ป้อจาย​คน​นั้น​ก็​อู้​ได้ คน​ตังหลาย​ก็​งืด ปา​กั๋น​อู้​ว่า “บ่﻿เกย​ฮู้​บ่﻿เกย​หัน​เรื่อง​จาอี้​ใน​ประเทศ​อิสราเอล​มา​ก่อน​สัก​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","แต่​หมู่​ฟาริสี​อู้​ว่า “คน​นี้​ไล่​ผี​ออก​ได้​โดย​ใจ๊​อำนาจ​ของ​หัวหน้า​ผี” ");
INSERT INTO nod_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","พระเยซู​เตียว​ตาง​ไป​ใคว่​กู้​เมือง ตึง​กู้​หมู่​บ้าน แล้ว​สั่ง​สอน​ใน​ธรรมศาลา​ของ​จาว​ยิว กับ​บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า ก็​ฮักษา​พยาธิ​ตึง​ก๋าน​เจ็บป่วย​ต่าง﻿ๆ หื้อ​คน​ตังหลาย​หาย​ตวย ");
INSERT INTO nod_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","เมื่อ​พระเยซู​หัน​คน​ตังหลาย พระองค์​ก็​ฮู้สึก​อินดู​หมู่​เขา ย้อน​ว่า​หมู่​เขา​ตุ๊กใจ๋​หลาย​อย่าง กับ​บ่﻿มี​ใผ​จ้วย เผียบ​เหมือน​ฝูง​แกะ​ตี้​บ่﻿มี​คน​เลี้ยง ");
INSERT INTO nod_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","พระองค์​อู้​กับ​หมู่​สาวก​ว่า “มี​คน​นัก​ตี้​พร้อม​จะ​ฮับ​เจื้อ​เหมือน​ข้าว​เหลือง​เต๋ม​โต้ง แต่​คน​งาน​ตี้​จะ​เกี่ยว​นั้น​ยัง​มี​หน้อย​ล้ำ​ไป ");
INSERT INTO nod_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ย้อน​จาอั้น​หื้อ​จ้วย​กั๋น​อ้อนวอน​ขอ​พระเจ้า ผู้​เผียบ​เหมือน​เจ้า​ของ​นา​หื้อ​ส่ง​คนงาน​มา เปื้อ​จ้วย​กั๋น​เกี่ยว​พืช​ผล​ของ​พระองค์​ตวย” ");
INSERT INTO nod_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","พระเยซู​ฮ้อง​สาวก​สิบ​สอง​คน​มา แล้ว​หื้อ​สิทธิ​อำนาจ​หมู่​เขา​เปื้อ​จะ​ไล่​ผี​ฮ้าย กับ​ฮักษา​โรค​ตึง​ก๋าน​เจ็บ​ป่วย​กู้​อย่าง​หื้อ​หาย​ได้ ");
INSERT INTO nod_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","หมู่​อัคร​สาวก​สิบ​สอง​คน มี​จื้อ​ว่า ซีโมน ตี้​ฮ้อง​แหม​จื้อ​ว่า​เปโตร อันดรูว์ ตี้​เป๋น​น้อง​บ่าว​ของ​ซีโมน​เปโตร ยากอบ ยอห์น ตี้​เป๋น​น้องบ่าว​ยากอบ ปี้น้อง​สอง​คน​นี้​เป๋น​ลูก​เศเบดี ");
INSERT INTO nod_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ฟีลิป บารโธโลมิว โธมัส มัทธิว คน​เก็บ​ภาษี ยากอบ ลูก​ของ​อัลเฟอัส ธัดเดอัส ");
INSERT INTO nod_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ซีโมน ตี้​เป๋น​คน​ของ​พรรค​จ้าดนิยม กับ​ยูดาส​อิสคาริโอท ต๋อน​เมื่อ​ลูน​คน​นี้​ได้​หักหลัง​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","เมื่อ​พระเยซู​ส่ง​สาวก​สิบ​สอง​คน​นี้​ออก​ไป ก็​สั่ง​ว่า “ห้าม​เข้า​หา​หมู่​คน​ต่างจ้าด กาว่า​เข้า​ไป​ใน​เมือง​ของ​หมู่​จาว​สะมาเรีย ");
INSERT INTO nod_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","แต่​หื้อ​ไป​หา​คน​อิสราเอล​ตี้​เผียบ​เหมือน​แกะ​ของ​พระเจ้า​ตี้​หลง​หาย​ไป ");
INSERT INTO nod_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ต๋อน​ตี้​หมู่​ต้าน​เตียว​ไป​นั้น หื้อ​บอก​ไป​ตวย​ว่า ‘แผ่นดิน​สวรรค์​มา​ใก้​จะ​แผว​แล้ว​เน่อ’ ");
INSERT INTO nod_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","แล้ว​ฮักษา​คน​ป่วย​หื้อ​หาย เยียะ​หื้อ​คน​ต๋าย​ไป​แล้ว​ปิ๊ก​เป๋น​ขึ้น​มา​ใหม่ ฮักษา​คน​เป๋น​ขี้ตู้ด​หื้อ​หาย​สะอาด ไล่​ผี​ออก​จาก​คน​ตี้​ถูก​เข้า ต้าน​ตังหลาย​ได้​ฮับ​ฤทธิ์​อำนาจ​นี้​มา​บ่﻿ดาย ก็​หื้อ​จ้วย​เหลือ​คน​อื่น​บ่﻿ดาย ");
INSERT INTO nod_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","บ่﻿ต้อง​เอา​สตางค์​ติด​ตั๋ว​ไป​สัก​เหรียญ ");
INSERT INTO nod_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","บ่﻿ต้อง​เอา​ถง เสื้อผ้า​แหม​ผืน เกิบ กาว่า​ไม้เต๊า​ไป​ตวย ย้อน​ว่า​คน​ตี้​เยียะ​ก๋าน ก็​สมควร​จะ​ได้​ฮับ​ก๋าน​ผ่อกอย​ใน​สิ่ง​ตี้​เขา​จ๋ำ​เป๋น​ต้อง​ใจ๊ ");
INSERT INTO nod_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“เมื่อ​ต้าน​ไป​เถิง​หมู่​บ้าน​ใด​กาว่า​เมือง​ใด​ก็​ต๋าม หื้อ​เซาะ​หา​คน​ตี้​เต๋มใจ๋​ต้อนฮับ​ต้าน แล้ว​ย้าง​อยู่​กับ​เขา​คน​นั้น จ๋น​กว่า​จะ​ออก​เตียว​ตาง​ต่อ​ไป​ตี้​อื่น​แหม ");
INSERT INTO nod_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","เมื่อ​เข้า​ไป​ใน​เฮือน​ของ​เขา ก็​หื้อ​ปั๋น​ปอน​เขา ");
INSERT INTO nod_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ถ้า​คน​ใน​เฮือน​นั้น​ยินดี​ต้อนฮับ​หมู่​ต้าน ก็​หื้อ​กำปอน​นั้น​อยู่​กับ​เขา แต่​ถ้า​เขา​บ่﻿ต้อนฮับ​หมู่​ต้าน ก็​หื้อ​กำปอน​นั้น​ปิ๊ก​ย้อน​มา​หา​หมู่​ต้าน​เหีย ");
INSERT INTO nod_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ถ้า​บ้าน​ใด​เมือง​ใด​บ่﻿ยินดี​ต้อนฮับ​ต้าน บ่﻿ฟัง​กำ​อู้​ของ​ต้าน เมื่อ​ออก​จาก​บ้าน​เมือง​ของ​เขา ก็​หื้อ​ปัด​ขี้ฝุ่น​ตี้​ติด​ตี๋น​ของ​ต้าน​ออก​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","เฮา​บอก​ความ​จริง​แก่​เจ้า​ตังหลาย​ว่า ใน​วัน​ตัดสิน​ลงโต้ษ​บาป​นั้น​จาว​เมือง​โสโดม​กับ​เมือง​โกโมราห์​จะ​มี​โต้ษ​เบา​เหลือ​จาว​เมือง​นั้น​แหม ");
INSERT INTO nod_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ฟัง​หื้อ​ดี​เน่อ เฮา​ส่ง​ต้าน​ตังหลาย​ออก​ไป เผียบ​เหมือน​ส่ง​แกะ​เข้า​ไป​อยู่​ต้ามก๋าง​หมู่​หมาป่า ย้อน​จาอั้น​ต้อง​หลวก​เหมือน​งู ตึง​ซื่อใส​อ่อนน้อม​เหมือน​นกก๋าแก๋ ");
INSERT INTO nod_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","หละวัง​หื้อ​ดี ย้อน​ว่า​คน​หมู่​นั้น​จะ​ยับ​ต้าน​ตังหลาย​ปา​ไป​ขึ้น​ศาล แล้ว​เฆี่ยน​ลง​โต้ษ​ต้าน​ตี้​ก๋าง​ธรรมศาลา​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","หมู่​เขา​จะ​ปา​ตั๋ว​ต้าน​ไป​ยืน​ต่อ​หน้า​เจ้าเมือง ต่อ​หน้า​กษัตริย์ ย้อน​ว่า​หมู่​ต้าน​ติดต๋าม​เฮา ต้าน​จะ​ต้อง​เป๋น​พยาน​เรื่อง​เฮา​หื้อ​กษัตริย์​กับ​เจ้าเมือง​ตึง​คน​ต่างจ้าด​ฟัง ");
INSERT INTO nod_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","เมื่อ​ต้าน​โดน​ยับ บ่﻿ต้อง​ฮ้อนอก​ตกใจ๋​ว่า​จะ​อู้​อะหยัง กาว่า​จะ​อู้​จาใด​ดี เมื่อ​เถิง​เวลา​นั้น ต้าน​จะ​ฮู้​ว่า​จะ​อู้​อะหยัง​พ่อง ");
INSERT INTO nod_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","แต่​บ่﻿ใจ้​ตั๋ว​ต้าน​ตี้​อู้ แต่​เป๋น​พระวิญญาณ​ของ​พระบิดา​ตี้​อู้​ผ่าน​ตั๋ว​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ปี้น้อง​จะ​หักหลัง​กั๋น​จ๋น​ถูก​ฆ่า​ต๋าย ป้อ​แม่​จะ​หักหลัง​ลูก​จ๋น​ถูก​ฆ่า​ต๋าย หมู่​ลูก﻿ๆ ก็​จะ​ต่อต้าน​ป้อ​แม่ แล้ว​เยียะ​หื้อ​ถูก​ฆ่า​ต๋าย​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","คน​ตังหลาย​จะ​จัง​หมู่​ต้าน ย้อน​ว่า​หมู่​ต้าน​ได้​ติดต๋าม​เฮา แต่​ถ้า​ใผ​ตี้​ทน​ได้​จ๋น​เถิง​ตี้​สุด ก็​จะ​ได้ฮับ​ความ​รอด​ป๊น​บาป​โต้ษ ");
INSERT INTO nod_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ถ้า​เขา​ค่ำเข​ต้าน​ใน​เมือง​นี้ ก็​หื้อ​หนี​ไป​เมือง​ปู๊น เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า ก่อน​ตี้​หมู่​ต้าน​จะ​ไป​เยียะ​ก๋าน​หื้อ​แล้ว​จ๋น​ใคว่​กู้​เมือง​ของ​จาว​อิสราเอล บุตรมนุษย์​จะ​มา​แผว​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ลูกศิษย์​บ่﻿ใหญ่​เหลือ​ครู กับ​คน​ฮับใจ๊​บ่﻿ใหญ่​เหลือ​เจ้านาย ");
INSERT INTO nod_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ลูกศิษย์​ขึ้น​ไป​เปียง​ครู กาว่า​คน​ฮับใจ๊​เปียง​นาย​ของ​ต๋น ก็​นัก​แล้ว ถ้า​คน​ปา​กั๋น​ฮ้อง​เฮา​ตี้​เป๋น​เจ้า​ของ​เฮือน​ว่า เบเอลเซบูล แล้ว​เขา​จะ​ฮ้อง​จื้อ​ต้าน​ตี้​เป๋น​สมาชิก​ใน​ครอบครัว​ฮ้าย​เหลือ​นั้น​สัก​มอก​ใด ");
INSERT INTO nod_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ย้อน​จาอั้น​บ่﻿ต้อง​กั๋ว​คน​หมู่​นั้น กู้​อย่าง​ตี้​ปิดบัง​ซุก​ไว้​จะ​เปิด​หื้อ​หัน ตึง​ตี้​เป๋น​ความ​ลับ​กู้​อย่าง​จะ​ถูก​เปิดเผย​ออก​มา​หมด​หลึ้ง ");
INSERT INTO nod_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","สิ่ง​ใด​ตี้​เฮา​บอก​หื้อ​ต้าน​ตังหลาย​ใน​ตี้​มืด ก็​หื้อ​ไป​บอก​ใน​ตี้​แจ้ง สิ่ง​ใด​ตี้​เฮา​ซูบซาบ​บอก​หื้อ​ต้าน ก็​หื้อ​เอิ้น​บอก​ตี้​ดาดฟ้า​หลังคา​ตึก ");
INSERT INTO nod_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","บ่﻿ต้อง​กั๋ว​คน​ตี้​ฆ่า​ได้​ก้า​ตั๋ว แต่​บ่﻿มี​อำนาจ​ฆ่า​จิต​วิญญาณ​ของ​ต้าน​ได้ แต่​หื้อ​กั๋ว​พระเจ้า​ผู้​ตี้​มี​ฤทธิ์​อำนาจ​ทำลาย​ตึง​ตั๋ว​ตึง​จิต​วิญญาณ​ของ​ต้าน​ใน​หม้อหน้าฮก​ได้ ");
INSERT INTO nod_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","นกจอก​สอง​ตั๋ว เปิ้น​ขาย​กั๋น​บาท​เดียว​บ่﻿ใจ้​กา ถ้า​พระบิดา​บ่﻿ยอม นก​หมู่​นั้น​สัก​ตั๋ว​จะ​ตก​มา​ต๋าย​บน​ปื๊น​ดิน​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","เส้น​ผม​ของ​ต้าน​มี​กี่​เส้น​พระองค์​ก็​นับ​ไว้​หมด​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ย้อน​จาอี้​บ่﻿ต้อง​กั๋ว​เน่อ หมู่​ต้าน​มี​ก้า​นัก​เหลือ​นกจอก​หลาย​ตั๋ว​แหม​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ถ้า​คน​ใด​ยอมฮับ​เฮา​ต่อหน้า​คน​ใน​โลก​นี้ เฮา​ก็​จะ​ยอมฮับ​เขา​ต่อหน้า​พระบิดา​ของ​เฮา​ตี้​อยู่​ใน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","แต่​ถ้า​คน​ใด​ตี้​บ่﻿ยอมฮับ​เฮา​ต่อหน้า​คน​ใน​โลก​นี้ เฮา​ก็​จะ​บ่﻿ยอมฮับ​เขา​ต่อหน้า​พระบิดา​ของ​เฮา​ตี้​อยู่​ใน​สวรรค์​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“บ่﻿ดี​กึ๊ด​เอา​คน​เดียว​ว่า เฮา​มา​ใน​โลก​นี้​เปื้อ​นำ​เอา​ความ​สงบ​สุข​มา​หื้อ​เน่อ แต่​เฮา​เอา​ดาบ​มา ");
INSERT INTO nod_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","เฮา​มา​เปื้อ​เยียะ​หื้อ ‘ลูก​บ่าว​แตกแยก​กับ​ป้อ ลูก​สาว​แตกแยก​กับ​แม่ ลูกใป๊​แตกแยก​กับ​แม่​ผัว ");
INSERT INTO nod_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","คน​ใน​สมาชิก​ครอบครัว​เดียว​กั๋น​จะ​เป๋น​ศัตรู๋​กั๋น’ ");
INSERT INTO nod_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“คน​ใด​ตี้​ฮัก​ป้อ​กาว่า​ฮัก​แม่​ของ​ตั๋ว​นัก​เหลือ​เฮา ก็​บ่﻿สมควร​มา​เป๋น​สาวก​ของ​เฮา คน​ตี้​ฮัก​ลูก​บ่าว​ลูก​สาว​ของ​ตั๋ว​นัก​เหลือ​เฮา ก็​บ่﻿สมควร​ตี้​จะ​เป๋น​สาวก​ของ​เฮา​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","กับ​คน​ใด​ตี้​บ่﻿ยอม​แบก​ไม้​ก๋าง​เขน​ของ​ตั๋ว​แล้ว​ตวย​เฮา​มา ก็​บ่﻿สมควร​มา​เป๋น​สาวก​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","คน​ตี้​ใค่​ฮักษา​จีวิต​ของ​ตั๋ว​ไว้ คน​นั้น​จะ​ฮักษา​จีวิต​นั้น​บ่﻿ได้​ก็​จะ​ต๋าย แต่​คน​ยอม​สละ​จีวิต​ของ​ตั๋ว​ย้อน​หัน​แก่​เฮา​ก็​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“คน​ตี้​ต้อนฮับ​หมู่​ต้าน​ก็​ต้อนฮับ​เฮา คน​ตี้​ต้อนฮับ​เฮา​ก็​ต้อนฮับ​ผู้​ตี้​ใจ๊​เฮา​มา​ตวย ");
INSERT INTO nod_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","คน​ตี้​ต้อนฮับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ย้อน​หัน​ว่า​เขา​เป๋น​จาอั้น ก็​จะ​ได้​ฮับ​รางวัล​แบบ​เดียว​กั๋น​กับ​คน​นั้น กาว่า​คน​ตี้​ต้อนฮับ​คน​ถูกต้อง​ต๋าม​ธรรม ย้อน​ว่า​เขา​เป๋น​จาอั้น ก็​จะ​ได้​ฮับ​รางวัล​แบบ​เดียว​กั๋น​กับ​คน​นั้น ");
INSERT INTO nod_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","กาว่า​คน​ตี้​เอา​น้ำ​เย็น​สัก​แก้ว​นึ่ง​หื้อ​สาวก​ตี้​ต่ำต้อย​ตี้​สุด ย้อน​หัน​ว่า​เขา​เป๋น​สาวก​ของ​เฮา เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​นั้น​ก็​จะ​ได้​ฮับ​รางวัล​แน่นอน” ");
INSERT INTO nod_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","เมื่อ​พระเยซู​สั่ง​หมู่​สาวก​ตึง​สิบ​สอง​คน​เรียบร้อย​แล้ว พระองค์​ก็​ออก​จาก​ตี้​หั้น​ไป​เตสนา กับ​สั่ง​สอน​ต๋าม​เมือง​ต่าง﻿ๆ ใน​ต๋ำ​หมู่​แคว้น​กาลิลี ");
INSERT INTO nod_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ส่วน​ยอห์น​ผู้​หื้อ​บัพติศมา​ยัง​อยู่​ใน​คอก ได้ยิน​ข่าว​เกี่ยว​กับ​สิ่ง​ต่าง﻿ๆ ตี้​พระคริสต์​เยียะ​อยู่ ก็​เลย​หื้อ​สาวก​ของ​ตั๋ว​ไป​หา​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ถาม​ว่า “ต้าน​เป๋น​ผู้​ตี้​จะ​มา​นั้น​กา กาว่า​จะ​ต้อง​กอง​ถ้า​คน​อื่น​แหม” ");
INSERT INTO nod_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","พระเยซู​ตอบ​ว่า “ปิ๊ก​ไป​บอก​ยอห์น​ต๋าม​ตี้​หมู่​ต้าน​ได้ยิน กับ​ได้​หัน ");
INSERT INTO nod_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","คือ​คน​ต๋าบอด​ก็​ผ่อ​หัน​ได้ คน​ง่อย​ก็​เตียว​ได้ คน​ขี้ตู้ด​ก็​หาย​สะอาด คน​หู​หนวก​ก็​ได้​ยิน คน​ต๋าย​ก็​เป๋น​ขึ้น​จาก​ความ​ต๋าย กับ​คน​ตุ๊ก​คน​ยาก​ก็​ได้​ฟัง​ข่าวดี ");
INSERT INTO nod_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","คน​ตี้​บ่﻿ขัดใจ๋​ใน​สิ่ง​ตี้​เฮา​อู้​กับ​เยียะ ก็​เป๋น​สุข” ");
INSERT INTO nod_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","เมื่อ​สาวก​ของ​ยอห์น​ได้​ปิ๊ก​ไป​แล้ว พระเยซู​ตั้งเก๊า​อู้​กับ​คน​ตังหลาย​เรื่อง​ยอห์น​ว่า “ต้าน​ตังหลาย​ไป​ผ่อ​อะหยัง​ใน​ดินแดน​ทุรกั๋นดาร ไป​ผ่อ​ต้น​อ้อ​ถูก​ลม​ปั๊ด​แกว่ง​ไป​แกว่ง​มา​จาอั้น​กา ");
INSERT INTO nod_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ถ้า​บ่﻿ใจ้ ออก​ไป​ผ่อ​อะหยัง​กั๋น ไป​ผ่อ​คน​แต่งตั๋ว​งาม﻿ๆ กา ย้อน​ว่า​คน​ตี้​แต่งตั๋ว​อย่าง​ดี​นั้น​ย่อม​ปา​กั๋น​อยู่​ใน​วัง​ปู๊น ");
INSERT INTO nod_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ถ้า​จาอั้น​หมู่​ต้าน​ออก​ไป​ผ่อ​อะหยัง​กั๋น ไป​ผ่อ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​แม่น​ก่อ แม่น​แล้ว เฮา​บอก​ต้าน​ตังหลาย​ว่า​ยอห์น​เป๋น​นัก​เหลือ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​แหม​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","คือ​ยอห์น​คน​เนียะ มี​กำเขียน​เถิง​ต้าน​ไว้​ว่า ‘เฮา​จะ​ส่ง​คน​ส่ง​ข่าว​นำ​หน้า​ต้าน​ไป​ก่อน เขา​จะ​เกียม​คน​หื้อ​พร้อม​ก่อน​ต้าน​มา’ ");
INSERT INTO nod_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า บ่﻿มี​ใผ​ตี้​ยิ่งใหญ่​เหลือ​ยอห์น​ผู้​หื้อ​บัพติศมา แต่​คน​ตี้​เล็ก​หน้อย​ตี้​สุด​ใน​แผ่นดิน​สวรรค์​นั้น ก็​ยัง​ใหญ่​เหลือ​ยอห์น​แหม​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","นับ​ตั้งแต่​สมัย​ยอห์น​ผู้​หื้อ​บัพติศมา​เริ่ม​เตสนา​มา​จ๋น​แผว​บ่าเดี่ยว​นี้ แผ่นดิน​สวรรค์​ก็​โดน​โจ๋มตี๋​อย่าง​หนัก กับ​หมู่​หัว​รุนแรง​ก็​ฮิ​เอา​แผ่นดิน​สวรรค์​หื้อ​ได้ ");
INSERT INTO nod_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ตี้​อู้​จาอั้น​ย้อน​ว่า​ก่อน​สมัย​ยอห์น ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตึงหมด กับ​บท​บัญญัติ​ของ​โมเสส​เกย​บอก​ไว้​เถิง​เรื่อง​แผ่นดิน​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ถ้า​ต้าน​ตังหลาย​เจื้อ​กำ​ของ​หมู่​เขา แล้ว​ตี้​อู้​ว่า​เอลียาห์​จะ​มา ก็​หมายเถิง​ยอห์น​คน​เนียะ ");
INSERT INTO nod_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“เฮา​จะ​เผียบ​คน​ใน​ยุค​สมัย​นี้​เหมือน​กับ​อะหยัง​ดี หมู่​เขา​ก็​เผียบ​เหมือน​กับ​หละอ่อน​นั่ง​เล่น​อยู่​ก๋าง​กาด​ก๋าง​ลี เอิ้น​ฮ้อง​ใส่​กั๋น​ว่า ");
INSERT INTO nod_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘หมู่​เปิ้น​เป่า​ปี่​เป่า​แน​หื้อ​ฟัง​แล้ว หมู่​ตั๋ว​ก็​บ่﻿เต้น​บ่﻿ฟ้อน​ตวย หมู่​เปิ้น​ปา​กั๋น​ฮ้อง​เพลง​สำหรับ​งาน​ศพ​หื้อ​ฟัง หมู่​ตั๋ว​ก็​บ่﻿แป๋ง​หน้า​หมอง​ต๋อง​เศร้า​ตวย’ ");
INSERT INTO nod_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","เมื่อ​ยอห์น​มา เขา​ก็​ถือ​ศีล​อด​อาหาร​บ่﻿กิ๋น​เหล้า​องุ่น หมู่​คน​ก็​ว่า ‘คน​นี้​มี​ผี​เข้า’ ");
INSERT INTO nod_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ส่วน​บุตรมนุษย์​ได้​ตึง​กิ๋น​ตึง​ดื่ม คน​ตังหลาย​ก็​ว่า ‘ผ่อ​คน​นี้​ลอ ขี้​กละ ขี้​เมา​ตวย ป๋าย​บ่﻿ปอ​ยัง​เป๋น​เปื้อน​กับ​คน​เก็บ​ภาษี คบ​กั๋น​กับ​คน​บาป’ แต่​ปั๋ญญา​ของ​พระเจ้า​นั้น​ก็​ได้ฮับ​ก๋าน​ยอมฮับ​ว่า​ถูกต้อง​แล้ว​จาก​ผล​ตี้​ออก​มา” ");
INSERT INTO nod_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","แล้ว​พระเยซู​ก็​ตั้งเก๊า​ต๋ำหนิ​ว่า​หื้อ​เมือง​ต่าง﻿ๆ ตี้​พระองค์​ได้​เยียะ​ก๋าน​อัศจ๋รรย์​ไว้​นัก​เหลือ​เปิ้น ย้อน​ว่า​หมู่​เขา​บ่﻿ยอม​กลับใจ๋​จาก​บาป ");
INSERT INTO nod_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​เมือง​โคราซิน​กับ​เมือง​เบธไซดา ถ้า​เฮา​ไป​เยียะ​ก๋าน​อัศจ๋รรย์​แบบ​เดียว​กั๋น​นี้​ตี้​เมือง​ไทระ​กับ​เมือง​ไซดอน คน​ตังหลาย​ตี้​หั้น​ก็​จะ​กลับใจ๋​จาก​บาป ปา​กั๋น​นุ่ง​ผ้า​กระสอบ​กับ​เอา​ขี้เต้า​ผุก​ใส่​หัว​ตั๋ว​เก่า​ไป​เมิน​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","เฮา​บอก​หื้อ​เจ้า​ฮู้​ว่า ใน​วัน​ตัดสิน​ลงโต้ษ​บาป​นั้น เมือง​ไทระ​กับ​เมือง​ไซดอน​จะ​มี​โต้ษ​เบา​เหลือ​หมู่​เจ้า​แหม ");
INSERT INTO nod_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ส่วน​เมือง​คาเปอรนาอุม เจ้า​กึ๊ด​ว่า​เจ้า​จะ​ถูก​ยก​ขึ้น​เปียง​ฟ้า​สวรรค์​กา​บ่﻿ใจ้​เน่อ แต่​เจ้า​จะ​ถูก​โจ้ง​ลง​ไป​ใน​แดน​คน​ต๋าย​เน่อ ย้อน​ว่า​ก๋าน​อัศจ๋รรย์​ตี้​เฮา​ได้​เยียะ​หื้อ​เจ้า​หัน​นี้ ถ้า​เอา​ไป​เยียะ​ตี้​เมือง​โสโดม​เมือง​นั้น ก็​จะ​ยัง​มี​อยู่​จ๋น​เถิง​ตึง​วัน​นี้ ");
INSERT INTO nod_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","เฮา​บอก​หื้อ​ฮู้​ว่า​ใน​วัน​ตัดสิน​ลงโต้ษ​บาป​นั้น โต้ษ​ตี้​เมือง​โสโดม​จะ​ฮับ​นั้น ยัง​จะ​เบา​เหลือ​โต้ษ​ของ​เจ้า​แหม” ");
INSERT INTO nod_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","แล้ว​พระเยซู​ก็​อู้​ว่า “ข้า​แต่​พระบิดา ผู้​เป๋น​เจ้า​ของ​ฟ้า​สวรรค์​กับ​แผ่นดิน​โลก ข้า​พระองค์​ขอ​สรรเสริญ​พระองค์ ย้อน​ว่า​พระองค์​ได้​ปิดบัง​เรื่อง​ต่าง﻿ๆ หมู่​นี้ บ่﻿หื้อ​ผู้​มี​ผญา​ปั๋ญญา ผู้​มี​ก๋าน​ศึกษา​ได้​ฮู้ แต่​ได้​เปิด​เผย​หื้อ​กับ​หมู่​คน​ตี้​ถ่อมใจ๋​เป๋น​เหมือน​หละอ่อน​หน้อย﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ข้า​แต่​พระบิดา​เจ้า แม่น​แล้ว พระองค์​ปอใจ๋​ตี้​จะ​เยียะ​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","แล้ว​พระองค์​ก็​อู้​กับ​คน​ตังหลาย​ว่า “พระบิดา​ได้​มอบ​สิทธิ​อำนาจ​เหนือ​กู้​สิ่ง​กู้​อย่าง​หื้อ​เฮา บ่﻿มี​ใผ​ฮู้จัก​พระบุตร​นอก​จาก​พระบิดา บ่﻿มี​ใผ​ฮู้จัก​พระบิดา​นอก​จาก​พระบุตร กับ​คน​ตี้​พระบุตร​ต้องก๋าน​เปิดเผย​หื้อ​ฮู้จัก​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ส่วน​คน​ตังหลาย​ตี้​ฮู้สึก​อิด​อก​อ่อนใจ๋ กับ​มี​ภาระ​หนัก หื้อ​มา​หา​เฮา​เต๊อะ แล้ว​เฮา​จะ​หื้อ​ต้าน​ตังหลาย​หาย​อิด​หาย​อ่อน​กับ​ได้​พักผ่อน​หย่อนใจ๋ ");
INSERT INTO nod_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ฮับ​เฮา​เป๋น​ผู้นำ​จีวิต แล้ว​เฮียน​ฮู้​จาก​เฮา ย้อน​ว่า​ใจ๋​เฮา​อ่อนน้อม​ถ่อม​ต๋น แล้ว​ต้าน​ตังหลาย​จะ​ได้​พักผ่อน ");
INSERT INTO nod_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ย้อน​เฮา​จะ​นำ​จีวิต​ของ​ต้าน​หื้อ​ตวย​ได้​ง่าย กับ​ภาระ​ของ​เฮา​ก็​มอก​เหมาะ” ");
INSERT INTO nod_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","มี​เตื้อ​นึ่ง​พระเยซู​เตียว​ลัด​ก๋าง​โต้ง วัน​นั้น​เป๋น​วัน​สะบาโต หมู่​สาวก​ของ​พระองค์​ใค่​อยาก​กิ๋น​ข้าว ก็​ปา​กั๋น​เด็ด​งวงข้าว​มา​เก็ด​กิ๋น​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","เมื่อ​หมู่​ฟาริสี​หัน​เข้า​ใส่ ก็​ถาม​พระเยซู​ว่า “ผ่อ​หั้น​ลอ หมู่​สาวก​ของ​ต้าน​เยียะ​ใน​สิ่ง​ตี้​ห้าม​เยียะ​ใน​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","พระเยซู​ตอบ​ว่า “หมู่​ต้าน​บ่﻿เกย​อ่าน​พระคัมภีร์​เรื่อง​ตี้​กษัตริย์​ดาวิด​เยียะ ต๋อน​ตี้​ต้าน​กับ​หมู่​คน​ตี้​มา​ตวย​ใค่​อยาก​กิ๋น​ข้าว​กา ");
INSERT INTO nod_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ต้าน​เข้า​ไป​ใน​พระวิหาร​ของ​พระเจ้า แล้ว​กิ๋น​เข้าหนมปัง​ตี้​ตั้ง​ถวาย​พระเจ้า เซิ่ง​ต๋าม​กฎ ห้าม​ต้าน​กับ​หมู่​ของ​ต้าน​กิ๋น​นอก​จาก​ปุโรหิต​เต้าอั้น​ตี้​กิ๋น​ได้ ");
INSERT INTO nod_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","หมู่​ต้าน​ยัง​บ่﻿เกย​อ่าน​บท​บัญญัติ​ของ​โมเสส​กา ตี้​ว่า​หมู่​ปุโรหิต​ตี้​เยียะ​ก๋าน​อยู่​ใน​พระวิหาร​ก็​เยียะ​ก๋าน​ใน​วัน​สะบาโต​เหมือน​กั๋น แต่​หมู่​เขา​ก็​บ่﻿มี​ความ​ผิด ");
INSERT INTO nod_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","แล้ว​เฮา​บอก​หื้อ​ฮู้​ว่า มี​คน​นึ่ง​ตี้​อยู่​ตี้​นี่​ยิ่งใหญ่​เหลือ​พระวิหาร​แหม ");
INSERT INTO nod_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ถ้า​หมู่​ต้าน​เข้าใจ๋​ความหมาย​ของ​ข้อ​พระคัมภีร์​ตี้​ว่า ‘เฮา​ต้องก๋าน​ความ​เมตต๋า บ่﻿ใจ้​ต้องก๋าน​สัตว์​มา​ปู่จา’ ต้าน​คง​จะ​บ่﻿ตัดสิน​ลงโต้ษ​คน​หมู่​นี้​ตี้​บ่﻿มี​ความ​ผิด​แน่﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ย้อน​ว่า​บุตรมนุษย์​เป๋น​เจ้า​เป๋น​นาย​เหนือ​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","พระเยซู​ออก​มา​จาก​ตี้​หั้น แล้ว​เข้า​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","มี​ป้อจาย​คน​นึ่ง​อยู่​ตี้​หั้น​มือ​เผิก​นึ่ง​ของ​เขา​ลีบ จาว​ยิว​บาง​คน​ได้​ถาม​ว่า “ห้าม​ฮักษา​คน​เป๋น​พยาธิ​ใน​วัน​สะบาโต​ก่อ” ตี้​เขา​ถาม​เปื้อ​จะ​หา​เหตุ​นาบ​โต้ษ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","พระเยซู​ก็​ตอบ​หมู่​เขา​ว่า “ถ้า​คน​ใด​ใน​หมู่​ต้าน​มี​แกะ​อยู่​ตั๋ว​เดียว แล้ว​แกะ​ตั๋ว​นั้น​ตกลง​ไป​ใน​น้ำบ่อ​ใน​วัน​สะบาโต เขา​คน​นั้น​จะ​บ่﻿จ้วย​จั๊ก​แกะ​ขึ้น​มา​จาก​บ่อ​กา ");
INSERT INTO nod_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","คน﻿ๆ เดียว​ก็​มี​ก้า​นัก​เหลือ​แกะ​ตั๋ว​นึ่ง​หลาย​เต้า ย้อน​จาอั้น​ควร​จะ​เยียะ​ก๋าน​ดี​ใน​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","แล้ว​พระเยซู​สั่ง​คน​มือ​ลีบ​นั้น​ว่า “เหยียด​มือ​ของ​เจ้า​ออก​มา” เขา​ก็​เยียะ​ตวย​ต๋าม แล้ว​มือ​ของ​เขา​ก็​หาย​ดี​เหมือน​แหม​เผิก​นึ่ง ");
INSERT INTO nod_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","แล้ว​หมู่​ฟาริสี​ก็​เลย​ปา​กั๋น​ออก​ไป​วางแผน​ว่า​จะ​ฆ่า​พระเยซู​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","แต่​พระเยซู​ฮู้​ตั๋ว​เหีย​ก่อน​ว่า​หมู่​เขา​วางแผน​จะ​เยียะ​อะหยัง ก็​เลย​ออก​ไป​จาก​ตี้​หั้น มี​คน​เป๋น​จ๋ำนวน​นัก​ตวย​พระองค์​ไป พระองค์​ก็​ได้​ฮักษา​คน​ป่วย​หื้อ​หาย​กู้​คน ");
INSERT INTO nod_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","พระเยซู​สั่ง​ห้าม​คน​หมู่​นั้น บ่﻿หื้อ​บอก​คน​อื่น​ว่า พระองค์​เป๋น​ใผ ");
INSERT INTO nod_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​กำ​ตี้​อิสยาห์ ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​อู้​ไว้​แล้ว​ว่า ");
INSERT INTO nod_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“คน​ฮับใจ๊​คน​นี้​คือ​คน​ตี้​เฮา​ได้​เลือก​ไว้​แล้ว ตี้​เฮา​ฮัก​กับ​เปิงใจ๋​ขนาด เฮา​จะ​หื้อ​อำนาจ​กับ​ต้าน​โดย​พระวิญญาณ​ของ​เฮา ต้าน​จะ​บอก​เรื่อง​ความ​ยุติธรรม​แก่​คน​กู้​จ้าด ");
INSERT INTO nod_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ต้าน​จะ​บ่﻿ผิด​หัว​ใผ กาว่า​ขึ้น​เสียง​ดัง บ่﻿มี​ใผ​จะ​ได้​ยิน​เสียง​ของ​ต้าน​ตี้​ก๋าง​กอง ");
INSERT INTO nod_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ต้าน​จะ​บ่﻿หัก​ไม้​อ้อ​ตี้​จ๊ำ​แล้ว​ขว้าง กับ​ต้าน​จะ​บ่﻿ดับ​ไส้​โกมไฟ​ตี้​เป๋น​ควัน​ใก้​จะ​ดับ ต้าน​จะ​เยียะ​จาอี้​จ๋น​กว่า​ต้าน จะ​เยียะ​หื้อ​ความ​ยุติธรรม​ได้ฮับ​ชัย ");
INSERT INTO nod_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ต้าน​จะ​เป๋น​ความ​หวัง​ของ​คน​กู้﻿ๆ จ้าด” ");
INSERT INTO nod_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","มี​ป้อจาย​คน​นึ่ง​โดน​ผี​เข้า เยียะ​หื้อ​เขา​ต๋า​บอด​กับ​เป๋น​ใบ้ บาง​คน​ปา​เขา​มา​หา​พระเยซู พระองค์​ก็​ได้​ฮักษา​เขา​หื้อ​หาย​จ๋น​ผ่อ​หัน​กับ​อู้​ได้​เหมือน​เก่า ");
INSERT INTO nod_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","คน​ตึงหมด​ปา​กั๋น​งืด ถาม​กั๋น​ว่า “คน​นี้​เป๋น​บุตร​ของ​กษัตริย์​ดาวิด”​ได้​กา ");
INSERT INTO nod_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","เมื่อ​หมู่​ฟาริสี​ได้ยิน​จาอั้น ก็​อู้​ว่า “ตี้​คน​นี้​ไล่​ผี​ออก​ได้ ก็​ย้อน​ว่า​ใจ๊​อำนาจ​ของ​เบเอลเซบูล หัวหน้า​ผี” ");
INSERT INTO nod_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","พระเยซู​ฮู้​กำกึ๊ด​ของ​หมู่​เขา ก็​ตอบ​ว่า “อาณาจักร​ตี้​แตกแยก​กั๋น​จะ​ฉิบหาย เมือง​ใด​กาว่า​ครอบครัว​ใด​แตกแยก​กั๋น​ก็​จะ​ตั้ง​อยู่​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","เหมือน​เดียว​กั๋น​ถ้า​ซาต๋าน​ขับ​ไล่​หมู่​ของ​มัน​เอง ก็​เหมือน​ต่อ​สู้​ตั๋วเก่า แล้ว​อาณาจักร​ของ​มัน​จะ​ตั้ง​อยู่​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","กับ​ถ้า​เฮา​ไล่​ผี​ออก​โดย​ใจ๊​อำนาจ​ของ​เบเอลเซบูล หมู่​ของ​ต้าน​ไล่​ผี​ออก​โดย​ใจ๊​อำนาจ​ของ​ใผ จาอั้น​หมู่​ของ​ต้าน​นั้น​ละ จะ​เป๋น​ผู้​ตัดสิน​เรื่อง​นี้​ได้ ");
INSERT INTO nod_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","แต่​ถ้า​เฮา​ไล่​ผี​ออก​โดย​พระวิญญาณ​ของ​พระเจ้า แสดง​ว่า​แผ่นดิน​ของ​พระองค์​ก็​มา​เถิง​หมู่​ต้าน​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“กาว่า​ถ้า​ใผ​สามารถ​เข้า​ไป​ปล้น​เอา​ทรัพย์​สมบัติ​ใน​บ้าน​ของ​คน​ตี้​มี​ก๋ำลัง​นัก เขา​ก็​ต้อง​มัด​เจ้าของ​บ้าน​ตี้​แข็งแฮง​นั้น​เหีย​ก่อน เถิง​จะ​สามารถ​ปล้น​ได้ ");
INSERT INTO nod_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ถ้า​ใผ​บ่﻿ได้​อยู่​ฝ่าย​เดียว​กับ​เฮา​ก็​เป๋น​ศัตรู๋​ต่อ​เฮา ใผ​บ่﻿ได้​จ้วย​ฮ้อง​คน​เข้า​มา​เปาะ​มา​ต้อม​กับ​เฮา ก็​เป๋น​คน​เยียะ​หื้อ​คน​แตก​ขะแล​ขะแจ​ไป ");
INSERT INTO nod_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ย้อน​จาอั้น​เฮา​ขอ​บอก​หื้อ​หมู่​ต้าน​ว่า ความ​บาป​กับ​กำ​หมิ่น​ประมาท​พระเจ้า​จะ​ยก​โต้ษ​หื้อ​ได้​กู้​อย่าง แต่​พระเจ้า​จะ​บ่﻿ยกโต้ษ​หื้อ​คน​ใด​ตี้​อู้​หมิ่น​ประมาท​พระวิญญาณ​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","พระเจ้า​ยัง​จะ​ยกโต้ษ​หื้อ​กับ​คน​ตี้​ด่า​บุตรมนุษย์​ได้ แต่​จะ​ยกโต้ษ​หื้อ​คน​ตี้​ด่า​พระวิญญาณ​บริสุทธิ์​ตึง​บ่﻿ได้ บ่﻿ว่า​บ่าเดี่ยว​นี้​กาว่า​ตลอด​ผด​ไป​แผว​ยุค​หน้า” ");
INSERT INTO nod_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","พระเยซู​อู้​แหม​ว่า “ถ้า​เก๊าไม้​ดี​หน่วย​ก็​จะ​ออก​มา​ดี ถ้า​เก๊าไม้​บ่﻿ดี​หน่วย​ออก​มา​ตึง​บ่﻿ดี เฮา​จะ​ฮู้​ว่า​เก๊า​นั้น​เป๋น​จาใด​ก็​หื้อ​ผ่อ​ตี้​หน่วย​ของ​มัน ");
INSERT INTO nod_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","หมู่​เจ้า​เป๋น​คน​ตี้​เผียบ​เหมือน​งู​ปิ๊ด แล้ว​คน​บ่﻿ดี​นัก​อย่าง​เจ้า​จะ​อู้​สิ่ง​ดี​ได้​จาใด ย้อน​ใน​ใจ๋​เป๋น​จาใด​ปาก​ก็​อู้​มา​จาอั้น ");
INSERT INTO nod_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","คน​ดี​ก็​มี​สิ่ง​ดี﻿ๆ ใน​ใจ๋ แล้ว​ก็​จะ​อู้​สิ่ง​ดี​ออก​มา แต่​คน​บ่﻿ดี​ก็​มี​สิ่ง​บ่﻿ดี​ใน​ใจ๋ แล้ว​ก็​จะ​อู้​สิ่ง​บ่﻿ดี​ออก​มา​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","เฮา​จะ​บอก​ต้าน​ตังหลาย​ว่า ใน​วัน​ตัดสิน​ลงโต้ษ​บาป​นั้น​ต้าน​ตังหลาย​จะ​ต้อง​ฮับผิดชอบ​ใน​กำ​อู้​ตี้​บ่﻿มี​สาระ ");
INSERT INTO nod_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","กำ​อู้​ของ​หมู่​ต้าน​จะ​จี๊​หื้อ​หัน​ว่า​ต้าน​จะ​ป๊น​โต้ษ กาว่า​จะ​ถูก​ตัดสิน​ลงโต้ษ” ");
INSERT INTO nod_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","เวลา​นั้น​มี​หมู่​ฟาริสี​กับ​ธรรมาจ๋ารย์​บาง​คน​บอก​พระเยซู​ว่า “อาจ๋ารย์ ขอ​ต้าน​เยียะ​หมายสำคัญ​หื้อ​หมู่​เฮา​หัน​กำ​ลอ ว่า​ต้าน​มา​จาก​พระเจ้า​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","พระเยซู​ก็​ตอบ​ว่า “มี​ก้า​หมู่​คน​บ่﻿ดี​กับ​คน​บ่﻿ซื่อสัตย์​ต่อ​พระเจ้า​ตี้​ฮ้อง​ขอ​หื้อ​เยียะ​หมายสำคัญ​หื้อ​ผ่อ แต่​พระเจ้า​จะ​บ่﻿เยียะ​หื้อ​หัน​เน่อ นอก​จาก​หมายสำคัญ​ตี้​เกิด​ขึ้น​กับ​โยนาห์ ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","คือ​โยนาห์​อยู่​ใน​ต๊อง​ป๋า​ตั๋ว​ใหญ่​เถิง​สาม​วัน​สาม​คืน​จาใด บุตรมนุษย์​ก็​จะ​อยู่​ใต้​ผืน​แผ่นดิน​โลก​เป๋น​เวลา​สาม​วัน​สาม​คืน​จาอั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","จาว​เมือง​นีนะเวห์​จะ​ยืน​ขึ้น​นาบโต้ษ​คน​สมัย​นี้ ใน​วัน​ตี้​พระเจ้า​ตัดสิน​โลก ย้อน​ว่า​เขา​ตังหลาย​ได้​กลับใจ๋​จาก​บาป​เมื่อ​โยนาห์​ไป​สั่ง​สอน​หมู่​เขา แต่​ต๋อน​นี้​คน​ตี้​เป๋น​ใหญ่​เหลือ​โยนาห์​อยู่​ส่อง​หน้า​หมู่​ต้าน แต่​ยัง​บ่﻿มี​ใผ​กลับใจ๋​จาก​บาป​สัก​คน ");
INSERT INTO nod_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","แล้ว​ใน​วัน​นั้น พระราชินี​ของ​ตัง​ใต้​ก็​จะ​ยืน​ขึ้น​นาบโต้ษ​คน​ใน​สมัย​นี้ ย้อน​ว่า​พระนาง​ได้​มา​จาก​ตี้​สุด​ป๋าย​แผ่นดิน​โลก เปื้อ​จะ​มา​ฟัง​สติ​ปั๋ญญา​ของ​กษัตริย์​ซาโลมอน แต่​บ่าเดี่ยว​นี้​คน​ตี้​เป๋น​ใหญ่​เหลือ​กษัตริย์​ซาโลมอน​อยู่​ตี้​นี่​แล้ว หมู่​ต้าน​ก็​บ่﻿ยอม​ฟัง ");
INSERT INTO nod_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ผี​ฮ้าย​ตั๋ว​นึ่ง เมื่อ​ออก​จาก​ตั๋ว​ของ​คน​ไป​แล้ว ก็​ฮ่อน​ไป​ต๋าม​ตี้​กั๋นดาร​แห้งแล้ง​เปื้อ​เซาะ​หา​ตี้​อยู่​ใหม่ แต่​ก็​เซาะ​หา​บ่﻿ปะ ");
INSERT INTO nod_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ผี​ฮ้าย​ตั๋ว​นั้น​เลย​อู้​ขึ้น​ว่า ‘ข้า​จะ​ปิ๊ก​ไป​เฮือน​หลัง​เก่า​ตี้​ได้​ออก​มา​แล้ว​ดี​กว่า’ เมื่อ​ผี​ฮ้าย​ปิ๊ก​มา​แล้ว ก็​หัน​ว่า​เฮือน​หลัง​เก่า​นั้น​ยัง​ว่าง บ่﻿มี​ใผ​อยู่​เตื้อ กับ​เผี้ยว​สะอาด​เรียบร้อย​ดี ");
INSERT INTO nod_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ผี​ฮ้าย​ตั๋ว​นั้น​ก็​ไป​จวน​ผี​ตั๋ว​อื่น﻿ๆ แหม​เจ็ด​ตั๋ว​ตี้​ฮ้าย​เหลือ​มัน​แหม แล้ว​ปา​กั๋น​เข้า​มา​อยู่​ใน​เฮือน​หลัง​นั้น สุดต๊าย​แล้ว​คน﻿ๆ นั้น​ก็​ซ้ำ​ฮ้าย​เหลือ​เก่า​แหม คน​บ่﻿ดี​ใน​สมัย​นี้​ก็​จะ​มี​สภาพ​เหมือน​จาอั้น​ตวย” ");
INSERT INTO nod_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ต๋อน​ตี้​พระเยซู​ก่ำลัง​อู้​กับ​หมู่​คน​ตังหลาย แม่​กับ​หมู่​น้อง​บ่าว​ของ​พระองค์​ก็​มา​ยืน​ถ้า​อยู่​ตัง​นอก แน​จะ​อู้​กับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","มี​คน​มา​บอก​พระเยซู​ว่า “แม่​กับ​หมู่​น้อง​บ่าว​ของ​อาจ๋ารย์​มา​ยืน​ถ้า​อยู่​ตังนอก หมู่​เขา​บอก​ว่า​ใค่​อู้​ตวย​ต้าน” ");
INSERT INTO nod_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","พระเยซู​บอก​ว่า “ใผ​เป๋น​แม่​กับ​ปี้น้อง​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","แล้ว​พระเยซู​ก็​จี๊​ไป​ตี้​หมู่​สาวก​ของ​พระองค์​อู้​ว่า “หมู่​เนียะ​เป๋น​แม่​กับ​ปี้น้อง​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ย้อนว่า​คน​ตี้​เยียะ​ตวย​ต๋าม​ความ​ต้องก๋าน​ของ​พระบิดา​ของ​เฮา​ตี้​อยู่​ใน​สวรรค์ คน​นั้น​ก็​เป๋น​ปี้น้อง​กับ​เป๋น​แม่​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ใน​วัน​เดียว​กั๋น​นั้น พระเยซู​ออก​จาก​เฮือน​มา​นั่ง​อยู่​ฮิม​ทะเลสาบ ");
INSERT INTO nod_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","มี​คน​จ๋ำนวน​นัก​ปา​กั๋น​มา​หลุ้ม​พระองค์ พระเยซู​ก็​ลง​ไป​นั่ง​อยู่​ใน​เฮือ คน​ตังหลาย​ก็​ยืน​อยู่​ฮิม​ฝั่ง ");
INSERT INTO nod_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","แล้ว​พระองค์​ก็​เล่า​เรื่อง​ต่าง﻿ๆ เป๋น​กำเผียบ​สอน​หมู่​เขา พระองค์​เล่า​ว่า “มี​จาวนา​คน​นึ่ง ออก​ไป​หว่าน​เม็ด​พืช ");
INSERT INTO nod_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ต๋อน​ตี้​หว่าน​อยู่​นั้น บาง​เม็ด​ตก​ต๋าม​หน​ตาง​เตียว นก​ก็​มา​จิก​กิ๋น​เหีย​หมด ");
INSERT INTO nod_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","บาง​เม็ด​ก็​ตก​ลง​ดิน​ตี้​ปื๊น​ตัง​ลุ่ม​เป๋น​บ่าหิน​เต๋ม​ไป​หมด มี​ดิน​บาง​แตะแหยะ​อยู่​ตัง​บน ก็​เยียะ​หื้อ​เม็ด​พืช​นั้น​งอก​ขึ้น​เวย ");
INSERT INTO nod_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","แต่​เมื่อ​โดน​แดด​เผา​นัก​ขึ้น​ติก﻿ๆ ก็​เหี่ยว​แห้ง​ต๋าย ย้อน​ว่า​ฮาก​อยู่​ตื้น​ล้ำ​ไป ");
INSERT INTO nod_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","บาง​เม็ด​ตก​ก๋าง​ป่า​หนาม ต้น​หนาม​นั้น​ก็​ใหญ่​ขึ้น​มา​งำ​ต้น​นั้น​เหีย​หมด ");
INSERT INTO nod_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","แต่​มี​บาง​เม็ด​ตก​บน​ดิน​ดี ก็​งอก​งาม​ใหญ่​ขึ้น เกิด​ดอก​ออก​ผล​ร้อย​เต้า​พ่อง หก​สิบ​เต้า​พ่อง สาม​สิบ​เต้า​พ่อง ");
INSERT INTO nod_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","หมู่​สาวก​ปา​กั๋น​มา​ถาม​พระเยซู​ว่า “เป๋น​จาใด​อาจ๋ารย์​เถิง​สอน​คน​ตังหลาย​หมู่​นั้น​เป๋น​กำเผียบ” ");
INSERT INTO nod_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","พระเยซู​ตอบ​ว่า “ข้อ​ล้ำเลิ็ก​เรื่อง​แผ่นดิน​ของ​สวรรค์​โผด​หื้อ​ต้าน​ตังหลาย​ฮู้​ได้ ส่วน​หมู่​คน​อื่น﻿ๆ นั้น​บ่﻿โผด​หื้อ​ใผ​ฮู้​สัก​คน ");
INSERT INTO nod_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","คน​ตี้​เข้าใจ๋​อยู่​แล้ว ก็​จะ​เข้าใจ๋​นัก​ขึ้น​จ๋น​เหลือ​ล้น ส่วน​คน​ตี้​บ่﻿เข้าใจ๋ กับ​บ่﻿สนใจ๋​นั้น แม้​สิ่ง​ตี้​เขา​เข้าใจ๋ พระเจ้า​ก็​จะ​เยียะ​หื้อ​เขา​บ่﻿เข้าใจ๋​แหม​เลย ");
INSERT INTO nod_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ย้อน​จาอั้น​เฮา​จึง​ได้​อู้​ได้​สอน​หมู่​เขา​เป๋น​กำเผียบ เปื้อ​หมู่​เขา​ผ่อ​แล้ว​ผ่อ​แหม​ก็​บ่﻿หัน ฟัง​แล้ว​ฟัง​แหม​ก็​บ่﻿ได้ยิน​กับ​บ่﻿เข้าใจ๋ ");
INSERT INTO nod_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ก็​เป๋น​ไป​ต๋าม​กำ​ตี้​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​บอก​ไว้​ว่า ‘หมู่​เจ้า​จะ​ฟัง​แล้ว​ฟัง​แหม แต่​จะ​บ่﻿เข้าใจ๋ จะ​ผ่อ​แล้ว​ผ่อ​แหม​แต่​จะ​บ่﻿หัน ");
INSERT INTO nod_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ย้อน​จิตใจ๋​ของ​คน​หมู่​นี้​หลึ่ง หมู่​เขา​ปิด​หู​ปิด​ต๋า​เหีย ถ้า​บ่﻿จาอั้น​หมู่​เขา​ก็​จะ​หัน​กับ​ต๋า ได้ยิน​กับ​หู เข้าใจ๋​ด้วย​จิตใจ๋​ของ​หมู่​เขา แล้ว​ปิ๊ก​มา​หา​เฮา​เปื้อ​หื้อ​เฮา​ฮักษา​หมู่​เขา​หื้อ​หาย​ดี’ ");
INSERT INTO nod_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","แต่​หมู่​ต้าน​ได้​หัน​กับ​ต๋า​ได้​ยิน​กับ​หู​ก็​เป๋น​สุข ");
INSERT INTO nod_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​กับ​หมู่​คน​ยำเก๋ง​พระเจ้า​ตังหลาย ใค่​หัน​สิ่ง​ตี้​ต้าน​ตังหลาย​หัน แต่​ก็​บ่﻿เกย​หัน ใค่​ได้ยิน​สิ่ง​ตี้​ต้าน​ตังหลาย​ได้ยิน แต่​ก็​บ่﻿เกย​ได้ยิน ");
INSERT INTO nod_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ฟัง​หื้อ​ดี​เน่อ ต่อ​ไป​นี้​เป๋น​ความหมาย​ของ​กำเผียบ​เรื่อง​คน​หว่าน​เม็ด​พืช ตี้​เอา​เม็ด​พืช​ไป​หว่าน คือ​ว่า ");
INSERT INTO nod_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","เม็ด​ตี้​ตก​ต๋าม​หน​ตาง​เตียว ก็​เหมือน​คน​ตี้​ได้​ฟัง​เรื่อง​แผ่นดิน​ของ​พระเจ้า แต่​บ่﻿เข้าใจ๋ แล้ว​ซาต๋าน​ก็​มา​ลู่​เอา​กำ​นั้น​ตี้​หว่าน​ลง​ใน​ใจ๋​ของ​เขา​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","เม็ด​ตี้​ตก​ลง​ดิน​ตี้​ปื๊น​ตัง​ลุ่ม​เป๋น​บ่าหิน​เต๋ม​ไป​หมด เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​แล้ว ก็​ฮับ​ถ้อยกำ​นั้น​ไว้​บ่า​เดี่ยว​นั้น อย่าง​จื้นจม​ยินดี ");
INSERT INTO nod_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","แต่​ฮาก​ลง​ดิน​บ่﻿เลิ็ก อยู่​ได้​บ่﻿เมิน เมื่อ​เกิด​ปั๋ญหา​กาว่า​โดน​ค่ำ ย้อน​ถ้อยกำ​นั้น​เขา​ก็​เลิก​เจื้อ​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","เม็ด​ตี้​ตก​ก๋าง​ป่า​หนาม​นั้น ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​แล้ว แต่​ยัง​เป๋น​ห่วง​เรื่อง​ต่าง﻿ๆ เกี่ยว​กับ​จีวิต​ใน​โลก​นี้ กับ​หลง​มัว​เมา​ข้าว​ของ​เงิน​คำ สิ่ง​หมู่​นี้​ก็​มา​งำ​ถ้อยกำ​ไว้ เยียะ​หื้อ​ถ้อยกำ​นั้น​บ่﻿เกิด​ผล​ใน​จีวิต ");
INSERT INTO nod_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ส่วน​เม็ด​ตี้​ตก​บน​ดิน​ดี ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​แล้ว​เข้าใจ๋ คน​นั้น​ก็​เกิด​ดอก​ออก​ผล​ร้อย​เต้า​พ่อง หก​สิบ​เต้า​พ่อง กาว่า​สาม​สิบ​เต้า​พ่อง” ");
INSERT INTO nod_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","พระเยซู​เล่า​กำเผียบ​แหม​เรื่อง​นึ่ง หื้อ​เขา​ตังหลาย​ฟัง​ว่า “แผ่นดิน​สวรรค์ เผียบ​เหมือน​คน​นึ่ง​คัด​ข้าว​เจื๊อ​ดี​มา​หว่าน​ใน​นา​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ตก​ต๋อน​เมื่อคืน​นั้น​เมื่อ​คน​หลับ​หมด​แล้ว ศัตรู๋​ของ​เขา​ได้​มา​หว่าน​หญ้า​ข้าวนก​ลง​ไป​ใน​นา​ตั๊ด​ตี้​เดียว​กั๋น แล้ว​ก็​หนี​ไป ");
INSERT INTO nod_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","เมื่อ​เถิง​เวลา​ข้าว​เจื๊อ​ดี​นั้น​ออก​งวง หญ้า​ข้าวนก​ก็​งอก​งาม​ขึ้น​มา​ตวย ");
INSERT INTO nod_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","หมู่​คน​ฮับใจ๊​ก็​ถาม​นาย​ของ​เขา​ว่า ‘นาย​ครับ นาย​หว่าน​ข้าว​เจื๊อ​อย่าง​ดี​ลง​ใน​นา​บ่﻿ใจ้​กา แล้ว​หญ้า​ข้าวนก​ขึ้น​มา​ได้​จาใด’ ");
INSERT INTO nod_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“นาย​ตอบ​ว่า ‘ศัตรู๋​เยียะ’ คน​ฮับใจ๊​ถาม​ว่า ‘นาย​จะ​หื้อ​หมู่​เฮา​ไป​หลก​เอา​หญ้า​ข้าวนก​ออก​ขว้าง​เหีย​ก่อน​ก่อ’ ");
INSERT INTO nod_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“นาย​ตอบ​ว่า ‘บ่﻿ดี​เยียะ ย้อน​กั๋ว​ว่า​ต๋อน​หลก​หญ้า​ข้าวนก จะ​หลัน​หลก​ใส่​ข้าว​เจื๊อ​ดี​ติด​มือ​ออก​มา​ตวย ");
INSERT INTO nod_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ป่อย​หื้อ​ตึง​สอง​ใหญ่​งาม​ไป​ตวย​กั๋น​ก่อน จ๋น​เถิง​หน้า​เกี่ยว​ก็​ได้ แล้ว​เฮา​จะ​สั่ง​หื้อ​คน​งาน​เกี่ยว​หญ้า​ข้าวนก​ออก​ก่อน มัด​เป๋น​หลุ้น﻿ๆ เอา​ไป​เผา​ไฟ​เหีย แล้ว​ปิ๊ก​มา​เกี่ยว​ข้าว​เจื๊อ​ดี​นั้น​เอา​ไป​เก็บ​ไว้​ใน​หลองข้าว​ของ​เฮา’ ” ");
INSERT INTO nod_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","พระเยซู​เล่า​กำเผียบ​แหม​เรื่อง​นึ่ง​หื้อ​เขา​ฟัง​ว่า “แผ่นดิน​สวรรค์ เผียบ​เหมือน​เม็ด​มัสตาร์ด​เม็ด​นึ่ง ตี้​คน​นึ่ง​เอา​ไป​ปูก​ไว้​ใน​สวน​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","เป๋น​เม็ด​หน้อย​ตี้​สุด​ใน​หมู่​เม็ด​พืช​ตังหลาย แต่​ถ้า​ได้​ใหญ่​งอก​งาม​ขึ้น​มา ก็​สูง​ใหญ่​เหลือ​หมู่ จ๋น​นก​มา​แป๋ง​ฮัง​บน​กิ่ง​ของ​เก๊า​นั้น​ได้” ");
INSERT INTO nod_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","พระเยซู​ก็​เล่า​กำเผียบ​แหม​เรื่อง​นึ่ง​หื้อ​เขา​ฟัง​ว่า “แผ่นดิน​สวรรค์​เผียบ​เหมือน​เจื๊อ​ผงฟู ตี้​แม่ญิง​คน​นึ่ง​เอา​มา​สูน​กับ​แป้ง​สาม​ถัง เจื๊อ​นั้น​ก็​เยียะ​หื้อ​แป้ง​นั้น​ปุ๊​ขึ้น​ตึง​หมด” ");
INSERT INTO nod_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","พระเยซู​เล่า​เรื่อง​ตึงหมด​นี้​หื้อ​คน​ตังหลาย​ฟัง​เป๋น​กำเผียบ นอก​จาก​กำเผียบ​แล้ว พระองค์​บ่﻿ได้​อู้​อะหยัง​เลย ");
INSERT INTO nod_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ย้อน​จาอั้น​ก็​เป๋น​ไป​ต๋าม​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​เกย​อู้​ไว้​ว่า “ข้าพเจ้า​จะ​อู้​ออก​มา​เป๋น​กำเผียบ จะ​อู้​เรื่อง​ความ​ลับ​ตี้​ปิด​บัง​ไว้​ตั้งแต่​สร้าง​โลก​มา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","พระเยซู​แหละ​ออก​มา​จาก​คน​ตังหลาย​เข้า​ไป​ใน​เฮือน หมู่​สาวก​เข้า​มา​หา​พระองค์​อู้​ว่า “จ้วย​อธิบาย​เรื่อง​หญ้า​ข้าวนก​ใน​นา​นั้น​หื้อ​ฟัง​หน้อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","พระเยซู​ตอบ​ว่า “คน​ตี้​หว่าน​ข้าว​เจื๊อ​ดี​นั้น​คือ​บุตรมนุษย์ ");
INSERT INTO nod_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","นา​ก็​เผียบ​เหมือน​โลก​นี้ ข้าว​เจื๊อ​ดี​ก็​เผียบ​เหมือน​คน​ของ​แผ่นดิน​สวรรค์ หญ้า​ข้าวนก​เผียบ​เหมือน​คน​ของ​มาร ");
INSERT INTO nod_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ศัตรู๋​ตี้​เข้า​มา​หว่าน​เม็ด​หญ้า​ข้าวนก​นั้น​ก็​คือ​มาร หน้า​เกี่ยว​ข้าว​เผียบ​เหมือน​เป๋น​วัน​สิ้น​โลก หมู่​คน​งาน​ตี้​ปา​กั๋น​เกี่ยว​ข้าว​ก็​เผียบ​เหมือน​หมู่​ทูตสวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“หญ้า​ข้าวนก​ถูก​หลก​มัด​เอา​ไป​เผา​ไฟ​จาใด ใน​วัน​สิ้น​โลก​คน​ของ​มาร​ก็​จะ​ถูก​ปา​ไป​เผา​ไฟ​จาอั้น ");
INSERT INTO nod_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","บุตรมนุษย์​จะ​ส่ง​หมู่​ทูตสวรรค์​ของ​พระเจ้า​มา เปื้อ​รวบรวม​คน​ตี้​เยียะ​หื้อ​คน​อื่น​เยียะ​บาป กับ​คน​ตี้​เยียะ​บ่﻿ดี​ออก​ไป​จาก​แผ่นดิน​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","แล้ว​จะ​เอา​คน​หมู่​นี้​ไป​โจ้ง​ลง​ใน​เต๋าไฟ​ตี้​ฮ้อน​ขนาด ตี้​หั้น​มี​ก้า​เสียง​ไห้​หุย​อย่าง​เจ็บ​ปวด​ตึง​ขบ​เขี้ยว​เกี๊ยว​กาง ");
INSERT INTO nod_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ใน​เวลา​เดียว​กั๋น​คน​ของ​พระเจ้า​จะ​ส่อง​แสง​เหมือน​แสง​ของ​ตะวัน ใน​แผ่นดิน​ของ​พระบิดา​ของ​หมู่​เขา ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“แผ่นดิน​สวรรค์​เผียบ​เหมือน​ว่า​มี​อุ่ง​สมบัติ​ซ่อน​ไว้​ตี้​ก๋าง​โต้ง เมื่อ​มี​คน​มา​ปะ​เข้า​ใส่ ก็​ดี​ใจ๋​ขนาด เอา​ปิ๊ก​เก็บ​ซ่อน​ไว้​เหมือน​เก่า​จึง​ไป​ขาย​กู้​สิ่ง​กู้​อย่าง​ตี้​เขา​มี​แล้ว​เอา​สตางค์​ไป​ซื้อ​ตี้​นา​หั้น​เหีย ");
INSERT INTO nod_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“แผ่นดิน​สวรรค์ ก็​เผียบ​เหมือน​ป้อ​ก๊า​ไป​เซาะ​ซื้อ​ไข่มุก​เม็ด​งาม ");
INSERT INTO nod_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","เมื่อ​ปะ​ไข่มุก​ล้ำก้า​เม็ด​นึ่ง เขา​ก็​ไป​ขาย​กู้​สิ่ง​กู้​อย่าง​ตี้​เขา​มี​เปื้อ​เอา​สตางค์​ไป​ซื้อ​ไข่มุก​งาม​เม็ด​นั้น ");
INSERT INTO nod_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“แหม​อย่าง​นึ่ง​แผ่นดิน​สวรรค์​เผียบ​เหมือน​อวน​ตี้​ลาก​ป๋า​อยู่​ใน​ทะเล แล้ว​ยับ​ป๋า​ได้​หลาย​อย่าง ");
INSERT INTO nod_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","เมื่อ​ยับ​ได้​ป๋า​เต๋ม​อวน​แล้ว ก็​ลาก​ขึ้น​ฝั่ง ปา​กั๋น​นั่ง​เลือก​เอา​ก้า​ป๋า​ตี้​กิ๋น​ได้​ใส่​ซ้า​เก็บ​ไว้ แล้ว​เอา​ป๋า​ตี้​กิ๋น​บ่﻿ได้​ขว้าง​เหีย ");
INSERT INTO nod_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","แล้ว​ใน​วัน​สิ้น​โลก​ก็​จะ​เป๋น​จาอั้น หมู่​ทูตสวรรค์​จะ​แยก​คน​บ่﻿ดี​ออก​จาก​คน​ยำเก๋ง​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ส่วน​หมู่​คน​บ่﻿ดี​ก็​เอา​ไป​โจ้ง​ใน​เต๋าไฟ​ตี้​ฮ้อน มี​ก้า​เสียง​ไห้​หุย​อย่าง​เจ็บ​ปวด​ตึง​ขบ​เขี้ยว​เกี๊ยว​กาง ");
INSERT INTO nod_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“ตึง​หมด​ตึง​เสี้ยง​ตี้​เฮา​อู้​มา​นี้ หมู่​ต้าน​เข้าใจ๋​กั๋น​ก่อ” หมู่​สาวก​ตอบ​ว่า “เข้าใจ๋​ดี​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","พระเยซู​อู้​กับ​หมู่​สาวก​แหม​ว่า “หมู่​ธรรมาจ๋ารย์​กู้​คน​ตี้​ได้​ฮับ​เอา​กำสอน​เรื่อง​แผ่นดิน​สวรรค์​แล้ว ก็​เผียบ​เหมือน​เจ้า​ของ​บ้าน​คน​นึ่ง ตี้​ได้​เอา​สมบัติ​ล้ำ​ก้า​ตึง​เก่า​ตึง​ใหม่​ออก​มา​จาก​ห้อง​เก็บ​ของ​ของ​ตั๋ว” ");
INSERT INTO nod_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","เมื่อ​พระเยซู​เล่า​กำเผียบ​ต่าง﻿ๆ แล้ว​พระองค์​ก็​ไป​จาก​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ปิ๊ก​ไป​เมือง​นาซาเร็ธ​บ้าน​ของ​พระองค์ แล้ว​สั่ง​สอน​คน​ใน​ธรรมศาลา​ของ​จาว​ยิว หมู่​เขา​ก็​ปา​กั๋น​งืด​อู้​กั๋น​ว่า “คน​นี้​ไป​ได้​ผญา​ปั๋ญญา​กับ​ฤทธิ์​อำนาจ​เยียะ​ก๋าน​อัศจ๋รรย์​นี้​มา​จาก​ไหน ");
INSERT INTO nod_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","เขา​เป๋น​ลูก​สล่า​ไม้ แม่​จื้อ​มารีย์ มี​น้องบ่าว​จื้อ​ยากอบ โยเซฟ ซีโมน กับ​ยูดาส​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","น้องสาว​กู้​คน​ก็​อยู่​เมือง​เดียว​กั๋น​กับ​หมู่​เฮา​ตวย​บ่﻿ใจ้​กา แล้ว​เขา​ไป​ได้​สิ่ง​ต่าง﻿ๆ หมู่​นี้​มา​จาก​ตี้​ไหน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","หมู่​เขา​บ่﻿ยอมฮับ​พระองค์ พระองค์​อู้​กับ​หมู่​เขา​ว่า “ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​นั้น​จะ​ได้ฮับ​เกียรติ​ใน​กู้﻿ๆ ตี้ ยกเว้น​ใน​บ้าน​เมือง​เดียว​กั๋น​กับ​ครอบครัว​ของ​ตั๋ว​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","พระเยซู​ก็​บ่﻿ได้​เยียะ​ก๋าน​อัศจ๋รรย์​ตี้​หั้น​นัก​เต้าใด ย้อน​ว่า​หมู่​เขา​บ่﻿มี​ความ​เจื้อ ");
INSERT INTO nod_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","เมื่อ​กษัตริย์​เฮโรด​ตี้​ปกครอง​แคว้น​กาลิลี​ได้ยิน​เรื่อง​ราว​ของ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ก็​อู้​กับ​หมู่​ตี้​เปิ็กษา​ว่า “เขา​คน​นี้​จะ​ต้อง​เป๋น​ยอห์น​ผู้​หื้อ​บัพติศมา​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แหม​เตื้อ​แน่﻿ๆ เขา​เถิง​เยียะ​ก๋าน​อัศจ๋รรย์​หมู่​นี้​ได้” ");
INSERT INTO nod_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","กษัตริย์​เฮโรด​กึ๊ด​จาอั้น​ย้อน​ว่า​ต้าน​ได้​ยับ​ยอห์น​เอา​เจื้อก​เหล็ก​ล่าม​ไว้​ใน​คอก ย้อน​หันแก่​นาง​เฮโรเดียส เมีย​ฟีลิป​น้อง​บ่าว​ของ​ต๋น ");
INSERT INTO nod_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","เซิ่ง​ยอห์น​เกย​อู้​กับ​เฮโรด​ว่า “ต้าน​บ่﻿มี​สิทธิ์​เอา​เมีย​ของ​น้อง​มา​เป๋น​เมีย​ของ​ตั๋ว” ");
INSERT INTO nod_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","เยียะ​หื้อ​เฮโรด​ใค่​ฆ่า​ยอห์น แต่​ก็​กั๋ว​จาว​เมือง​ตังหลาย​ตี้​นับถือ​ยอห์น​ว่า​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ใน​งาน​วัน​เกิด​ของ​กษัตริย์​เฮโรด ใน​งาน​นั้น​ลูก​สาว​ของ​เฮโรเดียส​ฟ้อน​หื้อ​เฮโรด​กับ​แขก​ตี้​มา​ใน​งาน​ผ่อ เฮโรด​ปอ​อก​ปอ​ใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","จึง​ได้​สัญญา​ต่อ​คน​ตังหลาย​ว่า​นาง​ขอ​อะหยัง​ก็​จะ​หื้อ ");
INSERT INTO nod_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","นาง​ก็​เลย​ขอ​ต๋าม​ตี้​แม่​ของ​นาง​บอก​คือ “ข้าเจ้า​ขอ​หัว​ของ​ยอห์น​ผู้​หื้อ​บัพติศมา​ใส่​ถาด​มา​หื้อ​ข้าเจ้า​ตี้​นี่” ");
INSERT INTO nod_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","กษัตริย์​เฮโรด​ก็​ตุ๊ก​ใจ๋​ขนาด แต่​ได้​สัญญา​ต่อหน้า​แขก​ตังหลาย​ไว้ แล้ว ก็​สั่ง​คน​หื้อ​เยียะ​ต๋าม​ตี้​นาง​ขอ ");
INSERT INTO nod_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","เฮโรด​ก็​ใจ๊​คน​ไป​กก​คอ​ยอห์น​ขำ​ใน​คอก ");
INSERT INTO nod_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","แล้ว​เอา​หัว​ใส่​ถาด​มา​หื้อ​นาง​คน​นั้น แล้ว​นาง​ก็​เอา​ไป​หื้อ​แม่ ");
INSERT INTO nod_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ส่วน​หมู่​สาวก​ของ​ยอห์น​ก็​มา​ฮับ​ศพ​ของ​ยอห์น​ไป​ฝัง แล้ว​ไป​เล่า​เรื่อง​ตี้​เกิด​ขึ้น​นี้​หื้อ​พระเยซู​ฟัง ");
INSERT INTO nod_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","เมื่อ​พระเยซู​ได้ยิน​เรื่อง​ของ​ยอห์น​แล้ว ก็​ลง​เฮือ​ไป​ตี้​เงียบ﻿ๆ เป๋น​ส่วน​ตั๋ว คน​ตังหลาย​ต๋าม​เมือง​ต่าง﻿ๆ ฮู้​ก็​ปา​กั๋น​เตียว​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","เมื่อ​พระเยซู​ขึ้น​จาก​เฮือ ก็​หัน​คน​เป๋น​จ๋ำนวน​นัก พระองค์​ก็​ฮู้สึก​อินดู แล้ว​ฮักษา​คน​เป๋น​พยาธิ​ใน​หมู่​นั้น​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ตก​ต๋อน​แลง​หมู่​สาวก​ก็​มา​บอก​พระเยซู​ว่า “อาจ๋ารย์ บ่าเดี่ยว​นี้​ก็​ค่ำ​นัก​แก​แล้ว ต๋ำ​หมู่​นี้​ก็​ทุรกั๋นดาร หื้อ​คน​หมู่​นี้​ปิ๊ก​ไป​ก่อน​บ๋อ เปื้อ​จะ​ได้​ไป​เซาะ​ซื้อ​ของกิ๋น​กั๋น​ต๋าม​หมู่​บ้าน​ต่าง﻿ๆ นั้น” ");
INSERT INTO nod_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","แต่​พระเยซู​ตอบ​ว่า “หื้อ​หมู่​เขา​อยู่​กั๋น​ตี้​นี่​เต๊อะ แต่​หมู่​ต้าน​ไป​เซาะ​ของ​กิ๋น​มา​เลี้ยง​เขา​เหีย” ");
INSERT INTO nod_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","หมู่​สาวก​ตอบ​ว่า “ตี้​นี่​หมู่​เฮา​มี​ก้า​เข้าหนมปัง​ห้า​ก้อน​กับ​ป๋า​สอง​ตั๋ว​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","พระเยซู​บอก​ว่า “เอา​มา​หื้อ​เฮา​ตี้​นี่​ลอ” ");
INSERT INTO nod_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","พระเยซู​สั่ง​คน​ตังหลาย​นั่ง​ลง​บน​หญ้า แล้ว​ฮับ​เข้าหนมปัง​ห้า​ก้อน​กับ​ป๋า​สอง​ตั๋ว​นั้น​มา แล้ว​แหงน​หน้า​ขึ้น​ไป​ผ่อ​ฟ้า​สวรรค์​ขอบ​พระคุณ​พระเจ้า พระองค์​ก็​หัก​เข้าหนมปัง​แล้ว​เอา​เข้าหนมปัง​กับ​ป๋า​นั้น​หื้อ​หมู่​สาวก​แจก​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","คน​ตึง​หมด​ได้​กิ๋น​อิ่ม​กู้​คน แล้ว​หมู่​สาวก​ก็​เก็บ​ของ​กิ๋น​ตี้​เหลือ​ได้​สิบ​สอง​ซ้า​เต๋ม﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","คน​ตี้​กิ๋น​อยู่​ตี้​หั้น​มี​ป้อจาย​ประมาณ​ห้า​ปัน​คน แม่ญิง​กับ​หละอ่อน​บ่﻿ได้​นับ ");
INSERT INTO nod_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","หลัง​จาก​นั้น​สัก​กำ พระเยซู​ก็​บอก​หื้อ​หมู่​สาวก​ลง​เฮือ​ข้าม​ฟาก​ไป​ก่อน ส่วน​พระองค์​ยัง​อยู่​ตี้​หั้น​เปื้อ​ส่ง​คน​ตังหลาย​ปิ๊ก​บ้าน ");
INSERT INTO nod_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","เมื่อ​ส่ง​คน​ตังหลาย​ปิ๊ก​เมือ​บ้าน​หมด​แล้ว พระองค์​ก็​ขึ้น​ไป​บน​ดอย​คน​เดียว​เปื้อ​อธิษฐาน มืด​ค่ำ​แล้ว​พระองค์​ก็​ยัง​อยู่​ตี้​หั้น​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ส่วน​เฮือ​ของ​หมู่​สาวก​ได้​ออก​จาก​ฝั่ง​ไป​จ้าดไก๋​แล้ว ก่ำลัง​ถูก​คลื่น​ลม​ปั๊ด​ไป​ปั๊ด​มา​ย้อน​เฮือ​ตอ​ลม ");
INSERT INTO nod_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ประมาณ​ตี๋​สาม​เถิง​หก​โมง​เจ๊า พระเยซู​เตียว​บน​น้ำ​ไป​หา​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","เมื่อ​หมู่​สาวก​หัน​พระองค์​เตียว​มา​บน​น้ำ ก็​ตกใจ๋​กั๋ว ปา​กั๋น​ฮ้อง​เสียง​ดัง​ว่า “ผี” ");
INSERT INTO nod_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","แต่​พระเยซู​อู้​กับ​หมู่​เขา​ต๋อน​นั้น​ว่า “แป๋ง​ใจ๋​ดี﻿ๆ ไว้ นี่​เฮา​เน่อ บ่﻿ถ้า​กั๋ว” ");
INSERT INTO nod_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","เปโตร​อู้​ว่า “ถ้า​เป๋น​อาจ๋ารย์​แต๊﻿ๆ แล้ว ฮ้อง​ข้าพเจ้า​เตียว​บน​น้ำ​ไป​หา​กำ” ");
INSERT INTO nod_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","พระเยซู​บอก​ว่า “มา​แหละ” เปโตร​ก็​ออก​จาก​เฮือ​เตียว​บน​น้ำ​ไป​หา​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","แต่​เมื่อ​เปโตร​หัน​คลื่น​ลม​แฮง​ก็​กั๋ว เมื่อ​ก่ำลัง​จะ​จ๋ม​ลง​น้ำ ก็​เอิ้น​เสียง​ดัง​ว่า “อาจ๋ารย์ จ้วย​กำ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","พระเยซู​ก็​ฟั่ง​ยื่น​มือ​จั๊ก​ตั๋ว​เขา​ไว้​อู้​ว่า “ต้าน​มี​ความ​เจื้อ​หน้อย​แต๊﻿ๆ สงสัย​เยียะ​หยัง” ");
INSERT INTO nod_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","เมื่อ​พระเยซู​กับ​เปโตร​ขึ้น​เฮือ​แล้ว​ลม​ก็​ย้าง ");
INSERT INTO nod_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","หมู่​สาวก​ตี้​อยู่​ใน​เฮือ​ปา​กั๋น​มา​กราบ​ไหว้​พระเยซู แล้ว​อู้​ว่า “ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","หลัง​จาก​ข้าม​ฟาก​มา​แล้ว ก็​มา​แผว​ฝั่ง​แคว้น​เยนเนซาเรท ");
INSERT INTO nod_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","เมื่อ​คน​ตี้​หั้น​จ๋ำ​พระเยซู​ได้ ก็​ส่ง​ข่าว​เอิ้น​บอก​กั๋น​ไป​ใคว่​แคว้น คน​ตังหลาย​ก็​ปา​คน​ป่วย​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","เปื้อ​อ้อนวอน​ขอ​หยุบ​ตี๋น​เสื้อ​ของ​พระองค์​เต้าอั้น​ก็​ปอ​แล้ว ใผ​ตี้​ได้​หยุบ​ตี๋น​เสื้อ​คุม​ของ​พระองค์​ก็​หาย​ป่วย​กั๋น​หมด​กู้​คน ");
INSERT INTO nod_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ต๋อน​นั้น​มี​หมู่​ฟาริสี​กับ​หมู่​ธรรมาจ๋ารย์​บาง​คน​เตียว​ตาง​มา​จาก​กรุง​เยรูซาเล็ม​มา​หา​พระเยซู ถาม​ว่า ");
INSERT INTO nod_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“เป๋น​จาใด​หมู่​สาวก​ของ​ต้าน​จึง​ปา​กั๋น​ดูถูก​ดู​แควน​กำสอน​ต๋าม​ฮีต​เก่า​ฮอย​เดิม ตี้​ป้ออุ๊ย​แม่หม่อน​สอน​ไว้​เรื่อง​ก๋าน​ซ่วย​มือ​ต๋าม​ธรรมเนียม​ก่อน​กิ๋น​ข้าว” ");
INSERT INTO nod_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","พระเยซู​จึง​ตอบ​หมู่​เขา​ว่า “เป๋น​จาใด​หมู่​ต้าน​เถิง​ดูถูก​ดู​แควน​กำสั่ง​ของ​พระเจ้า​เรื่อง​ตี้​เอา​ก้า​หัน​แต่​ฮีต​เก่า​ฮอย​เดิม​ต่าง﻿ๆ ของ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ย้อน​พระเจ้า​บอก​ว่า ‘หื้อ​เคารพ​นับถือ​ป้อ​แม่​ของ​ตั๋ว’ กับ ‘คน​ใด​ตี้​สาป​แจ้ง​ป้อ​แม่​จะ​ต้อง​มี​โต้ษ​เถิง​ต๋าย’ ");
INSERT INTO nod_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","แต่​หมู่​ต้าน​แอกขะแตก​สอน​ว่า ‘ทรัพย์​สมบัติ​ตี้​ควร​จะ​จ้วยเหลือ​ป้อ​แม่​นั้น​ก็​เปิง​ดี​ตี้​จะ​เอา​ไป​ถวาย​หื้อ​กับ​พระเจ้า​แตน’ ");
INSERT INTO nod_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","จาอี้​ละ​หมู่​ต้าน​ก็​เยียะ​หื้อ​ถ้อยกำ​ของ​พระเจ้า​บ่﻿มี​ผล​ย้อน​ฮีต​เก่า​ฮอย​เดิม​ตี้​สอน​ต่อ﻿ๆ กั๋น​มา ");
INSERT INTO nod_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","หมู่​ต้าน​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด อิสยาห์​อู้​ถูก​แต๊﻿ๆ ตี้​ตวายตั๊ก​เถิง​ต้าน​ตังหลาย​ว่า ");
INSERT INTO nod_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘คน​หมู่​นี้​นับถือ​เฮา​ก้า​ปาก​ของ​เขา​เต้าอั้น แต่​ใจ๋​อยู่​ห่าง​ไก๋​จาก​เฮา ");
INSERT INTO nod_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ก็​เลย​บ่﻿มี​ประโยชน์​ตี้​หมู่​เขา​จะ​นมัสก๋าน​เฮา ย้อน​เขา​เอา​กฎ​ตี้​คน​ตั้ง​ขึ้น​มา​อ้าง​เป๋น​กำสั่ง​ของ​พระเจ้า’ ” ");
INSERT INTO nod_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","แล้ว​พระเยซู​ก็​ฮ้อง​คน​ตังหลาย​เข้า​มา อู้​กับ​หมู่​เขา​ว่า “ฟัง​หื้อ​ดี﻿ๆ หื้อ​เข้าใจ๋​แต๊﻿ๆ เน่อ ");
INSERT INTO nod_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","บ่﻿ใจ้​สิ่ง​ตี้​เข้า​ปาก​เยียะ​หื้อ​คน​เป๋น​มลทิน​ใน​สาย​ต๋า​พระเจ้า​เน่อ แต่​สิ่ง​ตี้​ออก​มา​จาก​ปาก​เยียะ​หื้อ​คน​เป๋น​มลทิน” ");
INSERT INTO nod_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","หมู่​สาวก​ของ​พระเยซู​เข้า​มา​บอก​ว่า “อาจ๋ารย์ ฮู้​ก่อ ตี้​ต้าน​อู้​ไป​นั้น​เยียะ​หื้อ​หมู่​ฟาริสี​ปา​กั๋น​เจ็บใจ๋​ขนาด” ");
INSERT INTO nod_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","พระเยซู​ตอบ​เป๋น​กำเผียบ​ว่า “เก๊าไม้​เก๊า​ใด​ตี้​พระบิดา​ของ​เฮา​ตี้​อยู่​บน​สวรรค์​บ่﻿ได้​ปูก ก็​จะ​หลก​ออก​เหีย​หมด​ตึง​ฮาก ");
INSERT INTO nod_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","บ่﻿ถ้า​ไป​ใส่​ใจ๋​หมู่​เขา​เน่อ เขา​หมู่​นั้น​เผียบ​เหมือน​คน​นำ​ตาง​ตี้​ต๋า​บอด ถ้า​คน​ต๋า​บอด​จู๋ง​คน​ต๋า​บอด ตึง​สอง​คน​ก็​จะ​ปา​กั๋น​ตก​ขุม​ตก​บ่อ” ");
INSERT INTO nod_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","เปโตร​บอก​พระเยซู​ว่า “ขอ​จ้วย​อธิบาย​เรื่อง​กำเผียบ​ตี้​ได้​เล่า​ไป​นั้น​หื้อ​ข้าพเจ้า​ตังหลาย​แหม​กำ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","พระเยซู​อู้​ว่า “ต้าน​ตังหลาย​ยัง​บ่﻿เข้าใจ๋​แหม​กา ");
INSERT INTO nod_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","บ่﻿ฮู้​กา ของ​กู้​อย่าง​ตี้​เข้า​ไป​ใน​ปาก ก็​จะ​ลง​ต๊อง​แล้ว​ก็​ถ่าย​ออก​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","แต่​กำ​อู้​ตี้​ออก​มา​จาก​ปาก​นั้น​ก็​ออก​มา​จาก​จิตใจ๋ สิ่ง​ตี้​ออก​มา​นี้​เยียะ​หื้อ​คน​เป๋น​มลทิน ");
INSERT INTO nod_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ย้อน​ว่า​ก๋าน​กึ๊ด​ฮ้าย ก๋าน​ฆ่า​คน ก๋าน​เล่น​จู๊ ก๋าน​เยียะ​บาป​ตาง​เพศ​กู้​อย่าง ก๋าน​ลัก​ของ ก๋าน​ขี้​จุ ก๋าน​ใส่​ฮ้าย​คน​อื่น​ก็​ออก​มา​จาก​จิตใจ๋​ของ​คน ");
INSERT INTO nod_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","สิ่ง​หมู่​นี้​เยียะ​หื้อ​เป๋น​คน​มลทิน​ใน​สายต๋า​พระเจ้า แต่​เรื่อง​ตี้​บ่﻿ได้​ซ่วย​มือ​ก่อน​กิ๋น​ข้าว​นั้น บ่﻿ได้​เยียะ​หื้อ​คน​เป๋น​มลทิน​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","แล้ว​พระเยซู​ก็​ออก​มา​จาก​ตี้​หั้น เตียว​เข้า​ไป​ใน​เขต​เมือง​ไทระ​กับ​เมือง​ไซดอน ");
INSERT INTO nod_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","มี​แม่ญิง​จาว​คานาอัน​คน​นึ่ง​ตี้​อยู่​ต๋ำ​หมู่​หั้น​เข้า​มา​เอิ้น​ฮ้อง​พระเยซู​ว่า “พระองค์​เจ้า​ข้า ต้าน​ผู้​เป๋น​บุตร​ของ​กษัตริย์​ดาวิด ขอ​โผด​อินดู​ข้าเจ้า​พ่อง​เต๊อะ ลูกสาว​ของ​ข้าเจ้า​โดน​ผี​เข้า เป๋น​ตุ๊ก​ทรมาน​ขนาด” ");
INSERT INTO nod_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ส่วน​พระเยซู​บ่﻿ยอม​อู้​กับ​แม่ญิง​คน​นั้น​สัก​กำ หมู่​สาวก​ก็​เข้า​มา​บอก​พระองค์​ว่า “ไล่​เหิบ​ไป​ไก๋﻿ๆ เต๊อะ นาง​ฮ้อง​เอิ้น​ตวย​ตื๊อ​หมู่​เฮา​มา​บ่﻿ยอม​ย้าง” ");
INSERT INTO nod_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","พระเยซู​งว้าย​หลัง​ไป​ตอบ​แม่ญิง​คน​นั้น​ว่า “พระเจ้า​ส่ง​เฮา​มา​จ้วย​ก้า​คน​อิสราเอล​เต้าอั้น​ตี้​เป๋น​เหมือน​แกะ​หลง” ");
INSERT INTO nod_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","แต่​แม่ญิง​คน​นั้น​ก็​เข้า​มา​คุกเข่า​ต่อ​หน้า​พระเยซู แล้ว​อู้​ว่า “พระองค์​เจ้า​ข้า​ขอ​โผด​จ้วย​ข้าเจ้า​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","พระเยซู​ตอบ​ว่า “บ่﻿ถูกต้อง​ตี้​จะ​เอา​ของกิ๋น​ของ​ลูก​ไป​โจ้ง​หื้อ​หมา” ");
INSERT INTO nod_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","แต่​แม่ญิง​คน​นั้น​ตอบ​ว่า “แม่น​แล้ว แต่​ว่า​ต้าน​เจ้า​ข้า แม้​แต่​หมา​ก็​ยัง​ได้​กิ๋น​เศษ​ของกิ๋น​ตี้​ตก​จาก​โต๊ะ​ของ​เจ้าของ” ");
INSERT INTO nod_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","พระเยซู​ตอบ​ว่า “หญิง​เหย เจ้า​มี​ความ​เจื้อ​นัก​แต๊﻿ๆ สิ่ง​ตี้​เจ้า​ขอ​ก็​หื้อ​เป๋น​ไป​ต๋าม​ตี้​ต้องก๋าน​นั้น​เต๊อะ” เวลา​เดียว​กั๋น​นั้น​ลูกสาว​ของ​นาง​ก็​หาย​เป๋น​ปกติ ");
INSERT INTO nod_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","พระเยซู​ออก​จาก​ตี้​หั้น​เตียว​เลาะ​ฮิม​ฝั่ง​ทะเลสาบ​กาลิลี แล้ว​ก็​ขึ้น​บน​ดอย​นั่ง​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","มี​หมู่​คน​จ๋ำนวน​นัก​มา​หา​พระองค์ ปา​หมู่​คน​ง่อย คน​ต๋า​บอด คน​พิก๋าน คน​เป๋น​ใบ้ ตึง​คน​ตี้​เป๋น​พยาธิ​สะป๊ะ มา​วาง​นอน​ใก้​ตี๋น​พระเยซู แล้ว​พระองค์​ก็​โผด​ฮักษา​หมู่​เขา​จ๋น​หาย​กั๋น​หมด​กู้​คน ");
INSERT INTO nod_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","จ๋น​คน​ตังหลาย​ปา​กั๋น​งืด​เมื่อ​ได้​หัน​คน​ใบ้​อู้​ได้ คน​พิก๋าน​ก็​หาย คน​ง่อย​ก็​เตียว​ได้ คน​ต๋า​บอด​ก็​ผ่อ​หัน​ได้​แหม คน​ตังหลาย​ก็​ปา​กั๋น​สรรเสริญ​พระเจ้า​ของ​จาว​อิสราเอล ");
INSERT INTO nod_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","พระเยซู​ฮ้อง​หมู่​สาวก​มา​หา​อู้​ว่า “เฮา​อินดู​คน​หมู่​นี้​ขนาด ย้อน​หมู่​เขา​อยู่​ตวย​เฮา​สาม​วัน​มา​แล้ว บ่าเดี่ยว​นี้​บ่﻿มี​อะหยัง​กิ๋น​สัก​อย่าง ถ้า​เฮา​หื้อ​หมู่​เขา​ปิ๊ก​บ้าน​โดย​บ่﻿ได้​กิ๋น​อะหยัง​เตื้อ หมู่​เขา​ก็​จะ​เป๋น​ปิ​หมด​แฮง​ก๋าง​ตาง​ก็​ได้” ");
INSERT INTO nod_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","หมู่​สาวก​อู้​ว่า “ใน​ตี้​ทุรกั๋นดาร​จาอี้​จะ​ไป​เซาะ​ของกิ๋น​ตี้​ไหน​มา​เลี้ยง​คน​จ๋ำนวน​นัก​มอก​อี้​ได้” ");
INSERT INTO nod_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","พระเยซู​ถาม​หมู่​สาวก​ว่า “หมู่​ต้าน​มี​เข้าหนมปัง​กี่​ก้อน” หมู่​สาวก​ตอบ​ว่า “มี​เข้าหนมปัง​เจ็ด​ก้อน​กับ​ป๋า​ตั๋ว​หน้อย﻿ๆ บ่﻿กี่​ตั๋ว” ");
INSERT INTO nod_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","พระองค์​สั่ง​หื้อ​คน​ตังหลาย​นั่ง​ลง​บน​ปื๊น​ดิน ");
INSERT INTO nod_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","แล้ว​พระองค์​ฮับ​เอา​เข้าหนมปัง​เจ็ด​ก้อน​กับ​ป๋า​นั้น​มา​อธิษฐาน​ขอบพระคุณ​พระเจ้า แล้ว​ก็​หัก​เข้าหนมปัง​ตึง​ป๋า ยื่น​หื้อ​หมู่​สาวก​เอา​ไป​แจก​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","กู้​คน​กิ๋น​อิ่ม​กั๋น​หมด แล้ว​ยัง​เก็บ​ของกิ๋น​ตี้​เหลือ​ใส่​ก๋วย​ได้​แหม​เจ็ด​แก่น​เต๋ม﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","คน​ตึงหมด​ตี้​นั่ง​กิ๋น​ของกิ๋น​ตวย​กั๋น​หั้น​นับ​ก้า​ป้อจาย​ได้​สี่​ปัน​คน บ่﻿นับ​แม่ญิง​กับ​หละอ่อน ");
INSERT INTO nod_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","เมื่อ​พระเยซู​ส่ง​กู้​คน​ปิ๊ก​เมือ​บ้าน​หมด​แล้ว พระองค์​ก็​ลง​เฮือ​ไป​แคว้น​มากาดาน ");
INSERT INTO nod_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","หมู่​ฟาริสี​กับ​หมู่​สะดูสี​มา​ทดลอง​พระเยซู ขอ​หื้อ​เยียะ​หมายสำคัญ​จาก​ฟ้า​สวรรค์​หื้อ​ผ่อ เปื้อ​จะ​ฮู้​ว่า​พระองค์​มา​จาก​พระเจ้า​แต๊﻿ๆ ก่อ ");
INSERT INTO nod_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","พระเยซู​ตอบ​ว่า “วัน​ใด​ก็​ต๋าม ต๋อน​เมื่อแลง​ตี้​ต๊องฟ้า​เป๋น​สี​แดง หมู่​ต้าน​ก็​บอก​ว่า ‘วัน​พูก​อากาศ​จะ​ดี’ ");
INSERT INTO nod_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","แต่​ถ้า​ต๋อน​เจ๊า​วัน​ใด​ต๊องฟ้า​สี​แดง​กับ​มืด​อึมคึม ต้าน​ก็​จะ​บอก​ว่า ‘วัน​นี้​ฝน​จะ​ตก’ ต้าน​ตังหลาย​แยง​ผ่อ​ต๊องฟ้า​แล้ว​ก็​ฮู้​ว่า​อากาศ​วัน​นี้​จะ​เป๋น​จาใด แต่​เมื่อ​ต้าน​หัน​สิ่ง​ตี้​เฮา​เยียะ​มา เยียะ​หยัง​ต้าน​ตังหลาย​ยัง​บ่﻿ฮู้​บ่﻿เข้าใจ๋​ว่า​หมายเถิง​อะหยัง​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","มี​ก้า​หมู่​คน​บ่﻿ดี​กับ​คน​บ่﻿ซื่อสัตย์​ต่อ​พระเจ้า ตี้​ฮ้อง​ขอ​หื้อ​เยียะ​หมายสำคัญ​หื้อ​ผ่อ แต่​พระเจ้า​จะ​บ่﻿เยียะ​หื้อ​หัน​เน่อ นอก​จาก​หมายสำคัญ​ตี้​เกิด​ขึ้น​กับ​โยนาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า” แล้ว​พระเยซู​ก็​ละ​หมู่​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","เมื่อ​หมู่​สาวก​ของ​พระเยซู​ปา​กั๋น​ข้าม​ไป​แหม​ฟาก​นึ่ง​ของ​ทะเลสาบ​แล้ว หมู่​เขา​ลืม​เอา​เข้าหนมปัง​มา​ตวย ");
INSERT INTO nod_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","พระเยซู​เตื๋อน​หมู่​เขา​ว่า “หื้อ​แน​หละวัง​เจื๊อฟู​ของ​หมู่​ฟาริสี​กับ​หมู่​สะดูสี​ไว้​หื้อ​ดี​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","หมู่​สาวก​อู้​กั๋น​ว่า “ตี้​พระองค์​อู้​จาอี้​ก็​ย้อน​ว่า​หมู่​เฮา​ลืม​เอา​เข้าหนมปัง​มา​ตวย​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","พระเยซู​ฮู้​ว่า​หมู่​เขา​อู้​เรื่อง​อะหยัง​กั๋น​อยู่ ก็​เลย​อู้​ว่า “หมู่​ต้าน​มี​ความ​เจื้อ​หน้อย​เหีย​แต๊﻿ๆ เยียะ​หยัง​หมู่​ต้าน​ปา​กั๋น​อู้​เรื่อง​บ่﻿มี​เข้าหนมปัง ");
INSERT INTO nod_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","หมู่​ต้าน​ยัง​บ่﻿เข้าใจ๋​เตื้อ​กา จ๋ำ​ได้​อยู่​ก่อ​ต๋อน​ตี้​เฮา​เอา​เข้าหนมปัง​ห้า​ก้อน​เลี้ยง​ตึง​ห้า​ปัน​คน แล้ว​เก็บ​ของกิ๋น​ตี้​เหลือ​ใส่​ซ้า​ได้​กี่​แก่น ");
INSERT INTO nod_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","กับ​เรื่อง​เข้าหนมปัง​เจ็ด​ก้อน​เลี้ยง​ได้​ตึง​สี่​ปัน​คน แล้ว​เก็บ​ของกิ๋น​ตี้​เหลือ​ใส่​ก๋วย​นับ​ได้​กี่​แก่น​ฮึ ");
INSERT INTO nod_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","เป๋น​จาใด​หมู่​ต้าน​เถิง​บ่﻿เข้าใจ๋​เตื้อ​ว่า เฮา​บ่﻿ได้​อู้​เรื่อง​เข้าหนมปัง แต่​เฮา​เตื๋อน​หมู่​ต้าน​หื้อ​แน​หละวัง​เจื๊อ​ของ​หมู่​ฟาริสี​กับ​หมู่​สะดูสี​หื้อ​ดี” ");
INSERT INTO nod_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ใน​ตี้​สุด​หมู่​สาวก​ก็​เข้าใจ๋​แล้ว​ว่า พระเยซู​บ่﻿ได้​อู้​เถิง​เรื่อง​หละวัง​เจื๊อ​ตี้​ใส่​ใน​เข้าหนมปัง แต่​หื้อ​หละวัง​กำสอน​ของ​หมู่​ฟาริสี​กับ​หมู่​สะดูสี ");
INSERT INTO nod_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","เมื่อ​พระเยซู​มา​เถิง​แคว้น​ซีซารียา ฟีลิปปี พระองค์​ถาม​หมู่​สาวก​ของ​พระองค์​ว่า “คน​ตังหลาย​อู้​กั๋น​ว่า​บุตรมนุษย์​เป๋น​ใผ​กา” ");
INSERT INTO nod_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","หมู่​สาวก​ตอบ​ว่า “บาง​คน​ก็​ว่า​เป๋น​ยอห์น​ผู้​หื้อ​บัพติศมา บาง​คน​ก็​ว่า​เป๋น​เอลียาห์ เป๋น​เยเรมีย์​ก็​มี กาว่า​เป๋น​คน​ใด​คน​นึ่ง​ใน​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","พระเยซู​ก็​ถาม​หมู่​เขา​ว่า “หมู่​ต้าน​ลอ​กึ๊ด​ว่า​เฮา​เป๋น​ใผ” ");
INSERT INTO nod_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ซีโมน​ตี้​ฮ้อง​แหม​จื้อ​ว่า​เปโตร​ตอบ​ว่า “พระองค์​เป๋น​พระคริสต์​เป๋น​พระบุตร​ของ​พระเจ้า​ตี้​มี​จีวิต​อยู่” ");
INSERT INTO nod_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","พระเยซู​ตอบ​ว่า “ซีโมน ลูก​ของ​โยนาห์​เหย ต้าน​ได้​ฮับ​ปอน​แต๊﻿ๆ ย้อน​ว่า​เรื่อง​นี้​พระบิดา​ของ​เฮา​ตี้​อยู่​ใน​สวรรค์ เป๋น​ผู้​เปิดเผย​หื้อ​ต้าน​ฮู้ บ่﻿ใจ้​คน​บอก​หื้อ​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","เฮา​จะ​บอก​หื้อ​ฮู้​ว่า​ต้าน​คือ​เปโตร ต้าน​เป๋น​เหมือน​บ่าหิน​ตี้​เฮา​จะ​สร้าง​คริสตจักร​ของ​เฮา​ขึ้น​ตั้ง​ไว้ อำนาจ​ตึงหมด​ของ​ความ​ต๋าย​จะ​มี​ชัย​เหนือ​คริสตจักร​ของ​เฮา​นั้น​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","เฮา​จะ​เอา​ขะแจ๋​ตี้​ไข​แผ่นดิน​สวรรค์​ไว้​หื้อ​ต้าน อะหยัง​ก็​ต๋าม​ตี้​ต้าน​ห้าม​ใน​โลก​นี้ พระเจ้า​ก็​ห้าม​สิ่ง​นั้น​ใน​สวรรค์ แล้ว​อะหยัง​ก็​ต๋าม​ตี้​ต้าน​หื้อ​เยียะ​ใน​โลก​นี้ พระเจ้า​ก็​หื้อ​เยียะ​สิ่ง​นั้น​ใน​สวรรค์​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","แล้ว​พระเยซู​สั่ง​หมู่​สาวก​บ่﻿หื้อ​บอก​คน​อื่น​ว่า พระองค์​เป๋น​พระคริสต์ ");
INSERT INTO nod_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ตั้งแต่​นั้น​เป๋น​ต้น​มา​พระเยซู​อธิบาย​หื้อ​หมู่​สาวก​ของ​พระองค์​ฟัง​ว่า พระองค์​จะ​ต้อง​ไป​กรุง​เยรูซาเล็ม แล้ว​จะ​ต้อง​ฮับ​ความ​ตุ๊ก​ทรมาน​หลาย​อย่าง​จาก​หมู่​คน​เฒ่า​คน​แก่​กับ​หมู่​หัวหน้า​ปุโรหิต​ตึง​หมู่​ธรรมาจ๋ารย์ ใน​ตี้​สุด​พระองค์​จะ​ถูก​ฆ่า​ต๋าย แต่​หลัง​จาก​นั้น​แหม​สาม​วัน พระเจ้า​จะ​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","เมื่อ​เปโตร​ได้ยิน​จาอั้น​ก็​ปา​พระเยซู​ออก​จาก​หมู่ แล้ว​ว่า​หื้อ​พระองค์​ว่า “อู้​จาอี้​ได้​จาใด พระเจ้า​จะ​บ่﻿หื้อ​สิ่ง​นี้​เกิด​ขึ้น​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","พระเยซู​ก็​งว้าย​หลัง​มา​อู้​กับ​เปโตร​ว่า “ไอ่​ซาต๋าน ไป​หื้อ​ป๊น​หู​ป๊น​ต๋า เจ้า​ก่ำลัง​ขัดขวาง​เฮา ย้อน​ว่า​เจ้า​บ่﻿ได้​กึ๊ด​อย่าง​พระเจ้า แต่​กึ๊ด​อย่าง​คน” ");
INSERT INTO nod_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","พระเยซู​ก็​อู้​กับ​หมู่​สาวก​ว่า “ถ้า​ใผ​คน​ใด​ใค่​เป๋น​สาวก​ของ​เฮา ก็​หื้อ​คน​นั้น​ตัด​อก​ตัด​ใจ๋ แบก​ไม้​ก๋าง​เขน​ของ​ตั๋ว​เก่า​แล้ว​ตวย​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ย้อน​ว่า​ถ้า​คน​ใด​ใค่​ฮักษา​จีวิต​ของ​ตั๋ว​ไว้ คน​นั้น​จะ​ฮักษา​จีวิต​นั้น​บ่﻿ได้​ก็​จะ​ต๋าย แต่​ถ้า​คน​ใด​ยอม​สละ​จีวิต​ของ​ตั๋ว​ย้อน​หัน​แก่​เฮา คน​นั้น​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","จะ​มี​ประโยชน์​อะหยัง​ถ้า​ได้​เป๋น​เจ้าของ​กู้​สิ่ง​กู้​อย่าง​ใน​โลก​นี้ แต่​ต้อง​เสีย​จีวิต​ของ​ตั๋ว​ไป​เหีย ต้าน​จะ​เอา​อะหยัง​ไป​แลก​กับ​จีวิต​ของ​ต้าน​ปิ๊ก​คืน​มา​ได้ ");
INSERT INTO nod_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","แต่​บุตรมนุษย์​จะ​ปิ๊ก​มา​ด้วย​รัศมี​ของ​พระบิดา​พร้อม​กับ​ทูตสวรรค์​ของ​พระองค์ แล้ว​บุตรมนุษย์​จะ​มา​ตัดสิน​กู้​คน​ต๋าม​ตี้​แต่​ละ​คน​ได้​เยียะ​เอา​ไว้ ");
INSERT INTO nod_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า หมู่​ต้าน​บาง​คน​ตี้​ยืน​อยู่​ตี้​นี่​จะ​ยัง​บ่﻿ต๋าย​เตื้อ จ๋น​กว่า​จะ​ได้​หัน​บุตรมนุษย์​เข้า​มา​อย่าง​กษัตริย์​ตี้​ยิ่งใหญ่” ");
INSERT INTO nod_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","หลัง​จาก​นั้น​หก​วัน​พระเยซู​ปา​เปโตร ยากอบ กับ ยอห์น​น้อง​ของ​ยากอบ ขึ้น​ไป​บน​ดอย​สูง​ตวย​กั๋น​บ่﻿มี​คน​อื่น​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","แล้ว​ตั๋ว​ของ​พระองค์​ก็​เปี่ยน​ไป​ต่อ​หน้า​ต่อ​ต๋า​หมู่​เขา หน้า​ของ​พระองค์​ส่อง​แสง​แจ้ง​เหมือน​ตะวัน เสื้อผ้า​ก็​ขาว​จ๋น​เหลื้อม​มาบ﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","แล้ว​หมู่​เขา​ก็​หัน​โมเสส​กับ​เอลียาห์​ก่ำลัง​อู้​กับ​พระเยซู​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","เปโตร​อู้​กับ​พระเยซู​ว่า “พระองค์​เจ้า​ข้า เป๋น​สิ่ง​ดี​แต๊﻿ๆ ตี้​หมู่​เฮา​ได้​มา​อยู่​ตี้​นี่ ถ้า​พระองค์​ต้องก๋าน หมู่​เฮา​จะ​แป๋ง​ตูบ​ไว้​สาม​หลัง​หื้อ​พระองค์ โมเสส กับ​เอลียาห์​คน​ละ​หลัง” ");
INSERT INTO nod_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","เปโตร​อู้​ลิ้น​ยัง​บ่﻿ตัน​เข้า​ปาก ก็​มี​เมฆ​สว่าง​แจ้ง​หลึ้ง​มา​หุ้ม​หมู่​เขา​ไว้ แล้ว​มี​เสียง​ออก​มา​จาก​เมฆ​ว่า “ต้าน​ผู้​นี้​เป๋น​ลูก​ตี้​เฮา​ฮัก เฮา​ปอใจ๋​ต้าน​นัก​ขนาด​เน่อ หื้อ​เจื้อฟัง​ต้าน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","เมื่อ​หมู่​สาวก​ได้ยิน​ก็​กั๋ว​ขนาด ปา​กั๋น​ก้ม​กราบ​ลง ");
INSERT INTO nod_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","พระเยซู​เตียว​มา​หยุบ​ตั๋ว​หมู่​เขา​อู้​ว่า “ลุก​ขึ้น​เต๊อะ บ่﻿ต้อง​กั๋ว” ");
INSERT INTO nod_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","เมื่อ​หมู่​เขา​แหงน​หน้า​ขึ้น​ผ่อ ก็​บ่﻿หัน​ใผ หัน​ก้า​พระเยซู​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ต๋อน​ตี้​ปา​กั๋น​เตียว​ลง​มา​จาก​ดอย​นั้น พระองค์​สั่ง​หมู่​เขา​ว่า “ห้าม​บอก​หื้อ​ใผ​ฮู้​เน่อ​ว่า หมู่​ต้าน​ได้​หัน​อะหยัง​มา​แล้ว​พ่อง​จ๋น​กว่า​บุตรมนุษย์​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​เหีย​ก่อน” ");
INSERT INTO nod_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","หมู่​สาวก​ถาม​ว่า “เป๋น​จาใด​หมู่​ธรรมาจ๋ารย์​ปา​กั๋น​อู้​ว่า เอลียาห์​ต้อง​มา​ก่อน​พระคริสต์” ");
INSERT INTO nod_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","พระเยซู​ตอบ​ว่า “ถูก​แล้ว​ตี้​เอลียาห์​ต้อง​มา​ก่อน เปื้อ​มา​เกียม​กู้​สิ่ง​กู้​อย่าง​หื้อ​ปิ๊ก​เหมือน​เก่า ");
INSERT INTO nod_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","แต่​เฮา​จะ​บอก​หื้อ​ฮู้​ว่า เอลียาห์​ได้​มา​แล้ว หมู่​เขา​บ่﻿ฮู้​ว่า​เป๋น​เอลียาห์ แต่​ปา​กั๋น​เยียะ​บ่﻿ดี​กับ​เปิ้น​ต๋าม​ใจ๋​ของ​หมู่​เขา เต้าอั้น​ยัง​บ่﻿ปอ​หมู่​เขา​ก็​จะ​ทรมาน​บุตรมนุษย์​จาอั้น​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","หมู่​สาวก​ก็​ฮู้​ว่า ตี้​พระเยซู​อู้​มา​นั้น​หมายเถิง​ยอห์น​ผู้​หื้อ​บัพติศมา ");
INSERT INTO nod_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","เมื่อ​พระเยซู​กับ​หมู่​สาวก​ปิ๊ก​ลง​มา​เถิง​ตี้​หมู่​คน​อยู่​กั๋น ก็​มี​ป้อจาย​คน​นึ่ง​มา​คุก​เข่า​ส่อง​หน้า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","อู้​ว่า “พระองค์​เจ้า​ข้า ขอ​โผด​อินดู​ลูกบ่าว​ของ​ข้าพเจ้า​ตวย​เต๊อะ เขา​เป๋น​โรค​ลม​บ้า​หมู ตุ๊ก​ทรมาน​ขนาด เกย​ตก​น้ำ​ตก​ไฟ​เจื่อ﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ข้าพเจ้า​เกย​ปา​ลูกบ่าว​คน​นี้​มา​หา​หมู่​สาวก​ของ​พระองค์ แต่​หมู่​เขา​ฮักษา​หื้อ​หาย​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","พระเยซู​ตอบ​ว่า “เฮ่อ หมู่​คน​บ่﻿มี​ความ​เจื้อ​กับ​เยียะ​บ่﻿ดี เฮา​จะ​ต้อง​อยู่​กับ​หมู่​สู​แหม​เมิน​สัก​เต้าใด เฮา​จะ​ต้อง​อดทน​กับ​หมู่​สู​ไป​แผว​ไหน ปา​หละอ่อน​คน​นั้น​มา​นี่​แล่” ");
INSERT INTO nod_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","แล้ว​พระเยซู​สั่ง​ผี​ตั๋ว​นั้น​หื้อ​ออก​มา ผี​นั้น​ก็​ออก​จาก​หละอ่อน​คน​นั้น​เวย​บ่﻿ค้าน หละอ่อน​คน​นั้น​ก็​หาย​เป๋น​ปกติ ");
INSERT INTO nod_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","เมื่อ​พระเยซู​อยู่​คน​เดียว หมู่​สาวก​ก็​มา​ถาม​พระองค์​ว่า “เป๋น​จาใด​หมู่​เฮา​เถิง​ไล่​ผี​ตั๋ว​นั้น​ออก​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","พระเยซู​ตอบ​หมู่​เขา​ว่า “ย้อน​หมู่​ต้าน​มี​ความ​เจื้อ​หน้อย​ล้ำ​ไป เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​ต้าน​ตังหลาย​มี​ความ​เจื้อ​เต้า​เม็ด​มัสตาร์ด​เม็ด​นึ่ง แล้ว​สั่ง​ดอย​ม่อน​นี้​หื้อ​ย้าย​จาก​ตี้​นี่​ไป​อยู่​ตัง​ปู๊น ก็​จะ​เป๋น​ไป​ต๋าม​ตี้​ต้าน​ว่า​นั้น จะ​บ่﻿มี​อะหยัง​ตี้​ต้าน​ตังหลาย​จะ​เยียะ​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","เมื่อ​พระเยซู​กับ​หมู่​สาวก​มา​จุมนุม​กั๋น​ตี้​แคว้น​กาลิลี พระเยซู​บอก​กับ​หมู่​เขา​ว่า “จะ​มี​คน​หักหลัง​บุตรมนุษย์ แล้ว​มอบ​พระองค์​หื้อ​อยู่​ใน​อำนาจ​ของ​คน ");
INSERT INTO nod_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","แล้ว​หมู่​เขา​จะ​ฆ่า​พระองค์​หื้อ​ต๋าย แต่​พระองค์​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ใน​วัน​ตี้​สาม” หมู่​สาวก​ก็​ปา​กั๋น​แป๋ง​หน้า​หมอง​ต๋อง​เศร้า​เสียใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","เมื่อ​พระเยซู​กับ​หมู่​สาวก​เตียว​ตาง​มา​เถิง​เมือง​คาเปอรนาอุม มี​คน​เก็บ​สตางค์​ก้า​บำรุง​พระวิหาร​มา​ถาม​เปโตร​ว่า “อาจ๋ารย์​ของ​ต้าน​บ่﻿เสีย​สตางค์​ก้า​บำรุง​พระวิหาร​กา” ");
INSERT INTO nod_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","เปโตร​ตอบ​ว่า “เสีย​ก่า บ่﻿เสีย​จาใด” เมื่อ​เปโตร​เข้า​ไป​หา​พระเยซู​ใน​เฮือน พระองค์​ก็​อู้​ขึ้น​ก่อน​ว่า “ซีโมน ตั๋ว​ต้าน​กึ๊ด​จาใด​พ่อง คน​ตี้​เป๋น​กษัตริย์​ใน​โลก​นี้​เกย​เก็บ​ก้า​ถา​ต่าง﻿ๆ จาก​ใผ เก็บ​จาก​หมู่​ลูก﻿ๆ ของ​ต้าน กาว่า​เก็บ​จาก​คน​อื่น﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","เปโตร​ตอบ​ว่า “เก็บ​จาก​คน​อื่น﻿ๆ” พระเยซู​บอก​ว่า “ถ้า​จาอั้น​หมู่​ลูก﻿ๆ ของ​พระองค์ ก็​บ่﻿ต้อง​เสีย​ก้าถา​แม่น​ก่อ ");
INSERT INTO nod_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","แต่​เปื้อ​บ่﻿หื้อ​คน​ตี้​มา​เก็บ​สตางค์​ก้า​บำรุง​โขด หื้อ​ต้าน​ไป​จ่อม​เบ็ด​ตี้​ทะเลสาบ เมื่อ​ได้​ป๋า​ตั๋ว​เก๊าหัวที หื้อ​ง้าง​ปาก​ป๋า​ออก แล้ว​ต้าน​จะ​ปะ​สตางค์​เหรียญ​นึ่ง​เชเขล หื้อ​เอา​สตางค์​นั้น​ไป​จ่าย​ก้า​บำรุง​พระวิหาร​สำหรับ​เฮา​กับ​ต้าน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","มี​ต๋อน​นึ่ง​หมู่​สาวก​มา​ถาม​พระเยซู​ว่า “ใน​แผ่นดิน​สวรรค์ ใผ​เป๋น​ใหญ่​ตี้​สุด” ");
INSERT INTO nod_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","พระเยซู​ฮ้อง​หละอ่อน​หน้อย​คน​นึ่ง​มา​ยืน​อยู่​ส่อง​หน้า​หมู่​สาวก ");
INSERT INTO nod_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","แล้ว​อู้​กับ​หมู่​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​หมู่​ต้าน​บ่﻿ยอม​เปี่ยน​ใจ๋​หื้อ​เป๋น​เหมือน​หละอ่อน​หน้อย​หมู่​นี้ ก็​จะ​เข้า​ไป​ใน​แผ่นดิน​สวรรค์​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ย้อน​จาอั้น ถ้า​ใผ​คน​ใด​อ่อนน้อม​ถ่อมต๋น เหมือน​หละอ่อน​หน้อย﻿ๆ คน​นี้ ก็​จะ​นับ​ได้​ว่า​เป๋น​คน​ตี้​ยิ่งใหญ่​เหลือ​เปิ้น​ใน​แผ่นดิน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“แหม​อย่าง ใผ​คน​ใด​ตี้​ต้อนฮับ​คน​ตี้​เป๋น​เหมือน​หละอ่อน​หน้อย​จาอี้ ย้อน​หัน​แก่​เฮา ก็​เผียบ​เหมือน​กับ​ว่า​คน​นั้น​ได้​ต้อนฮับ​เฮา​ตวย ");
INSERT INTO nod_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","แต่​ถ้า​ใผ​คน​ใด​เยียะ​หื้อ​คน​ตี้​เป๋น​เหมือน​หละอ่อน​หน้อย​ตี้​เจื้อ​วางใจ๋​ใน​เฮา​หลง​ผิด​ไป​สัก​คน​นึ่ง ก็​หื้อ​เอา​บ่าหิน​โม่​ก้อน​ใหญ่﻿ๆ มัด​ติด​คอ​คน​นั้น แล้ว​อุ้ม​โจ้ง​ลง​ใน​ทะเล​หื้อ​ต๋าย​เหีย ก็​ยัง​ดี​เหลือ ");
INSERT INTO nod_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​โลก​นี้ ย้อน​ว่า​สิ่ง​ต่าง﻿ๆ ตี้​เยียะ​หื้อ​คน​หลงผิด แต่​ความ​ฉิบหาย​จะ​เกิด​ขึ้น​กับ​คน​ตี้​เยียะ​หื้อ​เกิด​เรื่อง​จาอี้​นั้น ");
INSERT INTO nod_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ย้อน​จาอั้น ถ้า​มือ​กา​ว่า​ตี๋น​ของ​ต้าน​เยียะ​หื้อ​ตั๋ว​ต้าน​เป๋น​บาป ก็​หื้อ​กก​ขว้าง​เหีย ย้อน​ว่า​ถ้า​มี​มือ​กุด​กาว่า​ตี๋น​ปุด​แต่​ยัง​มี​จีวิต​นิรันดร์ ก็​ยัง​ดี​เหลือ​มี​มือ​กา​ว่า​ตี๋น​ตึง​สอง​ข้าง​ดี​ครบ​หมด แต่​ต้อง​ตก​ใน​ไฟ​ตี้​บ่﻿มี​วัน​ดับ ");
INSERT INTO nod_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ถ้า​แก่นต๋า​ของ​ต้าน​เยียะ​หื้อ​ตั๋ว​ต้าน​เป๋น​บาป ก็​หื้อ​ควัด​ขว้าง​เหีย ย้อน​ว่า​ถ้า​เหลือ​แก่นต๋า​เผิก​เดียว​แต่​มี​จีวิต​นิรันดร์ ก็​ยัง​ดี​เหลือ​มี​ต๋า​ครบ​ตึง​สอง​แก่น แต่​ต้อง​ตก​หม้อหน้าฮก ");
INSERT INTO nod_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“หละวัง​หื้อ​ดี ห้าม​ดูถูก​ดู​แควน​คน​ตี้​ต่ำต้อย​หมู่​นี้​แม้​แต่​คน​เดียว เฮา​ขอ​บอก​หื้อ​ต้าน​ตังหลาย​ฮู้​ว่า ทูตสวรรค์​ประจ๋ำ​ตั๋ว​ของ​หมู่​เขา​เข้า​เฝ้า​พระบิดา​ของ​เฮา​ตี้​ใน​สวรรค์​ตลอด ");
INSERT INTO nod_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“หมู่​ต้าน​จะ​กึ๊ด​จาใด ถ้า​ป้อจาย​คน​นึ่ง​มี​แกะ​ร้อย​ตั๋ว​แล้ว​มี​ตั๋ว​นึ่ง​หาย​ไป เขา​ก็​ละ​แกะ​เก้า​สิบ​เก้า​ตั๋ว​ไว้​บน​ดอย แล้ว​ไป​ตวย​เซาะ​หา​แกะ​ตั๋ว​ตี้​หาย ");
INSERT INTO nod_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เมื่อ​เขา​ปะ​แกะ​ตั๋ว​ตี้​หาย​ไป​นั้น​แล้ว เขา​จะ​จื้นจมยินดี​ตี้​ได้​ปะ​แกะ​ตั๋ว​นั้น​นัก​เหลือ​ตี้​มี​เก้า​สิบ​เก้า​ตั๋ว​ตี้​บ่﻿ได้​หาย​ไป​แหม​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ก็​เหมือน​เดียว​กั๋น​กับ​พระบิดา​ของ​ต้าน​ตังหลาย​ตี้​อยู่​ใน​สวรรค์ ก็​บ่﻿ใค่​หื้อ​คน​ต่ำต้อย​หมู่​นี้​คน​ใด​คน​นึ่ง​หลง​หาย​ไป​แม้​แต่​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ถ้า​ปี้น้อง​ผู้เจื้อ​เยียะ​บ่﻿ดี​ต่อ​ต้าน ก็​หื้อ​ไป​อธิบาย​ตั๋ว​ต่อ​ตั๋ว​หื้อ​เขา​หัน​ความ​ผิด​ของ​เขา ถ้า​เขา​ฟัง​ต้าน​ก็​นับ​ว่า​เขา​กับ​ต้าน​ปิ๊ก​มา​เป๋น​ปี้น้อง​กั๋น​แหม ");
INSERT INTO nod_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","แต่​ถ้า​เขา​บ่﻿ยอม​ฟัง ก็​หื้อ​ปา​แหม​สัก​คน​สอง​คน​ตวย​ต้าน​ไป​หา​เขา เปื้อ​ว่า​เรื่องราว​ตี้​เกิด​ขึ้น​นั้น​จะ​ได้​มี​พยาน​สอง​สาม​คน​เถิง​จะ​เจื้อถือ​ได้ ");
INSERT INTO nod_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ถ้า​เขา​ยัง​บ่﻿ยอม​ฟัง​แหม ก็​หื้อ​เอา​เรื่อง​นี้​ไป​บอก​คริสตจักร แต่​ถ้า​เขา​ยัง​บ่﻿ยอม​ฟัง​คริสตจักร ก็​หื้อ​เยียะ​กับ​เขา​เหมือน​เป๋น​คน​ตี้​บ่﻿ฮู้จัก​พระเจ้า​กาว่า​เขา​เป๋น​เหมือน​คน​เก็บ​ภาษี​ตี้​ขี้โก๋ง ");
INSERT INTO nod_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า อะหยัง​ก็​ต๋าม​ตี้​ต้าน​ห้าม​ใน​โลก​นี้ พระเจ้า​ก็​ห้าม​สิ่ง​นั้น​ใน​สวรรค์ แล้ว​อะหยัง​ก็​ต๋าม​ตี้​ต้าน​หื้อ​เยียะ​ใน​โลก​นี้ พระเจ้า​ก็​หื้อ​เยียะ​สิ่ง​นั้น​ใน​สวรรค์​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“เฮา​บอก​ต้าน​แหม​ว่า ถ้า​หมู่​ต้าน​ตี้​อยู่​ใน​โลก​นี้​สัก​สอง​คน​ฮ่วม​ใจ๋​กั๋น​ตี้​จะ​ขอ​สิ่ง​นึ่ง​สิ่ง​ใด พระบิดา​ของ​เฮา​ตี้​อยู่​ใน​สวรรค์​ก็​จะ​เยียะ​สิ่ง​นั้น​หื้อ​ต้าน​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ย้อน​ว่า​ตี้​ไหน​ก็​ต๋าม​ตี้​มี​สอง​สาม​คน​มา​จุมนุม​กั๋น​ใน​นาม​ของ​เฮา เฮา​ก็​จะ​อยู่​กับ​หมู่​เขา​ตี้​หั้น” ");
INSERT INTO nod_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ต๋อน​นั้น​เปโตร​เข้า​มา​ถาม​พระเยซู​ว่า “อาจ๋ารย์ ถ้า​ปี้น้อง​เยียะ​ผิด​ต่อ​เฮา​ติก﻿ๆ เฮา​จะ​ยกโต้ษ​หื้อ​กี่​เตื้อ​ดี แผว​เจ็ด​เตื้อ​ปอ​ก่อ” ");
INSERT INTO nod_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","พระเยซู​ตอบ​ว่า “อึ บ่﻿ใจ้​เจ็ด​เตื้อ​เน่อ แต่​ต้อง​เป๋น​เจ็ด​คูณ​แหม​เจ็ด​สิบ​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“ตี้​เป๋น​จาอี้​ย้อน​ว่า แผ่นดิน​สวรรค์​เผียบ​เหมือน​กับ​เจ้า​องค์​นึ่ง ตี้​ต้องก๋าน​จะ​สะสาง​หนี้​ตี้​หมู่​คน​ฮับใจ๊​ติด​ค้าง​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","เมื่อ​ลง​มือ​จัด​ก๋าน​บัญชี ก็​ปา​คน​ฮับใจ๊​คน​นึ่ง​ตี้​เป๋น​หนี้​อยู่​นึ่ง​หมื่น​ตะลันต์ เข้า​มา ");
INSERT INTO nod_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","แต่​เขา​มี​สตางค์​บ่﻿ปอ​ส้าย​หนี้ เจ้า​องค์​นั้น​ก็​เลย​สั่ง​หื้อ​เอา​ตั๋ว​คน​ฮับใจ๊​คน​นี้​ตึง​ลูก​เมีย​กับ​ข้าว​ของ​กู้​อย่าง​ตี้​เขา​มี เอา​ไป​ขาย​เหีย​หื้อ​หมด​เปื้อ​เอา​สตางค์​มา​ส้าย​หนี้ ");
INSERT INTO nod_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“คน​ฮับใจ๊​คน​นั้น​ก็​คุกเข่า​ลง​อ้อนวอน​ต่อ​เจ้า​องค์​นั้น​ว่า ‘ขอ​เวลา​หื้อ​แหม​หน้อย​เต๊อะ จะ​เอา​สตางค์​ตึง​หมด​มา​ใจ๊​หนี้​หื้อ​จ๋น​ครบ​กู้​บาท​กู้​สตางค์’ ");
INSERT INTO nod_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","เจ้า​องค์​นั้น​มี​ความ​อินดู​คน​ฮับใจ๊​คน​นั้น เลย​ยก​หนี้​ตึงหมด​หื้อ แล้ว​ป่อย​ตั๋ว​ไป ");
INSERT INTO nod_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“บ่ากอง​คน​ฮับใจ๊​คน​นั้น​ออก​ไป​แล้ว ไป​ปะ​เปื้อน​ตี้​เป๋น​คน​ฮับใจ๊​ตวย​กั๋น ตี้​เป๋น​หนี้​เขา​อยู่​นึ่ง​ร้อย​เดนาริอัน เขา​ก็​เข้า​ไป​บีบ​คอ​เปื้อน​คน​ฮับใจ๊​คน​นั้น​แล้ว​สั่ง​ว่า ‘ส้าย​สตางค์​ตี้​เป๋น​หนี้​มา​บ่าเดี่ยว​นี้​เลย’ ");
INSERT INTO nod_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“เปื้อน​คน​ฮับใจ๊​ตี้​เป๋น​ลูก​หนี้​ก็​คุก​เข่า​ลง​อ้อนวอน​ว่า ‘ขอ​เวลา​แหม​สัก​หน้อย​เต๊อะ แล้ว​เฮา​จะ​เอา​สตางค์​ตึงหมด​มา​ส้าย​หนี้​หื้อ​จ๋น​ครบ’ ");
INSERT INTO nod_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“แต่​เขา​บ่﻿ยอม เลย​สั่ง​หื้อ​ยับ​เปื้อน​คน​ฮับใจ๊​คน​นั้น​ไป​ขัง​คอก​ไว้​จ๋น​กว่า​จะ​ส้าย​หนี้​จ๋น​ครบ​ตึงหมด​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","เมื่อ​คน​ฮับใจ๊​คน​อื่น﻿ๆ หัน​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น ก็​ฮู้สึก​สลด​ใจ๋ เลย​ไป​เล่า​เรื่อง​ตี้​เกิด​ขึ้น​นี้​หื้อ​เจ้า​องค์​นั้น​ฟัง ");
INSERT INTO nod_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“เจ้า​องค์​นั้น​ฮ้อง​คน​ฮับใจ๊​คน​เก่า​มา​หา อู้​ว่า ‘ไอ่​ขี้ข้า​ใจ๋​ดำ เฮา​ได้​ยก​หนี้​หื้อ​เจ้า​ตึงหมด​แล้ว ย้อน​ว่า​เจ้า​ได้​อ้อนวอน​เฮา ");
INSERT INTO nod_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","เจ้า​ก็​น่า​จะ​อินดู​เปื้อน​คน​ฮับใจ๊​คน​อื่น﻿ๆ เหมือน​อย่าง​ตี้​เฮา​อินดู​เจ้า​ตวย​บ่﻿ใจ้​กา’ ");
INSERT INTO nod_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","เจ้า​องค์​นั้น​โขด​ขนาด เลย​เอา​คน​ฮับใจ๊​คน​นี้​ขัง​คอก แล้ว​ก็​หื้อ​ลง​โต้ษ​เขา​จ๋น​กว่า​จะ​ส้าย​หนี้​จ๋น​ครบ ");
INSERT INTO nod_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“พระบิดา​ของ​เฮา​ตี้​อยู่​ใน​สวรรค์​จะ​เยียะ​จาอี้​กับ​หมู่​ต้าน​กู้​คน​เหมือน​กั๋น ถ้า​หมู่​ต้าน​บ่﻿ยอม​ยกโต้ษ​หื้อ​กับ​ปี้น้อง​จาก​ใจ๋​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","หลัง​จาก​ตี้​พระเยซู​อู้​เรื่อง​หมู่​นี้​แล้ว ก็​ออก​จาก​แคว้น​กาลิลี​เตียว​ตาง​เข้า​ไป​แคว้น​ยูเดีย​ตี้​อยู่​แหม​เผิก​นึ่ง​ของ​แม่น้ำ​จอร์แดน ");
INSERT INTO nod_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","มี​คน​ติดต๋าม​พระเยซู​ไป​เป๋น​จ๋ำนวน​นัก พระองค์​ก็​ฮักษา​คน​เป๋น​พยาธิ​ใน​หมู่​เขา​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","หมู่​ฟาริสี​บาง​คน​มา​ลอง​เจิง​พระเยซู ถาม​ว่า “จะ​ผิด​บท​บัญญัติ​ก่อ ถ้า​ผัว​จะ​ละ​เมีย​เหีย บ่﻿ว่า​จะ​มี​สาเหตุ​มา​จาก​เรื่อง​อะหยัง​ก็​ต๋าม” ");
INSERT INTO nod_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","พระเยซู​ตอบ​ว่า “หมู่​ต้าน​บ่﻿เกย​อ่าน​กา ว่า​ต๋อน​เก๊าหัวที​พระ​ผู้​สร้าง​ได้​สร้าง​คน​เป๋น​ป้อจาย​กับ​แม่ญิง ");
INSERT INTO nod_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","พระเจ้า​อู้​ว่า ‘ย้อน​จาอั้น​ป้อจาย​จะ​แยก​จาก​ป้อ​แม่​ของ​ตั๋ว​ไป​อยู่​ฮ่วม​ผูกพัน​กั๋น​กับ​เมีย ตึง​สอง​คน​จะ​ก๋าย​เป๋น​คน﻿ๆ เดียว​กั๋น’ ");
INSERT INTO nod_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","กับ​จะ​บ่﻿เป๋น​สอง​คน​แหม​ต่อ​ไป แต่​เป๋น​คน﻿ๆ เดียว​กั๋น ย้อน​จาอั้น​สิ่ง​ตี้​พระเจ้า​ได้​มัด​ได้​ปัน​เข้า​ตวย​กั๋น​แล้ว บ่﻿ดี​หื้อ​ใผ​มา​เต​เขา​ตึง​สอง​ออก​จาก​กั๋น​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","หมู่​ฟาริสี​ถาม​แหม​ว่า “เป๋น​จาใด​โมเสส​เถิง​สั่ง​หื้อ​เขียน​ใบหย่า​หื้อ​เมีย​เหีย แล้ว​ก็​ละ​นาง​ไป​ได้​เลย” ");
INSERT INTO nod_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","พระเยซู​ตอบ​ว่า “โมเสส​ยอม​หื้อ​หมู่​ต้าน​ละ​เมีย​ได้ ย้อน​ว่า​หมู่​ต้าน​หลึกหลึ่ง แต่​พระเจ้า​บ่﻿ได้​ตั้งใจ๋​หื้อ​เป๋น​ไป​จาอั้น​ตั้งแต่​เก๊า​แต่​เหง้า ");
INSERT INTO nod_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","แต่​เฮา​บอก​ต้าน​ตังหลาย​ว่า ป้อจาย​คน​ใด​ละ​เมีย​แล้ว​ไป​มี​เมีย​ใหม่ ย้อน​สาเหตุ​อื่น﻿ๆ เว้น​แต่​เมีย​ไป​เล่นจู๊ ก็​ถือ​ว่า​ผิด​เรื่อง​ก๋าน​ล่วง​ประเวณี” ");
INSERT INTO nod_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","หมู่​สาวก​อู้​กับ​พระเยซู​ว่า “ถ้า​มี​ข้อ​นี้​ข้อ​เดียว​ตี้​ป้อจาย​จะ​ละ​เมีย​ได้ บ่﻿แต่งงาน​เหีย​เลย​จะ​ดี​เหลือ​ก่อน” ");
INSERT INTO nod_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","พระเยซู​ตอบ​ว่า “บ่﻿ใจ้​ว่า​กู้​คน​ยอมฮับ​กำ​นี้​ได้ แต่​จะ​มี​บาง​คน​เต้าอั้น​ตี้​พระเจ้า​เยียะ​หื้อ​ฮับ​ได้ ");
INSERT INTO nod_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","อย่าง​บาง​คน​เกิด​มา​เป๋น​จาอั้น บาง​คน​ถูก​ยับ​ต๋อน​เหีย​และ​บาง​คน​บ่﻿แต่งงาน​ย้อน​หัน​แก่​แผ่นดิน​สวรรค์ ถ้า​ใผ​ยอมฮับ​กำสอน​นี้​ได้​ก็​หื้อ​ยอมฮับ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ต๋อน​นั้น​มี​บาง​คน​ปา​หละอ่อน​หน้อย﻿ๆ ของ​หมู่​เขา​เข้า​มา​หา​พระเยซู เปื้อ​หื้อ​พระองค์​วาง​มือ​กับ​อธิษฐาน​เผื่อ แต่​หมู่​สาวก​ว่า​หื้อ ");
INSERT INTO nod_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","แต่​พระเยซู​บอก​ว่า “หื้อ​หมู่​หละอ่อน​เข้า​มา​หา​เฮา​เต๊อะ บ่﻿ดี​ห้าม​เขา​ไว้ ย้อน​ว่า​แผ่นดิน​สวรรค์​เป๋น​ของ​คน​ตี้​เผียบ​เหมือน​หละอ่อน​หมู่​นี้” ");
INSERT INTO nod_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","หลัง​จาก​ตี้​พระเยซู​วาง​มือ​ปั๋น​ปอน​หละอ่อน​หมู่​นั้น​แล้ว พระองค์​ก็​ออก​ไป​จาก​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","มี​ป้อจาย​คน​นึ่ง​มา​หา​พระเยซู​ถาม​ว่า “อาจ๋ารย์ ข้าพเจ้า​จะ​ต้อง​เยียะ​ความ​ดี​อะหยัง​พ่อง​เถิง​จะ​ได้​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","พระเยซู​ตอบ​ว่า “เป๋น​จาใด​ต้าน​เถิง​ถาม​เฮา​ว่า​อะหยัง​ดี มี​ก้า​พระเจ้า​เต้าอั้น​ตี้​ดี ถ้า​ต้าน​ต้องก๋าน​จะ​มี​จีวิต​นิรันดร์​ก็​ต้อง​เยียะ​ต๋าม​บท​บัญญัติ” ");
INSERT INTO nod_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ป้อจาย​คน​นั้น​ถาม​ว่า “ข้อ​ไหน​พ่อง” พระเยซู​ตอบ​ว่า “ข้อ​ตี้​ว่า ‘ห้าม​ฆ่า​คน ห้าม​เป๋น​จู๊​ผัว​เมีย​เปิ้น ห้าม​ลัก​ของ​ของ​เปิ้น ห้าม​เป๋น​พยาน​ตี้​อู้​บ่﻿แต๊ ");
INSERT INTO nod_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","จง​เคารพ​นับถือ​ป้อ​แม่​ของ​ตั๋ว แล้ว​จง​ฮัก​เปื้อน​บ้าน​เหมือน​ฮัก​ตั๋ว​เก่า’ ” ");
INSERT INTO nod_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ป้อจาย​หนุ่ม​คน​นั้น​ตอบ​ว่า “ข้อ​ต่าง﻿ๆ ใน​บท​บัญญัติ​นี้ ข้าพเจ้า​ได้​ถือ​ฮักษา​กู้​ข้อ​บ่﻿ได้​ขาด​อยู่​แล้ว ยัง​มี​อะหยัง​ตี้​จะ​ต้อง​เยียะ​แหม​ก่อ” ");
INSERT INTO nod_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","พระเยซู​ตอบ​ว่า “ถ้า​ต้าน​ต้องก๋าน​เป๋น​คน​ดี​พร้อม​ใน​สายต๋า​ของ​พระเจ้า ต้าน​จะ​ต้อง​ไป​ขาย​ของ​กู้​อย่าง​ตี้​ต้าน​มี​อยู่ แล้ว​เอา​สตางค์​ไป​แจก​คน​ตุ๊ก​คน​จ๋น ต้าน​จึง​จะ​มี​สมบัติ​ใน​สวรรค์ แล้ว​ตวย​เฮา​มา​เป๋น​สาวก​ของ​เฮา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","เมื่อ​ป้อจาย​หนุ่ม​คน​นั้น​ได้ยิน​จาอั้น ก็​เตียว​ออก​ไป​ด้วย​ใจ๋​เป๋น​ตุ๊ก ย้อน​ว่า​เขา​รวย​นัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","พระเยซู​อู้​กับ​หมู่​สาวก​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​รวย​จะ​เข้า​ใน​แผ่นดิน​สวรรค์​ก็​ยาก​นัก​แก ");
INSERT INTO nod_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","เฮา​ขอ​บอก​หมู่​ต้าน​แหม​เตื้อ​ว่า ตั๋ว​อูฐ​ลอด​เข้า​ฮู​เข็ม ยัง​ง่าย​เหลือ​ตี้​คน​รวย​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​แหม​ก่อน” ");
INSERT INTO nod_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","เมื่อ​หมู่​สาวก​ได้ยิน​จาอั้น ก็​ปา​กั๋น​งืด​ขนาด ถาม​ว่า “ถ้า​จาอั้น ใผ​จะ​รอด​ป๊น​บาป​โต้ษ​ได้” ");
INSERT INTO nod_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","พระเยซู​ผ่อ​หมู่​สาวก​แล้ว​อู้​ว่า “สำหรับ​คน เป๋น​ไป​บ่﻿ได้​อยู่​แล้ว แต่​สำหรับ​พระเจ้า​กู้​สิ่ง​กู้​อย่าง​เป๋น​ไป​ได้​ตึงหมด” ");
INSERT INTO nod_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","เปโตร​ถาม​พระเยซู​ว่า “ผ่อ​ลอ หมู่​เฮา​ได้​ละ​กู้​สิ่ง​กู้​อย่าง​เปื้อ​ติดต๋าม​อาจ๋ารย์​มา แล้ว​หมู่​เฮา​จะ​ได้​อะหยัง​ตอบ​แตน​พ่อง” ");
INSERT INTO nod_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","พระเยซู​ตอบ​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ใน​ยุค​ใหม่ บุตรมนุษย์​จะ​นั่ง​บน​บัลลังก์​อัน​ยิ่งใหญ่ แล้ว​ต้าน​ตังหลาย​ตี้​ได้​ตวย​เฮา ก็​จะ​ได้​นั่ง​บน​บัลลังก์​สิบ​สอง​ตี้ เปื้อ​ตัดสิน​สิบ​สอง​ผะกุ๋น​ของ​คน​อิสราเอล ");
INSERT INTO nod_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","กู้​คน​ตี้​ละ​บ้าน กาว่า​ละ​ปี้น้อง ละ​ป้อ​แม่ ละ​ลูก﻿ๆ กาว่า​ละ​ไฮ่​นา​ย้อน​หันแก่​เฮา ก็​จะ​ได้​ฮับ​ผล​ตอบ​แตน​เป๋น​ร้อย​เต้า กับ​จะ​ได้​ฮับ​จีวิต​นิรันดร์​ตวย ");
INSERT INTO nod_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","แต่​มี​หลาย​คน​ตี้​เป๋น​คน​ตังเก๊า​ใน​ต๋อน​นี้ จะ​ก๋าย​เป๋น​คน​ตังป๋าย กับ​คน​ตังป๋าย​ต๋อน​นี้ จะ​ก๋าย​ไป​เป๋น​คน​ตังเก๊า” ");
INSERT INTO nod_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“แผ่นดิน​สวรรค์​เผียบ​เหมือน​เจ้าของ​สวน​คน​นึ่ง ตี้​ออก​จาก​เฮือน​ไป​เจ๊า​มืด เปื้อ​ไป​จ้าง​คน​งาน​มา​เยียะ​ก๋าน​ใน​สวน​องุ่น​ของ​เปิ้น ");
INSERT INTO nod_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","เมื่อ​ตกลง​กั๋น​แล้ว​ว่า​จะ​หื้อ​ก้า​แฮง​นึ่ง​เดนาริอัน​ต่อ​วัน แล้ว​ก็​ส่ง​คน​งาน​เข้า​ไป​เยียะ​ก๋าน​ใน​สวน​องุ่น ");
INSERT INTO nod_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“ประมาณ​เก้า​โมง​เจ๊า เจ้าของ​สวน​ก็​เตียว​เข้า​ไป​ตี้​กาด​แหม ก็​หัน​บาง​คน​ยืน​อยู่​บ่﻿ดาย บ่﻿ได้​เยียะ​ก๋าน​อะหยัง ");
INSERT INTO nod_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","เจ้าของ​สวน​อู้​ว่า ‘ถ้า​หมู่​เจ้า​ไป​เยียะ​ก๋าน​ใน​สวน​องุ่น​ของ​เฮา เฮา​จะ​หื้อ​ก้า​จ้าง​ต๋าม​สมควร’ ");
INSERT INTO nod_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","คน​หมู่​นั้น​ก็​ตกลง​ไป​เยียะ​ก๋าน ใน​สวน​องุ่น ประมาณ​เติงตอน เจ้า​ของ​สวน​ก็​ออก​ไป​แหม บ่าย​สาม​โมง​แล้ว​ก็​ยัง​ออก​ไป​เยียะ​จาอั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ประมาณ​ห้า​โมง​แลง เจ้าของ​สวน​ก็​ออก​ไป​แหม​เตื้อ ก็​หัน​บาง​คน​ยืน​อยู่​บ่﻿ดาย เปิ้น​ก็​เข้า​ไป​ถาม​คน​หมู่​นั้น​ว่า ‘เป๋น​จาใด​หมู่​เจ้า​เถิง​ยืน​ตี้​นี่ บ่﻿เยียะ​ก๋าน​อะหยัง​วัน​ค่ำ​จาอี้’ ");
INSERT INTO nod_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“เขา​หมู่​นั้น​ตอบ​ว่า ‘บ่﻿มี​ใผ​จ้าง​หมู่​เฮา’ เจ้าของ​สวน​ก็​จวน​หมู่​เขา​ว่า ‘ไป​เยียะ​ก๋าน​ตี้​สวน​องุ่น​ของ​เฮา​บ๋อ’ ");
INSERT INTO nod_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ตก​เมื่อแลง​วัน​นั้น​เถิง​เวลา​เลิก​งาน​แล้ว เจ้า​ของ​สวน​สั่ง​หัวหน้า​คน​งาน​ว่า ‘ไป​ฮ้อง​คน​งาน​ตึงหมด​มา แล้ว​จ่าย​ก้า​แฮง​หื้อ​หมู่​เขา จ่าย​ต๋าม​ลำดับ​ตั้งแต่​คน​มา​เมื่อลูน​จ๋น​เถิง​คน​ตี้​มา​เก๊าหัวที’ ");
INSERT INTO nod_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“คน​งาน​ตี้​มา​เมื่อลูน​ต๋อน​ห้า​โมง​แลง ได้​ก้า​แฮง​ไป​คน​ละ​นึ่ง​เดนาริอัน ");
INSERT INTO nod_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","หมู่​คน​งาน​ฮับจ้าง​ตี้​มา​ก่อน​ก็​คาด​ว่า​จะ​ได้​นัก​เหลือ​นั้น แต่​ก็​ได้​คน​ละ​นึ่ง​เดนาริอัน​เต้า​กั๋น​หมด ");
INSERT INTO nod_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","เมื่อ​หมู่​เขา​ฮับ​ก้า​แฮง​ไป​แล้ว ก็​จ่ม​ว่า​หื้อ​เจ้าของ​สวน​ว่า ");
INSERT INTO nod_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘คน​หมู่​นั้น​เยียะ​ก๋าน​จั้วโมง​เดียว แต่​ได้​ก้า​แฮง​เต้า​กับ​หมู่​เฮา​ตี้​เยียะ​ก๋าน​ฮิม​ต๋าย​อยู่​ก๋าง​แดด​ฮ้อน​วัน​ค่ำ’ ");
INSERT INTO nod_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“เจ้าของ​สวน​องุ่น​ก็​ตอบ​คน​นึ่ง​ใน​หมู่​คน​นั้น​ว่า ‘เปื้อน​เหย เฮา​บ่﻿ได้​โก๋ง​เจ้า​เน่อ ก็​ตกลง​ก้า​แฮง​กั๋น​ไว้​แล้ว​ว่า​นึ่ง​เดนาริอัน​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ฮับ​ก้า​แฮง​ของ​เจ้า​แล้ว​ไป​เหีย​เต๊อะ เฮา​ปอ​ใจ๋​จะ​จ่าย​หื้อ​คน​ตี้​เฮา​จ้าง​มา​เมื่อลูน​เต้า​กับ​ตี้​เฮา​จ่าย​หื้อ​เจ้า ");
INSERT INTO nod_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","เฮา​มี​สิทธิ์​ตี้​จะ​เยียะ​จาอี้​กับ​สตางค์​ของ​เฮา กาว่า​เจ้า​ขอย​ย้อน​เฮา​ใจ๋​กว้าง​จาอั้น​กา’ ");
INSERT INTO nod_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“แต่​มี​หลาย​คน​ตี้​เป๋น​คน​ตังเก๊า​ใน​ต๋อน​นี้ จะ​ก๋าย​เป๋น​คน​ตังป๋าย กับ​คน​ตังป๋าย​ต๋อน​นี้ จะ​ก๋าย​ไป​เป๋น​คน​ตังเก๊า” ");
INSERT INTO nod_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ต๋อน​ตี้​พระเยซู​ก่ำลัง​เตียว​ตาง​ไป​กรุง​เยรูซาเล็ม พระองค์​ฮ้อง​สาวก​ตึง​สิบ​สอง​คน​หื้อ​ออก​จาก​คน​ตังหลาย​มา​อยู่​เปาะ​กั๋น แล้ว​อู้​กับ​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ผ่อ​เน่อ หมู่​เฮา​ก่ำลัง​จะ​ไป​กรุง​เยรูซาเล็ม แล้ว​บุตรมนุษย์​จะ​ถูก​หักหลัง​หื้อ​อยู่​ใน​อำนาจ​ของ​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์ เขา​หมู่​นั้น​จะ​ตัดสิน​ลงโต้ษ​ต้าน​เถิง​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","แล้ว​จะ​มอบ​ต้าน​หื้อ​กับ​คน​ต่างจ้าด​เฆี่ยน​ตี๋​กับ​เยาะเย้ย แล้ว​ก็​ปา​ไป​เขิง​ตี้​ไม้​ก๋าง​เขน​จ๋น​ต๋าย แต่​ใน​วัน​ตี้​สาม​พระเจ้า​จะ​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","แม่​ของ​ยากอบ​กับ​ยอห์น​ตี้​เป๋น​ลูกบ่าว​ของ​เศเบดี สาม​คน​แม่​ลูก​ปา​กั๋น​มา​หา​พระเยซู นาง​คุกเข่า​ลง​แล้ว​ขอ​หื้อ​พระองค์​เยียะ​หื้อ​นาง​อย่าง​นึ่ง ");
INSERT INTO nod_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","พระเยซู​ถาม​นาง​ว่า “มี​เรื่อง​อะหยัง​กา” นาง​ตอบ​ว่า “เมื่อ​พระองค์​ขึ้น​เป๋น​เจ้า​องค์​นั้น​แล้ว ขอ​หื้อ​ลูกบ่าว​ตึง​สอง​คน​ของ​ข้าเจ้า​นั่ง​อยู่​เผิก​ขวา​คน​นึ่ง เผิก​ซ้าย​คน​นึ่ง​ตวย​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","พระเยซู​ตอบ​ว่า “หมู่​ต้าน​บ่﻿ฮู้​ว่า ก่ำลัง​ขอ​อะหยัง ต้าน​จะ​กิ๋น​น้ำ​จาก​ถ้วย​แห่ง​ความ​ตุ๊ก​ตี้​เฮา​จะ​กิ๋น​ได้​กา” เขา​ตึง​สอง​ตอบ​ว่า “ได้​ก่า” ");
INSERT INTO nod_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","พระเยซู​บอก​เขา​ว่า “หมู่​ต้าน​จะ​ได้​กิ๋น​จาก​ถ้วย​ของ​เฮา​แน่นอน แต่​ตี้​จะ​หื้อ​ใผ​นั่ง​เผิก​ขวา​เผิก​ซ้าย​ของ​เฮา​นั้น บ่﻿ใจ้​เฮา​เป๋น​คน​จัด​หื้อ​นั่ง​เน่อ แต่​พระบิดา​ของ​เฮา​เต้าอั้น​ตี้​เป๋น​ผู้​เลือก​ว่า​จะ​หื้อ​ใผ​นั่ง​ตั๊ด​ไหน” ");
INSERT INTO nod_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","เมื่อ​หมู่​สาวก​แหม​สิบ​คน​ได้ยิน​จาอั้น ก็​ปา​กั๋น​โขด​สอง​คน​ปี้น้อง​นั้น ");
INSERT INTO nod_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","พระเยซู​ก็​ฮ้อง​หมู่​เขา​ตึงหมด​มา​หา แล้ว​อู้​ว่า “ต้าน​ตังหลาย​ก็​ฮู้​แล้ว​ว่า​ผู้​ปกครอง​ของ​คน​ต่างจ้าด วาง​ตั๋ว​เป๋น​นาย​เหนือ​เขา​ตังหลาย หมู่​ผู้นำ​ก็​ใจ๊​อำนาจ​เหนือ​เขา​ตังหลาย​ตวย ");
INSERT INTO nod_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","แต่​สำหรับ​หมู่​ต้าน​นั้น​บ่﻿เป๋น​จาอั้น​เน่อ ใน​หมู่​ต้าน​ถ้า​ใผ​คน​ใด​ใค่​เป๋น​ใหญ่ ก็​หื้อ​เขา​เป๋น​ผู้​ฮับใจ๊​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ถ้า​ใผ​คน​ใด​ใค่​เป๋น​ใหญ่​เหลือ​เปิ้น ก็​ต้อง​ยอม​สมัคร​ใจ๋​เป๋น​คน​ฮับใจ๊​ของ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","เหมือน​เดียว​กั๋น​กับ​บุตรมนุษย์​ตี้​บ่﻿ได้​มา​เปื้อ​หื้อ​คน​อื่น​ฮับใจ๊ แต่​มา​เปื้อ​ฮับใจ๊​คน​อื่น แล้ว​ก็​สละ​จีวิต​ของ​ต้าน​เปื้อ​เป๋น​ก้า​ไถ่​คน​จ๋ำนวน​นัก​หื้อ​รอด​ป๊น​บาป​โต้ษ” ");
INSERT INTO nod_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ต๋อน​ตี้​พระเยซู​กับ​สาวก​ก่ำลัง​ออก​จาก​เมือง​เยรีโค มี​คน​เตียว​ไป​ตวย​เป๋น​จ๋ำนวน​นัก ");
INSERT INTO nod_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","มี​คน​ต๋า​บอด​สอง​คน​นั่ง​อยู่​ฮิม​หนตาง เมื่อ​ได้ยิน​ว่า​พระเยซู​ก่ำลัง​เตียว​ก๋าย​มา ก็​ฮ้อง​เอิ้น​เสียง​ดัง​ว่า “องค์​พระผู้เป๋นเจ้า บุตร​ของ​กษัตริย์​ดาวิด​เหย ขอ​โผด​อินดู​เฮา​สอง​คน​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","คน​ตังหลาย​ปา​กั๋น​ด่า​คน​ต๋า​บอด​สอง​คน​นั้น​หื้อ​ดัก​เหีย แต่​เขา​ก็​เอิ้น​ดัง​ขึ้น​ติก﻿ๆ ว่า “องค์​พระผู้เป๋นเจ้า บุตร​ของ​กษัตริย์​ดาวิด​เหย ขอ​โผด​อินดู​หมู่​เฮา​สอง​คน​น่อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","พระเยซู​ก็​เลย​หยุด แล้ว​ฮ้อง​มา​ถาม​ว่า “เจ้า​ต้องก๋าน​หื้อ​เฮา​เยียะ​อะหยัง​หื้อ​กา” ");
INSERT INTO nod_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","คน​ต๋า​บอด​ตอบ​ว่า “องค์​พระผู้เป๋นเจ้า หมู่​เฮา​ใค่​ผ่อ​หัน” ");
INSERT INTO nod_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","พระเยซู​อินดู​เขา ก็​เลย​เอา​มือ​จิ​ตี้​แก่นต๋า​ของ​เขา เขา​ตึง​สอง​ก็​ผ่อ​หัน​บ่า​เดี่ยว​นั้น​เลย แล้ว​เขา​ก็​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","เมื่อ​พระเยซู​กับ​หมู่​สาวก​เข้า​มา​ใก้​กรุง​เยรูซาเล็ม ก็​มา​แผว​หมู่​บ้าน​เบธฟายี​บน​ดอย​บ่ากอกเทศ ก็​ใจ๊​สาวก​สอง​คน​เข้า​ไป​ก่อน ");
INSERT INTO nod_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","สั่ง​ว่า “เข้า​ไป​ใน​หมู่​บ้าน​ตัง​หน้า​หั้น​เน่อ ตันที​ตี้​เข้า​ไป​แล้ว จะ​ปะ​แม่​ลา​กับ​ลูก​ของ​มัน​มัด​อยู่​ตี้​หั้น หื้อ​แก้​เจื้อก​จู๋ง​มา​หื้อ​เฮา​ตึง​สอง​ตั๋ว ");
INSERT INTO nod_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ถ้า​มี​คน​ถาม หื้อ​ตอบ​เขา​ว่า องค์​พระผู้เป๋นเจ้า​ต้องก๋าน​ใจ๊ เขา​ก็​จะ​หื้อ​มา​เลย​ตันที” ");
INSERT INTO nod_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","สิ่ง​ตี้​เกิด​ขึ้น​นี้​ก็​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​อู้​ไว้​ว่า ");
INSERT INTO nod_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“หื้อ​บอก​จาว​เมือง​ศิโยน​ว่า ‘ผ่อ​หั้น​ลอ กษัตริย์​ของ​หมู่​เจ้า​ก่ำลัง​มา​หา​เจ้า​ตังหลาย พระองค์​สุภาพ​อ่อนโยน​ขี่​หลัง​ลา ขี่​หลัง​ลูก​ลา​มา’ ” ");
INSERT INTO nod_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","สาวก​สอง​คน​นั้น​ก็​ไป แล้ว​เยียะ​ต๋าม​ตี้​พระเยซู​สั่ง ");
INSERT INTO nod_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","เขา​จู๋ง​ลา​สอง​ตั๋ว​แม่​ลูก​มา​หื้อ​พระเยซู เอา​เสื้อผ้า​ของ​หมู่​เขา​ปู๋​บน​หลัง​ลา พระองค์​ก็​ขึ้น​ขี่ ");
INSERT INTO nod_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","หมู่​คน​จ๋ำนวน​นัก​ปา​กั๋น​เอา​เสื้อผ้า​ของ​ตั๋ว​ปู๋​บน​หนตาง บาง​คน​ก็​ฟัน​กิ่ง​ไม้​มา​ยาย​ต๋าม​หนตาง​ตวย ");
INSERT INTO nod_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","หมู่​คน​ตี้​เตียว​นำ​หน้า​กับ​เตียว​ตวย​หลัง​พระเยซู ปา​กั๋น​โห่​ฮ้อง​เสียง​ดัง​ว่า “โฮซันนา​แก่​บุตร​ของ​กษัตริย์​ดาวิด ขอ​พระเจ้า​ปั๋น​ปอน​ผู้​ตี้​มา​ใน​นาม​องค์​พระผู้เป๋นเจ้า โฮซันนา​ใน​ตี้​สูงสุด” ");
INSERT INTO nod_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","เมื่อ​พระเยซู​เข้า​ไป​ใน​กรุง​เยรูซาเล็ม คน​ตึง​เมือง​แตกตื่น​ถาม​กั๋น​ว่า “คน​นี้​เป๋น​ใผ​กา” ");
INSERT INTO nod_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","คน​ตังหลาย​ตอบ​ว่า “คน​นี้​จื้อ​เยซู เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​มา​จาก​หมู่​บ้าน​นาซาเร็ธ​ใน​แคว้น​กาลิลี” ");
INSERT INTO nod_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","พระเยซู​เข้า​ไป​ใน​บริเวณ​พระวิหาร แล้ว​ไล่​เหิบ​หมู่​คน​ตี้​ก่ำลัง​ซื้อ​ขาย​ของ​กั๋น​อยู่​ตี้​หั้น กับ​ปึ๊ด​โต๊ะ​ของ​คน​ฮับ​แลก​สตางค์ กับ​ยู้​ตี้​นั่ง​ของ​คน​ขาย​นกก๋าแก๋​ขว้าง​ตวย ");
INSERT INTO nod_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","พระองค์​อู้​กับ​คน​หมู่​นั้น​ว่า “มี​กำ​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘พระวิหาร​ของ​เฮา​จะ​ฮ้อง​ว่า​เป๋น​ตี้​สำหรับ​อธิษฐาน’ แต่​หมู่​เจ้า​มา​เยียะ​หื้อ​ก๋าย​เป๋น​ถ้ำ​ของ​โจ๋ร​เหีย” ");
INSERT INTO nod_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","มี​คน​ต๋า​บอด​กับ​คน​ง่อย​ปา​กั๋น​เข้า​มา​หา​พระเยซู​ตี้​พระวิหาร แล้ว​พระองค์​ฮักษา​หมู่​เขา​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","เมื่อ​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์​หัน​สิ่ง​อัศจ๋รรย์​ต่าง﻿ๆ ตี้​พระเยซู​เยียะ กับ​ได้ยิน​เสียง​หละอ่อน​โห่​เอิ้น​กั๋น​ใน​บริเวณ​พระวิหาร​ว่า “โฮซันนา​แก่​บุตร​ของ​กษัตริย์​ดาวิด”​หมู่​เขา​ก็​ปา​กั๋น​โขด​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","หมู่​เขา​ถาม​พระเยซู​ว่า “ต้าน​บ่﻿ได้ยิน​ตี้​หละอ่อน​หมู่​นี้​โห่​เอิ้น​กั๋น​กา” พระเยซู​ตอบ​ว่า “ได้ยิน​ก่า หมู่​ต้าน​บ่﻿เกย​อ่าน​ปะ​ใน​พระคัมภีร์​พ่อง​กา​ตี้​ว่า ‘พระเจ้า​ได้​เกียม​หละอ่อน กับ​หละอ่อน​เกิด​ใหม่﻿ๆ หื้อ​ฮ้อง​ถวาย​กำ​สรรเสริญ​พระองค์’ ” ");
INSERT INTO nod_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","พระเยซู​ก็​ละ​หมู่​เขา แล้ว​ก็​ออก​จาก​กรุง​เยรูซาเล็ม​ไป​นอน​ตี้​หมู่​บ้าน​เบธานี ");
INSERT INTO nod_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","เมื่อ​แจ้ง​เจ๊า​ต๋อน​พระเยซู​ก่ำลัง​เตียว​ปิ๊ก​เข้า​กรุง​เยรูซาเล็ม พระองค์​อยาก​กิ๋น​ข้าว ");
INSERT INTO nod_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","เมื่อ​พระองค์​หัน​ใส่​เก๊า​บ่าเดื่อ​อยู่​ฮิม​ตาง ก็​เตียว​เข้า​ไป​ใก้ แต่​บ่﻿มี​อะหยัง​บน​เก๊า มี​ก้า​ใบ​เต้าอั้น พระองค์​ก็​บอก​บ่าเดื่อ​เก๊า​นั้น​ว่า “ห้าม​ออก​หน่วย​แหม​ซ้ำ​เน่อ” บ่ากอง​ว่า​หื้อ​แล้ว บ่าเดื่อ​เก๊า​นั้น​ก็​เหี่ยว​แห้ง​ต๋าย​ขำ​หน้า​ขำ​ต๋า ");
INSERT INTO nod_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","เมื่อ​หมู่​สาวก​หัน​ก็​ปา​กั๋น​งืด ถาม​พระเยซู​ว่า “เป๋น​ไป​ได้​จาใด​เก๊า​บ่าเดื่อ​เหี่ยว​แห้ง​ต๋าย​เวย​จาอี้” ");
INSERT INTO nod_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","พระเยซู​ตอบ​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​ต้าน​มี​ความ​เจื้อ บ่﻿อิกขะหลิก​ใจ๋​สัก​หน้อย ต้าน​ก็​จะ​เยียะ​จาอี้​ได้​เหมือน​กั๋น จะ​เยียะ​ได้​นัก​เหลือ​นี้​แหม​ตวย บ่﻿ว่า​จะ​สั่ง​ดอย​ม่อน​นี้​ย้าย​ลง​ไป​ใน​ทะเล​เหีย ก็​จะ​เป๋น​ไป​จาอั้น ");
INSERT INTO nod_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ถ้า​ต้าน​เจื้อ ต้าน​ก็​จะ​ได้​ฮับ​กู้​อย่าง​ต๋าม​ตี้​ต้าน​อธิษฐาน​ขอ” ");
INSERT INTO nod_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","พระเยซู​เข้า​ไป​ใน​บริเวณ​พระวิหาร ต๋อน​ตี้​ก่ำลัง​สอน​อยู่​นั้น หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​เข้า​มา​ถาม​พระองค์​ว่า “ต้าน​มี​สิทธิ​อำนาจ​อะหยัง​เยียะ​สิ่ง​หมู่​นี้ ใผ​หื้อ​สิทธิ​อำนาจ​ต้าน” ");
INSERT INTO nod_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","พระเยซู​ตอบ​ว่า “เฮา​จะ​ถาม​หมู่​ต้าน​สัก​ข้อ​นึ่ง​ก่อน ถ้า​หมู่​ต้าน​ตอบ​เฮา เฮา​เถิง​จะ​บอก​ว่า​เฮา​ใจ๊​สิทธิ​อำนาจ​ของ​ใผ​มา​เยียะ​สิ่ง​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ลอง​ตอบ​เฮา​มา​กำ​ลอ​ว่า สิทธิ​อำนาจ​ของ​ยอห์น​ตี้​เขา​หื้อ​บัพติศมา​นั้น​มา​จาก​ไหน มา​จาก​พระเจ้า​กาว่า​มา​จาก​คน” หมู่​เขา​ก็​เปิ็กษา​กั๋น​ว่า “ถ้า​หมู่​เฮา​จะ​ว่า ‘มา​จาก​พระเจ้า’ ต้าน​ก็​จะ​ย้อน​ถาม​หมู่​เฮา​แหม​ว่า ‘แล้ว​เป๋น​จาใด​บ่﻿เจื้อ​ยอห์น’ ");
INSERT INTO nod_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","แต่​ถ้า​หมู่​เฮา​จะ​ว่า ‘มา​จาก​คน’ ก็​กั๋ว​คน​ตังหลาย​จะ​โขด ย้อน​ว่า​คน​ตังหลาย​ปา​กั๋น​เจื้อ​ว่า​ยอห์น​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","หมู่​เขา​ก็​เลย​ตอบ​พระองค์​ว่า “หมู่​เฮา​บ่﻿ฮู้​เน่อ” พระเยซู​ก็​บอก​หมู่​เขา​ว่า “ถ้า​จาอั้น เฮา​ก็​จะ​บ่﻿บอก​เหมือน​กั๋น​ว่า เฮา​ใจ๊​สิทธิ​อำนาจ​ของ​ใผ​เยียะ​สิ่ง​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“บอก​กำ​ลอ​ว่า หมู่​ต้าน​กึ๊ด​จาใด​เกี่ยว​กับ​เรื่อง​ตี้​จะ​เล่า​ต่อ​ไป​นี้ คือ​ป้อจาย​คน​นึ่ง​มี​ลูก​บ่าว​สอง​คน เขา​บอก​ลูก​บ่าว​คน​เก๊า​ว่า ‘ลูก​ป้อ วัน​นี้​ไป​เยียะ​ก๋าน​ใน​สวน​องุ่น​ของ​ป้อ​กำ​เน่อ’ ");
INSERT INTO nod_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“ลูก​บ่าว​คน​เก๊า​ตอบ​ว่า ‘อึ บ่﻿ไป’ แต่​เมื่อลูน​เขา​เปี่ยนใจ๋​ไป ");
INSERT INTO nod_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“จาก​นั้น​ป้อ​ก็​ไป​บอก​ลูก​บ่าว​คน​หล้า​เหมือน​กั๋น​ว่า ‘ลูก​ป้อ วัน​นี้​ไป​เยียะ​ก๋าน​ใน​สวน​องุ่น​ของ​ป้อ​กำ​เน่อ’ ลูก​บ่าว​คน​หล้า​ตอบ​ว่า ‘ตกลง​ครับ ผม​จะ​ไป​เยียะ’ แต่​เขา​ก็​บ่﻿ได้​ไป​เยียะ​สัก​กำ ");
INSERT INTO nod_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“ขอ​ถาม​ว่า ลูก​บ่าว​สอง​คน​นี้ คน​ใด​ตี้​เจื้อ​ฟัง​เยียะ​ต๋าม​กำ​สั่ง​ของ​ป้อ” หมู่​เขา​ตอบ​ว่า “ลูก​บ่าว​คน​เก๊า” พระเยซู​ก็​บอก​หมู่​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​เก็บ​ภาษี​กับ​แม่ญิง​ขาย​ตั๋ว จะ​ได้​เข้า​ใน​แผ่นดิน​สวรรค์​ก่อน​หมู่​ต้าน​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ย้อน​ว่า​ยอห์น​ได้​มา​จี๊​ตาง​หื้อ​หัน​ว่า​จะ​ใจ๊​จีวิต​อย่าง​ถูกต้อง​ต๋าม​ธรรม​ได้​จาใด หมู่​ต้าน​ก็​บ่﻿ยอม​เจื้อ​ยอห์น แต่​คน​เก็บ​ภาษี​กับ​แม่ญิง​ขาย​ตั๋ว​ได้​เจื้อ​ยอห์น เถิง​แม้​ต้าน​ตังหลาย​ได้​หัน​สิ่ง​หมู่​นี้​แล้ว แต่​ก็​ยัง​บ่﻿ยอม​กลับใจ๋​จาก​บาป​มา​เจื้อ​ยอห์น​เลย ");
INSERT INTO nod_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ฟัง​กำเผียบ​ตี้​จะ​เล่า​นี้​หื้อ​ดี เรื่อง​มี​อยู่​ว่า เจ้า​ของ​สวน​คน​นึ่ง​เยียะ​สวน​องุ่น เขา​ล้อม​ฮั้ว​แวด​สวน​ไว้​หมด เจาะ​หิน​แป๋ง​เป๋น​บ่อ​ย่ำ​องุ่น กับ​แป๋ง​ป้อม​สำหรับ​เฝ้า​สวน​ไว้ แล้ว​หื้อ​คน​มา​เจ้า ส่วน​เจ้าของ​ก็​เตียวตาง​ไป​อยู่​ต่าง​ประเทศ ");
INSERT INTO nod_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","เมื่อ​เถิง​หน้า​เก็บ​หน่วย​องุ่น เจ้าของ​สวน​ก็​หื้อ​ลูกจ้าง​ไป​หา​หมู่​คน​เจ้า เปื้อ​ฮับ​ส่วน​แบ่ง​องุ่น​ตี้​เป๋น​ส่วน​แบ่ง​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“แต่​หมู่​คน​เจ้า​ก็​ยับ​ลูกจ้าง​หมู่​นั้น​ไว้ แล้ว​ปา​กั๋น​บุบ​ตี๋​คน​นึ่ง ฆ่า​เหีย​คน​นึ่ง กับ​เอา​บ่าหิน​ขว้าง​คน​ตี้​สาม​จ๋น​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","เจ้าของ​สวน​ก็​ส่ง​หมู่​ลูกจ้าง​มา​หา​แหม​จ๋ำนวน​นัก​เหลือ​เตื้อ​ตี้​แล้ว แต่​ก็​ถูก​หมู่​คน​เจ้า​สวน​ปา​กั๋น​เยียะ​จาอั้น​แหม ");
INSERT INTO nod_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","สุดต๊าย​เจ้าของ​สวน​ส่ง​ลูกบ่าว​ของ​เขา​ไป เจ้า​ของ​สวน​อู้​ว่า ‘คน​เจ้า​หมู่​นั้น​ก็​จะ​นับถือ​ลูก​บ่าว​ของ​เฮา​พ่อง’ ");
INSERT INTO nod_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“แต่​เมื่อ​หมู่​คน​เจ้า​หัน​ใส่​ลูก​บ่าว​เจ้าของ​สวน​มา ก็​อู้​กั๋น​ว่า ‘นี่​ลอ คน​ตี้​จะ​ฮับ​มรดก หมู่​เฮา​จ้วย​กั๋น​ฆ่า​มัน​เหีย​เต๊อะ แล้ว​มรดก​นั้น​จะ​ตก​เป๋น​ของ​หมู่​เฮา’ ");
INSERT INTO nod_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","หมู่​เขา​ก็​ยับ​ลูก​บ่าว​เจ้าของ​สวน​นั้น อุ้ม​โจ้ง​ออก​ไป​นอก​สวน​แล้ว​ก็​ฆ่า ");
INSERT INTO nod_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","เมื่อ​เจ้า​ของ​สวน​ปิ๊ก​มา​เขา​จะ​เยียะ​จาใด​กับ​คน​เจ้า​หมู่​นี้” ");
INSERT INTO nod_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","หมู่​หัวหน้า​ปุโรหิต​กับ​คน​เฒ่า​คน​แก่​ตอบ​ว่า “เจ้า​ของ​สวน​จะ​ฆ่า​คน​บ่﻿ดี​หมู่​นั้น​หื้อ​ต๋าย​อย่าง​ตุ๊ก​ทรมาน แล้ว​ก็​หื้อ​คน​ตี้​ยอม​แบ่ง​องุ่น​หื้อ​กับ​เจ้า​ของ​สวน​เมื่อ​เถิง​หน้า​เก็บ​หน่วย​เจ้า​ต่อ” ");
INSERT INTO nod_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","พระเยซู​บอก​หมู่​เขา​ว่า “หมู่​ต้าน​บ่﻿เกย​อ่าน​พระคัมภีร์​ข้อ​นี้​กา​ตี้​ว่า ‘ศิลา​ตี้​สล่า​แป๋ง​เฮือน​เอา​ขว้าง​ไป​แล้ว​นั้น ป๋ากฏ​ว่า​เป๋น​ศิลามุมเอก สิ่ง​นี้​มา​จาก​องค์​พระผู้เป๋นเจ้า ตี้​หมู่​เฮา​หัน​กับ​ต๋า ก็​งืด​แต๊﻿ๆ’ ");
INSERT INTO nod_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","เฮา​จะ​บอก​หื้อ​ฮู้​ว่า แผ่นดิน​ของ​พระเจ้า​จะ​ถูก​ยึด​เอา​ไป​จาก​หมู่​ต้าน แล้ว​ก็​ยก​หื้อ​กับ​คน​ตี้​เยียะ​ต๋าม​กำสั่ง​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","คน​ใด​ก็​ต๋าม​ตี้​โก้น​เต๋ง​บ่าหิน​ก้อน​นี้ เขา​ก็​จะ​แหลว​เป๋น​บ่าหลิ่น​ติ่น​ต่อน ถ้า​บ่าหิน​ก้อน​นี้​ตก​เต๋ง​ใส่​ใผ คน​นั้น​ก็​จะ​แหลว​ไป​เลย” ");
INSERT INTO nod_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","เมื่อ​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ฟาริสี​ได้ยิน​กำเผียบ​เรื่อง​นี้​ของ​พระเยซู ก็​ฮู้​ว่า​พระองค์​ก่ำลัง​อู้​เถิง​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","หมู่​เขา​ก็​ปา​กั๋น​หา​ตาง​ตี้​จะ​ยับ​พระองค์ แต่​ก็​กั๋ว​คน​ตังหลาย ย้อน​ว่า​มี​คน​จ๋ำนวน​นัก​เจื้อ​ว่า​พระเยซู​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","พระเยซู​เล่า​เรื่อง​เป๋น​กำเผียบ​หื้อ​หมู่​เขา​ฟัง​แหม​ว่า ");
INSERT INTO nod_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“แผ่นดิน​สวรรค์​เผียบ​เหมือน​กษัตริย์​ตี้​ได้​จัด​งาน​เลี้ยง​ฉลอง​แต่งงาน​หื้อ​ลูกบ่าว​ของ​ต้าน ");
INSERT INTO nod_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","เมื่อ​เกียม​เสร็จ​แล้ว กษัตริย์​ส่ง​คน​ฮับใจ๊​ไป​ฮ้อง​แขก​ตี้​เจิญ​ไว้​หื้อ​มา​งาน​ได้​แล้ว แต่​ก็​บ่﻿มี​ใผ​ยอม​มา ");
INSERT INTO nod_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","กษัตริย์​ก็​ส่ง​คน​ฮับใจ๊​คน​อื่น​ไป​ฮ้อง​แหม สั่ง​หื้อ​บอก​จาอี้​ว่า ‘เฮา​ได้​ฆ่า​หมู่​งัว​ตั๋ว​ตุ้ย﻿ๆ ไว้ กู้​อย่าง​พร้อม​แล้ว หื้อ​มา​งาน​เลี้ยง​ฉลอง​ก๋าน​แต่งงาน​นี้​ได้​เลย’ ");
INSERT INTO nod_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“แต่​บ่﻿มี​ใผ​สนใจ๋​สัก​คน ต่าง​คน​ต่าง​ไป​เยียะ​ก๋าน​ของ​ตั๋ว​เหีย คน​นึ่ง​ไป​เยียะ​ไฮ่​เยียะ​นา แหม​คน​นึ่ง​ก็​ไป​ก๊า​ขาย​เหีย ");
INSERT INTO nod_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","คน​อื่น﻿ๆ ก็​ยับ​หมู่​คน​ฮับใจ๊​ตี้​มา​บอก​นั้น​แล้ว​บุบ​ฆ่า​เหีย ");
INSERT INTO nod_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","กษัตริย์​โขด​ขนาด เลย​ส่ง​ก๋อง​ทัพ​มา​ฆ่า​ฆาตกร​หมู่​นั้น แล้ว​เผา​เมือง​ของ​หมู่​เขา​ตวย ");
INSERT INTO nod_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“กษัตริย์​อู้​กับ​คน​ฮับใจ๊​ของ​พระองค์​ว่า ‘งาน​เลี้ยง​ฉลอง​ก๋าน​แต่งงาน​ก็​เกียม​ไว้​พร้อม​แล้ว แต่​แขก​ตี้​เฮา​ได้​เจิญ​ไว้​นั้น​บ่﻿เปิง​ตี้​จะ​มา​ใน​งาน​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","หื้อ​ออก​ไป​ต๋าม​กู้​ฮ่อม​ตาง​เตียว เมื่อ​ปะ​ใผ​ก็​เจิญ​มา​ใน​งาน​นี้​หื้อ​หมด ");
INSERT INTO nod_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","แล้ว​หมู่​คน​ฮับใจ๊​ออก​ไป​ต๋าม​หนตาง แล้ว​ก็​เจิญ​กู้​คน​ตี้​หมู่​เขา​ปะ ตึง​คน​ดี​ตึง​คน​บ่﻿ดี​แล้ว​ปา​มา จ๋น​ใน​ตี้​สุด​ห้อง​ฮับ​แขก​ก็​มี​คน​มา​เต๋ม​ห้อง ");
INSERT INTO nod_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“เมื่อ​กษัตริย์​เข้า​มา​ผ่อ​แขก​ตี้​มา ก็​หัน​ใส่​ป้อจาย​คน​นึ่ง​แต่งตั๋ว​บ่﻿เปิง​กับ​งาน​แต่งงาน ");
INSERT INTO nod_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","พระองค์​ก็​อู้​ว่า ‘เปื้อน​เหย เข้า​มา​ตี้​นี่​ได้​จาใด เสื้อ​คุม​สำหรับ​งาน​แต่ง​ก็​บ่﻿มี’ ป้อจาย​นั้น​ก็​ปาก​บ่﻿ออก ");
INSERT INTO nod_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","กษัตริย์​ก็​สั่ง​หมู่​คน​ฮับใจ๊​ว่า ‘มัด​ตี๋น​มัด​มือ​คน​นี้ แล้ว​โจ้ง​ออก​ไป​ตัง​นอก ตั๊ด​ตี้​มืด​ตี้​มี​เสียง​คน​ไห้​หุย​ขบ​เขี้ยว​เกี๊ยว​กาง​อย่าง​เจ็บปวด’ ” ");
INSERT INTO nod_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","พระเยซู​ก็​สรุป​ว่า “มี​หลาย​คน​ตี้​ได้ฮับ​เจิญ​มา แต่​มี​คน​หน้อย​ตี้​จะ​ถูก​เลือก​ไว้” ");
INSERT INTO nod_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","หมู่​ฟาริสี​ก็​ออก​ไป​วางแผน​หา​ตาง​เอา​ผิด​กำ​อู้​ของ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","หมู่​เขา​ก็​เลย​ส่ง​สาวก​ของ​ตั๋ว กับ​หมู่​ตี้​สนับ​สนุน​เฮโรด ไป​ถาม​พระเยซู​ว่า “อาจ๋ารย์ หมู่​เฮา​ฮู้​ว่า​อาจ๋ารย์​เป๋น​คน​สัตย์ซื่อ สอน​เรื่อง​ตาง​ของ​พระเจ้า​ต๋าม​ความ​จริง​โดย​บ่﻿ได้​เอาใจ๋​ใผ ย้อน​อาจ๋ารย์​บ่﻿หันแก่​หน้า​ใผ​เลย ");
INSERT INTO nod_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ถ้า​จาอั้น​จ้วย​บอก​หมู่​เฮา​กำ​ลอ​ว่า อาจ๋ารย์​กึ๊ด​ว่า​จาใด ตี้​จะ​เสีย​ภาษี​หื้อ​ซีซาร์ เฮา​ควร​จะ​เสีย​ดี​กาว่า​บ่﻿ควร​เสีย​ดี” ");
INSERT INTO nod_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","แต่​พระเยซู​ฮู้​กำกึ๊ด​ฮ้าย​ของ​หมู่​เขา พระองค์​เลย​อู้​ย้อน​ไป​ว่า “หมู่​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ต้าน​จะ​มา​จับ​ผิด​เฮา​เยียะ​หยัง ");
INSERT INTO nod_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","เอา​เหรียญ​ตี้​ใจ๊​เสีย​ภาษี​มา​หื้อ​เฮา​ผ่อ​ลอ” หมู่​เขา​ก็​ยื่น​เหรียญ​เดนาริอัน​เหรียญ​นึ่ง​หื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","พระเยซู​ถาม​หมู่​เขา​ว่า “ฮูป​กับ​จื้อ​ตี้​อยู่​บน​เหรียญ​นี้​เป๋น​ของ​ใผ” ");
INSERT INTO nod_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","หมู่​เขา​ตอบ​ว่า “เป๋น​ของ​ซีซาร์” พระเยซู​ก็​บอก​หมู่​เขา​ว่า “ของ​ของ​ซีซาร์​ก็​เอา​ไป​หื้อ​ซีซาร์ แต่​ของ​ของ​พระเจ้า​ก็​หื้อ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","เมื่อ​ได้ยิน​จาอั้น​หมู่​เขา​ก็​งืด แล้ว​ละ​พระองค์​ไว้​ปา​กั๋น​ออก​ไป ");
INSERT INTO nod_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ใน​วัน​นั้น สะดูสี​บาง​คน​มา​หา​พระเยซู คน​หมู่​นี้​ถือ​ว่า​บ่﻿มี​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย หมู่​เขา​ถาม​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“อาจ๋ารย์ บท​บัญญัติ​ของ​โมเสส​เขียน​ไว้​ว่า ‘ถ้า​ป้อจาย​คน​ใด​ต๋าย แต่​ยัง​บ่﻿ตัน​มี​ลูก​เตื้อ น้องบ่าว​เขา​ก็​ต้อง​ฮับ​เอา​ปี้​ใป๊​มา​เป๋น​เมีย​เหีย กับ​หื้อ​มี​ลูก​สืบ​เจื๊อสาย​ของ​อ้าย​ไว้’ ");
INSERT INTO nod_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","สมมุติ​ว่า ใน​หมู่​เฮา​นี้​มี​ป้อจาย​ตี้​เป๋น​ปี้น้อง​กั๋น​เจ็ด​คน อ้าย​เก๊า​แต่งงาน​ยัง​บ่﻿ตัน​มี​ลูก​ก็​ต๋าย​ไป​เหีย น้องบ่าว​คน​ถัด​มา​ฮับ​นาง​มา​เป๋น​เมีย​ต่อ ");
INSERT INTO nod_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","น้องบ่าว​คน​ตี้​สอง​ก็​ต๋าย​บ่﻿มี​ลูก​เหมือน​กั๋น แล้ว​ก็​เป๋น​อย่าง​เดียว​กั๋น​กับ​น้องบ่าว​คน​ตี้​สาม​จ๋น​เถิง​คน​ตี้​เจ็ด​ตี้​ต้อง​ฮับ​เอา​ปี้ใป๊​มา​เป๋น​เมีย​ต่อ﻿ๆ กั๋น​มา ");
INSERT INTO nod_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","แล้ว​สุดต๊าย​แม่ญิง​คน​นั้น​ก็​ต๋าย​ตวย ");
INSERT INTO nod_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","เมื่อ​เถิง​วัน​ตี้​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น แม่ญิง​คน​นี้​จะ​เป๋น​เมีย​ของ​ใผ ย้อน​ว่า​ตึง​เจ็ด​คน​นั้น​ก็​เกย​เป๋น​ผัว​ของ​นาง​มา​หมด​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","พระเยซู​ตอบ​หมู่​เขา​ว่า “หมู่​ต้าน​เข้าใจ๋​ผิด​แล้ว ย้อน​ว่า​หมู่​ต้าน​บ่﻿เข้าใจ๋​พระคัมภีร์​กับ​บ่﻿ฮู้จัก​ฤทธิ์​อำนาจ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","เมื่อ​เถิง​วัน​ตี้​กู้​คน​เป๋น​ขึ้น​จาก​ความ​ต๋าย จะ​บ่﻿แต่งงาน​กั๋น กาว่า​ยก​หื้อ​เป๋น​ผัว​เป๋น​เมีย​กั๋น​แหม แต่​จะ​เป๋น​เหมือน​ทูตสวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ส่วน​เรื่อง​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น หมู่​ต้าน​บ่﻿เกย​อ่าน​กา ตี้​พระเจ้า​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘เฮา​เป๋น​พระเจ้า​ตี้​อับราฮัม อิสอัค กับ​ยาโคบ​นับถือ’ พระองค์​บ่﻿เป๋น​พระเจ้า​ของ​คน​ต๋าย แต่​เป๋น​พระเจ้า​ของ​คน​ตี้​มี​จีวิต” ");
INSERT INTO nod_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","เมื่อ​คน​ตังหลาย​ได้ยิน​จาอี้​ก็​ปา​กั๋น​งืด​ใน​กำสอน​ของ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","เมื่อ​หมู่​ฟาริสี​ได้ยิน​ว่า​หมู่​สะดูสี​จับ​ผิด​ใน​กำ​อู้​พระเยซู​บ่﻿ได้ หมู่​เขา​ก็​มา​จุมนุม​กั๋น​เปื้อ​ถาม​พระเยซู​แหม​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","มี​ผู้​ชำนาญ​บท​บัญญัติ​คน​นึ่ง ลองเจิง​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“อาจ๋ารย์ ใน​บท​บัญญัติ​ตึง​หมด ข้อ​ใด​สำคัญ​เหลือ​เปิ้น” ");
INSERT INTO nod_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","พระเยซู​ตอบ​ว่า “ ‘จง​ฮัก​องค์​พระ​ผู้​เป๋น​เจ้า พระเจ้า​ของ​ต้าน​จ๋น​สุด​จิต​สุด​ใจ๋​กับ​สุด​ผญา​ปั๋ญญา​ของ​เจ้า’ ");
INSERT INTO nod_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","คือ​เป๋น​บท​บัญญัติ​ข้อ​เก๊า กับ​เป๋น​ข้อ​ตี้​สำคัญ​ตี้​สุด ");
INSERT INTO nod_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ส่วน​ข้อ​สอง​ตี้​สำคัญ​ปอ﻿ๆ กั๋น​คือ ‘จง​ฮัก​เปื้อน​บ้าน​เหมือน​ฮัก​ตั๋ว​เก่า’ ");
INSERT INTO nod_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","บท​บัญญัติ​กับ​หนังสือ​ของ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตี้​ได้​เขียน​ไว้ ก็​ขึ้น​อยู่​กับ​บท​บัญญัติ​สอง​ข้อ​นี้” ");
INSERT INTO nod_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ต๋อน​ตี้​หมู่​ฟาริสี​มา​จุมนุม​กั๋น​อยู่​ตี้​หั้น พระเยซู​ได้​ถาม​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“หมู่​ต้าน​กึ๊ด​จาใด​พ่อง​เรื่อง​เกี่ยว​กับ​พระคริสต์ ต้าน​เป๋น​เจื๊อสาย​ของ​ใผ” หมู่​ฟาริสี​ตอบ​ว่า “เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด” ");
INSERT INTO nod_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","พระเยซู​ถาม​ต่อ​ว่า “แล้ว​เป๋น​จาใด​เมื่อ​กษัตริย์​ดาวิด​อู้​โดย​พระวิญญาณ​บริสุทธิ์​นั้น จึง​ฮ้อง​พระคริสต์​ว่า ‘องค์​พระผู้เป๋นเจ้า’ ย้อน​กษัตริย์​ดาวิด​ได้​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘พระเจ้า​อู้​กับ​องค์​พระผู้เป๋นเจ้า​ของ​ข้าพเจ้า​ว่า “หื้อ​นั่ง​ตัง​ขวา​มือ​ของ​เฮา จ๋น​เต๊า​ฮอด​เฮา​จะ​เยียะ​หื้อ​ศัตรู๋​ของ​ต้าน อยู่​ลุ่ม​ปื๊น​ตี๋น​ของ​ต้าน” ’ ");
INSERT INTO nod_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ใน​เมื่อ​กษัตริย์​ดาวิด​ฮ้อง​พระองค์​ว่า ‘องค์​พระผู้เป๋นเจ้า’ แล้ว​พระองค์​จะ​เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด​ได้​จาใด” ");
INSERT INTO nod_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","บ่﻿มี​ใผ​ตอบ​พระเยซู​ได้​สัก​คน นับ​ตั้งแต่​วัน​นั้น​เป๋น​ต้น​มา​ก็​บ่﻿มี​ใผ​ก้า​เข้า​มา​ถาม​อะหยัง​พระองค์​แหม​เลย ");
INSERT INTO nod_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","พระเยซู​อู้​กับ​คน​ตังหลาย​ตึง​หมู่​สาวก​ของ​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี​มี​อำนาจ​ตี้​จะ​สอน​ต้าน​ตังหลาย​เรื่อง​บท​บัญญัติ​ของ​โมเสส ");
INSERT INTO nod_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","อะหยัง​ตี้​เขา​สอน ก็​หื้อ​เจื้อ​ฟัง​กับ​เยียะ​ตวย​ต๋าม​กำสอน​นั้น แต่​สิ่ง​ตี้​หมู่​เขา​เยียะ ห้าม​เยียะ​ตวย​เน่อ ย้อน​ว่า​คน​หมู่​นี้​สอน​อย่าง​นึ่ง แต่​เยียะ​แหม​อย่าง​นึ่ง ");
INSERT INTO nod_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","เขา​ตั้ง​กฎ​ตี้​ยาก﻿ๆ หื้อ​คน​ตังหลาย​ยึด​ถือ เผียบ​เหมือน​หมู่​เขา​เอา​ของ​หนัก﻿ๆ หื้อ​คน​อื่น​แบก​ไว้ แต่​หมู่​เขา​ก็​บ่﻿ยอม​จ้วย​จิ​สัก​หน้อย ");
INSERT INTO nod_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“เขา​ฮิ​เยียะ​กู้​อย่าง​เปื้อ​อวด​คน​เต้าอั้น เขา​แป๋ง​แอ็บ​ใส่​ข้อ​พระคัมภีร์​แก่น​ใหญ่​เหลือ​เปิ้น​มัด​ตี้​ตั๋ว แล้ว​ใส่​เสื้อ​คุม​ตี้​มี​พู่​ห้อย​ยาว​เหลือ​เปิ้น ");
INSERT INTO nod_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","เขา​ซอบ​นั่ง​ตั๊ด​ตี้​มี​เกียรติ​ใน​งาน​เลี้ยง กับ​ตี้​สำคัญ​ใน​ธรรมศาลา​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","หมู่​เขา​ซอบ​หื้อ​คน​ไหว้​ก๋าง​กาด​ก๋าง​ลี กับ​ซอบ​หื้อ​คน​ตังหลาย​ฮ้อง​เขา​ว่า ‘อาจ๋ารย์’ ");
INSERT INTO nod_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“แต่​ห้าม​หื้อ​คน​อื่น​ฮ้อง​หมู่​ต้าน​ว่า ‘อาจ๋ารย์’ ย้อน​ว่า​ต้าน​ตังหลาย​มี​อาจ๋ารย์​คน​เดียว กับ​หมู่​ต้าน​ก็​เป๋น​ปี้น้อง​กั๋น​ตึงหมด ");
INSERT INTO nod_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ห้าม​ฮ้อง​คน​บน​โลก​นี้​ว่า ‘พระบิดา’ ย้อน​ว่า​ต้าน​ตังหลาย​มี​พระบิดา​องค์​เดียว​ตี้​อยู่​ใน​สวรรค์​คือ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ห้าม​หื้อ​คน​ใด​ฮ้อง​ต้าน​ตังหลาย​ว่า ‘เจ้านาย’ ย้อน​ว่า​ต้าน​ตังหลาย​มี​เจ้านาย​คน​เดียว​คือ​พระคริสต์ ");
INSERT INTO nod_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ใน​หมู่​ต้าน​คน​ตี้​เป๋น​ใหญ่​เหลือ​เปิ้น จะ​ต้อง​เป๋น​คน​ตี้​ฮับใจ๊​ต้าน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","คน​ตี้​ยก​ตั๋ว​ขึ้น คน​นั้น​จะ​ถูก​เต็ก​หื้อ​ต่ำ​ลง ส่วน​คน​ตี้​ถ่อม​ตั๋ว​ลง ก็​จะ​ได้ฮับ​ก๋าน​ยก​ขึ้น ");
INSERT INTO nod_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี ย้อน​ว่า​หมู่​เจ้า​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด หมู่​เจ้า​ได้​กีด​กั๋น​คน​อื่น​บ่﻿หื้อ​ไป​แผว​แผ่นดิน​สวรรค์ เซิ่ง​หมู่​เจ้า​ก็​บ่﻿ยอม​เข้า​ไป เมื่อ​คน​อื่น​ฮิ​จะ​เข้า​ไป หมู่​เจ้า​เอง​ก็​ขวาง​ไว้​เหีย​ ");
INSERT INTO nod_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี เจ้า​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ตี้​ต้อง​ฮับ​ความ​ตุ๊ก หมู่​เจ้า​ยอม​ข้าม​น้ำ​ข้าม​ทะเล เปื้อ​เซาะ​หา​คน​ก้า​คน​เดียว​หื้อ​เข้า​ฮีต​ศาสนา​ยิว เมื่อ​เข้า​ฮีต​แล้ว ก็​เยียะ​หื้อ​เขา​สมควร​ตี้​จะ​ตก​หม้อหน้าฮก​นัก​เหลือ​เจ้า​ตังหลาย​แหม​สอง​เต้า ");
INSERT INTO nod_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​คน​นำ​ตาง​ตี้​ต๋า​บอด ตี้​ต้อง​ฮับ​ความ​ตุ๊ก หมู่​เจ้า​สอน​ว่า ‘ถ้า​คน​ใด​ก็​ต๋าม​เมื่อ​สาบาน​โดย​อ้าง​พระวิหาร ก็​บ่﻿มี​ความหมาย​อะหยัง แต่​ถ้า​คน​ใด​สาบาน​อ้าง​คำ​ของ​พระวิหาร เขา​จะ​ต้อง​เยียะ​ตวย​กำ​สาบาน​ตี้​ได้​อ้าง​แล้ว​นั้น​หื้อ​ได้’ ");
INSERT INTO nod_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","หมู่​คน​ง่าว​ป๋าย​บ่﻿ปอ​ต๋า​บอด​แหม อัน​ไหน​สำคัญ​เหลือ​กั๋น คำ​ใน​พระวิหาร​กาว่า​พระวิหาร​ตี้​เยียะ​หื้อ​คำ​นั้น​เป๋น​สิ่ง​ศักดิ์สิทธิ์ ");
INSERT INTO nod_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","หมู่​เจ้า​ยัง​อู้​แหม​ว่า ‘ถ้า​คน​ใด​ก็​ต๋าม​สาบาน​โดย​อ้าง​แต้น​ปู่จา ก็​บ่﻿มี​ความหมาย​อะหยัง แต่​ถ้า​คน​ใด​สาบาน​โดย​อ้าง​เครื่อง​ปู่จา​บน​แต้น​ปู่จา​นั้น เขา​จะ​ต้อง​เยียะ​ตวย​กำ​สาบาน​ตี้​ได้​ว่า​นั้น​หื้อ​ได้’ ");
INSERT INTO nod_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","เจ้า​คน​ต๋า​บอด​แต๊﻿ๆ อะหยัง​สำคัญ​เหลือ​กั๋น เครื่อง​ปู่จา​กาว่า​แต้น​ปู่จา อัน​ใด​ตี้​เยียะ​หื้อ​เครื่อง​ปู่จา​นั้น​ศักดิ์สิทธิ์ ");
INSERT INTO nod_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ย้อน​จาอี้​ใผ​ก็​ต๋าม​ตี้​สาบาน​โดย​อ้าง​แต้น​ปู่จา เขา​ก็​สาบาน​โดย​อ้าง​แต้น​ปู่จา​ตึง​เครื่องปู่จา​กู้​อย่าง​ตี้​อยู่​บน​แต้น​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","คน​ตี้​สาบาน​โดย​อ้าง​พระวิหาร เขา​ก็​สาบาน​โดย​อ้าง​พระวิหาร​ผด​แผว​พระเจ้า​ผู้​ตี้​อยู่​ใน​พระวิหาร​ตวย ");
INSERT INTO nod_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","กับ​คน​ตี้​สาบาน​โดย​อ้าง​สวรรค์ ก็​สาบาน​โดย​อ้าง​บัลลังก์​ของ​พระเจ้า​ตึง​พระองค์​ตี้​นั่ง​อยู่​บน​บัลลังก์​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี เจ้า​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ย้อน​หมู่​เจ้า​ถวาย​สิบลด​จาก​หอมด่วน เม็ด​ผักจี กับ​ยี่หร่า แต่​สิ่ง​ตี้​สำคัญ​เหลือ​นั้น​ใน​บท​บัญญัติ คือ​ความ​ยุติธรรม ความ​เมตต๋า กับ​ความ​ซื่อสัตย์​ก็​ละเลย​เหีย ส่วน​ก๋าน​ถวาย​สิบลด เจ้า​ก็​ควร​เยียะ​อยู่ แต่​บ่﻿ดี​ละ​สิ่ง​สำคัญ​หมู่​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","คน​นำ​ตาง​ตี้​ต๋า​บอด หมู่​เจ้า​กรอง​แมง​ตั๋ว​หน้อย﻿ๆ ออก​จาก​น้ำ​กิ๋น แต่​ลืน​อูฐ​เข้า​ไป​ตึง​ตั๋ว ");
INSERT INTO nod_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี เจ้า​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด หมู่​เจ้า​ล้าง​ถ้วย​จาน​ก้า​ตัง​นอก​เต้าอั้น แต่​ตัง​ใน​นั้น​มี​ก้า​ความ​โลภ​กับ​ความ​มัว​เมา​ใน​กิเลส​เต๋ม​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","หมู่​ฟาริสี​ต๋า​บอด หื้อ​หมู่​เจ้า​ล้าง​ตัง​ใน​ถ้วย​จาน​หื้อ​สะอาด​เหีย​ก่อน แล้ว​ตัง​นอก​ก็​จะ​สะอาด​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี เจ้า​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ย้อน​หมู่​เจ้า​เผียบ​เหมือน​อุโมงค์​ฝัง​ศพ​ตี้​ตา​สี​ขาว ตัง​นอก​ผ่อ​งาม​แต๊﻿ๆ แต่​ตัง​ใน​มี​ก้า​กระดูก​คน​ต๋าย​กับ​สิ่ง​ตี้​เป๋น​มลทิน​กู้​อย่าง​เต๋ม​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","เหมือน​กับ​หมู่​เจ้า ตี้​หื้อ​คน​หัน​ว่า​เป๋น​คน​เยียะ​สิ่ง​ตี้​ถูกต้อง​ต๋าม​ธรรม แต่​แต๊﻿ๆ ใน​ตั๋ว​เจ้า​มี​ความ​หน้า​ซื่อ​ใจ๋​ก๊ด​กับ​ความ​บ่﻿ดี​เต๋ม​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี เจ้า​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ย้อน​หมู่​เจ้า​ได้​แป๋ง​อุโมงค์​ฝัง​ศพ​ตี้​เปิง​กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า แล้ว​แต่ง​หย้อง​หลุม​ฝัง​ศพ​ของ​คน​หมู่​ตี้​เยียะ​ถูกต้อง​ต๋าม​ธรรม ");
INSERT INTO nod_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","หมู่​เจ้า​ก็​อู้​ว่า ‘ถ้า​เฮา​อยู่​ใน​สมัย​ป้อ​อุ๊ย​แม่​หม่อน​ของ​เฮา​นั้น เฮา​จะ​บ่﻿ยอม​ฮ่วม​มือ​กับ​เขา ตี้​ฆ่า​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​หมู่​นี้​แน่﻿ๆ’ ");
INSERT INTO nod_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","เป๋น​ก๋าน​แสดง​หื้อ​หัน​ว่า​หมู่​เจ้า​ยอมฮับ​ว่า ตั๋ว​เก่า​เป๋น​ลูก​หลาน​ของ​คน​หมู่​นั้น ตี้​ฆ่า​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ย้อน​จาอั้น หื้อ​เยียะ​บาป​ตี้​ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​เจ้า​ได้​ตั้งเก๊า​เยียะ​ไว้​หื้อ​เสร็จ​เหีย​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“หมู่​จ้าด​งู หมู่​จ้าด​งู​ปิ๊ด หมู่​เจ้า​จะ​ป๊น​จาก​หม้อหน้าฮก​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ย้อน​จาอั้น เฮา​จะ​ส่ง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า คน​ตี้​มี​ปั๋ญญา กับ​ธรรมาจ๋ารย์​มา​หา​เจ้า​ตังหลาย แล้ว​เจ้า​ตังหลาย​ก็​จะ​ยับ​เขา​หมู่​นั้น​ไป​ฆ่า​เหีย​พ่อง ไป​เขิง​บน​ไม้​ก๋าง​เขน​พ่อง​ไป​เฆี่ยน​ใน​ธรรมศาลา​ของ​จาว​ยิว​พ่อง ไล่​หมู่​เขา​หนี​จาก​เมือง​นึ่ง​ไป​แหม​เมือง​นึ่ง​พ่อง ");
INSERT INTO nod_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ย้อน​จาอั้น​โต้ษ​จะ​มา​เถิง​หมู่​เจ้า​นี่​ละ ตี้​ได้​ฆ่า​คน​ตี้​บริสุทธิ์ ตั้งแต่​อาแบล​ตี้​ถูก​ฆ่า​ต๋าย​จ๋น​เถิง​เศคาริยาห์​ลูก​ของ​เบเรคิยาห์ ตี้​ถูก​ฆ่า​ต๋าย​หละหว่าง​พระวิหาร​กับ​แต้น​ปู่จา ");
INSERT INTO nod_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","เฮา​บอก​ความ​จริง​แก่​เจ้า​ตังหลาย​ว่า โต้ษ​ตี้​ได้​ฆ่า​คน​หมู่​นั้น​ก็​จะ​มา​เถิง​คน​ใน​ยุค​นี้​อย่าง​แน่นอน ");
INSERT INTO nod_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“โอ เยรูซาเล็ม เยรูซาเล็ม​เหย เจ้า​คือ​ผู้​ตี้​ได้​ฆ่า​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า แล้ว​เอา​บ่าหิน​ขว้าง​คน​หมู่​นั้น​ตี้​พระเจ้า​ส่ง​มา​หา​หมู่​เจ้า​จ๋น​ต๋าย หลาย​เตื้อ​เฮา​ใค่​เอา​ลูก​ของ​เจ้า​มา​ไว้​ใน​อ้อม​อก เหมือน​แม่​ไก่​กก​ลูก​อยู่​ใต้​ปีก​ของ​มัน แต่​เจ้า​บ่﻿ยอม ");
INSERT INTO nod_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ผ่อ​หื้อ​ดี​เน่อ เฮือน​ของ​เจ้า​จะ​ถูก​ละ​ขว้าง​หื้อ​ฮ้าง​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","เฮา​ขอ​บอก​เจ้า​ตังหลาย​ไว้​เน่อ​ว่า ตั้งแต่​นี้​ต่อ​ไป​ปาย​หน้า เจ้า​ตังหลาย​จะ​บ่﻿หัน​เฮา​แหม​แล้ว จ๋น​กว่า​หมู่​เจ้า​จะ​เอิ้น​ว่า ‘ขอ​พระเจ้า​ปั๋น​ปอน​ผู้​ตี้​มา​ใน​นาม​ของ​องค์​พระผู้เป๋นเจ้า’ ” ");
INSERT INTO nod_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ต๋อน​ตี้​พระเยซู​ก่ำลัง​เตียว​ออก​จาก​บริเวณ​พระวิหาร หมู่​สาวก​มา​จี๊​หื้อ​พระองค์​ผ่อ​ตึก​ต่าง﻿ๆ ใน​บริเวณ​พระวิหาร ");
INSERT INTO nod_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","พระองค์​อู้​กับ​หมู่​เขา​ว่า “ต้าน​ตังหลาย​หัน​ตึก​หมู่​นี้​ก่อ เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า บ่าหิน​ตี้​ซ้อน​กั๋น​หมู่​นี้​จะ​ถูก​เต​ขว้าง​จ๋น​บ่﻿หัน​วาง​ซ้อน​กั๋น​เลย​สัก​ก้อน” ");
INSERT INTO nod_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ต๋อน​ตี้​พระเยซู​ก่ำลัง​นั่ง​อยู่​บน​ดอย​บ่ากอกเทศ หมู่​สาวก​มา​ถาม​พระองค์​เป๋น​ก๋าน​ส่วน​ตั๋ว​ว่า “ขอ​บอก​หมู่​เฮา​กำ​เต๊อะ​ว่า สิ่ง​หมู่​นี้​จะ​เกิด​ขึ้น​เมื่อ​ใด แล้ว​วัน​ตี้​พระองค์​จะ​ปิ๊ก​มา​กับ​วัน​สิ้น​โลก​จะ​มี​หมายสำคัญ​อะหยัง​พ่อง” ");
INSERT INTO nod_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","พระองค์​ตอบ​ว่า “หละวัง​หื้อ​ดี ห้าม​หื้อ​ใผ​จุล่าย​ต้าน​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ย้อน​ว่า​จะ​มี​หลาย​คน​อ้าง​จื้อ​ของ​เฮา​ว่า ‘เฮา​เป๋น​พระคริสต์’ แล้ว​จุล่าย​หื้อ​หลาย​คน​หลง​เจื้อ ");
INSERT INTO nod_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ต้าน​ตังหลาย​จะ​ได้ยิน​เรื่อง​สงคราม กับ​ได้​ข่าว​ลือ​ว่า​เกิด​สงคราม​ตึง​ใก้​ตึง​ไก๋ ก็​บ่﻿ถ้า​ตก​อก​ตก​ใจ๋ ย้อน​เรื่อง​จาอี้​จะ​ต้อง​เกิด​ขึ้น​ก่อน แต่​ยัง​บ่﻿เถิง​วัน​เสี้ยง​สุด​ของ​โลก​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ประเทศ​นึ่ง​จะ​สู้ฮบ​กับ​แหม​ประเทศ​นึ่ง อาณาจักร​นึ่ง​ก็​จะ​สู้ฮบ​กับ​แหม​อาณาจักร​นึ่ง จะ​เกิด​ก๋าน​กั้น​ข้าว​อยาก​น้ำ​กับ​แผ่นดิน​จะ​ไหว​หลาย​ตี้ ");
INSERT INTO nod_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","แต่​เหตุก๋ารณ์​หมู่​นี้​ก็​เผียบ​เหมือน​ก๋าน​ตั้งเก๊า​เจ็บ​ต๊อง​ก่อน​เกิด​ลูก ");
INSERT INTO nod_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“หมู่​ต้าน​จะ​ถูก​ยับ​ไป​ทรมาน แล้ว​ถูก​ฆ่า คน​จะ​จัง​ต้าน​ใคว่​ไป​หมด ย้อน​ว่า​หมู่​ต้าน​ได้​ติดต๋าม​เฮา ");
INSERT INTO nod_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","เถิง​ต๋อน​นั้น​หลาย​คน​จะ​เลิก​เจื้อ จะ​หักหลัง​กั๋น​กับ​จะ​จัง​กั๋น​ตวย ");
INSERT INTO nod_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","จะ​มี​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตั๋ว​ป๋อม​หลาย​คน แล้ว​มา​จุล่าย​คน​จ๋ำนวน​นัก ");
INSERT INTO nod_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","คน​ตังหลาย​จะ​บ่﻿มี​ความ​ฮัก​หื้อ​กั๋น​แหม​ต่อ​ไป ย้อน​ว่า​ความ​บ่﻿ดี​จะ​นัก​ขึ้น​ติก﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","แต่​ถ้า​ใผ​ตี้​ทน​ได้​จ๋น​เถิง​ตี้​สุด​จะ​ได้ฮับ​ความ​รอด​ป๊น​บาป​โต้ษ ");
INSERT INTO nod_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","คน​จะ​บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า​ไป​ใคว่​ตึง​โลก เปื้อ​กู้​จ้าด​จะ​ได้ยิน​ข่าวดี​นี้ แล้ว​วัน​สิ้น​โลก​จะ​มา​เถิง ");
INSERT INTO nod_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ดาเนียล​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​เกย​อู้​เถิง ‘สิ่ง​ตี้​มา​ย่ำ​สิ่ง​ศักดิ์สิทธิ์ ตี้​เยียะ​หื้อ​เกิด​ความ​ฉิบหาย’ เมื่อ​ต้าน​หัน​สิ่ง​นั้น​ตั้ง​อยู่​ใน​สถาน​ตี้​ศักดิ์สิทธิ์ (​หื้อ​คน​ตี้​อ่าน​กำ​นี้​เข้าใจ๋​ความหมาย​หื้อ​ดี​) ");
INSERT INTO nod_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ก็​หื้อ​คน​ตี้​อยู่​ใน​แคว้น​ยูเดีย​ขะใจ๋​หนี​ไป​อยู่​บน​ดอย​เวย﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","คน​ตี้​อยู่​บน​ดาดฟ้า​หลังคา​บ้าน ห้าม​ลง​มา​กาว่า​ปิ๊ก​เข้า​ไป​เก็บ​คัว​ใน​บ้าน ");
INSERT INTO nod_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","คน​ตี้​อยู่​ต๋าม​โต้ง​ต๋าม​นา ห้าม​ปิ๊ก​ไป​เอา​เสื้อ​คุม​ตี้​บ้าน หื้อ​ลวด​หนี​ไป​เลย ");
INSERT INTO nod_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ใน​หว่าง​นั้น​ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​แม่มาน​กับ​แม่​ลูก​หน้อย​ตี้​ลูก​ยัง​กิ๋น​นม​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","หื้อ​อ้อนวอน​ขอ​พระเจ้า​ตี้​จะ​บ่﻿ต้อง​หนี​ใน​หน้า​หนาว กาว่า​ใน​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ย้อน​ว่า​ยาม​นั้น​จะ​เกิด​ความ​ตุ๊กยาก​ลำบาก​อย่าง​ใหญ่​หลวง​ขนาด อย่าง​ตี้​บ่﻿เกย​เกิด​ขึ้น​มา​ก่อน​เลย นับ​ตั้งแต่​โลก​เกิด​ขึ้น​จ๋น​เถิง​บ่าเดี่ยว​นี้ กับ​จะ​บ่﻿มี​จาอี้​เกิด​ขึ้น​แหม​เลย ");
INSERT INTO nod_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ถ้า​พระเจ้า​บ่﻿หย้อ​วัน​เวลา​หมู่​นั้น​หื้อ​สั้น​ลง ก็​จะ​บ่﻿มี​ใผ​รอด​จีวิต​เลย แต่​ย้อน​ว่า​พระองค์​หัน​แก่​คน​ตี้​พระองค์​ได้​เลือก​ไว้​เป๋น​ของ​พระองค์​แล้ว ก็​หื้อ​เวลา​นั้น​สั้น​ลง ");
INSERT INTO nod_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ใน​เวลา​นั้น​ถ้า​มี​คน​ใด​มา​บอก​ว่า ‘ผ่อ​ลอ​พระคริสต์​อยู่​หั้น’ กาว่า ‘พระคริสต์​อยู่​นี้’ ห้าม​เจื้อ​เขา​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ย้อน​ว่า​จะ​มี​พระคริสต์​ตั๋ว​ป๋อม กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตั๋ว​ป๋อม​เกิด​ขึ้น แล้ว​หมู่​เขา​ก็​จะ​เยียะ​ก๋าน​อัศจ๋รรย์​กับ​หมายสำคัญ​ต่าง﻿ๆ เปื้อ​จุล่าย​แม้​แต่​คน​ตี้​พระเจ้า​ได้​เลือก​ไว้​แล้ว ถ้า​เป๋น​ไป​ได้ ");
INSERT INTO nod_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ฟัง​ไว้​หื้อ​ดี​เน่อ เฮา​ได้​เตื๋อน​หมู่​ต้าน​ไว้​ก่อน​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ย้อน​จาอั้น​ถ้า​มี​ใผ​มา​บอก​ต้าน​ตังหลาย​ว่า ‘หั้น​ลอ พระคริสต์​อยู่​ตี้​ดินแดน​ทุรกั๋นดาร’ ห้าม​ออก​ไป​หา​เขา กาว่า​ถ้า​มี​คน​บอก​ว่า ‘พระคริสต์​หลบ​อยู่​นี่​ลอ’ ก็​ห้าม​เจื้อ​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ย้อน​ว่า​เมื่อ​บุตรมนุษย์​ปิ๊ก​มา จะ​เผียบ​เหมือน​กับ​ฟ้า​แมบ​ตัง​วันออก อยู่​ตัง​วันตก​ก็​หัน​แจ้ง​หลึ้ง ");
INSERT INTO nod_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","เหมือน​กับ​ตี้​ไหน​มี​ซาก​ศพ ตี้​หั้น​ก็​จะ​มี​หมู่​แฮ้ง​หลุ้ม​ต๋อม​กั๋น​เต๋ม​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ตันที​ตี้​เวลา​ตุ๊ก​ยาก​ลำบาก​นั้น​ผ่าน​ป๊น​ไป​แล้ว ‘ตะวัน​จะ​มืด​ตึ๊ก เดือน​จะ​บ่﻿ส่อง​แสง ดาว​จะ​หยวะ​ตก​จาก​ต๊องฟ้า หมู่​ผู้​มี​อำนาจ​ตังหลาย​ใน​ต๊องฟ้า​ก็​จะ​สั่นไหว​เฝื่อน​คลอน’ ");
INSERT INTO nod_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“ใน​เวลา​นั้น​จะ​มี​หมายสำคัญ​บน​ต๊องฟ้า​บอก​หื้อ​ฮู้​ว่า บุตรมนุษย์​ก่ำลัง​ปิ๊ก​มา คน​ตังหลาย​หมด​ตึง​โลก​จะ​ไห้​สนั่น​ปั่น​ปื๊น หมู่​เขา​จะ​หัน​บุตรมนุษย์​ลง​มา​บน​เมฆ​ใน​ต๊องฟ้า​ด้วย​ฤทธิ์​อำนาจ​กับ​รัศมี​อัน​ยิ่งใหญ่ ");
INSERT INTO nod_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","พระองค์​จะ​ส่ง​หมู่​ทูตสวรรค์​ของ​พระองค์​มา พร้อม​กับ​เสียง​แก​ตี้​ดัง​ขนาด หมู่​ทูตสวรรค์​นั้น​จะ​มา​รวบรวม​คน​ตี้​พระองค์​เลือก​ไว้​แล้ว จาก​ตึง​สี่​ทิศ​ตั้งแต่​ขอบ​ฟ้า​เผิก​นึ่ง จ๋น​เถิง​สุด​ขอบ​ฟ้า​แหม​เผิก​นึ่ง ");
INSERT INTO nod_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“หื้อ​เฮียน​ฮู้​จาก​เรื่อง​เก๊า​บ่าเดื่อ คือ​เมื่อ​กิ่ง​บ่าเดื่อ​โป่ง​ใบ​ใหม่ ต้าน​ก็​ฮู้​ว่า​ใก้​จะ​เถิง​หน้า​ฮ้อน​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ก็​เหมือน​เดียว​กั๋น เมื่อ​ต้าน​ตังหลาย​หัน​เหตุก๋ารณ์​ตี้​เฮา​บอก​แล้ว ก็​หื้อ​ฮู้​ว่า​ใก้​เถิง​เวลา​ตี้​พระองค์​จะ​ปิ๊ก​มา ใก้​จะ​เถิง​เวลา​แต๊﻿ๆ แล้ว​เน่อ ");
INSERT INTO nod_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ใน​ยุค​นี้​จะ​ยัง​บ่﻿ต๋าย​ก่อน​เหตุก๋ารณ์​ตี้​ว่า​หมู่​นี้​จะ​เกิด​ขึ้น ");
INSERT INTO nod_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ต๊องฟ้า​กับ​โลก​จะ​ยุบ​หาย​ไป แต่​ถ้อยกำ​ของ​เฮา​จะ​บ่﻿สูญหาย​ไป​เลย ");
INSERT INTO nod_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“แต่​ว่า​วัน​นั้น​เวลา​นั้น​ตี้​สิ่ง​หมู่​นี้​จะ​เกิด​ขึ้น บ่﻿มี​ใผ​ฮู้​สัก​คน หมู่​ทูตสวรรค์​ก็​บ่﻿ฮู้ บุตร​ของ​พระเจ้า​ก็​บ่﻿ฮู้ มี​ก้า​พระบิดา​องค์​เดียว​เต้าอั้น​ตี้​ฮู้ ");
INSERT INTO nod_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","เมื่อ​บุตรมนุษย์​จะ​มา ก็​จะ​เป๋น​อย่าง​เดียว​กับ​ใน​สมัย​ของ​โนอาห์ ");
INSERT INTO nod_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","คือ​ว่า​ใน​สมัย​ของ​โนอาห์​นั้น ก่อน​ตี้​น้ำ​จะ​ท่วม​โลก คน​ตังหลาย​ได้​กิ๋น​กับ​ดื่ม มี​ก๋าน​แต่งงาน​กั๋น ตึง​ยก​ลูก​หื้อ​เป๋น​ผัว​เมีย​กั๋น จ๋น​เถิง​วัน​ตี้​โนอาห์​ได้​เข้า​ไป​ใน​เฮือ ");
INSERT INTO nod_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","คน​ตังหลาย​หมู่​นี้​บ่﻿ฮู้​ตั๋ว​เลย​ว่า​จะ​เกิด​เหตุก๋ารณ์​อะหยัง​ขึ้น เต๊า​ฮอด​น้ำ​ท่วม​ปั๊ด​ปา​คน​หมู่​นี้​ไป​หมด เมื่อ​บุตรมนุษย์​จะ​มา​ก็​จะ​เป๋น​จาอั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ใน​ยาม​นั้น​ป้อจาย​สอง​คน​ตี้​ก่ำลัง​เยียะ​นา คน​นึ่ง​จะ​ถูก​ฮับ​ไป​แต่​แหม​คน​นึ่ง​จะ​ถูก​ละ​ไว้ ");
INSERT INTO nod_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","กับ​แม่ญิง​สอง​คน​ก่ำลัง​โม่​แป้ง​อยู่​ตวย​กั๋น คน​นึ่ง​จะ​ถูก​ฮับ​ไป​แต่​แหม​คน​นึ่ง​จะ​ถูก​ละ​ไว้ ");
INSERT INTO nod_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ย้อน​จาอั้น​หมู่​ต้าน​จง​หละวัง​ตั๋ว​หื้อ​ดี ย้อน​ต้าน​บ่﻿ฮู้​ว่า​องค์​พระผู้เป๋นเจ้า​ของ​ต้าน​จะ​ปิ๊ก​มา​เมื่อ​ใด​วัน​ไหน​กั๋น​แน่ ");
INSERT INTO nod_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","หื้อ​จ๋ำ​ไว้​ว่า ถ้า​เจ้าของ​บ้าน​ฮู้​ตั๋ว​ว่า​ขโมย​จะ​ลัก​เข้า​มา​ต๋อน​เมื่อคืน​เวลา​ใด เขา​ก็​จะ​แน​หละวัง บ่﻿หื้อ​ขโมย​งัด​เข้า​มา​ใน​บ้าน​ได้​แน่﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","เหมือน​เดียว​กั๋น ต้าน​ตังหลาย​จง​เกียม​ตั๋ว​ไว้​หื้อ​พร้อม ย้อน​ว่า​บุตรมนุษย์​จะ​มา​ใน​เวลา​ตี้​หมู่​ต้าน​กึ๊ด​บ่﻿เถิง ");
INSERT INTO nod_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ใผ​คน​ใด​ตี้​เป๋น​คน​ฮับใจ๊​ตี้​ซื่อสัตย์​กับ​หลวก ตี้​เจ้านาย​มอบ​หน้าตี้​หื้อ​เป๋น​หัวหน้า​คน​ฮับใจ๊​คน​อื่น﻿ๆ เปื้อ​แจก​ของกิ๋น​ต๋าม​เวลา ");
INSERT INTO nod_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","เมื่อ​เจ้านาย​ปิ๊ก​มา​หัน​เขา​ยัง​เยียะ​ก๋าน​อยู่​อย่าง​ดี คน​ฮับใจ๊​คน​นั้น​ก็​เป๋น​สุข ");
INSERT INTO nod_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เจ้านาย​จะ​ตั้ง​หื้อ​เขา​ผ่อกอย​กู้​อย่าง​ตี้​เป๋น​ของ​เปิ้น ");
INSERT INTO nod_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","แต่​ถ้า​คน​ฮับใจ๊​คน​นั้น​เป๋น​คน​บ่﻿ดี แล้ว​กึ๊ด​ใน​ใจ๋​ว่า ‘แหม​เมิน​อยู่​กว่า​เจ้านาย​จะ​ปิ๊ก​มา’ ");
INSERT INTO nod_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","แล้ว​ตั้งเก๊า​บุบ​ตี๋​คน​ฮับใจ๊​คน​อื่น﻿ๆ กับ​ปา​กั๋น​ตึง​กิ๋น​ตึง​ดื่ม​กับ​หมู่​เปื้อน​ขี้​เหล้า ");
INSERT INTO nod_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","เจ้านาย​ของ​เขา​ก็​จะ​ปิ๊ก​มา​ใน​วัน​เวลา​ตี้​เขา​บ่﻿ฮู้​กับ​บ่﻿ตัน​ฮู้คิง ");
INSERT INTO nod_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","แล้ว​ก็​จะ​ลงโต้ษ​เขา​อย่าง​หนัก ตึง​ไล่​หื้อ​ไป​อยู่​ตวย​หมู่​คน​หน้า​ซื่อ​ใจ๋​ก๊ด ตั๊ด​ตี้​มี​เสียง​คน​ไห้​หุย​ขบ​เขี้ยว​เกี๊ยว​กาง​อย่าง​เจ็บ​ปวด” ");
INSERT INTO nod_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ใน​เวลา​นั้น แผ่นดิน​สวรรค์​จะ​เผียบ​เหมือน​เปื้อน​เจ้าสาว​สิบ​คน ก๋ำ​โกม​ไฟ​ออก​มา​ถ้า​ฮับ​เจ้าบ่าว ");
INSERT INTO nod_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ใน​แม่ญิง​หมู่​นั้น​มี​ห้า​คน​เป๋น​คน​ง่าว แหม​ห้า​คน​เป๋น​คน​หลวก ");
INSERT INTO nod_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","แม่ญิง​ง่าว​ห้า​คน​นั้น​เอา​โกม​ไฟ​ไป แต่​บ่﻿ได้​เอา​น้ำมัน​สำรอง​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","แต่​แม่ญิง​หลวก​ห้า​คน​นั้น​เอา​น้ำมัน​สำรอง​ใส่​ก๋า​ไป​พร้อม​กับ​โกม​ไฟ​ตวย ");
INSERT INTO nod_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","เป๋น​เวลา​เมิน​ขนาด​แต่​เจ้าบ่าว​ก็​ยัง​บ่﻿มา​เตื้อ แม่ญิง​สาว​ตึง​สิบ​คน​ก็​ใค่หลับ​แล้ว​ก็​หลับ​ไป ");
INSERT INTO nod_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“เมื่อ​เถิง​เวลา​เตี้ยง​คืน ก็​มี​เสียง​เอิ้น​ฮ้อง​ว่า ‘เจ้าบ่าว​มา​แล้ว ขะใจ๋​ออก​มา​ต้อนฮับ​เน่อ’ ");
INSERT INTO nod_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“เปื้อน​เจ้าสาว​ตึง​หมด​สิบ​คน​ก็​ตื่น แล้ว​แป๋ง​ไส้​โกม​ไฟ​ของ​ตั๋ว​หื้อ​พร้อม ");
INSERT INTO nod_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","หมู่​แม่ญิง​ง่าว​อู้​กับ​หมู่​แม่ญิง​หลวก​ว่า ‘ขอ​แบ่ง​น้ำมัน​ของ​หมู่​เจ้า​หื้อ​หมู่​เฮา​พ่อง​เต๊อะ โกม​ไฟ​ของ​หมู่​เฮา​ก่ำลัง​จะ​ดับ​อยู่​แล้ว’ ");
INSERT INTO nod_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“หมู่​แม่ญิง​หลวก​ตอบ​ว่า ‘บ่﻿ได้​ก้า น้ำมัน​ตี้​มี​อยู่​นี้​มี​ปอ​สำหรับ​ตั๋ว​เฮา​เต้าอั้น หมู่​เจ้า​ไป​เซาะ​ซื้อ​จาก​คน​ขาย​เอา​คน​เดียว​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“ต๋อน​ตี้​หมู่​แม่ญิง​ง่าว​ออก​ไป​เซาะ​ซื้อ​น้ำมัน เจ้าบ่าว​ก็​มา​แผว เปื้อน​เจ้าสาว​ตี้​พร้อม​อยู่​แล้ว​ได้​ไป​งาน​เลี้ยง​แต่งงาน​กับ​เจ้าบ่าว แล้ว​ปะตู๋​ก็​หับ ");
INSERT INTO nod_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ต่อ​มา​เมื่อ​หมู่​แม่ญิง​ง่าว​ห้า​คน​ปิ๊ก​มา ก็​ปา​กั๋น​ฮ้อง​ว่า ‘ต้าน​เจ้า﻿ๆ จ้วย​ไข​ปะตู๋​หื้อ​เฮา​กำ​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“แต่​เจ้าบ่าว​ตอบ​ว่า ‘เฮา​บอก​ความ​จริง​แก่​หมู่​เจ้า​ว่า เฮา​บ่﻿ฮู้จัก​หมู่​เจ้า​เลย’ ");
INSERT INTO nod_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“ย้อน​จาอั้น หื้อ​ต้าน​ตังหลาย​เฝ้า​หละวัง​อยู่​ตลอด ย้อน​ต้าน​บ่﻿ฮู้​วัน​เวลา​ตี้​เฮา​จะ​ปิ๊ก​มา ");
INSERT INTO nod_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“แผ่นดิน​สวรรค์​ก็​เผียบ​เหมือน​ป้อจาย​คน​นึ่ง​ตี้​ก่ำลัง​จะ​ออก​เตียว​ตาง​ไป​เมือง​ไก๋ เขา​ฮ้อง​หมู่​คน​ฮับใจ๊​เข้า​มา​หา แล้ว​มอบ​ข้าว​ของ​เงิน​คำ​หื้อ​ฮับผิดชอบ ");
INSERT INTO nod_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ต้าน​หื้อ​สตางค์​ห้า​ตะลันต์​แก่​คน​ตี้​นึ่ง หื้อ​สอง​ตะลันต์​แก่​คน​ตี้​สอง แล้ว​ก็​หื้อ​คน​ตี้​สาม​ตะลันต์​เดียว โดย​แบ่ง​หื้อ​ต๋าม​ความ​สามารถ​ของ​แต่​ละ​คน แล้ว​ต้าน​ก็​ออก​เตียว​ตาง ");
INSERT INTO nod_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","คน​ฮับใจ๊​ตี้​ได้​ห้า​ตะลันต์ ก็​เอา​ไป​เป๋น​ตืน​ก๊า​ขาย​เลย แล้ว​ก็​ได้​ก่ำไฮ​มา​แหม​ห้า​ตะลันต์ ");
INSERT INTO nod_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","คน​ฮับใจ๊​ตี้​ได้​สอง​ตะลันต์ ก็​เอา​ไป​เป๋น​ตืน​ก๊า​ขาย​เหมือน​กั๋น แล้ว​ก็​ได้​ก่ำไฮ​มา​แหม​สอง​ตะลันต์ ");
INSERT INTO nod_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","สำหรับ​คน​ฮับใจ๊​ตี้​ได้​ตะลันต์​เดียว ก็​ขุด​ดิน​เป๋น​ฮ่อม แล้ว​ซ่อน​สตางค์​ของ​เจ้านาย​ไว้​ใน​หั้น​เหีย ");
INSERT INTO nod_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“เวลา​ผ่าน​ไป​เมิน​แล้ว เจ้านาย​ปิ๊ก​มา จึง​ฮ้อง​หมู่​คน​ฮับใจ๊​สาม​คน​มา​ถาม​ว่า​ได้​เอา​สตางค์​ไป​เยียะ​อะหยัง​กั๋น​พ่อง ");
INSERT INTO nod_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","คน​ฮับใจ๊​ตี้​ได้​ห้า​ตะลันต์ เอา​ตึง​ตืน​ตึง​ก่ำไฮ​แหม​ห้า​ตะลันต์​มา​หื้อ​นาย​แล้ว​ก็​บอก​ว่า ‘นาย​เจ้าข้า สตางค์​ตี้​หื้อ​ข้าพเจ้า​ไว้​ห้า​ตะลันต์ ผ่อ​นี่​ลอ ตืน​ห้า​ตะลันต์​ข้าพเจ้า​ได้​ก่ำไฮ​มา​เปาะ​แหม​ห้า​ตะลันต์’ ");
INSERT INTO nod_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“นาย​ก็​อู้​กับ​เขา​ว่า ‘ดี​แล้ว เจ้า​เป๋น​คน​ฮับใจ๊​ตี้​ดี กับ​ซื่อสัตย์ เจ้า​ซื่อสัตย์​ใน​สิ่ง​เล็ก﻿ๆ หน้อย﻿ๆ เฮา​จะ​ตั้ง​หื้อ​เจ้า​ผ่อกอย​ของ​จ๋ำนวน​นัก มา​ฮ่วม​ยินดี​กับ​นาย​ของ​เจ้า​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“แล้ว​คน​ฮับใจ๊​ตี้​ได้​สอง​ตะลันต์ ก็​เข้า​มา​อู้​ว่า ‘นาย​เจ้าข้า สตางค์​ตี้​หื้อ​ข้าพเจ้า​ไว้​สอง​ตะลันต์ ผ่อ​นี่​ลอ ตืน​สอง​ตะลันต์​ข้าพเจ้า​ได้​ก่ำไฮ​มา​เปาะ​แหม​สอง​ตะลันต์’ ");
INSERT INTO nod_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“นาย​ก็​อู้​กับ​เขา​ว่า ‘ดี​แล้ว เจ้า​เป๋น​คน​ฮับใจ๊​ตี้​ดี กับ​ซื่อสัตย์ เจ้า​ซื่อสัตย์​ใน​สิ่ง​เล็ก﻿ๆ หน้อย﻿ๆ เฮา​จะ​ตั้ง​หื้อ​เจ้า​ผ่อกอย​ของ​จ๋ำนวน​นัก มา​ฮ่วม​ยินดี​กับ​นาย​ของ​เจ้า​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“แล้ว​คน​ฮับใจ๊​ตี้​ได้​ตะลันต์​เดียว​ก็​เข้า​มา​อู้​ว่า ‘นาย​เจ้าข้า ข้าพเจ้า​ฮู้​ว่า​ต้าน​เป๋น​คน​เขี้ยว ต้าน​เก็บเกี่ยว​สิ่ง​ตี้​ต้าน​บ่﻿ได้​ปูก แล้ว​ก็​เก็บ​พืช​ผล​ตี้​ต้าน​บ่﻿ได้​หว่าน ");
INSERT INTO nod_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ข้าพเจ้า​กั๋ว​ก็​เลย​เอา​สตางค์​ตะลันต์​เดียว ไป​ขุด​ขุม​ซ่อน​ไว้​ใน​ดิน​เหีย ผ่อ​นี่​ลอ สตางค์​ตะลันต์​เดียว​ของ​ต้าน’ ");
INSERT INTO nod_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“นาย​ก็​ตอบ​เขา​ว่า ‘ไอ่​ขี้​ข้า​บ่﻿ดี​ขี้ค้าน เจ้า​ก็​ฮู้​ว่า​เฮา​เก็บเกี่ยว​ใน​สิ่ง​ตี้​เฮา​บ่﻿ได้​ปูก กับ​เก็บ​พืชผล​ตี้​เฮา​บ่﻿ได้​หว่าน ");
INSERT INTO nod_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ถ้า​จาอั้น​เป๋น​จาใด​บ่﻿เอา​สตางค์​นั้น​ไป​ฝาก​ธนาคาร​ไว้ เมื่อ​เฮา​ปิ๊ก​มา​ก็​จะ​ได้​สตางค์​ตึง​ต้น​ตึง​ดอก’ ");
INSERT INTO nod_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“แล้ว​เจ้านาย​ก็​สั่ง​หื้อ​เอา​สตางค์​นึ่ง​ตะลันต์​จาก​เขา​ไป​หื้อ​คน​ตี้​มี​สิบ​ตะลันต์ ");
INSERT INTO nod_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ย้อน​คน​ตี้​มี​อยู่​แล้ว ก็​จะ​เตื่อม​นัก​ขึ้น​จ๋น​เหลือ​ล้น ส่วน​คน​ตี้​บ่﻿มี แม้​แต่​สิ่ง​ตี้​เขา​มี​อยู่​นั้น​ก็​จะ​เอา​ไป​จาก​เขา​เหีย ");
INSERT INTO nod_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","จาก​นั้น​ก็​สั่ง​หื้อ​เอา​คน​ฮับใจ๊​บ่﻿มี​ประโยชน์​คน​นั้น โจ้ง​ออก​ไป​ตี้​มืด​ตัง​นอก​เหีย ตี้​หั้น​จะ​มี​เสียง​ไห้​หุย​ขบ​เขี้ยว​เกี๊ยว​กาง​อย่าง​เจ็บปวด ");
INSERT INTO nod_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“เมื่อ​บุตรมนุษย์​จะ​ปิ๊ก​มา​โดย​รัศมี​อัน​ยิ่งใหญ่​ฮ่วม​กับ​หมู่​ทูตสวรรค์ พระองค์​จะ​นั่ง​บน​บัลลังก์​ตี้​เต๋ม​ไป​ด้วย​รัศมี​ตี้​มา​จาก​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","คน​เจื๊อ​จ้าด​ต่าง﻿ๆ จะ​มา​เปาะ​กั๋น​ส่อง​หน้า​บุตรมนุษย์ พระองค์​จะ​แบ่ง​หมู่​เขา​ออก​เป๋น​สอง​หมู่ เหมือน​กับ​คน​เลี้ยง​แกะ​ตี้​แยก​แกะ​ออก​จาก​แป๊ะ ");
INSERT INTO nod_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","พระองค์​จะ​เอา​แกะ​ไว้​ตัง​ขวา​มือ ส่วน​แป๊ะ​ก็​จะ​เอา​ไว้​ตัง​ซ้าย​มือ ");
INSERT INTO nod_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“แล้ว​พระองค์​ผู้​เป๋น​กษัตริย์​จะ​อู้​กับ​หมู่​ตี้​อยู่​ตัง​ขวา​มือ​ว่า ‘ต้าน​ตังหลาย​ตี้​ได้ฮับ​ปอน​จาก​พระบิดา​ของ​เฮา เจิญ​ฮับ​อาณาจักร​ตี้​ได้​เกียม​ไว้​สำหรับ​ต้าน​ตังหลาย​ตั้งแต่​สร้าง​โลก​มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ย้อน​ว่า​ต๋อน​ตี้​เฮา​ใค่​อยาก​กิ๋น​ข้าว หมู่​ต้าน​ก็​เลี้ยง​เฮา เฮา​ใค่​อยาก​กิ๋น​น้ำ ต้าน​ก็​เอา​น้ำ​หื้อ​เฮา​กิ๋น เฮา​เป๋น​คน​แปลก​หน้า หมู่​ต้าน​ก็​ต้อนฮับ​เฮา​หื้อ​เข้า​ไป​ใน​บ้าน ");
INSERT INTO nod_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","เฮา​บ่﻿มี​เสื้อผ้า​ใส่ ต้าน​ก็​เอา​มา​หื้อ​เฮา​นุ่ง เฮา​บ่﻿สบาย ต้าน​ก็​ผ่อกอย​เอา​ใจ๋​ใส่ เฮา​ติด​คอก ต้าน​ก็​มา​แอ่ว​หา​เฮา’ ");
INSERT INTO nod_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“แล้ว​หมู่​ตี้​เยียะ​ถูกต้อง​ต๋าม​ธรรม​จะ​ตอบ​ว่า ‘องค์​พระผู้เป๋นเจ้า หมู่​เฮา​เกย​หัน​พระองค์​ใค่​อยาก​กิ๋น​ข้าว​แล้ว​เลี้ยง​พระองค์​เมื่อใด กาว่า​หัน​พระองค์​ใค่​อยาก​กิ๋น​น้ำ​แล้ว​เอา​น้ำ​หื้อ​พระองค์​กิ๋น​เมื่อใด ");
INSERT INTO nod_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","หมู่​เฮา​เกย​หัน​พระองค์​เป๋น​คน​แปลก​หน้า​แล้ว​เจิญ​พระองค์​เข้า​มา​ใน​บ้าน กาว่า​หัน​พระองค์​บ่﻿มี​เสื้อผ้า​ใส่​แล้ว​เอา​เสื้อผ้า​มา​หื้อ​นุ่ง​เมื่อใด ");
INSERT INTO nod_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","หมู่​เฮา​หัน​พระองค์​บ่﻿สบาย กาว่า​ติด​คอก​แล้ว​ไป​แอ่ว​หา​พระองค์​เมื่อใด’ ");
INSERT INTO nod_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“แล้ว​พระองค์​ผู้​เป๋น​กษัตริย์​จะ​ตอบ​หมู่​เขา​ว่า ‘เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เมื่อใด​ก็​ต๋าม​ตี้​หมู่​ต้าน​เยียะ​กับ​คน​ตี้​ต่ำต้อย​ตี้​สุด​คน​นึ่ง​ใน​หมู่​ปี้น้อง​ของ​เฮา ก็​เหมือน​ต้าน​ตังหลาย​ได้​เยียะ​ต่อ​เฮา​ตวย’ ");
INSERT INTO nod_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“แล้ว​พระองค์​จะ​บิ่น​หน้า​ไป​บอก​หมู่​ตี้​อยู่​ตัง​เผิก​ซ้าย​มือ​ว่า ‘ไป​หื้อ​ป๊น​หู​ป๊น​ต๋า​เฮา​เหีย หมู่​เจ้า​ถูก​แจ้ง​หื้อ​ตก​หม้อหน้าฮก​ใน​ไฟ​ตี้​บ่﻿มี​วัน​ดับ เป๋น​ไฟ​ตี้​เกียม​ไว้​สำหรับ​มาร​กับ​หมู่​ของ​มัน ");
INSERT INTO nod_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ย้อน​ว่า​ต๋อน​ตี้​เฮา​ใค่​อยาก​กิ๋น​ข้าว เจ้า​ตังหลาย​ก็​บ่﻿ได้​หื้อ​อะหยัง​เฮา​กิ๋น เฮา​ใค่​อยาก​กิ๋น​น้ำ เจ้า​ตังหลาย​บ่﻿ได้​หื้อ​น้ำ​เฮา​กิ๋น ");
INSERT INTO nod_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","เฮา​เป๋น​คน​แปลก​หน้า เจ้า​ตังหลาย​ก็​บ่﻿ได้​เจิญ​เฮา​เข้า​ไป​ใน​บ้าน เฮา​บ่﻿มี​เสื้อผ้า​ใส่ เจ้า​ตังหลาย​บ่﻿ได้​หื้อ​เสื้อผ้า​เฮา​นุ่ง เฮา​บ่﻿สบาย​กับ​ติด​คอก เจ้า​ตังหลาย​บ่﻿เกย​มา​แอ่ว​หา​เฮา’ ");
INSERT INTO nod_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“หมู่​เขา​ก็​จะ​ตอบ​ว่า ‘พระองค์​เจ้า​ข้า หมู่​เฮา​หัน​ต้าน​ใค่​อยาก​กิ๋น​ข้าว กิ๋น​น้ำ กาว่า​เป๋น​คน​แปลก​หน้า กาว่า​บ่﻿มี​เสื้อผ้า​นุ่ง บ่﻿สบาย​กับ​ติด​คอก แล้ว​หมู่​เฮา​บ่﻿ได้​เยียะ​อะหยัง​สัก​อย่าง​ตี้​จะ​จ้วยเหลือ​ต้าน​เมื่อใด​กา’ ");
INSERT INTO nod_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“พระองค์​จะ​ตอบ​ว่า ‘เฮา​บอก​ความ​จริง​แก่​เจ้า​ตังหลาย​ว่า อะหยัง​ก็​ต๋าม​ตี้​เจ้า​ตังหลาย​บ่﻿ได้​เยียะ​กับ​คน​ต่ำต้อย​ตี้​สุด​คน​นึ่ง เจ้า​ตังหลาย​ก็​บ่﻿ได้​เยียะ​ต่อ​เฮา​เลย’ ");
INSERT INTO nod_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“แล้ว​คน​ตังหลาย​หมู่​นั้น​ก็​จะ​ต้อง​ฮับ​โต้ษ​ตลอด​ไป แต่​คน​ตี้​เยียะ​ถูกต้อง​ต๋าม​ธรรม​จะ​เข้า​สู่​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","เมื่อ​พระเยซู​อู้​เรื่อง​หมู่​นี้​เป๋น​กำเผียบ​จบ​แล้ว พระองค์​บอก​หมู่​สาวก​ของ​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“หมู่​ต้าน​ก็​ฮู้​แล้ว​ว่า​แหม​สอง​วัน​จะ​เถิง​งาน​ปัสกา​ต๋อน​นั้น​บุตรมนุษย์​จะ​ถูก​ยับ​ส่ง​ไป​หื้อ​ศัตรู๋​เปื้อ​เอา​ไป​เขิง​บน​ไม้​ก๋าง​เขน​จ๋น​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","กวม​เดียว​กั๋น​นั้น​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​มา​จุมนุม​กั๋น​ตี้​บ้าน​ของ​มหา​ปุโรหิต ตี้​จื้อ​คายาฟาส ");
INSERT INTO nod_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","หมู่​เขา​วางแผน​ตี้​จะ​ลัก​ยับ​พระเยซู​ไป​ฆ่า ");
INSERT INTO nod_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","แต่​หมู่​เขา​ตกลง​กั๋น​ว่า “ใน​หละหว่าง​งาน​นี้ บ่﻿ดี​ฟั่ง​เยียะ​อะหยัง​เตื้อ กั๋ว​ว่า​คน​ตังหลาย​จะ​วุ่นวาย​แตกตื่น​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","เมื่อ​พระเยซู​อยู่​ตี้​หมู่​บ้าน​เบธานี​ใน​บ้าน​ของ​ซีโมน​คน​ตี้​เกย​เป๋น​ขี้ตู้ด ");
INSERT INTO nod_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","มี​แม่ญิง​คน​นึ่ง​ก๋ำ​ขวด​ใส่​น้ำมัน​หอม​รากา​แปง​ขนาด​เข้า​มา​หา​พระองค์ นาง​ถอก​น้ำมัน​หอม​ลง​บน​หัว​ของ​พระองค์​ต๋อน​ตี้​พระองค์​ก่ำลัง​กิ๋น​ข้าว​อยู่​นั้น ");
INSERT INTO nod_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","เมื่อ​หมู่​สาวก​ซัด​ต๋า​หัน​จาอั้น​ก็​บ่﻿ปอใจ๋ อู้​กั๋น​ว่า “เป๋น​จาใด​เยียะ​หื้อ​เสีย​ของ​ไป เหีย​บ่﻿ดาย ");
INSERT INTO nod_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ถ้า​เอา​ไป​ขาย​ก็​จะ​ได้​สตางค์​นัก แล้ว​เอา​สตางค์​นั้น​ไป​ปั๋น​หื้อ​คน​ตุ๊ก​คน​จ๋น​ก็​ได้” ");
INSERT INTO nod_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","พระเยซู​ฮู้​กำกึ๊ด​จาอั้น​ก็​อู้​กับ​หมู่​สาวก​ว่า “ไป​ยุ่ง​กับ​นาง​เยียะ​หยัง นาง​ได้​เยียะ​สิ่ง​ตี้​ดี​งาม​หื้อ​กับ​เฮา ");
INSERT INTO nod_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","คน​ตุ๊ก​คน​จ๋น​จะ​ยัง​อยู่​ตวย​หมู่​ต้าน​ไป​ตลอด แต่​เฮา​จะ​บ่﻿อยู่​ตวย​หมู่​ต้าน​ไป​ตลอด ");
INSERT INTO nod_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ตี้​นาง​เอา​น้ำมัน​หอม​ถอก​ลง​บน​ตั๋ว​เฮา​นั้น ก็​เปื้อ​จะ​เกียม​ไว้​สำหรับ​ก๋าน​ฝัง​ศพ​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า บ่﻿ว่า​คน​จะ​บอก​ข่าวดี​เรื่อง​แผ่นดิน​สวรรค์​ไป​ตี้​ไหน​ก็​ต๋าม​ใน​โลก เขา​ก็​จะ​เล่า​เรื่อง​ตี้​นาง​เยียะ​นี้​เป๋น​ก๋าน​ระลึก​เถิง​นาง​ตวย” ");
INSERT INTO nod_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ยูดาส อิสคาริโอท เป๋น​สาวก​คน​นึ่ง​ใน​สิบ​สอง​คน​ของ​พระเยซู ไป​ปะ​หมู่​หัวหน้า​ปุโรหิต ");
INSERT INTO nod_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ถาม​ว่า “หมู่​ต้าน​จะ​หื้อ​เฮา​เต้าใด​ถ้า​เฮา​จี๊​ตั๋ว​พระเยซู​หื้อ” หมู่​มหา​ปุโรหิต​ก็​หื้อ​สตางค์​ยูดาส​สาม​สิบ​เหรียญ​เงิน ");
INSERT INTO nod_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ตั้งแต่​หั้น​มา​ยูดาส​ก็​แน​หา​โอกาส​ตี้​จะ​หักหลัง​พระเยซู​หื้อ​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","วัน​ตี้​นึ่ง​ของ​งาน​กิ๋น​เข้าหนมปัง​บ่﻿ใส่​เจื๊อ หมู่​สาวก​เข้า​มา​หา​พระเยซู​แล้ว​ถาม​ว่า “จะ​หื้อ​หมู่​เฮา​ไป​เกียม​มื้อ​ปัสกา​หื้อ​พระองค์​กิ๋น​ตี้​ไหน​ดี” ");
INSERT INTO nod_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","พระเยซู​บอก​ว่า “หื้อ​เข้า​ไป​ใน​กรุง​เยรูซาเล็ม​ไป​หา​ป้อจาย​คน​นึ่ง แล้ว​บอก​เขา​ว่า ‘อาจ๋ารย์​บอก​ว่า ก๋ำหนด​เวลา​ของ​เฮา​มา​ใก้​จะ​แผว​แล้ว เฮา​ต้องก๋าน​จะ​เลี้ยง​ฉลอง​งาน​ปัสกา​กับ​หมู่​สาวก​ตี้​บ้าน​ของ​ต้าน’ ” ");
INSERT INTO nod_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","หมู่​สาวก​เยียะ​ต๋าม​ตี้​พระเยซู​บอก แล้ว​ได้​จัด​เกียม​มื้อ​ปัสกา​ไว้ ");
INSERT INTO nod_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","เถิง​ต๋อน​เมื่อค่ำ พระเยซู​ฮ่วม​กิ๋น​กับ​สาวก​ตึง​สิบ​สอง​คน ");
INSERT INTO nod_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ต๋อน​ตี้​ก่ำลัง​กิ๋น​อยู่​นั้น พระเยซู​อู้​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​นึ่ง​ใน​หมู่​ต้าน​จะ​หักหลัง​เฮา” ");
INSERT INTO nod_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","หมู่​สาวก​ก็​ตุ๊กใจ๋​ขนาด เปี่ยน​กั๋น​ถาม​พระองค์​กำ​คน​ว่า “พระองค์​เจ้า​ข้า​เป๋น​เฮา​กา” ");
INSERT INTO nod_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","พระเยซู​ตอบ​ว่า “คน​ตี้​จุ่ม​ลง​ถ้วย​เดียว​กับ​เฮา​จะ​เป๋น​คน​ตี้​หักหลัง​เฮา ");
INSERT INTO nod_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","บุตรมนุษย์​จะ​ต้อง​จาก​ไป​ต๋าม​ตี้​มี​เขียน​ไว้​ใน​พระคัมภีร์​เกี่ยวกับ​พระองค์ แต่​ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​คน​ตี้​หักหลัง​บุตรมนุษย์ ถ้า​คน​นั้น​บ่﻿ได้​เกิด​มา​ก็​ยัง​ดี​เหลือ​นี้” ");
INSERT INTO nod_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ยูดาส​คน​ตี้​จะ​หักหลัง​พระองค์​ถาม​ว่า “อาจ๋ารย์ เป๋น​เฮา​กา” พระองค์​ตอบ​ว่า “ต้าน​ว่า​คน​เดียว​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ต๋อน​ตี้​ก่ำลัง​กิ๋น​ข้าว​ตวย​กั๋น​อยู่​นั้น พระเยซู​หยิบ​เข้าหนมปัง​ขึ้น​มา​ขอบ​พระคุณ​พระเจ้า แล้ว​บิ​ยื่น​หื้อ​หมู่​สาวก อู้​ว่า “นี่​คือ​ก๋าย​ของ​เฮา หื้อ​ฮับ​เอา​ไป​กิ๋น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","แล้ว​พระเยซู​ก็​ก๋ำ​ถ้วย​เหล้า​องุ่น​ขึ้น​มา ขอบพระคุณ​พระเจ้า แล้ว​ก็​ส่ง​หื้อ​หมู่​สาวก อู้​ว่า “หื้อ​กู้​คน​กิ๋น​จาก​ถ้วย​นี้ ");
INSERT INTO nod_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ย้อน​ว่า​สิ่ง​ตี้​อยู่​ใน​ถ้วย​นี้​คือ​เลือด​ของ​เฮา​ตี้​จะ​ไหล​ออก​มา​เปื้อ​รับรอง​พันธสัญญา​หละหว่าง​พระเจ้า​กับ​คน​ตังหลาย กับ​เปื้อ​ยกโต้ษ​บาป​ของ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","เฮา​บอก​ต้าน​ตังหลาย​ว่า ตั้งแต่​นี้​ไป เฮา​จะ​บ่﻿กิ๋น​เหล้า​องุ่น​แหม​ต่อ​ไป จ๋น​กว่า​จะ​เถิง​วัน​นั้น​ตี้​เฮา​จะ​กิ๋น​ตวย​กั๋น​กับ​หมู่​ต้าน​ใน​แผ่นดิน​พระบิดา​ของ​เฮา แต่​เป๋น​ความหมาย​แบบ​ใหม่” ");
INSERT INTO nod_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","เมื่อ​หมู่​เขา​ฮ้อง​เพลง​สรรเสริญ​พระเจ้า​แล้ว ก็​ปา​กั๋น​ออก​ไป​ตี้​ดอย​บ่ากอกเทศ ");
INSERT INTO nod_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","พระเยซู​อู้​กับ​หมู่​สาวก​ว่า “คืน​นี้​หมู่​ต้าน​จะ​หนี​ละ​เฮา​ไป​เหีย​หมด เหมือน​กับ​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘พระเจ้า​จะ​ฆ่า​คน​เลี้ยง​แกะ แล้ว​แกะ​หมู่​นั้น​จะ​แตก​ขะแล​ขะแจ​หนี​ไป​หมด’ ");
INSERT INTO nod_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","แต่​เมื่อ​พระเจ้า​เยียะ​หื้อ​เฮา​เป๋น​ขึ้น​จาก​ความ​ต๋าย เฮา​จะ​ไป​แคว้น​กาลิลี​ก่อน​หมู่​ต้าน แล้ว​ปะ​กั๋น​ตี้​หั้น​น่อ” ");
INSERT INTO nod_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","เปโตร​บอก​พระองค์​ว่า “เถิง​คน​อื่น﻿ๆ จะ​ละ​พระองค์​ไป​หมด แต่​ข้าพเจ้า​จะ​บ่﻿มี​วัน​เยียะ​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","พระเยซู​อู้​กับ​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า คืน​นี้​ก่อน​ตี้​ไก่​จะ​ขัน ต้าน​จะ​บอก​บ่﻿ฮู้จัก​เฮา​เถิง​สาม​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","แต่​เปโตร​ยืนยัน​ว่า “แม้​ว่า​ข้าพเจ้า​จะ​ต้อง​ต๋าย​ตวย​พระองค์ ข้าพเจ้า​ตึง​บ่﻿มี​วัน​ปฏิเสธ​พระองค์​เลย” หมู่​สาวก​คน​อื่น﻿ๆ ตึงหมด ก็​อู้​จาอั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","จาก​นั้น​พระเยซู​ก็​ปา​สาวก​เตียว​ไป​ใน​ตี้​นึ่ง​จื้อ​ว่า​เกทเสมนี แล้ว​บอก​หมู่​สาวก​ว่า “นั่ง​อยู่​ตั๊ด​นี่​เน่อ เฮา​จะ​ไป​อธิษฐาน​ตัง​ปู๊น” ");
INSERT INTO nod_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","พระองค์​ปา​เปโตร ยอห์น​กับ​ยากอบ ตี้​เป๋น​ลูกบ่าว​สอง​คน​ของ​เศเบดี​ไป​ตวย เวลา​นั้น​พระองค์​โศกเศร้า​เป๋น​ตุ๊ก​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","พระองค์​บอก​หมู่​เขา​ว่า “ใจ๋​เฮา​เป๋น​ตุ๊ก​ปอ​จะ​ต๋าย​อยู่​แล้ว เฝ้า​อยู่​ตี้​นี่​กับ​เฮา​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","แล้ว​พระองค์​เตียว​ห่าง​ออก​ไป​หน้อย ก็​ก้ม​หน้า​ลง​ปื๊น แล้ว​อธิษฐาน​ว่า “พระบิดา​เจ้าข้า ถ้า​เป๋น​ไป​ได้ ขอ​หื้อ​ถ้วย​แห่ง​ความ​ตุ๊กยาก​นี้​ป๊น​ไป​จาก​ข้า​พระองค์​เหีย​เต๊อะ แต่​ขอ​หื้อ​เป๋น​ไป​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์​บ่﻿ใจ้​ของ​ข้า​พระองค์” ");
INSERT INTO nod_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","แล้ว​พระองค์​เตียว​ปิ๊ก​มา​หา​สาวก​สาม​คน​นั้น​ตี้​นั่ง​ถ้า​อยู่​หั้น ก็​หัน​หมู่​เขา​ก่ำลัง​นอน​หลับ​อยู่ ก็​ถาม​เปโตร​ว่า “หมู่​ต้าน​นั่ง​เฝ้า​เฮา​สัก​จั้วโมง​บ่﻿ได้​กา ");
INSERT INTO nod_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","หื้อ​เฝ้า​หละวัง​กับ​อธิษฐาน​ตวย เปื้อ​ว่า​ต้าน​จะ​บ่﻿ตก​อยู่​ใน​อำนาจ​ของ​ก๋าน​ลองใจ๋ เถิง​แม้​ว่า​จิตใจ๋​ฝ่าย​วิญญาณ​ใค่​ยอม​เยียะ แต่​ตั๋ว​ของ​คน​เฮา​ยัง​อ่อนแอ​อยู่” ");
INSERT INTO nod_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","พระองค์​ปิ๊ก​ไป​อธิษฐาน​แหม​เป๋น​เตื้อ​ตี้​สอง​ว่า “ข้า​แต่​พระบิดา ถ้า​ถ้วย​แห่ง​ความ​ตุ๊กยาก​นี้​ป๊น​ไป​บ่﻿ได้ จ๋ำเป๋น​ต้อง​กิ๋น​แต๊﻿ๆ ก็​ขอ​หื้อ​เป๋น​ไป​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","จาก​นั้น​พระองค์​ก็​มา​หา​สาวก​สาม​คน​นั้น​แหม ก็​หัน​หมู่​เขา​ยัง​หลับ​อยู่ ย้อน​ว่า​หมู่​เขา​มืน​ต๋า​บ่﻿ขึ้น ");
INSERT INTO nod_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","พระเยซู​ก็​ละ​เขา​ไป​อธิษฐาน​เหมือน​สอง​เตื้อ​ตี้​ผ่าน​มา ");
INSERT INTO nod_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","จาก​นั้น​พระองค์​มา​หา​หมู่​สาวก อู้​ว่า “ยัง​หลับ​หื้อ​หาย​อิด​อยู่​แหม​กา ใก้​จะ​เถิง​เวลา​ตี้​บุตรมนุษย์​จะ​ถูก​หักหลัง​ยก​หื้อ​หมู่​คน​บาป​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ลุก​ขึ้น​ไป​กั๋น​เต๊อะ คน​ตี้​หักหลัง​เฮา​มา​แผว​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","บ่ากอง​พระเยซู​อู้​ลิ้น​ยัง​บ่﻿ตัน​เข้า​ปาก​เตื้อ ยูดาส​ตี้​เป๋น​สาวก​คน​นึ่ง​ใน​สิบ​สอง​คน​นั้น ก็​เตียว​มา​เถิง​ตวย​กั๋น กับ​คน​จ๋ำนวน​นัก​ตี้​ก๋ำ​ดาบ​ก๋ำ​ค้อน​มา​ตวย หมู่​เขา​เป๋น​คน​ตี้​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​ของ​คน​ตังหลาย​ส่ง​มา ");
INSERT INTO nod_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ยูดาส​ได้​ตกลง​กับ​คน​หมู่​นั้น​ไว้​ก่อน​แล้ว​ว่า “เฮา​จูบ​คน​ใด ก็​แม่น​คน​นั้น หื้อ​ไป​ยับ​เขา​ได้​เลย” ");
INSERT INTO nod_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","เมื่อ​มา​แผว ยูดาส​ก็​เข้า​มา​หา​พระเยซู​เวย​บ่า​ค้าน แล้ว​อู้​กับ​พระองค์​ว่า “อาจ๋ารย์​ครับ” แล้ว​ก็​จูบ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","พระเยซู​อู้​กับ​เขา​ว่า “เปื้อน​เหย จะ​เยียะ​อะหยัง​ก็​ขะใจ๋​เยียะ​เหีย” แล้ว​คน​หมู่​นั้น​ก็​เข้า​มา​ยับ​พระองค์​กุม​ตั๋ว​ไว้ ");
INSERT INTO nod_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","สาวก​คน​นึ่ง​ตี้​อยู่​กับ​พระเยซู​ก็​จั๊ก​ดาบ​ออก​มา​ฟัน​ถูก​หู​คน​ฮับใจ๊​ของ​มหา​ปุโรหิต​ปุด ");
INSERT INTO nod_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","พระเยซู​อู้​กับ​เขา​ว่า “เก็บ​ดาบ​ใส่​ฝัก​เหีย​เต๊อะ ย้อน​ว่า​คน​ตี้​ใจ๊​ดาบ​ก็​จะ​ต๋าย​ย้อน​ดาบ ");
INSERT INTO nod_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ต้าน​กึ๊ด​ว่า​เฮา​จะ​ขอ​ความ​จ้วยเหลือ​จาก​พระบิดา​เฮา แล้ว​พระองค์​จะ​ส่ง​ทูตสวรรค์​มา​หื้อ​กับ​เฮา​นัก​เหลือ​สิบ​สอง​ก๋อง​ตันที​บ่﻿ได้​กา ");
INSERT INTO nod_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","แต่​ถ้า​เฮา​เยียะ​จาอั้น ก็​จะ​บ่﻿เป๋น​ไป​ต๋าม​ตี้​พระคัมภีร์​เขียน​ไว้​ว่า​จะ​ต้อง​เป๋น​ไป​ต๋าม​นี้” ");
INSERT INTO nod_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","พระเยซู​อู้​กับ​คน​หมู่​นั้น​ว่า “หมู่​เจ้า​หัน​เฮา​เป๋น​โจ๋ร​กา เถิง​ได้​ก๋ำ​ดาบ​ก๋ำ​ค้อน​มา​ยับ​เฮา เฮา​นั่ง​สั่ง​สอน​อยู่​ใน​พระวิหาร​กู้​วัน ต้าน​ตังหลาย​ก็​บ่﻿มา​ยับ​เฮา ");
INSERT INTO nod_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","แต่​ตี้​เกิด​ขึ้น​ตึงหมด​นี้ ก็​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​เขียน​ไว้” แล้ว​หมู่​สาวก​ตึง​หมด​ก็​ละ​ขว้าง​พระองค์​แล้ว​ปา​กั๋น​หนี​ไป ");
INSERT INTO nod_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","หมู่​ตี้​ปา​กั๋น​มา​ยับ​พระเยซู​นั้น ปา​พระองค์​ไป​ตี้​บ้าน​ของ​คายาฟาส​มหา​ปุโรหิต ตี้​หั้น​มี​หมู่​ธรรมาจ๋ารย์ กับ​หมู่​คน​เฒ่า​คน​แก่​มา​จุมนุม​กั๋น​อยู่ ");
INSERT INTO nod_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ส่วน​เปโตร​เตียว​ถ่อม​ตวย​พระเยซู​ไป​ห่าง﻿ๆ มา​จ๋น​เข้า​ไป​แผว​ก๋าง​ข่วง​บ้าน​ของ​มหา​ปุโรหิต เขา​เข้า​ไป​นั่ง​ก๋าง​ข่วง​บ้าน​กับ​หมู่​ยาม แน​ผ่อ​ว่า​จะ​มี​อะหยัง​เกิด​ขึ้น​พ่อง ");
INSERT INTO nod_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​สมาชิก​สภา​จาว​ยิว​ปา​กั๋น​เซาะ​หา​พยาน​เท็จ​มา​ใส่ฮ้าย​พระเยซู เปื้อ​จะ​ฆ่า​พระองค์​เหีย ");
INSERT INTO nod_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","เถิง​แม้​จะ​มี​พยาน​เท็จ​หลาย​คน แต่​หมู่​เขา​ก็​หา​หลักฐาน​ตี้​ดี​ปอ​บ่﻿ได้ แล้ว​ใน​ตี้​สุด​ก็​มี​สอง​คน​มา​หื้อ​ก๋าน​ว่า ");
INSERT INTO nod_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“เยซู​คน​นี้​เกย​อู้​ว่า ‘เฮา​สามารถ​ตุ๊บ​พระวิหาร​ของ​พระเจ้า​ขว้าง​ได้ แล้ว​แป๋ง​ขึ้น​มา​ใหม่​ภาย​ใน​สาม​วัน’ ” ");
INSERT INTO nod_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","มหา​ปุโรหิต​จึง​ลุก​ยืน​ขึ้น​ถาม​พระเยซู​ว่า “ต้าน​จะ​บ่﻿แก้​ตั๋ว​ใน​กำ​กล่าวหา​ตี้​หมู่​เขา​ว่า​มา​นี่​พ่อง​กา” ");
INSERT INTO nod_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","แต่​พระเยซู​ดัก​อยู่ มหา​ปุโรหิต​ก็​อู้​กับ​พระองค์​ว่า “ขอ​ต้าน​สาบาน​ใน​นาม​พระเจ้า​ตี้​มี​จีวิต​อยู่ ขอ​หื้อ​บอก​หมู่​เฮา​มา​เต๊อะ​ว่า ต้าน​เป๋น​พระคริสต์พระบุตร​ของ​พระเจ้า​จาอั้น​กา” ");
INSERT INTO nod_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","พระเยซู​ตอบ​เขา​ว่า “อู้​ถูก​แล้ว แต่​เฮา​จะ​บอก​หื้อ​ฮู้​แหม​ว่า ตั้งแต่​นี้​ไป ต้าน​ตังหลาย​จะ​ได้​หัน​บุตรมนุษย์​นั่ง​ตัง​เผิก​ขวา​ของ​พระเจ้า​ผู้​มี​ฤทธิ์​อำนาจ กับ​จะ​ลง​มา​บน​เมฆ​ใน​ฟ้า​สวรรค์” ");
INSERT INTO nod_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","มหา​ปุโรหิต​ก็​ฉีก​เสื้อผ้า​ของ​ตั๋ว​เก่า​อู้​ว่า “เขา​อู้​หมิ่น​ประมาท​พระเจ้า เฮา​บ่﻿ต้อง​มี​พยาน​อะหยัง​แหม หัน​ก่อ ต้าน​ตังหลาย​ก็​ได้ยิน​เขา​อู้​หมิ่น​ประมาท​พระเจ้า​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","“หมู่​ต้าน​กึ๊ด​จาใด​พ่อง” หมู่​เขา​ตอบ​ว่า “เปิง​ฮับ​โต้ษ​เถิง​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","หมู่​เขา​ก็​ถ่ม​น้ำลาย​ใส่​หน้า​พระองค์ กับ​บุบ​ตี๋​พระองค์ คน​อื่น﻿ๆ ปา​กั๋น​ตบ​หน้า​พระองค์​ตวย ");
INSERT INTO nod_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","อู้​หย้อ​ว่า “พระคริสต์​ตวาย​มา​กำ​ลอ​ว่า ใผ​ตบ​หน้า​เจ้า” ");
INSERT INTO nod_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ต๋อน​ตี้​เปโตร​ก่ำลัง​นั่ง​อยู่​ตี้​ก๋าง​ข่วง​บ้าน มี​สาวใจ๊​คน​นึ่ง​เข้า​มา​ตั๊ก​ว่า “ต้าน​ก็​อยู่​ตวย​เยซู​จาว​กาลิลี​ตวย​บ่﻿ใจ้​กา” ");
INSERT INTO nod_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","แต่​เปโตร​ปฏิเสธ​ต่อหน้า​คน​ตังหลาย​ว่า “ตี้​เจ้า​อู้​นั้น​เฮา​บ่﻿ฮู้​เรื่อง​ลอ” ");
INSERT INTO nod_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","แล้ว​เปโตร​ก็​เตียว​ออก​ไป​ตี้​ปะตู๋​ฮั้ว​บ้าน สาวใจ๊​แหม​คน​หัน​ใส่​ก็​บอก​กับ​คน​ตังหลาย​ตี้​อยู่​ตั๊ด​หั้น​ว่า “คน​นี้​อยู่​กับ​เยซู​จาว​นาซาเร็ธ​ตวย​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","เปโตร​ปฏิเสธ​แหม​ว่า “เฮา​สาบาน​ได้​เลย​ว่า​เฮา​บ่﻿เกย​ฮู้จัก​จาย​คน​นั้น​เลย” ");
INSERT INTO nod_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ต่อ​มา​สัก​กำ​นึ่ง คน​ตี้​ยืน​อยู่​ตี้​หั้น​ก็​เตียว​เข้า​มา​หา​เปโตร​อู้​ว่า “เจ้า​เป๋น​คน​นึ่ง​ใน​หมู่​นั้น​แน่﻿ๆ ฟัง​สำเนียง​ของ​เจ้า​ก็​ฮู้​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","เปโตร​ก็​อู้​ว่า “สาบาน​ก็​ได้​ว่า​ข้า​อู้​แต๊ ข้า​บ่﻿เกย​ฮู้จัก​เขา ขอ​หื้อ​พระเจ้า​ลงโต้ษ​เต๊อะ​ถ้า​ข้า​จุ” แล้ว​ไก่​ก็​ขัน​ขึ้น​มา​ตัน​กำ​เดียว​นั้น ");
INSERT INTO nod_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","เปโตร​ก็​เลย​กึ๊ด​เถิง​กำ​อู้​ตี้​พระเยซู​เกย​บอก​เขา​ว่า “ก่อน​ไก่​ขัน ต้าน​จะ​บอก​ว่า​บ่﻿ฮู้จัก​เฮา​เถิง​สาม​เตื้อ” เปโตร​ก็​ออก​ไป​ตัง​นอก แล้ว​ไห้​เสียใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","เถิง​ต๋อน​เจ๊ามืด หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​ตึงหมด​ได้​ตัดสินใจ๋​กั๋น​ว่า​พระเยซู​สมควร​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","หมู่​เขา​มัด​พระเยซู​แล้ว​ปา​ไป​มอบ​หื้อ​ปีลาต​ตี้​เป๋น​เจ้าเมือง ");
INSERT INTO nod_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","เมื่อ​ยูดาส อิสคาริโอท คน​ตี้​หักหลัง​พระเยซู หัน​ว่า​พระเยซู​ถูก​ตัดสิน​ลงโต้ษ​เถิง​ต๋าย ก็​กิ๋นแหนง​ขนาด เขา​เอา​สตางค์​สาม​สิบ​เหรียญ​เงิน​ตี้​ได้ มา​คืน​หื้อ​กับ​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่ ");
INSERT INTO nod_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","อู้​ว่า “เฮา​ได้​เยียะ​บาป​ไป​แล้ว​ตี้​ได้​หักหลัง​ผู้​บริสุทธิ์​คน​นึ่ง​เถิง​ต๋าย” หมู่​มหา​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​ตอบ​ว่า “เรื่อง​นี้​เกี่ยว​อะหยัง​กับ​เฮา​ตวย เป๋น​เรื่อง​ของ​เจ้า​คน​เดียว​ตี้​ต้อง​ฮับผิดชอบ” ");
INSERT INTO nod_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ยูดาส​เอา​สตางค์​นั้น​ก๋ำปือ​เข้า​ไป​ใน​พระวิหาร แล้ว​ก็​ออก​ไป​แขวน​คอ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","หมู่​หัวหน้า​ปุโรหิต​ก็​เก็บ​สตางค์​นั้น​มา อู้​ว่า “เป๋น​ก๋าน​ผิด​บท​บัญญัติ​ตี้​จะ​เอา​สตางค์​จาอี้​เก็บ​ไว้​ใน​คลัง​พระวิหาร ย้อน​เป๋น​สตางค์​เปื้อน​เลือด” ");
INSERT INTO nod_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","หมู่​เขา​ตัดสินใจ๋​เอา​สตางค์​นั้น​ไป​ซื้อ​ตี้​นา​ของ​สล่า​ปั้น​หม้อ เปื้อ​เอา​ไว้​เป๋น​ตี้​ฝัง​ศพ​คน​ต่าง​บ้าน​ต่าง​เมือง ");
INSERT INTO nod_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ตี้​ตั๊ด​หั้น​เลย​ฮ้อง​ว่า “นา​เลือด” มา​เต๊า​ฮอด​เถิง​วัน​นี้ ");
INSERT INTO nod_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","แล้ว​ก็​เป๋น​ไป​ต๋าม​ตี้​เยเรมีย์ ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​อู้​ไว้​ว่า “หมู่​เขา​เอา​สตางค์​สาม​สิบ​เหรียญ​เงิน ตี้​เป๋น​ก้า​หัว​ของ​คน​นั้น​ต๋าม​ตี้​จาว​อิสราเอล​ตั้ง​หื้อ ");
INSERT INTO nod_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","เอา​ไป​ซื้อ​นา​ของ​สล่า​ปั้น​หม้อ ต๋าม​ตี้​องค์​พระผู้เป๋นเจ้า​ได้​สั่ง​ไว้” ");
INSERT INTO nod_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","หมู่​เขา​ปา​พระเยซู​ไป​ยืน​อยู่​ต่อหน้า​เจ้าเมือง​ปีลาต ปีลาต​ถาม​พระเยซู​ว่า “ต้าน​เป๋น​กษัตริย์​ของ​จาว​ยิว​กา” พระองค์​ก็​ตอบ​ว่า “ต้าน​อู้​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","แต่​เมื่อ​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​ใส่​ความ​พระเยซู พระองค์​บ่﻿ได้​ตอบ​อะหยัง​หมู่​เขา​สัก​กำเดียว​เลย ");
INSERT INTO nod_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ปีลาต​ถาม​พระองค์​ว่า “ต้าน​บ่﻿ได้ยิน​ข้อหา​ตึงหมด​ตี้​เขา​ว่า​หื้อ​ต้าน​กา” ");
INSERT INTO nod_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","แต่​พระเยซู​บ่﻿ตอบ​กาว่า​แก้​ตั๋ว​สัก​กำ ปีลาต​ก็​งืด​ขนาด ");
INSERT INTO nod_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","เป๋น​ธรรมเนียม​ใน​หละหว่าง​งาน​ปัสกา ตี้​เจ้าเมือง​จะ​ป่อย​นักโต้ษ​คน​นึ่ง​ต๋าม​ตี้​คน​ตังหลาย​เลือก ");
INSERT INTO nod_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ต๋อน​นั้น​มี​นักโต้ษ​ตี้​มี​จื้อ​เสียง​ดัง​คน​นึ่ง​จื้อ​บารับบัส ");
INSERT INTO nod_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","เมื่อ​คน​ตังหลาย​มา​จุมนุม​กั๋น​แล้ว ปีลาต​ก็​ถาม​หมู่​เขา​ว่า “ใค่​หื้อ​เฮา​ป่อย​ใผ​หละหว่าง​บารับบัส กับ​เยซู​ตี้​ฮ้อง​กั๋น​ว่า​พระคริสต์” ");
INSERT INTO nod_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ปีลาต​ฮู้​ว่า​ตี้​ผู้นำ​จาว​ยิว​ยับ​พระเยซู​มา​หื้อ​ต้าน​ตัดสิน​ก็​ย้อน​ขอย​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ต๋อน​ตี้​ปีลาต​นั่ง​อยู่​บน​ตี้​นั่ง​ของ​ผู้​พิพากษา เมีย​ของ​ต้าน​ใจ๊​คน​มา​บอก​ว่า “ห้าม​ยุ่ง​กับ​จาย​คน​นี้ ต้าน​เป๋น​คน​บ่﻿มี​ความ​ผิด ตะคืน​ข้าเจ้า​ฝัน​ฮ้าย​บ่﻿สบายใจ๋​ขนาด​เกี่ยว​กับ​ต้าน​คน​นี้” ");
INSERT INTO nod_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","แต่​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​อู้​สุ่ย​คน​ตังหลาย​หื้อ​ปีลาต​ป่อย​บารับบัส แล้ว​หื้อ​ฆ่า​พระเยซู​เหีย ");
INSERT INTO nod_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","เจ้าเมือง​ถาม​คน​ตังหลาย​แหม​ว่า “สอง​คน​นี้​จะ​หื้อ​ป่อย​ใผ​ดี” คน​ตังหลาย​เอิ้น​ตอบ​ว่า “บารับบัส” ");
INSERT INTO nod_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ปีลาต​ถาม​ว่า “แล้ว​เยซู​คน​ตี้​ฮ้อง​กั๋น​ว่า​พระคริสต์​นี้​ลอ จะ​หื้อ​เฮา​เยียะ​จาใด” หมู่​เขา​กู้​คน​เอิ้น​ตอบ​ว่า “เขิง​บน​ไม้​ก๋าง​เขน” ");
INSERT INTO nod_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ปีลาต​ก็​ถาม​ว่า “เขิง​เขา​เยียะ​หยัง เขา​เยียะ​อะหยัง​ผิด” แต่​คน​ตังหลาย​เอิ้น​เสียง​ดัง​ขึ้น​ติก﻿ๆ ว่า “เขิง​บน​ไม้​ก๋าง​เขน” ");
INSERT INTO nod_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","เมื่อ​ปีลาต​หัน​ว่า​เยียะ​อะหยัง​บ่﻿ได้​นัก​เหลือ​นี้​แล้ว กำ​เดียว​จะ​เกิด​วุ่นวาย​ขึ้น เขา​ก็​เอา​น้ำ​ซ่วย​มือ​ส่อง​หน้า​คน​ตังหลาย​อู้​ว่า “ก๋าน​ต๋าย​ของ​จาย​คน​นี้ เฮา​บ่﻿เกี่ยว เฮา​บ่﻿มี​ความ​ผิด​เน่อ หมู่​ต้าน​ฮับ​ผิด​กั๋น​คน​เดียว​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","คน​ตังหลาย​ตอบ​ว่า “หมู่​เฮา​กับ​ลูก﻿ๆ ของ​เฮา​จะ​ฮับผิดชอบ​เรื่อง​ก๋าน​ต๋าย​ของ​เขา​คน​เดียว” ");
INSERT INTO nod_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ปีลาต​จึง​ป่อย​บารับบัส​หื้อ​หมู่​เขา​ไป จาก​นั้น​ก็​สั่ง​หื้อ​เฆี่ยน​พระเยซู แล้ว​หื้อ​หมู่​ทหาร​เอา​ไป​เขิง​บน​ไม้​ก๋าง​เขน ");
INSERT INTO nod_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","หลัง​จาก​นั้น​หมู่​ทหาร​ของ​ปีลาต​ปา​พระเยซู​เข้า​ไป​ตี้​ศูนย์บัญชาก๋าน​ใหญ่​ของ​โรมัน หมู่​ทหาร​ตึง​ก๋อง​เข้า​มา​แวด​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","หมู่​เขา​แก้​เสื้อ​ของ​พระองค์​ออก แล้ว​เอา​เสื้อ​คุม​สี​แดง​สด​มา​ใส่​แตน ");
INSERT INTO nod_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","หมู่​เขา​เอา​กิ่ง​ไม้​ตี้​มี​หนาม​มา​แป๋ง​เป๋น​มงกุฎ แล้ว​เอา​สุบ​หัว​หื้อ​พระองค์ มือ​ขวา​หื้อ​ก๋ำ​ก้าน​ไม้​อ้อ​ไว้ แล้ว​ขี้แต่ง​คุก​เข่า​ลง​ส่อง​หน้า​พระองค์ เหล้น​หน้า​ว่า “ขอ​กษัตริย์​ของ​จาว​ยิว​จง​จ๋ำเริญ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","แล้ว​ก็​ถ่ม​น้ำลาย​ใส่ เอา​ไม้​อ้อ​นั้น​ฟาด​หัว​พระองค์​หลาย​กำ ");
INSERT INTO nod_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","เมื่อ​ดู​แควน​จ๋น​ปอใจ๋​แล้ว หมู่​เขา​ก็​แก้​เสื้อ​คุม​ออก แล้ว​เอา​เสื้อ​ผืน​เก่า​ของ​พระองค์​มา​นุ่ง​หื้อ​ใหม่ แล้ว​ปา​พระองค์​ออก​ไป​เขิง​บน​ไม้​ก๋าง​เขน ");
INSERT INTO nod_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ต๋อน​ตี้​หมู่​เขา​ก่ำลัง​เอา​พระองค์​เตียว​ออก​มา ก็​ปะ​ป้อจาย​คน​นึ่ง​จื้อ​ซีโมน​มา​จาก​เมือง​ไซรีน หมู่​ทหาร​ก็​เข​ซีโมน​แบก​ไม้​ก๋าง​เขน​แตน​พระเยซู​ไป ");
INSERT INTO nod_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","เมื่อ​มา​แผว​ตี้​นึ่ง​ตี้​ฮ้อง​กั๋น​ว่า กลโกธา หมายเถิง เนิน​กระโหล้ง​หัว ");
INSERT INTO nod_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","หมู่​เขา​เอา​เหล้า​องุ่น​สูน​กับ​ดี​ขม​มา​หื้อ แต่​พระองค์​จิม​บ่﻿ดาย​บ่﻿ยอม​กิ๋น ");
INSERT INTO nod_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","เมื่อ​เขา​เขิง​พระองค์​บน​ไม้​ก๋าง​เขน​แล้ว ก็​เอา​เสื้อผ้า​ของ​พระองค์​มา​จก​เบอร์​แบ่ง​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","แล้ว​หมู่​เขา​ก็​นั่ง​เฝ้า​พระเยซู​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","หมู่​เขา​ได้​เขียน​ข้อหา​ติด​ไว้​เลย​หัว​พระเยซู​ขึ้น​ไป​ว่า “คน​นี้​คือ​เยซู กษัตริย์​ของ​จาว​ยิว” ");
INSERT INTO nod_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","มี​โจ๋ร​สอง​คน​ถูก​เขิง​บน​ไม้​ก๋าง​เขน​พร้อม​พระองค์ ตัง​ขวา​คน​นึ่ง​ตัง​ซ้าย​คน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","คน​ตังหลาย​ตี้​เตียว​ก๋าย​ไป​ก๋าย​มา ปา​กั๋น​สว่าย​หน้า​อู้​หยาม​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“เจ้า​เป๋น​คน​ตี้​อู้​ว่า​จะ​ทำลาย​พระวิหาร แล้ว​จะ​แป๋ง​ขึ้น​ใหม่​ใน​สาม​วัน​บ่﻿ใจ้​กา ถ้า​เจ้า​เป๋น​พระบุตร​ของ​พระเจ้า​แต๊ จ้วย​ตั๋ว​เก่า​หื้อ​รอด​ก่อน​เต๊อะ ลง​มา​จาก​ไม้​ก๋าง​เขน​เหีย​แหล่” ");
INSERT INTO nod_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์ กับ​หมู่​คน​เฒ่า​คน​แก่​ปา​กั๋น​เยาะเย้ย​พระองค์​เหมือน​กั๋น​ว่า ");
INSERT INTO nod_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“เขา​จ้วย​จีวิต​คน​อื่น​หื้อ​รอด​ได้ แต่​จ้วย​จีวิต​ตั๋ว​เก่า​บ่﻿ได้ ถ้า​เขา​เป๋น​กษัตริย์​ของ​อิสราเอล​แต๊ หื้อ​ลง​มา​จาก​ไม้​ก๋าง​เขน​บ่าเดี่ยว​นี้​เต๊อะ แล้ว​เฮา​จะ​ได้​เจื้อ ");
INSERT INTO nod_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","เขา​ไว้​ใจ๋​พระเจ้า ถ้า​พระเจ้า​ต้องก๋าน​จ้วย​จีวิต​เขา ก็​หื้อ​พระเจ้า​จ้วย​เขา​บ่าเดี่ยว​นี้ ย้อน​เขา​อู้​ว่า ‘เฮา​เป๋น​พระบุตร​ของ​พระเจ้า’ ” ");
INSERT INTO nod_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","โจ๋ร​สอง​คน​ตี้​ถูก​เขิง​ตวย​พระองค์​นั้น ก็​อู้​ถ่อยจ๊า​ใส่​พระองค์​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ตั้งแต่​ต๋อน​เตี้ยง​วัน ก็​มืด​ไป​ใคว่​แผ่นดิน​จ๋น​เถิง​บ่าย​สาม​โมง ");
INSERT INTO nod_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ประมาณ​บ่าย​สาม​โมง​พระเยซู​ฮ้อง​เสียง​ดัง​ว่า “เอลี เอลี ลามา สะบัก ธานี” แป๋​ว่า “พระเจ้า​ของ​ข้า​พระองค์ พระเจ้า​ของ​ข้า​พระองค์ เป๋น​จาใด​พระองค์​มา​ละ​ข้า​พระองค์​ไป​เหีย” ");
INSERT INTO nod_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","มี​บาง​คน​ตี้​อยู่​ตี้​หั้น​ได้ยิน​ก็​อู้​กั๋น​ว่า “เขา​ฮ้อง​หา​เอลียาห์” ");
INSERT INTO nod_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","มี​คน​นึ่ง​ใน​หมู่​เขา​ล่น​ไป​เอา​ฟองน้ำ​มา​จุ่ม​เหล้า​องุ่น​ส้ม เสียบ​ป๋าย​ไม้​อ้อ ยื่น​หื้อ​พระเยซู​กิ๋น ");
INSERT INTO nod_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","แต่​คน​อื่น﻿ๆ อู้​กั๋น​ว่า “กำเดียว​ก่อน แน​ผ่อ​ว่า​เอลียาห์​จะ​มา​จ้วย​จีวิต​เขา​ก่อ” ");
INSERT INTO nod_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","เมื่อ​พระเยซู​ฮ้อง​เสียง​ดัง​ขึ้น​แหม​เตื้อ พระองค์​ก็​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","เวลา​กวม​กั๋น​นั้น ผ้ากั้ง​ใน​พระวิหาร​ก็​ฉีก​ออก​เป๋น​สอง​เผิก​ตั้งแต่​ตัง​บน​ลง​ลุ่ม แผ่นดิน​ก็​ไหว บ่าหิน​ก็​บะ​ออก​จาก​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","อุโมงค์​ฝัง​ศพ​เปิด​อ้า​โต้โล้ คน​ของ​พระเจ้า​หลาย​คน​ตี้​ต๋าย​ไป​แล้ว​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","คน​ต๋าย​หมู่​นั้น​เตียว​ออก​มา​จาก​อุโมงค์​ฝัง​ศพ หลังจาก​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว ปา​กั๋น​เข้า​ไป​ใน​กรุง​เยรูซาเล็ม ตี้​หั้น​หลาย​คน​หัน​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","เมื่อ​นายร้อย​กับ​หมู่​ทหาร​ตี้​เฝ้า​พระเยซู​อยู่​หัน​แผ่นดิน​ไหว​กับ​เหตุก๋ารณ์​ตึงหมด​ตี้​เกิด​ขึ้น ก็​กั๋ว​กั๋น​ขนาด อู้​ว่า “แต๊﻿ๆ แล้ว​ต้าน​คน​นี้​เป๋น​พระบุตร​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","มี​แม่ญิง​หลาย​คน​ยืน​ผ่อ​อยู่​ไก๋﻿ๆ หมู่​นาง​เกย​ติดต๋าม​ผ่อกอย​พระเยซู​มา​จาก​กาลิลี ");
INSERT INTO nod_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ใน​คน​หมู่​นั้น​มี​มารีย์​จาว​เมือง​มักดาลา มารีย์​แม่​ของ​ยากอบ​กับ​โยเซฟ ตึง​แม่​ของ​ยากอบ​กับ​ยอห์น​ลูกบ่าว​เศเบดี ");
INSERT INTO nod_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","เมื่อ​เถิง​ต๋อน​เมื่อแลง มี​เศรษฐี​คน​นึ่ง​จาก​เมือง​อาริมาเธีย​จื้อ​โยเซฟ เป๋น​สาวก​คน​นึ่ง​ของ​พระเยซู​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","เข้า​ไป​หา​ปีลาต​เปื้อ​ขอ​ศพ​พระเยซู ปีลาต​ก็​สั่ง​หื้อ​ทหาร​เอา​ศพ​พระเยซู​หื้อ​โยเซฟ ");
INSERT INTO nod_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","โยเซฟ​เอา​ศพ​พระองค์​ไป กับ​เอา​ผ้า​ลินิน​สะอาด​ปัน​ศพ​ไว้ ");
INSERT INTO nod_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","แล้ว​เอา​ศพ​ไป​ไว้​ใน​อุโมงค์​ฝัง​ศพ​ใหม่​ของ​เขา ตี้​เจาะ​เข้า​ไป​ใน​หิน แล้ว​กิ้ง​บ่าหิน​แผ่น​ใหญ่​มา​ตึด​ปาก​อุโมงค์​ไว้​เหีย เสร็จ​แล้ว​เขา​ก็​ไป ");
INSERT INTO nod_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","มารีย์​จาว​มักดาลา​กับ​มารีย์​แหม​คน​นึ่ง ผก​ผ่อ​แหม​เผิก​นึ่ง​ของ​อุโมงค์​ฝัง​ศพ ");
INSERT INTO nod_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ต๋อน​เจ๊า​ถัด​มา​แหม​วัน​นึ่ง​เป๋น​วัน​สะบาโต หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ฟาริสี​มา​ปะ​ปีลาต ");
INSERT INTO nod_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","บอก​ต้าน​ว่า “หมู่​เฮา​จ๋ำ​ได้​ว่า คน​ขี้​จุ​หลอกลวง​คน​นั้น​เกย​อู้​ไว้​ต๋อน​ตี้​ยัง​มี​จีวิต​ว่า ‘หลัง​จาก​ต๋าย​ได้​สาม​วัน เฮา​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย’ ");
INSERT INTO nod_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ย้อน​จาอั้น ขอ​จ้วย​สั่ง​ทหาร​ไป​เฝ้า​ตี้​อุโมงค์​ฝัง​ศพ​หื้อ​แน่นหนา​ตวย​เต๊อะ เฝ้า​ไว้​จ๋น​เถิง​วัน​ตี้​สาม บ่﻿แน่​ว่า​หมู่​สาวก​ของ​เขา​อาจ​จะ​มา​ลัก​เอา​ศพ​ไป แล้ว​บอก​กับ​คน​ตังหลาย​ว่า ‘เขา​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว’ ต๋อน​หั้น​ก๋าน​หลอกลวง​เตื้อ​นี้​จะ​ฮ้าย​เหลือ​เตื้อ​เก๊าหัวที​แหม​ก่อน” ");
INSERT INTO nod_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ปีลาต​บอก​หมู่​เขา​ว่า “เอา​ทหาร​ไป​เป๋น​ยาม​เฝ้า​ตี้​อุโมงค์​ฝัง​ศพ​หื้อ​แน่นหนา เต้า​ตี้​หมู่​ต้าน​จะ​เยียะ​ได้” ");
INSERT INTO nod_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ย้อน​จาอั้น​หมู่​เขา​ก็​ไป​เยียะ​หื้อ​อุโมงค์​ฝัง​ศพ​แน่น​ขึ้น โดย​จ้ำ​ก๋า​ไว้​บน​บ่าหิน​ตี้​ตึด​ปาก​ตาง​เข้า​อุโมงค์ กับ​วาง​เวร​ยาม​เฝ้า​ตวย ");
INSERT INTO nod_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","หลัง​วัน​สะบาโต​ป๊น​ไป​แล้ว ต๋อน​เจ๊า​มืด​ของ​วัน​ติ๊ด มารีย์​จาว​มักดาลา กับ​มารีย์​แหม​คน​นึ่ง​ปา​กั๋น​ไป​ผ่อ​อุโมงค์​ฝัง​ศพ ");
INSERT INTO nod_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ใน​ต๋อน​นั้น​เกิด​แผ่นดิน​ไหว​แฮง​ขนาด ย้อน​ว่า​มี​ทูตสวรรค์​ของ​พระเจ้า​องค์​นึ่ง​ลง​มา​จาก​สวรรค์​กิ้ง​บ่าหิน​ออก​จาก​ปาก​อุโมงค์ แล้ว​นั่ง​บน​บ่าหิน​นั้น ");
INSERT INTO nod_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ตั๋ว​ของ​ทูตสวรรค์​แจ้ง​หลึ้ง​เหมือน​ฟ้า​แมบ เสื้อผ้า​ตี้​นุ่ง​สี​ขาว​เหมือน​หิมะ ");
INSERT INTO nod_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ทหาร​ยาม​หัน​ทูตสวรรค์​ของ​องค์​พระผู้เป๋นเจ้า​ก็​กั๋ว​จ๋น​ตั๋ว​สั่น​ถาบ﻿ๆ แล้ว​โก้น​ลง​ซื่อ​เกิ็กเดิ็ก​เหมือน​คน​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ทูตสวรรค์​องค์​นั้น​อู้​กับ​แม่ญิง​สอง​คน​นั้น​ว่า “บ่﻿ถ้า​กั๋ว​เน่อ เฮา​ฮู้​ว่า​หมู่​เจ้า​มา​หา​พระเยซู​ตี้​ถูก​เขิง​บน​ไม้​ก๋าง​เขน ");
INSERT INTO nod_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","พระองค์​บ่﻿ได้​อยู่​ตี้​นี่ พระเจ้า​เยียะ​หื้อ​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย​เหมือน​ตี้​ได้​อู้​ไว้​แล้ว เข้า​มา​ผ่อ​ตี้​วาง​ศพ​ของ​พระองค์​แหล่ ");
INSERT INTO nod_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","แล้ว​ขะใจ๋​ไป​บอก​หมู่​สาวก​ของ​พระองค์​เน่อ​ว่า ‘พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว ต๋อน​นี้​ก่ำลัง​ไป​แคว้น​กาลิลี​ก่อน​หน้า​ต้าน​ตังหลาย ต้าน​ตังหลาย​จะ​หัน​พระองค์​ตี้​หั้น’ เฮา​บอก​หมู่​เจ้า​แล้ว​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","แม่ญิง​ตึง​สอง​คน​ก็​ฟั่ง​ออก​จาก​อุโมงค์ หมู่​นาง​กั๋ว​แต่​ก็​ดีใจ๋​ขนาด ล่น​ไป​บอก​หมู่​สาวก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","จู่﻿ๆ พระเยซู​ก็​มา​ปะ​แม่ญิง​สอง​คน​นี้ ตั๊ก​หมู่​นาง ตึง​สอง​คน​ก็​เข้า​มา​กอด​ตี๋น​พระองค์​แล้ว​นมัสก๋าน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","พระเยซู​อู้​กับ​นาง​ว่า “บ่﻿ถ้า​กั๋ว หื้อ​ไป​บอก​หมู่​ปี้น้อง​ตี้​เป๋น​สาวก​ของ​เฮา​หื้อ​ปา​กั๋น​ไป​แคว้น​กาลิลี​เต๊อะ แล้ว​จะ​หัน​เฮา​ตี้​ปู๊น” ");
INSERT INTO nod_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ต๋อน​ตี้​แม่ญิง​ตึง​สอง​คน​ก่ำลัง​เตียว​ไป​นั้น ทหาร​ยาม​บาง​คน​ก็​เข้า​มา​ใน​เมือง เล่า​เรื่อง​ตี้​เกิด​ขึ้น​ตึง​หมด​หื้อ​หมู่​หัวหน้า​ปุโรหิต​ฟัง ");
INSERT INTO nod_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","เมื่อ​หมู่​หัวหน้า​ปุโรหิต​หารือ​วางแผน​กับ​หมู่​คน​เฒ่า​คน​แก่​แล้ว หมู่​เขา​ก็​เอา​สตางค์​หื้อ​หมู่​ทหาร​ยาม​จ๋ำนวน​นัก ");
INSERT INTO nod_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","สั่ง​ว่า “หมู่​เจ้า​จะ​ต้อง​อู้​ว่า ‘หมู่​สาวก​ของ​เยซู​มา​ต๋อน​เมื่อ​คืน แล้ว​ลัก​เอา​ศพ​ไป ต๋อน​ตี้​ทหาร​ยาม​ก่ำลัง​หลับ’ ");
INSERT INTO nod_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ถ้า​เจ้าเมือง​ฮู้​เรื่อง​นี้ หมู่​เฮา​จะ​อู้​แตน หมู่​เจ้า​จะ​บ่﻿เดือด​ฮ้อน” ");
INSERT INTO nod_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","หมู่​ทหาร​ฮับ​สตางค์​ไป​แล้ว​ก็​เยียะ​ตวย​ต๋าม​นั้น หมู่​จาว​ยิว​ก็​ยัง​เล่าลือ​เรื่อง​นี้​จ๋น​แผว​ตึง​วัน​นี้ ");
INSERT INTO nod_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","หมู่​สาวก​ตี้​เหลือ​สิบ​เอ็ด​คน​ก็​ปา​กั๋น​ไป​แคว้น​กาลิลี แล้ว​ขึ้น​ไป​บน​ดอย​ตี้​พระเยซู​บอก ");
INSERT INTO nod_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","เมื่อ​หัน​พระเยซู​ก็​ปา​กั๋น​นมัสก๋าน​พระองค์ แต่​มี​บาง​คน​อิกขะหลิก​ใน​ใจ๋ ");
INSERT INTO nod_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","พระเยซู​เข้า​มา​หา​หมู่​เขา อู้​ว่า “พระเจ้า​มอบ​สิทธิ​อำนาจ​ตึงหมด​ใน​สวรรค์​กับ​แผ่นดิน​โลก​ไว้​กับ​เฮา​แล้ว ");
INSERT INTO nod_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ย้อน​จาอี้ หื้อ​หมู่​ต้าน​ไป​สอน​คน​กู้​จ้าด​หื้อ​เป๋น​สาวก​ของ​เฮา กับ​หื้อ​เขา​ฮับ​บัพติศมา​ใน​นาม​พระบิดา พระบุตร​กับ​พระวิญญาณ​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","สอน​เขา​หื้อ​เจื้อฟัง​กู้​สิ่ง​ตี้​เฮา​ได้​สั่ง​ไว้​กับ​ต้าน ฮู้​ไว้​เต๊อะ​ว่า เฮา​จะ​อยู่​กับ​หมู่​ต้าน​ตลอด​ไป​จ๋น​แผว​วัน​สิ้น​โลก​แต๊﻿ๆ”");
INSERT INTO nod_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ข่าวดี​เรื่อง​พระเยซู​คริสต์​ผู้​เป๋น​บุตร​ของ​พระเจ้าได้​ตั้งเก๊า​จาอี้​ว่า ");
INSERT INTO nod_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ใน​หนังสือ​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​เขียน​ไว้​ว่า “เฮา​จะ​ส่ง​คน​ส่ง​ข่าว​นำ​หน้า​ต้าน​ไป​ก่อน เขา​จะ​เกียม​คน​หื้อ​พร้อม​ก่อน​ต้าน​มา” ");
INSERT INTO nod_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“มี​เสียง​ฮ้อง​เอิ้น​ของ​คน​นึ่ง​ใน​ดินแดน​ทุรกั๋นดาร​ว่า ‘เกียม​ใจ๋​หื้อ​พร้อม​สำหรับ​ก๋าน​เข้า​มา​ของ​องค์​พระ​ผู้​เป๋น​เจ้า จง​แป๋ง​หน​ตาง​ซื่อ﻿ๆ หื้อ​พระองค์’ ” ");
INSERT INTO nod_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","คน​ส่ง​ข่าว​นี้​คือ​ยอห์น​ผู้​หื้อ​บัพติศมา ต้าน​ผด​มา​ใน​ดินแดน​ทุรกั๋นดาร ต้าน​บอก​หื้อ​คน​กลับใจ๋​จาก​บาป แล้ว​ฮับ​บัพติศมา เปื้อ​พระเจ้า​จะ​ยกโต้ษ​บาป​หื้อ ");
INSERT INTO nod_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","คน​ตังหลาย​ตี้​มา​จาก​กรุง​เยรูซาเล็ม​กับ​คน​ตี้​มา​จาก​แคว้น​ยูเดีย​ปา​กั๋น​มา​ฟัง​ยอห์น​เตสนา เมื่อ​หมู่​เขา​สารภาพ​บาป​แล้ว ยอห์น​ก็​หื้อ​หมู่​เขา​ฮับ​บัพติศมา​ใน​แม่น้ำ​จอร์แดน ");
INSERT INTO nod_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ยอห์น​อยู่​ใน​ดินแดน​ทุรกั๋นดาร เขา​ใจ๊​จีวิต​อย่าง​เรียบ​ง่าย นุ่ง​เสื้อผ้า​ตี้​แป๋ง​จาก​ขน​อูฐ มี​สายฮ้าง​หนัง​มัด​แอว​แบบ​เดียว​กับ​เอลียาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ใน​สมัย​โบราณ กิ๋น​จั๊กแต๋น​กับ​น้ำเผิ้ง​ป่า​เป๋น​อาหาร ");
INSERT INTO nod_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ยอห์น​บอก​หื้อ​ฮู้​ว่า “จะ​มี​คน​นึ่ง​มา​เมื่อ​ลูน​เฮา ต้าน​ผู้​นั้น​จะ​ยิ่งใหญ่​เหลือ​เฮา แม้แต่​แก้​สาย​มัด​เกิบ​ของ​ต้าน ตั๋ว​เฮา​ยัง​บ่﻿สมควร​จะ​ก้ม​ลง​ไป​เยียะ​จาอั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","เฮา​หื้อ​หมู่​ต้าน​ฮับ​บัพติศมา​ด้วย​น้ำ แต่​ต้าน​ผู้​ตี้​จะ​มา​นั้น​จะ​หื้อ​ฮับ​บัพติศมา​ด้วย​พระวิญญาณ​บริสุทธิ์” ");
INSERT INTO nod_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ใน​ต๋อน​นั้น​พระเยซู​เตียวตาง​มา​จาก​เมือง​นาซาเร็ธ​ใน​แคว้น​กาลิลี แล้ว​ยอห์น​ได้​หื้อ​บัพติศมา​พระองค์​ใน​แม่น้ำ​จอร์แดน ");
INSERT INTO nod_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ต๋อน​ตี้​พระเยซู​ผด​ขึ้น​มา​จาก​น้ำ พระองค์​ก็​หัน​ต๊องฟ้า​แหวก​ออก​เป๋น​ฮ่อม พระวิญญาณ​มี​ฮูปฮ่าง​เหมือน​นกก๋าแก๋​ลง​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","แล้ว​มี​เสียง​จาก​ฟ้า​สวรรค์​ว่า “ต้าน​เป๋น​ลูก​ตี้​เฮา​ฮัก เฮา​เปิงใจ๋​ต้าน​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ตันใด​นั้น​พระวิญญาณ​ก็​ส่ง​พระเยซู​เข้า​ไป​อยู่​ใน​ดินแดน​ทุรกั๋นดาร ");
INSERT INTO nod_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","พระองค์​อยู่​ตี้​หั้น​เป๋น​เวลา​สี่​สิบ​วัน ซาต๋าน​ก็​มา​ลองใจ๋​พระองค์​ตลอด ตี้​หั้น​มี​สัตว์​ป่า หมู่​ทูตสวรรค์​ก็​มา​ผ่อกอย​พระองค์​ตวย ");
INSERT INTO nod_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","หลัง​จาก​ยอห์น​ผู้​หื้อ​บัพติศมา​โดน​ยับ​ขัง​คอก​แล้ว พระเยซู​ก็​ปิ๊ก​ไป​แคว้น​กาลิลี ตั้งเก๊า​เตสนา​สั่ง​สอน​เรื่อง​ข่าวดี​ของ​พระเจ้า​หื้อ​คน​ตี้​หั้น​ว่า ");
INSERT INTO nod_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“เถิง​เวลา​แล้ว แผ่นดิน​ของ​พระเจ้า​ใก้​เข้า​มา​แผว​แล้ว หื้อ​กลับใจ๋​จาก​บาป​เหีย กับ​เจื้อ​ใน​ข่าวดี​ของ​พระเจ้า​นี้​ตวย” ");
INSERT INTO nod_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ต๋อน​ตี้​พระเยซู​เตียว​ไป​ต๋าม​ฮิม​ฝั่ง​ทะเลสาบ​กาลิลี​อยู่​นั้น ก็​หัน​ใส่​คน​หา​ป๋า​สอง​คน​ปี้น้อง​ก่ำลัง​ต้อด​แห​อยู่ คน​อ้าย​จื้อ​ซีโมน คน​น้อง​จื้อ​อันดรูว์ ");
INSERT INTO nod_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","พระองค์​ก็​อู้​กับ​หมู่​เขา​ว่า “ตวย​เฮา​มา​เป๋น​สาวก​เฮา​เต๊อะ เฮา​จะ​สอน​หื้อ​ต้าน​เซาะ​หา​คน​เหมือน​เซาะ​หา​ป๋า” ");
INSERT INTO nod_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ตึง​สอง​คน​ก็​สวะ​แห แล้ว​ปา​กั๋น​ตวย​พระองค์​ไป​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","พระองค์​เตียว​ต่อ​ไป​แหม​น่อย ก็​หัน​ยากอบ​กับ​ยอห์น​น้อง​ของ​เขา ตึง​สอง​คน​เป๋น​ลูกบ่าว​ของ​เศเบดี หมู่​เขา​ก่ำลัง​ซ่อม​แห​อยู่​ใน​เฮือ ");
INSERT INTO nod_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","พระองค์​ฮ้อง​หมู่​เขา​ตึง​สอง​หื้อ​ไป​ตวย​พระองค์ เขา​ก็​ละ​ป้อ​ตึง​หมู่​ลูกจ้าง​ไว้​ใน​เฮือ แล้ว​ตวย​พระองค์​ไป​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","พระเยซู​กับ​หมู่​สาวก​เข้า​ไป​ใน​เมือง​คาเปอรนาอุม เมื่อ​เถิง​วัน​สะบาโต พระองค์​เข้า​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว แล้ว​เตสนา​สั่ง​สอน​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","คน​ตังหลาย​ก็​ปา​กั๋น​งืด​ใน​กำสอน​ของ​พระองค์ ย้อน​ว่า​พระองค์​สอน​อย่าง​ผู้​ตี้​มี​สิทธิ​อำนาจ​แต๊﻿ๆ บ่﻿เหมือน​หมู่​ธรรมาจ๋ารย์ ");
INSERT INTO nod_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","แล้ว​จู่﻿ๆ ก็​มี​ป้อจาย​คน​นึ่ง​ใน​ธรรมศาลา​นั้น​ตี้​มี​ผี​ฮ้าย​เข้า ");
INSERT INTO nod_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ฮ้อง​เสียง​ดัง​ว่า “พระเยซู​จาว​นาซาเร็ธ มา​ยุ่ง​กับ​หมู่​เฮา​เยียะ​หยัง ต้าน​จะ​มา​ทำลาย​หมู่​เฮา​กา เฮา​ฮู้​ว่า​ต้าน​เป๋น​ใผ ต้าน​เป๋น​ผู้​บริสุทธิ์​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","พระเยซู​สั่ง​ผี​นั้น​ว่า “จะ​ไป​ปาก​นัก ออก​มา​จาก​เขา​บ่าเดี่ยว​นี้” ");
INSERT INTO nod_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ผี​ฮ้าย​ก็​เยียะ​หื้อ​ป้อจาย​คน​นั้น​ดิ้น​โจ่ง​ดิ้น​จ่าง​กับ​ฮ้อง​เสียง​ดัง แล้ว​ก็​ออก​จาก​ตั๋ว​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","คน​ตังหลาย​ก็​ปา​กั๋น​งืด​อู้​กั๋น​ว่า “ปาด​โทะ อะหยัง​เป๋น​ล้ำ​เป๋น​เหลือ​เนียะ ต้อง​เป๋น​กำสอน​ใหม่​แน่﻿ๆ มี​สิทธิ​อำนาจ​แต๊﻿ๆ ขนาด​ต้าน​สั่ง​หื้อ​ผี​ฮ้าย​ออก มัน​ก็​เจื้อฟัง” ");
INSERT INTO nod_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","แล้ว​จื้อ​เสียง​ของ​พระองค์​ก็​โด่ง​ดัง​ไป​เวย​ขนาด มี​คน​อู้​สืบ​กั๋น​ไป​ใคว่​แคว้น​กาลิลี ");
INSERT INTO nod_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","เมื่อ​พระเยซู​กับ​หมู่​สาวก​ของ​พระองค์​ออก​จาก​ธรรมศาลา​แล้ว พระองค์​ก็​เข้า​ไป​ใน​เฮือน​หลัง​นึ่ง เป๋น​เฮือน​ของ​ซีโมน​กับ​อันดรูว์ ยากอบ​กับ​ยอห์น​ก็​เข้า​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","แม่​เมีย​ของ​ซีโมน​บ่﻿สบาย​เป๋น​ไข้​นอน​อยู่ หมู่​เขา​ก็​เล่า​อาก๋าน​ของ​นาง​หื้อ​พระองค์​ฟัง ");
INSERT INTO nod_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","พระองค์​ก็​เตียว​เข้า​ไป​ก๋ำ​มือ​นาง แล้ว​ตุ้ม​หื้อ​ลุก​ขึ้น​นั่ง นาง​ก็​หาย​จาก​ไข้ แล้ว​นาง​ก็​ลุก​ขึ้น​ฮับใจ๊​ผ่อกอย​พระเยซู​กับ​หมู่​สาวก ");
INSERT INTO nod_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","เมื่อแลง​วัน​นั้น​ต๋อน​ตะวัน​ตก​ดิน​แล้ว คน​ตึง​เมือง​ก็​ปา​กั๋น​เอา​คน​เป๋น​พยาธิ​พะยำ ตึง​คน​ตี้​โดน​ผี​เข้า​มา​หา​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ปา​กั๋น​มา​ออ​ถ้า​อยู่​ตี้​ปะตู๋​หน้า​บ้าน ");
INSERT INTO nod_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","พระองค์​จึง​ฮักษา​คน​จ๋ำนวน​นัก​ตี้​เป๋น​พยาธิ​พะยำ​ต่าง﻿ๆ หื้อ​หาย ตึง​ขับ​ไล่​ผี​ออก​ไป​จาก​หลาย​คน​แหม​ตวย แต่​พระองค์​ห้าม​บ่﻿หื้อ​หมู่​มัน​อู้ ย้อน​หมู่​มัน​ฮู้​แล้ว​ว่า​พระองค์​เป๋น​ใผ ");
INSERT INTO nod_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","วัน​นึ่ง​พระเยซู​ลุก​ขึ้น​ใน​เวลา​เจ๊า​มืด เตียว​ออก​จาก​บ้าน​ไป​อธิษฐาน​ใน​ตี้​สงัด​ดัก​เย็น ");
INSERT INTO nod_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ซีโมน​ตึง​เปื้อน​ก็​ออก​ตวย​เซาะ​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","เมื่อ​ปะ​แล้ว​หมู่​เขา​ก็​บอก​ว่า “คน​ตังหลาย​ปา​กั๋น​ตวย​เซาะ​หา​พระองค์​อยู่” ");
INSERT INTO nod_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","แต่​พระองค์​ตอบ​ว่า “หื้อ​หมู่​เฮา​ไป​เมือง​อื่น​ต๋ำ​หมู่​นี้​กั๋น​เต๊อะ เฮา​จะ​สั่ง​สอน​ตี้​หั้น​ตวย ตี้​เฮา​มา​นี่​ก็​เปื้อ​มา​สั่ง​สอน​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","พระองค์​ก็​เตียว​ตาง​ไป​ใคว่​แคว้น​กาลิลี เตสนา​สั่ง​สอน​ต๋าม​ธรรมศาลา​ของ​จาว​ยิว แล้ว​ขับ​ไล่​ผี​แหม​หลาย​ตั๋ว​ออก​ไป​จาก​หลาย​คน​ตวย ");
INSERT INTO nod_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","มี​ป้อจาย​คน​นึ่ง​เป๋น​ขี้ตู้ด เขา​มา​คุก​เข่า​อ้อนวอน​ขอ​พระเยซู​ว่า “พระองค์​เจ้าข้า ถ้า​พระองค์​ใค่​จ้วย​ข้าพเจ้า​หื้อ​หาย ข้าพเจ้า​ก็​จะ​หาย​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","พระเยซู​ฮู้สึก​อินดู​ก็​ยื่น​มือ​ออก​ไป​หยุบ​ป้อจาย​คน​นั้น แล้ว​อู้​ว่า “เฮา​ใค่​จ้วย จง​หาย​โรค​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","แล้ว​โรค​ของ​เขา​ก็​หาย​บ่า​เดี่ยว​นั้น​เลย ตึง​เนื้อ​ตึง​ตั๋ว​ก็​สะอาด​หมด​ใส ");
INSERT INTO nod_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ก่อน​ตี้​พระเยซู​จะ​หื้อ​เขา​ไป พระองค์​สั่ง​ว่า ");
INSERT INTO nod_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ห้าม​เล่า​เรื่อง​นี้​หื้อ​ใผ​ฟัง​เน่อ แต่​หื้อ​ไป​แสดง​ตั๋ว​ต่อ​ปุโรหิต แล้ว​เอา​เครื่อง​ปู่จา​สำหรับ​คน​ตี้​หาย​โรค​นี้ ไป​ถวาย​ต๋าม​กำสั่ง​ของ​บท​บัญญัติ​ของ​โมเสส เปื้อ​แสดง​หื้อ​คน​ตังหลาย​ฮู้​ว่า​เจ้า​หาย​โรค​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","แต่​เมื่อ​ป้อจาย​คน​นี้​ออก​ไป​แล้ว ก็​เล่า​หื้อ​คน​ตังหลาย​ฟัง​จ๋น​ฮู้​กั๋น​ไป​ใคว่​หมด เยียะ​หื้อ​พระเยซู​เข้า​ไป​ใน​เมือง​อย่าง​เปิดเผย​บ่﻿ได้ พระองค์​ก็​ต้อง​หลบ​อยู่​นอก​เมือง แต่​ก็​ยัง​มี​คน​นัก​ขนาด​จาก​กู้​หน​กู้​แห่ง​หลั่งไหล​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ต่อ​มา​แหม​สอง​สาม​วัน พระเยซู​เข้า​ไป​ใน​เมือง​คาเปอรนาอุม​แหม จาว​บ้าน​จาว​เมือง​ฮู้​ข่าว​ว่า​พระองค์​ปิ๊ก​มา​อยู่​บ้าน​ตี้​เกย​อยู่​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ก็​ปา​กั๋น​มา​เต๋ม​บ้าน​จ๋น​ล้น​ออก​มา​ยัด​กั๋น​อยู่​หน้า​ปะตู๋ แล้ว​พระเยซู​ก็​เตสนา​สั่ง​สอน​ถ้อยกำ​ของ​พระเจ้า​หื้อ​หมู่​เขา​ฟัง ");
INSERT INTO nod_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","มี​ป้อจาย​สี่​คน​จ้วย​กั๋น​หาม​คน​ง่อย​คน​นึ่ง​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","เมื่อ​เข้า​ไป​ใก้﻿ๆ พระเยซู​บ่﻿ได้ ย้อน​มี​คน​นัก หมู่​เขา​ก็​ปา​กั๋น​ขึ้น​ไป​เต​หลังคา​ออก​ตั๊ด​บน​หัว​พระองค์ เมื่อ​เต​เป๋น​ฮ่อม​แล้ว ก็​ปา​กั๋น​หย่อน​คน​เป๋น​ง่อย​นอน​อยู่​บน​ตี้นอน​ลง​ไป ");
INSERT INTO nod_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","พระองค์​หัน​ความ​เจื้อ​ของ​หมู่​เขา​ก็​อู้​กับ​คน​ง่อย​ว่า “ลูก​เหย บาป​ของ​เจ้า​ได้​โผด​ยก​หื้อ​แล้ว​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ตี้​หั้น​มี​หมู่​ธรรมาจ๋ารย์​บาง​คน​นั่ง​อยู่ ก็​กึ๊ด​ใน​ใจ๋​ว่า ");
INSERT INTO nod_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“เป๋น​จาใด​คน​นี้​อู้​หมิ่น​ประมาท​พระเจ้า ใผ​จะ​ยก​โต้ษ​บาป​ได้​นอก​จาก​พระเจ้า​องค์​เดียว​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","พระเยซู​ฮู้​กำกึ๊ด​ใน​ใจ๋​ของ​หมู่​เขา ก็​ถาม​ว่า “เป๋น​จาใด​หมู่​ต้าน​กึ๊ด​ใน​ใจ๋​จาอี้ ");
INSERT INTO nod_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","อัน​ใด​จะ​ง่าย​เหลือ​กั๋น ตี้​จะ​อู้​กับ​คน​ง่อย​นี้​ว่า ‘บาป​ของ​เจ้า​โผด​ยก​หื้อ​แล้ว​เน่อ’ กาว่า​จะ​อู้​ว่า ‘ลุก​ขึ้น​แบก​ตี้นอน​เตียว​ไป​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","แต่​เปื้อ​ต้าน​ตังหลาย​จะ​ฮู้​ว่า​บุตรมนุษย์ มี​สิทธิ​อำนาจ​ใน​โลก​ตี้​จะ​โผด​ยก​โต้ษ​บาป​ได้” แล้ว​พระองค์​ก็​อู้​กับ​คน​ง่อย​นั้น​ว่า ");
INSERT INTO nod_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“เฮา​สั่ง​เจ้า​หื้อ​ลุก​ขึ้น​แบก​ตี้นอน​ปิ๊ก​ไป​บ้าน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","คน​ง่อย​นั้น​ก็​ลุก​ขึ้น แบก​ตี้นอน​แล้ว​เตียว​ปิ๊ก​บ้าน​ต่อ​หน้า​ต่อ​ต๋า​คน​ตังหลาย คน​ตึงหมด​ก็​ปา​กั๋น​งืด​สรรเสริญ​พระเจ้า​ว่า “เฮา​บ่﻿เกย​ฮู้​บ่﻿เกย​หัน​อะหยัง​จาอี้​สัก​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","พระเยซู​เตียว​ต๋าม​ฮิม​ทะเลสาบ​แหม มี​คน​จ๋ำนวน​นัก​มา​หา​พระองค์ พระองค์​จึง​เตสนา​สั่ง​สอน​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","กวม​เวลา​ตี้​พระองค์​เตียว​มา​ต๋าม​ตาง​นั้น ก็​หัน​คน​เก็บ​ภาษี​คน​นึ่ง​จื้อ​เลวี​ลูก​ของ​อัลเฟอัส​นั่ง​อยู่​ตี้​ด่าน​เก็บ​ภาษี พระองค์​อู้​กับ​เขา​ว่า “ตวย​เฮา​มา​เต๊อะ” เลวี​ก็​ลุก​ขึ้น​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","เมื่อ​แลง​วัน​นั้น​ต๋อน​ตี้​พระเยซู​กิ๋น​ข้าว​กับ​หมู่​สาวก​ใน​บ้าน​เลวี ก็​มี​หมู่​คน​เก็บ​ภาษี​กับ​คน​บาป​หลาย​คน​มา​ฮ่วม​กิ๋น​ข้าว​ตวย​พระองค์​ตี้​หั้น ย้อน​ว่า​มี​คน​จาอี้​หลาย​คน​ติดต๋าม​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","มี​หมู่​คน​ตี้​เป๋น​ตึง​ธรรมาจ๋ารย์​เป๋น​ตึง​ฟาริสี​หัน​พระเยซู​นั่ง​กิ๋น​ข้าว​ตวย​กั๋น​กับ​คน​เก็บ​ภาษี​ตึง​หมู่​คน​บาปก็​ถาม​สาวก​ของ​พระองค์​ว่า “เป๋น​จาใด​อาจ๋ารย์​ของ​หมู่​ต้าน​นั่ง​กิ๋น​ข้าว​ฮ่วม​กับ​คน​เก็บ​ภาษี​กับ​คน​บาป​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","เมื่อ​พระเยซู​ได้ยิน​จาอั้น​ก็​ตอบ​ว่า “คน​อยู่​ดี​สบาย​แข็งแฮง​บ่﻿ต้องก๋าน​หมอ แต่​คน​ตี้​บ่﻿สบาย​ต้องก๋าน​หมอ เฮา​บ่﻿ได้​มา​เปื้อ​ฮ้อง​หา​คน​ตี้​กึ๊ด​ว่า​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม แต่​มา​เปื้อ​ฮ้อง​หา​คน​บาป” ");
INSERT INTO nod_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","เวลา​นั้น​หมู่​สาวก​ของ​ยอห์น​ผู้​หื้อ​บัพติศมา​ตึง​หมู่​ฟาริสี​ถือ​ศีล​อด​อาหาร มี​บาง​คน​มา​ถาม​พระเยซู​ว่า “หมู่​สาวก​ของ​ยอห์น​กับ​สาวก​ของ​หมู่​ฟาริสี​ถือ​ศีล​อด​อาหาร แต่​เป๋น​จาใด​สาวก​ของ​ต้าน​บ่﻿เยียะ​พ่อง” ");
INSERT INTO nod_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","พระองค์​ตอบ​เป๋น​กำเผียบ​ว่า “เมื่อ​เจ้าบ่าว​ยัง​อยู่ เปื้อน﻿ๆ ของ​เขา​จะ​ถือ​ศีล​อด​อาหาร​ได้​จาใด เจ้าบ่าว​อยู่​ตวย​หมู่​เขา​เมิน​มอก​ใด หมู่​เขา​ก็​จะ​บ่﻿อด​อาหาร​เมิน​มอก​อั้น ");
INSERT INTO nod_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","แต่​จะ​มี​วัน​นึ่ง​ตี้​เจ้าบ่าว​จะ​ถูก​เอา​ไป​จาก​หมู่​เขา เถิง​ต๋อน​นั้น​หมู่​เขา​ก็​จะ​ปา​กั๋น​ถือ​ศีล​อด​อาหาร ");
INSERT INTO nod_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“บ่﻿มี​ใผ​เอา​ผ้า​ใหม่​มา​ปะ​เสื้อผ้า​เก่า ถ้า​เยียะ​จาอั้น เมื่อ​ผ้า​ใหม่​หด​ก็​จะ​จั๊ก​เสื้อผ้า​ผืน​เก่า​ปุด​นัก​เหลือ​เก่า ");
INSERT INTO nod_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","บ่﻿มี​ใผ​เอา​เหล้า​องุ่น​หมัก​ใหม่﻿ๆ ใส่​ถง​หนัง​เก่า ย้อน​ว่า​ถ้า​เยียะ​จาอั้น​เหล้า​องุ่น​หมัก​ใหม่​นั้น​จะ​เยียะ​หื้อ​ถง​หนัง​เก่า​แตก เหล้า​องุ่น​ตึง​ถง​หนัง​ก็​จะ​ใจ๊​บ่﻿ได้ เหล้า​องุ่น​หมัก​ใหม่​ต้อง​ใส่​ใน​ถง​หนัง​ใหม่” ");
INSERT INTO nod_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","มี​เตื้อ​นึ่ง​เป๋น​วัน​สะบาโต พระเยซู​เตียว​ลัด​ก๋าง​โต้ง หละหว่าง​เตียว​ลัด​ไป​นั้น หมู่​สาวก​ของ​พระองค์​ก็​เด็ด​งวงข้าว​มา​เก็ด​กิ๋น​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","หมู่​ฟาริสี​หัน​ก็​ถาม​พระเยซู​ว่า “ผ่อ​หั้น​ลอ เป๋น​จาใด​สาวก​ของ​ต้าน​เยียะ​สิ่ง​ตี้​ห้าม​เยียะ​ใน​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","พระองค์​ก็​ตอบ​ว่า “หมู่​ต้าน​บ่﻿เกย​อ่าน​พระคัมภีร์​เรื่อง​ตี้​กษัตริย์​ดาวิด​เยียะ​ต๋อน​ตี้​ต้าน​กับ​หมู่​คน​ตี้​มา​ตวย​ใค่​อยาก​กิ๋น​ข้าว​กา ");
INSERT INTO nod_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ต้าน​เข้า​ไป​ใน​พระวิหาร​ของ​พระเจ้า​ใน​ต๋อน​ตี้​อาบีอาธาร์​เป๋น​มหา​ปุโรหิต​อยู่ แล้ว​กิ๋น​เข้าหนมปัง​ตี้​ตั้ง​ถวาย​พระเจ้า เซิ่ง​ต๋าม​กฎ​บ่﻿หื้อ​ใผ​กิ๋น​นอก​จาก​ปุโรหิต​เต้าอั้น​ตี้​กิ๋น​ได้ แต่​ต้าน​ยัง​เอา​หื้อ​หมู่​คน​ตี้​มา​ตวย​กิ๋น​ตวย” ");
INSERT INTO nod_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","พระเยซู​บอก​หมู่​เขา​ว่า “พระเจ้า​ตั้ง​วัน​สะบาโต​สำหรับ​จ้วย​มนุษย์ บ่﻿ใจ้​หื้อ​มนุษย์​ต้อง​มา​ลำบาก​ย้อน​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ย้อน​จาอั้น​บุตรมนุษย์​เป๋น​เจ้า​เป๋น​นาย​เหนือ​วัน​สะบาโต​ตวย” ");
INSERT INTO nod_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","พระเยซู​เข้า​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว​แหม มี​ป้อจาย​คน​นึ่ง​มือ​เผิก​นึ่ง​ของ​เขา​ลีบ​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","มี​จาว​ยิว​บาง​คน​ก่ำลัง​ผ่อ​ว่า​พระองค์​จะ​ฮักษา​ป้อจาย​มือ​ลีบ​คน​นั้น​ใน​วัน​สะบาโต​ก่อ เปื้อ​จะ​หา​เหตุ​นาบ​โต้ษ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","พระองค์​บอก​คน​มือ​ลีบ​คน​นั้น​ว่า “ลุก​ยืน​ขึ้น​ส่อง​หน้า​คน​ตังหลาย” ");
INSERT INTO nod_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","แล้ว​พระองค์​ก็​ถาม​หมู่​เขา​ว่า “ควร​จะ​เยียะ​ก๋าน​ดี​กาว่า​เยียะ​ก๋าน​ฮ้าย​ใน​วัน​สะบาโต จะ​จ้วย​จีวิต​กาว่า​จะ​ทำลาย​จีวิต” แต่​หมู่​เขา​ก็​ปา​กั๋น​ดัก​ปิ้ง ");
INSERT INTO nod_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","พระเยซู​ผ่อ​รอบ﻿ๆ หมู่​เขา พระองค์​โขด​กับ​เสียใจ๋​ตี้​หัน​ว่า​หมู่​เขา​มี​จิตใจ๋​หลึ่ง แล้ว​อู้​กับ​คน​มือ​ลีบ​ว่า “เหยียด​มือ​ออก​มา” เขา​ก็​เยียะ​ตวย​ต๋าม แล้ว​มือ​ของ​เขา​ก็​หาย​เป๋น​ปกติ ");
INSERT INTO nod_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","เมื่อ​หมู่​ฟาริสี​หัน​จาอั้น ก็​ฟั่ง​ออก​ไป​วางแผน​กับ​หมู่​ของ​กษัตริย์​เฮโรด​ว่า​จะ​ฆ่า​พระเยซู​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","พระเยซู​ไป​ทะเลสาบ​กาลิลี​กับ​หมู่​สาวก แล้ว​มี​คน​นัก​ขนาด​ตวย​พระองค์​ไป ตึง​คน​ตี้​มา​จาก​แคว้น​กาลิลี แคว้น​ยูเดีย ");
INSERT INTO nod_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","กรุง​เยรูซาเล็ม แคว้น​อิดูเมอา กับ​แคว้น​ตี้​อยู่​เผิก​แม่น้ำ​จอร์แดน แล้ว​ก็​ยัง​มี​คน​ลุก​มา​จาก​แถว​เมือง​ไทระ​กับ​เมือง​ไซดอน​มา​ตวย ย้อน​ได้ยิน​เถิง​เรื่อง​ต่าง﻿ๆ ตี้​พระองค์​เยียะ​มา ");
INSERT INTO nod_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","พระองค์​ก็​เลย​สั่ง​หมู่​สาวก​เกียม​เฮือ​ลำ​นึ่ง​หื้อ เปื้อ​กั๋น​คน​หมู่​นั้น​บ่﻿หื้อ​มา​ยัด​ยู้​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ย้อน​ใน​วัน​นั้น​พระองค์​ได้​ฮักษา​คน​จ๋ำนวน​นัก​หื้อ​หาย คน​เป๋น​พยาธิ​พะยำ​ต่าง﻿ๆ ก็​ยัด​ยู้​กั๋น​เข้า​มา​เปื้อ​จะ​หยุบ​จะ​ก๋ำ​พระองค์ แล้ว​จะ​หาย​โรค ");
INSERT INTO nod_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","เมื่อ​หมู่​ผี​ฮ้าย​ตี้​เข้า​ใน​คน​หัน​พระองค์ ก็​หมอบ​ลง​กราบ​ไหว้​พระองค์ แล้ว​ฮ้อง​เสียง​ดัง​ว่า “ต้าน​เป๋น​บุตร​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","แต่​พระเยซู​สั่ง​ห้าม​หมู่​ผี​ฮ้าย​อย่าง​เด็ดขาด​บ่﻿หื้อ​บอก​ว่า​พระองค์​เป๋น​ใผ ");
INSERT INTO nod_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","หลัง​จาก​นั้น​พระเยซู​ขึ้น​ไป​บน​ดอย​ม่อน​นึ่ง แล้ว​พระองค์​เปิงใจ๋​จะ​ฮ้อง​คน​ใด​ก็​ฮ้อง​คน​นั้น​ตวย​พระองค์​ไป หมู่​เขา​ก็​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ตึง​หมด​มี​สิบ​สอง​คน พระองค์​แต่งตั้ง​คน​หมู่​นี้​เปื้อ​จะ​อยู่​ตวย​ต้าน กับ​จะ​ใจ๊​หมู่​เขา​ไป​บอก​ข่าวดี​หื้อ​คน​อื่น​ฟัง พระเยซู​ฮ้อง​หมู่​เขา​ว่า​หมู่​อัคร​สาวก ");
INSERT INTO nod_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ตึง​หื้อ​หมู่​เขา​มี​อำนาจ​ตี้​จะ​ขับ​ไล่​ผี​ออก​ได้​ตวย ");
INSERT INTO nod_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","หมู่​อัคร​สาวก​สิบ​สอง​คน​นี้​มี​จื้อ​ว่า ซีโมน​คน​ตี้​พระองค์​ตั้ง​จื้อ​หื้อ​แหม​จื้อ​ว่า เปโตร ");
INSERT INTO nod_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ยากอบ​ลูกบ่าว​ของ​เศเบดี กับ​ยอห์น​น้องบ่าว​ของ​เขา สอง​คน​นี้​พระองค์​หื้อ​จื้อ​แหม​ว่า โบอาเนอเย​แป๋​ว่า “ลูกบ่าว​ของ​ฟ้า​ฮ้อง” ");
INSERT INTO nod_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","อันดรูว์ ฟีลิป บารโธโลมิว มัทธิว โธมัส ยากอบ​ลูก​บ่าว​ของ​อัลเฟอัส ธัดเดอัส ซีโมน​คน​ของ​พรรค​จ้าดนิยม ");
INSERT INTO nod_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","กับ​ยูดาส อิสคาริโอท ต๋อน​เมื่อ​ลูน​คน​นี้​ได้​หักหลัง​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","จาก​นั้น​พระองค์​ก็​ปิ๊ก​บ้าน มี​หมู่​คน​มา​ยืนออ​กั๋น​อยู่​ตี้​บ้าน​หั้น​แหม จ๋น​เยียะ​หื้อ​พระเยซู​ตึง​หมู่​สาวก​สิบ​สอง​คน​บ่﻿มี​เวลา​กิ๋น​ข้าว​กิ๋น​น้ำ ");
INSERT INTO nod_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","เมื่อ​ครอบครัว​ของ​พระองค์​ได้ยิน​ข่าว​นี้ ก็​กึ๊ด​ว่า​พระองค์​เป๋น​บ้า​ไป​แล้ว จึง​ปา​กั๋น​มา​หา​เปื้อ​จะ​ยับ​ปิ๊ก​เมือ​บ้าน ");
INSERT INTO nod_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","แต่​มี​หมู่​ธรรมาจ๋ารย์​ตี้​ลุก​จาก​กรุง​เยรูซาเล็ม​มา อู้​กั๋น​ว่า “เขา​ถูก​เบเอลเซบูล หัวหน้า​ผี​เข้า ตี้​เขา​ไล่​ผี​ออก​ได้​นั้น ก็​ย้อน​ใจ๊​อำนาจ​ของ​หัวหน้า​ผี​ตั๋ว​นี้​ละ” ");
INSERT INTO nod_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","พระเยซู​จึง​ฮ้อง​หมู่​เขา​เข้า​มา​ใก้﻿ๆ แล้ว​เล่า​กำเผียบ​หื้อ​เขา​ฟัง​ว่า “ซาต๋าน​จะ​ขับ​ไล่​ตั๋ว​เก่า​ได้​กา ");
INSERT INTO nod_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ถ้า​อาณาจักร​ใด﻿ๆ แตกแยก​กั๋น​เหีย อาณาจักร​นั้น​ก็​จะ​ตั้ง​อยู่​ต่อ​ไป​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","กาว่า​ถ้า​ครอบครัว​ใด​แตกแยก​กั๋น ครอบครัว​นั้น​ก็​จะ​ตั้ง​อยู่​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","เหมือน​กับ​ถ้า​ซาต๋าน​ต่อต้าน​หมู่​ของ​มัน หมู่​มัน​ก็​จะ​แตกแยก​กั๋น แล้ว​ซาต๋าน​ก็​จะ​ตั้ง​อยู่​บ่﻿ได้ แต่​จะ​หล้มจ๋ม​ไป​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“บ่﻿มี​ใผ​สามารถ​ตี้​จะ​เข้า​ไป​ปล้น​เอา​ทรัพย์​สมบัติ​ใน​บ้าน​ของ​คน​ตี้​มี​ก๋ำลัง​นัก​ได้ เขา​จะ​ต้อง​มัด​เจ้าของ​บ้าน​ตี้​มี​ก๋ำลัง​นัก​นั้น​เหีย​ก่อน เถิง​จะ​สามารถ​ปล้น​ได้ ");
INSERT INTO nod_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ความ​บาป​ต่าง﻿ๆ ตึง​กำ​อู้​หมิ่น​ประมาท​ตี้​คน​ใด​ว่า​มา​นั้น ยัง​ยกโต้ษ​หื้อ​ได้ ");
INSERT INTO nod_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","แต่​ถ้า​ใผ​อู้​หมิ่น​ประมาท​พระวิญญาณ​บริสุทธิ์​จะ​ยกโต้ษ​หื้อ​ตึง​บ่﻿ได้​เลย ย้อน​ว่า​บาป​นั้น​จะ​ติด​ตั๋ว​ไป​ตลอด” ");
INSERT INTO nod_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ตี้​พระเยซู​อู้​จาอั้น​ก็​ย้อน​ว่า หมู่​เขา​ปา​กั๋น​หา​ว่า​พระองค์​มี​ผี​ฮ้าย​เข้า ");
INSERT INTO nod_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","เวลา​นั้น แม่​กับ​หมู่​น้อง​บ่าว​ของ​พระเยซู​ก็​มา​ยืน​ถ้า​อยู่​ตัง​นอก หมู่​เขา​ใจ๊​คน​เข้า​ไป​ฮ้อง​พระองค์​ออก​มา ");
INSERT INTO nod_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","มี​หลาย​คน​ตี้​นั่ง​แวด​พระเยซู​เป๋น​หมู่ บอก​กับ​พระองค์​ว่า “แม่​กับ​หมู่​น้อง​บ่าว​มา​ยืน​ถ้า​อยู่​ตังนอก” ");
INSERT INTO nod_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","พระเยซู​บอก​ว่า “ใผ​เป๋น​แม่​กับ​ปี้น้อง​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","แล้ว​พระองค์​ก็​ผ่อ​ไป​ตี้​คน​นั่ง​แวด​พระองค์​อยู่ อู้​ว่า “หมู่​เนียะ​เป๋น​แม่​กับ​ปี้น้อง​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ย้อน​ว่า​คน​ตี้​เยียะ​ตวย​ต๋าม​ความ​ต้องก๋าน​ของ​พระเจ้า คน​นั้น​ก็​เป๋น​ปี้น้อง​กับ​เป๋น​แม่​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","พระเยซู​สั่ง​สอน​ตี้​ฮิม​ทะเลสาบ​แหม มี​คน​จ๋ำนวน​นัก​ปา​กั๋น​มา​หลุ้ม​พระองค์ พระองค์​ก็​ลง​ไป​นั่ง​อยู่​ใน​เฮือ​ลอย​ฮิม​ฝั่ง ส่วน​คน​ตังหลาย​ยืน​ฟัง​อยู่​บน​ต๋าฝั่ง ");
INSERT INTO nod_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","พระเยซู​อู้​เป๋น​กำเผียบ​สอน​หมู่​เขา​หลาย​อย่าง พระองค์​เล่า​ว่า ");
INSERT INTO nod_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ฟัง​หื้อ​ดี﻿ๆ เน่อ มี​จาวนา​คน​นึ่ง​ออก​ไป​หว่าน​เม็ด​พืช ");
INSERT INTO nod_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ต๋อน​ตี้​หว่าน​อยู่​นั้น บาง​เม็ด​ตก​ต๋าม​หน​ตาง​เตียว นก​ก็​มา​จิก​กิ๋น​เหีย​หมด ");
INSERT INTO nod_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","บาง​เม็ด​ก็​ตก​ลง​ดิน​ตี้​ปื๊น​ตัง​ลุ่ม​เป๋น​บ่าหิน​เต๋ม​ไป​หมด มี​ดิน​บาง​แตะแหยะ​อยู่​ตัง​บน ก็​เยียะ​หื้อ​เม็ด​พืช​นั้น​งอก​ขึ้น​เวย ");
INSERT INTO nod_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","แต่​เมื่อ​โดน​แดด​เผา​นัก​ขึ้น​ติก﻿ๆ ก็​เหี่ยว​แห้ง​ต๋าย ย้อน​ว่า​ฮาก​อยู่​ตื้น​ล้ำ​ไป ");
INSERT INTO nod_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","บาง​เม็ด​ตก​ก๋าง​ป่า​หนาม ต้น​หนาม​นั้น​ก็​ใหญ่​ขึ้น​มา​งำ​ต้น​นั้น​เหีย​หมด ต้น​นั้น​ก็​บ่﻿มี​ดอก​บ่﻿มี​หน่วย ");
INSERT INTO nod_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","แต่​มี​บาง​เม็ด​ตก​บน​ดิน​ดี​ก็​งอก​งาม​ใหญ่​ขึ้น เกิด​ดอก​ออก​ผล​สาม​สิบ​เต้า​พ่อง หก​สิบ​เต้า​พ่อง ร้อย​เต้า​พ่อง” ");
INSERT INTO nod_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","แล้ว​พระองค์​อู้​ว่า “ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","เมื่อ​คน​ตังหลาย​ปิ๊ก​ไป​แล้ว สาวก​สิบ​สอง​คน​ตึง​บาง​คน​ตี้​ตวย​พระองค์​อยู่ ก็​ถาม​เถิง​เรื่อง​กำเผียบ​นั้น​ว่า​หมาย​ความ​ว่า​จาใด ");
INSERT INTO nod_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","พระองค์​ตอบ​ว่า “ข้อ​ล้ำเลิ็ก​เรื่อง​แผ่นดิน​ของ​พระเจ้า​โผด​หื้อ​ต้าน​ตังหลาย​ฮู้​ได้ ส่วน​หมู่​คน​อื่น﻿ๆ นั้น จะ​อู้​หื้อ​ฟัง​เป๋น​กำเผียบ​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","เปื้อ​ว่า ‘หมู่​เขา​ผ่อ​แล้ว​ผ่อ​แหม​แต่​จะ​บ่﻿หัน ฟัง​แล้ว​ฟัง​แหม​แต่​จะ​บ่﻿เข้าใจ๋ ถ้า​เขา​หัน ถ้า​เขา​เข้าใจ๋ เขา​ก็​จะ​ปิ๊ก​มา​หา​พระเจ้า แล้ว​ฮับ​ก๋าน​ยกโต้ษ’ ” ");
INSERT INTO nod_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","แล้ว​พระเยซู​ถาม​หมู่​เขา​ว่า “หมู่​ต้าน​บ่﻿เข้าใจ๋​กำเผียบ​นั้น​เตื้อ​กา แล้ว​จะ​เข้าใจ๋​กำเผียบ​อื่น﻿ๆ ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","หมาย​ความ​ว่า คน​หว่าน​เม็ด​พืช​นั้น​หว่าน​ถ้อยกำ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","เม็ด​ตี้​ตก​ต๋าม​หน​ตาง​เตียว​ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​ของ​พระเจ้า​แล้ว แต่​ซาต๋าน​มา​ลู่​เอา​ถ้อยกำ​นั้น​ตี้​หว่าน​ลง​ใน​ใจ๋​ของ​เขา​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ส่วน​เม็ด​ตี้​ตก​ลง​ดิน​ตี้​ปื๊น​ตัง​ลุ่ม​เป๋น​บ่าหิน​เต๋ม​ไป​หมด ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ แล้ว​ก็​ฮับ​ถ้อยกำ​นั้น​ไว้​บ่า​เดี่ยว​นั้น​เลย​อย่าง​จื้นจม​ยินดี ");
INSERT INTO nod_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","แต่​ฮาก​ลง​ดิน​บ่﻿เลิ็ก อยู่​ได้​บ่﻿เมิน เมื่อ​เกิด​ปั๋ญหา​กาว่า​โดน​ค่ำ​ย้อน​ถ้อยกำ​นั้น เขา​ก็​เลิก​เจื้อ​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ส่วน​เม็ด​ตี้​ตก​ก๋าง​ป่า​หนาม​นั้น ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","แต่​ยัง​เป๋น​ห่วง​เรื่อง​ต่าง﻿ๆ กับ​จีวิต​ใน​โลก​นี้ หลง​มัวเมา​ข้าว​ของ​เงิน​คำ กับ​โลภ​ใค่​ได้​สิ่ง​ต่าง﻿ๆ สิ่ง​หมู่​นี้​ก็​มา​งำ​ถ้อยกำ​ไว้ เยียะ​หื้อ​ถ้อยกำ​นั้น​บ่﻿เกิด​ผล​ใน​จีวิต ");
INSERT INTO nod_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","แต่​เม็ด​ตี้​ตก​บน​ดิน​ดี​ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​แล้ว​ฮับ​ไว้ แล้ว​เกิด​ดอก​ออก​ผล​สาม​สิบ​เต้า​พ่อง หก​สิบ​เต้า​พ่อง ร้อย​เต้า​พ่อง” ");
INSERT INTO nod_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","แล้ว​พระองค์​ถาม​หมู่​เขา​ว่า “มี​ใผ​พ่อง​เมื่อ​ต๋าม​โกม​ไฟ​แล้ว​จะ​เอา​ถัง​ควบ​ไว้ กาว่า​เอา​ไป​ซุก​ไว้​ปื๊น​เตียง​เหีย แต่​จะ​บ่﻿เอา​ไป​ตั้ง​บน​ตั่ง​ไว้​กา ");
INSERT INTO nod_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","กู้​สิ่ง​ตี้​เอา​ไป​ซ่อน​ไว้​ก็​จะ​ป๋ากฏ​ออก​มา​หื้อ​หัน กู้​สิ่ง​ตี้​เป๋น​ความ​ลับ​จะ​ถูก​เปิดเผย​หื้อ​ฮู้ ");
INSERT INTO nod_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","พระองค์​อู้​กับ​หมู่​เขา​แหม​ว่า “หื้อ​เอา​ใจ๋​ใส่​ใน​สิ่ง​ตี้​ต้าน​ได้​ฟัง​หื้อ​ดี﻿ๆ ต้าน​จะ​สวน​สิ่ง​ตี้​ฟัง​มา​ด้วย​ต๋าง​แก่น​ใด พระเจ้า​จะ​สวน​ความ​เข้าใจ๋​คืน​หื้อ​ต้าน​ด้วย​ต๋าง​แก่น​นั้น ป๋าย​บ่﻿ปอ​จะ​เตื่อม​แถ้ง​หื้อ​แหม ");
INSERT INTO nod_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","คน​ตี้​เข้าใจ๋​อยู่​แล้ว​ก็​จะ​เข้าใจ๋​นัก​ขึ้น​แหม ส่วน​คน​ตี้​บ่﻿เข้าใจ๋​กับ​บ่﻿สนใจ๋​นั้น แม้​สิ่ง​ตี้​เขา​เข้าใจ๋​พระเจ้า​ก็​จะ​เยียะ​หื้อ​เขา​บ่﻿เข้าใจ๋​แหม​เลย” ");
INSERT INTO nod_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","พระองค์​อู้​ต่อ​แหม​ว่า “แผ่นดิน​ของ​พระเจ้า​เผียบ​เหมือน​กับ​ป้อจาย​คน​นึ่ง​หว่าน​เม็ด​พืช​ลง​ใน​โต้งนา ");
INSERT INTO nod_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ต๋อน​เมื่อคืน​ก็​นอน​หลับ เมื่อ​วัน​ก็​ลุก​ขึ้น ไป﻿ๆ มา﻿ๆ เม็ด​พืช​นั้น​จะ​งอก​จ๋ำเริญ​ขึ้น​จาใด​เขา​ก็​บ่﻿ฮู้ ");
INSERT INTO nod_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ย้อน​ว่า​ดิน​เยียะ​หื้อ​เม็ด​นั้น​งอก​ขึ้น​เป๋น​ต้น​ก่อน แล้ว​เมื่อลูน​มา​ก็​ออก​งวง หลัง​จาก​นั้น​ก็​มี​เม็ด​ข้าว​เต๋ม​งวง ");
INSERT INTO nod_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","เมื่อ​ข้าว​แก่​ได้​ตี้ สมควร​ดี​เกี่ยว​แล้ว เขา​ก็​ไป​เกี่ยว​เก็บ​มา​ไว้​กิ๋น ย้อน​ว่า​เถิง​ยาม​เกี่ยว​ข้าว​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","แล้ว​พระองค์​ก็​อู้​ว่า “จะ​เผียบ​แผ่นดิน​ของ​พระเจ้า​เหมือน​อะหยัง​ดี กาว่า​จะ​อู้​กำเผียบ​จาใด​ดี ");
INSERT INTO nod_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ก็​เผียบ​เหมือน​เม็ด​มัสตาร์ด​เม็ด​นึ่ง ต๋อน​บ่ม​ไว้​ใน​ดิน เม็ด​ก็​หน้อย​เหลือ​เปิ้น ");
INSERT INTO nod_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","แต่​เมื่อ​งอก​จ๋ำเริญ​ขึ้น​มา​แล้ว ก็​เป๋น​ต้น​ใหญ่​เหลือ​เปิ้น มี​กิ่ง​ใหญ่​ปอ​ตี้​นก​มา​แป๋ง​ฮัง​อาศัย​อยู่​ใน​ฮ่ม​เงา​ของ​ต้น​นั้น​ได้” ");
INSERT INTO nod_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","พระเยซู​ใจ๊​กำเผียบ​หลาย​เรื่อง​จาอี้​ไป​สอน​คน​ตังหลาย​เต้า​ตี้​หมู่​เขา​เข้าใจ๋​ได้ ");
INSERT INTO nod_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","นอก​จาก​กำเผียบ​แล้ว พระองค์​บ่﻿ได้​อู้​อะหยัง​กับ​หมู่​เขา​แหม แต่​เมื่อ​คน​ตังหลาย​ปิ๊ก​ไป​แล้ว พระองค์​ก็​อธิบาย​กำเผียบ​หมู่​นั้น​หื้อ​หมู่​สาวก​ฟัง ");
INSERT INTO nod_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","เมื่อ​แลง​วัน​นั้น พระเยซู​บอก​หมู่​สาวก​ว่า “หื้อ​หมู่​เฮา​ข้าม​ทะเลสาบ​ไป​เผิก​ตัง​ปู๊น​กั๋น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","หมู่​เขา​ก็​ลา​คน​ตังหลาย ปา​กั๋น​ลง​เฮือ​กับ​พระองค์​ตี้​นั่ง​ใน​เฮือ​อยู่​แล้ว แล้ว​ปา​พระองค์​ไป มี​เฮือ​หลาย​ลำ​ตวย​ไป ");
INSERT INTO nod_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","จู่﻿ๆ ลมหลวง​ก็​เกิด​ขึ้น เยียะ​หื้อ​คลื่น​ซัด​น้ำ​เข้า​มา​จ๋น​ปอ​จะ​เต๋ม​ลำ​เฮือ ");
INSERT INTO nod_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","แต่​พระเยซู​นอน​หนุน​หมอน​หลับ​อยู่​ต๊าย​เฮือ หมู่​สาวก​ก็​มา​ฮ้อง​พระองค์​ลุก บอก​ว่า “อาจ๋ารย์​บ่﻿ห่วง​กั๋น​พ่อง​กา หมู่​เฮา​ก่ำลัง​จะ​จ๋ม​น้ำ​ต๋าย​กั๋น​หมด​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","พระองค์​ก็​ลุก​ขึ้น​ห้าม​ลม แล้ว​สั่ง​คลื่น​ว่า “ย้าง ย้าง​บ่าเดี่ยว​นี้” แล้ว​ลม​ก็​ย้าง คลื่น​ก็​หนิมผิ้ว​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","พระองค์​อู้​กับ​หมู่​เขา​ว่า “กั๋ว​เยียะ​หยัง บ่﻿มี​ความ​เจื้อ​กา” ");
INSERT INTO nod_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","หมู่​เขา​กั๋ว​ขนาด อู้​กั๋น​ใน​หมู่​เขา​ว่า “ต้าน​ผู้​นี้​เป๋น​ใผ​กั๋น ขนาด​ลม​หลวง​กับ​คลื่น​แฮง​ก็​ยัง​เจื้อ​ฟัง​ต้าน” ");
INSERT INTO nod_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","พระเยซู​กับ​หมู่​สาวก​ก็​ข้าม​ทะเลสาบ​มา​เถิง​แหม​เผิก​ใน​เขต​ของ​จาว​เกราซา ");
INSERT INTO nod_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","หลัง​จาก​ตี้​พระเยซู​ขึ้น​จาก​เฮือ ก็​มี​ป้อจาย​คน​นึ่ง​ออก​มา​จาก​อุโมงค์​ฝัง​ศพ​เข้า​มา​หา​พระองค์ เขา​โดน​ผี​ฮ้าย​เข้า ");
INSERT INTO nod_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ป้อจาย​คน​นั้น​อยู่​ต๋าม​อุโมงค์​ฝัง​ศพ บ่﻿มี​ใผ​มัด​เขา​ไว้​ได้​แหม​แล้ว ขนาด​เอา​เจื้อก​เหล็ก​ล่าม​ไว้​ยัง​บ่﻿อยู่ ");
INSERT INTO nod_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ย้อน​ว่า​เกย​เอา​เจื้อก​เหล็ก​ล่าม​เขา​ไว้​หลาย​เตื้อ​แล้ว แต่​เขา​ก็​สะต๊ก​เจื้อก​เหล็ก​ตี้​ล่าม​มือ​จ๋น​ปุด ตี้​ล่าม​ตี๋น​ก็​เอา​ฟาด​ลง​จ๋น​ปุด บ่﻿มี​ใผ​มี​แฮง​ปอ​ตี้​จะ​เยียะ​หื้อ​เขา​อยู่​ดึ้ง﻿ๆ ได้ ");
INSERT INTO nod_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","เขา​จะ​เตียว​ไป​เตียว​มา​ต๋าม​อุโมงค์​ฝัง​ศพ​กับ​ต๋าม​ดอย​ต่าง﻿ๆ ตึง​เมื่อวัน​ตึง​เมื่อคืน คาง​เสียง​ดัง​เหมือน​ผีบ้า แล้ว​เอา​บ่าหิน​คม​เถือ​เนื้อ​เถือ​ตั๋ว ");
INSERT INTO nod_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","เมื่อ​เขา​หัน​พระเยซู​จ้าดไก๋ ก็​ล่น​เข้า​มา​หา​กราบ​ไหว้​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","แล้ว​ฮ้อง​เสียง​ดัง​ว่า “พระเยซู​พระบุตร​ของ​พระเจ้า​ผู้​สูงสุด มา​ยุ่ง​กับ​ข้า​เยียะ​หยัง ขอ​สัญญา​ต่อ​พระเจ้า​ก่อน​เต๊อะ​ว่า พระองค์​จะ​บ่﻿ทรมาน​ข้า” ");
INSERT INTO nod_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","เขา​อู้​จาอี้​ย้อน​พระเยซู​สั่ง​ว่า “ไอ่​ผี​ฮ้าย จง​ออก​จาก​คน​นั้น​เหีย” ");
INSERT INTO nod_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","พระเยซู​ถาม​มัน​ว่า “เจ้า​จื้อ​อะหยัง” มัน​ตอบ​ว่า “จื้อ​ก๋อง ย้อน​หมู่​ข้า​มี​หลาย​ตั๋ว​อยู่​ตวย​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","หมู่​มัน​อ้อนวอน​พระองค์​ซ้ำแล้ว​ซ้ำแหม ขอ​บ่﻿หื้อ​พระองค์​ไล่​มัน​ออก​ไป​จาก​แคว้น​นี้ ");
INSERT INTO nod_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ต๋ำ​หมู่​นั้น​มี​หมู​หมู่​ใหญ่​ก่ำลัง​เซาะ​หา​กิ๋น​อยู่​ต๋าม​เถิ้ม​ดอย ");
INSERT INTO nod_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ผี​หมู่​นั้น​อ้อนวอน​พระเยซู​ว่า “ขอ​โผด​หื้อ​หมู่​ข้า​ตังหลาย​ไป​เข้า​ใน​หมู​หมู่​นี้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","พระองค์​ก็​ยอม​หื้อ​ไป​เข้า​อยู่​ใน​หมู​ได้ แล้ว​ผี​ฮ้าย​หมู่​นั้น​ก็​ออก​จาก​ป้อจาย​คน​นั้น ไป​เข้า​ใน​หมู​จ๋ำนวน​ประมาณ​สอง​ปัน​ตั๋ว แล้ว​หมู​ก็​ปา​กั๋น​ล่น​ลง​หน้าผา​จิ๊ง​ลง​ไป​ใน​ทะเล​แก๊น​น้ำ​ต๋าย​หมด ");
INSERT INTO nod_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","หมู่​คน​เลี้ยง​หมู​ก็​ปา​กั๋น​ล่น​หนี​ไป​เล่า​เรื่อง​นี้​หื้อ​คน​ใน​เมือง​กับ​คน​ต๋าม​บ้าน​นอก​ฟัง หมู่​เขา​ก็​ออก​มา​ผ่อ​ว่า​เกิด​อะหยัง​ขึ้น ");
INSERT INTO nod_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","เมื่อ​หมู่​เขา​ปา​กั๋น​มา​หา​พระเยซู ก็​หัน​ป้อจาย​คน​ตี้​เกย​โดน​ผี​เข้า นุ่ง​เสื้อผ้า​มี​สติ​ดี​นั่ง​อยู่ คน​ตังหลาย​ก็​ปา​กั๋น​กั๋ว ");
INSERT INTO nod_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","คน​ตังหลาย​ตี้​ได้​หัน​เหตุก๋ารณ์​ก็​เล่า​หื้อ​คน​อื่น﻿ๆ ฟัง​ว่า เกิด​อะหยัง​ขึ้น​กับ​คน​ตี้​โดน​ผี​เข้า​กับ​ตี้​เกิด​ใน​หมู่​หมู ");
INSERT INTO nod_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","คน​หมู่​นั้น​ก็​อ้อนวอน​ขอ​หื้อ​พระองค์​ออก​ไป​จาก​เขตแดน​ของ​หมู่​เขา​เหีย ");
INSERT INTO nod_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ต๋อน​ตี้​พระเยซู​ปิ๊ก​ลง​เฮือ ป้อจาย​คน​ตี้​เกย​โดน​ผี​เข้า​ก็​ขอ​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","พระองค์​บ่﻿ยอม​หื้อ​เขา​ไป แต่​บอก​เขา​ว่า “ปิ๊ก​ไป​บ้าน​เหีย แล้ว​เล่า​หื้อ​หมู่​เขา​ฟัง​เถิง​ก๋าน​ใหญ่​ตี้​องค์​พระผู้เป๋นเจ้า​ได้​เยียะ​ต่อ​เจ้า​กับ​ความ​เมตต๋า​ตี้​พระองค์​โผด​หื้อ​เจ้า” ");
INSERT INTO nod_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ป้อจาย​คน​นั้น​ก็​ปิ๊ก​ไป แล้ว​ตั้งเก๊า​บอก​หื้อ​คน​ใน​แคว้น​ทศบุรี​ฟัง​เถิง​เหตุก๋ารณ์​ตี้​พระเยซู​ได้​เยียะ​กับ​เขา คน​ตังหลาย​ก็​ปา​กั๋น​งืด​ขนาด ");
INSERT INTO nod_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","พระเยซู​ลง​เฮือ​ปิ๊ก​ไป​แหม​ฝั่ง​ของ​ทะเลสาบ หมู่​คน​จ๋ำนวน​นัก​มา​แวด​พระองค์​ตี้​ฮิม​ฝั่ง​ทะเลสาบ​นั้น ");
INSERT INTO nod_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","มี​นาย​ธรรมศาลา​ของ​จาว​ยิว​คน​นึ่ง​จื้อ​ไยรัส​มา​ตี้​หั้น​ตวย เมื่อ​เขา​หัน​พระเยซู​ก็​เข้า​มา​กราบ​ตี๋น​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","อ้อนวอน​พระองค์​ว่า “ลูกสาว​หน้อย﻿ๆ ของ​ข้าพเจ้า​ป่วย​ก่ำลัง​จะ​ต๋าย ขอ​พระองค์​โผด​ไป​วาง​มือ​บน​ตั๋ว​เขา​น่อย​เต๊อะ เปื้อ​เขา​จะ​ได้​หาย​โรค แล้ว​บ่﻿ต๋าย” ");
INSERT INTO nod_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","พระเยซู​ก็​ไป​กับ​ไยรัส หมู่​คน​จ๋ำนวน​นัก​เตียว​ยัด​ยู้​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","มี​แม่ญิง​คน​นึ่ง​เป๋น​โรค​เลือด​ตก​บ่﻿หยุด​มา​สิบ​สอง​ปี๋​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","นาง​ทนตุ๊ก​ทรมาน​หนัก​ขนาด​จาก​ก๋าน​ฮักษา​ของ​หมอ​หลาย​คน เสี้ยง​เงิน​เสี้ยง​ทอง​จ๋น​หมด​เนื้อ​หมด​ตั๋ว แต่​โรค​นั้น​ก็​บ่﻿ยังแควน​ขึ้น ซ้ำ​ปิ๊ก​เป๋น​นัก​เหลือ​เก่า ");
INSERT INTO nod_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","บ่ากอง​นาง​ได้ยิน​เรื่อง​ของ​พระเยซู ก็​เตียว​เข้า​ไป​ใน​คน​ตังหลาย ลัก​เข้า​มา​ตัง​หลัง​พระเยซู แล้ว​หยุบ​เสื้อ​คุม​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ย้อน​นาง​กึ๊ด​ใน​ใจ๋​ว่า “ถ้า​เฮา​ได้​หยุบ​ก้า​เสื้อผ้า​ของ​พระองค์ เฮา​ก็​จะ​หาย​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","บ่ากอง​เขา​หยุบ​เสื้อ​พระเยซู เลือด​ตี้​ตก​อยู่​ก็​หยุด​แห้ง​ไป​เลย นาง​ก็​ฮู้​ตั๋ว​ว่า​โรค​หาย​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","พระเยซู​ฮู้​บ่า​เดี่ยว​นั้น​เลย​ว่า​ฤทธิ์​ใน​ตั๋ว​ของ​พระองค์​ได้​แผ่ซ่าน​ออก​ไป จึง​เหลียว​ปิ๊ก​ไป​ถาม​คน​ตังหลาย​ว่า “ใผ​มา​หยุบ​เสื้อผ้า​เฮา” ");
INSERT INTO nod_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","หมู่​สาวก​ก็​ตอบ​ว่า “พระองค์​ก็​หัน​อยู่​แล้ว​ว่า​คน​ก่ำลัง​ยัด​ยู้​พระองค์​อยู่ ยัง​จะ​ถาม​อยู่​กา​ว่า ‘ใผ​หยุบ​ตั๋ว​เฮา’ ” ");
INSERT INTO nod_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","แต่​พระเยซู​ผ่อ​ไป​รอบ﻿ๆ เปื้อ​จะ​หา​คน​ตี้​หยุบ​เสื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","แม่ญิง​คน​นั้น​กั๋ว​จ๋น​ตั๋ว​สั่น ย้อน​ฮู้​ว่า​เกิด​อะหยัง​ขึ้น​กับ​นาง ก็​เข้า​มา​ก้ม​ลง​กราบ​พระองค์ แล้ว​เล่า​เรื่อง​ตี้​เกิด​ขึ้น​ตึง​หมด​หื้อ​พระองค์​ฟัง ");
INSERT INTO nod_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","พระเยซู​ก็​อู้​กับ​นาง​ว่า “ลูก​เหย ความ​เจื้อ​ของ​เจ้า​เยียะ​หื้อ​เจ้า​หาย​โรค​แล้ว จะ​บ่﻿ต้อง​ตุ๊ก​แหม ขอ​หื้อ​อยู่​ดี​มี​สุข​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ต๋อน​ตี้​พระองค์​ก่ำลัง​อู้​อยู่​นั้น มี​คน​มา​จาก​บ้าน​ของ​ไยรัส​ตี้​เป๋น​นาย​ธรรมศาลา​มา​บอก​เขา​ว่า “ลูก​สาว​ของ​ต้าน​ต๋าย​แล้ว บ่﻿ต้อง​รบก๋วน​อาจ๋ารย์​ละ” ");
INSERT INTO nod_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","เมื่อ​พระเยซู​ได้ยิน​ก็​บ่﻿สนใจ๋​ตี้​หมู่​เขา​อู้​กั๋น บอก​ไยรัส​ว่า “บ่﻿ต้อง​กั๋ว​เน่อ ขอ​หื้อ​เจื้อ​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","พระองค์​บ่﻿หื้อ​คน​อื่น​ตวย​พระองค์​ไป เว้น​แต่​เปโตร ยากอบ กับ​ยอห์น​น้องบ่าว​ของ​ยากอบ ");
INSERT INTO nod_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","เมื่อ​หมู่​เขา​มา​แผว​เฮือน​ของ​ไยรัส พระองค์​ก็​หัน​คน​วุ่น​วะ​วุ่น​วาย​ไห้​หุย​กั๋น​สนั่น​ปั่น​ปื๊น ");
INSERT INTO nod_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","พระองค์​เข้า​ไป​ใน​บ้าน แล้ว​บอก​หมู่​เขา​ว่า “หมู่​ต้าน​ปา​กั๋น​วุ่น​วะ​วุ่น​วาย​ไห้​สนั่น​ปั่น​ปื๊น​เยียะ​หยัง หละอ่อน​คน​นี้​ยัง​บ่﻿ต๋าย​เตื้อ​ลอ ก่ำลัง​นอน​หลับ​อยู่​บ่﻿ดาย” ");
INSERT INTO nod_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","หมู่​เขา​ก็​ใค่หัว​ใส่​พระองค์ หลัง​จาก​พระองค์​ไล่​หมู่​เขา​ออก​ไป​แล้ว ก็​ปา​ป้อ​แม่​ของ​หละอ่อน​กับ​สาวก​สาม​คน​ตี้​มา​ตวย​พระองค์​นั้น เข้า​ไป​ใน​ห้อง​ตี้​หละอ่อน​คน​นั้น​นอน​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","พระองค์​ก๋ำ​มือ​ของ​หละอ่อน​คน​นั้น​แล้ว​อู้​ว่า “ทาลิธา คูมิ” เป๋น​ภาษา​ฮีบรู​แป๋​ว่า “หล้า​เหย ลุก​ขึ้น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","หละอ่อน​คน​นั้น​ก็​ลุก​ขึ้น​มา แล้ว​เตียว​ไป​เตียว​มา​ใน​ห้อง​นั้น (​หละอ่อน​แม่ญิง​คน​นี้​อายุ​สิบ​สอง​ปี๋​) คน​ตี้​อยู่​ใน​ห้อง​ก็​ปา​กั๋น​งืด​อยู่​ใน​ใจ๋ ");
INSERT INTO nod_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","พระเยซู​สั่ง​หมู่​เขา​บ่﻿หื้อ​เล่า​เรื่อง​นี้​หื้อ​ใผ​ฟัง​เป๋น​เด็ด​ขาด แล้ว​บอก​ป้อ​แม่​เซาะ​ข้าว​มา​หื้อ​หละอ่อน​กิ๋น​เหีย ");
INSERT INTO nod_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","พระเยซู​ออก​จาก​ตี้​หั้น แล้ว​ปิ๊ก​ไป​เมือง​นาซาเร็ธ​บ้าน​ของ​พระองค์ หมู่​สาวก​ก็​ไป​ตวย​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","เมื่อ​เถิง​วัน​สะบาโต พระองค์​ก็​ตั้งเก๊า​สั่ง​สอน​ใน​ธรรมศาลา​ของ​จาว​ยิว มี​คน​นัก​ขนาด​ฟัง​แล้ว​งืด​ใน​กำสอน​ของ​พระองค์ ก็​อู้​กั๋น​ว่า “เขา​ไป​เอา​กำกึ๊ด​จาอี้​ตี้​ไหน​มา ผญา​ปั๋ญญา​ตี้​คน​นี้​ได้​มา​เป๋น​จาใด ตึง​ก๋าน​อัศจ๋รรย์​ต่าง﻿ๆ ก็​ยัง​เยียะ​ได้​ตวย ");
INSERT INTO nod_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","เขา​เป๋น​สล่า​ไม้​บ่﻿ใจ้​กา เป๋น​ลูก​บ่าว​ของ​มารีย์ มี​น้อง​บ่าว​จื้อ​ยากอบ โยเสส ยูดาส กับ​ซีโมน หมู่​น้องสาว​ของ​เขา​ก็​อยู่​ใน​เมือง​นี้​กับ​หมู่​เฮา​บ่﻿ใจ้​กา” หมู่​เขา​ก็​เลย​บ่﻿ยอมฮับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","พระเยซู​ก็​เลย​อู้​กับ​หมู่​เขา​ว่า “ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​นั้น​จะ​ได้ฮับ​เกียรติ​ใน​กู้﻿ๆ ตี้ ยกเว้น​ใน​บ้าน​เมือง​ตึง​ครอบครัว​ญาติ​ปี้น้อง​ของ​ตั๋ว” ");
INSERT INTO nod_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ต๋อน​ตี้​อยู่​ตี้​หั้น พระเยซู​ก็​บ่﻿สามารถ​เยียะ​ก๋าน​อัศจ๋รรย์​ได้ นอกจาก​วาง​มือ​ฮักษา​คน​ป่วย​หื้อ​หาย​บ่﻿กี่​คน​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","พระองค์​งืด​ตี้​หมู่​เขา​บ่﻿มี​ความ​เจื้อ​ใน​พระองค์ พระองค์​ก็​เลย​ไป​สอน​ต๋าม​หมู่​บ้าน​อื่น​ต๋าม​ใก้​ต๋าม​ฮิม​เหีย ");
INSERT INTO nod_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","พระองค์​ฮ้อง​สาวก​สิบ​สอง​คน​มา แล้ว​ส่ง​หมู่​เขา​ออก​ไป​เป๋น​กู้﻿ๆ พระองค์​หื้อ​หมู่​เขา​มี​สิทธิ​อำนาจ​ตี้​จะ​ไล่​ผี​ตังหลาย​ออก​ได้ ");
INSERT INTO nod_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","แล้ว​สั่ง​ว่า “บ่﻿ต้อง​เอา​อะหยัง​ติด​ตั๋ว​ไป​เน่อ นอก​จาก​ไม้เต๊า บ่﻿ต้อง​เอา​ของกิ๋น ถง​ย่าม กับ​สตางค์​ติด​ตั๋ว​ไป ");
INSERT INTO nod_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","หื้อ​สุบ​เกิบ​ได้ แต่​บ่﻿ต้อง​เอา​เสื้อผ้า​ไป​ตวย​แหม​ผืน” ");
INSERT INTO nod_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","พระองค์​ก็​อู้​กับ​หมู่​เขา​ว่า “ถ้า​เข้า​ไป​ใน​เฮือน​ใด ก็​หื้อ​ย้าง​อยู่​ตี้​เฮือน​นั้น​จ๋น​กว่า​จะ​ไป​เมือง​อื่น ");
INSERT INTO nod_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","แต่​ถ้า​ตี้​ไหน​บ่﻿ต้อนฮับ​กาว่า​บ่﻿ฟัง​หมู่​ต้าน ก็​หื้อ​ออก​จาก​ตี้​หั้น​ไป​เหีย แล้ว​ปัด​ขี้ฝุ่น​ตี้​ติด​ตี๋น​ของ​ต้าน​ขว้าง เปื้อ​ส่อ​หื้อ​หัน​ว่า​พระเจ้า​บ่﻿ปอใจ๋​กับ​บ่﻿ยอมฮับ​เขา” ");
INSERT INTO nod_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","หมู่​สาวก​ของ​พระองค์​ก็​ออก​ไป​สั่ง​สอน​หื้อ​คน​ตังหลาย​กลับใจ๋​จาก​บาป ");
INSERT INTO nod_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","หมู่​เขา​ขับ​ไล่​ผี​ออก​ไป​หลาย​ตั๋ว กับ​ตา​น้ำมัน​บ่ากอก​หื้อ​คน​เจ็บ​ป่วย​หลาย​คน คน​หมู่​นั้น​ก็​หาย ");
INSERT INTO nod_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","กษัตริย์​เฮโรด​ได้ยิน​จื้อ​เสียง​ของ​พระเยซู ย้อน​มี​คน​เล่าลือ​กั๋น​ไป​ทั่ว บาง​คน​อู้​ว่า “คน​นี้​ต้อง​เป๋น​ยอห์น​ผู้​หื้อ​บัพติศมา ตี้​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แน่﻿ๆ เถิง​เยียะ​ก๋าน​อัศจ๋รรย์​ได้” ");
INSERT INTO nod_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","พ่อง​ก็​ว่า “เขา​คือ​เอลียาห์” แต่​คน​อื่น​ก็​ว่า “เขา​คือ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า เหมือน​กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​อื่น﻿ๆ ใน​สมัย​โบราณ​นั้น” ");
INSERT INTO nod_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","เมื่อ​กษัตริย์​เฮโรด​ได้ยิน​เรื่อง​หมู่​นี้ ต้าน​อู้​ว่า “ต้อง​เป๋น​ยอห์น​คน​ตี้​เฮา​สั่ง​หื้อ​กก​คอ​แล้ว เป๋น​ขึ้น​จาก​ความ​ต๋าย​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","กษัตริย์​เฮโรด​กึ๊ด​จาอั้น​ย้อน​ว่า​ต้าน​สั่ง​หื้อ​ยับ​ยอห์น​เอา​เจื้อก​เหล็ก​ล่าม​ไว้​ใน​คอก ย้อน​หันแก่​นาง​เฮโรเดียส​เมีย​ของ​ต้าน เซิ่ง​เกย​เป๋น​เมีย​ของ​ฟีลิป​น้อง​บ่าว​ของ​ต้าน ");
INSERT INTO nod_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ยอห์น​เกย​อู้​กับ​กษัตริย์​เฮโรด​ว่า “ต้าน​บ่﻿มี​สิทธิ์​เอา​เมีย​ของ​น้อง​มา​เป๋น​เมีย​ของ​ตั๋ว” ");
INSERT INTO nod_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","เฮโรเดียส​แค้น ใค่​ฆ่า​ยอห์น แต่​กษัตริย์​เฮโรด​บ่﻿หื้อ​เยียะ ");
INSERT INTO nod_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ย้อน​พระองค์​กั๋ว​ยอห์น ต้าน​ฮู้​ว่า​ยอห์น​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม​ตึง​เป๋น​คน​บริสุทธิ์ ก็​เลย​ปกป้อง​ยอห์น​ไว้ กู้​เตื้อ​ตี้​กษัตริย์​เฮโรด​ฟัง​ยอห์น​สอน​ก็​บ่﻿ม่วนใจ๋ แต่​ก็​ยัง​ใค่​ฟัง​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","วัน​นึ่ง​เป๋น​เวลา​ดี​ตี้​เฮโรเดียส​จะ​หื้อ​ยอห์น​ถูก​ฆ่า เป๋น​วัน​เกิด​ของ​กษัตริย์​เฮโรด พระองค์​เจิญ​หมู่​ข้าราชก๋าน​จั๊น​สูง นายทหาร​จั๊น​ผู้ใหญ่ ตึง​คน​สำคัญ﻿ๆ ใน​แคว้น​กาลิลี​มา​งาน​เลี้ยง ");
INSERT INTO nod_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ใน​งาน​นั้น​ลูก​สาว​ของ​เฮโรเดียส​ฟ้อน เยียะ​หื้อ​กษัตริย์​เฮโรด​ตึง​หมู่​แขก​ปอ​อก​ปอ​ใจ๋​ขนาด กษัตริย์​เฮโรด​บอก​ว่า “จะ​ขอ​อะหยัง​เฮา​ก็​จะ​หื้อ” ");
INSERT INTO nod_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","แล้ว​กษัตริย์​เฮโรด​ยัง​สัญญา​แหม​ว่า “หนู​จะ​ขอ​อะหยัง​ก็​ได้ จะ​ขอ​แบ่ง​ราชอาณาจักร​สัก​เกิ่ง​นึ่ง​ก็​จะ​หื้อ” ");
INSERT INTO nod_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","นาง​ก็​ออก​ไป​ถาม​แม่​ว่า “แม่​เจ้า จะ​ขอ​อะหยัง​ดี” แม่​ก็​ตอบ​ว่า “ขอ​หัว​ของ​ยอห์น​ผู้​หื้อ​บัพติศมา” ");
INSERT INTO nod_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","แล้ว​นาง​ก็​ฟั่ง​ล่น​เข้า​ไป​บอก​กษัตริย์​ว่า “ข้าเจ้า​ขอ​หัว​ของ​ยอห์น​ผู้​หื้อ​บัพติศมา​ใส่​ถาด​มา​หื้อ​ข้าเจ้า​บ่าเดี่ยว​นี้” ");
INSERT INTO nod_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","กษัตริย์​เฮโรด​ก็​ตุ๊กใจ๋​อย่าง​หนัก แต่​ได้​สาบาน​ต่อหน้า​แขก​ตังหลาย​ไว้​แล้ว บ่﻿ใค่​บอก​นาง​ว่า​หื้อ​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","เฮโรด​ก็​สั่ง​หื้อ​ทหาร​คน​นึ่ง​ไป​กก​คอ​ยอห์น​มา ทหาร​คน​นั้น​ก็​ไป​กก​คอ​ยอห์น​ขำ​ใน​คอก ");
INSERT INTO nod_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","แล้ว​เอา​หัว​ใส่​ถาด​มา​หื้อ​นาง​คน​นั้น แล้ว​นาง​ก็​เอา​ไป​หื้อ​แม่ ");
INSERT INTO nod_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","เมื่อ​สาวก​ของ​ยอห์น​ฮู้​จาอั้น ก็​ปา​กั๋น​มา​ฮับ​ศพ​ของ​ยอห์น​ไป​ฝัง​ไว้​ใน​อุโมงค์ ");
INSERT INTO nod_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","หมู่​อัคร​สาวก​ตี้​พระเยซู​ส่ง​ออก​ไป​มา​แวด​พระองค์ แล้ว​รายงาน​เรื่อง​กู้​อย่าง​ตี้​ได้​เยียะ​ตึง​ได้​สอน​หื้อ​พระองค์​ฟัง แล้ว​พระเยซู​ก็​บอก​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","“หมู่​เฮา​ไป​หา​ตี้​เงียบ﻿ๆ ย้าง​กั๋น​สัก​กำ​เต๊อะ” ย้อน​ว่า​มี​คน​นัก​ขนาด​มา​หา​พระองค์​อยู่​สะลวด จ๋น​บ่﻿มี​เวลา​แม้​แต่​จะ​กิ๋น​ข้าว ");
INSERT INTO nod_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","หมู่​เขา​ก็​ลง​เฮือ​ไป​หา​ตี้​เงียบ﻿ๆ เป๋น​ส่วน​ตั๋ว ");
INSERT INTO nod_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","แต่​ก็​มี​หลาย​คน​หัน​หมู่​เขา​ไป ก็​จ๋ำ​หมู่​เขา​ได้ แล้ว​คน​หมู่​นี้​ตี้​มา​จาก​หลาย﻿ๆ หมู่​บ้าน ก็​ล่น​ไป​ต๋าม​ฮิม​ฝั่ง​ทะเล เปื้อ​ไป​ดัก​รอ​ถ้า​พระเยซู​กับ​หมู่​สาวก ");
INSERT INTO nod_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","เมื่อ​พระเยซู​ขึ้น​จาก​เฮือ ก็​หัน​คน​เป๋น​จ๋ำนวน​นัก พระองค์​ก็​ฮู้สึก​อินดู​หมู่​เขา ย้อน​ว่า​หมู่​เขา​เผียบ​เหมือน​ฝูง​แกะ​ตี้​บ่﻿มี​คน​เลี้ยง พระองค์​จึง​สั่ง​สอน​หมู่​เขา​หลาย​เรื่อง ");
INSERT INTO nod_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ตก​ต๋อน​แลง หมู่​สาวก​ก็​มา​บอก​พระองค์​ว่า “อาจ๋ารย์ บ่าเดี่ยว​นี้​ก็​ค่ำ​นัก​แก​แล้ว ต๋ำ​หมู่​นี้​ก็​ทุรกั๋นดาร ");
INSERT INTO nod_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","บอก​หื้อ​หมู่​เขา​ปิ๊ก​ไป​เหีย​ก่อน​บ๋อ เปื้อ​จะ​ได้​ไป​เซาะ​ซื้อ​ของกิ๋น​กั๋น​ต๋าม​บ้าน​ไฮ่​บ้าน​นา​ตึง​หมู่​บ้าน​ต๋ำ​หมู่​นี้​ก่อน” ");
INSERT INTO nod_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","แต่​พระองค์​อู้​ว่า “หมู่​ต้าน​ไป​เซาะ​ของ​กิ๋น​มา​เลี้ยง​หมู่​เขา​เหีย​ก่า” หมู่​สาวก​บอก​ว่า “จะ​ต้อง​ใจ๊​เงิน​จ๋ำนวน​ก้าจ้าง​สอง​ร้อย​วัน​เถิง​จะ​ปอ​ซื้อ​ของกิ๋น​มา​เลี้ยง​คน​หมู่​นี้​ได้” ");
INSERT INTO nod_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","พระเยซู​ก็​บอก​หมู่​เขา​ว่า “ไป​เซาะ​ผ่อ​ลอ​ว่า​มี​เข้าหนมปัง​อยู่​กี่​ก้อน” เมื่อ​หมู่​เขา​ฮู้​ก็​ปิ๊ก​มา​บอก​ว่า “มี​เข้าหนมปัง​ห้า​ก้อน​กับ​ป๋า​สอง​ตั๋ว” ");
INSERT INTO nod_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","พระองค์​ก็​สั่ง​หื้อ​คน​ตังหลาย​นั่ง​เป๋น​หมู่﻿ๆ บน​หญ้า​เขียว​จุ้ม​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","คน​ตังหลาย​ก็​นั่ง​ลง​เป๋น​หมู่﻿ๆ ร้อย​คน​พ่อง​ห้า​สิบ​คน​พ่อง ");
INSERT INTO nod_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","แล้ว​พระองค์​ก็​ฮับ​เข้าหนมปัง​ห้า​ก้อน​กับ​ป๋า​สอง​ตั๋ว​นั้น​มา แล้ว​แหงน​หน้า​ขึ้น​ไป​ผ่อ​ฟ้า​สวรรค์​ขอบ​พระคุณ​พระเจ้า แล้ว​ก็​หัก​เข้าหนมปัง​ส่ง​หื้อ​หมู่​สาวก​เอา​ไป​แจก​คน​ตังหลาย แล้ว​พระองค์​แบ่ง​ป๋า​สอง​ตั๋ว​แจก​หื้อ​หมู่​เขา​ตวย ");
INSERT INTO nod_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","คน​ตึง​หมด​ได้​กิ๋น​อิ่ม​กู้​คน ");
INSERT INTO nod_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","แล้ว​หมู่​สาวก​เก็บ​เข้าหนมปัง​ตึง​ป๋า​ตี้​เหลือ​ได้​สิบ​สอง​ซ้า​เต๋ม﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","คน​ตี้​กิ๋น​เข้าหนมปัง​ตวย​กั๋น​วัน​นั้น​นับ​ก้า​ป้อจาย​มี​ห้า​ปัน​คน ");
INSERT INTO nod_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","หลัง​จาก​นั้น​สัก​กำ พระเยซู​ก็​บอก​หื้อ​หมู่​สาวก​ของ​พระองค์​ลง​เฮือ​ข้าม​ฟาก​ไป​เมือง​เบธไซดา​ก่อน ส่วน​พระองค์​ยัง​อยู่​ตี้​หั้น เปื้อ​ส่ง​คน​ตังหลาย​ปิ๊ก​บ้าน ");
INSERT INTO nod_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","หลังจาก​พระองค์​ลา​คน​ตังหลาย​แล้ว ก็​ขึ้น​ไป​อธิษฐาน​บน​ดอย ");
INSERT INTO nod_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","มืด​ค่ำ​แล้ว​เฮือ​ของ​หมู่​สาวก​ลอย​อยู่​ก๋าง​ทะเลสาบ ส่วน​พระองค์​อยู่​บน​บก​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","พระองค์​หัน​หมู่​สาวก​ก่ำลัง​พาย​เฮือ​อย่าง​ยาก​ลำบาก ย้อน​เฮือ​ตอ​ลม​อยู่ หละหว่าง​ตี๋​สาม​เถิง​หก​โมง​เจ๊า พระองค์​เตียว​บน​น้ำ​ไป​หา​หมู่​เขา กับ​เหมือน​ว่า​ก่ำลัง​จะ​เตียว​ก๋าย​หมู่​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","เมื่อ​หมู่​สาวก​หัน​พระองค์​เตียว​มา​บน​น้ำ​ก็​กึ๊ด​ว่า​เป๋น​ผี เลย​ฮ้อง​เสียง​ดัง ");
INSERT INTO nod_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ย้อน​ว่า​ตกใจ๋​กั๋ว แล้ว​พระองค์​ก็​อู้​กับ​หมู่​เขา​ต๋อน​นั้น​ว่า “แป๋ง​ใจ๋​ดี﻿ๆ ไว้ นี่​เฮา​เน่อ บ่﻿ถ้า​กั๋ว” ");
INSERT INTO nod_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","เมื่อ​พระเยซู​ขึ้น​เฮือ​แล้ว ลม​ก็​ย้าง หมู่​เขา​ปา​กั๋น​งืด​ขนาด​ตี้​พระองค์​เตียว​บน​น้ำ​ได้​กับ​ลม​ก็​หยุด ");
INSERT INTO nod_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ย้อน​เขา​ยัง​บ่﻿เข้าใจ๋​ความหมาย​เรื่อง​เข้าหนมปัง​ห้า​ก้อน​นั้น สุด​ปั๋ญญา​หมู่​เขา​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","หลัง​จาก​ข้าม​ฟาก​มา​แผว​ฝั่ง​แคว้น​เยนเนซาเรท​แล้ว หมู่​สาวก​ก็​มัด​เฮือ​ไว้ ");
INSERT INTO nod_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","เมื่อ​ขึ้น​มา​จาก​เฮือ​แล้ว คน​ตี้​หั้น​ก็​จ๋ำ​พระเยซู​ได้ ");
INSERT INTO nod_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ก็​ล่น​ไป​บอก​หมู่​คน​อื่น﻿ๆ ใคว่​แคว้น แล้ว​หาม​คน​ป่วย​ใส่​ตี้​นอน​มา​หา​พระองค์ ฮู้​ว่า​พระองค์​อยู่​ตัง​ใด​ก็​ไป​หา​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","พระองค์​ไป​ตัง​ใด​บ่﻿ว่า​ใน​หมู่บ้าน ใน​เมือง กาว่า​ไป​บ้าน​นอก​ก็​ดี คน​ตังหลาย​ก็​ปา​เอา​คน​ป่วย​มา​นอน​ต๋าม​กาด เปื้อ​ขอ​หยุบ​ตี๋น​เสื้อ​คุม​ของ​พระองค์ กู้​คน​ตี้​ได้​หยุบ​ตี๋น​เสื้อ​ของ​พระองค์​ก็​หาย​ป่วย ");
INSERT INTO nod_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","มี​หมู่​ฟาริสี​กับ​หมู่​ธรรมาจ๋ารย์​ตี้​มา​จาก​กรุง​เยรูซาเล็ม​ปา​กั๋น​มา​หา​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","หมู่​เขา​หัน​สาวก​ของ​พระเยซู​บาง​คน​บ่﻿ซ่วย​มือ​ต๋าม​พิธี​ตาง​ศาสนา​ยิว​ก่อน​กิ๋น​ข้าว ");
INSERT INTO nod_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(​จาว​ยิว​ตังหลาย​ตึง​คน​ตี้​เป๋น​หมู่​ฟาริสี​จะ​ถือ​ต๋าม​กำสอน​ตี้​ป้ออุ๊ย​แม่หม่อน​สอน​ต่อ﻿ๆ กั๋น​มา​ว่า ถ้า​บ่﻿ซ่วย​มือ​ต๋าม​พิธี​ตาง​ศาสนา​เหีย​ก่อน จะ​บ่﻿กิ๋น​ข้าว​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","หลัง​จาก​ไป​ซื้อ​ของ​ใน​กาด​มา​แล้ว ก็​ต้อง​ซ่วย​มือ​ต๋าม​พิธี​นั้น​เหีย​ก่อน​เหมือน​กั๋น แล้ว​ก้อย​กิ๋น​ข้าว ก็​มี​ฮีต​ฮอย​อื่น﻿ๆ แหม​หลาย​อย่าง​ตี้​เขา​ถือ อย่าง​ก๋าน​ล้าง​ถ้วย จ๊อน หม้อ​ใส่​น้ำ ตึง​หม้อแก๋ง​ตวย​) ");
INSERT INTO nod_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ย้อน​จาอั้น​หมู่​ฟาริสี​กับ​หมู่​ธรรมาจ๋ารย์​ก็​ถาม​พระเยซู​ว่า “เป๋น​จาใด​หมู่​สาวก​ของ​ต้าน​บ่﻿เยียะ​ต๋าม​ฮีต​เก่า​ฮอย​เดิม​ตี้​ป้ออุ๊ย​แม่หม่อน​สอน​ไว้ แต่​ปา​กั๋น​ใจ๊​มือ​ตี้​เป๋น​มลทิน​กิ๋น​ข้าว” ");
INSERT INTO nod_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","พระองค์​ตอบ​ว่า “หมู่​ต้าน​เป๋น​คน​หน้า​ซื่อ​ใจ๋​ก๊ด อิสยาห์​อู้​ถูก​แต๊﻿ๆ ตี้​ตวายตั๊ก​เถิง​หมู่​ต้าน​ว่า “​คน​หมู่​นี้​นับถือ​เฮา​ก้า​ปาก​ของ​เขา​เต้าอั้น แต่​ใจ๋​อยู่​ห่าง​ไก๋​จาก​เฮา​ขนาด ");
INSERT INTO nod_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ก็​เลย​บ่﻿มี​ประโยชน์​ตี้​หมู่​เขา​จะ​นมัสก๋าน​เฮา ย้อน​เขา​เอา​กฎ​ตี้​คน​ตั้ง​ขึ้น​มา​อ้าง​เป๋น​กำสั่ง​ของ​พระเจ้า​” ");
INSERT INTO nod_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","หมู่​ต้าน​ละเลย​กำสั่ง​สอน​ของ​พระเจ้า แล้ว​ไป​ยึด​ถือ​ต๋าม​กำสอน​ของ​ป้ออุ๊ย​แม่หม่อน​ตี้​สอน​ต่อ﻿ๆ กั๋น​มา” ");
INSERT INTO nod_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","แล้ว​พระเยซู​อู้​แหม​ว่า “หมู่​ต้าน​เก่ง​ขนาด​ตี้​ปา​กั๋น​หลบ​หลีก​กำสั่ง​ของ​พระเจ้า เปื้อ​เยียะ​ต๋าม​ฮีต​เก่า​ฮอย​เดิม​ของ​ป้ออุ๊ย​แม่หม่อน​ตี้​สอน​ต่อ﻿ๆ กั๋น​นั้น ");
INSERT INTO nod_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","อย่าง​เจ้น โมเสส​สอน​ไว้​ว่า ‘จง​เคารพ​นับถือ​ป้อ​แม่​ของ​ตั๋ว’ กับ ‘คน​ใด​ตี้​สาป​แจ้ง​ป้อ​แม่​จะ​ต้อง​มี​โต้ษ​เถิง​ต๋าย’ ");
INSERT INTO nod_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","แต่​หมู่​ต้าน​แอกขะแตก​สอน​ว่า ทรัพย์​สมบัติ​ตี้​ควร​จะ​จ้วยเหลือ​ป้อ​แม่​นั้น ก็​เปิง​ดี​ตี้​จะ​เอา​ไป​ถวาย​หื้อ​กับ​พระเจ้า​แตน​ ");
INSERT INTO nod_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ลูก​คน​นั้น​ก็​มี​ข้อ​แก้​ตั๋ว​บ่﻿ต้อง​จ้วยเหลือ​ป้อ​แม่ ");
INSERT INTO nod_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","หมู่​ต้าน​ก็​เยียะ​หื้อ​ถ้อยกำ​ของ​พระเจ้า​บ่﻿มี​ผล ย้อน​ฮีต​เก่า​ฮอย​เดิม​ตี้​สอน​ต่อ﻿ๆ กั๋น​มา กับ​โดย​เยียะ​แหม​หลาย​อย่าง​ตี้​เหมือน​กับ​จาอี้​ตวย” ");
INSERT INTO nod_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","พระเยซู​ก็​ฮ้อง​คน​ตังหลาย​เข้า​มา​หา​แหม แล้ว​อู้​กับ​หมู่​เขา​ว่า “หมู่​ต้าน​กู้​คน​ฟัง​หื้อ​ดี﻿ๆ หื้อ​เข้าใจ๋​แต๊﻿ๆ เน่อ ");
INSERT INTO nod_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ก๋าน​กิ๋น​ของ​ตี้​ห้าม​กิ๋น​บ่﻿ได้​เยียะ​หื้อ​คน​เป๋น​มลทิน แต่​สิ่ง​ตี้​ออก​มา​จาก​ตัง​ใน​ใจ๋ สิ่ง​นั้น​ละ​จะ​เยียะ​หื้อ​คน​เป๋น​มลทิน ");
INSERT INTO nod_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","เมื่อ​พระเยซู​ละ​คน​ตังหลาย​เข้า​ไป​ใน​เฮือน หมู่​สาวก​ก็​เข้า​มา​ถาม​พระองค์​ว่า “กำเผียบ​นั้น​หมายความ​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","พระองค์​ปิ๊ก​ถาม​หมู่​เขา​ว่า “ต้าน​ตังหลาย​ยัง​บ่﻿เข้าใจ๋​แหม​กา ต้าน​ยัง​บ่﻿หัน​เตื้อ​ก๋า คือ​ว่า​บ่﻿มี​อะหยัง​ตี้​เข้า​ปาก​ไป​แล้ว​เยียะ​หื้อ​คน​เป๋น​มลทิน​ได้ ");
INSERT INTO nod_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ย้อน​ว่า​บ่﻿ได้​เข้า​ไป​ใน​จิตใจ๋ แต่​ลง​ต๊อง​แล้ว​ก็​ถ่าย​ออก​ไป​เหีย” (​ตี้​อู้​จาอี้​เป๋น​ก๋าน​บอก​หื้อ​ฮู้​ว่า​ของ​กิ๋น​กู้​อย่าง​กิ๋น​ได้ บ่﻿มี​อัน​ใด​เป๋น​มลทิน) ");
INSERT INTO nod_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","พระองค์​ก็​อู้​ต่อ​แหม​ว่า “สิ่ง​ตี้​ออก​มา​จาก​จิตใจ๋​ของ​คน​นั้น​ละ​เยียะ​หื้อ​คน​เป๋น​มลทิน ");
INSERT INTO nod_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ย้อน​ว่า​สิ่ง​ตี้​ออก​มา​จาก​จิตใจ๋​ของ​คน​คือ​ก๋าน​กึ๊ด​ฮ้าย ก๋าน​ลัก​ของ ก๋าน​ฆ่า​คน ก๋าน​เยียะ​บาป​ตาง​เพศ​กู้​อย่าง ");
INSERT INTO nod_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ก๋าน​เล่น​จู๊ ก๋าน​ขี้โลภ ก๋าน​เยียะ​ฮ้าย ก๋าน​หลอกลวง ราคะ​ตั๋ณหา ความ​อิจฉา​ขอย​ยวน ก๋าน​ใส่​ฮ้าย​คน​อื่น ความ​หยิ่ง​จ๋องหอง กับ​ก๋าน​เป๋น​คน​บ่﻿มี​สำนึก​ใน​ตาง​ธรรม ");
INSERT INTO nod_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","สะป๊ะ​กู้​สิ่ง​ตี้​บ่﻿ดี​นี้​ออก​จาก​ใจ๋​ของ​คน เยียะ​หื้อ​คน​เป๋น​มลทิน” ");
INSERT INTO nod_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","พระเยซู​ลุก​จาก​ตี้​หั้น​เข้า​ไป​ใน​แคว้น​เมือง​ไทระ​กับ​เมือง​ไซดอน​ แล้ว​เข้า​ไป​ใน​เฮือน​หลัง​นึ่ง พระองค์​บ่﻿ต้อง​ก๋าน​หื้อ​ใผ​ฮู้​ใผ​หัน แต่​ก็​ยัง​มี​คน​ฮู้​คน​หัน​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","มี​แม่ญิง​คน​นึ่ง ลูกสาว​ของ​นาง​ถูก​ผี​ฮ้าย​เข้า เมื่อ​ฮู้​ข่าว​เถิง​เรื่อง​พระเยซู นาง​ก็​เข้า​มา แล้ว​ไหว้​ตี้​ตี๋น​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","แม่ญิง​คน​นั้น​บ่﻿ใจ้​เป๋น​จาว​ยิว แต่​เป๋น​จาว​ซีเรีย​ฟีนิเซีย ตี้​อู้​ภาษา​กรีก นาง​มา​อ้อนวอน​ขอ​หื้อ​พระองค์​ขับ​ไล่​ผี​ออก​จาก​ลูก​สาว ");
INSERT INTO nod_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","พระองค์​อู้​กับ​แม่ญิง​คน​นั้น​ว่า “หื้อ​หมู่​ลูก​กิ๋น​อิ่ม​เหีย​ก่อน​เต๊อะ บ่﻿ถูกต้อง​ตี้​จะ​เอา​ของกิ๋น​ของ​ลูก​ไป​โจ้ง​หื้อ​หมา” ");
INSERT INTO nod_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","แต่​แม่ญิง​คน​นั้น​ตอบ​พระองค์​ว่า “แม่น​แล้ว​ต้าน​เจ้า​ข้า แม้​แต่​หมา​ตี้​อยู่​ปื๊น​โต๊ะ ก็​ได้​กิ๋น​เศษ​ของกิ๋น​ลูก​ตี้​ตก​ลง​จาก​โต๊ะ” ");
INSERT INTO nod_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","พระเยซู​บอก​นาง​ว่า “ย้อน​เจ้า​ตอบ​จาอี้ ปิ๊ก​ไป​บ้าน​เจ้า​เต๊อะ ผี​ออก​จาก​ลูก​สาว​แล้ว​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","เมื่อ​นาง​ปิ๊ก​ไป​แผว​บ้าน ก็​หัน​ลูก​สาว​นอน​อยู่​บน​ตี้นอน ผี​ออก​ไป​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","แล้ว​พระเยซู​ออก​จาก​แคว้น​เมือง​ไทระ​เตียว​ก๋าย​เมือง​ไซดอน ไป​ทะเลสาบ​กาลิลี​ใน​แคว้น​ทศบุรี ");
INSERT INTO nod_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","มี​คน​ปา​ป้อจาย​หู​หนวก​ปาก​กั๊ก​คน​นึ่ง​มา​หา​พระองค์ อ้อนวอน​ขอ​พระองค์​วาง​มือ​บน​ตั๋ว​คน​นั้น เปื้อ​ฮักษา​เขา​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","พระองค์​ปา​ป้อจาย​คน​นั้น​ออก​จาก​คน​ตังหลาย​ไป​อยู่​แหม​ตี้​นึ่ง พระองค์​เอา​นิ้ว​มือ​ซุก​เข้า​ไป​ใน​ฮู​หู​ของ​เขา แล้ว​ถ่ม​น้ำลาย​ใส่​นิ้ว​มือ​แปด​ตี้​ลิ้น​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","แล้ว​พระองค์​แหงน​หน้า​ผ่อ​ฟ้า​สวรรค์ ถอน​หาย​ใจ๋​ยาว​ด้วย​ความ​อินดู​แล้ว​บอก​คน​นั้น​ว่า “เอฟฟาธา” แป๋​ว่า “จง​เปิด​ออก” ");
INSERT INTO nod_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","แล้ว​หู​ของ​คน​นั้น​ก็​ได้ยิน ลิ้น​ก็​อู้​ได้​ถอบ​ขึ้น​มา​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","พระองค์​สั่ง​หมู่​คน​ตี้​ปา​เขา​มา​บ่﻿หื้อ​ไป​เล่า​เรื่อง​นี้​หื้อ​ใผ​ฟัง แต่​ยิ่ง​พระองค์​สั่ง​ห้าม​นัก​เต้า​ใด หมู่​เขา​ก็​ยิ่ง​บอก​คน​อื่น​นัก​ขึ้น​เต้า​อั้น ");
INSERT INTO nod_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","คน​ตังหลาย​ก็​ปา​กั๋น​งืด​ขนาด​อู้​กั๋น​ว่า “กู้​สิ่ง​ตี้​พระเยซู​เยียะ​นั้น​ดี​ขนาด พระองค์​เยียะ​หื้อ​คน​หู​หนวก​ได้ยิน เยียะ​หื้อ​คน​ใบ้​อู้​ได้” ");
INSERT INTO nod_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","เวลา​นั้น​มี​คน​จ๋ำนวน​นัก​มา​หา​พระเยซู​แหม แต่​เมื่อ​ของกิ๋น​เสี้ยง​หมด​แล้ว พระเยซู​จึง​ฮ้อง​หมู่​สาวก​มา​หา​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“เฮา​อินดู​คน​หมู่​นี้​ขนาด ย้อน​หมู่​เขา​อยู่​ตวย​เฮา​สาม​วัน​มา​แล้ว บ่าเดี่ยว​นี้​บ่﻿มี​อะหยัง​กิ๋น​สัก​อย่าง ");
INSERT INTO nod_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ถ้า​เฮา​หื้อ​หมู่​เขา​ปิ๊ก​บ้าน​โดย​บ่﻿ได้​กิ๋น​อะหยัง​เตื้อ หมู่​เขา​ก็​จะ​เป๋น​ปิ​หมด​แฮง​ก๋าง​ตาง ย้อน​ว่า​บาง​คน​ก็​ลุก​จาก​ตี้​ไก๋﻿ๆ มา” ");
INSERT INTO nod_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","หมู่​สาวก​ก็​ตอบ​ว่า “ใน​ตี้​ทุรกั๋นดาร​จาอี้ จะ​ไป​เซาะ​ของกิ๋น​ตี้​ไหน​มา​เลี้ยง​หมู่​เขา​ปะล้ำ​ปะเหลือ” ");
INSERT INTO nod_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","พระเยซู​ถาม​หมู่​สาวก​ว่า “หมู่​ต้าน​มี​เข้าหนมปัง​กี่​ก้อน” หมู่​สาวก​ตอบ​ว่า “เจ็ด​ก้อน​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","พระองค์​สั่ง​หื้อ​คน​ตังหลาย​นั่ง​ลง​บน​ปื๊น​ดิน แล้ว​พระองค์​ฮับ​เอา​เข้าหนมปัง​มา​อธิษฐาน​ขอบพระคุณ​พระเจ้า แล้ว​ก็​หัก​เข้าหนมปัง​ยื่น​หื้อ​หมู่​สาวก​เอา​ไป​แจก​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","หมู่​เขา​มี​ป๋า​ตั๋ว​หน้อย﻿ๆ บ่﻿กี่​ตั๋ว พระองค์​ก็​เอา​ป๋า​นั้น​มา​ขอบ​พระคุณ​พระเจ้า แล้ว​หื้อ​หมู่​สาวก​เอา​ไป​แจก​ตวย ");
INSERT INTO nod_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","คน​ตังหลาย​กิ๋น​อิ่ม​กั๋น​หมด​แล้ว ยัง​เก็บ​ของกิ๋น​ตี้​เหลือ​ใส่​ก๋วย​ได้​แหม​เจ็ด​แก่น ");
INSERT INTO nod_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","คน​ตี้​อยู่​ตี้​หั้น​มี​ประมาณ​สี่​ปัน​คน แล้ว​พระองค์​ก็​ส่ง​เขา​ตังหลาย​ปิ๊ก​เมือ​บ้าน ");
INSERT INTO nod_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ส่วน​พระองค์​กับ​หมู่​สาวก​ปา​กั๋น​ลง​เฮือ​ไป​แคว้น​ดาลมานูธา​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","หมู่​ฟาริสี​ตั้งเก๊า​เถียง​พระเยซู แล้ว​ขอ​หื้อ​พระองค์​เยียะ​หมายสำคัญ​จาก​ฟ้า​สวรรค์​หื้อ​ผ่อ เปื้อ​จะ​ฮู้​ว่า​พระองค์​มา​จาก​พระเจ้า​แต๊﻿ๆ ก่อ ");
INSERT INTO nod_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","พระเยซู​ถอน​หายใจ๋​ยาว​แล้ว​อู้​ว่า “เป๋น​จาใด​คน​ใน​สมัย​นี้​ผ่อ​หา​ก้า​หมายสำคัญ​เต้าอั้น เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เฮา​จะ​บ่﻿เยียะ​หมายสำคัญ​หื้อ​คน​ใน​สมัย​นี้​หัน” ");
INSERT INTO nod_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","พระองค์​ก็​ละ​หมู่​เขา​ไว้​หั้น แล้ว​ลง​เฮือ​กับ​หมู่​สาวก​ข้าม​ทะเลสาบ​ไป​แหม​ฝั่ง​นึ่ง​เหีย ");
INSERT INTO nod_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","หมู่​สาวก​ลืม​เอา​เข้าหนมปัง​มา​ตวย ใน​เฮือ​มี​อยู่​ก้อน​เดียว ");
INSERT INTO nod_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","พระเยซู​เตื๋อน​หมู่​เขา​ว่า “หละวัง​เจื๊อฟู​ของ​หมู่​ฟาริสี กับ​เจื๊อฟู​ของ​กษัตริย์​เฮโรด​ไว้​หื้อ​ดี﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","หมู่​สาวก​อู้​กั๋น​ว่า “ตี้​พระองค์​อู้​จาอี้​ก็​ย้อน​ว่า​หมู่​เฮา​บ่﻿มี​เข้าหนมปัง” ");
INSERT INTO nod_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","พระเยซู​ฮู้​ว่า​หมู่​เขา​อู้​เรื่อง​อะหยัง​กั๋น​อยู่​ก็​เลย​อู้​ว่า “เยียะ​หยัง​หมู่​ต้าน​ปา​กั๋น​อู้​เรื่อง​บ่﻿มี​เข้าหนมปัง หมู่​ต้าน​ยัง​บ่﻿เข้าใจ๋​เตื้อ​กา กาว่า​สุด​กำกึ๊ด​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","มี​ต๋า​ก็​ผ่อ​บ่﻿หัน กับ​มี​หู​ก็​บ่﻿ได้ยิน​จาอั้น​กา หมู่​ต้าน​จ๋ำ​บ่﻿ได้​กา ");
INSERT INTO nod_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ต๋อน​ตี้​เฮา​เอา​เข้าหนมปัง​ห้า​ก้อน​เลี้ยง​ตึง​ห้า​ปัน​คน​นั้น หมู่​ต้าน​เก็บ​ตี้​เหลือ​ได้​กี่​ซ้า” หมู่​เขา​ตอบ​ว่า “ได้​สิบ​สอง​ซ้า” ");
INSERT INTO nod_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ต๋อน​ตี้​เฮา​เอา​เข้าหนมปัง​เจ็ด​ก้อน​เลี้ยง​ตึง​สี่​ปัน​คน​ลอ ต้าน​ตังหลาย​เก็บ​ตี้​เหลือ​ได้​กี่​ก๋วย” หมู่​เขา​ตอบ​ว่า “ได้​เจ็ด​ก๋วย” ");
INSERT INTO nod_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","แล้ว​พระเยซู​ก็​อู้​ว่า “ยัง​บ่﻿เข้าใจ๋​เตื้อ​กา” ");
INSERT INTO nod_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","เมื่อ​พระเยซู​ตึง​หมู่​สาวก​มา​แผว​เมือง​เบธไซดา มี​คน​ปา​คน​ต๋าบอด​คน​นึ่ง​มา​อ้อนวอน​ขอ​พระองค์​ฮักษา​เขา​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","พระองค์​ก็​จู๋ง​มือ​คน​ต๋า​บอด​ออก​มา​นอก​หมู่​บ้าน แล้ว​ถ่ม​น้ำลาย​ใส่​ต๋า​ตึง​วาง​มือ​บน​ต๋า​สอง​เบื้อง​ของ​คน​นั้น ถาม​ว่า “ผ่อ​หัน​อะหยัง​พ่อง​ก่อ” ");
INSERT INTO nod_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","คน​ต๋า​บอด​ก็​ได้​เหงย​หน้า​ขึ้น​มา​ผ่อ​แล้ว​บอก​ว่า “หัน​คน​เหมือน​เก๊าไม้​เตียว​ไป​เตียว​มา” ");
INSERT INTO nod_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","พระองค์​ก็​วาง​มือ​บน​ต๋า​ของ​เขา​แหม​เตื้อ​นึ่ง คน​ต๋า​บอด​ก็​ปัก​ต๋า​ผ่อ ต๋า​ของ​เขา​ก็​หาย​ดี เขา​ผ่อ​หัน​สิ่ง​ตังหลาย​ได้​เป่ง​หลึ้ง ");
INSERT INTO nod_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","พระองค์​ก็​ส่ง​เขา​ปิ๊ก​เมือ​บ้าน​เหีย​กับ​บอก​ว่า “ห้าม​แว่​เข้า​ไป​ใน​หมู่​บ้าน​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","พระเยซู​กับ​หมู่​สาวก​เตียวตาง​ไป​ต๋าม​หมู่​บ้าน​ใก้​เมือง​ซีซารียา​ฟีลิปปี ต๋อน​เตียว​ก๋าง​ตาง​นั้น​พระองค์​ถาม​หมู่​สาวก​ของ​พระองค์​ว่า “คน​ตังหลาย​อู้​กั๋น​ว่า​เฮา​เป๋น​ใผ​กา” ");
INSERT INTO nod_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","หมู่​สาวก​ตอบ​ว่า “บาง​คน​ก็​ว่า​เป๋น​ยอห์น​ผู้​หื้อ​บัพติศมา บาง​คน​ก็​ว่า​เป๋น​เอลียาห์ แล้ว​มี​บาง​คน​ว่า​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​นึ่ง” ");
INSERT INTO nod_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","แล้ว​พระองค์​ถาม​หมู่​เขา​ว่า “หมู่​ต้าน​ลอ กึ๊ด​ว่า​เฮา​เป๋น​ใผ” เปโตร​ตอบ​ว่า “พระองค์​เป๋น​พระคริสต์” ");
INSERT INTO nod_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","แล้ว​พระองค์​ก็​สั่ง​หมู่​สาวก​บ่﻿หื้อ​บอก​คน​อื่น​ว่า​พระองค์​เป๋น​ใผ ");
INSERT INTO nod_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","แล้ว​พระเยซู​ตั้งเก๊า​สอน​หื้อ​หมู่​เขา​ฮู้​ว่า “บุตรมนุษย์​จะ​ต้อง​ได้​ฮับ​ความ​ตุ๊ก​ทรมาน​หลาย​อย่าง หมู่​คน​เฒ่า​คน​แก่ หมู่​หัวหน้า​ปุโรหิต ตึง​หมู่​ธรรมาจ๋ารย์​จะ​บ่﻿ยอมฮับ​พระองค์ ใน​ตี้​สุด​พระองค์​จะ​ต้อง​ถูก​ฆ่า​ต๋าย แต่​หลัง​จาก​นั้น​แหม​สาม​วัน​พระเจ้า​จะ​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","พระเยซู​เล่า​เรื่อง​นี้​หื้อ​หมู่​สาวก​ฟัง​อย่าง​บ่﻿ปิด​บัง​อะหยัง ส่วน​เปโตร​ปา​พระเยซู​ออก​จาก​หมู่ แล้ว​ว่า​หื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","พระเยซู​งว้าย​หน้า​มา​ผ่อ​หมู่​สาวก​แล้ว​ก็​ด่า​เปโตร​ว่า “ไอ่​ซาต๋าน ไป​หื้อ​ป๊น​หู​ป๊น​ต๋า ย้อน​ว่า​เจ้า​บ่﻿ได้​กึ๊ด​อย่าง​พระเจ้า แต่​กึ๊ด​อย่าง​คน” ");
INSERT INTO nod_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","แล้ว​พระองค์​ฮ้อง​คน​ตังหลาย​กับ​หมู่​สาวก​เข้า​มา​หา แล้ว​บอก​หมู่​เขา​ว่า “ถ้า​ใผ​คน​ใด​ใค่​เป๋น​สาวก​ของ​เฮา ก็​หื้อ​คน​นั้น​ตัด​อก​ตัด​ใจ๋ แบก​ไม้​ก๋าง​เขน​ของ​ตั๋ว​เก่า แล้ว​ตวย​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ย้อน​ว่า​ถ้า​คน​ใด​ใค่​ฮักษา​จีวิต​ของ​ตั๋ว​ไว้ คน​นั้น​จะ​ฮักษา​จีวิต​นั้น​บ่﻿ได้​ก็​จะ​ต๋าย แต่​ถ้า​คน​ใด​ยอม​สละ​จีวิต​ของ​ตั๋ว​ย้อน​หัน​แก่​เฮา​ตึง​ข่าวดี คน​นั้น​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","จะ​มี​ประโยชน์​อะหยัง ถ้า​ได้​เป๋น​เจ้าของ​กู้​สิ่ง​กู้​อย่าง​ใน​โลก​นี้ แต่​ต้อง​เสีย​จีวิต​ของ​ตั๋ว​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ต้าน​จะ​เอา​อะหยัง​ไป​แลก​กับ​จีวิต​ของ​ต้าน​ปิ๊ก​คืน​มา​ได้ ");
INSERT INTO nod_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ใน​ยุค​นี้​ตี้​มี​คน​บาป​เป๋น​คน​บ่﻿ซื่อสัตย์​ต่อ​พระเจ้า ถ้า​คน​ใด​อาย​ย้อน​ติดต๋าม​เฮา​กับ​กำสอน​ของ​เฮา เฮา​ผู้​เป๋น​บุตรมนุษย์​ก็​จะ​อาย​คน​นั้น​ตวย​เมื่อ​เฮา​ปิ๊ก​มา​ใน​โลก​ด้วย​รัศมี​ของ​พระบิดา​ฮ่วม​กับ​หมู่​ทูตสวรรค์​บริสุทธิ์” ");
INSERT INTO nod_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","พระเยซู​อู้​กับ​หมู่​เขา​แหม​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า หมู่​ต้าน​บาง​คน​ตี้​ยืน​อยู่​ตี้​นี่ จะ​ยัง​บ่﻿ต๋าย​เตื้อ​จ๋น​กว่า​จะ​ได้​หัน​แผ่นดิน​ของ​พระเจ้า​มา​ด้วย​ฤทธิ์​เดช” ");
INSERT INTO nod_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","หลัง​จาก​นั้น​หก​วัน​พระเยซู​ปา​เปโตร ยากอบ กับ​ยอห์น​ขึ้น​ไป​บน​ดอย​สูง​ตวย​กั๋น บ่﻿มี​คน​อื่น​ตี้​หั้น แล้ว​ตั๋ว​ของ​พระองค์​ก็​เปี่ยน​ไป​ต่อ​หน้า​ต่อ​ต๋า​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","เสื้อผ้า​ของ​พระองค์​ก็​ขาว​จ๋น​เหลื้อม​มาบ﻿ๆ บ่﻿มี​สล่า​ฟอก​ผ้า​คน​ใด​ใน​โลก​จะ​ฟอก​เสื้อผ้า​หื้อ​ขาว​จาอั้น​ได้ ");
INSERT INTO nod_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","แล้ว​หมู่​เขา​ก็​หัน​เอลียาห์​กับ​โมเสส​ก่ำลัง​อู้​กับ​พระเยซู​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","เปโตร​บอก​พระเยซู​ว่า “อาจ๋ารย์​ครับ เป๋น​สิ่ง​ดี​แต๊﻿ๆ ตี้​หมู่​เฮา​ได้​มา​อยู่​ตี้​นี่ หมู่​เฮา​จะ​แป๋ง​ตูบ​ไว้​สาม​หลัง​หื้อ​อาจ๋ารย์ โมเสส กับ​เอลียาห์​คน​ละ​หลัง” ");
INSERT INTO nod_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ตี้​เปโตร​อู้​จาอั้น​ก็​ย้อน​ว่า​หมู่​เขา​ยัง​สะดุ้ง​ตก​ใจ๋​อยู่ เลย​บ่﻿ฮู้​ว่า​จะ​อู้​จาใด​ดี ");
INSERT INTO nod_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","จาก​นั้น​ก็​มี​เมฆ​มา​หุ้ม​หมู่​เขา​ไว้ แล้ว​มี​เสียง​ออก​มา​จาก​เมฆ​ว่า “ต้าน​ผู้​นี้​เป๋น​ลูก​ตี้​เฮา​ฮัก หื้อ​เจื้อฟัง​ต้าน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","หมู่​เขา​ฟั่ง​เหลียว​ผ่อ​รอบ﻿ๆ ตันใด​นั้น​ก็​บ่﻿หัน​ใผ หัน​ก้า​พระเยซู​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ต๋อน​ตี้​ปา​กั๋น​เตียว​ลง​มา​จาก​ดอย​นั้น พระองค์​สั่ง​ห้าม​หมู่​เขา​บ่﻿หื้อ​เล่า​เรื่อง​ตี้​หัน​นี้​หื้อ​ใผ​ฟัง จ๋น​กว่า​บุตรมนุษย์​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","หมู่​เขา​ก็​เก็บ​เรื่อง​นี้​ไว้ แต่​ก็​ยัง​ถาม​ใน​หมู่​เดียว​กั๋น​ว่า ตี้​พระองค์​อู้​ว่า “เป๋น​ขึ้น​จาก​ความ​ต๋าย” นั้น​หมายความ​ว่า​จาใด ");
INSERT INTO nod_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","แล้ว​หมู่​เขา​ถาม​พระองค์​ว่า “เป๋น​จาใด​หมู่​ธรรมาจ๋ารย์​ปา​กั๋น​อู้​ว่า​เอลียาห์​ต้อง​มา​ก่อน​พระคริสต์” ");
INSERT INTO nod_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","พระเยซู​ตอบ​ว่า “ถูก​แล้ว ตี้​เอลียาห์​ต้อง​มา​ก่อน​เปื้อ​มา​เกียม​กู้​สิ่ง​กู้​อย่าง​หื้อ​ปิ๊ก​เหมือน​เก่า แต่​จ๋ำ​ได้​ก่อ​ว่า​พระคัมภีร์​เขียน​เถิง​บุตรมนุษย์​ไว้​ตวย​ว่า บุตรมนุษย์​จะ​ต้อง​ทน​ตุ๊ก​ทรมาน​อย่าง​แสนสาหัส​กับ​ถูก​ละ​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","แต่​เฮา​จะ​บอก​หื้อ​ฮู้​ว่า​เอลียาห์​ได้​มา​แล้ว คน​ตังหลาย​ก็​ปา​กั๋น​เยียะ​บ่﻿ดี​กับ​เปิ้น​ต๋าม​ใจ๋​ของ​หมู่​เขา เหมือน​กับ​ตี้​เกย​เขียน​ไว้​ใน​พระคัมภีร์” ");
INSERT INTO nod_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","เมื่อ​พระเยซู​กับ​สาวก​ลง​ดอย​มา​หา​หมู่​สาวก​ตี้​ถ้า​อยู่​ตัง​ลุ่ม ก็​หัน​มี​คน​จ๋ำนวน​นัก​แวด​ตะหลุ้ม​หมู่​สาวก​อยู่ มี​หมู่​ธรรมาจ๋ารย์​ก่ำลัง​เถียง​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","เมื่อ​คน​ตังหลาย​หัน​พระเยซู​เตียว​มา ก็​แปลกใจ๋​กับ​ดีใจ๋ ปา​กั๋น​ล่น​เข้า​มา​ต้อนฮับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","พระเยซู​ถาม​หมู่​เขา​ว่า “ก่ำลัง​เถียง​กั๋น​เรื่อง​อะหยัง” ");
INSERT INTO nod_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","มี​ป้อจาย​คน​นึ่ง​ใน​คน​ตังหลาย​นั้น​ตอบ​พระองค์​ว่า “อาจ๋ารย์​ครับ ข้าพเจ้า​ปา​ลูก​บ่าว​มา​หา​อาจ๋ารย์ เขา​มี​ผี​เข้า​เยียะ​หื้อ​อู้​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ผี​ออก​ฤทธิ์​เมื่อใด จะ​เยียะ​หละอ่อน​คน​นี้​โก้น​ลง​ดิน น้ำลาย​ออก​เต๋ม​ปาก​โจ๊ะโฟ๊ะ ขบ​เขี้ยว​ขบ​กาง​มั่นตึ้ง กับ​ตั๋ว​แข็ง​เกิ็กเดิ็ก ข้าพเจ้า​ขอ​หมู่​สาวก​ของ​ต้าน​ไล่​ผี​นั้น​ออก แต่​หมู่​เขา​ไล่​มัน​ออก​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","พระเยซู​ตอบ​ว่า “เฮ่อ หมู่​คน​บ่﻿มี​ความ​เจื้อ เฮา​จะ​ต้อง​อยู่​กับ​หมู่​สู​ไป​แหม​เมิน​สัก​เต้าใด เฮา​จะ​ต้อง​อดทน​กับ​หมู่​สู​ไป​แผว​ไหน ปา​หละอ่อน​คน​นั้น​มา​นี่​แล่” ");
INSERT INTO nod_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","หมู่​เขา​ก็​ปา​หละอ่อน​มา​หา​พระองค์ เมื่อ​ผี​หัน​พระองค์ ก็​เยียะ​หื้อ​หละอ่อน​จั๊ก แล้ว​โก้น​ลง​กิ้ง​ไป​มา​บน​ปื๊น​ดิน กับ​น้ำลาย​ออก​เต๋ม​ปาก​โจ๊ะโฟ๊ะ ");
INSERT INTO nod_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","พระเยซู​ก็​ถาม​ป้อ​ของ​หละอ่อน​คน​นั้น​ว่า “ผี​เยียะ​หื้อ​เป๋น​จาอี้​มา​เมิน​แล้ว​กา” ป้อ​ก็​ตอบ​ว่า “เป๋น​ตั้งแต่​เมื่อ​หน้อย﻿ๆ มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ผี​เกย​เยียะ​หื้อ​ตก​น้ำ​ตก​ไฟ​เจื่อ﻿ๆ เปื้อ​จะ​ฆ่า​หื้อ​ต๋าย ถ้า​ต้าน​สามารถ​จ้วย​ได้ ก็​ขอ​อินดู​จ้วย​น่อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","พระเยซู​อู้​กับ​ป้อ​หละอ่อน​คน​นั้น​ว่า “ ‘ถ้า​จ้วย​ได้’ อี้​กา ถ้า​ใผ​เจื้อ กู้​อย่าง​ก็​เป๋น​ไป​ได้​สำหรับ​เขา” ");
INSERT INTO nod_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ป้อ​ของ​หละอ่อน​ก็​ฮ้อง​ออก​ปาก​ออก​คอ​ว่า “ข้าพเจ้า​เจื้อ﻿ๆ แต่​มี​ความ​เจื้อ​บ่﻿ปอ ขอ​โผด​เตื่อม​แถ้ง​หื้อ​เจื้อ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","เมื่อ​พระเยซู​หัน​หลาย​คน​ปา​กั๋น​ล่น​เข้า​มา​หา​นัก​ขึ้น พระองค์​ก็​สั่ง​ผี​ฮ้าย​ตั๋ว​นั้น​ว่า “ไอ่​ผี​ตี้​เยียะ​หื้อ​หู​หนวก​อู้​บ่﻿ได้ เฮา​สั่ง​หื้อ​เจ้า​ออก​จาก​หละอ่อน​คน​นี้ ห้าม​ปิ๊ก​มา​เข้า​เขา​แหม​ซ้ำ​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ผี​นั้น​ก็​ไห้﻿ๆ หุย﻿ๆ เยียะ​หละอ่อน​คน​นั้น​ดิ้นโจ้ง​ดิ้นจ้าง​อยู่​สัก​กำ​นึ่ง​แล้ว​ก็​ออก​ไป หละอ่อน​ก็​นอน​หนิมผิ้ว​เหมือน​คน​ต๋าย แล้ว​คน​ตังหลาย​ก็​อู้​กั๋น​ว่า “เขา​ต๋าย​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","แต่​พระเยซู​ก๋ำ​มือ​ของ​หละอ่อน​คน​นั้น​จั๊ก​หื้อ​ลุก​ขึ้น หละอ่อน​คน​นั้น​ก็​ลุก​ขึ้น​ยืน ");
INSERT INTO nod_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","เมื่อ​พระเยซู​เข้า​ไป​ใน​เฮือน​หลัง​นึ่ง หมู่​สาวก​ก็​มา​ถาม​พระองค์​เป๋น​ส่วน​ตั๋ว​ว่า “เป๋น​จาใด​หมู่​เฮา​เถิง​ไล่​ผี​นั้น​ออก​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","พระองค์​ก็​ตอบ​ว่า “ผี​จาอี้​จะ​ไล่​ออก​ง่าย﻿ๆ ตึง​บ่﻿ได้​เน่อ เว้น​แต่​ต้อง​อธิษฐาน​ไล่​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","พระเยซู​ตึง​หมู่​สาวก​ปา​กั๋น​ออก​จาก​ตี้​หั้น เตียว​ก๋าย​แคว้น​กาลิลี​ไป แต่​พระองค์​บ่﻿ใค่​หื้อ​ใผ​ฮู้​ว่า​พระองค์​อยู่​ตี้​ไหน ");
INSERT INTO nod_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ย้อน​ว่า​ต๋อน​นั้น​พระเยซู​ก่ำลัง​สอน​หมู่​สาวก พระองค์​บอก​หมู่​เขา​ว่า “จะ​มี​คน​หักหลัง​บุตรมนุษย์ แล้ว​มอบ​พระองค์​หื้อ​อยู่​ใน​อำนาจ​ของ​คน แล้ว​หมู่​เขา​จะ​ฆ่า​พระองค์​หื้อ​ต๋าย แต่​เมื่อ​ต๋าย​ได้​สาม​วัน พระองค์​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ตี้​พระเยซู​บอก หมู่​สาวก​บ่﻿เข้าใจ๋​กำ​อู้​นั้น แต่​หมู่​เขา​ก็​บ่﻿ก้า​ถาม​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","แล้ว​หมู่​เขา​มา​เถิง​เมือง​คาเปอรนาอุม ต๋อน​ตี้​อยู่​ใน​บ้าน พระเยซู​ถาม​หมู่​สาวก​ว่า “ต๋อน​เตียว​มา​ก๋าง​ตาง หมู่​ต้าน​เถียง​กั๋น​เรื่อง​อะหยัง” ");
INSERT INTO nod_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","แต่​กู้​คน​ปา​กั๋น​ดัก​ปิ้ง​หมด​ฮู้สึก​อาย ย้อน​ว่า​ต๋อน​เตียว​มา​ก๋าง​ตาง​นั้น หมู่​เขา​เถียง​กั๋น​เรื่อง​ใผ​จะ​เป๋น​ใหญ่​ตี้​สุด ");
INSERT INTO nod_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","พระองค์​ก็​นั่ง​ลง​ฮ้อง​สาวก​ตึง​สิบ​สอง​คน​เข้า​มา​แล้ว​อู้​ว่า “ถ้า​ใผ​ใค่​เป๋น​คน​ตังเก๊า ก็​หื้อ​เขา​คน​นั้น​เป๋น​คน​ตังป๋าย แล้ว​ฮับใจ๊​คน​ตังหลาย” ");
INSERT INTO nod_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","พระองค์​เอา​หละอ่อน​หน้อย​คน​นึ่ง​มา​ยืน​อยู่​ส่อง​หน้า​หมู่​เขา พระองค์​ก็​อุ้ม​หละอ่อน​คน​นั้น​มา​นั่ง​ตัก​ไว้ แล้ว​อู้​กับ​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ถ้า​ใผ​จะ​ต้อนฮับ​หละอ่อน​หน้อย​จาอี้​ย้อน​หัน​แก่​เฮา คน​นั้น​ก็​ได้​ต้อนฮับ​เฮา บ่﻿ใจ้​ต้อนฮับ​ก้า​เฮา​เต้าอั้น แต่​ยัง​ต้อนฮับ​ผู้​ตี้​ใจ๊​เฮา​มา​ตวย” ");
INSERT INTO nod_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ยอห์น​อู้​กับ​พระเยซู​ว่า “อาจ๋ารย์​ครับ หมู่​เฮา​หัน​คน​นึ่ง​ไล่​ผี​ออก​ใน​นาม​ของ​พระองค์ หมู่​เฮา​ก็​ห้าม​เขา​ย้อน​เขา​บ่﻿ใจ้​หมู่​เฮา” ");
INSERT INTO nod_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","แต่​พระเยซู​บอก​ว่า “บ่﻿ต้อง​ห้าม​เขา​เน่อ ย้อน​ว่า​บ่﻿มี​ใผ​สัก​คน​ตี้​เยียะ​ก๋าน​อัศจ๋รรย์​ใน​จื้อ​ของ​เฮา แล้ว​จะ​ปิ๊ก​มา​ว่า​ใส่​ฮ้าย​เฮา​เมื่อลูน ");
INSERT INTO nod_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ใผ​บ่﻿ต่อต้าน​เฮา​ก็​เป๋น​หมู่​ของ​เฮา​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ใผ​ก็​ดี​ตี้​เอา​น้ำ​หื้อ​หมู่​ต้าน​กิ๋น​สัก​จอก​นึ่ง​ย้อน​ว่า​หมู่​ต้าน​เป๋น​คน​ฝ่าย​พระคริสต์ คน​นั้น​ก็​จะ​ได้​ฮับ​รางวัล​แน่นอน” ");
INSERT INTO nod_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“แต่​ถ้า​ใผ​คน​ใด​เยียะ​หื้อ​คน​ตี้​เป๋น​เหมือน​หละอ่อน​หน้อย​ตี้​เจื้อ​วางใจ๋​ใน​เฮา​หลง​ผิด​ไป​สัก​คน​นึ่ง ก็​หื้อ​เอา​บ่าหิน​โม่​ก้อน​ใหญ่﻿ๆ มัด​ติด​คอ​คน​นั้น แล้ว​อุ้ม​โจ้ง​ลง​ใน​ทะเล​หื้อ​ต๋าย​เหีย ก็​ยัง​ดี​เหลือ ");
INSERT INTO nod_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ถ้า​มือ​ของ​ต้าน​เยียะ​หื้อ​ตั๋ว​ต้าน​เป๋น​บาป ก็​หื้อ​กก​ขว้าง​เหีย ย้อน​ว่า​ถ้า​มี​มือ​กุด​แต่​ยัง​มี​จีวิต​นิรันดร์ ยัง​ดี​เหลือ​มี​มือ​ตึง​สอง​ข้าง​ดี​ครบ​หมด แต่​ต้อง​ตก​หม้อหน้าฮก​ตี้​มี​ไฟ​ไหม้​บ่﻿ฮู้จัก​ดับ ");
INSERT INTO nod_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ถ้า​ตี๋น​ของ​ต้าน​เยียะ​หื้อ​ตั๋ว​ต้าน​เป๋น​บาป ก็​หื้อ​กก​ขว้าง​เหีย ย้อน​ว่า​ถ้า​มี​ตี๋น​ปุด แต่​ยัง​มี​จีวิต​นิรันดร์​ยัง​ดี​เหลือ​มี​ตี๋น​ตึง​สอง​ข้าง​ดี​ครบ​หมด แต่​ต้อง​ตก​หม้อหน้าฮก ");
INSERT INTO nod_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ถ้า​แก่นต๋า​ของ​ต้าน​เยียะ​หื้อ​ตั๋ว​ต้าน​เป๋น​บาป ก็​หื้อ​ควัด​ขว้าง​เหีย ย้อน​ว่า​ถ้า​มี​แก่นต๋า​เผิก​เดียว แต่​ยัง​ได้​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า ยัง​ดี​เหลือ​มี​ต๋า​ครบ​ตึง​สอง​แก่น แต่​ต้อง​ตก​หม้อหน้าฮก ");
INSERT INTO nod_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","เซิ่ง ‘ตี้​หั้น​ตั๋ว​หนอน​ตี้​กิ๋น​คน​บ่﻿ฮู้จัก​ต๋าย ไฟ​ก็​ไหม้​อยู่​บ่﻿ฮู้จัก​ดับ’ ");
INSERT INTO nod_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","พระเจ้า​จะ​เกียม​คน​ตังหลาย​หื้อ​หมดใส​ด้วย​ไฟ ");
INSERT INTO nod_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“เกื๋อ​เป๋น​สิ่ง​ตี้​มี​ประโยชน์ แต่​ถ้า​เกื๋อ​จ๋าง​ไป​เหีย​จะ​เยียะ​หื้อ​เก็ม​แหม​ตึง​บ่﻿ได้ ขอ​หื้อ​ต้าน​ตังหลาย​เป๋น​เหมือน​เกื๋อ แล้ว​อยู่​ตวย​กั๋น​อย่าง​สงบสุข​กับ​สามัคคี” ");
INSERT INTO nod_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","แล้ว​พระเยซู​ออก​จาก​เมือง​คาเปอรนาอุม​เข้า​ไป​แคว้น​ยูเดีย​ตี้​อยู่​แหม​เผิก​นึ่ง ของ​แม่น้ำ​จอร์แดน มี​คน​ปา​กั๋น​มา​หา​พระองค์ พระองค์​ก็​สั่ง​สอน​หมู่​เขา​เหมือน​อย่าง​ตี้​เกย​สอน​มา​ก่อน​นั้น ");
INSERT INTO nod_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","มี​หมู่​ฟาริสี​บาง​คน​มา​ลอง​เจิง​พระองค์​ว่า “จะ​ผิด​บท​บัญญัติ​ก่อ​ถ้า​ผัว​จะ​ละ​เมีย​เหีย” ");
INSERT INTO nod_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","พระองค์​ย้อน​ถาม​เขา​ว่า “โมเสส​ได้​สั่ง​เกี่ยว​กับ​เรื่อง​นี้​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","หมู่​เขา​ปา​กั๋น​ตอบ​ว่า “โมเสส​ยอม​หื้อ​ป้อจาย​ละ​เมีย​ได้ มอก​ป้อจาย​เขียน​ใบหย่า​หื้อ​เมีย​เหีย แล้ว​ก็​ละ​นาง​ไป​ได้​เลย” ");
INSERT INTO nod_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","พระเยซู​ตอบ​ว่า “โมเสส​เขียน​บท​บัญญัติ​ข้อ​นี้​ก็​ย้อน​ว่า​หมู่​ต้าน​หลึกหลึ่ง ");
INSERT INTO nod_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","แต่​ตั้งแต่​เก๊าหัวที​ตี้​พระเจ้า​สร้าง​โลก​นั้น ‘พระองค์​ได้​สร้าง​คน​เป๋น​ป้อจาย​กับ​แม่ญิง’ ");
INSERT INTO nod_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ย้อน​จาอั้น​ป้อจาย​จะ​แยก​จาก​ป้อ​แม่​ของ​ตั๋ว​ไป​อยู่​ฮ่วม​ผูกพัน​กั๋น​กับ​เมีย ตึง​สอง​คน​จะ​ก๋าย​เป๋น​คน﻿ๆ เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","กับ​จะ​บ่﻿เป๋น​สอง​คน​แหม​ต่อ​ไป แต่​เป๋น​คน﻿ๆ เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ย้อน​จาอั้น​สิ่ง​ตี้​พระเจ้า​ได้​มัด​ได้​ปัน​เข้า​ตวย​กั๋น​แล้ว บ่﻿ดี​หื้อ​ใผ​มา​เต​เขา​ตึง​สอง​ออก​จาก​กั๋น​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","เมื่อ​พระเยซู​เข้า​ไป​ใน​บ้าน​กับ​หมู่​สาวก หมู่​สาวก​ก็​ถาม​พระองค์​เกี่ยว​กับ​เรื่อง​ก๋าน​ละ​ผัว​ละ​เมีย ");
INSERT INTO nod_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","พระองค์​ตอบ​ว่า “ป้อจาย​คน​ใด​ละ​เมีย​เก่า​แล้ว​ไป​มี​เมีย​ใหม่ คน​นั้น​ก็​เยียะ​ผิด​เรื่อง​ก๋าน​ล่วง​ประเวณี​ต่อ​เมีย​เก่า ");
INSERT INTO nod_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ถ้า​แม่ญิง​คน​ใด​ละ​ผัว​เก่า​แล้ว​ไป​เอา​ผัว​ใหม่ คน​นั้น​ก็​เยียะ​ผิด​เรื่อง​ก๋าน​ล่วง​ประเวณี​ต่อ​ผัว​เก่า​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","มี​บาง​คน​ปา​หละอ่อน​หน้อย﻿ๆ ของ​หมู่​เขา​เข้า​มา​หา​พระเยซู เปื้อ​หื้อ​พระองค์​วาง​มือ​ปั๋น​ปอน แต่​หมู่​สาวก​ว่า​หื้อ ");
INSERT INTO nod_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","เมื่อ​พระเยซู​หัน​หมู่​สาวก​เยียะ​จาอั้น ก็​บ่﻿ปอใจ๋ อู้​กับ​หมู่​เขา​ว่า “หื้อ​หมู่​หละอ่อน​เข้า​มา​หา​เฮา​เต๊อะ บ่﻿ดี​ห้าม​เขา​ไว้ ย้อน​ว่า​แผ่นดิน​ของ​พระเจ้า​เป๋น​ของ​คน​ตี้​เผียบ​เหมือน​หละอ่อน​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​ใผ​คน​ใด​บ่﻿ฮับ​เอา​แผ่นดิน​ของ​พระเจ้า​เหมือน​หละอ่อน​หมู่​นี้ คน​นั้น​ก็​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​ตึง​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","แล้ว​พระองค์​ก็​กอด​หละอ่อน​หมู่​นั้น เอา​มือ​วาง​หมู่​เขา แล้ว​ก็​ปั๋น​ปอน​หื้อ ");
INSERT INTO nod_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ใน​เวลา​ตี้​พระเยซู​ก่ำลัง​เตียว​ไป​ต๋าม​หน​ตาง​นั้น มี​ป้อจาย​คน​นึ่ง​ล่น​เข้า​มา​คุกเข่า​ลง​ต่อ​หน้า​พระองค์​ถาม​ว่า “อาจ๋ารย์​ผู้​ดี​เลิศ ข้าพเจ้า​จะ​ต้อง​เยียะ​ความ​ดี​อะหยัง​พ่อง​เถิง​จะ​ได้​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","พระเยซู​ตอบ​เขา​ว่า “ต้าน​ฮ้อง​เฮา​ว่า​ผู้​ดี​เลิศ​เยียะ​หยัง บ่﻿มี​ใผ​ดี​เลิศ​นอก​จาก​พระเจ้า​องค์​เดียว​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ต้าน​ฮู้​บท​บัญญัติ​แล้ว ตี้​ว่า ‘ห้าม​ฆ่า​คน ห้าม​เป๋น​จู๊​ผัว​เมีย​เปิ้น ห้าม​ลัก​ของ​ของ​เปิ้น ห้าม​เป๋น​พยาน​ตี้​อู้​บ่﻿แต๊ ห้าม​โก๋ง​ของ​ของ​คน​อื่น จง​เคารพ​นับถือ​ป้อ​แม่​ของ​ตั๋ว’ ” ");
INSERT INTO nod_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ป้อจาย​คน​นั้น​ก็​อู้​ว่า “อาจ๋ารย์ ข้อ​ต่าง﻿ๆ ใน​บท​บัญญัติ​นี้ ข้าพเจ้า​ได้​ถือ​ฮักษา​กู้​ข้อ​บ่﻿ได้​ขาด​ตั้งแต่​เป๋น​หละอ่อน​มา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","พระเยซู​ปัก​ต๋า​ผ่อ​เขา​ก็​ฮู้สึก​ฮัก​เขา​จึง​อู้​ว่า “แต่​ต้าน​ยัง​บ่﻿ได้​เยียะ​แหม​อย่าง​นึ่ง คือ​หื้อ​ไป​ขาย​ของ​กู้​อย่าง​ตี้​ต้าน​มี​อยู่ แล้ว​เอา​สตางค์​ไป​แจก​คน​ตุ๊ก​คน​จ๋น ต้าน​จึง​จะ​มี​สมบัติ​ใน​สวรรค์ แล้ว​ตวย​เฮา​มา​เป๋น​สาวก​ของ​เฮา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","เมื่อ​เขา​ได้ยิน​พระเยซู​อู้​จาอั้น หน้า​ของ​เขา​ก็​หมอง​ซ็อกต็อก แล้ว​เตียว​ออก​ไป​ด้วย​ใจ๋​เป๋น​ตุ๊ก ย้อน​ว่า​เขา​รวย​นัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","พระเยซู​ผ่อ​ไป​ผ่อ​มา​จ๋น​ใคว่ แล้ว​อู้​กับ​หมู่​สาวก​ว่า “คน​รวย​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​ก็​ยาก​นัก​แก” ");
INSERT INTO nod_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","หมู่​สาวก​งืด​ใน​กำ​อู้​ของ​พระเยซู แล้ว​พระองค์​อู้​กับ​สาวก​แหม​ว่า “ลูก​เหย คน​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​ก็​ยาก​นัก​แก​ ");
INSERT INTO nod_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ตั๋ว​อูฐ​ลอด​เข้า​ฮู​เข็ม ยัง​ง่าย​เหลือ​ตี้​คน​รวย​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​แหม​ก่อน” ");
INSERT INTO nod_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","หมู่​สาวก​ฟัง​แล้ว​ซ้ำ​งืด​นัก​เหลือ​เก่า​อู้​กั๋น​ว่า “ถ้า​จาอั้น ใผ​จะ​รอด​ป๊น​บาป​โต้ษ​ได้” ");
INSERT INTO nod_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","พระเยซู​ผ่อ​หมู่​สาวก​แล้ว​อู้​ว่า “สำหรับ​คน​ก็​เป๋น​ไป​บ่﻿ได้​อยู่​แล้ว แต่​สำหรับ​พระเจ้า​กู้​สิ่ง​กู้​อย่าง​เป๋น​ไป​ได้​ตึงหมด” ");
INSERT INTO nod_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","เปโตร​อู้​กับ​พระองค์​ว่า “ผ่อ​ลอ หมู่​เฮา​ได้​ละ​กู้​สิ่ง​กู้​อย่าง​เปื้อ​ติดต๋าม​อาจ๋ารย์​มา” ");
INSERT INTO nod_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","พระเยซู​ตอบ​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​ใผ​คน​ใด​ตี้​ละ​บ้าน ละ​ปี้น้อง ละ​ป้อ​แม่ ละ​ลูก﻿ๆ กาว่า​ละ​ไฮ่​นา​ย้อน​หัน​แก่​เฮา​ตึง​ข่าวดี​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","คน​นั้น​จะ​ได้​ฮับ​ผล​ตอบ​แตน​ใน​โลก​นี้​เป๋น​ร้อย​เต้า คือ​บ้าน ปี้น้อง ป้อ​แม่ ลูก﻿ๆ กาว่า ไฮ่​นา รวม​ตึง​ก๋าน​โดน​ค่ำ​ตวย แต่​ใน​โลก​หน้า​เขา​จะ​ได้​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","แต่​มี​หลาย​คน​ตี้​เป๋น​คน​ตัง​เก๊า​ใน​ต๋อน​นี้ จะ​ก๋าย​เป๋น​คน​ตัง​ป๋าย กับ​คน​ตัง​ป๋าย​ต๋อน​นี้ จะ​ก๋าย​ไป​เป๋น​คน​ตัง​เก๊า” ");
INSERT INTO nod_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","เมื่อ​ก่ำลัง​เตียว​ตาง​ไป​กรุง​เยรูซาเล็ม พระเยซู​เตียว​นำ​หน้า​หมู่​เขา​ไป​ก่อน หมู่​สาวก​ปา​กั๋น​งืด​ใน​ใจ๋ คน​ตี้​เตียว​ตวย​หลัง​ก็​กั๋ว​ขึ้น​มา พระเยซู​ปา​หมู่​สาวก​ตึง​สิบ​สอง​คน​นั้น​ออก​จาก​คน​ตังหลาย​แหม แล้ว​อู้​เรื่อง​เหตุก๋ารณ์​ตี้​จะ​เกิด​ขึ้น​กับ​พระองค์​หื้อ​หมู่​เขา​ฟัง ");
INSERT INTO nod_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","พระองค์​บอก​หมู่​เขา​ว่า “ผ่อ​เน่อ หมู่​เฮา​ก่ำลัง​จะ​ไป​กรุง​เยรูซาเล็ม แล้ว​บุตรมนุษย์​จะ​ถูก​หักหลัง​หื้อ​อยู่​ใน​อำนาจ​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์ เขา​หมู่​นั้น​จะ​ตัดสิน​ลงโต้ษ​ต้าน​เถิง​ต๋าย แล้ว​จะ​มอบ​ต้าน​หื้อ​กับ​คน​ต่างจ้าด ");
INSERT INTO nod_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","แล้ว​หมู่​คน​ต่างจ้าด​นั้น​ก็​จะ​เยาะเย้ย​ถ่ม​น้ำลาย​ใส่​ต้าน เฆี่ยน​ตี๋​ต้าน แล้ว​ใน​ตี้​สุด​ก็​จะ​ปา​กั๋น​ฆ่า​ต้าน​ต๋าย แต่​พระเจ้า​จะ​เยียะ​หื้อ​ต้าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ใน​วัน​ตี้​สาม” ");
INSERT INTO nod_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","แล้ว​ยากอบ​กับ​ยอห์น​ลูกบ่าว​ของ​เศเบดี​เข้า​มา​อู้​กับ​พระเยซู​ว่า “อาจ๋ารย์​ครับ เฮา​มี​เรื่อง​จะ​ขอ​สัก​อย่าง​ได้​ก่อ​ครับ” ");
INSERT INTO nod_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","พระเยซู​ถาม​ว่า “มี​เรื่อง​อะหยัง​กา” ");
INSERT INTO nod_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","หมู่​เขา​ตอบ​ว่า “เมื่อ​อาจ๋ารย์​ได้​ฮับ​เกียรติ​เป๋น​กษัตริย์​แล้ว ขอ​แต่งตั้ง​หื้อ​เฮา​นั่ง​เผิก​ขวา​คน​นึ่ง เผิก​ซ้าย​คน​นึ่ง” ");
INSERT INTO nod_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","พระเยซู​ตอบ​ว่า “หมู่​ต้าน​บ่﻿ฮู้​ว่า​ก่ำลัง​ขอ​อะหยัง หมู่​ต้าน​จะ​กิ๋น​น้ำ​จาก​ถ้วย​แห่ง​ความ​ตุ๊ก​ตี้​เฮา​จะ​กิ๋น​ได้​กา เฮา​จะ​ฮับ​ความ​ตุ๊ก​ตี้​นัก​ขนาด​ไหน หมู่​ต้าน​จะ​ฮับ​ได้​ก่อ” ");
INSERT INTO nod_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","เขา​ตึง​สอง​ตอบ​ว่า “ได้​ก่า” พระเยซู​บอก​เขา​ว่า “หมู่​ต้าน​จะ​ได้​กิ๋น​จาก​ถ้วย​ของ​เฮา​แน่นอน ความ​ตุ๊ก​ตี้​นัก​ล้ำ​ไป​ตี้​เฮา​จะ​ฮับ​นั้น หมู่​ต้าน​จะ​ได้​ฮับ​แน่﻿ๆ ก็​แม่น​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","แต่​ตี้​จะ​หื้อ​ใผ​นั่ง​เผิก​ขวา​เผิก​ซ้าย​ของ​เฮา​นั้น บ่﻿ใจ้​เฮา​เป๋น​คน​จัด​หื้อ​นั่ง​เน่อ แต่​พระเจ้า​ของ​เฮา​เต้าอั้น​ตี้​เป๋น​ผู้​เลือก​ว่า​จะ​หื้อ​ใผ​นั่ง​ตั๊ด​ไหน” ");
INSERT INTO nod_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","เมื่อ​หมู่​สาวก​แหม​สิบ​คน​ได้ยิน​จาอั้น ก็​ปา​กั๋น​โขด​ยากอบ​กับ​ยอห์น ");
INSERT INTO nod_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ย้อน​จาอั้น พระเยซู​ก็​ฮ้อง​หมู่​เขา​ตึงหมด​มา​หา แล้ว​อู้​ว่า “ต้าน​ตังหลาย​ฮู้​แล้ว​ว่า ผู้​ตี้​คน​ตังหลาย​ถือ​ว่า​เป๋น​ผู้​ปกครอง​ของ​คน​ต่างจ้าด​วาง​ตั๋ว​เป๋น​นาย​เหนือ​เขา​ตังหลาย หมู่​ผู้นำ​ก็​ใจ๊​อำนาจ​เหนือ​เขา​ตังหลาย​ตวย ");
INSERT INTO nod_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","แต่​สำหรับ​หมู่​ต้าน​นั้น​บ่﻿เป๋น​จาอั้น​เน่อ ใน​หมู่​ต้าน​ถ้า​ใผ​คน​ใด​ใค่​เป๋น​ใหญ่​ก็​หื้อ​เขา​เป๋น​ผู้​ฮับใจ๊​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ถ้า​ใผ​คน​ใด​ใค่​เป๋น​ใหญ่​เหลือ​เปิ้น ก็​ต้อง​ยอม​สมัคร​ใจ๋​เป๋น​คน​ฮับใจ๊​ของ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ย้อน​บุตรมนุษย์​บ่﻿ได้​มา​เปื้อ​หื้อ​คน​อื่น​ฮับใจ๊ แต่​มา​เปื้อ​ฮับใจ๊​คน​อื่น แล้ว​ก็​สละ​จีวิต​ของ​ต้าน​เปื้อ​เป๋น​ก้า​ไถ่​คน​จ๋ำนวน​นัก​หื้อ​รอด​ป๊น​บาป​โต้ษ” ");
INSERT INTO nod_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","พระเยซู​ตึง​หมู่​สาวก​มา​แผว​เมือง​เยรีโค ต๋อน​ตี้​ออก​จาก​เมือง มี​คน​จ๋ำนวน​นัก​ตวย​พระองค์​กับ​หมู่​สาวก​ไป มี​คน​ต๋า​บอด​คน​นึ่ง​จื้อ​บารทิเมอัส​ลูก​ของ​ทิเมอัส นั่ง​ขอ​ตาน​อยู่​ฮิม​หนตาง ");
INSERT INTO nod_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","เมื่อ​เขา​ได้ยิน​ว่า​พระเยซู​จาว​เมือง​นาซาเร็ธ​ก่ำลัง​เตียว​ก๋าย​มา เขา​ก็​ฮ้อง​เอิ้น​เสียง​ดัง​ว่า “บุตร​ของ​กษัตริย์​ดาวิด ขอ​โผด​อินดู​ข้า​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","มี​หลาย​คน​ปา​กั๋น​ด่า​เขา บอก​หื้อ​ดัก​เหีย แต่​เขา​ก็​เอิ้น​ดัง​ขึ้น​ติก﻿ๆ ว่า “บุตร​ของ​กษัตริย์​ดาวิด​เหย ขอ​โผด​อินดู​ข้า​น่อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","พระเยซู​ก็​เลย​หยุด​แล้ว​อู้​ว่า “ฮ้อง​เขา​มา​เพ้” หมู่​เขา​ก็​ฮ้อง​คน​ต๋าบอด​นั้น​บอก​ว่า “หื้อ​จื้น​อก​จื้น​ใจ๋​เต๊อะ ขะใจ๋​ลุก​ขึ้น​แหล่ พระเยซู​ฮ้อง​เจ้า​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","คน​ต๋าบอด​คน​นั้น​ก็​ก๋ำ​ผ้าต้วบ​ตี้​ตุ๊ม​อยู่​ขว้าง​ไป​เหีย แล้ว​ลุก​ขึ้น​มา​หา​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","พระองค์​ถาม​เขา​ว่า “เจ้า​ต้องก๋าน​หื้อ​เฮา​เยียะ​อะหยัง​หื้อ​กา” คน​ต๋า​บอด​ตอบ​ว่า “อาจ๋ารย์ ข้าพเจ้า​ใค่​ผ่อ​หัน” ");
INSERT INTO nod_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","พระเยซู​ตอบ​เขา​ว่า “ไป​เต๊อะ​เน่อ ความ​เจื้อ​ของ​เจ้า​เยียะ​หื้อ​ต๋า​ของ​เจ้า​หาย​บอด​แล้ว” แล้ว​เขา​ก็​ผ่อ​หัน​บ่า​เดี่ยว​นั้น​เลย แล้ว​เขา​ก็​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","เมื่อ​พระเยซู​กับ​หมู่​สาวก​เข้า​มา​ใก้​จะ​แผว​กรุง​เยรูซาเล็ม ก็​มา​แผว​หมู่​บ้าน​เบธฟายี​กับ​หมู่​บ้าน​เบธานี​ตี้​บน​ดอย​บ่ากอกเทศ พระองค์​ใจ๊​สาวก​สอง​คน​เข้า​ไป​ก่อน ");
INSERT INTO nod_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","สั่ง​ว่า “หื้อ​เข้า​ไป​ใน​หมู่​บ้าน​ตี้​อยู่​ตัง​หน้า​หั้น​เน่อ ตันที​ตี้​เข้า​ไป​แล้ว จะ​ปะ​ลูก​ลา​ตั๋ว​นึ่ง​มัด​อยู่ ลา​ตั๋ว​นี้​ยัง​บ่﻿มี​ใผ​เกย​ขี่​กำ​เตื้อ หื้อ​แก้​เจื้อก​แล้ว​จู๋ง​มา​ตี้​นี่​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ถ้า​มี​คน​ถาม​ว่า ‘หมู่​ต้าน​เยียะ​จาอี้​เยียะ​หยัง’ หื้อ​ตอบ​เขา​ว่า ‘องค์​พระผู้เป๋นเจ้า​ต้องก๋าน​ใจ๊​สัก​กำเดียว แล้ว​จะ​เอา​มา​คืน​หื้อ​ตี้​เก่า’ ” ");
INSERT INTO nod_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","สาวก​สอง​คน​นั้น​ก็​ไป แล้ว​ปะ​ลูก​ลา​ตั๋ว​นึ่ง​มัด​อยู่​นอก​ปะตู๋​บ้าน​ฮิม​หนตาง​หั้น หมู่​เขา​ก็​แก้​เจื้อก​แล้ว​จู๋ง​มา ");
INSERT INTO nod_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","มี​บาง​คน​อยู่​ตี้​หั้น​ถาม​ว่า “แก้​เจื้อก​ลา​เยียะ​หยัง” ");
INSERT INTO nod_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","สาวก​ตึง​สอง​ก็​ตอบ​ต๋าม​ตี้​พระเยซู​บอก​มา หมู่​เขา​ก็​ยอม​หื้อ​เอา​ลูก​ลา​ไป ");
INSERT INTO nod_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","แล้ว​หมู่​เขา​ก็​จู๋ง​ลูก​ลา​มา​หื้อ​พระเยซู เอา​เสื้อผ้า​ของ​หมู่​เขา​ปู๋​บน​หลัง​ลา แล้ว​จ้วย​ตุ้ม​พระองค์​ขึ้น​ขี่ ");
INSERT INTO nod_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","คน​ตังหลาย​ปา​กั๋น​เอา​เสื้อผ้า​ของ​หมู่​เขา​มา​ปู๋​ลง​บน​หนตาง บาง​คน​ก็​ฟัน​กิ่ง​ไม้​มี​ใบ​นัก​ตี้​ก๋าง​โต้ง​มา​ยาย​ต๋าม​หนตาง​ตวย ");
INSERT INTO nod_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","คน​ตี้​เตียว​นำ​หน้า​กับ​คน​เตียว​ตวย​หลัง ปา​กั๋น​โห่​ฮ้อง​เสียง​ดัง​ว่า “โฮซันนา ขอ​พระเจ้า​ปั๋น​ปอน​ผู้​ตี้​มา​ใน​นาม​องค์​พระผู้เป๋นเจ้า ");
INSERT INTO nod_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ขอ​พระเจ้า​ปั๋น​ปอน​อาณาจักร​ของ​กษัตริย์​ดาวิด​ป้อ​อุ๊ย​แม่​หม่อน​ของ​เฮา​ตี้​ก่ำลัง​จะ​มา​ตั้ง​เต๊อะ​เน่อ โฮซันนา​ใน​ตี้​สูงสุด” ");
INSERT INTO nod_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","เมื่อ​พระเยซู​เข้า​ไป​ใน​กรุง​เยรูซาเล็ม​แล้ว ก็​เข้า​ไป​ใน​บริเวณ​พระวิหาร​เตียว​ผ่อ​สิ่ง​ตังหลาย​ตังมวล​จ๋น​ใคว่​หมด แต่​ต๋อน​นั้น​ก็​เกือบ​มืด​นัก​แก​แล้ว จึง​ออก​ไป​หมู่​บ้าน​เบธานี​กับ​หมู่​สาวก​สิบ​สอง​คน ");
INSERT INTO nod_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","แจ้ง​เจ๊า​มา​แหม​วัน​นึ่ง ต๋อน​ตี้​เตียว​ออก​จาก​หมู่​บ้าน​เบธานี พระเยซู​อยาก​กิ๋น​ข้าว ");
INSERT INTO nod_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","เมื่อ​พระองค์​หัน​ใส่​เก๊า​บ่าเดื่อ​เก๊า​นึ่ง​อยู่​ไก๋​ต๋า​มี​ใบ​เต๋ม​เก๊า พระองค์​ก็​เตียว​เข้า​ไป​ผ่อ​ใก้﻿ๆ ว่า​มี​หน่วย​พ่อง​ก่อ เมื่อ​เตียว​เข้า​ไป​ใก้ หัน​มี​ก้า​ใบ​เต๋ม​เก๊า​ไป​หมด แต่​บ่﻿มี​หน่วย​สัก​แก่น ย้อน​ยัง​บ่﻿เถิง​เวลา​ออก​หน่วย​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","พระเยซู​ก็​บอก​บ่าเดื่อ​เก๊า​นั้น​ว่า “ตั้งแต่​นี้​ต่อ​ไป จะ​บ่﻿มี​ใผ​ได้​กิ๋น​หน่วย​ของ​เจ้า​แหม” หมู่​สาวก​ก็​ได้ยิน​กำ​อู้​นั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","เมื่อ​มา​แผว​กรุง​เยรูซาเล็ม​แล้ว พระเยซู​ก็​เข้า​ไป​ใน​บริเวณ​พระวิหาร แล้ว​ไล่​เหิบ​หมู่​ตี้​ก่ำลัง​ซื้อ​ขาย​ของ​กั๋น​อยู่​ตี้​หั้น ปึ๊ด​โต๊ะ​ของ​คน​ฮับ​แลก​สตางค์ กับ​ยู้​ตี้​นั่ง​ของ​หมู่​คน​ขาย​นกก๋าแก๋​ขว้าง​ตวย ");
INSERT INTO nod_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","แล้ว​ห้าม​บ่﻿หื้อ​คน​ขน​ของ​สิ่ง​ใด﻿ๆ เตียว​ลัด​บริเวณ​ข่วง​พระวิหาร ");
INSERT INTO nod_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","พระองค์​สอน​หมู่​เขา​ว่า “มี​ถ้อยกำ​ของ​พระเจ้า​เขียน​ไว้​ใน​พระคัมภีร์​บ่﻿ใจ้​กา ว่า ‘พระวิหาร​ของ​เฮา​จะ​ฮ้อง​ว่า​เป๋น​ตี้​สำหรับ​อธิษฐาน​ของ​คน​กู้​จ้าด​กู้​ภาษา แต่​หมู่​เจ้า​มา​เยียะ​หื้อ​ก๋าย​เป๋น​ถ้ำ​ของ​โจ๋ร​เหีย’ ” ");
INSERT INTO nod_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","เมื่อ​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์​ฮู้​หัน​จาอั้น หมู่​เขา​ก็​กั๋ว​พระองค์ ก็​เลย​เปิ็กษา​หารือ​กั๋น​เปื้อ​หา​ตาง​ตี้​จะ​ฆ่า​พระองค์​เหีย ย้อน​ว่า​คน​ตังหลาย​ตี้​ได้​ฟัง​กำ​สอน​ของ​พระเยซู​ก็​งืด ");
INSERT INTO nod_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","แต่​เมื่อ​ค่ำ​ลง​แล้ว พระเยซู​ตึง​หมู่​สาวก​ก็​ปา​กั๋น​ออก​ไป​จาก​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","แจ้ง​เจ๊า​มา​แหม​วัน​นึ่ง เมื่อ​พระเยซู​ตึง​หมู่​สาวก​เตียว​ก๋าย​เก๊า​บ่าเดื่อ​เก๊า​ตะวา​แหม ก็​หัน​เหี่ยว​แห้ง​ไป​หมด​จ๋น​เถิง​ฮาก ");
INSERT INTO nod_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","เปโตร​กึ๊ด​เถิง​กำ​ตี้​พระเยซู​บอก​บ่าเดื่อ​ต้น​นั้น​ตะวา​จึง​อู้​ขึ้น​ว่า “อาจ๋ารย์​ครับ ผ่อ​บ่าเดื่อ​เก๊า​ตี้​พระองค์​แจ้ง​ตะวา​นี้​ลอ เหี่ยว​แห้ง​ต๋าย​ไป​แต๊​เฮ่ย” ");
INSERT INTO nod_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","พระเยซู​ก็​บอก​หมู่​สาวก​ว่า “ขอ​หื้อ​เจื้อ​พระเจ้า​เต๊อะ​หน่า ");
INSERT INTO nod_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​ใผ​คน​ใด​จะ​สั่ง​ดอย​ม่อน​นี้​ว่า ‘จง​ย้าย​ลง​ไป​ใน​ทะเล​เหีย’ โดย​บ่﻿สงสัย​เลย แต่​เจื้อ​ว่า​จะ​เป๋น​ต๋าม​ตี้​สั่ง​นั้น ก็​จะ​เป๋น​ไป​จาอั้น ");
INSERT INTO nod_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ย้อน​จาอี้​เฮา​บอก​ต้าน​ตังหลาย​ว่า ต้าน​จะ​อธิษฐาน​ขอ​สิ่ง​ใด ถ้า​ต้าน​เจื้อ​ว่า​จะ​ได้ฮับ ต้าน​ก็​จะ​ได้ฮับ​ต๋าม​นั้น​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ต๋อน​ก่ำลัง​อธิษฐาน​อยู่ ถ้า​กึ๊ด​ได้​ว่า​ต้าน​มี​เรื่อง​ผิดอก​ผิดใจ๋​ใผ​อยู่ ก็​ยกโต้ษ​หื้อ​คน​นั้น​เหีย​ก่อน แล้ว​พระบิดา​ของ​ต้าน​ตี้​อยู่​ใน​สวรรค์​ก็​จะ​โผด​ยกโต้ษ​หื้อ​ต้าน​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","แต่​ถ้า​ต้าน​ตังหลาย​บ่﻿ยอม​ยกโต้ษ​หื้อ​ใผ พระบิดา​ของ​ต้าน​ตี้​อยู่​ใน​สวรรค์ ก็​จะ​บ่﻿ยอม​โผด​ยกโต้ษ​หื้อ​ต้าน​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","พระเยซู​กับ​หมู่​สาวก​เข้า​มา​กรุง​เยรูซาเล็ม​แหม เมื่อ​พระเยซู​ก่ำลัง​เตียว​อยู่​ตี้​บริเวณ​พระวิหาร หมู่​หัวหน้า​ปุโรหิต​ตึง​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​คน​เฒ่า​คน​แก่​เข้า​มา​ถาม​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ต้าน​มี​สิทธิ​อำนาจ​อะหยัง​เยียะ​สิ่ง​หมู่​นี้ ใผ​หื้อ​สิทธิ​อำนาจ​ต้าน​ตี้​จะ​เยียะ​จาอี้” ");
INSERT INTO nod_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","พระเยซู​ตอบ​หมู่​เขา​ว่า “เฮา​จะ​ถาม​หมู่​ต้าน​สัก​ข้อ​นึ่ง​ก่อน ถ้า​หมู่​ต้าน​ตอบ​เฮา เฮา​เถิง​จะ​บอก​ว่า​เฮา​ใจ๊​สิทธิ​อำนาจ​ของ​ใผ​มา​เยียะ​สิ่ง​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ลอง​ตอบ​เฮา​มา​กำ​ลอ​ว่า​สิทธิ​อำนาจ​ของ​ยอห์น​ตี้​เขา​หื้อ​บัพติศมา​นั้น มา​จาก​พระเจ้า​กาว่า​มา​จาก​คน” ");
INSERT INTO nod_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","หมู่​เขา​ก็​เปิ็กษา​กั๋น​ว่า “ถ้า​เฮา​จะ​ว่า ‘มา​จาก​พระเจ้า’ ต้าน​ก็​จะ​ย้อน​ถาม​หมู่​เฮา​แหม​ว่า ‘แล้ว​เป๋น​จาใด​บ่﻿เจื้อ​ยอห์น’ ");
INSERT INTO nod_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","แต่​ถ้า​หมู่​เฮา​จะ​ว่า ‘มา​จาก​คน’ ” ก็​กั๋ว​คน​ตังหลาย​จะ​โขด ย้อน​ว่า​คน​ตังหลาย​ปา​กั๋น​เจื้อ​ว่า​ยอห์น​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","หมู่​เขา​ก็​เลย​ตอบ​พระองค์​ว่า “หมู่​เฮา​บ่﻿ฮู้​เน่อ” พระเยซู​ก็​บอก​หมู่​เขา​ว่า “ถ้า​จาอั้น เฮา​ก็​จะ​บ่﻿บอก​เหมือน​กั๋น​ว่า​เฮา​ใจ๊​สิทธิ​อำนาจ​ของ​ใผ​เยียะ​สิ่ง​หมู่​นี้” ");
INSERT INTO nod_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","พระเยซู​อู้​กับ​หมู่​เขา​เป๋น​กำเผียบ​ว่า “มี​ป้อจาย​คน​นึ่ง​เยียะ​สวน​องุ่น เขา​ล้อม​ฮั้ว​แวด​สวน​ไว้​หมด เจาะ​หิน​แป๋ง​บ่อ​กั๊น​น้ำองุ่น กับ​แป๋ง​ป้อม​สำหรับ​เฝ้า​สวน​ไว้ แล้ว​หื้อ​คน​มา​เจ้า ส่วน​เจ้าของ​ก็​เตียวตาง​ไป​อยู่​ต่าง​ประเทศ ");
INSERT INTO nod_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","เมื่อ​เถิง​หน้า​เก็บ​หน่วย​องุ่น เจ้าของ​สวน​ก็​หื้อ​ลูกจ้าง​ไป​หา​หมู่​คน​เจ้า เปื้อ​ฮับ​ส่วน​แบ่ง​องุ่น​ตี้​เป๋น​ส่วน​แบ่ง​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","แต่​หมู่​คน​เจ้า​ก็​ยับ​ลูกจ้าง​คน​นั้น​ไว้ ปา​กั๋น​บุบ​ตี๋​แล้ว​ไล่​ปิ๊ก​โดย​บ่﻿ได้​อะหยัง​ติด​มือ​ไป​สัก​อย่าง ");
INSERT INTO nod_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","เจ้าของ​สวน​ก็​ส่ง​ลูกจ้าง​ไป​แหม​คน​นึ่ง กำ​นี้​คน​เจ้า​ปา​กั๋น​บุบ​หัว​เขา​กับ​เยียะ​หื้อ​เขา​อาย ");
INSERT INTO nod_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ต่อ​มา​เจ้าของ​สวน​ส่ง​ลูกจ้าง​คน​นึ่ง​ไป​แหม หมู่​เขา​ก็​ฆ่า​เหีย แล้ว​เจ้าของ​ก็​ส่ง​คน​ฮับใจ๊​ไป​แหม​หลาย​คน หมู่​คน​เจ้า​ก็​บุบ​ตี๋​พ่อง​ฆ่า​พ่อง ");
INSERT INTO nod_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","เจ้าของ​สวน​ยัง​มี​แหม​คน​นึ่ง เป๋น​ลูกบ่าว​ตี้​เขา​ฮัก จึง​ส่ง​ลูก​ไป กึ๊ด​ว่า ‘คน​เจ้า​หมู่​นั้น​ก็​จะ​นับถือ​ลูก​บ่าว​ของ​เฮา​พ่อง’ ");
INSERT INTO nod_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","แต่​หมู่​คน​เจ้า​อู้​กั๋น​ว่า ‘นี่​ลอ คน​ตี้​จะ​ฮับ​มรดก หมู่​เฮา​จ้วย​กั๋น​ฆ่า​มัน​เหีย​เต๊อะ แล้ว​มรดก​นั้น​จะ​ตก​เป๋น​ของ​หมู่​เฮา’ ");
INSERT INTO nod_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","หมู่​เขา​ก็​ยับ​ลูกบ่าว​เจ้าของ​สวน​นั้น​ฆ่า แล้ว​เอา​ศพ​ขว้าง​ไว้​ตัง​นอก​สวน” ");
INSERT INTO nod_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","พระเยซู​ถาม​ว่า “เจ้าของ​สวน​จะ​เยียะ​จาใด เขา​ก็​จะ​มา​ฆ่า​หมู่​คน​เจ้า​สวน​หมู่​นั้น​เหีย แล้ว​เอา​สวน​องุ่น​นั้น​ไป​หื้อ​คน​อื่น​เจ้า​ต่อ ");
INSERT INTO nod_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ต้าน​ตังหลาย​บ่﻿เกย​อ่าน​พระคัมภีร์​ข้อ​นี้​กา ตี้​ว่า ‘ศิลา​ตี้​สล่า​แป๋ง​เฮือน​เอา​ขว้าง​ไป​แล้ว​นั้น ป๋ากฏ​ว่า​เป๋น​ศิลามุมเอก ");
INSERT INTO nod_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","สิ่ง​นี้​มา​จาก​องค์​พระผู้เป๋นเจ้า ตี้​หมู่​เฮา​หัน​กับ​ต๋า ก็​งืด​แต๊﻿ๆ’ ” ");
INSERT INTO nod_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","หมู่​ผู้นำ​จาว​ยิว​ฮู้​ว่า​พระองค์​ก่ำลัง​อู้​กำเผียบ​เถิง​หมู่​เขา หมู่​เขา​ก็​ปา​กั๋น​หา​ตาง​ตี้​จะ​ยับ​พระองค์ แต่​ก็​กั๋ว​คน​ตังหลาย​ตี้​หั้น หมู่​เขา​เลย​ปา​กั๋น​ปิ๊ก​ไป​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","แล้ว​หมู่​เขา​ส่ง​หมู่​ฟาริสี​กับ​หมู่​ของ​เฮโรด​ไป​หา​พระเยซู เปื้อ​จะ​แน​ยับ​ผิด​ใน​กำ​อู้​กำ​จ๋า​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","เมื่อ​มา​แผว​แล้ว หมู่​เขา​ก็​ถาม​พระองค์​ว่า “อาจ๋ารย์ หมู่​เฮา​ฮู้​ว่า​อาจ๋ารย์​เป๋น​คน​ซื่อสัตย์ บ่﻿ได้​เอาใจ๋​ใผ กับ​บ่﻿หันแก่​หน้า​ใผ​เลย แต่​สอน​เรื่อง​ตาง​ของ​พระเจ้า​ต๋าม​ความ​จริง ขอ​บอก​เฮา​ว่า​ถูก​กาว่า​บ่﻿ถูก​ตี้​จะ​เสีย​ภาษี​หื้อ​ซีซาร์ เฮา​ควร​จะ​เสีย​ดี​กาว่า​บ่﻿ควร​เสีย​ดี” ");
INSERT INTO nod_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","แต่​พระองค์​ฮู้​วอก​หมู่​เขา​จึง​ตอบ​ว่า “ต้าน​จะ​มา​จับ​ผิด​เฮา​เยียะ​หยัง เอา​เหรียญ​เดนาริอัน​มา​หื้อ​เฮา​ผ่อ​สัก​เหรียญ​ลอ” ");
INSERT INTO nod_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","หมู่​เขา​ก็​เอา​เหรียญ​นึ่ง​มา​หื้อ​พระองค์ พระเยซู​ถาม​หมู่​เขา​ว่า “ฮูป​กับ​จื้อ​ตี้​อยู่​บน​เหรียญ​นี้​เป๋น​ของ​ใผ” หมู่​เขา​ตอบ​ว่า “เป๋น​ของ​ซีซาร์” ");
INSERT INTO nod_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","พระเยซู​ก็​บอก​หมู่​เขา​ว่า “ของ​ของ​ซีซาร์​ก็​เอา​ไป​หื้อ​ซีซาร์ แต่​ของ​ของ​พระเจ้า​ก็​หื้อ​พระเจ้า” หมู่​เขา​ก็​งืด​พระองค์​ขนาด ");
INSERT INTO nod_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","มี​หมู่​สะดูสี​บาง​คน​มา​หา​พระเยซู คน​หมู่​นี้​ถือ​ว่า​บ่﻿มี​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย หมู่​เขา​ถาม​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“อาจ๋ารย์ บท​บัญญัติ​ของ​โมเสส​เขียน​ไว้​ว่า ถ้า​ป้อจาย​คน​ใด​ต๋าย​ละ​เมีย แต่​ยัง​บ่﻿ตัน​มี​ลูก​เตื้อ ก็​หื้อ​น้องบ่าว​ฮับ​ปี้ใป๊​มา​เป๋น​เมีย เปื้อ​หื้อ​มี​ลูก​สืบ​เจื๊อสาย​ของ​อ้าย​ไว้ ");
INSERT INTO nod_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","สมมุติ​ว่า​มี​ป้อจาย​ตี้​เป๋น​ปี้น้อง​กั๋น​เจ็ด​คน อ้าย​เก๊า​มี​เมีย แล้ว​ต๋าย​ไป​ยัง​บ่﻿มี​ลูก​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","น้องบ่าว​คน​ตี้​สอง​ก็​ฮับ​เอา​ปี้ใป๊​มา​เป๋น​เมีย แล้ว​ก็​ต๋าย​ไป​ยัง​บ่﻿มี​ลูก​เตื้อ น้อง​คน​ตี้​สาม​ก็​ฮับ​เอา​ปี้ใป๊​มา​เป๋น​เมีย​แหม แล้ว​เขา​ก็​ต๋าย​ไป​ยัง​บ่﻿มี​ลูก​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ปี้น้อง​ตึง​เจ็ด​คน​นี้​เอา​แม่ญิง​คน​นั้น​มา​เป๋น​เมีย แต่​ก็​ต๋าย​โดย​บ่﻿มี​ลูก แล้ว​สุดต๊าย​แม่ญิง​คน​นั้น​ก็​ต๋าย​ตวย ");
INSERT INTO nod_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","จาอั้น​เมื่อ​เถิง​วัน​ตี้​คน​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย แล้ว​ใน​วัน​นั้น​แม่ญิง​คน​นี้​จะ​เป๋น​เมีย​ของ​ใผ ย้อน​ว่า​นาง​เกย​เป๋น​เมีย​ของ​ป้อจาย​ตึง​เจ็ด​คน​นั้น​หมด​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","พระเยซู​บอก​หมู่​เขา​ว่า “ใน​ข้อ​นี้​หมู่​ต้าน​เข้าใจ๋​ผิด​แล้ว ย้อน​ว่า​หมู่​ต้าน​บ่﻿เข้าใจ๋​พระคัมภีร์​กับ​บ่﻿ฮู้จัก​ฤทธิ์​อำนาจ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","เมื่อ​เถิง​วัน​ตี้​กู้​คน​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น จะ​บ่﻿มี​ก๋าน​แต่งงาน​กั๋น กาว่า​ยก​หื้อ​เป๋น​ผัว​เป๋น​เมีย​กั๋น​แหม แต่​จะ​เป๋น​เหมือน​ทูตสวรรค์ ");
INSERT INTO nod_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ส่วน​เรื่อง​คน​ต๋าย​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ก่อ หมู่​ต้าน​บ่﻿เกย​อ่าน​เรื่อง​คุ่ม​ไม้​ตี้​บ่﻿ไหม้​ไฟ​ใน​หนังสือ​ตี้​โมเสส​เขียน​กา พระเจ้า​อู้​กับ​โมเสส​ว่า ‘เฮา​เป๋น​พระเจ้า​ตี้​อับราฮัม อิสอัค กับ​ยาโคบ​นับถือ’ ");
INSERT INTO nod_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","พระองค์​บ่﻿เป๋น​พระเจ้า​ของ​คน​ต๋าย แต่​เป๋น​พระเจ้า​ของ​คน​ตี้​มี​จีวิต หมู่​ต้าน​เข้าใจ๋​ผิด​ไป​นัก​ขนาด” ");
INSERT INTO nod_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","มี​ธรรมาจ๋ารย์​คน​นึ่ง​เข้า​มา​ได้ยิน​หมู่​เขา​เถียง​พระเยซู ก็​หัน​ว่า​พระองค์​ตอบ​หมู่​เขา​ได้​ดี​จึง​ถาม​พระองค์​ว่า “ใน​บท​บัญญัติ​ตึง​หมด​ข้อ​ใด​สำคัญ​เหลือ​เปิ้น” ");
INSERT INTO nod_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","พระเยซู​ตอบ​ว่า “บท​บัญญัติ​ตึง​หมด​ข้อ​ตี้​สำคัญ​ตี้​สุด​คือ​ข้อ​ตี้​ว่า ‘จาว​อิสราเอล​ตังหลาย​ฟัง​ไว้​หื้อ​ดี​เน่อ องค์​พระผู้เป๋นเจ้า​ของ​เฮา​เป๋น​พระเจ้า​องค์​เดียว ");
INSERT INTO nod_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","จง​ฮัก​องค์​พระผู้เป๋นเจ้า พระเจ้า​ของ​ต้าน​จ๋น​สุด​จิต​สุด​ใจ๋ สุด​ผญา​ปั๋ญญา กับ​สุด​ก่ำลัง​ของ​เจ้า’ ");
INSERT INTO nod_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ส่วน​ข้อ​ตี้​สำคัญ​เป๋น​ข้อ​สอง​นั้น​คือ ‘จง​ฮัก​เปื้อน​บ้าน​เหมือน​ฮัก​ตั๋ว​เก่า’ บท​บัญญัติ​อื่น​ตี้​สำคัญ​เหลือ​สอง​ข้อ​นี้​บ่﻿มี​แหม​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","แล้ว​ธรรมาจ๋ารย์​คน​นั้น​อู้​ว่า “ดี​แล้ว​อาจ๋ารย์ ต้าน​อู้​ถูก​แต๊﻿ๆ ว่า​พระเจ้า​มี​แต่​องค์​เดียว นอกจาก​พระองค์​แล้ว​บ่﻿มี​พระเจ้า​อื่น​แหม ");
INSERT INTO nod_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ก๋าน​ฮัก​พระองค์​ด้วย​สุด​จิต​สุด​ใจ๋ สุด​ก่ำลัง สุด​ความ​เข้าใจ๋ กับ​ก๋าน​ฮัก​เปื้อน​บ้าน​เหมือน​ฮัก​ตั๋ว​เก่า ก็​สำคัญ​เหลือ​สัตว์​ตี้​เผา​ปู่จา​กับ​เครื่อง​ปู่จา​ต่าง﻿ๆ ตึง​หมด” ");
INSERT INTO nod_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","เมื่อ​พระเยซู​หัน​ว่า​คน​นั้น​ตอบ​อย่าง​มี​ผญา​ปั๋ญญา จึง​อู้​กับ​เขา​ว่า “ต้าน​ก็​ใก้​ตี้​จะ​เป๋น​คน​ของ​พระเจ้า​มา​นักแก​แล้ว” ตั้งแต่​นั้น​ไป​ก็​บ่﻿มี​ใผ​ก้า​ถาม​พระองค์​แหม ");
INSERT INTO nod_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ต๋อน​ตี้​พระเยซู​สั่ง​สอน​อยู่​ใน​พระวิหาร พระองค์​ถาม​คน​ตังหลาย​ว่า “ตี้​หมู่​ธรรมาจ๋ารย์​ว่า​พระคริสต์​เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด​นั้น เป๋น​ไป​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ย้อน​ว่า​ตั๋ว​กษัตริย์​ดาวิด​อู้​เถิง​พระคริสต์​โดย​พระวิญญาณ​บริสุทธิ์​ว่า ‘พระเจ้า​อู้​กับ​องค์​พระผู้เป๋นเจ้า​ของ​ข้าพเจ้า​ว่า “หื้อ​นั่ง​ตัง​ขวา​มือ​ของ​เฮา จ๋น​เต๊า​ฮอด​เฮา​จะ​เยียะ​หื้อ​ศัตรู๋​ของ​ต้าน​อยู่​ลุ่ม​ปื๊น​ตี๋น​ของ​ต้าน” ’ ");
INSERT INTO nod_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ตั๋ว​ของ​กษัตริย์​ดาวิด​ฮ้อง​พระองค์​ว่า ‘องค์​พระผู้เป๋นเจ้า’ แล้ว​พระองค์​จะ​เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด​ได้​จาใด” คน​ตังหลาย​ฟัง​จาอั้น​ก็​ม่วนใจ๋ ");
INSERT INTO nod_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ต๋อน​ตี้​พระเยซู​สอน​ก็​อู้​ว่า “หื้อ​หละวัง​หมู่​ธรรมาจ๋ารย์​ไว้​หื้อ​ดี﻿ๆ หมู่​เขา​ซอบ​นุ่ง​เสื้อ​คุม​ยาว​เตียว​ไป​เตียว​มา แล้ว​ซอบ​หื้อ​คน​ไหว้​ก๋าง​กาด​ก๋าง​ลี ");
INSERT INTO nod_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","กับ​ซอบ​นั่ง​ตั๊ด​ตี้​สำคัญ​ใน​ธรรมศาลา​ของ​จาว​ยิว กับ​ตี้​มี​เกียรติ​ใน​งาน​เลี้ยง ");
INSERT INTO nod_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","หมู่​เขา​ยึด​เอา​สมบัติ​ของ​หมู่​แม่​หม้าย​ไป​เป๋น​ของ​ตั๋ว​เก่า​เหีย แล้ว​ก็​ขี้แต่ง​อธิษฐาน​ยาว﻿ๆ คน​หมู่​นี้​จะ​ต้อง​ฮับ​โต้ษ​ใหญ่​หลวง” ");
INSERT INTO nod_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","เมื่อ​พระเยซู​นั่ง​อยู่​หน้า​ตู้​เก็บ​สตางค์​ถวาย​ใน​พระวิหาร ก็​ผ่อ​คน​ตังหลาย​เอา​สตางค์​มา​จ่อม​ลง​ใน​ตู้​เก็บ​สตางค์​นั้น คน​ร่ำรวย​หลาย​คน​เอา​สตางค์​จ๋ำนวน​นัก​มา​จ่อม ");
INSERT INTO nod_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","แต่​มี​แม่​หม้าย​ตุ๊ก​คน​นึ่ง​เอา​เหรียญ​ตองแดง​หน้อย﻿ๆ สอง​อัน​มา​จ่อม​ตวย​เปิ้น มี​ก้า​มอก​สัก​ซาว​ห้า​สตางค์ ");
INSERT INTO nod_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","พระเยซู​ฮ้อง​หมู่​สาวก​เข้า​มา​บอก​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า แม่​หม้าย​ตุ๊ก​คน​นี้ จ่อม​สตางค์​นัก​เหลือ​คน​ตังหลาย​หมู่​นั้น​ก่อน ");
INSERT INTO nod_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ย้อน​ว่า​คน​ตังหลาย​ได้​เอา​สตางค์​ตี้​เหลือ​ใจ๊​มา​จ่อม แต่​แม่​หม้าย​คน​นี้​ตุ๊กยาก ยัง​ได้​เอา​สตางค์​ตี้​มี​อยู่​สำหรับ​เลี้ยง​จีวิต​ของ​ตั๋ว​มา​จ่อม​จ๋น​เสี้ยง​หมด” ");
INSERT INTO nod_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ต๋อน​ตี้​พระเยซู​ก่ำลัง​เตียว​ออก​จาก​บริเวณ​พระวิหาร สาวก​ของ​พระองค์​คน​นึ่ง​อู้​ว่า “อาจ๋ารย์ ตึก​หมู่​นี้​ใหญ่​โต​งาม​ขนาด บ่าหิน​ตี้​ใจ๊​แป๋ง​ก็​ก้อน​ใหญ่​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","พระองค์​ตอบ​คน​นั้น​ว่า “ต้าน​หัน​ตึก​ใหญ่﻿ๆ หมู่​นี้​ก่อ บ่าหิน​ตี้​ซ้อน​กั๋น​หมู่​นี้​จะ​ถูก​เต​ขว้าง​จ๋น​บ่﻿หัน​วาง​ซ้อน​กั๋น​เลย​สัก​ก้อน” ");
INSERT INTO nod_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ต๋อน​ตี้​พระเยซู​ก่ำลัง​นั่ง​อยู่​บน​ดอย​บ่ากอกเทศ​ตี้​อยู่​แหม​เผิก​ซื่อ​พระวิหาร เปโตร ยากอบ ยอห์น กับ​อันดรูว์​มา​ถาม​พระองค์​เป๋น​ก๋าน​ส่วน​ตั๋ว​ว่า ");
INSERT INTO nod_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ขอ​บอก​หมู่​เฮา​กำ​เต๊อะ​ว่า สิ่ง​หมู่​นี้​จะ​เกิด​ขึ้น​เมื่อ​ใด มี​อะหยัง​เป๋น​หมายสำคัญ​หื้อ​หัน​ว่า​สิ่ง​หมู่​นี้​จะ​เกิด​ขึ้น​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","พระองค์​ตอบ​ว่า “หละวัง​หื้อ​ดี ห้าม​หื้อ​ใผ​จุล่าย​ต้าน​เน่อ ");
INSERT INTO nod_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ย้อน​ว่า​จะ​มี​หลาย​คน​มา​อ้าง​จื้อ​ของ​เฮา​ว่า ‘เฮา​เป๋น​พระคริสต์’ แล้ว​จุล่าย​หื้อ​หลาย​คน​หลง​เจื้อ ");
INSERT INTO nod_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","เมื่อ​ต้าน​ได้ยิน​เรื่อง​สงคราม กับ​ได้​ข่าว​ลือ​ว่า​เกิด​สงคราม​ตึง​ใก้​ตึง​ไก๋ ก็​บ่﻿ถ้า​ตก​อก​ตก​ใจ๋ ย้อน​เรื่อง​จาอี้​จะ​ต้อง​เกิด​ขึ้น​ก่อน แต่​ยัง​บ่﻿เถิง​วัน​เสี้ยง​สุด​ของ​โลก​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ประเทศ​นึ่ง​จะ​สู้ฮบ​กับ​แหม​ประเทศ​นึ่ง อาณาจักร​นึ่ง​ก็​จะ​สู้ฮบ​กับ​แหม​อาณาจักร​นึ่ง จะ​เกิด​ก๋าน​กั้น​ข้าว​อยาก​น้ำ กับ​แผ่นดิน​จะ​ไหว​หลาย​ตี้ เหตุก๋ารณ์​หมู่​นี้​ก็​เผียบ​เหมือน​ก๋าน​ตั้งเก๊า​เจ็บ​ต๊อง​ก่อน​เกิด​ลูก ");
INSERT INTO nod_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","แต่​จง​หละวัง​ตั๋ว​ไว้​หื้อ​ดี ย้อน​ว่า​หมู่​ต้าน​จะ​ถูก​ยับ​ปา​ไป​ขึ้น​ศาล จะ​ถูก​เฆี่ยน​ถูก​ตี๋​ใน​ธรรมศาลา​ของ​จาว​ยิว กับ​จะ​ต้อง​ไป​ยืน​ต่อ​หน้า​เจ้าเมือง ต่อ​หน้า​กษัตริย์​ย้อน​ว่า​หมู่​ต้าน​ติดต๋าม​เฮา เปื้อ​จะ​เป๋น​พยาน​เรื่อง​เฮา​ต่อ​หน้า​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","แต่​ก่อน​เถิง​วัน​เสี้ยง​สุด​ของ​โลก คน​ตังหลาย​จะ​ต้อง​บอก​ข่าวดี​หื้อ​กู้​จ้าด​กู้​เผ่า​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","เมื่อ​หมู่​ต้าน​โดน​ยับ​ไป​ขึ้น​ศาล​นั้น ห้าม​ฟั่ง​ฮ้อนอก​ตกใจ๋​เตื้อ​ว่า​จะ​อู้​ตอบ​จาใด​ดี แต่​ใน​เวลา​นั้น หื้อ​อู้​ไป​ต๋าม​ตี้​พระเจ้า​โผด​หื้อ​ต้าน​อู้ ย้อน​ว่า​ผู้​ตี้​อู้​นั้น​บ่﻿ใจ้​ตั๋ว​ต้าน​ตี้​อู้ แต่​เป๋น​พระวิญญาณ​บริสุทธิ์​อู้​ผ่าน​ตั๋ว​ต้าน ");
INSERT INTO nod_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“ปี้น้อง​จะ​หักหลัง​กั๋น​จ๋น​ถูก​ฆ่า​ต๋าย ป้อ​แม่​จะ​หักหลัง​ลูก​จ๋น​ถูก​ฆ่า​ต๋าย หมู่​ลูก﻿ๆ ก็​จะ​ต่อต้าน​ป้อ​แม่​แล้ว​เยียะ​หื้อ​ถูก​ฆ่า​ต๋าย​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","คน​ตังหลาย​จะ​จัง​หมู่​ต้าน ย้อน​ว่า​ต้าน​ได้​ติดต๋าม​เฮา แต่​ถ้า​ใผ​ตี้​ทน​ได้​จ๋น​เถิง​ตี้​สุด จะ​ได้ฮับ​ความ​รอด​ป๊น​บาป​โต้ษ ");
INSERT INTO nod_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“แต่​เมื่อ​หมู่​ต้าน​หัน ‘สิ่ง​ตี้​มา​ย่ำ​สิ่ง​ศักดิ์สิทธิ์ ตี้​เยียะ​หื้อ​เกิด​ความ​ฉิบหาย’ มา​ตั้ง​ไว้​ใน​สถาน​ตี้​บ่﻿ควร​ดี​ตั้ง (​หื้อ​คน​ตี้​อ่าน​กำ​นี้​เข้าใจ๋​ความหมาย​หื้อ​ดี​) ก็​หื้อ​คน​ตี้​อยู่​ใน​แคว้น​ยูเดีย​ขะใจ๋​หนี​ไป​อยู่​บน​ดอย​เวย﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","คน​ตี้​อยู่​บน​ดาดฟ้า​หลังคา​บ้าน ห้าม​ลง​มา​กาว่า​ปิ๊ก​เข้า​ไป​เก็บ​คัว​ใน​บ้าน ");
INSERT INTO nod_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","คน​ตี้​อยู่​ต๋าม​โต้ง​ต๋าม​นา ห้าม​ปิ๊ก​ไป​เอา​เสื้อ​คุม​ตี้​บ้าน หื้อ​ลวด​หนี​ไป​เลย ");
INSERT INTO nod_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ใน​หว่าง​นั้น​ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​แม่มาน​กับ​แม่​ลูก​หน้อย​ตี้​ลูก​ยัง​กิ๋น​นม​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","หื้อ​อ้อนวอน​ขอ​พระเจ้า​ตี้​จะ​บ่﻿เกิด​ขึ้น​ใน​หน้า​หนาว ");
INSERT INTO nod_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ย้อน​ว่า​ยาม​นั้น​จะ​เกิด​ความ​ตุ๊กยาก​ลำบาก​ขนาด​อย่าง​ตี้​บ่﻿เกย​เกิด​ขึ้น​มา​ก่อน​เลย นับ​ตั้งแต่​พระเจ้า​สร้าง​โลก​มา​จ๋น​เถิง​บ่าเดี่ยว​นี้ กับ​จะ​บ่﻿มี​จาอี้​เกิด​ขึ้น​แหม​เลย ");
INSERT INTO nod_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ถ้า​องค์​พระผู้เป๋นเจ้า​บ่﻿หย้อ​วัน​เวลา​หมู่​นั้น​หื้อ​สั้น​ลง ก็​จะ​บ่﻿มี​ใผ​รอด​จีวิต​เลย แต่​ย้อน​ว่า​พระองค์​หัน​แก่​คน​ตี้​พระองค์​ได้​เลือก​ไว้​เป๋น​ของ​พระองค์​แล้ว ก็​หื้อ​เวลา​นั้น​สั้น​ลง ");
INSERT INTO nod_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ใน​เวลา​นั้น​ถ้า​มี​คน​ใด​มา​บอก​ว่า ‘ผ่อ​ลอ​พระคริสต์​อยู่​หั้น’ กาว่า ‘พระคริสต์​อยู่​นี้’ ห้าม​เจื้อ​เขา​เน่อ ");
INSERT INTO nod_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ย้อน​ว่า​จะ​มี​พระคริสต์​ตั๋ว​ป๋อม​กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตั๋ว​ป๋อม​เกิด​ขึ้น แล้ว​หมู่​เขา​ก็​จะ​เยียะ​ก๋าน​อัศจ๋รรย์​กับ​หมายสำคัญ​ต่าง﻿ๆ เปื้อ​จุล่าย​คน​ตี้​พระเจ้า​ได้​เลือก​ไว้​แล้ว ถ้า​เป๋น​ไป​ได้ ");
INSERT INTO nod_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ต้าน​ตังหลาย​จง​เฝ้า​หละวัง​ตั๋ว​ไว้​หื้อ​ดี​เน่อ เฮา​ได้​เตื๋อน​หมู่​ต้าน​ไว้​ก่อน​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“หลังจาก​เวลา​ตุ๊ก​ยาก​ลำบาก​นั้น​ผ่าน​ป๊น​ไป​แล้ว ‘ตะวัน​จะ​มืด​ตึ๊ก เดือน​จะ​บ่﻿ส่อง​แสง ");
INSERT INTO nod_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ดาว​จะ​หยวะ​ตก​จาก​ต๊องฟ้า หมู่​ผู้​มี​อำนาจ​ตังหลาย​ใน​ต๊องฟ้า​ก็​จะ​สั่นไหว​เฝื่อน​คลอน’ ");
INSERT INTO nod_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“แล้ว​คน​ตังหลาย​จะ​หัน​บุตรมนุษย์​ลง​มา​บน​เมฆ​ด้วย​ฤทธิ์​อำนาจ​อัน​ยิ่งใหญ่​กับ​รัศมี ");
INSERT INTO nod_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","เวลา​นั้น​พระองค์​จะ​ส่ง​หมู่​ทูตสวรรค์​มา​รวบรวม​คน​ตี้​พระองค์​เลือก​ไว้​แล้ว​จาก​ตึง​สี่​ทิศ ตั้งแต่​สุด​ป๋าย​แผ่นดิน​โลก​จ๋น​เถิง​สุด​ขอบ​ฟ้า ");
INSERT INTO nod_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“หื้อ​เฮียน​ฮู้​จาก​เรื่อง​เก๊า​บ่าเดื่อ คือ​เมื่อ​เก๊า​บ่าเดื่อ​โป่ง​ใบ​ใหม่ ต้าน​ก็​ฮู้​ว่า​ใก้​จะ​เถิง​หน้า​ฮ้อน​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ก็​เหมือน​เดียว​กั๋น เมื่อ​หมู่​ต้าน​หัน​เหตุก๋ารณ์​ตี้​เฮา​บอก​แล้ว​นั้น​เกิด​ขึ้น ก็​หื้อ​ฮู้​ว่า​ใก้​เถิง​เวลา​ตี้​พระองค์​จะ​ปิ๊ก​มา ใก้​จะ​เถิง​เวลา​แต๊﻿ๆ แล้ว​เน่อ ");
INSERT INTO nod_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า คน​ใน​ยุค​นี้​จะ​ยัง​บ่﻿ต๋าย​ก่อน​เหตุก๋ารณ์​ตี้​ว่า​หมู่​นี้​จะ​เกิด​ขึ้น ");
INSERT INTO nod_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ต๊องฟ้า​กับ​โลก​จะ​ยุบ​หาย​ไป แต่​ถ้อยกำ​ของ​เฮา​จะ​บ่﻿สูญหาย​ไป​เลย ");
INSERT INTO nod_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“แต่​ว่า​วัน​นั้น​เวลา​นั้น​ตี้​สิ่ง​หมู่​นี้​จะ​เกิด​ขึ้น บ่﻿มี​ใผ​ฮู้​สัก​คน หมู่​ทูตสวรรค์​ก็​บ่﻿ฮู้ บุตร​ของ​พระเจ้า​ก็​บ่﻿ฮู้ มี​ก้า​พระบิดา​องค์​เดียว​เต้าอั้น​ตี้​ฮู้ ");
INSERT INTO nod_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","จง​เฝ้า​หละวัง​ตื่น​ตั๋ว​ไว้​หื้อ​ดี ย้อน​ต้าน​บ่﻿ฮู้​ว่า​วัน​เวลา​นั้น​จะ​มา​แผว​เมื่อใด ");
INSERT INTO nod_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ก็​เผียบ​เหมือน​เจ้า​ของ​บ้าน​คน​นึ่ง​ตี้​ก่ำลัง​จะ​ออก​เตียว​ตาง​ไป​เมือง​ไก๋ เขา​มอบ​อำนาจ​หื้อ​หมู่​คน​ฮับใจ๊​ฮับผิดชอบ​บ้าน​ต๋าม​หน้าตี้​ก๋าน​งาน​ของ​ใผ​ของ​มัน กับ​บอก​คน​ยาม​หื้อ​เฝ้า​ปะตู๋​บ้าน​ไว้​หื้อ​ดี﻿ๆ ");
INSERT INTO nod_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ย้อน​จาอั้น​หมู่​ต้าน​จง​หละวัง​ตั๋ว​หื้อ​ดี ย้อน​ต้าน​บ่﻿ฮู้​ว่า​เจ้า​ของ​บ้าน​จะ​ปิ๊ก​มา​เวลา​ใด จะ​มา​เมื่อค่ำ​กา จะ​มา​เดิ็กดื่นเกิ่งคืน​กา จะ​มา​ยาม​ไก่​ขัน​กา กาว่า​จะ​มา​เมื่อเจ๊า ");
INSERT INTO nod_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","จง​เฝ้า​หละวัง​หื้อ​ดี กั๋ว​ว่า​เปิ้น​อาจ​จะ​สะหลดสะหลัน​มา​ปะ​ใส่​ต้าน​นอน​หลับ​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","สิ่ง​ตี้​เฮา​อู้​กับ​หมู่​ต้าน เฮา​ก็​อู้​กับ​คน​ตังหลาย​เหมือน​กั๋น​ว่า จง​เฝ้า​หละวัง​หื้อ​ดี” ");
INSERT INTO nod_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","แหม​สอง​วัน​จะ​เถิง​งาน​ปัสกา ตึง​งาน​กิ๋น​เข้าหนมปัง​บ่﻿ใส่​เจื๊อ หมู่​หัวหน้า​ปุโรหิต​ตึง​หมู่​ธรรมาจ๋ารย์​วางแผน​ตี้​จะ​ลัก​ยับ​พระเยซู​ไป​ฆ่า​เหีย ");
INSERT INTO nod_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","หมู่​เขา​อู้​กั๋น​ว่า “ใน​หละหว่าง​งาน​นี้ บ่﻿ดี​ฟั่ง​เยียะ​อะหยัง​เตื้อ กั๋ว​ว่า​คน​ตังหลาย​จะ​วุ่นวาย​แตกตื่น​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ต๋อน​นั้น​พระเยซู​อยู่​ตี้​หมู่​บ้าน​เบธานี​ใน​บ้าน​ของ​ซีโมน​คน​ตี้​เกย​เป๋น​ขี้ตู้ด ต๋อน​ตี้​พระองค์​ก่ำลัง​กิ๋น​ข้าว มี​แม่ญิง​คน​นึ่ง​เข้า​มา​หา นาง​ก๋ำ​ขวด​ใส่​น้ำมัน​หอม​นารดา​บริสุทธิ์​รากา​แปง​ขนาด นาง​ตุ๊บ​ปาก​ขวด​ถอก​น้ำมัน​หอม​นั้น​ลง​บน​หัว​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","บาง​คน​ตี้​หั้น​บ่﻿ปอใจ๋​อู้​กั๋น​ว่า “เป๋น​จาใด​เยียะ​หื้อ​น้ำมัน​หอม​เสีย​ไป​เหีย​บ่﻿ดาย ");
INSERT INTO nod_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ถ้า​เอา​น้ำมัน​หอม​นี้​ไป​ขาย ก็​จะ​ได้​สตางค์​เถิง​สาม​ร้อย​ป๋าย จะ​เอา​สตางค์​นั้น​ไป​ปั๋น​หื้อ​คน​ตุ๊ก​คน​จ๋น​ก็​ได้” หมู่​เขา​ปา​กั๋น​หลุ้ม​ว่า​หื้อ​แม่ญิง​คน​นั้น ");
INSERT INTO nod_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","แต่​พระเยซู​ก็​อู้​กับ​หมู่​เขา​ว่า “ห้าม​ว่า​หื้อ​นาง ไป​ยุ่ง​กับ​นาง​เยียะ​หยัง นาง​ได้​เยียะ​สิ่ง​ตี้​ดี​งาม​หื้อ​กับ​เฮา ");
INSERT INTO nod_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","คน​ตุ๊ก​คน​จ๋น​จะ​ยัง​อยู่​ตวย​หมู่​ต้าน​ไป​ตลอด แต่​เฮา​จะ​บ่﻿อยู่​ตวย​หมู่​ต้าน​ไป​ตลอด ");
INSERT INTO nod_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","แม่ญิง​คน​นี้​เยียะ​เต้า​ตี้​เยียะ​ได้ เขา​ถอก​น้ำมัน​หอม​บน​ตั๋ว​เฮา เปื้อ​จะ​เกียม​ก๋าน​ฝัง​ศพ​ของ​เฮา​ล่วง​หน้า ");
INSERT INTO nod_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า บ่﻿ว่า​คน​จะ​บอก​ข่าวดี​ไป​ตี้​ไหน​ก็​ต๋าม​ใน​โลก เขา​ก็​จะ​เล่า​เรื่อง​ตี้​นาง​เยียะ​นี้​เป๋น​ก๋าน​ระลึก​เถิง​นาง​ตวย” ");
INSERT INTO nod_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","แล้ว​ยูดาส​อิสคาริโอท​ตี้​เป๋น​สาวก​คน​นึ่ง​ใน​สิบ​สอง​คน​ของ​พระเยซู ไป​หา​หมู่​หัวหน้า​ปุโรหิต​เปื้อ​จะ​หักหลัง​พระองค์​หื้อ​หมู่​เขา​ยับ ");
INSERT INTO nod_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","เมื่อ​ได้ยิน​ยูดาส​อู้​จาอั้น ก็​ดีอกดีใจ๋ แล้ว​สัญญา​ว่า​จะ​หื้อ​สตางค์​เป๋น​ก้า​ตอบแตน แล้ว​ยูดาส​ก็​แน​หา​โอกาส​ตี้​จะ​หักหลัง​พระเยซู ");
INSERT INTO nod_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ใน​วัน​ตี้​นึ่ง​ของ​งาน​กิ๋น​เข้าหนมปัง​บ่﻿ใส่​เจื๊อ เป๋น​วัน​ตี้​จาว​ยิว​ฆ่า​ลูก​แกะ​สำหรับ​งาน​ปัสกา หมู่​สาวก​ปา​กั๋น​ถาม​พระเยซู​ว่า “จะ​หื้อ​หมู่​เฮา​ไป​เกียม​มื้อ​ปัสกา​หื้อ​พระองค์​กิ๋น​ตี้​ไหน​ดี” ");
INSERT INTO nod_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","พระเยซู​ก็​ใจ๊​สาวก​สอง​คน​ไป​กรุง​เยรูซาเล็ม บอก​เขา​ว่า “หื้อ​เข้า​ไป​ใน​กรุง​เยรูซาเล็ม แล้ว​จะ​มี​ป้อจาย​คน​นึ่ง​แบก​น้ำหม้อ​มา​หา​หมู่​ต้าน หื้อ​ตวย​คน​นั้น​ไป ");
INSERT INTO nod_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","เขา​เข้า​เฮือน​หลัง​ใด​ก็​หื้อ​บอก​เจ้าของ​เฮือน​นั้น​ว่า ‘อาจ๋ารย์​หื้อ​หมู่​เฮา​มา​ถาม​ว่า ห้อง​ตี้​เปิ้น​จะ​กิ๋น​มื้อ​ปัสกา​กับ​หมู่​สาวก​นั้น​อยู่​ตัง​ใด’ ");
INSERT INTO nod_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","เจ้าของ​เฮือน​จะ​ปา​หมู่​ต้าน​ขึ้น​ไป​ห้อง​ใหญ่​จั๊น​บน​ตี้​แต่ง​ดา​ไว้​แล้ว ก็​หื้อ​จัด​เกียม​มื้อ​ปัสกา​ไว้​ตี้​ห้อง​นั้น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","แล้ว​สาวก​สอง​คน​นั้น​ก็​ออก​ไป เข้า​ไป​ใน​เมือง แล้ว​ก็​ปะ​กู้​อย่าง​ตี้​พระเยซู​บอก​ไว้​ตึงหมด หมู่​เขา​ก็​ได้​จัด​เกียม​มื้อ​ปัสกา​ไว้ ");
INSERT INTO nod_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","เถิง​ต๋อน​เมื่อค่ำ พระเยซู​กับ​หมู่​สาวก​สิบ​สอง​คน​ก็​มา​แผว​เฮือน​หลัง​นั้น ");
INSERT INTO nod_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ต๋อน​ตี้​ก่ำลัง​กิ๋น​อยู่​นั้น พระเยซู​อู้​ว่า “เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า คน​นึ่ง​ใน​หมู่​ต้าน​จะ​หักหลัง​เฮา คน​นั้น​นั่ง​กิ๋น​ข้าว​ตวย​หมู่​เฮา​ตี้​นี้” ");
INSERT INTO nod_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","หมู่​สาวก​ก็​ตุ๊กใจ๋ กู้​คน​เปี่ยน​กั๋น​ถาม​พระองค์​กำ​คน​ว่า “เป๋น​เฮา​กา” ");
INSERT INTO nod_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","พระเยซู​ก็​ตอบ​หมู่​เขา​ว่า “เป๋น​คน​นึ่ง​ใน​หมู่​ต้าน​สิบ​สอง​คน​นี้​ละ คือ​คน​ตี้​จุ่ม​ลง​ใน​ถ้วย​เดียว​กับ​เฮา ");
INSERT INTO nod_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","บุตรมนุษย์​จะ​ต้อง​จาก​ไป​ต๋าม​ตี้​มี​เขียน​ไว้​ใน​พระคัมภีร์​เกี่ยวกับ​พระองค์ แต่​ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​คน​ตี้​หักหลัง​บุตรมนุษย์ ถ้า​คน​นั้น​บ่﻿ได้​เกิด​มา​ก็​ยัง​ดี​เหลือ” ");
INSERT INTO nod_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ต๋อน​ตี้​ก่ำลัง​กิ๋น​ข้าว​ตวย​กั๋น​อยู่​นั้น พระเยซู​หยิบ​เข้าหนมปัง​ขึ้น​มา​ขอบ​พระคุณ​พระเจ้า แล้ว​บิ​ยื่น​หื้อ​หมู่​สาวก อู้​ว่า “นี่​คือ​ก๋าย​ของ​เฮา หื้อ​ฮับ​เอา​ไป​กิ๋น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","พระองค์​ก็​ก๋ำ​ถ้วย​เหล้า​องุ่น​ขึ้น​มา​ขอบพระคุณ​พระเจ้า แล้ว​ส่ง​หื้อ​หมู่​สาวก​กู้​คน​กิ๋น ");
INSERT INTO nod_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","พระองค์​อู้​ว่า “สิ่ง​ตี้​อยู่​ใน​ถ้วย​นี้​คือ​เลือด​ของ​เฮา​ตี้​จะ​ไหล​ออก​มา เปื้อ​รับรอง​พันธสัญญา​หละหว่าง​พระเจ้า​กับ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า เฮา​จะ​บ่﻿กิ๋น​เหล้า​องุ่น​แหม​ต่อ​ไป จ๋น​กว่า​จะ​เถิง​วัน​นั้น​ตี้​เฮา​จะ​กิ๋น​ตวย​กั๋น​ใน​แผ่นดิน​ของ​พระเจ้า แต่​จะ​กิ๋น​ใน​ความหมาย​แบบ​ใหม่” ");
INSERT INTO nod_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","เมื่อ​หมู่​เขา​ฮ้อง​เพลง​สรรเสริญ​พระเจ้า​แล้ว ก็​ปา​กั๋น​ออก​ไป​ตี้​ดอย​บ่ากอกเทศ ");
INSERT INTO nod_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","พระเยซู​อู้​กับ​หมู่​สาวก​ว่า “หมู่​ต้าน​จะ​หนี​ละ​เฮา​ไป​เหีย​หมด ย้อน​มี​กำ​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘พระเจ้า​จะ​ฆ่า​คน​เลี้ยง​แกะ แล้ว​แกะ​หมู่​นั้น​จะ​แตก​ขะแล​ขะแจ​หนี​ไป​หมด’ ");
INSERT INTO nod_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","แต่​เมื่อ​พระเจ้า​เยียะ​หื้อ​เฮา​เป๋น​ขึ้น​จาก​ความ​ต๋าย เฮา​จะ​ไป​แคว้น​กาลิลี​ก่อน​หมู่​ต้าน แล้ว​ปะ​กั๋น​ตี้​หั้น​น่อ” ");
INSERT INTO nod_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","แต่​เปโตร​บอก​พระองค์​ว่า “เถิง​คน​อื่น﻿ๆ จะ​ละ​พระองค์​ไป​หมด แต่​ข้าพเจ้า​จะ​บ่﻿มี​วัน​เยียะ​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","พระเยซู​อู้​กับ​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า คืน​นี้​ก่อน​ตี้​ไก่​จะ​ขัน​สอง​เตื้อ ต้าน​จะ​บอก​บ่﻿ฮู้จัก​เฮา​เถิง​สาม​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","แต่​เปโตร​ยืนยัน​เสียง​แข็ง​ว่า “แม้​ว่า​ข้าพเจ้า​จะ​ต้อง​ต๋าย​ตวย​พระองค์ ข้าพเจ้า​ตึง​บ่﻿มี​วัน​ปฏิเสธ​พระองค์​เลย” หมู่​สาวก​คน​อื่น﻿ๆ ตึงหมด ก็​อู้​จาอั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","พระเยซู​กับ​หมู่​สาวก​ปา​กั๋น​ไป​ตี้​นึ่ง​จื้อ​ว่า เกทเสมนี พระองค์​บอก​หมู่​สาวก​ว่า “นั่ง​ถ้า​อยู่​ตี้​นี่​เน่อ เฮา​จะ​ไป​อธิษฐาน” ");
INSERT INTO nod_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","แล้ว​ก็​ปา​เปโตร ยอห์น​กับ​ยากอบ​ไป​ตวย เวลา​นั้น​พระองค์​เป๋น​ตุ๊ก​หนักใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","บอก​หมู่​เขา​ว่า “ใจ๋​เฮา​เป๋น​ตุ๊ก​ปอ​จะ​ต๋าย​อยู่​แล้ว เฝ้า​อยู่​ตี้​นี่​กั๋น​เน่อ” ");
INSERT INTO nod_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","แล้ว​พระองค์​เตียว​ห่าง​ออก​ไป​หน้อย ก็​คุก​เข่า​ลง​ปื๊น​ดิน แล้ว​อธิษฐาน​ขอ​หื้อ​เวลา​แห่ง​ความ​ตุ๊กยาก​นี้ ป๊น​ไป​จาก​พระองค์​เหีย​ถ้า​เป๋น​ไป​ได้ ");
INSERT INTO nod_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","พระองค์​อ้อนวอน​ว่า “อับบา พระบิดา​เจ้าข้า พระองค์​สามารถ​เยียะ​สิ่ง​ตึง​มวล​ได้ ขอ​หื้อ​ถ้วย​แห่ง​ความ​ตุ๊กยาก​นี้​ป๊น​ไป​จาก​ข้า​พระองค์​เหีย​เต๊อะ แต่​ขอ​หื้อ​เป๋น​ไป​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์ บ่﻿ใจ้​ของ​ข้า​พระองค์” ");
INSERT INTO nod_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","แล้ว​พระองค์​เตียว​ปิ๊ก​มา​หา​สาวก​สาม​คน​นั้น​ตี้​นั่ง​ถ้า​อยู่​หั้น ก็​หัน​หมู่​เขา​ก่ำลัง​นอน​หลับ​อยู่ ก็​ถาม​เปโตร​ว่า “ซีโมน ต้าน​นอน​หลับ​เหีย​กา จะ​เฝ้า​เฮา​สัก​จั้วโมง​บ่﻿ได้​กา ");
INSERT INTO nod_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","หื้อ​เฝ้า​หละวัง​กับ​อธิษฐาน​ตวย เปื้อ​ว่า​ต้าน​จะ​บ่﻿ตก​อยู่​ใน​อำนาจ​ของ​ก๋าน​ลองใจ๋ เถิง​ว่า​จิตใจ๋​ฝ่าย​วิญญาณ​ใค่​ยอม​เยียะ แต่​ตั๋ว​ของ​คน​เฮา​ยัง​อ่อนแอ​อยู่” ");
INSERT INTO nod_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","แล้ว​พระองค์​ปิ๊ก​ไป​อธิษฐาน​เหมือน​เก่า​แหม​เตื้อ ");
INSERT INTO nod_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","แล้ว​เตียว​ปิ๊ก​มา​หา​สาวก​สาม​คน​นั้น​แหม ก็​หัน​หมู่​เขา​ยัง​หลับ​อยู่ ย้อน​ว่า​หมู่​เขา​มืน​ต๋า​บ่﻿ขึ้น หมู่​สาวก​ก็​บ่﻿ฮู้​จะ​อู้​อะหยัง​กับ​พระองค์​ดี ");
INSERT INTO nod_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","พระองค์​ก็​เตียว​ปิ๊ก​ไป​อธิษฐาน​แหม​เตื้อ​นึ่ง เมื่อ​ปิ๊ก​มา​หา​หมู่​เขา​เป๋น​เตื้อ​ตี้​สาม จึง​อู้​กับ​หมู่​เขา​ว่า “ยัง​หลับ​หื้อ​หาย​อิด​อยู่​แหม​กา ปอ​แล้ว เถิง​เวลา​ตี้​บุตรมนุษย์​จะ​ถูก​หักหลัง​ยก​หื้อ​หมู่​คน​บาป​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ลุก​ขึ้น​ไป​กั๋น​เต๊อะ คน​ตี้​หักหลัง​เฮา​มา​แผว​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","บ่ากอง​พระเยซู​อู้​ลิ้น​ยัง​บ่﻿ตัน​เข้า​ปาก​เตื้อ ยูดาส​ตี้​เป๋น​สาวก​คน​นึ่ง​ใน​สิบ​สอง​คน​นั้น ก็​เตียว​มา​เถิง​ตวย​กั๋น​กับ​หมู่​คน​หลาย​ตี้​ก๋ำ​ดาบ​ก๋ำ​ค้อน​มา​ตวย หมู่​เขา​เป๋น​คน​ตี้​หัวหน้า​ปุโรหิต ธรรมาจ๋ารย์ กับ​หมู่​คน​เฒ่า​คน​แก่​ส่ง​มา ");
INSERT INTO nod_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ยูดาส​ได้​ตกลง​กับ​คน​หมู่​นั้น​ไว้​ก่อน​แล้ว​ว่า “เฮา​จูบ​คน​ใด​ก็​แม่น​คน​นั้น​เน่อ หื้อ​ยับ​แล้ว​กุม​ตั๋ว​เขา​ไป” ");
INSERT INTO nod_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ยูดาส​เตียว​ซื่อ﻿ๆ เข้า​มา​หา​พระเยซู แล้ว​อู้​กับ​พระองค์​ว่า “อาจ๋ารย์​ครับ” แล้ว​ก็​จูบ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","คน​หมู่​นั้น​ก็​ยับ​พระองค์​กุม​ตั๋ว​ไว้ ");
INSERT INTO nod_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","แต่​มี​คน​นึ่ง​ตี้​ยืน​ใก้​กั๋น​หั้น จั๊ก​ดาบ​ออก​มา​ฟัน​ถูก​หู​คน​ฮับใจ๊​คน​นึ่ง​ของ​มหา​ปุโรหิต​ปุด ");
INSERT INTO nod_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","พระเยซู​อู้​กับ​คน​หมู่​นั้น​ว่า “หมู่​เจ้า​หัน​เฮา​เป๋น​โจ๋ร​กา เถิง​ได้​ก๋ำ​ดาบ​ก๋ำ​ค้อน​มา​ยับ​เฮา ");
INSERT INTO nod_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","เฮา​อยู่​ตวย​กับ​สั่ง​สอน​หมู่​ต้าน​กู้​วัน​ใน​พระวิหาร ต้าน​ตังหลาย​ก็​บ่﻿มา​ยับ​เฮา แต่​ตี้​เกิด​ขึ้น​ตึงหมด​นี้​ก็​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​เขียน​ไว้​ใน​พระคัมภีร์” ");
INSERT INTO nod_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","แล้ว​หมู่​สาวก​ตึง​หมด​ก็​ละ​ขว้าง​พระองค์​แล้ว​ปา​กั๋น​หนี​ไป ");
INSERT INTO nod_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","มี​ป้อจาย​หนุ่ม​คน​นึ่ง​ตุ๊ม​ก้า​ผ้า​ลินิน​ผืน​เดียว​เต้าอั้น​เตียว​ถ่อม​ตวย​พระองค์​ไป คน​หมู่​นั้น​ก็​ปา​กั๋น​ยับ​ป้อจาย​หนุ่ม​คน​นั้น ");
INSERT INTO nod_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","แต่​เขา​สะวึด​ผ้า​ตุ๊ม​ขว้าง​เหีย​ป๋วย​ตั๋ว​โจ๊ะโละ​ล่น​หนี​ไป ");
INSERT INTO nod_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","หมู่​เขา​ปา​พระเยซู​ไป​หา​มหา​ปุโรหิต ตี้​หั้น​มี​หมู่​หัวหน้า​ปุโรหิต หมู่​ธรรมาจ๋ารย์ กับ​หมู่​คน​เฒ่า​คน​แก่​มา​จุมนุม​กั๋น​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ส่วน​เปโตร​เตียว​ถ่อม​ตวย​พระเยซู​ไป​ห่าง﻿ๆ จ๋น​เข้า​ไป​แผว​ก๋าง​ข่วง​บ้าน​ของ​มหา​ปุโรหิต ไป​นั่ง​หิง​ไฟ​ตวย​หมู่​ยาม ");
INSERT INTO nod_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​สมาชิก​สภา​จาว​ยิว​ปา​กั๋น​เซาะ​หา​พยาน​มา​ใส่ฮ้าย​พระเยซู เปื้อ​จะ​ฆ่า​พระองค์​เหีย แต่​บ่﻿ปะ ");
INSERT INTO nod_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","เถิง​แม้​ว่า​จะ​มี​หลาย​คน​เป๋น​พยาน​เท็จ แต่​กำ​หื้อ​ก๋าน​ของ​หมู่​เขา​บ่﻿เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","แล้ว​ก็​มี​บาง​คน​ลุก​ยืน​ขึ้น​เล่า​แต่​เป๋น​พยาน​เท็จ​ว่า ");
INSERT INTO nod_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“หมู่​เฮา​ได้ยิน​คน​นี้​อู้​ว่า ‘เฮา​จะ​ตุ๊บ​พระวิหาร​นี้​ตี้​มนุษย์​แป๋ง​ขึ้น​มา​ขว้าง​เหีย แล้ว​สาม​วัน​หลังจาก​นั้น เฮา​จะ​แป๋ง​พระวิหาร​ขึ้น​มา​ใหม่​แหม​หลัง​นึ่ง​ตี้​มนุษย์​บ่﻿ได้​แป๋ง’ ” ");
INSERT INTO nod_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","แต่​กำ​พยาน​ของ​หมู่​เขา​ขัด​กั๋น​เยียะ​หื้อ​ฟัง​บ่﻿ขึ้น ");
INSERT INTO nod_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","มหา​ปุโรหิต​จึง​ลุก​ยืน​ขึ้น​ก๋าง​หมู่​คน​ตี้​จุมนุม​กั๋น​นั้น ถาม​พระเยซู​ว่า “ต้าน​จะ​บ่﻿แก้​ตั๋ว​ใน​กำ​กล่าวหา​ตี้​หมู่​เขา​ว่า​มา​นี่​พ่อง​กา” ");
INSERT INTO nod_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","แต่​พระเยซู​ดัก​อยู่ บ่﻿ได้​ตอบ​อะหยัง​สัก​อย่าง มหา​ปุโรหิต​ก็​ถาม​พระองค์​แหม​ว่า “ต้าน​เป๋น​พระคริสต์​พระบุตร​ของ​พระเจ้า ผู้​ตี้​สมควร​ได้ฮับ​ก๋าน​สรรเสริญ​จาอั้น​กา” ");
INSERT INTO nod_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","พระเยซู​ก็​ตอบ​ว่า “แม่น​แล้ว เฮา​เป๋น แล้ว​ต้าน​ตังหลาย​จะ​ได้​หัน​บุตรมนุษย์​นั่ง​ตัง​เผิก​ขวา​ของ​พระเจ้า​ผู้​มี​ฤทธิ์​อำนาจ กับ​จะ​ลง​มา​บน​เมฆ​ใน​ฟ้า​สวรรค์” ");
INSERT INTO nod_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","มหา​ปุโรหิต​ก็​ฉีก​เสื้อผ้า​ของ​ตั๋ว​เก่า​อู้​ว่า “เฮา​บ่﻿ต้อง​มี​พยาน​อะหยัง​แหม ");
INSERT INTO nod_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ต้าน​ตังหลาย​ก็​ได้ยิน​เขา​อู้​หมิ่น​ประมาท​พระเจ้า​แล้ว ต้าน​ตังหลาย​กึ๊ด​จาใด​พ่อง” หมู่​เขา​ตัดสิน​ว่า​พระเยซู​เปิง​ฮับ​โต้ษ​เถิง​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","แล้ว​บาง​คน​ถ่ม​น้ำลาย​ใส่​หน้า​พระองค์ ปิด​หน้า​พระองค์​ไว้​กับ​บุบ​ตี๋​พระองค์ แล้ว​อู้​หย้อ​พระองค์​ว่า “ตวาย​มา​กำ​ลอ​ว่า ใผ​ตบ​หน้า​เจ้า” หมู่​ยาม​ก็​ปา​พระองค์​ไป แล้ว​ตบ​พระองค์​ตวย ");
INSERT INTO nod_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ต๋อน​ตี้​เปโตร​ก่ำลัง​นั่ง​อยู่​ตี้​ก๋าง​ข่วง​บ้าน​นั้น มี​สาวใจ๊​คน​นึ่ง​ของ​มหา​ปุโรหิต​เตียว​เข้า​มา ");
INSERT INTO nod_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","นาง​หัน​เปโตร​นั่ง​หิง​ไฟ​อยู่ ก็​เข้า​ไป​ส่อง​ผ่อ​หน้า​ใก้﻿ๆ แล้ว​อู้​ว่า “ต้าน​ก็​อยู่​ตวย​เยซู​จาว​เมือง​นาซาเร็ธ​ตวย​บ่﻿ใจ้​กา” ");
INSERT INTO nod_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","แต่​เปโตร​ปฏิเสธ​ตี้​อยู่​ตวย​พระเยซู อู้​ว่า “ตี้​เจ้า​อู้​นั้น​เฮา​บ่﻿ฮู้​เรื่อง เฮา​บ่﻿เข้า​ใจ๋​ลอ” เปโตร​ก็​เตียว​ไป​ตี้​ตาง​เข้า​ข่วง​บ้าน แล้ว​ไก่​ก็​ขัน ");
INSERT INTO nod_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","สาวใจ๊​คน​นั้น​หัน​เปโตร​ตี้​หั้น​แหม นาง​ก็​บอก​หมู่​คน​ตี้​ยืน​อยู่​ต๋ำ​หมู่​หั้น​ว่า “เขา​เป๋น​คน​นึ่ง​ใน​คน​หมู่​นั้น” ");
INSERT INTO nod_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","เปโตร​ก็​ปฏิเสธ​แหม​เตื้อ ต่อ​มา​สัก​กำ​นึ่ง คน​ตังหลาย​ตี้​ยืน​อยู่​ตี้​หั้น​อู้​กับ​เปโตร​ว่า “เจ้า​เป๋น​คน​นึ่ง​ใน​หมู่​นั้น​แน่﻿ๆ ย้อน​ว่า​เจ้า​เป๋น​จาว​กาลิลี​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","แต่​เปโตร​ก็​อู้​ว่า “สาบาน​ก็​ได้​ว่า​ข้า​อู้​แต๊ ข้า​บ่﻿เกย​ฮู้จัก​เขา ขอ​หื้อ​พระเจ้า​ลงโต้ษ​เต๊อะ ถ้า​ข้า​จุ” ");
INSERT INTO nod_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","บ่ากอง​เปโตร​อู้​ออก​มา​จาอั้น ไก่​ก็​ขัน​เป๋น​เตื้อ​ตี้​สอง เปโตร​ก็​เลย​กึ๊ด​เถิง​กำ​อู้​ตี้​พระเยซู​เกย​บอก​เขา​ว่า “ก่อน​ไก่​ขัน​สอง​เตื้อ ต้าน​จะ​บอก​ว่า​บ่﻿ฮู้จัก​เฮา​เถิง​สาม​เตื้อ” แล้ว​เขา​ก็​ไห้​ออก​มา​บ่า​เดียว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","แจ้งเจ๊า​มา หมู่​หัวหน้า​ปุโรหิต หมู่​ธรรมาจ๋ารย์ หมู่​คน​เฒ่า​คน​แก่ ตึง​สมาชิก​กู้​คู่​กู้​คน​ของ​สภา​จาว​ยิว​มา​ปะ​กั๋น​ตกลง​เรื่อง​พระเยซู แล้ว​ก็​มัด​พระเยซู แล้ว​ปา​ไป​มอบ​หื้อ​ปีลาต​ตี้​เป๋น​เจ้าเมือง ");
INSERT INTO nod_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ปีลาต​ถาม​พระเยซู​ว่า “ต้าน​เป๋น​กษัตริย์​ของ​จาว​ยิว​กา” พระองค์​ก็​ตอบ​ว่า “ต้าน​อู้​แล้ว” ");
INSERT INTO nod_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","หมู่​หัวหน้า​ปุโรหิต​ใส่​ความ​พระเยซู​ใน​หลาย​ข้อ​หลาย​ประก๋าน ");
INSERT INTO nod_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ปีลาต​จึง​ถาม​พระองค์​แหม​ว่า “ฟัง​ลอ เขา​ฟ้อง​ข้อหา​ต้าน​ตึงหมด​นี้ ต้าน​จะ​บ่﻿ตอบ​อะหยัง​พ่อง​กา” ");
INSERT INTO nod_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","แต่​พระเยซู​บ่﻿ตอบ​อะหยัง ปีลาต​ก็​งืด ");
INSERT INTO nod_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ใน​หละหว่าง​งาน​ปัสกา ปีลาต​เกย​ป่อย​นักโต้ษ​คน​นึ่ง​ต๋าม​ตี้​คน​ตังหลาย​ขอ ");
INSERT INTO nod_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ใน​เวลา​นั้น​มี​ป้อจาย​คน​นึ่ง​จื้อ​บารับบัส​ถูก​ยับ​ขัง​คอก​ฮ่วม​กับ​กบฏ​คน​อื่น﻿ๆ เซิ่ง​หมู่​เขา​ได้​ฆ่า​คน​ต๋าย​หละหว่าง​ก่อ​ก๋าน​วุ่นวาย ");
INSERT INTO nod_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","คน​ตังหลาย​ก็​ปา​กั๋น​มา​ขอ​ปีลาต​หื้อ​ป่อย​นักโต้ษ​คน​นึ่ง อย่าง​ตี้​เกย​เยียะ​มา ");
INSERT INTO nod_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ปีลาต​ถาม​หมู่​เขา​ว่า “ต้าน​ตังหลาย​ต้องก๋าน​หื้อ​เฮา​ป่อย​กษัตริย์​ของ​จาว​ยิว​ก่อ” ");
INSERT INTO nod_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ปีลาต​ฮู้​ว่า ตี้​หมู่​หัวหน้า​ปุโรหิต​ยับ​พระเยซู​มา​หื้อ​ต้าน​ตัดสิน ก็​ย้อน​ขอย​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","แต่​หมู่​หัวหน้า​ปุโรหิต​อู้​สุ่ย​คน​ตังหลาย​หื้อ​ปีลาต​ป่อย​บารับบัส​แตน ");
INSERT INTO nod_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ปีลาต​ก็​ถาม​หมู่​เขา​แหม​เตื้อ​ว่า “แล้ว​คน﻿ๆ นี้​ตี้​ฮ้อง​กั๋น​ว่า​กษัตริย์​ของ​จาว​ยิว​ลอ จะ​หื้อ​เฮา​เยียะ​จาใด” ");
INSERT INTO nod_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","หมู่​เขา​เอิ้น​ตอบ​มา​ว่า “เขิง​บน​ไม้​ก๋าง​เขน” ");
INSERT INTO nod_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ปีลาต​ถาม​ว่า “เขิง​เขา​เยียะ​หยัง เขา​เยียะ​อะหยัง​ผิด” แต่​คน​ตังหลาย​ซ้ำ​เอิ้น​เสียง​ดัง​ขึ้น​เหลือ​เก่า​ว่า “เขิง​บน​ไม้​ก๋าง​เขน” ");
INSERT INTO nod_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ปีลาต​จะ​เอาใจ๋​หมู่​เขา จึง​ป่อย​บารับบัส​หื้อ​หมู่​เขา​ไป กับ​สั่ง​หื้อ​เฆี่ยน​พระเยซู แล้ว​หื้อ​หมู่​ทหาร​เอา​ไป​เขิง​บน​ไม้​ก๋าง​เขน ");
INSERT INTO nod_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","หมู่​ทหาร​ปา​พระเยซู​เข้า​ไป​ตี้​ศูนย์บัญชาก๋าน​ใหญ่​ของ​โรมัน​ตี้​จื้อ​ว่า ปรีโทเรียม แล้ว​ฮ้อง​หมู่​ทหาร​ตึง​ก๋อง​มา​จุมนุม​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","หมู่​เขา​เอา​เสื้อ​คุม​สี​ม่วง​มา​นุ่ง​หื้อ​พระองค์ แล้ว​เอา​กิ่ง​ไม้​ตี้​มี​หนาม​มา​แป๋ง​เป๋น​มงกุฎ แล้ว​เอา​สุบ​หัว​หื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","แล้ว​หมู่​เขา​ก็​ขี้แต่ง​เข้า​มา​ไหว้​สา​พระองค์ อู้​ว่า “ขอ​กษัตริย์​ของ​จาว​ยิว​จง​จ๋ำเริญ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","แล้ว​หมู่​เขา​ก็​เอา​ไม้​อ้อ​ฟาด​หัว​พระองค์ ถ่ม​น้ำลาย​ใส่​พระองค์ แล้ว​คุกเข่า​ลง​ขี้แต่ง​นมัสก๋าน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","เมื่อ​ดู​แควน​จ๋น​ปอใจ๋​แล้ว หมู่​เขา​ก็​แก้​เสื้อ​คุม​สี​ม่วง​ออก แล้ว​เอา​เสื้อ​ผืน​เก่า​ของ​พระองค์​มา​นุ่ง​หื้อ​ใหม่ แล้ว​ปา​พระองค์​ออก​ไป​เขิง​บน​ไม้​ก๋าง​เขน ");
INSERT INTO nod_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ต๋อน​ตี้​ปา​พระองค์​ไป​ต๋าม​หนตาง​นั้น ก็​ปะ​ป้อจาย​คน​นึ่ง​ลุก​บ้าน​นอก​มา เขา​จื้อ​ซีโมน​มา​จาก​เมือง​ไซรีน เป๋น​ป้อ​ของ​อเล็กซานเดอร์​กับ​รูฟัส หมู่​ทหาร​ก็​เข​ซีโมน​แบก​ไม้​ก๋าง​เขน​แตน​พระเยซู​ไป ");
INSERT INTO nod_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","หมู่​เขา​ปา​พระเยซู​มา​แผว​ตี้​นึ่ง​จื้อ กลโกธา (​แป๋​ว่า​เนิน​กระโหล้ง​หัว​) ");
INSERT INTO nod_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","หมู่​เขา​เอา​เหล้า​องุ่น​สูน​กับ​มดยอบ​มา​หื้อ​พระองค์​กิ๋น แต่​พระองค์​บ่﻿ยอม​กิ๋น ");
INSERT INTO nod_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","แล้ว​หมู่​เขา​ก็​เขิง​พระองค์​บน​ไม้​ก๋าง​เขน กับ​เอา​เสื้อผ้า​ของ​พระองค์​มา​จก​เบอร์​แบ่ง​กั๋น เปื้อ​ผ่อ​ว่า​ใผ​จะ​ได้​อะหยัง​พ่อง ");
INSERT INTO nod_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ต๋อน​ตี้​หมู่​เขา​เขิง​พระองค์​นั้น​เป๋น​เวลา​เก้า​โมง​เจ๊า ");
INSERT INTO nod_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","มี​ป้าย​เขียน​ข้อหา​ติด​ไว้​บน​ไม้​ก๋าง​เขน​ว่า “กษัตริย์​ของ​จาว​ยิว” ");
INSERT INTO nod_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","หมู่​เขา​เอา​โจ๋ร​สอง​คน​เขิง​บน​ไม้​ก๋าง​เขน​พร้อม​พระองค์ ตัง​ขวา​คน​นึ่ง​ตัง​ซ้าย​คน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","คน​ตังหลาย​ตี้​เตียว​ก๋าย​ไป​ก๋าย​มา ปา​กั๋น​สว่าย​หน้า​อู้​หยาม​พระองค์​ว่า “เฮอะ​เหอ เจ้า​เป๋น​คน​ตี้​อู้​ว่า​จะ​ทำลาย​พระวิหาร แล้ว​จะ​แป๋ง​ขึ้น​ใหม่​ใน​สาม​วัน​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","จ้วย​ตั๋ว​เก่า​หื้อ​รอด​ก่อน​เต๊อะ ลง​มา​จาก​ไม้​ก๋าง​เขน​เหีย​แหล่” ");
INSERT INTO nod_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์​ปา​กั๋น​เยาะเย้ย​พระองค์​ใน​วง​ของ​หมู่​เขา​เหมือน​กั๋น​ว่า “เขา​จ้วย​จีวิต​คน​อื่น​หื้อ​รอด​จีวิต​ได้ แต่​จ้วย​จีวิต​ตั๋ว​เก่า​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","หื้อ​พระคริสต์​กษัตริย์​ของ​จาว​อิสราเอล​ลง​มา​จาก​ไม้​ก๋าง​เขน​บ่าเดี่ยว​นี้​เต๊อะ เปื้อ​เฮา​จะ​ได้​เจื้อ” โจ๋ร​สอง​คน​ตี้​ถูก​เขิง​ตวย​พระองค์​นั้น​ก็​อู้​ถ่อยจ๊า​ใส่​พระองค์​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","เมื่อ​เวลา​เตี้ยง​วัน ก็​มืด​ไป​ใคว่​แผ่นดิน​จ๋น​เถิง​บ่าย​สาม​โมง ");
INSERT INTO nod_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ใน​เวลา​บ่าย​สาม​โมง พระเยซู​ฮ้อง​เสียง​ดัง​ว่า “เอโลอี เอโลอี ลามา สะบัก​ธานี” แป๋​ว่า “พระเจ้า​ของ​ข้า​พระองค์ พระเจ้า​ของ​ข้า​พระองค์ เป๋น​จาใด​พระองค์​มา​ละ​ข้า​พระองค์​ไป​เหีย” ");
INSERT INTO nod_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","มี​บาง​คน​ตี้​อยู่​ตี้​หั้น​ได้ยิน​ก็​อู้​กั๋น​ว่า “ฟัง​ลอ เขา​ฮ้อง​หา​เอลียาห์” ");
INSERT INTO nod_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","มี​คน​นึ่ง​ล่น​ไป​เอา​ฟองน้ำ​มา​จุ่ม​เหล้า​องุ่น​ส้ม เสียบ​ป๋าย​ไม้​อ้อ​ยื่น​หื้อ​พระองค์​กิ๋น​แล้ว​อู้​ว่า “กำเดียว​ก่อน​เน่อ หื้อ​เฮา​แน​ผ่อ​ว่า​เอลียาห์​จะ​มา​เอา​เขา​ลง​จาก​ไม้​ก๋าง​เขน​ก่อ” ");
INSERT INTO nod_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","พระเยซู​ฮ้อง​เสียง​ดัง แล้ว​ก็​ต๋าย ");
INSERT INTO nod_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ต๋อน​นั้น​ผ้ากั้ง​ใน​พระวิหาร​ฉีก​ออก​เป๋น​สอง​เผิก​ตั้งแต่​ตัง​บน​ลง​ลุ่ม ");
INSERT INTO nod_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","เมื่อ​นายร้อย​ทหาร​ตี้​ยืน​อยู่​ส่อง​หน้า​พระองค์​หัน​ว่า​พระองค์​ต๋าย​จาใด ก็​อู้​ว่า “แต๊﻿ๆ แล้ว ต้าน​คน​นี้​เป๋น​พระบุตร​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","มี​แม่ญิง​บาง​คน​ยืน​ผ่อ​อยู่​ไก๋﻿ๆ คือ​มารีย์​จาว​เมือง​มักดาลา นาง​สะโลเม กับ​มารีย์​แม่​ของ​ยากอบ​หน้อย​ตึง​โยเสส ");
INSERT INTO nod_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","แม่ญิง​หมู่​นี้​เกย​ติดต๋าม​ผ่อกอย​พระเยซู​ต๋อน​ตี้​พระองค์​อยู่​ตี้​แคว้น​กาลิลี ตี้​หั้น​ก็​มี​แม่ญิง​คน​อื่น​แหม​หลาย​คน​ตี้​ตวย​พระองค์​มา​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","วัน​นั้น​เป๋น​วัน​จัด​เกียม​แต่ง​ดา​ก่อน​เถิง​วัน​สะบาโต เมื่อ​เถิง​ต๋อน​เมื่อแลง ");
INSERT INTO nod_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","โยเซฟ​จาว​อาริมาเธีย​ก้า​ไป​หา​ปีลาต​เปื้อ​ขอ​ศพ​พระเยซู เขา​เป๋น​สมาชิก​ตี้​มี​จื้อเสียง​ดี​ของ​สภา​แซนเฮดริน เป๋น​คน​ตี้​รอ​ถ้า​วัน​เวลา​ตี้​แผ่นดิน​ของ​พระเจ้า​จะ​มา​เถิง ");
INSERT INTO nod_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ปีลาต​ก็​อิกขะหลิก​ใน​ใจ๋​ตี้​พระเยซู​ต๋าย​เวย​ขนาด​นี้​แล้ว จึง​ฮ้อง​นายร้อย​ทหาร​คน​นึ่ง​มา​ถาม​ว่า​พระเยซู​ต๋าย​แล้ว​กา ");
INSERT INTO nod_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","เมื่อ​ปีลาต​ฮู้​เรื่อง​จาก​นายร้อย​คน​นั้น​แล้ว ก็​อนุญาต​หื้อ​โยเซฟ​เอา​ศพ​พระเยซู​ไป​ได้ ");
INSERT INTO nod_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","โยเซฟ​ซื้อ​ผ้า​ลินิน​มา แล้ว​เอา​ศพ​พระองค์​ลง​มา​จาก​ไม้​ก๋าง​เขน ก็​เอา​ผ้า​ลินิน​นั้น​ปัน​ศพ​พระองค์ แล้ว​เอา​ศพ​ไป​ไว้​ใน​อุโมงค์​ฝัง​ศพ​ตี้​เจาะ​เข้า​ไป​ใน​หิน แล้ว​กิ้ง​บ่าหิน​แผ่น​ใหญ่​มา​ตึด​ปาก​อุโมงค์​ไว้​เหีย ");
INSERT INTO nod_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","มารีย์​จาว​มักดาลา​ตึง​มารีย์​แม่​ของ​โยเสส​ก็​หัน​อุโมงค์​ตี้​โยเซฟ​เอา​ศพ​ของ​พระเยซู​ไป​ฝัง​ไว้​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","เมื่อ​วัน​สะบาโต​ป๊น​ไป​แล้ว มารีย์​จาว​มักดาลา นาง​สะโลเม กับ​มารีย์​แม่​ของ​ยากอบ ไป​ซื้อ​เครื่องหอม​มา เปื้อ​จะ​ชโลม​ศพ​ของ​พระเยซู​ต๋าม​ธรรมเนียม​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","เจ๊า​มืด​ของ​วัน​ติ๊ด​บ่ากอง​ตะวัน​ก่ำลัง​จะ​ออก หมู่​เขา​ก็​ไป​ตี้​อุโมงค์​ฝัง​ศพ​นั้น ");
INSERT INTO nod_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","หละหว่าง​เตียวตาง​ไป หมู่​เขา​อู้​กั๋น​ว่า “ใผ​จะ​กิ้ง​บ่าหิน​ตี้​ตึด​ปาก​อุโมงค์​หื้อ​เฮา​กา” ");
INSERT INTO nod_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","เมื่อ​มา​เถิง​อุโมงค์ หมู่​เขา​ก็​หัน​บ่าหิน​ใหญ่​นั้น​กิ้ง​ออก​ไป​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","หมู่​เขา​เข้า​ไป​ใน​อุโมงค์ ก็​หัน​ป้อจาย​หนุ่ม​คน​นึ่ง​นุ่ง​เสื้อ​คุม​สี​ขาว นั่ง​อยู่​ตัง​เผิก​ขวา หมู่​เขา​ก็​สะดุ้ง​ตกอกตกใจ๋ ");
INSERT INTO nod_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ป้อจาย​หนุ่ม​คน​นั้น​อู้​กับ​หมู่​เขา​ว่า “บ่﻿ถ้า​ตกใจ๋​เน่อ หมู่​เจ้า​มา​หา​พระเยซู​จาว​เมือง​นาซาเร็ธ​ตี้​ถูก​เขิง​บน​ไม้​ก๋าง​เขน​นั้น​กา พระเจ้า​เยียะ​หื้อ​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว พระองค์​บ่﻿ได้​อยู่​ตี้​นี่ ผ่อ​ตั๊ด​ตี้​หมู่​เขา​วาง​ศพ​ของ​พระองค์​แหล่ ");
INSERT INTO nod_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","แล้ว​หื้อ​ไป​บอก​หมู่​สาวก​ของ​พระองค์​ตึง​เปโตร​ตวย​เน่อ​ว่า ‘พระองค์​ก่ำลัง​ไป​แคว้น​กาลิลี​ก่อน​หน้า​ต้าน​ตังหลาย ต้าน​ตังหลาย​จะ​หัน​พระองค์​ตี้​หั้น เหมือน​อย่าง​ตี้​พระองค์​เกย​บอก​ต้าน​ตังหลาย​ไว้’ ” ");
INSERT INTO nod_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","แม่ญิง​หมู่​นั้น​ก็​ฟั่ง​ล่น​ออก​ไป​จาก​อุโมงค์​ตึง​งืด​ตึง​ตั๋ว​สั่น​ไป​หมด บ่﻿อู้​อะหยัง​กับ​ใผ​สัก​คน​ย้อน​ว่า​กั๋ว ");
INSERT INTO nod_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","เมื่อ​เจ๊า​มืด​วัน​ติ๊ด​หลังจาก​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว พระองค์​ก็​ป๋ากฏ​ตั๋ว​หื้อ​มารีย์​จาว​มักดาลา​หัน​ก่อน​เปิ้น นาง​คือ​คน​ตี้​พระเยซู​ขับ​ไล่​ผี​เจ็ด​ตั๋ว​ออก​จาก​นาง​นั้น ");
INSERT INTO nod_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","แล้ว​นาง​ไป​บอก​หื้อ​หมู่​สาวก​ฟัง ต๋อน​นั้น​เขา​หมู่​นั้น​ก่ำลัง​ไห้​เป๋น​ตุ๊ก​อยู่ ");
INSERT INTO nod_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","แต่​เมื่อ​หมู่​เขา​ได้ยิน​ว่า​พระองค์​มี​จีวิต กับ​มารีย์​ได้​หัน​พระองค์​มา​แล้ว เขา​ก็​บ่﻿เจื้อ ");
INSERT INTO nod_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","หลังจาก​นั้น​มี​สอง​คน​ตี้​เกย​ติดต๋าม​พระเยซู​ก่ำลัง​เตียวตาง​ไป​บ้าน​นอก พระเยซู​ป๋ากฏ​หื้อ​สอง​คน​นี้​หัน​แต่​เป๋น​สภาพ​บ่﻿เหมือน​เก่า ");
INSERT INTO nod_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","สอง​คน​นั้น​ก็​ปิ๊ก​ไป​บอก​คน​อื่น﻿ๆ ตี้​เกย​ติดต๋าม​พระองค์​ว่า​ได้​หัน​พระเยซู แต่​หมู่​เขา​ก็​บ่﻿เจื้อ ");
INSERT INTO nod_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ถัด​มา​เมื่อลูน​พระเยซู​ป๋ากฏ​หื้อ​สาวก​ตึง​สิบ​เอ็ด​คน​หัน​ต๋อน​ตี้​หมู่​เขา​กิ๋น​ข้าว​กั๋น​อยู่ พระองค์​ว่า​หื้อ​หมู่​เขา ย้อน​ว่า​หมู่​เขา​สงสัย​ตึง​หลึ่ง​ตี้​บ่﻿เจื้อ​คน​ตี้​ได้​หัน​พระองค์​หลังจาก​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว ");
INSERT INTO nod_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","พระองค์​อู้​กับ​หมู่​สาวก​ของ​พระองค์​ว่า “ต้าน​ตังหลาย​จง​ออก​ไป​บอก​ข่าวดี​หื้อ​คน​ตังหลาย​ฟัง​จ๋น​ใคว่​โลก ");
INSERT INTO nod_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","คน​ใด​เจื้อ​และ​ฮับ​บัพติศมา​คน​นั้น​ก็​จะ​รอด​ป๊น​บาป​โต้ษ แต่​คน​ใด​บ่﻿เจื้อ​จะ​ถูก​ตัดสิน​ลง​โต้ษ ");
INSERT INTO nod_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","คน​ตี้​เจื้อ​จะ​ฮับ​ฤทธิ์​อำนาจ​เยียะ​หมายสำคัญ คือ​จะ​ไล่​ผี​ออก​ด้วย​จื้อ​ของ​เฮา จะ​อู้​ภาษา​อื่น﻿ๆ ตี้​บ่﻿เกย​ฮู้ ");
INSERT INTO nod_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","เขา​จะ​หยุบ​งู​ปิ๊ด​ได้ ถ้า​กิ๋น​ของ​มี​ปิ๊ด​ก็​จะ​บ่﻿เป๋น​อันตราย​ต่อ​เขา เขา​จะ​เอา​มือ​วาง​บน​ตั๋ว​คน​ป่วย คน​หมู่​นั้น​ก็​จะ​หาย​ป่วย” ");
INSERT INTO nod_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","เมื่อ​พระเยซู​อู้​กับ​หมู่​เขา​จบ​แล้ว พระเจ้า​ก็​ฮับ​พระองค์​ขึ้น​ไป​สวรรค์​หื้อ​นั่ง​ตัง​เผิก​ขวา​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","แล้ว​หมู่​สาวก​ก็​ออก​ไป​เตสนา​สั่ง​สอน​กู้​ตี้​กู้​แห่ง องค์​พระผู้เป๋นเจ้า​ก็​เยียะ​ก๋าน​ตวย​หมู่​เขา โดย​หื้อ​ฤทธิ์​อำนาจ​หมู่​เขา​เยียะ​หมายสำคัญ​เปื้อ​พิสูจน์​ว่า กำสอน​ของ​เขา​เป๋น​เรื่อง​แต๊");
INSERT INTO nod_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","สวัสดี​ครับ ต้าน​เธโอฟีลัส ตี้​นับถือ มี​หลาย​คน​ลง​มือ​เขียน​เรื่องราว​ต่าง﻿ๆ เซิ่ง​สำเร็จ​แล้ว​ต้ามก๋าง​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ต๋าม​ตี้​หมู่​เขา​ได้​หัน​กับ​ต๋า​ตั้งแต่​เก๊า และ​ได้​เป๋น​ผู้​บอก​ถ้อยกำ​นั้น​หื้อ​เฮา​ฮู้ ");
INSERT INTO nod_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ย้อน​จาอี้ หลัง​จาก​ตี้​ข้าพเจ้า​สืบ​เซาะ​อย่าง​ละเอียด​ตั้งแต่​เก๊า ก็​หัน​ว่า​ดี​ตี้​จะ​เขียน​เรื่อง​ราว​ต๋าม​ลำดับ​ฝาก​มา​หื้อ​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","เปื้อ​ต้าน​จะ​ได้​ฮู้​แน่นอน​ว่า​กำสอน​ตี้​ต้าน​ได้​ฮู้​มา​นั้น​เป๋น​เรื่อง​แต๊ ");
INSERT INTO nod_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ใน​ยุค​ตี้​เฮโรด​เป๋น​กษัตริย์​แคว้น​ยูเดีย มี​ปุโรหิต​คน​นึ่ง​จื้อ​เศคาริยาห์​อยู่​ใน​หมู่​อาบียาห์ เมีย​ของ​เศคาริยาห์​จื้อ​เอลีซาเบธ ตึง​สอง​เป๋น​คน​ใน​ผะกุ๋น​อาโรน ");
INSERT INTO nod_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","เขา​ตึง​สอง​คน​เยียะ​ต๋าม​บท​บัญญัติ​กับ​กฎเก๋ณฑ์​ของ​พระเจ้า​ตึง​หมด​ได้​อย่าง​บ่﻿มี​ตี้​ติ​เลย กับ​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม ");
INSERT INTO nod_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","แต่​ตึง​สอง​คน​บ่﻿มี​ลูก ย้อน​ว่า​นาง​เอลีซาเบธ​เป๋น​หมัน กับ​ตึง​สอง​ก็​เฒ่า​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ต๋อน​ตี้​หมู่​ของ​เศคาริยาห์​อยู่​เวร เปื้อ​เยียะ​หน้าตี้​ของ​ปุโรหิต​เข้า​เฝ้า​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ต้าน​จกเบอร์​ต๋าม​ธรรมเนียม​ของ​ปุโรหิต​ได้ จึง​ต้อง​เข้า​ไป​เผา​เครื่องหอม​ปู่จา​ใน​พระวิหาร ");
INSERT INTO nod_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ส่วน​คน​ตังหลาย​ก็​อธิษฐาน​อยู่​ตังนอก​ต๋อน​ตี้​เผา​เครื่องหอม​นั้น ");
INSERT INTO nod_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ทูตสวรรค์​องค์​นึ่ง​ของ​พระเจ้า​มา​ป๋ากฏ​หื้อ​เศคาริยาห์​หัน โดย​ยืน​อยู่​ตัง​เผิก​ขวา​ของ​แต้น​เผา​เครื่องหอม​นั้น ");
INSERT INTO nod_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","เศคาริยาห์​หัน​ใส่​ทูตสวรรค์​องค์​นั้น​ก็​สะดุ้ง​กั๋ว​ตั๋ว​สั่น ");
INSERT INTO nod_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ทูตสวรรค์​จึง​อู้​กับ​ต้าน​ว่า “เศคาริยาห์​เหย บ่﻿ถ้า​กั๋ว​เน่อ พระเจ้า​ฟัง​กำ​อธิษฐาน​ของ​ต้าน​แล้ว เอลีซาเบธ​เมีย​ของ​ต้าน​จะ​เกิด​ลูก​ป้อจาย หื้อ​ตั้ง​จื้อ​ลูก​ว่า​ยอห์น ");
INSERT INTO nod_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ต้าน​จะ​มี​ความ​จื้นจมยินดี​ย้อน​หละอ่อน​คน​นี้​นัก​ขนาด กับ​คน​อื่น​จ๋ำนวน​นัก​ก็​จะ​มี​ความ​ยินดี ตี้​เขา​เกิด​มา ");
INSERT INTO nod_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","เขา​จะ​เป๋นใหญ่​ต่อหน้า​พระเจ้า เขา​จะ​บ่﻿กิ๋น​เหล้า​องุ่น​กับ​เหล้า​อื่น﻿ๆ เลย กับ​พระวิญญาณ​บริสุทธิ์​จะ​อยู่​กับ​เขา​ตั้งแต่​อยู่​ใน​ต๊อง ");
INSERT INTO nod_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","เขา​จะ​นำ​จาว​อิสราเอล​หลาย​คน​ปิ๊ก​มา​หา​องค์​พระผู้เป๋นเจ้า​พระเจ้า​ของ​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","เขา​จะ​นำ​หน้า​พระองค์​โดย​อำนาจ​ตี้​มา​จาก​พระวิญญาณ​เหมือน​ตี้​เอลียาห์​เกย​มี เยียะ​หื้อ​ป้อ​คืนดี​กับ​ลูก กับ​คน​หลึ่ง​เปี่ยน​เป๋น​คน​มี​ปั๋ญญา​ของ​คน​ตี้​ถูกต้อง​ต๋าม​ธรรม เปื้อ​เกียม​คน​ใน​จ้าด​นึ่ง​ไว้​หื้อ​พร้อม​สำหรับ​ก๋าน​มา​ของ​องค์​พระผู้เป๋นเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","เศคาริยาห์​จึง​ถาม​ทูตสวรรค์​ว่า “ข้าพเจ้า​จะ​แน่ใจ๋​ได้​จาใด ย้อน​ข้าพเจ้า​กับ​เมีย​ก็​เฒ่า​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ฝ่าย​ทูตสวรรค์​ก็​ตอบ​ว่า “เฮา​คือ​กาเบรียล เซิ่ง​ยืน​อยู่​ต่อหน้า​พระเจ้า พระองค์​ใจ๊​เฮา​มา​อู้​กับ​ต้าน​กับ​บอก​ข่าวดี​นี้​แก่​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","แต่​ย้อน​ต้าน​บ่﻿เจื้อ​กำ​ของ​เฮา​ว่า​เรื่อง​นี้​จะ​เป๋น​แต๊​ต๋าม​ตี้​ก๋ำหนด ต้าน​ก็​จะ​เป๋น​ใบ้​จ๋น​เถิง​วัน​ตี้​เรื่อง​นี้​จะ​เกิด​ขึ้น​ใน​เวลา​ตี้​ก๋ำหนด” ");
INSERT INTO nod_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","คน​ตังหลาย​ตี้​ถ้า​เศคาริยาห์​ก็​งืด​ตี้​ต้าน​อยู่​ใน​พระวิหาร​เมิน​ล้ำ​ไป ");
INSERT INTO nod_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","เมื่อ​ต้าน​ออก​มา​แล้ว​ก็​อู้​กับ​หมู่​เขา​บ่﻿ได้ คน​หมู่​นั้น​ก็​กึ๊ด​ได้​ว่า​ต้าน​หัน​นิมิต​ใน​พระวิหาร ย้อน​หัน​ต้าน​เต๊ะ​ท่า​ใบ้​ใส่​หมู่​เขา​แต่​ยัง​อู้​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","เมื่อ​หมด​เวร​ของ​ต้าน​แล้ว​ต้าน​ก็​ปิ๊ก​บ้าน ");
INSERT INTO nod_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","เมื่อ​ลูน​มา เอลีซาเบธ​เมีย​ของ​เศคาริยาห์​ก็​มาน แล้ว​ก็​เก็บ​ตั๋ว​อยู่​ใน​บ้าน​ห้า​เดือน ");
INSERT INTO nod_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","นาง​อู้​ว่า “พระเจ้า​ได้​จ้วย​ข้าเจ้า​จาอี้ ใน​เวลา​นี้​พระองค์​เมตต๋า​ข้าเจ้า เปื้อ​จะ​บ่﻿หื้อ​ข้าเจ้า​ได้​อาย​คน​ตังหลาย​ย้อน​บ่﻿มี​ลูก” ");
INSERT INTO nod_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","เมื่อ​เอลีซาเบธ​ต๊อง​ได้​หก​เดือน​แล้ว ทูตสวรรค์​กาเบรียล​ก็​ฮับ​กำสั่ง​จาก​พระเจ้า​หื้อ​ไป​เมือง​นึ่ง​ใน​แคว้น​กาลิลี​จื้อ​นาซาเร็ธ ");
INSERT INTO nod_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ไป​หา​แม่ญิง​สาว​บริสุทธิ์​คน​นึ่ง​จื้อ​มารีย์ นาง​หมั้น​กับ​ป้อจาย​ตี้​จื้อ​โยเซฟ เซิ่ง​เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด ");
INSERT INTO nod_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ทูตสวรรค์​เข้า​มา​ใน​บ้าน​มารีย์ แล้ว​อู้​กับ​นาง​ว่า “มารีย์​เหย พระเจ้า​โผด​เจ้า พระองค์​อยู่​กับ​เจ้า​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","มารีย์​ก็​บ่﻿ม่วนใจ๋​ใน​กำ​อู้​ของ​ทูตสวรรค์​นั้น​ว่า กำ​ตวายตั๊ก​นั้น​หมายความ​ว่า​จาใด ");
INSERT INTO nod_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ทูตสวรรค์​ก็​อู้​กับ​นาง​แหม​ว่า “บ่﻿ถ้า​กั๋ว​ย้อน​พระเจ้า​โผด​เจ้า​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ผ่อ​เน่อ เจ้า​จะ​ต๊อง​แล้ว​เกิด​ลูก​ป้อจาย หื้อ​ตั้ง​จื้อ​ว่า​เยซู ");
INSERT INTO nod_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ลูก​คน​นั้น​จะ​เป๋นใหญ่ กับ​จะ​ได้​จื้อ​ว่า​เป๋น​พระบุตร​ของ​พระเจ้า​ผู้​สูงสุด พระเจ้า​จะ​ตั้ง​หื้อ​พระองค์​เป๋น​กษัตริย์​อย่าง​เดียว​กั๋น​กับ​กษัตริย์​ดาวิด​ป้อ​อุ๊ย​แม่​หม่อน​ของ​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ต้าน​จะ​ปกครอง​จาว​อิสราเอล​ตลอด​ไป แผ่นดิน​ของ​ต้าน​จะ​บ่﻿เสี้ยง​สุด​เลย” ");
INSERT INTO nod_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","มารีย์​ก็​ถาม​ทูตสวรรค์​ว่า “เหตุก๋ารณ์​นี้​จะ​เป๋น​ไป​ได้​จาใด ข้าเจ้า​ยัง​บ่﻿เกย​นอน​กับ​ป้อจาย​กำ​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ทูตสวรรค์​ตอบ​ว่า “พระวิญญาณ​บริสุทธิ์​จะ​อยู่​กับ​เจ้า ฤทธิ์​เดช​ของ​พระเจ้า​ผู้​สูงสุด​จะ​ปกคุม​เจ้า​ไว้ ย้อน​จาอี้​ผู้​บริสุทธิ์​ตี้​จะ​เกิด​มา​นั้น​จะ​ได้​จื้อ​ว่า พระบุตร​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ฟัง​เน่อ เอลีซาเบธ​ญาติ​ของ​เจ้า​เถิงแม้​นาง​เฒ่า​แล้ว ก็​ยัง​จะ​มี​ลูก​ป้อจาย คน​ตังหลาย​ถือ​ว่า​นาง​เป๋น​หมัน แต่​ก็​ยัง​ต๊อง​ได้​หก​เดือน​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ย้อน​บ่﻿มี​อะหยัง​ตี้​พระเจ้า​เยียะ​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","มารีย์​จึง​ว่า “ข้าเจ้า​เป๋น​คน​ฮับใจ๊​ของ​พระเจ้า ขอ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​ต้าน​ว่า​นั้น​เต๊อะ” แล้ว​ทูตสวรรค์​นั้น​ก็​จาก​นาง​ไป ");
INSERT INTO nod_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","เมื่อ​ลูน​มา มารีย์​ก็​ฟั่ง​ไป​เมือง​นึ่ง​ต๋ำ​หมู่​ดอย​ใน​แคว้น​ยูเดีย ");
INSERT INTO nod_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","แล้ว​เข้า​ไป​ใน​เฮือน​ของ​เศคาริยาห์ กับ​ตั๊กตวาย​เอลีซาเบธ ");
INSERT INTO nod_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","เมื่อ​เอลีซาเบธ​ได้ยิน​กำ​ตั๊กตวาย​ของ​มารีย์ ลูก​ใน​ต๊อง​ของ​เอลีซาเบธ​ก็​ดิ้น แล้ว​เอลีซาเบธ​ก็​ได้ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","จึง​อู้​เสียง​ดัง​ว่า “ใน​หมู่​แม่ญิง​ตังหลาย หลาน​ได้ฮับ​ปอน​นัก​เหลือ​เปิ้น ตึง​ลูก​ใน​ต๊อง​ของ​หลาน​ก็​ได้ฮับ​ปอน​ตวย ");
INSERT INTO nod_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","เป๋น​จาใด​พระเจ้า​โผด​ป้า​นัก​ขนาด​จาอี้ ตี้​แม่​ของ​องค์​พระผู้เป๋นเจ้า​ของ​ป้า​มา​แอ่ว​หา ");
INSERT INTO nod_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ผ่อ​ลอ บ่ากอง​ป้า​ได้ยิน​เสียง​อู้​ของ​หลาน ลูก​ใน​ต๊อง​ของ​ป้า​ก็​ดิ้น​อย่าง​จื้นจมยินดี ");
INSERT INTO nod_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","หลาน​ก็​เป๋น​สุข ย้อน​เจื้อ​กำ​ตี้​พระเจ้า​อู้​กับ​หลาน​ว่า​จะ​เป๋น​ไป​ต๋าม​นั้น” ");
INSERT INTO nod_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","มารีย์​จึง​ว่า “จิตใจ๋​ของ​ข้าเจ้า​ก็​สรรเสริญ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","จิตใจ๋​ข้าเจ้า​จื้นจมยินดี​ใน​พระเจ้า ผู้จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ​ของ​ข้าเจ้า ");
INSERT INTO nod_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ย้อน​พระองค์​ผ่อ​หัน​กับ​ห่วงใย​คน​ฮับใจ๊​ของ​พระองค์ ตี้​มี​ฐานะ​อัน​ต่ำต้อย แล้ว​ตั้งแต่​บ่าเดี่ยว​นี้​เป๋น​ต้น​ไป คน​กู้​เจ้น​จะ​ฮ้อง​ข้าเจ้า​ว่า​ผู้​มี​ความ​สุข ");
INSERT INTO nod_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ย้อน​ว่า​ผู้​มี​ฤทธิ์​อำนาจ​ได้​เยียะ​ก๋าน​ใหญ่​แก่​ข้าเจ้า กับ​พระองค์​ก็​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","พระองค์​มี​เมตต๋า​ต่อ​คน​ตี้​เก๋งกั๋ว​พระองค์​ตลอด​ไป​กู้​เจ้น​คน ");
INSERT INTO nod_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","พระองค์​ได้​ใจ๊​อำนาจ​เยียะ​สิ่ง​ตี้​ยิ่งใหญ่ พระองค์​ได้​เยียะ​หื้อ​คน​ตี้​มี​ใจ๋​จ๋องหอง​แตก​หนี ");
INSERT INTO nod_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","พระองค์​ได้​ยึด​อำนาจ​จาก​ผู้​ปกครอง แล้ว​ยก​คน​ต่ำต้อย​ขึ้น ");
INSERT INTO nod_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","พระองค์​โผด​หื้อ​สิ่ง​ดี﻿ๆ แก่​คน​อดอยาก แต่​คน​ร่ำรวย​พระเจ้า​หื้อ​ปิ๊ก​ไป​มือ​บ่ดาย ");
INSERT INTO nod_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","พระองค์​ได้​จ้วย​จาว​อิสราเอล​คน​ฮับใจ๊​ของ​พระองค์ คือ​พระองค์​บ่﻿ได้​ลืม​ความ​เมตต๋า​ตี้​ได้​สัญญา​ต่อ​อับราฮัม​กับ​ลูกหลาน​ของ​ต้าน​ตลอด​ไป ต๋าม​ตี้​พระองค์​ได้​อู้​ไว้​กับ​ป้อ​อุ๊ย​แม่​หม่อน​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","มารีย์​ก็​อยู่​ตวย​เอลีซาเบธ​ประมาณ​สาม​เดือน แล้ว​ก็​ปิ๊ก​บ้าน​ของ​นาง ");
INSERT INTO nod_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","เมื่อ​เอลีซาเบธ​เถิง​ก๋ำหนด​เกิด​แล้ว ก็​เกิด​ลูก​เป๋น​ป้อจาย ");
INSERT INTO nod_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ญาติ​ปี้น้อง​กับ​หมู่​จาวบ้าน​ของ​นาง​ได้ยิน​ว่า​พระเจ้า​ได้​แสดง​ความ​เมตต๋า​อย่าง​ยิ่งใหญ่​ต่อ​นาง ก็​ปา​กั๋น​จื้นจมยินดี​ตวย ");
INSERT INTO nod_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","เมื่อ​หละอ่อน​เกิด​ได้​แปด​วัน หมู่​เขา​ก็​ปา​กั๋น​มา​ฮ่วม​ใน​พิธี​สุหนัต​ของ​หละอ่อน​หน้อย แล้ว​จะ​ใส่​จื้อ​หละอ่อน​นั้น​ว่า​เศคาริยาห์​เหมือน​จื้อ​ของ​ป้อ ");
INSERT INTO nod_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","แต่​แม่​ของ​หละอ่อน​หน้อย​บอก​ว่า “บ่﻿ใจ้​เน่อ ต้อง​ใส่​จื้อ​ว่า ยอห์น” ");
INSERT INTO nod_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","หมู่​เขา​ก็​ปา​กั๋น​อู้​ว่า “บ่﻿มี​ปี้น้อง​ของ​ต้าน​จื้อ​ว่า​ยอห์น​ลอ” ");
INSERT INTO nod_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","แล้ว​หมู่​เขา​เต๊ะ​ท่า​ใบ้​ถาม​เศคาริยาห์​ว่า “ต้าน​ใค่​ใส่​จื้อ​ลูก​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ต้าน​ก็​ขอ​กระดานชนวน​มา แล้ว​เขียน​จื้อ​ลูก​ว่า ยอห์น คน​ตังหลาย​ก็​ปา​กั๋น​งืด ");
INSERT INTO nod_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","แล้ว​ต้าน​ก็​อู้​ได้​เหมือน​เก่า​บ่า​เดี่ยว​นั้น​เลย กับ​สรรเสริญ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","จาว​บ้าน​ก็​ปา​กั๋น​กั๋ว และ​เหตุก๋ารณ์​หมู่​นั้น​ก็​เล่าลือ​กั๋น​ไป​จ๋น​ใคว่​ดอย​ใน​แคว้น​ยูเดีย ");
INSERT INTO nod_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","หมู่​คน​ตี้​ได้ยิน​เรื่อง​นี้​ก็​จ๋ำ​ไว้​ใน​ใจ๋​ตึง​สงสัย​ว่า “หละอ่อน​หน้อย​คน​นี้​จะ​เป๋น​จาใด​ต่อ​ไป​ตังหน้า” ย้อน​อำนาจ​ของ​พระเจ้า​อยู่​กับ​เขา ");
INSERT INTO nod_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","เศคาริยาห์​ป้อ​ของ​ยอห์น​ก็​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์​แล้ว​ตวายตั๊ก​ว่า ");
INSERT INTO nod_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“จง​สรรเสริญ​พระเจ้า​ของ​หมู่​จาว​อิสราเอล ย้อน​ว่า​พระองค์​ได้​มา​หา​คน​ของ​พระองค์​แล้ว เปื้อ​จ้วย​หมู่​เขา​หื้อ​มี​อิสระ ");
INSERT INTO nod_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","พระองค์​ได้​หื้อ​ผู้จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ​ตี้​มี​ฤทธิ์​เกิด​มา ใน​เจื๊อสาย​ของ​กษัตริย์​ดาวิด​ผู้​ฮับใจ๊​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ก็​เป๋น​ไป​ต๋าม​ตี้​พระองค์​ได้​อู้​ไว้​ตั้งแต่​โบราณ​มา​แล้ว​ผ่าน​ตาง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตี้​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","คือ​พระองค์​จะ​จ้วย​เฮา​หื้อ​รอด​ป๊น​จาก​หมู่​ศัตรู๋​ของ​เฮา กับ​ป๊น​จาก​อำนาจ​ของ​คน​ตังหลาย​ตี้​จัง​เฮา ");
INSERT INTO nod_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ย้อน​พระเจ้า​ได้​เมตต๋า​ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​เฮา กับ​กึ๊ด​เถิง​พันธสัญญา​อัน​บริสุทธิ์​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","คือ​พันธสัญญา​ตี้​พระเจ้า​ปฏิญาณ​ไว้​กับ​อับราฮัม ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ตี้​จะ​จ้วย​หมู่​เฮา​ป๊น​จาก​อำนาจ​ของ​ศัตรู๋​ตังหลาย​ของ​หมู่​เฮา แล้ว​จะ​โผด​หื้อ​เฮา​ฮับใจ๊​พระองค์​โดย​บ่﻿มี​ความ​กั๋ว ");
INSERT INTO nod_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ด้วย​ความ​บริสุทธิ์​กับ​ความ​ถูกต้อง​ต๋าม​ธรรม​ไป​ตลอด​จีวิต​ของ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ส่วน​ยอห์น​ลูก​ของ​เฮา​เหย คน​อื่น﻿ๆ จะ​ว่า​ลูก​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ผู้​สูงสุด ย้อน​ว่า​ลูก​จะ​นำ​หน้า​องค์​พระผู้เป๋นเจ้า เปื้อ​เกียม​ก๋าน​มา​ของ​องค์​พระผู้เป๋นเจ้า​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","79","เปื้อ​จะ​เยียะ​หื้อ​คน​ของ​พระองค์​ฮู้​เถิง​ความ​รอด​ป๊น​บาป​โต้ษ คือ​โต้ษ​บาป​ของ​หมู่​เขา​จะ​ได้​ฮับ​ก๋าน​ยกโต้ษ​โดย​ความ​เมตต๋า​ของ​พระเจ้า แสง​จาก​สวรรค์​ก็​ใก้​จะ​ส่อง​ลง​มา​เถิง​หมู่​เฮา เปื้อ​ส่อง​หื้อ​กับ​คน​ตังหลาย​ตี้​อยู่​ใน​ความ​มืด กับ​คน​ตี้​ตก​อยู่​ใต้​เงา​แห่ง​ความ​ต๋าย กับ​เปื้อ​นำ​หมู่​เฮา​มา​สู่​ตาง​แห่ง​สันติสุข” ");
INSERT INTO nod_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","หละอ่อน​หน้อย​คน​นั้น​ก็​ใหญ่​ขึ้น กับ​เข้มแข็ง​ตาง​จิตวิญญาณ​นัก​ขึ้น ต้าน​ก็​ไป​อยู่​ใน​ดินแดน​ทุรกั๋นดาร​จ๋น​เถิง​วัน​ตี้​ต้าน​เผย​ตั๋ว​ต่อ​หน้า​จาว​อิสราเอล ");
INSERT INTO nod_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ต๋อน​นั้น​จักรพรรดิ​ออกัสตัส มี​กำสั่ง​หื้อ​มี​ก๋าน​จด​ทะเบียน​สำมะโน​ครัว​ใคว่​อาณาจักร​โรม ");
INSERT INTO nod_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ก๋าน​จด​ทะเบียน​สำมะโน​ครัว​นี้​เป๋น​เตื้อ​ตี้​นึ่ง​ตี้​เกิด​ขึ้น​ต๋อน​คีรินิอัส​เป๋น​เจ้าเมือง​แคว้น​ซีเรีย ");
INSERT INTO nod_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","คน​ตังหลาย​ก็​ปา​กั๋น​ไป​จด​ทะเบียน​ตี้​เมือง​ของ​ต๋น ");
INSERT INTO nod_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","โยเซฟ​ก็​ออก​จาก​เมือง​นาซาเร็ธ​แคว้น​กาลิลี ขึ้น​ไป​เมือง​เบธเลเฮม​ตี้​เป๋น​บ้าน​เกิด​ของ​กษัตริย์​ดาวิด​ใน​แคว้น​ยูเดีย ย้อน​ว่า​โยเซฟ​เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด ");
INSERT INTO nod_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","เขา​ปา​มารีย์​ตี้​หมั้น​ไว้​กับ​ต๊อง​แก่​ใก้​จะ​เกิด​ไป​ตวย เปื้อ​จะ​ขึ้น​ทะเบียน​สำมะโน​ครัว ");
INSERT INTO nod_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","เมื่อ​เขา​ตึง​สอง​อยู่​ใน​เมือง​เบธเลเฮม​นั้น ก็​เถิง​เวลา​ตี้​มารีย์​จะ​เกิด​ลูก ");
INSERT INTO nod_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","นาง​ก็​เกิด​ลูก​ป้อจาย​คน​เก๊า นาง​เอา​ผ้า​อ้อม​ปัน​ตั๋ว​หละอ่อน แล้ว​วาง​ไว้​ใน​ฮาง​หญ้า ย้อน​บ่﻿มี​ตี้​พัก​ไหน​ว่าง​เลย ");
INSERT INTO nod_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ใก้﻿ๆ เมือง​นั้น​มี​คน​เลี้ยง​แกะ เฝ้า​ฝูง​แกะ​ของ​หมู่​เขา​ต๋อน​เมื่อคืน ");
INSERT INTO nod_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","มี​ทูตสวรรค์​องค์​นึ่ง​ของ​องค์​พระผู้เป๋นเจ้า​ป๋ากฏ​กับ​หมู่​เขา รัศมี​ของ​พระเจ้า​ส่อง​ล้อม​รอบ​หมู่​เขา หมู่​เขา​ก็​ตกใจ๋​กั๋ว​ขนาด ");
INSERT INTO nod_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ทูตสวรรค์​องค์​นั้น​อู้​กับ​หมู่​เขา​ว่า “บ่﻿ถ้า​กั๋ว​เน่อ ย้อน​เฮา​นำ​ข่าว​มา​บอก​ต้าน​ตังหลาย เป๋น​ข่าว​ตี้​จะ​เยียะ​หื้อ​คน​ตังหลาย​ดีอกดีใจ๋ ");
INSERT INTO nod_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","คือ​ว่า​วัน​นี้ พระ​ผู้​จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ​ของ​ต้าน​ตังหลาย คือ​พระคริสต์ องค์​พระผู้เป๋นเจ้า​มา​เกิด​ตี้​เมือง​เบธเลเฮม บ้าน​เกิด​ของ​กษัตริย์​ดาวิด ");
INSERT INTO nod_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","จะ​มี​อย่าง​นึ่ง​ตี้​เยียะ​หื้อ​ฮู้​ว่า​เป๋น​แต๊ คือ​หมู่​ต้าน​จะ​หัน​หละอ่อน​หน้อย​ปัน​ผ้าอ้อม​นอน​อยู่​ใน​ฮาง​หญ้า” ");
INSERT INTO nod_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","จู่﻿ๆ ก็​มี​หมู่​ทูตสวรรค์​จ๋ำนวน​นัก​มา​ฮ่วม​กับ​ทูตสวรรค์​องค์​นั้น​แล้ว​ปา​กั๋น​สรรเสริญ​พระเจ้า​ว่า ");
INSERT INTO nod_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ขอ​หื้อ​พระเจ้า​ฮับ​เกียรติ​ใน​สวรรค์​สูงสุด ขอ​หื้อ​พระเจ้า​หื้อ​สันติสุข​แก่​คน​ตี้​พระองค์​เปิงใจ๋​ใน​โลก​นี้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","เมื่อ​หมู่​ทูตสวรรค์​จาก​หมู่​เขา​ปิ๊ก​ไป​สวรรค์​แล้ว หมู่​คน​เลี้ยง​แกะ​ก็​จวน​กั๋น​ว่า “หื้อ​เฮา​ไป​เมือง​เบธเลเฮม ผ่อ​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​ต๋าม​ตี้​องค์​พระผู้เป๋นเจ้า​ได้​บอก​หมู่​เฮา” ");
INSERT INTO nod_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","หมู่​เขา​ก็​ฟั่ง​ปา​กั๋น​ไป เมื่อ​ไป​แผว​ก็​ปะ​โยเซฟ​กับ​มารีย์ แล้ว​หัน​หละอ่อน​เกิด​ใหม่​นอน​อยู่​ใน​ฮาง​หญ้า ");
INSERT INTO nod_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","เมื่อ​หมู่​เขา​หัน​จาอั้น​แล้ว ก็​เล่า​เรื่อง​ตี้​ทูตสวรรค์​บอก​นั้น​หื้อ​โยเซฟ​กับ​มารีย์​ตึง​คน​อื่น﻿ๆ ฟัง ");
INSERT INTO nod_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","คน​ตังหลาย​ตี้​ได้ยิน​ก็​ปา​กั๋น​งืด​ใน​เรื่อง​ตี้​คน​เลี้ยง​แกะ​เล่า​หื้อ​ฟัง​นั้น ");
INSERT INTO nod_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ส่วน​มารีย์​ก็​จ๋ำ​เรื่อง​หมู่​นี้​ไว้​ใน​ใจ๋ กับ​กึ๊ด​เถิง​เรื่อง​นี้​อยู่​ตลอด ");
INSERT INTO nod_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","หมู่​คน​เลี้ยง​แกะ​ก็​ปา​กั๋น​ปิ๊ก​กับ​สรรเสริญ​พระเจ้า​ไป​ตวย ใน​เหตุก๋ารณ์​ตึงหมด​ตี้​เขา​ได้ยิน​ได้​หัน​ต๋าม​ตี้​ทูตสวรรค์​บอก​ไว้​กู้​อย่าง ");
INSERT INTO nod_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","เมื่อ​หละอ่อน​คน​นั้น​เกิด​ได้​แปด​วัน​แล้ว ก็​เถิง​วัน​ตี้​จะ​เข้า​พิธี​สุหนัต ป้อแม่​จึง​ตั้ง​จื้อ​ว่า​เยซู ต๋าม​ตี้​ทูตสวรรค์​บอก​ไว้​ตั้งแต่​มารีย์​ยัง​บ่﻿ต๊อง​เตื้อ ");
INSERT INTO nod_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","เมื่อ​เถิง​เวลา​เยียะ​พิธี​ล้าง​ตั๋ว​หื้อ​บริสุทธิ์​ต๋าม​บท​บัญญัติ​ของ​โมเสส​แล้ว โยเซฟ​ตึง​มารีย์​ก็​ปา​ลูก​ไป​กรุง​เยรูซาเล็ม เปื้อ​ถวาย​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(​ต๋าม​ตี้​เขียน​ไว้​ใน​บท​บัญญัติ​ของ​โมเสส​ว่า “ลูก​คน​เก๊า​ตี้​เป๋น​ป้อจาย​กู้​คน​ต้อง​มอบ​ถวาย​หื้อ​องค์​พระผู้เป๋นเจ้า”) ");
INSERT INTO nod_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","แล้ว​เขา​ก็​ถวาย​เครื่อง​ปู่จา​สำหรับ​พิธี​นี้ ต๋าม​ตี้​องค์​พระผู้เป๋นเจ้า​สั่ง​ไว้​ใน​บท​บัญญัติ ของ​พระองค์ คือ​นกเขา​หนุ่ม​กู้​นึ่ง​กาว่า​นกก๋าแก๋​หนุ่ม​กู้​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","มี​ป้อจาย​คน​นึ่ง​จื้อ​สิเมโอน​อยู่​ใน​กรุง​เยรูซาเล็ม เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม​กับ​เจื้อฟัง​พระเจ้า ต้าน​รอ​ถ้า​เวลา​ตี้​พระเจ้า​จะ​มา​จ้วย​จาว​อิสราเอล​หื้อ​รอด​ป๊น​จาก​ความ​ตุ๊ก กับ​พระวิญญาณ​บริสุทธิ์​อยู่​กับ​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","พระวิญญาณ​บริสุทธิ์​เกย​เปิดเผย​แก่​ต้าน​ว่า ต้าน​จะ​บ่﻿ต๋าย​เตื้อ​จ๋น​กว่า​ต้าน​จะ​ได้​หัน​พระคริสต์​ของ​องค์​พระผู้เป๋นเจ้า ");
INSERT INTO nod_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ใน​วัน​นั้น​สิเมโอน​เข้า​ไป​ใน​พระวิหาร​โดย​ก๋าน​นำ​ของ​พระวิญญาณ​บริสุทธิ์ เมื่อ​ป้อแม่​ปา​พระเยซู​เข้า​ไป​ใน​พระวิหาร เปื้อ​จะ​เยียะ​ต๋าม​ธรรมเนียม​บท​บัญญัติ ");
INSERT INTO nod_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","สิเมโอน​ก็​อุ้ม​พระเยซู แล้ว​สรรเสริญ​พระเจ้า​ว่า ");
INSERT INTO nod_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ข้า​แต่​พระเจ้า​ผู้​ยิ่งใหญ่​สูงสุด บ่าเดี่ยว​นี้​ขอ​หื้อ​ส่ง​ผู้​ฮับใจ๊​ของ​พระองค์​ไป​เป๋น​สุข ต๋าม​กำ​สัญญา​ของ​พระองค์​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ย้อน​ว่า ต๋า​ของ​ข้าพเจ้า​ได้​หัน​พระ​ผู้​จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ​ตี้​พระเจ้า​ส่ง​มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ผู้​ตี้​พระองค์​เกียม​ไว้​สำหรับ​คน​กู้​จ้าด ");
INSERT INTO nod_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ผู้​ตี้​เป๋น​แสง​ส่อง​แจ้ง​หื้อ​คน​ต่างจ้าด​ฮู้จัก​พระเจ้า กับ​เป๋น​ผู้​นำ​เกียรติ​อัน​ยิ่งใหญ่​มา​หื้อ​จาว​อิสราเอล​คน​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ส่วน​โยเซฟ​กับ​มารีย์​ได้ยิน​สิเมโอน​อู้​จาอั้น​ก็​งืด​ใน​กำ​ตี้​ต้าน​ได้​อู้​เถิง​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","สิเมโอน​ก็​ปั๋น​ปอน​หมู่​เขา แล้ว​อู้​กับ​มารีย์​แม่​พระเยซู​ว่า “ถ้า​ผ่อ​ไป​เต๊อะ หละอ่อน​หน้อย​คน​นี้​ตี้​พระเจ้า​เลือก​ไว้​จะ​เยียะ​หื้อ​จาว​อิสราเอล​หลาย​คน​ล้ม​ลง กาว่า​ลุก​ขึ้น กับ​จะ​เป๋น​เครื่องหมาย​ตี้​แสดง​เถิง​ความ​ต้องก๋าน​ของ​พระเจ้า แต่​คน​จะ​ต่อต้าน ");
INSERT INTO nod_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","เปื้อ​จะ​เปิดเผย​กำกึ๊ด​ใน​ใจ๋​ของ​คน​จ๋ำนวน​นัก กับ​หัวใจ๋​ของ​แม่​ก็​จะ​เจ็บปวด​ทรมาน​เหมือน​ถูก​ดาบ​แตง​ใน​ใจ๋” ");
INSERT INTO nod_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","มี​แม่ญิง​คน​นึ่ง​จื้อ​อันนา เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า เป๋น​ลูกสาว​ของ​ฟานูเอล​คน​ใน​ผะกุ๋น​อาเชอร์ นาง​เฒ่า​นัก​แล้ว แต่งงาน​เมื่อ​ยัง​สาว อยู่​กิ๋น​กั๋น​ได้​เจ็ด​ปี๋​ผัว​ก็​ต๋าย​ละ ");
INSERT INTO nod_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","นาง​เป๋น​หม้าย​จ๋น​อายุ​ได้​แปด​สิบ​สี่​ปี๋ นาง​บ่﻿ได้​ออก​จาก​พระวิหาร​เลย แต่​นมัสก๋าน​ตึง​เมื่อวัน​เมื่อคืน​โดย​ถือ​ศีล​อด​อาหาร​กับ​อธิษฐาน ");
INSERT INTO nod_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","นาง​เข้า​มา​ตั๊ด​ต๋อน​ตี้​สิเมโอน​ยัง​อยู่​กับ​โยเซฟ​กับ​มารีย์ นาง​ตั้งเก๊า​ขอบพระคุณ​พระเจ้า​สำหรับ​พระเยซู แล้ว​อู้​เรื่อง​พระเยซู​หื้อ​คน​ตังหลาย​ตี้​ถ้า​เวลา​ตี้​กรุง​เยรูซาเล็ม​จะ​หลุด​ป๊น​เป๋น​อิสระ​ฟัง ");
INSERT INTO nod_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","เมื่อ​โยเซฟ​กับ​มารีย์​ได้​เยียะ​ต๋าม​บท​บัญญัติ​ของ​องค์​พระผู้เป๋นเจ้า​กู้​อย่าง​แล้ว ก็​ปิ๊ก​ไป​เมือง​นาซาเร็ธ​บ้าน​ของ​เขา​ใน​แคว้น​กาลิลี ");
INSERT INTO nod_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","หละอ่อน​หน้อย​คน​นั้น​ก็​ใหญ่​ขึ้น แข็งแฮง มี​สติ​ปั๋ญญา​นัก กับ​พระเจ้า​ก็​ปั๋น​ปอน​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","กู้​ปี๋​ป้อแม่​ของ​พระเยซู​เกย​ขึ้น​ไป​กรุง​เยรูซาเล็ม​เปื้อ​ฮ่วม​งาน​ปัสกา ");
INSERT INTO nod_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ต๋อน​ตี้​พระเยซู​อายุ​สิบ​สอง​ปี๋ หมู่​เขา​ก็​ขึ้น​ไป​กรุง​เยรูซาเล็ม​เปื้อ​ฮ่วม​งาน​ปัสกา​เหมือน​กู้​ปี๋ ");
INSERT INTO nod_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","เมื่อ​เสี้ยง​งาน​แล้ว หมู่​เขา​ก็​ปิ๊ก​เมือ​บ้าน ส่วน​พระเยซู​ยัง​อยู่​ใน​กรุง​เยรูซาเล็ม โยเซฟ​กับ​มารีย์​ก็​บ่﻿ฮู้ ");
INSERT INTO nod_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","เขา​สอง​คน​กึ๊ด​ว่า​พระเยซู​อยู่​ใน​หมู่​คน​ตี้​มา​ตวย​กั๋น เมื่อ​เตียว​ตาง​มา​ได้​วัน​นึ่ง ก็​เซาะหา​พระเยซู​ใน​หมู่​ปี้น้อง​กับ​หมู่​คน​ตี้​ฮู้จัก​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","เมื่อ​เซาะหา​บ่﻿ปะ ก็​ปิ๊ก​ไป​เซาะ​ใน​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","เซาะ​ได้​สาม​วัน ก็​ปะ​พระเยซู​นั่ง​อยู่​บริเวณ​พระวิหาร​กับ​หมู่​อาจ๋ารย์ ก่ำลัง​ฟัง​กับ​ถาม​อาจ๋ารย์​หมู่​นั้น ");
INSERT INTO nod_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","คน​ตังหลาย​ตี้​ได้ยิน​พระองค์​อู้ ก็​ปา​กั๋น​งืด​ใน​สติ​ปั๋ญญา​กับ​กำตอบ​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","เมื่อ​ป้อแม่​หัน​ก็​งืด​ขนาด แม่​ก็​ถาม​ว่า “ลูก​เหย เยียะ​หยัง​จาอี้ ป้อ​กับ​แม่​เซาะหา​ลูก​ตุ๊ก​อก​ตุ๊ก​ใจ๋​ขนาด​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","พระเยซู​ก็​ตอบ​ไป​ว่า “เซาะ​หา​เฮา​เยียะ​หยัง บ่﻿ฮู้​กา ว่า​เฮา​ต้อง​อยู่​ใน​บ้าน​ของ​พระบิดา​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ป้อแม่​ก็​บ่﻿เข้าใจ๋​กำ​อู้​ของ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","แล้ว​พระเยซู​ก็​ปิ๊ก​ไป​เมือง​นาซาเร็ธ​ตวย​หมู่​เขา กับ​ยอม​เจื้อฟัง​ป้อแม่ แม่​ก็​จ๋ำ​เรื่อง​ตึงหมด​นี้​ไว้​ใน​ใจ๋ ");
INSERT INTO nod_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","พระเยซู​ก็​ใหญ่​ขึ้น​ตึง​ตั๋ว​กับ​สติ​ปั๋ญญา พระเจ้า​กับ​คน​ตังหลาย​ก็​ปอใจ๋​พระองค์​นัก​ขึ้น​ติก﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ใน​ปี๋​ตี้​สิบ​ห้า​ใน​ราชก๋าน​ทิเบริอัส​ซีซาร์ ต๋อน​นั้น​ปอนทิอัส​ปีลาต​เป๋น​เจ้าเมือง​แคว้น​ยูเดีย เฮโรด อันติบัส​ปกครอง​แคว้น​กาลิลี ฟีลิป​น้องบ่าว​ของ​เฮโรด​ปกครอง​แคว้น​อิทูเรีย​กับ​แคว้น​ตราโคนิติส ส่วน​ลีซาเนียส​ปกครอง​แคว้น​อาบีเลน ");
INSERT INTO nod_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","อันนาส​กับ​คายาฟาส​เป๋น​มหา​ปุโรหิต ต๋อน​นั้น​ยอห์น​ลูก​เศคาริยาห์​ได้​ฮับ​ถ้อยกำ​ของ​พระเจ้า​ใน​ดินแดน​ทุรกั๋นดาร ");
INSERT INTO nod_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","แล้ว​ยอห์น​ก็​ไป​ตัง​ลุ่ม​แม่น้ำ​จอร์แดน​จ๋น​ใคว่ บอก​หื้อ​คน​กลับใจ๋​จาก​บาป​กับ​หื้อ​ฮับ​บัพติศมา​เปื้อ​พระเจ้า​จะ​ยกโต้ษ​บาป​หื้อ ");
INSERT INTO nod_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","เรื่อง​นี้​ก็​เป๋น​ไป​ต๋าม​ตี้​เขียน​ไว้​ใน​หนังสือ​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ว่า “มี​เสียง​ฮ้องเอิ้น​ของ​คน​นึ่ง​ใน​ดินแดน​ทุรกั๋นดาร​ว่า ‘เกียม​ใจ๋​หื้อ​พร้อม​สำหรับ​ก๋าน​เข้า​มา​ของ​องค์​พระ​ผู้​เป๋น​เจ้า จง​แป๋ง​หน​ตาง​ซื่อ﻿ๆ หื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ห้วย​กู้​ตี้​ก็​ถม​หื้อ​เต๋ม ดอย​ต่าง﻿ๆ ก็​ตัด​หื้อ​ต่ำ​ลง ตาง​ก๊ด​ก็​แป๋ง​หื้อ​ซื่อ ตาง​ตี้​สูง​ต่ำ​บ่﻿เต้า​กั๋น​ก็​แป๋ง​หื้อ​เปียง ");
INSERT INTO nod_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","คน​ตังหลาย​จะ​หัน​ความ​รอด​ป๊น​บาป​โต้ษ​ของ​พระเจ้า’ ” ");
INSERT INTO nod_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ยอห์น​จึง​ว่า​หมู่​คน​ตี้​ออก​มา​ฮับ​บัพติศมา​ว่า “หมู่​จ้าด​งู​ปิ๊ด ใผ​เตื๋อน​หื้อ​หมู่​สู​หลบ​หนี​จาก​ก๋าน​ลงโต้ษ​ของ​พระเจ้า​ตี้​ก่ำลัง​จะ​มา​เถิง ");
INSERT INTO nod_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","เยียะ​หื้อ​ผ่อ​กำ​ลุ​ว่า​จีวิต​หมู่​สู​เกิด​ผล​จาก​ก๋าน​กลับใจ๋​จาก​บาป​แล้ว​แต๊﻿ๆ บ่﻿ดี​กึ๊ด​เอา​คน​เดียว​ว่า ‘หมู่​เฮา​บ่﻿ต้อง​ถูก​ลงโต้ษ ย้อน​ว่า​หมู่​เฮา​เป๋น​ลูก​หลาน​ต๋านเต๊า​ของ​อับราฮัม’ เฮา​จะ​บอก​หื้อ​ฮู้​ว่า พระเจ้า​จะ​เยียะ​หื้อ​บ่าหิน​หมู่​นี้​ก๋าย​เป๋น​ลูก​หลาน​ของ​อับราฮัม​ก็​ได้​เน่อ ");
INSERT INTO nod_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","มุย​ได้​เกียม​แน​ไว้​ตี้​ปื๊น​เก๊าไม้​แล้ว เก๊าไม้​กู้​เก๊า​ตี้​เกิด​หน่วย​บ่﻿ดี​จะ​ถูก​ตัด​แล้ว​ขว้าง​ใส่​ใน​ก๋อง​ไฟ” ");
INSERT INTO nod_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","หมู่​คน​จึง​ถาม​ต้าน​ว่า “เฮา​จะ​ต้อง​เยียะ​จาใด​ดี” ");
INSERT INTO nod_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ยอห์น​ตอบ​หมู่​เขา​ว่า “คน​ใด​มี​เสื้อ​สอง​ผืน​หื้อ​แบ่ง​คน​ตี้​บ่﻿มี คน​ใด​มี​ของกิ๋น​ก็​หื้อ​ปั๋น​คน​ตี้​บ่﻿มี​กิ๋น” ");
INSERT INTO nod_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","หมู่​คน​เก็บ​ภาษี​ก็​มา​ขอ​ฮับ​บัพติศมา​ตวย หมู่​เขา​ถาม​ว่า “อาจ๋ารย์ หมู่​เฮา​จะ​ต้อง​เยียะ​จาใด​พ่อง” ");
INSERT INTO nod_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ยอห์น​ตอบ​หมู่​เขา​ว่า “หมู่​เจ้า​ห้าม​เก็บ​ภาษี​เกิ๋น​ตี้​ก๋ำหนด” ");
INSERT INTO nod_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","หมู่​ทหาร​ก็​ถาม​ว่า “หมู่​เฮา​ลอ​จะ​ต้อง​เยียะ​จาใด​พ่อง” ต้าน​ตอบ​หมู่​เขา​ว่า “ห้าม​บังคับ​คน​อื่น​กับ​ห้าม​ใส่​ฮ้าย​เปื้อ​เอา​สตางค์​คน​อื่น แต่​หื้อ​ปอใจ๋​ก้าจ้าง​ของ​ตั๋ว” ");
INSERT INTO nod_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","คน​ตังหลาย​ก่ำลัง​ถ้า​พระคริสต์​มา​อย่าง​ใจ๋จด​ใจ๋จ่อ ก็​สงสัย​ว่า ยอห์น​เป๋น​พระคริสต์​แม่น​ก่อ ");
INSERT INTO nod_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ยอห์น​จึง​ตอบ​เขา​ตังหลาย​ว่า “เฮา​หื้อ​เจ้า​ฮับ​บัพติศมา​ด้วย​น้ำ แต่​จะ​มี​แหม​ผู้​นึ่ง​มี​อำนาจ​นัก​เหลือ​เฮา​มา​เมื่อ​ลูน แม้แต่​แก้​สาย​มัด​เกิบ​ของ​ต้าน ตั๋ว​เฮา​ยัง​บ่﻿สมควร​จะ​เยียะ​จาอั้น​เลย ต้าน​จะ​หื้อ​เจ้า​ตังหลาย​ฮับ​บัพติศมา​ด้วย​พระวิญญาณ​บริสุทธิ์​กับ​ด้วย​ไฟ ");
INSERT INTO nod_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ต้าน​เหมือน​จาวนา มือ​ของ​ต้าน​ก๋ำ​ผาก​หะ​ข้าว​ไว้ แล้ว​จะ​สะสาง​ตะราง​ตี๋​ข้าว​จ๋น​ใคว่ จะ​เก็บ​ข้าว​เต้ง​ไว้​ใน​หลองข้าว ส่วน​ข้าว​ลีบ​ก็​จะ​เอา​ไป​เผา​ไฟ​ตี้​บ่﻿ฮู้จัก​ดับ” ");
INSERT INTO nod_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ยอห์น​จั๊กจวน​เขา​แหม​หลาย​อย่าง กับ​บอก​ข่าวดี​เรื่อง​พระคริสต์​แก่​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ยอห์น​ด่า​กษัตริย์​เฮโรด​ตี้​ปกครอง​แคว้น เรื่อง​เอา​นาง​เฮโรเดียส​เมีย​ของ​น้อง​บ่าว​มา​เป๋น​เมีย​ของ​ตั๋ว กับ​อู้​เถิง​ก๋าน​บ่﻿ดี​ตังหลาย​ตี้​เฮโรด​ได้​เยียะ ");
INSERT INTO nod_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","เฮโรด​ซ้ำ​เยียะ​ก๋าน​บ่﻿ดี​นัก​ขึ้น​แหม เปาะ​กับ​ตี้​เยียะ​มา​แล้ว คือ​ยับ​ยอห์น​ไป​ขัง​คอก ");
INSERT INTO nod_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","เมื่อ​คน​ตังหลาย​ฮับ​บัพติศมา พระเยซู​ก็​ฮับ​ตวย ต๋อน​ตี้​พระเยซู​ก่ำลัง​อธิษฐาน​อยู่ ฟ้า​สวรรค์​ก็​แหวก​ออก​เป๋น​ฮ่อม ");
INSERT INTO nod_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","พระวิญญาณ​บริสุทธิ์​มี​ฮูปฮ่าง​เหมือน​นกก๋าแก๋​ลง​มา​อยู่​บน​พระองค์ แล้ว​มี​เสียง​มา​จาก​ฟ้า​สวรรค์​ว่า “ต้าน​ผู้​นี้​เป๋น​ลูก​ตี้​เฮา​ฮัก เฮา​เปิงใจ๋​ต้าน​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","เมื่อ​พระเยซู​ตั้งเก๊า​สั่ง​สอน พระองค์​อายุ​ประมาณ​สาม​สิบ​ปี๋ ต๋าม​กำกึ๊ด​ของ​คน​ตังหลาย​เข้าใจ๋​ว่า พระเยซู​เป๋น​ลูก​ของ​โยเซฟ โยเซฟ​เป๋น​ลูก​ของ​เฮลี ");
INSERT INTO nod_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","เฮลี​เป๋น​ลูก​ของ​มัทธัต มัทธัต​เป๋น​ลูก​ของ​เลวี เลวี​เป๋น​ลูก​ของ​เมลคี เมลคี​เป๋น​ลูก​ของ​ยันนาย ยันนาย​เป๋น​ลูก​ของ​โยเซฟ ");
INSERT INTO nod_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","โยเซฟ​เป๋น​ลูก​ของ​มัทธาธีอัส มัทธาธีอัส​เป๋น​ลูก​ของ​อาโมส อาโมส​เป๋น​ลูก​ของ​นาฮูม นาฮูม​เป๋น​ลูก​ของ​เอสลี เอสลี​เป๋น​ลูก​ของ​นักกาย ");
INSERT INTO nod_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","นักกาย​เป๋น​ลูก​ของ​มาอาท มาอาท​เป๋น​ลูก​ของ​มัทธาธีอัส มัทธาธีอัส​เป๋น​ลูก​ของ​เสเมอิน เสเมอิน​เป๋น​ลูก​ของ​โยเสค โยเสค​เป๋น​ลูก​ของ​โยดา ");
INSERT INTO nod_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","โยดา​เป๋น​ลูก​ของ​โยอานัน โยอานัน​เป๋น​ลูก​ของ​เรซา เรซา​เป๋น​ลูก​ของ​เศรุบบาเบล เศรุบบาเบล​เป๋น​ลูก​ของ​เชอัลทิเอล เชอัลทิเอล​เป๋น​ลูก​ของ​เนรี ");
INSERT INTO nod_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","เนรี​เป๋น​ลูก​ของ​เมลคี เมลคี​เป๋น​ลูก​ของ​อัดดี อัดดี​เป๋น​ลูก​ของ​โคสัม โคสัม​เป๋น​ลูก​ของ​เอลมาดัม เอลมาดัม​เป๋น​ลูก​ของ​เอร์ ");
INSERT INTO nod_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","เอร์​เป๋น​ลูก​ของ​โยชูวา โยชูวา​เป๋น​ลูก​ของ​เอลีเยเซอร์ เอลีเยเซอร์​เป๋น​ลูก​ของ​โยริม โยริม​เป๋น​ลูก​ของ​มัทธัต มัทธัต​เป๋น​ลูก​ของ​เลวี ");
INSERT INTO nod_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","เลวี​เป๋น​ลูก​ของ​สิเมโอน สิเมโอน​เป๋น​ลูก​ของ​ยูดาห์ ยูดาห์​เป๋น​ลูก​ของ​โยเซฟ โยเซฟ​เป๋น​ลูก​ของ​โยนาม โยนาม​เป๋น​ลูก​ของ​เอลียาคิม ");
INSERT INTO nod_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","เอลียาคิม​เป๋น​ลูก​ของ​เมเลอา เมเลอา​เป๋น​ลูก​ของ​เมนนา เมนนา​เป๋น​ลูก​ของ​มัทตะธา มัทตะธา​เป๋น​ลูก​ของ​นาธัน นาธัน​เป๋น​ลูก​ของ​ดาวิด ");
INSERT INTO nod_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ดาวิด​เป๋น​ลูก​ของ​เจสซี เจสซี​เป๋น​ลูก​ของ​โอเบด โอเบด​เป๋น​ลูก​ของ​โบอาส โบอาส​เป๋น​ลูก​ของ​สัลโมน สัลโมน​เป๋น​ลูก​ของ​นาโชน ");
INSERT INTO nod_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","นาโชน​เป๋น​ลูก​ของ​อัมมีนาดับ อัมมีนาดับ​เป๋น​ลูก​ของ​อัดมิน อัดมิน​เป๋น​ลูก​ของ​อารนี อารนี​เป๋น​ลูก​ของ​เฮสโรน เฮสโรน​เป๋น​ลูก​ของ​เปเรศ เปเรศ​เป๋น​ลูก​ของ​ยูดาห์ ");
INSERT INTO nod_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ยูดาห์​เป๋น​ลูก​ของ​ยาโคบ ยาโคบ​เป๋น​ลูก​ของ​อิสอัค อิสอัค​เป๋น​ลูก​ของ​อับราฮัม อับราฮัม​เป๋น​ลูก​ของ​เทราห์ เทราห์​เป๋น​ลูก​ของ​นาโฮร์ ");
INSERT INTO nod_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","นาโฮร์​เป๋น​ลูก​ของ​เสรุก เสรุก​เป๋น​ลูก​ของ​เรอู เรอู​เป๋น​ลูก​ของ​เปเลก เปเลก​เป๋น​ลูก​ของ​เอเบอร์ เอเบอร์​เป๋น​ลูก​ของ​เชลาห์ ");
INSERT INTO nod_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","เชลาห์​เป๋น​ลูก​ของ​ไคนาน ไคนาน​เป๋น​ลูก​ของ​อารฟาซัด อารฟาซัด​เป๋น​ลูก​ของ​เชม เชม​เป๋น​ลูก​ของ​โนอาห์ โนอาห์​เป๋น​ลูก​ของ​ลาเมค ");
INSERT INTO nod_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ลาเมค​เป๋น​ลูก​ของ​เมธูเสลาห์ เมธูเสลาห์​เป๋น​ลูก​ของ​เอโนค เอโนค​เป๋น​ลูก​ของ​ยาเรด ยาเรด​เป๋น​ลูก​ของ​มาหะลาเลเอล มาหะลาเลเอล​เป๋น​ลูก​ของ​ไคนาน ");
INSERT INTO nod_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ไคนาน​เป๋น​ลูก​ของ​เอโนช เอโนช​เป๋น​ลูก​ของ​เสท เสท​เป๋น​ลูก​ของ​อาดัม อาดัม​เป๋น​ลูก​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","พระวิญญาณ​บริสุทธิ์​อยู่​กับ​พระเยซู แล้ว​พระองค์​ออก​ไป​จาก​แม่น้ำ​จอร์แดน​พระวิญญาณ​ก็​ปา​พระองค์​ไป​ใน​ดินแดน​ทุรกั๋นดาร ");
INSERT INTO nod_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ตี้​หั้น​มาร​ก็​ลองใจ๋​พระองค์​เป๋น​เวลา​สี่​สิบ​วัน ตลอด​เวลา​นั้น​พระองค์​บ่﻿ได้​กิ๋น​อะหยัง​เลย แล้ว​หลังจาก​นั้น​พระองค์​ก็​ใค่​อยาก​กิ๋น​ข้าว ");
INSERT INTO nod_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","มาร​จึง​อู้​กับ​พระองค์​ว่า “ถ้า​ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า ก็​หื้อ​สั่ง​บ่าหิน​ก้อน​นี้​เป๋น​เข้าหนมปัง​แล่” ");
INSERT INTO nod_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","พระเยซู​ก็​ตอบ​มาร​ว่า “พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘คน​เฮา​จะ​เลี้ยง​จีวิต​ด้วย​อาหาร​อย่าง​เดียว​บ่﻿ได้’ ” ");
INSERT INTO nod_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","แล้ว​มาร​ก็​ปา​พระเยซู​ไป​ตี้​สูง หื้อ​พระองค์​ผ่อ​อาณาจักร​ตึงหมด​ใน​โลก​นี้​ก้า​มาบ​เดียว แล้ว​บอก​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“สิทธิ​อำนาจ​กับ​ความ​รุ่งเรือง​ของ​อาณาจักร​ตึงหมด​นี้​เฮา​จะ​ยก​หื้อ​ต้าน ย้อน​ว่า​ตึงหมด​นี้​ได้​มอบ​ไว้​เป๋น​สิทธิ์​ของ​เฮา​แล้ว เฮา​ใค่​ยก​หื้อ​ใผ​ก็​ได้​ต๋าม​ใจ๋​เฮา ");
INSERT INTO nod_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ถ้า​ต้าน​นมัสก๋าน​เฮา กู้​สิ่ง​กู้​อย่าง​นี้​ก็​จะ​เป๋น​ของ​ต้าน” ");
INSERT INTO nod_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","พระเยซู​ตอบ​มาร​ว่า “พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘หื้อ​นมัสก๋าน​องค์​พระผู้เป๋นเจ้า​พระเจ้า​ของ​เจ้า กับ​ฮับใจ๊​พระองค์​ผู้​เดียว​เต้าอั้น’ ” ");
INSERT INTO nod_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","แล้ว​มาร​ก็​ปา​พระเยซู​ไป​กรุง​เยรูซาเล็ม ปา​ขึ้น​ไป​อยู่​บน​หลังคา​พระวิหาร แล้ว​บอก​พระองค์​ว่า “ถ้า​ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า​แต๊﻿ๆ ก็​หื้อ​โดด​ลง​ไป​แล่ ");
INSERT INTO nod_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ย้อน​พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘พระเจ้า​จะ​สั่ง​หื้อ​ทูตสวรรค์​มา​ปกปัก​ฮักษา​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","เอา​มือ​ฮับ​ต้าน​ไว้​บ่﻿หื้อ​ตี๋น​ไป​ตุ๊บ​ใส่​บ่าหิน’ ” ");
INSERT INTO nod_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","พระเยซู​ตอบ​มาร​ว่า “พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘ห้าม​ลองดี​องค์​พระผู้เป๋นเจ้า​พระเจ้า​ของ​เจ้า’ ” ");
INSERT INTO nod_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","เมื่อ​มาร​ลองใจ๋​พระองค์​กู้​อย่าง​แล้ว ก็​ละ​พระองค์​ไว้​จ๋น​กว่า​จะ​มี​โอกาส​เหมาะ﻿ๆ แหม ");
INSERT INTO nod_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","พระเยซู​ปิ๊ก​ไป​แคว้น​กาลิลี​โดย​อำนาจ​พระวิญญาณ​บริสุทธิ์ กับ​มี​คน​เล่า​เรื่อง​เกี่ยวกับ​พระองค์​จ๋น​ใคว่​ต๋ำ​หมู่​หั้น ");
INSERT INTO nod_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","พระองค์​สั่ง​สอน​ใน​ธรรมศาลา​ของ​จาว​ยิว คน​ตังหลาย​ก็​ปา​กั๋น​ยกย่อง​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","แล้ว​พระองค์​ก็​มา​แผว​เมือง​นาซาเร็ธ เป๋น​เมือง​ตี้​พระองค์​ใหญ่ ใน​วัน​สะบาโต​พระองค์​ไป​ธรรมศาลา​ของ​จาว​ยิว​เหมือน​กู้​เตื้อ แล้ว​ยืน​ขึ้น​จะ​อ่าน​พระคัมภีร์ ");
INSERT INTO nod_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","มี​คน​ส่ง​ม้วน​พระธรรม​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​หื้อ​พระองค์ เมื่อ​พระองค์​ก๋าง​พระคัมภีร์​นั้น​ออก ก็​ปะ​ข้อ​ตี้​เขียน​ไว้​ว่า ");
INSERT INTO nod_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“พระวิญญาณ​ของ​องค์​พระผู้เป๋นเจ้า​อยู่​กับ​ข้าพเจ้า ย้อน​ว่า​พระองค์​ได้​ตั้ง​ข้าพเจ้า​ไว้ หื้อ​บอก​ข่าวดี​แก่​คน​ตุ๊ก พระองค์​ใจ๊​ข้าพเจ้า​หื้อ​บอก​นักโต้ษ​ว่า​เขา​จะ​มี​อิสระ หื้อ​บอก​คน​ต๋าบอด​ว่า​เขา​จะ​หัน​แหม หื้อ​บอก​คน​ตี้​โดน​ค่ำ​ว่า​จะ​ป๊น​ตุ๊ก ");
INSERT INTO nod_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","กับ​หื้อ​บอก​ว่า​เถิง​เวลา​แล้ว ตี้​พระเจ้า​จะ​จ้วย​คน​ของ​พระองค์” ");
INSERT INTO nod_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","เมื่อ​อ่าน​หื้อ​คน​ตังหลาย​ฟัง​แล้ว พระองค์​ก็​ม้วน​พระคัมภีร์​นั้น​ส่ง​คืน​เจ้าหน้าตี้ แล้ว​นั่ง​ลง สายต๋า​ของ​คน​ตังหลาย​ใน​ธรรมศาลา​ก็​ผ่อ​มา​ตี้​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","พระองค์​อู้​ว่า “วัน​นี้​พระคัมภีร์​ต๋อน​นี้​ตี้​ต้าน​ได้ยิน​ก็​เป๋น​แต๊​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","คน​ตังหลาย​ก็​อู้​ยกย่อง​พระองค์ และ​ปา​กั๋น​งืด​ใน​กำ​อู้​ตี้​น่า​ฟัง​ของ​พระองค์ หมู่​เขา​อู้​กั๋น​ว่า “คน​นี้​เป๋น​ลูก​บ่าว​โยเซฟ​บ่﻿ใจ้​กา” ");
INSERT INTO nod_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","พระองค์​ก็​อู้​กับ​เขา​ตังหลาย​ว่า “ต้าน​ตังหลาย​คง​จะ​อ้าง​กำ​สุภาษิต​ใส่​เฮา​ตี้​ว่า ‘หมอ​ฮักษา​ตั๋ว​เก่า​ก่อน​เต๊อะ’ กับ​จะ​ว่า ‘สิ่ง​ตี้​ได้ยิน​ว่า​ต้าน​เยียะ​ใน​เมือง​คาเปอรนาอุม หื้อ​เยียะ​ตี้​นี่​ใน​เมือง​ของ​ตั๋ว​พ่อง’ ” ");
INSERT INTO nod_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","พระเยซู​อู้​กับ​หมู่​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า บ่﻿มี​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​สัก​คน​ได้ฮับ​ก๋าน​ยอมฮับ​จาก​คน​ใน​บ้าน​เมือง​ของ​ตั๋ว​เก่า ");
INSERT INTO nod_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","เฮา​บอก​ความ​จริง​แหม​ว่า เมื่อ​ฝน​บ่﻿ตก​สาม​ปี๋​เกิ่ง​จ๋น​เกิด​ก๋าน​กั้นอยาก​ใคว่​แผ่นดิน​ใน​สมัย​ของ​เอลียาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ก็​มี​แม่​หม้าย​ใน​หมู่​จาว​อิสราเอล​จ๋ำนวน​นัก ");
INSERT INTO nod_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","แต่​พระเจ้า​ก็​บ่﻿ใจ๊​เอลียาห์​ไป​หา​แม่​หม้าย​จาว​อิสราเอล​คน​ใด​เลย แต่​หื้อ​ไป​หา​แม่​หม้าย​คน​นึ่ง​เป๋น​คน​ต่างจ้าด​ใน​หมู่​บ้าน​ศาเรฟัท​เขต​เมือง​ไซดอน​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","กับ​ใน​สมัย​เอลีชา​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ก็​เหมือน​กั๋น ใน​หมู่​จาว​อิสราเอล​มี​คน​เป๋น​ขี้ตู้ด​หลาย​คน แต่​บ่﻿มี​ใผ​ได้ฮับ​ก๋าน​ฮักษา​หื้อ​หาย​เลย เว้น​แต่​นาอามาน​จาว​ซีเรีย​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","เมื่อ​คน​ตังหลาย​ใน​ธรรมศาลา​ได้ยิน​จาอั้น​ก็​โขด​ขนาด ");
INSERT INTO nod_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","จึง​ลุก​ขึ้น​ลาก​พระองค์​ออก​จาก​เมือง ปา​ไป​บน​หน้าผา​ตี้​เมือง​ของ​หมู่​เขา​ตั้ง​อยู่​นั้น ตั้งใจ๋​ว่า​จะ​ยู้​พระองค์​หื้อ​ตก​ลง​ไป ");
INSERT INTO nod_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","แต่​พระองค์​เตียว​ลัด​ก๋าง​หมู่​เขา​ไป​ได้ ");
INSERT INTO nod_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","พระเยซู​ไป​เมือง​คาเปอรนาอุม​ใน​แคว้น​กาลิลี แล้ว​เตสนา​สั่ง​สอน​คน​ตังหลาย​ใน​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","คน​ตังหลาย​ก็​ปา​กั๋น​งืด​ใน​กำสอน​ของ​พระองค์ ย้อน​ว่า​พระองค์​สอน​อย่าง​ผู้​มี​สิทธิ​อำนาจ ");
INSERT INTO nod_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ใน​ธรรมศาลา​ของ​จาว​ยิว​มี​ป้อจาย​คน​นึ่ง​โดน​ผี​ฮ้าย​เข้า​อยู่ เขา​ฮ้อง​เสียง​ดัง​ว่า ");
INSERT INTO nod_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“พระเยซู​จาว​นาซาเร็ธ มา​ยุ่ง​กับ​หมู่​เฮา​เยียะ​หยัง ต้าน​มา​ทำลาย​หมู่​เฮา​กา เฮา​ฮู้​ว่า​ต้าน​เป๋น​ใผ ต้าน​เป๋น​ผู้​บริสุทธิ์​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","พระเยซู​จึง​สั่ง​มัน​ว่า “จะ​ไป​ปาก​นัก ออก​มา​จาก​เขา​บ่าเดี่ยว​นี้” ผี​ฮ้าย​นั้น​ก็​เยียะ​หื้อ​คน​นั้น​โก้น​ลง​ต่อ​หน้า​คน​ตังหลาย แล้ว​ก็​ออก​จาก​ป้อจาย​คน​นั้น​ไป โดย​คน​นั้น​บ่﻿ได้ฮับ​บาดเจ็บ ");
INSERT INTO nod_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","คน​ตังหลาย​ก็​ปา​กั๋น​งืด อู้​กั๋น​ว่า “กำ​อู้​ของ​ต้าน​เป๋น​จาใด​หา หยัง​มี​สิทธิ​อำนาจ​สั่ง​หื้อ​ผี​ฮ้าย​ออก มัน​ก็​ยอม​ออก” ");
INSERT INTO nod_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","คน​ก็​เล่า​เรื่อง​ของ​พระองค์​ไป​ใคว่​ต๋ำ​หมู่​หั้น ");
INSERT INTO nod_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","พระเยซู​ออก​จาก​ธรรมศาลา​เข้า​ไป​ใน​เฮือน​ซีโมน แม่​เมีย​ของ​ซีโมน​เป๋น​ไข้​หนัก​ขนาด เขา​ตังหลาย​จึง​อ้อนวอน​พระองค์​หื้อ​จ้วย​นาง ");
INSERT INTO nod_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","พระเยซู​ก็​ไป​ยืน​อยู่​ตัง​ข้าง​ตี้นอน​ของ​นาง อู้​ว่า “ขอ​หื้อ​หาย​ไข้​บ่าเดี่ยว​นี้” แล้ว​นาง​ก็​หาย​จาก​ไข้ สัก​กำเดียว​นาง​ก็​ลุก​ขึ้น​ฮับใจ๊​ผ่อกอย​พระเยซู​กับ​หมู่​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","เมื่อแลง​ใก้​ตะวัน​ตก​ดิน ก็​มี​คน​ปา​คน​เจ็บป่วย​เป๋น​พยาธิ​พะยำ​ต่าง﻿ๆ มา​หา​พระเยซู พระองค์​ก็​วาง​มือ​บน​ตั๋ว​คน​ป่วย​หมู่​นั้น​กู้​คน ฮักษา​หมู่​เขา​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","หมู่​ผี​ฮ้าย​ก็​ออก​จาก​คน​ตี้​โดน​เข้า​ตวย มัน​ฮ้อง​เสียง​ดัง​ว่า “ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า” พระองค์​ก็​ห้าม​บ่﻿หื้อ​หมู่​มัน​อู้ ย้อน​หมู่​มัน​ฮู้​แล้ว​ว่า​พระองค์​เป๋น​พระคริสต์ ");
INSERT INTO nod_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","แจ้ง​เจ๊า​มา​พระเยซู​ออก​ไป​ตี้​สงัด​ดัก​เย็น​ต๋าม​ลำพัง คน​ตังหลาย​ก็​เซาะ​หา​พระองค์ เมื่อ​ปะ​พระองค์​แล้ว ก็​เหนี่ยว​พระองค์​ไว้ บ่﻿หื้อ​จาก​หมู่​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","แต่​พระองค์​บอก​หมู่​เขา​ว่า “เฮา​ต้อง​ไป​บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า​หื้อ​คน​ใน​เมือง​อื่น​ฮู้​ตวย ตี้​เฮา​ฮับใจ๊​มา​นั้น​ก็​เปื้อ​เหตุ​นี้​ละ” ");
INSERT INTO nod_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","พระองค์​จึง​เตสนา​สั่ง​สอน​ใน​ธรรมศาลา​ต่าง﻿ๆ ใน​แคว้น​ยูเดีย ");
INSERT INTO nod_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","มี​เตื้อ​นึ่ง​คน​ตังหลาย​ยืน​เบียด​พระเยซู เปื้อ​จะ​ฟัง​พระเยซู​สั่ง​สอน​ถ้อยกำ​ของ​พระเจ้า ต๋อน​นั้น​พระองค์​ยืน​อยู่​บน​ต๋าฝั่ง​ทะเลสาบ​กาลิลี ");
INSERT INTO nod_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","พระองค์​หัน​เฮือ​อยู่​ฮิม​ฝั่ง​ทะเล​นั้น​สอง​ลำ​ตี้​หมู่​คน​หา​ป๋า​ละ​ไว้​เปื้อ​ไป​ซัก​อวน ");
INSERT INTO nod_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","พระองค์​จึง​ลง​ไป​ใน​เฮือ​ลำ​นึ่ง​เป๋น​ของ​ซีโมน แล้ว​บอก​หื้อ​เขา​ถอย​เฮือ​ออก​จาก​ฝั่ง​ไป​น่อย พระองค์​ก็​นั่ง​อยู่​ใน​เฮือ​นั้น​สั่ง​สอน​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","เมื่อ​สอน​จบ​แล้ว​ก็​บอก​ซีโมน​ว่า “เอา​เฮือ​ออก​ไป​ตี้​น้ำ​เลิ็ก﻿ๆ แล้ว​หย่อน​อวน​ลง​เอา​ป๋า” ");
INSERT INTO nod_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ซีโมน​ตอบ​พระองค์​ว่า “อาจ๋ารย์ หมู่​เฮา​ลาก​อวน​คืน​ฮุ่ง​ยัง​บ่﻿ได้​ป๋า​สัก​ตั๋ว แต่​เฮา​จะ​หย่อน​อวน​ลง​แหม​กำ​ต๋าม​ตี้​พระองค์​บอก” ");
INSERT INTO nod_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","เมื่อ​หย่อน​อวน​ลง​ไป ก็​ยับ​ป๋า​ได้​นัก​ขนาด​จ๋น​อวน​เกือบ​ปุด ");
INSERT INTO nod_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","เขา​จึง​กวั๊ก​เปื้อน​ตี้​อยู่​ใน​เฮือ​แหม​ลำ​นึ่ง​หื้อ​มา​จ้วย​กั๋น เปื้อน​ก็​มา​จ้วย แล้ว​ได้​ป๋า​เต๋ม​เฮือ​สอง​ลำ​จ๋น​เฮือ​เกือบ​จ๋ม ");
INSERT INTO nod_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ซีโมน​เปโตร เมื่อ​หัน​จาอั้น ก็​ก้ม​ลง​กราบ​พระเยซู บอก​พระองค์​ว่า “ขอ​หื้อ​ไป​ไก๋﻿ๆ ข้าพเจ้า​เต๊อะ ย้อน​ว่า​ข้าพเจ้า​เป๋น​คน​บาป” ");
INSERT INTO nod_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ตี้​อู้​จาอั้น ย้อน​ว่า​เขา​กับ​คน​ตังหลาย​ตี้​อยู่​ตวย​กั๋น​หั้น​งืด​ตี้​ได้​ป๋า​นัก​จาอี้ ");
INSERT INTO nod_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ยากอบ​กับ​ยอห์น​ลูก​ของ​เศเบดี เปื้อน​ฮ่วม​หา​ป๋า​ตวย​กั๋น​กับ​ซีโมน​ก็​งืด​เหมือน​กั๋น พระเยซู​อู้​กับ​ซีโมน​ว่า “บ่﻿ถ้า​กั๋ว ตั้งแต่​นี้​ไป​ต้าน​จะ​เป๋น​ผู้​ปา​คน​มา​หา​เฮา” ");
INSERT INTO nod_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","เมื่อ​เอา​เฮือ​เข้า​ฝั่ง​แล้ว หมู่​เขา​ก็​สละ​กู้​อย่าง​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ต๋อน​ตี้​พระองค์​อยู่​ใน​เมือง​นึ่ง มี​คน​เป๋น​ขี้ตู้ด​เต๋ม​ตึง​เนื้อ​ตึง​ตั๋ว เมื่อ​เขา​หัน​พระเยซู​ก็​ก้ม​หน้า​ลง​จ๋น​เถิง​ดิน อ้อนวอน​พระเยซู​ว่า “พระองค์​เจ้า​ข้า ถ้า​พระองค์​ใค่​จ้วย​ข้าพเจ้า​หื้อ​หาย ข้าพเจ้า​ก็​จะ​หาย​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","พระองค์​ยื่น​มือ​ออก​ไป​หยุบ​ป้อจาย​คน​นั้น​แล้ว​อู้​ว่า “เฮา​ใค่​จ้วย จง​หาย​โรค​เต๊อะ” แล้ว​เขา​ก็​หาย​เป๋น​ขี้ตู้ด​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","พระองค์​สั่ง​เขา​ว่า “ห้าม​เล่า​เรื่อง​นี้​หื้อ​ใผ​ฟัง​เน่อ แต่​หื้อ​ไป​แสดง​ตั๋ว​ต่อ​ปุโรหิต แล้ว​เอา​เครื่อง​ปู่จา​สำหรับ​คน​ตี้​หาย​โรค​นี้​ไป​ถวาย​ต๋าม​กำสั่ง​ของ​บท​บัญญัติ​ของ​โมเสส เปื้อ​แสดง​หื้อ​คน​ตังหลาย​ฮู้​ว่า​เจ้า​หาย​โรค​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","มี​คน​เล่า​เรื่อง​ของ​พระเยซู​ไป​ไก๋​แหม คน​ตังหลาย​จ๋ำนวน​นัก​ก็​มา​จุมนุม​กั๋น เปื้อ​จะ​ฟัง​พระองค์​กับ​หื้อ​พระองค์​ฮักษา​โรค​ต่าง﻿ๆ ของ​เขา​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","แต่​พระองค์​ก็​ลัก​ไป​หา​ตี้​เงียบ﻿ๆ เปื้อ​อธิษฐาน​เป๋น​ประจ๋ำ ");
INSERT INTO nod_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","วัน​นึ่ง​เมื่อ​พระองค์​ก่ำลัง​สั่ง​สอน​อยู่ ก็​มี​หมู่​ฟาริสี​กับ​หมู่​ธรรมาจ๋ารย์​นั่ง​ฟัง​อยู่​ตี้​หั้น​ตวย หมู่​เขา​มา​จาก​กู้​หมู่​บ้าน​ใน​แคว้น​กาลิลี แคว้น​ยูเดีย​กับ​กรุง​เยรูซาเล็ม กับ​พระเจ้า​ได้​หื้อ​ฤทธิ์​อำนาจ​กับ​พระเยซู​ตี้​ฮักษา​โรค​ต่าง﻿ๆ หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","มี​คน​หาม​คน​ง่อย​คน​นึ่ง​นอน​อยู่​ตี้นอน​มา หมู่​เขา​ฮิ​จะ​เอา​คน​ป่วย​เข้า​ไป​วาง​ลง​ตังหน้า​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ก็​บ่﻿มี​ฮ่อม​ตี้​จะ​เอา​คน​ป่วย​เข้า​ไป​ได้​ย้อน​มี​คน​นัก เขา​ก็​หาม​ขึ้น​ไป​ตัง​หลังคา เต​หลังคา​ออก​เป๋น​ฮ่อม หย่อน​คน​ป่วย​ตึง​ตี้นอน​ลง​ก๋าง​หมู่​ส่อง​หน้า​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","เมื่อ​พระเยซู​หัน​ความ​เจื้อ​ของ​หมู่​เขา ก็​อู้​กับ​คน​ง่อย​ว่า “เปื้อน​เหย บาป​ของ​เจ้า​ได้​โผด​ยก​หื้อ​แล้ว​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี​กึ๊ด​ใน​ใจ๋​ว่า “คน​นี้​เป๋น​ใผ ตี้​อู้​หมิ่น​ประมาท​พระเจ้า ใผ​จะ​ยก​โต้ษ​บาป​ได้​นอก​จาก​พระเจ้า​องค์​เดียว​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","พระเยซู​ฮู้​กำกึ๊ด​ใน​ใจ๋​ของ​หมู่​เขา ก็​ถาม​ว่า “เป๋น​จาใด​หมู่​ต้าน​กึ๊ด​ใน​ใจ๋​จาอี้ ");
INSERT INTO nod_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","อัน​ใด​จะ​ง่าย​เหลือ​กั๋น​ตี้​จะ​ว่า ‘บาป​ของ​เจ้า​ได้​โผด​ยก​แล้ว’ กับ​จะ​ว่า ‘ลุก​ขึ้น​เตียว​ไป​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","แต่​เปื้อ​ต้าน​ตังหลาย​จะ​ฮู้​ว่า​บุตรมนุษย์​มี​สิทธิ​อำนาจ​ใน​โลก​ตี้​จะ​โผด​ยก​โต้ษ​บาป​ได้” แล้ว​พระองค์​ก็​อู้​กับ​คน​ง่อย​นั้น​ว่า “เฮา​สั่ง​เจ้า​หื้อ​ลุก​ขึ้น​แบก​ตี้นอน​ปิ๊ก​ไป​บ้าน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","เขา​ก็​ลุก​ขึ้น​ต่อ​หน้า​คน​ตังหลาย​บ่า​เดี่ยว​นั้น​เลย แบก​ตี้นอน​ขึ้น แล้ว​เตียว​ปิ๊ก​บ้าน​สรรเสริญ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","คน​ตังหลาย​ปา​กั๋น​งืด​ขนาด ปา​กั๋น​สรรเสริญ​พระเจ้า ต่าง​คน​ต่าง​เก๋งกั๋ว อู้​กั๋น​ว่า “วัน​นี้​เฮา​ได้​หัน​สิ่ง​ตี้​อัศจ๋รรย์​ตี้​สุด” ");
INSERT INTO nod_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","เมื่อ​เหตุก๋ารณ์​นี้​ผ่าน​ไป​แล้ว พระเยซู​ออก​ไป แล้ว​หัน​ใส่​คน​เก็บ​ภาษี​คน​นึ่ง​จื้อ​ว่า​เลวี​นั่ง​อยู่​ตี้​ด่าน​เก็บ​ภาษี พระองค์​อู้​กับ​เขา​ว่า “ตวย​เฮา​มา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","เขา​ก็​สละ​กู้​สิ่ง​กู้​อย่าง​ไว้​หั้น ลุก​ขึ้น​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","เลวี​จัด​งาน​เลี้ยง​ใหญ่​ตี้​บ้าน​ของ​เขา เปื้อ​เป๋น​เกียรติ​แก่​พระเยซู มี​คน​เก็บ​ภาษี​กับ​คน​อื่น​แหม​หลาย​คน​นั่ง​ฮ่วม​โต๊ะ​ตวย​หมู่​สาวก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","หมู่​ฟาริสี​กับ​หมู่​ธรรมาจ๋ารย์​ตี้​อยู่​ใน​หมู่​ของ​เขา​ซูบซาบ​กั๋น ติ​หมู่​สาวก​ของ​พระเยซู​ว่า เป๋น​จาใด​หมู่​ต้าน​มา​กิ๋น​มา​ดื่ม​กับ​หมู่​คน​เก็บ​ภาษี​กับ​หมู่​คน​บาป ");
INSERT INTO nod_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","พระเยซู​ตอบ​หมู่​เขา​ว่า “คน​อยู่​ดี​สบาย​แข็งแฮง​บ่﻿ต้องก๋าน​หมอ แต่​คน​ตี้​บ่﻿สบาย​ต้องก๋าน​หมอ ");
INSERT INTO nod_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","เฮา​บ่﻿ได้​มา​เปื้อ​ฮ้อง​หา​คน​ตี้​กึ๊ด​ว่า​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม แต่​มา​เปื้อ​ฮ้อง​หา​คน​บาป​หื้อ​กลับใจ๋​ใหม่” ");
INSERT INTO nod_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","หมู่​เขา​บอก​พระเยซู​ว่า “หมู่​สาวก​ของ​ยอห์น​ผู้​หื้อ​บัพติศมา​ถือ​ศีล​อด​อาหาร​กับ​อธิษฐาน​อยู่​เจื่อ﻿ๆ สาวก​ของ​หมู่​ฟาริสี​ก็​ถือ​เหมือน​กั๋น แต่​สาวก​ของ​ต้าน​เอา​ตึง​กิ๋น​ตึง​ดื่ม” ");
INSERT INTO nod_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","พระเยซู​อู้​กับ​หมู่​เขา​ว่า “หมู่​ต้าน​จะ​หื้อ​เปื้อน​ของ​เจ้าบ่าว​ถือ​ศีล​อด​อาหาร​เมื่อ​เจ้าบ่าว​ยัง​อยู่​กับ​เขา​กา ");
INSERT INTO nod_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","แต่​จะ​มี​วัน​นึ่ง​เจ้าบ่าว​จะ​ถูก​เอา​ไป​จาก​หมู่​เขา วัน​นั้น​หมู่​เขา​จะ​ถือ​ศีล​อด​อาหาร” ");
INSERT INTO nod_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","พระเยซู​ได้​อู้​กำเผียบ​ข้อ​นึ่ง​หื้อ​หมู่​เขา​ฟัง​ว่า “บ่﻿มี​ใผ​เอา​ผ้า​จาก​เสื้อ​ใหม่​มา​ปะ​เสื้อ​เก่า ถ้า​เยียะ​จาอั้น​เสื้อ​ใหม่​ก็​จะ​ปุด ป๋าย​บ่﻿ปอ​ผ้า​จาก​เสื้อ​ใหม่​ก็​บ่﻿เปิง​กับ​เสื้อ​เก่า​ตวย ");
INSERT INTO nod_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","บ่﻿มี​ใผ​เอา​เหล้า​องุ่น​หมัก​ใหม่﻿ๆ ใส่​ถง​หนัง​เก่า ย้อน​ว่า​ถ้า​เยียะ​จาอั้น​เหล้า​องุ่น​ตี้​หมัก​ใหม่​นั้น จะ​เยียะ​หื้อ​ถง​หนัง​เก่า​แตก เหล้าองุ่น​ก็​ฮั่ว​ออก​มา​หมด ถง​หนัง​ก็​จะ​ปุด​จะ​หวาก ถง​หนัง​ก็​จะ​ใจ๊​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","เหล้า​องุ่น​หมัก​ใหม่﻿ๆ ต้อง​ใส่​ถง​หนัง​ใหม่ ");
INSERT INTO nod_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","บ่﻿มี​ใผ​กิ๋น​เหล้า​องุ่น​เก่า แล้ว​จะ​ใค่​กิ๋น​เหล้า​องุ่น​ใหม่﻿ๆ เขา​ย่อม​บอก​ว่า ‘ของ​เก่า​นั้น​ดี​แล้ว’ ” ");
INSERT INTO nod_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ใน​วัน​สะบาโต​วัน​นึ่ง พระเยซู​ก่ำลัง​เตียว​ลัด​ก๋าง​โต้ง หมู่​สาวก​ของ​พระองค์​ก็​เด็ด​งวงข้าว​มา​เก็ด​กิ๋น​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","บาง​คน​ใน​หมู่​ฟาริสี​ถาม​ว่า “เป๋น​จาใด​หมู่​ต้าน​เยียะ​ใน​สิ่ง​ตี้​ห้าม​เยียะ​ใน​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","พระเยซู​จึง​ตอบ​เขา​ว่า “หมู่​ต้าน​บ่﻿เกย​อ่าน​พระคัมภีร์​เรื่อง​ตี้​กษัตริย์​ดาวิด​เยียะ​เมื่อ​ต้าน​กับ​หมู่​ตี้​มา​ตวย​ใค่​อยาก​กิ๋น​ข้าว​กา ");
INSERT INTO nod_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ต้าน​เข้า​ไป​ใน​พระวิหาร​ของ​พระเจ้า แล้ว​กิ๋น​เข้าหนมปัง​ตี้​ตั้ง​ถวาย​พระเจ้า แล้ว​ยัง​เอา​หื้อ​หมู่​คน​ตี้​มา​ตวย​กั๋น​กิ๋น​ตวย เซิ่ง​ต๋าม​กฎ​ห้าม​บ่﻿หื้อ​ใผ​กิ๋น​นอก​จาก​ปุโรหิต​เต้าอั้น​ตี้​กิ๋น​ได้” ");
INSERT INTO nod_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","พระองค์​จึง​บอก​หมู่​ฟาริสี​ว่า “เฮา​ผู้​เป๋น​บุตรมนุษย์​เป๋น​ใหญ่​เหลือ​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ใน​วัน​สะบาโต​แหม​วัน​นึ่ง พระเยซู​เข้า​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว​แล้ว​สั่ง​สอน มี​คน​นึ่ง​มือ​ขวา​ลีบ​ได้​เข้า​ไป​ฟัง​ตวย ");
INSERT INTO nod_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี​ก็​ปา​กั๋น​ถ้า​ผ่อ​ว่า พระองค์​จะ​ฮักษา​เขา​ใน​วัน​สะบาโต​ก่อ เปื้อ​จะ​หา​เหตุ​นาบ​โต้ษ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","แต่​พระองค์​ฮู้​ว่า​เขา​กึ๊ด​จาใด จึง​อู้​กับ​คน​มือ​ลีบ​คน​นั้น​ว่า “ลุก​ยืน​ขึ้น​ส่อง​หน้า​คน​ตังหลาย” เขา​ก็​ลุก​ยืน​ขึ้น ");
INSERT INTO nod_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","แล้ว​พระเยซู​ก็​อู้​กับ​คน​ตังหลาย​ว่า “เฮา​จะ​ถาม​ต้าน​ตังหลาย​ว่า ควร​จะ​เยียะ​ก๋าน​ดี​กาว่า​เยียะ​ก๋าน​ฮ้าย​ใน​วัน​สะบาโต จะ​จ้วย​จีวิต​กาว่า​จะ​ทำลาย​จีวิต” ");
INSERT INTO nod_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","แล้ว​พระองค์​ผ่อ​ไป​ตี้​กู้​คน​ตี้​อยู่​หั้น บอก​คน​มือ​ลีบ​ว่า “เหยียด​มือ​ของ​เจ้า​ออก​มา” เขา​ก็​เยียะ​ตวย​ต๋าม แล้ว​มือ​ของ​เขา​ก็​หาย​เป๋น​ปกติ ");
INSERT INTO nod_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","หมู่​ฟาริสี​กับ​หมู่​ธรรมาจ๋ารย์​ก็​โขด​หื้อ​พระเยซู จึง​เปิ็กษา​กั๋น​ว่า​จะ​เยียะ​จาใด​กับ​พระองค์​ดี ");
INSERT INTO nod_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ต๋อน​นั้น​พระเยซู​ขึ้น​ไป​บน​ดอย​ม่อน​นึ่ง​เปื้อ​อธิษฐาน แล้ว​ได้​อธิษฐาน​ต่อ​พระเจ้า​คืน​ฮุ่ง ");
INSERT INTO nod_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","แจ้ง​แล้ว​พระองค์​ก็​ฮ้อง​หมู่​สาวก​มา​หา แล้ว​เลือก​เอา​สิบ​สอง​คน​ออก​จาก​หมู่​สาวก​นั้น แล้ว​ฮ้อง​หมู่​เขา​ว่า​หมู่​อัคร​สาวก ");
INSERT INTO nod_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","คือ​ซีโมน​ตี้​พระองค์​ฮ้อง​แหม​จื้อ​ว่า เปโตร อันดรูว์​น้องบ่าว​ของ​เปโตร ยากอบ ยอห์น ฟีลิป บารโธโลมิว ");
INSERT INTO nod_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","มัทธิว​โธมัส ยากอบ​ลูกบ่าว​ของ​อัลเฟอัส ซีโมน ตี้​เป๋น​คน​ของ​พรรค​จ้าดนิยม ");
INSERT INTO nod_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ยูดาส​ลูกบ่าว​ของ​ยากอบ กับ​ยูดาส อิสคาริโอท​ต๋อน​เมื่อ​ลูน​คน​นี้​ได้​หักหลัง​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","แล้ว​พระเยซู​กับ​หมู่​อัคร​สาวก​ก็​ลง​มา​ยืน​ใน​ตี้​เปียง​แห่ง​นึ่ง พร้อม​ตึง​หมู่​สาวก​ของ​พระองค์​กับ​แหม​หลาย​คน​ตี้​มา​จาก​ใคว่​แคว้น​ยูเดีย กรุง​เยรูซาเล็ม กับ​เมือง​ต่าง﻿ๆ ฮิม​ฝั่ง​ทะเล​คือ​เมือง​ไทระ​กับ​เมือง​ไซดอน เปื้อ​จะ​ฟัง​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","กับ​หื้อ​พระองค์​ฮักษา​โรค​ของ​หมู่​เขา หมู่​คน​ตี้​ต้อง​ทน​ตุ๊ก​ย้อน​ผี​ฮ้าย​เข้า พระเยซู​ก็​ฮักษา​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","คน​ตังหลาย​ต่าง​คน​ก็​ต่าง​พยายาม​ตี้​จะ​ถูก​ตั๋ว​พระเยซู ย้อน​มี​ฤทธิ์​ซ่าน​ออก​จาก​พระองค์​ฮักษา​โรค​ของ​หมู่​เขา​หื้อ​หาย​กู้​คน ");
INSERT INTO nod_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","พระเยซู​ผ่อ​หน้า​หมู่​สาวก​ของ​พระองค์ อู้​กับ​หมู่​เขา​ว่า “หมู่​ต้าน​ตี้​ตุ๊กยาก พระเจ้า​โผด​หื้อ​หมู่​ต้าน​เป๋น​สุข ย้อน​ว่า​หมู่​ต้าน​ได้​เป๋น​คน​ของ​แผ่นดิน​ของ​พระเจ้า​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","หมู่​ต้าน​ตี้​กั้น​อยาก​ใน​เวลา​นี้ พระเจ้า​โผด​หื้อ​หมู่​ต้าน​เป๋น​สุข ย้อน​ว่า​หมู่​ต้าน​จะ​ได้​กิ๋น​อิ่ม หมู่​ต้าน​ตี้​ฮ้อง​ไห้​อยู่​ใน​เวลา​นี้ พระเจ้า​โผด​หื้อ​หมู่​ต้าน​เป๋น​สุข ย้อน​ว่า​หมู่​ต้าน​จะ​ได้​ใค่​หัว ");
INSERT INTO nod_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","พระเจ้า​โผด​หื้อ​หมู่​ต้าน​เป๋น​สุข เมื่อ​คน​ตังหลาย​จัง​หมู่​ต้าน ไล่​หมู่​ต้าน​ออก​จาก​หมู่​เขา ดู​ถูก​ดู​แควน​หมู่​ต้าน ว่า​หมู่​ต้าน​เป๋น​คน​บ่﻿ดี ย้อน​หมู่​ต้าน​หัน​แก่​เฮา​ผู้​เป๋น​บุตรมนุษย์ ");
INSERT INTO nod_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","เมื่อ​เกิด​จาอั้น​ขึ้น ต้าน​ตังหลาย​จง​จื้นจม​ยินดี​วิด﻿ๆ เต้น﻿ๆ เต๊อะ ย้อน​ว่า​พระเจ้า​มี​รางวัล​อัน​ยิ่งใหญ่​ไว้​ใน​สวรรค์​สำหรับ​หมู่​ต้าน เซิ่ง​ก็​เหมือน​เดียว​กั๋น​กับ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตี้​โดน​ป้ออุ๊ย​แม่หม่อน​เยียะ​อย่าง​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","แต่​ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​เจ้า​ตังหลาย​ตี้​ร่ำรวย ย้อน​ว่า​เจ้า​ได้​ฮับ​ความ​สุข​สบาย​ตี้​สุด​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ความ​ฉิบหาย​ก็​เกิด​กับ​เจ้า​ตังหลาย​ตี้​ได้​กิ๋น​อิ่ม​เวลา​นี้ ย้อน​ว่า​เจ้า​จะ​กั้น​อยาก ความ​ฉิบหาย​ก็​เกิด​กับ​เจ้า​ตังหลาย​ตี้​ใค่หัว​เวลา​นี้ ย้อน​ว่า​เจ้า​จะ​โศกเศร้า​เสียใจ๋ ");
INSERT INTO nod_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ความ​ฉิบหาย​ก็​เกิด​กับ​เจ้า​ตังหลาย​ตี้​หมู่​คน​ยกย่อง​ว่า​เจ้า​เป๋น​คน​ดี ย้อน​ว่า​ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​เขา​ก็​ได้​เยียะ​อย่าง​เดียว​กั๋น​นี้​กับ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตั๋ว​ป๋อม​มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“แต่​เฮา​บอก​หื้อ​ต้าน​ตังหลาย​ตี้​ก่ำลัง​ฟัง​อยู่​ว่า จง​ฮัก​ศัตรู๋​ของ​ต้าน จง​เยียะ​ดี​กับ​คน​ตี้​จัง​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","จง​ปั๋น​ปอน​คน​ตี้​แจ้งด่า​ต้าน จง​อธิษฐาน​เผื่อ​คน​ตี้​เยียะ​ฮ้าย​ต่อ​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ถ้า​ใผ​คน​ใด​ตบ​แก้ม​ของ​ต้าน​เผิก​นึ่ง ก็​หื้อ​บิ่น​แหม​เผิก​นึ่ง​หื้อ​เขา​แหม ใผ​เอา​เสื้อ​คุม​ต้าน​ไป ถ้า​เขา​จะ​เอา​เสื้อ​แหม​ก็​หื้อ​เขา​ไป​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ถ้า​ใผ​มา​ขอ​อะหยัง​จาก​ต้าน ก็​หื้อ​เขา​ไป​เต๊อะ กับ​เมื่อ​ใผ​เอา​อะหยัง​ของ​ต้าน​ไป ก็​บ่﻿ถ้า​ทวง​คืน ");
INSERT INTO nod_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","หื้อ​เยียะ​ต่อ​คน​อื่น อย่าง​ตี้​ต้าน​ต้องก๋าน​หื้อ​คน​อื่น​เยียะ​ต่อ​ต้าน​จาอั้น ");
INSERT INTO nod_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ถ้า​ต้าน​ตังหลาย​ฮัก​ก้า​คน​ตี้​ฮัก​ต้าน​เต้าอั้น จะ​ได้​บุญคุณ​อะหยัง คน​บ่﻿ดี​คน​บาป​ตังหลาย ก็​ฮัก​คน​ตี้​ฮัก​เขา​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ถ้า​ต้าน​เยียะ​ดี​กับ​คน​ตี้​เยียะ​ดี​กับ​ต้าน​เต้าอั้น จะ​บุญคุณ​อะหยัง คน​บาป​ตังหลาย​ก็​เยียะ​อย่าง​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ถ้า​ต้าน​ตังหลาย​หื้อ​ยืม​ก้า​คน​ตี้​ต้าน​ฮู้​ว่า​จะ​ได้​คืน​เต้าอั้น จะ​ได้​บุญคุณ​อะหยัง คน​บาป​ตังหลาย​ก็​หื้อ​คน​บาป​ยืม​โดย​คาด​ว่า​จะ​ฮับ​คืน​อย่าง​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","แต่​จง​ฮัก​ศัตรู๋​ของ​ต้าน​ตังหลาย กับ​เยียะ​ดี​กับ​เขา จง​หื้อ​เขา​ยืม​ไป​โดย​บ่﻿ต้อง​ห่วง​ว่า​จะ​ได้​คืน แล้ว​ต้าน​จะ​ได้​ฮับ​รางวัล​ยิ่งใหญ่​ใน​สวรรค์ จะ​ได้​เป๋น​ลูก​ของ​พระเจ้า​ผู้​สูงสุด ย้อน​พระองค์​โผด​ตึง​คน​ตี้​อกตัญญู ตึง​คน​บ่﻿ดี ");
INSERT INTO nod_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ต้าน​ตังหลาย​จง​มี​ความ​เมตต๋า​กรุณา เหมือน​พระบิดา​ของ​ต้าน​มี​ความ​เมตต๋า​กรุณา ");
INSERT INTO nod_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“บ่﻿ดี​ตัดสิน​ใผ แล้ว​เขา​ก็​จะ​บ่﻿ตัดสิน​ต้าน บ่﻿ถ้า​ตัดสิน​ลงโต้ษ​ใผ แล้ว​เขา​ก็​จะ​บ่﻿ตัดสิน​ลงโต้ษ​ต้าน จง​ยกโต้ษ​หื้อ​เขา แล้ว​เขา​ก็​จะ​ยกโต้ษ​หื้อ​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","จง​หื้อ​กับ​คน​อื่น แล้ว​พระเจ้า​ก็​จะ​หื้อ​กับ​ต้าน ต้าน​จะ​ได้​ฮับ​ตวง​จ๋นสวดจ๋นล้น​ต๋าง ย้อน​ว่า​ต้าน​ใจ๊​ต๋าง​แก่น​ใด​ตวง​หื้อ​คน​อื่น พระเจ้า​ก็​จะ​ใจ๊​ต๋าง​แก่น​นั้น​ตวง​หื้อ​ต้าน​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","พระเยซู​อู้​กับ​หมู่​เขา​เป๋น​กำเผียบ​ว่า “คน​ต๋าบอด​จู๋ง​คน​ต๋าบอด​ได้​กา ตึง​สอง​คน​จะ​บ่﻿ตก​ขุม​ตก​บ่อ​กา ");
INSERT INTO nod_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ลูกศิษย์​บ่﻿ใหญ่​เหลือ​ครู แต่​ลูกศิษย์​ตี้​ฮับ​ก๋าน​เฝิ็ก​สอน​จบ​แล้ว​ก็​จะ​เป๋น​เหมือน​ครู​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“เป๋น​จาใด​ต้าน​ผ่อ​หัน​ขี้ฝุ่น​ตี้​อยู่​ใน​ต๋า​ปี้น้อง​ของ​ต้าน แต่​ไม้​ตึง​ดุ้น​อยู่​ใน​ต๋า​ตั๋ว​เก่า​ผ่อ​บ่﻿หัน ");
INSERT INTO nod_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","เป๋น​จาใด​ต้าน​อู้​กับ​หมู่​ปี้น้อง​ของ​ต้าน​ว่า ‘น้อง​เหย หื้อ​เฮา​เขี่ย​ขี้ฝุ่น​ออก​จาก​ต๋า​ของ​เจ้า​เนาะ’ แต่​ตี้​ไหน​ได้​มี​ไม้​ตึง​ดุ้น​อยู่​ใน​ต๋า​ตั๋ว​เก่า​ก็​บ่﻿หัน คน​หน้า​ซื่อ​ใจ๋​ก๊ด หื้อ​จั๊ก​ไม้​ดุ้น​ออก​จาก​ต๋า​ตั๋ว​เก่า​เหีย​ก่อน แล้ว​จะ​ได้​ผ่อ​หัน​ถี่﻿ๆ ก่อน​ตี้​จะ​ไป​เขี่ย​ขี้ฝุ่น​ออก​จาก​ต๋า​ของ​ปี้น้อง​ได้ ");
INSERT INTO nod_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“เก๊าไม้​ดี​ก็​ออก​หน่วย​ดี เก๊าไม้​บ่﻿ดี​ก็​ออก​หน่วย​บ่﻿ดี ");
INSERT INTO nod_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","เฮา​จะ​ฮู้​ว่า​เก๊าไม้​ดี​กาว่า​บ่﻿ดี ก็​ผ่อ​ตี้​หน่วย​ของ​มัน บ่﻿มี​ใผ​เกย​เก็บ​หน่วย​บ่าเดื่อ​จาก​เก๊าไม้​ตี้​มี​หนาม กาว่า​เก็บ​องุ่น​จาก​เก๊า​หญ้า​ตี้​มี​หนาม ");
INSERT INTO nod_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","คน​ดี​ก็​มี​สิ่ง​ดี﻿ๆ ใน​ใจ๋​แล้ว​ก็​จะ​อู้​แต่​สิ่ง​ดี​ออก​มา แต่​คน​บ่﻿ดี​ก็​มี​สิ่ง​บ่﻿ดี​ใน​ใจ๋​กับ​จะ​อู้​สิ่ง​บ่﻿ดี​ออก​มา​เหมือน​กั๋น ย้อน​ใน​ใจ๋​เป๋น​จาใด​ปาก​ก็​อู้​มา​จาอั้น ");
INSERT INTO nod_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“เป๋น​จาใด​ต้าน​ตังหลาย​ฮ้อง​เฮา​ว่า องค์​พระผู้เป๋นเจ้า แต่​หมู่​ต้าน​ก็​บ่﻿เยียะ​ต๋าม​ตี้​เฮา​สอน​นั้น ");
INSERT INTO nod_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","กู้​คน​ตี้​มา​หา​เฮา​กับ​ฟัง​กำ​สอน​ของ​เฮา แล้ว​เยียะ​ตวย​ต๋าม​กำ​สอน​นั้น เฮา​จะ​บอก​หื้อ​ต้าน​ตังหลาย​ฮู้​ว่า​เขา​เผียบ​เหมือน​ใผ ");
INSERT INTO nod_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","เขา​เผียบ​เหมือน​คน​ตี้​แป๋ง​เฮือน เขา​ขุด​ขุม​เลิ็ก​วาง​ฐาน​ไว้​บน​บ่าหิน เมื่อ​น้ำ​ท่วม สาย​น้ำ​เจี้ยว​ตั้ง​ใส่​เฮือน​นั้น เฮือน​ก็​บ่﻿ไหว​บ่﻿เฟือน ย้อน​ได้​แป๋ง​ไว้​อย่าง​มั่นคง ");
INSERT INTO nod_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","แต่​คน​ตี้​ได้​ฟัง​กำสอน​ของ​เฮา แล้ว​ก็​บ่﻿ได้​เยียะ​ตวย​ต๋าม เขา​ก็​เผียบ​เหมือน​คน​นึ่ง​แป๋ง​เฮือน​บน​ดิน ขุด​ขุม​วาง​ฐาน​ไว้​บ่﻿เลิ็ก เมื่อ​มี​น้ำ​ท่วม สาย​น้ำ​ไหล​แฮง​ตั้ง​ใส่​เฮือน​นั้น เฮือน​นั้น​ก็​จะ​หลุ​จะ​ปัง​ลง​ตันที เสียหาย​หมด” ");
INSERT INTO nod_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","เมื่อ​พระเยซู​อู้​เรื่อง​หมู่​นี้​หื้อ​คน​ตังหลาย​ฟัง​แล้ว พระองค์​ก็​เข้า​ไป​ใน​เมือง​คาเปอรนาอุม ");
INSERT INTO nod_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","มี​คน​ฮับใจ๊​คน​นึ่ง​ของ​นายร้อย​ทหาร​โรมัน บ่﻿สบาย​หนัก​เกือบ​จะ​ต๋าย​แล้ว นายร้อย​ฮัก​คน​นั้น​นัก ");
INSERT INTO nod_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","นายร้อย​ได้​ยิน​ว่า​พระเยซู​มา จึง​หื้อ​หมู่​คน​เฒ่า​คน​แก่​ของ​จาว​ยิว​บาง​คน ไป​อ้อนวอน​ขอ​หื้อ​พระองค์​มา​ฮักษา​คน​ฮับใจ๊​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","เมื่อ​หมู่​คน​เฒ่า​คน​แก่​นั้น​มา​เถิง​พระเยซู​แล้ว ก็​อ้อนวอน​แล้ว​อ้อนวอน​แหม​ว่า “นายร้อย​คน​นั้น​สมควร​ตี้​ต้าน​จะ​จ้วย ");
INSERT INTO nod_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ย้อน​เขา​ฮัก​คน​ใน​จ้าด​ของ​เฮา กับ​เขา​ได้​แป๋ง​ธรรมศาลา​หื้อ​เฮา​ตวย” ");
INSERT INTO nod_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","พระเยซู​จึง​ไป​กับ​หมู่​เขา เมื่อ​ไป​เกือบ​จะ​เถิง​เฮือน​ตี้​นายร้อย​คน​นั้น​อยู่ นายร้อย​ก็​หื้อ​เปื้อน​บาง​คน​ไป​หา​พระองค์ ใจ๊​บอก​ว่า “บ่﻿ถ้า​เข้า​ไป​ใน​เฮือน​เน่อ ย้อน​ข้าพเจ้า​บ่﻿ดี​ปอ​ตี้​จะ​หื้อ​ต้าน​ลอด​เข้า​มา​ใน​จายคา​เฮือน​ของ​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ย้อน​จาอั้น​ข้าพเจ้า​หัน​ว่า​บ่﻿เปิง​ตี้​จะ​ออก​มา​ปะ​ต้าน แต่​ขอ​ต้าน​สั่ง​กำเดียว​เต้าอั้น คน​ฮับใจ๊​ของ​ข้าพเจ้า​ก็​จะ​หาย​จาก​พยาธิ​ตี้​เขา​เป๋น ");
INSERT INTO nod_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ข้าพเจ้า​อยู่​ใต้​วินัย​ของ​ทหาร กับ​มี​ทหาร​อยู่​ใต้​บังคับ​ของ​ข้าพเจ้า​ตวย ข้าพเจ้า​สั่ง​คน​นึ่ง​ว่า ‘ไป’ เขา​ก็​ไป สั่ง​คน​นึ่ง​ว่า ‘มา’ เขา​ก็​มา ข้าพเจ้า​บอก​คน​ฮับใจ๊​ว่า ‘เยียะ​อัน​นี้​เน่อ’ เขา​ก็​เยียะ” ");
INSERT INTO nod_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","เมื่อ​พระเยซู​ได้ยิน​จาอั้น​ก็​งืด​ใน​ความ​เจื้อ​ของ​นายร้อย จึง​เหลียว​ปิ๊ก​มา​อู้​กับ​คน​ตังหลาย​ตี้​ติดต๋าม​พระองค์​ไป​ว่า “เฮา​บอก​หื้อ​ต้าน​ตังหลาย​ฮู้​ว่า เฮา​บ่﻿เกย​ปะ​ใผ​คน​ใด​ใน​ประเทศ​อิสราเอล​ตี้​มี​ความ​เจื้อ​นัก​ขนาด​นี้​มา​ก่อน​เลย” ");
INSERT INTO nod_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","เมื่อ​เปื้อน​ปิ๊ก​ไป​เถิง​เฮือน​นายร้อย ก็​หัน​คน​ฮับใจ๊​คน​นั้น​หาย​เป๋น​ปกติ​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ได้​แหม​บ่﻿ปอ​เมิน พระเยซู​ไป​หมู่​บ้าน​นาอิน​กับ​หมู่​สาวก​ของ​พระองค์ คน​ตังหลาย​แหม​จ้าดนัก​ก็​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","เมื่อ​มา​เถิง​ใก้​ปะตู๋​เมือง​นั้น มี​คน​หาม​ศพ​ป้อจาย​หนุ่ม​คน​นึ่ง​มา แม่​ของ​ป้อจาย​คน​นั้น​เป๋น​หม้าย​มี​ลูก​คน​เดียว จาว​บ้าน​จ้าดหลาย​คน​ก็​มา​ตวย​นาง ");
INSERT INTO nod_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","เมื่อ​พระเยซู​หัน​แม่​ของ​ป้อจาย​คน​นั้น พระองค์​มี​ใจ๋​อินดู​นาง อู้​ว่า “บ่﻿ต้อง​ไห้​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","แล้ว​พระองค์​เข้า​ไป​ใก้﻿ๆ แล้ว​ต๊ะ​แตะ​หาม​ศพ หมู่​ตี้​หาม​ก็​หยุด​ยืน พระองค์​จึง​สั่ง​ว่า “จาย​หนุ่ม​เหย เฮา​สั่ง​เจ้า​หื้อ​ลุก​ขึ้น” ");
INSERT INTO nod_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","คน​ต๋าย​นั้น​ก็​ลุก​ขึ้น​นั่ง​อู้​ได้ พระองค์​จึง​มอบ​จาย​หนุ่ม​คน​นั้น​หื้อ​แม่​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","คน​ตังหลาย​ตี้​ตวย​มา​ก็​เก๋งกั๋ว​กั๋น​ขนาด แล้ว​ปา​กั๋น​สรรเสริญ​พระเจ้า​ว่า “ต้าน​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตี้​ยิ่งใหญ่​ได้​เกิด​ขึ้น​มา​ต้ามก๋าง​หมู่​เฮา​แล้ว กับ​พระเจ้า​ได้​มา​จ้วย​คน​ของ​พระองค์​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","เรื่อง​นี้​ก็​ได้​เล่าลือ​กั๋น​ไป​ใคว่​แคว้น​ยูเดีย กับ​ดินแดน​ตี้​อยู่​แวด​แคว้น​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","หมู่​สาวก​ของ​ยอห์น​ก็​เล่า​เถิง​เหตุก๋ารณ์​ตึง​หมด​นั้น​หื้อ​ยอห์น​ฟัง ");
INSERT INTO nod_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ยอห์น​ฮ้อง​สาวก​สอง​คน​มา​หา สั่ง​หื้อ​ไป​ถาม​พระเยซู​ว่า “ต้าน​เป๋น​ผู้​ตี้​จะ​มา​นั้น​กา กาว่า​จะ​ต้อง​กอง​ถ้า​คน​อื่น​แหม” ");
INSERT INTO nod_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","เมื่อ​หมู่​เขา​มา​เถิง​พระเยซู ก็​บอก​พระองค์​ว่า “ยอห์น​ผู้​หื้อ​บัพติศมา​ใจ๊​หมู่​เฮา​มา​ถาม​พระองค์​ว่า ‘ต้าน​เป๋น​ผู้​ตี้​จะ​มา​นั้น​กา กาว่า​จะ​ต้อง​กอง​ถ้า​คน​อื่น​แหม’ ” ");
INSERT INTO nod_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ใน​เวลา​หละหว่าง​นั้น​พระเยซู​ได้​ฮักษา​คน​เจ็บ​คน​เป๋น​โรค​ต่าง﻿ๆ หื้อ​หาย​เป๋น​จ๋ำนวน​นัก คน​ตี้​ผี​เข้า​ก็​หาย คน​ต๋าบอด​ก็​ผ่อ​หัน​ได้ ");
INSERT INTO nod_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","พระองค์​ตอบ​สาวก​สอง​คน​นั้น​ไป​ว่า “ปิ๊ก​ไป​บอก​ยอห์น​ต๋าม​ตี้​หมู่​ต้าน​ได้​ยิน​กับ​ได้​หัน คือ​คน​ต๋าบอด​ก็​ผ่อ​หัน​ได้ คน​ง่อย​ก็​เตียว​ได้ คน​ขี้ตู้ด​ก็​หาย​สะอาด คน​หู​หนวก​ก็​ได้​ยิน คน​ต๋าย​ก็​เป๋น​ขึ้น​จาก​ความ​ต๋าย คน​ตุ๊ก​คน​ยาก​ก็​ได้​ฟัง​ข่าวดี ");
INSERT INTO nod_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","คน​ตี้​บ่﻿ขัดใจ๋​ใน​สิ่ง​ตี้​เฮา​อู้​กับ​เยียะ ก็​เป๋น​สุข” ");
INSERT INTO nod_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","เมื่อ​คน​ตี้​ยอห์น​ใจ๊​มา​ปิ๊ก​ไป​แล้ว พระองค์​ตั้งเก๊า​อู้​กับ​คน​ตังหลาย​เรื่อง​ยอห์น​ว่า “ต้าน​ตังหลาย​ไป​ผ่อ​อะหยัง​ใน​ดินแดน​ทุรกั๋นดาร ไป​ผ่อ​ต้น​อ้อ​ถูก​ลม​ปั๊ด​แกว่ง​ไป​แกว่ง​มา​จาอั้น​กา ");
INSERT INTO nod_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ถ้า​บ่﻿ใจ้ ออก​ไป​ผ่อ​อะหยัง​กั๋น ไป​ผ่อ​คน​แต่งตั๋ว​งาม﻿ๆ กา ย้อน​ว่า​คน​ตี้​แต่งตั๋ว​อย่าง​ดี​กิ๋น​ดี​อยู่​ดี​ย่อม​ปา​กั๋น​อยู่​ใน​วัง​ปู๊น ");
INSERT INTO nod_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ถ้า​จาอั้น​หมู่​ต้าน​ออก​ไป​ผ่อ​อะหยัง​กั๋น ไป​ผ่อ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​แม่น​ก่อ แม่น​แล้ว เฮา​บอก​ต้าน​ตังหลาย​ว่า​ยอห์น​เป๋น​นัก​เหลือ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​แหม​ก่อน ");
INSERT INTO nod_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","คือ​ยอห์น​คน​เนียะ มี​กำเขียน​เถิง​ต้าน​ไว้​ว่า ‘เฮา​จะ​ส่ง​คน​ส่ง​ข่าว​นำ​หน้า​ต้าน​ไป​ก่อน เขา​จะ​เกียม​คน​หื้อ​พร้อม​ก่อน​ต้าน​มา’ ");
INSERT INTO nod_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","เฮา​บอก​ต้าน​ตังหลาย​ว่า ใน​หมู่​คน​ตี้​เกิด​มา​นั้น​บ่﻿มี​ใผ​ตี้​ยิ่งใหญ่​เหลือ​ยอห์น แต่​คน​เล็ก​หน้อย​ตี้​สุด​ใน​แผ่นดิน​ของ​พระเจ้า ก็​ยัง​ใหญ่​เหลือ​ยอห์น​แหม​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","คน​ตังหลาย​กับ​หมู่​คน​เก็บ​ภาษี​ตี้​ได้ยิน​กับ​ได้ฮับ​บัพติศมา​จาก​ยอห์น​แล้ว ก็​ยอมฮับ​ว่า​พระเจ้า​ยุติธรรม ");
INSERT INTO nod_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","แต่​หมู่​ฟาริสี​กับ​ผู้​ชำนาญ​บท​บัญญัติ บ่﻿ยอมฮับ​แผนก๋าน​ของ​พระเจ้า​ตี้​มี​ต่อ​หมู่​เขา โดย​บ่﻿ฮับ​บัพติศมา​จาก​ยอห์น ");
INSERT INTO nod_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","พระเยซู​อู้​ต่อ​ไป​แหม​ว่า “จาอั้น​เฮา​จะ​เผียบ​คน​ใน​ยุค​สมัย​นี้​เหมือน​กับ​อะหยัง​ดี หมู่​เขา​จะ​เหมือน​อะหยัง ");
INSERT INTO nod_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ก็​เผียบ​เหมือน​กับ​หละอ่อน​นั่ง​เล่น​อยู่​ก๋าง​กาด​ก๋าง​ลี เอิ้น​ฮ้อง​ใส่​กั๋น​ว่า ‘หมู่​เปิ้น​เป่า​ปี่​เป่า​แน​หื้อ​ฟัง​แล้ว หมู่​ตั๋ว​ก็​บ่﻿เต้น​บ่﻿ฟ้อน​ตวย หมู่​เปิ้น​ปา​กั๋น​ฮ้อง​เพลง สำหรับ​งาน​ศพ​หื้อ​ฟัง หมู่​ตั๋ว​ก็​บ่﻿ไห้​บ่﻿หุย​ตวย’ ");
INSERT INTO nod_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ย้อน​ยอห์น​ผู้​หื้อ​บัพติศมา​ถือ​ศีล​อด​อาหาร​กับ​บ่﻿ได้​กิ๋น​เหล้า​องุ่น ต้าน​ตังหลาย​ก็​ว่า ‘คน​นี้​มี​ผี​เข้า​อยู่’ ");
INSERT INTO nod_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ส่วน​บุตรมนุษย์​ได้​ตึง​กิ๋น​ตึง​ดื่ม ต้าน​ตังหลาย​ก็​ว่า ‘ผ่อ​คน​นี้​ลอ ขี้​กละ ขี้​เมา​ตวย ป๋าย​บ่﻿ปอ​ยัง​เป๋น​เปื้อน​กับ​คน​เก็บ​ภาษี คบ​กั๋น​กับ​คน​บาป’ ");
INSERT INTO nod_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","แต่​ปั๋ญญา​ของ​พระเจ้า​นั้น​ก็​ได้ฮับ​ก๋าน​ยอมฮับ​ว่า​ถูกต้อง​แล้ว​จาก​คน​ตี้​เยียะ​ตวย​ต๋าม​ปั๋ญญา​นั้น” ");
INSERT INTO nod_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","มี​คน​นึ่ง​ใน​หมู่​ฟาริสี​จื้อ​ซีโมน เจิญ​พระองค์​ไป​กิ๋น​ข้าว​ตวย พระองค์​ก็​ไป​นั่ง​กิ๋น​ใน​เฮือน​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","มี​แม่ญิง​คน​นึ่ง​ใน​เมือง​นั้น​เป๋น​คน​บาป เมื่อ​ฮู้​ว่า​พระองค์​ก่ำลัง​กิ๋น​ข้าว​อยู่​ใน​บ้าน​ของ​ฟาริสี​คน​นั้น ");
INSERT INTO nod_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","แม่ญิง​คน​นั้น​ก็​ก๋ำ​ขวด​ใส่​น้ำมัน​หอม​มา​ยืน​อยู่​ตัง​หลัง​ใก้﻿ๆ ตี๋น​พระเยซู ไห้​จ๋น​น้ำต๋า​ย้อย​ตก​ใส่​ตี๋น​พระองค์ นาง​ก็​เอา​ผม​ของ​นาง​เจ๊ด​ตี๋น​พระองค์ จูบ​ตี๋น​พระองค์​แล้ว​เอา​น้ำมัน​หอม​ถอก​ใส่​ตี๋น​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ฟาริสี​ตี้​ได้​เจิญ​พระเยซู​มา​บ้าน​หัน​ใส่ ก็​กึ๊ด​ใน​ใจ๋​ว่า “ถ้า​ต้าน​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​แต๊ ก็​ต้อง​ฮู้​ว่า​แม่ญิง​คน​ตี้​ถูก​ตั๋ว​ของ​ต้าน​นั้น​เป๋น​ใผ เป๋น​คน​จาใด ย้อน​นาง​เป๋น​คน​บาป” ");
INSERT INTO nod_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","พระเยซู​จึง​อู้​กับ​เขา​ว่า “ซีโมน​เหย เฮา​มี​เรื่อง​จะ​อู้​กับ​ต้าน​หน้อย” เขา​ก็​ตอบ​ว่า “เจิญ​อาจ๋ารย์ อู้​ไป​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","พระองค์​จึง​อู้​ว่า “เจ้าหนี้​คน​นึ่ง​มี​ลูก​หนี้​สอง​คน คน​นึ่ง​เป๋น​หนี้​ห้า​ร้อย​เดนาริอัน แหม​คน​นึ่ง​เป๋น​หนี้​ห้า​สิบ​เดนาริอัน ");
INSERT INTO nod_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","เมื่อ​หมู่​เขา​บ่﻿มี​สตางค์​มา​ใจ๊​หนี้ เจ้าหนี้​ก็​ยก​หนี้​หื้อ​กับ​สอง​คน​นั้น​เหีย แล้ว​ใน​สอง​คน​นั้น​ใผ​จะ​ฮัก​นาย​นัก​เหลือ​กั๋น” ");
INSERT INTO nod_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ซีโมน​ก็​บอก​พระองค์​ว่า “ข้าพเจ้า​หัน​ว่า​คน​ตี้​นาย​ยก​หนี้​หื้อ​นัก ก็​ฮัก​นาย​นัก” พระองค์​จึง​ว่า “ต้าน​อู้​ถูก​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","พระองค์​จึง​เหลียว​หลัง​ผ่อ​แม่ญิง​คน​นั้น แล้ว​อู้​กับ​ซีโมน​ว่า “ต้าน​หัน​แม่ญิง​คน​นี้​ก่อ เฮา​ได้​เข้า​มา​ใน​เฮือน​ของ​ต้าน ต้าน​บ่﻿ได้​เอา​น้ำ​มา​ซ่วย​ตี๋น​เฮา แต่​แม่ญิง​คน​นี้​ได้​เอา​น้ำต๋า​ซ่วย​ตี๋น​เฮา แล้ว​เอา​ผม​เจ๊ด​ตี๋น​เฮา ");
INSERT INTO nod_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ต้าน​บ่﻿ได้​จูบ​เฮา แต่​แม่ญิง​คน​นี้​จูบ​ตี๋น​เฮา​ตลอด​ตั้งแต่​นาง​เข้า​มา ");
INSERT INTO nod_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ต้าน​บ่﻿ได้​เอา​น้ำมัน​ถอก​หัว​เฮา แต่​แม่ญิง​คน​นี้​เอา​น้ำมัน​หอม​ถอก​ใส่​ตี๋น​เฮา ");
INSERT INTO nod_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ย้อน​จาอั้น​เฮา​บอก​ต้าน​ว่า บาป​ของ​แม่ญิง​คน​นี้​เซิ่ง​มี​นัก ได้​โผด​ยก​หื้อ​แล้ว ย้อน​นาง​ฮัก​เฮา​นัก แต่​คน​ตี้​ได้ฮับ​ก๋าน​ยกโต้ษ​หน้อย​ก็​ฮัก​หน้อย” ");
INSERT INTO nod_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","พระองค์​จึง​บอก​กับ​แม่ญิง​คน​นั้น​ว่า “บาป​ของ​เจ้า เฮา​ยก​หื้อ​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ฝ่าย​คน​ตังหลาย​ตี้​นั่ง​กิ๋น​ข้าว​ตวย​กั๋น​กึ๊ด​ใน​ใจ๋​ว่า “คน​นี้​เป๋น​ใผ​เถิง​ยกโต้ษ​บาป​หื้อ​ได้” ");
INSERT INTO nod_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","พระเยซู​จึง​บอก​แม่ญิง​คน​นั้น​ว่า “ความ​เจื้อ​ของ​เจ้า​ได้​เยียะ​หื้อ​เจ้า​รอด​ป๊น​บาป​โต้ษ​แล้ว ขอ​หื้อ​อยู่​ดี​มี​สุข​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ต่อ​มา​พระองค์​ก็​เตียว​ตาง​ไป​ใคว่​บ้าน​ใคว่​เมือง บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า สาวก​สิบ​สอง​คน​ก็​อยู่​กับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ฮ่วม​กับ​แม่ญิง​บาง​คน​ตี้​พระองค์​เกย​ไล่​ผี​ออก​จาก​ตั๋ว​กับ​ฮักษา​โรค​หื้อ​หาย ได้​แก่​มารีย์​ตี้​ฮ้อง​กั๋น​ว่า​มารีย์​จาว​มักดาลา คน​ตี้​พระองค์​ได้​ไล่​ผี​ออก​เจ็ด​ตั๋ว ");
INSERT INTO nod_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","กับ​นาง​โยอันนา​เมีย​ของ​คูซา ป้อบ้าน​ของ​เจ้าเมือง​เฮโรด สุสันนา​กับ​แม่ญิง​แหม​หลาย​คน​ตี้​เกย​ถวาย​ของ​ส่วน​ตั๋ว​จ้วยเหลือ​พระองค์​กับ​สาวก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","เมื่อ​มี​หมู่​คน​จ๋ำนวน​นัก คน​จาก​หลาย​บ้าน​หลาย​เมือง​มา​หา​พระเยซู พระองค์​จึง​อู้​กับ​หมู่​เขา​เป๋น​กำเผียบ​ว่า ");
INSERT INTO nod_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“มี​จาวนา​คน​นึ่ง​ออก​ไป​หว่าน​เม็ด​พืช บาง​เม็ด​ตก​ต๋าม​หน​ตาง​เตียว คน​ก็​ย่ำ​แล้ว​นก​ก็​มา​จิก​กิ๋น​เหีย​หมด ");
INSERT INTO nod_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","บาง​เม็ด​ก็​ตก​ลง​ดิน​ตี้​ปื๊น​ตัง​ลุ่ม​เป๋น​บ่าหิน​เต๋ม​ไป​หมด เมื่อ​งอก​ขึ้น​มา​บ่﻿ปอ​เมิน​ก็​เหี่ยว​แห้ง​ต๋าย ย้อน​ว่า​ขาด​น้ำ ");
INSERT INTO nod_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","บาง​เม็ด​ตก​ก๋าง​ป่า​หนาม ต้น​หนาม​นั้น​ก็​ใหญ่​ขึ้น​มา​งำ​ต้น​นั้น​เหีย​หมด ");
INSERT INTO nod_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","บาง​เม็ด​ตก​บน​ดิน​ดี ก็​งอก​งาม​ใหญ่​ขึ้น​แล้ว​ก็​มี​งวง​มี​เม็ด​นัก​เป๋น​ร้อย​เต้า” เมื่อ​พระองค์​อู้​แล้ว ก็​บอก​หมู่​เขา​เสียง​ดัง​ว่า “ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","หมู่​สาวก​ถาม​พระองค์​ว่า “กำเผียบ​นั้น​หมาย​ความ​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","พระเยซู​บอก​หมู่​สาวก​ว่า “ข้อ​ล้ำเลิ็ก​เรื่อง​แผ่นดิน​ของ​พระเจ้า​โผด​หื้อ​ต้าน​ตังหลาย​ฮู้​ได้ ส่วน​หมู่​คน​อื่น﻿ๆ นั้น จะ​อู้​หื้อ​ฟัง​เป๋น​กำเผียบ​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​พระคัมภีร์​ตี้​ว่า ‘หมู่​เขา​ผ่อ​แต่​บ่﻿หัน หมู่​เขา​ฟัง​แต่​บ่﻿เข้าใจ๋’ ");
INSERT INTO nod_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“กำเผียบ​คือ​จาอี้ เม็ด​พืช​ก็​คือ​ถ้อยกำ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ตี้​ตก​ต๋าม​หน​ตาง​เตียว​ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​ของ​พระเจ้า แล้ว​มาร​ก็​มา​ลู่​เอา​ถ้อยกำ​นั้น​ตี้​หว่าน​ลง​ใน​ใจ๋​ของ​เขา​ไป​เหีย เปื้อ​บ่﻿หื้อ​เขา​เจื้อ​และ​รอด​ป๊น​บาป​โต้ษ​ได้ ");
INSERT INTO nod_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ตี้​ตก​ลง​ดิน​ตี้​ปื๊น​ตัง​ลุ่ม​เป๋น​บ่าหิน​เต๋ม​ไป​หมด ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​แล้ว​ก็​ฮับ​ถ้อยกำ​นั้น​ตัน​บาด​ตัน​บ้วง​อย่าง​จื้นจม​ยินดี แต่​ฮาก​ลง​ดิน​บ่﻿เลิ็ก เขา​เจื้อ​บ่﻿ปอ​เมิน เมื่อ​ถูก​ทดลอง​ก็​เลิก​เจื้อ​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ตี้​ตก​ก๋าง​ป่า​หนาม​นั้น​ก็​เหมือน​คน​ตี้​ได้​ฟัง​ถ้อยกำ​แล้ว​ก็​ฮับ​เอา​เหมือน​กั๋น แต่​ความ​เป๋น​ห่วง​เรื่อง​ต่าง﻿ๆ เกี่ยว​กับ​จีวิต​ใน​โลก​นี้ ความ​หลง​มัวเมา​ข้าว​ของ​เงิน​คำ กับ​ความ​ม่วน​งัน​สัน​เล้า ก็​มา​งำ​เขา​ไว้ แล้ว​ความ​เจื้อ​ของ​เขา​ก็​บ่﻿จ๋ำเริญ​เติบโต ");
INSERT INTO nod_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ตี้​ตก​บน​ดิน​ดี ก็​เหมือน​คน​มี​จิตใจ๋​ตี้​ดี​งาม​กับ​สูง​ส่ง เมื่อ​ได้​ฟัง​ถ้อยกำ​ก็​จ๋ำ​เอา​ไว้ แล้ว​ก็​อดทน​จ๋น​ออก​ผล ");
INSERT INTO nod_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“บ่﻿มี​ใผ​เมื่อ​ต๋าม​โกม​ไฟ​แล้ว​จะ​เอา​ซ้า​ควบ​ไว้​เหีย กาว่า​เอา​ไป​ซุก​ไว้​ปื๊น​เตียง แต่​จะ​ตั้ง​บน​ตั่ง​ไว้ เปื้อ​คน​ตังหลาย​ตี้​เข้า​มา​จะ​หัน​เป่งแจ้ง​ได้ ");
INSERT INTO nod_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","กู้​สิ่ง​ตี้​เอา​ไป​ซ่อน​ไว้​ก็​จะ​ป๋ากฏ​ออก​มา​หื้อ​หัน กับ​กู้​สิ่ง​ตี้​เป๋น​ความ​ลับ​ก็​จะ​ถูก​เปิดเผย​หื้อ​ฮู้ ");
INSERT INTO nod_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ย้อน​จาอั้น ต้าน​ตังหลาย​ฟัง​หื้อ​ดี﻿ๆ คน​ตี้​เข้าใจ๋​อยู่​แล้ว​ก็​จะ​เข้าใจ๋​นัก​ขึ้น​แหม ส่วน​คน​ตี้​บ่﻿เข้าใจ๋ แม้​ตี้​เขา​กึ๊ด​ว่า​เขา​เข้าใจ๋ พระเจ้า​จะ​เอา​ไป​จาก​เขา​เหีย” ");
INSERT INTO nod_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ต๋อน​นั้น​แม่​กับ​หมู่​น้อง​บ่าว​ของ​พระเยซู​มา​หา​พระองค์ แต่​เข้า​ไป​เถิง​ตั๋ว​พระองค์​บ่﻿ได้ ย้อน​มี​คน​นัก ");
INSERT INTO nod_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","มี​คน​บอก​พระองค์​ว่า “แม่​กับ​หมู่​น้อง​บ่าว​ของ​ต้าน​มา​ยืน​ถ้า​อยู่​ตังนอก” ");
INSERT INTO nod_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","พระเยซู​อู้​กับ​หมู่​เขา​ตี้​หั้น​ว่า “แม่​กับ​น้อง​ของ​เฮา คือ​คน​ตี้​ได้​ฟัง​ถ้อยกำ​ของ​พระเจ้า แล้ว​เยียะ​ต๋าม” ");
INSERT INTO nod_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","อยู่​มา​วัน​นึ่ง​พระองค์​ลง​เฮือ​กับ​หมู่​สาวก​ของ​พระองค์ แล้ว​พระองค์​บอก​หมู่​เขา​ว่า “หื้อ​หมู่​เฮา​ข้าม​ทะเลสาบ​ไป​เผิก​ตัง​ปู๊น​เต๊อะ” หมู่​เขา​ก็​นั่ง​เฮือ​ออก​ไป ");
INSERT INTO nod_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","เมื่อ​เฮือ​ก่ำลัง​ไป พระองค์​ก็​นอน​หลับ แล้ว​มี​ลมหลวง​ก๋าง​ทะเล น้ำ​ซัด​เข้า​เกือบ​เต๋ม​เฮือ​จ๋น​เป๋น​อันตราย ");
INSERT INTO nod_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","หมู่​เขา​มา​ฮ้อง​พระองค์​ลุก บอก​พระองค์​ว่า “อาจ๋ารย์ อาจ๋ารย์ หมู่​เฮา​จะ​จ๋ม​น้ำ​ต๋าย​กั๋น​หมด​แล้ว” พระองค์​ก็​ลุก​ขึ้น​ห้าม​ลม​กับ​คลื่น แล้ว​คลื่น​กับ​ลม​ก็​หยุด ทะเล​ก็​หนิมผิ้ว​ดี ");
INSERT INTO nod_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","พระเยซู​จึง​อู้​กับ​หมู่​เขา​ว่า “บ่﻿มี​ความ​เจื้อ​กา” หมู่​เขา​ก็​กั๋ว​กับ​ปา​กั๋น​งืด​อู้​กั๋น​ว่า “ต้าน​ผู้​นี้​เป๋น​ใผ​กั๋น สั่ง​บังคับ​ลม​กับ​คลื่น​ได้ ลม​กับ​คลื่น​ก็​เจื้อ​ฟัง​ต้าน” ");
INSERT INTO nod_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","หมู่​เขา​แล่น​เฮือ​ไป​เถิง​เขต​ของ​จาว​เกราซา​ตี้​อยู่​แหม​เผิก​นึ่ง​ของ​ทะเลสาบ​กาลิลี ");
INSERT INTO nod_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","เมื่อ​พระองค์​ขึ้น​ฝั่ง มี​คน​นึ่ง​ออก​มา​จาก​เมือง​มา​ปะ​พระองค์ คน​นั้น​มี​ผี​เข้า​อยู่ บ่﻿ได้​นุ่ง​เสื้อ​นุ่ง​ผ้า บ่﻿ได้​อยู่​กับ​บ้าน​กับ​เฮือน อยู่​ต๋าม​อุโมงค์​ฝัง​ศพ​มา​เมิน​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","เมื่อ​เขา​หัน​พระเยซู เขา​ก็​หุย​เสียง​ดัง ยอบ​ตั๋ว​ลง​ไหว้​ส่อง​หน้า​พระองค์​ฮ้อง​เสียง​ดัง​ว่า “โอ​พระเยซู​พระบุตร​ของ​พระเจ้า​ผู้​สูงสุด มา​ยุ่ง​กับ​เฮา​เยียะ​หยัง ขอ​เต๊อะ ห้าม​ทรมาน​เฮา​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ตี้​เขา​อู้​จาอั้น ก็​ย้อน​พระเยซู​ได้​สั่ง​ผี​ฮ้าย​หื้อ​ออก​จาก​เขา ผี​นั้น​เกย​เข้า​เขา​หลาย​เตื้อ เขา​เกย​ถูก​คน​เอา​เจื้อก​เหล็ก​ล่าม​กับ​กุม​เขา​ไว้ แต่​เขา​ก็​สะต๊ก​เจื้อก​เหล็ก​ปุด​หมด กับ​ผี​ฮ้าย​ก็​ปา​เขา​เข้า​ไป​อยู่​ใน​ป่า​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","พระเยซู​ถาม​เขา​ว่า “เจ้า​จื้อ​อะหยัง” เขา​ตอบ​ว่า “จื้อ​ก๋อง” ย้อน​ว่า​มี​ผี​ฮ้าย​หลาย​ตั๋ว​เข้า​อยู่​ใน​ตั๋ว​เขา ");
INSERT INTO nod_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ผี​นั้น​ก็​อ้อนวอน​ซ้ำแล้ว​ซ้ำแหม ขอ​บ่﻿หื้อ​พระองค์​สั่ง​ปิ๊ก​ไป​อยู่​ใน​ขุม​ตี้​เลิ็ก​ตี้​สุด ");
INSERT INTO nod_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","มี​หมู​เป๋น​หมู่​ใหญ่​ก่ำลัง​เซาะ​หา​กิ๋น​อยู่​ต๋าม​เถิ้ม​ดอย​ใก้﻿ๆ หั้น ผี​หมู่​นั้น​จึง​อ้อนวอน​พระองค์ ขอ​ไป​เข้า​อยู่​ใน​หมู​หมู่​นั้น พระเยซู​อู้​ว่า “ไป​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ผี​ฮ้าย​หมู่​นั้น​ก็​ออก​จาก​ป้อจาย​คน​นั้น แล้ว​ไป​เข้า​อยู่​ใน​หมู หมู​หมู่​นั้น​ก็​ปา​กั๋น​ล่น​ลง​หน้าผา​จิ๊ง​ลง​ไป​ใน​ทะเล​แก๊น​น้ำ​ต๋าย​หมด ");
INSERT INTO nod_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","หมู่​คน​เลี้ยง​หมู​เมื่อ​หัน​เหตุก๋ารณ์​จาอั้น ก็​ปา​กั๋น​ล่น​หนี​ไป​เล่า​หื้อ​คน​ใน​เมือง​นั้น​ฟัง ตึง​ใน​เวียง​ตึง​บ้าน​นอก ");
INSERT INTO nod_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","คน​ตังหลาย​ก็​ปา​กั๋น​ออก​ไป​ผ่อ​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​นั้น เมื่อ​หมู่​เขา​มา​ตี้​พระเยซู​อยู่ ก็​หัน​คน​ตี้​ผี​ออก​แล้ว​นั้น นุ่ง​เสื้อผ้า มี​สติ​ดี​นั่ง​อยู่​ใก้​ตี๋น​พระเยซู คน​ตังหลาย​ก็​ปา​กั๋น​กั๋ว ");
INSERT INTO nod_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","คน​ตังหลาย​ตี้​ได้​หัน​เหตุก๋ารณ์ ก็​เล่า​หื้อ​คน​อื่น﻿ๆ ฟัง​เรื่อง​คน​โดน​ผี​เข้า​หาย​เป๋น​ปกติ​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","หมู่​คน​ใน​ดินแดน​เกราซา​ปา​กั๋น​มา​อ้อนวอน​พระองค์​ขอ​หื้อ​ไป​จาก​หมู่​เขา​เหีย ย้อน​ว่า​หมู่​เขา​กั๋ว พระเยซู​จึง​ลง​เฮือ​ไป ");
INSERT INTO nod_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","คน​ตี้​ผี​ออก​จาก​ตั๋ว​แล้ว อ้อนวอน​ขอ​ไป​กับ​พระองค์ แต่​พระเยซู​สั่ง​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ปิ๊ก​ไป​บ้าน​เหีย แล้ว​บอก​หื้อ​จาวบ้าน​ฮู้​เถิง​ก๋าน​ใหญ่​ตี้​พระเจ้า​ได้​เยียะ​ต่อ​เจ้า” คน​นั้น​ก็​ปิ๊ก​ไป​บอก​คน​ตึง​เมือง​ฮู้​เถิง​เหตุก๋ารณ์​ตี้​พระเยซู​ได้​เยียะ​กับ​เขา ");
INSERT INTO nod_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","เมื่อ​พระเยซู​ปิ๊ก​ข้าม​ทะเล​มา​แล้ว คน​ตังหลาย​ก็​ต้อนฮับ​พระองค์ ย้อน​เขา​ตังหลาย​ถ้า​พระองค์​อยู่ ");
INSERT INTO nod_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","มี​ป้อจาย​คน​นึ่ง​จื้อ​ไยรัส เป๋น​นาย​ธรรมศาลา​ของ​จาว​ยิว​เข้า​มา​กราบ​ตี๋น​พระเยซู อ้อนวอน​พระองค์​หื้อ​ไป​บ้าน​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ย้อน​ว่า​เขา​มี​ลูก​สาว​คน​เดียว​อายุ​สิบ​สอง​ขวบ นอน​ป่วย​อยู่​เกือบ​จะ​ต๋าย​แล้ว เมื่อ​พระองค์​ก่ำลัง​ไป​นั้น คน​ตังหลาย​ก็​ยัด​ยู้​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","มี​แม่ญิง​คน​นึ่ง​เป๋น​โรค​เลือด​ตก​บ่﻿หยุด​สิบ​สอง​ปี๋​แล้ว เสี้ยง​เงินทอง​หื้อ​หมอ​ฮักษา​จ๋น​หมด​เนื้อ​หมด​ตั๋ว แต่​บ่﻿มี​ใผ​ฮักษา​ได้ ");
INSERT INTO nod_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","นาง​ลักมอบ​มา​ตัง​หลัง​พระเยซู แล้ว​ก็​หยุบ​ตี๋น​เสื้อ​คุม​ของ​พระองค์ เลือด​ตี้​ตก​ก็​หยุด​แห้ง​ไป​เลย ");
INSERT INTO nod_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","พระเยซู​จึง​ถาม​ว่า “ใผ​มา​หยุบ​ตั๋ว​เฮา” เมื่อ​คน​ตังหลาย​อู้​ว่า​บ่﻿ได้​โดน​ลอ เปโตร​จึง​บอก​พระองค์​ว่า “อาจ๋ารย์ คน​ยัด​ยู้​กั๋น​ล่อ ก็​ถูก​ใส่​พระองค์​พ่อง​ก่า” ");
INSERT INTO nod_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","แต่​พระเยซู​บอก​ว่า “มี​คน​นึ่ง​ถูก​ตั๋ว​เฮา ย้อน​เฮา​ฮู้สึก​ฤทธิ์​แผ่ซ่าน​ออก​จาก​ตั๋ว​เฮา” ");
INSERT INTO nod_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","เมื่อ​แม่ญิง​คน​นั้น​หัน​ว่า​พระเยซู​ฮู้​แล้ว นาง​กั๋ว​จ๋น​ตั๋ว​สั่น​เข้า​มา​ก้ม​ลง​กราบ​พระองค์ บอก​พระองค์​ต่อหน้า​คน​ตังหลาย​ว่า นาง​ได้​ถูก​ต้อง​พระองค์​ย้อน​เหตุ​อะหยัง และ​ได้​หาย​โรค​ตันที ");
INSERT INTO nod_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","พระองค์​อู้​กับ​นาง​ว่า “ลูก​เหย​ความ​เจื้อ​ของ​เจ้า​เยียะ​หื้อ​เจ้า​หาย​โรค​แล้ว ขอ​หื้อ​อยู่​ดี​มี​สุข​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ต๋อน​ตี้​พระองค์​ก่ำลัง​อู้​อยู่​นั้น มี​คน​มา​จาก​บ้าน​ของ​ไยรัส​ตี้​เป๋น​นาย​ธรรมศาลา​มา​บอก​เขา​ว่า “ลูก​สาว​ของ​ต้าน​ต๋าย​แล้ว บ่﻿ต้อง​รบก๋วน​อาจ๋ารย์​ละ” ");
INSERT INTO nod_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","เมื่อ​พระเยซู​ได้ยิน​จาอั้น จึง​อู้​กับ​ไยรัส​ว่า “บ่﻿ต้อง​กั๋ว จง​เจื้อ​เต้าอั้น แล้ว​ลูก​จะ​หาย” ");
INSERT INTO nod_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","เมื่อ​มา​แผว พระเยซู​ก็​เข้า​ไป​ใน​เฮือน พระองค์​บ่﻿หื้อ​คน​อื่น​เข้า​ไป​ตวย นอกจาก​เปโตร ยอห์น ยากอบ​กับ​ป้อแม่​ของ​หละอ่อน​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","คน​ตังหลาย​ก็​ไห้​หุย​สนั่น​ปั่น​ปื๊น ย้อน​หละอ่อน​คน​นั้น​ต๋าย พระเยซู​บอก​หมู่​เขา​ว่า “บ่﻿ต้อง​ไห้ เขา​ยัง​บ่﻿ต๋าย​เตื้อ​ลอ แต่​หลับ​อยู่​บ่﻿ดาย” ");
INSERT INTO nod_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","คน​ตังหลาย​ก็​ใค่หัว​ใส่​พระองค์ ย้อน​หมู่​เขา​ฮู้​ว่า​หละอ่อน​นั้น​ต๋าย​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","พระเยซู​ก๋ำ​มือ​หละอ่อน​คน​นั้น​ไว้ แล้ว​อู้​ออก​มา​ว่า “ลูก​เหย จง​ลุก​ขึ้น​มา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","แล้ว​วิญญาณ​ของ​หละอ่อน​ก็​ปิ๊ก​เข้า​สู่​ใน​หละอ่อน​คน​นั้น เขา​ก็​ลุก​ขึ้น​นั่ง​ตันที พระองค์​สั่ง​ป้อแม่​ว่า “เอา​ข้าว​มา​หื้อ​หละอ่อน​กิ๋น” ");
INSERT INTO nod_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ป้อแม่​ของ​หละอ่อน​ก็​ปา​กั๋น​ตก​สะเกิ็ด แต่​พระองค์​สั่ง​ห้าม​เขา​บ่﻿หื้อ​บอก​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​นั้น​กับ​ใผ​สัก​คน ");
INSERT INTO nod_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","พระเยซู​ฮ้อง​สาวก​สิบ​สอง​คน​มา แล้ว​หื้อ​สิทธิ​อำนาจ​หมู่​เขา​ไล่​ผี​ฮ้าย​กับ​ฮักษา​โรค​ต่าง﻿ๆ หื้อ​หาย​ได้ ");
INSERT INTO nod_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","แล้ว​พระองค์​ส่ง​หมู่​เขา​ออก​ไป​บอก​เรื่อง​แผ่นดิน​ของ​พระเจ้า กับ​ฮักษา​คน​เจ็บป่วย​ตังหลาย​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","พระองค์​สั่ง​หมู่​เขา​ว่า “บ่﻿ต้อง​เอา​อะหยัง​ไป​ตวย​เน่อ เจ้น​ไม้เต๊า ถง ของกิ๋น สตางค์ กาว่า เสื้อผ้า​แหม​ผืน ");
INSERT INTO nod_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ถ้า​เข้า​ไป​ใน​เฮือน​ใด ก็​หื้อ​ย้าง​อยู่​เฮือน​นั้น​จ๋น​กว่า​จะ​ย้าย​ไป ");
INSERT INTO nod_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","หมู่​บ้าน​ใด​บ่﻿ยอม​ต้อนฮับ​ต้าน เมื่อ​ต้าน​ออก​จาก​หมู่​บ้าน​นั้น​ไป หื้อ​ปัด​ขี้ฝุ่น​ตี้​ติด​ตี๋น​ต้าน​ออก​ขว้าง​ไว้​หั้น เปื้อ​ส่อ​หื้อ​หัน​ว่า​พระเจ้า​บ่﻿ปอใจ๋​กับ​บ่﻿ยอมฮับ​เขา” ");
INSERT INTO nod_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","หมู่​สาวก​ก็​ปา​กั๋น​ออก​ไป​ใคว่​บ้าน​ใคว่​เมือง บอก​ข่าวดี​กับ​ฮักษา​คน​เจ็บป่วย​กู้​แห่ง​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","กษัตริย์​เฮโรด​ตี้​ปกครอง​แคว้น​กาลิลี​ได้​ยิน​เรื่อง​เหตุก๋ารณ์​ตังหลาย​ตี้​พระเยซู​กับ​สาวก​ได้​เยียะ จึง​สับสน​ขนาด ย้อน​บาง​คน​บอก​ว่า​ยอห์น​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","บาง​คน​ว่า​เป๋น​เอลียาห์​มา​ป๋ากฏ คน​อื่น​ก็​ว่า​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ใน​สมัย​โบราณ​ตี้​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","เฮโรด​ก็​อู้​ว่า “ยอห์น​นั้น​เฮา​ได้​สั่ง​หื้อ​กก​คอ​แล้ว แต่​คน​นี้​ตี้​เฮา​ได้ยิน​เรื่อง​ของ​เขา เป๋น​ใผ​หา” แล้ว​เฮโรด​จึง​หา​โอกาส​ตี้​จะ​ปะ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","เมื่อ​หมู่​อัคร​สาวก​ปิ๊ก​มา​แล้ว เขา​รายงาน​พระเยซู​เรื่อง​ตี้​หมู่​เขา​ได้​เยียะ พระองค์​ก็​ปา​หมู่​เขา​แหละ​ออก​จาก​คน​นัก ไป​ตัง​เมือง​เบธไซดา ");
INSERT INTO nod_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","แต่​คน​ตังหลาย​ฮู้​จึง​ปา​กั๋น​ไป​ตวย​หา​พระองค์ พระองค์​ก็​ต้อนฮับ​เขา สอน​เขา​เถิง​เรื่อง​แผ่นดิน​ของ​พระเจ้า ใผ​ต้องก๋าน​หื้อ​พระองค์​ฮักษา​โรค​พระองค์​ก็​ฮักษา​หื้อ ");
INSERT INTO nod_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ต๋อน​เมื่อแลง สาวก​สิบ​สอง​คน​มา​บอก​พระองค์​ว่า “บอก​หื้อ​คน​หมู่​นี้​ไป​เซาะ​ของกิ๋น​กับ​เซาะ​ตี้​ย้าง​นอน​กั๋น​ต๋าม​บ้าน​ไฮ่​บ้าน​นา​ตึง​หมู่​บ้าน​ต๋ำ​หมู่​นี้​เอา​เต๊อะ ย้อน​ตี้​นี่​ทุรกั๋นดาร” ");
INSERT INTO nod_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","พระองค์​บอก​หมู่​สาวก​ว่า “หมู่​ต้าน​ไป​เซาะ​ของ​กิ๋น​มา​เลี้ยง​หมู่​เขา​เหีย​ก่า” หมู่​เขา​ก็​ว่า “เฮา​บ่﻿มี​อะหยัง​นัก มี​ก้า​เข้าหนมปัง​ห้า​ก้อน​กับ​ป๋า​สอง​ตั๋ว​เต้าอั้น จะ​หื้อ​เฮา​ไป​ซื้อ​ของ​กิ๋น​สำหรับ​คน​หมู่​นี้​กา” ");
INSERT INTO nod_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ตี้​อู้​จาอี้​ย้อน​นับ​ก้า​ป้อจาย​ได้​ประมาณ​ห้า​ปัน​คน แล้ว​พระองค์​จึง​สั่ง​หมู่​สาวก​ว่า “จัด​หื้อ​คน​ตึง​หมด​นั่ง​ลง​เป๋น​หมู่﻿ๆ ละ​ห้า​สิบ​คน” ");
INSERT INTO nod_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","สาวก​ก็​เยียะ​ต๋าม​กำสั่ง​คือ​จัด​หื้อ​คน​ตึง​หมด​นั่ง​ลง ");
INSERT INTO nod_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","พระองค์​จึง​ฮับ​เข้าหนมปัง​ห้า​ก้อน​กับ​ป๋า​สอง​ตั๋ว​นั้น​มา แล้ว​แหงน​หน้า​ขึ้น​ผ่อ​ฟ้า​สวรรค์​ขอบ​พระคุณ​พระเจ้า แล้ว​ก็​หัก​ส่ง​หื้อ​หมู่​สาวก​เอา​ไป​แจก​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","คน​ตึง​หมด​ได้​กิ๋น​อิ่ม​กู้​คน แล้ว​หมู่​เขา​เก็บ​ของ​กิ๋น​ตี้​เหลือ​ได้​สิบ​สอง​ซ้า​เต๋ม﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","วัน​นึ่ง เมื่อ​พระเยซู​อธิษฐาน​อยู่​คน​เดียว หมู่​สาวก​ก็​อยู่​ใก้﻿ๆ พระองค์​ก็​ถาม​หมู่​เขา​ว่า “คน​ตังหลาย​อู้​กั๋น​ว่า​เฮา​เป๋น​ใผ​กา” ");
INSERT INTO nod_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","หมู่​สาวก​ตอบ​ว่า “บาง​คน​ว่า เป๋น​ยอห์น​ผู้​หื้อ​บัพติศมา บาง​คน​ว่า เป๋น​เอลียาห์ บาง​คน​ก็​ว่า เป๋น​คน​นึ่ง​ใน​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ใน​สมัย​โบราณ​ตี้​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","พระองค์​ถาม​หมู่​เขา​ว่า “หมู่​ต้าน​ลอ​กึ๊ด​ว่า​เฮา​เป๋น​ใผ” เปโตร​ตอบ​พระองค์​ว่า “พระองค์​เป๋น​พระคริสต์​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","พระองค์​สั่ง​หมู่​สาวก​บ่﻿หื้อ​บอก​เรื่อง​นี้​กับ​ใผ ");
INSERT INTO nod_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","แล้ว​บอก​หมู่​เขา​ว่า “บุตรมนุษย์​จะ​ต้อง​ได้​ฮับ​ความ​ตุ๊ก​ทรมาน​หลาย​อย่าง หมู่​คน​เฒ่า​คน​แก่ หมู่​หัวหน้า​ปุโรหิต กับ​หมู่​ธรรมาจ๋ารย์​จะ​บ่﻿ยอมฮับ​พระองค์ ใน​ตี้​สุด​พระองค์​จะ​ถูก​ฆ่า​ต๋าย แต่​หลัง​จาก​นั้น​แหม​สาม​วัน พระเจ้า​จะ​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","พระองค์​ก็​บอก​หื้อ​คน​ตังหลาย​ว่า “ถ้า​ใผ​คน​ใด​ใค่​เป๋น​สาวก​ของ​เฮา ก็​หื้อ​คน​นั้น​ตัด​อก​ตัด​ใจ๋ แบก​ไม้​ก๋าง​เขน​ของ​ตั๋ว​เก่า แล้ว​ตวย​เฮา​มา​กู้​วัน ");
INSERT INTO nod_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ย้อน​ว่า​ถ้า​คน​ใด​ใค่​ฮักษา​จีวิต​ของ​ตั๋ว​ไว้ คน​นั้น​จะ​ฮักษา​จีวิต​นั้น​บ่﻿ได้​ก็​จะ​ต๋าย แต่​ถ้า​คน​ใด​ยอม​สละ​จีวิต​ของ​ตั๋ว​ย้อน​หัน​แก่​เฮา คน​นั้น​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","จะ​มี​ประโยชน์​อะหยัง​ถ้า​ได้​เป๋น​เจ้าของ​กู้​สิ่ง​กู้​อย่าง​ใน​โลก​นี้ แต่​ต้อง​เสีย​จีวิต​ของ​ตั๋ว​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ถ้า​คน​ใด​อาย​ย้อน​ติดต๋าม​เฮา​กับ​กำสอน​ของ​เฮา เฮา​ผู้​เป๋น​บุตรมนุษย์​ก็​จะ​อาย​คน​นั้น​ตวย เมื่อ​เฮา​ปิ๊ก​มา​ใน​โลก​ด้วย​รัศมี​ของ​ต้าน กับ​ของ​พระบิดา ตึง​ของ​หมู่​ทูตสวรรค์​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","แต่​เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า หมู่​ต้าน​บาง​คน​ตี้​ยืน​อยู่​ตี้​นี่​จะ​ยัง​บ่﻿ต๋าย​เตื้อ จ๋น​กว่า​จะ​ได้​หัน​แผ่นดิน​ของ​พระเจ้า​เหีย​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","เมื่อ​พระเยซู​อู้​จาอั้น​แล้ว​ได้​สัก​แปด​วัน พระองค์​ก็​ปา​เปโตร ยอห์น กับ​ยากอบ​ขึ้น​ไป​บน​ดอย​เปื้อ​อธิษฐาน ");
INSERT INTO nod_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","เมื่อ​พระองค์​ก่ำลัง​อธิษฐาน​อยู่ หน้า​ของ​พระองค์​ก็​เปี่ยน​ไป เสื้อผ้า​ของ​พระองค์​ก็​ขาว​จ๋น​ต้อง​ต๋า​มาบ﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","แล้ว​มี​สอง​คน​คือ​โมเสส​กับ​เอลียาห์​ก่ำลัง​อู้​กับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ผู้​ตี้​มา​ป๋ากฏ​นั้น​มี​รัศมี​อัน​ยิ่งใหญ่ ก่ำลัง​อู้​กั๋น​เถิง​เรื่อง​ความ​ต๋าย​ของ​พระองค์​ตี้​จะ​เกิด​ขึ้น​แต๊​ใน​กรุง​เยรูซาเล็ม ต๋าม​ความ​ต้องก๋าน​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","เปโตร ยากอบ ยอห์น ก่ำลัง​ใค่หลับ เมื่อ​ต๋า​แจ้ง​ขึ้น​ก็​หัน​รัศมี​ของ​พระองค์ กับ​หัน​สอง​คน​นั้น​ยืน​อยู่​กับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","เมื่อ​สอง​คน​นั้น​ก่ำลัง​จะ​ลา​พระองค์ เปโตร​จึง​อู้​กับ​พระเยซู​ว่า “อาจ๋ารย์​ครับ เป๋น​สิ่ง​ดี​แต๊﻿ๆ ตี้​หมู่​เฮา​ได้​มา​อยู่​ตี้​นี่ หมู่​เฮา​จะ​แป๋ง​ตูบ​ไว้​สาม​หลัง หื้อ​อาจ๋ารย์ โมเสส กับ​เอลียาห์​คน​ละ​หลัง” เปโตร​บ่﻿ฮู้สึก​ตั๋ว​ว่า​ได้​อู้​อะหยัง​ไป ");
INSERT INTO nod_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","เมื่อ​เขา​ก่ำลัง​อู้​อยู่​นั้น มี​เมฆ​หุ้ม​หมู่​เขา​ไว้ เมื่อ​อยู่​ใน​เมฆ​หมู่​เขา​ก็​กั๋ว ");
INSERT INTO nod_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","มี​เสียง​ออก​มา​จาก​เมฆ​ว่า “ต้าน​ผู้​นี้​เป๋น​ลูก​ของ​เฮา เป๋น​ผู้​ตี้​เฮา​เลือก​ไว้ หื้อ​เจื้อฟัง​ต้าน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","เมื่อ​เสียง​ดัก​แล้ว เขา​ตึง​สาม​ก็​หัน​ก้า​พระเยซู​คน​เดียว​เต้าอั้น เหตุก๋ารณ์​ตี้​หมู่​เขา​หัน​นั้น หมู่​เขา​เก็บ​เรื่อง​นี้​ไว้ กับ​บ่﻿ได้​บอก​หื้อ​ใผ​ฮู้​สัก​คน ");
INSERT INTO nod_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","เมื่อ​แจ้ง​เจ๊า​แล้ว พระเยซู​กับ​สาวก​สาม​คน​นั้น​ลง​ดอย​มา มี​คน​จ๋ำนวน​นัก​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","มี​ป้อจาย​คน​นึ่ง​ใน​คน​ตังหลาย​ตี้​มา​นั้น​เอิ้น​พระองค์​ว่า “อาจ๋ารย์​ครับ ขอ​ไป​ผ่อ​ลูก​ข้าพเจ้า​หน้อย ข้าพเจ้า​มี​ลูก​คน​เดียว​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ผี​ฮ้าย​เข้า​เขา เยียะ​หื้อ​เขา​ฮ้อง​เสียง​ดัง​บ่า​เดี่ยว​นั้น​เลย กับ​โก้น​ลง​จั๊กดิ้นจั๊กงอ​น้ำลาย​ออก​เต๋ม​ปาก จ๋น​เนื้อ​ตั๋ว​ม้าน​ไป​หมด ผี​ตึง​บ่﻿ออก​จาก​เขา​เลย ");
INSERT INTO nod_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ข้าพเจ้า​ขอ​หมู่​สาวก​ของ​ต้าน​ไล่​ผี​นั้น​ออก แต่​หมู่​เขา​ไล่​มัน​ออก​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","พระเยซู​ตอบ​ว่า “เฮ่อ หมู่​คน​บ่﻿มี​ความ​เจื้อ​กับ​เยียะ​บ่﻿ดี เฮา​จะ​อยู่​กับ​หมู่​สู​กับ​จะ​ต้อง​อดทน​กับ​หมู่​สู​ไป​แผว​ไหน ปา​ลูก​มา​นี่​แล่” ");
INSERT INTO nod_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","เมื่อ​หละอ่อน​คน​นั้น​ก่ำลัง​มา ผี​ฮ้าย​ก็​เยียะ​หื้อ​เขา​จั๊กดิ้นจั๊กงอ แต่​พระเยซู​สั่ง​ผี​ฮ้าย​นั้น​หื้อ​ออก​มา กับ​ฮักษา​หละอ่อน​หื้อ​หาย​เป๋น​ปกติ แล้ว​หื้อ​ป้อ​ของ​เขา​ฮับ​ไป ");
INSERT INTO nod_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","คน​ตังหลาย​ก็​งืด​ใน​ฤทธิ์​อำนาจ​อัน​ยิ่งใหญ่​ของ​พระเจ้า แต่​เมื่อ​หมู่​เขา​ยัง​ยืน​งืด​ใน​สิ่ง​ตังหลาย​ตี้​พระเยซู​เยียะ พระองค์​ก็​อู้​กับ​หมู่​สาวก​ว่า ");
INSERT INTO nod_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ต้าน​ตังหลาย​จ๋ำ​กำ​นี้​ไว้​เน่อ ว่า​จะ​มี​คน​หักหลัง​บุตรมนุษย์ แล้ว​มอบ​พระองค์​หื้อ​อยู่​ใน​อำนาจ​ของ​คน” ");
INSERT INTO nod_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","แต่​หมู่​สาวก​บ่﻿เข้าใจ๋​กำ​อู้​นั้น ย้อน​พระเจ้า​ยัง​บ่﻿เปิดเผย​หื้อ​ฮู้ เปื้อ​หมู่​เขา​จะ​ยัง​บ่﻿เข้าใจ๋​เตื้อ แต่​หมู่​เขา​ก็​บ่﻿ก้า​ถาม​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","แล้ว​มี​ก๋าน​เถียง​กั๋น​เกิด​ขึ้น​ใน​หมู่​สาวก​ว่า ใน​หมู่​เขา​ใผ​จะ​เป๋น​ใหญ่​ตี้​สุด ");
INSERT INTO nod_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","พระเยซู​ฮู้​ว่า​หมู่​เขา​กึ๊ด​อะหยัง จึง​เอา​หละอ่อน​หน้อย​คน​นึ่ง​มา​ยืน​ฮิม​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","แล้ว​บอก​หมู่​เขา​ว่า “ใผ​คน​ใด​ตี้​ต้อนฮับ​คน​ตี้​เป๋น​เหมือน​หละอ่อน​หน้อย​จาอี้​ย้อน​หัน​แก่​เฮา ก็​เผียบ​เหมือน​กับ​ว่า​คน​นั้น​ได้​ต้อนฮับ​เฮา​ตวย คน​ใด​ต้อนฮับ​เฮา​คน​นั้น​ก็​ได้​ต้อนฮับ​ผู้​ตี้​ใจ๊​เฮา​มา ย้อน​ว่า​ใผ​เล็ก​หน้อย​ตี้​สุด​ใน​หมู่​ต้าน คน​นั้น​ละ​เป๋น​ใหญ่​ตี้​สุด” ");
INSERT INTO nod_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ยอห์น​บอก​พระเยซู​ว่า “อาจ๋ารย์​ครับ หมู่​เฮา​หัน​คน​นึ่ง​ไล่​ผี​ออก​ใน​นาม​ของ​พระองค์ หมู่​เฮา​ก็​ห้าม​เขา ย้อน​เขา​บ่﻿ใจ้​หมู่​เฮา” ");
INSERT INTO nod_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","พระเยซู​บอก​ยอห์น​ว่า “บ่﻿ต้อง​ห้าม​เขา​เน่อ ย้อน​ว่า​ใผ​บ่﻿ต่อต้าน​หมู่​ต้าน เขา​ก็​เป๋น​หมู่​ของ​ต้าน​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","บ่ากอง​ใก้​เวลา​ตี้​พระเจ้า​จะ​ฮับ​พระองค์​ปิ๊ก​สวรรค์ พระองค์​ก็​ตั้งใจ๋​แน่วแน่​ตี้​จะ​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","พระองค์​ส่ง​บาง​คน​ล่วงหน้า​ไป​บอก​ข่าว​ตี้​หมู่​บ้าน​จาว​สะมาเรีย​ก่อน เปื้อ​เกียม​สิ่ง​ต่าง﻿ๆ หื้อ​พร้อม​สำหรับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","แต่​จาวบ้าน​บ่﻿ต้อนฮับ​พระองค์ ย้อน​หัน​ว่า​พระองค์​จะ​ซื่อ​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","เมื่อ​ยากอบ​กับ​ยอห์น​สาวก​ของ​พระองค์​หัน​จาอั้น ก็​ถาม​พระองค์​ว่า “องค์​พระผู้เป๋นเจ้า พระองค์​ใค่​หื้อ​หมู่​เฮา​ขอ​ไฟ​ลง​มา​จาก​สวรรค์​เผา​หมู่​เขา​เหีย​ดี​ก่อ” ");
INSERT INTO nod_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","พระองค์​เหลียว​หน้า​มา​ว่า​หื้อ​เขา ");
INSERT INTO nod_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","แล้ว​พระองค์​กับ​หมู่​สาวก​ก็​เข้า​ไป​แหม​หมู่​บ้าน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","เมื่อ​พระเยซู​กับ​หมู่​สาวก​ก่ำลัง​เตียว​ตาง​ไป ก็​มี​คน​นึ่ง​บอก​พระองค์​ว่า “ต้าน​ไป​ตาง​ใด ข้าพเจ้า​ขอ​ตวย​ต้าน​ไป​ตาง​นั้น” ");
INSERT INTO nod_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","พระเยซู​บอก​เขา​ว่า “หมาไน​ยัง​มี​ฮู​อยู่ นก​ใน​อากาศ​ยัง​มี​ฮัง​นอน แต่​บุตรมนุษย์​บ่﻿มี​ตี้​จะ​ซุก​หัว​นอน” ");
INSERT INTO nod_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","พระองค์​บอก​แหม​คน​ว่า “ตวย​เฮา​มา​เต๊อะ” คน​นั้น​ตอบ​ว่า “พระองค์​เจ้า​ข้า หื้อ​ข้าพเจ้า​ปิ๊ก​ไป​ฝัง​ศพ​ป้อ​ก่อน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","พระเยซู​บอก​เขา​ต่อ​ไป​ว่า “หื้อ​คน​ต๋าย​ฝัง​คน​ต๋าย​เอา​คน​เดียว​เต๊อะ แต่​ต้าน​จง​ไป​บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","แหม​คน​นึ่ง​บอก​พระองค์​ว่า “อาจ๋ารย์​ครับ ตั๋ว​เฮา​จะ​ไป​ตวย​เหมือน​กั๋น แต่​ขอ​ไป​ลา​ตัง​บ้าน​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","พระเยซู​จึง​บอก​เขา​ว่า “ใผ​ก๋ำ​ง้อนไถ แล้ว​งว้าย​หน้า​ปิ๊ก​เหีย คน​นั้น​ก็​บ่﻿เปิง​สำหรับ​แผ่นดิน​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","เมื่อ​เหตุก๋ารณ์​หมู่​นั้น​ล่วง​ป๊น​ไป​แล้ว พระเยซู​ก็​ตั้ง​สาวก​แหม​เจ็ด​สิบ​สอง​คน​ ใจ๊​เขา​ออก​ไป​เป๋น​กู้﻿ๆ หื้อ​ล่วงหน้า​ไป​ก่อน​พระองค์ เข้า​ไป​ใน​เมือง​กับ​หมู่บ้าน​ต่าง﻿ๆ ตี้​พระองค์​จะ​ไป ");
INSERT INTO nod_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","พระองค์​อู้​กับ​หมู่​สาวก​ว่า “มี​คน​นัก​ตี้​พร้อม​จะ​ฮับ​เจื้อ​เหมือน​ข้าว​เหลือง​เต๋ม​โต้ง แต่​คนงาน​ตี้​จะ​เกี่ยว​นั้น​ยัง​มี​หน้อย​ล้ำ​ไป ย้อน​จาอั้น​หื้อ​จ้วย​กั๋น​อ้อนวอน​ขอ​พระเจ้า​ผู้​เผียบ​เหมือน​เจ้า​ของ​นา หื้อ​ส่ง​คนงาน​มา​เปื้อ​จ้วย​กั๋น​เกี่ยว​พืช​ผล​ของ​พระองค์​ตวย ");
INSERT INTO nod_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ต้าน​ตังหลาย​จง​ออก​ไป​เต๊อะ เฮา​ส่ง​ต้าน​ออก​ไป​เผียบ​เหมือน​ส่ง​หมู่​ลูก​แกะ​เข้า​ไป​อยู่​ต้ามก๋าง​หมู่​หมา​ป่า ");
INSERT INTO nod_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","บ่﻿ต้อง​เอา​ถง​สตางค์ กาว่า​ถง​สะปาย กาว่า​เกิบ​แหม​กู้​นึ่ง​ไป กับ​ต๋าม​หน​ตาง​ก็​บ่﻿ต้อง​เสีย​เวลา​ตั๊กตวาย​ใผ ");
INSERT INTO nod_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ถ้า​จะ​เข้า​เฮือน​ใด​ก็​หื้อ​ปั๋น​ปอน​ว่า ‘ขอ​สันติสุข​จง​มี​แก่​เฮือน​นี้​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ถ้า​เขา​ฮัก​สันติสุข กำปอน​ของ​ต้าน​ก็​จะ​อยู่​กับ​เขา ถ้า​เขา​บ่﻿ฮัก​สันติสุข​กำปอน​นั้น​ก็​จะ​ปิ๊ก​คืน​มา​หา​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","จง​ย้าง​อยู่​ใน​เฮือน​นั้น​กิ๋น​ดื่ม​ของ​ตี้​เขา​หื้อ​นั้น ย้อน​ว่า​คน​ตี้​เยียะ​ก๋าน​ก็​สมควร​จะ​ได้ฮับ​ก้า​จ้าง บ่﻿ถ้า​ย้าย​จาก​เฮือน​นี้​ไป​อยู่​เฮือน​ปู๊น ");
INSERT INTO nod_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ถ้า​หมู่​ต้าน​เข้า​ไป​ใน​เมือง​ใด แล้ว​มี​คน​ต้อนฮับ​หมู่​ต้าน หื้อ​กิ๋น​ของกิ๋น​ตี้​เขา​จัด​ตั้ง​ไว้​นั้น ");
INSERT INTO nod_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","จง​ฮักษา​คน​ป่วย​ใน​เมือง​นั้น​หื้อ​หาย​ป่วย เวลา​ฮักษา​คน​ป่วย​ก็​หื้อ​สอน​หมู่​เขา​ว่า​แผ่นดิน​ของ​พระเจ้า​ใก้​เข้า​มา​แผว​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","แต่​ถ้า​หมู่​ต้าน​เข้า​ไป​เมือง​ใด แล้ว​คน​ใน​เมือง​นั้น​บ่﻿ต้อนฮับ​หมู่​ต้าน หื้อ​ออก​ไป​ก๋าง​กอง​เมือง​นั้น บอก​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘แม้แต่​ขี้ฝุ่น​ใน​เมือง​ของ​หมู่​เจ้า​ตี้​ติด​ตี๋น​หมู่​เฮา หมู่​เฮา​ก็​จะ​ปั๊ด​ออก​เปื้อ​แสดง​เถิง​ก๋าน​บ่﻿ยอมฮับ​หมู่​เจ้า แต่​หมู่​เจ้า​จง​เข้าใจ๋​ข้อความ​นี้​เต๊อะ คือ​แผ่นดิน​ของ​พระเจ้า​ใก้​มา​แผว​แล้ว’ ");
INSERT INTO nod_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","เฮา​บอก​หมู่​เจ้า​ว่า โต้ษ​ของ​เมือง​โสโดม​ใน​วัน​ตี้​พระเจ้า​ตัดสิน​ลงโต้ษ​บาป ยัง​จะ​เบา​เหลือ​โต้ษ​ของ​เมือง​นั้น​แหม ");
INSERT INTO nod_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​เมือง​โคราซิน เมือง​เบธไซดา ย้อน​ถ้า​เฮา​ไป​เยียะ​ก๋าน​อัศจ๋รรย์​แบบ​เดียว​กั๋น​นี้​ตี้​เมือง​ไทระ​กับ​เมือง​ไซดอน คน​ตังหลาย​ตี้​หั้น​ก็​จะ​กลับใจ๋​จาก​บาป ปา​กั๋น​นุ่ง​ผ้า​กระสอบ นั่ง​ลง​เอา​ขี้เต้า​ผุก​ใส่​หัว​ตั๋ว​เก่า​ไป​เมิน​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ใน​วัน​ตัดสิน​ลงโต้ษ​บาป โต้ษ​ของ​เมือง​ไทระ​กับ​เมือง​ไซดอน จะ​เบา​เหลือ​โต้ษ​ของ​หมู่​เจ้า ");
INSERT INTO nod_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ส่วน​เมือง​คาเปอรนาอุม​เจ้า​กึ๊ด​ว่า​เจ้า​จะ​ถูก​ยก​ขึ้น​เปียง​ฟ้า​กา บ่﻿ใจ้​เน่อ แต่​หมู่​เจ้า​จะ​ตก​ลง​ไป​เถิง​แดน​คน​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","พระเยซู​บอก​หมู่​สาวก​ว่า “คน​ตี้​ฟัง​ต้าน​ตังหลาย​ก็​ได้​ฟัง​เฮา คน​ตี้​บ่﻿ยอมฮับ​ต้าน​ตังหลาย ก็​บ่﻿ยอมฮับ​เฮา คน​ตี้​บ่﻿ยอมฮับ​เฮา​ก็​บ่﻿ยอมฮับ​ผู้​ตี้​ใจ๊​เฮา​มา” ");
INSERT INTO nod_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","หมู่​สาวก​เจ็ด​สิบ​สอง​คน​นั้น​ก็​ปิ๊ก​มา​ด้วย​ความ​จื้นจมยินดี บอก​พระองค์​ว่า “องค์​พระผู้เป๋นเจ้า แม้​แต่​หมู่​ผี หมู่​เฮา​ก็​บังคับ​โดย​นาม​ของ​พระองค์​ได้” ");
INSERT INTO nod_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","พระองค์​บอก​หมู่​เขา​ว่า “เฮา​ได้​หัน​ซาต๋าน​ตก​ลง​จาก​ฟ้า​เหมือน​ฟ้า​แมบ ");
INSERT INTO nod_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ฟัง​เน่อ เฮา​ได้​หื้อ​หมู่​ต้าน​มี​อำนาจ​ย่ำ​งู​ปิ๊ด​กับ​แมงป่อง​ได้ ตึง​หื้อ​มี​อำนาจ​ยิ่งใหญ่​เหลือ​ศัตรู๋​ของ​พระเจ้า บ่﻿มี​สิ่ง​ใด​เยียะ​อันตราย​ต้าน​ได้​สัก​อย่าง ");
INSERT INTO nod_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","บ่﻿ถ้า​จื้นจมยินดี​ใน​เรื่อง​ตี้​ต้าน​บังคับ​ผี​ได้ แต่​หื้อ​ยินดี​ตี้​จื้อ​ของ​หมู่​ต้าน​จด​ไว้​แล้ว​ใน​สวรรค์” ");
INSERT INTO nod_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ต๋อน​นั้น พระเยซู​มี​ความ​สุข​ตี้​เกิด​จาก​พระวิญญาณ​บริสุทธิ์ จึง​อู้​ว่า “ข้า​แต่​พระบิดา ผู้​เป๋น​เจ้า​ของ​ฟ้า​สวรรค์​กับ​แผ่นดิน​โลก ข้า​พระองค์​ขอ​สรรเสริญ​พระองค์ ย้อน​ว่า​พระองค์​ได้​ปิดบัง​เรื่อง​ต่าง﻿ๆ หมู่​นี้ บ่﻿หื้อ​ผู้​มี​ผญา​ปั๋ญญา กับ​ผู้​มี​ก๋าน​ศึกษา​ได้​ฮู้ แต่​ได้​เปิด​เผย​หื้อ​กับ​หมู่​คน​ตี้​ถ่อมใจ๋​เป๋น​เหมือน​หละอ่อน​หน้อย﻿ๆ ข้า​แต่​พระบิดา​เจ้า แม่น​แล้ว พระองค์​ปอใจ๋​ตี้​จะ​เยียะ​จาอั้น ");
INSERT INTO nod_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“พระบิดา​ได้​มอบ​สิทธิ​อำนาจ​เหนือ​กู้​สิ่ง​กู้​อย่าง​หื้อ​เฮา บ่﻿มี​ใผ​ฮู้จัก​พระบุตร​ว่า​เป๋น​ใผ​นอก​จาก​พระบิดา บ่﻿มี​ใผ​ฮู้จัก​พระบิดา​ว่า​เป๋น​ใผ​นอก​จาก​พระบุตร กับ​คน​ตี้​พระบุตร​ต้องก๋าน​เปิดเผย​หื้อ​ฮู้จัก​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","พระเยซู​เหลียว​ไป​ผ่อ​หมู่​สาวก อู้​ก้า​หมู่​เขา​เต้าอั้น​ว่า “คน​ตี้​ได้​หัน​ใน​สิ่ง​ตี้​หมู่​ต้าน​ได้​หัน​ก็​เป๋น​สุข ");
INSERT INTO nod_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","เฮา​บอก​ต้าน​ตังหลาย​ว่า​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​กับ กษัตริย์​หลาย​องค์​ใค่​หัน​สิ่ง​ตี้​ต้าน​ตังหลาย​หัน แต่​ก็​บ่﻿เกย​หัน ใค่​ได้ยิน​สิ่ง​ตี้​ต้าน​ตังหลาย​ได้ยิน แต่​ก็​บ่﻿เกย​ได้ยิน” ");
INSERT INTO nod_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","มี​ผู้​ชำนาญ​บท​บัญญัติ​คน​นึ่ง​ยืน​ขึ้น​ลองเจิง​พระองค์​ถาม​ว่า “อาจ๋ารย์ ข้าพเจ้า​จะ​ต้อง​เยียะ​ความ​ดี​อะหยัง​พ่อง เถิง​จะ​ได้​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","พระองค์​ตอบ​เขา​ว่า “ใน​บท​บัญญัติ​ของ​โมเสส​มี​กำเขียน​ไว้​จาใด​พ่อง ต้าน​อ่าน​แล้ว​เข้าใจ๋​อย่างใด” ");
INSERT INTO nod_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","เขา​ตอบ​พระองค์​ว่า “จง​ฮัก​องค์​พระผู้เป๋นเจ้า พระเจ้า​ของ​ต้าน​จ๋น​สุด​จิต​สุด​ใจ๋ สุด​ก่ำลัง กับ​สุด​ผญา​ปั๋ญญา​ของ​เจ้า กับ​จง​ฮัก​เปื้อน​บ้าน​เหมือน​ฮัก​ตั๋ว​เก่า” ");
INSERT INTO nod_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","พระองค์​จึง​อู้​กับ​เขา​ว่า “ต้าน​ตอบ​ถูก​แล้ว จง​เยียะ​จาอั้น แล้ว​จะ​ได้​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","แต่​คน​นั้น​ใค่​แสดง​ว่า​ตั๋ว​ดี จึง​ถาม​พระเยซู​ว่า “ใผ​เป๋น​เปื้อน​บ้าน​ของ​ข้าพเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","พระเยซู​ตอบ​ว่า “มี​ป้อจาย​คน​นึ่ง​ออก​จาก​กรุง​เยรูซาเล็ม​ไป​เมือง​เยรีโค เขา​ถูก​หมู่​โจ๋ร​ปล้น โจ๋ร​นั้น​ได้​ลู่​เอา​เสื้อผ้า​ของ​เขา บุบ​ตี๋​เขา แล้ว​ละ​เขา​ไว้​ตี้​หั้น​จ๋น​เกือบ​จะ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ปอดี​ปุโรหิต​คน​นึ่ง​เตียว​ไป​ตัง​นั้น หัน​ใส่​คน​นั้น​ก็​เตียว​เว้น​ไป​แหม​เผิก​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","คน​นึ่ง​ใน​หมู่​เลวี​ก็​เยียะ​อย่าง​เดียว​กั๋น เมื่อ​มา​เถิง​ตี้​หั้น หัน​ใส่​คน​นั้น​แล้ว​ก็​เว้น​ไป​แหม​เผิก​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","แต่​มี​จาว​สะมาเรีย​คน​นึ่ง​เมื่อ​เตียว​มา​เถิง​คน​นั้น หัน​ใส่​เขา​แล้ว ก็​มี​ใจ๋​อินดู ");
INSERT INTO nod_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","เข้า​ไป​ฮักษา​เขา​โดย​เอา​น้ำมัน​กับ​เหล้า​องุ่น​ถอก​ใส่​แผล แล้ว​เอา​ผ้า​มา​ปัน​แผล​หื้อ กับ​เอา​เขา​ขึ้น​ขี่​ลา​ของ​ตั๋ว ปา​มา​ตี้​โรงแรม​แห่ง​นึ่ง​และ​ฮักษา​พยาบาล​เขา ");
INSERT INTO nod_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","แจ้ง​เจ๊า​มา​เมื่อ​จะ​ไป​ต่อ​แหม จาว​สะมาเรีย​คน​นั้น​ก็​เอา​สตางค์​สอง​เดนาริอัน​หื้อ​เจ้า​ของ​โรงแรม​ไว้ บอก​ว่า ‘ฮักษา​เขา​เต๊อะ สตางค์​ตี้​ต้อง​เสีย​นัก​เหลือ​นี้ เมื่อ​เฮา​ปิ๊ก​มา​จะ​เตื่อม​หื้อ​แหม’ ” ");
INSERT INTO nod_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","พระเยซู​ก็​ถาม​ธรรมาจ๋ารย์​คน​นั้น​ว่า “สาม​คน​นั้น ต้าน​กึ๊ด​ว่า​คน​ใด​เป๋น​เปื้อน​บ้าน​ของ​คน​ตี้​ถูก​ปล้น” ");
INSERT INTO nod_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","เขา​ตอบ​ว่า “ก็​คน​ตี้​เมตต๋า​เขา​นั่น​ละ” พระเยซู​จึง​บอก​เขา​ว่า “ต้าน​จง​ไป​เยียะ​เหมือน​จาอั้น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","เมื่อ​พระเยซู​กับ​หมู่​สาวก​ก่ำลัง​เตียวตาง​ต่อ​ไป​กรุง​เยรูซาเล็ม​นั้น ก็​เข้า​ไป​ตี้​หมู่​บ้าน​นึ่ง มี​แม่ญิง​คน​นึ่ง​จื้อ​มารธา ต้อนฮับ​พระองค์​ไว้​ตี้​เฮือน​ของ​นาง ");
INSERT INTO nod_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","มารธา​มี​น้อง​สาว​คน​นึ่ง​จื้อ​มารีย์ มารีย์​ก็​มา​นั่ง​ฮิม​ตี๋น​พระเยซู​ฟัง​กำ​สั่ง​สอน​จาก​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","มารธา​เมา​เยียะ​ว่า​เยียะ​กิ๋น​อยู่​คน​เดียว จึง​เอิ้น​ถาม​พระเยซู​ว่า “อาจ๋ารย์​เจ้า อาจ๋ารย์​บ่﻿สนใจ๋​กา ตี้​น้องสาว​ปล่อย​ข้าเจ้า​เยียะ​ก๋าน​คน​เดียว ขอ​บอก​เขา​มา​จ้วย​ข้าเจ้า​น่อย” ");
INSERT INTO nod_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","พระเยซู​ตอบ​นาง​ว่า “มารธา​เหย เจ้า​กระวน​กระวาย​กับ​ฮ้อนใจ๋​ใน​หลาย​อย่าง​ล้ำ​ไป ");
INSERT INTO nod_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","สิ่ง​ตี้​จ๋ำ​เป๋น​มี​สิ่ง​เดียว​เต้าอั้น มารีย์​ได้​เลือก​เอา​สิ่ง​ดี​อัน​นั้น ใผ​จะ​ลู่​เอา​ไป​จาก​เขา​ตึง​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","มี​วัน​นึ่ง​พระเยซู​อธิษฐาน​อยู่​ใน​ตี้​แห่ง​นึ่ง เมื่อ​อธิษฐาน​จบ​แล้ว​สาวก​คน​นึ่ง​บอก​พระองค์​ว่า “อาจ๋ารย์​ครับ ขอ​สอน​หมู่​เฮา​อธิษฐาน เหมือน​ตี้​ยอห์น​ผู้​หื้อ​บัพติศมา​สอน​สาวก​ของ​เขา​พ่อง” ");
INSERT INTO nod_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","พระองค์​บอก​หมู่​เขา​ว่า “เมื่อ​อธิษฐาน​หื้อ​ว่า ‘ข้า​แต่​พระบิดา​ขอ​หื้อ​นาม​ของ​พระองค์​เป๋น​ตี้​นับถือ ขอ​หื้อ​แผ่นดิน​ของ​พระองค์​มา​ตั้ง​อยู่ ");
INSERT INTO nod_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ขอ​โผด​หื้อ​ข้า​พระองค์​ตังหลาย​มี​อาหาร​กิ๋น​ตึง​วัน ");
INSERT INTO nod_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ขอ​โผด​ยก​โต้ษ​บาป​ของ​ข้า​พระองค์​ตังหลาย เหมือน​ข้า​พระองค์​ยกโต้ษ​หื้อ​คน​ตี้​เยียะ​บาป​ต่อ​ข้า​พระองค์​นั้น ขอ​บ่﻿หื้อ​ปา​ข้า​พระองค์​ตังหลาย เข้า​ไป​หา​ก๋าน​ลองใจ๋’ ” ");
INSERT INTO nod_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","พระองค์​อู้​กับ​หมู่​เขา​ว่า “สมมุติ​คน​นึ่ง​ใน​หมู่​ต้าน​ไป​หา​เสี่ยว​คน​นึ่ง​ตี้​บ้าน​ใน​เวลา​เตี้ยงคืน อู้​กับ​เขา​ว่า ‘เสี่ยว​เหย​ขอ​ยืม​เข้าหนมปัง​สัก​สาม​ก้อน​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","เปื้อน​เฮา​คน​นึ่ง​ก้า​หา​เตียวตาง​มา​เถิง เฮา​บ่﻿มี​อะหยัง​จะ​หื้อ​เขา​กิ๋น’ ");
INSERT INTO nod_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","แล้ว​เสี่ยว​ตี้​อยู่​ตัง​ใน​บ้าน​ก็​ตอบ​ว่า ‘ห้าม​มา​รบก๋วน​กั๋น​เต๊อะ ปะตู๋​บ้าน​ก็​หับ​แล้ว หมู่​ลูก﻿ๆ กับ เฮา​ก่ำลัง​จะ​หลับ เฮา​ลุก​ไป​เอา​หื้อ​เสี่ยว​บ่﻿ได้’ ");
INSERT INTO nod_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","เฮา​บอก​ต้าน​ตังหลาย​ว่า เถิงแม้​ว่า​เป๋น​เสี่ยว​กั๋น เขา​ก็​ยัง​บ่﻿ลุก​มา​เอา​หื้อ แต่​ย้อน​คน​นั้น​ตื๊อ​ฮ้อง​ติก﻿ๆ เสี่ยว​คน​นั้น​จึง​ลุก​ขึ้น​มา​เอา​หื้อ​ต๋าม​ตี้​ต้องก๋าน ");
INSERT INTO nod_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","เฮา​จึง​บอก​ต้าน​ตังหลาย​ว่า จง​ขอ​แล้ว​จะ​ได้ จง​เซาะ​แล้ว​จะ​ปะ จง​ฮ้อง​ตี้​ปะตู๋​แล้ว​จะ​เปิด​หื้อ ");
INSERT INTO nod_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ย้อน​ว่า​กู้​คน​ตี้​ขอ​ก็​จะ​ได้ กู้​คน​ตี้​เซาะ​ก็​จะ​ปะ กู้​คน​ตี้​ฮ้อง​ตี้​ปะตู๋​ก็​จะ​เปิด​หื้อ​เขา ");
INSERT INTO nod_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","มี​ใผ​ใน​หมู่​ต้าน​ตี้​เป๋น​ป้อ ถ้า​ลูก​ขอ​ป๋า​จะ​เอา​งู​ปิ๊ด​หื้อ​แตน​กา ถ้า​ขอ​ไข่​จะ​เอา​แมงป่อง​หื้อ​เขา​กา ");
INSERT INTO nod_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ย้อน​ว่า​ต้าน​ตังหลาย​ตี้​เป๋น​คน​บาป​ก็​ยัง​ฮู้จัก​เอา​ของ​ดี﻿ๆ หื้อ​ลูก แล้ว​นัก​เหลือ​นั้น พระบิดา​ตี้​อยู่​ใน​สวรรค์​จะ​บ่﻿หื้อ​พระวิญญาณ​บริสุทธิ์​กับ​คน​ตี้​ขอ​จาก​พระองค์​กา” ");
INSERT INTO nod_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","วัน​นึ่ง​พระเยซู​ไล่​ผี​ตี้​เยียะ​หื้อ​คน​เป๋น​ใบ้​ออก​จาก​ป้อจาย​คน​นึ่ง แล้ว​เขา​ก็​อู้​ได้ คน​ตังหลาย​ก็​ปา​กั๋น​งืด ");
INSERT INTO nod_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","แต่​บาง​คน​ใน​หมู่​เขา​อู้​ว่า “คน​นี้​ไล่​ผี​ออก​ได้​โดย​ใจ๊​อำนาจ​ของ​เบเอลเซบูล​หัวหน้า​ผี” ");
INSERT INTO nod_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ซ้ำ​คน​ก็​จะ​มา​ทดลอง​พระองค์ ขอ​หื้อ​พระองค์​เยียะ​หมายสำคัญ​จาก​ฟ้า​สวรรค์​หื้อ​ผ่อ เปื้อ​จะ​ฮู้​ว่า​พระองค์​มา​จาก​พระเจ้า​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","แต่​พระองค์​ฮู้​กำกึ๊ด​ใน​ใจ๋​ของ​เขา​จึง​อู้​ว่า “อาณาจักร​ใด​ถ้า​แตกแยก​กั๋น​จะ​ฉิบหาย ครอบครัว​ใด​แตก​กั๋น​ก็​ฉิบหาย ");
INSERT INTO nod_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ถ้า​ซาต๋าน​แตกแยก​กั๋น​ใน​หมู่​ของ​มัน อาณาจักร​ของ​มัน​จะ​ตั้ง​อยู่​ได้​จาใด ต้าน​ตังหลาย​ว่า​เฮา​ไล่​ผี​ออก​โดย​ใจ๊​อำนาจ​ของ​เบเอลเซบูล ");
INSERT INTO nod_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","แต่​ถ้า​เฮา​ไล่​ผี​ออก​โดย​ใจ๊​อำนาจ​ของ​เบเอลเซบูล หมู่​ของ​ต้าน​ไล่​ผี​ออก​โดย​ใจ๊​อำนาจ​ของ​ใผ จาอั้น​หมู่​ของ​ต้าน​นั้น​ละ จะ​เป๋น​ผู้​ตัดสิน​เรื่อง​นี้​ได้ ");
INSERT INTO nod_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","แต่​ถ้า​เฮา​ไล่​ผี​ออก​โดย​อำนาจ​ของ​พระเจ้า แสดง​ว่า​แผ่นดิน​ของ​พระองค์​ก็​มา​เถิง​หมู่​ต้าน​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“เมื่อ​คน​ตี้​มี​ก่ำลัง ก๋ำ​อาวุธ​เฝ้า​เฮือน​ของ​ตั๋ว​อยู่ สิ่ง​ของ​ของ​เขา​ก็​จะ​มี​อยู่​โดย​บ่﻿มี​อันตราย ");
INSERT INTO nod_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","แต่​เมื่อ​มี​คน​ตี้​มี​ก๋ำลัง​นัก​เหลือ​เขา เข้า​มา​ต่อ​สู้​แล้ว​เขา​ก๊าน คน​นั้น​ก็​จะ​ลู่​อาวุธ​ตี้​เขา​วางใจ๋​ไป​เหีย แล้ว​เก็บ​เอา​สิ่ง​ของ​ทรัพย์​สมบัติ​ของ​เขา​ไป​แบ่ง​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ถ้า​ใผ​บ่﻿ได้​อยู่​ฝ่าย​เดียว​กับ​เฮา​ก็​เป๋น​ศัตรู๋​ต่อ​เฮา ใผ​บ่﻿ได้​จ้วย​ฮ้อง​คน​เข้า​มา​เปาะ​มา​ต้อม​กับ​เฮา ก็​เป๋น​คน​เยียะ​หื้อ​คน​แตก​ขะแล​ขะแจ​ไป ");
INSERT INTO nod_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ผี​ฮ้าย​ตั๋ว​นึ่ง เมื่อ​ออก​จาก​ตั๋ว​ของ​คน​ไป​แล้ว ก็​ฮ่อน​ไป​ต๋าม​ตี้​กั๋นดาร​แห้งแล้ง​เปื้อ​เซาะ​หา​ตี้​อยู่​ใหม่ แต่​ก็​เซาะ​หา​บ่﻿ปะ ผี​ฮ้าย​ตั๋ว​นั้น​เลย​อู้​ขึ้น​ว่า ‘ข้า​จะ​ปิ๊ก​ไป​เฮือน​หลัง​เก่า​ตี้​ได้​ออก​มา​แล้ว​ดี​กว่า’ ");
INSERT INTO nod_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","เมื่อ​ปิ๊ก​มา​แล้ว​ก็​หัน​ว่า เฮือน​หลัง​เก่า​นั้น​เผี้ยว​สะอาด​เรียบร้อย​ดี ");
INSERT INTO nod_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ผี​ตั๋ว​นั้น​ก็​ไป​จวน​ผี​ตั๋ว​อื่น﻿ๆ แหม​เจ็ด​ตั๋ว​ตี้​ฮ้าย​เหลือ​มัน​แหม แล้ว​ปา​กั๋น​เข้า​มา​อยู่​ใน​เฮือน​หลัง​นั้น สุดต๊าย​แล้ว​คน﻿ๆ นั้น​ก็​ซ้ำ​ฮ้าย​เหลือ​เก่า​แหม” ");
INSERT INTO nod_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","เมื่อ​พระเยซู​ก่ำลัง​อู้​อยู่ มี​แม่ญิง​คน​นึ่ง​ใน​คน​ตังหลาย​ฮ้อง​บอก​พระองค์​ว่า “แม่​ตี้​เกิด​พระองค์​และ​หื้อ​กิ๋น​นม ก็​เป๋น​สุข” ");
INSERT INTO nod_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","แต่​พระองค์​อู้​ว่า “คน​ตังหลาย​ตี้​ได้ยิน​ถ้อยกำ​ของ​พระเจ้า แล้ว​เยียะ​ต๋าม​ถ้อยกำ​นั้น ก็​เป๋น​สุข​เหลือ​นั้น​แหม​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","เมื่อ​คน​ปา​กั๋น​มา​นัก​ขึ้น​แหม พระองค์​ก็​อู้​ว่า “คน​สมัย​นี้​เป๋น​คน​บ่﻿ดี มี​ก้า​ผ่อ​หา​หมายสำคัญ​เต้าอั้น แต่​เฮา​จะ​บ่﻿เยียะ​หื้อ​หัน​เน่อ นอก​จาก​หมายสำคัญ​ตี้​เกิด​ขึ้น​กับ​โยนาห์​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ย้อน​ว่า​สิ่ง​ตี้​เกิด​ขึ้น​กับ​โยนาห์​ได้​เป๋น​หมายสำคัญ​หื้อ​จาว​เมือง​นีนะเวห์​ฮู้​ว่า พระเจ้า​ได้​ส่ง​เขา​ไป ก็​เหมือน​กั๋น​กับ​สิ่ง​ตี้​จะ​เกิด​ขึ้น​กับ​บุตรมนุษย์​ก็​เป๋น​หมายสำคัญ​หื้อ​คน​ใน​สมัย​นี้​ฮู้ ");
INSERT INTO nod_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ใน​วัน​ตี้​พระเจ้า​จะ​ตัดสิน​โลก พระราชินี​ของ​ตัง​ใต้​ ก็​จะ​ยืน​ขึ้น​นาบโต้ษ​คน​ใน​สมัย​นี้ ย้อน​ว่า​พระนาง​ได้​มา​จาก​ตี้​สุด​ป๋าย​แผ่นดิน​โลก เปื้อ​จะ​มา​ฟัง​สติ​ปั๋ญญา​ของ​กษัตริย์​ซาโลมอน แต่​บ่าเดี่ยว​นี้​คน​ตี้​เป๋น​ใหญ่​เหลือ​กษัตริย์​ซาโลมอน​อยู่​ตี้​นี่ แล้ว​หมู่​ต้าน​ก็​บ่﻿ยอม​ฟัง ");
INSERT INTO nod_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","จาว​เมือง​นีนะเวห์​จะ​ยืน​ขึ้น​นาบโต้ษ​คน​สมัย​นี้ ใน​วัน​ตี้​พระเจ้า​ตัดสิน​โลก ย้อน​ว่า​เขา​ตังหลาย​ได้​กลับใจ๋​จาก​บาป​เมื่อ​โยนาห์​ไป​สั่ง​สอน​หมู่​เขา แต่​ต๋อน​นี้​คน​ตี้​เป๋น​ใหญ่​เหลือ​โยนาห์​อยู่​ส่อง​หน้า​หมู่​ต้าน แต่​ยัง​บ่﻿มี​ใผ​กลับใจ๋​จาก​บาป​สัก​คน ");
INSERT INTO nod_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“บ่﻿มี​ใผ​เมื่อ​ต๋าม​โกม​ไฟ​แล้ว​จะ​เอา​ตั้ง​ไว้​ตี้​ลับ​ตี้​บัง กาว่า​เอา​ถัง​ควบ​ไว้​แต่​จะ​ตั้ง​ไว้​บน​ตั่ง เปื้อ​คน​ตังหลาย​ตี้​เข้า​มา​จะ​หัน​เป่งแจ้ง​ได้ ");
INSERT INTO nod_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","แก่นต๋า​เผียบ​เหมือน​โกม​ไฟ​ส่อง​แจ้ง​ใน​ตั๋ว​ของ​คน​เฮา ถ้า​แก่นต๋า​ของ​ต้าน​ดี ตึง​เนื้อ​ตึง​ตั๋ว​ก็​เป่งแจ้ง​ไป​หมด ถ้า​แก่นต๋า​ของ​ต้าน​บ่﻿ดี ตึง​ตั๋ว​ของ​ต้าน​ก็​จะ​มืด​หมด ");
INSERT INTO nod_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ย้อน​จาอั้น​จง​หละวัง​หื้อ​ดี หละวัง​ความ​เป่งแจ้ง​ตี้​ต้าน​กึ๊ด​ว่า​อยู่​ใน​ตั๋ว​เป๋น​ความ​มืด ");
INSERT INTO nod_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ถ้า​ตั๋ว​ของ​ต้าน​ตึง​หมด​มี​ก้า​ความ​เป่งแจ้ง​บ่﻿มี​ความ​มืด​เลย ก็​จะ​แจ้ง​ไป​หมด​เหมือน​กับ​โกม​ไฟ​ตี้​ส่อง​มา​หา​ต้าน​นั้น” ");
INSERT INTO nod_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","เมื่อ​พระองค์​อู้​เสร็จ​แล้ว มี​คน​นึ่ง​ใน​หมู่​ฟาริสี​เจิญ​พระองค์​ไป​กิ๋น​ข้าว​ตวย​กั๋น​ตี้​บ้าน พระองค์​ก็​เข้า​ไป​แล้ว​นั่ง​ลง​กิ๋น​ตวย​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","เมื่อ​ฟาริสี​คน​นั้น​หัน​ว่า พระเยซู​บ่﻿ได้​เยียะ​พิธี​ซ่วย​มือ​ก่อน​กิ๋น​ข้าว เขา​ก็​แปลกใจ๋ ");
INSERT INTO nod_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","พระองค์​อู้​กับ​เขา​ว่า “หมู่​ฟาริสี​ล้าง​ถ้วย​จาน​ก้า​ตัง​นอก​เต้าอั้น แต่​ตัง​ใน​นั้น​มี​ก้า​ความ​โลภ​กับ​ก๋าน​บ่﻿ดี ");
INSERT INTO nod_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","หมู่​คน​ง่าว พระเจ้า​ผู้​สร้าง​ตัง​นอก​ก็​ได้​สร้าง​ตัง​ใน​ตวย​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","จง​เอา​ของ​ตี้​อยู่​ใน​ถ้วย​จาน​หื้อ​คน​ตุ๊กยาก แล้ว​กู้​อย่าง​ก็​จะ​สะอาด​บริสุทธิ์​สำหรับ​เจ้า ");
INSERT INTO nod_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ฟาริสี​ย้อน​หมู่​เจ้า​ถวาย​สิบลด​จาก​หอมด่วน ขมิ้น กับ​หมู่​เครื่องเทศ แต่​บ่﻿สนใจ๋​ความ​ยุติธรรม​กับ​ความ​ฮัก​ต่อ​พระเจ้า ก๋าน​ถวาย​สิบลด​เจ้า​ก็​ควร​เยียะ​อยู่ แต่​บ่﻿ดี​ละ​สิ่ง​สำคัญ​หมู่​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ฟาริสี ย้อน​เจ้า​ซอบ​นั่ง​ตั๊ด​ตี้​สำคัญ​ใน​ธรรมศาลา​ของ​จาว​ยิว กับ​ซอบ​หื้อ​คน​ไหว้​ก๋าง​กาด​ก๋าง​ลี ");
INSERT INTO nod_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​เจ้า​ตังหลาย ย้อน​หมู่​เจ้า​เผียบ​เหมือน​อุโมงค์​ฝัง​ศพ​ตี้​คน​บ่﻿ฮู้​ว่า​มี​ศพ​ฝัง​อยู่​หั้น คน​จะ​เตียว​ย่ำ​ไป​ย่ำ​มา​โดย​บ่﻿ฮู้​เรื่อง” ");
INSERT INTO nod_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ผู้​ชำนาญ​บท​บัญญัติ​คน​นึ่ง​บอก​พระองค์​ว่า “อาจ๋ารย์ ตี้​ต้าน​ว่า​จาอั้น ต้าน​ก็​ดู​แควน​หมู่​เฮา​ตวย​ก่า” ");
INSERT INTO nod_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","พระองค์​ก็​บอก​เขา​ว่า “ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ผู้​ชำนาญ​บท​บัญญัติ​ตวย ย้อน​หมู่​เจ้า​ตั้ง​กฎ​ตี้​ยาก﻿ๆ หื้อ​คน​ตังหลาย​แบก​ไว้ แต่​หมู่​เจ้า​นั้น​ก็​บ่﻿ยอม​จ้วย​จิ​สัก​หน้อย ");
INSERT INTO nod_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​เจ้า​ตังหลาย ย้อน​หมู่​เจ้า​ได้​แป๋ง​อุโมงค์​ฝัง​ศพ​ตี้​เปิง​กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า แต่​ป้อ​อุ๊ย​แม่​หม่อน ของ​หมู่​เจ้า​นั้น​ละ​เป๋น​คน​ฆ่า​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​หมู่​นั้น ");
INSERT INTO nod_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ตี้​หมู่​เจ้า​เยียะ​นั้น​ก็​แสดง​ว่า​หมู่​เจ้า​หัน​ดี​หัน​งาม​กับ​สิ่ง​ตี้​ป้ออุ๊ย​แม่หม่อน​ได้​เยียะ หมู่​เขา​ฆ่า​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า แล้ว​หมู่​เจ้า​ก็​มา​แป๋ง​อุโมงค์​ฝังศพ​หื้อ ");
INSERT INTO nod_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ย้อน​จาอั้น พระเจ้า​ได้​อู้​ต๋าม​ปั๋ญญา​ของ​พระองค์​ว่า ‘เฮา​จะ​ส่ง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​เฮา​กับ​หมู่​อัคร​สาวก​ไป​หา​หมู่​เขา หมู่​เขา​ก็​จะ​ฆ่า​เหีย​พ่อง จะ​ค่ำ​เหีย​พ่อง’ ");
INSERT INTO nod_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ย้อน​จาอั้น​คน​ใน​ยุค​นี้​นี่​ละ จะ​ต้อง​ฮับ​โต้ษ​ตี้​ได้​ฆ่า​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตึงหมด​ตั้งแต่​เมื่อ​เก๊า​สร้าง​โลก ");
INSERT INTO nod_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","คือ​ตั้งแต่​อาแบล​จ๋น​เถิง​เศคาริยาห์​ตี้​ถูก​ฆ่า​ต๋าย​หละหว่าง​พระวิหาร​กับ​แต้น​ปู่จา เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ใน​ยุค​นี้​จะ​ต้อง​ฮับ​โต้ษ​ตี้​ได้​ฆ่า​คน​หมู่​นั้น​อย่าง​แน่​นอน ");
INSERT INTO nod_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​ผู้​ชำนาญ​บท​บัญญัติ ย้อน​ว่า​หมู่​เจ้า​เอา​ลูก​ขะแจ๋​แห่ง​ความ​ฮู้​เรื่อง​พระเจ้า​ไป​ซ่อน​ไว้​เหีย แต่​หมู่​เจ้า​ก็​บ่﻿ยอม​เข้า​ไป คน​อื่น​ฮิ​จะ​เข้า​ไป หมู่​เจ้า​เอง​ก็​ขวาง​ไว้​เหีย” ");
INSERT INTO nod_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","เมื่อ​พระเยซู​ออก​มา​จาก​บ้าน​ฟาริสี​คน​นั้น​แล้ว หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี​ก็​ตั้งเก๊า​ต่อต้าน​พระองค์​อย่าง​แฮง​กับ​หลุ้ม​ถาม​พระองค์​หลาย​อย่าง ");
INSERT INTO nod_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","หมู่​เขา​หวัง​จะ​ยับ​ผิด​เอา​จาก​กำ​ของ​พระองค์ เปื้อ​จะ​ฟ้อง​พระองค์​ได้ ");
INSERT INTO nod_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","กำ​นั้น​มี​คน​นัก​เป๋น​ปัน﻿ๆ คน​มา​จุมนุม​ยัด​กั๋น​อยู่ พระเยซู​อู้​กับ​หมู่​สาวก​ของ​พระองค์​ก่อน​ว่า “ต้าน​ตังหลาย​จง​หละวัง​เจื๊อฟู​ของ​หมู่​ฟาริสี คือ​ความ​หน้า​ซื่อ​ใจ๋​ก๊ด ");
INSERT INTO nod_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","แต่​กู้​อย่าง​ตี้​ปิดบัง​ซุก​ไว้​จะ​เปิด​หื้อ​หัน ตึง​ตี้​เป๋น​ความ​ลับ​กู้​อย่าง​จะ​ถูก​เปิดเผย​ออก​มา​หมด​หลึ้ง ");
INSERT INTO nod_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ย้อน​จาอั้น​กู้​สิ่ง​ตี้​ต้าน​อู้​ใน​ตี้​มืด คน​จะ​ได้ยิน​ใน​ตี้​แจ้ง กับ​สิ่ง​ตี้​ต้าน​ซูบซาบ​ตี้​หู​ใน​ห้อง​ส่วน​ตั๋ว จะ​มี​คน​เอิ้น​บอก​บน​ดาดฟ้า​หลังคา​ตึก ");
INSERT INTO nod_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“เปื้อน​ของ​เฮา​เหย เฮา​ขอ​บอก​ต้าน​ตังหลาย​ว่า​บ่﻿ต้อง​กั๋ว​คน​ตี้​ฆ่า​ได้​ก้า​ตั๋ว แล้ว​เมื่อ​ลูน​มา​ก็​เยียะ​อะหยัง​ต้าน​แหม​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","แต่​เฮา​จะ​เตื๋อน​หื้อ​ฮู้​ก่อน​ว่า​สมควร​จะ​กั๋ว​ใผ หื้อ​กั๋ว​พระเจ้า​ผู้​ตี้​ฆ่า​ต้าน​ได้ แล้ว​ยัง​มี​ฤทธิ์​อำนาจ​จะ​เอา​โจ้ง​ลง​หม้อหน้าฮก​ได้​แหม หื้อ​กั๋ว​พระองค์​นั้น​ละ ");
INSERT INTO nod_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","นกจอก​ห้า​ตั๋ว​เปิ้น​ขาย​กั๋น​สอง​บาท​บ่﻿ใจ้​กา แม้​นก​ตั๋ว​เดียว​พระเจ้า​ก็​บ่﻿ลืม ");
INSERT INTO nod_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ขนาด​ผม​ของ​ต้าน​มี​กี่​เส้น พระเจ้า​ก็​นับ​ไว้​หมด​แล้ว ย้อน​จาอี้​บ่﻿ต้อง​กั๋ว​เน่อ หมู่​ต้าน​มี​ก้า​นัก​เหลือ​นกจอก​หลาย​ตั๋ว​แหม​ก่อน ");
INSERT INTO nod_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“เฮา​บอก​หมู่​ต้าน​ว่า คน​ใด​ตี้​ยอมฮับ​เฮา​ต่อหน้า​คน​ใน​โลก​นี้ บุตรมนุษย์​ก็​จะ​ยอมฮับ​เขา​ต่อหน้า​หมู่​ทูตสวรรค์​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","แต่​คน​ใด​ตี้​บ่﻿ยอมฮับ​เฮา​ต่อหน้า​คน​ใน​โลก​นี้ เฮา​ก็​จะ​บ่﻿ยอมฮับ​เขา​ต่อหน้า​หมู่​ทูตสวรรค์​ของ​พระเจ้า​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","พระเจ้า​ยัง​จะ​ยกโต้ษ​หื้อ​กับ​คน​ตี้​ด่า​บุตรมนุษย์​ได้ แต่​จะ​ยกโต้ษ​หื้อ​คน​ตี้​อู้​หมิ่น​ประมาท​พระวิญญาณ​บริสุทธิ์​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“เมื่อ​หมู่​ต้าน​ถูก​ปา​ไป​ตัดสิน​โต้ษ​ใน​ธรรมศาลา กาว่า​ต่อหน้า​เจ้าเมือง​กาว่า​ผู้​มี​อำนาจ​ตัดสิน บ่﻿ต้อง​ฮ้อนอก​ตกใจ๋​ว่า​จะ​ตอบ​จาใด​จะ​อู้​จาใด ");
INSERT INTO nod_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ย้อน​ว่า​พระวิญญาณ​บริสุทธิ์​จะ​สอน​ต้าน​ว่า ควร​จะ​อู้​จาใด​ใน​เวลา​นั้น” ");
INSERT INTO nod_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","มี​คน​นึ่ง​ใน​หมู่​คน​ตี้​มา​หั้น​บอก​พระเยซู​ว่า “อาจ๋ารย์ ขอ​สั่ง​หื้อ​อ้าย​แบ่ง​มรดก​หื้อ​ข้าพเจ้า​กำ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","แต่​พระเยซู​อู้​กับ​เขา​ว่า “ใผ​ได้​ตั้ง​เฮา​เป๋น​ผู้​ตัดสิน​ความ กาว่า​เป๋น​คน​แบ่ง​มรดก​หื้อ​ต้าน​กา” ");
INSERT INTO nod_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","แล้ว​พระองค์​ก็​อู้​กับ​คน​ตังหลาย​ว่า “จง​หละวัง​หื้อ​ละ​เว้น​ก๋าน​โลภ​ตึง​หมด​เหีย ย้อน​ว่า​จีวิต​ของ​คน​เฮา​บ่﻿ได้​ขึ้น​อยู่​กับ​ก๋าน​มี​สิ่ง​ของ​นัก﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","พระองค์​อู้​กำเผียบ​ข้อ​นึ่ง​หื้อ​หมู่​เขา​ฟัง​ว่า “มี​เศรษฐี​คน​นึ่ง นา​ของ​เขา​ได้​ข้าว​นัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","เขา​กึ๊ด​ใน​ใจ๋​ว่า ‘เฮา​จะ​เยียะ​จาใด​ดี​หา ย้อน​ว่า​เฮา​บ่﻿มี​ตี้​ตี้​จะ​ใส่​ข้าว​จ๋น​หมด​จ๋น​เสี้ยง​ได้’ ");
INSERT INTO nod_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","เขา​กึ๊ด​ว่า ‘เฮา​จะ​เต​หลองข้าว​เก่า​นั้น แล้ว​แป๋ง​แหม​ใหม่​หื้อ​ใหญ่﻿ๆ แล้ว​เก็บ​ข้าว​กับ​ทรัพย์​สมบัติ​ไว้​ใน​หลอง​ใหม่​จ๋น​หมด ");
INSERT INTO nod_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","แล้ว​เฮา​จะ​บอก​กับ​ตั๋ว​เก่า​ว่า “เฮา​มี​ข้าว​ของ​นัก​อยู่​ได้​แหม​หลาย​ปี๋ หื้อ​อยู่​สบาย﻿ๆ กิ๋น​ดื่ม​ม่วนงัน​เต๊อะ” ’ ");
INSERT INTO nod_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“แต่​พระเจ้า​บอก​กับ​เขา​ว่า ‘เออ คน​ง่าว คืน​นี้​เจ้า​จะ​ต๋าย​แล้ว ของ​ตี้​สะสม​ไว้​นั้น​จะ​เป๋น​ของ​ใผ’ ");
INSERT INTO nod_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“คน​ตี้​สะสม​ทรัพย์​สมบัติ​ไว้​หื้อ​ตั๋ว​เก่า แต่​บ่﻿ได้​ร่ำรวย​ใน​สิ่ง​ดี​ใน​สายต๋า​พระเจ้า​ก็​เป๋น​จาอั้น​ละ” ");
INSERT INTO nod_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","พระเยซู​อู้​กับ​หมู่​สาวก​ของ​พระองค์​ว่า “ย้อน​จาอั้น​บ่﻿ถ้า​ฮ้อนใจ๋​จี้​วี้​จ้อ​หว้อ​เกี่ยวกับ​จีวิต​ว่า จะ​เอา​อะหยัง​มา​กิ๋น กาว่า​เป๋น​ห่วง​เรื่อง​ของ​ตั๋ว​ว่า จะ​เซาะ​หา​เสื้อผ้า​ตี้​ไหน​มา​นุ่ง ");
INSERT INTO nod_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ย้อน​ว่า​จีวิต​สำคัญ​นัก​เหลือ​ของ​กิ๋น กับ​ตั๋ว​ของ​คน​เฮา​ก็​สำคัญ​นัก​เหลือ​ผ้า​นุ่ง ");
INSERT INTO nod_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ลอง​ผ่อ​หมู่​นกก๋า​ลอ​ว่า บ่﻿ได้​หว่าน บ่﻿ได้​เก็บ​เกี่ยว บ่﻿ได้​เอา​ข้าว​ไว้​ใน​หลอง แต่​พระเจ้า​เป๋น​ผู้​เลี้ยง​นก​หมู่​นั้น​ไว้ หมู่​ต้าน​มี​ก้า​นัก​เหลือ​นก​หมู่​นั้น​แหม​ก่อน ");
INSERT INTO nod_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ใน​หมู่​ต้าน มี​ใผ​พ่อง​ตี้​ฮ้อนใจ๋​แล้ว​ต่อ​จีวิต​ตั๋ว​เก่า​หื้อ​ยาว​ออก​ไป​แหม​สัก​หน้อย​นึ่ง​ได้ ");
INSERT INTO nod_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ย้อน​จาอั้น แม้​สิ่ง​หน้อย﻿ๆ จาอี้​ยัง​เยียะ​บ่﻿ได้ จะ​ฮ้อนอก​ตกใจ๋​เรื่อง​อื่น﻿ๆ เยียะ​หยัง ");
INSERT INTO nod_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“ลอง​ผ่อ​ดอกไม้​ลอ มัน​งอก​งาม​ขึ้น​มา​ได้​จาใด มัน​บ่﻿ได้​เยียะ​ก๋าน มัน​บ่﻿ปั่น​ฝ้าย​แป๋ง​เสื้อ​นุ่ง แต่​เฮา​บอก​หื้อ​ฮู้​ว่า ขนาด​กษัตริย์​ซาโลมอน​ตี้​นับ​ว่า​ร่ำรวย​นัก​ขนาด ก็​ยัง​ใส่​เสื้อผ้า​บ่﻿งาม​เต้า​ดอกไม้​หมู่​นี้​สัก​ดอก​เดียว ");
INSERT INTO nod_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ถ้า​พระเจ้า​แต่งหย้อง​ดอก​หญ้า​ต๋ำ​โต้ง​ต๋ำ​นา เซิ่ง​มี​จีวิต​อยู่​ได้​วัน​นี้​วัน​เดียว ตก​แหม​วัน​ก็​จะ​ถูก​ก๋ำปือ​เข้า​ก๋องไฟ​จาอั้น แล้ว พระองค์​ก็​จะ​แต่งหย้อง​หมู่​ต้าน​นัก​เหลือ​นั้น​แหม โอ หมู่​ต้าน​มี​ความ​เจื้อ​หน้อย​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ต้าน​ก็​บ่﻿ถ้า​ฮ้อน​ใจ๋​ว่า​จะ​เอา​อะหยัง​มา​กิ๋น​มา​ดื่ม ");
INSERT INTO nod_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ย้อน​ว่า​คน​ตี้​บ่﻿ฮู้จัก​พระเจ้า​ใคว่​โลก​เซาะ​หา​สิ่ง​หมู่​นี้ แต่​พระบิดา​ของ​ต้าน​ตังหลาย​ฮู้​ดี​อยู่​แล้ว​ว่า​สิ่ง​หมู่​นี้​จ๋ำเป๋น​สำหรับ​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","แต่​หื้อ​ต้าน​เซาะ​หา​แผ่นดิน​ของ​พระเจ้า​ก่อน แล้ว​พระเจ้า​จะ​เตื่อม​แถ้ง​สิ่ง​ตี้​จ๋ำเป๋น​หมู่​นี้​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“หมู่​แกะ​หน้อย﻿ๆ เหย บ่﻿ถ้า​กั๋ว​เน่อ พระบิดา​ของ​หมู่​ต้าน​ปอใจ๋​ตี้​จะ​หื้อ​หมู่​ต้าน​อยู่​ใน​แผ่นดิน​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ต้าน​ตังหลาย​จง​ขาย​ของ​ตี้​มี​อยู่ แล้ว​แจก​หื้อ​คน​ตุ๊ก หื้อ​แป๋ง​ถง​สตางค์​ตี้​บ่﻿มี​วัน​ปุด คือ​มี​ทรัพย์​สมบัติ​ไว้​ใน​สวรรค์​ตี้​บ่﻿ฮู้จัก​หมด ตี้​ขโมย​ก็​บ่﻿เข้า​มา​ใก้ แมง​ก็​บ่﻿มา​ขบ​กิ๋น ");
INSERT INTO nod_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ย้อน​ว่า​ทรัพย์​สมบัติ​ของ​ต้าน​อยู่​ตี้​ไหน จิตใจ๋​ของ​ต้าน​ก็​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ต้าน​ตังหลาย​ต้อง​แต่งตั๋ว​หื้อ​พร้อม​ตี้​จะ​ฮับใจ๊ กับ​หื้อ​โกม​ไฟ​ของ​ต้าน​แจ้ง​อยู่ ");
INSERT INTO nod_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","หื้อ​เป๋น​เหมือน​คน​ฮับใจ๊ ตี้​ถ้า​ต้อนฮับ​นาย​ของ​ตั๋ว เมื่อ​นาย​ปิ๊ก​จาก​งาน​แต่งงาน​มา​แผว​บ้าน แล้ว​เมื่อ​นาย​มา​ฮ้อง​หน้า​ปะตู๋ หมู่​เขา​ก็​จะ​ไข​หื้อ​บ่า​เดี่ยว​นั้น​ได้​เลย ");
INSERT INTO nod_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","คน​ฮับใจ๊​ตี้​นาย​มา​ปะ​ว่า​ก่ำลัง​รอ​ถ้า​อยู่​ก็​เป๋น​สุข เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า นาย​จะ​แต่งตั๋ว​เป๋น​คน​ฮับใจ๊ แล้ว​หื้อ​คน​ฮับใจ๊​นั่ง​กิ๋น​ข้าว นาย​จะ​ยก​ข้าว​มา​หื้อ​กิ๋น ");
INSERT INTO nod_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ถ้า​นาย​ปิ๊ก​มา​ปะ​ว่า​คน​ฮับใจ๊​ยัง​รอ​ถ้า​อยู่ หมู่​เขา​ก็​จะ​เป๋น​สุข แม้​ว่า​จะ​เป๋น​เวลา​เตี้ยงคืน กาว่า​ใก้​แจ้ง​แล้ว​ก็​ต๋าม ");
INSERT INTO nod_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","หื้อ​จ๋ำ​ไว้​ว่า ถ้า​เจ้าของ​บ้าน​ฮู้​ตั๋ว​ว่า​ขโมย​จะ​ลัก​เข้า​มา​เวลา​ใด เขา​ก็​จะ​แน​หละวัง​บ่﻿หื้อ​ขโมย​งัด​เข้า​มา​ใน​บ้าน​ได้​แน่﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ต้าน​ตังหลาย​จง​เกียม​ตั๋ว​ไว้​หื้อ​พร้อม ย้อน​ว่า​บุตรมนุษย์​จะ​มา​ใน​เวลา​ตี้​หมู่​ต้าน​กึ๊ด​บ่﻿เถิง” ");
INSERT INTO nod_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","เปโตร​ถาม​พระเยซู​ว่า “อาจ๋ารย์​อู้​กำเผียบ​นั้น​หื้อ​หมู่​เฮา​ฟัง​กา กาว่า​อู้​หื้อ​คน​อื่น​ฟัง” ");
INSERT INTO nod_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","พระองค์​ตอบ​ว่า “ใผ​เป๋น​ป้อบ้าน​ตี้​ซื่อสัตย์ กับ​หลวก ตี้​เจ้านาย​มอบ​หน้าตี้​หื้อ​เป๋น​หัวหน้า​คน​ฮับใจ๊​คน​อื่น﻿ๆ เปื้อ​แจก​ของกิ๋น​ต๋าม​เวลา ");
INSERT INTO nod_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","เมื่อ​เจ้านาย​ปิ๊ก​มา​หัน​เขา​ยัง​เยียะ​ก๋าน​อยู่​อย่าง​ดี ป้อ​บ้าน​คน​นั้น​ก็​เป๋น​สุข ");
INSERT INTO nod_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เจ้านาย​จะ​ตั้ง​หื้อ​เขา​ผ่อกอย​กู้​อย่าง​ตี้​เป๋น​ของ​เปิ้น ");
INSERT INTO nod_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","แต่​ถ้า​ป้อบ้าน​คน​นั้น​กึ๊ด​ใน​ใจ๋​ว่า ‘แหม​เมิน​อยู่​กว่า​เจ้านาย​จะ​ปิ๊ก​มา’ แล้ว​ตั้งเก๊า​บุบ​ตี๋​คน​ฮับใจ๊​จาย​ญิง​กับ​ตึง​กิ๋น​ตึง​ดื่ม​จ๋น​เมา​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","เจ้านาย​ของ​เขา​ก็​จะ​ปิ๊ก​มา​ใน​วัน​เวลา​ตี้​เขา​บ่﻿ฮู้​กับ​บ่﻿ตัน​ฮู้คิง แล้ว​ก็​จะ​ลงโต้ษ​เขา​อย่าง​หนัก ตึง​ไล่​หื้อ​ไป​อยู่​ตวย​หมู่​คน​ตี้​บ่﻿เจื้อ ");
INSERT INTO nod_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","คน​ฮับใจ๊​ตี้​ฮู้​ใจ๋​นาย แล้ว​บ่﻿ได้​เกียม​ตั๋ว​เยียะ​ก๋าน​ต๋ามใจ๋​นาย จะ​ต้อง​ถูก​เฆี่ยน​หนัก ");
INSERT INTO nod_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","แต่​คน​ตี้​บ่﻿ฮู้ แล้ว​เยียะ​ใน​สิ่ง​ตี้​สมควร​จะ​ถูก​เฆี่ยน ก็​จะ​ถูก​เฆี่ยน​หน้อย ใผ​ได้ฮับ​นัก ก็​จะ​ต้อง​หื้อ​นัก ใผ​ได้ฮับ​ความ​ไว้วางใจ๋​นัก​ก็​จะ​ต้อง​ฮับผิดชอบ​นัก ");
INSERT INTO nod_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“เฮา​มา​เปื้อ​จะ​หื้อ​ไฟ​แห่ง​ก๋าน​ตัดสิน​เกิด​ขึ้น​ใน​โลก เฮา​ก็​ใค่​หื้อ​ไฟ​นั้น​ลุก เปื้อ​ก๋านงาน​เฮา​จะ​ได้​สำเร็จ ");
INSERT INTO nod_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","เฮา​ต้อง​ฮับ​ความ​ตุ๊ก​ขนาด เฮา​ก็​ตุ๊กใจ๋​จ๋น​กว่า​จะ​สำเร็จ ");
INSERT INTO nod_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ต้าน​ตังหลาย​กึ๊ด​ว่า​เฮา​มา​เปื้อ​จะ​หื้อ​เกิด​ความ​สงบ​สุข​ใน​โลก​นี้​กา บ่﻿ใจ้​จาอั้น​เน่อ แต่​มา​เปื้อ​หื้อ​เกิด​ก๋าน​แตกแยก​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ตั้งแต่​นี้​ไป​เฮือน​ใด​ตี้​มี​ห้า​คน​ก็​จะ​แตกแยก​กั๋น เป๋น​หมู่​นึ่ง​สาม​คน​กับ​แหม​หมู่​สอง​คน​ตี้​ต่อต้าน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ป้อ​กับ​ลูก​บ่าว​จะ​แตกแยก​กั๋น แม่​กับ​ลูก​สาว​จะ​แตกแยก​กั๋น แม่​ผัว​กับ​ลูกใป๊​จะ​แตกแยก​กั๋น” ");
INSERT INTO nod_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","พระเยซู​อู้​กับ​คน​ตังหลาย​แหม​ว่า “เมื่อ​ต้าน​ตังหลาย​หัน​เมฆ​ดำ​บน​ต๊องฟ้า​ตัง​วันตก ต้าน​ก็​อู้​ตันที​ว่า ‘ฝน​จะ​ตก​แล้ว’ ก็​เป๋น​จาอั้น​แต๊ ");
INSERT INTO nod_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","เมื่อ​ต้าน​หัน​ลม​ปั๊ด​มา​ตัง​ใต้ ต้าน​ก็​ว่า ‘จะ​ฮ้อน​ขนาด’ แล้ว​ก็​เป๋น​จาอั้น​แต๊ ");
INSERT INTO nod_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","เออ คน​หน้า​ซื่อ​ใจ๋​ก๊ด ต้าน​ตังหลาย​ฮู้จัก​ตี๋​ความหมาย​ของ​สิ่ง​ตี้​เกิด​ขึ้น​บน​แผ่นดิน​กับ​ต๊องฟ้า แต่​เป๋น​จาใด​ต้าน​ตี๋​ความหมาย​สิ่ง​ตี้​พระเจ้า​ก่ำลัง​เยียะ​อยู่​ใน​สมัย​นี้​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“เป๋น​จาใด​ต้าน​ตังหลาย​บ่﻿ตัดสิน​เอา​คน​เดียว​ว่า อะหยัง​เป๋น​สิ่ง​ตี้​ถูก ");
INSERT INTO nod_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ถ้า​ต้าน​ก่ำลัง​เตียว​ไป​ศาล​กับ​คน​ตี้​จะ​ฟ้อง​ต้าน หื้อ​อุตส่าห์​หา​ตาง​ตี้​จะ​ตกลง​กั๋น​ได้​เมื่อ​ยัง​บ่﻿ตัน​ไป​เถิง​ศาล​เตื้อ กั๋ว​ว่า​เขา​จะ​บังคับ​ต้าน​ไป​หา​ผู้​พิพากษา ผู้​พิพากษา​ก็​จะ​ส่ง​ต่อ​หื้อ​นายกุมคอก นายกุมคอก​ก็​จะ​เอา​ต้าน​ไป​ขัง​คอก​ไว้​เหีย ");
INSERT INTO nod_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","เฮา​บอก​ต้าน​ว่า ต้าน​จะ​ออก​จาก​คอก​ตึง​บ่﻿ได้ จ๋น​กว่า​จะ​จ่าย​ก้า​ปรับ​จ๋น​ครบ​กู้​บาท​กู้​สตางค์​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","เวลา​นั้น​มี​บาง​คน​อยู่​หั้น​เล่า​เรื่อง​จาว​กาลิลี​ตี้​ถูก​ปีลาต​ฆ่า​ต๋าย​ต๋อน​ตี้​ก่ำลัง​เยียะ​พิธี​ถวาย​เครื่อง​ปู่จา​พระเจ้า หื้อ​พระเยซู​ฟัง ");
INSERT INTO nod_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","พระองค์​ก็​ถาม​หมู่​เขา​ว่า “ต้าน​ตังหลาย​กึ๊ด​ว่า​จาว​กาลิลี​หมู่​นั้น​เป๋น​คน​บาป​นัก​เหลือ​จาว​กาลิลี​คน​อื่น﻿ๆ ย้อน​ว่า​หมู่​เขา​ได้​ถูก​ฆ่า​ต๋าย​จาอั้น​กา ");
INSERT INTO nod_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","เฮา​บอก​ต้าน​ตังหลาย​ว่า​บ่﻿ใจ้ ถ้า​ต้าน​ตังหลาย​บ่﻿ได้​กลับใจ๋​จาก​บาป ก็​จะ​ต้อง​ฉิบหาย​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","กาว่า​สิบ​แปด​คน​นั้น​ลอ ตี้​หอ​คอย​เมือง​สิโลอัม​โก้น​เต๋ง​หมู่​เขา​ต๋าย ต้าน​ตังหลาย​กึ๊ด​ว่า​หมู่​เขา​เป๋น​คน​บาป​นัก​เหลือ​คน​ตังหลาย​ตี้​อยู่​ใน​กรุง​เยรูซาเล็ม​กา ");
INSERT INTO nod_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","เฮา​บอก​ต้าน​ตังหลาย​ว่า​บ่﻿ใจ้ ถ้า​ต้าน​ตังหลาย​บ่﻿กลับใจ๋​จาก​บาป​ก็​จะ​ฉิบหาย​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","พระเยซู​อู้​กำเผียบ​หื้อ​หมู่​เขา​ฟัง​ว่า “มี​คน​นึ่ง​ปูก​เก๊า​บ่าเดื่อ​เก๊า​นึ่ง​ไว้​ใน​สวน​องุ่น​ของ​เขา เขา​มา​เซาะ​หา​หน่วย​ตี้​เก๊า​นั้น​ก็​บ่﻿มี ");
INSERT INTO nod_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","เขา​ก็​บอก​คน​เยียะ​สวน​องุ่น​ว่า ‘ผ่อ​ลอ​เฮา​มา​เซาะ​หน่วย​บ่าเดื่อ​เก๊า​นี้​สาม​ปี๋​แล้ว บ่﻿หัน​มี​สัก​หน่วย ฟัน​ขว้าง​เหีย​เต๊อะ ละ​ไว้​ก็​เติ้ก​สวน​บ่ดาย’ ");
INSERT INTO nod_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","คน​เยียะ​สวน​องุ่น​ก็​บอก​ว่า ‘นาย​ครับ ขอ​เอา​ไว้​แหม​ปี๋​เต๊อะ ลอง​กุ่น​ดิน​เอา​ปุ๋ย​ใส่​ผ่อ​ก่อน ");
INSERT INTO nod_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ถ้า​ปี๋​หน้า​มี​หน่วย​ก็​ดี แต่​ถ้า​บ่﻿มี​หน่วย ก้อย​ฟัน​ขว้าง​เมื่อ​ลูน​ก็​ได้’ ” ");
INSERT INTO nod_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ใน​วัน​สะบาโต​วัน​นึ่ง พระเยซู​ก่ำลัง​สั่ง​สอน​อยู่​ใน​ธรรมศาลา​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","มี​แม่ญิง​คน​นึ่ง​โดน​ผี​เข้า​เยียะ​หื้อ​เป๋น​โรค​ได้​สิบ​แปด​ปี๋ นาง​หลังก่อง​หยืด​ตั๋ว​ซื่อ​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","เมื่อ​พระองค์​หัน​นาง​แล้ว​จึง​ฮ้อง​หื้อ​เข้า​มา​หา​บอก​ว่า “นาง​เหย ตั๋ว​เจ้า​หาย​จาก​โรค​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","พระองค์​เอา​มือ​วาง​ตี้​ตั๋ว​ของ​นาง โรค​ของ​นาง​ก็​หาย​บ่า​เดี่ยว​นั้น​เลย หยืด​ตั๋ว​ซื่อ​ได้ กับ​สรรเสริญ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","แต่​นาย​ธรรมศาลา​โขด​ตี้​พระเยซู​ฮักษา​โรค​ใน​วัน​สะบาโต จึง​บอก​คน​ตังหลาย​ว่า “มี​หก​วัน​ตี้​หื้อ​เยียะ​ก๋าน​ได้ ใน​หก​วัน​นั้น​หื้อ​มา​ฮักษา​โรค​เต๊อะ แต่​ใน​วัน​สะบาโต​ขอ​ย้าง​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","พระเยซู​ตอบ​เขา​ว่า “คน​หน้า​ซื่อ​ใจ๋​ก๊ด เจ้า​ตังหลาย​ได้​แก้​เจื้อก​งัว​เจื้อก​ลา ปา​มัน​ออก​คอก​ไป​กิ๋น​น้ำ​ใน​วัน​สะบาโต​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","แม่ญิง​คน​นี้​เป๋น​เจื๊อสาย​ของ​อับราฮัม เขา​ถูก​ซาต๋าน​เยียะ​หื้อ​เป๋น​โรค​มา​สิบ​แปด​ปี๋​แล้ว บ่﻿สมควร​เตื้อ​กา​ตี้​นาง​จะ​มี​อิสระ​ใน​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","เมื่อ​พระองค์​อู้​จาอั้น​แล้ว หมู่​ตี้​เป๋น​ศัตรู๋​ก็​อาย แต่​คน​ตังหลาย​จื้นจมยินดี ย้อน​ก๋าน​อัศจ๋รรย์​ตี้​พระเยซู​ได้​เยียะ ");
INSERT INTO nod_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","พระองค์​อู้​หื้อ​ฟัง​ว่า “แผ่นดิน​ของ​พระเจ้า​เหมือน​อะหยัง เฮา​จะ​เผียบ​แผ่นดิน​ของ​พระเจ้า​เหมือน อะหยัง​ดี​น่อ ");
INSERT INTO nod_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ก็​เผียบ​เหมือน​เม็ด​มัสตาร์ด​เม็ด​นึ่ง​ตี้​คน​นึ่ง​เอา​ไป​ปูก​ไว้​ใน​สวน​ของ​เขา งอก​ออก​มา​แล้ว ก็​เป๋น​ต้น​ใหญ่​จ๋น​นก​มา​แป๋ง​ฮัง​บน​กิ่ง​ของ​เก๊า​นั้น​ได้” ");
INSERT INTO nod_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","พระองค์​ก็​อู้​แหม​ว่า “เฮา​จะ​เผียบ​แผ่นดิน​ของ​พระเจ้า​เหมือน​อะหยัง​ดี​หา ");
INSERT INTO nod_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ก็​เผียบ​เหมือน​เจื๊อ​ผงฟู​ตี้​แม่ญิง​คน​นึ่ง​เอา​มา​สูน​กับ​แป้ง​สาม​ถัง เจื๊อ​นั้น​ก็​เยียะ​หื้อ​แป้ง​นั้น​ปุ๊​ขึ้น​ตึง​หมด” ");
INSERT INTO nod_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ต๋อน​ตี้​พระองค์​ก่ำลัง​เตียวตาง​ไป​กรุง​เยรูซาเล็ม พระเยซู​ก็​แอ่ว​ไป​ต๋าม​บ้าน​ต๋าม​เมือง​ต่าง﻿ๆ สั่ง​สอน​คน​ตังหลาย​ตวย ");
INSERT INTO nod_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","มี​คน​นึ่ง​ถาม​พระองค์​ว่า “อาจ๋ารย์ คน​ตี้​จะ​รอด​ป๊น​บาป​โต้ษ​นั้น​มี​หน้อย​กา” ");
INSERT INTO nod_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","พระองค์​อู้​กับ​คน​ตังหลาย​ว่า “ต้าน​ตังหลาย​จง​พยายาม​เข้า​ไป​ตาง​ปะตู๋​กีด﻿ๆ เน่อ เฮา​บอก​ต้าน​ตังหลาย​ว่า มี​คน​นัก​ฮิ​จะ​เข้า​ไป​ก็​เข้า​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","เมื่อ​เจ้า​ของ​บ้าน​หับ​ปะตู๋​แล้ว ต้าน​ตังหลาย​ยืน​ฮ้อง​อยู่​ตัง​นอก​ปะตู๋​ว่า ‘นาย​เจ้าข้า จ้วย​ไข​ปะตู๋​หื้อ​เฮา​กำ​เต๊อะ’ แต่​เจ้า​ของ​บ้าน​ตอบ​ว่า ‘เฮา​บ่﻿ฮู้จัก​หมู่​เจ้า​ว่า​เป๋น​ใผ ลุก​ตี้​ไหน​มา’ ");
INSERT INTO nod_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ต้าน​ตังหลาย​ก็​จะ​ตอบ​ว่า ‘หมู่​เฮา​เกย​กิ๋น​สุก​กิ๋น​ดิบ​กับ​ต้าน ต้าน​เกย​สั่ง​สอน​ต๋ำ​ถนน​ใน​บ้าน​ของ​หมู่​เฮา​นั้น​ลอ’ ");
INSERT INTO nod_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","เจ้า​ของ​บ้าน​ก็​ตอบ​ว่า ‘เฮา​บ่﻿ฮู้จัก​หมู่​เจ้า​ว่า​เป๋น​ใผ ลุก​ตี้​ไหน​มา เจ้า​ผู้​เยียะ​บ่﻿ดี​ตังหลาย จง​ไป​หื้อ​ป๊น​หน้า​เฮา​เหีย​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“เมื่อ​นั้น​ต้าน​ตังหลาย​จะ​หัน​อับราฮัม อิสอัค ยาโคบ กับ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตังหลาย​ใน​แผ่นดิน​ของ​พระเจ้า แต่​ตั๋ว​ต้าน​จะ​ถูก​ขับ​ไล่​หื้อ​ไป​อยู่​ตัง​นอก แล้ว​หมู่​ต้าน​ก็​จะ​ไห้​หุย​ขบ​เขี้ยว​เกี๊ยว​กาง​อย่าง​เจ็บ​ปวด ");
INSERT INTO nod_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","คน​จะ​มา​จาก​ตัง​วันออก ตัง​วันตก ตัง​เหนือ กับ​ตัง​ใต้​จะ​กิ๋น​เลี้ยง​ฉลอง​กั๋น​ใน​แผ่นดิน​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ผ่อ​เน่อ​จะ​มี​คน​ตี้​เป๋น​คน​ตังเก๊า​ใน​ต๋อน​นี้ จะ​ก๋าย​เป๋น​คน​ตังป๋าย กับ​คน​ตังป๋าย​ต๋อน​นี้ จะ​ก๋าย​ไป​เป๋น​คน​ตังเก๊า” ");
INSERT INTO nod_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ใน​วัน​นั้น​มี​หมู่​ฟาริสี​บาง​คน​มา​บอก​พระองค์​ว่า “ขอ​ต้าน​ไป​จาก​ตี้​นี่​เหีย​เต๊อะ​ย้อน​เฮโรด​เจ้าเมือง​จะ​ฆ่า​ต้าน” ");
INSERT INTO nod_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","พระองค์​จึง​บอก​หมู่​เขา​ว่า “ไป​บอก​หมาไน​ตั๋ว​นั้น​เน่อ​ว่า เฮา​ไล่​ผี​ออก​กับ​ฮักษา​โรค​ใน​วัน​นี้​กับ​วัน​พูก แล้ว​ใน​วัน​ตี้​พระเจ้า​ก๋ำหนด​ไว้ เฮา​จะ​เยียะ​หื้อ​สำเร็จ ");
INSERT INTO nod_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","แต่​ว่า​จ๋ำเป๋น​ตี้​เฮา​จะ​ต้อง​เตียว​ไป​วัน​นี้ วัน​พูก กับ​วัน​ฮือ ย้อน​ว่า​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​จะ​บ่﻿ถูก​ฆ่า​นอก​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“โอ เยรูซาเล็ม เยรูซาเล็ม​เหย เจ้า​คือ​ผู้​ตี้​ได้​ฆ่า​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า แล้ว​เอา​บ่าหิน​ขว้าง​คน​หมู่​นั้น​ตี้​พระเจ้า​ส่ง​มา​หา​หมู่​เจ้า​จ๋น​ต๋าย หลาย​เตื้อ​เฮา​ใค่​เอา​ลูก​ของ​เจ้า​มา​ไว้​ใน​อ้อม​อก​เหมือน​แม่​ไก่​กก​ลูก​อยู่​ใต้​ปีก​ของ​มัน แต่​เจ้า​บ่﻿ยอม ");
INSERT INTO nod_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ผ่อ​หื้อ​ดี​เน่อ เฮือน​ของ​เจ้า​จะ​ถูก​ละ​ขว้าง​หื้อ​ฮ้าง​ไป​เหีย เฮา​ขอ​บอก​เจ้า​ตังหลาย​ไว้​เน่อ​ว่า เจ้า​ตังหลาย​จะ​บ่﻿หัน​เฮา​แหม​แล้ว จ๋น​กว่า​หมู่​เจ้า​จะ​เอิ้น​ว่า ‘ขอ​พระเจ้า​ปั๋น​ปอน​ผู้​ตี้​มา​ใน​นาม​ของ​องค์​พระผู้เป๋นเจ้า’” ");
INSERT INTO nod_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ใน​วัน​สะบาโต​วัน​นึ่ง พระเยซู​เข้า​ไป​ใน​เฮือน​ของ​ผู้​นำ​คน​นึ่ง​ของ​หมู่​ฟาริสี​เปื้อ​จะ​กิ๋น​ข้าว คน​ตี้​หั้น​ถ้า​ผ่อ​ว่า พระองค์​จะ​เยียะ​ก๋าน​ใน​วัน​สะบาโต​ก่อ ");
INSERT INTO nod_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","มี​คน​นึ่ง​เป๋น​โรค​บวม​น้ำ​อยู่​ต่อหน้า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","พระเยซู​จึง​ถาม​หมู่​ผู้​ชำนาญ​บท​บัญญัติ​กับ​หมู่​ฟาริสี​ว่า “ถ้า​จะ​ฮักษา​คน​ป่วย​ใน​วัน​สะบาโต จะ​ผิด​บท​บัญญัติ​ก่อ” ");
INSERT INTO nod_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","หมู่​เขา​ก็​บ่﻿ว่า​ใด​สัก​คน พระองค์​จึง​ก๋ำ​ตั๋ว​คน​ป่วย แล้ว​ฮักษา​เขา​หื้อ​หาย​โรค แล้ว​ก็​หื้อ​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","พระองค์​จึง​ถาม​เขา​ตังหลาย​ว่า “ใน​หมู่​ต้าน​มี​ใผ​พ่อง​ถ้า​มี​ลูก​กาว่า​งัว​ตก​น้ำบ่อ​ใน​วัน​สะบาโต จะ​บ่﻿ขะใจ๋​ลาก​ออก​กา” ");
INSERT INTO nod_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","หมู่​เขา​ก็​ตอบ​กำถาม​นั้น​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","พระเยซู​หัน​หมู่​คน​ตี้​ฮับ​เจิญ​มา​กิ๋น​เลี้ยง​เลือก​นั่ง​ตี้​สำคัญ พระองค์​จึง​อู้​กำเผียบ​หื้อ​หมู่​เขา​ฟัง​ว่า ");
INSERT INTO nod_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“เมื่อ​มี​ใผ​เจิญ​ต้าน​ไป​กิ๋น​เลี้ยง​งาน​แต่งงาน บ่﻿ดี​ไป​เลือก​ตี้​นั่ง​ตี้​สำคัญ​เน่อ เผื่อ​ว่า​เจ้าภาพ​ได้​เจิญ​คน​ตี้​มี​ยศ​สูง​เหลือ​ต้าน​มา​ใน​งาน​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","เจ้าภาพ​จะ​ปา​คน​นั้น​มา​หา แล้ว​จะ​บอก​หื้อ​ต้าน​ลุก​หื้อ​คน​นั้น​นั่ง แล้ว​ต้าน​จะ​ถูก​เลื่อน​ไป​นั่ง​ตี้​ต่ำ​ตี้​สุด ต้าน​ก็​จะ​อาย ");
INSERT INTO nod_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","เมื่อ​ต้าน​ได้ฮับ​เจิญ ถ้า​ไป​แผว​บ้าน​ตี้​จัด​งาน​แล้ว หื้อ​เซาะ​ตี้​นั่ง​ตี้​ต่ำ​ตี้​สุด​ก่อน ถ้า​เจ้าภาพ​มา​บอก​ต้าน​ว่า ‘เปื้อน​เหย เจิญ​ต้าน​ไป​นั่ง​ตี้​ดี​เหลือ​นี้​เต๊อะ’ ต้าน​ก็​จะ​ได้ฮับ​เกียรติ​ต่อหน้า​คน​ตังหลาย​ตี้​นั่ง​ตวย​กั๋น​หั้น ");
INSERT INTO nod_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ย้อน​ว่า​กู้​คน​ตี้​ยก​ตั๋ว​ขึ้น​ก็​จะ​ถูก​เต็ก​หื้อ​ต่ำ​ลง ส่วน​คน​ตี้​ถ่อม​ตั๋ว​ลง​ก็​จะ​ได้ฮับ​ก๋าน​ยก​ขึ้น” ");
INSERT INTO nod_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","แล้ว​พระเยซู​อู้​กับ​เจ้าภาพ​ว่า “เมื่อ​ต้าน​จะ​จัด​งาน​เลี้ยง จะ​เป๋น​เมื่อ​วัน​ก็​ดี เมื่อ​ค่ำ​ก็​ดี บ่﻿ถ้า​เจิญ​ก้า​เปื้อน​เดียว​เสี่ยว​กั๋น กาว่า​เจิญ​ญาติ​ปี้น้อง กาว่า​เปื้อน​บ้าน​ตี้​ร่ำรวย​เต้าอั้น ย้อน​หมู่​นั้น​ก็​จะ​เจิญ​ต้าน​เป๋น​ก๋าน​ส้าย​มื้อ​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","แต่​เมื่อ​จัด​งานเลี้ยง หื้อ​เจิญ​หมู่​คน​ตุ๊ก คน​พิก๋าน คน​แข้ง​หัก​ขา​ห้าน กับ​คน​ต๋าบอด​ตวย ");
INSERT INTO nod_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","แล้ว​พระเจ้า​จะ​ปั๋นปอน​ต้าน ย้อน​คน​หมู่​นี้​บ่﻿มี​อะหยัง​จะ​มา​ส้าย​ต้าน แต่​พระเจ้า​จะ​เป๋น​ผู้​หื้อ​รางวัล​ต้าน​เมื่อ​พระองค์​เยียะ​หื้อ​คน​ถูกต้อง​ต๋าม​ธรรม เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","มี​คน​นึ่ง​ตี้​นั่ง​กิ๋น​ข้าว​โต๊ะ​เดียว​กั๋น​กับ​พระเยซู เมื่อ​ได้ยิน​พระองค์​อู้​จาอี้ ก็​บอก​พระองค์​ว่า “คน​ตี้​จะ​ได้​เข้า​ฮ่วม​งานเลี้ยง​ใน​แผ่นดิน​ของ​พระเจ้า​ก็​เป๋น​สุข” ");
INSERT INTO nod_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","พระองค์​อู้​กับ​เขา​ว่า “มี​คน​นึ่ง​จัด​งานเลี้ยง​ใหญ่​โต ได้​เจิญ​คน​จ๋ำนวน​นัก​มา​ฮ่วม​งาน ");
INSERT INTO nod_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","เมื่อ​เกียม​เสร็จ​แล้ว ก็​ส่ง​คน​ฮับใจ๊​ออก​ไป​ตวย​หา​หมู่​ตี้​เจิญ​ไว้​แล้ว​บอก​เขา​ว่า ‘เจิญ​มา​เต๊อะ กู้​สิ่ง​กู้​อย่าง​ก็​พร้อม​แล้ว’ ");
INSERT INTO nod_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","คน​หมู่​นั้น​ปา​กั๋น​อ้าง​ว่า ไป​บ่﻿ได้ คน​หัวที​บอก​ว่า ‘เฮา​ซื้อ​นา​ไว้ วัน​นี้​จะ​ไป​ผ่อ​นา​นั้น ขอ​สูมา​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","แหม​คน​นึ่ง​ว่า ‘เฮา​ซื้อ​งัว​ไว้​ห้า​กู้ เฮา​จะ​ไป​ลอง​ก๋าน​ผ่อ เฮา​ขอ​สูมา​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","แหม​คน​นึ่ง​ก็​อู้​ว่า ‘เฮา​แต่งงาน​ใหม่​ย้อน​จาอั้น​ไป​บ่﻿ได้’ ");
INSERT INTO nod_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","คน​ฮับใจ๊​ก็​ปิ๊ก​มา​บอก​นาย นาย​โขด​ขนาด​สั่ง​คน​ฮับใจ๊​ว่า ‘ออก​ไป​ต๋าม​กอง​ใหญ่​กับ​กอง​หน้อย​ใน​เมือง​เวย﻿ๆ ปา​คน​ตุ๊ก คน​พิก๋าน คน​ต๋าบอด กับ​คน​แข้ง​หัก​ขา​ห้าน​เข้า​มา​เน่อ’ ");
INSERT INTO nod_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","คน​ฮับใจ๊​ปิ๊ก​มา​บอก​ว่า ‘นาย​ครับ​เฮา​ได้​เยียะ​ต๋าม​ตี้​นาย​สั่ง​ไว้​แล้ว ยัง​มี​ตี้​ว่าง​อยู่’ ");
INSERT INTO nod_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","นาย​จึง​สั่ง​คน​ฮับใจ๊​แหม​ว่า ‘ออก​ไป​ต๋าม​หนตาง​บ้านนอก เมื่อ​ปะ​ใผ​ก็​หื้อ​จั๊กจวน​มา​หมด เปื้อ​หื้อ​มี​คน​มา​เต๋ม​เฮือน​เฮา ");
INSERT INTO nod_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","เฮา​บอก​ต้าน​ตังหลาย​ว่า หมู่​คน​ตี้​เฮา​เจิญ​แล้ว​บ่﻿มา​นั้น บ่﻿มี​ใผ​สัก​คน​จะ​ได้​กิ๋น​ของกิ๋น​ของ​เฮา’ ” ");
INSERT INTO nod_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","มี​คน​จ๋ำนวน​นัก​ตวย​พระองค์​ไป พระองค์​เหลียว​หลัง​มา​ผ่อ แล้ว​ก็​อู้​กับ​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ถ้า​คน​ใด​มา​หา​เฮา​แล้ว​ฮัก​เฮา​หน้อย​เหลือ​ป้อ แม่ ลูก เมีย ญาติ กับ​ปี้น้อง แม้แต่​จีวิต​ตั๋ว​เก่า​นัก​เหลือ​เฮา จะ​เป๋น​สาวก​ของ​เฮา​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","คน​ใด​ตี้​บ่﻿ยอม​แบก​ไม้​ก๋าง​เขน​ของ​ตั๋ว​แล้ว​ตวย​เฮา​มา คน​นั้น​จะ​เป๋น​สาวก​ของ​เฮา​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ใน​หมู่​ต้าน​ถ้า​ใผ​จะ​ใค่​แป๋ง​ตึก​จะ​บ่﻿นั่ง​ลง​กึ๊ด​รากา​เหีย​ก่อน​กา ว่า จะ​มี​เงิน​ปอ​เยียะ​จ๋น​แล้ว​ก่อ ");
INSERT INTO nod_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","กั๋ว​ว่า​ถ้า​วาง​ฐาน​แล้ว แต่​แป๋ง​บ่﻿แล้ว คน​ตังหลาย​ตี้​มา​หัน​ก็​จะ​ใค่หัว​ใส่ ");
INSERT INTO nod_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","แล้ว​อู้​ว่า ‘คน​นี้​ตั้ง​ต้น​แป๋ง แต่​แป๋ง​หื้อ​แล้ว​บ่﻿ได้’ ");
INSERT INTO nod_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","กาว่า มี​กษัตริย์​องค์​ใด​พ่อง เมื่อ​จะ​ยก​ทัพ​ไป​ฮบ​กับ​กษัตริย์​องค์​อื่น จะ​บ่﻿นั่ง​ลง​กึ๊ด​เหีย​ก่อน​ว่า มี​ทหาร​หมื่น​คน​จะ​ฮบ​กับ​ก๋องทัพ​ตี้​ยก​มา​สอง​หมื่น​คน​ได้​ก่อ ");
INSERT INTO nod_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ถ้า​หัน​ว่า​สู้​บ่﻿ได้ เมื่อ​ยัง​อยู่​ห่าง​กั๋น ก็​จะ​ใจ๊​หมู่​ทูต​ไป​ขอ​เป๋น​มิตร​กั๋น​เหีย ");
INSERT INTO nod_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ก็​อย่าง​เดียว​กั๋น​นั้น​ละ ใน​หมู่​ต้าน ถ้า​ใผ​บ่﻿ยอม​สละ​กู้​สิ่ง จะ​เป๋น​สาวก​ของ​เฮา​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“เกื๋อ​เป๋น​ของ​ดี แต่​ถ้า​เกื๋อ​จ๋าง​ไป​เหีย จะ​เยียะ​หื้อ​เก็ม​แหม​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","จะ​เอา​เป๋น​ปุ๋ย​ใส่​ดิน​ก็​บ่﻿ได้ จะ​เอา​หมัก​กับ​ขี้​สัตว์​แป๋ง​ปุ๋ย​ก็​บ่﻿ได้ เขา​ก็​จะ​เอา​ขว้าง​เหีย​เต้าอั้น ใผ​ยอม​ฟัง​ก็​หื้อ​ฟัง​ไว้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ต๋อน​นั้น​หมู่​คน​เก็บ​ภาษี​กับ​หมู่​คน​บาป​ตังหลาย​ปา​กั๋น​เข้า​มา​ใก้​พระเยซู​เปื้อ​จะ​ฟัง​พระองค์​สั่ง​สอน ");
INSERT INTO nod_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","แต่​หมู่​ฟาริสี​กับ​หมู่​ธรรมาจ๋ารย์​จ่ม​ว่า “คน​นี้​ต้อนฮับ​คน​บาป​กับ​กิ๋น​ดื่ม​ตวย​หมู่​เขา” ");
INSERT INTO nod_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","พระองค์​อู้​เป๋น​กำเผียบ​หื้อ​หมู่​เขา​ฟัง​ว่า ");
INSERT INTO nod_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ใน​หมู่​ต้าน​มี​ใผ​พ่อง​ตี้​มี​แกะ​ร้อย​ตั๋ว แล้ว​มี​ตั๋ว​นึ่ง​หาย​ไป จะ​บ่﻿ละ​แกะ​เก้า​สิบ​เก้า​ตั๋ว​ไว้ แล้ว​ก็​ไป​เซาะ​หา​ตั๋ว​ตี้​หาย​ไป​จ๋น​ปะ​กา ");
INSERT INTO nod_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","เมื่อ​ปะ​แล้ว​ก็​ยก​ขึ้น​ใส่​บ่า​แบก​ปิ๊ก​มา​ด้วย​ความ​จื้นจมยินดี ");
INSERT INTO nod_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","เมื่อ​มา​เถิง​บ้าน​แล้ว จึง​เจิญ​หมู่​เปื้อน​ฝูง​กับ​จาวบ้าน​มา​ตี้​บ้าน แล้ว​บอก​หมู่​เขา​ว่า ‘ขอ​ยินดี​กับ​เฮา​ตวย​เน่อ ย้อน​ว่า​เฮา​ได้​ปะ​แกะ​ตั๋ว​ตี้​หาย​ไป​นั้น​แล้ว’ ");
INSERT INTO nod_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","เฮา​บอก​ต้าน​ตังหลาย​ว่า ใน​สวรรค์​ก็​เป๋น​อย่าง​เดียว​กั๋น​เมื่อ​คน​บาป​คน​นึ่ง​กลับใจ๋​จาก​บาป จะ​มี​ความ​จื้นจมยินดี​นัก​เหลือ​เก้า​สิบ​เก้า​คน​ตี้​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม​แล้ว​บ่﻿ต้อง​กลับใจ๋​จาก​บาป ");
INSERT INTO nod_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“กาว่า​แม่ญิง​คน​ใด​มี​เหรียญ​เงิน​สิบ​เหรียญ แต่​เหรียญ​นึ่ง​หาย​ไป​จะ​บ่﻿ต๋าม​โกม​ไฟ​กวาด​เฮือน​เซาะ​หา​จ๋น​ปะ​กา ");
INSERT INTO nod_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","เมื่อ​ปะ​แล้ว​ก็​เจิญ​เปื้อน​ฝูง​กับ​จาวบ้าน​มา​อยู่​ฮ่วม​กั๋น บอก​หมู่​เขา​ว่า ‘ขอ​ยินดี​กับ​ข้าเจ้า​ตวย​เน่อ ข้าเจ้า​เซาะ​หา​เหรียญ​ตี้​หาย​ไป​นั้น​ได้​แล้ว’ ");
INSERT INTO nod_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ก็​เป๋น​อย่าง​เดียว​กั๋น​นั้น​ละ เฮา​บอก​ต้าน​ตังหลาย​ว่า หมู่​ทูตสวรรค์​ของ​พระเจ้า​จะ​มี​ความ​ยินดี​เมื่อ​มี​คน​บาป​คน​เดียว​กลับใจ๋​จาก​บาป” ");
INSERT INTO nod_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","พระองค์​เล่า​แหม​เรื่อง​นึ่ง​หื้อ​หมู่​เขา​ฟัง​ว่า “คน​นึ่ง​มี​ลูก​ป้อจาย​อยู่​สอง​คน ลูกหล้า​นั้น​มา​อู้​กับ​ป้อ​ว่า ");
INSERT INTO nod_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","‘ป้อ​ครับ ขอ​สมบัติ​ตี้​เป๋น​ส่วน​ของ​ลูก​เหีย​เต๊อะ’ ป้อ​ก็​แบ่ง​ทรัพย์​สมบัติ​หื้อ​ลูก​ตึง​สอง​คน ");
INSERT INTO nod_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ได้​สัก​สอง​สาม​วัน​ลูก​คน​หล้า​ก็​เก็บ​เอา​ทรัพย์​สมบัติ ตึง​หมด​ตี้​เป๋น​ของ​เขา​ออก​จาก​บ้าน​ไป​เมือง​ไก๋ แล้ว​ใจ๊​จ่าย​สตางค์​อย่าง​สุรุ่ยสุร่าย ");
INSERT INTO nod_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","เมื่อ​สตางค์​เสี้ยง​หมด​แล้ว ก็​เกิด​กั้น​อยาก​ใน​เมือง​นั้น เขา​ก็​บ่﻿มี​สตางค์​ติด​ตั๋ว​เลย ");
INSERT INTO nod_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","จึง​ไป​ขอ​เยียะ​ก๋าน​กับ​จาว​เมือง​คน​นึ่ง คน​นั้น​ก็​ใจ๊​เขา​ไป​เลี้ยง​หมู​อยู่​ก๋าง​โต้ง ");
INSERT INTO nod_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","เขา​ใค่​อยาก​กิ๋น​หื้อ​อิ่ม​ต้อง แต่​บ่﻿มี​ใผ​หื้อ​อะหยัง​เขา​กิ๋น​สัก​อย่าง แม้แต่​บ่าถั่ว​ตี้​หมู​กิ๋น เขา​ก็​ใค่​อยาก​กิ๋น ");
INSERT INTO nod_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","เมื่อ​เขา​กึ๊ด​ได้​ก็​อู้​ว่า ‘ลูกจ้าง​ของ​ป้อ​เฮา​มี​หลาย​คน ก็​ยัง​มี​ข้าว​กิ๋น​จ๋น​เหลือ ส่วน​ตั๋ว​เฮา​จะ​มา​ต๋าย​เหีย​ตี้​นี่​ย้อน​กั้นอยาก​กา ");
INSERT INTO nod_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","เฮา​จะ​ปิ๊ก​ไป​หา​ป้อ​บอก​เปิ้น​ว่า “ป้อ​ครับ ลูก​ได้​เยียะ​บาป​ต่อ​พระเจ้า​กับ​ต่อ​ป้อ​ตวย ");
INSERT INTO nod_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ลูก​บ่﻿สมควร​จะ​เป๋น​ลูก​ของ​ป้อ ขอ​ฮับ​ลูก​ไว้​เป๋น​ลูกจ้าง​คน​นึ่ง​เต๊อะ” ’ ");
INSERT INTO nod_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","แล้ว​เขา​ก็​ลุก​ขึ้น​ปิ๊ก​ไป​หา​ป้อ เมื่อ​เขา​ยัง​อยู่​ไก๋ ป้อ​หัน​เขา​ก็​มี​ความ​อินดู แล้ว​ล่น​ออก​ไป​กอด​คอ​กับ​จูบ​ลูก ");
INSERT INTO nod_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ฝ่าย​ลูก​ก็​อู้​กับ​ป้อ​ว่า ‘ป้อ​ครับ ลูก​ได้​เยียะ​ผิด​ต่อ​พระเจ้า​กับ​ป้อ​ตวย ลูก​บ่﻿สมควร​เป๋น​ลูก​ของ​ป้อ​ต่อ​ไป’ ");
INSERT INTO nod_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","แต่​ป้อ​สั่ง​หมู่​คน​ฮับใจ๊​ว่า ‘ขะใจ๋​ไป​เอา​เสื้อ​คุม​อย่าง​ดี​ตี้​สุด​มา​นุ่ง​หื้อ​เขา เอา​แหวน​มา​ใส่​นิ้ว​มือ เอา​เกิบ​มา​หื้อ​สุบ ");
INSERT INTO nod_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","บึด​จะ​มี​งาน​เลี้ยง​ฉลอง​เน่อ เลือก​เอา​ลูก​งัว​ตั๋ว​ตุ้ย﻿ๆ มา​ฆ่า​เลี้ยง​กั๋น​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ย้อน​ว่า​ลูก​ของ​เฮา​คน​นี้ ต๋าย​ไป​แล้ว แต่​ได้​ปิ๊ก​เป๋น​ขึ้น​มา​แหม เขา​หาย​ไป​แล้ว​แต่​ได้​มา​ปะ​กั๋น​แหม’ เขา​ตังหลาย​ก็​เริ่ม​ฉลอง​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ลูก​คน​เก๊า​เยียะ​ก๋าน​อยู่​ก๋าง​โต้ง เมื่อ​ปิ๊ก​มา​ใก้​เถิง​บ้าน ก็​ได้ยิน​เสียง​แห่แหน​เต้น​ฟ้อน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","เขา​ฮ้อง​คน​ฮับใจ๊​คน​นึ่ง​มา​ถาม​ว่า ‘เปิ้น​มี​งาน​อะหยัง​กั๋น’ ");
INSERT INTO nod_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ลูก​จ้าง​ก็​ตอบ​ว่า ‘น้อง​ของ​ต้าน​ปิ๊ก​มา​แล้ว ป้อ​ของ​ต้าน​สั่ง​หื้อ​ฆ่า​ลูก​งัว​ตั๋ว​ตุ้ย﻿ๆ กิ๋น​เลี้ยง​กั๋น ย้อน​น้อง​ของ​ต้าน ปิ๊ก​มา​อย่าง​ปลอดภัย’ ");
INSERT INTO nod_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ลูก​คน​เก๊า​ก็​โขด บ่﻿ยอม​เข้า​บ้าน ป้อ​ก็​ออก​มา​ขอฮ้อง​เขา ");
INSERT INTO nod_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","แต่​เขา​ตอบ​ป้อ​ว่า ‘ผ่อ​ลอ ลูก​ได้​ฮับใจ๊​ป้อ​มา​กี่​ปี๋​แล้ว บ่﻿เกย​เหลือ​กำสั่ง​ของ​ป้อ​เลย​สัก​ข้อ ขนาด​แป๊ะ​สัก​ตั๋ว​นึ่ง ป้อ​ก็​ยัง​บ่﻿เกย​หื้อ​ฆ่า​เลี้ยง​เปื้อ​ฉลอง​กับ​เปื้อน​ฝูง ");
INSERT INTO nod_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","แต่​เมื่อ​ลูก​คน​นี้​ของ​ป้อ​ได้​ใจ๊​สมบัติ​จ๋น​หมด​จ๋น​เสี้ยง โดย​ไป​คบ​แม่ญิง​ขาย​ตั๋ว ป้อ​ยัง​ได้​ฆ่า​ลูก​งัว​ตั๋ว​ตุ้ย﻿ๆ เลี้ยง​กั๋น​อยู่​กา’ ");
INSERT INTO nod_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ป้อ​จึง​ตอบ​เขา​ว่า ‘ลูก​เหย ลูก​อยู่​กับ​ป้อ​มา​ตลอด ของ​ของ​ป้อ​ตึง​หมด​ก็​เป๋น​ของ​เจ้า​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","สมควร​ตี้​หมู่​เฮา​จะ​ยินดี​กับ​ฉลอง​กั๋น ย้อน​น้อง​คน​นี้​ต๋าย​แล้ว​แต่​ปิ๊ก​เป๋น​ขึ้น​มา​แหม เขา​หาย​ไป​แล้ว​แต่​ได้​มา​ปะ​กั๋น​แหม’ ” ");
INSERT INTO nod_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","พระเยซู​เล่า​เรื่อง​หื้อ​หมู่​สาวก​ฟัง​ว่า “เศรษฐี​คน​นึ่ง​มี​ป้อบ้าน มี​คน​มา​ฟ้อง​เศรษฐี​ว่า​ป้อบ้าน​ของ​เขา​ใจ๊​จ่าย​สตางค์​บ่﻿ถูก ");
INSERT INTO nod_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","เศรษฐี​จึง​ฮ้อง​ป้อบ้าน​มา​ถาม​ว่า ‘เรื่อง​ตี้​เฮา​ได้ยิน​มา​เป๋น​จาใด หื้อ​เอา​สมุด​บันทึก​ฮับ​จ่าย​ของ​เจ้า​มา​ลอ ย้อน​เจ้า​จะ​เป๋น​ป้อบ้าน​ต่อ​ไป​บ่﻿ได้​แล้ว’ ");
INSERT INTO nod_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ป้อ​บ้าน​คน​นั้น​กึ๊ด​ใน​ใจ๋​ว่า ‘เฮา​จะ​เยียะ​จาใด​ดี ย้อน​นาย​จะ​ถอด​เฮา​ออก​จาก​หน้าตี้ ป้อบ้าน​จะ​ไป​ฮับจ้าง​ขุด​ดิน​ก็​บ่﻿มี​แฮง จะ​ขอ​คน​อื่น​กิ๋น​ก็​อาย​เขา ");
INSERT INTO nod_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","เฮา​กึ๊ด​ได้​แล้ว​ว่า​จะ​เยียะ​จาใด​ดี เปื้อ​ต๋อน​ถูก​ถอด​ออก​จาก​หน้าตี้​ป้อบ้าน คน​อื่น​ยัง​ต้อนฮับ​เฮา​ไว้​ใน​เฮือน​เขา​ต่อ​ไป​ได้’ ");
INSERT INTO nod_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ป้อบ้าน​นั้น​ก็​ฮ้อง​ลูก​หนี้​ของ​นาย​มา​ตึง​หมด​ถาม​คน​หัวที​ว่า ‘ต้าน​เป๋น​หนี้​นาย​ของ​ข้า​เต้าใด’ ");
INSERT INTO nod_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","เขา​ตอบ​ว่า ‘เป๋น​หนี้​น้ำมัน​บ่ากอกเทศ​ร้อย​ถัง’ ป้อบ้าน​บอก​เขา​ว่า ‘เอา​ใบ​แจ้ง​หนี้​มา นั่ง​ลง​ขะใจ๋​แก้​เป๋น​ห้า​สิบ​ถัง​เน่อ’ ");
INSERT INTO nod_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","แล้ว​ถาม​แหม​คน​นึ่ง​ว่า ‘ต้าน​เป๋น​หนี้​เต้าใด’ เขา​ตอบ​ว่า ‘เป๋น​หนี้​ข้าว​สาลี​ร้อย​กระสอบ’ ป้อบ้าน​ก็​บอก​ว่า ‘เอา​ใบ​แจ้ง​หนี้​มา​แก้​เป๋น​แปด​สิบ​กระสอบ​เน่อ’ ");
INSERT INTO nod_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","เศรษฐี​ก็​ยกย่อง​ป้อบ้าน​ขี้โก๋ง​คน​นั้น​ว่า​เขา​หลวก​ใน​เรื่อง​นี้ ย้อน​ว่า​คน​ตังหลาย​ตี้​อยู่​ฝ่าย​โลก​นี้​ก็​หลวก​ใน​เรื่อง​ของ​โลก​นัก​เหลือ​คน​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“เฮา​บอก​ต้าน​ตังหลาย​ว่า หื้อ​ใจ๊​ทรัพย์​สมบัติ​ตี้​มี​อยู่​ใน​โลก​นี้​จ้วย​คน​อื่น​เปื้อ​หื้อ​เป๋น​เปื้อน​กั๋น เปื้อ​ว่า​เมื่อ​ทรัพย์​สมบัติ​เสี้ยง​แล้ว พระเจ้า​จะ​ต้อนฮับ​ต้าน​เข้า​ใน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“คน​ตี้​ซื่อสัตย์​ใน​สิ่ง​หน้อย﻿ๆ จะ​ซื่อสัตย์​ใน​สิ่ง​ตี้​ใหญ่ คน​ตี้​บ่﻿ซื่อสัตย์​ใน​สิ่ง​หน้อย﻿ๆ ก็​จะ​บ่﻿ซื่อสัตย์​ใน​สิ่ง​ใหญ่​ตวย ");
INSERT INTO nod_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","แล้ว​ถ้า​ต้าน​ตังหลาย​บ่﻿ซื่อสัตย์​ใน​ทรัพย์​สมบัติ​ฝ่าย​โลก ใผ​จะ​มอบ​ทรัพย์​สมบัติ​ตี้​เตี้ยง​แต๊​หื้อ​ต้าน​กา ");
INSERT INTO nod_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ถ้า​ต้าน​ตังหลาย​บ่﻿ซื่อสัตย์​ใน​ของ​ของ​คน​อื่น ใผ​จะ​มอบ​ทรัพย์​สมบัติ​ของ​ต้าน​หื้อ​เป๋น​ของ​ต้าน​ได้ ");
INSERT INTO nod_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","บ่﻿มี​ใผ​จะ​ฮับ​ใจ๊​เจ้านาย​สอง​คน​พร้อม​กั๋น​ได้ ย้อน​ว่า​เขา​จะ​จัง​นาย​คน​นึ่ง แล้ว​ก็​ฮัก​นาย​แหม​คน​นึ่ง กาว่า​เขา​ก็​จะ​ซื่อสัตย์​กับ​นาย​คน​นึ่ง แต่​จะ​ดู​ถูก​ดู​แควน​นาย​แหม​คน​นึ่ง เจ้น​เดียว​กั๋น​ต้าน​จะ​ฮับใจ๊​พระเจ้า​แล้ว​จะ​ฮับใจ๊​เงินคำ​พร้อม​กั๋น​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ส่วน​หมู่​ฟาริสี​ตี้​หัน​แก่​เงิน เมื่อ​ได้ยิน​กำ​หมู่​นั้น​ก็​ปา​กั๋น​ใค่​หัว​ใส่​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","พระเยซู​อู้​กับ​หมู่​เขา​ว่า “เจ้า​ตังหลาย​แต่ง​เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม​ต่อหน้า​คน แต่​พระเจ้า​ฮู้​ใจ๋​ของ​ต้าน​ตังหลาย​ดี สิ่ง​ตี้​คน​หัน​ว่า​มี​ก้า​กับ​น่า​นับถือ สำหรับ​พระเจ้า​นั้น​หัน​ว่า​เป๋น​สิ่ง​ตี้​น่า​จัง ");
INSERT INTO nod_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“จาว​ยิว​ได้​ใจ๊​บท​บัญญัติ​ของ​โมเสส​กับ​กำ​เขียน​ของ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า มา​จ๋น​แผว​สมัย​ยอห์น​ผู้​หื้อ​บัพติศมา แล้ว​ก็​มี​ก๋าน​บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า คน​ตังหลาย​ก็​ลู่​กั๋น​เข้า​ไป​ใน​แผ่นดิน​นั้น ");
INSERT INTO nod_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ฟ้า​กับ​ดิน​จะ​ล่วง​ป๊น​ไป ก็​ง่าย​เหลือ​บท​บัญญัติ​ขีด﻿ๆ นึ่ง​จะ​ตก​ไป ");
INSERT INTO nod_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ป้อจาย​คน​ใด​ตี้​ละ​เมีย​ไป​มี​เมีย​ใหม่ ก็​ผิด​เรื่อง​ก๋าน​ล่วง​ประเวณี​แล้ว ถ้า​คน​ใด​ไป​เอา​แม่​ฮ้าง​มา​เป๋น​เมีย ก็​ผิด​เรื่อง​ก๋าน​ล่วง​ประเวณี​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“มี​เศรษฐี​คน​นึ่ง​นุ่ง​ห่ม​ผ้า​รากา​แปง​กับ​ป่าน​อย่าง​ดี กิ๋น​ดี​อยู่​ดี​ตึง​วัน ");
INSERT INTO nod_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","มี​แหม​คน​นึ่ง​เป๋น​ขอ​ตาน​จื้อ​ลาซารัส เป๋น​ตุ่ม​เต๋ม​เนื้อ​เต๋ม​ตั๋ว มี​คน​เอา​เขา​มา​นอน​ไว้​ตี้​ปะตู๋​ฮั้ว​บ้าน​ของ​เศรษฐี ");
INSERT INTO nod_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","เขา​หวัง​ว่า​จะ​ได้​กิ๋น​เศษ​ของ​กิ๋น​ตี้​ตก​จาก​โต๊ะ​อาหาร​ของ​เศรษฐี แม้​แต่​หมา​ก็​มา​เลีย​ตุ่ม​ตี้​เนื้อ​ตั๋ว​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ต่อ​มา​ขอตาน​คน​นั้น​ต๋าย หมู่​ทูตสวรรค์​ก็​ปา​เขา​ไป​อยู่​กับ​อับราฮัม​บน​สวรรค์ แหม​บ่﻿เมิน​เศรษฐี​นั้น​ต๋าย ก็​ถูก​ฝัง​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","แล้ว​ได้​ไป​อยู่​แดน​คน​ต๋าย มี​ความ​ตุ๊ก​เวทนา​ขนาด เศรษฐี​แหงน​ผ่อ​หัน​อับราฮัม​อยู่​ไก๋ ลาซารัส​ก็​อยู่​กับ​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","เศรษฐี​ก็​ฮ้อง​ว่า ‘ป้อ​อับราฮัม​เหย ขอ​อินดู​ข้าพเจ้า​เต๊อะ ขอ​ใจ๊​ลาซารัส​เอา​ป๋าย​นิ้ว​จุ่ม​น้ำ​มา​จิ​ลิ้น​ข้าพเจ้า​หน้อย ข้าพเจ้า​จะ​ได้​เย็น​พ่อง ย้อน​อยู่​ตี้​นี่​เปล๋วไฟ​ฮ้อน ตุ๊ก​ทรมาน​ขนาด’ ");
INSERT INTO nod_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","อับราฮัม​จึง​ตอบ​ว่า ‘ลูก​เหย เจ้า​กึ๊ด​ผ่อ​เต๊อะ​ว่า​เมื่อ​ยัง​มี​จีวิต​อยู่ เจ้า​ได้​ของ​ดี​มา​ตลอด แต่​ลาซารัส​ได้​สิ่ง​บ่﻿ดี​เลย บ่าเดี่ยว​นี้​เขา​ได้ฮับ​ก๋าน​ปลอบใจ๋ แต่​เจ้า​ได้ฮับ​ความ​ตุ๊ก​ทรมาน ");
INSERT INTO nod_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","แหม​อย่าง​นึ่ง หละหว่าง​เฮา​กับ​เจ้า​มี​ห้วย​เลิ็ก​กั้น​อยู่ ใผ​ใค่​ข้าม​จาก​นี่​ไป​หา​เจ้า​ตึง​บ่﻿ได้ กาว่า​จะ​ข้าม​จาก​ตี้​หั้น​มา​หา​เฮา​ก็​บ่﻿ได้’ ");
INSERT INTO nod_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","เศรษฐี​นั้น​จึง​อู้​ว่า ‘ป้อ​ครับ ถ้า​จาอั้น​ขอ​ใจ๊​ลาซารัส​ไป​บ้าน​ป้อ​ข้าพเจ้า​กำ​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ย้อน​ข้าพเจ้า​มี​ปี้น้อง​ห้า​คน​ตวย​กั๋น หื้อ​ลาซารัส​ตักเตื๋อน​หมู่​เขา เผื่อ​ว่า​เมื่อ​หมู่​เขา​ต๋าย​จะ​บ่﻿ได้​เข้า​มา​อยู่​ใน​ตี้​ตุ๊ก​ทรมาน​นี้’ ");
INSERT INTO nod_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","อับราฮัม​จึง​ตอบ​เขา​แหม​ว่า ‘หมู่​เขา​มี​กำสอน​ของ​โมเสส​กับ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​หั้น​แล้ว หื้อ​หมู่​เขา​ฟัง​กำสอน​ของ​หมู่​นั้น​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","เศรษฐี​นั้น​ก็​ว่า ‘บ่﻿ได้ ป้อ​อับราฮัม​ครับ ถ้า​คน​นึ่ง​ตี้​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ปิ๊ก​ไป​บอก​หมู่​เขา﻿ๆ ก็​จะ​กลับใจ๋​จาก​บาป’ ");
INSERT INTO nod_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","อับราฮัม​ก็​บอก​แหม​ว่า ‘ถ้า​หมู่​เขา​บ่﻿ฟัง​สิ่ง​ตี้​โมเสส​กับ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​สอน​มา​แล้ว เถิง​คน​ตี้​เป๋น​ขึ้น​จาก​ความ​ต๋าย จะ​ปิ๊ก​ไป​บอก​เขา﻿ๆ ก็​ตึง​บ่﻿เจื้อ’ ” ");
INSERT INTO nod_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","พระเยซู​อู้​กับ​หมู่​สาวก​ของ​พระองค์​แหม​ว่า “จะ​มี​สิ่ง​ต่าง﻿ๆ ตี้​เยียะ​หื้อ​คน​หลงผิด​แน่นอน แต่​ความ​ฉิบหาย​จะ​เกิด​ขึ้น​กับ​คน​ตี้​เยียะ​หื้อ​เกิด​เรื่อง​จาอี้​นั้น ");
INSERT INTO nod_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ถ้า​เอา​บ่าหิน​โม่​มัด​ติด​คอ​คน​นั้น แล้ว​โจ้ง​ลง​น้ำ​ทะเล​เลิ็ก​เหีย ก็​ยัง​ดี​เหลือ​ตี้​เขา​จะ​เยียะ​หื้อ​คน​ตี้​เป๋น​เหมือน​หละอ่อน​หน้อย​หมู่​นี้​คน​นึ่ง​หลง​ผิด​ไป ");
INSERT INTO nod_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","จง​หละวัง​หื้อ​ดี ถ้า​ปี้น้อง​เยียะ​ผิด​ต่อ​ต้าน หื้อ​เตื๋อน​เขา ถ้า​เขา​ยอมฮับ​ผิด​ก็​หื้อ​ยกโต้ษ​เขา​เหีย ");
INSERT INTO nod_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ถ้า​เขา​จะ​เยียะ​ผิด​ต่อ​ต้าน​วัน​นึ่ง​เจ็ด​เตื้อ แล้ว​ก็​มา​หา​ต้าน​ตึง​เจ็ด​เตื้อ​นั้น แล้ว​บอก​ต้าน​ว่า​ขอ​สูมา​เต๊อะ จง​ยก​โต้ษ​หื้อ​เขา​เหีย” ");
INSERT INTO nod_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","หมู่​อัคร​สาวก​บอก​พระเยซู​ว่า “ขอ​พระองค์​โผด​หื้อ​หมู่​เฮา​มี​ความ​เจื้อ​นัก​ขึ้น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","พระองค์​ก็​บอก​ว่า “ถ้า​หมู่​ต้าน​มี​ความ​เจื้อ​เต้า​เม็ด​มัสตาร์ด​เม็ด​นึ่ง ต้าน​ก็​จะ​สั่ง​ต้น​หม่อน​นี้​ได้​ว่า ‘จง​ถอน​ขึ้น​มา​แล้ว​ลง​ไป​ปัก​อยู่​ใน​ทะเล’ มัน​ก็​จะ​เจื้อฟัง​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ใน​หมู่​ต้าน​มี​ใผ​พ่อง​เมื่อ​คน​ฮับใจ๊​ไป​ไถ​นา กาว่า​ไป​เลี้ยง​แกะ แล้ว​เมื่อ​ปิ๊ก​มา​จะ​อู้​กับ​คน​ฮับใจ๊​ว่า ‘เจิญ​นั่ง​ลง​กิ๋น​ข้าว​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","กาว่า​จะ​บอก​ว่า ‘ดา​ข้าว​หื้อ​เฮา​กิ๋น กับ​เกียม​ตั๋ว​หื้อ​พร้อม​ฮับใจ๊​เฮา​จ๋น​เฮา​กิ๋น​อิ่ม​เหีย​ก่อน แล้ว​เจ้า​ก้อย​กิ๋น​เมื่อ​ลูน’ ");
INSERT INTO nod_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","นาย​จะ​ขอบคุณ​คน​ฮับใจ๊​ย้อน​เขา​ได้​เยียะ​ต๋าม​กำสั่ง​กา ");
INSERT INTO nod_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","จาใด​ก็​ดี เมื่อ​ต้าน​ตังหลาย​ได้​เยียะ​กู้​สิ่ง​ตี้​เฮา​สั่ง​หื้อ​เยียะ​นั้น ก็​คง​จะ​อู้​ว่า ‘ข้าพเจ้า​ตังหลาย​เป๋น​คน​ฮับใจ๊ บ่﻿ได้​มี​บุญคุณ​ต่อ​นาย หมู่​ข้าพเจ้า​เยียะ​ต๋าม​หน้าตี้​ตี้​ควร​จะ​เยียะ​เต้าอั้น’ ” ");
INSERT INTO nod_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","เมื่อ​พระเยซู​ก่ำลัง​ไป​กรุง​เยรูซาเล็ม พระองค์​ก็​เลาะ​หละหว่าง​แคว้น​กาลิลี​กับ​แคว้น​สะมาเรีย ");
INSERT INTO nod_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","เมื่อ​พระเยซู​ไป​ตี้​หมู่​บ้าน​แห่ง​นึ่ง มี​คน​เป๋น​ขี้ตู้ด​สิบ​คน​มา​หา​พระองค์ หมู่​เขา​ยืน​อยู่​จ้าดไก๋ ");
INSERT INTO nod_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","แล้ว​ก็​ฮ้อง​เสียง​ดัง​ว่า “เยซู นาย​เจ้า​ข้า ขอ​อินดู​ข้าพเจ้า​ตังหลาย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","เมื่อ​พระองค์​หัน​แล้ว​ก็​อู้​ว่า “จง​ไป​แสดง​ตั๋ว​ต่อ​หมู่​ปุโรหิต​เต๊อะ หื้อ​เขา​กวด​ผ่อ​ก่อน” เมื่อ​ก่ำลัง​เตียว​ไป​เขา​ตังหลาย​ก็​หาย​สะอาด ");
INSERT INTO nod_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","มี​คน​นึ่ง​ใน​หมู่​นั้น​เมื่อ​หัน​ว่า ตั๋ว​หาย​โรค​แล้ว ก็​ปิ๊ก​มา​ฮ้อง​เสียง​ดัง​สรรเสริญ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","กับ​ก้ม​ลง​ไหว้​ตี้​ตี๋น​ของ​พระเยซู ขอบ​พระคุณ​พระองค์ คน​นั้น​เป๋น​จาว​สะมาเรีย ");
INSERT INTO nod_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","พระเยซู​ก็​ถาม​เขา​ว่า “มี​สิบ​คน​หาย​โรค​บ่﻿ใจ้​กา แล้ว​เก้า​คน​นั้น​ไป​ไหน​เหีย​หมด ");
INSERT INTO nod_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","บ่﻿มี​ใผ​ปิ๊ก​มา​สรรเสริญ​พระเจ้า​นอก​จาก​คน​ต่างจ้าด​คน​นี้​เต้าอั้น​กา” ");
INSERT INTO nod_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","แล้ว​พระองค์​ก็​บอก​คน​นั้น​ว่า “ลุก​ขึ้น​ไป​เต๊อะ​ความ​เจื้อ​ของ​เจ้า​ได้​เยียะ​หื้อ​เจ้า​หาย​เป๋น​ปกติ​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","มี​หมู่​ฟาริสี​ถาม​พระองค์​ว่า “แผ่นดิน​ของ​พระเจ้า​จะ​มา​แผว​เมื่อ​ใด” พระเยซู​ตอบ​เขา​ว่า “แผ่นดิน​ของ​พระเจ้า​จะ​บ่﻿มา​โดย​หื้อ​หัน​กับ​ต๋า ");
INSERT INTO nod_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","จะ​บ่﻿มี​ใผ​อู้​ว่า ‘มา​แผว​แล้ว มา​ผ่อ​นี่​ลอ’ กาว่า ‘ไป​ผ่อ​ปู๊น’ ย้อน​ว่า​แผ่นดิน​ของ​พระเจ้า​อยู่​ต้ามก๋าง​ต้าน​ตังหลาย” ");
INSERT INTO nod_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","เมื่อ​ลูน​มา​พระเยซู​อู้​กับ​หมู่​สาวก​ว่า “จะ​มี​เวลา​นึ่ง​เมื่อ​ต้าน​ตังหลาย​จะ​ใค่​หัน​วัน​ตี้​เฮา​ผู้​เป๋น​บุตรมนุษย์​จะ​มา​แหม แต่​หมู่​ต้าน​จะ​บ่﻿หัน ");
INSERT INTO nod_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","จะ​มี​คน​อู้​กับ​ต้าน​ตังหลาย​ว่า ‘มา​ผ่อ​นี่’ กาว่า ‘ไป​ผ่อ​ปู๊น พระองค์​มา​แล้ว’ ห้าม​ออก​ไป​ตวย​เขา​เน่อ ");
INSERT INTO nod_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ย้อน​ว่า​เมื่อ​วัน​ตี้​บุตรมนุษย์​ปิ๊ก​มา ก็​เผียบ​เหมือน​ฟ้า​แมบ​เผิก​นึ่ง​ก็​จะ​แจ้ง​ไป​แหม​เผิก​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","แต่​จ๋ำ​เป๋น​ตี้​บุตรมนุษย์​จะ​ต้อง​ทน​ตุ๊ก​ทรมาน​หลาย​อย่าง​เหีย​ก่อน กับ​คน​สมัย​นี้​จะ​บ่﻿ยอมฮับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“เมื่อ​บุตรมนุษย์​จะ​มา​ก็​จะ​เป๋น​อย่าง​เดียว​กับ​ใน​สมัย​ของ​โนอาห์ ");
INSERT INTO nod_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","คน​ตังหลาย​ได้​กิ๋น​กับ​ดื่ม มี​ก๋าน​แต่งงาน​กั๋น ตึง​ยก​ลูก​หื้อ​เป๋น​ผัว​เมีย​กั๋น จ๋น​เถิง​วัน​ตี้​โนอาห์​ได้​เข้า​ไป​ใน​เฮือ แล้ว​น้ำ​ก็​ท่วม​โลก​จ๋น​คน​ต๋าย​หมด ");
INSERT INTO nod_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ใน​สมัย​ของ​โลท​ก็​เหมือน​กั๋น คน​ตังหลาย​ได้​กิ๋น ได้​ดื่ม ได้​หว่าน ได้​ปูก ได้​ซื้อ​ขาย ได้​ก่อ​สร้าง ");
INSERT INTO nod_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","แต่​ใน​วัน​ตี้​โลท​ออก​จาก​เมือง​โสโดม​นั้น ไฟ​กำมะถัน​ก็​ตก​จาก​ฟ้า เผา​ไหม้​คน​หมู่​นั้น​หมด ");
INSERT INTO nod_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","เมื่อ​บุตรมนุษย์​จะ​มา​ก็​จะ​เป๋น​จาอั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ใน​วัน​นั้น​คน​ตี้​อยู่​บน​ดาดฟ้า​หลังคา​บ้าน ห้าม​ปิ๊ก​เข้า​ไป​เก็บ​คัว​อะหยัง​เน่อ คน​ตี้​อยู่​ต๋าม​โต้ง​ต๋าม​นา​ก็​ห้าม​ปิ๊ก​บ้าน​เน่อ ");
INSERT INTO nod_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","จง​กึ๊ด​เถิง​เมีย​ของ​โลท​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","คน​ใด​ฮิ​เอา​จีวิต​ของ​ตั๋ว​รอด คน​นั้น​จะ​ฮักษา​จีวิต​นั้น​บ่﻿ได้​ก็​จะ​ต๋าย แต่​คน​ใด​ยอม​สละ​จีวิต​ของ​ตั๋ว ก็​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","เฮา​บอก​ต้าน​ตังหลาย​ว่า ใน​คืน​นั้น​สอง​คน​ตี้​นอน​อยู่​ตวย​กั๋น คน​นึ่ง​จะ​ถูก​ฮับ​ไป​แต่​แหม​คน​นึ่ง​จะ​ถูก​ละ​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","กับ​แม่ญิง​สอง​คน​ก่ำลัง​โม่​แป้ง​อยู่​ตวย​กั๋น คน​นึ่ง​จะ​ถูก​ฮับ​ไป​แต่​แหม​คน​นึ่ง​จะ​ถูก​ละ​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","สอง​คน​อยู่​ใน​โต้ง​นา จะ​เอา​ไป​คน​นึ่ง ละ​ไว้​คน​นึ่ง” ");
INSERT INTO nod_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","หมู่​สาวก​จึง​ถาม​พระองค์​ว่า “อาจ๋ารย์​ครับ จะ​เกิด​ขึ้น​ตี้​ไหน” พระองค์​ตอบ​หมู่​เขา​ว่า “ตี้​ไหน​มี​ซาก​ศพ ตี้​หั้น​ก็​จะ​มี​หมู่​แฮ้ง​หลุ้ม​ต๋อม​กั๋น​เต๋ม​ไป​หมด” ");
INSERT INTO nod_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","พระเยซู​อู้​กำเผียบ​ข้อ​นึ่ง​หื้อ​หมู่​สาวก​ฟัง​เปื้อ​จะ​สอน​ว่า คน​ตังหลาย​ควร​อธิษฐาน​อยู่​เสมอ​อย่าง​บ่﻿อ่อนใจ๋ ");
INSERT INTO nod_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","พระองค์​อู้​ว่า “ใน​เมือง​นึ่ง​มี​ผู้​พิพากษา​คน​นึ่ง​ตี้​บ่﻿เก๋งกั๋ว​พระเจ้า​และ​บ่﻿สนใจ๋​ใผ ");
INSERT INTO nod_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ใน​เมือง​นั้น​มี​แม่​หม้าย​คน​นึ่ง​มา​หา​ผู้​พิพากษา​คน​นั้น บอก​เขา​ว่า ‘ขอ​หื้อ​ความ​ยุติธรรม​กับ​คดี​ของ​ข้าเจ้า​น่อย’ ");
INSERT INTO nod_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","เวลา​ผ่าน​ไป​เมิน​แล้ว ผู้​พิพากษา​คน​นั้น​ก็​บ่﻿ยอม​จ้วย แต่​เมื่อ​ลูน​เขา​กึ๊ด​ใน​ใจ๋​ว่า ‘เถิง​เฮา​นี้​จะ​บ่﻿เก๋งกั๋ว​พระเจ้า กับ​บ่﻿สนใจ๋​ใผ ");
INSERT INTO nod_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","แต่​แม่​หม้าย​คน​นี้​มา​รบก๋วน​เฮา​เจื่อ﻿ๆ เฮา​จะ​หื้อ​ความ​ยุติธรรม​แก่​นาง นาง​จะ​บ่﻿มา​รบก๋วน​เฮา​หื้อ​รำคาญ​ใจ๋​แหม’ ” ");
INSERT INTO nod_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","พระเยซู​บอก​หมู่​เขา​ว่า “หื้อ​ฟัง​กำ​อู้​ผู้​พิพากษา​บ่﻿ยุติธรรม​คน​นี้​ลอ ");
INSERT INTO nod_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","พระเจ้า​จะ​บ่﻿หื้อ​ความ​ยุติธรรม​แก่​คน​ตี้​เลือก​ไว้ ตี้​ฮ้อง​ขอ​ต่อ​พระองค์​ตึง​เมื่อวัน​เมื่อคืน​กา พระองค์​จะ​อด​ใจ๋​ได้​เมิน​กา ");
INSERT INTO nod_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","เฮา​บอก​ต้าน​ตังหลาย​ว่า พระองค์​จะ​หื้อ​ความ​ยุติธรรม​กับ​หมู่​เขา​เวย﻿ๆ แต่​เมื่อ​เฮา​ผู้​เป๋น​บุตรมนุษย์​มา​แหม​เตื้อ เฮา​จะ​ปะ​คน​ตี้​เจื้อ​อยู่​สัก​กี่​คน​บ่﻿ฮู้” ");
INSERT INTO nod_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","สำหรับ​บาง​คน​ตี้​มั่นใจ๋​ตั๋ว​เก่า​ว่า เป๋น​คน​ถูกต้อง​ต๋าม​ธรรม​แล้ว​ดู​หมิ่น​คน​อื่น​นั้น พระองค์​อู้​กำเผียบ​หื้อ​ฟัง​ว่า ");
INSERT INTO nod_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“มี​สอง​คน​ขึ้น​ไป​อธิษฐาน​ใน​พระวิหาร คน​นึ่ง​เป๋น​ฟาริสี​แหม​คน​นึ่ง​เป๋น​คน​เก็บ​ภาษี ");
INSERT INTO nod_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","คน​ฟาริสี​หยิ่ง​จ๋องหอง​คน​นั้น​ลุก​ขึ้น​ยืน​อธิษฐาน​ว่า ‘พระองค์​เจ้า​ข้า ขอบพระคุณ​พระองค์​ตี้​ข้าพเจ้า​บ่﻿เหมือน​คน​อื่น ตี้​เป๋น​คน​โลภ​คน​บ่﻿ดี คน​ล่วง​ประเวณี กับ​บ่﻿เหมือน​คน​เก็บ​ภาษี​คน​นี้ ");
INSERT INTO nod_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ใน​หว่าง​ติ๊ด​นึ่ง​ข้าพเจ้า​ถือ​ศีล​อด​อาหาร​สอง​เตื้อ กับ​กู้​สิ่ง​ตี้​ข้าพเจ้า​ฮิ​หา​มา​ได้ ข้าพเจ้า​ก็​เอา​นึ่ง​ใน​สิบ​ส่วน​มา​ถวาย’ ");
INSERT INTO nod_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“ส่วน​คน​เก็บ​ภาษี​ยืน​อยู่​จ้าดไก๋ บ่﻿แหงน​หน้า​ผ่อ​ต๊องฟ้า แต่​เสียใจ๋​ตุ๊บ​อก​ตั๋วเก่า อู้​ว่า ‘พระองค์​เจ้า​ข้า ขอ​โผด​เมตต๋า​ข้าพเจ้า​ตี้​เป๋น​คน​บาป​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","เฮา​บอก​ต้าน​ตังหลาย​ว่า เมื่อ​ปิ๊ก​บ้าน​คน​เก็บ​ภาษี​คน​นี้​ละ​เป๋น​คน​ตี้​พระเจ้า​ยก​โต้ษ​บาป​หื้อ บ่﻿ใจ้​ฟาริสี ย้อน​ว่า​กู้​คน​ตี้​ยก​ตั๋ว​ขึ้น​จะ​ถูก​เต็ก​หื้อ​ต่ำ​ลง ส่วน​คน​ตี้​ถ่อม​ตั๋ว​ลง​ก็​จะ​ได้ฮับ​ก๋าน​ยก​ขึ้น” ");
INSERT INTO nod_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ต่อ​มา​มี​บาง​คน​ปา​หละอ่อน​หน้อย﻿ๆ ของ​หมู่​เขา​เข้า​มา​หา​พระองค์ เปื้อ​หื้อ​พระองค์​วาง​มือ​ปั๋น​ปอน​หละอ่อน​หมู่​นั้น หมู่​สาวก​เมื่อ​หัน​จาอั้น ก็​ว่า​หื้อ​เขา ");
INSERT INTO nod_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","แต่​พระเยซู​ฮ้อง​หื้อ​เขา​ปา​หละอ่อน​เข้า​มา แล้ว​อู้​กับ​หมู่​สาวก​ว่า “หื้อ​หมู่​หละอ่อน​เข้า​มา​หา​เฮา​เต๊อะ บ่﻿ดี​ห้าม​เขา​ไว้ ย้อน​ว่า​แผ่นดิน​ของ​พระเจ้า​เป๋น​ของ​คน​ตี้​เผียบ​เหมือน​หละอ่อน​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ใด​บ่﻿ฮับ​เอา​แผ่นดิน​ของ​พระเจ้า​เหมือน​หละอ่อน​หน้อย​หมู่​นี้​คน​นั้น​จะ​เข้า​แผ่นดิน​ของ​พระเจ้า​ตึง​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","มี​ผู้​นำ​จาว​ยิว​คน​นึ่ง​ถาม​พระเยซู​ว่า “อาจ๋ารย์​ผู้​ดี​เลิศ ข้าพเจ้า​จะ​ต้อง​เยียะ​ความ​ดี​อะหยัง​พ่อง​เถิง​จะ​ได้​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","พระองค์​ตอบ​เขา​ว่า “ต้าน​ฮ้อง​เฮา​ว่า​ผู้​ดี​เลิศ​เยียะ​หยัง บ่﻿มี​ใผ​ดี​เลิศ​นอก​จาก​พระเจ้า​องค์​เดียว​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ต้าน​ฮู้​บท​บัญญัติ​แล้ว​ตี้​ว่า ‘ห้าม​เป๋น​จู๊​ผัว​เมีย​เปิ้น ห้าม​ฆ่า​คน ห้าม​ลัก​ของ​ของ​เปิ้น ห้าม​เป๋น​พยาน​ตี้​อู้​บ่﻿แต๊ จง​เคารพ​นับถือ​ป้อ​แม่​ของ​ตั๋ว’ ” ");
INSERT INTO nod_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","คน​นั้น​ตอบ​พระองค์​ว่า “ข้อ​ต่าง﻿ๆ ใน​บท​บัญญัติ​นี้ ข้าพเจ้า​ได้​ถือ​ฮักษา​กู้​ข้อ​บ่﻿ได้​ขาด​ตั้งแต่​เป๋น​หละอ่อน​มา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","เมื่อ​พระเยซู​ได้ยิน​จาอั้น​ก็​บอก​เขา​ว่า “ต้าน​ยัง​บ่﻿ได้​เยียะ​แหม​อย่าง​นึ่ง​คือ​หื้อ​ไป​ขาย​ของ​กู้​อย่าง​ตี้​ต้าน​มี​อยู่ แล้ว​เอา​สตางค์​ไป​แจก​คน​ตุ๊ก​คน​จ๋น ต้าน​จึง​จะ​มี​สมบัติ​ใน​สวรรค์ แล้ว​ตวย​เฮา​มา​เป๋น​สาวก​ของ​เฮา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","เมื่อ​เขา​ได้ยิน​จาอั้น ใจ๋​ก็​เป๋น​ตุ๊ก​หนัก ย้อน​เขา​เป๋น​คน​รวย​นัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","พระเยซู​หัน​เขา​เป๋น​ตุ๊ก​จาอั้น จึง​อู้​ว่า “คน​รวย​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​ก็​ยาก​นัก​แก ");
INSERT INTO nod_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ตั๋ว​อูฐ​ลอด​เข้า​ฮู​เข็ม​ยัง​ง่าย​เหลือ​ตี้​คน​รวย​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​แหม​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","คน​ตังหลาย​ตี้​ได้ยิน​จึง​ถาม​ว่า “ถ้า​จาอั้น ใผ​จะ​รอด​ป๊น​บาป​โต้ษ​ได้” ");
INSERT INTO nod_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","พระเยซู​ก็​ตอบ​ว่า “สำหรับ​คน เป๋น​ไป​บ่﻿ได้​อยู่​แล้ว แต่​สำหรับ​พระเจ้า​กู้​สิ่ง​กู้​อย่าง​เป๋น​ไป​ได้​ตึงหมด” ");
INSERT INTO nod_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","เปโตร​ถาม​พระเยซู​ว่า “ผ่อ​ลอ หมู่​เฮา​ได้​ละ​บ้าน​ละ​เฮือน​ติดต๋าม​พระองค์​มา” ");
INSERT INTO nod_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","พระองค์​ตอบ​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ใด​ได้​ละ​บ้าน​ละ​เฮือน ปี้น้อง ป้อ​แม่ ลูก​เมีย​เปื้อ​หัน​แก่​แผ่นดิน​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ก็​จะ​ได้ฮับ​ผล​ตอบแตน​เป๋น​หลาย​เต้า​ใน​โลก​นี้ กับ​ใน​โลก​หน้า​เขา​จะ​ได้​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","พระเยซู​ฮ้อง​หมู่​สาวก​สิบ​สอง​คน​เข้า​มา​หา​พระองค์ แล้ว​บอก​หมู่​เขา​ว่า “หมู่​เฮา​ก่ำลัง​จะ​ไป​กรุง​เยรูซาเล็ม เรื่อง​ราว​กู้​อย่าง​ตี้​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​เขียน​ไว้​เกี่ยว​กับ​บุตรมนุษย์​นั้น​ก็​จะ​เป๋น​แต๊ ");
INSERT INTO nod_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","คือ​บุตรมนุษย์​จะ​ถูก​มอบ​หื้อ​คน​ต่างจ้าด หมู่​เขา​จะ​เยาะเย้ย​ต้าน ดู​ถูก​ดู​แควน​กับ​ถ่ม​น้ำลาย​ใส่​ต้าน ");
INSERT INTO nod_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","หมู่​เขา​จะ​เฆี่ยน​ตี๋​ต้าน แล้ว​ฆ่า​ต้าน​ต๋าย แต่​ใน​วัน​ตี้​สาม​พระเจ้า​จะ​เยียะ​หื้อ​ต้าน​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","หมู่​สาวก​บ่﻿เข้าใจ๋​สิ่ง​หมู่​นี้ ความหมาย​ของ​สิ่ง​หมู่​นี้​หมู่​เขา​กึ๊ด​บ่﻿เถิง หมู่​เขา​เลย​บ่﻿ฮู้​ว่า​พระองค์​อู้​เถิง​เรื่อง​อะหยัง ");
INSERT INTO nod_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","เมื่อ​พระองค์​มา​ใก้​จะ​เถิง​เมือง​เยรีโค มี​คน​ต๋า​บอด​คน​นึ่ง​นั่ง​ขอ​ตาน​อยู่​ฮิม​หนตาง ");
INSERT INTO nod_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","เมื่อ​เขา​ได้ยิน​เสียง​คน​ตังหลาย​เตียว​ก๋าย​มา ก็​ถาม​ว่า​เกิด​อะหยัง​ขึ้น​กา ");
INSERT INTO nod_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","หมู่​เขา​ก็​บอก​ว่า “เยซู​จาว​นาซาเร็ธ​ก่ำลัง​เตียว​ก๋าย​มา” ");
INSERT INTO nod_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","คน​ต๋า​บอด​จึง​ฮ้อง​เอิ้น​เสียง​ดัง​ว่า “เยซู บุตร​ของ​กษัตริย์​ดาวิด​เหย ขอ​โผด​อินดู​ข้า​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","คน​ตี้​เตียว​ไป​ตังหน้า​เขา​ก็​ว่า​หื้อ​ดัก​เหีย แต่​เขา​ก็​เอิ้น​ดัง​ขึ้น​ติก﻿ๆ ว่า “บุตร​ของ​กษัตริย์​ดาวิด​เหย ขอ​โผด​อินดู​ข้า​น่อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","พระเยซู​หยุด​ยืน​อยู่ สั่ง​หื้อ​คน​ปา​เขา​เข้า​มา​หา​พระองค์ เมื่อ​คน​ต๋าบอด​เข้า​มา​ใก้​แล้ว พระองค์​จึง​ถาม​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“เจ้า​ต้องก๋าน​หื้อ​เฮา​เยียะ​อะหยัง​หื้อ​กา” เขา​ตอบ​ว่า “องค์​พระผู้เป๋นเจ้า ข้าพเจ้า​ใค่​ผ่อ​หัน” ");
INSERT INTO nod_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","พระเยซู​บอก​เขา​ว่า “จง​ผ่อ​หัน​เต๊อะ ความ​เจื้อ​ของ​เจ้า​เยียะ​หื้อ​ต๋า​ของ​เจ้า​หาย​บอด​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","เขา​ก็​ผ่อ​หัน​ได้​บ่า​เดียว​นั้น​เลย แล้ว​เขา​ก็​ตวย​พระองค์​ไป​สรรเสริญ​พระเจ้า​ไป​ตวย เมื่อ​คน​ตังหลาย​หัน​จาอั้น​ก็​สรรเสริญ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","พระเยซู​เตียว​ผ่าน​เมือง​เยรีโค ");
INSERT INTO nod_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","มี​ป้อจาย​คน​นึ่ง​จื้อ​ศักเคียส เป๋น​หัวหน้า​คน​เก็บ​ภาษี​กับ​เป๋น​คน​ร่ำรวย ");
INSERT INTO nod_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ศักเคียส​ใค่​หัน​พระเยซู​เลย​ฮิ​ผ่อ​ว่า​เป๋น​คน​ใด แต่​ผ่อ​บ่﻿หัน​ย้อน​มี​คน​นัก ซ้ำ​เขา​ก็​เป๋น​คน​ป็อก ");
INSERT INTO nod_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","เขา​จึง​ล่น​ไป​ตัง​หน้า​ขึ้น​เก๊า​บ่าเดื่อ​ตี้​อยู่​ฮิม​ตาง เปื้อ​จะ​ผ่อ​หัน​พระเยซู​ย้อน​ว่า​พระองค์​จะ​ก๋าย​ไป​ตาง​หั้น ");
INSERT INTO nod_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","เมื่อ​พระเยซู​มา​แผว ก็​แหงน​ผ่อ​ศักเคียส แล้ว​อู้​ว่า “ศักเคียส​เหย​ขะใจ๋​ลง​มา​เวย﻿ๆ วัน​นี้​เฮา​จะ​ย้าง​ตี้​บ้าน​ของ​ต้าน” ");
INSERT INTO nod_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","เขา​ก็​ฟั่ง​ลง​มา แล้ว​ต้อนฮับ​พระองค์​ด้วย​ความ​จื้นจมยินดี ");
INSERT INTO nod_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","คน​ตังหลาย​หัน​จาอั้น ก็​ปา​กั๋น​จ่ม​ว่า “พระเยซู​ไป​ย้าง​อยู่​กับ​คน​บาป” ");
INSERT INTO nod_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ต๋อน​อยู่​ใน​บ้าน ศักเคียส​ลุก​ขึ้น​อู้​กับ​พระเยซู​ว่า “องค์​พระผู้เป๋นเจ้า บ่าเดี่ยว​นี้​ทรัพย์​สิ่งของ​ของ​ข้าพเจ้า ข้าพเจ้า​จะ​แบ่ง​หื้อ​คน​ตุ๊ก​เกิ่ง​นึ่ง ตี้​ได้​โก๋ง​อะหยัง​ของ​ใผ​มา ข้าพเจ้า​จะ​ส้าย​คืน​หื้อ​เขา​สี่​เต้า” ");
INSERT INTO nod_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","พระเยซู​บอก​เขา​ว่า “วัน​นี้​คน​ใน​เฮือน​นี้​ได้ฮับ​ความ​รอด​ป๊น​บาป​โต้ษ​แล้ว ย้อน​คน​นี้​เป๋น​เจื๊อสาย​ของ​อับราฮัม​ตวย ");
INSERT INTO nod_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ย้อน​ว่า​บุตรมนุษย์​มา​เปื้อ​จะ​เซาะ​หา​แล้ว​จ้วย​คน​ตี้​หลง​หาย​หื้อ​รอด​ป๊น​บาป​โต้ษ” ");
INSERT INTO nod_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","เมื่อ​เขา​ตังหลาย​ก่ำลัง​ฟัง​อยู่ พระองค์​อู้​กำเผียบ​แหม​เรื่อง​นึ่ง ย้อน​พระองค์​มา​ใก้​กรุง​เยรูซาเล็ม​แล้ว เขา​ตังหลาย​ก็​กึ๊ด​ว่า​แผ่นดิน​ของ​พระเจ้า​จะ​เริ่ม​ต้น​ขึ้น​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ย้อน​จาอั้น​พระองค์​จึง​อู้​ว่า “มี​เจ้านาย​คน​นึ่ง​เกิด​มา​ใน​ผะกุ๋น​กษัตริย์ ต้าน​จะ​ไป​เมือง​ไก๋​เปื้อ​ฮับ​ก๋าน​แต่งตั้ง​เป๋น​กษัตริย์​แล้ว​ปิ๊ก​มา ");
INSERT INTO nod_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ต้าน​จึง​ฮ้อง​คน​ฮับใจ๊​สิบ​คน​มา​เอา​สตางค์​หื้อ​หมู่​เขา​คน​ละ​นึ่ง​มินา​บอก​ว่า ‘เอา​ไป​เป๋น​ตืน​ก๊า​ขาย​จ๋น​แผว​วัน​ตี้​เฮา​ปิ๊ก​มา​เน่อ’ ");
INSERT INTO nod_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","จาว​เมือง​นั้น​จัง​เจ้านาย​คน​นี้ จึง​ใจ๊​คน​ตวย​ไป​บอก​จักรพรรดิ​ว่า ‘เฮา​บ่﻿ยอมฮับ​คน​นี้​เป๋น​กษัตริย์​ปกครอง​เฮา’ ");
INSERT INTO nod_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“แต่​เมื่อ​ต้าน​ได้ฮับ​แต่งตั้ง​เป๋น​กษัตริย์​แล้ว​ก็​ปิ๊ก​มา จึง​ฮ้อง​หมู่​คน​ฮับใจ๊​ตี้​ได้​หื้อ​สตางค์​ไว้​มา​หา เปื้อ​จะ​ผ่อ​ว่า​ใผ​ได้​ก่ำไฮ​เต้า​ใด ");
INSERT INTO nod_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","คน​ตี้​นึ่ง​บอก​ว่า ‘นาย​เจ้าข้า​สตางค์​ตี้​หื้อ​ข้าพเจ้า​ไว้​นึ่ง​มินา​นั้น​ข้าพเจ้า​ได้​ก่ำไฮ​มา​สิบ​เต้า’ ");
INSERT INTO nod_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","นาย​ก็​อู้​กับ​เขา​ว่า ‘ดี​แล้ว เจ้า​เป๋น​คน​ฮับใจ๊​ตี้​ดี ย้อน​เจ้า​ซื่อสัตย์​ใน​สิ่ง​เล็ก﻿ๆ หน้อย﻿ๆ เฮา​จึง​มอบ​อำนาจ​หื้อ​เจ้า​ปกครอง​สิบ​เมือง’ ");
INSERT INTO nod_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","คน​ตี้​สอง​มา​บอก​ว่า ‘นาย​เจ้าข้า สตางค์​ตี้​หื้อ​ข้าพเจ้า​ไว้​นึ่ง​มินา​นั้น ข้าพเจ้า​ได้​ก่ำไฮ​มา​ห้า​เต้า’ ");
INSERT INTO nod_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","นาย​ก็​อู้​กับ​เขา​อย่าง​เดียว​กั๋น​ว่า ‘เฮา​จึง​มอบ​อำนาจ​หื้อ​เจ้า​ปกครอง​ห้า​เมือง’ ");
INSERT INTO nod_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","แหม​คน​นึ่ง​มา​บอก​ว่า ‘นาย​เจ้าข้า​สตางค์​ตี้​หื้อ​ข้าพเจ้า​ไว้​นึ่ง​มินา​นั้น ข้าพเจ้า​เอา​ห่อ​ผ้า​ป๊ก​เก็บ​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ย้อน​ข้าพเจ้า​กั๋ว​ว่า นาย​เป๋น​คน​เขี้ยว ต้าน​ยึด​ก่ำไฮ​เอา​จาก​งาน​ของ​คน​อื่น กับ​เก็บ​เกี่ยว​สิ่ง​ตี้​ต้าน​บ่﻿ได้​ปูก’ ");
INSERT INTO nod_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","เจ้านาย​ก็​ตอบ​เขา​ว่า ‘ไอ่​ขี้ข้า​บ่﻿ดี เฮา​จะ​เอา​กำ​ของ​เจ้า​นั้น​ละ​ลง​โต้ษ​เจ้า เจ้า​ฮู้​ว่า​เฮา​เป๋น​คน​ใจ๋​แข็ง ตี้​ยึด​ก่ำไฮ​เอา​จาก​งาน​ของ​คน​อื่น กับ​เก็บเกี่ยว​ใน​สิ่ง​ตี้​เฮา​บ่﻿ได้​ปูก ");
INSERT INTO nod_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","เป๋น​จาใด​บ่﻿เอา​สตางค์​นั้น​ไป​ฝาก​ธนาคาร​ไว้ เมื่อ​เฮา​ปิ๊ก​มา​ก็​จะ​ได้​สตางค์​ตึง​ต้น​ตึง​ดอก’ ");
INSERT INTO nod_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“แล้ว​เจ้านาย​ก็​สั่ง​คน​ตี้​ยืน​อยู่​ใก้﻿ๆ หั้น​ว่า ‘เอา​สตางค์​นึ่ง​มินา​จาก​เขา​ไป​หื้อ​คน​ตี้​มี​สิบ​มินา’ ");
INSERT INTO nod_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","คน​นั้น​ก็​ว่า ‘นาย​ครับ เขา​มี​สิบ​มินา​แล้ว​ลอ’ ");
INSERT INTO nod_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","นาย​ก็​ตอบ​ว่า ‘เฮา​บอก​เจ้า​ตังหลาย​ว่า คน​ตี้​มี​อยู่​แล้ว​ก็​จะ​เตื่อม​หื้อ​แหม ส่วน​คน​ตี้​บ่﻿มี แม้​แต่​สิ่ง​ตี้​เขา​มี​อยู่​นั้น​ก็​จะ​เอา​ไป​จาก​เขา​เหีย ");
INSERT INTO nod_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ส่วน​หมู่​ศัตรู๋​ตังหลาย​ตี้​บ่﻿ยอม​หื้อ​เฮา​เป๋น​กษัตริย์​ปกครอง​เขา หื้อ​ปา​มา​นี้​ฆ่า​เหีย​ต่อ​หน้า​เฮา’ ” ");
INSERT INTO nod_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","หลังจาก​ตี้​พระเยซู​อู้​เรื่อง​หมู่​นั้น​แล้ว พระองค์​เตียว​นำ​หมู่​เขา​ขึ้น​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","เมื่อ​พระองค์​มา​เถิง​ใก้​หมู่​บ้าน​เบธฟายี​กับ​หมู่บ้าน​เบธานี ตี้​ดอย​บ่ากอกเทศ พระองค์​ใจ๊​สาวก​สอง​คน​เข้า​ไป​ก่อน ");
INSERT INTO nod_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","สั่ง​ว่า “หื้อ​เข้า​ไป​ใน​หมู่​บ้าน​ตี้​อยู่​ตัง​หน้า​หั้น​เน่อ ตันที​ตี้​เข้า​ไป​แล้ว​จะ​ปะ​ลูก​ลา​ตั๋ว​นึ่ง​มัด​อยู่ ลา​ตั๋ว​นี้​ยัง​บ่﻿มี​ใผ​เกย​ขี่​กำ​เตื้อ หื้อ​แก้​เจื้อก​แล้ว​จู๋ง​มา​ตี้​นี่​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ถ้า​มี​ใผ​ถาม​ว่า​แก้​เจื้อก​ลา​เยียะ​หยัง ก็​บอก​เขา​ว่า ‘นาย​เฮา​ต้องก๋าน​ลูก​ลา​ตั๋ว​นี้’ ” ");
INSERT INTO nod_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","สาวก​สอง​คน​นั้น​ไป ก็​ปะ​เหมือน​ตี้​พระองค์​บอก ");
INSERT INTO nod_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","เมื่อ​หมู่​เขา​ก่ำลัง​แก้​เจื้อก​อยู่ เจ้า​ของ​ลา​ก็​ถาม​เขา​ว่า “แก้​เจื้อก​ลา​เยียะ​หยัง” ");
INSERT INTO nod_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","เขา​ก็​ตอบ​ว่า “องค์​พระผู้เป๋นเจ้า​ต้องก๋าน​ใจ๊” ");
INSERT INTO nod_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","แล้ว​หมู่​เขา​ก็​จู๋ง​ลูก​ลา​มา​หื้อ​พระเยซู เอา​เสื้อผ้า​ของ​หมู่​เขา​ปู๋​บน​หลัง​ลา แล้ว​จ้วย​ตุ้ม​พระองค์​ขึ้น​ขี่ ");
INSERT INTO nod_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ต๋อน​ตี้​พระองค์​ขี่​ลา​ไป คน​ตังหลาย​ก็​ปา​กั๋น​เอา​เสื้อผ้า​ของ​หมู่​เขา​ปู๋​ต๋ำ​หนตาง ");
INSERT INTO nod_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","เมื่อ​พระองค์​มา​เถิง​ใก้​ตี้​จะ​ลง​จาก​ดอย​บ่ากอกเทศ​แล้ว ผู้​ติดต๋าม​กู้​คน​ก็​มี​ความ​ยินดี ย้อน​ก๋าน​อัศจ๋รรย์​ต่าง﻿ๆ ตี้​เกย​หัน​นั้น ก็​สรรเสริญ​พระเจ้า​เสียง​ดัง​ว่า ");
INSERT INTO nod_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ขอ​พระเจ้า​ปั๋น​ปอน​กษัตริย์​ผู้​ตี้​มา​ใน​นาม​องค์​พระผู้เป๋นเจ้า สรรเสริญ​พระเจ้า จง​มี​สันติสุข​ใน​สวรรค์​กับ​ขอ​หื้อ​พระเจ้า​ได้ฮับ​เกียรติ​สูงสุด” ");
INSERT INTO nod_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","มี​ฟาริสี​บาง​คน​ใน​คน​ตังหลาย​นั้น​บอก​พระเยซู​ว่า “อาจ๋ารย์​ครับ สั่ง​หมู่​สาวก​ของ​ต้าน​ห้าม​อู้​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","พระองค์​ตอบ​หมู่​เขา​ว่า “เถิง​หมู่​เขา​บ่﻿ฮ้อง บ่าหิน​หมู่​นี้​ก็​จะ​ฮ้อง​แตน​หมู่​เขา” ");
INSERT INTO nod_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","เมื่อ​พระองค์​มา​ใก้​จ๋น​หัน​กรุง​เยรูซาเล็ม​อยู่​ตังหน้า พระองค์​ก็​ไห้ ย้อน​อินดู​คน​ใน​เมือง​นั้น ");
INSERT INTO nod_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","อู้​ว่า “วัน​นี้​เฮา​ใค่​หื้อ​เจ้า​ฮู้จัก​ตาง​ตี้​จะ​ได้​สันติสุข​กับ​พระเจ้า แต่​บ่าเดี่ยว​นี้​พระองค์​ได้​ซ่อน​บ่﻿หื้อ​เจ้า​ฮู้ ");
INSERT INTO nod_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","วัน​นึ่ง​หมู่​ศัตรู๋​ของ​เจ้า​จะ​โจ๋มตี๋​เจ้า แล้ว​จะ​แป๋ง​ก่ำแปง​ล้อม ขัง​เจ้า​ไว้​กู้​ด้าน ");
INSERT INTO nod_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","หมู่​เขา​จะ​ทำลาย​เจ้า​ตึง​คน​ของ​เจ้า​จ๋น​หมด​จ๋น​เสี้ยง แม้แต่​บ่าหิน​ก็​จะ​บ่﻿หื้อ​หัน​วาง​ซ้อน​กั๋น​เลย​สัก​ก้อน ย้อน​เจ้า​บ่﻿ฮับฮู้​ว่า​พระเจ้า​ได้​มา​จ้วย​เจ้า​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","พระเยซู​เข้า​ไป​ใน​บริเวณ​พระวิหาร แล้ว​ไล่​เหิบ​หมู่​คน​ตี้​ก่ำลัง​ซื้อ​ขาย​ของ​กั๋น​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","พระองค์​อู้​กับ​คน​หมู่​นั้น​ว่า “มี​กำ​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘พระวิหาร​ของ​เฮา​จะ​ฮ้อง​ว่า​เป๋น​ตี้​สำหรับ​อธิษฐาน แต่​หมู่​เจ้า​มา​เยียะ​หื้อ​ก๋าย​เป๋น​ถ้ำ​ของ​โจ๋ร​เหีย’” ");
INSERT INTO nod_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","แล้ว​พระเยซู​สั่ง​สอน​อยู่​ใน​พระวิหาร​กู้​วัน ใน​เวลา​เดียว​กั๋น​นั้น หมู่​หัวหน้า​ปุโรหิต หมู่​ธรรมาจ๋ารย์​กับ​ผู้นำ​จาว​ยิว ก็​หา​ตาง​จะ​ฆ่า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","แต่​หมู่​เขา​ก็​ยัง​บ่﻿ฮู้​ว่า​จะ​เยียะ​จาใด​ได้ ย้อน​ว่า​คน​ตังหลาย​ตั้งใจ๋​ฟัง​กำสอน​กู้​กำ​ของ​พระองค์​อยู่ ");
INSERT INTO nod_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","วัน​นึ่ง​ต๋อน​ตี้​พระเยซู​ก่ำลัง​สอน​คน​อยู่​ใน​บริเวณ​พระวิหาร​กับ​บอก​ข่าวดี​อยู่ หมู่​หัวหน้า​ปุโรหิต หมู่​ธรรมาจ๋ารย์​กับ​หมู่​คน​เฒ่า​คน​แก่​ปา​กั๋น​มา​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","หมู่​เขา​ถาม​พระองค์​ว่า “ต้าน​มี​สิทธิ​อำนาจ​อะหยัง​เยียะ​สิ่ง​หมู่​นี้ ใผ​หื้อ​สิทธิ​อำนาจ​ต้าน” ");
INSERT INTO nod_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","พระองค์​ตอบ​หมู่​เขา​ว่า “เฮา​จะ​ถาม​หมู่​ต้าน​สัก​ข้อ​นึ่ง​ก่อน ตอบ​เฮา​มา​เน่อ​ว่า ");
INSERT INTO nod_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","สิทธิ​อำนาจ​ของ​ยอห์น​ตี้​เขา​หื้อ​บัพติศมา​นั้น มา​จาก​พระเจ้า​กาว่า​มา​จาก​คน” ");
INSERT INTO nod_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","หมู่​เขา​ก็​เปิ็กษา​กั๋น​ว่า “ถ้า​เฮา​จะ​ว่า​มา​จาก​พระเจ้า ต้าน​ก็​จะ​ย้อน​ถาม​หมู่​เฮา​แหม​ว่า ‘แล้ว​เป๋น​จาใด​บ่﻿เจื้อ​ยอห์น’ ");
INSERT INTO nod_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ถ้า​หมู่​เฮา​จะ​ว่า ‘มา​จาก​คน’ คน​ตังหลาย​ก็​จะ​เอา​บ่าหิน​ขว้าง​หมู่​เฮา ย้อน​ว่า​คน​ตังหลาย​ปา​กั๋น​เจื้อ​ว่า​ยอห์น​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","หมู่​เขา​ก็​เลย​ตอบ​พระองค์​ว่า “หมู่​เฮา​บ่﻿ฮู้​เน่อ​ว่า​มา​จาก​ไหน” ");
INSERT INTO nod_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","พระเยซู​ก็​บอก​หมู่​เขา​ว่า “ถ้า​จาอั้น เฮา​ก็​จะ​บ่﻿บอก​เหมือน​กั๋น​ว่า​เฮา​ใจ๊​สิทธิ​อำนาจ​ของ​ใผ​เยียะ​สิ่ง​หมู่​นี้” ");
INSERT INTO nod_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","พระเยซู​อู้​กำเผียบ​หื้อ​คน​ตังหลาย​ฟัง​ว่า “มี​ป้อจาย​คน​นึ่ง​เยียะ​สวน​องุ่น​หื้อ​คน​มา​เจ้า ส่วน​เจ้าของ​ก็​เตียวตาง​ไป​อยู่​ต่าง​ประเทศ​เหีย​หลาย​ปี๋ ");
INSERT INTO nod_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","เมื่อ​เถิง​หน้า​เก็บ​หน่วย​องุ่น เจ้าของ​สวน​ก็​หื้อ​ลูกจ้าง​ไป​ฮับ​ส่วน​แบ่ง​องุ่น หมู่​คน​เจ้า​ก็​ยับ​ลูกจ้าง​คน​นั้น​ไว้​แล้ว​บุบ​ตี๋ แล้ว​ไล่​ปิ๊ก​โดย​บ่﻿ได้​อะหยัง​ติด​มือ​ไป​สัก​อย่าง ");
INSERT INTO nod_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","เจ้าของ​สวน​ก็​ส่ง​ลูกจ้าง​แหม​คน​นึ่ง​ไป หมู่​คน​เจ้าสวน​ก็​เยียะ​เหมือน​เก่า ยับ​มา​บุบ​กับ​เยียะ​หื้อ​เขา​อาย แล้ว​ไล่​ปิ๊ก​โดย​บ่﻿ได้​อะหยัง​ติด​มือ​ไป​สัก​อย่าง ");
INSERT INTO nod_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","เจ้า​ของ​สวน​ส่ง​คน​ตี้​สาม​ไป​แหม หมู่​คน​เจ้า​สวน​ก็​บุบ​ตี๋​เขา​จ๋น​ได้ฮับ​บาดเจ็บ แล้ว​ไล่​ออก​ไป​นอก​สวน ");
INSERT INTO nod_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","เจ้า​ของ​สวน​กึ๊ด​ว่า ‘จะ​เยียะ​จาใด​ดี เฮา​จะ​ส่ง​ลูกบ่าว​ตี้​เฮา​ฮัก​ไป หมู่​เขา​คง​จะ​นับถือ​พ่อง’ ");
INSERT INTO nod_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","แต่​เมื่อ​หมู่​คน​เจ้า​หัน​ใส่​ลูก​บ่าว​เจ้าของ​สวน​มา ก็​อู้​กั๋น​ว่า ‘นี่​ลอ คน​ตี้​จะ​ฮับ​มรดก หมู่​เฮา​จ้วย​กั๋น​ฆ่า​มัน​เหีย​เต๊อะ แล้ว​มรดก​นั้น​จะ​ตก​เป๋น​ของ​หมู่​เฮา’ ");
INSERT INTO nod_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","หมู่​เขา​ก็​ลาก​ลูกบ่าว​เจ้าของ​สวน​นั้น​อุ้ม​โจ้ง​ออก​ไป​นอก​สวน​แล้ว​ก็​ฆ่า” พระเยซู​ถาม​ว่า “เจ้าของ​สวน​จะ​เยียะ​จาใด​กับ​คน​เจ้า​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","เขา​ก็​จะ​มา​ฆ่า​หมู่​คน​เจ้า​สวน​หมู่​นั้น​เหีย แล้ว​เอา​สวน​องุ่น​นั้น​ไป​หื้อ​คน​อื่น​เจ้า​ต่อ” คน​ตังหลาย​เมื่อ​ได้ยิน​จาอั้น​ก็​อู้​กั๋น​ว่า “บ่﻿ดี​หื้อ​เป๋น​จาอั้น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","พระเยซู​ปัก​ต๋า​ผ่อ​หมู่​เขา​แล้ว​ถาม​ว่า “แล้ว​ตี้​พระคัมภีร์​มี​เขียน​ไว้​ว่า ‘ศิลา​ตี้​สล่า​แป๋ง​เฮือน​เอา​ขว้าง​ไป​แล้ว​นั้น ป๋ากฏ​ว่า​เป๋น​ศิลามุมเอก’ นั้น​หมายความ​ว่า​จาใด ");
INSERT INTO nod_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","กู้​คน​ตี้​โก้น​เต๋ง​บ่าหิน​ก้อน​นั้น ก็​จะ​แหลว​เป๋น​บ่าหลิ่น​ติ่น​ต่อน ถ้า​ศิลา​ก้อน​นั้น​ตก​เต๋ง​ใส่​ใผ คน​นั้น​ก็​จะ​แหลว​ไป​เลย” ");
INSERT INTO nod_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","หมู่​ธรรมาจ๋ารย์​กับ​หมู่​หัวหน้า​ปุโรหิต​ฮู้​ว่า​พระเยซู​อู้​กำเผียบ​เถิง​หมู่​เขา หมู่​เขา​ก็​หา​ตาง​ตี้​จะ​ยับ​พระองค์​เหีย แต่​ก็​กั๋ว​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","หมู่​เขา​จึง​ตวย​ผ่อ​พระองค์ กับ​ส่ง​คน​ไป​สอดแนม ป๋อม​ตั๋ว​เป๋น​คน​ซื่อสัตย์ หื้อ​เข้า​ไป​อยู่​ใก้﻿ๆ พระองค์ หวัง​จะ​ยับ​ผิด​ใน​กำ​อู้​ของ​พระองค์ เปื้อ​จะ​มอบ​พระองค์​หื้อ​อยู่​ใต้​สิทธิ​อำนาจ​ของ​เจ้าเมือง​โรม ");
INSERT INTO nod_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","หมู่​สอดแนม​ถาม​พระเยซู​ว่า “อาจ๋ารย์ หมู่​เฮา​ฮู้​ว่า​อาจ๋ารย์​อู้​กับ​สอน​ก็​ถูกต้อง บ่﻿หันแก่​หน้า​ใผ​สัก​คน แต่​สอน​เรื่อง​ตาง​ของ​พระเจ้า​ต๋าม​ความ​จริง ขอ​บอก​หมู่​เฮา​น่อย​เต๊อะ​ว่า ");
INSERT INTO nod_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ตี้​จะ​เสีย​ภาษี​หื้อ​ซีซาร์ เฮา​ควร​จะ​เสีย​ดี​กาว่า​บ่﻿ควร​เสีย​ดี” ");
INSERT INTO nod_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","พระเยซู​ฮู้​อุบาย​ของ​หมู่​เขา จึง​บอก​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“เอา​เหรียญ​เดนาริอัน​มา​หื้อ​เฮา​ผ่อ​ลอ ฮูป​กับ​จื้อ​ตี้​อยู่​บน​เหรียญ​นี้​เป๋น​ของ​ใผ” หมู่​เขา​ตอบ​ว่า “เป๋น​ของ​ซีซาร์” ");
INSERT INTO nod_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","พระองค์​ก็​บอก​หมู่​เขา​ว่า “ของ​ของ​ซีซาร์​ก็​เอา​ไป​หื้อ​ซีซาร์ แต่​ของ​ของ​พระเจ้า​ก็​หื้อ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","หมู่​คน​สอดแนม เอา​ผิด​ใน​กำ​อู้​ของ​พระเยซู​ต่อหน้า​คน​ตังหลาย​บ่﻿ได้ แหม​อย่าง​นึ่ง​ก็​งืด​ใน​กำตอบ​ของ​พระองค์​ตวย​จึง​ดัก​อยู่ ");
INSERT INTO nod_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","มี​หมู่​สะดูสี​บาง​คน​มา​หา​พระเยซู คน​หมู่​นี้​ถือ​ว่า​บ่﻿มี​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","หมู่​เขา​ถาม​พระองค์​ว่า “อาจ๋ารย์ บท​บัญญัติ​ของ​โมเสส​เขียน​ไว้​ว่า ถ้า​ป้อจาย​คน​ใด​ต๋าย​ละ​เมีย แต่​ยัง​บ่﻿ตัน​มี​ลูก​เตื้อ ก็​หื้อ​น้องบ่าว​ฮับ​ปี้ใป๊​มา​เป๋น​เมีย เปื้อ​หื้อ​มี​ลูก​สืบ​เจื๊อสาย​ของ​อ้าย​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","สมมุติ​ว่า​มี​ป้อจาย​ตี้​เป๋น​ปี้น้อง​กั๋น​เจ็ด​คน อ้าย​เก๊า​มี​เมีย​แล้ว​ต๋าย​ไป​ยัง​บ่﻿มี​ลูก​เตื้อ ");
INSERT INTO nod_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","น้องบ่าว​คน​ตี้​สอง​ก็​ฮับ​เอา​ปี้ใป๊​มา​เป๋น​เมีย แล้ว​ก็​ต๋าย​ไป​ยัง​บ่﻿มี​ลูก​เตื้อ น้อง​คน​ตี้​สาม​ก็​ฮับ​เอา​ปี้ใป๊​มา​เป๋น​เมีย​แหม ");
INSERT INTO nod_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ก็​เป๋น​อย่าง​เดียว​กั๋น​จ๋น​เถิง​คน​ตี้​เจ็ด ตึง​เจ็ด​คน​ต๋าย​แต่​ยัง​บ่﻿มี​ลูก ");
INSERT INTO nod_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","แล้ว​สุดต๊าย​แม่ญิง​คน​นั้น​ก็​ต๋าย​ตวย ");
INSERT INTO nod_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ย้อน​จาอั้น​เมื่อ​เถิง​วัน​ตี้​คน​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย แม่ญิง​คน​นี้​จะ​เป๋น​เมีย​ของ​ใผ ย้อน​ว่า​นาง​เกย​เป๋น​เมีย​ของ​ป้อจาย ตึง​เจ็ด​คน​นั้น” ");
INSERT INTO nod_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","พระเยซู​ตอบ​เขา​ว่า “คน​ใน​ยุค​นี้​มี​ก๋าน​แต่งงาน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","แต่​คน​ตี้​พระเจ้า​หัน​สมควร​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​มา​อยู่​ใน​ยุค​หน้า จะ​บ่﻿มี​ก๋าน​แต่งงาน​กั๋น กาว่า​ยก​หื้อ​เป๋น​ผัว​เป๋น​เมีย​กั๋น​แหม ");
INSERT INTO nod_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","แต๊﻿ๆ แล้ว​หมู่​เขา​จะ​บ่﻿ต๋าย​แหม​ต่อไป แต่​จะ​เป๋น​เหมือน​ทูตสวรรค์ เป๋น​ลูก​ของ​พระเจ้า ย้อน​เป๋น​คน​ตี้​พระเจ้า​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ก๋าน​ตี้​คน​ต๋าย​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น โมเสส​ได้​แสดง​หื้อ​หัน​ต๋อน​ตี้​เขา​ได้​เขียน​ใน​เรื่อง​คุ่ม​ไม้​ตี้​บ่﻿ไหม้​ไฟ​ โมเสส​อู้​เถิง​พระเจ้า​ว่า พระองค์​เป๋น​พระเจ้า​ตี้​อับราฮัม อิสอัค​กับ​ยาโคบ​นับถือ ");
INSERT INTO nod_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","พระองค์​บ่﻿เป๋น​พระเจ้า​ของ​คน​ต๋าย แต่​เป๋น​พระเจ้า​ของ​คน​ตี้​มี​จีวิต ย้อน​ว่า​สำหรับ​พระเจ้า​แล้ว กู้​คน​ยัง​มี​จีวิต​อยู่ แม้​ว่า​จะ​ต๋าย​ไป​แล้ว​ก็​ต๋าม” ");
INSERT INTO nod_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","หมู่​ธรรมาจ๋ารย์​บาง​คน​บอก​พระเยซู​ว่า “อาจ๋ารย์​ครับ ต้าน​อู้​ได้​ดี​นักแก​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ตี้​หมู่​เขา​อู้​จาอั้น ย้อน​หมู่​เขา​บ่﻿ก้า​ถาม​อะหยัง​แหม​เลย ");
INSERT INTO nod_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","พระองค์​ถาม​หมู่​เขา​ว่า “เป๋น​จาใด​หมู่​ต้าน​ว่า​พระคริสต์​เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด ");
INSERT INTO nod_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ย้อน​กษัตริย์​ดาวิด​ได้​บอก​ไว้​ใน​พระธรรม​สดุดี​ว่า ‘พระเจ้า​อู้​กับ​องค์​พระผู้เป๋นเจ้า​ของ​ข้าพเจ้า​ว่า หื้อ​นั่ง​ตัง​ขวา​มือ​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","จ๋น​เต๊า​ฮอด​เฮา​จะ​เยียะ​หื้อ​ศัตรู๋​ของ​ต้าน เป๋น​ตี้​ฮอง​ตี๋น​ของ​ต้าน’ ");
INSERT INTO nod_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","กษัตริย์​ดาวิด​ยัง​ฮ้อง​พระองค์​ว่า ‘องค์​พระ​ผู้​เป๋น​เจ้า’ แล้ว​พระองค์​จะ​เป๋น​เจื๊อสาย​ของ​กษัตริย์​ดาวิด​ได้​จาใด” ");
INSERT INTO nod_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","เมื่อ​คน​ตังหลาย​ก่ำลัง​ฟัง​อยู่ พระองค์​จึง​อู้​กับ​หมู่​สาวก​ของ​พระองค์​ว่า ");
INSERT INTO nod_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“หื้อ​หละวัง​หมู่​ธรรมาจ๋ารย์​ไว้​หื้อ​ดี﻿ๆ หมู่​เขา​ซอบ​นุ่ง​เสื้อ​คุม​ยาว เตียว​ไป​เตียว​มา แล้ว​ซอบ​หื้อ​คน​ไหว้​ก๋าง​กาด​ก๋าง​ลี กับ​ซอบ​นั่ง​ตั๊ด​ตี้​สำคัญ​ใน​ธรรมศาลา​ของ​จาว​ยิว​กับ​ตี้​มี​เกียรติ​ใน​งาน​เลี้ยง ");
INSERT INTO nod_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","หมู่​เขา​ยึด​เอา​สมบัติ​ของ​หมู่​แม่​หม้าย​ไป​เป๋น​ของ​ตั๋ว​เก่า​เหีย แล้ว​ก็​ขี้แต่ง​อธิษฐาน​ยาว﻿ๆ คน​หมู่​นี้​จะ​ต้อง​ฮับ​โต้ษ​ใหญ่​หลวง” ");
INSERT INTO nod_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","เมื่อ​พระเยซู​เหงย​หน้า​ขึ้น ก็​หัน​หมู่​คน​ร่ำรวย​ตังหลาย​เอา​สตางค์ มา​จ่อม​ลง​ใน​ตู้​เก็บ​เงิน​ถวาย ");
INSERT INTO nod_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","พระองค์​หัน​แม่​หม้าย​คน​นึ่ง​เป๋น​คน​ตุ๊ก เอา​เหรียญ​ตองแดง​หน้อย﻿ๆ สอง​อัน​มา​จ่อม​ตวย​เปิ้น ");
INSERT INTO nod_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","พระองค์​ก็​อู้​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า แม่​หม้าย​ตุ๊ก​จ๋น​คน​นี้​จ่อม​สตางค์​นัก​เหลือ​คน​ตังหลาย​หมู่​นั้น​ก่อน ");
INSERT INTO nod_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ย้อน​ว่า​คน​ตังหลาย​ได้​เอา​สตางค์​ตี้​เหลือ​ใจ๊​มา​จ่อม​ถวาย แต่​แม่​หม้าย​คน​นี้​ตุ๊กยาก ยัง​ได้​เอา​สตางค์​ตี้​มี​อยู่​สำหรับ​เลี้ยง​จีวิต​ของ​ตั๋ว​มา​จ่อม​จ๋น​เสี้ยง​หมด” ");
INSERT INTO nod_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","มี​สาวก​บาง​คน​อวด​ว่า​พระวิหาร​หลัง​นี้​ได้​ตกแต่ง​ด้วย​บ่าหิน​งาม กับ​ของ​ตกแต่ง​ตี้​คน​ถวาย ");
INSERT INTO nod_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","พระเยซู​จึง​อู้​กับ​เขา​ว่า “สิ่ง​หมู่​นี้​ตี้​ต้าน​ตังหลาย​หัน วัน​นึ่ง​บ่าหิน​ตี้​ซ้อน​กั๋น​หมู่​นี้​จะ​ถูก​เต​ขว้าง​จ๋น​บ่﻿หัน​วาง​ซ้อน​กั๋น​เลย​สัก​ก้อน” ");
INSERT INTO nod_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","หมู่​สาวก​ก็​ถาม​พระองค์​ว่า “อาจ๋ารย์ สิ่ง​หมู่​นี้​จะ​เกิด​ขึ้น​เมื่อ​ใด มี​อะหยัง​เป๋น​หมายสำคัญ​หื้อ​หัน​ว่า​สิ่ง​หมู่​นี้​จะ​เกิด​ขึ้น​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","พระองค์​ก็​บอก​ว่า “หละวัง​หื้อ​ดี ห้าม​หื้อ​ใผ​จุล่าย​ต้าน​เน่อ ย้อน​ว่า​จะ​มี​หลาย​คน​มา​อ้าง​จื้อ​ของ​เฮา​ว่า ‘เฮา​เป๋น​พระคริสต์’ กับ​บอก​ว่า ‘เวลา​นั้น​ใก้​มา​แผว​แล้ว’ ห้าม​ตวย​เขา​ไป​เน่อ ");
INSERT INTO nod_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","เมื่อ​ต้าน​ได้ยิน​เรื่อง​สงคราม​กับ​ก๋าน​จลาจล ก็​บ่﻿ถ้า​ตก​อก​ตก​ใจ๋ ย้อน​เรื่อง​จาอี้​จะ​ต้อง​เกิด​ขึ้น​ก่อน แต่​ยัง​บ่﻿เถิง​วัน​เสี้ยง​สุด​ของ​โลก​ใน​ต๋อน​นี้​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","แล้ว​พระองค์​อู้​กับ​หมู่​เขา​แหม​ว่า “ประเทศ​นึ่ง​จะ​สู้ฮบ​กับ​แหม​ประเทศ​นึ่ง อาณาจักร​นึ่ง​ก็​จะ​สู้ฮบ​กับ​แหม​อาณาจักร​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ใน​ตี้​ต่าง﻿ๆ จะ​เกิด​แผ่นดิน​ไหว​ขนาด​หนัก จะ​เกิด​ก๋าน​กั้น​ข้าว​อยาก​น้ำ จะ​มี​โรคภัย​ไข้เจ็บ จะ​มี​เหตุก๋ารณ์​ตี้​น่า​กั๋ว​กับ​หมายสำคัญ​หลาย​อย่าง​เกิด​ขึ้น​บน​ต๊องฟ้า ");
INSERT INTO nod_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ก่อน​เหตุก๋ารณ์​หมู่​นี้​จะ​เกิด​ขึ้น หมู่​ต้าน​จะ​ถูก​ยับ​และ​โดน​ข่มเหง จะ​ถูก​ปา​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว แล้ว​ถูก​ขัง​ไว้​ใน​คอก กับ​จะ​ถูก​ปา​ไป​ตัดสิน​ความ​ต่อหน้า​กษัตริย์​กับ​เจ้าเมือง ย้อน​ว่า​หมู่​ต้าน​ติดต๋าม​เฮา ");
INSERT INTO nod_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","เหตุก๋ารณ์​นี้​ก็​เป๋น​โอกาส​หื้อ​หมู่​ต้าน​เป๋น​พยาน​เรื่อง​เฮา ");
INSERT INTO nod_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ย้อน​จาอั้น​ต้าน​ตังหลาย​จง​ป๋งใจ๋​ไว้ บ่﻿ต้อง​กึ๊ด​ล่วงหน้า​ว่า​จะ​แก้​คดี​จาใด ");
INSERT INTO nod_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","เฮา​จะ​หื้อ​กำ​อู้​กับ​ผญา​ปั๋ญญา​แก่​หมู่​ต้าน เถิง​ขนาด​หมู่​ศัตรู๋​ของ​หมู่​ต้าน​จะ​ต่อต้าน​กับ​เอา​ผิด​หมู่​ต้าน​บ่﻿ได้​เลย ");
INSERT INTO nod_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","แม้แต่​ป้อแม่​ญาติ​ปี้น้อง ตึง​เปื้อน​ฝูง​จะ​หักหลัง​หมู่​ต้าน หมู่​เขา​จะ​เยียะ​หื้อ​ต้าน​บาง​คน​ถูก​ฆ่า​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","คน​ตังหลาย​จะ​จัง​หมู่​ต้าน​ย้อน​ว่า​หมู่​ต้าน​ได้​ติดต๋าม​เฮา ");
INSERT INTO nod_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","แต่​ผม​บน​หัว​ของ​หมู่​ต้าน​สัก​เส้น​นึ่ง​จะ​บ่﻿ถูก​เยียะ​หื้อ​เสีย​ไป ");
INSERT INTO nod_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","หมู่​ต้าน​จะ​ได้​จีวิต​นิรันดร์​ถ้า​ตั้ง​มั่นคง​อยู่​ใน​ความ​เจื้อ” ");
INSERT INTO nod_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“เมื่อ​หมู่​ต้าน​หัน​ก๋องทัพ​ทหาร​มา​ตั้ง​ล้อม​กรุง​เยรูซาเล็ม จง​ฮู้​ไว้​เต๊อะ​ว่า​ความ​ฉิบหาย​ของ​เมือง​นั้น​ก็​ใก้​เข้า​มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ใน​เวลา​นั้น​ก็​หื้อ​คน​ตี้​อยู่​ใน​แคว้น​ยูเดีย​ขะใจ๋​หนี​ไป​อยู่​บน​ดอย​เวย﻿ๆ หมู่​คน​ตี้​อยู่​ใน​กรุง​ก็​หื้อ​ออก​ไป​เหีย คน​ตี้​อยู่​นอก​เมือง​ก็​บ่﻿ถ้า​เข้า​ไป​ใน​กรุง​เน่อ ");
INSERT INTO nod_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ย้อน​ว่า​เวลา​นั้น​เป๋น​เวลา​ลง​โต้ษ เปื้อ​กู้​อย่าง​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​นั้น​เป๋น​แต๊ ");
INSERT INTO nod_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ใน​หว่าง​นั้น​ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​หมู่​แม่มาน​กับ​แม่​ลูก​หน้อย​ตี้​ลูก​ยัง​กิ๋น​นม​อยู่ ย้อน​มี​ความ​ตุ๊ก​ฮ้อน​อัน​ใหญ่​หลวง​จะ​เกิด​ขึ้น​บน​แผ่นดิน กับ​พระเจ้า​จะ​โขด​หื้อ​คน​เจื๊อจ้าด​นี้​ขนาด ");
INSERT INTO nod_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","หมู่​เขา​จะ​ถูก​ฆ่า​ด้วย​ดาบ กับ​จะ​ถูก​ต้อน​ไป​เป๋น​เชลย​ใน​ประเทศ​ต่าง﻿ๆ กับ​กรุง​เยรูซาเล็ม​จะ​ถูก​คน​ต่างจ้าด​ย่ำ​จ๋น​กว่า​จะ​หมด​ก๋ำหนด​เวลา​ของ​คน​ต่างจ้าด​นั้น ");
INSERT INTO nod_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“จะ​มี​หมายสำคัญ​ตี้​ตะวัน เดือน​กับ​ดาว​ตังหลาย กับ​ใน​แผ่นดิน​โลก​นั้น ประเทศ​ต่าง﻿ๆ จะ​มี​ความ​ตุ๊ก​เดือดฮ้อน กับ​มี​ความ​สับสน​ใน​ความ​ปั่นป่วน​กับ​เสียง​ดัง​ของ​ทะเล​กับ​คลื่น ");
INSERT INTO nod_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","คน​จะ​กั๋ว​จ๋น​เป๋น​ลม​เมื่อ​ก่ำลัง​รอ​ผ่อ​ว่า​อะหยัง​จะ​เกิด​ขึ้น​บน​โลก ย้อน​ว่า​หมู่​ผู้​มี​อำนาจ​ตังหลาย​ใน​ต๊องฟ้า​ก็​จะ​สั่นไหว​เฝื่อน​คลอน ");
INSERT INTO nod_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","เวลา​นั้น​คน​ตังหลาย​จะ​หัน​บุตรมนุษย์​ลง​มา​บน​เมฆ​ด้วย​ฤทธิ์​อำนาจ​กับ​รัศมี​อัน​ยิ่งใหญ่ ");
INSERT INTO nod_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","เมื่อ​เหตุก๋ารณ์​นี้​ตั้งเก๊า​จะ​เกิด​ขึ้น หื้อ​ยืน​ขึ้น​ผ่อ​ไป​ตัง​บน ย้อน​ว่า​ความ​รอด​ป๊น​บาป​โต้ษ​ของ​หมู่​ต้าน​ก่ำลัง​ใก้​เข้า​มา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","พระเยซู​อู้​กำเผียบ​หื้อ​หมู่​เขา​ฟัง​ว่า “ผ่อ​เก๊า​บ่าเดื่อ​กับ​เก๊าไม้​ตังหลาย​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","เมื่อ​มัน​โป่ง​ใบ​แล้ว​ต้าน​ตังหลาย​ก็​จะ​ฮู้​คน​เดียว​ว่า ใก้​จะ​เถิง​หน้า​ฮ้อน​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ก็​เหมือน​เดียว​กั๋น เมื่อ​ต้าน​ตังหลาย​หัน​เหตุก๋ารณ์​ตี้​เฮา​บอก​แล้ว​นั้น​เกิด​ขึ้น ก็​หื้อ​ฮู้​ว่า​แผ่นดิน​ของ​พระเจ้า​มา​ใก้​จะ​เถิง​แล้ว​เน่อ ");
INSERT INTO nod_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ใน​ยุค​นี้​จะ​ยัง​บ่﻿ต๋าย​ก่อน​เหตุก๋ารณ์​ตี้​ว่า​หมู่​นี้​จะ​เกิด​ขึ้น ");
INSERT INTO nod_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ต๊องฟ้า​กับ​โลก​จะ​ยุบ​หาย​ไป แต่​ถ้อยกำ​ของ​เฮา​จะ​บ่﻿สูญหาย​ไป​เลย ");
INSERT INTO nod_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“จง​หละวัง​ตั๋ว​ไว้​หื้อ​ดี​เน่อ บ่﻿ดี​เอา​ก้า​กิ๋น​เหล้า​เมา​ยา กาว่า บ่﻿ดี​กั๋งวล​เถิง​จีวิต​นี้​เต้าอั้น ถ้า​เป๋น​จาอั้น​เวลา​นั้น​ก็​จะ​มา​เถิง​หมู่​ต้าน​เมื่อ​ยัง​บ่﻿ตัน​กึ๊ด เหมือน​ติด​แฮ้ว ");
INSERT INTO nod_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ย้อน​วัน​นั้น​จะ​เกิด​ขึ้น​กับ​คน​ตังหลาย​ใน​โลก ");
INSERT INTO nod_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","หื้อ​เฝ้า​หละวัง​อยู่​ตลอด​กับ​อธิษฐาน​ตึง​วัน เปื้อ​หมู่​ต้าน​จะ​มี​ก๋ำลัง​ตี้​จะ​ป๊น​จาก​เหตุก๋ารณ์​ตังมวล​ตี้​จะ​เกิด​ขึ้น แล้ว​จะ​ยืน​อยู่​ต่อหน้า​บุตรมนุษย์​ได้” ");
INSERT INTO nod_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","กู้​วัน​พระเยซู​สั่ง​สอน​ใน​บริเวณ​พระวิหาร​ต๋อน​เมื่อวัน แล้ว​ต๋อน​เมื่อคืน​พระองค์​ย้าง​พัก​ตี้​ดอย​บ่ากอกเทศ ");
INSERT INTO nod_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","คน​ตังหลาย​ก็​มา​หา​พระองค์​ใน​บริเวณ​พระวิหาร​ตั้งแต่​เจ๊ามืด​เปื้อ​จะ​ฟัง​พระองค์​สั่ง​สอน ");
INSERT INTO nod_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","เมื่อ​ใก้​จะ​เถิง​งาน​ปัสกา คือ​งาน​กิ๋น​เข้าหนมปัง​บ่﻿ใส่​เจื๊อ ");
INSERT INTO nod_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์ ปา​กั๋น​หา​ตาง​ก๋ำจัด​พระเยซู​อย่าง​ลับ﻿ๆ อยู่ ย้อน​กั๋ว​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ซาต๋าน​ครอบงำ​จิตใจ๋​ยูดาส อิสคาริโอท ตี้​เป๋น​สาวก​คน​นึ่ง​ใน​สิบ​สอง​คน ");
INSERT INTO nod_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ยูดาส​ก็​ไป​นัด​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​นาย​ทหาร​ฮักษา​พระวิหาร​ว่า เขา​จะ​หักหลัง​พระเยซู​จาใด​ดี ");
INSERT INTO nod_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","คน​หมู่​นั้น​ก็​ดีอกดีใจ๋ แล้ว​สัญญา​ว่า​จะ​หื้อ​สตางค์​เป๋น​ก้า​ตอบแตน ");
INSERT INTO nod_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ยูดาส​ก็​ตกลง แล้ว​ก็​แน​หา​โอกาส​ตี้​จะ​หักหลัง​พระเยซู​หื้อ​หมู่​เขา​โดย​บ่﻿หื้อ​ใผ​ฮู้ ");
INSERT INTO nod_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","เมื่อ​เถิง​วัน​กิ๋น​เข้าหนมปัง​บ่﻿ใส่​เจื๊อ จาว​ยิว​ต้อง​ฆ่า​ลูก​แกะ​สำหรับ​งาน​ปัสกา ");
INSERT INTO nod_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","พระเยซู​ก็​ใจ๊​เปโตร​กับ​ยอห์น​ล่วงหน้า​ไป​ก่อน สั่ง​เขา​ว่า “ไป​จัด​เกียม​มื้อ​ปัสกา​ไว้​หื้อ​หมู่​เฮา​กิ๋น​ตวย​กั๋น” ");
INSERT INTO nod_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","หมู่​เขา​ถาม​พระองค์​ว่า “จะ​หื้อ​หมู่​เฮา​ไป​เกียม​มื้อ​ปัสกา​ตี้​ไหน​ดี” ");
INSERT INTO nod_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","พระองค์​ก็​บอก​ว่า “เมื่อ​หมู่​ต้าน​เข้า​ไป​ใน​กรุง​เยรูซาเล็ม แล้ว​จะ​มี​ป้อจาย​คน​นึ่ง​แบก​น้ำหม้อ​มา​หา​หมู่​ต้าน เขา​จะ​เข้า​ไป​เฮือน​หลัง​ใด​ก็​หื้อ​ตวย​เขา​เข้า​ไป ");
INSERT INTO nod_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","แล้ว​บอก​เจ้าของ​เฮือน​นั้น​ว่า ‘อาจ๋ารย์​หื้อ​มา​ถาม​ว่า ห้อง​ตี้​เปิ้น​จะ​กิ๋น​มื้อ​ปัสกา​กับ​หมู่​สาวก​นั้น​อยู่​ตัง​ใด’ ");
INSERT INTO nod_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","เจ้าของ​เฮือน​จะ​ปา​หมู่​ต้าน​ขึ้น​ไป​ห้อง​ใหญ่​จั๊น​บน​ตี้​แต่ง​ดา​ไว้​แล้ว ก็​หื้อ​จัด​เกียม​มื้อ​ปัสกา​ไว้​ตี้​ห้อง​นั้น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ตึง​สอง​คน​ก็​ไป แล้ว​ก็​ปะ​กู้​อย่าง​ตี้​พระองค์​บอก​ไว้​ตึงหมด หมู่​เขา​ก็​ได้​จัด​เกียม​มื้อ​ปัสกา​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","เมื่อ​เถิง​เวลา​กิ๋น​มื้อ​ปัสกา พระเยซู​ก็​เข้า​ไป​นั่ง​ตี้​โต๊ะ​กับ​หมู่​อัคร​สาวก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","อู้​กับ​หมู่​เขา​ว่า “เฮา​มี​ความ​ตั้งใจ๋​ตี้​จะ​กิ๋น​มื้อ​ปัสกา​นี้​กับ​หมู่​ต้าน ก่อน​ตี้​เฮา​จะ​ต้อง​ทน​ตุ๊ก​ทรมาน ");
INSERT INTO nod_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","เฮา​ขอ​บอก​ไว้​ว่า​เฮา​จะ​บ่﻿กิ๋น​มื้อ​ปัสกา​นี้​แหม จ๋น​ความหมาย​ของ​ปัสกา​นั้น​จะ​สมบูรณ์​ใน​แผ่นดิน​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","พระองค์​ยก​จอก​น้ำองุ่น​ขึ้น​มา เมื่อ​อธิษฐาน​ขอบพระคุณ​พระเจ้า​แล้ว ก็​ส่ง​หื้อ​หมู่​สาวก บอก​ว่า “เอา​ไป​แบ่ง​กั๋น​กิ๋น​เน่อ ");
INSERT INTO nod_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","เฮา​บอก​หมู่​ต้าน​ว่า ตั้งแต่​นี้​ไป​เฮา​จะ​บ่﻿กิ๋น​เหล้า​องุ่น​แหม​แล้ว จ๋น​กว่า​แผ่นดิน​ของ​พระเจ้า จะ​มา​แผว” ");
INSERT INTO nod_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","แล้ว​พระองค์​ก็​หยิบ​เข้าหนมปัง​ขึ้น​มา ขอบพระคุณ​พระเจ้า​แล้ว​ก็​บิ​ยื่น​หื้อ​หมู่​สาวก อู้​ว่า “นี่​เป๋น​ก๋าย​ของ​เฮา ตี้​ได้​หื้อ​ไว้​กับ​ต้าน​ตังหลาย หื้อ​เยียะ​จาอี้ เปื้อ​กึ๊ด​เถิง​เฮา” ");
INSERT INTO nod_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","เมื่อ​กิ๋น​เข้าหนมปัง​แล้ว​พระองค์​ก็​ก๋ำ​ถ้วย​ขึ้น​มา​เยียะ​อย่าง​เดียว​กั๋น แล้ว​อู้​ว่า “ถ้วย​นี้​เป๋น​พันธสัญญา​ใหม่​หละหว่าง​พระเจ้า​กับ​ต้าน​ตังหลาย​ตี้​พระองค์​จะ​ยืนยัน​โดย​เลือด​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","แต่​ผ่อ​เต๊อะ​คน​ตี้​จะ​หักหลัง​เฮา ก็​อยู่​ตวย​กั๋น​กับ​เฮา​บน​โต๊ะ​นี้ ");
INSERT INTO nod_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","บุตรมนุษย์​จะ​ต้อง​จาก​ไป​ต๋าม​ตี้​พระเจ้า​ได้​ก๋ำหนด​ไว้​แล้ว แต่​ความ​ฉิบหาย​ก็​จะ​เกิด​กับ​คน​ตี้​หักหลัง​บุตรมนุษย์” ");
INSERT INTO nod_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","แล้ว​หมู่​สาวก​ก็​ถาม​กั๋น​ไป​มา​ว่า จะ​เป๋น​ใผ​ใน​หมู่​เขา​ตี้​จะ​เยียะ​จาอี้ ");
INSERT INTO nod_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","หมู่​สาวก​เถียง​กั๋น​ว่า ใผ​จะ​เป๋น​ใหญ่​ตี้​สุด​ใน​แผ่นดิน​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","พระองค์​จึง​อู้​กับ​หมู่​เขา​ว่า “กษัตริย์​ของ​คน​ต่างจ้าด​เป๋น​เจ้านาย​ปกครอง​คน​ตังหลาย​โดย​ก๋าน​บังคับ กับ​ผู้​มี​อำนาจ​หมู่​นี้​ก็​ฮ้อง​ตั๋ว​เก่า​ว่า​เป๋น​ผู้​มี​บุญคุณ​ของ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","แต่​สำหรับ​หมู่​ต้าน​นั้น​บ่﻿เป๋น​จาอั้น​เน่อ คน​ใด​เป๋น​ใหญ่​ก็​หื้อ​คน​นั้น​เป๋น​คน​เล็ก​หน้อย​ตี้​สุด คน​ใด​เป๋น​นาย​ก็​หื้อ​เป๋น​คน​ฮับใจ๊ ");
INSERT INTO nod_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","จะ​ถาม​ว่า​คน​ตี้​นั่ง​โต๊ะ​กับ​คน​ตี้​ฮับใจ๊ ใผ​เป๋น​ใหญ่​เหลือ​กั๋น คน​ตี้​นั่ง​โต๊ะ​บ่﻿ใจ้​กา แต่​เฮา​อยู่​ตวย​ต้าน​ตังหลาย เหมือน​เป๋น​คน​ฮับใจ๊ ");
INSERT INTO nod_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ต้าน​ตังหลาย​เป๋น​คน​ตี้​ได้​อยู่​กับ​เฮา ใน​เวลา​ตี้​เฮา​ต่อ​สู้​กับ​ความ​ลำบาก ");
INSERT INTO nod_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","พระบิดา​ได้​จัด​เกียม​แผ่นดิน​แล้ว​มอบ​หื้อ​เฮา​จาใด เฮา​ก็​จัด​เกียม​แล้ว​มอบ​หื้อ​ต้าน​ตังหลาย​จาอั้น ");
INSERT INTO nod_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","เปื้อ​หมู่​ต้าน​จะ​ได้​กิ๋น​ได้​ดื่ม​ฮ่วม​โต๊ะ​กับ​เฮา​ใน​แผ่นดิน​ของ​เฮา กับ​ต้าน​ตังหลาย​จะ​ได้​นั่ง​บน​บัลลังก์ เปื้อ​ตัดสิน​สิบ​สอง​ผะกุ๋น​ของ​คน​อิสราเอล ");
INSERT INTO nod_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ซีโมน​เหย ซาต๋าน​ได้​ขอ​หมู่​ต้าน​ไว้ เปื้อ​จะ​เอา​ไป​ฝัด​ไป​ฮ่อน​เหมือน​เปิ้น​ฝัด​ข้าว ");
INSERT INTO nod_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","แต่​เฮา​ได้​อธิษฐาน​เผื่อ​ตั๋ว​ต้าน เปื้อ​ต้าน​จะ​บ่﻿ได้​ขาด​ความ​เจื้อ แล้ว​เมื่อ​ต้าน​กลับใจ๋​มา​หา​เฮา ก็​หื้อ​จ้วย​หมู่​ปี้น้อง​หื้อ​มี​ความ​เจื้อ​เข้มแข็ง​นัก​ขึ้น​ตวย​เน่อ” ");
INSERT INTO nod_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","เปโตร​บอก​พระองค์​ว่า “พระองค์​เจ้า​ข้า ข้าพเจ้า​พร้อม​แล้ว​ตี้​จะ​ไป​ตวย​ต้าน บ่﻿ว่า​จะ​ติด​คอก กาว่า​จะ​ต๋าย​ก็​ได้” ");
INSERT INTO nod_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","พระเยซู​บอก​เปโตร​ว่า “คืน​นี้​ก่อน​ไก่​ขัน ต้าน​จะ​บอก​บ่﻿ฮู้จัก​เฮา​เถิง​สาม​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","พระเยซู​ถาม​หมู่​สาวก​ว่า “ต๋อน​ตี้​เฮา​ใจ๊​ต้าน​ตังหลาย​ออก​ไป​บอก​ข่าวดี แล้ว​บ่﻿หื้อ​เอา​ถง​สตางค์ ถง​สะปาย กาว่า​เกิบ​แหม​กู้​ไป​ตวย​นั้น ต้าน​ตังหลาย​ขาด​อะหยัง​พ่อง” เขา​ตังหลาย​ก็​ปา​กั๋น​บอก​ว่า “บ่﻿ขาด​อะหยัง​สัก​อย่าง” ");
INSERT INTO nod_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","พระเยซู​บอก​เขา​ว่า “แต่​บ่าเดี่ยว​นี้​ใผ​มี​ถง​สตางค์ กาว่า​ถง​สะปาย ก็​หื้อ​เอา​ไป​ตวย ใผ​บ่﻿มี​ดาบ​ก็​หื้อ​ขาย​เสื้อ​คุม​ซื้อ​ดาบ​เหีย ");
INSERT INTO nod_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","เฮา​บอก​ต้าน​ตังหลาย​ว่า กำ​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​ตี้​อู้​เถิง​เฮา จะ​ต้อง​เป๋น​ไป​ต๋าม​นั้น คือ​กำ​ตี้​ว่า ‘พระองค์​ถูก​นับ​อยู่​ใน​หมู่​เดียว​กั๋น​กับ​คน​บ่﻿ดี’ กำ​ตวายตั๊ก​ตี้​เล็ง​เถิง​เฮา​นั้น​ก่ำลัง​จะ​เป๋น​แต๊” ");
INSERT INTO nod_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","หมู่​เขา​บอก​พระองค์​ว่า “องค์​พระผู้เป๋นเจ้า หมู่​เฮา​มี​ดาบ​สอง​เถี่ยน​ครับ” พระองค์​บอก​ว่า “ปอ​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","พระเยซู​ออก​จาก​กรุง​เยรูซาเล็ม ไป​ตี้​ดอย​บ่ากอกเทศ​เหมือน​ตะก่อน หมู่​สาวก​ก็​ไป​ตวย​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ตี้​ดอย​นั้น​พระองค์​บอก​หมู่​สาวก​ว่า “หื้อ​อธิษฐาน​เน่อ​เปื้อ​ว่า​ต้าน​จะ​บ่﻿ตก​อยู่​ใน​อำนาจ​ของ​ก๋าน​ลองใจ๋” ");
INSERT INTO nod_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","พระองค์​เตียว​ไป​แหม​น่อย ไก๋​ประมาณ​เอา​บ่าหิน​ขว้าง แล้ว​คุก​เข่า​ลง​อธิษฐาน​ว่า ");
INSERT INTO nod_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“พระบิดา​เจ้าข้า ถ้า​พระองค์​ปอใจ๋ ขอ​หื้อ​ถ้วย​แห่ง​ความ​ตุ๊กยาก​นี้​ป๊น​ไป​จาก​ข้า​พระองค์​เหีย​เต๊อะ แต่​ขอ​หื้อ​เป๋น​ไป​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์​บ่﻿ใจ้​ของ​ข้า​พระองค์” ");
INSERT INTO nod_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","มี​ทูตสวรรค์​องค์​นึ่ง​จาก​สวรรค์​มา​ป๋ากฏ​จ้วย​พระองค์​หื้อ​มี​ก๋ำลังใจ๋​นัก​ขึ้น ");
INSERT INTO nod_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","เมื่อ​พระองค์​เป๋น​ตุ๊ก​หนัก ก็​ยิ่ง​ตั้งใจ๋​อธิษฐาน​นัก​ขึ้น จ๋น​เหื่อ​ไหล​เป๋น​เหมือน​เลือด​ออก หยด​ลง​ดิน​เป๋น​เม็ด​ใหญ่ ");
INSERT INTO nod_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","เมื่อ​อธิษฐาน​แล้ว​พระองค์​ก็​ลุก​เตียว​ปิ๊ก​มา​หา​หมู่​สาวก ก็​หัน​หมู่​เขา​หลับ​อยู่​ย้อน​ตุ๊กใจ๋​จ๋น​อิด ");
INSERT INTO nod_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","พระองค์​จึง​อู้​ว่า “หลับ​เยียะ​หยัง ลุก​ขึ้น​อธิษฐาน​เปื้อ​จะ​บ่﻿ตก​อยู่​ใน​อำนาจ​ของ​ก๋าน​ลองใจ๋” ");
INSERT INTO nod_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","บ่ากอง​พระองค์​อู้​ลิ้น​ยัง​บ่﻿ตัน​เข้า​ปาก​เตื้อ ก็​มี​หลาย​คน​เตียว​เข้า​มา มี​ยูดาส​ตี้​เป๋น​สาวก​คน​นึ่ง​ใน​สิบ​สอง​คน​นั้น​นำ​หน้า ยูดาส​ก็​เข้า​มา​ใก้​พระเยซู​แล้ว​ตั๊กตวาย​พระองค์​โดย​ก๋าน​จูบ ");
INSERT INTO nod_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","พระองค์​ก็​ถาม​ว่า “ยูดาส เจ้า​จะ​หักหลัง​บุตรมนุษย์​ด้วย​ก๋าน​จูบ​กา” ");
INSERT INTO nod_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","เมื่อ​หมู่​สาวก​คน​อื่น﻿ๆ หัน​ว่า​จะ​มี​อะหยัง​เกิด​ขึ้น​ต่อไป จึง​ถาม​พระเยซู​ว่า “องค์​พระผู้เป๋นเจ้า เอา​ดาบ​ฟัน​เลย​บ๋อ” ");
INSERT INTO nod_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","แล้ว​คน​นึ่ง​ใน​หมู่​สาวก​ก็​จั๊ก​ดาบ​ออก​มา​ฟัน​คน​ฮับใจ๊​ของ​มหา​ปุโรหิต ถูก​หู​เผิก​ขวา​ปุด ");
INSERT INTO nod_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","พระเยซู​ก็​ห้าม​เขา​ไว้ แล้ว​เก็บ​เอา​ใบ​หู​มา​ต่อ​หื้อ​คน​นั้น หู​เขา​ก็​หาย​เป๋น​ปกติ ");
INSERT INTO nod_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","พระเยซู​อู้​กับ​หมู่​หัวหน้า​ปุโรหิต หมู่​นาย​ทหาร​ฮักษา​พระวิหาร กับ​หมู่​คน​เฒ่า​คน​แก่ ตี้​มา​ยับ​พระองค์​ว่า “หมู่​เจ้า​หัน​เฮา​เป๋น​โจ๋ร​กา เถิง​ได้​ก๋ำ​ดาบ​ก๋ำ​ค้อน​มา​ยับ​เฮา ");
INSERT INTO nod_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","เฮา​อยู่​ตวย​ต้าน​ตังหลาย​กู้​วัน​ใน​พระวิหาร ต้าน​ตังหลาย​ก็​บ่﻿มา​ยับ​เฮา แต่​บ่าเดี่ยว​นี้​เป๋น​เวลา​ของ​หมู่​ต้าน​แล้ว​เน่อ เป๋น​เวลา​ของ​อำนาจ​แห่ง​ความ​มืด” ");
INSERT INTO nod_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","หมู่​นาย​ทหาร​ยับ​พระเยซู​ปา​ไป​บ้าน​มหา​ปุโรหิต เปโตร​เตียว​ถ่อม​ตวย​พระองค์​ไป​ห่าง﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","เมื่อ​หมู่​เขา​ดัง​ไฟ​ตี้​ก๋าง​ข่วง​แล้ว​ปา​กั๋น​หิง​ไฟ เปโตร​ก็​นั่ง​หิง​ไฟ​ตวย​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","มี​สาวใจ๊​คน​นึ่ง​หัน​เปโตร​นั่ง​หิง​ไฟ​อยู่​ใก้﻿ๆ ก็​ส่อง​ผ่อ​หน้า​เปโตร​แล้ว​อู้​ว่า “คน​นี้​ก็​อยู่​ตวย​เยซู” ");
INSERT INTO nod_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","เปโตร​ปฏิเสธ​ว่า “นาง​เหย คน​นั้น​ข้า​บ่﻿ฮู้จัก​ลอ” ");
INSERT INTO nod_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","แหม​สัก​กำเดียว​ป้อจาย​คน​นึ่ง​หัน​เขา​ก็​อู้​ว่า “เจ้า​เป๋น​คน​นึ่ง​ใน​หมู่​นั้น​ตวย” เปโตร​ก็​บอก​ว่า “อ้าย​เหย บ่﻿ใจ้​ลอ” ");
INSERT INTO nod_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","แหม​สัก​จั้วโมง​นึ่ง มี​แหม​คน​ยืนยัน​แข็งขัน​ว่า “แม่น​แล้ว คน​นี้​อยู่​ตวย​คน​จื้อ​เยซู​แน่﻿ๆ ย้อน​เขา​เป๋น​จาว​กาลิลี​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","เปโตร​ก็​อู้​ว่า “อ้าย​เหย ตี้​ว่า​มา​นั้น​ข้า​บ่﻿ฮู้​เรื่อง” เมื่อ​เปโตร​ก่ำลัง​อู้​ลิ้น​ยัง​บ่﻿ตัน​เข้า​ปาก ไก่​ก็​ขัน ");
INSERT INTO nod_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","องค์​พระผู้เป๋นเจ้า​เหลียว​หลัง​มา​ผ่อ​เปโตร แล้ว​เปโตร​ก็​เลย​กึ๊ด​เถิง​กำ​อู้​ตี้​พระเยซู​เกย​บอก​เขา​ว่า “คืน​นี้​ก่อน​ไก่​ขัน ต้าน​จะ​บอก​ว่า​บ่﻿ฮู้จัก​เฮา​สาม​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","เปโตร​ก็​ออก​ไป​ตัง​นอก​แล้ว​ไห้​เสียใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","คน​ตี้​กุม​พระเยซู​ก็​เยาะเย้ย​บุบ​ตี๋​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","เอา​ผ้า​มัด​ต๋า​พระองค์ ตบ​หน้า​พระองค์ แล้ว​ถาม​ว่า “ตวาย​มา​กำ​ลอ​ว่า​ใผ​ตบ​หน้า​เจ้า” ");
INSERT INTO nod_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","แล้ว​อู้​หยาม​ใส่​พระองค์​แหม​หลาย​อย่าง ");
INSERT INTO nod_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","แจ้ง​เจ๊า​มา​หมู่​คน​เฒ่า​คน​แก่ หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์​ก็​ประชุม​กั๋น หมู่​เขา​ปา​พระเยซู เข้า​มา​ใน​สภา​ของ​หมู่​เขา​ตวย ");
INSERT INTO nod_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ถาม​พระเยซู​ว่า “ต้าน​เป๋น​พระคริสต์​กา บอก​มา​เต๊อะ” พระเยซู​ตอบ​ว่า “เถิง​เฮา​บอก หมู่​ต้าน​ก็​บ่﻿เจื้อ ");
INSERT INTO nod_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ถ้า​เฮา​ถาม​ต้าน﻿ๆ ก็​จะ​บ่﻿ตอบ​เฮา ");
INSERT INTO nod_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ตั้งแต่​นี้​ไป​บุตรมนุษย์​จะ​ได้​นั่ง​ตัง​เผิก​ขวา​ของ​พระเจ้า​ผู้​มี​ฤทธิ์​อำนาจ” ");
INSERT INTO nod_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","หมู่​เขา​ก็​ถาม​พระองค์​แหม​ว่า “ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า​กา” พระองค์​ก็​ตอบ​ว่า “หมู่​ต้าน​อู้​แล้ว​ว่า​เฮา​เป๋น” ");
INSERT INTO nod_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","หมู่​เขา​ก็​ปา​กั๋น​ว่า “หมู่​เฮา​บ่﻿ต้อง​มี​พยาน​อะหยัง​แหม ย้อน​ได้ยิน​กำ​จาก​ปาก​ของ​เขา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","แล้ว​กู้​คน​ใน​ตี้​ประชุม​ก็​ลุก​ขึ้น​ปา​พระเยซู​ไป​หา​ปีลาต​ตี้​เป๋น​เจ้าเมือง ");
INSERT INTO nod_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","หมู่​เขา​ฟ้อง​ว่า “หมู่​เฮา​หัน​ป้อจาย​คน​นี้​สุ่ย​คน​ตังหลาย​บ่﻿เสีย​ภาษี​หื้อ​ซีซาร์ แล้ว​ก็​อ้าง​ว่า​ตั๋ว​เขา​คือ​พระคริสต์​เป๋น​กษัตริย์​องค์​นึ่ง” ");
INSERT INTO nod_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ปีลาต​ซัก​ถาม​พระเยซู​ว่า “ต้าน​เป๋น​กษัตริย์​ของ​จาว​ยิว​กา” พระองค์​ก็​ตอบ​ว่า “ต้าน​อู้​แล้ว” ");
INSERT INTO nod_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ปีลาต​จึง​บอก​หมู่​หัวหน้า​ปุโรหิต​กับ​คน​ตังหลาย​ว่า “เฮา​บ่﻿มี​หลักฐาน​อะหยัง​ตี้​จะ​ลง​โต้ษ​ป้อจาย​คน​นี้” ");
INSERT INTO nod_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","หมู่​เขา​ซ้ำ​ยืนยัน​อย่าง​แข็งขัน​ว่า “คน​นี้​สุ่ย​จาว​เมือง​หื้อ​วุ่นวาย​โดย​กำสอน​ของ​เขา​ไป​ใคว่​แคว้น​ยูเดีย ตั้งเก๊า​ตี้​แคว้น​กาลิลี​ก่อน​แล้ว​จ๋น​มา​เถิง​ตี้​นี่” ");
INSERT INTO nod_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","เมื่อ​ปีลาต​ได้ยิน​จาอั้น​ก็​ถาม​ว่า “ป้อจาย​คน​นี้​เป๋น​จาว​กาลิลี​กา” ");
INSERT INTO nod_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","เมื่อ​ฮู้​ว่า​พระเยซู​มา​จาก​ดินแดน​ตี้​กษัตริย์​เฮโรด​ปกครอง​อยู่ ก็​ส่ง​พระองค์​ไป​หา​เฮโรด ต๋อน​นั้น​ต้าน​อยู่​ใน​กรุง​เยรูซาเล็ม​ปอดี ");
INSERT INTO nod_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","เมื่อ​เฮโรด​หัน​พระเยซู​ก็​ดีใจ๋ ย้อน​ต้าน​ใค่​ปะ​พระเยซู​มา​เมิน​แล้ว ต้าน​เกย​ได้ยิน​เรื่อง​พระเยซู ก็​หวัง​ว่า​จะ​ได้​หัน​พระองค์​เยียะ​ก๋าน​อัศจ๋รรย์​พ่อง ");
INSERT INTO nod_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","เฮโรด​จึง​ถาม​พระเยซู​หลาย​อย่าง แต่​พระองค์​บ่﻿ตอบ​อะหยัง​สัก​อย่าง ");
INSERT INTO nod_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ธรรมาจ๋ารย์​ก็​ใส่​ความ​พระเยซู​อย่าง​รุนแรง ");
INSERT INTO nod_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","เฮโรด​กับ​หมู่​ทหาร​ของ​เขา​ปา​กั๋น​ใค่​หัว​ใส่​พระองค์ เยาะเย้ย​ดู​ถูก​ดู​แควน​พระองค์ เอา​เสื้อ​คุม​อย่าง​ดี​ของ​กษัตริย์​หื้อ​พระองค์​นุ่ง แล้ว​ส่ง​พระองค์​ปิ๊ก​ไป​หื้อ​ปีลาต​แหม ");
INSERT INTO nod_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ปีลาต​กับ​เฮโรด​ก็​คืน​ดี​กั๋น​ใน​วัน​นั้น ย้อน​ว่า​ตะก่อน​เป๋น​ศัตรู๋​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ปีลาต​ฮ้อง​หมู่​หัวหน้า​ปุโรหิต หมู่​ผู้​นำ​จาว​ยิว กับ​คน​ตังหลาย​มา​ประชุม​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","แล้ว​อู้​กับ​หมู่​เขา​ว่า “ต้าน​ตังหลาย​ได้​ปา​คน​นี้​มา​หา​เฮา ฟ้อง​ว่า​เขา​ได้​สุ่ย​จาว​เมือง​หื้อ​กบฏ เฮา​ได้​สอบสวน​เขา​ต่อ​หน้า​ต้าน​ตังหลาย​แล้ว​ก็​หัน​ว่า​บ่﻿มี​หลักฐาน​ปอ​ตี้​จะ​ตัดสิน​ได้​ว่า​เขา​เยียะ​ผิด​อย่าง​ตี้​ต้าน​ว่า​ลอ ");
INSERT INTO nod_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","กษัตริย์​เฮโรด​ก็​หัน​ว่า​เขา​บ่﻿มี​ความ​ผิด​เหมือน​กั๋น ย้อน​จาอั้น​กษัตริย์​เฮโรด​ได้​ส่ง​ตั๋ว​ปิ๊ก​มา​หื้อ​เฮา​แหม เฮา​หัน​ว่า​คน​นี้​บ่﻿ได้​เยียะ​อะหยัง​ผิด​จ๋น​ต้อง​ลงโต้ษ​เถิง​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","เฮา​จะ​สั่ง​เฆี่ยน​เขา​แล้ว​ปล่อย​ไป​เหีย” ");
INSERT INTO nod_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","คน​ตังหลาย​ปา​กั๋น​เอิ้น​เสียง​ดัง​บอก​ปีลาต​ว่า “เอา​คน​นี้​ไป​ฆ่า​เหีย แล้ว​ป่อย​บารับบัส​หื้อ​หมู่​เฮา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(​บารับบัส​ถูก​ยับ​ขัง​คอก​ใน​ข้อหา​ฆ่า​คน​ต๋าย กับ​ก่อ​ก๋าน​วุ่นวาย​ใน​กรุง​เยรูซาเล็ม​) ");
INSERT INTO nod_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ปีลาต​ยัง​มี​ใจ๋​ใค่​ป่อย​พระเยซู ก็​อู้​กับ​หมู่​เขา​แหม​เตื้อ​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","คน​หมู่​นั้น​ก็​เอิ้น​เสียง​ดัง​บอก​ปีลาต​ว่า “เขิง​บน​ไม้​ก๋าง​เขน เขิง​บน​ไม้​ก๋าง​เขน” ");
INSERT INTO nod_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ปีลาต​อู้​กับ​หมู่​เขา​เป๋น​เตื้อ​ตี้​สาม​ว่า “เขิง​เขา​เยียะ​หยัง เขา​เยียะ​อะหยัง​ผิด เฮา​บ่﻿หัน​ว่า​เขา​มี​ความ​ผิด​จ๋น​ต้อง​ต๋าย​ลอ เฮา​จะ​เฆี่ยน​เขา​ก็​ปอ แล้ว​จะ​ป่อย​ตั๋ว​ไป” ");
INSERT INTO nod_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","คน​ตังหลาย​ฮ้อง​เป๋น​เสียง​เดียว​กั๋น​ว่า “เขิง​บน​ไม้​ก๋าง​เขน” ");
INSERT INTO nod_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ปีลาต​ตัดสินใจ๋​เยียะ​ต๋าม​ตี้​หมู่​เขา​ต้องก๋าน ");
INSERT INTO nod_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","จึง​ป่อย​คน​ตี้​ถูก​ยับ​เข้า​คอก​ใน​ข้อหา​ก่อ​ก๋าน​วุ่นวาย​กับ​ฆ่า​คน​ต๋าย หื้อ​หมู่​เขา​ไป ส่วน​พระเยซู​ก็​หื้อ​หมู่​เขา​เอา​ไป​เยียะ​จาใด​ก็​ได้ ต๋าม​ใจ๋​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","เมื่อ​ทหาร​ปา​พระเยซู​ออก​ไป หมู่​เขา​เข​ซีโมน​จาว​เมือง​ไซรีน ตี้​ก่ำลัง​ลุก​บ้าน​นอก​มา หื้อ​แบก​ไม้​ก๋าง​เขน​ตวย​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","มี​คน​จ๋ำนวน​นัก​ตวย​พระองค์​ไป ตึง​หมู่​แม่ญิง​ตี้​ไห้​ย้อน​อินดู​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","พระเยซู​เหลียว​มา​ผ่อ​หมู่​เขา​แล้ว​อู้​ว่า “ลูกสาว​แห่ง​เยรูซาเล็ม​เหย บ่﻿ถ้า​ไห้​ย้อน​อินดู​เฮา แต่​หื้อ​ไห้​ย้อน​อินดู​ตั๋ว​เก่า​กับ​ลูก​ของ​ตั๋ว​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ย้อน​จะ​มี​เวลา​นึ่ง​ตี้​คน​ตังหลาย​จะ​ว่า ‘แม่ญิง​หมู่​นี้​ตี้​เป๋น​หมัน ต๊อง​ตี้​บ่﻿ได้​มาน กับ​หัว​นม​ตี้​หละอ่อน​บ่﻿เกย​ดูด ก็​เป๋น​สุข’ ");
INSERT INTO nod_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","เวลา​นั้น​หมู่​เขา​จะ​อู้​กับ​ดอย​ตังหลาย​ว่า ‘ขอ​ดอย​โหยด​มา​เต๋ง​เฮา ขอ​ม่อน​ดอย​บัง​เฮา​ไว้​น่อย​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ย้อน​ว่า​ถ้า​คน​ตังหลาย​เยียะ​กับ​คน​บริสุทธิ์​ขนาด​นี้ แล้ว​อะหยัง​จะ​เกิด​ขึ้น​กับ​คน​ตี้​เยียะ​ผิด​พ่อง” ");
INSERT INTO nod_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","หมู่​ทหาร​กุม​นักโต้ษ​แหม​สอง​คน​มา​ตวย​พระเยซู เปื้อ​ฆ่า​พร้อม​กับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","หมู่​เขา​ปา​ตึง​สาม​คน​มา​เถิง​ตี้​แห่ง​นึ่ง​จื้อ​ว่า “เนิน​กระโหล้ง​หัว” แล้ว​เอา​พระเยซู​เขิง​บน​ไม้​ก๋าง​เขน​ฮ่วม​กับ​นักโต้ษ​สอง​คน ตัง​ซ้าย​คน​นึ่ง ตัง​ขวา​คน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","พระเยซู​อธิษฐาน​ว่า “พระบิดา​เจ้า​ข้า ขอ​ยก​โต้ษ​หื้อ​หมู่​เขา​ตวย ย้อน​หมู่​เขา​บ่﻿ฮู้​ว่า​ก่ำลัง​เยียะ​อะหยัง” หมู่​ทหาร​เอา​เสื้อผ้า​ของ​พระองค์​มา​จก​เบอร์​แบ่ง​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","จาว​เมือง​ตังหลาย​ก็​ยืน​ผ่อ​อยู่ หมู่​ผู้​นำ​จาว​ยิว​อู้​เยาะเย้ย​พระองค์​ว่า “เขา​จ้วย​จีวิต​คน​อื่น​หื้อ​รอด​ได้ ก็​หื้อ​จ้วย​จีวิต​ตั๋ว​เก่า​ผ่อ​ลอ ถ้า​เขา​เป๋น​พระคริสต์​ผู้​ตี้​พระเจ้า​ได้​เลือก​ไว้” ");
INSERT INTO nod_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","หมู่​ทหาร​ก็​เยาะเย้ย​พระองค์​ตวย หมู่​เขา​เอา​เหล้า​องุ่น​ส้ม​หื้อ​พระองค์​กิ๋น ");
INSERT INTO nod_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","อู้​ว่า “ถ้า​ต้าน​เป๋น​กษัตริย์​ของ​จาว​ยิว​ก็​จ้วย​ตั๋ว​เก่า​หื้อ​รอด​ก่อน​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","มี​ป้าย​เขียน​ข้อความ​ติด​ไว้​เหนือ​หัว​พระองค์​ว่า “คน​นี้​คือ​กษัตริย์​ของ​จาว​ยิว” ");
INSERT INTO nod_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","นักโต้ษ​คน​นึ่ง​ตี้​ถูก​เขิง​บน​ไม้​ก๋าง​เขน​ข้าง​พระองค์ ก็​เยาะเย้ย​พระองค์​ว่า “ต้าน​เป๋น​พระคริสต์​บ่﻿ใจ้​กา จ้วย​ตั๋ว​เก่า​กับ​เฮา​หื้อ​รอด​แหล่” ");
INSERT INTO nod_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","แต่​มี​นักโต้ษ​แหม​คน​นึ่ง​ห้าม​เขา​ว่า “บ่﻿กั๋ว​พระเจ้า​กา เจ้า​ก็​เป๋น​นักโต้ษ​ตี้​ต้อง​ถูก​ฆ่า​ต๋าย​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","เฮา​สอง​คน​ก็​สม​กับ​โต้ษ​นั้น​แต๊ หมู่​เฮา​ได้ฮับ​โต้ษ​ต๋าม​ตี้​หมู่​เฮา​เยียะ​ไป​นั้น แต่​ต้าน​คน​นี้​บ่﻿ได้​เยียะ​ผิด​อะหยัง​เลย” ");
INSERT INTO nod_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","แล้ว​เขา​ก็​อู้​ว่า “พระเยซู​เจ้า​ข้า ขอ​กึ๊ด​หา​ข้าพเจ้า​พ่อง เมื่อ​พระองค์​เข้า​ไป​ใน​สวน​สวรรค์” ");
INSERT INTO nod_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","พระเยซู​ตอบ​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า วัน​นี้​ต้าน​จะ​ได้​อยู่​กับ​เฮา​ใน​สวน​สวรรค์​แน่นอน” ");
INSERT INTO nod_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ต๋อน​นั้น​เป๋น​เวลา​ประมาณ​เตี้ยง​วัน ก็​มืด​ไป​ใคว่​แผ่นดิน​จ๋น​เถิง​บ่าย​สาม​โมง ");
INSERT INTO nod_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ตะวัน​ก็​ดับ​มืด​ไป ผ้ากั้ง​ใน​พระวิหาร​ก็​ฉีก​ออก​เป๋น​สอง​เผิก ");
INSERT INTO nod_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","พระเยซู​ฮ้อง​เสียง​ดัง​ขึ้น​ว่า “พระบิดา​เจ้า​ข้า ข้า​พระองค์​ขอ​มอบ​วิญญาณ​ของ​ข้า​พระองค์​ไว้​กับ​พระองค์” เมื่อ​อู้​จาอั้น​แล้ว​ก็​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","นายร้อย​ทหาร​เมื่อ​หัน​เหตุก๋ารณ์​เป๋น​ไป​จาอั้น ก็​สรรเสริญ​พระเจ้า​ว่า “แต๊﻿ๆ แล้ว ต้าน​คน​นี้​เป๋น​คน​บริสุทธิ์” ");
INSERT INTO nod_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","คน​ตังหลาย​ตี้​มา​หลุ้ม​ผ่อ​เหตุก๋ารณ์ ก็​ปา​กั๋น​ตบ​อก​ด้วย​ความ​โศกเศร้า​เสียใจ๋​ปิ๊ก​เมือ​บ้าน ");
INSERT INTO nod_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","คน​ตี้​ฮู้จัก​พระเยซู กับ​หมู่​แม่ญิง​ตี้​เกย​ติดต๋าม​พระองค์​จาก​กาลิลี​ก็​ปา​กั๋น​ยืน​ผ่อ​อยู่​ห่าง﻿ๆ ");
INSERT INTO nod_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","มี​ป้อจาย​คน​นึ่ง​จื้อ​โยเซฟ เป๋น​คน​ดี​กับ​เยียะ​ถูกต้อง​ต๋าม​ธรรม กับ​เป๋น​สมาชิก​สภา​คน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","เขา​เป๋น​จาว​อาริมาเธีย​อยู่​ใน​แคว้น​ยูเดีย กับ​ก่ำลัง​ถ้า​แผ่นดิน​ของ​พระเจ้า เขา​บ่﻿หัน​ตวย​ใน​ก๋าน​ตัดสิน​ฆ่า​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","เขา​เข้า​ไป​หา​ปีลาต​เปื้อ​ขอ​ศพ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","เมื่อ​ได้ฮับ​อนุญาต​แล้ว ก็​เอา​ศพ​ลง​มา​จาก​ไม้​ก๋าง​เขน เอา​ผ้า​ลินิน​ปัน​ศพ แล้ว​เอา​ไป​ไว้​ใน​อุโมงค์​ตี้​เจาะ​เข้า​ไป​ใน​หิน อุโมงค์​นั้น​ยัง​บ่﻿ได้​ใส่​ศพ​คน​ใด​เตื้อ ");
INSERT INTO nod_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","วัน​นั้น​เป๋น​วัน​ดา​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","หมู่​แม่ญิง​ตี้​เกย​ติดต๋าม​พระเยซู​มา​จาก​กาลิลี​ก็​ไป​ตวย​โยเซฟ​ตี้​อุโมงค์​นั้น จะ​ได้​หัน​ว่า​เขา​เอา​ศพ​ไว้​จาใด ");
INSERT INTO nod_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","จาก​นั้น​หมู่​เขา​ก็​ปิ๊ก​เมือ​บ้าน ไป​เกียม​เครื่องหอม​กับ​น้ำมัน​หอม​เปื้อ​จะ​เอา​มา​อาบ​ศพ​พระเยซู แต่​ใน​วัน​สะบาโต​เขา​ปา​กั๋น​ย้าง​วัน​นึ่ง​ต๋าม​บท​บัญญัติ​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","เจ๊ามืด​วัน​ติ๊ด หมู่​แม่ญิง​เอา​เครื่องหอม​ตี้​เขา​จัด​เกียม​ไว้​มา​ตี้​อุโมงค์​ฝัง​ศพ​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","หมู่​นาง​ก็​หัน​บ่าหิน​ใหญ่​ตี้​ตึด​ปาก​อุโมงค์​ฝัง​ศพ​อยู่ กิ้ง​ออก​ไป​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","เมื่อ​หมู่​นาง​เข้า​ไป​ตัง​ใน​ก็​ผ่อ​บ่﻿หัน​ศพ​ของ​พระเยซู​องค์​พระผู้เป๋นเจ้า ");
INSERT INTO nod_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","เมื่อ​ก่ำลัง​กึ๊ด ย้อน​บ่﻿เข้าใจ๋​ใน​เหตุก๋ารณ์​นั้น ก็​มี​ป้อจาย​สอง​คน​มา​ยืน​อยู่​ใก้﻿ๆ เสื้อผ้า​เหลื้อม​มาบ﻿ๆ จ๋น​ผ่อ​ปอ​จะ​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","แม่ญิง​หมู่​นั้น​กั๋ว​เลย​ก้ม​หน้า​ลง​ดิน ป้อจาย​สอง​คน​นั้น​อู้​กับ​หมู่​เขา​ว่า “หมู่​เจ้า​มา​หา​คน​เป๋น​ใน​หมู่​คน​ต๋าย​เยียะ​หยัง ");
INSERT INTO nod_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","พระองค์​บ่﻿อยู่​ตี้​นี่​แต่​พระเจ้า​เยียะ​หื้อ​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว หื้อ​กึ๊ด​เถิง​กำ​ตี้​พระองค์​ได้​อู้​กับ​ต้าน​ตังหลาย​เมื่อ​พระองค์​อยู่​ใน​แคว้น​กาลิลี​ว่า ");
INSERT INTO nod_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘บุตรมนุษย์​จะ​ถูก​มอบ​ไว้​ใน​อำนาจ​ของ​คน​บาป จะ​ถูก​เขิง​ไว้​บน​ไม้​ก๋าง​เขน​จ๋น​ต๋าย แล้ว​ใน​วัน​ตี้​สาม​พระองค์​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย’ ” ");
INSERT INTO nod_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","เมื่อ​หมู่​นาง​กึ๊ด ก็​จ๋ำ​กำ​ตี้​พระองค์​อู้​นั้น​ได้ ");
INSERT INTO nod_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","เมื่อ​ปิ๊ก​จาก​อุโมงค์​ก็​ปา​กั๋น​ไป​บอก​หมู่​สาวก​สิบ​เอ็ด​คน​กับ​คน​อื่น﻿ๆ ต๋าม​ตี้​ได้​หัน​ได้ยิน​มา​นั้น ");
INSERT INTO nod_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","คน​ตี้​ไป​บอก​หมู่​อัคร​สาวก​คือ มารีย์​จาว​มักดาลา โยอันนา มารีย์​แม่​ของ​ยากอบ กับ​แม่ญิง​คน​อื่น​ตี้​อยู่​ตวย​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","หมู่​อัคร​สาวก​บ่﻿เจื้อ หา​ว่า​แม่ญิง​หมู่​นี้​อู้​ไป​เล่ย ");
INSERT INTO nod_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","เปโตร​เมื่อ​ได้ยิน​แล้ว ก็​ล่น​ไป​ตี้​อุโมงค์​ก้ม​ส่อง​เข้า​ไป​ใน​อุโมงค์ ก็​หัน​ก้า​ผ้า​ปัน​ศพ​เต้าอั้น เปโตร​ก็​งืด​แล้ว​ปิ๊ก​บ้าน ");
INSERT INTO nod_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ใน​วัน​เดียว​กั๋น​นั้น มี​สาวก​สอง​คน​ออก​จาก​กรุง​เยรูซาเล็ม ไป​หมู่​บ้าน​เอมมาอูส หมู่​บ้าน​นี้​อยู่​ห่าง​จาก​กรุง​เยรูซาเล็ม​สิบ​เอ็ด​กิโลเมตร ");
INSERT INTO nod_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","เมื่อ​เตียวตาง​ไป หมู่​เขา​อู้​กั๋น​เรื่อง​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​กับ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ต๋อน​ตี้​หมู่​เขา​ก่ำลัง​อู้​กั๋น​อยู่ พระเยซู​ก็​เข้า​มา​หา​แล้ว​เตียว​ไป​ตวย​กั๋น ");
INSERT INTO nod_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","พระเจ้า​เยียะ​หื้อ​หมู่​เขา​จ๋ำ​พระองค์​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","พระองค์​ถาม​หมู่​เขา​ว่า “หละหว่าง​เตียวตาง​มา​นี่​หมู่​ต้าน​อู้​กั๋น​เรื่อง​อะหยัง” หมู่​เขา​ก็​หยุด​ยืน​หน้า​หมอง​ต๋อง​เศร้า​อยู่ ");
INSERT INTO nod_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","คน​นึ่ง​จื้อ​เคลโอปัส​ก็​ถาม​พระองค์​ว่า “ต้าน​ท่า​จะ​เป๋น​คน​เดียว​ใน​กรุง​เยรูซาเล็ม ตี้​บ่﻿ฮู้​เรื่อง​เหตุก๋ารณ์​ตังหลาย​ตี้​เกิด​ขึ้น​ใน​สอง​สาม​วัน​นี้​เหีย​ก้า” ");
INSERT INTO nod_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","พระเยซู​ถาม​เขา​ว่า “เหตุก๋ารณ์​อะหยัง” เขา​ก็​ตอบ​พระองค์​ว่า “เหตุก๋ารณ์​เรื่อง​พระเยซู​จาว​เมือง​นาซาเร็ธ เปิ้น​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตี้​มี​ฤทธิ์​อำนาจ​ใน​ก๋าน​งาน กับ​ใน​กำ​อู้​ต่อหน้า​พระเจ้า​กับ​ต่อหน้า​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ผู้​นำ​ของ​หมู่​เฮา​ได้​มอบ​พระองค์​หื้อ​ถูก​ตัดสิน​ลงโต้ษ​เถิง​ต๋าย หมู่​เขา​เอา​พระองค์​เขิง​บน​ไม้​ก๋าง​เขน ");
INSERT INTO nod_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","แต่​เฮา​ตังหลาย​ได้​หวัง​ไว้​ว่า ต้าน​ผู้​นี้​จะ​เป๋น​ผู้​ไถ่​จาว​อิสราเอล​จาก​อาณาจักร​โรม ");
INSERT INTO nod_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ซ้ำ​วัน​นี้​เป๋น​วัน​ตี้​สาม​แล้ว​ตี้​เหตุก๋ารณ์​นั้น​เกิด​ขึ้น เจ๊ามืด​วัน​นี้​มี​แม่ญิง​สอง​สาม​คน​เยียะ​หื้อ​หมู่​เฮา​งืด​ขนาด หมู่​เขา​ไป​ตี้​อุโมงค์​ฝัง​ศพ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","แต่​บ่﻿หัน​ศพ​ของ​พระองค์ ก็​ปิ๊ก​มา​เล่า​หื้อ​ฟัง​ว่า ได้​หัน​หมู่​ทูตสวรรค์​กับ​หมู่​ทูตสวรรค์​บอก​ว่า พระองค์​ยัง​มี​จีวิต​อยู่ ");
INSERT INTO nod_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","มี​บาง​คน​ใน​หมู่​เฮา​ก็​ไป​ผ่อ​ตี้​อุโมงค์ แต่​บ่﻿หัน​พระองค์​อย่าง​ตี้​หมู่​แม่ญิง​บอก​นั้น​ละ” ");
INSERT INTO nod_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","พระเยซู​อู้​กับ​สอง​คน​นั้น​ว่า “เออ​คน​ง่าว เป๋น​จาใด​บ่﻿เจื้อ​กำ​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​บอก​ไว้ ");
INSERT INTO nod_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","จ๋ำ​เป๋น​ตี้​พระคริสต์​จะ​ต้อง​ทน​ตุ๊ก​ทรมาน​จาอั้น แล้ว​จึง​จะ​ได้ฮับ​เกียรติ​บ่﻿ใจ้​กา” ");
INSERT INTO nod_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","พระเยซู​อธิบาย​สิ่ง​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​ตี้​เล็ง​เถิง​พระองค์ ตั้งแต่​โมเสส​จ๋น​เถิง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตึง​หมด​หื้อ​เขา​ฟัง ");
INSERT INTO nod_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","เมื่อ​ใก้​จะ​แผว​หมู่​บ้าน​ตี้​หมู่​เขา​ไป​นั้น พระเยซู​เยียะ​เหมือน​จะ​เตียว​ก๋าย​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","แต่​หมู่​เขา​ก็​อู้​เหนี่ยว​พระองค์​ไว้​ว่า “เจิญ​ต้าน​ย้าง​ตวย​กั๋น​เต๊อะ บ่าเดี่ยว​นี้​ก็​ค่ำ​แล้ว ตะวัน​เกือบ​จะ​ตก​แล้ว” พระองค์​ก็​เข้า​ไป​ย้าง​ตวย​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ต๋อน​ตี้​พระองค์​กิ๋น​ข้าว​ตวย​หมู่​เขา พระองค์​ก็​หยิบ​เข้าหนมปัง​ขอบ​พระคุณ​พระเจ้า แล้ว​หัก​ส่ง​หื้อ​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","พระเจ้า​ก็​เยียะ​หื้อ​หมู่​เขา​จ๋ำ​พระองค์​ได้ หมู่​เขา​ก็​จ๋ำ​พระองค์​ได้​แต่​พระองค์​หาย​ตั๋ว​ไป​เหีย​แล้ว ");
INSERT INTO nod_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","หมู่​เขา​ก็​อู้​กั๋น​ว่า “ใจ๋​หมู่​เฮา​เต้น​ตุ๊บ﻿ๆ ตั๊บ﻿ๆ เมื่อ​อู้​กั๋น​มา​ต๋าม​ตาง​กับ​เมื่อ​พระองค์​อธิบาย​พระคัมภีร์​หื้อ​ฟัง​แม่น​ก่อ” ");
INSERT INTO nod_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","แล้ว​ตึง​สอง​คน​ก็​ฟั่ง​ปิ๊ก​ไป​กรุง​เยรูซาเล็ม เมื่อ​มา​แผว ก็​ปะ​หมู่​สาวก​สิบ​เอ็ด​คน​ก่ำลัง​จุมนุม​กั๋น​กับ​คน​อื่น​หลาย​คน อู้​กั๋น​ว่า ");
INSERT INTO nod_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“องค์​พระผู้เป๋นเจ้า​ได้​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แต๊﻿ๆ ซีโมน​ก็​หัน” ");
INSERT INTO nod_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","สอง​คน​นั้น​ก็​เล่า​เรื่อง​ตี้​เกิด​ขึ้น​ต๋าม​ตาง กับ​ตี้​เขา​จ๋ำ​พระองค์​ได้​ต๋อน​หัก​เข้าหนมปัง ");
INSERT INTO nod_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","เมื่อ​สอง​คน​นั้น​ก่ำลัง​เล่า​เรื่อง​หื้อ​หมู่​สาวก​ตังหลาย​ฟัง พระเยซู​ก็​เข้า​มา​ยืน​อยู่​ต้ามก๋าง​หมู่​เขา แล้ว​ก็​อู้​ว่า “ขอ​หื้อ​หมู่​ต้าน​มี​สันติสุข​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","หมู่​เขา​ตกใจ๋​กั๋ว​กึ๊ด​ว่า​หัน​ผี ");
INSERT INTO nod_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","พระเยซู​ก็​อู้​กับ​หมู่​เขา​ว่า “เป๋น​จาใด​หมู่​ต้าน​เถิง​กั๋ว สงสัย​เยียะ​หยัง ");
INSERT INTO nod_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ผ่อ​มือ​ผ่อ​ตี๋น​เฮา​ลอ แล้ว​จะ​ฮู้​ว่า​เป๋น​เฮา ยุบ​ตั๋ว​เฮา​ผ่อ​ลอ ผี​บ่﻿มี​เนื้อหนัง บ่﻿มี​กระดูก เหมือน​ตี้​ต้าน​ตังหลาย​หัน​เฮา​มี” ");
INSERT INTO nod_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","เมื่อ​พระองค์​อู้​จาอั้น​แล้ว พระองค์​ก็​เอา​มือ​เอา​ตี๋น​หื้อ​หมู่​เขา​ผ่อ ");
INSERT INTO nod_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","เมื่อ​หมู่​เขา​ยัง​บ่﻿เจื้อ​แต๊﻿ๆ ว่า​เป๋น​พระเยซู ย้อน​หมู่​เขา​ก่ำลัง​อัศจ๋รรย์​ใจ๋​กับ​จื้นจมยินดี​อยู่​นั้น​พระองค์​ก็​ถาม​หมู่​เขา​ว่า “หมู่​ต้าน​มี​อะหยัง​กิ๋น​พ่อง​ก่อ” ");
INSERT INTO nod_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","หมู่​เขา​ก็​เอา​ป๋า​ปิ้ง​ติ่น​นึ่ง​มา​หื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","พระองค์​ก็​กิ๋น​ส่อง​หน้า​เขา​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","แล้ว​พระองค์​อู้​กับ​หมู่​เขา​ว่า “เมื่อ​เฮา​ยัง​อยู่​ตวย​หมู่​ต้าน ก็​บอก​หื้อ​ฮู้​ว่า​กู้​กำ​ตี้​เขียน​ไว้​ใน​บท​บัญญัติ​ของ​โมเสส กำ​ตี้​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตังหลาย​ได้​เขียน กับ​กำ​ตี้​เขียน​ไว้​ใน​พระธรรม​สดุดี ตี้​อู้​เถิง​เฮา​นั้น​จะ​ต้อง​เป๋น​แต๊​ต๋าม​นั้น” ");
INSERT INTO nod_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","แล้ว​พระเยซู​ก็​เยียะ​หื้อ​หมู่​เขา​เข้าใจ๋​ข้อ​ต่าง﻿ๆ หมู่​นี้​ใน​พระคัมภีร์​ได้ ");
INSERT INTO nod_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","พระองค์​บอก​หมู่​เขา​ว่า “มี​เขียน​ไว้​ว่า จ๋ำเป๋น​ตี้​พระคริสต์​จะ​ต้อง​ทน​ตุ๊ก​ทรมาน​จ๋น​ต๋าย แล้ว​ใน​วัน​ตี้​สาม​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","แล้ว​หื้อ​บอก​คน​กู้​จ้าด​ใน​นาม​ของ​พระองค์ เรื่อง​ก๋าน​กลับใจ๋​จาก​บาป กับ​เรื่อง​ก๋าน​ยกโต้ษ​บาป ตั้งเก๊า​ตี้​กรุง​เยรูซาเล็ม​ก่อน ");
INSERT INTO nod_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","หมู่​ต้าน​จะ​เป๋น​พยาน​ใน​เรื่อง​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","เฮา​จะ​หื้อ​สิ่ง​ตี้​พระบิดา​สัญญา​ว่า​จะ​หื้อ​หมู่​ต้าน แต่​หมู่​ต้าน​ต้อง​ถ้า​อยู่​ใน​กรุง​เยรูซาเล็ม​ก่อน จ๋น​กว่า​ต้าน​จะ​ได้ฮับ​ฤทธิ์​อำนาจ​จาก​เบื้อง​บน​เหีย​ก่อน” ");
INSERT INTO nod_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","พระเยซู​ปา​หมู่​สาวก​ออก​จาก​กรุง​เยรูซาเล็ม​ไป​ตี้​หมู่​บ้าน​เบธานี แล้ว​พระองค์​ยก​มือ​ปั๋น​ปอน​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","เมื่อ​ก่ำลัง​ปั๋น​ปอน​อยู่​นั้น พระเจ้า​ก็​ฮับ​พระองค์​ขึ้น​ไป​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","หมู่​สาวก​ก็​นมัสก๋าน​พระองค์ แล้ว​ปา​กั๋น​ปิ๊ก​เข้า​กรุง​เยรูซาเล็ม​ด้วย​ความ​จื้นจมยินดี ");
INSERT INTO nod_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","หมู่​เขา​อยู่​ใน​พระวิหาร​กู้​วัน เปื้อ​สรรเสริญ​พระเจ้า");
INSERT INTO nod_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ก่อน​ตี้​พระเจ้า​จะ​สร้าง​โลก​นี้ ก็​มี​ผู้​ตี้​ฮ้อง​กั๋น​ว่า พระกำ อยู่​แล้ว พระกำ​อยู่​กับ​พระเจ้า กับ​เป๋น​พระเจ้า​ตวย ");
INSERT INTO nod_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","พระกำ​อยู่​กับ​พระเจ้า​ตั้งแต่​เมื่อ​เก๊าหัวที ");
INSERT INTO nod_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","พระเจ้า​ใจ๊​พระกำ​สร้าง​กู้​สิ่ง​กู้​อย่าง ใน​กู้​สิ่ง​ตี้​เกิด​นั้น​บ่﻿มี​อะหยัง​เลย​ตี้​เกิด​นอก​เหนือ​จาก​พระกำ ");
INSERT INTO nod_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","พระกำ​เป๋น​เก๊า​เหง้า​จีวิต กับ​จีวิต​นั้น​ก็​นำ​ความ​เป่งแจ้ง​มา​หื้อ​กู้​คน ");
INSERT INTO nod_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ความ​เป่งแจ้ง​ส่อง​เข้า​มา​ใน​ความ​มืด แต่​ความ​มืด​เยียะ​หื้อ​ความ​เป่งแจ้ง​ดับ​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","พระเจ้า​ได้​ส่ง​ป้อจาย​มา​คน​นึ่ง​จื้อ​ยอห์น​ผู้​หื้อ​บัพติศมา ");
INSERT INTO nod_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ต้าน​มา​เป๋น​พยาน​หื้อ​ความ​เป่งแจ้ง​นั้น เปื้อ​กู้​คน​จะ​ได้​เจื้อ​ความ​เป่งแจ้ง​นั้น​โดย​กำ​พยาน​ของ​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ยอห์น​บ่﻿ใจ้​ความ​เป่งแจ้ง​นั้น แต่​ต้าน​มา​เป๋น​พยาน​หื้อ​ความ​เป่งแจ้ง​นั้น ");
INSERT INTO nod_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","พระองค์ ผู้​ตี้​เป๋น​ความ​เป่งแจ้ง​แต๊ ตี้​เยียะ​หื้อ​กู้​คน​หัน​ความ​จริง​เรื่อง​พระเจ้า​นั้น ก่ำลัง​เข้า​มา​ใน​โลก ");
INSERT INTO nod_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","พระองค์​นั้น​อยู่​ใน​โลก​นี้ เถิงแม้​ว่า​พระเจ้า​สร้าง​โลก​ขึ้น​มา​โดย​พระองค์ แต่​ก็​บ่﻿มี​ใผ​ใน​โลก​นี้​ฮู้จัก​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","พระองค์​ได้​มา​ตี้​บ้านเมือง​ของ​พระองค์ แต่​ปี้น้อง​จาว​บ้าน​ของ​พระองค์ ก็​ยัง​บ่﻿ยอม​ฮับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","แต่​ใผ​ตี้​ยอมฮับ​และ​เจื้อ​วางใจ๋​ใน​พระองค์ พระองค์​ก็​หื้อ​สิทธิ์​เขา​เป๋น​ลูก​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","บ่﻿ใจ้​ลูก​ตี้​เกิด​จาก​คน กาว่า​เกิด​จาก​ความ​ต้องก๋าน​ตาง​ก๋าย กาว่า​เกิด​จาก​ความ​ต้องก๋าน​ของ​ป้อแม่ แต่​พระเจ้า​เยียะ​หื้อ​เป๋น​ลูก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","พระกำ​ได้​มา​เกิด​เป๋น​คน​และ​อยู่​ต้ามก๋าง​หมู่​เฮา พระองค์​มี​พระคุณ​กับ​ความ​จริง​เกี่ยวกับ​พระเจ้า​อย่าง​เต๋ม​ล้น แล้ว​หมู่​เฮา​เกย​หัน​ความ​ยิ่งใหญ่​ของ​พระบุตร​องค์​เดียว​ตี้​มา​จาก​พระบิดา ");
INSERT INTO nod_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ยอห์น​เป๋น​พยาน​เรื่อง​ของ​พระองค์​และ​ฮ้องเอิ้น​บอก​คน​ตังหลาย​ว่า “คน​นี้​คือ​คน​ตี้​เฮา​เกย​อู้​เถิง​ว่า ‘ผู้​ตี้​มา​เมื่อ​ลูน​เฮา​จะ​เป๋น​คน​ตี้​ยิ่งใหญ่​นัก​เหลือ​ตั๋ว​เฮา ย้อน​ว่า​ต้าน​มี​อยู่​ก่อน​ตี้​เฮา​จะ​เกิด​แหม’ ” ");
INSERT INTO nod_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","พระองค์​มี​พระคุณ​เต๋ม​ล้น ก็​เลย​ปั๋น​ปอน​หื้อ​หมู่​เฮา​บ่﻿ขาด​เลย ");
INSERT INTO nod_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","พระเจ้า​ได้​หื้อ​บท​บัญญัติ​ของ​พระองค์​ผ่าน​ตาง​โมเสส แต่​หื้อ​พระคุณ​กับ​ความ​จริง​เกี่ยวกับ​พระองค์​ผ่าน​ตาง​พระเยซู​คริสต์ ");
INSERT INTO nod_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","บ่﻿มี​ใผ​เกย​หัน​พระเจ้า มี​ก้า​พระบุตร​องค์​เดียว​ของ​พระเจ้า ตี้​เป๋น​พระเจ้า​เอง กับ​อยู่​ใก้​พระบิดา ตี้​เยียะ​หื้อ​เฮา​ฮู้จัก​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","นี่​เป๋น​กำ​พยาน​ของ​ยอห์น เมื่อ​หมู่​ผู้นำ​จาว​ยิว​ใน​กรุง​เยรูซาเล็ม​ส่ง​หมู่​ปุโรหิต​กับ​หมู่​เลวี​ไป​หา​ยอห์น หมู่​เขา​มา​ถาม​ยอห์น​ว่า “ต้าน​เป๋น​ใผ” ");
INSERT INTO nod_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ยอห์น​ยอมฮับ​อย่าง​เปิดเผย กับ​บอก​ความ​จริง​กับ​เขา​ว่า “เฮา​บ่﻿ใจ้​พระคริสต์” ");
INSERT INTO nod_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","แล้ว​หมู่​เขา​ก็​ถาม​แหม​ว่า “ถ้า​จาอั้น เป๋น​เอลียาห์​กา” ยอห์น​ก็​บอก​ว่า “บ่﻿ใจ้” หมู่​เขา​ก็​ถาม​แหม​ว่า “เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​นั้น​ตี้​เฮา​กอย​ถ้า​อยู่​กา” ยอห์น​ก็​บอก​ว่า “บ่﻿ใจ้” ");
INSERT INTO nod_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","หมู่​เขา​ก็​เลย​ถาม​ว่า “แล้ว​ต้าน​เป๋น​ใผ​กั๋น​แน่ บอก​หื้อ​เฮา​ฮู้​กำ เฮา​ต้อง​ปิ๊ก​ไป​ตอบ​คน​ตี้​ใจ๊​เฮา​มา ต้าน​ว่า​ต้าน​เป๋น​ใผ” ");
INSERT INTO nod_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ยอห์น​ก็​เลย​ตอบ​ต๋าม​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ตี้​ได้​อู้​ไว้​ว่า “เฮา​เป๋น​เสียง​ฮ้องเอิ้น​ของ​คน​นึ่ง​ใน​ดินแดน​ทุรกั๋นดาร​ว่า จง​แป๋ง​หน​ตาง​ซื่อ﻿ๆ หื้อ​องค์​พระ​ผู้​เป๋น​เจ้า” ");
INSERT INTO nod_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","บาง​คน​ตี้​หมู่​ฟาริสี​ส่ง​มา ");
INSERT INTO nod_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ถาม​ว่า “ถ้า​ต้าน​บ่﻿ใจ้​พระคริสต์ บ่﻿ใจ้​เอลียาห์ กับ​บ่﻿ใจ้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​นั้น แล้ว​จาใด​ต้าน​เถิง​หื้อ​บัพติศมา​กับ​คน​ตังหลาย” ");
INSERT INTO nod_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ยอห์น​ก็​ตอบ​ว่า “เฮา​หื้อ​บัพติศมา​ด้วย​น้ำ แต่​จะ​มี​แหม​ผู้​นึ่ง​ใน​หมู่​ต้าน ตี้​หมู่​ต้าน​ยัง​บ่﻿ฮู้จัก​ว่า​เป๋น​ใผ ");
INSERT INTO nod_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ต้าน​เป๋น​ผู้​ตี้​จะ​มา​เมื่อลูน​เฮา แม้แต่​แก้​สาย​มัด​เกิบ​ของ​ต้าน ตั๋ว​เฮา​ยัง​บ่﻿สมควร​จะ​เยียะ​จาอั้น​เลย” ");
INSERT INTO nod_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","เหตุก๋ารณ์​นี้​เกิด​ขึ้น​ตี้​หมู่​บ้าน​เบธานี​เผิก​ตัง​วันออก​ของ​แม่น้ำ​จอร์แดน​ตี้​ยอห์น​ก่ำลัง​หื้อ​บัพติศมา​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","แหม​วัน​นึ่ง ยอห์น​หัน​พระเยซู​เตียว​ซื่อ​มา​ตาง​เขา ยอห์น​ก็​เอิ้น​ว่า “หั้น​ลอ ลูก​แกะ​ของ​พระเจ้า ตี้​จะ​มา​ฮับ​เอา​โต้ษ​บาป​ของ​โลก​ไป ");
INSERT INTO nod_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","คน​นี้​คือ​คน​ตี้​เฮา​เกย​อู้​เถิง​ว่า ‘จะ​มี​คน​นึ่ง​มา​เมื่อ​ลูน​เฮา จะ​เป๋น​คน​ตี้​ยิ่งใหญ่​นัก​เหลือ​ตั๋ว​เฮา ย้อน​ว่า​ต้าน​มี​อยู่​ก่อน​ตี้​เฮา​จะ​เกิด​แหม’ ");
INSERT INTO nod_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ตั๋ว​เฮา​ก็​บ่﻿ฮู้​ว่า​ต้าน​เป๋น​ใผ แต่​ตี้​เฮา​หื้อ​บัพติศมา​ด้วย​น้ำ ก็​เปื้อ​จะ​เปิดเผย​หื้อ​จาว​อิสราเอล​ได้​ฮู้จัก​ต้าน” ");
INSERT INTO nod_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","ยอห์น​ก็​อู้​เป๋น​พยาน​แหม​ว่า “เฮา​บ่﻿ฮู้​ว่า​ต้าน​ผู้​นั้น​เป๋น​ใผ แต่​ผู้​ตี้​ใจ๊​เฮา​มา​หื้อ​บัพติศมา​ด้วย​น้ำ​เกย​บอก​ว่า ‘เมื่อ​ต้าน​หัน​พระวิญญาณ​ของ​พระเจ้า​ลง​มา​อยู่​กับ​ใผ คน​นั้น​ละ​จะ​เป๋น​คน​หื้อ​บัพติศมา​ด้วย​พระวิญญาณ​บริสุทธิ์’ แล้ว​เฮา​ได้​หัน​พระวิญญาณ​ลง​มา​จาก​ฟ้า​สวรรค์​มี​ฮูปฮ่าง​เหมือน​นกก๋าแก๋​ลง​มา​อยู่​กับ​ป้อจาย​คน​นี้ ");
INSERT INTO nod_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","เฮา​หัน​เรื่อง​นี้​กับ​ต๋า​ตั๋วเก่า เป๋น​พยาน​ได้​ว่า คน​นี้​เป๋น​พระบุตร​ของ​พระเจ้า​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ต่อ​มา​แหม​วัน​นึ่ง ยอห์น​ก่ำลัง​ยืน​อยู่​กับ​สาวก​ของ​เขา​สอง​คน ");
INSERT INTO nod_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","เมื่อ​ยอห์น​หัน​พระเยซู​เตียว​ก๋าย​ไป ก็​อู้​ว่า “หั้น​ลอ ลูก​แกะ​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","เมื่อ​สาวก​สอง​คน​นั้น ได้​ยิน​จาอั้น​ก็​เตียว​ตวย​พระเยซู​ไป ");
INSERT INTO nod_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","พระเยซู​ก็​งว้าย​มา แล้ว​หัน​เขา​สอง​คน​เตียว​ตวย​มา พระองค์​ก็​ถาม​ว่า “ต้าน​ต้องก๋าน​อะหยัง” แล้ว​หมู่​เขา​ก็​ตอบ​ว่า “รับบี” (​หมายเถิง​อาจ๋ารย์​) “ต้าน​พัก​อยู่​ตี้​ไหน” ");
INSERT INTO nod_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","พระเยซู​ก็​บอก​ว่า “ตวย​มา​ผ่อ​แล่” แล้ว​สาวก​ของ​ยอห์น​สอง​คน​ก็​ตวย​พระเยซู​ไป​ตี้​อยู่​ของ​พระองค์ ต๋อน​นั้น​เป๋น​เวลา​สี่​โมง​แลง​แล้ว หมู่​เขา​ก็​เลย​อยู่​ตวย​พระเยซู​จ๋น​เสี้ยง​วัน​นั้น ");
INSERT INTO nod_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","อันดรูว์ น้องบ่าว​ของ​ซีโมน​เปโตร​เป๋น​คน​นึ่ง​ใน​สอง​คน​นั้น​ตี้​ได้​ยิน​ยอห์น​อู้ แล้ว​ตวย​พระเยซู​ไป ");
INSERT INTO nod_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","อย่าง​แรก​ตี้​อันดรูว์​เยียะ ก็​คือ​ไป​หา​ซีโมน​อ้าย​ของ​เขา แล้ว​อันดรูว์​ก็​เล่า​หื้อ​ซีโมน​ฟัง​ว่า “เฮา​ได้​ปะ​กับ​พระ​เมสสิยาห์​แล้ว” (​พระ​เมสสิยาห์​แป๋​ว่า​พระคริสต์​) ");
INSERT INTO nod_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","อันดรูว์​ก็​ปา​ซีโมน​ไป​ปะ​พระเยซู บ่ากอง​พระเยซู​หัน​ซีโมน​ก็​อู้​ว่า “ต้าน​คือ​ซีโมน​ลูกบ่าว​ของ​ยอห์น แต่​คน​จะ​ฮ้อง​ต้าน​ว่า เคฟาส” (​คือ​เปโตร ตี้​แป๋​ว่า บ่าหิน​ใหญ่​) ");
INSERT INTO nod_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","แหม​วัน​นึ่ง พระเยซู​ตัดสิน​ใจ๋​จะ​ไป​แคว้น​กาลิลี แล้ว​พระองค์​ก็​ไป​หา​ฟีลิป อู้​กับ​เขา​ว่า “ตวย​เฮา​มา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ฟีลิป​เป๋น​คน​เมือง​เบธไซดา เหมือน​อันดรูว์​กับ​เปโตร ");
INSERT INTO nod_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","แล้ว​ฟีลิป​ก็​ไป​หา​นาธานาเอล แล้ว​บอก​เขา​ว่า “เฮา​ได้​ปะ​คน​นั้น​ตี้​โมเสส​เขียน​เถิง​ใน​บท​บัญญัติ กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ได้​เขียน​เถิง​ต้าน​ไว้​ตวย คือ​เยซู​จาว​เมือง​นาซาเร็ธ​ตี้​เป๋น​ลูกบ่าว​ของ​โยเซฟ” ");
INSERT INTO nod_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","แล้ว​นาธานาเอล​ก็​อู้​ว่า “นาซาเร็ธ​นั่น​หนะ​ก๋า ของ​ดี​อะหยัง​จะ​มา​จาก​เมือง​นาซาเร็ธ​ได้” ฟีลิป​ก็​บอก​ว่า “ตวย​เฮา​มา​ผ่อ​แล่” ");
INSERT INTO nod_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","บ่ากอง​พระองค์​หัน​นาธานาเอล​เตียว​เข้า​มา​หา พระองค์​ก็​อู้​ว่า “นี่​ลอ จาว​อิสราเอล​แต๊﻿ๆ ตี้​บ่﻿ขี้​จุ​เลย” ");
INSERT INTO nod_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","นาธานาเอล​ก็​ถาม​ว่า “ต้าน​ฮู้จัก​เฮา​ได้​จาใด” พระเยซู​ก็​บอก​ว่า “เฮา​หัน​ต้าน​อยู่​ปื๊น​เก๊า​บ่าเดื่อ​ก่อน​ตี้​ฟีลิป​ไป​ฮ้อง​ต้าน​แหม” ");
INSERT INTO nod_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","นาธานาเอล​ก็​บอก​ว่า “อาจ๋ารย์ ต้าน​เป๋น​พระบุตร​ของ​พระเจ้า กับ​เป๋น​กษัตริย์​ของ​จาว​อิสราเอล​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","พระเยซู​ก็​อู้​แหม​ว่า “ตี้​ต้าน​เจื้อ​นี้ ก็​ย้อน​เฮา​บอก​ว่า เฮา​หัน​ต้าน​อยู่​ปื๊น​เก๊า​บ่าเดื่อ​กา แต่​ต้าน​จะ​ได้​หัน​สิ่ง​ตี้​ยิ่งใหญ่​นัก​เหลือ​นี้​แหม” ");
INSERT INTO nod_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","พระองค์​ก็​อู้​ต่อ​แหม​ว่า “เฮา​จะ​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า หมู่​ต้าน​จะ​ได้​หัน​ต๊องฟ้า​เปิด​ออก​เป๋น​ฮ่อม กับ​จะ​หัน​ทูตสวรรค์​ของ​พระเจ้า​ขึ้น﻿ๆ ลง﻿ๆ อยู่​บน​บุตรมนุษย์” ");
INSERT INTO nod_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ใน​วัน​ตี้​สาม มี​งาน​แต่งงาน​ตี้​หมู่​บ้าน​คานา​ใน​แคว้น​กาลิลี แม่​ของ​พระเยซู​ก็​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","พระเยซู​กับ​หมู่​สาวก​ก็​ได้ฮับ​เจิญ​ไป​งาน​นี้​ตวย ");
INSERT INTO nod_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","บ่ากอง​เหล้า​องุ่น​หมด แม่​ของ​พระเยซู​ก็​มา​บอก​พระองค์​ว่า “เหล้า​องุ่น​หมด​แล้ว​เน่อ” ");
INSERT INTO nod_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","พระเยซู​ก็​บอก​ว่า “แม่​เหย มา​บอก​เฮา​เยียะ​หยัง บ่﻿ใจ้​เรื่อง​ของ​เฮา” แล้ว​พระเยซู​ก็​บอก​แหม​ว่า “ยัง​บ่﻿เถิง​เวลา​ของ​เฮา​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","แล้ว​แม่​พระเยซู​ก็​ไป​บอก​คน​ฮับใจ๊​ว่า “เยซู​สั่ง​เยียะ​อะหยัง​ก็​หื้อ​เยียะ​ต๋าม​ตี้​เปิ้น​สั่ง​เน่อ” ");
INSERT INTO nod_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","มี​โอ่ง​หิน​ใส่​น้ำ​ตั้ง​อยู่​หั้น​หก​แก่น แต่​ละ​แก่น​ใส่​น้ำ​ได้​ประมาณ​แปด​สิบ​เถิง​ร้อย​ซาว​ลิตร ไว้​สำหรับ​พิธี​ซ่วย​มือ​ซ่วย​ตี๋น​ก่อน​กิ๋น​ข้าว​ต๋าม​ธรรมเนียม​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","แล้ว​พระเยซู​ก็​มา​บอก​คน​ฮับใจ๊​ว่า “ตัก​น้ำ​ใส่​โอ่ง​หื้อ​เต๋ม​เปียง​ปาก​ตึงหมด​นั้น​เลย” คน​ฮับใจ๊​ก็​เยียะ​ต๋าม​กำสั่ง​ของ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","เสร็จ​แล้ว​พระเยซู​ก็​บอก​ว่า “ตัก​ไป​หื้อ​ป้องาน​เต๊อะ” คน​ฮับใจ๊​ก็​ตัก​น้ำ​ใน​โอ่ง​หิน​นั้น​ไป​หื้อ​ป้องาน​จิม ");
INSERT INTO nod_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","เมื่อ​ป้องาน​ได้​จิม​น้ำ​ตี้​ก๋าย​เป๋น​เหล้า​องุ่น​แล้ว เขา​ก็​สงสัย​ว่า​เหล้า​องุ่น​นี้​มา​จาก​ไหน (​แต่​หมู่​คน​ฮับใจ๊​ตี้​ตัก​น้ำ​นั้น​ฮู้​) แล้ว​ป้องาน​ก็​ฮ้อง​เจ้าบ่าว​มา​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ใผ﻿ๆ ก็​เอา​เหล้า​องุ่น​ดี​ตี้​สุด​มา​หื้อ​แขก​กิ๋น​กั๋น​ก่อน เมื่อ​กิ๋น​ได้​นัก​แล้ว​ก็​ก้อย​เอา​เหล้า​บ่﻿ดี​มา​หื้อ แต่​ต้าน​เก็บ​เหล้า​องุ่น​ตี้​ดี​ตี้​สุด​มา​จ๋น​บ่าเดี่ยว​นี้” ");
INSERT INTO nod_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","นี่​เป๋น​หมายสำคัญ​เตื้อ​แรก​ของ​พระเยซู พระองค์​เยียะ​ตี้​หมู่บ้าน​คานา​ใน​แคว้น​กาลิลี หมู่​สาวก​ก็​ปา​กั๋น​เจื้อ​วางใจ๋​ใน​พระองค์ ย้อน​ได้​หัน​ความ​ยิ่งใหญ่​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","หลังจาก​นั้น​แล้ว​พระองค์​ก็​ไป​เมือง​คาเปอรนาอุม​พร้อม​แม่​กับ​หมู่​น้อง​บ่าว กับ​หมู่​สาวก​ของ​พระองค์ แล้ว​อยู่​ตี้​หั้น​แหม​บ่﻿กี่​วัน ");
INSERT INTO nod_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","เมื่อ​ใก้​เถิง​งาน​ปัสกา​ของ​จาว​ยิว พระเยซู​ก็​เตียว​ตาง​ขึ้น​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ใน​บริเวณ​พระวิหาร พระองค์​ก็​หัน​หมู่​คน​ขาย​งัว ขาย​แกะ​กับ​ขาย​นกก๋าแก๋ ตี้​ไว้​สำหรับ​เป๋น​เครื่องปู่จา คน​แลก​เหรียญ​ก็​นั่ง​อยู่​ตวย​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","พระองค์​ก็​เอา​เจื้อก​แป๋ง​เป๋น​แส้ ไล่​เหิบ​หมู่​เขา​ออก​จาก​พระวิหาร​ตึง​แกะ​ตึง​งัว แล้ว​พระองค์​ก็​ถอก​เหรียญ กับ​ปึ๊ด​โต๊ะ​ของ​คน​แลก​เหรียญ​เหีย​หมด ");
INSERT INTO nod_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","พระองค์​ก็​ว่า​หื้อ​คน​ขาย​นกก๋าแก๋​ว่า “ขน​คัว​ออก​ไป​หื้อ​หมด ห้าม​มา​เยียะ​บ้าน​พระบิดา​ของ​เฮา​หื้อ​ก๋าย​เป๋น​กาด” ");
INSERT INTO nod_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","กำ​นั้น​สาวก​ก็​กึ๊ด​เถิง​กำ​ใน​พระคัมภีร์​ตี้​ว่า “ความ​จงฮัก​ภักดี​ตี้​มี​ต่อ​บ้าน​ของ​พระเจ้า​เยียะ​หื้อ​ตั๋ว​เฮา​วอดวาย​เสี้ยง​หมด” ");
INSERT INTO nod_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","เมื่อ​หมู่​ผู้นำ​จาว​ยิว​หัน​จาอั้น ก็​มา​ว่า​หื้อ​พระองค์​ว่า “ต้าน​มี​สิทธิ์​อะหยัง​มา​เยียะ​จาอี้ แน่​จริง​ก็​เยียะ​ก๋าน​อัศจ๋รรย์​ตี้​แสดง​เถิง​อำนาจ​ของ​ต้าน​หื้อ​ผ่อ​กำ​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","พระเยซู​ก็​ตอบ​ว่า “ตุ๊บ​พระวิหาร​นี้​ขว้าง​เหีย​แล่ แล้ว​เฮา​จะ​แป๋ง​ขึ้น​ใหม่​ใน​สาม​วัน” ");
INSERT INTO nod_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","หมู่​ผู้นำ​จาว​ยิว​ก็​ว่า “พระวิหาร​นี้​ใจ๊​เวลา​แป๋ง​ตึง​สี่​สิบ​หก​ปี๋ แล้ว​ต้าน​จะ​แป๋ง​ใหม่​ใน​สาม​วัน​อั้น​น้อ” ");
INSERT INTO nod_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","แต่​พระวิหาร​ตี้​พระองค์​อู้​เถิง​ก็​คือ​ตั๋ว​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","หลัง​จาก​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว หมู่​สาวก​ก็​จ๋ำ​ได้​ว่า พระองค์​เกย​อู้​จาอี้​ไว้ แล้ว​หมู่​เขา​ก็​เจื้อ​พระคัมภีร์​กับ​เจื้อ​กำ​อู้​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","หละหว่าง​งาน​ปัสกา พระองค์​ก็​อยู่​ตี้​กรุง​เยรูซาเล็ม แล้ว​ก็​มี​แหม​หลาย​คน​มา​เจื้อ​กับ​วางใจ๋​พระองค์ เมื่อ​ได้​หัน​ก๋าน​อัศจ๋รรย์​ตี้​พระองค์​เยียะ ");
INSERT INTO nod_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","แต่​พระองค์​บ่﻿ได้​ไว้​วางใจ๋​ใน​ความ​เจื้อ​ของ​หมู่​เขา​เลย ย้อน​ว่า​พระองค์​ฮู้จัก​กู้​คน​ดี ");
INSERT INTO nod_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","บ่﻿ต้อง​มี​ใผ​มา​บอก​พระองค์​ว่า​ใจ๋​คน​เป๋น​จาใด ย้อน​ว่า​พระองค์​ฮู้​จิตใจ๋​ของ​คน​กู้​คน​ดี ");
INSERT INTO nod_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","มี​ป้อจาย​คน​นึ่ง​จื้อ​นิโคเดมัส เป๋น​สมาชิก​หมู่​ฟาริสี​กับ​เป๋น​ผู้​นำ​จาว​ยิว​คน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","เขา​มา​หา​พระเยซู​ต๋อน​เมื่อคืน อู้​กับ​พระองค์​ว่า “อาจ๋ารย์ หมู่​เฮา​ฮู้​ว่า ต้าน​เป๋น​อาจ๋ารย์​ตี้​มา​จาก​พระเจ้า ย้อน​ว่า​ก๋าน​อัศจ๋รรย์​ตี้​อาจ๋ารย์​เยียะ บ่﻿มี​ใผ​เยียะ​ได้ นอก​จาก​คน​ตี้​พระเจ้า​อยู่​ตวย​เต้าอั้น” ");
INSERT INTO nod_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","พระเยซู​ก็​บอก​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า ใผ​บ่﻿เกิด​ใหม่​ก็​บ่﻿หัน​แผ่นดิน​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","นิโคเดมัส​ก็​ถาม​แหม​ว่า “คน​เฒ่า​แล้ว​จะ​เกิด​ใหม่​ได้​จาใด จะ​หื้อ​มุด​เข้า​ไป​ใน​ต๊อง​แม่ แล้ว​เกิด​ออก​มา​ใหม่​แหม​รอบ​กา” ");
INSERT INTO nod_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","พระเยซู​ก็​ตอบ​แหม​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า ถ้า​ใผ​บ่﻿ได้​เกิด​จาก​น้ำ​กับ​พระวิญญาณ ก็​จะ​เข้า​แผ่นดิน​ของ​พระเจ้า​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","จีวิต​ตาง​เนื้อหนัง​นี้​มา​จาก​ป้อ​แม่​ของ​เฮา แต่​จีวิต​ตาง​ฝ่าย​จิตวิญญาณ​มา​จาก​พระวิญญาณ ");
INSERT INTO nod_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ตี้​เฮา​บอก​ว่า ‘หมู่​ต้าน​จะ​ต้อง​เกิด​ใหม่​นั้น’ ต้าน​บ่﻿ต้อง​งืด​เนาะ ");
INSERT INTO nod_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ลม​ใค่​ปั๊ด​ไป​ตาง​ใด ก็​ปั๊ด​ไป​ตาง​นั้น ต้าน​ได้​ยิน​เสียง​ลม แต่​บ่﻿ฮู้​ว่า​มา​จาก​ไหน กาว่า​จะ​ปั๊ด​ไป​ไหน คน​ตี้​เกิด​จาก​พระวิญญาณ​ก็​จะ​เป๋น​จาอั้น​เน่อ” ");
INSERT INTO nod_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","นิโคเดมัส​ก็​ถาม​แหม​ว่า “มัน​จะ​เป๋น​ไป​ได้​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","พระเยซู​ก็​ตอบ​ว่า “ต้าน​ก็​เป๋น​อาจ๋ารย์​ตี้​จาว​อิสราเอล​นับ​หน้า​ถือ​ต๋า​กั๋น จาใด​ต้าน​บ่﻿เข้าใจ๋​เรื่อง​นี้​แหม ");
INSERT INTO nod_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า หมู่​เฮา​เล่า​เรื่อง​ตี้​หมู่​เฮา​ได้​ฮู้ กับ​เป๋น​พยาน​ใน​สิ่ง​ตี้​ได้​หัน แต่​หมู่​ต้าน​ก็​บ่﻿ยอม​ฮับ​กำ​พยาน​ของ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","นี่​ขนาด​เฮา​อู้​เถิง​เรื่อง​ใน​โลก​นี้ หมู่​ต้าน​ยัง​บ่﻿ยอม​เจื้อ​เลย แล้ว​ถ้า​เฮา​อู้​เถิง​เรื่อง​ใน​สวรรค์​หื้อ​หมู่​ต้าน​ฟัง หมู่​ต้าน​จะ​เจื้อ​เฮา​กา ");
INSERT INTO nod_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","บ่﻿มี​ใผ​เกย​ขึ้น​ไป​บน​สวรรค์ นอก​จาก​คน​ตี้​ลง​มา​จาก​สวรรค์​เต้าอั้น ก็​คือ บุตรมนุษย์ ");
INSERT INTO nod_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","เหมือน​ตี้​โมเสส​ได้​ยก​ไม้เต๊า ตี้​มี​งู​ตองแดง​ขึ้น​ใน​ดินแดน​ทุรกั๋นดาร​จาใด​บุตรมนุษย์​ก็​จะ​ต้อง​ถูก​ยก​ขึ้น​จาอั้น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","เปื้อ​ว่า​กู้​คน​ตี้​เจื้อ​วางใจ๋​ใน​พระองค์​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“ย้อน​ว่า​พระเจ้า​ฮัก​โลก​นี้​นัก​ขนาด จึง​หื้อ​พระบุตร​องค์​เดียว​ของ​พระองค์ เปื้อ​กู้​คน​ตี้​เจื้อ​วางใจ๋​พระบุตร​นั้น​จะ​บ่﻿ฉิบหาย แต่​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ย้อน​ว่า​พระเจ้า​บ่﻿ได้​ส่ง​พระบุตร​เข้า​มา​ใน​โลก​นี้ เปื้อ​ตัดสิน​ลงโต้ษ​คน​ใน​โลก แต่​มา​เปื้อ​จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ ");
INSERT INTO nod_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","คน​ใด​ตี้​เจื้อ​วางใจ๋​พระองค์​นั้น​ก็​บ่﻿ถูก​ลงโต้ษ แต่​คน​ใด​ตี้​บ่﻿เจื้อ​วางใจ๋​พระองค์​ก็​ได้​ถูก​ตัดสิน​ลงโต้ษ​ไป​แล้ว ย้อน​เขา​บ่﻿ได้​เจื้อ​วางใจ๋​พระบุตร​องค์​เดียว​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","นี่​เป๋น​วิธี​ตี้​พระเจ้า​ใจ๊​ตัดสิน คือ ความ​เป่งแจ้ง​ได้​เข้า​มา​ใน​โลก​นี้​แล้ว แต่​คน​ก็​ฮัก​ความ​มืด​นัก​เหลือ​ความ​เป่งแจ้ง ย้อน​ว่า​หมู่​เขา​เยียะ​บาป ");
INSERT INTO nod_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","กู้​คน​ตี้​เยียะ​บาป​ก็​จัง​ความ​เป่งแจ้ง กับ​จะ​บ่﻿เข้า​มา​อยู่​ใน​ตี้​แจ้ง ย้อน​ว่า​หมู่​เขา​กั๋ว​ความ​เป่งแจ้ง​จะ​เปิดเผย​หื้อ​หัน​ความ​บาป​ตี้​เขา​ได้​เยียะ​ออก​มา ");
INSERT INTO nod_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","แต่​คน​ตี้​เยียะ​ต๋าม​ตี้​พระเจ้า​หัน​ว่า​ถูกต้อง ก็​เข้า​มา​ใน​ตี้​แจ้ง เปื้อ​ว่า​ความ​เป่งแจ้ง​จะ​เยียะ​หื้อ​หัน​ว่า สิ่ง​ตี้​เขา​เยียะ​นั้น ก็​ย้อน​เขา​เจื้อฟัง​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","หลัง​จาก​นั้น พระเยซู​กับ​หมู่​สาวก​ก็​ปา​กั๋น​เตียว​ไป​ใน​แคว้น​ยูเดีย แล้ว​ก็​ย้าง​กั๋น​อยู่​ตี้​หั้น กับ​หื้อ​บัพติศมา​กับ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ส่วน​ยอห์น​ก็​ก่ำลัง​หื้อ​บัพติศมา​อยู่​ตี้​หมู่บ้าน​อายโนน​ใก้​หมู่บ้าน​สาลิม ย้อน​ตี้​หั้น​มี​น้ำ​นัก​กับ​คน​ปา​กั๋น​มา​ฮับ​บัพติศมา ");
INSERT INTO nod_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(​เรื่อง​นี้​เกิด​ขึ้น​ก่อน​ตี้​ยอห์น​จะ​โดน​ยับ​ขัง​คอก​) ");
INSERT INTO nod_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","สาวก​ของ​ยอห์น​บาง​คน​เถียง​กับ​จาว​ยิว​คน​นึ่ง​เรื่อง​พิธี​ซ่วย​มือ​ซ่วย​ตี๋น​ก่อน​กิ๋น​ข้าว ");
INSERT INTO nod_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","แล้ว​หมู่​เขา​ก็​ปา​กั๋น​มา​หา​ยอห์น บอก​ยอห์น​ว่า “อาจ๋ารย์​ครับ คน​ตี้​อาจ๋ารย์​เกย​อู้​เถิง ตี้​เกย​อยู่​กับ​อาจ๋ารย์​ฝั่ง​ปู๊น​ของ​แม่น้ำ​จอร์แดน บ่าเดี่ยว​นี้​เขา​ก่ำลัง​หื้อ​บัพติศมา​อยู่ แล้ว​กู้​คน​ก็​ปา​กั๋น​แห่​ไป​หา​เขา​เหีย​หมด” ");
INSERT INTO nod_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ยอห์น​ก็​บอก​ว่า “บ่﻿มี​ใผ​ได้​ฮับ​อะหยัง​นอก​จาก​พระเจ้า​จะ​หื้อ ");
INSERT INTO nod_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","หมู่​ต้าน​ก็​เป๋น​พยาน​ได้​ลอ​ว่า เฮา​เกย​บอก​ว่า ‘เฮา​บ่﻿ใจ้​พระคริสต์ แต่​พระเจ้า​ใจ๊​เฮา​มา​ก่อน​พระองค์’ ");
INSERT INTO nod_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“เจ้าสาว​เป๋น​ของ​เจ้าบ่าว แต่​เปื้อน​เจ้าบ่าว​ตี้​ถ้า​ฟัง​อยู่ ก็​มี​ความ​สุข​เมื่อ​ได้​ยิน​เสียง​เจ้าบ่าว ก็​เหมือน​เฮา​ตี้​มี​ความ​สุข​เมื่อ​ได้​ยิน​เรื่อง​ตี้​เกิด​ขึ้น​กับ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","พระองค์​ต้อง​ยิ่งใหญ่​ขึ้น แล้ว​ตั๋ว​เฮา​ก็​ต้อง​หน้อย​ลง ");
INSERT INTO nod_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“ผู้​ตี้​ลง​มา​จาก​สวรรค์​ก็​เป๋น​ใหญ่​เหลือ​กู้​สิ่ง​กู้​อย่าง ส่วน​คน​ตี้​มา​จาก​โลก​ก็​เป๋น​ของ​โลก อู้​ก้า​เรื่อง​ของ​โลก​เต้าอั้น แต่​ผู้​ตี้​ลง​มา​จาก​สวรรค์​นั้น​เป๋น​ใหญ่​เหลือ​กู้​สิ่ง​กู้​อย่าง ");
INSERT INTO nod_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","พระองค์​เป๋น​พยาน​ใน​สิ่ง​ตี้​พระองค์​ได้​หัน​ได้​ยิน​มา แต่​ก็​บ่﻿มี​ใผ​ยอมฮับ​กำ​พยาน​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ส่วน​คน​ตี้​ยอมฮับ​กำ​พยาน​นั้น ก็​แสดง​ว่า​เขา​เจื้อ​ถ้อยกำ​ของ​พระเจ้า​ว่า​เป๋น​ความ​จริง ");
INSERT INTO nod_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ย้อน​ว่า​ผู้​ตี้​พระเจ้า​ใจ๊​มา​นั้น อู้​กำ​ตี้​มา​จาก​พระเจ้า ย้อน​ว่า​พระเจ้า​หื้อ​พระวิญญาณ​กับ​พระองค์​อย่าง​เต๋ม​ตี้​บ่﻿มี​ขีด​จ๋ำกัด​เลย ");
INSERT INTO nod_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","พระเจ้า​ฮัก​พระบุตร​กับ​หื้อ​พระองค์​ควบคุม​กู้​สิ่ง​กู้​อย่าง ");
INSERT INTO nod_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","คน​ตี้​เจื้อ​วางใจ๋​ใน​พระบุตร​นั้น ก็​มี​จีวิต​นิรันดร์ แต่​คน​ตี้​บ่﻿เจื้อ​ฟัง​พระบุตร​ก็​บ่﻿หัน​จีวิต​นิรันดร์ ป๋าย​บ่﻿ปอ​พระเจ้า​จะ​ลง​โต้ษ​เขา​ตลอด​ไป” ");
INSERT INTO nod_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","พระเยซู​ฮู้​เรื่อง​ตี้​หมู่​ฟาริสี​ได้​ข่าว​ว่า “พระเยซู​มี​สาวก​กับ​หื้อ​บัพติศมา​นัก​เหลือ​ยอห์น” ");
INSERT INTO nod_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(แต๊﻿ๆ พระเยซู​บ่﻿ใจ้​เป๋น​คน​หื้อ​บัพติศมา แต่​สาวก​ของ​พระองค์​เป๋น​คน​เยียะ​หื้อ​) ");
INSERT INTO nod_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","พระองค์​ก็​เลย​ออก​จาก​แคว้น​ยูเดีย ปิ๊ก​ไป​แคว้น​กาลิลี​แหม​เตื้อ ");
INSERT INTO nod_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","แต่​จะ​ต้อง​ก๋าย​ไป​ตาง​แคว้น​สะมาเรีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ใน​แคว้น​สะมาเรีย พระองค์​เตียวตาง​ไป​เถิง​เมือง​สิคาร์​ใก้﻿ๆ กับ​ตี้​ดิน​ของ​ยาโคบ​ตี้​เขา​ได้​หื้อ​กับ​โยเซฟ​ลูกบ่าว​ของ​เขา​ไว้ ");
INSERT INTO nod_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","น้ำบ่อ​ของ​ยาโคบ​อยู่​ตี้​หั้น แล้ว​พระเยซู​เตียว​มา​อิด​แก่ ก็​เลย​นั่ง​ย้าง​ตี้​หั้น ต๋อน​นั้น​เป๋น​เวลา​เตี้ยง​วัน ");
INSERT INTO nod_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","มี​แม่ญิง​จาว​สะมาเรีย​คน​นึ่ง​มา​ตัก​น้ำ​ตี้​น้ำบ่อ​นั้น พระเยซู​ก็​เลย​อู้​กับ​นาง​ว่า “เฮา​ขอ​กิ๋น​น้ำ​หน้อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ต๋อน​นั้น​พระเยซู​อยู่​ตี้​หั้น​คน​เดียว ย้อน​ว่า​หมู่​สาวก​ของ​พระองค์​ออก​ไป​ซื้อ​ของกิ๋น​ใน​เมือง ");
INSERT INTO nod_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","แม่ญิง​จาว​สะมาเรีย​ก็​อู้​ว่า “ต้าน​เป๋น​จาว​ยิว ข้าเจ้า​เป๋น​แม่ญิง​จาว​สะมาเรีย จาใด​ต้าน​มา​ขอ​น้ำ​ข้าเจ้า​กิ๋น” (​เขา​อู้​จาอี้ ย้อน​ว่า​จาว​ยิว​บ่﻿ยุ่ง​เกี่ยว​อะหยัง​กับ​จาว​สะมาเรีย​) ");
INSERT INTO nod_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","พระเยซู​ก็​ตอบ​ว่า “ถ้า​เจ้า​ฮู้​ว่า​พระเจ้า​จะ​หื้อ​อะหยัง​กับ​เจ้า​พ่อง กับ​ฮู้​ว่า​คน​ตี้​ขอ​น้ำ​เจ้า​เป๋น​ใผ เจ้า​ก็​จะ​ขอ​จาก​เขา แล้ว​เขา​คน​นั้น​ก็​จะ​หื้อ​น้ำ​ตี้​หื้อ​จีวิต​กับ​เจ้า” ");
INSERT INTO nod_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","แม่ญิง​คน​นั้น​ก็​ตอบ​ว่า “ต้าน​เจ้า ต้าน​บ่﻿มี​อะหยัง​ตัก​น้ำ​สัก​อย่าง น้ำบ่อ​นี้​ก็​เลิ็ก แล้ว​ต้าน​จะ​เอา​น้ำ​ตี้​หื้อ​จีวิต​นั้น​ลุก​ไหน​มา” ");
INSERT INTO nod_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","“ต้าน​เป๋น​ใหญ่​เหลือ​ยาโคบ ป้อ​อุ๊ย​แม่​หม่อน​ของ​เฮา​ตี้​เป๋น​คน​ขุด​น้ำบ่อ​นี้​กา ตั๋ว​ยาโคบ ลูก﻿ๆ กับ​หมู่​สัตว์​ของ​เขา​ก็​กิ๋น​น้ำ​จาก​บ่อ​นี้​กั๋น​ตึงหมด” ");
INSERT INTO nod_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","พระองค์​ก็​ตอบ​ว่า “กู้​คน​ตี้​กิ๋น​น้ำ​จาก​น้ำบ่อ​นี้​ก็​จะ​อยาก​กิ๋น​น้ำ​แหม ");
INSERT INTO nod_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","แต่​คน​ตี้​ได้​กิ๋น​น้ำ​ตี้​เฮา​จะ​หื้อ ก็​จะ​บ่﻿อยาก​กิ๋น​น้ำ​แหม ย้อน​ว่า​น้ำ​ตี้​เฮา​จะ​หื้อ​นั้น​ก็​ก๋าย​เป๋น​ต๋าน้ำ​ตี้​ไหล​บ่﻿หยุด​ใน​ตั๋ว​เขา กับ​จะ​หื้อ​เขา​มี​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","แม่ญิง​คน​นั้น​ก็​อู้​ว่า “ต้าน​เจ้า ขอ​น้ำ​นี้​หื้อ​กับ​ข้าเจ้า​เต๊อะ ข้าเจ้า​จะ​ได้​บ่﻿อยาก​กิ๋น​น้ำ​แหม กับ​บ่﻿ต้อง​ปิ๊ก​มา​ตัก​น้ำ​ตี้​น้ำบ่อ​นี้​แหม​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","พระองค์​ก็​ตอบ​ว่า “ไป​ฮ้อง​ผัว​ของ​เจ้า​มา​ตี้​นี่​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","แม่ญิง​คน​นั้น​ก็​ตอบ​ว่า “ข้าเจ้า​บ่﻿มี​ผัว” พระองค์​ก็​บอก​ว่า “เออ แม่น​แต๊​ละ ตี้​เจ้า​อู้​มา​ว่า​บ่﻿มี​ผัว ");
INSERT INTO nod_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ย้อน​ว่า​เจ้า​มี​ผัว​มา​แล้ว​ห้า​คน คน​ตี้​อยู่​กิ๋น​ตวย​กั๋น​บ่าเดี่ยว​นี้​ก็​บ่﻿ใจ้​ผัว​ของ​เจ้า ตี้​เจ้า​อู้​มา​ก็​แม่น​แต๊​ละ” ");
INSERT INTO nod_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","แม่ญิง​คน​นั้น​ก็​อู้​ว่า “ต้าน​เจ้า ข้าเจ้า​หัน​แล้ว​ว่า​ต้าน​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","หมู่​ป้อ​อุ๊ย​แม่​หม่อน​ของ​เฮา​ได้​นมัสก๋าน​บน​ดอย​นี้ แต่​หมู่​ต้าน​จาว​ยิว​บอก​ว่า​ตี้​ตี้​ต้อง​นมัสก๋าน​อยู่​กรุง​เยรูซาเล็ม​ปู๊น​ก่อน” ");
INSERT INTO nod_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","พระองค์​ก็​ตอบ​ว่า “หื้อ​เจื้อ​เฮา​เต๊อะ สัก​วัน​นึ่ง คน​ตังหลาย​จะ​บ่﻿นมัสก๋าน​พระบิดา​ก้า​ตี้​กรุง​เยรูซาเล็ม​กาว่า​บน​ดอย​นี้​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","หมู่​จาว​สะมาเรีย​บ่﻿ฮู้จัก​พระเจ้า​ตี้​ตั๋ว​เก่า​นมัสก๋าน แต่​หมู่​เฮา​จาว​ยิว​ฮู้จัก​พระเจ้า​ตี้​เฮา​นมัสก๋าน ย้อน​ว่า​ความ​รอด​ป๊น​บาป​โต้ษ​นั้น​ก็​มา​โดย​ตาง​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","แต่​เวลา​นั้น​ก็​ใก้​มา​แผว​แล้ว บ่าเดี่ยวนี้​ก็​มา​แผว​แล้ว​ตวย ตี้​คน​นมัสก๋าน​พระเจ้า​อย่าง​แต๊​จริง จะ​นมัสก๋าน​พระบิดา​โดย​อำนาจ​ของ​พระวิญญาณ​กับ​นมัสก๋าน​ต๋าม​ความ​จริง พระเจ้า​ตวย​เซาะ​หา​คน​จาอี้​เนาะ​ตี้​จะ​มา​นมัสก๋าน​พระองค์​จาอั้น ");
INSERT INTO nod_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","พระเจ้า​เป๋น​พระวิญญาณ จาอั้น​คน​นมัสก๋าน​ต้อง​นมัสก๋าน​โดย​อำนาจ​ของ​พระวิญญาณ​กับ​นมัสก๋าน​ต๋าม​ความ​จริง” ");
INSERT INTO nod_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","แม่ญิง​คน​นั้น​ก็​อู้​ว่า “ข้าเจ้า​ฮู้​ว่า​พระ​เมสสิยาห์ (​ตี้​ฮ้อง​ว่า​พระคริสต์​) จะ​มา เมื่อ​พระองค์​มา​เถิง ก็​จะ​อธิบาย​กู้​สิ่ง​กู้​อย่าง​หื้อ​เฮา​ฮู้” ");
INSERT INTO nod_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","พระองค์​ก็​ตอบ​ว่า “เฮา​ตี้​ก่ำลัง​อู้​กับ​เจ้า​นี่​ลอ เป๋น​คน​นั้น” ");
INSERT INTO nod_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","แล้ว​ต๋อน​นั้น​หมู่​สาวก​ก็​ปิ๊ก​มา​ปอดี หมู่​เขา​ก็​งืด​ตี้​หัน​พระเยซู​ก่ำลัง​อู้​อยู่​กับ​แม่ญิง แต่​ก็​บ่﻿มี​ใผ​ถาม​พระองค์​ว่า “พระองค์​ใค่​ได้​อะหยัง​จาก​แม่ญิง​คน​นั้น กาว่า เยียะ​หยัง​พระองค์​ไป​อู้​กับ​เขา” ");
INSERT INTO nod_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","แม่ญิง​คน​นั้น​ก็​ละ​น้ำหม้อ แล้ว​ก็​เข้า​ไป​บอก​คน​ใน​เมือง​ว่า ");
INSERT INTO nod_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“มา​ผ่อ​กำ​ลอ ป้อจาย​คน​ตี้​บอก​กู้​สิ่ง​กู้​อย่าง​ตี้​ตั๋ว​ข้าเจ้า​เกย​เยียะ ต้าน​แม่น​พระคริสต์​ละ​ก้า” ");
INSERT INTO nod_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","หมู่​คน​ก็​ปา​กั๋น​ออก​จาก​เมือง​ไป​หา​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","หละหว่าง​นั้น​หมู่​สาวก​ก็​อ้อนวอน​พระองค์​ว่า “อาจ๋ารย์ กิ๋น​อะหยัง​พ่อง​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","แต่​พระองค์​ก็​บอก​ว่า “เฮา​มี​ของกิ๋น​ตี้​หมู่​ต้าน​บ่﻿ฮู้” ");
INSERT INTO nod_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","หมู่​สาวก​ก็​ถาม​กั๋น​ว่า “มี​คน​เอา​ของกิ๋น​มา​หื้อ​อาจ๋ารย์​แล้ว​กา” ");
INSERT INTO nod_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","พระองค์​ก็​บอก​ว่า “ของกิ๋น​ของ​เฮา​ก็​คือ เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​พระเจ้า​ผู้​ตี้​ใจ๊​เฮา​มา กับ​เยียะ​ก๋าน​ของ​พระองค์​หื้อ​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","หมู่​ต้าน​มี​กำ​ตี้​บอก​ว่า ‘กอย​ถ้า​แหม​สี่​เดือน​ก็​จะ​เกี่ยว​ข้าว​ได้​แล้ว’ แต่​เฮา​บอก​ต้าน​ว่า หื้อ​มืน​ต๋า​ผ่อ​โต้ง​หั้น​ลอ บ่าเดี่ยว​นี้​ข้าว​ก็​เหลือง​ฮะ​เหลือง​ฮ่าม พร้อม​เกี่ยว​ได้​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ต๋อน​นี้​คน​เกี่ยว​ก่ำลัง​ฮับ​ก้า​จ้าง กับ​ก่ำลัง​ฮอม​พืช​ผล​นั้น​ไว้​สำหรับ​จีวิต​นิรันดร์ คน​ปูก​กับ​คน​เกี่ยว​ก็​เลย​มี​ความ​สุข​ฮ่วม​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","จาอั้น ก็​เป๋น​ไป​ต๋าม​กำ​ตี้​ว่า ‘คน​นึ่ง​ปูก แหม​คน​นึ่ง​เกี่ยว’ ");
INSERT INTO nod_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","เฮา​ใจ๊​หมู่​ต้าน​ไป​เกี่ยว​ใน​สิ่ง​ตี้​หมู่​ต้าน​บ่﻿ได้​ใจ๊​แฮง​เยียะ แต่​คน​อื่น​ได้​ใจ๊​แฮง​เยียะ​เอา​ไว้ แล้ว​หมู่​ต้าน​ก็​ได้​ฮับ​ประโยชน์​จาก​แฮง​ของ​เขา” ");
INSERT INTO nod_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","จาก​กำ​พยาน​ของ​แม่ญิง​คน​นั้น ตี้​ว่า “ป้อจาย​คน​นี้​บอก​กู้​สิ่ง​กู้​อย่าง​ตี้​ตั๋ว​ข้าเจ้า​เกย​เยียะ” ก็​เยียะ​หื้อ​จาว​สะมาเรีย​หลาย​คน​ใน​เมือง​นั้น​เจื้อ​วางใจ๋​ใน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","เมื่อ​จาว​สะมาเรีย​มา​หา​พระองค์ หมู่​เขา​ได้​ฮ้อง​ขอ​หื้อ​พระองค์​ย้าง​อยู่​กับ​หมู่​เขา แล้ว​พระองค์​ก็​ย้าง​อยู่​ตี้​หั้น​แหม​สอง​วัน ");
INSERT INTO nod_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","กำ​อู้​ของ​พระองค์​ก็​เยียะ​หื้อ​คน​แหม​หลาย​คน​มา​เจื้อ​วางใจ๋​ใน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","แล้ว​จาว​เมือง​ก็​บอก​แม่ญิง​คน​นั้น​ว่า “ตั้งแต่​นี้ หมู่​เฮา​เจื้อ​วางใจ๋​พระเยซู​บ่﻿ใจ้​ย้อน​กำ​พยาน​ของ​เจ้า​อย่าง​เดียว แต่​ย้อน​ว่า​หมู่​เฮา​ได้​ยิน​กับ​หู และ​ได้​ฮู้​ว่า​ต้าน​คน​นี้​เป๋น​พระ​ผู้​จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ​ของ​โลก​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","หลัง​จาก​ย้าง​อยู่​แคว้น​สะมาเรีย​สอง​วัน พระเยซู​ก็​เตียว​ตาง​ไป​แคว้น​กาลิลี​ต่อ ");
INSERT INTO nod_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(​พระองค์​เกย​อู้​ไว้​ว่า ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​จะ​บ่﻿ได้ฮับ​เกียรติ​ตี้​บ้าน​เมือง​ของ​ตั๋ว​เก่า​) ");
INSERT INTO nod_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","เมื่อ​พระองค์​มา​แผว​แคว้น​กาลิลี จาว​กาลิลี​ก็​มา​ต้อนฮับ​พระองค์ ย้อน​ว่า​หมู่​เขา​ได้​ไป​ฮ่วม​งาน​ปัสกา​ตี้​กรุง​เยรูซาเล็ม กับ​ได้​หัน​กู้​สิ่ง​กู้​อย่าง​ตี้​พระเยซู​เยียะ​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","พระเยซู​ก็​ปิ๊ก​ไป​หมู่บ้าน​คานา​ใน​แคว้น​กาลิลี​แหม​เตื้อ​นึ่ง ตี้​หั้น​เป๋น​หมู่บ้าน​ตี้​พระองค์​เกย​เปี่ยน​น้ำ​หื้อ​เป๋น​เหล้า​องุ่น ตี้​หั้น​มี​ข้าราชก๋าน​คน​นึ่ง ลูกบ่าว​ของ​เขา​อยู่​ตี้​เมือง​คาเปอรนาอุม บ่﻿สบาย​หนัก ");
INSERT INTO nod_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","เมื่อ​ข้าราชก๋าน​คน​นั้น​ได้​ยิน​ว่า​พระเยซู​ลุก​จาก​แคว้น​ยูเดีย​มา​แคว้น​กาลิลี เขา​ก็​ฟั่ง​ไป​อ้อนวอน​ขอ​หื้อ​พระองค์​มา​ฮักษา​ลูกบ่าว​ของ​เขา​ตี้​ก่ำลัง​จะ​ต๋าย​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","พระเยซู​ก็​อู้​กับ​เขา​ว่า “ถ้า​หมู่​ต้าน​บ่﻿หัน​หมายสำคัญ​กับ​ก๋าน​อัศจ๋รรย์​เหีย​ก่อน ก็​จะ​บ่﻿เจื้อ​วางใจ๋​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ข้าราชก๋าน​คน​นั้น​ก็​บอก​พระองค์​ว่า “ต้าน​ครับ ขอ​ไป​จ้วย​ลูก​เฮา​ก่อน​ตี้​เขา​จะ​ต๋าย​กำ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","พระเยซู​ก็​บอก​ว่า “ปิ๊ก​เมือ​บ้าน​เหีย ลูกบ่าว​ต้าน​จะ​หาย” เขา​ก็​เจื้อ​กำ​อู้​ของ​พระองค์ แล้ว​ก็​ปิ๊ก​บ้าน​ไป ");
INSERT INTO nod_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ใน​หละหว่าง​ตาง​ตี้​เขา​ปิ๊ก​นั้น เขา​ก็​ปะ​กับ​หมู่​คน​ฮับใจ๊ หมู่​เขา​มา​ส่ง​ข่าว​ว่า “ลูกบ่าว​ต้าน​ยังแควน​ขึ้น​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","เขา​ก็​ถาม​คน​ฮับใจ๊​ว่า “ยังแควน​ตั้งแต่​เมื่อ​ใด​ละ” คนใจ๊​ก็​บอก​ว่า “ไข้​ซว่าง​ตั้งแต่​บ่าย​โมง​ตะวา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ป้อ​คน​นั้น​ก็​เข้าใจ๋​ว่า​เป๋น​เวลา​ตี้​พระเยซู​อู้​ว่า “ลูกบ่าว​ต้าน​จะ​หาย” ย้อน​จาอั้น ตั๋ว​เขา​กับ​กู้​คน​ใน​ครอบครัว​ก็​มา​เจื้อ​วางใจ๋​ใน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","นี่​เป๋น​หมายสำคัญ​เตื้อ​ตี้​สอง​ตี้​พระเยซู​เยียะ ตั้งแต่​ออก​จาก​แคว้น​ยูเดีย​มา​แคว้น​กาลิลี ");
INSERT INTO nod_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","หลัง​จาก​นั้น พระเยซู​ก็​เตียว​ขึ้น​ไป​ตี้​กรุง​เยรูซาเล็ม เปื้อ​ไป​ฮ่วม​งาน​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ใน​กรุง​เยรูซาเล็ม​มี​สระน้ำ​อยู่​ใก้﻿ๆ ปะตู๋​ตี้​จื้อ​ว่า ปะตู๋​แกะ ภาษา​ฮีบรู​ฮ้อง​ว่า “เบธซาธา” ตี้​หั้น​มี​ศาลา​ห้า​หลัง ");
INSERT INTO nod_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","แล้ว​ก็​มี​คน​เจ็บ​คน​ป่วย​นัก​ขนาด​ตี้​นอน​อยู่​ใน​ศาลา​ต่าง﻿ๆ นั้น​คือ คน​ต๋าบอด คน​เป๋น​ง่อย กับ​คน​เป๋น​อัมพาต ");
INSERT INTO nod_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ตี้​หั้น​มี​ป้อจาย​คน​นึ่ง บ่﻿สบาย​ได้​สาม​สิบ​แปด​ปี๋​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","เมื่อ​พระเยซู​หัน​เขา​นอน​อยู่​ตี้​หั้น พระเยซู​ก็​ฮู้​ว่า​ป้อจาย​คน​นี้​บ่﻿สบาย​มา​เมิน พระองค์​ก็​เลย​อู้​กับ​เขา​ว่า “ใค่​อยาก​หาย​ก่อ” ");
INSERT INTO nod_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ป้อจาย​คน​นี้​ก็​ตอบ​ว่า “ต้าน​ครับ เมื่อ​น้ำ​เป๋น​คลื่น ก็​บ่﻿มี​ใผ​จ้วย​เอา​เฮา​ลง​ไป​สัก​คน ต๋อน​เฮา​กั๊น​จะ​ลง คน​อื่น​ก็​ลู่​ลง​ไป​เหีย​ก่อน​กู้​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","พระเยซู​ก็​เลย​ตอบ​ว่า “ลุก​ขึ้น แล้ว​แบก​ตี้นอน​ของ​เจ้า​เตียว​ไป​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ป้อจาย​คน​นี้​ก็​หาย​บ่า​เดี่ยว​นั้น​เลย แล้ว​แบก​ตี้นอน​เตียว​ไป วัน​ตี้​เรื่อง​นี้​เกิด​ขึ้น​เป๋น​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ผู้นำ​จาว​ยิว​ก็​อู้​กับ​ป้อจาย​คน​ตี้​หาย​ว่า “ตี้​ต้าน​แบก​ตี้นอน​เตียว​ไป​เตียว​มา​ใน​วัน​สะบาโต ฮู้​ก่อ มัน​ผิด​บท​บัญญัติ” ");
INSERT INTO nod_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ป้อจาย​คน​นั้น​ก็​ตอบ​ว่า “คน​ตี้​ฮักษา​เฮา​บอก​หื้อ​เก็บ​ตี้นอน​เตียว​ไป​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","หมู่​ผู้นำ​จาว​ยิว​ถาม​แหม​กำ​ว่า “ใผ​เป๋น​คน​อู้​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","แต่​ป้อจาย​คน​นั้น​บ่﻿ฮู้​ว่า​คน​ตี้​ฮักษา​เขา​จื้อ​อะหยัง ย้อน​พระเยซู​เตียว​หาย​เข้า​ไป​ใน​หมู่​คน​ตี้​อยู่​ตี้​หั้น​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","หลังจาก​นั้น พระเยซู​ก็​ปะ​เขา​แหม​เตื้อ​ใน​พระวิหาร พระองค์​ก็​อู้​กับ​เขา​ว่า “ต๋อน​นี้​ต้าน​ก็​หาย​ดี​แล้ว หื้อ​ย้าง​เยียะ​บาป​เหีย เปื้อ​บ่﻿หื้อ​ความ​ตุ๊ก​นัก​เหลือ​นี้​เกิด​ขึ้น​กับ​ต้าน​แหม” ");
INSERT INTO nod_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","แล้ว​ป้อจาย​คน​นั้น​ก็​ไป​บอก​หมู่​ผู้นำ​จาว​ยิว​ว่า​พระเยซู​เป๋น​คน​ฮักษา​เขา​หื้อ​หาย ");
INSERT INTO nod_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","จาอั้น​หมู่​ผู้นำ​จาว​ยิว​ก็​ตั้งเก๊า​ค่ำ​พระองค์ ย้อน​ว่า​พระองค์​เยียะ​สิ่ง​หมู่​นี้​ใน​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","พระเยซู​ก็​บอก​ว่า “พระบิดา​ของ​เฮา​เยียะ​ก๋าน​อยู่​ตลอด แล้ว​เฮา​ต้อง​เยียะ​ก๋าน​ตลอด​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ย้อน​จาอี้ หมู่​ผู้นำ​จาว​ยิว​ก็​ซ้ำ​กึ๊ด​จะ​ฆ่า​พระองค์ ย้อน​พระองค์​บ่﻿ได้​ย้าง​เยียะ​ก๋าน​ใน​วัน​สะบาโต ป๋าย​บ่﻿ปอ​พระองค์​ยัง​ฮ้อง​พระเจ้า​ว่า​เป๋น​พระบิดา​ของ​ตั๋ว​เก่า​แหม ก็​เต้า​กับ​เป๋น​ก๋าน​ยก​ตั๋ว​เก่า​เต้า​กับ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","พระเยซู​บอก​กับ​หมู่​ผู้นำ​จาว​ยิว​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า พระบุตร​เยียะ​ต๋าม​ใจ๋​ตั๋ว​เก่า​บ่﻿ได้ พระองค์​เยียะ​ได้​ก้า​สิ่ง​ตี้​หัน​พระบิดา​เยียะ​เต้าอั้น ย้อน​ว่า​อะหยัง​ตี้​พระบิดา​เยียะ พระบุตร​ก็​เยียะ​ตวย ");
INSERT INTO nod_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ย้อน​ว่า​พระบิดา​ฮัก​พระบุตร เลย​หื้อ​พระบุตร​หัน​กู้​สิ่ง​กู้​อย่าง​ตี้​พระบิดา​เยียะ แล้ว​พระองค์​จะ​หื้อ​พระบุตร​หัน​สิ่ง​ตี้​ยิ่งใหญ่​นัก​เหลือ​นี้​แหม เป๋น​สิ่ง​ตี้​พระบุตร​จะ​เยียะ แล้ว​หมู่​ต้าน​ก็​จะ​งืด ");
INSERT INTO nod_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","เหมือน​กับ​ตี้​พระบิดา​เยียะ​หื้อ​คน​ต๋าย​แล้ว​เป๋น​ขึ้น​จาก​ความ​ต๋าย พระบุตร​ก็​จะ​หื้อ​จีวิต​กับ​ใผ​ก็​ได้​ตี้​พระองค์​ใค่​โผด​หื้อ​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","พระบิดา​บ่﻿ตัดสิน​ใผ แต่​พระองค์​มอบ​สิทธิ​อำนาจ​ตึงหมด​ใน​ก๋าน​ตัดสิน​หื้อ​พระบุตร ");
INSERT INTO nod_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","เปื้อ​หมู่​คน​ตึง​หมด​จะ​หื้อ​เกียรติ​พระบุตร​เหมือน​ตี้​หมู่​เขา​หื้อ​เกียรติ​พระบิดา คน​ตี้​บ่﻿หื้อ​เกียรติ​พระบุตร หมู่​เขา​ก็​บ่﻿หื้อ​เกียรติ​พระบิดา​ผู้​ตี้​ใจ๊​พระบุตร​มา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ตี้​ฟัง​กำ​เฮา​และ​เจื้อ​วางใจ๋​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา เขา​ก็​มี​จีวิต​นิรันดร์ กับ​จะ​บ่﻿ถูก​ตัดสิน​ลงโต้ษ ย้อน​ว่า​เขา​ได้​ป๊น​จาก​ความ​ต๋าย ไป​มี​จีวิต​นิรันดร์​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เวลา​นั้น​ก็​ใก้​มา​แผว บ่าเดี่ยวนี้​ก็​มา​แผว​แล้ว​ตวย​ตี้​คน​ต๋าย​จะ​ได้​ยิน​เสียง​พระบุตร​ของ​พระเจ้า คน​ตี้​ได้​ยิน​แล้ว​เจื้อฟัง ก็​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","พระบิดา​เป๋น​บ่อเกิด​ของ​จีวิต​ตึงหมด กับ​ได้​หื้อ​พระบุตร​ของ​พระองค์​เป๋น​บ่อเกิด​ของ​จีวิต​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","พระบิดา​มอบ​สิทธิ​อำนาจ​ตี้​จะ​เป๋น​ผู้​ตัดสิน​ลงโต้ษ​หื้อ​พระบุตร​ของ​พระองค์ ย้อน​ว่า​พระบุตร​ก็​เป๋น​บุตรมนุษย์​ตวย ");
INSERT INTO nod_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","หมู่​ต้าน​บ่﻿ต้อง​งืด​ใน​เรื่อง​นี้ ย้อน​ว่า​เวลา​ใก้​จะ​มา​แผว​แล้ว​ตี้​คน​ต๋าย​จะ​ได้ยิน​เสียง​บุตรมนุษย์ ");
INSERT INTO nod_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","แล้ว​ปา​กั๋น​ออก​มา​จาก​อุโมงค์​ฝังศพ คน​ตี้​เยียะ​ดี​ก็​เป๋น​ขึ้น​มา​เปื้อ​ฮับ​จีวิต​นิรันดร์ คน​ตี้​เยียะ​บ่﻿ดี​ก็​จะ​เป๋น​ขึ้น​มา​เปื้อ​ถูก​ตัดสิน​ลงโต้ษ ");
INSERT INTO nod_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“เฮา​จะ​เยียะ​อะหยัง​ต๋าม​ใจ๋​ตั๋ว​เก่า​บ่﻿ได้ พระเจ้า​สั่ง​จาใด เฮา​ก็​ตัดสิน​ไป​จาอั้น แล้ว​กำ​ตัดสิน​ของ​เฮา​ก็​ยุติธรรม ย้อน​ว่า​เฮา​เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​ผู้​ตี้​ใจ๊​เฮา​มา บ่﻿ใจ้​ต๋าม​ใจ๋​ของ​ตั๋ว​เก่า ");
INSERT INTO nod_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ถ้า​เฮา​เป๋น​พยาน​หื้อ​ตั๋ว​เก่า กำ​พยาน​ของ​เฮา​ก็​เจื้อถือ​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","แต่​เฮา​มี​ผู้​นึ่ง​เป๋น​พยาน​หื้อ​เฮา เฮา​ฮู้​ว่า​กำ​พยาน​ของ​พระองค์​เรื่อง​เฮา​นั้น​เป๋น​ความ​จริง ");
INSERT INTO nod_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“หมู่​ต้าน​ได้​ส่ง​คน​ไป​หา​ยอห์น แล้ว​ยอห์น​ก็​ได้​อู้​กำ​พยาน​เรื่อง​เฮา​ตี้​เป๋น​ความ​จริง ");
INSERT INTO nod_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ตี้​เฮา​อู้​จาอี้​บ่﻿ใจ้​ว่า​เฮา​ต้อง​หื้อ​คน​มา​เป๋น​พยาน​หื้อ แต่​เปื้อ​จ้วย​หื้อ​หมู่​ต้าน​เจื้อ​เฮา แล้ว​รอด​ป๊น​บาป​โต้ษ ");
INSERT INTO nod_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ยอห์น​เป๋น​เหมือน​โกม​ไฟ​ตี้​ต๋าม​ส่อง​แสง หมู่​ต้าน​ปอใจ๋​ตี้​จะ​ฮับ​แสง​ของ​ยอห์น แล้ว​จื้นจม​ยินดี​กับ​แสง​นั้น​ได้​กำ​นึ่ง ");
INSERT INTO nod_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“แต่​เฮา​มี​กำ​พยาน​ตี้​ยิ่งใหญ่​นัก​เหลือ​กำ​พยาน​ของ​ยอห์น ย้อน​ว่า​ก๋าน​ตี้​พระบิดา​มอบ​หื้อ​เฮา​เยียะ​จ๋น​แล้ว คือ​กำ​สั่ง​สอน​กับ​หมายสำคัญ​ตี้​เฮา​ก่ำลัง​เยียะ​อยู่ ก๋าน​นี้​เป๋น​พยาน​หื้อ​เฮา​ว่า​พระบิดา​เป๋น​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","พระบิดา​ผู้​ตี้​ใจ๊​เฮา​มา​ก็​เป๋น​พยาน​หื้อ​เฮา​ตวย หมู่​ต้าน​บ่﻿เกย​ได้​ยิน​เสียง บ่﻿เกย​หัน​ฮูปฮ่าง​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","กำ​อู้​ของ​พระองค์​ก็​บ่﻿อยู่​ใน​ใจ๋​ของ​หมู่​ต้าน ย้อน​ว่า​หมู่​ต้าน​บ่﻿เจื้อ​วางใจ๋​ผู้​ตี้​พระบิดา​ส่ง​มา ");
INSERT INTO nod_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","หมู่​ต้าน​ตั้งใจ๋​ฮ่ำเฮียน​พระคัมภีร์ ย้อน​กึ๊ด​ว่า​หมู่​ต้าน​จะ​ปะ​ตาง​ตี้​จะ​ได้ฮับ​จีวิต​นิรันดร์​ใน​นั้น พระคัมภีร์​นี้​ละ​มี​กำ​เขียน​เถิง​เฮา ");
INSERT INTO nod_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","แต่​หมู่​ต้าน​ก็​บ่﻿ยอม​มา​หา​เฮา​เปื้อ​ฮับ​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“เฮา​บ่﻿สนใจ๋​กำ​ยกย่อง​ของ​คน ");
INSERT INTO nod_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ย้อน​เฮา​ฮู้จัก​หมู่​ต้าน​กับ​ฮู้​ว่า​ใน​ใจ๋​หมู่​ต้าน​บ่﻿ได้​ฮัก​พระเจ้า​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","เฮา​มา​ใน​นาม​ของ​พระบิดา หมู่​ต้าน​ก็​บ่﻿ยอม​ฮับ​เฮา แต่​ถ้า​มี​คน​มา​อู้​ใน​นาม​ตั๋ว​เก่า หมู่​ต้าน​ก็​จะ​ยอม​ฮับ​เขา​เหีย ");
INSERT INTO nod_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","หมู่​ต้าน​จะ​เจื้อ​เฮา​ได้​จาใด ย้อน​หมู่​ต้าน​ซอบ​ยกย่อง​กั๋น แต่​บ่﻿สนใจ๋​เซาะ​หา​กำ​ยกย่อง​ตี้​มา​จาก​พระเจ้า​องค์​เดียว ");
INSERT INTO nod_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","บ่﻿ต้อง​กึ๊ด​ว่า​เฮา​จะ​ฟ้อง​หมู่​ต้าน​ต่อหน้า​พระบิดา หมู่​ต้าน​หวัง​จะ​รอด​ป๊น​บาป​โต้ษ​โดย​เจื้อ​ฟัง​บท​บัญญัติ​ของ​โมเสส แต่​โมเสส​คน​เนียะ จะ​เป๋น​คน​ฟ้อง​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ถ้า​หมู่​ต้าน​เจื้อ​โมเสส​แต๊﻿ๆ ต้าน​ก็​จะ​เจื้อ​เฮา​ตวย ย้อน​โมเสส​ได้​เขียน​เถิง​ตั๋ว​เฮา ");
INSERT INTO nod_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","แต่​ถ้า​ต้าน​บ่﻿เจื้อ​ใน​สิ่ง​ตี้​โมเสส​เขียน​แล้ว ต้าน​จะ​เจื้อ​กำ​อู้​ของ​เฮา​ได้​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","หลังจาก​นั้น​พระเยซู​ก็​ข้าม​ไป​แหม​เผิก​นึ่ง​ของ​ทะเลสาบ​กาลิลี (​มี​แหม​จื้อ​ว่า ทะเลสาบ​ทิเบเรียส​) ");
INSERT INTO nod_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","มี​คน​นัก​ขนาด​ตวย​พระองค์​ไป ย้อน​ว่า​หมู่​เขา​ได้​หัน​หมายสำคัญ​ตี้​พระองค์​ได้​ฮักษา​คน​บ่﻿สบาย ");
INSERT INTO nod_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","ต๋อน​นั้น​ใก้​จะ​เถิง​งาน​ปัสกา​ของ​จาว​ยิว พระองค์​ได้​เตียว​ขึ้น​ไป​บน​ดอย แล้ว​นั่ง​อยู่​กับ​หมู่​สาวก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","เมื่อ​พระองค์​เหงย​หน้า​ขึ้น​มา ก็​หัน​หมู่​คน​เป๋น​จ๋ำนวน​นัก​ปา​กั๋น​มา​หา พระองค์​ก็​อู้​กับ​ฟีลิป​ว่า “เฮา​จะ​ซื้อ​ของกิ๋น​ตี้​ไหน​เถิง​จะ​ปอ​เลี้ยง​คน​ตึงหมด​นี้” ");
INSERT INTO nod_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(​พระองค์​ถาม​เปื้อ​ลองใจ๋​ฟีลิป แต๊﻿ๆ แล้ว​พระองค์​ฮู้​ว่า​จะ​เยียะ​จาใด​) ");
INSERT INTO nod_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ฟีลิป​ก็​บอก​ว่า “ก้าจ้าง​สอง​ร้อย​วัน ยัง​บ่﻿ปอ​ซื้อ​ของ​กิ๋น​หื้อ​หมู่​เขา​กิ๋น​กั๋น​คน​ละ​หน้อย​เลย” ");
INSERT INTO nod_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","สาวก​แหม​คน​นึ่ง​ของ​พระองค์​จื้อ​อันดรูว์ น้องบ่าว​ซีโมน​เปโตร​บอก​ว่า ");
INSERT INTO nod_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“มี​หละอ่อน​ป้อจาย​คน​นึ่ง เขา​มี​เข้าหนมปัง​บาร์เลย์​ห้า​ก้อน​กับ​ป๋า​แหม​สอง​ตั๋ว แต่​มอกอี้​ตึง​บ่﻿ปอ​เลี้ยง​คน​ตึงหมด” ");
INSERT INTO nod_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ตี้​หั้น​มี​หญ้า​เปียง​อยู่ พระเยซู​ก็​เลย​อู้​กับ​หมู่​สาวก​ว่า “บอก​หื้อ​หมู่​เขา​นั่ง​ลง” แล้ว​กู้​คน​ก็​ปา​กั๋น​นั่ง​ลง (​นับ​ก้า​ป้อจาย​ได้​ประมาณ​ห้า​ปัน​คน​) ");
INSERT INTO nod_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","แล้ว​พระเยซู​ก็​เอา​เข้าหนมปัง​มา เมื่อ​อธิษฐาน​ขอบคุณ​พระเจ้า​แล้ว พระองค์​ก็​หัก​แจก​หื้อ​กู้​คน​ตี้​นั่ง​อยู่​กิ๋น​กั๋น​เต๋ม​ตี้ แล้ว​พระองค์​ก็​เอา​ป๋า​มา​เยียะ​อย่าง​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","หลัง​จาก​กู้​คน​กิ๋น​อิ่ม​แล้ว พระองค์​ก็​บอก​หมู่​สาวก​ว่า “เก็บ​เข้าหนมปัง​ตี้​เหลือ​มา​หื้อ​หมด จะ​ได้​บ่﻿เสีย​ของ” ");
INSERT INTO nod_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","แล้ว​หมู่​สาวก​ก็​ไป​เก็บ​ตี้​เหลือ​ตี้​มา​จาก​เข้าหนมปัง​บาร์เลย์​ห้า​ก้อน​นั้น​ได้​สิบ​สอง​ซ้า​เต๋ม﻿ๆ ");
INSERT INTO nod_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","คน​ตังหลาย​เมื่อ​หัน​หมายสำคัญ​ตี้​พระองค์​เยียะ ก็​ปา​กั๋น​อู้​ว่า “คน​นี้​ต้อง​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​นั้น​ตี้​ว่า​กั๋น​ว่า​จะ​เข้า​มา​ใน​โลก​นี้ แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","พระเยซู​ฮู้​ว่า​หมู่​เขา​จะ​ค่ำเข​หื้อ​พระองค์​ไป​เป๋น​กษัตริย์​ของ​หมู่​เขา พระองค์​ก็​เลย​ลัก​ขึ้น​ไป​บน​ดอย​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ตก​เมื่อแลง​มา หมู่​สาวก​ของ​พระองค์​ก็​ไป​ตี้​ทะเลสาบ ");
INSERT INTO nod_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","แล้ว​ลง​เฮือ​ข้าม​ฟาก​ไป​เมือง​คาเปอรนาอุม ย้อน​ว่า​ต๋อน​นั้น​มืด​แล้ว แต่​พระเยซู​ก็​ยัง​บ่﻿มา​หา​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","แล้ว​ลมหลวง​ก็​ปั๊ด​มา เยียะ​หื้อ​ทะเลสาบ​มี​คลื่น​แฮง​ขนาด ");
INSERT INTO nod_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","เมื่อ​เฮือ​ออก​จาก​ฝั่ง​มา​ได้​สัก​ห้า หก​กิโลเมตร หมู่​สาวก​ก็​หัน​พระเยซู​ก่ำลัง​เตียว​มา​บน​น้ำ​เข้า​มา​ใก้​เฮือ หมู่​เขา​ก็​ปา​กั๋น​กั๋ว​ขนาด ");
INSERT INTO nod_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","พระเยซู​ก็​บอก​ว่า “นี่​เฮา​เน่อ บ่﻿ถ้า​กั๋ว” ");
INSERT INTO nod_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","แล้ว หมู่​เขา​ก็​เต๋ม​ใจ๋​ฮับ​พระองค์​ขึ้น​เฮือ แล้ว​เฮือ​ก็​เถิง​ฝั่ง​ตี้​เขา​จะ​ไป​ปอ​ดี ");
INSERT INTO nod_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ตก​แหม​วัน คน​จ๋ำนวน​นัก​ตี้​ยัง​อยู่​แหม​เผิก​นึ่ง หัน​ว่า​วัน​ก่อน​หน้า​นั้น​ตี้​หั้น​มี​เฮือ​ก้า​ลำ​เดียว กับ​ฮู้​ว่า​หมู่​สาวก​เต้าอั้น​ตี้​ลง​เฮือ​ลำ​นั้น​ไป แต่​พระเยซู​บ่﻿ได้​ลง​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","แล้ว​มี​เฮือ​ลำ​อื่น​ตี้​ลุก​มา​จาก​เมือง​ทิเบเรียส เข้า​มา​จอด​ฝั่ง​ใก้﻿ๆ ตี้​หมู่​เขา​ได้​กิ๋น​เข้าหนมปัง​หลัง​จาก​พระเยซู​อธิษฐาน​ขอบคุณ​พระเจ้า​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","บ่ากอง​หมู่​เขา​หัน​ว่า​พระเยซู​ตึง​หมู่​สาวก​บ่﻿อยู่​ตี้​หั้น ก็​ปา​กั๋น​ลง​เฮือ​ลำ​นั้น​ไป​ตวย​เซาะหา​พระองค์​ตี้​เมือง​คาเปอรนาอุม ");
INSERT INTO nod_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","เมื่อ​หมู่​เขา​ปะ​พระเยซู​แหม​เผิก​นึ่ง​ของ​ทะเลสาบ หมู่​เขา​ก็​ถาม​พระองค์​ว่า “อาจ๋ารย์​ต้าน​มา​เมื่อ​ใด​ละ” ");
INSERT INTO nod_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","พระเยซู​ก็​ตอบ​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ตี้​หมู่​ต้าน​ตวย​เซาะ​หา​เฮา บ่﻿ใจ้​ว่า​หมู่​ต้าน​เข้าใจ๋​หมายสำคัญ​ตี้​หมู่​ต้าน​หัน แต่​ย้อน​ว่า​ได้​กิ๋น​เข้าหนมปัง​จ๋น​อิ่ม​บ่﻿ดาย ");
INSERT INTO nod_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","บ่﻿ถ้า​เยียะ​ก๋าน​เปื้อ​ของกิ๋น​ตี้​เน่า​บูด​ได้ แต่​หื้อ​เยียะ​ก๋าน เปื้อ​ของ​กิ๋น​ตี้​อยู่​ได้​จ๋น​เถิง​จีวิต​นิรันดร์ บุตรมนุษย์​จะ​เป๋น​คน​หื้อ​ของกิ๋น​นั้น​กับ​หมู่​ต้าน ย้อน​ว่า​พระเจ้า​พระบิดา​หื้อ​สิทธิ​อำนาจ​กับ​บุตรมนุษย์​ตี้​จะ​เยียะ​จาอี้​ได้” ");
INSERT INTO nod_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","แล้ว​หมู่​เขา​ก็​ถาม​แหม​ว่า “หมู่​เฮา​ต้อง​เยียะ​อะหยัง เถิง​จะ​เยียะ​หื้อ​พระเจ้า​ปอใจ๋” ");
INSERT INTO nod_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","พระเยซู​ก็​ตอบ​ว่า “สิ่ง​ตี้​พระเจ้า​ใค่​หื้อ​เยียะ​ก็​คือ​เจื้อ​วางใจ๋​ผู้​ตี้​พระองค์​ใจ๊​มา” ");
INSERT INTO nod_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","หมู่​เขา​ก็​ถาม​แหม​ว่า “ถ้า​จาอั้น ต้าน​จะ​เยียะ​หมายสำคัญ​อะหยัง​เปื้อ​เฮา​จะ​ได้​หัน​และ​เจื้อ​วางใจ๋​ต้าน​ได้ ต้าน​จะ​เยียะ​อะหยัง​พ่อง ");
INSERT INTO nod_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ป้อ​อุ๊ย​แม่​หม่อน​ของ​เฮา​ได้​กิ๋น​มานา​ ใน​ดินแดน​ทุรกั๋นดาร​อย่าง​ตี้​มี​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘ต้าน​ได้​หื้อ​ของ​กิ๋น​จาก​สวรรค์’ ” ");
INSERT INTO nod_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","พระเยซู​ก็​ตอบ​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า บ่﻿ใจ้​โมเสส​ตี้​หื้อ​ของกิ๋น​จาก​สวรรค์​นั้น​กับ​ต้าน แต่​เป๋น​พระบิดา​ของ​เฮา​ตี้​หื้อ​ของกิ๋น​ตี้​แต๊​จริง​จาก​สวรรค์​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ย้อน​ว่า​ของกิ๋น​ตี้​พระเจ้า​หื้อ​นั้น​ก็​คือ​ผู้​ตี้​ลง​มา​จาก​สวรรค์ แล้ว​หื้อ​จีวิต​กับ​โลก​นี้” ");
INSERT INTO nod_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","หมู่​เขา​ก็​อู้​ว่า “ต้าน​ครับ ต่อไป​นี้​ขอ​ของกิ๋น​นั้น​หื้อ​หมู่​เฮา​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","พระเยซู​ก็​อู้​ว่า “เฮา​เป๋น​ของกิ๋น​ตี้​หื้อ​จีวิต คน​ตี้​มา​หา​เฮา​ก็​จะ​บ่﻿อยาก​กิ๋น​ข้าว​แหม แล้ว​คน​ตี้​เจื้อ​วางใจ๋​ใน​เฮา​ก็​จะ​บ่﻿อยาก​กิ๋น​น้ำ​แหม​เลย ");
INSERT INTO nod_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","เหมือน​กับ​ตี้​เฮา​เกย​บอก​หมู่​ต้าน​ว่า หมู่​ต้าน​ได้​หัน​เฮา แต่​หมู่​ต้าน​ก็​ยัง​บ่﻿เจื้อ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","กู้​คน​ตี้​พระบิดา​หื้อ​เฮา จะ​มา​หา​เฮา ใผ​ตี้​มา​หา​เฮา เฮา​จะ​บ่﻿ละ​บ่﻿ขว้าง​เขา ");
INSERT INTO nod_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ย้อน​ว่า เฮา​บ่﻿ได้​ลง​มา​จาก​สวรรค์​เปื้อ​เยียะ​ต๋าม​ใจ๋​ตั๋ว​เก่า แต่​มา​เปื้อ​เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ความ​ต้องก๋าน​ของ​ผู้​ตี้​ใจ๊​เฮา​มา​ก็​คือ ฮักษา​กู้​คน​ตี้​พระองค์​หื้อ​เฮา​ไว้​บ่﻿หื้อ​หาย​ไป​สัก​คน​เดียว และ​เยียะ​หื้อ​คน​หมู่​นั้น​เป๋น​ขึ้น​จาก​ความ​ต๋าย ใน​วัน​สุดต๊าย ");
INSERT INTO nod_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ย้อน​ว่า​พระบิดา​ต้องก๋าน​หื้อ​กู้​คน​ตี้​หัน​พระบุตร​กับ​เจื้อ​วางใจ๋​ใน​พระองค์​นั้น​ได้​ฮับ​จีวิต​นิรันดร์ และ​เฮา​จะ​เยียะ​หื้อ​เขา​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ใน​วัน​สุดต๊าย” ");
INSERT INTO nod_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","หมู่​จาว​ยิว​ก็​ตั้งเก๊า​จ่ม​กั๋น ตี้​พระเยซู​อู้​ว่า “เฮา​เป๋น​ของกิ๋น​ตี้​ลง​มา​จาก​สวรรค์” ");
INSERT INTO nod_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","และ​หมู่​จาว​ยิว​ก็​อู้​กั๋น​แหม​ว่า “นี่​เยซู ลูกบ่าว​โยเซฟ​บ่﻿ใจ้​กา ป้อ​แม่​ของ​เขา​เฮา​ก็​ฮู้จัก แล้ว​เขา​อู้​ได้​จาใด​ว่า ‘เฮา​ลง​มา​จาก​สวรรค์’ ” ");
INSERT INTO nod_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","พระเยซู​ก็​อู้​ว่า “บ่﻿ต้อง​จ่ม​กั๋น​เนาะ ");
INSERT INTO nod_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","บ่﻿มี​ใผ​ติดต๋าม​เฮา​ได้ ถ้า​พระบิดา​ผู้​ตี้​ใจ๊​เฮา​มา​บ่﻿ได้​ปา​เขา​มา​หา​เฮา และ​เฮา​จะ​เยียะ​หื้อ​เขา​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ใน​วัน​สุดต๊าย ");
INSERT INTO nod_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​เขียน​ไว้​ว่า ‘พระเจ้า​จะ​สั่ง​สอน​กู้​คน’ กู้​คน​ตี้​ยอม​ฟัง​พระบิดา​กับ​เฮียน​ฮู้​จาก​พระองค์ เขา​ตึง​มา​ติดต๋าม​เฮา ");
INSERT INTO nod_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","บ่﻿มี​ใผ​เกย​หัน​พระบิดา นอก​จาก​ผู้​ตี้​มา​จาก​พระเจ้า​เต้าอั้น​ตี้​เกย​หัน​พระบิดา ");
INSERT INTO nod_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","เฮา​จะ​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ใผ​ตี้​เจื้อ​วางใจ๋​เฮา​ก็​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","เฮา​เป๋น​ของกิ๋น​ตี้​หื้อ​จีวิต ");
INSERT INTO nod_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​ต้าน​ได้​กิ๋น​มานา​ใน​ตี้​ดินแดน​ทุรกั๋นดาร แต่​หมู่​เขา​ก็​ยัง​ต๋าย​กั๋น​หมด ");
INSERT INTO nod_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","แต่​เฮา​เป๋น​ของกิ๋น​นั้น​ตี้​มา​จาก​สวรรค์ ถ้า​ใผ​กิ๋น​จะ​บ่﻿ต๋าย​แหม​เลย ");
INSERT INTO nod_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","เฮา​เป๋น​ของกิ๋น​ตี้​หื้อ​จีวิต​เซิ่ง​ลง​มา​จาก​สวรรค์ ถ้า​ใผ​คน​ใด​กิ๋น​ของกิ๋น​นี้ เขา​จะ​มี​จีวิต​นิรันดร์ ของกิ๋น​นี้​ก็​คือ​เนื้อหนัง​ของ​เฮา ตี้​เฮา​จะ​หื้อ​คน​ใน​โลก​เปื้อ​มี​จีวิต​นิรันดร์​ได้” ");
INSERT INTO nod_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","จาว​ยิว​ก็​ตั้งเก๊า​เถียง​กั๋น​ว่า “ป้อจาย​คน​นี้​จะ​เอา​เนื้อหนัง​ของ​เขา​หื้อ​หมู่​เฮา​กิ๋น​ได้​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","พระเยซู​ก็​อู้​กับ​เขา​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​หมู่​ต้าน​บ่﻿ได้​กิ๋น​เนื้อหนัง​และ​กิ๋น​เลือด​ของ​บุตรมนุษย์ ต้าน​ก็​บ่﻿มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ใผ​ตี้​กิ๋น​เนื้อหนัง​กับ​เลือด​ของ​เฮา ก็​มี​จีวิต​นิรันดร์ และ​เฮา​จะ​หื้อ​เขา​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ใน​วัน​สุดต๊าย ");
INSERT INTO nod_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ย้อน​ว่า​เนื้อหนัง​ของ​เฮา​ก็​เป๋น​ของกิ๋น​ตี้​แต๊​จริง กับ​เลือด​ของ​เฮา​ก็​เป๋น​น้ำ​ตี้​แต๊​จริง ");
INSERT INTO nod_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ใผ​ตี้​กิ๋น​เนื้อหนัง​และ​กิ๋น​เลือด​ของ​เฮา คน​นั้น​ก็​อยู่​กับ​เฮา และ​เฮา​ก็​อยู่​กับ​เขา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","เหมือน​ตี้​พระบิดา​ผู้​มี​จีวิต​อยู่​ใจ๊​เฮา​มา และ​เฮา​มี​จีวิต​ย้อน​พระบิดา จาอั้น​คน​ตี้​กิ๋น​เนื้อหนัง​กับ​เลือด​ของ​เฮา​ก็​จะ​มี​จีวิต​ย้อน​เฮา​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","เฮา​เป๋น​ของกิ๋น​ตี้​ลง​มา​จาก​สวรรค์ เซิ่ง​บ่﻿เหมือน​กับ​มานา​ตี้​ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​ต้าน​ได้​กิ๋น​แล้ว​ก็​ยัง​ต๋าย แต่​คน​ตี้​กิ๋น​ของกิ๋น​นี้​จะ​มี​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","พระเยซู​อู้​เรื่อง​นี้​ต๋อน​ตี้​สอน​ใน​ธรรมศาลา​ของ​จาว​ยิว ใน​เมือง​คาเปอรนาอุม ");
INSERT INTO nod_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","บ่ากอง​หมู่​สาวก​ของ​พระองค์​หลาย​คน​ได้​ยิน​เรื่อง​จาอั้น เขา​ก็​จ่ม​กั๋น​ว่า “ใผ​จะ​ยอมฮับ​กำสอน​ยาก﻿ๆ จาอี้​ได้” ");
INSERT INTO nod_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","พระเยซู​ฮู้​ว่า​หมู่​เขา​จ่ม​กั๋น​เรื่อง​นี้ พระองค์​ก็​ถาม​หมู่​เขา​ว่า “กำสอน​นี้​เยียะ​หื้อ​หมู่​ต้าน​บ่﻿ใค่​เจื้อ​เฮา​แหม​กา ");
INSERT INTO nod_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","แล้ว​หมู่​ต้าน​จะ​ว่า​จาใด​ถ้า​หัน​บุตรมนุษย์​ขึ้น​ไป​บน​สวรรค์​ตี้​พระองค์​เกย​อยู่​มา​ก่อน​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","พระวิญญาณ​หื้อ​จีวิต​นิรันดร์ แต่​สิ่ง​ตี้​คน​เยียะ​บ่﻿มี​ประโยชน์​อะหยัง​เลย กำ​อู้​ตี้​เฮา​ได้​บอก​กับ​หมู่​ต้าน​มา​จาก​พระวิญญาณ​และ​หื้อ​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","แต่​หมู่​ต้าน​บาง​คน​ก็​บ่﻿เจื้อ” (​พระเยซู​ฮู้​ตั้งแต่​ต้น​ว่า​คน​ไหน​บ่﻿เจื้อ​และ​คน​ไหน​จะ​หักหลัง​พระองค์) ");
INSERT INTO nod_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","และ​พระองค์​ก็​อู้​ว่า “ย้อน​จาอี้ เฮา​เถิง​บอก​หมู่​ต้าน​ว่า บ่﻿มี​ใผ​ติดต๋าม​เฮา​ได้ ถ้า​พระบิดา​บ่﻿ได้​ปา​เขา​มา​หา​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","หลังจาก​ตี้​พระเยซู​อู้​จาอี้ ก็​มี​สาวก​หลาย​คน​ตี้​เลิก​ติดต๋าม​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","แล้ว​พระเยซู​ก็​ถาม​สาวก​สิบ​สอง​คน​ของ​พระองค์​ว่า “หมู่​ต้าน​ก็​จะ​เลิก​ติดต๋าม​เฮา​ตวย​กา” ");
INSERT INTO nod_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ซีโมน​เปโตร​ก็​บอก​พระองค์​ว่า “ถ้า​เฮา​เลิก​ติดต๋าม​พระองค์ แล้ว​จะ​หื้อ​เฮา​ไป​ติดต๋าม​ใผ​แหม พระองค์​มี​กำ​ตี้​หื้อ​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","หมู่​เฮา​เจื้อ​และ​ฮู้​ว่า​พระองค์​เป๋น​ผู้​บริสุทธิ์​ของ​พระเจ้า​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","พระเยซู​อู้​กับ​หมู่​เขา​ว่า “เฮา​เลือก​หมู่​ต้าน​ตึง​สิบ​สอง​คน​แม่น​ก่อ แต่​คน​นึ่ง​จะ​เป๋น​มาร” ");
INSERT INTO nod_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(​พระเยซู​หมาย​เถิง ยูดาส ลูกบ่าว​ของ​ซีโมน อิสคาริโอท ตี้​จะ​หัก​หลัง​พระองค์ เถิงแม้​ว่า​เขา​จะ​อยู่​ใน​หมู่​สาวก​สิบ​สอง​คน​ก็​ต๋าม​) ");
INSERT INTO nod_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","หลังจาก​นั้น​พระเยซู​ก็​เตียว​ไป​ใคว่​แคว้น​กาลิลี พระองค์​บ่﻿อยาก​ไป​แคว้น​ยูเดีย ย้อน​ว่า​หมู่​ผู้นำ​จาว​ยิว​เซาะ​หา​ตาง​ตี้​จะ​ฆ่า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ต๋อน​นั้น​ใก้​งาน​อยู่​เพิง​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","หมู่​น้องบ่าว​ของ​พระองค์​ก็​บอก​ว่า “อ้าย​น่า​จะ​ไป​แคว้น​ยูเดีย เปื้อ​หมู่​สาวก​ของ​อ้าย​จะ​ได้​หัน​ก๋าน​อัศจ๋รรย์​ตี้​อ้าย​เยียะ ");
INSERT INTO nod_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ย้อน​ว่า​คน​ตี้​ใค่​มี​จื้อ​เสียง​จะ​บ่﻿เยียะ​อะหยัง​ใน​ตี้​ลับ﻿ๆ กั๋น ไหน﻿ๆ อ้าย​ก็​เยียะ​ก๋าน​อัศจ๋รรย์​หมู่​นี้​อยู่​แล้ว ก็​หื้อ​คน​ตึง​โลก​ฮู้​ไป​เลย​ก่า” ");
INSERT INTO nod_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","แม้​แต่​น้อง​บ่าว​ของ​พระองค์​ยัง​บ่﻿เจื้อ​วางใจ๋​พระองค์​เลย ");
INSERT INTO nod_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","พระเยซู​ก็​บอก​ว่า “ยัง​บ่﻿เถิง​เวลา​ของ​เฮา​เตื้อ แต่​หมู่​น้อง​ไป​เวลา​ไหน​ก็​ได้ ");
INSERT INTO nod_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","คน​ใน​โลก​นี้​เขา​บ่﻿มี​อะหยัง​หื้อ​จัง​หมู่​น้อง แต่​หมู่​เขา​จัง​เฮา​ย้อน​เฮา​บอก​ว่า​หมู่​เขา​เยียะ​บ่﻿ดี ");
INSERT INTO nod_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","หมู่​น้อง​ไป​กั๋น​เต๊อะ เฮา​ยัง​บ่﻿พร้อม​ตี้​จะ​ไป​เตื้อ ย้อน​ยัง​บ่﻿เถิง​เวลา​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","หลังจาก​ตี้​อู้​จาอั้น พระองค์​ก็​อยู่​ใน​แคว้น​กาลิลี​ต่อ ");
INSERT INTO nod_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","บ่ากอง​หมู่​น้องบ่าว​ของ​พระองค์​ไป​ฮ่วม​งาน​แล้ว พระองค์​ก็​ตวย​ไป​เมื่อลูน​โดย​บ่﻿ใค่​หื้อ​ใผ​ฮู้​ใผ​หัน ");
INSERT INTO nod_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","หมู่​ผู้นำ​จาว​ยิว​ก่ำลัง​เซาะ​ผ่อ​หา​พระองค์​ใน​งาน หมู่​เขา​ก็​ถาม​ว่า “ป้อจาย​คน​นั้น​อยู่​ไหน” ");
INSERT INTO nod_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","คน​ตังหลาย​ตี้​อยู่​ตี้​หั้น​ก็​ปา​กั๋น​ซูบซาบ​เรื่อง​พระองค์​กั๋น​ขนาด พ่อง​ก็​ว่า “เขา​ก็​เป๋น​คน​ดี​ลอ” พ่อง​ก็​ว่า “บ่﻿ใจ้ เขา​เป๋น​คน​ขี้​จุ​ขี้​ล่าย” ");
INSERT INTO nod_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","แต่​บ่﻿มี​ใผ​ก้า​อู้​เรื่อง​พระองค์​อย่าง​เปิดเผย ย้อน​ว่า​หมู่​เขา​กั๋ว​หมู่​ผู้นำ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","บ่ากอง​เถิง​หละหว่าง​ก๋าง​งาน​อยู่​เพิง​ของ​จาว​ยิว พระเยซู​ก็​เข้า​ไป​ใน​บริเวณ​พระวิหาร แล้ว​ตั้ง​เก๊า​สั่ง​สอน​หมู่​คน ");
INSERT INTO nod_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","เมื่อ​หมู่​ผู้นำ​จาว​ยิว​ได้​ยิน​กำสอน​ของ​พระองค์​ก็​งืด แล้ว​ว่า “ป้อจาย​คน​นี้​บ่﻿ได้​เฮียน​มา แล้ว​จาใด​เขา​ฮู้​นัก​แต๊ะ” ");
INSERT INTO nod_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","พระเยซู​ตอบ​ว่า “กำสอน​ของ​เฮา​นั้น​บ่﻿ใจ้​เป๋น​กำ​ของ​เฮา แต่​มา​จาก​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ใผ​ตี้​เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์​ก็​จะ​ฮู้​ว่า​กำ​ตี้​เฮา​สอน​นั้น​มา​จาก​พระเจ้า​กาว่า​เฮา​อู้​ขึ้น​มา​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","คน​ตี้​อู้​ต๋าม​ใจ๋​ตั๋วเก่า​ก็​เซาะ​หา​เกียรติ​ใส่​ตั๋ว แต่​คน​ตี้​เซาะ​หา​เกียรติ​หื้อ​ผู้​ตี้​ใจ๊​เขา​มา คน​นั้น​เนาะ​ก็​เป๋น​คน​ตี้​จริงใจ๋​กับ​บ่﻿จุ​ใผ​ตวย ");
INSERT INTO nod_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","โมเสส​ได้​หื้อ​บท​บัญญัติ​กับ​หมู่​ต้าน​บ่﻿ใจ้​กา แต่​หมู่​ต้าน​ก็​บ่﻿ได้​เยียะ​ต๋าม​บท​บัญญัติ​นั้น​สัก​คน แล้ว​จาใด​หมู่​ต้าน​เซาะ​หา​ตาง​ตี้​จะ​ฆ่า​เฮา​จ๋น​ได้” ");
INSERT INTO nod_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","หมู่​เขา​ก็​ตอบ​ว่า “ต้าน​โดน​ผี​เข้า​ก๋า ใผ​จะ​ฆ่า​ต้าน” ");
INSERT INTO nod_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","พระเยซู​ตอบ​ว่า “เฮา​ได้​เยียะ​ก๋าน​อัศจ๋รรย์​อย่าง​นึ่ง แล้ว​หมู่​ต้าน​ก็​ปา​กั๋น​งืด ");
INSERT INTO nod_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","โมเสส​ได้​หื้อ​กฎ​เกี่ยวกับ​ก๋าน​เข้า​พิธี​สุหนัต (​แต๊﻿ๆ บ่﻿ใจ้​โมเสส​ตี้​เป๋น​คน​ตั้ง​หื้อ แต่​เป๋น​ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​ต้าน​) แล้ว​หมู่​ต้าน​ก็​ยัง​เยียะ​พิธี​สุหนัต​หื้อ​กับ​หละอ่อน​ป้อจาย​ตั๊ด​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ถ้า​วัน​สะบาโต​หมู่​ต้าน​ยัง​เยียะ​พิธี​สุหนัต​หื้อ​หละอ่อน​ป้อจาย​ได้ เปื้อ​บ่﻿หื้อ​ผิด​บท​บัญญัติ​ของ​โมเสส แล้ว​หมู่​ต้าน​จะ​มา​โขด​เฮา​ตี้​เฮา​ฮักษา​คน﻿ๆ นึ่ง​หื้อ​หาย​เป๋น​ปกติ​ใน​วัน​สะบาโต​เยียะ​หยัง ");
INSERT INTO nod_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","บ่﻿ดี​ตัดสิน​ใผ​ต๋าม​ตี้​หัน​ตังนอก แต่​หื้อ​ตัดสิน​ไป​ต๋าม​ความ​จริง” ");
INSERT INTO nod_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","บาง​คน​ใน​กรุง​เยรูซาเล็ม​ถาม​กั๋น​ว่า “คน​นี้​บ่﻿ใจ้​กา​ตี้​หมู่​ผู้​นำ​ฮิ​หา​ฮ่อม​จะ​ฆ่า ");
INSERT INTO nod_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","แต่​ผ่อ​ลอ เขา​ก่ำลัง​อู้​อยู่​ใน​ตี้​สาธารณะ แต่​หมู่​ผู้​นำ​ก็​บ่﻿มี​ใผ​ว่า​เขา​สัก​คน หมู่​ผู้​นำ​มั่นใจ๋​แล้ว​กา ว่า​เขา​เป๋น​พระคริสต์ ");
INSERT INTO nod_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","แต่​เฮา​ฮู้​ว่า​คน​นี้​มา​จาก​ไหน ถ้า​พระคริสต์​มา​แต๊ ก็​จะ​บ่﻿มี​ใผ​ฮู้​ว่า​พระองค์​มา​จาก​ไหน” ");
INSERT INTO nod_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ต๋อน​ตี้​พระเยซู​สอน​อยู่​บริเวณ​พระวิหาร พระองค์​ก็​เอิ้น​หื้อ​กู้​คน​ได้​ยิน​ว่า “แม่น​แล้ว หมู่​ต้าน​ฮู้จัก​เฮา และ​ฮู้​ว่า​เฮา​ลุก​ไหน​มา เฮา​บ่﻿ได้​มา​โดย​สิทธิ​อำนาจ​ของ​ตั๋วเก่า แต่​ผู้​ตี้​ใจ๊​เฮา​มา​นั้น​อู้​แต่​ความ​จริง​และ​หมู่​ต้าน​บ่﻿ฮู้จัก​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","แต่​เฮา​ฮู้จัก​พระองค์​ย้อน​เฮา​มา​จาก​พระองค์​และ​พระองค์​เป๋น​ผู้​ตี้​ใจ๊​เฮา​มา” ");
INSERT INTO nod_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","หมู่​เขา​ก็​หา​ตาง​จะ​ยับ​พระเยซู แต่​บ่﻿มี​ใผ​ยับ​พระองค์​ได้​ย้อน​บ่﻿เถิง​เวลา​ของ​พระองค์​เตื้อ ");
INSERT INTO nod_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","แต่​มี​หลาย​คน​ใน​หมู่​นั้น​เจื้อ​วางใจ๋​พระองค์ หมู่​เขา​ก็​อู้​ว่า “เมื่อ​พระคริสต์​มา​นั้น พระองค์​จะ​เยียะ​หมายสำคัญ​นัก​เหลือ​ตี้​ป้อจาย​คน​นี้​เยียะ​กา” ");
INSERT INTO nod_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","บ่ากอง​หมู่​ฟาริสี​ได้​ยิน​ว่า​คน​ตังหลาย​ปา​กั๋น​เล่า​เรื่อง​พระเยซู หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ฟาริสี​ก็​เลย​ส่ง​ทหาร​ฮักษา​พระวิหาร​ไป​ยับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","แล้ว​พระเยซู​ก็​อู้​ว่า “เฮา​จะ​อยู่​กับ​หมู่​ต้าน​ไป​แหม​บ่﻿เมิน แล้ว​ก็​จะ​ปิ๊ก​ไป​หา​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","หมู่​ต้าน​จะ​ตวย​เซาะ​หา​เฮา​แต่​ก็​จะ​บ่﻿ปะ กับ​ตี้​ตี้​เฮา​ไป​นั้น​หมู่​ต้าน​ไป​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","หมู่​ผู้นำ​จาว​ยิว​ก็​อู้​กั๋น​ว่า “เขา​จะ​ไป​ตี้​ไหน​ตี้​หมู่​เฮา​จะ​ตวย​เซาะ​หา​เขา​บ่﻿ปะ เขา​จะ​ไป​หา​จาว​ยิว​ตี้​แตก​ขะแล​ขะแจ​ไป​อยู่​เมือง​กรีก แล้ว​สอน​จาว​กรีก​ตี้​หั้น​กา ");
INSERT INTO nod_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ตี้​เขา​อู้​ว่า ‘หมู่​ต้าน​จะ​ตวย​เซาะ​หา​เฮา​แต่​ก็​จะ​บ่﻿ปะ’ กับ ‘ตี้​ตี้​เฮา​ไป​นั้น​หมู่​ต้าน​ไป​บ่﻿ได้’ หมายความ​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ใน​วัน​สุดต๊าย​ของ​งาน​อยู่​เพิง​เซิ่ง​เป๋น​วัน​สำคัญ​ตี้​สุด พระเยซู​ยืน​ขึ้น​แล้ว​ก็​ฮ้อง​เอิ้น​ว่า “ใผ​ตี้​ใค่​อยาก​กิ๋น​น้ำ​หื้อ​มา​หา​เฮา​แล้ว​กิ๋น​เหีย ");
INSERT INTO nod_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","คน​ตี้​เจื้อ​วาง​ใจ๋​เฮา​ก็​เป๋น​เหมือน​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘แม่น้ำ​ตี้​มี​สาย​น้ำ​เลี้ยง​จีวิต​จะ​ไหล​จาก​หัวใจ๋​ของ​เขา​ออก​มา’ ” ");
INSERT INTO nod_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ตี้​พระเยซู​อู้​จาอั้น​พระองค์​หมาย​เถิง​พระวิญญาณ เซิ่ง​ถ้า​ใผ​เจื้อ​วางใจ๋​พระองค์ ก็​จะ​ได้​ฮับ​พระวิญญาณ​ไป แต่​ยัง​บ่﻿มี​ใผ​ได้​ฮับ​ต๋อน​นั้น ย้อน​พระเยซู​ยัง​บ่﻿ได้​ฮับ​เกียรติ​อัน​ยิ่งใหญ่​ของ​พระองค์​เตื้อ ");
INSERT INTO nod_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","บ่ากอง​หมู่​คน​ได้​ยิน​จาอั้น บาง​คน​ก็​อู้​ว่า “ต้าน​คน​นี้​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​นั้น​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","บาง​คน​ก็​อู้​ว่า “เขา​เป๋น​พระคริสต์” บาง​คน​ก็​อู้​ว่า “พระคริสต์​จะ​มา​จาก​แคว้น​กาลิลี​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","พระคัมภีร์​มี​เขียน​ไว้​บ่﻿ใจ้​กา ว่า​พระคริสต์​จะ​มา​จาก​เจื๊อ​สาย​ของ​กษัตริย์​ดาวิด กับ​มา​จาก​หมู่บ้าน​เบธเลเฮม​เมือง​ตี้​ดาวิด​เกย​อยู่” ");
INSERT INTO nod_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ย้อน​จาอั้น​ก็​เกิด​ก๋าน​แตกแยก​กั๋น​ใน​หมู่​เขา​เรื่อง​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","บาง​คน​ใค่​ยับ​พระองค์ แต่​บ่﻿มี​ใผ​เยียะ​จาอั้น ");
INSERT INTO nod_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","จาอั้น​ทหาร​ฮักษา​พระวิหาร​ก็​ปิ๊ก​ไป​หา​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ฟาริสี แล้ว​หมู่​เขา​ก็​ถาม​หมู่​ทหาร​ว่า “เยียะ​หยัง​หมู่​สู​บ่﻿ยับ​เขา​มา” ");
INSERT INTO nod_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","หมู่​ทหาร​ก็​ตอบ​ว่า “เฮา​บ่﻿เกย​ได้​ยิน​ใผ​อู้​อย่าง​เขา​เลย” ");
INSERT INTO nod_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","หมู่​ฟาริสี​ก็​อู้​ว่า “หมู่​สู​หลง​กำ​จุ​ของ​เขา​ไป​ตวย​กา ");
INSERT INTO nod_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ผ่อ​ลอ มี​ใผ​ใน​หมู่​ผู้​นำ​กาว่า​หมู่​ฟาริสี​ตี้​หลง​เจื้อ​เขา​พ่อง ");
INSERT INTO nod_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","บ่﻿มี​เลย​แม่น​ก่อ แต่​คน​หมู่​นี้​ตี้​บ่﻿ฮู้​บท​บัญญัติ พระเจ้า​ก็​สาป​แจ้ง​หมู่​เขา​อยู่​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","นิโคเดมัส คน​ตี้​เกย​ไป​หา​พระเยซู​ก่อน​หน้า​นี้ กับ​เป๋น​ผู้นำ​คน​นึ่ง​ของ​จาว​ยิว เขา​ก็​ถาม​ว่า ");
INSERT INTO nod_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“บท​บัญญัติ​ของ​เฮา​บ่﻿หื้อ​ตัดสิน​ใผ​ก่อน​ตี้​จะ​ฟัง​เขา​อู้ กับ​ฮู้​ว่า​เขา​เยียะ​อะหยัง​บ่﻿ใจ้​กา” ");
INSERT INTO nod_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","หมู่​เขา​ก็​อู้​กับ​นิโคเดมัส​ว่า “ต้าน​ก็​ลุก​แคว้น​กาลิลี​มา​เหมือน​เขา​ตวย​กา ลอง​ไป​เซาะ​ผ่อ​ใน​พระคัมภีร์​ลอ แล้ว​ต้าน​จะ​ฮู้​ว่า บ่﻿มี​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ลุก​กาลิลี​มา​เลย” ");
INSERT INTO nod_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","แล้ว​หมู่​เขา​ตึงหมด​ก็​แยก​ย้าย​กั๋น​ปิ๊ก​บ้าน ");
INSERT INTO nod_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","แล้ว​พระเยซู​ก็​ไป​ดอย​บ่ากอกเทศ ");
INSERT INTO nod_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ต๋อน​เจ๊ามืด​วัน​ถัด​มา พระองค์​ก็​ปิ๊ก​เข้า​ไป​ใน​พระวิหาร​แหม​เตื้อ​นึ่ง คน​ตังหลาย​ก็​มา​หา​พระองค์ แล้ว​พระองค์​ก็​นั่ง​ลง​สั่ง​สอน​คน​หมู่​นั้น ");
INSERT INTO nod_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี​ปา​แม่ญิง​คน​นึ่ง​มา แล้ว​หื้อ​ยืน​ต่อ​หน้า​หมู่​คน แม่ญิง​คน​นี้​เล่น​จู๊​แล้ว​เขา​ยับ​ได้​คาหนังคาเขา ");
INSERT INTO nod_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","หมู่​เขา​ก็​อู้​กับ​พระองค์​ว่า “อาจ๋ารย์ แม่ญิง​คน​นี้​โดน​ยับ​ได้​ต๋อน​ตี้​ก่ำลัง​เล่นจู๊​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ใน​บท​บัญญัติ โมเสส​สั่ง​หื้อ​เอา​บ่าหิน​ขว้าง​แม่ญิง​จาอี้​หื้อ​ต๋าย แล้ว​อาจ๋ารย์​จะ​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(​ตี้​หมู่​เขา​ถาม​จาอี้​ก็​ย้อน​ว่า​หมู่​เขา​ใค่​ทดลอง​พระองค์​เปื้อ​หา​เรื่อง​ตี้​จะ​ยับ​พระองค์​) แต่​พระเยซู​ก็​ก้ม​ลง​เอา​นิ้ว​เขียน​บน​ปื๊น​ดิน ");
INSERT INTO nod_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","หมู่​เขา​ก็​เข​หื้อ​พระองค์​ตอบ​ติก﻿ๆ แล้ว​พระองค์​ก็​เลย​ลุก​ขึ้น​อู้​กับ​หมู่​เขา​ว่า “ใน​หมู่​ต้าน​คน​ใด​บ่﻿มี​บาป​เลย ก็​หื้อ​เอา​บ่าหิน​ขว้าง​นาง​ก่อน​แล่” ");
INSERT INTO nod_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","แล้ว​พระองค์​ก็​ก้ม​ลง​ใจ๊​นิ้ว​เขียน​บน​ปื๊น​ดิน​ต่อ ");
INSERT INTO nod_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","บ่ากอง​หมู่​ธรรมาจ๋ารย์​กับ​หมู่​ฟาริสี​ได้ยิน​พระเยซู​อู้​จาอั้น แล้ว​หมู่​เขา​ก็​ออก​ไป​เตื้อ​คน﻿ๆ คน​เฒ่า​เริ่ม​ออก​ไป​ก่อน​จ๋น​เหลือ​ก้า​พระเยซู​กับ​แม่ญิง​คน​นั้น​ยัง​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","พระเยซู​ก็​ลุก​ขึ้น​แล้ว​ถาม​แม่ญิง​คน​นั้น​ว่า “หญิง​เหย หมู่​เขา​ไป​ไหน​กั๋น​หมด​แล้ว บ่﻿มี​ใผ​ลงโต้ษ​เจ้า​กา” ");
INSERT INTO nod_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","แม่ญิง​คน​นั้น​ก็​ตอบ​ว่า “บ่﻿มี​เจ้า” แล้ว​พระเยซู​ก็​อู้​ว่า “เฮา​ก็​บ่﻿ลงโต้ษ​เจ้า​เหมือน​กั๋น ไป​เต๊อะ แล้ว​ห้าม​เยียะ​บาป​แหม” ");
INSERT INTO nod_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","แล้ว​พระเยซู​ก็​อู้​กับ​คน​ตังหลาย​แหม​เตื้อ​ว่า “เฮา​เป๋น​ความ​เป่งแจ้ง​ของ​โลก คน​ตี้​ติดต๋าม​หลาม​ตวย​เฮา​มา​ก็​จะ​บ่﻿เตียว​ใน​ความ​มืด แต่​จะ​มี​แสงแจ้ง​ตี้​ส่อง​นำ​จีวิต​ของ​เขา” ");
INSERT INTO nod_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","หมู่​ฟาริสี​ก็​อู้​กับ​พระองค์​ว่า “ต้าน​เป๋น​พยาน​หื้อ​ตั๋ว​เก่า กำ​พยาน​ของ​ต้าน​ก็​เจื้อถือ​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","พระเยซู​ก็​ตอบ​ว่า “เถิง​เฮา​เป๋น​พยาน​หื้อ​ตั๋ว​เก่า แต่​สิ่ง​ตี้​เฮา​อู้​มา​นั้น​ก็​เป๋น​ความ​จริง ย้อน​ว่า​เฮา​ฮู้​ว่า​ตั๋ว​เฮา​ลุก​ไหน​มา​กับ​ก่ำลัง​จะ​ไป​ไหน แต่​หมู่​ต้าน​บ่﻿ฮู้​ว่า​เฮา​ลุก​ไหน​มา​กาว่า​ก่ำลัง​จะ​ไป​ไหน ");
INSERT INTO nod_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","หมู่​ต้าน​ตัดสิน​เฮา​ต๋าม​วิธี​ของ​คน เฮา​บ่﻿ได้​ตัดสิน​ใผ ");
INSERT INTO nod_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","แต่​ถ้า​เฮา​ตัดสิน​คน​ใด กำ​ตัดสิน​ของ​เฮา​ก็​ถูกต้อง ย้อน​เฮา​บ่﻿ได้​ตัดสิน​คน​เดียว แต่​เฮา​ตัดสิน​ฮ่วม​กับ​พระบิดา​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ใน​บท​บัญญัติ​ของ​ต้าน​บอก​ว่า ถ้า​มี​กำ​พยาน​สอง​คน กำ​พยาน​นั้น​ก็​เจื้อถือ​ได้ ");
INSERT INTO nod_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","เฮา​เป๋น​พยาน​หื้อ​ตั๋วเก่า และ​พระบิดา​ผู้​ตี้​ใจ๊​เฮา​มา​ก็​เป๋น​พยาน​หื้อ​เฮา​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","แล้ว​หมู่​เขา​ก็​ถาม​ว่า “พระบิดา​ของ​ต้าน​อยู่​ตี้​ไหน” พระเยซู​ก็​ตอบ​ว่า “หมู่​ต้าน​บ่﻿ฮู้จัก​เฮา​กับ​บ่﻿ฮู้จัก​พระบิดา​ของ​เฮา ถ้า​หมู่​ต้าน​ฮู้จัก​เฮา หมู่​ต้าน​ก็​จะ​ฮู้จัก​พระบิดา​ของ​เฮา​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ต๋อน​ตี้​พระองค์​อู้​เถิง​สิ่ง​หมู่​นี้ พระองค์​ก่ำลัง​สั่ง​สอน​อยู่​ใน​ห้อง​ตั้ง​ตู้​ถวาย​อยู่​ใน​บริเวณ​พระวิหาร แล้ว​บ่﻿มี​ใผ​มา​ยับ​พระองค์ ย้อน​ยัง​บ่﻿เถิง​เวลา​ของ​พระองค์​เตื้อ ");
INSERT INTO nod_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","พระเยซู​อู้​กับ​คน​ตังหลาย​แหม​ว่า “เฮา​จะ​ไป​จาก​ตี้​นี่ แล้ว​หมู่​ต้าน​จะ​ตวย​เซาะ​หา​เฮา แต่​หมู่​ต้าน​จะ​ต๋าย​ใน​ต๋อน​ตี้​ยัง​เป๋น​คน​บาป​อยู่ ตี้​ตี้​เฮา​ไป​นั้น​หมู่​ต้าน​ไป​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","หมู่​ผู้นำ​จาว​ยิว​ก็​ถาม​กั๋น​ว่า “เขา​จะ​ไป​ฆ่า​ตั๋ว​ต๋าย​กาว่า​จาใด เถิง​อู้​ว่า ‘ตี้​ตี้​เฮา​ไป​นั้น​หมู่​ต้าน​ไป​บ่﻿ได้’ ” ");
INSERT INTO nod_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","พระเยซู​อู้​ว่า “หมู่​ต้าน​มา​จาก​โลก​นี้​ตี้​อยู่​ตัง​ลุ่ม แต่​เฮา​มา​จาก​สวรรค์​ตี้​อยู่​ตัง​บน แล้ว​หมู่​ต้าน​ก็​เป๋น​ของ​โลก​นี้ แต่​เฮา​บ่﻿ใจ้​เป๋น​ของ​โลก​นี้ ");
INSERT INTO nod_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","เฮา​เลย​บอก​ว่า หมู่​ต้าน​จะ​ต๋าย​ใน​ต๋อน​ตี้​ยัง​เป๋น​คน​บาป​อยู่ แม่น​แล้ว หมู่​ต้าน​จะ​ต๋าย​ใน​ต๋อน​ตี้​ยัง​เป๋น​คน​บาป​อยู่​แน่﻿ๆ ถ้า​หมู่​ต้าน​บ่﻿เจื้อ​ว่า เฮา​เป๋น​คน​นั้น​ตี้​เฮา​บอก​ว่า​เฮา​เป๋น” ");
INSERT INTO nod_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","หมู่​ผู้นำ​จาว​ยิว​ก็​ถาม​พระองค์​ว่า “แล้ว​ต้าน​เป๋น​ใผ” พระเยซู​ก็​ตอบ​ว่า “เฮา​เป๋น​คน​นั้น​ตี้​เฮา​บอก​หมู่​ต้าน​ตั้งแต่​เก๊า​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","แต๊﻿ๆ เฮา​มี​หลาย​เรื่อง​ตี้​จะ​ว่า​หื้อ​หมู่​ต้าน​กับ​ตัดสิน​ลงโต้ษ​หมู่​ต้าน แต่​เฮา​จะ​อู้​ก้า​เรื่อง​ตี้​เฮา​ได้​ยิน​จาก​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา​หื้อ​คน​ใน​โลก​ฟัง ย้อน​พระองค์​อู้​ความ​จริง” ");
INSERT INTO nod_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","(​หมู่​เขา​บ่﻿เข้าใจ๋​ว่า​พระเยซู​ก่ำลัง​อู้​เถิง​พระบิดา​) ");
INSERT INTO nod_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","จาอั้น​พระเยซู​ก็​อู้​แหม​ว่า “เมื่อ​หมู่​ต้าน​ยก​บุตรมนุษย์​ขึ้น หมู่​ต้าน​ก็​จะ​ฮู้​ว่า​เฮา​เป๋น​คน​นั้น​ละ เฮา​บ่﻿ได้​เยียะ​ต๋าม​ใจ๋​ตั๋วเก่า แต่​เฮา​อู้​สิ่ง​ตี้​พระบิดา​สอน​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา​ก็​อยู่​กับ​เฮา​ตวย พระองค์​บ่﻿เกย​ละ​เฮา​ไว้​หื้อ​อยู่​คน​เดียว ย้อน​เฮา​เยียะ​ต๋ามใจ๋​พระองค์​ตลอด” ");
INSERT INTO nod_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","บ่ากอง​พระเยซู​อู้​จาอี้ ก็​มี​หลาย​คน​เจื้อ​วางใจ๋​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","พระเยซู​ก็​อู้​กับ​จาว​ยิว​ตี้​เจื้อ​วางใจ๋​ใน​พระองค์​ว่า “ถ้า​หมู่​ต้าน​ยึดถือ​ใน​กำ​สั่ง​สอน​ของ​เฮา หมู่​ต้าน​ก็​เป๋น​สาวก​ของ​เฮา​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","หมู่​ต้าน​จะ​ฮู้จัก​ความ​จริง แล้ว​ความ​จริง​นั้น​ก็​จะ​เยียะ​หื้อ​หมู่​ต้าน​มี​อิสระ” ");
INSERT INTO nod_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","หมู่​เขา​อู้​ว่า “หมู่​เฮา​เป๋น​ลูกหลาน​ของ​อับราฮัม บ่﻿เกย​เป๋น​ขี้ข้า​ใผ เยียะ​หยัง​อาจ๋ารย์​อู้​ว่า ‘หมู่​ต้าน​จะ​มี​อิสระ’ ” ");
INSERT INTO nod_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","พระเยซู​ตอบ​ว่า “เฮา​จะ​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า แต๊﻿ๆ แล้ว​กู้​คน​ตี้​เยียะ​บาป​ก็​เป๋น​ขี้ข้า​ของ​ความ​บาป ");
INSERT INTO nod_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ขี้ข้า​บ่﻿ใจ้​คน​ใน​ครอบครัว แต่​ลูก​เป๋น​คน​ใน​ครอบครัว​ตลอด​ไป ");
INSERT INTO nod_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ถ้า​พระบุตร​หื้อ​หมู่​ต้าน​มี​อิสระ หมู่​ต้าน​ก็​จะ​มี​อิสระ​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","เฮา​ฮู้​ว่า​หมู่​ต้าน​เป๋น​ลูกหลาน​ของ​อับราฮัม แต่​หมู่​ต้าน​ฮิ​หา​ตาง​จะ​ฆ่า​เฮา ย้อน​ว่า​หมู่​ต้าน​บ่﻿ยอมฮับ​กำ​สั่ง​สอน​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","เฮา​บอก​หมู่​ต้าน​เถิง​สิ่ง​ตี้​พระบิดา​ของ​เฮา​เยียะ​หื้อ​เฮา​หัน แต่​หมู่​ต้าน​ก็​เยียะ​สิ่ง​ตี้​ได้​ยิน​จาก​ป้อ​ของ​หมู่​ต้าน” ");
INSERT INTO nod_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","หมู่​เขา​อู้​ว่า “อับราฮัม​เป๋น​ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​เฮา” พระเยซู​เลย​อู้​ว่า “ถ้า​หมู่​ต้าน​เป๋น​ลูกหลาน​ของ​อับราฮัม​แต๊﻿ๆ หมู่​ต้าน​ก็​จะ​เยียะ​ต๋าม​ตี้​อับราฮัม​เยียะ ");
INSERT INTO nod_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","เฮา​เป๋น​คน​บอก​ความ​จริง​เถิง​สิ่ง​ตี้​เฮา​ได้ยิน​จาก​พระเจ้า แต่​หมู่​ต้าน​ก็​ฮิ​หา​ตาง​ตี้​จะ​ฆ่า​เฮา อับราฮัม​บ่﻿เกย​เยียะ​จาอี้​เน่อ ");
INSERT INTO nod_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","หมู่​ต้าน​เยียะ​ต๋าม​ตี้​ป้อ​ของ​หมู่​ต้าน​เยียะ” หมู่​จาว​ยิว​ก็​อู้​กับ​พระเยซู​ว่า “หมู่​เฮา​บ่﻿ใจ้​ลูก​จู๊ พระเจ้า​เต้าอั้น​ตี้​เป๋น​ป้อ​ของ​หมู่​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","พระเยซู​ก็​อู้​ว่า “ถ้า​พระเจ้า​เป๋น​ป้อ​ของ​หมู่​ต้าน​แต๊﻿ๆ หมู่​ต้าน​ก็​จะ​ฮัก​เฮา ย้อน​เฮา​มา​จาก​พระเจ้า​และ​เฮา​อยู่​นี่​แล้ว เฮา​บ่﻿ได้​มา​โดย​ต๋ามใจ๋​ตั๋ว​เก่า แต่​พระเจ้า​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","เยียะ​หยัง​หมู่​ต้าน​บ่﻿เข้าใจ๋​เรื่อง​ตี้​เฮา​อู้ ย้อน​ว่า​หมู่​ต้าน​อด​ฟัง​กำสอน​ของ​เฮา​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","หมู่​ต้าน​มา​จาก​ป้อ​ของ​หมู่​ต้าน​คือ​มาร แล้ว​หมู่​ต้าน​ก็​ใค่​เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​ป้อ​หมู่​ต้าน ตั้งแต่​เก๊า​มาร​ก็​เป๋น​ฆาตกร และ​บ่﻿เกย​อยู่​ฝ่าย​ความ​จริง​เลย ย้อน​มัน​บ่﻿มี​ความ​จริง​ใน​ตั๋ว​ของ​มัน เมื่อ​มัน​อู้​กำ​จุ มัน​ก็​เยียะ​ต๋าม​สันดาน​ของ​มัน ย้อน​ว่า​มัน​ขี้​จุ​กับ​เป๋น​ป้อ​ของ​ก๋าน​จุ ");
INSERT INTO nod_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ย้อน​จาอั้น เมื่อ​เฮา​อู้​ความ​จริง​กับ​หมู่​ต้าน หมู่​ต้าน​ก็​บ่﻿เจื้อ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","มี​ใผ​พ่อง​ใน​หมู่​ต้าน​ตี้​จี๊​หื้อ​หัน​ว่า​เฮา​เยียะ​บาป แล้ว​เยียะ​หยัง​หมู่​ต้าน​บ่﻿ยอม​เจื้อ​เฮา​เมื่อ​เฮา​อู้​ความ​จริง ");
INSERT INTO nod_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","คน​ของ​พระเจ้า​ก็​ฟัง​กำ​อู้​ของ​พระเจ้า แต่​ตี้​หมู่​ต้าน​บ่﻿ยอม​ฟัง​เฮา​ก็​ย้อน​ว่า​หมู่​ต้าน​บ่﻿ใจ้​คน​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","หมู่​จาว​ยิว​ก็​อู้​ว่า “หมู่​เฮา​อู้​ผิด​ตี้​ไหน ตี้​ว่า​ต้าน​เป๋น​จาว​สะมาเรีย กับ​โดน​ผี​เข้า​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","พระเยซู​ก็​อู้​ว่า “เฮา​บ่﻿ได้​โดน​ผี​เข้า แต่​เฮา​หื้อ​เกียรติ​พระบิดา​ของ​เฮา แต่​หมู่​ต้าน​ก็​ดู​ถูก​ดู​แควน​เฮา ");
INSERT INTO nod_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","เฮา​บ่﻿เซาะ​หา​กำ​ยกย่อง​สรรเสริญ​หื้อ​ตั๋ว​เก่า แต่​พระเจ้า​เป๋น​ผู้​เซาะ​หา​หื้อ​เฮา และ​พระองค์​ก็​เป๋น​ผู้​ตัดสิน​เข้า​ข้าง​เฮา ");
INSERT INTO nod_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​ใผ​คน​ใด​เยียะ​ต๋าม​กำ​สั่ง​สอน​ของ​เฮา คน​นั้น​ก็​จะ​บ่﻿มี​วัน​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","หมู่​จาว​ยิว​ก็​อู้​กับ​พระองค์​ว่า “ต๋อน​นี้​เฮา​ฮู้​แล้ว​ว่า​ต้าน​โดน​ผี​ฮ้าย​เข้า​แน่﻿ๆ ย้อน​อับราฮัม​กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ก็​ต๋าย​กั๋น​ไป​แล้ว แต่​ต้าน​อู้​ว่า ‘ใผ​คน​ใด​ตี้​เยียะ​ต๋าม​กำ​สั่ง​สอน​ของ​เฮา​ก็​จะ​บ่﻿มี​วัน​ต๋าย’ ");
INSERT INTO nod_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ต้าน​เป๋น​ใหญ่​นัก​เหลือ​อับราฮัม ป้ออุ๊ย​แม่หม่อน​ของ​เฮา​กา ย้อน​อับราฮัม​กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ก็​ต๋าย​กั๋น​ไป​แล้ว ต้าน​กึ๊ด​ว่า​ต้าน​เป๋น​ใผ” ");
INSERT INTO nod_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","พระเยซู​ตอบ​ว่า “ถ้า​เฮา​ยกย่อง​สรรเสริญ​ตั๋วเก่า กำ​ยกย่อง​สรรเสริญ​นั้น​ก็​บ่﻿มี​ความหมาย​อะหยัง​เลย พระบิดา​ของ​เฮา​ผู้​ตี้​หมู่​ต้าน​อ้าง​ว่า​เป๋น​พระเจ้า​ของ​หมู่​ต้าน​นั้น​เนาะ เป๋น​ผู้​ตี้​ยกย่อง​สรรเสริญ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","แต๊﻿ๆ แล้ว หมู่​ต้าน​บ่﻿ฮู้จัก​พระองค์ แต่​เฮา​ฮู้จัก​พระองค์ ถ้า​เฮา​อู้​ว่า​เฮา​บ่﻿ฮู้จัก​พระองค์ เฮา​ก็​เป๋น​คน​ขี้​จุ​เหมือน​หมู่​ต้าน แต่​เฮา​ฮู้จัก​พระองค์​กับ​เยียะ​ต๋าม​ตี้​พระองค์​บอก​เฮา ");
INSERT INTO nod_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","อับราฮัม​ป้อ​อุ๊ย​แม่​หม่อน​ของ​หมู่​ต้าน​ดีใจ๋​ตี้​จะ​หัน​วัน​ตี้​เฮา​มา เขา​ได้​หัน​ล่วงหน้า​แล้ว กับ​ดีใจ๋​แล้ว​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","หมู่​จาว​ยิว​ก็​อู้​ว่า “ต้าน​อายุ​ยัง​บ่﻿เถิง​ห้า​สิบ​เลย ต้าน​เกย​หัน​อับราฮัม​ได้​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","พระเยซู​ตอบ​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ก่อน​อับราฮัม​เกิด เฮา​ก็​เป๋น​อยู่​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","คน​หมู่​นั้น​ก็​เลย​หยิบ​บ่าหิน​ขึ้น​มา​จะ​ขว้าง​พระเยซู แต่​พระองค์​ก็​หลบ​ออก​จาก​พระวิหาร​ไป ");
INSERT INTO nod_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","บ่ากอง​พระเยซู​ก่ำลัง​เตียว​ตาง​อยู่ พระองค์​ก็​หัน​ป้อจาย​ต๋า​บอด​ตั้งแต่​เกิด​คน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","แล้ว​หมู่​สาวก​ของ​พระองค์​ก็​ถาม​ว่า “อาจ๋ารย์ บาป​ของ​ใผ​กั๋น​ตี้​เยียะ​หื้อ​ป้อจาย​คน​นี้​เกิด​มา​ต๋า​บอด บาป​ของ​เขา​กาว่า​ของ​ป้อ​แม่​เขา” ");
INSERT INTO nod_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","พระเยซู​ก็​ตอบ​ว่า “บ่﻿ใจ้​บาป​ของ​เขา​กาว่า​ของ​ป้อ​แม่​เขา แต่​ตี้​ป้อจาย​คน​นี้​ต๋า​บอด​ก็​เปื้อ​คน​ตังหลาย​จะ​ได้​หัน​ฤทธิ์​อำนาจ​ของ​พระเจ้า​ผ่าน​ตาง​จีวิต​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ต๋อน​เมื่อ​วัน​หมู่​เฮา​ต้อง​เยียะ​ก๋าน​ของ​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา​นั้น ย้อน​ต๋อน​เมื่อ​คืน​ก่ำลัง​มา แล้ว​จะ​บ่﻿มี​ใผ​เยียะ​ก๋าน​ได้ ");
INSERT INTO nod_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","เมื่อ​เฮา​อยู่​ใน​โลก​นี้ เฮา​ก็​เป๋น​ความ​เป่งแจ้ง​ของ​โลก” ");
INSERT INTO nod_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","บ่ากอง​พระเยซู​อู้​จาอั้น​แล้ว พระองค์​ก็​ถ่ม​น้ำลาย​แตว​กับ​ขี้ดิน​จ๋น​เป๋น​ขี้เปอะ แล้ว​แปด​ตี้​ต๋า​ของ​ป้อจาย​ต๋า​บอด ");
INSERT INTO nod_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","แล้ว​พระองค์​ก็​บอก​กับ​เขา​ว่า “ไป​ล้าง​ต๋า​ตี้​สระ​สิโลอัม​เต๊อะ” (​สิโลอัม แป๋​ว่า ใจ๊​ไป​) ป้อจาย​คน​นั้น​ก็​ไป​ล้าง​ต๋า​ตี้​สระ​สิโลอัม เมื่อ​ออก​ไป เขา​ก็​ผ่อ​หัน​ได้ ");
INSERT INTO nod_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","หมู่​จาว​บ้าน​กับ​คน​ตังหลาย​ตี้​เกย​หัน​เขา​เป๋น​ขอตาน​ก็​อู้​กั๋น​ว่า “ป้อจาย​คน​นี้​บ่﻿ใจ้​กา​ตี้​เกย​นั่ง​ขอตาน​อยู่” ");
INSERT INTO nod_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","พ่อง​ก็​อู้​ว่า “แม่น​เขา​แล้ว” พ่อง​ก็​ว่า “บ่﻿แม่น หน้า​เหมือน​กั๋น​บ่﻿ดาย” แล้ว​ป้อจาย​คน​นั้น​ก็​บอก​ว่า “แม่น​แล้ว เป๋น​เฮา​เนียะ” ");
INSERT INTO nod_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","แล้ว​หมู่​เขา​ก็​ถาม​เขา​แหม​ว่า “ต้าน​ผ่อ​หัน​ได้​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ป้อจาย​คน​นั้น​ก็​ตอบ​ว่า “ป้อจาย​ตี้​จื้อ​เยซู​แป๋ง​ขี้เปอะ​แปด​ต๋า​ของ​เฮา​แล้ว​บอก​หื้อ​เฮา​ไป​ล้าง​ต๋า​ตี้​สระ​สิโลอัม เมื่อ​เฮา​ไป​ล้าง​ต๋า​ตี้​สระ​นั้น แล้ว​เฮา​ก็​ผ่อ​หัน​ได้” ");
INSERT INTO nod_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","คน​ตังหลาย​ก็​ถาม​เขา​ว่า “แล้ว​ป้อจาย​คน​นั้น​อยู่​ตี้​ไหน” เขา​ก็​ตอบ​ว่า “เฮา​บ่﻿ฮู้” ");
INSERT INTO nod_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","หมู่​เขา​ก็​ปา​ป้อจาย​ตี้​เกย​ต๋า​บอด​คน​นั้น​ไป​หา​หมู่​ฟาริสี ");
INSERT INTO nod_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","วัน​ตี้​พระเยซู​แป๋ง​ขี้เปอะ​แปด​ต๋า​เขา​หื้อ​หาย​บอด​นั้น​เป๋น​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","หมู่​ฟาริสี​ก็​ถาม​เขา​ว่า เขา​ผ่อ​หัน​ได้​จาใด ป้อจาย​คน​นี้​ก็​ตอบ​ว่า “เขา​เอา​ขี้เปอะ​แปด​ต๋า​ของ​เฮา แล้ว​เฮา​ก็​ไป​ล้าง​ต๋า​ก็​ผ่อ​หัน​ได้” ");
INSERT INTO nod_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ฟาริสี​บาง​คน​ก็​อู้​ว่า “ป้อจาย​คน​นั้น​บ่﻿ได้​มา​จาก​พระเจ้า ย้อน​ว่า​เขา​บ่﻿ได้​ฮักษา​กฎ​วัน​สะบาโต” แต่​บาง​คน​อู้​ว่า “คน​บาป​จะ​เยียะ​หมายสำคัญ​จาอี้​ได้​จาใด” แล้ว​กำกึ๊ด​ของ​หมู่​เขา​ก็​แตก​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","หมู่​ฟาริสี​ก็​เลย​ถาม​ป้อจาย​คน​นี้​แหม​ว่า “เจ้า​กึ๊ด​จาใด​เรื่อง​ป้อจาย​คน​นั้น ย้อน​เจ้า​เป๋น​คน​ตี้​เขา​เยียะ​หื้อ​ต๋า​ของ​เจ้า​หาย​บอด” ป้อจาย​คน​นี้​ก็​ตอบ​ว่า “เขา​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","หมู่​ผู้นำ​จาว​ยิว​บ่﻿ยอม​เจื้อ​ว่า​ป้อจาย​คน​นี้​เกย​ต๋าบอด แล้ว​บ่าเดี่ยว​นี้​ก็​ผ่อ​หัน​ได้ หมู่​เขา​ก็​เลย​ฮ้อง​ป้อ​แม่​ของ​ป้อจาย​คน​นี้​มา ");
INSERT INTO nod_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","แล้ว​ถาม​ว่า “ป้อจาย​คน​นี้​เป๋น​ลูกบ่าว​ของ​ต้าน​แม่น​ก่อ ตี้​ต้าน​บอก​ว่า​เขา​ต๋าบอด​ตั้งแต่​เกิด​นั้น แล้ว​เยียะ​หยัง​เขา​เถิง​ผ่อ​หัน​ได้” ");
INSERT INTO nod_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ป้อ​แม่​ป้อจาย​คน​นี้​ก็​ตอบ​ว่า “เฮา​ฮู้​ว่า​ป้อจาย​คน​นี้​เป๋น​ลูกบ่าว​ของ​เฮา แล้ว​เฮา​ก็​ฮู้​ว่า เขา​ต๋า​บอด​ตั้งแต่​เกิด​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","แต่​เฮา​บ่﻿ฮู้​ว่า​เยียะ​หยัง​บ่าเดี่ยว​นี้​เขา​เถิง​ผ่อ​หัน​ได้ แล้ว​ใผ​เยียะ​หื้อ​เขา​หาย​บอด​เฮา​ก็​บ่﻿ฮู้​เหมือน​กั๋น ไป​ถาม​เขา​เอา​เต๊อะ เขา​ใหญ่​แล้ว เขา​ตึง​เล่า​เรื่อง​ของ​เขา​คน​เดียว​ได้” ");
INSERT INTO nod_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ตี้​ป้อ​แม่​ของ​ป้อจาย​คน​นี้​อู้​จาอั้น ก็​ย้อน​ว่า​กั๋ว​หมู่​ผู้นำ​จาว​ยิว ย้อน​หมู่​ผู้นำ​จาว​ยิว​ตกลง​กั๋น​ไว้​ว่า ถ้า​คน​ใด​ยอมฮับ​ว่า​พระเยซู​เป๋น​พระคริสต์ ก็​หื้อ​ไล่​คน​นั้น​ออก​จาก​สมาชิก​ธรรมศาลา ");
INSERT INTO nod_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","จาอั้น​ป้อแม่​ของ​ป้อจาย​คน​นี้​เลย​อู้​ว่า “เขา​ใหญ่​แล้ว ไป​ถาม​เขา​เอา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","หมู่​ผู้นำ​จาว​ยิว​เลย​ฮ้อง​ป้อจาย​ตี้​เกย​ต๋า​บอด​คน​นั้น​มา​แหม​เตื้อ​นึ่ง แล้ว​ก็​บอก​กับ​เขา​ว่า “เจ้า​ต้อง​สาบาน​ต่อหน้า​พระเจ้า​ว่า​จะ​อู้​ความ​จริง เฮา​ฮู้​ว่า​ป้อจาย​คน​นั้น​เป๋น​คน​บาป” ");
INSERT INTO nod_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","เขา​ก็​ตอบ​ว่า “ป้อจาย​คน​นั้น​เป๋น​คน​บาป​ก่อ​เฮา​บ่﻿ฮู้ เฮา​ฮู้​ก้า​ว่า​เฮา​เกย​ต๋า​บอด​แล้ว​บ่าเดี่ยว​นี้​ก็​ผ่อ​หัน​ได้​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","คน​หมู่​นั้น​ก็​ถาม​เขา​แหม​ว่า “เขา​เยียะ​อะหยัง​กับ​เจ้า​พ่อง แล้ว​เขา​เยียะ​จาใด​หื้อ​ต๋า​ของ​เจ้า​หาย​บอด” ");
INSERT INTO nod_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ป้อจาย​คน​นี้​ก็​ตอบ​ว่า “เฮา​บอก​หมู่​ต้าน​ไป​แล้ว แต่​หมู่​ต้าน​ก็​บ่﻿ได้​ฟัง จะ​หื้อ​เฮา​เล่า​แหม​เตื้อ​เยียะ​หยัง หมู่​ต้าน​ใค่​เป๋น​สาวก​ของ​เขา​ตวย​กา” ");
INSERT INTO nod_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","หมู่​ผู้นำ​จาว​ยิว​เลย​เส้ย​ป้อจาย​คน​นี้​ว่า “เจ้า​เป๋น​สาวก​ของ​เขา แต่​หมู่​เฮา​เป๋น​สาวก​ของ​โมเสส​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","หมู่​เฮา​ฮู้​ว่า​พระเจ้า​ได้​อู้​กับ​โมเสส แต่​ป้อจาย​คน​นี้​ลุก​ไหน​มา​เฮา​ก็​บ่﻿ฮู้” ");
INSERT INTO nod_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","แล้ว​ป้อจาย​คน​นี้​ก็​ตอบ​ว่า “มัน​ตึง​งืด​แต๊﻿ๆ ตี้​หมู่​ต้าน​บ่﻿ฮู้​ว่า​เขา​ลุก​ไหน​มา แต่​เขา​ก็​เยียะ​หื้อ​ต๋า​ของ​เฮา​หาย​บอด ");
INSERT INTO nod_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","หมู่​เฮา​ฮู้​ว่า​พระเจ้า​บ่﻿ฟัง​คน​บาป แต่​ถ้า​ใผ​คน​ใด​เก๋งกั๋ว​พระเจ้า​และ​เยียะ​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์ พระองค์​ก็​ฟัง​คน​นั้น ");
INSERT INTO nod_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ตั้ง​เมื่อ​เก๊า​สร้าง​โลก ยัง​บ่﻿เกย​มี​ใผ​ได้​ยิน​ว่า มี​ใผ​คน​ใด​เยียะ​หื้อ​คน​ต๋า​บอด​ตั้งแต่​เกิด​ผ่อ​หัน​ได้ ");
INSERT INTO nod_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ถ้า​เขา​บ่﻿ได้​มา​จาก​พระเจ้า เขา​ก็​เยียะ​จาอี้​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","หมู่​ผู้นำ​จาว​ยิว​บอก​ป้อจาย​คน​นี้​ว่า “ต้าน​หน่ะ​ก่า บาป​มา​ตั้งแต่​เกิด ก้า​มา​สอน​เฮา​ได้​จาใด” แล้ว​หมู่​เขา​ก็​ไล่​เหิบ​ป้อจาย​คน​นั้น​ออก​ไป ");
INSERT INTO nod_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","เมื่อ​พระเยซู​ได้​ยิน​ว่า​มี​อะหยัง​เกิด​ขึ้น​กับ​ป้อจาย​ตี้​เกย​ต๋า​บอด​คน​นั้น​พ่อง พระองค์​ก็​เลย​ไป​หา​เขา กับ​ถาม​เขา​ว่า “ต้าน​เจื้อ​วางใจ๋​ใน​บุตรมนุษย์​กา” ");
INSERT INTO nod_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ป้อจาย​คน​นั้น​ก็​ตอบ​ว่า “ต้าน​ครับ ใผ​คือ​บุตรมนุษย์​ตี้​เฮา​จะ​เจื้อ​วางใจ๋​เขา​ได้” ");
INSERT INTO nod_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","พระเยซู​ก็​ตอบ​ว่า “ต้าน​ก็​หัน​เขา​แล้ว เขา​ก็​คือ​คน​ตี้​ก่ำลัง​อู้​อยู่​กับ​ต้าน​นี่​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","แล้ว​ป้อจาย​คน​นั้น​ก็​อู้​ว่า “พระองค์​เจ้า​ข้า ข้าพเจ้า​เจื้อ​วางใจ๋​ใน​พระองค์” แล้ว​ป้อจาย​คน​นั้น​ก็​กราบ​ไหว้​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","แล้ว​พระเยซู​ก็​อู้​ว่า “เฮา​มา​เปื้อ​ตัดสิน​โลก​นี้ เปื้อ​หื้อ​คน​ต๋าบอด​ผ่อ​หัน​ได้ กับ​หื้อ​คน​ตี้​กึ๊ด​ว่า​ตั๋ว​เก่า​ผ่อ​หัน ก็​ก๋าย​เป๋น​ต๋า​บอด” ");
INSERT INTO nod_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","แล้ว​หมู่​ฟาริสี​ตี้​อยู่​ต๋ำ​หั้น​ได้ยิน​พระเยซู​อู้​จาอั้น ก็​เลย​อู้​กับ​พระองค์​ว่า “ต้าน​ว่า​หมู่​เฮา​ต๋า​บอด​ตวย​กา” ");
INSERT INTO nod_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","พระเยซู​ก็​บอก​ว่า “ถ้า​หมู่​ต้าน​ต๋า​บอด หมู่​ต้าน​ก็​บ่﻿มี​บาป​อะหยัง แต่​ย้อน​ว่า​บ่าเดี่ยว​นี้​หมู่​ต้าน​บอก​ว่า ‘เฮา​ผ่อ​หัน’ หมู่​ต้าน​ก็​ยัง​เป๋น​คน​บาป​อยู่” ");
INSERT INTO nod_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","พระเยซู​อู้​ว่า “เฮา​จะ​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ตี้​บ่﻿ได้​เข้า​คอก​แกะ​ตาง​ปะตู๋ แต่​ลัก​เข้า​ไป​ตาง​อื่น ก็​เป๋น​คน​ขี้ลัก​กับ​เป๋น​โจ๋ร ");
INSERT INTO nod_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","แต่​คน​ตี้​เข้า​คอก​แกะ​ตาง​ปะตู๋​ก็​เป๋น​คน​เลี้ยง​แกะ​หมู่​นั้น ");
INSERT INTO nod_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","คน​เฝ้า​ปะตู๋​ก็​เปิด​ปะตู๋​หื้อ​เขา แกะ​ก็​ฟัง​เสียง​ของ​เขา เขา​ฮ้อง​แกะ​ของ​ตั๋ว​เก่า​ต๋าม​จื้อ​ของ​มัน แล้ว​ก็​ปา​แกะ​ออก​จาก​คอก ");
INSERT INTO nod_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","เมื่อ​ต้อน​แกะ​ของ​ตั๋ว​ออก​จาก​คอก​หมด​แล้ว เขา​ก็​เตียว​นำ​หน้า​แกะ แล้ว​แกะ​ก็​ตวย​ก้น​เขา​ไป ย้อน​แกะ​ฮู้จัก​เสียง​คน​เลี้ยง ");
INSERT INTO nod_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","แกะ​จะ​บ่﻿ตวย​คน​อื่น แต่​จะ​หนี​จาก​คน​นั้น​ไป​เหีย ย้อน​บ่﻿ฮู้จัก​เสียง​คน​อื่น​ตี้​บ่﻿ใจ้​คน​เลี้ยง” ");
INSERT INTO nod_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","พระเยซู​อู้​เรื่อง​กำเผียบ​นี้​หื้อ​หมู่​เขา​ฟัง แต่​หมู่​เขา​ก็​บ่﻿เข้าใจ๋​ว่า​พระองค์​หมายเถิง​อะหยัง ");
INSERT INTO nod_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","พระเยซู​อู้​แหม​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า เฮา​เป๋น​ปะตู๋​คอก​แกะ ");
INSERT INTO nod_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","กู้​คน​ตี้​มา​ก่อน​เฮา​ก็​เป๋น​คน​ขี้ลัก​กับ​เป๋น​โจ๋ร แต่​แกะ​ก็​บ่﻿ได้​ฟัง​เสียง​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","เฮา​เป๋น​ปะตู๋ คน​ตี้​เข้า​มา​ตาง​เฮา​ก็​จะ​รอด เขา​จะ​เข้า﻿ๆ ออก﻿ๆ กับ​ปะ​กับ​หญ้า​เขียว​อุ้ม​หุ้ม ");
INSERT INTO nod_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","คน​ขี้ลัก​นั้น​ก็​มา​เปื้อ​ลัก ฆ่า กับ​ทำลาย​เต้าอั้น แต่​เฮา​มา​เปื้อ​คน​ตี้​เป๋น​แกะ​ของ​เฮา​จะ​มี​จีวิต เซิ่ง​บ่﻿ขาด​อะหยัง​เลย ");
INSERT INTO nod_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“เฮา​เป๋น​คน​เลี้ยง​แกะ​ตี้​ดี คน​เลี้ยง​แกะ​ตี้​ดี​นั้น​ก็​ยอม​สละ​จีวิต​ตั๋ว​เก่า​เปื้อ​แกะ​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ลูกจ้าง​บ่﻿ใจ้​คน​เลี้ยง​ตี้​เป๋น​เจ้าของ​แกะ เมื่อ​เขา​หัน​หมาป่า​มา เขา​ก็​จะ​ละ​แกะ​ไว้ แล้ว​หนี​ไป หมาป่า​ก็​จะ​งาบ​เอา​แกะ​ไป​เหีย และ​เยียะ​หื้อ​หมู่​แกะ​แตก​ขะแล​ขะแจ​ไป ");
INSERT INTO nod_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ลูกจ้าง​ก็​หนี ย้อน​เขา​เป๋น​ก้า​ลูกจ้าง กับ​เขา​บ่﻿ได้​ห่วง​แกะ​เลย ");
INSERT INTO nod_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“เฮา​เป๋น​คน​เลี้ยง​แกะ​ตี้​ดี เฮา​ฮู้จัก​แกะ​ของ​เฮา แกะ​ของ​เฮา​ก็​ฮู้จัก​เฮา ");
INSERT INTO nod_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","เหมือน​กับ​ตี้​พระบิดา​ฮู้จัก​เฮา​กับ​เฮา​ก็​ฮู้จัก​พระบิดา แล้ว​เฮา​ก็​สละ​จีวิต​หื้อ​แกะ​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","เฮา​มี​แกะ​ตั๋ว​อื่น​ตี้​บ่﻿ใจ้​ของ​คอก​นี้ แกะ​หมู่​นั้น​เฮา​ก็​ต้อง​ปา​มา​ตวย กับ​แกะ​หมู่​นั้น​ก็​จะ​ฟัง​เสียง​เฮา แล้ว​เฮา​ก็​จะ​เอา​แกะ​มา​เปาะ​เป๋น​หมู่​เดียว​กั๋น​ตี้​มี​คน​เลี้ยง​คน​เดียว​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","พระบิดา​ฮัก​เฮา ย้อน​ว่า​เฮา​ยอม​สละ​จีวิต​ของ​เฮา​เปื้อ​จะ​ฮับ​จีวิต​นั้น​คืน​มา ");
INSERT INTO nod_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","บ่﻿มี​ใผ​เอา​จีวิต​ของ​เฮา​ไป​จาก​เฮา​ได้ แต่​เฮา​เต๋มใจ๋​สละ​จีวิต​ของ​เฮา เฮา​มี​สิทธิ​อำนาจ​ตี้​จะ​สละ​จีวิต​ของ​เฮา กับ​มี​สิทธิ​อำนาจ​ตี้​จะ​เอา​จีวิต​ของ​เฮา​คืน​มา นี่​เป๋น​กำสั่ง​ตี้​พระบิดา​หื้อ​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","บ่ากอง​พระเยซู​อู้​จาอั้น ก็​เกิด​ก๋าน​แตกแยก​กั๋น​แหม​ใน​หมู่​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","หลาย​คน​อู้​ว่า “เขา​โดน​ผี​เข้า​จ๋น​เป๋น​ผีบ้า​ไป​แล้ว ไป​ฟัง​เขา​เยียะ​หยัง” ");
INSERT INTO nod_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","แต่​คน​อื่น​ก็​อู้​ว่า “คน​ตี้​โดน​ผี​เข้า​จะ​อู้​จาอี้​ได้​จาใด ผี​จะ​เยียะ​หื้อ​คน​ต๋า​บอด​ผ่อ​หัน​ได้​ตวย​กา” ");
INSERT INTO nod_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ต๋อน​นั้น​เป๋น​หน้า​หนาว มี​งาน​เลี้ยง​ฉลอง​พระวิหาร​ตี้​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","พระเยซู​ก่ำลัง​เตียว​อยู่​ตี้​ระเบียง​นึ่ง​ใน​พระวิหาร​จื้อ ระเบียง​ของ​ซาโลมอน ");
INSERT INTO nod_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","หมู่​จาว​ยิว​ก็​เข้า​มา​แวด​พระองค์​แล้ว​ก็​ถาม​พระองค์​ว่า “ต้าน​จะ​หื้อ​เฮา​สงสัย​ว่า​ต้าน​เป๋น​ใผ​ไป​แหม​เมิน​เต้าใด ถ้า​ต้าน​เป๋น​พระคริสต์​แต๊​ก็​หื้อ​บอก​เฮา​มา​ซื่อ﻿ๆ เลย” ");
INSERT INTO nod_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","พระเยซู​ก็​ตอบ​ว่า “เฮา​บอก​หมู่​ต้าน​ไป​แล้ว แต่​หมู่​ต้าน​ก็​บ่﻿ยอม​เจื้อ สิ่ง​ตี้​เฮา​เยียะ​โดย​สิทธิ​อำนาจ​ของ​พระบิดา​ก็​เยียะ​หื้อ​หัน​แล้ว​ว่า เฮา​เป๋น​ใผ ");
INSERT INTO nod_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","แต่​หมู่​ต้าน​ก็​บ่﻿เจื้อ​ย้อน​ว่า​หมู่​ต้าน​บ่﻿ใจ้​แกะ​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","แกะ​ของ​เฮา​ก็​ฟัง​เสียง​ของ​เฮา กับ​เฮา​ก็​ฮู้จัก​แกะ​หมู่​นั้น กับ​แกะ​หมู่​นั้น​ก็​ตวย​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","เฮา​หื้อ​จีวิต​นิรันดร์​กับ​แกะ​หมู่​นั้น แกะ​หมู่​นั้น​ก็​จะ​บ่﻿มี​วัน​ฉิบหาย กับ​บ่﻿มี​ใผ​ลู่​เอา​แกะ​หมู่​นั้น​ไป​จาก​มือ​เฮา​ได้ ");
INSERT INTO nod_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","พระบิดา​ของ​เฮา​ผู้​ตี้​หื้อ​แกะ​หมู่​นั้น​กับ​เฮา​ก็​เป๋น​ใหญ่​เหลือ​กู้​สิ่ง​กู้​อย่าง กับ​บ่﻿มี​ใผ​ลู่​เอา​แกะ​หมู่​นั้น​ไป​จาก​พระองค์​ได้ ");
INSERT INTO nod_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","เฮา​กับ​พระบิดา​ก็​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น” ");
INSERT INTO nod_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","หมู่​จาว​ยิว​ก็​เลย​หยิบ​บ่าหิน​ขึ้น​มา​กะ​จะ​ขว้าง​พระองค์​แหม​เตื้อ ");
INSERT INTO nod_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","พระเยซู​ก็​อู้​กับ​หมู่​เขา​ว่า “เฮา​เยียะ​หื้อ​หมู่​ต้าน​หัน​ก๋าน​ดี​หลาย​อย่าง​ตี้​มา​จาก​พระบิดา หมู่​ต้าน​หยิบ​บ่าหิน​ขึ้น​มา​จะ​ขว้าง​เฮา​หื้อ​ต๋าย​ย้อน​ก๋าน​ดี​เรื่อง​ไหน” ");
INSERT INTO nod_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","หมู่​จาว​ยิว​ก็​ตอบ​พระองค์​ว่า “ตี้​เฮา​จะ​เอา​บ่าหิน​ขว้าง​ต้าน บ่﻿ใจ้​ย้อน​ก๋าน​ดี​นั้น​แต่​ย้อน​ว่า​ต้าน​อู้​หมิ่น​ประมาท​พระเจ้า ต้าน​เป๋น​ก้า​คน​แต่​ยก​ตั๋ว​เก่า​เป๋น​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","พระเยซู​ก็​ตอบ​ว่า “ใน​บท​บัญญัติ​ของ​หมู่​ต้าน มี​กำ​ของ​พระเจ้า​ตี้​เขียน​ไว้​บ่﻿ใจ้​กา ว่า ‘พระเจ้า​อู้​ว่า หมู่​ต้าน​เป๋น​เทพเจ้า​ตังหลาย’ ");
INSERT INTO nod_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","เฮา​ฮู้​ว่า​สิ่ง​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​ก็​ถูก​ต้อง​ตลอด แล้ว​พระเจ้า​บ่﻿ได้​อู้​หมิ่น​ประมาท​เมื่อ​ฮ้อง​คน​ตี้​ฮับ​ถ้อยกำ​ของ​พระองค์​ว่า​เป๋น​เทพเจ้า​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","แล้ว​หมู่​ต้าน​จะ​ว่า​หื้อ​คน​ตี้​พระบิดา​เลือก​และ​ใจ๊​มา​ใน​โลก บอก​ว่า ‘ต้าน​อู้​หมิ่น​ประมาท​พระเจ้า’ ย้อน​เฮา​ได้​อู้​ว่า​เฮา​เป๋น​พระบุตร​ของ​พระเจ้า​จาอั้น​กา ");
INSERT INTO nod_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ถ้า​เฮา​บ่﻿เยียะ​ก๋าน​ของ​พระบิดา​ของ​เฮา ก็​บ่﻿ต้อง​เจื้อ​วางใจ๋​ใน​เฮา ");
INSERT INTO nod_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","แต่​ถ้า​เฮา​เยียะ​ก๋าน​ของ​พระบิดา เถิงแม้​ว่า​หมู่​ต้าน​จะ​บ่﻿เจื้อ​วางใจ๋​เฮา ก็​หื้อ​เจื้อ​ใน​ก๋าน​นั้น​เต๊อะ เปื้อ​หมู่​ต้าน​จะ​ได้​ฮู้​กับ​เข้าใจ๋​ว่า พระบิดา​ก็​อยู่​ใน​เฮา​และ​เฮา​ก็​อยู่​ใน​พระบิดา” ");
INSERT INTO nod_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","หมู่​เขา​ก็​ฮิ​จะ​ยับ​พระองค์​แหม​เตื้อ แต่​พระองค์​ก็​รอด​ป๊น​จาก​มือ​หมู่​เขา​ไป​ได้ ");
INSERT INTO nod_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","แล้ว​พระองค์​ก็​ข้าม​แม่น้ำ​จอร์แดน​ไป​แหม​เผิก​นึ่ง ไป​ตี้​ตะก่อน​ยอห์น​เกย​หื้อ​บัพติศมา แล้ว​พระองค์​ก็​ย้าง​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","คน​นัก​ขนาด​ก็​ปา​กั๋น​มา​หา​พระองค์ แล้ว​ก็​อู้​ว่า “ยอห์น​บ่﻿ได้​เยียะ​หมายสำคัญ​อะหยัง​เลย แต่​กู้​สิ่ง​ตี้​ยอห์น​ได้​อู้​เถิง​ป้อจาย​คน​นี้​ก็​เป๋น​ความ​จริง” ");
INSERT INTO nod_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","กับ​มี​หลาย​คน​ตี้​หั้น​เจื้อ​วางใจ๋​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","มี​ป้อจาย​คน​นึ่ง​จื้อ​ลาซารัส​ก่ำลัง​บ่﻿สบาย เขา​อยู่​ตี้​หมู่บ้าน​เบธานี​กับ​มารีย์​ตึง​มารธา​ปี้​สาว​ของ​เขา ");
INSERT INTO nod_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","มารีย์​คน​นี้​เป๋น​แม่ญิง​ตี้​เอา​น้ำมัน​หอม​ถอก​ลง​บน​ตี๋น​ของ​พระเยซู แล้ว​เอา​ผม​ของ​ตั๋ว​เก่า​เจ๊ด​ตี๋น​หื้อ​พระองค์ ลาซารัส​ตี้​บ่﻿สบาย​ก็​เป๋น​น้องบ่าว​ของ​มารีย์​คน​นี้ ");
INSERT INTO nod_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ปี้​สาว​ตึง​สอง​คน​ของ​เขา ก็​ใจ๊​คน​ไป​บอก​พระเยซู​ว่า “อาจ๋ารย์ คน​ตี้​อาจ๋ารย์​ฮัก​ก่ำลัง​บ่﻿สบาย” ");
INSERT INTO nod_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","บ่ากอง​พระเยซู​ได้​ยิน​จาอั้น พระองค์​ก็​อู้​ว่า “สุดต๊าย​แล้ว ผล​ของ​ก๋าน​บ่﻿สบาย​นี้​ก็​บ่﻿ใจ้​ความ​ต๋าย เปื้อ​คน​จะ​ได้​หัน​ความ​ยิ่ง​ใหญ่​ของ​พระเจ้า กับ​ของ​พระบุตร​ของ​พระองค์​ผ่าน​ก๋าน​บ่﻿สบาย​นี้” ");
INSERT INTO nod_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","พระเยซู​ฮัก​มารธา​กับ​น้องสาว​ของ​นาง​ตึง​ลาซารัส​ตวย ");
INSERT INTO nod_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ต๋อน​พระองค์​ได้​ยิน​ว่า​ลาซารัส​บ่﻿สบาย พระองค์​ก็​ยัง​ย้าง​อยู่​ตี้​เก่า​ไป​แหม​สอง​วัน ");
INSERT INTO nod_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","หลังจาก​นั้น​พระองค์​ก็​บอก​กับ​สาวก​ว่า “เฮา​ปิ๊ก​ไป​แคว้น​ยูเดีย​กั๋น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","หมู่​สาวก​ก็​อู้​กับ​พระองค์​ว่า “อาจ๋ารย์ บ่﻿กี่​วัน​มา​นี้​หมู่​จาว​ยิว​ตี้​หั้น​ฮิ​เอา​บ่าหิน​จะ​ขว้าง​อาจ๋ารย์​หื้อ​ต๋าย อาจ๋ารย์​ยัง​จะ​ไป​ตี้​หั้น​แหม​กา” ");
INSERT INTO nod_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","พระเยซู​ตอบ​ว่า “ต๋อน​เมื่อ​วัน​มี​สิบ​สอง​จั้วโมง​บ่﻿ใจ้​กา ถ้า​ใผ​เตียว​ต๋อน​เมื่อ​วัน​ก็​จะ​บ่﻿ข้อง​สะดุด​ย้อน​มี​แสง​สว่าง​ของ​โลก​นี้ ");
INSERT INTO nod_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","แต่​ถ้า​ใผ​เตียว​ต๋อน​เมื่อ​คืน​ก็​จะ​ข้อง​สะดุด​ย้อน​บ่﻿มี​แสง​สว่าง” ");
INSERT INTO nod_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","หลังจาก​ตี้​พระองค์​อู้​จาอั้น​แล้ว พระองค์​ก็​บอก​กับ​หมู่​สาวก​แหม​ว่า “ลาซารัส​เปื้อน​ของ​เฮา​หลับ​ไป​แล้ว แต่​เฮา​จะ​ไป​ตี้​หั้น​เปื้อ​ฮ้อง​เขา​หื้อ​ลุก​ขึ้น​มา” ");
INSERT INTO nod_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","สาวก​ของ​พระองค์​ก็​อู้​ว่า “อาจ๋ารย์ ถ้า​เขา​หลับ​อยู่ เขา​ก็​ยังแควน​ขึ้น​แล้ว​ก้า” ");
INSERT INTO nod_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","พระเยซู​หมายเถิง​ว่า​ลาซารัส​ต๋าย​แล้ว แต่​หมู่​สาวก​กึ๊ด​ว่า​พระองค์​หมายเถิง​เขา​นอน​หลับ​บ่﻿ดาย ");
INSERT INTO nod_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","จาอั้น​พระเยซู​ก็​เลย​อู้​ซื่อ﻿ๆ กับ​หมู่​เขา​ว่า “ลาซารัส​ต๋าย​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","และ​ย้อน​เฮา​หัน​แก่​หมู่​ต้าน เฮา​เถิง​ดีใจ๋​ตี้​บ่﻿ได้​อยู่​ตี้​หั้น เปื้อ​หมู่​ต้าน​จะ​ได้​เจื้อ​วางใจ๋​เฮา​นัก​ขึ้น หมู่​เฮา​ไป​หา​เขา​กั๋น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","โธมัส (​ตี้​เขา​ฮ้อง​กั๋น​ว่า​แฝด​) ก็​อู้​กับ​สาวก​คน​อื่น​ว่า “หมู่​เฮา​ไป​กั๋น​เต๊อะ ไป​ต๋าย​ตวย​กั๋น​กับ​อาจ๋ารย์” ");
INSERT INTO nod_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","บ่ากอง​พระเยซู​ไป​เถิง​หมู่บ้าน​เบธานี ก็​ได้​ข่าว​ว่า​เขา​เอา​ศพ​ลาซารัส​ไป​ฝัง​ไว้​ตี้​อุโมงค์​ฝังศพ​ได้​สี่​วัน​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","หมู่บ้าน​เบธานี​อยู่​ใก้​กรุง​เยรูซาเล็ม​ห่าง​กั๋น​ประมาณ​สาม​กิโลเมตร ");
INSERT INTO nod_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","หมู่​จาว​ยิว​หลาย​คน​ก็​มา​ปลอบใจ๋​มารธา​กับ​มารีย์​ตี้​น้องบ่าว​ของ​หมู่​นาง​ต๋าย ");
INSERT INTO nod_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","เมื่อ​มารธา​ได้​ยิน​ว่า​พระเยซู​มา นาง​ก็​เตียว​ออก​ไป​หา​เปื้อ​ต้อนฮับ​พระองค์ แต่​มารีย์​ยัง​อยู่​ใน​เฮือน ");
INSERT INTO nod_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","แล้ว​มารธา​อู้​กับ​พระเยซู​ว่า “อาจ๋ารย์ ถ้า​อาจ๋ารย์​อยู่​กับ​หมู่​เฮา น้องบ่าว​ข้าเจ้า​ก็​จะ​บ่﻿ต๋าย ");
INSERT INTO nod_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","แต่​เถิง​บ่าเดี่ยว​นี้​ข้าเจ้า​ก็​ฮู้​ว่า​พระเจ้า​จะ​หื้อ​กู้​สิ่ง​กู้​อย่าง​ตี้​อาจ๋ารย์​ขอ” ");
INSERT INTO nod_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","พระเยซู​อู้​ว่า “น้องบ่าว​ของ​เจ้า​จะ​เป๋น​ขึ้น​มา​มี​จีวิต​แหม​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","มารธา​อู้​ว่า “ข้าเจ้า​ฮู้​ว่า​เขา​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ใน​วัน​สุดต๊าย” ");
INSERT INTO nod_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","พระเยซู​อู้​กับ​มารธา​ว่า “เฮา​เป๋น​ผู้​ตี้​เยียะ​หื้อ​คน​เป๋น​ขึ้น​จาก​ความ​ต๋าย​และ​หื้อ​จีวิต​กับ​หมู่​เขา กู้​คน​ตี้​เจื้อ​วางใจ๋​เฮา เถิงแม้​ต๋าย​ไป​แล้ว​ก็​ยัง​มี​จีวิต​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","แล้ว​ใผ​ตี้​ยัง​มี​จีวิต​อยู่​กับ​เจื้อ​วางใจ๋​เฮา เขา​ก็​จะ​บ่﻿มี​วัน​ต๋าย มารธา​เจ้า​เจื้อ​จาอั้น​ก่อ” ");
INSERT INTO nod_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","มารธา​ก็​บอก​พระองค์​ว่า “อาจ๋ารย์ ข้าเจ้า​เจื้อ​ว่า​อาจ๋ารย์​เป๋น​พระคริสต์ เป๋น​พระบุตร​ของ​พระเจ้า​ตี้​ว่า​กั๋น​ว่า​จะ​เข้า​มา​ใน​โลก​นี้” ");
INSERT INTO nod_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","หลังจาก​มารธา​อู้​จาอั้น​แล้ว เขา​ก็​ปิ๊ก​ไป​ฮ้อง​มารีย์​น้องสาว​ของ​เขา​มา​ลัก​อู้​กั๋น​สอง​คน​ว่า “อาจ๋ารย์​มา​แล้ว ต้าน​ถาม​หา​น้อง​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","บ่ากอง​มารีย์​ได้​ยิน​จาอั้น​ก็​ฟั่ง​ลุก​ไป​หา​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","พระองค์​ยัง​บ่﻿เข้า​ไป​ใน​หมู่​บ้าน​เตื้อ พระองค์​ยัง​อยู่​ตี้​เก่า​ตี้​มารธา​ไป​หา ");
INSERT INTO nod_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","แล้ว​หมู่​จาว​ยิว​ตี้​มา​ปลอบใจ๋​มารีย์​หัน​มารีย์​ฟั่ง​ลุก​ออก​จาก​เฮือน​ไป หมู่​เขา​ก็​กึ๊ด​ว่า​มารีย์​จะ​ไป​ไห้​ตี้​อุโมงค์​ฝังศพ หมู่​เขา​ก็​เลย​ตวย​มารีย์​ไป ");
INSERT INTO nod_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","เมื่อ​มารีย์​ไป​เถิง​ตี้ ตี้​พระเยซู​อยู่​ก็​หัน​พระเยซู แล้ว​ก็​ยอบ​ลง​กราบ​ตี้​ตี๋น​ของ​พระองค์ แล้ว​อู้​ว่า “อาจ๋ารย์ ถ้า​อาจ๋ารย์​อยู่​ตี้​นี่​น้องบ่าว​ข้าเจ้า​ก็​จะ​บ่﻿ต๋าย” ");
INSERT INTO nod_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","เมื่อ​พระเยซู​หัน​มารีย์​ไห้ กับ​หมู่​จาว​ยิว​ตี้​ตวย​มารีย์​มา​ตี้​ปา​กั๋น​ไห้​ตวย พระองค์​ก็​บ่﻿ม่วนใจ๋​กับ​ตุ๊ก​ใจ๋ ");
INSERT INTO nod_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","แล้ว​พระองค์​ก็​อู้​ว่า “หมู่​ต้าน​เอา​ศพ​ไป​ไว้​ตี้​ไหน” หมู่​เขา​ก็​ตอบ​ว่า “อาจ๋ารย์ ตวย​มา​ผ่อ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","แล้ว​พระเยซู​ก็​ไห้ ");
INSERT INTO nod_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","หมู่​จาว​ยิว​ตี้​ตวย​มา​อู้​กั๋น​ว่า “ผ่อ​ลอ ป้อจาย​คน​นี้​ฮัก​ลาซารัส​นัก​ขนาด” ");
INSERT INTO nod_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","แต่​บาง​คน​ก็​อู้​ว่า “เขา​เยียะ​หื้อ​คน​ต๋า​บอด​ผ่อ​หัน​ได้ แล้ว​จ้วย​ลาซารัส​บ่﻿หื้อ​ต๋าย​บ่﻿ได้​กา” ");
INSERT INTO nod_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","พระเยซู​ก็​บ่﻿ม่วนใจ๋​แหม​เตื้อ พระองค์​ก็​ไป​เถิง​อุโมงค์​ฝังศพ อุโมงค์​นั้น​เป๋น​ถ้ำ มี​บ่าหิน​ก้อน​ใหญ่​ตึด​ปาก​อุโมงค์​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","แล้ว​พระองค์​ก็​สั่ง​ว่า “กิ้ง​บ่าหิน​ออก​ลอ” มารธา​ปี้​สาว​ของ​ลาซารัส​ก็​อู้​ว่า “อาจ๋ารย์ เขา​ต๋าย​มา​ได้​สี่​วัน​แล้ว บ่าเดี่ยว​ศพ​ก็​เหม็นตึ๊ง​แล้ว​ก่า” ");
INSERT INTO nod_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","พระเยซู​ก็​อู้​ว่า “เฮา​บอก​เจ้า​แล้ว​บ่﻿ใจ้​กา​ว่า ถ้า​เจ้า​เจื้อ​วางใจ๋​เฮา เจ้า​ก็​จะ​หัน​ความ​ยิ่งใหญ่​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","หมู่​เขา​ก็​เลย​กิ้ง​บ่าหิน​ออก แล้ว​พระเยซู​ก็​แหงน​หน้า​ขึ้น​อธิษฐาน​ว่า “ข้า​แต่​พระบิดา ข้า​พระองค์​ขอบคุณ​พระองค์​ตี้​พระองค์​ฟัง​ข้า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","กับ​ข้า​พระองค์​ก็​ฮู้​ว่า​พระองค์​ฟัง​ข้า​พระองค์​ตลอด ตี้​ข้า​พระองค์​อู้​จาอี้​ก็​ย้อน​หัน​แก่​คน​ตังหลาย​ตี้​อยู่​ตี้​นี่ เปื้อ​หมู่​เขา​จะ​ได้​เจื้อ​ว่า​พระองค์​เป๋น​ผู้​ตี้​ใจ๊​ข้า​พระองค์​มา” ");
INSERT INTO nod_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","บ่ากอง​พระเยซู​อู้​จาอั้น​แล้ว พระองค์​ก็​ฮ้อง​เอิ้น​ขึ้น​มา​ว่า “ลาซารัส​เหย ออก​มา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","แล้ว​ลาซารัส​ตี้​ต๋าย​ไป​แล้ว​ก็​เตียว​ออก​มา​จาก​อุโมงค์ มี​ผ้า​ปัน​มือ​ปัน​ตี๋น​กับ​หน้า​เขา​อยู่ พระเยซู​ก็​เลย​บอก​คน​ตังหลาย​ว่า “แก้​ผ้า​ตี้​ปัน​เขา​ออก หื้อ​เขา​เตียว​ไป” ");
INSERT INTO nod_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","หมู่​จาว​ยิว​ตี้​มา​หา​มารีย์​ได้​หัน​สิ่ง​ตี้​พระเยซู​เยียะ ก็​ปา​กั๋น​เจื้อ​วางใจ๋​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","แต่​มี​บาง​คน​ใน​หมู่​นั้น​ไป​เล่า​สิ่ง​ตี้​หัน​พระเยซู​เยียะ​หื้อ​หมู่​ฟาริสี​ฟัง ");
INSERT INTO nod_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","แล้ว​หมู่​หัว​หน้า​ปุโรหิต​กับ​หมู่​ฟาริสี​ก็​ฮ้อง​ประชุม​สภา​แซนเฮดริน แล้ว​หมู่​เขา​อู้​กั๋น​ว่า “หมู่​เฮา​จะ​เยียะ​จาใด​ดี ป้อจาย​คน​นี้​เยียะ​หมายสำคัญ​หลาย​อย่าง​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ถ้า​เฮา​ป่อย​หื้อ​เขา​เยียะ​จาอี้​ไป​ติก﻿ๆ คน​ตังหลาย​ก็​จะ​ปา​กั๋น​ไป​เจื้อ​เขา​เหีย​หมด แล้ว​หมู่​โรมัน​ก็​จะ​มา​ทำลาย​ตึง​พระวิหาร​และ​ตึง​จ้าด​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","แต่​มี​ป้อจาย​คน​นึ่ง​ใน​หมู่​นั้น​จื้อ คายาฟาส เขา​เป๋น​มหา​ปุโรหิต​ใน​ปี๋​นั้น เขา​ก็​อู้​ว่า “หมู่​ต้าน​บ่﻿ฮู้​อะหยัง​เลย ");
INSERT INTO nod_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","หมู่​ต้าน​บ่﻿เข้าใจ๋​ว่า สำหรับ​หมู่​ต้าน​แล้ว จะ​หื้อ​ป้อจาย​คน​นึ่ง​ต๋าย​เปื้อ​คน​ตึง​หมด ก็​ยัง​ดี​เหลือ​หื้อ​คน​ใน​จ้าด​ตึง​หมด​โดน​ทำลาย” ");
INSERT INTO nod_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","คายาฟาส​บ่﻿ได้​อู้​จาอี้​ขึ้น​มา​คน​เดียว แต่​ย้อน​ว่า​เขา​เป๋น​มหา​ปุโรหิต​ใน​ปี๋​นั้น พระเจ้า​ก็​เลย​หื้อ​เขา​อู้​เป๋น​กำ​ตวายตั๊ก​ว่า​พระเยซู​จะ​ต๋าย​เปื้อ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","และ​พระองค์​บ่﻿ได้​ต๋าย​เปื้อ​จาว​ยิว​เต้าอั้น แต่​เปื้อ​จะ​รวม​คน​ของ​พระเจ้า​ตี้​แตก​ขะแล​ขะแจ​ไป​ใคว่​โลก​หื้อ​มา​อยู่​เป๋น​หมู่​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ตั้งแต่​วัน​นั้น​หมู่​ผู้นำ​จาว​ยิว​ก็​วางแผน​จะ​ฆ่า​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","พระองค์​ก็​เลย​บ่﻿ออก​ไป​ไหน​มา​ไหน​อย่าง​เปิดเผย​ใน​ตี้​ตี้​มี​หมู่​จาว​ยิว แต่​ออก​จาก​หมู่บ้าน​เบธานี​ไป​ตี้​หมู่บ้าน​เอฟราอิม อยู่​ใก้﻿ๆ ตี้​กั๋นดาร​แห้งแล้ง แล้ว​พระองค์​กับ​หมู่​สาวก​ก็​ย้าง​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ต๋อน​เมื่อ​ใก้​เถิง​งาน​ปัสกา​ของ​จาว​ยิว หลาย​คน​ตี้​ลุก​บ้าน​นอก​มา​ก็​ปา​กั๋น​เข้า​ไป​ใน​กรุง​เยรูซาเล็ม​เปื้อ​เยียะ​พิธี​ล้าง​ตั๋ว​หื้อ​บริสุทธิ์​ก่อน​งาน​นั้น ");
INSERT INTO nod_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","แล้ว​คน​ตังหลาย​ก็​ปา​กั๋น​เซาะ​ผ่อ​หา​พระเยซู ต๋อน​ตี้​อยู่​ใน​พระวิหาร​หมู่​เขา​ก็​ถาม​กั๋น​ว่า “ต้าน​กึ๊ด​จาใด ป้อจาย​คน​นั้น​จะ​มา​งาน​ก่อ” ");
INSERT INTO nod_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","แต่​หมู่​หัว​หน้า​ปุโรหิต​กับ​หมู่​ฟาริสี​ได้​สั่ง​คน​ตังหลาย​ว่า ถ้า​ใผ​หัน​พระเยซู​อยู่​ตี้​ไหน ก็​ต้อง​มา​บอก​หมู่​เขา เปื้อ​หมู่​เขา​จะ​ไป​ยับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ก่อน​เถิง​งาน​ปัสกา​หก​วัน พระเยซู​ก็​มา​ตี้​หมู่บ้าน​เบธานี​เซิ่ง​เป๋น​หมู่​บ้าน​ตี้​ลาซารัส​อยู่ ลาซารัส​คน​นี้​ตี้​พระองค์​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","หมู่​คน​ตี้​หั้น​จัด​งานเลี้ยง​หื้อ​พระองค์ มารธา​ก็​จ้วย​ผ่อ​กอย​เรื่อง​ของกิ๋น​ของ​ว่า ต๋อน​นั้น​ลาซารัส​ก็​นั่ง​กิ๋น​ข้าว​อยู่​โต๊ะ​เดียว​กั๋น​กับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","มารีย์​เอา​น้ำมัน​หอม​นารดา​บริสุทธิ์​รากา​แปง​มา​ประมาณ​เกิ่ง​ลิตร แล้ว​ก็​ถอก​ใส่​ตี๋น​ของ​พระเยซู แล้ว​เอา​ผม​ของ​ตั๋ว​เก่า​เจ๊ด​ตี๋น​หื้อ​พระองค์ ใคว่​ตึง​บ้าน​ก็​หอม​น้ำมัน​หอม​นั้น​ขนาด ");
INSERT INTO nod_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","แต่​ยูดาส อิสคาริโอท สาวก​คน​นึ่ง​ของ​พระเยซู คน​ตี้​จะ​หักหลัง​พระองค์ ก็​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“เยียะ​หยัง​บ่﻿เอา​น้ำมัน​หอม​นี้​ไป​ขาย แล้ว​เอา​สตางค์​มา​ปั๋น​หื้อ​กับ​คน​ตุ๊ก​คน​จ๋น ถ้า​ขาย​จะ​ได้​สตางค์​เหรียญ​เถิง​สาม​ร้อย” ");
INSERT INTO nod_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ตี้​ยูดาส​อู้​จาอี้​บ่﻿ใจ้​ว่า​เขา​เป๋น​ห่วง​คน​ตุ๊ก แต่​ย้อน​ว่า​เขา​เป๋น​คน​ขี้ลัก ซอบ​ลัก​สตางค์​ใน​ถง​สตางค์​ส่วน​รวม​ตี้​เขา​เป๋น​คน​ผ่อ ");
INSERT INTO nod_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","พระเยซู​ก็​อู้​ว่า “ห้าม​ว่า​หื้อ​นาง นาง​เยียะ​จาอี้​เปื้อ​จะ​เกียม​ก๋าน​ฝัง​ศพ​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","คน​ตุ๊ก​คน​จ๋น​จะ​ยัง​อยู่​ตวย​หมู่​ต้าน​ไป​ตลอด แต่​เฮา​จะ​บ่﻿อยู่​ตวย​หมู่​ต้าน​ไป​ตลอด” ");
INSERT INTO nod_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","บ่ากอง​หมู่​จาว​ยิว​จ๋ำนวน​นัก​ได้​ยิน​ว่า​พระเยซู​อยู่​ตี้​หมู่บ้าน​เบธานี หมู่​เขา​ก็​เลย​ปา​กั๋น​ไป​ตี้​หั้น ย้อน​ใค่​หัน​พระเยซู​กับ​ลาซารัส คน​ตี้​พระเยซู​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","จาอั้น หมู่​หัว​หน้า​ปุโรหิต​ก็​เลย​วางแผน​จะ​ฆ่า​ลาซารัส​ตวย ");
INSERT INTO nod_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ย้อน​ลาซารัส​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แต๊﻿ๆ หมู่​จาว​ยิว​หลาย​คน​ก็​เลย​ละ​หมู่​ผู้นำ​จาว​ยิว​แล้ว​ไป​เจื้อ​วางใจ๋​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","แหม​วัน​นึ่ง​คน​นัก​ขนาด​ตี้​มา​ฮ่วม​งาน​ปัสกา ได้ยิน​ว่า​พระเยซู​ก่ำลัง​เข้า​มา​ตี้​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","หมู่​เขา​ก็​ปา​กั๋น​เอา​กิ่ง​ปาล์ม​ไป​ต้อนฮับ​พระองค์​แล้ว​โห่​ฮ้อง​ว่า “โฮซันนา” “ขอ​พระเจ้า​ปั๋น​ปอน​ผู้​ตี้​มา​ใน​นาม​องค์​พระผู้เป๋นเจ้า​เต๊อะ​เน่อ” “ขอ​พระเจ้า​ปั๋น​ปอน​กษัตริย์​อิสราเอล​เต๊อะ​เน่อ” ");
INSERT INTO nod_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","พระเยซู​เอา​ลูก​ลา​ตั๋ว​นึ่ง​ขี่​มา อย่าง​ใน​พระคัมภีร์​ตี้​เขียน​ไว้​ว่า ");
INSERT INTO nod_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“จาว​เมือง​ศิโยน​เหย บ่﻿ต้อง​กั๋ว ผ่อ​หั้น​ลอ กษัตริย์​ของ​หมู่​เจ้า​ก่ำลัง​มา พระองค์​ขี่​ลูก​ลา​อยู่” ");
INSERT INTO nod_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ใน​ต๋อน​นั้น​หมู่​สาวก​ของ​พระองค์​ยัง​บ่﻿เข้าใจ๋​เรื่อง​นี้ แต่​หลัง​จาก​ตี้​พระเยซู​ได้ฮับ​เกียรติ​อัน​ยิ่งใหญ่​แล้ว หมู่​เขา​ก็​กึ๊ด​ขึ้น​ได้​ว่า พระคัมภีร์​ได้​เขียน​เกี่ยวกับ​พระเยซู​เถิง​เรื่อง​นี้​ไว้ กับ​หมู่​เขา​เป๋น​คน​ตี้​ได้​เยียะ​จาอั้น​หื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","หมู่​คน​ตี้​อยู่​กับ​พระเยซู​ต๋อน​ตี้​พระองค์​ฮ้อง​ลาซารัส​ออก​จาก​อุโมงค์​ฝัง​ศพ กับ​เยียะ​หื้อ​ลาซารัส​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น ก็​เป๋น​พยาน​ใน​สิ่ง​ตี้​เขา​ได้​ยิน​ได้​หัน​มา ");
INSERT INTO nod_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","จาอั้น​หลาย​คน​ก็​ปา​กั๋น​มา​หา​พระเยซู ย้อน​ได้ยิน​ว่า​พระองค์​เยียะ​หมายสำคัญ​นี้ ");
INSERT INTO nod_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","หมู่​ฟาริสี​ก็​อู้​กั๋น​ว่า “หัน​ก่อ หมู่​เฮา​เยียะ​อะหยัง​เขา ก็​บ่﻿สำเร็จ​สัก​อย่าง คน​ตึง​โลก​ปา​กั๋น​ไป​ติดต๋าม​เขา​เหีย​หมด” ");
INSERT INTO nod_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","มี​จาว​กรีก​บาง​คน​ใน​คน​ตังหลาย​ตี้​ขึ้น​ไป​นมัสก๋าน​พระเจ้า​ตี้​กรุง​เยรูซาเล็ม​ใน​หละหว่าง​งาน​ปัสกา ");
INSERT INTO nod_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","แล้ว​หมู่​เขา​ก็​ไป​หา​สาวก​ของ​พระเยซู​คน​นึ่ง จื้อ ฟีลิป ตี้​มา​จาก​หมู่บ้าน​เบธไซดา​ใน​แคว้น​กาลิลี แล้ว​ก็​ขอ​ฟีลิป​ว่า “ต้าน​ครับ เฮา​ใค่​ปะ​พระเยซู” ");
INSERT INTO nod_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ฟีลิป​ก็​เลย​ไป​บอก​อันดรูว์ แล้ว​เขา​ตึง​สอง​คน​ก็​ไป​บอก​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","พระเยซู​ก็​อู้​ว่า “เถิง​เวลา​แล้ว​ตี้​พระเจ้า​จะ​เยียะ​หื้อ​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​บุตรมนุษย์ ");
INSERT INTO nod_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า ถ้า​เม็ด​ข้าว​แห้ง​แล้ว​ตก​ลง​ดิน ก็​จะ​งอก​ขึ้น​มา​หื้อ​ผล​แหม​หลาย​เม็ด แต่​ถ้า​บ่﻿ตก​ลง​ดิน ก็​จะ​เป๋น​ก้า​เม็ด​ข้าว​เม็ด​เดียว​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","คน​ใด​ตี้​ใจ๊​จีวิต​หันแก่​ตั๋ว​เก่า​ใน​โลก​นี้ คน​นั้น​ก็​ฮักษา​จีวิต​นั้น​บ่﻿ได้​ก็​จะ​ต๋าย แต่​ถ้า​ใผ​ใจ๊​จีวิต​บ่﻿หัน​แก่​ตั๋ว​ใน​โลก​นี้ ก็​จะ​ฮักษา​จีวิต​ไว้​ได้​จ๋น​ฮับ​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ใผ​ตี้​ฮับใจ๊​เฮา ก็​ต้อง​ติดต๋าม​หลาม​ตวย​เฮา​มา เฮา​อยู่​ตี้​ไหน ผู้​ฮับใจ๊​ของ​เฮา​ก็​จะ​อยู่​ตี้​หั้น​ตวย ใผ​ตี้​ฮับใจ๊​เฮา พระเจ้า​ก็​จะ​ยกย่อง​คน​นั้น ");
INSERT INTO nod_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“บ่าเดี่ยว​นี้​เฮา​ตุ๊ก​อก​ตุ๊ก​ใจ๋​ขนาด จะ​อู้​จาใด​ดี จะ​หื้อ​เฮา​อู้​ว่า ‘พระบิดา​เจ้าข้า ขอ​โผด​จ้วย​ข้า​พระองค์​หื้อ​ป๊น​เวลา​แห่ง​ความ​ตุ๊กยาก​นี้​ตวย​เต๊อะ’ จาอั้น​กา บ่﻿ใจ้ ตี้​เฮา​มา​ใน​โลก​ก็​เปื้อ​เวลา​แห่ง​ความ​ตุ๊กยาก​นี้ ");
INSERT INTO nod_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ข้า​แต่​พระบิดา ขอ​หื้อ​คน​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​พระองค์” แล้ว​ก็​มี​เสียง​อู้​จาก​ต๊องฟ้า​ว่า “เฮา​ได้​เยียะ​หื้อ​หัน​ความ​ยิ่งใหญ่​แล้ว กับ​จะ​เยียะ​หื้อ​หัน​แหม” ");
INSERT INTO nod_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","เมื่อ​คน​ตี้​อยู่​หั้น​ได้ยิน​เสียง​นั้น บาง​คน​ก็​อู้​ว่า​เป๋น​เสียง​ฟ้า​ฮ้อง แต่​คน​อื่น​อู้​ว่า “ทูตสวรรค์​อู้​กับ​ต้าน” ");
INSERT INTO nod_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","แล้ว​พระเยซู​ก็​บอก​กับ​หมู่​เขา​ว่า “เสียง​นี้​ก็​เปื้อ​หมู่​ต้าน​บ่﻿ใจ้​เปื้อ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","เถิง​เวลา​ตี้​จะ​ตัดสิน​ลงโต้ษ​โลก​แล้ว ผู้​ปกครอง​แห่ง​โลก​นี้​ก็​จะ​โดน​ไล่​ออก​ไป ");
INSERT INTO nod_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","เมื่อ​เฮา​ถูก​ยก​ขึ้น​จาก​แผ่นดิน​โลก เฮา​ก็​จะ​จั๊ก​นำ​กู้​คน​มา​เจื้อ​วางใจ๋​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","พระเยซู​อู้​จาอี้​เปื้อ​บอก​หื้อ​ฮู้​ว่า​พระองค์​จะ​ต๋าย​จาใด ");
INSERT INTO nod_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","คน​ตังหลาย​ก็​อู้​ว่า “บท​บัญญัติ​บอก​หมู่​เฮา​ไว้​ว่า พระคริสต์​จะ​มี​จีวิต​ตลอด​ไป แล้ว​เยียะ​หยัง​ต้าน​อู้​ว่า ‘บุตรมนุษย์​จะ​ต้อง​ถูก​ยก​ขึ้น’ กับ ‘บุตรมนุษย์’ เป๋น​ใผ” ");
INSERT INTO nod_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","พระเยซู​อู้​ว่า “แสงแจ้ง​ของ​เฮา​จะ​อยู่​กับ​หมู่​ต้าน​ไป​แหม​สัก​บึด​สัก​เมื่อ หื้อ​เตียว​ไป​ต๋อน​ตี้​ยัง​มี​แสงแจ้ง​อยู่ เปื้อ​ความ​มืด​จะ​ตวย​บ่﻿ตัน​ต้าน ย้อน​คน​ตี้​เตียว​ใน​ความ​มืด​ก็​จะ​บ่﻿หัน​ว่า​ก่ำลัง​เตียว​ไป​ตาง​ใด ");
INSERT INTO nod_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ต๋อน​ตี้​ยัง​มี​แสงแจ้ง​ของ​เฮา​อยู่ ก็​หื้อ​เจื้อ​วางใจ๋​ใน​แสงแจ้ง​นั้น​เต๊อะ เปื้อ​ว่า​ต้าน​จะ​ได้​เป๋น​ลูก​ของ​ความ​เป่งแจ้ง” บ่ากอง​พระเยซู​อู้​จบ​แล้ว ก็​ละ​หมู่​เขา​ไป​แล้ว​ซ่อน​ตั๋ว​จาก​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","เถิงแม้​ว่า​พระเยซู​เยียะ​หมายสำคัญ​หลาย​อย่าง​หื้อ​หมู่​เขา​หัน แต่​หมู่​เขา​ก็​ยัง​บ่﻿เจื้อ​วางใจ๋​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​อู้​ไว้​ว่า “องค์​พระผู้เป๋นเจ้า มี​ใผ​พ่อง​ตี้​เจื้อ​กำ​อู้​ของ​หมู่​เฮา และ​พระองค์​แสดง​ฤทธิ์​อำนาจ​หื้อ​ใผ​ผ่อ” ");
INSERT INTO nod_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","จาอั้น​หมู่​เขา​ก็​เลย​เจื้อ​พระองค์​บ่﻿ได้ ย้อน​ว่า​อิสยาห์​อู้​ไว้​แหม​ว่า ");
INSERT INTO nod_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“พระเจ้า​เยียะ​หื้อ​ต๋า​หมู่​เขา​บอด และ​เยียะ​หื้อ​จิตใจ๋​หมู่​เขา​หลึกหลึ่ง เปื้อ​ว่า​ต๋า​หมู่​เขา​จะ​ผ่อ​บ่﻿หัน กับ​จิตใจ๋​หมู่​เขา​ก็​จะ​บ่﻿เข้าใจ๋ หมู่​เขา​จะ​ได้​บ่﻿ปิ๊ก​มา​หา​เฮา​เปื้อ​หื้อ​เฮา​ฮักษา​หมู่​เขา​หื้อ​หาย​ดี” ");
INSERT INTO nod_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","อิสยาห์​อู้​จาอี้​ก็​ย้อน​ว่า เขา​ได้​หัน​ความ​ยิ่งใหญ่​ของ​พระเยซู​ล่วงหน้า​แล้ว และ​อู้​เถิง​พระองค์​ไว้ ");
INSERT INTO nod_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","แต่​ต๋อน​นั้น​มี​หลาย​คน ตึง​หมู่​ผู้​นำ​จาว​ยิว​ก็​เจื้อ​วางใจ๋​พระองค์ แต่​เขา​ก็​บ่﻿ก้า​ยอมฮับ​พระองค์​อย่าง​เปิดเผย ย้อน​กั๋ว​ตี้​หมู่​ฟาริสี​จะ​ไล่​หมู่​เขา​ออก​จาก​สมาชิก​ธรรมศาลา ");
INSERT INTO nod_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ย้อน​ว่า​หมู่​เขา​ซอบ​กำ​ยกย่อง​ของ​คน​นัก​เหลือ​กำ​ยกย่อง​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","พระเยซู​ฮ้องเอิ้น​ว่า “ใผ​ตี้​เจื้อ​วางใจ๋​เฮา เขา​บ่﻿ได้​เจื้อ​วางใจ๋​ก้า​เฮา​เต้าอั้น แต่​เขา​เจื้อ​วางใจ๋​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","คน​ตี้​ผ่อ​หัน​เฮา เขา​ก็​หัน​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","เฮา​เข้า​มา​เป๋น​ความ​เป่งแจ้ง​หื้อ​โลก เปื้อ​กู้​คน​ตี้​เจื้อ​วางใจ๋​เฮา​จะ​บ่﻿อยู่​ใน​ความ​มืด ");
INSERT INTO nod_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“คน​ตี้​ได้ยิน​กำสอน​ของ​เฮา​แล้ว​บ่﻿เจื้อ​ฟัง เฮา​บ่﻿ตัดสิน​ลงโต้ษ​เขา ย้อน​ว่า​เฮา​บ่﻿ได้​มา​เปื้อ​ตัดสิน​ลงโต้ษ​โลก​นี้ แต่​เฮา​มา​เปื้อ​จ้วย​โลก​นี้​หื้อ​รอด​ป๊น​บาป​โต้ษ ");
INSERT INTO nod_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ถ้า​ใผ​บ่﻿ยอมฮับ​เฮา​และ​บ่﻿ฮับ​กำ​อู้​ของ​เฮา จะ​มี​อย่าง​นึ่ง​ตี้​จะ​ตัดสิน​ลงโต้ษ​เขา คือ​กำ​ตี้​เฮา​ได้​อู้​ไป​แล้ว​นั้น​เนาะ จะ​ตัดสิน​ลงโต้ษ​เขา​ใน​วัน​สุดต๊าย ");
INSERT INTO nod_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ย้อน​กำ​อู้​หมู่​นี้​เฮา​บ่﻿ได้​อู้​ต๋ามใจ๋​ตั๋วเก่า แต่​พระบิดา​ผู้​ตี้​ใจ๊​เฮา​มา​สั่ง​เฮา​ว่า​จะ​อู้​อะหยัง​อย่างใด​พ่อง ");
INSERT INTO nod_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","แล้ว​เฮา​ก็​ฮู้​ว่า​กำสั่ง​ของ​พระองค์​นั้น​จะ​นำ​ไป​เถิง​จีวิต​นิรันดร์ เฮา​เลย​อู้​ต๋าม​ตี้​พระบิดา​สั่ง​หื้อ​อู้” ");
INSERT INTO nod_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ก่อน​เถิง​งาน​ปัสกา พระเยซู​ฮู้​ว่า​เถิง​เวลา​แล้ว​ตี้​พระองค์​จะ​ต้อง​จาก​โลก​นี้​ปิ๊ก​ไป​หา​พระบิดา พระองค์​ฮัก​หมู่​คน​ตี้​ติดต๋าม​พระองค์​เซิ่ง​อยู่​ใน​โลก​นี้​ตลอด​มา กับ​พระองค์​ก็​เยียะ​หื้อ​หมู่​เขา​หัน​ว่า​พระองค์​ฮัก​หมู่​เขา​มอก​ใด ");
INSERT INTO nod_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ต๋อน​ตี้​ก่ำลัง​กิ๋น​ข้าวแลง​กั๋น​อยู่ มาร​ได้​เยียะ​หื้อ​ใจ๋​ของ​ยูดาส อิสคาริโอท ลูกบ่าว​ของ​ซีโมน กึ๊ด​จะ​หักหลัง​พระเยซู​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","พระองค์​ก็​ฮู้​ว่า​พระเจ้า​หื้อ​พระองค์​มี​อำนาจ​เหนือ​กู้​สิ่ง​กู้​อย่าง กับ​พระองค์​มา​จาก​พระเจ้า​แล้ว​ก่ำลัง​จะ​ปิ๊ก​ไป​หา​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","พระเยซู​ก็​ลุก​ขึ้น​จาก​โต๊ะ ถอด​เสื้อ​คุม​ออก แล้ว​เอา​ผ้า​เจ๊ด​ตั๋ว​มัด​แอว​ไว้ ");
INSERT INTO nod_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","แล้ว​พระองค์​ก็​ถอก​น้ำ​ใส่​กะละมัง​เอา​ไป​ล้าง​ตี๋น​หื้อ​หมู่​สาวก แล้ว​เอา​ผ้า​ตี้​มัด​แอว​เจ๊ด​ตี๋น​หื้อ​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","เมื่อ​ล้าง​มา​เถิง​ซีโมน​เปโตร เขา​ก็​ถาม​พระองค์​ว่า “องค์​พระผู้เป๋นเจ้า ต้าน​จะ​ล้าง​ตี๋น​หื้อ​เฮา​ตวย​กา” ");
INSERT INTO nod_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","พระเยซู​ตอบ​ว่า “ต๋อน​นี้​ตี้​เฮา​เยียะ​จาอี้ ต้าน​ยัง​บ่﻿เข้าใจ๋​เตื้อ แต่​แหม​หน้อย​ต้าน​จะ​เข้าใจ๋” ");
INSERT INTO nod_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ซีโมน​เปโตร​ก็​เลย​อู้​ว่า “เฮา​บ่﻿มี​วัน​ยอม​หื้อ​พระองค์​ล้าง​ตี๋น​หื้อ​เฮา​แน่นอน” พระเยซู​ก็​เลย​อู้​ว่า “ถ้า​เฮา​บ่﻿ได้​ล้าง​หื้อ​ต้าน ต้าน​ก็​บ่﻿ได้​เป๋น​คน​ของ​เฮา​แหม” ");
INSERT INTO nod_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ซีโมน​เปโตร​ก็​อู้​ว่า “อาจ๋ารย์​ถ้า​เป๋น​จาอั้น บ่﻿ใจ้​ก้า​ตี๋น​ของ​เฮา แต่​ขอ​หื้อ​ล้าง​ตึง​มือ​ตึง​หัว​ของ​เฮา​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","พระเยซู​ก็​อู้​ว่า “คน​ตี้​อาบ​น้ำ​ก็​สะอาด​ตึง​ตั๋ว​แล้ว ล้าง​ก้า​ตี๋น​ก็​ปอ หมู่​ต้าน​สะอาด​แล้ว แต่​บ่﻿ใจ้​กู้​คน” ");
INSERT INTO nod_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","พระองค์​ฮู้​ว่า​ใผ​จะ​หักหลัง​พระองค์ ย้อน​จาอั้น​พระองค์​ก็​เลย​อู้​ว่า “บ่﻿ใจ้​กู้​คน​ตี้​สะอาด” ");
INSERT INTO nod_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","บ่ากอง​พระเยซู​ล้าง​ตี๋น​หื้อ​หมู่​สาวก​แล้ว พระองค์​ก็​ใส่​เสื้อ​คุม​ปิ๊ก​ไป​นั่ง​ตี้​เก่า แล้ว​พระองค์​ก็​ถาม​ว่า “ตี้​เฮา​เยียะ​จาอี้​หื้อ​หมู่​ต้าน หมู่​ต้าน​เข้าใจ๋​ก่อ ");
INSERT INTO nod_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","หมู่​ต้าน​ฮ้อง​เฮา​ว่า ‘อาจ๋ารย์’ กับ ‘องค์​พระผู้เป๋นเจ้า’ ตี้​หมู่​ต้าน​ฮ้อง​จาอั้น​ก็​แม่น​แล้ว ย้อน​เฮา​เป๋น​จาอั้น​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ถ้า​เฮา​ตี้​เป๋น​อาจ๋ารย์​กับ​องค์​พระผู้เป๋นเจ้า​ยัง​ล้าง​ตี๋น​หื้อ​หมู่​ต้าน หมู่​ต้าน​ก็​ควร​จะ​ล้าง​ตี๋น​หื้อ​กั๋น​ตวย ");
INSERT INTO nod_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","เฮา​ได้​เยียะ​เป๋น​ตั๋วอย่าง​หื้อ​หมู่​ต้าน​ผ่อ​แล้ว ก็​หื้อ​หมู่​ต้าน​เยียะ​ต๋าม​ตี้​เฮา​ได้​เยียะ ");
INSERT INTO nod_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ฮับใจ๊​บ่﻿ใหญ่​เหลือ​เจ้านาย​ของ​เขา กับ​คน​ส่ง​ข่าว​ก็​บ่﻿ใหญ่​เหลือ​ผู้​ตี้​ใจ๊​เขา​มา ");
INSERT INTO nod_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ถ้า​หมู่​ต้าน​เข้าใจ๋​กับ​เยียะ​ต๋าม​สิ่ง​นี้ หมู่​ต้าน​ก็​เป๋น​สุข” ");
INSERT INTO nod_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“เฮา​บ่﻿ได้​หมายเถิง​หมู่​ต้าน​กู้​คน เฮา​ฮู้จัก​คน​ตี้​เฮา​เลือก​ไว้ แต่​จะ​ต้อง​เป๋น​แต๊​ต๋าม​พระคัมภีร์​ตี้​อู้​ไว้​ว่า ‘คน​ตี้​กิ๋น​ของกิ๋น​เฮา ก็​ก๋าย​เป๋น​ศัตรู๋​ของ​เฮา’ ");
INSERT INTO nod_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","เฮา​บอก​หมู่​ต้าน​ไว้​บ่าเดี่ยว​นี้ ก่อน​ตี้​เรื่อง​นี้​จะ​เกิด​ขึ้น ก็​เปื้อ​ว่า เมื่อ​เกิด​เหตุก๋ารณ์​นั้น​หมู่​ต้าน​ก็​จะ​เจื้อ​ว่า​เฮา​เป๋น​คน​นั้น​ตี้​เฮา​บอก​ว่า​เฮา​เป๋น ");
INSERT INTO nod_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ตี้​ยอมฮับ​คน​ตี้​เฮา​ใจ๊​ไป ก็​ยอมฮับ​เฮา​ตวย กับ​คน​ตี้​ยอมฮับ​เฮา​ก็​ยอมฮับ​ผู้​ตี้​ใจ๊​เฮา​มา” ");
INSERT INTO nod_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","บ่ากอง​พระเยซู​อู้​จาอั้น​แล้ว พระองค์​ก็​ตุ๊ก​อก​ตุ๊ก​ใจ๋​ขนาด แล้ว​ก็​อู้​ออก​มา​อย่าง​เปิดเผย​ว่า “เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​นึ่ง​ใน​หมู่​ต้าน​จะ​หักหลัง​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","แล้ว​หมู่​สาวก​ก็​ผ่อ​หน้า​กั๋น ใค่​ฮู้​ว่า​พระองค์​อู้​เถิง​ใผ ");
INSERT INTO nod_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","มี​สาวก​คน​นึ่ง​ตี้​พระองค์​ฮัก​เอน​ตั๋ว​นอน​กิ๋น​ข้าว​ข้าง​พระองค์​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ซีโมน​เปโตร ก็​ส่ง​ซิก​หื้อ​เขา​ถาม​พระองค์​ว่า พระองค์​อู้​เถิง​ใผ ");
INSERT INTO nod_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","สาวก​คน​นั้น​ก็​เอน​ตั๋ว​เข้า​ไป​ใก้﻿ๆ พระเยซู แล้ว​ถาม​พระองค์​ว่า “อาจ๋ารย์ ต้าน​อู้​เถิง​ใผ​ครับ” ");
INSERT INTO nod_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","พระเยซู​ตอบ​ว่า “คน​นั้น​ก็​คือ​คน​ตี้​เฮา​จะ​เอา​เข้าหนมปัง​จุ่ม​ลง​ใน​ถ้วย​นี้ แล้ว​ยื่น​หื้อ​เขา” แล้ว​พระองค์​ก็​เอา​เข้าหนมปัง​จุ่ม​ลง​ใน​ถ้วย​แล้ว​ยื่น​หื้อ​ยูดาส อิสคาริโอท ลูกบ่าว​ของ​ซีโมน ");
INSERT INTO nod_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","เมื่อ​ยูดาส​ฮับ​เข้าหนมปัง​ไป ซาต๋าน​ก็​เข้า​เขา พระเยซู​ก็​อู้​กับ​เขา​ว่า “จะ​เยียะ​อะหยัง​ก็​ขะใจ๋​เยียะ​เหีย” ");
INSERT INTO nod_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","กู้​คน​ตี้​เอน​ตั๋ว​นอน​อยู่​ตี้​หั้น บ่﻿เข้าใจ๋​ว่า​เยียะ​หยัง​พระเยซู​อู้​กับ​ยูดาส​จาอั้น ");
INSERT INTO nod_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","บาง​คน​ก็​กึ๊ด​ว่า ย้อน​ยูดาส​เป๋น​คน​ผ่อ​ถง​สตางค์ พระเยซู​เลย​บอก​หื้อ​เขา​ไป​ซื้อ​ของ​ตี้​จะ​ใจ๊​ใน​งาน กาว่า​พระองค์​บอก​หื้อ​ยูดาส​แจก​ของ​หื้อ​คน​ตุ๊ก​พ่อง ");
INSERT INTO nod_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","บ่ากอง​ยูดาส​ฮับ​เข้าหนมปัง​นั้น เขา​ก็​ออก​ไป​บ่า​เดี่ยว​นั้น​เลย ต๋อน​นั้น​เป๋น​เมื่อคืน​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","หลังจาก​ตี้​ยูดาส​ออก​ไป​แล้ว พระเยซู​ก็​อู้​ว่า “เถิง​เวลา​แล้ว​ตี้​คน​จะ​ได้​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​บุตรมนุษย์ แล้ว​พระเจ้า​จะ​ได้​ฮับ​เกียรติ​ผ่าน​ตาง​พระองค์​ตวย ");
INSERT INTO nod_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ถ้า​พระเจ้า​ได้ฮับ​เกียรติ​ผ่าน​ตาง​บุตรมนุษย์ พระเจ้า​ก็​จะ​เยียะ​หื้อ​บุตรมนุษย์​ได้ฮับ​เกียรติ​ตวย กับ​พระเจ้า​จะ​เยียะ​บ่าเดี่ยว​นี้ ");
INSERT INTO nod_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“ลูก​เหย เฮา​จะ​อยู่​กับ​หมู่​ต้าน​ไป​แหม​กำเดียว​เต้าอั้น แล้ว​หมู่​ต้าน​จะ​ตวย​เซาะ​หา​เฮา เฮา​จะ​บอก​หมู่​ต้าน​เหมือน​กับ​ตี้​เฮา​บอก​หมู่​จาว​ยิว​ว่า ตี้​ตี้​เฮา​ก่ำลัง​จะ​ไป​นั้น หมู่​ต้าน​ไป​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“เฮา​หื้อ​กำสั่ง​ใหม่​กับ​หมู่​ต้าน ก็​คือ หื้อ​ฮัก​กั๋น หมู่​ต้าน​ต้อง​ฮัก​กั๋น​เหมือน​กับ​ตี้​เฮา​ฮัก​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ถ้า​หมู่​ต้าน​ฮัก​กั๋น กู้​คน​ก็​จะ​ฮู้​ว่า​หมู่​ต้าน​เป๋น​สาวก​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ซีโมน​เปโตร​ก็​ถาม​พระเยซู​ว่า “พระองค์​เจ้าข้า ต้าน​จะ​ไป​ตี้​ไหน” พระเยซู​ตอบ​ว่า “ตี้​ตี้​เฮา​จะ​ไป​นั้น ต๋อน​นี้​หมู่​ต้าน​ยัง​ตวย​เฮา​ไป​บ่﻿ได้​เตื้อ แต่​หมู่​ต้าน​จะ​ตวย​เฮา​ไป​เมื่อ​ลูน” ");
INSERT INTO nod_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","แล้ว​ซีโมน​เปโตร​ก็​ถาม​แหม​ว่า “พระองค์​เจ้า​ข้า เยียะ​หยัง​บ่าเดี่ยว​นี้​เฮา​เถิง​ตวย​พระองค์​ไป​บ่﻿ได้​เตื้อ เฮา​พร้อม​ตี้​จะ​ต๋าย​เปื้อ​พระองค์” ");
INSERT INTO nod_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","พระเยซู​ก็​ตอบ​ว่า “ต้าน​พร้อม​จะ​ต๋าย​เปื้อ​เฮา​กา เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า ก่อน​ไก่​ขัน ต้าน​จะ​บอก​บ่﻿ฮู้จัก​เฮา​สาม​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“บ่﻿ต้อง​ตุ๊ก​อก​ตุ๊ก​ใจ๋​ไป ขอ​หื้อ​เจื้อ​วางใจ๋​พระเจ้า​กับ​เจื้อ​วางใจ๋​เฮา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ใน​บ้าน​พระบิดา​ของ​เฮา​ก็​มี​ตี้​อยู่​นัก และ​เฮา​จะ​ไป​เกียม​ตี้​หื้อ​หมู่​ต้าน ถ้า​บ่﻿มี เฮา​ก็​จะ​บ่﻿บอก​หมู่​ต้าน​จาอี้​เน่อ ");
INSERT INTO nod_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","หลัง​จาก​เฮา​ไป​เกียม​ตี้​หื้อ​หมู่​ต้าน​แล้ว เฮา​ก็​จะ​ปิ๊ก​มา​ฮับ​หมู่​ต้าน​ไป​อยู่​กับ​เฮา เปื้อ​ว่า​เฮา​อยู่​ตี้​ไหน​หมู่​ต้าน​ก็​จะ​ได้​อยู่​ตี้​หั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","หมู่​ต้าน​ก็​ฮู้จัก​ตาง​ตี้​เฮา​จะ​ไป​นั้น​แล้ว​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","โธมัส​อู้​กับ​พระเยซู​ว่า “อาจ๋ารย์ หมู่​เฮา​ยัง​บ่﻿ฮู้​เลย​ว่า อาจ๋ารย์​จะ​ไป​ตี้​ไหน แล้ว​หมู่​เฮา​จะ​ฮู้จัก​ตาง​นั้น​ได้​จาใด​กั๋น” ");
INSERT INTO nod_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","พระเยซู​อู้​กับ​เขา​ว่า “เฮา​เป๋น​ตาง​นั้น เป๋น​ความ​จริง กับ​เป๋น​จีวิต บ่﻿มี​ใผ​ไป​หา​พระบิดา​ได้​นอกจาก​มา​ตาง​เฮา ");
INSERT INTO nod_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ถ้า​หมู่​ต้าน​ฮู้จัก​เฮา​แล้ว หมู่​ต้าน​ก็​จะ​ฮู้จัก​พระบิดา​ของ​เฮา​ตวย ตั้งแต่​บ่าเดี่ยว​นี้​เป๋น​ต้น​ไป หมู่​ต้าน​ฮู้จัก​พระองค์​กับ​หัน​พระองค์​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ฟีลิป​ก็​อู้​กับ​พระเยซู​ว่า “อาจ๋ารย์ ขอ​หื้อ​เฮา​หัน​พระบิดา เฮา​ก็​ปอใจ๋​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","พระเยซู​อู้​กับ​เขา​ว่า “ฟีลิป​เหย เฮา​อยู่​กับ​ต้าน​ปอ​เถิง​มอก​อี้​ละ ต้าน​ยัง​บ่﻿ฮู้จัก​เฮา​แหม​กา ใผ​ตี้​หัน​เฮา​ก็​หัน​พระบิดา เป๋น​จาใด​ต้าน​ยัง​อู้​ว่า ‘ขอ​หื้อ​เฮา​หัน​พระบิดา’ ");
INSERT INTO nod_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ต้าน​บ่﻿เจื้อ​กา ว่า​เฮา​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​พระบิดา​และ​พระบิดา​ก็​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​เฮา กำ​ตี้​เฮา​อู้ เฮา​บ่﻿ได้​อู้​ต๋ามใจ๋​ตั๋ว​เก่า แต่​พระบิดา​ตี้​อยู่​ใน​เฮา​เยียะ​ก๋าน​ของ​พระองค์​ผ่าน​ตาง​เฮา ");
INSERT INTO nod_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","เจื้อ​เฮา​เต๊อะ​ว่า เฮา​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​พระบิดา​และ​พระบิดา​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​เฮา บ่﻿อั้น​ก็​หื้อ​เจื้อ​ใน​ก๋าน​หมู่​นั้น​ตี้​เฮา​เยียะ​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","เฮา​บอก​ความ​จริง​แก่​ต้าน​ตังหลาย​ว่า คน​ตี้​เจื้อ​วางใจ๋​เฮา​ก็​จะ​เยียะ​ก๋าน​ตี้​เฮา​เยียะ​นั้น​ตวย และ​เขา​จะ​เยียะ​ก๋าน​ตี้​ยิ่งใหญ่​นัก​เหลือ​นั้น​แหม ย้อน​ว่า​เฮา​จะ​ไป​หา​พระบิดา ");
INSERT INTO nod_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","แล้ว​อะหยัง​ก็​ต๋าม​ตี้​หมู่​ต้าน​จะ​ขอ​ใน​นาม​ของ​เฮา เฮา​ก็​จะ​เยียะ​สิ่ง​นั้น​หื้อ เปื้อ​ตี้​พระบุตร​จะ​เยียะ​หื้อ​คน​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​พระบิดา ");
INSERT INTO nod_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ถ้า​ต้าน​ขอ​อะหยัง​ใน​นาม​ของ​เฮา เฮา​ก็​จะ​เยียะ​หื้อ ");
INSERT INTO nod_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“ถ้า​หมู่​ต้าน​ฮัก​เฮา หมู่​ต้าน​ก็​จะ​เยียะ​ต๋าม​กำสั่ง​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","แล้ว​เฮา​ก็​จะ​ขอ​พระบิดา แล้ว​พระองค์​ก็​จะ​ส่ง​ผู้จ้วย​แหม​ผู้​นึ่ง​มา​หื้อ​หมู่​ต้าน ผู้จ้วย​นี้​จะ​อยู่​กับ​หมู่​ต้าน​ตลอด​ไป ");
INSERT INTO nod_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ผู้จ้วย​พระองค์​นี้​ก็​คือ​พระวิญญาณ​ตี้​เปิดเผย​ความ​จริง โลก​นี้​ยอมฮับ​พระองค์​บ่﻿ได้​ย้อน​ผ่อ​บ่﻿หัน​กับ​บ่﻿ฮู้จัก​พระองค์ แต่​หมู่​ต้าน​ฮู้จัก​พระองค์​แล้ว ย้อน​ว่า​บ่าเดี่ยว​นี้​พระองค์​ก็​อยู่​กับ​หมู่​ต้าน กับ​จะ​อยู่​ใน​ตั๋ว​หมู่​ต้าน​หลังจาก​นี้​ตวย ");
INSERT INTO nod_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“เฮา​จะ​บ่﻿ละ​บ่﻿ขว้าง​หมู่​ต้าน​ไว้​หื้อ​อยู่​ใน​โลก​นี้​คน​เดียว เฮา​จะ​ปิ๊ก​มา​หา​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","แหม​บ่﻿เมิน​โลก​ก็​จะ​บ่﻿หัน​เฮา แต่​หมู่​ต้าน​จะ​หัน​เฮา ย้อน​เฮา​มี​จีวิต​อยู่ หมู่​ต้าน​ก็​จะ​มี​จีวิต​อยู่​ตวย ");
INSERT INTO nod_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ใน​วัน​นั้น​หมู่​ต้าน​ก็​จะ​ฮู้​ว่า​เฮา​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​พระบิดา​ของ​เฮา และ​หมู่​ต้าน​ก็​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​เฮา และ​เฮา​ก็​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","คน​ตี้​ยอมฮับ​กำ​สั่ง​ของ​เฮา​กับ​เยียะ​ต๋าม​นั้น​ก็​เป๋น​คน​ตี้​ฮัก​เฮา แล้ว​พระบิดา​ของ​เฮา​ก็​จะ​ฮัก​เขา กับ​เฮา​ก็​จะ​ฮัก​เขา​ตวย กับ​จะ​เปิดเผย​เรื่อง​ของ​เฮา​หื้อ​เขา​ฮู้” ");
INSERT INTO nod_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ยูดาส (​บ่﻿ใจ้​ยูดาส อิสคาริโอท​) ถาม​พระเยซู​ว่า “พระองค์​เจ้า​ข้า เยียะ​หยัง​จะ​เปิดเผย​หื้อ​หมู่​เฮา​ฮู้ แต่​บ่﻿หื้อ​โลก​นี้​ฮู้” ");
INSERT INTO nod_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","พระเยซู​ตอบ​ว่า “ถ้า​ใผ​ฮัก​เฮา เขา​ก็​จะ​เยียะ​ต๋าม​กำ​สั่ง​สอน​ของ​เฮา พระบิดา​ของ​เฮา​ก็​จะ​ฮัก​เขา และ​พระบิดา​กับ​เฮา​ก็​จะ​มา​หา​เขา แล้ว​ก็​จะ​อยู่​กับ​เขา ");
INSERT INTO nod_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","คน​ไหน​บ่﻿ฮัก​เฮา เขา​ก็​จะ​บ่﻿เยียะ​ต๋าม​กำ​สั่ง​สอน​ของ​เฮา กำ​สั่ง​สอน​ตี้​หมู่​ต้าน​ได้​ยิน​บ่﻿ใจ้​เป๋น​กำ​สั่ง​สอน​ของ​เฮา แต่​เป๋น​ของ​พระบิดา​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“เฮา​ได้​อู้​กำ​หมู่​นี้​หื้อ​หมู่​ต้าน​ฟัง​ต๋อน​ตี้​ยัง​อยู่​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","เมื่อ​พระบิดา​ส่ง​ผู้จ้วย​คือ​พระวิญญาณ​บริสุทธิ์​มา​แตน​เฮา พระวิญญาณ​นั้น​ก็​จะ​สอน​หมู่​ต้าน​กู้​สิ่ง​กู้​อย่าง กับ​จะ​เยียะ​หื้อ​หมู่​ต้าน​จ๋ำ​กู้​สิ่ง​ตี้​เฮา​ได้​อู้​กับ​หมู่​ต้าน​ไป​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“เฮา​หื้อ​สันติสุข​ของ​เฮา​ไว้​กับ​หมู่​ต้าน สันติสุข​ตี้​เฮา​หื้อ​บ่﻿เหมือน​กับ​ตี้​โลก​หื้อ บ่﻿ต้อง​ตุ๊ก​อก​ตุ๊ก​ใจ๋​กับ​บ่﻿ต้อง​กั๋ว ");
INSERT INTO nod_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ต้าน​ได้ยิน​ตี้​เฮา​บอก​ต้าน​แล้ว​ว่า เฮา​จะ​ละ​หมู่​ต้าน​ไป​และ​จะ​ปิ๊ก​มา​หา​หมู่​ต้าน​แหม ถ้า​หมู่​ต้าน​ฮัก​เฮา หมู่​ต้าน​ก็​จะ​ดีใจ๋​ตี้​เฮา​จะ​ปิ๊ก​ไป​หา​พระบิดา ย้อน​พระบิดา​เป๋น​ใหญ่​เหลือ​ตั๋ว​เฮา ");
INSERT INTO nod_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","แล้ว​บ่าเดี่ยว​นี้​เฮา​ได้​บอก​หมู่​ต้าน​ก่อน​ตี้​เรื่อง​นี้​จะ​เกิด​ขึ้น เปื้อ​ว่า​เมื่อ​เกิด​ขึ้น​แต๊﻿ๆ หมู่​ต้าน​ก็​จะ​เจื้อ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","เฮา​จะ​อู้​กับ​หมู่​ต้าน​แหม​บ่﻿เมิน ย้อน​ว่า​ผู้​ปกครอง​แห่ง​โลก​นี้​ก่ำลัง​จะ​มา เขา​บ่﻿มี​สิทธิ​อำนาจ​เหลือ​ตั๋ว​เฮา ");
INSERT INTO nod_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","แต่​เฮา​เยียะ​ต๋าม​ตี้​พระบิดา​สั่ง​เฮา เปื้อ​โลก​จะ​ได้​ฮู้​ว่า​เฮา​ฮัก​พระบิดา ลุก​ขึ้น​แล้ว​ไป​กั๋น​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“เฮา​เป๋น​เคือ​องุ่น​แต๊ กับ​พระบิดา​ก็​เป๋น​คน​ผ่อ​คน​กอย ");
INSERT INTO nod_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","กิ่ง​กู้​กิ่ง​ใน​เฮา​ตี้​บ่﻿มี​หน่วย พระบิดา​ก็​ตัด​ขว้าง​เหีย และ​พระองค์​ก็​แต่ง​กิ่ง​ตี้​มี​หน่วย​เปื้อ​หื้อ​มัน​ออก​หน่วย​นัก​ขึ้น ");
INSERT INTO nod_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","หมู่​ต้าน​ก็​สะอาด​แล้ว​ย้อน​กำ​สอน​ของ​เฮา​ตี้​ได้​บอก​กับ​หมู่​ต้าน​ไป ");
INSERT INTO nod_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","หื้อ​ติด​กับ​เฮา และ​เฮา​ก็​จะ​ติด​กับ​หมู่​ต้าน กิ่ง​ออก​หน่วย​เอง​บ่﻿ได้​นอก​จาก​ติด​กับ​เคือ​องุ่น​เต้าอั้น หมู่​ต้าน​ก็​เป๋น​เหมือน​กิ่ง​นั้น​ตี้​ออก​หน่วย​บ่﻿ได้​นอกจาก​ติด​กับ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“เฮา​เป๋น​เคือ​องุ่น หมู่​ต้าน​เป๋น​กิ่ง ใผ​ตี้​ติด​อยู่​กับ​เฮา​และ​เฮา​ติด​อยู่​กับ​เขา คน​นั้น​ก็​จะ​ออก​หน่วย​นัก ย้อน​ถ้า​ใผ​แยก​จาก​เฮา เขา​ก็​เยียะ​อะหยัง​บ่﻿ได้​เลย ");
INSERT INTO nod_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ถ้า​เขา​บ่﻿ติด​กับ​เฮา เขา​ก็​เป๋น​เหมือน​กิ่ง​ตี้​โดน​ตัด​ขว้าง​หื้อ​เหี่ยว​แห้ง​ต๋าย แล้ว​โดน​เก็บ​เอา​ไป​เผา​ไฟ​เหีย ");
INSERT INTO nod_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“ถ้า​หมู่​ต้าน​ติด​อยู่​กับ​เฮา​และ​กำ​สั่ง​สอน​ของ​เฮา​ก็​ติด​อยู่​กับ​หมู่​ต้าน บ่﻿ว่า​หมู่​ต้าน​จะ​ขอ​อะหยัง ต้าน​ก็​จะ​ได้​สิ่ง​นั้น ");
INSERT INTO nod_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ถ้า​หมู่​ต้าน​ออก​หน่วย​นัก หมู่​ต้าน​ก็​จะ​เยียะ​หื้อ​หัน​ว่า​หมู่​ต้าน​เป๋น​สาวก​ของ​เฮา กับ​จะ​เยียะ​หื้อ​กู้​คน​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​พระบิดา ");
INSERT INTO nod_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","พระบิดา​ฮัก​เฮา​จาใด เฮา​ก็​ฮัก​หมู่​ต้าน​จาอั้น หื้อ​หมู่​ต้าน​อยู่​ใน​ความ​ฮัก​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ถ้า​หมู่​ต้าน​เยียะ​ต๋าม​กำสั่ง​ของ​เฮา หมู่​ต้าน​ก็​อยู่​ใน​ความ​ฮัก​ของ​เฮา เหมือน​กับ​ตี้​เฮา​เยียะ​ต๋าม​กำสั่ง​ของ​พระบิดา และ​อยู่​ใน​ความ​ฮัก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","นี่​เป๋น​สิ่ง​ตี้​เฮา​บอก​กับ​หมู่​ต้าน เปื้อ​หื้อ​หมู่​ต้าน​มี​ความ​จื้นจม​ยินดี​อย่าง​ตี้​เฮา​มี กับ​มี​ความ​ยินดี​อย่าง​เต๋มตี้ ");
INSERT INTO nod_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","กำสั่ง​ของ​เฮา​ก็​คือ​หื้อ​หมู่​ต้าน​ฮัก​กั๋น เหมือน​ตี้​เฮา​ฮัก​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","บ่﻿มี​ความ​ฮัก​ไหน​ตี้​ยิ่งใหญ่​นัก​เหลือ​นี้​แหม​แล้ว ก็​คือ ก๋าน​ตี้​คน​นึ่ง​สละ​จีวิต​เปื้อ​เปื้อน​ของ​ตั๋วเก่า ");
INSERT INTO nod_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ถ้า​หมู่​ต้าน​เยียะ​ต๋าม​กำสั่ง​ของ​เฮา หมู่​ต้าน​ก็​เป๋น​เปื้อน​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","เฮา​จะ​บ่﻿ฮ้อง​หมู่​ต้าน​ว่า​คน​ฮับใจ๊​แหม ย้อน​ว่า​คน​ฮับใจ๊​บ่﻿ฮู้​ว่า​นาย​ของ​ตั๋ว​เก่า​เยียะ​อะหยัง​พ่อง แต่​เฮา​ฮ้อง​หมู่​ต้าน​ว่า เปื้อน ย้อน​ว่า กู้​สิ่ง​กู้​อย่าง​ตี้​เฮา​ได้ยิน​จาก​พระบิดา​ของ​เฮา เฮา​ก็​บอก​หื้อ​หมู่​ต้าน​ฮู้​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","หมู่​ต้าน​บ่﻿ได้​เลือก​เฮา แต่​เฮา​เป๋น​คน​เลือก​หมู่​ต้าน กับ​มอบหมาย​งาน​หื้อ​หมู่​ต้าน​ไป​เยียะ​จ๋น​เกิด​ผล เป๋น​ผล​ตี้​อยู่​ได้​ตลอด ย้อน​จาอั้น อะหยัง​ก็​ต๋าม​ตี้​หมู่​ต้าน​ขอ​ใน​นาม​ของ​เฮา พระบิดา​ก็​จะ​หื้อ​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","กำสั่ง​ของ​เฮา​ก็​คือ หื้อ​หมู่​ต้าน​ฮัก​กั๋น​เน่อ ");
INSERT INTO nod_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“เมื่อ​โลก​นี้​จัง​หมู่​ต้าน ก็​หื้อ​จ๋ำ​ไว้​ว่า​โลก​นี้​จัง​เฮา​ก่อน ");
INSERT INTO nod_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ถ้า​หมู่​ต้าน​เป๋น​คน​ของ​โลก​นี้ โลก​นี้​ก็​จะ​ฮัก​หมู่​ต้าน​ตี้​เป๋น​คน​ของ​โลก แต่​หมู่​ต้าน​บ่﻿ได้​เป๋น​คน​ของ​โลก​แล้ว ย้อน​เฮา​ได้​เลือก​หมู่​ต้าน​หื้อ​ออก​จาก​โลก จาอั้น​โลก​เลย​จัง​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","หมู่​ต้าน​จ๋ำ​กำ​ตี้​เฮา​เกย​บอก​ไว้​ได้​ก่อ​ว่า ‘คน​ฮับใจ๊​บ่﻿ใหญ่​เหลือ​เจ้านาย​ของ​เขา’ ถ้า​หมู่​เขา​ค่ำ​เฮา หมู่​เขา​ก็​จะ​ค่ำ​หมู่​ต้าน​ตวย ถ้า​หมู่​เขา​เยียะ​ต๋าม​กำ​สั่ง​สอน​ของ​เฮา หมู่​เขา​ก็​จะ​เยียะ​ต๋าม​กำ​สั่ง​สอน​ของ​หมู่​ต้าน​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ตี้​หมู่​เขา​ค่ำ​หมู่​ต้าน​ก็​ย้อน​หมู่​ต้าน​ติดต๋าม​เฮา ย้อน​หมู่​เขา​บ่﻿ฮู้จัก​ผู้​ตี้​ใจ๊​เฮา​มา ");
INSERT INTO nod_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ถ้า​เฮา​บ่﻿ได้​มา​กับ​บ่﻿ได้​สั่ง​สอน​หมู่​เขา หมู่​เขา​ก็​จะ​บ่﻿มี​ความ​ผิด​อะหยัง แต่​บ่าเดี่ยว​นี้​หมู่​เขา​บ่﻿มี​ข้อ​แก้​ตั๋ว​ใน​เรื่อง​บาป​ของ​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ใผ​ตี้​จัง​เฮา​ก็​จัง​พระบิดา​เฮา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ถ้า​เฮา​บ่﻿ได้​เยียะ​ก๋าน​อัศจ๋รรย์​ตี้​บ่﻿เกย​มี​ใผ​เยียะ​ใน​หมู่​เขา หมู่​เขา​ก็​จะ​บ่﻿มี​บาป​อะหยัง แต่​หมู่​เขา​ได้​หัน​ก๋าน​อัศจ๋รรย์​หลาย​อย่าง​ตี้​เฮา​เยียะ​ไป​แล้ว หมู่​เขา​ก็​ยัง​จัง​เฮา​กับ​พระบิดา​ของ​เฮา​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ตี้​เป๋น​จาอั้น​ก็​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​บท​บัญญัติ​ของ​เขา​ตี้​ว่า ‘หมู่​เขา​จัง​เฮา​โดย​บ่﻿มี​สาเหตุ’ ");
INSERT INTO nod_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“เฮา​จะ​ส่ง​ผู้จ้วย​ตี้​มา​จาก​พระบิดา​มา​หื้อ​หมู่​ต้าน​ก็​คือ พระวิญญาณ​ตี้​เปิดเผย​ความ​จริง พระองค์​จะ​เป๋น​พยาน​หื้อ​ตั๋ว​เฮา ");
INSERT INTO nod_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","และ​หมู่​ต้าน​ก็​จะ​เป๋น​พยาน​บอก​เรื่อง​ของ​เฮา​หื้อ​คน​ฮู้​ตวย ย้อน​หมู่​ต้าน​ได้​อยู่​กับ​เฮา​ตั้งแต่​เก๊า​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“เฮา​บอก​เรื่อง​หมู่​นี้​กับ​หมู่​ต้าน​ก็​เปื้อ​บ่﻿หื้อ​หมู่​ต้าน​ละ​ความ​เจื้อ ");
INSERT INTO nod_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","เขา​จะ​ไล่​หมู่​ต้าน​ออก​จาก​สมาชิก​ธรรมศาลา​ของ​จาว​ยิว แล้ว​จะ​มี​วัน​นึ่ง​ตี้​กู้​คน​ตี้​ฆ่า​หมู่​ต้าน​จะ​กึ๊ด​ว่า ตี้​เยียะ​จาอั้น​เป๋น​ก๋าน​ฮับใจ๊​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ตี้​เขา​จะ​เยียะ​จาอั้น ย้อน​เขา​บ่﻿ฮู้จัก​พระบิดา​กับ​บ่﻿ฮู้จัก​เฮา ");
INSERT INTO nod_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","แต่​ตี้​เฮา​บอก​เรื่อง​หมู่​นี้​กับ​หมู่​ต้าน​ไว้​ก่อน ก็​เปื้อ​เมื่อ​เรื่อง​นี้​เกิด​ขึ้น หมู่​ต้าน​ก็​จะ​กึ๊ด​ได้​ว่า​เฮา​ได้​เตื๋อน​หมู่​ต้าน​ไว้​แล้ว แต่​เฮา​บ่﻿ได้​บอก​เรื่อง​นี้​กับ​หมู่​ต้าน​ตั้งแต่​เก๊า ย้อน​ว่า​เฮา​ยัง​อยู่​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ต๋อน​นี้​เฮา​ก่ำลัง​จะ​ไป​หา​พระองค์​ผู้​ตี้​ใจ๊​เฮา​มา แต่​ก็​บ่﻿มี​ใผ​ใน​หมู่​ต้าน​ถาม​เฮา​ว่า ‘อาจ๋ารย์​จะ​ไป​ตี้​ไหน’ ");
INSERT INTO nod_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","หมู่​ต้าน​ก่ำลัง​ตุ๊ก​อก​ตุ๊ก​ใจ๋​ย้อน​เฮา​บอก​เรื่อง​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","แต่​เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า ตี้​เฮา​จาก​หมู่​ต้าน​ไป​นั้น ก็​เป๋น​ก๋าน​ดี​กับ​หมู่​ต้าน​ย้อน​ว่า​ถ้า​เฮา​บ่﻿ไป พระองค์​ผู้จ้วย​ก็​จะ​บ่﻿มา​หา​หมู่​ต้าน แต่​ถ้า​เฮา​ไป เฮา​ก็​จะ​ส่ง​พระองค์​ผู้จ้วย​มา​หา​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","เมื่อ​พระองค์​มา​แล้ว พระองค์​ก็​จะ​เยียะ​หื้อ​โลก​ฮู้​เถิง​ความ​จริง​เรื่อง​บาป เรื่อง​ความ​ถูกต้อง กับ​เรื่อง​ก๋าน​ตัดสิน​ลงโต้ษ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ใน​เรื่อง​บาป​นั้น​ก็​คือ หมู่​คน​บ่﻿ยอม​เจื้อ​วางใจ๋​เฮา ");
INSERT INTO nod_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","และ​ใน​เรื่อง​ความ​ถูกต้อง​นั้น​ก็​คือ เฮา​จะ​ปิ๊ก​ไป​หา​พระบิดา แล้ว​หมู่​ต้าน​ก็​จะ​บ่﻿หัน​เฮา​แหม ");
INSERT INTO nod_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ใน​เรื่อง​ก๋าน​ตัดสิน​ลงโต้ษ​ของ​พระเจ้า​นั้น​ก็​คือ ผู้​ปกครอง​โลก​นี้​โดน​ตัดสิน​ลงโต้ษ​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“เฮา​มี​แหม​หลาย​เรื่อง​ตี้​จะ​บอก​กับ​หมู่​ต้าน แต่​ถ้า​อู้​กับ​หมู่​ต้าน​บ่าเดี่ยวนี้​ก็​ยาก​ตี้​หมู่​ต้าน​จะ​ฮับ​ได้ ");
INSERT INTO nod_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","แต่​เมื่อ​พระวิญญาณ​ตี้​เปิดเผย​ความ​จริง​มา ก็​จะ​เยียะ​หื้อ​หมู่​ต้าน​เข้าใจ๋​เถิง​ความ​จริง​ตึง​หมด ย้อน​ว่า​พระวิญญาณ​จะ​บ่﻿อู้​ต๋ามใจ๋​ตั๋วเก่า แต่​จะ​อู้​ใน​สิ่ง​ตี้​ได้ยิน​จาก​พระบิดา แล้ว​ก็​จะ​บอก​หมู่​ต้าน​ใน​สิ่ง​ตี้​จะ​เกิด​ขึ้น ");
INSERT INTO nod_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","และ​พระวิญญาณ​ก็​จะ​เยียะ​หื้อ​หมู่​ต้าน​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​เฮา ย้อน​พระวิญญาณ​จะ​เอา​กำสอน​ของ​เฮา​มา​บอก​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","กู้​สิ่ง​กู้​อย่าง​ตี้​เป๋น​ของ​พระบิดา​ก็​เป๋น​ของ​เฮา จาอั้น​เฮา​เลย​บอก​หมู่​ต้าน​ว่า พระวิญญาณ​จะ​เอา​กำสอน​ของ​เฮา​มา​บอก​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“แหม​หน้อย​หมู่​ต้าน​ก็​จะ​บ่﻿หัน​เฮา แล้ว​ต่อ​ไป​แหม​หน้อย​หมู่​ต้าน​ก็​จะ​หัน​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","สาวก​บาง​คน​ก็​อู้​กั๋น​ว่า “ตี้​อาจ๋ารย์​อู้​ว่า ‘แหม​หน้อย​หมู่​ต้าน​ก็​จะ​บ่﻿หัน​เฮา แล้ว​ต่อ​ไป​แหม​หน้อย​หมู่​ต้าน​ก็​จะ​หัน​เฮา’ กับ ‘ย้อน​เฮา​ไป​เถิง​พระบิดา’ อาจ๋ารย์​หมายความ​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","แล้ว​หมู่​เขา​ก็​ถาม​กั๋น​แหม​ว่า “ ‘แหม​หน้อย’ ของ​อาจ๋ารย์ อาจ๋ารย์​หมายเถิง​อะหยัง เฮา​บ่﻿เข้าใจ๋​เรื่อง​ตี้​อาจ๋ารย์​อู้​เลย” ");
INSERT INTO nod_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","พระเยซู​ฮู้​ว่า​หมู่​เขา​ใค่​ถาม​พระองค์ พระองค์​ก็​เลย​อู้​กับ​หมู่​เขา​ว่า “หมู่​ต้าน​ถาม​กั๋น​อยู่​กา ว่า​เฮา​หมายความ​ว่า​จาใด ตี้​เฮา​อู้​ว่า แหม​หน้อย​หมู่​ต้าน​ก็​จะ​บ่﻿หัน​เฮา แล้ว​ต่อ​ไป​แหม​หน้อย​หมู่​ต้าน​ก็​จะ​หัน​เฮา ");
INSERT INTO nod_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า หมู่​ต้าน​จะ​ไห้​หุย แต่​โลก​จะ​จื้นจม​ยินดี หมู่​ต้าน​จะ​โศกเศร้า​เสียใจ๋ แต่​ความ​โศกเศร้า​เสียใจ๋​ของ​หมู่​ต้าน​จะ​ก๋าย​เป๋น​ความ​จื้นจม​ยินดี ");
INSERT INTO nod_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ต๋อน​ตี้​แม่ญิง​เกิด​ลูก เขา​ก็​ตุ๊ก​ย้อน​ความ​เจ็บ​ปวด​ทรมาน แต่​เมื่อ​ลูก​เกิด​ออก​มา​แล้ว เขา​ก็​ลืม​ความ​เจ็บ​ปวด​นั้น ย้อน​เขา​มี​ความ​จื้นจม​ยินดี​ตี้​ลูก​ได้​เกิด​มา​ใน​โลก​นี้ ");
INSERT INTO nod_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ก็​เหมือน​กับ​ต๋อน​นี้​ตี้​หมู่​ต้าน​ตุ๊ก​อก​ตุ๊ก​ใจ๋ แต่​เมื่อ​เฮา​ปิ๊ก​มา​หา​หมู่​ต้าน​แหม หมู่​ต้าน​ก็​จะ​มี​ความ​จื้นจม​ยินดี กับ​จะ​บ่﻿มี​ใผ​มา​ลู่​เอา​ความ​จื้นจม​ยินดี​ไป​จาก​หมู่​ต้าน​ได้ ");
INSERT INTO nod_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ใน​วัน​นั้น​หมู่​ต้าน​ก็​จะ​บ่﻿ถาม​อะหยัง​เฮา​แหม เฮา​บอก​ความ​จริง​แก่​หมู่​ต้าน​ว่า ถ้า​ต้าน​ขอ​อะหยัง​จาก​พระบิดา​ใน​นาม​ของ​เฮา พระองค์​ก็​จะ​หื้อ​กับ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","จ๋น​เถิง​บ่าเดี่ยว​นี้​หมู่​ต้าน​ยัง​บ่﻿ได้​ขอ​อะหยัง​ใน​นาม​ของ​เฮา​เลย หื้อ​ขอ​เต๊อะ แล้ว​หมู่​ต้าน​ก็​จะ​ได้ เปื้อ​หมู่​ต้าน​จะ​มี​ความ​จื้นจม​ยินดี​อย่าง​เต๋ม​ตี้ ");
INSERT INTO nod_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“เฮา​เล่า​เรื่อง​หมู่​นี้​เป๋น​กำเผียบ​หื้อ​หมู่​ต้าน​ฟัง แต่​จะ​มี​วัน​นึ่ง​ตี้​เฮา​จะ​บ่﻿ใจ๊​กำเผียบ​แล้ว แต่​เฮา​จะ​อู้​ซื่อ﻿ๆ เกี่ยว​กับ​พระบิดา ");
INSERT INTO nod_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ใน​วัน​นั้น​หมู่​ต้าน​จะ​บ่﻿ต้อง​ขอ​อะหยัง​ผ่าน​ตาง​เฮา​แหม​แล้ว ต้าน​ขอ​จาก​พระบิดา​ได้​โดย​ตรง​เลย ");
INSERT INTO nod_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","พระบิดา​ฮัก​หมู่​ต้าน​ย้อน​ว่า​หมู่​ต้าน​ฮัก​เฮา​และ​เจื้อ​ว่า​เฮา​มา​จาก​พระบิดา ");
INSERT INTO nod_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","เฮา​มา​จาก​พระบิดา​และ​เข้า​มา​ใน​โลก​แล้ว และ​ก่ำลัง​จะ​ไป​จาก​โลก แล้ว​ปิ๊ก​ไป​หา​พระบิดา” ");
INSERT INTO nod_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","หมู่​สาวก​ก็​อู้​กั๋น​ว่า “ผ่อ​ลอ อาจ๋ารย์​อู้​กับ​หมู่​เฮา​ซื่อ﻿ๆ โดย​บ่﻿ใจ๊​กำเผียบ​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ต๋อน​นี้​หมู่​เฮา​เข้าใจ๋​แล้ว​ว่า​อาจ๋ารย์​ฮู้​กู้​สิ่ง​กู้​อย่าง บ่﻿จ๋ำ​เป๋น​ตี้​ใผ​จะ​ต้อง​ถาม​อาจ๋ารย์​แหม ย้อน​ว่า​อาจ๋ารย์​ฮู้​แล้ว​ว่า​หมู่​เฮา​กึ๊ด​จะ​ถาม​อะหยัง มอกอี้​หมู่​เฮา​ก็​เจื้อ​แล้ว​ว่า​อาจ๋ารย์​มา​จาก​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","แล้ว​พระเยซู​ก็​อู้​ว่า “บ่าเดี่ยว​นี้​หมู่​ต้าน​เจื้อ​เฮา​แล้ว​กา ");
INSERT INTO nod_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ผ่อ​ลอ จะ​มี​วัน​นึ่ง​ตี้​จะ​มา​เถิง และ​แต๊﻿ๆ บ่าเดี่ยว​นี้​ก็​เถิง​แล้ว ตี้​หมู่​ต้าน​จะ​แตก​ขะแล​ขะแจ​หนี​ไป​บ้าน​ใผ​บ้าน​มัน แล้ว​จะ​ละ​เฮา​ไว้​หื้อ​อยู่​คน​เดียว แต่​เฮา​บ่﻿ได้​อยู่​คน​เดียว ย้อน​พระบิดา​อยู่​กับ​เฮา ");
INSERT INTO nod_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“เฮา​บอก​เรื่อง​หมู่​นี้​กับ​หมู่​ต้าน​ไว้​เปื้อ​สันติสุข​ของ​เฮา​จะ​อยู่​กับ​หมู่​ต้าน ใน​โลก​นี้​ต้าน​จะ​ปะ​ความ​ตุ๊กยาก​ลำบาก แต่​หื้อ​เข้มแข็ง​ไว้​เน่อ ย้อน​ว่า​เฮา​มี​ชัย​เหนือ​โลก​แล้ว” ");
INSERT INTO nod_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","หลังจาก​พระเยซู​อู้​จาอั้น​แล้ว พระองค์​ก็​แหงน​หน้า​ขึ้น​ผ่อ​ต๊องฟ้า แล้ว​ก็​อู้​ว่า “ข้า​แต่​พระบิดา เถิง​เวลา​แล้ว ขอ​โผด​เยียะ​หื้อ​กู้​คน​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​พระบุตร​ของ​พระองค์ เปื้อ​พระบุตร​ของ​พระองค์​ก็​จะ​ได้​เยียะ​หื้อ​กู้​คน​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ย้อน​ว่า​พระองค์​ได้​หื้อ​พระบุตร​มี​สิทธิ​อำนาจ​เหนือ​กู้​คน เปื้อ​พระบุตร​จะ​หื้อ​จีวิต​นิรันดร์​กับ​กู้​คน​ตี้​พระองค์​ได้​หื้อ​พระบุตร​ไว้ ");
INSERT INTO nod_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","จีวิต​นิรันดร์​ก็​คือ ก๋าน​ฮู้จัก​พระองค์​ผู้​เป๋น​พระเจ้า​ผู้​เตี้ยงแต๊​องค์​เดียว และ​ฮู้จัก​พระเยซู​คริสต์​ผู้​ตี้​พระองค์​ใจ๊​มา ");
INSERT INTO nod_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ข้า​พระองค์​ได้​เยียะ​หื้อ​คน​ใน​โลก​นี้​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​พระองค์​โดย​เยียะ​ก๋าน​กู้​อย่าง​ตี้​พระองค์​มอบ​หื้อ​ข้า​พระองค์​ไว้​เสร็จ​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","บ่าเดี่ยว​นี้​ขอ​พระบิดา​หื้อ​เกียรติ​ข้า​พระองค์​ต่อหน้า​พระองค์ คือ​เกียรติ​ตี้​พระบุตร​เกย​มี​ฮ่วม​กั๋น​กับ​พระองค์​ก่อน​ตี้​โลก​นี้​เกิด​ขึ้น​มา ");
INSERT INTO nod_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“คน​ตี้​พระองค์​นำ​มา​ติดต๋าม​ข้า​พระองค์​จาก​โลก​นี้ ข้า​พระองค์​ก็​เยียะ​หื้อ​ฮู้จัก​พระองค์ คน​หมู่​นี้​เป๋น​ของ​พระองค์​ตี้​พระองค์​มอบ​ไว้​กับ​ข้า​พระองค์​แล้ว หมู่​เขา​ได้​เยียะ​ต๋าม​ถ้อยกำ​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","บ่าเดี่ยว​นี้​หมู่​เขา​ฮู้​แล้ว​ว่า กู้​สิ่ง​ตี้​พระองค์​หื้อ​ข้า​พระองค์​ไว้​มา​จาก​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ย้อน​ว่า​กำ​ตี้​พระองค์​หื้อ​ข้า​พระองค์​ไว้​นั้น ข้า​พระองค์​ได้​หื้อ​หมู่​เขา​แล้ว และ​หมู่​เขา​ก็​ยอมฮับ​กำ​นั้น​ไว้ และ​หมู่​เขา​ฮู้​แต๊﻿ๆ แล้ว​ว่า​ข้า​พระองค์​มา​จาก​พระองค์ และ​เจื้อ​ว่า​พระองค์​ใจ๊​ข้า​พระองค์​มา ");
INSERT INTO nod_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ข้า​พระองค์​อธิษฐาน​หื้อ​หมู่​เขา บ่﻿ใจ้​อธิษฐาน​หื้อ​คน​ใน​โลก แต่​อธิษฐาน​หื้อ​คน​หมู่​นั้น​ตี้​พระองค์​มอบ​หื้อ​ข้า​พระองค์​ไว้ ย้อน​หมู่​เขา​เป๋น​คน​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","กู้​อย่าง​ตี้​เป๋น​ของ​ข้า​พระองค์ ก็​เป๋น​ของ​พระองค์ แล้ว​กู้​อย่าง​ตี้​เป๋น​ของ​พระองค์​ก็​เป๋น​ของ​ข้า​พระองค์ กับ​คน​หมู่​นี้​เยียะ​หื้อ​โลก​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​ข้า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ข้า​พระองค์​จะ​บ่﻿อยู่​ใน​โลก​นี้​แหม​แล้ว แต่​หมู่​เขา​ยัง​อยู่​ใน​โลก​นี้ กับ​ข้า​พระองค์​ก่ำลัง​จะ​ปิ๊ก​ไป​หา​พระองค์ ข้า​แต่​พระบิดา ผู้​บริสุทธิ์ ขอ​พระองค์​ปกปัก​ฮักษา​หมู่​เขา​โดย​ฤทธิ์​อำนาจ​ของ​พระองค์​ตี้​ได้​หื้อ​ข้า​พระองค์​ตวย​เต๊อะ เปื้อ​หมู่​เขา​จะ​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น เหมือน​กับ​ตี้​พระองค์​กับ​ข้า​พระองค์​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ต๋อน​ตี้​ข้า​พระองค์​อยู่​กับ​หมู่​เขา ข้า​พระองค์​ก็​ปกปัก​ฮักษา​หมู่​เขา​หื้อ​ปลอดภัย​โดย​ฤทธิ์​อำนาจ​ตี้​พระองค์​หื้อ​ข้า​พระองค์ ข้า​พระองค์​ปกป้อง​หมู่​เขา​ไว้​และ​บ่﻿มี​ใผ​หาย​ไป​สัก​คน ยกเว้น​คน​นั้น​ตี้​พระองค์​ก๋ำหนด​ไว้ จะ​ต้อง​ฉิบหาย​วายวอด เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​พระคัมภีร์ ");
INSERT INTO nod_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“แต่​บ่าเดี่ยว​นี้​ข้า​พระองค์​ก่ำลัง​จะ​ปิ๊ก​ไป​หา​พระองค์ ตี้​ข้า​พระองค์​อู้​เรื่อง​หมู่​นี้​ต๋อน​ตี้​ยัง​อยู่​ใน​โลก ก็​เปื้อ​หื้อ​หมู่​เขา​ได้​ฮับ​ความ​จื้นจม​ยินดี​อย่าง​เต๋มตี้​เหมือน​ตี้​ข้า​พระองค์​ได้ฮับ ");
INSERT INTO nod_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ข้า​พระองค์​ได้​หื้อ​ถ้อยกำ​ของ​พระองค์​กับ​หมู่​เขา​แล้ว และ​โลก​นี้​จัง​หมู่​เขา ย้อน​ว่า​หมู่​เขา​บ่﻿ใจ้​ของ​โลก​เหมือน​กับ​ตี้​ข้า​พระองค์​บ่﻿ใจ้​ของ​โลก ");
INSERT INTO nod_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ข้า​พระองค์​บ่﻿ขอ​หื้อ​พระองค์​เอา​หมู่​เขา​ออก​ไป​จาก​โลก แต่​ขอ​หื้อ​พระองค์​ปกปัก​ฮักษา​หมู่​เขา​หื้อ​ปลอดภัย​จาก​มาร ");
INSERT INTO nod_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","หมู่​เขา​บ่﻿ใจ้​ของ​โลก​เหมือน​กับ​ข้า​พระองค์​ตี้​บ่﻿ใจ้​ของ​โลก ");
INSERT INTO nod_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ถ้อยกำ​ของ​พระองค์​เป๋น​ความ​จริง ขอ​หื้อ​ถ้อยกำ​นั้น​เยียะ​หื้อ​หมู่​เขา​เป๋น​คน​ตี้​บริสุทธิ์​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","พระองค์​ส่ง​ข้า​พระองค์​มา​ใน​โลก​จาใด ข้า​พระองค์​ก็​ส่ง​หมู่​เขา​ไป​ใน​โลก​จาอั้น ");
INSERT INTO nod_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ข้า​พระองค์​ขอ​ถวาย​ตั๋ว​ฮับใจ๊​พระองค์ เปื้อ​หมู่​เขา​ก็​จะ​ถวาย​ตั๋ว​ฮับใจ๊​พระองค์​อย่าง​แต๊​จริง​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ข้า​พระองค์​บ่﻿ได้​อธิษฐาน​เปื้อ​หมู่​เขา​เต้าอั้น แต่​อธิษฐาน​เปื้อ​หมู่​คน​ตี้​จะ​เจื้อ​วางใจ๋​ข้า​พระองค์​ผ่าน​ตาง​กำ​พยาน​ของ​หมู่​เขา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ข้า​พระองค์​ขอ​หื้อ​หมู่​เขา​ตึง​หมด​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​เหมือน​กับ​ตี้​พระบิดา​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​ข้า​พระองค์ และ​ข้า​พระองค์​ก็​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​พระบิดา ขอ​หื้อ​หมู่​เขา​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​เฮา​ตวย เปื้อ​โลก​จะ​เจื้อ​ว่า​พระองค์​เป๋น​ผู้​ส่ง​ข้า​พระองค์​มา ");
INSERT INTO nod_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","เกียรติ​ตี้​พระองค์​ได้​หื้อ​ข้า​พระองค์​ไว้ ข้า​พระองค์​ได้​หื้อ​หมู่​เขา​แล้ว เปื้อ​หมู่​เขา​จะ​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​เหมือน​กับ​ตี้​พระองค์​กับ​ข้า​พระองค์​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ข้า​พระองค์​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​หมู่​เขา กับ​พระองค์​ก็​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​ข้า​พระองค์ เปื้อ​หมู่​เขา​จะ​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​แต๊﻿ๆ กับ​เปื้อ​คน​ตังหลาย​จะ​ฮู้​ว่า​พระองค์​ส่ง​ข้า​พระองค์​มา และ​พระองค์​ก็​ฮัก​หมู่​เขา​เหมือน​กับ​ตี้​พระองค์​ฮัก​ข้า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ข้า​แต่​พระบิดา ข้า​พระองค์​ใค่​หื้อ​คน​หมู่​นี้​ตี้​พระองค์​หื้อ​ข้า​พระองค์ อยู่​กับ​ข้า​พระองค์​ใน​ตี้​ตี้​ข้า​พระองค์​อยู่​นั้น เปื้อ​หมู่​เขา​จะ​ได้​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​ข้า​พระองค์ ตี้​พระองค์​หื้อ​ข้า​พระองค์​ไว้ ย้อน​พระองค์​ฮัก​ข้า​พระองค์​ก่อน​สร้าง​โลก​นี้ ");
INSERT INTO nod_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ข้า​แต่​พระบิดา​ผู้​มี​ความ​ยุติธรรม โลก​นี้​บ่﻿ฮู้จัก​พระองค์ แต่​ข้า​พระองค์​ฮู้จัก​พระองค์ และ​คน​หมู่​นี้​ก็​ฮู้​ว่า​พระองค์​ส่ง​ข้า​พระองค์​มา ");
INSERT INTO nod_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ข้า​พระองค์​เยียะ​หื้อ​หมู่​เขา​ฮู้จัก​พระองค์​แล้ว กับ​จะ​เยียะ​ต่อ​ไป​แหม เปื้อ​ว่า​ความ​ฮัก​ตี้​พระองค์​มี​หื้อ​ข้า​พระองค์​จะ​อยู่​กับ​หมู่​เขา กับ​ข้า​พระองค์​ก็​จะ​เป๋น​อัน​นึ่ง​อัน​เดียว​กั๋น​กับ​หมู่​เขา​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","เมื่อ​พระเยซู​อธิษฐาน​เสร็จ​แล้ว พระองค์​กับ​หมู่​สาวก​ก็​เตียว​ออก​จาก​ตี้​หั้น​ไป ข้าม​ห้วย​จื้อ​ขิดโรน แล้ว​เข้า​ไป​ใน​สวน​บ่ากอกเทศ​แห่ง​นึ่ง ");
INSERT INTO nod_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ยูดาส​คน​ตี้​หักหลัง​พระองค์​ก็​ฮู้จัก​สวน​นี้​ตวย ย้อน​ว่า​พระองค์​กับ​หมู่​สาวก​เกย​มา​ปะ​กั๋น​ตี้​นี่​เจื่อ﻿ๆ ");
INSERT INTO nod_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","แล้ว​ยูดาส​ก็​ปา​หมู่​ทหาร​โรมัน​กับ​ทหาร​ฮักษา​พระวิหาร​ตี้​หมู่​หัว​หน้า​ปุโรหิต​กับ​หมู่​ฟาริสี​ส่ง​มา ไป​ตี้​สวน​นั้น หมู่​เขา​ต๋าม​โกม ก๋ำ​ไม้แค่ กับ​มี​อาวุธ​มา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","พระเยซู​ฮู้​ว่า​จะ​เกิด​อะหยัง​ขึ้น​กับ​พระองค์ พระองค์​ก็​เลย​เตียว​ออก​ไป​ถาม​หมู่​เขา​ว่า “หมู่​ต้าน​มา​ตวย​เซาะ​หา​ใผ” ");
INSERT INTO nod_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","หมู่​เขา​ก็​ตอบ​ว่า “เยซู จาว​นาซาเร็ธ” พระเยซู​ก็​เลย​อู้​ว่า “เฮา​เป๋น​คน​นั้น” ยูดาส​คน​ตี้​หักหลัง​พระเยซู​ก็​ยืน​อยู่​กับ​หมู่​เขา​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","เมื่อ​หมู่​เขา​ได้​ยิน​พระเยซู​อู้​ว่า “เฮา​เป๋น​คน​นั้น” หมู่​เขา​ก็​ถอย​หลัง​โก้น​ลง​ดิน ");
INSERT INTO nod_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","แล้ว​พระเยซู​ก็​ถาม​เขา​แหม​เตื้อ​ว่า “หมู่​ต้าน​มา​ตวย​เซาะ​หา​ใผ” หมู่​เขา​ก็​ตอบ​ว่า “เยซู จาว​นาซาเร็ธ” ");
INSERT INTO nod_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","พระเยซู​ก็​เลย​อู้​ว่า “ก็​เฮา​บอก​แล้ว​ลอ​ว่า​เฮา​เป๋น​คน​นั้น ถ้า​หมู่​ต้าน​มา​ตวย​เซาะ​หา​เฮา ก็​หื้อ​ป่อย​คน​หมู่​นี้​ไป​เหีย” ");
INSERT INTO nod_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ตี้​พระเยซู​อู้​จาอั้น​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​พระองค์​เกย​อู้​ไว้​ว่า “ข้า​พระองค์​บ่﻿หื้อ​คน​ตี้​พระบิดา​มอบ​หื้อ​ข้า​พระองค์​ไว้ หาย​ไป​สัก​คน​เดียว” ");
INSERT INTO nod_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ซีโมน​เปโตร​มี​ดาบ​อยู่ เขา​เลย​จั๊ก​ออก​มา​ฟัน​ถูก​หู​เผิก​ขวา​ของ​มัลคัส ปุด เซิ่ง​เป๋น​คน​ฮับ​ใจ๊​ของ​มหา​ปุโรหิต ");
INSERT INTO nod_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","พระเยซู​อู้​กับ​เขา​ว่า “เก็บ​ดาบ​ใส่​ฝัก​เหีย​เต๊อะ กึ๊ด​ว่า​เฮา​จะ​บ่﻿กิ๋น​จาก​ถ้วย​แห่ง​ความ​ตุ๊ก​ตี้​พระบิดา​หื้อ​เฮา​ไว้​กา” ");
INSERT INTO nod_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","นายพัน​กับ​หมู่​ทหาร​โรมัน แล้ว​ก็​หมู่​ทหาร​ฮักษา​พระวิหาร​ของ​จาว​ยิว​ก็​ยับ​พระเยซู​มัด​ไว้ ");
INSERT INTO nod_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","แล้ว​ปา​พระองค์​ไป​หา​อันนาส​ก่อน ย้อน​เขา​เป๋น​ป้อเมีย​ของ​คายาฟาส​ตี้​เป๋น​มหา​ปุโรหิต​ใน​ปี๋​นั้น ");
INSERT INTO nod_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","คายาฟาส​เป๋น​คน​ตี้​เกย​บอก​หมู่​จาว​ยิว​ว่า “ก็​ดี​ถ้า​หื้อ​คน​นึ่ง​ต๋าย​เปื้อ​คน​ตึง​หมด” ");
INSERT INTO nod_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ซีโมน​เปโตร​กับ​สาวก​แหม​คน​นึ่ง​ตวย​พระเยซู​ไป สาวก​คน​นั้น​ฮู้จัก​มหา​ปุโรหิต เขา​เลย​ตวย​พระเยซู​เข้า​ไป​ใน​ก๋าง​ข่วง​บ้าน​ของ​มหา​ปุโรหิต ");
INSERT INTO nod_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","แต่​เปโตร​ยืน​ถ้า​อยู่​ตัง​นอก​ข้าง​ปะตู๋ สาวก​คน​นั้น​ตี้​ฮู้จัก​มหา​ปุโรหิต​ก็​เลย​ออก​มา​บอก​สาวใจ๊​ตี้​เฝ้า​ปะตู๋ แล้ว​ปา​เปโตร​เข้า​ไป​ตัง​ใน​ตวย ");
INSERT INTO nod_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","สาวใจ๊​ตี้​เฝ้า​ปะตู๋​คน​นั้น​ถาม​เปโตร​ว่า “ต้าน​เป๋น​สาวก​ของ​ป้อจาย​คน​นั้น​ตวย​บ่﻿ใจ้​กา” เปโตร​ก็​ตอบ​ว่า “บ่﻿ใจ้​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ตี้​หั้น​หมู่​ขี้ข้า​กับ​ทหาร​ฮักษา​พระวิหาร​ดัง​ไฟ​ยืน​หิง​หื้อ​อุ่น​กั๋น​อยู่​ย้อน​อากาศ​มัน​หนาว เปโตร​ก็​ไป​ยืน​หิง​ไฟ​อยู่​กับ​หมู่​เขา​ตวย ");
INSERT INTO nod_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","มหา​ปุโรหิต​ก็​สอบสวน​พระเยซู​เรื่อง​หมู่​สาวก​กับ​กำสอน​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","พระองค์​ตอบ​ว่า “เฮา​ได้​อู้​อย่าง​เปิดเผย​กับ​กู้​คน เฮา​สอน​อยู่​ใน​ธรรมศาลา​กับ​ใน​พระวิหาร​ตลอด​ตี้​จาว​ยิว​ตึง​หมด​มา​จุมนุม​กั๋น เฮา​บ่﻿เกย​สอน​อะหยัง​อย่าง​ลับ﻿ๆ เลย ");
INSERT INTO nod_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ต้าน​มา​ถาม​เฮา​เยียะ​หยัง ไป​ถาม​คน​หมู่​นั้น​ตี้​ได้​ยิน​กำ​อู้​ของ​เฮา​เต๊อะ หมู่​เขา​ฮู้​ดี​ว่า​เฮา​อู้​อะหยัง​ไป​พ่อง” ");
INSERT INTO nod_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","บ่ากอง​พระเยซู​อู้​จาอั้น ทหาร​ฮักษา​พระวิหาร​คน​นึ่ง​ตี้​ยืน​อยู่​ใก้​หั้น ก็​ตบ​หน้า​พระองค์​แล้ว​อู้​ว่า “ตอบ​มหา​ปุโรหิต​จาอั้น​ได้​จาใด​หา” ");
INSERT INTO nod_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","พระเยซู​เลย​ตอบ​ว่า “ถ้า​เฮา​อู้​อะหยัง​ผิด​ก็​หื้อ​บอก​มา​เลย​ว่า​ผิด​จาใด แต่​ถ้า​เฮา​อู้​ถูก มา​ตบ​หน้า​เฮา​เยียะ​หยัง” ");
INSERT INTO nod_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","อันนาส​เลย​หื้อ​ปา​พระเยซู​ตี้​ยัง​โดน​มัด​อยู่​ไป​หา​คายาฟาส​ตี้​เป๋น​มหา​ปุโรหิต ");
INSERT INTO nod_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ต๋อน​ตี้​ซีโมน​เปโตร​ก่ำลัง​ยืน​หิง​ไฟ​อยู่ หมู่​คน​ตี้​หั้น​ถาม​เขา​ว่า “เจ้า​เป๋น​สาวก​ของ​คน​นั้น​ตวย​กา” เปโตร​ก็​ปฏิเสธ​ว่า “บ่﻿ใจ้​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","คน​ฮับใจ๊​คน​นึ่ง​ของ​มหา​ปุโรหิต ตี้​เป๋น​ญาติ​ของ​ป้อจาย​ตี้​โดน​เปโตร​ฟัน​หู​ปุด​ก็​อู้​กับ​เปโตร​ว่า “ก็​เฮา​หัน​ต้าน​อยู่​ใน​สวน​กับ​ป้อจาย​คน​นั้น​บ่﻿ใจ้​กา” ");
INSERT INTO nod_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","เปโตร​ก็​บอก​บ่﻿ใจ้​แหม​เตื้อ แล้ว​ไก่​ก็​ขัน​ขึ้น​มา​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","เจ๊ามืด​หมู่​เขา​ก็​ปา​พระเยซู​ออก​จาก​บ้าน​คายาฟาส​ไป​ตี้​วัง​ของ​เจ้า​เมือง​โรมัน หมู่​จาว​ยิว​บ่﻿ได้​เข้า​ไป​ตี้​หั้น ย้อน​กั๋ว​ว่า​ตั๋ว​เก่า​จะ​เป๋น​มลทิน​ แล้ว​จะ​เข้า​ฮ่วม​ใน​งาน​ปัสกา​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","เจ้าเมือง​ปีลาต​เลย​ออก​มา​หา​หมู่​เขา​ตังนอก​แล้ว​ถาม​ว่า “หมู่​ต้าน​ฟ้อง​ป้อจาย​คน​นี้​ย้อน​เรื่อง​อะหยัง” ");
INSERT INTO nod_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","หมู่​เขา​ตอบ​ปีลาต​ว่า “ถ้า​เขา​บ่﻿ได้​เยียะ​ผิด หมู่​เฮา​ก็​จะ​บ่﻿เอา​ตั๋ว​เขา​มา​หื้อ​ต้าน” ");
INSERT INTO nod_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ปีลาต​อู้​กับ​หมู่​เขา​ว่า “หื้อ​หมู่​ต้าน​เอา​เขา​ไป​ตัดสิน​ลงโต้ษ​ต๋าม​บท​บัญญัติ​ของ​หมู่​ต้าน​กั๋น​เอง​เต๊อะ” หมู่​จาว​ยิว​เลย​บอก​ปีลาต​ว่า “ต๋าม​กฎหมาย​ของ​โรมัน เฮา​บ่﻿มี​สิทธิ์​ตัดสิน​ฆ่า​ใผ​ลุ” ");
INSERT INTO nod_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ตี้​เกิด​ขึ้น​จาอี้​ก็​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​ตี้​พระเยซู​เกย​อู้​ไว้​ว่า​พระองค์​จะ​ต๋าย​จาใด ");
INSERT INTO nod_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ปีลาต​ก็​ปิ๊ก​เข้า​ไป​ใน​วัง​แล้ว​ฮ้อง​พระเยซู​มา​ถาม​ว่า “ต้าน​เป๋น​กษัตริย์​ของ​จาว​ยิว​กา” ");
INSERT INTO nod_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","พระเยซู​ก็​ตอบ​ว่า “ตี้​ต้าน​ถาม​จาอี้​ต้าน​กึ๊ด​คน​เดียว​กาว่า​คน​อื่น​บอก” ");
INSERT INTO nod_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ปีลาต​ก็​ตอบ​ว่า “ต้าน​กึ๊ด​ว่า​เฮา​เป๋น​จาว​ยิว​กา คน​ใน​จ้าด​ของ​ต้าน​กับ​หมู่​หัว​หน้า​ปุโรหิต​นั้น​เนาะ ตี้​ยับ​ต้าน​มา​หื้อ​เฮา ต้าน​เยียะ​อะหยัง​ผิด” ");
INSERT INTO nod_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","พระเยซู​ก็​ตอบ​ว่า “สิทธิ​อำนาจ​ตี้​เป๋น​กษัตริย์​ของ​เฮา​บ่﻿ได้​มา​จาก​โลก​นี้ ย้อน​ถ้า​เป๋น​จาอั้น คน​ของ​เฮา​ก็​จะ​สู้​เปื้อ​บ่﻿หื้อ​หมู่​จาว​ยิว​ยับ​เฮา แต่​สิทธิ​อำนาจ​ตี้​เป๋น​กษัตริย์​ของ​เฮา​บ่﻿ได้​มา​จาก​โลก​นี้” ");
INSERT INTO nod_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ปีลาต​เลย​บอก​พระองค์​ว่า “ถ้า​จาอั้น ต้าน​ก็​เป๋น​กษัตริย์​หนะ​ก่า” พระเยซู​ก็​บอก​ว่า “ต้าน​อู้​ว่า​เฮา​เป๋น​กษัตริย์​ก็​แม่น​แล้ว จาอั้น เฮา​เลย​มา​เกิด​ใน​โลก​นี้​เปื้อ​เป๋น​พยาน​หื้อ​กับ​ความ​จริง กับ​กู้﻿ๆ คน​ตี้​ฮัก​ความ​จริง​ก็​ฟัง​เสียง​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ปีลาต​ก็​ถาม​พระองค์​แหม​ว่า “ความ​จริง​คือ​อะหยัง” เมื่อ​เขา​ถาม​แล้ว​ก็​ออก​ไป​หา​หมู่​จาว​ยิว​อู้​กับ​หมู่​เขา​ว่า “เฮา​บ่﻿หัน​ว่า​เขา​มี​ความ​ผิด​อะหยัง ");
INSERT INTO nod_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","แต่​หมู่​ต้าน​มี​ธรรมเนียม​หื้อ​เฮา​ป่อย​นักโต้ษ​คน​นึ่ง​หื้อ​หมู่​ต้าน​ใน​งาน​ปัสกา หมู่​ต้าน​ใค่​หื้อ​เฮา​ป่อย​กษัตริย์​ของ​จาว​ยิว​ก่อ” ");
INSERT INTO nod_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","แต่​หมู่​จาว​ยิว​ปา​กั๋น​ฮ้อง​เอิ้น​ออก​มา​ว่า “บ่﻿ป่อย​เขา ขอ​หื้อ​ป่อย​บารับบัส​แตน” (​บารับบัส​เป๋น​กบฏ​) ");
INSERT INTO nod_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ปีลาต​เลย​ปา​พระเยซู​ไป แล้ว​สั่ง​ทหาร​เฆี่ยน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","หมู่​ทหาร​ก็​เอา​กิ่ง​ไม้​ตี้​มี​หนาม​มา​แป๋ง​เป๋น​มงกุฎ แล้ว​เอา​สุบ​หัว​หื้อ​พระองค์ แล้ว​เอา​เสื้อ​คุม​สี​ม่วง​ใส่​หื้อ ");
INSERT INTO nod_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","แล้ว​หมู่​เขา​ก็​เปี่ยน​กั๋น​เข้า​มา​หา​พระองค์​กับ​อู้​หย้อ​พระองค์​ว่า “ขอ​กษัตริย์​ของ​จาว​ยิว​จง​จ๋ำเริญ​เต๊อะ” แล้ว​ก็​ตบ​หน้า​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ปีลาต​ก็​ออก​มา​อู้​กับ​หมู่​จาว​ยิว​ว่า “ผ่อ​ลอ เฮา​ปา​เขา​ออก​มา​หื้อ​หมู่​ต้าน เปื้อ​หื้อ​หมู่​ต้าน​ฮู้​ว่า เฮา​บ่﻿หัน​ว่า​ป้อจาย​คน​นี้​มี​ความ​ผิด​อะหยัง​เลย” ");
INSERT INTO nod_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","พระเยซู​ก็​ออก​มา​ตึง​สุบ​มงกุฎ​หนาม​กับ​ใส่​เสื้อ​คุม​สี​ม่วง ปีลาต​เลย​อู้​กับ​คน​ตังหลาย​ว่า “เขา​นี่​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","เมื่อ​หมู่​หัว​หน้า​ปุโรหิต​กับ​ทหาร​ฮักษา​พระวิหาร​หัน​พระองค์ ก็​ปา​กั๋น​ฮ้องเอิ้น​ว่า “เขิง​บน​ไม้​ก๋าง​เขน เขิง​บน​ไม้​ก๋าง​เขน” ปีลาต​ก็​อู้​กับ​หมู่​เขา​ว่า “หมู่​ต้าน​เอา​เขา​ไป​เขิง​กั๋น​คน​เดียว​เต๊อะ ย้อน​เฮา​บ่﻿หัน​ว่า​เขา​มี​ความ​ผิด​อะหยัง​เลย” ");
INSERT INTO nod_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","หมู่​จาว​ยิว​ก็​อู้​กับ​ปีลาต​ว่า “หมู่​เฮา​มี​กฎหมาย ต๋าม​กฎ​นั้น​เขา​สมควร​ต๋าย ย้อน​เขา​ยก​ตั๋ว​เป๋น​พระบุตร​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","เมื่อ​ปีลาต​ได้ยิน​ว่า​พระเยซู​ยก​ตั๋ว​เป๋น​พระบุตร​ของ​พระเจ้า เขา​ก็​กั๋ว​นัก​ขึ้น ");
INSERT INTO nod_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ปีลาต​เลย​ปา​พระเยซู​เข้า​ไป​ใน​วัง​แหม​รอบ แล้ว​อู้​กับ​พระเยซู​ว่า “ต้าน​ลุก​ไหน​มา” แต่​พระเยซู​บ่﻿ตอบ​อะหยัง ");
INSERT INTO nod_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ปีลาต​เลย​อู้​กับ​พระองค์​ว่า “เยียะ​หยัง​บ่﻿ยอม​อู้​กับ​เฮา ต้าน​บ่﻿ฮู้​กา ว่า​เฮา​มี​อำนาจ​ตี้​จะ​ป่อย​ต้าน​กาว่า​จะ​เขิง​ต้าน​ตี้​ไม้​ก๋าง​เขน​ได้” ");
INSERT INTO nod_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","พระเยซู​ก็​อู้​ว่า “ถ้า​พระเจ้า​บ่﻿ได้​หื้อ​อำนาจ​นั้น​กับ​ต้าน ต้าน​ก็​จะ​บ่﻿มี​อำนาจ​เหนือ​เฮา จาอั้น​คน​ตี้​ยับ​เฮา​มา​หื้อ​ต้าน​ก็​ผิด​นัก​เหลือ​ต้าน” ");
INSERT INTO nod_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","เมื่อ​ปีลาต​ได้ยิน​จาอั้น เขา​ก็​ฮิ​หา​ตาง​ตี้​จะ​ป่อย​พระเยซู แต่​จาว​ยิว​ก็​เอิ้น​ว่า “ถ้า​ต้าน​ป่อย​เขา ต้าน​ก็​บ่﻿ใจ้​เปื้อน​ของ​ซีซาร์ ย้อน​คน​ตี้​อ้าง​ตั๋ว​เก่า​เป๋น​กษัตริย์​ก็​เป๋น​ศัตรู๋​กับ​ซีซาร์” ");
INSERT INTO nod_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","เมื่อ​ปีลาต​ได้ยิน​จาอั้น เขา​ก็​ปา​พระเยซู​ออก​มา แล้ว​ก็​นั่ง​ตี้​นั่ง​ของ​ผู้​พิพากษา​ตี้​ฮ้อง​กั๋น​ว่า “ลานหิน” (​ภาษา​ฮีบรู​ฮ้อง​ว่า “กับบาธา”) ");
INSERT INTO nod_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","วัน​นั้น​เป๋น​วัน​เกียม​งาน​ปัสกา ใก้​เตี้ยง​ปีลาต​ก็​อู้​กับ​หมู่​จาว​ยิว​ว่า “ผ่อ​แล่ นี่​กษัตริย์​ของ​หมู่​ต้าน” ");
INSERT INTO nod_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","หมู่​เขา​ก็​ปา​กั๋น​เอิ้น​ว่า “ฆ่า​มัน​เลย ฆ่า​มัน​เลย เขิง​บน​ไม้​ก๋าง​เขน​เลย” ปีลาต​อู้​กับ​หมู่​เขา​ว่า “หมู่​ต้าน​จะ​หื้อ​เฮา​เขิง​กษัตริย์​ของ​หมู่​ต้าน​ตี้​ไม้​ก๋าง​เขน​กา” หมู่​หัว​หน้า​ปุโรหิต​ก็​ตอบ​ว่า “เฮา​มี​กษัตริย์​องค์​เดียว​เต้าอั้น คือ​ซีซาร์” ");
INSERT INTO nod_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","แล้ว​ปีลาต​ก็​ยก​พระเยซู​หื้อ​หมู่​เขา​เอา​ไป​เขิง​บน​ไม้​ก๋าง​เขน หมู่​ทหาร​ก็​ปา​พระเยซู​ไป ");
INSERT INTO nod_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","แล้ว​หื้อ​พระองค์​แบก​ไม้​ก๋าง​เขน​ของ​พระองค์​ไป​ตี้​ตี้​ฮ้อง​กั๋น​ว่า “เนิน​กระโหล้ง​หัว” ภาษา​ฮีบรู​ฮ้อง​ว่า “กลโกธา” ");
INSERT INTO nod_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","หมู่​เขา​ก็​เอา​พระองค์​ไป​เขิง​บน​ไม้​ก๋าง​เขน​ตี้​หั้น​กับ​นักโต้ษ​แหม​สอง​คน พระเยซู​อยู่​ก๋าง นักโต้ษ​สอง​คน​นั้น​อยู่​คน​ละ​เผิก​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ปีลาต​หื้อ​เขียน​ข้อความ​ติด​ไว้​บน​ไม้​ก๋าง​เขน​ของ​พระองค์​ว่า “เยซู จาว​นาซาเร็ธ กษัตริย์​ของ​จาว​ยิว” ");
INSERT INTO nod_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","จาว​ยิว​หลาย​คน​ก็​ได้​อ่าน​ป้าย​นี้ ย้อน​ตี้​ตี้​เขา​เขิง​พระเยซู​นั้น​อยู่​ใก้​เมือง และ​ป้าย​นั้น​เขียน​เป๋น​ภาษา​ฮีบรู ภาษา​ลาติน กับ​ภาษา​กรีก ");
INSERT INTO nod_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","หมู่​หัว​หน้า​ปุโรหิต​อู้​กับ​ปีลาต​ว่า “ขอ​บ่﻿หื้อ​เขียน​ว่า ‘กษัตริย์​ของ​จาว​ยิว’ แต่​ขอ​หื้อ​เขียน​ว่า ‘ป้อจาย​คน​นี้​อ้าง​ว่า​เป๋น​กษัตริย์​ของ​จาว​ยิว’ ” ");
INSERT INTO nod_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ปีลาต​เลย​ตอบ​หมู่​เขา​ไป​ว่า “อะหยัง​ตี้​เฮา​เขียน​ไป​แล้ว​ก็​หื้อ​แล้ว​ไป​เหีย” ");
INSERT INTO nod_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","เมื่อ​หมู่​ทหาร​เขิง​พระเยซู​แล้ว ก็​เอา​เสื้อผ้า​ของ​พระองค์​มา​แบ่ง​กั๋น​ใน​หมู่​ทหาร​สี่​คน​ได้​คน​ละ​ผืน แต่​เหลือ​เสื้อ​ตั๋ว​ตัง​ใน​ของ​พระเยซู​เป๋น​ผ้า​ตอ​ผืน​เดียว​บ่﻿มี​ดูก ");
INSERT INTO nod_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","หมู่​เขา​เลย​อู้​กั๋น​ว่า “บ่﻿ต้อง​ฉีก​ละ หื้อ​จกเบอร์​กั๋น​เอา​ว่า​ใผ​จะ​ได้” ตี้​เกิด​ขึ้น​จาอี้​ก็​เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​พระคัมภีร์​ตี้​เขียน​ไว้​ว่า “​เขา​เอา​เสื้อผ้า​เฮา​ไป​แบ่ง​กั๋น แล้ว​เอา​เสื้อ​ของ​เฮา​มา​จกเบอร์​” หมู่​ทหาร​ก็​ได้​เยียะ​จาอั้น ");
INSERT INTO nod_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","คน​ตี้​ยืน​อยู่​ใก้​ไม้​ก๋าง​เขน​ของ​พระเยซู​นั้น ก็​มี​แม่​กับ​น้าสาว​ของ​พระองค์ มารีย์​เมีย​เคลโอปัส กับ​มารีย์​จาว​เมือง​มักดาลา ");
INSERT INTO nod_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","เมื่อ​พระเยซู​หัน​แม่​กับ​สาวก​ตี้​พระองค์​ฮัก​ยืน​อยู่​ใก้﻿ๆ หั้น พระองค์​ก็​เลย​อู้​กับ​แม่​ของ​พระองค์​ว่า “แม่​เหย ขอ​หื้อ​ฮับ​คน​นั้น​เป๋น​ลูก​แม่” ");
INSERT INTO nod_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","แล้ว​พระองค์​ก็​อู้​กับ​สาวก​คน​นั้น​ว่า “ฮับ​นาง​เป๋น​แม่​ของ​ต้าน​ตวย” สาวก​คน​นั้น​ก็​ฮับ​แม่​ของ​พระองค์​มา​อยู่​ตี้​บ้าน​ของ​ตั๋ว​เก่า​ตั้งแต่​ต๋อน​นั้น ");
INSERT INTO nod_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","หลังจาก​นั้น พระเยซู​ฮู้​ว่า​กู้​สิ่ง​กู้​อย่าง​เสร็จ​หมด​แล้ว เปื้อ​หื้อ​เป๋น​ไป​ต๋าม​พระคัมภีร์ พระองค์​เลย​อู้​ว่า “เฮา​ใค่​อยาก​กิ๋น​น้ำ” ");
INSERT INTO nod_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","มี​ถ้วย​ใส่​เหล้า​องุ่น​ส้ม​วาง​อยู่​ตี้​หั้น เขา​ก็​เอา​ฟองน้ำ​มา​จุ่ม​เหล้า​องุ่น​นั้น​ใส่​ป๋าย​ไม้​อ้อ​แล้ว​ยก​ขึ้น​เถิง​ปาก​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","บ่ากอง​พระเยซู​กิ๋น​เหล้า​องุ่น​ส้ม​นั้น พระองค์​ก็​อู้​ว่า “เสร็จ​แล้ว” คอ​ของ​พระองค์​แหง็ก​ลง​แล้ว​ก็​ต๋าย ");
INSERT INTO nod_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","วัน​นั้น​เป๋น​วัน​เกียม แล้ว​แหม​วัน​จะ​เป๋น​วัน​สะบาโต​หลวง​ย้อน​ว่า​เป๋น​งาน​ปัสกา หมู่​จาว​ยิว​เลย​ขอ​หื้อ​ปีลาต​สั่ง​ทหาร​ของ​เขา ตุ๊บ​ขา​คน​ตี้​โดน​เขิง​อยู่​บน​ไม้​ก๋าง​เขน​หื้อ​หัก​เหีย แล้ว​หื้อ​เอา​ศพ​ออก​ไป​เปื้อ​บ่﻿หื้อ​ศพ​กา​อยู่​ตี้​ไม้​ก๋าง​เขน​ใน​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","จาอั้น หมู่​ทหาร​เลย​มา​ตุ๊บ​ขา​ของ​คน​แรก​กับ​แหม​คน​นึ่ง​ตี้​โดน​เขิง​อยู่​ข้าง﻿ๆ พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","บ่ากอง​มา​เถิง​พระเยซู เขา​หัน​ว่า​พระองค์​ต๋าย​แล้ว เขา​เลย​บ่﻿ได้​ตุ๊บ​ขา​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","แต่​ทหาร​แหม​คน​นึ่ง​เอา​หอก​แตง​ขี้ข้าง​พระองค์ แล้ว​เลือด​กับ​น้ำ​ก็​ไหล​ปุ้ง​ออก​มา ");
INSERT INTO nod_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","คน​นั้น​ตี้​หัน​ก็​เล่า​เป๋น​พยาน และ​กำ​พยาน​ของ​เขา​ก็​เป๋น​ความ​จริง เขา​ฮู้​ว่า​เขา​อู้​ความ​จริง เปื้อ​ต้าน​ตังหลาย​จะ​ได้​เจื้อ ");
INSERT INTO nod_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","สิ่ง​นี้​เกิด​ขึ้น​เปื้อ​เป๋น​ไป​ต๋าม​พระคัมภีร์ ตี้​ว่า “กระดูก​ของ​พระองค์​จะ​บ่﻿หัก​สัก​อัน” ");
INSERT INTO nod_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","กับ​มี​พระคัมภีร์​แหม​ข้อ​นึ่ง​ตี้​ว่า “หมู่​เขา​จะ​ผ่อ​พระองค์​ตี้​หมู่​เขา​ได้​แตง” ");
INSERT INTO nod_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","หลังจาก​นั้น​โยเซฟ​จาว​อาริมาเธีย​ตี้​เป๋น​สาวก​ลับ﻿ๆ ของ​พระเยซู ย้อน​กั๋ว​หมู่​ผู้นำ​จาว​ยิว ก็​มา​ขอ​ปีลาต​เอา​ศพ​พระเยซู​ไป ปีลาต​ก็​ยอม​หื้อ โยเซฟ​ก็​มา​เอา​ศพ​พระองค์​ไป ");
INSERT INTO nod_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","นิโคเดมัส​คน​ตี้​เกย​ไป​หา​พระเยซู​ต๋อน​เมื่อ​คืน​ก่อน​หน้า​นี้​ก็​มา​ตวย เขา​เอา​เครื่องหอม​มา​ก็​คือ มดยอบ​ผสม​กับ​กฤษณา​หนัก​ประมาณ​สาม​สิบ​กิโลกรัม​ป๋าย ");
INSERT INTO nod_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","โยเซฟ​กับ​นิโคเดมัส​ก็​เอา​ศพ​พระองค์​มา​กับ​เอา​ผ้า​ลินิน​ห่อ​ศพ​กับ​เครื่องหอม​ไว้​ต๋าม​ประเพณี​ก๋าน​ฝัง​ศพ​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ใก้﻿ๆ ตี้​พระเยซู​ถูก​เขิง​นั้น มี​สวน​อยู่​ตี้​นึ่ง ใน​สวน​นั้น​มี​อุโมงค์​ฝัง​ศพ​ใหม่​ตี้​บ่﻿เกย​ใจ๊​ใส่​ศพ​คน​ใด​เตื้อ ");
INSERT INTO nod_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","แล้ว​ย้อน​ว่า​วัน​นั้น​เป๋น​วัน​ดา​วัน​สะบาโต​ของ​จาว​ยิว กับ​อุโมงค์​ฝังศพ​นั้น​ก็​อยู่​ใก้﻿ๆ ตี้​หั้น เขา​ก็​เลย​เอา​ศพ​ของ​พระองค์​วาง​ไว้​ใน​อุโมงค์​นั้น ");
INSERT INTO nod_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","เจ๊ามืด​วัน​ติ๊ด มารีย์​จาว​มักดาลา​มา​เถิง​อุโมงค์​ฝัง​ศพ​ก็​หัน​ว่า​บ่าหิน​ใหญ่​ตี้​ตึด​ปาก​อุโมงค์​นั้น​กิ้ง​ออก​ไป​จาก​ปาก​อุโมงค์​แล้ว ");
INSERT INTO nod_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","นาง​ก็​ฟั่ง​ล่น​ไป​หา​ซีโมน​เปโตร กับ​สาวก​แหม​คน​นึ่ง​ตี้​พระเยซู​ฮัก และ​บอก​หมู่​เขา​ว่า “มี​คน​เอา​ศพ​องค์​พระผู้เป๋นเจ้า​ไป​จาก​อุโมงค์​แล้ว บ่﻿ฮู้​ว่า​เขา​เอา​ศพ​ไป​ไว้​ตี้​ไหน” ");
INSERT INTO nod_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","เปโตร​กับ​สาวก​คน​นั้น​ก็​ไป​ตี้​อุโมงค์​ฝัง​ศพ ");
INSERT INTO nod_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ตึง​สอง​คน​ล่น​ไป​ตวย​กั๋น แต่​สาวก​คน​นั้น​ล่น​เวย​เหลือ​เปโตร จึง​ไป​เถิง​อุโมงค์​ก่อน ");
INSERT INTO nod_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","แต่​บ่﻿ได้​เข้า​ไป​ตัง​ใน ได้​ก้า​ก้ม​ส่อง​เข้า​ไป​แล้ว​ก็​หัน​ผ้า​ปัน​ศพ​วาง​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","บ่ากอง​ซีโมน​เปโตร​ตี้​ตวย​ก้น​สาวก​คน​นั้น​มา​เถิง เขา​ก็​เข้า​ไป​ใน​อุโมงค์​ฝัง​ศพ แล้ว​ก็​หัน​ผ้า​ปัน​ศพ​วาง​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","แต่​ผ้า​ปัน​หัว​ของ​พระเยซู​บ่﻿ได้​วาง​อยู่​กับ​ผ้า​ลินิน แต่​พับ​วาง​ไว้​แยก​แหม​ต่าง​หาก ");
INSERT INTO nod_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","9","สาวก​คน​ตี้​มา​เถิง​ก่อน​ก็​ตวย​เข้า​ไป​ตัง​ใน เถิงแม้​ว่า​หมู่​เขา​ยัง​บ่﻿เข้าใจ๋​ข้อ​พระคัมภีร์​ตี้​ว่า พระองค์​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย แต่​เมื่อ​หมู่​เขา​หัน​ตึง​หมด​นี้ สาวก​คน​นั้น​ก็​เจื้อ​ตี้​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","แล้ว​สาวก​ตึง​สอง​คน​ก็​ปิ๊ก​ไป​บ้าน ");
INSERT INTO nod_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","มารีย์​จาว​มักดาลา​ยัง​ยืน​ไห้​อยู่​ตัง​นอก​อุโมงค์​ฝัง​ศพ ต๋อน​ตี้​ก่ำลัง​ไห้​อยู่​นั้น​นาง​ก็​ก้ม​ส่อง​ผ่อ​ตัง​ใน​อุโมงค์​ฝัง​ศพ ");
INSERT INTO nod_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","แล้ว​ก็​หัน​ทูตสวรรค์​สอง​องค์​ใส่​เสื้อ​สี​ขาว​นั่ง​อยู่​ตั๊ด​ตี้​ศพ​พระเยซู​เกย​วาง​อยู่ องค์​นึ่ง​อยู่​ตัง​หัว แหม​องค์​อยู่​ตัง​ตี๋น ");
INSERT INTO nod_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ทูตสวรรค์​ก็​ถาม​มารีย์​ว่า “เจ้า​ไห้​เยียะ​หยัง” นาง​ก็​ตอบ​ว่า “มี​คน​เอา​องค์​พระผู้เป๋นเจ้า​ของ​ข้าเจ้า​ไป​แล้ว ข้าเจ้า​บ่﻿ฮู้​ว่า​เขา​เอา​พระองค์​ไป​ไว้​ตี้​ไหน” ");
INSERT INTO nod_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","บ่ากอง​มารีย์​อู้​จาอั้น​แล้ว ก็​งว้าย​หลัง​มา ก็​หัน​พระเยซู​ยืน​อยู่​ตี้​หั้น แต่​นาง​บ่﻿ฮู้​ว่า​เป๋น​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","พระองค์​ก็​ถาม​นาง​ว่า “เจ้า​ไห้​เยียะ​หยัง ตวย​เซาะ​หา​ใผ​อยู่​กา” มารีย์​กึ๊ด​ว่า​พระเยซู​เป๋น​คน​เยียะ​สวน​ก็​เลย​อู้​กับ​พระองค์​ว่า “ต้าน​เจ้า ถ้า​ต้าน​เอา​พระองค์​ไป ขอ​บอก​ข้าเจ้า​เต๊อะ​ว่า​ต้าน​เอา​ไป​ไว้​ตี้​ไหน ข้าเจ้า​จะ​ได้​ไป​ฮับ​พระองค์” ");
INSERT INTO nod_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","พระเยซู​ก็​เลย​อู้​ว่า “มารีย์​เหย” มารีย์​ก็​งว้าย​หลัง​มา​ผ่อ​พระองค์​แหม​เตื้อ​แล้ว​ก็​ฮ้อง​เป๋น​ภาษา​ฮีบรู​ว่า “รับโบนี” (​แป๋​ว่า อาจ๋ารย์​) ");
INSERT INTO nod_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","พระองค์​ก็​อู้​กับ​นาง​ว่า “บ่﻿ต้อง​เกาะ​เฮา เฮา​ยัง​บ่﻿ได้​ปิ๊ก​ไป​หา​พระบิดา​ของ​เฮา​เตื้อ แต่​หื้อ​ไป​บอก​หมู่​ปี้น้อง​ตี้​ติดต๋าม​เฮา​ว่า เฮา​จะ​ปิ๊ก​ไป​หา​พระบิดา​ของ​เฮา ตี้​เป๋น​พระบิดา​ของ​ต้าน​ตังหลาย ก็​คือ​ไป​หา​พระเจ้า​ของ​เฮา​ตี้​เป๋น​พระเจ้า​ของ​ต้าน​ตังหลาย​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","มารีย์ จาว​มักดาลา​ก็​ไป​บอก​หมู่​สาวก​ของ​พระเยซู​ว่า “ข้าเจ้า​ได้​หัน​องค์​พระผู้เป๋นเจ้า​แล้ว” และ​มารีย์​ก็​ได้​เล่า​ว่า​พระองค์​อู้​อะหยัง​กับ​นาง​พ่อง ");
INSERT INTO nod_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","เมื่อ​แลง​วัน​ติ๊ด ต๋อน​หมู่​สาวก​อยู่​รวม​กั๋น หมู่​เขา​ก็​หับ​ปะตู๋​ใส่​ก๋อน​ห้อง ย้อน​กั๋ว​หมู่​ผู้นำ​จาว​ยิว พระเยซู​ก็​มา​ยืน​อยู่​ต้ามก๋าง​หมู่​เขา​แล้ว​ก็​อู้​ว่า “ขอ​หื้อ​หมู่​ต้าน​มี​สันติสุข​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","เมื่อ​พระองค์​อู้​จาอั้น​แล้ว พระองค์​ก็​เอา​มือ​กับ​ขี้ข้าง​หื้อ​หมู่​เขา​ผ่อ หมู่​สาวก​ก็​ปา​กั๋น​ดี​อก​ดี​ใจ๋​ตี้​ได้​หัน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","แล้ว​พระเยซู​ก็​อู้​แหม​ว่า “ขอ​หื้อ​หมู่​ต้าน​มี​สันติสุข​เต๊อะ ต๋อน​นี้​เฮา​จะ​ใจ๊​หมู่​ต้าน​ไป​เหมือน​กับ​ตี้​พระบิดา​ใจ๊​เฮา​มา” ");
INSERT INTO nod_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","บ่ากอง​พระเยซู​อู้​จาอั้น​แล้ว ก็​เป่า​ลมหายใจ๋​หด​หมู่​เขา​แล้ว​ก็​อู้​ว่า “ฮับ​พระวิญญาณ​บริสุทธิ์​ไป​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ถ้า​หมู่​ต้าน​ยกโต้ษ​ความ​บาป​หื้อ​ใผ คน​นั้น​ก็​ได้​ฮับ​ก๋าน​ยกโต้ษ แต่​ถ้า​หมู่​ต้าน​บ่﻿ยอม​ยกโต้ษ​หื้อ​ใผ คน​นั้น​ก็​บ่﻿ได้​ฮับ​ก๋าน​ยกโต้ษ​ตวย” ");
INSERT INTO nod_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","โธมัส ตี้​เขา​ฮ้อง​กั๋น​ว่า​แฝด เป๋น​สาวก​คน​นึ่ง​ใน​สิบ​สอง​คน เขา​บ่﻿ได้​อยู่​กับ​หมู่​สาวก​ต๋อน​ตี้​พระเยซู​มา​หา ");
INSERT INTO nod_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","สาวก​คน​อื่น​มา​บอก​เขา​ว่า “หมู่​เฮา​ได้​หัน​องค์​พระผู้เป๋นเจ้า​แล้ว” แต่​โธมัส​ก็​อู้​กับ​หมู่​เขา​ว่า “ถ้า​เฮา​บ่﻿ได้​หัน​ฮอย​เหล็กกน​ตี้​มือ​ของ​อาจ๋ารย์ และ​บ่﻿ได้​เอา​นิ้ว​แหย่​เข้า​ไป​ใน​ฮู​เหล็กกน​กับ​แผล​ตี้​ขี้ข้าง​อาจ๋ารย์ เฮา​ตึง​บ่﻿เจื้อ” ");
INSERT INTO nod_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","เมื่อ​ผ่าน​ไป​ได้​ติ๊ด​นึ่ง ต๋อน​ตี้​หมู่​สาวก​ของ​พระองค์​มา​จุม​กั๋น​อยู่​ใน​บ้าน​นั้น​แหม โธมัส​ก็​อยู่​ตวย เถิงแม้​ว่า​ปะตู๋​หับ​ใส่​ก๋อน​แล้ว แต่​พระเยซู​ก็​เข้า​มา​อยู่​ต้ามก๋าง​หมู่​เขา​แล้ว​ก็​อู้​ว่า “ขอ​หื้อ​หมู่​ต้าน​มี​สันติสุข​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","แล้ว​พระองค์​อู้​กับ​โธมัส​ว่า “โธมัส​เหย เอา​นิ้ว​มา​แหย่​ตี้​นี่​กับ​ผ่อ​มือ​ของ​เฮา แล้ว​ก็​เอา​มือ​ซวาม​ขี้ข้าง​ของ​เฮา​เหีย บ่﻿ต้อง​สงสัย​แหม หื้อ​เจื้อ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","แล้ว​โธมัส​ก็​ฮ้อง​ขึ้น​มา​ว่า “องค์​พระผู้เป๋นเจ้า พระเจ้า​ของ​ข้า​พระองค์” ");
INSERT INTO nod_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","พระเยซู​ก็​อู้​กับ​เขา​ว่า “ย้อน​ต้าน​ได้​หัน​เฮา ต้าน​เลย​เจื้อ​กา คน​ตี้​บ่﻿หัน​เฮา​แต่​เจื้อ​นั้น ก็​เป๋น​สุข” ");
INSERT INTO nod_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","พระเยซู​ได้​เยียะ​หมายสำคัญ​แหม​หลาย​อย่าง​หื้อ​หมู่​สาวก​หัน แต่​บ่﻿ได้​เขียน​ไว้​ใน​หนังสือ​เล่ม​นี้ ");
INSERT INTO nod_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","แต่​ตี้​ได้​เขียน​สิ่ง​หมู่​นี้​ลง​ไป​ก็​เปื้อ​หมู่​ต้าน​จะ​เจื้อ​ว่า พระเยซู​เป๋น​พระคริสต์ คือ​พระบุตร​ของ​พระเจ้า และ​ถ้า​ใผ​วางใจ๋​พระองค์ ก็​จะ​มี​จีวิต​นิรันดร์ ");
INSERT INTO nod_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","หลัง​จาก​นั้น​พระเยซู​ก็​มา​หื้อ​หมู่​สาวก​หัน​แหม​เตื้อ​นึ่ง​ตี้​ทะเล​สาบ​ทิเบเรียส เรื่อง​เป๋น​จาอี้​คือ ");
INSERT INTO nod_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ต๋อน​นั้น​ซีโมน​เปโตร โธมัส​ตี้​เขา​ฮ้อง​กั๋น​ว่า​แฝด นาธานาเอล​ตี้​มา​จาก​หมู่บ้าน​คานา​ใน​แคว้น​กาลิลี ลูกบ่าว​สอง​คน​ของ​เศเบดี กับ​สาวก​แหม​สอง​คน​ของ​พระเยซู ก็​อยู่​ตวย​กั๋น​ตึง​หมด ");
INSERT INTO nod_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","แล้ว​ซีโมน​เปโตร​ก็​บอก​หมู่​เขา​ว่า “เฮา​จะ​ไป​เซาะ​ป๋า” หมู่​เขา​ตึง​หมด​ก็​บอก​ว่า “เฮา​จะ​ไป​ตวย” แล้ว​หมู่​เขา​ก็​ลง​เฮือ​ไป แต่​ตึง​คืน​นั้น​หมู่​เขา​เซาะ​ป๋า​บ่﻿ได้​สัก​ตั๋ว ");
INSERT INTO nod_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","เมื่อ​เถิง​ต๋อน​เจ๊า พระเยซู​ยืน​อยู่​บน​ต๋า​ฝั่ง แต่​หมู่​สาวก​บ่﻿ฮู้​ว่า​เป๋น​พระเยซู ");
INSERT INTO nod_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","พระเยซู​เลย​ถาม​หมู่​เขา​ว่า “เปื้อน​เหย ได้​ป๋า​พ่อง​ก่อ” หมู่​เขา​ก็​ตอบ​ว่า “บ่﻿ได้​เลย” ");
INSERT INTO nod_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","พระองค์​ก็​อู้​กับ​หมู่​เขา​ว่า “หื้อ​ต้อด​แห​ไป​ตาง​ขวา​เฮือ​ลอ แล้ว​จะ​ได้​ป๋า” เขา​เลย​ต้อด​แห​ลง​ไป ป๋า​นัก​ขนาด​ก็​ติด​แห​จ๋น​สาว​แห​ขึ้น​มา​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","สาวก​คน​ตี้​พระเยซู​ฮัก​ก็​บอก​เปโตร​ว่า “เป๋น​องค์​พระผู้เป๋นเจ้า” บ่ากอง​เปโตร​ได้​ยิน​ว่า​เป๋น​องค์​พระผู้เป๋นเจ้า เขา​ก็​เปี๋ย​เสื้อ​คุม​ตี้​ถอด​ไว้​มา​ใส่ แล้ว​ก็​โดด​ลง​น้ำ​ว่าย​เข้า​ฝั่ง ");
INSERT INTO nod_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","แต่​สาวก​คน​อื่น﻿ๆ นั่ง​เฮือ​ปิ๊ก​มา​กับ​ลาก​แห​ตี้​มี​ป๋า​ติด​เต๋ม​นั้น​มา​ตวย ย้อน​หมู่​เขา​อยู่​บ่﻿ไก๋​ฝั่ง​นัก ประมาณ​ร้อย​เมตร​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","บ่ากอง​หมู่​เขา​ขึ้น​มา​บน​ฝั่ง​แล้ว ก็​หัน​ถ่าน​ติด​ไฟ​มี​ป๋า​ปิ้ง​อยู่​ตัง​บน​กับ​มี​เข้าหนมปัง​อยู่ ");
INSERT INTO nod_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","พระเยซู​ก็​อู้​กับ​หมู่​เขา​ว่า “เอา​ป๋า​ตี้​ได้​ตะ​กี้​มา​พ่อง​ลอ” ");
INSERT INTO nod_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ซีโมน​เปโตร​ก็​ลง​เฮือ​ไป​ลาก​แห​ขึ้น​มา ป๋า​ใหญ่​ติด​เต๋ม​แห​นับ​ได้​มี​ร้อย​ห้า​สิบ​สาม​ตั๋ว แต่​ป๋า​ติด​นัก​จาอั้น​แห​ก็​ยัง​บ่﻿ปุด ");
INSERT INTO nod_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","พระเยซู​ก็​อู้​กับ​หมู่​เขา​ว่า “มา​กิ๋น​ข้าวงาย​กั๋น​เต๊อะ” หมู่​สาวก​บ่﻿มี​ใผ​ก้า​ถาม​พระองค์​ว่า “ต้าน​เป๋น​ใผ” ย้อน​หมู่​เขา​ฮู้​แล้ว​ว่า​เป๋น​องค์​พระผู้เป๋นเจ้า ");
INSERT INTO nod_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","พระเยซู​ก็​หยิบ​เข้าหนมปัง​แจก​หื้อ​หมู่​เขา แล้ว​ก็​เอา​ป๋า​มา​เยียะ​อย่าง​เดียว​กั๋น ");
INSERT INTO nod_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","นี่​เป๋น​เตื้อ​ตี้​สาม​ตี้​พระเยซู​มา​หื้อ​หมู่​สาวก​หัน​หลังจาก​ตี้​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","เมื่อ​หมู่​เขา​กิ๋น​ข้าวงาย​กั๋น​อิ่ม​แล้ว พระเยซู​ก็​อู้​กับ​ซีโมน​เปโตร​ว่า “ซีโมน ลูกบ่าว​ยอห์น​เหย ต้าน​ฮัก​เฮา​นัก​เหลือ​หมู่​นี้​ก่อ” เปโตร​ก็​ตอบ​ว่า “ครับ​องค์​พระผู้เป๋นเจ้า พระองค์​ก็​ฮู้​ว่า​เฮา​ฮัก​พระองค์” พระเยซู​เลย​สั่ง​เปโตร​ว่า “หื้อ​เลี้ยง​ลูก​แกะ​ของ​เฮา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","แล้ว​พระองค์​ก็​ถาม​เขา​เป๋น​เตื้อ​ตี้​สอง​ว่า “ซีโมน ลูกบ่าว​ยอห์น​เหย ต้าน​ฮัก​เฮา​ก่อ” เปโตร​ก็​ตอบ​พระองค์​แหม​ว่า “ครับ​องค์​พระผู้เป๋นเจ้า พระองค์​ก็​ฮู้​ว่า​เฮา​ฮัก​พระองค์” พระเยซู​เลย​สั่ง​เขา​แหม​เตื้อ​ว่า “หื้อ​ผ่อกอย​แกะ​ของ​เฮา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","แล้ว​พระองค์​ก็​ถาม​เขา​เป๋น​เตื้อ​ตี้​สาม​ว่า “ซีโมน ลูกบ่าว​ยอห์น​เหย ต้าน​ฮัก​เฮา​ก่อ” เปโตร​ฮู้สึก​เสียใจ๋​ตี้​พระองค์​ถาม​เขา​เถิง​สาม​เตื้อ​ว่า “ต้าน​ฮัก​เฮา​ก่อ” เขา​เลย​บอก​พระองค์​ว่า “องค์​พระผู้เป๋นเจ้า พระองค์​ก็​ฮู้​กู้​สิ่ง​กู้​อย่าง​แล้ว พระองค์​ฮู้​ว่า​เฮา​ฮัก​พระองค์” พระเยซู​อู้​กับ​เขา​แหม​ว่า “หื้อ​เลี้ยง​แกะ​ของ​เฮา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“เฮา​บอก​ความ​จริง​แก่​ต้าน​ว่า ต๋อน​ต้าน​ยัง​เป๋น​บ่าว ต้าน​มัด​สาย​แอว​คน​เดียว​เกียม​ตั๋ว​ไป​หั้น​ไป​นี่​ต๋าม​ใจ๋​ตั๋วเก่า แต่​เมื่อ​ต้าน​เฒ่า​แล้ว ต้าน​จะ​ยื่น​มือ​หื้อ​คน​อื่น​มัด​สาย​แอว​หื้อ แล้ว​เขา​ก็​จะ​ปา​ต้าน​ไป​หั้น​ไป​นี่​ตี้​ต้าน​บ่﻿ใค่​ไป” ");
INSERT INTO nod_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(​ตี้​พระองค์​อู้​จาอั้น ก็​เปื้อ​บอก​หื้อ​ฮู้​ว่า เปโตร​จะ​ต๋าย​จาใด​เปื้อ​จะ​เยียะ​หื้อ​คน​หัน​เถิง​ความ​ยิ่งใหญ่​ของ​พระเจ้า​) บ่ากอง​พระองค์​อู้​จาอั้น​แล้ว ก็​อู้​กับ​เปโตร​ว่า “ตวย​เฮา​มา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ซีโมน​เปโตร​งว้าย​หลัง​ไป​ก็​หัน​ว่า​สาวก​คน​ตี้​พระเยซู​ฮัก​ตวย​มา (​สาวก​คน​นั้น​ก็​คือ​คน​ตี้​เอน​ตั๋ว​ใก้﻿ๆ พระเยซู​ต๋อน​ตี้​กิ๋น​ข้าว​ก่อน​ตี้​พระเยซู​โดน​ยับ แล้ว​ได้​ถาม​พระองค์​ว่า “อาจ๋ารย์ คน​ตี้​หักหลัง​ต้าน​เป๋น​ใผ​ครับ”) ");
INSERT INTO nod_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","เมื่อ​เปโตร​หัน​สาวก​คน​นั้น​ก็​เลย​ถาม​พระเยซู​ว่า “พระองค์​ครับ แล้ว​คน​นี้​จะ​เป๋น​จาใด” ");
INSERT INTO nod_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","พระเยซู​ก็​ตอบ​เปโตร​ว่า “ถ้า​เฮา​ใค่​หื้อ​เขา​อยู่​จ๋น​เถิง​เฮา​ปิ๊ก​มา​แหม​เตื้อ แล้ว​มัน​เรื่อง​อะหยัง​ของ​ต้าน​ตวย หื้อ​ตวย​เฮา​มา​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ย้อน​กำ​ตี้​พระเยซู​อู้​นั้น ก็​เยียะ​หื้อ​หมู่​ปี้น้อง​ตี้​ติดต๋าม​พระเยซู​เล่า​ลือ​กั๋น​ไป​ใคว่​ว่า​สาวก​คน​นั้น​จะ​บ่﻿ต๋าย แต่​พระเยซู​บ่﻿ได้​บอก​ว่า​สาวก​คน​นั้น​จะ​บ่﻿ต๋าย พระองค์​อู้​ก้า​ว่า “ถ้า​เฮา​ใค่​หื้อ​เขา​อยู่​จ๋น​เถิง​เฮา​ปิ๊ก​มา​แหม​เตื้อ แล้ว​มัน​เรื่อง​อะหยัง​ของ​ต้าน​ตวย” เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","สาวก​คน​นั้น​เนาะ​ตี้​เป๋น​พยาน​เรื่อง​หมู่​นี้ กับ​เป๋น​คน​ตี้​เขียน​บันทึก​สิ่ง​หมู่​นี้​ไว้ แล้ว​หมู่​เฮา​ฮู้​ว่า​กำ​พยาน​ของ​เขา​เป๋น​ความ​จริง ");
INSERT INTO nod_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","มี​แหม​หลาย​อย่าง​ตี้​พระเยซู​ได้​เยียะ​ไว้ ถ้า​จะ​เขียน​ตึง​หมด​นั้น ข้าพเจ้า​กึ๊ด​ว่า​โลก​ตึง​โลก​ก็​บ่﻿ใหญ่​ปอ​จะ​เก็บ​หนังสือ​ตี้​จะ​เขียน​นั้น​ได้");
INSERT INTO nod_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ต้าน​เธโอฟีลัส​ตี้​นับถือ หนังสือ​เล่ม​ก่อน​ตี้​ข้าพเจ้า​เขียน​หื้อ​นั้น เป๋น​เรื่องราว​เกี่ยวกับ​กู้​สิ่ง​กู้​อย่าง​ตี้​พระเยซู​เยียะ​ตึง​สั่ง​สอน​มา​ตั้งแต่​เก๊า ");
INSERT INTO nod_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","จ๋น​แผว​วัน​สุดต๊าย​ตี้​พระองค์​หื้อ​กำสั่ง​โดย​ฤทธิ์​อำนาจ​ของ​พระวิญญาณ​บริสุทธิ์​กับ​หมู่​อัครทูต​ตี้​พระองค์​เลือก​ไว้ แล้ว​พระเจ้า​ก็​ฮับ​พระเยซู​ขึ้น​ไป​บน​สวรรค์ ");
INSERT INTO nod_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ใน​เวลา​สี่​สิบ​วัน​หลัง​ก๋าน​ทน​ตุ๊ก​ทรมาน​จ๋น​ต๋าย​แล้ว พระองค์​ป๋ากฏ​หื้อ​หมู่​เขา​หัน​แหม​หลาย​เตื้อ ตึง​เยียะ​สิ่ง​อัน​เป๋น​ก๋าน​พิสูจน์​หลาย​อย่าง ตี้​ยืนยัน​ว่า​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แต๊﻿ๆ ตึง​ได้​อู้​เถิง​เรื่อง​แผ่นดิน​ของ​พระเจ้า​ตวย ");
INSERT INTO nod_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","มี​เตื้อ​นึ่ง​เมื่อ​พระองค์​ก่ำลัง​กิ๋น​ข้าว​กับ​หมู่​อัครทูต พระองค์​สั่ง​หมู่​เขา​ว่า “ห้าม​ฟั่ง​ไป​ไหน​เตื้อ หื้อ​ถ้า​อยู่​ตี้​กรุง​เยรูซาเล็ม​ก่อน จ๋น​กว่า​หมู่​ต้าน​จะ​ได้ฮับ​สิ่ง​ตี้​พระบิดา​สัญญา​ไว้ ต๋าม​ตี้​เฮา​เกย​อู้​กับ​หมู่​ต้าน​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","คือ​ว่า​ยอห์น​หื้อ​ฮับ​บัพติศมา​ด้วย​น้ำ แต่​แหม​บ่﻿เมิน​ต้าน​ตังหลาย​จะ​ฮับ​บัพติศมา​ด้วย​พระวิญญาณ​บริสุทธิ์” ");
INSERT INTO nod_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","เมื่อ​พระเยซู​กับ​หมู่​อัครทูต​มา​ฮ่วม​กั๋น​แหม หมู่​เขา​ก็​ถาม​พระองค์​ว่า “พระองค์​เจ้าข้า ต๋อน​นี้​พระองค์​ก่ำลัง​จะ​จ้วย​หื้อ​จาว​อิสราเอล​มี​อาณาจักร​เหมือน​ตะก่อน​แม่น​ก่อ” ");
INSERT INTO nod_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","พระเยซู​บอก​กับ​หมู่​เขา​ว่า “บ่﻿ใจ้​เรื่อง​ตี้​ต้าน​ตังหลาย​จะ​ฮู้​วัน​เวลา​ตี้​พระบิดา​ก๋ำหนด​ขึ้น​ด้วย​สิทธิ​อำนาจ​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","แต่​เมื่อ​พระวิญญาณ​บริสุทธิ์​มา​อยู่​กับ​หมู่​ต้าน​แล้ว หมู่​ต้าน​ก็​จะ​ได้​ฮับ​ฤทธิ์​อำนาจ แล้ว​จะ​เป๋น​พยาน​เล่า​เรื่อง​ของ​เฮา​หื้อ​คน​ตังหลาย​ฟัง ตั้งแต่​กรุง​เยรูซาเล็ม​ใคว่​แคว้น​ยูเดีย แคว้น​สะมาเรีย จ๋น​ใคว่​โลก​นี้” ");
INSERT INTO nod_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","เมื่อ​พระเยซู​อู้​จาอั้น​แล้ว พระเจ้า​ก็​ฮับ​พระองค์​ขึ้น​ไป​บน​ต๊องฟ้า​ต่อหน้า​ต่อต๋า​หมู่​เขา แล้ว​ฝ้า​ก็​เกิ้ง​พระองค์​ไว้ จ๋น​หมู่​เขา​ผ่อ​พระองค์​บ่﻿หัน ");
INSERT INTO nod_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ใน​เวลา​ตี้​หมู่​เขา​ก่ำลัง​ปักต๋าผ่อ​พระองค์​จาก​ไป​ใน​ต๊องฟ้า​นั้น อยู่﻿ๆ ก็​มี​ป้อจาย​ใส่​เสื้อผ้า​สี​ขาว​สอง​คน​มา​ยืน​แหมะ​ข้าง​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","แล้ว​อู้​กับ​หมู่​เขา​ว่า “จาว​กาลิลี​เหย หมู่​ต้าน​ยืน​ปักต๋าผ่อ​ต๊องฟ้า​อยู่​เยียะ​หยัง พระเจ้า​ฮับ​พระเยซู​องค์​นี้​ขึ้น​ไป​บน​สวรรค์​แล้ว พระองค์​จะ​ปิ๊ก​มา​แหม​เตื้อ​นึ่ง​เหมือน​ตี้​หมู่​ต้าน​หัน​พระองค์​ขึ้น​ไป​นั้น” ");
INSERT INTO nod_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","แล้ว​หมู่​เขา​ก็​ลง​จาก​ดอย​บ่ากอกเทศ​ปิ๊ก​ไป​กรุง​เยรูซาเล็ม เซิ่ง​อยู่​ห่าง​ออก​ไป​ประมาณ​นึ่ง​กิโลเมตร ");
INSERT INTO nod_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","เมื่อ​มา​แผว​กรุง​เยรูซาเล็ม​แล้ว หมู่​อัครทูต​ก็​ปา​กั๋น​ขึ้น​ไป​ห้อง​จั๊น​บน​ตี้​หมู่​เขา​ย้าง​อาศัย​อยู่​หั้น ใน​หมู่​เขา​มี​เปโตร ยอห์น ยากอบ อันดรูว์ ฟีลิป โธมัส บารโธโลมิว มัทธิว ยากอบ​ลูกบ่าว​ของ​อัลเฟอัส ซีโมน​คน​ของ​พรรค​จ้าดนิยม กับ​ยูดาส​ลูกบ่าว​ของ​ยากอบ​แหม​คน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","หมู่​เขา​พร้อม​ใจ๋​กั๋น​อธิษฐาน​เจื่อ﻿ๆ ฮ่วม​กับ​หมู่​แม่ญิง​ตึง​นาง​มารีย์​แม่​ของ​พระเยซู​ตึง​หมู่​น้อง​ของ​พระองค์​ตวย ");
INSERT INTO nod_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","มี​วัน​นึ่ง​เปโตร​ยืน​ขึ้น​ก๋าง​ปี้น้อง​ผู้เจื้อ​ตังหลาย (​เซิ่ง​อยู่​ตวย​กั๋น​ประมาณ​ร้อย​ซาว​คน​) แล้ว​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ปี้น้อง​ตังหลาย ข้อ​พระคัมภีร์​ตี้​พระวิญญาณ​บริสุทธิ์​ใจ๊​กับ​กษัตริย์​ดาวิด​อู้​ไว้​เมื่อ​ตะก่อน​นั้น เกี่ยวกับ​เรื่อง​ยูดาส​ปา​ทหาร​ไป​ยับ​พระเยซู ก็​จ๋ำเป๋น​ต้อง​เป๋น​ไป​ต๋าม​นั้น ");
INSERT INTO nod_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ยูดาส​เป๋น​คน​นึ่ง​ตี้​นับ​เส้น​เข้า​ตวย​หมู่​เฮา กับ​มี​ส่วน​ฮ่วม​ใน​งาน​ของ​หมู่​เฮา​นี้​ตวย​กั๋น” ");
INSERT INTO nod_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(​ยูดาส​เอา​สตางค์​ตี้​ได้​จาก​ก๋าน​เยียะ​บ่﻿ดี​ไป​ซื้อ​ตี้ดิน​ไว้ ตี้​หั้น​เขา​ผะเลิด​วำ​ลง​ตังหน้า​ขี้ปุ๋ม​แตก​ไส้​สด​ออก​มา​ต๋าย​ขำตี้ ");
INSERT INTO nod_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","เรื่อง​นี้​ฮู้​กั๋น​ใคว่​กรุง​เยรูซาเล็ม หมู่​จาว​เยรูซาเล็ม​จึง​ฮ้อง​ตี้ดิน​ตั๊ด​หั้น​ต๋าม​ภาษา​ต๊องถิ่น​ว่า อาเคลดามา ตี้​แป๋​ว่า “นา​เลือด” ย้อน​ว่า​มี​เลือด​ตก​ใส่​ตี้ดิน​หั้น​) ");
INSERT INTO nod_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","เปโตร​อู้​ต่อ​ไป​ว่า “เรื่อง​นี้​มี​เขียน​ไว้​ใน​พระธรรม​สดุดี​ว่า ‘ขอ​หื้อ​ตี้​อยู่​ของ​เขา​เป๋น​ฮ้าง ห้าม​คน​เข้า​ไป​อยู่​แหม​ต่อ​ไป’ ยัง​มี​เขียน​ไว้​แหม​ว่า ‘ส่วน​ต๋ำแหน่ง​ก๋าน​ฮับใจ๊​ของ​เขา​นั้น หื้อ​คน​อื่น​มา​ฮับ​แตน’ ");
INSERT INTO nod_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ย้อนจาอั้น​หมู่​เฮา​จ๋ำเป๋น​จะ​ต้อง​เลือก​ป้อจาย​แหม​คน​นึ่ง​เอา​มา​แตน​ยูดาส คน​นั้น​จะ​ต้อง​เป๋น​คน​ตี้​อยู่​กับ​หมู่​เฮา​ตลอด​เวลา​ตี้​หมู่​เฮา​อยู่​ตวย​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​นั้น ");
INSERT INTO nod_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","นับ​ตั้งแต่​พระเยซู​ฮับ​บัพติศมา​จาก​ยอห์น จ๋น​แผว​วัน​ตี้​พระเจ้า​ฮับ​พระองค์​ขึ้น​ไป​สวรรค์ เขา​คน​นี้​จะ​ต้อง​เป๋น​พยาน​ฮ่วม​กับ​หมู่​เฮา​ตี้​จะ​อู้​หื้อ​คน​อื่น﻿ๆ ฮู้​ว่า พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว” ");
INSERT INTO nod_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","หมู่​เขา​จึง​เสนอ​จื้อ​ป้อจาย​สอง​คน​คือ โยเซฟ​ตี้​ฮ้อง​กั๋น​ว่า​บารซับบาส (มี​แหม​จื้อ​ว่า​ยุสทัส​) กับ​แหม​คน​คือ​มัทธีอัส ");
INSERT INTO nod_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","แล้ว​หมู่​เขา​ก็​อธิษฐาน​ว่า “ข้า​แต่​พระเจ้า พระองค์​ฮู้​เถิง​จิตใจ๋​ของ​กู้​คน ขอ​พระองค์​โผด​จี๊​หื้อ​หมู่​เฮา​หัน​ว่า​หละหว่าง​สอง​คน​นี้​ใผ​คือ​คน​ตี้​พระองค์​เลือก​หื้อ​เป๋น​อัครทูต​ฮับใจ๊​พระองค์ แตน​ยูดาส​คน​ตี้​ละ​หน้าตี้ แล้ว​ไป​อยู่​ใน​ตี้​ตี้​เปิง​กับ​เขา” ");
INSERT INTO nod_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","แล้ว​หมู่​เขา​ก็​จกเบอร์​กั๋น ได้​จื้อ​มัทธีอัส จึง​เพิ่ม​มัทธีอัส​เข้า​กับ​หมู่​อัครทูต​สิบ​เอ็ด​คน​นั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","เมื่อ​เถิง​วัน​เพ็นเทคอสต์ หมู่​ผู้เจื้อ​ก็​มา​จุมนุม​กั๋น​ใน​ตี้​นึ่ง ");
INSERT INTO nod_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ต๋อน​ตี้​หมู่​เขา​บ่ตันมึ้ง​นั้น ก็​มี​เสียง​จาก​ต๊องฟ้า​เหมือน​กับ​เสียง​ลม​หลวง​ปั๊ด​ดัง​ใคว่​ไป​ตึง​บ้าน​ตึง​เฮือน​ตี้​หมู่​เขา​ก่ำลัง​จุมนุม​กั๋น​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","แล้ว​หมู่​เขา​ก็​หัน​สิ่ง​นึ่ง​เหมือน​เปล๋วไฟ​ตี้​มี​ฮูปฮ่าง​เหมือน​ลิ้น​ลอย​มา​อยู่​บน​หัว​หมู่​เขา​กู้​คน ");
INSERT INTO nod_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","แล้ว​หมู่​เขา​กู้​คน​ก็​ได้​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ จึง​ตั้งเก๊า​อู้​ภาษา​ต่าง﻿ๆ ตี้​บ่﻿เกย​ฮู้​ต๋าม​ตี้​พระวิญญาณ​บริสุทธิ์​โผด​หื้อ​อู้ ");
INSERT INTO nod_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ต๋อน​นั้น​มี​จาว​ยิว​ตี้​เก๋งกั๋ว​พระเจ้า​ลุก​จาก​หลาย​ประเทศ​ใคว่​โลก​มา​อยู่​ใน​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","เมื่อ​ได้ยิน​เสียง​จาอั้น คน​ตังหลาย​ก็​ปา​กั๋น​มา​ผ่อ แล้ว​ก็​ปา​กั๋น​งืด​ตี้​ได้ยิน​หมู่​ผู้เจื้อ​อู้​เป๋น​ภาษา​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","คน​ตังหลาย​ก็​อู้​กั๋น​ว่า “คน​หมู่​นี้​เป๋น​จาว​กาลิลี​ตึงหมด​บ่﻿ใจ้​กา ");
INSERT INTO nod_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","แล้ว​เป๋น​จาใด​หมู่​เฮา​ได้ยิน​หมู่​เขา​อู้​เป๋น​กำ​ภาษา​บ้าน​เกิด​เมือง​นอน​ของ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ตี้​เป๋น​จาว​ปารเธีย จาว​มีเดีย ตึง​จาว​เอลาม ตึง​คน​ตี้​อยู่​ใน​เขตแดน​เมโสโปเตเมีย ตึง​คน​ตี้​อยู่​ใน​แคว้น​ยูเดีย แคว้น​คัปปาโดเซีย แคว้น​ปอนทัส แคว้น​เอเชีย​ ");
INSERT INTO nod_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","แคว้น​ฟรีเจีย แคว้น​ปัมฟีเลีย ประเทศ​อียิปต์ ตึง​คน​ใน​แคว้น​ลิเบีย​ใก้​เมือง​ไซรีน หมู่​ตี้​มา​จาก​กรุง​โรม​ตี้​มา​แอ่ว เซิ่ง​มี​ตึง​จาว​ยิว​กับ​คน​ตี้​เข้า​ฮีต​ศาสนา​ยิว ");
INSERT INTO nod_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ตึง​จาว​เกาะ​ครีต กับ​จาว​อาระเบีย​ตวย หมู่​เฮา​ได้ยิน​หมู่​เขา​อู้​เรื่อง​สิ่ง​อัศจ๋รรย์​ของ​พระเจ้า​เป๋น​กำ​ภาษา​ของ​หมู่​เฮา​ลู้” ");
INSERT INTO nod_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","คน​หมู่​นั้น​ก็​ปา​กั๋น​งืด​ขำอก​ขำใจ๋​อธิบาย​บ่﻿ได้ จึง​เหลียว​มา​ถาม​กั๋น​ว่า “อะหยัง​กั๋น​ปะล้ำ​ปะเหลือ​นี่” ");
INSERT INTO nod_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ซ้ำ​คน​ก็​ใค่หัว​ใส่​หมู่​ผู้เจื้อ​อู้​ว่า “คน​หมู่​นี้​ท่า​จะ​เมา​เหล้า​องุ่น​เหีย​ละ​ก้า” ");
INSERT INTO nod_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","แล้ว​เปโตร​ตึง​หมู่​อัครทูต​แหม​สิบ​เอ็ด​คน​นั้น​ก็​ลุก​ยืน​ขึ้น​อู้​กับ​คน​ตังหลาย​ด้วย​เสียง​อัน​ดัง​ว่า “ต้าน​จาว​ยิว​ตังหลาย​ตึง​หมู่​คน​ตี้​อาศัย​อยู่​ใน​กรุง​เยรูซาเล็ม ขอ​ปา​กั๋น​ดัก​ก่อน เฮา​จะ​บอก​หื้อ​ต้าน​ตังหลาย​ฟัง ");
INSERT INTO nod_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","คน​หมู่​นี้​บ่﻿ได้​เมา​เหล้า​อย่าง​ตี้​หมู่​ต้าน​กึ๊ด​เน่อ บ่าเดี่ยวนี้​เป๋น​เวลา​เก้า​โมง​เจ๊า​อยู่​ลอ ");
INSERT INTO nod_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","แต่​สิ่ง​ตี้​ต้าน​ตังหลาย​หัน​เมื่อเจ๊า​นี้ เป๋น​สิ่ง​ตี้​ได้​เกิด​ขึ้น​ต๋าม​ตี้​โยเอล​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​อู้​ไว้​เมิน​แล้ว​ว่า ");
INSERT INTO nod_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘พระเจ้า​บอก​ว่า​ใน​วาระ​สุดต๊าย เฮา​จะ​หื้อ​พระวิญญาณ​บริสุทธิ์​ลง​มา​อยู่​กับ​มนุษย์​ตังหลาย ลูกบ่าว​ลูกสาว​ของ​ต้าน​ตังหลาย​จะ​ออก​ไป​บอก​ถ้อยกำ​ของ​พระเจ้า คน​หนุ่ม​จะ​หัน​นิมิต คน​เฒ่า​คน​แก่​จะ​ฝัน​หัน ");
INSERT INTO nod_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ใน​เวลา​นั้น​เฮา​จะ​หื้อ​พระวิญญาณ​บริสุทธิ์​ลง​มา​อยู่ กับ​ข้าใจ๊​จาย​ญิง​ตังหลาย​ของ​เฮา แล้ว​เขา​ตังหลาย​จะ​บอก​ถ้อยกำ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","เฮา​จะ​แสดง​สิ่ง​ปาฏิหาริย์​ใน​ต๊องฟ้า​ตัง​บน ตึง​หมายสำคัญ​ตี้​แผ่นดิน​โลก​ตัง​ลุ่ม จะ​มี​เลือด มี​ไฟ มี​หมอก​ควัน​มืดตึ๊บ ");
INSERT INTO nod_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ตะวัน​จะ​มืด​ไป เดือน​จะ​ก๋าย​เป๋น​สี​แดง​เหมือน​เลือด ก่อน​จะ​เถิง​วัน​อัน​ยิ่งใหญ่​ของ​องค์​พระ​ผู้​เป๋น​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","แล้ว​คน​ตี้​ฮ้อง​ขอ​พระเจ้า​จ้วย​ก็​จะ​รอด​ป๊น’ ");
INSERT INTO nod_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“จาว​อิสราเอล​ตังหลาย​เหย จง​ฟัง​เน่อ พระเยซู​จาว​นาซาเร็ธ​เป๋น​ผู้​ตี้​พระเจ้า​รับรอง โดย​เยียะ​ก๋าน​ปาฏิหาริย์ ก๋าน​อัศจ๋รรย์ ตึง​หมายสำคัญ​ต่าง﻿ๆ ผ่าน​พระเยซู ต๋าม​ตี้​ต้าน​ตังหลาย​ก็​ฮู้​ก็​หัน​มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ต้าน​ผู้​นี้​ถูก​มอบ​ไว้​ต๋าม​แผนก๋าน​ของ​พระเจ้า​ตี้​ฮู้​ล่วง​หน้า​ก่อน​แล้ว​ว่า หมู่​ต้าน​จะ​ฆ่า​พระองค์​โดย​หื้อ​หมู่​คน​บ่﻿ดี​ยับ​พระองค์​ไป​เขิง​บน​ไม้​ก๋าง​เขน ");
INSERT INTO nod_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","แต่​พระเจ้า​เยียะ​หื้อ​พระเยซู​เป๋น​ขึ้น​มา​ใหม่ ก็​ได้​ป๊น​จาก​ความ​เจ็บปวด​จาก​ความ​ต๋าย​เหีย ย้อน​ว่า​ความ​ต๋าย​จะ​ครอบงำ​พระองค์​ไว้​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","กษัตริย์​ดาวิด​อู้​เถิง​พระเยซู​ว่า ‘ข้าพเจ้า​หัน​องค์​พระ​ผู้​เป๋น​เจ้า​อยู่​ส่อง​หน้า​ข้าพเจ้า​ตลอด​เวลา ใจ๋​ของ​ข้าพเจ้า​บ่﻿สะ​ต๊าน​หย้าน​กั๋ว ย้อน​ว่า​พระองค์​อยู่​ตัง​เผิก​ขวา​มือ​ของ​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ย้อนจาอี้​จิตใจ๋​ของ​ข้าพเจ้า​ก็​จื้นเจยบาน ปาก​ของ​ข้าพเจ้า​ก็​อู้​อย่าง​จื้นจมยินดี ตั๋ว​ข้าพเจ้า​จะ​อยู่​อย่าง​มี​ความ​หวัง ");
INSERT INTO nod_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","พระเจ้า​จะ​บ่﻿ละ​จิต​วิญญาณ​ของ​ข้าพเจ้า​ไว้​ใน​แดน​ของ​คน​ต๋าย กับ​บ่﻿ละ​องค์​บริสุทธิ์​ของ​พระองค์​หื้อ​เปื่อย​เน่า​ไป​ใน​ขุมฝังศพ ");
INSERT INTO nod_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","พระองค์​โผด​หื้อ​ข้าพเจ้า​ฮู้​ตาง​แห่ง​จีวิต โผด​หื้อ​ข้าพเจ้า​เต๋ม​บริบูรณ์​ด้วย​ความ​ยินดี ย้อน​อยู่​ส่อง​หน้า​พระองค์’ ");
INSERT INTO nod_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ปี้น้อง​ตังหลาย ข้าพเจ้า​จะ​อู้​อย่าง​มั่นใจ๋​ว่า กษัตริย์​ดาวิด​ผู้​เป๋น​เก๊า​เหง้า​แห่ง​เฮา​ตังหลาย​ตี้​ต๋าย​ไป​แล้ว อุโมงค์​ฝัง​ศพ​ของ​ต้าน​ยัง​มี​อยู่​จ๋น​เถิง​ตึง​วัน​นี้ ");
INSERT INTO nod_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","กษัตริย์​ดาวิด​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ตี้​ฮู้​ว่า​พระเจ้า​หื้อ​กำมั่นสัญญา​แก่​ต้าน​ว่า ลูก​หลาน​คน​นึ่ง​ของ​ต้าน​จะ​สืบ​แตน​บัลลังก์​ของ​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","กษัตริย์​ดาวิด​เล็ง​หัน​เหตุก๋ารณ์​ปาย​หน้า จึง​อู้​เถิง​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ของ​พระคริสต์​ว่า พระเจ้า​จะ​บ่﻿ละ​พระองค์​ไว้​ใน​แดน​ของ​คน​ต๋าย เนื้อหนัง​มังสา​ของ​พระองค์​จะ​บ่﻿เปื่อย​เน่า​ใน​ขุมฝังศพ ");
INSERT INTO nod_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ตี้​อู้​มา​นี้​หมายเถิง​พระเยซู​ตี้​พระเจ้า​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว หมู่​เฮา​จึง​เป๋น​พยาน​ใน​เรื่อง​นี้ ");
INSERT INTO nod_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","พระเจ้า​ก็​ฮับ​พระเยซู​ขึ้น​ไป​อยู่​ตัง​เผิก​ขวา​ของ​พระองค์​แล้ว พระเจ้า​ตี้​เป๋น​พระบิดา​ก็​มอบ​พระวิญญาณ​บริสุทธิ์​หื้อ​กับ​พระเยซู ต๋าม​ตี้​สัญญา​ไว้ พระเยซู​ก็​หื้อ​พระวิญญาณ​บริสุทธิ์​นี้​ไว้​กับ​หมู่​เฮา อย่าง​ตี้​หมู่​ต้าน​ได้​หัน​กับ​ได้ยิน​อยู่​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","กษัตริย์​ดาวิด​บ่﻿ได้​ขึ้น​ไป​บน​สวรรค์ แต่​ต้าน​อู้​ว่า ‘พระเจ้า​อู้​กับ​องค์​พระผู้เป๋นเจ้า​ของ​ข้าพเจ้า​ว่า “หื้อ​นั่ง​ตัง​ขวา​มือ​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","จ๋น​เต๊า​ฮอด​เฮา​จะ​เยียะ​หื้อ​ศัตรู๋​ของ​ต้าน เป๋น​ตี้​ฮอง​ตี๋น​ของ​ต้าน” ’ ” ");
INSERT INTO nod_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","เปโตร​อู้​ต่อ​ว่า “ย้อนจาอั้น​ขอ​หื้อ​จาว​อิสราเอล​ตังหลาย​ฮู้​แต๊﻿ๆ เน่อ​ว่า พระเจ้า​ตั้ง​พระเยซู​ผู้​ตี้​หมู่​ต้าน​ปา​กั๋น​เอา​ไป​เขิง​ไว้​บน​ไม้​ก๋าง​เขน​นั้น หื้อ​เป๋น​ตึง​องค์​พระ​ผู้​เป๋น​เจ้า​เป๋น​ตึง​พระคริสต์​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","เมื่อ​คน​ตังหลาย​ได้ยิน​จาอั้น​แล้ว ก็​ฮู้สึก​บ่﻿ม่วนใจ๋ จึง​ปา​กั๋น​ถาม​เปโตร​ตึง​หมู่​อัครทูต​คน​อื่น﻿ๆ ว่า “ปี้น้อง​เหย เฮา​จะ​เยียะ​จาใด​ดี​นี่” ");
INSERT INTO nod_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","เปโตร​จึง​ตอบ​ว่า “หมู่​ต้าน​จง​กลับใจ๋​จาก​บาป แล้ว​ฮับ​บัพติศมา​ใน​นาม​พระเยซู​คริสต์​เปื้อ​ฮับ​ก๋าน​ยกโต้ษ​บาป แล้ว​พระเจ้า​จะ​หื้อ​พระวิญญาณ​บริสุทธิ์​แก่​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ย้อน​พระเจ้า​สัญญา​ไว้​ว่า​จะ​หื้อ​พระวิญญาณ​บริสุทธิ์​กับ​หมู่​ต้าน ตึง​หมู่​ลูก​หลาน​ของ​ต้าน ตึง​กู้​คน​ตี้​อยู่​ประเทศ​ไก๋﻿ๆ คือ​กู้​คน​ตี้​องค์​พระ​ผู้​เป๋น​เจ้า​พระเจ้า​ของ​เฮา​ฮ้อง​หื้อ​เข้า​มา​หา​พระองค์” ");
INSERT INTO nod_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","แล้ว​เปโตร​ก็​ตักเตื๋อน​กับ​วิงวอน​คน​ตังหลาย​เมิน​ขนาด​ว่า “หื้อ​เอา​ตั๋ว​รอด​หื้อ​ดี หื้อ​ป๊น​จาก​โต้ษ​ตี้​คน​บ่﻿ดี​ใน​สมัย​นี้​จะ​ต้อง​ฮับ” ");
INSERT INTO nod_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","คน​ตังหลาย​ตี้​ยอมฮับ​สิ่ง​ตี้​เปโตร​อู้​ก็​ฮับ​บัพติศมา ใน​วัน​นั้น​มี​คน​เข้า​มา​เป๋น​ผู้เจื้อ​ประมาณ​สาม​ปัน​คน ");
INSERT INTO nod_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","หมู่​เขา​ฟัง​กำ​สั่ง​สอน​ของ​หมู่​อัครทูต ตึง​อยู่​ตวย​กั๋น​เป๋น​เปื้อน​ฮ่วม​ความ​เจื้อ​เดียว​กั๋น​อย่าง​เอา​แต๊​เอา​ว่า กิ๋น​ข้าว​ตวย​กั๋น​กับ​หัก​เข้าหนมปัง​กับ​อธิษฐาน​ตวย​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","หมู่​อัครทูต​เยียะ​ก๋าน​ปาฏิหาริย์​ตึง​หมายสำคัญ​หลาย​สิ่ง​หลาย​อย่าง คน​ตังหลาย​ตี้​หั้น​ก็​มี​ความ​เก๋งกั๋ว​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","หมู่​เขา​ตี้​ฮับเจื้อ​ก็​มา​ฮ่วม​กั๋น​เป๋น​ประจ๋ำ เอา​สิ่งของ​มา​ฮอม​ไว้​เป๋น​ก๋องก๋าง แล้ว​ใจ๊​ตวย​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","หมู่​เขา​ขาย​ตี้ดิน​ตึง​เข้าของ​ต่าง﻿ๆ เอา​เงิน​มา​ปั๋น​หื้อ​คน​ตี้​มี​ความ​จ๋ำเป๋น ");
INSERT INTO nod_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","หมู่​เขา​ไป​จุมนุม​กั๋น​ตี้​ข่วง​พระวิหาร​ตึง​วัน ฮ่วม​พิธี​หัก​เข้าหนมปัง​ใน​บ้าน​เฮือน​ของ​เขา ตึง​เอา​ของกิ๋น​มา​กิ๋น​ตวย​กั๋น​ด้วย​ความ​จื้นจมยินดี​กับ​เต๋มอก​เต๋มใจ๋ ");
INSERT INTO nod_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","กับ​ปา​กั๋น​สรรเสริญ​พระเจ้า แล้ว​กู้​คน​ก็​ซอบ​อก​ซอบ​ใจ๋​หมู่​เขา แล้ว​องค์​พระ​ผู้​เป๋น​เจ้า​ก็​โผด​หื้อ​คน​ตี้​จะ​ฮับ​ความ​รอด​ป๊น​บาป​โต้ษ​เข้า​มา​ใน​หมู่​เขา​นัก​ขึ้น​ตึง​วัน ");
INSERT INTO nod_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","วัน​นึ่ง​เปโตร​กับ​ยอห์น​เตียว​ไป​ตี้​พระวิหาร เข้า​ฮ่วม​ก๋าน​อธิษฐาน​เวลา​ประจ๋ำ​บ่าย​สาม​โมง ");
INSERT INTO nod_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","มี​ป้อจาย​คน​นึ่ง​เป๋น​ง่อยเปี้ย​เสียขา​มา​ตั้งแต่​เกิด กู้​วัน​จะ​มี​คน​หาม​เขา​เข้า​ไป​ไว้​ตี้​ฮิม​ปะตู๋​พระวิหาร เซิ่ง​ปะตู๋​หั้น​จื้อ​ว่า ปะตู๋งาม เปื้อ​แน​ขอ​สตางค์​จาก​คน​ตี้​เข้า​มา​ใน​พระวิหาร​นั้น ");
INSERT INTO nod_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ป้อจาย​คน​นี้​บ่ากอง​หัน​เปโตร​กับ​ยอห์น​ก่ำลัง​เตียว​มา เขา​ก็​ฮ้อง​ขอ​สตางค์ ");
INSERT INTO nod_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","เปโตร​กับ​ยอห์น​ก็​ปักต๋าผ่อ​ไป​ตี้​ป้อจาย​คน​นั้น​แล้ว​อู้​ว่า “ผ่อ​เฮา​นิ” ");
INSERT INTO nod_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","คน​ง่อย​ก็​ผ่อ​ไป​ตี้​คน​ตึง​สอง ผ่อ​ไป​ตวย​ตื่นเต้น​ไป​ตวย ย้อน​กึ๊ด​ว่า​จะ​ได้​สตางค์​จาก​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","แต่​เปโตร​อู้​ว่า “ตึงเนื้อ​ตึง​ตั๋ว​เฮา​บ่﻿มี​สตางค์​สัก​บาท แต่​เฮา​มี​อย่าง​นึ่ง​จะ​หื้อ คือ​ใน​พระ​นาม​พระเยซู​คริสต์​จาว​นาซาเร็ธ หื้อ​ลุก​ขึ้น​บ่าเดี่ยวนี้” ");
INSERT INTO nod_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","แล้ว​เปโตร​ก็​ก๋ำ​มือ​ขวา​ของ​ป้อจาย​คน​นั้น​ตุ้ม​หื้อ​ลุก​ขึ้น ตี๋น​กับ​ข้อแข้ง​ของ​เขา​ก็​มี​แฮง​ขึ้น​มา​บ่าดิด​บ่าเดี่ยว ");
INSERT INTO nod_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","เขา​ก็​โดด​ขึ้น​แล้ว​ก็​เตียว​ได้ เตียว​ไป​ตวย​เต้น​ไป​ตวย ปาก​ก็​อู้​กำ​ยกย่อง​สรรเสริญ​พระเจ้า แล้ว​เข้า​ไป​ใน​ข่วง​พระวิหาร​พร้อม​กั๋น​ตึง​เปโตร​กับ​ยอห์น ");
INSERT INTO nod_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","เมื่อ​คน​ตังหลาย​หัน​เขา​เตียว​ได้​กับ​ฮ้อง​สรรเสริญ​พระเจ้า​จาอั้น ");
INSERT INTO nod_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ก็​จ๋ำ​ได้​ว่า​เขา​คือ​ป้อจาย​คน​ตี้​นั่ง​แน​ขอ​สตางค์​อยู่​ฮิม​ปะตู๋​จื้อ ปะตู๋งาม หมู่​เขา​ปา​กั๋น​ตกขะป้า​งืด​ใน​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​กับ​เขา​คน​นั้น ");
INSERT INTO nod_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ใน​เวลา​ตี้​ป้อจาย​คน​นั้น​ก๋ำ​แขน​เปโตร​กับ​ยอห์น ตี้​ระเบียง​วิหาร​ของ​ซาโลมอน​นั้น คน​ตังหลาย​ก็​งืด​ขนาด​ปา​กั๋น​แตก​ตื่น​ล่น​มา​ผ่อ ");
INSERT INTO nod_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","เมื่อ​เปโตร​หัน​จาอั้น ก็​อู้​กับ​หมู่​เขา​ว่า “ปี้น้อง​จาว​อิสราเอล​เหย งืดใจ๋​กับ​เรื่อง​นี้​เยียะ​หยัง ปักต๋าผ่อ​หมู่​เฮา​เยียะ​หยัง เหมือน​กับ​ว่า​ป้อจาย​คน​นี้​เตียว​ได้​ย้อน​อำนาจ​ของ​เฮา กาว่า​เฮา​เป๋น​คน​เคร่ง​ตาง​ศาสนา​จ๋น​พระเจ้า​เปิง​ใจ๋​จาอั้น​กา ");
INSERT INTO nod_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","บ่﻿ใจ้​จาอั้น​ลอ แต่​พระเจ้า​ตี้​อับราฮัม อิสอัค กับ​ยาโคบ ป้ออุ๊ย​แม่หม่อน​ของ​เฮา​นับถือ ก็​ได้​เยียะ​หื้อ​พระเยซู​ผู้​ฮับใจ๊​ของ​พระองค์​มี​เกียรติ พระเยซู​ก็​คือ​คน​ตี้​หมู่​ต้าน​มอบ​ตั๋ว​หื้อ​ปีลาต​ผู้​เป๋น​เจ้าเมือง ตึง​บ่﻿ยอมฮับ​พระองค์​ต่อ​ปีลาต แม้​ว่า​ปีลาต​ตัดสินใจ๋​ปล่อย​พระองค์​หื้อ​มี​อิสระ ");
INSERT INTO nod_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","หมู่​ต้าน​บ่﻿ยอมฮับ​ผู้​ตี้​บริสุทธิ์​กับ​ถูกต้อง​ต๋าม​ธรรม แต่​ปา​กั๋น​ขอ​หื้อ​ปีลาต​ปล่อย​ตั๋ว​คน​ตี้​ฆ่า​คน​ต๋าย​นั้น​แตน​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","หมู่​ต้าน​ฆ่า​พระเยซู​ผู้​ตี้​เป๋น​ผู้​หื้อ​จีวิต แต่​พระเจ้า​เยียะ​หื้อ​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย หมู่​เฮา​เป๋น​พยาน​ใน​เรื่อง​นี้ ");
INSERT INTO nod_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ป้อจาย​ง่อย​ตี้​หมู่​ต้าน​เกย​ฮู้จัก​หาย​เป๋น​ปกติ ย้อน​ความ​เจื้อ​ใน​ฤทธิ์​เดช​ของ​พระเยซู ความ​เจื้อ​พระเยซู​เยียะ​หื้อ​เขา​หาย​เป๋น​ปกติ อย่าง​ตี้​หมู่​ต้าน​หัน​กับ​ต๋า​จาอี้​ละ ");
INSERT INTO nod_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ปี้น้อง​ตังหลาย​เหย ตั๋ว​เฮา​ฮู้​เน่อ​ว่า​ตี้​หมู่​ต้าน​กับ​หมู่​ผู้​นำ​ของ​ต้าน​เยียะ​จาอั้น​กับ​พระเยซู ก็​บ่﻿ฮู้เรื่อง​ฮู้ราว​ว่า​เยียะ​อะหยัง​ลง​ไป ");
INSERT INTO nod_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","แต่​พระเจ้า​เยียะ​หื้อ​เรื่อง​นี้​เกิด​ขึ้น ต๋าม​ตี้​พระองค์​เกย​บอก​ไว้​ผ่าน​ตาง​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ว่า พระคริสต์​ต้อง​ทน​ตุ๊ก​ทรมาน ");
INSERT INTO nod_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ย้อน​จาอั้น​หมู่​ต้าน​จง​กลับใจ๋​จาก​บาป​ปิ๊ก​มา​หา​พระเจ้า แล้ว​พระองค์​จะ​ล้าง​บาป​หื้อ​ต้าน​จ๋น​หมด​จ๋น​เสี้ยง ");
INSERT INTO nod_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","แล้ว​องค์​พระ​ผู้​เป๋น​เจ้า​จะ​โผด​หื้อ​หมู่​ต้าน​มี​เวลา​พักผ่อน​หย่อนใจ๋ กับ​พระองค์​จะ​ส่ง​พระคริสต์​คือ​พระเยซู​หื้อ​แก่​ต้าน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","แต่​บ่าเดี่ยวนี้​พระเยซู​จะ​ต้อง​อยู่​ใน​สวรรค์​ก่อน จ๋น​เถิง​เวลา​ตี้​พระเจ้า​จะ​เยียะ​กู้​สิ่ง​กู้​อย่าง​หื้อ​ปิ๊ก​เป๋น​เหมือน​เก่า​นั้น ต๋าม​ตี้​พระเจ้า​สัญญา​ไว้​ผ่าน​ตาง​กำ​อู้​ของ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์​ผู้​บริสุทธิ์​ใน​สมัย​โบราณ ");
INSERT INTO nod_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","โมเสส​อู้​ว่า ‘องค์​พระ​ผู้​เป๋น​เจ้า​พระเจ้า​ของ​ต้าน​ตังหลาย​จะ​นำ​คน​นึ่ง​ใน​หมู่​ปี้น้อง​ของ​ต้าน​ตังหลาย หื้อ​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์​เหมือน​ข้าพเจ้า ต้าน​ตังหลาย​ต้อง​เจื้อฟัง​กู้​สิ่ง​กู้​อย่าง​ตี้​เปิ้น​อู้​เน่อ ");
INSERT INTO nod_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ใผ​บ่﻿เจื้อฟัง​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​นี้ ก็​จะ​ถูก​ตัด​ออก​จาก​ก๋าน​เป๋น​คน​ของ​พระเจ้า แล้ว​ปะ​กับ​ความ​ฉิบหาย’ ");
INSERT INTO nod_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“ซามูเอล​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​กับ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​อื่น﻿ๆ ตี้​ตวย​มา​เมื่อลูน ก็​เกย​อู้​เรื่อง​ตี้​เกิด​ขึ้น​ใน​บ่าเดี่ยว​นี้​กั๋น​กู้​คน ");
INSERT INTO nod_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","พระสัญญา​ตี้​พระเจ้า​หื้อ​ไว้​ผ่าน​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์​ก็​หื้อ​ไว้​สำหรับ​หมู่​ต้าน กับ​หมู่​ต้าน​จะ​มี​ส่วนฮ่วม​ใน​พันธสัญญา​ของ​พระเจ้า​ตี้​เยียะ​ไว้​กับ​ป้ออุ๊ย​แม่หม่อน​ของ​ต้าน พระเจ้า​อู้​กับ​อับราฮัม​ว่า ‘คน​กู้​เจื๊อจ้าด​ใน​โลก​จะ​ได้ฮับ​ปอน​ผ่าน​ตาง​เจื๊อสาย​ของ​เจ้า’ ");
INSERT INTO nod_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","เมื่อ​พระเจ้า​แต่งตั้ง​พระเยซู​ผู้​ฮับใจ๊​พระองค์ พระเจ้า​ก็​ส่ง​ต้าน​มา​หื้อ​จาว​อิสราเอล​ก่อน เปื้อ​ปั๋น​ปอน​หื้อ​หมู่​ต้าน โดย​หื้อ​ต้าน​ตังหลาย​ปิ๊ก​งว้าย​จาก​เส้นตาง​จีวิต​ตี้​บ่﻿ดี” ");
INSERT INTO nod_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","เมื่อ​เปโตร​กับ​ยอห์น​ก่ำลัง​อู้​กับ​คน​ตังหลาย​อยู่​หั้น หมู่​ปุโรหิต นายทหาร​ฮักษา​พระวิหาร ตึง​หมู่​สะดูสี​ปา​กั๋น​งอม​เข้า​ใส่​คน​ตึง​สอง ");
INSERT INTO nod_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","หมู่​เขา​โขด​ตึง​สอง​ย้อน​สอน​คน​ตังหลาย​ว่า​มี​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย เหมือน​ตี้​พระเจ้า​เยียะ​หื้อ​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น ");
INSERT INTO nod_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","หมู่​เขา​จึง​ยับ​คน​ตึง​สอง​ไป​ขัง​คอก​ไว้​จ๋น​แผว​วันพูก​เมื่อเจ๊า​ย้อน​ว่า​ค่ำ​แล้ว (​กฎหมาย​ของ​จาว​ยิว​บ่﻿หื้อ​คน​ขึ้น​ศาล​ต๋อน​มืด​ค่ำ​) ");
INSERT INTO nod_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","แต่​หลาย​คน​ตี้​ฟัง​ก็​เจื้อ​ใน​เรื่อง​ตี้​เปโตร​กับ​ยอห์น​สั่ง​สอน จ๋น​บ่าเดี่ยวนี้​มี​ผู้เจื้อ​ตี้​เป๋น​ป้อจาย​ประมาณ​ห้า​ปัน​คน​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ต่อ​มา​แผว​วันพูก​หมู่​ผู้​นำ​จาว​ยิว หมู่​คน​เฒ่า​คน​แก่ กับ​หมู่​ธรรมาจ๋ารย์​มา​อยู่​ตวย​กั๋น​ใน​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ใน​ก๋าน​ประชุม​นั้น​มี​อันนาส​เซิ่ง​เป๋น​มหา​ปุโรหิต คายาฟาส ยอห์น อเล็กซานเดอร์ กับ​ญาติ​ป้อจาย​คน​อื่น﻿ๆ ของ​มหา​ปุโรหิต ");
INSERT INTO nod_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","คน​หมู่​นั้น​สั่ง​หื้อ​เปโตร​กับ​ยอห์น​มา​ยืน​อยู่​ส่อง​หน้า​หมู่​เขา แล้ว​ถาม​ว่า “เจ้า​ตึง​สอง​มี​อำนาจ​อะหยัง​มา​เยียะ​จาอี้ กาว่า​ใจ๊​สิทธิ​อำนาจ​ของ​ใผ” ");
INSERT INTO nod_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","เวลา​นั้น​เปโตร​ได้​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ จึง​ตอบ​หมู่​เขา​ไป​ว่า “ต้าน​ผู้​นำ​ของ​จ้าด​เฮา หมู่​คน​เฒ่า​คน​แก่​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","วันนี้​หมู่​ต้าน​มา​สอบสวน​สิ่ง​ดี﻿ๆ ตี้​ข้าพเจ้า​เยียะ​หื้อ​กับ​คน​ง่อย​นี้ ใค่​ฮู้​ก๋า​ว่า​เขา​หาย​ง่อย​ได้​จาใด ");
INSERT INTO nod_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ก็​หื้อ​หมู่​ต้าน​กับ​จาว​อิสราเอล​ตังหลาย​ฮู้​ไว้​เต๊อะ​ว่า ป้อจาย​คน​ตี้​ยืน​อยู่​ต่อ​หน้า​ต้าน​ตังหลาย หาย​เป๋น​ปกติ​ด้วย​ฤทธิ์​อำนาจ​ของ​พระเยซู​คริสต์​จาว​นาซาเร็ธ คน​ตี้​หมู่​ต้าน​เอา​ไป​เขิง​ไว้​บน​ไม้​ก๋าง​เขน​จ๋น​ต๋าย แต่​พระเจ้า​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","พระคัมภีร์​เกย​เขียน​ไว้​ว่า พระองค์​เป๋น ‘ศิลา​ตี้​สล่า​อย่าง​หมู่​ต้าน​เอา​ขว้าง​ไป​แล้ว ป๋ากฏ​ว่า​เป๋น​ศิลามุมเอก’ ");
INSERT INTO nod_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","นอกจาก​พระเยซู​แล้ว ก็​บ่﻿มี​ใผ​จ้วย​หมู่​เฮา​รอด​ป๊น​บาป​โต้ษ​ได้ ย้อน​ว่า​บ่﻿มี​ใผ​คน​ใด​ใน​โลก​ตี้​พระเจ้า​หื้อ​เป๋น​ผู้​จ้วย​หื้อ​รอด​สำหรับ​หมู่​เฮา” ");
INSERT INTO nod_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","หมู่​เขา​งืด​ขนาด​เมื่อ​หัน​เปโตร​กับ​ยอห์น​ก้า​อู้​บ่﻿กั๋ว​ใผ สอง​คน​นี้​เป๋น​คน​บ่﻿ได้​ฮับ​ก๋าน​ศึกษา​กับ​บ่﻿เก่ง​ด้าน​ใด​ด้าน​นึ่ง แต่​จ๋ำ​ได้​ว่า​เปโตร​กับ​ยอห์น​เกย​อยู่​กับ​พระเยซู​มา​ก่อน ");
INSERT INTO nod_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","แต่​หมู่​เขา​อู้​อะหยัง​บ่﻿ได้ ย้อน​ว่า​หัน​ป้อจาย​ง่อย​ตี้​ได้​ฮับ​ก๋าน​ฮักษา​จ๋น​หาย​ดี ยืน​แหมะ​เปโตร​ตึง​ยอห์น ");
INSERT INTO nod_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","หมู่​เขา​ก็​สั่ง​หื้อ​เปโตร​กับ​ยอห์น​ออก​ไป​จาก​ตี้​ประชุม​สภา​แซนเฮดริน​ก่อน แล้ว​ก็​เปิ็กษา​กั๋น​ว่า ");
INSERT INTO nod_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“หมู่​เฮา​จะ​เอา​จาใด​กับ​สอง​คน​นี้​ดี​หา ย้อน​คน​ตังหลาย​ตี้​อยู่​ใน​กรุง​เยรูซาเล็ม​ก็​ฮู้​แล้ว​ว่า​สอง​คน​นี้​เยียะ​ก๋าน​อัศจ๋รรย์​ตี้​ยิ่งใหญ่ หมู่​เฮา​จะ​บ่﻿ยอมฮับ​ก็​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","แต่​เปื้อ​บ่﻿หื้อ​เรื่อง​นี้​แพ่​ไป​เข้า​หู​ใผ หมู่​เฮา​ต้อง​ขู่​ว่า​บ่﻿หื้อ​อู้​ใน​นาม​พระเยซู​กับ​ใผ​คน​ใด​แหม​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","จาก​นั้น​หมู่​เขา​ก็​ฮ้อง​เปโตร​กับ​ยอห์น​เข้า​มา แล้ว​สั่ง​ว่า “ห้าม​อู้​กาว่า​สั่ง​สอน​อะหยัง​เกี่ยวกับ​พระเยซู​แหม​ซ้ำ​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","แต่​เปโตร​กับ​ยอห์น​ตอบ​ว่า “ต้าน​ตังหลาย​ตัดสิน​เอา​คน​เดียว​เต๊อะ พระเจ้า​หื้อ​หมู่​เฮา​เจื้อฟัง​ต้าน​ตังหลาย​แตน​ตี้​จะ​เจื้อฟัง​พระองค์​กา ");
INSERT INTO nod_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","หมู่​เฮา​ตึง​อด​บ่﻿ได้​ตี้​จะ​อู้​ใน​สิ่ง​ตี้​หมู่​เฮา​ได้​ฮู้​ได้​หัน” ");
INSERT INTO nod_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","หมู่​เขา​ก็​ขู่​เปโตร​กับ​ยอห์น​แหม แล้ว​ปล่อย​ตึง​สอง​ไป​บ่﻿ฮู้​จะ​ลง​โต้ษ​จาใด​ดี ย้อน​คน​ตังหลาย​ปา​กั๋น​สรรเสริญ​พระเจ้า​ใน​สิ่ง​ตี้​เกิด​ขึ้น​นั้น ");
INSERT INTO nod_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","เป๋น​เรื่อง​อัศจ๋รรย์​แต๊﻿ๆ ตี้​ป้อจาย​เป๋น​ง่อย​ตั้งแต่​เกิด แล้ว​บ่าเดี่ยวนี้​อายุ​ได้​สี่​สิบ​ป๋าย​เตียว​ได้​ดวาก﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","เมื่อ​หมู่​เขา​ปล่อย​เปโตร​กับ​ยอห์น​แล้ว ตึง​สอง​คน​ก็​ปิ๊ก​ไป​หา​หมู่​ผู้เจื้อ เล่า​เรื่อง​ตึงหมด​ตึงเสี้ยง​ตี้​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​ได้​อู้​ได้​ว่า​หื้อ​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","เมื่อ​หมู่​ผู้เจื้อ​ได้ยิน​จาอั้น ก็​ปา​กั๋น​ฮ่วมใจ๋​อธิษฐาน​ต่อ​พระเจ้า​พร้อม​เดียว​กั๋น​ว่า “ข้า​แต่​พระเจ้า​ผู้​ยิ่งใหญ่​สูง​สุด พระองค์​เป๋น​ผู้​สร้าง​ตึง​ต๊องฟ้า​ตึง​โลก​ตึง​ทะเล​กับ​ซะป๊ะ​ตังมวล​ตี้​อยู่​ใน​สถาน​ตี้​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","เมิน​มา​แล้ว​พระองค์​ได้​อู้​ไว้​โดย​พระวิญญาณ​บริสุทธิ์ ผ่าน​ปาก​กษัตริย์​ดาวิด​ผู้​ฮับใจ๊​พระองค์​ตี้​เป๋น​ป้ออุ๊ย​แม่หม่อน​ของ​เฮา​ว่า ‘เป๋น​จาใด​คน​ต่างจ้าด​ปา​กั๋น​โขด ตึง​วางแผน​ต่อต้าน​องค์​พระ​ผู้​เป๋น​เจ้า แต่​จะ​บ่﻿ได้​ผล ");
INSERT INTO nod_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","หมู่​กษัตริย์​ต่าง﻿ๆ ใน​โลก​ก็​ปา​กั๋น​เกียม​ตี้​จะ​สู้ หมู่​ผู้​ปกครอง​ก็​มา​ฮ่วม​กั๋น​ต่อต้าน องค์​พระ​ผู้​เป๋น​เจ้า​กับ​พระคริสต์’ ");
INSERT INTO nod_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","แล้ว​กำ​ทำนาย​นี้​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​ก็​เกิด​ขึ้น​แต๊​ใน​เมือง​นี้ ย้อน​กษัตริย์​เฮโรด​ตึง​ปอนทิอัส ปีลาต​เจ้าเมือง กับ​คน​ต่างจ้าด​กับ​จาว​อิสราเอล ได้​ปา​กั๋น​ต่อต้าน​พระเยซู​ผู้​ฮับใจ๊​ตี้​บริสุทธิ์​ของ​พระองค์ ผู้​ตี้​พระองค์​เจิม​ไว้​เป๋น​พระคริสต์ ");
INSERT INTO nod_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","สิ่ง​ตังมวล​ตี้​เขา​ตังหลาย​หมู่​นั้น​ได้​เยียะ​ก็​เกิด​ขึ้น​ต๋าม​ตี้​พระองค์​ก๋ำหนด​ไว้​ตั้งแต่​เมิน​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","บ่าเดี่ยวนี้​ขอ​พระองค์​โผด​ฟัง​กำ​ขู่​ของ​เขา​หมู่​นั้น ขอ​จ้วย​หมู่​เฮา​ผู้​ฮับใจ๊​ของ​พระองค์​มี​ใจ๋​บ่﻿กั๋ว​ใผ​ตี้​จะ​บอก​เล่า​ถ้อยกำ​ของ​พระองค์​น่อย​เต๊อะ ");
INSERT INTO nod_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ขอ​หื้อ​พระองค์​แสดง​ฤทธิ์​อำนาจ​ตี้​จะ​ฮักษา​คน​ป่วย กับ​เยียะ​หมายสำคัญ​ตึง​ปาฏิหาริย์ ผ่าน​ตาง​พระเยซู​ผู้​ฮับใจ๊​ตี้​บริสุทธิ์​ของ​พระองค์” ");
INSERT INTO nod_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","เมื่อ​หมู่​ผู้เจื้อ​อธิษฐาน​สุด​แล้ว พระเจ้า​ก็​เยียะ​หื้อ​ตี้​เขา​จุมนุม​กั๋น​นั้น​สนั่น​หวั่นไหว หมู่​เขา​ก็​ได้​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ แล้ว​ได้​บอก​เล่า​ถ้อยกำ​ของ​พระเจ้า​อย่าง​บ่﻿กั๋ว​ใผ ");
INSERT INTO nod_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ผู้เจื้อ​ตังหลาย​เป๋น​น้ำนึ่ง​ใจ๋​เดียว​กั๋น ตึง​กึ๊ด​ว่า​สิ่ง​ของ​ตี้​มี​อยู่​นั้น​บ่﻿มี​ใผ​บอก​ว่า​เป๋น​ของ​ตั๋วเก่า ถือ​ว่า​เป๋น​ก๋องก๋าง ก็​ปั๋น​กั๋น​กิ๋น​ปั๋น​กั๋น​ใจ๊​กู้​คน ");
INSERT INTO nod_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","หมู่​อัครทูต​ได้​อู้​อย่าง​มี​อำนาจ เป๋น​พยาน​เรื่อง​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​เป๋น​ขึ้น​จาก​ความ​ต๋าย แล้ว​พระเจ้า​ก็​ปั๋นปอน​หมู่​เขา​กู้​คู่​กู้​คน​นัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","บ่﻿มี​ใผ​ใน​หมู่​เขา​ตี้​ตุ๊กยาก​กั้นอยาก​อะหยัง​เลย ย้อน​ว่า​คน​ตี้​มี​ตี้ดิน​กาว่า​บ้าน​เฮือน​ก็​ขาย​เหีย ");
INSERT INTO nod_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","แล้ว​ก็​เอา​สตางค์​มา​มอบ​หื้อ​อัครทูต​เอา​ไป​แจก​คน​ตี้​มี​ความ​จ๋ำเป๋น ");
INSERT INTO nod_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","เหมือน​กับ​ตั๋วอย่าง​ของ​โยเซฟ​คน​ตี้​หมู่​อัครทูต​ฮ้อง​ว่า​บารนาบัส (​หมายเถิง คน​ตี้​หื้อ​ก๋ำลังใจ๋​) เป๋น​จาว​เลวี เขา​เกิด​ตี้​เกาะ​ไซปรัส ");
INSERT INTO nod_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","โยเซฟ​ขาย​ตี้​นา​ของ​ตั๋ว แล้ว​ก็​เอา​สตางค์​ตี้​ได้​มา​นั้น​หื้อ​กับ​หมู่​อัครทูต ");
INSERT INTO nod_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","มี​ป้อจาย​คน​นึ่ง​จื้อ​อานาเนีย​กับ​เมีย​ของ​เขา​จื้อ​สัปฟีรา ปา​กั๋น​ขาย​ตี้ดิน​ของ​ต๋น​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","แต่​เขา​เก็บ​สตางค์​เอา​ไว้​บาง​ส่วน เมีย​ของ​เขา​ก็​ฮู้​ก็​หัน​ตวย จาก​นั้น​เขา​จึง​นำ​เอา​สตางค์​ส่วน​ตี้​เหลือ​มา​หื้อ​กับ​หมู่​อัครทูต ");
INSERT INTO nod_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","เปโตร​อู้​กับ​อานาเนีย​ว่า “เป๋น​จาใด​เถิง​ยอม​หื้อ​ซาต๋าน​ครอบงำ​จิตใจ๋​หื้อ​จุล่าย​ต่อ​พระวิญญาณ​บริสุทธิ์ แบ่ง​สตางค์​ส่วน​นึ่ง​ตี้​ได้​จาก​ก๋าน​ขาย​ตี้ดิน​เอา​ไว้ ");
INSERT INTO nod_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ตี้ดิน​นั้น​ก็​เป๋น​ของ​เจ้า​อยู่​แล้ว​ก่อน​ตี้​จะ​ขาย​บ่﻿ใจ้​กา หลังจาก​ตี้​ขาย​แล้ว เงิน​นั้น​ก็​ยัง​เป๋น​สิทธิ์​ของ​เจ้า​บ่﻿ใจ้​กา แล้ว​เป๋น​จาใด​เจ้า​กึ๊ด​เยียะ​จาอี้ เจ้า​บ่﻿ได้​จุล่าย​ต่อ​หมู่​เฮา​นา แต่​ก่ำลัง​จุล่าย​ต่อ​พระเจ้า​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","เมื่อ​อานาเนีย​ได้ยิน​กำ​ว่า​จาอั้น​ก็​โก้น​ลง​จั๊ก​ต๋าย​ขำตี้ คน​ตังหลาย​ตี้​หัน​จาอั้น​ก็​กั๋ว​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ป้อจาย​คน​หนุ่ม​หลาย​คน​ก็​มา​ห่อ​ศพ​อานาเนีย แล้ว​ปา​กั๋น​หาม​ออก​ไป​ฝัง​เหีย ");
INSERT INTO nod_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","หลังจาก​นั้น​บ่﻿เมิน​ประมาณ​สัก​สาม​จั้วโมง เมีย​ของ​อานาเนีย​ก็​เตียว​เข้า​มา ยัง​บ่﻿ฮู้​เรื่อง​ตี้​เกิด​ขึ้น​กับ​ผัว​ของ​เขา​สัก​อย่าง​เตื้อ ");
INSERT INTO nod_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","เปโตร​ก็​ถาม​นาง​ว่า “บอก​เฮา​ลอ​ว่า เจ้า​กับ​ผัว​ขาย​ตี้ดิน​ได้​สตางค์​เต้าอี้​แต๊​กา” สัปฟีรา​ตอบ​ว่า “แม่น​แล้ว ได้​เต้าอั้น​แต๊﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","เปโตร​ก็​อู้​กับ​นาง​ว่า “เป๋น​จาใด​สอง​คน​ผัว​เมีย​กู้​นี้ เถิง​ปา​กั๋น​จุล่าย​ลองดี​พระวิญญาณ​บริสุทธิ์​ของ​องค์​พระ​ผู้​เป๋น​เจ้า ผ่อ​หั้น​แล่ คน​หมู่​นั้น​ตี้​ไป​ฝัง​ศพ​ผัว​ของ​เจ้า​ก่ำลัง​เข้า​มา หมู่​เขา​ก็​จะ​ปา​กั๋น​หาม​ศพ​ของ​เจ้า​ออก​ไป​ฝัง​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","สัปฟีรา​ก็​โก้น​ลง​จั๊ก​ต๋าย​ฮิม​ตี๋น​ส่อง​หน้า​เปโตร​บ่า​เดี่ยว​นั้น​เลย เมื่อ​ป้อจาย​หนุ่ม​หมู่​นั้น​เตียว​เข้า​มา​ก็​หัน​ว่า​นาง​ต๋าย​แล้ว หมู่​เขา​จึง​หาม​ศพ​ของ​นาง​ออก​ไป​ฝัง​ไว้​แหมะ​กับ​ผัว​ของ​นาง​หั้น ");
INSERT INTO nod_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ส่วน​คน​ตังหลาย​ใน​คริสตจักร​ตึง​หมู่​คน​อื่น​ตี้​ได้ยิน​เรื่อง​ตี้​เกิด​ขึ้น​นี้​ก็​ปา​กั๋น​กั๋ว​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","หมู่​อัครทูต​ได้​แสดง​ก๋าน​ปาฏิหาริย์​ตึง​หมายสำคัญ​หลาย​อย่าง​ใน​คน​ตังหลาย กับ​หมู่​ผู้เจื้อ​ก็​มา​จุมนุม​กั๋น​ตี้​ระเบียง​วิหาร​ของ​ซาโลมอน ");
INSERT INTO nod_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","คน​อื่น﻿ๆ บ่﻿ก้า​เข้า​ไป​ฮ่วม เถิง​แม้​ว่า​เคารพ​นับถือ​หมู่​เขา​นัก​ขนาด​ก็​ต๋าม ");
INSERT INTO nod_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","แต่​ยัง​มี​ตึง​ป้อจาย​แม่ญิง​ตี้​ฮับเจื้อ​ใน​องค์​พระ​ผู้​เป๋น​เจ้า​เข้า​มา​เพิ่ม​นัก​ขึ้น​ติก﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ย้อน​สิ่ง​ตี้​หมู่​อัครทูต​ได้​เยียะ​นั้น คน​ตังหลาย​ก็​ปา​กั๋น​หาม​คน​เจ็บ​คน​ป่วย​ไป​วาง​บน​ตี้นอน​กับ​สาด​แล้ว​ไป​ไว้​ข้าง​ตาง เปื้อ​อย่าง​หน้อย​เวลา​ตี้​เปโตร​เตียว​ก๋าย​ไป เงา​ของ​ต้าน​อาจ​จะ​ฟาด​ถูก​ตั๋ว​ของ​คน​ป่วย​หมู่​นั้น​พ่อง แล้ว​จะ​หาย​ป่วย ");
INSERT INTO nod_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","มี​หมู่​คน​จ๋ำนวน​นัก​เข้า​มา​ใน​กรุง​เยรูซาเล็ม​ตี้​มา​จาก​หมู่บ้าน​ต่าง﻿ๆ แวด​กรุง​หั้น หมู่​เขา​ปา​คน​ป่วย​กับ​คน​ตี้​ตุ๊ก​ทรมาน​จาก​ผี​ฮ้าย​เข้า​มา​ตวย คน​หมู่​นี้​ก็​ฮับ​ก๋าน​ฮักษา​หื้อ​หาย​หมด​กู้​คน ");
INSERT INTO nod_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","มหา​ปุโรหิต​ตึง​หมู่​ของ​เขา​เซิ่ง​เป๋น​สมาชิก​สะดูสี​ก็​ขอย​หมู่​อัครทูต​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","จึง​ยับ​หมู่​อัครทูต​ไป​ขัง​คอก​ไว้ ");
INSERT INTO nod_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","แต่​เมื่อคืน​นั้น ทูตสวรรค์​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​มา​ไข​ปะตู๋​คอก แล้ว​ปา​หมู่​อัครทูต​ออก​จาก​คอก​ไป ทูตสวรรค์​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“หื้อ​ไป​ตี้​ข่วง​พระวิหาร บอก​คน​ตังหลาย​เถิง​เรื่อง​จีวิต​ใหม่​นี้​ตี้​หั้น​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","หมู่​อัครทูต​ก็​เจื้อฟัง แจ้ง​บ่﻿แจ้ง​หมู่​เขา​ก็​เข้า​ไป​ตี้​ข่วง​พระวิหาร แล้ว​ตั้งเก๊า​สั่ง​สอน​คน​ตังหลาย มหา​ปุโรหิต​กับ​หมู่​ของ​เขา​ฮ้อง​หมู่​คน​เฒ่า​คน​แก่​ของ​จาว​อิสราเอล​มา​ประชุม​สภา​แซนเฮดริน แล้ว​ใจ๊​เจ้าหน้าตี้​ไป​เอา​หมู่​อัครทูต​ออก​จาก​คอก​ปา​มา​ตี้​ประชุม ");
INSERT INTO nod_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","แต่​เมื่อ​เจ้าหน้าตี้​ไป​แผว​คอก​บ่﻿ปะ​หมู่​อัครทูต​อยู่​ใน​หั้น หมู่​เขา​ก็​ปิ๊ก​มา​รายงาน​ว่า ");
INSERT INTO nod_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“หมู่​เฮา​หัน​คอก​ปิด​แน่นหนา​จ้าดดี ยาม​ก็​ยัง​เฝ้า​อยู่​ตี้​ปะตู๋ แต่​เมื่อ​ไข​ปะตู๋​เข้า​ไป ก็​บ่﻿หัน​มี​ใผ​อยู่​ใน​หั้น​สัก​คน” ");
INSERT INTO nod_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","เมื่อ​นายทหาร​ฮักษา​พระวิหาร​ตึง​หมู่​หัวหน้า​ปุโรหิต​ได้ยิน​จาอั้น ก็​งืด​อิกขะหลิก​ใจ๋​ว่า​จะ​มี​อะหยัง​เกิด​ขึ้น​แหม​ต่อไป ");
INSERT INTO nod_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","แล้ว​มี​คน​นึ่ง​เข้า​มา​รายงาน​ว่า “หมู่​คน​ตี้​ต้าน​ยับ​ไป​ขัง​คอก​ไว้​นั้น บ่าเดี่ยวนี้​ก่ำลัง​ยืน​สั่ง​สอน​คน​ตังหลาย​อยู่​ตี้​ข่วง​พระวิหาร​ปู๊น​ลอ” ");
INSERT INTO nod_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","แล้ว​นายทหาร​ฮักษา​พระวิหาร​กับ​เจ้าหน้าตี้​ก็​ออก​ไป​ปา​หมู่​อัครทูต​เข้า​มา แต่​บ่﻿ใจ๊​ก่ำลัง​บังคับ ย้อน​กั๋ว​คน​ตังหลาย​จะ​เอา​บ่าหิน​ขว้าง​ใส่ ");
INSERT INTO nod_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","หมู่​เขา​ปา​หมู่​อัครทูต​เข้า​มา​ยืน​อยู่​ต่อ​หน้า​ตี้​ประชุม​สภา แล้ว​มหา​ปุโรหิต​ก็​ถาม​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“หมู่​เฮา​สั่ง​ห้าม​อย่าง​เด็ดขาด​แล้ว​ว่า บ่﻿หื้อ​สอน​ใน​นาม​ของ​พระเยซู​เวลา​ตี้​สั่ง​สอน​บ่﻿ใจ้​กา แต่​หมู่​เจ้า​ก็​ยัง​เผยแพ่​กำสอน​ของ​เจ้า​นี้​ไป​ใคว่​กรุง​เยรูซาเล็ม แล้ว​ตั้งใจ๋​นาบโต้ษ​หมู่​เฮา​ว่า​เยียะ​หื้อ​เยซู​ต้อง​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","เปโตร​กับ​หมู่​อัครทูต​คน​อื่น﻿ๆ ก็​อู้​ว่า “หมู่​เฮา​จ๋ำเป๋น​ต้อง​เจื้อฟัง​กำสั่ง​ของ​พระเจ้า​นัก​เหลือ​เจื้อฟัง​กำสั่ง​ของ​มนุษย์ ");
INSERT INTO nod_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","พระเจ้า​ของ​ป้ออุ๊ย​แม่หม่อน​ของ​เฮา​เยียะ​หื้อ​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย ผู้​ตี้​ต้าน​ตังหลาย​ฆ่า​โดย​เอา​พระองค์​เขิง​บน​ไม้​ก๋าง​เขน​จ๋น​ต๋าย​นั้น ");
INSERT INTO nod_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","พระเจ้า​ยก​พระเยซู​ไว้​หื้อ​อยู่​ตัง​เผิก​ขวา​ของ​พระองค์ ใน​ฐานะ​เป๋น​เจ้า​เป๋น​นาย​กับ​เป๋น​พระ​ผู้​จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ เปื้อ​คน​จ้าด​อิสราเอล​จะ​สามารถ​กลับใจ๋​จาก​บาป แล้ว​ฮับ​ก๋าน​ยกโต้ษ​บาป ");
INSERT INTO nod_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","หมู่​เฮา​เป๋น​พยาน​ใน​เรื่อง​นี้ พระวิญญาณ​บริสุทธิ์​ตี้​พระเจ้า​มอบ​หื้อ​กับ​กู้​คน​ตี้​เจื้อฟัง​พระองค์ ก็​เป๋น​พยาน​ตวย​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","เมื่อ​หมู่​สมาชิก​ใน​สภา​ได้ยิน​จาอั้น​ก็​หมิ้ง​ขนาด กับ​กึ๊ด​ว่า​จะ​ฆ่า​อัครทูต​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","แต่​มี​สมาชิก​สภา​คน​นึ่ง​จื้อ​กามาลิเอล เป๋น​ฟาริสี​กับ​เป๋น​ครู​สอน​บท​บัญญัติ​ตวย เป๋น​คน​ตี้​คน​ตังหลาย​นับถือ เขา​ลุก​ขึ้น​ยืน แล้ว​สั่ง​หื้อ​ปา​หมู่​อัครทูต​ออก​ไป​ตัง​นอก​เหีย​สัก​บึด​ก่อน ");
INSERT INTO nod_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","แล้ว​ต้าน​อู้​ว่า “จาว​อิสราเอล​ตังหลาย หละวัง​ตั๋ว​หื้อ​ดี​เน่อ ใน​สิ่ง​ตี้​ต้าน​ตังหลาย​จะ​เยียะ​กับ​ป้อจาย​หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","จ๋ำ​ได้​ก่อ​ต๋อน​ตี้​มี​ป้อจาย​คน​นึ่ง​จื้อ​ธุดาส​อ้าง​ว่า​ตั๋ว​เขา​เป๋น​ผู้​ยิ่งใหญ่ มี​คน​ติดต๋าม​หลาม​ตวย​เขา​ประมาณ​สี่​ร้อย​คน เมื่อ​เขา​ถูก​ฆ่า​ต๋าย หมู่​คน​ตี้​ติดต๋าม​เขา​ก็​แตก​ขะแล​ขะแจ​ไป​เหีย​หมด บ่﻿หัน​มี​อะหยัง​เกิด​ขึ้น​สัก​อย่าง ");
INSERT INTO nod_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","หลังจาก​ธุดาส​ต๋าย​ก็​มี​ยูดาส​จาว​กาลิลี​แหม​คน​นึ่ง เมื่อ​ต๋อน​ตี้​จด​ทะเบียน​สำมะโน​ครัว เขา​ได้​จั๊ก​จู๋ง​หมู่​คน​หื้อ​ติดต๋าม​เขา​ไป แต่​เขา​ก็​ถูก​ฆ่า​ต๋าย แล้ว​หมู่​ศิษย์​ของ​เขา​ก็​แตก​ขะแล​ขะแจ​ไป​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","บ่าเดี่ยวนี้​ก็​เหมือน​กั๋น ข้าพเจ้า​จึง​ขอ​แนะนำ​หมู่​ต้าน​หื้อ​อยู่​ห่าง﻿ๆ จาก​คน​หมู่​นี้ ห้าม​ยุ่ง​กับ​หมู่​เขา​ปะล้ำ​ปะเหลือ ย้อน​ว่า​ถ้า​แผนก๋าน​กาว่า​ก๋าน​หมู่​นี้​ของ​หมู่​เขา​มา​จาก​มนุษย์ ก็​จะ​หุยหาย​ตุยตาย​ไป​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","แต่​ถ้า​แผนก๋าน​นี้​มา​จาก​พระเจ้า​ลอ ต้าน​บ่﻿สามารถ​เกิ็ดเกิ้ง​ได้​เน่อ แล้ว​ต้าน​ก็​จะ​ตั้ง​ตั๋ว​ต่อสู้​กับ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","หมู่​เขา​ก็​ยอม​ฟัง​กำ​แนะนำ​ของ​กามาลิเอล จึง​ฮ้อง​หมู่​อัครทูต​เข้า​มา แล้ว​ก็​ใจ๊​คน​เฆี่ยน กับ​สั่ง​ห้าม​บ่﻿หื้อ​อู้​ใน​นาม​พระเยซู​แหม แล้ว​ก็​ปล่อย​ตั๋ว​ไป ");
INSERT INTO nod_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","หมู่​อัครทูต​ก็​ออก​จาก​สภา​มา​ด้วย​ความ​ยินดี​ขนาด ย้อน​ว่า​พระเจ้า​หัน​ว่า​หมู่​เขา​มี​ก้า​ปอ​ตี้​จะ​ฮับ​ก๋าน​ดูถูก​ดู​แควน เปื้อ​นาม​ของ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","แล้ว​กู้​วัน​ใน​ข่วง​พระวิหาร​ตึง​ใน​บ้านเฮือน​ของ​คน​ตังหลาย หมู่​อัครทูต​ก็​สั่ง​สอน​ตึง​บอก​ข่าวดี​บ่﻿เกย​ขาด​ว่า​พระเยซู​คือ​พระคริสต์ ");
INSERT INTO nod_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ใน​หละหว่าง​เวลา​นั้น มี​คน​ฮับเจื้อ​พระเยซู​นัก​ขึ้น​ติก﻿ๆ หมู่​จาว​ยิว​ตี้​อู้​ภาษา​กรีก​ปา​กั๋น​จ่ม​ว่า​หื้อ​หมู่​จาว​ยิว​ตี้​อู้​ภาษา​ฮีบรู เรื่อง​หมู่​แม่​หม้าย​ตี้​อู้​ภาษา​กรีก บ่﻿ได้​ฮับ​อาหาร​ตี้​แจก​ประจ๋ำ​วัน ");
INSERT INTO nod_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","อัครทูต​ตึง​สิบ​สอง​คน​จึง​ฮ้อง​หมู่​ผู้เจื้อ​ตึงหมด​มา​จุมนุม​กั๋น แล้ว​อู้​ว่า “บ่﻿ถูกต้อง​เน่อ​ตี้​หมู่​เฮา​จะ​เมา​ไป​แจก​อาหาร​กั๋น​อยู่ จ๋น​ละเลย​ก๋าน​สั่ง​สอน​ถ้อยกำ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","เอา​จาอี้​ก็​แล้ว​กั๋น​ปี้น้อง​ตังหลาย​เหย หื้อ​เลือก​ป้อจาย​สัก​เจ็ด​คน​ใน​หมู่​ต้าน​ตี้​มี​จื้อเสียง​ดี เป๋น​คน​ตี้​ได้​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ เป๋น​คน​มี​ผญา​ปั๋ญญา​ดี แล้ว​เฮา​จะ​ตั้ง​หื้อ​หมู่​เขา​ผ่อกอย​ฮับผิดชอบ​ก๋าน​แจก​อาหาร​นี้ ");
INSERT INTO nod_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ส่วน​หมู่​เฮา​จะ​ตั้งอก​ตั้งใจ๋​ใจ๊​เวลา​อธิษฐาน​ตึง​สั่ง​สอน​ถ้อยกำ​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","คน​ตังหลาย​ก็​ปออก​ปอใจ๋​กับ​ข้อ​เสนอ​นี้ จึง​เลือก​สเทเฟน (​ป้อจาย​ตี้​มี​ความ​เจื้อ​นัก​ขนาด​กับ​ได้​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์​) ฟีลิป โปรโครัส นิคาโนร์ ทิโมน ปารเมนัส กับ​นิโคเลาส์ (​ตี้​เป๋น​จาว​เมือง​อันทิโอก เซิ่ง​ก่อน​หน้า​นี้​เข้า​ฮีต​ศาสนา​ยิว​) ");
INSERT INTO nod_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","หมู่​เขา​จึง​ปา​ตึง​เจ็ด​คน​นี้​มา​ยืน​ต่อ​หน้า​หมู่​อัครทูต แล้ว​หมู่​อัครทูต​ก็​อธิษฐาน​วาง​มือ​บน​หัว​คน​ตึง​เจ็ด​นั้น เปื้อ​มอบ​หื้อ​เยียะ​งาน​นี้ ");
INSERT INTO nod_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ก๋าน​บอก​ถ้อยกำ​ของ​พระเจ้า​ก็​แผ่​ขยาย​กว้าง​ออก​ไป​ติก﻿ๆ มี​คน​มา​ฮับเจื้อ​พระเยซู​ใน​กรุง​เยรูซาเล็ม​นัก​ขึ้น​เวย​ขนาด กับ​มี​หมู่​ปุโรหิต​หลาย​คน​ฮับเจื้อ​ตวย ");
INSERT INTO nod_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","คน​จื้อ​สเทเฟน​ฮับ​ปอน​ตึง​ฤทธิ์​อำนาจ​ของ​พระเจ้า​นัก เยียะ​สิ่ง​ปาฏิหาริย์​ตึง​หมายสำคัญ​หลาย​อย่าง​ต่อ​หน้า​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","แต่​มี​บาง​คน​มา​จาก​ธรรมศาลา​ของ​จาว​ยิว จื้อ​ธรรมศาลา​ขี้ข้า​มี​อิสระ มา​เถียง​กับ​สเทเฟน หมู่​เขา​เป๋น​จาว​ยิว​มา​จาก​เมือง​ไซรีน เมือง​อเล็กซานเดรีย แคว้น​ซิลีเซีย และ​แคว้น​เอเชีย ");
INSERT INTO nod_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","แต่​หมู่​เขา​ก็​เถียง​สู้​บ่﻿ได้ ย้อน​ว่า​พระวิญญาณ​บริสุทธิ์​หื้อ​ปั๋ญญา​ใน​ก๋าน​อู้​แก่​สเทเฟน ");
INSERT INTO nod_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ย้อนจาอั้น​เขา​หมู่​นั้น​จึง​หื้อ​สินบน​เอา​คน​มา​อู้​ว่า “เฮา​ได้ยิน​ป้อจาย​คน​นี้​อู้​กำ​หมิ่น​ประมาท​ต่อ​โมเสส​กับ​ต่อ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","เขา​หมู่​นั้น​เยียะ​จาอี้ ก็​สุ่ย​หื้อ​คน​ตังหลาย​ตึง​หมู่​คน​เฒ่า​คน​แก่​ของ​จาว​ยิว​กับ​ธรรมาจ๋ารย์​ยับ​สเทเฟน แล้ว​เอา​ไป​ตี้​สภา ");
INSERT INTO nod_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","หมู่​เขา​นำ​พยาน​เท็จ​มา​อู้​ว่า “ป้อจาย​คน​นี้​อู้​ดู​หมิ่น​พระวิหาร​แห่ง​นี้ และ​ต่อต้าน​บท​บัญญัติ​ของ​โมเสส​ตลอด​เวลา ");
INSERT INTO nod_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ย้อน​หมู่​เฮา​ได้ยิน​เขา​อู้​ว่า เยซู​จาว​นาซาเร็ธ​จะ​เต​พระวิหาร​แห่ง​นี้​ขว้าง กับ​จะ​เปี่ยน​ฮีต​เก่า​ฮอย​เดิม​ตี้​โมเสส​หื้อ​ไว้​กับ​เฮา” ");
INSERT INTO nod_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","คน​ตังหลาย​ตี้​นั่ง​อยู่​ใน​สภา​นั้น​ปา​กั๋น​ปักต๋าผ่อ​ไป​ตี้​สเทเฟน ก็​หัน​ว่า​หน้า​ของ​เขา​เหมือน​หน้า​ของ​ทูตสวรรค์ ");
INSERT INTO nod_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","มหา​ปุโรหิต​ถาม​สเทเฟน​ว่า “เรื่อง​ตี้​เขา​ฟ้อง​มา​นี้ แต๊​กาว่า​บ่﻿แต๊” ");
INSERT INTO nod_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","สเทเฟน​ก็​ตอบ​ว่า “ต้าน​คน​เฒ่า​คน​แก่​กับ​ปี้น้อง​ตังหลาย​ฟัง​หื้อ​ดี​ก่อน พระเจ้า​ผู้​ยิ่งใหญ่​ป๋ากฏ​ตั๋ว​ต่อ​อับราฮัม​ป้ออุ๊ย​แม่หม่อน​เก๊า​เหง้า​ของ​หมู่​เฮา ต๋อน​นั้น​ต้าน​ยัง​อยู่​ตี้​ดินแดน​เมโสโปเตเมีย​ก่อน​จะ​ย้าย​ไป​อยู่​ตี้​เมือง​ฮาราน ");
INSERT INTO nod_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","พระเจ้า​อู้​กับ​อับราฮัม​ว่า ‘หื้อ​เจ้า​ออก​จาก​ประเทศ​ของ​เจ้า ออก​จาก​ญาติ​ปี้น้อง​ของ​เจ้า ไป​ดินแดน​ตี้​เฮา​จะ​บอก​หื้อ​เจ้า​ฮู้’ ");
INSERT INTO nod_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","แล้ว​อับราฮัม​ก็​ออก​จาก​ดินแดน​ของ​จาว​เคลเดีย​มา​อาศัย​อยู่​ตี้​เมือง​ฮาราน หลังจาก​ป้อ​ของ​ต้าน​ต๋าย​แล้ว พระเจ้า​ก็​ส่ง​ต้าน​ออก​จาก​ตี้​หั้น​มา​ดินแดน​ตี้​หมู่​ต้าน​อาศัย​อยู่​บ่าเดี่ยวนี้ ");
INSERT INTO nod_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“ใน​ต๋อน​นั้น​พระเจ้า​ยัง​บ่﻿หื้อ​อับราฮัม​เป๋น​เจ้าของ​ตี้ดิน​ตั๊ด​นี้​แม้​แต่​วา​เดียว แต่​พระเจ้า​สัญญา​ตี้​จะ​ยก​แผ่นดิน​ตึงหมด​นี้​หื้อ​ต้าน​ตึง​ลูกหลาน​ต๋านเต๊า​ของ​ต้าน แต่​ต๋อน​นั้น​อับราฮัม​ยัง​บ่﻿มี​ลูก​สัก​คน​เตื้อ ");
INSERT INTO nod_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","พระเจ้า​อู้​กับ​ต้าน​จาอี้​ว่า ‘ลูกหลาน​ของ​เจ้า​จะ​เป๋น​คน​แปลกหน้า​ใน​แผ่นดิน​อื่น จะ​เป๋น​ขี้ข้า คน​ตี้​หั้น​จะ​เยียะ​บ่﻿ดี​ต่อ​หมู่​เขา​เป๋น​เวลา​สี่​ร้อย​ปี๋ ");
INSERT INTO nod_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","แต่​เฮา​จะ​ลงโต้ษ​คน​จ้าด​นั้น ตี้​เยียะ​หื้อ​ลูกหลาน​ของ​เจ้า​ต้อง​ตก​เป๋น​ขี้ข้า’ พระเจ้า​ยัง​อู้​แหม​ว่า ‘หลังจาก​นั้น​หมู่​เขา​ก็​จะ​ออก​จาก​ดินแดน​นั้น แล้ว​มา​นมัสก๋าน​เฮา​ตี้​สถาน​ตี้​นี่’ ");
INSERT INTO nod_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","พระเจ้า​ก็​มอบ​หื้อ​อับราฮัม​เยียะ​พิธี​สุหนัต เปื้อ​เป๋น​เครื่องหมาย​พันธสัญญา​ไว้​หละหว่าง​พระองค์​กับ​ต้าน เมื่อ​อับราฮัม​มี​ลูกบ่าว​จื้อ​อิสอัค​อายุ​แปด​วัน อับราฮัม​ก็​เยียะ​พิธี​สุหนัต​หื้อ​เขา ต่อ​มา​อิสอัค​มี​ลูกบ่าว​จื้อ​ยาโคบ แล้ว​ยาโคบ​ก็​มี​ลูกบ่าว​สิบ​สอง​คน​ตี้​เป๋น​ต้น​ผะกุ๋น​ต่าง﻿ๆ ของ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“หมู่​ลูกบ่าว​ของ​ยาโคบ​ปา​กั๋น​ขอย​โยเซฟ​น้อง​บ่าว​ของ​ตั๋ว จึง​ขาย​โยเซฟ​หื้อ​ไป​เป๋น​ขี้ข้า​ใน​ประเทศ​อียิปต์ แต่​พระเจ้า​ก็​อยู่​ตวย​โยเซฟ ");
INSERT INTO nod_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","พระองค์​จ้วย​หื้อ​โยเซฟ​ป๊น​จาก​ความ​ตุ๊ก​กู้​อย่าง พระเจ้า​เยียะ​หื้อ​โยเซฟ​มี​ปั๋ญญา กับ​หื้อ​ฟาโรห์ (​แป๋​ว่า​กษัตริย์​ของ​อียิปต์​) เปิงใจ๋​โยเซฟ​ขนาด เถิง​กับ​แต่งตั้ง​หื้อ​เป๋น​ผู้​ปกครอง​ประเทศ​อียิปต์​ตึง​ใน​วัง​ของ​ฟาโรห์​ตวย ");
INSERT INTO nod_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“ต่อ​มา​ตี้​ประเทศ​อียิปต์​ตึง​ดินแดน​คานาอัน​เกิด​กั๋นดาร​อดอยาก เยียะ​หื้อ​เดือดฮ้อน​กั๋น​อย่าง​หนัก ป้ออุ๊ย​แม่หม่อน​เก๊า​เหง้า​ของ​หมู่​เฮา​ก็​บ่﻿มี​อาหาร​กิ๋น ");
INSERT INTO nod_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","เมื่อ​ยาโคบ​ได้ยิน​ว่า​ใน​ประเทศ​อียิปต์​มี​ของกิ๋น ก็​ส่ง​ป้ออุ๊ย​แม่หม่อน​เก๊า​เหง้า​ของ​หมู่​เฮา​ไป​ตี้​หั้น​เตื้อ​ตี้​นึ่ง ");
INSERT INTO nod_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ต๋อน​ไป​เตื้อ​ตี้​สอง​นั้น โยเซฟ​ก็​เปิดเผย​ตั๋ว​หื้อ​ปี้น้อง​ของ​ต้าน​ฮู้จัก ฟาโรห์​ก็​ฮู้จัก​ครอบครัว​ญาติ​ปี้น้อง​ของ​โยเซฟ​ตวย ");
INSERT INTO nod_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","โยเซฟ​ส่ง​คน​ไป​ฮับ​ยาโคบ​ป้อ​ของ​ต้าน​ตึง​ญาติ​ปี้น้อง​ของ​ต้าน รวม​ตึงหมด​ตึงเสี้ยง​เจ็ด​สิบ​ห้า​คน​หื้อ​มา​อยู่​ตวย​กั๋น​ใน​ประเทศ​อียิปต์ ");
INSERT INTO nod_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ยาโคบ​ก็​ปา​กั๋น​ย้าย​ไป​อยู่​ตี้​ประเทศ​อียิปต์ แล้ว​ยาโคบ​กับ​ป้ออุ๊ย​แม่หม่อน​ตี้​เป๋น​เก๊า​เหง้า​ของ​หมู่​เฮา​ก็​ต๋าย​ตี้​ประเทศ​อียิปต์​นั้น ");
INSERT INTO nod_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","มี​คน​เอา​ศพ​ของ​ต้าน​หมู่​นั้น​มา​ตี้​เมือง​เชเคม แล้ว​ฝัง​ไว้​ใน​อุโมงค์​ฝัง​ศพ​ตี้​อับราฮัม​ใจ๊​สตางค์​จ๋ำนวน​นึ่ง ซื้อ​มา​จาก​ลูกบ่าว​ของ​ฮาโมร์​ใน​เมือง​เชเคม​นั้น ");
INSERT INTO nod_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“เมื่อ​ใก้​เถิง​เวลา​ตี้​พระเจ้า​จะ​ฮักษา​สัญญา​ตี้​หื้อ​ไว้​กับ​อับราฮัม จ๋ำนวน​จาว​อิสราเอล​ใน​ประเทศ​อียิปต์​ได้​เพิ่ม​ขึ้น​นัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","เวลา​นั้น​ประเทศ​อียิปต์​มี​กษัตริย์​ใหม่​ขึ้น​ปกครอง​ประเทศ​องค์​นึ่ง​ตี้​บ่﻿เกย​ฮู้​เรื่อง​เกี่ยวกับ​โยเซฟ​เลย ");
INSERT INTO nod_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","กษัตริย์​องค์​นี้​ใจ๊​อุบาย​หลอกลวง​ตึง​เยียะ​บ่﻿ดี​ต่อ​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา โดย​เข​หื้อ​เอา​ลูกหน้อย​ของ​หมู่​เขา​ไป​ขว้าง​ตัง​นอก​หื้อ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","โมเสส​ก็​เกิด​มา​ใน​หละหว่าง​เวลา​นั้น ต๋อน​เป๋น​หละอ่อน ต้าน​มี​ฮูปฮ่าง​งาม​น่า​ฮัก​ขนาด ป้อ​แม่​ก็​เลี้ยงดู​ต้าน​ไว้​ใน​บ้าน​จ๋น​อายุ​ได้​สาม​เดือน ");
INSERT INTO nod_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","แล้ว​ก็​ต้อง​เอา​ไป​ขว้าง​ไว้​นอก​บ้าน ลูกสาว​ของ​ฟาโรห์​ก็​ปะ​ใส่ แล้ว​เอา​ต้าน​ไป​เลี้ยง​ไว้​เป๋น​ลูกเก็บ ");
INSERT INTO nod_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","โมเสส​จึง​ได้ฮับ​ก๋าน​ศึกษา​วิชา​ความ​ฮู้​ตึงหมด​ของ​จาว​อียิปต์ กับ​ต้าน​ก็​เก่ง​ใน​เรื่อง​กำ​อู้​กำ​จ๋า​ตึง​งาน​ต่าง﻿ๆ ตวย ");
INSERT INTO nod_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“เมื่อ​โมเสส​อายุ​ได้​สี่​สิบ​ปี๋ ต้าน​กึ๊ดใจ๋​ใค่​ไป​แอ่ว​หา​ปี้น้อง​จาว​อิสราเอล​ของ​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","เมื่อ​ต้าน​ซัดต๋า​หัน​จาว​อิสราเอล​คน​นึ่ง​ถูก​จาว​อียิปต์​คน​นึ่ง​ค่ำ ต้าน​ก็​เข้า​ไป​จ้วย แล้ว​ฆ่า​ป้อจาย​จาว​อียิปต์​คน​นั้น​ต๋าย เป๋น​ก๋าน​แก้แค้น​หื้อ ");
INSERT INTO nod_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","โมเสส​กึ๊ด​ใน​ใจ๋​ว่า​ปี้น้อง​จาว​อิสราเอล​คง​ฮู้​แล้ว​ว่า พระเจ้า​จะ​ใจ๊​ต้าน​นี่​ละ​มา​จ้วย​ปล่อย​หื้อ​หมู่​เขา​มี​อิสระ แต่​ว่า​หมู่​เขา​บ่﻿เข้าใจ๋​ไป​จาอั้น ");
INSERT INTO nod_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","วัน​ถัด​มา​โมเสส​เตียว​ก๋าย​มา​หัน​จาว​อิสราเอล​สอง​คน​ก่ำลัง​ผิดหัว​กั๋น หัน​ท่า​บ่﻿ดี ต้าน​ก็​ฮิ​เข้า​ไป​ห้าม แล้ว​อู้​หื้อ​เขา​คืนดี​กั๋น​เหีย​ว่า ‘เป๋น​ปี้น้อง​กั๋น​แต๊﻿ๆ เยียะ​หยัง​ตี๋​กั๋น​จ๋น​เลือด​ตก​ยาง​ออก’ ");
INSERT INTO nod_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","แต่​ป้อจาย​คน​ตี้​ค่ำ​นั้น​ยู้​โมเสส​ออก​ไป แล้ว​อู้​ว่า ‘ใผ​ตั้ง​หื้อ​เจ้า​เป๋น​ผู้​ปกครอง​กับ​ตัดสิน​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","เจ้า​จะ​มา​ฆ่า​เฮา​เหมือน​ตี้​ฆ่า​จาว​อียิปต์​เมื่อ​ตะวา​นี้​กา’ ");
INSERT INTO nod_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","เมื่อ​โมเสส​ได้ยิน​กำ​อู้​จาอั้น ก็​หนี​ไป​อาศัย​อยู่​ใน​แผ่นดิน​จาว​มีเดียน​ใน​ฐานะ​คน​แปลก​หน้า แล้ว​ต้าน​ก็​มี​ลูก​ป้อจาย​สอง​คน​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“หลังจาก​อยู่​ตี้​หั้น​ได้​สี่​สิบ​ปี๋ วัน​นึ่ง​ทูตสวรรค์​ผู้​ฮับใจ๊​ของ​พระเจ้า​ต๋น​นึ่ง มา​ป๋ากฏ​หื้อ​โมเสส​หัน​ใน​เปล๋วไฟ​ตี้​ก่ำลัง​ไหม้​คุ่ม​ไม้ ใน​ดินแดน​ทุรกั๋นดาร​ใก้​ดอย​ซีนาย ");
INSERT INTO nod_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","เมื่อ​โมเสส​ซัดต๋า​หันใส่​ก็​เกือบ​บ่﻿เจื้อ​สายต๋า​ตั๋ว​เก่า งืด​แต๊﻿ๆ เมื่อ​เตียว​เข้า​ไป​ใก้﻿ๆ เปื้อ​จะ​หัน​ถี่﻿ๆ ก็​ได้ยิน​เสียง​ของ​พระเจ้า​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘เฮา​เป๋น​พระเจ้า​ของ​ป้ออุ๊ย​แม่หม่อน​ของ​เจ้า เฮา​เป๋น​พระเจ้า​ตี้​อับราฮัม อิสอัค กับ​ยาโคบ​นับถือ’ โมเสส​กั๋ว​จ๋น​ตั๋ว​สั่น​ถาบ﻿ๆ บ่﻿ก้า​ผ่อ​ตี้​คุ่ม​ไม้​นั้น ");
INSERT INTO nod_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","แล้ว​พระเจ้า​ก็​อู้​กับ​โมเสส​แหม​ว่า ‘ถอด​เกิบ​ออก​เหีย​ก่อน ย้อน​ตี้​เจ้า​ยืน​อยู่​นี้​เป๋น​ตี้​ศักดิ์สิทธิ์’ ");
INSERT INTO nod_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","พระเจ้า​อู้​ต่อ​ไป​ว่า ‘เฮา​หัน​ความ​ตุ๊ก​คน​จ้าด​ของ​เฮา​ตี้​อยู่​ใน​ประเทศ​อียิปต์​แล้ว เฮา​ได้ยิน​เสียง​ฮ้อง​ป่นปี้ตีนัง​ของ​หมู่​เขา เฮา​จึง​ลง​มา​เปื้อ​จะ​ปล่อย​เขา​หื้อ​มี​อิสระ มา​เต๊อะ เฮา​จะ​ส่ง​เจ้า​ปิ๊ก​ไป​ประเทศ​อียิปต์’ ");
INSERT INTO nod_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“โมเสส​คน​นี้​ละ​ตี้​จาว​อิสราเอล​บ่﻿ยอมฮับ​โดย​อู้​ว่า ‘ใผ​ตั้ง​เจ้า​หื้อ​เป๋น​ผู้​ปกครอง​กับ​ตัดสิน​หมู่​เฮา’ พระเจ้า​ส่ง​ต้าน​มา​เป๋น​ผู้​ปกครอง​กับ​ผู้​จ้วย​หื้อ​ป๊น​ความ​ตุ๊ก โดย​อู้​ผ่าน​ทูตสวรรค์​ตี้​ป๋ากฏ​หื้อ​ต้าน​หัน​ใน​คุ่ม​ไม้​ตี้​ไฟ​ไหม้​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","โมเสส​ก็​คือ​คน​ตี้​ปา​จาว​อิสราเอล​ออก​มา​จาก​ประเทศ​อียิปต์ ต้าน​เยียะ​ปาฏิหาริย์​ตึง​หมายสำคัญ​ต่าง﻿ๆ ใน​ประเทศ​อียิปต์ ตี้​ทะเล​แดง กับ​เป๋น​เวลา​สี่​สิบ​ปี๋​ใน​ดินแดน​ทุรกั๋นดาร ");
INSERT INTO nod_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“โมเสส​คน​นี้​ละ​เป๋น​ผู้​ตี้​อู้​กับ​จาว​อิสราเอล​ตังหลาย​ว่า ‘พระเจ้า​จะ​นำ​คน​นึ่ง​ใน​หมู่​ปี้น้อง​ของ​ต้าน​ตังหลาย​หื้อ​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระองค์​เหมือน​อย่าง​ข้าพเจ้า’ ");
INSERT INTO nod_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","โมเสส​คน​นี้​อยู่​กับ​จุมนุม​จาว​อิสราเอล​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา​ใน​ดินแดน​ทุรกั๋นดาร ฮ่วม​กับ​ทูตสวรรค์​ตี้​อู้​กับ​โมเสส​ใน​ดอย​ซีนาย ตี้​หั้น​ต้าน​ฮับ​ถ้อยกำ​แห่ง​จีวิต​มา​หื้อ​เฮา​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","แต่​ป้ออุ๊ย​แม่หม่อน​ของ​เฮา​บ่﻿ยอม​เจื้อฟัง​ต้าน หมู่​เขา​บ่﻿ยอมฮับ​ต้าน ใค่​ปิ๊ก​ไป​ประเทศ​อียิปต์ ");
INSERT INTO nod_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ต๋อน​ตี้​โมเสส​ขึ้น​ไป​บน​ดอย​ซีนาย​ได้​หลาย​วัน​แล้ว หมู่​เขา​อู้​กับ​อาโรน​อ้าย​ของ​ต้าน​ว่า ‘ขอ​จ้วย​แป๋ง​พระ​หื้อ​หมู่​เฮา​กำ​เต๊อะ เปื้อ​จะ​หื้อ​มา​นำ​ตาง​หมู่​เฮา ย้อน​หมู่​เฮา​บ่﻿ฮู้​ว่า​เกิด​อะหยัง​ขึ้น​กับ​โมเสส​คน​ตี้​นำ​เฮา​ออก​มา​จาก​ประเทศ​อียิปต์’ ");
INSERT INTO nod_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ใน​เวลา​นั้น​หมู่​เขา​ก็​ปา​กั๋น​เอา​คำ​ตี้​ติด​ตั๋ว​มา​หล่อ​เป๋น​ฮูป​งัวก๊อก​ขึ้น​มา​ตั๋ว​นึ่ง แล้ว​ถวาย​เครื่อง​ปู่จา​ฮูป​เคารพ​นั้น หมู่​เขา​ก็​ปา​กั๋น​กิ๋นเลี้ยง​ฉลอง​สิ่ง​ตี้​หมู่​เขา​แป๋ง​ขึ้น​มา​กับ​มือ ");
INSERT INTO nod_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","แต่​พระเจ้า​บิ่น​หน้า​หนี​จาก​หมู่​เขา​เหีย พระองค์​ปล่อย​หื้อ​หมู่​เขา​นมัสก๋าน​หมู่​ดาว​ใน​ต๊องฟ้า อย่าง​ตี้​มี​เขียน​ไว้​แล้ว​ใน​หนังสือ​ของ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ว่า ‘จาว​อิสราเอล​ตังหลาย สัตว์​ตี้​หมู่​เจ้า​ฆ่า​เอา​มา​ปู่จา ใน​ดินแดน​ทุรกั๋นดาร​เป๋น​เวลา​เถิง​สี่​สิบ​ปี๋​นั้น เจ้า​เอา​มา​ปู่จา​เฮา​กา ");
INSERT INTO nod_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","บ่﻿ใจ้ แต่​หมู่​เจ้า​ขน​เอา​แต้น​ปู่จา​ของ​พระ​โมเลค กับ​ฮูป​พระ​เรฟาน​เทพเจ้า​แห่ง​ดาว คือ​ฮูป​พระ​ตี้​หมู่​เจ้า​แป๋ง​ขึ้น​เปื้อ​กราบ​ไหว้​นมัสก๋าน​บ่﻿ใจ้​กา จาอั้น​เฮา​จะ​กวาด​เจ้า​หื้อ​ไป​เป๋น​เชลย​ไก๋﻿ๆ หล่าย​เมือง​บาบิโลน​ปู๊น’ ");
INSERT INTO nod_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา​ก็​มี​เต็นท์​ศักดิ์สิทธิ์​แห่ง​สักขีพยาน​ตี้​ดินแดน​ทุรกั๋นดาร เป๋น​เต็นท์​ตี้​พระเจ้า​บอก​หื้อ​โมเสส​แป๋ง​ขึ้น​มา​ต๋าม​ฮูปแบบ​ตี้​พระองค์​เยียะ​หื้อ​ต้าน​หัน​นั้น ");
INSERT INTO nod_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","เมื่อ​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา​ได้​เต็นท์​นั้น​จาก​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เขา​มา​แล้ว ต้าน​หมู่​นั้น​ขน​เต็นท์​ตวย​โยชูวา​เข้า​ไป​ไว้​ใน​ดินแดน​ตี้​ยึด​มา​จาก​จ้าด​ต่าง﻿ๆ ตี้​พระเจ้า​ไล่​ออก​ไป​ต่อหน้า​ต่อต๋า​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา แล้ว​เต็นท์​นี้​ก็​อยู่​ตี้​หั้น​ตลอด​มา​จ๋น​เถิง​สมัย​ของ​กษัตริย์​ดาวิด ");
INSERT INTO nod_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“พระเจ้า​เปิงใจ๋​กษัตริย์​ดาวิด​ขนาด ต้าน​ขอ​แป๋ง​พระวิหาร​หื้อ​พระเจ้า​ของ​ยาโคบ​ ");
INSERT INTO nod_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","แต่​กษัตริย์​ซาโลมอน​ลูก​ของ​กษัตริย์​ดาวิด​เป๋น​ผู้​แป๋ง​พระวิหาร​สำหรับ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“แต่​พระเจ้า​ผู้​สูงสุด​ก็​บ่﻿อาศัย​อยู่​ใน​พระวิหาร​ตี้​แป๋ง​จาก​มือ​ของ​มนุษย์ อย่าง​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​อู้​ไว้​ว่า ");
INSERT INTO nod_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘สวรรค์​เป๋น​บัลลังก์​ของ​เฮา แผ่นดิน​โลก​ก็​คือ​แต้น​ตี้​ฮอง​ตี๋น​ของ​เฮา พระเจ้า​ผู้​สูงสุด​ถาม​ว่า แล้ว​เจ้า​จะ​แป๋ง​วิหาร​อะหยัง​สำหรับ​เฮา หมู่​เจ้า​จะ​หื้อ​เฮา​ย้าง​อยู่​ตี้​ไหน ");
INSERT INTO nod_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ซะป๊ะ​ซะเป้ด​หมู่​นี้​เฮา​สร้าง​ขึ้น​มา​ด้วย​มือ​ของ​เฮา​ตึงหมด​บ่﻿ใจ้​กา’ ” ");
INSERT INTO nod_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","สเทเฟน​อู้​ต่อ​ไป​ว่า “หมู่​ต้าน​เป๋น​คน​หัวแข็ง หลึ่ง ตึง​หูหนวก ต้าน​ตังหลาย​ขัดขวาง​พระวิญญาณ​บริสุทธิ์​อยู่​สะลวด หมู่​ต้าน​เยียะ​เหมือน​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","มี​คน​ตี้​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​คน​ใด​พ่อง​ตี้​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​ต้าน​บ่﻿ได้​ค่ำ​หือ ส่วน​หมู่​คน​ตี้​ตวายตั๊ก​ก๋าน​มา​ของ​ผู้​ถูกต้อง​ต๋าม​ธรรม​คือ​พระเยซู ป้ออุ๊ย​แม่หม่อน​ก็​ฆ่า​หมู่​คน​นั้น​ต๋าย​ตวย แล้ว​บ่าเดี่ยวนี้​หมู่​ต้าน​หักหลัง​พระเยซู แล้ว​ฆ่า​พระองค์​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","หมู่​ต้าน​นั้น​ละ​เป๋น​คน​ตี้​ฮับ​บท​บัญญัติ​ของ​พระเจ้า​ตี้​ทูตสวรรค์​ของ​พระเจ้า​เอา​มา​หื้อ แต่​หมู่​ต้าน​ก็​บ่﻿ยอม​เจื้อฟัง​บท​บัญญัติ​นั้น” ");
INSERT INTO nod_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","เมื่อ​ผู้นำ​จาว​ยิว​ได้ยิน​จาอั้น​ก็​ปา​กั๋น​โขด​ยั้น​เขี้ยว​หยั้น​กาง​เข้า​ใส่​สเทเฟน ");
INSERT INTO nod_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","แต่​สเทเฟน​ก็​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ ต้าน​แหงน​ผ่อ​ขึ้น​บน​ต๊องฟ้า​ก็​หัน​รัศมี​ของ​พระเจ้า กับ​หัน​พระเยซู​ยืน​อยู่​ตัง​เผิก​ขวา​ของ​พระเจ้า​หั้น ");
INSERT INTO nod_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","แล้ว​สเทเฟน​อู้​ว่า “ผ่อ​หั้น​ลอ ข้าพเจ้า​หัน​สวรรค์​เปิด​ออก กับ​หัน​บุตรมนุษย์​ยืน​อยู่​ตัง​เผิก​ขวา​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","หมู่​เขา​ก็​ปา​กั๋น​ฮ้อง​เสียง​ดัง​เอา​มือ​ตึด​หู แล้ว​ปา​กั๋น​งอม​เข้า​ใส่​สเทเฟน ");
INSERT INTO nod_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ปา​กั๋น​ลาก​สเทเฟน​ออก​ไป​นอก​เมือง เอา​บ่าหิน​ขว้าง​จ๋น​ต๋าย หมู่​ตี้​เป๋น​พยาน​ก็​ปา​กั๋น​แก้​เสื้อ​คุม​ของ​ตั๋ว ฝาก​ไว้​ฮิม​ตี๋น​ป้อจาย​หนุ่ม​คน​นึ่ง​จื้อ​เซาโล ");
INSERT INTO nod_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ต๋อน​ตี้​หมู่​เขา​ปา​กั๋น​เอา​บ่าหิน​หลุ้ม​ขว้าง​อยู่​นั้น สเทเฟน​ก่ำลัง​อธิษฐาน​ว่า “พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า ขอ​ฮับ​จิตวิญญาณ​ของ​ข้าพเจ้า​ตวย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","แล้ว​สเทเฟน​ก็​คุก​เข่า​ฮ้อง​ออก​ปาก​เสียง​ดัง​ว่า “พระองค์​เจ้าข้า ห้าม​เอา​โต้ษ​หมู่​เขา​เน่อ ตี้​หมู่​เขา​ปา​กั๋น​เยียะ​บาป​นี้” เมื่อ​อู้​จบ​แล้ว​สเทเฟน​ก็​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","เซาโล​ก็​อยู่​ตี้​หั้น เขา​หันดี​ตวย​ใน​ก๋าน​ฆ่า​สเทเฟน ใน​วัน​นั้น​มี​ก๋าน​ตั้งเก๊า​ค่ำเข​คริสตจักร​ครั้ง​ใหญ่​ใน​กรุง​เยรูซาเล็ม ผู้เจื้อ​ตังหลาย​เว้น​แต่​หมู่​อัครทูต​แตก​หนี​ขะแล​ขะแจ​ไป​ทั่ว​แคว้น​ยูเดีย​กับ​แคว้น​สะมาเรีย ");
INSERT INTO nod_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","หมู่​คน​ตี้​ยำเก๋ง​พระเจ้า​จัดก๋าน​ฝัง​ศพ​สเทเฟน แล้ว​ปา​กั๋น​ไห้​ฮ่ำหา​สเทเฟน​ด้วย​ความ​โศกเศร้า​เสียใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ส่วน​เซาโล​ก็​ตั้งเก๊า​ทำลาย​คริสตจักร เขา​เข้า​ไป​ใน​เฮือน​จาก​หลัง​นึ่ง​ไป​แหม​หลัง​นึ่ง เปื้อ​ลากคอ​ตึง​แม่ญิง​ป้อจาย​ไป​ขัง​คอก ");
INSERT INTO nod_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","สำหรับ​ผู้เจื้อ​ตี้​แตก​ขะแล​ขะแจ​ไป ก็​ปา​กั๋น​บอก​ข่าวดี​เรื่อง​ถ้อยกำ​ของ​พระเยซู​กู้​ตี้​กู้​ตาง​ตี้​หมู่​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ส่วน​ฟีลิป​ไป​ตี้​เมือง​นึ่ง​ใน​แคว้น​สะมาเรีย แล้ว​บอก​เรื่อง​ของ​พระคริสต์​หื้อ​คน​ตี้​หั้น​ฟัง ");
INSERT INTO nod_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","เมื่อ​คน​ตังหลาย​ได้ยิน​ฟีลิป​บอก ก็​ตั้งใจ๋​ฟัง​ใน​สิ่ง​ตี้​ต้าน​อู้ กับ​หัน​ก๋าน​อัศจ๋รรย์​ตี้​ต้าน​เยียะ ");
INSERT INTO nod_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","เจ้น เมื่อ​ฟีลิป​ไล่​ผี​ฮ้าย ผี​ฮ้าย​ตี้​เข้า​คน​อยู่​ก็​ฮ้อง​เสียง​ดัง​ออก​ไป​จาก​คน​นั้น​เหีย หมู่​คน​ตี้​เป๋น​โรค​ต๋ายผาก​กับ​คน​ง่อย​ก็​ฮับ​ก๋าน​ฮักษา​จ๋น​หาย ");
INSERT INTO nod_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","คน​ใน​เมือง​นั้น​ก็​มี​ความ​จื้นจมยินดี​อย่าง​นัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","มี​ป้อจาย​คน​นึ่ง​จื้อ​ซีโมน เขา​อยู่​เมือง​นั้น เป๋น​คน​เก่ง​ตาง​เวทมนตร์​กาถาอาคม เขา​เยียะ​หื้อ​จาว​สะมาเรีย​งืด​ใน​ตั๋ว​เขา​มา​ก่อน เขา​อ้าง​ตั๋ว​ว่า​เป๋น​ผู้​ยิ่งใหญ่ ");
INSERT INTO nod_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ส่วน​คน​ตังหลาย​บ่﻿ว่า​จั๊น​สูง​กาว่า​จั๊น​ต่ำ​ใน​สังคม ก็​หื้อ​ความ​สนใจ๋​ใน​ตั๋ว​เขา​นัก​ขนาด อู้​กั๋น​ว่า “ป้อจาย​คน​นี้​เป๋น​คน​ตี้​มี​อำนาจ​ต๋าม​แบบ​พระเจ้า​ตี้​ฮ้อง​กั๋น​ว่า ผู้​มี​อำนาจ​ยิ่งใหญ่” ");
INSERT INTO nod_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","คน​ตังหลาย​สนใจ๋​ฟัง​ซีโมน ย้อน​เขา​เยียะ​หื้อ​คน​งืด​ใน​เวทมนตร์​กาถา​ของ​เขา​มา​เมิน​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","แต่​เมื่อ​ฟีลิป​บอก​ข่าวดี​เรื่อง​แผ่นดิน​ของ​พระเจ้า​กับ​เรื่อง​ของ​พระเยซู​คริสต์ หมู่​จาว​เมือง​นั้น​ก็​ฮับ​เจื้อ แล้ว​ฮับ​บัพติศมา​ตึง​ป้อจาย​แม่ญิง ");
INSERT INTO nod_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ซีโมน​ก็​เจื้อ​ตวย หลังจาก​ตี้​เขา​ฮับ​บัพติศมา​แล้ว เขา​ก็​ติดต๋าม​ฟีลิป​ไป​ผับใคว่ เขา​หัน​หมายสำคัญ​กับ​ก๋าน​อัศจ๋รรย์​ตี้​ฟีลิป​เยียะ ก็​งืด​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","เมื่อ​หมู่​อัครทูต​ตี้​กรุง​เยรูซาเล็ม​ได้ยิน​ข่าว​ว่า​จาว​สะมาเรีย​ยอมฮับ​ถ้อยกำ​ของ​พระเจ้า​แล้ว ต้าน​หมู่​นั้น​ก็​ส่ง​เปโตร​กับ​ยอห์น​มา​หา​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","เมื่อ​เปโตร​กับ​ยอห์น​มา​แผว​แคว้น​สะมาเรีย​แล้ว ก็​อธิษฐาน​เผื่อ​ผู้เจื้อ​ตังหลาย เปื้อ​หื้อ​หมู่​เขา​ฮับ​พระวิญญาณ​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ย้อน​ว่า​พระวิญญาณ​บริสุทธิ์​ยัง​บ่﻿มา​อยู่​กับ​เขา​ตังหลาย​เตื้อ แต่​หมู่​เขา​ฮับ​บัพติศมา​ใน​นาม​ของ​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","แล้ว​เปโตร​กับ​ยอห์น​อธิษฐาน​วาง​มือ​บน​หัว​หมู่​เขา คน​ตึงหมด​ก็​ได้​ฮับ​พระวิญญาณ​บริสุทธิ์ ");
INSERT INTO nod_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","เมื่อ​ซีโมน​หัน​อัครทูต​วาง​มือ​ลง​บน​หัว​คน​หมู่​นั้น​แล้ว เขา​หมู่​นั้น​ก็​ได้​ฮับ​พระวิญญาณ​บริสุทธิ์ ซีโมน​ก็​เอา​สตางค์​มา​เสนอ​ขอ​ซื้อ​จาก​อัครทูต ");
INSERT INTO nod_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","อู้​ว่า “ขอ​อำนาจ​จาอี้​หื้อ​ข้าพเจ้า​พ่อง​เต๊อะ เปื้อ​ว่า​กู้​คน​ตี้​ข้าพเจ้า​วาง​มือ​จะ​ได้​ฮับ​พระวิญญาณ​บริสุทธิ์​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","เปโตร​เอ็กปั๊ด​ซีโมน​ว่า “ขอ​หื้อ​สู​กับ​สตางค์​ของ​สู​ฉิบหาย​วายวอด​ไป​ตวย​กั๋น​เหีย ย้อน​สู​กึ๊ด​ว่า​สตางค์​สามารถ​ซื้อ​สิ่ง​ตี้​พระเจ้า​จะ​หื้อ​ได้ ");
INSERT INTO nod_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","สู​จะ​บ่﻿มี​ส่วน​ฮ่วม​ใน​เรื่อง​นี้​อย่าง​เด็ดขาด ย้อน​จิตใจ๋​ของ​สู​บ่﻿ซื่อ​บ่﻿ใส​ต่อ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ย้อนจาอั้น​จง​กลับใจ๋​จาก​บาป จาก​ความ​บ่﻿ดี​จาอี้ แล้ว​อธิษฐาน​ต่อ​องค์​พระ​ผู้​เป๋น​เจ้า หวัง​ว่า​พระองค์​อาจ​จะ​ยกโต้ษ​กำกึ๊ด​ตี้​อยู่​ใน​ใจ๋​ของ​สู​ก็​ได้ ");
INSERT INTO nod_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ย้อน​เฮา​หัน​ว่า​สู​ขอย​จ๋น​เจ็บใจ๋ เยียะ​หื้อ​ตก​เป๋น​ขี้ข้า​ของ​ความ​บาป” ");
INSERT INTO nod_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","แล้ว​ซีโมน​ตอบ​ว่า “ขอ​หมู่​ต้าน​จ้วย​อธิษฐาน​ต่อ​องค์​พระ​ผู้​เป๋น​เจ้า​เผื่อ​กำ​เต๊อะ เปื้อ​สิ่ง​ตี้​อู้​มา​นั้น​จะ​บ่﻿เกิด​ขึ้น​กับ​ข้าพเจ้า​สัก​อย่าง” ");
INSERT INTO nod_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","หลังจาก​เปโตร​กับ​ยอห์น​เป๋น​พยาน​กับ​อู้​เถิง​ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​แล้ว ก็​ปิ๊ก​ไป​กรุง​เยรูซาเล็ม ใน​หละหว่าง​ก๋าง​ตาง​นั้น​ก็​ได้​อู้​เถิง​ข่าวดี​เรื่อง​พระเยซู​ต๋าม​หมู่​บ้าน​ของ​จาว​สะมาเรีย​แหม​หลาย​ตี้ ");
INSERT INTO nod_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ทูตสวรรค์​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​องค์​นึ่ง​สั่ง​ฟีลิป​ว่า “เกียม​ตั๋ว​เตียวตาง​ลง​ไป​ตัง​ใต้​ต๋าม​เส้นตาง​จาก​กรุง​เยรูซาเล็ม​เถิง​เมือง​กาซา เป๋น​เส้นตาง​กั๋นดาร” ");
INSERT INTO nod_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ฟีลิป​จึง​เกียม​ตั๋ว​แล้ว​ออก​เตียวตาง หละหว่าง​เตียวตาง​ก็​หัน​ขันที​คน​นึ่ง​เป๋น​จาว​เอธิโอเปีย เป๋น​เจ้าหน้าตี้​ของ​พระราชินี​ประเทศ​เอธิโอเปีย มี​หน้าตี้​ผ่อกอย​ทรัพย์​สมบัติ​ตึงหมด​ของ​พระนาง ขันที​คน​นี้​ไป​นมัสก๋าน​พระเจ้า​ตี้​กรุง​เยรูซาเล็ม​มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","หละหว่าง​นั่ง​รถม้า​ปิ๊ก​เมือ​บ้าน​นั้น เขา​ก่ำลัง​อ่าน​หนังสือ​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","แล้ว​พระวิญญาณ​บริสุทธิ์​บอก​ฟีลิป​ว่า “เข้า​ไป​ใก้﻿ๆ รถ​กัน​นั้น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ฟีลิป​ก็​ล่น​เข้า​ไป​ใก้​รถ​กัน​นั้น ได้ยิน​เสียง​คน​ก่ำลัง​อ่าน​หนังสือ​ตี้​อิสยาห์​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​เขียน​ไว้ ฟีลิป​จึง​ถาม​ว่า “ต้าน​เข้าใจ๋​ตี้​ก่ำลัง​อ่าน​หั้น​ก่อ” ");
INSERT INTO nod_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ขันที​ตอบ​ว่า “ถ้า​บ่﻿มี​ใผ​อธิบาย​หื้อ​ฟัง ก็​จะ​เข้าใจ๋​ได้​จาใด” แล้ว​เขา​ก็​เจิญ​ฟีลิป​ขึ้น​ไป​นั่ง​บน​รถ​ตวย​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ข้อความ​ใน​พระคัมภีร์​ตี้​ขันที​ก่ำลัง​อ่าน​อยู่​นั้น​มี​ว่า​จาอี้ “ต้าน​ถูก​ปา​ไป​เหมือน​กับ​แกะ​ตี้​ถูก​ปา​เอา​ไป​ฆ่า ต้าน​เหมือน​กับ​ลูก​แกะ​ตี้​ดัก​ปาก​ต่อ​หน้า​คน​ตัด​ขน ต้าน​บ่﻿อ้า​ปาก​อู้​อะหยัง​เลย​เหมือน​กับ​ลูก​แกะ​นั้น ");
INSERT INTO nod_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ต้าน​ถูก​อับ​อาย​ขาย​หน้า​แต่​ต้าน​บ่﻿ได้​ฮับ​ความ​ยุติธรรม บ่﻿มี​ใผ​สัก​คน​ตี้​จะ​เล่า​เรื่อง​เกี่ยวกับ​เจื๊อสาย​ของ​ต้าน​ได้ ย้อน​จีวิต​ของ​ต้าน​จาก​โลก​นี้​ไป​แล้ว” ");
INSERT INTO nod_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ขันที​ก็​ถาม​ฟีลิป​ว่า “บอก​เฮา​ฮู้​น่อย​ว่า​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ก่ำลัง​อู้​เถิง​ตั๋ว​เก่า​กาว่า​อู้​เถิง​คน​อื่น” ");
INSERT INTO nod_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","แล้ว​ฟีลิป​ก็​ตั้งเก๊า​เล่า​เรื่อง​ข่าวดี​ของ​พระเยซู อ้างอิง​พระคัมภีร์​ตั้งแต่​ข้อ​นี้​ไป​หื้อ​ขันที​ฟัง ");
INSERT INTO nod_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ใน​หละหว่าง​ตี้​นั่ง​รถ​ไป​ต๋าม​ตาง​นั้น ก็​ก๋าย​ตี้​มี​น้ำ​แห่ง​นึ่ง ขันที​จึง​อู้​ว่า “ผ่อ​น้ำ​หั้น​ลอ มี​อะหยัง​ขัดข้อง​ก่อ ถ้า​เฮา​จะ​ฮับ​บัพติศมา” ");
INSERT INTO nod_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","แล้ว​ฟีลิป​ก็​ตอบ​ว่า “ถ้า​ต้าน​เจื้อ​อย่าง​เต๋มใจ๋​ก็​ฮับ​บัพติศมา​ได้” ขันที​ตอบ​ว่า “เฮา​เจื้อ​ว่า​พระเยซู​คริสต์​เป๋น​บุตร​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","แล้ว​ขันที​ก็​สั่ง​หื้อ​หยุด​รถ จาก​นั้น​ขันที​กับ​ฟีลิป​ก็​เตียว​ลง​ไป​ใน​น้ำ แล้ว​ขันที​ก็​ฮับ​บัพติศมา​จาก​ฟีลิป ");
INSERT INTO nod_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","เมื่อ​ปา​กั๋น​ขึ้น​จาก​น้ำ​แล้ว พระวิญญาณ​บริสุทธิ์​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​ก็​ฮับ​ฟีลิป​ไป​เหีย ขันที​ก็​บ่﻿หัน​หน้า​หัน​ต๋า​ฟีลิป​แหม​เลย จาก​นั้น​ขันที​ก็​เตียวตาง​ต่อ​ไป​ด้วย​ความ​จื้นจม​ยินดี ");
INSERT INTO nod_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ส่วน​ฟีลิป​ก็​มา​ผด​ตี้​เมือง​อาโซทัส แล้ว​ก็​บอก​ข่าวดี​เรื่อง​พระเยซู​ต๋าม​กู้​เมือง​ตี้​ต้าน​เตียวตาง​ก๋าย​ไป​จ๋น​มา​แผว​เมือง​ซีซารียา ");
INSERT INTO nod_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ใน​หละหว่าง​นั้น เซาโล​ก็​ยัง​ขู่​ตี้​จะ​ฆ่า​หมู่​สาวก​ของ​องค์​พระ​ผู้​เป๋น​เจ้า เขา​ไป​หา​มหา​ปุโรหิต ");
INSERT INTO nod_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","แล้ว​ขอ​หนังสือ​ตี้​จะ​นำ​ไป​ธรรมศาลา​ของ​จาว​ยิว​ต่าง﻿ๆ ใน​เมือง​ดามัสกัส เปื้อ​ขอ​ความ​ฮ่วมมือ​ว่า ถ้า​ปะ​ใผ​คน​ใด​ตี้​ติดต๋าม​ลัทธิ​นั้น​ตี้​ฮ้อง​ว่า ตาง​ของ​พระเยซู บ่﻿ว่า​เป๋น​ป้อจาย​กาว่า​แม่ญิง ก็​จะ​หื้อ​เขา​ยับ​ปา​ปิ๊ก​มา​ตี้​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","เมื่อ​เซาโล​เตียวตาง​ใก้​จะ​แผว​เมือง​ดามัสกัส จู่﻿ๆ ก็​มี​แสง​แจ้ง​จาก​ต๊องฟ้า​ส่อง​ลง​มา​ตี้​ตั๋ว​เขา ");
INSERT INTO nod_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","เซาโล​โก้น​ลง​ดิน แล้ว​ได้ยิน​เสียง​เอิ้น​ลง​มา​ว่า “เซาโล เซาโล เจ้า​ค่ำ​เฮา​เยียะ​หยัง” ");
INSERT INTO nod_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","เซาโล​ถาม​ว่า “พระองค์​เจ้าข้า พระองค์​เป๋น​ใผ” มี​เสียง​ตอบ​ว่า “เฮา​คือ​เยซู ผู้​ตี้​เจ้า​ค่ำ​นั้น ");
INSERT INTO nod_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ลุก​ขึ้น​เต๊อะ แล้ว​เข้า​ไป​ใน​เมือง จะ​มี​คน​มา​บอก​หื้อ​เจ้า​ฮู้​ว่า​จะ​ต้อง​เยียะ​อะหยัง​ต่อ​ไป” ");
INSERT INTO nod_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","หมู่​คน​ตี้​เตียวตาง​มา​ตวย​ปา​กั๋น​ยืน​หนิม​อู้​อะหยัง​บ่﻿ออก ได้ยิน​เสียง​บ่﻿ดาย​แต่​บ่﻿หัน​ตั๋ว​คน​อู้ ");
INSERT INTO nod_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","แล้ว​เซาโล​ก็​ลุก​ขึ้น แต่​เมื่อ​มืน​ต๋า​ผ่อ​ก็​บ่﻿หัน​อะหยัง​สัก​อย่าง คน​หมู่​นั้น​จึง​จู๋ง​มือ​เซาโล​ปา​เข้า​ไป​ใน​เมือง​ดามัสกัส ");
INSERT INTO nod_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","เซาโล​ผ่อ​อะหยัง​บ่﻿หัน​ได้​สาม​วัน ใน​สาม​วัน​นั้น เขา​ตึง​บ่﻿กิ๋น​ข้าว​บ่﻿กิ๋น​น้ำ ");
INSERT INTO nod_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ใน​เมือง​ดามัสกัส​นั้น มี​คน​นึ่ง​จื้อ​อานาเนีย​เป๋น​ผู้เจื้อ องค์​พระ​ผู้​เป๋น​เจ้า​อู้​กับ​เขา​ตาง​นิมิต​ว่า “อานาเนีย​เหย” อานาเนีย​ก็​ตอบ​ว่า “พระองค์​เจ้าข้า ข้าพเจ้า​อยู่​ตี้​นี่” ");
INSERT INTO nod_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","พระองค์​บอก​ว่า “หื้อ​ไป​ตี้​หนตาง​จื้อ​ว่า ตางซื่อ เน่อ เข้า​ไป​ตี้​บ้าน​ของ​ยูดาส ถาม​หา​ป้อจาย​จื้อ​เซาโล​เป๋น​คน​จาว​เมือง​ทาร์ซัส บ่าเดี่ยวนี้​เขา​ก่ำลัง​อธิษฐาน​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ส่วน​เซาโล​ก็​หัน​นิมิต​เหมือน​กั๋น คือ​เขา​หัน​ป้อจาย​คน​นึ่ง​จื้อ​อานาเนีย​ก่ำลัง​เข้า​มา​หา แล้ว​วาง​มือ​บน​หัว​เขา​เปื้อ​เขา​จะ​ผ่อ​หัน​แหม​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","อานาเนีย​ตอบ​ว่า “พระองค์​เจ้า​ข้า ข้าพเจ้า​ได้ยิน​หลาย​คน​อู้​เถิง​คน​นั้น​ว่า เขา​เยียะ​ฮ้าย​ต่อ​คน​ของ​พระองค์​ใน​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ก่อน​เขา​มา​นี่ เขา​ฮับ​อำนาจ​จาก​หมู่​หัวหน้า​ปุโรหิต​หื้อ​มา​ยับ​คน​ตังหลาย​ตี้​เจื้อ​พระองค์” ");
INSERT INTO nod_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","แต่​องค์​พระ​ผู้​เป๋น​เจ้า​บอก​อานาเนีย​ว่า “ไป​เต๊อะ ย้อน​เฮา​เลือก​ป้อจาย​คน​นี้​เป๋น​เครื่องมือ​ตี้​จะ​นำ​เรื่องราว​ของ​เฮา​ไป​บอก​กับ​คน​ต่างจ้าด​กับ​หมู่​กษัตริย์​กับ​คน​จาว​อิสราเอล​ตวย ");
INSERT INTO nod_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","เฮา​จะ​เยียะ​หื้อ​เซาโล​ฮู้​ว่า เขา​จะ​ต้อง​ทน​ตุ๊ก​ทรมาน​เปื้อ​เฮา​สัก​มอก​ใด” ");
INSERT INTO nod_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","แล้ว​อานาเนีย​ก็​ไป​ตี้​บ้าน​ตี้​ว่า​นั้น​ก็​ปะ​เซาโล แล้ว​วาง​มือ​ลง​บน​หัว​เซาโล​อู้​ว่า “อ้าย​เซาโล​เหย พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​ตี้​ป๋ากฏ​หื้อ​อ้าย​หัน​หละหว่าง​ก๋าง​ตาง​ตี้​มา​นั้น ส่ง​ข้าพเจ้า​มา​เปื้อ​เยียะ​หื้อ​อ้าย​ผ่อ​หัน​แหม​เตื้อ กับ​จะ​หื้อ​อ้าย​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์” ");
INSERT INTO nod_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","แล้ว​ก็​มี​อย่าง​นึ่ง​เหมือน​เกล็ด​ป๋า​หยวะ​ออก​จาก​ต๋า​ของ​เซาโล​บ่า​เดี่ยว​นั้น​เลย แล้ว​เขา​ก็​ผ่อ​หัน​แหม​เตื้อ เขา​ก็​ลุก​ขึ้น​ฮับ​บัพติศมา ");
INSERT INTO nod_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","เมื่อ​กิ๋น​ข้าว​กิ๋น​น้ำ​แล้ว เขา​ก็​ฮู้สึก​มี​แฮง​นัก​ขึ้น แล้ว​เซาโล​ก็​ย้าง​อยู่​กับ​หมู่​ผู้เจื้อ​ใน​เมือง​ดามัสกัส​หลาย​วัน ");
INSERT INTO nod_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","แล้ว​เซาโล​ก็​บ่﻿รอ​จ๊า​ตี้​จะ​ไป​ธรรมศาลา​ของ​จาว​ยิว แล้ว​ตั้งเก๊า​บอก​เรื่อง​ของ​พระเยซู​ว่า “พระองค์​เป๋น​พระบุตร​ของ​พระเจ้า” ");
INSERT INTO nod_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","คน​ตังหลาย​ตี้​ได้ยิน​เซาโล​อู้​จาอั้น​ก็​อิกขะหลิก​ใน​ใจ๋​อู้​กั๋น​ว่า “คน​นี้​บ่﻿ใจ้​กา ตี้​ค่ำ​กับ​เยียะ​ฮ้าย​ต่อ​ผู้เจื้อ​ใน​กรุง​เยรูซาเล็ม แล้ว​ตี้​เขา​มา​นี่​ก็​ย้อน​ตั้งใจ๋​จะ​มา​ยับ​คน​หมู่​นั้น​ปิ๊ก​ไป​หื้อ​หมู่​หัวหน้า​ปุโรหิต” ");
INSERT INTO nod_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","แต่​กำ​เตสนา​ของ​เซาโล​ก็​มี​อำนาจ​นัก​ขึ้น​ติก﻿ๆ กับ​พิสูจน์​หื้อ​จาว​ยิว​ใน​เมือง​ดามัสกัส​หัน​ว่า พระเยซู​เป๋น​พระคริสต์ เยียะ​หื้อ​หมู่​เขา​ปาก​บ่﻿ออก​เถียง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","หลาย​วัน​ผ่าน​ไป หมู่​จาว​ยิว​วางแผน​จะ​ฆ่า​เซาโล​เหีย ");
INSERT INTO nod_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","แต่​มี​คน​บอก​เซาโล​หื้อ​ฮู้​แผน​นั้น​เหีย​ก่อน หมู่​นั้น​ผก​ตี้​ปะตู๋​เมือง​ตึง​เมื่อวัน​เมื่อคืน​แน​จะ​ฆ่า​เซาโล ");
INSERT INTO nod_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","แต่​วัน​นึ่ง​ต๋อน​เมื่อคืน หมู่​ผู้เจื้อ​หื้อ​เซาโล​นั่ง​มอบ​ใน​ก๋วย​แก่น​ใหญ่ แล้ว​หย่อน​ก๋วย​นั้น​จ๊า﻿ๆ ผ่าน​ฮ่อม​ก่ำแปง​เมือง​ลง​ไป​ตัง​ลุ่ม ");
INSERT INTO nod_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","เมื่อ​เซาโล​ปิ๊ก​มา​แผว​กรุง​เยรูซาเล็ม​แล้ว เขา​ฮิ​เข้า​ฮ่วม​กับ​หมู่​ผู้เจื้อ แต่​หมู่​นั้น​ปา​กั๋น​กั๋ว ย้อน​บ่﻿เจื้อ​ว่า​เซาโล​เป๋น​ผู้เจื้อ​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","แต่​บารนาบัส​ปา​เซาโล​ไป​ปะ​หมู่​อัครทูต แล้ว​อธิบาย​หื้อ​ฟัง​ว่า ใน​หละหว่าง​ตาง​ไป​เมือง​ดามัสกัส​เซาโล​ปะ​องค์​พระ​ผู้​เป๋น​เจ้า​ได้​จาใด แล้ว​พระองค์​อู้​อะหยัง​กับ​เซาโล​พ่อง ยัง​เล่า​แหม​ว่า ต๋อน​เซาโล​อยู่​ตี้​เมือง​ดามัสกัส​นั้น เซาโล​เตสนา​เรื่อง​ของ​พระเยซู​อย่าง​บ่﻿กั๋ว​ใผ ");
INSERT INTO nod_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","หมู่​อัครทูต​ก็​ยอมฮับ​เซาโล​เข้า​มา​อยู่​ตวย​กั๋น แล้ว​ไป​ไหน​มา​ไหน​ใน​กรุง​เยรูซาเล็ม​ตวย​กั๋น​อย่าง​สบาย กับ​เตสนา​ใน​นาม​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​อย่าง​บ่﻿กั๋ว​ใผ ");
INSERT INTO nod_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ต้าน​อู้​โต้แย้ง​เถียง​กับ​หมู่​จาว​ยิว​ตี้​อู้​ภาษา​กรีก​ตวย แต่​หมู่​นั้น​ก็​หา​ตาง​ตี้​จะ​ฆ่า​ต้าน​เหีย ");
INSERT INTO nod_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","เมื่อ​หมู่​ปี้น้อง​ผู้เจื้อ​ฮู้​เรื่อง​นี้ ก็​ปา​เซาโล​ไป​ตี้​เมือง​ซีซารียา แล้ว​ส่ง​ไป​เมือง​ทาร์ซัส​บ้าน​เกิด​ของ​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","จาก​นั้น​หมู่​คริสตจักร​ใคว่​แคว้น​ยูเดีย กาลิลี กับ​สะมาเรีย​ก็​มี​สันติสุข กับ​พระวิญญาณ​บริสุทธิ์​จ้วย​หื้อ​คริสตจักร​เข้มแข็ง มี​คน​มา​เจื้อ​พระเยซู​นัก​ขึ้น แล้ว​หมู่​ผู้เจื้อ​ก็​ใจ๊​จีวิต​ตี้​เคารพ​ยำเก๋ง​องค์​พระ​ผู้​เป๋น​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ส่วน​เปโตร​เตียวตาง​ไป​ตี้​ต่าง﻿ๆ ก็​ไป​แอ่ว​หา​คน​ของ​พระเจ้า​ใน​เมือง​ลิดดา ");
INSERT INTO nod_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ตี้​หั้น​เขา​ปะ​ป้อจาย​คน​นึ่ง​จื้อ​ไอเนอัส​เป๋น​ง่อย​นอน​อยู่​บน​ตี้นอน​มา​แปด​ปี๋​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","เปโตร​อู้​กับ​เขา​ว่า “ไอเนอัส​เหย พระเยซู​คริสต์​ฮักษา​ต้าน​หื้อ​หาย​แล้ว ลุก​ขึ้น​เก็บ​ตี้นอน​เหีย​เต๊อะ” แล้ว​ไอเนอัส​ก็​ลุก​ขึ้น​บ่า​เดี่ยว​นั้น ");
INSERT INTO nod_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","เมื่อ​คน​ตังหลาย​ตี้​อาศัย​อยู่​ใน​เมือง​ลิดดา​กับ​ตี้​ราบ​ชาโรน​หัน​จาอั้น หมู่​เขา​ก็​เข้า​มา​ฮับเจื้อ​องค์​พระ​ผู้​เป๋น​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ตี้​เมือง​ยัฟฟา​มี​ผู้เจื้อ​เป๋น​แม่ญิง​คน​นึ่ง​จื้อ​ทาบิธา​เป๋น​ภาษา​ฮีบรู แต่​ภาษา​กรีก​ว่า​โดรคัส​แป๋​ว่า​กว๋าง นาง​เป๋น​คน​จ้วย​เอา​ใจ๋ใส่​กับ​หื้อ​ตาน​แก่​คน​ตุ๊ก​คน​ยาก​มา​ตลอด ");
INSERT INTO nod_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","เวลา​นั้น​นาง​ป่วย​แล้ว​ต๋าย หมู่​เปื้อน​บ้าน​จึง​อาบ​น้ำ​ศพ​ต๋าม​ธรรมเนียม​จาว​ยิว แล้ว​เก็บ​ศพ​นาง​ไว้​ตี้​ห้อง​จั๊น​บน ");
INSERT INTO nod_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","เมือง​ลิดดา​กับ​เมือง​ยัฟฟา​อยู่​บ่﻿ไก๋​กั๋น เมื่อ​หมู่​ผู้เจื้อ​ได้ยิน​ว่า​เปโตร​อยู่​ใน​เมือง​ลิดดา หมู่​เขา​ก็​ใจ๊​ป้อจาย​สอง​คน​ไป​อ้อนวอน​เจิญ​เปโตร​ว่า “ขอ​มา​เวย﻿ๆ เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","เปโตร​จึง​ตวย​สอง​คน​นั้น​ไป เมื่อ​ไป​แผว หมู่​เขา​ก็​ปา​เปโตร​ขึ้น​ไป​ตี้​ห้อง​จั๊น​บน หมู่​แม่​หม้าย​ยืน​ไห้​สนั่น​ปั่น​ปื๊น​แวด​เปโตร กับ​จี๊​หื้อ​เปโตร​ผ่อ​เสื้อผ้า​ต่าง﻿ๆ ตี้​โดรคัส​หยิบ​ไว้​ต๋อน​ยัง​มี​จีวิต​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","เปโตร​จึง​ขอ​หื้อ​หมู่​เขา​ออก​ไป​ตัง​นอก ต้าน​ก็​คุก​เข่า​อธิษฐาน แล้ว​บิ่น​หน้า​มา​ตัง​ศพ​อู้​ว่า “ทาบิธา​ลุก​ขึ้น​เต๊อะ” นาง​ก็​มืน​ต๋า​ขึ้น เมื่อ​หัน​เปโตร นาง​ก็​ลุก​ขึ้น​นั่ง ");
INSERT INTO nod_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","เปโตร​จึง​เอา​มือ​จ้วย​ตุ้ม​นาง​ลุก​ขึ้น​ยืน จาก​นั้น​ก็​ฮ้อง​หมู่​ผู้เจื้อ​กับ​หมู่​แม่​หม้าย​เข้า​มา แล้ว​หื้อ​ผ่อ​ว่า​นาง​มี​จีวิต​ขึ้น​มา​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","เรื่อง​นี้​ฮู้​กั๋น​ไป​ใคว่​เมือง​ยัฟฟา เยียะ​หื้อ​มี​หลาย​คน​มา​ฮับเจื้อ​องค์​พระ​ผู้​เป๋น​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","เปโตร​อยู่​ใน​เมือง​ยัฟฟา​ต่อ​ไป​แหม​หลาย​วัน ต้าน​อยู่​ตวย​คน​จื้อ​ซีโมน​ผู้​มี​อาชีพ​เป๋น​สล่า​ฟอก​หนัง ");
INSERT INTO nod_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ใน​เมือง​ซีซารียา​มี​ป้อจาย​คน​นึ่ง​จื้อ​โครเนลิอัส เป๋น​นายร้อย​ทหาร​อยู่​ก๋อง​ทหาร​จื้อ​ก๋อง​อิตาเลียน ");
INSERT INTO nod_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","นายร้อย​คน​นี้​ตึง​ครอบครัว​ของ​ต้าน​เป๋น​คน​ยำเก๋ง​พระเจ้า ต้าน​หื้อ​ตาน​จ้วยเหลือ​คน​ตุ๊ก​คน​จ๋น​กับ​อธิษฐาน​ต่อ​พระเจ้า​บ่﻿เกย​ขาด ");
INSERT INTO nod_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","วัน​นึ่ง​เวลา​ประมาณ​บ่าย​สาม​โมง โครเนลิอัส​ก่ำลัง​อธิษฐาน​อยู่ ก็​หัน​นิมิต​อย่าง​เต๋ม​ต๋า คือ​เขา​หัน​ทูตสวรรค์​องค์​นึ่ง​ของ​พระเจ้า​เข้า​มา​หา​ฮ้อง​ต้าน​ว่า “โครเนลิอัส​เหย” ");
INSERT INTO nod_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","โครเนลิอัส​ตกใจ๋​กั๋ว​ปักต๋าผ่อ​ทูต​องค์​นั้น แล้ว​ถาม​ว่า “ต้าน​เจ้าข้า มี​อะหยัง​กา” ทูตสวรรค์​จึง​อู้​กับ​ต้าน​ว่า “กำ​อธิษฐาน​ของ​เจ้า​กับ​ตาน​ตี้​เจ้า​จ้วยเหลือ​คน​ตุ๊ก​คน​จ๋น ก็​ขึ้น​ไป​เถิง​พระเจ้า​แล้ว พระองค์​บ่﻿ได้​ลืม​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","บ่าเดี่ยวนี้​หื้อ​เจ้า​ส่ง​คน​ไป​ตี้​เมือง​ยัฟฟา ไป​เจิญ​ซีโมน​ตี้​คน​ฮ้อง​ว่า​เปโตร​มา​หา​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","เปโตร​ย้าง​อยู่​กับ​สล่า​ฟอก​หนัง​จื้อ​ซีโมน บ้าน​เปิ้น​อยู่​ฮิม​ทะเล” ");
INSERT INTO nod_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","เมื่อ​ทูตสวรรค์​ไป​แล้ว โครเนลิอัส​จึง​ฮ้อง​คน​ฮับใจ๊​ใน​บ้าน​มา​สอง​คน กับ​ทหาร​ฮับใจ๊​แหม​คน​นึ่ง​ตี้​ยำเก๋ง​พระเจ้า​เข้า​มา​หา ");
INSERT INTO nod_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","แล้ว​ก็​เล่า​เรื่อง​ตี้​เกิด​ขึ้น​ตึงหมด​ตึงเสี้ยง​หื้อ​หมู่​เขา​ฟัง จาก​นั้น​ก็​ส่ง​หมู่​เขา​ไป​เมือง​ยัฟฟา ");
INSERT INTO nod_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","วัน​ต่อ​มา​เวลา​ประมาณ​เตี้ยง คน​หมู่​นั้น​ก่ำลัง​เตียวตาง​มา​ใก้​จะ​แผว​เมือง​ยัฟฟา เป๋น​เวลา​เดียว​กั๋น​ตี้​เปโตร​ขึ้น​ไป​บน​ดาดฟ้า​เปื้อ​อธิษฐาน ");
INSERT INTO nod_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","เปโตร​ก็​ใค่​อยาก​กิ๋น​ข้าว หละหว่าง​ตี้​คน​ใน​บ้าน​ก่ำลัง​เยียะ​กิ๋น​อยู่​นั้น เปโตร​ก็​ตก​อยู่​ใน​ภาวะ​เกิ่ง​หลับ​เกิ่ง​ตื่น ");
INSERT INTO nod_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","เขา​หัน​ต๊องฟ้า​เปิด​ออก แล้ว​หัน​อย่าง​นึ่ง​เหมือน​ผ้า​สี่​แจ่ง​ผืน​ใหญ่​ลง​มา​เอง​เหมือน​ว่า​มี​คน​ก๋ำ​แจ่ง​ผ้า​ลง​มา​ปื๊น​โลก ");
INSERT INTO nod_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ใน​ผ้า​ผืน​นั้น​หัน​มี​สัตว์​กู้​อย่าง ตึง​สัตว์​สี่​ตี๋น​เตียว​ดิน สัตว์​เลื้อยกาน กับ​นก​ใน​อากาศ ");
INSERT INTO nod_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","แล้ว​มี​เสียง​อู้​กับ​ต้าน​ว่า “เปโตร​เหย ลุก​ขึ้น​มา​ฆ่า​สัตว์​หมู่​นี้​กิ๋น​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","เปโตร​ตอบ​ว่า “อึ บ่﻿ได้​องค์​พระผู้เป๋นเจ้า สิ่ง​ตี้​เป๋น​ของ​ต้อง​ห้าม​กาว่า​เป๋น​มลทิน​หมู่​นั้น ข้า​พระองค์​บ่﻿เกย​กิ๋น​เลย” ");
INSERT INTO nod_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","เสียง​นั้น​ก็​อู้​เตื้อ​ตี้​สอง​ว่า “สิ่ง​ตี้​พระเจ้า​เยียะ​หื้อ​สะอาด​แล้ว เจ้า​บ่﻿ควร​ถือ​ว่า​เป๋น​มลทิน” ");
INSERT INTO nod_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","เปโตร​หัน​จาอี้​เถิง​สาม​เตื้อ​ตวย​กั๋น แล้ว​ของ​หมู่​นั้น​ก็​ลอย​ปิ๊ก​ขึ้น​ไป​บน​ต๊องฟ้า​ตันที ");
INSERT INTO nod_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ต๋อน​ตี้​เปโตร​ก่ำลัง​อิกขะหลิก​ใน​ใจ๋​ว่า​นิมิต​ตี้​หัน​นี้​หมาย​เถิง​อะหยัง ใน​เวลา​เดียว​กั๋น​นั้น หมู่​คน​ตี้​โครเนลิอัส​ใจ๊​มา​ก็​ปะ​บ้าน​ของ​ซีโมน​แล้ว หมู่​เขา​ก่ำลัง​ยืน​อยู่​หน้า​ปะตู๋​ฮั้ว​บ้าน​ปอดี ");
INSERT INTO nod_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ป้อจาย​หมู่​นั้น​เอิ้น​ถาม​ว่า “ซีโมน​ตี้​ฮ้อง​ว่า​เปโตร​ย้าง​อยู่​ตี้​นี่​ก่อ” ");
INSERT INTO nod_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","เมื่อ​เปโตร​ยัง​กึ๊ด​เถิง​เรื่อง​นิมิต​อยู่ พระวิญญาณ​บริสุทธิ์​บอก​เขา​ว่า “ผ่อ​หั้น​ลอ มี​ป้อจาย​สาม​คน​มา​ถาม​หา​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ลุก​ขึ้น แล้ว​ลง​ไป​ตัง​ลุ่ม หื้อ​ไป​ตวย​หมู่​เขา​เต๊อะ บ่﻿ต้อง​สงสัย​อะหยัง​ย้อน​เฮา​ใจ๊​หมู่​เขา​มา​หา​เจ้า” ");
INSERT INTO nod_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","แล้ว​เปโตร​ก็​ลง​ไป​หา​หมู่​เขา บอก​ว่า “เฮา​คือ​คน​ตี้​ต้าน​ตังหลาย​มา​เซาะ​หา มี​ธุระ​อะหยัง​กา” ");
INSERT INTO nod_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","หมู่​เขา​ปา​กั๋น​ตอบ​ว่า “นายร้อย​โครเนลิอัส​หื้อ​หมู่​เฮา​มา​หา​ต้าน เปิ้น​เป๋น​คน​ตี้​ถูกต้อง​ต๋าม​ธรรม​กับ​เก๋งกั๋ว​พระเจ้า จาว​ยิว​ก็​ยกย่อง​นับถือ​ต้าน ทูตสวรรค์​บริสุทธิ์​บอก​เปิ้น​หื้อ​มา​เจิญ​ต้าน​ไป​ตี้​บ้าน เปื้อ​ขอ​หื้อ​ต้าน​เล่า​เรื่อง​หื้อ​ฟัง” ");
INSERT INTO nod_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","เปโตร​ก็​เลย​จวน​ป้อจาย​ตึง​สาม​ย้าง​ตี้​บ้าน​นั้น แจ้งเจ๊า​มา​เปโตร​ไป​ตวย​หมู่​เขา มี​ปี้น้อง​ผู้เจื้อ​บาง​คน​จาก​เมือง​ยัฟฟา​ติดต๋าม​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ถัด​มา​แหม​วัน​นึ่ง​หมู่​เขา​ก็​เตียวตาง​มา​แผว​เมือง​ซีซารียา โครเนลิอัส​ก่ำลัง​กองถ้า​ต้อนฮับ​อยู่ กับ​เจิญ​ญาติ​ปี้น้อง​ตึง​เปื้อน​สนิท​มา​จุมนุม​กั๋น​อยู่​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","เมื่อ​เปโตร​เตียว​เข้า​ไป​ใน​บ้าน โครเนลิอัส​ก็​ต้อนฮับ​ด้วย​ก๋าน​หมอบ​ลง​ไหว้​ตี้​ตี๋น​ของ​เปโตร ");
INSERT INTO nod_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","แต่​เปโตร​ก๋ำ​แขน​โครเนลิอัส​หื้อ​ลุก​ขึ้น​แล้ว​บอก​ว่า “ลุก​ขึ้น​เต๊อะ เฮา​ก็​เป๋น​คน​เหมือน​กั๋น” ");
INSERT INTO nod_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","เปโตร​อู้​กับ​โครเนลิอัส แล้ว​ปา​กั๋น​เตียว​เข้า​ไป​ตัง​ใน ก็​ปะ​หมู่​คน​ตี้​มา​จุมนุม​กั๋น​อยู่​ตี้​หั้น​จ๋ำนวน​นัก ");
INSERT INTO nod_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","เปโตร​ก็​อู้​กับ​คน​ตังหลาย​นั้น​ว่า “ต้าน​ตังหลาย​ก็​ฮู้​อยู่​แล้ว​ว่า เป๋น​ก๋าน​ผิด​บท​บัญญัติ​ตี้​จาว​ยิว​คบ​กาว่า​แอ่ว​หา​คน​ต่างจ้าด แต่​พระเจ้า​เยียะ​หื้อ​หัน​แล้ว​ว่า บ่﻿ควร​จะ​ถือ​ว่า​คน​นึ่ง​คน​ใด​เป๋น​คน​บ่﻿สะอาด​กาว่า​เป๋น​คน​มี​มลทิน ");
INSERT INTO nod_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ย้อน​จาอั้น​เมื่อ​มี​คน​ไป​เจิญ​เฮา​มา เฮา​ก็​บ่﻿ขัดข้อง​อะหยัง แต่​ขอ​ถาม​น่อย​เต๊อะ​ว่า ต้าน​เจิญ​เฮา​มา​เยียะ​อะหยัง” ");
INSERT INTO nod_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","โครเนลิอัส​จึง​ตอบ​ว่า “เมื่อ​สี่​วัน​มา​แล้ว ต๋อน​บ่าย​สาม​โมง​เต้า​กับ​เวลา​นี้​ปอดี เฮา​อธิษฐาน​อยู่​ใน​บ้าน จู่﻿ๆ ก็​มี​ป้อจาย​คน​นึ่ง​นุ่ง​เสื้อ​มัน​เงา​มา​ยืน​อยู่​ส่อง​หน้า​เฮา ");
INSERT INTO nod_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","แล้ว​อู้​ว่า ‘โครเนลิอัส​เหย พระเจ้า​ฟัง​กำ​อธิษฐาน​ของ​เจ้า​แล้ว ก็​ฮู้​ก็​หัน​เถิง​ตาน​ตี้​จ้วยเหลือ​คน​ตุ๊ก​คน​จ๋น ");
INSERT INTO nod_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","หื้อ​เจ้า​ส่ง​คน​ไป​ตี้​เมือง​ยัฟฟา เจิญ​ซีโมน​ตี้​คน​ฮ้อง​ว่า​เปโตร​มา​ตี้​นี่ เปโตร​ย้าง​อยู่​กับ​ซีโมน​ตี้​เป๋น​สล่า​ฟอก​หนัง บ้าน​ของ​เขา​อยู่​ฮิม​ทะเล’ ");
INSERT INTO nod_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","เฮา​จึง​ส่ง​คน​ไป​เจิญ​ต้าน​ตันที ต้าน​มา​แล้ว​ก็​ดี​แต๊﻿ๆ บ่าเดี่ยวนี้​หมู่​เฮา​อยู่​พร้อม​กั๋น​ต่อ​หน้า​พระเจ้า​ตี้​นี่ เปื้อ​ฟัง​กู้​สิ่ง​ตี้​องค์​พระ​ผู้​เป๋น​เจ้า​สั่ง​หื้อ​ต้าน​มา​บอก​หมู่​เฮา” ");
INSERT INTO nod_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","เปโตร​จึง​อู้​ว่า “บ่าเดี่ยวนี้​เฮา​เข้าใจ๋​อย่าง​ถองแกะ​ถองแก๋น​แล้ว​ว่า พระเจ้า​บ่﻿เลือก​หน้า​ใผ ");
INSERT INTO nod_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","แต่​พระองค์​ยอมฮับ​คน​กู้​จ้าด​ตี้​เคารพ​ยำเก๋ง​พระองค์ กับ​เยียะ​ต๋าม​ความ​ถูกต้อง ");
INSERT INTO nod_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ต้าน​ก็​ฮู้​ถ้อยกำ​ตี้​พระเจ้า​มอบ​หื้อ​กับ​จาว​อิสราเอล คือ​ถ้อยกำ​ตี้​บอก​เถิง​ข่าวดี​เกี่ยวกับ​สันติสุข​ผ่าน​ตาง​พระเยซู​คริสต์​ผู้​เป๋น​องค์​พระ​ผู้​เป๋น​เจ้า​ของ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ต้าน​ก็​ฮู้​เถิง​เหตุก๋ารณ์​ยิ่งใหญ่​ตี้​เกิด​ขึ้น​ทั่ว​แคว้น​ยูเดีย ตั้งเก๊า​ใน​กาลิลี​หลังจาก​ยอห์น​บอก​เรื่อง​บัพติศมา​นั้น ");
INSERT INTO nod_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","คือ​ว่า​พระเจ้า​เจิม​พระเยซู​จาว​นาซาเร็ธ​ด้วย​พระวิญญาณ​บริสุทธิ์​ตึง​ฤทธิ์​อำนาจ พระเยซู​เยียะ​สิ่ง​ดี﻿ๆ ไป​ผับใคว่ ตึง​ฮักษา​คน​ตี้​ตก​เป๋น​ขี้ข้า​อยู่​ใต้​อำนาจ​ของ​มาร ย้อน​ว่า​พระเจ้า​อยู่​ตวย​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","หมู่​เฮา​ก็​เป๋น​พยาน​เถิง​ก๋านงาน​ตึงหมด​ตึงเสี้ยง​ตี้​พระองค์​เยียะ​ใน​กรุง​เยรูซาเล็ม​กับ​ใน​แคว้น​ยูเดีย​นั้น หมู่​เขา​ฆ่า​พระองค์​โดย​เขิง​บน​ไม้​ก๋างเขน ");
INSERT INTO nod_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","แต่​ใน​วัน​ตี้​สาม พระเจ้า​เยียะ​หื้อ​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย ตึง​หื้อ​พระองค์​มา​ป๋ากฏ​ตั๋ว​หื้อ​หัน ");
INSERT INTO nod_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","แต่​บ่﻿ใจ้​หื้อ​กู้​คน​หัน พระเจ้า​เลือก​คน​ตี้​จะ​เป๋น​พยาน​ล่วงหน้า​ไว้​แล้ว คือ​หมู่​เฮา​ตี้​กิ๋น​ดื่ม​กับ​พระเยซู​หลังจาก​พระองค์​เป๋น​ขึ้น​จาก​ความ​ต๋าย​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","พระเยซู​สั่ง​หื้อ​หมู่​เฮา​ออก​ไป​เตสนา​สั่ง​สอน​คน​ตังหลาย กับ​หื้อ​หมู่​เฮา​เป๋น​พยาน​ว่า พระเจ้า​แต่งตั้ง​พระองค์​ไว้​หื้อ​เป๋น​ผู้​พิพากษา​ตึง​คน​ตี้​มี​จีวิต​อยู่ กับ​คน​ตี้​ต๋าย​ไป​แล้ว​ตวย ");
INSERT INTO nod_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตังหลาย​ก็​เป๋น​พยาน​เถิง​พระองค์​ว่า กู้​คน​ตี้​เจื้อ​วางใจ๋​พระองค์​จะ​ฮับ​ก๋าน​ยกโต้ษ​บาป​โดย​พระองค์” ");
INSERT INTO nod_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","เมื่อ​เปโตร​ก่ำลัง​อู้​อยู่​นั้น พระวิญญาณ​บริสุทธิ์​ก็​ลง​มา​อยู่​กับ​คน​ตังหลาย​ตี้​ฟัง​ถ้อยกำ​เรื่อง​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","หมู่​จาว​ยิว​ตี้​เป๋น​ผู้เจื้อ​ตี้​มา​ตวย​เปโตร ก็​ปา​กั๋น​งืด​ใน​ใจ๋​ตี้​พระเจ้า​หื้อ​พระวิญญาณ​บริสุทธิ์​แก่​คน​ต่างจ้าด​ตวย ");
INSERT INTO nod_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ย้อน​หมู่​เขา​ได้ยิน​คน​หมู่​นี้​อู้​ภาษา​อื่น﻿ๆ กับ​สรรเสริญ​พระเจ้า เปโตร​ก็​อู้​ขึ้น​ว่า ");
INSERT INTO nod_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“บ่﻿มี​ใผ​ตี้​จะ​ว่า​บ่﻿หื้อ​คน​หมู่​นี้​ฮับ​บัพติศมา​ด้วย​น้ำ​ได้ ย้อน​ว่า​หมู่​เขา​ก็​ฮับ​พระวิญญาณ​บริสุทธิ์​เหมือน​กับ​หมู่​เฮา” ");
INSERT INTO nod_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","เปโตร​จึง​สั่ง​หื้อ​หมู่​เขา​เข้า​ฮับ​บัพติศมา​ด้วย​น้ำ​ใน​นาม​ของ​พระเยซู​คริสต์ จาก​นั้น​หมู่​เขา​ก็​จวน​เปโตร​หื้อ​ย้าง​อยู่​กับ​หมู่​เขา​แหม​สอง​สาม​วัน ");
INSERT INTO nod_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","หมู่​อัครทูต​กับ​หมู่​ปี้น้อง​ผู้เจื้อ​ตี้​อยู่​ใน​แคว้น​ยูเดีย​ได้ยิน​ว่า​คน​ต่างจ้าด​ก็​เจื้อ​ถ้อยกำ​ของ​พระเจ้า​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","แต่​เมื่อ​เปโตร​ปิ๊ก​มา​ตี้​กรุง​เยรูซาเล็ม หมู่​คน​ตี้​หัน​ตวย​ว่า​คน​ต่างจ้าด​ตี้​ฮับเจื้อ​พระเยซู​ควร​เข้า​พิธี​สุหนัต ก็​ด่า​ต้าน​ว่า ");
INSERT INTO nod_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“เจ้า​เข้า​ไป​ใน​บ้าน​ของ​หมู่​ตี้​บ่﻿ได้​เข้า​พิธี​สุหนัต ก็​บ่﻿ถูกต้อง ป๋าย​บ่﻿ปอ​ยัง​กิ๋น​ข้าว​ฮ่วม​กับ​หมู่​เขา​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","เปโตร​จึง​เล่า​เถิง​สิ่ง​ต่าง﻿ๆ ตี้​เกิด​ขึ้น​หื้อ​หมู่​เขา​ฟัง​ตั้งแต่​เก๊า​สุด​ป๋าย​ว่า ");
INSERT INTO nod_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ต๋อน​ตี้​ข้าพเจ้า​ก่ำลัง​อธิษฐาน​ตี้​เมือง​ยัฟฟา​นั้น ข้าพเจ้า​อยู่​ใน​ภาวะ​เกิ่ง​หลับ​เกิ่ง​ตื่น แล้ว​หัน​นิมิต มี​อย่าง​นึ่ง​ผ่อ​เหมือน​ผ้า​สี่​แจ่ง​ผืน​ใหญ่​ลง​มา​เอง​เหมือน​ว่า​มี​คน​ก๋ำ​แจ่ง​ผ้า​ลง​มา​จาก​ฟ้า​มา​หา​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ข้าพเจ้า​ปักต๋าผ่อ​ถี่﻿ๆ ใน​ผ้า​ผืน​นั้น หัน​มี​สัตว์​สี่​ตี๋น​เตียว​ดิน สัตว์​ป่า สัตว์​เลื้อยกาน กับ​นก​ใน​อากาศ ");
INSERT INTO nod_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","แล้ว​ข้าพเจ้า​ก็​ได้ยิน​เสียง​อู้​ว่า ‘เปโตร​เหย ลุก​ขึ้น​มา​ฆ่า​สัตว์​หมู่​นี้​กิ๋น​เต๊อะ’ ");
INSERT INTO nod_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","แต่​ข้าพเจ้า​ก็​ตอบ​ว่า ‘อึ บ่﻿ได้​องค์​พระผู้เป๋นเจ้า ข้าพเจ้า​บ่﻿เกย​กิ๋น​ของ​ต้อง​ห้าม​กาว่า​ของ​เป๋น​มลทิน สัตว์​หมู่​นี้​บ่﻿เกย​เข้า​ปาก​ข้า​พระองค์​เลย​สัก​กำ’ ");
INSERT INTO nod_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“มี​เสียง​อู้​จาก​ต๊องฟ้า​เป๋น​เตื้อ​ตี้​สอง​ว่า ‘สิ่ง​ตี้​พระเจ้า​เยียะ​หื้อ​สะอาด​แล้ว เจ้า​บ่﻿ควร​ถือ​ว่า​เป๋น​มลทิน’ ");
INSERT INTO nod_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","เหตุก๋ารณ์​นี้​เกิด​ขึ้น​อย่าง​เดียว​กั๋น​เถิง​สาม​เตื้อ แล้ว​ของ​ตึงหมด​ก็​ลอย​ปิ๊ก​ขึ้น​ไป​บน​ต๊องฟ้า​แหม ");
INSERT INTO nod_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“เวลา​เดียว​กั๋น​นั้น​ก็​มี​สาม​คน​มา​ยืน​ตั๊ด​หน้า​บ้าน​ตี้​ข้าพเจ้า​อยู่ ป้อจาย​คน​นึ่ง​ใจ๊​หมู่​เขา​มา​จาก​เมือง​ซีซารียา​มา​หา​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","แล้ว​พระวิญญาณ​บริสุทธิ์​บอก​ข้าพเจ้า​หื้อ​ไป​ตวย​หมู่​เขา​เต๊อะ บ่﻿ต้อง​สงสัย ปี้น้อง​ผู้เจื้อ​ตึง​หก​คน​นี้​ก็​ไป​ตวย​ข้าพเจ้า แล้ว​หมู่​เฮา​ก็​เข้า​ไป​ใน​บ้าน​ของ​โครเนลิอัส​ตี้​ใจ๊​คน​มา​หา​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","โครเนลิอัส​ก็​อู้​หื้อ​หมู่​เฮา​ฟัง​ว่า เขา​หัน​ทูตสวรรค์​ยืน​อยู่​ใน​บ้าน​ของ​เขา แล้ว​อู้​ว่า ‘หื้อ​ส่ง​คน​ไป​ตี้​เมือง​ยัฟฟา ไป​เจิญ​ซีโมน​ตี้​คน​ฮ้อง​กั๋น​ว่า​เปโตร​มา​หา ");
INSERT INTO nod_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","เปโตร​คน​นี้​จะ​เล่า​เถิง​ถ้อยกำ​ตี้​จะ​เยียะ​หื้อ​ต้าน​กับ​สมาชิก​ใน​ครอบครัว​ของ​ต้าน​ได้​ฮับ​ความ​รอด​ป๊น​บาป​โต้ษ’ ");
INSERT INTO nod_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“เมื่อ​ข้าพเจ้า​ตั้งเก๊า​อู้ พระวิญญาณ​บริสุทธิ์​ก็​ลง​มา​อยู่​กับ​หมู่​เขา เหมือน​กับ​ตี้​มา​อยู่​กับ​หมู่​เฮา​ต๋อน​เริ่ม​ต้น​นั้น ");
INSERT INTO nod_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","เยียะ​หื้อ​ข้าพเจ้า​กึ๊ด​เถิง​สิ่ง​ตี้​พระเยซู​อู้​ไว้​ว่า ‘ยอห์น​หื้อ​ฮับ​บัพติศมา​ด้วย​น้ำ แต่​หมู่​เจ้า​จะ​ฮับ​บัพติศมา​ด้วย​พระวิญญาณ​บริสุทธิ์’ ");
INSERT INTO nod_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","จาอั้น​ถ้า​พระเจ้า​หื้อ​พระวิญญาณ​บริสุทธิ์​กับ​หมู่​เขา เหมือน​หมู่​เฮา​ตี้​เจื้อ​วางใจ๋​พระเยซู​คริสต์​องค์​พระผู้เป๋นเจ้า​แล้ว ข้าพเจ้า​จะ​ขัดขืน​พระเจ้า​ก็​ตึง​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","เมื่อ​หมู่​เขา​ได้ยิน​จาอั้น ก็​เลิก​ว่า​เปโตร แล้ว​ปา​กั๋น​สรรเสริญ​พระเจ้า​ว่า “พระเจ้า​ก็​โผด​หื้อ​สิทธิ์​คน​ต่างจ้าด ตี้​จะ​กลับใจ๋​จาก​บาป​กับ​ได้​ฮับ​จีวิต​นิรันดร์” ");
INSERT INTO nod_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ฝ่าย​หมู่​ผู้เจื้อ​ตี้​แตก​ขะแล​ขะแจ​ไป​ต๋อน​ตี้​มี​ก๋าน​ค่ำเข​หลังจาก​สเทเฟน​ต๋าย พ่อง​ก็​ไป​ไก๋​แผว​ดินแดน​ฟีนิเซีย พ่อง​ไป​เกาะ​ไซปรัส พ่อง​ผด​ไป​แผว​เมือง​อันทิโอก แต่​คน​หมู่​นี้​บอก​ถ้อยกำ​เรื่อง​พระเยซู​หื้อ​จาว​ยิว​ฟัง​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ผู้เจื้อ​จาว​เกาะ​ไซปรัส​กับ​จาว​เมือง​ไซรีน​บาง​คน​มา​แผว​เมือง​อันทิโอก แล้ว​ปา​กั๋น​บอก​ข่าวดี​เกี่ยวกับ​พระเยซู​องค์​พระผู้เป๋นเจ้า​หื้อ​กับ​จาว​กรีก ");
INSERT INTO nod_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ฤทธิ์​อำนาจ​ของ​องค์​พระผู้เป๋นเจ้า​อยู่​กับ​หมู่​เขา เยียะ​หื้อ​มี​คน​มา​ฮับเจื้อ​กับ​ตวย​ต๋าม​องค์​พระผู้เป๋นเจ้า​เป๋น​จ๋ำนวน​นัก ");
INSERT INTO nod_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ข่าว​นี้​เล่าลือ​ไป​แผว​คริสตจักร​ใน​กรุง​เยรูซาเล็ม คริสตจักร​ก็​ส่ง​บารนาบัส​ไป​เมือง​อันทิโอก เปื้อ​ผ่อ​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","เมื่อ​บารนาบัส​มา​แผว​เมือง​อันทิโอก​แล้ว หัน​ว่า​พระเจ้า​ปั๋นปอน​คน​ตี้​หั้น​แต๊﻿ๆ เขา​ก็​ดีใจ๋​ขนาด แล้ว​หื้อ​ก๋ำลังใจ๋​กับ​หมู่​เขา​หื้อ​เจื้อฟัง​องค์​พระผู้เป๋นเจ้า​อย่าง​มั่นคง ");
INSERT INTO nod_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","บารนาบัส​เป๋น​คน​ดี มี​ความ​เจื้อ​เข้มแข็ง เขา​ได้​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ จึง​มี​คน​จ๋ำนวน​นัก​เข้า​มา​ฮับเจื้อ​องค์​พระผู้เป๋นเจ้า ");
INSERT INTO nod_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","จาก​นั้น​บารนาบัส​ก็​ไป​ตวย​หา​เซาโล​ตี้​เมือง​ทาร์ซัส ");
INSERT INTO nod_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","เมื่อ​ปะ​เซาโล​แล้ว ก็​ปา​มา​ตี้​เมือง​อันทิโอก แล้ว​ตึง​สอง​คน​ก็​เข้า​ฮ่วม​จุมนุม​กับ​คน​ใน​คริสตจักร​ตี้​หั้น​เป๋น​เวลา​นึ่ง​ปี๋​เต๋ม ต้าน​ตึง​สอง​สั่ง​สอน​คน​เป๋น​จ๋ำนวน​นัก หมู่​ผู้เจื้อ​ได้​จื้อ​ว่า​คริสเตียน​เป๋น​ครั้ง​แรก​ตี้​เมือง​อันทิโอก​นี้​ละ ");
INSERT INTO nod_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ใน​เวลา​นั้น​มี​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​บาง​คน​ลุก​จาก​กรุง​เยรูซาเล็ม​เตียวตาง​ไป​เมือง​อันทิโอก ");
INSERT INTO nod_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","มี​คน​นึ่ง​ใน​หมู่​นั้น​จื้อ​อากาบัส เขา​ยืน​ขึ้น​ใน​ตี้​จุมนุม แล้ว​ตวายตั๊ก​โดย​พระวิญญาณ​บริสุทธิ์​ว่า จะ​เกิด​ก๋าน​กั้นอยาก​ครั้ง​ใหญ่​ใคว่​อาณาจักร​โรม (​เหตุก๋ารณ์​นี้​เกิด​ขึ้น​ใน​สมัย​ของ​จักรพรรดิ​คลาวดิอัส​) ");
INSERT INTO nod_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ย้อนจาอั้น​หมู่​ผู้เจื้อ​ตี้​อยู่​ใน​เมือง​อันทิโอก ก็​ตกลง​กั๋น​ตี้​จะ​หื้อ​ความ​จ้วยเหลือ​กับ​หมู่​ปี้น้อง​ผู้เจื้อ​ตี้​อาศัย​อยู่​ใน​แคว้น​ยูเดีย ต๋าม​แฮง​ตี้​จะ​จ้วย​ได้ ");
INSERT INTO nod_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","หมู่​เขา​ก็​เยียะ​จาอั้น คือ​เก็บ​ฮอม​เงิน​คำ แล้ว​มอบ​หื้อ​บารนาบัส​กับ​เซาโล​เอา​ไป​หื้อ​ผู้ปกครอง​ของ​คริสตจักร​ใน​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","เวลา​นั้น​กษัตริย์​เฮโรด​ยับ​บาง​คน​ใน​คริสตจักร เขา​ตั้งใจ๋​จะ​ค่ำ​หมู่​ผู้เจื้อ ");
INSERT INTO nod_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ต้าน​สั่ง​หื้อ​เอา​ดาบ​ฆ่า​ยากอบ​อ้าย​ของ​ยอห์น​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","เมื่อ​กษัตริย์​เฮโรด​หัน​ว่า​เยียะ​จาอี้​เยียะ​หื้อ​หมู่​จาว​ยิว​ปออก​ปอใจ๋ จึง​สั่ง​หื้อ​ไป​ยับ​เปโตร​มา​แหม​คน เซิ่ง​ตั๊ด​งาน​กิ๋น​เข้าหนมปัง​บ่﻿ใส่​เจื๊อ ");
INSERT INTO nod_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","หลังจาก​ยับ​เปโตร​มา​แล้ว ก็​เอา​ไป​ขัง​ไว้​ใน​คอก แล้ว​สั่ง​ทหาร​จ๋ำนวน​สี่​หมู่﻿ๆ ละ​สี่​คน​เปี่ยน​เวร​กั๋น​เฝ้า​เปโตร​ไว้ ตั้งใจ๋​ว่า​เมื่อ​เสี้ยง​สุด​งาน​นั้น​แล้ว ก็​จะ​เอา​เปโตร​ออก​ไป​ตัดสิน​ต่อ​หน้า​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ย้อนจาอั้น​เปโตร​จึง​ถูก​ขัง​ไว้​ใน​คอก แต่​ว่า​คริสตจักร​ปา​กั๋น​อธิษฐาน​อ้อนวอน​ต่อ​พระเจ้า​เผื่อ​เปโตร ");
INSERT INTO nod_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ต๋อน​เมื่อคืน​ก่อน​ตี้​เฮโรด​จะ​ปา​เปโตร​ออก​มา​จาก​คอก มี​ทหาร​สอง​คน​อยู่​สอง​ป่างข้าง เปโตร​ก่ำลัง​หลับ​อยู่​หว่างก๋าง มี​เจื้อก​เหล็ก​สอง​เส้น​ล่าม​ต้าน​ไว้ มี​ทหาร​ยาม​ยืน​เฝ้า​อยู่​หน้า​ปะตู๋​คอก​ตวย ");
INSERT INTO nod_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","จู่﻿ๆ ก็​มี​ทูตสวรรค์​องค์​นึ่ง​ของ​องค์​พระผู้เป๋นเจ้า​มา​ป๋ากฏ แล้ว​มี​แสง​ส่อง​เข้า​มา​ใน​ห้อง​ตี้​เปโตร​นอน ทูตสวรรค์​จิ​ขี้ข้าง​เปโตร​หื้อ​ตื่น​แล้ว​บอก​ว่า “ขะใจ๋​ลุก​ขึ้น​เวย﻿ๆ” กำ​นั้น​เจื้อก​เหล็ก​ก็​หลวะ​ออก​จาก​มือ​ของ​เปโตร​ตึง​สอง​เส้น ");
INSERT INTO nod_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ทูตสวรรค์​ก็​บอก​เปโตร​ว่า “เอา​ผ้าต่อง​มัด​แอว แล้ว​สุบ​เกิบ​เหีย” เปโตร​ก็​เยียะ​ตวย จาก​นั้น​ทูตสวรรค์​ก็​บอก​แหม​ว่า “ใส่​เสื้อ แล้ว​ตวย​ก้น​เฮา​มา” ");
INSERT INTO nod_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","เปโตร​จึง​ตวย​ทูตสวรรค์​นั้น​ออก​ไป แต่​บ่﻿ฮู้​ว่า​ตี้​ทูตสวรรค์​ก่ำลัง​เยียะ​นี้​เป๋น​เหตุก๋ารณ์​เกิด​ขึ้น​แต๊﻿ๆ ต้าน​กึ๊ด​ว่า​ฝัน​ไป ");
INSERT INTO nod_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ตึง​สอง​ก็​เตียว​ก๋าย​ยาม​จั๊น​ตี้​นึ่ง​กับ​ยาม​จั๊น​ตี้​สอง จ๋น​มา​เถิง​ปะตู๋​เหล็ก​ตี้​จะ​เข้า​ไป​ใน​เมือง ปะตู๋​นั้น​ก็​เปิด​อ้า​ออก​เอง ตึง​สอง​ออก​ไป​เตียว​ก๋าง​กอง​เส้น​นึ่ง แล้ว​ทูตสวรรค์​ก็​หาย​ไป ");
INSERT INTO nod_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","แล้ว​เปโตร​ก็​ฮู้สึก​ตั๋ว​จึง​อู้​ว่า “บ่าเดี่ยวนี้​เฮา​ฮู้​แล้ว​ว่า​เป๋น​เรื่อง​แต๊ องค์​พระผู้เป๋นเจ้า​ส่ง​ทูตสวรรค์​ของ​พระองค์​มา​จ้วย​จีวิต​เฮา หื้อ​รอด​ป๊น​จาก​อำนาจ​ของ​เฮโรด กับ​จาก​ก๋าน​คาดหมาย​ของ​จาว​ยิว” ");
INSERT INTO nod_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","เมื่อ​เปโตร​กึ๊ด​จาอี้​แล้ว ก็​ไป​ตี้​บ้าน​ของ​มารีย์​แม่​ของ​ยอห์น​ตี้​มี​แหม​จื้อ​ว่า​มาระโก ตี้​หั้น​มี​หลาย​คน​จุมนุม​อธิษฐาน​กั๋น​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","เปโตร​ก็​ไป​เคาะ​ปะตู๋​จั๊น​นอก​บ้าน มี​สาวใจ๊​คน​นึ่ง​จื้อ​โรดา​เตียว​มา​ผ่อ ");
INSERT INTO nod_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","เมื่อ​นาง​จ๋ำ​ว่า​เป๋น​เสียง​ของ​เปโตร ก็​ดีใจ๋​ขนาด​เถิง​กับ​ล่น​ปิ๊ก​เข้า​ไป​ใน​บ้าน​แตน​ตี้​จะ​ไข​ปะตู๋​หื้อ​เปโตร แล้ว​บอก​คน​ตังหลาย​ว่า “เปโตร​มา​ยืน​อยู่​ตี้​ปะตู๋​บ้าน” ");
INSERT INTO nod_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","คน​หมู่​นั้น​ก็​ปา​กั๋น​ว่า “เป๋น​บ้า​ไป​แล้ว​กา” แต่​นาง​ยืนยัน​ว่า​เป๋น​จาอั้น​แต๊﻿ๆ หมู่​เขา​จึง​ว่า “เป๋น​ทูตสวรรค์​ประจ๋ำ​ตั๋ว​เปโตร​แน่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ส่วน​เปโตร​ก็​ยัง​เคาะ​อยู่​ติก﻿ๆ เมื่อ​หมู่​เขา​ไข​ปะตู๋​แล้ว​หัน​เปโตร ก็​ปา​กั๋น​งืด​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","แต่​เปโตร​โบก​มือ​หื้อ​ดัก​ไว้​ก่อน แล้ว​ตั้งเก๊า​เล่า​หื้อ​หมู่​เขา​ฟัง​เถิง​เรื่อง​ตี้​องค์​พระผู้เป๋นเจ้า​จ้วย​เขา​ออก​มา​จาก​คอก​ได้​จาใด แล้ว​เปโตร​ก็​บอก​ว่า “ขอ​เอา​เรื่อง​นี้​ไป​เล่า​หื้อ​ยากอบ​กับ​หมู่​ปี้น้อง​ผู้เจื้อ​ฟัง​ตวย” หลังจาก​นั้น​เปโตร​ก็​ออก​จาก​บ้าน​ไป​ตัง​อื่น​เหีย ");
INSERT INTO nod_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","เถิง​แจ้งเจ๊า​มา หมู่​ทหาร​ก็​วุ่นวาย​บ่﻿ฮู้​ว่า​เกิด​อะหยัง​ขึ้น​กับ​เปโตร ");
INSERT INTO nod_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","กษัตริย์​เฮโรด​สั่ง​หื้อ​เซาะ​หา​เปโตร​แต่​บ่﻿ปะ จึง​สอบสวน​หมู่​ทหาร​ยาม แล้ว​สั่ง​หื้อ​ปา​หมู่​ทหาร​ยาม​ไป​ฆ่า​เหีย หลังจาก​นั้น​กษัตริย์​เฮโรด​ก็​เตียวตาง​ออก​จาก​แคว้น​ยูเดีย​ไป​ย้าง​อยู่​ตี้​เมือง​ซีซารียา​เวลา​นึ่ง ");
INSERT INTO nod_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","กษัตริย์​เฮโรด​โขด​หื้อ​จาว​เมือง​ไทระ​กับ​จาว​เมือง​ไซดอน​ขนาด สอง​เมือง​นั้น​จึง​ส่ง​หมู่​ตั๋วแตน​มา​หา​ต้าน ก่อน​มา​หา​ต้าน หมู่​เขา​ฮับ​ความ​จ้วยเหลือ​จาก​บลัสทัส​ตี้​เป๋น​ผู้จ้วย​ส่วน​ตั๋ว​ของ​กษัตริย์​เฮโรด แล้ว​ขอ​หื้อ​ปา​ไป​คืนดี​กับ​กษัตริย์​เฮโรด ย้อน​ต้อง​เปิ้งปา​อาหาร​จาก​ดินแดน​ของ​กษัตริย์​เฮโรด ");
INSERT INTO nod_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ใน​วัน​ตี้​กษัตริย์​เฮโรด​เลือก​ไว้​แล้ว​นั้น ต้าน​แต่ง​กษัตริย์​เต๋ม​ยศ ขึ้น​นั่ง​บน​บัลลังก์ แล้ว​อู้​ต่อ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","หมู่​คน​ก็​ปา​กั๋น​เอิ้น​เสียง​ดัง​ว่า “นี่​คือ​เทพเจ้า​อู้​แต๊﻿ๆ บ่﻿ใจ้​คน​อู้​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","สัก​กำเดียว​ก็​มี​ทูตสวรรค์​องค์​นึ่ง​ของ​องค์​พระผู้เป๋นเจ้า​เยียะ​หื้อ​เฮโรด​เป๋น​โรค​ฮ้าย ย้อน​ต้าน​ยอมฮับ​ก๋าน​ยกย่อง​นี้ กับ​หื้อ​เกียรติ​ตั๋ว​เก่า​แตน​หื้อ​เกียรติ​พระเจ้า แล้ว​กษัตริย์​เฮโรด​ก็​ถูก​ขี้ตืก​ขบ​กิ๋น​ตั๋ว​จ๋น​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","แต่​ถ้อยกำ​ของ​พระเจ้า​ก็​แพ่​ไป มี​คน​ฮับเจื้อ​นัก​ขึ้น​ไป​ติก﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","เมื่อ​บารนาบัส​กับ​เซาโล​เยียะ​ก๋าน​ตี้​ฮับ​มอบหมาย​เสร็จ​แล้ว คือ​เอา​สตางค์​มา​จ้วยเหลือ ก็​ปา​กั๋น​เตียวตาง​ออก​จาก​กรุง​เยรูซาเล็ม​ปิ๊ก​ไป​เมือง​อันทิโอก กับ​ปา​ยอห์น​ตี้​มี​แหม​จื้อ​ว่า​มาระโก​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ใน​คริสตจักร​ตี้​เมือง​อันทิโอก มี​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​กับ​หมู่​อาจ๋ารย์​คือ บารนาบัส สิเมโอน​ตี้​มี​แหม​จื้อ​นึ่ง​ว่า​นิเกอร์ ลูสิอัส​เป๋น​จาว​เมือง​ไซรีน มานาเอน (​คน​ตี้​ได้​ฮับ​ก๋าน​เลี้ยงดู​มา​ตวย​กั๋น​กับ​เฮโรด​เจ้าเมือง​ตั้ง​แต่​เป๋น​หละอ่อน​แล้ว​) กับ​เซาโล ");
INSERT INTO nod_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","เวลา​ตี้​หมู่​เขา​นมัสก๋าน​องค์​พระผู้เป๋นเจ้า​กับ​ถือ​ศีล​อด​อาหาร​อยู่​นั้น พระวิญญาณ​บริสุทธิ์​ก็​อู้​กับ​หมู่​เขา​ว่า “หื้อ​แต่งตั้ง​บารนาบัส​กับ​เซาโล​ไว้​สำหรับ​ก๋าน​งาน​ตี้​เฮา​ฮ้อง​หื้อ​หมู่​เขา​เยียะ” ");
INSERT INTO nod_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","หลังจาก​ปา​กั๋น​ถือ​ศีล​อด​อาหาร​กับ​อธิษฐาน​แล้ว ก็​วาง​มือ​บน​หัว​บารนาบัส​กับ​เซาโล เปื้อ​มอบหมาย​หื้อ​เยียะ​ก๋าน​พิเศษ จาก​นั้น​ก็​ส่ง​ต้าน​ตึง​สอง​ไป ");
INSERT INTO nod_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","พระวิญญาณ​บริสุทธิ์​ก็​นำ​ต้าน​ตึง​สอง​ไป​เมือง​เซลูเคีย แล้ว​หมู่​เขา​ก็​ลง​เฮือ​จาก​ตี้​หั้น​ไป​ตี้​เกาะ​ไซปรัส ");
INSERT INTO nod_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","เมื่อ​มา​แผว​เมือง​ซาลามิส​ใน​เกาะ​นั้น หมู่​เขา​บอก​เรื่อง​ถ้อยกำ​ของ​พระเจ้า​ใน​ธรรมศาลา​ของ​จาว​ยิว ยอห์น​ตี้​มี​แหม​จื้อ​ว่า​มาระโก​ก็​อยู่​ตวย​ใน​ฐานะ​ผู้จ้วย ");
INSERT INTO nod_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","หมู่​เขา​ปา​กั๋น​เตียวตาง​ใคว่​เกาะ​ไป​จ๋น​แผว​เมือง​ปาโฟส ตี้​หั้น​หมู่​เขา​ปะ​จาว​ยิว​คน​นึ่ง​จื้อ​บารเยซู เป๋น​คน​ใจ๊​เวทมนตร์​กาถา​กับ​อ้าง​ว่า​ตั๋ว​เก่า​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","เขา​อยู่​ตวย​เจ้าเมือง​จื้อ​เสอร์จีอัส เปาลุส เซิ่ง​เป๋น​คน​ฮู้​คน​หลวก เจ้าเมือง​เจิญ​บารนาบัส​กับ​เซาโล​มา​หา เปื้อ​หื้อ​อู้​ถ้อยกำ​ของ​พระเจ้า​หื้อ​ฟัง ");
INSERT INTO nod_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","แต่​เอลีมาส​นัก​เวทมนตร์ (​เอลีมาส​เป๋น​จื้อ​ภาษา​กรีก​ของ​บารเยซู​) ฮิ​อู้​ขัดขวาง​บารนาบัส​กับ​เซาโล กับ​ฮิ​จวน​เจ้าเมือง​บ่﻿หื้อ​เจื้อ ");
INSERT INTO nod_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","แต่​เซาโล​ตี้​ฮ้อง​แหม​จื้อ​ว่า​เปาโล ก็​ได้ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์ เขา​ปักต๋าผ่อ​ไป​ตี้​เอลีมาส​แล้ว​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“เจ้า​เป๋น​ลูก​ของ​มาร เป๋น​ศัตรู๋​ของ​ความ​ดี​ตังหลาย ใน​ตั๋ว​ของ​เจ้า​มี​แต่​กล​อุบาย​ใจ๋ฮ้าย​ซะป๊ะ​ซะเป้ด เจ้า​ตึง​จะ​บ่﻿หยุด​ตี้​จะ​ฮิ​เปี่ยน​ความ​จริง​เกี่ยวกับ​องค์​พระ​ผู้​เป๋น​เจ้า​หื้อ​เป๋น​เรื่อง​บ่﻿แต๊​สัก​เตื้อ​กา ");
INSERT INTO nod_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ผ่อ​เน่อ องค์​พระ​ผู้​เป๋น​เจ้า​จะ​ลงโต้ษ​เยียะ​หื้อ​เจ้า​ต๋าบอด​ผ่อ​บ่﻿หัน​แสงแดด จ๋น​เถิง​เวลา​ตี้​พระเจ้า​ก๋ำหนด​ไว้” แล้ว​เอลีมาส​ก็​ต๋าบอด​บ่า​เดี่ยว​นั้น​เลย เขา​จึง​ซวาม​หา​คน​หื้อ​จู๋ง​มือ​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","เมื่อ​ต้าน​เจ้าเมือง​หัน​เหตุก๋ารณ์​ตี้​เกิด​ขึ้น​นั้น​ก็​ฮับเจื้อ ย้อน​อัศจ๋รรย์​ใจ๋​ใน​กำสอน​เรื่อง​องค์​พระ​ผู้​เป๋น​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","เปาโล​กับ​หมู่​ของ​ต้าน​ลง​เฮือ​จาก​เมือง​ปาโฟส​ไป​เมือง​เปอร์กา​ใน​แคว้น​ปัมฟีเลีย แต่​ยอห์น​แยก​ตั๋ว​ออก​จาก​หมู่​เขา​ปิ๊ก​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","จาก​เมือง​เปอร์กา​ต้าน​หมู่​นั้น​ก็​ยัง​เตียวตาง​ต่อ​ไป​จ๋น​แผว​เมือง​อันทิโอก​ใน​แคว้น​ปิสิเดีย เมื่อ​เถิง​วัน​สะบาโต เปาโล​กับ​บารนาบัส​เข้า​ไป​นั่ง​ฮ่วม​ใน​ธรรมศาลา​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","หลังจาก​อ่าน​หนังสือ​บท​บัญญัติ​ของ​โมเสส​กับ​ข้อเขียน​ของ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ต๋าม​วาระ​ก๋าน​นมัสก๋าน​แล้ว หมู่​นาย​ธรรมศาลา​ส่ง​คน​มา​บอก​บารนาบัส​กับ​เปาโล​ว่า “ปี้น้อง​เหย ถ้า​ต้าน​มี​กำ​หื้อ​ก๋ำลังใจ๋​คน​ตังหลาย ขอ​เจิญ​ออก​มา​อู้​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","เปาโล​ก็​ยืน​ขึ้น​ยก​มือ​โบก​หื้อ​ดัก​แล้ว​อู้​ว่า “ฟัง​หื้อ​ดี​จาว​อิสราเอล​กับ​ต้าน​ตังหลาย​ตี้​เคารพ​ยำเก๋ง​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","พระเจ้า​ของ​จาว​อิสราเอล​เลือก​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา​ไว้ เยียะ​หื้อ​เขา​หมู่​นั้น​จ๋ำเริญ​เติบโต​ขึ้น​ต๋อน​อยู่​ใน​แผ่นดิน​อียิปต์ แล้ว​พระองค์​ก็​ปา​หมู่​เขา​ออก​มา​จาก​ประเทศ​นั้น​ด้วย​ฤทธิ์​อำนาจ​อัน​ยิ่งใหญ่​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","พระองค์​อดทน​ต่อ​ก๋าน​เยียะ​ตั๋ว​ของ​หมู่​เขา​ใน​ดินแดน​ทุรกั๋นดาร​เป๋น​เวลา​ประมาณ​สี่​สิบ​ปี๋ ");
INSERT INTO nod_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","พระเจ้า​ไล่เหิบ​คน​เจ็ด​จ้าด​ออก​ไป​จาก​แผ่นดิน​คานาอัน แล้ว​แบ่ง​แผ่นดิน​ของ​คน​จ้าด​หมู่​นั้น​หื้อ​จาว​อิสราเอล​ไว้​เป๋น​มรดก ");
INSERT INTO nod_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","เหตุ​หมู่​นี้​เกิด​มา​เป๋น​เวลา​ประมาณ​สี่​ร้อย​ห้า​สิบ​ปี๋ “หลังจาก​นั้น​พระเจ้า​ก็​หื้อ​หมู่​ผู้วินิจฉัย​ปกครอง​ผ่อกอย​หมู่​เขา จ๋น​มา​แผว​สมัย​ของ​ซามูเอล​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ต๋อน​นั้น​จาว​อิสราเอล​ขอ​หื้อ​มี​กษัตริย์ พระเจ้า​จึง​แต่งตั้ง​ซาอูล​ลูกบ่าว​ของ​คีช​ตี้​มา​จาก​เผ่า​เบนยามิน​หื้อ​เป๋น​กษัตริย์​ของ​หมู่​เขา ซาอูล​ครอบครอง​อยู่​สี่​สิบ​ปี๋ ");
INSERT INTO nod_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","หลังจาก​พระเจ้า​ถอด​ซาอูล​ออก​จาก​ต๋ำแหน่ง​กษัตริย์​แล้ว ก็​ตั้ง​ดาวิด​ขึ้น​เป๋น​กษัตริย์​ของ​จาว​อิสราเอล​แตน พระองค์​อู้​เถิง​ดาวิด​ว่า ‘เฮา​หัน​ว่า​ดาวิด​ลูกบ่าว​ของ​เจสซี​เป๋น​คน​ตี้​เฮา​เปิงใจ๋​ขนาด ย้อน​ว่า​เขา​เยียะ​กู้​สิ่ง​กู้​อย่าง​ตี้​เฮา​ใค่​หื้อ​เขา​เยียะ’ ");
INSERT INTO nod_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“แล้ว​จาก​เจื๊อสาย​ของ​กษัตริย์​ดาวิด​นี่​ละ พระเจ้า​โผด​หื้อ​จาว​อิสราเอล​ตังหลาย​มี​พระ​ผู้​จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ​เกิด​มา​คือ พระเยซู ต๋าม​ตี้​สัญญา​ไว้​แล้ว​นั้น ");
INSERT INTO nod_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","แต่​ก่อน​ตี้​พระเยซู​จะ​ตั้งเก๊า​เยียะ​ก๋าน​ของ​พระเจ้า ยอห์น​บอก​จาว​อิสราเอล​ตังหลาย​เถิง​เรื่อง​ก๋าน​ฮับ​บัพติศมา​ด้วย​น้ำ เปื้อ​แสดง​ว่า​กลับใจ๋​จาก​บาป​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","เมื่อ​ยอห์น​เยียะ​ก๋าน​ต๋าม​หน้าตี้​เกือบ​เสร็จ​ก็​ถาม​ว่า ‘หมู่​ต้าน​กึ๊ด​ว่า​ข้าพเจ้า​เป๋น​ใผ​กา ข้าพเจ้า​บ่﻿ใจ้​คน​ตี้​ต้าน​ตังหลาย​กองถ้า แต่​ผ่อ​เน่อ จะ​มี​แหม​คน​นึ่ง​มา​เมื่อลูน​ข้าพเจ้า เซิ่ง​ข้าพเจ้า​บ่﻿ควร​แม้แต่​จะ​แก้​เจื้อก​มัด​เกิบ​ของ​ต้าน’ ");
INSERT INTO nod_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ปี้น้อง​ตังหลาย​ตี้​เป๋น​ลูก​หลาน​ของ​อับราฮัม กับ​หมู่​ต้าน​ตี้​เป๋น​คน​ต่างจ้าด​ตี้​เคารพ​ยำเก๋ง​พระเจ้า หื้อ​ผ่อ​ไว้​เน่อ ถ้อยกำ​เรื่อง​ความ​รอด​ป๊น​บาป​โต้ษ​นี้ ได้​ส่ง​มา​เถิง​เฮา​ตังหลาย​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ส่วน​จาว​อิสราเอล​ตี้​อาศัย​อยู่​ใน​กรุง​เยรูซาเล็ม​กับ​ผู้​ปกครอง​บ้าน​เมือง บ่﻿หัน​ว่า​พระเยซู​เป๋น​พระ​ผู้​จ้วย​หื้อ​รอด​ป๊น​บาป​โต้ษ แต่​ตี้​หมู่​เขา​ตัดสิน​ลงโต้ษ​พระองค์​นั้น ก็​เป๋น​ไป​ต๋าม​กำ​ทำนาย​ของ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตี้​อ่าน​กู้​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ขนาด​ว่า​หมู่​เขา​หา​ความ​ผิด​บ่﻿ได้​ตี้​จะ​ฆ่า​พระองค์ แต่​หมู่​เขา​ก็​ยัง​ฮ้อง​ขอ​หื้อ​ปีลาต​ฆ่า​พระองค์​เหีย ");
INSERT INTO nod_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","เมื่อ​หมู่​เขา​เยียะ​สำเร็จ​ต๋าม​ตี้​พระคัมภีร์​เขียน​ไว้​เกี่ยวกับ​พระเยซู​แล้ว มี​คน​เอา​ศพ​ของ​พระองค์​ลง​มา​จาก​ไม้​ก๋าง​เขน แล้ว​เอา​ไป​วาง​ไว้​ใน​อุโมงค์​ฝัง​ศพ ");
INSERT INTO nod_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","แต่​พระเจ้า​เยียะ​หื้อ​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","พระเยซู​ป๋ากฏ​ตั๋ว​หื้อ​คน​ตี้​เกย​เตียวตาง​กับ​พระองค์​จาก​แคว้น​กาลิลี​ไป​กรุง​เยรูซาเล็ม​หัน​เป๋น​เวลา​หลาย​วัน ต๋อน​นี้​หมู่​เขา​เป๋น​พยาน​เล่า​เรื่อง​ของ​พระองค์​หื้อ​จาว​อิสราเอล​ตังหลาย​ฟัง ");
INSERT INTO nod_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“ตี้​เฮา​สอง​คน​มา​ตี้​นี่ ก็​เปื้อ​บอก​ข่าวดี​หื้อ​ต้าน​ตังหลาย​ฟัง คือ​พระสัญญา​ตี้​พระเจ้า​หื้อ​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา​ไว้ พระองค์​ก็​ตอบ​พระสัญญา​นี้​สำหรับ​หมู่​เฮา​ตี้​เป๋น​ลูก​หลาน​ของ​หมู่​เขา​ครบ​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","โดย​เยียะ​หื้อ​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย อย่าง​ตี้​เขียน​ไว้​ใน​หนังสือ​สดุดี​บท​ตี้​สอง​ว่า ‘เจ้า​เป๋น​ลูก​ของ​เฮา วัน​นี้​เฮา​ได้​เป๋น​ป้อ​ของ​เจ้า’ ");
INSERT INTO nod_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","พระเจ้า​เยียะ​หื้อ​พระเยซู​เป๋น​ขึ้น​จาก​ความ​ต๋าย​บ่﻿หื้อ​ตั๋ว​เน่า​นั้น เหมือน​ตี้​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘เฮา​จะ​หื้อ​ปอน​ตี้​แน่นอน​กับ​ศักดิ์สิทธิ์​แก่​ต้าน ตี้​สัญญา​ไว้​กับ​กษัตริย์​ดาวิด​นั้น’ ");
INSERT INTO nod_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ก็​มี​แหม​ข้อ​นึ่ง​ใน​พระคัมภีร์​ตี้​อู้​ว่า ‘พระองค์​จะ​บ่﻿หื้อ​องค์​บริสุทธิ์​ของ​พระองค์​เปื่อย​เน่า​ไป’ ");
INSERT INTO nod_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","กษัตริย์​ดาวิด​บ่﻿ได้​อู้​หมายเถิง​ตั๋วเก่า ย้อน​ต้าน​ฮับใจ๊​พระเจ้า​ต๋าม​ความ​ต้องก๋าน​ของ​พระองค์​ใน​เวลา​มี​จีวิต​อยู่ เมื่อ​ต๋าย​ไป​ศพ​ของ​ต้าน​ก็​ฝัง​ไว้​ใน​ตี้​ฝังศพ​ของ​ป้ออุ๊ย​แม่หม่อน แล้ว​ก็​เปื่อย​เน่า​ไป ");
INSERT INTO nod_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","แต่​พระเยซู​ผู้​ตี้​พระเจ้า​เยียะ​หื้อ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น​บ่﻿เปื่อย​เน่า​เลย ");
INSERT INTO nod_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“ย้อน​จาอั้น​ปี้น้อง​ตังหลาย​เหย โดย​สิ่ง​ตี้​พระเยซู​ได้​เยียะ ข้าพเจ้า​บอก​หื้อ​ฮู้​ว่า​มี​ก๋าน​ยกโต้ษ​บาป ");
INSERT INTO nod_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","โดย​พระเยซู กู้​คน​ตี้​เจื้อ​วางใจ๋​ใน​พระองค์​จะ​ป๊น​บาป​โต้ษ​กู้​อย่าง ตี้​คน​ถือ​บท​บัญญัติ​ของ​โมเสส​บ่﻿สามารถ​ป๊น​บาป​โต้ษ​ได้ ");
INSERT INTO nod_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","จง​หละวัง​หื้อ​ดี เปื้อ​กำ​ของ​หมู่​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​ตี้​อู้​ไว้​นั้น​จะ​บ่﻿เกิด​ขึ้น​กับ​หมู่​ต้าน คือ ");
INSERT INTO nod_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ผ่อ​เน่อ เจ้า​ตังหลาย​ตี้​ดูถูก​ดู​แควน​ถ้อยกำ​ของ​พระเจ้า หื้อ​เจ้า​ตังหลาย​งืด​ใน​ใจ๋​แล้ว​พินาศ​ฉิบหาย ย้อน​เฮา​จะ​เยียะ​สิ่ง​นึ่ง​ใน​สมัย​ของ​เจ้า​ตังหลาย เซิ่ง​เป๋น​สิ่ง​ตี้​เจ้า​จะ​บ่﻿เจื้อ แม้ว่า​มี​คน​มา​บอก​ก็​ต๋าม’ ” ");
INSERT INTO nod_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ต๋อน​ตี้​เปาโล​กับ​บารนาบัส​ก่ำลัง​เตียว​ออก​ไป​จาก​ธรรมศาลา​นั้น ก็​มี​คน​มา​อ้อนวอน​ขอ​หื้อ​ปิ๊ก​มา​อู้​เรื่อง​นี้​แหม​ใน​วัน​สะบาโต​ต่อ​ไป ");
INSERT INTO nod_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","หลังจาก​คน​ออก​จาก​ตี้​ประชุม​นั้น​แล้ว ก็​ปา​กั๋น​ปิ๊ก​บ้าน​ใผ​เฮือน​มัน แต่​มี​จาว​ยิว​หลาย​คน​ตึง​คน​ต่างจ้าด​หลาย คน​ตี้​เข้า​ฮีต​ศาสนา​ยิว​กับ​เคร่ง​ศาสนา​ตวย​เปาโล​กับ​บารนาบัส​ไป ต้าน​ตึง​สอง​จั๊กจวน​หื้อ​หมู่​เขา​เปิ้ง​พระคุณ​ของ​พระเจ้า​อย่าง​มั่นคง ");
INSERT INTO nod_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ใน​วัน​สะบาโต​ถัด​ไป คน​เกือบ​เสี้ยง​ตึง​เมือง​มา​จุมนุม​กั๋น​ฟัง​ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","เมื่อ​จาว​ยิว​หัน​หมู่​คน​ปา​กั๋น​มา​จ๋ำนวน​นัก ก็​ขอย​ขนาด จึง​อู้​คัดค้าน​กำ​ของ​เปาโล​อย่าง​หยาบคาย ");
INSERT INTO nod_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","แต่​เปาโล​กับ​บารนาบัส​อู้​อย่าง​บ่﻿กั๋ว​ใผ​ว่า “จ๋ำเป๋น​ตี้​จะ​ต้อง​อู้​เถิง​ถ้อยกำ​ของ​พระเจ้า​หื้อ​ต้าน​ตังหลาย​ฟัง​ก่อน แต่​เมื่อ​ต้าน​ตังหลาย​บ่﻿เอา กับ​หัน​ว่า​ตั๋ว​เอง​นี้​บ่﻿เหมาะ​บ่﻿เปิง​ตี้​จะ​ฮับ​จีวิต​นิรันดร์​แล้ว จาอั้น​หมู่​เฮา​จะ​ปา​กั๋น​ไป​หา​คน​ต่างจ้าด ");
INSERT INTO nod_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ย้อน​องค์​พระ​ผู้​เป๋น​เจ้า​สั่ง​หมู่​เฮา​ผ่าน​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​สมัย​ก่อน​ว่า ‘เฮา​แต่งตั้ง​หื้อ​เจ้า​เป๋น​แสง​สว่าง​กับ​คน​ต่างจ้าด เปื้อ​คน​ตึง​โลก​จะ​รอด​ป๊น​บาป​โต้ษ​ผ่าน​เจ้า’ ” ");
INSERT INTO nod_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","เมื่อ​คน​ต่างจ้าด​ได้ยิน​จาอั้น ก็​ดีอกดีใจ๋ กับ​สรรเสริญ​องค์​พระ​ผู้​เป๋น​เจ้า​สำหรับ​ถ้อยกำ​ของ​พระองค์ แล้ว​คน​ตี้​พระเจ้า​เลือก​ไว้​เปื้อ​จะ​ฮับ​จีวิต​นิรันดร์ ก็​ฮับเจื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​ก็​แผ่​ขยาย​ออก​ไป​ใคว่​ดินแดน​แถว​นั้น ");
INSERT INTO nod_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","แต่​หมู่​จาว​ยิว​ไป​สุ่ย​หมู่​แม่ญิง​คน​ต่างจ้าด​ตี้​มี​ฐานะ​ดี​กับ​นับถือ​พระเจ้า ตึง​หมู่​ป้อจาย​ตี้​เป๋นใหญ่​เป๋นโต​ใน​เมือง หื้อ​ปา​กั๋น​ค่ำเข​แล้ว​ไล่เหิบ​เปาโล​กับ​บารนาบัส​ออก​ไป​จาก​ดินแดน​ของ​หมู่​เขา​เหีย ");
INSERT INTO nod_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","แล้ว​เปาโล​กับ​บารนาบัส​ปา​กั๋น​ปัด​ขี้ฝุ่น​ตี้​ติด​ตี๋น​เป๋น​ก๋าน​บ่﻿ยอมฮับ​หมู่​เขา แล้ว​ปา​กั๋น​เตียวตาง​ไป​เมือง​อิโคนียูม ");
INSERT INTO nod_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ส่วน​หมู่​ผู้เจื้อ​ก็​ดีใจ๋​ขนาด​ตึง​ได้​ฮับ​ก๋าน​ดลใจ๋​จาก​พระวิญญาณ​บริสุทธิ์​ตวย ");
INSERT INTO nod_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ตี้​เมือง​อิโคนียูม​หั้น​ก็​เหมือน​กั๋น คือ​เปาโล​กับ​บารนาบัส​เข้า​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว หมู่​ต้าน​บอก​ข่าวดี​เก่ง​ขนาด​จ๋น​จาว​ยิว​กับ​คน​ต่างจ้าด​จ๋ำนวน​นัก​ฮับเจื้อ ");
INSERT INTO nod_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","แต่​หมู่​จาว​ยิว​ตี้​บ่﻿ยอม​ฮับเจื้อ​ปา​กั๋น​สุ่ย​คน​ต่างจ้าด​หื้อ​โขด​หมู่​ปี้น้อง​ผู้เจื้อ ");
INSERT INTO nod_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ส่วน​เปาโล​กับ​บารนาบัส​ก็​อยู่​ตี้​หั้น​เมิน​นักแก แล้ว​บอก​เรื่อง​องค์​พระ​ผู้​เป๋น​เจ้า​อย่าง​บ่﻿กั๋ว​ใผ พระองค์​พิสูจน์​ว่า​ถ้อยกำ​ตี้​หมู่​เขา​อู้​เกี่ยวกับ​พระคุณ​ของ​พระองค์​เป๋น​แต๊ โดย​โผด​หื้อ​หมู่​เขา​เยียะ​หมายสำคัญ​กับ​ก๋าน​ปาฏิหาริย์​ต่าง﻿ๆ ได้ ");
INSERT INTO nod_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","คน​ตังหลาย​ใน​เมือง​นั้น​แตก​ออก​เป๋น​สอง​หมู่ หมู่​นึ่ง​อยู่​ฝ่าย​จาว​ยิว แหม​หมู่​นึ่ง​อยู่​ฝ่าย​อัครทูต ");
INSERT INTO nod_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","คน​ต่างจ้าด​กับ​จาว​ยิว​บาง​คน​ฮ่วม​กับ​หมู่​ผู้​นำ​ของ​หมู่​เขา ปา​กั๋น​วาง​แผนก๋าน​จะ​เยียะ​ฮ้าย ตึง​จะ​เอา​บ่าหิน​ขว้าง​เปาโล​กับ​บารนาบัส​หื้อ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","แต่​ต้าน​ตึง​สอง​ฮู้​แผนก๋าน​นี้​เหีย​ก่อน จึง​หนี​ไป​ตี้​เมือง​ลิสตรา กับ​เมือง​เดอร์บี​ใน​แคว้น​ลิคาโอเนีย กับ​หมู่​บ้านนอก​ต๋าม​หมู่​เมือง​แวด​นั้น ");
INSERT INTO nod_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ตี้​หั้น​ต้าน​ตึง​สอง​ก็​ยัง​บอก​ข่าวดี​แหม ");
INSERT INTO nod_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ตี้​เมือง​ลิสตรา​มี​ป้อจาย​ตี๋น​บ่﻿ดี​คน​นึ่ง​นั่ง​อยู่ เขา​เตียว​บ่﻿ได้​มา​ตั้งแต่​เกิด​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ป้อจาย​คน​นี้​ก่ำลัง​นั่ง​ฟัง​เปาโล​อู้​อยู่ เปาโล​ก็​ปักต๋าผ่อ​มา​ตี้​เขา แล้ว​หัน​ว่า​เขา​มี​ความ​เจื้อ​ปอ​ตี้​จะ​ฮับ​ก๋าน​ฮักษา​หื้อ​หาย​ได้ ");
INSERT INTO nod_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","เปาโล​จึง​เอิ้น​เสียง​ดัง​ว่า “ลุก​ขึ้น​ยืน” แล้ว​ป้อจาย​คน​นั้น​ก็​ผะหลาด​ลุก​ขึ้น​ยืน​แล้ว​เตียว​ไป ");
INSERT INTO nod_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","เมื่อ​คน​ตังหลาย​หัน​สิ่ง​ตี้​เปาโล​ได้​เยียะ​แล้ว​นั้น หมู่​เขา​ก็​ปา​กั๋น​เอิ้น​เป๋น​ภาษา​ลิคาโอเนีย​ว่า “หมู่​เทพเจ้า​ได้​ตะแหลง​เป๋น​คน​ลง​มา​หา​หมู่​เฮา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","หมู่​เขา​จึง​ฮ้อง​บารนาบัส​ว่า​เทพเจ้า​ซุส แล้ว​ฮ้อง​เปาโล​ว่า​เทพเจ้า​เฮอร์เมส ย้อน​ว่า​เปาโล​เป๋น​คน​อู้ ");
INSERT INTO nod_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","มี​ศาล​เทพเจ้า​ซุส​อยู่​นอก​เมือง​บ่﻿ไก๋​เต้าใด ปุโรหิต​จู๋ง​งัว​ปู๊​หลาย​ตั๋ว​กับ​ติ้ว​ปวง​จ้อ​ดอกไม้​หลาย​ปวง​มา​ตี้​ปะตู๋​เมือง ย้อน​เขา​กับ​คน​ตังหลาย​ตั้งใจ๋​จะ​ถวาย​เครื่อง​ปู่จา​แก่​หมู่​อัครทูต ");
INSERT INTO nod_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","แต่​เมื่อ​บารนาบัส​กับ​เปาโล​ฮู้​ข่าว​จาอั้น ก็​สีก​เสื้อผ้า​ของ​ตั๋วเก่า แล้ว​ก็​ล่น​เข้า​ไป​ก๋าง​คน​หมู่​นั้น​ฮ้อง​เอิ้น​ว่า ");
INSERT INTO nod_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“กำ​เดียว​ก่อน ต้าน​ตังหลาย​ปา​กั๋น​เยียะ​จาอี้​เยียะ​หยัง หมู่​เฮา​ก็​เป๋น​คน​บ่ดาย​เหมือน​กั๋น หมู่​เฮา​มา​ตี้​นี่​เปื้อ​บอก​ข่าวดี​หื้อ​กับ​หมู่​ต้าน เปื้อ​ต้าน​ตังหลาย​จะ​ได้​บิ่นหลังต๋ำ​จาก​สิ่ง​หมู่​นี้​ตี้​บ่﻿มี​ก้า​บ่﻿มี​ประโยชน์ แล้ว​เข้า​มา​หา​พระเจ้า​ผู้​มี​จีวิต​อยู่ ตี้​สร้าง​ต๊องฟ้า แผ่นดิน​โลก ต๊อง​ทะเล กับ​ของ​ตึงหมด​ตี้​อยู่​ใน​ตี้​หมู่​นั้น ");
INSERT INTO nod_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ใน​อดีต​พระองค์​ยอม​หื้อ​คน​แต่​ละ​จ้าด​เยียะ​ต๋าม​ใจ๋​ตั๋วเก่า ");
INSERT INTO nod_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","แต่​โดย​สิ่ง​ดี﻿ๆ ตี้​เยียะ​ต่อ​คน พระองค์​ก็​หื้อ​หลักฐาน​มา​บ่﻿เกย​ขาด​ว่า​พระองค์​มี​อยู่ อย่าง​เจ้น พระองค์​โผด​หื้อ​มี​ฝน​ตก​จาก​ต๊องฟ้า มี​พืชผล​ต๋าม​หละดู พระองค์​เลี้ยงดู​หื้อ​ต้าน​ตังหลาย​กิ๋น​อิ่ม กับ​เยียะ​หื้อ​จื้นเจยบาน​ขนาด” ");
INSERT INTO nod_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","เถิงแม้​ว่า​อู้​จาอี้​แล้ว เปาโล​กับ​บารนาบัส​ยัง​ห้าม​บ่﻿หื้อ​คน​ตังหลาย​เอา​งัว​ถวาย​เป๋น​เครื่อง​ปู่จา​แก่​หมู่​เขา​เกือบ​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","แล้ว​มี​จาว​ยิว​บาง​คน​มา​จาก​เมือง​อันทิโอก​กับ​เมือง​อิโคนียูม​จั๊กจวน​คน​ตังหลาย​เข้า​ฮ่วม​กับ​หมู่​เขา แล้ว​ปา​กั๋น​เอา​บ่าหิน​ขว้าง​เปาโล เมื่อ​กึ๊ด​ว่า​เปาโล​ต๋าย​แล้ว ก็​ปา​กั๋น​ลาก​ออก​ไป​ไว้​นอก​เมือง ");
INSERT INTO nod_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","แต่​หลังจาก​หมู่​ผู้เจื้อ​ปา​กั๋น​มา​ยืน​แวด​เปาโล​ไว้ ต้าน​ก็​ลุก​ขึ้น​เตียว​เข้า​ไป​ใน​เมือง วัน​ต่อ​มา​เปาโล​กับ​บารนาบัส​ก็​เตียวตาง​ไป​ตี้​เมือง​เดอร์บี ");
INSERT INTO nod_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","เปาโล​กับ​บารนาบัส​บอก​ข่าวดี​ใน​เมือง​เดอร์บี​นั้น มี​คน​เข้า​มา​ฮับเจื้อ​จ๋ำนวน​นัก จาก​นั้น​ต้าน​ตึง​สอง​ปา​กั๋น​ปิ๊ก​ไป​เมือง​ลิสตรา เมือง​อิโคนียูม กับ​เมือง​อันทิโอก ");
INSERT INTO nod_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","เปื้อ​จ้วย​หื้อ​หมู่​ผู้เจื้อ​มี​ความ​เจื้อ​เข้มแข็ง​ขึ้น ตึง​หื้อ​ก๋ำลังใจ๋​ตี้​จะ​เจื้อ​มั่นคง​ต่อไป แล้ว​บอก​หื้อ​เขา​ตังหลาย​ฮู้​ว่า เฮา​ตังหลาย​จ๋ำเป๋น​ต้อง​ทน​ความ​ตุ๊กยาก​ลำบาก​ก่อน​ตี้​จะ​เข้า​ใน​แผ่นดิน​ของ​พระเจ้า​ได้ ");
INSERT INTO nod_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","เปาโล​กับ​บารนาบัส​แต่งตั้ง​ผู้ปกครอง​ใน​แต่​ละ​คริสตจักร ต้าน​ตึง​สอง​อธิษฐาน​กับ​ถือ​ศีล​อด​อาหาร แล้ว​มอบ​ผู้ปกครอง​หมู่​นั้น​ไว้​กับ​องค์​พระ​ผู้​เป๋น​เจ้า​ผู้​ตี้​หมู่​เขา​เจื้อ​วางใจ๋​นั้น ");
INSERT INTO nod_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","แล้ว​เปาโล​กับ​บารนาบัส​เตียวตาง​ผ่าน​แคว้น​ปิสิเดีย​ไป​แคว้น​ปัมฟีเลีย ");
INSERT INTO nod_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","หลังจาก​บอก​ข่าวดี​เรื่อง​พระเยซู​ใน​เมือง​เปอร์กา​แล้ว ก็​เตียวตาง​ลง​ไป​เมือง​อัททาลิยา ");
INSERT INTO nod_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ต้าน​ตึง​สอง​นั่ง​เฮือ​จาก​ตี้​นี่​ปิ๊ก​ไป​เมือง​อันทิโอก​ใน​แคว้น​ซีเรีย เซิ่ง​เป๋น​สถานตี้​ผู้เจื้อ​ได้​อธิษฐาน​มอบ​ต้าน​ตึง​สอง​ไว้​กับ​พระเจ้า​หื้อ​ผ่อกอย​ต๋าม​ความ​ดี​ของ​พระองค์ สำหรับ​งาน​ตี้​ได้​เยียะ​เสร็จ​แล้ว​บ่าเดี่ยวนี้ ");
INSERT INTO nod_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","เมื่อ​มา​แผว​แล้ว ต้าน​ตึง​สอง​ฮ้อง​หมู่​ผู้เจื้อ​มา​จุมนุม​กั๋น แล้ว​เล่า​เถิง​ก๋านงาน​ต่าง﻿ๆ ตี้​พระเจ้า​ได้​เยียะ​ฮ่วม​กับ​หมู่​เขา ตึง​เรื่อง​พระเจ้า​หื้อ​คน​ต่างจ้าด​มา​ฮับเจื้อ​ตวย ");
INSERT INTO nod_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ต้าน​ตึง​สอง​ก็​ย้าง​อยู่​กับ​หมู่​ผู้เจื้อ​ตี้​หั้น​เป๋น​เวลา​เมิน ");
INSERT INTO nod_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","มี​บาง​คน​เตียวตาง​ลง​มา​จาก​แคว้น​ยูเดีย แล้ว​สั่ง​สอน​หมู่​ปี้น้อง​ผู้เจื้อ​ตี้​เมือง​อันทิโอก​ว่า “ถ้า​บ่﻿ได้​เข้า​พิธี​สุหนัต​ต๋าม​บท​บัญญัติ​ของ​โมเสส ก็​จะ​รอด​ป๊น​บาป​โต้ษ​บ่﻿ได้” ");
INSERT INTO nod_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","กำสอน​จาอี้​เปาโล​กับ​บารนาบัส​บ่﻿หัน​ตวย​สัก​หน้อย จึง​เถียง​กั๋น​กับ​หมู่​ตี้​สอน​นั้น​อย่าง​หนัก หมู่​ผู้เจื้อ​จึง​แต่งตั้ง​เปาโล​ตึง​บารนาบัส​กับ​ผู้เจื้อ​บาง​คน​ใน​หมู่​เขา​หื้อ​ไป​กรุง​เยรูซาเล็ม เปื้อ​เปิ็กษา​หารือ​กับ​หมู่​อัครทูต​ตึง​หมู่​ผู้ปกครอง​เกี่ยวกับ​เรื่อง​นี้ ");
INSERT INTO nod_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","คริสตจักร​ก็​ส่ง​คน​หมู่​นี้​ออก​เตียวตาง​ไป เมื่อ​ผ่าน​แคว้น​ฟีนิเซีย​กับ​แคว้น​สะมาเรีย หมู่​ต้าน​ก็​เล่า​เรื่อง​ว่า​คน​ต่างจ้าด​เข้า​มา​ฮับเจื้อ​พระเจ้า หมู่​ปี้น้อง​ผู้เจื้อ​ตี้​หั้น​ฟัง​จาอั้น​ก็​ปา​กั๋น​ดีใจ๋​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","เมื่อ​เตียวตาง​มา​แผว​กรุง​เยรูซาเล็ม​แล้ว หมู่​อัครทูต​กับ​หมู่​ผู้ปกครอง​กับ​คน​ใน​คริสตจักร​ก็​ปา​กั๋น​มา​ต้อนฮับ แล้ว​หมู่​เขา​ตี้​เตียวตาง​มา​ก็​เล่า​เรื่อง​กู้​สิ่ง​ตี้​พระเจ้า​เยียะ​ผ่าน​ตาง​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","แต่​ผู้เจื้อ​บาง​คน​ตี้​เป๋น​สมาชิก​หมู่​ฟาริสี​ยืน​ขึ้น​อู้​ว่า “หมู่​คน​ต่างจ้าด​ตี้​ฮับเจื้อ​จ๋ำเป๋น​ต้อง​เข้า​พิธี​สุหนัต​กับ​ต้อง​ถือ​ต๋าม​บท​บัญญัติ​ของ​โมเสส​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ฝ่าย​หมู่​อัครทูต​กับ​หมู่​ผู้ปกครอง​ใน​คริสตจักร​จึง​จุมนุม​หารือ​กั๋น​เกี่ยวกับ​เรื่อง​นี้ ");
INSERT INTO nod_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","หลังจาก​เปิ็กษา​กั๋น​นัก​แล้ว เปโตร​ก็​ยืน​ขึ้น​อู้​ว่า “ปี้น้อง​ตังหลาย​เหย ต้าน​ก็​ฮู้​แล้ว​เถิง​เวลา​หัวที​นั้น​ตี้​พระเจ้า​เลือก​ข้าพเจ้า​จาก​ต้ามก๋าง​หมู่​ต้าน​หื้อ​ไป​บอก​ข่าวดี​หื้อ​คน​ต่างจ้าด​ฟัง เปื้อ​เขา​หมู่​นั้น​จะ​ได้​ฮับเจื้อ ");
INSERT INTO nod_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","พระเจ้า​ผู้​ฮู้​เถิง​จิตใจ๋​ของ​คน​ดี แสดง​หื้อ​หัน​ว่า​ยอมฮับ​คน​ต่างจ้าด โดย​หื้อ​พระวิญญาณ​บริสุทธิ์​กับ​หมู่​เขา​เหมือน​ตี้​หื้อ​กับ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","พระองค์​บ่﻿แบ่ง​หมู่​เขา​หมู่​เฮา แต่​จะ​ยกโต้ษ​บาป​หมู่​เขา​ย้อน​ความ​เจื้อ​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ถ้า​จาอั้น ลองดี​พระเจ้า​เยียะ​หยัง ย้อน​ว่า​ต้าน​ตังหลาย​เยียะ​หื้อ​ผู้เจื้อ​ต่างจ้าด​มี​ภาระ​เรื่อง​ก๋าน​ถือ​ต๋าม​บท​บัญญัติ​ของ​โมเสส เซิ่ง​ตั๋ว​หมู่​เฮา​ตึง​ป้ออุ๊ย​แม่หม่อน​ของ​เฮา​ก็​เยียะ​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","แต่​เฮา​ตังหลาย​เจื้อ​ว่า​โดย​พระคุณ​ของ​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า หมู่​เฮา​ได้​รอด​ป๊น​บาป​โต้ษ​เหมือน​กับ​หมู่​เขา” ");
INSERT INTO nod_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","คน​ตังหลาย​ปา​กั๋น​ดัก​ฟัง​บารนาบัส​กับ​เปาโล​เล่า​เรื่อง​หมายสำคัญ​ตึง​ก๋าน​ปาฏิหาริย์​ต่าง﻿ๆ ตี้​พระเจ้า​เยียะ​ผ่าน​ตาง​หมู่​เขา​ต้ามก๋าง​คน​ต่างจ้าด ");
INSERT INTO nod_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","เมื่อ​อู้​จบ​แล้ว​ยากอบ​ก็​อู้​ขึ้น​ว่า “ปี้น้อง​ตังหลาย​ฟัง​เฮา​กำ ");
INSERT INTO nod_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","เรื่อง​เมื่อ​ต๋อน​เก๊า​ตี้​พระเจ้า​ห่วงใย​คน​ต่างจ้าด​โดย​เลือก​คน​ใน​หมู่​เขา​หื้อ​เป๋น​คน​ของ​พระองค์ ซีโมน​ได้​บอก​เฮา​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","เรื่อง​นี้​ก็​เป๋น​อย่าง​กำ​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​เขียน​ไว้​ว่า ");
INSERT INTO nod_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘เมื่อลูน​เฮา​จะ​ปิ๊ก​มา แล้ว​อาณาจักร​ของ​กษัตริย์​ดาวิด​ตี้​ยุบ​ลง​ไป​แล้ว​นั้น เฮา​จะ​สร้าง​ขึ้น​ใหม่​กับ​ฟื้นฟู​หื้อ​เหมือน​เก่า ");
INSERT INTO nod_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","เปื้อ​คน​อื่น﻿ๆ จะ​เข้า​มา​หา​เฮา​องค์​พระ​ผู้​เป๋น​เจ้า คือ​คน​ต่างจ้าด​ตี้​เฮา​ฮ้อง​มา​เป๋น​คน​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","เรื่อง​เหตุก๋ารณ์​หมู่​นี้​เฮา​ได้​บอก​ตั้งแต่​โบราณ​มา​แล้ว’ ” ");
INSERT INTO nod_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ยากอบ​ก็​อู้​ต่อ​ไป​ว่า “ข้าพเจ้า​ก็​เลย​หัน​ว่า หมู่​เฮา​บ่﻿ควร​จะ​กีด​กั๋น​คน​ต่างจ้าด​ตี้​ก่ำลัง​เข้า​มา​หา​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","แต่​เฮา​ควร​จะ​เขียน​จดหมาย​ไป​บอก​หมู่​เขา​ว่า อย่าง​ตี้​นึ่ง ห้าม​กิ๋น​อาหาร​ตี้​เป๋น​มลทิน​ย้อน​ได้​เอา​ไป​ปู่จา​ฮูป​เคารพ​แล้ว อย่าง​ตี้​สอง ห้าม​เยียะ​บาป​ตาง​เพศ อย่าง​ตี้​สาม ห้าม​กิ๋น​จิ๊น​สัตว์​ตี้​ถูก​ฮัด​คอ​ต๋าย​ตี้​เลือด​ยัง​ค้าง​อยู่​ใน​ตั๋ว กับ​อย่าง​ตี้​สี่ ห้าม​กิ๋น​เลือด ");
INSERT INTO nod_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ย้อน​ว่า​ตั้งแต่​โบราณ​ใน​กู้​เมือง จาว​ยิว​ได้​บอก​บท​บัญญัติ​ของ​โมเสส กับ​อ่าน​บท​บัญญัติ​นี้​ใน​ธรรมศาลา​กู้​วัน​สะบาโต” ");
INSERT INTO nod_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","แล้ว​หมู่​อัครทูต หมู่​ผู้ปกครอง กับ​กู้​คน​ใน​คริสตจักร​ตี้​กรุง​เยรูซาเล็ม ปา​กั๋น​หัน​ตวย​ตี้​จะ​เลือก​ป้อจาย​บาง​คน​ใน​หมู่​เขา​หื้อ​เตียวตาง​ไป​เมือง​อันทิโอก​กับ​เปาโล​ตึง​บารนาบัส คน​ตี้​ฮับ​ก๋าน​เลือก​คือ​ยูดาส​ตี้​มี​แหม​จื้อ​ว่า​บารซับบาส​กับ​สิลาส ตึง​สอง​คน​นี้​เป๋น​ผู้​นำ​ของ​หมู่​ปี้น้อง​ผู้เจื้อ ");
INSERT INTO nod_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","แล้ว​ก็​ฝาก​จดหมาย​ไป​ตวย ใน​จดหมาย​เขียน​ว่า จาก​อัครทูต​ของ​พระเยซู​กับ​หมู่​ผู้ปกครอง​ผู้​เป๋น​ปี้น้อง​ของ​ต้าน​ตังหลาย ฝาก​กำ​สวัสดี​มา​เถิง​ปี้น้อง​ผู้เจื้อ​ตังหลาย​ตี้​เป๋น​คน​ต่างจ้าด ตี้​อยู่​ใน​เมือง​อันทิโอก แคว้น​ซีเรีย กับ​แคว้น​ซีลีเซีย ");
INSERT INTO nod_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","เนื่อง​จาก​หมู่​เฮา​ได้ยิน​มา​ว่า​มี​บาง​คน​ใน​หมู่​เฮา​อู้​หื้อ​ต้าน​ตังหลาย​บ่﻿ม่วนใจ๋ กับ​เยียะ​หื้อ​วุ่นวาย​ใจ๋ แต่​หมู่​เฮา​บ่﻿ได้​สั่ง​หื้อ​เขา​มา​บอก​จาอั้น ");
INSERT INTO nod_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","หมู่​เฮา​ตึงหมด​ตึงเสี้ยง​จึง​ตกลง​ใจ๋​ตี้​จะ​เลือก​บาง​คน เปื้อ​ส่ง​มา​หา​ต้าน​ตังหลาย​พร้อม​กับ​บารนาบัส​ตึง​เปาโล​ตี้​เฮา​ฮัก​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ตึง​สอง​คน​นี้​เป๋น​คน​ตี้​มอบ​จีวิต​ของ​เขา​เปื้อ​ฮับใจ๊​พระเยซู​คริสต์​องค์​พระ​ผู้​เป๋น​เจ้า​ของ​เฮา​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ย้อนจาอั้น​หมู่​เฮา​จึง​ใจ๊​ยูดาส​กับ​สิลาส​มา​หา เปื้อ​จะ​บอก​เรื่อง​อัน​เดียว​กั๋น​กับ​ข้อความ​ตี้​หมู่​เฮา​เขียน​ไว้​ใน​จดหมาย​นี้​หื้อ​ฟัง ");
INSERT INTO nod_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","คือ​ว่า​พระวิญญาณ​บริสุทธิ์​กับ​หมู่​เฮา​หัน​ดี​ตี้​จะ​บ่﻿หื้อ​ต้าน​ตังหลาย​หนัก​ใจ๋​ใน​ข้อ​นึ่ง​ข้อ​ใด เว้น​สิ่ง​จ๋ำเป๋น​ตี้​ต้อง​เยียะ​คือ ");
INSERT INTO nod_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","อย่าง​ตี้​นึ่ง ห้าม​กิ๋น​ของกิ๋น​ตี้​เกย​เอา​ไป​ปู่จา​ฮูป​เคารพ​แล้ว อย่าง​ตี้​สอง ห้าม​กิ๋น​เลือด อย่าง​ตี้​สาม ห้าม​กิ๋น​จิ๊น​สัตว์​ตี้​ถูก​ฮัด​คอ​ต๋าย​ตี้​เลือด​ยัง​ค้าง​อยู่​ใน​ตั๋ว อย่าง​ตี้​สี่ ห้าม​เยียะ​บาป​ตาง​เพศ ถ้า​ต้าน​ตังหลาย​ถือ​ข้อ​ห้าม​หมู่​นี้ ก็​นับ​ว่า​เยียะ​สิ่ง​ตี้​ถูกต้อง​แล้ว ขอ​หื้อ​มี​ความ​สุข​เน่อ ");
INSERT INTO nod_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","คริสตจักร​ก็​ส่ง​บารนาบัส เปาโล ยูดาส กับ​สิลาส​ออก​ไป แล้ว​ป้อจาย​สี่​คน​นี้​ก็​เตียวตาง​ไป​เมือง​อันทิโอก ตี้​หั้น​ต้าน​หมู่​นั้น​ฮ้อง​หมู่​ผู้เจื้อ​มา​จุมนุม​กั๋น แล้ว​เอา​จดหมาย​มอบ​หื้อ​กับ​คน​ตังหลาย​นั้น ");
INSERT INTO nod_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","เมื่อ​อ่าน​จดหมาย​นั้น​แล้ว ก็​ปา​กั๋น​จื้นอก​จื้นใจ๋​ใน​กำ​หื้อ​ก๋ำลังใจ๋​นั้น ");
INSERT INTO nod_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ส่วน​ยูดาส​กับ​สิลาส​ตี้​เป๋น​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ก็​อู้​หลาย​กำ​ตี้​หื้อ​ก๋ำลังใจ๋​หมู่​ปี้น้อง​ผู้เจื้อ กับ​เยียะ​หื้อ​มี​ความ​เจื้อ​เข้มแข็ง​ขึ้น ");
INSERT INTO nod_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","หลังจาก​ยูดาส​กับ​สิลาส​อยู่​ตี้​หั้น​บ่﻿ปอ​เมิน​สัก​เต้าใด หมู่​ผู้เจื้อ​ก็​ส่ง​สิลาส​กับ​ยูดาส​ปิ๊ก​เมือ​หา​หมู่​ผู้เจื้อ​ตี้​ใจ๊​เขา​มา ก่อน​จะ​ไป ปี้น้อง​ผู้เจื้อ​ตี้​เมือง​อันทิโอก​ก็​ปั๋น​ปอน​เขา​หื้อ​มี​ความ​สุข​กับ​ปลอดภัย​ใน​ก๋าน​เตียวตาง ");
INSERT INTO nod_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ส่วน​เปาโล​กับ​บารนาบัส​ก็​ยัง​อยู่​ใน​เมือง​อันทิโอก​ต่อ ต้าน​ตึง​สอง​บอก​ข่าวดี​กับ​สั่ง​สอน​ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​ฮ่วม​กับ​คน​อื่น﻿ๆ หลาย​คน ");
INSERT INTO nod_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","เมื่อ​เวลา​ผ่าน​ไป​ปอ​สมควร เปาโล​อู้​กับ​บารนาบัส​ว่า “เฮา​ปิ๊ก​ไป​แอ่ว​หา​หมู่​ปี้น้อง​ผู้เจื้อ​ต๋าม​เมือง​ตี้​เกย​บอก​ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​ดี​บ๋อ เปื้อ​ผ่อ​ว่า​ความ​เจื้อ​ของ​หมู่​เขา​เป๋น​จาใด​พ่อง” ");
INSERT INTO nod_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","บารนาบัส​ก็​หันตวย เขา​ใค่​ปา​ยอห์น​ตี้​มี​แหม​จื้อ​ว่า​มาระโก​ไป​ตวย ");
INSERT INTO nod_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","แต่​เปาโล​หัน​ว่า​บ่﻿เปิง​ตี้​จะ​ปา​เขา​ไป ย้อน​มาระโก​เกย​ละ​หมู่​เขา​ไป​ต๋อน​ตี้​อยู่​เมือง​ปัมฟีเลีย กับ​บ่﻿ได้​อยู่​ฮ่วม​งาน​กั๋น​ต่อไป ");
INSERT INTO nod_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","แล้ว​เปาโล​กับ​บารนาบัส​ก็​ผิดใจ๋​กั๋น​อย่าง​หนัก​เถิง​กับ​ต้อง​แยก​ตาง​กั๋น บารนาบัส​ปา​มาระโก​ลง​เฮือ​ไป​ตี้​เกาะ​ไซปรัส​ตวย​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ส่วน​เปาโล​เลือก​สิลาส​เป๋น​เปื้อน​ฮ่วม​เตียวตาง ก่อน​จาก​กั๋น หมู่​ปี้น้อง​ผู้เจื้อ​ก็​อธิษฐาน​มอบ​ต้าน​ตึง​สอง​ไว้​กับ​พระเจ้า​หื้อ​ผ่อกอย​ต๋าม​ความ​ดี​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","เปาโล​กับ​สิลาส​ไป​ใคว่​แคว้น​ซีเรีย​กับ​แคว้น​ซีลีเซีย เปื้อ​จ้วย​หื้อ​หมู่​ผู้เจื้อ​ใน​คริสตจักร​ต่าง﻿ๆ มี​ความ​เจื้อ​เข้มแข็ง​ขึ้น ");
INSERT INTO nod_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","เปาโล​ไป​เมือง​เดอร์บี​กับ​เมือง​ลิสตรา ตี้​หั้น​มี​สาวก​ของ​พระเยซู​คน​นึ่ง​จื้อ​ทิโมธี แม่​เป๋น​ผู้เจื้อ​จาว​ยิว​แต่​ป้อ​เป๋น​จาว​กรีก ");
INSERT INTO nod_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ทิโมธี​เป๋น​คน​มี​จื้อ​เสียง​ดี​ใน​หมู่​ปี้น้อง​ผู้เจื้อ​ใน​เมือง​ลิสตรา​กับ​เมือง​อิโคนียูม ");
INSERT INTO nod_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","เปาโล​ใค่​ปา​ทิโมธี​ฮ่วม​เตียวตาง​ไป​ตวย​กั๋น จึง​หื้อ​ทิโมธี​เข้า​พิธี​สุหนัต​ก่อน เปื้อ​เอาใจ๋​จาว​ยิว​ตังหลาย​ตี้​อยู่​ใน​เมือง​ต๋ำ​หมู่​นั้น​ตี้​หมู่​เขา​จะ​ไป ย้อน​คน​ตังหลาย​ฮู้​ว่า​ป้อ​ของ​ทิโมธี​เป๋น​จาว​กรีก ");
INSERT INTO nod_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","เมื่อ​ต้าน​หมู่​นั้น​เตียว​แอ่ว​ไป​ต๋าม​เมือง​ต่าง﻿ๆ นั้น ก็​อู้​เรื่อง​ข้อ​ตกลง​จาก​กรุง​เยรูซาเล็ม​ของ​หมู่​อัครทูต​กับ​หมู่​ผู้ปกครอง​หื้อ​ผู้เจื้อ​ตังหลาย​ใน​กู้​เมือง​ฟัง เปื้อ​จะ​ได้​เยียะ​ตวย​ต๋าม​นั้น ");
INSERT INTO nod_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","จึง​เยียะ​หื้อ​หมู่​คริสตจักร​ตังหลาย​มี​ความ​เจื้อ​เข้มแข็ง​ขึ้น กับ​มี​คน​เข้า​มา​ฮับเจื้อ​นัก​ขึ้น​ตึง​วัน﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","แล้ว​เปาโล​กับ​คน​ตี้​ไป​ตวย​กั๋น​ก็​เตียวตาง​ผ่าน​เขตแดน​แคว้น​ฟรีเจีย​กับ​แคว้น​กาลาเทีย ย้อน​ว่า​ใน​เวลา​นั้น​พระวิญญาณ​บริสุทธิ์​บ่﻿หื้อ​หมู่​ต้าน​ไป​บอก​ถ้อยกำ​ของ​พระเจ้า​ตี้​แคว้น​เอเชีย ");
INSERT INTO nod_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","เมื่อ​ต้าน​หมู่​นั้น​มา​แผว​เขตแดน​ของ​แคว้น​มิเซีย​แล้ว ก็​ฮิ​จะ​เข้า​ไป​ใน​แคว้น​บิธีเนีย แต่​พระวิญญาณ​ของ​พระเยซู​ยัง​บ่﻿หื้อ​เข้า​ไป​เตื้อ ");
INSERT INTO nod_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ต้าน​หมู่​นั้น​จึง​เตียวตาง​ผ่าน​แคว้น​มิเซีย​ไป​เมือง​โตรอัส​ฮิม​ทะเล​เหีย ");
INSERT INTO nod_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ต๋อน​เมื่อคืน​เปาโล​หัน​นิมิต​ว่า​มี​ป้อจาย​จาว​แคว้น​มาซิโดเนีย​คน​นึ่ง​มา​ยืน​อ้อนวอน​ว่า “ขอ​มา​จ้วย​หมู่​เฮา​จาว​แคว้น​มาซิโดเนีย​กำ​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","หลังจาก​เปาโล​หัน​นิมิต​แล้ว หมู่​เฮา​ตึงหมด​ก็​ตัดสินใจ๋​ไป​ตี้​แคว้น​มาซิโดเนีย​ตันที โดย​เข้าใจ๋​ว่า​พระเจ้า​ฮ้อง​หื้อ​หมู่​เฮา​ไป​บอก​ข่าวดี​กับ​จาว​มาซิโดเนีย​หั้น ");
INSERT INTO nod_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","จาก​เมือง​โตรอัส หมู่​เฮา​นั่ง​เฮือ​สะเปา​ลัด​ซื่อ​ไป​ตี้​เกาะ​สาโมธรัส วัน​ถัด​มา​ก็​ไป​เถิง​เมือง​เนอาบุรี ");
INSERT INTO nod_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","จาก​เมือง​เนอาบุรี​นั้น หมู่​เฮา​ก็​ไป​ตี้​เมือง​ฟีลิปปี เซิ่ง​เป๋น​เมือง​สำคัญ​ของ​แคว้น​มาซิโดเนีย กับ​เป๋น​เมือง​ขึ้น​ของ​โรม​ตวย หมู่​เฮา​อยู่​ใน​เมือง​นี้​หลาย​วัน ");
INSERT INTO nod_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","เมื่อ​เถิง​วัน​สะบาโต หมู่​เฮา​ออก​จาก​ปะตู๋​เมือง​ไป​ตี้​แม่น้ำ เฮา​กึ๊ด​กั๋น​ว่า​จะ​มี​จาว​ยิว​จุมนุม​กั๋น​อธิษฐาน​ใน​ตี้​นึ่ง​ตั๊ด​หั้น เมื่อ​ปะ​แล้ว​ก็​นั่ง​อู้​กับ​หมู่​แม่ญิง​ตี้​มา​จุมนุม​กั๋น​อยู่​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","มี​แม่ญิง​คน​นึ่ง​จื้อ​ลิเดีย​มา​จาก​เมือง​ธิยาทิรา เป๋น​คน​ขาย​ผ้า​สี​ม่วง​รากา​แปง เป๋น​คน​นับถือ​พระเจ้า เมื่อ​ก่ำลัง​ฟัง​หมู่​เฮา​อู้​อยู่​นั้น องค์​พระ​ผู้​เป๋น​เจ้า​ก็​เปิดใจ๋​ของ​นาง​หื้อ​สนใจ๋​ถ้อยกำ​ตี้​เปาโล​อู้​นั้น แล้ว​นาง​ก็​ฮับเจื้อ ");
INSERT INTO nod_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","เมื่อ​แม่ญิง​คน​นั้น​ตึง​สมาชิก​ใน​ครอบครัว​ของ​นาง​ฮับ​บัพติศมา​แล้ว นาง​ก็​จั๊กจวน​หมู่​เฮา​ว่า “ถ้า​หมู่​ต้าน​ตังหลาย​หัน​ว่า​ข้าเจ้า​มี​ความ​เจื้อ​ใน​องค์​พระ​ผู้​เป๋น​เจ้า​แต๊﻿ๆ แล้ว ก็​ขอ​เจิญ​ปา​กั๋น​มา​ย้าง​ตี้​บ้าน​ของ​ข้าเจ้า​เต๊อะ” นาง​จวน​แล้ว​จวน​แหม​จ๋น​หมู่​เฮา​ขัด​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","วัน​นึ่ง​เมื่อ​หมู่​เฮา​ก่ำลัง​จะ​ไป​ตี้​จุมนุม​อธิษฐาน มี​สาวใจ๊​คน​นึ่ง​มา​ปะ​หมู่​เฮา นาง​เป๋น​ขี้ข้า​เจ้านาย​หลาย​คน นาง​มี​ผีหมอเมื่อ​เข้า​อยู่ เยียะ​หื้อ​มี​ความ​สามารถ​ตวายตั๊ก​เรื่องราว​ปาย​หน้า​ได้ นาง​เซาะ​สตางค์​หื้อ​เจ้านาย​เป๋น​จ๋ำนวน​นัก ");
INSERT INTO nod_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","แม่ญิง​คน​นี้​เตียว​ตวย​ก้น​เปาโล​กับ​หมู่​เฮา​แล้ว​เอิ้น​ว่า “คน​หมู่​นี้​เป๋น​คน​ฮับใจ๊​ของ​พระเจ้า​ผู้​สูงสุด​เน่อ หมู่​เขา​มา​บอก​วิถีตาง​ตี้​จะ​รอด​ป๊น​บาป​โต้ษ​หื้อ​กับ​หมู่​ต้าน” ");
INSERT INTO nod_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","นาง​เยียะ​จาอี้​ติดต่อ​กั๋น​หลาย​วัน ก๋วนใจ๋​เปาโล​ขนาด​จ๋น​อด​บ่﻿ได้ เปาโล​จึง​งว้าย​ไป​สั่ง​ผี​ตี้​เข้า​นั้น​ว่า “ใน​นาม​ตึง​อำนาจ​ของ​พระเยซู​คริสต์​ข้า​สั่ง​หื้อ​ออก​จาก​ตั๋ว​นาง​บ่าเดี่ยว​นี้” แล้ว​ผี​ต๋น​นั้น​ก็​ออก​ไป​บ่า​เดี่ยว​นั้น​เลย ");
INSERT INTO nod_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","หมู่​เจ้านาย​ของ​แม่ญิง​คน​นั้น​หัน​ว่า​หมด​โอกาส​ตี้​จะ​ได้​สตางค์​แล้ว จึง​ยับ​เปาโล​กับ​สิลาส​ลาก​ไป​หา​ผู้​มี​อำนาจ​ตัดสิน​ตี้​ข่วง​ก๋าง​เมือง ");
INSERT INTO nod_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","เมื่อ​หมู่​เขา​ปา​มา​เถิง​หมู่​ผู้​พิพากษา​คดี​ทั่วไป​แล้ว ก็​อู้​ว่า “ไอ่ หมู่​นี้​เป๋น​จาว​ยิว​เข้า​มา​ก่อก๋วน​ใน​บ้าน​เมือง​ของ​เฮา ");
INSERT INTO nod_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","เขา​หมู่​นี้​มา​สั่ง​สอน​จั๊กจวน​หื้อ​เจื้อ​ถือ​ธรรมเนียม​ต่าง﻿ๆ ตี้​หมู่​เฮา​จาว​โรมัน​บ่﻿ยอมฮับ​กับ​เยียะ​ตึง​บ่﻿ได้ ย้อน​ผิด​กฎหมาย” ");
INSERT INTO nod_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","คน​ตังหลาย​ตี้​จุมนุม​ฟัง​กั๋น​ก็​หลุ้ม​เยียะ​หื้อ​เปาโล​กับ​สิลาส หมู่​ผู้​พิพากษา​คดี​ทั่วไป​ก็​ใจ๊​ทหาร​เข้า​มา​จั๊ก​เสื้อผ้า​ของ​เปาโล​กับ​สิลาส​ออก แล้ว​สั่ง​หื้อ​เอา​ไม้แส้​เฆี่ยน​หลัง ");
INSERT INTO nod_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","หลังจาก​ทหาร​เฆี่ยน​ไป​หลาย​กำ​แล้ว ก็​เอา​ตั๋ว​ไป​ขัง​ไว้​ใน​คอก หมู่​ผู้​พิพากษา​คดี​ทั่วไป​สั่ง​นาย​กุม​คอก​เฝ้า​ไว้​หื้อ​ดี ");
INSERT INTO nod_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","เมื่อ​นาย​กุม​คอก​ได้​ฮับ​กำสั่ง​แล้ว ก็​กุม​ตั๋ว​คน​ตึง​สอง​ไป​ขัง​ไว้​ตี้​ห้อง​ขัง​จั๊น​ใน แล้ว​ใส่​ขื่อคา​ตี้​แข้ง​อย่าง​แน่นหนา ");
INSERT INTO nod_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ประมาณ​เตี้ยงคืน​เปาโล​กับ​สิลาส​ก่ำลัง​ปา​กั๋น​อธิษฐาน​ฮ้อง​เพลง​สรรเสริญ​พระเจ้า​อยู่​นั้น นักโต้ษ​คน​อื่น﻿ๆ ก็​ฟัง​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","จู่﻿ๆ ก็​เกิด​แผ่นดินไหว​แฮง​ขนาด​จ๋น​ฐาน​ของ​คอก​สั่น​สนั่น​ปั่น​ปื๊น แล้ว​ปะตู๋​กู้​บาน​ก็​เปิด​ออก​หมด เจื้อก​เหล็ก​ตี้​ล่าม​นักโต้ษ​หลวะ​ออก​หมด​กู้​คน ");
INSERT INTO nod_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","นาย​กุม​คอก​ตื่น​ขึ้น​มา​ก็​หัน​ปะตู๋​คอก​ไข​ออก​หมด ก็​กึ๊ด​ว่า​นักโต้ษ​หนี​ออก​ไป​เสี้ยง​หมด​แล้ว เขา​กั๋ว​จะ​มี​โต้ษ​จึง​จั๊ก​ดาบ​ออก​มา​จะ​ฆ่า​ตั๋ว​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","แต่​เปาโล​เอิ้น​เสียง​ดัง​ว่า “ห้าม​เยียะ​เน่อ หมู่​เฮา​อยู่​นี่​กั๋น​หมด​ลู้” ");
INSERT INTO nod_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","นาย​กุม​คอก​ก็​เลย​บอก​หื้อ​คน​ต๋าม​ไฟ​ส่อง​ผ่อ แล้ว​ล่น​เข้า​ไป​หมอบ​ไหว้​ตี๋น​เปาโล​กับ​สิลาส ตั๋ว​เขา​สั่น​ถาบ﻿ๆ ย้อน​กั๋ว ");
INSERT INTO nod_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","แล้ว​ปา​ตึง​สอง​ออก​มา​จาก​คอก​ถาม​ว่า “ต้าน​ครับ ข้าพเจ้า​จะ​ต้อง​เยียะ​จาใด​เถิง​จะ​รอด​ป๊น​บาป​โต้ษ​ได้” ");
INSERT INTO nod_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","เปาโล​กับ​สิลาส​ก็​ตอบ​ว่า “หื้อ​เจื้อ​วางใจ๋​ใน​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า แล้ว​ต้าน​ก็​จะ​รอด​ป๊น​บาป​โต้ษ​ได้ ตึง​ครอบครัว​ของ​ต้าน​กู้​คน​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ต้าน​ตึง​สอง​ก็​สั่ง​สอน​ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​หื้อ​นาย​กุม​คอก​กับ​กู้​คน​ตี้​อยู่​ใน​บ้าน​ของ​เขา​ฟัง ");
INSERT INTO nod_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","แม้​ว่า​จะ​เป๋น​เมื่อคืน​แล้ว นาย​กุม​คอก​ก็​ยัง​ปา​เปาโล​กับ​สิลาส​ไป​ล้าง​แผล​ตี้​ถูก​เฆี่ยน แล้ว​เขา​กับ​สมาชิก​ใน​ครอบครัว​กู้​คน​ก็​ฮับ​บัพติศมา​พร้อม​กั๋น​หมด​ตันที ");
INSERT INTO nod_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","หลังจาก​นั้น​นาย​กุม​คอก​ก็​ปา​ต้าน​ตึง​สอง​ไป​บ้าน​ของ​เขา แล้ว​ยก​ขันโตก​ข้าว​มา​สู่​หมู่​เขา​กิ๋น นาย​กุม​คอก​กับ​สมาชิก​ใน​ครอบครัว​ยินดี​ขนาด ย้อน​ว่า​กู้​คน​ได้​เจื้อ​วางใจ๋​พระเจ้า​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","แจ้งเจ๊า​มา​หมู่​ผู้​พิพากษา​คดี​ทั่วไป​สั่ง​หมู่​เจ้าหน้าตี้​มา​บอก​นาย​กุม​คอก​ว่า “ปล่อย​ตั๋ว​สอง​คน​นั้น​ไป​เหีย​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","นาย​กุม​คอก​ก็​ไป​บอก​เปาโล​ว่า “หมู่​ผู้​พิพากษา​คดี​ทั่วไป​สั่ง​หื้อ​ปล่อย​ตั๋ว​ต้าน​ตึง​สอง ขอ​หื้อ​ไป​อยู่​ดี​มี​สุข​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","แต่​เปาโล​อู้​กับ​หมู่​เจ้าหน้าตี้​ว่า “หมู่​เขา​เอา​ไม้แส้​เฆี่ยน​หมู่​เฮา​ต่อ​หน้า​คน​ตังหลาย​แล้ว​เอา​ไป​ขัง​คอก​โดย​บ่﻿ยอม​สอบสวน​ก่อน แต่​หมู่​เฮา​เป๋น​คน​สัญจ้าด​โรมัน​เน่อ บ่าเดี่ยวนี้​จะ​มา​ไล่เหิบ​หมู่​เฮา​หื้อ​ลัก​มอบ​ออก​ไป​จาอั้น​กา เยียะ​จาอี้​บ่﻿ได้​เน่อ หื้อ​หมู่​เขา​นั้น​มา​ปา​หมู่​เฮา​ออก​ไป” ");
INSERT INTO nod_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","หมู่​เจ้าหน้าตี้​จึง​ไป​รายงาน​เรื่อง​นี้​ต่อ​หมู่​ผู้​พิพากษา​คดี​ทั่วไป เมื่อ​หมู่​เขา​ได้ยิน​ว่า​เปาโล​กับ​สิลาส​เป๋น​คน​จ้าด​โรมัน ก็​ปา​กั๋น​กั๋ว​กับ​ฮ้อนใจ๋ ");
INSERT INTO nod_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ก็​มา​ขอ​สูมาลาโต้ษ​ต้าน​ตึง​สอง แล้ว​ปา​ออก​มา​จาก​คอก กับ​ขอ​หื้อ​ต้าน​ตึง​สอง​ออก​จาก​เมือง​นี้​ไป​เหีย ");
INSERT INTO nod_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","เมื่อ​เปาโล​กับ​สิลาส​ออก​จาก​คอก​แล้ว ก็​ไป​บ้าน​ของ​นาง​ลิเดีย ตี้​หั้น​เปาโล​กับ​สิลาส​ก็​ปะ​หมู่​ปี้น้อง​ผู้เจื้อ แล้ว​อู้​กำ​ตี้​หื้อ​ก๋ำลังใจ๋​หมู่​นั้น แล้ว​ก็​ลา​จาก​กั๋น​ไป ");
INSERT INTO nod_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","เมื่อ​เปาโล​กับ​สิลาส​เตียวตาง​ผ่าน​เมือง​อัมฟีบุรี​กับ​เมือง​อปอลโลเนีย​แล้ว ต้าน​ตึง​สอง​ก็​มา​แผว​เมือง​เธสะโลนิก๋า ตี้​หั้น​มี​ธรรมศาลา​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ต๋าม​ปกติ​เปาโล​ก็​ไป​ธรรมศาลา​ใน​วัน​สะบาโต แล้ว​อ้าง​พระคัมภีร์​มา​โต้ตอบ​กับ​หมู่​เขา​รวม​เป๋น​เวลา​สาม​วัน​สะบาโต ");
INSERT INTO nod_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ต้าน​อธิบาย​พระคัมภีร์​กับ​พิสูจน์​หื้อ​หมู่​เขา​หัน​ว่า พระคริสต์​จ๋ำเป๋น​ต้อง​ทนตุ๊ก​จ๋น​ต๋าย แล้ว​เป๋น​ขึ้น​จาก​ความ​ต๋าย เปาโล​อู้​ว่า “พระเยซู​ตี้​ข้าพเจ้า​บอก​หื้อ​หมู่​ต้าน​ฟัง​นี้​ละ​คือ​พระคริสต์” ");
INSERT INTO nod_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","มี​จาว​ยิว​บาง​คน​ใน​หมู่​นั้น​ก็​ฮับเจื้อ จึง​เข้า​ฮ่วม​กับ​เปาโล​ตึง​สิลาส ก็​มี​จาว​กรีก​จ๋ำนวน​นัก​ตี้​นับถือ​พระเจ้า กับ​แม่ญิง​คน​สำคัญ​หลาย​คน​ก็​เข้า​ฮ่วม​ตวย ");
INSERT INTO nod_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","แต่​หมู่​จาว​ยิว​ขอย จึง​ไป​เข้า​กับ​หมู่​นักเลง​ต๋าม​กาด​จ๋ำนวน​นัก ปา​กั๋น​เยียะ​วุ่นวาย​ขึ้น​ตึง​เมือง หมู่​เขา​ปา​กั๋น​เข้า​ไป​ใน​บ้าน​ของ​ยาโสน แล้ว​ฮิ​เซาะ​หา​เปาโล​กับ​สิลาส เปื้อ​จะ​ลาก​คอ​หมู่​เขา​ออก​ไป​หื้อ​คน​ตังหลาย ");
INSERT INTO nod_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","แต่​เมื่อ​เซาะ​บ่﻿ปะ หมู่​เขา​ก็​ปา​กั๋น​ไป​ลาก​ตั๋ว​ยาโสน​กับ​ปี้น้อง​ผู้เจื้อ​บาง​คน​ออก​ไป​หา​เจ้าหน้าตี้​บ้านเมือง อู้​ใส่​ฮ้าย​ว่า “ไอ่ หมู่​นั้น​เป๋น​คน​เยียะ​หื้อ​วุ่นวาย​กู้​ตี้ บ่าเดี่ยวนี้​ก็​มา​ตี้​นี่​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ยาโสน​ต้อนฮับ​ไอ่​หมู่​นั้น​ไว้​ใน​บ้าน แล้ว​หมู่​เขา​ก็​เยียะ​ผิด​กฎ​ของ​ซีซาร์ หมู่​เขา​สอน​ว่า มี​กษัตริย์​แหม​องค์​นึ่ง​จื้อ​เยซู” ");
INSERT INTO nod_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","เมื่อ​จาว​เมือง​ตังหลาย​กับ​เจ้าหน้าตี้​บ้านเมือง​ได้ยิน​จาอั้น​ก็​ฮ้อนใจ๋ ");
INSERT INTO nod_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","จึง​สั่ง​ยาโสน​กับ​ผู้เจื้อ​คน​อื่น﻿ๆ จ่าย​ก้า​ประกั๋น​ตั๋ว แล้ว​ก็​ปล่อย​ตั๋ว​ไป ");
INSERT INTO nod_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","เมื่อ​ค่ำ​แล้ว หมู่​ปี้น้อง​ผู้เจื้อ​ก็​ส่ง​เปาโล​กับ​สิลาส​ไป​เมือง​เบโรอา เมื่อ​ต้าน​ตึง​สอง​คน​ไป​เถิง​ตี้​หั้น​แล้ว ก็​เข้า​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","จาว​ยิว​ตี้​นี่​มี​ใจ๋​ยอมฮับ​นัก​เหลือ​จาว​ยิว​ใน​เมือง​เธสะโลนิก๋า หมู่​เขา​ฮับ​ฟัง​กำสอน​ของ​เปาโล​อย่าง​สนใจ๋ แล้ว​ศึกษา​พระคัมภีร์​ตึง​วัน เปื้อ​ใค่​ฮู้​ว่า​สิ่ง​ตี้​เปาโล​สอน​นั้น​จะ​เป๋น​เรื่อง​แต๊​สัก​มอกใด ");
INSERT INTO nod_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ย้อนจาอี้​มี​จาว​ยิว​หลาย​คน​มา​ฮับเจื้อ ก็​มี​แม่ญิง​จาว​กรีก​ตี้​มี​ฐานะ​ดี​กับ​ป้อจาย​จาว​กรีก​หลาย​คน​ฮับเจื้อ​ตวย ");
INSERT INTO nod_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","แต่​เมื่อ​จาว​ยิว​ใน​เมือง​เธสะโลนิก๋า​ฮู้​ว่า​เปาโล​มา​สั่ง​สอน​ถ้อยกำ​ของ​พระเจ้า​ตี้​เมือง​เบโรอา ก็​ปา​กั๋น​มา​ตี้​หั้น แล้ว​สุ่ย​จาวบ้าน​จาว​เมือง​หื้อ​ต่อต้าน​เปาโล ");
INSERT INTO nod_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","หมู่​ปี้น้อง​ผู้เจื้อ​จึง​ส่ง​เปาโล​ออก​เตียวตาง​ไป​ตี้​ฮิม​ฝั่ง​ทะเล​ตันที แต่​สิลาส​กับ​ทิโมธี​ยัง​อยู่​ตี้​เมือง​เบโรอา​นั้น ");
INSERT INTO nod_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","หมู่​คน​ตี้​ปา​เปาโล​ไป​ส่ง​นั้น​ก็​ปา​ต้าน​ลง​เฮือ​ไป​แผว​เมือง​เอเธนส์ เปาโล​ฝาก​กำ​สั่ง​หื้อ​คน​หมู่​นั้น​ไป​บอก​สิลาส​กับ​ทิโมธี​ว่า หื้อ​ตึง​สอง​คน​ขะใจ๋​มา​ตวย​หา​เปาโล​เวย﻿ๆ เมื่อ​หมู่​เขา​ฮับ​กำ​แล้ว​ก็​ปา​กั๋น​ปิ๊ก​ไป​เมือง​เบโรอา ");
INSERT INTO nod_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ต๋อน​ตี้​เปาโล​ก่ำลัง​รอ​ถ้า​สิลาส​กับ​ทิโมธี​ใน​เมือง​เอเธนส์​หั้น ต้าน​ลำบาก​ใจ๋​ย้อน​หัน​ฮูป​เคารพ​เต๋ม​บ้าน​เต๋ม​เมือง​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ย้อนจาอั้น​ต้าน​จึง​ยก​เหตุผล​มา​ถกเถียง​กับ​จาว​ยิว​กับ​จาว​กรีก​ตี้​ยำเก๋ง​พระเจ้า​ใน​ธรรมศาลา​ของ​จาว​ยิว ตึง​คน​ตี้​อยู่​ใน​ข่วง​ก๋าง​เมือง​ตึง​วัน ");
INSERT INTO nod_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","มี​นัก​ปราชญ์​ใน​หมู่​ของ​เอปิคูเรียน​กับ​หมู่​สโตอิก​บาง​คน​มา​เถียง​กับ​เปาโล บาง​คน​ก็​อู้​ว่า “คน​เก็บ​ขี้ซาก​ความ​ฮู้​ตี้​บ่﻿มี​สาระ​จะ​เอา​อะหยัง​มา​อู้​หื้อ​เฮา​ฟัง” บาง​คน​ก็​อู้​ว่า “ฟัง​ผ่อ​เหมือน​ว่า​เขา​บอก​เถิง​เทพเจ้า​ต่าง​ประเทศ” หมู่​เขา​อู้​จาอี้​ก็​ย้อน​ว่า​เปาโล​ก่ำลัง​สอน​เรื่อง​พระเยซู​กับ​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","หมู่​เขา​จึง​ปา​เปาโล​ไป​ตี้​สภา​อาเรโอปากัส แล้ว​ถาม​ว่า “จ้วย​อธิบาย​กำสอน​ใหม่​ของ​ต้าน​หื้อ​หมู่​เฮา​ฮู้​น่อย​ว่า​เป๋น​จาใด ");
INSERT INTO nod_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ย้อน​ต้าน​เอา​เรื่อง​แปลก​มา​เล่า​หื้อ​ฟัง หมู่​เฮา​จึง​ใค่​ฮู้​ว่า​เรื่อง​นี้​มี​ความหมาย​ว่า​จาใด” ");
INSERT INTO nod_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(​จาว​เอเธนส์​กับ​คน​ต่างจ้าด​ตี้​อยู่​เมือง​เอเธนส์​นั้น​ซอบ​อู้​กับ​ฟัง​เรื่อง​ใหม่​ตลอด​) ");
INSERT INTO nod_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","เปาโล​ก็​ยืน​ขึ้น​อู้​ใน​สภา​อาเรโอปากัส​ว่า “จาว​เอเธนส์​ตังหลาย​เหย ข้าพเจ้า​แยง​ผ่อ​แล้ว​หัน​ว่า​หมู่​ต้าน​เป๋น​คน​เคร่ง​ศาสนา​ใน​กู้​ด้าน ");
INSERT INTO nod_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ย้อน​ต๋อน​ตี้​ข้าพเจ้า​มา​เถิง​เมือง​นี้ ก็​ผ่อ​หัน​สิ่ง​ตี้​หมู่​ต้าน​เคารพ​ปู่จา​หลาย​อย่าง​ต๋าม​ตาง แล้ว​ก็​ปะ​แต้น​ปู่จา​อัน​นึ่ง​เขียน​ว่า ‘แก่​เทพเจ้า​ตี้​บ่﻿ฮู้จัก’ เทพเจ้า​องค์​นี้​ละ​ตี้​ต้าน​ตังหลาย​บ่﻿ฮู้จัก​แต่​ก็​ยัง​นมัสก๋าน กำเดียว​ข้าพเจ้า​จะ​บอก​หื้อ​ฮู้ ");
INSERT INTO nod_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“เทพเจ้า​องค์​นี้​ละ​คือ​พระเจ้า​ผู้​ตี้​สร้าง​โลก​กับ​ซะป๊ะ​กู้​อย่าง​ใน​โลก​นี้ พระองค์​เป๋น​เจ้า​เหนือ​ต๊องฟ้า​กับ​แผ่นดิน​โลก จึง​บ่﻿ได้​อาศัย​อยู่​ใน​วิหาร​ตี้​แป๋ง​ขึ้น​จาก​มือ​คน ");
INSERT INTO nod_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","พระเจ้า​บ่﻿ต้อง​หื้อ​มนุษย์​มา​ฮับใจ๊​พระองค์​เหมือน​กับ​ว่า​พระองค์​ต้องก๋าน​อะหยัง ย้อน​ว่า​พระองค์​หื้อ​จีวิต​กับ​กู้​สิ่ง​กู้​อย่าง​แก่​มนุษย์ ");
INSERT INTO nod_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","จาก​มนุษย์​คน​นึ่ง พระองค์​สร้าง​มนุษย์​กู้​จ้าด​สืบ​สายเลือด​เดียว​กั๋น​หื้อ​ไป​อยู่​ใคว่​โลก​ต๋าม​เขตแดน​กับ​เวลา​ตี้​พระองค์​ก๋ำหนด​ไว้​ล่วงหน้า​สำหรับ​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","พระองค์​เยียะ​จาอี้​ก็​เปื้อ​จาว​โลก​จะ​เซาะ​หา​พระองค์ แล้ว​อาจ​จะ​ซวาม​หา​จ๋น​ปะ​พระองค์ แต่​แต๊﻿ๆ แล้ว พระองค์​บ่﻿ได้​อยู่​ไก๋​จาก​หมู่​เฮา​แต่​ละ​คน​เลย ");
INSERT INTO nod_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","อย่าง​มี​คน​เกย​อู้​ไว้​ว่า ‘ย้อน​พระองค์​เยียะ​หื้อ​หมู่​เฮา​มี​จีวิต ดิ้นต๊วง​ได้ กับ​เป๋น​อยู่’ แล้ว​ก็​มี​นัก​เขียน​ค่าว​ใน​หมู่​ต้าน​เกย​เขียน​ว่า ‘หมู่​เฮา​ตังหลาย​เป๋น​เจื๊อสาย​ของ​พระองค์’ ");
INSERT INTO nod_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“ย้อนจาอั้น​เมื่อ​หมู่​เฮา​เป๋น​เจื๊อสาย​ของ​พระเจ้า​แล้ว หมู่​เฮา​ก็​บ่﻿ดี​กึ๊ด​ว่า​พระองค์​เป๋น​เหมือน​ฮูป​เคารพ ตี้​คน​กึ๊ด​ออกแบบ​แป๋ง​มา​จาก​คำ จาก​เงิน กาว่า​จาก​บ่าหิน ");
INSERT INTO nod_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","สมัย​ตะก่อน​มนุษย์​บ่﻿ฮู้​เรื่อง​เกี่ยวกับ​พระเจ้า พระเจ้า​ก็​บ่﻿ถือ​โต้ษ​อะหยัง แต่​บ่าเดี่ยวนี้​พระองค์​สั่ง​หื้อ​มนุษย์​ตึงหมด​ใน​กู้​ตี้​กลับใจ๋​จาก​บาป ");
INSERT INTO nod_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ย้อน​พระองค์​ก๋ำหนด​วัน​นึ่ง​ไว้​แล้ว​เป๋น​วัน​ตี้​พระองค์​จะ​ตัดสิน​กู้​คน​ใน​โลก​นี้​อย่าง​ยุติธรรม โดย​ป้อจาย​คน​นึ่ง​ตี้​พระองค์​แต่งตั้ง​ไว้ พระองค์​ก็​พิสูจน์​เรื่อง​นี้​หื้อ​กู้​คน​ฮู้ โดย​หื้อ​คน​นั้น​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","เมื่อ​หมู่​เขา​ฟัง​เรื่อง​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย บาง​คน​ใค่หัว​ใส่ แต่​บาง​คน​ก็​อู้​ว่า “เฮา​ใค่​ฟัง​ต้าน​อู้​เกี่ยวกับ​เรื่อง​นี้​แหม” ");
INSERT INTO nod_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","จาก​นั้น​เปาโล​ก็​จาก​หมู่​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","แต่​มี​บาง​คน​เข้า​ฮ่วม​กับ​เปาโล​แล้ว​ฮับเจื้อ ใน​หมู่​คน​ตี้​ฮับเจื้อ​มี​คน​นึ่ง​จื้อ​ดิโอนิสิอัส เขา​เป๋น​สมาชิก​ของ​สภา​อาเรโอปากัส กับ​แม่ญิง​คน​นึ่ง​จื้อ​ดามาริส​รวม​กับ​คน​อื่น﻿ๆ ตวย ");
INSERT INTO nod_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","หลังจาก​นั้น เปาโล​ก็​ออก​จาก​เมือง​เอเธนส์​ไป​เมือง​โครินธ์ ");
INSERT INTO nod_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ตี้​หั้น​ต้าน​ได้​ฮู้จัก​จาว​ยิว​สอง​คน​จื้อ​อาควิลลา​กับ​เมีย​ของ​เขา​จื้อ​ปริสคา อาควิลลา​เป๋น​จาว​แคว้น​ปอนทัส ตึง​สอง​คน​ลุก​จาก​ประเทศ​อิตาลี​เมื่อ​บ่﻿เมิน​มา​นี่ ย้อน​จักรพรรดิ​คลาวดิอัส​สั่ง​หื้อ​จาว​ยิว​กู้​คน​ออก​ไป​จาก​กรุง​โรม เปาโล​ก็​ไป​หา​เขา​ตึง​สอง ");
INSERT INTO nod_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","แล้ว​อยู่​กับ​หมู่​เขา​กับ​เยียะ​ก๋าน​ตวย​กั๋น​ย้อน​ว่า​เปาโล​เป๋น​สล่า​แป๋ง​เต็นท์​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","กู้​วัน​สะบาโต​เปาโล​จะ​ไป​ยก​เหตุ​ผล​โต้เถียง​ใน​ธรรมศาลา​ของ​จาว​ยิว เปื้อ​จั๊กจวน​จาว​ยิว​กับ​จาว​กรีก​หื้อ​มา​เจื้อ​ใน​สิ่ง​ตี้​อู้​เกี่ยวกับ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","เมื่อ​สิลาส​กับ​ทิโมธี​เตียวตาง​จาก​แคว้น​มาซิโดเนีย​มา​เถิง​แล้ว เปาโล​ก็​ใจ๊​เวลา​เต๋มตี้​เตสนา​กับ​เป๋น​พยาน​ต่อ​จาว​ยิว​ว่า​พระคริสต์​นั้น​คือ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","แต่​เมื่อ​จาว​ยิว​หมู่​นั้น​ต่อต้าน​กับ​อู้​หยาบคาย​ต่อ​เปาโล ต้าน​ก็​ปัด​ขี้ฝุ่น​ออก​จาก​เสื้อผ้า​แสดง​หื้อ​หัน​ว่า​บ่﻿หัน​ตวย​หมู่​เขา แล้ว​บอก​ว่า “ถ้า​พระเจ้า​ลงโต้ษ​ต้าน​ตังหลาย ก็​ห้าม​ยู้​โต้ษ​ใส่​คน​อื่น​เน่อ ส่วน​ตั๋ว​ข้าพเจ้า​ก็​บ่﻿ต้อง​ฮับผิดชอบ​ต้าน​ตังหลาย​แหม​แล้ว ตั้งแต่​บ่าเดี่ยวนี้​เป๋น​ต้น​ไป​ข้าพเจ้า​จะ​ไป​หา​คน​ต่างจ้าด” ");
INSERT INTO nod_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","เปาโล​ก็​ออก​จาก​ธรรมศาลา แล้ว​เข้า​ไป​อยู่​ใน​บ้าน​ของ​ป้อจาย​คน​นึ่ง​จื้อ​ทิทิอัส ยุสทัส​ตี้​เป๋น​คน​ต่างจ้าด​แต่​นับถือ​พระเจ้า บ้าน​ของ​เขา​อยู่​แหมะ​กับ​ธรรมศาลา ");
INSERT INTO nod_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","คริสปัส​ตี้​เป๋น​นาย​ธรรมศาลา​กับ​สมาชิก​ใน​ครอบครัว​ของ​เขา​กู้​คน​ก็​ฮับเจื้อ​องค์​พระ​ผู้​เป๋น​เจ้า จาว​โครินธ์​หลาย​คน​ฟัง​เปาโล​อู้​ก็​ฮับเจื้อ​แล้ว​ฮับ​บัพติศมา ");
INSERT INTO nod_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","คืน​นึ่ง​องค์​พระ​ผู้​เป๋น​เจ้า​บอก​เปาโล​ตาง​นิมิต​ว่า “บ่﻿ถ้า​กั๋ว หื้อ​บอก​ข่าวดี​ต่อ​ไป​ติก﻿ๆ ห้าม​เลิก​เน่อ ");
INSERT INTO nod_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","เฮา​อยู่​กับ​เจ้า จะ​บ่﻿มี​ใผ​เข้า​มา​เยียะ​ฮ้าย​ต่อ​เจ้า ย้อน​ใน​เมือง​นี้​มี​คน​จ๋ำนวน​นัก​ตี้​เป๋น​คน​ของ​เฮา” ");
INSERT INTO nod_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","เปาโล​จึง​อยู่​ใน​เมือง​โครินธ์​สั่ง​สอน​ถ้อยกำ​ของ​พระเจ้า​เป๋น​เวลา​นึ่ง​ปี๋​เกิ่ง ");
INSERT INTO nod_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ต๋อน​ตี้​กัลลิโอ​เป๋น​เจ้าเมือง​แคว้น​อาคายา​นั้น จาว​ยิว​ปา​กั๋น​หลุ้ม​ใส่​เปาโล แล้ว​ก็​ปา​ไป​ตี้​ศาล ");
INSERT INTO nod_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","หมู่​เขา​ฟ้อง​กัลลิโอ​ว่า “ป้อจาย​คน​นี้​จั๊กจวน​หื้อ​คน​ไป​นมัสก๋าน​พระเจ้า​ใน​ตาง​ตี้​ผิด​กฎหมาย” ");
INSERT INTO nod_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","เมื่อ​เปาโล​ก่ำลัง​จะ​อู้​แก้​ข้อ​กล่าวหา กัลลิโอ​ก็​บอก​กับ​หมู่​จาว​ยิว​ว่า “ฟัง​ก่อน​จาว​ยิว​ตังหลาย ถ้า​เป๋น​เรื่อง​คดี​อาญา​บ่﻿ว่า​จะ​หนัก​จะ​เบา ก็​มี​เหตุผล​ปอ​ตี้​เฮา​จะ​อด​ฟัง​กำ​ฟ้อง​ของ​เจ้า​ตังหลาย​เน่อ ");
INSERT INTO nod_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","แต่​นี่​เป๋น​เรื่อง​โต้แย้ง​เกี่ยวกับ​กำ​ตี้​ใจ๊ จื้อ​ตี้​ฮ้อง ตึง​บท​บัญญัติ​ของ​หมู่​ต้าน หื้อ​ไป​จัดก๋าน​เอา​คน​เดียว​ก็​แล้ว​กั๋น เฮา​บ่﻿ตัดสิน​เรื่อง​จาอี้” ");
INSERT INTO nod_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","แล้ว​กัลลิโอ​ก็​ไล่​คน​ตึงหมด​หื้อ​ออก​ไป​จาก​ศาล ");
INSERT INTO nod_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","คน​ตังหลาย​จึง​ไป​ยับ​โสสเธเนส​ตี้​เป๋น​นาย​ธรรมศาลา​มา​บุบ​ตี๋​ต่อ​หน้า​ศาล แต่​กัลลิโอ​ก็​บ่﻿สนใจ๋​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","เปาโล​ก็​อยู่​ตี้​เมือง​โครินธ์​ต่อ​แหม​เวลา​นึ่ง แล้ว​ลา​หมู่​ปี้น้อง​ผู้เจื้อ​ไป​เมือง​เคนเครีย​อยู่​ใก้​กั๋น​หั้น แต่​ก่อน​ตี้​เปาโล​จะ​ลง​เฮือ​ตี้​ต้า​เฮือ​เมือง​นั้น ต้าน​โก๋น​หัว​ของ​ตั๋วเก่า ย้อน​ว่า​เกย​บน​ตั๋ว​ไว้​กับ​พระเจ้า แล้ว​ไป​แคว้น​ซีเรีย​ฮ่วม​กับ​ปริสคา​กับ​อาควิลลา ");
INSERT INTO nod_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","เมื่อ​ปา​กั๋น​มา​แผว​เมือง​เอเฟซัส เปาโล​ก็​ปล่อย​ปริสคา​กับ​อาควิลลา​ไว้​ตี้​หั้น แล้ว​เข้า​ไป​ใน​ธรรมศาลา​ของ​จาว​ยิว​ยก​เหตุผล​มา​โต้เถียง​กับ​หมู่​จาว​ยิว​ใน​หั้น ");
INSERT INTO nod_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","แล้ว​หมู่​เขา​ขอ​หื้อ​ต้าน​อยู่​ต่อ​ไป​แหม แต่​เปาโล​บ่﻿ยอม​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","แต่​ก่อน​ตี้​เปาโล​จะ​ลา​หมู่​เขา​ไป ต้าน​บอก​ว่า “ถ้า​เป๋น​ความ​ต้องก๋าน​ของ​พระเจ้า ข้าพเจ้า​จะ​ปิ๊ก​มา​หา​ต้าน​ตังหลาย​แหม” แล้ว​เปาโล​ก็​ลง​เฮือ​ออก​จาก​เมือง​เอเฟซัส ");
INSERT INTO nod_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","เมื่อ​เฮือ​มา​แผว​ฝั่ง​เมือง​ซีซารียา​แล้ว เปาโล​ขึ้น​ไป​แอ่ว​หา​คริสตจักร​ตี้​กรุง​เยรูซาเล็ม แล้ว​ก็​ลวด​ไป​เมือง​อันทิโอก ");
INSERT INTO nod_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","หลังจาก​อยู่​ตี้​เมือง​อันทิโอก​ได้​หว่าง​นึ่ง เปาโล​ก็​เตียวตาง​ไป​ใคว่​แคว้น​กาลาเทีย​กับ​แคว้น​ฟรีเจีย เปื้อ​เยี่ยม​ผู้เจื้อ​ตังหลาย​กับ​จ้วย​หื้อ​มี​ความ​เจื้อ​เข้มแข็ง​ขึ้น ");
INSERT INTO nod_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","มี​ป้อจาย​จาว​ยิว​คน​นึ่ง​จื้อ​อปอลโล​มา​เมือง​เอเฟซัส เขา​เกิด​ตี้​เมือง​อเล็กซานเดรีย เป๋น​คน​ตี้​อู้​เก่ง​กับ​มี​ความ​ฮู้​พระคัมภีร์​เป๋น​อย่าง​ดี ");
INSERT INTO nod_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","อปอลโล​คน​นี้​ฮับ​ก๋าน​อบรม​จ๋น​ฮู้​เถิง​วิถีตาง​ของ​องค์​พระ​ผู้​เป๋น​เจ้า เขา​สั่ง​สอน​เรื่อง​ของ​พระเยซู​อย่าง​กระตือรือร้น​ถูกต้อง​แม่นยำ แต่​เขา​ฮู้​ก้า​เรื่อง​บัพติศมา​ตี้​ยอห์น​สั่ง​สอน​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","อปอลโล​อู้​เรื่อง​ของ​พระเยซู​อย่าง​บ่﻿กั๋ว​ใผ​ใน​ธรรมศาลา​ของ​จาว​ยิว เมื่อ​ปริสคา​กับ​อาควิลลา​ได้ยิน​เขา​อู้ ก็​ปา​อปอลโล​มา​ตี้​บ้าน​ของ​หมู่​เขา แล้ว​อธิบาย​วิถีตาง​ของ​พระเจ้า​หื้อ​เข้าใจ๋​นัก​ขึ้น ");
INSERT INTO nod_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","เมื่อ​อปอลโล​ใค่​ไป​ตี้​แคว้น​อาคายา หมู่​ปี้น้อง​ผู้เจื้อ​ก็​หื้อ​ก๋ำลังใจ๋​เขา​กับ​เขียน​จดหมาย​ไป​เถิง​ผู้เจื้อ​ตี้​หั้น​ว่า​ขอ​หื้อ​ต้อนฮับ​เขา​ตวย เมื่อ​อปอลโล​ไป​แผว​แคว้น​อาคายา​แล้ว ก็​จ้วยเหลือ​คน​หมู่​นั้น​ตี้​ฮับเจื้อ​โดย​พระคุณ​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ย้อน​อปอลโล​โต้แย้ง​หมู่​จาว​ยิว​อย่าง​หนักแน่น​ต่อ​หน้า​คน​ใน​ตี้​สาธารณะ โดย​ยก​ข้อ​พระคัมภีร์​พิสูจน์​ว่า​พระเยซู​คือ​พระคริสต์ หมู่​จาว​ยิว​ก็​เถียง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ใน​เวลา​ตี้​อปอลโล​อยู่​ใน​เมือง​โครินธ์​นั้น เปาโล​ก็​เตียวตาง​ต๋าม​เส้นตาง​ตัง​เหนือ​ใน​แคว้น​กาลาเทีย​กับ​แคว้น​ฟรีเจีย​จ๋น​มา​แผว​เมือง​เอเฟซัส ตี้​หั้น​ปะ​กับ​ผู้เจื้อ​บาง​คน ");
INSERT INTO nod_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","เปาโล​ถาม​เขา​ว่า “หลังจาก​ฮับเจื้อ​พระเยซู​แล้ว​นั้น หมู่​ต้าน​ได้​ฮับ​พระวิญญาณ​บริสุทธิ์​กั๋น​ก่อ” เขา​ตอบ​ว่า “อึ หมู่​เฮา​บ่﻿เกย​ได้ยิน​เรื่อง​พระวิญญาณ​บริสุทธิ์​สัก​เตื้อ” ");
INSERT INTO nod_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","เปาโล​ถาม​ต่อ​ว่า “ถ้า​จาอั้น​ต้าน​ฮับ​บัพติศมา​มี​ความหมาย​อะหยัง” หมู่​เขา​ก็​ตอบ​ว่า “ความหมาย​ตี้​ยอห์น​สอน” ");
INSERT INTO nod_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","เปาโล​จึง​บอก​ว่า “บัพติศมา​ตี้​ยอห์น​สอน​นั้น​แสดง​ว่า​กลับใจ๋​จาก​บาป​แล้ว​เต้าอั้น ยอห์น​บอก​คน​ตังหลาย​ว่า​หื้อ​เจื้อ​พระองค์​ตี้​จะ​มา​เมื่อลูน​คือ​พระเยซู” ");
INSERT INTO nod_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","เมื่อ​หมู่​เขา​ได้ยิน​จาอั้น ก็​ปา​กั๋น​ฮับ​บัพติศมา​ใน​นาม​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​เปื้อ​แสดง​ว่า​เจื้อ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","หลังจาก​เปาโล​วาง​มือ​บน​หัว​หมู่​เขา​แล้ว พระวิญญาณ​บริสุทธิ์​ก็​มา​อยู่​ตวย​หมู่​เขา เขา​ตังหลาย​ก็​ปา​กั๋น​อู้​ภาษา​อื่น﻿ๆ กับ​บอก​ถ้อยกำ​ของ​พระเจ้า​ตวย ");
INSERT INTO nod_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","คน​หมู่​นี้​มี​ป้อจาย​ประมาณ​สิบ​สอง​คน ");
INSERT INTO nod_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","เปาโล​ไป​อู้​ใน​ธรรมศาลา​ของ​จาว​ยิว​อย่าง​บ่﻿กั๋ว​ใผ​เป๋น​เวลา​สาม​เดือน เขา​ยก​เหตุ​ผล​โต้เถียง​จั๊กจวน​จาว​ยิว​หื้อ​เจื้อ​เรื่อง​แผ่นดิน​ของ​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","แต่​มี​บาง​คน​หลึ่ง​บ่﻿ยอม​เจื้อ แล้ว​อู้จ๋า​หยาบจ๊า​ต่อ​ลัทธิ​นั้น​ตี้​ฮ้อง​ว่า ตาง​ของ​พระเยซู ต่อ​หน้า​คน​ตังหลาย ย้อน​จาอั้น​เปาโล​จึง​ปา​หมู่​ผู้เจื้อ​แยก​ไป​อู้จ๋า​โต้ตอบ​กั๋น​ตึง​วัน​ตี้​ห้อง​ประชุม​ของ​ทีรันนัส ");
INSERT INTO nod_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","เปาโล​เยียะ​จาอี้​อยู่​สอง​ปี๋ เยียะ​หื้อ​กู้​คน​ตี้​อาศัย​อยู่​ใน​แคว้น​เอเชีย​ตึง​จาว​ยิว​กับ​จาว​กรีก​ได้ยิน​ได้​ฟัง​ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า ");
INSERT INTO nod_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","พระเจ้า​เยียะ​ก๋าน​อัศจ๋รรย์​อัน​พิเศษ​เหลือ​ปกติ​ผ่าน​ตาง​เปาโล ");
INSERT INTO nod_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","แม้​แต่​ผ้า​เจ๊ด​หน้า​กับ​ผ้า​กั๋น​เปื้อน​ตี้​ถูก​ตั๋ว​เปาโล เมื่อ​เอา​ไป​วาง​บน​ตั๋ว​คน​บ่﻿สบาย โรค​ก็​หาย กับ​ผี​ฮ้าย​ก็​ออก​ตวย ");
INSERT INTO nod_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","มี​จาว​ยิว​บาง​คน​ไป​เป๋น​หมอผี ฮิ​อ้าง​จื้อ​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​ใน​ก๋าน​ไล่​ผี​ว่า “ใน​นาม​พระเยซู​ตี้​เปาโล​เตสนา​สั่ง​สอน​นั้น เฮา​สั่ง​หื้อ​เจ้า​ออก​มา​จาก​คน​นี้​เหีย” ");
INSERT INTO nod_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ลูกบ่าว​เจ็ด​คน​ของ​เสวา​หัวหน้า​ปุโรหิต​ของ​จาว​ยิว​ก็​เยียะ​จาอี้​เหมือน​กั๋น​กู้​คน ");
INSERT INTO nod_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","แต่​มี​วัน​นึ่ง หมู่​เขา​สั่ง​ผี​ฮ้าย​ออก​จาก​ป้อจาย​คน​นึ่ง แต่​ผี​ฮ้าย​ก็​ตอบ​หมู่​เขา​ว่า “ข้า​ก็​ฮู้จัก​พระเยซู เปาโล​ข้า​ก็​ฮู้จัก แต่​หมู่​สู​เป๋น​ใผ​กา” ");
INSERT INTO nod_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","แล้ว​คน​ตี้​ถูก​ผี​เข้า​อยู่​นั้น​ก็​ต๋างหยาง​ใส่​หมู่​เขา แล้ว​เยียะ​หื้อ​หมู่​เขา​จ๋น​เสื้อผ้า​หลวะ​หมด เขา​ตึงหมด​นั้น​ก็​ปา​กั๋น​ล่น​หนี​ออก​จาก​เฮือน​ป๋วย​ตั๋ว​โจ๊ะโละ ต๋าม​เนื้อ​ต๋าม​ตั๋ว​มี​แผล​เลือด​ไหล​หลาย​ตี้ ");
INSERT INTO nod_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","คน​ตี้​อยู่​ใน​เมือง​เอเฟซัส​ตึง​จาว​ยิว​กับ​จาว​กรีก​ฮู้​เรื่อง​นี้​กั๋น​เสี้ยง​หมด เยียะ​หื้อ​กู้​คน​กั๋ว​กับ​ปา​กั๋น​ยกย่อง​จื้อ​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​อย่าง​ยิ่ง ");
INSERT INTO nod_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","มี​หลาย​คน​ตี้​ฮับเจื้อ​พระเยซู แล้ว​มา​ยอมฮับ​ว่า​เกย​ใจ๊​กาถา​เยียะ​ใน​ตาง​ตี้​บ่﻿ดี​เหมือน​กั๋น ");
INSERT INTO nod_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","หลาย​คน​ตี้​ใจ๊​เวทมนตร์​กาถา​เอา​หนังสือ​ตี้​เป๋น​ต๋ำฮา​เวทมนตร์​กาถา​มา​เผา​ไฟ​ต่อ​หน้า​คน​ตังหลาย ต๋ำฮา​นั้น​มี​ก้า​นัก นับ​ได้​เถิง​ห้า​หมื่น​เหรียญ​เงิน ");
INSERT INTO nod_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","เหตุก๋ารณ์​หมู่​นี้​เยียะ​หื้อ​ถ้อยกำ​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​แพ่​ขยาย​ออก​ไป​อย่าง​มี​ฤทธิ์​อำนาจ กับ​เกิด​ผล​มี​คน​ฮับเจื้อ​นัก​ขึ้น​ติก﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","หลังจาก​เรื่อง​ตี้​เกิด​ขึ้น​หมู่​นี้​เสี้ยง​สุด​ลง​แล้ว เปาโล​ก็​ตัดสินใจ๋​จะ​เตียวตาง​ผ่าน​แคว้น​มาซิโดเนีย​กับ​แคว้น​อาคายา แล้ว​จะ​ลวด​ไป​กรุง​เยรูซาเล็ม ต้าน​อู้​ว่า “หลังจาก​ข้าพเจ้า​ไป​กรุง​เยรูซาเล็ม​แล้ว จะ​ต้อง​ไป​กรุง​โรม​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","เปาโล​ก็​ส่ง​ผู้จ้วย​ตึง​สอง​ของ​ต้าน​คือ​ทิโมธี​กับ​เอรัสทัส​ไป​แคว้น​มาซิโดเนีย ส่วน​ตั๋ว​ของ​เปิ้น​ย้าง​ตี้​แคว้น​เอเชีย​ต่อ​ไป​แหม​หน้อย ");
INSERT INTO nod_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ใน​เวลา​นั้น​เกิด​ก๋าน​วุ่นวาย​อย่าง​หนัก​ตี้​เมือง​เอเฟซัส ย้อน​เรื่อง​ลัทธิ​นั้น​ตี้​ฮ้อง​ว่า ตาง​ของ​พระเยซู ");
INSERT INTO nod_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","มี​ป้อจาย​คน​นึ่ง​จื้อ​เดเมตริอัส​เป๋น​สล่า​เครื่อง​เงิน เขา​เอา​เงิน​มา​แป๋ง​ฮูปปั้น​เจ้าแม่​อารเทมิส​ตี้​เป๋น​เจ้าแม่​ของ​จาว​เอเฟซัส เยียะ​หื้อ​หมู่​สล่า​มี​รายได้​ดี ");
INSERT INTO nod_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","เดเมตริอัส​ฮ้อง​หมู่​เขา​กับ​หมู่​คน​ตี้​มี​อาชีพ​เกี่ยวข้อง​กั๋น​มา​จุมนุม​กั๋น แล้ว​อู้​ว่า “ต้าน​ตังหลาย​ก็​ฮู้​ดี​อยู่​แล้ว​ว่า​หมู่​เฮา​มี​รายได้​ดี มี​เงิน​มี​คำ​ก็​ย้อน​เยียะ​ก๋าน​จาอี้ ");
INSERT INTO nod_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ต้าน​ตังหลาย​ก็​ได้​หัน​ได้ยิน​แล้ว​ว่า​เปาโล​คน​นี้​จั๊กจวน​หื้อ​หลาย​คน​เจื้อ​ว่า ฮูปปั้น​ตี้​แป๋ง​จาก​มือ​คน​บ่﻿ใจ้​พระเจ้า​เตี้ยงแต๊ เขา​บ่﻿ได้​เยียะ​จาอี้​ตี้​เมือง​เอเฟซัส​ตี้​เดียว แต่​เยียะ​เกือบ​ใคว่​แคว้น​เอเชีย​ตวย ");
INSERT INTO nod_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","เรื่อง​นี้​อันตราย​ขนาด​เน่อ จะ​เยียะ​หื้อ​จื้อเสียง​ของ​หมู่​เฮา​ต้อง​เสีย​ไป แล้ว​ยัง​บ่﻿ปอ​จะ​เยียะ​หื้อ​วิหาร​ของ​เจ้าแม่​อารเทมิส​ผู้​ยิ่งใหญ่​เสื่อม​เสีย​อิทธิพล​ไป ตึง​พระนาง​องค์​นี้​ตี้​คน​ใคว่​แคว้น​เอเชีย​กับ​ใคว่​โลก​กราบ​ไหว้​ปู่จา​ก็​จะ​หมด​ศักดิ์ศรี​ไป​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","เมื่อ​หมู่​เขา​ได้ยิน​จาอั้น ก็​โขด​จ๋น​หน้า​ดำ​หน้า​แดง​จึง​ปา​กั๋น​โห่​ฮ้อง​ว่า “เจ้าแม่​อารเทมิส​ของ​จาว​เอเฟซัส​ยิ่งใหญ่﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ใคว่​ตึง​เมือง​ก็​วุ่นวาย​สับสน​กั๋น​ไป​หมด หมู่​จาว​เมือง​ยับ​จาว​มาซิโดเนีย​สอง​คน​คือ​กายอัส​กับ​อาริสทารคัส​ตี้​เป๋น​เปื้อน​ฮ่วม​เตียวตาง​ของ​เปาโล แล้ว​ลาก​ตวย​หมู่​คน​ตี้​ล่น​เข้า​ไป​ใน​โฮงละคร​ใหญ่ ");
INSERT INTO nod_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","เปาโล​ใค่​เข้า​ไป​อู้​ต่อ​หน้า​คน​ตังหลาย แต่​หมู่​ผู้เจื้อ​บ่﻿ยอม​หื้อ​เข้า​ไป ย้อน​กั๋ว​คน​หมู่​นั้น​จะ​เยียะ​หื้อ ");
INSERT INTO nod_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ก็​มี​เจ้าหน้าตี้​ปกครอง​แคว้น​เอเชีย​บาง​คน​ตี้​เป๋น​เปื้อน​ของ​เปาโล ใจ๊​คน​ไป​อ้อนวอน​เปาโล​บ่﻿หื้อ​เสี่ยง​เข้า​ไป​ใน​โฮงละคร​นั้น ");
INSERT INTO nod_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ใน​โฮง​ละคร​นั้น​หมู่​คน​ปา​กั๋น​ฮ้อง​เอิ้น​เสียง​ดัง บาง​คน​ว่า​จาอั้น บาง​คน​ว่า​จาอี้​จ๋น​วุ่นวาย​ไป​หมด แต่​คน​ส่วน​ใหญ่​ก็​บ่﻿ฮู้​ว่า​เขา​มา​จุมนุม​กั๋น​เรื่อง​อะหยัง ");
INSERT INTO nod_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","มี​จาว​ยิว​บาง​คน​ยู้​อเล็กซานเดอร์​ออก​ไป​อยู่​ตัง​หน้า แล้ว​บอก​กำ​ตี้​จะ​หื้อ​เขา​อู้ เขา​จึง​ยก​มือ​ขึ้น​โบก​หื้อ​คน​ตังหลาย​ดัก​ก่อน แล้ว​พยายาม​จะ​อู้​แก้​แตน​ต่อหน้า​คน​ตี้​มา​จุมนุม​นั้น ");
INSERT INTO nod_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","เมื่อ​คน​ตังหลาย​ฮู้​ว่า​อเล็กซานเดอร์​เป๋น​จาว​ยิว หมู่​เขา​ก็​เอิ้น​เสียง​ดัง​ขึ้น​มา​แหม​เป๋น​เสียง​เดียว​กั๋น​ว่า “เจ้าแม่​อารเทมิส​ของ​จาว​เอเฟซัส​ยิ่งใหญ่﻿ๆ” ฮ้อง​ซ้ำแล้ว​ซ้ำแหม​อยู่​จาอั้น​ประมาณ​สอง​จั้วโมง ");
INSERT INTO nod_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ต๋อน​สุดต๊าย​นายอำเภอ​เยียะ​หื้อ​คน​ตังหลาย​ดัก​ปาก แล้ว​อู้​ว่า “ปี้น้อง​จาว​เอเฟซัส​ตังหลาย มี​ใผ​พ่อง​ตี้​ยัง​บ่﻿ฮู้​ว่า​เมือง​เอเฟซัส​เป๋น​คน​ผ่อกอย​พระวิหาร​ของ​เจ้าแม่​อารเทมิส​ผู้​ยิ่งใหญ่ กับ​เทวฮูป​ศักดิ์สิทธิ์​ของ​พระนาง​ตี้​ตก​มา​จาก​ต๊องฟ้า ");
INSERT INTO nod_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","เรื่อง​นี้​กู้​คน​ฮู้​แล้ว ย้อนจาอั้น​หมู่​ต้าน​ต้อง​ใจ๋​เย็น﻿ๆ ห้าม​ใจ๊​อารมณ์​เยียะ​อะหยัง​ไป​เล่ย ");
INSERT INTO nod_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","แต่​หมู่​ต้าน​ลาก​ป้อจาย​สอง​คน​นี้​มา​ตี้​นี่ หมู่​เขา​บ่﻿ได้​ลัก​ของ​อะหยัง​ใน​พระวิหาร​กาว่า​ดู​แควน​เจ้าแม่​ของ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ถ้า​เดเมตริอัส​กับ​หมู่​สล่า​เครื่อง​เงิน​มี​เรื่อง​กับ​ใผ ศาล​ก็​เปิด​อยู่ หมู่​ผู้​พิพากษา​ก็​มี​พร้อม หื้อ​หมู่​เขา​มา​ฟ้อง​ตี้​หั้น​คน​เดียว​แหล่ ");
INSERT INTO nod_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ถ้า​หมู่​ต้าน​ยัง​มี​เรื่อง​อื่น​แหม ก็​หื้อ​ไป​ตกลง​กั๋น​ใน​ตี้​ประชุม​ต๋าม​กฎหมาย ");
INSERT INTO nod_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","เหตุก๋ารณ์​วัน​นี้​หมู่​เฮา​ก็​หันลาย​จะ​โดน​ข้อหา​ก่อ​ก๋าน​จลาจล​ขึ้น หมู่​เฮา​จะ​บ่﻿มี​ข้ออ้าง​ตี้​จะ​แก้​ตั๋ว​กับ​รัฐบาล​ได้​ว่า​มา​จุมนุม​หื้อ​เกิด​ก๋าน​วุ่นวาย​ใน​วัน​นี้​เยียะ​หยัง” ");
INSERT INTO nod_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","เมื่อ​อู้​จบ​แล้ว​ก็​หื้อ​เลิก​จุมนุม​กั๋น​ไป ");
INSERT INTO nod_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","เมื่อ​ก๋าน​วุ่นวาย​บ่﻿มี​แล้ว เปาโล​ก็​ฮ้อง​หมู่​ผู้เจื้อ​มา​ปะ​กั๋น หลังจาก​อู้​กำ​หื้อ​ก๋ำลังใจ๋​หมู่​เขา​แล้ว เปาโล​ก็​ลา​หมู่​เขา​ไป​แคว้น​มาซิโดเนีย ");
INSERT INTO nod_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","เปาโล​หื้อ​ก๋ำลังใจ๋​หมู่​ผู้เจื้อ​ต๋าม​ตี้​ต่าง﻿ๆ ตี้​ต้าน​ก๋าย​ไป​ใน​แคว้น​นั้น​จ๋น​มา​แผว​ประเทศ​กรีก ");
INSERT INTO nod_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","เปาโล​ย้าง​อยู่​ตี้​หั้น​สาม​เดือน แต่​เมื่อ​ต้าน​เกียม​จะ​ลง​เฮือ​ไป​แคว้น​ซีเรีย ก็​ได้​ฮู้​ว่า​มี​หมู่​จาว​ยิว​วางแผน​จะ​ฆ่า​ต้าน​ถ้า​เตียวตาง​ตัง​เฮือ เปาโล​ก็​เลย​ตัดสินใจ๋​งว้าย​เตียว​ปิ๊ก​ไป​แคว้น​ซีเรีย​มา​ตัง​แคว้น​มาซิโดเนีย​เหีย ");
INSERT INTO nod_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","เปาโล​มี​เปื้อน​ฮ่วม​เตียวตาง​ไป​หลาย​คน คือ​โสปาเทอร์​ลูกบ่าว​ของ​ปีรัส​จาว​เมือง​เบโรอา อาริสทารคัส​กับ​เสคุนดัส​จาว​เมือง​เธสะโลนิก๋า กายอัส​จาว​เมือง​เดอร์บี ทิโมธี​จาว​เมือง​ลิสตรา กับ​ทีคิกัส​ตึง​โตรฟีมัส​จาว​แคว้น​เอเชีย ");
INSERT INTO nod_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","แต่​คน​ตึงหมด​นี้​เตียวตาง​ล่วงหน้า​ไป​ถ้า​หมู่​เฮา​ตี้​เมือง​โตรอัส​ก่อน​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","หลังจาก​วัน​งาน​กิ๋น​เข้าหนมปัง​บ่﻿ใส่​เจื๊อ หมู่​เฮา​ก็​ลง​เฮือ​ออก​จาก​เมือง​ฟีลิปปี มา​ได้​ห้า​วัน​ก็​มา​แผว​เมือง​โตรอัส ก็​ปะ​กับ​หมู่​เขา แล้ว​ย้าง​อยู่​ตวย​กั๋น​เจ็ด​วัน ");
INSERT INTO nod_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ต๋อน​วัน​เสาร์​เมื่อคืน เฮา​ตังหลาย​จุมนุม​กั๋น​กับ​ฮ่วม​พิธี​หัก​เข้าหนมปัง เปาโล​ก็​อู้​กับ​หมู่​คน​ตี้​หั้น อู้​แล้ว​อู้​แหม​จ๋น​แผว​เตี้ยง​คืน ย้อน​ตั้งใจ๋​จะ​ออก​จาก​เมือง​นี้​ต๋อน​แจ้งเจ๊า​วันพูก ");
INSERT INTO nod_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ใน​ห้อง​จั๊น​บน​ตี้​เฮา​จุมนุม​กั๋น​นั้น​มี​โกม​ไฟ​ต๋าม​ไว้​อยู่​หลาย​แก่น ");
INSERT INTO nod_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","มี​ป้อจาย​หนุ่ม​คน​นึ่ง​จื้อ​ยุทิกัส​นั่ง​อยู่​บน​ขอบ​หน้าต่าง ใน​เวลา​เปาโล​อู้​อยู่​ติก﻿ๆ บ่﻿ย้าง​สัก​เตื้อ เขา​ก็​ใค่​หลับ​แหมะฮาก สุดต๊าย​เขา​หมิ้ง​หลับ​จึง​ปิ้นตะหลิ้น​ตก​จาก​หน้าต่าง​จั๊น​ตี้​สาม​ลง​มา เมื่อ​หมู่​เขา​ยก​ตั๋ว​เขา​ขึ้น​มา​ก็​หัน​ว่า​เขา​ต๋าย​เหีย​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","เปาโล​จึง​ลง​ไป​หา แล้ว​อุ้ม​ป้อจาย​หนุ่ม​คน​นั้น​ขึ้น แล้ว​อู้​กับ​คน​ตังหลาย​ว่า “บ่﻿ถ้า​ฮ้อนอก​ตกใจ๋​เน่อ เขา​ยัง​มี​จีวิต​อยู่” ");
INSERT INTO nod_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","แล้ว​เปาโล​ก็​ปิ๊ก​ขึ้น​ไป​จั๊น​บน​แหม ฮ่วม​พิธี​หัก​เข้าหนมปัง กับ​กิ๋น​ข้าว​ตวย​กั๋น แล้ว​ก็​อู้​ต่อ​ไป​จ๋น​แผว​เมื่อเจ๊า ก็​ลา​หมู่​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","หมู่​เขา​ก็​ปา​ยุทิกัส​ตี้​ยัง​มี​จีวิต​อยู่​ปิ๊ก​เมือ​บ้าน กู้​คน​ก็​ฮู้สึก​ซว่างใจ๋ ");
INSERT INTO nod_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ฝ่าย​หมู่​เฮา​ลง​เฮือ​ไป​เมือง​อัสโสส​ก่อน แล้ว​จะ​ไป​ฮับ​เปาโล​ตี้​หั้น​ต๋าม​ตี้​ต้าน​บอก​ไว้ ย้อน​ว่า​ต้าน​ตั้งใจ๋​จะ​ไป​เมือง​อัสโสส​ตัง​เตียว​ดิน ");
INSERT INTO nod_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","เมื่อ​เปาโล​ปะ​กับ​หมู่​เฮา​ตี้​เมือง​อัสโสส​แล้ว เฮา​ก็​ฮับ​ต้าน​ลง​เฮือ​ไป​เมือง​มิทิเลนี ");
INSERT INTO nod_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","วัน​ถัด​ไป​เฮือ​ออก​จาก​ตี้​หั้น​ไป​แผว​ฝั่ง​ซื่อ​เกาะ​คิโอส วัน​ตี้​สอง​ก็​มา​แผว​เกาะ​สามอส แหม​วัน​ต่อ​มา​หมู่​เฮา​ก็​มา​แผว​เมือง​มิเลทัส ");
INSERT INTO nod_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","เปาโล​ตัดสินใจ๋​ว่า​จะ​เอา​เฮือ​ก๋าย​เมือง​เอเฟซัส​ไป​เหีย เปื้อ​จะ​บ่﻿เสีย​เวลา​ตี้​แคว้น​เอเชีย ย้อน​ว่า​ต้าน​ฟั่ง​ไป​แผว​กรุง​เยรูซาเล็ม ถ้า​เป๋น​ไป​ได้​จะ​ไป​หื้อ​เถิง​ก่อน​วัน​เพ็นเทคอสต์ ");
INSERT INTO nod_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ต๋อน​อยู่​ใน​เมือง​มิเลทัส เปาโล​ส่ง​คน​ไป​บอก​หื้อ​หมู่​ผู้ปกครอง​ของ​คริสตจักร​ตี้​เมือง​เอเฟซัส​มา​หา​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","เมื่อ​หมู่​ผู้ปกครอง​มา​แผว​แล้ว เปาโล​อู้​ว่า “ต้าน​ตังหลาย​ก็​ฮู้​แล้ว​ว่า​ข้าพเจ้า​ใจ๊​จีวิต​จาใด​พ่อง​ตลอด​เวลา​ตี้​ข้าพเจ้า​อยู่​ตวย​หมู่​ต้าน ตั้งแต่​วัน​หนที​ตี้​ข้าพเจ้า​มา​แผว​แคว้น​เอเชีย​นี้ ");
INSERT INTO nod_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ข้าพเจ้า​ฮับใจ๊​องค์​พระ​ผู้​เป๋น​เจ้า​อย่าง​ถ่อมอก​ถ่อมใจ๋ กับ​ไห้​ย้อน​ความ​ตุ๊ก ข้าพเจ้า​อดทน​ความ​ตุ๊กยาก​ลำบาก​จาก​แผนก๋าน​ฮ้าย​ต่าง﻿ๆ ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ต้าน​ก็​ฮู้​ว่า​ข้าพเจ้า​บ่﻿เกย​ลังเล​ตี้​จะ​อู้​จะ​บอก​เรื่อง​ต่าง﻿ๆ ตี้​จะ​เป๋น​ประโยชน์​กับ​หมู่​ต้าน แต่​ได้​เตสนา​สั่ง​สอน​ต้าน​ต๋าม​บ้าน​ต๋าม​ตี้​สาธารณะ​ต่าง﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ข้าพเจ้า​ตักเตื๋อน​ตึง​จาว​ยิว​กับ​จาว​กรีก​หื้อ​กลับใจ๋​จาก​บาป​มา​หา​พระเจ้า กับ​เจื้อ​วางใจ๋​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​ของ​หมู่​เฮา ");
INSERT INTO nod_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","บ่าเดี่ยวนี้​ข้าพเจ้า​จ๋ำใจ๋​ต้อง​ไป​กรุง​เยรูซาเล็ม​ต๋าม​ตี้​พระวิญญาณ​บริสุทธิ์​บอก​หื้อ​ไป ข้าพเจ้า​ก็​บ่﻿ฮู้​เหมือน​กั๋น​ว่า​จะ​มี​อะหยัง​เกิด​ขึ้น​กับ​ข้าพเจ้า​ตี้​หั้น​พ่อง ");
INSERT INTO nod_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ข้าพเจ้า​ฮู้​แต่​ว่า​ใน​เมือง​ต่าง﻿ๆ ตี้​ก่ำลัง​จะ​ไป​นั้น พระวิญญาณ​บริสุทธิ์​เตื๋อน​หื้อ​ฮู้​ว่า​คน​ตี้​หั้น​จะ​ยับ​ขัง​คอก กับ​จะ​เยียะ​หื้อ​ข้าพเจ้า​ฮับ​ความ​ตุ๊กยาก​ลำบาก ");
INSERT INTO nod_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","แต่​ข้าพเจ้า​บ่﻿ได้​ถือ​ว่า​จีวิต​ของ​ข้าพเจ้า​มี​ก้า​นัก​สำหรับ​ตั๋วเก่า นอกจาก​ขอ​เยียะ​หน้าตี้​ตี้​ฮับ​มอบหมาย​จาก​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า คือ​บอก​ข่าวดี​เรื่อง​พระคุณ​ของ​พระเจ้า​หื้อ​คน​อื่น​ฟัง​หื้อ​สำเร็จ​ก็​ปอ​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ต๋อน​นี้​ข้าพเจ้า​ฮู้​ดี​ว่า​จะ​บ่﻿มี​ใผ​ใน​หมู่​ต้าน ตี้​ข้าพเจ้า​เกย​แอ่ว​ไป​บอก​เรื่อง​แผ่นดิน​ของ​พระเจ้า​หื้อ​ฟัง​นั้น จะ​หัน​หน้า​หัน​ต๋า​ข้าพเจ้า​แหม ");
INSERT INTO nod_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ย้อนจาอี้​ข้าพเจ้า​อู้​แต๊﻿ๆ หื้อ​ต้าน​ตังหลาย​เข้าใจ๋​ใน​วัน​นี้​ว่า ถ้า​พระเจ้า​ลงโต้ษ​คน​ใด​ใน​หมู่​ต้าน ข้าพเจ้า​บ่﻿มี​โต้ษ​เน่อ ");
INSERT INTO nod_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ย้อน​ว่า​ข้าพเจ้า​บ่﻿ลังเล​ใน​ก๋าน​บอก​ความ​ต้องก๋าน​ตึงหมด​ของ​พระเจ้า​หื้อ​หมู่​ต้าน​ฮู้ ");
INSERT INTO nod_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“หื้อ​ต้าน​ตังหลาย​เฝ้า​หละวัง​ตั๋ว​กับ​สมาชิก​คริสตจักร​ตี้​พระวิญญาณ​บริสุทธิ์​มอบหมาย​หื้อ​ต้าน​ตังหลาย​ผ่อกอย หื้อ​เอาใจ๋​ใส่​คน​ตังหลาย​ใน​คริสตจักร​เหมือน​ผู้เลี้ยง​แกะ​ผ่อกอย​แกะ ตี้​พระเจ้า​เยียะ​หื้อ​เป๋น​คน​ของ​พระองค์​โดย​ก๋าน​ต๋าย​ของ​พระบุตร​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ข้าพเจ้า​ฮู้​ดี​ว่า​เมื่อ​ข้าพเจ้า​ลา​จาก​ต้าน​ตังหลาย​ไป​แล้ว จะ​มี​คน​อื่น​ตี้​สอน​ผิด​เข้า​มา​ใน​หมู่​ต้าน หมู่​เขา​เผียบ​เหมือน​หมาป่า​สวก​ตี้​มา​ทำลาย​หมู่​แกะ​จ๋น​เสี้ยง ");
INSERT INTO nod_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","แม้​แต่​ใน​หมู่​ต้าน ก็​จะ​มี​บาง​คน​ออก​มา​สอน​ผิด​ไป​จาก​ความ​จริง เปื้อ​จั๊กจวน​หมู่​ผู้เจื้อ​หื้อ​หลง​ตวย​เขา​ไป ");
INSERT INTO nod_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ย้อนจาอั้น​เฝ้า​หละวัง​ตั๋ว​ไว้​หื้อ​ดี ขอ​หื้อ​กึ๊ด​เถิง​ว่า​ข้าพเจ้า​ฮับ​ความ​ตุ๊ก​ใน​ก๋าน​ตักเตื๋อน​สั่ง​สอน​หมู่​ต้าน​ตึง​เมื่อวัน​เมื่อคืน​ตลอด​สาม​ปี๋ ");
INSERT INTO nod_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“บ่าเดี่ยวนี้​ข้าพเจ้า​ขอ​มอบ​ต้าน​ตังหลาย​ไว้​กับ​พระเจ้า​กับ​ถ้อยกำ​เกี่ยวกับ​พระคุณ​ของ​พระองค์ ตี้​สามารถ​เยียะ​หื้อ​ต้าน​ตังหลาย​เข้มแข็ง​ขึ้น​ใน​ความ​เจื้อ กับ​ฮับ​ปอน​ของ​พระเจ้า​ฮ่วม​กับ​คน​ตังหลาย​ของ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“ข้าพเจ้า​บ่﻿เกย​กึ๊ด​ขี้โลภ​ใค่​ได้​เงิน​คำ​กาว่า​เสื้อผ้า​ของ​ใผ​เลย ");
INSERT INTO nod_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","หมู่​ต้าน​ก็​ฮู้​ดี​อยู่​แล้ว​ว่า ข้าพเจ้า​เซาะ​ว่า​หากิ๋น​ด้วย​มือ​ของ​ข้าพเจ้า​คน​เดียว เปื้อ​เลี้ยง​ตั๋ว​เก่า​กับ​คน​ตี้​อยู่​ตวย​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","โดย​ตี้​ข้าพเจ้า​เยียะ​ตึงหมด​นี้​ก็​แสดง​หื้อ​หมู่​ต้าน​หัน​ว่า​หมู่​เฮา​จะ​ต้อง​เยียะ​ก๋าน​หนัก เปื้อ​จ้วยเหลือ​คน​ตี้​อ่อนแอ ขอ​หื้อ​ต้าน​ตังหลาย​หมั่น​กึ๊ด​เถิง​กำ​อู้​ของ​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า​ไว้ ตี้​ว่า ‘ก๋าน​หื้อ​เยียะ​หื้อ​หมู่​เฮา​มี​ความ​สุข​นัก​เหลือ​ก๋าน​ฮับ’ ” ");
INSERT INTO nod_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","เมื่อ​เปาโล​อู้​เสร็จ​แล้ว ก็​คุก​เข่า​ลง​อธิษฐาน​พร้อม​กับ​ผู้ปกครอง​หมู่​นั้น ");
INSERT INTO nod_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","หมู่​เขา​ก็​กอด​ลา​เปาโล​ไว้ ปา​กั๋น​ไห้​สะอึกสะอื้น ");
INSERT INTO nod_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ตี้​เยียะ​หื้อ​หมู่​เขา​เป๋น​ตุ๊ก​นัก​เหลือ​เปิ้น​ก็​คือ​กำ​อู้​ของ​เปาโล​ต๋อน​ตี้​ว่า ต่อไป​นี้​หมู่​เขา​จะ​บ่﻿หัน​หน้า​ต้าน​แหม​แล้ว จาก​นั้น​หมู่​เขา​ก็​ปา​กั๋น​มา​ส่ง​เปาโล​ตี้​เฮือ ");
INSERT INTO nod_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","เมื่อ​ลา​จาก​กั๋น​แล้ว หมู่​เฮา​ก็​ลง​เฮือ​ตั้งซื่อ​ไป​เกาะ​โขส แหม​วัน​นึ่ง​ก็​มา​เถิง​เกาะ​โรดส์ จาก​ตี้​หั้น​ก็​มา​แผว​เมือง​ปาทารา ");
INSERT INTO nod_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","หมู่​เฮา​ปะ​เฮือ​ลำ​นึ่ง​ตี้​จะ​ไป​เมือง​ฟีนิเซีย หมู่​เฮา​ก็​ลง​เฮือ​ลำ​นั้น​ไป ");
INSERT INTO nod_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","เมื่อ​หมู่​เฮา​ผ่อ​หัน​เกาะ​ไซปรัส​แล้ว เฮือ​ก็​ก๋าย​มา​ตาง​ใต้​ของ​เกาะ​ไป​แคว้น​ซีเรีย แล้ว​ก็​จอด​ตี้​เมือง​ไทระ เปื้อ​ขน​สินก๊า​ออก​จาก​เฮือ​ขึ้น​ฝั่ง ");
INSERT INTO nod_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","หมู่​เฮา​เซาะ​หมู่​ผู้เจื้อ แล้ว​ปะ​หมู่​เขา​ตี้​หั้น ก็​ย้าง​อยู่​กับ​หมู่​เขา​ได้​เจ็ด​วัน หมู่​ผู้เจื้อ​บอก​เปาโล​โดย​ก๋าน​นำ​ของ​พระวิญญาณ​บริสุทธิ์​ว่า​ห้าม​ไป​กรุง​เยรูซาเล็ม​เน่อ ");
INSERT INTO nod_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","แต่​ว่า​เมื่อ​เถิง​เวลา​ตี้​หมู่​เฮา​จะ​ต้อง​เตียวตาง​ต่อไป หมู่​เขา​ตึงหมด​ตึง​ลูก​ตึง​เมีย​ก็​มา​ส่ง​หมู่​เฮา​ตี้​นอก​เมือง เมื่อ​มา​แผว​ฮิม​ทะเล หมู่​เฮา​ก็​ปา​กั๋น​คุก​เข่า​อธิษฐาน​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","แล้ว​ล่ำลา​กั๋น จาก​นั้น​หมู่​เฮา​ก็​ลง​เฮือ หมู่​เขา​ก็​ปา​กั๋น​ปิ๊ก​บ้าน ");
INSERT INTO nod_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","จาก​เมือง​ไทระ​เฮือ​มา​จอด​ตี้​เมือง​ทอเลเมอิส หมู่​เฮา​ไป​แอ่ว​หา​ปี้น้อง​ผู้เจื้อ​ตี้​หั้น แล้ว​ย้าง​อยู่​กับ​หมู่​เขา​วัน​นึ่ง ");
INSERT INTO nod_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","วัน​ถัด​มา​หมู่​เฮา​เตียวตาง​ต่อ​ไป​แหม​จ๋น​มา​แผว​เมือง​ซีซารียา หมู่​เฮา​แว่​บ้าน​ของ​ฟีลิป แล้ว​ย้าง​อยู่​กับ​เขา ฟีลิป​เป๋น​คน​บอก​ข่าวดี​ของ​พระเจ้า เป๋น​คน​นึ่ง​ใน​หมู่​เจ็ด​คน​ตี้​ฮับ​ก๋าน​เลือก​หื้อ​เป๋น​ผู้​ผ่อกอย​ก๋าน​แจก​อาหาร​หื้อ​คน​ตุ๊ก ");
INSERT INTO nod_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ฟีลิป​มี​ลูกสาว​สี่​คน​ตี้​ยัง​บ่﻿ได้​แต่งงาน​เตื้อ ตึง​สี่​คน​สามารถ​ตวายตั๊ก​ได้ ");
INSERT INTO nod_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","หลังจาก​หมู่​เฮา​ย้าง​อยู่​ตี้​หั้น​หลาย​วัน ก็​มี​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​มา​จาก​แคว้น​ยูเดีย​จื้อ​อากาบัส ");
INSERT INTO nod_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","เขา​เข้า​มา​หา​หมู่​เฮา แล้ว​เอา​สายฮ้าง​มัด​แอว​ของ​เปาโล​มา​มัด​มือ​มัด​ตี๋น​ตั๋ว​เขา​อู้​ว่า “พระวิญญาณ​บริสุทธิ์​บอก​ว่า ‘จาว​ยิว​ใน​กรุง​เยรูซาเล็ม​จะ​มัด​คน​ตี้​เป๋น​เจ้าของ​สาย​มัด​แอว​นี้​จาอี้​เน่อ แล้ว​จะ​มอบ​เขา​หื้อ​กับ​คน​ต่างจ้าด’ ” ");
INSERT INTO nod_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","เมื่อ​หมู่​เฮา​ได้ยิน​จาอั้น หมู่​เฮา​กับ​คน​ตี้​อยู่​ตี้​หั้น​ก็​ปา​กั๋น​อ้อนวอน​เปาโล​บ่﻿หื้อ​ขึ้น​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","แต่​เปาโล​ตอบ​ว่า “หมู่​ต้าน​ปา​กั๋น​ไห้​ฮ้อง​เยียะ​หยัง เยียะ​หื้อ​ข้าพเจ้า​บ่﻿ม่วนใจ๋​เหีย​บ่ดาย ข้าพเจ้า​พร้อม​ตี้​จะ​ถูก​มัด​ถูก​ขัง​คอก นัก​เหลือ​นั้น​ข้าพเจ้า​พร้อม​ตี้​จะ​ต๋าย​ใน​กรุง​เยรูซาเล็ม เปื้อ​หัน​แก่​พระเยซู​องค์​พระ​ผู้​เป๋น​เจ้า” ");
INSERT INTO nod_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","เมื่อ​อ้อนวอน​เปาโล​บ่﻿ได้​ผล หมู่​เฮา​ก็​ปา​กั๋น​เลิก แล้ว​บอก​ว่า “ขอ​หื้อ​เป๋น​ไป​ต๋าม​ความ​ต้องก๋าน​ของ​องค์​พระ​ผู้​เป๋น​เจ้า​ก็​แล้ว​กั๋น” ");
INSERT INTO nod_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","หลังจาก​นั้น​หมู่​เฮา​ก็​เกียม​ตั๋ว แล้ว​ปา​กั๋น​เตียวตาง​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","มี​ผู้เจื้อ​บาง​คน​จาก​เมือง​ซีซารียา​ไป​ตวย​หมู่​เฮา หมู่​เขา​ปา​หมู่​เฮา​ไป​ตี้​บ้าน​ของ​มนาสัน​จาว​เกาะ​ไซปรัส​ตี้​เป๋น​ผู้เจื้อ​เก่าแก่ หมู่​เฮา​ย้าง​อยู่​ตวย​เขา ");
INSERT INTO nod_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","เมื่อ​หมู่​เฮา​มา​แผว​กรุง​เยรูซาเล็ม​แล้ว หมู่​ปี้น้อง​ผู้เจื้อ​ก็​ต้อนฮับ​หมู่​เฮา​อย่าง​อบอุ่น ");
INSERT INTO nod_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","วัน​ถัด​มา​เปาโล​กับ​หมู่​เฮา​ปา​กั๋น​ไป​แอ่ว​หา​ยากอบ ผู้ปกครอง​ของ​คริสตจักร​กู้​คน​ก็​อยู่​ตี้​หั้น​ตวย ");
INSERT INTO nod_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","เปาโล​ตั๊ก​หมู่​เขา แล้ว​เล่า​เถิง​เรื่อง​ต่าง﻿ๆ ตี้​พระเจ้า​ใจ๊​ต้าน​หื้อ​ไป​เยียะ​พันธกิจ​กับ​คน​ต่างจ้าด ");
INSERT INTO nod_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","เมื่อ​หมู่​เขา​ได้ยิน​เรื่องราว​ตึง​หมด​จาอั้น ก็​ปา​กั๋น​สรรเสริญ​พระเจ้า แล้ว​อู้​กับ​เปาโล​ว่า “อ้าย​เปาโล​เหย ต้าน​ก็​หัน​แล้ว​ว่า​มี​จาว​ยิว​หลาย​ปัน​คน​ตี้​ฮับเจื้อ​พระเยซู แต่​ก็​ยัง​ฮักษา​บท​บัญญัติ​ของ​โมเสส​อย่าง​เคร่งครัด​เอา​เป๋น​แต๊​เป๋น​ว่า​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","มี​คน​บอก​จาว​ยิว​ใน​กรุง​เยรูซาเล็ม​ว่า ต้าน​สอน​จาว​ยิว​กู้​คน​ตี้​อยู่​ตวย​คน​ต่างจ้าด​หื้อ​ละ​บท​บัญญัติ​ของ​โมเสส​เหีย โดย​บอก​ว่า​บ่﻿ต้อง​เยียะ​พิธี​สุหนัต​หื้อ​กับ​ลูกบ่าว​ของ​เขา​นั้น กาว่า​เยียะ​ต๋าม​ฮีต​เก่า​ฮอย​เดิม​ของ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","บ่าเดี่ยวนี้​หมู่​เฮา​จะ​เยียะ​จาใด​ดี เปื้อ​พิสูจน์​ว่า​ข้อ​กล่าวหา​ของ​หมู่​เขา​บ่﻿แต๊ หมู่​เขา​คง​จะ​ฮู้​แล้ว​ว่า​ต้าน​มา​ตี้​นี่​แล้ว ก็​จะ​ปา​กั๋น​หลุ้ม​เยียะ​หื้อ​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","หื้อ​เยียะ​ต๋าม​ตี้​หมู่​เฮา​จะ​บอก​ก็​แล้ว​กั๋น คือ​ว่า​มี​สี่​คน​ตี้​อยู่​กับ​หมู่​เฮา​ตี้​นี่​ตี้​สาบาน​ตั๋ว​กับ​พระเจ้า​ไว้​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ปา​คน​หมู่​นี้​เข้า​ไป​ใน​พระวิหาร เข้า​ฮ่วม​พิธี​ล้าง​ตั๋ว​หื้อ​บริสุทธิ์​ตวย​กั๋น แล้ว​จ่าย​ก้า​เครื่อง​ปู่จา​สำหรับ​พิธี​นั้น​หื้อ​แก่​หมู่​เขา เปื้อ​จะ​โก๋น​หัว​ได้ คน​ตังหลาย​จะ​ฮู้​ว่า​เรื่อง​ตี้​ได้ยิน​มา​เกี่ยวกับ​ต้าน​นั้น​ก็​บ่﻿แต๊ ย้อน​ว่า​ตั๋ว​ต้าน​ก็​ยัง​ฮักษา​บท​บัญญัติ​ของ​โมเสส​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","สำหรับ​หมู่​คน​ต่างจ้าด​ตี้​ฮับเจื้อ​พระเจ้า​นั้น หมู่​เฮา​ส่ง​จดหมาย​แจ้ง​มติ​ตี้​ประชุม​ไป​แล้ว คือ​อย่าง​ตี้​นึ่ง ห้าม​กิ๋น​ของกิ๋น​ตี้​เกย​เอา​ไป​ปู่จา​ฮูป​เคารพ​แล้ว อย่าง​ตี้​สอง ห้าม​กิ๋น​เลือด อย่าง​ตี้​สาม ห้าม​กิ๋น​จิ๊น​สัตว์​ตี้​ถูก​ฮัด​คอ​ต๋าย กับ​อย่าง​ตี้​สี่ ห้าม​เยียะ​บาป​ตาง​เพศ” ");
INSERT INTO nod_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","แล้ว​วัน​ถัด​มา​เปาโล​ก็​ปา​ป้อจาย​สี่​คน​นี้​เข้า​พิธี​ล้าง​ตั๋ว​หื้อ​บริสุทธิ์​ตวย​กั๋น แล้ว​ปา​กั๋น​เข้า​ไป​ใน​พระวิหาร​แจ้ง​หื้อ​ปุโรหิต​ฮู้​ว่า​พิธี​ล้าง​นี้​จะ​เสี้ยง​สุด​วัน​ไหน แล้ว​จะ​นำ​เครื่อง​ปู่จา​มา​ถวาย​สำหรับ​หมู่​เขา​แต่​ละ​คน​ใน​วัน​นั้น ");
INSERT INTO nod_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","เมื่อ​เวลา​ก๋ำหนด​เจ็ด​วัน​ของ​พิธี​ใก้​จะ​แล้ว มี​จาว​ยิว​บาง​คน​จาก​แคว้น​เอเชีย​หัน​เปาโล​ใน​พระวิหาร ก็​สุ่ย​คน​ตังหลาย​หื้อ​โขด​แล้ว​ยับ​เปาโล ");
INSERT INTO nod_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","หมู่​เขา​ฮ้อง​เอิ้น​เสียง​ดัง​ว่า “ปี้น้อง​จาว​อิสราเอล​เหย มา​จ้วย​กั๋น​แล่ ไอ่​ตั๋ว​นี่​เป๋น​คน​ตี้​แอ่ว​ไป​สอน​คน​ใคว่​ไป​หมด​หื้อ​ต่อต้าน​คน​จ้าด​ของ​เฮา กับ​บท​บัญญัติ​ของ​โมเสส​ตึง​พระวิหาร​ของ​เฮา หัน​ก่อ​บ่าเดี่ยวนี้​มัน​ยัง​ปา​จาว​กรีก​เข้า​มา​ใน​พระวิหาร​แหม​ตวย เยียะ​หื้อ​สถาน​ตี้​อัน​ศักดิ์สิทธิ์​นี้​มี​มลทิน” ");
INSERT INTO nod_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(​หมู่​เขา​ว่า​จาอี้​ก็​ย้อน​หัน​โตรฟีมัส​จาว​เมือง​เอเฟซัส​อยู่​กับ​เปาโล​ใน​เมือง จึง​กึ๊ด​เดา​เอา​ว่า​เปาโล​ปา​โตรฟีมัส​เข้า​มา​ใน​พระวิหาร​ตวย​) ");
INSERT INTO nod_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","คน​ตึง​เมือง​ก็​โขด ปา​กั๋น​หลุ้ม​เข้า​ไป​ยับ​เปาโล​ลาก​ออก​ไป​นอก​พระวิหาร แล้ว​หับ​ปะตู๋​พระวิหาร​เหีย ");
INSERT INTO nod_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ใน​เวลา​ตี้​หมู่​เขา​ฮิ​จะ​ฆ่า​เปาโล​อยู่​นั้น มี​คน​ไป​รายงาน​นายพัน​ว่า ใน​กรุง​เยรูซาเล็ม​ตึง​เมือง​ก่ำลัง​วุ่นวาย​ไป​หมด​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","นายพัน​ก็​ฟั่ง​ปา​หมู่​ทหาร​ล่น​ไป​ตี้​คน​ตังหลาย เมื่อ​คน​ตังหลาย​หัน​นายพัน​กับ​หมู่​ทหาร​มา จึง​ย้าง​บุบ​ตี๋​เปาโล ");
INSERT INTO nod_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","นายพัน​ก็​เข้า​ไป​หา​เปาโล​แล้ว​ก็​ยับ​ต้าน สั่ง​หื้อ​เอา​เจื้อก​เหล็ก​สอง​เส้น​มา​ล่าม​ต้าน​ไว้ จาก​นั้น​นายพัน​ก็​สอบสวน​คน​ตังหลาย​ว่า​เปาโล​เป๋น​ใผ เขา​เยียะ​อะหยัง ");
INSERT INTO nod_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","บาง​คน​เอิ้น​ว่า​จาอี้ แหม​คน​ว่า​จาอั้น นายพัน​บ่﻿สามารถ​ฮู้​แต๊​เถิง​เรื่อง​ตี้​เกิด​ขึ้น​ย้อน​วุ่นวาย​ขนาด ก็​เลย​สั่ง​หื้อ​ปา​ตั๋ว​เปาโล​เข้า​ไป​ไว้​ใน​ป้อม​ทหาร ");
INSERT INTO nod_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","เมื่อ​ปา​เปาโล​เตียว​มา​แผว​ซี่คันใด​ขึ้น​ป้อม คน​ตังหลาย​ก็​โขด​นัก​ขึ้น​จ๋น​หน้า​ดำ​หน้า​แดง หมู่​ทหาร​จึง​จ้วย​กั๋น​ยก​ตั๋ว​เปาโล​ขึ้น​ป๊น​หัว ");
INSERT INTO nod_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","คน​ตังหลาย​ตี้​ตวย​ไป​เอิ้น​ตวย​ก้น​ว่า “ฆ่า​มัน​เหีย﻿ๆ” ");
INSERT INTO nod_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","เมื่อ​ทหาร​ก่ำลัง​ปา​เปาโล​เข้า​ไป​ใน​ป้อม เปาโล​ก็​อู้​กับ​นายพัน​ทหาร​โรมัน​เป๋น​ภาษา​กรีก​ว่า “ข้าพเจ้า​ขอ​อู้​กับ​ต้าน​น่อย​ได้​ก่อ” นายพัน​ถาม​ว่า “เจ้า​อู้​ภาษา​กรีก​ได้​ตวย​กา ");
INSERT INTO nod_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","เจ้า​เป๋น​จาว​อียิปต์​ตี้​เกย​ก่อ​ก๋าน​จลาจล​เมื่อ​ตะก่อน แล้ว​ปา​นัก​ฆ่า​สี่​ปัน​คน​เข้า​ไป​ใน​ดินแดน​ทุรกั๋นดาร​บ่﻿ใจ้​กา” ");
INSERT INTO nod_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","เปาโล​ตอบ​ว่า “บ่﻿ใจ้ ข้าพเจ้า​เป๋น​จาว​ยิว เกิด​ตี้​เมือง​ทาร์ซัส​ใน​แคว้น​ซีลีเซีย เป๋น​คน​ของ​เมือง​สำคัญ ขอ​อนุญาต​หื้อ​อู้​กับ​คน​ตังหลาย​น่อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","เมื่อ​นายพัน​อนุญาต เปาโล​ก็​ยืน​ขึ้น​ตั๊ด​ตี้​ซี่คันใด แล้ว​โบก​มือ​หื้อ​คน​ตังหลาย​ดัก​ก่อน เมื่อ​คน​ตังหลาย​ดัก​ดี​แล้ว เปาโล​ก็​อู้​กับ​หมู่​เขา​เป๋น​ภาษา​ฮีบรู​ว่า ");
INSERT INTO nod_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ป้อ​แม่​ปี้น้อง​ตังหลาย​บ่าเดี่ยวนี้​ขอ​ฟัง​กำ​จี๊แจ๋ง​ของ​ข้าพเจ้า​สัก​หน้อย​เต๊อะ” ");
INSERT INTO nod_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","เมื่อ​หมู่​เขา​ได้ยิน​เปาโล​อู้​เป๋น​ภาษา​ฮีบรู หมู่​เขา​ซ้ำ​ปา​กั๋น​ดัก​เหลือ​เก่า แล้ว​เปาโล​ก็​อู้​ว่า ");
INSERT INTO nod_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ข้าพเจ้า​เป๋น​จาว​ยิว​เกิด​ตี้​เมือง​ทาร์ซัส​แคว้น​ซีลีเซีย แต่​มา​ใหญ่​ตี้​กรุง​เยรูซาเล็ม​นี้ ข้าพเจ้า​เป๋น​ศิษย์​ของ​อาจ๋ารย์​กามาลิเอล ต้าน​อบรม​สั่ง​สอน​ข้าพเจ้า​หื้อ​เยียะ​ต๋าม​บท​บัญญัติ​ของ​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา​อย่าง​เคร่งครัด ข้าพเจ้า​เป๋น​คน​ตี้​กระตือรือร้น​ต่อ​พระเจ้า​ขนาด เหมือน​กั๋น​กับ​หมู่​ต้าน​ตี้​อยู่​ตี้​นี่​วัน​นี้ ");
INSERT INTO nod_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ข้าพเจ้า​เกย​ค่ำ​คน​ตี้​ติดต๋าม​ลัทธิ​นั้น​ตี้​ฮ้อง​ว่า ตาง​ของ​พระเยซู จ๋น​ต๋าย​ก็​มี กับ​ยับ​หมู่​เขา​ตึง​ป้อจาย​แม่ญิง​ไป​ขัง​คอก​ก็​มี ");
INSERT INTO nod_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","มหา​ปุโรหิต​กับ​สภา​คน​เฒ่า​คน​แก่​ก็​เป๋น​พยาน​หื้อ​ข้าพเจ้า​ได้ ย้อน​ข้าพเจ้า​ได้​ฮับ​หนังสือ​จาก​หมู่​เขา ตี้​เขียน​เถิง​ปี้น้อง​จาว​ยิว​ใน​เมือง​ดามัสกัส เปื้อ​มอบ​อำนาจ​หื้อ​ข้าพเจ้า​ไป​ยับ​คน​ตี้​หั้น ตี้​ติดต๋าม​ลัทธิ​นั้น แล้ว​ปา​มา​ลงโต้ษ​ตี้​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“เมื่อ​ข้าพเจ้า​เตียวตาง​ใก้​จะ​แผว​เมือง​ดามัสกัส เวลา​ต๋อน​นั้น​ประมาณ​เตี้ยง จู่﻿ๆ ก็​มี​แสง​แจ้ง​จาก​ต๊องฟ้า​ส่อง​ลง​มา​ตี้​ตั๋ว​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ข้าพเจ้า​ก็​โก้น​ลง​ดิน แล้ว​ได้ยิน​เสียง​อัน​ดัง​ว่า ‘เซาโล เซาโล​เหย เจ้า​ค่ำ​เฮา​เยียะ​หยัง’ ");
INSERT INTO nod_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ข้าพเจ้า​ก็​ถาม​ไป​ว่า ‘พระองค์​เจ้าข้า พระองค์​เป๋น​ใผ’ พระองค์​ก็​ตอบ​ว่า ‘เฮา​คือ​เยซู​จาว​นาซาเร็ธ​ผู้​ตี้​เจ้า​ค่ำ​นั้น’ ");
INSERT INTO nod_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","หมู่​คน​ตี้​ไป​ตวย​ข้าพเจ้า​ก็​หัน​แสง​แจ้ง​นั้น​เหมือน​กั๋น แต่​บ่﻿ได้ยิน​เสียง​ของ​ผู้​ตี้​อู้​กับ​ข้าพเจ้า​นั้น ");
INSERT INTO nod_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ข้าพเจ้า​ก็​ถาม​ว่า ‘พระองค์​เจ้าข้า ข้าพเจ้า​จะ​ต้อง​เยียะ​จาใด​ดี’ องค์​พระ​ผู้​เป๋น​เจ้า​ก็​บอก​ว่า ‘ลุก​ขึ้น​เตียว​เข้า​ไป​ใน​เมือง​ดามัสกัส ตี้​หั้น​จะ​มี​คน​บอก​เจ้า​กู้​อย่าง​ตี้​เฮา​มอบหมาย​หื้อ​เจ้า​เยียะ’ ");
INSERT INTO nod_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","แสง​แจ้ง​ตี้​ส่อง​ลง​มา​นั้น​เยียะ​หื้อ​ต๋า​ข้าพเจ้า​ผ่อ​อะหยัง​บ่﻿หัน​สัก​หน้อย หมู่​คน​ตี้​ไป​ตวย​จึง​จู๋ง​มือ​ข้าพเจ้า​ปา​เข้า​ไป​ใน​เมือง​ดามัสกัส ");
INSERT INTO nod_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ใน​เมือง​นั้น​มี​ป้อจาย​คน​นึ่ง​มา​หา​ข้าพเจ้า เขา​จื้อ​อานาเนีย เป๋น​คน​ตี้​เคร่งครัด​บท​บัญญัติ​ของ​โมเสส กับ​เป๋น​คน​ตี้​มี​จื้อเสียง​ดี​ใน​หมู่​จาว​ยิว​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","เขา​เข้า​มา​ยืน​อยู่​ป่างข้าง​ข้าพเจ้า​อู้​ว่า ‘อ้าย​เซาโล​เหย ขอ​หื้อ​ต๋า​ผ่อ​หัน​แหม​เตื้อ’ แล้ว​วินาที​นั้น​ข้าพเจ้า​ก็​หัน​ได้ กับ​หัน​เขา​ตวย ");
INSERT INTO nod_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“อานาเนีย​บอก​ว่า ‘พระเจ้า​ของ​ป้ออุ๊ย​แม่หม่อน​ของ​หมู่​เฮา​เลือก​ต้าน​หื้อ​ฮู้​เถิง​ความ​ต้องก๋าน​ของ​พระองค์ กับ​หื้อ​หัน​พระองค์​ตี้​ถูกต้อง​ต๋าม​ธรรม กับ​หื้อ​ได้ยิน​กำ​อู้​จาก​ปาก​ของ​พระองค์​ตวย ");
INSERT INTO nod_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ย้อน​ต้าน​จะ​เป๋น​พยาน​หื้อ​กู้​คน​ฮู้​เถิง​สิ่ง​ตี้​ต้าน​ได้​หัน​ได้ยิน​เกี่ยวกับ​พระองค์ ");
INSERT INTO nod_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","บ่﻿ต้อง​ถ้า​อะหยัง​แหม​แล้ว ลุก​ขึ้น​ฮับ​บัพติศมา แล้ว​ขอ​องค์​พระ​ผู้​เป๋น​เจ้า​ล้าง​บาป​ของ​ต้าน​หื้อ​หมด​เสี้ยง​ไป’ ");
INSERT INTO nod_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ข้าพเจ้า​ปิ๊ก​มา​ตี้​กรุง​เยรูซาเล็ม เมื่อ​อธิษฐาน​ใน​พระวิหาร ก็​ตก​อยู่​ใน​ภาวะ​เกิ่ง​หลับ​เกิ่ง​ตื่น ");
INSERT INTO nod_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","แล้ว​ข้าพเจ้า​ก็​หัน​องค์​พระ​ผู้​เป๋น​เจ้า พระองค์​อู้​กับ​ข้าพเจ้า​ว่า ‘ขะใจ๋​ออก​ไป​จาก​กรุง​เยรูซาเล็ม​เวย﻿ๆ เน่อ ย้อน​ว่า​คน​ตี้​นี่​จะ​บ่﻿ยอมฮับ​เรื่อง​ตี้​ต้าน​อู้​เกี่ยวกับ​เฮา’ ");
INSERT INTO nod_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","แล้ว​ข้าพเจ้า​ก็​ตอบ​ว่า ‘พระองค์​เจ้าข้า คน​หมู่​นี้​ฮู้​ว่า​ข้า​พระองค์​เกย​ไป​ต๋าม​ธรรมศาลา​ต่าง﻿ๆ ของ​จาว​ยิว​กู้​ตี้ เปื้อ​ยับ​คน​ตี้​ฮับเจื้อ​พระองค์​ไป​ขัง​คอก​กับ​บุบ​ตี๋ ");
INSERT INTO nod_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","กับ​ต๋อน​สเทเฟน​พยาน​ของ​พระองค์​ถูก​ฆ่า​ต๋าย​นั้น ข้า​พระองค์​ก็​ยืน​อยู่​ตั๊ด​หั้น หัน​ดี​หัน​งาม​ตวย​ตี้​ฆ่า​เขา ข้า​พระองค์​เป๋น​คน​เฝ้า​เสื้อ​คุม​ของ​หมู่​คน​ตี้​ฆ่า​นั้น’ ");
INSERT INTO nod_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","แล้ว​พระองค์​ก็​บอก​กับ​ข้าพเจ้า​ว่า ‘ไป​เต๊อะ เฮา​จะ​ส่ง​เจ้า​ไป​ไก๋﻿ๆ ไป​หา​คน​ต่างจ้าด’ ” ");
INSERT INTO nod_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","คน​ตังหลาย​ฟัง​เปาโล​อู้​มา​ตลอด แต่​เมื่อ​ได้ยิน​เปาโล​อู้​เถิง​เรื่อง​ไป​หา​คน​ต่างจ้าด ก็​ปา​กั๋น​เอิ้น​เสียง​ดัง​ว่า “เอา​มัน​ไป​ฆ่า​ต๋าย​เหีย อยู่​ไป​ก็​หนัก​แผ่นดิน” ");
INSERT INTO nod_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","หมู่​เขา​ฮ้อง​เสียง​ดัง​แล้ว​แก้​เสื้อ​คุม​ออก ปา​กั๋น​ก๋ำ​ขี้ฝุ่น​ผุก​ขึ้น​บน​หัว ");
INSERT INTO nod_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","นายพัน​ทหาร​โรมัน​สั่ง​หื้อ​ปา​เปาโล​เข้า​ไป​ใน​ป้อม​ทหาร สั่ง​เฆี่ยน​กับ​สอบสวน​เปาโล​เปื้อ​จะ​ฮู้​ว่า​เป๋น​จาใด​คน​ตึง​เมือง​ปา​กั๋น​ฮ้อง​เสียง​ดัง​ใส่​เปาโล ");
INSERT INTO nod_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","เมื่อ​หมู่​ทหาร​ก่ำลัง​เอา​เจื้อก​หนัง​มัด​เกียม​เฆี่ยน​ต้าน เปาโล​ก็​ถาม​นายร้อย​ตี้​ยืน​อยู่​ตี้​หั้น​ว่า “จะ​เฆี่ยน​คน​สัญจ้าด​โรมัน​ก่อน​ตัดสิน​ต๋าม​กฎหมาย​แล้ว​กา” ");
INSERT INTO nod_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","เมื่อ​นายร้อย​ได้ยิน​จาอั้น ก็​ไป​รายงาน​หื้อ​นายพัน​ฮู้ แล้ว​ถาม​ว่า “ต้าน​จะ​เยียะ​จาใด​ดี ป้อจาย​คน​นี้​เป๋น​คน​สัญจ้าด​โรมัน​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","นายพัน​ก็​เข้า​ไป​ถาม​เปาโล​ว่า “เจ้า​เป๋น​คน​สัญจ้าด​โรมัน​แต๊​กา” เปาโล​ตอบ​ว่า “แต๊​ก่า” ");
INSERT INTO nod_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","นายพัน​บอก​ว่า “ตั๋ว​ของ​เฮา​ต้อง​เสีย​สตางค์​จ๋ำนวน​นัก​ขนาด​เถิง​จะ​ได้​สัญจ้าด​โรมัน” เปาโล​ตอบ​ว่า “แต่​ตั๋ว​ข้าพเจ้า​เป๋น​คน​สัญจ้าด​โรมัน​ตั้งแต่​เกิด​เน่อ ย้อน​ป้อ​เป๋น​คน​สัญจ้าด​โรมัน​อยู่​แล้ว” ");
INSERT INTO nod_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","หมู่​ทหาร​ตี้​ก่ำลัง​จะ​สอบสวน​ก็​ละ​เปาโล​ไป​ตันที นายพัน​ก็​ตกใจ๋​กั๋ว​ขึ้น​มา​เมื่อ​ฮู้​ว่า คน​ตี้​เขา​สั่ง​หื้อ​เอา​เจื้อก​เหล็ก​ล่าม​นั้น​เป๋น​คน​สัญจ้าด​โรมัน เซิ่ง​เป๋น​ก๋าน​เยียะ​ผิด​กฎหมาย​ของ​โรม ");
INSERT INTO nod_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ถัด​มา​แหม​วัน​นึ่ง นายพัน​ใค่​ฮู้​ว่า​จาว​ยิว​ใส่​ความ​เปาโล​เรื่อง​อะหยัง ก็​สั่ง​หื้อ​เจ้าหน้าตี้​ปล่อย​เปาโล​ก่อน แล้ว​ฮ้อง​ประชุม​หมู่​หัวหน้า​ปุโรหิต​กับ​สภา​แซนเฮดริน แล้ว​ปา​เปาโล​เข้า​มา​ยืน​ต่อ​หน้า​หมู่​เขา ");
INSERT INTO nod_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","เปาโล​ปักต๋าผ่อ​ไป​ตี้​หมู่​สมาชิก​สภา​แซนเฮดริน แล้ว​อู้​ว่า “ปี้น้อง​ตังหลาย ข้าพเจ้า​ใจ๊​จีวิต​ต่อหน้า​พระเจ้า​ด้วย​จิต​สำนึก​ตี้​ดี​ตลอด​มา​จ๋น​แผว​ตึง​วัน​นี้” ");
INSERT INTO nod_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","อานาเนีย​ตี้​เป๋น​มหา​ปุโรหิต สั่ง​หื้อ​คน​ตี้​ยืน​อยู่​ฮิม​เปาโล​ตบ​ปาก​เปาโล ");
INSERT INTO nod_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","เปาโล​ก็​อู้​กับ​อานาเนีย​ว่า “พระเจ้า​จะ​ตบ​ปาก​ต้าน​เหมือน​กั๋น​เน่อ ต้าน​เผียบ​เหมือน​ก่ำแปง​ตี้​ตา​สี​ขาว ต้าน​นั่ง​ตัดสิน​ข้าพเจ้า​ต๋าม​บท​บัญญัติ​ของ​โมเสส แต่​ยัง​สั่ง​หื้อ​เขา​ตบ​ข้าพเจ้า เซิ่ง​เป๋น​ก๋าน​ผิด​บท​บัญญัติ​จาอั้น​กา” ");
INSERT INTO nod_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","คน​ตี้​ยืน​อยู่​ใก้​เปาโล​อู้​ว่า “เจ้า​ก้า​อู้​ดูถูก​ดู​แควน​มหา​ปุโรหิต​ของ​พระเจ้า​จาอั้น​กา” ");
INSERT INTO nod_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","เปาโล​บอก​ว่า “ปี้น้อง​ตังหลาย ข้าพเจ้า​บ่﻿ฮู้​ลอ​ว่า​ป้อจาย​คน​นี้​เป๋น​มหา​ปุโรหิต ถ้า​ฮู้​ข้าพเจ้า​จะ​บ่﻿ว่า ย้อน​มี​เขียน​ไว้​ใน​พระคัมภีร์​ว่า ‘ห้าม​แจ้งด่า​ผู้​ตี้​ปกครอง​เจ้า’” ");
INSERT INTO nod_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","เมื่อ​เปาโล​หัน​ว่า​ตี้​ประชุม​มี​ตึง​หมู่​สะดูสี​กับ​หมู่​ฟาริสี ต้าน​ก็​อู้​เสียง​ดัง​ว่า “ปี้น้อง​ตังหลาย ข้าพเจ้า​เป๋น​ฟาริสี เป๋น​ลูก​ของ​ฟาริสี​ตวย​เน่อ ตี้​ข้าพเจ้า​ถูก​สอบสวน​นี้ ก็​ย้อน​มี​ความ​หวัง​ว่า​คน​ตี้​ต๋าย​ไป​แล้ว​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย” ");
INSERT INTO nod_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","บ่ากอง​เปาโล​อู้​จาอั้น หมู่​ฟาริสี​กับ​หมู่​สะดูสี​ก็​ตั้งเก๊า​เถียง​กั๋น ตี้​ประชุม​นั้น​เลย​แบ่ง​ออก​เป๋น​สอง​หมู่ ");
INSERT INTO nod_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(​หมู่​เขา​ผิด​เถียง​กั๋น​ก็​ย้อน​ว่า​หมู่​สะดูสี​ถือ​ว่า​ทูตสวรรค์​กาว่า​วิญญาณ​กับ​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย​บ่﻿มี แต่​หมู่​ฟาริสี​เจื้อ​ว่า​มี​ตึง​สาม​อย่าง​นี้​) ");
INSERT INTO nod_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ตึง​สอง​หมู่​จึง​ผิด​เถียง​กั๋น​เสียง​ดัง​นัก​ขึ้น​ติก﻿ๆ แล้ว​มี​ธรรมาจ๋ารย์​บาง​คน​ตี้​เป๋น​ฟาริสี​ยืน​ขึ้น​เถียง​อย่าง​หนักแน่น​ว่า “หมู่​เฮา​บ่﻿หัน​ว่า​ป้อจาย​คน​นี้​เยียะ​ผิด​อะหยัง​สัก​หน้อย วิญญาณ​กาว่า​ทูตสวรรค์​อาจ​จะ​อู้​กับ​เขา​แต๊” ");
INSERT INTO nod_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ก๋าน​เถียง​นั้น​แฮง​ขึ้น﻿ๆ จ๋น​นายพัน​กั๋ว​ว่า​หมู่​เขา​จะ​หลุ้ม​เยียะ​ฮ้าย​เปาโล จึง​สั่ง​หื้อ​ทหาร​ปา​ตั๋ว​เปาโล​ออก​มา​ห่าง​จาก​คน​หมู่​นั้น แล้ว​ปา​ปิ๊ก​ไป​ตี้​ป้อม​ทหาร​เหีย ");
INSERT INTO nod_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","แล้ว​ใน​คืน​นั้น​องค์​พระ​ผู้​เป๋น​เจ้า​มา​ยืน​ป่างข้าง​เปาโล​บอก​ว่า “เจ้า​บ่﻿ต้อง​กั๋ว​เน่อ เจ้า​เป๋น​พยาน​หื้อ​เฮา​ใน​กรุง​เยรูซาเล็ม​จาใด เจ้า​จะ​ต้อง​เป๋น​พยาน​ใน​กรุง​โรม​จาอั้น” ");
INSERT INTO nod_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","วัน​ถัด​มา​จาว​ยิว​มา​สุมหัว​กั๋น​วางแผน​จะ​ฆ่า​เปาโล แล้ว​สาบาน​ฮ่วม​กั๋น​ว่า​จะ​บ่﻿กิ๋น​ข้าว​กิ๋น​น้ำ​จ๋น​กว่า​จะ​ฆ่า​เขา​ได้​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","คน​ตี้​มา​สุมหัว​กั๋น​มี​ประมาณ​สี่​สิบ​ป๋าย ");
INSERT INTO nod_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","แล้ว​หมู่​เขา​ก็​ไป​บอก​กับ​หมู่​หัวหน้า​ปุโรหิต​ตึง​หมู่​คน​เฒ่า​คน​แก่​ว่า “หมู่​เฮา​สาบาน​กั๋น​ไว้​แล้ว​ว่า จะ​บ่﻿กิ๋น​ข้าว​กิ๋น​น้ำ​จ๋นกว่า​จะ​ฆ่า​เปาโล​ได้​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ต๋อน​นี้​ขอ​หมู่​ต้าน​ใน​นาม​ของ​สภา​นี้ ไป​บอก​นายพัน​ปา​เปาโล​มา​หา​หมู่​ต้าน โดย​ขี้แต่ง​บอก​ว่า​หมู่​ต้าน​ใค่​สอบสวน​เรื่อง​ของ​เขา​หื้อ​แค้ม﻿ๆ นัก​ขึ้น แล้ว​หมู่​เฮา​จะ​ปา​กั๋น​เกิ็ด​ฆ่า​เขา​เหีย​ก่อน​ตี้​จะ​มา​แผว​ตี้​นี่” ");
INSERT INTO nod_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","แต่​ลูกบ่าว​ของ​น้องสาว​เปาโล​ได้ยิน​เรื่อง​แผนก๋าน​ฮ้าย​นี้​ก่อน จึง​เข้า​ไป​ใน​ป้อม​ทหาร​บอก​เปาโล ");
INSERT INTO nod_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","เปาโล​ฮ้อง​นายร้อย​คน​นึ่ง​มา​บอก​ว่า “ขอ​ปา​ป้อจาย​หนุ่ม​คน​นี้​ไป​หา​นายพัน​กำ​เต๊อะ เขา​มี​เรื่อง​สำคัญ​จะ​บอก​หื้อ​ต้าน​ฮู้” ");
INSERT INTO nod_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","นายร้อย​จึง​ปา​ป้อจาย​หนุ่ม​คน​นี้​ไป​หา​นายพัน​แล้ว​บอก​ว่า “นักโต้ษ​เปาโล​ขอ​ข้าพเจ้า​ปา​ป้อจาย​หนุ่ม​คน​นี้​มา​หา​ต้าน เขา​มี​เรื่อง​จะ​บอก​หื้อ​ต้าน​ฮู้” ");
INSERT INTO nod_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","นายพัน​จึง​จู๋ง​มือ​ป้อจาย​หนุ่ม​คน​นั้น​ไป​ห่าง​จาก​หมู่​คน​แล้ว​ถาม​ว่า “มี​อะหยัง​กา” ");
INSERT INTO nod_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ป้อจาย​หนุ่ม​ก็​ตอบ​ว่า “จาว​ยิว​ตกลง​กั๋น​ว่า​วัน​พูก​จะ​มา​ขอ​ต้าน​ปา​เปาโล​เข้า​ไป​ตี้​สภา​แซนเฮดริน​แหม หมู่​เขา​จะ​ขี้แต่ง​ใค่​ไต่​สวน​เรื่อง​เปาโล​หื้อ​แค้ม﻿ๆ แหม​หน้อย ");
INSERT INTO nod_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ขอ​ต้าน​ห้าม​เยียะ​ตวย​ต๋าม​ตี้​หมู่​เขา​ว่า​เน่อ หมู่​เขา​มี​คน​สี่​สิบ​ป๋าย​แน​ฆ่า​เปาโล​อยู่ ย้อน​หมู่​เขา​สาบาน​กั๋น​ว่า​จะ​บ่﻿กิ๋น​ข้าว​กิ๋น​น้ำ​จ๋น​กว่า​จะ​ฆ่า​ได้​เหีย​ก่อน ต๋อน​นี้​หมู่​เขา​ก็​เกียม​พร้อม​แล้ว ก่ำลัง​ถ้า​ต้าน​ว่า​จะ​ตกลง​ต๋าม​กำขอ​ของ​หมู่​เขา​ก่อ” ");
INSERT INTO nod_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","แล้ว​นายพัน​ก็​หื้อ​ป้อจาย​หนุ่ม​คน​นั้น​ปิ๊ก​ไป​เหีย สั่ง​นัก​สั่ง​หนา​ว่า “ห้าม​บอก​หื้อ​ใผ​ฮู้​เน่อ ว่า​เจ้า​มา​แจ้ง​เรื่อง​นี้​กับ​เฮา​แล้ว” ");
INSERT INTO nod_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","จาก​นั้น​นายพัน​ฮ้อง​นายร้อย​มา​สอง​คน​สั่ง​ว่า “หื้อ​ไป​เกียม​ทหาร​ราบ​สอง​ร้อย​นาย ทหารม้า​เจ็ด​สิบ​นาย ทหาร​หอก​แหม​สอง​ร้อย​นาย เกียม​ออก​เตียวตาง​ไป​เมือง​ซีซารียา​ต๋อน​สาม​ทุ่ม​คืน​นี้ ");
INSERT INTO nod_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","เกียม​ม้า​หื้อ​เปาโล​สัก​สอง​สาม​ตั๋ว แล้ว​คุ้ม​กั๋น​เขา​ไป​จ๋น​แผว​เจ้าเมือง​เฟลิกส์​อย่าง​ปลอดภัย” ");
INSERT INTO nod_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","แล้ว​นายพัน​ก็​เขียน​จดหมาย​ข้อความ​ว่า ");
INSERT INTO nod_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","เรียน​ต้าน​เจ้าเมือง​เฟลิกส์ จาก​ข้าพเจ้า​คลาวดิอัส ลีเซียส ");
INSERT INTO nod_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ป้อจาย​คน​นี้​ถูก​จาว​ยิว​ยับ​มา เขา​เกือบ​จะ​ถูก​คน​หมู่​นั้น​ฆ่า​ต๋าย แต่​ข้าพเจ้า​ปา​หมู่​ทหาร​ไป​จ้วย​เขา​ไว้ ย้อน​ข้าพเจ้า​ได้ยิน​มา​ว่า​เขา​เป๋น​คน​สัญจ้าด​โรมัน ");
INSERT INTO nod_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ข้าพเจ้า​ใค่​ฮู้​ว่า​จาว​ยิว​ใส่ความ​เขา​เรื่อง​อะหยัง​พ่อง จึง​ปา​ตั๋ว​เขา​ไป​ตี้​สภา​แซนเฮดริน ");
INSERT INTO nod_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ข้าพเจ้า​ก็​หัน​ว่า​เขา​ถูก​ฟ้อง​เรื่อง​เกี่ยวกับ​บท​บัญญัติ​ของ​จาว​ยิว แต่​บ่﻿มี​ความ​ผิด​เถิง​ขนาด​ต้อง​ถูก​ฆ่า​ต๋าย​กาว่า​ถูก​คอก ");
INSERT INTO nod_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","เมื่อ​ข้าพเจ้า​ฮู้​ว่า​มี​จาว​ยิว​หมู่​นึ่ง​วางแผน​จะ​ฆ่า​เขา ก็​เลย​ฟั่ง​ส่ง​เขา​มา​หา​ต้าน​ก่อน แล้ว​ก็​สั่ง​หื้อ​คน​หมู่​นั้น​ตี้​ใส่ความ​เขา​มา​ฟ้อง​ป้อจาย​คน​นี้​กับ​ต้าน​เอา​คน​เดียว ");
INSERT INTO nod_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","หมู่​ทหาร​ราบ​ก็​เยียะ​ต๋าม​ตี้​นายพัน​สั่ง ปา​เปาโล​ออก​เตียวตาง​ไป​จ๋น​แผว​เมือง​อันทิปาตรีส์​ใน​คืน​นั้น ");
INSERT INTO nod_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","วัน​ถัด​มา​หมู่​ทหาร​ราบ​ก็​ปา​กั๋น​ปิ๊ก​ไป​ป้อม​ทหาร แล้ว​หมู่​ทหารม้า​ก็​ปา​เปาโล​เตียวตาง​ต่อไป ");
INSERT INTO nod_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","เมื่อ​หมู่​ทหารม้า​มา​แผว​เมือง​ซีซารียา​แล้ว ก็​เอา​จดหมาย​ไป​หื้อ​เจ้าเมือง​กับ​มอบ​ตั๋ว​เปาโล​หื้อ​ตวย ");
INSERT INTO nod_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","เจ้าเมือง​อ่าน​จดหมาย แล้ว​ถาม​เปาโล​ว่า​มา​จาก​แคว้น​ไหน เมื่อ​ฮู้​ว่า​เปาโล​มา​จาก​แคว้น​ซีลีเซีย ");
INSERT INTO nod_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","เจ้าเมือง​จึง​บอก​ว่า “ข้า​จะ​ฟัง​กำ​หื้อก๋าน​ของ​เจ้า​เมื่อ​ฝ่าย​ตี้​ฟ้อง​มา​แผว​แล้ว” ต้าน​จึง​สั่ง​หื้อ​กุม​ตั๋ว​เปาโล​ไว้​ใน​วัง​เก่า​ของ​เฮโรด ");
INSERT INTO nod_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ห้า​วัน​ถัด​มา​อานาเนีย​มหา​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​บาง​คน ตึง​ทนาย​ความ​จื้อ​เทอร์ทูลลัส เตียวตาง​ลง​มา​จาก​กรุง​เยรูซาเล็ม​มา​แผว​เมือง​ซีซารียา​แล้ว ก็​ตั้ง​ข้อหา​ฟ้อง​เปาโล​ต่อ​หน้า​เจ้าเมือง ");
INSERT INTO nod_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","เจ้าเมือง​ฮ้อง​เปาโล​เข้า​มา แล้ว​เทอร์ทูลลัส​ก็​กล่าวหา​เปาโล​ต่อ​หน้า​เจ้าเมือง​เฟลิกส์​ว่า “ต้าน​เฟลิกส์​ตี้​เคารพ หมู่​เฮา​จาว​ยิว​อยู่​เย็น​เป๋น​สุข​จาก​ก๋าน​ปกครอง​ของ​ต้าน​มา​เป๋น​เวลา​เมิน​นาน กับ​ประเทศ​จ้าด​ของ​เฮา​ก็​ฮับ​ก๋าน​ปฏิรูป ย้อน​ต้าน​ผ่อ​ก๋ารณ์ไก๋ ");
INSERT INTO nod_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","หมู่​เฮา​ใคว่​ประเทศ​ขอบ​พระคุณ​ต้าน​อย่าง​ซาบซึ้ง​สำหรับ​สิ่ง​ดี﻿ๆ หมู่​นี้ ");
INSERT INTO nod_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ข้าพเจ้า​บ่﻿ใค่​เสีย​เวลา​ของ​ต้าน​นัก​ล้ำ​ไป ก็​ขอ​รบก๋วน​ต้าน​ฟัง​หมู่​เฮา​เล่า​ต่อ​แหม​สัก​หน้อย ");
INSERT INTO nod_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“หมู่​เฮา​หัน​ว่า ป้อจาย​คน​นี้​เป๋น​คน​อันตราย สุ่ย​หื้อ​เกิด​ก๋าน​จลาจล​ใน​หมู่​จาว​ยิว​ใน​กู้​ตี้ เขา​เป๋น​หัวหน้า​ลัทธิ​นาซาเร็ธ ");
INSERT INTO nod_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","เขา​ยัง​ฮิ​เยียะ​หื้อ​พระวิหาร​มัวหมอง หมู่​ข้าพเจ้า​เลย​ปา​กั๋น​ยับ​ตั๋ว​เขา ");
INSERT INTO nod_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ขอ​ต้าน​ลอง​สอบสวน​เขา​ผ่อ​เต๊อะ แล้ว​ต้าน​จะ​ฮู้​จาก​ปาก​ของ​เขา​ว่า กู้​สิ่ง​ตี้​เฮา​ตังหลาย​กล่าวหา​เขา​นั้น​เป๋น​ความ​จริง” ");
INSERT INTO nod_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","จาว​ยิว​คน​อื่น﻿ๆ ก็​เข้า​มา​ฮ่วม​ยืนยัน​ว่า ตี้​เทอร์ทูลลัส​อู้​มา​ตึงหมด​ก็​เป๋น​เรื่อง​แต๊ ");
INSERT INTO nod_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","เมื่อ​เจ้าเมือง​หื้อ​สัญญาณ​เปาโล​อู้ ต้าน​ก็​อู้​ว่า “ข้าพเจ้า​ฮู้​ว่า​ต้าน​เป๋น​ผู้​ตัดสิน​ความ​หื้อ​ประเทศ​นี้​มา​หลาย​ปี๋​แล้ว ข้าพเจ้า​จึง​สบายใจ๋​ตี้​จะ​แก้​ข้อ​กล่าวหา​ของ​ตั๋วเก่า​ต่อ​หน้า​ต้าน ");
INSERT INTO nod_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ถ้า​ต้าน​สอบถาม​ก็​จะ​ฮู้​ได้​เลย​ว่า ใน​เวลา​บ่﻿เกิ๋น​สิบ​สอง​วัน​มา​นี้ ข้าพเจ้า​ไป​กรุง​เยรูซาเล็ม​เปื้อ​นมัสก๋าน​พระเจ้า​ตี้​พระวิหาร ");
INSERT INTO nod_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","หมู่​เขา​บ่﻿หัน​ว่า​ข้าพเจ้า​เถียง​กับ​ใผ​ใน​พระวิหาร กาว่า​อู้​สุ่ย​หมู่​คน​ตี้​ธรรมศาลา​ของ​จาว​ยิว กาว่า​ตี้​อื่น﻿ๆ ใน​เมือง​ตวย ");
INSERT INTO nod_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","เรื่อง​ตึงหมด​ตี้​หมู่​เขา​ก่ำลัง​ฟ้อง​ข้าพเจ้า​นั้น หมู่​เขา​บ่﻿สามารถ​หา​ข้อ​พิสูจน์​ได้ ");
INSERT INTO nod_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ข้าพเจ้า​ยอมฮับ​ว่า​ได้​นมัสก๋าน​พระเจ้า​ของ​ป้ออุ๊ย​แม่หม่อน​ของ​ข้าพเจ้า โดย​เป๋น​ผู้​ติดต๋าม​ลัทธิ​นั้น​ตี้​ฮ้อง​ว่า ตาง​ของ​พระเยซู ตี้​หมู่​เขา​ฮ้อง​ว่า​เป๋น​ลัทธิ​นิก๋าย​นึ่ง ข้าพเจ้า​ก็​เจื้อถือ​กู้​อย่าง​ตี้​เขียน​ไว้​ใน​บท​บัญญัติ​ของ​โมเสส ตึง​ใน​หนังสือ​ของ​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ข้าพเจ้า​ก็​มี​ความ​หวัง​อย่าง​เดียว​กับ​หมู่​เขา​ว่า พระเจ้า​จะ​เยียะ​หื้อ​กู้​คน​ตึง​คน​ถูกต้อง​ต๋าม​ธรรม​กับ​คน​บ่﻿ดี​เป๋น​ขึ้น​จาก​ความ​ต๋าย ");
INSERT INTO nod_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ย้อนจาอั้น​ข้าพเจ้า​จึง​อุตส่าห์​เยียะ​กู้​สิ่ง​ด้วย​จิต​สำนึก​ตี้​บริสุทธิ์​ต่อ​พระเจ้า​กับ​มนุษย์​อย่าง​เป๋น​แต๊​เป๋น​ว่า​อยู่​เสมอ ");
INSERT INTO nod_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ต๋อน​หลัง​ตี้​ไป​จาก​กรุง​เยรูซาเล็ม​เป๋น​เวลา​หลาย​ปี๋ ข้าพเจ้า​ปิ๊ก​มา​เปื้อ​เอา​สตางค์​มา​จ้วยเหลือ​คน​ตุ๊ก​คน​ยาก​ใน​จ้าด​ของ​ข้าพเจ้า แล้ว​ก็​ลวด​ถวาย​เครื่อง​ปู่จา​พระเจ้า ");
INSERT INTO nod_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","เวลา​นั้น​หมู่​เขา​ก็​หัน​ข้าพเจ้า​ใน​พระวิหาร หลังจาก​ข้าพเจ้า​เยียะ​พิธี​ล้าง​ตั๋ว​หื้อ​บริสุทธิ์​แล้ว หมู่​เขา​ก็​หัน​ว่า​ข้าพเจ้า​บ่﻿ได้​อยู่​กับ​หมู่​คน กาว่า​ก่อ​ความ​วุ่นวาย ");
INSERT INTO nod_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","แต่​มี​จาว​ยิว​บาง​คน​ตี้​มา​จาก​แคว้น​เอเชีย​อยู่​ตี้​หั้น​ใน​วัน​นั้น ถ้า​เขา​หมู่​นั้น​มี​ข้อ​กล่าวหา​ข้าพเจ้า หมู่​เขา​น่า​จะ​มา​ฟ้อง​ข้าพเจ้า​ต่อ​หน้า​ต้าน​ตี้​นี่​ตวย ");
INSERT INTO nod_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","กาว่า​บ่﻿จาอั้น ก็​หื้อ​หมู่​คน​ตี้​มา​ตี้​นี่​บอก​ความ​ผิด​ตี้​ข้าพเจ้า​ถูก​ตัดสิน​ต๋อน​ตี้​อยู่​ต่อ​สภา​แซนเฮดริน​เต๊อะ แต่​บ่﻿มี​แม่น​ก่อ ");
INSERT INTO nod_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","เว้น​แต่​ว่า​ข้าพเจ้า​ถูก​สอบสวน​ต่อ​หน้า​ต้าน​ตังหลาย​ใน​วัน​นี้​ย้อน​เรื่อง​เดียว​เต้าอั้น ก็​คือ ข้าพเจ้า​ฮ้อง​ขึ้น​ใน​ตี้​ประชุม​นั้น​ว่า ‘ข้าพเจ้า​เจื้อ​ว่า​มี​ก๋าน​เป๋น​ขึ้น​จาก​ความ​ต๋าย’ ” ");
INSERT INTO nod_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","เฟลิกส์​ฮู้​เรื่อง​ลัทธิ​นั้น​ตี้​ฮ้อง​ว่า ตาง​ของ​พระเยซู ดี​อยู่​แล้ว ก็​เลื่อน​ก๋าน​พิจารณา​คดี​ออก​ไป​ก่อน บอก​ว่า “เมื่อ​นายพัน​ลีเซียส​มา​แผว เฮา​จะ​ตัดสิน​คดี​ของ​หมู่​ต้าน” ");
INSERT INTO nod_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","เขา​สั่ง​นายร้อย​หื้อ​กุม​ตั๋ว​เปาโล​ไว้ แต่​หื้อ​ลด​หย่อน​ก๋าน​กวดขัน​ลง​พ่อง แล้ว​หื้อ​เปื้อน﻿ๆ ของ​เปาโล​ผ่อกอย​จ้วยเหลือ​ใน​สิ่ง​ตี้​จ๋ำเป๋น ");
INSERT INTO nod_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","หลาย​วัน​ต่อ​มา​เฟลิกส์​มา​กับ​ดรูสิลลา​เมีย​ของ​เขา​ตี้​เป๋น​จาว​ยิว แล้ว​เฟลิกส์​สั่ง​หื้อ​ปา​เปาโล​มา​หา แล้ว​ฟัง​เปาโล​อู้​เรื่อง​ก๋าน​เจื้อ​พระเยซู​คริสต์ ");
INSERT INTO nod_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","แต่​เมื่อ​เปาโล​อู้​เถิง​ความ​ยุติธรรม ก๋าน​ห้ามใจ๋ กับ​วัน​ตี้​พระเจ้า​จะ​ตัดสิน​กู้​คน​สำหรับ​สิ่ง​ดี​กับ​สิ่ง​บ่﻿ดี​ตี้​เกย​เยียะ เฟลิกส์​ก็​เกิด​กั๋ว​ขึ้น​มา​อู้​ว่า “เอา​ละ วัน​นี้​ปอ​เต้าอี้​ก่อน ไป​ได้​แล้ว เอา​ไว้​เฮา​มี​เวลา​จะ​ฮ้อง​มา​แหม​ใหม่” ");
INSERT INTO nod_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ใน​เวลา​เดียว​กั๋น​นั้น เฟลิกส์​ก็​หวัง​ว่า เปาโล​จะ​ติด​สินบน เขา​จึง​ฮ้อง​เปาโล​มา​อู้​ตวย​เจื่อ​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ผ่าน​ไป​แล้ว​สอง​ปี๋ ปอรสิอัส​เฟสทัส ก็​มา​ฮับ​ต๋ำแหน่ง​เจ้าเมือง​แตน​เฟลิกส์ แต่​เนื่อง​จาก​เฟลิกส์​ใค่​เอาใจ๋​จาว​ยิว​ก่อน​ออก​จาก​ต๋ำแหน่ง ก็​ยัง​ละ​หื้อ​เปาโล​ติด​คอก​ตี้​หั้น​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","เมื่อ​เฟสทัส​เข้า​ฮับ​ต๋ำแหน่ง​เจ้าเมือง​ได้​สาม​วัน ก็​เตียวตาง​จาก​เมือง​ซีซารียา​ไป​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ตี้​หั้น​หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​ผู้นำ​จาว​ยิว​ยื่น​ข้อ​กล่าวหา​เปาโล​ต่อ​เฟสทัส ");
INSERT INTO nod_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","แล้ว​อ้อนวอน​เฟสทัส​ขอ​ความ​กรุณา​หื้อ​จ้วย​ส่ง​เปาโล​มา​ตี้​กรุง​เยรูซาเล็ม​ตวย หมู่​เขา​เยียะ​จาอี้​ย้อน​ว่า​วางแผน​จะ​ฆ่า​เปาโล​หละหว่าง​ตาง ");
INSERT INTO nod_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","เฟสทัส​ตอบ​ว่า “เปาโล​ถูก​กุม​ตั๋ว​อยู่​ตี้​เมือง​ซีซารียา แหม​บ่﻿เมิน​เต้าใด​เฮา​ก็​จะ​ปิ๊ก​ไป​ตี้​หั้น​แล้ว ");
INSERT INTO nod_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","หื้อ​ผู้นำ​ใน​หมู่​ต้าน​ลง​ไป​ตวย​เฮา ถ้า​เปาโล​มี​ความ​ผิด​อย่าง​นึ่ง​อย่างใด​ก็​หื้อ​หมู่​เขา​ฟ้อง​เปาโล​ตี้​หั้น” ");
INSERT INTO nod_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","หลังจาก​อยู่​กับ​หมู่​เขา​ได้​แปด​วัน​กาว่า​สิบ​วัน เฟสทัส​ก็​ปิ๊ก​ไป​เมือง​ซีซารียา วัน​ถัด​มา​ต้าน​ก็​เปิด​ศาล​ตัดสิน แล้ว​สั่ง​หื้อ​ปา​เปาโล​เข้า​มา ");
INSERT INTO nod_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","เมื่อ​เปาโล​มา​แผว​แล้ว หมู่​จาว​ยิว​ตี้​มา​จาก​กรุง​เยรูซาเล็ม​ก็​มา​ยืน​แวด​ตะหลุ้ม​กล่าวหา​ว่า เปาโล​เยียะ​ผิด​ฮ้ายแฮง​หลาย​อย่าง แต่​ข้อหา​หมู่​นั้น หมู่​เขา​พิสูจน์​บ่﻿ได้​สัก​ข้อ ");
INSERT INTO nod_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","แล้ว​เปาโล​ก็​แก้​ข้อ​กล่าวหา​ว่า “ข้าพเจ้า​บ่﻿ได้​เยียะ​อะหยัง​ผิด​ต่อ​บท​บัญญัติ​ของ​จาว​ยิว กาว่า​ต่อ​พระวิหาร กาว่า​ต่อ​ซีซาร์​เน่อ” ");
INSERT INTO nod_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","แต่​เฟสทัส​ใค่​เอาใจ๋​จาว​ยิว​จึง​ถาม​เปาโล​ว่า “เจ้า​ใค่​ไป​กรุง​เยรูซาเล็ม​ก่อ เปื้อ​สู้​คดี​ตี้​ถูก​กล่าวหา​นี้​ต่อ​หน้า​เฮา​ตี้​หั้น” ");
INSERT INTO nod_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","เปาโล​ตอบ​ว่า “ต๋อน​นี้​ข้าพเจ้า​ก็​ก่ำลัง​อยู่​ต่อ​หน้า​ศาล​ของ​ซีซาร์ ข้าพเจ้า​ควร​จะ​ได้​ฮับ​ก๋าน​ตัดสิน​ตี้​นี่ ต้าน​ก็​ฮู้​ดี​ว่า​ข้าพเจ้า​บ่﻿ได้​เยียะ​ผิด​อะหยัง​ต่อ​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ถ้า​ข้าพเจ้า​เยียะ​ผิด​แต๊ กาว่า​เยียะ​อะหยัง​ตี้​สมควร​ต๋าย ข้าพเจ้า​ก็​ยอม​ต๋าย​บ่﻿ขัดขืน​สัก​อย่าง แต่​ถ้า​ข้อ​กล่าวหา​หมู่​นี้​เอา​มา​ฟ้อง​เป๋น​เรื่อง​บ่﻿แต๊ ใผ​ก็​บ่﻿มี​สิทธิ์​จะ​ส่ง​ข้าพเจ้า​ไป​หื้อ​กับ​หมู่​นี้ ข้าพเจ้า​ขอ​ถวาย​ฎีกา​ต่อ​ซีซาร์” ");
INSERT INTO nod_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","หลังจาก​เฟสทัส​หารือ​กับ​ตี้เปิ็กษา​แล้ว ก็​บอก​ว่า “ย้อน​เจ้า​ถวาย​ฎีกา​เถิง​ซีซาร์ ก็​จะ​ต้อง​ไป​เข้า​เฝ้า​ซีซาร์” ");
INSERT INTO nod_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","หลาย​วัน​ต่อ​มา​กษัตริย์​อากริปปา​กับ​พระนาง​เบอร์นิส​น้องสาว​ของ​พระองค์ มา​ต้อนฮับ​เฟสทัส​ตี้​เมือง​ซีซารียา ");
INSERT INTO nod_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ใน​หละหว่าง​ตี้​กษัตริย์​อากริปปา​อยู่​ตี้​หั้น​หลาย​วัน เฟสทัส​ก็​เล่า​เรื่อง​คดี​ของ​เปาโล​หื้อ​ฟัง​ว่า “ตี้​นี่​มี​ป้อจาย​คน​นึ่ง​เป๋น​นักโต้ษ​ตี้​เฟลิกส์​ขัง​คอก​ไว้ ");
INSERT INTO nod_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ต๋อน​ตี้​ข้าพเจ้า​อยู่​ใน​กรุง​เยรูซาเล็ม หมู่​หัวหน้า​ปุโรหิต​กับ​หมู่​คน​เฒ่า​คน​แก่​จาว​ยิว​เอา​คดี​ของ​ป้อจาย​คน​นี้​มา​ยื่น​ฟ้อง​ต่อ​ข้าพเจ้า กับ​ขอ​หื้อ​ตัดสิน​ลงโต้ษ​เขา ");
INSERT INTO nod_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ข้าพเจ้า​บอก​หมู่​เขา​ว่า ต๋าม​ธรรมเนียม​ของ​จาว​โรมัน​จะ​บ่﻿มอบ​ตั๋ว​นักโต้ษ​หื้อ​ใผ จ๋น​กว่า​คน​ฟ้อง​กับ​คน​ตี้​ถูก​ฟ้อง​มา​อยู่​ส่อง​หน้า​กั๋น เปื้อ​หื้อ​คน​ตี้​ถูก​ฟ้อง​มี​โอกาส​แก้​ข้อ​กล่าวหา​เหีย​ก่อน ");
INSERT INTO nod_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“เมื่อ​หมู่​เขา​ตวย​ข้าพเจ้า​มา​ตี้​นี่ ข้าพเจ้า​ก็​บ่﻿รอ​จ๊า แหม​วัน​ถัด​ไป ข้าพเจ้า​ก็​เปิด​ศาล​ตัดสิน​แล้ว​สั่ง​หื้อ​ปา​ตั๋ว​ป้อจาย​คน​นั้น​เข้า​มา ");
INSERT INTO nod_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","เมื่อ​หมู่​ตี้​ฟ้อง​เขา​ยืน​ขึ้น​กล่าวหา​เขา ข้าพเจ้า​ก็​หัน​ว่า​ข้อ​กล่าวหา​นั้น​บ่﻿ใจ้​เรื่อง​ฮ้ายแฮง​อย่าง​ตี้​กึ๊ด​ไว้ ");
INSERT INTO nod_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","แต่​เป๋น​ก๋าน​โต้เถียง​กั๋น​เกี่ยวกับ​ศาสนา​ของ​หมู่​เขา​เหีย กับ​เรื่อง​ป้อจาย​คน​นึ่ง​จื้อ​เยซู​ตี้​ต๋าย​ไป​แล้ว แต่​เปาโล​ยืนยัน​ว่า​ยัง​มี​จีวิต​อยู่ ");
INSERT INTO nod_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ข้าพเจ้า​บ่﻿ฮู้​ว่า​จะ​สอบสวน​เรื่อง​หมู่​นี้​จาใด​ดี จึง​ถาม​เปาโล​ว่า​เขา​ใค่​ไป​กรุง​เยรูซาเล็ม​เปื้อ​สู้​คดี​นี้​ตี้​หั้น​ก่อ ");
INSERT INTO nod_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","แต่​เขา​ขอ​ถวาย​ฎีกา​เถิง​ซีซาร์ ข้าพเจ้า​จึง​สั่ง​หื้อ​กุม​ตั๋ว​เขา​ไว้​ก่อน จ๋น​กว่า​จะ​ส่ง​ตั๋ว​เขา​ไป​หื้อ​ซีซาร์” ");
INSERT INTO nod_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","แล้ว​กษัตริย์​อากริปปา​ก็​อู้​กับ​เฟสทัส​ว่า “ข้าพเจ้า​ก็​ใค่​ฟัง​จาก​ปาก​ของ​ป้อจาย​คน​นี้​ตวย” เฟสทัส​ตอบ​ว่า “วัน​พูก​ต้าน​จะ​ได้​ฟัง​เขา” ");
INSERT INTO nod_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ใน​วัน​ถัด​มา​กษัตริย์​อากริปปา​กับ​พระนาง​เบอร์นิส​เข้า​ไป​ใน​ห้องโถง​ใหญ่​ด้วย​ขบวน​แห่​อย่าง​ยิ่งใหญ่ หมู่​เขา​มา​ตวย​กั๋น​กับ​หมู่​ผู้​บังคับ​บัญชา​ทหาร​กับ​ผู้นำ​คน​สำคัญ﻿ๆ ของ​เมือง แล้ว​เฟสทัส​สั่ง​หื้อ​ปา​เปาโล​เข้า​มา ");
INSERT INTO nod_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","จาก​นั้น​เฟสทัส​ก็​อู้​ว่า “กษัตริย์​อากริปปา​กับ​ต้าน​ตังหลาย​ตี้​อยู่​ตี้​นี่ หมู่​ต้าน​หัน​ป้อจาย​คน​นี้​แล้ว เขา​เป๋น​คน​ตี้​จาว​ยิว​ตังหลาย​ใน​เมือง​นี้​ตึง​ตี้​กรุง​เยรูซาเล็ม​ฮ้อง​เอิ้น​กับ​ข้าพเจ้า​ว่า เขา​บ่﻿สมควร​ตี้​จะ​มี​จีวิต​อยู่​ต่อ​ไป ");
INSERT INTO nod_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","แต่​ข้าพเจ้า​หัน​ว่า​เขา​บ่﻿ได้​เยียะ​อะหยัง​ผิด​เถิง​ต้อง​ต๋าย เมื่อ​เขา​ถวาย​ฎีกา​เถิง​ซีซาร์ ข้าพเจ้า​จึง​ตกลง​ว่า​จะ​ส่ง​เขา​ไป​ขึ้น​ศาล​ตี้​กรุง​โรม ");
INSERT INTO nod_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","แต่​ข้าพเจ้า​บ่﻿ฮู้​ว่า​จะ​เขียน​รายงาน​ต่อ​พระองค์​เกี่ยวกับ​ป้อจาย​คน​นี้​จาใด​ดี ก็​เลย​ปา​เขา​มา​อยู่​ต่อ​หน้า​หมู่​ต้าน โดย​เฉพาะ​อย่าง​ยิ่ง​ตี้​อยู่​ต่อ​หน้า​กษัตริย์​อากริปปา ตี้​ฮู้​บท​บัญญัติ​ของ​จาว​ยิว​เป๋น​อย่าง​ดี เปื้อ​ก๋าน​สอบสวน​เตื้อ​นี้​จะ​ออก​ผล​ปอ​ตี้​จะ​เขียน​รายงาน​ได้ ");
INSERT INTO nod_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ย้อน​ข้าพเจ้า​ฮู้สึก​ว่า​บ่﻿เปิง​ตี้​จะ​ส่ง​ตั๋ว​นักโต้ษ​ไป​หื้อ​ซีซาร์ โดย​บ่﻿เจาะจง​ว่า​เขา​เยียะ​อะหยัง​ผิด​พ่อง” ");
INSERT INTO nod_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","กษัตริย์​อากริปปา​บอก​กับ​เปาโล​ว่า “เฮา​อนุญาต​หื้อ​เจ้า​อู้​แก้​ข้อ​กล่าวหา​หื้อ​ตั๋ว​เก่า​ได้” เปาโล​ก็​ยื่น​มือ​แล้ว​ตั้งเก๊า​แก้​ข้อ​กล่าวหา​ว่า ");
INSERT INTO nod_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ต้าน​กษัตริย์​อากริปปา ข้าพเจ้า​ถือ​ว่า​เป๋น​โอกาส​ดี​แต๊﻿ๆ ตี้​ได้​อยู่​ต่อ​หน้า​พระองค์​ใน​วัน​นี้ เปื้อ​แก้​ข้อ​กล่าวหา​ตึงหมด​ตี้​หมู่​จาว​ยิว​ใส่ความ​ข้าพเจ้า​นั้น ");
INSERT INTO nod_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ย้อน​ต้าน​กษัตริย์​ก็​ฮู้​ฮีต​เก่า​ฮอย​เดิม​กับ​ข้อ​โต้แย้ง​ต่าง﻿ๆ ของ​จาว​ยิว​เป๋น​อย่าง​ดี ย้อนจาอั้น ขอ​พระองค์​อดทน​ฟัง​ข้าพเจ้า​หน้อย​เน่อ ");
INSERT INTO nod_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“จาว​ยิว​ฮู้​หัน​ข้าพเจ้า​มา​ตั้งแต่​เป๋น​หละอ่อน​ตี้​บ้าน​เกิด กับ​ต๋อน​ตี้​ข้าพเจ้า​อยู่​ต้ามก๋าง​หมู่​เขา​ใน​กรุง​เยรูซาเล็ม ");
INSERT INTO nod_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","หมู่​เขา​ฮู้จัก​ข้าพเจ้า​เมิน​มา​แล้ว ถ้า​หมู่​เขา​จะ​ยอม​เป๋น​พยาน​หื้อ​ข้าพเจ้า ก็​จะ​ยืนยัน​ว่า​ข้าพเจ้า​เป๋น​สมาชิก​ฟาริสี เป๋น​หมู่​คน​ตี้​เคร่ง​ศาสนา​ตี้สุด​ใน​หมู่​จาว​ยิว ");
INSERT INTO nod_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","บ่าเดี่ยวนี้​ตี้​ข้าพเจ้า​ถูก​สอบสวน​อยู่​นี้ ก็​ย้อน​ว่า​ข้าพเจ้า​มี​ความ​หวัง​ใน​สิ่ง​ตี้​พระเจ้า​สัญญา​ไว้​กับ​ป้ออุ๊ย​แม่หม่อน​ของ​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","เป๋น​พระสัญญา​ตี้​สิบ​สอง​ผะกุ๋น​ของ​หมู่​เฮา​หวัง​ว่า​จะ​เป๋น​แต๊ จึง​ฮับใจ๊​พระเจ้า​อย่าง​เอา​แต๊​เอา​ว่า​ตึง​เมื่อวัน​เมื่อคืน ข้า​แต่​กษัตริย์ หมู่​จาว​ยิว​ใส่ความ​ข้าพเจ้า​ก็​ย้อน​ความ​หวัง​อัน​นี้​ละ ");
INSERT INTO nod_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","เป๋น​จาใด​ต้าน​ตังหลาย​เจื้อ​ว่า พระเจ้า​เยียะ​หื้อ​คน​เป๋น​ขึ้น​จาก​ความ​ต๋าย​นั้น​เป๋น​ไป​ตึง​บ่﻿ได้ ");
INSERT INTO nod_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ข้าพเจ้า​ก็​เกย​กึ๊ด​ว่า​จ๋ำเป๋น​ต้อง​ขัดขวาง​จื้อ​ของ​พระเยซู​จาว​นาซาเร็ธ​เต้า​ตี้​จะ​เยียะ​ได้ ");
INSERT INTO nod_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ข้าพเจ้า​ก็​เยียะ​จาอั้น​แล้ว​ใน​กรุง​เยรูซาเล็ม ข้าพเจ้า​ได้​ฮับ​สิทธิ​อำนาจ​จาก​หมู่​หัวหน้า​ปุโรหิต​หื้อ​ยับ​คน​ตี้​เจื้อ​พระเยซู​ไป​ขัง​คอก เมื่อ​หมู่​นั้น​ถูก​ลงโต้ษ​เถิง​ต๋าย ข้าพเจ้า​ก็​หัน​ดี​หัน​งาม​ตวย ");
INSERT INTO nod_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ข้าพเจ้า​ยับ​เอา​เขา​หมู่​นั้น​ต๋าม​ธรรมศาลา​ต่าง﻿ๆ มา​ลงโต้ษ​เจื่อ​ขนาด กับ​ฮิ​บังคับ​หื้อ​หมู่​เขา​อู้​ดู​แควน​พระเยซู ข้าพเจ้า​ตึง​โขด​ตึง​จัง​คน​หมู่​นี้​ขนาด เถิง​กับ​เตียวตาง​ไป​ค่ำ​คน​หมู่​นี้​เถิง​เมือง​ใน​ต่าง​ประเทศ ");
INSERT INTO nod_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ใน​ก๋าน​เตียวตาง​ไป​ยับ​หมู่​ผู้เจื้อ​แบบ​นี้ มี​เตื้อ​นึ่ง​ข้าพเจ้า​ไป​เมือง​ดามัสกัส โดย​ได้​ฮับ​สิทธิ​อำนาจ​กับ​กำสั่ง​จาก​หมู่​หัวหน้า​ปุโรหิต​หื้อ​ไป​ยับ​หมู่​คน​ตี้​เจื้อ​พระเยซู​ตี้​หั้น ");
INSERT INTO nod_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ข้า​แต่​กษัตริย์ เวลา​ประมาณ​เตี้ยงวัน​ต๋อน​ตี้​ข้าพเจ้า​ก่ำลัง​เตียวตาง​อยู่​นั้น ข้าพเจ้า​ก็​หัน​แสง​แจ้ง​จาก​ต๊องฟ้า​แจ้ง​เหลือ​แสง​ตะวัน ส่อง​ลง​มา​ตี้​ตั๋ว​ข้าพเจ้า​ตึง​คน​ตังหลาย​ตี้​ไป​ตวย​กั๋น​กับ​ข้าพเจ้า ");
INSERT INTO nod_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","หมู่​เฮา​ตึงหมด​โก้น​ลง​ดิน แล้ว​ข้าพเจ้า​ก็​ได้ยิน​เสียง​อู้​กับ​ข้าพเจ้า​เป๋น​ภาษา​ฮีบรู​ว่า ‘เซาโล เซาโล​เหย เจ้า​ค่ำ​เฮา​เยียะ​หยัง ก๋าน​ตี้​เจ้า​ขัดขืน​เฮา​ก็​เยียะ​หื้อ​ตั๋ว​เก่า​เจ็บ​เหมือน​งัว​เตะ​เหล็ก​เหลี้ยม​ของ​เจ้าของ’ ");
INSERT INTO nod_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ข้าพเจ้า​ก็​ถาม​ว่า ‘พระองค์​เจ้าข้า พระองค์​เป๋น​ใผ’ แล้ว​พระองค์​ตอบ​ว่า ‘เฮา​คือ​เยซู​ผู้​ตี้​เจ้า​ค่ำ​นั้น​ละ ");
INSERT INTO nod_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ลุก​ขึ้น​เต๊อะ ตี้​เฮา​มา​หา​เจ้า​ก็​เปื้อ​จะ​แต่งตั้ง​เจ้า​หื้อ​เป๋น​ผู้​ฮับใจ๊​เฮา กับ​เป๋น​พยาน​อู้​หื้อ​คน​อื่น​ฟัง​เถิง​เหตุก๋ารณ์​ตี้​เจ้า​ได้​หัน​เฮา กับ​เรื่อง​ตี้​เฮา​จะ​สำแดง​หื้อ​ฮู้​ใน​ปาย​หน้า ");
INSERT INTO nod_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","เฮา​จะ​จ้วยเหลือ​เจ้า​หื้อ​รอด​ป๊น​จาก​จาว​ยิว​กับ​คน​ต่างจ้าด​ตี้​เฮา​จะ​ใจ๊​เจ้า​ไป​หา​นั้น ");
INSERT INTO nod_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","เปื้อ​เปิด​หู​เปิด​ต๋า​ของ​หมู่​เขา​หื้อ​บิ่นหลังต๋ำ​จาก​ความ​มืด​เข้า​มา​หา​ความ​เป่งแจ้ง กับ​จาก​อำนาจ​ของ​ซาต๋าน​เข้า​มา​หา​พระเจ้า เปื้อ​เขา​หมู่​นั้น​จะ​ฮับ​ก๋าน​ยกโต้ษ​บาป แล้ว​เป๋น​สมาชิก​ฮ่วม​กั๋น​กับ​หมู่​คน​ตี้​พระเจ้า​เลือก​ไว้​เป๋น​คน​ของ​พระองค์ โดย​ความ​เจื้อ​ใน​เฮา’ ");
INSERT INTO nod_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“ข้า​แต่​กษัตริย์​อากริปปา หลังจาก​นั้น ข้าพเจ้า​จึง​เจื้อฟัง​นิมิต​ตี้​มา​จาก​สวรรค์​นั้น​ตึง​บ่﻿ขัดขืน​เลย ");
INSERT INTO nod_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ข้าพเจ้า​ตั้งเก๊า​เตสนา​สั่ง​สอน​ใน​เมือง​ดามัสกัส​ก่อน แล้ว​ก็​ใน​กรุง​เยรูซาเล็ม​ตึง​ใคว่​แคว้น​ยูเดีย​กับ​ต้ามก๋าง​คน​ต่างจ้าด​ตวย ข้าพเจ้า​บอก​หื้อ​หมู่​เขา​กลับใจ๋​จาก​บาป​มา​หา​พระเจ้า​เหีย แล้ว​เยียะ​สิ่ง​ตี้​แสดง​ว่า​กลับใจ๋​แต๊﻿ๆ ");
INSERT INTO nod_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ย้อนจาอี้​หมู่​จาว​ยิว​เข้า​มา​ยับ​ข้าพเจ้า​ต๋อน​ตี้​อยู่​ใน​พระวิหาร แล้ว​ฮิ​จะ​ฆ่า​ข้าพเจ้า​เหีย ");
INSERT INTO nod_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","แต่​พระเจ้า​ก็​จ้วย​ข้าพเจ้า​มา​จ๋น​แผว​ตึง​วันนี้ ข้าพเจ้า​จึง​มา​ยืน​เป๋น​พยาน​ต่อ​ต้าน​ตังหลาย​ตึง​ผู้​หน้อย​ผู้ใหญ่​ใน​ตี้​นี่​ได้ ข้าพเจ้า​บ่﻿ได้​อู้​เรื่อง​อื่น﻿ๆ นอกจาก​สิ่ง​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​กับ​โมเสส​บอก​ไว้​ว่า​จะ​เกิด​ขึ้น ");
INSERT INTO nod_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","สิ่ง​นั้น​ก็​คือ​พระคริสต์​จะ​ต้อง​ทน​ตุ๊ก​ทรมาน​จ๋น​ต๋าย แล้ว​พระองค์​จะ​เป๋น​ขึ้น​จาก​ความ​ต๋าย​ก่อน​เปิ้น เป๋น​ก๋าน​แสดง​ความ​เป่งแจ้ง​มา​สู่​จาว​ยิว​ตึง​คน​ต่างจ้าด คือ​ความ​รอด​ป๊น​บาป​โต้ษ” ");
INSERT INTO nod_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ใน​เวลา​ตี้​เปาโล​ก่ำลัง​อู้​แก้​ข้อ​กล่าวหา​อยู่​นั้น เฟสทัส​ก็​ขัด​จั๋งหวะ​เอ็ก​ใส่​เปาโล​ว่า “เปาโล เจ้า​เพี้ยน​ไป​แล้ว เจ้า​เฮียน​นัก​ล้ำ​ไป เยียะ​หื้อ​เป๋น​ผีบ้า” ");
INSERT INTO nod_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","แต่​เปาโล​ตอบ​ว่า “ต้าน​เฟสทัส ข้าพเจ้า​บ่﻿เป๋น​ผีบ้า แต่​สิ่ง​ตี้​ข้าพเจ้า​อู้​มา​นี้​เป๋น​เรื่อง​แต๊ ข้าพเจ้า​อู้​อย่าง​คน​ปกติ ");
INSERT INTO nod_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ต้าน​กษัตริย์​อากริปปา​ก็​ฮู้​เรื่อง​หมู่​นี้​ดี​อยู่​แล้ว ข้าพเจ้า​ก็​บ่﻿กั๋ว​ตี้​จะ​อู้​อย่าง​เปิดเผย​กับ​พระองค์ ข้าพเจ้า​แน่​ใจ๋​ว่า​พระองค์​ได้​สังเกต​หัน​ใน​สิ่ง​ตี้​ข้าพเจ้า​อู้​เกี่ยวกับ​พระเยซู ย้อน​ว่า​เรื่อง​หมู่​นี้​บ่﻿ได้​เกิด​ขึ้น​ใน​ตี้​ลับลี้ ");
INSERT INTO nod_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ข้า​แต่​กษัตริย์​อากริปปา พระองค์​เจื้อ​สิ่ง​ตี้​ผู้​เป๋น​ปาก​เป๋น​เสียง​แตน​พระเจ้า​เขียน​ไว้​ก่อ ข้าพเจ้า​ฮู้​แน่​ว่า​พระองค์​เจื้อ” ");
INSERT INTO nod_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","กษัตริย์​อากริปปา​ก็​เลย​อู้​กับ​เปาโล​ว่า “เจ้า​กึ๊ด​ว่า​เจ้า​จะ​จั๊กจวน​หื้อ​เฮา​เป๋น​คริสเตียน​ใน​เวลา​สั้น﻿ๆ จาอั้น​กา” ");
INSERT INTO nod_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","เปาโล​ก็​ตอบ​ว่า “บ่﻿ว่า​จะ​เป๋น​เวลา​หน้อย​กาว่า​เวลา​นัก​ก็​ต๋าม ข้าพเจ้า​อธิษฐาน​ต่อ​พระเจ้า​ขอ​หื้อ​กษัตริย์​กับ​กู้​คน​ตี้​ได้​ฟัง​ข้าพเจ้า​ใน​วัน​นี้​เป๋น​เหมือน​อย่าง​ข้าพเจ้า ยกเว้น​บ่﻿ถูก​เจื้อก​เหล็ก​ล่าม​อย่าง​ข้าพเจ้า” ");
INSERT INTO nod_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","จาก​นั้น​กษัตริย์​อากริปปา เจ้าเมือง พระนาง​เบอร์นิส กับ​คน​อื่น﻿ๆ ตี้​นั่ง​อยู่​ตวย​กั๋น​หั้น ก็​ปา​กั๋น​ลุก​ขึ้น​ออก​ไป​หมด ");
INSERT INTO nod_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","หลังจาก​หมู่​เขา​ออก​ไป​จาก​ห้อง​แล้ว ก็​อู้​กั๋น​ว่า “ป้อจาย​คน​นี้​บ่﻿ได้​เยียะ​อะหยัง​ตี้​สมควร​ต๋าย กาว่า​สมควร​ถูก​ขัง​คอก​สัก​หน้อย” ");
INSERT INTO nod_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","แล้ว​กษัตริย์​อากริปปา​ก็​อู้​กับ​เฟสทัส​ว่า “ถ้า​ป้อจาย​คน​นี้​บ่﻿ได้​ถวาย​ฎีกา​เถิง​ซีซาร์ จะ​ปล่อย​เขา​ไป​ก็​ได้” ");
INSERT INTO nod_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","หลังจาก​หมู่​เฮา​ได้​ฮับ​ก๋าน​ตัดสิน​เรื่อง​เวลา​ตี้​จะ​เตียวตาง​ไป​ประเทศ​อิตาลี​แล้ว เปาโล​กับ​นักโต้ษ​คน​อื่น﻿ๆ ก็​ถูก​กุม​ตั๋ว​ไว้​กับ​นายร้อย​คน​นึ่ง​จื้อ​ยูเลียส มา​จาก​ก๋องทหาร​จักรพรรดิ​ออกัสตัส ");
INSERT INTO nod_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","มี​เฮือ​ลำ​นึ่ง​มา​จาก​เมือง​อัดรามิททิยุม เฮือ​ลำ​นี้​ก่ำลัง​จะ​ไป​ต๋าม​ต้าเฮือ​ต่าง﻿ๆ ต๋าม​แนว​ฝั่ง​ของ​แคว้น​เอเชีย หมู่​เฮา​ก็​ลง​เฮือ​ลำ​นี้​ออก​ทะเล​ไป มี​จาว​มาซิโดเนีย​คน​นึ่ง​จื้อ​อาริสทารคัส เขา​ลุก​จาก​เมือง​เธสะโลนิก๋า​ไป​กับ​หมู่​เฮา​ตวย ");
INSERT INTO nod_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","วัน​ถัด​มา​หมู่​เฮา​ก็​มา​แผว​ต้าเฮือ​เมือง​ไซดอน ยูเลียส​ดี​ต่อ​เปาโล​ขนาด ยอม​หื้อ​เปาโล​ไป​แอ่ว​หา​หมู่​เปื้อน﻿ๆ ได้ เปื้อ​เขา​หมู่​นั้น​จะ​จ้วยเหลือ​ต้าน​ต๋าม​ความ​จ๋ำเป๋น ");
INSERT INTO nod_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","เฮือ​ของ​หมู่​เฮา​แล่น​ออก​จาก​เมือง​ไซดอน มี​ลม​ปั๊ด​มา​แฮง​ขนาด หมู่​เฮา​จึง​บิ่น​หัวเฮือ​ไป​ตัง​เกาะ​ไซปรัส​ตี้​ลม​บ่﻿ปอ​แฮง ");
INSERT INTO nod_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","หมู่​เฮา​แล่น​เฮือ​ข้าม​ทะเล​ก๋าย​เขต​ของ​แคว้น​ซีลีเซีย​กับ​แคว้น​ปัมฟีเลีย จ๋น​มา​แผว​เมือง​มิรา​ใน​แคว้น​ลิเซีย ");
INSERT INTO nod_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ตี้​นี่​นายร้อย​ปะ​เฮือ​ลำ​นึ่ง​มา​จาก​เมือง​อเล็กซานเดรีย​ก่ำลัง​จะ​ไป​ประเทศ​อิตาลี เขา​เลย​ปา​หมู่​เฮา​ลง​เฮือ​ลำ​นั้น ");
INSERT INTO nod_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","เฮือ​ของ​หมู่​เฮา​ไป​จ๊า​ขนาด ใจ๊​เวลา​หลาย​วัน ใน​ตี้สุด​ก็​มา​เถิง​เมือง​คนีดัส​อย่าง​ยาก​ลำบาก เฮา​บ่﻿สามารถ​ไป​ต่อ​ได้​ย้อน​ลม​ตั้ง​แฮง​ขนาด จึง​เปี่ยน​เส้นตาง​ไป​ตัง​ลม​ปั๊ด​บ่﻿ปอ​แฮง​ของ​เกาะ​ครีต​ใก้​แหลม​สัลโมเน ");
INSERT INTO nod_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","เฮือ​แล่น​เลาะ​ฝั่ง​เกาะ​ครีต​ไป​อย่าง​ยาก​ลำบาก แล้ว​ก็​มา​แผว​ตี้​นึ่ง ตี้​จื้อ​มี​ความหมาย​ว่า ต้า​เฮือ​งาม ตี้​หั้น​อยู่​ฮิม​เมือง​ลาเซีย ");
INSERT INTO nod_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","หมู่​เฮา​เสีย​เวลา​นัก​เหมือน​กั๋น ถ้า​จะ​แล่น​เฮือ​ต่อ​ต๋อน​นี้​ก็​อันตราย​ล้ำ​ไป ย้อน​หาก​ป๊น​หละหว่าง​งาน​ถือ​ศีล​อด​อาหาร​ไป​แล้ว จะ​เป๋น​เวลา​ตี้​ฝน​ตก​หนัก กับ​ใน​ทะเล​จะ​มี​คลื่น​ลม​แฮง เปาโล​จึง​เตื๋อน​สติ​หมู่​เขา​ว่า ");
INSERT INTO nod_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ต้าน​ตังหลาย ข้าพเจ้า​หัน​ว่า​ก๋าน​เตียวตาง​หน​นี้​จะ​มี​อันตราย ตี้​จะ​เยียะ​หื้อ​มี​ความ​เสียหาย​อย่าง​ใหญ่​หลวง ตึง​สินก๊า​ตี้​ขน​มา ตึง​เฮือ ตึง​จีวิต​ของ​หมู่​เฮา​ตวย” ");
INSERT INTO nod_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","แต่​นายร้อย​บ่﻿ฟัง​กำ​เตื๋อน​ของ​เปาโล เขา​เจื้อ​กัปตัน​กับ​เจ้าของ​เฮือ​นัก​เหลือ ");
INSERT INTO nod_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ย้อน​ต้าเฮือ​นี้​บ่﻿เหมาะ​ตี้​จะ​จอด​เฮือ​จ๋น​ยาม​ฝน​ผ่าน​ไป​แล้ว คน​ส่วน​ใหญ่​จึง​ตกลง​กั๋น​ตี้​จะ​แล่น​เฮือ​จาก​ตี้​หั้น หมู่​เขา​ฮิ​จะ​ไป​หื้อ​แผว​เมือง​ฟีนิกส์ แล้ว​จะ​จอด​เฮือ​ไว้​ตี้​หั้น ฟีนิกส์​เป๋น​เมืองต้า​ของ​เกาะ​ครีต เป๋น​ต้าเฮือ​ตี้​บิ่นหน้า​ไป​ตัง​วันตก​แจ่ง​ใต้​กับ​ตัง​วันตก​แจ่ง​เหนือ ");
INSERT INTO nod_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","เมื่อ​มี​ลม​ปั๊ด​มา​ตังใต้​บ่﻿ปอ​แฮง​เต้าใด หมู่​เขา​ก็​กึ๊ด​ว่า​เหมาะ​แล้ว เป๋น​ลม​ตี้​เฮา​ไป​ต่อ​ได้ ลูกเฮือ​จึง​จั๊ก​สมอเฮือ​ขึ้น แล้ว​แล่น​เลาะ​ไป​ต๋าม​ฮิม​ฝั่ง​เกาะ​ครีต ");
INSERT INTO nod_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","แต่​บ่﻿ปอ​เมิน​เต้าใด​ก็​มี​ลมหลวง​ตี้​ฮ้อง​ว่า ลม​ตัง​วันออก​แจ่ง​เหนือ ปั๊ด​บน​ปื๊น​ดิน​ลง​มา​จาก​เกาะ ");
INSERT INTO nod_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","เฮือ​ตก​อยู่​ก๋าง​ลมหลวง​บ่﻿สามารถ​ฝ่า​ไป​ได้ หมู่​เฮา​ก็​เลย​ปล่อย​เฮือ​แล่น​ปิ๋ว​ไป​ตวย​ลม ");
INSERT INTO nod_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","เฮือ​ก๋าย​ไป​ตังใต้​เกาะ​หน้อย​จื้อ​คาวดา ตี้​หั้น​เกาะ​บัง​ลม​ไว้​พ่อง หมู่​เฮา​ก็​สามารถ​จั๊ก​เฮือ​ลำ​หน้อย​ตี้​ลาก​ตวย​เฮือ​ใหญ่​ขึ้น​มา แล้ว​มัด​ไว้​แต่​ยาก​ขนาด ");
INSERT INTO nod_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","เมื่อ​เอา​เฮือ​ลำ​หน้อย​ขึ้น​มา​แล้ว หมู่​เขา​ก็​เอา​เจื้อก​ลอด​ปื๊น​ต๊อง​เฮือ​ใหญ่ เปื้อ​มัด​เฮือ​หื้อ​แน่น​ป้องกั๋น​เฮือ​แตก แล้ว​หุบ​ใบ​เฮือ​ลง​หื้อ​เฮือ​ลอย​ไป​ตวย​ลม ย้อน​กั๋ว​ว่า​เฮือ​จะ​ไป​ติด​สันดอน​ทราย​ใน​อ่าว​เสอร์ทิส ");
INSERT INTO nod_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ถัด​มา​แหม​วัน ลม​ก็​ยัง​ปั๊ด​เฮือ​ปิ๋ว​ไป​ปิ๋ว​มา หมู่​เขา​จึง​จ้วย​กั๋น​เอา​ของ​ตี้​ใส่​มา​บน​เฮือ​โจ้ง​ลง​ทะเล ");
INSERT INTO nod_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","เมื่อ​เถิง​วัน​ถ้วน​สาม หมู่​เขา​ก็​ยัง​ต้อง​เอา​เครื่องมือ​ของใจ๊​ใน​เฮือ​โจ้ง​ลง​ทะเล​เหีย ");
INSERT INTO nod_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","หมู่​เฮา​บ่﻿หัน​ดาว​บ่﻿หัน​ตะวัน​มา​หลาย​วัน​แล้ว ลมหลวง​ก็​ยัง​ปั๊ด​แฮง​เหมือน​เก่า หมู่​เฮา​หมด​หวัง​ตี้​จะ​มี​จีวิต​รอด​แหม​ต่อไป ");
INSERT INTO nod_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","บ่﻿มี​ใผ​ได้​กิ๋น​ข้าว​กิ๋น​น้ำ​มา​หลาย​วัน​แล้ว เปาโล​จึง​ยืน​ขึ้น​ต่อ​หน้า​หมู่​เขา​อู้​ว่า “หมู่​ต้าน​น่า​จะ​ฟัง​กำ​แนะนำ​ของ​ข้าพเจ้า​พ่อง​ว่า ห้าม​เอา​เฮือ​ออก​จาก​เกาะ​ครีต แล้ว​จะ​บ่﻿ปะ​กับ​อันตราย​ตึง​ความ​เสียหาย​จาอี้ ");
INSERT INTO nod_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","แต่​บ่าเดี่ยวนี้​ข้าพเจ้า​ขอ​หมู่​ต้าน​แป๋ง​ใจ๋​ดี﻿ๆ ไว้​เน่อ จะ​บ่﻿มี​ใผ​ต๋าย​สัก​คน​เดียว จะ​เสียหาย​ก้า​เฮือ​เต้าอั้น ");
INSERT INTO nod_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","เมื่อ​ตะคืน​นี้​ทูตสวรรค์​องค์​นึ่ง​ของ​พระเจ้า ผู้​เป๋น​พระเจ้า​ของ​ข้าพเจ้า​ตี้​ข้าพเจ้า​ฮับใจ๊​อยู่ มา​ยืน​อยู่​ฮิม​ป่างข้าง ");
INSERT INTO nod_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","แล้ว​บอก​ว่า ‘เปาโล​เหย บ่﻿ถ้า​กั๋ว​เน่อ เจ้า​จะ​ได้​ยืน​หื้อ​ก๋าน​ต่อ​หน้า​ซีซาร์​แน่﻿ๆ พระเจ้า​โผด​จ้วย​เจ้า​โดย​หื้อ​คน​ตังหลาย​ตี้​อยู่​ใน​เฮือ​ตวย​เจ้า​รอด​ต๋าย’ ");
