﻿USE sofia;
DROP TABLE IF EXISTS sofia.noaH_vpl;
CREATE TABLE noaH_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES noaH_vpl WRITE;
INSERT INTO noaH_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mua pãrag hĩgk'ak'im, jãga warrgar David reik'a sĩerrjö, Hẽwandamau jũrr hich Hiewaa Jesucristoogta mʌg durr gaai chi Pörk'amk'ĩir hichdëucha pʌ̈ijĩ. Mag Jesucristojã mag rey David k'ararr hag chaain hewagam k'ʌʌn dën hajim ha k'ap hamk'ĩir, hag nawe jöoi Abrán k'ararr sĩejerr haigmua hewag pawi k'ĩeb chi Jesús t'aabatarr haig pãrag jaauk'im. ");
INSERT INTO noaH_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Maataa, hich jöoi Abrán, Isá haai hajim hanaabá; maagwai, Isá jũrr Jacob haai; Jacob jũrr Judá haai. Mamʌ mag Judá hich happai k'aba, tagam hich k'odnaanpa doce naajim haajem, hich k'urau, hich jöoi Jacob chaainpai. ");
INSERT INTO noaH_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Mag hich Judá, Fares haai hanaa hĩchab Zara haai hajim haajem; ham hãd, Tamar ha t'ʌ̃r sĩejim haajem. Mag Fares, Esrom haai hajim; maagwai chi Esrom jũrr Aram haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Hich Aram, Aminadab haai hajim haajem; maagwai chi Aminadab jũrr Naasón haai. Naasón jũrr Salmón haai hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Chi Salmón, Booz haai hajim haajem, Rahab dʌ̈ím; maagwai chi Booz, Obed haai, Rut dʌ̈ím. Obed jũrr Isaí haai hajim haajem; ");
INSERT INTO noaH_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","maagwai chi Isaí jũrr mag rey David k'ararr hag haai hajim haajem. Mag chi rey David, Salomón haai hajim haajem, Urías jua heem hʌʌi k'echeu hautarr dʌ̈ím. ");
INSERT INTO noaH_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón, Roboam haai hajim haajem; maagwai Roboam jũrr Abías haai; maimua chi Abías jũrr Asa haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Hich Asa, Josafat haai hajim haajem; maagwai Josafat jũrr Joram haai; maimua chi Joram jũrr Uzías haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías, Jotam haai hajim haajem; maagwai chi Jotam jũrr Acaz haai; maimua Acaz jũrr Ezequías haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Chi Ezequías, Manasés haai hajim haajem; maagwai Manasés jũrr Amón haai; maimua chi Amón jũrr Josías haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Chi Josías, Jeconías haai hajim haajem. Mag chi Jeconías k'od hãbam k'ʌʌn k'apan sĩejim hanaabá, maach jöoin israelnaan Babiloniapienau hamach durrag pʌrk'a harr nʌm jaar. ");
INSERT INTO noaH_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mag ham chik'amnau hamach durr pʌrk'a harrtarr k'ur, Jeconías chaai paarpajim haajem. Ma, Salatiel ha t'ʌ̃rjim haajem, Zorobabel haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Hich Zorobabel, Abiud haai hajim haajem; maagwai chi Abiud jũrr Eliaquim haai; maimua chi Eliaquim jũrr Azor haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Hich Azor, Sadoc haai hajim haajem; maagwai chi Sadoc, Aquim haai; maimua chi Aquim jũrr Eliud haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Chi Eliud, Eleazar haai hajim haajem; maagwai chi Eleazar, Matán haai; maimua chi Matán jũrr Jacob haai. ");
INSERT INTO noaH_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Chi Jacob, José haai hajim haajem. Mag Joseeta, María jaai hajim hanaabá; maimua chi María, Jesús hãd. Mag Jesuuta maadëu hich Hẽwandamaucha pʌ̈iwia bëejim haajem hag Jesuu, hamach peerdʌ haumk'ĩir warrgarwe hõrau nʌajerr. ");
INSERT INTO noaH_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wajapcharan, mag jöoi Abrán k'ararr sĩerr haigmua hewag pawi David reik'a sĩsiju jaar pa nʌm haar, catorce generaciones dichjim hanaabá. Mag David sĩsiewaim haigmua hewag nassi pawi maach jöoin israelnaan Babiloniapienau pʌrk'a harrtarr jaar pa nʌm haar hagjö catorce generaciones dichjim haajem. Mag maach jöoin Babiloniapien durr narr haigmua hich Hẽwandamaucha pʌ̈iju jaaujerr hewag nassi pawi t'aabachë nʌm jaar pa nʌm hora hagjö catorce generaciones dichjim hanaabá; hajapcharan maach Pör Jesús t'aabachë nʌm jaarma. ");
INSERT INTO noaH_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mag Jesucristo t'aabatarran mʌgta hajim haajem: Chi María, hewag pawi hi hãdpaju, ya Joseeu hiek dee wai sĩejim haajem, hag dʌ̈i paag. Pari mag sĩi hiek dee wai sĩewai hagt'a hag dʌ̈ijã k'aba nʌmta bi hee pabaadëjim hanaabá. Pari ma chan chik'am dënjã k'aba, hich Hẽwandam Hak'arauta hich hiiu haawai mag hi bi hee papijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José chi jaaipajuun Hẽwandam dau na nem hagchata waaujerr haawai, sĩi warre hich hʌʌi chi t'et'emnaanag jaauju k'ãyau, hichta warag sĩi k'ĩuu höbërju k'ĩirjubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ya hirua mag pʌaju k'ĩirjubaadëmta, Hẽwandam chog hʌ̃gt'armua bëewi hirig, —José, David k'ararr chaain hewagam k'ʌʌn bi heem, hoob pʌch hʌʌi pʌaju k'ĩirju chiram hajim hanʌm. Jãg chaai hirua bi hee wai sim chan deeum dën k'aba, hich Hẽwandam Hak'arauta jõorpitarr k'abahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariaau jãg chaaidam hat'aawai hi t'ʌ̃rdam Jesús ha t'ʌ̃rbá. Hi t'ʌ̃r magta t'ʌ̃rju, hichdëuta hich p'öbör hamach pekau hee t'ʌnʌm peerdʌ hauju haawai ha jaaumajim hanaabá chi Hẽwandam chogau. ");
INSERT INTO noaH_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mamʌ t'um mamagk'arran, hich hi jaaujem k'ʌʌnag maach Pör Hẽwandamau p'ãpitarr gaai jaau simjöo höbëbërg mamk'ĩirta magpibajieb. Mag hirua p'ãpitarr gaai mag sim: ");
INSERT INTO noaH_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hʌʌi hõor meraa k'itʌm bi hee pawi chaai hooju. Mag chaai t'ʌ̃rdam Emanuel ha t'ʌ̃rju” ha p'ã sim. Mag Emanuel ha simʌn, “Hẽwandam maach dʌ̈i sim” haawaiu. ");
INSERT INTO noaH_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Maimua mag chi José k'ãi werba t'ʌnaawi dauk'anpawi p'iidʌbaadeeu, Hẽwandam chogau hichig jaautarrjö tag María pʌaju k'ĩirjuba, hich mag hag dʌ̈i sĩsijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pari mag hag dʌ̈i ya hich hʌʌik'a wai sĩerrjã, chi chaai hauba nʌwe chan José bʌ̃ʌrjã hich hʌʌi dʌ̈i k'apes haba haajeejim hanaabá. Ya maimua chadcha chi Hẽwandam chogau jaautarrjö chi chaaidam hat'aawai, Joseeu hi t'ʌ̃rdam Jesús ha t'ʌ̃rjim haajem, hichig t'ʌ̃rpi jaautarrjö. ");
INSERT INTO noaH_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mag Jesús t'aabaawai p'öbördam Belén hanʌm heeta t'aabajim haajem, Judea durr. Mag jaar Herodeeta mag Judea durr reik'a sĩejim haajem. Hich mag jaar hĩchab k'ĩirjug k'aug hat'ee chi machnaan magonaan hanʌm k'ʌʌn hedau höbeerjem bi garmua bëejierram haajem, Jerusalén p'öbörög. Mak'ʌʌn, hedjã heem p'ĩdagta estudiejem k'ʌʌn hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mag bëewi bardʌtk'achëwi, judionaanag, —Pãar rey t'aabatarr, ¿jamta wai nʌma? Hi t'aababarm jaau sim p'ĩdag maach daúacha hootarr haawai hiita marau jʌr wëdurumgui haajeejim hanʌm, hiita judionaan reik'aju haawai hi hajaug t'ö hiek'aan. ");
INSERT INTO noaH_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mag judionaan rey t'aababarm hanʌm hũr hat'aawai chi rey Herodes warre k'ak'aisamjö haadëjim hanaabá. Mag nʌm dʌ̈i tagam k'ʌʌn chi Jerusalenpienjã jʌ̃gderraata hap'öbaadëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Magbaawai chi rey Herodeeu p'adnaan chi pörnaan t'um Moiseeu Hẽwandam hiek p'ã pʌarr jawaag chi machnaanpa t'ʌ̃rk'ʌʌipʌ̈iwia hamag, —¿Jamta mag warrgarwe Hẽwandamau pʌ̈iju jaaujerr t'aabaju haajẽ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Magbaawai hamachdëu hirig, —Judea durr p'öbördam Belén hanʌm heeta t'aabaju haajem hanaabahab, hich magta Hẽwandamau hich hi jaaumie Miqueas k'ak'itarrag jaaupitarr haawai hajim hanʌm. Mag hirua jaautarr hiek gaai, ");
INSERT INTO noaH_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Pãar, Judá durram p'öbördam Belenpien, pãran chadcha k'apan k'aba durrum. Mag durrab mamʌ, pãar hee hãb t'aababarmuata israelnaan mʌ hõork'a t'ʌnʌm k'ʌʌn gobernaaju haawai, pãach durr hagjö p'öbör t'ʌnʌm hee pãar p'öbör chan chi serbiibam k'abam” ha p'ã simgui hajierram hanʌm, chi Herodeeg. ");
INSERT INTO noaH_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","P'adnaan chi pörnaanau maestronaan dʌ̈imua hichig mag jaaubaawai, chi rey Herodeeu jũrr mag chi magonaan hed höbeerjem garmua bëetarr k'ʌʌn hamach happai t'ʌ̃rk'anaa wajap'a hichig jaaupijim hanaabá, jãagwaichata mag p'ĩdag hamau hoo naajĩ. ");
INSERT INTO noaH_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mag wajap'a hichig jaaupinaan chadau hamag, —Hĩsin chad hërëubaadët hajim hanʌm, Belenag. Hërëubaadëwi t'umaa jëeu hoopetat hajim hanʌm, wajap'a mag chaai k'ap haag. Maimua ya pãachdëu wajap'a k'ap'ʌ nʌisiewai mau mʌ haar hiek pʌ̈ibapʌ̈it, muajã mawia hĩchab pãar dënjö hi hajaug t'ö hiek'aimaag hajim hanaabá, juau hogt'om. ");
INSERT INTO noaH_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mag chadcha chi rey Herodeeu hamachig jaautarrta jʌ̃g t'õba hërëubaadëjim haajem. Mag wëtumua, warrcha hamach t'ʌgdʌawai hamachdëu p'ĩdag hootarrta deeu hũwaai ham na p'uu jöisijim hanaabá. Magbaawai hag hẽudee hoo warrmamua, ya chi chaai sim haig pabaimaawai, hag hʌ̃r hedjã hee bar jöisijim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mag hamach chi magonaanau chi p'ĩdag hoo hat'aawai honee hap'öbaadëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mag barwia, chi chaai k'ërarr haar dubnaa hooimaawai, chadcha chi chaaidam hich María dʌ̈i hooimajierram hanaabá. Magbaawai hag k'ĩirp'ee jĩepör p'õbk'anaa hi hajaug t'ö hiek'ajierram haajem, hich reik'aju higwi. Magnaa hamach nem wai bëetarr heem p'ĩr maimua incienso mirra dʌ̈i t'ũp'a k'it'ëem haunaa hirig deejierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mag hagt'a ham haig nʌm hee, hich chi Hẽwandam chogau k'ãai k'õrg hee tag hamag Herodes gar dichpiba jaautarr haawai, hag garjã dichba, deeum k'ʌd garta p'ʌʌrdʌ dichwi hamach durrag wëtjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mag chi magonaan hërëutarr k'ur Hẽwandam chogau deeu José k'ãai k'õrk'api hauwia hirig jaaujim haajem, Herodeeu chaai t'õopʌ̈yaag jʌrpiju. “Mamʌ magju nawe p'iidʌtk'awi jöpk'aa chaai dʌ̈i Egiptoog hërëubaadët” hajim hanaabá. “Mua jaaubam haig chan hoob mammua bëemiet” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Magbaawai José dauk'anpawi, chadcha hag bʌ̈rre nem k'ĩir k'augwia, hagt'a hãspaju wají nʌwe, jöpk'arraa hamach chaai hat'aadëjierram haajem, Egiptoog. ");
INSERT INTO noaH_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mammua da bëeba, ya chi Herodes meebaadëm ha hũrbaawaita deeu bëejierram haajem. Pari mam mag chaai harrtarran, maan maach Pör Hẽwandamau hich hi jaaumie Oseas k'ararrag jaaupitarrjö hamk'ĩir hajiebma. Magju higwiata chi Oseas k'ararrag Hẽwandamau, “Egipto durrmuata mua mʌch Chaai t'ʌ̃rpʌ̈iju” ha p'ãpijim. ");
INSERT INTO noaH_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodeeu chi k'ĩirjug k'ap'ʌm k'ʌʌn nʌ sim hee, hĩchab k'aug hat'ajim haajem, ya jũrr deeum k'ʌd garta p'ʌʌrdʌ hërëubaadëm. Mag hich k'ũgurbapäaiwai, k'ĩir machgau warm k'ʌʌnau hichig jaautarr k'ĩirjunaa, Belén p'öbör heem chaain maimua hag bigaau p'öbördam nʌnʌidʌm heem chaaindampa t'umaa año numiimua heegam k'ʌʌndam k'ëchpi jaaujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mag k'ëchpi jaautarran, maan mag chaain höbarm gaaimua Hẽwandamau hich hi jaaumie Jeremías k'ararrag p'ãpitarr gaai jaau simjöta hajim. Hirua p'ã pʌatarr mʌg hajim: ");
INSERT INTO noaH_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá p'öbör hee hʌʌi bĩep jẽhbʌ hök'ĩirjug machgau hidawaa hʌ̃apëpër k'aju. Ma Raquel hajim, hich chaain hewagam k'ʌʌn hat'ee bĩewai. Mag sim chan par k'ĩir jãsenk'a nʌmjã k'ĩupaba, waragta bĩe t'ʌnaaju hich chaaindam hötarr hat'ee” ha p'ã sim Hẽwandam hiek gaai. ");
INSERT INTO noaH_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pari chi Herodes meetarr k'ur, hagt'a chi José mam Egipto nʌm hee, Hẽwandamau hich chog pʌ̈iwi k'ãai k'õrk'a t'ʌnʌm heeta hirig, ");
INSERT INTO noaH_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—José, p'iidʌbá haichëjim hanʌm. Chaai t'õoju hẽk'a narr k'ʌʌnjã hamachta ya k'ëchp'öbaadeewai ya deeu pãach durrag chaai harrju haai nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Magbaawai José p'iidʌwia Jesudam dʌ̈i chi hãdpa deeu hũwaai Israelag bëejierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pari mag chi rey meebaadeewai, chi hiewaa Arquelao ha t'ʌ̃r sĩerrta jũrr Judea durr hich haaijö reik'a sĩsim ha hũrbaawai, hagʌg maju högk'ajim haajem. Mag nʌm hee hĩchab deeu Hẽwandamau k'ãaipi hat'aawai, Hẽwandam chogaujã magʌg mapiba jaautarr haawai jũrr Galileaagta hërëujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea durr barwi, sĩi k'ajap'a Nazaret p'öbördamagta wëtwi, mamta naaimajim haajem. Pari mag Nazaret p'öbör heeta naaimarran, maan Hẽwandamau hich hi jaaumienag jaaujerrjö, Jesús Nazaretpierr ha t'ʌ̃rju harr haawai hajima. ");
INSERT INTO noaH_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Warrcha Juan chi hõor pör choomieu Hẽwandam hiek jaaubaadëm jaar, Judea durr bʌ̃ʌrjã hõor chukag heeta sĩejeejim haajem. Mam hich sim haar hõor maawaita hamag jaaumamua, ");
INSERT INTO noaH_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pãach k'aibag hãsie hewag k'ĩirjuwia Hẽwandamagta chugpaapi jëeubat'ʌ̃” haajeejim hanʌm. Magnaa hĩchab, “Ya mʌigmua jöpcha hich Hẽwandamau maach t'umaam k'ʌʌn Pörk'apiju maach hee pʌ̈iju” haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mamʌ maan Juanau mag jaau nʌrraju higwiata chi Hẽwandam hi jaaumie Isaías k'ararrau Hẽwandam hiek p'ãawaijã mag p'ãjiebma: “Woun hãb hajappai hõor barba haajem haar sĩejemuata, hich haar hõor barbaimaawai, ‘Maach Pörön ya bëeimʌʌ sim’ ha jaau nʌrraju. ‘Hi bëeju nawe pãach t'ãar k'ĩir k'augbat’ haju, ‘t'ãraucha k'õsi hi hiek hʌ̈k'aag’ ” ha p'ã sim. ");
INSERT INTO noaH_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Hich chi Juan k'ajũa camello k'aar dënta k'a sĩejim haajem; maagwai hi hãi jʌ̃ajemjã nemhëu dën hajim haajem. Hichin pabʌ̈ hee hasp'itjö sim langosta hanʌmta pa miel dʌ̈i k'ö nʌrrʌm hiiuta sĩejeejim haajem, tag deeum nem k'oojem chuk'u haawai. ");
INSERT INTO noaH_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hirua mag jaau nʌrrʌm k'aug hat'aawai, Judea durram k'ʌʌn Jordán higaau joobaajerr k'ʌʌn dʌ̈i Jerusalenpienpa hi hiek hũraan bëejeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mag bëewia hamach pekau Hẽwandamag chugpaapi jëeubaawai hichdëu ham pör choopʌ̈imaajeejim haajem, Jordán hee. ");
INSERT INTO noaH_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pari Juanau hoowai hich haig Moiseeu Hẽwandam hiek p'ã pʌatarr wajapcha hʌʌrk'aajerr k'ʌʌn k'apan bëe t'ʌnʌm dʌ̈i hĩchab tagam k'ʌʌn chi machnaan saduceo hanʌm k'ʌʌnpa bëe t'ʌnʌm hoobaawai, hamag magjim hanʌm: —Chi k'aibagnaan, ¿k'aíu pãrag jaauwai Hẽwandamau maach hi hagk'am hed sĩi pör chootarr gaaimuapaita pãar hi jua machag hãwatbaju ha jaaujĩ? ");
INSERT INTO noaH_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sĩi pãach pör choopi nʌmuapai chan hirua pãar haubam hajim hanʌm. Hẽwandam jua machgau dau hap'ʌʌ hamap'a nʌm k'ai, pãach k'aibag t'umaa hãsie hewag k'ĩirjuwia, Hẽwandamag hisegpi jëeuwia, chadcha Hẽwandam hiek hʌ̈k'aajem k'ʌʌnjö habat hajim hanʌm, pãach k'apeen dʌ̈ijã. ");
INSERT INTO noaH_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hoob pãrau chik'amnaan dënjö, pãachjã warrgar pãach jöoi Abrán k'ararrjö Hẽwandam dʌ̈i k'apeerk'a nʌm hawi, “Maran Abrán chaainau; mag hi chaaink'a nʌmta, ¿jãga Hẽwandamau mag maar dau hap'ʌʌ hapibarju?” ha k'ĩirjumiet hajim hanaabá. Sĩi mag Abrán chaaink'a nʌm gaaimuapaita mag hʌ̃gt'ar höbeerjem hak'iin, mokdau mʌg t'ʌnʌmjã Hẽwandamau hõrag paapʌ̈iwia, mʌk'ʌʌnjã hĩchab Abrán chaainau haju haai sim. Mamʌ mag Abrán chaain chaar hawiajã hichiita Hẽwandam jua machag hãwatab k'aba hãwatju. Mag k'õch k'aba nʌm k'ai, pãach k'aibagta warre Hẽwandamag hisegpi jëeubat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pãrau k'ap'ʌ naabá, nemjĩirjã k'aigbamʌn t'u wërpmaajem. Hich hagjöta hajugui hajim hanʌm hĩchab Hẽwandamau pãar dʌ̈ijã. Ya hirua pãar chachimʌʌ sim. Har hõor hamach k'aibag hisegwia Hẽwandamag chugpaapi jëeuba nʌm k'ʌʌnan, har pa t'upʌ̈iwia jʌser haadee hörpʌ̈i nʌmjöta haju hich Hẽwandamau ham dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mua chan pöd pãar t'ãar wajaug paa haubam. Hẽwandamagta pãach k'aibag chugpaapi jëeubaawai muan sĩi dödamaupaita pãar pör choo chirʌmgui hajim hanʌm. Pari mʌ hẽudee hãb hurumʌn chadau mʌ k'ãaijã jua t'eeg hʌ̃rpai sĩewai, jãguan chad Hẽwandam Hak'aarjã pãrag deewi pãar k'aibagjã hõtdau hee warre hörbapʌ̈imjöta haju hajim hanʌm. Mʌ chan mʌg chirʌm haig sĩi hi chogk'aagpaijã serbiibata chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","K'ĩir k'ap'ʌ habat hajim hanʌm: Hi bëem hed hi hiek hʌ̈k'a nʌm k'ʌʌnan, arroz pöm p'ierrwia wajap'a hãk'a t'ʌnʌʌubarmjöta haju. Maagwai hi hiek hʌ̈k'amap'a harr k'ʌʌn, jũrr chi arroz bʌ̈ t'ʌʌtarrta sĩi hãbamʌg päardʌnaa hörbapʌ̈imjö haju. Magbarm chan hõtdau t'õo k'augba sĩerrʌm heeta hich Hẽwandamaucha bark'ʌʌipʌ̈ijugui ha jaaujeejim hanʌm Juanau hich haig bëe nʌm k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Biek hãb Galilea durrmua Jesús Jordanag majim haajem, Juanau hõor pör choo sĩerr haar hichjã hagjö Juanag hich pör choopien. ");
INSERT INTO noaH_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mag mawia, hich pör choopienta bëejim habaawai, Juanau hi pör choomap'apaim hiek'au hirig, —Pʌchdëuta mʌ pör chooju haai chirʌmta mag muata pʌ pör choobaadëjupá hajim hanʌm, Juan garmua. ");
INSERT INTO noaH_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Magbaawai Jesuu, —Hidëu magma hajim hanʌm. Hichiita maadëu Hẽwandamau jaau simjö hi hipierr t'umaa nem wauju haai naabahab hajim hanʌm. Magbaawai Juanau, —Magan chadau hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mag, chadcha Juanau hi pör choopʌ̈ijim haajem. Mag hich pör choobapäaiwai, durr waaidʌnaa hoowai, hedaujãata weeudʌbaadëm heemua Hẽwandam Hak'aar duburjöo k'itʌmta bëewia hi gaai jupchëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Magbarm hee hĩchab hʌ̃gt'armua woun hiekjö, “Mʌʌta mʌ Chaai mʌchdëu jãsehne wai chitʌmʌu; hi gaaimua mʌ honee chiraajemgui” habarmjã hũrjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Maimua hich Hẽwandam Hak'araupai Jesús warp hõor chukag chʌʌi warrjim haajem, hich garmua mepeer pödju k'ap'ʌ sĩerr haawai juau hogt'om mam chi dösãtag hich k'ũgur hauju hẽk'apieg. ");
INSERT INTO noaH_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mam hich happai cuarenta días y cuarenta noches bʌ̃ʌrjã t'ach k'öba chirajim haajem. Maimua k'ãai k'apan mag dichdimaawaita, hi hiek hi jãsöo haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Magbaadëm heeta dösãt chi dau lök bëejim hanaabá, hi himeerk'a hi k'ũgur hauwia Jöoi dau na nem k'aigbam waupiju hẽk'aag. Mag bëewi hirig, —Pʌ chadcha Hẽwandam Hiewaa k'ai, magan mʌ dak'ĩir mokdau mʌg t'ʌnʌm panag paabapʌ̈i haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pari hichig magbaicheewai jũrr hichdëu chi dösãtag, —Hẽwandam hiek p'ã sim gaai jaauwai, “Sĩi t'ach k'öju happai k'ap hamk'ĩir hirua maach hompaabajim” ha sim. “Hirua maach hompaatarran, t'ach happai k'ĩirjuju k'ãai, hich hipierraa wënʌrramk'ĩirta maach hompaajim” ha p'ã sim ha chirajim haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mag hijẽjẽb naawi, chi dösãtagta Hẽwandam Hak'arau hʌdʌraa Jesús harrpijim haajem, Jerusalenag. Mag hat'aadëwi, Haai hi jëeujem dihëu hʌ̃r hʌ̃gt'aa harrnaa, ");
INSERT INTO noaH_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","hirig magjim hanaabma, chi dösãtau: —Pʌ chadcha Hẽwandam Hiewaa k'ai, magan mʌg hee baubaad hajim hanʌm. Pʌ chig haba k'abahab. Hẽwandam hiek p'ã sim gaai, “Hich Hẽwandamau hich chognaan pʌ̈iju” ha sĩebahab hajim hanʌm, “pʌ t'ʌa wënʌrramk'ĩir.” Maagwai mʌg hee pʌ baudʌk'iinjã, “hamau sĩi hamach jua heeta pʌ jãau haubajup, buju haimaau pʌ chig ham hugua.” ¡Baubaad! hajim hanʌm, chi dösãtau hirig. ");
INSERT INTO noaH_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Magbaawaita jũrr hichdëu chi dösãtag, —Hĩchab Hẽwandam hiek p'ã sim gaai jaauwaijã, “Hẽwandamau chadcha pãach t'ʌaju hawi hoob nem parhoob hamiet” ha sĩebahab ha chirajim haajem hirua. ");
INSERT INTO noaH_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Maimua hãbmiecha paawai deeu chi dösãtaupai durr pöoma sim gaai hi harrjim haajem. Mag durrsĩ gaaimua dawaa durr warp'am magwe t'um hag gaai nem t'ʌnʌm dʌ̈i hirig hoopinaa, ");
INSERT INTO noaH_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Pua mʌ bʌ̈k'ʌrr p'õbk'anaa mʌrʌgta Hẽwandamagamjö jëeumʌn, har pʌchdëu nem hoo sim t'umaa mua pʌrʌgta deejugui hajim hanaabá, chi dösãt garmua. ");
INSERT INTO noaH_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mamʌ mag nʌʌ paawaita Jesuu hirig, —Hẽwandam hiek p'ã sim gaai jaauwai, “Pãar Pörön Hẽwandamau; hãba hirigpaita jëeubat, maimua hãba hi hiekpaita hipierraa habat” ha sim. Magnaa mag sĩebnaa pʌdëu pʌchta jöpk'aa mʌ haigmua sĩiubaad ha chirajim haajem hirua. Mag, bʌ̃ʌrjã hi hipierraa habajim hanaabá Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Magbaawain chadau chi dösãt sĩiubaadeewai hi hiek hich happai chirsijim haajem. Mag hich happai haadeewai Hẽwandam chognaanauta hʌ̃gt'armua bëewi hʌ̈u hi k'ĩir jãsenk'a naaichëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan chi hõor pör choomie ya cárcel deg p'ãar wai nʌm ha hũrbaadeewai, Jesús Galileaag majim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pari hich bãautarr p'öbör Nazaret heepai sĩeba, warag Capernaumag petajim haajem, t'ʌrrdö higaau joobaan, warrgar maach jöoin Zabulonnaan Neftalinaan dʌ̈i joobaajerr durr. ");
INSERT INTO noaH_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pari mag hi mam matarran, Hẽwandam hi jaaumie Isaías k'ararrau p'ã pʌarr heyaa höbërmk'ĩir hajim. Mag hirua p'ã pʌarr gaai mag sim: ");
INSERT INTO noaH_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulonnaan joobaajerr perás maimua Neftalinaan joobaajerr perasta hõor peerdʌju woun nʌrraju” ha sim, “Jordán higaau t'oom higar, p'ũas higaau, maimua k'ĩeb Galilea hee judionaan k'abam k'ʌʌn joobaajem haram magwe. ");
INSERT INTO noaH_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Magbaawain sĩi k'ĩ t'ʌnʌm hee naajerr k'ʌʌn haarta hõt bʌ̈ harar haimamjöta haju. Peerdʌju k'augba haawai pöd hʌ̃gt'ar höbërbaju haajerr k'ʌʌn hat'eeta hedau haardʌbaadëmjöta haju.” ");
INSERT INTO noaH_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Magtarr haigmua Jesuu hich Haai hi jajawagmamua, “Pãach k'aibag hisegwia, Hẽwandamagta chugpaapi jëeubat, maimua hirigta hʌdʌraa pãach Pörk'apibat” haajeejim haajem hõrag. ");
INSERT INTO noaH_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Biek hãb Jesús t'ʌrrdö Galilea higaau nʌrrʌmua, hõor numí hooimajim haajem. Mak'ʌʌn k'od hãbam k'ʌʌn hajim: haaijã hãba, hãdjã hãba. Ham t'ʌ̃r, hãb Simón hajim, hich mapai hĩchab Pedro ha t'ʌ̃r sĩejim. Maagwai hãbak'ai Andrés ha t'ʌ̃r sĩejim. Hamach dö hʌamien harr haawai, hirua hooimaawai, hatarraai bar k'odjörrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mag hoobaimaawai Jesuu hamag, —Mʌ dʌ̈i wëttarrau hajim hanʌm. Hich jãg pãach mʌg sĩi dö hʌa gaaipai nʌmjö, mʌg hatag jũrr mʌ hiek hõrag jaau gaaipaita nʌisijugui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Magbaawai hamach hatarraai p'ëpʌawi chadcha hi dʌ̈i hërëubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Maimua mag Galilea higaau mamua hag hatag deeu hũwaai hõor numí hooimajim haajem, hagjö hãbam k'odpai. Mak'ʌʌn Santiago hajim haajem Juan dʌ̈i, jöoi Zebedeo chaain. Mak'ʌʌnjã dö hʌamien harr haawai, hirua hooimaawai, hamach red t'ʌrrdʌ sĩsidʌmta k'a naajim haajem, bote hee hamach haai dʌ̈i. Mag hoobaimaa, mak'ʌʌnagjã Jesuu, ");
INSERT INTO noaH_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","“Mʌ dʌ̈i wëttarrau” habarm bʌ̈rre sĩi hamach redjã k'augba, bote dʌ̈i hamach hayag pʌawi hi dʌ̈i wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mag nʌrrʌmua Galilea higaau Jesuu jaau p'ʌʌrdʌ nʌrraajeejim haajem, p'öbördam k'ëk'ëdʌm hee judionaan Hẽwandam hiek jaaujem di sĩsidʌmpierr. Mag jaau nʌrrʌmʌn maach peerdʌajem hiekta jaaunaa hĩchab Hẽwandamagta dich Pörk'apiju haai nʌm haajeejim haajem. Mag nʌm dʌ̈i hõor hamach k'amor machagpierr hich haig wai bëe nʌmʌn monaaupʌ̈inaa sĩi k'a mamachdögpa chugpaapʌ̈i maajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria durram magwe Jesús mag nʌrrʌmʌn bĩi wëjorr haawai, hõor k'amor machag k'ĩirpierram k'ʌʌnta hi haig waibëejeejim hanaabá: sĩi k'ajap'am k'amor machag paraam k'ʌʌn, k'a mamachdög paraam k'ʌʌn, dösãt bën paraam k'ʌʌn, pör bënmie paraam k'ʌʌn maimua bʌ̈ wa jua k'ãijã jʌserm k'ʌʌnpa waibëemamʌn, Jesuu monaaupʌ̈i maajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hõor pöoma Galilea durram k'ʌʌn, Decápolis durr p'öbör nʌnʌidʌm heem k'ʌʌn, Jerusalenpien, Judea durram k'ʌʌn maimua Jordán hi hatag hed höbeerjem garm k'ʌʌnpa Jesús hẽudee pos haajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mag hõor pöm hich hẽudee noodʌbaadëm hoobaawai hich Jesús warag durrsĩ gaai waaidʌ höbërwi hoo sĩsijim hanʌm. Magbaawai hi k'apeen hi dʌ̈i wënʌrraajerr k'ʌʌn hich bigaau hohood hap'öbaadeewai ");
INSERT INTO noaH_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","jãga chadcha Hẽwandam dʌ̈i hajap'a wënʌrraju haai nʌ ha jaaumamua magjim hanʌm, t'umaam k'ʌʌnag: ");
INSERT INTO noaH_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Pãar har pãach k'aigba nʌm k'ap Hẽwandamagta pãach heeg hoopim k'õsi durrum k'ʌʌn, honee habat hajim hanʌm, pãachta hi dʌ̈i hãba jooba wënʌrraju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Pãar har pãach pekau pöm nʌm k'aug hauwi hök'ĩirjunaa Hẽwandamagta chugpaapi nʌm k'ʌʌn, honee habat hajim hanʌm, hich Hẽwandamauta pãar k'ĩir jãsenk'awi pãar k'ĩir honee hapiju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Pãar har bʌ̃ʌr habarm gaaimua meeuk'aba k'ĩir t'ũu Hẽwandamagta pãach dʌ̈i hichdëu hampierr hapiejem k'ʌʌn, honee habat hajim hanʌm, pãach mag nʌm paar hirua durr hiiur deeju ha simjã pãachdëuta jʌ̃aju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Pãar har Hẽwandamau waupim k'õsim nem wawaagta jãsog t'ʌnʌmjönaa höbichag t'ʌnʌmjö nʌm k'ʌʌn, honee habat hajim hanʌm, mag nem wajap'a waum k'õchk'a nʌm k'ʌʌn juagta Hẽwandamau dʌ̈i hoojeewai. ");
INSERT INTO noaH_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Pãar har wir haig pãach k'apeendamjã dau haug k'aug paraa haajem k'ʌʌn, honee habat; pãachdëu ham dʌ̈i jãagjem paran Hẽwandamaujã hagjö pãar dau haug k'aug paraa hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Pãar har t'ãar hajap'a nʌm gaaimua hãba Hẽwandam dawagaata nem waaujem k'ʌʌn, honee habat hajim hanʌm, pãrauta pãach mag nʌm gaaimua Hẽwandam k'ĩir hooju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Pãar har pãachdëu Hẽwandam hiek hʌ̈k'atarr gaaimua pãach k'õinaa nʌmjö k'õinaa hamk'ĩir hõrag jaau durrum k'ʌʌn, honee habat, pãachta Hẽwandamau hich chaaink'a hauju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Har Hẽwandamau nem waupi sim hipierraa nem wau nʌm gaaimua jũrr hõrau pãach dʌ̈ita k'aigba haawai dau hap'ʌʌ durraajem k'ʌʌn, honee habat hajim hanʌm, pãachta mʌg hatagjã Hẽwandam dʌ̈i hãba jooba wënʌrraju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Har mʌ gaaimua hõrau pãach k'ĩir hiek'anaa pãach gaaijã jua k'ʌaba nʌm dʌ̈i hĩchab sĩi pãach k'aibag waum k'õchgau pãach dʌ̈i chad k'abam hiekta chadam hiekjöo haadëp haawai, warag honee habat. ");
INSERT INTO noaH_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pari pãach dʌ̈i maagwaijã, hoob hök'ĩirjuu hamiet hajim hanʌm. Magju k'ãai warag honee habat; pãar mag nʌm jũrran hʌ̃gt'arin pãar hat'ee nem wajap'am pöomata t'ʌnʌm. Hĩs jãg pãar dʌ̈i k'aibag t'ʌnʌmjö haba haajeejieb hajim hanʌm warrgarwejã ham jöoinau Hẽwandam hi jaaujerr k'ʌʌn dʌ̈i. Pari magtarr hĩs ham hʌ̃gt'ar Hẽwandam dʌ̈i honee naabahab ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mag hiek'ak'agmamua hich Jesuupai, ’Pãrau k'ap'ʌ nʌmgui hajim hanʌm, t'ak'aar nak'a haadëk'iin, tag bʌ̃ʌrjã maadëu nem higba sĩsiju. Magbaawai sĩi hõrau hag hʌ̃r hërëu dich t'ʌnaawiajã, hausĩuba hich mag bʌ̈ hee sĩeju, tag higba sĩewai. Jãg nem hãrpimaaugau t'ak'aar hiigjemjö, pãrauta hõor hok'ooju harrjã hʌ̈u mʌ juapierr k'aigpër durraba haajeeb hajim hanʌm hok'oopimaaugau. ");
INSERT INTO noaH_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Jãg durrsĩ gaai p'öbör sim pöd dau merju k'aba haajemjö, pãraujã pãachdëu mʌ hiek k'augtarr chan pöd meerju k'aba nʌmgui hajim hanaabá, pãach nem wajap'a wau nʌm gaaimua pãachta mʌig heegarm k'ʌʌn hat'ee k'ĩchag hee lámpara paa dʌnʌmjö naawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pãrau k'ap'ʌ nʌm, lamparaan paanaa sĩi nem bʌ̈ hee hausĩuba, dau garta hausĩiujem, dijã t'um hararaa hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hich jãgta haju haai nʌmgui hajim hanʌm pãarjã. Magua pãachdëu nemdam wajap'a wau nʌm gaaimua pãachta hõtdau p'uu dʌnʌmjö habat hajim hanʌm, t'umaam k'ʌʌn na harar hamk'ĩir; mag pãach nem wajap'a wau nʌm gaaimua maach Haai hʌ̃gt'ar chirʌmta t'umaam k'ʌʌnau t'ömk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Hoob pãrau mua mag Moiseeu ley p'ã pʌatarr warre hisegpäain wa sĩi warrgar Hẽwandam hi jaaujerr k'ʌʌnau nem jaaujerr k'ãijã hisegpäainta bëejim hamiet hajim hanʌm Jesuu. Magju k'ãai muan warag chadcha hag gaai jaau sim t'umaa wawaanta bëejim. ");
INSERT INTO noaH_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cha mʌ hiek'a chirʌm hiek'au, mʌg durr jöoita hedaujã dʌ̈i Hẽwandamau hi hagk'abam haig chan, ley gaai jaau sĩsidʌm hiek bʌ̈dam hãbjã hok'oopibaju. Hichiita nem t'umaa hich jaautarrjö höbëbërg majugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Magua, hãbmua k'ãijã leidam bʌt'ʌ k'itawiajã hag gaai jaau sim hiek bʌ̈ hãb k'ãijã hʌʌrk'aba, ni hag gaai jaau simjö hamk'ĩir hich paarmua deeum k'ʌʌnagjã jaauba sim chan, Hẽwandam maach Pörk'a sim durr paauk'aimaawaijã hichta t'umaam k'ʌʌn k'ãaijã jua heegpai sĩerraju. Pari magba, har hichdëujã mag ley gaai jaau simjö hipierraanaa warm k'ʌʌnagjã hagjö hag gaai jaau simjö hipierraa hamk'ĩir jaau simʌn chadau, mag Hẽwandam durr paimaawaijã hĩchab hichta warm k'ʌʌn hʌ̃rpai sĩsijugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Magnaa hichdëupai, Pãrauta hich Hẽwandamau nem waupi jaau simjö nem wauba, sĩi jãg Hẽwandam hiek jawaag chi machnaan haajem k'ʌʌnjöpai nem waunaa Moiseeu ley p'ã pʌatarr hʌʌrk'aajem k'ʌʌn dënjöpaita nem wau nʌm chan, pãar hʌ̃gt'ar höbërbamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Maimua hich Jesuu magjim haajem: ’Pãrau k'ap'ʌ nʌmgui hajim hanʌm, warrgarwejã pãar jöoinau, “Hoob hõor t'õom; chi hõor t'õo simʌn hich hagjö t'õopʌ̈iju haai sim” ha jaaujeejim. ");
INSERT INTO noaH_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pari mua mag chirʌmgui hajim hanʌm: Hõor t'õoba hawiajã sĩi dich k'apeendam dʌ̈i meeuk'a nʌmpaijã hich hagjö pekauk'a höbër sim. Sĩi dich k'apeer meeuk'amk'ĩir hi k'ĩir hiek'a nʌmjã pekauu; chi mag hiek'a sim k'ʌʌn, t'et'emnaanau k'aibag waupi jaauju. Maimua har sĩi chik'am t'õp hiek'a simjã ya sĩi k'ĩmie durr barpʌ̈ijuuta sim; hõor t'õoba hab mamʌ hich hagjö sĩebahab hajim hanʌm, pekauta wau sĩewai. ");
INSERT INTO noaH_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Maguata mag chirʌm: Pʌ, Hẽwandamag nemchaaita ofrendak'a deenaa jëwaan mam; pari mag mam hee pʌ k'ĩir hee dʌhnʌisim, hãbmua pʌch dʌ̈i hiekk'õrdam paraa sim. ");
INSERT INTO noaH_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Magbaawai pʌch ofrenda chi nemchaain p'aajem haig pʌawi, mag pʌch dʌ̈i k'aigba sim haar mawi, hit'ũu hi dʌ̈i hiyʌ̈ʌ hawi, k'õinaa nʌisit ha jaaumajim hanaabá. Maimuan chadau deeu mawia pʌch ofrendadamau Hẽwandamag jëeubamí hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Wa hãbmua k'ãijã leinaanag pʌ k'aibag waumk'ĩir pʌch jawaan harrwai, chi t'et'emnaan haar barwi jaauju nawe, hi dʌ̈i wajap'a hiyʌ̈ʌ hawi k'õinaa nʌisit hajim hanʌm. Magbamʌn chi t'et'emnaanau guardianaanag pʌ pʌr deebaawai jũrr mak'ʌʌnau pʌ cárcel deg pʌ̈ijugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cha mʌ hiek'a chirʌm hiek'au, ya pʌʌta hamau mag p'ãar hat'amʌn, p'atk'on gaaimua hatarr k'ai, hãbmiecharam centaaudam p'agpʌ̈ibam haigjã hamau pʌ höbeerpʌ̈ibajugui hajim hanʌm. Mua mag chirʌmʌn, pãach k'aibag Hẽwandamag chugpaapiju haai nʌwe chugpaapiwi hi dʌ̈i k'õinaa hajuuta hẽk'abat ha chirʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mag hiek'amamua hich Jesuupai hamag magjim haajem: ’Pãrau k'ap'ʌ nʌmgui hajim hanʌm hĩchab, warrgarwejã pãar jöoinau, “Hoob pãach hõor k'abam dʌ̈i k'apes hamiet” ha jaaujeejim. ");
INSERT INTO noaH_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pari hĩs mua mag chirʌm: Warre k'apes haba hawiajã, hãbmuata hʌʌi hoowi hich hödegpai k'ãijã, “Jãg hʌʌita magju haai k'itaba” ha k'ĩirju simʌn, mag k'ĩirjubarmuapai ya hich t'ãar hee pekau waubarm mag hʌʌi dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Magam huguata, pʌ juachaar garm daúa k'ãijã pʌ pekau waupi sim k'ai, jẽunaa warre warp barbapʌ̈i. Mag dau hãbpaim gaaimua pʌch mor t'um k'ĩmie durr maju k'ãai, dau happaita hok'oobarmʌn, hʌ̈u simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wa pʌ juachaar garm juau k'ãijã pʌ pekau waupi sim k'ai, warre t'ʌapnaa warp barbapʌ̈i. Jua hãbpaim gaaimua pʌch mor t'um k'ĩmie durr maju k'ãai, mag jua happaita hok'oobarmʌn hʌ̈u simgui hajim haajem. Wajapcharan magʌm pekau waumaaugau dau chuk'umjö hoobamjönaa magʌm nem k'aigbam wawaagjã jua chuk'umjö habá, bʌ̃ʌrjã wauba. Magju k'ãai Hẽwandam dau na pʌch morta sʌrk'abá ha chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Pãrau k'ap'ʌ nʌmgui hajim hanʌm hĩchab, pãar jöoinau jaauwai, “Hãbmua k'ãijã hich hʌʌi pʌagpam k'ai, warre hẽsap gaai ‘Mua pʌ pʌa chirʌm’ ha p'ãnaata hirig deeju haai sim” ha jaaujeejim. ");
INSERT INTO noaH_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pari hĩs jũrr mua mag chirʌmgui hajim hanʌm: Hãbmua k'ãijã hich hʌʌi deeum dʌ̈i chadcha magba simta pʌa simʌn magan warag juau deeum dʌ̈i magamk'ĩirjöta pʌa simgui hajim nʌm, magʌm gaaimua warag pekau waumk'ĩir. Mag hich hap sim hawi chik'amnau pʌatarr hʌʌita hau sim wounjã pekauta wau simgui hajim hanʌm, hagt'a chik'am hʌʌik'a simta hau sĩewai. ");
INSERT INTO noaH_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Hĩchab pãrau k'ap'ʌ nʌm, warrgarwejã pãar jöoinau jaauwain, sĩi parhoobam nem higwiata dichdëu nem waum k'õsim wauju ha hiek'aawain, naspawiajã deeu waubam haju haai sim ha jaaujeejim. Magarrau “Maach Pör Hẽwandam higwiata mua mag nem wauju ha hiek'abarmʌn chadau pöd naspawiajã dich hiek'atarr chaaur haju k'aba sim” ha jaaujeejim. ");
INSERT INTO noaH_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pari hĩs mua pãrag mag chirʌmgui hajim hanʌm hich Jesuu: Hoob bʌ̃ʌrjã nem hinagdam higwia k'ãijã mag gaaimuata nem wauju ha hiek'amiet. Hedjã Hẽwandam k'u juupjem haawai hoob hedjã higwiajã mag gaaimuata nem wauju hamiet. ");
INSERT INTO noaH_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mʌg durrjã sĩi Hẽwandam bʌ̈ dʌnʌʌujem haawai ni mʌg durr higwiajã hoob mag gaaimuata nem wauju ha hiek'amiet ha jaaumajim hanʌm. Wa Jerusalén p'öbör higwia k'ãijã, jãg p'öbör t'umaam k'ʌʌn k'ãaijã chi hʌ̃rʌʌcharam Rey sĩejem p'öbör haawai, hoob mag gaaimuajã nem wauju ha hiek'amiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wa dich pör higwia k'ãijã hoob mag hiek'amiet; magʌmjã pekauu. Pãach hip'it'ur mag hiek'awiajã pãrau pãach pörbʌ̈ hãbjã bäp'ä paa hauba ni p'ʌisijã paa haubamgui hajim hanʌm, hich Hẽwandamaupaita magpiejeewai. Mag nem parhooba higwiata hiek'a nʌm haig, Hẽwandam higwiata pãar mag hiek'a nʌm k'abahab, nem t'um hichdëuta homparr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Magju k'ãai chadcha nem wauju k'ai, warre wauju habat. Wa wauba k'ãijã haju k'ai, warre hich hagjö waubam habat, mag nem hinag higwia magʌm gaaimuata wauju ha hiek'aba. ");
INSERT INTO noaH_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Pãrau k'ap'ʌ nʌm hĩchab, warrgarin pãar jöoinau jaauwai, “Chik'amnau pʌch dau suawai puajã hagjö hi dën suju haai sim” ha jaaujeejim; wa “Chik'amnau pʌ k'ierr hãb k'ãijã buat'ẽupäaiwai pʌchdëujã hi dën hagjö haju haai sim” ha jaaujeejim. ");
INSERT INTO noaH_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pari hĩs mua mag chirʌmgui hajim hanʌm deeu hich Jesuu: Hãbmua k'ãijã pãach dʌ̈i k'aigba haawai hoob ham dʌ̈i hagjö k'aigba hamiet. Magʌmjã hagjö pekauu. Magju k'ãai pʌ k'ĩidadcha deetarr k'ai, t'oom garjã hagjö deemk'ĩir hirig k'ĩir hʌabá hajim hanaabá warag. ");
INSERT INTO noaH_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hãbmua k'ãijã leinaanag pʌ jaauwia pʌ camis k'ãijã k'echt'ʌg haum hig sim k'ai, warag tagam k'ajũajã hʌdʌraa hirig harrpibá. ");
INSERT INTO noaH_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nem chʌk'ʌm k'ãijã hajués pʌchig kilómetro hãb harrpi sim k'ai, magʌm haba warag kilómetro numí hat'aad hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hõrau pʌchig nem jëeuwai hö hajap'a magʌm haba deebá. Maimua sĩi pʌchig nem prestaa k'ãijã jëeuwai deeb k'aba deebapʌ̈i hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Hĩchab pãrau k'ap'ʌ nʌm, warrgar pãar jöoinau jaauwain, “Pãach k'apk'ʌʌnta k'a k'õsinaa pãach k'a huk'urm k'ʌʌn hoomap'a habat” ha jaaujeejim. ");
INSERT INTO noaH_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pari hĩs mua mag chirʌmgui hajim hanʌm hich Jesuu: Pãach k'a huk'urm k'ʌʌnjã daupii habat; maimua hagjö mʌ hiek gaaimua pãach k'aibag wauju hẽk'aajem k'ʌʌn kõitjã warag Hẽwandamagta jëeubat. ");
INSERT INTO noaH_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pãrau magta hamʌn magan chadcha pãar hʌ̃gt'ar Hẽwandam chiraajem chaainau. Hich hag Hẽwandamauta hõor wajap'am k'ʌʌn hat'eejã hedau wʌʌpinaa k'aigbam k'ʌʌn hat'eejã wʌʌpiejem. Hichdëuta hĩchab hich daar hagpierraa haajem k'ʌʌn hat'eejã noseg chëpinaa sĩi parhoob hamach k'õchagpierr nem waaujem k'ʌʌn hat'eejã noseg chëpiejemgui hajim hanʌm. Magua pãraujã hagjö t'um pãach dʌ̈i k'aigba haajem k'ʌʌnpata daupii haju haai nʌmgui hajim haajem, hichdëu haajemjö. ");
INSERT INTO noaH_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pãrau sĩi pãach daupiim k'ʌʌnpaita hagjö daupii hamʌn, ¿maig k'an wajaug sĩ? ¿Sĩi Romaam gobierno hat'ee dëbpaar jëeujem k'ʌʌn chi k'aigbam k'ʌʌnaujã hich hagjö haba haajẽ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wa sĩi pãrau pãachjö judionaank'a t'ʌnʌm k'ʌʌnagpai k'ãijã saludaak'iin, ¿maigjã k'an wajaug sĩ? ¿Hich hagjö haba haajẽ judionaan k'abam k'ʌʌnaujã? Pãach meeun k'abam k'ʌʌn hawiajã hoob hamag saludaamap'a hamiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pãach Haai hʌ̃gt'ar chiraajemjã chi wajap'am haawai pãach chi chaainaujã hĩchab pãach Haaijö hö wajap'a habat pãach k'apeen dʌ̈i ha jaaumajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Sĩi pãach hö wajaug p'ëmk'ĩirpai chan hoob chik'am dak'ĩir nem waumiet hajim hanʌm. Bigaaum k'ʌʌnag magamk'ĩirpaita pãrau mag nem wau nʌm paar chan, maach Haai hʌ̃gt'ar simua pãar wajap'a hig hiyʌ̈ʌ habaju, ya mʌig heegarwe hõrau pãar wajap'a hig hiyʌ̈ʌ nʌmua ya hamau pãrag p'ag nʌmjöta naawai. ");
INSERT INTO noaH_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Magam huguata, dau hap'ʌʌm k'ʌʌndamag nemdam deewaijã hoob t'umaam k'ʌʌnag k'ak'apdö hapimiet, sĩi jãg hamach hëugar wajap'a hig hiyʌ̈ʌ hamk'ĩirpai culto hee wa kaaijã hee k'ãijã hõor k'apanag dak'ĩir haajem k'ʌʌn dënjö. Har jãg hamach hëugar wajap'a hig hiyʌ̈ʌ hamk'ĩirta hap'ʌʌm k'ʌʌndam dʌ̈i hö wajap'a haajem k'ʌʌnan, ya hõrau hamag p'agbarmjöta nʌmgui hajim hanʌm, ham hëugar wajap'a hiek'a nʌmua. Jãgʌm k'ʌʌnag k'anii Hẽwandamau tag p'agbarju. ");
INSERT INTO noaH_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dau hap'ʌʌm k'ʌʌndamag nem hinagdam deewai hoob pãach k'apeen pãach dʌ̈i chi wajapcharam k'ʌʌnagjã jaaumiet. ");
INSERT INTO noaH_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Magju k'ãai warag pãach k'augpimap'amjö meraata deebat hajim hanʌm. Pãrau mag meraa deewiajã, pãar Haai hʌ̃gt'armua pãar hoo sim haawai, hichdëujã pãar heeg hoob k'aba heeg hooju ha jaaujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mag nem jajawagmamua hich Jesuu magjim hanʌm: ’Pãach Hẽwandamag jëeuwai, hoob jãg sĩi chadcha magba nʌmta Hẽwandamag jëeu nʌm hamk'ĩir jãg hõor dak'ĩirpai jëeujem k'ʌʌnjö hamiet hajim hanʌm. Jãk'ʌʌnan sĩi hõrag hamach hoomk'ĩirpaita culto hee maimua sĩi kaaijã heejã hagjö Hẽwandamag jëeu nʌm hanʌmua bʌ̈jãaupaita hijẽjẽb haajerramgui hajim hanaabá. Jãg hamach hëugar wajap'a hig hiyʌ̈ʌ hamk'ĩirta jãg nʌm k'ʌʌnan, ya hõrau hamag p'agbarmjöta nʌmgui hajim hanʌm, ham hëugar wajap'a hiek'a nʌmua. ");
INSERT INTO noaH_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pari pãrag mua jaauk'im: Hẽwandamag jëeuwai, ham dënjö k'aba, pãach k'ãaijem t'uur wai nʌm k'ai, haar dubnaata pãach happai hirig jëeubat. Mag pãach happai nʌmjö naab mamʌ, maig pãar dʌ̈i sim pãar Haai. Mag pãar Hayau pãrau pãach happai hichig jëeu nʌm hoobaawai pãrag hirua pãachdëu nem jëeu nʌmjã deeb k'aba deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Mag hirig jëeuwaijã hoob jãg par hiiupai Hẽwandam hiek hʌ̈k'a nʌm hanʌm k'ʌʌn dënjö parhoobam hiek maadëu higbaju hayaampata hiek'a nʌʌ hamiet hajim hanaabá. Hamachigan jãg jëeubaadëm pʌa chʌuu haawaita Hẽwandamau hʌ̃rcha hamach hiek hũurjempii haajerram hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pãrau hichig jëeuju nawe pãar Hayau ya pãrau nem hig nʌmjã k'ap'ʌ sim haawai, hoob ham dënjö hatcha hiek'a nʌʌ hamiet. ");
INSERT INTO noaH_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Magju k'ãai pãachdëu hirig jëeuwai mʌgta jëeubat hajim hanʌm: “Hẽwandam, pʌʌta maar Haai hʌ̃gt'ar chiraajemʌu. Pʌch happaita chadcha pekau chuk'u chitʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pʌrʌgta marau maach dʌ̈i pʌchdëu hampierr hapinaa pʌchta t'umaam k'ʌʌn Pörk'apim k'õsi nʌm. Hʌ̃gt'arjã jãg pʌchdëu nem waupi jaau nʌm happai waaujemjö, mʌig heegarjã t'um pʌchdëu jaau simjöta hapim k'õsi nʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hed hëepierr pua marag hich jãg k'öjudam deebarju. ");
INSERT INTO noaH_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hẽwandam, maar pekau t'um chugpaabapʌ̈i, maimua har marau maach dʌ̈i k'aigba habarm k'ʌʌn dʌ̈i tag magʌm hiek higba hich mag k'ĩir hok'oopäaijemjö, maar dënjã k'ĩir hok'oobapʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hoob pua hʌdʌraa chan maar pekau hee burrpi chiram. Mag k'ãai warag maar t'ʌa wai chirsí, p'it'urg chuk'u dösãtau maar hichig paa haum hugua. Hẽwandam, pʌchdëuta nem t'ʌnʌmʌn t'um k'ap chirʌm. Pʌchta chi jua t'ierriu, maagwai pʌchpaita t'umaam k'ʌʌnau t'ö hiek'aju haai nʌm, mʌg hatag pawiajã hich mag.” ’Magta jëeubat hajim hanaabá hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Magnaa hĩchab, Chik'amnau pãach dʌ̈i k'aigba haawai, pãrau ham dʌ̈i magʌm hiekjã higba sĩi k'ĩir hok'oopʌ̈imʌn, magan maach Haai hʌ̃gt'ar chiraajemuajã hĩchab pãar pekau chugpaapʌ̈iwia tag magʌm hiek higba hich mag k'ĩir hok'oopʌ̈ijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mamʌ pãrauta pãach k'apeen wir haig perdonaabam chan, maach Haai Hẽwandamaujã pãar pekau chugpaabamgui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Pãach Hẽwandamag jëeu k'ëwaag t'ach k'öba sʌrk'aawai, hoob jãg sĩi hamach hëugar wajap'a hig hiyʌ̈ʌ hamk'ĩirpai nem waaujem k'ʌʌnjö jãsogau hök'ĩirjuumjö hamiet hajim hanʌm, mag hoowi bigaaum k'ʌʌnau “Jãan Hẽwandamag jëeu nʌmua sʌrk'a naawaita jãg nʌm” ham hugua. Jãg hamach sʌrk'a nʌm k'ap hamk'ĩirpaita hök'ĩirjuumjö haajem k'ʌʌnan, ya hõrau hamag chi p'agamjöta nʌmgui hajim hanaabá, ham higwi chadcha sʌrk'aajem k'ʌʌnau hanʌm gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Magju k'ãai Hẽwandamag jëwaag sʌrk'aawai, warag wajap'a pãach k'ĩir sũgpʌ̈inaa pör megbapʌ̈it, ");
INSERT INTO noaH_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bigaaum k'ʌʌnau mag pãach sʌrk'a nʌm ni hãbmuajã k'ap ham hugua. Pãrau magta hamʌn, hãba maach Haai pãar dʌ̈i simuapaita k'ap haju; maagwai hichdëuta hĩchab pãar heeg hoojugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mʌig heegarwe chan hoob p'atk'on wa nem hinag pöm k'ãijã paarpaju hẽk'amiet. Mʌiguin nem t'um polieu hãrnaa k'uk'ungaujã jẽeumaajem; mag nʌm dʌ̈i nem jĩgmienaujã sĩi dubwia jĩgk'amaajemgui ha jaaumajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Magju k'ãai nem wajap'a wau nʌmuata p'atk'on hãk'a p'iemam dʌ̈i nem hinag pöm paarpamamjö habat, hʌ̃gt'ar paimaawaijã chadcha paraa naaimaag. Pãach jam paauk'aimaawaim hat'eeta pãrau p'atk'on p'ie nʌmjö nem wajap'amta wau nʌmʌn hʌ̈u simgui hajim hanʌm. Jam chan polieujã hãrba, k'uk'ungaujã jẽeuba, ni nem jĩgmienaujã pöd jĩgk'abam. ");
INSERT INTO noaH_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mʌig jẽb gaai nʌweta nem t'um paraa haju k'ĩirjuju k'ãyau hʌ̃gt'ar paawaita nem t'um paarpaju k'ĩirju wënʌrrʌmʌn, magan chadcha pãar k'ĩirjug hãba Hẽwandam gaaita sim hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Maach daun hõtdaujöta sim maach mor gaai. Maach daujãata wajap'a sim haiguin, nem t'um dawaata hoojem. Hich hagjöta sim maach t'ãarjã. Hẽwandam hiek hʌ̈k'anaa maach t'ãarta wajap'a sim haiguin, nem t'um Hẽwandamau k'õsimjöta waaujem. Mag nʌm haiguin hararag hee nʌmjöta nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mamʌ magba hagt'a pãach pekau hee nʌmʌn, magan pãran sĩi hagt'a k'ĩchag hee jʌrk'a jʌrk'a nʌmjöta nʌm. Mag nʌm haig pöd Hẽwandam dʌ̈i naaju k'aba nʌmgui hajim hanaabá, pekau heeta naawai. ");
INSERT INTO noaH_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni hãbmuajã pöd patronnaan numiim k'ʌʌn chogk'aju k'aba simgui hajim hanʌm. Patronnaan numí hak'iin, hiwiir hãbpaita hʌ̃rcha k'a k'õsi haju. Hich hagjöta sim hĩchab Hẽwandam dʌ̈ijã. Pöd pãrau Hẽwandam k'ĩrag wʌrpanaa, p'atk'onag k'ãijã wʌrpaju k'aba nʌm. Pãar magta nʌm chan Hẽwandam hipierraa k'aba nʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mag nem k'ĩir pogk'e jajawagmamua magjim hanʌm hich Jesuu: ’Hoob pãrau “¿k'ani k'öju wa k'anta döjuuta maach mʌg nʌma?” ha k'ĩirjumiet. Wa magbam k'ai, ya k'ajũa chuk'u nʌm “¿K'ani jũajuuta mʌg nʌmua?” ha k'ãijã k'ĩirjumiet hajim hanʌm. Pãarta nem k'oojem nem k'ãaijã wajapchanaa k'ajũa k'ãyaujã Hẽwandam dau na hʌ̃rʌʌcha balee sĩsid haawai, hirua pãrag hoobamjöo habajugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pãadë har nemchaaindam hedjã hee hũrr p'op'og haajem k'ʌʌn hoobat. Ham p'idk'ajã p'idk'aba haajeewai hamach p'at'audam hãk'aagjã di chuk'u nʌm. Mag p'idk'aba sĩi naajeeb mamʌ, maach Haai hʌ̃gt'ar chiraajemuata hamag p'at'audam daumeraa dee wai simua ham k'ee wai sĩejemgui hajim hanʌm. Magʌm pãar chará nemchaain jãg t'ʌnʌm k'ãaijã hʌ̃rcha balee naawai, ¿jãga hirua bʌ̃ʌrjã pãrag hooba habarju? ha jaaumajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hoob hatcha pãachdëu nem hig nʌmta k'ĩirju nʌʌ hamiet. Mag pãrau pãachdëu k'õsimta hig nʌʌ hak'iinjã, ¿k'aíuta mʌg nʌm haig mag hichdëu k'ĩirju sim gaaimuapai hich meeju harr hʌ̃r horadam hãbpai k'ãijã hich hiiupiju haai sĩ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Mag nʌmta k'ajũa chuk'u haawaijã ¿k'ant'ee hatcha k'ĩirju nʌʌ haajẽ? Pãadë har pamaardam hooihmʌ t'ʌnaajem k'ĩirjubat. Hamjã hĩchab bʌ̃ʌrjã p'idk'ajã p'idk'aba, ni hamach k'ajũa jũaju k'ĩirjuwia hẽk'ak'a nʌʌjã haba haajem. ");
INSERT INTO noaH_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mag naab mamʌ hõor hãbmuajã ham dʌ̈i barba haajem, hooimʌg hat'ee. Warrgar rey Salomón k'ararraujã p'atk'on pöm paraanaa nem wajap'am pöm paraa haajerraujã pamaardam hooimʌgjö chan pöd k'ajũa jũaba haajeejimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pamaar jãg hooihmʌ t'ʌnʌm hedau wʌʌbaadëmuapai k'iugp'ëbaadeewai sĩi k'ʌʌijemjã Hẽwandamau jãg hooihmʌ wai sĩejemta, ¿jãgwi pãar pamaar k'ãai hʌ̃rcha balee nʌmua nem jëeu nʌmta hirua deeba habarju? ¿Wa pãachdëu jëeu nʌmjã pöd deebajupii haajẽwa? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hoob hatcha “¿k'anta k'oogáwa?” wa “¿k'anta doogáwa?”, wa magbam k'ai, “¿k'andamta jũabaraag k'ai?” hamiet hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, hõor Hẽwandam hiek hʌ̈k'abam k'ʌʌnta magʌm nem t'um k'ĩirju p'öbaadëmjã pʌaba sĩerrjëem. Mamʌ pãar Haai hʌ̃gt'ar chiraajemua pãrau nem hig nʌmjã t'um k'ap'ʌ sim haawai pãar chan warm k'ʌʌnjö magbaju haai nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hãba Hẽwandamau nem waupi jaau simpaita waunaa hirigpaita pãach dʌ̈i hichdëu hampierr hapibat. Pãrau chadcha magta hamʌn, tagam nem pãachdëu higbarmjã hirua deeb k'aba deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hoob hatcha “¿K'anta nan k'öbarju wa k'anta jũabarju?” ha k'ĩirjumiet. Hag nawe k'ĩirjuwiajã par k'abahab hajim hanʌm. P'it'urgan hãspapak'ampierr hoojem. Magua maadëu hag nawe k'ĩirjuba hawiajã, hichiita maadëu nem hig nʌm chan chuk k'abajugui hajim hanaabá, magʌm k'ĩirjuju haag. ");
INSERT INTO noaH_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Chik'am hĩgk'am k'õchgaupai chan hoob chik'am pekau p'ëmiet, heeu Hẽwandamau pãach chach nʌm hed magʌm hiek pãachig higduk'am hajim hanʌm Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pãrauta chik'am jaaum k'õchgau “Jãan magta sĩerrʌm” hamʌn, pãachdëu chik'am jaau nʌmjö haju Hẽwandamaujã pãar dʌ̈i. Pãachdëu chik'am jaau nʌmjö hich hag jaautarr hiek'au Hẽwandamaujã pãach k'ĩir pãar jaau t'ʌnʌʌujugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mag simta ¿jãgwi pua sĩi pʌch k'apeer dau hee pasurdam wai simta heerpa nʌʌ haajẽma, pʌch dau heejã hagjö pasur pömk'am wai sim k'augba? Maachin nacha dich k'ĩirjunaata hiek'a nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jãga pua pʌch k'aperag, “Daai kakë, mua pʌ dau heem pasur noi hauk'im” haju, pʌch dau heejã hag k'ãyau nem pöm sim joot'ʌ t'ʌnʌm noi hauba simta? ");
INSERT INTO noaH_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","K'ĩirjug chukdam, nacha dich dau heem pasurta noi hauba haajeeb hajim hanʌm, wajap'a hoog; maimuan chadau jũrr dich k'apeer dau heemjã hagjö noipʌ̈i nʌm. Magua dichta nacha k'ĩirjuba haajeeb chik'am jawaag. Dichjã hagjö chirʌm chan pöd dich k'apeen jaauju k'abam hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Magnaa mag jajawagmamua hichdëupai, ’Saak k'õriimjö sĩsidʌm k'ʌʌnag hoob mʌg pãach peerdʌajem hiek jaaumiet, heeu magbam jãgʌm k'ʌʌnau warag pãach gaai mas haduk'am hajim hanaabá. Mʌg hiekta nem t'umaam k'ãai chi wajapcharam haawai k'ũsnaanjö nem wajap'amjã haai habam k'ʌʌnagjã hoob mʌg hiek jaaumiet, heeu warag sĩi nem parhoobamta jaau nʌmjö hag higwia k'aigba hiyʌ̈ʌ haduk'amgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Maimua hĩchab hich Jesuupai magjim hanʌm: ’Pʌaba jëeubat; pãachdëu nem higbarm Hẽwandamau deeju. Pãrau hi jʌrmʌn, hi baauju; hi sim haar dubaag pãach weeu haupi jëeumʌn, hirua pãar weeu hauju hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, har hõor nem jëeu paraam k'ʌʌnagan deeb k'aba deejem; har hamachdëu nem hinag hig nʌm pʌaba jʌr nʌm k'ʌʌnau baaujem; maagwai hĩchab chi puertdi sirbaichëm k'ʌjã weeu hauwia dubpiejem ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Pãrau hãbmua k'ãijã pãach chaairau t'achdam jëeubaawai, ¿mokdauta p'ëdeeju k'ai, t'ach hawi? ");
INSERT INTO noaH_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wa magbam k'ai, chaairau hãwarrdam k'ãijã jëeu k'itaawai, ¿nemk'õrta hãwarr hawi t'õo deeju k'ai? Ni hãbmuajã mag chan habajugui hajim hanʌm hichdëupai. ");
INSERT INTO noaH_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Magnaa, Pãar jãg hö hãk'ãraa k'it'ëem k'ʌʌnaujã pãach chaainau nem jëeuwai, ¿nem wajap'amjã hĩgk'aba deeba haajẽ? hajim hanʌm. Pãrau jãg deejem k'ai, pãar Haai hʌ̃gt'ar simua chará pãrau pãach chaainag nem deejem k'ãaijã wajapcharamta deebajup hajim hanʌm, hichig jëeu nʌm k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Magua mua pãrag hĩchab mag chirʌmgui hajim hanʌm: Chik'amnau pãach dʌ̈i k'aigba hapimap'a nʌm k'ai, pãach garmuajã hoob chik'am dʌ̈i k'aigba hamiet. Hõrau pãach dʌ̈i hapim k'õsimjöta pãach garmuajã ham dʌ̈i habat hajim hanʌm. Moiseeu ley p'ã pʌatarr gaaijã magta jaaunaa hĩchab Hẽwandamau hich hiek jaaupiejerr k'ʌʌnaujã hich magta jaaujerr haawai, magta haju haai nʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Hʌ̃gt'ar höbërm k'õsi nʌm k'ai, puertdi p'ĩrk'im garta dubju hẽk'abat hajim hanʌm Jesuu. ¿Jãgwi? Dösãt haar maajem k'ʌdta k'ʌdjã pömnaa chi puertdijã nem wäg sĩejeewaima. Mag sim garta hõor pöm hërërëu haajem. ");
INSERT INTO noaH_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pari jũrr hʌ̃gt'ar harrjem k'ʌdan p'ĩrk'inaa chi dub nʌm haram puertdijã p'ĩrk'i k'itʌm. Mag sim haawai chadcha dubju p'it'ur sĩerrʌmgui hajim hanʌm. Magua hĩchab mag gar chan hõor pöm wëtba haajem hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’K'arin Hẽwandamau hich hiek jaaupibaawaita hi hiek jaau wënʌrrʌm haajem k'ʌʌnan chi sëumienta mag wënʌrraajem. Magʌm k'ʌʌn dʌ̈i k'ĩir k'ap'ʌ habat hajim hanʌm. Mag sĩsidʌmta pãar k'ũguraag sĩi ovejadamjö daumeraa pãar haig bëejem. Pari ham hödiin sĩi k'um nem hoo wai simjöta sĩsidʌmgui hajim hanʌm, pãarjã hamachjö hamk'ĩir hamach gar t'ereu hawaag. ");
INSERT INTO noaH_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hich jãg miu gayam uva p'ierrba ni higojã hag bʌ̈ gayam k'abam p'ierrba haajemjö, hamau nem wau nʌm gaaimua pãrau ham k'ap'ʌ haju haai nʌm, hõor wajap'am k'ʌʌná wa hõor k'aigbam k'ʌʌná. ");
INSERT INTO noaH_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pãrau k'ap'ʌ nʌm, nemjĩir bʌ̈ʌn hich chë sim gaaimuata k'ap'ʌ haajem, nemjõ hajap'amʌ́ wa nemjõ k'aigbamʌ́. ");
INSERT INTO noaH_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nemjõ hajap'am chan mie neeme chëba ni nemjõ hãk'ãraamjã mie chukk'u k'aba sĩerrʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pãrau k'ap'ʌ nʌmgui hajim hanʌm hĩchab, nemjõ hãk'ãraa cheejemʌn t'u wërpnaa jʌʌubaadee hörpäaijem. ");
INSERT INTO noaH_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hich hagjöta hajugui hajim hanʌm Hẽwandamau mag sëuk'a nʌrrjëem k'ʌʌn dʌ̈ijã, mag nemjõ hãk'ãraamjöta naawai. Magua k'ap'ʌ habat: Hõran hamachdëu nem wau nʌm gaaimuata hamachdëupai hamach jaaujem, hõor wäjäauná wa hõor k'aigbam k'ʌʌná. ");
INSERT INTO noaH_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mag hiek'ak'agmamua Jesuu magjim hanʌm hĩchab: ’Har mʌrʌg “Señor, Señor” haajem k'ʌʌnjã t'um chan Hẽwandamta t'umaam k'ʌʌn Pörk'a sim haar höbërbam. Chi höbërju k'ʌʌnan, har mʌ Haai hʌ̃gt'ar simua nem jaau sim hipierraa haajem k'ʌʌnpaita hi sim haar höbërjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mag hed paawai hõor pöm t'ʌnʌm heemua mʌrʌg par hamach hip'it'ur, “Señor, pua maar k'augbata sĩeba. Pʌ t'ʌ̃r gaai marau pʌ hiek hõrag jaauba haajeejieb. Pʌ juapaau k'abajieb, marau hõor mor heem mepeerjã jʌr wërpnaa hag na hõrau hooba haajem nempa waaujerr. ¿Magtarrta pua maar k'augba chirʌ́?” hajurau hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pari magbaawai mua hamag, “Mua chan bʌ̃ʌrjã pãar k'augba chitʌm. Pãach sĩi pãach k'õchagpierr nem k'aigbampai wau sĩerrjëe harr k'ap, pãadë warag pãachta mʌ haigmua hërëubaadët” haju ha jaaumajim hanʌm, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Magua, hãbmiecha paawai pãrag mag chirʌmgui hajim hanʌm, hich Jesuu: Chi mʌg mʌ hiek hũrnaa mua jaaumam hipierraa nem wau sim wounan, woun hãb k'ĩirjug k'aug sĩerrau durrk'udau hee hich dibʌ̈ juk'anaa di hëutarrjöta simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mag durrk'u hee hëu sĩerr haawai, noseg pöm chëwia, dö pöm bëewia, p'ũhãd pöm wëtarrjã, chʌababa hich mag sĩsijim hanʌm, durrk'u heeta wajap'a juk'a dʌnarr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pari jũrr har sĩi par jʌ̃gʌupai mʌ hiek hũrnaa mua nem jaau chirʌmjã mʌ hipierraa wauba sim wounan, jũrr hagjö woun hãb k'ĩirjugjã chuk'u sĩi k'õmarii mosjã hee di hëutarrjöta simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ya hëu dʌnʌisim hee noseg pöm chëwia, dö pöm haadëm dʌ̈i p'ũpa wëbaadeewai, sĩi hap'ëbaadëjim hanʌm. Mag, nem t'umaa hok'oojim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chadcha Jesuu mag nem k'ĩir pogk'e jaaubarm hũrwia sĩita hõor jʌ̃gderraa naajim hanaabá, ");
INSERT INTO noaH_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","hamachdëu hũurwai Jesuu Moiseeu ley p'ã pʌarr jawaag chi k'ap'ʌm k'ap'ʌm haajem k'ʌʌn k'ãyaujã jaau k'ap'ʌcha jaaumatarr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mag durrsĩ gaai Jesuu hõrag jaau sĩi hawia hʌʌrbaau, hõor pöoma hi hẽudee wëtjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mag hi mamta hi k'ĩirp'ee woun hãb kokobé bënëu bar sim höbërchëwia hi k'ĩirp'ee jĩepör p'õbk'anaa hirig, —Señor, pua k'õs chirʌm k'ai, mʌg p'ĩedau warre mʌ gaaimua chugpaabapʌ̈i haichëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Magbaa Jesuu hi gaai pʌrnaa, —Mua pʌ monaaupʌ̈im k'õsi chirʌm; monaau chirsí magan hajim hanʌm hirig. Magbarm bʌ̈rre chi p'ĩe k'a dodos chirarr monaau sĩsiewai mor wajapp'a haadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Magbaadeewai chi Jesuu hirig, —Pʌch mʌgbarm hoob chik'amnag jawamgui hajim hanʌm. Magju k'ãai nacha Jerusalén mawia Haai hi jëeujem degam p'adëg pʌch mor hoopibaimá. Maimuan chad pʌch chadcha monaau sĩsim t'umaam k'ʌʌnag k'ap hamk'ĩir, Moiseeu hiek p'ã pʌarr gaai jaau simjö nemchaain ofrendak'a deebá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mag kokobé bënëu sĩerr monaaupʌ̈iwia petaau, p'öbördam Capernaum hanʌm hee dubimajim haajem. Mag barbaimam k'aug hat'aawai capitán soldaaun pör hi haig bëewia ");
INSERT INTO noaH_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","hirig chaigpamamua, —Señor, mʌ di haar haaunaan wai chirʌm, mʌ chog. Sĩi put heepai pöd p'iidʌba k'ërʌm, k'a chʌk'ʌ k'itaawai. Mag nʌm dʌ̈i k'a machagaupata warag heeg pamam hajim hanʌm, chi capitanau Jesuug. ");
INSERT INTO noaH_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Magbaawai Jesuu jũrr hirig, —Hoob k'ĩirjum; mua pʌ chog monaaupäain majugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pari magbaa chi capitán garmua deeu Jesuug, —Señor, pʌ mapimaaugau k'abam, pari mʌ chadcha Hẽwandam dau na hʌ̈u k'aba chirʌm, pʌ mʌ deg dubaag. Hich maupaimua mʌ chog monaaupi jaaubá. Pua mag jaaumʌn, pʌch hiek'au haawai hi monaaubajupa hajim hanʌm Jesuug. ");
INSERT INTO noaH_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Muajã mʌch gaaita k'ap'ʌ chitʌmgui hajim hanʌm, mʌchjã hĩchab mʌch pörnaan jua heegarpai chiraawai. Mag chirab mamʌ, mʌchdëujã hĩchab soldaaun mʌch jua heegar p'ë wai chirʌm. Mak'ʌʌn hee hãbamʌg k'ãijã mua “Pet” haawai maajem, mʌ hipierraa; maimua deeumʌgjã “Pidú” haawai bëejem. Wa mʌch chogag k'ãijã “Mʌgta habá” haawai mʌ hipierr haajem. Magua, maupaimua pua monaaupi jaaumʌn chadcha monaauju k'ap'ʌ chirʌmgui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chi capitanau hich jʌ̃g daar mag hiek'abaawai jʌ̃gderraa haadëmua hich hẽudee wëtmarr k'ʌʌnagta, —Keena, pãadë hoobat: Mʌg maach israelnaan hee mʌg woun dënjö hʌ̈k'a nʌm chan mua hagt'a hooba chitʌmgui hajim hanʌm hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chadcha mʌg hatag hõor pöm durrpierram k'ʌʌnta maach jöoin Abrán k'ararr dʌ̈i, Isá k'ararr dʌ̈i maimua Jacob k'ararrpa hʌ̃gt'ar Hẽwandam dʌ̈i hãbam mes gaai hohood hap'öbaadëju, hi dʌ̈i hãba t'ach k'oog. Maig t'ʌnaaju: hed höbeerjem garm k'ʌʌn dʌ̈i hedau burrjem garm k'ʌʌnpa maach meeun dʌ̈i hãba. ");
INSERT INTO noaH_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pari mag hed pãar chi israelnaanta chadcha Hẽwandam t'umaam k'ʌʌn Pörk'a sim haar naaju haai nʌmta, pãachdëu hʌ̈k'aba nʌm gaaimua pãachta jũrr k'ĩmie durr bark'ʌʌipʌ̈iju hajim hanaabá, hamach k'ĩircha. Mam bark'ʌʌibapäaiwaita hicharaucha pãar bĩep jẽhbʌ habarju. Maigta mamag k'ap'öbaadëmʌn hich maig hich mag nʌisim hiek'au ha jaaumajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mag hiek'apʌ̈iwi deeu chi capitanag heerpanaa, —Pʌch diig petá; pʌchdëu hãba mua pʌch chog monaaujupaita k'ĩirju sĩewai chadcha pʌ chog monaaujugui ha hajim hanʌm hirig. Mag Jesuu “Pʌ chog monaauju” habarm bʌ̈rre mam warp mor mas k'ërarrta chadcha monakk'a haadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Maimua petaau, hich Jesús jũrr Pedro di haar majim haajem. Mam barwi hooimaawai, hich chi Pedro p'aauhũan mor mas k'ʌʌumie paar t'ʌnʌm hooimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mag hoobaimaawai Jesuu hi haar mawi hi jua gaai pʌrbaawai, warre chi k'ʌʌumie meeudʌbaadëjim hanaabá. Mag k'ʌʌumie meeudʌbaadee, p'iidʌwi ham jãhogaagpajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Maimua ya hedau k'ëubaadëm hee, hõor dösãt bënëu sĩsidʌm k'ʌʌn k'apaana Jesús haig waibëemajierram hanʌm. Mag hich haig waibëe nʌm k'ʌʌnan, sĩi par hiek'aupai höbeerpi jaaubaawai, mag ham mor heem bën k'aigbamjã höbeerpʌ̈inaa sĩi k'ajap'am k'amor machgau sĩsidʌmjã monaaupʌ̈i maajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mag hirua hõor monaaumaajerran, warrgar Hẽwandam hi jaaumie Isaías k'ararrau jaautarrjö, “Hichdëuta maach k'a t'ũg hich gaai hauwia, maach k'amor machagjã chugpaapʌ̈ijim” ha simjö, chadcha hich hag heyaa höbërmk'ĩir hajim. ");
INSERT INTO noaH_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mag hõor pöm bëe t'ʌnʌm k'ʌʌnau hich p'ʌʌr t'uurbaadeewai Jesuu hich hag t'ʌrrdö heepai t'oom higar hich harrpijim haajem, hich k'apeenag. ");
INSERT INTO noaH_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pari mag nʌm hee Moiseeu ley p'ã pʌarr jawaag chi machnaan heem hãb bëewi hirig, —Maestro, mʌʌn pʌ mampierr pʌ dʌ̈i chitam k'õsi chirʌm haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Magbaa jũrr Jesuu hirig, —Pʌchdëu mag mʌ dʌ̈i mam k'õsi chirʌm k'ai, marrau magan; mamʌ pʌrʌg jaauk'imgui hajim hanʌm: Mʌ k'ãyau pabʌ̈ heem nemchaain hamach k'ãaijem jẽbdi paraam; nem hichpanjã k'eeupaawai hamach k'ãaijem k'ãidu wai sĩsidʌm. Mamʌ mʌch chi Hemk'ooi Hiewaa chan mʌg chitʌm haig k'ëubaadeewai k'ãyaag wajap'a werba chiraju didamjã chuk'u chitʌmgui hajim hanʌm. Pʌjã mʌjö magta chitam k'õsi chirʌm k'ai, marrau magan hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Magbaawai hãb mag k'apan t'ʌnʌm hee dʌ̈i hi hiek hũraag hi hẽudee nʌrraajerrau jũrr hirig, —Señor, mʌjã pʌ dʌ̈i chitam k'õsi chirʌm, pari hidëu nacha mʌch haai haar mawia hi dʌ̈i chirʌʌ hapibá hajim hanʌm. Mʌg hatag mʌch juadamaucha jöoi hauk'ër pʌabajeen chadau mʌ pʌ dʌ̈i hogdʌba chitajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Magbaa jũrr Jesuu hirig, —Magju k'ãai warre mʌ dʌ̈ita marrau hajim hanʌm. Hidëu har jãg hamach Hẽwandam hiek hʌ̈k'amaaugau chi t'õmjö nʌm k'ʌʌnagta hamach binaan bëppibá hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mag hich harrpibaawai, ya wëtumua Jesús ham na jap hee waaidʌbaadeewai, chi k'apeenau hi harrjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ya mag döjãrr paauk'abaadëm heeta, dëgölp p'ũas meeuk'abaadëwi p'ũas t'eega japau pöd hãwatbajujö haadëjim haajem. Pari mag t'ʌnʌm hee hich Jesús k'ãi jörrajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Magbaawai hi k'apeen hãaur k'ʌʌnau hi p'iriupʌ̈yaan wëtwia hirig, —Señor, p'iidʌbaad. Ya maach k'öogpabahaba. Maar k'aigpër hat'á hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Magbaawai hichdëu hamag, —¿K'ant'eeta hatcha jãp'ierr nʌma? hajim hanaabá. Jãgan pãrau chan mʌ pãach dʌ̈i chitʌmjã k'augbata naab hajim hanʌm, jãgcha jãp'ierraag. Magnaa p'iidʌwia p'ũug meeurrau sĩunaa hĩchab chi p'ũasagjã meeurrau sĩubaawai, tag p'ũjã wëba, p'ũasdaujã baupa k'aba, warre sĩi döjã meuu jöisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jesuu hamach dak'ĩir magbarm hoowia dauderraa nʌmua hamach wir haigpaita, —Keena, ¿k'anim wounta jãg mʌg p'ũasaujã hi hipierraanaa p'ũujã hi hipierraata nʌma hirua hiek'aawai? hanaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mag wëtmaa hawia, ya t'oom higar Gadara durr paauk'abaimaawai, wounaan numí dösãt dau heerpamieu bar sĩsidʌm k'ʌʌnta hujã haarmua höbërdʌtk'achëwi, chi Jesús sim dak'a bëejierram haajem. Mag sĩsidʌmʌn sĩi pabʌ̈ heem nem maach k'oojem k'ʌʌnjöta sĩsid harr haawai mag ham nʌm gar hõor dichju hak'ʌr haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mag hi dak'a bëewi hi t'ʌ̃rcha t'ʌ̃rt'ʌ̃rnaa hirig, —Jesús, Hẽwandam Hiewaa, ¿k'ant'eeta pʌ maar dʌ̈i mʌgbaichëma? Mʌʌgwaiwe chan hoob maar chig ha chiram hajierram hanʌm, mag chi dösãt bën wai narr k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Maigmua warpcha k'aba k'ũsnaan k'apan p'at'au jʌr k'ö wënʌrrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chi mepeenaujã mak'ʌʌn k'ũsnaan maig wënʌrrʌm k'ap'ʌ narr haawai warag Jesuug chaigpanaa hirig, —Pua maar jʌrk'ʌyaagpam k'ai, hidëu warag jãk'ʌʌn k'ũsnaan heeta marag dubpibá hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Magbaawai Jesuu hamag, —Magan jãk'ʌʌn k'ũsnaan hee dubjurauma hajim hanʌm. Magbaawai mak'ʌʌn mepeen mak'ʌʌn wounaan heemua höbërdʌtk'awi jũrr mak'ʌʌn k'ũsnaan heeta dubp'öbaadëjim hanaabá. Magbaawai sĩi pör lököomjö parhooba t'ʌrrdöog k'ap'ig p'öbaadëwi dö hee dʌrbagk'a sĩi k'ũsnaan k'apan k'ẽu k'uurbʌ k'ëchjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Magbarm hoowi, chi k'ũsnaan t'ʌa narr k'ʌʌn jãp'ierrwi, p'öbörög k'ap'ig p'öbaadëwi, mag wounaan numí dösãt dau heerpamieu sĩsid harr mor heem mepeen höbërdʌtk'awia jũrr k'ũsnaan hee dubtarr t'umaa p'öbör heem k'ʌʌnag jaaumajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Magbaawai chi p'öbör heem k'ʌʌn k'apan hag bʌ̈rre chi Jesús haar wëtwi warag hichta maigmua jũrr deeum durrag mapi jaaujierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mag hõor mor heem mepeen jʌrk'ʌʌiwi, deeu hich k'apeen dʌ̈i jap hee pawi dʌrbabaadeeu, deeu t'oom higar hich sĩerr p'öbör hee sĩeimajim haajem, Capernaum p'öbör hee. ");
INSERT INTO noaH_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mag hi barbaichëm k'aug hat'aawai woun hãb sĩi k'apá jʌser k'itʌmta pa bʌʌrk'am gaai hi haig haibëejierram haajem. Mag hich haig haaunaan wai barbaichëm hoowia, chi wounaan hö hak'aar hãba hiruata hamach haaunaan monaaupʌ̈iju k'ap'ʌ sĩerr haawai, chi k'apá jʌser k'itʌmʌgta, —Honee habá, pʌ pekau ya t'um chugpaa sĩsimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pari Jesuu mag hiek'abarm hũrwia, Moiseeu ley p'ã pʌarr jawaag chi machnaanjã haig t'ʌnarr haawai, hamach hödegpai, “Mʌg woun maachjöpai sĩewai mag hiek'aju k'aba simta hichta Hẽwandamjö mag hiek'a sim” ha k'ĩirju naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mamʌ hamau mag k'ĩirju nʌmjã Jesuu k'ap'ʌ sĩerr haawai magbaawai hamag magjim hanʌm: —¿K'ant'eeta pãar jãg t'ãar k'aigbata k'ĩirju sĩsid haajẽma? ");
INSERT INTO noaH_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Wa mag pekau chugpaabarmjã dau daau hooba naawai pãrau k'ĩirjuawai chadcha p'it'urg chuk'u t'umaam k'ʌʌnau mag hiek'aju haai nʌm ha nʌwa? Chadcha t'umaam k'ʌʌnau mag hiek'aju haaima. Mamʌ mua hirig “P'iidʌwi dʌrdʌr habá” hak'iin, hõrau hamach daúacha hooju, hi monaau sĩsi wa monaauba k'ãijã hich mag sĩsim. Magua pãrau cha mua jawaagpamjö chan habaju. ");
INSERT INTO noaH_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mamʌ mʌch chi Hemk'ooi Hiewaata chadcha Hẽwandamau juapá deetarrau mʌig heegar hõor pekau chugpaagjã jua t'eeg chirʌm k'ap hamk'ĩir, pãrag hoopik'imgui hajim hanʌm. Magnaa chi k'apá jʌser k'itʌmʌgta, —P'iidʌbaad, maimua pʌch put juurwia pʌch diig petá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jesuu hichig magbaa chadcha chi k'apá jʌser k'itarrau hi hipierr nem moná p'iidʌbaadëwi hich diig petajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Magbarm hoowia haig narr k'ʌʌn dauderraa nʌisijim hanʌm. Mag nʌm hiek'au warag Hẽwandamagta, “Hʌ̈uhcha jãgbarm, Hẽwandam. Jãan pʌch jua t'eegauta mʌg wounag jãgpibarm” hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mag hãb k'apá jʌser k'itarr monaaupʌ̈iwi bëeuta, hõrau gobiernoog dëbpaar p'agaan bëejem mes gaai mʌ hoo chirʌm hoochëjim hich Jesuu, mag gobiernoog hõrau dëbpaar paraa nʌm jëeu nʌm p'idagta p'idk'a chirarr haawai. Maig mʌ hoobaicheewaita hich Jesuu mʌ t'ʌ̃rcha t'ʌ̃rnaa, —Mateo, mʌ dʌ̈i marrau hajim. Magbaa chadcha mʌ hi dʌ̈i mawia hich mag hi bʌ̈ hogdʌba chirsijim. ");
INSERT INTO noaH_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hag k'ur maach hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌn t'um hãba hich Jesús dʌ̈i mʌ di haig t'ach k'ö naajim. Mag maar t'ach k'ö nʌm haig hĩchab hõor k'apan mʌ k'apeen mʌ p'idk'aajerrjö Romaam gobierno hat'ee dëbpaar jëeujem k'ʌʌn dʌ̈i sĩi hõor hamach k'aigba nʌm gaaimua hagjö t'ʌ̃rp'öo haajem k'ʌʌnpa bëewi maar haig hãbam mes gaai hohood haichëjim. ");
INSERT INTO noaH_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mag hoobaawai, Moiseeu p'ã pʌatarr wajapcha hʌʌrk'aajem k'ʌʌnjã haig narr haawai, jũrr mag maach chi Jesús dʌ̈icha wënʌrraajerr k'ʌʌnagta, —¿Jãga jãg pãar maestro sĩi dëbpaar jëeumien dʌ̈i pekau pöm sĩsidʌm k'ʌʌnpata hãba t'ach k'ö sĩ? ha jëeujierram. ");
INSERT INTO noaH_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pari hamau mag jëeubaichëm hich Jesuujã hũr sĩerr haawai hamag magjim: —Chi k'a monak'a nʌm k'ʌʌnau chan doctor higba haajem; mor masi nʌm k'ʌʌnauta doctor hiigjem hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Maimua magjim hĩchab: —Wajap'a k'ĩirjunaa Hẽwandam hiek p'ã sim gaaim mua jawaagpam k'ap habat. Chi p'ã sim hiek gaai Hẽwandamau mag sim: “Muan pãragan sĩi nemchaainta k'ëchnaa mʌrʌg jëeu nʌʌ haju k'ãai, pãach k'apeenta hʌ̃rcha dau haug k'aug paraa hapim k'õsi chirʌm” ha simgui hajim Jesuu. Maguata muajã ham pekau pöm nʌmjã higba, ham dʌ̈i t'ach k'ö chirʌmgui hajim. Mʌ chan bʌ̃ʌrjã pekau chuk'u wajap'a k'it'ëem haajem k'ʌʌn jʌraanjã bëeba, mʌʌn hõor pekau pöoma k'it'ëem k'ʌʌn peerdʌ hawaanta bëejimgui hajim, k'ĩirjug hiiur haumk'ĩir. Maguata mag hõor pekau pöm nʌmjã higba, ham dʌ̈i t'ach k'ö chirabahab hajim, hamjã Hẽwandam dënk'a hawaag. ");
INSERT INTO noaH_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Maimua ya höbër p'öbaadëm hee, Juan chi hõor pör choomie dʌ̈i wënʌrraajerr k'ʌʌn bëewia Jesuug jëeuchëjierram: —¿Jãgwi maar maimua fariseonaanjã hagjö Hẽwandamag jëeu k'ëwaag hʌ̃iba sʌrk'aajemta, pʌ k'apeenta sʌrk'aba haajemma? haichëjierram hirig. ");
INSERT INTO noaH_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Magbaa Jesuu hamag magjim: —¿Pãrau k'ĩirjuawai jua pʌr nʌm haig hõor t'ʌ̃rk'ʌʌitarr hök'ĩirjuu t'ach k'öba naaju haai nʌ chi jua pʌr sim woun ham dʌ̈i sim haig? hajim hamag. Magnaa hichdëupai, Hich hagjöta nʌmgui hajim mʌ k'apeenjã. Ham hök'ĩirjuu hajuun, mʌ ham jaaijö ham dʌ̈i chitʌm pʌr hat'am hed gayan chadau hamach k'ĩrauta sʌrk'awia hĩchab ham t'achjã k'öba nʌisip haju, gaai machgau. Mamʌ mʌʌgwaiwe chan ham sʌrk'aju k'aba nʌmgui hajim, hagt'a mʌ ham dʌ̈i chiraawai. ");
INSERT INTO noaH_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Pãadë k'ĩirjubat. Pãran chadcha pãach jöoinau jaaujerrjö t'ach k'öba sʌrk'a nʌm. Mamʌ pãrau jãg mua hiek hiiur jaau chirʌmjã k'õsinaa hagjö warrgarm k'ĩirjug chi jöoijã hagt'a k'õsi wënʌrrʌmʌn, magan mag k'ĩirjugan sĩi put hiiur hauwia jũrr k'ajũa jöoi gaai p'ẽek'abarmjöta sĩsimgui hajim. Hãbmua k'ãijã put hiiur k'ajũa jöoi gaai p'ẽek'ak'iin, mag put hiiur hi pächdʌbaadëmua chi k'a sim hee t'ʌrrdʌbaadeeu, warag hich warr sĩerr k'ãaijã nem wäg sĩsijugui hajim hamag. Magua chi mʌ hiek hʌ̈k'a simua chan mʌg hiek hiiur mua jaau chitʌmjã hʌ̈k'anaa pöd hamach jöoin hijã hagjö hʌʌrk'aju k'aba simgui hajim, chi Jesús garmua. ");
INSERT INTO noaH_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mʌg mʌ hiek hʌ̈k'a nʌmʌn vino nemhëu hiiur hee pʌajemjöta simgui hajim. Pãrau k'ap'ʌ nʌm, vino hõrr pöd nemhëu jöoi ya chi pʌajem hee pʌju k'aba sim. Mag pʌk'iin, chi vino hõrr hachpabaadeewai, chi nemhëu jöoiraa sĩewai, hãwatba jẽgdʌbaadee, chi vinojã hãrbaadëm dʌ̈i chi nemhëujã ya tag serbiiba sĩsijugui hajim. Maguata vino hõrran hagjö nemhëu hiiur heeta pʌajem; maagwai nemhëujã jẽgdʌba, chi vinojã hãrbamgui hajim, mag hichig jëeuchëtarr k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mag Jesús hagt'a Juan pör choomieu hõor pʌ̈itarr dʌ̈i hiyʌ̈ʌ dʌnʌm hee, maach meeun heem judío hãb chi pörk'a sim bëewi sĩi hi k'ĩirp'ee kanieu p'õbk'abaichëjim. Mag p'õbk'achëwi hirig chaigpamamua, —Chaigpai mʌ k'adam chugpajimgui hajim. Pari pua mʌ di haar manaa hi gaai pʌrimak'iin, mua k'ap'ʌ chirʌmgui hajim, pua deeu hi hiiu hauju. ");
INSERT INTO noaH_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Magbaawai Jesús p'iidʌwi petaawai maach chi k'apeenjã hi dʌ̈i wëtjim. ");
INSERT INTO noaH_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pari mag wëtum hee, hʌʌi hãb p'õmieu bar sim bëewi meraa hëugarmua hi k'ajũa hi gaai pʌrchëjim, hich hödegpai “Nau hi k'ajũa gaai pʌrbarmuapai mʌ monaauju” ha k'ĩirjuwia. Hich mag hʌʌi doce años mag p'õmie dʌ̈i sĩejim, bʌ̃ʌrjã chugpaa k'augba. ");
INSERT INTO noaH_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pari mag hich gaai pʌrbaichëmjã k'ap'ʌ sĩerr haawai hich chi Jesuu hirig hewag p'ʌʌrba hoonaa, —Hoob chigaa ham; mua pʌch monaauju k'ap'ʌ mʌ gaai pʌrchëtarr gaaimua, hʌ̈u pʌ monaauwi peerdʌjã peerdʌ hʌisibahab hajim chi hʌʌirag. Mag, chadcha Jesuu magbarm bʌ̈rre mag hʌʌi monaau sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Maimuan chad warag hërëubaadëwi, chi binaandam wai narr di haar barwi hooimaawai, hök'ĩirjuu nʌm hiek'au sĩi hʌ̈rrsirpa jẽb t'ʌnʌm dʌ̈i gaai machgau bĩep sereu t'ʌnʌmta hooimajim, hamach hi harr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Magbaawai hamag, —¿K'ant'eeta jãg t'ʌnʌ́ma? Chaai meeba sĩita k'ãi sĩebahab hajim. Magnaa, Jöpcha dawag hërëubaadët hajim hamag. Pari hirua mag hiek'a sim hũrwia haig t'ʌnarr k'ʌʌnau warag hi wau hiek'a naajim. ");
INSERT INTO noaH_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Maimua hõor t'um dawag höbeerk'apʌ̈iwia, chi binaandam haar dubwi, hi juadam gaai pʌrbaimaawai warag dʌ̈i pʌr p'iidʌbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mag hirua chaai p'iriu hautarran hich hag durr hee warp'am magweta bĩi jöisijim. ");
INSERT INTO noaH_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mag Jairo k'a deeu hiiu hauwia petaau, dau k'ĩsu k'it'ëem k'ʌʌnta numí hi hẽudee hähäag wëtjim. Mag hähäak'amua, —Jesús, pʌʌta rey David k'achitarr hag chaain hewagam k'ʌʌn Hiewaa marau nʌ narr; maar hapdurrum maar dau haug k'augbahur haajeejim, hamach dau monaaupäain bëemk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pari Jesús warag hich jẽer sĩerr diig majim. Pari magʌmjã pʌaba hi hẽudee wëtwi, hich haar bardʌtk'abaimaawaita, hamag, —¿Pãrau k'ĩirjuawai mua chadcha pãar dau monaaupʌ̈iju chirʌ́? ha jëeujim. Magbaawai hamachdëu, —Hëera, marau k'ap'ʌ nʌmgui hajierram, chadcha pua maar dau monaauju. ");
INSERT INTO noaH_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Magbaawai Jesuu ham dau hëu haait'ʌ haait'ʌnaa, —Mua pãach dau monaaupʌ̈ijuuta pãachdëu k'ĩirju narr haawai chadcha pãar dau monaaupʌ̈ik'imgui hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mag chadcha hirua magbarm bʌ̈rre hamach numwe sĩi daujã wajapp'a hap'öbaadëjim. Maimua Jesuu hamag bʌ̃ʌrjã bit'urgam k'ʌʌnag jaaupibajim mag hamach dau monaaubarm. ");
INSERT INTO noaH_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pari magtarrta, sĩi haigmua höbër p'öbaadëwi hich mag durr heepain hamach wënʌrrʌmpierr jaaumajierram hanaabá, jãga Jesuu ham dau monaaujĩ. ");
INSERT INTO noaH_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mag dau k'ĩsu k'it'ëe harr k'ʌʌn Jesús haig naawi daau paauk'abaadëm hee, jũrr woun hãb pöd hiek'aba k'itʌmta hi haig haibëejierram. Ma pör bënmie paraa sĩejim, dösãt bën. ");
INSERT INTO noaH_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mag hich haig waipierrwai mag bënjã Jesuu jẽu werbajim. Magbaa mag meu meraa sĩerrta nem meu höp'ërg hich mʌg hiek'a sĩsijim. Magbarm hoowi hõor dauderraa nʌm hiek'au, “Keena, mʌig Israel durr chan maach hee hag na maadëu mʌg hooba haajerr hĩsta chadcha maadëu mʌg hoo nʌmwai” haajeejim jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pari bit'urgam k'ʌʌnau sĩi mag durrum hee, jũrr fariseonaanau warag ham hichaaur, “Jã sĩi dösãtnaan pör dʌ̈i k'apeerk'a sĩewaita hag juapaauta hirua jãg hõor mor heem mepeenjã dau daau jʌrk'ʌʌi sĩebahab” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús p'öbörpierr nʌrrʌmua didam k'apan k'aba k'ëk'ëdʌm heem magwe p'ʌʌrdʌ nʌrraajeejim. Mag nʌrrʌmua Hẽwandam hiek jaaujem deg dubwi maach peerdʌajem hiek jaaumamua, “Hẽwandamta maach t'umaam k'ʌʌn Pörk'aimʌʌ sim; magua hirigta hidëu pãach t'ãar hajaug paapibat” ha jaaujeejim. Mag nʌm dʌ̈i hĩchab hõor k'amor machagjã k'ĩirpierr monaaumaajeejim, k'a mamachdögpa. ");
INSERT INTO noaH_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mag nʌrrʌmua sĩi hõor pöoma oveja chaaindamta chi t'ʌajã chuk'u sĩi dau hap'ʌʌ parhoob haaidʌ t'ʌnʌmjö hoobaawai, ham dau haug k'augwi, ");
INSERT INTO noaH_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","maar hich k'apeenagta, —Chadcha Hẽwandam hi jaau nʌmʌn, arrozdö pöm p'ur wëjömjöta p'idag pöoma simgui hajim. Mag simta chi jaau wënʌrraju k'ʌʌn chan k'apan k'abata durrum. ");
INSERT INTO noaH_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Magua muan pãragan Hẽwandamag jëeubat ha chirʌmgui hajim, warag hich hi jaauju k'ʌʌn k'apan jöp'ëecha hich hi jawaan pʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Biek hãb Jesuu maach hich k'apeen doce hich dʌ̈icha hogdʌba wënʌrraju k'ʌʌn hich haig t'ʌ̃rk'a hauwi maachta mepeen k'ãaijã jua t'eeg hʌ̃rcha hapijim, bën hõor mor hee sĩsidʌmjã maach jua jʌmpiba jʌr wërpnaa, haaunaanjã hamach k'amor machagpierr monaaunaa, sĩi pa mamachdögjã monaaumamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mag maach hich hiek jaaumk'ĩir hichdëucha doce jʌr hautarr k'ʌʌn mʌk'ʌʌn hajim: Simón, (hichpai Pedro ha t'ʌ̃ʌrjem); Andrés, chi Simón heeum; Santiago, jöoi Zebedeo hiewaa, (hichpai hĩchab Jacobo haajem); Juan, hagjö jöoi Zebedeo hiewaa, Santiago heeum; ");
INSERT INTO noaH_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo, gobierno dëbpaar jëeumie harr, (hajapcharan mʌchma, mʌchpai hĩchab Leví haajem); Santiago, jöoi Alfeo hiewaa, (hichpai hĩchab Jacobo haajem); Tadeo, hichpai hĩchab Lebeo ha t'ʌ̃ʌrjem; ");
INSERT INTO noaH_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, celotenaan hee sĩerr; maimua Judas Iscariote. Maagwai maadëu k'ap'ʌ chirarr hak'iin, hiin mag Judas Iscarioteeuta t'et'em k'ʌʌnag Jesús pʌr deeju hajima, hi t'õomk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mak'ʌʌn doce hich Jesuucha jʌr hautarr k'ʌʌnta hichdëucha pʌ̈ijim. Pari mag maar pʌ̈yaagpamua marag, judionaan k'abam k'ʌʌn hee chan wëtpiba, ni Samaria durram p'öbör heejã wëtpiba jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","—Magju k'ãai maach judionaan hee Hẽwandam hiek hʌ̈k'abagau oveja pap chuk'u hok'oo wënʌrrʌmjö t'ʌnʌm k'ʌʌn heeta hërëubaadët hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mag wënʌrrʌmua hamag, “Hẽwandamta t'umaam k'ʌʌn Pörk'aimʌʌ sim; pãar peerdʌju k'ai, hirigta hʌdʌraa pãach Pörk'apibat” ha jaaupetat hajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Magnaa haaunaanjã monaaunaa, kokobé bënëu sĩsidʌmjã monaaunaa, hõor chi meemjã deeu p'iriu haunaa, hõor mor heem bënjã jẽu wërppetat. Pãrag magamk'ĩir mua mʌch juapá sĩi parta dee chirʌm haawai pãachdëu hõor dʌ̈i mag nʌm paarjã hoob jëeumiet hajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mag jajawagmamua, ’Hoob hagʌmua nem përk'oog hawi p'atk'on k'ãijã harrmiet. ");
INSERT INTO noaH_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni k'ʌd jãrr t'ach k'oogjã hoob p'iejãb harrmiet hajim. K'ajũajã pãach mor gaaim happai harrwi zapatjã pãachdëu jũa nʌm happaita hat'aadët. Bordonjã chuk'u hich jãg hërëubaadët hajim. Mua pãrag mag chirʌmʌn, pãachdëu ham dʌ̈i wajap'a nʌm k'ʌʌn hõraupai hagjö pãrau nem higbarmjã k'ap naaju haawaita bʌ̃ʌrjã nem harrpiba chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","P'öbör hee pãach dubimaawai, wa sĩi didam k'apan k'abam haig k'ãijã pãach barimaawai, k'ap haag nacha jëeu hoobat, k'ai di haigta pãach jẽerimaju haai nʌ ha k'ap haag. Mag pãach jẽerbaimam degpai naawia hërëubaadët ha jaaumajim, sĩi parhoob dipierr k'ãi wënʌrraba. ");
INSERT INTO noaH_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mag pãach jẽerimaju di haig barimaawaijã wajap'a saludaabat hajim chi di k'ʌʌn dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chadcha hamau mag pãar hamach haig jẽerpimʌn, pãach Hẽwandam dʌ̈i k'õinaa wënʌrrʌmjö hamachjã hi dʌ̈i k'õinaa naaju. Magbam chan hamachta warag Hẽwandam dʌ̈i k'õinaa hajujã k'augba nʌisiju. ");
INSERT INTO noaH_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Maagwai pãach hamach haig barpiba ni sĩi pãach hiekpaijã hũrmap'a habaawai mag di haigmua wa mag p'öbör heemua k'ãijã hërëubaadët hajim. Mamʌ mag wëtaagpamuajã warre hamach dak'ĩirwe pãach bʌ̈ gaaim jẽb hʌʌrp'ë hʌʌrp'ënaa hamag, “Pãachdëu jãg hũrba habarm gaaimua Hẽwandam dʌ̈ita k'ĩir k'ap habat” ha hiek'awia hërëubaadët hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mʌ cha hiek'a chirʌm hiek'au, mag hamau pãar higba, ni pãar hiekjã hũrmap'a habarm jũrran warrgar Hẽwandamau Sodomapien dʌ̈i maimua Gomorrapien dʌ̈i hatarr k'ãaijã ham gaai hat'uuchata burrju ha jaaumajim hich Jesuu maachigcha. ");
INSERT INTO noaH_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mag maar pʌ̈yaagpamua hĩchab marag magjim: ’Mua chadcha pãar pʌ̈i chirʌm, pari mʌ hiek hũrbat hajim: Pãran sĩi oveja chaaindam k'um nem t'ʌnʌm hee pʌak'ʌʌibapʌ̈imjöta habarm, hõor k'aibagk'am heeta wënʌrraju haawai. Magua, mʌch himeerba muan pãragan, k'ĩirjug k'aug hichk'umjöta habat ha chirʌm. Mag naab mamʌ hĩchab k'ĩir machag chuk'u duburdamjö habat hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","K'ĩir k'ap'ʌ wënʌrrat'ʌ̃. Pãran hõrau pʌr harrwi Hẽwandam hiek jaaujem degam chi t'et'emnaanag deebaimap haju. Magbaa hamau pãar wʌjã wʌmaju. ");
INSERT INTO noaH_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mʌ gaaimua pãar k'aibag waumk'ĩir, hõrau pãar gobernadornaan haarjã harrnaa reinaan haarjã haharr haju. Pari mag chi t'et'emnaan haar pãach harrwai, hʌ̈u pãrau hamag hũrmk'ĩir mʌ jaaunaa sĩi judionaan k'abam k'ʌʌnagjã mʌ jaaujurau. ");
INSERT INTO noaH_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pari mag chi t'et'emnaanag pãach pʌr deewaijã hoob pãach kõit pãachdëupai hiek'aju k'ĩirjuwia hag nawe, “¿Mʌ k'an hata hiek'ajuwa?” ha k'ĩirjumiet hajim, ya pãar hiek'aagpaawai hich Hẽwandamauta hichdëu k'ap pãrag hiek'apiju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mua pãrag mag chirʌmʌn, pãar Haai hʌ̃gt'ar sim hag Hak'arauta pãrag hiek'amk'ĩir k'ĩirjug deeju haawaita mag chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Mag jaran wir haig k'od hãbam k'ʌʌnjã chi hʌ̈k'aba sim garmua hʌ̈u mʌ hiek hʌ̈k'a k'ërʌm t'et'emnaanag jaaupʌ̈imajugui hajim, hich k'odpai wir haig t'õomk'ĩir. Hamach dënnaanjã hagjö mʌ gaaimua t'õomk'ĩir t'et'emnaanag jaaupʌ̈imaawai chi dënnaanaujã hich hagjö haju hamach chaain dʌ̈i wir haig. ");
INSERT INTO noaH_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mʌ gaaimua t'umaam k'ʌʌnau pãar hoomapp'a haju, pari hõrau pãach dʌ̈i mag nʌmjã magʌm hiek higba warag Hẽwandam dʌ̈ita hubʌnaa hich gaai magʌm dichpi hat'amʌn, hʌ̈u peerdʌwi hʌ̃gt'archa höbërjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pãach nʌm p'öbör hee pãach t'et pʌrbaichee jũrr deeum p'öbörög hërëupetat. Mag wënʌrrʌmua mʌg Israel durr p'öbör k'apan nʌnʌidʌm hee dʌrju jʌr wënʌrrawiajã, pãrau p'öbör t'um p'ʌʌrpʌ̈iju nawe mʌch chi Hemk'ooi Hiewaa deeu pãar hee chiraichëjugui hajim, magbarm haigmua Hẽwandamta hõor t'ãar hee chi Pörk'aju haai sim k'ap hapieg. ");
INSERT INTO noaH_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Mag pãach dau hap'ʌʌ haju hanʌm hũurwaijã hoob jʌ̃gderraa hamiet hajim. Pãrau k'ap'ʌ nʌmgui hajim, heeu nem k'aug simua chan hich maestro k'ãai hatcha nem k'aug k'aba, ni sĩi chik'am chogk'a simjã hich patrón k'ãai hʌ̃rpai k'aba sĩejem. ");
INSERT INTO noaH_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Magua, hãb k'ãijã chadcha hich maestroou jaau simjöta nʌrrʌm k'ai, magan chi maestro dʌ̈i haajemjö haju hi dʌ̈ijã. Jãga chi patrón jöoi dau hãauk'a nʌm hee chi chognaanta daupii habarju. Maguama, mʌch pãar Pörk'a chirʌmʌg hõrau mʌʌn mepeen pör Beelzebú dʌ̈ita chirʌm ha hiek'aajeewai pãrag chará hamau hat'uucha k'aigba hiek'ajugui ha jaaumajim maachigcha. ");
INSERT INTO noaH_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Mʌg jẽb gaai maach wounaan hãba t'ʌnʌm k'ʌʌn hoob högk'amiet, pãach t'õoju k'ĩirjuwia. Hamaun mʌig heegar hamachdëu pãar dʌ̈i mag k'aigbanaa parhooba k'ãijã hiek'abarmjã sĩi hich mag k'ĩir hok'oojupii haju. Mamʌ magtarr hiek'an mʌg hatag paawai Hẽwandamau deeu heeupemjö hëudʌ hauwia t'umaam k'ʌʌnag hũrpijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mag pãar dau hap'ʌʌ hajujã chadcha hĩs mua meraamjöta jaau chirʌm, maach happai. Mamʌ pãach peerdʌajem hiek pãachig jaaujem chan hik'ʌa jaauba, t'etta jaaupetat hajim, t'umaam k'ʌʌnag hũrmk'ĩir, mag chi hũr nʌm k'ʌʌnau pãach dʌ̈i k'aigba hajujã k'ĩirjuba. ");
INSERT INTO noaH_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hamau pãar chi hʌ̃rʌmʌn chadcha t'õoju hawiajã t'õoju; pari pãar hak'aar chan pöd t'õo haubam. Magʌm k'ʌʌn hoob högk'amiet hajim. Magarrau högk'aju hawiajã pãach chi hʌ̃rʌmjã t'õowia pãach hak'aarjã k'ĩmie durr hich mag sĩerramk'ĩir barpʌ̈yaagjã jua t'eeg simʌn chadau, chadcha hök'ö habat hajim, Hẽwandam higwi. ");
INSERT INTO noaH_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Pãrau k'ap'ʌ nʌm, nemchaaindam par herraam gaai për haaujem. Pari mag baleebamjö k'it'ëe hab mamʌ, maach Haai hʌ̃gt'ar chiraajemua t'õpibam haig chan hãbjã t'õba haajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Magʌm pãar chará nemchaain k'ãaijã hʌ̃rcha balee naawai pãarta hirua wajapcha t'ʌa wai sĩejem. Hichdëun pãar pörbʌ̈ k'apanagjã k'app'ʌ wai sĩejem. ");
INSERT INTO noaH_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Magua, hoob hatcha pãach k'ĩirjumiet; pãarta nemchaain k'ãaijã hʌ̃rcha balee naabahab hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Hãb k'ãijã mʌ higar sĩewai hõor dak'ĩirjã meerba mʌ hiek hʌ̈k'aajem ha jaau sim wounan, muajã hĩchab mʌch Haai hʌ̃gt'ar sim dak'ĩir, “Jãan chadcha mʌ garmʌu” hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mamʌ jũrr hãbmua k'ãijã hõor dak'ĩir mʌ higwi “Mʌ chan hi higarm k'abam” ha sim wounan, muajã hĩchab mʌch Haai hʌ̃gt'ar sim dak'ĩir, “Jã chan mʌ dën k'abam, mua hi k'augba chitʌm” ha hiek'aju hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Hoob pãrau, mʌʌn sĩi mʌg durr gaai hõor k'õinaa bibigagjã chuk'u hapiegta bëejim hamiet. Mʌ chan pãar k'õinaa hapieg k'aba, warag hiek p'it'urg hapiegjöta bëejimgui hajim hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mʌ mʌig mʌg durr gaai bëetarran, mʌch hiek gaaimua chaain chi hemk'ooinjã hamach haai dʌ̈i k'aigba, chi hʌʌinaujã hamach hãd dʌ̈i k'aigba maimua chi hãignaanjã hamach p'aauhũan dʌ̈i k'aigba jũrr chik'am hichaaur haadëp'ʌm gaaimua hiek p'it'urg hapiegta bëejimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wajapcharan deeum k'ʌʌnjã k'aba, dich wir haiguim k'ʌʌnpaita k'a huk'ur t'ʌnaajugui hajim, hiwiir hãbmua mʌ hiek hʌ̈k'amap'a haadëp'ʌm gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Hãbmua k'ãijã hʌ̃rcha hich haaita mʌ k'ãai k'õsi wa hich hãd k'ãijã mʌ k'ãaijã hʌ̃rcha k'õsi sim chan magan mag woun chan mʌ dën haju k'aba simgui hajim. Wa magba mʌʌta hʌ̃rcha k'õsi haju k'ãai, hich hiewaa wa hich k'a k'ãijã hʌ̃rcha k'õsi wai sim wounjã mʌ dën haju k'aba simgui hajim hĩchab. ");
INSERT INTO noaH_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chi mʌ dʌ̈i nʌrram k'õsi simuan warre hich p'it'urg hau nʌrrajujã k'ap'ʌ haju haai sim, mʌ gaaimua chik'amnau hich t'õoju k'ap'ʌ hawiajã hich mag mʌ bʌ̈ hogdʌba nʌrraju haawai. Mag hãwatbaju chan parta hidëu k'õs mʌ dʌ̈i sim ha hiek'ajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Har mʌ gaaimua bʌ̃ʌrjã p'it'urg haumap'a sim chan meem hedjã hʌ̃gt'ar höbërbam. Mamʌ har mua nem jaau chirʌm waum k'õchgau wa mʌ gaaimua k'ãijã dau hap'ʌʌ habarmʌn chadau hʌ̃gt'archa höbërjugui ha jaaujim maachigcha. ");
INSERT INTO noaH_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mag hiek'ak'agmamua marag, ’Pãar mʌ hiek jaau wënʌrrʌm haig, hõrau hʌ̈uta pãar hamach haig baarpinaa pãar hiek hũr nʌmʌn magan mʌpata hĩchab hʌdʌʌr hamach haig barpi nʌmgui hajim, muata pãar pʌ̈i chiraawai. Mag hamau mʌjã hamach haig barpi nʌm haig, hich chi mʌ pʌ̈itarr Jöoipata barpi nʌmgui hajim, mʌchjã hichdëuta pʌ̈itarr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hẽwandamau hich hiek jaaumk'ĩir jʌr hauwi pʌ̈itarrta hʌ̈u hamach haig hau nʌm k'ʌʌn dʌ̈in, mag hichdëu pʌ̈i sim dʌ̈i hajap'a habarmjö haju ham dʌ̈ijã; maimua sĩi woun wajap'am k'ãijã hagjö hamach haig haumʌn, hi dʌ̈i hajap'a harrjö hajugui hajim hĩchab ham dʌ̈ijã. ");
INSERT INTO noaH_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Maimua hãbmua k'ãijã mʌg mʌ hiek hʌ̈k'awi mʌ hiek jaau durrum k'ʌʌn hamach haig barimaawai nemdam bʌ̃rʌʌm k'ãijã deem k'õsi deemʌn, magtarr paar hagjö hĩchab Hẽwandamau hirig nem wajap'am deeb k'aba deejugui ha jaaumajim. ");
INSERT INTO noaH_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mag maach doce hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnag mag nem jaaudubwi, wëtpi jaaubaawai, maar wëtjim. Magbaawai jũrr hich deeum p'öbör nʌnʌidʌmʌg petajim, hich hag durr heepai, mamaam k'ʌʌnagjã hagjö maach peerdʌajem hiek jawaag. ");
INSERT INTO noaH_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hich maagwai Juanau cárcel deg simua Cristoou nem wau nʌrrʌm hũr sĩejim haajem. Magbaawai hich k'apeen heem hãaur k'ʌʌn hich haig t'ʌ̃rk'a hauwi chi Jesús haar pʌ̈ijim haajem, ");
INSERT INTO noaH_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","hi haar mawi, hiita chadcha hich Hẽwandam hi jaaumienau jaauwai Hẽwandamau pʌ̈iju jaaujerrá wa har k'abam k'ai hich jãg nʌag ha k'ap jëeumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mag bëewi, chadcha hichig jëeubaicheewai, hich Jesuu hamag, —Hërëubaadëwi Juanag jaaubaimat hajim hanʌm, pãach jʌ̃gʌucha hũrnaa pãach daúacha mʌg hoobarm. ");
INSERT INTO noaH_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hirig, “Dau k'augba k'ëk'ëd harr k'ʌʌn dau wajap'a t'ʌnʌm” habat. “Bʌ̈ wëdʌ wëdʌ sĩsid harr k'ʌʌnjã ya wajap'a nʌrrjëem. Kach k'ĩsu sĩsid harr k'ʌʌnjã wajap'a hũr sĩsidʌm. Chi meem harr k'ʌʌnjã deeu hiiu nʌrrjëem, maimua hap'ʌʌm k'ʌʌnagjã hĩchab hõor peerdʌajem hiek jaau chirʌm” ha jaaubaimat hajim. ");
INSERT INTO noaH_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Magnaa hĩchab hirig, “Chi mʌ hiek hʌ̈k'awi hogdʌba mʌ gaai hʌ̈k'a chirʌm wounan honee hich mag chitaju ha jaaubaimat” hajim hanʌm, mag hichig jëeuwimarr k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mag chi Juan k'apeen hich haig naawi deeu hërëubaadeewai, hich haig narr k'ʌʌnagta Juan higwi hiek'amamua hamag magjim hanʌm: —Pãrau Jordán higaau woun Hẽwandam hi jaau nʌrrʌm hoon weetwai, ¿sĩi woun hiek t'eeg chuk'u p'ũu choomaar sõsõii jũurba hahau haajemjök'amta hoon wëtjierrá? Magʌm woun k'abajim. ");
INSERT INTO noaH_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Magan, ¿k'anim wounta hoon wëtjĩma? hajim hanʌm hamag. ¿Woun k'ajũa wajap'a jũa simta hoojupii hawi hoon wëtjierrá? Pãrau k'ap'ʌ nʌmgui hajim hanʌm, k'ajũa wajap'a jũajem k'ʌʌnan sĩi p'öbör hee di hooimʌm heeta naajem, reinaan dʌ̈i hãba. ");
INSERT INTO noaH_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mamʌ pãrau magjömta hooimabajierram. Pãrau hooimatarran woun hãb Hẽwandam hi jaau nʌrrʌm hajim. Mamʌ pãadë hũrbat: Juan chan warrgar Hẽwandam hi jaaujerr k'ʌʌnjöpai k'aba, ham k'ãaijã hʌ̃rpaita simgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hi higwia Hẽwandamau hich hi jaaumienag warrgarwe hich hiek p'ãpitarr gaai jaauwai, Jãata hirua mʌ na pʌ̈iju hajim, hichdëuta mʌ na mʌ maju hee hõrag jaau peetwai t'umaam k'ʌʌnau mʌ hiek hũrm k'õsi sĩi mʌ nʌ naamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Magua, mua pãrag mʌch himeerba jaau chirʌmgui hajim hanʌm hich Jesuu: Warrgar Hẽwandam hi jaaujerr k'ʌʌn heejã Juan chi hõor pör choomie k'ãai hʌ̃rʌʌcharam chan hãbjã chuk'u hajim. Mamʌ chi mʌ hiek hũrwia, mua nem waubarmjã k'ap'ʌnaa, Hẽwandamta hich t'ãar hee hau sim wounan chadau, maadëu nem higba k'itawiajã, Juan k'ãyau k'apcha hajugui hajim hanʌm, jãga Hẽwandam hichdëu hõor peerdʌ hat'am t'ãar hee sĩeicheejẽ. ");
INSERT INTO noaH_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mag jaaumamua, ’Pãrag jaauk'imgui hajim hanʌm: Juan sĩsierr haigmua hĩs hewagjã chadcha hõor pöm Hẽwandamagta hamach t'ãar hajaug paapinaa hamach Pörk'a haum k'õchk'a t'ʌnʌm. Pari hamau mag hẽk'a durrum dʌ̈i hĩchab chi t'et'em k'ʌʌnau jũrr k'ajap'am nemjö mag Hẽwandam hamach Pörk'a hauju hiekta warre chugpaapʌ̈iju hẽk'aajem. ");
INSERT INTO noaH_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Warrgar Hẽwandam hi jaaujerr k'ʌʌnau jaaujerr hiek dʌ̈i Moiseeu ley p'ã pʌatarran, sĩi Juan bëe nʌm hora Hẽwandamauta mag hõor t'ãar hajaug paanaa ham Pörk'aan bëeju k'ap jawaag hajim. Magtarr haawai Juan bëewi jaauchëtarran mag warrgarwe mʌ higwi hamau jaaujerrjö haadëm hajim. ");
INSERT INTO noaH_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Maagwai mag hi hiek hʌ̈k'am k'õsi nʌm k'ʌʌnau k'ap'ʌ hajugui hajim hanʌm, Juanan warrgarm profeta Elías haajerr bëeju jaaujerr kõit pʌ̈iwiata jãg nʌrrajim. ");
INSERT INTO noaH_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Magnaa hich Jesuupai, ’Keena, jʌ̃g hʌ̃rʌʌnaa cha mua jaau chirʌm wajap'a hũrbat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mag hiek'ak'agmamua, maach Pör Jesuu haig narr k'ʌʌnag, ’Mua pãrag jaauk'imgui hajim hanʌm, pãar jãga nʌm habarí. Magnaa, Pãar har Juan hisegwi mʌjã hiseg nʌm k'ʌʌnan, chaain jemk'a nʌmua hamach k'apeen dʌ̈i k'ĩir haup'öbaadëmjöta nʌmgui hajim hanʌm. Warm k'ʌʌn garmua, “Maar dʌ̈i karris sir nʌm gaai honee jemk'abahut” haawaijã jemk'amap'a nʌm. ");
INSERT INTO noaH_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Maimua jũrr, “Magan sĩi hök'ĩirjuu hõor mee wai nʌm haiguimjö hohood habat” haawaijã magjã k'õchk'aba nʌmgui hajim hanʌm. Paarjã magta naawai, ¿k'ani k'õsi nʌmma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pãar hee Juan chi hõor pör choomie nʌrraajeewai hirua Hẽwandamag jëwaag sʌrk'aajeejim, hajap t'ach k'öba. Magʌm vino chará bʌ̃ʌrjã döbajim. Mamʌ mag hoowi pãrau, “Jãan mepeer dʌ̈i k'apeerk'a sĩewaita sĩi hich jãg haai t'ach k'öba nʌrraajem” ha hiek'aajem pãrau. ");
INSERT INTO noaH_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mamʌ hĩs mʌch chi Hemk'ooi Hiewaa chaar bëewi, pãach dʌ̈i parhooba t'achdamjã k'önaa vinodampa dö k'itaawai, jũrr magjã k'õchk'aba warag pãrau mʌ hëugar, t'ach bipöm k'önaa vino pigjã chitʌm haajem. Magnaa gobierno dëbpaar jëeu nʌmua hõor k'ũguurjem k'ʌʌn dʌ̈ijã k'apeerk'anaa pekau pöm sĩsidʌm k'ʌʌn dʌ̈ipa k'apeerk'a chitʌm ha hiek'aajerramgui hajim hanʌm, mʌjã hiseg nʌm hiek'au. Pari har chi Hẽwandamau k'ĩirjug deetarraucha k'ĩirju nʌm k'ʌʌnau chan magba, hamau chadcha k'ap'ʌ nʌm, chijã k'ʌʌnta hich Hẽwandamaucha pʌ̈itarr k'ʌʌn hagá ha hiek'amajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesuu hoowai hirua hʌ̃rcha hag na hõrau nem hooba haajem nem waumatarr p'öbör heem k'ʌʌnauta bʌ̃ʌrjã Hẽwandam higba ni hi hiekjã hʌ̈k'aba naajim hanaabá. Magbaawai k'ĩesir hiek'amamua mak'ʌʌn p'öbör heem k'ʌʌn higwiata magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Hëh, hapdurr, Corazinpien! ¡Hëh, hapdurr, Betsaidapienjã hagjö, Hẽwandamau ham hi hagk'am hed! Ham hee nem hooba haajem nem wau nʌmua Hẽwandamau hich juapá hoopitarr Tiro p'öbör heeta wa Sidón p'öbör hee k'ãijã wautarr hamuan, nawe hamau hamach k'ĩirjug k'aigbam hisegwi sʌrk'ak'amgui hajim hanʌm. Magtarr hamuan hamau t'eerju t'eerwia, hʌ̃r jupnaa, putiu pör börrnaa, k'oopa nʌm k'ʌʌn sʌrk'aajemjö sʌrk'ak'am. Mag nʌmua hamau hamach mor hãsie hewag k'ĩirjuwia Hẽwandamag jëeuk'am, hamach k'aibag chugpamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pari cha mʌ hiek'a chirʌm hiek'au Hẽwandamau mʌg durr hi hagk'am hed Corazinpienta Betsaidapien dʌ̈i hirua ham gaai masiicha waupʌ̈ijugui hajim hanʌm, Tiropien dʌ̈i Sidonpien k'ãaijã, hamachdëu hũrtarrta hʌ̈k'aba harr gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Maagwai Capernaumpien higwiajãh, ¿k'an habarju? hajim hanʌm. Magnaa hichdëupai, ¡Hëh! Hamaun hamach t'ö nʌmgui hajim hanʌm, hamachta chi wäjäaun hawia. Hamaun hʌ̃gt'ar paauk'abaimaajã hamachta chi pörnaan k'ajupii nʌm. Mamʌ jãk'ʌʌn chan Hẽwandamau hich haar höbeerpiba, k'ĩmie durrta warag bark'ʌʌipʌ̈ijugui hiek'amajim haajem. Sodoma p'öbör heeta jãg pãar hee hõrau hooba haajem nem waumatarr wautarr hamuan, jãg p'öbör hagt'a sĩerrak'am, Hẽwandam hiek hʌ̈k'atarr gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pari mʌ cha hiek'a chirʌm hiek'au Hẽwandamau mʌg durr hi hagk'am hed gaai, pãar gaaita Hẽwandamau hat'uucha mas deejugui hajim hanʌm, Sodomapien k'ãaijã. ");
INSERT INTO noaH_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hich mag jaar hĩchab hich Jesuu hich Hayag jëeumamua, —Tata, mua pʌrʌg hʌ̈u hajim ha chirʌmgui hajim hanʌm, pʌchta hʌ̃gt'arm magwe nem t'um mʌg wëjöm Pör haawai. Mʌ honee chirʌmgui hajim hanʌm, hõor hamach k'ĩirjug k'aug t'öwia, nem t'um k'ap'ʌm k'ap'ʌm haajem k'ʌʌnaujã hamach peerdʌju hiek k'augba harrta, jũrr pua k'ĩirjugdam meraa chaainjö k'it'ëem k'ʌʌnagta hʌ̈u k'augpibaawai. ");
INSERT INTO noaH_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chadcha puata nem wajap'a waaujem Tata, pʌchdëu juau ham dʌ̈i magju hatarr haawai hajim haajem mag jëeumamua. ");
INSERT INTO noaH_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mag hich Hayag hʌ̈u hajim hawia jũrr haig narr k'ʌʌnagta, ’Nem t'um mʌg t'ʌnʌmʌn mʌ Hayau mʌrʌgta deejimgui hajim hanʌm. Mamʌ hãbmuajã k'augba sim, k'ai hagá hi Hiewaa. Hãba hich mʌ Hayaupaita k'ap'ʌ sim, chadcha mʌ hi Chaairau. Mʌg nʌm haig hãbmuajã k'augba sim, k'ai hagá mʌ Haai. Hãba mʌch chi Chaairaupaita mʌch Haai k'ap'ʌ chitʌm. Bigaaum k'ʌʌnau k'ap'ʌ haju hawiajã, mʌchdëu hamag jaaubarm k'ʌʌnaupaita hĩchab k'ap'ʌ haju haai nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Magua, muan pãragan, chadcha mʌ Haai k'ap ham k'õsi nʌm k'ai, mʌ hiekta hʌ̈k'abat ha chirʌmgui hajim hanʌm. Pãach pekau pömag k'ap'ʌnaa hök'ĩirjugau gaai machaaga nʌm k'ʌʌn, mʌʌta pãrau pãach t'ãar hee haumʌn, muata pãar hök'ĩirjug meeupijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hidëu mʌrʌgta hʌdʌraa pãachig nem jaaupibat; muan hök'ar hit'ũuta jaaumaajem. Pãrau mua jaau chirʌm hipierraata hamʌn, hʌ̈u pãar k'ĩir meeu nʌisiju. ");
INSERT INTO noaH_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mua nem jaau chirʌm chan hatcha p'it'urg haawai pãrau pödbajöjöom k'abam. Muan nem t'um pãachdëu pödju hayaam nemta jaaujemgui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hich mag jaar biek hãb jua hʌ̃i nʌm hedcha maach hi dʌ̈i wënʌrraajerr k'ʌʌn t'um hi hiek jaaut'urwia deeu hi dʌ̈i narr haawai, hich Jesuu trigo p'ur wëjöm hee maar p'ë wai dichjim. Magbaawai maar hee hãaur k'ʌʌnau chi bich t'ʌrrëunaa, jua heepai sigt'ʌnaa k'ö wënʌrrajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maig hĩchab fariseonaanjã dʌ̈i narr haawai mag hoowi hich Jesuugta, —Pʌdë hoobá, jua hʌ̃i nʌm hed haawai bʌ̃ʌrjã p'idk'aju k'aba nʌmta, pʌ k'apeenau jãg trigo p'ierrnaa k'ö wënʌrrʌm. ¿Pua chan k'augba hab, jãgpai p'ierr nʌmjã nem pöm heeu nʌm dʌ̈i hãba sim? hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Magbaawaita jũrr Jesuu hamag, —Mamʌ ¿k'ani mʌ k'apeenau k'aigba habar? hajim. ¿Magan pãrau chan Hẽwandam hiek p'ã sim gaai t'ʌ̃ʌrwai hooba haajeeb, Daviiu hich dʌ̈i wënʌrrarr k'ʌʌn dʌ̈imua hamach jãsöo p'öbaadeewai Hẽwandam hat'eem pan k'ötarr? ");
INSERT INTO noaH_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mag pan parhoobam k'ʌʌnau k'öju k'aba, hãba p'adnaanaupaita k'öju haai naajim. Mamʌ pãrau k'ap'ʌ nʌm, jãga hirua Hẽwandamag jëeujem deg dubwi Hẽwandam hat'eem pan nasãd gaai p'ë sĩerr hauwi k'öjĩ. Mamʌ mag k'ötarr paarjã Hẽwandamau hi chig habajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Wa pãrau Moiseeu ley p'ã pʌatarr gaai t'ʌ̃ʌrwai hooba haajẽwa? Jua hʌ̃ʌijem hed hawiajã p'adnaan Haai hi jëeujem deg p'idk'aawai pekau k'abam ha sim. ");
INSERT INTO noaH_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mag Haai hi jëeujem deg p'idk'aju haai sim k'ai, ¿jãgwi mʌ mag Haai hi jëeujem di k'ãaijã hich Jöoiraucha pʌ̈itarrauta sabarhed hawi mʌch k'apeenag trigo p'ierr k'öpi jaauju k'aba chirʌ́? ");
INSERT INTO noaH_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wajapcharan jãg Hẽwandam hiek p'ã sim gaai jaau sim pãrau k'augbata naabahab, Hẽwandamau hich hiek gaai “Nemchaain t'õonaa mʌrʌg jëeuwai hʌ̈u sĩeb mamʌ, muan pãach k'apeenta hʌ̃rcha dau haug k'aug paraa hapim k'õsi chirʌm” ha sim. Pãrau hirua mag sim wajap'a k'ap'ʌ naak'iin, jãg hõor hiekk'õr chuk'um k'ʌʌndampa pãrau k'aigba nʌm ha jaaubajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maimua ham jʌ̃gdaar mag hiek'apʌ̈iwia deeu hichdëupai, ’Mʌʌn Hẽwandam Hiewaa Hemk'ooirau. Muata t'umaam k'ʌʌnag k'an nemta wauju haai nʌ wa wauju k'aba nʌ ha jaauju haai chirʌmgui hajim, jua hʌ̃ʌijem hed hawiajã. ");
INSERT INTO noaH_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mag trigodö hee fariseonaan dʌ̈i hijẽjẽb sĩewi petaau, haigmua dak'a maach meeun Hẽwandam hiek jaaujem di sĩerr hee dubimajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mag Haai hi jaaujem deg woun hãb jua jʌser k'itʌmjã sĩejim. Hamach chi fariseonaanau Jesús hipeerdʌwi nem hagcha k'aba jaaubarm gaaimua hi himeraa pʌr hauju hẽk'aajerr haawai, juau hogt'om hirig, —¿Jua hʌ̃ʌijem hed hawiajã, hõor mor masim k'ʌʌn monaauju haai sĩ? ha jëeujierram. ");
INSERT INTO noaH_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Magbaawai hichdëu hamag magjim: —Pãar mʌg nʌm haig pãar ovejadam dau hãb k'ãijã jẽbdeg buudimaawai, ¿k'aíuta jua hʌ̃ʌijem hed hawia jẽu hawaan maba haajẽ? Mag sim, ¿pãrau hoowai maach wounaanta nemchaain k'ãaijã hʌ̃rcha balee naabá? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mag sim haawai jua hʌ̃ʌijem hed hawiajã hichiita muan hõor dau haug k'augju haai nʌm ha chirʌm hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Magnaa hich Jesuupai chi woun mag jua jʌser k'itarragta, —Dayag jua hʌabá hajim. Magbaa chadcha jua hʌabaa jua monakk'a warm chi wajap'a sĩerr dʌ̈i hãba sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mamʌ jua hʌ̃ʌijem hedta magbarm hoobaawai, haigmua höbëraau, chi fariseonaanau Jesús t'õopʌ̈yaag jãga hak'iina ha k'ĩirju nʌisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mag hich t'õopʌ̈iju k'ĩirju p'öbaadëm hich Jesuu k'aug hat'aawai hichta warag haigmua petajim. Mag hi petaawai hõor pöm dʌ̈i hi hẽudee wëtjim. Jesuu mor masim k'ʌʌn t'um hich haig waibëe nʌm monaaupʌ̈i maajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mamʌ hichdëu mag hõor monaau simjã sĩi k'apanag hee parhooba hich jaaupiba haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pari magtarran, Hẽwandam hi jaaumie jöoi Isaías k'ararrau hich Jesús higwia jaautarrjö hamk'ĩir hajim. Chi Hẽwandam hiek gaai hi higwia mag sim: ");
INSERT INTO noaH_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hachá sim mʌ chog” ha sim Hẽwandamau, “mʌchdëu jʌr hautarr mʌchdëu k'õsim. Hi gaaimuata mʌ honee chirʌm. Hi gaai, mua mʌch Hak'aarta p'ẽs deeju. Magbaawai hirua jaauju, jãga hõor mʌ dʌ̈i wënʌrraju haai nʌ. ");
INSERT INTO noaH_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hí chan hõor dʌ̈ijã meeurraunaa k'ĩesir hijẽjẽbjã haba, ni kaaijã hee hõor dʌ̈i meeuk'arrjã chuk'u haju. ");
INSERT INTO noaH_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mag hi pʌ̈ibarm chan hõor dau hap'ʌʌ k'it'ëem k'ʌʌn warag dau haug waupiegjã k'aba, ni hich hiek gaai hubʌ k'aba k'it'ëem k'ʌʌn hok'oopiegjã k'aba, warag hich meebarm gaaimua hõor hʌ̈u peerdʌju hayaa hapiegta pʌ̈iju. ");
INSERT INTO noaH_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Magbaawai durrpierram k'ʌʌnau hi higwia, ‘Jãguata chadcha hʌ̈u maach peerdʌ hauju k'abahab’ hajurau” ha sim Hẽwandamau hich hiek gaai. ");
INSERT INTO noaH_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Biek hãb woun hãb dösãt bënëu sim Jesús haig haibëejierram. Mag woun hich hag bënëu meu meraanaa daujã k'ĩsu k'itajim. Mag hich haig haipierrwai Jesuu hi dau monaaupʌ̈iwia mag meu meraa sĩerrjã wajap'a hiek'apijim. ");
INSERT INTO noaH_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mag hoowi hõor dauderraa nʌm hiek'au hamach wir haigpai, “¿Keena, mʌg woun jöoi David k'ararr chaain hewagam k'ʌʌn heem maach peerdʌ haumk'ĩir pʌ̈iju haajerr k'abam k'ai?” haajeejim, Jesús higwia. ");
INSERT INTO noaH_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pari hõordamau sĩi mag nʌm hũrbaawai fariseonaanau jũrr ham hichaaur, —Dösãtnaan pör Beelzebú dʌ̈i bën dötarr haawaita hag juapaauta jãg hõor mor heem mepeenjã dau daau jʌrk'ʌʌi nʌrrʌm haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pari hamau hamach heepai mag nʌmjã Jesuu k'ap'ʌ sĩerr haawai jũrr hich garmua hamag magjim: —Pãrau hoowai, gobiernoou hich higar nʌm k'ʌʌn jãrrcha t'öonaa hamach wir haigpai wërbʌpik'iin, ¿mag gobierno warre k'ʌt mabaju k'ai? Wa hãbmua k'ãijã hich chaain dʌ̈ipai meeuk'awi hamach wir haigpai wërbʌk'iin, ¿warag haaidʌbaju k'ai? ");
INSERT INTO noaH_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pãar hiek mag mʌjã dösãt dʌ̈ita chirʌm hanaawai, dösãtauta wir haig dösãtpai jʌr wërpk'iin, pöd hich mag jua t'eeg sĩerrabajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Chadcha mag dösãtnaan pör Beelzebuuta mʌrʌg hich jua t'eeg dee sim k'ai, magan har pãach higar t'ʌnʌm k'ʌʌnaujã hagjö hi juapaauta mepeen jʌr wërp nʌm. Mag nʌmta ¿jãgwi pãrau mak'ʌʌnag chan bʌ̃ʌrjã magʌm haba nʌ? ¿Chadcha hich Hẽwandamauta hamag magamk'ĩir hich juapá dee sim pãachdëu k'ap'ʌ naawai k'abá? Pãar hiek mag chi dösãtaupaita wir haig hich k'aibag waaujem hanʌpí, magan jãg chi mʌ dënjö dau daau mepeen jʌr wërp nʌm k'ʌʌnagchata jëeu hoobat, daau hamau chadcha dösãt juapaauta jãg jʌr wërp nʌm habarju. Pãach chi mʌrʌg mag hiek'a nʌm k'ʌʌnta hag heyaajã k'aba hiek'a naabahab. ");
INSERT INTO noaH_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Muan chadcha Hẽwandam jua t'eegauta mepeenjã jãg jʌr wërp chitʌmgui hajim. Mag mepeen mua jʌr wërp chirʌm gaaimua pãrau k'ap'ʌ haju haai nʌm, ya hich Hẽwandam chi jua t'ierrta mʌig pãar hee sĩeichëm. Mamʌ magʌmjã pãrau k'augba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Pãadë k'ĩirjubat. Ni hãbmuajã mʌg nʌm haig sĩi hãb jierrnem wajap'am dʌ̈i hich di t'ʌa sim haig dubwi hi nem jĩgk'abaju. Sĩi k'apanaam k'ʌʌnau wa hi k'ãai hʌ̃rʌʌcharamua hi hibʌʌr hauwi k'abam chan, pöd hi nem jĩgk'abamgui hajim. Hich hagjöta simgui hajim mepeerjã. Mʌ hi k'ãai jua t'eeg hʌ̃r k'aba chirak'iin, muajã pöd hõor mor heem mepeen jãg dau daau jʌr wërpbaju. Mamʌ mua chadcha Hẽwandam juapaauta mʌg nem wau chitaawai meperaujã mʌ jua jʌmba haajem. ");
INSERT INTO noaH_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Magua, mua mag chirʌm: Har chi mʌ higar k'aba sim wounan hichta dösãt higar sim; maimua Hẽwandam hiek hʌ̈k'api hawaag mʌ hipierr hõor hãbamʌg jʌr p'ëba simuan waragta jʌr wërp simjö simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Magua, mua mag chirabma hajim hich Jesuupai: Hẽwandamaun chadcha hõor k'aibag t'umaa chugpaaju, ham parhoob hiek'amatarrpa t'um. Mamʌ pekau hãb sim, maan mua Hẽwandam Hak'aar jua t'eegau nem wau chitʌm hoo nʌmta warag mepeer gaai t'ʌ nʌmʌu. Mag pekau chan Hẽwandamau bʌ̃ʌrjã k'ĩir hok'oobamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mʌch chi Hemk'ooi Hiewaa higwiata k'aigba k'ãijã hiek'a nʌm pekaun hʌ̈u chugpaaju; mamʌ chaig pãrau mua mag Hẽwandam Hak'aar juapaau k'aba Beelzebú jua t'eegauta mepeenjã jʌr wërp chitʌm hanarr chan mʌig heegarjã chugpaaba, ni mʌg hatag Hẽwandamau deeu jẽb hiiur hompaabarm gaaijã chugpaaba hich mag sĩsijugui hajim, Hẽwandam Hak'aar higwiata mag hiek'a naawai. ");
INSERT INTO noaH_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Mag hiek'ak'agmamua hĩchab hamag magjim Jesuu: ’Pãadë mʌ sëu hawia nemjĩir jĩirwaijã wajap jarba sĩi hich jãg bãaupibat. Mag nemjĩir wajap chëbajugui hajim. Mamʌ wajap'ata p'ãichichagau bʌ̈ k'uanaa jar bãaumʌn, mag nemjõ wajap'a chëju. Wajapcharan hich chë sim gaaimuata k'ap'ʌ haajemgui hajim, jãga sĩ mag nemjõ. Hich jãgta naabahab hajim pãarjã hagjö. Pãach nem wau nʌm gaaimuata pãachdëupai pãach jaau naabahab, hõor wäjäauná wa hõor k'aigbam k'ʌʌná. ");
INSERT INTO noaH_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","K'ĩirjug chuknaan, jãg pãar hö k'aibag sĩsidʌm k'ʌʌnau, ¿jãga pãrau nem wajap'am hig hiyʌ̈ʌ habarju? Nem dich k'ĩirjug hee k'ĩirju hahauk'amta dich hiiu jaauba haajeeb. ");
INSERT INTO noaH_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hõor k'ĩirjug wajap'am k'ʌʌnau nem wajap'am nemta hiek'a nʌm, hamau nem wajap'amta wauju k'ĩirju naawai. Mamʌ hö k'aigbam k'ʌʌnaun, hiek'aawaijã k'aigbata hiek'a nʌm, ham hödi sĩi nem k'aigbamta wauju k'ĩirju sĩsid haawai. ");
INSERT INTO noaH_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pari mʌ cha hiek'a chirʌm hiek'au, Hẽwandamau hõor hi hagk'am hedan, mʌig heegar haawai pãach hiek k'aigbam hiek'aajerr t'umaa pãach hidamaucha hirig jaaujugui hajim, k'an jãgwia mag hiek'aajeejĩ. ");
INSERT INTO noaH_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wajapcharan mʌig heegar haawai pãach hiek'amaajerr hiek'aupaita wir haig pãach hiekk'õr chuk'u nʌm ha jaaupiju, wa warag pãach k'aibag k'ãijã waupi jaaujugui ha jaaumajim chi fariseonaanag. ");
INSERT INTO noaH_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Biek hãb fariseonaan heem k'ʌʌnau maestronaan heem k'ʌʌn dʌ̈imua Jesuug, —Maestro, maraun maach dak'ĩirta pʌrʌg hag na bʌ̃ʌrjã maadëu hooba haajem nemta waupim k'õsi nʌmgui hajierram. ");
INSERT INTO noaH_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Magbaawai hich Jesuu hamag magjim: —Pãran pãachdëu Hẽwandam hiseg nʌm gaaimua warag chi hajaugjã chuk'u t'ʌnaawaita warag pãachdëu nem hooba haajem nempata pãach dak'ĩir waupi nʌm. Mamʌ mua waubamgui hajim. Mag k'ãai warrgar jöoi Jonás haajerr nemmeeurrk'an buch hee k'ãai t'ãrjup sĩerr gaaimua Nínivepienau Hẽwandamau hi pʌ̈itarr k'aug hautarrjöta, hĩchab mʌchjã Hẽwandamau pʌ̈itarr pãrag k'ap hapijugui hajim, mʌch hiiu p'iidʌbarm gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Hich jãg Jonás nemmeeurrk'an bi hee hãsdawam k'ãai t'ãrjupnaa hedaramjã k'ãai t'ãrjup sĩerrjö, hich hagjö mʌch chi Hemk'ooi Hiewaajã hĩchab hãsdawam k'ãai t'ãrjupnaa hedaramjã k'ãai t'ãrjup chirajugui hajim, jẽb hee. Mamʌ mag hoobarmjã pãrau hʌ̈k'abajugui hajim hamachigcha. ");
INSERT INTO noaH_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Magua, Hẽwandamau hõor hich haar p'ë hauju wa p'ë hauba k'ãijã haju jaau nʌm hed, Nínivepien p'iidʌtk'awi hamach hipaarmua pãar k'aibagta warag Hẽwandamag hĩgk'a t'ʌnʌʌuju, warag pãar k'aibag waumk'ĩir. ¿K'an jãgwi? Jonaau Hẽwandam hiek hamach haar jaaubaimaawai hamau magʌmjã haba hʌ̈k'atarr haawaima. Mamʌ hĩs mʌ Jonás k'ãaijã hʌ̃rʌʌcha chirʌmuata Hẽwandam hiek jaau chitʌmjã pãrau bʌ̃ʌrjã hʌ̈k'amap'a nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mag Hẽwandamau ham p'iriutk'a hauwia chachbarm jaar hĩchab Sabá durrmua rey Salomón hoon bëetarr hʌʌiraujã hich hipaarmua hĩchab pãar k'aibagta Hẽwandamag hĩgk'a t'ʌnʌʌujugui hajim, hí pãar k'ãaijã warpmuata Hẽwandamau Salomonag k'ĩirjug deetarr hiek'a sim hũraan bëetarr haawai. Mag k'ãai mʌ Salomón k'ãai hʌ̃rpai chirʌmuata mʌig pãach nʌm haig Hẽwandam hiek jaau chirʌmjã pãrau hũrmap'a nʌmgui hajim, mag hamachdëu nem hooba haajemta hamach dak'ĩir waupi narr k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mag hiek'ak'agmamua, ’Hĩs mʌg mʌ hiek hũrbarmjã hʌ̈k'aba habarm gaaimua warram k'ãaijã warag Hẽwandam dʌ̈i hiekk'õr pöm nʌisim k'ap hamk'ĩir, pãrag mʌg ejemplo jaauk'imgui hajim. Magnaa hichdëupai, Bën k'aigbam hõor mor heemua jʌrpäaiwain warp hõor chukag hee p'ʌrëu nʌrraajem. Mamʌ pöd hich sĩeimaju baauba habaawai k'ĩirju sĩi hawia, ");
INSERT INTO noaH_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Deeu mʌch chiraajerr deg chiraimaag majugui” hawia, deeu hich hag woun jʌrmaajemgui hajim. Mag mawia hooimaawai, chadcha di chaarta wajap t'ũapwi hãbamʌg nem jök'anaa hau sĩsidʌmjö dijã parii hooimaajem. ");
INSERT INTO noaH_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mag hoobaimaawai, deeu mawia, hich daumaai hich k'apeen hich k'ãaijã k'aigbacharam k'ʌʌn siete jʌr p'ë hauwia, deeu mag woun mor hee naaicheejemgui hajim. Magbarm haigmua chi wounjã warr hich sĩerr k'ãai warag hat'uuchata k'aibag sĩsiejem. Hĩsim k'ʌʌn jãg k'aibag sĩsidʌm k'ʌʌnjã hich magta hajugui hajim meperau ham dʌ̈i, Hẽwandam hiek hũrtarrta hʌ̈k'aba harr gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Hagt'a Jesuu hõrag hiek'a sim hee, hi hãd hi heeugpeen dʌ̈i bardʌtk'achëwia hi dʌ̈i hiek'am hig naajim. Mamʌ hi sim haar dubba daaugajãrpai naaichëtarr haawai ");
INSERT INTO noaH_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","hãbmua chi Jesuug, —Pʌ hãd pʌ heeugpeen dʌ̈i daaugajãr nʌmwai; ham hiek pʌ dʌ̈i hiek'am k'õsi nʌm haajem ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Magbaa jũrr hichdëu, —¿Chijã hagá mag mʌ hãd, maimua chijã k'ʌʌn hagá mag mʌ heeugpeen? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Magnaa maach hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnagta jua hʌanaa, —Chamʌ k'ʌʌnta mʌ hãd hanaa mʌ heeugpeenauwai hajim. ");
INSERT INTO noaH_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mʌrʌgan mʌ Haai hʌ̃gt'ar chiraajemua k'õsimjö nem wau nʌm k'ʌʌnta mʌ hãd hanaa mʌ hʌ̃p'ʌʌinau, maimua hĩchab mak'ʌʌnta mʌ k'odnaanaugui hajim, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","K'ãai hãb Jesús hich jẽer sĩerr degmua mawia t'ʌrrdö higaau hoo sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Maigmua hich bigaau hõor pöm p'ʌʌrbaadeewai hichta warag bote hee waaidʌwi döjãrraa barjöisijim. Maagwai chi hõran durr mos gaaipaita pos t'ʌnaajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mag mam barjopnaata ejemplodam jaaumamua nem k'ĩir pogk'e jaaumajim. Mag jajawagmamua magjim: —Woun hãb nemjĩir dau p'oon majim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mag sĩi p'ömam hatarr haawai hãaurag chi nemjĩir daudam bʌ̈ diichjem hee burrjim haajem. Magbaa nemchaain bëewia sĩi k'ök'ʌʌipʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Maimua hãaur k'ʌʌn sĩi mok pör jojoodög heeta burrjim haajem, wajappai jẽb chuk'u sĩerr hee. Mak'ʌʌnan chi t'arrp'ëen hʌ̈u jöpcha t'arrp'ë höbërjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pari hedau pechag wʌʌbaadeeu sĩi hënanauk haadëmua p'uabaadëjim hanaabá, mokdau k'urau pöd hierr k'aar jẽrk'aba hʌ̃rʌʌta k'aark'a k'it'ëe harr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Maimua hĩchab tagam p'ötarr miudö harr hee burrwia, chi miuta nemjĩir k'ãaijã bãau k'ap'í bãauwia, sĩi chi nemjĩirdam hichdëuta pör pʌrëu haujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mamʌ tagam hʌ̈u jẽb wajaug hee burrtarran, wajap'a höbërwia hʌ̈u nem wajaug p'ur jopjim hanaabá, nem bich dapag maimuajã bich t'ʌʌ, maimua pogk'a bich daii; mamʌ mag sĩsidʌm chan bʌ̃ʌrjã chi vano chuk'u. ");
INSERT INTO noaH_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mag nem hĩgk'aadam jaau höpʌ̈iwi haig narr k'ʌʌnag, ’Keena, jʌ̃g hʌ̃rʌʌnaa chamʌg nem hĩgk'aadam mua jaau chirʌm wajap'a hũrbatgui hajim hich Jesuupai. ");
INSERT INTO noaH_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mag hi nem hĩgk'a höpinaa maach chi k'apeenauta hirig, —¿Jãgwiata pua jãg ejemplodam jaaumamuata hõrag nem jaaujẽ? ha jëeu naajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Magbaawai hichdëu marag magjim: —Pãrau k'augam k'õsi hũr naawai warre mʌchdëuta pãrag k'ap'ʌ hapi chirʌmgui hajim, jãgata Hẽwandam hõor t'ãar hee sĩeicheejẽ. Pari warm k'ʌʌnag mag k'augpibamgui hajim, hamau k'augam k'õsi hũrba naawai. ");
INSERT INTO noaH_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mag k'ãai har chi t'ãar honee hũrm k'õsi hũr nʌm k'ʌʌnagta Hẽwandamau warag k'ĩirjug deeju, hich hiek k'apcha hamk'ĩir. Mamʌ har mag nem waumap'a nʌm k'ʌʌnag chan deeba, warag ham jua heem k'echeu haumaju hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Maguata mua sĩi ejemplo jaaumamuata hamag nem jaauba haajeeb, mua nem wau chitʌm hamau hoo nʌmta hoobamjönaa mua nem jaau chitʌmjã hũr nʌmta hũrbamjö naawai. ");
INSERT INTO noaH_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hamach jãg nʌm gaaimua ham gaaita pa sĩebahab Hẽwandamau hich hiek gaai jöoi Isaías k'ararrag p'ãpitarr. Hirua p'ãtarr mag sim: “Par hamau hũrwiajã hũrbamjö k'augbajurau. Par wajap hoo nʌʌ hawiajã hoobamjö hajurau. ");
INSERT INTO noaH_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mʌk'ʌʌn wounaan k'ĩirjugan sĩita hãr sim; kachjã k'ĩnaa daupata k'ĩ sĩsidʌm. Mag naawai pöd hũrjã hũrba ni hoojã hooba, ni mʌrʌgjã hamach pekau chugpaapi jëeuba nʌm, hamach peerdʌ haumk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mag hiek'apʌ̈inaa deeu maragta, ’Pari pãar honee habat hajim; pãrau pãach daúacha mua nem wau chitʌm hoonaa pãach jʌ̃gʌucha mʌ hiekjã hũurjeewai mak'ʌʌn jöoi Isaiaau jaautarrjö k'aba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Magnaa, Chadcha mʌch himeerba pãrag mag chirʌmgui hajim: Warrgar k'apan Hẽwandam hi jaaujerr k'ʌʌnau cha mua nem wau chitʌm pãar dënjö hamach daúacha hoom k'õsi hatarrjã pöd hoobajierram. Cha pãrau hũr nʌmjã hamach jʌ̃gʌucha hũrm k'õsi hatarrjã pöd hũrba durrajimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Maimuan chadau hich Jesuu, ’Hũrbat, mua pãrag jaauk'imgui hajim, k'ani jaau sĩ chaig mʌchdëu nemjĩir dau jaau chirarr hag ejemploou. ");
INSERT INTO noaH_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Har mʌg Hẽwandam hiek jaau nʌm hũr nʌmjã pöd k'augbam k'ʌʌnan, chi nemjĩir daudam k'ʌdjã hee burrwia nemchaainau k'öpʌ̈itarrjöta nʌmgui hajim: Meperau bëewia, sĩi k'ũgurbaicheewai, Hẽwandam hiek hʌ̈k'atarrdam deeu hũrba harrjö hapäaijem. ");
INSERT INTO noaH_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Maimua har Hẽwandam hiek jaau nʌm hũrbaawai hʌ̈k'am k'õsi hʌ̈k'atarr k'ʌʌn, jũrr nemjĩir daudam mok pör jojoodög hee burrtarrjöta nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mamʌ jẽb chukag gaaimua chi nemjĩirdam wajap k'aark'aba harrjö, hĩchab mag hũrm k'õsi hũrnaa hʌ̈k'atarrjã wajappai hubʌ k'aba nʌm. Mag k'uk'urpai naawai, mag hiek wajap'am gaaimua chik'amnau k'aigbanaa p'it'urg haawaijã, deeu Hẽwandam hiekta hisegwi, warr hamach naajerrjöta wënʌrram k'õsi nʌm. ");
INSERT INTO noaH_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Maagwai maach k'apeen hihãsisisdöm k'ʌʌn, jũrr mag nemjĩir dau miu hee burrwia chi miúa pör pʌrëu hautarrjöta nʌmgui hajim. Hamau Hẽwandam hiek hũrm k'õsi hũurjem, mamʌ deeu hamach k'ĩirjug heepai, “Jãgʌm gaaimua pöd mʌ p'atk'on hauba k'ãijã chitaju,” wa magbam k'ai, “Mua chadcha hʌ̈k'ak'iinjã, pöd parhooba mʌchdëu hampierr habaju” ha k'ĩirjuajem. Mag gaaimua mag nemjĩirdam hap'ʌʌ bãauwia pöd chëba harrjö, Hẽwandam hat'ee nem wajap'a wawaagjã pödba, sĩi serbiibata nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Magarrau har Hẽwandam hiek hũrwia t'ãraucha hʌ̈k'aajem k'ʌʌnan chad, jũrr mag nemjĩir jẽb wajaug hee burrtarrjöta nʌmgui hajim. Magʌm k'ʌʌn Hẽwandam hat'ee nem waum k'õsi wau naawai, hamachdëu nem wauju hayagpierr waaujemgui hajim: hãaur k'ʌʌnau nemjĩir chi chëmiejö dʌ̈rrcha, hãaur k'ʌʌnau hagpierrpai maimua hãaur k'ʌʌnau bʌchk'unpai. Mamʌ t'umaam k'ʌʌnau hichiita hichdëu k'õsimjö haajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mag jaauwia, deeu hichdëupai mʌg ejemplodam jaaumamua magjim: ’Hĩs mua pãrag jaauk'imgui hajim, Hẽwandamau hichdëu hõor hi hagk'am hed jãga k'aigbam k'ʌʌn chi wäjäaun heemua hisegju. Maan mʌgaugui hajim: Woun hãbmua trigo jĩirjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mamʌ mag trigo hap'a sĩerrta, hõor t'um k'ãip'öbaadëmich, mag chi nemjĩir pap k'a huk'urm bëewia jũrr hi nemjĩir hee p'ũak dau k'aigbam hagjö trigojöo simta p'öt'urjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Maimua chi trigo bich baupa haadeewai chi p'ũakjã hagjöo dʌ̈i bich baupa jöisijim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Magbaadëm chi chognaanau hoo hat'aawai hamach patrón haar wëtwi hirig, “Patrón, pua jĩirwai trigo happai jĩirtarrta, ¿jãga hĩs jãg p'ũak k'aigbampata hag hee bich baupa wëjö?” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Magbaawai chi papk'ʌʌu, “Jã, maach dʌ̈i hiekk'õr paraam k'ʌʌnau k'ãijã hag hee p'ũak dau p'öwia k'abahab” hajim hanʌm. Magbaa chi chognaanau deeu pʌaba hirig, “¿Pua hoowai marau hag happai chi k'aarpa jẽu wërp'oon maju haai nʌ?” hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mamʌ magbaa chi nemjĩir k'ʌ jöoirau, “Hoob jẽwaan wëtmiet” hajim hanʌm, “magba hak'iin heeu pãrau chi trigo k'aardampa k'ãijã t'ʌrrëuduk'am. ");
INSERT INTO noaH_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Magju k'ãai hidëu warag hãba bãaupibat” hajim hanaabá. “Maimua ya p'ierr nʌm jaar paawaita mua hag hat'ee hõor pʌ̈ijugui hajim hanʌm, nacha hag happai t'ʌrrp'ënaa, k'õorjʌ̃naa hörpʌ̈imk'ĩir. Maimuan chadau hagjö chi trigo happai p'ierrwia chi hausĩiujem hee hausĩujugui” hajim hanaabá. Magtarr haawai hichdëu jaautarrjö hidëu bãaupiwia, p'ierr jaar paawaita hich mag chi p'ũak t'ʌrrp'ënaa, hag happai k'ĩet hörpʌ̈ijim hanaabá. Maagwai hõor hi hagk'am hedjã hich magta haju Hẽwandamaujã hich hiek hʌ̈k'abam k'ʌʌn dʌ̈i. Mamʌ hich hiek hʌ̈k'a nʌm k'ʌʌnan, mag trigo wajap hãk'a sĩutarrjö hich haarchata p'ë hauwi hich dʌ̈i hich mag wai sĩsiju ha jaaumajim, hich Jesuucha. ");
INSERT INTO noaH_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mag nem k'ĩir pogk'e jaaumamua hich Jesuupai hĩchab mʌg nem hĩgk'aadamjã jaaujim, mostaza daudam bʌ̃rʌʌ k'itʌm higwi: ’Pãrau k'ap'ʌ nʌ, jãga sim habarí Hẽwandam hiek mua jaau chitʌm, maimua k'anjöta sim ha mua pãrag jaaubark'iin hajim. Mʌg Hẽwandam hiek mua jaau chitʌmʌn, mostaza daudam jẽb hee jĩir sĩubarmjöta simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hiin chadcha tagam nemjĩir dau k'ãaijã hichta bʌ̃rʌʌcha k'itʌm. Mamʌ mag k'itʌmʌn nem bãau k'ap'í bãauwia, nem bʌ̈ pöm hãdëe haadeewai, sĩi nemchaaindam bëewi hag gaai di hëucheejemgui hajim. Hich hagjöta sĩebahab hajim hĩchab mʌg Hẽwandam hiek mua pãrag jaau chitʌmjã: Mʌʌgwaiwe chan k'apan k'abata hʌ̈k'a durrum; pari mag durrumuata warag nem pöm haaidʌbapäaiwai hõor k'apank'am k'ʌʌnau hʌ̈k'ajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mag jaaumamua hich Jesuupai, ’Hẽwandamau hich hiiu haawai mag hich hiek haaidʌpi nʌmʌn, hʌʌi hãbmua harin dʌ̈rrcha sim hee levadura pʌ̈itarrjöta simgui hajim. Pãrau k'ap'ʌ nʌmgui hajim, levadura bʌ̃rʌʌ pʌ̈itarrjã haaidʌmam hooba simta, harin t'um hʌrpi haaujem. Hich hagjöta sĩebahab hajim hĩchab Hẽwandam hiek mʌg mua jaau chitʌmjã. Mʌʌgwaiwe chan hõor pöm mʌg wëjöm hee hagt'a pömcha haaidʌba sim. Mamʌ mʌg hatag paawaita durr warp'am magwe haaidʌbaadee t'umaam k'ʌʌnau hũrab k'aba hũrjugui ha jaaumajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Magta Jesuu nem k'ĩir pogk'e jaaumajim, ejemplodam deemamua. Ejemplo chuk chan hõrag nem jaauba haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mamʌ mag ejemplooupai nem jaaujerran, warrgar Hẽwandam hi jaaujerrau Jesús higwia jaautarrjö, ejemplo deemamuata hõrag nem jaauju harr haawai hajim. Mag hirua ejemploou nem jaaumaju hatarran, warrgarwe Hẽwandamau hõrag k'augpiba hich t'ãar heepai wai sĩsierrta jũrr hewag pawi hõrag k'ap hamk'ĩir jaaumaju hajim. Magtarr haawaita mag ejemplo jaaumam haigjã chadcha hag heyaa höbëbërgmajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mag hõrag ejemploou nem jaau höbaadeewai hõrag wëtpi jaaujim. Maimua t'um hërëubaadee hich jẽer sĩerr di haar majim. Maig maach happai hap'öbaadee, marau hirig maachig jaaupijim, mag p'ũak dau k'aigbam trigo heeu jĩir wëjöm hee p'ötarr. ");
INSERT INTO noaH_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Magbaa hichdëu jaaubaadëwi magjim: —Har mag chi nemjĩir dau wajap'am p'öjim ha chirarr, jã mʌchpaíugui hajim, mʌch chi Hemk'ooi Hiewaa. ");
INSERT INTO noaH_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Maagwai hirua p'ötarr jẽb, jã mʌg hõor pöm wëjömta jaau sim. Chi nemjĩir dau wajap'am, hõor Hẽwandamagta hʌdʌraa hamach Pörk'api nʌm k'ʌʌnaugui hajim. Maagwai chi p'ũak k'aigbam, har sĩi Hẽwandam higar k'aba mepeer higar nʌm k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Maagwai chi patrón k'a huk'ur hi nemjĩir hee mag p'ũak dau p'öt'urtarr, jã chi meperaugui hajim. Maimua chi trigo p'ur jöisiewai t'ʌʌju ha jaautarr, Hẽwandamau mʌg durr hi hagk'ajuuta jaau sim. Chi trigo t'ʌʌ nʌmjö hõor dajẽk haju k'ʌʌn, hich Hẽwandam chognaanaugui hajim, angelnaan. ");
INSERT INTO noaH_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pãrau k'ap'ʌ naabá, p'ũak p'ʌnaa, jʌʌupinaa hörpäaijem. Hich jãgta haju hĩchab Hẽwandamaujã hõor dʌ̈i hichdëu mʌg durr hi hagk'abarm hed. ");
INSERT INTO noaH_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mag hed mʌch chi Hemk'ooi Hiewaau mua mʌch chognaan pʌ̈ijugui hajim, sĩi bigaaum k'ʌʌnagjã pekau waupinaa hamachdëupa nem k'aigbam wau sĩerrjëem k'ʌʌn t'um hãbamʌg jʌr p'ëmk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mag hãbamʌg jʌr p'ënaa horno paa dʌnʌmjö sim heeta bark'ʌʌiju. Magbaawai mag heeta hicharaucha bĩenaa gaai machgau ham k'ierr hujãkk'ʌr habarjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mamʌ warm k'ʌʌn mamagk'am hee, jũrr Hẽwandamagta hʌdʌraa hamach wajaug paapi nʌmua hi dënk'a narr k'ʌʌnan maach Haai t'umaam k'ʌʌn Pörk'a sim dʌ̈ita nʌisijugui hajim. Magnaa hichdëupai, Keena, jʌ̃g hʌ̃rʌʌnaa cha mua nem jaau chirʌm wajap'a hũrbat hajim, mag hiek'amamua. ");
INSERT INTO noaH_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mag jajawagmamua hĩchab mʌg nem hĩgk'aadamjã jaaujim, hich Jesuu: ’Woun hãb chik'am jẽb gaai p'idk'a sĩejim haajem. Mag p'idk'a simuata jẽb heem nem wajap'am hoobaadëjim hanaabá. Magbaawai pöd hichdëu harrju k'aba haawai, sĩi hoo pʌawia, hich nemta warag hisegamjö t'umaa përk'ʌʌipʌ̈iwia, hag p'atk'onauta mag hichdëu nem hoo pʌatarr chi jẽbpa për haujim haajem. Maimua hich Jesuupai mag hich nem hĩgk'a sim hũr narr k'ʌʌnag magjim: ’Chi mʌ dënk'aju k'ʌʌnaun mag wounau mag p'ĩr haum k'õchgau hich nem t'um përk'ʌʌitarrjö hamach nem wai nʌmjã t'umta hiseg nʌmjö haju haai nʌmgui hajim, mʌʌta jũrr mag nem hajap'am hamachdëu hig nʌmjö paarpaag. ");
INSERT INTO noaH_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Mag mʌʌta nem wajap'am hamachdëu hig nʌmjö paarpaagan, chihöo chi hʌ̃rʌʌcha balee simta për hawaag jʌr wënʌrrʌmjö haju haai nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mag jʌr nʌmua chi baau hat'am k'ʌʌu hich nem wai sim t'umaa përk'ʌʌiwi jũrr mag chihöo mag hich nem përk'ʌʌitarr k'ãaijã hʌ̃rcha balee simta për hat'amjöta haju, chadcha mʌ dënk'am k'õsi mʌ jʌrwia baau hat'aawai. ");
INSERT INTO noaH_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mag jajawagmamua, ’Hẽwandamau hõor hi hagk'am hedan, hãwarr pʌraag reeu döjãrr dö hʌrëu nʌmjöta hajugui hajim, hich Jesuupai. ");
INSERT INTO noaH_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","¿Pãrau hoowai mag hʌrëu wai jörröo hawia jiir haunaa, chi hãk'ãar t'eernaa barpʌ̈iwia, chi wajap'am happaita hauba haajẽ? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hich jãgta hajugui hajim hĩchab Hẽwandamau pãar dʌ̈ijã, mʌg durr hichdëu hi hagk'abarm hed. Hẽwandamau hich chognaanag hõor k'aigbam k'ʌʌn chi wäjäaun heemua k'ĩet t'eerpi jaauju; ");
INSERT INTO noaH_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","magnaa mag chi hãk'ãraam k'ʌʌn mag horno paa simjö sim hee bark'ʌʌipʌ̈iju. Mag bark'ʌʌibapäaiwai mamta hicharaucha bĩenaa gaai machgau ham k'ierr hujãkk'ʌr hajugui hajim, hamach k'aigba wënʌrrarr jũrr. ");
INSERT INTO noaH_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mag jaau dichwia hich Jesuupai maach hich dʌ̈i wënʌrrarr k'ʌʌnagta, —¿Pãrau cha mua jaau chirʌm wajap'a k'ap'ʌ nʌ? ha jëeujim. Magbaawai marau, —Hëera, maraun k'ap'ʌ nʌmgui hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Magbaa hichdëu marag magjim: —Mʌg hiek hiiur mua jaau chirʌmjã pãrau chadcha k'ap'ʌ naawai deeum k'ʌʌnag jawaagjã ya chi machnaank'a nʌmgui hajim. Jãg nʌm haig hõor Hẽwandam higwia hi jʌr nʌm k'ʌʌnag pãrau jaauju haai nʌmgui hajim, chadcha pãachdëuta nawe Hẽwandamau hich hi jaaumienag p'ãpitarrjã k'ap'ʌnaa mʌg hiek hiiur mua jaau chitʌmjã k'ap'ʌ naawai. ");
INSERT INTO noaH_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mag ejemplodamau nem jaau sĩewi jaau haaipabaadeewai haigmua mawia ");
INSERT INTO noaH_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","jũrr Nazaret p'öbörög petajim, hich bãautarr haar. Mam pabaimaa, Hẽwandam hiek jaau nʌm hũraag maach meeun biirdʌajem deg dubwi, hõrag Hẽwandam hiek jaaubaadëjim. Mag hirua jajawagmam hũrwia jʌ̃gderraa nʌm hiek'au warag hamach heepaita, —¿Magʌm hichdëu jamta k'augjimta mag jaaumáma? ¿Jãga hichdëu jãg hõor monaau nʌrrʌ́ma? hanaa hĩchab, ");
INSERT INTO noaH_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Keena, ¿pãrau hoowai jãg woun José pa waumie hag hiewaa k'abá, María dʌ̈ím? ¿Jã Santiago dʌ̈i k'od k'abá, José dʌ̈i, Simón dʌ̈i maimua Judas dʌ̈ijã hagjö? ");
INSERT INTO noaH_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hi hʌ̃p'ʌʌin t'um mʌig maach dʌ̈i hich mʌg p'öbör hee naajem; maagwai hichjã maadëu k'ap'ʌ nʌmgui hajierram, hich mʌiguim haawai. Mag simta, ¿jam k'augt'urwiata jãg nem jaau k'aauga hichdëu jaaumaajẽma? haajeejim jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hamachdëu mag nʌm gaaimua hirua nem jaau simjã hasekasba, warag hi dʌ̈i k'ĩir k'ʌʌuk'a p'öbaadëjim. Pari magbaa hich Jesuu hamag, —Chadcha deeum durram k'ʌʌnaun mʌg Hẽwandam hiek jaau wënʌrrʌm k'ʌʌnag heenaa ham dʌ̈i hajap'a haba haajeeb hajim. Mamʌ mag sim, jũrr dich di haig wa dich bãautarr durrpai chan magjã magba warag ham k'a hisëe haajerramgui hajim, jũrr hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mag, warag maig chan Jesuu hõor mor masim k'ʌʌn pöm monaaubajim, hamachdëu hi hiek hʌ̈k'amap'a narr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mag Jesús nem k'ĩir pogk'e hõor dak'ĩir wau nʌrrʌm jaar hĩchab Herodeta Galilea durr reik'a sĩejim. Mag hag na hõrau nem hooba haajempa hich Jesuu wau sim sĩi bĩi wëjöm chi Herodeeu hũr hat'aawai ");
INSERT INTO noaH_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","hich dʌ̈i hãbam degam k'ʌʌnag, —Maan Juan chi hõor pör choomie k'ararrta deeu hiiu p'iidʌwia mag nʌrrʌmgui hajim hanʌm; maguata mag hõor mor masim k'ʌʌnpa monaau nʌrrabahab hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Hirua mag sĩerran mʌga hajim haajem: Maata hich Herodeeu hich naam Felipe hʌʌi Herodías hanʌmta k'echeu hauwi sĩejim hanaabá. Mag hat'eeta Juanau chi reíg, “Pua pöd pʌch naam hʌʌi k'echeu hauwi pʌch hʌʌik'a hauju k'aba simgui” hajim hanʌm. Mamʌ sĩi hichig magbaawai warag Juan pʌr haupi jaauwi, cárcel deg p'ãar sĩupinaa cadenau jʌ̃ sĩupijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hichig mag hiek'atarr haawaita chi Herodeeu hi t'õopʌ̈im hiigjeejim hanʌm. Mamʌ t'umaam k'ʌʌnau Juanau Hẽwandam hiekta jaau sim k'ap'ʌ narr haawai, hirua t'õopʌ̈ik'iin, jũrr hõrau hichta k'aigbaju ha k'ĩirjuwia pöd t'õoba haajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mamʌ mag nʌm hee, biek hãb chi Herodes año cumpliitarr hag p'iesta k'a nʌm hee chi Herodías k'a jemk'ajim haajem, hõor k'apan t'ʌnʌm na. Mag hi jemk'a sim hoowia, hich Herodeeu k'õchk'a t'ʌnʌisiwi, ");
INSERT INTO noaH_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hich bãaurrag, “Pʌchdëu nem k'õsim mʌrʌg jëeubá; mʌch himeerba mua deeb k'aba deejugui” hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mamʌ magbarm chi hãdaujã hũrtarr haawai hich chaai wawí sĩujim hanʌm. Magbaawai chi chaairau hich bãaurr jöoyag, “Magan mʌ hat'ee Juan chi hõor pör choomie pörta t'ëp hee haudeebá; jãata mua k'õsi hʌmgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mamʌ mag Juan pörta hichig jëeubaawai warre chi rey hök'ĩirjuu haadëjim hanaabá. Mamʌ hichdëu hõor t'ʌ̃rk'ʌʌitarr dʌ̈i hãbam mes gaai nʌmuata mag hichig jëeubarm nem deeju ha hiek'atarr haawai ");
INSERT INTO noaH_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","chadcha Juan cárcel deg sĩerr haar hõor pʌ̈iwia t'õonaa, chi pör happai t'ëp hee waibëepi jaaujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Magbaawai hi hipierr wëtwi, chadcha hichdëu jaautarrjö t'õonaa, chi pör t'ʌapnaa haibëewi, chi daupeer mag chi jemk'a sĩerrag deechëjierram haajem. Magbaa hichdëu jũrr hich hãdag deejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mag chi Juan hö t'ʌapbapʌ̈im habaawai, hi dʌ̈i wënʌrraajerr k'ʌʌndamau bëewi, harrwi, hauk'ërjierram hanaabá. Maimua ya mag hamau hi t'õobapäaiwaita maar haig Jesuug jawaan bëejierram. ");
INSERT INTO noaH_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mag Juan hö t'ʌap t'õobarm hich haar jaaubaimam hũrwia, hök'ĩirjugau warag chawag hõor chukag haar maju habaawai, marau hi joo harrjim. Pari mag wëtumua ya maar döjãrr paauk'abaadëm hõrau hoopʌ̈itarr haawai hag dak'a p'öbör nʌnʌidʌm heem k'ʌʌnau jũrr k'ʌd garmua maar na hërëubaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Maimua ya jopimawia hooimaawai hi na hõor pöoma t'ʌnaajim. Magbaawai ham dau haug k'augwi ham haaunaanjã monaaupʌ̈imajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mag nʌm hee, ya k'eeuraa haadeewai maach garmuata hirig, —Mʌg hõorjã chukag heeta ya k'eeuraa haadëm; hamag wëtpi jaaubá, p'öbör hee wëtwi hamach hat'ee k'öjudam për haumk'ĩir hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Magbaawai, —K'öju jʌraanpai chan ham wëtju k'aba nʌm. ¿Jãg pãachdëuta ham jãhogbamma? hajim, hich Jesuu maachigta. ");
INSERT INTO noaH_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Magbaawai marau, —Maar k'öju chuk'u nʌmgui hajim hamag deeg. Hãba pandamta cinco wai nʌm dʌ̈i hãwarrdamta dau numpai wai nʌm hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Magbaawaita hichdëu, —Mak'ʌʌndam mʌ haig haipidut hajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mag chadcha hich haig haipierrwai hõor pöm mag t'ʌnarrag, —P'ũak hee hohood habat hajim. Maimua mag pandam cinco narr dʌ̈i chi hãwarrdampa p'ë hauwia hʌ̃gt'aag heerpanaa, Hẽwandamag hag paar hʌ̈u hajim hanaa, hichdëupai chi pan t'orreunaa marag hʌapʌ̈imajim. Magbaawai jũrr maachdëuta hõrag jigmajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mag jigmamua, jigmamua, hich hiiu haawai t'umaam k'ʌʌnau hamachdëu k'öm haig k'ötarrjã dʌ̈rr hapiwi, pan pöm sobjim, chi hãwarrjã hagjö. Mag chi sobtarr p'ë haunaa hoowai t'ʌbʌt k'apan docen hãb höbërjim chi hipiirk'am. ");
INSERT INTO noaH_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mag hed mag Jesuu jãhogtarr k'ʌʌn chi k'apanag cinco mil naajim, hemk'ooin happai, hʌʌin beerba ni chaainjã beerba. ");
INSERT INTO noaH_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mag hõor pöm t'ach k'öpiwi jũrr maachta hich na maach dʌrbagk'atarr jap hee wëtpi jaaujim, hich na t'oom higar naaimamk'ĩir. Maagwai hichin hagt'a hich haig sĩsijim hõor hoopäaiwai. ");
INSERT INTO noaH_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Maimua hõor t'um hërëuwia hich happai haadeewaita, hi hiek buchag gaai hich happai hich Hayag jëwaan majim haajem. Maagwai ya hedau k'ëubaadeewaijã mam hich happai chirajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Magʌmich maran ya döjãrr naajim. Mamʌ maar k'ĩir garmuata p'ũ wë t'ʌnarr haawai maar japan p'ũasau höpp'ërta jiir hahau k'ajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Maimua ya hãspa hurumuata hich Jesús maar hẽudee bëejim. Pari mag hurumjã sĩi döjã hʌ̃rta jẽb t'etag gayamjö hurajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mag döjã hʌ̃rta jẽb gayamjö maachig hurum hoobaawai jãp'ierrwi maar hähäi k'ap'öbaadëjim. Mag jãp'ierrnaa hähäik'amua, —Keena, hak'aar k'abahaba hanaajim marau. ");
INSERT INTO noaH_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pari magbaawai hich Jesuu, —Keena, hoob jãp'ierrmiet; mʌ k'abahab hajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Magbaa Pedroou hirig, —Señor, chadcha pʌchta Jesús k'ai, magan mʌjã pʌchjö döjã hʌ̃r pʌch haar mapibá hajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Magbaawai hirig, —Bëejuma hajim Jesuu. Magbaawai chadcha Pedroou jap heemua waaidʌbaadëwi Jesús k'ĩirp'ee dʌdʌrgmaa hajim, döjã hʌ̃rta durramjö. ");
INSERT INTO noaH_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pari p'ũas dau dapag hoowi jãp'ierrbaadëjim. Mag jãp'ierrbaadëm hee hĩchab ya hierrpamajim. Magbaawaita maach Pörög, —Señor, mʌ hoobahur, mʌʌn hierrpamamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Magbarm bʌ̈rre Jesuu hi jua gaai pʌrnaa, —¿K'ant'ee pua pʌch hierrpaju k'ĩirjujĩ? Jãgan pua chan mua pʌchig nem mag haawaijã mʌ hiek hʌ̈k'aba chirabma hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Maimua ya ham jap hee waaidʌtk'abaadee chi p'ũ meuu haadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mag chi Jesús jap hee pabaadee hi k'ĩirp'ee kanieu p'õbk'anaa, —Chadcha pʌʌta Hẽwandam Hiewaau hanaajim, marau hirig. ");
INSERT INTO noaH_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mag wëtumua t'oom higar Genesaret durr p'ẽeubaimajierram. ");
INSERT INTO noaH_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mag Jesús barbaimam hõrau k'augp'öbaadee, sĩi hag perás bĩi jöisijim. Mag hamachdëu k'augp'öbaadee hi haig hõor mor masim k'ʌʌn haibëenaa hirig, ");
INSERT INTO noaH_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Maar haaunaanag pʌch k'ajũahidam gaaipai k'ãijã pʌrpibá haajeejim, monaaumk'ĩir. Mag chadcha t'um hi k'ajũa gaai pʌrmam k'ʌʌnan warre monaauk'a maajeejim, mag sĩi pʌrbarmuapai. ");
INSERT INTO noaH_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hĩchab Moiseeu p'ã pʌatarr hiek wajapcha hʌʌrk'aajem k'ʌʌn dʌ̈i Hẽwandam hiek jawaag chi machnaan hi haig bëejierram. Mak'ʌʌn Jerusalenmua bëetarr k'ʌʌn hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Mag bëewi hirig, —¿Jãgwi pʌ k'apeenau maach jöoin hi pʌa nʌ? ¿Jãgwi t'ach k'oowaijã jua hʌbata t'ach k'oojẽ? ¿Pãrau k'augba naab jãg hʌ̈u k'aba sim? haichëjierram. ");
INSERT INTO noaH_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Magbaawai Jesuu hĩchab, —¿K'ant'ee pãraujã hagjö Hẽwandamau jaau sim t'um hipierraa habanaa sĩi pãach jöoin hiita hʌ̃rcha hʌʌrk'aju hẽk'aajerráma? hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Magnaa hamag, ¿Pãrau k'augba nʌ hajim, Hẽwandam hiek p'ã sim gaai jaauwai, “Pʌch haaijã pʌch hãd dʌ̈i jãsenenaa hök'ö habá” ha sim? Maimua “Har hiwiir hãbmua k'ãijã hich haai wa hich hãd k'ãijã t'õpnaa hãauk'a hiek'a simʌn warreta t'õopʌ̈iju haai nʌm” ha sim, ¿majã pãrau k'augba nʌ? hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Magnaa hichdëupai, Pari Hẽwandamau hich hiek gaai mag jaau simta, jũrr pãar hiek mag hãbmua k'ãijã dich hayag wa dich hãdag k'ãijã, “Pãrau hig nʌm mua wai chirab mamʌ, pöd mua deeju k'abam, ya t'um Hẽwandam hat'eem haawai” ha hiek'aju haai sim hanʌm, dich dënnaan dau haug k'augba. ");
INSERT INTO noaH_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pari pãrau hõrag mag jaau nʌm haig, Hẽwandamau nem jaau sim hisegnaa jũrr pãach jöoin hiita hʌ̃rcha hʌʌrk'a naabahab hajim Jesuu, hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Magnaa, Chadcha jãg Hẽwandam hiek gayam pãachdëu nem jaaujemjö k'aba jũrr hag chaaur nem wau sĩerrjëem k'apta Hẽwandamau hich hi jaaumie jöoi Isaías k'ararrag pãach higwia hich hiek'atarr hiek mʌg p'ãpijimgui hajim. Magnaa chadcha hag gayam jaaubaadëmua, ");
INSERT INTO noaH_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Pãran, sĩi par hiek'aupaita Hẽwandam hiek hʌ̈k'a nʌm hʌ̈k'a nʌm haajemgui” hajim Jesuu hamag. “Pari mag nʌm chan par chadcha t'ãraucha hʌ̈k'abamta mag sĩerrjëem. Pãach mag nʌm gaaimua pãar t'ãar chan hi dak'ajã k'aba, sĩi hi warpta t'ʌnʌmgui” hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“Jãg nʌm haiguin parii pãach hip'it'ur pãrau hirig jëeuju. Pãrau jaau nʌmjã sĩi wir haig pãach k'ĩirjugpaiu; jã hi hiek k'abamgui” hajim Jesuu hamag, warrgarwe Hẽwandamau jaautarr higwia. ");
INSERT INTO noaH_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Magnaa hõragta heerpanaa, ’Wajap'a mʌ hiek hũrbat hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Maadëu nem parhooba k'ö nʌmuapai chan Hẽwandam dau na maach hãrpiba haajemgui hajim. Hẽwandam na hõor hãrpiejemʌn hiek'aju k'abam nempa k'ĩirjunaa hiek'a nʌmuata hõor hãrpiejemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hirua magbapäaiwai maach chi k'apeenauta hirig, —Fariseonaan hiek, mag pua magbarm haig, ham k'ĩirta hiek'abapʌ̈im haajem hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Magbaawai jũrr hichdëu maachigta hiek'amamua, —Hoob ham hiek hasekasmiet hajim. Pãrau k'ap'ʌ nʌm, nemjĩir hee p'ũak k'aigbam höbeerwai t'ʌrrëupäaijem. Hich jãgta hajugui hajim mʌ Hayau ham dʌ̈i. Ham hichdëu jʌr hau sim k'ʌʌn k'aba haawai nemjĩir hajap'am heemua p'ũak chi k'aarpa t'ʌrrëunaa barbapʌ̈imjöta hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Magua, hidëu warag k'ĩuu sĩubat hajim. Jãk'ʌʌnan hamachjã dau k'ĩsu nʌmta hagjö dau k'ĩsum k'ʌʌn jua gaai pʌrnaa hëudʌ harrjem k'ʌʌnjöta nʌmgui hajim. Pãrau hoowai merag chuk'u sĩebá, dau k'augba k'itʌmua hagjö dau k'ĩsu k'itʌm jua gaai pʌrnaa harrk'iin, hãb bʌ̈hëu subaadee hamach numwe burrjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Magbaawaita maar heem hãb Pedro haajemua hirig, —Señor, cha pʌchdëu jaaubapʌ̈im deeu marag wajap'a jaaubá; marau pöd k'augba habarmgui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Magbaawai Jesuu marag jaaubaadëwia magjim: —¿Wa pãrau hagt'a k'augbata nʌwa? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Pãrau k'ap'ʌ naabá, maadëu nem k'ö nʌm t'um maach bi hee mawia chëbapäaiwai deeu chuk'u haadeejem? Magua dichdëu t'ach k'ö nʌmuapai chan maach hãrba haajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Maach hãrpi nʌmʌn t'ãar heemua k'ĩirjug k'aigbam hiek'a nʌmuata Hẽwandam na maach hãrpiejemgui hajim, ya k'ĩirjunaata hiek'amaawai. ");
INSERT INTO noaH_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nem t'um maach k'ĩirjug heemuata höbër t'ʌnʌm: k'ĩirjug k'aigbam, hõor t'õoju, dich hõor k'abam dʌ̈i k'apes haju, dich k'aman hap'a k'ãijã dich hõor dʌ̈ímjö haju, nem jĩgk'aju, sëuk'aju maimua chik'am hëugar chad k'abam hiek hiek'aju. ");
INSERT INTO noaH_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Magʌm nemeuta chadcha Hẽwandam na hõor hãrpiejem. Mamʌ chi machnaanau jaau nʌmjö sĩi jua sũgba t'ach k'ö nʌmuapai chan Hẽwandam dau na maach hãrba haajem ha jaaujim marag, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Maigmua higbaadeeu jũrr p'öbör numí Tiro Sidón dʌ̈i nʌmʌg petaawai maarjã hi dʌ̈i wëtjim. ");
INSERT INTO noaH_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Maimua ya mam paauk'abaimamta, hʌʌi hãb Israel durram k'aba Canaanpie hʌʌi mag perás sĩejerrta hähäag bëewia Jesuug, —Señor, mʌ hap hʌrrʌm mʌ dau haug k'augbá hajim. Mua k'ap'ʌ hʌmgui hajim, pʌʌta chadcha Hẽwandamau pʌ̈iju haajerrau. Maagwai mʌ chaai monawaagjã pʌ jua t'eeg sim. Mʌ k'a dösãt bënëu baarjemta pʌrʌg monaaubapʌ̈i ha hʌmgui haichëjim, hirig chaigpamamua. ");
INSERT INTO noaH_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pari par hũanau mag chaigpa k'itʌmjã Jesuu bʌ̃ʌrjã hi hiek hʌ̈k'abajim. Magbaawaita marau hirig, —Senõr, ¿jãg pua hirig mapi jaaubamma? Ya hatcha magaajã marau hũrmap'a nʌm. Magbamʌn hich jãg maach hẽudee hähäag majuwai hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pari magbaawai jũrr Jesuu chi hʌʌiragta, —Hẽwandamau mʌ pʌ̈itarran, maach meeun israelnaan sĩi oveja hok'oo durrumjö durrum k'ʌʌn peerdʌ haumk'ĩirta mʌ pʌ̈ijim hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pari mag nʌm hee, warag hi haigcha bëenaa kanieu p'õbk'anaata, —Señor, mʌ hap hʌrrʌm mʌ chaai monaaubapʌ̈i hajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Magbaa, judionaan k'abam k'ʌʌn chan monaauju k'abam hawi juau hogt'ompai chi Jesuu warag, —¿Pua mʌ hiek'a chirʌm hũrbata sĩ? hajim. Pʌ deeum durram haawai, mua pʌ chaaita nacha monaauk'iin, mua hoowai dich chaainag deeju harr panta k'echeunaa saakienag deebarmjö hajugui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pari magbaa hũanau dʌ̈i, —Señor, jãan chadaugui hajim. Mamʌ pua hoowai, ¿saakienaujã hamach pap juasur mes heegar k'ʌimam k'öba haajẽ? hajim. Maagjeewai mʌ Israelpie hʌʌi k'aba hʌab mamʌ, ¿pua mʌ chaaijã dau haug k'augbaju k'ai? Mua k'ap'ʌ hʌm, pua hi monaaupʌ̈iju haai simgui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Magbaawaita, —¡Jöo! Jãgan chadchata mua pʌch chaai monaauju k'ap'ʌnaata pua hʌ̈k'a hʌmgui hajim. Magan chadcha pʌchdëu jaau simjö pʌ chaai monaauju hajim hirig Jesuu. Mag, chadcha Jesuu mag hiek'abarm bʌ̈rre chi chaai monakk'a haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mag Sidonmua deeu maar bëewia hũwaai mag t'ʌrrdö pöm sim Galilea haajem higaau naaichëjim, hich Jesús dʌ̈i. Maimua buchag gaai waaidʌwia hoo sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mag hamach dak'ĩir jupbaimaawai hõor pöm hi haar wëtwi hi bigaau p'ʌʌrbaadëjim. Mag hõor pöm t'ʌnʌm hee hi haig haibëemajim: bʌ̈ wëdʌ wëdʌ k'it'ëem k'ʌʌn, dau k'ĩsum k'ʌʌn, bʌ̈dam wa juadam k'ãijã hãk'ãraam k'ʌʌn, meu meraam k'ʌʌn maimua tag haaunaan k'amor machag k'ĩirpierr hi haig haibëenaa hi bʌ̈k'ʌrr hausĩumaajeejim. Maagwai magʌm t'um hichdëu monaaupʌ̈i maajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hamach daúacha mag meu meraa k'it'ëe harrjã hijẽb nʌrrjëe, juadam wa bʌ̈dam k'ãijã hãk'ãraa k'it'ëe harrjã monak'a, maimua dau k'ĩsu k'it'ëe harr k'ʌʌnpa dau wajap'a nʌrrjëem hoowia, sĩi hõor dauderraa naajim. Mag hamachdëu hoo nʌm gaaimua maach meeun k'abam k'ʌʌnaupata maach meeun israelnaan Hẽwandamag jëeup'öo t'ʌnaajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Maimua mag maach hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnagta, —Hõor pöm mʌg t'ʌnʌm mʌ dau hee dau hap'ʌʌ durrumgui hajim. Ya k'ãai t'ãrjup pam ham maach haigmua bʌ̃ʌrjã hogdʌba, t'achdam k'öjujã chuk'u nʌm. Hich jãg t'ach k'öba chan mua hamach diig pʌ̈imap'a chirʌmgui hajim. Hich jãg pʌ̈ik'iin, di haar barba k'ãijã k'ʌd hee jãdaúa p'ʌrëubajupa hajim, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Magbaawaita marau hirig, —Mamʌ mʌg hõorjã chuk sim hee, ¿jam maadëu k'öju bawaagauma? hanaajim, hõor pöm mʌg t'ʌnʌm k'öpieg. ");
INSERT INTO noaH_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Magbaawai hich Jesuu marag, —¿Pãrau pan dau k'arr wai nʌma? ha jëeujim. Magbaa marau, —Sietepai, maimua hãwarrdamjã har dau k'apan k'aba durrumgui hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Magbaawai hichdëu hõrag k'ʌt jupk'api jaauwia, ");
INSERT INTO noaH_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","mag pandam siete narrjã chi hãwarrdam dʌ̈i hãba jua hee p'ë hauwia, Hẽwandamag hʌ̈u hajim hanaa t'orreubaadëjim. Magnaa maachig hʌapʌ̈imaawai marau jũrr hõrag jigmajim. ");
INSERT INTO noaH_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mag jig p'ʌʌrdʌdʌgmamua t'umaam k'ʌʌnau hamachdëu k'öm haig k'ötarrjã, pan pöm sob t'ʌnʌisijim. Mag chi sobtarr, t'ʌbʌt siete marau hipiirk'a haujim. ");
INSERT INTO noaH_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mag hed mag chi t'ach k'ö narr k'ʌʌn cuatro mil naajim, hemk'ooin happai, hʌʌinjã beerba ni chaainjã beerba. ");
INSERT INTO noaH_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Maimuan chadau hõrag wëtpi jaaubaawai hagdaujö hamach majupierr haaidʌjierram. Mag t'umaa hërëubaadeewain chadau, hichjã jap hee waaidʌbaadee, marau hi Magadanag harrjim. ");
INSERT INTO noaH_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mag Magadán durr paauk'abaimaawai fariseonaanau Saduceonaan dʌ̈imua Jesús hoon bëejierram. Pari mag bëetarran sĩi hi himeraa pʌr haum k'õchgaupai harr haawai hirig hamachdëu bʌ̃ʌrjã hooba haajem nemta hamach dak'ĩir hedjã hee waupi jaau naajim, mag gaaimua chadcha Hẽwandamau pʌ̈iwiata mag nʌrrʌm ha hamachig k'ap jaaumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pari Jesuu ham hipierraajã k'aba, warag sĩi hamag, —¿K'an jãgwi pãrau k'eeurag hedau dubmamua hedjã p'ur waau t'ʌnʌm hoowia, “Nan hedau wärjäp'ä haju” haajẽ; ");
INSERT INTO noaH_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","maimua jũrr hedaup'errejã hagjö hedau höbër hurum bʌ̈ʌu hedjã p'ur t'ʌnʌm hoowi, “Nan hedau k'õrk'aju” ha jaaujẽ? hajim. Pãrau jãg hedjã hoobarm gaaimuapai hed wärjäug haju wa hed k'õrk'ajujã nem k'aug nʌmta, ¿jãga jãg pãrau pãach daúa mua nem wau chitʌm hoo nʌmjã pöd k'aug hauba nʌ mʌ chadcha Hẽwandamau pʌ̈iju jaaujerr? hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Pãran pãachdëu Hẽwandam hiseg nʌm gaaimua warag chi hajaugjã chuk'u t'ʌnaawaita warag pãachdëu nem hooba haajem nempata pãach dak'ĩir waupi nʌm. Mamʌ mua waubamgui hajim. Mag k'ãai warrgar jöoi Jonás haajerr nemmeeurrk'an buch hee k'ãai t'ãrjup sĩet'urtarr gaaimua Nínivepienau Hẽwandamau hi pʌ̈itarr k'aug hautarrjöta, hĩchab mʌchjã Hẽwandamau pʌ̈itarr pãrag k'ap'ʌ hapijugui hajim, mʌch hiiu p'iidʌbarm gaaimua. Mamʌ magʌmjã pãrau hʌ̈k'abajugui hajim. Mag hiek'apet hawi hichta warag chaaug higbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mag higbaadëwi ya t'oom higar paauk'abaimaawaita maar k'ĩir hee dʌhnʌisijim, panjã haibëeba sĩi hich jãgta wënʌrrʌm. ");
INSERT INTO noaH_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Magbarm dʌ̈ichata hich Jesuujã marag, —K'ĩir k'ap'ʌ wënʌrrat'ʌ̃ hajim. Fariseonaan bënta saduceonaan bën dʌ̈i jãg levadurajö sim pãach gaai dʌrbapimiet hajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mag hũrwia, chadcha levadurata jaau simpii hawi, maach happaijã, —Keena, maach chan chadchata pan haibëebajimwai hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mamʌ maar mag hiyʌ̈ʌ nʌmjã hich Jesuu k'ap'ʌ sĩerr haawai, —¿K'ant'eeta pãar mag pan haibëebajim hanʌ́ma? Pãrau chan jãgan mua nem wau chitʌmjã hoobamjöta haajeeb hajim, mʌg mʌ dʌ̈i hãba wënʌrrʌmjã hʌ̈k'aba haag. ");
INSERT INTO noaH_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pãrau k'ĩir hee paba nʌ, mua pandam cincopai narrau hʌʌinjã beerba, chaainjã beerba, hemk'ooin happai cinco mil jãhogtarr? Maimua ¿t'ʌbʌt k'arr hipiirk'a haujĩ chi sobau? ");
INSERT INTO noaH_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿K'ĩir hee paba nʌ hagjö, pan sietepai narrau hõor pöm cuatro mil narr jãhogtarr? Maimua jãg hedjã, ¿t'ʌbʌt k'arr hipiirk'a haujierrá chi sobau? Pan chaarta hig nʌm hak'iinjã, ¿pãrau k'ĩirjuawai hĩsjã mua pöd pãach jãhog haubajupii nʌ? ");
INSERT INTO noaH_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jãga jãg pãrau bʌ̃ʌrjã k'aug hauba nʌ hajim, mua pãachig, “Fariseonaan bën saduceonaan bën dʌ̈i levadurajö simta pãach gaai dʌrbapimiet” haawai? Mua mag chirʌm haig chan pan chaar higwiata pãrag mag hiek'aba chirʌm; wajapcharan muan maiguin, hoob hamjö chik'am k'ĩir haawaipaita chadam hiekjö hiek'amiet ha chirʌmʌu hajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Magbaawaita marau k'augp'öbaadëjim, Jesuu levadura chaar jaauba, sĩi fariseonaanau saduceonaan dʌ̈imua nem jaaujemta jaau sim. ");
INSERT INTO noaH_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mag wëtwia deeum durr Cesarea de Filipo hanʌm paauk'abaimaawai hich Jesuu marag, —Hõrau mʌch chi Hemk'ooi Hiewaa higwia hiyʌ̈ʌ nʌm hũurwai, ham hiek ¿mʌ k'ai haajẽ? ¿Pãrau hũrba haajẽ? ha jëeujim. ");
INSERT INTO noaH_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Magbaawai marau hirig, —Ham hiek pʌ Juan chi hõor pör choomie haajem; deeum k'ʌʌnau jaauwai pʌʌta Elías haajem, warrgar Hẽwandam hi jaaujerr; wa magba Jeremías k'abam k'ai, dewam k'ãijã haajem, hagjö Hẽwandam hi jaaujerr. ");
INSERT INTO noaH_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Marau hichig magbaawai jũrr maachigta, —¿Ma pãachdëujãma? Pãrau k'ĩirjuawai, ¿mʌ k'ai hagá? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Magbaawai Simón Pedroou, —Pʌ Cristo k'abahab hajim hirig, hich Hẽwandam Hiewaa warrgarwe hichdëu jʌr hauwia hõor peerdʌ haumk'ĩir pʌ̈iju ha jaaujerr. ");
INSERT INTO noaH_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Magbaawai Jesuu hirig, —Simón Pedro, Jonás hiewaa, hõrau bʌ̃ʌrjã pʌrʌg jaautarr k'abamta chadcha pua hag heyaa jaaubapʌ̈imkë hajim. Jãg pua k'ap'ʌ jaaubapʌ̈imʌn, jãan hich mʌ Haai hʌ̃gt'ar chiraajemuata pʌrʌg mag k'ĩirjupiwi hajim. Maguata pua hag heyaa jaaubapʌ̈ibahab hajim. ");
INSERT INTO noaH_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pedro, maagwai pʌʌn chadcha pʌch t'ʌ̃riu jaau simjö mokdauu hajim hirig. Pua mʌ hiek jaaubaadëm gaaimuata mua mʌch hiek hʌ̈k'a nʌm k'ʌʌn k'apaana hapiju. Mag k'apaana haadëm chan pãach chi hʌ̃rʌm k'ʌʌnan k'ëchwiajã, pãar hak'aar chan hok'ooba hich mag Hẽwandam dʌ̈ita nʌisiju hajim. ");
INSERT INTO noaH_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pedro, pʌrʌgta mua mʌch hiek jaaumk'ĩir jaau chirʌmgui hajim. Pua mʌ hiek jaaubaadëm hũrwi hʌ̈k'a nʌm k'ʌʌn mʌ dënk'a nʌisiju. Mamʌ hĩchab pua jaau k'itʌm hũr nʌmjã hasekasba warag hiseg nʌm k'ʌʌnan hamach mag nʌm gaaimua warag hich mag hok'oo wënʌrrajugui hajim. Mag nʌm haiguin pua chi mʌ haar höbërju haai nʌm k'ʌʌnag puertdi weeu deenaa pöd dubbaju haai nʌm k'ʌʌn hat'ee sĩi warag p'ãar sĩsiuk'amjöta haju. ");
INSERT INTO noaH_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mamʌ Jesuu mag hich chadcha hich Hẽwandamau jʌr hauwia pʌ̈itarrk'a simjã bʌ̃ʌrjã hõrag jaaupiba jaaujim marag. ");
INSERT INTO noaH_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Maimua jaaumamua hich Jerusalenag majujã jaaujim. Mag Jerusalén pabaimaawai jöoin chi pörk'a nʌm k'ʌʌnau p'adnaan chi pörk'a nʌm k'ʌʌnaupa Moisés hiek jawaag chi machnaan dʌ̈imua hich dau hap'ʌʌ wai naawi hich t'õojujã jaaujim. Mamʌ mag hamau hi t'õowiajã deeu hũwaai k'ãai t'ãrjup nʌm hee deeu hich hiiu p'iidʌjujã jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mag jaaumam hũrwia, Pedroou hich happai chaaur t'ʌ̃rnaa, —Señor, ¿k'anii Hẽwandamau pʌ dʌ̈i magpibarju? Pʌ dʌ̈i chan hõrau magju k'aba nʌmgui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pari Pedroou hichig magbaawai, jũrr chi Jesuu hirig, —Jöpk'aa mʌ haigmua chaaug petá hajim. Meperauta pʌrʌg mag hiek'api sĩebahab. Puan mag sim haig sĩi warag k'aibag hee mʌ burrpijuuta hẽk'a simgui hajim. Pua chan Hẽwandamau nem waum hig simjã k'augba, sĩi parhoobam k'ʌʌnjöta k'ĩirju simgui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Maimua hichdëupai jũrr maach t'umaam k'ʌʌnagta, —Chadcha pãrau mʌ hiek pãach t'ãraucha hʌ̈k'a nʌm k'ai, magan mua nem waupi jaau chirʌm happaita waubat, “Mʌchdëuta k'ap chirʌm mʌchdëu nem wauju” ha hiek'aba. Mʌ gaaimua chik'amnau pãach dau hap'ʌʌ t'õoju k'ĩirjuwia k'ãijã magʌmjã higba waragta hʌ̈k'anaat hajim. ");
INSERT INTO noaH_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Har mʌig heegarjã mʌ gaaimua p'it'urg haumap'a nʌm k'ʌʌn chan bʌ̃ʌrjã hʌ̃gt'ar höbërbam. Magarrau har chi mua nem jaau chirʌm waum k'õchgauta hamach nemjã k'ĩirjuba, sĩi warag mʌ gaaimuata dau hap'ʌʌ hanʌm k'ʌʌnan chadau hʌ̃gt'archa höbërju jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pãrau hoowai, ¿k'an wajaug sĩ hajim, hãbmua mʌg durr t'um hichdëupai jʌ̃a wai sĩsim, mamʌ mag sim meebaadee k'ĩmie durr petam? ¿Hirua hich durr t'um hich dʌ̈i harrju haai sĩ? Pöd harrbam. ¿Pãrau k'ĩirjuawai hãbmua k'ãijã hʌ̃gt'ar höbëraag p'atk'on pöm p'agju haai sĩ? Mag p'agwiajã pöd dubbamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mʌgnaa mʌ Hayau mʌg durr hi hagk'am hedjã mʌchta hichdëu jua t'eeg deetarr dʌ̈i hi chognaan angelnaanpa bëewi, mʌig heegar hamach nem waaujerrpierr haju ham dʌ̈i: chi nem wajap'a waaujerr k'ʌʌn dʌ̈ijã hich hagjö maimua nem k'aigba waaujerr k'ʌʌn dʌ̈ijã hich hagjö. ");
INSERT INTO noaH_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cha mʌ hiek'a chirʌm hiek'au hãaur k'ʌʌn cha mʌ hiek hũr nʌm k'ʌʌn chan mʌch chi Hemk'ooi Hiewaa t'umaam k'ʌʌn Pörk'a bëeju hedamjö haadëm hoobam haigjã meebajugui ha jaaumajim. ");
INSERT INTO noaH_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mag hich Jesús maar dʌ̈i hiyʌ̈ʌ simua mag maar k'apeen hãaur k'ʌʌnag hamach daúa hich hoopiju jaautarr k'ur seis días haadëm hee, cerro pöm sim gaai petajim. Mag hich mam dʌ̈i p'ë harrjim: Pedro, Santiago maimua Juan, hich Santiago heeum. ");
INSERT INTO noaH_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mag mam wëtwi ham dak'ĩirta Jesús k'ĩir chaaupabaadëjim haajem. Hi k'ĩir hoowai mʌg hedau hãsdawam k'ĩirjöta bʌ̃ʌ t'ʌnʌisijim haajem; maagwai hi k'ajũa chará p'uumjö haadëjim haajem, hich bäpgau. ");
INSERT INTO noaH_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hi magbaadëm hee hoowai warrgarm jöoin Moiseeta Elías dʌ̈i hiyʌ̈ʌ dʌnʌnʌihdʌ naajim haajem, Jesús dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mag hoobaawaita Pedroou Jesuug, —Señor, hʌ̈u chi hagamjö nem wajaug maar mʌig nʌmgui hajim haajem. Pua k'õs hak'iin mua rãichdidam t'ãrjup hëuk'am hajim hanʌm: hãb pʌ hat'ee, hãb Moisés hat'ee maimua hãb Elías hat'ee. ");
INSERT INTO noaH_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mamʌ Pedro mag hiek'a dʌnʌm hee, jʌʌnt'umie baug bëewi ham jöodʌ hat'aichëjim hanaabá. Magbarm hee mag chi jʌʌnt'umie heemuata woun hiekjö, “Chamʌʌta mʌ Hiewaa mʌchdëu jãsehne wai chitʌmʌu, hõor peerdʌ haumk'ĩir mʌchdëu jʌr hautarr. Hirua nem jaau simta hipierraa habat” ha hiek'abarm hũrjierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hamach chi dʌ̈i wënʌrrarr k'ʌʌnaucha jaauwai, hamachdëu mag hũrbaawaita jãp'ierr p'öbaadëm hiek'au warag kanieu t'ʌk'öok'anaa heeg k'ök'öod hap'öbaadëjim hanaabá, k'ĩeb jẽb gaai dagau dʌrk'a. ");
INSERT INTO noaH_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Magbaa Jesuu ham haig bëenaa ham gaai juau sĩesĩenaa, —P'iidʌtk'abat, hoob jãp'ierrmiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Magbaawai chadcha hamau p'iidʌtk'anaa hoowai, tagam k'ʌʌn chuk'u, hãba Jesús happaita sĩejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Maimua deeu jerag bëejierram haajem. Mag hʌʌrbagk'a wëdurumua chi Jesuu hamag, —Mʌg pãachdëu hootarr hoob deeum k'ʌʌnag jaaumiet. Ya mʌch chi Hemk'ooi Hiewaa meewia deeu p'iidʌbaawain chadau jaaubat hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Magbaawaita jũrr hamach garmua hirig, —¿Jãgwi Hẽwandam hiek jawaag chi machnaanau jaauwai, mag Eliata hich Hẽwandamaucha pʌ̈iju jaaujem na bëeju haajẽ? hajierram haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Magbaawai hich Jesuu, —Chadcha chi bëen Eliata nacha bëema hajim hanʌm. Pari mag hi bëeju jaautarran, mag Hẽwandamau pʌ̈iju haajerr hõrag nʌpi jaaumk'ĩirta bëeju jaaujimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pari Elías ya bart'urjim. Mag hi bart'uurwaijã hamau hi k'aug hauba, sĩi warag deeum k'ʌʌnpii hawi hi dʌ̈i hamachdëu hampierr hawi warag hi t'õopʌ̈ijierramgui hajim hanʌm. Hamachdëu hi dʌ̈i jãgtarrjö mʌch chi Hemk'ooi Hiewaa dʌ̈ijã hajugui hajim hanaabá. Mʌg chirʌmʌn mʌʌn wajap ham jua machag hãwatjugui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pari Jesuu hamachig magbaawai warre k'aug hat'ajierram hanaabá, warrgar Hẽwandam hi jaaujerr Elías k'aba, Juan chi hõor pör choomie higwiata mag sim. ");
INSERT INTO noaH_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mag wëdurumua ya maar tagam k'ʌʌn dʌ̈i narr haig jër paauk'abaichëm hee, woun hãb bëewi hi k'ĩirp'ee p'õbk'anaa hirig chaigpamamua magchëjim: ");
INSERT INTO noaH_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Señor, mʌ chaai wai chirʌm t'õt'õrrsö k'itʌm. Mʌ hap chitʌm mʌ chaai dau haug k'augwia monaaubapʌ̈i haichëjim. Jãg k'itʌmʌn nem t'eegta baarjem. K'ar chará hooju chuk'u haawai barbaadëmua hõt heejã burrjem; wa magbamʌn dö heejã sĩi dobojo haimaajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mua mʌig pʌ k'apeen haig haibëetarrjã hamau pödbajierramgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Magbaawai Jesuu magjim, hõrag heerpanaa: —Pãran chadcha pãach t'ãar k'aibag gaaimuata Hẽwandamau jãg chaai monaaujujã k'ĩirjũba nʌm. Pãrau jãg Hẽwandam jua t'eeg simjã k'augbamjö nʌm, ¿hich jãgta sĩi mua hãwat chitaju haai chirʌ́ pãrau hoowai? ¿K'an hatchata pãrau mʌ pãach dʌ̈i chitapim hig nʌma? hajim, hajapcha hʌ̈k'aag. Magnaa, Mʌ haig mag chaai haipidut hajim. ");
INSERT INTO noaH_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Magbaa chadcha chi chaai hich haig haipierrwai chi meperag meeurraunaa höbërpi jaaubaawai, hi hipierr höbërbaadëjim. Magbarm haigmua chi chaai monak'a hich mag sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mag chi chaai monaautarr k'ur maach hap paauk'awi marau hich Jesuug, —¿Jãgwi marau pöd jãg chaai mor heem mepeer höbeerpi haubajĩ? ha jëeujim. ");
INSERT INTO noaH_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Magbaawai hich Jesuu marag magjim: —Jãan pãachdëu mʌg chaai Hẽwandamau monaaujujã k'ĩirjuba narr gaaimuaugui hajim. Pãrau Hẽwandam jua t'eeg sim k'ap'ʌnaa pãachdëu nem mag habarmjö hapiju k'ĩirjunaata nem wauk'iin, Hẽwandam hat'ee chan p'it'urm nem chuk'u haajeewai, chadcha pãachdëu jajaauk'ampierr hich mag pãachdëu jaau nʌmjö hapiju. Pãar k'ĩirjug hoojem hanaa chi pömag mostaza daudam har maach dau hee paba k'itaajemjö k'ãijã k'itak'iin, chag durrsĩig k'ãijã, “Jöpai mʌigmua mawia chum dʌnʌʌubaimá” habaawai chadcha p'it'urg chuk'u mawia pãar hipierr pãachdëu jaaubarm haar dʌnʌʌuwimajugui hajim.  ");
INSERT INTO noaH_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Magnaa hichdëupai, Jãg mepeer k'ĩir chan sĩi hiek'abarmuapai höbërba sĩerrʌm. Jãg höbërpi hawaagan, bʌ̃ʌrjã t'ach k'öba sĩi Hẽwandamagpai jëeu nʌʌ hawiata höbërpi jaaubaawai höbeerjemgui hajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea durr maach hich Jesús dʌ̈i hãba wënʌrraajeewai hichdëu marag magjim: —Mʌch chi Hemk'ooi Hiewaa mʌg chirʌmʌn chi t'ierrnaanag pʌr deebaawai ");
INSERT INTO noaH_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sĩi hamau mʌ t'õopʌ̈iju. Mamʌ mag hamau mʌ t'õowiajã k'ãai t'ãrjup nʌm hee deeu mʌ hiiu p'iidʌjugui hajim. Maachigcha mag jaaubaawai chadcha maar hök'ĩirjuu hap'öbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesuu maar hich dʌ̈i p'ë harrwi Capernaum p'öbör barimajim. Magbaawai Haai hi jëeujem di paar p'atk'on jëeujem k'ʌʌnau Pedro hich happai sim haar wëtwia hirigta, —¿Pʌ maestroou chan Haai hi jëeujem di paar p'agju haai simta p'agba haajeeb? haimajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Magbaawai hirua, —Keena, mʌ maestroou p'agba haajeeb ha chirajim haajem hamag. Maagwai ya maar maach jẽer narr di haar naajim. Maimua ya chi Pedro maach haar barbaimaawaijã jũrr Jesuu hirig hich hag hiekpai, —¿Pua jãga k'ĩirju chirʌ́ Simón? hajim. ¿Pua hoowai mʌg durr gaai reinaan t'ʌnʌm k'ʌʌnau chijã k'ʌʌnagta dëbpaar jëeujẽ: hamach k'odnaanag wa sĩi parhoobam k'ʌʌnag? ");
INSERT INTO noaH_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Magbaawai Pedroou hirig, —Hamach k'od k'abam k'ʌʌnagma hajim. Magbaata Jesuujã, —Chadcha chi k'odnaanau chan p'agba haajemgui hajim. Magua muajã mʌch Haai gaaimua hagjö p'agbaju haai chirabahab. Chi Haai hi jëeujem di hi dën haawai muajã p'agba, pãraujã p'agbaju haai nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mamʌ hamag maach hëugar hiek'am hugua maadëujã hichiita p'agju haai nʌmgui hajim Pedroog. Maimua, T'ʌrrdö hee dö hʌabamí hajim. Nau nacha pʌch jua gaai k'öbaichëm pua jiir hat'am hö hee p'atk'on sĩeju. Mag p'atk'onau hʌ̈u pua mʌ kõitjã p'agwi, pʌch dënjã p'agpʌ̈ijugui hajim Jesuu Pedroog. Magbaawai Pedroou chadcha hichig jaautarrjö hajim. ");
INSERT INTO noaH_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hich mag hiyʌ̈ʌ nʌmua marau hich Jesuug jëeu naajim, hichta mʌg hatag t'umaam k'ʌʌn Pörk'abaadeewai maach mʌg wënʌrrʌm heem k'aita hʌ̃rʌʌcha sĩsiju k'ai ha k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Magbaawai Jesuu chaaidamta t'ʌ̃rnaa maar jãrr dʌnʌʌupinaa magjim: ");
INSERT INTO noaH_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Mʌ cha hiek'a chirʌm hiek'au pãrau pãachta hʌ̃rʌʌcha ham k'õchgau pãachdëu mag k'ĩirju nʌm hisegnaa chaain mʌgʌmdam hagt'a serbiibamjöo habam chan, pãar pöd mʌ dʌ̈i chi pörnaan k'aju k'aba nʌm. ");
INSERT INTO noaH_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mag mʌchta chi Pörk'a chirsim hed mʌ garcha joot'ʌimaju k'ĩirju nʌm k'ʌʌnan warag hamachta serbiibamjönaa chaain mʌgʌmdamjöta haju haai nʌmgui hajim, mag hamachta hʌ̃rʌʌcha hajujã k'ĩirjuba. ");
INSERT INTO noaH_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pãrau mʌ dënjö mʌg k'it'ëem hãb k'ãijã jãsenk'awia pãach di haig haumʌn magan pãrau mʌchchata k'ĩir jãsenk'abarmjö habarmgui hajim, marag hiek'amamua. ");
INSERT INTO noaH_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mag warag hiek'ak'agmamua magjim: ’Hãbmua k'ãijã mʌ chaai mʌg mʌ hiek hʌ̈k'a k'ërʌmta pekau hee burrpimʌn, Hẽwandam dʌ̈i hiekk'õr pöomata sĩsiju. Mag mʌ chaai hãbam gaaimua k'ãijã warag Hẽwandam dʌ̈ita hiekk'õr paarpaju k'ãai, hichdëupai hich hö gaai mokpör pöm jʌ̃naa p'ũas hee baudʌk'iin hʌ̈ucha hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mʌg jẽb gaai hichiita hich jãg hõor dich k'apeen pekau waupiejem k'ʌʌn paraa haju. ¡Mamʌ hëh, hapk'iitʌ, chi mag dich k'apeendam pekau hee burrpiejem k'ʌʌn! ");
INSERT INTO noaH_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Magua, mua pãragjã mag chirʌm: Pãach juau wa pãach bʌ̈ʌu k'ãijã pekau hee burrpiju sim k'ai, warag t'ʌapnaa barbapʌ̈it hajim. Pãach t'um monak'a hok'oowi hõtdau hich mag t'õojã k'augba sĩerrʌm hee maju k'ãai, hʌ̈ucha simgui hajim, sĩi jua bisi wa bʌ̈ k'ãijã bisi hʌ̃gt'ar höbërju. ");
INSERT INTO noaH_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Wa pãach daúapai k'ãijã pekau hee burrpiju sim k'ai, hag dau jẽunaa warag barbapʌ̈it hajim. Dau numwe wajap'a simta k'ĩmie durr maju k'ãai, hʌ̈ucha simgui hajim, dau hãbpaim dʌ̈ipai hʌ̃gt'ar höbërju. Wajapcharan magʌm pekau waumaaugau, dau chuk'umjö hoobamjönaa magʌm nem k'aigbam wawaagjã jua chuk'umjö habat hajim, bʌ̃ʌrjã wauba. Magju k'ãai Hẽwandam dau na pãach morta sʌrk'abat ha jaaumajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mag jajawagmamua hĩchab, ’Mʌg daumeraa k'it'ëem k'ʌʌn hoob hãb k'ãijã hisegmiet hajim. Ham t'ʌa mʌ Haai haar t'ʌnʌm k'ʌʌnaun hamag dau par k'aba t'ʌnʌmgui hajim.  ");
INSERT INTO noaH_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","’Mʌch chi Hemk'ooi Hiewaan chadcha hõor hamach k'aibag gaaimua hok'oo k'it'ëem k'ʌʌn peerdʌ hawaanta bëejim ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Magnaa, Mua pãrag jëeu hook'imgui hajim, jãga sim k'ai pãrag: Woun hãbmua cien ovejas wai sim. Mag k'apan t'ʌnʌm heem hãb hok'oobaadee, ¿hirua tagam k'ʌʌn hãbam haig p'ëpʌawia mag chi hok'oo k'ërʌmta jʌraan mabaju k'ai? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mag jʌr nʌrrʌʌ hawi baau hat'ak'iin, mag hãbpai hok'ootarr baau hat'am paarta hʌ̃rcha hi honee hajugui hajim, tagam k'ʌʌn k'apan hok'ooba narr paar honee haju k'ãaijã. ");
INSERT INTO noaH_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hich jãg hãbmuajã hich nemchaain hok'oopimap'a haajemjö, hĩchab mʌ Haai hʌ̃gt'ar simuajã mʌg mʌ hiek hʌ̈k'a durrum k'ʌʌn chan hãbjã hok'oopimap'a simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mag nem k'ĩir pogk'e jajawagmamua, ’Pãrag k'ap hamk'ĩir jaauk'imgui hajim Jesuu. Pãachjö mʌ hiek hʌ̈k'a simua pãach hee hiwiir hãbam dʌ̈i k'ãijã k'aigba habaawai hi dʌ̈i hiyʌ̈ʌmamua wajap'a hirig jaaubat hajim, jãga sĩ mag k'aigba haawai. Pãachdëu mag hiek'abaawai hʌ̈u hũrwia hʌ̈k'amʌn magan pãrau pãach k'apeer mʌ hat'ee gan hat'am hajim. ");
INSERT INTO noaH_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mamʌ par pãachdëu hiek'a nʌmjã hũrbamʌn magan pãach daumaai hõor numí k'ãijã t'ʌ̃rk'a hat'at, maagwai hiek'amamjã hõor numí wa t'ãrjup nʌm dak'ĩirta mag hiek'amamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mag numí wa t'ãrjup nʌm dak'ĩir hiek'amamta bʌ̃ʌrjã hasekasbamʌn magan warre t'um chi hʌ̈k'a nʌm k'ʌʌn jʌ̃gdaarta hiek'aju haai nʌmgui hajim. Mag t'umaam k'ʌʌn dak'ĩir hiek'abarmjã hasekasba habaawain chadau, Hẽwandam hiek hʌ̈k'aba haajemjö wa Romaam gobierno dën dëbpaar jëeujem k'ʌʌn chi k'aigbam k'ʌʌn dʌ̈ímjö habat hajim ham dʌ̈i, tag pãach dʌ̈i k'apeerk'apiba. ");
INSERT INTO noaH_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Mag mʌig heegar haawai hamach jʌ̃g t'eeg gaaimua pãachdëu nem jaau nʌm hũrba haawai mag pãach dʌ̈i k'apeerk'apiba habarmjã hich Hẽwandamau hĩchab pãar higar sĩeju. Maimua deeu hich k'aibag hisegwi hũwaai pãach hee pãach k'apeerk'api haauwaijã hĩchab Hẽwandamau pãar higar sĩejugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mag hiek'amamua, ’Mua pãrag mag chirʌmgui hajim: Mʌig heegar hõor numí hamachdëu nem hig nʌm mʌrʌg jëwaag hãba hibëpwia jëeumʌn, mʌ Haai hʌ̃gt'ar chirʌmua hamag deeb k'aba deeju. ");
INSERT INTO noaH_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mag jëwaagta numí wa t'ãrjup k'ãijã hãba biirdʌnaa mʌrʌg jëeu nʌmʌn mʌʌn maig chirʌmgui hajim, ham jãrr. ");
INSERT INTO noaH_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Magbaawai Pedroou Jesuug, —Señor, magan mʌchjö pʌ hiek hʌ̈k'a nʌm k'ʌʌnau hãbmua k'ãijã mʌ dʌ̈i k'aigba haawai, ¿biek k'arr mua perdonaajuma? ha jëeujim. ¿Siete veces? ");
INSERT INTO noaH_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Magbaa Jesuu hirig, —Mag siete vecespai k'abam. Muan pʌrʌgan, setenta veces sieteta perdonaaju haai sim ha chirʌm hajim. Hajapcharan dich dʌ̈i k'aigba habarmpierrma. ");
INSERT INTO noaH_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Maimua hich Jesuupai magjim: —Mua mag pãraujã pãach k'apeen perdonaaju haai nʌm ha chirʌmʌn, Hẽwandamaujã maach perdonaabam haba haajeewaita mag jaau chirʌm hajim. Hẽwandaman rey hãb sĩerrau hich chognaan hich garcharam k'ʌʌn wajap'a p'idk'a nʌm k'ap haag hãhãbdö t'ʌ̃rk'anaa k'ap jëeu hoomatarrjöta sĩerrʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ya chi reíu t'ʌ̃rk'ʌʌibaadëm hee hi haig haibëejierram haajem, hãb hirig p'atk'on pöm diez mil talentos paar sĩerr. ");
INSERT INTO noaH_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mag dëbpaar pöm sim pöd hichig p'ag hauba habaawai chi reíu mag woun hichig dëbpaar paar sĩerrta warag hich hʌʌi dʌ̈i hich chaain maimua hich nem wai sĩerrpa t'um përpʌ̈ipi jaaujim hanaabá, jũrr deeum chogk'amk'ĩir, magbarmua chi dëbpaar p'ag höbërmk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Magbaawai chi chogau chi rey bʌ̈k'ʌrr p'õbk'anaa chaigpa jöchk'ërʌmua, “Señor, hidëu hoo hat'á. Mua hök'ar p'agmamua pʌ dëbpaar t'um höbeerpʌ̈ibajupa” haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pari mag hichig chaigpa jöchk'ërʌm hoobaawai, chi reíu hi dau haug k'augwi, mag dëbpaar pöm sĩerrjã tag hichig p'agpiba, sĩi warag k'ĩir hok'oopi jaaunaa, p'ãarju harrjã p'ãarba, sĩi hʌ̈u mapijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Pari mag hich pʌ̈ibapäaiwai, maigmua higbaadeeu, deeum hagjö chi rey chogk'a sim dʌ̈i t'ẽujim haajem. Magua jũrr hichig cien denarios paraa sĩerr haawai, pʌrnaa hö t'at'aik'amuata, “Jöpk'aa pʌchdëu mʌrʌg paar sim p'agbá” hajim hanaabá hirig. ");
INSERT INTO noaH_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pari magbaawai hichdëu reíg hatarrjö warmuajã hi bʌ̈k'ʌrr p'õbk'anaa chaigpa k'itʌmua, “Pua k'õs hak'iin, hidëu hoo hat'á hak'am; hök'ar p'agmamua mua pʌ dëbpaardam t'um p'agpʌ̈ibajupa” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pari chi dëbpaar jëeu sĩerr garmua mag k'õchk'aba, sĩi warag hich k'apeer dau haugjã k'augba cárcel deg pʌ̈iwia, hãbmiecharam centaaudam p'agbam haigjã höbeerpiba jaaujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mag hirua hich k'apeer dʌ̈i magtarr hoowi, warm k'ʌʌn hagjö chi rey chogk'a t'ʌnarr k'ʌʌnau hoowai, ham gaai masi hajim haajem. Mag gaai masi nʌm hiek'au chi reígcha magtarr t'umaa wajap'a hũrpipʌ̈ijierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mag hichig jaaubaa chi reíu t'ʌ̃rpʌ̈iwia hirig magjim hanʌm: “Wounta chadcha k'aigba chitʌmá” hajim hanʌm. “Maachig dau hap'ʌʌ chaigpabaadeewai, mua pʌ perdonaawi chi dëbpaarjã tag mʌchig p'agpiba hich jãg k'ĩir hok'oopijim. ");
INSERT INTO noaH_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Magtarr haawai puajã hagjö pʌch k'apeer dau haug k'augwi hi perdonaaju haai sĩejimgui” hajim hanʌm. “Pari pua bʌ̃ʌrjã hi dʌ̈i magbajimgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mag, warag chi rey meeuk'abaadëwi mag dëbpaar sĩi k'ĩir hok'oopiju hatarrta deeu heeupemjö t'umaa p'agpi jaaujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mag nem hĩgk'aadam jaauwi deeu hich Jesuupai magjim: ’Mʌ cha hiek'a chirʌm hiek'au pãrauta pãach k'apeendam chadcha perdonaawi tag magʌm hiekjã higba hich mag k'ĩir hok'oobam chan, mʌ Haai hʌ̃gt'ar chirʌmuajã hich hagjö pãar perdonaabamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mag marag nem jaau sĩi hawi, Galileamua mawia jũrr Judea sĩeimajim, Jordán higaau t'oogar dʌrba hedau höbeerjem bi gar. ");
INSERT INTO noaH_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mag hi petamjã hõrau k'augpʌ̈itarr haawai hõor pöoma hi hẽudee wëtjim. Mag hõor pöm t'ʌnʌm hee haaunaan k'apan t'ʌnarr haawai magʌm k'ʌʌnpa monaaupʌ̈i maajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mag nʌm hee fariseonaan heem k'ʌʌn hich Jesús haigcha bëewi juau hogt'om hirig, —¿Pua hoowai sĩi nem bʌ̃ʌr habarm gaaimua maadëu dich hʌʌi pʌaju haai nʌ? haichëjierram. ");
INSERT INTO noaH_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Magbaawai Jesuu hamag magjim: —Hẽwandam hiek p'ã sim gaai t'ʌ̃ʌrwai, ¿pãrau hooba haajẽ, warrcha chi hompaatarr Jöoiraujã hemk'ooi hʌʌi dʌ̈ita hompaajim ha sim? ");
INSERT INTO noaH_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Magtarr haawaita hemk'ooi hich hʌʌi dʌ̈i pabaadëmʌn hich dënnaan k'a hogdʌajem, ya hich hʌʌi dʌ̈ita hãba nʌrraag. Ya magbarm haigmua warran hagdaujö hamach happai naajerrta, hõor hãbpaimjö hich mag nʌisiejemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mag nʌisim chan ya tag hamach hãhãbdö nʌrrjëe haba, hõor hãbpaimjö nʌisijugui hajim. Mag warrgarwejã hich Hẽwandamauta mag papitarr haawai pöd hiwiir hãbmuajã hi hichaaur hawi dich hõor pʌaju k'aba nʌmgui hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Magbaawai jũrr hamach garmua hirig, —Pari pua mag simta, ¿k'an jãgwi Moiseeu jaauwai dich hʌʌi pʌagpaawai hẽsap gaai “Mua ya pʌ pʌa chirʌm” ha p'ãnaa hirig deeju haai sim ha simma? hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Magbaawaita Jesuu hamag, —Pari jã, nem jaauwaijã pãach jʌ̃g t'eeg sĩerrjëem gaaimua k'abahab hajim. Moiseeun chadcha hʌdʌraa hʌʌin pʌapiejeejim, pari warrcha hich Jöoirau hompaawai chan mag pʌamk'ĩir k'abata hompaajimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pãadë mʌ hiek hũrbat: Hʌʌi bʌ̃ʌrjã deeum dʌ̈i pʌrpʌr k'aba simta sĩi pʌam k'õchgaupai pʌawia deeum hʌʌi hau simʌn maan pekauta wau simgui hajim. Mag hich hap sim hawi chik'amnau pʌatarr hʌʌita hau sim wounjã pekauta wau sim, hagt'a chik'am hʌʌik'a simta hau sĩewai hajim jũrr hamag. ");
INSERT INTO noaH_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Magbaawaita maach heem k'ʌʌnaupai hãaur k'ʌʌnau jũrr, —Maach hemk'ooin dich hʌʌi dʌ̈i magta haju haai nʌm k'ai, magan warag hʌʌi haubajuuta simgui hajierram. ");
INSERT INTO noaH_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Magbaa jũrr hich Jesuu marag, —T'umaam k'ʌʌnau chan cha mua jaau chirʌm hiek pöd k'augbam; hãba hich Hẽwandamau k'augpi sim k'ʌʌnaupaita k'ap hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maimua, Pãrag jaauk'imgui hajim, jãgwi mag t'umaam k'ʌʌn pöd hʌʌi hauju k'aba nʌ. Hãaur k'ʌʌn bi heeweta mag hʌʌin hawaag k'aba t'aaba nʌmgui hajim. Pogk'a ya chi jöoin pawiajã p'ãrr japʌ̈i nʌm, k'apes hapimaaugau. Maagwai pogk'a mag p'ãrr jaba nʌmta, pari hamachdëupai Hẽwandamau nem jaau sim wajapcha wawaag hawi, bʌ̃ʌrjã k'apes haba hich mag t'ʌnʌmgui hajim, hʌʌinjã k'ĩirjuba. Mag jaauwi hãbmiecha paawai hichdëupai magjim: ’Dichdëu hoowai hʌʌijã chuk'u chitaju hʌ̈u pödjöjöo sim k'ai, magan hich magta nʌrraju haai simgui hajim, hʌʌi chuk'u. ");
INSERT INTO noaH_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mag nʌm hee, jũrram k'ʌʌnau Jesús haig chaain haibëe t'ʌnaajim, ham gaai pʌrnaa Hẽwandamag ham kõit jëeumk'ĩir. Pari mag jũrram k'ʌʌnau chaain haibëbëek'am hoowi chi haibëe nʌm k'ʌʌnagta maachdëuta meeuk'a naajim, tag haibëepimaaugau. ");
INSERT INTO noaH_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mamʌ mag marau hiek'a nʌm hũrbaawai Jesuu jũrr maachigta, —Hidëu mʌ haig chaain haibëepibat. ¿K'ant'ee pãrau ham bëepimap'a nʌ? hajim. Chi jöoin hawiajã, chamʌ k'ʌʌn chaainjö mʌ hiek hʌ̈k'ak'arrsö hʌ̈k'a nʌm k'ʌʌnta mʌg jẽb gaaijã hʌ̈u wënʌrrawi hʌ̃gt'arjã honee wënʌrrabajup hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Magnaa warag ham pör hʌ̃r jua hausĩunaa, Hẽwandamag ham kõit jëeuwi, warag haigmua chawag maar p'ë harrjim. ");
INSERT INTO noaH_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Biek hãb woun hãb hẽwan sĩerrau Jesús haig bëewi hi dʌ̈i hiyʌ̈ʌmamua, —Maestro, ¿k'an nem wajap'amta mua wauju haai chirʌ́ hʌ̃gt'ar höbëraag? Mʌrʌg jaaubá hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Magbaawai Jesuu hirig, —¿K'ant'ee mag nem wajap'amta wawaag pua mʌrʌg jëeu chirʌ́? Nem wajap'amʌn hãba hãbpaita sim; ma Hẽwandamau. Mamʌ pʌ chadcha hʌ̃gt'ar höbërm k'õs chirʌm k'ai, Hẽwandamau hich hiek p'ãnaa Moiseeg deetarr gaai jaau sim hipierraa habá hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Magbaa, —Pari hag gaai jaau sim heem, ¿chijãg higwiata pua mag jaau sĩ? hajim, chi hẽwan mag hi dʌ̈i hiyʌ̈ʌ haan berrau. Magbaa Jesuu hirig magjim: —Hoob hõor t'õo chitam; hoob pʌch hõor k'abam dʌ̈ijã k'apes ha chitam; nem jĩgk'am; sëuk'ajã chik'am hëugar nem jaau chitam; ");
INSERT INTO noaH_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pʌch haaijã daupiinaa pʌch hãdjã daupii habá, maimua pʌch k'apeenjã wir haig pʌchdëu pʌch k'õsi simjö daupii habá hajim hich Jesús garmua. ");
INSERT INTO noaH_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Magbaawai chi hẽwanau, —Mua magʌm t'um hʌʌrk'a chitabahab. ¿K'ani mua wauju hagt'a waaur chirʌ́? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Magbaawai deeu hich Jesuupai hirig, —Pʌ chadchata wajapcha ham k'õsi chirʌm k'ai, pʌch nem përk'ʌʌipʌ̈inaa chi p'atk'on hap'ʌʌm k'ʌʌndamag jigbapʌ̈i hajim. Mag k'aita hʌ̃gt'ar pawiajã pʌ hich mag nem wajap'am paraa chitaju. Mag përk'ʌʌipʌ̈inaa jigpʌ̈iwi, mʌ dʌ̈i marrau hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pari hich mag woundam chadcha p'atk'on paraam harr haawai Jesuu hichig magbarm hũrwia warre hök'ĩirjuu petajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mag woundam hök'ĩirjuu petam hoobaawai jũrr maragta hich Jesuu, —P'atk'on paraam k'ʌʌnta Hẽwandam chi Pörk'a sim haar höbëraagan chadchata t'et'e simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","P'atk'onpanta hʌ̃gt'ar Hẽwandam chi Pörk'a sim haar höbërju k'ãyau, camello pöm jãg maach wounaan k'ãaijã hʌ̃rpai sĩerrʌmta p'it'urg chuk'u nobeeu kach hee t'oogar höbër dichjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mag hi hiek'abapʌ̈im hũrwia chadcha jʌ̃gderraa nʌmua maach hi dʌ̈i wënʌrraajerr k'ʌʌn heem hãaur k'ʌʌnau, —Mag k'ai, magan ¿k'aita peerdʌagáwa? hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pari magbaa hich Jesuu marag hoonaa, —Hõragan chadcha p'it'urgma mag hũurwai. Mamʌ Hẽwandamag chan bʌ̃ʌrjã p'it'urg chuk'u simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jesuu magbaawai mag chi hẽwan p'atk'on paraam dʌ̈i hiyʌ̈ʌ narr k'ĩirjuwia, —Maraun chad pʌ dʌ̈i wënʌrram k'õchgau maach nemdam wai narrjã k'ĩirjuba, sĩi t'umaa p'ëpʌawi pʌ dʌ̈i hogdʌba wënʌrrabma. Mʌg pʌch dʌ̈i hogdʌba wënʌrrʌm jũrr ¿k'andamta marau hau durrajuma mʌg hatag paawaijã? hajim Pedroou. ");
INSERT INTO noaH_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Magbaawai Jesuu magjim: —Cha mʌ hiek'a chirʌm hiek'au mʌg durr jöoi hedaujã dʌ̈i t'um chi hiiurig pawia mʌch chi Hemk'ooi Hiewaa hõor Pörk'aag k'u juupjem wajapp'a k'itʌm gaai hoo chirsim hed, pãar mʌg mʌ hogdʌba mʌ dʌ̈i wënʌrraajem k'ʌʌnta mʌ jup chirʌm bigaau pörk'au doce nʌm gaai hohood hajugui hajim. Pãachdëuta mʌ dʌ̈i pãach hipaarmua jöoi Jacob k'ararr chaain doce narr k'ʌʌn hag chaain hewagam k'ʌʌnagjã k'ap jajaau haju, jãgaju Hẽwandamau ham dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Maimua har t'um chi mʌ gaaimua wa mʌ hiek jaaum k'õchgau k'ãijã hamach di, hamach naamk'ʌʌn, hamach heeugpeen, hamach haai, hamach hãd, hamach chaain wa sĩi hamach jẽb k'ãijã k'augba pʌa nʌm k'ʌʌnagjã hamach nem hok'ootarr k'ãyaujã hʌ̃r hag hatcha deewi mʌch dʌ̈ita hich mag wënʌrramk'ĩir mʌch haarcha p'ë haujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pari mag hed hãaur k'ʌʌn har mʌig heegar haawai hamachta chik'am k'ãaijã hʌ̃rʌʌcha nʌm haajerr k'ʌʌnta hʌ̃gt'ar Hẽwandam haar paauk'aimaawaijã jũrr serbiibacha haajerrjöo nʌisijugui hajim. Maimua jũrr har mʌ gaaimua chik'amnau serbiibag p'eejerr k'ʌʌnta jũrr warm k'ʌʌn k'ãaijã hʌ̃rcha nʌisijugui ha hiek'amajim hich Jesuu, marag hũrmk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Mʌg hatag mʌch hiek hʌ̈k'a durrum k'ʌʌnag hamach p'it'ur hatarr jũrr mua nem deeju hedan, woun hãb uvadö papau hich piyonnaanag nemjõ p'ierrtarr jũrr p'agtarrjöta hajugui hajim. Mag wounau nacha piyón jẽraag hedp'erre hõor jʌraan majim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mag mawi, chi nacha hooimatarr k'ʌʌn dʌ̈i hiek'aawai, k'ãai hãb p'idk'abarm paar p'aagjemjö denario hãb p'agju hajim haajem. Mag hiek'awi p'idk'amk'ĩir pʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Maimua ya hedau hʌ̃gt'arraa las nuevejö haadëm hee, deeu hõor jʌraan mawia kaaijã hee sĩi hõor p'idagjã chuk'u par nʌm hooimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Magbaa mak'ʌʌnagjã, “Pãarjã hĩchab mʌ p'idag hee p'idk'abamit; mua pãrag pãach p'idk'abarmpierr p'agjugui” hajim hanʌm. Magbaa mak'ʌʌnjã hĩchab p'idk'aan wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Maimua hedausĩe haadee, hich chi mork'ʌ jöoiraupai deeu hũwaai hõor jʌraan mawi, k'eeuragjã las tresjönaa deeu hichpai majim haajem. Maimua mak'ʌʌn dʌ̈ijã hiek'awi hich hagjö p'idk'aan pʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Maimua ya k'eeuraacha las cincojö haadëm hee, deeu hũwaai nacha hichdëu hõor hooimatarr haar majim haajem. Maimua hooimaawai sĩi hõor p'idagjã chukk'u haig naajim haajem. Magbaawai hamag, “¿K'ani jãg k'ëumaamta jãg sĩi p'idk'ajã p'idk'aba, parta k'ëudʌtk'amaama?” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Magbaa hamachdëu, “Marag ni hãbmuajã p'idag jaauba haawaita mʌg maar par naabahab” hajierram hanʌm. Magbaa jöoirau mak'ʌʌnagjã, “Magan mʌ nemjĩir hee uva p'ierrbamit” hajim hanʌm, “k'ëu nʌm hora.” ");
INSERT INTO noaH_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Maimua ya hedau k'ëubaadee chi uva papau hich chog mag hõor p'idag hee wai jẽer sĩerragta jũrr, “Jãimua p'idk'a narr k'ʌʌn t'ʌ̃rk'a haunaa hamag p'agk'abá hajim hanʌm. Hẽudeecha dubtarr k'ʌʌnagta nacha p'agnaa maimua nacha dubtarr k'ʌʌnagta jũrr hẽudeecha p'agbá” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mag, chadcha hẽudeecha k'eeuraa las cincojö dubtarr k'ʌʌnta nacha t'ʌ̃rk'a hauwi k'ãai hãb p'idk'a k'ëutarr k'ʌʌnagamjö denario hãhãbdö p'agk'amajim hanaabá, hagdaujö. ");
INSERT INTO noaH_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Maimuata jũrr nacha dubtarr k'ʌʌn t'ʌ̃rk'a haujim haajem. Ya mag hamach t'ʌ̃rk'ʌʌibaadee, warm k'ʌʌnag mag denario hãb deematarr haawai, hamaun jũrr hamachigta hʌ̃r p'agjupii naajima, hamachta hedp'erre dubtarr haawai. Pari magba hamagjã hẽudeecha dubtarr k'ʌʌnag p'agtarrjöpai p'agk'ajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mamʌ hamachig magpai p'agbaawai k'ĩujã hãwatba, chi mork'ʌʌgchata jũrr hãbmua, ");
INSERT INTO noaH_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Jãk'ʌʌn ya maar höbëraagpam heeta bardʌtk'achëtarr haawai hora hãbpaita p'idk'ajierram. Magtarrta maar hed durr pöm p'idk'a k'ëuwi hed pechagjã jemer k'ëudʌtk'amaam k'ʌʌn dʌ̈i hãbata pua hamag p'agbarbma, jũrr hamag herraapai p'agju haai simta” hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pari magbaawai chi p'idag k'ʌ jöoirau jũrr ham heem hãbak'aíg, “Kakë pari warr maach hiek'aawaijã, ¿denario hãbpaita pʌrʌg p'agju habajĩ, pʌ p'idk'abarm paar? Magtarr haawai mua pʌ k'ũgurba chirʌm perá” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Pʌch p'atk'ondam hauwia petá” hajim hanʌm. “Pari mua hichiita k'eeuraacha dubtarragjã pʌrʌg p'agtarrjö p'agam k'õsi chirʌmgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“Mʌch p'atk'on haawai mʌchdëu p'agam haig p'agju haai chirʌmgui” hajim hanʌm, “pöm p'idk'aba harr k'ʌʌnag hawiajã. ¿Wa sĩita pua mʌrʌg hõor dʌ̈i hö wajap'a hapimap'ata chirʌ́wa?” hajim hanʌm chi p'idag k'ʌ jöoirau. ");
INSERT INTO noaH_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mag nem hĩgk'aadam jaauwi hich Jesuupai, ’Hich jãgta hajugui hajim hĩchab mʌg hatagjã. Hẽudeecha p'idag hee dubtarr k'ʌʌnagta nacha dubtarr k'ʌʌnag p'agtarrjö, hẽudeecha mʌch hiek hʌ̈k'atarr k'ʌʌnagjã nacha hʌ̈k'atarr k'ʌʌnagamjö hagdaujö nem deemaju. Maiguin Hẽwandam hat'ee pöm nem wauba harr k'ʌʌnagjã warm k'ʌʌnagamjö p'agmajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Maimua mag Jerusalenag mam harr haawai ya k'ʌd hee paauk'abaadee, hich Jesuu maar maach hap t'ʌ̃rk'a hauwi marag jaaumamua magjim: ");
INSERT INTO noaH_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Pãrau hoo nʌmgui hajim, maach Jerusalenag wëtum. Mamʌ nau maach barbaimaawai mʌch chi Hemk'ooi Hiewaa mʌg chirʌmʌn t'et'emnaanag mʌ pʌr deeju. Magbaawai mak'ʌʌnau mʌ t'õopi jaauwi ");
INSERT INTO noaH_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jũrr maach meeun k'abam k'ʌʌn jua hee mʌ t'ʌsĩepʌ̈ijugui hajim. Magbaawai mak'ʌʌnau mʌ wau hiek'anaa mʌ gaai mas waunaa pakuls gaai mʌ meerp'ëpʌ̈ijugui hajim. Pari hamau mag mʌ wau t'õowiajã k'ãai t'ãrjup nʌm hee deeu mʌ hiiu p'iidʌju ha jaaumajim maachigcha. ");
INSERT INTO noaH_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Maimua hi hiek'a höbaadëm hee, jöoi Zebedeo hũan hich chaain dʌ̈i bëewi nem hinag jëwaagpamjö Jesús k'ĩirp'ee p'õbk'a t'ʌnaaichëjim. ");
INSERT INTO noaH_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Magbaawai Jesuu hirig, —¿K'andamta hig hʌ? hajim. Magbaa hich hũanau, —Señor, magan ya pʌchta t'umaam k'ʌʌn Pörk'abaadeewai mʌ chaain mʌk'ʌʌn numiita pʌch bigaau juppibá hajim, pʌch dʌ̈i hiek t'eeg hamk'ĩir: hãb pʌch juachaar gar, maagwai hãb pʌch juawë gar, Santiago Juan dʌ̈i higwi. ");
INSERT INTO noaH_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Magbaawai Jesuu warre chi chaainagta, —Pãrau chan pãachdëu jëeu nʌmjã k'augbata nʌmgui hajim. ¿Pãrau k'ĩirjuawai mag pãachta warm k'ʌʌn k'ãai hʌ̃rpai haag chik'amnau pãach dau haug wau nʌmjã mʌ dënjö hãwatju haai nʌ? hajim hamag. Magbaawai hamachdëu, —Hëera, marau hãwatbajup hajierram. ");
INSERT INTO noaH_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Magbaa deeu Jesuu hichdëupai hamag, —Chadcha pãrau hõrau pãach dau hap'ʌʌ wau nʌm hãwatma hajim. Pari mag mʌch juachaar gar wa juawë gar k'ãijã mʌch dʌ̈i hãba juppiju chan mua pöd jaauju k'aba chirʌmgui hajim, ya jãig paawain mʌ Hayauta hichdëu k'ap jaauju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Maach tagam k'ʌʌn hagjö hich Jesús dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnau hũurwai, mag warm k'ʌʌnau hi bigaau jupimaag k'ãidu jëeu nʌm hũrbaawai, chadcha ham dʌ̈i maar t'ãar hee k'aba naajim. ");
INSERT INTO noaH_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pari magbaa deeu hũwaai maach happai k'ĩet t'ʌ̃rk'anaa marag magjim, hich Jesuu: —Pãrau k'ap'ʌ nʌm, mʌig heegar har hamachta chi pörk'a nʌm k'ʌʌnan hamachta chi pörnaan haawai hiek t'eeg nʌm hawi hamach k'ãai jua heegpaim k'ʌʌn dʌ̈i hat'uu haajerram. ");
INSERT INTO noaH_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pari jũrr pãrau ham dënjö magju k'aba nʌmgui hajim pãach heepai. Magju k'ãai hãbmua k'ãijã pãach heepai hichta t'umaam k'ʌʌn k'ãaijã hʌ̃rʌʌ ham k'õsi sim k'ai, magan jũrr hich garmuata hich k'apeenau nem mag habaawaijã ham hipierr nʌnʌʌu haju haai simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Maagwai har hichta hʌ̃gt'ar pawiajã Hẽwandamau hich garcha juppi hahau hapim k'õsi sim k'ai, magan hichta sĩi parhoobam k'ʌʌn chogk'aju haai sim hajim. ");
INSERT INTO noaH_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mʌ pãar k'ãai Hemk'ooi Hiewaak'a chirʌmjã mag sĩi mʌch garmua chik'am chogaagjã bëebajim. Mʌ bëetarran sĩi chik'amnag mʌch chogamk'ĩirta bëejimgui hajim, mag chitʌmua chik'am jua machgau t'õowi mag t'õobarm gaaimua hõor pöm sĩi hamach pekau hee preso sĩsidʌmjö nʌm k'ʌʌn höbeerk'apäain. ");
INSERT INTO noaH_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mag wëtumua Jericó p'öbör hee naaimawi, deeu hërëu p'öbaadeeu, hõor pöoma Jesús hẽudee wëtjim. ");
INSERT INTO noaH_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mag hõor pöm wëtum k'ʌd bigaau dau k'ĩsu k'it'ëem numí hohoodö durrajim. Mag durrumua Jesús dichmam k'aug hat'aawai hähäak'amua, —Señor, pʌʌta rey David k'ararr hag chaain hewagam k'ʌʌn Hiewaau marau nʌ narr. Maar hapdurrum maar dau haug k'augbahur hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mamʌ mag ham hähäak'am hũrwia haig dich wëtum k'ʌʌnau hamag meeurrarrau haajeejim, k'ĩupamk'ĩir. Pari magʌmjã waragta Jesuug huhuuk'amua, —Señor, jöoi David k'ararr Hiewaa, maar hapdurrum maar dau haug k'augbahur haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Magbaawai Jesuu dʌnʌisiwi mag chi dau k'augba k'it'ëe harr k'ʌʌn t'ʌ̃rk'anaa, —¿K'ani pãrau mʌrʌg pãach dʌ̈i hapim k'õsi nʌ? hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Magbaawai hamachdëu, —Señor, maraun pʌrʌg maach dauta daujã wajaug paapim k'õsi nʌmgui hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Magbaa chadcha Jesuu ham dau haug k'augwi, ham dauhëu haait'ʌ haait'ʌ habaawai, warre daujã wajaug sĩi bi heewe hich magta t'aabatarrjö nʌisijim. Mag hamach dau monaaubapäaiwai warag hi dʌ̈i hërëubaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mag wëtumua ya Jerusalén dak'a Olivo durrsĩ gaai deeum p'öbördam Betfagé hanʌm paauk'abaimaawai hich Jesuu maach hich dʌ̈i wënʌrraajerr k'ʌʌn heem numí t'ʌ̃rnaa hamag, ");
INSERT INTO noaH_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Cha maach k'ĩirp'ee p'öbördam sim hee hërëubaadët hajim. Nau pãrau burro chi hʌʌidam pabʌ̈ gaai jʌ̃ sim hooimajugui hajim. Hag bigaau hĩchab chi chaaidamjã sĩeju. Mag pãachdëu hoobaimam hẽerwi haipidut hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mag pãachdëu hẽer waidurum hoowi hãbmua k'ãijã pãachig hiek'aawai hirig, mua hig chiraawaita harrum, mamʌ deeu jöpcha deepʌ̈iju habat ha jaaujim, chi mag hichdëu pʌ̈i sim k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pari mag burrodam hawaan mamk'ĩir hich k'apeen pʌ̈itarran, Hẽwandam hi jaaumie Zacarías k'ararrau p'ã pʌatarr heyaa höbërmk'ĩirta magjim. Mag hirua p'ãtarr gaai mag sim: ");
INSERT INTO noaH_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalenpienag jaaubat: ‘Pãrau warrgarwe nʌajerr Reita sĩi parhoobam k'ʌʌnjö k'ĩir machag chuk'u burrodam hagt'a chi jöoicha k'aba k'itʌm gaaita ya pãar haig hurum’ ” ha p'ã sim. ");
INSERT INTO noaH_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mag hamach chogbapäaiwai chadcha hërëubaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mag wëtwi hooimaawai, chadcha hich Jesuu jaautarrjö chi burro hʌʌidam hich chaai dʌ̈i hooimajierram hanaabá. Maimua hẽer hauwi, harrwi, ya hich Jesús sim haar pabaimaawai, hamach k'ajũa hẽerk'anaa chi burrodam p'õ gar t'eerk'abapäaiwai hag gaai Jesús waaidʌbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Maagwai hõor pöm t'ʌnarr haawai, hãaur k'ʌʌnau hi maju hee hamach k'ajũa hẽernaa t'eerk'amaawai, hãaur k'ʌʌnau jũrr papiujöm t'ʌrrpnaa t'eerk'amajim. ");
INSERT INTO noaH_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Maagwain na wëtum k'ʌʌnaujã serereu k'aawai hẽudee wëdurum k'ʌʌnaujã serereuk'amua, “Hʌ̈ucha habarm Hẽwandam. Rey David k'ararr hag hiewaajöm chan chuk'uk'um” haajeejim. “Hẽwandam, hich mʌʌta pʌchdëu pʌch jũrr pʌ̈ibarmʌu. Mʌg Rey pʌ̈ibarm gaaimua hʌ̃gt'arm magwe honee haju haai nʌm” haajeejim jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mamagag wëtumua ya Jerusalén hee Jesús dubbaimaawai sĩi p'öbör hee hõor t'umta p'ogdʌbaadëmjö hajim. Magp'öbaadëmʌn jũrram k'ʌʌnau hamach heepai, —Keena, jãan ¿chijãg wounta jãg hurúma? haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Magbaawai mag hi dʌ̈i hõor pöm wënʌrrʌm k'ʌʌnau, —Hẽwandam hi jaaumie Jesús k'abahab haajeejim, Galilea durr Nazaret p'öbör hee bãautarr. ");
INSERT INTO noaH_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mag barwia Haai hi jëeujem deg hooimaawaijãh, sĩi merrkau heemjö t'ʌnʌmta hooimajim. Magbaa mag hag hee Hẽwandamag ofrendak'a deeg nem për nʌm k'ʌʌn dawag jʌrk'ʌʌipʌ̈inaa, p'atk'on cambienaa dubur për nʌm k'ʌʌn mesjã jẽk'ʌt sĩepʌ̈imajim. ");
INSERT INTO noaH_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Magnaa hamag, —Hẽwandamau hich higwia hich hiek p'ã sim gaai “Mʌ diin sĩi mʌrʌg jëeujem diiu” ha simta, pãachdëuta hag hee mʌg nem parhẽpag për nʌmua sĩi chik'am k'ũguurjem dik'a wai naabma hajim. ");
INSERT INTO noaH_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mag hõor dawag jʌrk'ʌʌipʌ̈iwi, hichta hag hee sĩsiewai, dau k'augba k'it'ëem k'ʌʌn dʌ̈i bʌ̈ wëdʌ wëdʌ k'it'ëem k'ʌʌnpa hich haig bëemam Jesuu monaaupʌ̈i maajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mamʌ mag hirua hõor monaaupʌ̈pʌ̈ik'am p'adnaan chi pörk'a nʌm k'ʌʌnau Moiseeu ley p'ã pʌarr jawaag chi machnaan dʌ̈imua hamach daúacha mag hirua hõor monaau sim hoo nʌm dʌ̈i, chaainaupa hi t'ö hiek'a nʌm hiek'au “Rey David k'ararr hag Hiewaajöm chan chuk'uk'umk'am” hũrbaawai, ");
INSERT INTO noaH_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","meeuk'a nʌm hiek'au k'ĩir mor chigpai chi Jesuugta, —¿Mag serereuk'am k'ʌʌnau hiek'a nʌm pua hũr chirʌ́? hajierram hirig. Magbaa hichdëu, —Muak'a hũr chirʌmgui hajim. Pari pãrau Hẽwandam hiek p'ã sim gaai t'ʌ̃ʌrwai hooba haajeeb, hamau mag serereu haju higwi David k'ararrau, “Chaain daumeraam k'ʌʌn dʌ̈i hagt'a jũd dö k'it'ëem k'ʌʌndamaupa hirig jëeujem” ha p'ã pʌatarr. Ma chan pãrau bʌ̃ʌrjã k'ĩir hee paba naabma hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Magnaa warag hichta haigmua mawia jũrr hag dak'a p'öbördam Betania hanʌmʌg petajim. Mag mawia hich mam warag k'ãi hëejim. ");
INSERT INTO noaH_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mag mam k'ãi hëewi deeu hedp'erre Jerusalenag hurumua Jesús hiek hi jãsöo haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mag hi jãsog t'ʌnʌm hee, k'ʌd bigaau higo bʌ̈ dʌnʌm hoo hat'aawai hag gaai chi jõ simpii hawi haar hoon majim. Mamʌ hoon maawai sĩi bʌ̈ parii dʌnaajim. Mag hag gaai hooba habaa pabʌ̈ʌgta wounagamjö, —Pʌ jãg sim k'ai, jãgan mʌg hatagjã hich jãg chëba sĩerrajugui hajim. Pari hirua mag hiek'abaawai chi higo bʌ̈ warre p'uabaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Maachdëu mag hoobaawai dauderraa nʌm hiek'au marau hirig jëeu naajim, jãga jãg warre dëgölpta jãg p'uabaadë. ");
INSERT INTO noaH_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Magbaa hichdëu marag magjim: —Pãrau pãachdëu Hẽwandamag jëeuwaijã pãachdëu jëeubarmjö haju k'ĩirjunaata jëeuk'iin, mua mʌg pabʌ̈ p'uapibarmjöpaijã k'aba, hag k'ãai p'it'urcharam nemjã wauju. Jãgk'iin pãrau mʌg Olivo durrsĩigjã, “Mʌigmua mawia jũrr p'ũas hee hierrpabaad” hak'iinjã, chadcha pãachdëu hiek'abarmjö hajugui hajim, pãar hipierr. ");
INSERT INTO noaH_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mag pãachdëu jëeubarmjö haju k'ap'ʌnaata pãach nem jëeuwaijã jëeumʌn, pãachdëu jëeubarm nem pãrau paarpaju ha jaaujim marag. ");
INSERT INTO noaH_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Maimua bëewi deeu Jesús Haai hi jëeujem deg dubchëjim. Hi maig hõrag Hẽwandam hiek jaau sim hee, p'adnaan chi pörk'a nʌm k'ʌʌn dʌ̈i judionaan Asamblea heem chi pörnaan hi haig bëewi hirig jëeuchëjierram: —¿K'ai t'öwiata jãg mʌig nem për narr k'ʌʌn pua dawag jʌr wërppʌ̈ijĩ? ¿K'aíuta jãg pʌrʌg pʌchta nem hiek t'eeg hapijĩ? Marag jaaubá hajierram. ");
INSERT INTO noaH_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Magbaawai jũrr Jesuu hamag, —Magan nacha mʌrʌg jaaubat, muajã hĩchab pãrag jëeu hook'imgui hajim: Mua jëeubarm pãrau mʌrʌg jaaumʌn, magan muajã pãrag jaaujugui hajim, cha pãachdëu mʌrʌg jëeu nʌm. Magnaa chadcha hamag, ");
INSERT INTO noaH_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Pãrau hoowai, ¿k'aíuta Juan pʌ̈ijĩ hajim, jãg hamach k'aibag Hẽwandamag chugpaapi jaaunaa hõorjã pör choo nʌrramk'ĩir? ¿Hẽwandamau hajĩ, wa sĩi mʌg jẽb gayam k'ʌʌnau chogpʌ̈iwiata jãg nʌrrajĩwa? hajim. Magbaa hamach happai hiyʌ̈ʌ nʌmua, —Maadëu hirig, “Hẽwandamauta pʌ̈ijim” hak'iin, magan jũrr hirua maachig, “¿Jãg magʌmta pãrau hirua jaau nʌrrarr hiek hʌ̈k'abajierráma?” haju. ");
INSERT INTO noaH_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pöd maadëu, “Hõrauta pʌ̈ijim” hajujã k'abamgui hajierram. Maadëu magk'iin t'umaam k'ʌʌnau hi higwia “Jãan chadcha hich Hẽwandam hi jaaumieta jãg nʌrrajim” haajeewai, heeu dëgölp hõrau maach mokou bar t'õoduk'amgui hajierram. ");
INSERT INTO noaH_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mag warag hirig jaaujujã k'augba haawai, —Marau pöd jaauju k'augbamgui hajierram. Magbaawaita hichdëu hamag, —Mua pãrag nem jëeutarr pãrau mʌrʌg jaauba haawai muajã pãrag jaaubamgui hajim, k'ai t'öwiata mua jãg nem wau chitʌ́. ");
INSERT INTO noaH_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mag hichig jaauba habaawai mʌg nem hĩgk'aadam jaaujim: —Woun hãb chaain numí wai sĩejim haajem. Biek hãb chi jöoirag, “Hiewaa, hĩs mʌ uvadö hee p'idk'abamí” hajim hanʌm chi hayau. ");
INSERT INTO noaH_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Magbaa chi hiewaau, “Mʌ mamap'a chirʌmgui” hajim haajem. Maimua k'ĩirju sĩi hawiata, “Magan mʌ majugui” hawia majim haajem, p'idk'aan. ");
INSERT INTO noaH_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Maimua jũrr hich hiewaa chi hẽudeemʌgjã hich hagjö p'idk'aan mamk'ĩir jaaujim haajem. Magbaawai maguan chadau k'õchag, “Magan mʌ p'idk'aan majugui” hajim hanʌm. Pari mag maju hatarrta chadcha mabajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mag nem hĩgk'aadam jaauwia, haig hũr narr k'ʌʌnag jũrr, —¿Chijãgua pãrau hoowai hich hayau k'õsi sĩerrjö hi hipierraa hajĩ? ha jëeujim hich Jesuu. Magbaa, —Chi hiewaa chi jöoirau hajierram, chi cuento hũr narr k'ʌʌnau. Magbaa deeu hich Jesuupai hiek'ak'agmamua, —Roma durram gobierno hat'ee dëbpaar jëeujem k'ʌʌn chi k'aigbam k'ʌʌnta hʌʌin hamach durpa t'eegau parhooba sĩerrjëem k'ʌʌn dʌ̈i pãar k'ãai hʌ̃gt'archa höbërjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","¿Jãgwi mag chirʌ́? Juan chi hõor pör choomieu, jãga Hẽwandam dau na wënʌrraju haai nʌ ha jaaumam hũrwi pãrau hʌ̈k'abam daar, hamauta pãar k'ãaijã hʌ̈k'atarr haawaima. Pari pãrau magba hirua jaau nʌrrʌmjã hũrnaa hirua nem waaujerrjã pãach daúacha hoojerrta, pãach k'aibag k'ĩirjuwia Hẽwandamagjã chugpaapi jëeubajierramgui hajim hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Maimua hich Jesuupai, ’Hũrbat, deeum nem hĩgk'aadam pãrag hĩgk'ak'imgui hajim. Maimua hĩgk'abaadëmua magjim: ’Woun hãbmua uvadö jĩirjim haajem. Mag jĩirwi, hag higaau t'uur p'ʌʌrdʌpʌ̈iwi, chi uva chö piirjʌujujã waunaa, didamjã nasãdjö hʌ̃gt'aa hëu dʌnʌʌujim haajem, hag gaaimua warp dawaa hoo p'ʌʌrdʌdʌ haag. Mag t'um wajap'a wau sĩunaa, chawag mam k'õchk'abaadeewai, chi nemjĩirdö deeum k'ʌʌnag alquilaapʌ̈iwia, hichin jũrr deeum durr warp petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maimua ya chi uva waaubaadëmcha k'ĩirjunaa jöoirau hich chognaan pʌ̈ijim haajem, hich paatëm hagjö hich hat'ee deepʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pari mag chi chognaan hamach haar bardʌtk'abaimaawai, chi uva t'ʌa narr k'ʌʌnau pʌrp'öbaadëwi, hãaur k'ʌʌn gaai sĩi mas waunaa, hãaur k'ʌʌn warre k'ëchpʌ̈inaa maimua pogk'a mokoujã barmaajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Magbaawai deeu jöoirau jũrr k'apanaa pʌ̈ijim haajem. Pari mak'ʌʌnjã hamach haar barpinaa chi nacha bëetarr k'ʌʌn dʌ̈i harrjöo hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Maimua ya hãbmiecha paawai jöoirau hich chaai pʌ̈ijim haajem. Hi k'ĩirjugan hich chaai haawai hi högk'aju hawiata pʌ̈ijiebma. ");
INSERT INTO noaH_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pari warm k'ʌʌnau mag hi högk'ajujã k'ĩirjuba, sĩi warag hamach haar barpinaa, “Keena, chamʌʌta chi hiewaa haawai mʌguata mʌg hatagjã jũrr hich haai nemjĩir jʌ̃aju k'abahab” hajierram hanʌm. “Jãg sĩpí warre maadëu hi t'õopʌ̈iju, mʌg uvadö jũrr maach dënk'a hawaag” hajierram hanʌm, hamach happai. ");
INSERT INTO noaH_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mag, chadcha k'apanaam k'ʌʌnau pʌrp'öbaadëwi chi nemjĩirdö chaaur warp harrnaa t'õopʌ̈ijierram haajem, hich jöoi hiewaa hãba. ");
INSERT INTO noaH_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mag jaaunaa jũrr hich hiek hũr narr k'ʌʌnagta, hichdëu nem hĩgk'atarr higwi, ’Pãrau k'ĩirjuawai hĩsjã hagt'a mag uvadö sim hanaa chi t'ʌa narr k'ʌʌnjã hich hak'ʌʌnpai hak'iin, ¿jãgaju k'ai jöoirau magʌm wounaan dʌ̈i? ha jëeujim Jesuu hamag. ");
INSERT INTO noaH_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Magbaa hamachdëu, —Mag hamach k'aibag sĩsidʌm paar hamachdëu warm k'ʌʌn dʌ̈i haajerrjö hamach dënjö ham dau haug k'augba, hirua hagjö ham k'ëchpʌ̈ijuuta. Magnaa jũrr chadcha hichig p'agju k'ʌʌnagta hirua alquilaa pʌajugui hajierram, hag jaar paawaijã chi nemjõdam hichig hich paat deemk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hamachdëu magbaawaita Jesuu hamag magjim: —¿Pãrau chan bʌ̃ʌrjã Hẽwandamau hich hi jaaumienag hich hiek p'ãpitarr gaai jaau sĩsidʌm t'ʌ̃ʌrwai hooba haajeeb, “Di hëu narr k'ʌʌnau hisegtarr dibigta jũrr chi dihãd jãrramk'a sĩsim” ha sim? “Hẽwandam maach Pöröuta mag dibig wajap'amjö hapi sĩewai hõrau hoowaijã hʌ̈uuta hoo nʌm” ha sim, hich hiek gaai jaauwai. ");
INSERT INTO noaH_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Magua mua pãrag mag chirʌmgui hajim: Hẽwandam pãar t'ãar hee hichta chi Pörk'aju hatarr chi Pör k'aba, deeum k'ʌʌn judionaan k'abam k'ʌʌn hichdëu k'õsi simjö nem wauju k'ʌʌn dʌ̈ita ham Pörk'aju hajim.  ");
INSERT INTO noaH_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Maimua mag mua dihãd ha chirʌmjã mʌch higwiapaita mag chirʌmgui hajim. Chi mʌ hiek hʌ̈k'aba sim wounan, juau hogt'om mag dibig hʌ̃r burrwi hichdëupai hich gaai mas wau simjöta sim; maimua mag hʌ̈k'aba nʌrrʌmta meemʌn, jũrr mʌ mag dibig pömaamjö chirʌmta hi hʌ̃r buudimamjö hajugui hajim. Jesuu mag sĩerran mag hi hiek hʌ̈k'aba sim meebaadeewai warre k'ĩmie durr barpʌ̈ijuuta jaau sĩejim. ");
INSERT INTO noaH_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mamʌ mag hirua jajawagmam hũrwi p'adnaan chi pörnaanau Moiseeu p'ã pʌatarr wajapcha hʌʌrk'aajem k'ʌʌn dʌ̈imua k'aug hat'ajierram, hamachdëu hich hiseg nʌmta jaau sim. ");
INSERT INTO noaH_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mag hamach k'ĩir hiek'a simta k'aug hat'aawai jũrr hichta pʌr harram k'õchk'a p'öbaadëjim. Pari Jesuu chadcha Hẽwandamau nem jaaupi simta jaau nʌrrʌm t'umaam k'ʌʌnau k'ap'ʌ narr haawai hamachta jũrr k'aigbaju k'ĩirjuwi hi chig habajierram. ");
INSERT INTO noaH_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Maimua deeu nem hĩgk'amamua hõrag nem jaaumamua magjim: ");
INSERT INTO noaH_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Hẽwandamagta hamach t'ãar hee hichta chi Pörk'api nʌm k'ʌʌnan, rey hãb simua hich hiewaa jua pʌrmk'ĩir p'iesta wautarr hee hõor bëetarr k'ʌʌnjöta nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mag p'iesta hee bëemk'ĩir ya hõrag jaauk'a t'ʌnarr haawai hag hed pabaadee chi reíu deeu hich chognaan pʌ̈ijim haajem, mag bëeju harr k'ʌʌn haar jaaubat'uurwai bëemk'ĩir. Pari mag jaaubat'urmjã bëebajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Magbaawai jũrr deeum k'ʌʌn pʌ̈iwia hamag, “ ‘T'achin ya sĩi k'öjupaita sim, mʌch nemchaain hõtpaa wai chirarr k'ëch hauwi haata wau t'ʌnʌm; jua pʌr nʌm p'iesta hee wëttarrau’ ha jaaubat” ha jaaupʌ̈imajim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pari par mag deeu hiek jaaupʌ̈itarrjã bëebajierram hanaabá. Mag chi bëeju harr k'ʌʌn heem hãaur k'ʌʌn warag hamach nemjĩir hoon hërëubaadee tagam k'ʌʌn pogk'a hamach p'idag hee wëtjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Maimua hãaur k'ʌʌnau warag mag chi rey hiek jaau wënʌrrarr k'ʌʌn pʌr haunaa parhooba ham gaai mas waunaa warag k'ëchpʌ̈ijierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Magbaawai chi reíu k'ĩir machgau hich soldaaunag mag hich chognaan k'ëchtarr k'ʌʌnjã hagjö k'ëchpi jaaunaa ham p'öbörjã warre hörpi jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Maimuan chadau deeu hich chognaanag, “Nemen t'um k'ĩir k'aug t'ʌnʌm, jua pʌrju p'iesta hat'ee; pari chi t'ʌ̃rpʌ̈itarr k'ʌʌn chadcha chi bëeju k'ʌʌn k'aba harr haawai ham bëebajierramgui” hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Jãgan jãgbarpí kaaijã hee wëtwi mʌ chaai jua pʌr nʌm p'iesta hee bëemk'ĩir, t'um pãachdëu hoomam k'ʌʌnag jaaupetat” hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Magbaa chadcha chi chognaan wëtwi kaaijã hee hamachdëu hoomam k'ʌʌn t'umaa haibëejierram hanaabá, hõor wäjäaun dʌ̈i chi k'aigbam k'ʌʌnpa. Deg pachënaa hoowai sĩi dijã pöm simta hõrau p'ẽu wëjoojim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Maimua mag hõor t'umaa deg paauk'apinaa chi reíu hoon maawaijãh, bëe nʌm k'ʌʌnag jũamk'ĩir hawia hirua k'ajũa p'ëderrjã jũaba, woun hãb hag hee sĩerrau sĩi parhoobam k'ajũata jũa sim hooimajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Magbaawai chi reíu hirig, “¿Pʌ jãga jãg warm k'ʌʌnjö p'iesta heem k'ajũa jũaba simta mʌig dubjĩ?” hajim hanʌm hirig. Pari magʌmjã bʌ̃ʌrjã hi hiek jʌ̃ʌ haba, hichig k'abamjö sĩsijim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mag par jëeu hahauk'amjã hich hiek hʌ̈k'aba habaawai mes gaai t'ëp paa narr k'ʌʌnagta, “Hi bʌ̈ dʌ̈i juapa bʌʌrnaa daaugajãr k'ĩchag hee barbapʌ̈it” hajim hanʌm chi reíu, “hi gaai wajaugau hicharaucha bĩenaa hich mag hagäa hagäa sĩerramk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mag nem hĩgk'aadam jaauwia hich Jesuupai, ’Hʌ̃gt'ar höbërjujã mag p'iesta hee hõor pöm t'ʌ̃rk'ʌʌiwia k'apan k'aba bëetarrjöta sim hajim. Hẽwandamaun hich haar hõor pömta wëtpim k'õsi sim, mamʌ chi chadcha höbërju k'ʌʌn chan k'apan k'abata durrumgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pari mag hirua nem hĩgk'a sim hamach jʌ̃gaagaa k'aba haawai fariseonaan hamach hap hiek'awi hibëpjierram haajem, jãga Jesús hich hiek'a sim gaaimuapai himeraa pʌr hawaag hawi hirig jëeucheeg. ");
INSERT INTO noaH_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mag ya hibëpwi narr haawai hamach hee hamach higar narr k'ʌʌn heem pʌ̈ijierram, deeum k'ʌʌn hagjö chi rey Herodes higar narr k'ʌʌn dʌ̈i. Mag hamach pʌ̈ibaawai bëewi magchëjierram: —Maestro, marau k'ap'ʌ nʌm, pua chadcha hag heyaata nem jaaunaa hĩchab jãgata haju haai nʌ ha jaaujem, Hẽwandamau nem jaau sim heyaa wënʌrraag. Pua chan sĩi hõrau hamachdëu nem jaaum haig nem jaau nʌmʌgjã pʌch k'ũgurpiba wa sĩi pʌchdëu hoowai magjöo habaawai hag bʌ̈rre sĩi magau haba haajem. ");
INSERT INTO noaH_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Magua marau pʌrʌg jëeum hig nʌm: ¿Pua hoowai chadcha maach meeun judionaanaujã durrpierram k'ʌʌn rey Roma sĩejemʌgta impuesto p'agju haai nʌ, wa p'agju k'aba nʌ? haichëjierram hirig. ");
INSERT INTO noaH_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pari Jesuu ya mag ham hibëpwi k'ĩirju nʌmjã k'ap'ʌ sĩerr haawai jũrr hich garmua hamag, —Pãraun pãach k'augbampii naabma, ¿k'ant'ee pãrau jãg mʌ himeraa pʌr hauju hẽk'a nʌma? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Magnaa, Mʌrʌg hoopibat hajim, k'aniuta pãrau dëbpaar p'aagjẽ. Magbaa hirig p'atk'on denario hanʌm hãb hoopijierram. ");
INSERT INTO noaH_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mag hichig denario hãb hoopibaawai, —Pãrau hoowai, ¿k'ai k'ĩirta k'ai t'ʌ̃r dʌ̈i hag gaai sĩ? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Magbaa hamachdëu, —Romaam rey César k'ĩir k'abahab hajierram, hich t'ʌ̃r dʌ̈i. Magbaawaita Jesuu hamag, —Mag k'ai magan reíg hich paat deenaa Hẽwandamagjã hagjö hich paat deebat hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hamachig mag hiek'abapäaiwai sĩi jʌ̃gderraa nʌm hiek'au warag hamachta k'ĩu hërëubaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hich mag hedcha hĩchab saduceonaan heem k'ʌʌnjã hagjö Jesús haig bëejierram. Mag saduceonaanau jaauwai, maach meebaadëm chan maach hak'aar tag hiiuba haajem haajem. Hamach mag nem jaau sĩerrjëem gaaimua, hiyʌ̈ʌmamua juau hogt'om hirig magjierram: ");
INSERT INTO noaH_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, jöoi Moisés k'ararrau Hẽwandam hiek p'ã pʌarr gaai jaauwai, woun hãb hʌʌi wai simta chaaijã chuk'u meemʌn, magan mag chi meetarr k'od hãbam wai sim k'ai, magua hich k'ojaau hauju haai sim ha sim, hag dʌ̈i hich naamʌu chaain hooba harr haawai jũrr hi hat'ee hoo deeg, mag hoo deebarm hi chaaink'a nʌisimk'ĩir hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Maimua hamachdëupai warag hirig nem hĩgk'amamua magjierram: ’Biek hãb mʌig maach meeun hee hemk'ooin siete naajim haajem, hãbam k'od happai. Ham naam chi nacharamua hʌʌi hauwia chaaijã chuk'u meejim haajem. Magbaawai hag hẽudeemua hich k'ojaaupai wir haig haujim haajem, hich naam t'ʌ̃r hok'oopimaaugau hawi. ");
INSERT INTO noaH_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pari majã pöd hag dʌ̈i chaai hooba meejim haajem. Hich mag hewagam k'ʌʌnjã hãbam hʌʌiraupai warm meemam hẽudee t'eg hahaugmamua mag siete narr t'um t'egdʌpʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Maimua ya hãbmiecha paawai chi hʌʌijã meejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mag hãbam hʌʌiraupai hãbam k'od happai siete p'ëpʌ̈itarr haawai mʌg hatag t'umaam k'ʌʌn hiiu p'iidʌtk'abarm hedjã, ¿mag hʌʌi chijãg dënk'a sĩsijuma, chi nacha hautarr dën wa hẽudeegam k'ʌʌn dën? ha jëeujierram hirig, juau hogt'om. ");
INSERT INTO noaH_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Magbaata hũr nʌm jʌ̃g heyaa Jesuu hamag, —Pãran hok'oota hiek'a nʌmgui hajim, Hẽwandam hiek p'ã sĩsidʌm gaai jaau simta hi jua t'eegjã k'augbata hiek'a naawai. ");
INSERT INTO noaH_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Meetarr k'ʌʌndam t'umaa hiiu p'iidʌtk'a p'öbaadëm chan bʌ̃ʌrjã jua pʌpʌr habajugui hajim, ya ham hʌ̃gt'arm Hẽwandam chognaan t'ʌnʌm k'ʌʌnjö nʌisiju haawai. ");
INSERT INTO noaH_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Pãrau hooba haajẽ, Hẽwandamau hich hiek p'ãpitarr gaai mag hõor hötarr k'ʌʌn deeu hiiu p'iidʌtk'aju higwi, ");
INSERT INTO noaH_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Hichta jöoingar jöoi Abrán k'ararr Hẽwandam hanaa hĩchab jöoi Isá k'ararr hag Hẽwandamau maimua Jacob k'ararr dënjã hagjö” ha sim? Hirua mag mak'ʌʌn jöoin hagt'a meeba nʌmjö hiek'atarr haawai Hẽwandam chan hoob mag chi k'ëcham k'ʌʌn Hẽwandam k'abam. Hẽwandaman chi hiwam k'ʌʌn Hẽwandamaugui hajim. Hirigan nawe k'ëchtarr k'ʌʌn hawiajã hagt'a hiiu nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mag nem jaaumam hũrwia, chadcha t'um chi hũrmam k'ʌʌn jʌ̃gderraa naajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesuu mag saduceonaan warre k'ĩupaa sĩubarm fariseonaanau hoobaawai, jũrr hamaun chadau hi p'it'urg chuk'u pʌr hauju hawi, ");
INSERT INTO noaH_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","hãb ham heem Moiseeu ley p'ã pʌatarr jawaag chi mach hich Jesús haig bëewi hirig, ");
INSERT INTO noaH_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, Moiseeu ley p'ã pʌatarr gaai, ¿chijãg hiekta tagam k'ʌʌn k'ãaijã chi wajapcharamʌ́wa? ¿K'anta hʌ̃rʌʌcha Hẽwandamau maachig waupim k'õsi sĩ? hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Magbaawai Jesuu hirig, —Chi wajapcharamʌn, “Maach Hẽwandam sĩi par hiiupai k'aba, pʌch t'ãrauchata k'õsi habá” ha p'ã simʌu hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tagam ley hʌʌrk'api jaau nʌm k'ãaijã maata chi wajapcharamʌugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Magnaa deeu hichdëupai, Hãb hagjö hich hagjöpaimʌʌ simgui hajim. Ma sĩi “Pʌch k'apeenjã wir haig pʌchjö daupii habá” ha sim. ");
INSERT INTO noaH_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moiseeu ley p'ã pʌarr t'um tagam k'ʌʌn hagjö Hẽwandam hi jaaumienau jaaujerrpa mʌk'ʌʌn dau numiim gaaimuata höbërdʌtk'a nʌm. Mʌk'ʌʌn numiita wajap'a hʌʌrk'a simʌn magan tagam k'ʌʌn hʌʌrk'api jaau simjã t'um hʌʌrk'a simgui hajim hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mag chi fariseonaan hagt'a hãba biirdʌ t'ʌnʌm hee, ");
INSERT INTO noaH_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesuu hamag, —Pãrau mag hõor peerdʌ hawaag Mesías hanʌm bëeju hig hiyʌ̈ʌ haawai, ¿k'ai chaai haju k'ai ha k'ĩirjuba haajẽ? ha jëeujim. Magbaawai hamachdëu, —Jãan warrgar jöoi David k'ararr hag chaain hewagam k'ʌʌnauta hoodeejugui hajierram. ");
INSERT INTO noaH_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Magbaata hich Jesuu hamag, —¿Pari jãga mag David chaain hewagam k'ʌʌn dën habarju, hich Daviiujã mag hich Hẽwandamau pʌ̈iju haajerr higwi hi Pör ha hiek'atarrta? Hirua mag hiek'aawai, ¿hich Hẽwandam Hak'arauta mag hiek'apibajĩ? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","¿Pãrau k'augba nʌ, hich Hẽwandamaucha hiek'atarr Daviiu p'ãtarr? Mag hirua p'ãtarr gaai mag sim: “Maach Pör Hẽwandamau mʌ Pörög, ‘Mʌch hiek t'eeg chirʌmjö haag mʌ dʌ̈i hãba mʌ juachaar gar jupbá’ hajim ‘pʌch hoomap'a haajem k'ʌʌn t'um mua pʌch jua hee pʌrk'a dee nʌm hora.’ ” ");
INSERT INTO noaH_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mag hich David k'ararrauchajã Hẽwandamau pʌ̈iju haajerr higwi “maach Pör” ha hiek'atarrta, ¿jãga pãar hiek mag hí David chaain hewagam k'ʌʌn dënpai haju hanʌ́? Mag sĩi hi chaaipai haju hak'iin, hich paarmua mag “maach Pör” habak'amgui hajim Jesuu hamag. ");
INSERT INTO noaH_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mamʌ par hirua mamagk'amjã hãbmuajã bʌ̈dam hãbjã jʌ̃ʌ haba haajeejim. Magtarr haigmua hatag ni hãbmuajã tag hirig hiek chigaapaijã jëeuba haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Magtarr k'ur Jesuu hõragjã hũrmk'ĩir hiek'amamua maragjã magjim: ");
INSERT INTO noaH_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Chi machnaanta fariseonaan dʌ̈i Moiseeu ley p'ã pʌarr jaaujem k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Magua hamau jaau nʌm hũrnaa pãachig jajaauk'am hipierraa habat. Mamʌ hoob hamau haajemjö chan hamiet hajim. Jãk'ʌʌnan hamach hipaarmua Hẽwandam dau na hajap'a nem waupi jajaau haajemta hamachdëu chan hamachdëu jaau nʌmjö nem wauba sĩerrjëem. ");
INSERT INTO noaH_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Magnaa nem jawaagjã hamachdëu nem jaaum haigta jaau sĩerrjëem. Jãg nʌm haig hõor hʌ̃r nem chʌk'ʌmta jiirpʌ̈pʌ̈ik'amjöta naabahab hajim, hõrau wauju k'aba hatcha p'it'urgk'amta waupi jaauwai. Hõrag mag nem jaauwaijã hamaun hamach hipierraata hapi nʌm, mamʌ mag nʌm chan hamachdëujã hamachdëu nem jaau nʌmjö waujöjöopaijã k'aba nʌmta mag sĩerrjëemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ham nem waubaadëmʌn, hõrag sĩi hamach hoomk'ĩirpaita nem wau sĩerrjëem, hamachdëuta wajapcha Hẽwandam hiek hʌ̈k'a naawai hi dʌ̈i wajapcha nʌm hamk'ĩir. Hamach mag nʌm hawi, Hẽwandam hiek p'ã sĩsidʌm gayamjã jũrr deeum gaai p'ãnaa, chʌdam gaai hẽupʌ̈inaa, hamach piudau gaai jʌ̃pʌ̈inaa dag gaaijã jũapʌ̈imaajemgui hajim. Mag nʌm dʌ̈i hĩchab hamach k'ajũahi gaaijã nem bäbärgta jijiraa jũajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hõor k'apanag hee t'ach k'oowai, wa sĩi Hẽwandam hiek jaaujem deg k'ãijã biirdʌawai, hamachta sie wajapcharam gaai juupjemgui hajim, hõor k'ĩirp'ee t'umaam k'ʌʌnag hamach hoomk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Magnaa kaaijã hee hõrau hamach saludaawaijã hamaun hamach t'ö hiek'apinaa hamachig maestro hapim k'õsita sĩerrjëemgui ha jaaumajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mag jajawagmamua, ’Pari pãar mʌ dʌ̈i k'apeerk'a nʌm k'ʌʌn chan mʌ hiek hʌ̈k'a nʌm gaaimua t'um hagdaujöpai naawai, pãachig “maestro” hapiju k'aba nʌmgui hajim, chik'amnag. Mʌʌta pãar Maestroou hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pãar Haaijã hãbpaita wai nʌm; ma hʌ̃gt'ar sĩejemʌu. Magua, mʌig heegar chan pãach garmuajã hoob parhoobam k'ʌʌnag Hẽwandamagamjö “haai” hichëmiet hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hãba mʌch chi Cristopaita pãar Pörk'a chiraawai, hoob pãachigjã “maach pör” hapimiet hajim, dich k'apeen hãba t'ʌnʌm k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Magju k'ãai hãb k'ãijã pãar hee hichta chi pörk'am k'õsi sim k'ai, warag t'umaam k'ʌʌn chogk'aju haai sim. Mag nʌm haigta Hẽwandamau hoowai chi wajapcharamk'a simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mua mag chirʌmʌn, har hamach t'öwia chik'am dʌ̈i hat'uu haajem k'ʌʌn mʌg hatag paawai jũrr Hẽwandamag chaigpa hoo sĩsid haju haawaita mag chirʌm; maimua har mag hamach dʌ̈i hat'uu nʌmjã bʌ̃ʌrjã ham hichaaur haba sĩi warag serbiibamjö haajerr k'ʌʌnta jũrr Hẽwandamau warm k'ʌʌn k'ãaijã hʌ̃rpai hapiju haawaita mag chirʌmgui hajim hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Maimua mag hiek'ak'agmamua magjim: ’¡Hëh, pãarjã hagjö chi machnaan dʌ̈i Moiseeu p'ã pʌatarr hiek wajapcha hʌʌrk'aajem k'ʌʌn! Pãran pãachdëuta hʌ̃rcha Hẽwandam hiek k'ap'ʌm hanʌmta Hẽwandam haar höbërjujã k'augba nʌmgui hajim, pãachdëu hʌ̈k'aba nʌm gaaimua. Mamʌ mag nʌmta hõrau hi haar höbërju hẽk'aawaijã warag chi höbeerjem döig chawag k'echeu hahauk'amjö haajem, hõor k'ũgur wai nʌmua, Hẽwandam hiek hʌ̈k'apimaaugau.  ");
INSERT INTO noaH_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Hëh, hapdurr, pãar chi machnaan dʌ̈i Moiseeu p'ã pʌarr hiek hajapcha hʌʌrk'aajem haajem k'ʌʌn! Pãraun sĩita k'oopaa hʌʌin juagam nemdamjã k'echt'ʌg haumaajerramgui hajim; magnaata sëuk'a warag ham kõit Hẽwandamag jëeu nʌʌ haajerram, juau hogt'om pãach magba nʌm hamk'ĩir. Mamʌ pãach jãg nʌm paar jũrr Hẽwandamau hĩchab pãar gaai jua k'ʌabajugui ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Hëh pãar Moiseeu ley p'ã pʌarr jawaag chi machnaan chi mag ley wajapcha hʌʌrk'aajem haajem k'ʌʌn dʌ̈i! Pãachdëuta Hẽwandam hipierraacha nʌm hawi pãach dënjö hʌ̈k'api hawaag warp'am magwe jaau wënʌrraajemgui hajim. Mamʌ mag nʌmʌn, chadcha pãach hiek hʌ̈k'abaadee pãach k'ãaijã hat'uuchata k'aibag paapʌ̈imaajem, pãachjö hamjã Hẽwandamau k'ĩmie durr bark'ʌʌiju hayaa hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Hëh, pãran sĩi pãachjã dau k'augbamjö nʌmta hagjö dau k'augba k'it'ëem k'ʌʌn jua gaai hëudʌ harrumjö nʌmgui! hajim hamach k'ĩircha. Pãach mag nʌm gaaimuata pãar hiek mag “Haai hi jëeujem di higwia nem wauju ha hiek'atarr chadcha wauba hawiajã hidëu mag sim” ha hiek'aajemgui hajim hamag. Mamʌ jũrr “Chi Haai hi jëeujem deg p'ĩr t'ʌnʌm higwiata nem wauju ha hiek'aawain chad hichiita waub k'aba wauju haai sim” haajem, “Hẽwandam dënk'a sim higwiata mag hiek'a naawai.” ");
INSERT INTO noaH_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Pãran warag k'ĩirjugjã chuk'unaa dau k'augbamjöta t'ʌnʌm! Pãar k'ĩirjug paraa naak'iin, chi Haai hi jëeujem diita hajapcha sĩebahab, chi p'ĩr k'ãai. Mag sim hee sĩewaita hag heem p'ĩrjã hagjö Hẽwandam dënëg pa sĩebahab hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pãar hiek hĩchab mag “Sĩi chi Haai hi jëeujem deg nemchaain p'aag nasãdjö wau sim higwia nem wauju hatarr wauba hawiajã hidëu mag sim” hanʌm. “Pari mag nasãd gaai ofrenda sim higwiata nem wauju habarmʌn chadau hichiita waub k'aba wauju haai sim” haajem. ");
INSERT INTO noaH_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡K'augabnaan! ¿Magan pãragan chi nasãd k'ãaijã chi ofrendata wajapcha sĩeb? Nemchaai hich happai chan wajaug chuk'u simgui hajim; hãba mag nasãd gaai hausĩubaawaita wajaug haadëp sĩebahab, Hẽwandamau hich dënk'a hat'aawai. ");
INSERT INTO noaH_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chi mag nasãd Haai hi jëeujem degam higwiata nem wauju ha simua chan hãba chi nasãd higwiapai k'aba, hag gaai chi ofrenda paa sim higwiapata hiek'a sĩebahab hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Maagwai chi Hẽwandamag jëeujem di higwia nem wauju ha hiek'a simuajã sĩi mag chi di higwiapai k'aba, Hẽwandam higwiapata hiek'a sĩebahab, mag degta Hẽwandam sĩejeewai. ");
INSERT INTO noaH_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Maagwai hedjã higwia k'ãijã nem wauju ha hiek'a simuan mag hedjã higwiapai k'aba Hẽwandam higwiapata hiek'a sim, chi hedjã Hẽwandam k'u juupjem haawai. Mag hi k'u juupjem higwiapa hiek'aawai hich Hẽwandam higwiapata hiek'a sĩebahab hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Hëh, pãar Moiseeu ley p'ã pʌarr jawaag chi machnaan hag hiek wajapcha hʌʌrk'aajem haajem k'ʌʌn dʌ̈i! Pãraun pãachdëuta Hẽwandam na wajapcha nem wau nʌm hawia, hi paat hagjö deeg pãach nemjĩir bʌ̈ daiicharam gayampa Hẽwandamag ofrendak'a deejem: pãrau anís heemjã deenaa comino heemjã deejemgui hajim. Pari mag nʌmta jũrr mag ley Moiseeu p'ã pʌarr gaai hag k'ãai nem wajapcharam jaau simjö haju chan k'ĩir heejã paba haajemgui hajim. Pãrau chan wir haig pãach k'apeen dʌ̈i hagpierraanaa ham dau haug k'aug paraa nʌm dʌ̈i hĩchab Hẽwandam hiekta hogdʌba hich jãg hʌ̈k'a wënʌrraju haai nʌmjã k'ĩirjuba haajemgui hajim, majã magʌmta hʌ̃rcha wauju haai nʌmta. Magnaan chad tagam nem pãachdëu wau nʌm pʌaba hich jãg dee wënʌrraju haai nʌm. ");
INSERT INTO noaH_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡K'ĩirjug chuknaan! Pãach pem haawai pãran dö dö nʌm dʌ̈i sĩi pagatjöm k'ãijã döbapʌ̈imua pekaudam waumaaugau hawi, hajap'a sãnaata doojerram. Pari jũrr pekau pöm camellojök'amta sĩi hʌ̃ipʌ̈i nʌmjö nʌm chan pãar gaai mas k'aba haajemgui ha hiek'ajim hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Hëh, pãar Moiseeu ley p'ã pʌarr jawaag chi machnaan maimua mag ley wajapcha hʌʌrk'aajem haajem k'ʌʌn! Pãach hi haawai pãran sĩi pãach juagam nem hʌ̃rʌm chi memerk'ögpaita hʌk'ak'a haju k'ĩirju sĩerrjëem, mag memerk'öm hee k'ãijã döbaawai Hẽwandam dau na pekau waumaaugau hawi. Mamʌ pãachdëu chik'am nemdamjã pãach dënk'a haunaa waragta p'atk'onjã nem pöm paarpam k'õchk'a t'ʌnʌm gaaimua pekau pöm nʌm chan hisegba, ni Hẽwandamag chugpaapi jëeujujã k'ĩirjuba sĩerrjëemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Moiseeu ley p'ã pʌarr wajapcha hʌʌrk'aajem k'ʌʌn hanʌmta k'augabnaan! Jãg t'ach k'oopierr nem jã hʌk'ak'a haajemjö, ¿jãg pãach t'ãarta nacha Hẽwandamag hʌpibamma? Pãrau magta hamʌn chadau hʌ̃rpai k'aba pãar t'ãarpata wajap'a wënʌrrajugui ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Hëh, pãar Moiseeu ley p'ã pʌarr hajapcha hʌʌrk'aajem haajem k'ʌʌn hag ley jawaag chi machnaan dʌ̈i! Pãran sĩi hõor hauk'ërtarr jẽbdijöta sĩsidʌm. Sĩi daaugajãrpai hoowain wajap'a jarnaa hooimʌ wau sĩsidʌm; pari mag sim hag hee hierr wa hook'iin, sĩi maach hinaa pa happaita t'up'ãau nʌnʌidʌm. ");
INSERT INTO noaH_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pãarjã magta t'ʌnaabahab hajim: Sĩi k'ĩir heerpaawain hõor wajaauga t'ʌnʌm; pari pãar t'ãran k'aibagauta sĩi hãr sĩsidʌm. ");
INSERT INTO noaH_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Hëh, pãar Moiseeu ley p'ã pʌarr jawaag chi machnaan maimua mag ley wajap'a hʌʌrk'aajem haajem k'ʌʌn! Pãraun pãach magba nʌm hamk'ĩir, warrgar pãach jöoin Hẽwandam hi jaaujerr k'ʌʌn chadcha hõor wäjäaun harr haawai hagt'a k'ĩir heyaa wai wënʌrrʌm hawia, ham hauk'ërtarr jã hʌ̃rjã sirppapiba warag nem hooimʌ wau sĩsiu haajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Magnaa pãar dën, “¡Hih! maachta maar jöoinau mag Hẽwandam hi jaaumien k'eechjerr jaar narr hak'iin, marau chan ham dënjö mag maach jua paarmua dʌ̈i ham k'ëchbak'am” ha hiek'aajem. ");
INSERT INTO noaH_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pari sĩi pãachdëu mag nʌmuapai pãrau pãachdëujã k'ap'ʌ naabá, pãach mag warrgar Hẽwandam hi jaaujerr k'ʌʌn k'ëchmien chaaink'a nʌm. ");
INSERT INTO noaH_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mag hak'ʌʌn chaain haawai hĩs pãachdëujã hagjö hajurauma mʌ dʌ̈ijã hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡K'aibag, nemk'õr chi benen paraamjönaan! K'anii pãar jãg t'ʌnʌmta k'ĩmie durr wëtba peerdʌbajupa. Pãar chan peerdʌbam. ");
INSERT INTO noaH_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","K'ap'ʌ habat: Mua pãar hee mʌch hi jaaumien pʌ̈iwia k'ĩirjug k'augk'am k'ʌʌnjã maestronaan dʌ̈i pʌ̈iju. Pari mag mua ham pʌ̈ibaawai hãaur k'ʌʌn pãrau k'ëchpʌ̈iwia hãaur k'ʌʌn sĩi pakuls gaaijã bʌʌrnaa k'ëchmaju; hãaur k'ʌʌn pãrau pʌrnaa pãach Hẽwandam hiek jaaujem deg wʌjã wʌmaju; maagwai hãaur k'ʌʌn hamach pʌr haupiba deeum p'öbör hee k'ãijã dʌr wënʌrraawai hagpierr pãrau ham hẽudee k'oojem nem hẽudeemjö hẽk'aju. ");
INSERT INTO noaH_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pãach mag t'ʌnʌm gaaimua, warrgar Abel t'õotarr haigmua hewag pawiajã hõor Hẽwandam na wajap'a durrarrta k'ëchmatarr bag hãrtarr t'um jöoi Zacarías Berequías hiewaa Haai hi jëeujem deg t'õo naawai bag hãrtarrpa Hẽwandamau t'um pãach gaaita t'ʌpʌ̈iju. ");
INSERT INTO noaH_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cha mʌ hiek'a chirʌm hiek'au warrgarwe pãach jöoinau maagjerran pãach chi hĩs hewagam k'ʌʌn gaaita pajugui hajim, pãachdëujã hamau nem waaujerrjöta wau naawai. ");
INSERT INTO noaH_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mag Jerusalén p'öbör hee Haai hi jëeujem deg simua hʌ̃apërmamua magjim: ’¡Hëh! ¡Aay, Jerusalenpien! Pãraun chadcha warrgarweta Hẽwandamau hich hi jaaumk'ĩir chogpʌ̈i nʌm k'ʌʌnjã k'a k'õchk'aba, warag mokoujã bar wai nʌmua k'ëchpʌ̈imaajemgui hajim. Biek k'apan mua pãrag jaaujeejimgui hajim, hãt'ãrr hʌʌirau hich chaaindam t'umaa hich hich heegar t'oor wai juupjemjö pãar t'ʌa wai chitaag. Mamʌ magtarrjã pãachdëuta bʌ̃ʌrjã mag k'õchk'abajierram. ");
INSERT INTO noaH_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jãgtarrau nau pãrau hoomaa habarju. Nau mʌ mʌg chitʌʌ hawia petaawai pãar sĩi di pariim hee wouchnaan p'ëpʌabajëmjöta pãach happai nʌisijugui hajim, k'aigpërjujã chuk'u. ");
INSERT INTO noaH_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Magbarm haigmua tag pãrau mʌ hoobam hajim. Pãrau mʌ hoojuun, hãba ya pãachdëucha deeu mʌ hurum hoowi, “Hʌ̈uchata Hẽwandam pua pʌch jũrr pʌch Chaai maar hat'ee Reik'a pʌ̈ibarm” hanʌm haigta deeu mʌ hoojugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesuu Haai hi jëeujem deg mag hõrag nem jaau sĩi hawia höbërbaadeeu mag chi Haai hi jëeujem di hig hiyʌ̈ʌ nʌmuata marau hirig jaau naajim, di pöoma sĩi joot'ʌt'ʌʌd hëu dʌnʌm. ");
INSERT INTO noaH_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Magbaawai hichdëu marag magjim: —Pãrau jãg di wajap'a hëu dʌnʌm hoo naabá. Jãg t'ʌnʌm chan mok pör hãbjã hãbam hʌ̃r hich jãg hajap'a joot'ʌt'ʌʌd sĩerrabam. Jãg t'ʌnʌmʌn sĩi t'umaa hõrau pogueupʌ̈ijuuta jãg dʌnʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mag Haai hi jëeujem degmua höbërwi hërëubaadeeu jũrr Olivo durrsĩig wëtjim. Maimua barwi maar na jupbaimaawai maach chi k'apeenjã dʌ̈i hi bigaau hohood haimajim. Maimuata marau hirig jëeu naajim: —¿Jãagwaichata mag pʌchdëu jaau simjö mag Haai hi jëeujem di pogueupʌ̈ijuma? Maimua mag pʌ deeu bëeju hanʌmjã, ¿k'an gaaimuata mag pʌ deeu bëeju dakpapak'amjã marau k'ap hajuma? hanaajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Magbaawai jaaubaadëmua hichdëu marag, —K'ĩir k'ap'ʌ haajeet keena; hoob chik'amnag hʌdʌraa pãach k'ũgurpimiet hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mʌg hatag paawai hõor pöm sĩi chik'am k'ũgurm k'õchgau hamach hiekpai mʌ hiek gaai t'ʌwia, “Mʌʌta hag Cristoou Hẽwandamau pʌ̈iju haajerr” ha hiek'a nʌrrjëe haju. Mag nʌrrjëem gaaimua hõor pöm k'ũgur haumaju hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Juurhi p'iidʌju t'eeg jajaauk'amjã pãrau hũrjugui hajim. Mamʌ pãachdëu mag hũurwai hoob jãp'ierrmiet. Hichiita jerrba chadcha hich mag haju. Magjup mamʌ ma chan hagt'a Hẽwandamau pãar hi hagk'a nʌm k'abamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magbaadëmʌn durr mʌg wëjöm hee durr chaauram k'ʌʌn dʌ̈i wërbʌp'öo haadëju, hamachta jũrr chik'am k'ãai hʌ̃rpai ham k'õchgau. Magbaadeewai jãdau t'eeg haadëm dʌ̈i hʌʌur t'eegjã duuimaju, durrpierr. ");
INSERT INTO noaH_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pari mamagk'amʌn maan sĩi warrpem Jöoirau hõor dau haug waupi simʌugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ya magbaadeewai pãar chi mʌ hiek hʌ̈k'a durrum k'ʌʌn t'et'emnaanau pʌrnaa hamachjöm k'ʌʌnag pãar pʌr deemaju, pãar dʌ̈i hamachdëu hampierr hamk'ĩir. Mag pʌr deebaa pãar gaai mas waunaa pãar t'õojã t'õomajugui hajim. Mag nʌm dʌ̈i hĩchab t'umaam k'ʌʌnau pãar hoomapp'a haju mʌ hiek hʌ̈k'a durrum gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mag jaar paawai hõor pöm mʌ hiek hʌ̈k'a t'ʌnarr hamachdëu hʌ̈k'a narr hiek hisegwi deeu hewag wëtju, warr hamach narrjö. Magbaadee wir haig hamach heepaijã chik'am hoomapnaa wir haig chik'am t'õomaju hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hẽwandam hiita jaau nʌm hanʌm k'ʌʌn k'apaana höbërdʌtk'aju. Pari mag t'ʌnʌm sĩi hõor k'ũguraagpaita mag wënʌrraju haawai hõor pöm k'ũgurmajujã jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","¡Aay, mag hed gaaita nem k'aigbam pömaata t'ʌnʌisijupa! Ya mag nem k'aigbamta hʌ̃rpai haadeewai hõrau hamach k'apeen k'a k'õsi haajerrjã tag k'õchk'aba hap'öbaadëju. ");
INSERT INTO noaH_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pari warm k'ʌʌn mag t'ʌnʌm hee, hʌ̈u hichdëu mʌ hiek hʌ̈k'atarr gaaita hogdʌba k'ërʌm wounan hʌ̈u peerdʌjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hẽwandamau mʌg durr hi hagk'aju nawe, durrpierr t'umaam k'ʌʌnag mʌg hiek wajap'am hõor peerdʌ haaujem jaaudubju. Mag jaaubaawai t'umaam k'ʌʌnau hũrbaawain chadau warre hich Jöoirau mʌg durr jua k'ẽgk'apʌ̈iju ha jaaumajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mag hich Jesuu jajawagmamua magjim: ’K'ĩir heyaa habat, Hẽwandam hi jaaumie Daniel k'ararrau p'ã pʌarr gaai jaauwai Haai hi jëeujem deg hierr hich Hẽwandam sĩejem haarcha högk'aba dubwi hãbmua parhooba hichdëu ham haig haju jaautarr. Magtarr haawai chi hũr nʌm k'ʌʌnau wajap'a k'ap'ʌ habat hajim: chadcha Danielau jaautarrjö woun hãb chi k'aigbamta Hẽwandam hawi ya Haai hi jëeujem deg sĩeichëm hoobaawai ");
INSERT INTO noaH_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","mʌg chi Judea durr nʌm k'ʌʌn warag pabʌ̈ hee durr dapag hee dʌrbat hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Maagwai hich dihëu hʌ̃r hʌ̃gt'aa k'ãijã sim k'ai, hoob hich nem hawaan hawi hierrag mam. ");
INSERT INTO noaH_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wa magba di chaaur hich p'idag hee k'ãijã sim k'ai, hoob tag degag mam, hich k'ajũajöm k'ãijã hawaan hawi. ");
INSERT INTO noaH_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mamʌ ¡hëh, hapdurr mag jaar hʌʌin jõor k'it'ëem k'ʌʌn maimua har sĩi chaain daumeraa wai k'it'ëem k'ʌʌn! ");
INSERT INTO noaH_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Hedau k'õrgk'am hee wa jua hʌ̃i nʌm hed k'ãijã pãach mag dau hap'ʌʌ dʌr wënʌrram hugua, Hẽwandamagta jëeu durruu habatgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mag jaar mag wajap'a hõor dau haug waujujö chan mʌg durr hompaatarr haigmua hewagjã mag hooba, ni mag dichtarr k'urjã hagjö chan dau haug waubajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mag Hẽwandamau hõor dau haug waubaadëm hidëu hich mag sĩuk'iin, hõor hãbjã peerdʌbaju. Mamʌ hichdëu jʌr hauwia hich hiek hʌ̈k'a durrum k'ʌʌn hichdëu k'õsi p'ë wai sim gaaimua, hirua hich mag wai sĩi habajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Mamagk'am hee hãbmua k'ãijã pãachig, “Hoobat, chamʌʌta warrgarwe Hẽwandamau pʌ̈iju haajerrauwai”, wa magbam k'ai, “Pãadë hoobat, har sĩ; jãata haruuwai” haawai hoob hʌ̈k'amiet. ");
INSERT INTO noaH_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mua mag chirʌmʌn, hamach hiiupaita hamta Hẽwandamau pʌ̈ijim hanʌm k'ʌʌn dʌ̈i Hẽwandam hi jaaumien hanʌm k'ʌʌn k'apan sĩi sëuk'a chik'am k'ũgur wënʌrraju haawaita mag chirʌmgui hajim, k'ap hamk'ĩir. Mak'ʌʌnaun chadcha Hẽwandamauta hamach pʌ̈ijim hamk'ĩir, hag na hõrau hooba haajempa hõor dauderraa wau wënʌrraju. Mag nem wau wënʌrrʌmua hich Hẽwandamaucha jʌr hauwi hich hiek hʌ̈k'api hautarr k'ʌʌnpa k'ũgur hẽk'aju hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chadcha magju haawai hag nawe k'ap hamk'ĩir ya mua pãrag jaau chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ya mag k'ap'ʌ naawai hãbmua k'ãijã pãachig, “Hõor maba haajem haarta sim” ha jaauwai hoob haar hoon wëtmiet hajim. Wa magbam k'ai, “Mʌig simta hich hoopiba sim” ha jajaauk'awiajã hoob hʌ̈k'amiet hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mʌch chi Hemk'ooi Hiewaa bëewain, t'umaam k'ʌʌnauta mʌ hoojugui hajim, hich jãg hedau höbeerjem garmua hed burrjemʌg sĩi pagt'ʌm dau p'ʌr jẽer hat'aawai hedjã t'um harar hat'am hoojemjö. Magua hõrau mag pãachig ya barbaichëm ha jaauwaijã hoob hʌ̈k'amiet hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pãrau k'ap'ʌ nʌm, nemmí sim haig hãkõs hich k'ĩrau jupcheejem. Hich hagjöta habajup hajim hĩchab muajã mʌch hiek hʌ̈k'a nʌm k'ʌʌn dʌ̈i; ham p'ë harraag mʌch bëem hed ham haigta dau daau hurum t'umaam k'ʌʌnau mʌ hoojugui ha jaaumajim hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mag jajawagmamua hĩchab, ’Mag hich Hẽwandamau wajap hõor dau haug waupiwi ya tag magba haadëm hee, mʌg hãsdawam hedau k'ĩjugui hajim. Magbaawai hedau chi hedaramjã hararaa wʌʌ jẽerba warag k'ĩbaadëm dʌ̈i p'ĩdagjã hedjã heemua sĩi k'ʌijugui hajim. Magbaawai hedjã hee nem sĩsidʌmjã sĩi parhooba hamach nʌnʌid harr chaaurta haaidʌ jörrjëe t'ʌnʌisijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Magbaadëm heeta hedjã heejã mʌch chi Hemk'ooi Hiewaa hurum dauchach dawaa hoopijugui hajim. Mag hoowi durrpierram k'ʌʌn jãp'ierr nʌm hiek'au hicharaucha bĩe nʌmuata mʌch chi Hemk'ooi Hiewaa nem jua t'eeg t'umaam k'ʌʌn Pörk'a hurum hoojurau. ");
INSERT INTO noaH_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mag hurumua mʌch chognaanag nem jẽbag churo hiekjö trompeta sirpijugui hajim, mag sirbarmua mʌchdëu jʌr hauwia mʌch hiek hʌ̈k'atarr k'ʌʌn t'umaa durrpierram k'ʌʌn hãbam haig biirdʌ hawaag. ");
INSERT INTO noaH_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mag jaaumamua hich Jesuupai, ’K'ap hamk'ĩir pãrag jaauk'imgui hajim: Pãrau k'ap'ʌ nʌm, mʌig Israel durr higo bʌ̈ jãga haajẽ. Ya jãata k'ër k'uk'uur haadëmʌn t'umaam k'ʌʌnau ya chadcha döchʌumie burrju dakpapak'am haajem. ");
INSERT INTO noaH_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hich hagjöta hajugui hajim hĩchab mʌch chi Hemk'ooi Hiewaa bëeju gaai paawaijã. Cha mʌchdëu jaau chirʌm t'um hich hag hee höbëbërgmam pãach daúa hoobaawai k'ap'ʌ habat, ya mʌch chi Hemk'ooi Hiewaajã deeu bëeimʌʌ chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mua pãrag mag Haai hi jëeujem di hõrau pogueupʌ̈iju ha chirʌmʌn, cha hõor t'ʌnʌm k'ʌʌn k'ëchju nawe cha mʌchdëu jaau chirʌmjö t'umaa chadcha hajugui ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hedaujãjã mʌg jẽb dʌ̈i t'um chuk'u haadëju, mamʌ cha mua pãrag jaau chirʌm chan sëuk'aawai k'abam. Jãan t'umaa hich hag hee höbërjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mamʌ mag mʌ bëeju hed chan ni hãbmuajã k'augbam. Hʌ̃gt'ar Hẽwandam chognaanaujã k'augba, ni mʌchdëujã k'augba, hãba hich mʌ Hayaupaita mag mʌ bëeju horajã k'ap'ʌ simgui hajim, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Jöoingar Noé k'ararr jaar döhãdau hõor höpäaiwai t'ʌnaajerrjö t'ʌnaaju hĩchab mʌg hatag mʌch chi Hemk'ooi Hiewaa bëe nʌm jaarjã. ");
INSERT INTO noaH_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jöoi Noé sim jaar mag döhãd pöm bëeju nawe, hagt'a hõor p'iestajã waunaa, t'achjã k'önaa, döjã dönaa, sĩi jua pʌr k'odt'ʌnaajim, bʌ̃ʌrjã hamach höjujã k'ĩirjuba. ");
INSERT INTO noaH_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mamʌ ham mag honee bʌ̃ʌrjã hamach chig hajujã k'ĩirjuba nʌm hee, döhãd pöm bëewi, jẽb hierrpawi, t'umaa hödubjierram. Mʌch chi Hemk'ooi Hiewaa bëe nʌm jaarjã hich hagjöta hajugui hajim. Hamau bʌ̃ʌrjã hamach chig haju k'ĩirjuba nʌm hee, dëgölp mʌʌn dʌnʌʌuchëju ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mag mʌ pierrum dʌ̈icha hemk'ooin numí pabʌ̈ hee hamach p'idag hee naaju: mag numí nʌm heem hãb mua harrwi hãb werpʌajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hʌʌinjã hĩchab numí hãbam molin gaai ba naaju: mamʌ mua hãbpai mʌch dʌ̈i harrwi hãbak'ai werpʌajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Pãrau mʌ pãach Pörk'a barchëju hed bʌ̃ʌrjã k'augba naawai pãachjã hagjö t'ʌbagk'am huguata muan pãragan, wajap'a k'ĩir k'aug nʌisit ha chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pãrau k'ap'ʌ nʌm, hãbmua k'ãijã hich di haig nem jĩgmienau nem jĩgk'aan bëeju hora k'ap'ʌ hak'iin, k'ãijã k'ãiba hich mag dau p'ug hëeju hʌdʌʌr hich nem jĩgk'apiba. ");
INSERT INTO noaH_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Magua muan pãragjã hich hagjöta, hajap'a k'ĩir k'aug nʌisit ha chirʌm. Pãrau hãbmuajã mʌ bëeju hora k'augba nʌm. Pãrau mʌ da bëebajupii nʌm hee, mʌch chi Hemk'ooi Hiewaan dëgölp dʌnʌʌuchëjugui hajim marag hichdëucha jaaumamua. ");
INSERT INTO noaH_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mag jajawagmamua hĩchab hich Jesuupai deeu hich bëe nʌm hora jãga naaju haai nʌm k'ap hamk'ĩir hawi magjim: ’K'anim nemjö patrón hãb simua hich chaaug maagpaawai hich chog hãb simʌg warm k'ʌʌn pörk'apinaa hich magʌgpai hich nem t'umaa jaau pʌabajëm. ");
INSERT INTO noaH_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maimua mawia mam sĩi hawia deeu bëewi hichdëu jaau pʌarrjö p'idk'a sim hoobaicheewai, ¿mag jöoi hich chog dʌ̈i honee sim dʌ̈i chi chogjã honee habaju k'ai? hajim. ");
INSERT INTO noaH_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mag hajap'a p'idk'a sim hoobaicheewai jöoirau warag hich nem t'um magʌgta t'ʌsĩepʌ̈ijugui hajim, hich dënjö k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mamʌ magba, mag hichig nem jaautarrjã hich hödegpai “Mʌ patrón chan da bëebam” hawi ");
INSERT INTO noaH_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nem k'aibag hich k'apeen jũrr hich jua heegpaim dʌ̈i hichdëu hampierr hanaa, nagjã hichdëu döm haig dönaa, t'achjã hichdëu k'öm haig k'ömʌn, ");
INSERT INTO noaH_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","chi dik'ʌ bʌ̃ʌrjã hirua nʌba sim hee pierrwai, mamagk'am hoobaichee, jũrr hichdëu warm k'ʌʌn dʌ̈i haajerr k'ãaijã hi gaai hat'uucha wʌnaa, p'idag heemuajã barpʌ̈inaa, chi k'aigbacharam k'ʌʌn dʌ̈i hãba sĩujugui hajim. Magbaawai gaai machgau hicharaucha bĩemamua hi hagäa hagäa habarjugui hajim. Magnaa maachigta, Maguata pãraujã mʌ deeu bëeju k'ap'ʌ naawai mag hichig nem jaau pʌarr t'um wau sĩerrjöta haju haai nʌmgui hajim, pãach k'apeen dʌ̈i, hich Jöoirau k'õsimjö. ");
INSERT INTO noaH_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Mag Hẽwandamau mʌg durr hi hagk'am hed hichdëu hauju wa hauba k'ãijã hisegju k'ʌʌnan, biek hãb daupeen diez narr k'ʌʌn hõor jua pʌr nʌm p'iesta hee wëtaag chi jua pʌrju hemk'ooi nʌ narr k'ʌʌnjöta nʌmgui hajim hich Jesuupai. Mak'ʌʌn daupeenau mʌgta hajim haajem: Hamachdëu ya chi jaai paju hurum ha hũrbaawai hagdaujö hamach lámpara panhap'a hi k'ĩirp'ee wëtju haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mamʌ mag k'ĩirju narrta cincopaita k'ĩirjug k'ap'ʌ naajim haajem, maimua hagjö cinco sĩi k'ĩirjug chuk'umjöta sĩsid hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mag k'ĩirjug chuk'umjö narr k'ʌʌnaujã hamachpierr hamach lámpara harrjierram haajem. Mamʌ mag harrtarrta chi aceite höbaadeewai deeu hag hee choo hawaag hawi k'ĩet chi aceite pʌ harrbajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pari chi k'ĩirjug k'ap'ʌ narr k'ʌʌnaun chadau hamach lámpara panhap'a wëtum dʌ̈i hĩchab k'ĩet hamach pipied deeum boteedeg aceite pʌk'a harrjierram haajem, höbaadeewai deeu hag hee choo hawaag hawia. ");
INSERT INTO noaH_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mamʌ mag chi hemk'ooi da bëeba haawai, nʌ nʌʌ hawi dap'ögk'abaadee k'ãidʌtk'a p'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mag ham k'ãidʌtk'a t'ʌnʌm heeta, ya hedacha pamamua, “Ya pãrau nʌ narr wounan hurum; p'iidʌtk'abat'ʌ̃ hi k'ĩirp'ee hoon maag” hajim hanʌm hãbmua. ");
INSERT INTO noaH_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Magbaawaita p'iidʌtk'awi hapuraa hamach lámpara k'ĩir k'aug nʌrrjëe haadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Magbaawai mag cinco k'ĩirjug chuk'umjö narr k'ʌʌnau hʌ̈u hamach k'ãai k'ĩirjugdam paraa narr k'ʌʌnag, “Keena, pãach aceitedam heem marag bʌchk'un choo deebat, ya maar lámpara t'õogpam” hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pari magbaawai chi k'ĩirjug paraa narr k'ʌʌnau hamag, “Marau pãrag deebamgui” hajierram hanʌm. “Marau pãrag deek'iin, pöm deeba haawai, pãarjã waaurwi maachjã waaurju. Mag k'ãai chi peerjem di haar mawi pãach hat'ee për hat'amit” hajierram hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hamachig magbaawai hamach hat'ee aceite për hawaan hërëubaadëmich, hamau nʌ narr hemk'ooi barchëjim haajem. Mag barchëwi hoocheewai hich dʌ̈i dubaag hʌ̈u k'ĩir k'aug narr k'ʌʌnan hʌ̈u hich dʌ̈i wai dubjim haajem, hich jua pʌrju haar. Mag p'ë wai dubwi chi puertdijã p'ãar sĩujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Maimua hag k'ur nʌʌ hawiata mag cinco hamach lámpara hat'ee aceite jʌraan wëttarr k'ʌʌn bëewi, “Señor, Señor, maar weeu hat'á, ya maar bëejimgui” hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pari magbaawai chi hemk'ooirau, “Mua pãar k'augba chitʌm. Mua dubpibamgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mag nem hĩgk'aadam jaauwi deeu marag magjim: ’Pãarjã daupeen k'ĩirjug chuk'u narr k'ʌʌnjö daaugajãr t'ʌbagk'amap'a nʌm k'ai, dauk'ananaa k'ĩir k'aug nʌisit. Pãrau mʌch chi Hemk'ooi Hiewaa bëeju hedjã k'augba, ni chi horajã k'augba nʌm. Mʌʌn dëgölpta barchëjugui ha jaaumajim marag. ");
INSERT INTO noaH_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mag jaaumamua deeu hich Jesuupai magjim: ’Mʌchta mʌg durr gaai chi Pörk'a pierrum hed mʌch hat'ee wajap'a p'idk'aajerr k'ʌʌnag hamachpierr nem wajap'am jigjuun, hãbmua hich piyonnaan dʌ̈i harrjöta hajugui hajim. Mag hich piyonnaan dʌ̈i mʌgta hajim haajem: Mag wounau deeum durr maagpamua hich piyonnaan hãbam haig t'ʌ̃rk'anaa hich p'atk'onau p'idk'amk'ĩir hamag jaau pʌajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hãbak'aíg p'atk'on cinco mil deewi, hãbak'aíg dos mil maimua hãbak'aíg mil deejim haajem, hichdëu hoowai hʌ̈u hamachdëu p'idk'amajupierr. Mag hamachpierr p'atk'on jigpʌ̈iwi petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mag hi petaawai chi piyón mag cinco mil hautarrau hag p'atk'onau p'idk'abaadëwi hag hʌ̃r deeu cinco mil gan haujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maimua hãbak'ai dos mil hautarraujã hagjö hagua p'idk'awi deeu hag hʌ̃r dos mil gan haujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mamʌ hãbak'ai milpai hautarraun mawia, jẽbdi k'örnaa warag hag hee bëp sĩujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Maimua hag k'ur nʌʌ hawia deeu bëejim haajem, chi p'atk'on pap. Mag bëewi mag hich maagpamua p'atk'on jigtarr hautarr k'ʌʌn deeu t'ʌ̃rk'ʌʌipʌ̈ijim haajem, k'arrchata hagdaujö ganmajĩ ha k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nacha chi cinco mil hautarr bëejim haajem. Mag bëewi hag hʌ̃r hichdëu cinco mil gan hautarr chi papag deechëwia hirig, “Señor, pua mʌrʌg cinco mil werpʌarrau hag hʌ̃r mua hagjö cinco mil gan haujim; cha k'ërʌm pʌ p'atk'on” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Magbaawai chi patrón jöoirau hirig, “Hʌ̈u k'ërʌmgui” hajim hanʌm. “Pʌ chadcha piyón wajap'amʌu; pua mua jaautarr t'um hagjö habarm. Mʌg p'atk'on pöm k'aba deetarrau pua jãgbarpí, jãgtarr jũrr mua pʌrʌg warag hʌ̃r deek'imgui” hajim hanʌm. Magnaa hirig, “Hierrag dubwia mʌ dʌ̈i honee habá” hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mag k'ur dos mil hautarr bëewi maguajã hagjö, “Señor, pua mʌrʌg dos mil deetarr hʌ̃r muajã hagjö dos mil gan haujim; cha k'ërʌm pʌ p'atk'on” haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Magbaawai chi patronau magʌgjã, “Pʌjã chadcha piyón wajap'amʌu; pua mua jaautarr t'um hagjöo habarmgui” hajim hanʌm hirig. “P'atk'ondam pöm k'aba deetarrau pua hʌ̈u jãgbarm k'ai, hag jũrr mua pʌrʌg warag hʌ̃r deejugui” hajim hanʌm. “Jãgbarpí pʌjã hĩchab hierrag dubwi mʌ dʌ̈i honee habá” hajim haajem magʌgjã hagjö. ");
INSERT INTO noaH_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Maimua milpai hautarrjã bëejim haajem. Pari magua chan warm k'ʌʌn dënjö p'idk'awi gan hauba harr haawai sĩi warag, “Señor, mua pʌ k'ap'ʌ chitʌmgui hajim hanʌm, pʌ hõor dʌ̈i hatcha sĩerrʌm. Mua pʌ p'atk'onau p'idk'awi gantarr hak'iin, pua sĩi chi hʌ̃rʌm mʌ jua heem k'echeu hauk'amgui” hajim hanʌm, “pʌ dën sĩi chik'am jua p'it'ur hatarrta pʌch dënjö haajeewai. ");
INSERT INTO noaH_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mʌchdëu mag k'ap'ʌ chitaawai, pʌ p'atk'onau mʌ p'idk'aba, warag mua jẽb heeta bëp sĩujim. Magtarr haawai cha simgui” hajim hanʌm, “pʌ p'atk'on pʌchdëu werpʌatarrpierr.” ");
INSERT INTO noaH_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Magbaawai chi patronau hirig, “Pʌʌn pʌchta k'aibagnaa k'usëug sĩerrʌmgui” hajim hanʌm. “Pua mʌ hõor dʌ̈i mag chitʌm k'ap'ʌ simta, ");
INSERT INTO noaH_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿jãgwi mʌ p'atk'on warag banco hee deen mabajĩ” hajim hanʌm jũrr hirig, “mʌg mʌch barbaicheewai hʌ̃rʌʌpai bãau sim hoochëmk'ĩir?” ");
INSERT INTO noaH_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Magnaa haig narr k'ʌʌnag warag mag mil wai sĩerr hi jua heem k'echeunaa jũrr diez mil wai sĩerragta deepi jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mag nem hĩgk'aa jaau höwia hich Jesuu magjim: ’Hich hagjöta sĩebahab hĩchab Hẽwandam hat'ee nem wau nʌmjã. Har Hẽwandam hat'ee nem wawaag nem par daúa hooba haajem k'ʌʌn dʌ̈in hirua hich garmuajã hajap'a haju, hamau chok'õgba hi hat'ee nem wau naawai. Mamʌ mag nem waumap'a nʌm k'ʌʌn dʌ̈i chan magba, hichdëu hamag nem deetarrjã warag ham jua heem k'echeu haumaju. ");
INSERT INTO noaH_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Magnaa, Mag chi patronau chi k'usëumie dʌ̈i harrjö, hamach k'ĩircha ham serbiibag p'ënaa k'ĩchag hee bark'ʌʌipi jaaujugui hajim, mamta ham gaai wajaug bëemk'ĩir. Mag hirua k'ĩchag ha sĩerran k'ĩmie durr higwiata mag sĩejim. ");
INSERT INTO noaH_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Mʌch chi Hemk'ooi Hiewaata hʌ̃gt'armua mʌch chognaan angelnaanau p'ʌʌr t'uur bëem hedan, mʌchta chi Rey haawai mʌch k'u juupjem wajapp'a sim gaaita jupchëjugui hajim, hõor dʌ̈i mʌchdëu k'ap nem wawaag. ");
INSERT INTO noaH_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Magbaawai hõor durrpierram k'ʌʌnta t'um mʌch chognaanag mʌch haig p'ë hau bëepiju. Mag t'um hãba biirdʌbaicheewaita oveja t'ʌajem pastorrau chi ovejanaandam hamach hag hap'a k'ĩet paanaa chĩbjã hagjö hamach hag hap'a k'ĩet paajemjö hajugui hajim, hõor dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mag jaaumamua hich Jesuu hi hiek mag hed hich dënk'a nʌm k'ʌʌnta hich juachaar gar t'ʌ̃rk'ʌʌinaa jũrr k'aigbam k'ʌʌnta k'ĩet hich juawë gar t'ʌ̃rk'ʌʌimaju haajem. ");
INSERT INTO noaH_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Magnaa mag hich juachaar gar nʌm k'ʌʌnag hichta Rey haawai hichdëuta hamag, “Pãar, mʌ Hayau hʌ̈u habarm k'ʌʌn, hierrag dubbat mʌ dʌ̈i jooba wënʌrraag” haju hanaabá. “Mʌg durr hompaa nʌwe mʌch Haai dʌ̈imua pãrag nem deeju hatarr hĩsta chadcha mʌ Hayau pãachigcha deegpamgui” haju hanʌm, “pãachdëu mʌ dʌ̈i hʌ̈u hatarr jũrr.” ");
INSERT INTO noaH_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Magnaa hamag, “Pãrauta mʌ jãsöo jẽedʌ k'itaawaijã hʌ̈u mʌrʌg t'achdam deejierramgui” haju hanaabá; “höbichaaga t'ʌnaawaijã hʌ̈u mʌrʌg dödam döpijierram; mʌch maba haajem k'ʌʌn hee chitaawaijã pãrauta pãach haig jẽramk'ĩir hʌ̈u mʌrʌg didam jaaujierramgui” haju hanʌm; ");
INSERT INTO noaH_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","“k'ajũadam chukk'u chiraawaijã pãrauta hʌ̈u mʌrʌg deek'ërjierram; mʌ mor mas chiraawaijã pãrauta hʌ̈u mʌ hoot'urjierram; cárcel deg preso chiraawaijã hagjö pãrauta hʌ̈u mʌ hoot'urjierramgui” haju hanaabá hich Jesuucha, ham k'ĩir jãsenk'a hiek'amamua. ");
INSERT INTO noaH_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mag hamachig magbaawai mag hi juachaar gar nʌm k'ʌʌnau jũrr hirig “Señor, ¿jãagwai mag pʌ jãsöo k'itʌm marau pʌ jãhogjĩ?” ha jëeuju hanaabá, hamachdëu hi k'ĩircha hooba haajerr haawai. “¿Jãagwai mag pʌ höbissi k'itʌm hoobaawaijã marau pʌrʌg dödam döpijĩ? ");
INSERT INTO noaH_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pʌ hiek mag maach haig jẽramk'ĩir marau pʌrʌg maach dijã jaaunaa k'ajũadamjã chukk'u haawai deejeejim hanʌm, ¿ma jãagwai hajĩma?” haju hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","“Pʌ hiek mag pʌ mor mas sĩewaijã marau hoot'urwi, cárcel deg preso sĩewaijã hagjö marau pʌ hoot'urjim hanʌm, ¿ma jãagwai hajĩ, marau pʌ hooba haajerrta?” haju hanaabá, jũrr hirig hamach garmua. ");
INSERT INTO noaH_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Magbaawai deeu hich Jesuu hamag, “Pãrau chadcha mʌchcha chan hoobajierram, pari pãrau jãg dau hap'ʌʌ k'it'ëe harr k'ʌʌndam dau haug k'augwi ham dʌ̈i jãgtarr haig, mʌchchata dau haug k'aug nʌmjö naabajieb” haju haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Warm k'ʌʌnag mag hiek'awi hichdëupai jũrr mag chi k'aigbam k'ʌʌn hich juawë gar nʌm k'ʌʌnag, “Jöpai mʌ haigmua chawag hërëubaadët” haju hanʌm. “Pãar mʌ Hayau chi maldisiem k'ʌʌn haawai pãadëu k'ĩmie durr mepeer hich chognaan dʌ̈i sĩemk'ĩir wautarr haarta hërëubaadët” haju hanʌm, “hõtdau huu wëjöm t'õojã k'augba hich mag sĩerrʌm hee naaimaag.” ");
INSERT INTO noaH_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mag hiek'amamua hĩchab hamag hamach k'ĩircha, “Pãrau chan mʌ jãsöo jẽedʌ k'itaawaijã mʌrʌg t'achdam k'öpibajierram; höbichag k'itʌmjã maachig, ‘Cha k'ërʌm dödam döju k'ai’ habajierram” haju hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","“Hõor mʌch k'augbam k'ʌʌn heemjö p'ʌʌrdʌ chitaawaijã pãrau mʌrʌg didam deebajierram, pãach haig jẽermk'ĩir. K'ajũadam chukk'u daaupamaa haawaijã put sördamjã deeba; mor massi chiraawaijã mʌ hoon wëtba; ni cárcel deg chiraawaijã mʌ hoon wëtbajierramgui” haju hanʌm hamag hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pari hamachig magbaawai jũrr hamau hirig, “Señor, ¿jãagwai mag pʌ jãsöo höbissinaa pʌch maba haajem heeta jẽerju dijã chukk'u k'itʌm marau bʌ̃ʌrjã pʌ hasekasbajĩ?” haju hanʌm. “¿Jãagwai mag pʌ k'ajũadamjã chukk'u daaupamam marau pʌ hoojĩ? ¿Jam mag pʌ mor massi marau hoojĩ, wa cárcel deg sim k'ãijã marau pʌ hoon wëtbajĩ?” haju hanaabá, hamachdëu magbajim hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pari hichig magbaawai, mak'ʌʌnagjã hirua magju hanʌm: “Chadcha mʌk'ʌʌn wounaan dau hap'ʌʌ wënʌrraawai pãrau bʌ̃ʌrjã ham dau haug k'augba harran, jãan mʌchchata pãrau dau haug k'augba nʌm k'abajieb, ham mʌchdëu pʌ̈iwiata jãg wënʌrrarr haawai” haju hanʌm hĩchab hamachigcha. ");
INSERT INTO noaH_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Maimua ya hãbmiecha hiek'a hoogpamua maar dak'ĩir, ’Muata mag hiek'abarm k'ʌʌnan k'ĩmie durrta wëtjugui hajim, mamta hich mag dau hap'ʌʌ wënʌrraag. Mamʌ hõor wäjäaun mag mʌch juachaar gar hat'am k'ʌʌnan, mʌch dʌ̈ita hich mag hiiu nʌisijugui hajim, hich mag wënʌrraag. ");
INSERT INTO noaH_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesuu mag mʌg hatag deeu hich bëeju k'ap hamk'ĩir mag jaau dichtarr k'ur, maach hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnagta deeu magjim hich higwi: ");
INSERT INTO noaH_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pãrau k'ap'ʌ nʌmgui hajim, mʌigmua k'ãai numí nʌm hee p'iesta Pascua burrju. Mʌg p'iesta heeta hõrau mʌch chi Hemk'ooi Hiewaa pʌr deejugui hajim, pakuls gaai meerp'ë t'õomk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ya mag p'iesta burrju k'ãai numpai waaur nʌm hee, p'adnaan chi pörk'a nʌm k'ʌʌn jöoin chi t'ierrnaan dʌ̈i hãba biirdʌjierram haajem, p'adnaan t'umaam k'ʌʌn pör Caifás di haig. ");
INSERT INTO noaH_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mag hãba biirdʌtarran, Jesús himeraa pʌr hauwi t'õopʌ̈yaag hãba hibëpaag hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mamʌ mag hi t'õopʌ̈yaag hẽk'a nʌmta hamachdëupai deeu, —Hõor pöm mʌg t'ʌnʌm meeuk'apimaaugau, mʌg p'iesta hee chan hi chig haba, p'iesta dichtarr k'urta t'õopʌ̈ijugui hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mag nʌm hee Jesús woundam Simón hanʌm di haig sĩejim, Betania p'öbör hee. Hich mag Simón hanʌmpai hibʌʌr wauwi “p'ĩe paraa k'itarr” ha t'ʌ̃ʌrjeejim. ");
INSERT INTO noaH_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mag di haig mes gaai hi t'ach k'ö hoo simta, hʌʌi hãb jʌ̃gdee didam durrk'udau alabastro hanʌm dën boteedidam wau k'itʌm dʌ̈i dubchëjim. Mag jʌ̃gdee nem parhẽpaaga sĩerrʌm. Mag waibëewi Jesús pör hee sĩi choopʌ̈ichëjim. ");
INSERT INTO noaH_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mag hi pör hee choobapʌ̈im hoobaawai maach chi Jesús dʌ̈i wënʌrrarr k'ʌʌn hee hãaur k'ʌʌn mʌ k'apeen meeuk'a p'öbaadëwi, —¿K'ant'eeta jãg jʌ̃gdee parhẽpagk'am sĩi hãr choobapʌ̈ima? hajierram, ");
INSERT INTO noaH_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","nem parhẽpag përpʌ̈iwi hag p'atk'onau dau hap'ʌʌm k'ʌʌndamag hʌ̈u nemdam hau deeju hãb sĩerrtá. ");
INSERT INTO noaH_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mamʌ ham mag hiek'a nʌm hich Jesuu hũr sĩerr haawai, —¿K'ant'eeta pãrau chik'am k'ĩir naaupi nʌma? Hirua hʌ̈uta jʌ̃gdeeu mʌ pör k'ooi sĩebahab hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mʌig heegar dau hap'ʌʌ k'it'ëem k'ʌʌnan pãrau hich jãg pãach dʌ̈i hoo wai wënʌrraju, mamʌ mʌ chan tag pãar k'ĩir chitabamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mʌg hʌʌirau jʌ̃gdeeu mʌg mʌ k'ooibarmʌn maach jöoin hi haawai maach meeunau haajemjö mʌ hauk'ërju hedam hat'ee hag nawe ya mʌ k'a p'uur sim k'abahab hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cha mʌ hiek'a chirʌm hiek'au mʌg hatag pawiajã durrpierr Hẽwandamau hõor peerdʌajem hiek jaau wënʌrrʌm dʌ̈i hĩchab mʌg hʌʌirau mʌ dʌ̈i mʌgbarmjã jaaub k'aba jaaujugui hajim. Mag, hooba harr k'ʌʌnaujã hĩchab hi hiigjeeju ha jaaujim hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Maach hi k'apeen hi dʌ̈i doce hogdʌba wënʌrraajerr k'ʌʌn hee hãb Judas Iscariote ha t'ʌ̃r sĩerrau p'adnaan chi pörnaan haar mawia ");
INSERT INTO noaH_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","hamag, —Mua pãachig Jesús pʌr deebaawai, ¿pãrau k'arr mʌrʌg p'ag nʌ? haimajim haajem. Magbaawai hamachdëu, —Marau pʌrʌg treinta piezas deejugui hajim hanaabá. Magbaawai chadcha hich magʌm gaai hi hëugar hi përpʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Magtarr haigmua Judaan sĩi hãba p'adnaan chi pörnaanag Jesús pʌr deejuuta hẽk'a nʌrraajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Maach jöoin hi haawai pan levadura chuk'u wauwia k'oojem hag seman hee ya warrpem k'ãai hãb hãspa hëebaadëm hed maach hich dʌ̈i wënʌrraajem k'ʌʌnauta marau hich Jesuug, —¿Jamta nemk'oo jaram ovejadam t'õonaa k'ö nʌ? ha jëeu naajim, k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mag hichig jëeubaawai hichdëu marag, —Jerusalén woun hãb sim haar hërëubaadët hajim. Maimua magʌg mua jaaupʌ̈i chirʌm habat: “Ya mʌch t'õju gayaa pamaawai, pʌ di haigta nemk'oo jaram ovejadam wauwi pãar dʌ̈i hãba k'öm k'õsi chirʌm” habat hajim chi wëtju k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Magbaawai chadcha hichdëu jaautarrjö, maar k'apeenau wëtwi, hichdëu jaaupʌ̈itarrjö jaauwimawi, hi na mag nemk'oo jaram ovejadam wauwimajierram. ");
INSERT INTO noaH_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Maimua hich hẽudee hök'arta bëewi, ya k'ĩsu haadëm hee maach doce hi dʌ̈i wënʌrraajerr k'ʌʌn t'um hãba hi dʌ̈i t'ach k'ö naajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mag hãba k'ö nʌmuata hichdëu marag magjim: —Cha mʌ hiek'a chirʌm hiek'au mʌig maach hãba nʌm k'ʌʌn hee hãbmua wir haig mʌ hoomap'am k'ʌʌnag mʌ pʌr deeju hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mag hũrbaawai, chadcha maar hök'ĩirjuu hap'öbaadëjim. Mag nʌm hiek'au jũrram k'ʌʌnau hirig, “Señor, hĩsin mua k'ãijãa hagam” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mag jũrram k'ʌʌnau hichig jëjëeu k'aawai magjim: —Chi mag wir haig mʌ k'aibag waujuun nau mʌ dʌ̈i hãbam t'ëp hee pan sĩ k'öbarmʌugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Magnaa hichdëu, —Hoo nʌm dau heyaa Hemk'ooi Hiewaa chadcha Hẽwandam hiek p'ã sĩsidʌm gaai jaau simjö wajapp'a dau haug wawaagpaama hajim. Pari hapk'iitʌ mʌ mag hap'ʌʌ hamk'ĩir wir haig mʌ përtarr woun. Jãgʌm wounaan t'aababa harr hak'iin hʌ̈ucha hak'amgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Magbaawai Judaau hichdëu k'abajim hamk'ĩir, —Maestro, hĩsin mua k'ãijãa hagam hajim. Magbaa Jesuu hirig, —Chadcha pʌchdëu k'abá pua k'ap'ʌ jaaubapʌ̈im; pʌchdëu k'abahab hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mag hiyʌ̈ʌ t'ach k'ö nʌmua Jesuu pandam jua hee haunaa, Hẽwandamag hag paar hʌ̈u hajim hanaa k'õreunaa marag hʌapʌ̈ijim. Magnaa, —K'öbat, mʌ mʌ morou hajim, chi pan higwi. ");
INSERT INTO noaH_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Maimua jũrr vino jarrdam hauwi, hag paarjã hagjö Hẽwandamag hʌ̈u hajim hanaa deeu marag hʌapʌ̈ijim. Magnaa, —Döbat, mʌʌn mʌ bagau; hich jãg hãbam jarr heepai döpetat hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mʌg jarr heem vinodam döbarmta warrgarwe Hẽwandamau hõor dʌ̈i hiek deeju haajerrau. Mamʌ mʌg hiek'an hiek hiiuriugui hajim. Mʌ bag mʌg vinojö k'itʌm hãrbarmuata Hẽwandamau hõor k'aibag t'um chugpaa haujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pari mʌg döbarmjö chan tag döba, hãba mʌchta mʌch Hayau t'umaam k'ʌʌn Pörk'apibarm hedta deeu hũwaai pãar dʌ̈i döjugui hajim. Pari mag hed maach hoobarm chan hĩsimjöpai k'aba, honeechata haju, nem t'ʌnʌm t'um chi hiiur haju haawai ha jaaujim hich Jesuu maachigcha. ");
INSERT INTO noaH_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mag maach hich dʌ̈i hãba wënʌrraajerr k'ʌʌn hich dʌ̈i hãba mes gaai hiyʌ̈ʌ t'ach k'ö haaipawi, meuk'aarjã Hẽwandam hiek Salmos hanʌm gayam hauwia, Olivo durrsĩig wëtjim. ");
INSERT INTO noaH_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mam panaa Jesuu marag, —Hẽwandam hiek p'ã sim gaai, “Mua chi pastor t'õobapäaiwai chi ovejanaandam parhooba haaidʌju” ha simjö, hĩsim hedaar pãrau mʌ mʌch hap barpʌawi t'umaa haaidʌtk'ajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mamʌ hũwaai p'iidʌwia mʌch hiiu chirsiewai pãar na mawia Galilea chiraimajugui ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Magbaawaita Pedroou jũrr hirig, —T'umaam k'ʌʌnau pʌch hap barpʌawiajã mua chan pʌ barpʌabamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Magbaa Jesuu jũrr, —Pedro, cha mʌ hiek'a chirʌm hiek'au nau hãt'ãrr bĩeju nawe biek t'ãrjup pua hõrag bʌ̃ʌrjã mʌ k'augba chitʌm hajuwai hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mamʌ Jesuu hichig magbaawai chará warag Pedroou hirig, —Pʌ t'õbaimam haar dʌ̈i t'õimaju hawiajã mua chan pʌ k'augba chitʌm ha hiek'abamgui hajim. Hirua magbarm dʌ̈i maach chi k'apeenaujã t'umaam k'ʌʌnau hich mag hiek'ajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Maigmua jũrr nemjĩirdö Getsemaní hanʌmʌg maar p'ë harrjim. Maimua mam barwi, —Mʌig nʌisit, mʌ chum hʌ̃gt'aag jëwaak'emgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Maimua t'ãrjuppaim k'ʌʌn dʌ̈i petajim. Mag hich dʌ̈i p'ë harrtarr k'ʌʌn hãb Pedro hajim, maimua tagam k'ʌʌn numí jöoi Zebedeo chaain hajim, Santiago Juan dʌ̈i. Mam paauk'abaimaawai ham hiek hök'ĩirjuuga haadëmua gaai machaaga haadëjim haajem, chi Jesús. ");
INSERT INTO noaH_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mag simua hamag, —Mʌʌn dëgölp gaai machgau hök'ĩirjuuga haadëm; hãba mʌch t'õjuuta k'ĩirju chirʌmgui hajim. Pãar mʌig nʌisit, mamʌ mʌ dʌ̈i dauk'ana habat. Hoob k'ãimiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hamag mag jaau pʌawi hichin ham bigaau ham warp'aapai sĩeimajim haajem. Magnaa jẽk'ʌt t'ʌk'öonaa k'ĩeb jẽb gaai dagau dʌrnaa hʌ̃gt'aag jëeumamua, “Tata, pua k'õs hak'iin, hatcha mʌ dau hap'ʌʌ hapibak'amgui” hajim hanʌm. “Deeum nem waubarmuajã hagjö hõor peerdʌ hauju hayaa hak'iin, mʌ gaai machag mʌgcha hãwatbak'am. Pari mʌchdëu k'õsi chirʌmjö k'aba, pʌchdëu k'õsimjöta mʌ dʌ̈i habá” ha jëeumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mag hich Hayag jëeu sĩi hawi ham hoon bëejim haajem. Maimua hoocheewai ham k'ãi nʌmta hoochëjim hanaabá. Magbaawai Pedroogta, —Pãar chan horadam hãbjãta mʌ dʌ̈i dauk'ana k'aba nʌm. ");
INSERT INTO noaH_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jãg k'ãi nʌʌ haju k'ãai Hẽwandamagta jëeu nʌʌ habat'ʌ̃ hajim hanʌm, dösãtag hʌdʌʌr pãach t'ʌ haupim hugua. Mua hoowai pãrau pãach hödiiwan chadcha jëeum k'õsi durrumta, pari dap'ökgauta pödbam hajim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Maimua hichin deeu hũwaai mawia jëeubaadëmua hich Hayag, “Tata, pua mʌ mʌg dau haug waupibaju hayaa hak'iin hʌ̈u hak'amgui” ha k'itaajeejim hanʌm; “mamʌ hichiita mʌ hap'ʌʌ haju haai chirʌm k'ai, hagjö hʌ̈u sim. Mʌ dʌ̈i pʌchdëu ham haig habá” ha jëeumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mag jëeu sĩi hawi deeu ham hoon bëewaijãh, mag hi k'apeen hirua p'ë harrtarr k'ʌʌn dap'ökgau pödjã dau hẽeba sĩi k'ãidʌtk'a t'ʌnʌmta hoochëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mag k'ãidʌtk'a t'ʌnʌm hoobaichee deeu hich sĩerr haar mawia hich hag hiekpai deeu hich Hayag jajawagmajim haajem. Ma biek t'ãrjupam hajim haajem, mag jëeu sim. ");
INSERT INTO noaH_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Maimua hũwaai hoon bëewaijã hagt'a hich k'apeen k'ãidʌtk'a t'ʌnʌm hoobaichee hamag, —¿Hagt'a pãar sĩi k'ãi gaaita nʌ? hajim hanʌm. Ya pekau pöm sĩsidʌm k'ʌʌnag mʌch chi Hemk'ooi Hiewaa pʌr deeju hora pabaichëbahab. ");
INSERT INTO noaH_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","P'iidʌtk'abat'ʌ̃, maimua maach k'apeen haar wëttarraugui hajim hanʌm. Mʌ hoomap'am k'ʌʌnag mʌ pʌr deeju wounan ya dakpa hurumgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mag maar haig bëewi hagt'a hich Jesús maar dʌ̈i hiyʌ̈ʌ dʌnʌm hee, hich mag maach hi k'apeen doce narr heem hãb Judas hanʌmta hõor pochag hurajim. Mag wëdurum k'ʌʌnan hãaur k'ʌʌn espaar jua panhap'a bëe t'ʌnaawai tagam k'ʌʌn pa dʌ̈ijã bëe t'ʌnaajim. Mak'ʌʌn, p'adnaanau jöoin chi pörnaan dʌ̈imua pʌ̈itarr k'ʌʌn hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mag chadcha hõor pochag bëewi ya chi Judaau hag nawe, “Nau mua pãach dak'ĩir k'ĩir hʌ̃ʌ hat'amta pʌr hat'at” ha jaau wai sĩerr haawai ");
INSERT INTO noaH_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","hich dʌ̈i wënʌrrʌm k'ʌʌn dak'ĩraa hichdëu jaautarrjö Jesús dʌ̈i hãba dʌnʌʌuwimawi hirig, —Maestro, ¿jãgpai chirʌ́? hanaa hi k'ĩir hʌ̃ʌ hat'ajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Magbaa Jesuu hirig, —Pʌch hõor hawaan bëetarr jöpai pʌr hat'aad perá hajim. Magbaawai tagam k'ʌʌnau dʌ̈i haig bëewi Jesús pʌrp'öbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mag hi pʌrp'öbaadëm hoobaawai maar heem k'ʌʌnau hãbmua hich espaar sʌrr ha jẽu hat'awi chi p'adnaan t'umaam k'ʌʌn pör hag chog haig sĩerr kachta hoort'ubapʌ̈ijim. ");
INSERT INTO noaH_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Magbaawai Jesuu hirig, —Jöpai pʌch espaar hich deg p'ĩ sĩubá hajim. Pua k'augba sĩeb hajim, esparau wërbʌnaa hõor k'ëch nʌm k'ʌʌn hagjö esparauta k'ëchmaju. ");
INSERT INTO noaH_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mua mʌch chig hapibaju hak'iin, mʌch Hayag jëeubaawai hirua mʌ t'ʌamk'ĩir Hẽwandam chognaan pöoma milam k'ʌʌn hap'a doce ejércitos k'ãijã deepʌ̈ijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mamʌ mʌch t'ʌamk'ĩir mua jëeubaawai mag hõor pöm deepʌ̈ik'iinjã, ¿jãga Hẽwandam hiek p'ã sĩsidʌm gaai mʌ higwia jaau sim t'um hich hagjö habarju? hajim Pedroog. ");
INSERT INTO noaH_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mag hiek'apʌ̈iwia jũrr hich pʌr hawaan bëetarr k'ʌʌnagta, —¿Pãrau hoowain mʌʌn sĩi hõor nem jĩgk'anaa hõor t'õomiejöta chirab hajim jãg pãrau sĩi mʌ haig jua hee jierrnempan happai bëeg hat'ee? Hag na hed hëepierr pãrag mua Haai hi jëeujem deg Hẽwandam hi jaaujeewai bʌ̃ʌrjã pãrau mʌ pʌr haubajierram. ");
INSERT INTO noaH_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pari pãrau hĩs mʌ dʌ̈i mʌmʌgk'amʌn, jãan warrgar Hẽwandam hi jaaumienau jaautarr t'um hag heyaa höbërmk'ĩrau hajim. Ya hirua mag hiek'abarm hee, hĩchab maach chi k'apeenaujã chi Jesús hich happai werpʌawia parhoob dʌrmid p'öbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mag hi pʌr hawaan bëetarr k'ʌʌnau warre p'adnaan pör Caifás haarta hat'aadëjierram, mamta Moiseeu ley p'ã pʌarr jawaag chi machnaan dʌ̈i jöoin chi t'et'emnaanpa dʌ̈i hãba biirdʌ narr haawai. ");
INSERT INTO noaH_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mag hamau hi hat'aadeewai Pedro hiek hiruata warppaimua hoopʌ̈pʌ̈igmamua mag chi p'adnaan pör haig di hũjãrr dubimajim haajem. Mag dubwi, “Mʌigmua hook'im jãga haju k'ai” hawia, Haai hi jëeujem di t'ʌajem k'ʌʌn hohoodö nʌm haig dʌ̈i jupimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Maagwai p'adnaan chi pörnaanau judionaan Asamblea heem k'ʌʌn dʌ̈imua chi Jesuu nem wauba harrta sëuk'a hi gaai t'ʌpʌ̈iju hẽk'aajeejim hanaabá, magʌm gaaimua hi t'õopäaig. ");
INSERT INTO noaH_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mamʌ par mag jũrram k'ʌʌnau sëuk'a hi gaai nem parhooba t'ʌpʌ̈iju hẽk'a nʌmjã pödba haajeejim haajem. Mamagk'am hee, hõor numí chi sëumien bëewi, ");
INSERT INTO noaH_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Mʌg wounau maar dak'ĩir, hiruan mʌg Haai hi jëeujem di pogueupʌ̈inaa k'ãai t'ãrjuppaim hee deeu hëu dʌnʌʌuju ha hiek'a sĩejimgui hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Magbaawai chi p'adnaan pöröu dʌnʌʌunaa Jesuug, —¿Pua ham hiek'a nʌm hũr chirʌ́? ¿K'an jãgwi jãg pʌ hiek'amap'a sĩ? ¿Pua chadcha mag hiek'ajĩ wa hiek'abajĩ? Jaaubá hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pari magʌmjã Jesús bʌ̃ʌrjã jʌ̃ʌ haba, warag k'ĩuu sĩsijim haajem. Mag hich hiek hʌ̈k'aba habaawai deeu hirig chi p'adnaan pöröu, —Maach Hẽwandam hich mag hiiu sĩerrʌm hiek gaai t'ʌwi muata pʌrʌg “Jaaubá” ha chirʌm. ¿Pʌʌta chadcha Hẽwandam Hiewaa hichdëucha jʌr hauwia pʌ̈iju jaaujerrá? Marag jaaubá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Magbaa Jesuu hirig, —Pua k'abá hag heyaa jaaubapʌ̈im hajim hanʌm. Mʌ cha hiek'a chirʌm hiek'au mʌg woun Hemk'ooi Hiewaa Hẽwandam chi jua t'ierr bigaau hi juachaar gar hoo sim pãrau pãach daujãau hoowi hedjã baug hee hurumjã hoojurau ha hiek'ajim haajem, haig narr k'ʌʌn dak'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mag hũrbaawai chi p'adnaan pöröu hich k'ajũa mor gayamta sʌrr habarmʌn, warre nem pöm jẽ werbpʌ̈ijim hanaabá. Magnaa, —Mʌg wounau hiek'a sim chan hʌ̈u k'aba sim. Maach wounaan t'um hãba t'ʌnʌmta hiita mag Hẽwandam Hiewaa hanaab. Ya pãrau pãach jʌ̃gʌucha hũrbarm. ");
INSERT INTO noaH_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿K'ani maadëu tag hũrm hig nʌ? hajim hanʌm, hich k'apeenag. Magbaawai mag k'apan haig pos t'ʌnarr k'ʌʌnau, —Hí chadcha kulp pöm sĩebahab; magua warre t'õopʌ̈iju haaita simgui hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Magnaa hi k'ĩir gaaijã hichö t'unaa hi gaai mas waumajim hanaabá. Pogk'a hi k'ĩidadcha juajãau deenaa ");
INSERT INTO noaH_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","hirig, —Pʌchta chadcha warrgarwe hich Hẽwandamaucha jʌr hauwia pʌ̈iju haajerr k'ai, magan jaaubá: ¿k'aíuta pʌ k'ĩidadcha dee sĩ? haajeejim hanʌm jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mag chi t'et'em k'ʌʌnau Jesús dʌ̈i mamag k'aawai Pedro hiek hi daaugajãr hũjãrr hoo chirajim haajem. Mag hi hoo chirʌm haigta, mag degam hʌʌi chi di k'ʌʌn chog bëewia hirig, —Pʌjã hĩchab jãg Jesús Galileapierr dʌ̈i nʌrraajemʌugui haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pari hichig magbaicheewai hi hiek hirua t'um haig narr k'ʌʌn dak'ĩir, —Mua k'augbam pʌ k'an hata hiek'a sim k'ai; mua magʌm wounan k'augba chitʌm ha chirajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hichig magbaicheewai hi hiek mag hich chirarr haigmua daaugajãrm puertdi haar majim haajem. Mamʌ mamjã hagjö deeum hʌʌirau hi hoobaawai maguajã hich haig narr k'ʌʌnag, —Jãg wounan Jesús Nazaretpierr dʌ̈i nʌrraajemʌuwai hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pari magbaawai magʌgjã hichdëu, hirua magʌm Jesús k'augbam ha chirajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Maimua magtarr k'ur nʌʌpai hawi hi hiek maig hich dʌ̈i di hũjãrr narr k'ʌʌnaupai deeu hirig, —Marau hoowai pʌjã chadcha hi dʌ̈i wënʌrraajerr k'ʌʌn heemʌu. Pʌ hiek'a sim gaaipai merag chukk'u simgui hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Magbaawaita hirua warag k'ĩir mor chigpai hiek'amamua, —Chadcha mua magʌm wounaanjã k'augab chitʌmta pãrau mʌrʌg mag naaba ha chirajim hanaabá hich Pedroou. Mamʌ hirua mag hiek'abapʌ̈im dʌ̈icha hãt'ãrrta kekerekee hahbar. ");
INSERT INTO noaH_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mag hãt'ãrr hiek hũrbaawaita hich Pedroou jaauwai hi k'ĩir heyaa dʌhnʌisijim hanʌm, Jesuu hichig “Nau hãt'ãrr bĩeju nawe pua biek t'ãrjup hõrag mʌ k'augba chitʌm ha hiek'aju” hatarr. Mag k'ĩir hee dʌnʌisim habarmʌn chadau gaai machaaga haadëmua dawag höbërwi warre hö jãsenag haadëmua bĩe chirʌʌ hajim haajem, hichdëu jaauwai. ");
INSERT INTO noaH_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Maimua ya hãspabaadeewai p'adnaan chi pörnaan judionaan tagam k'ʌʌn hagjö chi t'et'em k'ʌʌn dʌ̈i biirdʌnaa deeu hiek'awi warre Jesús t'õopʌ̈iju k'ĩirju p'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mag hamach hap hiek'awi, jʌ̃gadau jua bʌʌrk'anaa, Pilatoota Romaam reíu pʌ̈iwia gobernadork'a sĩerr haawai, hirigta t'õopi jaaumk'ĩir hi haar harrjierram. ");
INSERT INTO noaH_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mag Jesús t'õopi jawamk'ĩir Pilato haar jua bʌʌrnaa hat'aadëm hũrbaawai chi Judaau deeu hũwaai t'umaa hewag k'ĩirjuwia, chi p'adnaan pörnaan chi t'ierrnaan dʌ̈i nʌm haar mawi, mag Jesús paar hichig p'atk'on p'agtarr t'um hũwaai hamag deeimajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mag deeimawia magjim hanʌm: —Jãg woun bʌ̃ʌrjã nem k'aigba wautarrjã chuk'u k'itʌmta pãrag pʌr deetarr gaaimua, mʌʌn chadcha pekau pöoma waubarm. Jã chan bʌ̃ʌrjã hiekk'õr chuk'u sĩejimgui hajim hanʌm. Pari magbaawai hamachdëu jũrr hirig, —¡Hidëu mag simgui hajim hanʌm; maata magan maar gaai mas sĩeba! Maigjã pʌchta pʌ mag chirabahab hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hamachdëu hichig magbaawai mawia chi p'atk'on Haai hi jëeujem deg barpʌawi higbaadëjim haajem. Mag mawi, hichdëupai pa gaai hʌ̃gt'aa jʌ̃gad jʌ̃naa, t'oom k'ẽu hich hö gaai jʌ̃naa, baudʌ hich hö jorrkaa t'õojim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mag barpʌabajeewai p'adnaan chi pörnaanau chi p'atk'on p'ë hauwi, —Mʌg p'atk'on hõor t'õoju paarta p'agtarr haawai pöd maadëu ofrenda hee hausĩubamgui hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Maimua hag k'ur deeu hamach hap hiek'awia hag p'atk'onau jẽbta për hauju hajierram haajem, durr warpmua hõor bëe nʌm k'ʌʌn meebaawai hag hee hauk'ëraag. Mag p'atk'on Jesús param harrau jẽb për hautarr, Campo del Alfarero ha t'ʌ̃r sĩejim. ");
INSERT INTO noaH_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mag jẽb gaaita Judaau hich t'õotarr haawai hĩs hewag pawiajã mag jẽb hagt'a “bag hãrtarr param p'atk'onau jẽb për hautarr” ha t'ʌ̃r sĩerrʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hamau mag p'atk'onau mag jẽb për hat'am haig, hĩchab magju nawe Hẽwandam hi jaaumie Jeremías k'ararrau hiek'atarr heyaa höbërjim hagjö. Hirua nawe hiek'atarr mʌg hajim: “Israelnaanau chi precio jaautarrpierr treinta piezas hauwi ");
INSERT INTO noaH_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","hag p'atk'onau el Campo del Alfarero për haujierram, maach Pör Hẽwandamau mʌrʌg jaautarr hipierr” ha p'ã sim. ");
INSERT INTO noaH_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mag harrwi chadcha Pilato na wai naaimajim haajem. Magbaa Pilatoou hirig, —¿Chadcha pʌʌta judionaan Reí? ha jëeujim hanʌm. Magbaawai Jesuu hirig, —Pua k'abá k'ap'ʌ jaaubapʌ̈imgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mamʌ hirua mag hiek'abarm hũrbaawai p'adnaan chi pörnaanau chi t'et'em k'ʌʌn dʌ̈imua warag hi hëugar sëuk'a hi k'aibag jaaup'öbaadëjim hanaabá. Mamʌ hich k'ĩir mamagk'amjã Jesuu bʌ̈dam hãbjã hiek'aba, warag k'ĩuu sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mag ham hiek hʌ̈k'aba haawai deeu hich Pilatooupai hirig, —Pua chan pʌch k'ĩir mag hiek'a nʌmjã hũrbahab, sĩi k'ĩuu jʌmaag hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pari par hich Pilatooucha magtarrjã, ni bʌ̈ hãbjã jʌ̃ʌ habajim haajem. Mag hich k'ĩircha hiek'a nʌmjã sĩi k'ĩuu hichig k'abamjö sim hoowi Pilatoou hich hödegpai, “Mua hõor mʌg hooba chitʌmgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mag hag nawejã mag p'iesta hee paawai hõrau jaaubarm presota chi gobernadorrau sĩi hich jãg höbeerpäaijeejim. ");
INSERT INTO noaH_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Maagwai preso hãb sĩi t'ʌ̃rp'öo sĩerrʌm sĩejim, Barrabás ha t'ʌ̃r sim. ");
INSERT INTO noaH_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mag hõrau jaaubarm presota sĩi höbeerpäaijerr haawai, Pilatoou hich hödegpain Jesuuta sĩi höbeerpʌ̈im k'õsi sĩerr haawai, mag hõor pöm wëjömʌg jëeumamua, —¿Chijãata pãrau sĩi hich jãg pʌapʌ̈ipim k'õsi nʌ: Barrabás, wa Jesús hich Hẽwandamau pʌ̈iju haajerr hanʌm? ha jëeujim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chi Pilatoou k'ap'ʌ sĩejim haajem, hamau hamachdëu Jesuu nem wau nʌrrarrjö pöd nem waubam gaaimuata mag hi pʌr dee wai narr. ");
INSERT INTO noaH_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Magnaa hõor dak'ĩir hich juupjem sie gaai hoo sĩsijim hanʌm. Mag hoo simta hi hʌʌirau hirig, —Jãg wounan hõor wajap'amʌuwai; hoob jã chan k'aibag waupi jaaum. Hedaar mʌ k'ãai k'õrk'aa k'aibag k'ãai k'õrk'a hʌajim hi gaaimua ha jaaupʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mamʌ mag nʌm hee, chi p'adnaan pörnaanau tagam k'ʌʌn chi t'et'em k'ʌʌn dʌ̈imua warag hõor wawik'a t'ʌnʌʌujim hanʌm, sĩi Barrabaata höbeerpi jaaunaa Jesús t'õopi jajaau hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ya mag wawik'a t'ʌnʌm hee, deeu chi gobernadorrau jëeumamua hamag, —Mʌg numí nʌm haig, ¿chijãata pãrau sĩi chigjã haba höbeerpʌ̈ipim k'õsi nʌ? ha jëeujim hanʌm. Magbaawai hamachdëu Barrabaata höbeerpi jajaau haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Magbaa deeu Pilatoou hamag, —Magan jãg Jesús mag warrgarwe hich Hẽwandamau pʌ̈iju jaaujerrta mʌg nʌrrʌm hanʌm dʌ̈i ¿mua jãgajuma? hajim hanʌm. Magbaawai t'umaam k'ʌʌnau hihãba, “Pa gaaita meerpbapʌ̈pʌ̈i” haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Magbaa, —¿Pari k'an nemta hirua k'aigba waujĩma, pãrau mag warre hi t'õopi jaau nʌm? hajim hanʌm chi Pilatoou. Hichdëun sĩi pʌapʌ̈im k'õchgau par mag jëeu hohook'amjã warag pa gaaita meerppi jajaau haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoou Jesús pʌapʌ̈iju hẽk'a nʌm pödba sĩi waragta hõor p'ogdʌmam hoobaawai dö haibëepiwi t'umaam k'ʌʌn dak'ĩir jua sũgpʌ̈ijim haajem. Magnaa, —Pãrau mʌg woun hiekk'õr chuk'u simta t'õomʌn mʌ chan bʌ̃ʌrjã kulp chuk'u chirʌm, maan ya pãach happaim nemeu; mʌ gaai t'ʌmiet hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Magbaawai t'umaam k'ʌʌnau sereu p'öbaadëmua warag, —Marau pʌ gaai t'ʌbam; maachta maach chaain dʌ̈i kulp paraa nʌisibajupa hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mag chadcha hamachdëu jaau narrjö, Pilatoou Barrabaata sĩi höbeerpʌ̈iwia, Jesús wʌpi jaaunaa, pakuls gaai meerppʌ̈imk'ĩir warre soldaaun jua hee t'ʌsĩepʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Magbaawai gobernador di haar harrwi mam pabaimaawai chi soldaaunau hamach k'apeen k'apan t'ʌ̃rk'a hauwi hamach jãrrcha wai naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Magnaa hi k'ajũa hʌ̃rʌm hẽerpʌ̈inaa, jũrr dewam p'uríhi simta jũapipʌ̈inaa, ");
INSERT INTO noaH_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","miu dën wërjũchk'a simta pörsirk'a jũapipʌ̈ijierram haajem. Magnaa hĩchab hi juachaar gar padamjã joot'ʌpʌ̈ijierram hanaabá. Magnaa mag hamach rey hanʌmua hi wau nʌmuata hi k'ĩirp'ee jĩepör p'õbk'anaa, —¿Jãgpai chirʌ́ Judionaan Rey? haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Magnaa jũrram k'ʌʌnau bëewi, hi gaai hichö t'unaa, hi jua hee hamachdëu padam joopʌ̈itarraupai hi pörchajã wʌmaajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mag hi dau hap'ʌʌ wau wai nʌʌ hawia, hamachdëu hirig k'ajũa jũapitarr deeu hẽer hauwia, hich k'ajũa chaardamta deeu jũapinaa, maimuan chadau pa gaai meerp'ëpäain hat'aadëjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mag wai höbërwi hag dʌ̈i wëtumua k'ʌd hee woun hãb Simón hanʌm deeum p'öbördam Cirene hanʌm heem dʌ̈i t'ẽujierram haajem. Mag dʌ̈i hoobaawai chi soldaaunau jũrr hajués magʌgta Jesuu pakuls harrmatarr harrpijierram. ");
INSERT INTO noaH_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mag harrmamua buchagdam Gólgota hanʌm haar paauk'abaimajim. Mag Gólgota haawai “pörpá durrsĩ” haawaiu. ");
INSERT INTO noaH_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mag mam paauk'abaimaa vino hiel hanʌm dʌ̈i nem hachaaga waaurëu simta dömk'ĩir deejierram. Mamʌ Jesuu sĩi bʌ̃rʌʌ dö hoowi tag döbajim. ");
INSERT INTO noaH_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ya pakuls gaai meerp'ënaa jiirjop sĩuwia, hamach chi meerp'ë narr soldaaunaupai, k'aíuta chi k'ajũa jʌ̃abarju k'ai hawi, jẽb gaai mokdaudam baraag paauk'ajierram haajem, mag nʌmua gan haumaag. ");
INSERT INTO noaH_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Maimua mag chi k'ajũa hamachpierr wai nʌisiewai t'ʌa nʌmua warag k'ʌt hohoodö hap'öbaadëjim hanaabá, chi pakuls dak'a. ");
INSERT INTO noaH_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hi meerp'ë jiir wëjöm pör hʌ̃r hẽsapdau p'ãk'a sim gaai jaau sĩejim, k'an gaaimuata hi mag wai naajĩ. Chi hẽsapdau gaai “Chamʌʌta Jesuu, Judionaan Rey” ha p'ã sĩejim. ");
INSERT INTO noaH_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mag hi meerp'ë wai nʌm dʌ̈i hĩchab hi bigaau chi nem jĩgmien numí hagjö pa gaai hamach k'ĩk'ĩetdö meerp'ë sĩujierram: hãb hi juachaar gar, hãb hi juawë gar. ");
INSERT INTO noaH_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mag hi meerp'ë wai narr hõor diichjem dak'a harr haawai dich nʌm k'ʌʌnaujã hi wau nʌm hiek'au warag hirig heerpanaa hʌ̃i p'ʌʌrp'ʌʌrnaa, ");
INSERT INTO noaH_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Wa jãgʌm k'aba puan mag Haai hi jëeujem dijã t'um pogueupʌ̈inaa deeu k'ãai t'ãrjuppaim hee hëu dʌnʌʌuju haajerrta, jãg pua wir haig pʌchpai peerdʌ haubama. Pʌ chadcha Hẽwandam Hiewaa k'ai, magan jãg pakuls gaaimua heeg hʌʌrbabaad haajeejim hirig. ");
INSERT INTO noaH_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mag nʌm dʌ̈i chi p'adnaan pörnaanau, Moiseeu ley p'ã pʌarr jawaag chi machnaanau tagam k'ʌʌn chi t'ierrnaan dʌ̈imua hirig, ");
INSERT INTO noaH_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Deeum k'ʌʌnan peerdʌ hautarrta pʌchta pödbahabma. Pʌ judionaan rey k'abá; maar dak'ĩir jãg pakuls gaaimua heeg hʌʌrbabaad. Mag hoobaawain chadau marau hʌ̈k'aju haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pʌ hiek mag Hẽwandamau pʌ chig hapibaju hanarr haawai, chadcha hichdëu pʌ k'õsi sim k'ai, nau hirua pʌ k'aigpër hauju. Magaag pʌchdëuchajã pʌ Hẽwandam Hiewaa hanarrau haajeejim hirig, ya pakuls gaai pawiajã. ");
INSERT INTO noaH_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jũrram k'ʌʌnau hirig mamagk'am hũrwi mag chi k'aibagnaan numí hi bigaau hagjö jiir hʌid t'ʌnarr k'ʌʌnaupa warag hi wau hiek'a naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hedausĩe t'ʌnʌm hee, dëgölp hedau k'ĩbaadëm habarmʌn sĩi warre hedaramjöta jöisijim. Mag k'ĩ t'ʌnʌʌ hawia hedau p'ʌʌibaajër las tres naata deeu haardʌbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Magbaadëm hee Jesuu t'et, “Elí, Elí, ¿lema sabactani?” hajim hanaabá. Mag sim haig maach meúan, “Aay, Hẽwandam, ¿k'ant'eeta pua mʌ mʌg dau hap'ʌʌ chirʌmjã mʌrʌg hoobamjöo haadëma?” ha k'itʌm hajim. ");
INSERT INTO noaH_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hãaur k'ʌʌn haig narr k'ʌʌnau mag hi hiek'abarm hũrtarr haawai jũrr hamach k'apeenag, —Keena, pãadë hũrbat: Maguan warrgar Hẽwandam hi jaaujerr Elías k'ararrta hich haig t'ʌ̃r simwai hanaajim, hirua hiek'atarr k'augbam gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hirua magbarm bʌ̈rre hãbmua k'ap'igbaadëwi, putjö hũhũp'ë k'itʌm gaai vino hadchuchúhu simta dorrdʌnaa waibëewi, pa gaai bʌʌrnaa hi hi haig hʌa haujim, hag gaaim bereu dömk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pari hãbmua hi dʌ̈i mamagk'am hee, hãaur k'ʌʌnau jũrr, —Hidëu hi sĩubá, daau nau Eliaau hi jãigmua heeg jiirpʌ̈yaan pierrju haajeejim. ");
INSERT INTO noaH_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mag jöchk'ërʌʌ hawia, t'et häa ha k'itawia, warag chaaupabaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mag hi chaaupabaadëm dʌ̈i hĩchab Haai hi jëeujem deg hierrgajãrcha put nem parrg t'uur hëu wëjorrta hʌ̃gt'aamua heeg sʌrr habarmʌn warre jãrrcha t'oop'em numiita jijirar jöisijim. Magbarm dʌ̈i hʌʌur t'eega duuibaadëmua mokpörpa t'örrchëchëuk'am dʌ̈i ");
INSERT INTO noaH_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","hõor hauk'ërtarr jẽbdipa weeudʌtk'amam hee, k'ëchtarr k'ʌʌnta deeu p'iidʌtk'awi hiiu nʌrrjëe haadëjim. Mag deeu hiiutarr k'ʌʌn hʌ̈u wajap'a Hẽwandam hiek hʌ̈k'a durrumta hötarr k'ʌʌn hajim. ");
INSERT INTO noaH_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mak'ʌʌn Jesús hiiu p'iidʌtarr hẽudee hamach jẽbdegmua höbërdʌtk'awi Jerusalén p'öbör hee wëtjierram. Mag ham p'öbör hee naaimatarrjã hõor k'apank'am k'ʌʌnau hoojierram. ");
INSERT INTO noaH_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Magbaawaita capitán soldaaun dʌ̈i Jesús pakuls gaai jiir wëjöm heegar narr k'ʌʌnau mag hʌʌur t'eeg duuibaadëm hee, mamagk'am hoop'öbaadee jãp'ierr nʌm hiek'au warag, —Mʌg wounan chadchata Hẽwandam Hiewaa hajim hajierram. ");
INSERT INTO noaH_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mag hi pʌr hauju nawejã hĩchab hʌʌin hi juag hoojerr k'ʌʌn k'apan Galileamua hi dʌ̈i bëetarr haawai mak'ʌʌnau hi dʌ̈i mamagk'am warpmua hoo naajim. ");
INSERT INTO noaH_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mag warpmua hoo narr hee naajim: María Magdalena, hãbak'ai María, Santiago dʌ̈i Josenaan ham hãd, maimua jöoi Zebedeo chaain hãdjã dʌ̈i haig sĩejim. ");
INSERT INTO noaH_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Maimua ya p'ãarmam hee, rik José hanʌm bëejim. Hich mag woun Judea durr p'öbördam Arimatea hanʌm haram hajim. Chi Jesús t'õoju nawe ya hichdëujã Jesús higar sĩejim. ");
INSERT INTO noaH_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mag sĩewai Pilato haar mawia ya Jesús mee k'ërʌm mordam hauk'ëraan maag jëeuwimajim haajem. Mag jëeubaimaa Pilatoou hich soldaaunag deepi jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Magbaa Joseeu mawia, ya chi meemdam heeg paa hauwi, harrwi, dĩesdam memerk'ögjã chuk'u bäpp'ä k'itʌm hee pʌrëunaa, ");
INSERT INTO noaH_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","hag nawe hichdëu hich hat'ee durrbʌ̈ k'õpag hee jẽbdi hiiur k'örpitarr hee hauk'ërt'urjim, wajapcharan hich jẽb gaaima. Magnaa mokpör pöm simua chi jẽbdi hi hee wajap'a joot'ʌ pʌawia higbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mamʌ mag chi José Arimateapierr petamjã María Magdalena chan maba, hãbak'ai María dʌ̈i hamach numpai chi hap'ʌʌmdam hauk'ërtarr jẽbdi haig hohoodö nʌisijim. ");
INSERT INTO noaH_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hag noram sĩi jua hʌ̃ʌijerr hed, wajapcharan sabarhedma, chi p'adnaan pörnaan Moiseeu Hẽwandam hiek p'ã pʌarr wajapcha hʌʌrk'aajerr k'ʌʌn dʌ̈i Pilato haar wëtwia ");
INSERT INTO noaH_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hirig, —Marau k'ĩir heyaa nʌmgui hajim hanʌm, jãg sëunem nem jaau sĩerrarrau jaauwai, hiin meewiajã k'ãai t'ãrjup nʌm hee deeu hiiu p'iidʌju ha hiek'atarr. ");
INSERT INTO noaH_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Magtarr haawai k'ãai t'ãrjup soldaaunag chi jẽbdi haig t'ʌapibá; magba hak'iin heeu dëgölp chi k'apeenau hedaar bëewia, chi binaan hamach jua k'ap hausĩunaa, naspawia chadchata deeu hiiu p'iidʌjim haduk'am. Magta haju hat'een magan warram k'ãai warag hatchata sëuk'a nem jaau nʌisijugui hajierram haajem, Pilatoog. ");
INSERT INTO noaH_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Magbaawai Pilatoou hamag, —Pãachdëu mag nʌm k'ai, magan soldaaunan har t'ʌnʌm. P'ë harrwi pãachdëu k'õchagpierr chi jẽbdijã wajap'a p'ãarnaa jʌʌrt'ʌ pʌabajët hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Magbaawai chadcha soldaaun p'ë harrwi mag chi jẽbdi hee mokdau joot'ʌ sĩerr hʌ̃rjã wajap'a dusnagjö simua jʌʌrt'ʌpʌ̈ijierram hanaabá. Magnaa chi soldaaunag k'ãai t'ãrjup hogdʌba haig t'ʌapi jaaujierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jua hʌ̃i k'ëutarr noram, domighed hedp'erre hagt'a k'ĩsu nʌwe María Magdalenaau deeum hʌʌi hagjö María ha t'ʌ̃r sĩerr dʌ̈i Jesús hauk'ërtarr jẽbdi haar hoon wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mag nʌm hee Hẽwandam chog hʌ̃gt'armua bëewi mag mokpör chi jẽbdi hee joot'ʌ sĩerr chaaug pʌrëubapäaiwai hʌʌur t'eega duuijim. Mag chi mok chaaug pʌrëupʌ̈iwia warag hag hʌ̃r hoo sim hooimajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chi Hẽwandam chog k'ĩir heerpaawai sĩi pagt'ʌm dau p'ʌr jẽer hat'am bʌ̈ hoo nʌmjö sĩejim hanʌm, maimua hi k'ajũa sĩi bäpp'ä sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldaaun chi jẽbdi t'ʌa narr k'ʌʌn mag hoobaawai jãp'ierr wajaugau k'a duuip'öbaadëwi sĩi warag chi meemjö jẽk'ʌt t'up'ãau hap'öbaadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pari mag chi soldaaun t'up'ãau hap'öbaadëm hee, chi Hẽwandam chogau chi hʌʌinag, —Hoob jãp'ierrmiet hajim hanʌm. Mua k'ap'ʌ chirʌmgui hajim hanʌm, pãrau Jesuuta jʌr wënʌrrʌm, har hamau pakuls gaai meerp'ë t'õotarr. ");
INSERT INTO noaH_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mʌig hich hauk'ërtarr heemua p'iidʌwi petaawai ya mʌig k'aba sim. Pãach daujãau hi hauk'ërtarr hee hoon bëejurauma hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Magnaa hamag, Hërëubaadët, maimua hi k'apeen haar, “ya hiiu p'iidʌwi pãar na Galileaag petajim, nau jamta pãrau hi hooimajugui” ha jaaubaimat hajim hanʌm chi Hẽwandam chogau. ");
INSERT INTO noaH_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ham hiek hamachig magbaawai haigmua hapuraa hërëubaadëjim hanaabá. Jãp'ierraa naajieb mamʌ hagjö honee naajim haajem, hamachig mag Jesús p'iidʌbarm ha jaaubaawai. Mag warag k'ajap'a bʌ̈ chʌp wëtjim haajem, maach chi k'apeenag jaauwimaag. ");
INSERT INTO noaH_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mag ham heerpamjö wëtumta hich Jesús ham k'ĩirp'ee höbërchëwi hamag saludaachëjim hanaabá. Mag hamachig hiek'abaichee hi k'aug hat'aawai hi bʌ̈k'ʌrr p'õbk'anaa hi bʌ̈ʌta hud hat'ajierram haajem, hirig jëeumamua. ");
INSERT INTO noaH_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Magbaawai hichdëu hamag, —Hoob nem hök'ö hamiet hajim hanʌm. Jãg jãp'ierr wënʌrraju k'ãai, mʌ k'apeen haar wëtwi Galileaag wëtpi jaaubat, nau jamta hamau mʌ hooimaju ha jaaubaimat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mag hich dʌ̈icha hoowia chi k'apeen haar jawaan dʌdʌrk'amich, soldaaun chi jẽbdi t'ʌa narr k'ʌʌn heem hãaur k'ʌʌnau p'öbör hee wëtwi chi p'adnaan pörnaanag jaauwimajierram hanaabá, mag chi mok chawag pʌrëupʌ̈inaa hag hʌ̃r jup sim hamachdëu hootarr maimua chi Jesujã hich hauk'ërtarr hee hooba k'ãidu parii haadëm. ");
INSERT INTO noaH_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mamʌ magbaawai chi p'adnaan pörnaanaujã hag bʌ̈rre tagam judionaan chi t'et'emnaan t'um t'ʌ̃rk'anaa hibëpjierram hanaabá, soldaaunag Jesús hiiu p'iidʌbarm higwi sëuk'a nem hĩgk'apieg. Magnaa hĩchab chi soldaaunau sëuk'a nem jaaubarm paarjã p'atk'on pöm p'agju hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ya mag hamach hap chi hiek'am harr haawai chi soldaaun wawimamua hamag magjierram hanʌm: —Hõrag jaauwai hedaar pãach k'ãi nʌmich chi k'apeen bëewiata chi hauk'ërtarr heem jĩgk'a harrwi hamachdëu k'ap wai nʌm ha jaaubat hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mag pãar k'ãitarr gobernadorrau hũrwia pãar dʌ̈i k'aigba hamʌn, marau maachdëuchata hi dʌ̈i hiek'awi maachig paa hauju. Magbaawai pãar chig habajugui hajierram hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mag, chadcha hamachig p'agbaawai, hõrag jaauwaijã, ham k'ãi nʌmichta chi k'apeen bëewi jĩgk'a harrjierram ha jaaujim hanaabá. Magtarr haawaita hĩs hewag pawiajã judionaan heyan hagt'a Jesús chan p'iidʌba maach chi k'apeenauta harrwi maach jua k'ap bëp sĩujim ha jaaujem. ");
INSERT INTO noaH_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mag Marianaanau maachig Galileaagta wëtpi naajim ha jaaubaawai maach chi k'apeen t'um once Galileaag wëtjim, hich Jesuu maachig nʌpi jaautarr buchagdam gaai hãba hi dʌ̈i hoog. ");
INSERT INTO noaH_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Maimua mam pawia ya hich Jesús warp hurum maachdëu hoop'öbaadeewai Hẽwandam chi Hayagamjö hirig jëeu naajim; mamʌ mag hirig jëeu nʌm hee, maar k'apeen hãaur k'ʌʌnau har k'abampii naajim. ");
INSERT INTO noaH_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mag nʌm hee warag maar haig bëewi maar dʌ̈i hiyʌ̈ʌmamua magjim: —Ya mʌ Hayau mʌrʌg hʌ̃gt'arm k'ʌʌn dʌ̈ijã hiek t'eeg hapinaa mʌig heegarm k'ʌʌn dʌ̈ijã hiek t'eeg hapibarmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Magua mua pãragan, mʌ matarr k'ur pãach hap paauk'abaadee durrpierr haaidʌbaadët ha chirʌmgui hajim; magnaa t'umaam k'ʌʌnag hamach meupierr mʌg pãach peerdʌtarr hiekta jaaunaa chi hʌ̈k'amam k'ʌʌnagjã pãach dënjö mʌchta hamach Pörk'apibat hajim. Magnaa hĩchab Hẽwandam chi Haai t'ʌ̃r gaai, chi Hiewaa t'ʌ̃r gaai maimua hich Hẽwandam Hak'aar t'ʌ̃r gaai pör choopetat hajim, mag chi hʌ̈k'amam k'ʌʌn. ");
INSERT INTO noaH_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mag nʌm dʌ̈i hĩchab mua pãachig jaaujerrjö Hẽwandamau nem waupi jaaumamta hi hipierraa waupi jaaubat hajim, hich jãg pãachdëujã mʌ hipierr wënʌrrʌmjö. Mʌʌn mʌchin Jöoirau mʌg durr hi hagk'a nʌm haar hich mag hed hëepierr pãar dʌ̈i chitajugui ha jaau pʌajim maachigcha.");
INSERT INTO noaH_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Warrcha maach peerdʌajem hiek jawaag Jesucristo Hẽwandam Hiewaa bëetarran mʌgta hajim haajem: ");
INSERT INTO noaH_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Warr jöoingar Hẽwandam hi jaaumie Isaías k'ararrag Hẽwandamau hich hiek p'ãpiewai hich Chaai pʌ̈ijuuta jaaujim hanaabá. Pari mag hich Chaai pʌ̈iju na deeum higwia hich Chaairagta magjim hanʌm: “Hiewaa, mua pʌ na mʌch hiek jaaujem pʌ̈iju. Mag wounauta pʌ na pʌ maju hee hõrag pʌ barju jajawagmaju, t'umaam k'ʌʌnau pʌ hiek hũrm k'õsi sĩi pʌ nʌ naamk'ĩir” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Mag woun hajappai hõor barba haajem haar sĩejemuata hich haar hõor barbaimaawai pʌ jaaumamua, ‘Ya maach Pör bëeimʌʌ sim’ ha jaaumaju, pʌ higwia. Mag pʌ higmamua, ‘Hi bëeju nawe pãach t'ãar k'ĩir k'augbat’ ha jaaumaju, t'ãraucha k'õsi pʌ hiek hʌ̈k'amk'ĩir.” Magta hajim haajem Hẽwandamau hich Hiewaag, Juan higwia. ");
INSERT INTO noaH_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mag chi Hẽwandam Hiewaa maju na hi jaau nʌrrarr Juan hajim haajem, chi hõor pör choomie. Warrgarwe chi Juan higwia mag nʌrraju jaautarr haawaita chadcha t'um hich hagjöo höbëbërgmamua Juanau hõrag, “Pãach k'aibag hãsie hewag k'ĩirjuwia, Hẽwandamag chugpaapi jëeuwia, mʌrʌg pãach pör choopibat; magbaawai Hẽwandamau chadcha pãar k'aibag chugpaapʌ̈iju” ha jaaujeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mag hirua jaau nʌrrʌm hũrbaawai bëejeejim haajem: Judea durram k'ʌʌn dʌ̈i Jerusalén p'öbör heem k'ʌʌnpa, hi hiek hũraan. Mag hamach jʌ̃gʌucha hũrwia, hãsie hewag hamach k'aibag k'ĩirjuwia, meerba jaaunaa hamach pör choopibaawai, Juanau ham pör choopʌ̈imajim haajem, döjã Jordán hee. ");
INSERT INTO noaH_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan chi hõor pör choomie k'ajũan camello hëu dënta k'a sĩejim haajem. Hi hãi jʌ̃ajemjã nemhëu dën hajim haajem. Maagwai hirua k'oojerr, hasp'it hajim hanaabá pamiel dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mag wounau hõrag jaauwai, “Mʌg hed gaai mʌ hẽudee jöpcha woun hãb bëejugui” haajeejim hanʌm. “Ma mʌ k'ãaijã hʌ̃rcha hiek t'eeg sim. Mag mʌ k'ãaijã hʌ̃rʌʌcha hiek t'eeg sĩewaita mʌ chan mʌg chirʌm haig sĩi hi chogk'aagpaijã serbiiba chirʌm. ");
INSERT INTO noaH_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Muan sĩi dödamaupai pãar pör choo chirʌm. Pari hichcha bëem hed gaai hichdëun pãrag hich Hẽwandam Hak'aarchata deejugui” haajeejim haajem hõrag, mag Jesús bëeju higwia. ");
INSERT INTO noaH_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mag Juanau hõor pör choo nʌrrʌm jaarta Jesucristo Hẽwandam Hiewaa bëejim haajem, Galilea durram p'öbör Nazaretmua. Mag hich haig pierrwai Juanau döjã Jordán hee hi pör choopʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mag pör choowia dö heemua höbëraau hoowai, hedaujãata weeudʌbaadëm heemua Hẽwandam Hak'aarta duburjöo k'itʌm hi gaai jupcheeg wëwëwë hurum hoojim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Magbarm hee hĩchab hʌ̃gt'armua hõor hiekjö, “Hiewaa, pʌʌta mʌ Chaai mʌchdëu jãsehne wai chitʌmʌu; pʌ gaaimua mʌ honee chiraajem” habarmjã hũrjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mag pör choo haaipawi hi durrpabaadëm hee, hich Hẽwandam Hak'araucha warp hõor chukag hee hi warrjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mag mam mawia cuarenta días sĩejim hanaabá, durr warp hõor chukag hee, maach k'oojem nemk'am hee. Mag hi sim haigta dösãtau bëewia hirig sëuk'abaichëjim hanaabá, hi k'ũgur hawaag. Maigmua chi dösãt petarr hẽudee jũrr Hẽwandam chognaanauta hʌ̃gt'armua bëewia hi k'ĩir jãsenk'achëjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mag k'ur Jesús majim haajem Galilea durr, hõrag “Hẽwandamau hõor t'umta hich dënk'a haum k'õsi sim” ha jawaan. Mag hi maawai rey Herodeeu Juan pʌr hauwi cárcel deg pʌ̈itarr k'ur hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mag Hẽwandam hiek jawaanta marr haawai hichpai higwia jaaumamua, “Warrgurwe Hẽwandamau Juan hẽudee woun hãb pʌ̈iju ha jaaujerr hĩsta barbaichëmgui” hajim hanʌm. “Maagwai hĩsin chad Hẽwandamau t'umaam k'ʌʌn hich dënk'a haum k'õsita sim. Pari magaagan pãach k'aibag hãsie hewag k'ĩirjunaa hiseg nʌm dʌ̈i t'ãraucha maach peerdʌajem hiekta hʌ̈k'abat” haajeejim haajem hich Jesuucha hõrag. ");
INSERT INTO noaH_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Biek hãb Jesús t'ʌrrdö Galilea hanʌm higaau nʌrrʌmua hõor numí dö hʌrëu nʌm hooimajim haajem. Mak'ʌʌn Simón hajim haajem hich naam Andrés hanʌm dʌ̈i. Hich mak'ʌʌn dö hʌamien hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mak'ʌʌnag Jesuu, —Hidëu pãach red pʌawia mʌ dʌ̈ita wëttarrau hajim hanʌm. Hich jãg pãach mʌg sĩi dö hʌa gaaipai nʌmjö, mʌg hatag jũrr mʌ hiek hõrag jaau gaaipaita nʌisijugui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mag chadcha hamachig magbarm bʌ̈rre hamach red pʌawia Jesús dʌ̈i hërëujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mag hërëubaadeeu hag hatk'ajãrpai deeu hõor numí botedam hee hamach red t'ʌrrdʌ sĩsidʌm k'a nʌm hooimajim haajem. Mak'ʌʌn jöoi Zebedeo chaain hajim haajem, Santiago Juan dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mak'ʌʌnjã Jesuu hëeurrjim hanaabá hich dʌ̈i. Magbaa hamach haai Zebedeo hich p'idk'aajem k'ʌʌn dʌ̈i bote hee pʌawia hi dʌ̈i wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mag wëtwi, Capernaum p'öbör hee barwia, jua hʌ̃ʌijem hed haadeewai, judionaan Hẽwandam hiek jaaujem hee mawia, hõrag Hẽwandam hiek jaaubaadëjim haajem, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mag hirua jaaumam hũrwia, haig hõor hi hiek hũr narr k'ʌʌn jʌ̃gderraa naajim haajem, hamachdëu hũurwai Jesuu jũrr Moiseeu ley p'ã pʌarr jawaag chi k'ap'ʌm k'ap'ʌm haajem k'ʌʌn k'ãyaujã jaau k'apcha jaaumam hũrwia. ");
INSERT INTO noaH_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mag Jesuu Hẽwandam hiek jaau sim haig woun hãb mor hee bën k'aigbam wai sim sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Mag wounau Jesús hoo hat'aawai chi bën hi mor hee simuata t'et häa hanaa hirig, —¡Jesús Nazaretpierr! Hidëu maar sĩi k'ajap'a sĩubá hajim hanʌm. Puan sĩi maar höpäainta hurum. Mua pʌ k'ap'ʌ chirʌmgui hajim hanʌm, pʌ jammua hurú. Pʌ Hẽwandam Hiewaa hʌ̃gt'armua bëetarr k'abahab, warrgurwe Hẽwandamau pʌ̈iju ha jaaujerr hajim hanaabá hirig chi mepeer garmua. ");
INSERT INTO noaH_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Magbaawai jũrr Jesuu chi meperagta meeuk'anaa, —K'ĩu habá. Pʌchta warag jãg woun mor heemua höbërbaad hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesuu mag hiek'abaa, chi mepeer mag woun mor heemua wiwiug höbërbaadeeu, warre jẽk'ʌt p'ʌp'ʌrgpʌ̈iwia, chi wounta hiek chuk pʌajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hõrau hamach daúa mag hoobaawai dauderraa nʌm hiek'au hamach wir haigpai, “¿Jãga jãg wounau hiek'aawai meperaupa hi hipierraa nʌma?” hanaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesuu mag woun mor heem mepeer jʌrbapʌ̈im jöpchata Galilea durr hee maimua hag bigaau p'öbördam nʌnʌidʌm heem magwe k'ak'apdö jöisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mag judionaan Hẽwandam hiek jaaujem deg Jesuu hõrag Hẽwandam hiek jaau sĩewia höbëraau higbaadëjim haajem, Simón Andrés dʌ̈i joobaajerr di haar. Mag hi mam dʌ̈i hi k'apeen numí wëtjim haajem. Mak'ʌʌn, Santiago hajim haajem Juan dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mag wëtwia Jesús deg pabaimaawai haiguim k'ʌʌnau hirig jaaujim haajem, Simón p'aauhũan put hee k'ʌʌumieu mor mas sim. ");
INSERT INTO noaH_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Hichig mag jaaubaa, haar dubwia, hi jua gaai pʌrnaa hʌ̃gt'aag p'iriu haujim hanaabá. Mag p'iriu hat'am bʌ̈rre chi k'ʌʌumiejã t'umbabaadeewai warag p'iidʌwia ham jãhogjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Maimua ya hedau k'ëubaadëm hee, hõrau hamach haaunaan k'amor machag k'ĩirpierr wai narr k'ʌʌn dʌ̈i dösãt bënëu sĩsidʌmpa Jesús haig waibëemajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mag warag t'um p'öbör heem k'ʌʌn bëewia hi sim di haig puertdi higaauta daaugajãrm magwe pos hap'öbaadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mag, sĩi k'ajap'am k'amor machag k'ĩirpierr wai sĩsidʌm hich haig haubëemarr k'ʌʌn monaaumam dʌ̈i hĩchab mepeenpa hõor mor hee sĩsid harr jʌr wërpmajim haajem. Chi mepeenau hi k'ap'ʌ naajim hanaabá, hi chadcha Hẽwandam Hiewaak'a sim. Mamʌ hich Jesuu bʌ̃ʌrjã hamag hiek'apiba haajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesuu hichdëu mag hõor pöm monaautarr hag noram hedaraawe p'iidʌwia p'öbör higaau warp'aapai hich hap majim haajem, hõor chukag hee, Hẽwandamag jëwaan. ");
INSERT INTO noaH_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Magbaawai Simonau tagam k'ʌʌn hich k'apeen dʌ̈imua hi jʌr wënʌrrawi hoobaimaawai ");
INSERT INTO noaH_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","hirig jaaujierram haajem, hõor t'umaam k'ʌʌnau mag hi jʌr wënʌrrʌm. ");
INSERT INTO noaH_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mamʌ magbaawai jũrr hichdëu hamag magjim hanʌm: —Chawag dewam p'öbör dak'apaim haarta wëttarrau, jũrr mamaam k'ʌʌnagjã Hẽwandam hiek hagjö jawaag. Warrjã mag jawaanta mʌ bëejimgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hich mag Jesuu Galilea durr hõor nʌnʌidʌmpierr Hẽwandam hiek jaau nʌrranaa judionaan Hẽwandam hiek jaaujem degjã jaaujeejim haajem. Mag nʌrrʌmua hõor mor hee mepeer k'aigbam wai sĩsidʌmjã warre dau daau höbeerpʌ̈i maajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Biek hãb woun p'ĩe k'a dodoso sim Jesús haig bëewia hi k'ĩirp'ee kanieu p'õbk'achëwia hirig, —Pua k'õs chirʌm k'ai, mʌg p'ĩedau warre mʌ gaaimua chugpaabapʌ̈i haichëjim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Magbaa Jesuu hi dau haug k'augwi hi gaai pʌrnaa hirig, —Mua pʌ monaaupʌ̈im k'õsi chirʌm. Monaau chirsí magan hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Magwia Jesuu hirig, Mua mʌg pʌch monaaubarm hoob hõrag jawam hajim hanʌm. Magju k'ãai nacha Jerusalén mawia Haai hi jëeujem degam p'adëg pʌch mor hoopibaimá. Maimua Moiseeu hiek p'ãtarr gaai jaau simjö pʌch monaaubarm paar nemchaain ofrendak'a deebá hajim hanʌm, pʌch mʌg monak'a chirsim hõrag k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mamʌ Jesuu mag hich monaautarr hõrag jaaupiba harrta hich nʌrrʌmpierr jaaubaadëjim hanaabá. Mag gaaimua Jesús tag p'öbör hee parhooba höbërju k'aba, hõor chukag chʌʌita sĩsijim haajem. Mamʌ magʌm hãba, mam p'öbör higaau hi sim haar durrpierram k'ʌʌn hi haar baarjeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesuu mag woun monaaupʌ̈itarr k'ur k'ãai k'apancha k'aba nʌm hee, p'öbör Capernaum hanʌmʌg majim haajem. Mag mawia barbaimaawai sĩi p'öbör heem k'ʌʌnau hi barbaimam k'ak'apdö jöisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mag hamachdëu hi deg pabaichëm k'aug hat'aawai haig bëe t'ʌnʌmua hõor pöm pos sĩi puertdi higaaum magwe p'ẽu t'ʌnʌisijim hanʌm. Jesuu mag pos t'ʌnʌm k'ʌʌnag Hẽwandam hiek jaau sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mag nʌm hee hõor jayapam k'ʌʌnau woun hãb k'apá jʌser k'itʌmta pa bʌʌrk'am gaai jiir haibëejierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mag haibëewi Jesús sim haar mag woun wai dubaag hẽk'a naajim haajem; pari mag puertdi higaau hõor p'ẽu t'ʌnʌm k'urau pöd hierrag wai dubju k'aba haawai, hʌ̃gt'aa dihëu hʌ̃r waaidʌtk'awia, chi Jesús sim hʌ̃rʌʌ dihëu magar hauwi, chi pa bʌʌrk'am gaai jʌ̃gadau jʌ̃k'anaa mag chi k'apá jʌser k'itʌm heeg jiir burrpʌ̈ijierram hanaabá, Jesús sim haigcha, hamach haaunaan monaaupʌ̈iju k'ap'ʌ narr haawai. ");
INSERT INTO noaH_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuu hamau mag k'ĩirju nʌmjã k'ap'ʌ sĩerr haawai chi k'apá jʌser k'itʌmʌgta, —Pʌ pekau t'um ya mua chugpaabapʌ̈imgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mamʌ mag hiek'abarm hũrwia Hẽwandam hiek jawaag hit'ee chi machnaan haig narr k'ʌʌnau hamach wir haigpai, ");
INSERT INTO noaH_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ma chijãg wounta Hẽwandam dau na mag k'aigba hi jũur hiek'a sĩma? Hãba Hẽwandamau k'abam chan maach pekau chugpaa hauba haajem” hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mamʌ hamau hamach hödegpai mag k'ĩirju nʌmjã Jesuu k'ap'ʌ sĩerr haawai hamag, —¿Pãrau k'ant'ee pãach hödeg jãg k'aigbata k'ĩirju nʌma? hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Wa mag pekau chugpaabarmjã dau daau hooba naawai pãrau k'ĩirjuawai chadcha p'it'urg chuk'u t'umaam k'ʌʌnau mag hiek'aju haai nʌm ha nʌwa? Mamʌ mua hirig, “P'iidʌwia pʌch pa bʌʌrk'am hãbamʌg p'ë hauwia petá” hak'iin, hõrau hamach daúacha hooju, hi monaau sĩsi wa monaauba k'ãijã hich mag sĩsim. Magua pãrau mʌ dënjö chan cha mua jawaagpamjö habajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mamʌ mʌch chi Hemk'ooi Hiewaa Hẽwandamau hich juapá deetarrau chadcha mʌg jẽb gaai hõor pekaujã chugpaaju haai chirʌm pãrag k'ap hamk'ĩir, mua pãrag hoopik'imgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Magnaa chi k'apá jʌser k'itʌmʌgta, —P'iidʌwia, pʌch put hãbamʌg juurwia, pʌch diig petá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Magbaawai hag bʌ̈rre chadcha p'iidʌwia, hich wai bëetarr pa bʌʌrk'am dʌ̈i hich putpa hãbamʌg p'ë hauwia, t'umaam k'ʌʌn dak'ĩir nem moná dawag höbërbaadëjim hanaabá. Mag höbërbaadëm hoowi haig narr k'ʌʌn dauderraa nʌisijim hanʌm. Mag nʌm hiek'au Hẽwandam t'ö hiek'amamua, “Hẽwandam, hag na marau bʌ̃ʌrjã mʌg nem hooba haajemta hĩsta chadcha pua marag pʌch jua t'eeg hoopibarm. Pʌchta chadcha chi jua t'ierriu Hẽwandam” hanaajim haajem, hirig jëeumamua. ");
INSERT INTO noaH_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesuu Capernaum p'öbör hee mag woun monaautarr k'ur petajim haajem deeu Galilea t'ʌrrdöog. Mag mawia hi barbaimaawai, hich haig jũrram k'ʌʌn p'ẽp'ẽeuk'amua hõor pos haadeewai, hamag Hẽwandam hiek jaaubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mag jaau sĩewi petaau jöoi hãb Alfeo hanʌm hiewaa Leví hanʌmta hooimajim hanʌm. Mag Leví Romaam gobierno dën dëbpaar jëeujem harr haawai hõrau hichig dëbpaar p'agaan bëejem hag mes bigaau päar sĩejim hanʌm. Mag hoobaimaawaita Jesuu hirig, “Mʌ dʌ̈i marrau” habaawai, p'iidʌwi, chadcha hi dʌ̈i petajim hanaabá, hi k'a hogdʌba nʌrraag. ");
INSERT INTO noaH_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Biek hãb Jesús hich k'apeen dʌ̈i Leví di haig t'ach k'ö sĩejim haajem. Maig naajim haajem hĩchab hich Leví k'apeen hagjö gobierno dën dëbpaar jëeujem k'ʌʌn. Maimua hĩchab hõor k'apan hi hẽudee bëetarr haawai hamach k'aibagau t'ʌ̃rp'öok'am k'ʌʌnpa haig t'ʌnaajim haajem, Jesús dʌ̈i hãbam mes gaai t'ach k'oowai. ");
INSERT INTO noaH_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mag hi mak'ʌʌn dʌ̈i hãba t'ach k'ö sim haig fariseonaanau Hẽwandam hiek jawaag chi machnaan dʌ̈imua chi Jesús dʌ̈i wënʌrraajerr k'ʌʌnagta jëeuchëjierram hanʌm: —¿Jãga jãg pãar maestro sĩi dëbpaar jëeujem k'ʌʌn dʌ̈i pekau pöm sĩsidʌm k'ʌʌnpa hãba t'ach k'ö sĩ? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mamʌ hamau mag hiek'abarm hũrwia Jesuu hamag magjim hanʌm: —K'a monak'a nʌm k'ʌʌnau chan doctor higba haajem. Mor masim k'ʌʌnta doctor hiigjem. Mʌ chan bʌ̃ʌrjã pekau chuk'u wajap'a k'it'ëem haajem k'ʌʌn jʌraanjã bëeba, mʌʌn hõor pekau pöoma k'it'ëem k'ʌʌn peerdʌ hawaanta bëejimgui hajim hanaabá, k'ĩirjug hiiur haumk'ĩir. Maguata mag ham pekau pöm nʌmjã higba, ham dʌ̈i t'ach k'ö chirabahab hajim hanʌm, hamjã Hẽwandam dënk'a hawaag. ");
INSERT INTO noaH_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","K'ãai hãb fariseonaan higar nʌm k'ʌʌn Juan chi hõor pör choomie k'apeen dʌ̈i t'ach k'öba sʌrk'a naajim haajem. Mag nʌm hee hõrau Jesús sim haar wëtwia hirig maguimajierram hanʌm: —Fariseonaan higar nʌm k'ʌʌn maimua Juan k'apeenjã sʌrk'a nʌmta, ¿k'an jãgwia pʌ dʌ̈i wënʌrraajem k'ʌʌnta jãg sʌrk'aba nʌ? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Magbaa Jesuu hamag magjim hanʌm: —Pãrau hoowai, ¿chi jua pʌr sim woun honee hich hʌʌi dʌ̈i t'ach k'ö nʌmich, hirua hõor hich jua pʌr nʌm hee t'ʌ̃rtarr k'ʌʌn sĩi bëewia hök'ĩirjuu hohoodö naajẽ, sʌrk'aawai bʌ̃ʌrjã t'ach k'öba? Magba haajem. ");
INSERT INTO noaH_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Magua hich hagjö mʌ dʌ̈i wënʌrraajem k'ʌʌnjã sʌrk'aba nʌm. Ham sʌrk'ajuun, mʌg hatag mʌ ham jaaijö ham dʌ̈i chitʌm pʌr hat'am hed gayan chadau ham hamach k'ĩrauta sʌrk'awia hĩchab t'achjã k'öba nʌisip haju, gaai machgau. Mamʌ mʌʌgwaiwe chan ham sʌrk'aju k'aba nʌmgui hajim hanʌm, hagt'a mʌ ham dʌ̈i chiraawai. ");
INSERT INTO noaH_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Magnaa, ’Pãadë k'ĩirjubat hajim hanʌm. Pãraun chadcha pãach jöoinau jaaujerrjö t'ach k'öba sʌrk'a nʌm. Mamʌ pãrau jãg mua hiek hiiur jaau chirʌmjã k'õsinaa hagjö warrgarm k'ĩirjug chi jöoijã hagt'a k'õsi wënʌrrʌmʌn, magan mag k'ĩirjugan sĩi put hiiur hauwia jũrr k'ajũa jöoi gaai p'ẽek'abarmjöta sĩsim. Hãbmua k'ãijã put hiiuriu k'ajũa jöoi gaai p'ẽek'ak'iin, mag put hiiur hi pächdʌbaadëmua chi k'a sim hee t'ʌrrdʌbaadeeu warag hich warr sĩerr k'ãaijã nem wäg sĩsiju. Magua chi mʌ hiek hʌ̈k'a simua chan mʌg hiek hiiur mua jaau chitʌmjã hʌ̈k'anaa pöd hamach jöoin hijã hagjö hʌʌrk'aju k'aba simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wa magbam k'ai, vino hõrr hachpamk'ĩir nemhëu jöoi dën t'ũrk'a sim hee pʌbarmjöta haju: Chi vino hõrr hachpabaadeewai, chi nemhëu jöoiraa sĩewai, hãwatba jẽgdʌbaadee chi vinojã hãrbaadëm dʌ̈i chi nemhëujã ya tag serbiiba sĩsiju. Maguata vino hõrr hachpamk'ĩran, hagjö nemhëu hiiur heeta pʌajemgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","K'ãai hãb jua hʌ̃ʌijem hed Jesús hich k'apeen dʌ̈i trigodö hee dich wëtumua chi k'apeenau trigo p'ierr hahaug wëtmajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mag trigo p'ierr nʌm hoowia Moiseeu Hẽwandam hiek p'ã pʌatarr wajapcha hʌʌrk'aajem k'ʌʌnau Jesuug, —Pʌdë hoobá: Jua hʌ̃i nʌm hed haawai bʌ̃ʌrjã p'idk'aju k'aba nʌmta pʌ k'apeenau jãg trigo p'ierrnaa k'ö wënʌrrʌmwai hajierram hanʌm. ¿Pua chan k'augbahab hajierram hanʌm, jãgpai p'ierr nʌmjã nem pöm heeu nʌm dʌ̈i hãba sim? ");
INSERT INTO noaH_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Magbaa jũrr Jesuu hamag magjim hanʌm: —Mamʌ ¿k'ani mʌ k'apeenau k'aigba habar? Magan ¿pãrau chan Hẽwandam hiek p'ã sim gaai t'ʌ̃ʌrwai bʌ̃ʌrjã k'augbata haajeeb, rey David k'ak'itarrau hich k'apeen dʌ̈imua hamach jãsöo hap'öbaadee pan k'ötarr? ");
INSERT INTO noaH_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, warr Abiatar p'adnaan pörk'a sim jaar David hich k'apeen dʌ̈i Haai hi jëeujem deg dubwia hag hee pan ofrendajö Hẽwandam hit'ee wai narr k'öpʌ̈itarr. Mag pan parhoobam k'ʌʌnau k'öju k'aba, hãba p'adëupaita k'öju haai sĩejim hanaabá. Mag sĩerrta hichdëujã k'öwi hich k'apeenagjã deejimgui hajim hanʌm hamag. Mamʌ mag k'ötarr paarjã Hẽwandamau ham chig habajim. ");
INSERT INTO noaH_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesuu hamag mag hiek'awi hichdëupai deeu hũmaai hamag magjim hanʌm: —Jua hʌ̃ʌijem hedan, hʌ̈u hõordam jua hʌ̃i wënʌrramk'ĩirta Hẽwandamau deejim; mamʌ mag nʌm chan mag jua hʌ̃ʌijem hed sʌrk'a wënʌrrʌm gaaimuata maach hʌ̈u wënʌrrʌm hanʌm k'abam. ");
INSERT INTO noaH_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Maguata mʌch chi Hemk'ooi Hiewaa mʌg jẽb gaaijã hiek t'eeg chirʌmuata t'umaam k'ʌʌnag k'an nemta wauju haai nʌ ha jaauju haai chirʌmgui hajim hanʌm, jua hʌ̃ʌijem hed hawiajã. ");
INSERT INTO noaH_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Biek hãb deeu jua hʌ̃ʌijem hed Jesús mawi Judionaan Hẽwandam hiek jaaujem deg dubimajim haajem. Maig woun hãb hooimajim hanʌm t'oom juadam jʌsar k'itʌm. ");
INSERT INTO noaH_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Maig naajim haajem hĩchab fariseonaan, Moiseeu Hẽwandam hiek p'ã pʌatarr wajapcha hʌʌrk'aajem k'ʌʌn. Mak'ʌʌnau Jesuug bʌ̃ʌrjã dau t'õba naajim hanʌm, hamach dak'ĩir Jesuu jua hʌ̃ʌijem hed mag woun monaaubapäaiwai hirig, “Jãgan pua chan jua hʌ̃ʌijem hedjã hʌʌrk'abata chirab” ha hiek'aag, mag nʌm dʌ̈i hĩchab magʌm gaaimua t'et'em k'ʌʌnagjã hi k'aibag waupi jawaag. ");
INSERT INTO noaH_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mamʌ Jesuu hamau mag k'ĩirju nʌm k'ap'ʌ sĩerr haawai warag chi jua jʌsar k'itʌmʌgta, —P'iidʌwia dayag pidú, maimua mau hõor jãrr dʌnʌʌubaichë hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Magnaa jũrr chi fariseonaanagta, —Pãrau hoowai ¿k'an nemta maadëu wauju haai nʌ hajim hanʌm, jua hʌ̃ʌijem hed? ¿Hõordam dʌ̈i hajap'a haju wa hõor k'aibag wauju? ¿Hõor peerdʌ hauju, wa hõor t'õoju? ¿K'ani hʌ̈ucha sĩ? ha jëeujim hanʌm hamag. Mamʌ hamachig mag jëeutarr ni hãbmuajã bʌ̃ʌrjã hi hiek hʌ̈k'abajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mag ni hãbmuajã hich hiek hʌ̈k'aba habaawai hamag k'ĩir masi heerpanaa warag hök'ĩirjuu haadëjim hanʌm, hichdëu hoowai hamau bʌ̃ʌrjã wir haig hamach k'apeen dau hee haug k'augba nʌm hoowia. Magwia chi jua jʌsar k'itʌmʌgta, —Dayag jua hʌabá hajim hanʌm. Mag chadcha hi hipierr hʌ̃gt'aag jua hʌabaawai warre jua monakk'a sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mag chi fariseonaanau hamach dak'ĩir mag woundam monaaubapʌ̈im hoobaawai k'ĩir machgau warag hamachta daau paauk'abaadëjierram haajem. Maimua rey Herodes higarm k'ʌʌn chi t'et'emnaan dʌ̈i hãba biirdʌwia, “Jãga hak'iin maadëu jãg Jesús pʌr hauwia t'õopʌ̈ik'amgui” ha k'ĩirju nʌisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Maigmua Jesuu hich k'apeen hich dʌ̈i p'ë harrjim haajem, hich hag Galilea heepai t'ʌrrdö pöoma simʌg. Mag hi mam dʌ̈i hõor k'apaana Galileapien Judeapienpa wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesuu mag hõor mor masim k'ʌʌn monaau nʌrrʌm ha hũrp'öbaadeewai hõor pöoma hi haig bëe t'ʌnʌisijim hanaabá: Jerusalenpien, p'öbör Idumea hanʌm haram k'ʌʌn, döjã Jordán hanʌm hee hedau höbeerjem garm k'ʌʌn, maimua p'öbör Sidón hanʌm dʌ̈i Tiro dak'a p'öbördam nʌnʌidʌm heem k'ʌʌnpa bëejierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mag hõor pöm bëe t'ʌnaawaita Jesuu hich k'apeenag ya hag nawe jaau wai sĩejim haajem, sĩi hich hit'ee bote k'ĩir k'aug wai naamk'ĩir, hatcha hõor pöm haadeewai t'et hich p'ẽeut'ʌ haum hugua hag hee waaidʌag. ");
INSERT INTO noaH_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hich mag hed Jesuu hõor pöoma monaauk'apʌ̈ijim haajem. Mag hõor pöm monaaumam hamach daúa hoo narr haawaita warag jũrram k'ʌʌnau hi gaai juaucha pʌrchëm hiigjeejim hanaabá, hamachjã monaaumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mag hõor pöm wëjöm hee naajim haajem hĩchab, mor hee t'õt'õrrsöm bën paraa sĩsidʌm k'ʌʌn. Magʌm k'ʌʌnau Jesús hoowai warag haig bëenaa, hi k'ĩirp'ee kanieu p'õbk'anaa wiwiuk'amuata, “Pʌʌn chadcha Hẽwandam Hiewaau” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mamʌ Jesuu chi mepeenag meeurrau sĩiujeejim hanaabá, t'umaam k'ʌʌn jʌ̃gdaar mag hich jaau wënʌrram hugua. ");
INSERT INTO noaH_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mag Jesuu hõor pöm monaau nʌrrarr k'ur durrsĩ gaai waaidʌwia hich dʌ̈i wënʌrrarr k'ʌʌn heem hichdëu k'õsim k'ʌʌn hich haig t'ʌ̃rk'a haujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mag hich haig t'ʌ̃rk'a hauwia mag hõor k'apan hich dʌ̈i wënʌrrʌm k'ʌʌn heem hichdëucha doce jʌr haujim haajem, hich hiek hõor hee jaau wënʌrramk'ĩir pʌ̈yaag. Hich mak'ʌʌnta hich hiek jaaujem k'ʌʌnk'a t'ʌ̃rjim haajem, apostolnaan. ");
INSERT INTO noaH_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Maimua mag doce jʌr hautarr k'ʌʌnag hĩchab hich jua t'eegjã deejim haajem, hich dënjö hõor mor masim k'ʌʌn monaaunaa mor hee mepeer k'aigbam sĩsidʌmpa jʌr wërpmamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mag hichdëu doce jʌr hautarr k'ʌʌn t'ʌ̃r, mʌk'ʌʌn hajim: Simón, (hichpai Jesuu Pedro ha t'ʌ̃rjim); ");
INSERT INTO noaH_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, jöoi Zebedeo hiewaa, (hichpai hĩchab Jacobo haajeejim); Juan, hagjö jöoi Zebedeo hiewaa, chi Santiago heeum; (Mak'ʌʌn Santiago Juan dʌ̈ita hamach numwe Jesuu “Boanerges” ha t'ʌ̃rjim haajem, ham hibʌʌr wau t'ʌ̃r; mag “Boanerges” ha sim haiguin, k'õrg pagt'ʌmjö sĩerrjëem ha simʌu.) Maimua mag tag ");
INSERT INTO noaH_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, (hichpai Leví ha t'ʌ̃r sĩejim); Tomás, Santiago, chi Alfeo hiewaa, (hichpai hagjö Jacobo ha t'ʌ̃r sĩejim); Tadeo, (hichpai Judas hanaa Lebeo haajeejim); Simón chi Cananista, maimua ");
INSERT INTO noaH_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, (hich maguata hewag pawi t'et'em k'ʌʌnag Jesús pʌr deeju hajima, hi t'õomk'ĩir). Mag hich k'apeen hich dʌ̈icha hogdʌba wënʌrraju k'ʌʌn jʌrk'a hauwi degag bëejierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mag bëewi hõrau hi deg pabaichëm k'aug hat'aawai hi haig hõor pöoma biirdʌbaadëjim haajem. Mag hõor pöm bëe t'ʌnaawai bʌ̃ʌrjã jua par k'abam gaaimua Jesujã t'ach k'öba ni hi k'apeenjã pöd t'ach k'öba naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús haar mag hõor pöm jũrr p'ẽp'ẽeuk'am gaaimua pöd t'achjã k'öba sim ha hũr hat'aawai chi k'odnaanau hi hawaan wëtjierram haajem, lökiebaadeewaita mag t'achjã k'öba simpii hawia. ");
INSERT INTO noaH_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mag nʌm dʌ̈i hĩchab Moiseeu Hẽwandam hiek p'ã pʌatarr jawaag chi machnaan Jerusalén p'öbör heemua bëetarr k'ʌʌnaujã hi higwia, “Jãan dösãtnaan pör Beelzebú haajem dʌ̈i k'apeerk'a sĩewai hag juapaauta jãg hõor mor heem mepeenjã dau daau jʌrk'ʌʌi nʌrrabahab” hanaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mamʌ ham mag hiek'a nʌm hich Jesuu k'ap'ʌ sĩerr haawai warag hich haig ham t'ʌ̃rk'a hauwi hamag, —Mua pãrag jëeu hook'imgui hajim hanʌm: ¿Pãrau k'ĩirjuawai meperau hichdëupai wir haig hichjöm k'ʌʌn dawag jʌrk'ʌʌiju k'ai? Meperau chan bën k'aigbam chawag jʌrba haajemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gobiernoou k'ãijã hõor pöm hich higar t'ʌnʌm jãrrcha t'öonaa hamach wir haigpai wërbʌpik'iin, hamach wir haigpai höbapäaiwai mag gobierno hich mag nem jua t'eeg sĩerrabaju. ");
INSERT INTO noaH_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wa magbam k'ai, woun hãb hich chaain dʌ̈ipai meeuk'awi hamach wir haigpai wërbʌk'iin, warag haaidʌju. ");
INSERT INTO noaH_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hich hagjöta simgui hajim hanʌm, mepeerjã. Meperau wir haig hamach heepai juurhi p'iriupʌ̈ik'iin, magan warre hamach höpʌ̈ijuuta hẽk'a p'öbaadëm. ");
INSERT INTO noaH_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Magnaa hamag, ’Pãadë mʌ sëu hawi wajap'a k'ĩirjubat hajim hanʌm. ¿K'aíu mʌg nʌm haig sĩi hãb jierrnem wajap'am dʌ̈i hich di t'ʌa sim haig dubwi hi nem jĩgk'aju k'ai? Sĩi k'apanaam k'ʌʌnau wa hi k'ãai hʌ̃rʌʌcharamua hi hibʌʌr hauwi k'abam chan pöd hi nem jĩgk'abam. Hich hagjöta sĩebahab hajim hanʌm, mepeerjã. Mʌ hi k'ãai jua t'eeg k'aba chirak'iin, muajã pöd hõor mor heem mepeen jãg dau daau jʌr wërpbajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mag hiek'amamua hich Jesuupai hamag magjim haajem: ’Pãadë pãach jʌ̃gʌucha wajap'a hũrbat cha mua jawaagpam: Hẽwandamaun chadcha hõor k'aibag t'umaa chugpaaju, ham parhoob hiek'amarrpa t'um. ");
INSERT INTO noaH_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mamʌ pekau hãb sim, maan mua Hẽwandam Hak'aar jua t'eegau nem wau chitʌm hoo nʌmta warag mepeer gaai t'ʌ nʌmʌu. Mag pekau chan Hẽwandamau bʌ̃ʌrjã perdonaabamgui hajim hanʌm, hi Hak'aar higwiata mag hiek'a naawai. Magua Hẽwandam Hak'aar higwiata mag k'aigba hiek'amʌn, mag wounan Hẽwandam dʌ̈i hiekk'õr pöomata hich mag chirsijugui hajim hanʌm, perdonaajã k'augba. ");
INSERT INTO noaH_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesuu hamag mag hiek'atarran, Moiseeu Hẽwandam hiek p'ã pʌarr jawaag chi machnaanau hich Jesús higwia “Jãan Beelzebú dʌ̈i k'apeerk'a sĩewaita jãg nem jua t'eeg hõor mor heem mepeenjã jʌrk'ʌʌi nʌrrʌm” ha hiek'a narr haawai hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mag nʌm hee hich Jesús hãd hi heeugpeen dʌ̈i hi haig bëejierram haajem. Mamʌ sĩi hõor pöm t'ʌnʌm k'urau pöd hi haar dubba, daaugajãrpai nʌisiwia jũrr hamach garmuata dawag hi t'ʌ̃r naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Magbaawai hi haig narr k'ʌʌnau hirig, —Pʌ hãdau pʌ heeugpeen dʌ̈imua pʌ hʌ̃p'ʌʌinpa daaugajãr pʌ jʌr wënʌrrʌm, pʌ dʌ̈i hiek'aag haajem ha jaaujierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Magbaa hichdëu hamag, —¿Chijã hagá mag mʌ hãd, maimua chijã k'ʌʌn hagá mag mʌ heeugpeen? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Magnaa hich bigaau hohoodö narr k'ʌʌnag heerpanaa magjim hanʌm: —Chamʌ k'ʌʌnta mʌ hãd hanaa mʌ heeugpeenau. ");
INSERT INTO noaH_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mʌrʌgan Hẽwandamau k'õsimjö nem wau nʌm k'ʌʌnta mʌ hãd hanaa mʌ hʌ̃p'ʌʌinau, maimua hĩchab mak'ʌʌnta mʌ k'odnaanau hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Deeu hũmaai Jesuu Galilea t'ʌrrdö higaau Hẽwandam hiek hõrag jaaubaadëjim haajem. Mag hirua jaau sim hũurwai, sĩi hõor pöoma hich bigaau pos p'ʌʌrbaadeewai, haig bote sĩerr hee waaidʌwia, dö jãrraapai hoo jöisijim haajem, jũrr mammua jawaag. Magbaawai hõor pöm mag t'ʌnarrau durrpaimuata hi hiek hũr naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mag mos higaau hõor pos t'ʌnʌmʌg ejemplodampa jaaumamua, —Mua pãrag nem hĩgk'aadam jaauk'im; wajap'a mʌ hiek hũrbat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Maimua magjim haajem: —Biek hãb, woun hãb trigo dau p'öon majimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mag mawi chi nemjĩir dau hirua p'ötarr, hãaurag bʌ̈ diichjem hee burrjim haajem. Magbaa nemchaain bëewia sĩi t'umaa k'ök'ʌʌipʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Maimua hãaur k'ʌʌn sĩi mokpör jojoodög heeta burrjim haajem, hajappai jẽb chuk'u sĩerr hee. Mak'ʌʌnan chi t'arrp'ëen hʌ̈u jöpcha t'arrp'ëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mamʌ mag durrk'u hʌ̃rʌʌ sim hiek'au pöd hierr k'aar jẽrk'aba hʌ̃rʌʌta k'aark'a k'ëk'ëd harr haawai, hed pechag wʌʌbaadeeu, sĩi hë nanauk haadëmua p'uabaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Maigmua hĩchab tagam p'ötarr, miudö harr hee burrwia, chi miiuta nemjĩir k'ãaijã bãau k'ap'í bãauwi, sĩi chi nemjĩirdam hichdëuta pör pʌrëu hich magpai dau hap'ʌʌ nʌisijim haajem, sirp'ʌg hee hag gaai jopjã jopba. ");
INSERT INTO noaH_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mamʌ tagam hʌ̈u jẽb wajaug hee burrtarran wajaug höbërwia hʌ̈u nem hajaug sĩi p'ur jopjim haajem, nem bich dapag maimuajã bich t'ʌʌ, maimua pogk'a bich daii; mamʌ mag sĩsidʌm chan bʌ̃ʌrjã chi vano chuk'u. ");
INSERT INTO noaH_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mag hĩgk'a höbaadeewai haig hich hiek hũr narr k'ʌʌnag, ’Keena, jʌ̃g hʌ̃rʌʌnaa chamʌg nem hĩgk'aadam mua jaaubarm wajap'a hũrbat hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mag Jesús haig hõor pos t'ʌnaawia ya hõor jigdʌdʌ k'abaadëm hee, hõordam hagt'a hi dak'apai hi k'apeen dʌ̈i hãba hohoodö narr k'ʌʌnau k'ap haag hirig jëeujierram haajem: —Ma chaig pua nem hĩgk'aadam jaau sĩerrau ¿k'ani jaau simma? Marag jaaubá hajierram hanʌm, wajapcha k'ap'ʌ haag hit'ee. ");
INSERT INTO noaH_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Magbaa Jesuu hamag magjim haajem: —Pãrau k'augam k'õsi hũr naawai mʌchdëun warre pãrag k'ap'ʌ hapi chirʌm, jãgata Hẽwandam hõor t'ãar hee sĩeicheejẽ. Pari har hi hiek bʌ̃ʌrpaijã hʌ̈k'abam k'ʌʌnag sĩi nem hĩgk'a nʌmuapaita jaaujemgui hajim hanʌm, ");
INSERT INTO noaH_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","maagwai mag sĩi k'ajap'am nem hĩgk'aadamjöpai hũurwai par hamau hamach jʌ̃gʌucha hũrnaa hamach dak'ĩir nem wau nʌm hoo nʌmjã hoobamjö hamk'ĩir; mag nʌm gaaimua Hẽwandamagjã hamach k'aibag chugpaapi jëeuba haawai Hẽwandamau ham k'aibagjã chugpaaba hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Maimua hamag, ’¿Mʌg nem hĩgk'aadam merag chuk'u k'itʌmjã pãrau k'augbata nʌ? hajim hanʌm. Mʌg p'it'ur k'aba simjã k'augba nʌm chan magan deeum nem jaauk'iinjã ¿pãrau jãga k'augjuma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cha mua nem hĩgk'aadam pãrag jaaubarmʌn mʌga simgui hajim hanʌm: Chi nemjĩir dau p'ö nʌrrarr woun, woun hãb Hẽwandam hiek hõor hee jaau nʌrrʌmjöta sim. ");
INSERT INTO noaH_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maagwai mag chi nemjĩir dau hõor bʌ̈ diichjem hee burrtarr, sĩi har Hẽwandam hiek jaau nʌm hũurjem k'ʌʌnta jaau simgui hajim hanʌm. Mag hũrnaa bʌchk'un k'augtarrdam meperau bëewia pör heem warre k'ĩir hak'oopibapäaiwai hũrba harrjöo t'ʌba nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Maagwai hãaur k'ʌʌn, chi nemjĩir dau har mokpör jojoodög hee burrtarrjöta naabahab hajim hanʌm. Hẽwandam hiek hõrau jaau nʌm hamach jʌ̃gʌucha hũurwai warrpemʌn hamau k'õchag hʌ̈k'a nʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pari mag chi nemjĩir wajap k'aar k'aba harrjö hagt'a Hẽwandam hiek gaai hubʌ k'aba naawai, mag Hẽwandam hiek hamachdëu hʌ̈k'a nʌm gaaimua hamach p'it'urg haunaa, bigaaum k'ʌʌnaujã hamach dʌ̈i k'aigbajujö haadeewai, sĩi warag hagʌg hoobamjö höbërwi weetjemgui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Maagwai hãaur k'ʌʌn sĩi nemjĩir dau miudö harr hee burrtarrjöta nʌmgui hajim hanʌm. Hamau hĩchab Hẽwandam hiek hũrm k'õsi hũr nʌm, ");
INSERT INTO noaH_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pari hãsie deeu hewag k'ĩirjuajerram. Ham k'ĩirjugan hãba riknaan k'ajuuta k'ĩirju sĩsidʌm, nem t'um paraa haag. Mag k'ĩirju sĩsidʌm gaaimuata hĩchab, mag nemjĩir sirp'ʌg hee haadeewai sĩi dau hap'ʌʌ chëba nʌisierrjö, Hẽwandam hiekjã t'ãraucha hʌ̈k'awi hi hit'ee nem wajap'a wawaagjã serbiiba t'ʌnaabahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pari hãaur k'ʌʌn t'ʌnʌmgui hajim hanʌm, har Hẽwandam hiek t'ãraucha hʌ̈k'awi, hi dau na hagchanaa, nem wajap'a waaujem k'ʌʌn. Magʌm k'ʌʌnau har Hẽwandamau nem wajap'a waupi jaauwaijã nem par daúa hooba haajem. Mag waum k'õsi wau naawai hamachdëu nem wauju hayagpierr waaujem: hãaur k'ʌʌnau nemjĩir chi chëmiejö dʌ̈rrcha, hãaur k'ʌʌnau hagpierrpai, maimua hãaur k'ʌʌnau bʌchk'unpai. Mamʌ t'umaam k'ʌʌnau hichiita hichdëu k'õsimjö haajem ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mag jaautarr k'ur hamag magjim haajem: ’Pãrau hoowai, ¿k'aíu hõtdau paanaa sĩi bat'ẽe heegar wa nem bʌ̈ hee k'ãijã hausĩiujẽ? Hõrau mag hausĩuba haajemgui hajim hanʌm. Hõtdaun paanaa dau garta hausĩiujemgui hajim hanʌm, dau hararaa hoog. ");
INSERT INTO noaH_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hich jãgta sĩebahab hajim hanʌm hagjö Hẽwandam hiekjã. Hĩswe chan hõrau hagt'a wajappai k'augba nʌm, jãga Hẽwandamau hõor peerdʌ hauju. Mamʌ jãg hõt bʌ̈ʌg nem hoowai dawaa hoojemjö, mʌg hatagta hamau wajapcha k'ap'ʌ nʌisijugui hajim hanʌm. Chi mag k'augba nʌm k'ʌʌnan hagt'a k'ĩchag hee nem hoo nʌmjöta nʌmgui hajim hanʌm, bʌ̃ʌrjã k'augba. ");
INSERT INTO noaH_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Magwi hich Jesuupai, ’Jʌ̃g hʌ̃rʌʌnaa cha mua jaau chirʌmjö habat hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Maimua magjim haajem: Pãrau mua nem jaau chirʌmta pãach t'ãraucha hʌ̈k'am k'õsinaa, pör hee haunaa warag k'augam k'õsi hamʌn, hich Hẽwandamau hagjö pãar pör höp'ër hapiju, hich hiek hajapcha k'ap'ʌ hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Har chi t'ãar honee hũrm k'õsi hũr nʌm k'ʌʌnag Hẽwandamau warag k'ĩirjug deejugui hajim hanʌm, hich hiek k'apcha hamk'ĩir. Mamʌ har hũrmap'apai hũr nʌm k'ʌʌn k'ĩirjug heemʌn, cha mua jaau chirʌmjö deeu hich hiek sĩepiba, k'echeu haumajugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mag jajawagmamua hĩchab hich Jesuupai, ’Pãrag deeum ejemplodam jaauk'imgui hajim hanʌm, jãga haajẽ hõrau mag mʌ hiek hʌ̈k'am k'õsi hʌ̈k'awi hamach t'ãar hee haauwai. Mag mʌ hiek hamach t'ãar hee hau nʌmʌn, woun hãbmua nemjĩir daudam jĩir sĩubarmjöta simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mag jĩir sĩubaawai t'arrp'ëwia hedaram magwe bãau hëhëek'am. Mamʌ mag bãau hëhëek'am chan chi jĩirtarraujã bʌ̃ʌrjã k'augba sim, jãga mag hich happai bãaumamua hʌ̃gt'aa papagmá. ");
INSERT INTO noaH_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Maan mag simʌn, ya jẽb hee sĩewai chi jẽbëuta hich happaimua mag bãaupi sim k'abahab. Nacha t'arrp'ëwi bãau sim, maimua dʌ̈rrcha haadeewai bi p'ũp'ũid haadëwi hũhũi jöisim. ");
INSERT INTO noaH_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maimua mag t'ʌnʌʌ hawi ya p'ur haadëm. Mag p'ur haadeewai t'umaam k'ʌʌnau ya k'ap'ʌ nʌmgui hajim hanʌm, t'ʌʌju haai haadëm. Magbaawai t'ʌʌwi deg paa t'ʌnʌʌujem. Hich hagjöta simgui hajim hanʌm hĩchab mʌ hiekjã: Hõrau k'augmampierr bãbãwagmamjöta sim, warag hich Hẽwandamau k'õsimjö wënʌrraa k'ap'ʌ paauk'amaawai. ");
INSERT INTO noaH_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesuu mag jaaumamua, ’¿Pãrau k'ap'ʌ nʌ, jãga sim habarí Hẽwandam hiek mua jaau chitʌm, maimua k'anjöta sim ha mua pãrag jaaubark'iin? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mʌg mua jaau chitʌm hiek'an, mostaza daudam woun hãbmua hich dik'u gaau jĩir sĩubarmjöta simgui hajim hanʌm. Hichta nemjĩir daudam t'umaam k'ʌʌn k'ãaijã bʌ̃rʌʌcha k'itʌm. ");
INSERT INTO noaH_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pari mag bʌ̃rʌʌ k'itʌmta jẽb hee jĩir k'ërbarmʌn sĩi pabʌ̈ pöm hãdëe bãaujem. Magbaawai nemchaain bëewi chi piu gaai hamach di hëeujem. Hich hagjöta simgui hajim hanʌm hĩchab mʌg Hẽwandam hiek mua pãrag jaau chitʌmjã: Mʌʌgwaiwe chan k'apan k'abata hʌ̈k'a durrum; pari mag durrumuata warag nem pöm haaidʌbapäaiwai hõor k'apank'am k'ʌʌnauta hʌ̈k'aju ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mag ejemplodampa jaaumamuata Hẽwandamau maach peerdʌ haaujem hiek Jesuu jaaujeejim haajem, magʌm gaaimua wajapcha k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mamʌ ejemplo chuk chan mag hõor pöm wëjömʌg bʌ̃ʌrjã nem jaauba haajeejim hanaabá. Mag ejemplodamaupa nem jaaumatarrta hich k'apeen dʌ̈i hamach happai haadeewain deeu wajap'a hamag jaaujeejim haajem, wajapcha k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hich hag hedpai ya k'eeuraa haadëm hee, Jesuu hich k'apeenag, —Wëttarrau hajim haajem, dö k'ĩijãr t'ʌrrdö higaau. ");
INSERT INTO noaH_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Maimua chadcha hõor haig narr k'ʌʌn p'ëpʌawi, ya hich Jesús bote hee waaidʌwia hoo wëjorr haawai, chi k'apeenau hi joo harrjim haajem. Mag ham wëtum dʌ̈i deeum bote haig narrjã hagjö ham dʌ̈i wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mag ham döjãrr paauk'a p'öbaaderr hagt'a pöm k'aba nʌm hee, p'ũ t'eeg wëbaadëmua sĩi p'ũasdau baupa jöisijim hanʌm. Mag p'ũas baupa haadëmua bote hee p'ũasdau sog bëbëek'amua ya chi boteeu hãwatbajujö hierrpamaa hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mamʌ mag nʌm hee hich Jesús bote k'ua pörk'au gaai sĩiuba k'ãi jörrajim haajem. Magbaawai hi k'apeenau jãp'ierr nʌm hiek'au hi p'iriupʌ̈iwia hirig, —¡Maestro, p'iidʌbá! Pua chan mʌg maach k'öomamjã k'augbahab hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Magbaa Jesús p'iidʌwia mag p'ũ t'eeg t'ʌnʌmʌg meeurrau sĩunaa hĩchab p'ũas meeuk'a t'ʌnʌmʌgjã “T'umbabaad” habaawai, warre döjã meuu sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Magwi hich k'apeenagta, —¿K'an jãgwi pãar jãg hatcha jãp'ierr nʌma? ¿Pãrau mʌ mʌg pãach dʌ̈i mʌ chitʌmjã k'augbata nʌ hajim hanʌm, jãgcha jãp'ierraag? ");
INSERT INTO noaH_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jesuu hamach dak'ĩir mag p'ũas dʌ̈i p'ũpa meeuk'a t'ʌnarr t'umba hat'am hoowia dauderraa nʌm hiek'au, “Keena, ¿mʌʌn k'anim wounta jãg p'ũujã p'ũas dʌ̈imua hi hipierraa nʌma?” ha jëjëeu haajeejim hanaabá hamach wir haigpai. ");
INSERT INTO noaH_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mag k'odjörröo hawia Gadara durr p'ẽeubaimajierram haajem, hich hag t'ʌrrdö heepai t'oom higar. ");
INSERT INTO noaH_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mag p'ẽeubaimawia Jesús bote heemua waaidʌwia durrpabaadëm hee, hi k'ĩirp'ee woun hãb dösãt bënëu bar simta durr hujã haarmua hi haig k'ap'ig bëejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mag woun sĩi hujã hee hõor hauk'eerjem jẽbdegpai sĩejeejim hanaabá. Mag sim chan par hõrau pʌr haunaa cadenau jʌ̃ sĩsiuk'amjã pöd jʌ̃ wai naaba haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mag juapa t'eeg sĩewaita biek k'apan parii hõrau cadenau bʌ̈ jʌ̃naa juapa jʌ̃ sĩsiuk'amjã, sĩi warag chi cadenta t'ʌrrëu pʌpʌa haajeejim hanʌm, ni hãbmuajã pöd pʌr wai sĩeba. ");
INSERT INTO noaH_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mag simʌn hedaram magwe sĩi pabʌ̈ heeta nʌrranaa hujã hʌ̃rʌm magwe nʌrraajeejim hanaabá. Mag nʌrrʌmʌn sĩi parhooba hähäagmamua mokdau juajã gar haunaa hichdëupaita hich p'ãrmaajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mamʌ mag nʌrrʌmua warpwe Jesús hoo hat'aawai sĩi warag hi simʌgta k'ap'ig bëewia hi k'ĩirp'ee p'õbk'abaichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mag p'õbk'achënaa t'et wiiu hanaa hirig, —¡Jesús, cha Hẽwandam hʌ̃gt'aa p'uu nʌm Hiewaa! ¿K'ant'eeta pua mʌ mʌg k'aibag waubaichëma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chi wounau hich garmua Jesuug mag hiek'atarran, maan Jesuu ya hag nawe chi mepeer mag woun mor hee simʌg chawag höbërpi jaautarr haawaita hirua mag hiek'ajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Magbaa Jesuu hirig, —¿Pʌ k'an ha t'ʌ̃ʌrjẽwi? hajim hanʌm. Magbaa chi wounau, —Mʌʌn “Mepeen P'öbör” ha t'ʌ̃ʌrjemgui hajim haajem, maar nem k'apan sĩerrjëe haawai. ");
INSERT INTO noaH_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hich mag wounau hirig hö bʌ̃rʌʌ haadëp haajeejim hanʌm, maigmua warp chi mepeen jʌrk'ʌʌipʌ̈im hugua. ");
INSERT INTO noaH_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Maig dak'a durr bʌ̈k'ʌrr k'ũsnaan k'apan p'at'au jʌr k'ö wënʌrrarr haawai ");
INSERT INTO noaH_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","chi mepeenau, —Magan har chum k'ũsnaan k'apan t'ʌnʌm haar maar pʌ̈iwi jũrr jãk'ʌʌn k'ũsnaan heeta marag dubpi jaaubá hajierram hanʌm Jesuug. ");
INSERT INTO noaH_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Magbaa chadcha Jesuu mag chi woun mor heem mepeenag höbeerpi jaauwi, jũrr mag k'ũsnaan k'apan dos miljö narr heeta dubpi jaaubaawai, chadcha mak'ʌʌn heeta dubp'öbaadëjim hanaabá. Mag mepeen k'aigbam pöm k'ũsnaan hee dubp'öbaadeewai sĩi parhooba k'ap'ig p'öbaadëwi hit'urmʌg hʌ̃rmua t'ʌrrdö hee dʌrbagk'a sĩi dö hee jogaa k'ëchdubjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mag hoobaawai hajap jãp'ierrwi chi t'ʌa narr k'ʌʌn parhooba k'ap'ig p'öbaadëjierram hanʌm, hõrag jawaan. Mag wëtwi p'öbör heejã jaauwi maimua p'öbör higaau di hãhãbdö nʌnʌidʌm heem k'ʌʌnagjã t'umwe jaaumajierram haajem. Hamachig mag jaaumaawai hag bʌ̈rre hõrau haar hoon weetjeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mag wëtwia Jesús haar barimawia hooimaawai, chi woun mag dösãt dʌ̈i sĩerr k'ajũa wajap'a jũawia maach k'ĩir hich mʌg jup hoo sim hooimajierram hanaabá, sĩi magʌm bën k'aigbam pöm mor hee chuk'u sĩerrjö, monak'a. Mag hoowai hõor dauderraa naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mamʌ mag hamach daúacha Jesuu mag woun bën chugpaapʌ̈iwia chi k'ũsnaanjã lökiewi dö hee jogaa k'ëchtarr horr k'ʌʌnau jũrr deeum k'ʌʌnag nem hĩgk'amajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chi hag perás joobaajerr k'ʌʌnau mag hũrbaawai Jesuug jajaau haajeejim hanʌm, hamach durrmua chawag mamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mag hich jʌrbaadeewai, deeu maag hawi, hich bëetarr boteeg mawi hag hee waaidʌbaadëjim haajem. Mag hi mam hoobaa mag chi dösãt bën wai sĩerrau hich harrmk'ĩir hirig jëeujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pari Jesuu hich dʌ̈i harrbajim haajem. Sĩi hirig warag, —Pʌch diig mawia pʌch k'odnaanag jaaubamí hajim hanʌm, jãga Hẽwandamau hʌ̈u pʌ dau hee haug k'augwia pʌ monaaubar. ");
INSERT INTO noaH_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jesuu hichig magbaawai chadcha hi hipierr mawia Decápolis durr p'öbör nʌnʌidʌm hee hõrag jaaumajim hanʌm, Jesuu hi dau haug k'augwi hʌ̈u hi bën chugpaatarr. Mag jaaumam hũrwi t'umaam k'ʌʌnta jʌ̃gderraa naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mag chadcha Jesús deeu Gadaramua dʌrbawia, t'oom higar nacha hich sĩerr haar barbaimaawai, hõor pöm hi bigaau p'ʌʌrbaadëjim hanʌm. Magbaawai pöd durragjã maba, hich haigpai dö higaau sĩsijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mag hõor pöm p'ẽp'ẽeuk'am hee, woun hãb Jairo ha t'ʌ̃r sim hi haig bëejim haajem. Mag jöoi judionaan Hẽwandam hiek jaaujem deg chi pörnaan t'ʌnʌm heem hajim haajem. Mag bëewia, Jesús bʌ̈k'ʌrr p'õbk'achëwia, ");
INSERT INTO noaH_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","chaigpamamua, —Mʌ k'aan parba jã heemuapai k'ërʌmta hoo pʌajim, mʌ di haar marraugui hajim hanʌm. Mua k'ap'ʌ chirʌm, puata mʌ k'a jua pʌrmʌn hʌ̈u hi peerdʌ haujugui hajim hanʌm hich Jairoou. ");
INSERT INTO noaH_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mag Jairoou hich di haar hëeurrbaicheewai Jesús chadcha hi dʌ̈i majim haajem. Mag hi mam dʌ̈i hĩchab hõor pöm hi hẽudee p'ẽeudʌ wëtmajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mag hõor k'apan pos wëtum hee hʌʌi hãb sĩejim haajem, doce años sĩi p'õmieu bar sim. ");
INSERT INTO noaH_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mag k'itʌmʌn wajap hʌʌi dau haug waaujeejim hanʌm, doctornaanag hich monaaupiju hẽk'a nʌmjã pödba haawai. Parii bënhë gaai hich p'atk'ondam wai k'ërarr t'um gastaapʌ̈itarrjã bʌ̃ʌrjã monaauba, waragta heeg pamaa hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hich mag hʌʌyau hũr hat'ajim hanʌm, Jesuu hõor mor masim k'ʌʌn monaau nʌrrʌm. Hichdëu mag hũrbaawai hi haar hõor pos t'ʌnʌm hee t'et p'ẽeudʌ mawia hëugarmua meraa hi k'ajũa gaaipai sĩi pʌrimajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Hirua mag meraa pʌrimatarran, hich hödegpai, “Sĩi mua hi k'ajũadam gaai pʌrbarmuapai mʌ monaau hʌisiju” ha k'ĩirjuwiata mag pʌrimajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mag chadcha hirua Jesús k'ajũa gaai pʌrbarm bʌ̈rre chi p'õmie mag t'ʌnarrjã warre t'ʌbabaadee warre hich mag monaau sĩsijim hanʌm. Magbaa hʌʌyau hĩchab warre hich k'a jʌʌubaadëmjã k'aug hat'ajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mamʌ hĩchab mag hich gaai pʌrbaichëm bʌ̈rre Jesuu k'aug hat'ajim hanʌm, Hẽwandam juapá hich gaai simua hʌʌi hãb monaaubapʌ̈im. Magbaa Jesuu mag hõor pos t'ʌnʌmʌg heerpanaa, —¿K'aíuta mʌ k'ajũa gaai pʌrbaichëma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Magbaawai jũrr hich k'apeenaupai hirig, —¿Jãga mag k'aíuta mʌ gaai pʌrbaichë haju? Pua hoobahab, hõor k'apan pʌch haig p'ẽp'ẽeuk'am. Mag nʌmʌ mag “K'aíuta mʌ gaai pʌrbaichë” ha sĩeb hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mamʌ mag jëeu buburrk'amjã ni hãbmuajã hichig jaauba haawai hich bigaau hõor nʌm k'ʌʌnagta hoop'ʌʌrdʌdʌ haajeejim hanʌm, mag hich k'ajũa gaai pʌrchëtarr hook'aawai. ");
INSERT INTO noaH_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mamʌ mag meraa hi gaai pʌrtarrta hich k'aug hat'aawai jãp'ierr nʌm hiek'au sĩi k'a duui Jesús haig bëewia hi k'ĩirp'ee kanieu p'õbk'abaichëjim hanaabá. Magwi chadcha meerba jaaujim hanʌm, mag hichdëu hi k'ajũa gaai pʌrtarr. ");
INSERT INTO noaH_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mag hichig meerba jaaubaawai Jesuu hirig, —Mua pʌch monaauju k'ap'ʌ mʌ gaai pʌrchëtarr gaaimua, hʌ̈u pʌ monaauwi peerdʌjã peerdʌ hʌisimgui hajim hanʌm. Ya pʌ monak'a hʌisiewai pʌch diig maju haai hʌmgui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús hagt'a mag hiek'a dʌnʌm hee, mag judionaan Hẽwandam hiek jaaujem degam chi pör Jairo hanʌm di haarmua hõor bëewi hirig, —Kakë, ya haaunaanaujã pöd hãwatba habarm; hidëu Maestro sĩubá hajierram hanʌm hirig. Ya par maach haar hi mabajup hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pari Jesuu hamau mag jaaubaichëmjã hasekasba, chi Jairoogta, —Hoob k'ĩirjum; sĩi mag k'ãai warag pʌch chaai hoo wai chitaju k'ĩirjugta wai chirsí hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Maimua ya warag Jairo dʌ̈i hi di haar mam harr haawai hich mam dʌ̈i hõor k'apan harrbajim haajem. Hãba hich dʌ̈i harrtarr k'ʌʌnan Pedro dʌ̈i Santiago hajim haajem, maimua Juan; mak'ʌʌn t'ãrjuppai harrjim haajem hich dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mag wëtwia di haar barimawia hooimaawai Jairo deg sĩi bĩep sereu t'ʌnʌm dʌ̈i hõor p'ogdʌ t'ʌnʌmjö t'ʌnʌm hee jũrram k'ʌʌnau hʌ̃apëpërk'amta hũrimajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Magbaa hich Jesuu hierr mag ham sereu t'ʌnʌm haar dubwia hamag, —¿K'ant'eeta mag hatcha sereu t'ʌnʌ́ma? hajim hanʌm. Hoob bĩemiet. Chaai meeba sĩi k'ãi k'ërʌm k'abahab hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mamʌ Jesuu mag chaai meeba sĩita k'ãi sim habaawai haig narr k'ʌʌnau warag hi wau hiek'a naajim hanaabá. Mamʌ hich gaai hiuk'a nʌmjã ham hiek hasekasba, warag t'umaam k'ʌʌnag dawag höbërpi jaauwi, chi binaandam dënnaan maimua hich k'apeen t'ãrjup hich dʌ̈i p'ë harrtarr k'ʌʌnpaita hich dʌ̈i hierrag dubpijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mag chi binaandam haar dubwi, hi juadam gaai pʌr haunaa hirig, —Talita, kum hajim hanʌm. (Mag sim haiguin maach meúan, “Hʌʌik'aardam, p'iidʌbaad” ha simʌu.) ");
INSERT INTO noaH_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Magbarm bʌ̈rre chadcha p'iidʌwia hõor dak'ĩir monak'a dʌr nʌnʌʌu k'abaadëjim hanaabá. Mag hoobaawai chi dënnaan maimua hich Jesús k'apeenpa warre dauderraa nʌisijim hanʌm. Hich mag chi daupeerdam Jesuu p'iriu hautarr, doce años sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mag p'iriu hauwi chi chaairag t'achdam deepi jaaujim hanʌm, k'ömk'ĩir. Mamʌ mag daupeerdam hichdëu p'iriu hautarr chan bʌ̃ʌrjã haig narr k'ʌʌnag jaaupibajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mag chaai chi meem harrta deeu p'iriu hauwia, Jesús hich bãautarr durr p'öbör Nazaret hanʌmʌg petajim hanʌm. Mag hi petam dʌ̈i hi k'apeenjã hi dʌ̈i wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mag mawi barimawia, ya jua hʌ̃ʌijem hed pabaadee, maar meeun Hẽwandam hiek jaaujem deg mawi Hẽwandam hiek jaaubaadëjim haajem. Mag hirua jaaumam hũrwia haig hõor pöm t'ʌnarr k'ʌʌnau jʌ̃gderraa nʌm hiek'au hamach wir haigpai jëjëeuk'amua mag naajim hanʌm: —¿Magʌm hiek hichdëu jamta k'augjimta mag hiek pöm jaaumáma? ¿Jãga jãg hõor monaau nʌrrʌ́ma? hanaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Keena, pãrau hoowai, ¿hich mʌg woun kalpinter k'abá hanaajim hanʌm, María hiewaa? Hi heeugpeenauwai, Santiago, José, Judas maimua Simón. Hi hʌ̃p'ʌʌin k'abahab hĩchab har mʌig hich mʌg p'öbör hee naajem k'ʌʌn; maagwai hichjã maadëu k'ap'ʌ nʌm, hich mʌiguim haawai. ");
INSERT INTO noaH_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pari magbaa Jesuu hamag magjim hanʌm: —Chadcha deeum durram k'ʌʌnaun mʌg Hẽwandam hiek jaau wënʌrrʌm k'ʌʌnag heenaa ham dʌ̈i hajap'a haba haajeeb. Pari mag sim jũrr dich bãautarr durrpai chan ham k'a k'õchk'abanaa hamach k'odnaanau ni hamach dʌ̈i hãbam deg joobaajem k'ʌʌnaujã ham k'a hisëe haajemgui hajim hanʌm hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mag warag maig chan Jesuu hõor mor masi narr k'ʌʌn t'um jua pʌrbajim haajem, hamachdëu mag hirua jaau sim hʌ̈k'aba harr gaaimua. Daudam k'apan k'aba hichdëu jua pʌrtarr k'ʌʌnpai monaaupʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mag hichdëu Hẽwandam hiek jaau k'itʌm hʌ̈k'aba nʌm hoowi hich Jesúpata warag t'umaa k'ĩirjuwi hök'ĩirjuu haadëjim hanaabá. Magbaawai hichta warag mawi jũrr haigmua p'öbördam dak'a sĩsidʌm hee Hẽwandam hiek jaau nʌrraajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mag nʌrrʌmua Jesuu biek hãb hich k'apeen doce hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌn hãbam haig t'ʌ̃rp'ë hauwi nunumdö pʌ̈yaagpajim haajem. Mag pʌ̈yaagpamua hĩchab hich juapa t'eegjã hamag deemajim hanʌm, mag juapaau hõor mor heem dösãt bën k'aigbampa hich dënjö jʌr wërpmamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Magwia hĩchab k'ʌd hee k'ömaagjã bʌ̃ʌrjã hamag nem hinag harrpiba, ni talegdijöm, t'achjöm, ni p'atk'onjã harrpibajim haajem. Hãba harrpitarran bordondampaita harrju haai nʌm hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hich hagjö zapatjã hamachdëu jũa narrdampai harrpiwi k'ajũajã hamach mor gayam dʌ̈ipaita wëtju haai nʌm ha jaaujim haajem, deeum t'eg jũjũa haagjã harrba. ");
INSERT INTO noaH_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mag jaauwi hĩchab, —Pãach wënʌrrʌmpierr pãachig di jaaubarm degpai k'eeupaawai k'ãibat hajim hanaabá, pãach maigmua chawag wët nʌm hora. ");
INSERT INTO noaH_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dëgölp k'ãijã hõrau hamach deg pãach dubpiba habaawai, wa pãachdëu hamachig Hẽwandam hiek jaau nʌm k'ãijã hũrba habaawai, warre hamach dak'ĩirwe pãach bʌ̈ gayam jẽb hʌʌrp'ë hʌʌrp'ënaa pãachta hërëubaadët hajim hanʌm. Pãrau magmʌn magbarmuapai hamag, “Pãach jãg Hẽwandam hiek hũrba habarm gaaimua hich dʌ̈ita k'ĩir k'ap'ʌ habat” hanʌmʌugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hamachig magbaawai chadcha hërëubaadëwia p'öbörpierr hõrag Hẽwandam hiek jaaumamua, “Pãach pekau pöoma nʌm hãsie hewag k'ĩirjuwia Hẽwandamagta chugpaapi jëeubat” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mag jaau wënʌrrʌmua hĩchab dösãt bënëu baarjerr k'ʌʌn mor heem bën k'aigbampa jʌr wërpnaa, pabʌ̈ olivo hanʌm k'aúa hõor k'amor masim k'ʌʌnjã k'a p'urnaa, Hẽwandamag jëeubaa hõor pöm monaaupʌ̈i maajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesuu mag hõor mor masim k'ʌʌn pöm monaau nʌrrʌm gaaimua sĩi hõor hee t'ʌ̃rp'öo sĩejim haajem. Mag nʌm hee Rey Herodeeu hũr hat'ajim hanʌm, hirua nem wau nʌrrʌm. Mag hichdëu hũr hat'aawai Jesuuta Juanpii hawi, “Maan Juan hõor pör choomie k'ararrta deeu hiiu p'iidʌwia mag nʌrrʌm; maguata mag hõor mor masim k'ʌʌnpa monaau nʌrrabahab” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mamʌ hirua mag sim hee bigaaum k'ʌʌnau, “Jã warr jöoingar Hẽwandam hi jaaumie Elías haajerr k'abahab” haajeejim hanʌm, Jesús higwia. Mamʌ jũrr magbaawai hãaur k'ʌʌnau, “Jã sĩi warr jöoingar Hẽwandam hi jaaujerr k'ʌʌnjö Hẽwandam hiek jaaujem k'abahab” haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jũrram k'ʌʌnau mamagk'am hũrbaawai chi rey Herodeeu, “Mʌrʌg chan ma chan deeum k'abam. Mua k'ĩirjuawain maan Juan chi hõor pör choomieu, har mua hi hö t'ʌappʌ̈ipitarr. Hichta deeu hiiuwia mag nʌrrabahab” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Hirua mag sĩerran mʌg hajim haajem: Maata hich Herodeeu hich naam Felipe hʌʌi Herodías hanʌmta k'echeu hauwi hag dʌ̈i sĩejim hanaabá. Mag hit'eeta Juanau chi reíg, “Pua pöd pʌch naam jua heem hʌʌi k'echeu hauwi pʌch hʌʌik'a hauju k'aba simgui” hajim hanʌm. Mamʌ sĩi hichig magbaawai warag Juan pʌr haupi jaauwi, cárcel deg p'ãar sĩupinaa, cadenau jʌ̃ sĩupijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mamʌ mag nʌm hee chi Herodes hʌʌi Herodías hanʌmuan Juanau mag hiek'atarr gaaimua t'õopimjã k'õsi t'ʌnaajim hanaabá. Pari mag nʌmta pöd t'õoba haajeejim hanʌm, mag chi jayau t'õomk'ĩir jaaubam haawai. ");
INSERT INTO noaH_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mag nʌm dʌ̈i chi rey Herodeeujã Juan hök'ö haajeejim hanaabá, hirua hoowai Juanau chadcha Hẽwandam dau na nem hagcha waunaa hãba hi hiekpai jaaujerr haawai. Maguata Juanau hichigcha hik'ʌaba hiek'amamjã magʌmjã higba, warag hũrm k'õsi hi hiek hũrnaa sĩi hich hödegpai, “¿Jãgata hak'iina?” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mag nʌm hee Herodeeu hich año cumplii nʌm hed p'iejãb pöm waupijim haajem, p'iesta k'aag. Magwi chi t'et'emnaan hich garcharam k'ʌʌn dʌ̈i, comandantenaan maimua Galileapien hagjö chi t'ierrnaanpa hãba t'ʌ̃rk'ʌʌipʌ̈ijim haajem, hich haig t'ach k'oon bëemk'ĩir. Magbarm heeta hĩchab Herodiaaujã Juan k'aibag wauju dawaa p'it'urg chukk'u hoo hat'ajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mag ham t'ach k'ö nʌmta, chi Herodías k'a bëewia hõor dak'ĩir jemk'abaichëjim hanʌm. Mag jemk'abarm chi reíu hich dʌ̈i hãba t'ach k'ö narr k'ʌʌn dʌ̈imua k'õigjierram haajem. Mag wajap'a jemk'abarm hoobaawaita chi reíu hich bãaurrag, —Pʌchdëu nem k'õsim mʌrʌg jëeubá, mua pʌrʌg deeju pʌchdëu nem higbarm hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mamʌ mag hichig nem jëeupipik'amjã chi dauperau bʌ̃ʌrjã jëeuba haawai hichdëuta deeu pʌaba hirig, —Chadcha mʌch himeerba parhoobam nem pʌchdëu k'õsim mʌrʌg jëeubarm mua pʌrʌg deebajupa. Pua mʌg durr mʌchdëu jʌ̃a chirʌm heem jãrrcha k'ãijã mʌrʌg jëeuk'iinjã, hichiita mua deeb k'aba pʌrʌg deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chi rey Herodeeu pʌaba hichig mag jëeupipik'amjã jëeuju k'augba haawai hich hãd haar mawi jũrr hich hãdagta jaauwimajim hanaabá, hichig k'ĩirjugdam deemk'ĩir. Magbaa chi hãdau hich k'aag, —Pʌchig Juan pörta t'ʌapnaa t'ëp hee deepi jaaujuma hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hich hãdau hichig mag jaaubarm bʌ̈rre deeu hich bãaurr jöoi haar mawia hirig, —Rey hajim hanʌm, muan nauwe pʌrʌg Juan hõor pör choomie pörta t'ʌapwia mʌchig t'ëp hee deepim k'õsi hʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mamʌ hich bãaurrau mag hichig Juan pörta jëeubaawai chi rey warre hök'ĩirjuu haadëjim hanʌm. Pari mag hich bãaurrau hichdëu nem k'õsim t'umwe jëeuwiajã hõor dak'ĩir hich himeerba deeju ha hiek'atarr haawai mag hãsie deebamjã habajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Magbaa hag bʌ̈rre hich soldaaun hãb pʌ̈ijim hanʌm, Juan hö t'ʌapnaa hich haig chi pör happai haibëemk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Magbaawai chi soldaaunau chadcha Juan cárcel deg sim haar mawia, hi hö t'ʌappʌ̈inaa, chi pör happai t'ëp hee chi dauperag deechëjim hanaabá. Mag hichig deebaicheewai jũrr hich hãdag deejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mag Juan cárcel deg pʌr wai narr hö t'ʌapbapʌ̈im ha hũrbaawai hi k'apeenau chi mordam cárcel degmua harrwia hauk'ërt'urjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Magtarr k'ur Jesús k'apeen mag hichdëu pʌ̈itarr k'ʌʌn deeu hi haig barchëjierram haajem. Mag bëewia deeu hãbam haig naaicheewai hamachdëu hõrag Hẽwandam hiek jaaujerr dʌ̈i hõor monaaumarrpa t'um hirig jaauchëjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mamʌ mag jũrram k'ʌʌn p'ẽp'ẽeuk'am gaaimua t'achdam k'oogpaijã bʌ̃ʌrjã jua par k'aba narr haawai mag ham nem hĩgk'a höpinaa jũrr hich Jesuu hamag, —Hõor chukag hee maach happai jua hʌ̃yaan wëttarrau hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Magwia chadcha hamach happai haig botedam sĩerr hee hërëubaadëjim haajem, hõor chukag haar. ");
INSERT INTO noaH_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pari mag ham wëtum hõor k'apank'am k'ʌʌnau hoopʌ̈ijierram haajem. Hamachdëu mag hoobapäaiwai, hi barjujã k'ap'ʌ narr haawai, jũrr k'ʌd hee k'ap'ig p'öbaadëwi, hamachta hi barju nawe bardʌtk'aimawia hi nʌ naaimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Maimua barimawia hooimaawai chadcha hõor pöoma pos t'ʌnaajim hanʌm, hi nawe. Hõor pöm mag wëjöm Jesuu hoowai hi dau hee hap'ʌʌ durrajim hanʌm, sĩi nemchaain papjã chuk'u wënʌrrʌmjö narr haawai. Hichdëu mag hoobaawai hamag Hẽwandam hiek jaau wai sĩi hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mag jaau simua ya k'eeuraa haadeewai hi k'apeenau hirig, —Ya hedau k'ëumamgui hajim hanʌm. Mag nʌmta maach chan t'ach k'öjujã chuk'u nʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Maach dʌ̈i mʌig hõor pöm t'ʌnʌm k'ʌʌnag wëtpi jaaubá hajim hanʌm, hõordam di dak'apaim haar wa magbam k'ai p'öbör dak'am haar k'ãijã hamach k'oog t'ach për hawaan wëtamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hichig magbaawai jũrr hich Jesuu hamachigta, —Ham pʌ̈iju k'ãyau pãachdëuta hamag t'ach deejurauma hajim hanʌm. Magbaa chi k'apeenau jũrr hirig, —¿Magan hõor pöm mʌg wëjöm t'um t'ach k'öpiegan doscientos denariota pan gaaipai haupi sĩeb? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Magbaa Jesuu hamag, —¿Pãrau pandam k'arr wai nʌwi? hajim hanʌm. Chuk'u nʌm k'ai, hõrag jëeu hoobat, k'aíu p'iejãb waibëejĩ hich k'oog k'ãijã, maimua mʌrʌg jaaubat hajim hanʌm. Magbaawai chadcha wëtwi, hõrag jëeu hohoogmamua hãbmua pandam cinco maimua hãwarrdam numí wai sim hoobaawai, deeu hi haig bëewia, hich mag hirig jaauchëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Magbaa hich Jesuu hõor k'apan mag t'ʌnarr k'ʌʌnag p'ũak hʌ̃r k'apanaa p'ʌʌr hohoodö juppi jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hamachig mag juppi jaaubaawai chadcha warp'aa poso p'ʌʌr nʌnʌid, p'ʌʌr nʌnʌid, hohood hap'öbaadëjim hanʌm, hamach k'ĩk'ĩratdö pogk'a chi k'apanag cincuenta, maagwai pogk'a cien; hõor pöm mag t'ʌnarr t'umaa hich mag hohood t'ʌnʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Magbaawai Jesuu mag pan cinco narr dʌ̈i mag hãwarr dau numí narrpa p'ë hauwia, hʌ̃gt'aag heerpanaa, Hẽwandamag hʌ̈u hajim hanaa chi pan t'orreunaa, jũrr hich k'apeenag hʌapʌ̈imajim haajem, tagam k'ʌʌnag jigmamk'ĩir. Hich hagjö chi hãwarrjã hagdaujö t'umaam k'ʌʌnag jigpʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Magdamaupai maig hõor t'ʌnarr k'ʌʌn t'um biwaauwia himie p'öbaadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mag himie p'öbaadeewai chi pan hãwarr dʌ̈i sobtarrau t'ʌbʌt doce hipiirk'a haujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mag chi t'ach k'ötarr k'ʌʌn k'apanag hemk'ooin happai cinco mil naajim haajem, hʌʌinjã beerba chaainjã beerba. ");
INSERT INTO noaH_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mag t'ach k'ö haaipawia Jesuu hich k'apeenag, —Pãar mʌ na t'oom higar Betsaidaag dʌrbagk'abaadët hajim hanʌm, maimua jam p'öbör heeta mʌ nʌbaimat. Mʌʌn nau mʌg hõor hërëu t'ʌnʌm t'um hoopʌ̈iwiata majugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Maimua chadcha mag hõor wëtum k'ʌʌn t'um hoopʌ̈iwiata durrsĩ gaai petajim haajem, Hẽwandamag jëwaan. ");
INSERT INTO noaH_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mag hich k'apeen bote hee hich na pʌ̈itarr haawai, ya k'ëubaadeewai, döjãrr wëtmajim haajem. Maagwai Jesús hich happai t'ʌbawi hagt'a durrsĩ gaai Hẽwandamag jëeu sĩejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mammua Jesuu hoowai hi k'apeen hamach juadamau hök'ar hẽk'a wëtmajim hanʌm, k'ĩir garmua p'ũ t'eeg wë t'ʌnʌm hee. Mag hamach juadamau hẽk'a wëtum hoobaawai hãspajuag ham hẽk'a hauwimajim haajem, sĩi döjã hʌ̃rpai mamua. Pari mag ham hẽk'a hautarrjã sĩi k'ajap'a ham haig dichaagpamjöo sĩejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mamʌ mag sĩi döjã hʌ̃rta nʌrrʌm hoo hat'aawai hak'aarpii hawia jãp'ierr nʌm hiek'au hähäa k'ap'öbaadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ma chan mag hãbpaimuajã hooba, hamach t'umaam k'ʌʌnauta hoo narr haawai, hamach t'umta jãp'ierr naajim haajem. Pari mag sereubaadëm bʌ̈rre hich Jesús garmua hamag, —Keena, hoob jãp'ierrmiet; mʌ k'abahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Magnaa ham bote hee waaidʌbaadee chi p'ũjã warre t'umbamamua t'umbabaadëjim haajem. Mag hoobaawai hi k'apeen warre dauderraa nʌisijim hanʌm, ");
INSERT INTO noaH_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","hag noram Jesuu hamach dak'ĩir pan hãwarr dʌ̈i k'apanjã k'aba narraupai hõor pöm t'ʌnarr t'ach k'öpitarrjã k'ĩir hee paba. Jesuu hich juapá hoopi sim k'ap'ʌ haju haai nʌmta warag magʌmjã k'ĩirjuba sĩita jãp'ierr naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Maimua warag hãba hërëubaadëwi t'oom higar deeum durr Genesaret hanʌm p'ẽeubagk'abaimaawai warre hamach wëttarr bote jʌ̃ sĩujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mag jʌ̃ sĩuwia ya ham durr paauk'abaadeewai haig hõor narr k'ʌʌnau warre Jesús k'aug hat'ajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hamachdëu mag hi k'augp'öbaadeewai, hamach dak'am k'ʌʌnag hi barbaichëm k'ap hamk'ĩir, jũrr jaau nʌrrjëe hap'öbaadëjim hanʌm. Hamachdëu mag hũrp'öbaadeewai p'öbörpierr haaunaanpanau hamach haaunaan pa bʌʌrk'am gaaipa hi sim haig haibëemajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús nʌrrʌmpierr p'öbör hee didam k'apan k'aba nʌnʌidʌm hee maimua sĩi durr didam hãhãbdö nʌnʌidʌm heem magwe hi na kaaijã hee hamach haaunaan haubëenaa hirig, —Maar haaunaanag pʌch k'ajũahidam gaaipai k'ãijã pʌrpibá haajeejim hanʌm, monaaumk'ĩir. Mag chadcha t'um hi k'ajũa gaai pʌrmam k'ʌʌnan warre monaauk'a maajeejim haajem, mag sĩi pʌrbarmuapai. ");
INSERT INTO noaH_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","K'ãai hãb Jerusalén p'öbör heemua Jesús haig bëejierram haajem, Moiseeu Hẽwandam hiek p'ã pʌatarr wajapcha hʌʌrk'aajem k'ʌʌn dʌ̈i hich hag Hẽwandam hiekpai jawaag chi machnaanpa. ");
INSERT INTO noaH_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mag bëewia hamachdëu hoowai hi k'apeen juajã hʌbata t'ach k'ö nʌm hoobaawai hʌ̈u k'abata nʌm hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Hamau mag hiek'a narran, hamach chi judionaan t'um hamach jöoin hi pʌaba warrgarwe t'ach k'oopierr hajap'a jua hʌnaa k'oojemta warm k'ʌʌnau hich jãg juajã sũgba k'ö narr haawaita mag hiek'a naajim hanaabá. Maguata ham meeun chan jua hʌb k'aba chan t'ach k'öba haajeejim haajem, Hẽwandam dau na hamach hãrju hawia. ");
INSERT INTO noaH_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maguata merrkau hee hudt'urwia bëeujã, hamach jöoinau jaaujemjö, jua hʌba chan pöd t'ach k'öba haajem haajem. Mag tag hamau nem waaujem k'ĩir k'apan t'ʌnʌm hamach warrgarm k'ʌʌn jöoin hi pʌaba, maguata hamau t'um hamach dö doojem jarr, t'ëp, jiedöpjömjã t'um hʌk'apʌ̈iwi hĩchab hamach k'ãaijem putjã t'um jãk'apäaijem hanaabá.) ");
INSERT INTO noaH_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hamach hich mag sĩerrjëem k'apta chi fariseonaanau maestronaan dʌ̈imua hich Jesuug, —¿K'an jãgwia pʌ k'apeenau warrgurwe maach jöoinau jaaujem hipierraa k'aba, sĩi juajã hʌba hich jãgta t'ach k'ö nʌma? hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mag hichig jëeubaa jũrr hich Jesús garmua hamag magjim hanʌm: —Pãach jãg Hẽwandam hiek gayam pãachdëu nem jaaujemjö k'aba jũrr hag chaaur nem wau sĩerrjëem k'apta Hẽwandamau hich hi jaaumie jöoi Isaías k'ararrag pãach higwia hich hiek'atarr hiek mʌg p'ãpijimgui hajim hanʌm: “Pãran sĩi par hiek'aupaita mʌ hiek hʌ̈k'a nʌm hʌ̈k'a nʌm haajem. Pari mag nʌm chan par chadcha t'ãraucha hʌ̈k'abamta mag sĩerrjëem. Pãach mag nʌm gaaimua pãar t'ãar chan mʌ dak'ajã k'aba, sĩi mʌ warpta t'ʌnʌm. ");
INSERT INTO noaH_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jãg nʌm haiguin parii pãach hip'it'ur pãrau mʌrʌg jëeuju. Pãrau jaau nʌmjã sĩi wir haig pãach k'ĩirjugpaiu; jã mʌ hiek k'abam” hajim warrgarwe Hẽwandamau, pãar higwia. ");
INSERT INTO noaH_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Mag chirʌmʌn pãachdëujã Hẽwandamau nem jaau sim hipierraa k'aba, sĩi pãach jöoin hiigta hee ham k'õchgau warag hirua nem jaau sim hichaaur sĩi pãach juagam nem hʌk'ak'a haju happai k'ap sĩerrjëe haawaita mag chirʌmgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hamag mag hiek'apʌ̈iwi hichdëupai hĩchab magjim hanʌm: ’Sĩi pãach jöoin hiigta hʌ̃rcha hee ham k'õchgau pãrau Hẽwandam hiek chaar gaai jaau simta warag hasekasmap'a haajem. ");
INSERT INTO noaH_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jãgju k'apta warrgarwe jöoi Moisés k'ararrau, “Pʌch haai pʌch hãd dʌ̈i jãsenenaa hök'ö habá” hajim hanʌm. Maimua, “Har hiwiir hãbmua k'ãijã hich haai wa hich hãd k'ãijã t'õpnaa hãauk'a simʌn, maan warreta t'õopʌ̈iju haai nʌm” ha sim. ");
INSERT INTO noaH_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pari Hẽwandamau hich hiek gaai mag jaau simta jũrr pãar hiek mag hãbmua k'ãijã dich hayag wa dich hãdag k'ãijã, “Pãrau hig nʌm mua wai chirab mamʌ pöd mua deeju k'abam, ya t'um Hẽwandam hit'eem haawai” ha hiek'aju haai sim hanʌm, dich dënnaan dau haug k'augba. ");
INSERT INTO noaH_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Magnaa pãar hiek mag ya chi mag hiek'abarmua chan mag dich dënnaan hiwiir hãb k'ãijã dau hap'ʌʌ k'ërʌm hoowiajã hagʌg hoobamjö haju haai sim haajem hanʌm, bʌ̃ʌrjã hagʌg hooba. ");
INSERT INTO noaH_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jãg pãach jöoin hiigta hee nʌmua pãrau Hẽwandamau nem waupi jaau simta warag hisegpʌ̈i nʌm k'abahab hajim hanʌm hamag. Mag nʌmta hewagam k'ʌʌnagjã pãrau hich magta k'augpi wëtum; mamʌ magpaijã k'aba, mag tag pãrau nem k'aigba jaaujem nem k'ĩir k'apan t'ʌnaabahab hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesuu mag hiek'awia hich haig hõor t'ʌ̃rk'a haunaa hamag, —Pãadë t'umaam k'ʌʌnau mʌ hiek wajap'a hũrbat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mʌg jẽb gaai chadcha hõor pekaudam paraa k'it'ëem. Pari sĩi parhooba t'ach k'ö nʌmuapai chan Hẽwandam na hõor hãrba haajem. Hẽwandam na hõor hãrpiejemʌn pãach t'ãar hee nem k'aigbam k'ĩirjunaa hiek'aawaita pãachdëupai pãach hãrpiejemgui hajim hanʌm.  ");
INSERT INTO noaH_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Magnaa hamag, Jʌ̃g hʌ̃rʌʌnaa wajap'a hũrbat hajim hanʌm cha mua pãrag jaau chirʌm. ");
INSERT INTO noaH_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesuu hõrag mag hiek'awia hichta jũrr haigmua chaaug petajim haajem. Maimua ya deg paauk'abaimaawai chi k'apeenauta deeu hich hag hiekpai hirig jëeu naajim haajem, hamachig jaaumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mag hichig jëeubaawai jaaumamua, —¿Wa mag chan pãraujã hagt'a mag hiek k'augbata naab? hajim hanʌm hamag. Mua k'abá pãrag, “Sĩi t'ach k'ö nʌm gaaimuapai chan pekau paarpaba haajem” ha chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","T'achdam k'ö nʌmʌn sĩi buch heepaita sĩeimaajem, t'ãar heejã dubba. Mag buch heepai sĩewi chëbapäaiwai deeu chuk'u haadeejemgui ha jaaumajim haajem. Hirua mag sĩerr haiguin Hẽwandamau maachig nem k'ömk'ĩir deetarr chan ni hãbjã k'aigba k'aba sĩsidʌm ha sim hajim. ");
INSERT INTO noaH_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mag hiek'amamua pʌaba hich Jesuu hamag, —Hõor pekau paarpa nʌmʌn t'ãar heemua k'ĩirjug k'aigbam höbër nʌmuata pekau paarpa nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","¿K'an jãgwia mag sĩ? T'ãar heeta magʌm k'ĩirjugjã t'um hompaa hauwia mammuata dawag höbër t'ʌnaawaima hajim hanʌm. Mammuata höbër t'ʌnʌm: dich hʌʌi k'abam dʌ̈i k'apes haju k'ĩirjug, nem jĩgk'aju k'ĩirjug, maimua hõor t'õoju k'ĩirjug. ");
INSERT INTO noaH_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mag tag höbër nʌm: chik'am nemta dich dënk'a haum k'õsi haju k'ĩirjug, deeum hʌʌin wauju k'ĩirjug, parhooba nem k'aigbam nem wauju k'ĩirjug, chik'am k'ũgurju k'ĩirjug, chik'am hãauk'a hiek'a nʌm, wir haig dich t'ö nʌm, maimua sĩi donjö k'ĩirjug chuk'u nem wau nʌm. ");
INSERT INTO noaH_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Magʌm nem t'um t'ãar heemua dawag höbërdʌtk'a t'ʌnʌmuata Hẽwandam dau na hõor pekau paarpapiejem ha jaaumajim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesuu maig hõrag jaau sĩewia petajim haajem, Tiro durr Sidón dʌ̈i nʌmʌg. Mag mawia hõor haig jẽerimajim haajem. Mamʌ mag hich deg pabaimamjã hõrag k'augpimap'a sĩejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mag hich k'augpimap'a sim hãba, hʌʌik'aardam t'õt'õrrsöm bënëu baarjerr hãdau mag hi barbaimam hũr hat'aawai, Jesús haar mawia hi k'ĩirp'ee kanieu p'õbk'abaimajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mag hʌʌi deeum durr Sirofenicia hanʌm durram hajim hanaabá. Hich mag hʌʌirau Jesús haar mawia chaigpaimajim hanʌm, hich chaai mor heem t'õt'õrrsöm bën höbeerpʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Magbaa, judionaan k'abam k'ʌʌn chan hagt'a monaauju k'aba chirʌm hawi, Jesuu hich mag hʌʌirag hogt'ompai, —Hidëu nacha Hẽwandam chaainta t'achdam k'öpi hat'á. Mua pua jaau simjö pʌ chaaita nacha monaauk'iin, mua hoowai dich chaainag deeju harr panta k'echeunaa saakienag deebarmjö hajugui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Magbaa chi hʌʌyau pʌaba, —Señor, pua jaau simʌn chadau. Pari hiin saakienaujã chaain jua bigaau chi pichag mes heegar k'ʌimam k'oojemgui hajim hanʌm. Maagjeewai mʌ Israelpie hʌʌi k'aba hʌab mamʌ, ¿pua mʌ chaaijã dau haug k'augbaju k'ai? hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Magbaata Jesuu hirig, —Pʌch jãg hiek'a hʌm gaaimua pʌ chaai mor heem mepeer ya höbërbaadëm. Ya pʌ pʌch diig maju haai hʌmgui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mag Jesuu hichig “Pʌch diig maju haai hʌm” habaawai, chadcha mawia hooimaawai, hi chaai chadcha monak'a put hee werba jẽer sim hooimajim haajem, Jesuu jaautarrjö chi mepeer ya hi mor heemua höbërbaaderr haawai. ");
INSERT INTO noaH_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mag chaai monaaupʌ̈itarr k'ur Jesús majim haajem, Tiromua Galilea t'ʌrrdöog. Mag mamua Sidón p'öbör hee dichwia Decápolis durrjã hagjö dichjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mag Galilea pabaimaawai hõrau hi haig waibëejim hanaabá, woun hãb kach k'ĩsunaa meu k'ʌk'ʌaa k'itʌm. Mag chi waibëetarr k'ʌʌnau Jesuug chaigpaimajim hanʌm, hamach haaunaandam gaai pʌrbarmua monaaupʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Magbaawai Jesuu chi woun mag kachdam k'ĩsunaa meu k'ʌk'ʌaa k'itʌm hich hap chawag harrnaa, hi kach hee jĩgpiriu p'ĩ hoonaa, deeu hich jĩgpir gaaipai hichöoujã homnaa, jũrr hi meuk'ĩir gaai jãrpʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Maimua hʌ̃gt'aag heerpanaa, jãp'ö duraa hʌ̃inaa chi wounag, “¡Efata!” hajim hanʌm. Mag sim haiguin maach meúan “¡Kach haardʌbaad!” ha sim hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesuu mag hiek'abarm bʌ̈rre mag kach k'ĩsu sĩerrjã warre kach haardʌbaadëm dʌ̈i chi meuk'ĩirjã hagjö nem wajaug hagua hiek'a sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Magbaawai hõor haig narr k'ʌʌnag, —Mʌg mua jãg woun monaaubarm hoob chik'amnag jaaumiet hajim hanʌm hich Jesuu. Mamʌ mag hamachig jaaupiba harr hãba, warag hamachdëu jaaum haig jaaujeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mag hoowia hõor t'um dauderraa nʌm hiek'au hi higwia, “Jesuuwan nem t'um wajap'ata wau nʌrraajem. Maguata kach k'ĩsum k'ʌʌnjã kach haardʌpinaa meu meraam k'ʌʌnjã wajap'a hiek'apimaajem” ha hiek'a naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Biek hãb deeu hũmaai Jesús haig hõor pöoma biirdʌbaichëjim haajem. Mag nʌm hee bʌ̃ʌrjã t'ach k'öju chuk'u narr haawai Jesuu hich k'apeenta hich haig t'ʌ̃rk'a haunaa hamagta magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Hõor pöm mʌg t'ʌnʌm mʌ dau hee dau hap'ʌʌ durrum. Ya k'ãai t'ãrjup pam ham maach haigmua bʌ̃ʌrjã hogdʌba, t'achdam k'öjujã chuk'u durrumgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Hich jãg t'achdamjã k'öpiba hamach diig pʌ̈ik'iin, k'ʌd hee wëtumua jãdaúa p'ʌrëuju, pöd hamach di haarjã barba. Magʌm hãaur k'ʌʌn chará warpmua bëe nʌm haawai pöd barba k'ãijã hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mamʌ Jesuu hamachig magbaawai jũrr chi k'apeen garmuata hirig, —Mʌg maach hõor chukag hee nʌm, ¿jamaam t'ach maadëu hamag deebarju? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Magbaawaita Jesuu hamag —¿Pãrau pan dau k'arr wai nʌ? habaawai, hamachdëu, —Marau pandam sietepai wai nʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mag pan siete wai nʌm habaawai Jesuu mag hõor pöm wëjömʌg, —Jẽk'ʌt jupk'abat hajim hanʌm. Magnaa mag pan siete narrdam jua hee p'ë haunaa, hag paar Hẽwandamag hʌ̈u hajim hanaa t'orreuwia, jũrr hich k'apeenag hʌapʌ̈imajim haajem, mag hõor pöm t'ʌnʌmʌg jigmamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mag dʌ̈i hĩchab hãwarrdamjã daudam k'apan k'aba wai narr haawai mag paarjã Hẽwandamag hʌ̈u hajim hanaa jũrr deeu hamag hʌapʌ̈imajim haajem, hõrag jigmamk'ĩir. Magbaawai chadcha chi k'apeenau hichdëu jaautarrjö t'umaam k'ʌʌnag jigpʌ̈ijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mag jig p'ʌʌrdʌdʌgmamua hagdaujö hamachdëu k'öm haig k'öwi, k'ʌd biwaau p'öbaadee t'umjã k'öpʌ̈iba, t'ʌbʌt siete hipiirk'a haujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mag k'öjujã chuk'u narr hee hirua jãhogtarr k'ʌʌn chi k'apanag cuatro mil naajim haajem. Mag k'ö dichwi hamachig wëtpi jaaubaawai, hërëubaadee, ");
INSERT INTO noaH_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","hich Jesujã deeu bote hee waaidʌjim haajem. Magbaawai chi k'apeenau deeum durr Dalmanutaag hi joo harrjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mag mawia ya chi Jesús barbaimam k'augp'öbaadeewai hi haig bëejierram haajem, fariseonaan. Mag bëewia hogt'om daau chadcha hi Hẽwandamau pʌ̈itarrta jãg nʌrrʌm k'ai ha k'ap haag hawi hirig, —Magan maar dau na hag na hõrau nem hooba haajem nem waubá haichëjierram hanʌm hirig, marau hoog hit'ee. ");
INSERT INTO noaH_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Hichig magbaicheewai chadcha ham hipierr wauk'iinjã hich hiek hʌ̈k'abaju k'ap warag sĩi jãp'ö duraa hʌ̃inaa, —¿K'an hatchata mua pãar dak'ĩir nem wau chitajuuta pãrau mag mʌrʌg nem waupi jaau nʌma? hajim hanʌm hamag. Mua chan pãar dau na bʌ̃ʌrjã nem waubamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hamag mag hiek'apʌ̈iwi hichta warag ham haigmua petajim haajem. Maimua mag mawi hich k'apeen dʌ̈i bote hee waaidʌwi hag k'ĩirp'ee dʌrbajim haajem, hich hag t'ʌrrdö heepai. ");
INSERT INTO noaH_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mag wëtumjã k'ĩir hee pab jap hee k'oogjã k'öju harrba hawi pandam dau hãbpaita wai k'odjörrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mag hërëu p'öbaadëwia k'odjörröm hee, Jesuu hich k'apeenag, —K'ĩir k'ap'ʌ wënʌrrat hajim hanʌm. Hoob fariseonaan bën maimua Herodes bënjã jãg levadurajö sim pãach gaai dʌrbapimiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Hamachig mag hiek'abaawai hamach k'oog panjã chuk'u naawaita mag hiek'a simpii hawi jũrr wir haig hamach heepai mag pan haubëeba harrta hig naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pari Jesuu hamachig mag hiek'abarmjã bʌ̃ʌrjã k'augba naajim haajem. Mag hichdëu hiek'abarmjã k'augba warag sĩi hich hichaaur hiyʌ̈ʌ nʌm k'aug hat'aawaita hamag magjim hanʌm: —¿Pãach hödegan pãraun sĩi pan chuk'um gaaimuata mua pãachig magjimpii naab? hajim hanʌm. Mua maata pãrag jaauba chirʌm. Jãgan jãg nʌm haiguin pãrau chan mua nem waaujemjã hagt'a k'augbata naabma hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pãar dau paraanaa kachjã wai nʌm; pari mag nʌmta sĩi dau k'ĩsumjönaa kachjã k'ĩsumjöta nʌm. Pãrau mua nem wau chitʌm hoojemjã, ¿k'ĩir hee paba nʌ, ");
INSERT INTO noaH_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","har pandam cincopai narrau mua hõor cinco mil narr jãhogtarr? T'umaam k'ʌʌn k'ö dichwia himie p'öbaadeewai, ¿t'ʌbʌt k'arr hipiirk'a haujĩ, chi sob? Hamachig mag jëeubaa hi k'apeenau, —T'ʌbʌt k'apan docen hãb hipiirk'a haujimgui hajierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Magbaawai deeu hichdëu hamag, —Maimua hagjö har pandam sietepai narrau mua hõor cuatro mil narr jãhogtarr hedjã, ¿hamau k'ötarr sob t'ʌbʌt k'arr p'ë haujĩwi? hajim hanʌm. Magbaawai, —T'ʌbʌt siete hipiirk'a haujimgui hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Magbaawaita hichdëu, —Chadma hajim hanʌm. Mamʌ pan higju hawiajã, ¿pãrau chan deeu mua hompaa haujujã k'ĩirjubata naab? hajim hanʌm. Mua chan levadura chaar jaauba, fariseonaanau nem k'aigba jaaujemta jaau chirʌm; pari mag nʌmta pãrau pöd k'aug hauba nʌmgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mag wëtmamua Betsaida p'öbör hee barimajim haajem. Mag barbaimaawai hõrau woun hãb dau k'ĩsu k'itʌm hi haig waibëewi hirig chaigpachëjierram haajem, hi gaai pʌrbaawai hi dau monaaumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Magbaa Jesuu mag chi daudam k'ĩsu k'itʌm jua gaai pʌrnaa chawag p'öbör higaau harrjim hanʌm. Mag harrwi hi dau hichöou p'uurnaa hi gaai pʌrnaa hirig, —¿Pua hʌ̈u hoo chirʌ́wi? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Magbaa chi dau k'ĩsu k'itʌmua, —Hëera, mua hõor pabʌ̈jö sĩsidʌmta dʌrdʌr nʌrrjëem hoo chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Magbaawai deeu Jesuu hi dau hëudam haait'ʌ haait'ʌnaa hirig, —Deeu dau hẽe hoobá hajim hanʌm. Magbaawai chadcha deeu dau hẽe hoobarau warre warp dawaa hich mag hoo sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mag dau k'ĩsu sĩerr monaau sĩsiewai Jesuu hich diig pʌ̈yaagpamua hirig tag p'öbör hee bëepiba jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús mag woun hãb dau k'ĩsu sĩerr monaaupʌ̈itarr k'ur hich k'apeen dʌ̈i durr Cesarea de Filipo hanʌm heem p'öbördam nʌnʌidʌmʌg majim haajem. Mag wëtumua hich Jesuu hamag, —Hõrau mʌ higwia hiyʌ̈ʌ nʌm hũurwai, ¿ham hiek mʌ k'ai haajẽ? ¿Pãrau hũrba haajẽ? ha jëeujim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jesuu hamachig mag jëeubaa chi k'apeenau hirig jũrram k'ʌʌnau, —Ham hiek pʌ Juan chi hõor pör choomie haajem. Deeum k'ʌʌnau jaauwai, pʌʌta Elías haajem, warrgar Hẽwandam hi jaaujerr. Maagwai pogk'a jaauwai, pʌ sĩi warrgar hagjö Hẽwandam hi jaaujerr k'ʌʌn heem haajemgui hajierram haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Magbaa jũrr hamachigcha, —¿Ma pãachdëujãma? ¿Pãrau k'ĩirjuawai mʌ k'ai hagá? ha jëeujim hanʌm hamag. Magbaawai Pedroou, —Pʌʌn Cristoou hajim hanʌm, warrgarwe hich Hẽwandamaucha jʌr hauwia hõor peerdʌ haumk'ĩir pʌ̈iju jaaujerr. ");
INSERT INTO noaH_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mamʌ Pedroou hichig magbaawai, —Chadcha pua hag heyaa jaaubapʌ̈im, mamʌ hoob bʌ̃ʌrjã chik'amnag jawam hajim hanʌm. Warm k'ʌʌnagjã jaaupibajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Maimua Jesuu wir haig hichpai jaaumamua magjim hanʌm hich k'apeenag: —Mʌch chi Hemk'ooi Hiewaa chadcha dau hap'ʌʌ haju haai chirʌm. Mʌ dau hãauk'a hisegwia Jerusalenpie jöoin chi t'et'em k'ʌʌnau p'adnaan chi pörk'a nʌm k'ʌʌnaupa Moisés hiek jawaag chi machnaan dʌ̈imua mʌ t'õomk'ĩir pʌr deejugui hajim hanʌm. Mamʌ hamau mag mʌ t'õowiajã k'ãai t'ãrjupam hee p'iidʌwi deeu mʌ hiiu chirsijugui ha jaaujim haajem hich k'apeenag. ");
INSERT INTO noaH_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mag, hich dau haug wauju hich k'apeenag hũramk'ĩir hajap'a jaaumajim haajem. Mag hirua hiek'abarm hũrbaawai Pedroou Jesús chawag warrwia hirig, —¿K'ant'eeta pʌ mag hiek'a sĩma? Hõrau pʌ dʌ̈i magju k'aba nʌmgui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pedroou mag hiek'abaawai Jesuu tagam k'ʌʌn hich k'apeenag hewag p'ʌʌrba heerpanaa jũrr Pedroogta k'ĩir masi, —Jöpk'aa mʌ haigmua chawag petá hajim hanʌm. Pua chan Hẽwandamau nem waum hig simjã k'augba, sĩi parhoobam k'ʌʌnjöta k'ĩirju simgui hajim hanʌm. Meperauta pʌrʌg mag hiek'api sĩebahab hajim hanaabá hirig. ");
INSERT INTO noaH_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Magwia Jesuu hich haig hõor t'ʌnarr k'ʌʌn dʌ̈i hich k'apeenpa hãba t'ʌ̃rk'a haunaa magjim hanʌm: —Chadcha pãrau mʌ hiek pãach t'ãraucha hʌ̈k'a nʌm k'ai, hed hëepierr magan mua nem waupi jaau chirʌm happaita waubat hajim hanʌm, “Mʌchdëuta k'ap chirʌm mʌchdëu nem wauju” ha hiek'aba. Mʌ gaaimua chik'amnau dau hap'ʌʌ pãach t'õoju k'ĩirjuwia k'ãijã, magʌmjã higba, waragta hʌ̈k'anaat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Har chi mʌg jẽb gaai mʌ gaaimua bʌ̃ʌrjã p'it'urg haumap'a wënʌrrʌm k'ʌʌn chan meem hedjã hʌ̃gt'ar höbërbamgui hajim hanʌm. Magarrau har chi mua nem jaau chirʌm waum k'õchgauta hamach nemjã k'ĩirjuba sĩi warag mʌ gaaimua wa mʌg hõor peerdʌajem hiek gaaimua k'ãijã dau hap'ʌʌ hanʌm k'ʌʌnan chadau hʌ̃gt'archa höbërjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Magnaa hamag, Pãrau hoowai ¿k'an wajaug sĩ hajim hanʌm, woun hãbmua mʌg durr t'um hichdëupai jʌ̃a wai sĩsim, pari mag sim meebaadee k'ĩmie durr petam? ¿Hirua hich durr t'um hich dʌ̈i harrju haai sĩ? Pöd harrbam. ");
INSERT INTO noaH_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿K'anta mʌg jẽb gaai hatcha nem parhẽpagcha sĩerrʌ́ hajim hanʌm, hagua dich hak'aar hʌ̃gt'ar p'ag wai höbëraag? ");
INSERT INTO noaH_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Maimua hãbmua k'ãijã hĩs mʌg hõor pekau pöomanaa Hẽwandam hiekjã t'ãraucha hʌ̈k'aba t'ʌnʌm heeta mʌ gaaimua wa sĩi mʌ hiekdam jaaujupai k'ãijã hõor dak'ĩir chigaa hamʌn, mʌg mʌch chi Hemk'ooi Hiewaajã t'umaam k'ʌʌn Pörk'anaa mʌch Haai jua t'eeg dʌ̈i hʌ̃gt'ar hi chognaan t'ʌnʌm k'ʌʌnpa mʌg durr chachaan bëem hedjã hĩchab hich k'ĩircha heerpanaa chigaa warag, “Mua bʌ̃ʌrjã pʌ k'augba chitʌm” ha hiek'ajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mag hiek'amamua hĩchab, ’Mʌ cha hiek'a chirʌm hiek'au hãaur k'ʌʌn cha mʌ hiek hũr nʌm k'ʌʌn chan mʌchta nem jua t'eeg t'umaam k'ʌʌn Pörk'a bëeju hedamjö haadëm hoobam haigjã meebajugui ha jaaumajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mag hich k'apeen hãaur k'ʌʌnag hamach daúa hich hoopiju jaautarr k'ur seis días nʌm hee Jesús durrsĩ pöm sim gaai majim haajem. Mag hich mam dʌ̈i hõor t'ãrjuppai p'ë harrjim haajem. Mak'ʌʌn Pedro hajim haajem Santiago dʌ̈i, maimua Juan. Mag wëtwi ya durrsĩ gaai nʌmta hamau hoo nʌm dak'ĩraa Jesús k'ĩir chaaupabaadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Magbaadëmua sĩi hi mor gayam k'ajũa jũa sĩerrpa bʌ̃ʌnaa p'uumjö haadëjim hanʌm hich bäpgau. K'ajũa hatcha bäp'ä magjö chan hõrau bʌ̃ʌrjã jã hauba haajem haajem. ");
INSERT INTO noaH_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Magbaadëm hee hoowai warrgarm jöoin Moisés dʌ̈i Elíata hiyʌ̈ʌ dʌnʌnʌihdʌ naajim haajem Jesús dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hamachdëu mag hoobaawaita Pedro hiek hirua Jesuug mag chirajim hanʌm: —Maestro, nem hajaug chi hagamjö maar mʌig nʌm. Marau pãar hit'ee rãichdidam t'ãrjup hëu deeju: hãb pʌ hit'ee, hãb Elías hit'ee, maimua hãb Moisés hit'ee. ");
INSERT INTO noaH_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mamʌ Pedroou Jesuug mag di hëu deeju ha hiek'atarran, maan hamach chi k'apeenta jãp'ierr nʌm hiek'au pöd hiek'ajujã k'augba haawaita hirua mag hiek'ajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mag ham jãp'ierr nʌm hee, dëgölp sĩi hedjã heemua jʌʌnt'umie baug bëewi, ham jöodʌ hat'aicheewai, sĩi hag hee hierr paauk'abaadëjim hanʌm. Magbarm hee woun hiekjö, “Chamʌʌta mʌ Hiewaa mʌchdëu jãsehne wai chitʌmʌugui” hajim hanʌm, “hõor peerdʌ haumk'ĩir mʌchdëucha jʌr hautarr. Hirua nem jaau simta hipierraa habat” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Maimua deeu chi jʌʌnt'umie chuk'u haadëm hee, hamau hoowai hi dʌ̈i mag hõor numí narr hooba, Jesús hich happaita hoo dʌnʌm hoojierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mag durrsĩe naawia jerag wëdurumua Jesuu mag hich k'apeen t'ãrjup hich dʌ̈i harrtarr k'ʌʌnag hamachdëu hootarrjã deeum k'ʌʌnag jaaupiba, sĩi hamach t'ãar heepaita k'ap'ʌ hapijim haajem, hich chi Hemk'ooi Hiewaa meewia deeu hiiu p'iidʌ nʌm hora. ");
INSERT INTO noaH_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Magtarr haawai chadcha chi k'apeenau bʌ̃ʌrjã hõrag jaauba haajeejim haajem. Pari mag nʌmʌn wir haig hamach heepain hiyʌ̈ʌ nʌmua, —¿Ma k'ani maachig jaau sĩejimta mag hi meewia deeu hi hiiu p'iidʌju ha sĩejĩma? haajeejim hanaabá hamach happai. ");
INSERT INTO noaH_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mag hamach happai mamag nʌʌ hawi halp'in hichigcha, —¿K'an jãgwia Hẽwandam hiek jawaag chi machnaanau jaauwai mag Hẽwandamau Cristo pʌ̈iju na Eliata bëeju haajẽ? ha jëeujierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Magbaawaita Jesuu hamag, —Chadma, chi machnaanau jaaujemjö, Eliata nacha bëema hajim hanʌm. Pari mag hi bëeju jaautarran, mag Hẽwandamau pʌ̈iju haajerr hõrag nʌpi jaaumk'ĩirta bëeju jaaujim. Pari Elían ya hudt'urjim. Mamʌ mag hi hudt'uurwai, Hẽwandam hiek p'ã sim gaai jaau simjö, hõrau hi dʌ̈i hamachdëu hampierr hawi warag hi t'õopʌ̈ijierram. Magtarr haawai ¿pãrau k'ĩirjuawai hõrau mʌ dʌ̈ijã hi dʌ̈i hatarrjö habaju k'ai hajim haajem, hich jãg Hẽwandam hiek p'ã sĩsidʌm gaai mʌch chi Hemk'ooi Hiewaa higwia wauju ha jaau simjö? ");
INSERT INTO noaH_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mag hiyʌ̈ʌ wëdurumua tagam hich k'apeen nueve narr haig pachënaa hoowai, hõor pöm warp'am magwe p'ʌʌr t'ʌnʌm jãrrta Hẽwandam hi jawaag chi machnaan garmua ham dʌ̈i hijẽjẽbk'am hoochëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mag hõor pöm t'ʌnarr k'ʌʌnau hamach dak'ĩir Jesús barbaichëm hoop'öbaadee honegau hi k'ĩirp'ee pochag p'öbaadëwi hi dʌ̈i saludaa nʌmua, “Hʌ̈uchata jãg pʌ barbaichëm” hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mag chi machnaan garmua hich k'apeen dʌ̈i hijẽjẽbk'am hoobaicheewai, —¿Pãar k'an hiekta hig nʌma? hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Magbaa mag hõor pos t'ʌnʌm heemua hãbmua magjim hanʌm: —Maestro, mua mʌch hiewaa haibëejimgui hajim hanʌm, hi mor heem bënëu pöd hiek'apiba sĩi hichʌp wai sĩewai, pʌrʌg warre jẽu werbamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mʌg k'itʌm barbaadeewain sĩi jẽk'ʌt bäjä haimaajem. Magbaadëmua sĩi hisap'un bau haadëm dʌ̈i t'et k'ierrpa kũkũerr k'abaadëmua p'it'ierrii haadeejemgui hajim hanʌm. Mag bar nʌmua warag nem dau haauga pabaadëmgui hajim hanʌm. Mua pʌ k'apeenag jaaujim, hamag mʌch chaai mor heem bën warre jẽupʌ̈imk'ĩir. Pari ni hãbmuajã pödbajim ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Magbaawai Jesuu hich k'apeenagta magjim hanaabá: —Pãrau chan jãg chaai Hẽwandamau monaaupʌ̈ijujã k'ĩirjubata nʌm. Pãrau jãg Hẽwandam jua t'eeg simjã k'ĩirjubamjö nʌm, ¿hich jãgta sĩi mua hãwat chitaju haai chirʌ́ pãrau hoowai? hajim hanʌm. ¿K'an hatchata pãrau mʌ pãach dʌ̈i chitapim hig nʌma hajim hanʌm, hajapcha hʌ̈k'aag? Magnaa, Mag chaai mʌ haig haipidut hajim hanaabá hamag. ");
INSERT INTO noaH_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Magbaawai chadcha chi chaai hi haig haibëejierram haajem. Mag haipierrwai, chi chaai mor hee mag chi mepeer simua Jesús k'ĩir heerpa hat'aawai, sĩi heeupemjö hich bënëu barbaadëmua warre jẽk'ʌt bäjä haimajim hanʌm. Mag bäjä haimaa sĩi parhooba bʌ̈ t'ʌt'ʌg k'abaadëm dʌ̈i hipëgchöo hisap'un bau haadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Hich dak'ĩir magbaadeewaita Jesuu chi hayag, —¿Pʌ chaai jãg bënëu barbaaderr ya dʌ̈rrʌ̈ʌ sĩwi? hajim hanʌm. Magbaa chi hayau, —Jãan hich bʌ̃rʌʌ k'itʌwe hich jãg baarjemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","K'ar chará jãg barbaadëmua chi meperau hõtdau heejã barpʌ̈inaa dö heejã barpäaijemgui hajim hanʌm, hi t'õopäaig. Maagjeewaita mua pʌrʌg chaigpa chirʌmgui hajim hanʌm. Pua hʌ̈u hi monaaupʌ̈iju haai chirʌm k'ai, maar dau haug k'augwi mʌ chaai monaaubapʌ̈i hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Magbaawai Jesuu hirig, —¿Jãgwi mag pua mʌrʌg “hʌ̈u hi monaaupʌ̈iju haai chirʌm k'ai” ha sĩwi? hajim hanʌm. Har Hẽwandam gaaita hʌ̈k'a nʌm k'ʌʌn hit'ee chan bʌ̃ʌrjã p'it'urm nem chuk'um. Maagwai puajã chadcha t'ãraucha hʌ̈k'amʌn, pʌ chaaijã monaaubajup hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Magbaa chi hayau, —Muan chadcha hʌ̈k'a chirʌmgui hajim hanʌm. Mamʌ pua mʌch chaai monaauju k'ĩirjugta hʌ̃rcha mʌrʌg k'ĩirjupibá hajim hanʌm, warag Hẽwandamag hʌ̈k'aag. ");
INSERT INTO noaH_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mag nʌm hee Jesuu hoowai hich haig hõor pöm biirdʌdʌk'am hoobaawai chi chaai mor hee mepeer simʌgta meeurrau haadëwi, —Mepeer, pʌchdëuta mʌg chaai jãg kach k'ĩsunaa meu meraa wai simgui hajim hanʌm. Magnaa, Mʌ hiek'au jöpai chaai mor heemua höbërbaad, maimua tag hi mor hee dubaag k'abamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mag Jesuu hichig meeurrau haadeewai chi mepeer wiiu ha baubaadëjim hanaabá. Mag baubaadëmua chi chaai deeu hich bënëu barbaadëwi, jẽk'ʌt bäjä haimawia, warre chi meemjö bʌ̃ʌrjã mimig chuk'u hapʌ̈ijim hanʌm. Mag haig hõor pöm pos t'ʌnarr k'ʌʌnau hamach dak'ĩir mag chi t'õmjö haadëm hoobaawai, “Chadcha ya meebaadëbahab” hanaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mamʌ hamau mag meebaadëm hanʌm hee, Jesuu chi chaai jua gaai pʌrnaa hʌ̃gt'aag p'iriu hat'ajim hanʌm. Mag hich jua gaai pʌrnaa p'iriu hat'aawai dʌ̈i p'iidʌ warag bʌ̈jãau dʌnʌisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mag chaai mor heem mepeer jʌrpʌ̈iwi hërëubaadeeu, ya hamach hap deg paauk'abaimaawai, hiyʌ̈ʌ nʌmua Jesuug, —¿K'an jãgwi jãg chaai mor hee bën k'aigbam wai sĩerr marau pöd höbeerpi haubajĩ? ha jëeujierram hanʌm chi k'apeenau. ");
INSERT INTO noaH_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mag hichig jëeubaawaita, —Mua pãrag jaauk'imgui hajim hanʌm: Jãg mepeer k'ĩir hõor mor heemua jʌrpäaigan, jãan sĩi t'achjã k'öba hãba Hẽwandamagpai jëeu nʌʌ haawaita jʌrpäaijemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Maig naawia hërëu p'öbaadëwia Galilea durr dichjim haajem. Mamʌ Jesuu mag hõrau hich pʌr hauwi hich t'õoju hanʌmta hich k'apeenag jaau sĩerr haawai hamach nʌmjã hõrag k'augpimap'a sĩejim haajem. Mag jaaumamua hamag maagjeejim hanʌm: —Mʌch chi Hemk'ooi Hiewaan hõrau chi t'ierrnaanag pʌr deeju. Mag pʌr deebaawai hamau mʌ t'õopʌ̈iju. Mamʌ mag hamau mʌ t'õojup mamʌ, hag k'ur k'ãai t'ãrjup nʌm hee deeu hiiu p'iidʌjugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mamʌ hamachig mag jaaumamjã pöd hi hiek'a sim k'augba haajeejim hanaabá. Mag hamachdëu pöd k'augba haawai jëwaag hẽk'aajeejim hanʌm; mamʌ hinagau hawi hich mag jëeubajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mag hiyʌ̈ʌ wënʌrrʌmua p'öbör Capernaum hanʌm hee barimajim haajem. Mag barwia ya deg paauk'abaimaawai hichdëu hamag, —Maach k'ʌd hee daaig wëduraawai pãar ¿k'an hata hiyʌ̈ʌ wëduraa hajĩ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mamʌ hamachig mag jëeubaawai, chi k'apeenau ni hãbmuajã hi hiek hʌ̈k'aba, sĩi k'ĩuu nʌisijim hanʌm, k'ʌd hee wëdurumua chijãata hamach heepai t'umaam k'ʌʌn k'ãai hʌ̃rʌʌcha sĩ ha chik'am hipeer hahaug wëdurarr k'ap. ");
INSERT INTO noaH_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mag hich hiek hʌ̈k'aba habaawai ham na jẽk'ʌt jupwi dʌ̈i hamach t'um hich bigaau t'ʌ̃rk'a hauwia hamag magjim haajem: —Hãbmua k'ĩirjuawai hichta tagam k'ʌʌn k'ãaijã hʌ̃rpai ham k'õsi sim k'ai, magan hichta warag t'umaam k'ʌʌn k'ãaijã serbiibachanaa sĩi hich k'apeen chogk'aju haai simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Magnaa chaaidam t'ʌ̃r hauwia, ham dak'ĩir chi chaaidam jua hee jiir hauwi hamag magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Mʌg chaai hagt'a hich juau paba haawai serbiiba k'itʌmjö hõor t'ʌnʌm t'um mua k'õsi chitʌm. Pãrau mʌ dënjö mʌg k'it'ëem hãb k'ãijã jãsenk'awia pãach di haig haumʌn magan pãrau mʌchchata k'ĩir jãsenk'abarmjö habarm hajim hanʌm. Mag pãrau hʌdʌraa pãach haig mʌ baarpi nʌm haiguin magan pãrau mʌ Haaijã k'õsi nʌmgui hajim hanʌm, hichdëuta mʌ pʌ̈itarr haawai. ");
INSERT INTO noaH_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mag hũrwia Juanau, —Maestro hajim hanʌm. Marau woun hãb hoojim, mag wounau hiek'amamua pʌ t'ʌ̃r t'ʌ̃rnaa hõor mor heem mepeenag höbeerpi jaaubaawai chadcha höbeerpʌ̈i maajeejim. Mamʌ maarjö pʌ dʌ̈i nʌrraba haajemuata mag sĩewai marau hirig tag hõor mor heem mepeen jʌrk'ʌʌipiba jaaujimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Magbaa Jesuu hamag, —¿K'ant'ee pãrau hirig magjierrá hajim hanʌm, hidëu hõor jua pʌrpiba? Mag wounau mʌ t'ʌ̃r gaaita mag hõor monaau nʌrrʌm k'ai, magan hirua wajap'ata nem wau sim k'abahab hajim hanʌm, mʌ hëugar k'aigba jaauba. ");
INSERT INTO noaH_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maadëu nem wau nʌm hoo simjã maach hichaaurjã k'aba warag maach juapierr hoo sim wounan, magan maan maach dʌ̈i sĩewaiu hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maimua hich hagjö hãbmua k'ãijã pãar Cristo k'apeen haawai pãrag nemdam bʌ̃rʌʌm k'ãijã deebarm wounan, Hẽwandamau hagjö hirig nem wajap'am deeb k'aba deeju ha chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Pari magba hãbmua k'ãijã mʌ chaai mʌg mʌ hiek hʌ̈k'a k'ërʌmta pekau hee burrpimʌn, Hẽwandam dʌ̈ita hiekk'õr pöoma sĩsiju. Mamʌ mag Hẽwandam dʌ̈ita hiekk'õr paarpaju k'ãai, hichdëupai hich hö gaai mokpör pömk'am jʌ̃naa p'ũas hee baudʌk'iin hʌ̈ucha hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Maimua hagjö pʌch juaupaita pʌ pekau waupi sim k'ai, hag garm jua warag warre t'ʌapbapʌ̈i. Hidëu pʌ jua bisi Hẽwandam haar barwiajã hʌ̈u simgui hajim hanʌm, pʌch jua numwe monak'a k'ĩmie durr hõtdau huu t'õojã k'augba wëjöm hee maju harr k'ãai.  ");
INSERT INTO noaH_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mam chan mag hõtdau huu t'ʌnʌmjã bʌ̃ʌrjã t'õba ni hag heem hödömiejã k'ëchaa k'augba sĩerrʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wa pʌ bʌ̈ʌu k'ãijã hagjö pʌ pekau hee burrpi sim k'ai, magan mag bʌ̈jã warag t'ʌapbapʌ̈i. Bʌ̈ numwe monak'a k'ĩmie durr maju harr k'ãai, Hẽwandam haar bʌ̈ bisi höbërwiajã hʌ̈ucha simgui hajim hanʌm.  ");
INSERT INTO noaH_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mam chan mag hõtdau huu t'ʌnʌmjã t'õba ni hag heem hödömiejã k'ëchba hich mag sĩerrʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wa pʌ daúa k'ãijã pʌ pekau waupi sim k'ai, magan mag dau warag jẽubapʌ̈i. Pʌch dau numwe monak'a k'ĩmie durr Hẽwandamag pʌch barpʌ̈ipiju k'ãai, dau bese k'ãijã pʌʌta Hẽwandam dënk'a simʌn hʌ̈ucha simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mam k'ĩmie durr chan hödömiejã k'ëchaa k'augba hich mag domk'a t'ʌnʌm dʌ̈i mag hõtdau huu t'ʌnʌmjã t'õba hich mag sĩerrʌmgui hajim hanʌm. Maguata muan pãragan, pekau waumaaugau dau chuk'umjö hoobamjönaa magʌm nem k'aigbam wawaagjã jua chuk'umjö habat ha chirʌmgui hajim hanʌm, bʌ̃ʌrjã wauba. ");
INSERT INTO noaH_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Mua pãrag mag chirʌmʌn, chik'amnau pãach t'um pãar wajap dau haug waupiju haawaita mag chirʌmgui hajim hanʌm. Mamʌ Hẽwandamau hʌdʌraa mag pãar dau haug waupi nʌmʌn, sĩi pãach hich dʌ̈i chadcha hubʌ wënʌrrʌm k'ai ha k'ap haagta magpi sim. Pãar dʌ̈i mag sim haig, nemek mod hãrm hugua p'ö sĩiujemjö, mag p'it'ur wënʌrrʌm gaaimua warag pãarjã hagjö hich dʌ̈i hajap'a wënʌrramk'ĩirta pãar dʌ̈i mag simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","T'ak'aran chadcha nem wajap'amʌu. Mamʌ mag sim nak'a haadëk'iin, ¿k'aíu magʌm t'ak'aar higju k'ai? hajim hanʌm. Jãg t'ak'arauta nem t'um sĩp'a hapiejemjö habat, pãach k'apeen dʌ̈i nem wajap'a wau nʌmua hagdaujö t'umaa k'õinaa wënʌrraag ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús mag Capernaum p'öbör heemua deeum durr Judeaag mawia jũrr döjã Jordán higaau hedau höbeerjemʌg petajim haajem. Mag hamach hee pabaimam k'aug hauwi hich haig hõor pöoma pos haicheewai hichdëu hag na hõrag jaaujerrjö mag hõor pöm t'ʌnʌmʌg Hẽwandam hiek jaaubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mag nʌm hee fariseonaan hi haig bëejierram haajem. Mak'ʌʌnau juau hogt'om Jesús himeraa pʌr hawaag hawi hirig jëeumamua, —¿Chadchata pua hoowai maach hemk'ooinau dich hʌʌi pʌaju haai nʌ wa pʌaju k'aba nʌ? ha jëeujierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Hichig mag jëeubaawai jũrr hich Jesús garmua hamag, —Moiseeu Hẽwandam hiek p'ã pʌarr gaai, ¿k'an ha jaau sĩwi? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Magbaa hamachdëu, —Moiseeu jaauwain maadëu dich hʌʌi pʌaju haai nʌm ha jaau pʌajim haajem. Sĩita hʌʌi pʌagpaawai wajap'a hẽsap p'ãnaa hag gaai, “Ya mua pʌ pʌa chirʌm” ha jaauju haai nʌmgui hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Magbaawaita Jesuu hamag, —Pãadë k'ĩu hũrbat hajim hanʌm. ¿Pãrau k'ap'ʌ nʌ, k'an gaaimua Moiseeu mag p'ã pʌajĩ? Hirua mag p'ã pʌatarran, pãach jʌ̃g t'eeg sĩsidʌm gaaimuata mag p'ã pʌajimgui hajim hanʌm, chadcha. ");
INSERT INTO noaH_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pari warrgarwe hich Hẽwandamau maach hompaawaijã hemk'ooi hʌʌi dʌ̈ita hompaajimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Magtarr haawaita hemk'ooi hich hʌʌi dʌ̈i pabaadëmʌn hich dënnaan k'a hogdʌajemgui hajim hanʌm, ya hich hʌʌi dʌ̈ita hãba nʌrraag. ");
INSERT INTO noaH_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ya magbarm haigmuan warran hagdaujö hamach happai naajerrta hõor hãbpaimjö hich mag nʌisiejem. Ya mag nʌisim chan ya tag hamach hãhãbdö nʌrrjëe haba, hõor hãbpaimjö nʌisiejem. ");
INSERT INTO noaH_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mag warrgarwejã hich Hẽwandamauta mag papitarr haawai pöd hiwiir hãbmuajã hi hichaaur hawi dich hõor pʌaju k'aba nʌmgui hajim hanʌm Jesuu hamag. ");
INSERT INTO noaH_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Maimua magtarr k'ur deg paauk'awijã chi k'apeen garmuata deeu hich hag hiekpai hirig jëeu naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mag hichig jëeubaawaita Jesuu hamag, —Hich hʌʌi pʌawia deeum hʌʌita hau simʌn magan pekauta wau simgui hajim hanʌm, hich hʌʌi chaar k'abam dʌ̈ita mag sĩewai. ");
INSERT INTO noaH_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wa magba chi hʌʌirau k'ãijã hich jaai pʌawia deeum hemk'ooita haumʌn magan hagjö pekauta wau simgui hajim hanʌm, hich jaai chaar k'abam dʌ̈ita sĩewai. ");
INSERT INTO noaH_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mag nʌm hee hõrau Jesús haig hamach chaain waibëe t'ʌnʌisijim haajem, ham gaai pʌrnaa ham kõit Hẽwandamag jëeumk'ĩir. Pari mag jũrram k'ʌʌnau chaain waibëbëek'am hoowi jũrr chi Jesús k'apeenauta chi haibëe nʌm k'ʌʌnag meeurrau sĩujierram haajem, tag haibëepimaaugau. ");
INSERT INTO noaH_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mamʌ hamau mag hõrag meeuk'a hiek'a nʌm hoobaawaita Jesuu jũrr hamachigta hagjö meeurraunaa, —Hidëu hõrag hamach chaaindam mʌ haig waibëepibat hajim hanʌm. ¿K'ant'ee pãrau hamag bëepiba jaau nʌ? Chi jöoin hawiajã chamʌ k'ʌʌn chaainjö mʌ hiek hʌ̈k'ak'arrsö hʌ̈k'a nʌm k'ʌʌnta mʌg jẽb gaaijã hʌ̈u wënʌrrawia hʌ̃gt'arjã honee wënʌrrabajup hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mamʌ chi hʌ̃gt'ar höbërju k'ĩirju nʌm k'ʌʌnaujã mʌk'ʌʌn chaain dënjö hʌ̈k'abam chan pöd höbërbamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mag hiek'apʌ̈inaa, Jesuu ham dak'ĩir warag chi chaain hich jua hee jiirk'a haunaa, ham pör hʌ̃r jua hausĩunaa, ham kõit wajap'a Hẽwandamag jëeumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Maigmua Jesús chawag maagpam hee, woun hãb hi haig k'ap'ig bëejim haajem. Mag bëewia hi k'ĩirp'ee kanieu p'õbk'achëwia hirig magchëjim hanʌm: —Maestro, pʌʌta chadcha maestro hajap'am haawai pʌrʌg jëwaan bëejim: ¿Mua k'ani jãgju haai chirʌ́ hʌ̃gt'ar höbëraag? Mʌrʌg jaaubá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Magbaawai Jesuu hirig, —¿K'ant'ee pua mʌrʌg chi hajap'am ha sĩ? Hõor hajap'am chan chuk'um. Hajap'amʌn hãba Hẽwandamta hich happai hajap'a sĩerrʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Pua k'ap'ʌ sĩebá hajim hanʌm, Hẽwandamau hich hiek Moiseeg p'ãpitarr gaai: “Hoob dich hõor k'abam dʌ̈i k'apes ham; hoob hõor t'õom; hoob nem jĩgk'am; hoob chik'am hëugarjã sëuk'a nem hĩgk'am; hoob sëuk'a chik'amnaanjã k'ũgurm; maimua pʌch dënnaanjã jãsene habá” ha sim? ");
INSERT INTO noaH_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Magbaawai chi woun mag hirig jëeuchëtarrau —Maestro, mʌch bʌ̃rʌʌwe mag pua jaaubarm t'um mua hʌʌrk'a chitabahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mag wounau mag hiek'abaawai Jesuu hi dau hee haug k'aug paraa heerpanaa hirig, —Mamʌ hagt'a pua nem k'ĩir hãb wauju waaur wai sĩebahab hajim hanʌm. Pʌch diig mawia, nem t'um pʌchdëu wai sim përk'ʌʌipʌ̈inaa, mag p'atk'on jũrr dau hap'ʌʌ k'it'ëem k'ʌʌnag t'um jigbapʌ̈i hajim hanaabá. Maimuan chadau mʌ hẽudee pidú hajim hanʌm, chadcha mʌ dʌ̈i chitam k'õsi chirʌm k'ai. Pua magmʌn hʌ̃gt'ar pawiajã bʌ̃ʌrjã haugchëba p'atk'on k'ãai nem hajap'am pömta wai chirsijugui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesuu hichig mag hiek'abaawai warre hök'ĩirjuu hich diig petajim hanaabá, chadcha p'atk'on paraam harr haawai. ");
INSERT INTO noaH_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hichdëu mag nem jaaubarm hipierraa hamaaugau warag hök'ĩirjuu petam hoowi, hich bigaau narr k'ʌʌn k'ĩir heerpa p'ʌʌrdʌnaa, hich dʌ̈i hogdʌba wënʌrrarr k'ʌʌnagta, —Keena, pãadë hoobat hajim hanʌm. P'atk'on paraam k'ʌʌnta Hẽwandam chi Pörk'a sim haar höbëraagan, chadcha t'et'e simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesuu mag hiek'abarm hũrwia warre jʌ̃gderraa hap'öbaadëjim hanaabá. Pari magwi deeu hich Jesuupai hamag, —¡Aay, chaaina! Har p'atk'on hit'ee wʌrpa haajem k'ʌʌnta Hẽwandam chi Pörk'a sim haar höbëraagan, chadcha p'it'ur sĩerrʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","P'atk'onpanta hʌ̃gt'ar Hẽwandam chi Pörk'a sim haar höbërju k'ãyau, camello pöm jãg maach wounaan k'ãaijã hʌ̃rpai sĩerrʌmta p'it'urg chuk'u nobeeu kach hee t'oogar höbër dichjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jesuu mag jaaubaawai chará warag jʌ̃gderraacha nʌm hiek'au jũrr hamach heepai wir haig hamach k'apeenag, —Mag k'ai, magan ¿k'aita peerdʌagáwa? hanaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Magbaa Jesuu hamag heerpanaa, —Hõragan chadcha p'it'urgma hajim hanʌm, mag hũurwai. Mamʌ Hẽwandamag chan bʌ̃ʌrjã p'it'urg chuk'u simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Magbaawai Pedroou hirig, —Maraun chad maach nem wai narrjã hewag k'ĩirjuba, t'um p'ëpʌawi pʌ dʌ̈i hogdʌba wënʌrrabma hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Magbaa jũrr hich Jesuu magjim hanʌm: —Pedro, mua chadcha mag chirʌm: Har mʌ gaaimua wa mʌ hiek jaaum k'õchgau k'ãijã hamach di, hamach heeugpeen, hamach hʌ̃p'ʌʌin, hamach dënnaan, hamach hʌʌi, hamach chaain, wa hamach nemjĩir k'ãijã k'ũchpaim hit'ee werpʌpʌak'am k'ʌʌnagan, ");
INSERT INTO noaH_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mʌg jẽb gaai hagt'a nʌwejã hamach heeugpeen, hamach hʌ̃p'ʌʌin, hamach hãd, hamach chaain, hamach nemjĩirpa t'um mʌ gaaimua hok'oomarr k'ãyaujã hʌ̃r warag hag hatcha deejugui hajim hanʌm. Hajap hõrau ham dau haug wauwiajã mag wënʌrrʌmʌn chadau, mʌg hatagjã durr hiiur gaai mʌch dʌ̈ita hich mag wënʌrramk'ĩir mʌch haarchata p'ë haujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pari mag hed hãaur k'ʌʌn har mʌig heegar haawai hamachta chik'am k'ãaijã hʌ̃rʌʌcha nʌm haajerr k'ʌʌnta hʌ̃gt'ar Hẽwandam haar paauk'aimaawaijã jũrr serbiibacha haajerrjöo nʌisijugui hajim hanʌm. Maimua jũrr har mʌ gaaimua chik'amnau serbiibag p'eejerr k'ʌʌnta jũrr warm k'ʌʌn k'ãaijã hʌ̃rʌʌcha nʌisijugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Maigmua p'öbör Jerusalenag k'ʌdau ma sim hee majim haajem, hich k'apeen dʌ̈i deeum k'ʌʌnpa. Mag wëtumua hich Jesuuta pör garcha ham na maa hajim hanʌm. Mamʌ mag chi hẽudee wëtmarr k'ʌʌnan t'ãar paraata wënʌrrajim haajem, hich Jesuucha hag nawe hõrau hich t'õoju jaautarr ya k'ap'ʌ narr haawai. Mamʌ mag ham t'ãar paraa wënʌrrʌm Jesuu k'ap'ʌ sĩerr haawai, hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌn doce k'ĩet t'ʌ̃rk'a hauwia Jerusalén p'öbör heem k'ʌʌnau hich dʌ̈i k'aigba haju jaaumamua magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Pãrau k'ap'ʌ nʌm, maach Jerusalenag wëtum; nau maach mam barbaimaawai mʌch chi Hemk'ooi Hiewaa mʌg chirʌmʌn t'et'emnaanag mʌ pʌr deejugui hajim hanʌm. Magbaawai mak'ʌʌnau jũrr maach meeun k'abam k'ʌʌnag mʌ t'õopi jaauwi durr chaauram k'ʌʌn jua hee mʌ t'ʌsĩepʌ̈ijugui hajim haajem, mak'ʌʌnaujã mʌ dʌ̈i hamachdëu hampierr hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Magbaawai mak'ʌʌnau mʌ wau hiek'anaa, mʌ jʌ̃gadaujã wʌnaa, mʌ gaaijã hichö t'unaa, hamachdëu ham haig mʌ dʌ̈i hawia, hãbmiecha paawai hamau mʌ t'õopʌ̈ijugui hajim hanʌm. Pari mag hamau mʌ t'õowiajã k'ãai t'ãrjup nʌm hee deeu mʌ hiiu p'iidʌjugui ha jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mag wëtum hee jöoi Zebedeo chaainau, hajapcharan Santiagoouma Juan dʌ̈imua hirig, —Maestro, marau pʌrʌg nemdam jëeum hig naajimgui hajim hanʌm. ¿Pua maar k'ĩir jãsenk'awi maachdëu jëeubarmjö habaju k'ai? hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Magbaa Jesuu hamag, —¿Pãrau jãgata mua pãach dʌ̈i hapim k'õsi nʌma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Magbaawai hamachdëu hirig, —Marau pʌrʌg jaaum hig nʌmʌn mʌg hatag pʌchta t'umaam k'ʌʌn Pörk'a bëewi mʌg durr t'um jʌ̃abaadeewaijã maar numiim k'ʌʌnagta pʌch bigaau juppibá hajierram hanʌm, pʌch dʌ̈i hiek t'eeg hamk'ĩir: hãb pʌch juachaar gar, maimua hãb pʌch juawë gar. ");
INSERT INTO noaH_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Magbaawaita hich Jesús garmua hamag, —Pãrau chan sĩi pãachdëu nem jëeu nʌmjã k'augbata nʌmgui hajim hanʌm. ¿Pãrau k'ĩirjuawai mag pãachta warm k'ʌʌn k'ãaijã hʌ̃rpai haag chik'amnau pãach dau haug wau nʌmjã mʌ dënjö hãwatwi mʌ t'õm hedjã mʌ dʌ̈i t'õju haai nʌ? hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Magbaawai chi Santiagoou Juan dʌ̈imua, —Hëera, marau hãwatbajup hajierram hanʌm. Mamʌ magbaawaita Jesuu hamag, —Pãrau chadcha hõrau pãach dau hap'ʌʌ wau nʌmjã hãwatwi mʌ t'õbarmjö t'õma hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pari magbarm gaaimuapai chan mag mʌch juachaar gar wa juawë gar k'ãijã mʌch dʌ̈i hãba juppiju chan mua pöd jaauju k'aba chirʌmgui hajim hanʌm, Hẽwandamauta hichdëu k'ap jaauju haawai. ");
INSERT INTO noaH_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mamʌ mag Santiagoou Juan dʌ̈imua hamach dak'ĩir Jesuug magbaawai chi k'apeen diez narr k'ʌʌnau jũrr ham dʌ̈ita meeuk'a naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mamʌ magbaawai Jesuu hamach t'um hãbam haig t'ʌ̃rk'a hauwia hamag magjim hanʌm: —Pãrau meraajã k'aba nʌm, chadcha sĩi mʌg jẽb gaai hõor pörk'awi hamachdëuta gobernaajem k'ʌʌnaun hamachta chi pörnaan haawai hiek t'eeg nʌm hawia hamach k'ãai jua heegpaim k'ʌʌn dʌ̈i hamachdëu hampierr haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pari jũrr pãrau pöd ham dënjö magju k'aba nʌm, pãach heepai. Magju k'ãai hãbmua k'ãijã pãach heepai hichta t'umaam k'ʌʌn k'ãai hʌ̃rʌʌ ham k'õsi sim k'ai, magan jũrr hich garmuata hich k'apeenau nem mag habaawaijã ham hipierr nʌnʌʌu haju haai simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Maagwai har hichta hʌ̃gt'ar pawiajã Hẽwandamau hich garcha juppi hahau hapim k'õsi sim k'ai, magan sĩi hichta parhoobam k'ʌʌn chogk'aju haai simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mʌ pãar k'ãai Hemk'ooi Hiewaak'a chirʌmjã mag sĩi mʌch garmua chik'am chogaagjã bëebajim. Mʌ bëetarran, sĩi chik'amnag mʌch chogamk'ĩirta bëejimgui hajim hanʌm, mag chitʌmua chik'am jua machgau t'õwi mag t'õbarm gaaimua hõor pöm sĩi hamach pekau hee preso sĩsidʌmjö nʌm k'ʌʌn höbeerk'apäain. ");
INSERT INTO noaH_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mag wëtumua Jericó p'öbör hee barimajierram haajem. Maig k'ũchpai naawia deeu ham hërëubaadëm dʌ̈i hõor pöm wëtjim haajem. Maimua ya ham p'öbör heemua höbërwi wëtumta k'ʌd bigaau woun hãb dau k'ĩsu k'itʌm Bartimeo hanʌmta hõor hërëu dich nʌm k'ʌʌnag nemdam jëeuwai hoo k'ërʌm hooimajierram haajem. Mag woundam jöoi Timeo hanʌm hiewaa hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mag dau k'ĩsu k'itʌmua hich dak'a Jesús Nazaretpierr dichmam k'aug hat'aawai hähäak'amua, —Jesús, pʌʌta rey David k'achitarr hag chaain hewagam k'ʌʌn Hiewaau marau nʌ narr. Mʌ hap chitʌm mʌ dau hee haug k'augbahur haajeejim hanʌm, hich dau monawaan bëemk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mag chi dau k'ĩsu k'itʌmua hähäa k'abaadeewai Jesús dʌ̈i hõor wëtmarr k'ʌʌnau hirig meeurrarrau haajeejim hanʌm, k'ĩupamk'ĩir. Mamʌ magbaawai chará warag t'et hähäak'amua, —Jesús, pʌʌta rey David k'ak'itarr hag chaain hewagam k'ʌʌn Hiewaau marau nʌ narr. Mʌ hap chitʌm mʌ dau haug k'augbahur haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesuu mag hähäak'am hũr hat'aawai dʌnʌisiwia chi dau k'ĩsu k'itarr hawaan mapijim haajem. Magbaawai chadcha hi hawaan wëtwi chi wëttarr k'ʌʌnau hirig, —¡K'ĩirdam hubʌ p'iidʌbaad! Jesuu pʌ t'ʌ̃r sĩebahab. Hi haar marrau hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hichig magbaawai hich hag bʌ̈rre hich k'ajũa hʌ̃r joot'ʌ jũa sĩerr barwerbpʌ̈iwi p'iidʌ dʌnʌisinaa Jesús haar petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mag chadcha hich haar dʌnʌʌubaimaawai Jesuu hirig, —¿K'ani pua mʌrʌg pʌch dʌ̈i hapim k'õsi chirʌ́? ha jëeujim hanʌm. Magbaa chi daudam k'ĩsu k'itʌm garmua jũrr hirig, —Maestro, muan pʌrʌg mʌch dauta monaaupʌ̈ipim k'õsi chirʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Magbaawai Jesuu hirig magjim hanʌm: —Chadcha muata pʌch dau monaauju k'ap'ʌ k'ĩirju chirarr gaaimua hʌ̈u pʌ monaau chirsim. Ya pʌ pʌch diig maju haai chirʌmgui hajim hanʌm. Hirua mag hiek'abarm bʌ̈rre chadcha dau heerdʌ sĩsiwi hich bi heem daujö daujã wajaug sĩsijim hanaabá. Mag hich dau monaaubapäaiwai warag hi dʌ̈i petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús hich k'apeen dʌ̈i mamua durrsĩ Olivo hanʌm gaai naaimajim haajem, p'öbör numí hãba dak'a nʌm k'ĩirp'ee. Mag p'öbör numí hãba dak'a narr t'ʌ̃r, hãb Betfagé hajim, maagwai hãbak'ai Betania. Maig durrsĩ gaai nʌmua hich k'apeen numí t'ʌ̃rk'a hauwi pʌ̈yaagpamua magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Cha maach k'ĩirp'ee p'öbördam sim hee hërëubaadët hajim hanʌm. Nau chi p'öbör hee dub nʌm haig pãrau burrodam pa gaai jʌ̃ k'ërʌm hooimaju. Mag burrodam gaai chan hagt'a ni hãbmuajã waaidʌba k'itʌm. Ma pãrau hẽerwia haipidut hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Hãbmua k'ãijã bëewi pãachig, “¿K'ant'ee jãg nemchaai pãrau hẽer harraag hẽk'a nʌ?” ha jëeubaawai, sĩi hit'ũu hirig, mʌ higwia, mua hig chiraawaita harrum, mamʌ deeu hũmaai jöpcha deen bëeju ha jaaubat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Maimua chadcha hërëu p'öbaadëwia, hamachig jaautarrjö burrodam k'ʌd bigaau puertdi dub nʌm dak'a hö jʌ̃ k'ërʌm hoobaimaawai, sĩi hẽer hauwimajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Magbaawai haig hõor narr k'ʌʌnau hamag, —¿Pãar k'anta jãig jãg nʌma, jamag pãrau chik'am nemchaai hẽer harrú? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Magbaawai Jesuu hamachig jaaupʌ̈itarrjö jaaubaawai hʌdʌraa warag hamag harrpijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mag chadcha warrwi Jesús sim haar pabaimaawai chi k'apeenau hamach k'ajũa hʌ̃r joot'ʌ jũajemua chi burro p'õpá hʌ̃r t'eer sĩujierram haajem. Magbaawai Jesús hag hʌ̃r waaidʌbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Magbaawai hõor k'apan hi dʌ̈i wëdurarr k'ʌʌnau hamach k'ajũa hʌ̃r joot'ʌ jũa narr hẽerk'anaa, hi maju k'ʌd hee t'eerk'amam dʌ̈i jũrr hãaur k'ʌʌnaujã k'ʌd bigaau papiujöm bʌbrëunaa, hagjö hi maju hee wërp'ogk'a majierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mag hi mam dʌ̈i hõor pöm hi na pos wëtmaawai hi hẽudeejã hagjö k'apaana pʌʌrt'ʌmajim hanʌm. Mag hõor pöm sĩi wëtum k'ʌʌnau serereugmamua mag naajim hanʌm: “Hʌ̈ucha habarm Hẽwandam, hich mʌʌta pʌchdëu pʌch jũrr pʌ̈ibarmʌu. Hijöm k'ʌʌn chan chuk'um. ");
INSERT INTO noaH_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pua maar Reik'amk'ĩir pʌ̈iju ha jaaujerr chadcha pierrumgui” haajeejim hanʌm. “¡Hʌ̈ucha habarm Hẽwandam! Warr jöoi David reik'a sĩerrjö hichta jũrr Reik'aju k'ap'ʌ nʌm gaaimua, pʌrʌg hʌ̈u habarm hanʌm. Hʌ̃gt'arm magwe honee haju haai nʌmgui” haajeejim hanʌm, Jesús t'ö hiek'a nʌmua. ");
INSERT INTO noaH_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mag wëtumua Jerusalén p'öbör hee barimajierram haajem. Mag barimawia, Haai hi jëeujem diig mawia, hag hee dubwia, dijã t'umaa heerpa p'ʌʌrdʌpʌ̈iwia, deeu höbërbaadëjim haajem. Mag höbërbaadëwia ya hedau k'eeuraa haadëm hee Betaniaag petajim haajem, hich k'apeen doceem dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hag noram mag p'öbör Betania hanʌm heemua Jerusalenag wëtumua Jesús jãsöo haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mag hi jãsöo nʌrrʌmta warpmua pabʌ̈ higo hanʌm hëpõo k'ʌd bigaau dʌnʌm hoo hat'ajim hanʌm. Magbaa haar dak'a hoon majim haajem, hag gaai chi nemjõ ya chi wawam nʌmpii hawia. Pari hag chee jaar k'aba harr haawai ni pör hãbjã hag gaai hoobajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mag hichdëu hag gaai pör hãbjã hooba habaawai chi pabʌ̈ʌgta wounagamjö, —Pʌch jãg sim gaaimua mʌg hatagjã hich jãg chëba sĩerrajugui hajim hanʌm. Hirua mag hiek'atarrjã hi k'apeenau hũrjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Maimua deeu Jerusalén p'öbör hee barchëwia, Haai hi jëeujem di haar manaa hooimaawaijãh, sĩi Haai hi jëeujem degta nem peerwai hõor pöm pos sereu wëjöm hooimajim hanaabá. Magbaa Jesuu mag nem për narr k'ʌʌn t'um dawag jʌrk'ʌʌinaa hag hee hõrag p'atk'on cambie narr k'ʌʌn mes dʌ̈i dubur për narr k'ʌʌn mespa jẽk'ʌt sĩepʌ̈imajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Magnaa tag hiwiir hãbamʌgjã Haai hi jëeujem deg nem hinag dʌ̈i dichpibajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Maimua hamag, —Pãrau k'ap'ʌ naabá hajim hanʌm, Hẽwandamau hich hiek p'ã pʌarr gaai, “Mʌg diin sĩi durrpierram k'ʌʌnau bëewi hag hee Haai hi jëeujem diiu” ha sim. Mag simta pãachdëuta hag hee nem parhẽpag për nʌmua sĩi chik'am k'ũguurjem dik'a wai naabma ha hiek'ajim haajem, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesuu mag hiek'abarm p'adnaan pörnaanau Moiseeu Hẽwandam hiek p'ã pʌarr jawaag chi machnaan dʌ̈imua hũrbaawai, hamach happai biirdʌwi, hiek'awi, “Jãga hak'iin maadëu jãg Jesús t'õopʌ̈ik'amgui” hanaajim haajem. Mamʌ hirua nem jaau sim hũrwi t'umaam k'ʌʌnau hi higar narr haawai hũmaai deeu hãsie k'ĩirjuajeejim hanaabá, mag hi higar nʌm k'ʌʌnau jũrr hamach dʌ̈ita meeuk'aju k'ĩirjuwia. ");
INSERT INTO noaH_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mamʌ hamau mag k'ĩirju nʌm hee, ya hedau k'ëubaadee Jesús hich k'apeen dʌ̈i mag p'öbör heemua warag hamachta chawag wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Maimua hag noram deeu Jesuu hich k'apeen dʌ̈i hich hag k'ʌd hee wëtumua hoowai mag hirua hiek'atarr higo sĩi chi k'aar haram magwe p'uhu t'ʌnaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mag p'uu t'ʌnʌm hoobaawai Pedroou, —Maestro, pʌdë hoobá, pua tag chëpiba jaautarr higo bʌ̈jã sĩi p'ua t'ʌnʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Magbaawai t'umaam k'ʌʌnagta Jesuu magjim haajem: —Pãach nem wawaag hiek'aawai chadcha Hẽwandamau pãachdëu jaaubarmjö hapiju k'ĩirjunaata hiek'abat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mua chadcha pãrag mag chirʌm: Hãbmua k'ãijã durrsĩigta wounagamjö hiek'abaawai chadcha hichdëu jaaubarmjö hich hipierraa haju k'ĩirjunaata “Jãigmua mawia jũrr p'ũas heeta dʌnʌʌubaimá” hak'iin, chadcha Hẽwandamau hichdëu mag hiek'abarmjö hapijugui hajim hanʌm, hichdëu mag hiek'abarmjö Hẽwandamau chadcha magpiju k'ĩirjunaata hiek'a sĩewai. ");
INSERT INTO noaH_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Maimua hĩchab, ’Pãachdëu Hẽwandamag nem hig nʌm jëeuwai chadcha hirua pãachig deeju k'ap'ʌnaa ya pãach jua hee wai nʌmjöta jëeumʌn, magan chadcha hirua pãrag pãachdëu nem hig nʌm deeb k'aba deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Maimua pãachdëu Hẽwandamag jëwaagpaawai pãach garmua wa pãach k'apeenau k'ãijã pãach dʌ̈i k'aigba nʌm k'ai, hagdaujö perdón jëeuwia, tag magʌm hiek higba warag k'ĩir hok'oopʌ̈iwia, magba harrjö ham dʌ̈i dau parii habat hajim hanʌm. Pãrau magmʌn hĩchab maach Haai hʌ̃gt'ar chirʌmʌgjã pãrau pãach pekau chugpaapi jëeubaawai hirua chugpaapʌ̈iwia tag pãach dʌ̈i magʌm hiek bʌ̃ʌrjã higbajugui hajim hanʌm.  ");
INSERT INTO noaH_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pari pãrauta pãach k'apeen wir haig perdonaabam chan, maach Haai hʌ̃gt'ar chirʌmuajã hich hagjö pãar pekau chugpaabamgui ha jaaumajim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Maimua deeu Jesús Jerusalén p'öbör hee barchëwia Haai hi jëeujem deg dubjim haajem. Mag dubwi hagt'a hierr simta, hi haig p'adnaan chi pörk'a nʌm k'ʌʌn bëejierram haajem, Hẽwandam hiek Moiseeu p'ã pʌarr jawaag hit'ee chi machnaan dʌ̈i judionaan Asamblea heem k'ʌʌnpa. ");
INSERT INTO noaH_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mak'ʌʌnau bëewia hirig, —¿K'ai t'öwiata jãg mʌig nem për narr k'ʌʌn pua dawag jʌr wërppʌ̈ijĩ? ¿K'aíuta jãg pʌrʌg pʌchta nem hiek t'eeg hapijĩ? Marag jaaubá haichëjierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hichig mag jëeubaicheewaita jũrr hich Jesús garmua hamag, —Magan muajã hĩchab pãrag jëeu hook'imgui hajim hanʌm. Mua jëeubarm pãrau mʌrʌg jaaumʌn, magan muajã hich hagjö pãrag jaauju, k'ai t'öwiata mua jãg nem wau chitʌ́. ");
INSERT INTO noaH_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Maimua hichdëupai, Nacha mʌrʌg jaaubat hajim hanʌm: ¿K'aíuta Juan pʌ̈ijĩ hõor pör choo nʌrramk'ĩir; Hẽwandamauta pʌ̈ijĩ wa sĩi mʌg jẽb gayam k'ʌʌnau hajĩ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Hamachig mag jëeubaawai sĩi warag jaaujujã k'augba, hamach wir haigpai hiyʌ̈ʌ nʌmua, —Maadëu hirig, “Juan hõor pör choomien Hẽwandamauta pʌ̈ijim” hak'iin, jũrr hirua maachig, “Magʌmta, ¿k'an jãgwia pãrau hirua jaau nʌrrarr hʌ̈k'abajierrá?” hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wa magba maadëu hirig, “Juanan sĩi hõrau pʌ̈iwiata jãg nʌrrajim” hak'iinjã, jũrr p'öbörpienta maach dʌ̈i meeuk'ajugui hajim hanaabá, hamau chadcha Juan hõor pör choomieu Hẽwandam hiekta jaau nʌrraajerr k'ap'ʌ narr haawai. ");
INSERT INTO noaH_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mag hamach happai jaauju k'augba hiyʌ̈ʌ naawia warag Jesuug, —Marau pöd jaauju k'augbamgui hajierram hanʌm. Magbaawai jũrr hich Jesús garmua hamag, —Mua pãrag nem jëeutarr pãrau mʌrʌg jaauba haawai muajã pãrag jaaubamgui hajim hanʌm, k'ai t'öwiata mua mʌg nem wau chitʌ́. ");
INSERT INTO noaH_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Maimua Jesuu hich haig hõor pos t'ʌnʌm k'ʌʌnag mʌg nem hĩgk'aadam jaaumamua magjim hanʌm: —Woun hãbmua uvadö jĩirjim haajem. Mag jĩirwia hag higaau hajap'a t'uur p'ʌʌrdʌpʌ̈iwi hich hagjö haig di hëu k'ërjim haajem, hag heegar chi uva chö piirjʌwaag. Magnaa hĩchab didamjã nasãdjö hʌ̃gt'aa hëu dʌnʌʌujim haajem, hag gaaimua warp dawaa hoo p'ʌʌrdʌdʌ haag. Mag nem t'um haaipa sĩuwi, chawag mam k'õchk'abaadeewai, chi nemjĩirdö deeum k'ʌʌnag alquilaapʌ̈iwi, hichin jũrr deeum durr warp petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mag mam mawi sĩi hawia, ya uva waaubaadëm k'ĩirjunaa, jöoirau hich chog hãb pʌ̈ijim haajem, chi t'ʌa narr k'ʌʌn haar, hich paatëm hich hit'ee deepʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pari mag hirua hich chogdam pʌ̈itarr di garm k'ʌʌnau sĩi hamach haar barpinaa pʌrp'öbaadëwi, wʌ wai nʌʌ hawia, sĩi deeu hich jua k'arraa jʌrbapäaiwai, hich juadam parii barjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Magbaawai hich mag jöoi chi uva papau dewam hich chog pʌ̈ijim haajem. Mamʌ majã hagjö hamach haar barpinaa, warm dʌ̈i hatarr k'ãaijã hatcha wʌ wai nʌmua pörjã k'õoppʌ̈iwi, sĩi hi k'ĩir parhooba hiek'a t'ʌnʌʌuwia, hĩchab jʌrpʌ̈ijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Magbaawai jöoirau deeum pʌ̈ijim haajem. Ma paawai chará hamach haar barpinaa warre t'õopʌ̈ijierram hanaabá. Magtarr k'urjã hich mag hich chognaan k'apan päaijeejim haajem, mamʌ mak'ʌʌnjã warm k'ʌʌn hatarrjö hĩchab k'ar sĩi mas wauwi päaijeejim hanʌm; magbajuun warre t'õopäaijeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Maimua ya hãbmiecha tag pʌ̈ijujã chuk'u haadeewai hich hiewaa hãbpai k'itaawai bʌ̃ʌrjã chig haba haajerrta pʌ̈ijim haajem. Hi k'ĩirjugan hich chaai haawai hi högk'aju hawiata pʌ̈ijiebma. ");
INSERT INTO noaH_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mamʌ par hich jöoi hiewaa hãba sĩi hamach haar barpinaa hamach wir haigpai, “Keena, chamʌʌta chi hiewaa haawai mʌguata mʌg hatagjã jũrr hich haai nemjĩir jʌ̃aju k'abahab” hajierram hanʌm. “Jãg sĩpí warre maadëu hi t'õopʌ̈ijugui” hajierram hanʌm, mʌg uvadö jũrr maach dënk'a hawaag. ");
INSERT INTO noaH_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mag, chadcha k'apanaam k'ʌʌnau pʌrp'öbaadëwi, t'õopʌ̈inaa, chi uvadö higaau hëudʌ deet'urjierramgui ha jaaumajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Maimua mag nem hĩgk'aadam höpʌ̈iwia hich hiek hũr narr k'ʌʌnag magjim haajem: ’Pãrau k'ĩirjuawai hĩsjã hagt'a mag uvadö sim hanaa chi t'ʌa narr k'ʌʌnjã hich hak'ʌʌnpai hak'iin, ¿jãgaju k'ai hajim hanʌm, magʌm wounaan dʌ̈i? Par hirua hich chaai hãbpai k'itʌm pʌ̈itarrpata mag t'õobapʌ̈im hoobaawai, mawia warre hamach t'um k'ëchpʌ̈iwia, hich uvadö jũrr deeum k'ʌʌnagta jaau pʌabjëjugui hajim hanʌm hichdëupai. ");
INSERT INTO noaH_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Magnaa hamag, ’¿Pãrau Hẽwandam hiek p'ã sim gaai t'ʌ̃ʌrwai hooba haajẽ hajim hanʌm, “Di hëu narr k'ʌʌnau hisegtarr dibigta jũrr chi dihãd jãrramk'a sĩsim” ha sim? ");
INSERT INTO noaH_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","“Hẽwandam maach Pöröuta mag dibig wajap'amjö hapi sĩewai hõrau hoowaijã hʌ̈uuta hoo nʌm” ha p'ã simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesuu mag nem hĩgk'aadam jaau simua hamachta jaau sim k'aug hat'aawai chi fariseonaanau maestronaan dʌ̈imua Asamblea heem k'ʌʌnaupa hãba hich maigwe hi pʌr haum hig naajim hanaabá; mamʌ mag hi pʌr hat'aawai jũrr hõrau hamachta k'aigbaju k'ĩirjuwia warag hi dichba hamachta hërëujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Magbaawai chi pörnaanau Jesús haar fariseonaan pʌ̈ijierram haajem rey Herodes higar narr k'ʌʌn dʌ̈i, mak'ʌʌnau hi dʌ̈i hiyʌ̈ʌmamua nem jëeumam k'ãijã k'augba hipeerdʌ hiek'abapäaiwai magʌm gaaimua hi pʌr hawaag hit'ee. ");
INSERT INTO noaH_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Magbaawai mak'ʌʌnau hërëuwia hi haar barimawia hirig maguimajierram hanʌm: —Maestro, marau k'ap'ʌ nʌm, pua nem hagchata jaaujem. Pua mag sĩi pʌchdëu hoowai magjöo habaawai mag hawi parhoobjã nem jaauba, hante pua chadchata t'umaam k'ʌʌnag jaaujemgui hajim hanʌm, jãgata haju haai nʌ Hẽwandamau nem jaau sim heyaa wënʌrraag. Pua chan sĩi hõrau hamachdëu nem jaaum haig nem jaau nʌmʌgjã pʌch k'ũgurpiba, wa sĩi pʌchdëu hoowai magjöo habaawai hag bʌ̈rre sĩi magau haba haajem. Magua marau pʌrʌg jëeum hig nʌmgui hajierram hanʌm: ¿Chadchata maach meeun judionaanaujã durrpierram k'ʌʌn rey Roma sĩejemʌgta impuesto p'agju haai nʌ wa p'agju k'aba nʌ? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mamʌ mag hamau sĩi hich himeraa pʌr hawaagta mag hichig jëeubaichëm k'ap'ʌ sĩerr haawai hamag magjim hanʌm: —¿Pãrau k'ant'eeta sĩi mʌ himeraa pʌr hauju hẽk'a nʌma? Daaig p'atk'on chi dau daí mʌ haig haipidut; mua pãrag hoopik'imgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Magbaawai chadcha hirig p'atk'on chi dau daídam deejierram hanaabá. Mag deebaawai jũrr hich Jesús garmua hamag, —Pãrau chamʌg p'atk'on gaai, ¿k'ai k'ĩirta hoo nʌ, maimua hĩchab hag gaai k'ai t'ʌ̃rta p'ã sĩ? hajim hanʌm. Magbaawai hamachdëu, —Romaam rey César k'ĩir k'abahab hich t'ʌ̃r dʌ̈i hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Magbaawai Jesuu hamag, —Pãrau mag k'ap'ʌ nʌm k'ai, magan reíg hich paat deenaa, Hẽwandamagjã hagjö hich paat deebat hajim hanʌm. Hamachig magbaawai sĩi jʌ̃gderraa nʌisim hiek'au warag hamachta k'ĩu nʌisijim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Biek hãb hagjö Jesús haig bëejierram haajem saduceonaan. Mak'ʌʌnau jaauwai ya maachta meebaadëm chan tag bʌ̃ʌrjã maach hak'aar hiiuba haajem haajem. Hamach mag nem jaau sĩerrjëem gaaimua hiyʌ̈ʌmamua juau hogt'om hirig magjierram hanaabá: ");
INSERT INTO noaH_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, jöoi Moisés k'ararrau Hẽwandam hiek p'ã pʌarr gaai jaauwai, woun hãb hʌʌi paraa simta mag hʌʌi dʌ̈i chaaijã chuk'u meemʌn jũrr chi k'od hãbam wai sim k'ai, magua hich hag hʌʌipai hauju haai sim ha sim, hag dʌ̈i hich naamʌu chaain hooba harr haawai jũrr hi hit'ee hoo deeg, mag hoo deebarm hi chaaink'a nʌisimk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maimua hamachdëupai warag hirig nem hĩgk'amamua magjierram hanʌm: ’Biek hãb hãbam k'od happai hemk'ooin siete naajim haajem. Ham naam chi nacharamua hʌʌi hauwia hich mag chaai chuk'u wënʌrrʌm hee meejim haajem, chi hemk'ooi. ");
INSERT INTO noaH_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Magbaawai jũrr chi heeumʌu wir haig hich k'ojaaupai hauwi mag dʌ̈ijã hagjö chaai hooba, chi hemk'ooita meejim haajem. Magbaa jũrr hich mag hʌʌipai hag heeumʌu hauwia mag dʌ̈ijã chaai hooba, hagjö hich naamk'ʌʌnjö meejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hich mag hewagjã hãbam hʌʌiraupai mag siete narr t'um t'egdʌpʌ̈itarrjã ni hãbam dʌ̈ijã chaai hoobajim hanaabá. Maimua ya hẽudeecha paawai chi hʌʌijã hagjö meejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Magua marau pʌrʌg k'ap haag hit'ee jëeum hig nʌmgui hajierram haajem: K'ëchtarr k'ʌʌn mʌg hatag Hẽwandamau deeu p'iriutk'a hat'am hedjã mag hamach t'umaam k'ʌʌnau hãbam hʌʌipai hautarr haawai, ¿chijãata chi jaai k'ʌ chaark'ajuma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Magbaawaita Jesuu hamag magjim hanaabá: —Pãrau chan bʌ̃ʌrjã Hẽwandam hiek p'ã simjã k'augba, ni hi jua t'eegjã k'augba nʌm gaaimuata sĩi warag k'ĩirjug chaaurta k'ĩirju nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hötarr k'ʌʌn deeu hiiu p'iidʌtk'a p'öbaadëm chan bʌ̃ʌrjã jua pʌpʌr habaju, ya ham hʌ̃gt'arm Hẽwandam chognaan t'ʌnʌm k'ʌʌnjö nʌisiju haawai. ");
INSERT INTO noaH_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mag hõor hötarr k'ʌʌnjã deeu hiiuju k'ap haag ¿pãrau Moiseeu Hẽwandam hiek p'ã pʌarr gaai t'ʌ̃rba haajẽ? Hag gaai Hẽwandamau Moiseeg, “Mʌʌta pãar jöoin Abrán k'ararr Hẽwandam hanaa hĩchab jöoi Isá k'ararr hag Hẽwandamau, maimua Jacob k'ararr dënjã hagjö” ha sim. ");
INSERT INTO noaH_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Hẽwandam chan hoob mag sĩi chi k'ëcham k'ʌʌn Hẽwandam k'abam. Hẽwandaman chi hiwam k'ʌʌn Hẽwandamau” ha p'ã sim. Hirigan nawe k'ëchtarr k'ʌʌn hawiajã hagt'a hiiu nʌmgui hajim hanʌm. Magnaa, Pãachta chadcha sĩi chaaurta k'ĩirju nʌmgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moiseeg Hẽwandamau hich hiek p'ãpitarr hiek jawaag chi machnaan heem hãbmua mag ham hijẽjẽbk'am hũr sĩi hawi, Jesuu hich dak'ĩir wajap'a hag heyaa jaaubapäaiwai, jũrr hi haig bëewi hirig, —¿Chijãata Hẽwandam hiek p'ã pʌarr gaai maachig nem waupi jaau sim heem chi hʌ̃rʌʌcharam hagá? ¿K'anta hʌ̃rʌʌcha Hẽwandamau maachig waupim k'õsi sĩ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Magbaa Jesuu mag wounag, —Hẽwandamau hich hiek gaai nem waupi jaau sim chi hʌ̃rʌʌcharamʌn mʌgta p'ã simgui hajim hanʌm: “Hũrbat'ʌ̃ keena, israelnaan: Maach Pör Hẽwandaman hichta hãbpai t'umaam k'ʌʌn Pörk'a sĩerrʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Maach Pör Hẽwandam sĩi par hiiupai k'aba, pʌch t'ãrauchata k'õsinaa pʌchdëu wauju hayaampierr hichdëu k'õsimjö habá” ha sim. Maata Hẽwandamau nem jaau sim chi hʌ̃rʌʌcharamʌugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Maimua hãbak'ai hag garm hich hagjöpaimʌʌ sĩebahab hajim hanʌm. Ma sĩi, “Pʌch k'apeenjã wir haig pʌchjö daupii habá” ha simgui hajim hanʌm. Hẽwandamau nem waupi jaau sim gaai chamʌ k'ʌʌn numiim k'ãai hʌ̃rpaim chan chuk'umgui hajim hanaabá hirig. ");
INSERT INTO noaH_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Magbaawai mag chi machdamau jũrr hirig, —Maestro, hʌ̈u pua hag heyaa jaaubapʌ̈im, jãan chadaugui hajim hanʌm. Maach Hẽwandaman hich happaita sĩerrʌm; hijöm chan tag chuk'um. ");
INSERT INTO noaH_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hẽwandamta dich t'ãraucha k'õsinaa dich k'apeenjã daupii nʌmta Haai hi jëeujem deg mawia nemchaain k'apan t'õonaa p'aa nʌmua hʌ̃gt'aag jëeu nʌm k'ãaijã hajapcha simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesuu hoowai mag wounau chadcha hagcha hich hiek hʌ̈k'abaawai hirig, —Pʌʌn pöm waaurba chirʌmgui hajim hanʌm, Hẽwandamta pʌch Pörk'apieg. Bigaaum k'ʌʌnau mag hoobaawai hãbmuajã tag hirig jëeubajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Haai hi jëeujem deg Hẽwandam hiek jaau sĩewia jũrr hich garmua haig narr k'ʌʌnag magjim hanʌm: —¿K'an jãgwia Moiseeu Hẽwandam hiek p'ã pʌatarr jawaag chi machnaan hiek mag Cristo rey David k'ararr hag chaain hewagam k'ʌʌn dën haajẽ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Hich Daviiuchajã Hẽwandam Hak'arau hichig hiek'apibaawai hich hag Mesías higwiapai “maach Pör” habajieb. Hante hirua p'ã pʌarr gaai mag simgui hajim hanʌm: “Maach Pör Hẽwandamau maach Pörög ‘Mʌch hiek t'eeg chirʌmjö haag mʌ dʌ̈i hãba mʌ juachaar gar jupbá hajim, pʌch hoomap'a haajem k'ʌʌn t'um mua pʌch jua hee pʌrk'a dee nʌm hora.’ ” ");
INSERT INTO noaH_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mag hich David k'ararrauchajã Hẽwandamau pʌ̈iju haajerr higwia “maach Pör” ha hiek'atarrta, ¿jãga pãar hiek hí David chaain hewagam k'ʌʌn dënpai haju haajẽ? Mag sĩi hich chaaipai haju hak'iin, hich paarmua mag “maach Pör” habak'amgui hajim hanʌm hamag. Mag hi hijẽjẽbk'am hõor pöm haig t'ʌnarr k'ʌʌnau hi hiek hũrm k'õsi hũr naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesuu Hẽwandam hiek jaaumamua magjim haajem: —Moiseeu Hẽwandam hiek p'ã pʌatarr jawaag chi machnaan dʌ̈i k'ai, k'ĩir k'ap'ʌ habat hajim hanʌm. Jãk'ʌʌnan sĩi k'ajũa bʌ̈ duurg jũanaa kaaijã hee hõrau hamach saludaawaijã hamach t'ö hiek'apim k'õsita sĩerrjëem hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jãk'ʌʌnan hamach Hẽwandam hi jaaujem deg weetwaijã hamachta pör garcha t'umaam k'ʌʌnag k'ĩir jʌrk'a juupjem, hamachta warm k'ʌʌn k'ãaijã wajapcha nʌm hawia. Maimua hõor chaauram k'ʌʌnau hamach haar t'ach k'ömk'ĩir t'ʌ̃ʌrwaijã, parhooba jupba, hamachdëuta k'ãidu wajapcharam jʌ̃a hau sĩerrjëemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","K'oopaa hʌʌin dau hap'ʌʌm dijã k'echt'ʌg haumaajerram. Mamʌ mag sĩerrjëemta chadcha hamach magba chit'ëem hamk'ĩir, Hẽwandamag jëeup'öbaadëmjã pʌa chʌuu hap'öbaadeejemgui hajim hanʌm. Pari hamach jãg sĩerrjëem paran Hẽwandamaujã ham gaai jua k'ʌaba deejugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Biek hãb Jesús Hẽwandamag jëeujem deg ham p'atk'on p'iejem k'ĩirp'ee hoo sĩejim haajem. Mag hoo simua jũrr bëe t'ʌnʌm k'ʌʌnau hag hee p'atk'on pʌapʌ̈i hërëu dich t'ʌnʌmta heerpa hoo sĩejim hanaabá. Hirua hoowai riknaanaun p'atk'on pöm dee naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mamʌ riknaanau mag p'atk'on dʌ̈rrcha dee pʌa nʌm hee, k'oopaa hʌʌi hãb hap'ʌʌ k'itʌm bëejim haajem. Mag bëewi p'atk'on chi dau daídam numpai wai sĩerr warre mag numwe hag hee dee pʌapʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mag k'oopaa hʌʌyau p'atk'on bʌ̃rʌʌ wai k'ërarrdam t'um deebarm hoowia Jesuu hich k'apeen hich haig t'ʌ̃rk'a hauwia, —Keena, mua pãrag jaauk'imgui hajim hanʌm. Jãg k'oopaa hʌʌi dau hap'ʌʌ k'itʌmua p'atk'on bʌ̃rʌʌ deejieb mamʌ, Hẽwandam dak'ĩiran tagam k'ʌʌn k'ãaijã hʌ̃rʌʌchata deebarmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Warm k'ʌʌnaun sĩi hamach dën sobtarr heemta Hẽwandamag dee naabahab. Mamʌ jãg k'oopaa hʌʌi hap'ʌʌ k'itʌmua chan magba, hich dën hãbmiecha hagua hich t'ach k'öju harrdamta warre t'um deebarmgui ha jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mag Haai hi jëeujem deg sĩewia höbërbaadeewai hi hogdʌba wënʌrraajerr k'ʌʌn heem hãbmua chi Jesuug, —Maestro, pʌdë hoobá hajim hanʌm, mokpör dapk'amua sĩi di hooimʌ joot'ʌt'ʌʌd hëu dʌnʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Magbaawai Jesuu hirig, —Har jãg di dap dʌnʌnʌidʌm pua hoo chirabá; jãg t'ʌnʌm chan mok pör hãbjã hãbam hʌ̃r hich jãg hajap'a joot'ʌt'ʌʌd sĩerrabam. Jãg t'ʌnʌmʌn sĩi t'umaa hõrau pogueupʌ̈ijuuta jãg dʌnʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Maigmua hërëubaadeeu mag Haai hi jëeujem di k'ĩirp'ee durrsĩ Olivo hanʌm gaai sĩeimajim haajem, hich k'apeen dʌ̈i. Maimua barwi ya hi jẽk'ʌt jupbaimaawai Pedroou, Santiago, Juan maimua Andrés dʌ̈imua hamach jayapam k'ʌʌnau hirig jëeumamua magjierram hanʌm: ");
INSERT INTO noaH_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Pʌ hiek mag jãg mokdau joot'ʌt'ʌʌd t'ʌnʌm t'um hõrau pogueupʌ̈iju hanʌm, ¿ma jãagwaichata magjuma? hajim hanʌm. ¿K'an jãg nʌm gaaimua cha pʌchdëu jaau simjö Hẽwandamau hijaaurjö hoopijuma hajierram hanʌm, mag Haai hi jëeujem di pogueupʌ̈imʌʌ pam? ");
INSERT INTO noaH_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Magbaawai Jesuu hamag, —Magan mua pãrag jaauk'imgui hajim hanʌm. Maimua jaaubaadëwia, Keena, k'ĩir k'ap'ʌ wënʌrrat'ʌ̃; hoob chik'amnag pãach hʌdʌraa k'ũgurpimiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mua pãrag mag chirʌmʌn, mʌg hatag paawai hõor k'apank'am k'ʌʌnau hamach hiekpai mʌ hiek gaai t'ʌwia, “Mʌʌta hag Cristoou Hẽwandamau pʌ̈iju haajerr” hawia, hõor pöm k'ũgurmaju haawaita mag chirʌmgui hajim hanʌm. Pari mak'ʌʌnau pãachig magwia k'ãijã hoob pãrau ham hiek hʌ̈k'amiet hajim hanaabá, ham wawimamua. ");
INSERT INTO noaH_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Juurhi p'iidʌju t'eega jajaauk'amjã pãrau hũrjugui hajim hanʌm. Mamʌ pãachdëu mag hũurwai hoob jãp'ierrmiet. Hichiita jerrba chadcha hich mag haju. Magjup mamʌ ma chan hagt'a Hẽwandamau pãar hi hagk'a nʌm k'abamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Magbaadëm dʌ̈i hĩchab durr mʌg wëjöm hee hamach heepai jũrr durr chaauram k'ʌʌn dʌ̈i wërbʌjurau, hamachta jũrr chik'amnaan k'ãyau hʌ̃rpai ham k'õchgau. Mag nʌm dʌ̈i hĩchab durrpierr hʌʌur t'eega duuimam dʌ̈i jãdau t'eegjã burrju. Mamʌ mag nʌmʌn sĩi warrpem Jöoirau hõor dau haug waupi simʌugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pãach mordam wir haig hʌʌrk'abat'ʌ̃. T'et'em k'ʌʌnag pãar pʌr deewi judionaan Hẽwandam hiek jaaujem degjã pãar gaai hamau mas deemaju. Mʌ gaaimua pãar k'aibag waumk'ĩir hamau pãar gobernadornaan haarjã warrwi reinaan haarjã warrmaju. Mamʌ magʌm k'ʌʌn haar pãar warrwaita warag pãrau mʌ hiek jaauwímʌcha hamag jaaujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hẽwandamau mʌg durr hi hagk'aju nawe mʌg hõor peerdʌ haaujem hiek'an hichiita t'umaa durr warp'am magwe meupierr jaaudubjugui hajim hanʌm hĩchab. ");
INSERT INTO noaH_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mag pãach pʌr haauwai, t'et'emnaan k'ĩirp'ee hiek'aagpaawai, hoob pãrau, “¿K'an hata mʌ hiek'ajuuta mʌgbaadëma?” ha k'ĩirjumiet hajim hanʌm. ¿K'an jãgwi mua mag chirʌ́? Ya maig chan pãar pãach k'ĩirjugdamaupai hiek'abam; magbaadëm haiguin hich Hẽwandam Hak'arauta pãrag hiek'amk'ĩir k'ĩirjug deeju haawaita mua mag chirabahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mag jaran wir haig k'od hãbam k'ʌʌnjã chi hʌ̈k'aba sim garmua hʌ̈u mʌ hiek hʌ̈k'a k'ërʌm t'et'emnaanag jaaupʌ̈imaju, hich k'odpai wir haig t'õomk'ĩir. Hamach dënnaanjã mʌ gaaimua t'õomk'ĩir t'et'emnaanag jaaupʌ̈imaawai chi dënnaanaujã hich hagjö hajugui hajim hanʌm, hamach chaain dʌ̈i wir haig. ");
INSERT INTO noaH_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pãachdëu mʌ hiek hʌ̈k'a durrum gaaimuajã t'umaam k'ʌʌnau pãar hoomap'a haju. Mamʌ magʌm gaaimua p'it'ur dau haug wau nʌmjã higba mʌ dʌ̈i hubʌ k'ërʌmʌn hʌ̈u peerdʌjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Hẽwandam hi jaaumie Daniel k'ararrau jaautarrjö, Haai hi jëeujem deg hierr p'adnaank'a nʌm k'ʌʌnjã dubba haajem haarta woun hãb bëewia hichta maig hierr sĩeichëm hoobaawai, Judea durr nʌm k'ʌʌn pabʌ̈ hee durr dapag hee dʌrbat hajim hanʌm. (Mʌg hiek p'ã sim gaai hoonaa t'ʌ̃r simua wajap'a k'ap'ʌ habá.) ");
INSERT INTO noaH_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hich maagwai jua hʌ̃ʌiwai hich dihëu hʌ̃r k'ãijã sim k'ai, hich nem p'ë hawaan hawi hoob tag hierrag dubam. ");
INSERT INTO noaH_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wa magba di chaaur hich p'idag hee k'ãijã sim k'ai, hoob tag degag mam, hich k'ajũajöm k'ãijã jʌraan. ");
INSERT INTO noaH_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mamʌ ¡hëh, hapdurr hajim hanʌm, magbaadëm jaar har hʌʌin jõor k'it'ëem k'ʌʌn, maimua hĩchab hʌʌin har chaaindam daumeraa jũd döpi wai durrum k'ʌʌn! ");
INSERT INTO noaH_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Magju nawe pãrau Hẽwandamagta jëeubat hajim hanʌm, heeu dëgölp magbaadëwia hedau k'õrg jaar k'ãijã pãach dau hap'ʌʌ wënʌrraduk'am. ");
INSERT INTO noaH_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mag jaarta wajapp'a hõor dau haug waujupa. Mag jaar hõor dau haug waujujö chan Hẽwandamau mʌg jẽb hompaaju nawejã hooba, ni hag k'urjã hagjö chan habaju hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mamʌ magbaadëm hich Hẽwandamau bʌ̃ʌrjã k'ãai heeg bʌchdʌ hauba hich mag warag hapik'iin, ni hãbjã peerdʌbaju. Pari har hich hiek hʌ̈k'a nʌm k'ʌʌn daupigau, hirua k'ãai k'apan deeju hatarr hʌ̈u magcha deebajugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Magbaadëm hee hõrau pãachig, “Hoobat, chamʌʌta warrgarwe Hẽwandamau pʌ̈iju haajerrauwai” haawai, hoob hʌ̈k'amiet. Wa magbam k'ai, “Har simta hichiuwai” haawaijã, hoob hʌ̈k'amiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mua mag chirʌmʌn hamach hiiupai hamta Hẽwandamau pʌ̈ijim hanʌm k'ʌʌn dʌ̈i Hẽwandam hi jaaumien hanʌm k'ʌʌnjã sĩi sëuk'a chik'am k'ũgur wënʌrraju haawaita mag chirʌmgui hajim hanʌm, k'ap hamk'ĩir. Mak'ʌʌnaun chadcha Hẽwandamauta hamach pʌ̈ijim hamk'ĩir, hag na hõrau nem hooba haajempa hõor dauderraa wau wënʌrraju. Mag nem wau wënʌrrʌmua hich Hẽwandamaucha jʌr hauwi hich hiek hʌ̈k'api hautarr k'ʌʌnpa k'ũgur hẽk'ajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Magnaa hamag, Mua ya pãrag jaaubarmgui hajim hanʌm, magju nawe k'ap hamk'ĩir; maagwai pãrag mʌch bëeju nawe k'ĩir k'ap'ʌ habat ha chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Mag hõor hajapp'a dau haug wau dichtarr k'ur hĩchab hãsdawam hedaujã k'ĩwia hedaram hedau hargjã k'ĩjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Magbaadëm dʌ̈i p'ĩdagjã hedjã heemua k'ʌibaadeewai tagam nem Hẽwandamau nem waumatarr hedjã hee sĩsidʌmpata sĩi parhooba hamach sĩsid harr chaaur haaidʌ jörrjëe t'ʌnʌisijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Magbaawaita t'umaam k'ʌʌnau mʌch chi Hemk'ooi Hiewaa chadcha hedjã baug hee dau daau hurum hoojurau. Ya maig mʌg jẽb gaaim k'ʌʌn t'um chachbaadëm haawai mʌchta nem jua t'eeg t'umaam k'ʌʌn Pörk'a bëejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mag mʌch pierrum dʌ̈i mua mʌch chognaan durrpierr haaidʌpʌ̈ijugui hajim hanʌm, mʌchdëu mʌch hit'ee jʌr hautarr k'ʌʌn t'um hãbam haig biirdʌ haumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mag jajawagmamua, ’Pãrag k'ap hamk'ĩir mua jaauk'imgui hajim hanʌm: Pãrau k'ap'ʌ nʌm, mʌig Israel durr higo k'ër k'uk'uur haadëmʌn t'umaam k'ʌʌnau ya chadcha döchʌumie burrju dakpapak'am haajem. ");
INSERT INTO noaH_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hich hagjöta hajugui hajim hanʌm hĩchab, mʌch chi Hemk'ooi Hiewaa bëeju gaai paawaijã. Cha mua nem jaau chirʌm t'um hich hag hee höbëbërgmam pãach daúa hoobaawai, k'ap'ʌ habat hajim hanʌm: ya mʌch chi Hemk'ooi Hiewaajã deeu bëeimʌʌ chirʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mua pãrag mag haai hi jëeujem di hõrau pogueupʌ̈iju ha chirʌmʌn, cha hõor t'ʌnʌm k'ʌʌn k'ëchju nawe, cha mʌchdëu jaau chirʌmjö t'umaa chadcha hajugui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hedaujãjã mʌg jẽb dʌ̈i t'um chuk'u haadëju, mamʌ cha mua pãrag jaau chirʌm chan sëuk'aawai k'abam; jãan t'umaa hich hag hee höbëbërgmajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Mamʌ mag mʌ bëeju hed chan ni hãbmuajã k'augbamgui hajim hanʌm. Hẽwandam chognaan hʌ̃gt'ar t'ʌnʌm k'ʌʌnaujã k'augba, ni mʌchdëujã k'augba, hãba hich mʌ Hayaupaita mag mʌ bëeju horajã k'ap'ʌ simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Mag pãachdëu mʌ bëeju horajã k'augba naawai muan pãragan, nem parhoobam nem wauba Hẽwandamagpaita jëeu nʌʌ jëeu nʌʌ habat ha chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mag mʌ bëejuun, woun hãb deeum durr maagpaawai hich chognaanag chi mork'ʌ dënjö hich di t'ʌamk'ĩir jaaunaa, hamachpierr p'idagjã jaauk'awi, chi puertdi t'ʌajemʌgjã hajap'a hoopaar jaau pʌawi petarrjöta simgui hajim hanʌm. Maagwai pãar chi di gar nem t'ʌa nʌisierrjöta nʌmgui hajim hanʌm hich k'apeenag. ");
INSERT INTO noaH_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mamʌ pãrau ni hãbmuajã mag mʌ bëeju k'augba naawai sĩi wajap'ata k'ĩir k'aug nʌisit hajim hanʌm, mʌ bëewaim hit'ee. Pãrau k'augbam, k'an horata mʌ bëeju: k'eeuraa haadëm hee, hedachanaa, hãspa hurumua hãt'ãrr bĩebaadëm hee, wa hedp'erre k'ãijã, ni hãbmuajã k'augbamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Heeu sĩi dëgölp mʌ dʌnʌʌubaicheewai mʌ dʌ̈i wëtaag pãar hagt'a k'ĩir k'augba k'ãi nʌmjö nʌm k'ãijã hoochëduk'am. ");
INSERT INTO noaH_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cha mua pãrag mag jaau chirʌm chan sĩi pãragpaijã k'abam; maan t'umaam k'ʌʌn hit'eeta mag jaau chirʌmgui hajim hanʌm. Maguata muan pʌaba, k'ĩir k'augbat'ʌ̃ ha chirʌmgui hajim hanʌm, mʌ bëewaim hit'ee. ");
INSERT INTO noaH_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jesuu mag hich k'apeenag hich mawia deeu bëeju jaauwai nemk'oo pömaam burraag k'ãaidam numpai waaur sĩejim haajem. Mag p'iesta hĩchab Pascua ha t'ʌ̃ʌrjem; hajapcharan maar meeun judionaanau pan sĩi hich jãg levadura chuk'u wauwia seman hëntër k'oojem hag semanma. Mag p'iesta burrju k'ãai k'apan k'aba waaur nʌm hee, p'adnaan chi pörnaanau Moiseeu Hẽwandam hiek p'ã pʌatarr jawaag chi machnaan dʌ̈imua hãba biirdʌwi k'ĩirjug jʌr naajim hanaabá, nemdam bʌ̃ʌr habarm gaaimua Jesús himeraa pʌr hauwi t'õopʌ̈yaag. ");
INSERT INTO noaH_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hamach hödegpain mag hi t'õopʌ̈iju k'ĩirju naajieb mamʌ, jũrr tagam k'ʌʌnau, “Keena, mʌg nemk'oo hee maadëu hi t'õoba sĩuju. Magba hak'iin hõor pöm mʌg wëjöm maach dʌ̈ita meeuk'aju” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mag nʌm hee Jesús Betania p'öbördam hee mawi woun Simón hanʌm deg t'ach k'ö sĩejim haajem. Hich mag Simón hibʌʌr wauwi “p'ĩe paraa k'itarr” ha t'ʌ̃ʌrjeejim haajem. Maig hi t'ach k'ö simta, hʌʌi hãb jʌ̃gdee didam durrk'udau alabastro hanʌm dën boteedidam wau k'itʌm dʌ̈i dubchëjim haajem. Mag hee jʌ̃gdee narrdo hanʌm dën t'ũpaaga sim hipir haibëejim haajem. Mag jʌ̃gdee k'ĩir nem parhẽpag sĩerrʌm. Mag sim dʌ̈i jua hee dubchëwi, chi boteedidam hö k'õorpnaa, hõor dak'ĩir Jesús pör hee choopʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mes gaai hi dʌ̈i hãba t'ach k'ö narr k'ʌʌnau hamach daúa mag jʌ̃gdee parhẽpagk'amta sĩi hi pör hee choobapʌ̈im hoobaawai hãaur k'ʌʌnau wir haigpai hamach k'apeenag, —Keena, ¿k'ant'eeta jãg jʌ̃gdee parhẽpag simta sĩi jãg hãr choobarma? hajierram hanʌm, ");
INSERT INTO noaH_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","jãg sĩi par hãr chooju k'ãai, parhẽp'ʌ përpʌ̈iwia hag p'atk'onau hʌ̈u dau hap'ʌʌm k'ʌʌn k'ĩirdam jãsenk'aju haai sĩerrtá. ");
INSERT INTO noaH_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mag bigaaum k'ʌʌnau magbaawaita jũrr hich Jesuu hamag, —¿K'ant'eeta pãrau mag hʌʌi k'ĩir naau hiek'a nʌma? hajim hanaabá. Jãgbarmua hirua mʌ dʌ̈i hʌ̈u habarm k'abahab; hidëu hi sĩi k'ajap'a sĩubat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dau hap'ʌʌm k'ʌʌndaman pãrau pãach hee hich jãg hoo wai wënʌrrajugui hajim hanʌm. Maagwai pãachdëu nemdam deem k'õsim haig pãrau hamag deeju haai naabahab; pari mʌ chan pãrau pãach hee hich mag mʌ hoo wai wënʌrrabaju. ");
INSERT INTO noaH_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mʌg hʌʌirau hichdëu k'ĩirjuawai hajapcha simjöta habarbahab mʌ dʌ̈i. Mʌg mʌ pör hʌ̃r jʌ̃gdeeu choobarmua mʌ meebaadeewai hauk'ëraan harrju nawe ya hirua mʌ k'a p'uur sim k'abahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Magnaa, Hĩs mua chadcha pãrag mag chirʌmgui hajim hanʌm: Mʌg hatag pawiajã durrpierr Hẽwandamau hõor peerdʌ haaujem hiek jaau wënʌrrʌm dʌ̈i hĩchab mʌg hʌʌirau mʌ dʌ̈i mʌgbarmjã jaaub k'aba jaauju. Mag, hooba harr k'ʌʌnaujã hĩchab hi hiigjeejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mag p'adnaan chi pörnaanau Moiseeu Hẽwandam hiek p'ã pʌatarr jawaag chi machnaan dʌ̈imua hich Jesús dak'ãu wai nʌm hee, hich dʌ̈i doce wënʌrraajerr heem hãb Judas Iscariote ha t'ʌ̃r sĩerrau p'adnaan chi pörk'a nʌm k'ʌʌn dʌ̈i hiek'aan majim haajem, jãga hichdëu hamag Jesús pʌr deeju ha jawaag. ");
INSERT INTO noaH_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Maimua mawia chadcha Judaau hamachig Jesús pʌr deeju ha hũrbaawai chi p'adnaan pörk'a nʌm k'ʌʌn honeeu p'öbaadëwia chi Judaag p'atk'onpa deeju hajierram hanaabá. Hichig mag p'atk'onpa deeju habaawai chará hãba hi himeraa pʌr hauwia warre hamag hamach jua hee deeju k'ĩirjugpaita wai sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan levadura chuk'u wauwia warrpem p'iesta burr nʌm hedcha judionaanau nemk'oo jaram hit'ee ovejadam t'õowia hedau k'ëubaadeewai k'oojem. Magua hich mag hedcha Jesús k'apeenau hirig, —¿Jampaita marau pʌ na p'iejãb wauwimaju haai nʌma? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mag hichig jëeubaawai hich k'apeen heem numí hich haig t'ʌ̃rk'a hauwi pʌ̈yaagpamua hamag, —Pãar maar na Jerusalén p'öbörög hërëubaadët hajim hanʌm. Nau pãar ya p'öbör hee paauk'abaimaawai pãrau woun hãb döt'ũr hee dö jöi harrum hooimajugui hajim hanʌm. Mag woun döt'ũr dʌ̈i mam hoobaawai hi hẽudee wëtwi, ");
INSERT INTO noaH_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","hi dubbaimam deg dʌ̈i dubwia, chi dik'ʌʌg mʌ himeerba, “Maestroou pʌrʌg jëeupijim, ¿jamta hí hich k'apeen dʌ̈i hãba nemk'oo jaram t'ach k'öju haai chirʌ́?” ha jëeubat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Magbaawai mag wounau pãar hʌ̃gt'aa warrwia dijã pöoma sĩi wajapp'a jar sim pãrag jaauju. Maigta p'iejãb wauwia sĩi maar na wajap'a nem k'ĩir k'aug sĩubat hajim hanʌm, mag hich k'apeen hichdëu pʌ̈iju k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesuu hamachig magbaawai, chadcha hi hipierr Jerusalén p'öbörög hërëuwia hooimaawai, chadcha hamachig jaautarrjö hooimajierram hanaabá. Mag hoobaimaawai maig mag nemk'oo jaram ovejadam wai narr wauwia sĩi hi baraata hoo nʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mag hich na numí pʌ̈itarr haawai ya k'eeuraa haadëm hee, tagam k'ʌʌn dʌ̈i barjim haajem, warm k'ʌʌnau p'iejãb wau wai narr haar. ");
INSERT INTO noaH_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mag barbaimaawai t'ach t'öik'awia ya hãba mes gaai k'ö nʌmua Jesuu hamag, —Keena, mua warre pãrag jaauk'imgui hajim hanʌm: Mʌ cha hiek'a chirʌm hiek'au maach k'apeer mʌig maach dʌ̈i hãba t'ach k'ö simuapai t'et'em k'ʌʌnag mʌ pʌr deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jesuu hamachig mag hiek'abarm hũrwia warre hök'ĩirjuu nʌisijim hanaabá. Mag hök'ĩirjuu nʌm hiek'au jũrram k'ʌʌnau hirig jëjëeu haajeejim hanʌm, chijãguata magju k'ap haag hawi. ");
INSERT INTO noaH_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mamʌ par mag hichig jëjëeuk'amjã hamag chi t'ʌ̃rjã jaauba, sĩi, —Pãach mʌg doce nʌm heem hãb mʌ k'ö chirʌm t'ëp hee hich panau sĩk'ö sim wounauta mʌ k'aibag waujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mʌ dʌ̈i magbarmua Hemk'ooi Hiewaan Hẽwandam hiek p'ã sim gaai jaau simjö hich hag heyaata höbëbërgmam. Mamʌ ¡hëh, hapk'iitʌ chi mag mʌ përpʌ̈i sim woun! Hante magju k'apnaa t'aababa harr hamuan hʌ̈ucha hak'amgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Maimua mag hiyʌ̈ʌ t'ach k'ö nʌmua Jesuu pan jua hee hauwia, Hẽwandamag hʌ̈u hajim hanaa k'õreunaa hamag hʌapʌ̈inaa, —Mʌg pan k'öbat. Mʌ mʌ morougui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Maimua hich hagjö jarrdamjã jua hee hauwia, hag paar Hẽwandamag hʌ̈u hajim hanaa, deeu hamag hʌapʌ̈ijim haajem. Magbaawai t'umaam k'ʌʌnau hag heem döjierram haajem. Mag hʌapʌ̈iwia hich Jesuupai magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Jãg döbarmʌn mʌ bagau, warrgarwe Hẽwandamau hõor dʌ̈i hiek deeju haajerr. Mamʌ mʌg hiek'an hiek hiiuriugui hajim hanʌm. Mʌg pãar hit'ee mʌ bag mʌg vinojö k'itʌm hãrbarmuata Hẽwandamau, hĩsmua hatagan chadau pãar peerdʌ wënʌrraju haai nʌm ha jaau simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Maimua, Mua warre pãrag jaauk'imgui hajim hanʌm: Mʌg vino döbarm haigmua mua chan tag döba, hãba Hẽwandamta t'umaam k'ʌʌn Pörk'a sĩsim hedta deeu hag k'ãyaujã hajapcharamta döjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesús mag hich k'apeen dʌ̈i hãba mes gaai hiyʌ̈ʌ t'ach k'ö naawia, meuk'aarjã Hẽwandam hiek Salmos hanʌm gaaim hauwia, Olivo durrsĩig hërëujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mag wëtwia mam pabaimaawai hich Jesuu hamag magjim hanʌm: —Nau pãach t'umaam k'ʌʌnau mʌ mʌch happai barpʌaju. ¿Jãgwi mag chirʌ́? Hich warrgarwe Hẽwandam hi jaaumienau Hẽwandam hiek p'ã pʌarr gaai hich mag haju ha sĩewaima. Mag hamau p'ã pʌarr gaai jaauwai, Hẽwandamau hʌdʌraa chi nemchaain pap hõrag t'õopiju ha sim, mʌ higwia. Mag mʌ t'õopʌ̈yaag pʌr hat'aawai pãar sĩi nemchaainjö parhoob pãach papjã k'augba, chawag haaidʌju ha p'ã simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pari mag mʌ t'õopʌ̈iwiajã deeu hiiu p'iidʌwia mʌchta pãar na majugui hajim hanʌm, Galileaag. Mamta deeu pãar dʌ̈i hoojugui hajim hanʌm hich k'apeenag. ");
INSERT INTO noaH_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jesuu mag hiek'abaawai Pedroou hirig magjim hanʌm: —Mʌ k'apeenau pʌ hogdʌwia chawag haaidʌtk'awiajã mʌ chan bʌ̃ʌrjã pʌ haigmua chawag hogdʌbamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pedroou hichig magbaawai Jesuu hirig, —Pʌ mag hiek'a chirab mamʌ, cha mʌ hiek'a chirʌm hiek'au nau hãspajuag hãt'ãrr biek numí bĩeju nawe hõrau pʌchig jëeubaawai pua biek t'ãrjup mʌ k'augba chitʌm hajugui hajim hanʌm hichigcha. ");
INSERT INTO noaH_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Magbaa Pedroou jũrr hirig, —Pʌ t'õbaimam haar t'õimaju hawiajã mua chan pʌ k'a hogdʌbajugui hajim hanʌm. Pedroou mag hijẽjẽb k'aawai tagam k'ʌʌnaujã hich hagjö, “Maraujã pʌ k'a hogdʌbaju” ha hiek'a naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesuu hich k'apeen hich dʌ̈i p'ë harrwia nemjĩirdö Getsemaní hanʌm hee barwia hamag, —Mʌ chum Hẽwandamag jëwaan mamich, pãar mʌig nʌisit hajim hanʌm tagam k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Magpet hawi t'ãrjuppai hich dʌ̈i p'ë harrjim haajem: Pedro, Santiago maimua Juan. Maimua hamach happai hap'öbaadëm haig, Jesús nem hök'ĩirjuuga haadëmua gaai machaaga haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hich magbaadeewai hichdëu hamag magjim hanʌm: —Mʌʌn dëgölp gaai machgau hök'ĩirjuuga haadëm; hãba mʌch t'õjuuta k'ĩirju chirʌmgui hajim hanʌm. Pãar mʌig nʌisit, mamʌ dauk'ana habat. Hoob k'ãimiet hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Magpet hawi hichin hag hatgajãrpai kanieu p'õbk'anaa, jẽb gaai dagau dʌrnaa, Hẽwandamag jëeumamua hi gaai machag hãwatpibaju hak'iin hʌ̈u hak'am ha jëeumajim haajem. Magnaa, ");
INSERT INTO noaH_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Tata, pʌ hit'ee chan bʌ̃ʌrjã p'it'urm nem chuk'um. Pua k'õs chirʌm k'ai mʌ peerdʌ hat'á hajim hanʌm, mʌ dau hap'ʌʌ haju nawe. Pʌrʌg mua jëeu chirʌm, mamʌ mʌchdëu k'õsi chirʌmjö k'aba pʌchdëu k'õsimjöta habá mʌ dʌ̈i ha jëeumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mag jëeu sĩewi ham haig bëewi hoocheewai ham k'ãi nʌmta hoochëjim hanaabá. Magbaawai jũrr Simonagta, —Pʌʌn sĩita k'ãi chirabma. Pʌ chan horadam hãbjã pöd dauk'ana haju k'abahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sĩi jãg k'ãi nʌʌ haju k'ãai Hẽwandamagta jëeubat hajim hanaabá, dösãtag hʌdʌʌr pãach t'ʌ haupim hugua. Mua hoowai pãach hödiiwan chadcha pãrau jëeum k'õsi durrumta pari dap'ökgauta pödba nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mag hiek'a pʌawi deeu ham haigmua petajim haajem. Maimua Hẽwandamag hichdëu nacha jëeu sĩerrjö hich hag hiekpai hiek'amamua deeu jëeumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mag jëeu sĩi hawia deeu hoon bëewaijãh, hi k'apeen dap'ökgau pödjã dau hẽeba, sĩi k'ãidʌtk'a t'ʌnʌmta hoochëjim hanaabá. Mag dap'ökgau pödjã dau hẽepiba t'ʌnaawai Jesuu hamachig hiek'abaichëmjã pöd hi hiek hʌ̈k'aju k'augba naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mag biek t'ãrjupam gaaijã hagt'a k'ãidʌtk'a t'ʌnʌm hoobaicheewaita deeu hamag, —¿Hagt'a pãar sĩi k'ãai gaaita nʌ? K'ãigap nem pʌabat hajim hanʌm. Pekau pöm sĩsidʌm k'ʌʌnag mʌch chi Hemk'ooi Hiewaa pʌr deeju hora pabaichëbahab. ");
INSERT INTO noaH_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","P'iidʌtk'abat, maimua maach k'apeen haar wëttarrau hajim hanʌm. Mʌ hoomap'am k'ʌʌnag mʌ pʌr deeju wounan ya dakpa hurumgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús hagt'a mag hiek'a dʌnʌm hee, hich k'apeenpai mag doce narr heem hãb Judas hanʌmta hõor pochag hurajim hanʌm. Mag wëdurum k'ʌʌnan hãaur k'ʌʌn sĩi espaar jua panhap'a bëe t'ʌnaawai tagam k'ʌʌn sĩi pa dʌ̈ijã bëe t'ʌnaajim haajem. Mak'ʌʌn p'adnaan chi pörk'a nʌm k'ʌʌnau Hẽwandam hiek jawaag chi machnaanau tagam k'ʌʌn jöoin chi pörnaan dʌ̈imua pʌ̈itarr k'ʌʌn hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mag chadcha hõor pochag bëewi ya chi Judaau hag nawe, “Nau mua mawia pãach dak'ĩir k'ĩir hʌ̃ʌ hat'amta pʌr hauwia hat'aadët” ha jaau wai sĩerr haawai, ");
INSERT INTO noaH_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","chadcha hich dʌ̈i wënʌrrʌm k'ʌʌn dak'ĩraa hichdëu jaautarrjö Jesús dʌ̈i hãba dʌnʌʌuwimawia hirig, “Maestro, ¿jãgpai chirʌ́?” hanaa hi k'ĩir hʌ̃ʌ hat'ajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Magbarm bʌ̈rre chi soldaaunau Jesús p'ʌʌr t'uur hauwia hi pʌrp'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mamʌ chi k'apeen hi dʌ̈i wënʌrrarr k'ʌʌnau hamach dak'ĩir mag hamach k'apeer pʌrp'öbaadëm hoobaawai hãbmua hich espaar chi baindegam sʌrr ha jẽu haunaa waa p'adnaan t'umaam k'ʌʌn pör hag chog kachta bis habarmʌn hoort'u werbpʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mag hich pʌrp'öbaadeewai Jesuu hamag, —¿Pãrau hoowain mʌʌn sĩi hõor nem jĩgk'anaa hõor t'õomiejöta chirab hajim hanʌm, jãg pãrau sĩi mʌ haig jua hee jierrnem panhappai bëeg hit'ee? ");
INSERT INTO noaH_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Hag na hed hëepierr pãrag mua Haai hi jëeujem deg Hẽwandam hi jaaujeewai bʌ̃ʌrjã pãrau mʌ pʌr hauba harrta hĩsta chadcha pãrau mʌ pʌr hauju hed hajimgui hajim hanʌm. Pari pãrau mʌ dʌ̈i mʌgbarmʌn, jãan mʌ higwia hich Hẽwandam hiek p'ã sim gaai jaau sim t'umaa hich hag hee höbëbërg mamk'ĩirta chadcha mʌgbarmgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chi k'apeenau mag hamach dak'ĩir hamach Pör pʌrp'öbaadëm hoobaawai tag hirigjã hooba, sĩi warag k'ap'ig p'öbaadëwia hich happai barpʌajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mamʌ mag hamau hich happai hi werpʌawia hat'aadëm hee, hẽwan hãb sĩerrauta sĩi börrjöoupai höpʌʌrnaa dʌ̈i hi hẽudee maa hajim haajem. Mamʌ chi soldaaunau mag woun dʌ̈i mam hoo hat'aawai hi pʌr hawaag hẽk'a naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pari mag hich gaai pʌrbaichee sĩi warag ham jua hee chi börrjö jẽu pʌawi hich jãg mor k'arr k'ap'igbaadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Soldaaunau mag Jesús pʌr hauwia hãb mag p'adnaan t'um t'ʌnʌm k'ʌʌn pörk'a sim haar warrjierram haajem. Mag mam hi wai dubp'öbaadeewai haig pos haimajierram hanaabá: tagam k'ʌʌn chi p'adnaan pörk'a nʌm k'ʌʌn, judionaan Asamblea heem chi pörnaan, maimua hagjö Moiseeu Hẽwandam hiek p'ã pʌarr jawaag chi machnaanpa t'um hãba. ");
INSERT INTO noaH_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mag hi pʌr hat'aadëm hẽudee hĩchab Pedroou sĩi warppaimua hoopʌ̈pʌ̈ig mawia p'adnaan pör sĩejem hag di hũjãrr dʌ̈i dubwi jupimajim haajem, guardianaan Haai hi jëeujem di t'ʌajem k'ʌʌn bigaau. Mag jupimawi hi hiek hõt huu t'ʌnʌm bigaau dʌ̈i chi guardianaanpa hãba hõt k'ãai hoo chirsijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Maagwai p'adnaan chi pörnaanau judionaan Asamblea heem k'ʌʌn dʌ̈imua chi Jesuu nem wauba harrta sëuk'a hi gaai t'ʌpʌ̈iju hẽk'aajeejim hanaabá, magʌm gaaimua hi t'õopäaig. Mamʌ chadcha hirua bʌ̃ʌrjã nem k'aigba wauba sĩerr haawai ");
INSERT INTO noaH_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","parii hi k'aibag waupi jaau nʌm k'ʌʌnaujã sëuk'a nem hĩgk'am k'õchgau hamach hiekpai parhoob jaaubaadëp'ʌmjã pöd hi pʌr hauba haajeejim haajem, mag hihãbajã k'aba sĩi haaip'ur nem jaaup'öbaadëp haawai. ");
INSERT INTO noaH_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Warm k'ʌʌnau mamagk'am hee, jũrr deeum k'ʌʌn bʌ̈jãau paauk'abaadëwi chi t'et'emnaanag hich k'ĩircha, ");
INSERT INTO noaH_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Marau maachdëucha hi hiek'a sim hũurwain, hirua mʌg Haai hi jëeujem di hõrau da hëu hauba harrjã sĩi t'um pogueupʌ̈iwia, hõor juajã higba, k'ãai t'ãrjuppaim hee deeu hëu dʌnʌʌuju ha hiek'a sim hũrjimgui haajeejim hanaabá jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mamʌ par jũrram k'ʌʌnau mamagk'amjã hihãbajã deeba, sĩi warag maadëujã k'augbata jaaup'öbaadëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Magbaa chi p'adnaan pöröu sĩi mag hõor pos t'ʌnʌm hee p'iidʌbaadëwi Jesuug, —¿Pua ham hiek hũr chirʌ́? ¿K'an jãgwi jãg pʌ hiek'amap'a sĩ? hajim hanʌm. ¿Pua chadcha mag hiek'ajĩ wa hiek'abajĩ? Jaaubá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mamʌ magʌmjã Jesuu bʌ̃ʌrjã jʌ̃ʌjã haba, sĩi warag k'ĩuu sĩsijim hanaabá. Mag hich hiek hʌ̈k'aba habaawaita deeu chi p'adëu pʌaba jëeumamua hirig, —¿Pʌʌta chadcha Hẽwandam Hiewaa hichdëucha jʌr hauwi pʌ̈iju jaaujerrá? Marag jaaubá hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Magbaa Jesuu, —Hëera, chadcha mʌʌugui hajim hanʌm. Mʌg hatag pãrau mʌ Hẽwandam t'umaam k'ʌʌn k'ãaijã jua t'eeg hʌ̃rpai sĩerrʌm bigaau hi juachaar garcha jup chirʌmjã hoowi hʌ̃gt'armua hedjã baug hee hurumjã pãach daúacha deeu mʌ hoobajup hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesuu hich dak'ĩir mag hiek'abarm hũrbaawai chi p'adnaan pöröu hich k'ajũa mor gaai jũa sĩerrta sʌrr habarmʌn warre jẽbpʌ̈ijim hanaabá, k'ĩir machgau. Magwia hich k'apeenag, —Keena, ¿k'an hatchata maadëu deeum k'ʌʌnau jaau nʌmta hũrm hig nʌma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya hirua hich hiiucha jaau sĩebahab hajim hanʌm. Pãrau t'umaam k'ʌʌnau hi hiek'abarm hũrbarm, chadcha hirua Hẽwandam dau na k'aigba hiek'abarm. ¿Pãrau mʌg woun dʌ̈i jãga haju k'ĩirju nʌ keena? hajim hanʌm hich k'apeenag. Magbaawai t'umaam k'ʌʌnau hihãba, —Jãan hiekk'õr pöm sĩewai hichiita t'õopʌ̈ijugui hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Magp'öbaadëwi hãaur k'ʌʌnau warag hi k'ĩir gaai hichöoujã t'unaa, putiujã hi dau p'ãarjʌ̃naa, hi gaai mas waunaa, juajãaujã k'ĩidadcha deejeejim hanʌm. Magnaa hogt'om hirig, —¿K'aíuta pʌ gaai mas deejĩ? Magan jaaubá haajeejim hanʌm. Mag jũrram k'ʌʌnau hi mag wai naawai chi Haai hi jëeujem di t'ʌajem guardianaanaujã dʌ̈i hi k'ĩidadcha deejeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mam hierr Jesús dʌ̈i mamag k'aawai Pedro hiek hi di hũjãrr chirajim haajem, daaugajãr. Maig hi chirʌmta hi haig hʌʌi hãb bëejim haajem, p'adnaan t'umaam k'ʌʌn pörk'a sim hag chog. ");
INSERT INTO noaH_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mag hʌʌirau Pedro hõt k'ãai sim hoobaicheewai hi k'ĩir heerpa wai dʌnʌʌ hawia hirig, —Pʌjã hĩchab Jesús Nazaretpierr dʌ̈i nʌrraajem k'abahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hichig magbaawai hi hiek hirua, —Mʌ k'abam, mua k'augbam pua k'aita jaau sim k'ai ha chirajim hanʌm. Magwia warag dawag mawia puertdi daaugajãrm haar hi hoot'ẽu chiirbaimamta, hãt'ãrrta kekerekee haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Maimua deeu hũmaai chi hʌʌirau hichdëu hi hoobaawai haig hõor t'ʌnarr k'ʌʌnag, —Chamʌg woun chadcha Jesús dʌ̈i nʌrraajerr k'abahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mag, biek numiim gaaijã Pedroou hirua magʌm Jesús k'augba chitʌm hajim hanʌm. Mamʌ hag k'ur nʌʌpai hawia deeu hũwaai haig narr k'ʌʌnau, —Chadcha pʌʌn hĩchab Jesús k'aperau. Pʌ Galileapierr k'abahab hajim hanʌm. Maguata pʌ hiek'a sim hũurwaijã pʌ hiek gaai merag chuk'u sĩsim k'ap'öbaadëjim hanʌm hirig jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pari hichig mag nʌʌ paawai Pedro hiek warag hirua chi Jesús higwia, —Chadcha mua magʌm woun k'augab chitʌmta mʌrʌg mag naab. Mʌ sëuk'a chirʌm k'ai, Hẽwandamau mʌ gaai jua k'ʌaba deeju haai simgui ha chirajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedroou mag hirua chan bʌ̃ʌrjã Jesús k'augba chitʌm ha hiek'abarm hee, deeu hũmaai chi hãt'ãrrta kekerekee hajim hanaabá. Mag hãt'ãrr biek numí bĩe dichdimaawaita Pedroou warre Jesuu hichig hiek'amatarr k'ĩir heyaa haadëjim hanʌm, “Hãt'ãrr biek numí bĩeju nawe pua biek t'ãrjup hõrag bʌ̃ʌrjã mʌ k'augba chitʌm ha hiek'aju” hichig Jesuu jaautarr. Hichig magtarr t'umaa k'ĩirju hat'aawaita warre hök'ĩirjug machag haadëmua hicharaucha hö jãsehne bĩe chirʌʌ hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Maimua hag hãspaau hedp'erre t'um chi t'et'emnaan hãbam haig podpajierram haajem, k'ĩirjug jʌrwi Pilato haar paawai Jesús k'aibag waupiju jaau k'ap'ʌ jawaag. Maig naajim haajem: p'adnaan chi pörk'a nʌm k'ʌʌn, Moiseeu Hẽwandam hiek p'ã pʌarr jawaag chi machnaan, judionaan heem jöoin chi t'ierrnaan maimua tagam k'ʌʌn hagjö chi Asamblea heem k'ʌʌnpa t'ʌnaajim haajem. Mak'ʌʌnauta hamach t'umaam k'ʌʌnau Jesús jua jʌ̃k'anaa Pilato haar harrjierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mag hich haar wai barbaimaawai Pilatoou hich Jesuug —¿Chadcha pʌʌta judionaan Reí? ha jëeujim hanʌm. Magbaawai Jesuu hirig, —Pua k'abá k'ap'ʌ jaaubapʌ̈im hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mag warag chi p'adnaan pörk'a nʌm k'ʌʌnau hich k'ĩircha hiek pöm hamachdëu jaaum haig sëuk'a hiek'amatarr higwia ");
INSERT INTO noaH_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","deeu hũmaai Pilatoou hirig, —¿K'an jãgwi pʌ hiek'amap'amjö sĩ? hajim hanʌm. ¿Pua hũrbahab, jũrram k'ʌʌnau pʌch k'ĩircha pʌch k'aibag waupi jaau nʌm? ");
INSERT INTO noaH_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mamʌ parii Pilatoou hichig mag jëeu hahauk'amjã sĩi warag k'ĩuu habaawai hich hödegpai, “Wounaan mʌg hoohba chitʌm” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatoou hag nawejã añopierr mag p'iesta Pascua hanʌm burrwai presonaan heem hãb parhoobam chi p'öbörpienau jëeubarm höbeerpäaijeejim. ");
INSERT INTO noaH_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Maagjerr haawai hich mag jaar woun hãb Barrabás hanʌmta deeum k'ʌʌn dʌ̈i cárcel deg preso sĩejim, hichdëu gobierno dʌ̈i hõor meeuk'apiwia hag meeuk'aa hee hõor t'õotarr gaaimua. ");
INSERT INTO noaH_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mag nemk'oopierr preso hãb sĩi höbeerpäaijerr haawai chi p'öbörpien hãbam haig biirdʌwia hag na Pilatoou hichdëu haajerrjö preso hãb höbeerpʌ̈imk'ĩir hirig jajaau haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hichig magbaawaita Pilatoou hamag, —¿Pãrau judionaan Rey Jesuuta mʌrʌg höbeerpʌ̈ipi nʌ? ha jëeujim hanaabá jũrr hamag. ");
INSERT INTO noaH_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hirua mag Jesuuta höbeerpʌ̈im k'õsi sĩerran, p'adnaan chi pörk'a nʌm k'ʌʌnau sĩi hamachdëu Jesuu nem wau nʌrrarrjö pöd nem waubam gaaimua hiekk'õr wau nʌm hiek'auta mag hi pʌr dee wai nʌm k'ap'ʌ sĩerr haawaita mag hiek'ajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","¡Hih! Mamʌ Pilatoou mag hiek'abaawai chará chi p'adnaan pörk'a nʌm k'ʌʌnau sĩi warag hõor wawik'a t'ʌnʌʌujim hanʌm, t'umaam k'ʌʌnau hãba Barrabaata sĩi hich jãg weeupʌ̈ipi jajaau hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mag Barrabaata sĩi höbeerpʌ̈ipim k'õchk'a nʌm hũrbaawai deeu Pilatoou, —¿Mag judionaan Rey hanʌm dʌ̈i mua jãgajuma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Magbaawai warag serereuk'amua Jesús warre pakuls gaaita meerp'ëpi jajaau haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Magbaa jũrr Pilatoou hamag, —¿Pari k'an nemta hirua k'aigba waujĩma hajim hanʌm, pãrau mag warre hi t'õopi jaau nʌm? Mamʌ hirua magbaawai chará warag hich mag pakuls gaaita meerp'ëpi jajaau haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mag warag serereuk'amjã pʌaba haawai, hõor pöm mag t'ʌnʌm jũrr hich dʌ̈ita meeuk'am hugua, chadcha ham hipierr Barrabaata weeupʌ̈ipi jaaujim hanaabá. Maimua chi Jesús jũrr wʌpi jaaunaa pakuls gaai meerp'ëpʌ̈imk'ĩir warre hamach jua hee deepʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Magbaawai chi soldaaunau Pilato sĩejem hag di hũjãrr chi Jesús warrwia soldaaun t'um hãbam haig t'ʌ̃rk'a haujierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mag warrnaa, hirig k'ajũa k'ichp'ë k'ĩir jũapinaa, hich hagjö miu dën wërjũch p'ʌʌrt'ʌ waunaa, pör gaai pörsirk'a jũapipʌ̈ijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mag jũapipʌ̈inaa juau hogt'om chi soldaaunaupai hi wau hiek'amamua, —¿Jãgpai chirʌ́ judionaan Rey? haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mag wai nʌmua hi pörchajã paau wʌnaa, k'ĩirchajã hichöou t'unaa, sĩi hi wau nʌm hiek'au hi k'ĩirp'eejã kanieu p'õbk'ak'a haajeejim hanʌm, hamach rey hanʌmua. ");
INSERT INTO noaH_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mag hi dau hap'ʌʌ wau wai nʌʌ hawia, hamachdëu hirig k'ajũa k'ichp'ë k'ĩir jũapitarr deeu hẽer hauwia, hich k'ajũa chaardamta deeu jũapipʌ̈inaa, pakuls gaai meerp'ëpäain hat'aadëjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mag Jesús pakuls gaai meerp'ëpäain harrum hee, ham k'ĩirp'ee woun hãb Simón hanʌm hich p'idag heemua hich diig hurajim haajem. Mag woun Cirenepierr hajim haajem, Alejandro dʌ̈i Rufo hanʌm ham haai. Chi soldaaunau mag Simón hoobaawai jũrr hajués hirigta Jesuu pakuls harrmaa hatarr harrpijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mag hërëu p'öbaadëwi buchagdam Gólgota hanʌmʌg harrjierram haajem. Maach meúan mag Gólgota hanʌmʌn Pörpá Durrsĩ ha simʌu. ");
INSERT INTO noaH_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Maig Jesuug vino mirra hee waaurëu sim döpiju hẽk'ajierram hanaabá, k'aparr haadëmua gaai machag t'ʌnʌm hãwatamk'ĩir. Mamʌ Jesuu bʌ̃ʌrjã döbajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mag dee nʌmjã döba habaawai hich mag pakuls gaai meerp'ëpʌ̈ijierram hanaabá. Mag meerp'ëpʌ̈iwia, k'aíuta hi k'ajũa wai sĩsiju k'ai hawi, chi soldaaunau hi k'ajũa jũajerr hʌ̃r p'atk'on bar jemk'a nʌmua hamachpierr hagdaujö gan haumajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mag hamau hi pakuls gaai meerp'ëpäaiwai ya hedaup'err garm las nueve t'ʌnaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mag hi meerp'ë wai narr pakuls gaai hi pör hʌ̃r hẽsapdau p'ã sĩejim hanaabá. Mamʌ mag nem k'aigbam wautarr jaauju chuk'u harr haawai sĩi “Judionaan Rey” ha p'ã sĩejim. ");
INSERT INTO noaH_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mag hi meerp'ëbapʌ̈im dʌ̈i hĩchab hagjö nem jĩgk'aajem k'ʌʌn numí hamach k'ĩk'ĩetdö hi bigaau pakuls gaai meerp'ëgk'apʌ̈ijierram haajem: hãb hi juachaar gar, maagwai hãbak'ai hi juawë gar.  ");
INSERT INTO noaH_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mag nʌm haiguin warrgarwe Hẽwandam hi jaaumienau p'ã pʌarr gaai, “Chi k'aigbam k'ʌʌn jãrr wai naaju” ha hiek'atarrjã t'um chadcha hag heyaata höbër sim. ");
INSERT INTO noaH_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mag hi pakuls gaai meerp'ë wai nʌm haig dich nʌm k'ʌʌnaujã hi wau nʌm hiek'au hirig heerpanaa, hʌ̃ip'ʌʌrp'ʌʌrnaa, “Wa jãgʌm k'abá, puan mag Haai hi jëeujem dijã t'um pogueupʌ̈inaa deeu k'ãai t'ãrjuppaim hee hëu dʌnʌʌuju haajerrta, ");
INSERT INTO noaH_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","jãg pua wir haig pʌchpai peerdʌ hauwia jãg pakuls gaaimua heeg hʌʌrbabáma” haajeejim hanʌm, dich nʌm k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sĩi dich nʌm k'ʌʌnaujã hirig mag hiek'a hërëu dich t'ʌnaawai hich hagjö p'adnaan chi pörnaanaujã Moiseeu Hẽwandam hiek p'ã pʌarr jawaag chi machnaan dʌ̈imua hamach hee wir haigpai, “Bigaaum k'ʌʌnan peerdʌ hautarrta jũrr wir haig hichpai chan pöd peerdʌ hauba sim” ha hiek'a naajim hanaabá, hi waauwai. ");
INSERT INTO noaH_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Magnaa hichigcha hiek'amamua, —Israelam Rey, ¿pʌch k'abá hõor peerdʌ haumk'ĩir Hẽwandamau pʌ̈itarr? Magan pakuls gaaimua heeg hʌʌrbabaad hanaajim haajem. Pʌ chadcha maar dak'ĩir heeg hʌʌrbamʌn, maach daúacha hoobaawai marau pʌ hiek hʌ̈k'aju hanaajim hanʌm hirig. Hich dʌ̈icha mag hãba hõor numí hagjö pakuls gaai narr k'ʌʌnaujã hirig hiek k'aigba hiek'a naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hich mag hed hedausĩe t'ʌnʌm hee dëgölp hedau k'ĩbaadëm habarmʌn sĩi warre hedaramjöta jöisijim hanaabá. Mag k'ĩ t'ʌnʌʌ hawia hedau p'ʌʌibaajër las tres naata deeu hedau haardʌbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hich mag hedau k'ĩbaadëm hee Jesuu t'et häa ha k'itawia, “Eloi, Eloi, ¿lema sabactani?” hajim hanʌm. Mag sim haig maach meúan: “Aay Hẽwandam, ¿k'ant'eeta pua mʌ mʌg dau hap'ʌʌ chirʌmjã mʌrʌg hoobamjöo haadëma?” ha simʌu. ");
INSERT INTO noaH_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Magbaawai haig hõor narr k'ʌʌnau Jesuu mag hiek'abarm hũrbaawai jũrr hamach k'apeenag, —Keena, pãadë hũrbat. Maguan warrgarm Hẽwandam hi jaaumie Elías k'ararrta hich haig t'ʌ̃r simwai hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Magbaawai hãbmua k'ap'igbaadëwia, putjö hũhũpp'ë k'itʌm gaai vino hadchuchúhu simta dorrdʌnaa haibëewi, pa gaai bʌʌrnaa, hi hi haig hʌa haujim haajem, hag gaaim bereu dömk'ĩir. Magnaa hichdëupai warm k'ʌʌnag, —Jãgnaan chad hidëu sĩi hootarraugui hajim hanʌm, daau chadcha Eliaau bëewi hi heeg jiirbapʌ̈ichëju. ");
INSERT INTO noaH_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pari mag nʌm hee deeu Jesuu t'et häa ha k'itawia warre chaaupabaadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Magbarm bʌ̈rre hĩchab Haai hi jëeujem deg hierr dijã garcha put nem parrg sim hëu wëjorrta sĩi hʌ̃gt'aamua heeg sʌrr habarmʌn warre jãrrcha t'oop'em numí jijirar jöisijim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mag Jesús häa hawia meebaadëm hoobaawai chi soldaaun ham capitán chi Jesús jiir wëjöm k'ĩirp'ee hoo dʌnarrau, —Chadchata jãgan mʌg wounan Hẽwandam Hiewaaugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Maig hĩchab hʌʌinjã naajim haajem. Mak'ʌʌn hʌʌinau sĩi warppaimua heerpa durruu hajim hanʌm. Chi maig narr k'ʌʌn, María Magdalena hajim haajem, hãb hagjö María ha t'ʌ̃r sĩerrpa. Mag María Santiago hãd hanaa hĩchab José hãd hajim haajem. Maig deeum hʌʌi Salomé hanʌmjã dʌ̈i sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hich mak'ʌʌn hʌʌinauta hi Galilea hee nʌrraawaijã hi dʌ̈i wënʌrrʌmua hirua nemdam hiigwaijã t'umaa hirig hau dedee haajeejim haajem. Maagjerr haawai Jerusalenagjã hi dʌ̈i bëewia dʌ̈i haig naajim hanaabá. Pari mak'ʌʌn happaijã k'aba, mag tag hʌʌin k'apan ham dʌ̈i bëetarr k'ʌʌnjã hĩchab haig naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hamau mag hi dau hap'ʌʌ wai k'ëumaa harran sĩi nem t'um k'ĩir k'aug sĩiujem hed hajim, jua hʌ̃i k'eeujem noram. ");
INSERT INTO noaH_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mag ya k'eeuraa haadëm hee, woun hãb judionaan Asamblea heem José Arimateapierr majim haajem, Pilato haar. Mag woun hĩchab chi t'et'em hajim hanaabá. Mag wounaujã hĩchab Hẽwandamau maach peerdʌ haumk'ĩir pʌ̈iju jaaujerr bëeju hanʌmta nʌajeejim haajem. Hich mag wounauta Pilato haar mawia ");
INSERT INTO noaH_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","hirig jëeuwimajim haajem, chi meemdam harrwi hauk'ëraan maag. Mag Jesús meebaadëm ha hũrbaawai Pilato warre jʌ̃gderraa haadëjim hanʌm, hirua k'ĩirjuawain Jesús meeba hagt'a hiiu sĩeju haai simta mag meebaadëm ha hũrbaawai. Magbaa Pilatoou chi capitán mag dʌ̈i meerp'ë nʌm haar sĩerrjã t'ʌ̃rpʌ̈ijim haajem, magʌg k'ap jëeu hoog. ");
INSERT INTO noaH_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Maimua chi capitán bëewia chadcha meebaadëm ha jaaubaawai Pilatoou Joseeg harrmk'ĩir jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Magbaawai Joseeu dĩesdam për hauwia, mawia, mag Jesús chi meemdam pakuls gaaim heeg jiir haunaa hagua hajap'a pʌrëupʌ̈ijim haajem. Magnaa hag nawe jẽbdi durrbʌ̈ k'õpag hee chi k'örm sĩerr hee hauk'ërwia chi jẽbdi hi hee hajap'a mok pör pöm simua joot'ʌ pʌajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mag chi binaandam jẽbdeg hauk'ërbarm hʌʌin numiim k'ʌʌnau warppaimua hoo naajim haajem. Mak'ʌʌn hʌʌin hãb María Magdalena hajim hanʌm, maimua hãbk'ai José hãd hagjö María ha t'ʌ̃ʌrjerr hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mag t'umaam k'ʌʌn jua hʌ̃i k'eeujem hed k'ëubaadeewai María Magdalena, hãbak'ai María Santiago hãd maimua Salomé dʌ̈i hamach t'ãrjupam k'ʌʌnau jʌ̃gdee përk'a sĩujierram haajem, hagua Jesús k'a p'uraan maag. ");
INSERT INTO noaH_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Maimua hag noram domighed hãspa hëebaadeewai hedaup'erre hõor mor dawaa haadëm hee, hi hauk'ërtarr jẽbdi haar hoon wëtjierram haajem, mag jʌ̃gdeeu hi k'a p'uraag. ");
INSERT INTO noaH_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mag wëtwi hamach happai k'ʌd hee, —Keena ¿k'aíuta chi jẽbdi hʌ̃rʌm mok maachig chawag pʌrëu deejuuta mʌg wëtúma? ha hiyʌ̈ʌ wënʌrrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mamʌ mag hiyʌ̈ʌ wëtmamua barimanaa hooimaawai, chi jẽbdi hi hee mok pör pöm simua joot'ʌ sĩerr jũrr chawag pʌrëupʌ̈i t'ʌnʌm hooimajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Magbaawai warag hierr dubwi hooimaa, woun hãb hẽwanaa k'itʌmta sĩi k'ajũa bäpp'ä k'ajũa bʌ̈ het'err jũa simta mag jẽbdeg juachaar gar jup hoo sim hooimajierram haajem. Hamachdëu mag hoobaawai warre jãp'ierr p'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mag hʌʌin jãp'ierr p'öbaadëm hoowi chi woun k'ajũa bäpp'ä jũa sĩerrau hamag, —Hoob jãp'ierrmiet hajim hanʌm. Mua k'ap'ʌ chirʌm, pãrau Jesús Nazaretpierr har pakuls gaai meerp'ë t'õotarrta jʌr wënʌrrʌm. Pari hi mʌig k'aba sĩebahab hajim hanʌm, ya hiiu p'iidʌwi petarr haawai. Pãadë hoobat hi hauk'ërtarr hee sĩi k'ãidu parii simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maimua hamag, Hërëubaadëwi hi k'apeen tagam k'ʌʌnagjã jaauwi Pedroogjã jaaubat hajim hanʌm: “Hichin ya pãar nawe Galileaag petam. Nau jamta hi hooimaju” ha jaaubat hajim hanʌm, hichdëu hamachigcha hag nawe jaautarrjö. ");
INSERT INTO noaH_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hamachig magbaawai jãp'ierr nʌm hiek'au bʌ̈ duui durrumta heerpamjö dawag höbërdʌtk'awi k'ap'ig p'öbaadëjim haajem. Maimua chi Jesús k'apeen haar bardʌtk'aimaawaijã, hagt'a jãp'ierr narr haawai, bʌ̃ʌrjã hiwiir hãbam k'ʌʌnagjã jaaubajierram haajem.  ");
INSERT INTO noaH_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Maimua mag domighed hãspaau Jesús hiiu p'iidʌwia María Magdalenaagta nacha hich hoopijim haajem, hi haig höbërchëwia. Hich mag hʌʌi mor heem hajim haajem, hag nawe hich Jesuu mepeen k'aigbam k'ʌʌn siete dau daau jʌrk'ʌʌipʌ̈itarr. ");
INSERT INTO noaH_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hichdëu mag hoobaawai chi Jesús dʌ̈i wënʌrraajerr k'ʌʌn gaai machgau bĩe durrum haar mawia hamag jaauwimajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mamʌ mag hamachig hich daúacha Jesús hiiu p'iidʌwi nem moná nʌrrʌm hoojim ha jajaauk'amjã hi hiek hʌ̈k'abajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Magtarr k'ur deeu hũwaai deeum k'ĩir t'egnaa hich k'apeen numí p'öbör heemua k'ʌd ma sim hee wëtmarr k'ʌʌnagjã hich hoopijim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mag hamachig hich hoopibaawai mak'ʌʌnaujã hagjö deeu hewag wëtwi hich hagjö chi hi dʌ̈icha hogdʌba wënʌrraajerr k'ʌʌnag jaauwimajierram haajem. Pari mak'ʌʌn hiekjã bʌ̃ʌrjã hʌ̈k'abajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Maimua hãbmiecharam gaai paawai Jesuu hich k'apeen once hãbam haig t'ach k'ö narr haig bëewia hich hoopijim haajem. Maimua hiyʌ̈ʌmamua hamag meeurrau sĩujim hanaabá. Mag meeurrau sĩutarran, maan hich hiiu p'iidʌwi nʌrrʌm hootarr k'ʌʌnau jaau nʌmjã hamach jʌ̃g t'eegau bʌ̃ʌrjã hʌ̈k'aba harr gaaimuata mag meeurrau sĩujim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Maimua hich Jesuu magjim hanʌm hamag: —Jãimua hërëu p'öbaadëwi Hẽwandamau hõor peerdʌ haaujem hiekta durrpierram magwe t'umaam k'ʌʌnag jaaupetat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chi mʌ hiek hʌ̈k'awi hich pör choopi sim k'ʌ hʌ̈u peerdʌju. Mamʌ chi mʌ hiek jaau nʌm hũr simjã hʌ̈k'aba sim chan Hẽwandamau hi peerdʌ hauba warag hi hisegpʌ̈ijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chi mʌ hiek t'ãraucha hʌ̈k'a nʌm k'ʌʌnau mʌchdëu haajerrjö, mua mʌch juapá deebarmua hõor mor heem mepeerjã höbeerpi jaaubaawai chadcha dau daau höbeerpʌ̈imajugui hajim hanʌm. Magnaa hĩchab deeum meu hich meu k'abamta hag nawe hiek'aajerrjö hiek'aju. ");
INSERT INTO noaH_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nemk'õr benen paraam gaai juau pʌrbaawai k'aak'iinjã bʌ̃ʌrjã chig habaju. Hõor t'õojem pak'ër k'ãijã hõrau döpipʌ̈iwiajã bʌ̃ʌrjã chig habaju; mag nʌm dʌ̈i hĩchab hõor mor masim k'ʌʌn kõit Hẽwandamag jëeunaa ham gaai juadamau pʌrbarmuapai monaaupʌ̈imaju ha jaaujim haajem. Mua pãrag mag nem waupi chirʌmʌn, mag pãachdëu wau nʌm gaaimua hõraujã mʌ hiekta pãrau jaau nʌm k'ap hamk'ĩraugui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesuu hich bʌ̈ hogdʌba haajerr k'ʌʌnag mag jaau haaipabaadeewai hich Hẽwandamaucha maach Pör Jesús hich haar haujim hanaabá, hʌ̃gt'ar. Mag Jesús hʌ̃gt'ar pabaimaawai warre hich Hẽwandam bigaau hi juachaar garta jupimajim haajem, hag nawe hichdëu hamag jaaujerrjö. ");
INSERT INTO noaH_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Magbaawai hi k'apeenau wëtwi chadcha hamachig jaautarrjö durrpierram magwe maach peerdʌajem hiek hõrag jaau wënʌrrajim haajem. Mag hamau jaau wënʌrrʌmpierr hĩchab hich Jesuu ham juag hoojeejim hanaabá, hag na hõrau hooba haajem nempa hamag waupi sim gaaimua. Magʌm gaaimuata hõrau chadcha k'ap'ʌ haajeejim haajem, hamau hi hiekta jaau nʌm.");
INSERT INTO noaH_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teófilo, k'apeer wʌ̈jʌ̈u: Mʌg hẽsap gaai murua pʌrʌg jawaagpam Jesuu hõrag hiek'amatarr dʌ̈i hirua nem waumatarrpa hãba. Pua k'ap'ʌ sim, jũrram k'ʌʌnau hich mʌg hiekpai p'ã hẽk'a nʌm warrpem hirua nem waubaaderr haarmua hirua nem jaaumatarrpa. Maadëu k'ap'ʌ nʌm, magʌm t'um chadcha hajim. Maagwai hõraujã t'um hich hag hiekpai maach hee k'ak'apdö wëjöm, ");
INSERT INTO noaH_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","har warrcha hirua nem waubaaderr hamach daúacha hootarrta hõrag jaaujerr k'ʌʌnau maachigjã jaautarrjö. ");
INSERT INTO noaH_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Maguata muajã hĩchab p'ãju k'ĩirjubaadëjim, pʌ hat'ee. Mamʌ mʌg p'ãju nawe, sĩi año k'apan hi dʌ̈i hãba wënʌrraajerr k'ʌʌn dʌ̈i k'aar haarmua k'ĩeb hö nʌm haar estudie chirʌʌ hawia hĩsta pʌrʌg p'ã deepʌ̈i chirʌm jöoi Teófilo. ");
INSERT INTO noaH_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mʌg murua pʌrʌg p'ã deepʌ̈i chirʌmʌn, pʌchdëu t'ʌ̃rbaawai Jesús higwia hõrau jaau nʌm pua hũurjemʌn chadcharam hiek'au ha k'ap hamk'ĩrau. ");
INSERT INTO noaH_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Murua pʌrʌg jaaum hig chirʌmʌn mʌgau: Herodes Judea durr reik'a sim jaar hĩchab sĩejim haajem p'ad Zacarías ha t'ʌ̃r sim, judionaan heem. Mag Zacarías warrgar p'ad Abías k'ak'itarr dʌ̈i hãba p'adnaan p'idk'aajerr k'ʌʌn chaain hewagam k'ʌʌn dën harr haawai hĩchab Abianaan hajim haajem. Chi Zacarías hʌʌi Elizabed ha t'ʌ̃r sĩejim haajem. Majã hĩchab warrgar p'ad Aarón ha t'ʌ̃ʌrjerr hag chaain hewagam k'ʌʌn k'a hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hich mag jöoi Zacarías hanʌm hich hʌʌi dʌ̈i Hẽwandam dak'ĩir hajap'a wënʌrraajeejim haajem, hi hipierraa. Mag gaaimua hãbmuajã ham hëugar hiek chigaapai hiek'aba haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mamʌ mag wënʌrrʌmjã chi hʌʌi bʌ̃ʌrjã chaai hooba k'itarr haawai chaai hãbjã chuk'u naajim haajem. Mag chaaijã chuk'u nʌmta ya hamach numwe jöoiraa k'it'ëe hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Mag nʌm hee jũrr Abianaanta Hẽwandamag jëeujem deg p'idk'aju seman harr haawai mag jöoi Zacarías hanʌmta hag deg p'idk'a sĩejim haajem, hich k'apeen hich dʌ̈i hãba p'idk'aajerr k'ʌʌnpa, warm k'ʌʌnaujã semanpierr hich mag p'idk'a diichjerrjö. Mamʌ mag p'adnaan k'apan t'ʌnaajerr haawai hed hëepierr hãb jʌr hauwia Hẽwandam hat'eem incienso p'aan duubjeejim hanʌm. Hamach warrgarwejã hich maagjerr haawai mag hedjã mag nʌmua jöoi Zacarías t'ʌ̃rta höbërjim haajem, mag incienso p'aag. ");
INSERT INTO noaH_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mag hich t'ʌ̃rta höbërtarr haawai hierr Hẽwandamag incienso p'aajem hag nasãd wau k'ërʌm haar simich, daaugajãr hamach biirdʌajem haigpaita sĩi hõor pöm Hẽwandamag jëeu k'odt'ʌnaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mag hí hagt'a hierr Hẽwandamag jëeu sim hee, Hẽwandam chogta hʌ̃gt'armua bëewia hi k'ĩirp'ee dʌnʌʌubaichëjim hanʌm, chi incienso p'aajem hag nasãd wau sim bigaau juachaar gar. ");
INSERT INTO noaH_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacariaau mag hoo hat'aawai k'ĩir hëu hawia warag jöoi k'a duuibaadëjim haajem, jãp'ierr nʌm hiek'au. ");
INSERT INTO noaH_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mamʌ magbaawai chi Hẽwandam chogau hirig, —Zacarías, hoob jãp'ierram hajim hanʌm. Pua Hẽwandamag jëeu chitʌʌ haajerr hĩsta hirua pʌ hiek hʌ̈k'abarm: Pʌ hʌʌi Elizabed bi hee pawia pʌrʌg chaai hoo deejugui hajim hanʌm. Mag chaai t'aaba k'ërsiewai pua hi t'ʌ̃rdam Juan ha t'ʌ̃rjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Magbaawain chadau pʌ honee chirsiju. Mag nʌm dʌ̈i hĩchab hõor pöm honee hajurau, hi t'aababarm habarm hamachdëu hũr hat'aawai. ");
INSERT INTO noaH_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mag chaairau bi heewe Hẽwandam Hak'aar hich gaai p'ẽs wai k'itajugui hajim hanʌm. Mag chaairau hich herraawe vinojã döba, ni nag deeum k'ĩir hawia k'ãijã bʌ̃ʌrjã hich hi hee hauba hich mag k'itajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mag chaai jöoipawia Hẽwandam hiek jaaubaadeewaita israelnaan k'apaana hãsie hamach mor k'ĩirjuwia deeu heeupemjö maach Pör Hẽwandam hiek hʌ̈k'ajurau, warrgar hamach jöoinau hʌ̈k'aajerrjö ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hi gaaimuata hõor hee Hẽwandamau hich jua t'eeg hoopijugui hajim hanʌm, warrgar hich hi jaaumie Elías k'ak'itarr dʌ̈i haajerrjö. Hirua Hẽwandam hi jaau nʌrrʌm hũrwia, jöoin hamach chaain dʌ̈i k'ajap k'aba wënʌrraajerr k'ʌʌnjã k'õinaa wënʌrranaa hĩchab hi hiek hũrmap'a haajerr k'ʌʌnaujã hamach jöoin warrgarm k'ʌʌn dënjö hi hipierraa haju, maagwai Hẽwandamau mag ham Pörk'aju päaiwaijã hamach t'ãraucha k'õsi hi hiek hũrmk'ĩir ha jaauchëjim haajem chi Hẽwandam chogau. ");
INSERT INTO noaH_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Magbaawai jöoi Zacariaau, —Mamʌ ¿jãga magbarju? hajim hanʌm, chi Hẽwandam chogag. Ya mʌg mʌ jöoiraa chirʌm, maimua mʌ hʌʌijã hĩchab hũanaa k'itʌmta ¿jãga mag chaai hoobarju? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Magbaa jũrr chi Hẽwandam chogau hirig, —Zacarías, mʌʌn Gabriel ha t'ʌ̃ʌrjemgui hajim hanʌm. Mʌchta Hẽwandam garcha hi bʌ̈k'ʌrr p'idk'aajem. Hichdëu mʌ pʌ̈iwiata pʌ haig mʌ bëejimgui hajim hanʌm, cha mʌchdëu hiek jaau chirʌm jawaan. ");
INSERT INTO noaH_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mamʌ mʌg murua pʌchig jaau chirʌm pʌchdëu hʌ̈k'aba habarm gaaimua, pʌ meu meraa chirsijugui hajim hanʌm, bʌ̃ʌrjã hiek'aba. Maimua ya chi chaai hat'am hedta deeu pʌ hiek heerdʌjugui hajim hanʌm. Murua pʌrʌg mag jaau chirʌmʌn, chadcha t'um mʌchdëu cha jaau chirʌmjöo haju ha jaaumajim haajem, chi Hẽwandam chog hʌ̃gt'armua bëetarrau. ");
INSERT INTO noaH_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Magʌmich daaugajãr hõor pöm Hẽwandamag jëeuwai pos t'ʌnarr k'ʌʌnau hi nʌ nʌmua jũrr hamach k'apeenag, —Keena, ¿jãga habarmta mʌg jöoi Zacarías jãg da höbërchëbáma? hanaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mamʌ mag nʌm hee höbërcheewaijã pöd hõrag hiek'aba, hiek'am hig nʌmjã sĩi juaupaita jajaau haajeejim hanʌm, pöd hiek höbërba haawai. Magbarm haigta k'augaa hap'öbaadëjim hanaabá, Hẽwandamau k'ãijã dau daau hirig hiek'achëwiata mag sĩsim. Maigmua hatag hich mag jöoi meu meraa k'ërsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Maimua hich p'idk'a sĩerr seman t'um höbër hëebaadeewai hich diig petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Maimua mag chi Hẽwandam chogau jaaut'urtarr k'ur chadcha jöpcha Elizabed bi heepajim hanaabá. Mag hich jõorbaadeewai dawagjã höbërba, cinco meses sĩi degpai sĩejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mag degpai simua, “Maach pör Hẽwandamauta mʌʌn heeg hoobarmgui” haajeejim hanʌm. “Chaai chuk'u haawai hõor hee k'ĩir naa hʌrraajerrjã tag mʌ chigag chuk'u hʌrraju. Hʌ̈ucha jãgbarm Hẽwandamau” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Magtarr k'ur seis meses dichwia nʌm hee, Hẽwandamau hʌ̃gt'armua deeu hich chog Gabriel pʌ̈ijim haajem, jũrr Galilea durr p'öbördam Nazaret ha t'ʌ̃r sim hee daupeer hõor meraa k'itʌm María ha t'ʌ̃r sĩerr haar. ");
INSERT INTO noaH_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mag daupeer woun hãb José hanʌm dʌ̈i jua pʌraag ya hiek deewi sĩejim haajem. Mamʌ mag hiek deewi nʌmjã José bʌ̃ʌrjã hagt'a María dʌ̈i k'apes haba naajim haajem. Chi José hanʌm warrgar rey David k'ak'itarr hag chaain hewagam k'ʌʌn dën hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mag hich chogbapäaiwai chi Hẽwandam chog bëewi chi daupeer sim haar dubwia hirig, —¿Jãgpai hʌ María? Honee habá haichëjim hanʌm. Hẽwandamau nem hajap'a haag hʌʌin k'apan t'ʌnʌm hee pʌʌta jʌr hat'am. María, chadcha Hẽwandam maach Pöröu pʌʌta heeg hoobarmgui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mag hũrbaawai k'ĩirju sĩi hawia hich hödegpai “¿Jãgwia hirua mʌrʌg mag hiek'abaichë?” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Magbaawai chi Hẽwandam chogau, —Hoob k'ĩirjum, pʌʌta Hẽwandamau hʌ̈u heeg hoobarbahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pua chaai hemk'ooidam paarpaju. Mag chaai Jesús ha t'ʌ̃rbá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hichta t'umaam k'ʌʌn k'ãai hʌ̃rʌʌcha sĩerraju, maimua hichpai Cha Hʌ̃gt'aa P'uu Nʌm hag Hiewaa ha t'ʌ̃rjugui hajim hanʌm. Maagwai maach Pör Hẽwandamau hirigta israelnaan t'umaam k'ʌʌn Reik'apiju, warrgar pãach jöoin David k'ararrag k'apitarrjö. ");
INSERT INTO noaH_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mag hichta t'umaam k'ʌʌn Pörk'abaadëm haigmua hatag hi jua t'eeg bʌ̃ʌrjã höba, hich mag sĩerraju ha jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Magbaawai Mariaau chi Hẽwandam chogag, —Mamʌ mʌg hagt'a mʌ hõor meraa jaaijã chuk'u hʌmta, ¿jãga magbarjuma? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Magbaawai chi Hẽwandam chogau magjim hanʌm: —Jãan hich Cha Hʌ̃gt'aa P'uu Nʌm hag Hak'aar pʌ gaai sĩeicheewaita pʌ jõorjugui hajim hanʌm, hich hiiu haawai. Mag gaaimua mʌg chaai pua hoobarm bʌ̃ʌrjã k'aibag chuk'u hauwia hich mag k'itaju. Hich Hẽwandamauta hich hiiu pʌ bi hee papi sim dën haawai hi t'ʌ̃r Hẽwandam Hiewaa ha t'ʌ̃rjugui ha jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maimua warag hirig, Pʌdë hũrbá hajim hanʌm, pʌ naamhũan Elizabed hũanaa k'itab mamʌ, hiruajã chaai hemk'ooi paarpajugui hajim hanʌm hĩchab. Hõrau pöd hirua chaai hoobaju haajerrjã ya seis meses simgui hajim hanʌm, bi hee patarr. ");
INSERT INTO noaH_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Hẽwandam hat'ee chan bʌ̃ʌrjã p'it'urm nem chuk'umgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Magbaa Mariaau magjim hanʌm: —Mʌʌn Hẽwandamau nem jawaata hũr hʌmgui hajim hanʌm, hichdëu nem jaaubarmpierr haag. Mag k'ai magan Hẽwandamau cha pua jaau simjö haju haai sim mʌ dʌ̈i hajim hanʌm. Mag jaau pʌawia chi Hẽwandam chog deeu hʌ̃gt'ar petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mag Hẽwandam chogau hichig hiek jaaut'urtarr k'ur k'ãai k'apancha k'aba nʌm hee, Mariaau hich naamhũan Elizabed hoon majim haajem Judea durr, durr dapag hee p'öbördam k'ërʌm hee. ");
INSERT INTO noaH_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mag petawia, jöoi Zacarías di haar barwia, hich naamhũanag, —¿Jãgpai hʌ Elizabed? haimajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mag Mariaau hichig hiek'abaichëm hũrbaawai warre hũan Elizabed bi heem chaaita pogogor k'abaadëjim hanaabá. Magbarm dʌ̈i hich hũan Elizabed gaaijã Hẽwandam Hak'aar p'ẽs haicheewai honegau Mariaag, ");
INSERT INTO noaH_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","—Kadam, pʌchta hãba chadcha hʌʌin k'apan t'ʌnʌm hee Hẽwandamau hʌ̈uhcha habarm; maimua pʌ chaaijã hʌ̈ucha k'itajugui hajim hanʌm, hõor hee Hẽwandam na. ");
INSERT INTO noaH_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","K'anii mʌg mʌ hap'ʌʌ hʌrrʌmua mua k'ap hʌajĩ pʌ maach Pör hãdk'a simua mʌch hoon bëeju. Hʌ̈u pʌ bëejimgui hajim hanʌm María. ");
INSERT INTO noaH_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jãguata pʌ hiek'abaichëm mʌchdëu hũr hat'am dʌ̈i, mʌ chaai hagt'a bi hee k'ërʌmuajã k'aug hat'aawai, t'ʌgdʌdʌ k'abaadëjimgui hajim hanaabá, honegau. ");
INSERT INTO noaH_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","María, Hẽwandam chogau pʌchig jaauchëtarr hiek pʌchdëu hʌ̈k'atarr gaaimua chadcha pʌʌta honee hʌrraju. Maach Pör Hẽwandamau hich chog dʌ̈i pʌrʌg jaaupʌ̈itarr hiek'an t'um hichdëu jaautarrjöo chadcha höbëbërgmajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Magbaawai Mariaau Hẽwandamag jëeumamua magjim haajem: “Hẽwandam, pʌchta hãba maar Pör haawai mʌch t'ãrauchata pʌrʌg hʌ̈u hajim ha hʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mʌ t'ãar honee hʌm Hẽwandam, pʌch maar peerdʌajemuata mʌch dʌ̈i mʌgbarm gaaimua. ");
INSERT INTO noaH_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chadcha puan mʌ dʌ̈i pʌchdëu hampierr haju haai sim. Hõrau hoowai sĩi mʌg maadëu nem higab hʌrrʌmta pua mʌ jʌr hat'am. Pua mʌ dʌ̈i mʌgbarm gaaimua hĩsmua hatag hich mag hõrau mʌ higwia, ‘¡Maagwai jãg hʌʌi honee k'aba hʌabá!’ hajurau. ");
INSERT INTO noaH_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pʌchdëupaita chadcha maar t'um wai dʌnʌm. Pʌchdëu mʌ dʌ̈i mʌgbarm gaaimua hõrau pʌ jua t'eeg k'ap'ʌ nʌisiju. ");
INSERT INTO noaH_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mʌg hatagjã har pʌch hipierraam k'ʌʌnan hich jãg pua ham dau hee haug k'aug paraa chitaju. ");
INSERT INTO noaH_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pʌ jua t'eegjöm k'ʌʌn chan mʌg jẽb gaai hooba haajem. Wir haig hamach t'öo haajerr k'ʌʌnjã ya pʌ jua heegar paauk'abaadëm. ");
INSERT INTO noaH_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mʌg jẽb gaai chi t'et'em t'et'em haajem k'ʌʌnjã hiek t'eeg chuk'u hisegk'ʌʌiwia jũrr hap'ʌʌ maadëu higbajöjöo k'it'ëem k'ʌʌnta pua pör p'iriupʌ̈imaajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hap'ʌʌ jãdaúa durrumjö k'it'ëem k'ʌʌnaujã pʌrʌg jëeuwai pua hamachdëu nem hig nʌm t'um deejem. Mamʌ riknaan, jũrr pua dau haug hee päaijem, pʌch higba nʌm kõit. ");
INSERT INTO noaH_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hẽwandam, pua nawe pʌch hiek'atarr k'ĩir hak'ooba, chadcha hĩsta pʌch chognaan israelnaan hʌ̈u heeg hoogpam, pʌchdëu warrgarwe maar jöoinag jaaujerrjö. ");
INSERT INTO noaH_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nacha jöoi Abranag jaauwai, hi chaain hewagam k'ʌʌn heem hãb t'aababarmuata maar peerdʌ hauju hatarr haawai, hĩs hewag nassi pawiata chadcha hich mag habarm.” Maga hajim haajem Mariaau Hẽwandamag jëeumamua hi t'ö hiek'atarr. ");
INSERT INTO noaH_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mag María hich naamhũan Elizabed hoon mawia hi di haig hed t'ãrjupjö sĩejim haajem. Mag sĩi hawiata deeu hich diig petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mag María hi haig sĩewia petarr k'ur ya hich hauju hed haadeewai hũan Elizabedau chaai chi hemk'ooidam hoojim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mag Hẽwandamau hʌ̈u hi heeg hoowia jõorpitarr chaai hat'am ha hũrbaawai ham dʌ̈i di dak'a naajerr k'ʌʌnau chi Elizabed k'odnaan dʌ̈imua ham haig bëewia hirig, “Hʌ̈uta Hẽwandamau pʌ chaai hoopibarm; pʌ chaai gaaimua maarjã honee nʌmgui” haajeejim hanʌm, jũrr bëe t'ʌnʌm k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Maimua mag hautarr ocho días haadëm hee, deeu chi Elizabed haig hi k'apk'ʌʌn dʌ̈i hi k'odnaanpa bëe t'ʌnʌisijierram haajem, chi chaai mehëudam p'ʌʌrbichpʌ̈i nʌm hoon. Mag bëewi chadcha p'ʌʌrbichpʌ̈ijim haajem. Mamʌ chi chaai t'ʌ̃r chi dënnaanau hagt'a jaauba narr haawai bigaaum k'ʌʌnaun chi chaaidamjã hich haai gaaita Zacarías ha t'ʌ̃rm hig naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamʌ magbaawai chi hãdau, —Hʌ̃hʌ̃, hi t'ʌ̃r chan mag k'abam. Mʌ chaairan Juan hata t'ʌ̃rjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Magbaawai hamachdëu jũrr hirig, —¿K'an jãgwia pua hi mag t'ʌ̃rm hig hʌ? Pãar hee hãbjã mag t'ʌ̃r chuk'u sĩebahab hajierram hanʌm, mag gaai hi t'ʌ̃raag. ");
INSERT INTO noaH_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Magbaawai jũrr chi hayag, —¿Pʌ chaai k'an ha t'ʌ̃r nʌ? ha jëeujierram haajem. Mamʌ mag jöoi meu meraa k'itʌmta kachpa k'ĩ t'ʌnarr haawai, jũrram k'ʌʌnau mag parhooba juau jajaauk'amua hichig jëeu nʌm k'aug hat'aawai, ");
INSERT INTO noaH_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","jũrr hich garmua tabaldam jëeuwia, hag gaai “Hiin Juan hata t'ʌ̃rju” ha p'ãnaa, hamag hoopijim hanaabá. Mag hoopibaawai t'um haig t'ʌnarr k'ʌʌnau hamach hödegpai, “¿K'an hajaug gaaimuata hãba mag gaaita chaai t'ʌ̃rm hig nʌma?” hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mamʌ mag p'ãnaa hirua hoopibarm dʌ̈icha hĩchab hich jöoi Zacarías hiek heerdʌ sĩsijim hanaabá. Magbaawai Hẽwandamag jëeumamua magjim hanʌm: —Hʌ̈uhcha jãg pʌchdëu jaautarrjöo habarm, Hẽwandam. Mʌ hũan chaai t'aabaawaita pua mʌ hiek heerdʌpiju hatarr haawai ya chadcha deeu mʌ hiek heerdʌ chirsim. Hĩsin chadau mʌch meuk'udamaucha pʌrʌg hʌ̈u hajim ha chirʌm Hẽwandam hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","Mag hoobaawai t'um haig narr k'ʌʌnau, “Jãan hich hiiuta jãgpibarm” ha k'ĩirju nʌisijierram hanaabá. Maimua hërëu p'öbaadëwia hamach wënʌrrʌmpierr hamachdëu hoomatarr t'um hich mag jajawag wëtmarr haawai Judea durr hee didam hãhãbdö k'ëk'ëdʌm heem k'ʌʌnaupa k'ak'apdö hich mag sĩi bĩi jöisijim haajem. Mamʌ mag chi jaau wënʌrrʌm k'ʌʌn hiek hũrmam k'ʌʌnau t'umaa k'ĩirjuwia hamach wir haigpai, “Mag chaaidam mʌg hatag jöoipabaadeewai, ¿jãgata k'itajuuta mag jaau nʌma, bʌ̃rʌʌ k'itwe mag nʌm?” haajeejim hanʌm. Mag, hich Hẽwandamau bʌ̃rʌʌwe hich k'õchagpierr bãaupʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hich hag hed hagtarr k'ur nʌʌpai hawia jöoi Zacarías gaai Hẽwandam Hak'aar p'ẽs haicheewai Hẽwandam hi jaaujem k'ʌʌn dënjö hiek'amamua María chaai higwia magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Hẽwandam, hʌ̈uhcha pua pʌch chaain heeg hoowia hĩsin chad maar peerdʌ hawaagpam. Magua maar honee nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Warrgar pʌ chog David k'ak'itarr hag chaain hewagam k'ʌʌn heemta pua chi jua t'ierr maar hat'ee pʌ̈ibapʌ̈im, maar peerdʌ haumk'ĩir, ");
INSERT INTO noaH_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","hich warrgarwe pʌch hi jaaumienau hõrag jaaujerrjö. ");
INSERT INTO noaH_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hamau jaauwai mag ‘Pʌchdëu pʌ̈ibarmuata maar peerdʌ hauju’ haajeejim, ‘t'um maach hoomap'a haajem k'ʌʌn jua heemua, maimua hĩchab chi dajãumie maach k'ũgurwia pekau hee burrpieg hẽk'a sĩerraajem jua heemuajã hagjö.’ Maagjerr hĩsta hʌ̈u hag hed pabaichëmgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","“Hẽwandam, pʌchdëu maar jöoin israelnaan dʌ̈i hiek deetarr bʌ̃ʌrjã k'ĩir hak'ooba, hʌ̈u pua maar dau hee haug k'augbarm. ");
INSERT INTO noaH_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mag hiek deetarr hed pua pʌch hiiucha jöoi Abranag jaauwai, pua maar peerdʌ hauju hajim, ");
INSERT INTO noaH_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","maach hoomap'am k'ʌʌn högk'aba, ni dösãtjã högk'aba, ");
INSERT INTO noaH_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","hãba pʌch dʌ̈ipai hajap'a wënʌrramk'ĩir, tag bʌ̃ʌrjã pekau wau wënʌrram hugua.” ");
INSERT INTO noaH_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mag nacha Mariaau chaai hooju higwia hiek'a dichtarr k'ur jũrr hich chaai higmamuata jöoirau magjim hanʌm: “Hiewaadam, pʌʌta Cha Hʌ̃gt'aa P'uu Nʌm hag hi jaaumie ha t'ʌ̃rju. Puata maach Pör maju hee hi na hõrag, ‘Maach peerdʌajem ya bëeimʌʌ sim’ ha jaaumaju, ya mag jaaubarm hũrwia hõrau hi pierrwai hamach t'ãraucha k'õsi hi hiek hʌ̈k'amk'ĩir; ");
INSERT INTO noaH_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","maimua hamag maach peerdʌajem hiek jaaubaawai hamach k'aibag t'umaa hãsie hewag k'ĩirjuwia Hẽwandamag chugpaapi jëeumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Magaag hat'eeta Hẽwandamau maach t'umaam k'ʌʌn k'ĩir jãsenk'awia hich Chaai pʌ̈i sim, peerdʌju k'augba haawai pöd hʌ̃gt'ar höbërbaju haajerr k'ʌʌnpa peerdʌ haumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mag hamach peerdʌju pierrum k'ap'ʌ haadëmʌn, sĩi hõor k'ĩchag hee nʌmjö nʌm k'ʌʌnau hãspa hurum k'aug hat'amjö warag hãspapiwia k'ʌd chaar hee paauk'abaadëmjö Hẽwandam dʌ̈i k'õinaa wënʌrraju.” Ma hajim haajem jöoi Zacariaau hich hiek heerdʌtarr hed hiek'atarr. ");
INSERT INTO noaH_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Maimua chi Juandam bãaumam dʌ̈i Hẽwandamau hich Hak'aarta hi gaai p'ẽs deejim hanaabá, hich dʌ̈i hubʌ nʌrrʌmua hich hiek jaau k'aug hamk'ĩir. Jöoipawia, hich hap hõor chukag hee warp mawia sĩejeejim haajem. Maimua Hẽwandamau hich hiek Israelpienag hũrpiju hed haadeewaita chi Juanau hõrag jaaubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mag Juan t'aaba nʌm jaar ya hĩchab Mariajã pömcha waaurba sĩejim haajem, Jesús gaai. Mag nʌm hee chi rey César Augustoou hich t'et'em k'ʌʌnag jaaujim haajem, jũrr mak'ʌʌnau hichdëu durr jʌ̃a sim hee hõor nʌnʌidʌmpierr jaaubaa hamach t'ʌ̃r p'ãk'api mamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mag hõor t'ʌ̃r p'ãk'atarr warrpem hajim haajem, Cirenio hanʌm Siria durr gobernadork'a sim jaar. ");
INSERT INTO noaH_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mag hiek haaidʌ nʌm jaar jaautarrjö, t'umaam k'ʌʌn hamach jöoin p'öbörpierr wëtjierram hanaabá, hamach t'ʌ̃r p'ãk'amk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Magua Josejã hĩchab hich jöoin p'öbör hee majim haajem, hich t'ʌ̃r p'ãmk'ĩir. Hich José Galilea durr joobaajeejim hanʌm, p'öbör Nazaret hanʌm hee. Mamʌ jöoingarm rey David k'ak'itarr hag chaain hewagam k'ʌʌn dën harr haawai chi David t'aabatarr p'öbör Belén hanʌmʌgta majim hanaabá, Judea durr. ");
INSERT INTO noaH_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mag hich mam dʌ̈i María harrjim haajem, hag nawe hiek deewia jua pʌrju hanarr haawai. Maagwai María ya hauwimʌʌ sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mag wëtwia, Belén bardʌtk'aimawia, k'ãai k'apan k'aba nʌm hee María chaai haujim haajem, warrpemdam. ");
INSERT INTO noaH_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mamʌ hamach jẽraag di hajap'amjã baauba sĩi p'ak k'ãaijem degta narr haawai putdam hee pʌrëunaa p'ak t'ak'aar sẽejemdam hut'ur k'ërʌm heeta werba k'ërjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mag chaai t'aababarm dak'a p'ʌʌrsã sim hee hõor naajim haajem, hedaar hamach oveja t'ʌa nʌm k'ʌʌn. ");
INSERT INTO noaH_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mag hamach nemchaain t'ʌa nʌmta, dëgölp p'ʌr jẽer hat'am dʌ̈i harar jöi sim hee, Hẽwandam chog hich Jöoirau pʌ̈itarrta ham k'ĩirp'ee barjopbaichëjim hanaabá. Mag hoobaawai jãp'ierr p'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Magbaa chi Hẽwandam chogau hamag, —Hoob jãp'ierrmiet. Mʌʌn sĩi pãrag hiek hajap'am jawaanta bëejimgui hajim hanʌm. Mʌg murua pãrag hiek jaaubarmua pãar israelnaan t'um honee hajurau, pãachdëu hũrmampierr. Murua pãrag hiek jawaan bëetarran mʌgaugui hajim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hĩsta Belén p'öbör hee chaai t'aababarm, warrgarwe hõor t'umaam k'ʌʌnau nʌajerr Chaai. Mʌg chaairauta mʌg hatag hõor peerdʌ haujugui hajim hanʌm. Hichta Cristoou maach Pör. ");
INSERT INTO noaH_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mʌch sëuk'a chirʌm ham hugua, nauwe hërëubaadët hajim hanʌm, Belén p'öbörög. Mam barbaimaawai chi chaaidam putdam hee pʌrëunaa p'ak t'ak'aar sẽejem hut'ur k'itʌm hee hauk'ërʌm pãrau hooimaju ha jaaujim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chi Hẽwandam chogau mag jaaubarm hee, hi k'apeen hijöm k'ʌʌn k'apan hedjã hee pʌʌrt'ʌbaichëjim hanaabá, sëuk'abarmjö habarm hee. Magbaawai mak'ʌʌnau Hẽwandamag jëeu nʌmua, ");
INSERT INTO noaH_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hẽwandam, hʌ̈u habarm hʌ̃gt'arm magwe. Hʌ̈u pua pʌch Hiewaa pʌ̈ibarmgui” hanaajim hanʌm. “Mʌg pʌchdëu hi pʌ̈ibarm gaaimua mʌg durr jöoi gaaijã pʌchdëu jʌr haumam k'ʌʌnan pʌ dʌ̈i k'õinaa wënʌrraju” hanaajim hanaabá, Hẽwandamag jëeumamua. ");
INSERT INTO noaH_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mag t'ʌnʌʌ hawia chi Hẽwandam chognaan deeu hʌ̃gt'ar hërëubaadeewai chi nemchaain t'ʌa narr k'ʌʌnau jũrr wir haigpai hamach k'apeenag, —Keena, magan Belenag wëttarrau hajim hanʌm, Hẽwandam chogau jaauwai mag chaaidam heeu hau k'itʌm hanʌm hoon. ");
INSERT INTO noaH_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mag wëttarrau hawia, chadcha heerpamjö hërëuwia hooimaawai, chadcha chi chaaidam hewaa hau k'itʌm p'ak t'ak'aar sẽejem hee hauk'ërʌm hooimajierram hanaabá. Maig hi bigaau chi hãd José dʌ̈i naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mag hamach daúa hoobaimaawai chi Hẽwandam chogau hamachig jaautarr t'um jũrr hamag hĩgk'aimajierram hanʌm. Mag jaauwia, höbërwia, deeu hamach nemchaain haar wëtumuajã hamachdëu hõor hoomampierr hich mag jajawag wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mag chi oveja t'ʌamienau nem hĩgk'ak'ag wëtum hũrwia t'um chi hũrmarr k'ʌʌn jʌ̃gderraa nʌisijim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mamʌ mag hamau jaau nʌm hũrtarr t'um Mariaau k'ap'ʌ sĩerrjã bʌ̃ʌrjã bĩi haba, hich t'ãar heepai hich mag k'ap'ʌ wai sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mag chi nemchaain t'ʌamienau hamach daúacha hoonaa hamach jʌ̃gʌucha hũrtarrpa hig wëtumua, honee Hẽwandam t'ö hiek'ak'ag wëtumua, “Hẽwandam, hĩsin chadau purua hʌ̈u habarm. Pʌjö wajaugk'am chan hõor chuk'um” ha serereug wëtwia deeu hamach nemchaain haar p'ʌʌrsã hee naaimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chi chaai hautarr ocho días haadëm hee, jöoingarwe hamach hi harr haawai nacha hi mehëudam p'ʌʌrbichpʌ̈iwia warre hi t'ʌ̃rdam Jesús ha t'ʌ̃rjierram haajem, chi Hẽwandam chogau warrcha Mariaag jaaucheewai t'ʌ̃rju ha jaautarrjö. ");
INSERT INTO noaH_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maimua hĩchab magtarr k'ur hed hãbjö haadëm hee, Jerusalén p'öbör hee Haai hi jëeujem deg chi Jesudam haibëejierram haajem p'adëg hoopien, Moiseeu Hẽwandam hiek p'ãtarr gaai jaau simjö hag hipierr. Mag haibëewia Hẽwandamag hi kõit hʌ̈u hajim hanaa warag hirig jëeumamua, “Hẽwandam, cha k'ërʌm maar chaaidam; puata hi k'ap chirʌm mʌg hatagjã. Hi dʌ̈i pʌchdëu hampierr habá” hajierram hanʌm, “pʌchigpai k'ĩirju bãaumk'ĩir.” Mag hamau jëeutarran hamach chaai Hẽwandamag deeg hajim, warrgar Moiseeu jaautarrjö. ");
INSERT INTO noaH_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mag Moisés hiek gaai Hẽwandamau mag sim: “T'um hemk'öi chaai chi nacha hoomamdam pãrau mʌrʌg deemaju.” ");
INSERT INTO noaH_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maimua hĩchab, “Jãbauk'itʌm wa dubur chaaindam k'ãijã dau numí deebat” ha sim “hag chaai paar.” Maagjerr haawai chadcha duburdam k'ëchwia chi chaai Hẽwandamag dee nʌm hanʌmua hi kõit jëeujierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Maagwai Jerusalén p'öbör hee woun hãb Simeón ha t'ʌ̃r sim sĩejim haajem, Hẽwandam dau na hajap'a k'itanaa hi hipierraa k'itaajerr. Hich mag jöoirau hĩchab nʌajeejim haajem, warrgarwe Hẽwandamau jöoinag jaauwai hirua hich Chaai pʌ̈ibarmuata israelnaan peerdʌ hauju ha jaaujerr Chaai. Mag jöoi gaai Hẽwandamau hich Hak'aar p'ẽs wai sĩejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Magua hich mag Hẽwandam Hak'arau hichig jaautarr haawai jöoi Simeonau k'ap'ʌ sĩejim haajem, hich daúacha hooju maach Pör Hẽwandamau mʌg jẽb gaai Cristota Reik'amk'ĩir pʌ̈iju ha jaaujerr. ");
INSERT INTO noaH_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Magtarr haawai mag chi Jesudam Haai hi jëeujem deg wai nʌm hedcha hich mag jöoi Simeón hanʌmjã hĩchab hich Hẽwandam Hak'arau hagʌg hi harrjim haajem. Mag José María dʌ̈imua jöoingarwe Moiseeu hiek p'ã pʌatarr gaai jaaujemjö chaai dʌ̈i haag Haai hi jëeujem deg bardʌtk'abaimaawai, ");
INSERT INTO noaH_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","hich mag jöoi Simeonau chi chaaidam jiir hauwia Hẽwandam t'ö hiek'amamua, ");
INSERT INTO noaH_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Hẽwandam, mʌʌn pʌ chogau” hajim hanʌm, “maagwai pʌ mʌ Pöröu; ");
INSERT INTO noaH_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","hĩsin chad ya pʌch haar mʌ hauju haai chirʌmgui” hajim hanʌm, “pʌ haar k'õinaa chiraimaag. Pʌchdëu nawe mʌrʌg hoopiju ha jaaujerr ya chadcha mʌch daúacha hoobarmgui” hajim hanʌm. “Mʌg chaairauta jöoipaawai hõor peerdʌ hauju. ");
INSERT INTO noaH_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Chadcha mʌg chaai hõor t'umaam k'ʌʌn hat'eeta pua pʌ̈ibarm. ");
INSERT INTO noaH_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mag, hi gaaimuata durr chaauram k'ʌʌnaujã Israelpien t'ö hiyʌ̈ʌ hajurau. Maimua hi jöoipa sĩsiewai hĩchab Israelpien k'abam k'ʌʌn hat'eejã hõtdaujö sĩsiju, hamachdëu jãga hamjã peerdʌju haai nʌ ha k'ap hamk'ĩir” ha hiek'amajim hanʌm jöoyau. ");
INSERT INTO noaH_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mag chaaidam bʌ̃rʌʌ k'itʌmta jöoipa k'ërsiewai, jãgata hõor heejã sĩerraju k'ai ha t'umaa jaaubarm hũrbaawai, hamach happai, “Maach chaai ¿jãgata k'itajuuta, bʌ̃rʌʌ k'itwe mag jaau nʌma?” hajierram hanʌm chi dënnaanau. ");
INSERT INTO noaH_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Maimua Simeonau chi dënnaanagta jũrr, —Pãach numwe Hẽwandamau pãar mʌg hatagjã hʌ̈u wai nʌisijugui hajim hanʌm. Magnaa chi hãdagcha, María, Hẽwandamau mʌg hich Hiewaa pʌ̈ibarm gaaimua, chadcha mʌg Israel durram k'ʌʌn pöm hʌ̃gt'ar höbërjugui hajim hanʌm. Mamʌ hĩchab Israel durram k'ʌʌnaupai hi hoomap'am hiek'au hamach jãrr hi p'ʌʌr t'uur hauju. Pʌch chaai mag dau hap'ʌʌ wai nʌm hoobaawai pʌchta t'ut'uíu t'oopbapʌ̈imjö hap'ʌʌ hi hat'ee pʌ bĩe hʌrrajugui hajim hanʌm, gaai machgau. Mag hi hap'ʌʌ wai nʌm haigta merag chuk'u hajugui hajim hanʌm, chijã k'ʌʌnauta hi k'õsi haju maimua chijã k'ʌʌnauta hi hoomap'a k'ãijã haju ha jaaumajim haajem hich chi hãdagcha. ");
INSERT INTO noaH_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Maig hĩchab hũan Ana hanʌmjã sĩejim haajem, hagjö Hẽwandam hi jaaumie. Mag Ana hapk'ʌ̃ʌ jöoi Fanuel k'ararr hag k'a hajim haajem. Maagwai hich jöoi Fanuel hanʌm warr jöoingar Asernaan ha t'ʌ̃ʌrjerr k'ʌʌn heem hajim haajem. Mag hũan Ana warrpem hich jaai hautarr dʌ̈i siete añospai nʌm hee k'oopawia hich mag tag jaaijã hauba k'itʌmua ya hũanaa k'itajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mag hũanaa ochenta y cuatro años k'itʌmjã chawag maba, hedaram magwe Haai hi jëeujem degpaita sĩejeejim haajem, sʌrk'a simua Hẽwandamag jëwaag. ");
INSERT INTO noaH_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mag hagt'a María hich chaai dʌ̈i Haai hi jëeujem deg nʌm hee, mag hũan Ana hanʌmjã bëewi Hẽwandamau hich Chaai pʌ̈itarr k'aug hat'aawai hirig, “Hʌ̈u hajim Hẽwandam; purua maar peerdʌ hawaag pʌ̈iju haajerr chaai barbaicheewai mʌ honee hʌmgui” hajim hanʌm. Magnaa mag hich Hẽwandamaucha pʌ̈iju ha jaautarr hĩchab nʌajerr k'ʌʌnag chi chaaidam higwia, “Hich Hẽwandamau jaautarrjö chamʌguata mʌg hatag maach peerdʌ hauju hag Chaaidamauwai” haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Maimua Hẽwandamau hich hiek Moiseeg p'ãpitarr gaai jaau sim hipierraa t'um wau dichdimaawai deeu hamach Nazaret p'öbörög bëejierram haajem, Galilea durr. ");
INSERT INTO noaH_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mag chaai hich dʌ̈rrpapagmampierr warag k'ĩirjug k'ap'ʌ pamajim hanaabá. Mag nʌm dʌ̈i hich Hẽwandamau hich k'õchagpierrta bãaupijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús dënnaan añopierr Jerusalenag weetjeejim haajem, nemk'oo pömaam jaar paawai. ");
INSERT INTO noaH_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mag añopierr weetjerr haawai, Jesús doce años haadeewai, hĩchab Jerusalenag majim haajem, hich dënnaan dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Maimua chi nemk'oo dichdimaawai hõor pöm hamach durrag hërërëuk'am hee, hĩchab José María dʌ̈i hamach p'öbörög wëtjim haajem. Mamʌ Jesús ham dʌ̈i maba, t'ʌba sĩsijim hanaabá. Mamʌ hi t'ʌbabarmjã chi jöoinau k'augbajierram haajem, deeum k'ʌʌn dʌ̈i hurumpii hawia. ");
INSERT INTO noaH_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","45","Mag deeum k'ʌʌn dʌ̈i hõor k'apanag hee hurumpii hawiata hich mag k'ãaim hãb wënʌrra k'ëumamua hi jʌʌrjeejim hanʌm. Mamʌ hamach k'odnaanag jëeuwia hamach k'ap k'ʌʌnagjã jëeuk'a hohook'am hooba habaawai hag noram deeu hewag bëejierram hanaabá, hi jʌr wëdurumua. ");
INSERT INTO noaH_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hich hag hed k'eeuraa Jerusalén barchëjierram haajem. Maimua hag noram hãspaau jʌrp'öbaadeeuta Haai hi jëeujem deg Hẽwandam hiek jawaag chi machnaan dʌ̈ita Hẽwandam hiek hiigwai hiyʌ̈ʌ hoo sim hooimajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Maagwai haig t'um chi hũr narr k'ʌʌn jʌ̃gderraa t'ʌnaajim haajem, chi machnaanau jëeumam chaairauta ham dënjö nem k'aug ham hiek hʌ̈k'apʌ̈pʌ̈igmam hũrwia. ");
INSERT INTO noaH_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mag chi machnaan jãrr sim hoobaicheewai, chi jöoinau hamach wir haigpai, —¡Mʌgah! Pʌdë hoobá, mʌigta sĩebma hajierram hanʌm. Magbaawai chi hãdau magjim hanʌm hich chaairag: —¿K'ant'eeta mʌgcha maar p'it'urg waupibarma? Pʌ jʌr wënʌrrʌmua marau pʌ k'ĩirju nʌʌ hajimwai hajim hanʌm, hich chaairag. ");
INSERT INTO noaH_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Magbaawai chi chaairau hamag magjim hanʌm: —¿Pãrau k'augbata nʌ, mʌ mʌig mʌch Haai hiek hõor dʌ̈i hig hiyʌ̈ʌ chiraju haai chirʌm? ");
INSERT INTO noaH_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mamʌ chi chaairau hamachig mag hiek'abarm chi jöoinau pöd k'augba, parhoobata hũrpʌ̈ijierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Maimua hich dënnaan dʌ̈i höbërwia hãba hamach p'öbör Nazareeg wëtjim haajem. Maimua hewag pawiajã hich dënnaan hipierraa hich mag k'itajim hanaabá. Mamʌ hich chaairau mamagk'amjã Mariaau hich t'ãar heepain t'um k'app'ʌ haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mag nʌm hee warag Jesús dʌ̈rrpamampierr hĩchab k'ĩirjug k'aug pamajim hanaabá. Maagwaita Hẽwandam dau na hagchanaa hĩchab hõor heejã k'ajapp'a nʌrraajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Woun Tiberio hanʌm reik'abaaderr haigmua quince años haadëm hee, gobernadornaan jayap naajim haajem: Judea durr: Poncio Pilato Galilea durr: Herodes Iturea durr Traconite durr dʌ̈i: Felipe (Herodes naam, haai gaaimua) Abilinia durr: Lisanias ");
INSERT INTO noaH_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mak'ʌʌn chi gobernadornaank'a nʌm jaar hĩchab p'adnaan pörk'a narr k'ʌʌn Anás hajim haajem Caifás dʌ̈i. Hich mag jaarta hĩchab Hẽwandamau jöoi Zacarías hiewaa Juan hõor chukag hee sĩerrag jaaujim haajem, hich hiek hõor hee jajawag mamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Hẽwandamau hichig mag jaaubaawai chadcha petawia döjã Jordán higaau k'ĩeb jajawagmamua maagjeejim hanʌm: “Pãar pekau pöoma naawai pãach k'aibag hãsie hewag k'ĩirjuwia Hẽwandamag chugpaapi jëeubat. Mag jëeubaa Hẽwandamau pãach k'aibag chugpaabapäaiwaita mua pãar pör choopʌ̈imajugui” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hi mag nʌrraju higwia warrgarwe Hẽwandam hi jaaumie Isaías ha t'ʌ̃ʌrjerrau mʌg p'ã pʌajim: “Woun hãb hajappai hõor barba haajem haar sĩejemuata hich haar hõor barbaimaawai, ‘Maach Pör ya bëeimʌʌ sim’ haju. ‘Hi bëeju nawe pãach t'ãar k'ĩir k'augbat’ haju, ‘t'ãraucha k'õsi hi hiek hʌ̈k'aag. ");
INSERT INTO noaH_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pari mag hʌ̈k'aagan pãach k'aibagau pãach t'ãar jãg sĩi durr dapag heem dö k'õrgjö hãk'ãrag sĩsidʌmjã jẽb dau dʌ̈ii paa nʌmjö hajaug paapʌ̈ipetat’ haju. ‘Pãach k'ĩirjug k'ʌd jũjũrk'imjö sĩsidʌmjã k'ʌd k'ajap'a wʌʌinaa bubuchdög dau dʌ̈ii jiirt'ẽubapʌ̈imjö habat’ haju. ");
INSERT INTO noaH_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mag t'um hajaug paapʌ̈iwia k'ĩir k'aug nʌisiewain chadau Hẽwandamau maach peerdʌju pʌ̈ibarm t'umaam k'ʌʌnau k'ĩircha hooju” ha p'ã sim. Hich mag Juanau maach t'ãarta k'ʌd wʌʌi nʌmjö waupi jaau nʌrrarran, warrgarwejã hirua mag jaau nʌrraju ya chi p'ãm harr haawaita nassi pawi chadcha mag jaau nʌrrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mag hũrwia hirig hamach pör choomk'ĩir hõor pöm bëe t'ʌnʌm k'ʌʌnag maagjeejim hanʌm hichdëu: —Chi k'aibagnaan, ¿k'aíu pãrag jaauwai Hẽwandamau maach hi hagk'am hed sĩi pör chootarr gaaimuapaita pãar hi jua machag hãwatbaju ha jaaujĩ? ");
INSERT INTO noaH_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sĩi pãach pör choopi nʌmuapai chan hirua pãar haubam. Hẽwandam jua machgau dau hap'ʌʌ hamap'a nʌm k'ai, pãach k'aibag t'umaa hãsie hewag k'ĩirjuwia, Hẽwandamag hisegpi jëeuwia, chadcha Hẽwandam hiek hʌ̈k'aajem k'ʌʌnjö habat hajim hanʌm, pãach k'apeen dʌ̈ijã. Hoob pãrau chik'amnaan dënjö, pãachjã warrgar pãach jöoi Abrán k'ararrjö Hẽwandam dʌ̈i k'apeerk'a nʌm hawi, “Maran Abrán chaainau; mag hi chaaink'a nʌmta, ¿jãga Hẽwandamau mag maar dau hap'ʌʌ hapibarju?” ha k'ĩirjumiet. Sĩi mag Abrán chaaink'a nʌm gaaimuapaita mag hʌ̃gt'ar höbeerjem hak'iin, mokdau mʌg t'ʌnʌmjã Hẽwandamau hõrag paapʌ̈iwia mak'ʌʌnjã hĩchab Abrán chaainau haju haai sim. Abrán chaai chaar hawiajã hichiita Hẽwandam jua machag hãwatab k'aba hãwatju. Mag k'õch k'aba nʌm k'ai, pãach k'aibagta warre Hẽwandamag hisegpi jëeubat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pãrau k'ap'ʌ naabá, nemjĩir k'aigbamʌn t'u wërpmaajem. Hich hagjöta simgui hajim hanʌm hĩchab Hẽwandamaujã pãar dʌ̈i. Ya hirua pãar chachimʌʌ sim. Har hõor hamach k'aibag hisegwia Hẽwandamag chugpaapi jëeuba nʌm k'ʌʌnan pa t'upʌ̈iwia jʌser haadee hörpʌ̈i nʌmjöta hajugui hajim hanʌm, hich Hẽwandamau ham dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mag jaaumam hũrwia, hõrau hirig —¿Magan maraujã jãga haju haai nʌ, Hẽwandam jua machag hãwatmaaugau? ha jëeujierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Magbaa hichdëu magjim hanʌm hamag: —K'ajũa t'eg jũaju paraa nʌm k'ʌʌnau bʌ̃ʌrjã jũaju chuk'u k'it'ëem k'ʌʌnag deepetat. Maagwai hagjö nem k'oojemdam wai nʌm k'ʌʌnau hĩchab chuk'um k'ʌʌn dʌ̈i jig k'öbat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Maig hĩchab bëejierram haajem gobierno dën dëbpaar jëeujem k'ʌʌn, hagjö hamach pör choopʌ̈imamk'ĩir. Mag bëewia mak'ʌʌnaujã hirig jëeumamua, —Maestro, maraujã ¿jãga haju haai nʌ? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Magbaawai hichdëu hamag, —Hoob leíu jaau sim k'ãyau hat'uucha hõor jua heem p'atk'on jëeumiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Maimua jũrr soldaaun bëewia, mak'ʌʌnaujã hirig, —Magbaa maraujã ¿jãgajuma? haichëjierram hanʌm. Magbaa hich Juanau magjim hanʌm chi soldaaunag: —Hoob tag chik'am jua heem nem hajués k'echt'ʌg haumiet. Wa pãachta hemk'ooin hawia chik'am k'ũgur jãp'ierrpinaa k'ãijã chik'am p'atk'ondam hau chit'ëe hamiet. Maimua hoob pãrau, “Mʌrʌgan bʌ̃rʌʌta p'aagjem, muan waragta hig chirʌm” hamiet hajim hanʌm. Pãachig p'ag nʌmdam dʌ̈ipai honee nʌisit ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mamagk'am hũrwia, hõrau jũrr hamach k'apeenag, “Hĩsin hich mʌ k'ãijãa Hẽwandamau nawe pʌ̈iju ha jaaujerrá hagam” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hamau mag hiek'a nʌm Juanau hag nawe hũr wai sĩerr haawai t'umaam k'ʌʌn jʌ̃g daar magjim hanʌm: —Mua pöd pãar t'ãar hajaug paa haubam. Muan sĩi dödamaupaita pãar pör choo chirʌmgui hajim hanʌm. Mamʌ hẽudee hãb hurumta mʌ k'ãyaujã jua t'eeg hʌ̃rcha sim. Jãguan chad hich Hak'aarjã pãrag deewia pãar k'aibagjã hõtdau hee warre hörbapʌ̈imjöta haju. Mʌ chan mʌg chirʌm haig sĩi hi chogk'aagpaijã serbiibata chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Magnaa hamag, K'ĩir k'ap'ʌ habat, Hẽwandaman ya bëeimʌʌ simgui hajim hanʌm. Hi bëem hed hi hiek hʌ̈k'a nʌm k'ʌʌnan arrozdö pöm wëjorr p'ierrwia hajap'a hãk'a t'ʌnʌʌubarmjöta haju. Maagwai har hi hiek hʌ̈k'amap'a harr k'ʌʌn, jũrr chi arroz bʌ̈ t'ʌʌtarrta sĩi hãbamʌg päardʌnaa hörbapʌ̈imjö haju. Mak'ʌʌnan bʌ̃ʌrjã hõtdau t'õo k'augba sĩerrʌm heeta hich Hẽwandamaucha bark'ʌʌipʌ̈iju ha jaaujeejim hanʌm, Juanau hich haig bëe nʌm k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mag jaautarr haigmuajã hich mag hiek k'ĩir pogk'e jaau k'itʌmua hõor wawiejeejim hanaabá, jãga t'umaam k'ʌʌn Hẽwandamau peerdʌ hauju haai sĩ. ");
INSERT INTO noaH_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Mag jaar chi gobernador Herodeeu hich naam Felipe hʌʌi Herodías hanʌm k'echeu hauwia hag dʌ̈i sim k'aug hat'aawai Juanau hirig hiek'ajim haajem. Mamʌ mag hirig hiek'atarr chan mag sĩi hich wach hʌʌi dʌ̈i sim hat'eepaijã k'aba, hich nem parhooba k'aigba waaujem kõitpata hirig hiek'ajim hanaabá. Mamʌ magʌmjã bʌ̃ʌrjã hi hiek hũrba, warag chi Herodeeu Juan cárcel deg p'ãar sĩupijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mamʌ mag Herodeeu chi Juan cárcel deg p'ãarpiju nawejã hõor pöm pör choojerr haawai, k'ãai hãb Jesujã bëewia Juanag hich pör choopibaawai, hĩchab hi pör choopʌ̈ijim haajem. Mag hich pör choo haaipabaadeewai Hẽwandamag jëeujim hanaabá. Mag hich Hayag jëeu sim heeta hedaujã weeudʌ jöisim heemua ");
INSERT INTO noaH_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Hẽwandam Hak'aar duburjö k'itʌmta dau daau bëewia hi hʌ̃r jupchëjim hanʌm. Mag jupbaichëm dʌ̈i hedjã heemua woun hiekjö, “Hiewaa, pʌʌta mʌ Chaai mʌchdëu jãsehne wai chitʌmʌu, pʌ gaaimua mʌ honee chiraajem” habarmjã hũrjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuu warrpem Hẽwandam hiek hõrag jaauwai treinta añosjö sĩejim haajem. Hiin Hẽwandam Hiewaa hajieb mamʌ, hõraun José hiewaa chaarpii haajeejim. Hich Jesús bãaurrjöoi Joseeta Elí hiewaa hajim haajem. Maagwai Elí Matat hiewaa hajim; ");
INSERT INTO noaH_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat Leví hiewaa; Leví Melqui hiewaa; Melqui Jana hiewaa; Jana José hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías hiewaa; Matatías Amós hiewaa; Amós Nahúm hiewaa; Nahúm Esli hiewaa; Esli Nagai hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat hiewaa; Maat Matatías hiewaa; Matatías Semei hiewaa; Semei Josec hiewaa; Josec Judá hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanán hiewaa; Joanán Resa hiewaa; Resa Zorobabel hiewaa; Zorobabel Salatiel hiewaa; Salatiel Neri hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui hiewaa; Melqui Adi hiewaa; Adi Cosam hiewaa; Cosam Elmadam hiewaa; Elmadam Er hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Jesús hiewaa; Jesús Eliezer hiewaa; Eliezer Jorim hiewaa; Jorim Matat hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví hiewaa; Leví Simeón hiewaa; Simeón Judá hiewaa; Judá José hiewaa; José Jonam hiewaa; Jonam Eliaquim hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea hiewaa; Melea Mena hiewaa; Mena Matata hiewaa; Matata Natán hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David hiewaa; David Isaí hiewaa; Isaí Obed hiewaa; Obed Booz hiewaa; Booz Sala hiewaa; Sala Naasón hiewaa; Naasón Aminadab hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab Admin hiewaa; Admin Arni hiewaa; Arni Esrom hiewaa; Esrom Fares hiewaa; Fares Judá hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacob hiewaa; Jacob Isá hiewaa; Isá Abrán hiewaa; Abrán Taré hiewaa; Taré Nacor hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug hiewaa; Serug Ragau hiewaa; Ragau Peleg hiewaa; Peleg Heber hiewaa; Heber Sala hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán hiewaa; Cainán Arfaxad hiewaa; Arfaxad Sem hiewaa; Sem Noé hiewaa; Noé Lamec hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalén hiewaa; Matusalén Enoc hiewaa; Enoc Jared hiewaa; Jared Mahalaleel hiewaa; Mahalaleel Cainán hiewaa; ");
INSERT INTO noaH_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enós hiewaa; Enós Set hiewaa; Set Adán hiewaa; Adán Hẽwandam hiewaa, hich Hẽwandamaucha hi homparr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mag pör choowia Jesús Hẽwandam Hak'aar hich gaai p'ẽs wai sim petajim haajem Jordán heemua, mag hich pör chootarr haigmua. Mag mamta hich hag Hẽwandam Hak'araupai Jordán higaau durr hõor chukag chʌʌi hi warrjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mam cuarenta días sĩejim haajem, bʌ̃ʌrjã t'ach k'öba. Hi mag sim hee dösãtau bëewia hi k'ĩirjug meerk'a Jöoi dau na hʌ̈u k'abam nem waupiju hẽk'aajeejim hanaabá. Mag cuarenta días dichdimaawaita heeupemjö Jesús jãsöo haadëjim haajem. Mag hi jãsöo haadëm hee, dösãtau hi k'ũgur hauju k'ĩirjuwia ");
INSERT INTO noaH_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","hirig, —Chadcha pʌ Hẽwandam Hiewaa k'ai, mʌg mokdau panag paabapʌ̈i hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Magbaawai Jesuu magjim hanʌm: —Hẽwandam hiek p'ã sim gaai jaauwai, “Sĩi t'ach k'öju happai k'ap hamk'ĩir hirua maach hompaabajim” ha sim. “Hirua maach hompaatarran, mag t'ach happai k'ĩirjuju k'ãyau hich hipierraa wënʌrramk'ĩirta maach hompaajim” ha p'ã simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Maimua Hẽwandamau hʌdʌraa warag dösãtag Jesús warrpijim haajem, durrsĩ pöm sim gaai. Mag warrwia mag durr pöm hʌ̃gt'aa sim gaaimuapai, sëuk'abarmjö habarm hee, mʌg jẽb gayam durr warp'am magwe t'um hirig hoopijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mag hoopiwia magjim hanʌm, chi dösãt garmua hirig: —Mua pʌrʌgta durr mʌg wëjöm dʌ̈i hag gaai nem t'ʌnʌmpa t'um deejugui hajim hanʌm, pʌchta t'umaam k'ʌʌn pörk'anaa t'ʌ̃rp'öo chirsimk'ĩir. Mua mʌchdëu deem k'õsim k'ʌʌnag deeju haai chirʌmgui hajim hanʌm, mʌch dën haawai. ");
INSERT INTO noaH_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mamʌ magaagan sĩi jĩepöröu p'õbk'anaa mʌrʌgta Hẽwandamagamjö jëeubá hajim hanaabá. Pua mʌrʌg mag jëeumʌn, mʌg durr t'umwe pʌch dënëu hajim hanʌm chi dösãtau. ");
INSERT INTO noaH_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Magbaawai Jesuu chi dösãtag, —Hẽwandam hiek p'ã sim gaai jaauwai, “Pãar Pörön Hẽwandamau; hãba hirigpaita jëeubat, maimua hãba hi hiekpaita hipierraa habat” ha simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Maimua Hẽwandamau deeu hʌdʌraa dösãtag Jesús warrpijim haajem, jũrr Jerusalén p'öbörög. Mam barwia Haai hi jëeujem di nem pöm dʌnʌm hʌ̃r chi sĩ gaai warrwia magjim hanʌm chi dösãt garmua Jesuug: —Pʌ chadcha Hẽwandam Hiewaa k'ai, magan mʌg hee baubaad hajim hanʌm. Pʌ chig haba k'abahab. ");
INSERT INTO noaH_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Hẽwandam hiek p'ã sim gaai “Hich Hẽwandamau hich chognaan pʌ̈iju” ha sĩebahab, “pʌ t'ʌa wënʌrramk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Maagwai mʌg hee pʌ baudʌk'iinjã, hamau sĩi hamach jua heeta pʌ jãau haubajup, buju haimaau pʌ chig ham hugua. ¡Baubaad! hajim hanʌm, chi meperau Jesuug. ");
INSERT INTO noaH_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Magbaawaita Jesuu magjim hanʌm: —Mamʌ hĩchab Hẽwandam hiek p'ã sim gaai jaauwai, “Hẽwandamau chadcha pãach t'ʌaju hawi hoob nem parhoob hamiet” ha sĩebahab hajim hanʌm, chi meperag. ");
INSERT INTO noaH_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hich mag warag chi dösãtau Jesuug hich hipierraa hamk'ĩir nem k'ĩirpierr jajaauk'am bʌ̃ʌrjã pödba habaawai, sëuk'a chi k'ũgur petajim haajem hichta. ");
INSERT INTO noaH_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Jesús hagt'a Hẽwandam Hak'aar hich gaai p'ẽs wai sim majim haajem deeu Galilea durr, hich berrag. Mag barwia judionaan Hẽwandam hiek jaaujem di sĩsidʌmpierr jaaujeejim haajem. Maagwai durr chaauram k'ʌʌnaupa hirua jaau nʌrrʌm k'ak'apdö hap'öbaadeewai t'umaam k'ʌʌnau hi higar nʌmua, “Hʌ̈uta mag jaau nʌrrabahab” haajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Maimua Nazareeg bëejim haajem, hich bãautarr p'öbörög. Mag bëewia jua hʌ̃ʌijem hed pabaadeewai judionaan Hẽwandam hiek jaaujem deg dubjim haajem, hag na hich duubjerrjö. Mag dubwia, hõrag hũrmk'ĩir Hẽwandam hiek t'ʌ̃raag p'iidʌ dʌnʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mag hi dʌnʌisiewai hãbmua hirig hʌapʌ̈ijim haajem, jöoingarm hẽsap chi pʌʌrt'ʌm, Hẽwandam hi jaaumie Isaías k'ararrau p'ãtarr. Maimua chi hẽsap pʌʌrt'ʌm gaai jʌrnaa t'ʌ̃rbaadëjim hanʌm. Hirua t'ʌ̃r sĩerr haig mag sĩejim haajem: ");
INSERT INTO noaH_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hẽwandamauta mʌ jʌr hautarr haawai hich Hak'aar mʌ gaai p'ẽs wai sim, hap'ʌʌm k'ʌʌnag jãga hichdëu ham peerdʌ hauju ha jaaumk'ĩir. Hirua mʌ pʌ̈itarran, hõor hamach k'aibag hee presonaanjö nʌm k'ʌʌnag, ‘Ya pãar höbërm hiek höbërju haai nʌm’ ha jaaumk'ĩir hajim; dau k'ĩsumjö nʌm k'ʌʌnagjã, ‘Ya pãrau wajap'a hooju haai nʌm’ ha jaaumk'ĩir; chik'amnau dau hap'ʌʌ waaujem k'ʌʌn dau haug k'augwia peerdʌ haumk'ĩir; ");
INSERT INTO noaH_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","maimua hõrag, ‘Hĩs chad mʌg jaarta Hẽwandamau pãar dʌ̈i nem hajapcha haju hed barbaichëm’ ha jaaumk'ĩirta mʌ pʌ̈ijim” hajim hanʌm, t'ʌ̃rmamua. ");
INSERT INTO noaH_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Maimua t'ʌ̃r haaipabaadeewai hichig chi hẽsap pʌʌrt'ʌm deetarrag deeu hʌapʌ̈iwia hoo sĩsijim haajem, hichdëu t'ʌ̃r sĩerr hiekpai jawaag. Magbaawai t'um haig narr k'ʌʌnau hãba hirigta heerpapaad t'ʌnʌisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mag hichig heerpapaad hap'öbaadeewai hamag magjim hanʌm: —Hĩsta chadcha pãach t'umaam k'ʌʌn dak'ĩir mʌg Hẽwandam hiek p'ã sim gaai hichdëu jaautarrjöo habarmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mag hũrwia t'umaam k'ʌʌnau hi wajap'a hig hiyʌ̈ʌ naajim hanʌm. Mag nʌm dʌ̈i hirua hiekdam hũrimʌ hiek'amam hũrwia t'um jʌ̃gderraa hap'öbaadëjim hanaabá. Mag hũrwia, jũrr hamach wir haigpai, —Keena, ¿mʌg woun José hiewaa k'abamá? ¿K'ani mag hiek'a hoo simma? hanaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Magbaawai Jesuu magjim hanʌm: —Pãrau mʌchig “Chadcha médico k'ai, pʌchdëupai pʌch monaaubapʌ̈i” ha hiek'aju mua k'ap'ʌ chirʌmgui hajim hanʌm. Magnaa hamag, Pãrau hũurwai Capernaum durr mua nem k'ĩir pogk'e waaujem hanaawai, mʌigjã magan hagjö waupi jaaujugui hajim hanʌm, mʌ hiek hʌ̈k'amap'am hiek'au. ");
INSERT INTO noaH_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mamʌ keena, pãadë hoobat, muajã mag chirʌmgui hajim hanʌm: Chi mʌg Hẽwandam hiek jaau wënʌrraajem k'ʌʌn chan dich dö hee hãba naajem k'ʌʌnau hãbjã k'a k'õchk'aba haajemwai. ");
INSERT INTO noaH_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mʌch sëuk'a chirʌm ham hugua pãrag jaauk'im: Pãrau k'ĩir heyaa nʌmgui hajim hanʌm, jöoingar Hẽwandam hiek jaaumie Elías k'ararr monak'a haawai Israel durr año t'ãrjup hawia jãrr bʌ̃ʌrjã noseg chëba harr hanʌm. Mag gaaimua Judea durr t'um jãdau t'eega burrtarr hanʌmjã pãrau hũurjem. ¿Pãrau k'ĩirjuawai mag jaar hĩchab k'oopaa hũanaan dau hap'ʌʌm chuk'u hajĩ Israel durr? Chuk'u hajim haju haai k'aba nʌm; k'apan t'ʌnaajim. ");
INSERT INTO noaH_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mamʌ magʌmjã ni hiwiir hãbam haarjã Hẽwandamau Elías pʌ̈ibajim. Mamag pʌ̈iju k'ãyau Sidón durr p'öbör Sarepta hanʌm hee k'oopaa hʌʌi hãb sĩerr haarta Hẽwandamau pʌ̈ijimgui hajim hanʌm, magʌgta hi jãhogamk'ĩir. ¿Jãgwi? Hich durram k'ʌʌn heepai pʌ̈imuan hi k'õchk'abaju k'ap'ʌ harr haawaima. Maguata warag deeum durragta pʌ̈ijimgui hajim hanʌm, hich meeun k'abam hee. ");
INSERT INTO noaH_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hĩchab k'ĩir heyaa habat: Israel durr Hẽwandam hiek jaaumie Eliseo k'ararr monak'a haawai hĩchab hõor kokobé bënëu bar sĩsidʌm k'apaana t'ʌnaajim. Mamʌ mag t'ʌnarr k'ʌʌn hiwiir hãbjã Hẽwandamau hirig monaaupi jaauba, hãba Siria durr woun Naamán haajerr happaita monaaupijim. ¿Jãgwi? Hẽwandamau hoowai hamach israelnaan heepai pʌ̈imuan, hamach heempai haawai bʌ̃ʌrjã hamach k'amor machag monaauju k'ĩirjubaju hich Hẽwandamau k'ap'ʌ sĩerr haawaima hajim hanʌm hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesuu mag hiek'abarm hũrbaawai haig narr k'ʌʌn t'um hi dʌ̈i meeuk'a p'öbaadëjim hanaabá, hamach k'ĩir hiek'abapäaiwai. ");
INSERT INTO noaH_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mag meeuk'a nʌmua warag p'iidʌtk'a p'öbaadëwia, p'öbör heemua jʌrpʌ̈iwia, hich hag p'öbör heepai durrsĩ gaai durr pör waaidʌ hi warrjierram haajem, mammua hit'urmʌg hee hi sĩepäaig. ");
INSERT INTO noaH_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mamʌ mag nʌm hee sĩi ham jãrr dichwia petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Maimua magtarr k'ur deeu Jesús Galilea durr p'öbör Capernaum hanʌmʌg bëejim haajem. Mag bëewia hõor jua hʌ̃ʌijem hed pabaadeewai hõrag jaaujeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mag hirua jaau sim haig hi hiek hũrwia hõor jʌ̃gderraa t'ʌnaajim hanʌm, chi k'ap'ʌm k'ap'ʌm haajem k'ʌʌn k'ãyaujã hichdëuta jaau k'ap'ʌcha jaaumam hũrwia. ");
INSERT INTO noaH_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mag judionaan Hẽwandam hiek jaaujem deg hĩchab sĩejim haajem, woun hãb mor hee bën k'aigbam wai sim. Mag wounau Jesús hoobaadeewai chi bën hi mor hee simuata t'et häa hanaa, ");
INSERT INTO noaH_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Jesús, Nazaretpierr! Hidëu maar sĩi k'ajap'a sĩubá hajim hanʌm. Pʌʌn warre maar höpäainta hurum. Mua pʌ k'ap'ʌ chirʌm, pʌ jammua hurú. Pʌ Hẽwandam Hiewaa hʌ̃gt'armua bëetarr k'abahab, warrgurwe Hẽwandamau pʌ̈iju jaaujerr hajim hanaabá, chi mepeer garmua. ");
INSERT INTO noaH_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Magbaawai Jesuu chi bënëg meeurraunaa, —K'ĩu habá. Pʌchta warag jãg woun mor heemua höbërbaad hajim hanʌm. Magbaawai chadcha chi mepeer höbërbaadëmua warre chi wounta jẽk'ʌt barwerbpʌ̈ijim hanaabá. Mamʌ magtarrjã chig haba, deeu k'ĩir heerdʌwia, warramjö monak'a sĩsijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mag hoowia t'umaam k'ʌʌn dauderraa nʌmua hamach heepai, “¿K'anim wounaan juapa t'eegta jãg mepeenag höbeerpi jaauwaijã hi hipierraa höbër nʌma? Keena, mʌig hag na maadëu mʌg chan hooba haajemwai” ha hiek'ap'öo t'ʌnaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesuu magtarr sĩi hag bigaau p'öbördam nʌnʌidʌm heem magwe bĩi t'ʌnʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Maimua mag woun mor heem mepeer jʌr pʌawia Hẽwandam hiek jaaujem degmua höbërwia petajim haajem, Simón di haar. Maimua barimawia hooimaawai, Simón p'aauhũanta k'ʌʌumieu mas t'ʌnʌm hooimajim hanaabá. Magbaawai mag hũan monaaupʌ̈imk'ĩir, hõrau Jesuug chaigpa naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Magbaawai hi werba jẽer sim bigaau dʌnʌʌuwimawia chi k'ʌʌumieg k'ĩesir hiek'abaawai warre chi k'ʌʌumie meeudʌbaadëjim hanaabá. Mag k'ʌʌumie meeudʌbaadeewai hag bʌ̈rre p'iidʌwia ham jãhogaagpajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Maimua hedau k'ëubaadeewai haaunaan paraa harr k'ʌʌnau hamach haaunaan k'amor machagpierr Jesús haig haubëemajierram haajem. Magbaawai Jesuu chi mor masim k'ʌʌn gaai pʌr hoomamuapai t'um monaaupʌ̈imajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mag pʌr hoomamua hõor mor hee bën paraa harrpa jẽu wërpmajim hanaabá. Chi mepeenaujã Hẽwandamau hi pʌ̈itarr k'ap'ʌ narr haawai, “Pʌʌn Hẽwandam Hiewaau” ha hähäag höbërdʌtk'a maajeejim hanʌm. Mamʌ Jesuu tag hamag hiek'apiba meeurrau sĩumajim haajem, hõrag hich jaaum hugua. ");
INSERT INTO noaH_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Maimua ya hãspabaadeewai haigmua chawag mawia hõor chukag haar hich happai sĩeimajim hanʌm. Mamʌ Capernaumpienau hi jʌr wënʌrrʌʌ hawia baau hat'aimaawai tag hi chawag pʌ̈imap'a sĩi hamach haigpaita sĩepim k'õsi naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mamʌ hichdëu hamag, —Mʌigpai chiraba mʌ chawag maju haai chirʌmgui hajim hanʌm, hĩchab deeum p'öbör heejã hõrag “Hẽwandamta ya t'umaam k'ʌʌn Pörk'aimʌʌ sim” ha jaauwia, hĩchab ham peerdʌju k'ĩirju nʌm k'ai, hirigta hʌdʌraa hamach Pörk'apiju haai nʌm ha jawaan, mag hat'eeta Hẽwandamau mʌ pʌ̈itarr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mag jaauwia, Capernaumpai sĩeba, hich mag p'öbörpierr judionaan biirdʌajem deg Hẽwandam hiek jaau nʌrraajeejim haajem, Galilea durr. ");
INSERT INTO noaH_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Biek hãb Jesús t'ʌrrdö Genesaret hanʌm higaau sim haig hõor pöoma podpachëwia t'et p'ẽeudʌ hi p'ʌʌr t'uur warrmajierram haajem, Hẽwandam hiek hũrm k'õchgau. ");
INSERT INTO noaH_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mag nʌm hee hichdëu bote numí mos gaai barhʌidʌ nʌm hoo hat'ajim hanʌm. Hag hee chi mork'ʌʌn chuk'u naajim hanʌm, dö hʌrëut'urwia dö higaau hamach red hʌ narr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Magbaawai chi bote dau hãb Simón dën harr haawai hirig jëeuwia, hag hee waaidʌwia, hichigpai bʌchk'un döjãrragaa hich warrpijim haajem. Magnaan chadau jupwia mammua hõor k'apan t'ʌnʌmʌg Hẽwandam hiek jaaubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Maimua mag hiek'a höbaadeewai chi Simonag, —Döjãrr wëbapʌ̈i, maimua chi red dubpʌ̈inaa deeu hʌrëu hoobat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Magbaawai Simonau jũrr magjim hanʌm: —Aay, hedaar maach daúa bʌ̃ʌrjã k'ãiba parii hʌrëu hëedʌtk'amaamjã bʌ̃ʌrjã marau pʌr haubajim. Mamʌ pʌ hiek haawai deeu mua chach hoojukë hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Maimua chadcha mag dubpʌ̈iwia jiir hoowai hãwarr pöoma t'ʌnʌmua chi red dau t'ʌrrdʌmaa hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Magbaawai hamach k'apeen deeum bote hee narr k'ʌʌnag jua t'õt'õi k'ap'öbaadëjim hanʌm, hamach juag hoon bëemk'ĩir. Mag chadcha warm k'ʌʌn bëewia jiir hat'aawai bote numwe hipiir haujierram hanaabá. Mag, bote numí narr hãba peer joot'ũpjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Mag Jesús hipierraa harr gaaimuapai hãwarr pöm pʌr hat'am hoobaawai Pedro dʌ̈i jap hãbam hee narr k'ʌʌnaupa, “¿Mʌʌn k'anim wounta hag na mʌg hooba haajemta hãwarr pöm mʌg pʌr haupibarma?” ha k'ĩirju nʌisijim hanʌm. Hich mag bʌ̈rre Simón Pedroou Jesús bʌ̈k'ʌrr p'õbk'a t'ʌnaaimawia hirig, —Señor, hoob mʌ dʌ̈i hãba nʌrram. Mʌʌn hatcha pekau pöoma chirʌm pʌ mʌ dʌ̈i nʌrraag hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Maagwai Pedro k'apeen hãbak'ai bote hee narr k'ʌʌnaujã hĩchab hamach k'apeenau k'ĩirju narrjö k'ĩirju nʌisijim hanaabá. Mag bote hee naajim haajem Zebedeo chaain, Santiago Juan dʌ̈i. Mamʌ Jesuu chi Simonag, —Simón, hoob k'ĩirjum hajim hanʌm. Warr pʌch sĩi dö hʌa gaaipai chitarrjö, hĩsmua hatagan pʌʌn jũrr mʌ hiekta hõrag jaau gaaipaita chirsijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Maimua dö higaau paauk'achëwia warag hi dʌ̈i mam hiek hërëubaadëjim hanaabá, hamach nem t'um pʌawia. ");
INSERT INTO noaH_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Maimua biek hãb Jesús deeum p'öbör hee sim haig woun hãb kokobé bënëu sĩi p'ĩe k'a dodos sim barchëjim haajem. Mag wounau hoo hat'aawai jẽk'ʌt p'õbk'anaa, jẽb gaai dagau dʌrnaa, chaigpamamua hirig, —Señor, pua k'õs chirʌm k'ai, mʌg p'ĩedau warre mʌ gaaimua chugpaabapʌ̈i haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Magbaawai Jesuu hi gaai pʌrnaa, —Mua pʌ monaaum k'õsi chirʌm; monaau chirsí magan hajim hanʌm. Magbarm bʌ̈rre chi p'ĩe k'a dodos chirarr monaau sĩsiewai mor hajapp'a sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mag ya monaau sĩsiewai, Jesuu hirig magjim hanʌm: —Pʌch mʌgbarm hoob chik'amnag jawam. Magju k'ãyau nacha Jerusalén mawia Haai hi jëeujem degam p'adëg pʌch mor hoopibaimá. Maimua Moiseeu hiek p'ãtarr gaai jaau simjö pʌch monaaubarm paar nemchaain ofrendak'a deebá hajim hanʌm, pʌch mʌg monaau sĩsim hõrag k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hich Jesús mag gaaimua sĩi warag hõor hee t'ʌ̃rp'öo sĩsijim hanaabá. Maagwaita warag hõor pöm biirdʌdʌ haajeejim hanʌm hi hiek hũraag, maimua hĩchab hamach monaaupʌ̈i mamk'ĩirjã hagjö. ");
INSERT INTO noaH_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mamʌ magʌm hãba, Jesús chawag maajeejim haajem, hich happai hõor chukag chʌʌi Hẽwandamag jëwaag. ");
INSERT INTO noaH_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Biek hãb Jesuu Hẽwandam hiek jaau sim haig fariseonaan dʌ̈i Hẽwandam hiek hat'ee chi machnaanpa hohood t'ʌnaajim. Mak'ʌʌn p'öbördam nʌnʌidʌmpierrmua bëetarr k'ʌʌn hajim haajem: Galilea durrmua bëetarr k'ʌʌn, Judea durrmua bëetarr k'ʌʌn, maimua hĩchab Jerusalenpienpa dʌ̈i naajim haajem. Maagwai Hẽwandam juapa t'eeg hi gaai sĩejim hanʌm, hõor monawaag. ");
INSERT INTO noaH_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mag nʌmta hõrau woun hãb k'apá jʌser k'itʌmta pa bʌʌrk'am gaai waiduraa hajierram haajem, Jesús sim haar wai dubwia hi k'ĩirp'ee werba sĩwaag, monaaupʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mamʌ dubju hẽk'a nʌm hõor pöm t'ʌnʌm k'urau pöd dubba habaawai, dihëu hʌ̃r waaidʌtk'a p'öbaadëwia, nem wäg waunaa, chi pa bʌʌrk'am gaai jʌ̃gadau jʌ̃k'anaa, chi haaunaanpa heeg jiir burrpʌ̈ijierram haajem, hõor jãrr Jesús hiek'a hoo sim k'ĩirp'eecha. ");
INSERT INTO noaH_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mag hich haig wai burrbaichëm hoobaawai, hirua chi wounaan hö hak'aar hãba hiruata hamach haaunaan monaaupʌ̈iju k'ĩirju nʌm k'ap'ʌ sĩerr haawai, chi k'apá jʌser k'itʌmʌgta, —Pʌ pekau t'um ya chugpaa sĩsimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mag hũrwia fariseonaan dʌ̈i Hẽwandam hiek hat'ee chi machnaanpa haig narr k'ʌʌnau hamach hödegpai, “¿Chijãg wounta Hẽwandam na mag hiek'a sĩma? ¿K'aíu mʌig pekau chugpaaju haai sĩ? Hẽwandamau k'abam chan pekau chugpaa hauba haajem” hanaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mamʌ Jesuu hamau mag k'ĩirju nʌm k'ap'ʌ sĩerr haawai hamag magjim hanʌm: —¿K'ant'eeta pãar jãg t'ãar k'aigba k'ĩirju sĩsid haajẽma? ");
INSERT INTO noaH_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Wa mag pekau chugpaabarmjã dau daau hooba naawai pãrau k'ĩirjuawai chadcha p'it'urg chuk'u t'umaam k'ʌʌnau mag hiek'aju haai nʌm ha nʌwa? Chadcha t'umaam k'ʌʌnau mag hiek'aju haaima. Mamʌ mua hirig “P'iidʌwi dʌrdʌr habá” hak'iin, hõrau hamach daúacha hooju, hi monaau sĩsi wa monaauba k'ãijã hich mag sĩsim. Magua pãrau mʌ dënjö chan cha mua jawaagpamjö habajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mamʌ mʌch chi Hemk'ooi Hiewaata chadcha Hẽwandamau juapá deetarrau mʌg jẽb gaai pekau chugpaagjã jua t'eeg chirʌm ha k'ap hamk'ĩir, pãrag hoopik'imgui hajim hanʌm. Maimua chadcha chi k'apá jʌser k'itʌmʌgta, —P'iidʌbá. Pʌch put juurwia, pʌch diig petá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Magbarm bʌ̈rre t'umaam k'ʌʌn dak'ĩir p'iidʌbaadëwia, hich waibëetarr pa bʌʌrk'am dʌ̈i putpa p'ë hauwia, hich diig petajim hanaabá. Mag mamua, “Hĩsin chadau Hẽwandam purua mʌ hʌ̈u habarm” ha hijẽjẽbag majim hanʌm, honegau. ");
INSERT INTO noaH_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mag chi woun p'iidʌbaadëm hoowia haig narr k'ʌʌn t'um dauderraa nʌm hiek'au, “Jãan hich hiiuta jãgbarm” hanaa hĩchab, “Hĩs Hẽwandamauta maadëu mʌg hooju k'ĩirjuba narrjã hoopibarm” hanaajim haajem, hamach hap pawiajã. ");
INSERT INTO noaH_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Maigmua höbërwia higbaadeeu hooimajim haajem, woun hãb Leví ha t'ʌ̃r sim. Mag woun hõrau dëbpaar p'agaan bëejem haig mes gaai päar sĩejim haajem, gobiernoog hõrau dëbpaar paraa nʌm jëeu nʌm p'idagta p'idk'a sĩerr haawai. Magʌgjã Jesuu, —Mʌ dʌ̈i marrau hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Magbaawai chadcha Leviiu p'iidʌwia hich p'idagjã k'augba, hi dʌ̈i petajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Maimua hich di haar barwia p'iejãb pöm waupijim hanʌm, Jesús k'öpieg. Mag nʌm dʌ̈i hĩchab hich k'apeen t'ʌ̃rk'ʌʌijim haajem, hich haig t'ach k'oon bëemk'ĩir. Magbaawai dëbpaar jëeujem k'ʌʌn k'apan wëdurum dʌ̈i parhoobam k'ʌʌnpa bëewia hãba t'ach k'ö naajim haajem, Jesús dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mamʌ magbaawai chi hajapcha Moiseeu Hẽwandam hiek p'ã pʌatarr hʌʌrk'aajem k'ʌʌnau Hẽwandam hiek hat'ee chi machnaan dʌ̈imua Jesús k'apeenagta, —¿K'an jãgwiata pãar jãg gobierno dëbpaar jëeujem k'ʌʌn dʌ̈i pekau pöm sĩsidʌm k'ʌʌnpa hãba t'ach k'ö nʌma? ha jëeujierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Magbaawai Jesuu magjim hanʌm hamag: —K'a monak'a nʌm k'ʌʌnau chan doctor higba haajem; hãba mor masi nʌm k'ʌʌnauta doctor hiigjem. ");
INSERT INTO noaH_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mʌ chan bʌ̃ʌrjã pekau chuk'u hajapp'a k'it'ëem haajem k'ʌʌn jʌraanjã bëeba, mʌʌn hõor pekau pöoma k'it'ëem k'ʌʌn peerdʌ hawaanta bëejimgui hajim hanʌm, k'ĩirjug hiiur haumk'ĩir. Maguata mag ham pekau pöm nʌmjã higba, ham dʌ̈i mʌ t'ach k'ö chirabahab hajim hanʌm, hamjã Hẽwandam dënk'a hawaag. ");
INSERT INTO noaH_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Maigmua Jesús hich k'apeen dʌ̈i höbër p'öbaadëm hee, hõor bëewia Jesuug magchëjierram hanʌm: —¿K'an jãgwia Juan dʌ̈i wënʌrraajem k'ʌʌnau t'ach k'ö nʌmjã hʌ̃iba sʌrk'anaata Hẽwandamag jëeujem daar, pʌ k'apeenau sʌrk'aba haajẽ? Chi hajapcha Moiseeu Hẽwandam hiek p'ã pʌatarr hʌʌrk'aajem k'ʌʌn higar nʌm k'ʌʌnaujã hagjö sʌrk'aajem, mamʌ pʌ k'apeenau chan hajap magba haajerram. ¿Jã k'an jãgwiauma? ha jëeujierram haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Magbaawai hichdëu hamag magjim hanʌm: —¿Pãrau hoowai chi jua pʌr sim woun honee hich hʌʌi dʌ̈i t'ach k'ö nʌmich, hirua hõor t'ʌ̃rtarr k'ʌʌn sʌrk'a nʌm hawia sĩi hök'ĩirjuu hohoodö naajẽ bʌ̃ʌrjã t'ach k'öba? ");
INSERT INTO noaH_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Magba haajem. Hich hagjöta nʌmgui hajim hanʌm mʌ k'apeenjã. Ham magjuun mʌ ham jaaijö ham dʌ̈i chitʌm pʌr hat'am hed gayan chadau ham hamach k'ĩrauta sʌrk'awia, hĩchab t'achjã k'öba nʌisip haju, gaai machgau. Mamʌ mʌʌgwaiwe chan ham sʌrk'aju k'aba nʌmgui hajim hanʌm, hagt'a mʌ ham dʌ̈i chiraawai. ");
INSERT INTO noaH_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Maimua hichdëupai magjim haajem: —Pãach k'ajũa jẽbaadeewai, ¿pãrau hoowai k'aíu dich k'ajũa hiiur gaaim jẽnaa jũrr chi jöoi gaai k'aajẽ? Maadëu magk'iin dich k'ajũa hajap'amta hãrpʌ̈iju. Maimua mag p'ẽebarmjã k'ĩir hãba k'aba daau p'ẽe wëjöm t'umaam k'ʌʌnau hooju. Hich hagjöta sim hĩchab mʌg hiek hiiur mua jaau chirʌmjã. Chi mʌ hiek hʌ̈k'a simua chan mʌg hiek hiiur mua jaau chitʌmjã hʌ̈k'anaa pöd hamach jöoin hijã hagjö hʌʌrk'aju k'aba simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mʌg mʌ hiek hʌ̈k'a nʌmʌn maadëu vino nemhëu hiiur hee pʌajemjöta sim. Pãrau k'ap'ʌ nʌmgui hajim hanʌm, vino hõrr nemhëu jöoi ya chi pʌajem hee pöd pʌju k'aba sim. Mag pʌk'iin chi vino hõrr hachpabaadeewai, chi nemhëu jöoiraa sĩewai hãwatba jẽgdʌbaadee, chi vinojã hãrbaadëm dʌ̈i chi nemhëujã ya tag serbiiba sĩsiju. ");
INSERT INTO noaH_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Maguata vino hõrran hagjö nemhëu hiiur heeta pʌajem; maagwai chi nemhëujã jẽgdʌba, chi vinojã hãrbamgui hajim hanʌm hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mag hiek'ak'agmamua, Pãrau k'ap'ʌ nʌmgui hajim hanʌm, chi vino hach doo k'aug nʌm k'ʌʌnag ham döp'ö t'ʌnʌm haig chi hõrr deeimak'iin, hamau “Hʌ̃hʌ̃, maraun chi hachta hig nʌm, jãata marag hajapcha sim” haju. Hich hagjöta pãrau mʌ hiek hũrmap'a, warag pãach hiita pʌaba wënʌrram k'õsi nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Biek hãb jua hʌ̃ʌijem hed Jesús hich k'apeen dʌ̈i trigo p'ur wëjöm hee dich wënʌrrajim haajem. Mag dich wëtumua hi k'apeenau trigo chi bichpa t'ʌrrëunaa chi dau juajãagpai sigt'ʌnaa k'ö wëtmajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mag k'ö nʌm hoowia chi hajapcha Moiseeu Hẽwandam hiek p'ã pʌatarr hʌʌrk'aajem k'ʌʌnau hamag, —Pãadë hoobat, jua hʌ̃i nʌm hed haawai bʌ̃ʌrjã p'idk'aju k'aba nʌmta pãrau jãg trigo p'ierrnaa k'ö wënʌrrʌm. ¿Pãrau chan k'augbahab hajim hanʌm, jãgpai p'ierr nʌmjã nem pöm heeu nʌm dʌ̈i hãba sim? ");
INSERT INTO noaH_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Magbaawai jũrr Jesuu hamag —Mamʌ ¿k'ani mʌ k'apeenau k'aigba habar? hajim hanʌm. ¿Magan pãrau bʌ̃ʌrjã Hẽwandam hiek p'ã sim gaai t'ʌ̃ʌrwai hooba haajeeb, Daviiu hich dʌ̈i wënʌrrarr k'ʌʌn dʌ̈imua hamach jãsöo hap'öbaadeewai Hẽwandam hat'eem pan k'ötarr? ");
INSERT INTO noaH_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pãrau k'ap'ʌ nʌm, jãga hirua Hẽwandamag jëeujem deg dubwia Hẽwandam hat'eem pan nasãd gaai p'ë sĩerr haujĩ. Mag pan parhoobam k'ʌʌnau k'öju k'aba, hãba p'adëupaita k'öju haai sĩejim. Mag k'ap'ʌ sĩerrta hirua k'öwia hĩchab hich dʌ̈i wënʌrrarr k'ʌʌnagjã deejimgui hajim hanʌm. Mamʌ mag k'ötarr paarjã Hẽwandamau ham chig habajim. ¿Magtarr pãrau k'augbata nʌ? hajim hanʌm hamag, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Maimua mag jaau dichwia hichdëupai, —Mʌʌn Hẽwandam Hiewaa Hemk'ooirau. Muruata t'umaam k'ʌʌnag k'an nemta wauju haai nʌ ha jaauju haai chirʌmgui hajim hanʌm, jua hʌ̃ʌijem hed hawiajã. ");
INSERT INTO noaH_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Maimua biek hãb hagjö jua hʌ̃ʌijem hed hich Jesús judionaan biirdʌajem deg dubwia Hẽwandam hiek jaau sĩejim haajem. Maig hĩchab sĩejim haajem woun hãb, juachaar garm juadam sĩi jua jʌser k'itʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Maagwai judionaan chi machnaan dʌ̈imua chi hajapcha Moiseeu Hẽwandam hiek p'ã pʌatarr hʌʌrk'aajem k'ʌʌnau Jesuug dau t'õba t'ʌnaajim hanʌm, heeu hirua jua hʌ̃ʌijem hedjã higba hõor jua pʌrwia monaaubaawai magʌm gaaimua hichigcha hõor dak'ĩir “Pua chan jua hʌ̃ʌijem hedjã bʌ̃ʌrjã hʌʌrk'abata sim” ha hiek'aag. ");
INSERT INTO noaH_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mamʌ hichdëu k'ap'ʌ sĩejim hanaabá, hamau mag k'ĩirju nʌm. Mag gaaimua chi woundam jua jʌser k'itʌmʌg, —Dayag pidú, mau hõor jãrrcha dʌnʌʌubaichë hajim hanʌm. Magbaawai chadcha bëewia hõor jãrrcha dʌnʌʌuchëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mag dʌnʌʌubaicheewai Jesuu magjim hanʌm: —¿Pãrau hoowai k'an nemta maadëu wauju haai nʌ jua hʌ̃ʌijem hed? ¿Hõordam dʌ̈i hajap'a haju, wa hõor k'aibag wauju? ¿Hõor peerdʌ hauju, wa hõor t'õoju? ¿K'ani hʌ̈ucha sĩ? hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mamʌ mag jëeunaa hõor t'umaam k'ʌʌn k'ĩir heerpa p'ʌʌrdʌdʌk'am hich hiek hʌ̈k'aba habaawai jũrr chi jua jʌser k'itʌmʌgta, —Dayag jua hʌabá hajim hanʌm. Mag chadcha hi hipierr jua hʌabaawai warre jua monakk'a sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mamʌ hamach dak'ĩir magbaawai hi dʌ̈i k'ĩir machag hap'öbaadëm hiek'au warag höbërdʌtk'awia, —Keena, maadëu jãgata hak'iin jãg Jesús t'õopʌ̈ik'am hanaajim hanʌm, hamach happai. ");
INSERT INTO noaH_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mag Jesuu jua hʌ̃ʌijem hedam magwe hõrag jaau nʌrrʌm hed gaai durrsĩ gaai waaidʌjim haajem, Hẽwandamag jëwaag. Mam heddurr pöm hich mag Hẽwandamag jëeu hëejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Maimua hãspabaadeewai hich dʌ̈i wënʌrraajerr k'ʌʌn hich haig t'ʌ̃rk'a hauwia mag k'apanag heem doce k'ĩet jʌr haujim haajem. Mak'ʌʌnta hi chognaan hi hiek jaaujem k'ʌʌnk'a t'ʌ̃rjim hanaabá, apostolnaan. ");
INSERT INTO noaH_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mʌk'ʌʌn hirua jʌr hautarr k'ʌʌn t'ʌ̃rʌu: Simón, (hichpai Jesuu Pedro ha t'ʌ̃rjim); Andrés, (chi Simón heeum); Santiago, (hichpai hĩchab Jacobo ha t'ʌ̃r sĩejim); Juan, (chi Santiago heeum); Felipe, Bartolomé, ");
INSERT INTO noaH_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, (hichpai Leví ha t'ʌ̃r sĩejim); Tomás, Santiago, (chi Alfeo hiewaa; hichpai hagjö Jacobo ha t'ʌ̃r sĩejim); Simón, (Celotenaan hee sĩerr); ");
INSERT INTO noaH_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, (hichpai Tadeo hanaa Lebeo ha t'ʌ̃ʌrjerr, deeum hagjö Santiago haajerr heeum); maimua Judas Iscariote, (hich maguata hewag pawi chi t'et'em k'ʌʌnag Jesús pʌr deeju hajima hi t'õomk'ĩir). ");
INSERT INTO noaH_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Maimua hich Jesús dʌ̈i durrsĩe narr k'ʌʌnpa t'um hãba hʌʌrba bëewia p'ëeurëgdam hee naaichëjim haajem. Maig hagjö hich dʌ̈i wënʌrraajerr k'ʌʌn k'apan biirdʌ t'ʌnʌm hee, hĩchab deeum durram k'ʌʌnpa hõor pöm t'ʌnaajim hanaabá: Judea durrmua bëetarr k'ʌʌn, Jerusalenmua bëetarr k'ʌʌn, maimua p'ũas higaau p'öbör Tiro hanʌm dak'a naajerr k'ʌʌn dʌ̈i Sidón perasöm k'ʌʌnpa t'ʌnaajim haajem. Hãaur k'ʌʌn hi hiek hũrm k'õchgau, maagwai tagam k'ʌʌn sĩi hamach monaaupʌ̈i mamk'ĩirta mag bëewi naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mag chadcha bën k'aigbam k'ĩirpierr hõor mor hee sĩsid harrjã t'um jʌr wërppʌ̈inaa monaaupʌ̈imajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mag hoowia t'umaam k'ʌʌnau hi gaai pʌrm hiigjeejim hanʌm, hamach monaaumk'ĩir, hamachdëu hoowai sĩi hi gaai pʌr nʌmuapaijã Hẽwandam jua t'eeg hich gaai wai simuata bënëgjã hich jua jʌmpiba monaaupʌ̈pʌ̈ik'am hoowia. ");
INSERT INTO noaH_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mag hõor mor masim k'ʌʌnpa t'ʌnarr t'um monaauk'apʌ̈iwia hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnagta heerpanaa magjim hanʌm, hich Jesuupai: —Pãar mʌg mʌ hiek hũrm k'õchgau dau hap'ʌʌ wënʌrrʌm k'ʌʌnta honee habat, mʌg hatag pãachta Hẽwandam dʌ̈i hãba jooba wënʌrraju haawai. ");
INSERT INTO noaH_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Honee habat hajim hanʌm, pãar har Hẽwandamau waupim k'õsim nem wawaagta jãsöomjö nʌm k'ʌʌn. Jãgtarr jũrr mʌg hatag pãar bʌ̃ʌrjã haugchëba wënʌrrajugui hajim hanʌm. Honee habat, pãar mʌ gaaimua dauhi paraa durraajem k'ʌʌn; mʌg hatag pãar hök'ĩirjug k'augba wënʌrrajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Honee habat hajim hanʌm, mʌch chi Hemk'ooi Hiewaa hiek hʌ̈k'a nʌm gaaimua pãach chik'amnau k'a huk'urnaa hamach haigmua k'ãijã warag di chaaur pãach jʌʌrwai. Honee habat, chik'amnau pãach wau hiek'amamua k'ãijã, “Jãg woun chan hõor hajap'am k'abam” ha hiek'aawai. ");
INSERT INTO noaH_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hõrau pãach dʌ̈i mag nʌm jaar hoob hök'ĩirjuu hamiet hajim hanʌm. Mag k'ãyau warag honee habat hajim hanaabá; pãar mag nʌm jũrran hʌ̃gt'arin pãar hat'ee nem hajap'am pöomata t'ʌnʌm. Hĩs mʌg pãar mʌ gaaimua dau hap'ʌʌ wau nʌmjö wënʌrraajeejim warrgarwejã, Hẽwandam hi jaaujerr k'ʌʌn. Mamʌ hĩs hʌ̃gt'ar Hẽwandam dʌ̈i ya ham honee nʌmgui ha hiek'amajim hanaabá, ham wawí nʌmua. ");
INSERT INTO noaH_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mag hiek'ak'agmamua hichdëupai, ’Mamʌ ¡hëh hapdurr hajim hanʌm, hõor hamach p'atk'onta t'ö hiyʌ̈ʌ haajem k'ʌʌn! Ham hamach p'atk'onag hee ham k'õchgau Hẽwandam higba harr jũrr, hamau mʌg hatag hoomaa hajurau hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Hëh, hapdurr hajim hanʌm, mʌg jẽb gaai nem t'um paraa bʌ̃ʌrjã haugchëba haajem k'ʌʌn! Jãgtarr k'ʌʌnta jũrr mʌg hatag dau haug hee wëtju. ¡Hëh, hapdurr hajim hanʌm, har sĩi honee ham k'õchgau bʌ̃ʌrjã hamach mor hewag k'ĩirjuwia hök'ĩirjuupaijã haba haajem k'ʌʌn! Hamachdëu hampierr ham k'õchgau Hẽwandam higba harr jũrr pöd hamach hʌ̃gt'ar höbërba haawai, mʌg hatag ham hicharaucha bĩe nʌisijugui hajim hanʌm. Maimua hĩchab, ");
INSERT INTO noaH_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Hëh, hapdurr hajim hanʌm, har t'umaam k'ʌʌnau pãar hëugar, “Jãan chad woun hajap'am pamá” ha hig hiyʌ̈ʌ haawai! Warrgarwejã par chadcha Hẽwandam hi chaar k'abamta jaaujerr k'ʌʌn hëugarjã hich magta hiek'aajeejim, pãar jöoinau. Hõrau mag ham hëugar hõor hajap'am haajeejieb mamʌ, maadëu k'ap'ʌ nʌmgui hajim hanʌm, ham pöd Hẽwandam haar höbërba harr. ");
INSERT INTO noaH_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mag jaaumamua Jesuu magjim haajem hich hiek hũr narr k'ʌʌnag: ’Pãach dʌ̈i hiekk'õr paraam k'ʌʌn k'a k'õsinaa pãach hoomap'a haajem k'ʌʌn dʌ̈ijã nem hajap'am waubat. ");
INSERT INTO noaH_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pãach chik'amnau t'õp hiek'aawai magʌm hiekjã higba, warag ham kõit Hẽwandamag jëeubat. Maimua pãach hãauk'a hiek'abaadëm pʌa chʌuu haawaijã, dʌ̈i hãauk'a hiek'aju k'ãyau, warag Hẽwandamagta ham kõit jëeubat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chik'amnau k'ãijã pʌch gaai mas deewai hoob hi gaai hagjö deem. Mag k'ãyau hʌdʌraa pʌch gaai mas hapibá. Wa pʌch camis k'ãijã hãbmua k'echt'ʌg haum hiigwai warag tagam k'ajũajã hʌdʌraa hirig harrpibá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wa pʌch nem k'ãijã hãbmua k'echt'ʌg haum hiigwai, meeuk'aju k'ãyau, hok'ooju hawiajã hidëu warag harrpibá. Hõrau pʌchig nem jëeuwai hö hajap'a magʌm haba deebá. Wa hãbmua k'ãijã k'ũchpaim hat'ee pʌch nemdam jëeu harrwai hoob, “Jöpk'aa mʌ hin deebahur” ham hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chik'amnau pʌch dʌ̈i k'aigba hapimap'a sim k'ai, pʌch garmuajã hoob hi dʌ̈i k'aigba ham. Hõrau pʌch dʌ̈i hapim k'õsimjöta pʌch garmuajã ham dʌ̈i habá hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Magnaa mag hichdëu parhoobam k'ʌʌnjö hapiba sim higwi, ’Pãadë k'ĩirjubat hajim hanʌm: Pãrau pãach jãsenem k'ʌʌnpaita daupii hak'iin, ¿maig k'an hajaug sĩ? Bʌ̃ʌrjã Hẽwandam hiek hʌ̈k'abam k'ʌʌnaujã hamach k'a k'õsim k'ʌʌn chan hoomap k'aba sĩerrjëemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wa pãrau pãach juag hoojem k'ʌʌn juagpaita hagjö hook'iin, ¿maigjã k'an hajaug sĩ? Mag nʌm haig hʌ̈u k'aba sim. Hẽwandam hiek hʌ̈k'aba haajem k'ʌʌnaujã jũrr hagdaujö chik'am juag hoojemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pãrau pãachdëu nem deebarmjö pãachig deejöjöo k'ĩirju nʌm k'ʌʌnagpaita nem deek'iin, ¿maigjã pãar jãga nʌ? ¿Hich hagjö haba haajẽ hajim hanʌm, Hẽwandam hamach t'ãar hee chuk'u nʌm k'ʌʌnaujã, deeu hagjö hamachig nem deemk'ĩir? ");
INSERT INTO noaH_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Magua muan pãragan, pãach dʌ̈i hiekk'õr paraam k'ʌʌnjã warag k'a k'õsita habat ha chirʌmgui hajim hanʌm. Maimua ham dʌ̈i hö hajap'a habat hĩchab, pãach nemdam k'ũchpaim hat'ee k'ãijã jëeu harrwai tag deen bëebaju k'ãijãa jãg deebapʌ̈im ha hiek'aba. Pãrau hö hãk'ãrag chuk'u magmʌn, hʌ̃gt'arin pãar hat'ee nem hajap'am pöoma t'ʌnʌmgui hajim hanʌm. Hĩchab pãar mag wënʌrrʌmʌn magan pãar chadcha Cha Hʌ̃gt'aa P'uu Nʌm hag chaainaugui hajim hanʌm. Hẽwandamau hõrau k'ĩirjuajemjöta k'ĩirjuajem hak'iin, hãba hõor hajap'am k'ʌʌnagpaita hirua nem deejeek'am. Mamʌ hi magba t'umaam k'ʌʌn dʌ̈i hajap'a k'itʌm, hõor k'aibagjã higba, ni mag hich hajaug k'itʌm paarjã hõrau hichig hʌ̈u hajim habajujã k'ĩirjuba. Magua pãraujã hagjöta haju haai nʌmgui hajim hanʌm, pãach k'apeen k'aibagjã higba. ");
INSERT INTO noaH_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Maachin t'umaam k'ʌʌn dau haug k'aug paraata hanʌm, har jãg maach Haai hʌ̃gt'ar simuajã hagjö maach t'umaam k'ʌʌn dau haug k'aaugjẽpirau. ");
INSERT INTO noaH_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Hoob chik'am hĩgk'am k'õchgaupai chan chik'am pekau p'ëmiet, heeu Hẽwandamau pãach chach nʌm hed magʌm hiek higduk'am pãach dʌ̈i. Hoob “Jãg wounan chad k'aibag hee pʌ̈iju haai sim” hamiet, heeu pãach hiek gaaimuapai Hẽwandamau pãachta k'aibag hee pʌ̈iduk'am. Chik'amnau pãach dʌ̈i k'aigba haawai sĩi warag hich mag k'ĩir hak'oobapʌ̈it, tag magʌm hiekjã higba. Pãrau pãach k'apeen dʌ̈i magmʌn, magan Hẽwandamaujã pãar dʌ̈i hagjö hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pãach k'apeenag nem hĩgk'aba deemʌn, Hẽwandamaujã pãrag nem hĩgk'aba deeju. Pãrau pãach k'apeenag nem deebarm jũrr, hirua pãrag hʌ̃r hag k'ãyau p'ẽsu hipiirnaa pör simii deeju. Mamʌ pãrau pãach k'apeenag chachnaata nem dee nʌmʌn, magan Hẽwandamaujã hich hagjöpai pãrag deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mag ejemplodam k'ĩir pogk'e jaaumamua, ’Pãadë k'ĩirjubat hajim hanʌm. Woun hãb dau k'augba simua hich k'apeer hagjö dau k'ĩsu k'itʌm jua gaai pʌr harrk'iin, hãb bʌ̈hëu subaadeeu ¿hamach numwe burrbaju k'ai? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","¿Pãrau hoowai heeu woun nem k'aug simua hichig jaau sim k'ãyau hatcha nem k'aug sĩejẽ? Hichig nem jaaumam t'um k'augbapäaiwain chadau hich maestro dënjö nem k'aug sĩsiejemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Pʌch dau hee pasur pöm sim joot'ʌ t'ʌnʌm nacha noi haubam haig, ¿jãga pua pʌch k'apeer dau heem pasurdam bʌ̃rʌʌ k'itʌm noi hawaag hagá? Maachin nacha dich k'ĩirjunaata hiek'a nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wa magbam k'ai, ¿jãga hãbmua hich k'aperag “Daai kakë, mua pʌ dau heem pasurdam noi hauk'im” haju, mamʌ hich dau heejã hag k'ãyau nem pöm sim joot'ʌ t'ʌnʌm noi hauba simta? Sĩi chik'am jaaum k'õchgaupai chan dich wir haig k'ĩirjubanaa pöd mag hiek'aju k'aba nʌmgui hajim hanʌm. K'ĩirjug chukdam, nacha dich dau heem pasurta noi hauba haajeeb, wajap'a hoog; maimuan chadau jũrr dich k'apeer dau heemjã hagjö noipʌ̈i nʌm. Magua dichta nacha k'ĩirjuba haajeeb chik'am jawaag. Dichjã hagjö chirʌm chan pöd dich k'apeen jaauju k'abamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mag jajawagmamua, ’Maach jaauju k'ʌʌn chuk'u hawiajã maachin dich hiek'a nʌm gaaimuata hõrag dich k'ap hapiejemgui hajim hanʌm, hõor wäjäauná wa hõor k'aigbam k'ʌʌná. Pãrau k'ap'ʌ nʌmgui hajim hanʌm, nemjõ hãk'ãraa cheejem higwia, “Jãg nemjõon chad hajap'a k'itabma” haba haajem; maagwai jũrr nemjõ hajap'am higwiajã, “Jãg nemjõon chi hãk'ãrau” haba haajem. ");
INSERT INTO noaH_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","¿Pãrau hoowai pahach gaai nemjõ k'ũwaa chë sim hoojẽ? Kũpud dënjã miel wie nʌm hooba haajem. ");
INSERT INTO noaH_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hich hagjöta nʌm hĩchab maach wounaanjã. Hõor k'ĩirjug hajap'am k'ʌʌnau nem hajap'am nemta hiek'a nʌm, hamau nem hajap'ata wauju k'ĩirju naawai; mamʌ hö hãk'ãraam k'ʌʌnaun hiek'aawaijã nem k'aigbamta hiek'a nʌm, ham hödi sĩi nem k'aigbamta wauju k'ĩirju sĩsid haawai. Magta hõraun maach hiyʌ̈ʌ nʌm hũr nʌm gaaipai warre k'ap'ʌ haajem, k'anim woun hagá: woun hajap'am wa woun k'aigbam. ");
INSERT INTO noaH_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Pãrau mua nem jaau chirʌm hipierraa k'aba nʌmta, ¿k'ant'ee mʌ higwia sĩi par hiiupai “Pʌʌta maar Pöröu” haajẽ? ");
INSERT INTO noaH_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Mua pãrag jaauk'imgui hajim hanʌm. Har chi mʌ haig bëewia mʌ hiek hũrnaa mua nem jaau chirʌm hipierraa nem waaujem k'ʌʌnan, biek hãb woun di hëwaag jẽbdi k'örk'a sĩi hawia durrk'udau hee hierr hich dibʌ̈ juk'anaa di hëutarr wounjöta nʌmgui hajim hanʌm. Ya mag haaipa dʌnʌisim hee, döhãd pöm bëewia hag gaai dö huu t'ʌnarrjã chʌyëupʌ̈iba hich mag sĩsijim hanaabá, dibʌ̈ hierr juk'a sĩerr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mamʌ har chi mʌ hiek hũrtarrta bʌ̃ʌrjã hag hipierraa k'aba nʌm k'ʌʌnan, jũrr hagjö woun hãb sĩi k'omariipai dibʌ̈ juk'anaa di hëutarrjöta nʌmgui hajim hanʌm. Mag k'omariipai hëu sĩerr haawai haaipa dʌnʌisim hee, hĩchab noseg pöm chë t'ʌnʌʌ harr k'ur döhãd pöm pierrwai, dö huu t'ʌnʌʌ hawia sĩi dö badag hʌʌrsirpʌ̈ijim hanaabá. Mag, nem t'umaa hok'oojimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mag hõor pöm wëjorrag hiek jaau hö dichtarr k'ur Capernaum p'öbörög petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mag Capernaum p'öbör hee capitán hãb sĩejim haajem, soldaaun pör. Mag capitán chog hãb hirua hʌ̃rcha daupii haajerrta mor mas parhba tag hãwatbajujö t'ʌnaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mag nʌm hee chi capitanau hũurwai Jesuu hõor monaau nʌrrʌm ha hũrbaadeewai, judionaan hee jöoin chi t'et'em k'ʌʌn jʌrwia pʌ̈ijim haajem Jesús haar, mak'ʌʌnau chi Jesuug chaigpa p'öbaadeewai hich chog monaaupäain hich di haar mamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Mag chadcha hërëuwia, chi Jesús sim haar bardʌtk'aimawia, mag capitán chog mor mas simta p'ʌʌrba jajaau nʌʌ hawia, chaigpa nʌmua hirig magjierram hanʌm: —Pua capitán di haar hi chog monaaun mak'iin hʌ̈u hak'am. Hi chan maachjö judío k'abam, mamʌ maach meeun k'a k'õsi sĩerrʌmgui hajierram hanʌm. Hirua maar Hẽwandam hiek jaaujem dijã par hëu deejim, hich p'atk'onau. Jãgʌm wounaan di haran chadcha pʌ maju haai chirʌm. Pua k'õs hak'iin maran pʌ hawaanta bëejimgui hajierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Magbaawai chadcha ham dʌ̈i majim haajem. Mamʌ ya chi haaunaan wai nʌm di dak'a wëtum hee, chi capitanau hich haig narr k'ʌʌn dʌ̈i hiek jaaupʌ̈ijim haajem, Jesús haar. Magbaawai wëtwi barimawia hirig, —Capitán hiek, pʌ mapimaaugau k'abam haajem, mamʌ hi hiek hí Hẽwandam dau na hʌ̈u k'aba chirʌm haajem, pʌ hi di haar maag. ");
INSERT INTO noaH_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Hich mag chirʌm k'ap, hichcha pʌ haig bëeba habarm haajem, pöd pʌ dʌ̈i k'ĩircha hiyʌ̈ʌ haju k'aba haawai. Mamʌ pua k'õs hak'iin, hich maupaimua hich chog monaaupi naajim. Hi hiek pʌch hiiu haawai chadcha monaauju haajem. ");
INSERT INTO noaH_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Hi hiek hiruajã hich gaaita k'ap'ʌ chitʌm haajem, hichjã hĩchab hich pörnaan jua heegpai chitaawai. Mag chirab mamʌ, hiruajã hĩchab soldaaun hich jua heegar p'ë wai chirʌm haajem. Mak'ʌʌnag hãbamʌg k'ãijã “Pet” haawai maajem haajem, hipierraa. Maimua deeumʌgjã “Pidú” haawai bëejem haajem. Maimua hich chogagjã “Mʌgta habá” habaawai hi hipierraa haajem haajem. Magua, maupaimua pua hi chog monaaupi jaaumʌn, chadcha monaauju hirua k'ap'ʌ chirʌm haajem ha jaauchëjierram haajem, Jesús haig. ");
INSERT INTO noaH_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Capitán judío k'aba simuata mag hiek jaaupʌ̈itarr warm k'ʌʌnau hichig jaaubaichëm hũrbaawai Jesús jʌ̃gderraa haadëmua hich hẽudee hõor pos wënʌrrarr k'ʌʌnagta, —Keena, pãadë hoobat. Mʌg maach israelnaan hee mʌg woun dënjö hʌ̈k'a nʌm chan hagt'a mua hooba chitʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Maimua chi hiek jawaan bëetarr k'ʌʌn deeu hewag wëtwia di haar hooimaawai, maig warppaimua ham barju nawe Jesuu monaaupʌ̈itarr haawai mag chi capitán chog mor mas k'ërarr monakk'a k'ërʌm hooimajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesús Capernaum p'öbör hee mag capitán chog monaaupʌ̈iwia höbëraau p'öbördam Naín hanʌmʌg petajim haajem. Mag hi mam dʌ̈i hi k'apeen k'apan wëtmam hee, hagjö deeum k'ʌʌn pöm pos wëtmajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mag mamua p'öbör hee dubaag puertdi sim haig dak'a pachënaa hoowai hõor binaan bëpaan warrumta hoo hat'ajim hanʌm. Ma, k'oopaa hũan chaai hichta hãbpai k'itarr hajim haajem. Mag binaandam harrum dʌ̈i hĩchab hag p'öbör heem k'ʌʌn hõor k'apaana wëdurajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Maimua haar barwia maach Pör Jesuu k'oopaa hũan hich chaai hat'ee dau hap'ʌʌ k'ërʌm hoobaawai hirig, —Hoob bĩem hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Magnaa warag haig bëewia chi binaan harrum pa gaai pʌrbaicheewai chi harrmaa harr k'ʌʌn dʌnʌisijierram haajem. Magbaawai chi binaan hẽwan sĩerrag, —Mʌ hiek'au p'iidʌbaad hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Magbaawai hag bʌ̈rre chi mee k'ërarrdam p'iidʌwia hʌ̈u deeu hiyʌ̈ʌ haadëjim hanaabá. Magbaa Jesuu chi hãdagta, —Har k'ërʌm, pʌch chaai hat'aad hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Magbaawai t'umaam k'ʌʌn jãp'ierr nʌm hiek'au Hẽwandamag jëeumamua, “Chadcha Hẽwandam, hʌ̈u pua maar heeg hoo chirʌm. Hʌ̈u pua jãg chaai chi meem harr p'iriu hat'am” hajierram hanʌm. Magnaa hĩchab hamach wir haigpai, “Keena, hĩsin chadchata maach hee jöoingarmjö Hẽwandam hi jaaumie sĩeichëchëm” k'ajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mag Jesuu chaai p'iriu hautarr Judea durr t'umaam k'ʌʌnau k'ak'apdö hap'öbaadeewai hichta warag t'ʌ̃rp'öo sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juanaujã hĩchab Jesuu mag nʌrrʌm t'um k'ap'ʌ haadëjim haajem, hich k'apeenau hich sim haar jaaubaimaawai. Magbaawai hich k'apeen numí t'ʌ̃rk'a hauwia ");
INSERT INTO noaH_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesús haar pʌ̈ijim haajem, mak'ʌʌnau hirig “¿Pʌʌta chadcha nawe Hẽwandam hi jaaumienau bëeju ha jaaujerrá, wa har k'abam k'ai warag hich jãg nʌag?” ha k'ap jëeumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Magbaawai chadcha hërëuwia Jesús sim haar barwia hirig maguimajierram hanʌm: —Juan chi hõor pör choomieu maar pʌ haig pʌ̈ijim, hichig jaaupʌ̈imk'ĩir. ¿Pʌʌta chadcha nawe Hẽwandam hi jaaumienau bëeju ha jaaujerrá, wa marau deeumta nʌju haai nʌwa? Marag hajap'a jaaubá marau k'ap haag haimajierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Magbaawai, —Pãrag hoopik'imgui hawi, ham dak'ĩir Jesuu k'amor machag sĩsidʌm pöm monaaunaa bën k'aigbam wai sĩsid harr k'ʌʌnjã monaaupʌ̈imajim hanaabá. Mag nʌm dʌ̈i hĩchab hõor dau k'augba k'it'ëe harr k'ʌʌnjã dau monaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Maimuan chadau magjim hanʌm, chi Juanau chogtarr k'ʌʌnag: —Hërëubaadëwia Juan haar jaaubaimat, pãach jʌ̃gʌucha hũrwia pãach daúacha mʌg hoobarm. Hirig, “Dau k'augba k'ëk'ëd harr k'ʌʌn dau hajap'a t'ʌnʌm habat; bʌ̈ wëdʌ wëdʌ sĩsid harr k'ʌʌnjã ya hajap'a nʌrrjëem; kach k'ĩsu harr k'ʌʌnaujã hajap'a hũr sĩsidʌm; chi meem harr k'ʌʌnjã deeu hiiu nʌrrjëem; maimua hap'ʌʌm k'ʌʌnagjã hĩchab hõor peerdʌajem hiek jaau chirʌm” ha jaaubaimat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hĩchab hirig, “Chi mʌ hiek hʌ̈k'awia hogdʌba mʌ gaai hʌ̈k'a chirʌm wounan hi honee hich mag chitaju” ha jaaubaimat hajim hanʌm, mag hichig jëeuwimarr k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Maimua chi Juanau chogpʌ̈itarr k'ʌʌn hërëu p'öbaadeewai chi Juan higwiata Jesuu hõrag magjim hanʌm: —Pãrau Jordán higaau woun hõrag Hẽwandam hi jaau nʌrrʌm hoon weetwai, ¿sĩi woun hiek t'eeg chuk'u p'ũu choomaar sõsõii jũurba hahau haajemjök'amta hoon wëtjierrá? Magʌm woun k'abajimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Magan ¿k'anim wounta hoon wëtjierráma? ¿Woun k'ajũa hajapp'a jũa simta hoojupii hawia hoon wëtjierrá? Pãrau k'ap'ʌ nʌmgui hajim hanʌm, k'ajũa hajap'a jũanaa t'ach biwaa k'oojem k'ʌʌnan sĩi p'öbör hee di hooimʌm heeta naajem, reinaan dʌ̈i hãba. ");
INSERT INTO noaH_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mamʌ pãrau magjömta hooimabajierram. Pãrau hooimatarran woun hãb Hẽwandam hi jaau nʌrrʌm hajim. Mamʌ mua pãrag jaauk'imgui hajim hanʌm: Juan chan warrgar Hẽwandam hi jaaujerr k'ʌʌnjöpai k'aba, ham k'ãyaujã hʌ̃rʌʌchata sim. ");
INSERT INTO noaH_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hi higwia Hẽwandamau hich hi jaaumienag warrgarwe hich hiek p'ãpitarr gaai jaauwai: “Jãata hirua mʌ na pʌ̈iju hajim, hichdëuta mʌ na mʌ maju hee hõrag jaaumaawai t'umaam k'ʌʌnau mʌ hiek hũrm k'õsi sĩi mʌ nʌ naamk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Magua muajã pãrag mag chirʌmgui hajim hanʌm hich Jesuu: Warrgar Hẽwandam hi jaaujerr k'ʌʌn heejã Juan chi hõor pör choomie k'ãyau hʌ̃rʌʌcharam chan hãbjã chuk'u hajim. Mamʌ chi mʌ hiek hũrwia, mua nem waubarmjã k'ap'ʌnaa, Hẽwandamta hich t'ãar hee hau sim wounan chad, maadëu nem higba k'itawiajã, Juan k'ãyaujã k'apcha haju, jãga Hẽwandam hichdëu hõor peerdʌ hat'am t'ãar hee sĩeicheejẽ. ");
INSERT INTO noaH_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Pãrau k'ap'ʌ nʌmgui hajim hanʌm, chi Juanau jaau nʌrrʌm hũr narr k'ʌʌn hee t'umaam k'ʌʌnau dëbpaar jëeujem k'ʌʌnaupa hamach k'aibag hãsie hewag k'ĩirjuwia hirig pör choopi nʌmua Hẽwandamagta, “Hẽwandam, chadcha puata maar t'ãar k'ap chirʌm. Hʌ̈u pua Juanag jaaupiwia marag pʌch hiek k'augpibarm” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mamʌ chi Moiseeu Hẽwandam hiek p'ãtarr hajapcha hʌʌrk'aajem k'ʌʌnau chi machnaan dʌ̈imua chan magba, Hẽwandamau ham t'ãar heejã warm k'ʌʌn dʌ̈ímjö ham hig sim warag hisegjierram. Mag gaaimua warag Juanagjã hamach pör choopibajierramgui hajim hanʌm, hamachta hajapcha nʌm hawia. ");
INSERT INTO noaH_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Maimua maach Pör Jesuu mag jaaumamua magjim haajem: ’Pãar hĩsim k'ʌʌn, ¿jãga nʌm habarí? Mua pãrag jaauk'im: ");
INSERT INTO noaH_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pãar har Juan hisegwi mʌjã hiseg nʌm k'ʌʌnan, chaain jemk'a nʌmua hamach k'apeen dʌ̈i k'ĩir haup'öbaadëmjöta nʌmgui hajim hanʌm. Warm k'ʌʌn garmua, “Maar dʌ̈i karris sir nʌm gaai honee jemk'abahut” haawaijã jemk'amap'a nʌm. Maimua jũrr, “Magan sĩi hök'ĩirjuu hõor mee wai nʌm haiguimjö hohoodö habat” haawaijã magjã k'õchk'aba nʌm. Pãarjã magta naawai, ¿k'ani k'õsi nʌmma? ");
INSERT INTO noaH_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pãar hee Juan chi hõor pör choomie nʌrraajeewai hirua hajap t'ach k'öba sʌrk'aajeejim, Hẽwandamag jëwaag. Magʌm vino chará bʌ̃ʌrjã döbajim. Mamʌ mag hoowai pãrau, “Jãan mepeer dʌ̈i k'apeerk'a sĩewaita sĩi hich jãg haai t'ach k'öba nʌrraajem” ha hiek'aajem pãrau. ");
INSERT INTO noaH_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mamʌ hĩs mʌch chi Hemk'ooi Hiewaa chaar bëewia pãach dʌ̈i parhooba t'achdam k'önaa vinodamjã dö k'itaawai jũrr magjã k'õchk'aba, warag pãrau mʌ hëugar t'ach bipöm k'önaa vino pigjã chitʌm haajem. Magnaa gobierno dëbpaar jëeu nʌmua hõor k'ũguurjem k'ʌʌn dʌ̈ijã k'apeerk'anaa pekau pöm sĩsidʌm k'ʌʌn dʌ̈ipa k'apeerk'a chitʌm ha hiek'aajerramgui hajim hanʌm, mʌjã hiseg nʌm hiek'au. ");
INSERT INTO noaH_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Magnaa hamag, Mamʌ har chi Hẽwandamau k'ĩirjug deetarraucha k'ĩirju nʌm k'ʌʌnau chan magba, hamau chadcha k'ap'ʌ nʌmgui hajim hanʌm, chijã k'ʌʌnta hich Hẽwandamaucha pʌ̈itarr k'ʌʌn hagá. ");
INSERT INTO noaH_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Biek hãb chi hajapcha Moiseeu Hẽwandam hiek p'ã pʌatarr hʌʌrk'aajem k'ʌʌn heem woun hãb Simón hanʌmua Jesús hich dʌ̈i hãba t'ach k'ömk'ĩir hich di haar hëeurrjim haajem. Magbaawai chadcha mag woun di haig bëewia, hich hat'eem t'öi k'ërʌm haig jupwia, dijã hee hãba p'ʌʌr k'öp'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Maagwai hag p'öbör hee sĩejim haajem, kachaloo hʌʌi hãb parhoobam hemk'ooin dʌ̈i sĩerrarr. Mag hʌʌirau Jesús Simón di haig t'ach k'ö sim k'aug hat'aawai jʌ̃gdee didam durrk'udau alabastro hanʌm dën boteedidam wau k'itʌm dʌ̈i bëejim haajem hi haig. ");
INSERT INTO noaH_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mag bëewia hi hëugarmua hi bʌ̈k'ʌrr p'õbk'achëwia bĩemamua hi bʌ̈ hʌ̃r hich dauchö t'ëutk'amam hich pörbʌ̈ʌupai jãrpʌ̈imajim hanʌm. Magnaa hi bʌ̈ hʌ̃ʌ hau, hʌ̃ʌ haunaa, jʌ̃gdeeu choomajim hanaabá, hi bʌ̈ gaai. ");
INSERT INTO noaH_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chi Jesús t'ʌ̃rpʌ̈itarr wounau mag hoobaawai hich hödegpai, “Mʌg woun chadcha Hẽwandam hi jaaumie chaar hak'iin, hirua warre k'aug hauk'amgui hajim hanʌm, k'anim hʌʌirauta jãg hich bʌ̈ gaai pʌrbaichë. Majã pekau pöoma simua hich gaai pʌr simta bʌ̃ʌrjã k'augba simgui” hajim hanʌm hich hödegpai. ");
INSERT INTO noaH_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Magbaawai Jesuu chi Simonag, —Simón, pʌdë mʌ hiek hũrbarí hajim hanʌm. Magbaawai jũrr chi Simonau Jesuug, —Maestro, magan mʌrʌg jaaubarim ¿k'an hagá? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Magbaawai Jesuu jaaubaadëjim haajem hirig. Mag jaaumamua, —Biek hãb wounau hõor numiim k'ʌʌnag p'atk'on prestaajimgui hajim hanʌm: hãbak'aíg cien denarios deewia warmʌg diez denarios deejim. ");
INSERT INTO noaH_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mamʌ hamau p'agpʌ̈yaag chuk'u narr haawai, “Hidëu mua sĩi hich jãg hok'oopik'im; hoob mʌrʌg p'agmiet” hajim hanʌm, chi mork'ʌʌu. Mag jaauwia Simonag, —¿Chijãgua pua k'ĩirjuawai hʌ̃rcha hi daupii haju k'ai? ha jëeujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Magbaawai Simonau, —Mua hoowain chi p'atk'on dʌ̈rrcha paraa sĩerraujöo simgui hajim hanʌm. Magbaawai Jesuu jũrr hirig, —Simón, maiguin chadcha pua hag heyaa jaaubarmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Magnaa chi hʌʌirag heerpanaa Simonag magjim haajem: —Simón, ¿pua mʌg hʌʌi hoo chirabá? Pʌdë k'ĩirjubarí. Pʌ di haig mʌ barcheewai pua mʌrʌg dödamjã jöi deebajimgui hajim hanʌm, mʌ bʌ̈ sũgamk'ĩir. Mag k'ãyau mʌg hʌʌirau hich dauchöoupai mʌ bʌ̈ hompʌ̈iwia hich pörbʌ̈ʌupai deeu jãrbapʌ̈im. ");
INSERT INTO noaH_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mʌ barcheewai pua mʌ k'ĩir hʌ̃ʌnaa, “Pʌ hʌ̈u bëejimjã” habajimgui hajim hanʌm. Mag k'ãyau mʌg hʌʌirau mʌ barchëtarr haigmua hich mag mʌ bʌ̈ hʌ̃ʌ hahauk'am. ");
INSERT INTO noaH_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pua aceitedamaujã mʌ pör p'uurbajimgui hajim hanʌm, mʌ barcheewai. Magtarr mʌg hʌʌirau jʌ̃gdeeuchata mʌ bʌ̈ gaai choowia p'uurpʌ̈ijimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hĩs mʌgbarm pʌdë k'ĩirjubarí hajim hanʌm, chi Simonag. Mʌg hʌʌirau mʌ dʌ̈i mʌgbaichëmʌn hich pekau pöoma sĩerr t'um chugpaabapʌ̈im jũrrta “Hʌ̈u hajim” ha sim k'abahab. Chi pekaujã bʌ̃rʌʌm k'aba harr haawai hichdëu hagjö dʌ̈rrcha mʌ k'a k'õsi hʌm ha sim k'abahab hajim hanʌm, jãg sim haig. Hich jãgta sĩebahab cha mua pʌrʌg nem hĩgk'a chirʌmjã. Hãbmua k'ãijã hichig dëbpaar paar nʌm k'ʌʌnag tag p'agpiba perdonaamʌn, chi dëbpaar pöomacha sĩerr garmua hʌ̃rʌʌcha hi daupii haju. Maagwai bʌ̃rʌʌpai paraa sĩerrau hi daupii hajup mamʌ, warm dënjöcha k'abaju. Magua hich perdonaatarrpierrpai sĩi hirig “Hʌ̈u hajim” hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Maimua jũrr chi hʌʌiragta hoonaa, —Pʌ k'aibag t'um chugpaa sĩsimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Magbaawai hi dʌ̈i hãba hohoodö narr k'ʌʌnau hamach wir haigpai hiyʌ̈ʌ nʌmua, —Keena, ¿mʌ chijãg woun hagá, jãg pekaupa chugpaa sim? hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mamʌ hamau mag k'ĩirju nʌmjã higba warag chi hʌʌiragta, —Hoob k'ĩirjum. Hʌ̈u pʌ peerdʌ hʌisimgui hajim hanʌm, pʌchdëu hʌ̈k'atarr gaaimua. Pʌch diig maju haai hʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Maigmua maau Jesús p'öbörpierr nʌrrʌmua hĩchab p'öbör chaaur didam k'apan k'aba k'ëk'ëdʌm heem magwe nʌrrajim haajem, maach peerdʌajem hiek jaauwai. Mag jaau nʌrrʌmua, —Hẽwandamta ya t'umaam k'ʌʌn pörk'aimʌʌ sim. Pãar peerdʌm k'õsi nʌm k'ai, hirigta hʌdʌraa pãach p'ẽet'ʌgpibat haajeejim hanʌm, hichta pãach Pörk'amk'ĩir. Hi dʌ̈i hĩchab wënʌrrajim haajem hichdëu doce jʌr hautarr k'ʌʌn, ");
INSERT INTO noaH_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","maimua hĩchab hʌʌin hichdëu ham mor heem mepeen jʌr wërpnaa sĩi k'ajap'am k'amor machagau sĩsid harr monaauk'apʌ̈imatarr k'ʌʌnjã hagjö. Chi hʌʌin mag hi dʌ̈i wënʌrrarr k'ʌʌn, dau hãb María hajim haajem hĩchab ham dën Magdalena haajerr. Hich mag hʌʌi mor heem hajim haajem Jesuu mepeen siete jʌr wërptarr. ");
INSERT INTO noaH_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hãbak'ai Juana hajim haajem, woun Chuza hanʌm hʌʌi. Hich mag woun Chuza hanʌmuata rey Herodes nem t'um hich dënjö k'ap'ʌ haajeejim hanaabá. Maimua hãb hagjö nʌrraajeejim haajem, Susana hanʌm. Maimua mag tag hʌʌin k'apan hagjö t'ʌnaajim haajem, hamach di haarmua nemdam haibëe nʌm hiiu, hi jãhog wai wënʌrraajerr k'ʌʌn. ");
INSERT INTO noaH_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mag Jesús p'öbörpierr maach peerdʌajem hiek jaau nʌrrʌm jaar, k'ãai hãb p'öbörpierram k'ʌʌn hi haig bëejierram haajem. Maimua t'um hãbam haig biirdʌbaadeewai hamag nem hĩgk'amamua magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Biek hãb woun nemjĩir dau p'oon majim haajem. Maimua mag mawia p'ö nʌrrʌmua hãaur chi nemjĩir daudam bʌ̈ diichjem hee burrtarr bʌ̈ʌu jẽb hee joot'ʌgmam dʌ̈i nemchaain bëewia sĩi k'ök'ʌʌipʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Maimua hãaurag mokpör jojoodög hee burrtarr t'arrp'ëjim hanʌm, mamʌ mag perasöm jẽb durrk'u hʌ̃rʌʌ sĩerr haawai jẽb jʌsarm gaaimua pöd k'aar k'aba, sĩi p'ua k'ëchjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mag p'ö nʌrrʌmua hĩchab hãaur k'ʌʌn miudö harr hee burrjim haajem. Mamʌ chi miuta hʌ̃rpabaadeewai nemjĩirdam hõt k'aba, sĩi hich magpai hap'ʌʌ nʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Maagwai tagam k'ʌʌn jẽb wajaug hee burrjim haajem. Mak'ʌʌnan chadau höbërwia chëbaadeewai k'aarpierr bich t'ʌʌ jopmajim haajem. Mag jaaumamua, haig narr k'ʌʌnag, —Keena, jʌ̃g hʌ̃rʌʌnaa chamʌg nem hĩgk'aadam mua jaau chirʌm hajap'a hũrbat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Magbaawai hi k'apeenau hirig jëeumamua, —Cha pua nem hĩgk'aadam jaau dichdimam, ¿k'an haawaiuma? Marau pöd k'augba habarm, marag jaaubá hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Magbaawai hichdëu magjim hanʌm hamag: —Pãrau k'augam k'õsi hũr naawai, mʌchdëun warre pãrag k'ap'ʌ hapiejem, jãgata Hẽwandam hõor t'ãar hee sĩeicheejẽ. Mamʌ warm k'ʌʌnagan sĩi k'ajap'am nem hĩgk'aadamjöpaita hĩgk'aajemgui hajim hanʌm, hamau hoo nʌmta hoobamjö hamk'ĩir, maimua hũr nʌmjã bʌ̃ʌrjã k'augbamjö hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Maimua hamag, ’Mua pãrag jaauk'imgui hajim hanʌm, hich Jesuu. Pãrau pãachig jaaupi nʌmʌn mʌgaugui hajim hanʌm: Chi nemjĩir dau wounau p'öt'urtarr, Hẽwandam hiek hõrag jaau nʌmta jaau simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Maagwai chi nemjĩir dau k'ʌdjã hee burrmarr, hõor Hẽwandam hiek sĩi par jʌ̃gʌupai hũurjem k'ʌʌnaugui hajim hanʌm. Hamau Hẽwandam hiek jaau nʌm hũr nʌm, mamʌ meperau bëewia k'ũgurbaicheewai hũrba harrjö t'ãar hee Hẽwandam hiek chuk'u t'ʌba nʌm, k'ʌdjã heem nemjĩir dau nemchaainau k'öpʌ̈itarrjö. ");
INSERT INTO noaH_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Maagwai mokpör jojoodög hee nemjĩir dau burrmarr, har maach k'apeenau Hẽwandam hiek hũurwai honee hʌ̈k'aajem k'ʌʌnaugui hajim hanʌm. Mamʌ t'ãraucha hʌ̈k'a nʌm k'aba haawai, nemjĩir dau pöd k'aar k'aba haajemjö k'ũchpai hʌ̈k'awia hiseg pʌajem. Maagwai hʌ̈k'a nʌm hanʌmta mag hiek hajap'am gaaimua meperau k'aigba haicheewai deeu Hẽwandam hiekta hisegwia warr hamach naajerrjö wënʌrram k'õsi nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Maagwai nemjĩir dau sirp'ʌg dʌ̈i höbërwia hõt k'aba bãautarr, jũrr har maach k'apeen hihãsisisdöm k'ʌʌnta jaau simgui hajim hanʌm. Hamau Hẽwandam hiek hũrm k'õsi hũr nʌm, mamʌ deeu hamach k'ĩirjug heepai, “Jãgʌm gaaimua pöd mʌ p'atk'on hauba k'ãijã chitaju,” wa magbam k'ai, “Mua chadcha hʌ̈k'ak'iinjã pöd parhooba mʌchdëu hampierr habaju” ha k'ĩirjuajem. Mag gaaimua mag nemjĩirdam hap'ʌʌ bãauwia pöd chëba harrjö hĩchab Hẽwandam hat'ee nem hajap'a wawaagjã pödba, sĩi serbiibata nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mamʌ jũrr chi nemjĩir jẽb hajaug hee burrtarr, har hõrau Hẽwandam hiek hamach t'ãraucha hʌ̈k'aa chaar hʌ̈k'aajem k'ʌʌnta jaau simgui hajim hanʌm. Magʌm k'ʌʌnau sĩi par jʌ̃gʌupai hũrba haajem. Hamachdëu hʌ̈k'a nʌm gaaimua dau haug wauju hak'iinjã, majã ham gaai mas k'aba simgui hajim hanʌm, Hẽwandam hat'ee nem hajap'a waum k'õchgau. ");
INSERT INTO noaH_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ya pãachig jaaubaawai pãrau k'ap'ʌ nʌisim, mamʌ hĩchab mʌg pãachdëu hũrbarmjã pãrau sĩi pãach hat'eepai wai naaju haai k'aba nʌmgui hajim hanʌm. ¿K'aíu hõtdau paanaa bat'ẽe heegar wa sĩi nem bʌ̈ hee k'ãijã hausĩiujẽ? Hõtdaun paanaa warre dijã garta hausĩiujemgui hajim hanʌm, t'umaam k'ʌʌn dau hararaa hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hĩswe chan hõrau hagt'a hajap k'augba nʌm, jãga Hẽwandamau hõor peerdʌ hauju. Mamʌ mʌg hatagta hamach daúacha hõt bʌ̈ʌg nem waibëenaa hoo nʌmjö hamau k'ap haju. Chi mag k'augba nʌm k'ʌʌnan hagt'a k'ĩchag hee nem hoo nʌmjöta nʌm, bʌ̃ʌrjã k'augba. ");
INSERT INTO noaH_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Hajap'a k'ĩirjubat hajim hanʌm, jãga pãrau hũr nʌ. Har chi t'ãar honee hũrm k'õsi hũr nʌm k'ʌʌnag Hẽwandamau warag k'ĩirjug deeju, hich hiek k'apcha hamk'ĩir. Mamʌ har hũrmap'apai hũr nʌm k'ʌʌn k'ĩirjug heemʌn, cha mua jaau chirʌm deeu Hẽwandamau hich hiek sĩepiba k'echeu haujugui hajim hanʌm, hũrmap'a naawai. ");
INSERT INTO noaH_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mag nʌm hee hich Jesús hãd hich chaain dʌ̈i hi haig bëejierram haajem. Mamʌ hõor pöm wëjöm k'urau pöd hi sim haarcha dubba, daaugajãrpai naaichëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Magbaawai hõrau hirig, —Pʌ heeugpeen pʌ hãd dʌ̈i daaugajãr nʌm. Ham hiek pʌ dʌ̈i hoom k'õsi nʌm haajem hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mamʌ magbaawai hichig mag jaauchëtarr k'ʌʌnag Jesuu magjim: —Mʌrʌgan mʌig Hẽwandam hiek hũrwia hag hipierraa nʌm k'ʌʌnta hĩchab mʌ heeugpeenjönaa mʌ hãdjö sĩsidʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Maimua biek hãb Jesuu hich k'apeenag, “Dök'ĩrag wëttarrau” hawia, chadcha döjãrr paauk'abaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Maimua ya ham mag döjãrr k'odjörröm hee, hich Jesús k'ãibaadëjim hanʌm. Mag hi k'ãi jörrömta, p'ũhãd pöm bëewia p'ũasdau dapag baupa haadeewai sosook'amua japau hãwatbajujö haadëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hamachdëu mag hoop'öbaadeewai hi k'ãi jörröm haar mawia, —¡Maestro, p'iidʌbaad! Ya maachin k'öogpamgui hajierram hanʌm. Magbaawai p'iidʌwia, p'ũ t'eeg t'ʌnʌmʌg meeurrau sĩunaa, hĩchab chi p'ũasagjã meeurrau sĩubaawai, tag p'ũjã wëba p'ũasdaujã baupa k'aba, warre sĩi döjã meuu jöisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Maimua jũrr hichdëu hamag, —Keena hajim hanʌm, ¿mʌg pãar mʌ dʌ̈i k'odjörrömjã nem hök'öta nʌ? Jãgan pãrau chan mʌ pãach dʌ̈i chitʌmjã k'augbata naab hajim hanʌm, jãgcha jãp'ierraag. Mag hamach dak'ĩir p'ũ dʌ̈i p'ũaspa warre t'umba hat'am hoobaawai jãp'ierrnaa dauderraa nʌmua hamach happai hök'arii, —Keena, ¿k'anim wounta mʌg p'ũugjã hiek'anaa p'ũasagjã hiek'aawai hi hipierraa haajẽma? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mag wëtmamua k'odjörröo hawia Gerasa durr barjierram haajem, hich hag t'ʌrrdö heepai t'oom higar Galilea k'ĩirp'ee. ");
INSERT INTO noaH_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mag Gerasa durr barimawia Jesús durrpabaadeewai hi k'ĩirp'ee woun hãb p'öbör heemua höbërchëjim haajem. Mag woun hich warrgarwe dösãt bënëu sĩpwia hich mag bar nʌrraajeejim hanaabá. Mag gaaimua nawe degmua mawi, tag degjã k'aba, hãba hujã hʌ̃rpai k'ãinaa, k'ajũa k'arraa hich mag sĩerrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mag wounau Jesús hoo hat'aawai dëgölp wiiu ha hi bʌ̈k'ʌrr p'õbk'abaimawia chaigpamamua t'et hirig magjim hanʌm: —Jesús, Cha Hʌ̃gt'aa P'uu Nʌm Hiewaa, ¿k'ant'eeta pua mʌ mʌgbaichëma? Hoob mʌ chig ha chiram hajim hanʌm, chi mepeer garmua Jesuu hichig woun mor heemua höbërpi jaaubaawai. Mag chi mepeer hajap t'ierrpa sĩerr haawai hʌ̃iba baarjeejim hanaabá. Mag barbaadeewai parii cadenau jʌ̃naa grillos hanʌm heejã bʌ̈ k'õok'a sĩsiuk'amjã hi hat'eem k'aba haajeejim hanʌm. Sĩi warag caden t'ʌrrëupʌ̈iwia hõor chukag haar warp warrjeejim hanaabá, chi meperau. ");
INSERT INTO noaH_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Maimua Jesuu hirig, —¿Pʌ k'an ha t'ʌ̃ʌrjẽ? hajim hanʌm. Magbaa chi wounau, —Mʌʌn “Mepeen P'öbör” ha t'ʌ̃ʌrjemgui hajim hanʌm. Hirua mag sĩerran, bën pöm hich mor hee dubchë t'ʌnʌm wai nʌrraajerr haawaita mag sĩejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Magbaawai chi mepeen woun mor hee mag t'ʌnarrau Jesuug, —Hoob warre k'ĩmie durr chan maar pʌ̈i chiram. ");
INSERT INTO noaH_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mag k'ãyau har k'ũsnaan p'at'au k'ö wënʌrrʌm heeta hidëu maar dubpibá hajierram hanʌm, hag dak'a k'ũsnaan k'apan t'ʌnarr haawai. Magbaawai Jesuu hamag hʌdʌraa k'ũsnaan heeta dubpijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Magbaa chadcha woun mor hee mepeen pöm mag t'ʌnarr höbërdʌtk'awia jũrr k'ũsnaan hee naaimaawai, k'ũsnaanta parhooba k'ap'ig p'öbaadëwia hit'urmʌg hʌ̃rmua t'ʌrrdö pöm wëjöm hee dʌrbagk'a sĩi k'ẽu k'uurbʌ k'ëchjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Magbaa chi k'ũs t'ʌa narr k'ʌʌnau hamachdëu mag hoobaawai jãp'ierrwia p'öbörög k'ap'ig p'öbaadëjim hanʌm, hõrag jawaan. Mag wëtumua hĩchab p'öbör chaauraa di nʌnʌidʌm heem k'ʌʌnagjã jaaumajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mag p'öbör hee jaaubaimaawai, chadcha haar hoon weetwai, chi woun mor hee bën pöm wai sĩerr wajap'a k'ajũa jũanaa, hag na magba haajerrjö, sĩi ya maach k'ĩir hich mʌg Jesús k'ĩirp'ee jup sim hooimajierram hanaabá. Hamachdëu mag hoobaimaawai jãp'ierraa hap'öbaadëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Magtarr chi hootarr k'ʌʌnau jũrr chi hoon bëe nʌm k'ʌʌnag jaau naajim hanʌm, jãga mag woun dösãtau mag wai nʌrraajerrta hʌ̈u Jesuu monaaupʌ̈ijĩ. ");
INSERT INTO noaH_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Magbaawai Gerasa perasöm k'ʌʌn pöm haig t'ʌnarr k'ʌʌnau jãp'ierr nʌmua Jesuug chawag mapi jaau naajim hanʌm, hamach hee sĩepiba. Mag chadcha, Jesús jap hee pabaadëjim haajem, deeu hamach berrag wëtaag. ");
INSERT INTO noaH_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mamʌ mag ham wëtaagpam hee, chi woun mag dösãt bënëu baarjerrau Jesuug jëjëeu haajeejim hanaabá, hi dʌ̈i maag. Mamʌ Jesuu hi harrba warag hirig, ");
INSERT INTO noaH_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Pʌch diigta petá, maimua t'umaam k'ʌʌnag jaaupet hajim hanʌm, jãga Hẽwandamau hʌ̈u pʌ heeg hoowi pʌ monaaubar. Hichig magbaawai chadcha p'öbör hee petawia hich mag jajawag majim haajem t'umaam k'ʌʌnag, jãga Jesuu hi dau haug k'augwia hich bën chugpaapʌ̈itarr. ");
INSERT INTO noaH_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mag Jesús deeu hich k'apeen dʌ̈i jap hee pawia Galilea durr barimaawai hõor pöm sĩi hi nʌ k'odt'ʌnaajim haajem. Mag hi barbaimam hoobaawai t'umaam k'ʌʌnau hirig, “Hʌ̈u pʌ bëejim” hanaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Mag hi barbaimam hee, woun hãb judionaan Hẽwandam hiek jaaujem di t'ʌajem Jairo ha t'ʌ̃r sĩerr hi haig bëejim haajem. Mag woun chan tag chaaijã chuk'u, hãba chaai hʌʌik'aardam doce añosjö sĩerrdam happai k'itʌmta ya meemaa hajim hanʌm. Mag tag chaaijã chuk'u hãbpai k'itʌm meemaa haawaita Jesús bʌ̈k'ʌrr p'õbk'anaa hö bʌ̃rʌʌ haichëjim hanʌm, hich di haar harrwia mag hich chaai mor mas k'ërʌm monaaupʌ̈imk'ĩir. Mag hich haig hö bʌ̃rʌʌ haicheewai, ya hagʌg wëtumta, warag hõrau ham p'ẽeudʌ harrmaa hajim hanʌm, pöd majujã k'aba. ");
INSERT INTO noaH_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mamʌ hõor pöm mag t'ʌnʌm hee, hĩchab hʌʌi hãb sĩejim haajem, doce años sĩi p'õmieu bar sim. Mag hʌʌirau hich p'atk'ondam t'um gastaapʌ̈iwia sĩejim hanaabá, doctornaanag hich hëwaupi simua. Mamʌ hãbmuajã pöd hi monaau hauba haajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mag hʌʌi mag simua Jesús hëugarmua bëewia hi k'ajũahidam gaaipai pʌrchëjim hanʌm. Mag hirua pʌrbarm bʌ̈rre chi p'õmie t'ʌbabaadeewai warre hich mag monaau sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Magbaawai Jesuu, —¿K'aíuta mʌ gaai pʌrbaichëma? hajim hanʌm. Mamʌ hãbmuajã jaauba haawai Pedroou hich k'apeen dʌ̈imua, —Maestro, k'aíu habarjugui hajim hanʌm. Pʌch haig hõor p'ẽeudʌdʌk'am k'ʌʌnau k'abahab, pua mag chirʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mamʌ Pedroou hichig magbaawai warag Jesuu, —Hʌ̃hʌ̃, sĩi hõor p'ẽeudʌdʌk'amua k'abam. Mua k'ap'ʌ chirʌmgui hajim hanʌm, juau hogt'omta hãbmua mʌig mʌ gaai pʌrbaichëm. Mag pʌrbaicheewai Hẽwandam juapá mʌ gaai simua monaaubapʌ̈imjã mua k'ap'ʌ chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mamʌ chi hʌʌirau hũurwai hichdëu meraa pʌrchëtarrta Jesuu mag hijẽb haadeewai, k'ĩir naau nʌm hiek'au, bʌ̈ duui bëewia hi bʌ̈k'ʌrr p'õbk'achëwia, meerba hõor t'umaam k'ʌʌn dak'ĩir jaaubaadëjim hanaabá, k'an hat'eeta hirua mag hi gaai pʌrchëjĩ, maimua jãga mag pʌrbarm bʌ̈rre hi monaau hʌisijĩ. ");
INSERT INTO noaH_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Magbaawai Jesuu hirig, —Hoob chigaa ham hajim hanʌm. Mua pʌch monaauju k'ap'ʌ mʌ gaai pʌrchëtarr gaaimua hʌ̈u pʌ monaauwia peerdʌ hʌisim. Pʌch diig maju haai hʌmgui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mamʌ hagt'a mag hi hiek'a höba nʌm hee, woun hãb bëejim haajem, mag judionaan Hẽwandam hiek jaaujem degam chi pör Jairo hanʌm di haarmua, hi hẽudee. Mag bëewia chi Jairoog, —Kakë, ya haaunaanaujã pöd hãwatba habarm. Hidëu Maestro sĩubá. Ya par maach haar hi mabajup haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mag jaaubaichëm hũrbaawai Jesuu magjim hanʌm chi Jairoog: —Hoob k'ĩirjum. Pua pʌch chaai hʌ̈u hoo wai chitaju. Sĩita hãba murua pʌch chaai monaauju k'ĩirjugta wai chirsí hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Maimua warag wëtwia di haar barimajierram haajem. Mamʌ t'uur k'ërʌm hee chi binaandam wai narr haar chan hich dʌ̈i hõor k'apan dubpiba, hãba chi dubtarr k'ʌʌnan, Pedro, Juan, Santiago, maimua chi haai chi hãd dʌ̈ipaita hich dʌ̈i dubpijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mag barwia hooimaawai, t'umaam k'ʌʌn sereeu hicharaucha bĩe nʌm dʌ̈i hĩchab hʌ̃apëpërk'amta hooimajim hanaabá. Mag hoobaimaawai Jesuu hamag, —Hoob bĩemiet'ʌ̃. Hi meeba sĩita hi k'ãi sĩebahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mamʌ hirua magbaawai, haig narr k'ʌʌnau warag hi wau hiek'a naajim hanaabá, hamachdëu chadcha chi chaai mee sim k'ap'ʌ narr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mamʌ hamau mag nʌmjã hũrba, warag dubwia chi binaan juadam gaai pʌrnaa, —¡Hʌʌik'aardam, p'iidʌbaad! hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Magbaawai hi hak'aardam deeu hi gaai k'ëraicheewai hag bʌ̈rre p'iidʌbaadëjim hanaabá. Mag p'iidʌbaadeewai hirig t'achdam hau deemk'ĩir jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mag p'iidʌbaadëm hoobaawai chi dënnaan k'ĩir hëu hawia warre dauderraa nʌisijim hanʌm. Maimua hichdëu magwia haig narr k'ʌʌnag, —Hĩs pãachdëu mʌg hoobarm hoob chik'amnag jaaumiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Maimua Jesuu hich k'apeen doce hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌn hãbam haig t'ʌ̃rk'anaa hagdaujö juapá deemajim haajem, hich dënjö hõor mor heem mepeen jʌrk'ʌʌinaa mor masim k'ʌʌnjã monaau wënʌrraju hayaa hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mag pʌ̈yaagpamua hamag magjim hanʌm: —Mua pãar pʌ̈i chirʌm, hõrag “Hẽwandamta t'umaam k'ʌʌn Pörk'aimʌʌ sim” ha jaaumk'ĩir, maimua hĩchab hamag “Pãar peerdʌju k'ai hirigta hʌdʌraa pãach Pörk'apibat” ha jaau wënʌrramk'ĩir. Mag wënʌrrʌmua hĩchab k'amor machagjã t'um pãrau monaau wënʌrrajugui ha jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Maimua hĩchab hamag, ’Pãach jua k'arr hërëubaadët, bʌ̃ʌrjã nem hinag harrba: bordón chuk'u, talegdijã chuk'u, ni t'ach ni p'atk'onjã hoob harrmiet; hich jãg hërëubaadët hajim hanʌm, k'ajũa t'eg jũajujã chuk'u. ");
INSERT INTO noaH_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maimua pãach wënʌrrʌmpierr pãachig di jaaubarm degpai k'eeupaawai k'ãibat hajim hanʌm, pãach maigmua wët nʌm hora. ");
INSERT INTO noaH_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mamʌ p'öbör hee ni hãbmuajã pãach hamach deg dubpiba ni pãach hiekjã hũrba habaawai warre hamach dak'ĩirwe pãach bʌ̈ gaaim jẽb hʌʌrp'ë hʌʌrp'ënaa pãachta hërëubaadët hajim hanʌm. Pãrau magmʌn magbarmuapai hamag “Pãachdëu jãg Hẽwandam hiek hũrba habarm gaaimua hich dʌ̈ita k'ĩir k'ap habat” hanʌmʌugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mag, chadcha Jesuu hamachig mag jaaubaawai hërëubaadëwia p'öbördampierr jãga Hẽwandamau maach peerdʌajẽ ha jaau wënʌrrʌm dʌ̈i hĩchab durrpierr haaunaanpa monaau wënʌrrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rey Herodes hanʌmua hũrbaadëjim haajem nem t'um Jesuu wau nʌrrʌm. Mag hichdëu hũrbaadeewai k'ak'aisamjö haadëjim hanaabá, jũrram k'ʌʌnau “Juan chi hõor pör choomieta hiiu p'iidʌwia nʌrraichëm” ha jaauchëchëk'am hũrwia. ");
INSERT INTO noaH_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mag nʌm dʌ̈i hirua hũurwai hãaur k'ʌʌnau jũrr, “Elías warrgar Hẽwandam hi jaaujerrta höbërchëwia jãg nʌrrʌm haajem” ha jaau nʌm dʌ̈i hagjö bigaaum k'ʌʌnau jũrr, “Elías k'abam k'ai jãan chadcha jöoingar Hẽwandam hiek jaaujerrta deeu p'iidʌwia jãg nʌrrʌm” ha jaauchë naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mag bĩi wëjöm hũrwia chi Herodeeu hich hödegpai, “Keen, magaag Juanan mua hö t'ʌappʌ̈ipitarrau. Magan, ¿k'ai hajuma hõrau mag bĩi t'ʌnʌm?” haajeejim hanʌm. Mamʌ parhooba mag jaau t'ʌnʌm gaaimua hichdëuchata hi dʌ̈i hoom k'õchag sĩejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mag doce hich Jesuucha pʌ̈itarr k'ʌʌn wënʌrrʌʌ hawia bardʌtk'acheeu hamachdëu nem wau wënʌrrarr t'um hirig hĩgk'achëjierram haajem. Magbaawai chi Jesuu chawag ham p'ë harrjim haajem, p'öbör Betsaida hanʌm higaau hõor chukag hee. ");
INSERT INTO noaH_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mamʌ hõrau mag hi petam k'augpʌ̈itarr haawai hi hẽudee pochag wëtjim hanʌm. Mag wëtwia hich haar bardʌtk'abaimaawai Jesuu hamag, —Hʌ̈u pãar bëejimgui hawia, warag hamag, Hẽwandamta t'umaam k'ʌʌn Pörk'aimʌʌ simgui hajim hanʌm. Pãar peerdʌju k'ai, hirigta hʌdʌraa pãach Pörk'apibat ha jaaumajim haajem. Mag jaaumamua hĩchab mor masim k'ʌʌnpa monaaupʌ̈imajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mag hõor monaaupʌ̈pʌ̈ik'am hee, warag hedau k'ëuju gar pabaadeewai chi doce hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnau hi haig bëewia hirig, —Mʌig maach hõor chukag heeta nʌpí, p'öbör hee wa di dak'a nʌnʌidʌm hee k'ãijã hamag wëtpi jaaubá hajierram hanʌm, magʌm haar t'achdam k'öwia k'ãimk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mamʌ magbaawai Jesuu jũrr hamag, —Ham pʌ̈iju k'ãyau, pãachdëuta hamag t'ach deebat hajim hanaabá. Magbaawai jũrr hamachdëu magjierram hanʌm hirig: —Maar k'öju chuk'u nʌm hamag deeg; hãba pandamta cinco wai nʌm dʌ̈i hãwarrdamta dau numpai wai nʌm. ¿Jãga hõor pöm mʌg t'ʌnʌm marau jãhogbarju? ¿Wa p'öbör heeta marau k'öju për hawaan wëtjuwa? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mag hõor pöm t'ʌnʌm hee hemk'ooin happai cinco miljö naajim haajem. Magbaa Jesuu hamag, —Hõrag jaaubat hajim hanʌm, hãbam haigpai poso de cincuenta en cincuenta k'ĩk'ĩratdö jupk'amamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mag chadcha hi hipierraa hõrag jaaubaawai t'um hich mag poso p'ʌʌr hohood hap'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Magbaawai hich Jesuu mag pan cinco narr chi hãwarrdam numpai narr dʌ̈i hãba p'ë hauwia, hʌ̃gt'aag heerpanaa, Hẽwandamag hʌ̈u hajim hanaa, t'orreuwia, hich k'apeenag hʌapʌ̈imajim haajem, jũrr hõrag jigmamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mag jigmamua t'umaam k'ʌʌn biwaauwia himie p'öbaadeewai chi pan hãwarr dʌ̈i sobtarrau t'ʌbʌt doce hipiirk'a haujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","K'ãai hãb Jesús hich dʌ̈i doce hogdʌba wënʌrraajerr k'ʌʌn dʌ̈i hõor chukag hee mawia Hẽwandamag jëeu sĩejim haajem. Mag jëeu dichwia hamag, —Hõrau mʌ higwia hiyʌ̈ʌ nʌm hũurwai, ¿ham hiek mʌ k'ai haajẽ? ¿Pãrau hũrba haajẽ? ha jëeujim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Magbaawai hamachdëu magjierram haajem: —Ham hiek pʌ Juan chi hõor pör choomie haajem; deeum k'ʌʌnau jaauwai, pʌʌta Elías haajem, warrgar Hẽwandam hi jaaujerr; maagwai pogk'a jaauwai pʌ sĩi warrgar hagjö Hẽwandam hi jaaumie harrta deeu hiiu p'iidʌwia nʌrraichëmjã ha jaaujem ham dën hajierram haajem jũrr hirig. ");
INSERT INTO noaH_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hichig magbaawai, jũrr hamachigcha, —¿Ma pãachdëujãma, pãrau k'ĩirjuawai mʌ k'ai hagá? ha jëeujim hanʌm. Magbaa Pedroou hirig, —Pʌʌn Cristoou, har warrgarwe hich Hẽwandamaucha hõor peerdʌ haumk'ĩir pʌ̈iju jaaujerr hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedroou hichig magbaawai, —Chadcha pua hag heyaa jaaubapʌ̈imkë hajim hanʌm, mamʌ hoob bʌ̃ʌrjã chik'amnag jaaum hajim hanʌm. Warm k'ʌʌnagjã jaaupibajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Maimua magjim hanʌm: —Mʌch chi Hemk'ooi Hiewaa chadcha dau hap'ʌʌ haju haai chirʌm. Mʌ dau hãauk'a hisegwia Jerusalenpie jöoin chi t'et'em k'ʌʌnau p'adnaan chi pörk'a nʌm k'ʌʌnaupa Moisés hiek jawaag chi machnaan dʌ̈imua mʌ t'õomk'ĩir pʌr deeju. Mamʌ mag hamau mʌ t'õowiajã k'ãai t'ãrjupam hee p'iidʌwia deeu mʌ hiiu chirsijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Maimua t'umaam k'ʌʌnag heerpa heerpanaa, —Chadcha pãrau mʌ hiek pãach t'ãraucha hʌ̈k'a nʌm k'ai, magan mua nem waupi jaau chirʌm happaita waubat hajim hanʌm, “Mʌchdëuta k'ap chirʌm mʌchdëu nem wauju” ha hiek'aba. Mʌ gaaimua chik'amnau pãach dau hap'ʌʌ t'õoju k'ĩirjuwia k'ãijã magʌm higba, waragta hʌ̈k'anaat. ");
INSERT INTO noaH_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Har chi mʌg jẽb gaai mʌ gaaimua bʌ̃ʌrjã p'it'urg haumap'a wënʌrrʌm k'ʌʌn chan meem hedjã hʌ̃gt'ar höbërbamgui hajim hanʌm. Magarrau har chi mua nem jaau chirʌm waum k'õchgauta hamach nemjã k'ĩirjuba sĩi warag mʌ gaaimuata dau hap'ʌʌ hanʌm k'ʌʌnan chadau hʌ̃gt'archa höbërjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pãrau hoowai, ¿k'an hajaug sĩ hajim hanʌm, woun hãbmua mʌg durr t'um hichdëupai jʌ̃a wai sĩsim, mamʌ mag sim meebaadee k'ĩmie durr petam; hirua hich durr t'um hich dʌ̈i harrju haai sĩ? Pöd harrbamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hãb k'ãijã mʌ gaaimua wa mʌ hiek jaauju k'ãijã hõor dak'ĩir chigaa hamʌn, mag mʌch chi Hemk'ooi Hiewaajã t'umaam k'ʌʌn Pörk'anaa mʌch Haai dʌ̈i hʌ̃gt'ar hi chognaan t'ʌnʌm k'ʌʌnpa mʌg durr chachaan bëem hedjã muajã hĩchab hich k'ĩircha heerpanaa chigaa warag, “Mua, bʌ̃ʌrjã pʌ k'augba chitʌm” hajugui hajim ");
INSERT INTO noaH_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cha mʌ hiek'a chirʌm hiek'au hãaur k'ʌʌn cha mʌ hiek hũr nʌm k'ʌʌn chan mʌchta t'umaam k'ʌʌn Pörk'a bëeju hedamjö haadëm hoobam haigjã meebajugui hajim haajem Jesuu hich k'apeenag. ");
INSERT INTO noaH_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mag hich k'apeen hãaur k'ʌʌnag hamach daúa hich hoopiju jaautarr k'ur seman hãbjö nʌm hee, durrsĩ gaai Hẽwandamag jëwaan mamua hich dʌ̈i p'ë harrjim haajem Pedro, Santiago maimua Juan. ");
INSERT INTO noaH_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mag mam wëtwi hich Hayag jëeu simta, dëgölp sĩi bʌ̃ʌmjö haadëjim hanaabá, hich mor gaai k'ajũa jũa sĩerrpa. Maagwai chi k'ajũa chará sĩi p'uumjö haadëjim hanʌm, hich bäpgau. ");
INSERT INTO noaH_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hi magbaadëm hee wounaan numí hi bigaau dʌnʌʌutk'achëwia hi dʌ̈i hiyʌ̈ʌ naajim haajem. Mag hi dʌ̈i hiyʌ̈ʌ narr k'ʌʌn, jöoingar Moisés k'ararr hajim haajem Hẽwandam hi jaaumie Elías k'ararr dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mag ham hiyʌ̈ʌ dʌnʌnʌidʌ haichëm dʌ̈i hĩchab pagt'ʌm daujö p'ʌr jẽer hat'amua mag hãsdaau narrta sĩi warag harar ham wʌʌ wai sĩsijim hanaabá. Ham hiyʌ̈ʌ narran, hich Hẽwandamaucha warrgarwe hich hi jaaumienag jaautarrjö, Jerusalén p'öbör hee hõrau hi t'õojuuta hig hiyʌ̈ʌ naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mamʌ maagwai Pedro hich k'apeen numí hamach hãba wënʌrrarr k'ʌʌn dʌ̈i sĩi dap'ökgau pöd dau hẽebajujö t'ʌnʌmuata hoo naajim hanaabá, mag Jesús Moisés dʌ̈i Eliapa hiyʌ̈ʌ dʌnʌnʌidʌ nʌm. Maagwai hich Jesuun hagt'a sĩi bʌ̃ʌmjö t'ʌnʌm dʌ̈i hi k'ajũa chará p'uumjöta t'ʌnaajim hanʌm, hich bäpgau. ");
INSERT INTO noaH_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mag hãba dʌnʌnʌidʌ naawia chi warm k'ʌʌn hi haigmua wëtaag hẽk'a nʌm hee, Pedroou hirig, —Maestro, hʌ̈u chi hagamjö nem hajaug maar mʌig nʌm, ¿jãgwia maadëu rãichdi t'ãrjup hëu haubá? hajim hanʌm, hãb pʌ hat'ee, hãb Moisés hat'ee maimua hãb Elías hat'ee. Mamʌ mag sim chan Pedroou hich hiek'a simjã k'augba simta mag hiek'a dʌnaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mamʌ mag hi hiek'a dʌnʌm hee, jʌʌnt'umie baug bëewia ham jöodʌ hat'aicheewai jãp'ierr p'öbaadëjim hanaabá, hag hee hierr paauk'abaadëm hoowia. ");
INSERT INTO noaH_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mag jʌʌnt'umie hee ham hierr paauk'abaadeewai hag heemua woun hiekjö, “Chamʌʌta mʌ Hiewaa, mʌchdëu jãsehne wai chitʌmʌu, hõor peerdʌ haumk'ĩir mʌchdëu jʌr hautarr. Hirua jaau simta hipierraa habat” ha hiek'abarm hũrjierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Maimua chi woun hiekjö sĩerr k'ĩubaadëm dʌ̈i hĩchab chi jʌʌnt'umiejã chukk'u haadëm hee hoowai Jesús hich happai hoo dʌnaajim hanʌm. Mamʌ hamachdëu mag hootarrjã hag hed gaai chan bʌ̃ʌrjã deeum k'ʌʌnag jaauba, sĩi k'ĩuu nʌisijierram hanaabá, nem dau chig hooba harrjö. ");
INSERT INTO noaH_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hag noram hãspaau mam durrsĩ gaai naawi deeu hich k'apeen dʌ̈i jër paauk'abaadëm hee, ham k'ĩirp'ee hõor pöoma wëdurajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mag k'apan pos wëdurum heemua woun hãb hi haig bëewia hirig magchëjim hanʌm: —Maestro, mʌ chaaidam t'õt'õrrsö k'itʌm pʌ haig haibëejim. ¿Pua mʌ dau haug k'augwia hi monaaupʌ̈ibaju k'ai? Mʌ chan tag chaaijã chuk'u hãba mʌgdam happaita wai chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mʌg k'ërʌm hich bënëu barbaadeewain nem t'eegta baarjem. Di bäbäjä k'abaadëmua hähäik'am dʌ̈i sĩi hisap'unjã bau haadeejem. Mag di bäbäjäk'am pʌamjã higba t'ʌnʌʌ hawia bar dichdimaawain gaai machgau sĩita k'a haupihba haadeejemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chi mepeer höbeerpʌ̈imk'ĩir pʌ dʌ̈i hogdʌba wënʌrraajem k'ʌʌnag mua jaautarrjã hamau pödbajierramgui haichëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Magbaawai Jesuu t'umaam k'ʌʌnag heerpanaa, —Pãran chadcha pãach t'ãar k'aibag gaaimuata pãrau chan jãg chaai Hẽwandamau monaaupʌ̈ijujã k'ĩirjuba nʌmgui hajim hanʌm. ¿Pãrau jãg Hẽwandam jua t'eeg simjã k'augbamjö nʌm sĩi hich jãgta mua hãwat chitaju haai chirʌ́ pãrau hoowai? ¿K'an hatchata pãrau mʌ pãach dʌ̈i chitapim hig nʌma hajim hanʌm, hajapcha hʌ̈k'aag? Magnaa jũrr chi hayagta, Mʌ haig pʌch chaai haipidú hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mag chadcha chi hayau haidurum hee, chi chaai hich bënëu t'eega barbaadëmua warre jẽk'ʌt barwerbpʌ̈ijim hanʌm. Magbaawai Jesuu chi mepeer mag chi chaai mor hee simʌg meeurraunaa höbeerpi jaaubaawai warre höbërbaadëjim hanaabá. Mag chaai monaaupʌ̈iwia chi hayag, —Har k'ërʌm pʌ chaai hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mag Jesuu chaai monaaubarm hoowia t'um haig narr k'ʌʌn dauderraa nʌisiwia Hẽwandamagta, “Hẽwandam, pʌchta chadcha mepeen k'ãyaujã chi jua t'ierriu. Mepeenau chan pöd pʌ dʌ̈i barbam” hajierram haajem. Tagam k'ʌʌn mag dauderraa t'ʌnʌm hee, Jesuu hich k'apeenag magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Hajap'a mʌ hiek'aagpam hũrwia k'ĩir heyaa wai nʌisit. Mʌigmua pömcha k'aba nʌm hee, mʌg mʌch chi Hemk'ooi Hiewaa mʌg chirʌmʌn chi t'ierrnaanag pʌr deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mamʌ chi k'apeenau Jesuu hamachig mag hiek'abarmjã warre k'ap'ʌ haju nem k'aba harr haawai pöd k'augbajierram hanaabá. Mag hamachdëu pöd k'augba habaawai hirig jëeujöjöo naawi warag hinagau jëeuba, hich magpai nʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Maimua wëtwia hamach happai hap'öbaadeewai, “Keena, magan mʌg nʌm haig, ¿chijãata hʌ̃rʌʌcha sim k'ai?” ha hiyʌ̈ʌ hap'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mamʌ Jesuu ham k'ĩirjug k'ap'ʌnaa ham t'ãarjã k'ap'ʌ sĩerr haawai, mag hiyʌ̈ʌ nʌm hũrbaa chaaidam jiir hauwia hich bigaau dʌnʌʌupi k'ërnaa hamag magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Mʌg chaai hagt'a hich juau paba haawai serbiiba k'itʌmjö hõor t'ʌnʌm t'um mua k'õsi chitʌm. Pãrau mʌ dënjö mʌg k'it'ëem hãb k'ãijã jãsenk'awia pãach di haig haumʌn, magan pãrau mʌchchata mag k'ĩir jãsenk'abarmjö habarmgui hajim hanʌm. Mag pãrau hʌdʌraa pãach haig mʌ baarpi nʌm haiguin magan pãrau mʌ Haaijã k'õsi nʌm hanʌm, hichdëuta mʌ pʌ̈itarr haawai. Mua pãrag jaauk'imgui hajim hanʌm: Har hamachdëupai k'ĩirjuawai t'umaam k'ʌʌn k'ãyaujã chaai bʌ̃rʌʌmdamjö serbiiba nʌm ha k'ĩirju nʌm k'ʌʌnta warm k'ʌʌn k'ãyaujã hʌ̃rʌʌcha nʌmgui hajim hanʌm chadcha, Hẽwandam dau na. ");
INSERT INTO noaH_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Magbaawai Juanau Jesuug, —Maestro, marau woun hãb hoojimgui hajim hanʌm. Mag wounau hiek'amamua pʌ t'ʌ̃r t'ʌ̃rnaa hõor mor heem meperag höbeerpi jaaubaawai chadcha höbeerpʌ̈i maajeejim. Mamʌ maarjö pʌ dʌ̈i nʌrraba haajemuata mag sĩewai marau hirig tag hõor mor heem mepeen jʌrk'ʌʌipiba jaaujimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Magbaa Jesuu magjim hanʌm hirig: —¿K'ant'ee pãrau hidëu hõor jua pʌrpiba hirig magjierrá? Maadëu nem wau nʌm hoowia maach hichaaur haba warag maach juapierr hoo sim k'ai, magan maan dʌ̈i maach higar sĩewaiugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ya Jesús deeu hʌ̃gt'ar hich Haai haar maimʌʌ haadeewai warag t'ãar p'ĩiuwia högk'aba Jerusalenag petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mamʌ hich na di jʌrwia nem k'ĩir k'augamk'ĩir, hich k'apeen heem hõor jʌr hauwia pʌ̈ijim haajem. Magbaa mak'ʌʌnau hërëuwia Samaria durr p'öbördam pöm k'aba k'itʌm hee hi na di jʌrimajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mamʌ chi Samariapienau Jesús sĩi Jerusalenagta mam ha hũrbaawai hi hat'ee chan di chuk'um hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Magbaawai deeu bëewia mag hirig deebaju habarm jaauchëjierram haajem. Mag hũrbaawaita jũrr Santiagoou Juan dʌ̈imua, —Señor, ¿pua hoowai mag pʌrʌg di deebam hanʌm jũrr marau Hẽwandamag jëeuju haai nʌ hajim hanʌm, Elías k'ararrau jëeubaawai hatarrjö ham p'öbör pábaadëmua huurdʌ k'ëchpʌ̈imk'ĩir? Marag jaaubá hajim hanʌm Jesuug. ");
INSERT INTO noaH_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Magbaawai Jesuu hamag p'ʌʌrba hoonaa magjim hanʌm: —¿K'aíu pãrag jaauwai magta haju haai nʌm hajĩ, hõrau dich k'a hisëe haawai? Chi mag hiek'aajem k'ʌʌnan bʌ̃ʌrjã Hẽwandam hiek hũrba haajem k'ʌʌnta mag hiek'aajemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mʌch chi Hemk'ooi Hiewaan mʌg jẽb gaai hõor peerdʌ hawaanta bëejim. Mʌ mag mʌch garmua warag hõor hamach pekau hee durrum peerdʌ haubanaa sĩi höpʌ̈yaanjã bëebajimgui hajim hanʌm. Mag warre ham kach dʌ̈ʌ hiek'apʌ̈iwia deeum p'öbördamag hërëubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mag hërëubaadëwia hagt'a barba wënʌrrʌm hee, hãbmua Jesuug, —Señor, mʌʌn pʌ mampierr pʌ dʌ̈i hich jãg chitajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Magbaawai jũrr hich Jesuu hirig, —Pʌchdëu mag mʌ dʌ̈i chitam k'õsi chirʌm k'ai, marrau magan hajim hanʌm. Mamʌ pʌrʌg jaauk'imgui hajim hanʌm: mʌ k'ãyau pabʌ̈ heem nemchaain hamach k'ãaijem jẽbdi paraam; nem hichpanjã k'eeupaawai hamach k'ãaijem k'ãidu wai sĩsidʌm. Mamʌ mʌch chi Hemk'ooi Hiewaa chan mʌg chitʌm haig k'ëubaadeewai k'ãyaag hajap'a werba chiraju didamjã chuk'u chitʌmgui hajim hanʌm. Pʌjã mʌjö magta chitam k'õsi chirʌm k'ai, marrau magan hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Maimua hãbak'aíg jũrr hich garmuata —Marrau mʌ dʌ̈i habaawai, jũrr magua, —Señor, magan hidëu nacha mʌ mʌch haai haar mawia hi dʌ̈i chirʌʌ hapibá. Mʌg hatag mʌch juadamaucha jöoi hauk'ër pʌabajeen chadau mua pʌ hogdʌba chitajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Magbaawai Jesuu hirig, —Magju k'ãai warre mʌ dʌ̈ita marrau hajim hanʌm. Hidëu har hamach Hẽwandam hiek hʌ̈k'amaaugau chi t'õmjö nʌm k'ʌʌnag hamach binaan bëppibá. Mamʌ pʌ mag k'ãyau warag hõrag jaaubamí hajim hanʌm: “Ya Hẽwandam t'umaam k'ʌʌn Pörk'acheeg bëeimʌʌ sim. Pãar peerdʌm k'õsi nʌm k'ai, hichta hʌdʌraa pãach Pörk'apibat” ha jaaupet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Magbaawai deeum haig sĩerrau hĩchab hirig magjim hanʌm: —Señor, mʌjã pʌ dʌ̈i hogdʌba chitaju hĩchab. Mamʌ hidëu nacha mʌch di haar mapibá hajim hanʌm, mʌch di haig durrum k'ʌʌnag “hayoo keena” hapʌ̈yaan. ");
INSERT INTO noaH_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Magbaa Jesuu magjim hanʌm: —Chi mʌ dʌ̈i nʌrrʌm woun chan hag na hichdëu parhooba nem waaujerrjã hagt'a k'ĩirju nʌrraju haai k'aba sim. Hirua magju k'ĩirju chirʌm chan, pöd Hẽwandam hat'ee nem hajap'a waubamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mag jũrram k'ʌʌnau Jesús dʌ̈i hogdʌba wënʌrraju ha t'ʌnarr k'ur maach Pör Jesuu hichdëucha hõor setenta jʌr hauwia k'ĩir sĩsied nunumdö pʌ̈yaagpajim haajem, hich na hich nʌrrajupierr. ");
INSERT INTO noaH_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mag ham pʌ̈yaagpamua magjim hanʌm: —Chadcha Hẽwandam hi jaau nʌmʌn arrozdö pöm p'ur wëjömjöta p'idag pöoma sim; mag simta chi jaau wënʌrraju k'ʌʌn chan k'apan k'aba durrumgui hajim hanʌm. Magua mua pãragan, Hẽwandamag jëeubat ha chirʌmgui hajim hanʌm, warag hich hi jaauju k'ʌʌn k'apan jöp'ëecha hich hi jawaan pʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Maimua magjim hanʌm hamag: —Hërëubaadët. Mamʌ pãadë hũrbat: Mua mʌg pãar pʌ̈i chirʌmʌn, hõor k'aibagk'am heeta wënʌrraju haawai pãran oveja chaaindam k'um nem t'ʌnʌm hee pʌak'ʌʌibapʌ̈imjöta habarmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pãach jua k'arr hërëubaadët: p'atk'on chuk'u, putdijã chuk'u, maimua zapatdamjã pãach bʌ̈ gayam happai hat'aadët. K'ʌdau hee hõor hoowaijã hiyʌ̈ʌ dʌnʌnʌidʌ nʌʌ haba dichpetat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Parhooba pãach wëtumpierr hõor deg duubwai saludaawia, “Maran maach peerdʌajem hiek jawaanta bëejim; pãach mʌg di hãbam degam k'ʌʌnau t'umaa hʌ̈k'ak'iin hʌ̈u hak'am” habat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pãrau mag jaau wënʌrrʌm hãbmua k'ãijã hʌ̈k'am k'õsi hʌ̈k'amʌn, hʌ̈u peerdʌwia Hẽwandamau hi hauju. Mamʌ hirua magbamʌn, magan Hẽwandamau mag woun heeg hooba, hi dʌ̈i hʌ̈u haju hatarr warag pãach dʌ̈ipaita hʌ̈u haju. ");
INSERT INTO noaH_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mag pãach hʌ̈u jẽerpibarm degpai t'achjã k'öbat, dipierr t'ach k'ö wënʌrraba. Mua pãrag mag chirʌmʌn, mag pãach p'idk'a wënʌrrʌm gaaimua hõrau sĩi pãar jãhogju haawaita mag chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","P'öbör hee pãach dub wënʌrrʌmpierr pãach jẽer nʌm haiguim k'ʌʌnau nem deewai magʌmjã haba k'öbat. ");
INSERT INTO noaH_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Maimua hĩchab magʌm p'öbörpierr pãachdëu haaunaan hoomam monaaupetat. Mag monaaupʌ̈iwia hamag, “Pãrau hĩs mʌg hoobarmʌn Hẽwandamauta pãrag hich jua t'eeg hoopi sim” ha jaaubat hajim hanʌm hĩchab. ");
INSERT INTO noaH_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mamʌ p'öbörpierr pãachdëu jaau wënʌrrʌm hũrmap'a ni hamach degjã pãach höbërpiba habaawai, kaaijã hee höbërnaa, pãach bʌ̈ gayam jẽb hʌʌrp'ë hʌʌrp'ënaa, hamach k'ĩircha magbat: ");
INSERT INTO noaH_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pãrau Hẽwandam hiek hiseg nʌm k'ai, ni pãar p'öbör heem jẽbdampaijã marau maach bʌ̈ gaai harrbam. Mamʌ ya pãrau k'ap'ʌ nʌisim, Hẽwandamau pãach heejã hich jua t'eeg hoopiju hatarr hoopiba habarm, pãachdëu hi hiseg nʌm gaaimua.” Magwia hërëubaadët hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mamʌ mua pãrag mag chirʌm: Mag pãachdëu jaau wënʌrrʌm gaaimua pãar hisegbarm p'öbör heem k'ʌʌnan, Hẽwandamau mʌg durr hi hagk'am hed gaai Sodomapien k'ãyaujã hʌ̃rʌʌcha Hẽwandam jua machag hãwatjugui hajim hanʌm, hich Jesuupai. ");
INSERT INTO noaH_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mag hich hiek hiseg nʌm k'ʌʌn higwia, ’¡Hëh, hapdurr Corazinpien! hajim hanʌm. ¡Hëh, hapdurr Betsaidapienjã hagjö, Hẽwandamau ham hi hagk'am hed! Ham hee nem hooba haajem nem wau nʌmua Hẽwandamau hich juapá hoopitarr Tiro p'öbör heeta wa Sidón p'öbör hee k'ãijã wautarr hamuan, nawe hamau hamach k'ĩirjug k'aigbam hisegwia sʌrk'ak'am. Magtarr hamuan, hamau t'eerju t'eerwia hʌ̃r jupnaa, putiu pör börrnaa, k'oopa nʌm k'ʌʌn sʌrk'aajemjö sʌrk'ak'am. Magnaa hamau hamach mor hewag hãsie k'ĩirjuwia Hẽwandamag jëeuk'amgui hajim hanʌm, hamach k'aibag chugpaamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Magua Hẽwandamau mʌg durr hi hagk'am hed Corazinpienta Betsaidapien dʌ̈i hirua masiicha waupʌ̈ijugui hajim hanʌm ham gaai, Tiropien dʌ̈i Sidonpien k'ãyaujã, hamachdëu hũrtarrta hʌ̈k'aba harr gaaimua. ");
INSERT INTO noaH_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Maagwai Capernaumpien higwiajã, ’¿K'an habarju? hajim hanʌm. ¡Hëh! Hamaun hamach t'ö nʌm, hamachta chi wäjäaun hawia. Hamaun hʌ̃gt'ar paauk'abaimaawaijã hamachta chi pörnaan k'aimajupii nʌm. Mamʌ jãk'ʌʌn chan Hẽwandamau hich haar höbeerpiba, warag k'ĩmie durrta bark'ʌʌipʌ̈ijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Maimua mag hichdëu pʌ̈iju k'ʌʌnag magjim hanʌm: ’Pãar hiek hũrm k'õsi hũr nʌm k'ʌʌnau magan mʌ hiekta hũr nʌm hĩchab. Maagwai har pãar hisegbarm k'ʌʌnau magan mʌpata hiseg nʌm. Mag hamau mʌ hiseg nʌm k'ai, magan hamau mʌ Haaijã hĩchab dʌ̈i hiseg nʌm, hichdëuta mʌ pʌ̈itarr haawai. Mag ham wawik'a wai sĩewian chadau k'ĩir sĩsied nunumdö wëtpi jaaubaa hërëubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mag hërëuwia, wënʌrrʌʌ hat'urwia, deeu bardʌtk'acheeu honee magchëjierram maach Pör Jesuug: —Señor, chadcha marau pʌ higwia puata maar pʌ̈ijim hanaa mepeenagjã höbeerpi jaauwain sĩita magʌmjã haba, mepeenan höbërmaajeejimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Magbaawai Jesuu hamag magjim haajem: —Pãrau mag höbeerpi jaauwai dösãt jua t'eeg chuk'u sĩi jẽk'ʌt p'ʌp'ʌrg petap'ʌm mua k'ap'ʌ chirajim. Jãguata hirua mʌ hök'ö sĩerrʌmgui hajim hanʌm, hichdëu mʌ jua jʌmbaju k'ap. ");
INSERT INTO noaH_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mua pãar jua t'eeg hapijim, pãach garmuata mepeen dajẽk hamk'ĩir. Maagwai mʌchdëu pãrag nem waupi jaau chirʌm wau wënʌrrʌmta dösãtau pãar nemk'õrig hʌmnaa döjũrigjã hʌmwiajã pãar bʌ̃ʌrjã chig habaju, mʌ jua t'eegta pãar gaai sĩewai. ");
INSERT INTO noaH_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mamʌ mag mepeenjã pãach garmuata jʌmpiba nʌm hawiapai chan hoob honee hamiet. Magarrau pãach t'ʌ̃rta ya hʌ̃gt'arm hẽsap gaai p'ã sĩsim gaaimuan chadau pãar honee haju haai nʌmgui hajim hanʌm, ya pãach Hẽwandam haarcha höbërju haawai. ");
INSERT INTO noaH_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mag hich Jesuu pʌ̈itarr k'ʌʌn deeu bëewia hichig honee nem hĩgk'abaichëm hũrbaawai hĩchab hich Jesujã Hẽwandam Hak'arau honee hapijim haajem. Mag hich honee haadeewai Hẽwandamag jëeumamua magjim hanʌm: —Tata, mua pʌrʌg hʌ̈u hajim ha chirʌm, pʌchta chadcha hʌ̃gt'arm magwe nem t'um mʌg wëjöm Pör haawai. Mʌ honee chirʌmgui hajim hanʌm, hõor hamach k'ĩirjug k'aug t'öwia nem t'um k'ap'ʌm k'ap'ʌm haajem k'ʌʌnaujã hamach peerdʌju hiek k'augba harrta jũrr pua k'ĩirjugdam meraa chaainjö k'it'ëem k'ʌʌnagta hʌ̈u k'augpibaawai. Chadcha puata nem hajap'a waaujem Tata hajim hanʌm, pʌchdëu juau ham dʌ̈i magju hatarr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Maimua jũrr chi haig narr k'ʌʌnagta magjim hanʌm: ’Nem t'um mʌg t'ʌnʌmʌn mʌ Hayau mʌrʌgta deejim. Mamʌ hãbmuajã k'augba sim, k'ai hagá mag Hẽwandam Hiewaa. Hãba hich mʌ Hayaupaita k'ap'ʌ simgui hajim hanʌm, chadcha mʌ hi chaairau. Mʌg nʌm haig hãbmuajã k'augba sim, k'ai hagá mʌ Haai. Hãba mʌch chi Chaairaupaita mʌch Haai k'ap'ʌ chitʌm. Bigaaum k'ʌʌnau k'ap'ʌ haju hawiajã mʌchdëu jaaubarm k'ʌʌnaupaita hĩchab hi k'ap'ʌ haju haai nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Maimua hamach hap pawia hich k'apeenag heerpa heerpanaa hamag, ’Honee habat hajim hanʌm, pãach jʌ̃gʌucha mʌ hiek hũr nʌm k'ʌʌn. ");
INSERT INTO noaH_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cha mua nem wau chitʌm pãrau pãach daujãau hoo nʌmjö, warrgarwe Hẽwandam hi jaaumienau reinaan dʌ̈imua hamach daúacha hoom hiigjeejim, mamʌ pöd hoobajierram. Hamach jʌ̃gʌucha pãrau hũr nʌmjö hũrm hiigjeejim, mamʌ pöd hũrbajierram. Mamʌ pãrau magba pãach daúacha hoonaa pãach kachiucha hũr nʌm. Magua mua pãrag “Honee habat” ha chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Maimua biek hãb Jesuu hõor k'apan t'ʌnʌmʌg jaau sim haig, chi Moiseeu p'ã pʌatarr hiek jawaag hat'ee chi machnaan heem hãb p'iidʌbaadëwia sĩi hi himeraa pʌr hawaagpai hirig magchëjim hanʌm: —Maestro, mʌrʌg jaaubá hajim hanʌm. ¿Mua jãgata haju haai chirʌ́ hʌ̃gt'archa höbëraag? ");
INSERT INTO noaH_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Magbaawai jũrr Jesuu hirig, —¿K'an ha p'ã sĩ Hẽwandamau hich hiek jöoingarwe Moiseeg p'ãpitarr gaai? ¿Pua hag gaai t'ʌ̃rba haajẽ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Magbaawai mag chi charrk'a chirʌmua magjim hanʌm: —Moiseeu Hẽwandam hiek p'ãtarr gaai, “Maach Pör Hẽwandam sĩi par hiiupai k'aba, pʌch t'ãrauchata k'õsi habá” ha sim; maimua hĩchab, “Pʌch k'apeenjã hagjö hagdaujöo k'a k'õsinaa daupii habá, pʌchjö wir haig” ha p'ã simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Magbaa Jesuu hirig, —Hëera, chadcha pua hich hag heyaa jaaubapʌ̈imkë hajim hanʌm. Cha pʌchdëu k'ap'ʌ jaau chirʌmjö habamí pʌch k'apeen dʌ̈ijã. Pua chadcha t'umaam k'ʌʌn dʌ̈i magmʌn, pʌ hʌ̃gt'ar höbërjugui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Magbaawai chi charrk'a chirʌmua sëuk'a hichdëu k'augba chirʌm hawia deeu, —¿Chijã k'ʌʌn hagáma hajim hanʌm mʌ k'apeen mag mua daupii haju k'ʌʌn? ");
INSERT INTO noaH_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Magbaawai Jesuu hirig, —Mʌ hiek hũrbá, mua pʌrʌg jaauk'imgui hajim hanʌm: Woun hãb Jerusalenmua Jericoog k'ʌdau ma sim hee maa hajim haajem. Mag hi ma k'itʌmta nem jĩgmien k'apan höbërdʌtk'achëwia, hi nemdam t'um k'echt'ʌgnaa, hi mor gayam k'ajũadampa hẽer hauwia, warag p'ãr wai nʌmua chi meemjö haadeewai sĩi barpʌajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mag chi meemjö jẽer k'ërʌm hee, hich hag k'ʌdau heepai p'ad maa hajim haajem. Mamʌ hichdëu mag hoo hat'aimaawai sĩi warag hagʌg hoobamjö dichjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Maimua hag k'ur nʌʌpai hawia, deeu hich hag k'ʌd heepai majim haajem, Levinaan ha t'ʌ̃ʌrjem k'ʌʌn heem hãb p'adnaan dʌ̈i p'idk'a nʌmua ham juag hoojem. Mamʌ maguajã hi dak'a bëenaa, sĩi heerpapet hawia, warag hoobamjö hich mag petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Maimua mag warm k'ʌʌn hërëu dichtarr hẽudee hagjö maa hajim haajem Samariapierrdam, hich hag k'ʌd heepai. (Samariapien judionaan dʌ̈in hagdaujö jũrr chik'am k'a k'õchk'aba haajeejim. Mamʌ maagjerrta magʌmjã higba,) maguan chadau hichdëu mag hoobaimaawai, “Hëh, ¿jãan chijãg woundamta jãg dau hap'ʌʌ jẽer k'ërʌm?” hawia, warag haar mawia, hich hat'ee nemk'au pabʌ̈ olivo hanʌm dën vinodampa wai nʌrrarrau bënhëk'a hi mor mag pepet'or sĩsidʌm hee p'uurk'anaa, put hee pʌrëunaa, hich cabaai gaai hat'aadëjim hanʌm, hich dʌ̈i hãba. Mag harrwia, hõor jẽerjem deg hag dʌ̈i sĩeimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Maimua hag noram hãspaau ya hich ma nʌrrʌmua denariodam numí chi dik'ʌʌg werpʌawia magjim hanʌm: “Mʌg woundam hajap'a hoo wai chirsí. Pua hi monaau haum k'õchgau cha murua p'atk'on werpʌabajëm hʌ̃r k'ãijã werbamʌn, hoob k'ĩirjum” hajim hanʌm. “Mʌch bëewai, chi waaurbarm t'um mua deeu pʌrʌg p'agchëjugui” hajim hanʌm. Mag jaau pʌawia petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mag hĩgk'a haaipawia, hich Jesuupai mag Hẽwandam hi jawaag chi charrk'a chirʌmʌg jëeujim haajem: —Pua k'ĩirjuawai ¿chijãata mag woundam hich happai ma k'itʌm hee k'apanaam k'ʌʌnau pʌrnaa mas deetarr hag k'apeer haju hayaa sĩ: chi p'ad, chi Levinaan heem, wa chi Samariapierrdam? ");
INSERT INTO noaH_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Magbaawai hichdëu, —Chi mag jẽer k'ërʌm hoobaimaawai hi dau haug k'augtarrma hajim hanʌm. Magbaawai Jesuu hirig, —Magan mawia hi dënjö pʌch hoomap'am k'ʌʌn hawia k'ãijã daupii habá hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Maigmua higbaadeeu hich k'apeen dʌ̈i hãba mamua deeum p'öbördam pöm k'aba k'itʌm hee barwia hʌʌi hãb Marta hanʌm di haig jẽerimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mag Marta hanʌm heeum María ha t'ʌ̃r sim sĩejim haajem, hi dʌ̈i k'od hãbam. Mag María bëewi sĩi Jesús dak'a hi hiek'a simpai hũr hoo sĩsijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Magʌmich Marta k'ʌrr higaau jua dʌ̈rrjã k'aba t'ʌnaajim hanʌm, hõor t'um jãhogaag hich happaimua p'iejãb waauwai. Mag hich jua dʌ̈rr k'aba haawai Jesús haig bëewia magchëjim hanʌm: —Señor, ¿pua hoowai hʌ̈u sĩ, mʌg mʌ jua dʌ̈rr k'aba t'ʌnʌm hee sĩi Mariaau jãg pʌ hiek'a simpai hũr hoo sĩeju? Jãg pua hirig jaaubá hajim hanʌm, mʌ juag hoon mamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Magbaawai Jesuu hirig, —Marta, chadcha pʌ jua dʌ̈rr k'aba t'ʌnʌm mua k'ap'ʌ chirʌmgui hajim hanʌm. Hajap'a hõor jãhog haum k'õchgau pʌ k'ĩirjugan nem t'umaa wauju happaita k'ĩirju buburrk'am. ");
INSERT INTO noaH_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mamʌ sĩi dich bi hat'eepai nem t'um wauju k'ĩirjuba hawiajã hʌ̈u sim. Mariaau pʌ k'ãyau hajapcha habarm. Jãg sim haig hirua Hẽwandam hiek hũrm k'õchgauta pʌ juagjã hooba habarm. Maagwai mua pöd hirig hũrpiba jaauju haai k'aba chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Biek hãb Jesús hich Hayag jëeu sĩejim haajem. Mag jëeu haaipabaadeewai hich k'apeen heem hãbmua hirig, —Señor, jãg Juanau hich dʌ̈i wënʌrrʌm k'ʌʌnag Hẽwandamag jëeu nʌm jaautarrjö, magan maragjã hagjö jaaubá hajim hanʌm, maraujã hĩchab hirig jëeu k'ap'ʌ haag. ");
INSERT INTO noaH_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Magbaawai hichdëu hamag magjim haajem: —Pãach Hẽwandamag jëeuwai magbat: “Hẽwandam, pʌʌta maar Haai hʌ̃gt'ar chiraajemʌu. Pʌch happaita chadcha pekau chuk'u chitʌm. Pʌrʌgta marau maach dʌ̈i pʌchdëu hampierr hapinaa pʌchta t'umaam k'ʌʌn Pörk'apim k'õsi nʌm. Hʌ̃gt'arjã jãg pʌchdëu nem waupi jaau nʌm happai waaujemjö, mʌg jẽb gaaijã t'um pʌchdëu jaau simjöta hapim k'õsi nʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hed hëepierr pua marag k'öjudam deebarju. Hẽwandam, maar pekau t'um chugpaabapʌ̈i, ");
INSERT INTO noaH_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","maimua har marau maach dʌ̈i k'aigba habarm k'ʌʌn dʌ̈i tag magʌm hiek higba hich mag k'ĩir hok'oopäaijemjö maar dënjã k'ĩir hok'oobapʌ̈i. Hoob pua hʌdʌraa chan maar pekau hee burrpi chiram. Mag k'ãyau warag maar t'ʌa wai chirsí, p'it'urg chuk'u dösãtau maar hichig paa haum hugua” ha jëeubat ha jaaujim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mag jaau dichwia jãga Hẽwandamag jëeuju haai nʌm ha k'ap hamk'ĩir hĩchab hamag magjim hanʌm: ’K'anim nemjö pʌ pʌch k'apk'ʌʌn hajap'am wai chirʌm. Maimua ya hedacha pam hee hi haar mawia pua hirig, ");
INSERT INTO noaH_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Kakë, mʌ haig mʌ k'apk'ʌʌndam barbaichëmʌg nemdam deejujã chuk'u chiraawai pʌ haig t'achdam jëeu hawaan bëejim” haimaawai, ");
INSERT INTO noaH_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","hirua hierrmua jũrr pʌrʌg, “Hidëu mʌ k'ajap'a k'ãaipibá. Ya mʌ put hee chirʌm; mʌ chaainjã ya k'ãidʌtk'a t'ʌnaawai pöd mʌ pʌ haar puertdi wewaanjã mabam; pʌ nem hig sim pöd mua deepʌ̈ibam” hak'iin, ¿jãgaju k'ai? ");
INSERT INTO noaH_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mua hoowai chan warmua mag hiek'awiajã chadcha hirua hichdëu nem jëeu sim hig sim k'ai, hichiita hirua warag pʌaba jëjëeu haju. Mag jëjëeuk'am, ¿jãga mag p'iidʌwia hirua hau deeba habarju? Hichiita hi p'iidʌjugui hajim hanʌm. Mamʌ mag hich k'apk'ʌʌnau nem hig sim hawia k'abam. Hi p'iidʌjuun, sĩi hidëu hich k'ãaipiba haawaita hirua nem hig sim hau deen p'iidʌju. ");
INSERT INTO noaH_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hich jãgta haajemgui hajim hanʌm hagjö Hẽwandamag jëeuwaijã. Magua mua pãragjã pʌaba jëeubat ha chirʌm. Magta pʌaba jëeu nʌmʌn, pãachdëu nem higbarm hirua deeju. Pãrau hi jʌrmʌn, hi baauju. Hi sim haar dubaag pãach weeu haupi jëeumʌn, hirua pãar weeu hauju. ");
INSERT INTO noaH_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, har hõor nem jëeu paraam k'ʌʌnagan nem deeb k'aba deejem. Har hamachdëu nem hinag hig nʌm pʌaba jʌr nʌm k'ʌʌnau baaujem. Maagwai hĩchab chi puertdi sirbaichëm k'ʌjã weeu hauwia dubpiejem. ");
INSERT INTO noaH_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿K'aíuta mʌg sim haig hich chaairau t'ach jëeubaa mokdauta p'ëdeeju k'ai? ¿Wa hãwarr k'ãijã chaairau jëeubaawai hãwarr deeju k'ãyau nemk'õrta t'õo deeju k'ai? ");
INSERT INTO noaH_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wa magba, ¿nemhãudam k'ãijã jëeubaawai nemhãu hawia döjũrta hau deeju k'ai? Ni hãbmuajã magbamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pãar hö hãk'ãraa k'it'ëem k'ʌʌnaujã pãach chaainau nem jëeuwai ¿nem hajap'amjã hĩgk'aba deeba haajẽ? Hich jãgta haajemgui hajim hanʌm maach Haai hʌ̃gt'ar chiraajemuajã hagjö. Chadcha t'ãrau hichig jëeu simʌgan hirua hich Hak'aarjã deeb k'aba deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Biek hãb Jesuu woun mor hee bën k'aigbam wai sim monaau sĩejim haajem. Mag bënëu chi woun pödjã hiek'apiba sĩi hichʌp wai sĩejeejim hanaabá. Mamʌ Jesuu chi bën höbeerbapʌ̈im bʌ̈rre chi woun deeu hiek heerdʌ sĩsiewai hiyʌ̈ʌ haadëjim hanʌm. Mag hoowi t'umaam k'ʌʌn dauderraa naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mamʌ hãaur k'ʌʌn dʌ̈i haig hoo narr k'ʌʌnau, —Jãg Jesuun dösãtnaan pör Beelzebú dʌ̈i bën dötarr haawai hag juapaauta jãg hõor mor heem mepeenjã dau daau jʌrk'ʌʌi nʌrraajemgui hanaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Magbaa jũrr hãaur k'ʌʌnau hamach hödegpai, “Daau chadcha hirua Hẽwandam juapá wai chirʌm k'ai, deeum nemjã hompaa hat'aju” hawia hirig, —Magan chadcha pʌchta Hẽwandamau pʌ̈iju haajerr chaar k'ai, hedjã hee maadëu nem hooba haajem hompaa hat'á pʌch hiek'au hajierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mamʌ magbaa hichdëu hamau k'ĩirju nʌm hajap'a k'ap'ʌ sĩerr haawai hamag magjim hanʌm: —Pãrau hoowai, gobiernoou hich higar nʌm k'ʌʌn jãrrcha t'öonaa hamach wir haigpai wërbʌpik'iin, ¿mag gobierno warre k'ʌt mabaju k'ai? hajim hanʌm. Jöoi hãb simua k'ãijã hich chaain dʌ̈ipai meeuk'awia hamach wir haigpai wërbʌk'iin, warag haaidʌjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hich magta haju hagjö dösãtjã. Hich k'apeen dʌ̈ipai wir haig wërbʌ nʌmua hamach höpʌ̈pʌ̈i hamʌn, pöd hich mag jua t'eeg k'aba sĩerraju, hamachdëupai hamach k'ëchmaawai. Pãar hiek mag mua dösãtnaan pör Beelzebú juapaauta mepeenjã hõor mor heem jʌrk'ʌʌi chirʌm hanʌm, ");
INSERT INTO noaH_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","chadcha Beelzebú hag juapaauta mua bën k'aigbamjã jʌrk'ʌʌi chitʌm k'ai, magan har pãach heepaim k'ʌʌnaujã hagjö hi juapaauta mepeen jʌr wërp nʌm. Mag nʌmta ¿jãgwia pãrau mak'ʌʌnag chan bʌ̃ʌrjã magʌm haba nʌ? hajim hanʌm. ¿Chadcha hich Hẽwandamauta hamag magamk'ĩir hich juapá dee sim pãachdëu k'ap'ʌ naawai k'abá? Pãar hiek mag chi dösãtaupaita wir haig hich k'aibag waaujem hanʌpí, magan jãg chi mʌ dënjö dau daau mepeen jʌr wërp nʌm k'ʌʌnagchata jëeu hoobat daau hamau chadcha dösãt juapaauta jãg jʌr wërp nʌm habarju pãrag. Pãach chi mʌrʌg mag hiek'a nʌm k'ʌʌnta hag heyaajã k'aba hiek'a naabahab. ");
INSERT INTO noaH_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Muan chadcha Hẽwandam jua t'eegauta mepeenjã jãg jʌr wërp chitʌm. Mag mepeenjã mua jʌr wërp chirʌm gaaimua pãrau k'ap'ʌ haju haai nʌm, ya hich Hẽwandam chi jua t'ierrta pãar hee sĩeichëm. Mamʌ magʌmjã pãrau k'augba nʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Dösãtan woun hãb chi jua t'ierrta jierrnem dʌ̈i hajap k'ĩir k'augwia hich di t'ʌa simjöta sĩerrʌmgui hajim hanʌm, nem jua t'eeg. Mag sĩewaita, hi k'ãyau jua heegpaimua chan hi sim haig hi nem bʌ̃ʌrjã chig habam, hich jua hee t'ʌnaawai. ");
INSERT INTO noaH_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mamʌ hãb hi k'ãyau t'et'echaramua bëewi, hi dʌ̈i wërbʌwia hi pödbapäaiwain chadau, hirua hich jierrnem t'ö chirarr t'um k'echt'ʌg hauwia hi juagam nemjã jũrr hich dënk'a hauju, hag dʌ̈i hichdëu hampierr haag. Magua mʌʌta dösãt k'ãai jua t'eeg chiraawai muata hõor heem mepeenjã jʌr wërpju haai chirʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Magua mua mag chirʌmgui hajim hanʌm: Har chi mʌ higar k'aba sim woun hichta dösãt higar sim; maimua Hẽwandam hiek hʌ̈k'api hawaag mʌ hipierr hõor hãbamʌg jʌr p'ëba simuan waragta jʌr wërp simjö simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Bën k'aigbam hõor mor heemua jʌrpäaiwain warp hõor chukag hee p'ʌrëu nʌrraajem. Mamʌ pöd hich sĩeimaju baauba habaawai k'ĩirju sĩi hawia, “Deeu mʌch chiraajerr deg chiraimaag majugui” hawia, deeu hich hag woun jʌrmaajem. ");
INSERT INTO noaH_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mag mawia hooimaawai, chadcha di chaarta hajap t'ũapwia hãbamʌg nem p'ëwia hãk'a t'ʌnʌmjö, dijã parii hooimaajem. ");
INSERT INTO noaH_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mag dijã parii hoobaimaawai, deeu mawia, hich daumaai hich k'apeen hich k'ãyau k'aigbacharam k'ʌʌn siete jʌr hauwia, deeu mag woun mor hee naaicheejem. Magbarm haigmua chi wounjã warr hich sĩerr k'ãyau warag hat'uucha k'aigba sĩsiejem. ");
INSERT INTO noaH_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús mag hiek'a sim hee, hʌʌi hãbmua k'apanag heemua hirig, —Pʌ t'aabawia hich jũd gaai pʌ döpi bãautarr hʌʌita Hẽwandamau hʌ̈ucha hajim chadcha. Dich chaaita jãg k'itak'iin maach honee k'itajugui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Magbaawai jũrr hichdëu, —Jãan chadaugui hajim hanʌm, mamʌ mag k'ãyau har Hẽwandam hiek jaau nʌm hũrwia hi hipierraa nʌm k'ʌʌnta hʌ̃rʌʌcha honee haju haai nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Warag hõor pöm hich haig p'ẽeudʌdʌk'am hee, Jesuu hamag hiek'amamua magjim haajem: —Hĩsim k'ʌʌn chan warag chi hajaugjã chuk'uta t'ʌnʌm. Hoo nʌmjömta warágata hamachdëu nem hooba haajempata k'ĩirpierr hompaa haupi jaau nʌm. Mamʌ mua pãar hipierraa nem waubamgui hajim hanʌm. Mag k'ãyau Hẽwandamau Jonás dʌ̈i harrjö habarm gaaimuata mʌch jua t'eeg hoopiju. ");
INSERT INTO noaH_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Warrgar jöoi Jonás haajerr nemmeeurrk'an buch hee k'ãai t'ãrjup sĩet'urtarr gaaimua Nínivepienau Hẽwandamau hi pʌ̈itarr k'aug hautarrjö hĩchab, mʌch chi Hemk'ooi Hiewaaujã hagjö mʌch hiiu p'iidʌbarm gaaimuata pãrag k'ap hapiju, chadcha hich Hẽwandamauta mʌ pʌ̈ibarm. Mamʌ magʌmjã pãrau hʌ̈k'abajugui hajim hanʌm hichdëupai. ");
INSERT INTO noaH_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Magua, har hĩs mʌg jaar hõor mee nʌm k'ʌʌn Hẽwandamau mʌg hatag ham p'iriutk'a hauwia chachbarm jaar, Sabá hanʌm durrmua rey Salomón hoon bëetarr hʌʌiraujã hich hipaarmua hĩchab pãar k'aibagta Hẽwandamag hĩgk'a t'ʌnʌʌuju. ¿Jãgwi? Hí pãar k'ãaijã warpmuata Hẽwandamau rey Salomonag k'ĩirjug deetarr hiek'a sim hũraan bëetarr haawaima. Mag k'ãai pãar wir haig nʌm k'ʌʌnau mʌ Salomón k'ãaijã hʌ̃rʌʌcha chirʌm hiekta hũrmap'a nʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mag Hẽwandamau hõor hi hagk'abarm hed Nínivepienaujã hĩchab hamach hipaarmua pãar k'aibagta warag Hẽwandamag hĩgk'a t'ʌnʌʌuju. ¿Jãgwi? Jonaau Hẽwandam hiek hamach haar jaaubaimaawai hamau magʌmjã haba hʌ̈k'atarr haawaima. Mamʌ hĩs mʌ Jonás k'ãyaujã hʌ̃rʌʌcha chirʌmuata Hẽwandam hiek jaau chitʌmjã pãrau hʌ̈k'amap'a nʌmgui hajim hanʌm, hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Maimua mag jajawagmamua hich Jesuupai, ’Mua mag hõtdau paanaa sĩi hag hʌ̃r bat'ẽeu k'öo sĩu nʌm hooba chitʌmgui hajim hanʌm. Hõtdaun paanaa hõor dau garta hausĩiujem, t'umaam k'ʌʌn dau hararaa hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Maach daun hõtdaujöta simgui hajim hanʌm, maach mor gaai. Maach daujãata hajap'a sim haiguin nem t'um dawaata hoojem. Hich hagjöta simgui hajim hanʌm maach t'ãarjã. Hẽwandam hiek hʌ̈k'anaa maach t'ãarta hajap'a sim haiguin nem t'um Hẽwandamau k'õsimjöta waaujem. Mag nʌm haiguin hararag hee nʌmjöta nʌm. Mamʌ magba hagt'a pãach pekau heeta nʌmʌn magan pãran sĩi k'ĩchag hee jʌrk'a jʌrk'a nʌmjöta nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Magua k'ĩirjug paraa haajeet. K'ĩchag hee nʌmjö nʌmta pãach t'ãar hajap'a nʌm hawi hoob Hẽwandamag pãach hisegpimiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mamʌ pekau gaaimua k'ĩchag hee k'aba nʌmjö nʌm k'ai, magan chadcha pãar hararag chaar heeta nʌm, Hẽwandam dʌ̈i. Mag hamʌn magan hõtdaúa pãar k'ĩirp'ee wʌʌ wai nʌm bʌ̈ʌg nʌmjöta nʌmgui hajim hanʌm, hi dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mag hich Jesús hiek'a höbaadëm hee, hãb Moiseeg Hẽwandamau hich hiek p'ãpitarr hajapcha hʌʌrk'aajem k'ʌʌn heemua hi t'ach k'oon hëeurrjim haajem, hich di haar. Magbaawai Jesuu hi dʌ̈i mawia, barwia, hãba p'ʌʌr k'öp'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mamʌ mag chi Jesús hëeurrtarr wounau hoowai Jesús jua hʌbata t'ach k'öbaadëjim hanaabá. Magbaa hich hödegpai, “Waa, hidëu maach jöoinau jaaujem k'augbamjö jua sũgbata t'ach k'ö chitabaa” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mamʌ maach Pör Jesuu mag wounau hich hödeg mag simjã k'ap'ʌ sĩerr haawai hirig, —Mʌ hiek hũrbá hajim hanʌm hirig. Pãar fariseonaanan pãach pem haawai sĩi juagam nem chi hʌ̃rʌm memerk'ögpaita hajap'a hʌk'ak'a haju k'ĩirju sĩerrjëemgui hajim hanʌm, mag memerk'öm hee k'ãijã döbaawai Hẽwandam dau na pekau waumaaugau hawi. Mamʌ pãachdëu chik'am nemdamjã jĩgk'a pãach dënk'a haunaa chik'am k'aibag wau nʌm gaaimua pekau pöm nʌm chan hisegba ni Hẽwandamag chugpaapi jëeujujã k'ĩirjuba sĩerrjëemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pãar chi k'ap'ʌm k'ap'ʌm haajem k'ʌʌnta, ¿jãga jãg k'ĩirjug chuk'umjöta nʌma? hajim hanʌm. ¿Pãrau k'ĩirjuawai Hẽwandamau hʌ̃rʌm nempai hoonaa pöd pãar t'ãar hooba haajẽ, mor hee hierr sĩewai? ¿Nem t'um hichdëupai wautarr k'abá? ");
INSERT INTO noaH_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nem hajap'a jã hʌk'ak'a haju k'ãyau, pãach k'aibagta Hẽwandamag chugpaapi jëeubat hajim hanʌm. Mag pãar morjã t'um hajap'a nem jã hʌk'a t'ʌnʌisimjö sĩsiewain chadau hap'ʌʌm k'ʌʌnagjã nem deem k'õsi deeju. ");
INSERT INTO noaH_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mamʌ ¡hëh, hapdurr hajim hanʌm pãar, fariseonaan, Hẽwandamau Moiseeg hich hiek p'ãpitarr hiek hajapcha hʌʌrk'aajem haajem k'ʌʌn! Pãrau chadcha Moiseeu deepi jaautarrjö t'um pãach di hũjãrram nemjĩirdam bʌ̈ daiicharam gayampa Hẽwandamag ofrendak'a deejem. Mag naab mamʌ, jũrr wir haig pãach k'apeen dʌ̈i hagpierraanaa Hẽwandamjã k'õsi haju chan bʌ̃ʌrjã k'ĩirjuba sĩerrjëemgui hajim hanʌm. Pãrau hʌ̃rcha Hẽwandamta k'õsi haju haai nʌmgui hajim hanaabá. Magnaan chadau pãachdëu nem dee nʌmjã hich jãg dee wënʌrraju haai nʌmgui hajim hanʌm hĩchab. ");
INSERT INTO noaH_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Magnaa hamag, Pãran pãach Hẽwandam hiek jaaujem deg weetwaijã pãachta pörgarcha t'umaam k'ʌʌnag k'ĩir jʌrk'a juupjerram, pãachta hajapcha nʌm hawia. Maimua kaaijã hee weetwaijã t'umaam k'ʌʌnau pãachig saludaa nʌmua pãach t'ö hiek'apim k'õsi sĩerrjëemgui hajim hanʌm, hõor dak'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Hëh! Pãarjã hagjö chi machnaan dʌ̈i Moiseeu p'ãtarr hiek hajapcha hʌʌrk'aajem haajem k'ʌʌn. Pãrau k'ap'ʌ nʌm, maach meeun hee nawe hõor hauk'ërtarr jẽbdi hʌ̃r dichpiba haajem. K'augba dichwiajã hichiita maach hãarjem haajem. Hich jãg jẽbdi hõor hãrpiejemjöta naabahab hajim hanʌm, pãarjã. Pãachdëu nem jaau nʌm gaaimuata hagjö hõor Hẽwandam dau na hãrpi naabahab, mamʌ magʌmta hamau k'augba durrumgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Magbaa chi machnaanpa haig narr haawai hãbmua hũr hoo sĩi hawia Jesuug magjim hanʌm: —Maestro, pua warm k'ʌʌnag mag hiek'abapʌ̈im haig, hĩchab maar k'ĩirpata hiek'abapʌ̈ibahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Magbaa Jesuu hirig, —Chadma hajim hanʌm. Mamʌ ¡hëh, hapdurr, pãar chi machnaan hãba! Pãrau chará pãachta chi k'ap'ʌm hawia pãachdëu nem jaaum haig jaaujem. Jãg nʌm haig pãrau hõor hʌ̃r nem chʌk'ʌm jiirpʌ̈pʌ̈ik'amjöta naabahab hajim hanʌm. Pãach garmuan pãrau hõrag nem jaauwai pãach hipierraata hapi nʌm. Mamʌ mag nʌm pãachdëu chan waujöjöopaijã k'aba haajemgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Hëh, magʌm pãar chará! Pãar jöoinauta warrgarwe Hẽwandam hi jaaujerr k'ʌʌnjã k'ëchbajieb hajim hanʌm. Pãachdëucha k'abajim, mamʌ pãar ya hĩs hewagam k'ʌʌn hawia bʌ̃ʌrjã k'ĩet'uupaijã k'aba nʌmgui hajim hanʌm. Hamau bëptarr jã hʌ̃rjã pãar dën hajap'a p'ʌnaa hooimʌ wau k'ër nʌmua pãach hiiupain pãrau, “Mʌk'ʌʌn jöointa chadcha Hẽwandam hi jaaujerr k'ʌʌnau” haajem. ");
INSERT INTO noaH_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mamʌ mua pãrag jaauk'imgui hajim hanʌm: Jãg nʌm haig pãrau, “Hoobat Hẽwandam hi jaaumien maar jöoinau k'ëchtarr. Mʌʌgwaijã hagt'a hich jãg wënʌrrʌm hak'iin, maraujã hagjö k'ëchju nʌm” ha jaau nʌm k'abahab hajim hanʌm. Magaagta pãar dën warag ham jã hʌ̃rjã nem hooimʌ waunaa sirppapiba haba haajeeb hajim hanʌm, pãachdëu k'ëchbajim hawia. ");
INSERT INTO noaH_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jãgju k'ap'ʌta Hẽwandamau hich k'ĩirjug hee hĩchab magjim: “Mua pãar hat'ee hõor pʌ̈iju, mʌch hi jaau wënʌrramk'ĩir. Mag mua jʌr hauwia pʌ̈ibarm k'ʌʌn hãaur k'ʌʌn k'ëchpʌ̈iwia hãaur k'ʌʌn hẽudee sĩi k'oojem nem hẽudeemjö hẽk'aju” ha jaaujim warrgarwe. Magtarr haawai hĩs hewag pawiajã chadcha pãar hich magta t'ʌnaabahab. Magua pãadë mʌ hiek hũrbat hajim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Har warrcha mʌg jẽb hich Hẽwandamau hompaatarr haigmua hewag hi hiek jaau durraajerr k'ʌʌn k'ëch nʌm haig bag hãrtarr t'um, jũrr hich Hẽwandamau pãar hĩs hewagam k'ʌʌn gaaita t'ʌpʌ̈ijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Warrcha Abel t'õotarr hed bag hãrtarr haigmua hewagjã k'ĩeb jöoi Zacarías k'ararr Haai hi jëeujem deg t'õo naawai hãrtarr bagpa t'um pãach gaaita pajugui hajim hanaabá. Jã chan par hok'oobam, hichiita Hẽwandamau pãrag jëeub k'aba jëeujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mag hiek'ak'agmamua, ¡Hëh, hapdurr hajim hanʌm pãar, Hẽwandam hiek jawaag chi machnaan haajem k'ʌʌnta! Pãrau k'ap'ʌ nʌmgui hajim hanʌm, Hẽwandam hiekta hʌ̃gt'ar dubaag hat'ee yabmejö sim. Mag yabmejö simta pãachdëuta nacha garpawia bʌ̃ʌrjã hõrag jaauba nʌmgui hajim hanaabá. Pãachjã dubba nʌmta, chi dubam k'õsi nʌm k'ʌʌnagjã pãrau hʌdʌʌr dubpiba nʌmgui hajim hanʌm, hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesuu hamachig magbaawai, hamach chi machnaan fariseonaanpa hi dʌ̈i meeuk'a p'öbaadëjim haajem. Maimua warag hi dʌ̈i wëtumua hi t'ʌ hawaag ha hi haig p'ẽeudʌ bëenaa, jũrram k'ʌʌnau hamachdëu k'ap'ʌm hirig jëeup'öbaadëjim hanaabá, ");
INSERT INTO noaH_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mag hamachdëu jëeu nʌm jũrr hich Jesuu hipeerdʌ k'ãijã jaaubapäaiwai magʌm gaaimua chi t'et'em k'ʌʌnag hi pʌr deeg. ");
INSERT INTO noaH_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mag nʌm hee warag hõor pöoma p'ẽeudʌdʌk'amua jũrr chik'aman bʌ̈pa k'iut'ʌgmaajeejim hanʌm. Ham mamagk'am hee, Jesuu hich k'apeen hich dʌ̈icha hogdʌba wënʌrraajerr k'ʌʌnag magjim hanʌm: —K'ĩir k'ap'ʌ wënʌrrat'ʌ̃; hoob fariseonaan bën levadurajö sim pãach gaai dʌrbapimiet. Mua mag chirʌm haiguin pãrag, “Hoob hamjö chik'am k'ĩir haawaipaita chadam hiekjö hiek'anaa pãach hap haadeewai jũrr pãachdëu jaaujemjö k'aba nem waumiet” ha chirʌmʌugui hajim hanʌm. Pãrau ham higar p'ũrrbamʌn, pãach gaai dʌrbabaadeewai sĩi hamjö nʌisijugui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mʌg jẽb gaai haawai meraa hiek'atarr hiek k'ãijã mʌg hatag paawai sĩi hich mag sĩsiwia k'ĩir hak'oog k'abam. Maagwai nem meraa wautarr hawia k'ãijã hich mag k'augba sĩsibajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Magnaa hichdëupai, Mua pãrag mag chirʌmgui hajim hanʌm: Har pãrau pãach happai meraa hiek'abarm hiek mʌg hatag paawai jũrr t'umaam k'ʌʌnau k'ak'apdö hajugui hajim hanʌm. Maimua hagjö k'augbaju hawia puertdi k'ãijã hajap p'ãark'anaa hö sausau hiek'atarr hiekjã t'umaam k'ʌʌn jʌ̃g daar jũrr k'apanag hee t'et jaaujugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mag hich k'apeenag jajawagmamua hĩchab hich Jesuupai, ’Keena, har sĩi mʌg hamach wir haig chik'am k'eechjem k'ʌʌn hoob högk'amiet hajim hanʌm. Hamau pãar chi hʌ̃rʌmʌn chadcha k'ëchpʌ̈iwiajã pãar hak'aar chan pöd t'õo haubamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mamʌ hĩchab mua pãrag jaauk'im, k'aita pãrau hök'ö haju haai nʌ: Hẽwandamta hök'ö habat hajim hanʌm. Jãan chad nem jua t'eeg sim, pãar t'õowia pãar hak'aarjã k'ĩmie durr barpʌ̈yaag ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Pãrau hoowai p'atk'ondam pöm k'abamua nemchaaindam cinco për hauba haajẽ? Herraam gaai mag ham përpʌ̈imaajeeb mamʌ, hich Hẽwandamau chan ham chigjã haba, hajap'ata hoo p'ë wai sĩejem. ");
INSERT INTO noaH_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maagwai hoob k'ĩirjumiet hajim hanʌm. Pãar chará nemchaain k'ãyaujã hʌ̃rʌʌcha hirua hiigjem. Mag pãachta nemchaain k'ãyaujã hajapcha nʌm gaaimua, pãar pörbʌ̈ maadëu higbaju hayaa sim k'apanagjã hirua t'um k'ap'ʌ wai simgui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mag jajawagmamua hich Jesuupai magjim hanʌm: ’Har hõrau hichig jëeuwai hich himeerba mʌ hiek hʌ̈k'aajem ha jaau sim wounan, mʌg mʌch chi Hemk'ooi Hiewaaujã hĩchab hʌ̃gt'ar Hẽwandam chognaan t'ʌnʌm dak'ĩir, “Jãan chadcha mʌ garmʌu” hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mamʌ har hõrau hichig jëeuwai k'ãijã, “Mʌ chan hi higarm k'abam” ha sim wounan, muajã hĩchab hʌ̃gt'ar Hẽwandam chognaan t'ʌnʌm dak'ĩir hich k'ĩircha, “Jã chan mʌ dën k'abam, mua hi k'augba chitʌm” hajugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Hamach mʌg jẽb gaai nʌweran hamau mʌch chi Hemk'ooi Hiewaa higwia k'aigba hiek'awiajã hamach k'aibag Hẽwandamag chugpaapi jëeubaawai hʌ̈u chugpaapʌ̈iju. Mamʌ pekau hãb simgui hajim hanʌm, maan mua Hẽwandam Hak'aar jua t'eegau nem wau chitʌm hoo nʌmta warag mepeer gaai t'ʌ nʌmʌu. Mag pekau chan Hẽwandamau bʌ̃ʌrjã k'ĩir hok'oobamgui hajim hanʌm, hi Hak'aar higwiata mag hiek'a naawai. ");
INSERT INTO noaH_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pãachdëu mʌ hiek hʌ̈k'a nʌm gaaimua hõrau pãach pʌr hauwia, pãar k'ĩir sëuk'a hiek'aag judionaan Hẽwandam hiek jaaujem deg harrwia, chi t'et'em k'ʌʌn haarjã harrwai, hoob “¿Jãgata mua hiek'aagau?” wa pʌchig hiek'abaawai, “¿K'an hata mua hamag hiek'aju?” ha k'ĩirjumiet. ");
INSERT INTO noaH_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ya pãar hiek'aagpaawai hich Hẽwandam Hak'arauchata pãrag k'ĩirjug deejugui hajim hanʌm, k'ĩirjug k'ap'ʌ hiek'amamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jesús mag hijẽjẽbk'am hee, hãbmua k'apanag heemua hirig, —Maestro, mʌ naamʌg jigpi jaaubá hajim hanʌm, mʌ haai juagam nem pʌatarr heem mʌrʌg hagjö jãrrcha deemk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Magbaawai Jesuu hirig, —¿K'aíu pʌrʌg jaauwai, muata magʌm nemjã chi t'et'em k'ʌʌn dënjö jigpi jaauju haai chirʌm hajĩ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Maimua hĩchab t'um haig narr k'ʌʌnagpa magjim hanʌm: —K'ĩirjug paraa haajeet. Hoob pãrau sĩi nem k'ĩir t'um paarpaju happaita k'ĩirjumiet hajim hanʌm. Pãrau nem t'um wai naawia k'ãijã pãar hëu meebamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mag jaaupʌ̈pʌ̈igmamua hĩchab hamag mʌg nem hĩgk'aadam jaaujim haajem: ’Woun hãb p'atk'on paraam sĩerrau nem jĩirjim haajem. Mag hich nem jĩirtarr t'um heeuwia deg paa hauwia hoowai chi hãk'aajem di dʌ̈rr k'aba t'ʌnaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Magbaawai k'ĩirju hoo sĩi hawia hich wir haigpai, “¿Mua jãgata habark'iina?” hajim hanʌm, “ya mʌg mʌ nem hãk'aajem dijã p'ẽu t'ʌnʌm.” ");
INSERT INTO noaH_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mag k'ĩirju hoo sĩi hawiata, “Hãa” hajim hanʌm hich happai. “Jãgan mua mʌch k'öju nem hãk'aajem di jãg t'ʌnʌm t'u wërppʌ̈iwia deeumta jũrr nem dapag hëuk'a haujugui” hajim hanʌm, “k'oojem nemjã t'um dʌ̈rr hawia juagam nempa t'um hãba dʌ̈rr hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ya mag hëu haaipagk'anaa hãba paa t'ʌnʌisiewain chadau sĩi año k'apan p'it'urg chuk'u hag heempai hau k'ö chirsijugui” hajim hanʌm. Maimua, “¡Jöo! Magbaawain chad mʌg woun sĩi degpai jua hʌ̃inaa, mʌchdëu k'öm haig t'achjã k'önaa, dödöjöjã biwaa döbaadee sĩi honee hajugui” hajim hanʌm, hichdëupai hichig. ");
INSERT INTO noaH_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","’Maimua chadcha mag hichdëu k'ĩirju sĩerrjö di dapag hëuk'anaa hag hee t'um hãba paa sĩsiewai jũrr Hẽwandamau hirig magjim hanʌm: “K'ĩirjug chukdam, nau hĩsim hedaar pʌ meejugui” hajim hanʌm. “Mag pʌ meebaadeewai, pʌ nem jãg t'ʌnʌm paarpaag pʌ p'it'urg wautarr ¿jãga haagauma?” hajim hanʌm. “Par pʌ p'it'ur hawia pua tag hoobamgui” hajim hanʌm Hẽwandamau. ");
INSERT INTO noaH_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mag nem hĩgk'aa hĩgk'a höpʌ̈iwia jũrr haig narr k'ʌʌnagta, ’Hich jãgta haajemgui hajim hanʌm hĩchab, har sĩi mʌg jẽb gaaipai p'atk'on pöm paarpawia, nem k'ĩir t'um paraanaa, sĩi Hẽwandamag hoobamjöo haajem k'ʌʌn. ");
INSERT INTO noaH_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Maimua mag hich dʌ̈icha hogdʌba wënʌrraajerr k'ʌʌnagta, ’Mua pãrag jaauk'imgui hajim hanʌm: Hoob pãrau “¿k'ani k'öjuuta maach mʌg nʌma?” hawia hök'ĩirjuu hamiet. Wa magbam k'ai, ya k'ajũajã chuk'u nʌm, “¿k'ani jũajuuta mʌg nʌma?” ha k'ãijã k'ĩirjumiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pãarta nem k'oojem nem k'ãyaujã hajapchanaa k'ajũa k'ãyaujã hʌ̃rʌʌcha balee sĩsidʌmgui hajim hanʌm, Hẽwandam dau na. Jãg hichdëu pãar hompaatarrjö, pãrau nem hig nʌmjã hirua deebajup. ");
INSERT INTO noaH_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pãadë k'ĩirjubat hajim hanʌm, kuerrb jãga naajẽ. Ham p'idk'aba haajeewai hamach t'ach k'öju hãk'aagjã di chuk'u naab mamʌ, ham haugchëba haajemgui hajim hanʌm, hich Hẽwandamauta hamag p'at'au deejeewai. Magʌm pãar chará nemchaain k'ãyaujã hajapcha naawai, ¿jãga hirua pãrag hooba habarju? ");
INSERT INTO noaH_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hoob hatcha pãachdëu nem hig nʌmta k'ĩirju nʌʌ hamiet hajim hanaabá. Mag pãrau pãachdëu k'õsimta hig nʌʌ hak'iinjã, ¿k'aíuta mʌg nʌm haig mag hichdëu k'ĩirju sim gaaimuapai hich meeju harr hʌ̃r horadam hãbpai k'ãijã hich hiiupiju haai sĩ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pãrau jãg p'it'ur k'abam nemdampaijã pödba nʌm, ¿k'ant'ee warag pãachdëu nem hig nʌmjã pödba nʌmta warag hãba haata k'ĩirju nʌʌ haju haai nʌ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pãadë har pamaardam hooihmʌ t'ʌnaajem k'ĩirjubat. Ham hĩchab bʌ̃ʌrjã p'idk'ajã p'idk'aba, ni hamach k'ajũa jũaju k'ĩirjuwia k'a hẽk'a nʌʌjã haba haajem. Mag naab mamʌ hiwiir hãbmuajã ham dʌ̈i barba haajemgui hajim hanʌm, hooimʌg hat'ee. Warrgar rey Salomón k'ararraujã p'atk'on pöm paraanaa nem hajap'ampa paraa haajerraujã pamaardam hooimʌgjö chan pöd k'ajũa jũaba haajeejimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pamaar jãg hooimʌ t'ʌnʌm hedau wʌʌbaadëmuapai k'iugp'ëbaadeewai sĩi k'ʌʌijemjã Hẽwandamau jãg hooimʌ wai sĩejemta, ¿jãgwia pãar pamaar k'ãyaujã hʌ̃rʌʌcha balee nʌmua nem jëeu nʌmta hirua deeba habarju? ¿Wa pãachdëu jëeu nʌmjã pöd deebajupii haajẽwa? hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pãach t'ach k'ö nʌm dʌ̈i dödöjö döju chan hoob pãrau hatcha k'ĩirjumiet hajim hanʌm. Wa jãga pãachdëu nem hig nʌm paarpajujã hoob k'ĩirjumiet. ");
INSERT INTO noaH_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, hõor t'um Hẽwandam hiek hʌ̈k'abam k'ʌʌnta magʌm nem k'ĩirju p'öbaadëmjã pʌaba sĩerrjëem. Mamʌ pãar Haai Hẽwandamau pãrau nem hig nʌmjã t'um k'ap'ʌ sĩewai pãar chan warm k'ʌʌnjö magju k'aba nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mag k'ãyau warag Hẽwandam hipierraa hajuuta k'ĩirjubat. Pãrau chadcha magmʌn, tagam nem pãachdëu higbarmjã hirua deeb k'aba deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Pãar chi mʌ bʌ̈ hogdʌba wënʌrrʌm k'ʌʌnan chadcha k'apan k'aba durrum. Mamʌ k'apanag hee pãach happai k'apan k'aba nʌm hawia hoob nem hök'ö wënʌrramiet hajim hanʌm. Pãrau maach Haai hipierraa hamʌn, hirua hich durr pãar p'ë harr nʌm hora pãar dʌ̈i nem hajap'a haju. ");
INSERT INTO noaH_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pãach nem wai nʌm përk'ʌʌimamua chi p'atk'on hap'ʌʌm k'ʌʌn hoomampierr jigpetat hajim hanʌm. Magbaawai pãrau hʌ̃gt'arm p'atk'on jẽeuba haajemta paarpajugui hajim hanʌm. Nem hajap'am pãrau mag wai nʌisim chan bʌ̃ʌrjã höbam. Ma mʌg jẽb gayam p'atk'on k'ĩir k'aba haawai nem jĩgk'aag chi hajap'amʌu hawiajã pöd haubam, ni comejenaujã hag hee dik'abamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mʌig jẽb gaai nʌweta nem t'um paraa haju k'ĩirjuju k'ãyau, hʌ̃gt'ar paawaita nem t'um paarpaju k'ĩirju wënʌrrʌmʌn magan chadcha pãar k'ĩirjug hãba Hẽwandam gaaita simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Mag jajawagmamua hich bëeju higwia magjim haajem hĩchab: ’Hõrau hamach patrón hõor jua pʌr nʌm haar matarr deeu bëeju nʌ nʌmua dauk'ana hõtdau p'uu nʌajemjö, pãarjã hĩchab hajap'a k'ĩir k'aug nʌisit hajim hanʌm, mʌ bëeju nʌawai. Mag hõrau hamach patrón barbaicheewai weeu hawaag nʌajemjö, mʌ bëejuuta nʌbat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, har chi chognaan mag dauk'ana hamach patrón nʌ nʌm k'ʌʌnan honee haju, hi barbaicheewai. Mag hamau dauk'ana hich nʌ nʌm hoobaicheewai, hichta jũrr chi chogk'a simjö ham sĩi nʌmich, mes gaai t'ach t'öik'awia ham jãhogjugui hajim hanaabá, hich garmuata. ");
INSERT INTO noaH_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chi chognaan hamach patrón hedacha pamjã bëeba ni hãspajuag pamjã bëeba sim hee warag dap'ökagjã higba nʌ nʌm k'ʌʌnan honee hajugui hajim hanʌm, hi da bëeba hawiajã hich pierrwai hamach dʌ̈i hajap'a haju k'ap. ");
INSERT INTO noaH_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, hãbmua k'ãijã hich di haig nem jĩgk'aan bëeju hora k'ap'ʌ hak'iin, bʌ̃ʌrjã k'ãiba warag sĩi t'ʌa hëeju, hʌdʌʌr hich nem jĩgk'apiba. ");
INSERT INTO noaH_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Magua muan pãragjã “Hich hagjöta hajap'a k'ĩir k'aug nʌisit” ha chirʌmgui hajim hanʌm. Pãrau mʌ bëeju hora chan hãbmuajã k'augbam. Pãrau mʌ da bëebajupii nʌm hee, mʌch chi Hemk'ooi Hiewaan dëgölp barchëju ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Magbaawai Pedroou Jesuug, —Señor, pua mag jaau sim, ¿maragpaita pua jaau chirʌ́, wa t'umaam k'ʌʌnagwa? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—Pãragpai k'abamgui hajim hanʌm; mua mag chirʌmʌn pãach t'um chi mʌ hiek hʌ̈k'a nʌm k'ʌʌnagau. Magnaa, Pãadë hũrbat hajim hanʌm: k'anim nemjö patrón hãb simua hich chaaug maagpaawai hich chog hãbamʌg warm k'ʌʌn pörk'apinaa hich magʌgpai hich nem t'um jaau pʌabajëm. ");
INSERT INTO noaH_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Maimua mawi, mam sĩi hawi deeu bëewi hichdëu jaau pʌarrjö p'idk'a sim hoobaicheewai, ¿mag jöoi hich chog dʌ̈i honee sim dʌ̈i chi chogjã honee habaju k'ai? ");
INSERT INTO noaH_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mag hajap'a p'idk'a sim hoobaicheewai jöoirau warag hich nem t'um magʌgta t'ʌsĩepʌ̈ijugui hajim hanʌm, hich dënjö k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mamʌ magba mag hichig nem jaautarrjã hich hödegpai, “Mʌ patrón chan da bëebam” hawi nem k'aibag hich k'apeen jũrr hich jua heegpaim k'ʌʌn dʌ̈i hichdëu hampierr hanaa, nagjã hichdëu döm haig dönaa, t'achjã hichdëu k'öm haig k'ömʌn, ");
INSERT INTO noaH_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","chi dik'ʌ bʌ̃ʌrjã hirua nʌba sim hee bëewi mamagk'am hoobaichee, jũrr hichdëu warm k'ʌʌn dʌ̈i haajerr k'ãaijã hi gaai hat'uucha wʌnaa, p'idag heemuajã barpʌ̈inaa, chi k'aigbacharam k'ʌʌn dʌ̈i hãba sĩujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Magua pãadë mʌ hiek hũrbat hajim hanʌm: hãbmua k'ãijã hich patronau hichig nem jaau pʌatarr k'ap'ʌ simta, dëgölp hich hoochëjujã k'ĩirjuba, ni bʌ̃ʌrjã hirua nem k'õsim nemjã waubamʌn, mag patronau hich bëem hed hi gaai mas deejugui hajim hanʌm, bʌ̃ʌrjã dau haug k'augba. Hich hagjöta hajugui hajim hanʌm hĩchab Hẽwandamau, har hajap'a wënʌrraju k'ap'ʌ nʌmta nem k'aigba waaujem k'ʌʌn gaai. ");
INSERT INTO noaH_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mamʌ hãbmuata k'augba haawai nem k'aigba waumʌn, Hẽwandamau hi gaai mas hab k'aba mas hajup mamʌ, hagpierrpai deejugui hajim hanaabá. ¿Pãrau hoowai har nem dʌ̈rrcha deetarrag hagjö hich deetarrpierr dʌ̈rrcha jëeuba haajẽ? hajim hanʌm. Mua pãrag magk'imgui hajim hanʌm: T'umaam k'ʌʌnau Hẽwandam hat'ee nemdam bʌ̃rʌʌm hawiajã wauju haai nʌm. Har chi hʌ̃rʌʌcha wauju k'ap'ʌ nʌm k'ʌʌnag hirua hich hagpierr dʌ̈rrcha jëeujem. Maimua har hich hat'ee nem dʌ̈rrcha wauju pödba nʌm k'ʌʌnag hirua hagjö hich hagpierr bʌchk'unpai jëeujemgui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Mʌʌn mʌg jẽb gaai hõor durrum k'ʌʌn hee mʌch hiekta p'ũak p'uu wëjöm hee hõtdau dʌrbapʌ̈imjö hapienta bëejimgui hajim hanʌm, hich Jesuu. Ya mag hõtdau pa sim, mamʌ mʌchdëu k'õsi chirʌmjö warag huu pa jẽerdʌmaa hak'iin hajapcha hak'amgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mamʌ magaagan hõor jua machgau hagt'a hajapp'a dau haug wauju waaur chirʌmgui hajim hanʌm. Mʌch dʌ̈i hõrau magju t'umaa k'ĩirjubaadeewaita hök'ĩirjug pöoma chiraajem; mamʌ hichiita hich mag hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pãrau k'ĩirjuawai mʌ sĩi pãar k'õinaa bibigag chukk'u naamk'ĩirta bëejĩ? Pãar magamk'ĩir k'abajim. Mʌg mʌ bëetarran mʌg mʌchdëu Hẽwandam hiek hõrag jaau chitʌm gaaimua hõor k'ĩirjug haaip'ur warag chaaur k'ĩirju nʌrrjëe hamk'ĩirjöta bëejimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mua mag chirʌmʌn, mʌg mua jaau chitʌm gaaimua hãbam deg k'ãijã cinco naajem k'ai, hõor t'ãrjupam k'ʌʌnau jũrr numiim k'ʌʌnau mʌ hiek hʌ̈k'a durrum k'ʌʌn hichaaur hiek'aju haawaita mag chirʌmgui hajim hanʌm. Wa magbam k'ai, jũrr numpaim k'ʌʌnau k'ãijã t'ãrjupam k'ʌʌnau k'ĩirjug hajap'am wai durrum k'ʌʌn higar k'aba wënʌrrajugui ha jaaumajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magp'öbaadeewai chi hayau mʌ hiek hʌ̈k'am k'õsi hʌ̈k'a sim hee, jũrr chi chaairau mʌ hiek hʌ̈k'amap'a hajugui hajim hanʌm. Hʌʌinjã hagjö, chi hãdau mʌ hiek hʌ̈k'am k'õsi hʌ̈k'a sim hee, jũrr chi k'aau bʌ̃ʌrjã mʌ hiek hʌ̈k'amap'a hajugui hajim hanʌm. Wa magbam k'ai, chi p'aauhũanau mʌ hiekdam hich hãigog jaau k'itaawai, jũrr chi hãigou hich p'aauhũan hichaaur hajugui hajim hanʌm, mʌ hiek hʌ̈k'amaaugau. ");
INSERT INTO noaH_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Maimua hõor k'apan hĩchab haig narr haawai hamagjã magjim hanʌm: ’Hedau duubjem garta hedjã k'ĩbaadeewai, “Nosegan hurum” haajem pãrau; chadcha hich maagjemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Maimua har p'ũ k'ãijã dok'ẽu garmua p'ua t'ʌnʌisiewai, “Hedau pechag wʌʌju haawai” haajem pãar hiek; magʌm hed chadcha hich mag pechag k'eeujemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pãrau magʌmjã k'aug hahau haajemta, ¿jãgwia hĩs pãrau pãach daúa mua nem wau chitʌm hoo nʌmjã pöd k'aug hauba nʌ hajim hanʌm, mʌ chadcha hich Hẽwandamau pʌ̈iju jaaujerr chaark'a chirʌm? ");
INSERT INTO noaH_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mag jajawagmamua hich Jesuupai hamag, ’¿Jãgwia pãrau pãach wir haigpai pãach Hẽwandam na k'aigba nʌm k'aug hauwia pöd “Maran chadcha k'aigba nʌm” haba nʌ? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mua pãrag jaauk'imgui hajim hanʌm: Hãbmua k'ãijã leinaanag pʌ k'aibag waumk'ĩir pʌch jawaan harrwai chi t'et'emnaan haar barwi jaauju nawe hi dʌ̈i hajap'a hiyʌ̈ʌ hawi k'õinaa nʌisit ha chirʌmgui hajim hanʌm. Magbamʌn chi t'et'emnaanau guardianaanag pʌ pʌr deebaawai jũrr mak'ʌʌnau pʌ cárcel deg pʌ̈ibajup hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cha mʌ hiek'a chirʌm hiek'au ya pʌʌta hamau mag p'ãar hat'amʌn, p'atk'on gaaimua harr k'ai, hãbmiecharam centaaudam p'agpʌ̈ibam haigjã hamau pʌ höbeerpʌ̈ibajugui hajim hanʌm. Mua mag chirʌmʌn, pãach k'aibag Hẽwandamag chugpaapiju haai nʌwe chugpaapiwi hi dʌ̈i k'õinaa hajuuta hẽk'abat ha chirʌmʌugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hich mag hed gaai hĩchab hãaur k'ʌʌn hich Jesús sim haig bëewi hirig nem hĩgk'a naaichëjim haajem. Mag hĩgk'amamua hirig, —Galileapien Haai hi jëeujem deg nemchaain k'ëchwia p'aa nʌmua hagua Hẽwandamag hamach k'aibag chugpaapi jëeu naajimgui hajim hanʌm. Ham mag Hẽwandamag jëeu durrumta, ham haig Pilato soldaaun bëewia sĩi ham k'ëchpʌ̈ichëjim haajemgui ha jaau naaichëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mag hichig jaaubaicheewaita Jesuu hamag, —¿Pãrau k'ĩirjuawai, mag Pilato soldaaunau dau haugjã chuk'u k'ëchpʌ̈itarr k'ʌʌn warm k'ʌʌn hagjö Galileapienk'a t'ʌnʌm k'ãyaujã hatcha k'aibag pöm sĩsid haawaita mag ham k'ëchpʌ̈ijim k'ai? hajim hanʌm jũrr hamag. ");
INSERT INTO noaH_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mag gaaimua k'abajim, mamʌ mua pãrag jaauk'imgui hajim hanʌm: Pãrauta chadcha pãach k'aibag t'umaa hãsie hewag k'ĩirjuwia Hẽwandamag chugpaapi jëeubam chan pãachjã dʌ̈i k'ëchjurau hajim hanaabá, hamachigcha. ");
INSERT INTO noaH_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Wa pãrau k'ĩirjuawai, har t'ʌrrdö Siloé haajem higaau di pöm sĩerr burrwai hõor dieciocho k'ëchtarr k'ʌʌnta tagam k'ʌʌn Jerusalén p'öbör hee naajem k'ʌʌn k'ãyaujã hiekk'õr pömaacha naajĩwa hajim hanʌm, Hẽwandam dau na? ");
INSERT INTO noaH_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mag hamach happaita Hẽwandam dak'ĩir hiekk'õr pömaacha narr gaaimuajã k'abajimgui hajim hanʌm, deeu hichdëupai. Hẽwandam dak'ĩran t'um hich hagjö t'ʌnʌm, nem k'aibag. Pãraujã hĩchab pãach k'aibag t'umaa k'ĩirjuwia Hẽwandamag chugpaapi jëeubam chan pãach t'um ni hãbjã peerdʌbamgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mag jaau dichwia hichdëupai mʌg nem hĩgk'aa hamag jaaujim haajem: ’Woun hãbmua hich uvadö hee nemjõ higo hanʌm jĩir wai sĩejim haajem. K'ãai hãb jõm k'õchag haadeewai haar hoon majim hanʌm. Mamʌ mag hoon maawai bʌ̃ʌrjã chëba sĩi hë meuu dʌnaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Magbaawai di haig pachëwia magjim hanʌm, chi nemjĩir jaarjemʌg: “Higo jõm k'õchgau año t'ãrjup pam sĩi haar hoo k'ʌrrk'a chirʌm; mamʌ chëba sĩerraawai gaai hooimaba haajem. Jãgan jãg sĩpí warag t'ubapʌ̈i” hajim hanʌm. “Magba par chëbam jãg sĩejemgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Magbaawai, “Patrón jöoi, magan hidëu año hãb hoo hat'á” hajim hanʌm, chi nemjĩir bʌ̈ p'ʌajem wounau. “Jãg sim k'ai, mua warag hag bʌ̈k'ʌrr wa p'ʌʌrdʌpʌ̈inaa p'ʌichichagau hi bʌ̈ k'uajugui” hajim hanʌm, “chëmk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mag bʌ̈ k'uabaawai chëmʌn hʌ̈uma” hajim hanʌm. “Mamʌ mag bʌ̈ k'ua nʌmjã hich magpai chëba habarmʌn magan chadau t'upʌ̈ijugui” hajim hanʌm, chi bʌ̈ jaarjemua. ");
INSERT INTO noaH_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Biek hãb jua hʌ̃i nʌm hed Jesuu Hẽwandam hiek jaau sĩejim haajem, judionaan hãba biirdʌwia Hẽwandam hiek jaaujem deg. ");
INSERT INTO noaH_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Maig hʌʌi hãb sĩejim haajem. Mag hʌʌi mor machpawia dieciocho años sĩi jã bʌrëu k'itaajeejim hanaabá, bën k'aigbam hi mor hee dubwia. Magtarr haigmua pöd bʌ̃ʌrjã p'õ k'ajap'a t'ʌrrk'aba hich mag k'itaajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesuu mag hoo hat'aawai dau hee haug k'augwia, hi t'ʌ̃r haunaa hirig, ");
INSERT INTO noaH_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","“Mua pʌ monaauk'im” hanaa, hi hʌ̃r jua hausĩubarm bʌ̈rre p'õ t'ʌrrk'a k'ajapp'a hoo dʌnʌisijim hanaabá, monakk'a. Mag hich monaaubapäaiwai honegau Hẽwandamag, “Hẽwandam, hĩsin chadau pua mʌ hʌ̈uta habarm. Pʌjö jua t'eegk'am chan mʌg jẽb gaai chuk'um. Hʌ̈u habarmgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mamʌ magbaawai mag hamach hãba biirdʌ nʌm hag degam chi pörk'a sĩerr Jesús dʌ̈i meeuk'abaadëwia jũrr k'ĩir mor chigpai hõragta, —Seman gaai seis diaspai p'idk'aju haai nʌmgui hajim hanʌm. Mag seis diam heen chadau pãadëu bëewia pãach monaaupibat hajim hanʌm. Mamʌ hoob mʌg sĩi jua hʌ̃i k'eeujem hed k'abajupama hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Magbaawaita maach Pör Jesuu hirig magjim hanaabá: —Woun sëunem, ¿k'ant'eeta pʌ mag chitʌ́ma? hajim hanʌm. Pãar mag jua hʌ̃ʌijem hed bʌ̃ʌrjã p'idk'aba haajem hanʌmta, ¿k'an jãgwia pãrau pãach cabaai wa p'ak k'ãijã dö döpien p'ë harrjẽma? ¿Jãg nʌm chan magan p'idk'a nʌm k'abahab? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pãrau pãach nemchaainjã mag dö döpi k'ʌrrk'a nʌmta, ¿k'an jãgwia mʌg hʌʌi hĩchab warrgar jöoi Abrán k'ararrau hʌ̈k'aajerr hag Hẽwandam gaai hʌ̈k'a simta pöd hi monaauju k'aba sĩ, jua hʌ̃ʌijem hed hawia? Jãg sim haig hijã hĩchab dieciocho años meperau hi pʌrnaa hö jʌ̃ wai simjö simta hẽerpʌ̈i nʌm k'abahab hajim hanʌm, jãg bënëu hi hogdʌpʌ̈imk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesuu mag hamach höbeerbapʌ̈im hũrwia hi hoomap'a haajem k'ʌʌn t'um chigaa hap'öbaadëjim hanaabá, hamachta. Mag ham chigaa nʌm hee, tagam k'ʌʌn t'um haig narr k'ʌʌnau hamach daúa Jesuu mag nem wau sim hoo nʌm gaaimua honee nʌm hiek'au Hẽwandamag, “Hʌ̈u chadcha pua marag pʌch jua t'eeg hoopibarm Hẽwandam; hag na marau mʌgjö chan nem hooba haajemgui” ha hiek'a naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mag hiek'ak'agmamua hĩchab magjim hanʌm hich Jesuu: ’¿Pãrau k'ap'ʌ nʌ, jãga sim habarí Hẽwandam hiek mua jaau chitʌm, maimua k'anjöta sim ha mua pãrag jaaubark'iin? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Magnaa hichdëupai, Mʌg Hẽwandam hiek'an mostaza daudam woun hãbmua hich nemjĩir hee jĩirjemjöta sĩerrʌm. Hichta nemjĩir daudam t'umaam k'ʌʌn k'ãyaujã bʌ̃rʌʌcha k'itʌm. Mamʌ mag k'itʌmʌn nem bãau k'ap'í bãauwia sĩi pabʌ̈ pöm hãdëe dʌnʌisiejemgui hajim hanʌm. Mag hãdëe dʌnʌisiewai nemchaaindamau hag gaai hamach didam hëup'öbaadeejem. Hich hagjöta simgui hajim hanʌm hĩchab mʌg Hẽwandam hiek mua pãrag jaau chitʌmjã. Mʌʌgwaiwe chan k'apan k'abata hʌ̈k'a durrum; pari mag durrumuata warag nem pöm haaidʌbapäaiwai, hõor k'apank'am k'ʌʌnau hʌ̈k'ajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Maimua deeu hichdëupai hamag, ’Pãrau k'ĩirjuawai ¿jãga sim habarí Hẽwandamau hich hiek haaidʌpi nʌm, maimua jũrr k'an dʌ̈ita mua pãrag jaaubark'iin? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hich hiiu haawai hich hiek haaidʌpi nʌmʌn, hʌʌi hãbmua harin dʌ̈rrcha sim hee levadura pʌ̈itarrjöta sĩerrʌmgui hajim hanʌm. Levadura bʌ̃rʌʌ pʌ̈itarrjã maadëu haaidʌmam chan hooba haajem; mamʌ mag simuan harin t'um hʌrpi haaujem. Hich hagjöta simgui hajim hanʌm hĩchab Hẽwandam hiek mʌg mua jaau chitʌmjã. Mʌʌgwaiwe chan hõor pöm mʌg wëjöm hee hagt'a pömcha haaidʌba sim. Mamʌ mʌg hatagta durr warp'am magwe haaidʌbaadee t'umaam k'ʌʌnau hũrab k'aba hũrjugui hajim hanʌm, hich Jesuucha. ");
INSERT INTO noaH_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuu hich mag Hẽwandam hiek jaau nʌrraajeejim haajem p'öbörpierr, didam k'apan k'aba dʌnʌnʌidʌm heem magwe hich nʌrrʌmpierr. Mag mamua warag Jerusalenag maa hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hi mag nʌrrʌm hee hãbmua hirig, —Señor, ¿hʌ̃gt'ar höbërju k'ʌʌnta k'apanaacha nʌ wa hok'ooju k'ʌʌnta k'apanaacha nʌwa? hajim hanʌm. Magbaawai Jesuu hirig, ");
INSERT INTO noaH_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Hʌ̃gt'ar höbëraagan, puertdidam bʌ̃rʌʌ k'itʌm hee dubaagpamjöta haajemgui hajim hanʌm. Muan pãragan, mag puertdidam p'ĩrk'i k'itʌm heeta dubju hẽk'abat ha chirʌm. Mʌg hatag hõor pöm hag hee dubam k'õsi hajup mamʌ, mag t'ʌnʌm k'ʌʌn heem hãbjã pöd dubbajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pãrau dubaag hẽk'awiajã ya chi dik'ʌ jöoyau p'ãarbapʌ̈im chan, par pãrau daaugajãrmua, “Señor, maar weeu hat'á” hawiajã, jũrr hierrmua hirua pãrag, “¿Pãar jamaam k'ʌʌnauma? Pãar chan mʌ haiguim k'ʌʌn k'abamgui” haju, warag weeu haubaju haawai. ");
INSERT INTO noaH_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Magbaawai pãach weeu haumk'ĩir, pãrau hirig magjurau: “¿Pua maar k'augbata chirʌ́? Maar pʌ dʌ̈i hãba t'ach k'oojerr k'ʌʌn k'abahab. Pʌ k'abajieb maar maestro. Pua hante maar p'öbör hee Hẽwandam hi jaauba haajeejieb” haju hirig. ");
INSERT INTO noaH_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mamʌ magbaawai hirua hĩchab pãrag magju: “Ya mua pãrag jaaubarm. Mua chan tag pãar k'augbam. Pãach sĩi nem k'aigbam happai wau wënʌrraajerr k'ap, pãadëu warag pãachta mʌ haigmua chawag hërëubaadët” ha hiek'ajugui hajim hanʌm, Hẽwandamau pãrag. ");
INSERT INTO noaH_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pãrau hoowai chadcha pãach daaugajãrpai t'ʌbagk'a nʌisim hoobaawai, pãrau hicharaucha sereeu höo t'ʌnʌmua, warag gaai machgaupa hihesse haadëp'ʌmua, pãrau hoojugui hajim hanʌm: jöoi Abrán, Isá, Jacob, maimua tag warrgarwe Hẽwandam hi jaaujerr k'ʌʌn hich dʌ̈i hãba hi bigaau honee hohoodö nʌm. Maagwai pãachta k'õinaa ham mag honee nʌmjö hi dʌ̈i wënʌrraju haajerr k'ʌʌnta pãran hich mag hiseg nʌisim hiek'augui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Maigta pãar k'ĩir machag hajugui hajim hanʌm, pãach pöd dubba nʌm daar durrpierram k'ʌʌnpata dub t'ʌnʌm hoowia. Maig t'ʌnaaju: hedau höbeerjem garm k'ʌʌn, hedau duubjem garm k'ʌʌn maimua deeum durram k'ʌʌnpa bëemawia Hẽwandam dʌ̈i hãba honee t'ach k'oog hohood hap'öbaadëjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mag Hẽwandamau hõor hi hagk'abaadëm hed har mʌg jẽb gaai haawai hamachta warm k'ʌʌn k'ãaijã hajapcha nʌm haajem k'ʌʌnta k'apan k'abacha höbërju. Mag k'ãyau har chik'amnau serbiibag p'ëejem k'ʌʌnta k'apanaacha Hẽwandam sim haar höbërjugui hajim hanʌm, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hich mag hedcha Hẽwandamau Moiseeg hich hiek p'ãpitarr hajapcha hʌʌrk'aajem k'ʌʌn Jesús haig bëewi hirig, —Rey Herodeeu pʌ t'õopäaig hẽk'a sim. Pʌchta mʌigmua jöpk'aa higbaad haichëjierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Magbaawai hichdëu hamag magjim hanʌm: —Hërëubaadëwi hirig, “Hich hip'it'ur hidëu mag sim; mʌg hed gayan mʌʌn hichiita hich mʌg hõor mor hee bën k'aigbampa jʌr wërpnaa hich mʌg hõor monaau chitaju” ha jaaubaimat hajim hanʌm, mʌ himeerba. Magnaa hĩchab, Ya mʌ p'idag höimʌʌ pamam; ");
INSERT INTO noaH_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","mag hagt'a höba sĩewai hich mʌg mʌch p'idag höpʌ̈ibam haarjã hogdʌba jaau chitʌmua Hẽwandam hi jaaujem k'ëchmien p'öbör hee barjugui hajim hanʌm, Jerusalén. ¡Jãga mag mʌjã hĩchab Hẽwandam hi jaaumieta Jerusalén p'öbör chaaur hamau mʌ t'õobarjugui! hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Maimua Jerusalenpienta warag hʌ̃apërwia magjim hanʌm: ’¡Hëh! ¡Aay, Jerusalenpien! Pãraun chadcha warrgarweta Hẽwandamau hich hi jaaumk'ĩir chogpʌ̈i nʌm k'ʌʌnjã k'a k'õchk'aba, pãrau warag mokoujã ham bar wai nʌmua k'ëchpʌ̈imaajemgui hajim hanʌm. Biek k'apan mua pãrag jaaujeejim, hãt'ãrr hʌʌirau hich chaaindam t'umaa hich hich heegar t'ʌa wai juupjemjö, pãar t'ʌa wai chitaag. Mamʌ magtarrjã pãachdëuta bʌ̃ʌrjã mag k'õchk'abajierramgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jãgtarrau nau pãrau hoomaa habarjugui hajim hanʌm. Nau mʌ mʌg chitʌʌ hawia petaawai Hẽwandamau sĩi di pariim hee wouchnaan p'ëpʌabaajemjöta t'ʌbagk'a nʌisijugui hajim hanʌm, pãran. Magbarm haigmua chan tag pãrau mʌ hoobamgui hajim hanʌm. Pãrau mʌ hoojuun, hãba ya pãachdëucha deeu mʌ hurum hoowia, “Hʌ̈uchata Hẽwandam, pua pʌch jũrr pʌch Chaaita maar hat'ee Reik'a pʌ̈ibarm” hanʌm haigta pãrau deeu mʌ hoojugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","K'ãai hãb fariseonaan heem hãb hĩchab chi pörk'a simua Jesús hëeurrjim haajem, hich di haar hi dʌ̈i hãba t'ach k'oog. Mag hed sĩi jua hʌ̃ʌijem hed harr haawai hamachdëun hãba hirigta heerpapa haajeejim hanaabá, heeu dëgölp mag pöd bʌ̃ʌrjã nem wauju k'abam hedta bʌ̃ʌr k'ãijã jua peert'ʌ nem waubaawai magʌm gaaimua hi himeraa pʌr hawaag. ");
INSERT INTO noaH_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mag ham t'ach k'ö nʌm haig bëewi sĩejim haajem hĩchab, woun hãb k'a höhöodö k'itʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mag hoobaawai warag hiyʌ̈ʌ nʌmua Jesuu chi machnaanag jëeunaa hĩchab chi fariseonaanagjã jëeumamua, —¿Pãrau hoowai mʌg jua hʌ̃i nʌm hed hõor mor masim k'ʌʌn monaauju haai sĩ, wa monaauju haai k'aba sĩwi? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mamʌ mag hamachig Jesuu jëeubarm hũr nʌmjã ni hãbmuajã jʌ̃ʌ habajierram hanaabá. Mag hamachig k'abamjö warag k'ĩuu habaawai mag chi k'a höhöodö k'itʌm hich haig t'ʌ̃rnaa, hi gaai pʌrbaawai monaaupʌ̈iwia, hirig, —Pʌ maju haai chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Maimua jũrr hich dʌ̈i hãba t'ach k'oog haig narr k'ʌʌnag magjim hanʌm: —Pãar cabaai k'ãijã wa pãar p'ak k'ãijã jẽbdeg burrwia pöd hich hap höbërba sĩsim hoobaawai, ¿k'aíuta hag bʌ̈rre mawia hich nemchaai jẽu haubaju k'ai hajim hanʌm, sĩi jua hʌ̃ʌijem hed hawia? ");
INSERT INTO noaH_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mamʌ hich hiek hʌ̈k'amk'ĩir par hirua mag jëeu hohook'amjã ni hãbmuajã hi hiek hʌ̈k'abajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Maimua Jesuu hoowai, jũrram k'ʌʌnau hamachig jaauba nʌm hee hamachdëuta sie hajapcharam jʌr haunaa nacha hohood haadeewai, chi t'ʌ̃rk'ʌʌipʌ̈iwia bëetarr k'ʌʌnag magjim hanʌm, ham wawimamua: ");
INSERT INTO noaH_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Dëgölp hãbmua k'ãijã hich jua pʌr nʌm p'iesta hee pãach t'ʌ̃r haauwai, hoob pãach k'ĩrau chan sie hajapcharamta hook'anaa pãachta pör garcha jupmiet hajim hanʌm. Magbam heeu mag sie pãach k'ãyau chi t'et'em k'ʌʌn hat'ee wai nʌm gaai k'ãijã pãach jupduk'am. ");
INSERT INTO noaH_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mag pãachta sie hajapcharam gaai hohoodö nʌm haig, chi jua pʌr chirʌm wounau bëewi pãrag “P'iidʌtk'abat, mʌg sie deeum k'ʌʌn hat'eemʌu” haicheewai, heeu dëgölp pãar k'ĩir naauwia jũrr hõor hëugarcha k'ĩir naa hohoodö haimaduk'am hajim hanʌm, tagam k'ʌʌn dak'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Magju k'ãai hãbmua k'ãijã hich jua pʌr nʌm p'iesta hee pãach t'ʌ̃r haauwai pãachta warm k'ʌʌn hëugarcharam sie gaai jupbat hajim hanaabá. Pãar mam hohoodö nʌm hoobaawai, chi jua pʌr chirʌm wounau pãrag, “Keena, jũrr mau na jupbahut” habaawai, chigag chuk'u pãachta warm k'ʌʌn na hohoodö haimaju. ");
INSERT INTO noaH_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mag, pãrag mag chirʌmʌn, har hamach t'öwia chik'am dʌ̈i hat'uucha haajem k'ʌʌnta jũrr mʌg hatag paawai ham Hẽwandamag chaigpa hoo sĩsidʌ haju. Maimua har mag hamach dʌ̈i hat'uu nʌm k'ʌʌn hichaaurjã magʌm haba sĩi warag serbiibamjö haajerr k'ʌʌnta jũrr mʌg hatag paawai Hẽwandamau warm k'ʌʌn k'ãyaujã hʌ̃rpai hapiju hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Maimua hich t'ach k'ömk'ĩir t'ʌ̃rtarrag magjim hanʌm hich Jesuu: ’Deeu pʌch p'iejãb dʌ̈rrcha wauwia t'ach k'ömk'ĩir hõor t'ʌ̃ʌrwai hoob sĩi pʌch k'apk'ʌʌn happai t'ʌ̃rk'ʌyam hajim hanʌm, ni pʌch k'odnaan, ni sĩi t'ʌ̃r k'odpaim k'ʌʌn happaijã t'ʌ̃rba, ni sĩi p'atk'on paraam k'ʌʌn pʌch dʌ̈i hãba di dak'a naajem k'ʌʌn happaijã hoob t'ʌ̃rk'ʌyam. Pua magʌm k'ʌʌnta k'ĩirjuwia t'ʌ̃rk'ʌʌimʌn, magan hamaujã hagjö wauwia pʌ t'ʌ̃r hat'aawai deeu pʌrʌg p'agbarmjöta haju. ");
INSERT INTO noaH_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Magju k'ãai pʌch p'iejãb pöm waupʌ̈iwia t'ach k'oog hõor t'ʌ̃ʌrwai dau hap'ʌʌm k'ʌʌndamta t'ʌ̃rbá hajim hanʌm: har bʌ̈ bisi wa juadam k'ãijã bisi k'it'ëem k'ʌʌn, har k'u t'ũuiba t'ũuiba k'it'ëem k'ʌʌn, wa har dau k'ĩsu k'it'ëem k'ʌʌn k'ãijã. ");
INSERT INTO noaH_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pua mag k'it'ëem k'ʌʌn dʌ̈ita magmʌn, hamau chadcha pʌ dʌ̈i pöd hagjö habaju, mamʌ magtarr paar Hẽwandamauta jũrr pʌ honee hapiju. Har hi hiek hʌ̈k'a durrumua k'ëchtarr k'ʌʌn deeu hiiu p'iidʌ nʌm jaar, magtarr jũrran hichdëuta pʌrʌg p'agjugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mag Jesús hiyʌ̈ʌ sim hũrwia, hãb hi dʌ̈i hãba t'ach k'ö sĩerrau hirig, —Hʌ̃gt'ar pawiajã hich mʌg cha maach nʌmjö Hẽwandam dʌ̈icha t'ach k'ö sim wounan chadcha hi honee hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hichig magbaawai jũrr Jesuu hirig, —Mua pʌrʌg nem hĩgk'ak'imgui hajim hanʌm. Magnaa, Jöoi hãb sĩejim haajemgui hajim hanʌm. Mag jöoirau hõor k'apank'am k'ʌʌnag jaau wai sĩejim haajem, hichdëu p'iejãb pöm waubapäaiwai mak'ʌʌn t'um hich haig t'ach k'oon bëemk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Maimua chadcha p'iejãb wauwia, ya t'ach k'öju hed haadeewai, chi patrón jöoirau hich chog pʌ̈ijim haajem, hich dʌ̈i hiek'atarr k'ʌʌn haar jaaubaimaawai t'ach k'oon bëemamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Maimua mawia, chi chogau jajawagmampierr bëemaaugau, jũrr pogk'a jaaumaajeejim haajem, chi bëeju harr k'ʌʌnau. Nacha jaauwimatarr haiguimua magjim hanʌm: “Chaig hewaa jẽb për hautarr hoon maju chiraawai mʌ pöd mabam; hidëu hẽudeem hat'ee k'ërtarrau” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Maimua hãbak'ai haar jaaubaimaawai maguajã hagjö, “Mʌ pöd mabam, p'ak hemk'ooin diez heeu përk'a hautarr p'idag hee wai jẽraan p'ë harrju haawai. Jãgba hak'iin chadau mʌ mak'amgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hich mag jajawagmamua hẽudeecharam haar jaaubaimaawai magua paawai magjim hanʌm: “Mʌ maju hajieb mamʌ, mʌch hʌʌi dʌ̈i hewaa pa chiraawai pöd mabajugui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Magbaawai mag chi hiek jaau chitarr woun deeu hich happai bëewi hichig warm k'ʌʌnau jaaumarrjöo jũrr hich patronag jaauchëjim haajem. Mag hũrbaawai jöoi k'ĩir machag t'ʌnʌmua magjim haajem, hich chogag: “Petá” hajim hanʌm, “deeu. Maimua jöpk'ar jũrr kaaijã hee har dau hap'ʌʌ k'it'ëem k'ʌʌn p'ë haipidú hajim hanʌm: har bʌ̈ bisi wa juadam k'ãijã bisi k'it'ëem k'ʌʌn, k'u t'ũuiba t'ũuiba k'it'ëem k'ʌʌn, maimua har dau k'ĩsu k'it'ëem k'ʌʌnpa.” ");
INSERT INTO noaH_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mag jaaubaawai chi chogau mawia, hichdëu jaaupʌ̈itarrjö hawia, deeu barchëwia magjim haajem, hich patronag: “Mua t'um pʌchdëu jaautarrjö habarm. Mamʌ magʌmjã hagt'a hõor k'apaana dʌ̈rr haju simgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Magbaawai hich jöoirau deeu magjim hanʌm, hich chogag: “Jũrr p'öbör higaau mawia parhooba har hich jãg dau hap'ʌʌ k'it'ëem k'ʌʌn t'um pʌchdëu hoomam p'ë haipidú” hajim hanʌm, “warre hõrau di dʌ̈rrk'aba sĩwaag. Pʌch hiek hʌ̈k'aba habaawai hamag t'um hajap'a jaaumamua hichiita mua ham mʌch dʌ̈i t'ach k'ömk'ĩirta t'ʌ̃rk'ʌʌi chirʌm habá” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya maadëu k'ap'ʌ nʌm, har nacha t'ʌ̃rwia bëeba harr k'ʌʌnau chan hamau bʌ̃ʌrjã mʌ t'ach hisĩebajugui hajim hanʌm, chi nacha t'ʌ̃rtarr k'ʌʌn higwia. ");
INSERT INTO noaH_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mag Jesús mam dʌ̈i hi hẽudee hõor pöoma wëtmajim haajem. Mag hich hẽudee wëtum k'ʌʌnag magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Hãbmua k'ãijã mʌ dʌ̈i hogdʌba nʌrraju k'ĩirju simta k'ũchpaijã hich dënnaan k'a hogdʌmap'a wa hich hʌʌi, hich chaain, hich k'odnaan k'ãijã hogdʌmap'anaa hich dau hap'ʌʌ haju k'ãijã k'ĩirju sim chan, pöd mʌ dʌ̈i k'apeer k'aju k'aba simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Har chi mʌ dʌ̈i nʌrram k'õsi simuan warre hich p'it'urg hau nʌrrajujã k'ap'ʌ haju haai simgui hajim hanʌm, mʌ gaaimua chik'amnau hich t'õoju k'ap'ʌ hawiajã hich mag mʌ bʌ̈ hogdʌba nʌrraju haawai. Mag hãwatbaju chan, parta hidëu k'õs mʌ dʌ̈i nʌrrʌm hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Magnaa hamag, ’¿Chijãg wounauta hich di hëwaagpaawai nacha k'ĩirju sĩi habaju k'ai hajim hanʌm, k'an nemta p'ë hauju, k'achpai higju, wa p'atk'on k'ãijã dʌ̈rr k'aba habaawai pöd nem higju t'um p'ë haubaju k'ãijã k'ap haag? ");
INSERT INTO noaH_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Magjã k'ĩirjubanaa, heeu dëgölp di hëuju haadëwia, dibʌ̈ happai k'ãijã juk'a sĩuwia, pöd hëu hauba hich mag werba sĩuk'iin, bigaaum k'ʌʌnau hich k'ĩircha k'ãijã hi wauwia hirig, ");
INSERT INTO noaH_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mʌg wounaun par di hëu haubajuuta sĩi dibʌ̈ happai jãg hidëu k'õs juk'abaadëjim” hajugui hajim hanʌm. Hich jãg di hëwaagpaawai k'ĩirjuajemjöta k'ĩirjuju haai simgui hajim hanʌm mʌ dʌ̈i nʌrraagjã, dich dau hap'ʌʌ haju k'ap'ʌ simjã magʌm higba warag magʌm hãwat nʌrraag. ");
INSERT INTO noaH_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Magnaa deeum ejemplo higwia, ’Wa magbam k'ai, ¿k'anim reita deeum hagjö hichjö reik'a sim dʌ̈i juurhi hee hich wërbʌan maju nawe k'ĩirju sĩi habaju k'ai hajim hanʌm, hajap k'ap haag? Hirua k'ap'ʌ simgui hajim hanʌm, warmua soldaaun k'apanag veinte mil wai sĩewai hichdëu diez milpai wai sim. Mag juurhi hee maju nawe, ¿hirua k'ĩirju haubaju k'ai, mag hich soldaaun magcha k'apan k'aba durrum dʌ̈i warm k'ʌʌn k'apan t'ʌnʌm haar wërbʌan petaawai hichdëu pödbaju? ");
INSERT INTO noaH_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Hirua mag k'ĩirjumʌn, hagt'a warm dʌ̈i t'ẽuju nawe, warp nʌwe k'aug haujugui hajim hanʌm, hichdëu pödbaju. Magbaawai hirua hich soldaaun warm k'ʌʌn haar chogpʌ̈iju, mak'ʌʌnau chaigpabaimaawai wërbʌju harrjã wërbʌba warag k'õinaa nʌisieg. ");
INSERT INTO noaH_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hich hagjöta haajemgui hajim hanʌm hĩchab mʌ dʌ̈i k'apeerk'aagjã. Mʌʌta nacha pãrau hʌ̃rcha k'õsinaa mʌg jẽb gaaim nem pãachdëu k'õsim t'um hisegbam chan, pöd mʌ k'apeen haju k'aba nʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mag hamach nem hisegmap'am k'ʌʌn higwi hiek'ak'agmamua hĩchab, ’T'ak'aran chadcha nem hajap'amʌugui hajim hanʌm; mamʌ mag sim nak'a haadëk'iin, ¿k'ant'ee serbiiju? Pöd bʌ̃ʌrjã hagua nem p'öju k'aba, ");
INSERT INTO noaH_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ni jẽb p'ʌichichag dʌ̈i waaurëunaa nemjĩir bʌ̈ k'uagjã serbiiba sĩsiju. Mag serbiiba sĩsiewai sĩi barpʌ̈ijugui hajim hanaabá. Hich jãgaugui hajim hanʌm hĩchab har mʌ hiek hʌ̈k'amaaugau hamach nem k'õchag t'um hisegba nʌm k'ʌʌnjã. Keena, jʌ̃g hʌ̃rʌʌnaa cha mua jaau chirʌm hajap'a hũrbat ha jaaumajim haajem, hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Biek hãb Jesuu jãga Hẽwandamau hõor peerdʌajẽ ha jaau sim haig, gobiernoog dëbpaar paar nʌm jëeujem k'ʌʌn k'apan bëe t'ʌnaajim haajem, chi pekau dapnaanpa, hi hiek hũraan. ");
INSERT INTO noaH_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Magbaawai chi hajap'a Hẽwandamau Moiseeg hiek p'ãpitarr hʌʌrk'aajem k'ʌʌn, maimua hag hiek jawaag hat'ee chi machnaan dʌ̈imua Jesús higwia, —Hi dën mʌg wounau chan pekau pöm sĩsidʌm k'ʌʌn hawiajã hisegba hich jãg warag ham dʌ̈i t'ach k'ö nʌrraajem hanaajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Magbaawai hichdëu ham mag hiek'a nʌm hũrwia, mʌg nem hĩgk'aadam jaaumamua hamag magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—K'anim nemjö mʌg nʌm haig hãbmua cien ovejas wai sim, maimua hãb hok'oobaadeewai, ¿k'aíuta tagam k'ʌʌn dö wajaug hee p'ëpʌawia mag hok'oo k'itʌmdam jʌraan mabaju k'ai? hajim hanʌm. Keen, par maadëu dich nemchaai haawai baaubam haigjã hook'a k'itʌʌ habarju. ");
INSERT INTO noaH_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Maimua mag baau hat'aawai, ¿k'aíuta sĩi honegau dich nemchaaidam hud haibëebaju k'ai? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Maimua di haig pachëwiajã, ¿k'aíuta hich k'apk'ʌʌn dʌ̈i hich di dak'a naajem k'ʌʌnpa t'ʌ̃rk'anaa, “Keen, mʌ honee chirʌm, mʌch oveja hok'ootarrdam hoo hat'aawai” habaju k'ai? ");
INSERT INTO noaH_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Keena, hich jãgta haajemgui hajim hanʌm hĩchab hʌ̃gt'arjã: Har hõor k'apan hamach hajaug t'öwia Hẽwandam dʌ̈icha wënʌrrʌm haajem k'ʌʌn gaaimua honee haju k'ãyau, pekau pömk'am k'ʌʌn heem hãb k'ãijã hich k'aibag hisegwia Hẽwandam hich t'ãar hee hat'am hed hʌ̃gt'armpeenjã honee hap'öbaadeejemgui hajim hanʌm hĩchab. ");
INSERT INTO noaH_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Maimua hĩchab mʌg jaaujim haajem: ’K'anim nemjö hʌʌi hãb simua p'atk'on chi dau daí happai diez wai sim, maimua mag heem hãb k'ãijã hok'oobaadeewai, ¿chijãg hʌʌirauta bʌ̃ʌrjã hich p'atk'on jʌrba hich mag sĩuju k'ai? Par jãgan hirua hag bʌ̈rre lámpara paanaa, dijã t'ũapwia, nem pʌaba jʌr sĩi hawia, baau hat'ajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Maimua mag baau hat'aawai, ¿chijãg hʌʌirauta hich k'apeen hich di dak'a naajem k'ʌʌn t'ʌ̃rk'a hauwia, “Keena, hĩsin mʌʌn honee hʌm, mʌch p'atk'ondam hok'oo wai hʌarr baau hat'aawai” habaju k'ai? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Magnaa hich Jesuupai, Hich jãgta hʌ̃gt'arjã hĩchab Hẽwandam chognaan honee hap'öbaadeejemgui hajim hanʌm, har woun hãb k'ãijã hich k'aibag hisegwia k'ĩirjug hajap'am jʌrwia Hẽwandam hich t'ãar hee hat'am hed. ");
INSERT INTO noaH_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Maimua jãga Hẽwandamau hõrau hich hiigwai hisegba haajem k'ap hamk'ĩir, Jesuu mag hich haig bëetarr k'ʌʌnag mʌg nem hĩgk'aajã hĩgk'ajim haajem hĩchab: —Woun jöoi hãb simua chaain numí wai sĩejim haajem, hemk'ooin hap'a. ");
INSERT INTO noaH_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","K'ãai hãb chi hiewaa chi hẽudeemua hich hayag, “Tata, pʌ meebaadeewai marau jʌ̃aju nem warre magan mʌrʌg mʌch jua hee dee chirbá” hajim hanʌm. Magbaawai jöoirau chadcha hamag jigbaadëjim haajem, hamachpierr. ");
INSERT INTO noaH_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mag deetarr k'ur k'ãai k'apancha k'aba nʌm hee, hichig nem deetarr t'um përk'ʌʌipʌ̈iwia hag p'atk'on dʌ̈i warre warp petajim haajem, deeum durr. Mamʌ mam pawia nem hoobam gaai hichdëu gastaam haig p'atk'on hãr gastaa sĩeimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Maimua mag p'atk'on nem parhoobam gaai werba sĩi hawia t'um höbapʌ̈im hee hĩchab jãdau t'eega burrjim haajem, hi sim durr. Maimua magbaadëm dʌ̈i ya hĩchab jãsogau mas haadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jãsogau hich magbaadeewai woun hãb sĩerr haar mawia parhoobam p'idagdam k'ãijã hichig deemk'ĩir jëeuwimajim hanʌm. Magbaa magua hirig jaaupʌ̈ijim haajem, k'ũsnaan t'ʌamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mag chadcha mawia k'ũsnaan t'ʌa hoo chirʌmua jãsooga haawai chi k'ũsnaanag p'at'au deechë nʌm heemta dʌ̈i k'öm hiigjeejim hanʌm, chi k'ũsnaanau k'ö nʌm dʌ̈i hãba, bʌ̃ʌr k'ãijã jãd t'õo hawaag. Mamʌ magʌmjã hãbmuajã hirig “Ya magan k'öjuma” haba haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","K'ãai hãb mag hoo chirʌʌ hawia t'umaa k'ĩirjumamua hich wir haigpai magjim hanʌm: “¡Hëh! Mʌ haai di haar hi piyonnaan bʌ̃ʌrjã k'öju hat'ee haugchëba biwaa t'ʌnʌm hee, mʌchta mʌch k'ĩir lökgau jãdaúa mʌig mʌ t'õo warrumgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Mʌg chirabnaa mʌ majugui” hajim hanʌm “mʌch haai haar. Maimua barimawia mua hirig ‘Tata, chadcha mua Hẽwandam dak'ĩir pekau wauwia pʌ dʌ̈ijã k'aigba habarm’ haimaju. ");
INSERT INTO noaH_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","‘Mag gaaimua warramjö pua mʌrʌg pʌch chaai haju k'aba sim. Mʌrʌg hiewaa haju k'ãyau sĩi mʌrʌg pʌch piyón habá; mʌ pʌ hat'ee hich mag p'idk'a chitaju’ ha hiek'aimaju” k'ĩirju hat'ajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Mag hich happai hiyʌ̈ʌ hoo sĩewia baubaadeeu chadcha hich haai haar petajim haajem. Mag mamua hagt'a di warp'aa sĩwe chi hayau hoo hat'ajim hanʌm, hi chaaita dau hap'ʌʌ hur k'itʌm. Magbaawai jöoi t'ãrau hãwatbajim haajem. Mag warag k'ap'ig mawia hich chaai hö p'ʌʌr jõinaa k'ĩir hʌ̃ʌ haujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Magbaawai chi chaairau hich hayag, “Tata, chadcha mua Hẽwandam dak'ĩir pekau wauwia pʌ dʌ̈ijã k'aigba habarmgui hajim hanʌm. Mag gaaimua warramjö pua mʌrʌg pʌch chaai haju k'aba chirʌm” hajim haajem hich hayag. ");
INSERT INTO noaH_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mamʌ chi hayau dau haug k'augwia, magʌmjã higba, warag degag harrwia hich chognaanag, “Mʌ chaai hat'ee k'ajũa chi hajapcharam jʌrwia jũapi sĩubat” hajim hanʌm. “Maimua hĩchab sorrtikjã jũapinaa zapatjã chi hajap'am jũapibapʌ̈it. ");
INSERT INTO noaH_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Magwia p'akdam chi hõtpaam haut'urwia t'õobapʌ̈it” hajim hanʌm, “maach t'um hãba honee k'ö nʌmua p'iesta wawaag. ");
INSERT INTO noaH_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pãrau hoo nʌmgui hajim hanʌm, mʌ chaai chi meem harrta deeu hiiubarmjö habarm; bëebajupii narrta deeu barbaichëm” hajim hanʌm. Mag, chadcha p'iesta waujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Mamʌ maagwai hich jöoi hiewaa chi naam, p'idag hee sĩejim haajem. Maimua bëewia di dak'a panaa hũr huraa haawai sĩi karris p'op'ook'am dʌ̈i tamburrpa bubujuk'am gaai jemk'a k'odt'ʌnʌm k'aug hat'ajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mag hũrbaawai hich haai chog hãb t'ʌ̃rnaa, “¿K'an gaaimua hagá heeupemjö mag t'ʌnarram?” ha jëeujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Magbaa chi chogau “Pʌ heeumta bëejimgui” hajim hanʌm. “Mag hʌ̈u barbaicheewaita pʌ hayau p'akdam chi sebaam wai narr t'õopibajieb” hajim hanʌm “p'iesta wawaag.” ");
INSERT INTO noaH_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mamʌ hichig mag jaaubaawai warag meeuk'awia dubmap'a daaugajãrpai sĩsijim haajem. Magbaawai höbërchëwia chi hayau hit'ũu hich hiewaag, “Dubtarrau hiewaa” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mamʌ hichig magbaawai warag hich hayag, “Pʌdë hũrbá tata” hajim hanʌm. “Mʌch herraawe bʌ̃ʌrjã pʌ haigmua hogdʌba, pʌ p'idag hee mʌ p'idk'a chitaajem; pua nem jajaauk'am hichaauraapaijã hiek'aba chitʌmgui” hajim hanʌm. “Mamʌ magʌmjã bʌ̃ʌrjã pua mʌrʌg chĩb chaaidam k'ãijã deeba haajem, mʌch k'apeen dʌ̈i honee k'ömk'ĩirjã. ");
INSERT INTO noaH_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mag k'ãyau sĩi jãg pʌch p'atk'on harrwia parhoob kachaloonaa hʌʌin dʌ̈ipa hãr gastaapʌ̈it'urtarr barbaicheewain chadau, pua p'ak chi sebaampa t'õo chirabma” hajim hanʌm, “hi k'ömk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Magbaa jöoirau jũrr hich hiewaag magjim haajem: “Mamʌ pua k'ap'ʌ chirabá” hajim hanʌm, “chadcha pʌchta mʌ haigmua hogdʌba k'itaajeewai mʌ nem mʌg t'ʌnʌm t'um pʌch dën happai t'ʌnʌm. ");
INSERT INTO noaH_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mamʌ pua hoo chirʌmgui” hajim hanʌm, “pʌ heeum chi meem harrta p'iidʌwi pierrumjö habarm; maach haigmua mawia tag bëebajupii narrta, hĩsta deeu pierrumgui” hajim hanʌm. “Magua hĩs chadcha maadëu mʌgju haai naabahab hajim hanʌm, hi bëetarr gaaimua honee haag.” ");
INSERT INTO noaH_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Maimua Jesuu hĩchab mʌg nem hĩgk'aadam hĩgk'ajim haajem, hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnag: —Hãb rik sĩejim haajem. Mamʌ hichdëu hich nem k'augba, deeumʌgta hich nem t'um jaau wai sĩejim haajem, magʌgta hich dënjö hamk'ĩir. Mamʌ k'ãai hãb chi mork'ʌʌu hũurwai hi nem haair haba parhooba sĩi hichdëu hampierrta wau sim ha hũrbaawai, ");
INSERT INTO noaH_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","t'ʌ̃rpʌ̈iwia hirig magjim hanʌm: “¿K'an hajaugta mua hũurwai mag pua bʌ̃ʌrjã mʌ nem haair haba chirʌm hanʌ́ma? Mʌ hiek'au nauwe jöpk'aa pʌchdëu nem waaujem t'um p'ãk'anaa mʌrʌg hoopibá” hajim hanʌm, “mua k'ap haag. Mag hoopiwia warre pʌdëu sĩiubaad, tag mua pʌ higbam” hajim hanʌm hich k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Magbaawai chi rik nem t'ʌa chirarr wounau k'ĩirju sĩi hawia, hich hödegpai, “¿Nau mʌ jãga hajuutaa mʌgbaadëma?” hajim hanʌm, “mʌg mʌ patronaujã mʌ jʌrbaadëm. Sirp'ʌg hee t'ut'ui dʌ̈i p'idk'aju serbiiba chirʌm. Parhooba sĩi hatcha kaaijã hee nem jëeu chitaagjã k'aba chirʌm” hajim hanʌm hichdëupai hichig. ");
INSERT INTO noaH_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Maimua hich hödegpai, “Hãa, ya mua k'ĩirju hat'am” hajim hanʌm, “jãga haju mʌch mʌigmua jʌrbapäaiwai hõrau hamach deg mʌch höbeerpimk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mag k'ĩirju hauwia chadcha hich patronag dëbpaar paraa narr k'ʌʌn hãhãbdö t'ʌ̃rnaa hamag jëeu hoomajim haajem. Nacharamʌg, “¿Pua maach patronag k'arr paraa chirʌ́?” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Magbaawai warmua, “Muan hirig cien latas de aceite paraa chirʌmgui” hajim hanʌm. Hichig mag jaaubaawai, “Chadcha pua mag haujim; cha sim hag hẽsap” hajim hanʌm. “Mamʌ t'ʌrrëupʌ̈iwia magan jũrr jöpk'arraa cincuenta lataspai p'ã sĩubá; mua pʌrʌg jãrrpai jëeuk'im” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Maimua hãbak'ai paar sĩerragjã hagjö, “¿Puajã k'arr maach patronag paar chirʌ́?” hajim hanʌm. Magbaawai chi dëbpaar paraa chirarrau, “Mua hirig trescientos sacos de arroz paar chirʌm” hajim hanʌm. Magbaawai chi k'ap haag jëeu sĩerrau, “Chadcha pua mag haujimkë” hajim hanʌm. “Cha sim hag hẽsap” hajim hanʌm. “Mamʌ t'ʌrrëupʌ̈iwia jũrr doscientos cincuenta sacospai p'ã sĩubá” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Magbarm k'aug hat'aawai chi patrón jöoirau hich nem haair haba harr woun higwia hich hödegpai, “Jöo, wounan chadcha k'ĩirjug k'ap'ʌta chirʌma” hajim hanʌm. Maimua jũrr hich hiek hũr narr k'ʌʌnagta magjim haajem, hich Jesuu: ’Chadcha Hẽwandam hiek hʌ̈k'amaaugau hamach k'õchagpierr wënʌrraajem k'ʌʌnta Hẽwandam hiek hajap'a hʌ̈k'a k'it'ëem k'ʌʌn k'ãyaujã k'ĩir hubʌcha sĩerrjëemgui hajim hanʌm, hamach gar hõor t'ereu hawaag. ");
INSERT INTO noaH_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pãadë hũrbat. P'atk'onan chadcha nem parhoobam wau nʌmua ganwia nem k'aigbam hat'eejã hiigjem. Mag sĩeb mamʌ, pãach p'atk'on haauwai hõordam dʌ̈i nem hajap'a wau nʌmuata ham dʌ̈i k'apeen k'abat hajim hanʌm. Maagwai pãach meebarm hed mʌg jẽb gayam nem tag higba haadeewai jũrr hʌ̃gt'arjã mak'ʌʌn dʌ̈ita nʌisiju, Hẽwandamau pãach hʌdʌraa höbeerpibaawai. ");
INSERT INTO noaH_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Woun hãbmua nemdam bʌ̃rʌʌm hawia k'ãijã hajap'a hʌʌrk'a simʌn, magan nem dʌ̈rrʌ̈ʌm hawiajã hich mag hajap'a hirua wai nʌrraju. Mamʌ nem bʌ̃rʌʌm hawia hagʌg hoomap'amjö warag hʌdʌraa hãrpi simʌn, magan nem dʌ̈rrʌ̈ʌm chará sĩi hãrpijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mʌg jẽb gaai Hẽwandamau pãachig nem deetarrdampaijã hajap'a hʌʌrk'aa meraa nʌmʌn, ¿jãga hich haram nem hajapcharam hirua pãrag deebarju? Deebamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chik'am nemjã pãrau hajap'a hʌʌrk'aba nʌm chan, ¿k'aíu pãrag hök'ar nem jʌ̃apiju harr k'ãijã jʌ̃apibarju? Jʌ̃apíbamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni hãbmuajã pöd patronnaan numiim k'ʌʌn chogk'aju k'aba simgui hajim hanʌm. Patronnaan numí hak'iin, hiwiir hãbpaita hʌ̃rcha k'a k'õsi haju. Hich hagjöta simgui hajim hanʌm hĩchab Hẽwandam dʌ̈ijã. Pöd pãrau Hẽwandam k'ĩrag wʌrpanaa p'atk'onagjã wʌrpa haju k'aba nʌm. Pãar magta nʌm chan pöd Hẽwandam hipierraa k'aba nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mamʌ hĩchab haig fariseonaan p'atk'on hat'ee bĩe k'it'ëem k'ʌʌnaupa chi Jesuu hiek'amam hũr narr haawai warag hi wau hiek'a naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Magbaawai Jesuu hamag hiek'amamua, —Pãran, pãachta hʌ̃rcha p'atk'on wai nʌm hawia Hẽwandam dau najã hʌ̈ucha nʌm haajeebma; mamʌ chadcha Hẽwandamauta pãar t'ãar k'ap'ʌ simgui hajim hanʌm. Mʌg jẽb gayam k'ʌʌnaun p'atk'onta nem t'um mʌg jẽb gaai t'ʌnʌm k'ãyau hajapcha sim hawia hagʌgta hee haajerram. Hamag mag nem wajaug sĩeb mamʌ, hagua nem k'aigba waauwaita sĩi hödömie sẽrk'a t'ʌnʌmjö Hẽwandamau k'õchk'aba haajemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mag nem jajawagmamua hĩchab hich hiek hũr narr k'ʌʌnag Jesuu magjim haajem: ’Juan hõor pör choomieu Hẽwandam hi jaauju naweran pãrau Moiseeu hiek p'ã pʌatarr dʌ̈i Hẽwandam hi jaaumienau hẽsap p'ãtarrpai wai naajimgui hajim hanʌm, hag gaai jaau sim hipierr wënʌrraag. Mamʌ Juanau hiek hiiur Hẽwandam haar höbeerpiejemta wai bëejimgui hajim hanʌm, chi wajapcharam. Mag jaauchëtarr haigmua hatag mag Hẽwandamta chi Pörk'aimʌʌ sim k'aug hat'ampierr, hĩsta hõor pöm hi hipierraa ham hig nʌm, chadcha hamach Pörk'abaadeewai hi dʌ̈i naam k'õchgau. ");
INSERT INTO noaH_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mag hiek hiiur wai naab mamʌ, jöoingar Hẽwandamau Moiseeg hich hiek p'ãpitarran hich warr sĩejerr hagt'a hich mag serbii sĩerrʌmgui hajim hanʌm. Mʌg durr t'um hedjãpa chugpawiajã jöoingarwe p'ã pʌatarr hiek chan bʌ̈dam hãbjã hok'oobamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Magua hĩsjã warrgarmjö dich hʌʌi hisegwia deeum hʌʌi haumʌn pekauta wau simgui hajim hanʌm; wa deeumua hʌʌi pʌatarr k'ãijã haumʌn magan hagjö pekauta wau simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Maimua hĩchab mʌg nem hĩgk'aadam jaaujim haajem Jesuu: ’Woun hãb sĩejim haajem, rik. Maan sĩi k'ajũa parhẽpagk'am happ'ata jũajeejim haajem. Maimua mag nʌm dʌ̈i hed hëepierr sĩi nemk'oo jaramjöta t'achjã wau k'oojeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mamʌ hĩchab woundam hap'ʌʌ k'itʌm Lázaro ha t'ʌ̃r sim sĩejim haajem, sĩi p'ĩe k'a dodoso k'itʌm. Mag k'itʌmʌn sĩi chi rik puertdi bigaau hõor bʌ̈ heeta hoo k'ëraajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mag k'ërʌmʌn jãsogau chi rik t'ach k'ö sim mes heegar pan perasdam k'ʌimam k'öm k'õchag k'ërʌm hee, saakienauta hi p'ĩedau sẽcheejeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mag k'itʌʌ hawia chi hap'ʌʌ k'itarrdam meejim haajem. Mag meebaadeewai Hẽwandam chognaan bëewia sĩi hi hak'aardam hʌ̃gt'ar Abrán sim haar harrjierram haajem. Mag k'ur chi rikjã hĩchab meebaadeewai bëp sĩuwia k'ĩmie durrta höbërjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Maimua ya k'ĩmie durrpanaa maach gaai machag hãwatbajujö t'ʌnʌmua hʌ̃gt'aag hoowai dau warp'a Lazarota Abrán bigaau k'õinaa päar sim hoo hat'ajim hanʌm, chi rik harrau. ");
INSERT INTO noaH_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Magbaawai mammua t'et, “Jöoi Abrán, mʌ hap chitʌm mʌ dau haug k'augbáa” hajim hanʌm. “Lázaro jĩgpirdam gaaipai k'ãijã dödamau homnaa mʌ haar pʌ̈ibapʌ̈ʌi. Ya mʌʌn hö jʌʌumaam. Hõt k'ierr pechag mʌg t'ʌnʌmjã mua hãwatbajujöta t'ʌnʌʌmgui” hajim hanʌm hähäak'amua. ");
INSERT INTO noaH_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mamʌ magbaawai jöoi Abranau hirig magjim hanʌm warag: “K'ĩir heyaa hajuma” hajim hanʌm, “pʌch monak'a haawai nem k'ĩir t'um paraanaa bʌ̃ʌrjã haugchëba chitarr. Maagwai Lázaro bʌ̃ʌrjã magʌm chuk'u hi dau hap'ʌʌ k'amor masi k'ërʌmjã pua hirig hooba haajeejim. Mamʌ hĩs mʌig hi k'õinaa bibigag chuk'u chirʌm. Jãigta k'ĩirjujuma hajim hanʌm, jãgwia jũrr hĩs pʌ hidawaa chirʌ́, hõt k'ierr pechag hee. ");
INSERT INTO noaH_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pua mag chirab mamʌ, pʌ haar pöd mua Lázaro pʌ̈ibamgui hajim hanʌm. Magnaa maach jãrr mʌg dö k'õrg sĩi jẽb hit'urm jaaba wëjömjö sim hee ¿jãga hi maju? Jammuajã pöd bëeju k'aba, ni maumuajã pöd maju k'abamgui” hajim hanʌm jöoi Abranau. ");
INSERT INTO noaH_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Magbaawai chi rik harrau warag chaigpa k'itʌmua jöoi Abranag, “Magan jũrr mʌ haai di haarta hi chogbapʌ̈i” hajim hanʌm, ");
INSERT INTO noaH_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","“mʌ k'od hãbam k'ʌʌn cinco p'ë wai chirʌm haar, mʌ mʌg chirʌm jaaubaimaawai hamach k'aibag hisegwia k'ĩirjug hajap'am haumk'ĩir, magbaawai ham meem hedjã mʌjö mʌgʌm haar gaai machag hãwataan bëem hugua” hajim hanʌm, chi rik harrau. ");
INSERT INTO noaH_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Magbaawai Abranau hirig, “Mamʌ hamau Hẽwandam hiek wai naabahab, Moiseeu chi Hẽwandam hi jaaumien dʌ̈imua p'ã pʌatarr. Hamau mag gaai jaau sĩsidʌmta hipierraa haju haai naabahab” hajim hanʌm, “pʌ sim haar wëtmap'a nʌmʌn.” ");
INSERT INTO noaH_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Magbaawai chi k'ĩmie durr simua magjim hanʌm: “Hʌ̃hʌ̃, mag k'abam jöoi Abrán. Sĩi p'ã sim gaaipai chan hamau hʌ̈k'abam. Mamʌ hãb meetarrta deeu ham haar höbërimawia hamag jaauwimak'iin chadau, warre hamau hamach k'aibag hisegjurau” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Magbaawai Abranau hirig magjim haajem: “Mamʌ hamau mag Hẽwandam hiek chi p'ãm wai nʌm gaai jaau sim hʌ̈k'aba nʌm chan, magan hãb meewia deeu hiiu p'iidʌwia hamag jawaan mak'iinjã, hamau hʌ̈k'abajugui” hajim haajem, chi rik harrag. ");
INSERT INTO noaH_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesuu magjim haajem hich dʌ̈i wënʌrraajerr k'ʌʌnag: —Mʌg jẽb gaai hichiita hich jãg hõor pekau waupiejem nem paraa haju, mamʌ ¡hëh, hapk'it! hajim hanʌm, chi magʌm nem paraa sim woun. ");
INSERT INTO noaH_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hirua magʌm gaaimua chi mʌ hiek hʌ̈k'a k'ërʌmta pekau hee burrpimʌn, hichta Hẽwandam dʌ̈i hiekk'õr pöoma sĩsiju. Mamʌ mag Hẽwandam dʌ̈ita hiekk'õr paarpaju k'ãai hichdëupai hich hö gaai mokpör pömk'am jʌ̃naa p'ũas hee baudʌk'iin hʌ̈ucha hajugui hajim hanʌm Jesuu. ");
INSERT INTO noaH_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Maimua hĩchab, ’Pãrag jaauk'im, k'ap'ʌ habat hajim hanʌm, hich Jesuupai. Pãachjö mʌ hiek hʌ̈k'a nʌm k'ʌʌnau k'ãijã pãach dʌ̈i k'aigba habaawai warag dʌ̈i hagjö haju k'ãyau sĩi ham wawibat hajim hanʌm. Maimua hamachdëu mag pãach dʌ̈i k'aigba habarm k'aug hauwia pãachig “Mʌ perdonaabá” haawai, ham perdonaawia hoob tag bʌ̃ʌrjã magʌm hiek higmiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hãbam hedpai k'ãijã biek k'apan pãach dʌ̈i k'aigba hawia, “Kakë mʌ perdonaabá, mua tag jãgbaju” ha k'ʌrrk'ak'a hawia k'ãijã, hich hagpierr hi perdonaabat hajim hanʌm, tag magʌm hiek bʌ̃ʌrjã higba. ");
INSERT INTO noaH_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mag dich k'apeen perdonaapi jaaubarm p'it'uurga sim k'ĩirjunaa, jũrr hich Jesuu chi doce jʌr hautarr k'ʌʌn garmua hirig magjierram haajem: —Señor, Hẽwandamau marag k'ĩirjug deebam chan pöd marau maach k'apeen perdonaabaju. Marag juapá deebá hajierram hanʌm, mag pʌchdëu jaau simjö haag. ");
INSERT INTO noaH_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Magbaawai maach Pör Jesuu magjim haajem hamag: —Pãrau k'ĩirjuawai chadcha Hẽwandam jua t'eeg sim k'ap'ʌnaa pãachdëu nem mag habarmjö hapiju k'ĩirjunaata nem wauk'iin, Hẽwandam hat'ee chan p'it'urm nem chuk'u haajeewai, chadcha pãachdëu jajaauk'ampierr hich mag pãachdëu jaau nʌmjö hajugui hajim hanʌm. Pãar k'ĩirjug hoojem hanaa chi pömag mostaza daudam har maach dau hee paba k'itaajemjö k'ãijã k'itak'iin, har pabʌ̈ pöm simʌg wounagamjö, “Jãigmua mawia jũrr hachum p'ũas hee dʌnʌʌubaimá” habaawai, chadcha pãar hipierraa hajugui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mag jaaumamua hĩchab magjim haajem: ’¿K'aíuta hich chog p'idk'a sĩi hawia barbaicheewai hit'ũu hirig, “Har pʌ hat'ee ya t'ach mes gaai t'öi k'ërʌm k'öbá” haju k'ai? ");
INSERT INTO noaH_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mag chan ni hãbmuajã hiek'abamgui hajim hanʌm. Jãan magju k'ãai warag, “Jöpk'aa p'iejãb wauwia mʌ jãhogbá, maimua murua nem hig chirʌm t'um p'ëdeebá; pʌchin nau mʌ k'ö dichtarr k'ur hẽudeechata k'öju” ha hiek'aju. ");
INSERT INTO noaH_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Pãrau hoowai hãbmua hich chognaanau hich hipierraa nem wau nʌm paar “Hʌ̈u hajim” haajẽ? Hʌ̈u hajim chan habam, hich p'idag hichdëu nem wauju hatarrta wau sĩewai. Hirig jaauba hak'iinjã hichiita hirua waub k'aba waujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hich hagjöraugui hajim hanʌm pãarjã hĩchab: ya Hẽwandamau pãachig nem jaautarr t'um wau höbaadeewai sĩi warag, “Maachin Hẽwandam chognaanpaiu; hichdëu maachig jaautarrpierrpai waubapʌ̈im” habat ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mag jaau sĩewia, warag Jerusalenag mamua didichagmajim haajem, Samaria durr Galilea durr dʌ̈i hãba t'ẽu nʌm jãrr k'ʌdau ma sim hee. ");
INSERT INTO noaH_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mag mamua p'öbördam pöm k'aba k'itʌm hee dubbaimaawai hi k'ĩirp'ee hõor diez kokobé bënëu bar k'it'ëem höbërdʌtk'achëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mag höbërdʌtk'achëwia warppaimua hirig hähäak'amua, —Maestro Jesús, maar hapdurrum maar dau haug k'augbahur haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hichig dau hap'ʌʌ mag durrum hoobaawai hamag, —Jerusalenag hërëuwia Haai hi jëeujem deg p'adnaanag pãach k'a t'eerhʌ̃chpibat hajim hanʌm. Hamachig magbaa chadcha hi hipierr hërëubaadëjim haajem. Mag wëtumua hagt'a barba nʌm hee, hamach mor hoowai k'a hajap'a magʌm bën chuk'u narrjö naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Hamach mag hoobaawai, hãbmua deeu hewag k'ap'ig hurumua honee, “Hẽwandam, hĩsin chadau puan mʌ dʌ̈i hʌ̈uta habarm; pʌjö jua t'eegk'am chan mʌg jẽb gaai chuk'um” ha hijẽjẽbag bëejim haajem, hich happai. ");
INSERT INTO noaH_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mag bëewi Jesús bʌ̈k'ʌrr p'õbk'a jẽbjã gaai dagau dʌrnaa, “Hʌ̈u hajim” hajim haajem hirig, hich monaautarr paar. Chi mag Jesuug hʌ̈u hajim haan bëetarr, Samariapierr hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Magbaawai Jesuu magʌg, —¿Pãar chi monaautarr k'ʌʌn diez naabajĩ? ¿Jam nʌma hajim hanʌm tagam k'ʌʌn nueve? ");
INSERT INTO noaH_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hamach monaautarr paar Hẽwandamag “Hʌ̈u hajim” haju chuk'u harrjö, hãba pʌ happaita deeu k'itaichëbma hajim hanʌm, deeum durramk'a chirʌmta. ");
INSERT INTO noaH_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Maimua hichdëupai mag chi kokobé bënëu bar k'itarrag, —P'iidʌwia petá hajim hanʌm. Mua jaautarr hipierr pʌch hödegpai, “Chadcha hi hipierraa hamʌn mʌ monaauju” ha k'ĩirjutarr gaaimua, hʌ̈u pʌ peerdʌwia monaaujã monaau chirsim hajim haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","K'ãai hãb chi hajap'a Moiseeu Hẽwandam hiek p'ã pʌatarr hʌʌrk'aajem k'ʌʌnau Jesuug, —¿Jãagwaichata mʌg jẽb gaai Hẽwandam maach Pörk'a sĩeichëjuwa? hajierram haajem hirig. Magbaa Jesuu hamag magjim haajem: —Hẽwandam hichta chi Pörk'a sĩeichëju chan hoob dau daauta bëeju hamiet. ");
INSERT INTO noaH_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mua nem wau chirʌm gaaimua pãrau k'ap'ʌ haju haai nʌm, Hẽwandam ya pãach hee sim; magua hirua hich jua hoopi simgui hajim hanaabá, chadcha hichta t'um hich hiek hʌ̈k'a nʌm k'ʌʌn Pörk'a sĩeichëm k'ap hamk'ĩir. Maagwai hõrau mʌʌgwaiwe chan, “Mʌgá, har nʌrrʌ́,” wa “Hachum har sĩ” habajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mak'ʌʌnag mag jaauwi jũrr hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnagta magjim haajem: —Mʌg hatag pãach happai wënʌrrʌm haig, pãrau mʌch chi Hemk'ooi Hiewaa k'ĩirjuwia k'ãaidam hãbpai k'ãijã hũmaai deeu mʌ dʌ̈i wënʌrram k'õsi haju. Mamʌ pöd mag wënʌrrabajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mʌg hatag hõrau pãachig, “Mʌgá, har nʌrrʌ́, ya bëejimwai,” wa magbam k'ai “Hachum sim” haawai, hoob hʌ̈k'awia haar hoon wëtmiet hajim haajem. Magua pãachig nem jaauwaijã hoob ham hiek hʌ̈k'amiet. ");
INSERT INTO noaH_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mʌch chi Hemk'ooi Hiewaa bëewain, t'umaam k'ʌʌnauta mʌ hoojugui hajim hanʌm, hich jãg pagt'ʌm dau p'ʌr jẽer hat'aawai hedjã t'um harar hat'aajemjö. Magua hõrau mag pãachig ya mʌ barbaichëm ha jaauwaijã hoob hʌ̈k'amiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mamʌ magju nawe hichiita mʌ dau hap'ʌʌ haju haai chirʌmgui hajim hanʌm, hõor mʌg t'ʌnʌm k'ʌʌn jua hee, hamachdëuta mʌ k'a hisëe wai wënʌrraawai. ");
INSERT INTO noaH_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mag mʌg hatag mʌch chi Hemk'ooi Hiewaa deeu bëeju gayaa paawai, jöoingar jöoi Noé k'ak'itarr jaar hõor döhãdau höpäaiwai hamachdëu hampierr t'ʌnaajerrjöta t'ʌnaajugui hajim hanʌm hĩchab. ");
INSERT INTO noaH_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mag jöoi Noé sim jaar hõrau hamach hok'oojujã k'ĩirjuba, sĩi p'iesta waunaa, t'ach k'öwia, dödöjö döju, maimua jua pʌrjuuta k'ĩirju naajim. Ham mag t'ʌnʌm hee, jöoi Noeeu hichig Hẽwandamau barco pöm waupi jaautarrjö chadcha wau hauwia hag hee dubjim. Mag dubbaadeewai döhãd pöm bëewia sĩi hõor pöm hödubjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maimua jöoi Lod k'achitarr Sodoma p'öbör hee sĩejeewaim jaarjã hich hagjöta t'ʌnaajim hĩchab. Ham k'ĩirjugan, hãba t'ach k'öju, dödöjö döju, hamachdëu nem k'õsimpierr haunaa jũrr hamach garmua përju, nem jĩirju maimua di hëujupai hajim. Mamʌ mag nʌmjã Hẽwandam gaai k'ĩirjuju chan haba haajeejim. ");
INSERT INTO noaH_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mamʌ ham mag t'ʌnʌm hee, jöoi Lod Sodoma p'öbör heemua höbërbaadeewai hich Hẽwandamau hedjã heemua hõtdau k'ĩir k'ʌipijim. Mag hõtdau k'ĩirta noseg chë t'ʌnʌmjö k'ʌi t'ʌnʌisimua hõor t'umaa p'aa k'ëchpʌ̈ijim. ");
INSERT INTO noaH_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jãg hamachdëu Hẽwandam k'ĩirjuba t'ʌnarrjöta t'ʌnaajugui hajim hanʌm hĩchab, mʌch chi Hemk'ooi Hiewaa deeu mʌg jẽb gaai dʌnʌʌubaichëm hedjã. ");
INSERT INTO noaH_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mag jaaumamua hich Jesuupai, ’Mag mʌ pierrum hed hãb k'ãijã hich dihëu hʌ̃r jua hʌ̃i sim k'ai, hich nem p'ë hawaan hawia hoob tag hierrag dubam hajim hanʌm; wa magba hich p'idk'aajem haar k'ãijã sim k'ai, hoob hich diig k'ap'ig bëem. ");
INSERT INTO noaH_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","K'ĩir heyaa habat hajim hanʌm: hewag hoopiba harr hee Lod hũanau sĩi hich nem k'ĩirjuwia hewag hootarr jũrrpai Hẽwandamau mag hʌʌi t'ak'arag paapʌ̈itarr. ");
INSERT INTO noaH_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Har chi mʌ hiek hʌ̈k'a sim gaaimua p'it'urg hãwatmap'a sĩi warag “Heeu jãgʌm gaaimua mʌ t'õoduk'am” ha k'ãijã hiyʌ̈ʌ sim k'ʌʌn warreta hok'oo simgui hajim hanʌm. Mamʌ har chi mʌ hiek gaaimuata dau hap'ʌʌ k'ãijã habarm wounan chadau hʌ̃gt'archa höbërjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mag hich k'apeenag jajawagmamua, ’Mag mʌ bëewai hõor numí hãbam put hee naajugui hajim hanʌm. Mamʌ mua hãbpai mʌch dʌ̈i harrwia, hãb werpʌaju. ");
INSERT INTO noaH_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hʌʌinjã numí hĩchab hãbam molin gaai ba naaju. Mamʌ mua hãbpai mʌch dʌ̈i harrwia, hãbak'ai werpʌajugui hajim hanʌm.  ");
INSERT INTO noaH_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hõor numí hagjö di chaaur naaju. Mamʌ mua hãbpai mʌch dʌ̈i harrwia, hãbak'ai werpʌajugui ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Magbaawai hi k'apeenau hirig, —Señor, cha purua jaau sim, ¿jampaita magju k'ai? ha jëeujierram hanʌm. Magbaa Jesuu hamag, —Jampai hagá hajujã k'aba simgui hajim hanʌm. Pãrau k'ap'ʌ nʌm, nemmí sim haig hãkõs hich k'ĩrau jupcheejem. Hich hagjöta hajugui hajim hanʌm hĩchab muajã mʌch hiek hʌ̈k'a nʌm k'ʌʌn dʌ̈i; ham p'ë harraag mʌch bëem hed ham haigta dau daau hurum t'umaam k'ʌʌnau mʌ hoojugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hĩchab Jesuu hich k'apeenag mʌg nem hĩgk'aadam jaaujim haajem, mag jaaubarm gaaimua hamachdëu nem hig nʌm Hẽwandamau da deeba hawiajã warag pʌaba hirig jëeuju haai nʌm ha k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mag jaaumamua magjim hanʌm: —Woun hãb chi t'et'em sĩejim haajem, p'öbör hee. Magua bʌ̃ʌrjã hich k'apeen högk'aba ni Hẽwandamjã higba sĩerrajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hich hag p'öbör heepai hĩchab sĩejeejim haajem, k'oopaa hũan hãb. Mag hũanau bëewia hirig, “Mʌ hap hʌrrʌm mʌ k'aigpërbá” haajeejim hanʌm, “mʌ k'a huk'urm k'ʌʌnau mʌ dʌ̈i hatcha jãgam hugua.” ");
INSERT INTO noaH_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mag k'oopaa hũan dau hap'ʌʌ hich haig hudk'ʌrrk'ak'ak'amjã bʌ̃ʌrjã hi hiek hasekasmap'a sĩi hawia k'ãai hãb magjim haajem: “Mua chadcha Hẽwandam higbanaa mʌch k'apeenjã högk'aba chitab mamʌ, ");
INSERT INTO noaH_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","jãg k'oopaa hũan tag mʌch haig bëbëe ham hugua, mua chadcha hi k'aigpërjugui” hajim hanʌm. “Magba hak'iin, hirua hidëu mʌ k'ajap chirbajugui” hajim hanʌm, “hich hag hiekpai p'ʌʌrba jajaau haawai.” ");
INSERT INTO noaH_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mag hĩgk'a dichwia, hich Jesuupai jũrr hamag, ’Pãrau hũrjierramgui hajim hanʌm, k'an ha hiek'ajĩ mag woun chi t'et'em nem k'aibag sĩerrau. ");
INSERT INTO noaH_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Pãrau hoowai hich haig bëbëe nʌʌ paawai k'oopaa hũan hirua k'aigpërbajĩ? Hẽwandamaujã hich chaainau hichig hedaram magwe jëeu nʌʌ hak'iin, hirua mak'ʌʌnjã heeg hoob k'aba hoojugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Magnaa, Mua pãrag jaauk'imgui hajim hanʌm. Hẽwandamagta pãrau mag jëeu nʌmʌn, pãar k'aigpërm hedjã warre hirua pãachdëu k'õsi nʌmjö haju pãar dʌ̈i. ¿Mamʌ pãrau k'ĩirjuawai mag mʌch chi Hemk'ooi Hiewaa bëeju hed hõor chadcha mag hamach t'ãraucha Hẽwandamag jëeu durrum k'ʌʌn hagt'a naaju k'ai? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Maimua hamachdëupai hamachta t'umaam k'ʌʌn k'ãyaujã hajap pekau chuk'u k'it'ëem hawia jũrr hamach k'apeen k'aibag p'eejem k'ʌʌnag Jesuu mʌg nem hĩgk'aadam jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Chi nem hĩgk'aadam mʌg hajim haajem: —Wounaan numí Haai hi jëeujem deg Hẽwandamag jëwaan wëtjim haajem. Hãb fariseo hajim hanʌm, Moiseeg Hẽwandamau hich hiek p'ãpitarr hajapcha hʌʌrk'aajem haajem k'ʌʌn heem, maagwai hãbak'ai gobiernoog hõrau dëbpaar paraa nʌm jëeujem hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chi hajapcha Moiseeu p'ã pʌatarr hiek hʌʌrk'aajemua bʌ̈jãaupai hoo dʌnʌmua, Hẽwandamag jëeu nʌm hanʌmta, hichpai t'ö hiek'amamua magmajim haajem: “Hẽwandam, pʌrʌg hʌ̈u hajim ha chirʌm, hʌ̈uta jãg mʌ chik'amnaanjö k'aba chitʌm. Mʌ hamjö nem jĩignemjã k'aba, pekau pömjã k'aba, ni deeum hʌʌinjã wauba chitʌmgui” hajim hanʌm. “Mʌ chan gobiernoog hõrau dëbpaar paraa nʌm k'ʌʌnag jëeujem har hachum simjöjã k'aba chitʌm” ha hiek'amajim hanʌm, hichdëupai hich hajaug t'öwia. ");
INSERT INTO noaH_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Maimua warag mag jaaupʌ̈pʌ̈igmamua magjim haajem: “Hẽwandam, mʌʌn semanpierr k'ãai numí t'ach k'öba sʌrk'a chiraajem, pʌrʌg jëwaag. Mag nʌm dʌ̈i hĩchab mʌch p'atk'ondam hoopierr hag heem deeb k'aba pʌrʌg dee k'itaajemgui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Maagwai jũrr chi gobiernoog paar nʌm k'ʌʌnag jëeujemdam hich happai hag warp'aa hoot'ẽu k'ërʌmua hagjö Hẽwandamag jëeu sĩejim haajem. Mamʌ maan, jũrr hichdëupaijã hich pekau pöm k'itʌm k'ap'ʌ sĩerr haawai, gaai machgau warag heeg hʌ̃t'ʌnaa pör jõjõik'amuata maagjeejim hanʌm Hẽwandamag: “Hẽwandam, mʌch chadcha pekau pöm chitʌm k'ap, pʌrʌg jëeu chirʌm; mʌ hap chitʌm mʌ heeg hoobá” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mag numí Hẽwandamag jëeu narr k'ʌʌn jaau dichwia, chi haig hich hiek hũr narr k'ʌʌnag magjim haajem: ’Hichdëupai Hẽwandamag hichta chi hajap'am ha chirarr k'ãyau, hich dau haug k'augpi jëeutarr wounta jũrr Hẽwandam dau na hag najã hich mag bʌ̃ʌrjã k'aibag chuk'u haajerrjöo sĩebahab hajim hanʌm. Mamʌ har hamach t'öwia chik'am dʌ̈i hat'uucha haajem k'ʌʌn, jũrr mʌg hatag paawai ham Hẽwandamag chaigpa hoo sĩsidʌ habarjugui hajim hanʌm. Maimua har mag hamach dʌ̈i hat'uu nʌm k'ʌʌn hichaaurjã magʌm haba sĩi warag serbiibamjö haajerr k'ʌʌnta, jũrr mʌg hatag paawai, Hẽwandamau warm k'ʌʌn k'ãyaujã hʌ̃rpai hapiju ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Biek hãb mag jũrram k'ʌʌnau haaunaan Jesús sim haig wai bëe nʌm hee, chaainpa chi dënnaanau haibëe naajim haajem, ham gaai pʌrnaa Hẽwandamag ham kõit jëeumk'ĩir. Mamʌ mag jũrram k'ʌʌnau chaain haibëbëek'am hoowia jũrr chi Jesús dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnauta mag chi haibëe nʌm k'ʌʌnag meeurrau sĩujierram haajem, tag haibëepimaaugau. ");
INSERT INTO noaH_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mamʌ hamau mag nʌm hee, warag Jesuu chi chaaindam t'ʌ̃rk'anaa jũrr hich k'apeenagta, —Hidëu chaain mʌ haig bëepibat hajim hanʌm. ¿K'ant'ee pãrau hamag bëepiba jaau nʌ? Chi jöoin hawiajã chamʌ k'ʌʌn chaainjö mʌ hiek hʌ̈k'ak'arrsö hʌ̈k'a nʌm k'ʌʌnta mʌg jẽb gaaijã hʌ̈u wënʌrrawia, hʌ̃gt'arjã honee wënʌrrajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mamʌ chi hʌ̃gt'ar höbërju k'ĩirju nʌm k'ʌʌnaujã mʌk'ʌʌn chaain dënjö hʌ̈k'abam chan pöd höbërbamgui hajim hanʌm. Mua pãrag mag jaau chirʌmʌn chadcharam hiekta jaau chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Biek hãb Jesús sim haig woun hãb chi t'et'em bëejim haajem, p'atk'on paraam. Mag wounau hirig, —Maestro, pʌʌta chadcha Maestro hajap'am haawai pʌrʌg jëwaan bëejim: ¿Mua k'ani jãgju haai chirʌ́, hʌ̃gt'ar höbëraag? Mʌrʌg jaaubá haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Magbaawai Jesuu hirig, —¿K'ant'ee pua mʌrʌg “chi hajap'am” ha sĩ? Hõor hajap'am chan chuk'umgui hajim hanʌm. Hajap'amʌn hãba Hẽwandamta hich happai hajap'a sĩerrʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿Pua k'ap'ʌ sĩebá hajim hanʌm, Hẽwandamau Moiseeg hich hiek p'ãpitarr gaai: “Hoob dich hõor k'abam dʌ̈i k'apes ham; hoob hõor t'õom; hoob nem jĩgk'am; hoob chik'am hëugarjã sëuk'a nem hĩgk'am; maimua pʌch haai jãsenk'anaa pʌch hãdjã jãsene habá” ha sim? ");
INSERT INTO noaH_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Magbaawai chi woun p'atk'on paraamua, —Mag pua jaau sim t'um mua mʌch bʌ̃rʌʌwe hʌʌrk'a chitabahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesuu hi mag hiek'a sim hũrbaawai hirig, —Mamʌ hagt'a k'ĩir hãb pua waaur wai sĩebahab hajim hanʌm. Pʌch nem t'um përk'ʌʌipʌ̈iwia chi p'atk'on hap'ʌʌ k'it'ëem k'ʌʌnag jigbapʌ̈i. Maimuan chadau mʌ hẽudee pidú hajim hanʌm, mʌ dʌ̈i chitam k'õsi chirʌm k'ai. Pua magmʌn, hʌ̃gt'ar pawiajã bʌ̃ʌrjã haugchëba, p'atk'on k'ãaijã nem hajap'am pömta wai chirsijugui hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mamʌ Jesuu hichig mag nem t'um përk'ʌʌiwia chi p'atk'on jigpi jaaubaawai, warre chi woun hök'ĩirjuu haadëjim hanaabá, chadcha p'atk'on paraam harr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesuu hoowai mag hichdëu nem jaaubarm gaaimua hatcha hök'ĩirjug pöm haadëm hoowi, —P'atk'on paraam k'ʌʌnta Hẽwandam chi Pörk'a sim haar höbëraagan chadcha t'et'e simgui hajim hanʌm, hamach p'atk'onagta hʌ̃rcha hee naawai. ");
INSERT INTO noaH_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","P'atk'onpanta hʌ̃gt'ar Hẽwandam chi Pörk'a sim haar höbërju k'ãyau, camello pöm jãg maach wounaan k'ãaijã hʌ̃rpai sĩerrʌmta p'it'urg chuk'u nobeeu kachdam hee t'oogar höbër dichjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesuu mag hiek'abarm hũrbaawai haig chi hũr narr k'ʌʌnau, —Mag k'ai, magan ¿k'aita peerdʌagáwa? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Magbaawai Jesuu hamag magjim haajem: —Hõragan chadcha p'it'urgma mag hũurwai, mamʌ Hẽwandamag chan bʌ̃ʌrjã p'it'urg chuk'u simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Magbaawai Pedroou hirig, —Maraun chad pʌ dʌ̈i wënʌrram k'õchgau maach nem wai narrjã hewag k'ĩirjuba, sĩi t'um p'ëpʌawi pʌ dʌ̈i hogdʌba wënʌrrabma hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Magbaa hich Jesuu magjim haajem: —Chadcha har t'um chi mʌ gaaimua wa mʌ hiek jaaum k'õchgau k'ãijã hamach di pʌawia, hamach dënnaanjã pʌanaa, hamach k'odnaan, hamach hʌʌin wa hamach chaain k'ãijã k'augba k'ũchpaim hat'ee p'ëpʌpʌak'am k'ʌʌnagan chadau, ");
INSERT INTO noaH_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mʌg jẽb gaai hagt'a nʌwejã mag hamach nem hok'oomarr k'ãaijã hʌ̃r hag hatcha deewi mʌg hatagjã mʌch dʌ̈ita hich mag wënʌrramk'ĩir mʌch haarcha p'ë haujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Maimua hich dʌ̈i doce hogdʌba wënʌrraajerr k'ʌʌn chaaur k'ĩet p'ë harrwia hamag magjim haajem: —Pãrag k'ap hamk'ĩir mua warre jaauk'imgui hajim hanʌm: Pãrau k'ap'ʌ nʌm, ya maach Jerusalenag wëtum. Jerusalén barbaimaawai warrgarwe Hẽwandam hi jaaumienau mʌch chi Hemk'ooi Hiewaa higwia p'ãtarrjö t'um hag heyaa höbërjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Magbaawai mak'ʌʌnau maach meeun k'abam k'ʌʌnag mʌ pʌr deejugui hajim hanʌm. Magbaawai mak'ʌʌnau mʌ wau hiek'amam dʌ̈i mʌ k'ĩir hiek'anaa mʌ gaai hichöpa t'umaju. ");
INSERT INTO noaH_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Magnaa mʌ wʌ wai nʌʌ hawia hamau mʌ t'õopʌ̈ijugui hajim hanʌm. Mamʌ k'ãai t'ãrjupam hee deeu mʌ hiiu p'iidʌju ha jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mamʌ hi mag hiek'abarm hamachdëu bʌ̃ʌrjã k'augba, hich mag nʌisijim haajem. Hamau hũurwai, Jesuu sĩi parhooba hichdëu hiek'a simjã k'augbata hiek'abapʌ̈imjö hũrpʌ̈ijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús hich k'apeen dʌ̈i mag mamua p'öbör Jericó hanʌm dak'a paauk'abaimaawai woun hãb dau k'ĩsu k'itʌm k'ʌd higaau hoo k'ërʌm hooimajierram haajem, hõor hërëu dich t'ʌnʌm k'ʌʌnag nem jëeuwai. ");
INSERT INTO noaH_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mag dau k'ĩsu k'itʌmua hõor pöm hich haig hërëu dich t'ʌnʌm k'aug hat'aawai jëeujim haajem, k'an jãgwiata mag t'ʌnʌm k'ai ha k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Magbaawai hãbmua hirig, —Jesús, Nazaretpierrta dich nʌrraawai k'abahab mʌg hõor pöm sereu wëtum hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Magbarm bʌ̈rre chi dau k'ĩsu k'itʌmua t'et hähäak'amua Jesuug, —¡Jesús, pʌʌta rey David k'achitarr hag chaain hewagam k'ʌʌn Hiewaau marau nʌ narr! Mʌ hap chitʌm mʌ dau hee haug k'augbahur haajeejim hanʌm, hich dau monawaan bëemk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Magbaawai chi na wëtmaa harr k'ʌʌnau hirig meeurrarrau haajeejim hanaabá, k'ĩupamk'ĩir. Mamʌ magbaawai chará waragta, —¡Jesús, pʌʌta rey David k'ararr hag chaain hewagam k'ʌʌn Hiewaau marau nʌ narr! Mʌ hap chitʌm mʌ dau haug k'augbahur haajeejim hanʌm, t'et k'ĩesirnaa. ");
INSERT INTO noaH_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mag hähäak'am hich Jesuu hũr hat'aawai dʌnʌisiwia hawaan mapijim haajem, hich haigcha haibëemk'ĩir. Mag hich haigcha haipierrwai hirig, ");
INSERT INTO noaH_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿K'ani pua mʌrʌg pʌch dʌ̈i hapim k'õsi chirʌ́? hajim hanʌm. Magbaawai chi dau k'ĩsu k'itʌmua, —Señor, muan pʌrʌg mʌch dauta monaaupim k'õsi chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Magbaa Jesuu hirig, —Magan dau heerdʌbaad hajim hanʌm. Chadcha muata pʌch monaaupʌ̈iju k'ĩirjutarr gaaimua, hʌ̈u pʌ peerdʌwia monaaujã monaau chirsimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesuu magbarm bʌ̈rre chadcha dau heerdʌ sĩsiwia hich bi heem daujö daujã hajaug sĩsijim hanaabá. Magbaawai warag hi dʌ̈i mamua honee Hẽwandamag jëeumamua, —Hẽwandam, hĩsin chadau pua mʌ hʌ̈uta habarm. Pʌjö jua t'eegk'am chan mʌg jẽb gaai chuk'um ha hijẽjẽbag majim haajem. Jesuu mag woun dau monaaubarm hoobaawai hĩchab mag hõor k'apan t'ʌnarr k'ʌʌnaujã Hẽwandamag jëeumamua hirig “Hʌ̈u hajim” hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mag wëtumua ya p'öbör Jericó hanʌm dak'a narr haawai warag Jesús hag p'öbör hee dubwia dichmaa hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mag p'öbör hee sĩejim haajem woun hãb p'atk'on paraam. Ma, Zaqueo hajim haajem, hõrau gobiernoog dëbpaar paraa nʌm jëeujem k'ʌʌn pör. ");
INSERT INTO noaH_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mag wounau Jesús k'ĩir hoog hẽk'aajeejim haajem, mag hõor pöm wëjöm heemua. Mamʌ jöointa bʌt'ʌ k'itarr haawai pöd hooba haajeejim hanaabá, bʌ̈ dʌ̈rr k'abam gaaimua. ");
INSERT INTO noaH_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mag warm k'ʌʌn pör hʌ̃rmua hichdëu pöd hooba habaawai, na k'ap'ig mawia, pabʌ̈ jeeubahk'ar neneree k'itʌm gaai waaidʌwia nʌbaadëjim hanʌm, hich heegar dichpinaa hoog. ");
INSERT INTO noaH_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mag hi pa gaai hʌ̃gt'aa simta, Jesuu bëewia, hʌ̃gt'aag hoonaa, hi t'ʌ̃r t'ʌ̃rnaa hirig, —Zaqueo, jöpai heeg hʌʌrbabaad, maimua marrau; hĩsin mʌʌn pʌ haigta jẽerimajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Magbaa chadcha jöpk'arraapai hʌʌrbawia, Zaqueoou honee Jesús hich di haar hat'aadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mamʌ chi dʌ̈i wënʌrrarr k'ʌʌnau hoowai, Jesús Zaqueo degta jẽerimaag waaidʌbaadëm hoobaawai, t'umaam k'ʌʌnau, —Keena, pãadë hoobat. Jesuun, pekau pöoma sim degta waaidʌbaadëmwai hanaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Magbaawai Zaqueoou maach Pör Jesús k'ĩirp'ee bʌ̈jãau dʌnʌʌunaa hirig t'umaam k'ʌʌn dak'ĩir, —Hũrbá, mua mʌchdëu nem wai chirʌm heem jãrrcha har hap'ʌʌ k'it'ëem k'ʌʌnag deejugui hajim hanʌm. Maagwai hiwiir hãbam dën k'ãijã sëuk'awi mua p'atk'on k'ũgur hautarr k'ai, jũrr mua hag k'ãyau hʌ̃r biek jayap deejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Magbaawai Jesuu hirig magjim haajem: —Zaqueo, pʌjã hĩchab jöoi Abrán k'ararr hag chaain hewagam k'ʌʌn dënëu, mamʌ hĩsta pua hirua hʌ̈k'aajerrjö hʌ̈k'a chirsimgui hajim hanʌm. Mag gaaimua hĩsin chadau pʌchjã peerdʌwia, mʌg degam k'ʌʌnpa peerdʌju hed pabaadëm. ");
INSERT INTO noaH_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mʌch chi Hemk'ooi Hiewaan chadcha hõor hamach k'aibag gaaimua hok'oo k'it'ëem k'ʌʌn jʌrwia, peerdʌ hawaanta bëejimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesuu Zaqueo dʌ̈i hãba nʌmua hiek'atarr hũrwia t'umaam k'ʌʌnau k'ĩirjuawai, Jesuuta Hẽwandamau pʌ̈itarr haawai, Jerusalenmua ya hichta t'umaam k'ʌʌn Pörk'aagpampii naajim hanaabá. Mamʌ mag nʌm hee ya chi Jerusalén p'öbör dak'a narr haawai, hamau mag hajappai k'augba k'ĩirju nʌm hajap'a k'ap hamk'ĩir, hamag mʌg nem hĩgk'aadam jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mag hĩgk'amamua hamag magjim hanʌm: —Woun hãb sĩejimgui hajim hanʌm, t'et'em hiewaa. Ma, hich t'ʌ̃rbapäaiwai, deeum durr majim haajem, jua t'eeg hapiwia reik'apieg. Mamʌ mag mawia hiin deeu bëeju hajiebma. ");
INSERT INTO noaH_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mag chadcha ya hich maagpamua hich chognaan diez t'ʌ̃rk'a hauwia, p'atk'on hagdaujö hamachpierr dʌ̈rrcha jigpʌ̈iwia, “Mʌg p'atk'on mua pãrag jig pʌa chirʌmʌn, mʌch bëe nʌm hora hagua p'idk'awia warag hʌ̃r haumk'ĩrau” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mamʌ mag woun hich dʌ̈i hãbam durr hee naajem k'ʌʌnaupaijã hi k'a k'õchk'aba haajeejim haajem. Maagjerr haawai hi petam hẽudee hõor pʌ̈iwia mak'ʌʌn dʌ̈i, “Pʌ chan marau maach durr reik'apimap'a nʌm” ha jaaupʌ̈ijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mamʌ hamau mag nʌm hãba, deeu bëewia, hichta ya t'umaam k'ʌʌn rey k'abaicheewai, mag hich maagpamua p'atk'on jig pʌatarr k'ʌʌn deeu t'ʌ̃rk'ʌʌipʌ̈ijim haajem, hich p'atk'on jigtarrau p'idk'awia chi hʌ̃rʌm haumatarr k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Magbaawai chi nacha deetarr bëewi, “Rey, cha k'ërʌm pʌ p'atk'ondam. Pua mʌrʌg deetarrau jũrr mua hag hʌ̃r diez veces gan haujim” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Magbaawai chi reíu hirig, “Hʌ̈u k'ërʌm” hajim hanʌm. “Pʌ chadcha piyón hajap'amʌu. Mʌg p'atk'on pöm k'aba deetarrau pua jãgbarm k'ai, jãgan jãgtarr jũrr mua pʌrʌg p'öbör diez deek'imgui hajim hanʌm chi reíu, pʌchta hag heem k'ʌʌn gobernador k'amk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Magbaawai hãbmuajã bëewia, hirig, “Rey, cha k'ërʌm pʌ p'atk'on” haichëjim hanʌm. “Mʌrʌgjã pua dee pʌatarrau cha mua hag hʌ̃r cinco veces gan wai chirʌm” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Magbaawai hĩchab magʌgjã chi reíu, “Puajã jãgan p'öbör cinco jʌ̃ajugui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","T'umaam k'ʌʌnag mag jëeuk'a hoomam haawai deeum t'ʌ̃rpʌ̈ijim haajem. Magua paawai bëewia magchëjim hanʌm: “Rey, pua mʌrʌg p'atk'on deetarr mua sĩi putdam hee pʌrëunaa hãk'a k'ërjim, hak'oom hugua. Magtarr haawai cha sim” hajim hanʌm “pʌ p'atk'ondam, hich hagpierrpai. ");
INSERT INTO noaH_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mua pʌ p'atk'onau bʌ̃ʌrjã p'idk'abajim, pʌch jãg hõor dʌ̈i hatcha hat'uu sĩerrʌm k'ap'ʌ chitaawai. Mua hagua p'idk'awia gantarr hak'iin, chi hʌ̃rʌm pua sĩi k'echeu hauk'amgui” hajim hanʌm, “pʌ dën sĩi chik'am jua p'it'ur hatarrta pʌch dënjö haadëp haajeewai.” ");
INSERT INTO noaH_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Magbaawai chi reíu magjim haajem hirig: “Pʌʌta mʌ chog chi k'aigbampama. Pʌ gaaita t'umaam k'ʌʌn k'usëugan t'ʌnʌm. Pʌch hiiupaita pua mʌ mag jaau chirʌm k'ai, magan muajã pʌ dʌ̈i pʌchdëu jaau simjö hajugui” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“Pʌ hiek mag mʌ hat'uuchanaa chik'am p'it'urg wautarrta mʌch dënjö haajem hanʌpí, ¿jãgwi mʌ p'atk'on banco hee deen mabajĩ” hajim hanʌm, “mʌch bëewai hʌ̃rʌʌpai bãau sim hoochëmk'ĩir?” ");
INSERT INTO noaH_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Maimua jũrr t'um haig narr k'ʌʌnag magjim haajem chi reíu: “Jãg hichig deetarrpierrpai wai sim dën k'echeunaa, jũrr har hichig deetarr hʌ̃r diez gan hautarragta deebat” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Magbaawai chi haig narr k'ʌʌnau chi reíg, “Rey, mamʌ ya hirua nem pöm wai sim. ¿K'ant'ee tag hirig deeju haai sĩ?” hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Magbaa chi reíu, “Mua pãrag jaauk'imgui” hajim hanʌm. “Har mʌ hat'ee nem wawaag nem par daúa hooba haajem k'ʌʌn dʌ̈in mua mʌch garmuajã hajap'a haju, hamau chok'õgba mʌ hat'ee nem wau naawai. Mamʌ har mag nem waumap'a nʌm k'ʌʌn dʌ̈i chan magba, mʌchdëu hamag nem deetarrjã warag ham jua heem k'echeu haumaju. ");
INSERT INTO noaH_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maimua hĩchab har chi mʌ k'ĩir hoomap'anaa mʌrʌg hamach reik'apimap'a narr k'ʌʌn, mʌig mʌ haig haubëenaa mʌ dak'ĩir k'ëchbapʌ̈it” hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mag jaau dichwia Jesús Jerusalén p'öbörög petajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mag mamua p'öbör Betfagé hanʌm dʌ̈i hãb hagjö Betania hanʌm dak'a durrsĩ Olivo hanʌm haar barbaimaawai hich k'apeen heem numí t'ʌ̃rk'anaa pʌ̈yaagpamua hamag magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Hachá maach k'ĩirp'ee p'öbördam sim hee hërëubaadët. Nau chi p'öbör hee dub nʌm haig pãrau burrodam pa gaai jʌ̃ k'ërʌm hooimaju. Mag burro gaai chan hagt'a ni hãbmuajã waaidʌba k'itʌm. Ma hẽer haipidut hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Hãbmua k'ãijã bëewia pãachig, “¿K'ant'ee jãg nemchaai hẽer harraag hẽk'a nʌ?” ha jëeubaawai, sĩi hit'ũu hirig, mua hig chiraawaita harrum habat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mag jaaubaawai hërëubaadeeu chadcha hamachig jaaupʌ̈itarrjöo hooimajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mag hoobaimaawai ya chi burrodam haibëeg hẽer nʌm hee, chi papk'ʌ bëewia hamag, —¿K'ant'ee pãrau mʌ nemchaai hẽer warrúma? haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Magbaawai hamachdëu hirig, —Maach Pör Jesuu hig naawaita marau harrubahab hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mag chadcha Jesús haig chi burrodam haibëewi, hamach k'ajũa jũa nʌm hʌ̃r joot'ʌ jũajem manto hanʌm hẽerk'anaa, jũrr chi burro p'õ hʌ̃r t'eernaa, hag hʌ̃r chi Jesús jiirpʌ̈ijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Magbaawai hĩchab warm k'ʌʌn ham dʌ̈i wënʌrrarr k'ʌʌnaujã hagjö mag manto joot'ʌ jũa narr hẽerk'anaa hi maju k'ʌd hee t'eerk'amajierram haajem, hichta chadcha ham Pöröu hawia. ");
INSERT INTO noaH_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Maimua ya durrsĩ Olivo hanʌm haigmua hʌʌrba nʌm dak'a haadëm hee, hõor pöm hi hẽudee honee pos wëdurum k'ʌʌnau hamachdëu hag na mag nem hooba haajempa Jesuu waumaajem hoojem k'ĩirjunaa Hẽwandamag jëeu nʌmua hĩchab “Hʌ̈u hajim” ha serereu k'ap'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mag Hẽwandamag jëeu nʌmua, —Hʌ̈ucha habarm Hẽwandam; hich mʌʌta pʌchdëu pʌch jũrr maar Reik'a pʌ̈ibarmʌugui hajierram hanʌm. Mʌg Rey pʌ̈ibarm gaaimua pʌchdëu jʌr haumam k'ʌʌnan hʌ̃gt'arm magwe pʌ dʌ̈i k'õinaa wënʌrraju. Hʌ̈u habarm Hẽwandam. Pʌjöm chan hãbjã chuk'umgui hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mag hõor pöm wënʌrrʌm hee hĩchab chi fariseonaanjã dʌ̈i wënʌrrarr haawai, mag hõor serereuk'am hũrwia, Jesuug magjierram hanʌm: —Maestro, ¿jãgwia pua pʌch higar nʌm k'ʌʌnag hiek'abama, k'ĩupagk'amk'ĩir? ");
INSERT INTO noaH_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Magbaawai hich Jesuu jũrr hamag, —Mamʌ hamau mag nʌm chadcha k'abahab hajim hanʌm. Hõor mag serereuk'am k'ʌʌnag mua hiek'abaawai ham chadcha k'ĩuu nʌisik'iinjã, jũrr har mokdau t'ʌnʌmua hamau serereuk'arr hiekpai wounaan dënjö sereu p'öbaadëbajup hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mag wëtumua ya chi Jerusalén p'öbör dak'acha haadeewai, p'öbör heerpa wai sĩi hawia, t'umaa k'ĩirjuwia Jesús bĩebaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mag bĩemamua chi p'öbörpien higwia magjim hanʌm: —¡Hëh, Jerusalenpien! Hẽwandam dʌ̈i pãach k'õinaa wënʌrramk'ĩir pãachig mua jaaujerr hiek pãachdëu hisegtarr, hĩs mʌgnaa k'ãijã deeu hãsie t'umaa k'ĩirjuwia higk'iin, pãar hʌ̈u peerdʌk'amgui hajim hanʌm. Mamʌ k'anii magʌm hiek pãar k'ĩirjug hee barjupa. ");
INSERT INTO noaH_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pãar jãg nʌʌ hawi pãar höju hed barbaicheewai, pãach hoomap'a haajem k'ʌʌnau sĩi pãar p'ʌʌrt'uur hauchëwia, p'öbör higaau warp'am magwe pãar höbërm hugua t'uur p'ʌʌrdʌpʌ̈ijugui hajim hanʌm. Magnaa pãar höbeerwaim hat'ee hoopaar haju, ");
INSERT INTO noaH_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","pãar t'um k'ëchpʌ̈pʌ̈igmamua ni hãbjã bʌ̈ hëuhëu k'itʌm hooba sĩwaag. Magbarm haigmua hatag di jãg hãbam hʌ̃r joot'ʌ hëu sĩsidʌmjã tag pãrau hich jãg hoobajugui hajim hanʌm, Hẽwandamau hich garmua pãach hoon bëetarrjã warag hi hisegtarr gaaimua. ");
INSERT INTO noaH_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Maimua chi Jerusalén p'öbör heecha pachëwia, Hẽwandamag jëeujem deg dubwia, hag hee tiendegamjö nem për narr k'ʌʌnag magjim haajem Jesuu: ");
INSERT INTO noaH_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Hẽwandamau hich higwia hich hiek gaai, “Mʌ diin sĩi mʌrʌg jëeujem diiu” ha sim. Mag simta pãachdëuta hag hee mʌg nem parhẽpag për nʌmua sĩi chik'am k'ũguurjem dik'a wai naabma hajim hanʌm. Mag warag meeurraunaa dawag jʌrk'ʌʌipʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Magtarr k'urjã hed hëepierr hich hag Hẽwandamag jëeujem degpai hõrag Hẽwandam hiek jaaujeejim haajem. Mamʌ chi p'adnaan pörk'a nʌm k'ʌʌnau chi machnaan dʌ̈imua, p'öbör heem k'ʌʌn chi t'et'emnaan dʌ̈imua meraa hi t'õopäaig hẽk'aajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mamʌ pöd hi chig haju k'aba haajeejim haajem, hõor pöm t'ʌnʌm k'ʌʌnau sĩi hãba hi hiek hũrm k'õchgau bʌ̃ʌrjã hi k'a hogdʌba haajerr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","K'ãai hãb Jesús Haai hi jëeujem deg dubwia hõrag jaau sĩejim haajem, jãga Hẽwandamau ham peerdʌ hauju. Hirua mag jaau sim haig, p'adnaan chi pörk'a nʌm k'ʌʌn bëejierram haajem, chi machnaan dʌ̈i judionaan ham Asamblea heem chi pörnaanpa. ");
INSERT INTO noaH_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mag bëewia hirig, —¿K'ai t'öwiata jãg mʌig nem për narr k'ʌʌn pua dawag jʌr wërppʌ̈ijĩ? ¿K'aíuta jãg pʌrʌg pʌchta nem hiek t'eeg hapijĩ? Marag jaaubá hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Magbaa Jesuu hamag magjim hanʌm: —Magan nacha mʌrʌg jaaubat. Muajã hĩchab pãrag jëeu hook'imgui hajim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Pãrau k'ĩirjuawai, ¿chadcha Hẽwandamauta Juan pʌ̈ijĩ hajim hanʌm, jãg hamach k'aibag Hẽwandamag chugpaapi jaaunaa hõor pör choo nʌrramk'ĩir, wa sĩi mʌg jẽb gayam k'ʌʌnau chogpʌ̈iwiata jãg nʌrrajĩwa? ");
INSERT INTO noaH_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mamʌ mag hirua jëeubarmjã pöd hʌ̈k'aju k'augba haawai hamach happai hiyʌ̈ʌ nʌmua hamach wir haigpai, —Keena, maadëu hirig Hẽwandamauta pʌ̈ijim hak'iin, magan jũrr hirua maachig, “Jãg magʌmta pãrau hirua jaau nʌrrarr hʌ̈k'abajierráma” hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wa magba maadëu jũrr, “Hichjöm k'ʌʌnaupai pʌ̈iwiata jãg nʌrrajim” hak'iin, magan hõor pöm mʌg t'ʌnʌm jũrr maach dʌ̈ita meeuk'awia, mokou bar wai nʌmuapai maach k'ëchpʌ̈ijugui hajim hanʌm, mʌg p'öbör hee t'umaam k'ʌʌnau hi higwia, “Chadcha Hẽwandam hi jaaumie chaar” haajeewai. ");
INSERT INTO noaH_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mag jaauju k'augba naawia warag, —Marau k'augbam jammuata bëejĩ, ni k'aíu pʌ̈iwiata jãg nʌrrajim k'ai hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Magbaawai Jesuu hamag magjim: —Mua pãrag jëeutarr mʌrʌg jaauba haawai muajã pãrag jaaubamgui hajim hanʌm, k'ai t'öwiata mua mʌg nem wau chitʌ́. ");
INSERT INTO noaH_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Maimua mag hõor pöm t'ʌnʌmʌg mʌg nem hĩgk'aadam jaaumamua magjim haajem Jesuu: —Woun hãbmua uvadö jĩirjim haajem. Maimua hich chawag mam k'õchk'abaadeewai deeum k'ʌʌnag alquilaapʌ̈iwi, warp deeum durr petawia, mam sĩi haimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mam mag simua ya chee jaar haadëm hee, hich chog pʌ̈ijim haajem, mag dʌ̈i hichig hich paatëm deepʌ̈imk'ĩir. Mamʌ mag chi nemjĩir k'ʌ jöoirau chogtarrdam hamach haar barbaimaawai, pʌrnaa, wʌ wai nʌʌ hawia, sĩi deeu hich jua k'arraa jʌrbapäaiwai, hich juadam parii barjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Magbaawai jöoirau deeum pʌ̈ijim haajem, hich chog. Mamʌ majã hamach haar hoo barpinaa, parhooba hi wau hiek'a wai nʌʌ hawia, warm k'ãyaujã hʌ̃rʌʌpai wʌnaa, hagjö hich jua k'arraa jʌr werbajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mag majã hich jua parii barbaimaawai deeum pʌ̈ijim haajem jöoirau. Mamʌ machará mag wʌ wai nʌmua, sĩi maach hëu pöm pepet'or haadëmua, bag k'a hʌ̃ʌipabaadeewaita hogdʌpʌ̈iwia, jʌrpʌ̈ijierram haajem, ni bʌchk'unpai deejöjöojã k'aba. ");
INSERT INTO noaH_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Magbaawai hich jöoi chi uvadö hag papau k'ĩirju sĩi hawia, “¿Mua jãga habark'iina?” hajim hanʌm. Mag k'ĩirju sĩi hawia, “Hãa, jãgan mua mʌch hiewaa mʌchdëujã chig haba haajemta pʌ̈ijugui” hajim hanʌm, “Tale hamau mʌ chaai hoop'öbaadeewai hi högk'awia hi chig habaju” hawia. Mag chadcha hich chaai pʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Maimua mag jöoirau hich hiewaa hichdëu jãsenecha haajemta pʌ̈iwia hurum hoobaawai hamach happai magjierram hanʌm: “Hachamʌ́ hi hiewaa haawai mʌguata mʌg hatag mʌg nemjĩirjã jʌ̃aju k'abahaba. Keena, jãgan maadëu warre hi t'õopʌ̈ijugui hajierram hanʌm, mʌg nemjĩirdö maach dënk'a sĩsimk'ĩir.” ");
INSERT INTO noaH_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mag chadcha hʌʌr barchëpinaa, pʌrp'öbaadëwi, warp nemjĩirdö higaau harrnaa, mam t'õopʌ̈ijierram haajem, hich jöoi hiewaa hãba. Mag nem hĩgk'aadam hĩgk'a höpʌ̈iwia hõrag magjim haajem, hich Jesuupai: —Pãrau k'ĩirjuawai, hĩsjã hagt'a mag uvadö sim hanaa chi t'ʌa narr k'ʌʌnjã hich hak'ʌʌnpai hak'iin ¿jãgaju k'ai jöoirau magʌm wounaan dʌ̈i? ");
INSERT INTO noaH_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Par hirua hich chaai hãbpai k'itʌm pʌ̈itarrpata mag t'õobapʌ̈im hoobaawai, mawia, warre hamach t'um k'ëchpʌ̈inaa, hich uvadö jũrr deeum k'ʌʌnagta jaau pʌabjëjugui hajim hanʌm, hichdëupai. Hamach jʌ̃g daar Jesuu mag hiek'abapʌ̈im hũrbaawai chi haig narr k'ʌʌnau, —Aay, Hẽwandam, ¿k'ant'ee pua magbaadëju? hajierram haajem, mag uvadö jaau sim gaaimua Hẽwandamau hamachta jaau sim k'ap'ʌ narr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Magbaawai Jesuu ham k'ĩir heerpa heerpanaa hamag, —¿K'an haawaiuma hajim hanʌm, Hẽwandam hiek p'ã sim gaai har “Di hëu narr k'ʌʌnau hisegtarr dibigta jũrr chi dihãd jãrramk'a sĩsim” ha sim? ");
INSERT INTO noaH_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Magnaa hichdëupai, Mag dihãd ha simʌn mʌ higwiata mag simgui hajim hanʌm. Chi mʌ hiek hʌ̈k'aba sim wounan juau hogt'om mag dibig hʌ̃r burrwi hichdëupai hich gaai mas wau simjöta sim; maimua mag hʌ̈k'aba nʌrrʌmta meemʌn jũrr mʌ mag dibig pömaamjö chirʌmta hi hʌ̃r buudimamjö hajugui hajim hanʌm. Jesuu mag sĩerran mag hi hiek hʌ̈k'aba meebaadeewai warre k'ĩmie durr barpʌ̈ijuuta jaau sĩejim. ");
INSERT INTO noaH_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hirua mag uvadö t'ʌa narr k'ʌʌn k'aibag sĩsid harr jaau sim gaaimua, p'adnaan chi pörk'a nʌm k'ʌʌnau chi machnaan dʌ̈imua k'aug hat'ajierram haajem, Jesuu hamachta jaau sim. Magbaawai hag bʌ̈rre hi pʌr haum higp'öbaadëjim haajem. Mamʌ mag hi pʌr hat'aawai p'öbör heem k'ʌʌnau jũrr hamachta k'aigbaju k'ĩirjuwia hi dichbajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mag hamach dʌ̈ita hõor meeuk'apiju k'ãai sĩi hõor jʌr hauwia chi Jesús sim haar pʌ̈ijierram haajem, mak'ʌʌnau chadcha k'augba haawaita hirig jëeu nʌm hawia jëeubaimaawai, jaauju k'augba hipeerdʌ k'ãijã jaaubapäaiwai, magʌm gaaimua gobernador haar hi pʌr harraag. ");
INSERT INTO noaH_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mag hërëuwi chadcha hirig maguimajierram haajem: —Maestro, marau k'ap'ʌ nʌmgui hajim hanʌm, pua chadcha nem hagchata jaaujem. Pua mag hõor hiwiir hãbpaita hʌ̃rcha k'a k'õsijã k'aba, hante pua chadchata t'umaam k'ʌʌnag jaaujem, jãgata haju haai nʌ Hẽwandamau nem jaau sim heyaa wënʌrraag. ");
INSERT INTO noaH_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Magua marau pʌrʌg jëeum hig nʌmgui hajim hanʌm: Pua hoowai ¿chadchata maach meeun judionaanaujã durrpierram k'ʌʌn rey Roma sĩejemʌgta impuesto p'agju haai nʌ, wa p'agju k'aba nʌwa? ");
INSERT INTO noaH_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mamʌ Jesuu mag sĩi hich himeraa pʌr hawaagpaita hichig jëeuchë nʌm k'ĩirjugjã k'ap'ʌ sĩerr haawai hamag magjim hanʌm: —¿K'ant'eeta pãrau sĩi himeraa mʌ pʌr hauju hẽk'a nʌma? ");
INSERT INTO noaH_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Daai mʌrʌg p'atk'on chi dau daí jʌr deebat, mua pãrag jaauk'imgui hajim hanʌm. Maimua hau deebaawai hamag, —¿K'ai k'ĩirta k'ai t'ʌ̃r dʌ̈i hag gaai sĩ hajim hanʌm, pãrau hoowai? Magbaawai hamachdëu, —Romaam rey César k'ĩir k'abahab hajierram haajem, hich t'ʌ̃r dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Magbaawai deeu hichdëu hamag, —Pãrau mag k'ap'ʌ nʌm k'ai, magan reíg hich paat deenaa Hẽwandamagjã hagjö hich paat deebat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mag hamachdëu jëeubaawai hi hipeerdʌ hiek'abarm gaaimuapai p'it'urg chuk'u hi pʌr hawaan ha bëetarrta, warag hich garmua hamachig mag jaaubarm hũrwia sĩi jʌ̃gderraa nʌm hiek'au warag hamachta k'ĩu nʌisijim haajem. Mag, pöd hi pʌr haubajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mag k'ur Jesús haig bëejierram haajem Saduceonaan. Mak'ʌʌnau jaauwai, maachta meebaadëm chan tag bʌ̃ʌrjã maach hak'aar hiiuba haajem haajem. Hamach mag nem jaau sĩerrjëem gaaimua hiyʌ̈ʌmamua juau hogt'om hirig magjierram haajem: ");
INSERT INTO noaH_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, jöoi Moisés k'ararrau Hẽwandam hiek p'ã pʌarr gaai jaauwai, woun hãb hʌʌi paraa simta mag hʌʌi dʌ̈i chaai chuk'u meemʌn jũrr chi k'od hãbam wai sim k'ai magua hich hag hʌʌipai hauju haai sim ha simgui hajierram hanʌm, hag dʌ̈i hich naamʌu chaain hooba harr haawai jũrr hi hat'ee hoo deeg; mag hoo deebarm hi chaaink'a nʌisimk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maimua hamachdëupai warag hirig nem hĩgk'amamua magjierram haajem: ’Biek hãb hãbam k'od happai hemk'ooin siete naajim haajem. Ham naam chi nacharamua hʌʌi hauwia, hich mag chaai chuk'u wënʌrrʌm hee meejim haajem, chi hemk'ooi. ");
INSERT INTO noaH_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Magbaawai jũrr chi heeumua haujim hanʌm hich hag hʌʌipai. Mamʌ mag dʌ̈ijã pöd chaai hooba, hich mag chaai chuk'u meejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Magbaawai hag heeumuajã jũrr hich hag hʌʌipai haujim hanʌm. Mamʌ maguajã pöd hag dʌ̈i chaai hooba meejim haajem. Hich mag hewagam k'ʌʌnjã hãbam hʌʌiraupai warm meemam hẽudee t'eg hahaugmamua mag hãbam k'od happai siete narr t'um t'egdʌpʌ̈ijim haajem; mamʌ ni hãbmuajã pöd mag hʌʌi dʌ̈i chaai hoobajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Maimua hãbmiecha paawai hĩchab chi hʌʌijã meejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Maagwai marau pʌrʌg jëeum hig nʌmʌn mʌgaugui hajierram hanʌm: Mag hãbam hʌʌiraupai hemk'ooin k'od hãbampai siete p'ëtarr haawai mʌg hatag t'umaam k'ʌʌn hiiu p'iidʌtk'a nʌm hedjã, ¿mag hʌʌi chijãg dënk'a sĩsijuma hajierram hanʌm: chi nacha hautarr dën, wa hẽudeegam k'ʌʌn dënwa? ");
INSERT INTO noaH_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Magbaawai Jesuu hamag magjim haajem: —Mʌg jẽb gayan, hõor jua pʌrnaa hamach chaainjã jua pʌrpipi haajerram. ");
INSERT INTO noaH_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mamʌ hiiu p'iidʌwia hʌ̃gt'archa höbër nʌm k'ʌʌn chan tag jua pʌrpʌr habam, hʌ̃gt'arm Hẽwandam chognaanjö tag meeba hich mag nʌisiju haawai. ");
INSERT INTO noaH_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ya ham Hẽwandam chognaanjö t'ʌnʌm dʌ̈i hĩchab Hẽwandam chaaink'a t'ʌnʌmgui hajim hanʌm, hich Hẽwandamauchata ham p'iriutk'a hautarr gaaimua. ");
INSERT INTO noaH_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Maach meewia deeu hiiu p'iidʌajem hiek'an Moiseeujã jaaujimgui hajim hanʌm, pabʌ̈dam neneree k'itʌm huurdʌ t'ʌnʌm hichdëu hootarr jaau sim hag hẽsap hichdëu p'ã pʌatarr gaai. Mag jaauwai, hi hiek maach Pör Hẽwandaman jöoingar jöoi Abrán k'ararr hag Hẽwandam haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hẽwandam chan hoob mag chi k'ëcham k'ʌʌn Hẽwandam k'abam. Hẽwandaman chi hiwam k'ʌʌn dënëu. Hirigan nawe meetarr k'ʌʌn hawia k'ãijã t'um chi hiwam k'ʌʌnau ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hirua mag hiek'abapʌ̈im hũrwia hãaur k'ʌʌn chi machnaanjã haig narr haawai mak'ʌʌnau hirig, —Maestro, hʌ̈uchata pua mag hiek'abapʌ̈imgui hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mag, Saduceonaanaujã hamachdëu pöd hi pʌr hauba meerk'abapʌ̈im hoobaawai tag hirig jëeuba hich mag nʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mag k'ĩu t'ʌnʌisim hee jũrr Jesuu hich garmuata hamag jëeujim hanʌm: —¿Jãga pãar hiek mag Mesías jöoingar David k'ararr hag chaain hewagam k'ʌʌn dën haajẽ, ");
INSERT INTO noaH_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","hich Daviiuchajã hichdëu hẽsap p'ãtarr Salmos hanʌm gaai hi higwi “maach Pör” ha hiek'atarrta? ¿Pãrau k'ĩir hee paba nʌ, Hẽwandamau hich hiek'atarr Daviig p'ãpitarr? Mag hirua p'ãtarr gaai mag sim: “Maach Pör Hẽwandamau magjim maach Pörög: ‘Mʌch hiek t'eeg chirʌmjö haag mʌ dʌ̈i hãba mʌ juachaar gar jupbá hajim, ");
INSERT INTO noaH_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pʌch hoomap'a haajem k'ʌʌn t'um mua pʌch jua hee pʌrk'a dee nʌm hora.’ ” ");
INSERT INTO noaH_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mag hich David k'ararrauchajã Hẽwandamau pʌ̈iju haajerr higwia “maach Pör” ha hiek'atarrta, ¿jãgwia pãrau sĩi hi David chaain hewagam k'ʌʌn dënpai haajẽ? Mag sĩi hich chaaipai haju hak'iin Daviiu hich paarmua mag “maach Pör” habak'amgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maimua hõor t'umaam k'ʌʌn jʌ̃g daar Jesuu hich k'apeen hich dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnagta magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moiseeu Hẽwandam hiek p'ã pʌatarr jawaag chi machnaan dʌ̈i k'ai k'ĩir k'ap'ʌ haajeet. Jãk'ʌʌnan sĩi k'ajũa bʌ̈ duurg jũanaa kaaijã hee hõrau hamachig saludaawaijã hamach t'ö hiek'apim k'õsita sĩerrjëemgui hajim hanʌm. Jãk'ʌʌnan hamach Hẽwandam hi jaaujem deg weetwaijã hamachta pörgarcha t'umaam k'ʌʌnag k'ĩir jʌrk'a juupjemgui hajim hanʌm, hamachta warm k'ʌʌn k'ãaijã hajapcha nʌm hawia. Maimua di chaaur t'ach k'ömk'ĩir t'ʌ̃ʌrwaijã parhooba jupba, k'ãidu hajapcharamta jʌ̃a hau sĩerrjëemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jãk'ʌʌnaun sĩita k'oopaa hʌʌin juagam nemdamjã k'echt'ʌg haumaajerram. Magnaata sëuk'a warag ham kõit Hẽwandamag jëeu nʌʌ haajemgui hajim hanʌm, juau hogt'om hamach magba nʌm hamk'ĩir. Mamʌ hamach jãg wënʌrrʌm paar, jũrr Hẽwandamau hĩchab ham gaai jua k'ʌabajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mag jaau dichwia hich Jesuu Hẽwandamag jëeujem deg jup hoo simua heerpa hoo sĩejim haajem, riknaan bëe t'ʌnʌm k'ʌʌnau jũrram k'ʌʌnau hamach ofrenda chi p'atk'on p'iejem hee pʌapʌ̈pʌ̈ik'am. ");
INSERT INTO noaH_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mag jũrram k'ʌʌnau hamach ofrenda deechë t'ʌnʌm hee, hĩchab k'oopaa hʌʌi hãb hap'ʌʌ k'itʌm bëejim haajem. Mag hʌʌirau p'atk'on chi dau daídam dau numpai wai sĩerr warre mag numwe hag hee pʌapʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mag hoobaawaita Jesuu, —Mʌg k'oopaa hʌʌi hap'ʌʌ k'itʌmuata chadcha t'umaam k'ʌʌn k'ãaijã hʌ̃rʌʌcha deebarmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Riknaanaun Hẽwandamag hamach dën chi sobbarm heemta ofrenda deejerram. Mamʌ mʌg k'oopaa hʌʌiraun hich dën hãbmiecha hagua hich t'ach k'öju harrdamta t'um Hẽwandamag deebarmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hãaur haig narr k'ʌʌnau Haai hi jëeujem di hooimʌ hõrau nem deematarr dʌ̈i mokdau hajap'amua joot'ʌt'ʌʌd hëu dʌnʌm hoowia hiyʌ̈ʌ naajim haajem. Mak'ʌʌnag Jesuu magjim haajem: ");
INSERT INTO noaH_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Har mokdau sĩi hajap'a joot'ʌt'ʌʌd jãg t'ʌnʌm pãrau hoo naabá. Jãg t'ʌnʌm chan mokpör hãbjã hãbam hʌ̃r hich jãg hajap'a joot'ʌt'ʌʌd sĩerrabam. Jãg t'ʌnʌmʌn sĩi t'umaa hõrau pogueupʌ̈ijuuta jãg dʌnʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Magbaawai hi k'apeenau hirig, —Maestro, pʌ hiek mag jãg mokdau joot'ʌt'ʌʌd t'ʌnʌm t'um hõrau pogueupʌ̈iju hanʌm, ma ¿jãagwaichata magjuma? ¿K'an jãg nʌm gaaimua Hẽwandamau hijaaurjö hoopijuma hajim hanʌm, mag Haai hi jëeujem di pogueupʌ̈imʌʌ pam? ");
INSERT INTO noaH_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Magbaawai jaaubaadëmua hichdëu hamag magjim haajem: —Keena, k'ĩir k'ap'ʌ wënʌrrat; hoob chik'amnag sĩi hʌdʌraa pãach k'ũgur haupimiet hajim hanʌm. Nau mʌg hatag paawai hõor k'apank'am k'ʌʌnau hamach hiekpaita mʌ hiek gaai t'ʌwia, “Mʌʌta hag Cristoou” hajurau, “Hẽwandamau pʌ̈iju haajerr. Hĩsta mʌ barbaichëm t'umaam k'ʌʌn Pörk'aag” ha hiek'amajugui hajim hanʌm. Mamʌ hamau pãachig maagwaijã hoob ham hiek hʌ̈k'amiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mʌg hatag paawaijã pãrau juurhi t'eega t'ʌnʌnʌmk'am hũrjurau, durrpierr. Mag t'ʌnʌm dʌ̈i hĩchab hõor wir haig hamach pörnaan dʌ̈ipai meeuk'awia sĩi p'ogdʌ t'ʌnʌm hanʌmjã hũrjugui hajim hanʌm. Mamʌ maagwai hoob pãrau, “Hĩsin chad Hẽwandamau warreta maach höpʌ̈yaagpam” hamiet hajim hanʌm. Chadcha magʌm nem t'um hich jãg didichagmaju; mamʌ magbaadëmua warag hag bʌ̈rre chan Hẽwandamau hõor t'um hʌʌrppʌ̈ibamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Maimua hĩchab mʌg durr t'um hi hagk'aju hed gayaa pamamjã k'ap hamk'ĩir jajawagmamua magjim haajem: ’Mag t'ʌnʌisim dʌ̈i hĩchab durr mʌg wëjöm heepai durr chaauram k'ʌʌn dʌ̈i wërbʌp'öo haadëjugui hajim hanʌm, hamachta jũrr chik'amnaan k'ãyau hʌ̃rpai ham k'õchgau. ");
INSERT INTO noaH_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mag nʌm dʌ̈i hĩchab durrpierr hʌʌur t'eega duuimajugui hajim hanʌm. Hagjö durrpierr jãdau t'eega burrnaa k'amor machagjã k'ĩir pogk'e hompamamua hõor pöm t'up'ãp'ãau hajugui hajim hanʌm. Magbaadeewai hedjã heejã hĩchab nem dau chigaa hag na hooba haajempata hoomam gaaimua hõor jãp'ierrju jaaumajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Mamʌ mag Haai hi jëeujem di hõrau pogueupʌ̈iwi, pãar höju nawe chik'amnau pãar hẽudee hẽk'awia, pãar pʌrnaa, hamach hãba biirdʌwia, Hẽwandam hi jaaujem deg pãar harrwia, cárcel degjã pãar harrmajugui hajim hanʌm. Mag pãrau mʌ hiek hʌ̈k'a durrum hat'eepai hamau pãar gobernadornaan haar harrwi reinaan haarjã harrjugui hajim hanʌm, pãar k'aibag waumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mamʌ magʌm haar mag pãar harrwaita hante pãrau hamag mʌ hiek jaauwímʌcha jaaujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mag t'et'em k'ʌʌn na pãach harrwai hoob pãrau pãachdëupai pãach kõit hiek'aju k'ĩirjuwia hag nawe, “¿Mʌ k'an hata hiek'ajuwa?” ha k'ĩirjumiet hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mua pãrag mag chirʌmʌn, hiek'amk'ĩir mʌchdëuta k'ĩirjug deeju haawaita mag chirʌm. Mag mʌchdëu hiek'api chiraawai hãbmuajã pãar hichaaur hiek t'ierr k'aba, ni pãrau hiek'a nʌmʌn sëuk'aawaiujã habajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hich mag jaran mʌ hiek hʌ̈k'a nʌm gaaimua pãach dënnaanaupaijã pãar pʌr deemajugui hajim hanʌm, chi t'et'em k'ʌʌnag. Wa magbam k'ai, pãach k'od hãbam k'ʌʌnaupai, sĩi t'ʌ̃r k'odpaim k'ʌʌnau, wa pãach k'apk'ʌʌn hajap'amua k'ãijã pãar pʌr deemaju. Mag pʌr deemaawai hãaur k'ʌʌn k'ëchpʌ̈inaa ");
INSERT INTO noaH_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","maimua har juau t'õoba habarm k'ʌʌn jũrr t'umaam k'ʌʌnau hoomapp'a hajugui hajim hanʌm, mʌ hiek hʌ̈k'a durrum gaaimua. ");
INSERT INTO noaH_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mamʌ mʌg jẽb gaai hõrau mag pãar hoomap'a hawiajã mua pãar t'ʌa wai chitajugui hajim hanʌm. Hamau mag pãar hoomap'a hajup mamʌ, pãar pörbʌ̈dam chan hãbjã Hẽwandamau chig hapibajugui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Hõrau mag pãach dʌ̈i k'aigba hawiajã pãarta warag Hẽwandam dʌ̈i hubʌ wënʌrrʌmʌn, pãar hak'aran hi haar höbërjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mag jajawagmamua jũrr Jerusalén p'öbör higwiajã magjim haajem: ’Mamʌ ya har pãachdëu hoowai Jerusalén p'öbörta soldaaunau p'ʌʌr t'uurbaadëm hoobaawai k'ap habat hajim hanʌm, chadchata ya Jerusalenpienan warm k'ʌʌnau k'ëchpʌ̈iwia sĩi di k'ierr happaita jʌjʌrʌʌ sĩwaagpam. ");
INSERT INTO noaH_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Magbaawai chi Judea durr nʌm k'ʌʌn, durr dapag hee dʌrbat hajim hanʌm; maimua chi Jerusalén p'öbör hee nʌm k'ʌʌn, höbërdʌtk'awia hërëupetat hajim hanʌm. Maagwai har p'öbör chaaur hamach p'idk'aajem haar k'ãijã nʌm k'ʌʌn, hoob tag hag p'öbör hee bëemiet. ");
INSERT INTO noaH_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Magbaadëmʌn, juau hich Hẽwandamau ham dʌ̈i magju harr haawai, hich hiek p'ã sim gaai t'umaa hichdëu jaautarrjö israelnaan hamach k'aigba nʌm paar ham chachwia ham dau hap'ʌʌ hapiegau hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mamʌ ¡hëh, hapdurr hajim hanʌm, magbaadëm jaar har hʌʌin jõor k'it'ëem k'ʌʌn, maimua hĩchab hʌʌin har chaaindam daumeraa wai durrum k'ʌʌn! Mag járata mʌg Israel durr hõor dau hap'ʌʌta nʌisijupa hajim hanʌm. Mua mag chirʌmʌn, hõor mʌg t'ʌnʌm k'ʌʌn gaaita Hẽwandam k'ĩir machag burrju haawaita mag chirʌmgui hajim hanʌm hich Jesuucha. ");
INSERT INTO noaH_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hãaur k'ʌʌn juurhi hee warm k'ʌʌn garmua juau k'ëchmaju; maagwai tagam k'ʌʌn mag juurhi hee chi ganbarm k'ʌʌnau pʌrk'anaa hamach dʌ̈i hamach durr p'ë harrmajugui hajim hanʌm, durrpierr. Mag deeum durram k'ʌʌnau Jerusalenpien dʌ̈i mag nʌm, hich Hẽwandamau jaautarr t'umaa habam haig chan Jerusalén p'öbörön warm k'ʌʌnauta hich mag pör höbeerpiba wai nʌisijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Maimua hich Jesuu hichpai jaaumamua magjim haajem hĩchab: ’Magbaawai mʌch chi Hemk'ooi Hiewaa bëeimʌʌ haadëmjã k'ap'ʌ hajugui hajim hanʌm, hãsdawam hedau gaai, hedau harg gaai, maimua hĩchab p'ĩdag gaai. Mag hoobaawai hõor jãp'ierrwia warag nem waujujã k'augba haadëm dʌ̈i, gaai machag hök'ĩirjug pöoma hap'öbaadëjugui hajim hanʌm. Maimua p'ũas dau dapag t'ʌnʌm hiek sĩi hedjã hee pũu wëjömpa hũrp'öbaadeewai ");
INSERT INTO noaH_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","hõor sĩi chi meemjö hiek chukjã haadëp hajugui hajim hanʌm, warag Hẽwandamau hamach dau hap'ʌʌ hapiju k'ĩirjuwia. Mag jaran hedjã heem nem sĩsidʌmpata sĩi parhooba hamach nʌnʌid harr chaaur haaidʌ jörrjëe t'ʌnʌisijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Magbaawaita t'umaam k'ʌʌnau mʌch chi Hemk'ooi Hiewaa chadcha hedjã baug hee dau daau hurum hoojugui hajim hanaabá. Ya maig mʌg jẽb gayam k'ʌʌn t'um chachbaadeewai mʌchta nem jua t'eeg t'umaam k'ʌʌn Pörk'a bëejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mamʌ pãachdëu mamagk'am hoop'öbaadeewai warag honee habat. Magbaadeewai ya pãrau k'ap'ʌ nʌmgui hajim hanʌm, chik'am jua hee pãach dau hap'ʌʌ wënʌrrʌm hee Hẽwandamau ya pãach peerdʌ hauwimʌʌ pam. ");
INSERT INTO noaH_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mag Jesuu deeu hich bëeju jaau simua hĩchab hamag mʌg ejemplo jaaujim haajem: ’¿Pãrau hooba haajẽ hajim hanʌm, har higo k'ër k'uk'uur haadëm, wa magbam k'ai deeum pabʌ̈ parhoobam k'ãijã k'ër k'uk'uur haadëm? ");
INSERT INTO noaH_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pãrau k'ap'ʌ nʌm, mʌig Israel durr higo k'ër k'uk'uur haadëmʌn t'umaam k'ʌʌnau ya chadcha döchʌumie dakpapak'am haajem. ");
INSERT INTO noaH_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hich hagjöta hajugui hajim hanʌm, hĩchab mʌ bëeju gayaa paawaijã. Ya pãachdëu nem t'um mʌchdëu jaau chirʌmjö hohoo k'abaadeewai k'ap'ʌ habat hajim hanʌm, ya mʌ bëeimʌʌ pam; muan mʌg durr mʌchdëuta jʌ̃a hauchëwia mʌchta t'umaam k'ʌʌn pörk'aan hurum. ");
INSERT INTO noaH_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mua pãrag mag Haai hi jëeujem di hõrau pogueupʌ̈iju ha jaau chirʌmʌn, cha hõor t'ʌnʌm k'ʌʌn k'ëchju nawe cha mʌchdëu jaau chirʌmjö t'umaa chadcha hajuuta jaau chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Hedaujãjã mʌg jẽb dʌ̈i t'um chuk'u haadëju, mamʌ cha mua pãrag jaau chirʌm chan sëuk'aawai k'abam, jãan t'umaa hich hag hee höbërjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","K'ĩir k'ap'ʌ nʌisit hajim hanʌm, mʌ bëewai sĩi döo gaaipai nʌm dʌ̈i warag pãach nem hig nʌmta k'ĩirju nʌm gaaimua mʌ hiek hʌ̈k'aba, warag t'ãar t'eeg sĩi mʌ bëejujã k'augba, hok'opp'a nʌm pãach hoochëpim hugua. ");
INSERT INTO noaH_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mag mʌ bëem hedan, har hatarraayau hãwarr baarwai sĩi k'öodʌ haaujemjöta, mʌg durr gaai hõor t'ʌnʌm k'ʌʌn t'um hãba dëgölp chachaan bëejugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mamʌ warag Hẽwandamag jëeunaa hajap k'ĩir k'aug nʌisit. Pãrau hich mag pʌaba hirig jëeu wënʌrrʌmʌn, nem t'umaamua mag hõor chachmawiajã bʌ̃ʌrjã pãar chig habajugui hajim hanʌm. Maagwai ya mʌch pierrum hedjã bʌ̃ʌrjã chigag chuk'u pãar mʌ haig mʌ k'ĩirp'ee bëe t'ʌnʌisijugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mag jaau simua hãsdaaupain sĩi Jesuu Haai hi jëeujem deg hõrag jaaujeejim haajem, Hẽwandam hiek. Maimua hedaar paawaita jũrr durrsĩ Olivo hanʌm gaai mawia hich mam hëejeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hãspa t'ʌnʌisiewai hedaup'erre hõor pöoma hi nʌan weetjeejim hanaabá, Haai hi jëeujem deg, hirua nem jaau sim hũraag. ");
INSERT INTO noaH_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mag hãbmiecha Jesús hich k'apeen dʌ̈i Jerusalén p'öbör hee nʌm jaar, pan levadura chuk'u wauwia k'oojem p'iesta burrju k'ãai k'apan k'aba waaur sĩejim haajem. Hich mag p'iestapai hĩchab Pascua ha t'ʌ̃ʌrjem. ");
INSERT INTO noaH_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Maagwai hĩchab p'adnaan hee chi pörk'a nʌm k'ʌʌnau hagjö judionaan Hẽwandam hiek hat'ee chi machnaan dʌ̈imua hamach heepai, “Jãgata hak'iin bʌ̃ʌrjã hõrag k'augpiba jãg Jesús pʌrnaa t'õobpʌ̈ik'amgui” hanaajim hanʌm. “Magba mʌg k'apanag heewe pʌr hat'aawai heeu hõor pöm mʌg t'ʌnʌm maach dʌ̈ita meeuk'aduk'am” ha k'ĩirju naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Hamau mag k'ĩirju nʌm hee, woun hãb Judas ha t'ʌ̃r sim sĩejim haajem, hibʌʌr wauwia hĩchab Iscariote ha t'ʌ̃ʌrjerr. Mag woun hĩchab hich Jesús dʌ̈i hi bʌ̈ hogdʌba wënʌrraajerr k'ʌʌn heem hajim haajem. Mag Jesús dʌ̈i hãba nʌrraajerrta meperau pör meubaadeewai p'adnaan chi pörk'a nʌm k'ʌʌn dʌ̈i hĩchab guardianaanjã chi pörk'a nʌm k'ʌʌnpa hãba nʌm haar majim hanaabá, jãgata hichdëu hamag hi pʌr deeju k'ap jawaan. ");
INSERT INTO noaH_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Maimua barimawia jaaubaawai, hamachdëu chi Judas hiek hamach jʌ̃gaagaa hũrbaawai, honeeu p'öbaadëwia warag hirig p'atk'onjã deeju ha hiek'ajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hichig magbaawai chará warag, —Hich magau magan maach hiek'abarm; murua chadcha pãrag hi pʌr deejugui hajim hanʌm. Magtarr haigmua hãba hi pʌr deeju k'ĩirjugta wai sĩsijim haajem, chi p'öbörpienagjã hich k'augpiba. ");
INSERT INTO noaH_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Judaau Jesús hëugar mamagk'am hee, pan levadura chuk'u wauwia k'oojem hed hãspa hëebaadëjim haajem. Mag hed judionaanau nemk'oo hedam hat'ee ovejadam wai narr t'õowia hedau k'ëubaadeewai k'oojeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hich mag hedcha Jesuu Pedro dʌ̈i Juan t'ʌ̃rk'anaa hamag magjim hanʌm: —Pãar maar na hërëubaadët. Maimua ovejadam për hauwia hagdamta maar na p'iejãb waubaimat hajim hanʌm, maach t'um hãba k'öimaag. ");
INSERT INTO noaH_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Magbaawai hamachdëu, —¿Jampaita marau pʌ na p'iejãb wauwimaju haai nʌma? ha jëeujierram haajem Jesuug. ");
INSERT INTO noaH_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Magbaa chi Jesuu hamag, —Chamʌg Jerusalenag k'ʌd ma sim hee hërëubaadët hajim hanʌm. Nau chi p'öbör dub nʌm haigcha woun hãb dö jöi haut'urwia döt'ũr dʌ̈i degag mam pãrau hooimaju. Magbaawai hi dʌ̈i hërëuwia hi dubbaimam deg dʌ̈i dubbaimat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mag dubwia chi dik'ʌʌg, mʌch chi maestroouta pãar pʌ̈ijim habat, jampaita nau k'eeurag maach t'um hãba t'ach k'öju haai nʌ ha k'ap jëeumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Magbaawai mag wounau pãrag hoopien majugui hajim hanʌm, hʌ̃gt'aa dijã pöm sim ya sĩi chi k'ĩir k'augam. Maigta nem t'um k'ĩir k'augwia maar nʌbat hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Magbaawai chadcha hi hipierraa hërëubaadeeu t'um hichdëu jaaumarrjöo hooimajierram hanaabá. Maig, hich na mag ovejadam waupitarr chadcha tagam nempa t'um k'ĩir k'augwia sĩi tagam k'ʌʌn dʌ̈i hi baraata hoo nʌisijim haajem, hãba k'oog. ");
INSERT INTO noaH_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Maimua k'ëubaadëm hee Jesús barchëjim haajem, tagam k'ʌʌn hich k'apeen dʌ̈i, Pedro Juan dʌ̈i narr haig. Mag hichdëu jʌr hauwia hi dʌ̈i hogdʌba wënʌrraajerr k'ʌʌn deeu t'umaa nʌisim hee, ya chi p'iejãb wau wai narrjã t'öik'a sĩsiewai hãba k'oog paauk'abaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mag k'ö nʌmua magjim haajem hich k'apeenag: —Keena, chadcha chik'amnaanau juau mʌch t'õoju nawe pãar dʌ̈i mʌg nemk'oo hedam ovejadam k'öm k'õchaaga chirajimgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mʌ chan mʌg k'öbarm haigmua tag k'öba, hãba Hẽwandamta hʌ̃gt'ar t'umaam k'ʌʌn Pörk'a sĩsim hedta hũmaai pãar dʌ̈i hãba tagam k'ʌʌn hichdëu peerdʌ hautarr k'ʌʌnpa deeu maach t'um hãba k'öjugui hajim hanʌm. Mag hedta t'umaam k'ʌʌnau warrgar nemk'oo hedam oveja t'õowai Hẽwandamau hamach peerdʌ hauju ha k'ĩirjuajerrjö, chadcha hamach peerdʌ nʌisim k'ap'ʌ hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Maimua vino jarrdam jua hee hauwia Hẽwandamag hʌ̈u hajim hanaa, —Ya pʌr hat'at hajim hanʌm. Maimua, Dönaa jũrr hʌapʌ̈ipetat hajim hanʌm, hagdaujö dö haumamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mʌʌn hãbmieta hĩs pãar dʌ̈i mʌg vinodam dö chirʌmgui hajim hanʌm. Mʌg döbarm haigmua tag döba, hãba Hẽwandamta t'umaam k'ʌʌn Pörk'a sĩsim hedta deeu döjugui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Maimua hagjö panjã jua hee hauwia, Hẽwandamag hʌ̈u hajim hanaa, t'orreuwia, hamag deenaa, —Mʌg panan mua mʌch morta pãrag dee chirʌm; mʌg hatagjã mʌ k'ĩirjunaa hich mʌgta k'abat ha jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Maimua ya k'ö haaipagk'abaadëm hee, deeu chi vino jarrdam jua hee hauwia hĩchab, —Mʌg jarr heem vinodam döbarmta warrgarwe Hẽwandamau hõor dʌ̈i hiek deeju haajerrau; mamʌ mʌg hiek'an hiek hiiuriugui hajim hanʌm. Mʌ bag mʌg vinojö hãrbarmuata Hẽwandamau, hĩsmua hatagan chadau pãar peerdʌ wënʌrraju haai nʌm ha jaau simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pãrag k'ap hamk'ĩir warre jaau chirʌmgui hajim hanʌm: Mag mʌ bag hãrmk'ĩran, maach heem mʌig maach dʌ̈i hãba t'ach k'ö simuapaita hich paarmua mʌ pʌr deeju, mʌ hoomap'am k'ʌʌnag. ");
INSERT INTO noaH_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mʌʌn chadcha Hemk'ooi Hiewaau, mamʌ magʌm hãba chadcha hamau mʌ t'õojugui hajim hanʌm. Mamʌ Hẽwandamau hich magpiju harr haawai t'um hichdëu jaautarrjöo höbëbërgmam. Mamʌ ¡Hëh, hapk'iitʌ hajim hanʌm, mag mʌ t'õomk'ĩir mʌ pʌr dee chirʌm woun! ");
INSERT INTO noaH_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesús mag hiek'abarm hũrwia hi k'apeenau hamach heepai jũrr chik'am hipeer hahauk'amua, —¿Chijãguataa wir haigpai mag meer hi pʌr deeju k'ai? hanaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Maimua nʌʌpai hawia hĩchab hamach heepai, “¿Chijãata magan mʌig maach hee hʌ̃rʌʌcha sĩ?” ha chik'am hipeer hahau k'ap'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mamʌ magbaawai Jesuu hamag magjim hanʌm: —Mʌg durr gaai reinaan t'ʌnʌm k'ʌʌnan hamachta hʌ̃rʌʌcha nʌm hawia hõor dʌ̈i hat'uucha sĩerrjëem. Mamʌ mag nʌmta hamachta chi t'ierrnaan hawia jũrr hõrag hamach higwia, “Jãguan chadau maar hat'ee nem hajap'amta waaujem” ha hiek'apimjã k'õsi haajemgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mamʌ pãar hee magju haai k'aba nʌmgui hajim hanʌm. Mag k'ãyau chadcha t'et'em hawia k'ãijã warag serbiibamjöta haju haai sim; maagwai chi pörk'a simta jũrr hich chogjöta haju haai simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Magnaa hamag, Pãrau k'ĩirjuawai, ¿chijã chi t'et'em hagá hajim hanʌm: sĩi mes gaai t'öik'a sĩsiewai k'oogpai jupcheejem, wa mes gaai chi t'ëp paajem? Magnaa hichdëupai, Chi hʌ̃rʌʌcha simʌn ya sĩi t'öik'a sĩsim habaawai k'oogpai jupcheejemʌugui hajim hanʌm. Magnaa hamag, Mʌʌn chadcha pãar Pöröugui hajim hanʌm. Mamʌ pãrau hoo nʌm, sĩi mʌig mʌ pãar chogk'a chitʌmjöo chirʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mamʌ mua hĩchab k'ap'ʌ chirʌmgui hajim hanʌm, chadcha pãarta mʌ dʌ̈i hogdʌba hich jãg wënʌrraajem mʌ chitʌmpierr, pãach dau hap'ʌʌ hajujã k'ĩirjuba. ");
INSERT INTO noaH_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pãach jãg wënʌrrʌm gaaimua, mua pãrag hĩchab mʌch dʌ̈i hõor pörk'apijugui hajim hanʌm, mʌ Hayau mʌchta t'umaam k'ʌʌn reik'apibarm dʌ̈i. ");
INSERT INTO noaH_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mag mʌchta t'umaam k'ʌʌn Pörk'a chirsim hedta deeu maach hãba honee haju. Maimua rey juupjemjöm sie gaai jupk'awia pãachta mʌ dʌ̈i jöoi Jacob k'ararr chaain doce narr k'ʌʌn hag chaain hewagam k'ʌʌn pörk'ajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Maimua hĩchab magjim haajem maach Pör Jesuu Simonag: —Simón, dösãtau Hẽwandamag jëeu wai simgui hajim hanʌm, pʌ dʌ̈i hichdëu hampierr hawia pʌ dau haug waupieg. ");
INSERT INTO noaH_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mamʌ mua jũrr pʌ kõit Hẽwandamag jëeu chirʌmgui hajim hanʌm, pʌch k'ũgurcheewai warre burrm hiek burrm hugua. Maagwai hũmaai deeu mʌ t'ʌ̃r gaai k'ĩirju chirsiewai pʌchdëupaita jũrr pʌch k'apeenag jaauju haai chirʌmgui hajim hanʌm, hamjã hagjö hubʌ nʌisimk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Magbaawai chi Simonau hirig, —Señor, mʌʌn pʌ dʌ̈i cárcel deg mawia pʌ t'õbarm haar t'õimaju hak'iinjã maju chirʌm; magʌmjã mʌ gaai mas k'abamgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Magbaawai Jesuu jũrr hirig, —Pedro hajim hanʌm, pʌ mag hiek'a chirʌm hãba, nau hõrau pʌchig jëeuwai, hãt'ãrr bĩeju nawe biek t'ãrjup purua hamag bʌ̃ʌrjã mʌ k'augba chitʌm ha jaaujugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Maimua warm k'ʌʌnagjã magjim haajem: —Har mua Hẽwandam hiek jawamk'ĩir pãar putjã chuk'u p'atk'onjã chuk'u sĩi hich jãg zapat t'eg jũajujã chuk'u pʌ̈ijim hed, ¿nem hinag hat'ee pãar haugchëjierrá? hajim hanʌm. Magbaawai chi k'apeenau, —Hʌ̃hʌ̃, bʌ̃ʌrjã maar haugchëbajimgui hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Magbaawai deeu hichdëupai hamag, —Magtarr hĩsin chadau put wai nʌm k'ai, hat'aadët; hĩchab p'atk'on k'ãijã wai nʌm k'ai, hat'aadët; maimua hãb k'ãijã espaar chuk'u sim k'ai, hich k'ajũa përbapʌ̈i hajim hanʌm, hagua hawaag. ");
INSERT INTO noaH_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mua pãrag mag chirʌmʌn, Hẽwandam hiek p'ã sim gaai jaau simjö ya mʌch t'õimʌʌ paawaita mag chirʌmgui hajim hanʌm. Hẽwandam hiek p'ã sim gaai mʌ higwia jaauwai, “Hiin, hõor t'õomiejöta wai naaju” ha sim. Mʌ higwia hich mag p'ã sim haawai chadcha t'um hichdëu jaau sim heyaa höbëbërg maju ha jaaumajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Magbaawai hamachdëu hirig hoopinaa, —Señor, ya marau mʌig espaar numí wai nʌmgui hajierram hanʌm. Magbaawai hichdëu, —Tag mʌ hiek'abam, hidëu hich magpai sĩujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Maigmua höbërdʌtk'aau Jesús Olivo durrsĩig petajim haajem, k'eeupierr mawia mag durrsĩ gaaimua hich Hayag jëeujerr haawai. Mag hi mam dʌ̈i hĩchab hi k'apeenjã hi dʌ̈i wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mag wëtwia hich Hayag jëeujem haig bardʌtk'abaimaawai hich k'apeenag, —Hẽwandamag jëeubat hajim hanʌm, dösãtag hʌdʌraa pãach p'ũrreu haupiba mʌ dʌ̈ita hubʌ wënʌrraag. ");
INSERT INTO noaH_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mag jaauwia, hichin ham haigmua mawia, juau mokdau barbapäaiwai burrjem hag warp'agjöpai sĩeimajim haajem, ham bigaau. Maig jẽk'ʌt jĩepöröu p'õbk'anaa, hʌ̃gt'aag heerpanaa, hich Hayag jëeubaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mag jëeumamua, —Tata hajim hanʌm, pua k'õs hak'iin, hatcha mʌ dau hap'ʌʌ hapibak'am. Deeum nem waubarmuajã hagjö hõor peerdʌ hauju hayaa hak'iin, mʌ gaai machag mʌgcha hãwatbak'amgui haajeejim hanʌm. Mamʌ pʌchdëuta k'ap chirʌm; mʌchdëu k'õsi chirʌmjö k'aba, pʌchdëu k'õchagpierrta mʌ dʌ̈i habá ha hiek'amajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hich Hayag jëeuwai mamagk'amua k'a t'eeg chuk'u t'ʌnʌm hee, hʌ̃gt'armua Hẽwandam chog bëewia hirig juapá deechëjim haajem, mag hich dau hap'ʌʌ haju hãwatamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mag hich dau hap'ʌʌ haju k'ĩirjuwia gaai machag t'ʌnʌmua warag oraa nʌmta, k'ajap'am nemjö t'et p'ʌrëu hahau haajeejim hanʌm. Mamagk'amua jʌachë t'ʌnʌm hoowain sĩi jʌa gaai bagpata höbër t'ʌnʌm t'ëutk'a t'ʌnaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mag hʌ̃gt'aag hich Hayag jëeu sĩi hawia, p'iidʌwia, hich k'apeen hoon bëewai sĩi warag hök'ĩirjug machgau k'ãidʌtk'a t'ʌnʌmta hoochëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Magbaawai hamag, —P'iidʌtk'abat'ʌ̃ keena hajim hanʌm. ¿K'ant'eeta pãar k'ãi nʌma? K'ãiju k'ãai Hẽwandamagta jëeubat'ʌ̃ hajim hanʌm, dösãtag hʌdʌraa pãach t'ʌ haupim hugua. ");
INSERT INTO noaH_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mamʌ hagt'a Jesús mag hiek'a dʌnʌm hee, dëgölp ham haig hõor k'apan pos haichëjim hanaabá. Mag k'apanag hee hoowai hich Jesús dʌ̈i doce hogdʌba wënʌrraajerr heem hãb Judas ha t'ʌ̃r sĩerrta ham na hurajim hanʌm. Mag bëewia, Jesús dʌ̈i hãba dʌnʌʌuchëjim hanaabá, sĩi k'ajap'a saludaa nʌmjö hi k'ĩir hʌ̃ʌg. ");
INSERT INTO noaH_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Magbaawai Jesuu hirig magjim hanʌm: —Judas, mʌch chi Hemk'ooi Hiewaa mʌ hoomap'am k'ʌʌnag pʌr deeg mʌ k'ĩir hʌ̃ʌ chirʌmta pʌchigan sĩi saludaa chirʌm ha chirabma hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Magbaawai hich Jesús k'apeenau hamach Pör dau hap'ʌʌ haju k'aug hat'aawai, —Kakë, ¿marau pʌ kõit esparau ham dʌ̈i jãauju jãg nʌ? hajierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mag hirig jëeu nʌm hee, hãbmua bis habarmʌn, p'adnaan pör hag chog kach juachaar garmta warre hoort'ubapʌ̈ijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Magbaawai Jesuu hich k'apeenag, —Hoob jãgmiet; hidëu mʌ dʌ̈i hamachdëu hampierr hapibat hajim hanʌm. Magnaa chi kach deeu hich sĩerrjöo k'aarpi sĩujim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Maimua Jesuu hoowai haig naajim haajem: p'adnaan chi pörk'a nʌm k'ʌʌn, judionaan Asamblea heem pörnaan, maimua Hẽwandam hi jëeujem di t'ʌajem k'ʌʌn chi pörnaanpa t'ʌnaajim haajem, hi pʌr hawaan bëetarr k'ʌʌn. Magbaawai chi Jesuu hamag magjim haajem: —¿Pãrau hoowain mʌʌn sĩi hõor nem jĩgk'anaa hõor t'õomiejöta chirabama hajim hanʌm, jãg sĩi mʌ haig jua hee jierrnempan happai bëeg? ");
INSERT INTO noaH_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Hẽwandamag jëeujem deg hed hëepierr pãar dʌ̈i mʌ chiraawai, bʌ̃ʌrjã pãrau mʌ chig haba haajerrta, hĩsta Hẽwandamau pãrag hʌdʌraa mʌ pʌr haupiju hed hajim. Maagwai hĩsta hĩchab chi dösãtjã pãar hʌ̃rpaju hed hajimgui hajim hanʌm, mʌ pʌr haumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Maimua Jesús pʌrp'öbaadëwia, harrwia, p'adnaan pör deg wai dubp'öbaadëjim haajem. Maagwai Pedroou warppaimuata hi hẽudee hoopʌ̈pʌ̈ig warrmaa hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mag chi p'adnaan pör haar deet'urwia chi Jesús hierr wai nʌmich, jũrr di hũjãrr hõt hörwia hag bigaau hohood hap'öbaadëjim haajem. Magbaawai Pedrojã hĩchab ham bigaau hoo sĩsijim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mamʌ hi mag hoo simta, haiguim hʌʌi hĩchab chi p'adnaan pör chogk'a sim bëewia, hi k'ĩir heerpanaa, warm k'ʌʌnag, —Chamʌg wounjã hĩchab hi dʌ̈i nʌrraajemʌu haichëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Magbaawai Pedroou, —Mua magʌm wounaan hooba chitʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Maimua hag k'ur nʌʌpai hawia jũrr hemk'ooi hãbmua hirig, —Pʌjã ham heem k'abahab haichëjim hanʌm. Magbaawai Pedroou, —Kakë, mʌ chan ham heem k'abam perá hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Maimua deeu hag k'ur hora hãbjönaa deeum bëewia maguajã hagjö hirig, —Chadcha mʌg wounjã hi dʌ̈i nʌrraajem k'abahab hajim hanʌm; jãan Galileapierrauwai hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Magbaawaita Pedroou, —Kakë, mua bʌ̃ʌrjã k'augbam, k'an hata pʌ hiek'a chirʌm k'ai hajim hanʌm. Magbarm bʌ̈rre hagt'a t'umjã Pedro hiek'a höba nʌm hee, hãt'ãrrta kekerekee hahbar. ");
INSERT INTO noaH_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mag hãt'ãrr bĩebaawai maach Pör Jesucristoou hewag p'ʌʌrba hoo nʌʌ hajim haajem, Pedroog. Maigta Pedroou k'ĩir heyaa haadëjim hanaabá, maach Pöröu hichig, “Pedro, hãt'ãrr bĩeju nawe hõrau pʌchig jëeuwai biek t'ãrjup pua bʌ̃ʌrjã mʌ k'augba chitʌm ha hiek'aju” ha jaautarr. ");
INSERT INTO noaH_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mag k'ĩir hee dʌnʌisim habarmʌn chadau, gaai machaaga haadëmua dawag höbërwia, warre hö jãsenag haadëmua bĩe sĩi hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Maagwai Jesús pʌr wai nʌm haig hoopaar t'ʌnarr k'ʌʌnaujã hi wau hiek'anaa hĩchab moketaupa p'ãr wai nʌmua hi gaai mas waumaajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Magnaa putiu hi dau p'ãarjʌ̃naa jũrram k'ʌʌnau k'ĩidadcha juajãau p'ot hanaa hirig, —Magan k'aug hat'á, k'aíuta pʌ p'ãrjĩ haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hich mag pʌamjã higba, hi wau wai nʌmua warag hirig parhoobajã hiek'amaajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Maimua ya hãspabaadeewai hãba biirdʌjierram haajem: Asamblea heem chi pörnaan p'adnaan pörk'a nʌm k'ʌʌn dʌ̈i Hẽwandam hi jawaag chi machnaanpa. Mag biirdʌwia hamach Asamblea hee chi Jesús haibëewia hirig, ");
INSERT INTO noaH_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Pʌchta chadcha warrgarwe Hẽwandamau hõor peerdʌ haumk'ĩir jʌr hauwia pʌ̈iju haajerrá? Warre marag jaaubá hajierram hanʌm, marau k'ap haag. Magbaawai Jesuu, —Mua pãrag jaauk'iinjã, pãrau mʌ hiek hʌ̈k'abajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Maimua mʌch garmua jũrr pãrag jëeumak'iinjã, pãrau mʌ hiek jʌ̃ʌjã haba ni mʌ pʌapʌ̈ijã pʌapʌ̈ibajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mamʌ nau mʌg hatag jöpcha mʌg woun Hemk'ooi Hiewaa Hẽwandam chi jua t'ierr bigaau hi juachaar gar jupimajugui hajim hanʌm, Hẽwandam dʌ̈i hãba t'umaam k'ʌʌn Pörk'aag. ");
INSERT INTO noaH_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Magbaawai t'umaam k'ʌʌnau hirig, —¿Hãa, magan pʌʌn Hẽwandam Hiewaapama? hajierram hanʌm. Magbaawai jũrr hichdëu hamag, —Pãachdëupa k'abá pãrau k'ap'ʌ mʌ haruu ha jaau nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Magbaawaita hamachdëu, —¿K'an hatcha maadëu deeum k'ʌʌnau jaau nʌmta hũrm hig nʌma? Ya maadëu hũrbarmgui hajierram hanʌm, hich hiiucha jaaubarm. ");
INSERT INTO noaH_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Maig wai nʌʌ hawia, hamach t'um hãba höbërdʌtk'awia, chi Jesús gobernador Pilato haar harrjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Maimua mam pawia Pilatoog sëuk'a magp'öbaadëjim hanʌm, Jesús k'ĩir: —Marau mʌg wounau pãar hëugar nem k'aigbam jaau nʌrrʌm hũrimajim hajierram hanʌm, pãar dʌ̈i hõor meeuk'amk'ĩir. Hichdëuta rey Cesaroog dëbpaarjã p'agpiba jaaunaa hichdëupaita hĩchab hichta Hẽwandamau pʌ̈iju hatarr haajemgui hajierram hanʌm, judionaan rey. ");
INSERT INTO noaH_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Magbaawai Pilatoou hich Jesuugcha, —¿Chadcha pʌʌta judionaan Reí? ha jëeujim hanʌm. Magbaawai Jesuu hirig, —Pua k'abá chadcha k'ap'ʌ jaaubapʌ̈imgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Magbaawai Pilatoou p'adnaan chi pörk'a nʌm k'ʌʌnag maimua tagam k'ʌʌn haig narr k'ʌʌnagpa, —Mua mʌg woun gaai bʌ̃ʌrjã nem k'aigba hooba chirʌmgui hajim hanʌm, hi t'õopäaig. ");
INSERT INTO noaH_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pilatoou magbaawai chará warag hamachdëuta hiek k'ẽgk'a p'öbaadëwi, —Jãguan chadchata hõrag pãar hëugar sëuk'a nem jaau nʌrrʌmua p'öbör meeuk'apiju hẽk'a simgui hajierram hanʌm, pãar dʌ̈i. Judea durr hee t'umaam k'ʌʌnag hich mag jaau nʌrraajem; Galilea durrmua jaaubaaderr hich mag jaau p'ʌʌrdʌ nʌrrʌmua k'ĩeb mau pabaichëmgui hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mag Pilatoou hũurwai Jesús Galilea durrmua bëejim ha hũrbaawai haig narr k'ʌʌnag jëeujim haajem, chadcha Galileapierr k'ai ha k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mag jëeuwai chadcha Galilea durram ha hũrbaawai, —Hãa, magan Herodes haarta deepʌ̈ijugui hajim hanʌm, hichta haram gobernador haawai. Mag chadcha deepʌ̈ijim haajem, mag jaar chi Herodejã hagjö Jerusalén p'öbör hee sĩerr haawai. ");
INSERT INTO noaH_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Maimua Herodeeu Jesús hoo hat'aawai honee haadëjim hanʌm, hag nawe hi dʌ̈i hoom k'õchag sĩerr haawai. Hichdëu hũurjeejim haajem Jesuu nem wau nʌrrʌm. Maagwai hich daúachata nem maadëu hooba haajem hirua wau sim hoom hiigjeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hichdëu mag k'ĩirju sim gaaimua hirig nem k'ĩir pogk'e jëeumaajeejim haajem. Mamʌ magʌmjã Jesuu bʌ̃ʌrjã hi hiek jʌ̃ʌ haba haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Maig naajim haajem hĩchab chi p'adnaan pörk'a nʌm k'ʌʌn Hẽwandam hiek hat'ee chi machnaanpa. Mak'ʌʌnau warag t'et hiek k'ẽgk'a, —Chadcha hi hiekk'õr pöm sĩebahab haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Magbaawai Herodeeu hich soldaaun dʌ̈imua hi gaai hiuk'anaa hi serbiibagpa p'ënaa, —Pãadë hoobat, judionaan reik'aju hanʌmta dau hap'ʌʌ hoo k'ërʌm haajeejim hanʌm. Magnaa warag juau hogt'om hi wau nʌmua k'ajũa hajap'am reinaanau jũajem k'ajũa jũapinaa deeu chi Herodeeu Pilato haar deepʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mag hed Pilato Herodes dʌ̈i k'apeer hajap'am k'ajierram haajem, warr magju nawe chan jũrr hagdaujö chik'am hoomap'a haajerrta. ");
INSERT INTO noaH_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Deeu Herodeeu Jesús hich haar deebapäaiwai Pilatoou t'umaam k'ʌʌn hãbam haig t'ʌ̃rk'a haujim haajem: p'adnaan chi pörk'a nʌm k'ʌʌn, judionaan chi t'et'em k'ʌʌn maimua chi p'öbörpienjã hagjö. ");
INSERT INTO noaH_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Maimua hamag magjim hanʌm: —Mʌg wounau maar hëugar sëuk'a nem hĩgk'a nʌrrʌm hawia pãrau mʌ haig hi haibëejierram. Mamʌ mʌchdëucha pãach dak'ĩir magʌm k'ap haag jëeu hoowai mʌg woun bʌ̃ʌrjã hiekk'õr chuk'u simta pãrau hich k'ĩirchajã mag t'ʌnarramgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pãrau k'ap'ʌ nʌmgui hajim hanʌm, mua Herodes haar hi deepʌ̈itarr. Mamʌ Herodeeu hoowaijã hichiita mʌg woun bʌ̃ʌrjã k'aibag chuk'u höbëbërk'am. Mʌg sim haig mua hoowai mʌg woun k'aibag chuk'u simgui hajim hanʌm, t'õopäaig hat'ee. Magnaa hamag, ¿Jãgajĩ hirua? ");
INSERT INTO noaH_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Muan hi pʌapʌ̈iju, mamʌ nacha hi wʌpi t'ʌnʌʌujugui hajim hanʌm, pʌapʌ̈iju nawe. ");
INSERT INTO noaH_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Mamʌ mag Pilatoou Jesús pʌapʌ̈iju habaawai warre t'umaam k'ʌʌnau hi hãba, —Jesús t'õobapʌ̈i, maimua jũrr Barrabaata maraun sĩi k'ajap'a höbeerpʌ̈ipi nʌmgui hajierram hanʌm. Mamʌ mag hamau preso hãb sĩi höbeerpi jaau narran, añopierr mag p'iesta burr nʌm hee paawai mag k'aajerr haawaita mag höbeerpi jaau naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mamʌ hamau höbërpʌ̈ipi jaautarr Barrabás haajerran cárcel deg sĩejim haajem, hichdëu hõor meeuk'apiwia mag meeuk'a nʌm hee hõor t'õotarr kõit. ");
INSERT INTO noaH_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Magbaa hich Pilatoou Jesús pʌapʌ̈im k'õsi sĩerr haawai deeu hamag hiek'ajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mamʌ magbaawai hũmaai deeu sereeu p'öbaadëwia hihãba, —Warre jãg Jesús pakuls gaai meerp'ë t'õobapʌ̈it haajeejim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mamʌ pʌaba ya biek t'ãrjupamua Pilatoou deeu hamag, —¿Pari k'an nemta hirua k'aigba waujĩma hajim hanʌm, hi t'õopäaig? Mua chan bʌ̃ʌrjã hi k'aibag hooba chirʌmgui hajim hanʌm, hi t'õopäaig. T'õoju k'ãai sĩi wʌnaa hi pʌapʌ̈iju jãg sĩ hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Magbaawai chará warag hähäak'amua hãba pakuls gaaita meerp'ëpi jajaau haajeejim hanaabá. Hich mag warag sereeu t'ʌnʌm k'ĩupaajã k'augba, hamachdëuta Pilato k'ĩupaa sĩujierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mag nʌʌ paawai Pilatoou ham hipierraa jũrr Jesuuta hamach jua hee deejim haajem, hamach k'õchagpierr hi dʌ̈i hamk'ĩir. Maimua hich soldaaunag t'õopʌ̈ipi jaaujim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mamʌ maagwai chi Barrabás cárcel deg sĩejim haajem, hichdëu hõor meeuk'apiwia hich hag meeuk'aa heepai hõor t'õotarr kõit. Mag, cárcel deg sĩerrta weeupʌ̈ipijim haajem, hõrau hig narrjö. ");
INSERT INTO noaH_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mag wai naawia Jesús t'õopʌ̈yaan hat'aadeeu, woun Simón hanʌm Cirenepierr p'öbör hee hurum dʌ̈i t'ẽubaawai, chi soldaaunau Jesuu harrmaa harr pakuls jũrr hi höp'ëeu hʌ̃r jiirpʌ̈ijierram haajem, Jesús mam hẽudee harramk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Maagwai hi hẽudee hõor pöoma wëdurajim haajem. Mag hõor k'apanag hee hʌʌinjã hĩchab hi hʌ̃apër durrumua hi hat'ee bĩe wëdurajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mamʌ Jesuu hewag p'ʌʌrba hoonaa hamag, —Jerusalenpie hʌʌin, hoob mʌ hat'ee bĩemiet hajim hanʌm. Mag k'ãyau pãach mor dʌ̈i pãach chaain k'ĩirjunaata bĩebat hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mʌg hatagta pãar dau hap'ʌʌcha haju. Mag jaar hʌʌin pöd chaain hooba harr k'ʌʌnau hamach k'apeen chaain dʌ̈i dau hap'ʌʌ durrum hoowia, “Hʌ̈uta jãg mʌ chaai chuk'u hʌrrʌm” hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hich mag jaar hĩchab hatcha mag dau hap'ʌʌ wënʌrramaaugau, t'õom k'õchgau durrsĩigta wounaanagamjö, “Maar hʌ̃r dʌrbagk'abaadët; pãach heegar warre maar bëpbapʌ̈it” ha hiek'ajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hamau mʌ mʌg wai naawia nau mʌ t'õobapäaiwai pa hajap'amta sĩi jẽwamk'ĩir t'ubapʌ̈imjö hajugui hajim hanʌm. Hamau mʌ dʌ̈ijã mʌg nʌm, ¿jãga haju k'ai hajim hanʌm, hamachdëu pahachjök'am k'ʌʌn hoowai? ");
INSERT INTO noaH_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mag chi Jesús harrum dʌ̈i hĩchab numí chi k'aigbam cárcel deg wai narr k'ʌʌn harrjierram haajem, hagjö t'õopäaig. ");
INSERT INTO noaH_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Maimua buchagdam “Pörpá durrsĩ” hanʌm gaai waaidʌtk'awia pakuls gaai hi meerp'ëpʌ̈ijierram haajem, maimua hi bigaau chi k'aibagnaanjã hagjö, hãb hi juachaar gar maimua hãb hi juawë gar. ");
INSERT INTO noaH_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Maagwai pakuls gaaimua Jesuu, —Tata, hõrau mʌ dʌ̈i mʌg nʌm hidëu sĩi hich jãg k'ĩir hok'oobapʌ̈i. Hamau hamachdëu nem wau nʌmjã k'augba naawaita mʌg mʌ dau hap'ʌʌ wau nʌm haajeejim haajem. Maagwai chi soldaaunau hamach happai, “Magan ¿k'aíuta chi k'ajũa jʌ̃aju k'ai?” hawia, mokdaudam bar nʌmua gan haumajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Maagwain hõrau Jesuugta heerpapaad t'ʌnaajim hanʌm. Mag nʌm dʌ̈i chi t'et'em k'ʌʌnaujã hiuk'anaa, hi wau hiek'anaa, daau hirua hichdëupai hich peerdʌ hat'aju hawia hirig, —Deeum k'ʌʌn peerdʌ hautarrpí, pʌchjã peerdʌ hat'á haajeejim hanʌm, pʌchta chadcha Cristo chaar Hẽwandamau jʌr hauwia pʌ̈itarr k'ai. ");
INSERT INTO noaH_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Maimua chi soldaaunaujã hĩchab sĩi hi waauwaipai hirig vino hadchuchúhu sim dömk'ĩir deechënaa jũrram k'ʌʌnau hirig, —Pʌ chadcha judionaan Rey k'ai, pʌchdëupai pʌch peerdʌ hat'á haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Maagwai hi meerp'ë jiir wëjöm pör hʌ̃r hẽsapdau p'ãk'a sim gaai jaau sĩejim haajem, k'an gaaimuata hi mag wai naajĩ. Chi hẽsapdau gaai “Chamʌʌta Jesuu, judionaan Rey” ha p'ã sĩejim haajem. Chi hẽsapdau p'ã sĩejim haajem griegonaan meúa, latín meúa maimua hebreonaan meúajã hagjö. ");
INSERT INTO noaH_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hĩchab hi dʌ̈i chi k'aibagnaan numí narr haawai hãbmuajã warag hi waunaa hirig, —¿Pʌ chadcha Hẽwandamau hõor peerdʌ haumk'ĩir pʌ̈itarr k'abá? Magʌmta, ¿jãg pua pʌch peerdʌ hauwia, maarjã peerdʌ haubamma? haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mamʌ magbaawai jũrr chi k'aperaupai hirig meeurraunaa, —¿Maachjã hagjö t'õopäaig hat'eeta hamau maach mʌig wai nʌmta pua Hẽwandam dak'ĩir warag mag hiek'a chirʌ́? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mag k'ãyau maachin, chadcha maachdëu k'aigba harr gaaimuata mʌg naabahab hajim hanʌm. Mamʌ mʌg woun chan bʌ̃ʌrjã pekau chuk'u simta hamau hi mʌg dau hap'ʌʌ wai nʌmgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Maimua hichdëupai mag hiek'apʌ̈inaa jũrr Jesuug, —Ya deeu pʌchta Reik'a bëewai hoob mʌ k'ĩir hok'oo chiram hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Magbaa Jesuu hirig, —Hĩswe pʌ mʌ dʌ̈i durr wʌ̈jʌ̈u durr chiraimaju hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hich mag hed hedausĩhcha nʌmta dëgölp hedau k'ĩbaadëm habarmʌn hedaramjö haadëjim haajem. Mag k'ĩ t'ʌnʌʌ hawia hedau p'ʌʌibaajër las tresjö naata deeu hedau haardʌbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mag hedau hãsdawam k'ĩbaadëm hee, Hẽwandamag jëeujem deg hierrgajãrcha put nem parrg t'uur hëu wëjorrta jãrrcha hʌ̃gt'aamua heeg sʌrr habarmʌn, warre t'oop'em numí jijirar jöisijim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mag hedau k'ĩbaadeewai Jesuu t'et, —¡Tata! Nau mʌ chaaupabaadeewai puata mʌ hak'aardam k'ap chirʌmgui hajim hanʌm. Mag hiek'a k'itʌm hee warag maach chaaupabaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Magbaawai capitán Romapierr haig sĩerrau hichdëu mag hoobaawai, —Chadchata jãgan mʌg wounan chi hajap'am hajimgui hajim hanʌm, Hẽwandam na. ");
INSERT INTO noaH_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Maimua hĩchab haig hõor pöm t'ʌnarr k'ʌʌnau hamach daúa mamagk'am hoobaawaita hãsie t'umaa hewag k'ĩirjuwia pör jõjõig wëtmajierram haajem, hamach diig. ");
INSERT INTO noaH_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mamʌ t'um hi k'apeen Galilea durrmua hi dʌ̈i hãba chi hʌʌinpa bëetarr k'ʌʌnaun warppaimuata mamagk'am t'um hoo naajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mag hed haig sĩejim haajem hĩchab woun hãb José hanʌm, Arimateapierr. Chi Arimatea hanʌm, Judea durram p'öbör hajim haajem. Hich mag José hĩchab judionaan Asamblea heem woun hajap'am hajim haajem, Hẽwandam dau na. ");
INSERT INTO noaH_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Maagwaita hich k'apeenau Jesús pʌr hawaag hibëp naawaijã hich chan ham higar k'aba sĩejim hanaabá. Magua hamau hi dau hap'ʌʌ wai naawaijã hichdëu chan dichba haajeejim hanʌm. Mag wounau hĩchab Hẽwandamau maach peerdʌ haumk'ĩir pʌ̈iju jaaujerr bëeju hanʌmta nʌajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hich mag wounauta, Jesús meebaadeewai, Pilato haar mawia chi mor mag mee k'ërʌm harraag jëeuwimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mag jëeuwimawia, Pilatoou harrju haai sim habaawai, mawia, heeg paawia, dĩesdam hee pʌrëunaa, jẽbdi pöm durrbʌ̈ k'õpag hee chi k'örm wai sĩerr hee hauk'ëraan harrjim haajem. Mag jẽbdeg chan hagt'a hõor hãbjã hauk'ërba k'örwia sĩi sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mag hi hauk'ërtarr hed viernes k'eeurag hajim haajem, jua hʌ̃ʌijem hedam hat'ee nem t'um k'ĩir k'aaugjem hed. ");
INSERT INTO noaH_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mam pamjã chi hʌʌin Galilea durrmua hi dʌ̈i bëetarr k'ʌʌnau hich mag hogdʌba, chi jẽbdi haar wëtwia hoojierram haajem hamach daúacha, jãga Jesús hauk'ërjĩ. ");
INSERT INTO noaH_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Maimua wëtwia, t'ũpag p'ëwia, hi k'a p'uraag sĩi jʌ̃gdee wau sĩujierram hanaabá. Maimua noram sĩi degpai jua hʌ̃i k'ëujierram haajem, Hẽwandamau Moiseeg hich hiek p'ãpitarr gaai jaau simjö. ");
INSERT INTO noaH_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Maimua mag jua hʌ̃i k'ëutarr noram, domighed hedp'erre hagt'a k'ĩk'ĩsu nʌwe, hʌʌin wëtjierram haajem chi jẽbdi haar hoon, hamachdëu hi k'a p'uraag jʌ̃gdee wau wai narr dʌ̈i. Mag ham wëtum dʌ̈i deeum hʌʌinjã ham dʌ̈i wëtjim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Maimua hooimaawai, mokpör pömk'amua chi jẽbdi hi hee joot'ʌ p'ãar sĩerrta chawag pʌrëupʌ̈i t'ʌnaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Magbaawai warag hag hee dubnaa hoowai, maach Pör Jesús mordam hich hauk'ërtarr hee chukk'u t'ʌnaajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mag hamachdëu hooba habaawai, “Keena, ¿jãga habarmta mʌg maadëu hoochëba habarma?” hanaajim hanʌm. Mag nʌm hee hoowai, hemk'ooin numí sĩi k'ajũa bʌ̃ʌmjö jũa sĩsidʌmta ham k'ĩirp'ee dʌnʌʌutk'abaichëjim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Magbaawai jãp'ierr hajaugau pöd ham k'ĩir heerpaba sĩi heeg hʌ̃t'ʌ p'öbaadeewai mak'ʌʌnau hamach garmua hamag magjierram hanʌm: —¿Chi monak'amta k'ant'ee pãrau hi jʌr wënʌrrʌmma hajierram hanʌm, mʌg jẽbdi hõor k'ëraag watarr hee? ");
INSERT INTO noaH_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Hi ya hiiu p'iidʌwia petabahab. Magua mʌig k'aba simgui hajim hanʌm. K'ĩir heyaa habat hajim hanʌm, Galilea durr haawaiwe hichdëu pãachig, Hemk'ooi Hiewaa pekau pömk'am k'ʌʌnau hi pʌr haunaa pakuls gaai hi meerppʌ̈iju jaaujerr; mamʌ k'ãai t'ãrjupam hee deeu hich hiiu p'iidʌju jaautarrjã k'ĩir heyaa habat hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Magbaawaita chadcha hi hiek'atarr k'ĩir hee dʌhnʌisijierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Magbaa chi jẽbdi haigmua wëtwia, chi dʌ̈i wënʌrraajerr once narr k'ʌʌnag t'um hamachdëu hootarrjöo jaauwimajierram haajem. Hich mag t'um haig narr k'ʌʌnagjã hich hagjö jaaujierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mag chi hʌʌin hich Jesuu once jʌr hautarr k'ʌʌn haar hiek jaauwimarr k'ʌʌnan, María Magdalena hajim haajem, Juana dʌ̈i, María Santiago hãdpa, mag tag hĩchab tagam hʌʌinpa. ");
INSERT INTO noaH_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mamʌ hʌʌinau nem hĩgk'a nʌm chi Jesús k'apeenau hũurwai sëuk'a nʌmjöo haawai hʌ̈k'abajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mamʌ Pedroou mag hũrbaawai p'iidʌbaadëwia jẽbdiig k'ap'igbaadëjim hanʌm. Maimua hag hee hierr hooimaawai, hãba hi pʌrëu sĩerr put happaita hooimajim hanaabá. Hichdëu mag hoobaawai hich diig mamua hich hödegpain, “¿Jãga hawiata jãg hich hauk'ërtarr hee chukk'u t'ʌnʌ́ma?” ha k'ĩirjubaadëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Maimua hich hag hedpai hõor numí p'öbör Emaús hanʌmʌg wëtjim haajem. Mag Emaús p'öbör Jerusalenmua once kilómetros sĩejim haajem chi warp'ag. ");
INSERT INTO noaH_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mag hërëubaadëwia k'ʌd hee Jesús higwia, “¿Jãgataa hi hauk'ërtarr heejã jãg sĩi k'ãidu parii t'ʌnʌ́ma?” ha hiyʌ̈ʌ wëtmajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mamʌ ham mag hiyʌ̈ʌ jũrr chik'am hi jũrr jaaupʌ̈pʌ̈ig wëtumta, hamau hig narr Jesuhchata bëewia ham wëtum dʌ̈i maa hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mamʌ hamach bigaau mag nʌrrʌmjã pöd k'aug hauba, sĩi deeum k'ʌʌnpiita naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mag wëtumua hich garmuata, —Keena, ¿pãar k'andam jaauwaita mʌg hiyʌ̈ʌ wënʌrrʌ́ma? ¿Jãga jãg pãar hök'ĩirjuumjö wëtmá? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Magbaawai hãb Cleofas haajerrau hirig, —Maadëu k'an hiek hagájã hamap'a simgui hajim hanʌm. T'umaam k'ʌʌnau k'ak'apdö t'ʌnʌm, jãgajĩ Jerusalén p'öbör hee. Pʌjã hĩchab hag p'öbör hee mʌg nemk'oo dichtarrta, ¿hãba pʌchdëupaita k'augba chirʌ́? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Magbaawai hich Jesuu hamag, —¿K'ani jãgjierráma hajim hanʌm, mʌg nemk'oo hee? Magbaa hamachdëu hirig jaaumamua, —Jesús Nazaretpierrma hajierram hanʌm, Hẽwandam hi jaaumie. Hirua Hẽwandam jua t'eegau nem k'ĩir pogk'e waaujeejim. Maimua jãga Hẽwandamau maach peerdʌ haaujẽ ha jaauwaijã hõrau k'ak'apdö haajeejimgui hajim hanʌm, chadcha Hẽwandam hiekta jaau sim. ");
INSERT INTO noaH_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mamʌ mag k'itarrta p'adnaan chi pörnaanau chi t'et'em k'ʌʌn dʌ̈imua Pilatoog pʌr deebajieb hajim hanʌm, jũrr hich soldaaunag pakuls gaai meerp'ë t'õopi jaaumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hamau hi jãgbajupii hawia marau k'ĩirjuawai hichdëuta israelnaan t'um Romapien jua heemua pör höbeer haujupii naajimgui hajim hanʌm. Mag k'ĩirju naajieb mamʌ, viernes hi t'õotarr ya k'ãai t'ãrjup pamgui hajim hanʌm, hĩsim k'urau hi dau hap'ʌʌ habarm. ");
INSERT INTO noaH_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Mag nʌm hee warag hʌʌin maarjö hi higar hʌ̈k'a nʌm k'ʌʌnau hĩs hedaup'erre k'ĩsu nʌwe jẽbdi haar hoot'urwia maach jʌ̃gderraata jaauchëjierramgui hajim hanʌm. Ham hiek k'abá mag chi hauk'ërtarr hee hooimaawai, chukk'u, sĩi Hẽwandam chognaanta haig naajim hanʌm. Mak'ʌʌnau hamag jaauwai, Jesús hiiu sim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mag jaaubaichëm hũrwia hagjö maach heem k'ʌʌnaucha chi jẽbdi haar hoon weetwai chadcha hʌʌinau jaau narrjö sĩi k'ãidu parta hooimajierram haajem ha hĩgk'amajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Magbaawaita jũrr hichdëu hamag, —Pãarta k'ĩirjug chukk'u nʌmá hajim hanʌm. Hẽwandam hi jaaumienau p'ãtarr gaai t'um hich magta höbëbërg maju ha jaaujierram, cha pãachdëu mʌrʌg jaau nʌmjö; mamʌ pãrau hʌ̈k'amap'ata naabahab hajim hanʌm. Pãrau k'ĩirjuawai, ¿hí hich Hẽwandamaucha jʌr hautarr haawai hich jãg dau hap'ʌʌ haju haai k'aba sĩejĩ? Mag k'abamgui hajim hanʌm. Ya nawe hich mag p'ã sĩerr haawai hich mag dau hap'ʌʌ haju haai sĩebajieb hajim hanʌm. Mamʌ hĩchab chi jʌr hautarr k'ʌʌu deeu hiiupiwia hichta t'umaam k'ʌʌn Pörk'apiju ha simjã hagjö mag Hẽwandam hi jaaumienau jaaubajieb hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Maimua jũrr hichdëuta warag hamag jaaubaadëjim hanaabá. Nacha Moiseeu p'ãtarr gaaimua jaaupʌ̈pʌ̈ig k'ĩeb chi Hẽwandam hi jaaumienau p'ã pʌatarr gayam magwe, hich higwia bëeju ha jaau sĩsidʌm t'um hajap'a jaaudubjim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mag hiyʌ̈ʌ wëtumua p'öbördam Emaús hanʌm hee hamach di haar barimajierram haajem. Mamʌ mam pabaimaawai hich Jesuu warag ham dak'ĩir sĩi dicham hig sĩejim hanʌm, juau hich t'ʌamk'ĩirjö. ");
INSERT INTO noaH_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Magbaawai hamachdëu hirig, —Maar haig k'ãibajë. Ya hatcha hedau k'eeuraa sĩebahab; k'ʌd pʌ k'ëujuwai hajierram hanʌm. Magbaawai chadcha ham dʌ̈i sĩsijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mag ham dʌ̈i t'ʌbawia, hãba hohoodö t'ach k'oogpamua pan hich jua hee hauwia, Hẽwandamag hʌ̈u hajim hanaa, t'orreuwia, hamag hʌapʌ̈ijim haajem, hag na hichdëu haajerrjö. ");
INSERT INTO noaH_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Magbaawaita dau heerdʌ p'öbaadëmjö warre hi k'aug hat'ajierram hanaabá. Mamʌ mag hich k'aug hat'am hee, dau përbarmjö harrau, ham jãrr sĩerrta dëgölp chukk'u haadëjim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Magbaawai hamach wir haigpai, —Keen, jãguata mʌch t'ãar heepain muan hich k'ãijãa ha chirajimgui hajim hanʌm hãbmua; maimua hĩchab maach dʌ̈i k'ʌd hee hiyʌ̈ʌ hurumua Hẽwandam hiekpa t'umaa hajap'a jaaupʌ̈pʌ̈igmam hũrwiajã mua k'augaa haadëjimgui hajim hanʌm hich k'aperag. ");
INSERT INTO noaH_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mag hamach hap hiyʌ̈ʌ naawia hich hag bʌ̈rre deeu bëejierram haajem Jerusalén p'öbörög, hamach k'apeen narr haar jawaan. Maimua hoocheewai, chi Jesús k'apeen hi dʌ̈i hogdʌba wënʌrraajerr k'ʌʌn once t'umaa hãbam haig podpa t'ʌnʌm hoochëjierram haajem, tagam k'ʌʌn hĩchab Jesús higar hʌ̈k'a narr k'ʌʌnpa hãba. ");
INSERT INTO noaH_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Maigjã hũrimaawai hamach t'umaam k'ʌʌnau, “Keena, chadchata maach Pörön hiiu p'iidʌbarmwai; ya Simonagjã hich hoopibarm” ha jaau nʌmta hũrimajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mag hamachig jaaubaawai, hamachdëujã jũrr warm k'ʌʌnag maguimajierram haajem: —Keena, magan maraujã pãrag jaauk'imgui hajierram hanʌm, maachdëu hi hootarr: Hirua k'abá maar hẽk'a hauwia k'ʌd hee maar hi dʌ̈i hãba wëtjima hajim hanʌm. Mamʌ mag k'ʌd hee hãba wëttarrjã marau pöd hi k'aug hauba, sĩi hãba t'ach k'ö nʌm haig pan t'orreuwia hichdëu hag na jiigjerrjö jigbaadëm haigta, marag hich k'augpimjö k'augpibaawai, marau hi k'aug haujimgui hajierram hanʌm jũrr hamach k'apeenag. ");
INSERT INTO noaH_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mag hagt'a ham hich hag hiekpai jũrr jaaup'öo t'ʌnʌm hee chi Jesús ham jãrr dʌnʌʌuchëwia, —¿Jãgpai nʌ keena? Hoob jãp'ierrmiet, mʌ k'abahab haichëjim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mag sĩi dëgölp hamach jãrr dʌnʌʌubaicheewai jãp'ierr nʌm hiek'au sĩi hi hak'aarta hoo nʌmpii naajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mamʌ mag jãp'ierr nʌm hoobaawai hichdëu hamag, —¿K'ant'ee pãrau pãach k'ĩirjug heepai “mʌʌta hak'aar” hanʌ́? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pãar hiek mag mʌ hak'aar hanʌm, pãadë hoobat mʌ jua maimua mʌ bʌ̈jã hagjö. Chadcha mʌch k'abahab hajim hanʌm. Mʌ gaaicha pʌrbahut, magnaa hajap'a hoobat hajim hanʌm. ¿Pãrau hak'aar gaai pʌrju haai nʌ, mʌ gaai pʌr nʌmjö? Hak'aar chan mor chuk'u sĩerrʌmgui hajim hanʌm, woun k'aba haawai. ");
INSERT INTO noaH_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Magnaa chadcha hamag hich juajãjã hoopinaa, hich bʌ̈jã hoopijim hanaabá, chadcha mag gaaimua hichta chik'amnau pakuls gaai meerp'ë t'õotarr hag wounau ha k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mamʌ mag hichcha hoo nʌmjã sĩi warag honegnaa dauderraamjö nʌm gaaimua hʌ̈k'aba narr haawai hich Jesús garmuata deeu hamag, —¿Keena, pãrau nem hinagdam k'oog chuk'u nʌwi? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Magbaawai hamachdëu hãwarrdam wai narr haawai chi p'aamdam hirig deejierram haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mag hichig deebaawai hauwia ham dak'ĩir k'öpʌ̈ijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mag hãwarrdam k'ö haaipawiata hamag, —Keena, mʌg mʌch hõrau t'õojuuta mua pãrag jaaujeejimgui hajim hanʌm, hagt'a maach hãba wënʌrraajeewaijã. Moiseeu Hẽwandam hiek p'ãtarr gaai mʌ higwia jaau simjö, hichiita hich jãg mʌch dau hap'ʌʌ hajujã jaaujeejimgui hajim hanʌm, mua pãrag. Maimua Hẽwandam hi jaaumienau p'ãtarr gaaijã jaaunaa Daviiu hẽsap Salmos hanʌm p'ãtarr gaaijã mʌ higwia hich mag p'ã sĩsid haawai, chadcha hichdëu jaautarrjöo t'um hag heyaa höbërjimgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Maimua mag hichdëu Hẽwandam hiek gaai p'ã sĩsidʌm jaautarr k'ap hamk'ĩir, hichdëupai ham pör höp'ërg hapijim hanaabá. Magbaawain chadau hi higwia Hẽwandam hiek gaai p'ã sĩsidʌmjã t'um k'ap'ʌ nʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Magnaa hamag magjim haajem hich Jesuupai: —Hich magta p'ã sim Hẽwandam hiek gaai. Maguata chadcha mʌch chi Cristo hich Hẽwandamaucha jʌr hautarr hawiajã dau hap'ʌʌ meeju haai chirajimgui hajim hanʌm. Mamʌ hĩchab k'ãai t'ãrjupam hee hiiu p'iidʌju harrjã jaau simgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mag mʌch chi Cristo hiiu p'iidʌbarm hootarr k'ʌʌnauta hamachdëu hootarr nacha Jerusalenpienag jaaunaa hĩchab durrpierram k'ʌʌnagjã jaaujugui hajim hanʌm, jãgata k'ĩirjug hajap'am jʌrbaawai Hẽwandamau hamach k'aibag chugpaaju haai sim t'umaam k'ʌʌnag k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mag pãrauta mʌ meewia hiiu p'iidʌtarrjã pãach daúacha hootarr haawai pãarta chi jaauju k'ʌʌnaugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mag jaaumamua hich Jesuucha hamag, Pari magaagan mʌgtarr k'ur jöpcha murua pãar hat'ee pʌ̈ijugui hajim hanʌm Hẽwandam Hak'aar, hich mʌ Hayaucha deeju ha jaautarr. Mamʌ mʌig Jerusalén p'öbör heepai nʌisit hajim hanʌm, mag Hak'aar bëe nʌm hora. Hʌ̃gt'armua hich Hẽwandamau pʌ̈ibapʌ̈im hedta pãar gaai p'ẽs sĩeichëjugui hajim hanʌm, pãachdëu hootarr t'umaam k'ʌʌnag jaau k'ap'ʌ jaau wënʌrramk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Maimua hãbmiecha paawai p'öbör heemua hich Jesuu ham p'ë harrjim haajem p'öbör Betania hanʌmʌg k'ʌdau ma sim hee. Mam p'öbör higaau pabaimaawai hʌ̃gt'aag jua hʌanaa Hẽwandamag jëeumamua, —Tata, puata mʌg hatagjã mʌk'ʌʌn wounaan hich jãg hʌ̈u ham p'ë wai chitajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mag ham k'ĩir honee hiek'amamua, ham dak'ĩraa hedjã baug hee hʌ̃gt'aa papagmamua, warag hoohba pamamua Hẽwandamau hich haar hʌ̃gt'ar hat'ajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mag hi hʌ̃gt'aag mam hoobaawai jẽb gaai kanieu p'õbk'anaa hirig, —Pʌjöm chan wounaan mʌg hatagjã marau hoobam. Pʌchta chadcha hãba maar Pöröu hajierram haajem. Mag jëeu durrawia, deeu Jerusalenag honee wëtjim haajem, hamachig jaautarrjö. ");
INSERT INTO noaH_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Maimua Jerusalén p'öbör hee pawiajã hich mag hed hëepierr Haai hi jëeujem deg wëtwia jëeu durraajeejim haajem.");
INSERT INTO noaH_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Warrgar bʌ̃ʌrjã nem hompaaba nʌwe Hẽwandam sim dʌ̈i chi Hiewaajã sĩejim haajem. Hich mag chi Hiewaapai hĩchab Hẽwandamau. ");
INSERT INTO noaH_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mag, hich warrgarwe Hẽwandam dʌ̈i hãba sĩerrajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hẽwandamau hi dʌ̈imuata nem t'ʌnʌmjã t'um hompaajim hanaabá. Mag hamach numiim k'ʌʌn jua haawai bʌ̃ʌrjã hirua nem wauba harr chan chuk'um. ");
INSERT INTO noaH_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hichdëuta maach hak'aarjã hiiupi haaujem. Maagwai hi gaaimuata hararag bʌ̈ʌg hoo nʌmjö maadëu k'ap'ʌ nʌm, jãga sĩerrʌ́ hich Hẽwandam chi Haaijã, mag k'ap'ʌ hapieg hich chi Hiewaata t'umaam k'ʌʌn hat'ee hõtdau paa dʌnʌmjö sĩewai. ");
INSERT INTO noaH_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mag hichdëuta hich Haai k'ap hapieg hõtdau paa dʌnʌmjö sĩewai mʌg durr hich k'aibagau sĩi hedau k'ĩejö simuajã pöd hi t'õo hauba haajem. ");
INSERT INTO noaH_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hich mag jaar hĩchab woun hãb Juan ha t'ʌ̃r sim sĩejim haajem, Hẽwandamau jʌr hautarr. ");
INSERT INTO noaH_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Maguan sĩi hich hẽudee deeum woun hãb bëejuuta jaau nʌrrajim haajem, mag wounta k'ĩchag hee hõt paa dʌnʌmjö sim ha jaaubaawai hõor t'umaam k'ʌʌnag mag hiekta hʌ̈k'amk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Hich Juan chan mag woun hichdëu bëeju ha jaau nʌrrarr k'aba, sĩi mag hõtdaujö sim bëeju jaaumk'ĩirpai jʌr hautarr hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Magtarr haawaita chadcha mag hirua jaaujerr woun hi hẽudee bëebajieb, Hẽwandam Hiewaa. Hichdëuta hich gaaimuapai t'umaam k'ʌʌnag Hẽwandam jãga sĩerrʌ́ ha k'ap hapiejem. ");
INSERT INTO noaH_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mag bëewia mʌg durr hichdëu hompaatarr gaai sĩeichëjim. Pari mʌg durr gaai jooba nʌm k'ʌʌnau hi k'aug hauba, sĩi parhoobam k'ʌʌnpii hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Hich durr gaai bëetarrta, mag hamach hee pierrumjã hõrau hi higbajierram. ");
INSERT INTO noaH_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pari hi hisegba hʌ̈u warag hi hiek hʌ̈k'a nʌmua warag hirigta hamach peerdʌpitarr k'ʌʌnan hichdëujã warag Hẽwandam chaainag paapʌ̈imajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mag hi chaaink'a nʌm chan sĩi mʌg heegarm k'ʌʌnjö chaai paarpam k'õchgau k'apese hawia paarpa hautarr k'abam. Mag hi chaaink'a nʌmʌn, sĩi Hẽwandamau hich garmuata hich hiiu haawai hich chaaink'a hau nʌmʌu. ");
INSERT INTO noaH_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mag, Hẽwandam Hiewaata wounag pawia mʌig heegar sĩeichëjim. Hichta Hẽwandam Chaai hãbpai k'itʌmuata hich hiiu haawai hich Haai hipierraa nem k'ĩir pogk'e wau nʌrrarr marau hoojim. Magta hi gaaimua marau k'ap'ʌ nʌisijim, jãga Hẽwandam chi Hayaujã maach jãsene sĩerrʌ́. ");
INSERT INTO noaH_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hi jaauwiata mag Juan hõor pör choomie k'ararrau hõrag, “Mʌ hẽudee hurumta mʌ k'ãaijã hiek t'eeg hʌ̃rpai simgui” haajeejim, hichta hi t'aabaju nawe sĩerr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hichta Hẽwandam Hiewaa maach dʌ̈i wajap'a k'itaawai maachdëu nem hig nʌmjã höo k'augbata hich mag dedee haajem. ");
INSERT INTO noaH_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hẽwandamau Moiseeg ley p'ãpiewai sĩi jãga wënʌrraju haai nʌ ha k'ap hamk'ĩirpai p'ãpijim. Pari jũrr Hẽwandamau hich Hiewaa Jesucristo päaiwai, hichta hich Chaai chaar haawai, warre hich gaaimuata hi jãga chitʌ́ ha k'ap'ʌnaa hĩchab maach hichdëu k'õsi simjã k'ap hamk'ĩirta pʌ̈ijim. ");
INSERT INTO noaH_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hãbmuajã Hẽwandam chi Haai chan bʌ̃ʌrjã hooba haajem. Pari hich chi Chaai hãbpai k'itʌmjã hich Haai dʌ̈i hãbam Hẽwandamk'anaa hi dʌ̈i hãba sĩejeewai hi hoo nʌm gaaimuata chi Haaijã warag maadëu k'ap'ʌ paauk'amam, hí jãga sĩerrʌ́. ");
INSERT INTO noaH_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mag Hẽwandamau pʌ̈iju jaaujerr bëeju hanʌm hich hẽudee hurum Juanau jaau nʌrrarr hed gaai Jerusalén p'öbör heemua judionaan chi pörk'a narr k'ʌʌnau p'adnaan pʌ̈ijierram, Levinaan ha t'ʌ̃ʌrjerr k'ʌʌn dʌ̈i, mak'ʌʌnau chi Juan haar wëtwia hirig, “¿Pʌ k'aíuma? ¿Pʌʌta nawe Hẽwandamau pʌ̈iju ha jaaujerrá?” ha k'ap jëeumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chadcha mag wëtwia hichig jëeubaimaawai Juanau hamag, —Mʌ chan nawe Hẽwandamau pʌ̈iju ha jaaujerr k'abamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Magbaawai deeu hamachdëupai, —Magan ¿pʌ k'aíuma? ¿Pʌ Elías k'abá? habaawai, jũrr hichdëu, —Mʌ chan Elías k'abamgui hajim hamag. Magbaa deeu hamachdëupai, —¿Wa pʌ warrgarwe hich Hẽwandamaucha hich hi jaaumk'ĩir jʌr hauju ha jaaujerráwa? ha jëeubaawai, jũrr hamag, —Hʌ̃hʌ̃, mʌ majã k'abamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pari magʌmjã pʌaba, —¿Pʌ k'aíuma? hajierram. Pua marag pʌch jaaubam, ¿marau k'an ha jaaubaimaagauma maach pʌ̈itarr k'ʌʌnag? hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Magbaawai Juanau hamag magjim: —Mʌʌn warrgar Hẽwandam hi jaaumie Isaías k'ararrau jaautarrjö, hajappai hõor barba haajem haar chiraajemʌugui hajim. Mʌʌn sĩi, “Maach Pör bëeimʌʌ sĩewai hi bëeju nawe pãach t'ãar k'ĩir k'augbat t'ãraucha k'õsi hi hiek hʌ̈k'aag” ha jaaujemʌugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pari mag k'ap haag hirig jëwaan bëetarr k'ʌʌnjã Moiseeu p'ã pʌarr hiek wajapcha hʌʌrk'aajerr k'ʌʌnau pʌ̈itarr k'ʌʌn hajim, fariseonaan. Maguata hamachta chi t'ierrnaan hawia hirig mag nʌrrapimap'apaim hiek'au hirig, ");
INSERT INTO noaH_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Pʌ hiek mag warrgarwe hich Hẽwandamau pʌ̈iju ha jaaujerrjã k'aba, Eliajã k'aba, Hẽwandam hi jaaujerrjã k'abam hanʌmta, magan ¿jãgwi pua hõor pör choo simma? hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Magbaawai Juanau, —Muan sĩi dödamaupaita hõor pör choo chitʌmgui hajim. Pari pãach hee woun hãb sim, hichta hich Hẽwandamaucha pʌ̈iju ha jaaujerrau. Ma hagt'a pãrau k'augba naabahab, mamʌ hi barcheewai k'ĩir k'aug naamk'ĩirta hag nawe mua hõor pör choo chitʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Maata mʌ hẽudee hurum. Mʌ chan sĩi hi chogk'a chitaagpaijã serbiiba chirʌmgui hajim, Jesús higwia. ");
INSERT INTO noaH_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mag hi k'ap haag hirig jëeuchëtarr t'um hi hiek'amarrpa döjã Jordán hanʌm higaau p'öbördam Betania hanʌm hee hajim, hich Juan k'ararrau hõor pör choo sĩerr haig. ");
INSERT INTO noaH_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mag hichig jëeuchëtarr k'ʌʌn dʌ̈i hiyʌ̈ʌ sĩerr noram Juanau hoowai, mag hirua hamag jaau sĩerr Jesuuta hi haig hur nʌrrajim. Mag hich haig hurum hoo hat'aawai hich haig narr k'ʌʌnag, —Pãadë hoobat hajim: Hẽwandamau pʌ̈itarr har hur k'itʌm. Jãguata corderodamjö hʌdʌraa hich t'õopibarmua hõor t'umaam k'ʌʌn pekau chugpaa haujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jãg higwiata norr mua pãrag, “Mʌ hẽudee hãb hurumta mʌ k'ãaijã hiek t'eeg hʌ̃rpainaa hichta mʌ k'ãyaujã warrgarwe hich mag sĩerrʌmgui” hajim Juan chi hõor pör choomieu. ");
INSERT INTO noaH_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mag jaaumamua, Mʌchdëujã k'augba chirajimgui hajim, hiita hich Hẽwandamaucha pʌ̈itarr. Pari hĩsin chad mua k'ap'ʌ chirʌmgui hajim, hich k'abahab maachdëu nʌ narr. Mamʌ mʌg maach israelnaanag hi k'ap hamk'ĩirta muan jãg hõor pör choo chitʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Maimua mag jajawagmamua, hĩchab hewag pawi hichdëu hootarr higwiajã Juan chi hõor pör choomieu, —Muan mʌch daúacha Hẽwandam Hak'aarta duburjö k'itʌmta hʌ̃gt'armua bëewia Jesús gaai jupbaichëmjã hoojimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hag nawe chan mua k'augba chirajimgui hajim, hiita warrgarwe Hẽwandamau pʌ̈iju ha jaaujerrk'a sim. Mamʌ mʌg hõor pör choomk'ĩir mʌch pʌ̈itarrauta mʌchigcha, “Har pʌch dak'ĩraa chi Hak'aar hʌ̃gt'armua bëewia woun hãb sim gaai jupbaicheewai pua k'ap'ʌ haju, mag wounauta hich Hẽwandam Hak'aarcha hõrag deemaju” ha jaautarr haawai, ");
INSERT INTO noaH_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","hĩsin chadau mua hi k'ap'ʌ chirʌmgui hajim, mag mʌchig jaautarrjö bëewi hi gaaita jupbaichëm mʌch daúacha hootarr haawai. Maguata hĩchab mua k'ap'ʌ chirʌmgui hajim Juanau Jesús higwia, hi chadchata Hẽwandam Hiewaau. ");
INSERT INTO noaH_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Maimua hag noram hagt'a mag p'öbördam Betania hanʌm haig mʌ chirajim, mʌch k'apeen dʌ̈i, maach maestro Juan k'ararrpa hãba. ");
INSERT INTO noaH_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mag maig maar nʌmta, Jesús dich nʌrrʌm hoobaawai maar maestroou, —Pãadë hoobat: Jãata Hẽwandamau pʌ̈itarrauwai hajim, corderodamjö hʌdʌraa hich t'õopibarmua hõor peerdʌ haumk'ĩir pʌ̈itarr. ");
INSERT INTO noaH_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Maach jʌ̃g daar maach maestro Juanau mag hiek'abarm hũrbaawai Jesús hẽudee maar wëtjim. ");
INSERT INTO noaH_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mag dichmamua hewag hoowai, maar hich hẽudee wëtum k'aug hat'aawai marag, —¿Pãar k'anta jʌr wënʌrrʌ́ma? hajim. Magbaawai marau jũrr hirig, —Maestro, ¿pʌ jam chiraajẽ? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Magbaawai Jesuu marag, —Magan mʌ dʌ̈i wëttarrau hajim, mʌ chiraajem haar k'augaan. Magbaa chadcha hi dʌ̈i wëtwi hi sĩerr haar maar barimajim. Mamʌ ya maagwai k'eeuragam las cuatrojö sĩerr haawai warag hich maig k'ëujim. ");
INSERT INTO noaH_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mag Juanau Jesús jaau sim hũrwia hãb hagjö mʌ dʌ̈i hẽudee matarr Andrés hajim, Simón Pedro dʌ̈i k'od hãbam. ");
INSERT INTO noaH_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mag Andrés hanʌmua hich naam Simón jʌraan mawia hoobaimaawai hirig, —Ya hĩsin chadau maran warrgarwe Hẽwandamau Mesías pʌ̈iju ha jaaujerr dʌ̈ita hoobarmgui hajim hanʌm. (Mag Mesías haawai griego meúa Cristo haawaiu.) ");
INSERT INTO noaH_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Maimua chadcha chi Simón hich dʌ̈i haibëejim, maar Jesús dʌ̈i narr haig. Mag hich haig waipierrwai Jesuu chi Simonag, —Pʌ Simón k'abahab hajim, Jonás hiewaa. Pari hĩsmua hatag pʌ Cefas ha t'ʌ̃rjugui hajim. (Mag Cefas haawai griegonaan meúa Pedro haawaiu. Mag Pedro ha sim haig mokpör haawaiu.) ");
INSERT INTO noaH_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hag noram Jesús jũrr Galilea durr maju haadëjim. Mag nʌm hee Felipe dʌ̈i hoojim. Mag hoobaawai hirig, —Felipe, mʌ dʌ̈i marrau hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Mag woundam Felipe hanʌm p'öbördam Betsaida hanʌm heem hajim, Andrés dʌ̈i Pedropa hãba naajerr p'öbör heem. ");
INSERT INTO noaH_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Maimua jũrr Felipeeu deeum woun Natanael hanʌm jʌraan mawia, hirig maguimajim haajem: —Natanael, maran ya Jesús dʌ̈ita wënʌrrʌmgui hajim hanʌm, har Nazaret p'öbör hee woun hãb José haajem hag hiewaa dʌ̈i. Hich jãg higwiata Moisés k'ararrau hẽsap p'ã pʌarr gaaijã jãg jaaunaa, Hẽwandam hi jaaumienaujã jãg jaauba haajeejieba haimajim haajem Felipeeu. ");
INSERT INTO noaH_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Magbaawai chi Natanaelau Felipeeg, —Hʌ̈k'abamgui hajim hanʌm. ¿K'aíu pʌrʌg jaauwai mag Nazaret p'öbör heemuata hõor chi t'et'emk'a höbërju ha jaaujĩ? hajim hanʌm. Mamʌ magbaawai chi Felipeeu, —Magan hoobahur hajim hanʌm, k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Magbaawai chadcha hi dʌ̈i bëejim. Mag bëewia ya hich haig pabaicheewai Jesuu hirig —Hachá k'itaichëm israel chaardam. Mʌg woundaman chadchata hö hak'aar wajap'ata chirabpama hajim hichigcha. ");
INSERT INTO noaH_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jesuu hichig mag hiek'abarm hũrbaawai Natanaelau hirig, —¿Jãga pua mag mʌ hö hak'aar hajap'a chirʌm k'ap'ʌ chirʌ́? hajim. Magbaa Jesuu hirig, —Felipeeu pʌ mawag hëeurrju nawe, har pʌch dik'u gaau higo bʌ̈ heegar sĩewai, mua pʌ hoobajieb hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Magbaa Natanaelau, —Maestro, pʌʌn chadchata Hẽwandam Hiewaau. Pʌch k'abahab hajim, israelnaan Rey marau nʌ narr. ");
INSERT INTO noaH_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Magbaa Jesuu hirig, —¿Higo bʌ̈ heegar mʌchdëu pʌch hootarr ha jaaubaawaita pua mʌrʌg mag chirʌ́? Hĩsta pua hag k'ãyaujã nem wajapcharam hoogpabahab hajim. ");
INSERT INTO noaH_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Maimua hich Jesuupai hĩchab maach t'um hich dʌ̈i k'apeerk'a haumarr k'ʌʌnag, —Mua pãrag jaauk'imgui hajim: Cha hiek'a chirʌm hiek'au chadcha mʌch chi Hemk'ooi Hiewaa haigta Hẽwandam chognaan hʌ̃gt'armua heegjã bëenaa deeu hʌ̃gt'aa waaidʌtk'ak'ak'am hoojugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Magtarr k'ur k'ãai t'ãrjup nʌm hee, Galilea durr p'öbördam Caná hanʌm hee hõor jua pʌr naajim. Maig Jesús hãdjã dʌ̈i sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mag jua pʌr nʌm hee, hich Jesujã t'ʌ̃rpʌ̈iwia haig sĩerr haawai hi hãdau hirigta, ");
INSERT INTO noaH_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","—Vino t'umaa höbaadëmwai hajim. ");
INSERT INTO noaH_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Magbaa chi chaairau hirig, —¿Pua k'ant'ee mʌrʌg mag sĩ? Mʌch nem wau chitʌm gaaimua hagt'a hõrag mʌch k'augpiju hora k'aba sĩebahab hajim hich hãdag. ");
INSERT INTO noaH_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pari hich hiewaau hichig magbaawai chi p'iejãb wau narr k'ʌʌnagta warag hich hũan Mariaau, —Hirua pãachig nem mag haawai hi hipierraa habat hajim. ");
INSERT INTO noaH_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Judionaan hamach hi haawai Hẽwandam na hamach wajap'a nʌm haag jua dʌ̈i bʌ̈pa hʌpʌ̈pʌ̈i haajeejim. Magua, magaag hat'ee döjã hiigjerr haawai mag p'iesta hee t'ũr mokdau dën dʌ̈rrcha k'it'ëem seis wai naajim. Mak'ʌʌn t'ũr hee de cincuenta a setenta litros dʌ̈rr haajeejim, dö. ");
INSERT INTO noaH_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Maimua Jesuu mag chi p'iejãb wau narr k'ʌʌnag mak'ʌʌn t'ũr döou hipiirk'api jaaujim. Mag chadcha hich hipierr hipiirk'abapäaiwai hamag, ");
INSERT INTO noaH_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","—Jãimua hag heem jöi harrwia chi p'iesta hee nʌm k'ʌʌn pörk'a simʌg dö hoopibamit hajim. Magbaa chadcha hichdëu jaautarrjö hi hipierr dö hoopijierram. ");
INSERT INTO noaH_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pari mag chi p'iesta hee nʌm k'ʌʌn pöröu mag dö hatarrta vinoog paa simjã k'augbata dö sĩejim. Hãba chi p'iejãb wau narr k'ʌʌnaupaita k'ap'ʌ naajim, hamach dak'ĩir harr haawai. Mag dö hoowi chi pörk'a sĩerrau chi jua pʌr chirarr woundam t'ʌ̃r hauwi ");
INSERT INTO noaH_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","hirig magjim: —T'umaam k'ʌʌnau vino chi wajapcharamta nacha hõrag jiigjerram; maimua mag dö nʌʌ hawiata jũrr parhoobam vino jiigjerramgui hajim. Pari pua magba hewaata chi wajapcharam jigaagpamgui hajim hirig, mag dö hatarrta vinoog paa simjã k'augba. ");
INSERT INTO noaH_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mag Galilea durr p'öbördam Caná hanʌm hee dö vinoog paatarrta warrpem hõrau nem hooba haajem Jesuu wautarr hajim, mag wau sim gaaimua hich jua t'eeg hoopieg. Mag, maach hi dʌ̈i wënʌrraajerr k'ʌʌnaujã warag wajapcha hi k'ap'ʌ nʌisijim, chadcha Hẽwandamau warrgarwe pʌ̈iju ha jaaujerr dʌ̈ita maach wënʌrrʌm. Magta marau warag hi hiek hʌ̈k'a nʌisijim. ");
INSERT INTO noaH_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Maimua magtarr k'ur hich hag Galilea durr heepai deeum p'öbördam Capernaum hanʌmʌg maar p'ë harrjim, hich hãd dʌ̈i hich heeugpeenpa. Mag p'öbördam hee k'ãaidam k'apanaa maar naaimajim. ");
INSERT INTO noaH_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judionaan p'iesta Pascua haajem burrju gayaa harr haawai Jesús Jerusalenag majim. ");
INSERT INTO noaH_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Maimua hirua hooimaawai, Haai hi jëeujem degta sĩi p'akjã përnaa, ovejajã përnaa, duburjã përnaa maimua sĩi hõrag p'atk'on cambie nʌm k'ʌʌnpata hohood t'ʌnʌm hooimajim. ");
INSERT INTO noaH_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hichdëu mag hoobaimaawai maar dak'ĩraa haig jʌ̃gad werba sĩsid harr jãaupʌrnaa hagua bobojog t'um hamach p'ak dʌ̈i ovejapa dawag jʌrk'ʌʌipʌ̈ijim. Magnaa chi p'atk'on cambie narr k'ʌʌn mesjã jẽk'ʌt sĩek'ʌʌipʌ̈pʌ̈i k'abaadeewai ham p'atk'onjã sĩi parhooba k'uyiupʌ̈imajim. ");
INSERT INTO noaH_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Magnaa chi dubur për narr k'ʌʌnag, —Jöpk'aa pãach nemchaain mʌigmua p'ë hat'aadët; mʌ Haai di chan sĩi pãrau merrkaúg paapäaig k'abamgui hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hirua mag hiek'abaawai maar k'ĩir hee dʌhnʌisijim, Hẽwandam hiek p'ã sim gaai, “Hẽwandam, pʌrʌg jëeujem di kõitan mʌʌn nem haneeme chitaawai hag gaaimua mʌʌn hõor jua hãwatab k'aba hãwatju” ha p'ã sim. ");
INSERT INTO noaH_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mag hamach dak'ĩir dawag hõor jʌrk'ʌʌibapʌ̈im hoobaawai judionaan chi pörnaanau hirig, —Pʌchdëu Hẽwandam di kõit jãg chirʌpí, pʌ hiek mag pʌʌta Hẽwandamau warrgarwe pʌ̈iju ha jaaujerr hanaawai magan maar dak'ĩir hag na marau nem hooba haajem hich Hẽwandam dënjö waubá hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Magbaawai hich Jesuu warag hamag, —Pãrau magta hoom k'õsi nʌm k'ai, magan mʌg di chʌyëubapʌ̈it; magbaa k'ãai t'ãrjup nʌm hee mua deeu hëu dʌnʌʌujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Magbaawai chi judionaanau hirig, —Mʌg Haai hi jëeujem di hëu hawaag cuarenta y seis años p'idk'atarrta, ¿puata mag k'ãai t'ãrjuppaim hee deeu hëu dʌnʌʌujũu? hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pari Jesuu mag hamag di ha simjã chi di chaar higwia k'aba, hich mor higwiata mag sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hi mag hiek'atarr haawaita, hamau hi t'õowia deeu hiiu p'iidʌtarr k'urjã maach chi hi dʌ̈i hogdʌba wënʌrrarr k'ʌʌnaun hi hiek'atarr k'ĩir heyaa naajim. Mag warag warrgarwe Hẽwandam hiek p'ã sĩsidʌm gaai Jesús higwia p'ã sĩsidʌmjã wajapcha k'ap'ʌnaa hich Jesuu hich hiiucha maachig nem jaaujerrjã warag marau k'ap'ʌ nʌisijim. ");
INSERT INTO noaH_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mag Jerusalenag mawia ham p'iesta Pascua hee simua hich hiiu haawai hag na hõrau nem hooba haajempa wautarr hoowia hõor k'apanaam k'ʌʌnau hi hiek hʌ̈k'ajierram. ");
INSERT INTO noaH_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pari mag hõrau hich hiek hʌ̈k'a nʌm hanʌmjã hichdëu wajap'a k'ap'ʌ sĩejim, hõrau chadcha t'ãraucha hich hiek hʌ̈k'aba nʌm. ");
INSERT INTO noaH_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pari mag k'aug haumamjã hõrau hichig jaaubamta sĩi hichdëupaita hõor t'umaam k'ʌʌn t'ãar k'aug haumaajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Woun hãb sĩejim, Moiseeu Hẽwandam hiek p'ã pʌatarr wajapcha hʌʌrk'aajem k'ʌʌn heem, Nicodemo ha t'ʌ̃r sĩerr. Maan judionaan heem chi t'et'em hajim hĩchab. ");
INSERT INTO noaH_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mag wounau hedaar Jesús haig bëewia hirig, —Maestro, marau k'ap'ʌ nʌmgui hajim, chadcha Hẽwandamauta pʌ pʌ̈ijim, hich hiek marag jaaumk'ĩir. Hí pʌ dʌ̈i sĩewai merag chuk'u simgui hajim, jãg hag na hõrau nem hooba haajempa pʌchdëu wau sim gaaimua. Magba haawai ni hãbmuajã jãg pua nem wau simjö wauba nʌmgui hajim. Magua mʌ pʌ haigta bëejimgui hajim, Hẽwandam chi Pörk'a sim haar jãga mʌ hi dʌ̈i chirsiju mʌchig k'ap jaaumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Magbaawai Jesuu hirig, —Pʌdë hũrbarí, mua pʌrʌg jaauk'imgui hajim: Chi deeu heeupemjö t'aababa sim chan pöd Hẽwandam hichta chi Pörk'a sim haar höbërbamgui hajim, hi chaai k'aba sĩewai. ");
INSERT INTO noaH_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Magbaawai Nicodemoou hirig jëeumamua, —¿Pari jãga ya mʌg maach chi jöoi chirʌm deeu t'aababarju? hajim. ¿Wa deeuta dich hãd bi hee dubju haai sĩwa hajim, hũwaai t'aababaag? ");
INSERT INTO noaH_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Magbaawai jũrr Jesuu deeu hũwaai, —Hʌ̃hʌ̃, mua chan sĩi t'aabaa chaar t'aaba nʌm jaauba chirʌmgui hajim. Mua mag heeupemjö t'aabaju ha chirʌmʌn, Juanau pör choo simua jaaujerrjö Hẽwandam Hak'arag dich k'ĩirjug chi hiiurig paapʌ̈ipi nʌmta jaau chirʌmgui hajim. Magbam chan pöd Hẽwandam sim haar höbërbam, hagt'a hi dën k'aba sĩewai. ");
INSERT INTO noaH_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maach hãdau maach t'aaba nʌmʌn sĩi mʌig heegarpai wënʌrraagau. Pari Hẽwandam Hak'aar hau nʌmuata deeu t'aababarmjö nʌmʌn chadau jũrr hʌ̃gt'ar pawiajã hich mag wënʌrraagau hajim. ");
INSERT INTO noaH_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pari mua mag pãach t'umaam k'ʌʌnta deeu t'aabaju haai nʌm ha chirʌm hũrwia hoob hatcha jʌ̃gderraa hamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hẽwandam Hak'aar hau nʌmʌn p'ũ wë t'ʌnʌmjöta simgui hajim. P'ũun parhooba hich wëm haig nem t'eeg juu hurum hũurjem, pari pöd k'augba haajem, jammuata hurú wa jamagta ma. Hich hagjöta simgui hajim, Hẽwandam Hak'aarjã hõor hee sĩeicheewai. Chi Hak'aar bʌ̃ʌrjã hooba nʌm, pari mag simuata hich hiiu haawai heeu t'aababarmjö maach k'ĩirjug chi hiiurig paapäaijemgui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Magbaawai deeu hich Nicodemooupai Jesuug, —Pua mag sim haig, ¿jãga haawaiuma? hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Magbaawai Jesuu hirig magjim: —¿Pʌʌta israelnaan hee maestro haawai hõrau hiigjemta mʌg mua Hẽwandam Hak'arauta k'ĩirjug hajaug paapäaijem jaau chirʌmjã k'augbata chirab? ");
INSERT INTO noaH_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pʌdë hũrbarí, pʌrʌg jaauk'imgui hajim: Maraun chadcha maachdëu k'ap'ʌm nemta jaaunaa maach daúacha hootarrta jaaujem, mamʌ pãrau hʌ̈k'amap'a nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Magnaa hirig, Mʌig heegarm nemdampai mua jaau chirʌmjã pãrau hʌ̈k'amap'a nʌm, ¿jãga hʌ̈k'aagauma hajim, ya Hẽwandam k'ĩirjugcha mua pãachig jaaubaadeewai? ");
INSERT INTO noaH_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Hagt'a hiwiir hãbjã hʌ̃gt'ar Hẽwandam sim haar maba sim, hi k'ĩirjug k'ap haag; hãba hi haarmua bëetarr wounaupaita Hẽwandam k'ĩirjugan k'ap'ʌ simgui hajim, hõrag jawaag; wajapcharan mʌch chi Hemk'ooi Hiewaama. Mʌch k'abahab hajim, Hẽwandam haarmua bëetarr haawai deeu hi haar maju. ");
INSERT INTO noaH_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pari magaag hat'eyan, israelnaan hõor maba haajem hee jãg Moiseeu p'ë wai nʌrraawai Hẽwandamau hirig bronce dën nemk'õrk'a waunaa pa gaai hʌ̃gt'aa jiirjoppi jaautarrjö, hich hagjöta hĩchab mʌch chi Hemk'ooi Hiewaajã pa gaai jiirjopju haai chirʌmgui hajim, magbarmua hõor peerdʌju hayaa hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wajapcharan mag nemk'õrk'a wau sim pa gaai jiir wëjorragta hoobaawai monaaujerrjö, chi mʌrʌgta hich peerdʌ haupi sim k'ʌʌn peerdʌwia Hẽwandam haarcha höbërwia hich mag hiiu sĩerrajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Pari magaagta Hẽwandamau hoowai mʌg durr gaaim k'ʌʌn t'um ya chi hok'oomta nʌm k'ap'ʌ harr haawai, hich garmuata ham peerdʌ haum k'õchgau mʌ hich Hiewaa hãbpai k'itʌmta ham kõit t'õmk'ĩir pʌ̈ijimgui hajim, magbarm gaaimua chi mʌrʌgta hamach peerdʌ haupi nʌm k'ʌʌn chan hok'ooba, mʌig heegarwejã hich dënk'anaa hich haar höbërwia hich mag hich dʌ̈i wënʌrramk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hẽwandamau mʌ pʌ̈itarr chan, sĩi hõor k'aibag waupi jaaumk'ĩir k'aba, sĩi ham peerdʌ haumk'ĩirta mʌ pʌ̈ijimgui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Mʌch chi Hẽwandam Hiewaa hiekta hʌ̈k'anaa mʌ hig sim woun chan Hẽwandamau hisegwia k'ĩmie durr barpʌ̈ibam. Pari har mʌ higba sim chan ya sĩi barpʌ̈ijupaita simgui hajim, hichdëu Hẽwandam Hiewaa mʌchta hãbpai chitʌmta higba harr gaaimua hichdëupaita wir haig hich hisegpi jaau simjö sĩewai. ");
INSERT INTO noaH_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mag hamachdëupai wir haig hamach hisegpimjö nʌmʌn, nem k'aigbamta waum k'õchgau Hẽwandam Hiewaa higba nʌm gaaimuau. Hamach mag nʌm gaaimuata mag hõor peerdʌ hawaag hõtdau paa dʌnʌmjö chirʌm bëewaijã mʌ higba nʌmgui hajim, hich mag k'ĩchag heeta meraa nem wau nʌmjö naam k'õchgau. ");
INSERT INTO noaH_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maguata har t'um Hẽwandam dau na nem k'aigba wau nʌm k'ʌʌnan jũrr mag hõtdau paa dʌnʌmjö chirʌmta hoomap'a haajemgui hajim. Mag mʌ hoomap'a naawaita mʌ higjã higba nʌm, mag hamach meraa nem wau nʌm k'augam hugua hawia. ");
INSERT INTO noaH_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pari magba har jũrr nem wajap'am happai waum k'õsi haajem k'ʌʌnau chan mʌ hisegba, warag mag hõtdau paa dʌnʌmjö chirʌmta hiigjerramgui hajim, Hẽwandamau k'õsi simjöta nem hagcha wauju k'ap'ʌnaa hamachdëu mag wajap'a nem wau nʌm bigaaum k'ʌʌnagjã k'ap hamk'ĩir. Magta Jesuu Nicodemoog, jãga Hẽwandamta chi Pörk'a sim haar hijã chiraimaju haai chirʌ́ ha jaaujim. ");
INSERT INTO noaH_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mag p'iesta Pascua dichtarr k'ur Jesuu maar p'ë harrjim Jerusalenmua chawag, hich hag Judea durr heepai. Maig nʌmua hõor pör choojeejim. ");
INSERT INTO noaH_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Hich mag jaar hĩchab Juanaujã hagt'a hõor pör choo nʌrrajim haajem, maagwaiwe chan hagt'a hi cárcel deg pʌ̈iba narr haawai. Mag hi hõor pör choo sĩerr haig Enón ha t'ʌ̃r sim, Salim dak'a. Maigta dödam nap'ʌ k'ërarr haawai hõor pör choojeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pari hõrau jaauwai mag nʌm hee hĩchab hãaur Juan dʌ̈i wënʌrraajerr k'ʌʌn garmua jũrr judío hãb haig sĩerr dʌ̈i chik'am hipeer hahauk'amua, “Magan ¿k'aíu pör choobarmta wajapcha sĩ, Jesuu pör choobarm wa maar maestroou choobarmwa?” hanaajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mag hijẽjẽb nʌʌ hawia warag hich Juan haarcha wëtwia hichigcha, —Maestro, har chum Jordán higaau hedau höbeerjem higar, pʌchdëucha marag jaauwai Hẽwandamau pʌ̈itarr ha sĩerr wounaujã hĩchab hõor pör choo nʌrrʌm haajemgui hajim hanʌm. Maagwai hõor pöm hʌ̃rcha hi haarta p'ẽp'ẽeuk'am haimajierram haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Magbaawai Juanau hamag, —Hoob hiekk'õr waumiet hajim hanʌm. Hẽwandamauta hichdëu k'ap hõrag jaauba haajeeb, hichdëu k'õsi simjöta nem waumk'ĩir. Mag sĩewai hichdëuta juau hirig jãgpi sĩebahab hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pãach jʌ̃gʌucha k'abá pãrau hũr naajimgui hajim hanʌm, har mua “Mʌ chan warrgarwe hich Hẽwandamau pʌ̈iju ha jaaujerr k'aba, sĩi hi bëeju na hi jaau chitʌmʌu” ha chiraawai. Magua mag hi haarta hʌ̃rcha hõor p'ẽp'ẽeu hawiajã mʌ honee chirʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pãrau hooba haajẽ hajim hanʌm, jua pʌr nʌm k'ʌʌnjã: chi hʌʌi dʌ̈i nawe hiek deewi simta chi jayau; pari chi mag heeu pa nʌm k'ʌʌn paairink'a sim dʌ̈i ham bigaau simjã hĩchab honee haajem. Maarjã hich hagjöta naabahab Jesús dʌ̈i. Hi jãg sim haig woun hãb heeu hʌʌi hau simjöta sĩebahab. Magua hamau jãg hi haarta p'ẽp'ẽeuk'am haig, mʌjã dʌ̈i hĩchab honee chirʌmgui hajim hanʌm, sĩi hõrag hi jaau chitʌmua. ");
INSERT INTO noaH_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Hiita mʌ k'ãaijã warag t'ʌ̃rp'öo pamaawai mʌ jũrr hi k'ãai heeg papagmam; pari mag nʌm haig hʌ̈u sim ha hiek'amajim haajem, hich chi hõor pör choomieu Jesús higwi. ");
INSERT INTO noaH_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Maimua mag hiek'amamua hich Juan chi pör choomieupai Jesús higwia, ’Hiita hʌ̃gt'armuacha bëetarr haawai hichta chadcha maach t'umaam k'ʌʌn k'ãyaujã hʌ̃rʌʌcha sĩebahab hajim hanʌm. Pari mʌ magba sĩi pãachjö mʌig heegarmpai haawai mʌg heegarm k'ʌʌn dënjöpaita jaau chirʌmgui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mamʌ hirua magba, mʌ k'ãaijã hʌ̃gt'armta hichdëucha hoowia hichdëucha hũrtarrta jaau sĩebahab hajim hanʌm Jesús higwia. Mamʌ magʌmjã k'apancha k'aba nʌm hi hiek hʌ̈k'a durrum k'ʌʌn. ");
INSERT INTO noaH_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pari har hʌ̈u hi hiek hʌ̈k'a durrum k'ʌʌnaun mag hʌ̈k'a nʌmua, “Hẽwandamaun chadchata hiek'a sĩerrʌm” hanʌm k'abahab hajim hanʌm, Jesús higwia hi Hiewaa ha hiek'aawai. ");
INSERT INTO noaH_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Hí chadcha hich Hẽwandamauchata pʌ̈itarr haawai hich Hẽwandam k'ĩirjugta jaau simgui hajim hanʌm, magamk'ĩirta hirig hich Hak'aarjã p'ẽs dee sĩewai. ");
INSERT INTO noaH_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chi Hayaujã hich Chaai jãsene wai sĩewai nem t'ʌnʌmjã t'um hãba hirigta jaaubajieb. ");
INSERT INTO noaH_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Magtarr haawai chadcha chi Hẽwandam Hiewaagta hich peerdʌ haupi sim k'ʌʌn mʌg heegarwejã ya hich dënk'a sĩsimgui hajim hanʌm, hi haar höbërwia hi dʌ̈i hich mag nʌrraag. Pari Hẽwandam Hiewaa hiekta hʌ̈k'aba habarm chan hi haarjã höbërba, warag hi gaaita Hẽwandamau hich k'ĩir machag meeupʌ̈ijugui hajim haajem, hich Juanau hich dʌ̈i wënʌrraajerr k'ʌʌnag. Magta Juan chi hõor pör choomieu Jesús t'ö hiek'amajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mag Juan chi hõor pör choomie dak'a maach Pör Jesujã sĩerr haawai fariseonaanau k'aug hat'ajierram, Juan haar maju k'ãai hʌ̃rcha Jesús hẽudeeta hõor pos haadëp'ʌm. Mag nʌm dʌ̈i hĩchab k'aug hat'ajierram, Juan haram k'ãyaujã hʌ̃rcha Jesuugta hõrau hamach pör choopi nʌm. ");
INSERT INTO noaH_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mamʌ wajapcharan hich Jesuujã chooba, maach hi dʌ̈i wënʌrraajerr k'ʌʌnauta hõran pör choojeejim. ");
INSERT INTO noaH_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mag, fariseonaanau Jesús haarta hʌ̃rcha hõor poposk'am k'ap'ʌ hap'öbaadëm hich Jesuujã k'aug hat'aawai Judea durrmua jũrr hichta warag Galileaag petajim. Magbaawai maar hi dʌ̈i wëtjim. ");
INSERT INTO noaH_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mag wëtumua hichiita Samaria durr dichab k'aba dichju hajim. ");
INSERT INTO noaH_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mag wëtmaa hawia hich Samaria durrpai p'öbördam Sicar ha t'ʌ̃r sĩerr haig maar barjim, jöoi Jacob k'ararrau jẽb për hauwia hich meebaadeewai hich hiewaa José haajerrag werpʌatarr dak'a. ");
INSERT INTO noaH_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mag jẽb hich chaairag werpʌatarr gaai posjã sĩejim, hich jöoi Jacob k'ararrau k'örpitarr pos. Mag wënʌrrʌmua hich Jesús ya k'ajeeu sĩerr haawai mag pos haar mawia hag hi dak'a jupimajim. Maagwai ya hedausĩe paimʌʌ sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mag nʌm hee maar p'öbör hee wëtjim, maach hat'ee k'öju për hawaan. Mag maar hërëubaadeewai Jesús hich happai hoo chirʌm heeta, hi hiek Samariapie hʌʌi hãb mag pos heem dö jöyaan bëejim haajem. Mag hich haig pierrwaita hirua, —Mʌrʌg bʌchk'un dödam doog jöi deebá ha chirajim haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mamʌ judionaan Samariapien dʌ̈i dau parii hiyʌ̈ʌ haba haajerr haawai, mag hichig dö jëeubaawai chi hʌʌirau hirig magjim haajem: —Pãar judionaan chan maar Samariapien dʌ̈i hiek'ajã map'a haajem k'ʌʌnta, ¿k'ant'ee pua mʌrʌg dö jëeu sĩwi? hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Magbaawai jũrr Jesuu hirig, —Hẽwandamau pʌch hat'ee nem deeg wai sim k'ap'ʌnaa k'aíuta pʌchig dö jëeu simjã k'ap'ʌ hak'iin, pʌch garmuata pua mʌrʌg dö jëeuk'amgui hajim hanʌm. Magbaawai mua pʌrʌg hõor hiiupiejem döota deek'amgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Hichig magbaawai jũrr chi hʌʌi garmua, —Señor, pari pua chi jöi haujujã chuk'u sim, mʌg pos jã naug sim heem pua pöd jöi haubamgui hajim hanʌm. ¿Jamaam dö mag maach hiiupiejem hanʌm mʌrʌg deeg hagá? ");
INSERT INTO noaH_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Jam pua mʌiguim k'ãaijã dö wajapcharam bawaag hagá? hajim hanaabá. Nachgarwe maar jöoi Jacob k'ararrauta mʌg pos marag werpʌajim. Hag heem hichdëujã döwia, hi chaainaujã döwia, hi nemchaainaujã döjierram. Magtarrta, ¿pua hag k'ãyaujã wajapcharam dö hig chirʌ́? hajim hanʌm. ¿Wa pʌʌta hi k'ãaijã hʌ̃rpai chirʌ́wa hajim haajem, mʌg k'ãai dö wajapcharam bawaag? ");
INSERT INTO noaH_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Magbaawaita Jesuu hirig magjim haajem: —Cha mʌ hiek'a chirʌm hiek'au, mʌg pos heem dö dö nʌm k'ʌʌnan t'um hichiita deeu höbisi hap'öbaadeewai hũwaai dö döm k'õsi hajugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pari mua dee chirʌm dö k'ĩirta dö nʌm k'ʌʌn chan bʌ̃ʌrjã höbichag chuk'u hich mag wënʌrraju. Mag hamachdëu döbarmpaita ham mor hee hich mag k'umdʌ höbër sĩsimjö sĩejugui hajim haajem, hich mag Hẽwandam dënk'a nʌisieg. ");
INSERT INTO noaH_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Magbaawai jũrr chi hʌʌi garmua, —Señor, magan mag dö k'ĩir mʌrʌg deebá hajim hanʌm, tag höbichag k'augba haadeewai mʌg pos heem döjã jöyaan bëeba haag. ");
INSERT INTO noaH_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Magbaawaita Jesuu, —Magan pʌch jaai hat'amí ha hajim hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Magbaa chi hʌʌirau, —Mʌ chan jaai chuk'u hʌmgui hajim hanʌm. Mag jaai chuk'u hʌm habaawai Jesuu hirig, —Pʌchigan pʌ jaai chuk'u hʌabma hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pʌ jaai haum cinco hauwia sim. Maimua cha pʌchdëu wai simjãh, magan jã chan pʌ jaai k'abahabma. Pʌʌn chadcha wajap'a k'ĩirjunaata hiek'a hʌmgui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mag hich höbeerbapʌ̈im hũrbaawaita hirig, —Mua hoowai pʌjã dau bʌ̃ʌmjöta simgui hajim hanʌm, mʌ mag hʌrrʌm k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maimua hichdëupai, Maar jöoin Samariapienaun mʌg Gerasim durr gaaita Hẽwandamag jëeujeejimgui hajim haajem chi durrsĩig jua hʌanaa. Pari pãar judionaan hiek mag hãba Jerusalenam Haai hi jëeujem degpaita Hẽwandamag jëeuju haai nʌm haajem. Pua hoowai, ¿jamta chadcha hirig jëeuju haai nʌwi? ha jëeujim haajem hirig. ");
INSERT INTO noaH_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Magbaawai Jesuu hirig, —Pʌdë mʌ hiek hũrbarí hajim hanʌm: Ya mʌg hatag paawai pãrau k'ĩirjubaju, mʌg durrsĩ gaaita Hẽwandamag jëeuju wa Jerusalén mawiata Hẽwandamag jëeuju. Magbarm haigmua parhooba pãach nʌm haigmua hirig jëeuju haai hap'öbaadëjugui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pãar Samariapienau chan Hẽwandamag jëeu nʌm hanʌmjã wajap hi k'augba nʌmta hirig jëeujem. Pari maar judionaanaun chadau, maach meeun heem hãb höbërbarm gaaimuata Hẽwandamau hõor peerdʌtk'aju k'ap'ʌ naawai, hirigta jëeujemgui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pari hĩs hirig jëeu chaar jëeu nʌm k'ʌʌnaun mʌg hatag paawai warag Hẽwandam Hak'arau k'õsi simjö jëeujugui hajim hanʌm, ya hamau Hẽwandam jãga sĩerrʌ́ ha k'ap'ʌ naawai. Hichig mag jëeu nʌm k'ʌʌnta hich Hẽwandamaujã hiigjemgui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hẽwandam chan maachjö mʌg mor chuk'u sim, Hak'aar haawai. Maguata hʌ̈k'aa chaar hʌ̈k'a nʌmuata hich Hẽwandam Hak'arau k'õsi simjöta hirig jëeuju haai naabahab ha chirajim haajem chi hʌʌirag. ");
INSERT INTO noaH_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Magbaawai jũrr chi hʌʌirau hirig, —Hʌ̃ʌjʌ̃, mua k'ap'ʌ hʌmgui hajim hanʌm, Cristo hanʌm bëeju, warrgarwe hich Hẽwandamau pʌ̈iju ha jaaujerr. Mag hich pierrum hedta hichdëucha t'umaa wajap'a jaauchëjugui hajim hanʌm, jãga sĩerrʌ́ Hẽwandam. ");
INSERT INTO noaH_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Magbaawai, —Mʌʌta hag Cristo warrgarwe hich Hẽwandamau pʌ̈iju ha jaaujerr k'abahab; hich hag wounta hĩs pʌ dʌ̈i hiyʌ̈ʌ chirabahab hajim hanʌm Jesuu, warre hich jaauwia. ");
INSERT INTO noaH_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ham mag hiyʌ̈ʌ nʌm heeta maar bardʌtk'achëjim. Maimua mag Samariapie hʌʌi dʌ̈ita hiyʌ̈ʌ nʌm hoobaicheewai chadcha maar dauderraa naajim. Pari magʌmjã hãbmuajã hirig, “¿Pʌ k'anta hirig jëeu sĩ, wa k'an hata pãar hiyʌ̈ʌ naajĩjã?” habajim. ");
INSERT INTO noaH_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mag Jesuu hichig, “Mʌʌta Hẽwandamau pʌ̈iju ha jaaujerr k'abahab” habaawai, hich döt'ũr werpʌawia p'öbörög k'ap'igbaadëjim. Mag mawia barwia hõrag, ");
INSERT INTO noaH_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Mau mʌ daupierr hoobahut'ʌ̃ hajim hanʌm, pos haar woun hãb simua, mua hichigjã jaauba harrta, mua nem waaujem t'umaa k'ap'ʌ mʌrʌg jaaubarm. Mua k'ĩirjuawai, jãata warrgarwe Hẽwandamau pʌ̈iju ha jaaujerrjöo simgui haimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mag chi hʌʌirau hamach haar jaaubaimaawai chadcha p'öbör heem k'ʌʌnaujã Jesús hoon wëtju hap'öbaadëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pari mag chi hʌʌi p'öbör hee nʌrrʌmich, ya maar deeu hi haig paauk'achëwi narr haawai marau hirig, —Maestro, t'achdam k'ö hat'á haajeejim. Pari mag hichig t'ach k'öpi jaaubaawai jũrr, ");
INSERT INTO noaH_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Mʌ t'ach k'öju wai chirabahab, pari mag t'ach k'ĩir pãrau k'augba nʌmgui hajim hichdëu. ");
INSERT INTO noaH_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Warag maachig magbaawai jũrr, —¿Wa hãbmua hi hat'ee t'ach k'ömk'ĩir deet'urtarr haawaita mag sĩwa? haajeejim marau. ");
INSERT INTO noaH_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pari maar mag hiek'a nʌm hũrbaawai Jesuu marag, —Mua mag t'ach k'öju wai chirʌm ha chirʌmʌn, Hẽwandamauta mʌ pʌ̈itarr haawai hirua k'õsi simjöta nem wau chirʌmʌugui hajim, mʌchig p'idag jaaupʌ̈itarr t'umaa höpʌ̈yaag. ");
INSERT INTO noaH_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pãrau nemjĩir p'ierraag hagt'a hed jayap waaur nʌm haajeebma. Pari mua jũrr pãrag, pãach bigaau hõor pöm trigo p'ur wëjömjö t'ʌnʌmta hoobat ha chirʌm. Jãg trigo p'ur wëjöm hapuraa heeujemjö, jãk'ʌʌnagta Hẽwandam hiek jaaubat ha chirʌmgui hajim, hamag hʌ̈k'amk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hõor jãg t'ʌnʌmʌg Hẽwandam hiek jaau nʌmta nemjĩir p'ierr nʌmjö p'idk'a nʌm k'ʌʌnag chan Hẽwandamau p'agab k'aba p'agjugui hajim. Mag hamau hi hat'ee hõor gan haumam k'ʌʌnan hich mag hi dʌ̈i wënʌrraagau. Ya mag nʌisim haig chi nacha hi hiek jaautarrjã honee hawia hẽudee jaaumamua hʌ̈k'api hat'am k'ʌʌnjã chi nacha jaautarr dʌ̈i hãba honee hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Har hõrau, “Chi nemjĩir jĩir simuan sĩi jĩirmam, pari k'ar chan pöd hichdëupai heeuba haajem” haawain chadcharauwai hajim. ");
INSERT INTO noaH_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Hiin chadcha deeum k'ʌʌnauta nacha chi p'idagan hëudʌ haujierram; pari magtarrta jũrr pãachta ham p'idag gaaimua wajapcha haju. Pãach chi bʌ̃ʌrjã p'it'urg hauba narrta nemjĩir p'ierramk'ĩirjöta mua pãar pʌ̈i chirʌm ha jaaumajim marag, maachdëu hich hiek jaau wënʌrrʌmua hõrag hʌ̈k'api haumaju higwia. ");
INSERT INTO noaH_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mag chadcha hʌʌi dö jöyaan k'itawia, “Jesuu bʌ̃ʌrjã hichig jaaubamta mua nem waaujem t'umaa k'aug hat'ajim” ha jaaubaimaawai, mag Samaria durr p'öbördam sĩerr hee hõor k'apank'am k'ʌʌnauta hi hiek hʌ̈k'a nʌm hiek'au, “Magan chadcha hich Hẽwandamaucha pʌ̈iju haajerrau” hawia chi Jesús hoon bëejierram. ");
INSERT INTO noaH_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Maimua chadcha mag bëewi chi Jesús haig barchëjierram, chi p'öbör heemua bëetarr k'ʌʌn. Mag hi haig paauk'achëwia hirig, —Mʌig maar haig k'ãibajë hajierram. Hichig magbaawai chadcha t'ʌbawia k'ãai numí sĩejim ham p'öbör hee. ");
INSERT INTO noaH_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mag k'ãai numiim hee hichdëucha jaau sim hũrwia, warag k'apanaacharam k'ʌʌnauta hi hiek hʌ̈k'ajierram. ");
INSERT INTO noaH_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mag hamachdëucha Jesuu jaau sim hũrwia hʌ̈k'atarr k'ʌʌnau chi hʌʌirag, —Ya hĩs chan sĩi pua jaau sim hũrwiapai k'aba, maach jʌ̃gʌucha hi hiek hũrwiata marau hʌ̈k'a nʌmgui haajeejim. Ya chadcha marau k'ap'ʌ nʌm, jãguata chadcha durrpierr hich hiek hʌ̈k'a nʌm k'ʌʌn t'um peerdʌ hauju k'abahab haajeejim jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Jesús mag Jerusalenmua mawi, Samaria p'öbördam hee k'ãai numí sĩeimawi, warag hich maa harrag petajim, Galileaag. Mamʌ mag p'iesta dichtarr k'ur Jerusalén t'ʌbaba harran, hag na hichdëu hiek'atarrjö, chi Hẽwandam hiek jaaujem k'ʌʌn chan hãbjã hamach durr hee hãba naajem k'ʌʌnaupaijã k'a k'õchk'aba haajeewai hajim. Magta hich t'aabatarr durrmua warag Galileaag petajim, hich bãautarr durr. ");
INSERT INTO noaH_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mag maa hawia Galilea durr barbaimaawai, mamaam k'ʌʌnau hʌ̈u hi wajap'a hamach hee barpijierram, hi dʌ̈i hãba Jerusalén p'iesta Pascua hanʌm hee naawai hirua nem wautarrjã t'um hamach daúa hoo narr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mag Galilea durr paimawia deeu Canaag majim, hag na hichdëu dö hatarrta vinoog paatarr p'öbörög. Maagwai hĩchab Capernaum p'öbör hee sĩejim woun hãb rey dʌ̈i p'idk'aajem, chi t'et'em. Mag dën chaai mor mas sĩejim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mag chi t'et'emua Jesús Judeamua bëewia jũrr Galilea barbaichëm ha hũrbaawai hi haar mawia hirig chaigpamamua, —Mʌ chaai ya pödba k'ërʌmta hoo pʌajim; mʌ hap chitʌm mʌ di haar marrau haichëjim, mʌ chaai monaaupäain. ");
INSERT INTO noaH_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pari magbaawai Jesuu hirig, —Pãrau chan pãach daúacha hag na hõrau nem hooba haajem wau nʌm hoobam haigjã Hẽwandam jua t'eeg mʌ gaai sim hʌ̈k'aba sĩerrjëemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pari magbaawai chi t'et'em garmua warag hirig, —Señor, mʌ hap chitʌm jöpai mʌ chaai hoomierrau, meeju nawe. Ya parba k'ërʌmta mua hoo pʌabajieb hajim. ");
INSERT INTO noaH_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Magbaa, —Hoob hatcha k'ĩirjum, pʌ chaaidam nauwe monaaubajup hajim Jesuu. Hichig magbaawai hich chaai meejujã k'ĩirjuba, Jesuu hich chaai monaaupʌ̈ijuuta hãba k'ĩirjumamua hich diig petajim. ");
INSERT INTO noaH_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mag hich diig mam hee hi chognaan hi k'ĩirp'ee bëewia hi dʌ̈i hoobaicheewai hirig, —Pʌ chaaidam monak'a k'ërʌm hajierram hanaabá. ");
INSERT INTO noaH_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Magbaa hichdëu hamag jëeujim haajem, k'an hora chaai deeu k'ĩirdam hinaa haadëjĩ. Mag hamachig jëeubaawai, —Norr k'eeurag la una naawia warre k'ʌʌumie meeuba k'ërsijimgui hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Magbaawai chi hayau hich hödegpai, “Magan mag horata Jesuu mʌrʌg ‘Hoob hatcha k'ĩirjum, pʌ chaai monaaubajup’ ha hiek'ajiebma” hajim haajem. Mag hich chaaidam monaaubapʌ̈im hoobaawai hichdëujã hʌ̈k'anaa hi deg dʌ̈i hãba naajerr k'ʌʌnaujã t'um chadcha Jesuuta Hẽwandam Hiewaa warrgarwe hichdëu pʌ̈iju haajerrau hawia hi hiek hʌ̈k'a nʌisijim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mag chaai parba k'ërʌm warppaimua monaaupʌ̈itarrta Judeamua bëewi Jesuu Galilea durr biek numiim hõor dak'ĩir hag na hamau mag hooba haajem wautarr hajim, mag chaai monaautarr gaaimua hichta Hẽwandamau pʌ̈itarr ha hõrag k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Magtarr k'ur Jerusalén p'öbör hee judionaan p'iesta wai narr haawai, Jesús deeu hagʌg petajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mag Jerusalén p'öbör hee dubaag “Ovejanaan Puertdi” ha t'ʌ̃r sim dak'a t'ʌ̈rrdö juau wautarr estanque hanʌm sim. Mag t'ʌrrdö t'ʌ̃r hebreonaan meúa Betesda haajem. Mag t'ʌ̈rrdö higaau pórticos hanʌm cinco naajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma, sĩi jʌserg heegar harr haawai mor masim k'ʌʌn k'apan t'ũp'ãau t'ʌnaajeejim: dau k'ĩsu k'it'ëem k'ʌʌn, bʌ̈ wëdʌ wëdʌ k'it'ëem k'ʌʌn, maimua sĩi juadam wa mor hëntër k'ãijã k'a chʌk'ʌ k'it'ëem k'ʌʌnpa. Maig nʌmua dö waaurëwaata nʌ naajim, ");
INSERT INTO noaH_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","k'arii Hẽwandam chog hʌ̃gt'armua bëewia mag dö waaurëu pʌabajëm hee chi nacha dubbaimamta monaaujerr haawai hag hee dubaag. Mag dö waaurëu pʌabajëm hee chi nacha dubbaimamʌn parhoobam k'amor machag wai sĩerr k'ãijã monaaub k'aba monaaujeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mag mor masim k'ʌʌn pöm t'ũp'ãau wëjöm hee sĩejim hĩchab woun hãb treinta y ocho años, sĩi k'a chʌk'ʌ haawai pöd hich happaijã p'iidʌba k'itʌm. ");
INSERT INTO noaH_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mag werba k'ërʌm Jesuu hoobaimawia mag año k'apan dau hap'ʌʌ k'ërʌmjã k'aug hat'aawai hirig, —¿Pʌ monaaum k'õsi chirʌ́wi? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Magbaawai chi mor masi k'ërarrau, —Señor, mʌʌn monaaum k'õchag chirʌm; pari chi dö waaurëu sĩubaawai hag hee mʌ jiirpʌ̈iju k'ʌʌn chuk'u haawaita pöd monaauba chirʌmgui hajim. Maadëu hag hee dubaag hẽk'aawai maach nawe hãbmua hag hee paajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Magbaawai Jesuu hirig, —Magan p'iidʌwia dʌrdʌr habá; maimua pʌch put juurwia hat'aad hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hichig magbarm bʌ̈rre chadcha warrjã hich mag monak'a sĩerrjöta p'iidʌ dʌnʌisiwia dʌr nʌnʌʌu k'abaadëjim. Maimua hich put juur hauwia hag dʌ̈i petajim. Pari mag hi monaautarr hed jua hʌ̃ʌijem hed harr haawai, ");
INSERT INTO noaH_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Moiseeu p'ã pʌarr hiek wajap'a hʌʌrk'aajerr k'ʌʌnau hirig, —Hĩs chan pua jãg put chʌgag jiir wai nʌrraju k'aba simgui hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pari hichig magbaawai chi woundamau hamag, —Pari chi mʌ monaaupʌ̈itarrauta mʌrʌg “Pʌch put juurwia hat'aad” hatarr haawaita mua harrubahab hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Magbaawai hamachdëu, —¿Chijãguata pʌrʌg mag sĩejĩ? hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pari mag hi monaaupʌ̈iwia hich Jesujã sĩi hõor k'apanag hee dubbaaderr haawai pöd hi k'augpʌ̈iba harr gaaimua, hĩs mag t'ʌ̃r t'ʌ̃rnaa mag wounauta mʌrʌg mag jaaujimjã habajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Maimua hag k'ur Jesuu hich hag woundamcha Haai hi jëeujem deg hoobaimaawaita hirig, —Ya hʌ̈u pʌ jãg monaau chirsipí, hoob tag pekau wau chitam. Heeu magbamʌn jũrr pʌch gaai hag k'ãai hatcha k'ãijã haduk'am hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesuu hichig magbaawai judionaan chi pörnaan haar mawia hamag jaauwimajim haajem, Jesuuta chadcha hich monaautarr. ");
INSERT INTO noaH_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mag gaaimua judionaan chi pörnaanau chan warag Jesús k'õchk'aba haajeejim, mag hamach dak'ĩir jua hʌ̃ʌijem hedam magwe hõor monaaujerr haawai. Hamagan mag nʌmdampai p'idk'a nʌm dʌ̈i hãba sĩerr haawai jua hʌ̃i nʌm hed pöd magju k'aba sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pari Jesuu mag chi judionaanau k'ĩirju nʌmjã k'ap'ʌ sĩerr haawai hamag, —Jua hʌ̃ʌijem hedam magwe mʌ Hayaujã hõor dau haug k'aaugjeewai muajã hich hagjöta chirʌm k'abahab hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesuu hamach jʌ̃g daar mag hiek'abaawai chará waragta hi t'õopʌ̈im k'õchk'a p'öbaadëjierram. Pari wajapcharan hamach dënjö jua hʌ̃ʌijem hedjã hʌʌrk'aba sim gaaimuapaijã k'aba, ham jʌ̃g daar Hẽwandam higwia hi Haai ha hiek'aawaita mag hi t'õom hiigjeejim, mag sim haig magan hiita Hẽwandam dʌ̈i hãba chirabma hawia. ");
INSERT INTO noaH_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Pari Jesuu warag, —Mʌch chi Chaairaujã mʌch Hayau nem waupim k'õsi sim k'augba hak'iin, muajã mʌch k'ĩrau chan waubajugui hajim. Magba hirua nem waupim k'õsi sim mʌchdëu k'ap'ʌ chiraawaita muajã chadcha waaujemgui hajim Jesuu chi judionaanag. ");
INSERT INTO noaH_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mag hich mʌ Hayaujã mʌ k'õsi haajeewai hichdëu nem waupim k'õsim t'um mʌrʌg k'ap hapiejemgui hajim. Maagjeewai hĩsmua hatagta mua nem wau chirʌm gaaimua pãrau hi jua hoogpamgui hajim. Hante mʌg woun monaautarr k'ãaijã hʌ̃rʌʌcha mua nem waumaju. Mag hoowiata pãar dauderraa hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Hich jãg chi Hayaujã hõor mee nʌm k'ʌʌnjã p'iriutk'a hauwia hich mag hich dʌ̈i wai sĩejemjö, mʌch chi Chaairaujã mʌchdëu magam k'õsim k'ʌʌn dʌ̈in hich hagjö hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Hich Hẽwandam chi Hayaujã hichdëu chan jaauba, mʌch chi Chaairagta jaaupiejem, hõor hich haar hauju wa hauba hisegju, ");
INSERT INTO noaH_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mag gaaimua hich jãg mʌ Haai t'ö hiyʌ̈ʌ haajemjö mʌch chi Chaaijã hagjö t'umaam k'ʌʌnag t'ö hiek'amk'ĩir. Mag sĩewai mʌch chi Chaairagjã heenaa wajap'a mʌ t'ö hiek'aba nʌm k'ʌʌnau chan magan mʌ Haaijã t'öba nʌmgui hajim, hichdëu mʌ pʌ̈itarrta mʌ mʌg chitʌmjã higba naawai. ");
INSERT INTO noaH_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Mʌ cha hiek'a chirʌm hiek'au chi mʌg mua jaau chitʌm hiekta hũrwia hʌ̈k'a simuan Hẽwandam hiekta hʌ̈k'a simgui hajim, chadcha hichdëuta mʌ pʌ̈iwia mag hich hiek jaaupitarr haawai. Mag hʌ̈k'abarm wounan Hẽwandamau ya hich dënk'a hauwia hich mag hi dʌ̈i sĩsim hiek'au. Magbarm woun gaai Hẽwandamau hichdëu hõor hi hagk'a nʌm hedjã mas habajugui hajim, warr hich k'aibag heepai chi t'õmjö sĩerrta hich mag hiiu nʌrraag ya chi peerdʌm haawai. ");
INSERT INTO noaH_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chadcha hĩsta pãar mag chi t'õmjö nʌm k'ʌʌnaujã mʌch chi Hẽwandam Hiewaa hiekcha hũrju hed pabaichëmgui hajim. Mag mʌ hiek hũrwia hʌ̈k'a nʌm k'ʌʌnan warre Hẽwandam dënk'anaa mʌg hatagjã hich mag hiiu nʌisijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hich jãg chi Hayaujã hichdëuta hõor hiiupiejemjö, hich dënjö hamk'ĩir mʌch chi Chaairagjã hagjö hich jua t'eeg deejimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mag nʌm dʌ̈i hĩchab mʌrʌgta hõor hich haar hauju wa hauba hisegju ha jaaumk'ĩirjã hiek t'eeg hapijimgui hajim, mʌchta Hemk'ooi Hiewaa haawai. ");
INSERT INTO noaH_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mag muata hõrag hamach k'ĩircha jawaagjã hiek t'eeg chirʌm ha hũrwia hoob jʌ̃gderraa hamiet. Pari chadcha mʌchdëuta mʌg hatag hötarr k'ʌʌnagjã hamach bëptarr jẽbdegmua höbeerpi jaaubaawai deeu hiiu p'iidʌtk'ajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chi nem wajap'a waaujerr k'ʌʌnan tag meeba hich mag Hẽwandam dʌ̈i wënʌrraagta p'iidʌtk'aju; pari nem k'aigbamta waaujerr k'ʌʌnan Hẽwandamau hamach hisegwia k'ĩmie durrta bark'ʌʌiju habarm hũraagpaita p'iidʌtk'ajugui ha jaaumajim hich Jesuucha. ");
INSERT INTO noaH_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Mʌ Hayauta mʌ pʌ̈itarr haawai hirigjã jëeuba sĩi mʌch k'ĩrau chan pöd mua nem wauba chitʌmgui hajim. Maguata, mʌch Hayau jaaubaawaita mua hagpierr nem waaujem; mag hichdëu jaau sĩewai nem hagchata waaujemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mua mʌch higwia mʌchdëupaita mʌ hiek t'eeg chirʌm hak'iin, mua magju k'aba chirʌmgui haju hõrau, tag mʌ hipierr jaau nʌm k'ʌʌn chuk'u haawai. ");
INSERT INTO noaH_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pari hãb simgui hajim, ma mʌ Hayau. Hiruata mʌ kõit chadcha nem hagcha jaaujem. Mua k'ap'ʌ chirʌmgui hajim, mag hirua nem jaau sim chadcharau. ");
INSERT INTO noaH_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pãrau Juan haar hõor pʌ̈ijierramgui hajim, hiita Hẽwandamau pʌ̈iju haajerrá ha k'ap jëeumk'ĩir. Magbaawai hirua, hí chan har k'abam, hãb hi hẽudee hurumta haruugui hajim, mʌ higwia. Hichdëu mag pãrag jaaupʌ̈itarr chadcha hajimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pari mʌ chan mag sĩi hõraupaita jaauju haai nʌmjã habam. Mua mag Juan higamjö chirʌmʌn, hirua nem jaaujerr hʌ̈k'awia pãach peerdʌtk'amk'ĩrau hajim. Mʌ wajapcha k'ap'ʌnaa jaauju haai sim chan mʌig heegarm k'abamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanan chadcha lámpara dau wajaug p'uu dʌnʌmjö sĩejim, muata hõor peerdʌ hauju haai chirʌm ha jawaag. Mag hirua jaau nʌrrarr hũurwai pãach jʌ̃gaagaa harr haawai k'ũchpain pãar honee hajierramgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pari Juanau sĩi hidamaupai jaau nʌrraajerr k'ãai mua wajapcharam wai chirʌmgui hajim, haguata Hẽwandamau mʌch pʌ̈ijim ha k'ap hapieg. Ma, hõrau hag na nem mag hooba haajem waaujem hag jua t'eegaugui hajim. Mag jua t'eegau mʌ Hayau nem k'ĩir pogk'e waupi jaautarr haawai, hõor dak'ĩir mag waauwai, chadcha hichdëuta mʌ pʌ̈ijim ha jaau sim k'abahab hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pãrau hoojã hooba ni hi hiekjã hũrba naab mamʌ, hich mʌ Haai mʌ pʌ̈itarraujã hagjö mʌ higar sim ha sim, hichdëuta warrgarwejã mʌ higwia hich hiek gaai p'ãpitarr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pari mag hichdëu mʌ pʌ̈iwia mua jaau chitʌmjã pãachdëu hʌ̈k'aba naawai pöd hi hiekjã pãrau pãach t'ãar hee hauba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pãraun sĩi Hẽwandam hiek p'ã sĩsidʌm gaai t'ʌ̃rnaa hag gaai jaau sĩsidʌm hʌʌrk'a nʌmuata pãach peerdʌjupii hawia t'ʌ̃ʌrjerram. Pari par mag hag gaai t'ʌ̃ʌrwai mʌ higwia jaau sĩsidʌm hoo nʌmta, pãrau pãach t'ãar t'eeg nʌm gaaimua ");
INSERT INTO noaH_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","bʌ̃ʌrjã mʌ higba nʌmgui hajim, hich mag hiiu wënʌrram k'õsi nʌm hanʌmta. ");
INSERT INTO noaH_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Mua chan mag pãrag sĩi mʌchig hee hamk'ĩirta nem wauba chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mua k'ap'ʌ chirʌm, pãrau chan t'ãraucha Hẽwandam k'õchk'aba nʌmta sĩi par hiiupai hi k'õsi nʌm haajerram. ");
INSERT INTO noaH_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mʌʌn hich mʌ Haai hiek'au pʌ̈iwiata mʌg chitʌm; pari magʌmjã mua mag jaauwai pãrau mʌ hiek hʌ̈k'aba nʌmgui hajim. Mamʌ jũrr hãb sĩi hich k'ĩraupai bëewiata pãrag magchëk'iin, mag hiek'an chadau pãrau hʌ̈k'ajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Jãga pãrau mua nem jaau chirʌm hʌ̈k'abarju hajim, jãg Hẽwandam hichta hãbpai k'itʌmta pãachdëu nem wau nʌm gaaimua honee hapiju k'ĩirjubanaa hãba pãach k'apeenagpaita pãach t'öpim k'õsi t'ʌnʌm? ");
INSERT INTO noaH_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Hoob pãach jãg nʌm paar muata Hẽwandamag pãach k'aibag waumk'ĩir hirig nem hĩgk'a t'ʌnʌʌuju hamiet hajim hamag. Chi Hẽwandamag pãar hĩgk'ajuun Moiseeuta pãar hĩgk'abajup, sĩi hirua p'ã pʌarr hiek wajap'a hʌʌrk'a nʌmuata pãach hʌ̃gt'ar höbërpiju hanʌmta chadcha hirua p'ã pʌarr t'um hipierraajã k'aba naawai. ");
INSERT INTO noaH_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chadcha pãrau Moiseeu p'ã pʌatarr t'umta hipierraa nʌm hak'iin, hichdëu Hẽwandam hiek p'ã pʌarr gaai mʌ higwia jaau pʌarr haawai, pãrau mʌ hiekjã hʌ̈k'a naak'amgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pari hirua mʌ higwia mag p'ã pʌarrjã pãrau hʌ̈k'ab nʌm, ¿jãga hĩs mʌchdëucha jaau chirʌmjã hʌ̈k'abarju? hajim hamag hamach k'ĩircha. ");
INSERT INTO noaH_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Magtarr k'ur deeu Jesús petajim, hag k'ĩirp'eepai t'ʌrrdö pöm Galilea ha t'ʌ̃r sim hee. Hich hag t'ʌrrdöpai hĩchab Tiberias ha t'ʌ̃ʌrjem. ");
INSERT INTO noaH_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mag hi hag k'ĩirp'ee petaawai hõor pöm hi hẽudee hërëubaadëjim, hamachdëu mag hõor mor masim k'ʌʌn pöoma monaaumamua hi jua t'eeg hoojerr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mag mawia maar na buchagdam gaai waaidʌwia jupbaimaawai maarjã hi bigaau jupimajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Maagwai judionaan p'iesta Pascua haajem ya burrju hʌ̃rʌʌ sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesuu hoowai mag hich hẽudee hõor pöoma bëewia pos haichëm hoobaawai Felipeegta, —Felipe, hõor pöm mʌg wëjöm hat'ee ¿jamta maadëu k'öju bawaagauma? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pari hichdëu Felipeeg mag sĩerran, daau hirua k'an habarju k'ai hawiata mag sĩejim. Mamʌ hich Jesuu hichdëu k'ap nem wauju k'ĩirju sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Magbaa Felipeeu hirig, —Doscientos denarios wai nʌm hanaa sĩi pan happai hauk'iinjã, hagdaujö dau hãhãbdöjã dʌ̈rrk'abajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Magbaawai maar k'apeer hãb Simón Pedro heeum Andrés ha t'ʌ̃ʌrjerrau, ");
INSERT INTO noaH_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Hãb mʌig chaaidam simuata pandam cinco wai nʌrrʌmgui hajim, maimua hãwarrdam dau numí. Pari hõor pöm mʌg wëjöm, ¿k'anii jãgpaimua dʌ̈rr habarju? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Andreeu magbaawai Jesuu jũrr maragta, —Magan hamag t'um hohoodö hapi jaaubat hajim. Mag jaaubaawai chadcha t'umaa p'ũak hee hohood hap'öbaadëjim. Mag hõor pöm wëjöm hee hemk'ooin happai cinco miljö naajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Maimua Jesuu mak'ʌʌn pandam hich jua hee p'ë hauwia, Hẽwandamag hʌ̈u hajim hanaa, jũrr marag hʌapʌ̈imajim, jũrr hõor pöm mag hohood wëjömʌg jigmamk'ĩir. Maimua jũrr chi hãwarrdam paarjã hich hagjö Hẽwandamag hʌ̈u hajim hanaa hagjö jigpijim, hamachdëu k'öm haig k'ömk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Maimua ya t'umaam k'ʌʌn biwaauwia tag k'ömap'a hap'öbaadeewai, sĩi barpʌ̈iju k'ãai, Jesuu marag p'ëpi jaaujim. ");
INSERT INTO noaH_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Maimua chadcha marau t'umaa p'ënaa hoowai, mag pandam cincopai narrta t'ʌbʌt doce hipiirk'a haujim, chi sobau. ");
INSERT INTO noaH_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hõor pöm mag t'ʌnarr k'ʌʌnau hamach daúacha Jesuu hich hiiu haawai mag hag na hamau mag hooba haajerrta mag waubarm hoobaawai jũrr hamach heepai, “Chadcha mʌg wounta hich Hẽwandamaucha hich hi jaaumk'ĩir jʌr hauwi pʌ̈iju ha jaaujerrauwai” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mag nʌmua warag hajués hich pʌr harrwia hamach reik'apim hig nʌm hichdëu k'aug hat'aawai warag durrsĩeg petajim, mam hich happai sĩeimaag. ");
INSERT INTO noaH_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Maimua ya hedau k'ëubaadeewai maar jerag bëewia, t'ʌrrdö hee burrdʌtk'achëwia, ");
INSERT INTO noaH_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","jũrr jap hee paauk'abaadëjim, hag k'ĩirp'ee p'öbör Capernaum hanʌmʌg wëtaag. Mag maar döjãrr paauk'abaadëm hee warag k'ĩssu haadëjim. Maagwai hich Jesús hagt'a bëeba sĩerr haawai maar dʌ̈i maba t'ʌba sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mag ya maar döjãrr wëtumta, p'ũ t'eeg wëbaadeewai sĩi p'ũas baupa haadëjim. ");
INSERT INTO noaH_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ya maagwai maar döjãrr naajim. Cinco k'abamʌn seis kilómetros k'ãijã naajim, döhi haigmua chi warp'ag. Mag nʌm heeta marau hoowai, Jesuuta döjã hʌ̃r durramjö dʌdʌrg hurum hoop'öbaadëjim. Mag hoop'öbaadeewai maar jãp'ierr p'öbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pari mag maar jãp'ierr p'öbaadeewai hichdëu marag, —Hoob jãp'ierrmiet, mʌ k'abahab hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Magbaawai warag marau maach jap hee hi t'ʌ̃r haujim. Mag maar dʌ̈i jap hee pabaadeewai sëuk'abarmjö habarm hee jöpchata ya maar maach maa harr haar naaimajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hag noram hãspaau t'oom higar t'ʌbagk'atarr k'ʌʌnau k'aug hat'ajierram haajem, jap hãbpai haig sĩerr hee maar hërëubaadëm. Mag maar weetwai chi Jesús maar dʌ̈i maba harrjã k'ap'ʌ naajim haajem hĩchab. ");
INSERT INTO noaH_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mag nʌm hee hich hag t'ʌrrdö heepai p'öbör Tiberias hanʌm haarmua bote bëewia, mag hag noram Jesuu pan cinco hich jua hee haunaa hag paar hʌ̈u hajim hanaa hõrag k'öpitarr dak'a jopdʌtk'achëjim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mag chadcha hamachdëu hoowai, Jesús haig k'aba ni maar hi dʌ̈i wënʌrraajem k'ʌʌnjã haig k'aba nʌm k'aug hat'aawai, mag bote jopdʌtk'achëtarr hee jũrr döjãrr paauk'abaadëjim haajem Capernaumag, Jesús hẽudee hi jʌr wëtumua. ");
INSERT INTO noaH_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Maimua mag wëtwia chadcha hag k'ĩirp'ee Jesús sim hoobaimaawai hirig, —Maestro, ¿k'an horata pʌ mau pabaadëjĩma? hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Magbaawai Jesuu hamag, —Chadcha pãrau mʌ jʌr wënʌrrʌmʌn, sĩi pãach t'ach biwaau k'öpitarr haawaita pãrau mʌ jʌr wënʌrrʌmgui hajim. Mamʌ hĩs mag mua jãg pãach dak'ĩir wautarr gaaimua mua jaau chitʌm hʌ̈k'ak'imjã haba nʌm. ");
INSERT INTO noaH_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jãg sĩi biwaau t'ach k'öm k'õchgaupai mʌ hẽudee hẽk'a wënʌrraju k'ãyau, tag bʌ̃ʌrjã jãsöo hapiba hich mag pãach hiiupiejem pan k'ĩirta hat'at hajim hamag. Mʌch chi Hemk'ooi Hiewaauta mag pan pãar hat'ee wai chirʌm. Mʌch Haai Hẽwandamau pãrau hag na mag nem hooba haajem waumk'ĩir juapá deetarrauta nem waaujeewai pãrau mʌ hiek hʌ̈k'anaa hichdëuta mʌ pʌ̈itarrjã k'ap'ʌ haju haai nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Magbaawai hamach garmua jũrr hirig, —¿Marau k'ani wauju haai nʌ hajierram, Hẽwandamau nem waupim k'õsi simjö haag? ");
INSERT INTO noaH_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Magbaawai Jesuu hamag magjim: —Hẽwandamau pãrag waupim k'õsi simʌn, mʌʌta warrgarwe hichdëu pʌ̈iju ha jaaujerr haawai mua nem jaau chitʌmta pãrag hʌ̈k'apim k'õsi simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Magbaawai deeu hamachdëu hirig, —Pua deeu maar dak'ĩir hag na marau hooba haajemta wauk'iin chadau marau chadcha pʌ Hẽwandamauta pʌ̈ijim haju. ¿Mamʌ k'ani pua wau nʌ? hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maimua hamachdëupai, Maar jöoin hõor chukag durr wënʌrraajeewai Moiseeu “maná” hanʌm hʌ̃gt'armua k'ʌipitarrta k'öjierramgui hajierram. Hich Hẽwandam hiek p'ã sim gaai jaauwaijã, “Hʌ̃gt'armua pan k'ʌipiwia hamag k'öpijim” ha sim. Maagwai puajãh, ¿k'ani wau nʌ? hajierram deeu hirig. ");
INSERT INTO noaH_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Magbaawai Jesuu hamag, —Pari Moiseeu k'abajimgui hajim hamag pan deetarr; mʌ Hayau k'abajieb hajim. Maimua hĩsjã hagt'a hich mʌ Hayauta hʌ̃gt'arm pan pãrag dee sĩebahab; pari hĩsimʌn warr pãar jöoinag deejerr k'ãaijã chi wajapcharamʌugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Magnaa hichdëupai hich higwi, Pari mag pan hich Hẽwandamauta dee sĩewai hʌ̃gt'armuachata bëejimgui hajim, hõor hiiupi hawaag. ");
INSERT INTO noaH_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Magbaawai hamachdëu hirig, —Señor, magan mag pan marag hich mag dee chitá hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Magbaa Jesuu, —Wajapcharan mʌchpai k'abahab hajim, mag pan hõor hiiupiejem. Mʌig heegarin par pãar t'ach pöm biwaau k'öwiajã deeu jãsooju. Biwaau dö döwiajã deeu höbisi haju. Mamʌ chi mʌ hiek hʌ̈k'anaa mʌʌta hau sim chan tag deeum higbajugui hajim, hich peerdʌ haumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mamʌ chaig mʌchdëu pãrag jaau chirarrjö, pãraun mʌ hoo naab mamʌ, bʌ̃ʌrjã mʌ hiek hʌ̈k'aba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","T'um mʌ Hayau mʌ hiek hʌ̈k'api nʌm k'ʌʌnaun mʌ hig nʌm. Mag mʌch hig nʌm k'ʌʌnan mua haub k'aba haujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mʌ chan sĩi mʌchdëu ham haig nem wawaagjã hʌ̃gt'armua bëebajim. Mʌʌn mʌch Hayau mʌchig nem mag habaawai hi hipierr haagta bëejimgui hajim, hichdëuta mʌ pʌ̈itarr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hich chi mʌ pʌ̈itarr Jöoiraujã k'õsi simʌn, mag ya mʌch hõork'a t'ʌnʌm k'ʌʌn heem hãbjã hok'oopiba, sĩi mʌg durr hö nʌm hedjã deeu p'iriutk'a haupim k'õsita simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mʌ Hayaun, har mʌ higwia “Jãata chadcha hi Hiewaau” hanaa mʌ hiek hʌ̈k'a nʌm k'ʌʌnta mʌg hatag pawiajã hich mag hichjö hiiu wënʌrrapim k'õsi sim. Pari magaagan mʌg hatag mʌg durr hö nʌm hedjã mʌchdëuta ham p'iriutk'a haujugui hajim hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hirua magbarm hee chi judionaan sereu p'öbaadëjim, Jesuu hamach jʌ̃gdaar “Mʌʌta hʌ̃gt'armua bëetarr Panau” ha hiek'abaawai. ");
INSERT INTO noaH_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mag sereu p'öbaadëwi hamach heepai, —Keena, pari ¿chamʌg Jesús maachdëu hoo bãautarr k'abá hanaajim, José hiewaa? Mag simta ¿jãga mag hiita hʌ̃gt'armua bëetarr habarju? Magan maadëuta hi dënnaan k'augba naab, hi mag hiek'a chirʌm hanaajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Magbaawai jũrr hichdëu hamag, —¿K'ant'eeta pãachig hiek'aawaijã pãar dën warag magta hiek'aajerráma? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Chadcha hich mʌ Hayauta mʌ pʌ̈itarr haawai hichdëuta mua hõrag jaau chitʌmjã hʌ̈k'apibam chan ni hãbmuajã pöd mʌ hiek hʌ̈k'abamgui hajim. Hichdëu hʌ̈k'apibaawai hʌ̈k'abarm k'ʌʌnan chadau mʌg durr hö nʌm hedjã deeu mua ham p'iriutk'a haujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hẽwandam hi jaaujerr k'ʌʌnau hẽsap p'ã pʌarr gaai jaauwai, hich Hẽwandamauta hich hõork'a nʌm k'ʌʌnag jaauk'amaju ha sim, hich hiek k'augmamk'ĩir. Hichdëucha magtarr haawaita har t'um hi hiek hũrnaa hʌ̈u hi k'augp'ömam k'ʌʌnaun mʌjã higjuraugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mua mag chirʌm chan mag hõrau hi hoojeewai haba chirʌm. Hãba hi hoowia hi k'ap'ʌ simʌn, mʌchta hi sim haarmua bëetarr haawai mʌchdëupaita hi hoojemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Magnaa, Mua mag chirʌmgui hajim: Chi mʌ hiek hich t'ãraucha hʌ̈k'a simʌn mʌg hatagjã hich mag Hẽwandam dënk'a sĩsim hiek'au. ");
INSERT INTO noaH_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mʌʌta chadcha hõor hich mag hiiu wënʌrrapiejem Panaugui hajim deeu Jesuu, hich higwia. ");
INSERT INTO noaH_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pãar jöoinaun chadcha hõor chukag hee durr p'ʌʌr wënʌrraawai maná k'öjierram. Hamau mag maná k'öjierrab mamʌ, hichiita k'ëchjierramgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mamʌ mua jaau chirʌm pan chan mag maná k'ĩir k'abam. Mua mag hʌ̃gt'armua bëetarr pan ha chirʌmʌn, mʌch jaauwiata mag chirʌmgui hajim. Chi mag panta k'öbarm wounan hich magta hiiu sĩsim hiek'au. ");
INSERT INTO noaH_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mʌchta mag pan hʌ̃gt'armua bëetarr hõor hiiupiejem k'abahab hajim. Mag panta k'ö simʌn hich magta hiiu sĩsiju. Mamʌ mag panjö mua pãrag deeju ha chirʌmʌn, t'umaam k'ʌʌn hiiu wënʌrraju haai hamk'ĩir ham kõit hʌdʌraa mʌch t'õopijuuta jaau chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Hamach pem haawai, Jesuu mag hiek'abapʌ̈im hũrwia, deeu sereu p'öbaadëwia hamach heepai, “¿Jãga jãg simua maachig hichta pank'a k'öpibarju?” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jũrram k'ʌʌnau mamagk'am hũrwia Jesuu hamag magjim: —Mʌ cha hiek'a chirʌm hiek'au har mʌch chi Hemk'ooi Hiewaa modta k'öwia mʌ bagjã döba sim chan pöd hich mag hiiu nʌrrabamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Magarrau chadcha chi mʌ mod k'öwia mʌ bagjã dö sim k'ʌʌn chadau meewiajã deeu hiiu p'iidʌwia hich mag hiiu sĩsim hiek'au hajim. Pari magaagan mʌg hatag mʌg durr hö nʌm hedjã mʌchdëuta deeu hũwaai hi p'iriu haujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mua mag chirʌmʌn, mʌ modouta mʌ bag hãrbarm dʌ̈imua chadcha hõor hiiupi hauju haawaita mag chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chi mʌ mod k'önaa mʌ bagjã dö simʌn mʌ dʌ̈i k'apeerk'am hiekta k'apeerk'a sĩsiju. Maagwai mʌch garmuajã hi dʌ̈i hich mag k'apeerk'a chirsijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mʌ Haai mʌ pʌ̈itarrjã mee k'augba sĩerraawai mʌchjã hi gaaimuata hich mag hiiu chitʌm. Maagwai hĩchab chi mʌ modta t'achjö wajap k'ö sim k'ʌʌn, hich jãg mʌjã mʌch Haai gaaimuata hich mag hiiu chitaajemjö, mag wounjã hĩchab mʌ gaaimuata mʌg hatag pawiajã hich mag hiiu sĩsijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Muan pãragan mag pãar jöoinau maná k'oojerr k'ĩir k'aba, hʌ̃gt'armua bëetarr panta k'öpi jaau chirʌmgui hajim. Mag maná hõor hich mag hiiupiejem k'ĩir k'aba harr haawai par hamau k'ö durrajieb pari mag k'ö nʌm gaaimuata Hẽwandamau ham hauju habajim. Mamʌ cha mua pan jaau chirʌmta k'öbarmʌn chadau Hẽwandamau hauwi hich mag hich dʌ̈i wai sĩsijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesuu hamag mag hiek'atarran Capernaum p'öbör hee judionaan Hẽwandam hiek jaaujem di wai narr heeta mag jaaumajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesuu mag jajawagmam hũrwia hõor pöm hi hẽudee wënʌrraajerr k'ʌʌn hee hãaur k'ʌʌnau, “Keena, mʌg wounan dau lökta nem jaau nʌrrʌm, ¿k'aíu hi hipierr habarju?” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pari hamach heepai mamagk'am hich Jesuu k'aug hat'aawai hamag magjim: —¿Mua mag jaau chirʌm hũrwia pãar t'ãar hee k'aigba nʌ? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Magan pãach dak'ĩir Hemk'ooi Hiewaa deeu hũwaai warr hich sĩerr haar sĩeimaag hʌ̃gt'aa papagmam hook'iinjã, pãrau ¿jãga k'ĩirjuk'ajĩma? Mag hook'iinjã ¿mʌ chadcha hʌ̃gt'armua bëebajim hajupá? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Magnaa warre hamag, Mua mag mʌch mod k'öpi jaau chirʌm chan mʌch mod chaarta jaauba chirʌmgui hajim. Mʌ modon chadcha pãrau k'öwiajã jãgua chan bʌ̃ʌrjã pãar peerdʌ haubajugui hajim, Hẽwandam Hak'arauta hõor hiiupiejeewai. Mag mʌ mod chaarta k'öju k'ĩirjuju k'ãai, cha mua pãach kõit hʌdʌraa mʌch t'õopiju jaau chirʌmta hʌ̈k'api chirʌmgui hajim, chi mag hʌ̈k'a nʌm k'ʌʌnauta Hẽwandam Hak'aar hõor hiiupiejem wai nʌisiju haawai. ");
INSERT INTO noaH_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pari mua mag jaau chirʌm hee pãar hee hãaur k'ʌʌnau mʌ hiek hʌ̈k'aba t'ʌnʌmgui ha hiek'amajim. Jesuu hamag mag hiek'atarran, warrgarwejã chijã k'ʌʌnauta hi hiek chadcha hʌ̈k'aba naaju ha k'ap'ʌnaa chijãguata wir haig hi hoomap'am k'ʌʌnagjã hich pʌr deeju ha k'ap'ʌ sĩerr haawaita mag hiek'apʌ̈ijim. ");
INSERT INTO noaH_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Maguata mag hiek'amamua, —Chadcha hich mʌ Hayauta mua hõrag jaau chitʌmjã hʌ̈k'apibam chan, pöd hãbmuajã hʌ̈k'abamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesuu mag hiek'atarr haigmua hõor pöm hi dʌ̈i wënʌrraajerr k'ʌʌn heem k'ʌʌnaujã hi k'a hogdʌ pʌawia ya tag hi dʌ̈i k'aba nʌisijim. ");
INSERT INTO noaH_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mag hõor pöm hich haigmua hërëu t'ʌnʌm hoobaawai maach hichdëucha hich dʌ̈i doce hogdʌba wënʌrramk'ĩir t'ʌ̃rk'a hautarr k'ʌʌnagjã, —¿Pãarjã warm k'ʌʌnjö wëtam k'õsi nʌwi? hajim marag. ");
INSERT INTO noaH_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Magbaawai Simón Pedroou hirig, —Señor, mag wëtwiajã, ¿k'ai haar maar hërëubaadëju? Hãba pʌchdëupaita hõor hiiupiejem hiek wai sĩebahab hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Maguata marau pʌ hiek hʌ̈k'ajim. Maimua marau k'ap'ʌ nʌm, pʌ chadcha Hẽwandam Hiewaa pekau chuk'u k'itʌm k'abahab hajim, hichdëu pʌ̈iju ha jaaujerr. ");
INSERT INTO noaH_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Simón Pedroou hichig magbaawai Jesuu jũrr, —Chadcha mʌchdëuta mua pãar doce t'ʌ̃rk'a haujimgui hajim, mʌch dʌ̈i hogdʌba wënʌrramk'ĩir. Magjieb mamʌ pãar hee hãb meperau pör meu simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesuu mag sĩerran, Simón Iscariote hiewaa Judas haajerr higwiata mag sĩejim. Mag Judas chadcha hĩchab hichdëucha maar doce t'ʌ̃rk'a hautarr heem hajim. Pari magua hi k'a huk'urm k'ʌʌnag hich pʌr deeju k'ap'ʌ sĩerr haawaita mag hiek'ajim marag. ");
INSERT INTO noaH_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Magtarr k'ur hich Jesús Galilea durr p'öbördam nʌnʌidʌmpierr p'ʌʌrdʌ nʌrrajim. Hich tag Judea durr mamap'a sĩejim, judionaan chi pörnaanau hich t'õog hẽk'aajerr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pari mag hi p'ʌʌr nʌrrʌm hee, judionaan p'iesta Las Enramadas hanʌm burrju k'ãai k'apan k'aba waaur narr haawai, ");
INSERT INTO noaH_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","hich heeugpeenaupai hirig, —Mʌig Galileapai sĩeba Judeaagta petá hajierram, jamjã pʌchig hee haajem k'ʌʌnag pʌchdëu nem wau sim hoomk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maadëu t'umaam k'ʌʌnag dich k'ap'ʌ hapim k'õsi chirʌm chan, sĩi dich happaita meraa nem wauba haajem. Jãg pʌch nem wau sim t'umaam k'ʌʌnag k'ap hamk'ĩirta waubá hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mamʌ hich heeugpeenaupai hirig mag narran, hirua hamach dak'ĩir mag nem wau sim hoo nʌmjã hamach paarmua hich Hẽwandamau pʌ̈iju ha jaaujerr k'abam haajerr haawaita juau hogt'om hirig mag naajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hich heeugpeenaupai hichig magbaawai Jesuu hamag, —Pãragan hora t'um wajap'amgui hajim, p'iesta hee maag. Pari hagt'a mʌch maju hora k'aba sĩewai mʌʌgwaiwe chan mʌ mabamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Pãar chan pöd hõrau hoomap'a habam, pãachjã ham higar naawai. Magarrau mʌʌn chadau hamau hoomap'a wai nʌmgui hajim, hamachdëu nem k'aigba wau nʌm mua hamach k'ĩircha jaaujeewai. ");
INSERT INTO noaH_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Magnaa hamag, Pãachta pãach p'iesta hee wëtjurauma hajim. Mamʌ hagt'a mʌch maju hora k'aba haawai mʌʌgwaiwe chan mʌ mabamgui hajim hich heeugpeenag. ");
INSERT INTO noaH_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hamag mag hiek'apʌ̈iwia hich chan maba, chadcha Galilea sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pari mag hich heeugpeen wëttarr k'ur nʌʌ hawia hök'arta ham hẽudee petajim, hich Jesús. Pari mag matarrjã hõrag hich mam k'augpiba meraata petajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Maagwai judionaan chi pörnaanau chi p'iesta hee hi jʌrp'öo t'ʌnʌmua, “¿Jamta simta jãg hoobáma?” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mag nʌm dʌ̈i hĩchab sĩi bigaaum k'ʌʌnaujã hi higwia, “Jãg wounan hãba nem wajap'ampaita wau k'itaajem” ha hiyʌ̈ʌ haawai, jũrr hãaur k'ʌʌnau, “Hʌ̃hʌ̃, ¿jãga hõor wajap'am habarju jãg sĩi hõor k'ũgur nʌrraajem?” haajeejim haajem jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pari mag hiek'a nʌmjã sĩi parhooba t'umaam k'ʌʌnag hũrmk'ĩir k'aba, hamach happaita mamag haajeejim hanaabá, magʌm gaaimua judionaan chi pörnaanau jũrr hamach dʌ̈ita k'aigbaju k'ĩirjuwia. ");
INSERT INTO noaH_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pari jũrram k'ʌʌnau mamagk'am hee, mag nʌm dʌ̈i hĩchab chi p'iestajã seman jãrr pamam heeta barwia, Haai hi jëeujem deg dubwia, hõrag Hẽwandam hiek jaau sĩeimajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mag hirua nem jaaumam hũrwia judionaan chi pörnaan jʌ̃gderraa nʌmua, “¿Jãga jãg estudietarrjã chuk'u sĩerrʌmta magʌm nemjã jaau k'aauga sĩma?” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Hamau mag hiek'a nʌm hũrwia jũrr hich Jesuu hamag, —Mua nem jaau chirʌm chan sĩi mʌch hiekpai k'abamgui hajim. Mua nem jaau chirʌmʌn mʌch pʌ̈itarr wounau mʌchig jaaupitarrta jaau chirʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hãbmua Hẽwandam hipierr nem waum k'õsi sim k'ai, magua k'ap'ʌ hajugui hajim, chadcha mua Hẽwandam hiekta jaau chirʌ́ wa sĩi mʌch hiekpaita jaau chirʌ́. ");
INSERT INTO noaH_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sĩi har hamach k'ĩirjug heemuapai hiek'a nʌm k'ʌʌnan sĩi hõrag hamach t'ö hiek'amk'ĩirta hiek'aajerramgui hajim. Pari magba har sĩi dich chogpʌ̈itarrta wajap'a hig hiyʌ̈ʌ hamk'ĩir nem jaau nʌm k'ʌʌnan, chadcha hichdëu jaaupitarr hiekta hich hagpierrpai jaaujemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Magnaa hichdëupai hamag, ’¿Moiseeu chadcha pãar hat'eeta ley p'ã pʌabajĩ? hajim. Magtarrjã pãrau hiwiram hãbmuajã hag gaai jaau sim hipierraa haba haajemgui hajim. ¿Hag gaai hĩchab hõorjã t'õopiba jaau sĩebá? hajim. Mag simta, ¿jãgwia pãrau mʌ t'õom hig nʌmma? hajim judionaan chi pörnaanag. ");
INSERT INTO noaH_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Magbaawai chi hũr narr k'ʌʌnau hirig, —Pʌʌn chadcha dösãtauta pör meu simgui hajierram. ¿K'aíu pʌ t'õom hig nʌmta pua mag sĩ? hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Magbaa Jesuu hamag magjim: —Chadcha pãar t'umaam k'ʌʌn dak'ĩir jua hʌ̃ʌijem hedta mua hõor monaaujim. Magtarr haawai hãba maata pãrau hig naabma hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pãach garmuan pãrau mʌrʌg mag naabma, pari k'ĩir heeya habat: Moiseeu jaauju nawe ya pãach jöoinau hich maagjerr haawai, ¿warag Moiseeujã pãrag chaain mehëudam hich mag p'ʌʌrbichpi jaau pʌabajĩ? Magtarr haawai ¿jua hʌ̃ʌijem hedam magwe pãrau hag hipierr haba haajẽ pãach chaain dʌ̈i? ¿Pari jãg nʌm haigjã p'idk'a nʌm k'abá? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mamʌ hich jãg Moiseeu jaau pʌarr hichaaur hamaaugau sabarhedam magwe pãachdëun chaain mehëu p'ʌʌrbich nʌmta, ¿jãgwia mua sĩi sabarhed woun monaautarr hoowiapai pãar mʌ dʌ̈i meeuk'a nʌ? hajim, mua sabarhedjã hʌʌrk'aba chirʌm hawia. ");
INSERT INTO noaH_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Magnaa hamag, Chik'am jaauju nʌm k'ai, wajap'a k'ĩirjunaata nem hagcha jaaubat; pari hoob jãg sĩi pãach k'õchagpierrta nem jaaumiet hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mag k'apanag dak'ĩir Haai hi jëeujem deg hijẽjẽbk'am hoowia chi Jerusalenpien chi pörk'a narr k'ʌʌn hee hãaur k'ʌʌnau jũrr hamach k'apeenag, —¿Chamʌ́ har hamau t'õopäaig pʌr hauju hẽk'a nʌm woun k'abá cha hijẽjẽbk'am? haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Jãga jãg hõor pöm t'ʌnʌm dak'ĩir hamachigcha mag hiek'amamjã bʌ̃ʌrjã hi chig haba nʌmma? ¿Wa ya chi t'et'echaram k'ʌʌnaujã, “Jãata chadcha warrgarwe hich Hẽwandamaucha pʌ̈iju jaaujerr” ha nʌwa? haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pari mag k'ai, maadëu k'ap'ʌ nʌmgui haajeejim, jam hagá hi durr. Mamʌ chadcha hich Hẽwandamau pʌ̈iju ha jaaujerrcha bëewai chan hãbmuajã k'augbaju, jammuata bëeju k'ai. Magua jã har k'abamgui haajeejim jũrram k'ʌʌnau, chadcha hich Galileapierrk'a sim k'ap'ʌ narr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mamʌ jũrram k'ʌʌnau mamagk'am hũrwia mag Haai hi jëeujem deg hichdëu jaau sĩerr haigmua hich Jesuu k'ĩesir hiek'amamua, —Magan pãraun mʌch chi wounjã k'ap'ʌnaa hĩchab mʌ durrjã k'ap'ʌ naabma hajim. Pari mʌ chan pãrau k'ĩirju nʌmjö sĩi mʌch k'ĩrau bëetarr k'abam. Mʌʌn hãb pãrau k'augba naab mamʌ, bʌ̃ʌrjã sëu chuk'u sĩerrʌmuata pʌ̈ijimgui hajim. Ma pãrau k'augba nʌmgui hajim, k'ai hagá. ");
INSERT INTO noaH_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mʌchdëun mua hi k'ap'ʌ chirʌmgui hajim, hi haar chirawia bëetarr haawai. Hichdëuta mʌ pʌ̈ijimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hamachig magbapäaiwai warag hi pʌr hauju k'ĩirjujierram. Pari hagt'a Hẽwandamau hi pʌr haupiju hora k'aba harr haawai ni hãbmuajã hi pʌr hauba, sĩi hich magpai sĩujierram. ");
INSERT INTO noaH_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hãaur k'ʌʌnau hi dʌ̈i mag nʌm hee, hãaur k'ʌʌn k'apan haig narr k'ʌʌnau hʌ̈k'a nʌm hiek'au, —Daau mag nʌm hich Hẽwandamaucha pʌ̈iju ha jaaujerr pierrwaijã, mʌg Jesuu nem wau nʌrrʌm k'ãaijã hʌ̃rʌʌcha hag na hõrau nem hooba haajem waubarju ha hiek'a naajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Moiseeu p'ã pʌarr hiek wajapcha hʌʌrk'aajem k'ʌʌnau hũurwai hõrau Jesús higar hiek'a nʌm hũrbaawai hamach garmua p'adnaan chi pörk'a narr k'ʌʌn dʌ̈imua guardianaan chi Haai hi jëeujem di t'ʌajerr k'ʌʌn pʌ̈ijierram, hi pʌr haumk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pari mag hich pʌr haumk'ĩir hich haar hõor pʌ̈i nʌmjã hich Jesuu k'ap'ʌ sĩerr haawai hamag, —K'ũchpaita pãar dʌ̈i mʌ mʌig heegar chitabahab. Mʌʌn deeu mʌch pʌ̈itarr haar maju chirʌmʌugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mag mʌ petaawai pãrau mʌ jʌrju, pari pöd mʌ baau haubajugui hajim, mag mʌ chiraimaju haar pãar barju k'aba naawai. ");
INSERT INTO noaH_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jesuu mag hiek'abapʌ̈im hũrwia, chi judionaan sereu p'öbaadëwia, jũrr hamach wir haigpai, “¿Jamag maju jaau simta mag pöd maadëu hi baaubaju hanʌm? ¿Wa deeum durr mawia jũrr parhoobam k'ʌʌnag jawaan maju higwiata mag sĩwa?” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“¿K'an ha simʌu mag maadëu hi jʌrwiajã pöd hi sim haar chan barbaju hanʌm?” haajeejim hamach heepai. ");
INSERT INTO noaH_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ya hãbmiecha chi p'iesta hö nʌm hedta chi wajapcharam hajim. Mag hed Jesuu dʌnʌʌunaa t'et hiek'amamua hõrag, —Hãb k'ãijã höbisi sim k'ai, mua wai chirʌm dö k'ĩirta döbá hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hich Hẽwandam hiek p'ã sim gaai jaau simjö, chi mʌ hiekta hʌ̈k'a sim t'ãarbʌ̈ heemuan hich mag sĩi hõor hiiupiejem döota k'umdʌ höbër sĩsimjö sĩeju hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mag sim haiguin Jesuu hi hiek hʌ̈k'abarm k'ʌʌnaun Hẽwandam Hak'aarta hauju ha sim hajim. Pari maagwai chan hagt'a chi Hẽwandam Hak'aar bëeba sĩejim, hich Jesujã hagt'a hich Haai haar hʌ̃gt'ar maba sĩerr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesuu mag hiek'abarm hũrbaawai hãaur haig narr k'ʌʌnau, “Mʌg wounan chadcha Hẽwandamau hich hi jaaumk'ĩir jʌr hautarrta jãg nʌrrʌm” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Maagwai hãaur k'ʌʌnau jũrr, “Keena, jãan warrgarwe hich Hẽwandamau pʌ̈iju haajerr wounauwai” hanʌm hee, tagam k'ʌʌnau, “Hʌ̃hʌ̃, mag k'abam; jãg woun chadcha cha jaau nʌmjö warrgarwe hich Hẽwandamau pʌ̈iju jaaujerr hak'iin, Galileapierr k'abak'am” haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“Hẽwandam hiek p'ã sim gaai jaauwai, Mesías mag warrgarwe hich Hẽwandamau pʌ̈iju jaautarran rey David k'ararr k'od haju haajem, hi chaain hewagam k'ʌʌn bi heem haju haawai. Maimua hi t'aabaawaijã Belén p'öbör heeta hauju ha sim, hich Davijã Belenpierr harr haawai. Magua mʌg woun chan hag Mesías k'ababam” k'ajierram jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mag Jesús higwia jũrram k'ʌʌnau pogk'a jaaup'öo t'ʌnʌm gaaimua, hãaur k'ʌʌn hi higar naawai hãaur k'ʌʌnau hi k'õchk'aba hiek'a nʌrrjëe hajim. ");
INSERT INTO noaH_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Hãaur k'ʌʌnaun hich Jesuuta warag preso pʌr harraag hẽk'a naajim, pari mag nʌmta hãbmuajã hi pʌr hauba sĩi sĩujierram. ");
INSERT INTO noaH_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mag hamachig jaaubaawai chadcha chi Haai hi jëeujem di t'ʌajerr k'ʌʌn wëtwia, deeu bëewia, jũrr fariseonaan p'adnaan chi pörnaan dʌ̈i hãba narr haar wëtjierram haajem. Magbaawai mak'ʌʌnau hamag, —¿Jãgwia pãrau hi pʌr haibëebajĩ? hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Magbaa chi guardianaanau hamag magjierram haajem: —Marau chadcha hi pʌr haubëeba harran, maachdëu hũurwai sĩi parhoobam k'ʌʌn hiek'aajemjö k'abata nem jaau sĩerr haawaita pʌr haubëebajimgui hajierram haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Magbaawai chi fariseonaanau chi guardianaanag, —¿Pãachpata hʌdʌraa k'ũgurpi nʌ hajierram haajem, mag hiek'aag? ");
INSERT INTO noaH_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Maach meeun judionaan chi pörnaanaun k'ap'ʌnaa maach chi fariseonaanaujã k'ap'ʌ nʌmgui hajierram haajem, jãg woun chan Hẽwandamau pʌ̈iju jaaujerr Mesías k'aba sim. ");
INSERT INTO noaH_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sĩi p'öbör hee parhoobam k'ʌʌnaun chadcha harpii naama. ¿Pari k'ani jãk'ʌʌnau Moiseeu p'ã pʌarr ley k'ap nʌ? Jãk'ʌʌn Hẽwandamau higbaju k'ʌʌn haawai sĩi chi maldisiem k'ʌʌn k'abahab hajierram hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Magbaawaita tagam k'ʌʌnau mag nʌm hee, hag na biek hãb hedaar hich Jesús dʌ̈i hiyʌ̈ʌ hat'urtarr hag fariseo Nicodemo haajerrau hich k'apeen hijũrr magjim hanʌm: ");
INSERT INTO noaH_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Keena, pari Moiseeu maachig ley werpʌatarr gaai jaauwai, k'an gaaimuata mag woun k'aibag wawaagpá ha k'ap haag wajap'a hi hiek hũr hauba chan pöd hõor hãbjã k'aibag waupi jaauju k'aba nʌm ha simta, ¿jãga pãar mag hiek'a nʌ? hajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Magbaa warm k'ʌʌnau hirig, —¿Pʌchjã hagjö Galileapierrá hi kõit mag hiek'aag? Mag chirabnaa, pʌdë Hẽwandam hiek p'ã sim gaai jʌrbarí hajim hanʌm. ¿K'aíu jaauwai mag Galileamuata Hẽwandam hi jaaujem hãb k'ãijã höbërju ha sĩ? hajierram hanʌm hirig.  ");
INSERT INTO noaH_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mag, chi p'iestajã höbaadeewai warag t'um hagdaujö hamach diig hërëubaadëjim. ");
INSERT INTO noaH_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mag hamach diig hërëubaadeewai hich Jesús jũrr Olivo durrsĩig petajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Maimua hag noram hedp'erre deeu bëewi Haai hi jëeujem deg sĩeichëjim. Mag hi maig sĩeichëm k'aug hat'aawai hi haig hõor bëe t'ʌnʌisijim. Magbaawai k'ʌt jupwi Hẽwandam hiek jawaagpajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pari mag ya hirua jaaubaadëm heeta, Hẽwandam hiek jawaag chi machnaanau fariseonaan dʌ̈imua hi haig hʌʌi waibëejierram. Mag hʌʌi hich jaai k'abamuata wau wai sim hooimawia mag hi haig waibëejierram. Mag waibëewia t'umaam k'ʌʌn jʌ̃g daar ");
INSERT INTO noaH_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesuug magjierram: —Maestro, mʌg hʌʌi hich jaai k'abamuata wau wai sim hooimajierramgui hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moiseeu ley p'ã pʌarr gaai jaauwai, mʌgʌm hʌʌinan mokou bar wai nʌmua warreta t'õopʌ̈ipi jaau sim. ¿Pua hoowai jãga haju haai sĩ? hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pari hamau mag hirig jëeu narran, jũrr chaauraapai k'ãijã jaaubaawai juau hogt'om hich magʌm gaaimuapai hi k'aibag wawaag hajima. Pari hichig mag jëeu nʌmjã hũrbamjö, chi Jesús warag heeg hʌ̃t'ʌnaa jĩgk'ẽúapai jẽb gaai p'ãpʌ̈i p'ãpʌ̈i hoo sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pari magʌmjã pʌaba mag hichig p'ʌʌrba jëjëeu k'aawaita dʌnʌʌunaa hamag, —Pãachdëu k'ap'ʌ jaau naawai pãach hee har bʌ̃ʌrjã pekau chuk'u nʌm k'ʌʌnauta nacha hi barjurauma hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mag hiek'apʌ̈iwia, deeu heeg hʌ̃t'ʌ hoo sĩsiwi, hũwaai jẽb gaai jĩgk'ẽúa p'ãpʌ̈i p'ãpʌ̈i hoo sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mag chi hʌʌi waiberr k'ʌʌnau Jesuu hamachig mag hiek'abapʌ̈im hũrbaawai jöoiraacharam k'ʌʌnta nacha hök'ar hãhãbdö wët hahaugmamua tagam k'ʌʌnjã k'ĩrab hërëudubjierram. Hãba chi hʌʌi happaita maba haig sĩsijim. Mag ya hamach numpai haadeewaita ");
INSERT INTO noaH_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","deeu dʌnʌʌunaa chi hʌʌiragta, —¿Jam nʌ pʌ haiberr k'ʌʌn? ¿Hãbmuajã pʌ mokou barba hërëubaadëjĩ? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Magbaawai chi hʌʌirau, —Hʌ̃hʌ̃, ni hãbmuajã mʌ chig habajimgui hajim. Magbaa deeu hich Jesuupai hirig, —Muajã pʌ chig habam. Petá, pari jãimua hoob tag pʌch jaai k'abam dʌ̈i k'apes hamgui hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mag k'ur deeu haig hõor narr k'ʌʌnag Jesuu magjim: —Mʌʌta mʌg durr gaai wënʌrrʌm k'ʌʌn hat'eem hõtdauu; chi mʌ dʌ̈ita nʌrrʌm chan tag bʌ̃ʌrjã k'ĩchag hee nʌrrabamgui hajim, mʌchdëuta hi hiiupinaa Hẽwandam k'ĩirjugjã k'augpi chiraawai. ");
INSERT INTO noaH_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Magbaawai chi fariseonaanau hirig magjierram: —Puan pʌchdëupaita wir haig pʌch jaau sim. Jãg pua jaau sim chan bʌ̃ʌrjã baleeba simgui hajierram, pʌchdëupaita pʌch jaau sĩewai. ");
INSERT INTO noaH_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Magbaawai Jesuu hamag magjim: —Muan mʌchdëupaita mʌch jaau chirab mamʌ, mua nem jaau chirʌmʌn chadcha balee simgui hajim. ¿K'an jãgwi mag chirʌ́? Mua mʌch bëetarr k'ap'ʌnaa mʌigmua petaau mʌch chiraimajujã mua k'ap'ʌ chiraawaita mag chirʌmgui hajim. Pari pãach hiek'õoin pãachdëun chad mʌ k'augba nʌmta mag mʌ jaau naabma hajim jũrr hamag. ");
INSERT INTO noaH_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pãraun pãachdëu hoowai magjöo habaawaita sĩi pãach k'ĩirjug heemuapaita mag chik'am jaaujemgui hajim. Pari mua pãar dënjö sĩi mag hõor jaauba chitʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Muata hõor jaau chirak'iin, sĩi mʌch happaimuata jaau chirʌm k'aba haawai muan chadcha nem hagchata jaaujugui hajim, hich mʌ pʌ̈itarrauta mʌ hipierr jaau sĩewai; hajapcharan hich mʌ Hayauma. ");
INSERT INTO noaH_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pãrag Moiseeu ley p'ã pʌarr gaai jaauwai, “Destignaan numiim k'ʌʌnauta chadcha nem hãba jaau nʌmʌn, mak'ʌʌnau jaau nʌm chadcha balee sim” ha sim. ");
INSERT INTO noaH_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mag ley gaai destignaan numiim k'ʌʌnauta hãba jaauju haai nʌm ha sĩewai, maar chi jaau nʌm k'ʌʌnjã numí naabahab: Dau hãb, mʌchpaiu; maimua hãbak'ai, mʌ Hayaugui hajim, chi mʌ pʌ̈itarr. Magua mua mʌch higwia mʌʌta mʌg durr gaai wënʌrrʌm k'ʌʌn hat'ee hõtdauu haawaijã chadcha balee simgui hajim, mʌch Haai dʌ̈imuata mag jaau chiraawai. ");
INSERT INTO noaH_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Magbaawai chi fariseonaanau, —Magan ¿jam sĩ pʌ haai? hajierram hirig. Magbaawai Jesuu, —Pãrau chan mʌjã k'augba, ni mʌ Haaijã k'augba nʌmgui hajim. Pãrau mʌ hoo naawai mʌ k'ap'ʌ naak'iin, hĩchab mʌ Haaijã k'ap'ʌ naak'amgui hajim, hi jãga sĩerrʌ́. ");
INSERT INTO noaH_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesuu mag hiek'amarr, Haai hi jëeujem deg ofrenda p'ëwi hag hãk'aajem haigta mag hiek'amajim, hichpai jaau simua. Pari hagt'a hi pʌr hauju hed k'aba harr haawai mag hichpai jaau sĩerr gaaimua hi pʌr haum hig narrjã hãbmuajã hi pʌr haubajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Maimua hag k'ur nʌʌpai hawi deeu hich Jesuupai haig narr k'ʌʌnag magjim: —Mʌ petaawai pãrau mʌ jʌrju, pari hãbmuajã mʌ baaubamgui hajim. Pãarta pekau hee wënʌrrʌmʌn, hich hag heepai pãar k'ëchwi mʌ mam haarjã pãar pöd barbamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mamʌ hirua mag simjã k'augba, chi judionaanau warag hamach k'apeenagta, —¿Wa juau hichdëupai hich t'õopʌ̈iju k'ĩirju sĩewaita mag hi sĩeimam haar pöd maach barbaju ha sĩwa? haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pari sĩi warag mag k'augbata jaau nʌm hũrwia Jesuu hamag magjim: —Mua pãrag mag chirʌmʌn, pãar mʌig heegarm k'ʌʌn haawai hich mʌig heegarpai nʌisijuuta jaau chirʌm. Pari mʌ hʌ̃gt'arm haawai deeu mʌch chirarr haar majugui hajim. Magnaa hamag, Pãar mʌg jẽb gayam k'ʌʌn k'abahab, pari mʌ chan pãarjö mʌg jẽb gayam k'abamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Maguata pãrau mʌʌta hich Hẽwandamau pʌ̈iju ha jaaujerr k'abampii hawia mʌ higbam chan, chaig mʌchdëu jaau chirarrjö, pãach pekau heepai k'ëchwi mʌ mam haarjã pãar pöd barbamgui hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mag hũrwia chi judionaanau hichigcha, —¿Magan pʌ k'aíuma? habaawai, hich Jesuupai deeu hamag hiek'amamua magjim: —Ya mua pãrag mʌch jaaujeewai, ¿k'an hatcha tag mua jaaubarju? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mʌch garmuan mua pãar jaauju hak'iin, jaauju pöoma chirʌm. Mamʌ magʌmta jaauba, hãba chi mʌ pʌ̈itarrau jaaupitarrpierrpaita jaau chitʌmgui hajim. Pãrau mʌ hiek hʌ̈k'amap'a naab mamʌ, mua jaau chirʌmʌn t'um chadcharaugui hajim, chi mʌ pʌ̈i simjã chadchata hiek'aajeewai. ");
INSERT INTO noaH_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pari mag hich Haai higwia par jajaauk'amjã pöd k'augbajierram. Mag hichdëu jajaauk'amjã k'augba habaawaita ");
INSERT INTO noaH_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","hamag magjim: —Jãg nʌʌ hawia ya pãachdëucha mʌch chi Hemk'ooi Hiewaa pakuls gaaicha meerp'ënaa jiirjop sĩubaawaita pãrau mʌ higwia, “Jãgan chadchata hich Hẽwandamau pʌ̈iju haajerr hajiebma, jãguata jãg sĩi hich k'ĩrau nem wauba haajeejim” hajurau. Maiguin chadau pãrau k'ap'ʌ hajugui hajim, mua hãba mʌch Hayau mʌchig jaaupimampaita hõragjã jaaujerr. ");
INSERT INTO noaH_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hich chi mʌ pʌ̈i sim mʌ dʌ̈i sĩewai, mua mʌch Hayau nem k'õsimpaita waaujeewai hirua sĩi mʌrʌg hoobamjöo haba haajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesuu mag hiek'abarm hũrwia hõor pöm hi hiek hʌ̈k'ajierram. ");
INSERT INTO noaH_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Maimua hich Jesuupai judionaan mag hich hiek hʌ̈k'atarr k'ʌʌnag magjim: —Pãarta jãg cha mua jaau chirʌm hiek pãachdëu hʌ̈k'abarmta hogdʌba hich mag mʌ hipierr wënʌrrʌmʌn, magan chadcha pãar mʌ k'apeenaugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mag hamʌn magan chadcharam hiekta pãrau k'augju. Mag chadam hiek pãachdëu hʌ̈k'abarmua ya tag pãar chik'am chogk'aba nʌisijugui hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Magbaawaita jũrr tagam k'ʌʌn hagjö haig narr k'ʌʌnau, —Maran jöoi Abrán chaain hewagam k'ʌʌnau; maar mag sĩi chik'aman chognaanjã k'aba nʌmgui hajierram. Mag nʌmta, ¿jãga pʌ hiek mag pʌ hiek hʌ̈k'abarmuata tag chik'am chogk'aba nʌisiju ha sĩ? hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Magbaawai Jesuu jũrr hamag, —Har pekau waaujem k'ʌʌnan chadcha t'um pekau chognaanaugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pãrau k'ap'ʌ nʌm, sĩi chik'am chogk'a p'idk'a sim chan, hich p'idk'a sim degam k'ʌʌn chaai k'aba haawai, ham dʌ̈i sĩerram hiek sĩerraba haajem. Pari chi dik'ʌ chaai magba, t'aababarwe ham chaaik'a sĩsierr hich mag ham dʌ̈i sĩsiejemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pekaúa pãar hich chognaanjö wai simta mʌch chi Hẽwandam Hiewaauta mag pekau jua heemua pãar höbeer hat'amʌn, ya tag hi chog k'aba, chadcha höbërm hiekta höbër nʌisijugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Magnaa, Mua k'ap'ʌ chirʌmgui hajim, pãar Abrán chaaink'a nʌm. Pari mag hi chaain hanʌmta pãachdëu mʌ hiek hũrmap'a nʌm gaaimua warag mʌ t'õopʌ̈imjã k'õsi nʌm. ");
INSERT INTO noaH_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Muan mʌch Haai dʌ̈i chiraawai hi dʌ̈i k'augtarrta pãrag jaaujem. Maagwai pãraujã hich hagjö pãach hayau pãachig jajaauk'amta waaujemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Magbaawai deeu hamachdëu, —Maar hayan Abranaugui hajierram. Mamʌ magbaawai hich Jesuu hamag, —Pãachdëu jaau nʌmjö pãar chadcha Abrán chaain hak'iin, hich Abranau haajerrjöta pãraujã haajeek'amgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pari magba haawai hich Hẽwandamaucha mʌchig jaautarrta meerba jaau chitaawaijã pãrau warag mʌ t'õopʌ̈im k'õsita haajemgui hajim. Abranau chan jãg pãar dënjö chik'am t'õoju hẽk'aba haajeejimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Magnaa, Pãar chan Abrán chaain k'abamjöta nʌmgui hajim. Maguata jãg pãach haai chi hãbak'aíu nem waaujemjöta pãachdëujã haajemgui hajim. Magbaawai hamachdëu sereu p'öbaadëwi, —Maar chan noo chaain k'abam. Maran haai hãbpaita wai nʌmgui hajierram: Hẽwandam. Hẽwandamta maar Haai charaugui hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Magbaawai Jesuu magjim: —Chadcha Hẽwandamta pãar Haai hak'iin, pãrau mʌjã daupii wai naak'amgui hajim, hich Hẽwandamau pʌ̈iwiata cha pãar dʌ̈i mag hiek'a hoo chiraawai. Mʌ chan sĩi mʌch k'ĩrau bëetarr k'abam; mʌʌn hich Hẽwandamaucha hich haarmua pʌ̈iwiata mʌg chitʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mag hijẽjẽbagmamua hich Jesuupai hamag, Mua k'ap'ʌ chirʌmgui hajim, jãgwi pãrau pöd mua jaau chitʌm hiek k'augba nʌ. Jãg k'augba nʌmʌn, pãachdëu hũrmap'amjö hũr naawaiugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Magnaa hamag, Pãar haai mepeer k'abahab hajim. Maguata pãar hi dënk'a naawai hirua nem jajaauk'amta waum k'õchk'aajerram. Mepeer warrgarwe hõor t'õomie k'abahab hajim. Hirua nem jaau sim chan bʌ̃ʌrjã chadam hiek k'abamta jaau sĩerrʌm. Hirua chadcha nem jaautarr chuk'um. Jãg hirua sëuk'a nem jaauwai hich k'apta jaauba haajeeb hajim, sëunem sĩerraawai. Magua hichta sëu paraam k'ʌʌn haaik'a sĩerrabahab hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pãach mag hi chaaink'a naawaita mua chadcha nem jaau chitʌmjã pãrau hʌ̈k'aba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pãar mʌg t'ʌnʌm hee, ¿k'aíu bʌ̃ʌrjã sëuk'aba mʌrʌg, “Pʌ pekau wai sim” haju haai sĩ? hajim hamag. Mʌ chan bʌ̃ʌrjã pekau chuk'u chitʌmgui hajim. Mag chitaawai muan chadcha nem hagchata jaau chitʌm. Pari magʌmjã ¿jãgwi pãrau hʌ̈k'aba haajemma? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Har chadcha Hẽwandam chaaink'a nʌm k'ʌʌnaun hi hiek hõrau jaau nʌm hũurwaijã hʌ̈k'am k'õsi hʌ̈k'aajerram. Pari pãar Hẽwandam chaain k'aba haawai pãrau hi hiek hʌ̈k'aba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mag hamachig, “pãar chan Hẽwandam chaain k'abamgui” habaawai, chi judionaanau hirig, —Chadchata pʌʌn jãgan Samariapierrau, maimua dösãtauta pʌ pör meu sĩebahab hajierram hichigcha. ");
INSERT INTO noaH_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Magbaawai Jesuu, —Mʌ dösãtau pör meuba chirʌmgui hajim. Mʌg chitʌm haiguin mʌʌn sĩi mʌch Haaita t'ö hiek'a chitʌm. Pari maagwai jũrr pãrau mʌ Haaijã högk'aba, warag mʌchta dösãtaujã pör meu chirʌm haajemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mʌ Hayaun chadcha hõraujã mʌrʌgta hee hapim k'õsi sĩeb mamʌ, mʌchdëu chan mʌrʌgta hee habat haba chitʌmgui hajim. Pari jãg pãrau mʌ hiseg nʌm paran hichdëuta pãar dʌ̈i hichdëu k'ap hajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Magnaa, Hĩs mua chadcha chi mua jaau chirʌm hipierraa sim woun chan t'õbaju ha chirʌmgui hajim hich Jesuu. ");
INSERT INTO noaH_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pari magbaawai chará chi judionaanau, —Hĩsta chadcha marau wajap'a pʌ k'ap'ʌ nʌm: Pʌʌn chadcha pör hee dösãt wai simuata mag hiek'api simgui hajierram. ¿K'ani Abranjã meewia maimua tagam k'ʌʌn hagjö Hẽwandam hi jaaujerr k'ʌʌnjã t'umaa hötarrta mag pʌ hipierraa nʌm k'ʌʌn chan k'ëchbaju ha nʌ? ");
INSERT INTO noaH_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Wa pʌʌta maar haai Abrán k'ararr k'ãaijã hatcha chirʌ́wa? hajierram. ¿Pua k'augbata sĩ hajierram, Abrán meewia tagam k'ʌʌn chi Hẽwandam hiek jaaujerr k'ʌʌnjã t'um hötarr? Magtarrta, ¿pʌ k'ai hagá hajierram hirig, mʌig maar hee mag pʌch t'ö hiek'acheeg? ");
INSERT INTO noaH_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Magbaa Jesuu, —Mua mʌchdëupaita mʌch t'ö hiek'ak'iin, mua mag mʌch t'ö chirʌmjã bʌ̃ʌrjã baleeba simgui hajim. Pari chadcha chi mʌ t'ö hiek'anaa mʌchta t'umaam k'ʌʌn k'ãaijã hʌ̃rpai hapi simʌn hich mʌ Hayaugui hajim. Wajapcharan har pãrau hi higwia pãar Hẽwandam haajemma, jãguata t'umaam k'ʌʌn k'ãaijã mʌchta hʌ̃rpai hapi simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mag pãachdëun, hiita pãach Hẽwandam hanaab mamʌ, pãrau hi k'augba nʌmgui hajim. Muan chad hi k'ap'ʌ chirʌm. Mua chadcha hi k'ap'ʌ chirʌmta hi k'augbam hak'iin, maiguin mʌʌn sëunem pãar dʌ̈i hãbata chirʌm. Pari mua chadcha hi k'ap'ʌ chitʌm; magua mua hi hipierraata nem waaujemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pãar jöoi Abrán honee hajim, Hẽwandamau hichig chaai deebarmua jũrr chaain hĩiubaadeeu hewag paawai mʌ bëejujã k'ap'ʌ sĩerr haawai. Maimua ya chadcha mʌ pierrum hoobaawaijã hi honee hajimgui hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Magbaawai chi judionaanau hich Jesuug, —Mag hiek'a sim chan hagt'a cincuenta añojã k'aba sim. Mag simta, ¿mag pua Abrán hoojim ha sĩ? hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Magbaa hich garmua, —Mʌʌn Abrán t'aabaju nawe hich mag chirajimgui hajim hamag. ");
INSERT INTO noaH_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hamachig magbaawai chará ya mokou hi baraag hẽk'a naajim. Pari mag nʌm hee, sĩi hich hiiu haawai, hõor hee t'eerbabag warag hichta daaupabaadëjim, Haai hi jëeujem degmua. ");
INSERT INTO noaH_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mag hich mokou baraag hẽk'a nʌm hee, Haai hi jëeujem degmua höbërwia Jesuu woun hãb bi heewe dau k'ĩsu t'aabatarr hooimajim. ");
INSERT INTO noaH_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mag hoobaimaawai maach hi dʌ̈i hogdʌba wënʌrraajerr k'ʌʌnauchata marau maach Maestroog jëeujim, hajapcharan hich Jesuugma, jãgwi mag woun dau k'ĩsu t'aabajĩ: ¿hich dënnaan pekau gaaimua hajĩ, wa hichdëucha pekau wautarr gaaimua hajĩ? ");
INSERT INTO noaH_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mag hichig jëeubaawai Jesuu magjim marag: —Jã chan hich pekau gaaimua k'aba, ni hich dënnaan pekau gaaimuajã k'abajimgui hajim. Jãg t'aabatarran, jãan jãg dau k'ĩsu sim gaaimua Hẽwandamau hich jua t'eeg hõrag hoopiegta jãg t'aabapijimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Magnaa marag, Pãrau k'ap'ʌ nʌmgui hajim, hãsdaaupaita p'idk'aajem. Hedau k'ëubaadeewai tag p'idk'aba haajem. Hich hagjöta simgui hajim, Hẽwandamau nem waupi sim wawaagjã. Magua muajã mʌch meebam haig chan jua hʌ̃ʌijem hed hawiajã mʌch pʌ̈itarrau jaaupʌ̈itarr p'idag pʌaba hich mag wau chitajugui hajim. Magbamʌn mʌg chitawi mʌ meebaadeewai ya tag magʌm p'idag wauju k'aba haadëjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mʌʌta mʌig heegar mʌg jẽb gaai chirʌm haiguin mʌchta hõor hat'eem hararagaugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Maimua mag hiek'anaa, jẽb gaai hichö t'unaa, mag hichö heepai jẽb wãwak'a waunaa, hagua chi dau k'ĩsu k'itarr dau p'uurpʌ̈ijim. ");
INSERT INTO noaH_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Mag p'uurpʌ̈inaa hirig, —Jãimua Siloé hee mawia pʌch dau sũgbapʌ̈imí hajim. Mag t'ʌrrdö Siloé hanʌm maach meúan “pʌ̈itarr” ha simʌu. Hichig mag jaaubaawai chadcha chi dau k'ĩsu k'itʌmua mawia hich dau sũgbapäaiwai daujã wajaug haadëjim hanaabá. Mag, hag na dau k'ĩsu k'aba sĩerrjö dau monakk'a hich di haar barjim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mag daujã wajaug sĩsim hoobaawai hi dʌ̈i di dak'a naajerr k'ʌʌnau maimua hag nawe sĩi dich nʌm k'ʌʌnag hi nem hinagdam jëeu sim hoojerr k'ʌʌn dʌ̈imua hamach wir haigpai, “¿Ma, jã har dau k'ĩsu k'itarr sĩi hõor dich nʌm k'ʌʌnag dau hap'ʌʌ nemdam jëeujerr k'abamá?” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Magbaawai hãaur k'ʌʌnau, “Chadcha, hichma” hanʌm hee, jũrr bigaaum k'ʌʌnau, “Hãhã, jã chan har k'abam, sĩita harjöo simgui” haajeejim haajem. Pari magbaawai hamau mag nʌm hee, jũrr hichdëu, “Mʌ hich har k'abahab” haajeejim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hamachig magbaawai, —¿Magan jãga jãg pʌ daujã wajaug haadëjĩma? ha jëeujeejim hanʌm hamach garmua. ");
INSERT INTO noaH_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Magbaawai hichdëu, —Jãan woun hãb har Jesús haajemuata hichö hee jẽb wãwak'a waunaa, hagua mʌ dau p'uurnaa mʌrʌg, “Chum Siloé hee mawia pʌch dau sũgbapʌ̈imí” habaawai, chadcha mua hi hipierr mawia mʌch dau sũgbapäaiwaita chadcha mʌ daujã wajaug haadëjimgui haajeejim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Magbaawai deeu hamachdëu hirig jëeumamua, —¿Jam sĩ mag pʌ dau monaautarr woun? habaawai, —Mua k'augbam jam sim k'ai haajeejim hanʌm hichdëu. ");
INSERT INTO noaH_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Pari Jesuu mag hichö jẽb hee waaurëunaa woundam dau k'ĩsu k'itarr monaautarr jua hʌ̃i k'eeujem hed harr haawai fariseonaan haar hi warrjierram haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mag hamach haar wai barbaimaawai hirig jëeumamua, —¿Jãga jãg pʌ daujã wajap'a chirsijĩ? hajierram hanʌm. Magbaawai hi hiek hirua jaaubaadëwi, —Hichö hee jẽb waaurëunaa mʌ dau p'uurpʌ̈inaa, hʌpi jaaubaawai, hi hipierr hawiata mua wajap'a hoo chirsijimgui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hirua magbaawai chi fariseonaan hee hãaur k'ʌʌnau, —Chi pʌ dʌ̈i magtarr woun chan magan Hẽwandamau pʌ̈itarr k'abam; maguata mʌg jua hʌ̃ʌijem hedjã hʌʌrk'aba simgui hajierram haajem. Pari maagwai jũrr hãaur k'ʌʌnau, —Pari hi Hẽwandamau pʌ̈itarr k'aba hak'iin, ¿jãga hirua jãg Hẽwandam jua t'eegau hõor monaaubarju? Pekau paraam k'ʌʌnau chan pöd hi dënjö jãgbamgui haajeejim hanʌm. Hamach magp'öbaadëm gaaimua warag hamach heepaijã hihãba hiek'aba nʌm hiek'au ");
INSERT INTO noaH_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","warag chi dau k'ĩsu k'itarragta, —Pua k'ĩirjuawai ¿k'anim woun hagá? Pʌ dauta hirua monaautarr haawai puata hi jaauju haai chirʌmgui haajeejim hanʌm hirig. Magbaawaita hichdëu, —Mua hoowai merag chuk'u sim, jãan hich Hẽwandam jua t'eegau nem wau nʌrrʌmta jãg nʌrrʌmgui hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pari mag dau k'augba k'itarrta dau wajap'a monaau sĩsimjã judionaan chi pörnaanau hʌ̈k'amap'a naajim hanaabá. Mag hʌ̈k'amaaugau, hi hiek warag hi dënnaanta t'ʌ̃rk'a hauwi hamagta, ");
INSERT INTO noaH_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Chadcha mʌg woun pãar chaairá? hajim hanʌm. ¿Pãachdëujã pãrau chadcha bi heeweta dau k'augba t'aabajim hanʌ́? Magtarrta ¿jãga hĩs jãg dau wajap'a hoo simma? ha jëeujierram haajem chi dënnaanagcha. ");
INSERT INTO noaH_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Magbaawai chi dënnaanau, —Hi chadcha maar chaai k'abahab; haauwai chadcha bi heeweta dau k'ĩsu k'itabajieb hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pari hi dau monaautarr chan marau k'augba nʌm, jãga hawiata hĩs jãg dau wajap'a sĩsi, ni k'aíuta hi dau monaaubarm k'ai. Hichigchata jëeubat hajierram hanʌm. Ya hi chi jöoi haawai hichdëuta hirua pãrag jaauju haai sĩebá hajierram haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pari hamau jaaumap'a magpai jaau narran, har Jesús higwiata chadcha hich warrgarwe pʌ̈iju haajerrta jãg nʌrrʌm ha hiek'a nʌm k'ʌʌnan judionaan chi t'et'em k'ʌʌnau Hẽwandam hiek jaaujem degjã tag dubpiba haag ya hibëp nʌm k'ap'ʌ narr haawaita magpai jaau naajim hanaabá. ");
INSERT INTO noaH_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Maguata hamau sĩi, “Hichigta jëeubat, ya hi chi jöoi k'abahab hichdëucha pãrag k'ap jawaag” haajeejim haajem warag chi fariseonaanagta. ");
INSERT INTO noaH_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Magbaawai hi hiek chi t'et'emnaanau deeu hichchata t'ʌ̃r haunaa, —Chadcha Hẽwandam dak'ĩir meerba marag jaaubá hajierram hanʌm. Hoob Jesuuta pʌch monaaujim ham. Marau k'ap'ʌ nʌmgui hajierram hanʌm, jãan pekau pöm sĩerrʌm. ");
INSERT INTO noaH_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Magbaawai hichdëu, —Mua chan k'augba chirʌm, hí mag pekau pöm sĩ wa pekau chuk'u sĩ ha chirajim haajem hirua. Hãba mua k'ap'ʌ chirʌmʌn, warr chadcha mʌ dau k'ĩsu chirajim, pari magtarrta hĩs mua wajap'a hoo chirʌm. Maata mua k'ap'ʌ chirʌmgui hajim hanʌm hamag. ");
INSERT INTO noaH_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Magbaawai hũwaai hamachdëu wajap'a jëjëwagmamua, —¿Ma jãga hajĩma pʌ dʌ̈i? ¿K'anta jãgjĩ pʌ dau heerdʌpieg? hajierram hanʌm hirig. ");
INSERT INTO noaH_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Magbaawai hichdëu, —Ya k'abá mua pãrag jaaubarmgui hajim hanʌm. Magʌmjã pãrau hʌ̈k'ab nʌm. Mag nʌmta ¿k'an hatchata deeu hũwaai jaaupi nʌmma? ¿Wa mag jaaubaawai hi hiek hʌ̈k'awia pãachjã hi k'apeenk'aagwa? hajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Magbaawai hirig hich k'ĩircha hiek'a t'ʌnʌʌuwia magjierram haajem: —Pʌchin pʌ hi higar chirama; pari maran Moisés higarta nʌm. ");
INSERT INTO noaH_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Marau k'ap'ʌ nʌmgui hajim hanʌm, Moiseegan hich Hẽwandamauchata hiek'ajim; pari jã chan marau k'augbamgui hajierram haajem, jammuata jãg nʌrraichëjim k'ai. ");
INSERT INTO noaH_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Magbaata hirua mag chirajim haajem: —Hʌ̈k'abam. Magan pãrau chan k'augba naabma hajim hanʌm, jammuata hi bëejĩ; pari mag simuata mʌ dau monaaupʌ̈ijim. ");
INSERT INTO noaH_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Maadëu k'ap'ʌ nʌmgui hajim hanʌm, sĩi parhooba pekau pömk'am k'ʌʌn hiek Hẽwandamau hũrba haajem. Hirua hũurjemʌn, hichig jëeunaa hich hipierraa nem wau nʌm k'ʌʌn hiekta hũurjem. ");
INSERT INTO noaH_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pãraujã k'ap'ʌ nʌmgui hajim hanʌm, bʌ̃ʌrjã hag na hõrau mʌg mʌjö bi heewe dau k'ĩsu t'aabatarr k'ʌʌn dau wajaug paa hau nʌm hanʌm hũrba haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mʌg mʌ dau wajap'a hapitarr woun hich Hẽwandamau pʌ̈itarr k'aba hak'iin, hirua jãgʌm nem pöd wauba haajeek'amgui hajim haajem hamag. ");
INSERT INTO noaH_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hamachig magbaawai sereu p'öbaadëwi hirig, —Pʌ sĩi dau haug pekau pöm t'aabatarrta, ¿k'ani mag sĩma? ¿Wa puata maar k'ãaijã k'apcha sĩwa hajierram hanaabá, marag jawaag? Maimua tag Hẽwandam hiek jaaujem degjã dubpiba, warag hamach haigmua hi jʌrpʌ̈ijierram haajem. ");
INSERT INTO noaH_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chi judionaanau mag woundam dʌ̈i magtarr Jesuu k'aug hat'ajim. Maimua hag k'ur chi woundam hoobaimaawai hich Jesuu hirig, —¿Pua chadcha Hemk'ooi Hiewaa hiek t'ãraucha hʌ̈k'a chirʌ́? ha jëeujim. ");
INSERT INTO noaH_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Magbaawai jũrr hichdëu, —Señor, ¿ma k'aiuma? Mʌrʌg wajap'a jaaubá hajim, mua k'ap'ʌ haadeewai hi hiek hʌ̈k'aag. ");
INSERT INTO noaH_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Magbaawai, —Pari ya k'abá pua mʌ hoo sima; mʌchta pʌ dʌ̈i hiyʌ̈ʌ chirabahab hajim jũrr hich Jesús garmua hirig. ");
INSERT INTO noaH_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jesuu hichig magbaawai, hi k'ĩirp'ee t'ʌk'öonaa hirig, —Señor, hĩsin mua chadcha k'ap'ʌ chirʌmgui hajim, pʌʌta hich Hẽwandamau pʌ̈itarrau. ");
INSERT INTO noaH_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Magbaawai Jesuu hirig magjim: —Mʌ bëetarran, k'aíuta chadcha Hẽwandam hiek hʌ̈k'a sĩ wa k'aíuta hʌ̈k'aba sĩ ha k'ap hamk'ĩirta bëejimgui hajim. Har dau k'ĩsu k'it'ëem k'ʌʌnjö hamach k'aibag hee nʌm k'ap'ʌ nʌm k'ʌʌn peerdʌ haunaa hĩchab har jũrr wajap'a nʌm hanʌm k'ʌʌnta hamach pekau gaaimua k'ĩchag heemjö nʌm jawaanta bëejimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesuu magbarm hũrwia fariseonaan heem hãaur k'ʌʌn haig narr k'ʌʌnau hirig, —Pʌrʌgan magan maran dau k'ĩsuta naabma hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Magbaawai Jesuu, —Pãar chadcha dau k'ĩsu naawaita jãg naak'iin, pãar pãach pekau gaaimua kulp pömcha k'aba naak'amgui hajim. Mamʌ magba pãar hiek mag wajap'a k'ap'ʌ nʌm hanʌmta juau jãg nem k'aigba waum k'õchgau mʌ higbam gaaimuata, pãar Hẽwandam dʌ̈i hiekk'õr pöoma nʌmgui hajim Jesuu hamag. ");
INSERT INTO noaH_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Maimua mag hiek'amamua Jesuu hamag mʌg ejemplo jaaujim: —Har oveja p'ãark'a t'ʌnʌm haar dubaag hẽk'a simta puertdi garmua dubba sĩi chi t'uur p'ʌʌrdʌ sim hʌ̃rta waaidʌ dich sim wounan, maan sĩi nem jĩgmie haawaita mag simgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pari magba puertdi garmuata dub simʌn, ma chi pastorrau, chi t'ʌa. ");
INSERT INTO noaH_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Magʌg mag chi oveja hierr p'ãark'a t'ʌnʌm puertdi haig simuajã hʌdʌraa dubpijugui hajim. Mag dubwi chi pastor hamach hoo p'ë wai nʌrraajemua haawai hamach t'ʌ̃r gaai t'ʌ̃rbaimaawai hamachdëujã hi k'aug haaujerram. Mag warag dawag p'ë harrwia ");
INSERT INTO noaH_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ya t'um daau paauk'abaadeewai, ham na dʌnʌisie hamachdëujã hi hẽudee weetjemgui hajim, ya hamach hich mag p'ë wai nʌrraajem dʌ̈i haawai. ");
INSERT INTO noaH_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pari magba jũrr hõor hamachdëu k'augbam k'ʌʌnauta ham t'ʌ̃rchëk'iin, mag dʌ̈i chan wëtba, warag parhoobata k'ap'ig p'öbaadëjugui hajim, hi hökgau. Hamau hamachdëu hõor k'augbam k'ʌʌn hiekjã k'ap'ʌ haajemgui ha jaaumajim Jesuu. ");
INSERT INTO noaH_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesuu mag hamag jaaumarran, jãg chi oveja t'ʌajemua hich nemchaain hoopaar p'ë wai nʌrraajemjö hiruajã hich hiek hʌ̈k'a nʌm k'ʌʌn dʌ̈i hich hagjöta haajem ha sim hajim. Pari mag jaaumamta haig hi hiek hũr narr k'ʌʌnau pöd k'aug hauba, sĩi oveja chaarta jaau simpii naajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Maimua deeu hich hag hiekpai higwia Jesuu hamag, —Muan chadcha pãrag, “Mʌʌta mak'ʌʌn oveja duubjem puertdiiu” ha chirʌmgui hajim, hõor hi hiek hʌ̈k'a nʌm k'ʌʌnan hi gaaimuata hʌ̃gt'arjã höbërju higwia. ");
INSERT INTO noaH_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Maimua chi fariseonaan k'ĩir hiek'amamua, ’Har mʌ bëeju nawe sëuk'a hamachdëupai hamauta Hẽwandam hiek jaau nʌm hawia sĩi hõor k'ũgurnaa hamachigta hee hapiejem k'ʌʌnan nem jĩgk'amienaugui hajim. Pari jãg oveja charau hamachdëu hõor k'augbam k'ʌʌn hiek hasekasba haajemjö, mʌg chadcha mʌ hiek hʌ̈k'a nʌm k'ʌʌnau chan par ham mag sëuk'a wënʌrrajieb mamʌ, ham hiek hasekasbajierramgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Magnaa hamag, Mʌʌta puertdi charau; chi mʌ hiek hʌ̈k'a nʌm gaaimuata peerdʌ nʌm k'ʌʌnan chadcha mʌ dënk'am hiekta mʌ dënk'a nʌisimgui hajim. Chi mag nʌisim k'ʌʌnagan, jãg chi pastorrau hich nemchaain wajap'a hoopaar p'ũak k'öpi wai nʌrraajemjö, muajã hĩchab ham t'ʌa wai chitajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Pari magba har sëuk'a chik'am k'ũguurjem k'ʌʌnan, chik'am hõorta jũrr hamachig paa haumam gaaimua chik'amnaan ovejata jĩgk'a haumamjö sĩerrjëemgui hajim. Mag nʌmʌn pari sĩi hamach hiek hʌ̈k'abarmuata chadcha peerdʌju ha jaauwai warag hʌdʌʌr hʌ̃gt'archa höbërpiejem hiekjã hũrpiba, hõor k'ĩirjug hãrpʌ̈i nʌmta mag nʌrrjëe haajemgui hajim. Mamʌ mʌ chan ham dënjö magaagta bëebajim. Mʌʌn sĩi mʌchdëu Hẽwandam hiek jaau chitʌmta hʌ̈k'abarmʌn, hich mag hi dënk'a wënʌrranaa mʌig heegarwejã honee hamk'ĩirta bëejimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Magnaa, Mʌʌta Pastor chaar chi wajapcharamʌugui hajim. Pastor chi wajap'am habarmʌn hich nemchaain peerdʌ hawaagjã hichta hʌdʌraa t'õopiejemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pari magba har pastor hanʌm k'ʌʌnjã sĩi p'atk'on hat'eepai t'ʌnʌm k'ʌʌnan, lobou nemchaain pʌraan hurum hoowaijã warag hamachta k'ap'igbaadeejem. Hamach nemchaain k'aba haawai bʌ̃ʌrjã ham gaai mas k'aba sim. Mag warag parhooba nemchaain dau hap'ʌʌ haaidʌpiejemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mag warag pastornaan hanʌmta hamachdëupa högk'awia k'ap'ig p'öbaadeejemgui hajim, nemchaain t'ʌam k'õchgau k'aba sĩi p'atk'on hat'eepaita naawai. ");
INSERT INTO noaH_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Maimua mag hiek'amamua deeu hichdëupai, ’Mʌʌta Pastor chaar chi wajapcharamʌugui hajim hich higwia. Hich jãg mʌ Hayau wajap'a mʌch k'ap'ʌnaa muajã mʌch Haai k'ap'ʌ chitʌmjö, mʌch higar nʌm k'ʌʌnjã mua k'ap'ʌ chitʌm; maagwai hamachdëujã mʌ k'ap'ʌ haajemgui hajim. Chadcha mʌch dën haawai mua ham kõit hʌdʌraa mʌch t'õopijugui hajim, ham peerdʌ hawaag. ");
INSERT INTO noaH_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pari hagjö deeum k'ʌʌn t'ʌnʌmgui hajim, mʌg israelnaan k'abam k'ʌʌn. Mak'ʌʌnjã mua hãbamʌg jʌr p'ë haujugui hajim, hamaujã mʌ hiek hũrbaawai hʌ̈k'amk'ĩir. Mag, israelnaan dʌ̈i pap hãbam dënk'a nʌisiewai mʌchta ham Pastork'a chitajugui hajim, hamach t'um hãba t'ʌa wai chitaag. ");
INSERT INTO noaH_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Magua, mag pastor wajap'amjö hõor kõit hʌdʌraa mʌch t'õopiju haawai mʌ Hayau mʌ daupii wai simgui hajim. Pari mag hʌdʌraa mʌch t'õopiwiajã deeu hiiu p'iidʌjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mag mʌch t'õopiju ha chirʌm chan, hajués chik'amnauta mʌrʌg magpi naawai k'aba, mʌch k'ĩrauta hõor kõit mʌch t'õopijugui hajim, ham peerdʌ hawaag. Mʌ Hayau mʌrʌg magta hapitarr haawai mua chadcha hʌdʌʌr mʌch t'õopiju haai chirʌm. Pari deeu hũwaai mag hiiu p'iidʌagjã jua t'eeg chirʌmgui hajim ham jʌ̃g daar. ");
INSERT INTO noaH_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Pari chi judionaan chi pörnaanau Jesuu mag hiek'abarm hũrbaawai, hamach pem haawai, deeu hũwaai sĩi chum haaip'ur hiyʌ̈ʌ hihãbajã k'aba nʌisim hiek'au, ");
INSERT INTO noaH_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","k'apank'am k'ʌʌnau warag hamach k'apeenag, —¿K'ant'ee pãrau hi hiek hũr nʌma? Jã sĩi hich pör hee dösãt bën wai simua lököo sĩewaita mag hiek'a sĩebahab haajeejim, chi Jesús higwia. ");
INSERT INTO noaH_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pari magbaawai hãaur k'ʌʌnau mag nʌm hee, jũrr warm k'ʌʌnau, —Pãar dak pör hee dösãt bën paraam k'ʌʌnau hi dënjö mag hiek'ajupa hanaajim. ¿Wa pãrau k'ĩirjuawai meperau dau k'ĩsum k'ʌʌnjã daujã wajaug hapiju haai sĩwa? haajeejim, hich Jesuu bi heewe dau k'ĩsu t'aabatarr monaautarr higwia. Jesuu mag hiek'atarr mag p'iesta Las Enramadas hanʌm dichtarr k'ur hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Maimua hag k'ur nʌʌ hawia Jerusalén p'öbör hee deeum p'iesta wau naajim, Haai hi jëeujem di hëu haaipawia di t'eert'ʌgtarr p'iesta. Magtarrta hewag pawiajã hich hag hedau paawai hich mag p'iesta waaujeejim. Mag p'iesta noseg jaar hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Maigta Jesús p'ʌʌrdʌ nʌrrajim daaugajãr Haai hi jëeujem di bigaau, “Pórtico de Salomón” ha t'ʌ̃r sim hee, dijãjö nem pöm wëu wëjöm hee. ");
INSERT INTO noaH_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hi mag nʌrrʌmta judionaan k'apan hi haig pos haichëwia hirig, —¿Jãagwaita pua marag meerba pʌch jaaujuuta jãg sĩma? Pʌʌta chadcha warrgarwe hich Hẽwandamaucha pʌ̈iju haajerr k'ai, warre marag jaaubá hajierram, marau k'ap haag. ");
INSERT INTO noaH_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Magbaawai hich Jesuu hamag, —Mua k'abá ya pãrag jaaubarm, pari pãrau hʌ̈k'amap'a nʌmgui hajim. Mʌ Hayau mʌchig waupitarrjö wau chitʌm hoo nʌm gaaimua pãrau k'ap'ʌ haju haai nʌm, mʌ chadcha hichdëu pʌ̈itarr. ");
INSERT INTO noaH_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pari chaig mʌchdëu jaau chirarrjö, pãar mʌ higar k'aba naawai, mua mag mʌ Hayau mʌ pʌ̈ijim ha jaau chirʌmjã pãrau hʌ̈k'aba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chadcha mʌ dënk'a nʌm k'ʌʌnaun, jãg ovejanaanau hiek gaaipai hamach pastor k'aug haaujemjö, mʌjã k'ap'ʌ nʌm, mʌ k'ai hagá; maagwai mʌchdëujã mua ham k'ap'ʌ chitʌmgui hajim. Mag mʌ k'ap'ʌ naawai mʌʌta ham na dʌnʌisimʌn, hamachdëujã mʌ hẽudee weetjemgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Magbaawai mʌchdëuta mʌch Haai haar ham höbërju haai hapiejem, tag hok'ooba sĩi hi chaaink'a hich mag wënʌrramk'ĩir. Ya magbarm chan ni hãbmuajã mʌ jua heem k'echt'ʌg haubamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mʌ Haai hichta t'umaam k'ʌʌn k'ãaijã hʌ̃rpai sĩerrʌmuata mʌrʌg mak'ʌʌn deejimgui hajim. Mag hichta hʌ̃rpai sĩerrʌmua deetarr haawai hãbmuajã hi jua heemjã pöd k'echeubamgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Magnaa, Mʌ mʌch Haai dʌ̈in maran hich hãbampaiugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hamachig magbaawai chará chi judionaan hũwaai sereu p'öbaadëwi deeu hi mokou barm hig naajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pari mag nʌm hee Jesuu hamag magjim: —Mʌ Hayau hich jua t'eeg mʌrʌg deetarrau mua chadcha pãar dak'ĩir nem wajap'am pöm k'ĩir pogk'e wauwia chirʌm. Pari mag nem k'ĩir pogk'e wautarr hee, ¿chijãg gaaimuata pãrau mʌ mokou barm hig nʌ? hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Magbaawai chi judionaan chi pörnaanau, —Marau chan mag pua nem wajap'a waaujem gaaimuata pʌ mokou baraagpam haba nʌm. Marau chadcha pʌ mokou barm hig nʌmʌn, pʌch hiek gaaimuapaita pʌ barm hig nʌmgui hajierram hirig, mʌg maach hãba t'um hagdaujöpai t'ʌnʌmta pʌ hiek mag pʌʌn Hẽwandamau hanaawai. ");
INSERT INTO noaH_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Magbaawai hich Jesuu hamag, —¿Pãrau hoowai mua magju k'aba chirʌ́? hajim. ¿Pãrau k'ĩir heyaa k'aba nʌ, har Hẽwandamau pãar jöoinag hich hiek p'ãpitarr gaai, “Pãran hẽwandamnaanau” ha p'ã sim? ");
INSERT INTO noaH_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Hirua magtarran hich hi jaaumk'ĩir jʌr hautarr k'ʌʌn higwiata mag sĩejimgui hajim. ¿Pari mak'ʌʌnjã hagjö mʌig heegarm k'ʌʌn k'abajĩ? Magua maadëu k'ap'ʌ nʌmgui hajim, hich Hẽwandamauta mag p'ãpitarr haawai mua mag mʌʌn Hẽwandam Hiewaau ha chirʌm haig pãrau mua k'aigba hiek'a chirʌm haju k'aba nʌmgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hich Hẽwandamauta hich haarmua mʌ jʌr hauwia mʌg jẽb gaai pʌ̈itarrta, ¿jãga pãrau mʌrʌg mag mua k'aigba hiek'a chirʌm habarju, mua Hẽwandamag Haai hicheewai? ");
INSERT INTO noaH_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Pãachdëu hoowai mua mʌch Hayau nem waaujem k'ĩir waubata chirʌm k'ai, magan hoob mʌ hiek hʌ̈k'amiet hajim. ");
INSERT INTO noaH_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pari pãachdëu hoowai muajã hirua nem waaujemta wau chirʌm k'ai, mʌ hiek hʌ̈k'aba hawiajã k'ap'ʌ habat hajim: hich Hẽwandam chi Haaijã mʌ dʌ̈i sim, maagwai mʌchjã mʌch Haai dʌ̈i chirʌm. ");
INSERT INTO noaH_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pari hich Jesuu magbaawai hũwaai hi pʌr hauju hẽk'ajierram. Pari hich pʌr haupiba, hʌ̈u peerdʌ k'eerbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Maimua mawia hag na Juan chi hõor pör choomieu Jordán hee hõor pör choo sĩerr gar dʌrbawia maig sĩsijim, hedau höbeerjem gar. ");
INSERT INTO noaH_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mag hi maig sĩeimaawai hõor pöm hi haar wëtwia hamach heepai, —Keena, chadcha Juanau chan mʌg Jesús dënjö hag na hõrau nem hooba haajemjã wauba k'itajim. Mamʌ hirua hich mʌg woun higwia nem jaaujerran, chadcha t'umaa hich hag heeta jaaumajimgui hajierram. ");
INSERT INTO noaH_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Maig hirua Hẽwandam hiek jaau sim hũrwia hõor k'apank'am k'ʌʌnau hi hiek hʌ̈k'ajierram. ");
INSERT INTO noaH_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Biek hãb p'öbördam Betania hanʌm hee woundam Lázaro hanʌm mor machpajim haajem. Hich Lázaro hʌ̃p'ʌʌin numí wai sĩejim, María Marta dʌ̈i. Mak'ʌʌn dʌ̈ita sĩejeejim hich. ");
INSERT INTO noaH_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hich mag Lázaro hʌ̃p'ʌi Mariaau hajim, maach Pör Jesús bʌ̈ hʌ̃r jʌ̃gdeeu choonaa hich pörbʌ̈ʌupai jʌʌupʌ̈itarr. ");
INSERT INTO noaH_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mag hamach hẽp'emk'öi mor machpawia warag heeg pamaawaita hamach numiim k'ʌʌnau hõor jʌr hauwia hich Jesús haig pʌ̈ijierram, jawaan mamk'ĩir. Magbaawai chadcha bëewia, —Señor, pʌ k'apk'ʌʌn chi wajap'am pua hʌ̃rcha hiigjemjã pödba k'ërʌmgui ha jaauchëjim Jesuug. ");
INSERT INTO noaH_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pari hichig mag jaaubaa sĩi warag, —Jãg k'amor machagau chan hi meem hiek meebamgui hajim. Jãan sĩi jãg k'amor machag gaaimua Hẽwandamta t'umaam k'ʌʌn k'ãaijã hʌ̃rpai sim hanaa mʌchjã hi Hiewaa haawai hagjö chirʌm ha k'ap hamk'ĩirta jãgpijimgui hajim hich Jesuu mag hichig hiek jaauchëtarrag. ");
INSERT INTO noaH_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesuu chadcha Marta dʌ̈i Mariajã hoomap k'aba ni hich Lazarojã hoomap k'aba haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mamʌ mag simta mag Lázaro mor mas sim hichig jaaubaichëmjã maba, warag k'ãai numí mag maach narr haig sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Maimua hag k'ur ya k'ãai numí naata marag hichdëu, —Deeu Judeaag wëttarraugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Magbaawai marau hirig, —Maestro, ¿hĩschapai hich jamaam k'ʌʌnau peer pʌch mokou bar t'õotarr k'ʌʌn haarta deeu pʌ mam hig sĩ? hanaajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Magbaawai jũrr hichdëu marag, —Pari hagt'a hamau mʌ t'õoju hora k'aba sĩebahab hajim. ¿Pãrau hoowai mʌg hedau hãspapak'am doce horas sĩeba haajẽ? hajim. Hãsdawan maach dichmam haig mawiajã bʌ̈ waaur t'ʌt'ʌgag maba haajemgui hajim, hãsdaau haawai. ");
INSERT INTO noaH_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pari maach hedaarta chitaju hat'een, sĩi bʌ̈hëu subaadeeu k'ãijã buudimajugui hajim, k'ĩchag hee haawai. Mag hagt'a hag hora k'aba sĩewai hararagagta chitʌmjö hõrau mʌ chig habajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Maimuata sĩi hawia, —Maach k'apk'ʌʌn Lázaro ya k'ãibaadëm; pari mua deeu hi p'iriupäain majugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Magbaata marau hirig mag naajim: —Señor, mag k'ãibaadëm k'ai, magan hʌ̈u hi k'ĩirdam hinaa haadëm. Mag k'ai magan hʌ̈u pör k'oordʌjugui hanaajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pari Jesuu mag Lázaro k'ãibaadëm ha sĩerran, maan hiin ya hi meebaadëmta jaau sim hajiebma. Pari mag simta maraun k'augba, sĩi k'ãai chaar k'ãibaadëmta jaau simpii naajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Maimuata ya warre marag, —Lázaro meejimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pari hʌ̈uta mʌ hi haar k'aba chirajimgui hajim. Magba hak'iin nau jãg chi mee sim mua pãach dak'ĩir p'iriu haujujã hoobak'am. Mamʌ chadcha Hẽwandam jua t'eeg mʌ gaai sim k'ap hamk'ĩir, hi haarcha hoon wëttarrau hajim marag. ");
INSERT INTO noaH_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mag hirua hoon wëttarrau habaawai maar heem hãb maar k'apeer ham dën hibʌʌr wauwia Meís ha t'ʌ̃ʌrjerrau, —Keena, magan maachjã hi dʌ̈i wëttarrau hajim, hi dʌ̈i hãba k'ëchimaag. Hirua mag sĩerran, Judeapienau peer hich Jesús t'õotarr haarta deeu högk'aba maagpam higwiata mag sĩejim. Mag Meís hanʌm, hi t'ʌ̃r chaar Tomás hajim. Mag, chadcha Jesús mam dʌ̈i maarjã hi dʌ̈i wëtjim. ");
INSERT INTO noaH_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mag wëtwia hũrimaawaijãh, ya k'ãai jayap sim ha jaau naajim, chi Lázaro hauk'ërtarr. ");
INSERT INTO noaH_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mag chi meetarr p'öbör Betania hanʌm Jerusalén dak'a kilómetros t'ãrjupjö sĩejim baraag. ");
INSERT INTO noaH_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jerusalenmua mag dak'a sĩewai judionaan k'apan weetjeejim haajem, Marta María dʌ̈i nʌm haar, mag hamach numpai hap'öbaadeewai hamach hẽp'emk'öi k'ĩirjuwia hatcha gaai machgau hök'ĩirjuu hapimaaugau hawia. ");
INSERT INTO noaH_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mag nʌm hee Martaau hũr hat'ajim haajem, ya Jesús hamach dakpamam. Mag k'aug hat'aawai hi k'ĩirp'ee hoon bëejim. Pari María maba, deg sĩsijim. ");
INSERT INTO noaH_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mag bëewia ya Jesús dʌ̈i t'ẽubaicheewai chi Martaau hirig, —Señor, pʌ mʌig sĩerr hak'iin, mʌ hẽp'emk'öi mʌg dau hap'ʌʌ habak'amgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pari mua k'ap'ʌ hʌmgui hajim, pua Hẽwandamag jëeubaawai pʌchdëu jëeubarmpierr hirua haju. ");
INSERT INTO noaH_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Magbaawai Jesuu hirig, —Marta, pʌ hẽp'emk'öi deeu hiiu p'iidʌjugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Magbaa Martaau, —Chadcha mua k'ap'ʌ hʌmgui hajim, mʌg hatag hötarr k'ʌʌn t'um deeu p'iidʌtk'a nʌm hedan hijã dʌ̈i p'iidʌju. ");
INSERT INTO noaH_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Magbaawai hirig Jesuu magjim: —Muata hõor p'iriu haunaa hich mag wai chirsiejem. Chi mʌ hiekta hʌ̈k'a sim k'ʌʌn meewiajã deeu hiiujugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maimua har mʌig heegarwejã mʌ hiekta t'ãraucha hʌ̈k'awia mʌ dënk'a t'ʌnʌm k'ʌʌn chan meem hiek meebam. Mak'ʌʌnan meewiajã deeu p'iidʌtk'awia hich mag nʌisijugui hajim. Magnaa hirig, —¿Pua mʌ mag hiek'a chirʌm chadcha hʌ̈k'a hʌwi? hajim chi Martaag. ");
INSERT INTO noaH_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Magbaawai chi Martaau, —Señor, mua k'ap'ʌ hʌmgui hajim, pʌ chadcha hich Hẽwandam Hiewaau. Pʌʌta warrgarwe hich Hẽwandamau hich hiek jaaumk'ĩir mʌg jẽb gaai pʌ̈iju haajerr k'abahab hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maimua Jesús dʌ̈i mag hiek'a dʌnaawia, chi Martaau hich heeum haar mawia, hök'arii hi kach gawaa, —María, maach Maestro ya chum p'öbör higaau sĩeichëm. Hi hiek pʌ dʌ̈i hiek'aag haajemgui haimajim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mag chadcha hichig mag jaaubaimam bʌ̈rre Jesús haig bëejim. ");
INSERT INTO noaH_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Maagwai chan hagt'a Jesús p'öbör hee dubba, Marta dʌ̈i hootarr haigpai sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pari mag María hapuraa höbërbaadëm hoobaawai judionaan ham k'ĩir jãsenk'aag ham haig bëewia narr k'ʌʌnau chi binaandam hauk'ërtarr haarta bĩen mampii hawia dʌ̈i hi hẽudee pochag bëejim. ");
INSERT INTO noaH_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mag bëewi, Jesús haig barchëwi, hi bʌ̈k'ʌrr p'õbk'anaa hirig, —Señor, pʌ mʌig sĩerr hak'iin, mʌ hẽp'emk'öi mʌg dau hap'ʌʌ habak'amgui hajim, bĩemamua. ");
INSERT INTO noaH_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mag warag hich dak'ĩir bĩebaadëm dʌ̈i chi judionaan hi dʌ̈i bëetarr k'ʌʌnjã bĩep'öbaadëm hoobaawai hichpa hö jãsenaaga haadëmua gaai machaaga haadëjim. ");
INSERT INTO noaH_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mag warag hich haig narr k'ʌʌnagta, ¿Jampaita hauk'ërjierrá? ha jëeujim. Magbaa hamachdëu, —Señor, hachum k'abahab; hoomierrau hajierram hirig. ");
INSERT INTO noaH_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mag gaai machag haadëmua hich Jesujã bĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mag Jesús bĩebaadëm hoowia chi judionaanau, —Keena, pãadë hoobat: Jãgan chadchata hirua hi jãsene haajeejimwai haajeejim jũrram k'ʌʌnau. ");
INSERT INTO noaH_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pari mak'ʌʌnau mag nʌm hee, hagjö bigaaum k'ʌʌnau jũrr, —Hichta mʌig sĩerr hak'iin, jãg dau k'ĩsu k'itʌm monaautarrjö, ¿mʌg Lazarojã hirua monaaubak'am k'ai? haajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mag mawia ya chi hauk'ërtarr haar pabaimaawai deeu gaai machag haadëjim. Chi binaan hauk'ërtarr jẽbdi, nawe durrbʌ̈ hee chi k'örm hajim. Mag simta mok pör pöm simuata sĩi chi jẽbdi hi hee joot'ʌ wai naajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mag haig pachëwia Jesuu chi haig narr k'ʌʌnag chi mokpör chawag pʌrëupʌ̈ipi jaaujim. Magbaawai Martaau hirig, —Señor ya maach hauk'ërtarr k'ãai jayap sim haawai ya maach hãr k'ërabahab hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Magbaawai Jesuu hirig, —Mamʌ mua k'abá chaigjã pʌrʌg, mua hi p'iriu hauju pʌch t'ãar hee k'ap'ʌ hʌm k'ai, pua chadcha Hẽwandam jua t'eeg hooju ha chirajimgui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mag chi mok chawag pʌrëupi jaautarr haawai chadcha chawag pʌrëupʌ̈ijierram. Magbaawai Jesuu hʌ̃gt'aag heerpanaa Hẽwandamag, —Tata, mua pʌrʌg hʌ̈u hajim ha chirʌmgui hajim, mʌg mʌchdëu jëeu chirʌm pua hʌ̈u mʌ hiek hʌ̈k'abaawai. ");
INSERT INTO noaH_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mua k'ap'ʌ chirʌmgui hajim, mua pʌchig jëeuwai pua mʌ hiek hʌ̈k'aajem. Pari magʌm hãba, hichiita t'umaam k'ʌʌn jʌ̃g daar mua t'et mag hʌ̈u hajim ha chirʌmgui hajim, t'umaam k'ʌʌnag chadcha pʌchdëuta mʌ pʌ̈ijim ha k'ap hamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mag hiek'awia deeu hichdëupai jũrr mag chi meem jẽb deg sĩerragta hi t'ʌ̃rcha t'ʌ̃rt'ʌ̃rnaa t'et, —Lázaro, dawag höbërbaichë hajim. ");
INSERT INTO noaH_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Magbaawai maach chi meem harrta chadcha dawag höbërchëjim. Hoowai hich hauk'ërtarr hich mag bʌ̈ haarmua k'ĩeb mor t'um dĩes baúa pʌrëunaa hödi haigmua hʌ̃gt'aag pörpa k'ĩir jãarjemua pʌrëu simta höbërchëjim. Mag höbërbaicheewai haig narr k'ʌʌnag, —Jãimua jãg put hẽerk'abapʌ̈it hajim, hidëu hich diig mamk'ĩir. ");
INSERT INTO noaH_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mag Jesuu Lázaro p'iriu hautarr hamach daúacha hootarr gaaimua, judionaan k'apan María dʌ̈i bëetarr k'ʌʌnau k'ap'ʌ nʌisijim, chadcha Jesús hich Hẽwandamau pʌ̈itarr. Mag warag hi higar nʌisijim. ");
INSERT INTO noaH_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pari mag t'ʌnʌm hee, hãaur k'ʌʌn warag fariseonaan haar wëtjim. Mag wëtwi Jesuu mag hõor p'iriu hat'amta hĩgk'aimajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Magbaawai chi fariseonaan, p'adnaan chi pörk'a narr k'ʌʌn dʌ̈i hãba, tagam k'ʌʌn chi t'ierrnaanpa biirdʌjierram haajem. Mag biirdʌnaa hamach heepai jũrr hamach k'apeenagta, —Keena, ¿maadëu jãga hajuma jãg woun dʌ̈i? hajierram hanʌm. Jãguan chadchata maach dauderraa hag na hõrau nem hooba haajempata wau nʌrrʌm. ");
INSERT INTO noaH_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Maadëu hʌdʌraa hirig jãgʌm nem waupi nʌmʌn, t'umaam k'ʌʌnta hi higar paauk'awia hamach reik'apiju. Magbaawai Romapien chi t'et'emnaan bëewia, jũrr maach Haai hi jëeujem diita pogueupʌ̈inaa, maachjã dau haug waujugui hajierram haajem. ");
INSERT INTO noaH_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mamʌ hãaur k'ʌʌnau mamagk'am hee, hãb mag añoou p'adnaan t'um t'ʌnarr k'ʌʌn pörk'a sĩerr Caifás ha t'ʌ̃ʌrjerrau hich k'apeenag, —Pãrau chan bʌ̃ʌrjã k'ĩirjubata hiek'a nʌmgui hajim hanʌm. ");
INSERT INTO noaH_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Magnaa hichdëupai, Mua hoowai wajapcha hajuun, mag pãrau jaau nʌmjö maach t'umaam k'ʌʌnta dau hap'ʌʌ hapiju k'ãai, jãg happaita maach t'umaam k'ʌʌn kõit t'õopiju haai simgui hajim hanaabá, Jesús higwia. ");
INSERT INTO noaH_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pari wajapcharan Caifaau mag hiek'atarr chan hich k'ĩirjugjã k'abajim. Wajapcharan mag añoou hichta t'um p'adnaan t'ʌnarr k'ʌʌn pör harr haawai hich Hẽwandamau mag hiek'apibaawaita mag hiek'ajim, Jesuuta judionaan t'ʌnʌm kõit t'õju higwia. ");
INSERT INTO noaH_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pari magbarm chan hĩchab judionaan kõitpai k'aba, hewag paawai t'um hich chaaink'aju k'ʌʌn kõitpa t'õju ha sim hajim, judionaan k'abam k'ʌʌn hawiajã, magbarmua hich chaain durrpierram k'ʌʌnta k'od hãbamk'a hawaag. ");
INSERT INTO noaH_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ya Caifaau mag hiek'atarr haawai magtarr haigmua judionaan chi t'et'emnaanau hãba hibëpwia warre Jesús t'õoju k'ĩirjugta wai nʌisijim. ");
INSERT INTO noaH_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesuu ya mag hich t'õoju k'ĩirju nʌm k'ap'ʌ sĩerr haawai ya tag judionaan hee parhooba nʌrraba haajeejim. Mag gaaimua hichta warag Judea durrmua warp petajim, p'öbördam Efraín hanʌmʌg. Mam chan hõor pömcha k'aba naajeejim. Maig maar hi dʌ̈i naaimajim, hi k'a hogdʌba wënʌrraajerr haawai. ");
INSERT INTO noaH_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mag p'öbör Efraín hanʌmʌg weetwai judionaan p'iesta Pascua haajem burrju dakpapa k'ajim. Hamach hi harr haawai, mag p'iesta hʌ̃rʌʌ harr haawai, hõor pöm Jerusalenag hërërëu k'ajim, Pascua burrju nawe k'ĩir k'augaag, hamach jöoinau jaaujerrjö domer nʌmua hamach k'aibag barpäain. ");
INSERT INTO noaH_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mag wët t'ʌnʌmuan Jesuuta jʌrp'öo haajeejim. Maimua ya Haai hi jëeujem degcha paauk'aimawiajã hi bëebaju k'ĩirjuwia jũrr hamach k'apeenagta, —Keena, ¿pãrau k'ĩirjuawai mʌg p'iesta hee hi bëeju k'ai? haajeejim haajem. ");
INSERT INTO noaH_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Maagwai chi fariseonaanau p'adnaan chi pörk'a narr k'ʌʌn dʌ̈imua ya hõrag jaauk'a wai naajim haajem, chi Jesús sim k'aug hat'aawai hamachig jaaumk'ĩir, mag hamachig jaaubaawai sĩi hi pʌr hawaan wëtaag. ");
INSERT INTO noaH_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Maimua mag p'iesta Pascua burraag seis diaspai waaur nʌm heeta, hich Jesús Betania hanʌmʌg mam dʌ̈i maarjã wëtjim. Mag Betania p'öbör heeta mag woundam Lázaro hanʌm hichdëu p'iriu hautarrjã sĩejeejim. ");
INSERT INTO noaH_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mag hi barbaimaawai maiguim k'ʌʌnau wajap p'iejãb wauwia Jesús k'öpiju hap'öbaadëwia chadcha waujierram. Maimua ya t'um wau haaipa sĩsiewai chi Lázaro hʌ̃p'ʌi Martaau chi nemek t'öi jijig k'ajim. Maagwai maar t'ach k'ö nʌm haig hĩchab hich Lazarojã dʌ̈i t'ach k'ö sĩejim. ");
INSERT INTO noaH_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mag nʌmta hich Lázaro hʌ̃p'ʌi hãbak'ai María jʌ̃gdee narrdo chaar dën nem parhẽpagk'am dʌ̈i dubchëjim. Mag dubchëwia, chigagjã higba, hagua Jesús bʌ̈ sũgnaa deeu hich pörbʌ̈ʌupai jʌʌupʌ̈ijim. Mag nem t'ũpag sĩewai mag hirua Jesús bʌ̈ hagua sũgbaadee sĩi dijã hëntër t'ʌ̃ap jöisijim. ");
INSERT INTO noaH_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Mag hoobaawai maar heem hãb maar k'apeer Judas Iscariote ha t'ʌ̃ʌrjerrau magjim: —Hëh, jãg jʌ̃gdee trescientos denariom gaai përpʌ̈iju haai sĩerrta, ¿k'ant'ee sĩi jãg hãr choobaadëma, hagua hap'ʌʌm k'ʌʌndamag nemdam haudeeju haai sĩerrtá? hajim. Hich mag Judaauta hewag pawiajã hich Jesús hoomap'a haajerr k'ʌʌnag hi pʌr deeju hajiebma. ");
INSERT INTO noaH_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pari Judaau mag hiek'atarr chan sĩi chadcha hap'ʌʌm k'ʌʌndam k'ĩirjuwia k'aba, nem jĩgmie harr haawaita mag hiek'a sĩejim. Hichdëuta maach t'umaam k'ʌʌn p'atk'on di wai nʌrraajerr haawai hõrau maachig deemam hauk'ërmamjã hichdëu jĩgk'am haig jĩgk'aajeejim. ");
INSERT INTO noaH_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Judaau mag hiek'abaawai Jesuu hirig, —Hidëu hirig jʌ̃gdeeu mʌ bʌ̈ sũgpibá hajim. Jã hi dën nau jöpcha mʌ meebaadeewai hagua mʌ k'a p'uraag sĩi hãk'a wai sĩerr k'abahab hajim hirig. ");
INSERT INTO noaH_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Magnaa, Hap'ʌʌm k'ʌʌnan hich mag pãrau pãach hee hoo wai wënʌrraju; pari mʌ chan hich mag pãar k'ĩir chitabajugui hajim. ");
INSERT INTO noaH_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mag Jesús Betania sĩeichëmjã chi judionaan Pascua dichaag bëetarr k'ʌʌnau k'aug hat'aawai k'apan hi hoon bëejierram. Pari mag bëe t'ʌnʌm chan hi hoogpaijã k'aba, hich Jesuu Lázaro p'iriu hauwia maach hich mʌg sim hoogpata bëe naajim. ");
INSERT INTO noaH_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Pari mag Jesuu hi hiiu hautarr gaaimua, judionaan pöm tag hamach higar k'aba jũrr Jesuu jaau nʌrrʌmta hʌ̈k'a t'ʌnʌisierr haawai, chi p'adnaan pörnaanau jũrr hich Lazaropata dʌ̈i t'õopʌ̈ijugui hap'öbaadëjim. ");
INSERT INTO noaH_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mag Jesús dʌ̈i maar Betania paauk'achëtarr noram Jerusalenmua hũrp'öbaadëjim haajem, hi barju. Maagwai ya hõor pöoma Jerusalén p'öbör hee t'ʌnaajim haajem, mag p'iesta hat'ee wëttarr k'ʌʌn. ");
INSERT INTO noaH_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mag hũrp'öbaadeewai hõrau sot'ark piujöm t'ʌrrp'ënaa hag jua panhap'a hi k'ĩirp'ee bëejierram. Maimua hich dʌ̈icha hoobaicheewai serereuk'amua honegau, “Hʌ̈ucha habarm Hẽwandam. Hich mʌʌta pʌchdëu maar israelnaan hat'ee pʌch jũrr pʌ̈ibarmʌu. Hichta maar Reik'aj