﻿USE sofia;
DROP TABLE IF EXISTS sofia.noaE_vpl;
CREATE TABLE noaE_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES noaE_vpl WRITE;
INSERT INTO noaE_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mua pãrag ĩgkhakhim, jãga warrgar David reikha sĩerrjö, Ẽwandamau jũrr ich Iewaa Jesucristoogta mʉg durr gaai chi Pörkhamkhĩir ichdëucha pʉ̈ijĩ. Mag Jesucristojã mag rey David khararr ag chaain ewagam khʉʉn dën ajim a khap amkhĩir, ag nawe jöoi Abrán khararr sĩejerr aigmua ewag pawi khĩeb chi Jesús thaabatarr aig pãrag jaaukhim. ");
INSERT INTO noaE_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Maataa, ich jöoi Abrán, Isá aai ajim anaabá; maagwai, Isá jũrr Jacob aai; Jacob jũrr Judá aai. Mamʉ mag Judá ich appai khaba, tagam ich khodnaanpa doce naajim aajem, ich khurau, ich jöoi Jacob chaainpai. ");
INSERT INTO noaE_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Mag ich Judá, Fares aai anaa ĩchab Zara aai ajim aajem; am ãd, Tamar a thʉ̈r sĩejim aajem. Mag Fares, Esrom aai ajim; maagwai chi Esrom jũrr Aram aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ich Aram, Aminadab aai ajim aajem; maagwai chi Aminadab jũrr Naasón aai. Naasón jũrr Salmón aai ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Chi Salmón, Booz aai ajim aajem, Rahab dʉ̈ím; maagwai chi Booz, Obed aai, Rut dʉ̈ím. Obed jũrr Isaí aai ajim aajem; ");
INSERT INTO noaE_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","maagwai chi Isaí jũrr mag rey David khararr ag aai ajim aajem. Mag chi rey David, Salomón aai ajim aajem, Urías jua eem ʉʉi khecheu autarr dʉ̈ím. ");
INSERT INTO noaE_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón, Roboam aai ajim aajem; maagwai Roboam jũrr Abías aai; maimua chi Abías jũrr Asa aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ich Asa, Josafat aai ajim aajem; maagwai Josafat jũrr Joram aai; maimua chi Joram jũrr Uzías aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías, Jotam aai ajim aajem; maagwai chi Jotam jũrr Acaz aai; maimua Acaz jũrr Ezequías aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Chi Ezequías, Manasés aai ajim aajem; maagwai Manasés jũrr Amón aai; maimua chi Amón jũrr Josías aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Chi Josías, Jeconías aai ajim aajem. Mag chi Jeconías khod ãbam khʉʉn khapan sĩejim anaabá, maach jöoin israelnaan Babiloniapienau amach durrag pʉrkha arr nʉm jaar. ");
INSERT INTO noaE_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mag am chikhamnau amach durr pʉrkha arrtarr khur, Jeconías chaai paarpajim aajem. Ma, Salatiel a thʉ̈rjim aajem, Zorobabel aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ich Zorobabel, Abiud aai ajim aajem; maagwai chi Abiud jũrr Eliaquim aai; maimua chi Eliaquim jũrr Azor aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ich Azor, Sadoc aai ajim aajem; maagwai chi Sadoc, Aquim aai; maimua chi Aquim jũrr Eliud aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Chi Eliud, Eleazar aai ajim aajem; maagwai chi Eleazar, Matán aai; maimua chi Matán jũrr Jacob aai. ");
INSERT INTO noaE_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Chi Jacob, José aai ajim aajem. Mag Joseeta, María jaai ajim anaabá; maimua chi María, Jesús ãd. Mag Jesuuta maadëu ich Ẽwandamaucha pʉ̈iwia bëejim aajem ag Jesuu, amach peerdʉ aumkhĩir warrgarwe õrau nʉajerr. ");
INSERT INTO noaE_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wajapcharan, mag jöoi Abrán khararr sĩerr aigmua ewag pawi David reikha sĩsiju jaar pa nʉm aar, catorce generaciones dichjim anaabá. Mag David sĩsiewaim aigmua ewag nassi pawi maach jöoin israelnaan Babiloniapienau pʉrkha arrtarr jaar pa nʉm aar agjö catorce generaciones dichjim aajem. Mag maach jöoin Babiloniapien durr narr aigmua ich Ẽwandamaucha pʉ̈iju jaaujerr ewag nassi pawi thaabachë nʉm jaar pa nʉm ora agjö catorce generaciones dichjim anaabá; ajapcharan maach Pör Jesús thaabachë nʉm jaarma. ");
INSERT INTO noaE_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mag Jesucristo thaabatarran mʉgta ajim aajem: Chi María, ewag pawi i ãdpaju, ya Joseeu iek dee wai sĩejim aajem, ag dʉ̈i paag. Pari mag sĩi iek dee wai sĩewai agtha ag dʉ̈ijã khaba nʉmta bi ee pabaadëjim anaabá. Pari ma chan chikham dënjã khaba, ich Ẽwandam Akharauta ich iiu aawai mag i bi ee papijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José chi jaaipajuun Ẽwandam dau na nem agchata waaujerr aawai, sĩi warre ich ʉʉi chi thethemnaanag jaauju khãyau, ichta warag sĩi khĩuu öbërju khĩirjubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ya irua mag pʉaju khĩirjubaadëmta, Ẽwandam chog ʉ̈gtharmua bëewi irig, —José, David khararr chaain ewagam khʉʉn bi eem, oob pʉch ʉʉi pʉaju khĩirju chiram ajim anʉm. Jãg chaai irua bi ee wai sim chan deeum dën khaba, ich Ẽwandam Akharauta jõorpitarr khabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mariaau jãg chaaidam athaawai i thʉ̈rdam Jesús a thʉ̈rbá. I thʉ̈r magta thʉ̈rju, ichdëuta ich phöbör amach pekau ee thʉnʉm peerdʉ auju aawai a jaaumajim anaabá chi Ẽwandam chogau. ");
INSERT INTO noaE_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mamʉ thum mamagkharran, ich i jaaujem khʉʉnag maach Pör Ẽwandamau phãpitarr gaai jaau simjöo öbëbërg mamkhĩirta magpibajieb. Mag irua phãpitarr gaai mag sim: ");
INSERT INTO noaE_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ʉʉi õor meraa khitʉm bi ee pawi chaai ooju. Mag chaai thʉ̈rdam Emanuel a thʉ̈rju” a phã sim. Mag Emanuel a simʉn, “Ẽwandam maach dʉ̈i sim” aawaiu. ");
INSERT INTO noaE_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Maimua mag chi José khãi werba thʉnaawi daukhanpawi phiidʉbaadeeu, Ẽwandam chogau ichig jaautarrjö tag María pʉaju khĩirjuba, ich mag ag dʉ̈i sĩsijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pari mag ag dʉ̈i ya ich ʉʉikha wai sĩerrjã, chi chaai auba nʉwe chan José bʉ̈ʉrjã ich ʉʉi dʉ̈i khapes aba aajeejim anaabá. Ya maimua chadcha chi Ẽwandam chogau jaautarrjö chi chaaidam athaawai, Joseeu i thʉ̈rdam Jesús a thʉ̈rjim aajem, ichig thʉ̈rpi jaautarrjö. ");
INSERT INTO noaE_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mag Jesús thaabaawai phöbördam Belén anʉm eeta thaabajim aajem, Judea durr. Mag jaar Erodeeta mag Judea durr reikha sĩejim aajem. Ich mag jaar ĩchab khĩirjug khaug athee chi machnaan magonaan anʉm khʉʉn edau öbeerjem bi garmua bëejierram aajem, Jerusalén phöbörög. Makhʉʉn, edjã eem phĩdagta estudiejem khʉʉn ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mag bëewi bardʉtkhachëwi, judionaanag, —Pãar rey thaabatarr, ¿jamta wai nʉma? I thaababarm jaau sim phĩdag maach daúacha ootarr aawai iita marau jʉr wëdurumgui aajeejim anʉm, iita judionaan reikhaju aawai i ajaug thö iekhaan. ");
INSERT INTO noaE_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mag judionaan rey thaababarm anʉm ũr athaawai chi rey Erodes warre khakhaisamjö aadëjim anaabá. Mag nʉm dʉ̈i tagam khʉʉn chi Jerusalenpienjã jʉ̈gderraata aphöbaadëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Magbaawai chi rey Erodeeu phadnaan chi pörnaan thum Moiseeu Ẽwandam iek phã pʉarr jawaag chi machnaanpa thʉ̈rkhʉʉipʉ̈iwia amag, —¿Jamta mag warrgarwe Ẽwandamau pʉ̈iju jaaujerr thaabaju aajẽ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Magbaawai amachdëu irig, —Judea durr phöbördam Belén anʉm eeta thaabaju aajem anaabahab, ich magta Ẽwandamau ich i jaaumie Miqueas khakhitarrag jaaupitarr aawai ajim anʉm. Mag irua jaautarr iek gaai, ");
INSERT INTO noaE_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Pãar, Judá durram phöbördam Belenpien, pãran chadcha khapan khaba durrum. Mag durrab mamʉ, pãar ee ãb thaababarmuata israelnaan mʉ õorkha thʉnʉm khʉʉn gobernaaju aawai, pãach durr agjö phöbör thʉnʉm ee pãar phöbör chan chi serbiibam khabam” a phã simgui ajierram anʉm, chi Erodeeg. ");
INSERT INTO noaE_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Phadnaan chi pörnaanau maestronaan dʉ̈imua ichig mag jaaubaawai, chi rey Erodeeu jũrr mag chi magonaan ed öbeerjem garmua bëetarr khʉʉn amach appai thʉ̈rkhanaa wajapha ichig jaaupijim anaabá, jãagwaichata mag phĩdag amau oo naajĩ. ");
INSERT INTO noaE_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mag wajapha ichig jaaupinaan chadau amag, —Ĩsin chad ërëubaadët ajim anʉm, Belenag. Ërëubaadëwi thumaa jëeu oopetat ajim anʉm, wajapha mag chaai khap aag. Maimua ya pãachdëu wajapha khaphʉ nʉisiewai mau mʉ aar iek pʉ̈ibapʉ̈it, muajã mawia ĩchab pãar dënjö i ajaug thö iekhaimaag ajim anaabá, juau ogthom. ");
INSERT INTO noaE_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mag chadcha chi rey Erodeeu amachig jaautarrta jʉ̈g thõba ërëubaadëjim aajem. Mag wëtumua, warrcha amach thʉgdʉawai amachdëu phĩdag ootarrta deeu ũwaai am na phuu jöisijim anaabá. Magbaawai ag ẽudee oo warrmamua, ya chi chaai sim aig pabaimaawai, ag ʉ̈r edjã ee bar jöisijim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mag amach chi magonaanau chi phĩdag oo athaawai onee aphöbaadëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mag barwia, chi chaai khërarr aar dubnaa ooimaawai, chadcha chi chaaidam ich María dʉ̈i ooimajierram anaabá. Magbaawai ag khĩirphee jĩepör phõbkhanaa i ajaug thö iekhajierram aajem, ich reikhaju igwi. Magnaa amach nem wai bëetarr eem phĩr maimua incienso mirra dʉ̈i thũpha khithëem aunaa irig deejierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mag agtha am aig nʉm ee, ich chi Ẽwandam chogau khãai khõrg ee tag amag Erodes gar dichpiba jaautarr aawai, ag garjã dichba, deeum khʉd garta phʉʉrdʉ dichwi amach durrag wëtjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mag chi magonaan ërëutarr khur Ẽwandam chogau deeu José khãai khõrkhapi auwia irig jaaujim aajem, Erodeeu chaai thõopʉ̈yaag jʉrpiju. “Mamʉ magju nawe phiidʉtkhawi jöpkhaa chaai dʉ̈i Egiptoog ërëubaadët” ajim anaabá. “Mua jaaubam aig chan oob mammua bëemiet” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Magbaawai José daukhanpawi, chadcha ag bʉ̈rre nem khĩir khaugwia, agtha ãspaju wají nʉwe, jöpkharraa amach chaai athaadëjierram aajem, Egiptoog. ");
INSERT INTO noaE_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mammua da bëeba, ya chi Erodes meebaadëm a ũrbaawaita deeu bëejierram aajem. Pari mam mag chaai arrtarran, maan maach Pör Ẽwandamau ich i jaaumie Oseas khararrag jaaupitarrjö amkhĩir ajiebma. Magju igwiata chi Oseas khararrag Ẽwandamau, “Egipto durrmuata mua mʉch Chaai thʉ̈rpʉ̈iju” a phãpijim. ");
INSERT INTO noaE_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erodeeu chi khĩirjug khaphʉm khʉʉn nʉ sim ee, ĩchab khaug athajim aajem, ya jũrr deeum khʉd garta phʉʉrdʉ ërëubaadëm. Mag ich khũgurbapäaiwai, khĩir machgau warm khʉʉnau ichig jaautarr khĩirjunaa, Belén phöbör eem chaain maimua ag bigaau phöbördam nʉnʉidʉm eem chaaindampa thumaa año numiimua eegam khʉʉndam khëchpi jaaujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mag khëchpi jaautarran, maan mag chaain öbarm gaaimua Ẽwandamau ich i jaaumie Jeremías khararrag phãpitarr gaai jaau simjöta ajim. Irua phã pʉatarr mʉg ajim: ");
INSERT INTO noaE_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá phöbör ee ʉʉi bĩep jẽbʉ ökhĩirjug machgau idawaa ʉ̈apëpër khaju. Ma Raquel ajim, ich chaain ewagam khʉʉn athee bĩewai. Mag sim chan par khĩir jãsenkha nʉmjã khĩupaba, waragta bĩe thʉnaaju ich chaaindam ötarr athee” a phã sim Ẽwandam iek gaai. ");
INSERT INTO noaE_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pari chi Erodes meetarr khur, agtha chi José mam Egipto nʉm ee, Ẽwandamau ich chog pʉ̈iwi khãai khõrkha thʉnʉm eeta irig, ");
INSERT INTO noaE_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—José, phiidʉbá aichëjim anʉm. Chaai thõoju ẽkha narr khʉʉnjã amachta ya khëchphöbaadeewai ya deeu pãach durrag chaai arrju aai nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Magbaawai José phiidʉwia Jesudam dʉ̈i chi ãdpa deeu ũwaai Israelag bëejierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pari mag chi rey meebaadeewai, chi iewaa Arquelao a thʉ̈r sĩerrta jũrr Judea durr ich aaijö reikha sĩsim a ũrbaawai, agʉg maju ögkhajim aajem. Mag nʉm ee ĩchab deeu Ẽwandamau khãaipi athaawai, Ẽwandam chogaujã magʉg mapiba jaautarr aawai jũrr Galileaagta ërëujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea durr barwi, sĩi khajapha Nazaret phöbördamagta wëtwi, mamta naaimajim aajem. Pari mag Nazaret phöbör eeta naaimarran, maan Ẽwandamau ich i jaaumienag jaaujerrjö, Jesús Nazaretpierr a thʉ̈rju arr aawai ajima. ");
INSERT INTO noaE_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Warrcha Juan chi õor pör choomieu Ẽwandam iek jaaubaadëm jaar, Judea durr bʉ̈ʉrjã õor chukag eeta sĩejeejim aajem. Mam ich sim aar õor maawaita amag jaaumamua, ");
INSERT INTO noaE_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pãach khaibag ãsie ewag khĩirjuwia Ẽwandamagta chugpaapi jëeubathʉ̈” aajeejim anʉm. Magnaa ĩchab, “Ya mʉigmua jöpcha ich Ẽwandamau maach thumaam khʉʉn Pörkhapiju maach ee pʉ̈iju” aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mamʉ maan Juanau mag jaau nʉrraju igwiata chi Ẽwandam i jaaumie Isaías khararrau Ẽwandam iek phãawaijã mag phãjiebma: “Woun ãb ajappai õor barba aajem aar sĩejemuata, ich aar õor barbaimaawai, ‘Maach Pörön ya bëeimʉʉ sim’ a jaau nʉrraju. ‘I bëeju nawe pãach thãar khĩir khaugbat’ aju, ‘thãraucha khõsi i iek ʉ̈khaag’ ” a phã sim. ");
INSERT INTO noaE_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ich chi Juan khajũa camello khaar dënta kha sĩejim aajem; maagwai i ãi jʉ̈ajemjã nemhëu dën ajim aajem. Ichin pabʉ̈ ee asphitjö sim langosta anʉmta pa miel dʉ̈i khö nʉrrʉm iiuta sĩejeejim aajem, tag deeum nem khoojem chukhu aawai. ");
INSERT INTO noaE_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Irua mag jaau nʉrrʉm khaug athaawai, Judea durram khʉʉn Jordán igaau joobaajerr khʉʉn dʉ̈i Jerusalenpienpa i iek ũraan bëejeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mag bëewia amach pekau Ẽwandamag chugpaapi jëeubaawai ichdëu am pör choopʉ̈imaajeejim aajem, Jordán ee. ");
INSERT INTO noaE_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pari Juanau oowai ich aig Moiseeu Ẽwandam iek phã pʉatarr wajapcha ʉʉrkhaajerr khʉʉn khapan bëe thʉnʉm dʉ̈i ĩchab tagam khʉʉn chi machnaan saduceo anʉm khʉʉnpa bëe thʉnʉm oobaawai, amag magjim anʉm: —Chi khaibagnaan, ¿khaíu pãrag jaauwai Ẽwandamau maach i agkham ed sĩi pör chootarr gaaimuapaita pãar i jua machag ãwatbaju a jaaujĩ? ");
INSERT INTO noaE_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sĩi pãach pör choopi nʉmuapai chan irua pãar aubam ajim anʉm. Ẽwandam jua machgau dau aphʉʉ amapha nʉm khai, pãach khaibag thumaa ãsie ewag khĩirjuwia, Ẽwandamag isegpi jëeuwia, chadcha Ẽwandam iek ʉ̈khaajem khʉʉnjö abat ajim anʉm, pãach khapeen dʉ̈ijã. ");
INSERT INTO noaE_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Oob pãrau chikhamnaan dënjö, pãachjã warrgar pãach jöoi Abrán khararrjö Ẽwandam dʉ̈i khapeerkha nʉm awi, “Maran Abrán chaainau; mag i chaainkha nʉmta, ¿jãga Ẽwandamau mag maar dau aphʉʉ apibarju?” a khĩirjumiet ajim anaabá. Sĩi mag Abrán chaainkha nʉm gaaimuapaita mag ʉ̈gthar öbeerjem akhiin, mokdau mʉg thʉnʉmjã Ẽwandamau õrag paapʉ̈iwia, mʉkhʉʉnjã ĩchab Abrán chaainau aju aai sim. Mamʉ mag Abrán chaain chaar awiajã ichiita Ẽwandam jua machag ãwatab khaba ãwatju. Mag khõch khaba nʉm khai, pãach khaibagta warre Ẽwandamag isegpi jëeubat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pãrau khaphʉ naabá, nemjĩirjã khaigbamʉn thu wërpmaajem. Ich agjöta ajugui ajim anʉm ĩchab Ẽwandamau pãar dʉ̈ijã. Ya irua pãar chachimʉʉ sim. Ar õor amach khaibag isegwia Ẽwandamag chugpaapi jëeuba nʉm khʉʉnan, ar pa thupʉ̈iwia jʉser aadee örpʉ̈i nʉmjöta aju ich Ẽwandamau am dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mua chan pöd pãar thãar wajaug paa aubam. Ẽwandamagta pãach khaibag chugpaapi jëeubaawai muan sĩi dödamaupaita pãar pör choo chirʉmgui ajim anʉm. Pari mʉ ẽudee ãb urumʉn chadau mʉ khãaijã jua theeg ʉ̈rpai sĩewai, jãguan chad Ẽwandam Akhaarjã pãrag deewi pãar khaibagjã õtdau ee warre örbapʉ̈imjöta aju ajim anʉm. Mʉ chan mʉg chirʉm aig sĩi i chogkhaagpaijã serbiibata chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Khĩir khaphʉ abat ajim anʉm: I bëem ed i iek ʉ̈kha nʉm khʉʉnan, arroz pöm phierrwia wajapha ãkha thʉnʉʉubarmjöta aju. Maagwai i iek ʉ̈khamapha arr khʉʉn, jũrr chi arroz bʉ̈ thʉʉtarrta sĩi ãbamʉg päardʉnaa örbapʉ̈imjö aju. Magbarm chan õtdau thõo khaugba sĩerrʉm eeta ich Ẽwandamaucha barkhʉʉipʉ̈ijugui a jaaujeejim anʉm Juanau ich aig bëe nʉm khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Biek ãb Galilea durrmua Jesús Jordanag majim aajem, Juanau õor pör choo sĩerr aar ichjã agjö Juanag ich pör choopien. ");
INSERT INTO noaE_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mag mawia, ich pör choopienta bëejim abaawai, Juanau i pör choomaphapaim iekhau irig, —Pʉchdëuta mʉ pör chooju aai chirʉmta mag muata pʉ pör choobaadëjupá ajim anʉm, Juan garmua. ");
INSERT INTO noaE_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Magbaawai Jesuu, —Idëu magma ajim anʉm. Ichiita maadëu Ẽwandamau jaau simjö i ipierr thumaa nem wauju aai naabahab ajim anʉm. Magbaawai Juanau, —Magan chadau ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mag, chadcha Juanau i pör choopʉ̈ijim aajem. Mag ich pör choobapäaiwai, durr waaidʉnaa oowai, edaujãata weeudʉbaadëm eemua Ẽwandam Akhaar duburjöo khitʉmta bëewia i gaai jupchëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Magbarm ee ĩchab ʉ̈gtharmua woun iekjö, “Mʉʉta mʉ Chaai mʉchdëu jãsehne wai chitʉmʉu; i gaaimua mʉ onee chiraajemgui” abarmjã ũrjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Maimua ich Ẽwandam Akharaupai Jesús warp õor chukag chʉʉi warrjim aajem, ich garmua mepeer pödju khaphʉ sĩerr aawai juau ogthom mam chi dösãtag ich khũgur auju ẽkhapieg. ");
INSERT INTO noaE_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mam ich appai cuarenta días y cuarenta noches bʉ̈ʉrjã thach khöba chirajim aajem. Maimua khãai khapan mag dichdimaawaita, i iek i jãsöo aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Magbaadëm eeta dösãt chi dau lök bëejim anaabá, i imeerkha i khũgur auwia Jöoi dau na nem khaigbam waupiju ẽkhaag. Mag bëewi irig, —Pʉ chadcha Ẽwandam Iewaa khai, magan mʉ dakhĩir mokdau mʉg thʉnʉm panag paabapʉ̈i aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pari ichig magbaicheewai jũrr ichdëu chi dösãtag, —Ẽwandam iek phã sim gaai jaauwai, “Sĩi thach khöju appai khap amkhĩir irua maach ompaabajim” a sim. “Irua maach ompaatarran, thach appai khĩirjuju khãai, ich ipierraa wënʉrramkhĩirta maach ompaajim” a phã sim a chirajim aajem irig. ");
INSERT INTO noaE_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mag ijẽjẽb naawi, chi dösãtagta Ẽwandam Akharau ʉdʉraa Jesús arrpijim aajem, Jerusalenag. Mag athaadëwi, Aai i jëeujem dihëu ʉ̈r ʉ̈gthaa arrnaa, ");
INSERT INTO noaE_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","irig magjim anaabma, chi dösãtau: —Pʉ chadcha Ẽwandam Iewaa khai, magan mʉg ee baubaad ajim anʉm. Pʉ chig aba khabahab. Ẽwandam iek phã sim gaai, “Ich Ẽwandamau ich chognaan pʉ̈iju” a sĩebahab ajim anʉm, “pʉ thʉa wënʉrramkhĩir.” Maagwai mʉg ee pʉ baudʉkhiinjã, “amau sĩi amach jua eeta pʉ jãau aubajup, buju aimaau pʉ chig am ugua.” ¡Baubaad! ajim anʉm, chi dösãtau irig. ");
INSERT INTO noaE_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Magbaawaita jũrr ichdëu chi dösãtag, —Ĩchab Ẽwandam iek phã sim gaai jaauwaijã, “Ẽwandamau chadcha pãach thʉaju awi oob nem parhoob amiet” a sĩebahab a chirajim aajem irua. ");
INSERT INTO noaE_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Maimua ãbmiecha paawai deeu chi dösãtaupai durr pöoma sim gaai i arrjim aajem. Mag durrsĩ gaaimua dawaa durr warpham magwe thum ag gaai nem thʉnʉm dʉ̈i irig oopinaa, ");
INSERT INTO noaE_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Pua mʉ bʉ̈khʉrr phõbkhanaa mʉrʉgta Ẽwandamagamjö jëeumʉn, ar pʉchdëu nem oo sim thumaa mua pʉrʉgta deejugui ajim anaabá, chi dösãt garmua. ");
INSERT INTO noaE_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mamʉ mag nʉʉ paawaita Jesuu irig, —Ẽwandam iek phã sim gaai jaauwai, “Pãar Pörön Ẽwandamau; ãba irigpaita jëeubat, maimua ãba i iekpaita ipierraa abat” a sim. Magnaa mag sĩebnaa pʉdëu pʉchta jöpkhaa mʉ aigmua sĩiubaad a chirajim aajem irua. Mag, bʉ̈ʉrjã i ipierraa abajim anaabá Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Magbaawain chadau chi dösãt sĩiubaadeewai i iek ich appai chirsijim aajem. Mag ich appai aadeewai Ẽwandam chognaanauta ʉ̈gtharmua bëewi ʉ̈u i khĩir jãsenkha naaichëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan chi õor pör choomie ya cárcel deg phãar wai nʉm a ũrbaadeewai, Jesús Galileaag majim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pari ich bãautarr phöbör Nazaret eepai sĩeba, warag Capernaumag petajim aajem, thʉrrdö igaau joobaan, warrgar maach jöoin Zabulonnaan Neftalinaan dʉ̈i joobaajerr durr. ");
INSERT INTO noaE_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pari mag i mam matarran, Ẽwandam i jaaumie Isaías khararrau phã pʉarr eyaa öbërmkhĩir ajim. Mag irua phã pʉarr gaai mag sim: ");
INSERT INTO noaE_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulonnaan joobaajerr perás maimua Neftalinaan joobaajerr perasta õor peerdʉju woun nʉrraju” a sim, “Jordán igaau thoom igar, phũas igaau, maimua khĩeb Galilea ee judionaan khabam khʉʉn joobaajem aram magwe. ");
INSERT INTO noaE_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Magbaawain sĩi khĩ thʉnʉm ee naajerr khʉʉn aarta õt bʉ̈ arar aimamjöta aju. Peerdʉju khaugba aawai pöd ʉ̈gthar öbërbaju aajerr khʉʉn atheeta edau aardʉbaadëmjöta aju.” ");
INSERT INTO noaE_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Magtarr aigmua Jesuu ich Aai i jajawagmamua, “Pãach khaibag isegwia, Ẽwandamagta chugpaapi jëeubat, maimua irigta ʉdʉraa pãach Pörkhapibat” aajeejim aajem õrag. ");
INSERT INTO noaE_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Biek ãb Jesús thʉrrdö Galilea igaau nʉrrʉmua, õor numí ooimajim aajem. Makhʉʉn khod ãbam khʉʉn ajim: aaijã ãba, ãdjã ãba. Am thʉ̈r, ãb Simón ajim, ich mapai ĩchab Pedro a thʉ̈r sĩejim. Maagwai ãbakhai Andrés a thʉ̈r sĩejim. Amach dö ʉamien arr aawai, irua ooimaawai, atarraai bar khodjörrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mag oobaimaawai Jesuu amag, —Mʉ dʉ̈i wëttarrau ajim anʉm. Ich jãg pãach mʉg sĩi dö ʉa gaaipai nʉmjö, mʉg atag jũrr mʉ iek õrag jaau gaaipaita nʉisijugui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Magbaawai amach atarraai phëpʉawi chadcha i dʉ̈i ërëubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Maimua mag Galilea igaau mamua ag atag deeu ũwaai õor numí ooimajim aajem, agjö ãbam khodpai. Makhʉʉn Santiago ajim aajem Juan dʉ̈i, jöoi Zebedeo chaain. Makhʉʉnjã dö ʉamien arr aawai, irua ooimaawai, amach red thʉrrdʉ sĩsidʉmta kha naajim aajem, bote ee amach aai dʉ̈i. Mag oobaimaa, makhʉʉnagjã Jesuu, ");
INSERT INTO noaE_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","“Mʉ dʉ̈i wëttarrau” abarm bʉ̈rre sĩi amach redjã khaugba, bote dʉ̈i amach ayag pʉawi i dʉ̈i wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mag nʉrrʉmua Galilea igaau Jesuu jaau phʉʉrdʉ nʉrraajeejim aajem, phöbördam khëkhëdʉm ee judionaan Ẽwandam iek jaaujem di sĩsidʉmpierr. Mag jaau nʉrrʉmʉn maach peerdʉajem iekta jaaunaa ĩchab Ẽwandamagta dich Pörkhapiju aai nʉm aajeejim aajem. Mag nʉm dʉ̈i õor amach khamor machagpierr ich aig wai bëe nʉmʉn monaaupʉ̈inaa sĩi kha mamachdögpa chugpaapʉ̈i maajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria durram magwe Jesús mag nʉrrʉmʉn bĩi wëjorr aawai, õor khamor machag khĩirpierram khʉʉnta i aig waibëejeejim anaabá: sĩi khajapham khamor machag paraam khʉʉn, kha mamachdög paraam khʉʉn, dösãt bën paraam khʉʉn, pör bënmie paraam khʉʉn maimua bʉ̈ wa jua khãijã jʉserm khʉʉnpa waibëemamʉn, Jesuu monaaupʉ̈i maajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Õor pöoma Galilea durram khʉʉn, Decápolis durr phöbör nʉnʉidʉm eem khʉʉn, Jerusalenpien, Judea durram khʉʉn maimua Jordán i atag ed öbeerjem garm khʉʉnpa Jesús ẽudee pos aajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mag õor pöm ich ẽudee noodʉbaadëm oobaawai ich Jesús warag durrsĩ gaai waaidʉ öbërwi oo sĩsijim anʉm. Magbaawai i khapeen i dʉ̈i wënʉrraajerr khʉʉn ich bigaau ohood aphöbaadeewai ");
INSERT INTO noaE_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","jãga chadcha Ẽwandam dʉ̈i ajapha wënʉrraju aai nʉ a jaaumamua magjim anʉm, thumaam khʉʉnag: ");
INSERT INTO noaE_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Pãar ar pãach khaigba nʉm khap Ẽwandamagta pãach eeg oopim khõsi durrum khʉʉn, onee abat ajim anʉm, pãachta i dʉ̈i ãba jooba wënʉrraju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Pãar ar pãach pekau pöm nʉm khaug auwi ökhĩirjunaa Ẽwandamagta chugpaapi nʉm khʉʉn, onee abat ajim anʉm, ich Ẽwandamauta pãar khĩir jãsenkhawi pãar khĩir onee apiju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Pãar ar bʉ̈ʉr abarm gaaimua meeukhaba khĩir thũu Ẽwandamagta pãach dʉ̈i ichdëu ampierr apiejem khʉʉn, onee abat ajim anʉm, pãach mag nʉm paar irua durr iiur deeju a simjã pãachdëuta jʉ̈aju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Pãar ar Ẽwandamau waupim khõsim nem wawaagta jãsog thʉnʉmjönaa öbichag thʉnʉmjö nʉm khʉʉn, onee abat ajim anʉm, mag nem wajapha waum khõchkha nʉm khʉʉn juagta Ẽwandamau dʉ̈i oojeewai. ");
INSERT INTO noaE_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Pãar ar wir aig pãach khapeendamjã dau aug khaug paraa aajem khʉʉn, onee abat; pãachdëu am dʉ̈i jãagjem paran Ẽwandamaujã agjö pãar dau aug khaug paraa ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Pãar ar thãar ajapha nʉm gaaimua ãba Ẽwandam dawagaata nem waaujem khʉʉn, onee abat ajim anʉm, pãrauta pãach mag nʉm gaaimua Ẽwandam khĩir ooju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Pãar ar pãachdëu Ẽwandam iek ʉ̈khatarr gaaimua pãach khõinaa nʉmjö khõinaa amkhĩir õrag jaau durrum khʉʉn, onee abat, pãachta Ẽwandamau ich chaainkha auju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ar Ẽwandamau nem waupi sim ipierraa nem wau nʉm gaaimua jũrr õrau pãach dʉ̈ita khaigba aawai dau aphʉʉ durraajem khʉʉn, onee abat ajim anʉm, pãachta mʉg atagjã Ẽwandam dʉ̈i ãba jooba wënʉrraju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ar mʉ gaaimua õrau pãach khĩir iekhanaa pãach gaaijã jua khʉaba nʉm dʉ̈i ĩchab sĩi pãach khaibag waum khõchgau pãach dʉ̈i chad khabam iekta chadam iekjöo aadëp aawai, warag onee abat. ");
INSERT INTO noaE_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pari pãach dʉ̈i maagwaijã, oob ökhĩirjuu amiet ajim anʉm. Magju khãai warag onee abat; pãar mag nʉm jũrran ʉ̈gtharin pãar athee nem wajapham pöomata thʉnʉm. Ĩs jãg pãar dʉ̈i khaibag thʉnʉmjö aba aajeejieb ajim anʉm warrgarwejã am jöoinau Ẽwandam i jaaujerr khʉʉn dʉ̈i. Pari magtarr ĩs am ʉ̈gthar Ẽwandam dʉ̈i onee naabahab a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mag iekhakhagmamua ich Jesuupai, ’Pãrau khaphʉ nʉmgui ajim anʉm, thakhaar nakha aadëkhiin, tag bʉ̈ʉrjã maadëu nem igba sĩsiju. Magbaawai sĩi õrau ag ʉ̈r ërëu dich thʉnaawiajã, ausĩuba ich mag bʉ̈ ee sĩeju, tag igba sĩewai. Jãg nem ãrpimaaugau thakhaar iigjemjö, pãrauta õor okhooju arrjã ʉ̈u mʉ juapierr khaigpër durraba aajeeb ajim anʉm okhoopimaaugau. ");
INSERT INTO noaE_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Jãg durrsĩ gaai phöbör sim pöd dau merju khaba aajemjö, pãraujã pãachdëu mʉ iek khaugtarr chan pöd meerju khaba nʉmgui ajim anaabá, pãach nem wajapha wau nʉm gaaimua pãachta mʉig eegarm khʉʉn athee khĩchag ee lámpara paa dʉnʉmjö naawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pãrau khaphʉ nʉm, lamparaan paanaa sĩi nem bʉ̈ ee ausĩuba, dau garta ausĩiujem, dijã thum araraa amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ich jãgta aju aai nʉmgui ajim anʉm pãarjã. Magua pãachdëu nemdam wajapha wau nʉm gaaimua pãachta õtdau phuu dʉnʉmjö abat ajim anʉm, thumaam khʉʉn na arar amkhĩir; mag pãach nem wajapha wau nʉm gaaimua maach Aai ʉ̈gthar chirʉmta thumaam khʉʉnau thömkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Oob pãrau mua mag Moiseeu ley phã pʉatarr warre isegpäain wa sĩi warrgar Ẽwandam i jaaujerr khʉʉnau nem jaaujerr khãijã isegpäainta bëejim amiet ajim anʉm Jesuu. Magju khãai muan warag chadcha ag gaai jaau sim thumaa wawaanta bëejim. ");
INSERT INTO noaE_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cha mʉ iekha chirʉm iekhau, mʉg durr jöoita edaujã dʉ̈i Ẽwandamau i agkhabam aig chan, ley gaai jaau sĩsidʉm iek bʉ̈dam ãbjã okhoopibaju. Ichiita nem thumaa ich jaautarrjö öbëbërg majugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Magua, ãbmua khãijã leidam bʉthʉ khitawiajã ag gaai jaau sim iek bʉ̈ ãb khãijã ʉʉrkhaba, ni ag gaai jaau simjö amkhĩir ich paarmua deeum khʉʉnagjã jaauba sim chan, Ẽwandam maach Pörkha sim durr paaukhaimaawaijã ichta thumaam khʉʉn khãaijã jua eegpai sĩerraju. Pari magba, ar ichdëujã mag ley gaai jaau simjö ipierraanaa warm khʉʉnagjã agjö ag gaai jaau simjö ipierraa amkhĩir jaau simʉn chadau, mag Ẽwandam durr paimaawaijã ĩchab ichta warm khʉʉn ʉ̈rpai sĩsijugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Magnaa ichdëupai, Pãrauta ich Ẽwandamau nem waupi jaau simjö nem wauba, sĩi jãg Ẽwandam iek jawaag chi machnaan aajem khʉʉnjöpai nem waunaa Moiseeu ley phã pʉatarr ʉʉrkhaajem khʉʉn dënjöpaita nem wau nʉm chan, pãar ʉ̈gthar öbërbamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Maimua ich Jesuu magjim aajem: ’Pãrau khaphʉ nʉmgui ajim anʉm, warrgarwejã pãar jöoinau, “Oob õor thõom; chi õor thõo simʉn ich agjö thõopʉ̈iju aai sim” a jaaujeejim. ");
INSERT INTO noaE_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pari mua mag chirʉmgui ajim anʉm: Õor thõoba awiajã sĩi dich khapeendam dʉ̈i meeukha nʉmpaijã ich agjö pekaukha öbër sim. Sĩi dich khapeer meeukhamkhĩir i khĩir iekha nʉmjã pekauu; chi mag iekha sim khʉʉn, thethemnaanau khaibag waupi jaauju. Maimua ar sĩi chikham thõp iekha simjã ya sĩi khĩmie durr barpʉ̈ijuuta sim; õor thõoba ab mamʉ ich agjö sĩebahab ajim anʉm, pekauta wau sĩewai. ");
INSERT INTO noaE_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Maguata mag chirʉm: Pʉ, Ẽwandamag nemchaaita ofrendakha deenaa jëwaan mam; pari mag mam ee pʉ khĩir ee dʉnʉisim, ãbmua pʉch dʉ̈i iekkhõrdam paraa sim. ");
INSERT INTO noaE_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Magbaawai pʉch ofrenda chi nemchaain phaajem aig pʉawi, mag pʉch dʉ̈i khaigba sim aar mawi, ithũu i dʉ̈i iyʉ̈ʉ awi, khõinaa nʉisit a jaaumajim anaabá. Maimuan chadau deeu mawia pʉch ofrendadamau Ẽwandamag jëeubamí ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Wa ãbmua khãijã leinaanag pʉ khaibag waumkhĩir pʉch jawaan arrwai, chi thethemnaan aar barwi jaauju nawe, i dʉ̈i wajapha iyʉ̈ʉ awi khõinaa nʉisit ajim anʉm. Magbamʉn chi thethemnaanau guardianaanag pʉ pʉr deebaawai jũrr makhʉʉnau pʉ cárcel deg pʉ̈ijugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cha mʉ iekha chirʉm iekhau, ya pʉʉta amau mag phãar athamʉn, phatkhon gaaimua atarr khai, ãbmiecharam centaaudam phagpʉ̈ibam aigjã amau pʉ öbeerpʉ̈ibajugui ajim anʉm. Mua mag chirʉmʉn, pãach khaibag Ẽwandamag chugpaapiju aai nʉwe chugpaapiwi i dʉ̈i khõinaa ajuuta ẽkhabat a chirʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mag iekhamamua ich Jesuupai amag magjim aajem: ’Pãrau khaphʉ nʉmgui ajim anʉm ĩchab, warrgarwejã pãar jöoinau, “Oob pãach õor khabam dʉ̈i khapes amiet” a jaaujeejim. ");
INSERT INTO noaE_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pari ĩs mua mag chirʉm: Warre khapes aba awiajã, ãbmuata ʉʉi oowi ich ödegpai khãijã, “Jãg ʉʉita magju aai khitaba” a khĩirju simʉn, mag khĩirjubarmuapai ya ich thãar ee pekau waubarm mag ʉʉi dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Magam uguata, pʉ juachaar garm daúa khãijã pʉ pekau waupi sim khai, jẽunaa warre warp barbapʉ̈i. Mag dau ãbpaim gaaimua pʉch mor thum khĩmie durr maju khãai, dau appaita okhoobarmʉn, ʉ̈u simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wa pʉ juachaar garm juau khãijã pʉ pekau waupi sim khai, warre thʉapnaa warp barbapʉ̈i. Jua ãbpaim gaaimua pʉch mor thum khĩmie durr maju khãai, mag jua appaita okhoobarmʉn ʉ̈u simgui ajim aajem. Wajapcharan magʉm pekau waumaaugau dau chukhumjö oobamjönaa magʉm nem khaigbam wawaagjã jua chukhumjö abá, bʉ̈ʉrjã wauba. Magju khãai Ẽwandam dau na pʉch morta sʉrkhabá a chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Pãrau khaphʉ nʉmgui ajim anʉm ĩchab, pãar jöoinau jaauwai, “Ãbmua khãijã ich ʉʉi pʉagpam khai, warre ẽsap gaai ‘Mua pʉ pʉa chirʉm’ a phãnaata irig deeju aai sim” a jaaujeejim. ");
INSERT INTO noaE_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pari ĩs jũrr mua mag chirʉmgui ajim anʉm: Ãbmua khãijã ich ʉʉi deeum dʉ̈i chadcha magba simta pʉa simʉn magan warag juau deeum dʉ̈i magamkhĩirjöta pʉa simgui ajim nʉm, magʉm gaaimua warag pekau waumkhĩir. Mag ich ap sim awi chikhamnau pʉatarr ʉʉita au sim wounjã pekauta wau simgui ajim anʉm, agtha chikham ʉʉikha simta au sĩewai. ");
INSERT INTO noaE_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ĩchab pãrau khaphʉ nʉm, warrgarwejã pãar jöoinau jaauwain, sĩi parhoobam nem igwiata dichdëu nem waum khõsim wauju a iekhaawain, naspawiajã deeu waubam aju aai sim a jaaujeejim. Magarrau “Maach Pör Ẽwandam igwiata mua mag nem wauju a iekhabarmʉn chadau pöd naspawiajã dich iekhatarr chaaur aju khaba sim” a jaaujeejim. ");
INSERT INTO noaE_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pari ĩs mua pãrag mag chirʉmgui ajim anʉm ich Jesuu: Oob bʉ̈ʉrjã nem inagdam igwia khãijã mag gaaimuata nem wauju a iekhamiet. Edjã Ẽwandam khu juupjem aawai oob edjã igwiajã mag gaaimuata nem wauju amiet. ");
INSERT INTO noaE_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mʉg durrjã sĩi Ẽwandam bʉ̈ dʉnʉʉujem aawai ni mʉg durr igwiajã oob mag gaaimuata nem wauju a iekhamiet a jaaumajim anʉm. Wa Jerusalén phöbör igwia khãijã, jãg phöbör thumaam khʉʉn khãaijã chi ʉ̈rʉʉcharam Rey sĩejem phöbör aawai, oob mag gaaimuajã nem wauju a iekhamiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wa dich pör igwia khãijã oob mag iekhamiet; magʉmjã pekauu. Pãach iphithur mag iekhawiajã pãrau pãach pörbʉ̈ ãbjã bäphä paa auba ni phʉisijã paa aubamgui ajim anʉm, ich Ẽwandamaupaita magpiejeewai. Mag nem parhooba igwiata iekha nʉm aig, Ẽwandam igwiata pãar mag iekha nʉm khabahab, nem thum ichdëuta omparr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Magju khãai chadcha nem wauju khai, warre wauju abat. Wa wauba khãijã aju khai, warre ich agjö waubam abat, mag nem inag igwia magʉm gaaimuata wauju a iekhaba. ");
INSERT INTO noaE_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Pãrau khaphʉ nʉm ĩchab, warrgarin pãar jöoinau jaauwai, “Chikhamnau pʉch dau suawai puajã agjö i dën suju aai sim” a jaaujeejim; wa “Chikhamnau pʉ khierr ãb khãijã buathẽupäaiwai pʉchdëujã i dën agjö aju aai sim” a jaaujeejim. ");
INSERT INTO noaE_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pari ĩs mua mag chirʉmgui ajim anʉm deeu ich Jesuu: Ãbmua khãijã pãach dʉ̈i khaigba aawai oob am dʉ̈i agjö khaigba amiet. Magʉmjã agjö pekauu. Magju khãai pʉ khĩidadcha deetarr khai, thoom garjã agjö deemkhĩir irig khĩir ʉabá ajim anaabá warag. ");
INSERT INTO noaE_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ãbmua khãijã leinaanag pʉ jaauwia pʉ camis khãijã khechthʉg aum ig sim khai, warag tagam khajũajã ʉdʉraa irig arrpibá. ");
INSERT INTO noaE_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nem chʉkhʉm khãijã ajués pʉchig kilómetro ãb arrpi sim khai, magʉm aba warag kilómetro numí athaad ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Õrau pʉchig nem jëeuwai ö ajapha magʉm aba deebá. Maimua sĩi pʉchig nem prestaa khãijã jëeuwai deeb khaba deebapʉ̈i ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ĩchab pãrau khaphʉ nʉm, warrgar pãar jöoinau jaauwain, “Pãach khapkhʉʉnta kha khõsinaa pãach kha ukhurm khʉʉn oomapha abat” a jaaujeejim. ");
INSERT INTO noaE_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pari ĩs mua mag chirʉmgui ajim anʉm ich Jesuu: Pãach kha ukhurm khʉʉnjã daupii abat; maimua agjö mʉ iek gaaimua pãach khaibag wauju ẽkhaajem khʉʉn kõitjã warag Ẽwandamagta jëeubat. ");
INSERT INTO noaE_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pãrau magta amʉn magan chadcha pãar ʉ̈gthar Ẽwandam chiraajem chaainau. Ich ag Ẽwandamauta õor wajapham khʉʉn atheejã edau wʉʉpinaa khaigbam khʉʉn atheejã wʉʉpiejem. Ichdëuta ĩchab ich daar agpierraa aajem khʉʉn atheejã noseg chëpinaa sĩi parhoob amach khõchagpierr nem waaujem khʉʉn atheejã noseg chëpiejemgui ajim anʉm. Magua pãraujã agjö thum pãach dʉ̈i khaigba aajem khʉʉnpata daupii aju aai nʉmgui ajim aajem, ichdëu aajemjö. ");
INSERT INTO noaE_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pãrau sĩi pãach daupiim khʉʉnpaita agjö daupii amʉn, ¿maig khan wajaug sĩ? ¿Sĩi Romaam gobierno athee dëbpaar jëeujem khʉʉn chi khaigbam khʉʉnaujã ich agjö aba aajẽ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wa sĩi pãrau pãachjö judionaankha thʉnʉm khʉʉnagpai khãijã saludaakhiin, ¿maigjã khan wajaug sĩ? ¿Ich agjö aba aajẽ judionaan khabam khʉʉnaujã? Pãach meeun khabam khʉʉn awiajã oob amag saludaamapha amiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pãach Aai ʉ̈gthar chiraajemjã chi wajapham aawai pãach chi chaainaujã ĩchab pãach Aaijö ö wajapha abat pãach khapeen dʉ̈i a jaaumajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Sĩi pãach ö wajaug phëmkhĩirpai chan oob chikham dakhĩir nem waumiet ajim anʉm. Bigaaum khʉʉnag magamkhĩirpaita pãrau mag nem wau nʉm paar chan, maach Aai ʉ̈gthar simua pãar wajapha ig iyʉ̈ʉ abaju, ya mʉig eegarwe õrau pãar wajapha ig iyʉ̈ʉ nʉmua ya amau pãrag phag nʉmjöta naawai. ");
INSERT INTO noaE_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Magam uguata, dau aphʉʉm khʉʉndamag nemdam deewaijã oob thumaam khʉʉnag khakhapdö apimiet, sĩi jãg amach ëugar wajapha ig iyʉ̈ʉ amkhĩirpai culto ee wa kaaijã ee khãijã õor khapanag dakhĩir aajem khʉʉn dënjö. Ar jãg amach ëugar wajapha ig iyʉ̈ʉ amkhĩirta aphʉʉm khʉʉndam dʉ̈i ö wajapha aajem khʉʉnan, ya õrau amag phagbarmjöta nʉmgui ajim anʉm, am ëugar wajapha iekha nʉmua. Jãgʉm khʉʉnag khanii Ẽwandamau tag phagbarju. ");
INSERT INTO noaE_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dau aphʉʉm khʉʉndamag nem inagdam deewai oob pãach khapeen pãach dʉ̈i chi wajapcharam khʉʉnagjã jaaumiet. ");
INSERT INTO noaE_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Magju khãai warag pãach khaugpimaphamjö meraata deebat ajim anʉm. Pãrau mag meraa deewiajã, pãar Aai ʉ̈gtharmua pãar oo sim aawai, ichdëujã pãar eeg oob khaba eeg ooju a jaaujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mag nem jajawagmamua ich Jesuu magjim anʉm: ’Pãach Ẽwandamag jëeuwai, oob jãg sĩi chadcha magba nʉmta Ẽwandamag jëeu nʉm amkhĩir jãg õor dakhĩirpai jëeujem khʉʉnjö amiet ajim anʉm. Jãkhʉʉnan sĩi õrag amach oomkhĩirpaita culto ee maimua sĩi kaaijã eejã agjö Ẽwandamag jëeu nʉm anʉmua bʉ̈jãaupaita ijẽjẽb aajerramgui ajim anaabá. Jãg amach ëugar wajapha ig iyʉ̈ʉ amkhĩirta jãg nʉm khʉʉnan, ya õrau amag phagbarmjöta nʉmgui ajim anʉm, am ëugar wajapha iekha nʉmua. ");
INSERT INTO noaE_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pari pãrag mua jaaukhim: Ẽwandamag jëeuwai, am dënjö khaba, pãach khãaijem thuur wai nʉm khai, aar dubnaata pãach appai irig jëeubat. Mag pãach appai nʉmjö naab mamʉ, maig pãar dʉ̈i sim pãar Aai. Mag pãar Ayau pãrau pãach appai ichig jëeu nʉm oobaawai pãrag irua pãachdëu nem jëeu nʉmjã deeb khaba deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Mag irig jëeuwaijã oob jãg par iiupai Ẽwandam iek ʉ̈kha nʉm anʉm khʉʉn dënjö parhoobam iek maadëu igbaju ayaampata iekha nʉʉ amiet ajim anaabá. Amachigan jãg jëeubaadëm pʉa chʉuu aawaita Ẽwandamau ʉ̈rcha amach iek ũurjempii aajerram ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pãrau ichig jëeuju nawe pãar Ayau ya pãrau nem ig nʉmjã khaphʉ sim aawai, oob am dënjö atcha iekha nʉʉ amiet. ");
INSERT INTO noaE_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Magju khãai pãachdëu irig jëeuwai mʉgta jëeubat ajim anʉm: “Ẽwandam, pʉʉta maar Aai ʉ̈gthar chiraajemʉu. Pʉch appaita chadcha pekau chukhu chitʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pʉrʉgta marau maach dʉ̈i pʉchdëu ampierr apinaa pʉchta thumaam khʉʉn Pörkhapim khõsi nʉm. Ʉ̈gtharjã jãg pʉchdëu nem waupi jaau nʉm appai waaujemjö, mʉig eegarjã thum pʉchdëu jaau simjöta apim khõsi nʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ed ëepierr pua marag ich jãg khöjudam deebarju. ");
INSERT INTO noaE_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ẽwandam, maar pekau thum chugpaabapʉ̈i, maimua ar marau maach dʉ̈i khaigba abarm khʉʉn dʉ̈i tag magʉm iek igba ich mag khĩir okhoopäaijemjö, maar dënjã khĩir okhoobapʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Oob pua ʉdʉraa chan maar pekau ee burrpi chiram. Mag khãai warag maar thʉa wai chirsí, phithurg chukhu dösãtau maar ichig paa aum ugua. Ẽwandam, pʉchdëuta nem thʉnʉmʉn thum khap chirʉm. Pʉchta chi jua thierriu, maagwai pʉchpaita thumaam khʉʉnau thö iekhaju aai nʉm, mʉg atag pawiajã ich mag.” ’Magta jëeubat ajim anaabá ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Magnaa ĩchab, Chikhamnau pãach dʉ̈i khaigba aawai, pãrau am dʉ̈i magʉm iekjã igba sĩi khĩir okhoopʉ̈imʉn, magan maach Aai ʉ̈gthar chiraajemuajã ĩchab pãar pekau chugpaapʉ̈iwia tag magʉm iek igba ich mag khĩir okhoopʉ̈ijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mamʉ pãrauta pãach khapeen wir aig perdonaabam chan, maach Aai Ẽwandamaujã pãar pekau chugpaabamgui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Pãach Ẽwandamag jëeu khëwaag thach khöba sʉrkhaawai, oob jãg sĩi amach ëugar wajapha ig iyʉ̈ʉ amkhĩirpai nem waaujem khʉʉnjö jãsogau ökhĩirjuumjö amiet ajim anʉm, mag oowi bigaaum khʉʉnau “Jãan Ẽwandamag jëeu nʉmua sʉrkha naawaita jãg nʉm” am ugua. Jãg amach sʉrkha nʉm khap amkhĩirpaita ökhĩirjuumjö aajem khʉʉnan, ya õrau amag chi phagamjöta nʉmgui ajim anaabá, am igwi chadcha sʉrkhaajem khʉʉnau anʉm gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Magju khãai Ẽwandamag jëwaag sʉrkhaawai, warag wajapha pãach khĩir sũgpʉ̈inaa pör megbapʉ̈it, ");
INSERT INTO noaE_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bigaaum khʉʉnau mag pãach sʉrkha nʉm ni ãbmuajã khap am ugua. Pãrau magta amʉn, ãba maach Aai pãar dʉ̈i simuapaita khap aju; maagwai ichdëuta ĩchab pãar eeg oojugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Mʉig eegarwe chan oob phatkhon wa nem inag pöm khãijã paarpaju ẽkhamiet. Mʉiguin nem thum polieu ãrnaa khukhungaujã jẽeumaajem; mag nʉm dʉ̈i nem jĩgmienaujã sĩi dubwia jĩgkhamaajemgui a jaaumajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Magju khãai nem wajapha wau nʉmuata phatkhon ãkha phiemam dʉ̈i nem inag pöm paarpamamjö abat, ʉ̈gthar paimaawaijã chadcha paraa naaimaag. Pãach jam paaukhaimaawaim atheeta pãrau phatkhon phie nʉmjö nem wajaphamta wau nʉmʉn ʉ̈u simgui ajim anʉm. Jam chan polieujã ãrba, khukhungaujã jẽeuba, ni nem jĩgmienaujã pöd jĩgkhabam. ");
INSERT INTO noaE_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mʉig jẽb gaai nʉweta nem thum paraa aju khĩirjuju khãyau ʉ̈gthar paawaita nem thum paarpaju khĩirju wënʉrrʉmʉn, magan chadcha pãar khĩirjug ãba Ẽwandam gaaita sim ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Maach daun õtdaujöta sim maach mor gaai. Maach daujãata wajapha sim aiguin, nem thum dawaata oojem. Ich agjöta sim maach thãarjã. Ẽwandam iek ʉ̈khanaa maach thãarta wajapha sim aiguin, nem thum Ẽwandamau khõsimjöta waaujem. Mag nʉm aiguin ararag ee nʉmjöta nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mamʉ magba agtha pãach pekau ee nʉmʉn, magan pãran sĩi agtha khĩchag ee jʉrkha jʉrkha nʉmjöta nʉm. Mag nʉm aig pöd Ẽwandam dʉ̈i naaju khaba nʉmgui ajim anaabá, pekau eeta naawai. ");
INSERT INTO noaE_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni ãbmuajã pöd patronnaan numiim khʉʉn chogkhaju khaba simgui ajim anʉm. Patronnaan numí akhiin, iwiir ãbpaita ʉ̈rcha kha khõsi aju. Ich agjöta sim ĩchab Ẽwandam dʉ̈ijã. Pöd pãrau Ẽwandam khĩrag wʉrpanaa, phatkhonag khãijã wʉrpaju khaba nʉm. Pãar magta nʉm chan Ẽwandam ipierraa khaba nʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mag nem khĩir pogkhe jajawagmamua magjim anʉm ich Jesuu: ’Oob pãrau “¿khani khöju wa khanta döjuuta maach mʉg nʉma?” a khĩirjumiet. Wa magbam khai, ya khajũa chukhu nʉm “¿Khani jũajuuta mʉg nʉmua?” a khãijã khĩirjumiet ajim anʉm. Pãarta nem khoojem nem khãaijã wajapchanaa khajũa khãyaujã Ẽwandam dau na ʉ̈rʉʉcha balee sĩsid aawai, irua pãrag oobamjöo abajugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pãadë ar nemchaaindam edjã ee ũrr phophog aajem khʉʉn oobat. Am phidkhajã phidkhaba aajeewai amach phathaudam ãkhaagjã di chukhu nʉm. Mag phidkhaba sĩi naajeeb mamʉ, maach Aai ʉ̈gthar chiraajemuata amag phathaudam daumeraa dee wai simua am khee wai sĩejemgui ajim anʉm. Magʉm pãar chará nemchaain jãg thʉnʉm khãaijã ʉ̈rcha balee naawai, ¿jãga irua bʉ̈ʉrjã pãrag ooba abarju? a jaaumajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oob atcha pãachdëu nem ig nʉmta khĩirju nʉʉ amiet. Mag pãrau pãachdëu khõsimta ig nʉʉ akhiinjã, ¿khaíuta mʉg nʉm aig mag ichdëu khĩirju sim gaaimuapai ich meeju arr ʉ̈r oradam ãbpai khãijã ich iiupiju aai sĩ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Mag nʉmta khajũa chukhu aawaijã ¿khanthee atcha khĩirju nʉʉ aajẽ? Pãadë ar pamaardam ooihmʉ thʉnaajem khĩirjubat. Amjã ĩchab bʉ̈ʉrjã phidkhajã phidkhaba, ni amach khajũa jũaju khĩirjuwia ẽkhakha nʉʉjã aba aajem. ");
INSERT INTO noaE_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mag naab mamʉ õor ãbmuajã am dʉ̈i barba aajem, ooimʉg athee. Warrgar rey Salomón khararraujã phatkhon pöm paraanaa nem wajapham pöm paraa aajerraujã pamaardam ooimʉgjö chan pöd khajũa jũaba aajeejimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pamaar jãg ooihmʉ thʉnʉm edau wʉʉbaadëmuapai khiugphëbaadeewai sĩi khʉʉijemjã Ẽwandamau jãg ooihmʉ wai sĩejemta, ¿jãgwi pãar pamaar khãai ʉ̈rcha balee nʉmua nem jëeu nʉmta irua deeba abarju? ¿Wa pãachdëu jëeu nʉmjã pöd deebajupii aajẽwa? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Oob atcha “¿khanta khoogáwa?” wa “¿khanta doogáwa?”, wa magbam khai, “¿khandamta jũabaraag khai?” amiet ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pãrau khaphʉ nʉmgui ajim anʉm, õor Ẽwandam iek ʉ̈khabam khʉʉnta magʉm nem thum khĩirju phöbaadëmjã pʉaba sĩerrjëem. Mamʉ pãar Aai ʉ̈gthar chiraajemua pãrau nem ig nʉmjã thum khaphʉ sim aawai pãar chan warm khʉʉnjö magbaju aai nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ãba Ẽwandamau nem waupi jaau simpaita waunaa irigpaita pãach dʉ̈i ichdëu ampierr apibat. Pãrau chadcha magta amʉn, tagam nem pãachdëu igbarmjã irua deeb khaba deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Oob atcha “¿Khanta nan khöbarju wa khanta jũabarju?” a khĩirjumiet. Ag nawe khĩirjuwiajã par khabahab ajim anʉm. Phithurgan ãspapakhampierr oojem. Magua maadëu ag nawe khĩirjuba awiajã, ichiita maadëu nem ig nʉm chan chuk khabajugui ajim anaabá, magʉm khĩirjuju aag. ");
INSERT INTO noaE_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Chikham ĩgkham khõchgaupai chan oob chikham pekau phëmiet, eeu Ẽwandamau pãach chach nʉm ed magʉm iek pãachig igdukham ajim anʉm Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pãrauta chikham jaaum khõchgau “Jãan magta sĩerrʉm” amʉn, pãachdëu chikham jaau nʉmjö aju Ẽwandamaujã pãar dʉ̈i. Pãachdëu chikham jaau nʉmjö ich ag jaautarr iekhau Ẽwandamaujã pãach khĩir pãar jaau thʉnʉʉujugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mag simta ¿jãgwi pua sĩi pʉch khapeer dau ee pasurdam wai simta eerpa nʉʉ aajẽma, pʉch dau eejã agjö pasur pömkham wai sim khaugba? Maachin nacha dich khĩirjunaata iekha nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jãga pua pʉch khaperag, “Daai kakë, mua pʉ dau eem pasur noi aukhim” aju, pʉch dau eejã ag khãyau nem pöm sim joothʉ thʉnʉm noi auba simta? ");
INSERT INTO noaE_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Khĩirjug chukdam, nacha dich dau eem pasurta noi auba aajeeb ajim anʉm, wajapha oog; maimuan chadau jũrr dich khapeer dau eemjã agjö noipʉ̈i nʉm. Magua dichta nacha khĩirjuba aajeeb chikham jawaag. Dichjã agjö chirʉm chan pöd dich khapeen jaauju khabam ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Magnaa mag jajawagmamua ichdëupai, ’Saak khõriimjö sĩsidʉm khʉʉnag oob mʉg pãach peerdʉajem iek jaaumiet, eeu magbam jãgʉm khʉʉnau warag pãach gaai mas adukham ajim anaabá. Mʉg iekta nem thumaam khãai chi wajapcharam aawai khũsnaanjö nem wajaphamjã aai abam khʉʉnagjã oob mʉg iek jaaumiet, eeu warag sĩi nem parhoobamta jaau nʉmjö ag igwia khaigba iyʉ̈ʉ adukhamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Maimua ĩchab ich Jesuupai magjim anʉm: ’Pʉaba jëeubat; pãachdëu nem igbarm Ẽwandamau deeju. Pãrau i jʉrmʉn, i baauju; i sim aar dubaag pãach weeu aupi jëeumʉn, irua pãar weeu auju ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pãrau khaphʉ nʉmgui ajim anʉm, ar õor nem jëeu paraam khʉʉnagan deeb khaba deejem; ar amachdëu nem inag ig nʉm pʉaba jʉr nʉm khʉʉnau baaujem; maagwai ĩchab chi puertdi sirbaichëm khʉjã weeu auwia dubpiejem a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Pãrau ãbmua khãijã pãach chaairau thachdam jëeubaawai, ¿mokdauta phëdeeju khai, thach awi? ");
INSERT INTO noaE_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wa magbam khai, chaairau ãwarrdam khãijã jëeu khitaawai, ¿nemkhõrta ãwarr awi thõo deeju khai? Ni ãbmuajã mag chan abajugui ajim anʉm ichdëupai. ");
INSERT INTO noaE_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Magnaa, Pãar jãg ö ãkhãraa khithëem khʉʉnaujã pãach chaainau nem jëeuwai, ¿nem wajaphamjã ĩgkhaba deeba aajẽ? ajim anʉm. Pãrau jãg deejem khai, pãar Aai ʉ̈gthar simua chará pãrau pãach chaainag nem deejem khãaijã wajapcharamta deebajup ajim anʉm, ichig jëeu nʉm khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Magua mua pãrag ĩchab mag chirʉmgui ajim anʉm: Chikhamnau pãach dʉ̈i khaigba apimapha nʉm khai, pãach garmuajã oob chikham dʉ̈i khaigba amiet. Õrau pãach dʉ̈i apim khõsimjöta pãach garmuajã am dʉ̈i abat ajim anʉm. Moiseeu ley phã pʉatarr gaaijã magta jaaunaa ĩchab Ẽwandamau ich iek jaaupiejerr khʉʉnaujã ich magta jaaujerr aawai, magta aju aai nʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ʉ̈gthar öbërm khõsi nʉm khai, puertdi phĩrkhim garta dubju ẽkhabat ajim anʉm Jesuu. ¿Jãgwi? Dösãt aar maajem khʉdta khʉdjã pömnaa chi puertdijã nem wäg sĩejeewaima. Mag sim garta õor pöm ërërëu aajem. ");
INSERT INTO noaE_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pari jũrr ʉ̈gthar arrjem khʉdan phĩrkhinaa chi dub nʉm aram puertdijã phĩrkhi khitʉm. Mag sim aawai chadcha dubju phithur sĩerrʉmgui ajim anʉm. Magua ĩchab mag gar chan õor pöm wëtba aajem ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Kharin Ẽwandamau ich iek jaaupibaawaita i iek jaau wënʉrrʉm aajem khʉʉnan chi sëumienta mag wënʉrraajem. Magʉm khʉʉn dʉ̈i khĩir khaphʉ abat ajim anʉm. Mag sĩsidʉmta pãar khũguraag sĩi ovejadamjö daumeraa pãar aig bëejem. Pari am ödiin sĩi khum nem oo wai simjöta sĩsidʉmgui ajim anʉm, pãarjã amachjö amkhĩir amach gar thereu awaag. ");
INSERT INTO noaE_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ich jãg miu gayam uva phierrba ni igojã ag bʉ̈ gayam khabam phierrba aajemjö, amau nem wau nʉm gaaimua pãrau am khaphʉ aju aai nʉm, õor wajapham khʉʉná wa õor khaigbam khʉʉná. ");
INSERT INTO noaE_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pãrau khaphʉ nʉm, nemjĩir bʉ̈ʉn ich chë sim gaaimuata khaphʉ aajem, nemjõ ajaphamʉ́ wa nemjõ khaigbamʉ́. ");
INSERT INTO noaE_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nemjõ ajapham chan mie neeme chëba ni nemjõ ãkhãraamjã mie chukkhu khaba sĩerrʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pãrau khaphʉ nʉmgui ajim anʉm ĩchab, nemjõ ãkhãraa cheejemʉn thu wërpnaa jʉʉubaadee örpäaijem. ");
INSERT INTO noaE_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ich agjöta ajugui ajim anʉm Ẽwandamau mag sëukha nʉrrjëem khʉʉn dʉ̈ijã, mag nemjõ ãkhãraamjöta naawai. Magua khaphʉ abat: Õran amachdëu nem wau nʉm gaaimuata amachdëupai amach jaaujem, õor wäjäauná wa õor khaigbam khʉʉná. ");
INSERT INTO noaE_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mag iekhakhagmamua Jesuu magjim anʉm ĩchab: ’Ar mʉrʉg “Señor, Señor” aajem khʉʉnjã thum chan Ẽwandamta thumaam khʉʉn Pörkha sim aar öbërbam. Chi öbërju khʉʉnan, ar mʉ Aai ʉ̈gthar simua nem jaau sim ipierraa aajem khʉʉnpaita i sim aar öbërjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mag ed paawai õor pöm thʉnʉm eemua mʉrʉg par amach iphithur, “Señor, pua maar khaugbata sĩeba. Pʉ thʉ̈r gaai marau pʉ iek õrag jaauba aajeejieb. Pʉ juapaau khabajieb, marau õor mor eem mepeerjã jʉr wërpnaa ag na õrau ooba aajem nempa waaujerr. ¿Magtarrta pua maar khaugba chirʉ́?” ajurau ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pari magbaawai mua amag, “Mua chan bʉ̈ʉrjã pãar khaugba chitʉm. Pãach sĩi pãach khõchagpierr nem khaigbampai wau sĩerrjëe arr khap, pãadë warag pãachta mʉ aigmua ërëubaadët” aju a jaaumajim anʉm, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Magua, ãbmiecha paawai pãrag mag chirʉmgui ajim anʉm, ich Jesuu: Chi mʉg mʉ iek ũrnaa mua jaaumam ipierraa nem wau sim wounan, woun ãb khĩirjug khaug sĩerrau durrkhudau ee ich dibʉ̈ jukhanaa di ëutarrjöta simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mag durrkhu ee ëu sĩerr aawai, noseg pöm chëwia, dö pöm bëewia, phũãd pöm wëtarrjã, chʉababa ich mag sĩsijim anʉm, durrkhu eeta wajapha jukha dʉnarr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pari jũrr ar sĩi par jʉ̈gʉupai mʉ iek ũrnaa mua nem jaau chirʉmjã mʉ ipierraa wauba sim wounan, jũrr agjö woun ãb khĩirjugjã chukhu sĩi khõmarii mosjã ee di ëutarrjöta simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ya ëu dʉnʉisim ee noseg pöm chëwia, dö pöm aadëm dʉ̈i phũpa wëbaadeewai, sĩi aphëbaadëjim anʉm. Mag, nem thumaa okhoojim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chadcha Jesuu mag nem khĩir pogkhe jaaubarm ũrwia sĩita õor jʉ̈gderraa naajim anaabá, ");
INSERT INTO noaE_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","amachdëu ũurwai Jesuu Moiseeu ley phã pʉarr jawaag chi khaphʉm khaphʉm aajem khʉʉn khãyaujã jaau khaphʉcha jaaumatarr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mag durrsĩ gaai Jesuu õrag jaau sĩi awia ʉʉrbaau, õor pöoma i ẽudee wëtjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mag i mamta i khĩirphee woun ãb kokobé bënëu bar sim öbërchëwia i khĩirphee jĩepör phõbkhanaa irig, —Señor, pua khõs chirʉm khai, mʉg phĩedau warre mʉ gaaimua chugpaabapʉ̈i aichëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Magbaa Jesuu i gaai pʉrnaa, —Mua pʉ monaaupʉ̈im khõsi chirʉm; monaau chirsí magan ajim anʉm irig. Magbarm bʉ̈rre chi phĩe kha dodos chirarr monaau sĩsiewai mor wajappha aadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Magbaadeewai chi Jesuu irig, —Pʉch mʉgbarm oob chikhamnag jawamgui ajim anʉm. Magju khãai nacha Jerusalén mawia Aai i jëeujem degam phadëg pʉch mor oopibaimá. Maimuan chad pʉch chadcha monaau sĩsim thumaam khʉʉnag khap amkhĩir, Moiseeu iek phã pʉarr gaai jaau simjö nemchaain ofrendakha deebá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mag kokobé bënëu sĩerr monaaupʉ̈iwia petaau, phöbördam Capernaum anʉm ee dubimajim aajem. Mag barbaimam khaug athaawai capitán soldaaun pör i aig bëewia ");
INSERT INTO noaE_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","irig chaigpamamua, —Señor, mʉ di aar aaunaan wai chirʉm, mʉ chog. Sĩi put eepai pöd phiidʉba khërʉm, kha chʉkhʉ khitaawai. Mag nʉm dʉ̈i kha machagaupata warag eeg pamam ajim anʉm, chi capitanau Jesuug. ");
INSERT INTO noaE_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Magbaawai Jesuu jũrr irig, —Oob khĩirjum; mua pʉ chog monaaupäain majugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pari magbaa chi capitán garmua deeu Jesuug, —Señor, pʉ mapimaaugau khabam, pari mʉ chadcha Ẽwandam dau na ʉ̈u khaba chirʉm, pʉ mʉ deg dubaag. Ich maupaimua mʉ chog monaaupi jaaubá. Pua mag jaaumʉn, pʉch iekhau aawai i monaaubajupa ajim anʉm Jesuug. ");
INSERT INTO noaE_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Muajã mʉch gaaita khaphʉ chitʉmgui ajim anʉm, mʉchjã ĩchab mʉch pörnaan jua eegarpai chiraawai. Mag chirab mamʉ, mʉchdëujã ĩchab soldaaun mʉch jua eegar phë wai chirʉm. Makhʉʉn ee ãbamʉg khãijã mua “Pet” aawai maajem, mʉ ipierraa; maimua deeumʉgjã “Pidú” aawai bëejem. Wa mʉch chogag khãijã “Mʉgta abá” aawai mʉ ipierr aajem. Magua, maupaimua pua monaaupi jaaumʉn chadcha monaauju khaphʉ chirʉmgui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chi capitanau ich jʉ̈g daar mag iekhabaawai jʉ̈gderraa aadëmua ich ẽudee wëtmarr khʉʉnagta, —Keena, pãadë oobat: Mʉg maach israelnaan ee mʉg woun dënjö ʉ̈kha nʉm chan mua agtha ooba chitʉmgui ajim anʉm ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chadcha mʉg atag õor pöm durrpierram khʉʉnta maach jöoin Abrán khararr dʉ̈i, Isá khararr dʉ̈i maimua Jacob khararrpa ʉ̈gthar Ẽwandam dʉ̈i ãbam mes gaai ohood aphöbaadëju, i dʉ̈i ãba thach khoog. Maig thʉnaaju: ed öbeerjem garm khʉʉn dʉ̈i edau burrjem garm khʉʉnpa maach meeun dʉ̈i ãba. ");
INSERT INTO noaE_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pari mag ed pãar chi israelnaanta chadcha Ẽwandam thumaam khʉʉn Pörkha sim aar naaju aai nʉmta, pãachdëu ʉ̈khaba nʉm gaaimua pãachta jũrr khĩmie durr barkhʉʉipʉ̈iju ajim anaabá, amach khĩircha. Mam barkhʉʉibapäaiwaita icharaucha pãar bĩep jẽbʉ abarju. Maigta mamag khaphöbaadëmʉn ich maig ich mag nʉisim iekhau a jaaumajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mag iekhapʉ̈iwi deeu chi capitanag eerpanaa, —Pʉch diig petá; pʉchdëu ãba mua pʉch chog monaaujupaita khĩirju sĩewai chadcha pʉ chog monaaujugui a ajim anʉm irig. Mag Jesuu “Pʉ chog monaauju” abarm bʉ̈rre mam warp mor mas khërarrta chadcha monakkha aadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Maimua petaau, ich Jesús jũrr Pedro di aar majim aajem. Mam barwi ooimaawai, ich chi Pedro phaauhũan mor mas khʉʉumie paar thʉnʉm ooimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mag oobaimaawai Jesuu i aar mawi i jua gaai pʉrbaawai, warre chi khʉʉumie meeudʉbaadëjim anaabá. Mag khʉʉumie meeudʉbaadee, phiidʉwi am jãogaagpajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Maimua ya edau khëubaadëm ee, õor dösãt bënëu sĩsidʉm khʉʉn khapaana Jesús aig waibëemajierram anʉm. Mag ich aig waibëe nʉm khʉʉnan, sĩi par iekhaupai öbeerpi jaaubaawai, mag am mor eem bën khaigbamjã öbeerpʉ̈inaa sĩi khajapham khamor machgau sĩsidʉmjã monaaupʉ̈i maajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mag irua õor monaaumaajerran, warrgar Ẽwandam i jaaumie Isaías khararrau jaautarrjö, “Ichdëuta maach kha thũg ich gaai auwia, maach khamor machagjã chugpaapʉ̈ijim” a simjö, chadcha ich ag eyaa öbërmkhĩir ajim. ");
INSERT INTO noaE_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mag õor pöm bëe thʉnʉm khʉʉnau ich phʉʉr thuurbaadeewai Jesuu ich ag thʉrrdö eepai thoom igar ich arrpijim aajem, ich khapeenag. ");
INSERT INTO noaE_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pari mag nʉm ee Moiseeu ley phã pʉarr jawaag chi machnaan eem ãb bëewi irig, —Maestro, mʉʉn pʉ mampierr pʉ dʉ̈i chitam khõsi chirʉm aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Magbaa jũrr Jesuu irig, —Pʉchdëu mag mʉ dʉ̈i mam khõsi chirʉm khai, marrau magan; mamʉ pʉrʉg jaaukhimgui ajim anʉm: Mʉ khãyau pabʉ̈ eem nemchaain amach khãaijem jẽbdi paraam; nem ichpanjã kheeupaawai amach khãaijem khãidu wai sĩsidʉm. Mamʉ mʉch chi Emkhooi Iewaa chan mʉg chitʉm aig khëubaadeewai khãyaag wajapha werba chiraju didamjã chukhu chitʉmgui ajim anʉm. Pʉjã mʉjö magta chitam khõsi chirʉm khai, marrau magan ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Magbaawai ãb mag khapan thʉnʉm ee dʉ̈i i iek ũraag i ẽudee nʉrraajerrau jũrr irig, —Señor, mʉjã pʉ dʉ̈i chitam khõsi chirʉm, pari idëu nacha mʉch aai aar mawia i dʉ̈i chirʉʉ apibá ajim anʉm. Mʉg atag mʉch juadamaucha jöoi aukhër pʉabajeen chadau mʉ pʉ dʉ̈i ogdʉba chitajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Magbaa jũrr Jesuu irig, —Magju khãai warre mʉ dʉ̈ita marrau ajim anʉm. Idëu ar jãg amach Ẽwandam iek ʉ̈khamaaugau chi thõmjö nʉm khʉʉnagta amach binaan bëppibá ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mag ich arrpibaawai, ya wëtumua Jesús am na jap ee waaidʉbaadeewai, chi khapeenau i arrjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ya mag döjãrr paaukhabaadëm eeta, dëgölp phũas meeukhabaadëwi phũas theega japau pöd ãwatbajujö aadëjim aajem. Pari mag thʉnʉm ee ich Jesús khãi jörrajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Magbaawai i khapeen ãaur khʉʉnau i phiriupʉ̈yaan wëtwia irig, —Señor, phiidʉbaad. Ya maach khöogpabahaba. Maar khaigpër athá ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Magbaawai ichdëu amag, —¿Khantheeta atcha jãphierr nʉma? ajim anaabá. Jãgan pãrau chan mʉ pãach dʉ̈i chitʉmjã khaugbata naab ajim anʉm, jãgcha jãphierraag. Magnaa phiidʉwia phũug meeurrau sĩunaa ĩchab chi phũasagjã meeurrau sĩubaawai, tag phũjã wëba, phũasdaujã baupa khaba, warre sĩi döjã meuu jöisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jesuu amach dakhĩir magbarm oowia dauderraa nʉmua amach wir aigpaita, —Keena, ¿khanim wounta jãg mʉg phũasaujã i ipierraanaa phũujã i ipierraata nʉma irua iekhaawai? anaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mag wëtmaa awia, ya thoom igar Gadara durr paaukhabaimaawai, wounaan numí dösãt dau eerpamieu bar sĩsidʉm khʉʉnta ujã aarmua öbërdʉtkhachëwi, chi Jesús sim dakha bëejierram aajem. Mag sĩsidʉmʉn sĩi pabʉ̈ eem nem maach khoojem khʉʉnjöta sĩsid arr aawai mag am nʉm gar õor dichju akhʉr aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mag i dakha bëewi i thʉ̈rcha thʉ̈rthʉ̈rnaa irig, —Jesús, Ẽwandam Iewaa, ¿khantheeta pʉ maar dʉ̈i mʉgbaichëma? Mʉʉgwaiwe chan oob maar chig a chiram ajierram anʉm, mag chi dösãt bën wai narr khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Maigmua warpcha khaba khũsnaan khapan phathau jʉr khö wënʉrrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Chi mepeenaujã makhʉʉn khũsnaan maig wënʉrrʉm khaphʉ narr aawai warag Jesuug chaigpanaa irig, —Pua maar jʉrkhʉyaagpam khai, idëu warag jãkhʉʉn khũsnaan eeta marag dubpibá ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Magbaawai Jesuu amag, —Magan jãkhʉʉn khũsnaan ee dubjurauma ajim anʉm. Magbaawai makhʉʉn mepeen makhʉʉn wounaan eemua öbërdʉtkhawi jũrr makhʉʉn khũsnaan eeta dubphöbaadëjim anaabá. Magbaawai sĩi pör lököomjö parhooba thʉrrdöog khaphig phöbaadëwi dö ee dʉrbagkha sĩi khũsnaan khapan khẽu khuurbʉ khëchjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Magbarm oowi, chi khũsnaan thʉa narr khʉʉn jãphierrwi, phöbörög khaphig phöbaadëwi, mag wounaan numí dösãt dau eerpamieu sĩsid arr mor eem mepeen öbërdʉtkhawia jũrr khũsnaan ee dubtarr thumaa phöbör eem khʉʉnag jaaumajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Magbaawai chi phöbör eem khʉʉn khapan ag bʉ̈rre chi Jesús aar wëtwi warag ichta maigmua jũrr deeum durrag mapi jaaujierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mag õor mor eem mepeen jʉrkhʉʉiwi, deeu ich khapeen dʉ̈i jap ee pawi dʉrbabaadeeu, deeu thoom igar ich sĩerr phöbör ee sĩeimajim aajem, Capernaum phöbör ee. ");
INSERT INTO noaE_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mag i barbaichëm khaug athaawai woun ãb sĩi khapá jʉser khitʉmta pa bʉʉrkham gaai i aig aibëejierram aajem. Mag ich aig aaunaan wai barbaichëm oowia, chi wounaan ö akhaar ãba iruata amach aaunaan monaaupʉ̈iju khaphʉ sĩerr aawai, chi khapá jʉser khitʉmʉgta, —Onee abá, pʉ pekau ya thum chugpaa sĩsimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pari Jesuu mag iekhabarm ũrwia, Moiseeu ley phã pʉarr jawaag chi machnaanjã aig thʉnarr aawai, amach ödegpai, “Mʉg woun maachjöpai sĩewai mag iekhaju khaba simta ichta Ẽwandamjö mag iekha sim” a khĩirju naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mamʉ amau mag khĩirju nʉmjã Jesuu khaphʉ sĩerr aawai magbaawai amag magjim anʉm: —¿Khantheeta pãar jãg thãar khaigbata khĩirju sĩsid aajẽma? ");
INSERT INTO noaE_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Wa mag pekau chugpaabarmjã dau daau ooba naawai pãrau khĩirjuawai chadcha phithurg chukhu thumaam khʉʉnau mag iekhaju aai nʉm a nʉwa? Chadcha thumaam khʉʉnau mag iekhaju aaima. Mamʉ mua irig “Phiidʉwi dʉrdʉr abá” akhiin, õrau amach daúacha ooju, i monaau sĩsi wa monaauba khãijã ich mag sĩsim. Magua pãrau cha mua jawaagpamjö chan abaju. ");
INSERT INTO noaE_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mamʉ mʉch chi Emkhooi Iewaata chadcha Ẽwandamau juapá deetarrau mʉig eegar õor pekau chugpaagjã jua theeg chirʉm khap amkhĩir, pãrag oopikhimgui ajim anʉm. Magnaa chi khapá jʉser khitʉmʉgta, —Phiidʉbaad, maimua pʉch put juurwia pʉch diig petá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jesuu ichig magbaa chadcha chi khapá jʉser khitarrau i ipierr nem moná phiidʉbaadëwi ich diig petajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Magbarm oowia aig narr khʉʉn dauderraa nʉisijim anʉm. Mag nʉm iekhau warag Ẽwandamagta, “Ʉ̈uhcha jãgbarm, Ẽwandam. Jãan pʉch jua theegauta mʉg wounag jãgpibarm” ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mag ãb khapá jʉser khitarr monaaupʉ̈iwi bëeuta, õrau gobiernoog dëbpaar phagaan bëejem mes gaai mʉ oo chirʉm oochëjim ich Jesuu, mag gobiernoog õrau dëbpaar paraa nʉm jëeu nʉm phidagta phidkha chirarr aawai. Maig mʉ oobaicheewaita ich Jesuu mʉ thʉ̈rcha thʉ̈rnaa, —Mateo, mʉ dʉ̈i marrau ajim. Magbaa chadcha mʉ i dʉ̈i mawia ich mag i bʉ̈ ogdʉba chirsijim. ");
INSERT INTO noaE_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ag khur maach ich dʉ̈i ogdʉba wënʉrraajerr khʉʉn thum ãba ich Jesús dʉ̈i mʉ di aig thach khö naajim. Mag maar thach khö nʉm aig ĩchab õor khapan mʉ khapeen mʉ phidkhaajerrjö Romaam gobierno athee dëbpaar jëeujem khʉʉn dʉ̈i sĩi õor amach khaigba nʉm gaaimua agjö thʉ̈rphöo aajem khʉʉnpa bëewi maar aig ãbam mes gaai ohood aichëjim. ");
INSERT INTO noaE_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mag oobaawai, Moiseeu phã pʉatarr wajapcha ʉʉrkhaajem khʉʉnjã aig narr aawai, jũrr mag maach chi Jesús dʉ̈icha wënʉrraajerr khʉʉnagta, —¿Jãga jãg pãar maestro sĩi dëbpaar jëeumien dʉ̈i pekau pöm sĩsidʉm khʉʉnpata ãba thach khö sĩ? a jëeujierram. ");
INSERT INTO noaE_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pari amau mag jëeubaichëm ich Jesuujã ũr sĩerr aawai amag magjim: —Chi kha monakha nʉm khʉʉnau chan doctor igba aajem; mor masi nʉm khʉʉnauta doctor iigjem ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Maimua magjim ĩchab: —Wajapha khĩirjunaa Ẽwandam iek phã sim gaaim mua jawaagpam khap abat. Chi phã sim iek gaai Ẽwandamau mag sim: “Muan pãragan sĩi nemchaainta khëchnaa mʉrʉg jëeu nʉʉ aju khãai, pãach khapeenta ʉ̈rcha dau aug khaug paraa apim khõsi chirʉm” a simgui ajim Jesuu. Maguata muajã am pekau pöm nʉmjã igba, am dʉ̈i thach khö chirʉmgui ajim. Mʉ chan bʉ̈ʉrjã pekau chukhu wajapha khithëem aajem khʉʉn jʉraanjã bëeba, mʉʉn õor pekau pöoma khithëem khʉʉn peerdʉ awaanta bëejimgui ajim, khĩirjug iiur aumkhĩir. Maguata mag õor pekau pöm nʉmjã igba, am dʉ̈i thach khö chirabahab ajim, amjã Ẽwandam dënkha awaag. ");
INSERT INTO noaE_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Maimua ya öbër phöbaadëm ee, Juan chi õor pör choomie dʉ̈i wënʉrraajerr khʉʉn bëewia Jesuug jëeuchëjierram: —¿Jãgwi maar maimua fariseonaanjã agjö Ẽwandamag jëeu khëwaag ʉ̈iba sʉrkhaajemta, pʉ khapeenta sʉrkhaba aajemma? aichëjierram irig. ");
INSERT INTO noaE_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Magbaa Jesuu amag magjim: —¿Pãrau khĩirjuawai jua pʉr nʉm aig õor thʉ̈rkhʉʉitarr ökhĩirjuu thach khöba naaju aai nʉ chi jua pʉr sim woun am dʉ̈i sim aig? ajim amag. Magnaa ichdëupai, Ich agjöta nʉmgui ajim mʉ khapeenjã. Am ökhĩirjuu ajuun, mʉ am jaaijö am dʉ̈i chitʉm pʉr atham ed gayan chadau amach khĩrauta sʉrkhawia ĩchab am thachjã khöba nʉisip aju, gaai machgau. Mamʉ mʉʉgwaiwe chan am sʉrkhaju khaba nʉmgui ajim, agtha mʉ am dʉ̈i chiraawai. ");
INSERT INTO noaE_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Pãadë khĩirjubat. Pãran chadcha pãach jöoinau jaaujerrjö thach khöba sʉrkha nʉm. Mamʉ pãrau jãg mua iek iiur jaau chirʉmjã khõsinaa agjö warrgarm khĩirjug chi jöoijã agtha khõsi wënʉrrʉmʉn, magan mag khĩirjugan sĩi put iiur auwia jũrr khajũa jöoi gaai phẽekhabarmjöta sĩsimgui ajim. Ãbmua khãijã put iiur khajũa jöoi gaai phẽekhakhiin, mag put iiur i pächdʉbaadëmua chi kha sim ee thʉrrdʉbaadeeu, warag ich warr sĩerr khãaijã nem wäg sĩsijugui ajim amag. Magua chi mʉ iek ʉ̈kha simua chan mʉg iek iiur mua jaau chitʉmjã ʉ̈khanaa pöd amach jöoin ijã agjö ʉʉrkhaju khaba simgui ajim, chi Jesús garmua. ");
INSERT INTO noaE_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mʉg mʉ iek ʉ̈kha nʉmʉn vino nemhëu iiur ee pʉajemjöta simgui ajim. Pãrau khaphʉ nʉm, vino õrr pöd nemhëu jöoi ya chi pʉajem ee pʉju khaba sim. Mag pʉkhiin, chi vino õrr achpabaadeewai, chi nemhëu jöoiraa sĩewai, ãwatba jẽgdʉbaadee, chi vinojã ãrbaadëm dʉ̈i chi nemhëujã ya tag serbiiba sĩsijugui ajim. Maguata vino õrran agjö nemhëu iiur eeta pʉajem; maagwai nemhëujã jẽgdʉba, chi vinojã ãrbamgui ajim, mag ichig jëeuchëtarr khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mag Jesús agtha Juan pör choomieu õor pʉ̈itarr dʉ̈i iyʉ̈ʉ dʉnʉm ee, maach meeun eem judío ãb chi pörkha sim bëewi sĩi i khĩirphee kanieu phõbkhabaichëjim. Mag phõbkhachëwi irig chaigpamamua, —Chaigpai mʉ khadam chugpajimgui ajim. Pari pua mʉ di aar manaa i gaai pʉrimakhiin, mua khaphʉ chirʉmgui ajim, pua deeu i iiu auju. ");
INSERT INTO noaE_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Magbaawai Jesús phiidʉwi petaawai maach chi khapeenjã i dʉ̈i wëtjim. ");
INSERT INTO noaE_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pari mag wëtum ee, ʉʉi ãb phõmieu bar sim bëewi meraa ëugarmua i khajũa i gaai pʉrchëjim, ich ödegpai “Nau i khajũa gaai pʉrbarmuapai mʉ monaauju” a khĩirjuwia. Ich mag ʉʉi doce años mag phõmie dʉ̈i sĩejim, bʉ̈ʉrjã chugpaa khaugba. ");
INSERT INTO noaE_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pari mag ich gaai pʉrbaichëmjã khaphʉ sĩerr aawai ich chi Jesuu irig ewag phʉʉrba oonaa, —Oob chigaa am; mua pʉch monaauju khaphʉ mʉ gaai pʉrchëtarr gaaimua, ʉ̈u pʉ monaauwi peerdʉjã peerdʉ ʉisibahab ajim chi ʉʉirag. Mag, chadcha Jesuu magbarm bʉ̈rre mag ʉʉi monaau sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Maimuan chad warag ërëubaadëwi, chi binaandam wai narr di aar barwi ooimaawai, ökhĩirjuu nʉm iekhau sĩi ʉ̈rrsirpa jẽb thʉnʉm dʉ̈i gaai machgau bĩep sereu thʉnʉmta ooimajim, amach i arr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Magbaawai amag, —¿Khantheeta jãg thʉnʉ́ma? Chaai meeba sĩita khãi sĩebahab ajim. Magnaa, Jöpcha dawag ërëubaadët ajim amag. Pari irua mag iekha sim ũrwia aig thʉnarr khʉʉnau warag i wau iekha naajim. ");
INSERT INTO noaE_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Maimua õor thum dawag öbeerkhapʉ̈iwia, chi binaandam aar dubwi, i juadam gaai pʉrbaimaawai warag dʉ̈i pʉr phiidʉbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mag irua chaai phiriu autarran ich ag durr ee warpham magweta bĩi jöisijim. ");
INSERT INTO noaE_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mag Jairo kha deeu iiu auwia petaau, dau khĩsu khithëem khʉʉnta numí i ẽudee ääag wëtjim. Mag ääakhamua, —Jesús, pʉʉta rey David khachitarr ag chaain ewagam khʉʉn Iewaa marau nʉ narr; maar apdurrum maar dau aug khaugbahur aajeejim, amach dau monaaupäain bëemkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pari Jesús warag ich jẽer sĩerr diig majim. Pari magʉmjã pʉaba i ẽudee wëtwi, ich aar bardʉtkhabaimaawaita, amag, —¿Pãrau khĩirjuawai mua chadcha pãar dau monaaupʉ̈iju chirʉ́? a jëeujim. Magbaawai amachdëu, —Ëera, marau khaphʉ nʉmgui ajierram, chadcha pua maar dau monaauju. ");
INSERT INTO noaE_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Magbaawai Jesuu am dau ëu aaithʉ aaithʉnaa, —Mua pãach dau monaaupʉ̈ijuuta pãachdëu khĩirju narr aawai chadcha pãar dau monaaupʉ̈ikhimgui ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mag chadcha irua magbarm bʉ̈rre amach numwe sĩi daujã wajappha aphöbaadëjim. Maimua Jesuu amag bʉ̈ʉrjã bithurgam khʉʉnag jaaupibajim mag amach dau monaaubarm. ");
INSERT INTO noaE_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pari magtarrta, sĩi aigmua öbër phöbaadëwi ich mag durr eepain amach wënʉrrʉmpierr jaaumajierram anaabá, jãga Jesuu am dau monaaujĩ. ");
INSERT INTO noaE_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mag dau khĩsu khithëe arr khʉʉn Jesús aig naawi daau paaukhabaadëm ee, jũrr woun ãb pöd iekhaba khitʉmta i aig aibëejierram. Ma pör bënmie paraa sĩejim, dösãt bën. ");
INSERT INTO noaE_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mag ich aig waipierrwai mag bënjã Jesuu jẽu werbajim. Magbaa mag meu meraa sĩerrta nem meu öphërg ich mʉg iekha sĩsijim. Magbarm oowi õor dauderraa nʉm iekhau, “Keena, mʉig Israel durr chan maach ee ag na maadëu mʉg ooba aajerr ĩsta chadcha maadëu mʉg oo nʉmwai” aajeejim jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pari bithurgam khʉʉnau sĩi mag durrum ee, jũrr fariseonaanau warag am ichaaur, “Jã sĩi dösãtnaan pör dʉ̈i khapeerkha sĩewaita ag juapaauta irua jãg õor mor eem mepeenjã dau daau jʉrkhʉʉi sĩebahab” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús phöbörpierr nʉrrʉmua didam khapan khaba khëkhëdʉm eem magwe phʉʉrdʉ nʉrraajeejim. Mag nʉrrʉmua Ẽwandam iek jaaujem deg dubwi maach peerdʉajem iek jaaumamua, “Ẽwandamta maach thumaam khʉʉn Pörkhaimʉʉ sim; magua irigta idëu pãach thãar ajaug paapibat” a jaaujeejim. Mag nʉm dʉ̈i ĩchab õor khamor machagjã khĩirpierr monaaumaajeejim, kha mamachdögpa. ");
INSERT INTO noaE_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mag nʉrrʉmua sĩi õor pöoma oveja chaaindamta chi thʉajã chukhu sĩi dau aphʉʉ parhoob aaidʉ thʉnʉmjö oobaawai, am dau aug khaugwi, ");
INSERT INTO noaE_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","maar ich khapeenagta, —Chadcha Ẽwandam i jaau nʉmʉn, arrozdö pöm phur wëjömjöta phidag pöoma simgui ajim. Mag simta chi jaau wënʉrraju khʉʉn chan khapan khabata durrum. ");
INSERT INTO noaE_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Magua muan pãragan Ẽwandamag jëeubat a chirʉmgui ajim, warag ich i jaauju khʉʉn khapan jöphëecha ich i jawaan pʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Biek ãb Jesuu maach ich khapeen doce ich dʉ̈icha ogdʉba wënʉrraju khʉʉn ich aig thʉ̈rkha auwi maachta mepeen khãaijã jua theeg ʉ̈rcha apijim, bën õor mor ee sĩsidʉmjã maach jua jʉmpiba jʉr wërpnaa, aaunaanjã amach khamor machagpierr monaaunaa, sĩi pa mamachdögjã monaaumamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mag maach ich iek jaaumkhĩir ichdëucha doce jʉr autarr khʉʉn mʉkhʉʉn ajim: Simón, (ichpai Pedro a thʉ̈ʉrjem); Andrés, chi Simón eeum; Santiago, jöoi Zebedeo iewaa, (ichpai ĩchab Jacobo aajem); Juan, agjö jöoi Zebedeo iewaa, Santiago eeum; ");
INSERT INTO noaE_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo, gobierno dëbpaar jëeumie arr, (ajapcharan mʉchma, mʉchpai ĩchab Leví aajem); Santiago, jöoi Alfeo iewaa, (ichpai ĩchab Jacobo aajem); Tadeo, ichpai ĩchab Lebeo a thʉ̈ʉrjem; ");
INSERT INTO noaE_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, celotenaan ee sĩerr; maimua Judas Iscariote. Maagwai maadëu khaphʉ chirarr akhiin, iin mag Judas Iscarioteeuta thethem khʉʉnag Jesús pʉr deeju ajima, i thõomkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Makhʉʉn doce ich Jesuucha jʉr autarr khʉʉnta ichdëucha pʉ̈ijim. Pari mag maar pʉ̈yaagpamua marag, judionaan khabam khʉʉn ee chan wëtpiba, ni Samaria durram phöbör eejã wëtpiba jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","—Magju khãai maach judionaan ee Ẽwandam iek ʉ̈khabagau oveja pap chukhu okhoo wënʉrrʉmjö thʉnʉm khʉʉn eeta ërëubaadët ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mag wënʉrrʉmua amag, “Ẽwandamta thumaam khʉʉn Pörkhaimʉʉ sim; pãar peerdʉju khai, irigta ʉdʉraa pãach Pörkhapibat” a jaaupetat ajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Magnaa aaunaanjã monaaunaa, kokobé bënëu sĩsidʉmjã monaaunaa, õor chi meemjã deeu phiriu aunaa, õor mor eem bënjã jẽu wërppetat. Pãrag magamkhĩir mua mʉch juapá sĩi parta dee chirʉm aawai pãachdëu õor dʉ̈i mag nʉm paarjã oob jëeumiet ajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mag jajawagmamua, ’Oob agʉmua nem përkhoog awi phatkhon khãijã arrmiet. ");
INSERT INTO noaE_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni khʉd jãrr thach khoogjã oob phiejãb arrmiet ajim. Khajũajã pãach mor gaaim appai arrwi zapatjã pãachdëu jũa nʉm appaita athaadët. Bordonjã chukhu ich jãg ërëubaadët ajim. Mua pãrag mag chirʉmʉn, pãachdëu am dʉ̈i wajapha nʉm khʉʉn õraupai agjö pãrau nem igbarmjã khap naaju aawaita bʉ̈ʉrjã nem arrpiba chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Phöbör ee pãach dubimaawai, wa sĩi didam khapan khabam aig khãijã pãach barimaawai, khap aag nacha jëeu oobat, khai di aigta pãach jẽerimaju aai nʉ a khap aag. Mag pãach jẽerbaimam degpai naawia ërëubaadët a jaaumajim, sĩi parhoob dipierr khãi wënʉrraba. ");
INSERT INTO noaE_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mag pãach jẽerimaju di aig barimaawaijã wajapha saludaabat ajim chi di khʉʉn dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chadcha amau mag pãar amach aig jẽerpimʉn, pãach Ẽwandam dʉ̈i khõinaa wënʉrrʉmjö amachjã i dʉ̈i khõinaa naaju. Magbam chan amachta warag Ẽwandam dʉ̈i khõinaa ajujã khaugba nʉisiju. ");
INSERT INTO noaE_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Maagwai pãach amach aig barpiba ni sĩi pãach iekpaijã ũrmapha abaawai mag di aigmua wa mag phöbör eemua khãijã ërëubaadët ajim. Mamʉ mag wëtaagpamuajã warre amach dakhĩirwe pãach bʉ̈ gaaim jẽb ʉʉrphë ʉʉrphënaa amag, “Pãachdëu jãg ũrba abarm gaaimua Ẽwandam dʉ̈ita khĩir khap abat” a iekhawia ërëubaadët ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mʉ cha iekha chirʉm iekhau, mag amau pãar igba, ni pãar iekjã ũrmapha abarm jũrran warrgar Ẽwandamau Sodomapien dʉ̈i maimua Gomorrapien dʉ̈i atarr khãaijã am gaai athuuchata burrju a jaaumajim ich Jesuu maachigcha. ");
INSERT INTO noaE_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mag maar pʉ̈yaagpamua ĩchab marag magjim: ’Mua chadcha pãar pʉ̈i chirʉm, pari mʉ iek ũrbat ajim: Pãran sĩi oveja chaaindam khum nem thʉnʉm ee pʉakhʉʉibapʉ̈imjöta abarm, õor khaibagkham eeta wënʉrraju aawai. Magua, mʉch imeerba muan pãragan, khĩirjug khaug ichkhumjöta abat a chirʉm. Mag naab mamʉ ĩchab khĩir machag chukhu duburdamjö abat ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Khĩir khaphʉ wënʉrrathʉ̈. Pãran õrau pʉr arrwi Ẽwandam iek jaaujem degam chi thethemnaanag deebaimap aju. Magbaa amau pãar wʉjã wʉmaju. ");
INSERT INTO noaE_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mʉ gaaimua pãar khaibag waumkhĩir, õrau pãar gobernadornaan aarjã arrnaa reinaan aarjã aharr aju. Pari mag chi thethemnaan aar pãach arrwai, ʉ̈u pãrau amag ũrmkhĩir mʉ jaaunaa sĩi judionaan khabam khʉʉnagjã mʉ jaaujurau. ");
INSERT INTO noaE_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pari mag chi thethemnaanag pãach pʉr deewaijã oob pãach kõit pãachdëupai iekhaju khĩirjuwia ag nawe, “¿Mʉ khan ata iekhajuwa?” a khĩirjumiet ajim, ya pãar iekhaagpaawai ich Ẽwandamauta ichdëu khap pãrag iekhapiju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mua pãrag mag chirʉmʉn, pãar Aai ʉ̈gthar sim ag Akharauta pãrag iekhamkhĩir khĩirjug deeju aawaita mag chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Mag jaran wir aig khod ãbam khʉʉnjã chi ʉ̈khaba sim garmua ʉ̈u mʉ iek ʉ̈kha khërʉm thethemnaanag jaaupʉ̈imajugui ajim, ich khodpai wir aig thõomkhĩir. Amach dënnaanjã agjö mʉ gaaimua thõomkhĩir thethemnaanag jaaupʉ̈imaawai chi dënnaanaujã ich agjö aju amach chaain dʉ̈i wir aig. ");
INSERT INTO noaE_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mʉ gaaimua thumaam khʉʉnau pãar oomappha aju, pari õrau pãach dʉ̈i mag nʉmjã magʉm iek igba warag Ẽwandam dʉ̈ita ubʉnaa ich gaai magʉm dichpi athamʉn, ʉ̈u peerdʉwi ʉ̈gtharcha öbërjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pãach nʉm phöbör ee pãach thet pʉrbaichee jũrr deeum phöbörög ërëupetat. Mag wënʉrrʉmua mʉg Israel durr phöbör khapan nʉnʉidʉm ee dʉrju jʉr wënʉrrawiajã, pãrau phöbör thum phʉʉrpʉ̈iju nawe mʉch chi Emkhooi Iewaa deeu pãar ee chiraichëjugui ajim, magbarm aigmua Ẽwandamta õor thãar ee chi Pörkhaju aai sim khap apieg. ");
INSERT INTO noaE_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Mag pãach dau aphʉʉ aju anʉm ũurwaijã oob jʉ̈gderraa amiet ajim. Pãrau khaphʉ nʉmgui ajim, eeu nem khaug simua chan ich maestro khãai atcha nem khaug khaba, ni sĩi chikham chogkha simjã ich patrón khãai ʉ̈rpai khaba sĩejem. ");
INSERT INTO noaE_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Magua, ãb khãijã chadcha ich maestroou jaau simjöta nʉrrʉm khai, magan chi maestro dʉ̈i aajemjö aju i dʉ̈ijã. Jãga chi patrón jöoi dau ãaukha nʉm ee chi chognaanta daupii abarju. Maguama, mʉch pãar Pörkha chirʉmʉg õrau mʉʉn mepeen pör Beelzebú dʉ̈ita chirʉm a iekhaajeewai pãrag chará amau athuucha khaigba iekhajugui a jaaumajim maachigcha. ");
INSERT INTO noaE_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Mʉg jẽb gaai maach wounaan ãba thʉnʉm khʉʉn oob ögkhamiet, pãach thõoju khĩirjuwia. Amaun mʉig eegar amachdëu pãar dʉ̈i mag khaigbanaa parhooba khãijã iekhabarmjã sĩi ich mag khĩir okhoojupii aju. Mamʉ magtarr iekhan mʉg atag paawai Ẽwandamau deeu eeupemjö ëudʉ auwia thumaam khʉʉnag ũrpijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mag pãar dau aphʉʉ ajujã chadcha ĩs mua meraamjöta jaau chirʉm, maach appai. Mamʉ pãach peerdʉajem iek pãachig jaaujem chan ikhʉa jaauba, thetta jaaupetat ajim, thumaam khʉʉnag ũrmkhĩir, mag chi ũr nʉm khʉʉnau pãach dʉ̈i khaigba ajujã khĩirjuba. ");
INSERT INTO noaE_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amau pãar chi ʉ̈rʉmʉn chadcha thõoju awiajã thõoju; pari pãar akhaar chan pöd thõo aubam. Magʉm khʉʉn oob ögkhamiet ajim. Magarrau ögkhaju awiajã pãach chi ʉ̈rʉmjã thõowia pãach akhaarjã khĩmie durr ich mag sĩerramkhĩir barpʉ̈yaagjã jua theeg simʉn chadau, chadcha ökhö abat ajim, Ẽwandam igwi. ");
INSERT INTO noaE_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Pãrau khaphʉ nʉm, nemchaaindam par erraam gaai për aaujem. Pari mag baleebamjö khithëe ab mamʉ, maach Aai ʉ̈gthar chiraajemua thõpibam aig chan ãbjã thõba aajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Magʉm pãar chará nemchaain khãaijã ʉ̈rcha balee naawai pãarta irua wajapcha thʉa wai sĩejem. Ichdëun pãar pörbʉ̈ khapanagjã khapphʉ wai sĩejem. ");
INSERT INTO noaE_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Magua, oob atcha pãach khĩirjumiet; pãarta nemchaain khãaijã ʉ̈rcha balee naabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ãb khãijã mʉ igar sĩewai õor dakhĩirjã meerba mʉ iek ʉ̈khaajem a jaau sim wounan, muajã ĩchab mʉch Aai ʉ̈gthar sim dakhĩir, “Jãan chadcha mʉ garmʉu” ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mamʉ jũrr ãbmua khãijã õor dakhĩir mʉ igwi “Mʉ chan i igarm khabam” a sim wounan, muajã ĩchab mʉch Aai ʉ̈gthar sim dakhĩir, “Jã chan mʉ dën khabam, mua i khaugba chitʉm” a iekhaju ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Oob pãrau, mʉʉn sĩi mʉg durr gaai õor khõinaa bibigagjã chukhu apiegta bëejim amiet. Mʉ chan pãar khõinaa apieg khaba, warag iek phithurg apiegjöta bëejimgui ajim ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mʉ mʉig mʉg durr gaai bëetarran, mʉch iek gaaimua chaain chi emkhooinjã amach aai dʉ̈i khaigba, chi ʉʉinaujã amach ãd dʉ̈i khaigba maimua chi ãignaanjã amach phaauhũan dʉ̈i khaigba jũrr chikham ichaaur aadëphʉm gaaimua iek phithurg apiegta bëejimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wajapcharan deeum khʉʉnjã khaba, dich wir aiguim khʉʉnpaita kha ukhur thʉnaajugui ajim, iwiir ãbmua mʉ iek ʉ̈khamapha aadëphʉm gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ãbmua khãijã ʉ̈rcha ich aaita mʉ khãai khõsi wa ich ãd khãijã mʉ khãaijã ʉ̈rcha khõsi sim chan magan mag woun chan mʉ dën aju khaba simgui ajim. Wa magba mʉʉta ʉ̈rcha khõsi aju khãai, ich iewaa wa ich kha khãijã ʉ̈rcha khõsi wai sim wounjã mʉ dën aju khaba simgui ajim ĩchab. ");
INSERT INTO noaE_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chi mʉ dʉ̈i nʉrram khõsi simuan warre ich phithurg au nʉrrajujã khaphʉ aju aai sim, mʉ gaaimua chikhamnau ich thõoju khaphʉ awiajã ich mag mʉ bʉ̈ ogdʉba nʉrraju aawai. Mag ãwatbaju chan parta idëu khõs mʉ dʉ̈i sim a iekhajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ar mʉ gaaimua bʉ̈ʉrjã phithurg aumapha sim chan meem edjã ʉ̈gthar öbërbam. Mamʉ ar mua nem jaau chirʉm waum khõchgau wa mʉ gaaimua khãijã dau aphʉʉ abarmʉn chadau ʉ̈gtharcha öbërjugui a jaaujim maachigcha. ");
INSERT INTO noaE_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mag iekhakhagmamua marag, ’Pãar mʉ iek jaau wënʉrrʉm aig, õrau ʉ̈uta pãar amach aig baarpinaa pãar iek ũr nʉmʉn magan mʉpata ĩchab ʉdʉʉr amach aig barpi nʉmgui ajim, muata pãar pʉ̈i chiraawai. Mag amau mʉjã amach aig barpi nʉm aig, ich chi mʉ pʉ̈itarr Jöoipata barpi nʉmgui ajim, mʉchjã ichdëuta pʉ̈itarr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ẽwandamau ich iek jaaumkhĩir jʉr auwi pʉ̈itarrta ʉ̈u amach aig au nʉm khʉʉn dʉ̈in, mag ichdëu pʉ̈i sim dʉ̈i ajapha abarmjö aju am dʉ̈ijã; maimua sĩi woun wajapham khãijã agjö amach aig aumʉn, i dʉ̈i ajapha arrjö ajugui ajim ĩchab am dʉ̈ijã. ");
INSERT INTO noaE_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Maimua ãbmua khãijã mʉg mʉ iek ʉ̈khawi mʉ iek jaau durrum khʉʉn amach aig barimaawai nemdam bʉ̈rʉʉm khãijã deem khõsi deemʉn, magtarr paar agjö ĩchab Ẽwandamau irig nem wajapham deeb khaba deejugui a jaaumajim. ");
INSERT INTO noaE_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mag maach doce ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnag mag nem jaaudubwi, wëtpi jaaubaawai, maar wëtjim. Magbaawai jũrr ich deeum phöbör nʉnʉidʉmʉg petajim, ich ag durr eepai, mamaam khʉʉnagjã agjö maach peerdʉajem iek jawaag. ");
INSERT INTO noaE_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ich maagwai Juanau cárcel deg simua Cristoou nem wau nʉrrʉm ũr sĩejim aajem. Magbaawai ich khapeen eem ãaur khʉʉn ich aig thʉ̈rkha auwi chi Jesús aar pʉ̈ijim aajem, ");
INSERT INTO noaE_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","i aar mawi, iita chadcha ich Ẽwandam i jaaumienau jaauwai Ẽwandamau pʉ̈iju jaaujerrá wa ar khabam khai ich jãg nʉag a khap jëeumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mag bëewi, chadcha ichig jëeubaicheewai, ich Jesuu amag, —Ërëubaadëwi Juanag jaaubaimat ajim anʉm, pãach jʉ̈gʉucha ũrnaa pãach daúacha mʉg oobarm. ");
INSERT INTO noaE_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Irig, “Dau khaugba khëkhëd arr khʉʉn dau wajapha thʉnʉm” abat. “Bʉ̈ wëdʉ wëdʉ sĩsid arr khʉʉnjã ya wajapha nʉrrjëem. Kach khĩsu sĩsid arr khʉʉnjã wajapha ũr sĩsidʉm. Chi meem arr khʉʉnjã deeu iiu nʉrrjëem, maimua aphʉʉm khʉʉnagjã ĩchab õor peerdʉajem iek jaau chirʉm” a jaaubaimat ajim. ");
INSERT INTO noaE_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Magnaa ĩchab irig, “Chi mʉ iek ʉ̈khawi ogdʉba mʉ gaai ʉ̈kha chirʉm wounan onee ich mag chitaju a jaaubaimat” ajim anʉm, mag ichig jëeuwimarr khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mag chi Juan khapeen ich aig naawi deeu ërëubaadeewai, ich aig narr khʉʉnagta Juan igwi iekhamamua amag magjim anʉm: —Pãrau Jordán igaau woun Ẽwandam i jaau nʉrrʉm oon weetwai, ¿sĩi woun iek theeg chukhu phũu choomaar sõsõii jũurba ahau aajemjökhamta oon wëtjierrá? Magʉm woun khabajim. ");
INSERT INTO noaE_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Magan, ¿khanim wounta oon wëtjĩma? ajim anʉm amag. ¿Woun khajũa wajapha jũa simta oojupii awi oon wëtjierrá? Pãrau khaphʉ nʉmgui ajim anʉm, khajũa wajapha jũajem khʉʉnan sĩi phöbör ee di ooimʉm eeta naajem, reinaan dʉ̈i ãba. ");
INSERT INTO noaE_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mamʉ pãrau magjömta ooimabajierram. Pãrau ooimatarran woun ãb Ẽwandam i jaau nʉrrʉm ajim. Mamʉ pãadë ũrbat: Juan chan warrgar Ẽwandam i jaaujerr khʉʉnjöpai khaba, am khãaijã ʉ̈rpaita simgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","I igwia Ẽwandamau ich i jaaumienag warrgarwe ich iek phãpitarr gaai jaauwai, Jãata irua mʉ na pʉ̈iju ajim, ichdëuta mʉ na mʉ maju ee õrag jaau peetwai thumaam khʉʉnau mʉ iek ũrm khõsi sĩi mʉ nʉ naamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Magua, mua pãrag mʉch imeerba jaau chirʉmgui ajim anʉm ich Jesuu: Warrgar Ẽwandam i jaaujerr khʉʉn eejã Juan chi õor pör choomie khãai ʉ̈rʉʉcharam chan ãbjã chukhu ajim. Mamʉ chi mʉ iek ũrwia, mua nem waubarmjã khaphʉnaa, Ẽwandamta ich thãar ee au sim wounan chadau, maadëu nem igba khitawiajã, Juan khãyau khapcha ajugui ajim anʉm, jãga Ẽwandam ichdëu õor peerdʉ atham thãar ee sĩeicheejẽ. ");
INSERT INTO noaE_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mag jaaumamua, ’Pãrag jaaukhimgui ajim anʉm: Juan sĩsierr aigmua ĩs ewagjã chadcha õor pöm Ẽwandamagta amach thãar ajaug paapinaa amach Pörkha aum khõchkha thʉnʉm. Pari amau mag ẽkha durrum dʉ̈i ĩchab chi thethem khʉʉnau jũrr khajapham nemjö mag Ẽwandam amach Pörkha auju iekta warre chugpaapʉ̈iju ẽkhaajem. ");
INSERT INTO noaE_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Warrgar Ẽwandam i jaaujerr khʉʉnau jaaujerr iek dʉ̈i Moiseeu ley phã pʉatarran, sĩi Juan bëe nʉm ora Ẽwandamauta mag õor thãar ajaug paanaa am Pörkhaan bëeju khap jawaag ajim. Magtarr aawai Juan bëewi jaauchëtarran mag warrgarwe mʉ igwi amau jaaujerrjö aadëm ajim. ");
INSERT INTO noaE_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Maagwai mag i iek ʉ̈kham khõsi nʉm khʉʉnau khaphʉ ajugui ajim anʉm, Juanan warrgarm profeta Elías aajerr bëeju jaaujerr kõit pʉ̈iwiata jãg nʉrrajim. ");
INSERT INTO noaE_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Magnaa ich Jesuupai, ’Keena, jʉ̈g ʉ̈rʉʉnaa cha mua jaau chirʉm wajapha ũrbat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mag iekhakhagmamua, maach Pör Jesuu aig narr khʉʉnag, ’Mua pãrag jaaukhimgui ajim anʉm, pãar jãga nʉm abarí. Magnaa, Pãar ar Juan isegwi mʉjã iseg nʉm khʉʉnan, chaain jemkha nʉmua amach khapeen dʉ̈i khĩir auphöbaadëmjöta nʉmgui ajim anʉm. Warm khʉʉn garmua, “Maar dʉ̈i karris sir nʉm gaai onee jemkhabahut” aawaijã jemkhamapha nʉm. ");
INSERT INTO noaE_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Maimua jũrr, “Magan sĩi ökhĩirjuu õor mee wai nʉm aiguimjö ohood abat” aawaijã magjã khõchkhaba nʉmgui ajim anʉm. Paarjã magta naawai, ¿khani khõsi nʉmma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pãar ee Juan chi õor pör choomie nʉrraajeewai irua Ẽwandamag jëwaag sʉrkhaajeejim, ajap thach khöba. Magʉm vino chará bʉ̈ʉrjã döbajim. Mamʉ mag oowi pãrau, “Jãan mepeer dʉ̈i khapeerkha sĩewaita sĩi ich jãg aai thach khöba nʉrraajem” a iekhaajem pãrau. ");
INSERT INTO noaE_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mamʉ ĩs mʉch chi Emkhooi Iewaa chaar bëewi, pãach dʉ̈i parhooba thachdamjã khönaa vinodampa dö khitaawai, jũrr magjã khõchkhaba warag pãrau mʉ ëugar, thach bipöm khönaa vino pigjã chitʉm aajem. Magnaa gobierno dëbpaar jëeu nʉmua õor khũguurjem khʉʉn dʉ̈ijã khapeerkhanaa pekau pöm sĩsidʉm khʉʉn dʉ̈ipa khapeerkha chitʉm a iekhaajerramgui ajim anʉm, mʉjã iseg nʉm iekhau. Pari ar chi Ẽwandamau khĩirjug deetarraucha khĩirju nʉm khʉʉnau chan magba, amau chadcha khaphʉ nʉm, chijã khʉʉnta ich Ẽwandamaucha pʉ̈itarr khʉʉn agá a iekhamajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesuu oowai irua ʉ̈rcha ag na õrau nem ooba aajem nem waumatarr phöbör eem khʉʉnauta bʉ̈ʉrjã Ẽwandam igba ni i iekjã ʉ̈khaba naajim anaabá. Magbaawai khĩesir iekhamamua makhʉʉn phöbör eem khʉʉn igwiata magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Ë, apdurr, Corazinpien! ¡Ë, apdurr, Betsaidapienjã agjö, Ẽwandamau am i agkham ed! Am ee nem ooba aajem nem wau nʉmua Ẽwandamau ich juapá oopitarr Tiro phöbör eeta wa Sidón phöbör ee khãijã wautarr amuan, nawe amau amach khĩirjug khaigbam isegwi sʉrkhakhamgui ajim anʉm. Magtarr amuan amau theerju theerwia, ʉ̈r jupnaa, putiu pör börrnaa, khoopa nʉm khʉʉn sʉrkhaajemjö sʉrkhakham. Mag nʉmua amau amach mor ãsie ewag khĩirjuwia Ẽwandamag jëeukham, amach khaibag chugpamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pari cha mʉ iekha chirʉm iekhau Ẽwandamau mʉg durr i agkham ed Corazinpienta Betsaidapien dʉ̈i irua am gaai masiicha waupʉ̈ijugui ajim anʉm, Tiropien dʉ̈i Sidonpien khãaijã, amachdëu ũrtarrta ʉ̈khaba arr gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Maagwai Capernaumpien igwiajã, ¿khan abarju? ajim anʉm. Magnaa ichdëupai, ¡Ë! Amaun amach thö nʉmgui ajim anʉm, amachta chi wäjäaun awia. Amaun ʉ̈gthar paaukhabaimaajã amachta chi pörnaan khajupii nʉm. Mamʉ jãkhʉʉn chan Ẽwandamau ich aar öbeerpiba, khĩmie durrta warag barkhʉʉipʉ̈ijugui iekhamajim aajem. Sodoma phöbör eeta jãg pãar ee õrau ooba aajem nem waumatarr wautarr amuan, jãg phöbör agtha sĩerrakham, Ẽwandam iek ʉ̈khatarr gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pari mʉ cha iekha chirʉm iekhau Ẽwandamau mʉg durr i agkham ed gaai, pãar gaaita Ẽwandamau athuucha mas deejugui ajim anʉm, Sodomapien khãaijã. ");
INSERT INTO noaE_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ich mag jaar ĩchab ich Jesuu ich Ayag jëeumamua, —Tata, mua pʉrʉg ʉ̈u ajim a chirʉmgui ajim anʉm, pʉchta ʉ̈gtharm magwe nem thum mʉg wëjöm Pör aawai. Mʉ onee chirʉmgui ajim anʉm, õor amach khĩirjug khaug thöwia, nem thum khaphʉm khaphʉm aajem khʉʉnaujã amach peerdʉju iek khaugba arrta, jũrr pua khĩirjugdam meraa chaainjö khithëem khʉʉnagta ʉ̈u khaugpibaawai. ");
INSERT INTO noaE_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chadcha puata nem wajapha waaujem Tata, pʉchdëu juau am dʉ̈i magju atarr aawai ajim aajem mag jëeumamua. ");
INSERT INTO noaE_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mag ich Ayag ʉ̈u ajim awia jũrr aig narr khʉʉnagta, ’Nem thum mʉg thʉnʉmʉn mʉ Ayau mʉrʉgta deejimgui ajim anʉm. Mamʉ ãbmuajã khaugba sim, khai agá i Iewaa. Ãba ich mʉ Ayaupaita khaphʉ sim, chadcha mʉ i Chaairau. Mʉg nʉm aig ãbmuajã khaugba sim, khai agá mʉ Aai. Ãba mʉch chi Chaairaupaita mʉch Aai khaphʉ chitʉm. Bigaaum khʉʉnau khaphʉ aju awiajã, mʉchdëu amag jaaubarm khʉʉnaupaita ĩchab khaphʉ aju aai nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Magua, muan pãragan, chadcha mʉ Aai khap am khõsi nʉm khai, mʉ iekta ʉ̈khabat a chirʉmgui ajim anʉm. Pãach pekau pömag khaphʉnaa ökhĩirjugau gaai machaaga nʉm khʉʉn, mʉʉta pãrau pãach thãar ee aumʉn, muata pãar ökhĩirjug meeupijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Idëu mʉrʉgta ʉdʉraa pãachig nem jaaupibat; muan ökhar ithũuta jaaumaajem. Pãrau mua jaau chirʉm ipierraata amʉn, ʉ̈u pãar khĩir meeu nʉisiju. ");
INSERT INTO noaE_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mua nem jaau chirʉm chan atcha phithurg aawai pãrau pödbajöjöom khabam. Muan nem thum pãachdëu pödju ayaam nemta jaaujemgui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ich mag jaar biek ãb jua ʉ̈i nʉm edcha maach i dʉ̈i wënʉrraajerr khʉʉn thum i iek jaauthurwia deeu i dʉ̈i narr aawai, ich Jesuu trigo phur wëjöm ee maar phë wai dichjim. Magbaawai maar ee ãaur khʉʉnau chi bich thʉrrëunaa, jua eepai sigthʉnaa khö wënʉrrajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maig ĩchab fariseonaanjã dʉ̈i narr aawai mag oowi ich Jesuugta, —Pʉdë oobá, jua ʉ̈i nʉm ed aawai bʉ̈ʉrjã phidkhaju khaba nʉmta, pʉ khapeenau jãg trigo phierrnaa khö wënʉrrʉm. ¿Pua chan khaugba ab, jãgpai phierr nʉmjã nem pöm eeu nʉm dʉ̈i ãba sim? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Magbaawaita jũrr Jesuu amag, —Mamʉ ¿khani mʉ khapeenau khaigba abar? ajim. ¿Magan pãrau chan Ẽwandam iek phã sim gaai thʉ̈ʉrwai ooba aajeeb, Daviiu ich dʉ̈i wënʉrrarr khʉʉn dʉ̈imua amach jãsöo phöbaadeewai Ẽwandam atheem pan khötarr? ");
INSERT INTO noaE_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mag pan parhoobam khʉʉnau khöju khaba, ãba phadnaanaupaita khöju aai naajim. Mamʉ pãrau khaphʉ nʉm, jãga irua Ẽwandamag jëeujem deg dubwi Ẽwandam atheem pan nasãd gaai phë sĩerr auwi khöjĩ. Mamʉ mag khötarr paarjã Ẽwandamau i chig abajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Wa pãrau Moiseeu ley phã pʉatarr gaai thʉ̈ʉrwai ooba aajẽwa? Jua ʉ̈ʉijem ed awiajã phadnaan Aai i jëeujem deg phidkhaawai pekau khabam a sim. ");
INSERT INTO noaE_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mag Aai i jëeujem deg phidkhaju aai sim khai, ¿jãgwi mʉ mag Aai i jëeujem di khãaijã ich Jöoiraucha pʉ̈itarrauta sabarhed awi mʉch khapeenag trigo phierr khöpi jaauju khaba chirʉ́? ");
INSERT INTO noaE_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wajapcharan jãg Ẽwandam iek phã sim gaai jaau sim pãrau khaugbata naabahab, Ẽwandamau ich iek gaai “Nemchaain thõonaa mʉrʉg jëeuwai ʉ̈u sĩeb mamʉ, muan pãach khapeenta ʉ̈rcha dau aug khaug paraa apim khõsi chirʉm” a sim. Pãrau irua mag sim wajapha khaphʉ naakhiin, jãg õor iekkhõr chukhum khʉʉndampa pãrau khaigba nʉm a jaaubajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maimua am jʉ̈gdaar mag iekhapʉ̈iwia deeu ichdëupai, ’Mʉʉn Ẽwandam Iewaa Emkhooirau. Muata thumaam khʉʉnag khan nemta wauju aai nʉ wa wauju khaba nʉ a jaauju aai chirʉmgui ajim, jua ʉ̈ʉijem ed awiajã. ");
INSERT INTO noaE_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mag trigodö ee fariseonaan dʉ̈i ijẽjẽb sĩewi petaau, aigmua dakha maach meeun Ẽwandam iek jaaujem di sĩerr ee dubimajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mag Aai i jaaujem deg woun ãb jua jʉser khitʉmjã sĩejim. Amach chi fariseonaanau Jesús ipeerdʉwi nem agcha khaba jaaubarm gaaimua i imeraa pʉr auju ẽkhaajerr aawai, juau ogthom irig, —¿Jua ʉ̈ʉijem ed awiajã, õor mor masim khʉʉn monaauju aai sĩ? a jëeujierram. ");
INSERT INTO noaE_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Magbaawai ichdëu amag magjim: —Pãar mʉg nʉm aig pãar ovejadam dau ãb khãijã jẽbdeg buudimaawai, ¿khaíuta jua ʉ̈ʉijem ed awia jẽu awaan maba aajẽ? Mag sim, ¿pãrau oowai maach wounaanta nemchaain khãaijã ʉ̈rcha balee naabá? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mag sim aawai jua ʉ̈ʉijem ed awiajã ichiita muan õor dau aug khaugju aai nʉm a chirʉm ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Magnaa ich Jesuupai chi woun mag jua jʉser khitarragta, —Dayag jua ʉabá ajim. Magbaa chadcha jua ʉabaa jua monakkha warm chi wajapha sĩerr dʉ̈i ãba sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mamʉ jua ʉ̈ʉijem edta magbarm oobaawai, aigmua öbëraau, chi fariseonaanau Jesús thõopʉ̈yaag jãga akhiina a khĩirju nʉisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mag ich thõopʉ̈iju khĩirju phöbaadëm ich Jesuu khaug athaawai ichta warag aigmua petajim. Mag i petaawai õor pöm dʉ̈i i ẽudee wëtjim. Jesuu mor masim khʉʉn thum ich aig waibëe nʉm monaaupʉ̈i maajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mamʉ ichdëu mag õor monaau simjã sĩi khapanag ee parhooba ich jaaupiba aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pari magtarran, Ẽwandam i jaaumie jöoi Isaías khararrau ich Jesús igwia jaautarrjö amkhĩir ajim. Chi Ẽwandam iek gaai i igwia mag sim: ");
INSERT INTO noaE_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Achá sim mʉ chog” a sim Ẽwandamau, “mʉchdëu jʉr autarr mʉchdëu khõsim. I gaaimuata mʉ onee chirʉm. I gaai, mua mʉch Akhaarta phẽs deeju. Magbaawai irua jaauju, jãga õor mʉ dʉ̈i wënʉrraju aai nʉ. ");
INSERT INTO noaE_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Í chan õor dʉ̈ijã meeurraunaa khĩesir ijẽjẽbjã aba, ni kaaijã ee õor dʉ̈i meeukharrjã chukhu aju. ");
INSERT INTO noaE_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mag i pʉ̈ibarm chan õor dau aphʉʉ khithëem khʉʉn warag dau aug waupiegjã khaba, ni ich iek gaai ubʉ khaba khithëem khʉʉn okhoopiegjã khaba, warag ich meebarm gaaimua õor ʉ̈u peerdʉju ayaa apiegta pʉ̈iju. ");
INSERT INTO noaE_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Magbaawai durrpierram khʉʉnau i igwia, ‘Jãguata chadcha ʉ̈u maach peerdʉ auju khabahab’ ajurau” a sim Ẽwandamau ich iek gaai. ");
INSERT INTO noaE_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Biek ãb woun ãb dösãt bënëu sim Jesús aig aibëejierram. Mag woun ich ag bënëu meu meraanaa daujã khĩsu khitajim. Mag ich aig aipierrwai Jesuu i dau monaaupʉ̈iwia mag meu meraa sĩerrjã wajapha iekhapijim. ");
INSERT INTO noaE_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mag oowi õor dauderraa nʉm iekhau amach wir aigpai, “¿Keena, mʉg woun jöoi David khararr chaain ewagam khʉʉn eem maach peerdʉ aumkhĩir pʉ̈iju aajerr khabam khai?” aajeejim, Jesús igwia. ");
INSERT INTO noaE_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pari õordamau sĩi mag nʉm ũrbaawai fariseonaanau jũrr am ichaaur, —Dösãtnaan pör Beelzebú dʉ̈i bën dötarr aawaita ag juapaauta jãg õor mor eem mepeenjã dau daau jʉrkhʉʉi nʉrrʉm aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pari amau amach eepai mag nʉmjã Jesuu khaphʉ sĩerr aawai jũrr ich garmua amag magjim: —Pãrau oowai, gobiernoou ich igar nʉm khʉʉn jãrrcha thöonaa amach wir aigpai wërbʉpikhiin, ¿mag gobierno warre khʉt mabaju khai? Wa ãbmua khãijã ich chaain dʉ̈ipai meeukhawi amach wir aigpai wërbʉkhiin, ¿warag aaidʉbaju khai? ");
INSERT INTO noaE_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pãar iek mag mʉjã dösãt dʉ̈ita chirʉm anaawai, dösãtauta wir aig dösãtpai jʉr wërpkhiin, pöd ich mag jua theeg sĩerrabajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Chadcha mag dösãtnaan pör Beelzebuuta mʉrʉg ich jua theeg dee sim khai, magan ar pãach igar thʉnʉm khʉʉnaujã agjö i juapaauta mepeen jʉr wërp nʉm. Mag nʉmta ¿jãgwi pãrau makhʉʉnag chan bʉ̈ʉrjã magʉm aba nʉ? ¿Chadcha ich Ẽwandamauta amag magamkhĩir ich juapá dee sim pãachdëu khaphʉ naawai khabá? Pãar iek mag chi dösãtaupaita wir aig ich khaibag waaujem anʉpí, magan jãg chi mʉ dënjö dau daau mepeen jʉr wërp nʉm khʉʉnagchata jëeu oobat, daau amau chadcha dösãt juapaauta jãg jʉr wërp nʉm abarju. Pãach chi mʉrʉg mag iekha nʉm khʉʉnta ag eyaajã khaba iekha naabahab. ");
INSERT INTO noaE_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Muan chadcha Ẽwandam jua theegauta mepeenjã jãg jʉr wërp chitʉmgui ajim. Mag mepeen mua jʉr wërp chirʉm gaaimua pãrau khaphʉ aju aai nʉm, ya ich Ẽwandam chi jua thierrta mʉig pãar ee sĩeichëm. Mamʉ magʉmjã pãrau khaugba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Pãadë khĩirjubat. Ni ãbmuajã mʉg nʉm aig sĩi ãb jierrnem wajapham dʉ̈i ich di thʉa sim aig dubwi i nem jĩgkhabaju. Sĩi khapanaam khʉʉnau wa i khãai ʉ̈rʉʉcharamua i ibʉʉr auwi khabam chan, pöd i nem jĩgkhabamgui ajim. Ich agjöta simgui ajim mepeerjã. Mʉ i khãai jua theeg ʉ̈r khaba chirakhiin, muajã pöd õor mor eem mepeen jãg dau daau jʉr wërpbaju. Mamʉ mua chadcha Ẽwandam juapaauta mʉg nem wau chitaawai meperaujã mʉ jua jʉmba aajem. ");
INSERT INTO noaE_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Magua, mua mag chirʉm: Ar chi mʉ igar khaba sim wounan ichta dösãt igar sim; maimua Ẽwandam iek ʉ̈khapi awaag mʉ ipierr õor ãbamʉg jʉr phëba simuan waragta jʉr wërp simjö simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Magua, mua mag chirabma ajim ich Jesuupai: Ẽwandamaun chadcha õor khaibag thumaa chugpaaju, am parhoob iekhamatarrpa thum. Mamʉ pekau ãb sim, maan mua Ẽwandam Akhaar jua theegau nem wau chitʉm oo nʉmta warag mepeer gaai thʉ nʉmʉu. Mag pekau chan Ẽwandamau bʉ̈ʉrjã khĩir okhoobamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mʉch chi Emkhooi Iewaa igwiata khaigba khãijã iekha nʉm pekaun ʉ̈u chugpaaju; mamʉ chaig pãrau mua mag Ẽwandam Akhaar juapaau khaba Beelzebú jua theegauta mepeenjã jʉr wërp chitʉm anarr chan mʉig eegarjã chugpaaba, ni mʉg atag Ẽwandamau deeu jẽb iiur ompaabarm gaaijã chugpaaba ich mag sĩsijugui ajim, Ẽwandam Akhaar igwiata mag iekha naawai. ");
INSERT INTO noaE_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Mag iekhakhagmamua ĩchab amag magjim Jesuu: ’Pãadë mʉ sëu awia nemjĩir jĩirwaijã wajap jarba sĩi ich jãg bãaupibat. Mag nemjĩir wajap chëbajugui ajim. Mamʉ wajaphata phãichichagau bʉ̈ khuanaa jar bãaumʉn, mag nemjõ wajapha chëju. Wajapcharan ich chë sim gaaimuata khaphʉ aajemgui ajim, jãga sĩ mag nemjõ. Ich jãgta naabahab ajim pãarjã agjö. Pãach nem wau nʉm gaaimuata pãachdëupai pãach jaau naabahab, õor wäjäauná wa õor khaigbam khʉʉná. ");
INSERT INTO noaE_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Khĩirjug chuknaan, jãg pãar ö khaibag sĩsidʉm khʉʉnau, ¿jãga pãrau nem wajapham ig iyʉ̈ʉ abarju? Nem dich khĩirjug ee khĩirju ahaukhamta dich iiu jaauba aajeeb. ");
INSERT INTO noaE_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Õor khĩirjug wajapham khʉʉnau nem wajapham nemta iekha nʉm, amau nem wajaphamta wauju khĩirju naawai. Mamʉ ö khaigbam khʉʉnaun, iekhaawaijã khaigbata iekha nʉm, am ödi sĩi nem khaigbamta wauju khĩirju sĩsid aawai. ");
INSERT INTO noaE_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pari mʉ cha iekha chirʉm iekhau, Ẽwandamau õor i agkham edan, mʉig eegar aawai pãach iek khaigbam iekhaajerr thumaa pãach idamaucha irig jaaujugui ajim, khan jãgwia mag iekhaajeejĩ. ");
INSERT INTO noaE_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wajapcharan mʉig eegar aawai pãach iekhamaajerr iekhaupaita wir aig pãach iekkhõr chukhu nʉm a jaaupiju, wa warag pãach khaibag khãijã waupi jaaujugui a jaaumajim chi fariseonaanag. ");
INSERT INTO noaE_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Biek ãb fariseonaan eem khʉʉnau maestronaan eem khʉʉn dʉ̈imua Jesuug, —Maestro, maraun maach dakhĩirta pʉrʉg ag na bʉ̈ʉrjã maadëu ooba aajem nemta waupim khõsi nʉmgui ajierram. ");
INSERT INTO noaE_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Magbaawai ich Jesuu amag magjim: —Pãran pãachdëu Ẽwandam iseg nʉm gaaimua warag chi ajaugjã chukhu thʉnaawaita warag pãachdëu nem ooba aajem nempata pãach dakhĩir waupi nʉm. Mamʉ mua waubamgui ajim. Mag khãai warrgar jöoi Jonás aajerr nemmeeurrkhan buch ee khãai thãrjup sĩerr gaaimua Nínivepienau Ẽwandamau i pʉ̈itarr khaug autarrjöta, ĩchab mʉchjã Ẽwandamau pʉ̈itarr pãrag khap apijugui ajim, mʉch iiu phiidʉbarm gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ich jãg Jonás nemmeeurrkhan bi ee ãsdawam khãai thãrjupnaa edaramjã khãai thãrjup sĩerrjö, ich agjö mʉch chi Emkhooi Iewaajã ĩchab ãsdawam khãai thãrjupnaa edaramjã khãai thãrjup chirajugui ajim, jẽb ee. Mamʉ mag oobarmjã pãrau ʉ̈khabajugui ajim amachigcha. ");
INSERT INTO noaE_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Magua, Ẽwandamau õor ich aar phë auju wa phë auba khãijã aju jaau nʉm ed, Nínivepien phiidʉtkhawi amach ipaarmua pãar khaibagta warag Ẽwandamag ĩgkha thʉnʉʉuju, warag pãar khaibag waumkhĩir. ¿Khan jãgwi? Jonaau Ẽwandam iek amach aar jaaubaimaawai amau magʉmjã aba ʉ̈khatarr aawaima. Mamʉ ĩs mʉ Jonás khãaijã ʉ̈rʉʉcha chirʉmuata Ẽwandam iek jaau chitʉmjã pãrau bʉ̈ʉrjã ʉ̈khamapha nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mag Ẽwandamau am phiriutkha auwia chachbarm jaar ĩchab Sabá durrmua rey Salomón oon bëetarr ʉʉiraujã ich ipaarmua ĩchab pãar khaibagta Ẽwandamag ĩgkha thʉnʉʉujugui ajim, í pãar khãaijã warpmuata Ẽwandamau Salomonag khĩirjug deetarr iekha sim ũraan bëetarr aawai. Mag khãai mʉ Salomón khãai ʉ̈rpai chirʉmuata mʉig pãach nʉm aig Ẽwandam iek jaau chirʉmjã pãrau ũrmapha nʉmgui ajim, mag amachdëu nem ooba aajemta amach dakhĩir waupi narr khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mag iekhakhagmamua, ’Ĩs mʉg mʉ iek ũrbarmjã ʉ̈khaba abarm gaaimua warram khãaijã warag Ẽwandam dʉ̈i iekkhõr pöm nʉisim khap amkhĩir, pãrag mʉg ejemplo jaaukhimgui ajim. Magnaa ichdëupai, Bën khaigbam õor mor eemua jʉrpäaiwain warp õor chukag ee phʉrëu nʉrraajem. Mamʉ pöd ich sĩeimaju baauba abaawai khĩirju sĩi awia, ");
INSERT INTO noaE_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Deeu mʉch chiraajerr deg chiraimaag majugui” awia, deeu ich ag woun jʉrmaajemgui ajim. Mag mawia ooimaawai, chadcha di chaarta wajap thũapwi ãbamʉg nem jökhanaa au sĩsidʉmjö dijã parii ooimaajem. ");
INSERT INTO noaE_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mag oobaimaawai, deeu mawia, ich daumaai ich khapeen ich khãaijã khaigbacharam khʉʉn siete jʉr phë auwia, deeu mag woun mor ee naaicheejemgui ajim. Magbarm aigmua chi wounjã warr ich sĩerr khãai warag athuuchata khaibag sĩsiejem. Ĩsim khʉʉn jãg khaibag sĩsidʉm khʉʉnjã ich magta ajugui ajim meperau am dʉ̈i, Ẽwandam iek ũrtarrta ʉ̈khaba arr gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Agtha Jesuu õrag iekha sim ee, i ãd i eeugpeen dʉ̈i bardʉtkhachëwia i dʉ̈i iekham ig naajim. Mamʉ i sim aar dubba daaugajãrpai naaichëtarr aawai ");
INSERT INTO noaE_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ãbmua chi Jesuug, —Pʉ ãd pʉ eeugpeen dʉ̈i daaugajãr nʉmwai; am iek pʉ dʉ̈i iekham khõsi nʉm aajem a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Magbaa jũrr ichdëu, —¿Chijã agá mag mʉ ãd, maimua chijã khʉʉn agá mag mʉ eeugpeen? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Magnaa maach ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnagta jua ʉanaa, —Chamʉ khʉʉnta mʉ ãd anaa mʉ eeugpeenauwai ajim. ");
INSERT INTO noaE_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mʉrʉgan mʉ Aai ʉ̈gthar chiraajemua khõsimjö nem wau nʉm khʉʉnta mʉ ãd anaa mʉ ʉ̈phʉʉinau, maimua ĩchab makhʉʉnta mʉ khodnaanaugui ajim, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Khãai ãb Jesús ich jẽer sĩerr degmua mawia thʉrrdö igaau oo sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Maigmua ich bigaau õor pöm phʉʉrbaadeewai ichta warag bote ee waaidʉwi döjãrraa barjöisijim. Maagwai chi õran durr mos gaaipaita pos thʉnaajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mag mam barjopnaata ejemplodam jaaumamua nem khĩir pogkhe jaaumajim. Mag jajawagmamua magjim: —Woun ãb nemjĩir dau phoon majim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mag sĩi phömam atarr aawai ãaurag chi nemjĩir daudam bʉ̈ diichjem ee burrjim aajem. Magbaa nemchaain bëewia sĩi khökhʉʉipʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Maimua ãaur khʉʉn sĩi mok pör jojoodög eeta burrjim aajem, wajappai jẽb chukhu sĩerr ee. Makhʉʉnan chi tharrphëen ʉ̈u jöpcha tharrphë öbërjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pari edau pechag wʉʉbaadeeu sĩi ënanauk aadëmua phuabaadëjim anaabá, mokdau khurau pöd ierr khaar jẽrkhaba ʉ̈rʉʉta khaarkha khithëe arr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Maimua ĩchab tagam phötarr miudö arr ee burrwia, chi miuta nemjĩir khãaijã bãau khaphí bãauwia, sĩi chi nemjĩirdam ichdëuta pör pʉrëu aujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mamʉ tagam ʉ̈u jẽb wajaug ee burrtarran, wajapha öbërwia ʉ̈u nem wajaug phur jopjim anaabá, nem bich dapag maimuajã bich thʉʉ, maimua pogkha bich daii; mamʉ mag sĩsidʉm chan bʉ̈ʉrjã chi vano chukhu. ");
INSERT INTO noaE_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mag nem ĩgkhaadam jaau öpʉ̈iwi aig narr khʉʉnag, ’Keena, jʉ̈g ʉ̈rʉʉnaa chamʉg nem ĩgkhaadam mua jaau chirʉm wajapha ũrbatgui ajim ich Jesuupai. ");
INSERT INTO noaE_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mag i nem ĩgkha öpinaa maach chi khapeenauta irig, —¿Jãgwiata pua jãg ejemplodam jaaumamuata õrag nem jaaujẽ? a jëeu naajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Magbaawai ichdëu marag magjim: —Pãrau khaugam khõsi ũr naawai warre mʉchdëuta pãrag khaphʉ api chirʉmgui ajim, jãgata Ẽwandam õor thãar ee sĩeicheejẽ. Pari warm khʉʉnag mag khaugpibamgui ajim, amau khaugam khõsi ũrba naawai. ");
INSERT INTO noaE_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mag khãai ar chi thãar onee ũrm khõsi ũr nʉm khʉʉnagta Ẽwandamau warag khĩirjug deeju, ich iek khapcha amkhĩir. Mamʉ ar mag nem waumapha nʉm khʉʉnag chan deeba, warag am jua eem khecheu aumaju ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Maguata mua sĩi ejemplo jaaumamuata amag nem jaauba aajeeb, mua nem wau chitʉm amau oo nʉmta oobamjönaa mua nem jaau chitʉmjã ũr nʉmta ũrbamjö naawai. ");
INSERT INTO noaE_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Amach jãg nʉm gaaimua am gaaita pa sĩebahab Ẽwandamau ich iek gaai jöoi Isaías khararrag phãpitarr. Irua phãtarr mag sim: “Par amau ũrwiajã ũrbamjö khaugbajurau. Par wajap oo nʉʉ awiajã oobamjö ajurau. ");
INSERT INTO noaE_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mʉkhʉʉn wounaan khĩirjugan sĩita ãr sim; kachjã khĩnaa daupata khĩ sĩsidʉm. Mag naawai pöd ũrjã ũrba ni oojã ooba, ni mʉrʉgjã amach pekau chugpaapi jëeuba nʉm, amach peerdʉ aumkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mag iekhapʉ̈inaa deeu maragta, ’Pari pãar onee abat ajim; pãrau pãach daúacha mua nem wau chitʉm oonaa pãach jʉ̈gʉucha mʉ iekjã ũurjeewai makhʉʉn jöoi Isaiaau jaautarrjö khaba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Magnaa, Chadcha mʉch imeerba pãrag mag chirʉmgui ajim: Warrgar khapan Ẽwandam i jaaujerr khʉʉnau cha mua nem wau chitʉm pãar dënjö amach daúacha oom khõsi atarrjã pöd oobajierram. Cha pãrau ũr nʉmjã amach jʉ̈gʉucha ũrm khõsi atarrjã pöd ũrba durrajimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Maimuan chadau ich Jesuu, ’Ũrbat, mua pãrag jaaukhimgui ajim, khani jaau sĩ chaig mʉchdëu nemjĩir dau jaau chirarr ag ejemploou. ");
INSERT INTO noaE_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ar mʉg Ẽwandam iek jaau nʉm ũr nʉmjã pöd khaugbam khʉʉnan, chi nemjĩir daudam khʉdjã ee burrwia nemchaainau khöpʉ̈itarrjöta nʉmgui ajim: Meperau bëewia, sĩi khũgurbaicheewai, Ẽwandam iek ʉ̈khatarrdam deeu ũrba arrjö apäaijem. ");
INSERT INTO noaE_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Maimua ar Ẽwandam iek jaau nʉm ũrbaawai ʉ̈kham khõsi ʉ̈khatarr khʉʉn, jũrr nemjĩir daudam mok pör jojoodög ee burrtarrjöta nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mamʉ jẽb chukag gaaimua chi nemjĩirdam wajap khaarkhaba arrjö, ĩchab mag ũrm khõsi ũrnaa ʉ̈khatarrjã wajappai ubʉ khaba nʉm. Mag khukhurpai naawai, mag iek wajapham gaaimua chikhamnau khaigbanaa phithurg aawaijã, deeu Ẽwandam iekta isegwi, warr amach naajerrjöta wënʉrram khõsi nʉm. ");
INSERT INTO noaE_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Maagwai maach khapeen ihãsisisdöm khʉʉn, jũrr mag nemjĩir dau miu ee burrwia chi miúa pör pʉrëu autarrjöta nʉmgui ajim. Amau Ẽwandam iek ũrm khõsi ũurjem, mamʉ deeu amach khĩirjug eepai, “Jãgʉm gaaimua pöd mʉ phatkhon auba khãijã chitaju,” wa magbam khai, “Mua chadcha ʉ̈khakhiinjã, pöd parhooba mʉchdëu ampierr abaju” a khĩirjuajem. Mag gaaimua mag nemjĩirdam aphʉʉ bãauwia pöd chëba arrjö, Ẽwandam athee nem wajapha wawaagjã pödba, sĩi serbiibata nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Magarrau ar Ẽwandam iek ũrwia thãraucha ʉ̈khaajem khʉʉnan chad, jũrr mag nemjĩir jẽb wajaug ee burrtarrjöta nʉmgui ajim. Magʉm khʉʉn Ẽwandam athee nem waum khõsi wau naawai, amachdëu nem wauju ayagpierr waaujemgui ajim: ãaur khʉʉnau nemjĩir chi chëmiejö dʉ̈rrcha, ãaur khʉʉnau agpierrpai maimua ãaur khʉʉnau bʉchkhunpai. Mamʉ thumaam khʉʉnau ichiita ichdëu khõsimjö aajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mag jaauwia, deeu ichdëupai mʉg ejemplodam jaaumamua magjim: ’Ĩs mua pãrag jaaukhimgui ajim, Ẽwandamau ichdëu õor i agkham ed jãga khaigbam khʉʉn chi wäjäaun eemua isegju. Maan mʉgaugui ajim: Woun ãbmua trigo jĩirjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mamʉ mag trigo apha sĩerrta, õor thum khãiphöbaadëmich, mag chi nemjĩir pap kha ukhurm bëewia jũrr i nemjĩir ee phũak dau khaigbam agjö trigojöo simta phöthurjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Maimua chi trigo bich baupa aadeewai chi phũakjã agjöo dʉ̈i bich baupa jöisijim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Magbaadëm chi chognaanau oo athaawai amach patrón aar wëtwi irig, “Patrón, pua jĩirwai trigo appai jĩirtarrta, ¿jãga ĩs jãg phũak khaigbampata ag ee bich baupa wëjö?” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Magbaawai chi papkhʉʉu, “Jã, maach dʉ̈i iekkhõr paraam khʉʉnau khãijã ag ee phũak dau phöwia khabahab” ajim anʉm. Magbaa chi chognaanau deeu pʉaba irig, “¿Pua oowai marau ag appai chi khaarpa jẽu wërphoon maju aai nʉ?” ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mamʉ magbaa chi nemjĩir khʉ jöoirau, “Oob jẽwaan wëtmiet” ajim anʉm, “magba akhiin eeu pãrau chi trigo khaardampa khãijã thʉrrëudukham. ");
INSERT INTO noaE_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Magju khãai idëu warag ãba bãaupibat” ajim anaabá. “Maimua ya phierr nʉm jaar paawaita mua ag athee õor pʉ̈ijugui ajim anʉm, nacha ag appai thʉrrphënaa, khõorjʉ̈naa örpʉ̈imkhĩir. Maimuan chadau agjö chi trigo appai phierrwia chi ausĩiujem ee ausĩujugui” ajim anaabá. Magtarr aawai ichdëu jaautarrjö idëu bãaupiwia, phierr jaar paawaita ich mag chi phũak thʉrrphënaa, ag appai khĩet örpʉ̈ijim anaabá. Maagwai õor i agkham edjã ich magta aju Ẽwandamaujã ich iek ʉ̈khabam khʉʉn dʉ̈i. Mamʉ ich iek ʉ̈kha nʉm khʉʉnan, mag trigo wajap ãkha sĩutarrjö ich aarchata phë auwi ich dʉ̈i ich mag wai sĩsiju a jaaumajim, ich Jesuucha. ");
INSERT INTO noaE_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mag nem khĩir pogkhe jaaumamua ich Jesuupai ĩchab mʉg nem ĩgkhaadamjã jaaujim, mostaza daudam bʉ̈rʉʉ khitʉm igwi: ’Pãrau khaphʉ nʉ, jãga sim abarí Ẽwandam iek mua jaau chitʉm, maimua khanjöta sim a mua pãrag jaaubarkhiin ajim. Mʉg Ẽwandam iek mua jaau chitʉmʉn, mostaza daudam jẽb ee jĩir sĩubarmjöta simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iin chadcha tagam nemjĩir dau khãaijã ichta bʉ̈rʉʉcha khitʉm. Mamʉ mag khitʉmʉn nem bãau khaphí bãauwia, nem bʉ̈ pöm ãdëe aadeewai, sĩi nemchaaindam bëewi ag gaai di ëucheejemgui ajim. Ich agjöta sĩebahab ajim ĩchab mʉg Ẽwandam iek mua pãrag jaau chitʉmjã: Mʉʉgwaiwe chan khapan khabata ʉ̈kha durrum; pari mag durrumuata warag nem pöm aaidʉbapäaiwai õor khapankham khʉʉnau ʉ̈khajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mag jaaumamua ich Jesuupai, ’Ẽwandamau ich iiu aawai mag ich iek aaidʉpi nʉmʉn, ʉʉi ãbmua arin dʉ̈rrcha sim ee levadura pʉ̈itarrjöta simgui ajim. Pãrau khaphʉ nʉmgui ajim, levadura bʉ̈rʉʉ pʉ̈itarrjã aaidʉmam ooba simta, arin thum ʉrpi aaujem. Ich agjöta sĩebahab ajim ĩchab Ẽwandam iek mʉg mua jaau chitʉmjã. Mʉʉgwaiwe chan õor pöm mʉg wëjöm ee agtha pömcha aaidʉba sim. Mamʉ mʉg atag paawaita durr warpham magwe aaidʉbaadee thumaam khʉʉnau ũrab khaba ũrjugui a jaaumajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Magta Jesuu nem khĩir pogkhe jaaumajim, ejemplodam deemamua. Ejemplo chuk chan õrag nem jaauba aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mamʉ mag ejemplooupai nem jaaujerran, warrgar Ẽwandam i jaaujerrau Jesús igwia jaautarrjö, ejemplo deemamuata õrag nem jaauju arr aawai ajim. Mag irua ejemploou nem jaaumaju atarran, warrgarwe Ẽwandamau õrag khaugpiba ich thãar eepai wai sĩsierrta jũrr ewag pawi õrag khap amkhĩir jaaumaju ajim. Magtarr aawaita mag ejemplo jaaumam aigjã chadcha ag eyaa öbëbërgmajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mag õrag ejemploou nem jaau öbaadeewai õrag wëtpi jaaujim. Maimua thum ërëubaadee ich jẽer sĩerr di aar majim. Maig maach appai aphöbaadee, marau irig maachig jaaupijim, mag phũak dau khaigbam trigo eeu jĩir wëjöm ee phötarr. ");
INSERT INTO noaE_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Magbaa ichdëu jaaubaadëwi magjim: —Ar mag chi nemjĩir dau wajapham phöjim a chirarr, jã mʉchpaíugui ajim, mʉch chi Emkhooi Iewaa. ");
INSERT INTO noaE_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Maagwai irua phötarr jẽb, jã mʉg õor pöm wëjömta jaau sim. Chi nemjĩir dau wajapham, õor Ẽwandamagta ʉdʉraa amach Pörkhapi nʉm khʉʉnaugui ajim. Maagwai chi phũak khaigbam, ar sĩi Ẽwandam igar khaba mepeer igar nʉm khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Maagwai chi patrón kha ukhur i nemjĩir ee mag phũak dau phöthurtarr, jã chi meperaugui ajim. Maimua chi trigo phur jöisiewai thʉʉju a jaautarr, Ẽwandamau mʉg durr i agkhajuuta jaau sim. Chi trigo thʉʉ nʉmjö õor dajẽk aju khʉʉn, ich Ẽwandam chognaanaugui ajim, angelnaan. ");
INSERT INTO noaE_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pãrau khaphʉ naabá, phũak phʉnaa, jʉʉupinaa örpäaijem. Ich jãgta aju ĩchab Ẽwandamaujã õor dʉ̈i ichdëu mʉg durr i agkhabarm ed. ");
INSERT INTO noaE_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mag ed mʉch chi Emkhooi Iewaau mua mʉch chognaan pʉ̈ijugui ajim, sĩi bigaaum khʉʉnagjã pekau waupinaa amachdëupa nem khaigbam wau sĩerrjëem khʉʉn thum ãbamʉg jʉr phëmkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mag ãbamʉg jʉr phënaa orno paa dʉnʉmjö sim eeta barkhʉʉiju. Magbaawai mag eeta icharaucha bĩenaa gaai machgau am khierr ujãkkhʉr abarjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mamʉ warm khʉʉn mamagkham ee, jũrr Ẽwandamagta ʉdʉraa amach wajaug paapi nʉmua i dënkha narr khʉʉnan maach Aai thumaam khʉʉn Pörkha sim dʉ̈ita nʉisijugui ajim. Magnaa ichdëupai, Keena, jʉ̈g ʉ̈rʉʉnaa cha mua nem jaau chirʉm wajapha ũrbat ajim, mag iekhamamua. ");
INSERT INTO noaE_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mag jajawagmamua ĩchab mʉg nem ĩgkhaadamjã jaaujim, ich Jesuu: ’Woun ãb chikham jẽb gaai phidkha sĩejim aajem. Mag phidkha simuata jẽb eem nem wajapham oobaadëjim anaabá. Magbaawai pöd ichdëu arrju khaba aawai, sĩi oo pʉawia, ich nemta warag isegamjö thumaa përkhʉʉipʉ̈iwia, ag phatkhonauta mag ichdëu nem oo pʉatarr chi jẽbpa për aujim aajem. Maimua ich Jesuupai mag ich nem ĩgkha sim ũr narr khʉʉnag magjim: ’Chi mʉ dënkhaju khʉʉnaun mag wounau mag phĩr aum khõchgau ich nem thum përkhʉʉitarrjö amach nem wai nʉmjã thumta iseg nʉmjö aju aai nʉmgui ajim, mʉʉta jũrr mag nem ajapham amachdëu ig nʉmjö paarpaag. ");
INSERT INTO noaE_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Mag mʉʉta nem wajapham amachdëu ig nʉmjö paarpaagan, chihöo chi ʉ̈rʉʉcha balee simta për awaag jʉr wënʉrrʉmjö aju aai nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mag jʉr nʉmua chi baau atham khʉʉu ich nem wai sim thumaa përkhʉʉiwi jũrr mag chihöo mag ich nem përkhʉʉitarr khãaijã ʉ̈rcha balee simta për athamjöta aju, chadcha mʉ dënkham khõsi mʉ jʉrwia baau athaawai. ");
INSERT INTO noaE_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mag jajawagmamua, ’Ẽwandamau õor i agkham edan, ãwarr pʉraag reeu döjãrr dö ʉrëu nʉmjöta ajugui ajim, ich Jesuupai. ");
INSERT INTO noaE_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","¿Pãrau oowai mag ʉrëu wai jörröo awia jiir aunaa, chi ãkhãar theernaa barpʉ̈iwia, chi wajapham appaita auba aajẽ? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ich jãgta ajugui ajim ĩchab Ẽwandamau pãar dʉ̈ijã, mʉg durr ichdëu i agkhabarm ed. Ẽwandamau ich chognaanag õor khaigbam khʉʉn chi wäjäaun eemua khĩet theerpi jaauju; ");
INSERT INTO noaE_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","magnaa mag chi ãkhãraam khʉʉn mag orno paa simjö sim ee barkhʉʉipʉ̈iju. Mag barkhʉʉibapäaiwai mamta icharaucha bĩenaa gaai machgau am khierr ujãkkhʉr ajugui ajim, amach khaigba wënʉrrarr jũrr. ");
INSERT INTO noaE_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mag jaau dichwia ich Jesuupai maach ich dʉ̈i wënʉrrarr khʉʉnagta, —¿Pãrau cha mua jaau chirʉm wajapha khaphʉ nʉ? a jëeujim. Magbaawai marau, —Ëera, maraun khaphʉ nʉmgui anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Magbaa ichdëu marag magjim: —Mʉg iek iiur mua jaau chirʉmjã pãrau chadcha khaphʉ naawai deeum khʉʉnag jawaagjã ya chi machnaankha nʉmgui ajim. Jãg nʉm aig õor Ẽwandam igwia i jʉr nʉm khʉʉnag pãrau jaauju aai nʉmgui ajim, chadcha pãachdëuta nawe Ẽwandamau ich i jaaumienag phãpitarrjã khaphʉnaa mʉg iek iiur mua jaau chitʉmjã khaphʉ naawai. ");
INSERT INTO noaE_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mag ejemplodamau nem jaau sĩewi jaau aaipabaadeewai aigmua mawia ");
INSERT INTO noaE_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","jũrr Nazaret phöbörög petajim, ich bãautarr aar. Mam pabaimaa, Ẽwandam iek jaau nʉm ũraag maach meeun biirdʉajem deg dubwi, õrag Ẽwandam iek jaaubaadëjim. Mag irua jajawagmam ũrwia jʉ̈gderraa nʉm iekhau warag amach eepaita, —¿Magʉm ichdëu jamta khaugjimta mag jaaumáma? ¿Jãga ichdëu jãg õor monaau nʉrrʉ́ma? anaa ĩchab, ");
INSERT INTO noaE_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Keena, ¿pãrau oowai jãg woun José pa waumie ag iewaa khabá, María dʉ̈ím? ¿Jã Santiago dʉ̈i khod khabá, José dʉ̈i, Simón dʉ̈i maimua Judas dʉ̈ijã agjö? ");
INSERT INTO noaE_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","I ʉ̈phʉʉin thum mʉig maach dʉ̈i ich mʉg phöbör ee naajem; maagwai ichjã maadëu khaphʉ nʉmgui ajierram, ich mʉiguim aawai. Mag simta, ¿jam khaugthurwiata jãg nem jaau khaauga ichdëu jaaumaajẽma? aajeejim jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Amachdëu mag nʉm gaaimua irua nem jaau simjã asekasba, warag i dʉ̈i khĩir khʉʉukha phöbaadëjim. Pari magbaa ich Jesuu amag, —Chadcha deeum durram khʉʉnaun mʉg Ẽwandam iek jaau wënʉrrʉm khʉʉnag eenaa am dʉ̈i ajapha aba aajeeb ajim. Mamʉ mag sim, jũrr dich di aig wa dich bãautarr durrpai chan magjã magba warag am kha isëe aajerramgui ajim, jũrr amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mag, warag maig chan Jesuu õor mor masim khʉʉn pöm monaaubajim, amachdëu i iek ʉ̈khamapha narr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mag Jesús nem khĩir pogkhe õor dakhĩir wau nʉrrʉm jaar ĩchab Erodeta Galilea durr reikha sĩejim. Mag ag na õrau nem ooba aajempa ich Jesuu wau sim sĩi bĩi wëjöm chi Erodeeu ũr athaawai ");
INSERT INTO noaE_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ich dʉ̈i ãbam degam khʉʉnag, —Maan Juan chi õor pör choomie khararrta deeu iiu phiidʉwia mag nʉrrʉmgui ajim anʉm; maguata mag õor mor masim khʉʉnpa monaau nʉrrabahab ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Irua mag sĩerran mʉga ajim aajem: Maata ich Erodeeu ich naam Felipe ʉʉi Erodías anʉmta khecheu auwi sĩejim anaabá. Mag atheeta Juanau chi reíg, “Pua pöd pʉch naam ʉʉi khecheu auwi pʉch ʉʉikha auju khaba simgui” ajim anʉm. Mamʉ sĩi ichig magbaawai warag Juan pʉr aupi jaauwi, cárcel deg phãar sĩupinaa cadenau jʉ̈ sĩupijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ichig mag iekhatarr aawaita chi Erodeeu i thõopʉ̈im iigjeejim anʉm. Mamʉ thumaam khʉʉnau Juanau Ẽwandam iekta jaau sim khaphʉ narr aawai, irua thõopʉ̈ikhiin, jũrr õrau ichta khaigbaju a khĩirjuwia pöd thõoba aajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mamʉ mag nʉm ee, biek ãb chi Erodes año cumpliitarr ag phiesta kha nʉm ee chi Erodías kha jemkhajim aajem, õor khapan thʉnʉm na. Mag i jemkha sim oowia, ich Erodeeu khõchkha thʉnʉisiwi, ");
INSERT INTO noaE_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ich bãaurrag, “Pʉchdëu nem khõsim mʉrʉg jëeubá; mʉch imeerba mua deeb khaba deejugui” ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mamʉ magbarm chi ãdaujã ũrtarr aawai ich chaai wawí sĩujim anʉm. Magbaawai chi chaairau ich bãaurr jöoyag, “Magan mʉ athee Juan chi õor pör choomie pörta thëp ee audeebá; jãata mua khõsi ʉmgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mamʉ mag Juan pörta ichig jëeubaawai warre chi rey ökhĩirjuu aadëjim anaabá. Mamʉ ichdëu õor thʉ̈rkhʉʉitarr dʉ̈i ãbam mes gaai nʉmuata mag ichig jëeubarm nem deeju a iekhatarr aawai ");
INSERT INTO noaE_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","chadcha Juan cárcel deg sĩerr aar õor pʉ̈iwia thõonaa, chi pör appai thëp ee waibëepi jaaujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Magbaawai i ipierr wëtwi, chadcha ichdëu jaautarrjö thõonaa, chi pör thʉapnaa aibëewi, chi daupeer mag chi jemkha sĩerrag deechëjierram aajem. Magbaa ichdëu jũrr ich ãdag deejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mag chi Juan ö thʉapbapʉ̈im abaawai, i dʉ̈i wënʉrraajerr khʉʉndamau bëewi, arrwi, aukhërjierram anaabá. Maimua ya mag amau i thõobapäaiwaita maar aig Jesuug jawaan bëejierram. ");
INSERT INTO noaE_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mag Juan ö thʉap thõobarm ich aar jaaubaimam ũrwia, ökhĩirjugau warag chawag õor chukag aar maju abaawai, marau i joo arrjim. Pari mag wëtumua ya maar döjãrr paaukhabaadëm õrau oopʉ̈itarr aawai ag dakha phöbör nʉnʉidʉm eem khʉʉnau jũrr khʉd garmua maar na ërëubaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Maimua ya jopimawia ooimaawai i na õor pöoma thʉnaajim. Magbaawai am dau aug khaugwi am aaunaanjã monaaupʉ̈imajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mag nʉm ee, ya kheeuraa aadeewai maach garmuata irig, —Mʉg õorjã chukag eeta ya kheeuraa aadëm; amag wëtpi jaaubá, phöbör ee wëtwi amach athee khöjudam për aumkhĩir anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Magbaawai, —Khöju jʉraanpai chan am wëtju khaba nʉm. ¿Jãg pãachdëuta am jãogbamma? ajim, ich Jesuu maachigta. ");
INSERT INTO noaE_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Magbaawai marau, —Maar khöju chukhu nʉmgui ajim amag deeg. Ãba pandamta cinco wai nʉm dʉ̈i ãwarrdamta dau numpai wai nʉm ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Magbaawaita ichdëu, —Makhʉʉndam mʉ aig aipidut ajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mag chadcha ich aig aipierrwai õor pöm mag thʉnarrag, —Phũak ee ohood abat ajim. Maimua mag pandam cinco narr dʉ̈i chi ãwarrdampa phë auwia ʉ̈gthaag eerpanaa, Ẽwandamag ag paar ʉ̈u ajim anaa, ichdëupai chi pan thorreunaa marag ʉapʉ̈imajim. Magbaawai jũrr maachdëuta õrag jigmajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mag jigmamua, jigmamua, ich iiu aawai thumaam khʉʉnau amachdëu khöm aig khötarrjã dʉ̈rr apiwi, pan pöm sobjim, chi ãwarrjã agjö. Mag chi sobtarr phë aunaa oowai thʉbʉt khapan docen ãb öbërjim chi ipiirkham. ");
INSERT INTO noaE_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mag ed mag Jesuu jãogtarr khʉʉn chi khapanag cinco mil naajim, emkhooin appai, ʉʉin beerba ni chaainjã beerba. ");
INSERT INTO noaE_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mag õor pöm thach khöpiwi jũrr maachta ich na maach dʉrbagkhatarr jap ee wëtpi jaaujim, ich na thoom igar naaimamkhĩir. Maagwai ichin agtha ich aig sĩsijim õor oopäaiwai. ");
INSERT INTO noaE_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Maimua õor thum ërëuwia ich appai aadeewaita, i iek buchag gaai ich appai ich Ayag jëwaan majim aajem. Maagwai ya edau khëubaadeewaijã mam ich appai chirajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Magʉmich maran ya döjãrr naajim. Mamʉ maar khĩir garmuata phũ wë thʉnarr aawai maar japan phũasau öpphërta jiir ahau khajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Maimua ya ãspa urumuata ich Jesús maar ẽudee bëejim. Pari mag urumjã sĩi döjã ʉ̈rta jẽb thetag gayamjö urajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mag döjã ʉ̈rta jẽb gayamjö maachig urum oobaawai jãphierrwi maar ääi khaphöbaadëjim. Mag jãphierrnaa ääikhamua, —Keena, akhaar khabahaba anaajim marau. ");
INSERT INTO noaE_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pari magbaawai ich Jesuu, —Keena, oob jãphierrmiet; mʉ khabahab ajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Magbaa Pedroou irig, —Señor, chadcha pʉchta Jesús khai, magan mʉjã pʉchjö döjã ʉ̈r pʉch aar mapibá ajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Magbaawai irig, —Bëejuma ajim Jesuu. Magbaawai chadcha Pedroou jap eemua waaidʉbaadëwi Jesús khĩirphee dʉdʉrgmaa ajim, döjã ʉ̈rta durramjö. ");
INSERT INTO noaE_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pari phũas dau dapag oowi jãphierrbaadëjim. Mag jãphierrbaadëm ee ĩchab ya ierrpamajim. Magbaawaita maach Pörög, —Señor, mʉ oobahur, mʉʉn ierrpamamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Magbarm bʉ̈rre Jesuu i jua gaai pʉrnaa, —¿Khanthee pua pʉch ierrpaju khĩirjujĩ? Jãgan pua chan mua pʉchig nem mag aawaijã mʉ iek ʉ̈khaba chirabma ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Maimua ya am jap ee waaidʉtkhabaadee chi phũ meuu aadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mag chi Jesús jap ee pabaadee i khĩirphee kanieu phõbkhanaa, —Chadcha pʉʉta Ẽwandam Iewaau anaajim, marau irig. ");
INSERT INTO noaE_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mag wëtumua thoom igar Genesaret durr phẽeubaimajierram. ");
INSERT INTO noaE_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mag Jesús barbaimam õrau khaugphöbaadee, sĩi ag perás bĩi jöisijim. Mag amachdëu khaugphöbaadee i aig õor mor masim khʉʉn aibëenaa irig, ");
INSERT INTO noaE_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Maar aaunaanag pʉch khajũahidam gaaipai khãijã pʉrpibá aajeejim, monaaumkhĩir. Mag chadcha thum i khajũa gaai pʉrmam khʉʉnan warre monaaukha maajeejim, mag sĩi pʉrbarmuapai. ");
INSERT INTO noaE_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ĩchab Moiseeu phã pʉatarr iek wajapcha ʉʉrkhaajem khʉʉn dʉ̈i Ẽwandam iek jawaag chi machnaan i aig bëejierram. Makhʉʉn Jerusalenmua bëetarr khʉʉn ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Mag bëewi irig, —¿Jãgwi pʉ khapeenau maach jöoin i pʉa nʉ? ¿Jãgwi thach khoowaijã jua ʉbata thach khoojẽ? ¿Pãrau khaugba naab jãg ʉ̈u khaba sim? aichëjierram. ");
INSERT INTO noaE_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Magbaawai Jesuu ĩchab, —¿Khanthee pãraujã agjö Ẽwandamau jaau sim thum ipierraa abanaa sĩi pãach jöoin iita ʉ̈rcha ʉʉrkhaju ẽkhaajerráma? ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Magnaa amag, ¿Pãrau khaugba nʉ ajim, Ẽwandam iek phã sim gaai jaauwai, “Pʉch aaijã pʉch ãd dʉ̈i jãsenenaa ökhö abá” a sim? Maimua “Ar iwiir ãbmua khãijã ich aai wa ich ãd khãijã thõpnaa ãaukha iekha simʉn warreta thõopʉ̈iju aai nʉm” a sim, ¿majã pãrau khaugba nʉ? ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Magnaa ichdëupai, Pari Ẽwandamau ich iek gaai mag jaau simta, jũrr pãar iek mag ãbmua khãijã dich ayag wa dich ãdag khãijã, “Pãrau ig nʉm mua wai chirab mamʉ, pöd mua deeju khabam, ya thum Ẽwandam atheem aawai” a iekhaju aai sim anʉm, dich dënnaan dau aug khaugba. ");
INSERT INTO noaE_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pari pãrau õrag mag jaau nʉm aig, Ẽwandamau nem jaau sim isegnaa jũrr pãach jöoin iita ʉ̈rcha ʉʉrkha naabahab ajim Jesuu, amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Magnaa, Chadcha jãg Ẽwandam iek gayam pãachdëu nem jaaujemjö khaba jũrr ag chaaur nem wau sĩerrjëem khapta Ẽwandamau ich i jaaumie jöoi Isaías khararrag pãach igwia ich iekhatarr iek mʉg phãpijimgui ajim. Magnaa chadcha ag gayam jaaubaadëmua, ");
INSERT INTO noaE_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Pãran, sĩi par iekhaupaita Ẽwandam iek ʉ̈kha nʉm ʉ̈kha nʉm aajemgui” ajim Jesuu amag. “Pari mag nʉm chan par chadcha thãraucha ʉ̈khabamta mag sĩerrjëem. Pãach mag nʉm gaaimua pãar thãar chan i dakhajã khaba, sĩi i warpta thʉnʉmgui” ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“Jãg nʉm aiguin parii pãach iphithur pãrau irig jëeuju. Pãrau jaau nʉmjã sĩi wir aig pãach khĩirjugpaiu; jã i iek khabamgui” ajim Jesuu amag, warrgarwe Ẽwandamau jaautarr igwia. ");
INSERT INTO noaE_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Magnaa õragta eerpanaa, ’Wajapha mʉ iek ũrbat ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Maadëu nem parhooba khö nʉmuapai chan Ẽwandam dau na maach ãrpiba aajemgui ajim. Ẽwandam na õor ãrpiejemʉn iekhaju khabam nempa khĩirjunaa iekha nʉmuata õor ãrpiejemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Irua magbapäaiwai maach chi khapeenauta irig, —Fariseonaan iek, mag pua magbarm aig, am khĩirta iekhabapʉ̈im aajem anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Magbaawai jũrr ichdëu maachigta iekhamamua, —Oob am iek asekasmiet ajim. Pãrau khaphʉ nʉm, nemjĩir ee phũak khaigbam öbeerwai thʉrrëupäaijem. Ich jãgta ajugui ajim mʉ Ayau am dʉ̈i. Am ichdëu jʉr au sim khʉʉn khaba aawai nemjĩir ajapham eemua phũak chi khaarpa thʉrrëunaa barbapʉ̈imjöta ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Magua, idëu warag khĩuu sĩubat ajim. Jãkhʉʉnan amachjã dau khĩsu nʉmta agjö dau khĩsum khʉʉn jua gaai pʉrnaa ëudʉ arrjem khʉʉnjöta nʉmgui ajim. Pãrau oowai merag chukhu sĩebá, dau khaugba khitʉmua agjö dau khĩsu khitʉm jua gaai pʉrnaa arrkhiin, ãb bʉ̈ëu subaadee amach numwe burrjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Magbaawaita maar eem ãb Pedro aajemua irig, —Señor, cha pʉchdëu jaaubapʉ̈im deeu marag wajapha jaaubá; marau pöd khaugba abarmgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Magbaawai Jesuu marag jaaubaadëwia magjim: —¿Wa pãrau agtha khaugbata nʉwa? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Pãrau khaphʉ naabá, maadëu nem khö nʉm thum maach bi ee mawia chëbapäaiwai deeu chukhu aadeejem? Magua dichdëu thach khö nʉmuapai chan maach ãrba aajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Maach ãrpi nʉmʉn thãar eemua khĩirjug khaigbam iekha nʉmuata Ẽwandam na maach ãrpiejemgui ajim, ya khĩirjunaata iekhamaawai. ");
INSERT INTO noaE_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nem thum maach khĩirjug eemuata öbër thʉnʉm: khĩirjug khaigbam, õor thõoju, dich õor khabam dʉ̈i khapes aju, dich khaman apha khãijã dich õor dʉ̈ímjö aju, nem jĩgkhaju, sëukhaju maimua chikham ëugar chad khabam iek iekhaju. ");
INSERT INTO noaE_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Magʉm nemeuta chadcha Ẽwandam na õor ãrpiejem. Mamʉ chi machnaanau jaau nʉmjö sĩi jua sũgba thach khö nʉmuapai chan Ẽwandam dau na maach ãrba aajem a jaaujim marag, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Maigmua igbaadeeu jũrr phöbör numí Tiro Sidón dʉ̈i nʉmʉg petaawai maarjã i dʉ̈i wëtjim. ");
INSERT INTO noaE_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Maimua ya mam paaukhabaimamta, ʉʉi ãb Israel durram khaba Canaanpie ʉʉi mag perás sĩejerrta ääag bëewia Jesuug, —Señor, mʉ ap ʉrrʉm mʉ dau aug khaugbá ajim. Mua khaphʉ ʉmgui ajim, pʉʉta chadcha Ẽwandamau pʉ̈iju aajerrau. Maagwai mʉ chaai monawaagjã pʉ jua theeg sim. Mʉ kha dösãt bënëu baarjemta pʉrʉg monaaubapʉ̈i a ʉmgui aichëjim, irig chaigpamamua. ");
INSERT INTO noaE_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pari par ũanau mag chaigpa khitʉmjã Jesuu bʉ̈ʉrjã i iek ʉ̈khabajim. Magbaawaita marau irig, —Senõr, ¿jãg pua irig mapi jaaubamma? Ya atcha magaajã marau ũrmapha nʉm. Magbamʉn ich jãg maach ẽudee ääag majuwai anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pari magbaawai jũrr Jesuu chi ʉʉiragta, —Ẽwandamau mʉ pʉ̈itarran, maach meeun israelnaan sĩi oveja okhoo durrumjö durrum khʉʉn peerdʉ aumkhĩirta mʉ pʉ̈ijim ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pari mag nʉm ee, warag i aigcha bëenaa kanieu phõbkhanaata, —Señor, mʉ ap ʉrrʉm mʉ chaai monaaubapʉ̈i ajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Magbaa, judionaan khabam khʉʉn chan monaauju khabam awi juau ogthompai chi Jesuu warag, —¿Pua mʉ iekha chirʉm ũrbata sĩ? ajim. Pʉ deeum durram aawai, mua pʉ chaaita nacha monaaukhiin, mua oowai dich chaainag deeju arr panta khecheunaa saakienag deebarmjö ajugui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pari magbaa ũanau dʉ̈i, —Señor, jãan chadaugui ajim. Mamʉ pua oowai, ¿saakienaujã amach pap juasur mes eegar khʉimam khöba aajẽ? ajim. Maagjeewai mʉ Israelpie ʉʉi khaba ʉab mamʉ, ¿pua mʉ chaaijã dau aug khaugbaju khai? Mua khaphʉ ʉm, pua i monaaupʉ̈iju aai simgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Magbaawaita, —¡Jöo! Jãgan chadchata mua pʉch chaai monaauju khaphʉnaata pua ʉ̈kha ʉmgui ajim. Magan chadcha pʉchdëu jaau simjö pʉ chaai monaauju ajim irig Jesuu. Mag, chadcha Jesuu mag iekhabarm bʉ̈rre chi chaai monakkha aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mag Sidonmua deeu maar bëewia ũwaai mag thʉrrdö pöm sim Galilea aajem igaau naaichëjim, ich Jesús dʉ̈i. Maimua buchag gaai waaidʉwia oo sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mag amach dakhĩir jupbaimaawai õor pöm i aar wëtwi i bigaau phʉʉrbaadëjim. Mag õor pöm thʉnʉm ee i aig aibëemajim: bʉ̈ wëdʉ wëdʉ khithëem khʉʉn, dau khĩsum khʉʉn, bʉ̈dam wa juadam khãijã ãkhãraam khʉʉn, meu meraam khʉʉn maimua tag aaunaan khamor machag khĩirpierr i aig aibëenaa i bʉ̈khʉrr ausĩumaajeejim. Maagwai magʉm thum ichdëu monaaupʉ̈i maajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Amach daúacha mag meu meraa khithëe arrjã ijẽb nʉrrjëe, juadam wa bʉ̈dam khãijã ãkhãraa khithëe arrjã monakha, maimua dau khĩsu khithëe arr khʉʉnpa dau wajapha nʉrrjëem oowia, sĩi õor dauderraa naajim. Mag amachdëu oo nʉm gaaimua maach meeun khabam khʉʉnaupata maach meeun israelnaan Ẽwandamag jëeuphöo thʉnaajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Maimua mag maach ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnagta, —Õor pöm mʉg thʉnʉm mʉ dau ee dau aphʉʉ durrumgui ajim. Ya khãai thãrjup pam am maach aigmua bʉ̈ʉrjã ogdʉba, thachdam khöjujã chukhu nʉm. Ich jãg thach khöba chan mua amach diig pʉ̈imapha chirʉmgui ajim. Ich jãg pʉ̈ikhiin, di aar barba khãijã khʉd ee jãdaúa phʉrëubajupa ajim, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Magbaawaita marau irig, —Mamʉ mʉg õorjã chuk sim ee, ¿jam maadëu khöju bawaagauma? anaajim, õor pöm mʉg thʉnʉm khöpieg. ");
INSERT INTO noaE_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Magbaawai ich Jesuu marag, —¿Pãrau pan dau kharr wai nʉma? a jëeujim. Magbaa marau, —Sietepai, maimua ãwarrdamjã ar dau khapan khaba durrumgui anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Magbaawai ichdëu õrag khʉt jupkhapi jaauwia, ");
INSERT INTO noaE_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","mag pandam siete narrjã chi ãwarrdam dʉ̈i ãba jua ee phë auwia, Ẽwandamag ʉ̈u ajim anaa thorreubaadëjim. Magnaa maachig ʉapʉ̈imaawai marau jũrr õrag jigmajim. ");
INSERT INTO noaE_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mag jig phʉʉrdʉdʉgmamua thumaam khʉʉnau amachdëu khöm aig khötarrjã, pan pöm sob thʉnʉisijim. Mag chi sobtarr, thʉbʉt siete marau ipiirkha aujim. ");
INSERT INTO noaE_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mag ed mag chi thach khö narr khʉʉn cuatro mil naajim, emkhooin appai, ʉʉinjã beerba ni chaainjã beerba. ");
INSERT INTO noaE_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Maimuan chadau õrag wëtpi jaaubaawai agdaujö amach majupierr aaidʉjierram. Mag thumaa ërëubaadeewain chadau, ichjã jap ee waaidʉbaadee, marau i Magadanag arrjim. ");
INSERT INTO noaE_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mag Magadán durr paaukhabaimaawai fariseonaanau Saduceonaan dʉ̈imua Jesús oon bëejierram. Pari mag bëetarran sĩi i imeraa pʉr aum khõchgaupai arr aawai irig amachdëu bʉ̈ʉrjã ooba aajem nemta amach dakhĩir edjã ee waupi jaau naajim, mag gaaimua chadcha Ẽwandamau pʉ̈iwiata mag nʉrrʉm a amachig khap jaaumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pari Jesuu am ipierraajã khaba, warag sĩi amag, —¿Khan jãgwi pãrau kheeurag edau dubmamua edjã phur waau thʉnʉm oowia, “Nan edau wärjäphä aju” aajẽ; ");
INSERT INTO noaE_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","maimua jũrr edaupherrejã agjö edau öbër urum bʉ̈ʉu edjã phur thʉnʉm oowi, “Nan edau khõrkhaju” a jaaujẽ? ajim. Pãrau jãg edjã oobarm gaaimuapai ed wärjäug aju wa ed khõrkhajujã nem khaug nʉmta, ¿jãga jãg pãrau pãach daúa mua nem wau chitʉm oo nʉmjã pöd khaug auba nʉ mʉ chadcha Ẽwandamau pʉ̈iju jaaujerr? ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Pãran pãachdëu Ẽwandam iseg nʉm gaaimua warag chi ajaugjã chukhu thʉnaawaita warag pãachdëu nem ooba aajem nempata pãach dakhĩir waupi nʉm. Mamʉ mua waubamgui ajim. Mag khãai warrgar jöoi Jonás aajerr nemmeeurrkhan buch ee khãai thãrjup sĩethurtarr gaaimua Nínivepienau Ẽwandamau i pʉ̈itarr khaug autarrjöta, ĩchab mʉchjã Ẽwandamau pʉ̈itarr pãrag khaphʉ apijugui ajim, mʉch iiu phiidʉbarm gaaimua. Mamʉ magʉmjã pãrau ʉ̈khabajugui ajim. Mag iekhapet awi ichta warag chaaug igbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mag igbaadëwi ya thoom igar paaukhabaimaawaita maar khĩir ee dʉnʉisijim, panjã aibëeba sĩi ich jãgta wënʉrrʉm. ");
INSERT INTO noaE_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Magbarm dʉ̈ichata ich Jesuujã marag, —Khĩir khaphʉ wënʉrrathʉ̈ ajim. Fariseonaan bënta saduceonaan bën dʉ̈i jãg levadurajö sim pãach gaai dʉrbapimiet ajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mag ũrwia, chadcha levadurata jaau simpii awi, maach appaijã, —Keena, maach chan chadchata pan aibëebajimwai anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mamʉ maar mag iyʉ̈ʉ nʉmjã ich Jesuu khaphʉ sĩerr aawai, —¿Khantheeta pãar mag pan aibëebajim anʉ́ma? Pãrau chan jãgan mua nem wau chitʉmjã oobamjöta aajeeb ajim, mʉg mʉ dʉ̈i ãba wënʉrrʉmjã ʉ̈khaba aag. ");
INSERT INTO noaE_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pãrau khĩir ee paba nʉ, mua pandam cincopai narrau ʉʉinjã beerba, chaainjã beerba, emkhooin appai cinco mil jãogtarr? Maimua ¿thʉbʉt kharr ipiirkha aujĩ chi sobau? ");
INSERT INTO noaE_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Khĩir ee paba nʉ agjö, pan sietepai narrau õor pöm cuatro mil narr jãogtarr? Maimua jãg edjã, ¿thʉbʉt kharr ipiirkha aujierrá chi sobau? Pan chaarta ig nʉm akhiinjã, ¿pãrau khĩirjuawai ĩsjã mua pöd pãach jãog aubajupii nʉ? ");
INSERT INTO noaE_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jãga jãg pãrau bʉ̈ʉrjã khaug auba nʉ ajim, mua pãachig, “Fariseonaan bën saduceonaan bën dʉ̈i levadurajö simta pãach gaai dʉrbapimiet” aawai? Mua mag chirʉm aig chan pan chaar igwiata pãrag mag iekhaba chirʉm; wajapcharan muan maiguin, oob amjö chikham khĩir aawaipaita chadam iekjö iekhamiet a chirʉmʉu ajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Magbaawaita marau khaugphöbaadëjim, Jesuu levadura chaar jaauba, sĩi fariseonaanau saduceonaan dʉ̈imua nem jaaujemta jaau sim. ");
INSERT INTO noaE_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mag wëtwia deeum durr Cesarea de Filipo anʉm paaukhabaimaawai ich Jesuu marag, —Õrau mʉch chi Emkhooi Iewaa igwia iyʉ̈ʉ nʉm ũurwai, am iek ¿mʉ khai aajẽ? ¿Pãrau ũrba aajẽ? a jëeujim. ");
INSERT INTO noaE_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Magbaawai marau irig, —Am iek pʉ Juan chi õor pör choomie aajem; deeum khʉʉnau jaauwai pʉʉta Elías aajem, warrgar Ẽwandam i jaaujerr; wa magba Jeremías khabam khai, dewam khãijã aajem, agjö Ẽwandam i jaaujerr. ");
INSERT INTO noaE_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Marau ichig magbaawai jũrr maachigta, —¿Ma pãachdëujãma? Pãrau khĩirjuawai, ¿mʉ khai agá? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Magbaawai Simón Pedroou, —Pʉ Cristo khabahab ajim irig, ich Ẽwandam Iewaa warrgarwe ichdëu jʉr auwia õor peerdʉ aumkhĩir pʉ̈iju a jaaujerr. ");
INSERT INTO noaE_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Magbaawai Jesuu irig, —Simón Pedro, Jonás iewaa, õrau bʉ̈ʉrjã pʉrʉg jaautarr khabamta chadcha pua ag eyaa jaaubapʉ̈imkë ajim. Jãg pua khaphʉ jaaubapʉ̈imʉn, jãan ich mʉ Aai ʉ̈gthar chiraajemuata pʉrʉg mag khĩirjupiwi ajim. Maguata pua ag eyaa jaaubapʉ̈ibahab ajim. ");
INSERT INTO noaE_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pedro, maagwai pʉʉn chadcha pʉch thʉ̈riu jaau simjö mokdauu ajim irig. Pua mʉ iek jaaubaadëm gaaimuata mua mʉch iek ʉ̈kha nʉm khʉʉn khapaana apiju. Mag khapaana aadëm chan pãach chi ʉ̈rʉm khʉʉnan khëchwiajã, pãar akhaar chan okhooba ich mag Ẽwandam dʉ̈ita nʉisiju ajim. ");
INSERT INTO noaE_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pedro, pʉrʉgta mua mʉch iek jaaumkhĩir jaau chirʉmgui ajim. Pua mʉ iek jaaubaadëm ũrwi ʉ̈kha nʉm khʉʉn mʉ dënkha nʉisiju. Mamʉ ĩchab pua jaau khitʉm ũr nʉmjã asekasba warag iseg nʉm khʉʉnan amach mag nʉm gaaimua warag ich mag okhoo wënʉrrajugui ajim. Mag nʉm aiguin pua chi mʉ aar öbërju aai nʉm khʉʉnag puertdi weeu deenaa pöd dubbaju aai nʉm khʉʉn athee sĩi warag phãar sĩsiukhamjöta aju. ");
INSERT INTO noaE_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mamʉ Jesuu mag ich chadcha ich Ẽwandamau jʉr auwia pʉ̈itarrkha simjã bʉ̈ʉrjã õrag jaaupiba jaaujim marag. ");
INSERT INTO noaE_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Maimua jaaumamua ich Jerusalenag majujã jaaujim. Mag Jerusalén pabaimaawai jöoin chi pörkha nʉm khʉʉnau phadnaan chi pörkha nʉm khʉʉnaupa Moisés iek jawaag chi machnaan dʉ̈imua ich dau aphʉʉ wai naawi ich thõojujã jaaujim. Mamʉ mag amau i thõowiajã deeu ũwaai khãai thãrjup nʉm ee deeu ich iiu phiidʉjujã jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mag jaaumam ũrwia, Pedroou ich appai chaaur thʉ̈rnaa, —Señor, ¿khanii Ẽwandamau pʉ dʉ̈i magpibarju? Pʉ dʉ̈i chan õrau magju khaba nʉmgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pari Pedroou ichig magbaawai, jũrr chi Jesuu irig, —Jöpkhaa mʉ aigmua chaaug petá ajim. Meperauta pʉrʉg mag iekhapi sĩebahab. Puan mag sim aig sĩi warag khaibag ee mʉ burrpijuuta ẽkha simgui ajim. Pua chan Ẽwandamau nem waum ig simjã khaugba, sĩi parhoobam khʉʉnjöta khĩirju simgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Maimua ichdëupai jũrr maach thumaam khʉʉnagta, —Chadcha pãrau mʉ iek pãach thãraucha ʉ̈kha nʉm khai, magan mua nem waupi jaau chirʉm appaita waubat, “Mʉchdëuta khap chirʉm mʉchdëu nem wauju” a iekhaba. Mʉ gaaimua chikhamnau pãach dau aphʉʉ thõoju khĩirjuwia khãijã magʉmjã igba waragta ʉ̈khanaat ajim. ");
INSERT INTO noaE_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ar mʉig eegarjã mʉ gaaimua phithurg aumapha nʉm khʉʉn chan bʉ̈ʉrjã ʉ̈gthar öbërbam. Magarrau ar chi mua nem jaau chirʉm waum khõchgauta amach nemjã khĩirjuba, sĩi warag mʉ gaaimuata dau aphʉʉ anʉm khʉʉnan chadau ʉ̈gtharcha öbërju jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pãrau oowai, ¿khan wajaug sĩ ajim, ãbmua mʉg durr thum ichdëupai jʉ̈a wai sĩsim, mamʉ mag sim meebaadee khĩmie durr petam? ¿Irua ich durr thum ich dʉ̈i arrju aai sĩ? Pöd arrbam. ¿Pãrau khĩirjuawai ãbmua khãijã ʉ̈gthar öbëraag phatkhon pöm phagju aai sĩ? Mag phagwiajã pöd dubbamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mʉgnaa mʉ Ayau mʉg durr i agkham edjã mʉchta ichdëu jua theeg deetarr dʉ̈i i chognaan angelnaanpa bëewi, mʉig eegar amach nem waaujerrpierr aju am dʉ̈i: chi nem wajapha waaujerr khʉʉn dʉ̈ijã ich agjö maimua nem khaigba waaujerr khʉʉn dʉ̈ijã ich agjö. ");
INSERT INTO noaE_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cha mʉ iekha chirʉm iekhau ãaur khʉʉn cha mʉ iek ũr nʉm khʉʉn chan mʉch chi Emkhooi Iewaa thumaam khʉʉn Pörkha bëeju edamjö aadëm oobam aigjã meebajugui a jaaumajim. ");
INSERT INTO noaE_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mag ich Jesús maar dʉ̈i iyʉ̈ʉ simua mag maar khapeen ãaur khʉʉnag amach daúa ich oopiju jaautarr khur seis días aadëm ee, cerro pöm sim gaai petajim. Mag ich mam dʉ̈i phë arrjim: Pedro, Santiago maimua Juan, ich Santiago eeum. ");
INSERT INTO noaE_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mag mam wëtwi am dakhĩirta Jesús khĩir chaaupabaadëjim aajem. I khĩir oowai mʉg edau ãsdawam khĩirjöta bʉ̈ʉ thʉnʉisijim aajem; maagwai i khajũa chará phuumjö aadëjim aajem, ich bäpgau. ");
INSERT INTO noaE_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","I magbaadëm ee oowai warrgarm jöoin Moiseeta Elías dʉ̈i iyʉ̈ʉ dʉnʉnʉihdʉ naajim aajem, Jesús dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mag oobaawaita Pedroou Jesuug, —Señor, ʉ̈u chi agamjö nem wajaug maar mʉig nʉmgui ajim aajem. Pua khõs akhiin mua rãichdidam thãrjup ëukham ajim anʉm: ãb pʉ athee, ãb Moisés athee maimua ãb Elías athee. ");
INSERT INTO noaE_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mamʉ Pedro mag iekha dʉnʉm ee, jʉʉnthumie baug bëewi am jöodʉ athaichëjim anaabá. Magbarm ee mag chi jʉʉnthumie eemuata woun iekjö, “Chamʉʉta mʉ Iewaa mʉchdëu jãsehne wai chitʉmʉu, õor peerdʉ aumkhĩir mʉchdëu jʉr autarr. Irua nem jaau simta ipierraa abat” a iekhabarm ũrjierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Amach chi dʉ̈i wënʉrrarr khʉʉnaucha jaauwai, amachdëu mag ũrbaawaita jãphierr phöbaadëm iekhau warag kanieu thʉkhöokhanaa eeg khökhöod aphöbaadëjim anaabá, khĩeb jẽb gaai dagau dʉrkha. ");
INSERT INTO noaE_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Magbaa Jesuu am aig bëenaa am gaai juau sĩesĩenaa, —Phiidʉtkhabat, oob jãphierrmiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Magbaawai chadcha amau phiidʉtkhanaa oowai, tagam khʉʉn chukhu, ãba Jesús appaita sĩejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Maimua deeu jerag bëejierram aajem. Mag ʉʉrbagkha wëdurumua chi Jesuu amag, —Mʉg pãachdëu ootarr oob deeum khʉʉnag jaaumiet. Ya mʉch chi Emkhooi Iewaa meewia deeu phiidʉbaawain chadau jaaubat ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Magbaawaita jũrr amach garmua irig, —¿Jãgwi Ẽwandam iek jawaag chi machnaanau jaauwai, mag Eliata ich Ẽwandamaucha pʉ̈iju jaaujem na bëeju aajẽ? ajierram aajem irig. ");
INSERT INTO noaE_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Magbaawai ich Jesuu, —Chadcha chi bëen Eliata nacha bëema ajim anʉm. Pari mag i bëeju jaautarran, mag Ẽwandamau pʉ̈iju aajerr õrag nʉpi jaaumkhĩirta bëeju jaaujimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pari Elías ya barthurjim. Mag i barthuurwaijã amau i khaug auba, sĩi warag deeum khʉʉnpii awi i dʉ̈i amachdëu ampierr awi warag i thõopʉ̈ijierramgui ajim anʉm. Amachdëu i dʉ̈i jãgtarrjö mʉch chi Emkhooi Iewaa dʉ̈ijã ajugui ajim anaabá. Mʉg chirʉmʉn mʉʉn wajap am jua machag ãwatjugui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pari Jesuu amachig magbaawai warre khaug athajierram anaabá, warrgar Ẽwandam i jaaujerr Elías khaba, Juan chi õor pör choomie igwiata mag sim. ");
INSERT INTO noaE_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mag wëdurumua ya maar tagam khʉʉn dʉ̈i narr aig jër paaukhabaichëm ee, woun ãb bëewi i khĩirphee phõbkhanaa irig chaigpamamua magchëjim: ");
INSERT INTO noaE_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Señor, mʉ chaai wai chirʉm thõthõrrsö khitʉm. Mʉ ap chitʉm mʉ chaai dau aug khaugwia monaaubapʉ̈i aichëjim. Jãg khitʉmʉn nem theegta baarjem. Khar chará ooju chukhu aawai barbaadëmua õt eejã burrjem; wa magbamʉn dö eejã sĩi dobojo aimaajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mua mʉig pʉ khapeen aig aibëetarrjã amau pödbajierramgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Magbaawai Jesuu magjim, õrag eerpanaa: —Pãran chadcha pãach thãar khaibag gaaimuata Ẽwandamau jãg chaai monaaujujã khĩirjũba nʉm. Pãrau jãg Ẽwandam jua theeg simjã khaugbamjö nʉm, ¿ich jãgta sĩi mua ãwat chitaju aai chirʉ́ pãrau oowai? ¿Khan atchata pãrau mʉ pãach dʉ̈i chitapim ig nʉma? ajim, ajapcha ʉ̈khaag. Magnaa, Mʉ aig mag chaai aipidut ajim. ");
INSERT INTO noaE_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Magbaa chadcha chi chaai ich aig aipierrwai chi meperag meeurraunaa öbërpi jaaubaawai, i ipierr öbërbaadëjim. Magbarm aigmua chi chaai monakha ich mag sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mag chi chaai monaautarr khur maach ap paaukhawi marau ich Jesuug, —¿Jãgwi marau pöd jãg chaai mor eem mepeer öbeerpi aubajĩ? a jëeujim. ");
INSERT INTO noaE_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Magbaawai ich Jesuu marag magjim: —Jãan pãachdëu mʉg chaai Ẽwandamau monaaujujã khĩirjuba narr gaaimuaugui ajim. Pãrau Ẽwandam jua theeg sim khaphʉnaa pãachdëu nem mag abarmjö apiju khĩirjunaata nem waukhiin, Ẽwandam athee chan phithurm nem chukhu aajeewai, chadcha pãachdëu jajaaukhampierr ich mag pãachdëu jaau nʉmjö apiju. Pãar khĩirjug oojem anaa chi pömag mostaza daudam ar maach dau ee paba khitaajemjö khãijã khitakhiin, chag durrsĩig khãijã, “Jöpai mʉigmua mawia chum dʉnʉʉubaimá” abaawai chadcha phithurg chukhu mawia pãar ipierr pãachdëu jaaubarm aar dʉnʉʉuwimajugui ajim.  ");
INSERT INTO noaE_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Magnaa ichdëupai, Jãg mepeer khĩir chan sĩi iekhabarmuapai öbërba sĩerrʉm. Jãg öbërpi awaagan, bʉ̈ʉrjã thach khöba sĩi Ẽwandamagpai jëeu nʉʉ awiata öbërpi jaaubaawai öbeerjemgui ajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea durr maach ich Jesús dʉ̈i ãba wënʉrraajeewai ichdëu marag magjim: —Mʉch chi Emkhooi Iewaa mʉg chirʉmʉn chi thierrnaanag pʉr deebaawai ");
INSERT INTO noaE_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sĩi amau mʉ thõopʉ̈iju. Mamʉ mag amau mʉ thõowiajã khãai thãrjup nʉm ee deeu mʉ iiu phiidʉjugui ajim. Maachigcha mag jaaubaawai chadcha maar ökhĩirjuu aphöbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesuu maar ich dʉ̈i phë arrwi Capernaum phöbör barimajim. Magbaawai Aai i jëeujem di paar phatkhon jëeujem khʉʉnau Pedro ich appai sim aar wëtwia irigta, —¿Pʉ maestroou chan Aai i jëeujem di paar phagju aai simta phagba aajeeb? aimajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Magbaawai irua, —Keena, mʉ maestroou phagba aajeeb a chirajim aajem amag. Maagwai ya maar maach jẽer narr di aar naajim. Maimua ya chi Pedro maach aar barbaimaawaijã jũrr Jesuu irig ich ag iekpai, —¿Pua jãga khĩirju chirʉ́ Simón? ajim. ¿Pua oowai mʉg durr gaai reinaan thʉnʉm khʉʉnau chijã khʉʉnagta dëbpaar jëeujẽ: amach khodnaanag wa sĩi parhoobam khʉʉnag? ");
INSERT INTO noaE_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Magbaawai Pedroou irig, —Amach khod khabam khʉʉnagma ajim. Magbaata Jesuujã, —Chadcha chi khodnaanau chan phagba aajemgui ajim. Magua muajã mʉch Aai gaaimua agjö phagbaju aai chirabahab. Chi Aai i jëeujem di i dën aawai muajã phagba, pãraujã phagbaju aai nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mamʉ amag maach ëugar iekham ugua maadëujã ichiita phagju aai nʉmgui ajim Pedroog. Maimua, Thʉrrdö ee dö ʉabamí ajim. Nau nacha pʉch jua gaai khöbaichëm pua jiir atham ö ee phatkhon sĩeju. Mag phatkhonau ʉ̈u pua mʉ kõitjã phagwi, pʉch dënjã phagpʉ̈ijugui ajim Jesuu Pedroog. Magbaawai Pedroou chadcha ichig jaautarrjö ajim. ");
INSERT INTO noaE_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ich mag iyʉ̈ʉ nʉmua marau ich Jesuug jëeu naajim, ichta mʉg atag thumaam khʉʉn Pörkhabaadeewai maach mʉg wënʉrrʉm eem khaita ʉ̈rʉʉcha sĩsiju khai a khap aag. ");
INSERT INTO noaE_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Magbaawai Jesuu chaaidamta thʉ̈rnaa maar jãrr dʉnʉʉupinaa magjim: ");
INSERT INTO noaE_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Mʉ cha iekha chirʉm iekhau pãrau pãachta ʉ̈rʉʉcha am khõchgau pãachdëu mag khĩirju nʉm isegnaa chaain mʉgʉmdam agtha serbiibamjöo abam chan, pãar pöd mʉ dʉ̈i chi pörnaan khaju khaba nʉm. ");
INSERT INTO noaE_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mag mʉchta chi Pörkha chirsim ed mʉ garcha joothʉimaju khĩirju nʉm khʉʉnan warag amachta serbiibamjönaa chaain mʉgʉmdamjöta aju aai nʉmgui ajim, mag amachta ʉ̈rʉʉcha ajujã khĩirjuba. ");
INSERT INTO noaE_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pãrau mʉ dënjö mʉg khithëem ãb khãijã jãsenkhawia pãach di aig aumʉn magan pãrau mʉchchata khĩir jãsenkhabarmjö abarmgui ajim, marag iekhamamua. ");
INSERT INTO noaE_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mag warag iekhakhagmamua magjim: ’Ãbmua khãijã mʉ chaai mʉg mʉ iek ʉ̈kha khërʉmta pekau ee burrpimʉn, Ẽwandam dʉ̈i iekkhõr pöomata sĩsiju. Mag mʉ chaai ãbam gaaimua khãijã warag Ẽwandam dʉ̈ita iekkhõr paarpaju khãai, ichdëupai ich ö gaai mokpör pöm jʉ̈naa phũas ee baudʉkhiin ʉ̈ucha ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mʉg jẽb gaai ichiita ich jãg õor dich khapeen pekau waupiejem khʉʉn paraa aju. ¡Mamʉ ë, apkhiitʉ, chi mag dich khapeendam pekau ee burrpiejem khʉʉn! ");
INSERT INTO noaE_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Magua, mua pãragjã mag chirʉm: Pãach juau wa pãach bʉ̈ʉu khãijã pekau ee burrpiju sim khai, warag thʉapnaa barbapʉ̈it ajim. Pãach thum monakha okhoowi õtdau ich mag thõojã khaugba sĩerrʉm ee maju khãai, ʉ̈ucha simgui ajim, sĩi jua bisi wa bʉ̈ khãijã bisi ʉ̈gthar öbërju. ");
INSERT INTO noaE_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Wa pãach daúapai khãijã pekau ee burrpiju sim khai, ag dau jẽunaa warag barbapʉ̈it ajim. Dau numwe wajapha simta khĩmie durr maju khãai, ʉ̈ucha simgui ajim, dau ãbpaim dʉ̈ipai ʉ̈gthar öbërju. Wajapcharan magʉm pekau waumaaugau, dau chukhumjö oobamjönaa magʉm nem khaigbam wawaagjã jua chukhumjö abat ajim, bʉ̈ʉrjã wauba. Magju khãai Ẽwandam dau na pãach morta sʉrkhabat a jaaumajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mag jajawagmamua ĩchab, ’Mʉg daumeraa khithëem khʉʉn oob ãb khãijã isegmiet ajim. Am thʉa mʉ Aai aar thʉnʉm khʉʉnaun amag dau par khaba thʉnʉmgui ajim.  ");
INSERT INTO noaE_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","’Mʉch chi Emkhooi Iewaan chadcha õor amach khaibag gaaimua okhoo khithëem khʉʉn peerdʉ awaanta bëejim a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Magnaa, Mua pãrag jëeu ookhimgui ajim, jãga sim khai pãrag: Woun ãbmua cien ovejas wai sim. Mag khapan thʉnʉm eem ãb okhoobaadee, ¿irua tagam khʉʉn ãbam aig phëpʉawia mag chi okhoo khërʉmta jʉraan mabaju khai? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mag jʉr nʉrrʉʉ awi baau athakhiin, mag ãbpai okhootarr baau atham paarta ʉ̈rcha i onee ajugui ajim, tagam khʉʉn khapan okhooba narr paar onee aju khãaijã. ");
INSERT INTO noaE_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ich jãg ãbmuajã ich nemchaain okhoopimapha aajemjö, ĩchab mʉ Aai ʉ̈gthar simuajã mʉg mʉ iek ʉ̈kha durrum khʉʉn chan ãbjã okhoopimapha simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mag nem khĩir pogkhe jajawagmamua, ’Pãrag khap amkhĩir jaaukhimgui ajim Jesuu. Pãachjö mʉ iek ʉ̈kha simua pãach ee iwiir ãbam dʉ̈i khãijã khaigba abaawai i dʉ̈i iyʉ̈ʉmamua wajapha irig jaaubat ajim, jãga sĩ mag khaigba aawai. Pãachdëu mag iekhabaawai ʉ̈u ũrwia ʉ̈khamʉn magan pãrau pãach khapeer mʉ athee gan atham ajim. ");
INSERT INTO noaE_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mamʉ par pãachdëu iekha nʉmjã ũrbamʉn magan pãach daumaai õor numí khãijã thʉ̈rkha athat, maagwai iekhamamjã õor numí wa thãrjup nʉm dakhĩirta mag iekhamamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mag numí wa thãrjup nʉm dakhĩir iekhamamta bʉ̈ʉrjã asekasbamʉn magan warre thum chi ʉ̈kha nʉm khʉʉn jʉ̈gdaarta iekhaju aai nʉmgui ajim. Mag thumaam khʉʉn dakhĩir iekhabarmjã asekasba abaawain chadau, Ẽwandam iek ʉ̈khaba aajemjö wa Romaam gobierno dën dëbpaar jëeujem khʉʉn chi khaigbam khʉʉn dʉ̈ímjö abat ajim am dʉ̈i, tag pãach dʉ̈i khapeerkhapiba. ");
INSERT INTO noaE_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Mag mʉig eegar aawai amach jʉ̈g theeg gaaimua pãachdëu nem jaau nʉm ũrba aawai mag pãach dʉ̈i khapeerkhapiba abarmjã ich Ẽwandamau ĩchab pãar igar sĩeju. Maimua deeu ich khaibag isegwi ũwaai pãach ee pãach khapeerkhapi aauwaijã ĩchab Ẽwandamau pãar igar sĩejugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mag iekhamamua, ’Mua pãrag mag chirʉmgui ajim: Mʉig eegar õor numí amachdëu nem ig nʉm mʉrʉg jëwaag ãba ibëpwia jëeumʉn, mʉ Aai ʉ̈gthar chirʉmua amag deeb khaba deeju. ");
INSERT INTO noaE_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mag jëwaagta numí wa thãrjup khãijã ãba biirdʉnaa mʉrʉg jëeu nʉmʉn mʉʉn maig chirʉmgui ajim, am jãrr. ");
INSERT INTO noaE_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Magbaawai Pedroou Jesuug, —Señor, magan mʉchjö pʉ iek ʉ̈kha nʉm khʉʉnau ãbmua khãijã mʉ dʉ̈i khaigba aawai, ¿biek kharr mua perdonaajuma? a jëeujim. ¿Siete veces? ");
INSERT INTO noaE_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Magbaa Jesuu irig, —Mag siete vecespai khabam. Muan pʉrʉgan, setenta veces sieteta perdonaaju aai sim a chirʉm ajim. Ajapcharan dich dʉ̈i khaigba abarmpierrma. ");
INSERT INTO noaE_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Maimua ich Jesuupai magjim: —Mua mag pãraujã pãach khapeen perdonaaju aai nʉm a chirʉmʉn, Ẽwandamaujã maach perdonaabam aba aajeewaita mag jaau chirʉm ajim. Ẽwandaman rey ãb sĩerrau ich chognaan ich garcharam khʉʉn wajapha phidkha nʉm khap aag ããbdö thʉ̈rkhanaa khap jëeu oomatarrjöta sĩerrʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ya chi reíu thʉ̈rkhʉʉibaadëm ee i aig aibëejierram aajem, ãb irig phatkhon pöm diez mil talentos paar sĩerr. ");
INSERT INTO noaE_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mag dëbpaar pöm sim pöd ichig phag auba abaawai chi reíu mag woun ichig dëbpaar paar sĩerrta warag ich ʉʉi dʉ̈i ich chaain maimua ich nem wai sĩerrpa thum përpʉ̈ipi jaaujim anaabá, jũrr deeum chogkhamkhĩir, magbarmua chi dëbpaar phag öbërmkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Magbaawai chi chogau chi rey bʉ̈khʉrr phõbkhanaa chaigpa jöchkhërʉmua, “Señor, idëu oo athá. Mua ökhar phagmamua pʉ dëbpaar thum öbeerpʉ̈ibajupa” aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pari mag ichig chaigpa jöchkhërʉm oobaawai, chi reíu i dau aug khaugwi, mag dëbpaar pöm sĩerrjã tag ichig phagpiba, sĩi warag khĩir okhoopi jaaunaa, phãarju arrjã phãarba, sĩi ʉ̈u mapijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Pari mag ich pʉ̈ibapäaiwai, maigmua igbaadeeu, deeum agjö chi rey chogkha sim dʉ̈i thẽujim aajem. Magua jũrr ichig cien denarios paraa sĩerr aawai, pʉrnaa ö thathaikhamuata, “Jöpkhaa pʉchdëu mʉrʉg paar sim phagbá” ajim anaabá irig. ");
INSERT INTO noaE_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pari magbaawai ichdëu reíg atarrjö warmuajã i bʉ̈khʉrr phõbkhanaa chaigpa khitʉmua, “Pua khõs akhiin, idëu oo athá akham; ökhar phagmamua mua pʉ dëbpaardam thum phagpʉ̈ibajupa” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pari chi dëbpaar jëeu sĩerr garmua mag khõchkhaba, sĩi warag ich khapeer dau augjã khaugba cárcel deg pʉ̈iwia, ãbmiecharam centaaudam phagbam aigjã öbeerpiba jaaujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mag irua ich khapeer dʉ̈i magtarr oowi, warm khʉʉn agjö chi rey chogkha thʉnarr khʉʉnau oowai, am gaai masi ajim aajem. Mag gaai masi nʉm iekhau chi reígcha magtarr thumaa wajapha ũrpipʉ̈ijierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mag ichig jaaubaa chi reíu thʉ̈rpʉ̈iwia irig magjim anʉm: “Wounta chadcha khaigba chitʉmá” ajim anʉm. “Maachig dau aphʉʉ chaigpabaadeewai, mua pʉ perdonaawi chi dëbpaarjã tag mʉchig phagpiba ich jãg khĩir okhoopijim. ");
INSERT INTO noaE_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Magtarr aawai puajã agjö pʉch khapeer dau aug khaugwi i perdonaaju aai sĩejimgui” ajim anʉm. “Pari pua bʉ̈ʉrjã i dʉ̈i magbajimgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mag, warag chi rey meeukhabaadëwi mag dëbpaar sĩi khĩir okhoopiju atarrta deeu eeupemjö thumaa phagpi jaaujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mag nem ĩgkhaadam jaauwi deeu ich Jesuupai magjim: ’Mʉ cha iekha chirʉm iekhau pãrauta pãach khapeendam chadcha perdonaawi tag magʉm iekjã igba ich mag khĩir okhoobam chan, mʉ Aai ʉ̈gthar chirʉmuajã ich agjö pãar perdonaabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mag marag nem jaau sĩi awi, Galileamua mawia jũrr Judea sĩeimajim, Jordán igaau thoogar dʉrba edau öbeerjem bi gar. ");
INSERT INTO noaE_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mag i petamjã õrau khaugpʉ̈itarr aawai õor pöoma i ẽudee wëtjim. Mag õor pöm thʉnʉm ee aaunaan khapan thʉnarr aawai magʉm khʉʉnpa monaaupʉ̈i maajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mag nʉm ee fariseonaan eem khʉʉn ich Jesús aigcha bëewi juau ogthom irig, —¿Pua oowai sĩi nem bʉ̈ʉr abarm gaaimua maadëu dich ʉʉi pʉaju aai nʉ? aichëjierram. ");
INSERT INTO noaE_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Magbaawai Jesuu amag magjim: —Ẽwandam iek phã sim gaai thʉ̈ʉrwai, ¿pãrau ooba aajẽ, warrcha chi ompaatarr Jöoiraujã emkhooi ʉʉi dʉ̈ita ompaajim a sim? ");
INSERT INTO noaE_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Magtarr aawaita emkhooi ich ʉʉi dʉ̈i pabaadëmʉn ich dënnaan kha ogdʉajem, ya ich ʉʉi dʉ̈ita ãba nʉrraag. Ya magbarm aigmua warran agdaujö amach appai naajerrta, õor ãbpaimjö ich mag nʉisiejemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mag nʉisim chan ya tag amach ããbdö nʉrrjëe aba, õor ãbpaimjö nʉisijugui ajim. Mag warrgarwejã ich Ẽwandamauta mag papitarr aawai pöd iwiir ãbmuajã i ichaaur awi dich õor pʉaju khaba nʉmgui ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Magbaawai jũrr amach garmua irig, —Pari pua mag simta, ¿khan jãgwi Moiseeu jaauwai dich ʉʉi pʉagpaawai ẽsap gaai “Mua ya pʉ pʉa chirʉm” a phãnaa irig deeju aai sim a simma? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Magbaawaita Jesuu amag, —Pari jã, nem jaauwaijã pãach jʉ̈g theeg sĩerrjëem gaaimua khabahab ajim. Moiseeun chadcha ʉdʉraa ʉʉin pʉapiejeejim, pari warrcha ich Jöoirau ompaawai chan mag pʉamkhĩir khabata ompaajimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pãadë mʉ iek ũrbat: Ʉʉi bʉ̈ʉrjã deeum dʉ̈i pʉrpʉr khaba simta sĩi pʉam khõchgaupai pʉawia deeum ʉʉi au simʉn maan pekauta wau simgui ajim. Mag ich ap sim awi chikhamnau pʉatarr ʉʉita au sim wounjã pekauta wau sim, agtha chikham ʉʉikha simta au sĩewai ajim jũrr amag. ");
INSERT INTO noaE_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Magbaawaita maach eem khʉʉnaupai ãaur khʉʉnau jũrr, —Maach emkhooin dich ʉʉi dʉ̈i magta aju aai nʉm khai, magan warag ʉʉi aubajuuta simgui ajierram. ");
INSERT INTO noaE_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Magbaa jũrr ich Jesuu marag, —Thumaam khʉʉnau chan cha mua jaau chirʉm iek pöd khaugbam; ãba ich Ẽwandamau khaugpi sim khʉʉnaupaita khap ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maimua, Pãrag jaaukhimgui ajim, jãgwi mag thumaam khʉʉn pöd ʉʉi auju khaba nʉ. Ãaur khʉʉn bi eeweta mag ʉʉin awaag khaba thaaba nʉmgui ajim. Pogkha ya chi jöoin pawiajã phãrr japʉ̈i nʉm, khapes apimaaugau. Maagwai pogkha mag phãrr jaba nʉmta, pari amachdëupai Ẽwandamau nem jaau sim wajapcha wawaag awi, bʉ̈ʉrjã khapes aba ich mag thʉnʉmgui ajim, ʉʉinjã khĩirjuba. Mag jaauwi ãbmiecha paawai ichdëupai magjim: ’Dichdëu oowai ʉʉijã chukhu chitaju ʉ̈u pödjöjöo sim khai, magan ich magta nʉrraju aai simgui ajim, ʉʉi chukhu. ");
INSERT INTO noaE_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mag nʉm ee, jũrram khʉʉnau Jesús aig chaain aibëe thʉnaajim, am gaai pʉrnaa Ẽwandamag am kõit jëeumkhĩir. Pari mag jũrram khʉʉnau chaain aibëbëekham oowi chi aibëe nʉm khʉʉnagta maachdëuta meeukha naajim, tag aibëepimaaugau. ");
INSERT INTO noaE_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mamʉ mag marau iekha nʉm ũrbaawai Jesuu jũrr maachigta, —Idëu mʉ aig chaain aibëepibat. ¿Khanthee pãrau am bëepimapha nʉ? ajim. Chi jöoin awiajã, chamʉ khʉʉn chaainjö mʉ iek ʉ̈khakharrsö ʉ̈kha nʉm khʉʉnta mʉg jẽb gaaijã ʉ̈u wënʉrrawi ʉ̈gtharjã onee wënʉrrabajup ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Magnaa warag am pör ʉ̈r jua ausĩunaa, Ẽwandamag am kõit jëeuwi, warag aigmua chawag maar phë arrjim. ");
INSERT INTO noaE_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Biek ãb woun ãb ẽwan sĩerrau Jesús aig bëewi i dʉ̈i iyʉ̈ʉmamua, —Maestro, ¿khan nem wajaphamta mua wauju aai chirʉ́ ʉ̈gthar öbëraag? Mʉrʉg jaaubá ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Magbaawai Jesuu irig, —¿Khanthee mag nem wajaphamta wawaag pua mʉrʉg jëeu chirʉ́? Nem wajaphamʉn ãba ãbpaita sim; ma Ẽwandamau. Mamʉ pʉ chadcha ʉ̈gthar öbërm khõs chirʉm khai, Ẽwandamau ich iek phãnaa Moiseeg deetarr gaai jaau sim ipierraa abá ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Magbaa, —Pari ag gaai jaau sim eem, ¿chijãg igwiata pua mag jaau sĩ? ajim, chi ẽwan mag i dʉ̈i iyʉ̈ʉ aan berrau. Magbaa Jesuu irig magjim: —Oob õor thõo chitam; oob pʉch õor khabam dʉ̈ijã khapes a chitam; nem jĩgkham; sëukhajã chikham ëugar nem jaau chitam; ");
INSERT INTO noaE_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pʉch aaijã daupiinaa pʉch ãdjã daupii abá, maimua pʉch khapeenjã wir aig pʉchdëu pʉch khõsi simjö daupii abá ajim ich Jesús garmua. ");
INSERT INTO noaE_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Magbaawai chi ẽwanau, —Mua magʉm thum ʉʉrkha chitabahab. ¿Khani mua wauju agtha waaur chirʉ́? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Magbaawai deeu ich Jesuupai irig, —Pʉ chadchata wajapcha am khõsi chirʉm khai, pʉch nem përkhʉʉipʉ̈inaa chi phatkhon aphʉʉm khʉʉndamag jigbapʉ̈i ajim. Mag khaita ʉ̈gthar pawiajã pʉ ich mag nem wajapham paraa chitaju. Mag përkhʉʉipʉ̈inaa jigpʉ̈iwi, mʉ dʉ̈i marrau ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pari ich mag woundam chadcha phatkhon paraam arr aawai Jesuu ichig magbarm ũrwia warre ökhĩirjuu petajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mag woundam ökhĩirjuu petam oobaawai jũrr maragta ich Jesuu, —Phatkhon paraam khʉʉnta Ẽwandam chi Pörkha sim aar öbëraagan chadchata thethe simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Phatkhonpanta ʉ̈gthar Ẽwandam chi Pörkha sim aar öbërju khãyau, camello pöm jãg maach wounaan khãaijã ʉ̈rpai sĩerrʉmta phithurg chukhu nobeeu kach ee thoogar öbër dichjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mag i iekhabapʉ̈im ũrwia chadcha jʉ̈gderraa nʉmua maach i dʉ̈i wënʉrraajerr khʉʉn eem ãaur khʉʉnau, —Mag khai, magan ¿khaita peerdʉagáwa? anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pari magbaa ich Jesuu marag oonaa, —Õragan chadcha phithurgma mag ũurwai. Mamʉ Ẽwandamag chan bʉ̈ʉrjã phithurg chukhu simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jesuu magbaawai mag chi ẽwan phatkhon paraam dʉ̈i iyʉ̈ʉ narr khĩirjuwia, —Maraun chad pʉ dʉ̈i wënʉrram khõchgau maach nemdam wai narrjã khĩirjuba, sĩi thumaa phëpʉawi pʉ dʉ̈i ogdʉba wënʉrrabma. Mʉg pʉch dʉ̈i ogdʉba wënʉrrʉm jũrr ¿khandamta marau au durrajuma mʉg atag paawaijã? ajim Pedroou. ");
INSERT INTO noaE_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Magbaawai Jesuu magjim: —Cha mʉ iekha chirʉm iekhau mʉg durr jöoi edaujã dʉ̈i thum chi iiurig pawia mʉch chi Emkhooi Iewaa õor Pörkhaag khu juupjem wajappha khitʉm gaai oo chirsim ed, pãar mʉg mʉ ogdʉba mʉ dʉ̈i wënʉrraajem khʉʉnta mʉ jup chirʉm bigaau pörkhau doce nʉm gaai ohood ajugui ajim. Pãachdëuta mʉ dʉ̈i pãach ipaarmua jöoi Jacob khararr chaain doce narr khʉʉn ag chaain ewagam khʉʉnagjã khap jajaau aju, jãgaju Ẽwandamau am dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Maimua ar thum chi mʉ gaaimua wa mʉ iek jaaum khõchgau khãijã amach di, amach naamkhʉʉn, amach eeugpeen, amach aai, amach ãd, amach chaain wa sĩi amach jẽb khãijã khaugba pʉa nʉm khʉʉnagjã amach nem okhootarr khãyaujã ʉ̈r ag atcha deewi mʉch dʉ̈ita ich mag wënʉrramkhĩir mʉch aarcha phë aujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pari mag ed ãaur khʉʉn ar mʉig eegar aawai amachta chikham khãaijã ʉ̈rʉʉcha nʉm aajerr khʉʉnta ʉ̈gthar Ẽwandam aar paaukhaimaawaijã jũrr serbiibacha aajerrjöo nʉisijugui ajim. Maimua jũrr ar mʉ gaaimua chikhamnau serbiibag pheejerr khʉʉnta jũrr warm khʉʉn khãaijã ʉ̈rcha nʉisijugui a iekhamajim ich Jesuu, marag ũrmkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Mʉg atag mʉch iek ʉ̈kha durrum khʉʉnag amach phithur atarr jũrr mua nem deeju edan, woun ãb uvadö papau ich piyonnaanag nemjõ phierrtarr jũrr phagtarrjöta ajugui ajim. Mag wounau nacha piyón jẽraag edpherre õor jʉraan majim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mag mawi, chi nacha ooimatarr khʉʉn dʉ̈i iekhaawai, khãai ãb phidkhabarm paar phaagjemjö denario ãb phagju ajim aajem. Mag iekhawi phidkhamkhĩir pʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Maimua ya edau ʉ̈gtharraa las nuevejö aadëm ee, deeu õor jʉraan mawia kaaijã ee sĩi õor phidagjã chukhu par nʉm ooimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Magbaa makhʉʉnagjã, “Pãarjã ĩchab mʉ phidag ee phidkhabamit; mua pãrag pãach phidkhabarmpierr phagjugui” ajim anʉm. Magbaa makhʉʉnjã ĩchab phidkhaan wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Maimua edausĩe aadee, ich chi morkhʉ jöoiraupai deeu ũwaai õor jʉraan mawi, kheeuragjã las tresjönaa deeu ichpai majim aajem. Maimua makhʉʉn dʉ̈ijã iekhawi ich agjö phidkhaan pʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Maimua ya kheeuraacha las cincojö aadëm ee, deeu ũwaai nacha ichdëu õor ooimatarr aar majim aajem. Maimua ooimaawai sĩi õor phidagjã chukkhu aig naajim aajem. Magbaawai amag, “¿Khani jãg khëumaamta jãg sĩi phidkhajã phidkhaba, parta khëudʉtkhamaama?” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Magbaa amachdëu, “Marag ni ãbmuajã phidag jaauba aawaita mʉg maar par naabahab” ajierram anʉm. Magbaa jöoirau makhʉʉnagjã, “Magan mʉ nemjĩir ee uva phierrbamit” ajim anʉm, “khëu nʉm ora.” ");
INSERT INTO noaE_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Maimua ya edau khëubaadee chi uva papau ich chog mag õor phidag ee wai jẽer sĩerragta jũrr, “Jãimua phidkha narr khʉʉn thʉ̈rkha aunaa amag phagkhabá ajim anʉm. Ẽudeecha dubtarr khʉʉnagta nacha phagnaa maimua nacha dubtarr khʉʉnagta jũrr ẽudeecha phagbá” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mag, chadcha ẽudeecha kheeuraa las cincojö dubtarr khʉʉnta nacha thʉ̈rkha auwi khãai ãb phidkha khëutarr khʉʉnagamjö denario ããbdö phagkhamajim anaabá, agdaujö. ");
INSERT INTO noaE_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Maimuata jũrr nacha dubtarr khʉʉn thʉ̈rkha aujim aajem. Ya mag amach thʉ̈rkhʉʉibaadee, warm khʉʉnag mag denario ãb deematarr aawai, amaun jũrr amachigta ʉ̈r phagjupii naajima, amachta edpherre dubtarr aawai. Pari magba amagjã ẽudeecha dubtarr khʉʉnag phagtarrjöpai phagkhajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mamʉ amachig magpai phagbaawai khĩujã ãwatba, chi morkhʉʉgchata jũrr ãbmua, ");
INSERT INTO noaE_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Jãkhʉʉn ya maar öbëraagpam eeta bardʉtkhachëtarr aawai ora ãbpaita phidkhajierram. Magtarrta maar ed durr pöm phidkha khëuwi ed pechagjã jemer khëudʉtkhamaam khʉʉn dʉ̈i ãbata pua amag phagbarbma, jũrr amag erraapai phagju aai simta” ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pari magbaawai chi phidag khʉ jöoirau jũrr am eem ãbakhaíg, “Kakë pari warr maach iekhaawaijã, ¿denario ãbpaita pʉrʉg phagju abajĩ, pʉ phidkhabarm paar? Magtarr aawai mua pʉ khũgurba chirʉm perá” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Pʉch phatkhondam auwia petá” ajim anʉm. “Pari mua ichiita kheeuraacha dubtarragjã pʉrʉg phagtarrjö phagam khõsi chirʉmgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“Mʉch phatkhon aawai mʉchdëu phagam aig phagju aai chirʉmgui” ajim anʉm, “pöm phidkhaba arr khʉʉnag awiajã. ¿Wa sĩita pua mʉrʉg õor dʉ̈i ö wajapha apimaphata chirʉ́wa?” ajim anʉm chi phidag khʉ jöoirau. ");
INSERT INTO noaE_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mag nem ĩgkhaadam jaauwi ich Jesuupai, ’Ich jãgta ajugui ajim ĩchab mʉg atagjã. Ẽudeecha phidag ee dubtarr khʉʉnagta nacha dubtarr khʉʉnag phagtarrjö, ẽudeecha mʉch iek ʉ̈khatarr khʉʉnagjã nacha ʉ̈khatarr khʉʉnagamjö agdaujö nem deemaju. Maiguin Ẽwandam athee pöm nem wauba arr khʉʉnagjã warm khʉʉnagamjö phagmajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Maimua mag Jerusalenag mam arr aawai ya khʉd ee paaukhabaadee, ich Jesuu maar maach ap thʉ̈rkha auwi marag jaaumamua magjim: ");
INSERT INTO noaE_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Pãrau oo nʉmgui ajim, maach Jerusalenag wëtum. Mamʉ nau maach barbaimaawai mʉch chi Emkhooi Iewaa mʉg chirʉmʉn thethemnaanag mʉ pʉr deeju. Magbaawai makhʉʉnau mʉ thõopi jaauwi ");
INSERT INTO noaE_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jũrr maach meeun khabam khʉʉn jua ee mʉ thʉsĩepʉ̈ijugui ajim. Magbaawai makhʉʉnau mʉ wau iekhanaa mʉ gaai mas waunaa pakuls gaai mʉ meerphëpʉ̈ijugui ajim. Pari amau mag mʉ wau thõowiajã khãai thãrjup nʉm ee deeu mʉ iiu phiidʉju a jaaumajim maachigcha. ");
INSERT INTO noaE_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Maimua i iekha öbaadëm ee, jöoi Zebedeo ũan ich chaain dʉ̈i bëewi nem inag jëwaagpamjö Jesús khĩirphee phõbkha thʉnaaichëjim. ");
INSERT INTO noaE_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Magbaawai Jesuu irig, —¿Khandamta ig ʉ? ajim. Magbaa ich ũanau, —Señor, magan ya pʉchta thumaam khʉʉn Pörkhabaadeewai mʉ chaain mʉkhʉʉn numiita pʉch bigaau juppibá ajim, pʉch dʉ̈i iek theeg amkhĩir: ãb pʉch juachaar gar, maagwai ãb pʉch juawë gar, Santiago Juan dʉ̈i igwi. ");
INSERT INTO noaE_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Magbaawai Jesuu warre chi chaainagta, —Pãrau chan pãachdëu jëeu nʉmjã khaugbata nʉmgui ajim. ¿Pãrau khĩirjuawai mag pãachta warm khʉʉn khãai ʉ̈rpai aag chikhamnau pãach dau aug wau nʉmjã mʉ dënjö ãwatju aai nʉ? ajim amag. Magbaawai amachdëu, —Ëera, marau ãwatbajup ajierram. ");
INSERT INTO noaE_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Magbaa deeu Jesuu ichdëupai amag, —Chadcha pãrau õrau pãach dau aphʉʉ wau nʉm ãwatma ajim. Pari mag mʉch juachaar gar wa juawë gar khãijã mʉch dʉ̈i ãba juppiju chan mua pöd jaauju khaba chirʉmgui ajim, ya jãig paawain mʉ Ayauta ichdëu khap jaauju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Maach tagam khʉʉn agjö ich Jesús dʉ̈i ogdʉba wënʉrraajerr khʉʉnau ũurwai, mag warm khʉʉnau i bigaau jupimaag khãidu jëeu nʉm ũrbaawai, chadcha am dʉ̈i maar thãar ee khaba naajim. ");
INSERT INTO noaE_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pari magbaa deeu ũwaai maach appai khĩet thʉ̈rkhanaa marag magjim, ich Jesuu: —Pãrau khaphʉ nʉm, mʉig eegar ar amachta chi pörkha nʉm khʉʉnan amachta chi pörnaan aawai iek theeg nʉm awi amach khãai jua eegpaim khʉʉn dʉ̈i athuu aajerram. ");
INSERT INTO noaE_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pari jũrr pãrau am dënjö magju khaba nʉmgui ajim pãach eepai. Magju khãai ãbmua khãijã pãach eepai ichta thumaam khʉʉn khãaijã ʉ̈rʉʉ am khõsi sim khai, magan jũrr ich garmuata ich khapeenau nem mag abaawaijã am ipierr nʉnʉʉu aju aai simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Maagwai ar ichta ʉ̈gthar pawiajã Ẽwandamau ich garcha juppi ahau apim khõsi sim khai, magan ichta sĩi parhoobam khʉʉn chogkhaju aai sim ajim. ");
INSERT INTO noaE_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mʉ pãar khãai Emkhooi Iewaakha chirʉmjã mag sĩi mʉch garmua chikham chogaagjã bëebajim. Mʉ bëetarran sĩi chikhamnag mʉch chogamkhĩirta bëejimgui ajim, mag chitʉmua chikham jua machgau thõowi mag thõobarm gaaimua õor pöm sĩi amach pekau ee preso sĩsidʉmjö nʉm khʉʉn öbeerkhapäain. ");
INSERT INTO noaE_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mag wëtumua Jericó phöbör ee naaimawi, deeu ërëu phöbaadeeu, õor pöoma Jesús ẽudee wëtjim. ");
INSERT INTO noaE_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mag õor pöm wëtum khʉd bigaau dau khĩsu khithëem numí ohoodö durrajim. Mag durrumua Jesús dichmam khaug athaawai ääakhamua, —Señor, pʉʉta rey David khararr ag chaain ewagam khʉʉn Iewaau marau nʉ narr. Maar apdurrum maar dau aug khaugbahur anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mamʉ mag am ääakham ũrwia aig dich wëtum khʉʉnau amag meeurrarrau aajeejim, khĩupamkhĩir. Pari magʉmjã waragta Jesuug uhuukhamua, —Señor, jöoi David khararr Iewaa, maar apdurrum maar dau aug khaugbahur aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Magbaawai Jesuu dʉnʉisiwi mag chi dau khaugba khithëe arr khʉʉn thʉ̈rkhanaa, —¿Khani pãrau mʉrʉg pãach dʉ̈i apim khõsi nʉ? ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Magbaawai amachdëu, —Señor, maraun pʉrʉg maach dauta daujã wajaug paapim khõsi nʉmgui ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Magbaa chadcha Jesuu am dau aug khaugwi, am dauhëu aaithʉ aaithʉ abaawai, warre daujã wajaug sĩi bi eewe ich magta thaabatarrjö nʉisijim. Mag amach dau monaaubapäaiwai warag i dʉ̈i ërëubaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mag wëtumua ya Jerusalén dakha Olivo durrsĩ gaai deeum phöbördam Betfagé anʉm paaukhabaimaawai ich Jesuu maach ich dʉ̈i wënʉrraajerr khʉʉn eem numí thʉ̈rnaa amag, ");
INSERT INTO noaE_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Cha maach khĩirphee phöbördam sim ee ërëubaadët ajim. Nau pãrau burro chi ʉʉidam pabʉ̈ gaai jʉ̈ sim ooimajugui ajim. Ag bigaau ĩchab chi chaaidamjã sĩeju. Mag pãachdëu oobaimam ẽerwi aipidut ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mag pãachdëu ẽer waidurum oowi ãbmua khãijã pãachig iekhaawai irig, mua ig chiraawaita arrum, mamʉ deeu jöpcha deepʉ̈iju abat a jaaujim, chi mag ichdëu pʉ̈i sim khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pari mag burrodam awaan mamkhĩir ich khapeen pʉ̈itarran, Ẽwandam i jaaumie Zacarías khararrau phã pʉatarr eyaa öbërmkhĩirta magjim. Mag irua phãtarr gaai mag sim: ");
INSERT INTO noaE_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalenpienag jaaubat: ‘Pãrau warrgarwe nʉajerr Reita sĩi parhoobam khʉʉnjö khĩir machag chukhu burrodam agtha chi jöoicha khaba khitʉm gaaita ya pãar aig urum’ ” a phã sim. ");
INSERT INTO noaE_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mag amach chogbapäaiwai chadcha ërëubaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mag wëtwi ooimaawai, chadcha ich Jesuu jaautarrjö chi burro ʉʉidam ich chaai dʉ̈i ooimajierram anaabá. Maimua ẽer auwi, arrwi, ya ich Jesús sim aar pabaimaawai, amach khajũa ẽerkhanaa chi burrodam phõ gar theerkhabapäaiwai ag gaai Jesús waaidʉbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Maagwai õor pöm thʉnarr aawai, ãaur khʉʉnau i maju ee amach khajũa ẽernaa theerkhamaawai, ãaur khʉʉnau jũrr papiujöm thʉrrpnaa theerkhamajim. ");
INSERT INTO noaE_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Maagwain na wëtum khʉʉnaujã serereu khaawai ẽudee wëdurum khʉʉnaujã serereukhamua, “Ʉ̈ucha abarm Ẽwandam. Rey David khararr ag iewaajöm chan chukhukhum” aajeejim. “Ẽwandam, ich mʉʉta pʉchdëu pʉch jũrr pʉ̈ibarmʉu. Mʉg Rey pʉ̈ibarm gaaimua ʉ̈gtharm magwe onee aju aai nʉm” aajeejim jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mamagag wëtumua ya Jerusalén ee Jesús dubbaimaawai sĩi phöbör ee õor thumta phogdʉbaadëmjö ajim. Magphöbaadëmʉn jũrram khʉʉnau amach eepai, —Keena, jãan ¿chijãg wounta jãg urúma? aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Magbaawai mag i dʉ̈i õor pöm wënʉrrʉm khʉʉnau, —Ẽwandam i jaaumie Jesús khabahab aajeejim, Galilea durr Nazaret phöbör ee bãautarr. ");
INSERT INTO noaE_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mag barwia Aai i jëeujem deg ooimaawaijã, sĩi merrkau eemjö thʉnʉmta ooimajim. Magbaa mag ag ee Ẽwandamag ofrendakha deeg nem për nʉm khʉʉn dawag jʉrkhʉʉipʉ̈inaa, phatkhon cambienaa dubur për nʉm khʉʉn mesjã jẽkhʉt sĩepʉ̈imajim. ");
INSERT INTO noaE_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Magnaa amag, —Ẽwandamau ich igwia ich iek phã sim gaai “Mʉ diin sĩi mʉrʉg jëeujem diiu” a simta, pãachdëuta ag ee mʉg nem parhẽpag për nʉmua sĩi chikham khũguurjem dikha wai naabma ajim. ");
INSERT INTO noaE_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mag õor dawag jʉrkhʉʉipʉ̈iwi, ichta ag ee sĩsiewai, dau khaugba khithëem khʉʉn dʉ̈i bʉ̈ wëdʉ wëdʉ khithëem khʉʉnpa ich aig bëemam Jesuu monaaupʉ̈i maajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mamʉ mag irua õor monaaupʉ̈pʉ̈ikham phadnaan chi pörkha nʉm khʉʉnau Moiseeu ley phã pʉarr jawaag chi machnaan dʉ̈imua amach daúacha mag irua õor monaau sim oo nʉm dʉ̈i, chaainaupa i thö iekha nʉm iekhau “Rey David khararr ag Iewaajöm chan chukhukhumkham” ũrbaawai, ");
INSERT INTO noaE_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","meeukha nʉm iekhau khĩir mor chigpai chi Jesuugta, —¿Mag serereukham khʉʉnau iekha nʉm pua ũr chirʉ́? ajierram irig. Magbaa ichdëu, —Muakha ũr chirʉmgui ajim. Pari pãrau Ẽwandam iek phã sim gaai thʉ̈ʉrwai ooba aajeeb, amau mag serereu aju igwi David khararrau, “Chaain daumeraam khʉʉn dʉ̈i agtha jũd dö khithëem khʉʉndamaupa irig jëeujem” a phã pʉatarr. Ma chan pãrau bʉ̈ʉrjã khĩir ee paba naabma ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Magnaa warag ichta aigmua mawia jũrr ag dakha phöbördam Betania anʉmʉg petajim. Mag mawia ich mam warag khãi ëejim. ");
INSERT INTO noaE_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mag mam khãi ëewi deeu edpherre Jerusalenag urumua Jesús iek i jãsöo aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mag i jãsog thʉnʉm ee, khʉd bigaau igo bʉ̈ dʉnʉm oo athaawai ag gaai chi jõ simpii awi aar oon majim. Mamʉ oon maawai sĩi bʉ̈ parii dʉnaajim. Mag ag gaai ooba abaa pabʉ̈ʉgta wounagamjö, —Pʉ jãg sim khai, jãgan mʉg atagjã ich jãg chëba sĩerrajugui ajim. Pari irua mag iekhabaawai chi igo bʉ̈ warre phuabaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Maachdëu mag oobaawai dauderraa nʉm iekhau marau irig jëeu naajim, jãga jãg warre dëgölpta jãg phuabaadë. ");
INSERT INTO noaE_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Magbaa ichdëu marag magjim: —Pãrau pãachdëu Ẽwandamag jëeuwaijã pãachdëu jëeubarmjö aju khĩirjunaata jëeukhiin, mua mʉg pabʉ̈ phuapibarmjöpaijã khaba, ag khãai phithurcharam nemjã wauju. Jãgkhiin pãrau mʉg Olivo durrsĩigjã, “Mʉigmua mawia jũrr phũas ee ierrpabaad” akhiinjã, chadcha pãachdëu iekhabarmjö ajugui ajim, pãar ipierr. ");
INSERT INTO noaE_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mag pãachdëu jëeubarmjö aju khaphʉnaata pãach nem jëeuwaijã jëeumʉn, pãachdëu jëeubarm nem pãrau paarpaju a jaaujim marag. ");
INSERT INTO noaE_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Maimua bëewi deeu Jesús Aai i jëeujem deg dubchëjim. I maig õrag Ẽwandam iek jaau sim ee, phadnaan chi pörkha nʉm khʉʉn dʉ̈i judionaan Asamblea eem chi pörnaan i aig bëewi irig jëeuchëjierram: —¿Khai thöwiata jãg mʉig nem për narr khʉʉn pua dawag jʉr wërppʉ̈ijĩ? ¿Khaíuta jãg pʉrʉg pʉchta nem iek theeg apijĩ? Marag jaaubá ajierram. ");
INSERT INTO noaE_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Magbaawai jũrr Jesuu amag, —Magan nacha mʉrʉg jaaubat, muajã ĩchab pãrag jëeu ookhimgui ajim: Mua jëeubarm pãrau mʉrʉg jaaumʉn, magan muajã pãrag jaaujugui ajim, cha pãachdëu mʉrʉg jëeu nʉm. Magnaa chadcha amag, ");
INSERT INTO noaE_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Pãrau oowai, ¿khaíuta Juan pʉ̈ijĩ ajim, jãg amach khaibag Ẽwandamag chugpaapi jaaunaa õorjã pör choo nʉrramkhĩir? ¿Ẽwandamau ajĩ, wa sĩi mʉg jẽb gayam khʉʉnau chogpʉ̈iwiata jãg nʉrrajĩwa? ajim. Magbaa amach appai iyʉ̈ʉ nʉmua, —Maadëu irig, “Ẽwandamauta pʉ̈ijim” akhiin, magan jũrr irua maachig, “¿Jãg magʉmta pãrau irua jaau nʉrrarr iek ʉ̈khabajierráma?” aju. ");
INSERT INTO noaE_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pöd maadëu, “Õrauta pʉ̈ijim” ajujã khabamgui ajierram. Maadëu magkhiin thumaam khʉʉnau i igwia “Jãan chadcha ich Ẽwandam i jaaumieta jãg nʉrrajim” aajeewai, eeu dëgölp õrau maach mokou bar thõodukhamgui ajierram. ");
INSERT INTO noaE_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mag warag irig jaaujujã khaugba aawai, —Marau pöd jaauju khaugbamgui ajierram. Magbaawaita ichdëu amag, —Mua pãrag nem jëeutarr pãrau mʉrʉg jaauba aawai muajã pãrag jaaubamgui ajim, khai thöwiata mua jãg nem wau chitʉ́. ");
INSERT INTO noaE_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mag ichig jaauba abaawai mʉg nem ĩgkhaadam jaaujim: —Woun ãb chaain numí wai sĩejim aajem. Biek ãb chi jöoirag, “Iewaa, ĩs mʉ uvadö ee phidkhabamí” ajim anʉm chi ayau. ");
INSERT INTO noaE_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Magbaa chi iewaau, “Mʉ mamapha chirʉmgui” ajim aajem. Maimua khĩirju sĩi awiata, “Magan mʉ majugui” awia majim aajem, phidkhaan. ");
INSERT INTO noaE_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Maimua jũrr ich iewaa chi ẽudeemʉgjã ich agjö phidkhaan mamkhĩir jaaujim aajem. Magbaawai maguan chadau khõchag, “Magan mʉ phidkhaan majugui” ajim anʉm. Pari mag maju atarrta chadcha mabajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mag nem ĩgkhaadam jaauwia, aig ũr narr khʉʉnag jũrr, —¿Chijãgua pãrau oowai ich ayau khõsi sĩerrjö i ipierraa ajĩ? a jëeujim ich Jesuu. Magbaa, —Chi iewaa chi jöoirau ajierram, chi cuento ũr narr khʉʉnau. Magbaa deeu ich Jesuupai iekhakhagmamua, —Roma durram gobierno athee dëbpaar jëeujem khʉʉn chi khaigbam khʉʉnta ʉʉin amach durpa theegau parhooba sĩerrjëem khʉʉn dʉ̈i pãar khãai ʉ̈gtharcha öbërjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","¿Jãgwi mag chirʉ́? Juan chi õor pör choomieu, jãga Ẽwandam dau na wënʉrraju aai nʉ a jaaumam ũrwi pãrau ʉ̈khabam daar, amauta pãar khãaijã ʉ̈khatarr aawaima. Pari pãrau magba irua jaau nʉrrʉmjã ũrnaa irua nem waaujerrjã pãach daúacha oojerrta, pãach khaibag khĩirjuwia Ẽwandamagjã chugpaapi jëeubajierramgui ajim amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Maimua ich Jesuupai, ’Ũrbat, deeum nem ĩgkhaadam pãrag ĩgkhakhimgui ajim. Maimua ĩgkhabaadëmua magjim: ’Woun ãbmua uvadö jĩirjim aajem. Mag jĩirwi, ag igaau thuur phʉʉrdʉpʉ̈iwi, chi uva chö piirjʉujujã waunaa, didamjã nasãdjö ʉ̈gthaa ëu dʉnʉʉujim aajem, ag gaaimua warp dawaa oo phʉʉrdʉdʉ aag. Mag thum wajapha wau sĩunaa, chawag mam khõchkhabaadeewai, chi nemjĩirdö deeum khʉʉnag alquilaapʉ̈iwia, ichin jũrr deeum durr warp petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maimua ya chi uva waaubaadëmcha khĩirjunaa jöoirau ich chognaan pʉ̈ijim aajem, ich paatëm agjö ich athee deepʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pari mag chi chognaan amach aar bardʉtkhabaimaawai, chi uva thʉa narr khʉʉnau pʉrphöbaadëwi, ãaur khʉʉn gaai sĩi mas waunaa, ãaur khʉʉn warre khëchpʉ̈inaa maimua pogkha mokoujã barmaajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Magbaawai deeu jöoirau jũrr khapanaa pʉ̈ijim aajem. Pari makhʉʉnjã amach aar barpinaa chi nacha bëetarr khʉʉn dʉ̈i arrjöo ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Maimua ya ãbmiecha paawai jöoirau ich chaai pʉ̈ijim aajem. I khĩirjugan ich chaai aawai i ögkhaju awiata pʉ̈ijiebma. ");
INSERT INTO noaE_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pari warm khʉʉnau mag i ögkhajujã khĩirjuba, sĩi warag amach aar barpinaa, “Keena, chamʉʉta chi iewaa aawai mʉguata mʉg atagjã jũrr ich aai nemjĩir jʉ̈aju khabahab” ajierram anʉm. “Jãg sĩpí warre maadëu i thõopʉ̈iju, mʉg uvadö jũrr maach dënkha awaag” ajierram anʉm, amach appai. ");
INSERT INTO noaE_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mag, chadcha khapanaam khʉʉnau pʉrphöbaadëwi chi nemjĩirdö chaaur warp arrnaa thõopʉ̈ijierram aajem, ich jöoi iewaa ãba. ");
INSERT INTO noaE_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mag jaaunaa jũrr ich iek ũr narr khʉʉnagta, ichdëu nem ĩgkhatarr igwi, ’Pãrau khĩirjuawai ĩsjã agtha mag uvadö sim anaa chi thʉa narr khʉʉnjã ich akhʉʉnpai akhiin, ¿jãgaju khai jöoirau magʉm wounaan dʉ̈i? a jëeujim Jesuu amag. ");
INSERT INTO noaE_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Magbaa amachdëu, —Mag amach khaibag sĩsidʉm paar amachdëu warm khʉʉn dʉ̈i aajerrjö amach dënjö am dau aug khaugba, irua agjö am khëchpʉ̈ijuuta. Magnaa jũrr chadcha ichig phagju khʉʉnagta irua alquilaa pʉajugui ajierram, ag jaar paawaijã chi nemjõdam ichig ich paat deemkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Amachdëu magbaawaita Jesuu amag magjim: —¿Pãrau chan bʉ̈ʉrjã Ẽwandamau ich i jaaumienag ich iek phãpitarr gaai jaau sĩsidʉm thʉ̈ʉrwai ooba aajeeb, “Di ëu narr khʉʉnau isegtarr dibigta jũrr chi dihãd jãrramkha sĩsim” a sim? “Ẽwandam maach Pöröuta mag dibig wajaphamjö api sĩewai õrau oowaijã ʉ̈uuta oo nʉm” a sim, ich iek gaai jaauwai. ");
INSERT INTO noaE_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Magua mua pãrag mag chirʉmgui ajim: Ẽwandam pãar thãar ee ichta chi Pörkhaju atarr chi Pör khaba, deeum khʉʉn judionaan khabam khʉʉn ichdëu khõsi simjö nem wauju khʉʉn dʉ̈ita am Pörkhaju ajim.  ");
INSERT INTO noaE_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Maimua mag mua dihãd a chirʉmjã mʉch igwiapaita mag chirʉmgui ajim. Chi mʉ iek ʉ̈khaba sim wounan, juau ogthom mag dibig ʉ̈r burrwi ichdëupai ich gaai mas wau simjöta sim; maimua mag ʉ̈khaba nʉrrʉmta meemʉn, jũrr mʉ mag dibig pömaamjö chirʉmta i ʉ̈r buudimamjö ajugui ajim. Jesuu mag sĩerran mag i iek ʉ̈khaba sim meebaadeewai warre khĩmie durr barpʉ̈ijuuta jaau sĩejim. ");
INSERT INTO noaE_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mamʉ mag irua jajawagmam ũrwi phadnaan chi pörnaanau Moiseeu phã pʉatarr wajapcha ʉʉrkhaajem khʉʉn dʉ̈imua khaug athajierram, amachdëu ich iseg nʉmta jaau sim. ");
INSERT INTO noaE_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mag amach khĩir iekha simta khaug athaawai jũrr ichta pʉr arram khõchkha phöbaadëjim. Pari Jesuu chadcha Ẽwandamau nem jaaupi simta jaau nʉrrʉm thumaam khʉʉnau khaphʉ narr aawai amachta jũrr khaigbaju khĩirjuwi i chig abajierram. ");
INSERT INTO noaE_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Maimua deeu nem ĩgkhamamua õrag nem jaaumamua magjim: ");
INSERT INTO noaE_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ẽwandamagta amach thãar ee ichta chi Pörkhapi nʉm khʉʉnan, rey ãb simua ich iewaa jua pʉrmkhĩir phiesta wautarr ee õor bëetarr khʉʉnjöta nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mag phiesta ee bëemkhĩir ya õrag jaaukha thʉnarr aawai ag ed pabaadee chi reíu deeu ich chognaan pʉ̈ijim aajem, mag bëeju arr khʉʉn aar jaaubathuurwai bëemkhĩir. Pari mag jaaubathurmjã bëebajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Magbaawai jũrr deeum khʉʉn pʉ̈iwia amag, “ ‘Thachin ya sĩi khöjupaita sim, mʉch nemchaain õtpaa wai chirarr khëch auwi aata wau thʉnʉm; jua pʉr nʉm phiesta ee wëttarrau’ a jaaubat” a jaaupʉ̈imajim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pari par mag deeu iek jaaupʉ̈itarrjã bëebajierram anaabá. Mag chi bëeju arr khʉʉn eem ãaur khʉʉn warag amach nemjĩir oon ërëubaadee tagam khʉʉn pogkha amach phidag ee wëtjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Maimua ãaur khʉʉnau warag mag chi rey iek jaau wënʉrrarr khʉʉn pʉr aunaa parhooba am gaai mas waunaa warag khëchpʉ̈ijierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Magbaawai chi reíu khĩir machgau ich soldaaunag mag ich chognaan khëchtarr khʉʉnjã agjö khëchpi jaaunaa am phöbörjã warre örpi jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Maimuan chadau deeu ich chognaanag, “Nemen thum khĩir khaug thʉnʉm, jua pʉrju phiesta athee; pari chi thʉ̈rpʉ̈itarr khʉʉn chadcha chi bëeju khʉʉn khaba arr aawai am bëebajierramgui” ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Jãgan jãgbarpí kaaijã ee wëtwi mʉ chaai jua pʉr nʉm phiesta ee bëemkhĩir, thum pãachdëu oomam khʉʉnag jaaupetat” ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Magbaa chadcha chi chognaan wëtwi kaaijã ee amachdëu oomam khʉʉn thumaa aibëejierram anaabá, õor wäjäaun dʉ̈i chi khaigbam khʉʉnpa. Deg pachënaa oowai sĩi dijã pöm simta õrau phẽu wëjoojim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Maimua mag õor thumaa deg paaukhapinaa chi reíu oon maawaijã, bëe nʉm khʉʉnag jũamkhĩir awia irua khajũa phëderrjã jũaba, woun ãb ag ee sĩerrau sĩi parhoobam khajũata jũa sim ooimajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Magbaawai chi reíu irig, “¿Pʉ jãga jãg warm khʉʉnjö phiesta eem khajũa jũaba simta mʉig dubjĩ?” ajim anʉm irig. Pari magʉmjã bʉ̈ʉrjã i iek jʉ̈ʉ aba, ichig khabamjö sĩsijim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mag par jëeu ahaukhamjã ich iek ʉ̈khaba abaawai mes gaai thëp paa narr khʉʉnagta, “I bʉ̈ dʉ̈i juapa bʉʉrnaa daaugajãr khĩchag ee barbapʉ̈it” ajim anʉm chi reíu, “i gaai wajaugau icharaucha bĩenaa ich mag agäa agäa sĩerramkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mag nem ĩgkhaadam jaauwia ich Jesuupai, ’Ʉ̈gthar öbërjujã mag phiesta ee õor pöm thʉ̈rkhʉʉiwia khapan khaba bëetarrjöta sim ajim. Ẽwandamaun ich aar õor pömta wëtpim khõsi sim, mamʉ chi chadcha öbërju khʉʉn chan khapan khabata durrumgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pari mag irua nem ĩgkha sim amach jʉ̈gaagaa khaba aawai fariseonaan amach ap iekhawi ibëpjierram aajem, jãga Jesús ich iekha sim gaaimuapai imeraa pʉr awaag awi irig jëeucheeg. ");
INSERT INTO noaE_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mag ya ibëpwi narr aawai amach ee amach igar narr khʉʉn eem pʉ̈ijierram, deeum khʉʉn agjö chi rey Erodes igar narr khʉʉn dʉ̈i. Mag amach pʉ̈ibaawai bëewi magchëjierram: —Maestro, marau khaphʉ nʉm, pua chadcha ag eyaata nem jaaunaa ĩchab jãgata aju aai nʉ a jaaujem, Ẽwandamau nem jaau sim eyaa wënʉrraag. Pua chan sĩi õrau amachdëu nem jaaum aig nem jaau nʉmʉgjã pʉch khũgurpiba wa sĩi pʉchdëu oowai magjöo abaawai ag bʉ̈rre sĩi magau aba aajem. ");
INSERT INTO noaE_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Magua marau pʉrʉg jëeum ig nʉm: ¿Pua oowai chadcha maach meeun judionaanaujã durrpierram khʉʉn rey Roma sĩejemʉgta impuesto phagju aai nʉ, wa phagju khaba nʉ? aichëjierram irig. ");
INSERT INTO noaE_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pari Jesuu ya mag am ibëpwi khĩirju nʉmjã khaphʉ sĩerr aawai jũrr ich garmua amag, —Pãraun pãach khaugbampii naabma, ¿khanthee pãrau jãg mʉ imeraa pʉr auju ẽkha nʉma? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Magnaa, Mʉrʉg oopibat ajim, khaniuta pãrau dëbpaar phaagjẽ. Magbaa irig phatkhon denario anʉm ãb oopijierram. ");
INSERT INTO noaE_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mag ichig denario ãb oopibaawai, —Pãrau oowai, ¿khai khĩirta khai thʉ̈r dʉ̈i ag gaai sĩ? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Magbaa amachdëu, —Romaam rey César khĩir khabahab ajierram, ich thʉ̈r dʉ̈i. Magbaawaita Jesuu amag, —Mag khai magan reíg ich paat deenaa Ẽwandamagjã agjö ich paat deebat ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Amachig mag iekhabapäaiwai sĩi jʉ̈gderraa nʉm iekhau warag amachta khĩu ërëubaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ich mag edcha ĩchab saduceonaan eem khʉʉnjã agjö Jesús aig bëejierram. Mag saduceonaanau jaauwai, maach meebaadëm chan maach akhaar tag iiuba aajem aajem. Amach mag nem jaau sĩerrjëem gaaimua, iyʉ̈ʉmamua juau ogthom irig magjierram: ");
INSERT INTO noaE_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, jöoi Moisés khararrau Ẽwandam iek phã pʉarr gaai jaauwai, woun ãb ʉʉi wai simta chaaijã chukhu meemʉn, magan mag chi meetarr khod ãbam wai sim khai, magua ich khojaau auju aai sim a sim, ag dʉ̈i ich naamʉu chaain ooba arr aawai jũrr i athee oo deeg, mag oo deebarm i chaainkha nʉisimkhĩir ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Maimua amachdëupai warag irig nem ĩgkhamamua magjierram: ’Biek ãb mʉig maach meeun ee emkhooin siete naajim aajem, ãbam khod appai. Am naam chi nacharamua ʉʉi auwia chaaijã chukhu meejim aajem. Magbaawai ag ẽudeemua ich khojaaupai wir aig aujim aajem, ich naam thʉ̈r okhoopimaaugau awi. ");
INSERT INTO noaE_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pari majã pöd ag dʉ̈i chaai ooba meejim aajem. Ich mag ewagam khʉʉnjã ãbam ʉʉiraupai warm meemam ẽudee theg ahaugmamua mag siete narr thum thegdʉpʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Maimua ya ãbmiecha paawai chi ʉʉijã meejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mag ãbam ʉʉiraupai ãbam khod appai siete phëpʉ̈itarr aawai mʉg atag thumaam khʉʉn iiu phiidʉtkhabarm edjã, ¿mag ʉʉi chijãg dënkha sĩsijuma, chi nacha autarr dën wa ẽudeegam khʉʉn dën? a jëeujierram irig, juau ogthom. ");
INSERT INTO noaE_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Magbaata ũr nʉm jʉ̈g eyaa Jesuu amag, —Pãran okhoota iekha nʉmgui ajim, Ẽwandam iek phã sĩsidʉm gaai jaau simta i jua theegjã khaugbata iekha naawai. ");
INSERT INTO noaE_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Meetarr khʉʉndam thumaa iiu phiidʉtkha phöbaadëm chan bʉ̈ʉrjã jua pʉpʉr abajugui ajim, ya am ʉ̈gtharm Ẽwandam chognaan thʉnʉm khʉʉnjö nʉisiju aawai. ");
INSERT INTO noaE_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Pãrau ooba aajẽ, Ẽwandamau ich iek phãpitarr gaai mag õor ötarr khʉʉn deeu iiu phiidʉtkhaju igwi, ");
INSERT INTO noaE_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ichta jöoingar jöoi Abrán khararr Ẽwandam anaa ĩchab jöoi Isá khararr ag Ẽwandamau maimua Jacob khararr dënjã agjö” a sim? Irua mag makhʉʉn jöoin agtha meeba nʉmjö iekhatarr aawai Ẽwandam chan oob mag chi khëcham khʉʉn Ẽwandam khabam. Ẽwandaman chi iwam khʉʉn Ẽwandamaugui ajim. Irigan nawe khëchtarr khʉʉn awiajã agtha iiu nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mag nem jaaumam ũrwia, chadcha thum chi ũrmam khʉʉn jʉ̈gderraa naajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesuu mag saduceonaan warre khĩupaa sĩubarm fariseonaanau oobaawai, jũrr amaun chadau i phithurg chukhu pʉr auju awi, ");
INSERT INTO noaE_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ãb am eem Moiseeu ley phã pʉatarr jawaag chi mach ich Jesús aig bëewi irig, ");
INSERT INTO noaE_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, Moiseeu ley phã pʉatarr gaai, ¿chijãg iekta tagam khʉʉn khãaijã chi wajapcharamʉ́wa? ¿Khanta ʉ̈rʉʉcha Ẽwandamau maachig waupim khõsi sĩ? ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Magbaawai Jesuu irig, —Chi wajapcharamʉn, “Maach Ẽwandam sĩi par iiupai khaba, pʉch thãrauchata khõsi abá” a phã simʉu ajim irig. ");
INSERT INTO noaE_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tagam ley ʉʉrkhapi jaau nʉm khãaijã maata chi wajapcharamʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Magnaa deeu ichdëupai, Ãb agjö ich agjöpaimʉʉ simgui ajim. Ma sĩi “Pʉch khapeenjã wir aig pʉchjö daupii abá” a sim. ");
INSERT INTO noaE_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moiseeu ley phã pʉarr thum tagam khʉʉn agjö Ẽwandam i jaaumienau jaaujerrpa mʉkhʉʉn dau numiim gaaimuata öbërdʉtkha nʉm. Mʉkhʉʉn numiita wajapha ʉʉrkha simʉn magan tagam khʉʉn ʉʉrkhapi jaau simjã thum ʉʉrkha simgui ajim ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mag chi fariseonaan agtha ãba biirdʉ thʉnʉm ee, ");
INSERT INTO noaE_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesuu amag, —Pãrau mag õor peerdʉ awaag Mesías anʉm bëeju ig iyʉ̈ʉ aawai, ¿khai chaai aju khai a khĩirjuba aajẽ? a jëeujim. Magbaawai amachdëu, —Jãan warrgar jöoi David khararr ag chaain ewagam khʉʉnauta oodeejugui ajierram. ");
INSERT INTO noaE_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Magbaata ich Jesuu amag, —¿Pari jãga mag David chaain ewagam khʉʉn dën abarju, ich Daviiujã mag ich Ẽwandamau pʉ̈iju aajerr igwi i Pör a iekhatarrta? Irua mag iekhaawai, ¿ich Ẽwandam Akharauta mag iekhapibajĩ? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","¿Pãrau khaugba nʉ, ich Ẽwandamaucha iekhatarr Daviiu phãtarr? Mag irua phãtarr gaai mag sim: “Maach Pör Ẽwandamau mʉ Pörög, ‘Mʉch iek theeg chirʉmjö aag mʉ dʉ̈i ãba mʉ juachaar gar jupbá’ ajim ‘pʉch oomapha aajem khʉʉn thum mua pʉch jua ee pʉrkha dee nʉm ora.’ ” ");
INSERT INTO noaE_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mag ich David khararrauchajã Ẽwandamau pʉ̈iju aajerr igwi “maach Pör” a iekhatarrta, ¿jãga pãar iek mag í David chaain ewagam khʉʉn dënpai aju anʉ́? Mag sĩi i chaaipai aju akhiin, ich paarmua mag “maach Pör” abakhamgui ajim Jesuu amag. ");
INSERT INTO noaE_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mamʉ par irua mamagkhamjã ãbmuajã bʉ̈dam ãbjã jʉ̈ʉ aba aajeejim. Magtarr aigmua atag ni ãbmuajã tag irig iek chigaapaijã jëeuba aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Magtarr khur Jesuu õragjã ũrmkhĩir iekhamamua maragjã magjim: ");
INSERT INTO noaE_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Chi machnaanta fariseonaan dʉ̈i Moiseeu ley phã pʉarr jaaujem khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Magua amau jaau nʉm ũrnaa pãachig jajaaukham ipierraa abat. Mamʉ oob amau aajemjö chan amiet ajim. Jãkhʉʉnan amach ipaarmua Ẽwandam dau na ajapha nem waupi jajaau aajemta amachdëu chan amachdëu jaau nʉmjö nem wauba sĩerrjëem. ");
INSERT INTO noaE_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Magnaa nem jawaagjã amachdëu nem jaaum aigta jaau sĩerrjëem. Jãg nʉm aig õor ʉ̈r nem chʉkhʉmta jiirpʉ̈pʉ̈ikhamjöta naabahab ajim, õrau wauju khaba atcha phithurgkhamta waupi jaauwai. Õrag mag nem jaauwaijã amaun amach ipierraata api nʉm, mamʉ mag nʉm chan amachdëujã amachdëu nem jaau nʉmjö waujöjöopaijã khaba nʉmta mag sĩerrjëemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Am nem waubaadëmʉn, õrag sĩi amach oomkhĩirpaita nem wau sĩerrjëem, amachdëuta wajapcha Ẽwandam iek ʉ̈kha naawai i dʉ̈i wajapcha nʉm amkhĩir. Amach mag nʉm awi, Ẽwandam iek phã sĩsidʉm gayamjã jũrr deeum gaai phãnaa, chʉdam gaai ẽupʉ̈inaa, amach piudau gaai jʉ̈pʉ̈inaa dag gaaijã jũapʉ̈imaajemgui ajim. Mag nʉm dʉ̈i ĩchab amach khajũahi gaaijã nem bäbärgta jijiraa jũajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Õor khapanag ee thach khoowai, wa sĩi Ẽwandam iek jaaujem deg khãijã biirdʉawai, amachta sie wajapcharam gaai juupjemgui ajim, õor khĩirphee thumaam khʉʉnag amach oomkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Magnaa kaaijã ee õrau amach saludaawaijã amaun amach thö iekhapinaa amachig maestro apim khõsita sĩerrjëemgui a jaaumajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mag jajawagmamua, ’Pari pãar mʉ dʉ̈i khapeerkha nʉm khʉʉn chan mʉ iek ʉ̈kha nʉm gaaimua thum agdaujöpai naawai, pãachig “maestro” apiju khaba nʉmgui ajim, chikhamnag. Mʉʉta pãar Maestroou ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pãar Aaijã ãbpaita wai nʉm; ma ʉ̈gthar sĩejemʉu. Magua, mʉig eegar chan pãach garmuajã oob parhoobam khʉʉnag Ẽwandamagamjö “aai” ichëmiet ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ãba mʉch chi Cristopaita pãar Pörkha chiraawai, oob pãachigjã “maach pör” apimiet ajim, dich khapeen ãba thʉnʉm khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Magju khãai ãb khãijã pãar ee ichta chi pörkham khõsi sim khai, warag thumaam khʉʉn chogkhaju aai sim. Mag nʉm aigta Ẽwandamau oowai chi wajapcharamkha simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mua mag chirʉmʉn, ar amach thöwia chikham dʉ̈i athuu aajem khʉʉn mʉg atag paawai jũrr Ẽwandamag chaigpa oo sĩsid aju aawaita mag chirʉm; maimua ar mag amach dʉ̈i athuu nʉmjã bʉ̈ʉrjã am ichaaur aba sĩi warag serbiibamjö aajerr khʉʉnta jũrr Ẽwandamau warm khʉʉn khãaijã ʉ̈rpai apiju aawaita mag chirʉmgui ajim ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Maimua mag iekhakhagmamua magjim: ’¡Ë, pãarjã agjö chi machnaan dʉ̈i Moiseeu phã pʉatarr iek wajapcha ʉʉrkhaajem khʉʉn! Pãran pãachdëuta ʉ̈rcha Ẽwandam iek khaphʉm anʉmta Ẽwandam aar öbërjujã khaugba nʉmgui ajim, pãachdëu ʉ̈khaba nʉm gaaimua. Mamʉ mag nʉmta õrau i aar öbërju ẽkhaawaijã warag chi öbeerjem döig chawag khecheu ahaukhamjö aajem, õor khũgur wai nʉmua, Ẽwandam iek ʉ̈khapimaaugau.  ");
INSERT INTO noaE_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ë, apdurr, pãar chi machnaan dʉ̈i Moiseeu phã pʉarr iek ajapcha ʉʉrkhaajem aajem khʉʉn! Pãraun sĩita khoopaa ʉʉin juagam nemdamjã khechthʉg aumaajerramgui ajim; magnaata sëukha warag am kõit Ẽwandamag jëeu nʉʉ aajerram, juau ogthom pãach magba nʉm amkhĩir. Mamʉ pãach jãg nʉm paar jũrr Ẽwandamau ĩchab pãar gaai jua khʉabajugui a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ë pãar Moiseeu ley phã pʉarr jawaag chi machnaan chi mag ley wajapcha ʉʉrkhaajem aajem khʉʉn dʉ̈i! Pãachdëuta Ẽwandam ipierraacha nʉm awi pãach dënjö ʉ̈khapi awaag warpham magwe jaau wënʉrraajemgui ajim. Mamʉ mag nʉmʉn, chadcha pãach iek ʉ̈khabaadee pãach khãaijã athuuchata khaibag paapʉ̈imaajem, pãachjö amjã Ẽwandamau khĩmie durr barkhʉʉiju ayaa amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ë, pãran sĩi pãachjã dau khaugbamjö nʉmta agjö dau khaugba khithëem khʉʉn jua gaai ëudʉ arrumjö nʉmgui! ajim amach khĩircha. Pãach mag nʉm gaaimuata pãar iek mag “Aai i jëeujem di igwia nem wauju a iekhatarr chadcha wauba awiajã idëu mag sim” a iekhaajemgui ajim amag. Mamʉ jũrr “Chi Aai i jëeujem deg phĩr thʉnʉm igwiata nem wauju a iekhaawain chad ichiita waub khaba wauju aai sim” aajem, “Ẽwandam dënkha sim igwiata mag iekha naawai.” ");
INSERT INTO noaE_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Pãran warag khĩirjugjã chukhunaa dau khaugbamjöta thʉnʉm! Pãar khĩirjug paraa naakhiin, chi Aai i jëeujem diita ajapcha sĩebahab, chi phĩr khãai. Mag sim ee sĩewaita ag eem phĩrjã agjö Ẽwandam dënëg pa sĩebahab ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pãar iek ĩchab mag “Sĩi chi Aai i jëeujem deg nemchaain phaag nasãdjö wau sim igwia nem wauju atarr wauba awiajã idëu mag sim” anʉm. “Pari mag nasãd gaai ofrenda sim igwiata nem wauju abarmʉn chadau ichiita waub khaba wauju aai sim” aajem. ");
INSERT INTO noaE_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Khaugabnaan! ¿Magan pãragan chi nasãd khãaijã chi ofrendata wajapcha sĩeb? Nemchaai ich appai chan wajaug chukhu simgui ajim; ãba mag nasãd gaai ausĩubaawaita wajaug aadëp sĩebahab, Ẽwandamau ich dënkha athaawai. ");
INSERT INTO noaE_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chi mag nasãd Aai i jëeujem degam igwiata nem wauju a simua chan ãba chi nasãd igwiapai khaba, ag gaai chi ofrenda paa sim igwiapata iekha sĩebahab ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Maagwai chi Ẽwandamag jëeujem di igwia nem wauju a iekha simuajã sĩi mag chi di igwiapai khaba, Ẽwandam igwiapata iekha sĩebahab, mag degta Ẽwandam sĩejeewai. ");
INSERT INTO noaE_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Maagwai edjã igwia khãijã nem wauju a iekha simuan mag edjã igwiapai khaba Ẽwandam igwiapata iekha sim, chi edjã Ẽwandam khu juupjem aawai. Mag i khu juupjem igwiapa iekhaawai ich Ẽwandam igwiapata iekha sĩebahab ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ë, pãar Moiseeu ley phã pʉarr jawaag chi machnaan ag iek wajapcha ʉʉrkhaajem aajem khʉʉn dʉ̈i! Pãraun pãachdëuta Ẽwandam na wajapcha nem wau nʉm awia, i paat agjö deeg pãach nemjĩir bʉ̈ daiicharam gayampa Ẽwandamag ofrendakha deejem: pãrau anís eemjã deenaa comino eemjã deejemgui ajim. Pari mag nʉmta jũrr mag ley Moiseeu phã pʉarr gaai ag khãai nem wajapcharam jaau simjö aju chan khĩir eejã paba aajemgui ajim. Pãrau chan wir aig pãach khapeen dʉ̈i agpierraanaa am dau aug khaug paraa nʉm dʉ̈i ĩchab Ẽwandam iekta ogdʉba ich jãg ʉ̈kha wënʉrraju aai nʉmjã khĩirjuba aajemgui ajim, majã magʉmta ʉ̈rcha wauju aai nʉmta. Magnaan chad tagam nem pãachdëu wau nʉm pʉaba ich jãg dee wënʉrraju aai nʉm. ");
INSERT INTO noaE_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Khĩirjug chuknaan! Pãach pem aawai pãran dö dö nʉm dʉ̈i sĩi pagatjöm khãijã döbapʉ̈imua pekaudam waumaaugau awi, ajapha sãnaata doojerram. Pari jũrr pekau pöm camellojökhamta sĩi ʉ̈ipʉ̈i nʉmjö nʉm chan pãar gaai mas khaba aajemgui a iekhajim amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ë, pãar Moiseeu ley phã pʉarr jawaag chi machnaan maimua mag ley wajapcha ʉʉrkhaajem aajem khʉʉn! Pãach i aawai pãran sĩi pãach juagam nem ʉ̈rʉm chi memerkhögpaita ʉkhakha aju khĩirju sĩerrjëem, mag memerkhöm ee khãijã döbaawai Ẽwandam dau na pekau waumaaugau awi. Mamʉ pãachdëu chikham nemdamjã pãach dënkha aunaa waragta phatkhonjã nem pöm paarpam khõchkha thʉnʉm gaaimua pekau pöm nʉm chan isegba, ni Ẽwandamag chugpaapi jëeujujã khĩirjuba sĩerrjëemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Moiseeu ley phã pʉarr wajapcha ʉʉrkhaajem khʉʉn anʉmta khaugabnaan! Jãg thach khoopierr nem jã ʉkhakha aajemjö, ¿jãg pãach thãarta nacha Ẽwandamag ʉpibamma? Pãrau magta amʉn chadau ʉ̈rpai khaba pãar thãarpata wajapha wënʉrrajugui a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ë, pãar Moiseeu ley phã pʉarr ajapcha ʉʉrkhaajem aajem khʉʉn ag ley jawaag chi machnaan dʉ̈i! Pãran sĩi õor aukhërtarr jẽbdijöta sĩsidʉm. Sĩi daaugajãrpai oowain wajapha jarnaa ooimʉ wau sĩsidʉm; pari mag sim ag ee ierr wa ookhiin, sĩi maach inaa pa appaita thuphãau nʉnʉidʉm. ");
INSERT INTO noaE_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pãarjã magta thʉnaabahab ajim: Sĩi khĩir eerpaawain õor wajaauga thʉnʉm; pari pãar thãran khaibagauta sĩi ãr sĩsidʉm. ");
INSERT INTO noaE_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ë, pãar Moiseeu ley phã pʉarr jawaag chi machnaan maimua mag ley wajapha ʉʉrkhaajem aajem khʉʉn! Pãraun pãach magba nʉm amkhĩir, warrgar pãach jöoin Ẽwandam i jaaujerr khʉʉn chadcha õor wäjäaun arr aawai agtha khĩir eyaa wai wënʉrrʉm awia, am aukhërtarr jã ʉ̈rjã sirppapiba warag nem ooimʉ wau sĩsiu aajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Magnaa pãar dën, “¡Ih! maachta maar jöoinau mag Ẽwandam i jaaumien kheechjerr jaar narr akhiin, marau chan am dënjö mag maach jua paarmua dʉ̈i am khëchbakham” a iekhaajem. ");
INSERT INTO noaE_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pari sĩi pãachdëu mag nʉmuapai pãrau pãachdëujã khaphʉ naabá, pãach mag warrgar Ẽwandam i jaaujerr khʉʉn khëchmien chaainkha nʉm. ");
INSERT INTO noaE_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mag akhʉʉn chaain aawai ĩs pãachdëujã agjö ajurauma mʉ dʉ̈ijã ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Khaibag, nemkhõr chi benen paraamjönaan! Khanii pãar jãg thʉnʉmta khĩmie durr wëtba peerdʉbajupa. Pãar chan peerdʉbam. ");
INSERT INTO noaE_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Khaphʉ abat: Mua pãar ee mʉch i jaaumien pʉ̈iwia khĩirjug khaugkham khʉʉnjã maestronaan dʉ̈i pʉ̈iju. Pari mag mua am pʉ̈ibaawai ãaur khʉʉn pãrau khëchpʉ̈iwia ãaur khʉʉn sĩi pakuls gaaijã bʉʉrnaa khëchmaju; ãaur khʉʉn pãrau pʉrnaa pãach Ẽwandam iek jaaujem deg wʉjã wʉmaju; maagwai ãaur khʉʉn amach pʉr aupiba deeum phöbör ee khãijã dʉr wënʉrraawai agpierr pãrau am ẽudee khoojem nem ẽudeemjö ẽkhaju. ");
INSERT INTO noaE_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pãach mag thʉnʉm gaaimua, warrgar Abel thõotarr aigmua ewag pawiajã õor Ẽwandam na wajapha durrarrta khëchmatarr bag ãrtarr thum jöoi Zacarías Berequías iewaa Aai i jëeujem deg thõo naawai bag ãrtarrpa Ẽwandamau thum pãach gaaita thʉpʉ̈iju. ");
INSERT INTO noaE_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cha mʉ iekha chirʉm iekhau warrgarwe pãach jöoinau maagjerran pãach chi ĩs ewagam khʉʉn gaaita pajugui ajim, pãachdëujã amau nem waaujerrjöta wau naawai. ");
INSERT INTO noaE_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Mag Jerusalén phöbör ee Aai i jëeujem deg simua ʉ̈apërmamua magjim: ’¡Ë! ¡Aay, Jerusalenpien! Pãraun chadcha warrgarweta Ẽwandamau ich i jaaumkhĩir chogpʉ̈i nʉm khʉʉnjã kha khõchkhaba, warag mokoujã bar wai nʉmua khëchpʉ̈imaajemgui ajim. Biek khapan mua pãrag jaaujeejimgui ajim, ãthãrr ʉʉirau ich chaaindam thumaa ich ich eegar thoor wai juupjemjö pãar thʉa wai chitaag. Mamʉ magtarrjã pãachdëuta bʉ̈ʉrjã mag khõchkhabajierram. ");
INSERT INTO noaE_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jãgtarrau nau pãrau oomaa abarju. Nau mʉ mʉg chitʉʉ awia petaawai pãar sĩi di pariim ee wouchnaan phëpʉabajëmjöta pãach appai nʉisijugui ajim, khaigpërjujã chukhu. ");
INSERT INTO noaE_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Magbarm aigmua tag pãrau mʉ oobam ajim. Pãrau mʉ oojuun, ãba ya pãachdëucha deeu mʉ urum oowi, “Ʉ̈uchata Ẽwandam pua pʉch jũrr pʉch Chaai maar athee Reikha pʉ̈ibarm” anʉm aigta deeu mʉ oojugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesuu Aai i jëeujem deg mag õrag nem jaau sĩi awia öbërbaadeeu mag chi Aai i jëeujem di ig iyʉ̈ʉ nʉmuata marau irig jaau naajim, di pöoma sĩi joothʉthʉʉd ëu dʉnʉm. ");
INSERT INTO noaE_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Magbaawai ichdëu marag magjim: —Pãrau jãg di wajapha ëu dʉnʉm oo naabá. Jãg thʉnʉm chan mok pör ãbjã ãbam ʉ̈r ich jãg ajapha joothʉthʉʉd sĩerrabam. Jãg thʉnʉmʉn sĩi thumaa õrau pogueupʉ̈ijuuta jãg dʉnʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mag Aai i jëeujem degmua öbërwi ërëubaadeeu jũrr Olivo durrsĩig wëtjim. Maimua barwi maar na jupbaimaawai maach chi khapeenjã dʉ̈i i bigaau ohood aimajim. Maimuata marau irig jëeu naajim: —¿Jãagwaichata mag pʉchdëu jaau simjö mag Aai i jëeujem di pogueupʉ̈ijuma? Maimua mag pʉ deeu bëeju anʉmjã, ¿khan gaaimuata mag pʉ deeu bëeju dakpapakhamjã marau khap ajuma? anaajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Magbaawai jaaubaadëmua ichdëu marag, —Khĩir khaphʉ aajeet keena; oob chikhamnag ʉdʉraa pãach khũgurpimiet ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mʉg atag paawai õor pöm sĩi chikham khũgurm khõchgau amach iekpai mʉ iek gaai thʉwia, “Mʉʉta ag Cristoou Ẽwandamau pʉ̈iju aajerr” a iekha nʉrrjëe aju. Mag nʉrrjëem gaaimua õor pöm khũgur aumaju ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Juurhi phiidʉju theeg jajaaukhamjã pãrau ũrjugui ajim. Mamʉ pãachdëu mag ũurwai oob jãphierrmiet. Ichiita jerrba chadcha ich mag aju. Magjup mamʉ ma chan agtha Ẽwandamau pãar i agkha nʉm khabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magbaadëmʉn durr mʉg wëjöm ee durr chaauram khʉʉn dʉ̈i wërbʉphöo aadëju, amachta jũrr chikham khãai ʉ̈rpai am khõchgau. Magbaadeewai jãdau theeg aadëm dʉ̈i ʉʉur theegjã duuimaju, durrpierr. ");
INSERT INTO noaE_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pari mamagkhamʉn maan sĩi warrpem Jöoirau õor dau aug waupi simʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ya magbaadeewai pãar chi mʉ iek ʉ̈kha durrum khʉʉn thethemnaanau pʉrnaa amachjöm khʉʉnag pãar pʉr deemaju, pãar dʉ̈i amachdëu ampierr amkhĩir. Mag pʉr deebaa pãar gaai mas waunaa pãar thõojã thõomajugui ajim. Mag nʉm dʉ̈i ĩchab thumaam khʉʉnau pãar oomappha aju mʉ iek ʉ̈kha durrum gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mag jaar paawai õor pöm mʉ iek ʉ̈kha thʉnarr amachdëu ʉ̈kha narr iek isegwi deeu ewag wëtju, warr amach narrjö. Magbaadee wir aig amach eepaijã chikham oomapnaa wir aig chikham thõomaju ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ẽwandam iita jaau nʉm anʉm khʉʉn khapaana öbërdʉtkhaju. Pari mag thʉnʉm sĩi õor khũguraagpaita mag wënʉrraju aawai õor pöm khũgurmajujã jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","¡Aay, mag ed gaaita nem khaigbam pömaata thʉnʉisijupa! Ya mag nem khaigbamta ʉ̈rpai aadeewai õrau amach khapeen kha khõsi aajerrjã tag khõchkhaba aphöbaadëju. ");
INSERT INTO noaE_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pari warm khʉʉn mag thʉnʉm ee, ʉ̈u ichdëu mʉ iek ʉ̈khatarr gaaita ogdʉba khërʉm wounan ʉ̈u peerdʉjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ẽwandamau mʉg durr i agkhaju nawe, durrpierr thumaam khʉʉnag mʉg iek wajapham õor peerdʉ aaujem jaaudubju. Mag jaaubaawai thumaam khʉʉnau ũrbaawain chadau warre ich Jöoirau mʉg durr jua khẽgkhapʉ̈iju a jaaumajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mag ich Jesuu jajawagmamua magjim: ’Khĩir eyaa abat, Ẽwandam i jaaumie Daniel khararrau phã pʉarr gaai jaauwai Aai i jëeujem deg ierr ich Ẽwandam sĩejem aarcha ögkhaba dubwi ãbmua parhooba ichdëu am aig aju jaautarr. Magtarr aawai chi ũr nʉm khʉʉnau wajapha khaphʉ abat ajim: chadcha Danielau jaautarrjö woun ãb chi khaigbamta Ẽwandam awi ya Aai i jëeujem deg sĩeichëm oobaawai ");
INSERT INTO noaE_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","mʉg chi Judea durr nʉm khʉʉn warag pabʉ̈ ee durr dapag ee dʉrbat ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Maagwai ich dihëu ʉ̈r ʉ̈gthaa khãijã sim khai, oob ich nem awaan awi ierrag mam. ");
INSERT INTO noaE_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wa magba di chaaur ich phidag ee khãijã sim khai, oob tag degag mam, ich khajũajöm khãijã awaan awi. ");
INSERT INTO noaE_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mamʉ ¡ë, apdurr mag jaar ʉʉin jõor khithëem khʉʉn maimua ar sĩi chaain daumeraa wai khithëem khʉʉn! ");
INSERT INTO noaE_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Edau khõrgkham ee wa jua ʉ̈i nʉm ed khãijã pãach mag dau aphʉʉ dʉr wënʉrram ugua, Ẽwandamagta jëeu durruu abatgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mag jaar mag wajapha õor dau aug waujujö chan mʉg durr ompaatarr aigmua ewagjã mag ooba, ni mag dichtarr khurjã agjö chan dau aug waubajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mag Ẽwandamau õor dau aug waubaadëm idëu ich mag sĩukhiin, õor ãbjã peerdʉbaju. Mamʉ ichdëu jʉr auwia ich iek ʉ̈kha durrum khʉʉn ichdëu khõsi phë wai sim gaaimua, irua ich mag wai sĩi abajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Mamagkham ee ãbmua khãijã pãachig, “Oobat, chamʉʉta warrgarwe Ẽwandamau pʉ̈iju aajerrauwai”, wa magbam khai, “Pãadë oobat, ar sĩ; jãata aruuwai” aawai oob ʉ̈khamiet. ");
INSERT INTO noaE_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mua mag chirʉmʉn, amach iiupaita amta Ẽwandamau pʉ̈ijim anʉm khʉʉn dʉ̈i Ẽwandam i jaaumien anʉm khʉʉn khapan sĩi sëukha chikham khũgur wënʉrraju aawaita mag chirʉmgui ajim, khap amkhĩir. Makhʉʉnaun chadcha Ẽwandamauta amach pʉ̈ijim amkhĩir, ag na õrau ooba aajempa õor dauderraa wau wënʉrraju. Mag nem wau wënʉrrʉmua ich Ẽwandamaucha jʉr auwi ich iek ʉ̈khapi autarr khʉʉnpa khũgur ẽkhaju ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chadcha magju aawai ag nawe khap amkhĩir ya mua pãrag jaau chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ya mag khaphʉ naawai ãbmua khãijã pãachig, “Õor maba aajem aarta sim” a jaauwai oob aar oon wëtmiet ajim. Wa magbam khai, “Mʉig simta ich oopiba sim” a jajaaukhawiajã oob ʉ̈khamiet ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mʉch chi Emkhooi Iewaa bëewain, thumaam khʉʉnauta mʉ oojugui ajim, ich jãg edau öbeerjem garmua ed burrjemʉg sĩi pagthʉm dau phʉr jẽer athaawai edjã thum arar atham oojemjö. Magua õrau mag pãachig ya barbaichëm a jaauwaijã oob ʉ̈khamiet ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pãrau khaphʉ nʉm, nemmí sim aig ãkõs ich khĩrau jupcheejem. Ich agjöta abajup ajim ĩchab muajã mʉch iek ʉ̈kha nʉm khʉʉn dʉ̈i; am phë arraag mʉch bëem ed am aigta dau daau urum thumaam khʉʉnau mʉ oojugui a jaaumajim ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Mag jajawagmamua ĩchab, ’Mag ich Ẽwandamau wajap õor dau aug waupiwi ya tag magba aadëm ee, mʉg ãsdawam edau khĩjugui ajim. Magbaawai edau chi edaramjã araraa wʉʉ jẽerba warag khĩbaadëm dʉ̈i phĩdagjã edjã eemua sĩi khʉijugui ajim. Magbaawai edjã ee nem sĩsidʉmjã sĩi parhooba amach nʉnʉid arr chaaurta aaidʉ jörrjëe thʉnʉisijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Magbaadëm eeta edjã eejã mʉch chi Emkhooi Iewaa urum dauchach dawaa oopijugui ajim. Mag oowi durrpierram khʉʉn jãphierr nʉm iekhau icharaucha bĩe nʉmuata mʉch chi Emkhooi Iewaa nem jua theeg thumaam khʉʉn Pörkha urum oojurau. ");
INSERT INTO noaE_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mag urumua mʉch chognaanag nem jẽbag churo iekjö trompeta sirpijugui ajim, mag sirbarmua mʉchdëu jʉr auwia mʉch iek ʉ̈khatarr khʉʉn thumaa durrpierram khʉʉn ãbam aig biirdʉ awaag. ");
INSERT INTO noaE_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mag jaaumamua ich Jesuupai, ’Khap amkhĩir pãrag jaaukhimgui ajim: Pãrau khaphʉ nʉm, mʉig Israel durr igo bʉ̈ jãga aajẽ. Ya jãata khër khukhuur aadëmʉn thumaam khʉʉnau ya chadcha döchʉumie burrju dakpapakham aajem. ");
INSERT INTO noaE_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ich agjöta ajugui ajim ĩchab mʉch chi Emkhooi Iewaa bëeju gaai paawaijã. Cha mʉchdëu jaau chirʉm thum ich ag ee öbëbërgmam pãach daúa oobaawai khaphʉ abat, ya mʉch chi Emkhooi Iewaajã deeu bëeimʉʉ chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mua pãrag mag Aai i jëeujem di õrau pogueupʉ̈iju a chirʉmʉn, cha õor thʉnʉm khʉʉn khëchju nawe cha mʉchdëu jaau chirʉmjö thumaa chadcha ajugui a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Edaujãjã mʉg jẽb dʉ̈i thum chukhu aadëju, mamʉ cha mua pãrag jaau chirʉm chan sëukhaawai khabam. Jãan thumaa ich ag ee öbërjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mamʉ mag mʉ bëeju ed chan ni ãbmuajã khaugbam. Ʉ̈gthar Ẽwandam chognaanaujã khaugba, ni mʉchdëujã khaugba, ãba ich mʉ Ayaupaita mag mʉ bëeju orajã khaphʉ simgui ajim, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Jöoingar Noé khararr jaar döãdau õor öpäaiwai thʉnaajerrjö thʉnaaju ĩchab mʉg atag mʉch chi Emkhooi Iewaa bëe nʉm jaarjã. ");
INSERT INTO noaE_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Jöoi Noé sim jaar mag döãd pöm bëeju nawe, agtha õor phiestajã waunaa, thachjã khönaa, döjã dönaa, sĩi jua pʉr khodthʉnaajim, bʉ̈ʉrjã amach öjujã khĩirjuba. ");
INSERT INTO noaE_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mamʉ am mag onee bʉ̈ʉrjã amach chig ajujã khĩirjuba nʉm ee, döãd pöm bëewi, jẽb ierrpawi, thumaa ödubjierram. Mʉch chi Emkhooi Iewaa bëe nʉm jaarjã ich agjöta ajugui ajim. Amau bʉ̈ʉrjã amach chig aju khĩirjuba nʉm ee, dëgölp mʉʉn dʉnʉʉuchëju a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mag mʉ pierrum dʉ̈icha emkhooin numí pabʉ̈ ee amach phidag ee naaju: mag numí nʉm eem ãb mua arrwi ãb werpʉajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ʉʉinjã ĩchab numí ãbam molin gaai ba naaju: mamʉ mua ãbpai mʉch dʉ̈i arrwi ãbakhai werpʉajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Pãrau mʉ pãach Pörkha barchëju ed bʉ̈ʉrjã khaugba naawai pãachjã agjö thʉbagkham uguata muan pãragan, wajapha khĩir khaug nʉisit a chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pãrau khaphʉ nʉm, ãbmua khãijã ich di aig nem jĩgmienau nem jĩgkhaan bëeju ora khaphʉ akhiin, khãijã khãiba ich mag dau phug ëeju ʉdʉʉr ich nem jĩgkhapiba. ");
INSERT INTO noaE_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Magua muan pãragjã ich agjöta, ajapha khĩir khaug nʉisit a chirʉm. Pãrau ãbmuajã mʉ bëeju ora khaugba nʉm. Pãrau mʉ da bëebajupii nʉm ee, mʉch chi Emkhooi Iewaan dëgölp dʉnʉʉuchëjugui ajim marag ichdëucha jaaumamua. ");
INSERT INTO noaE_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mag jajawagmamua ĩchab ich Jesuupai deeu ich bëe nʉm ora jãga naaju aai nʉm khap amkhĩir awi magjim: ’Khanim nemjö patrón ãb simua ich chaaug maagpaawai ich chog ãb simʉg warm khʉʉn pörkhapinaa ich magʉgpai ich nem thumaa jaau pʉabajëm. ");
INSERT INTO noaE_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maimua mawia mam sĩi awia deeu bëewi ichdëu jaau pʉarrjö phidkha sim oobaicheewai, ¿mag jöoi ich chog dʉ̈i onee sim dʉ̈i chi chogjã onee abaju khai? ajim. ");
INSERT INTO noaE_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mag ajapha phidkha sim oobaicheewai jöoirau warag ich nem thum magʉgta thʉsĩepʉ̈ijugui ajim, ich dënjö khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mamʉ magba, mag ichig nem jaautarrjã ich ödegpai “Mʉ patrón chan da bëebam” awi ");
INSERT INTO noaE_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nem khaibag ich khapeen jũrr ich jua eegpaim dʉ̈i ichdëu ampierr anaa, nagjã ichdëu döm aig dönaa, thachjã ichdëu khöm aig khömʉn, ");
INSERT INTO noaE_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","chi dikhʉ bʉ̈ʉrjã irua nʉba sim ee pierrwai, mamagkham oobaichee, jũrr ichdëu warm khʉʉn dʉ̈i aajerr khãaijã i gaai athuucha wʉnaa, phidag eemuajã barpʉ̈inaa, chi khaigbacharam khʉʉn dʉ̈i ãba sĩujugui ajim. Magbaawai gaai machgau icharaucha bĩemamua i agäa agäa abarjugui ajim. Magnaa maachigta, Maguata pãraujã mʉ deeu bëeju khaphʉ naawai mag ichig nem jaau pʉarr thum wau sĩerrjöta aju aai nʉmgui ajim, pãach khapeen dʉ̈i, ich Jöoirau khõsimjö. ");
INSERT INTO noaE_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Mag Ẽwandamau mʉg durr i agkham ed ichdëu auju wa auba khãijã isegju khʉʉnan, biek ãb daupeen diez narr khʉʉn õor jua pʉr nʉm phiesta ee wëtaag chi jua pʉrju emkhooi nʉ narr khʉʉnjöta nʉmgui ajim ich Jesuupai. Makhʉʉn daupeenau mʉgta ajim aajem: Amachdëu ya chi jaai paju urum a ũrbaawai agdaujö amach lámpara panhapha i khĩirphee wëtju aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mamʉ mag khĩirju narrta cincopaita khĩirjug khaphʉ naajim aajem, maimua agjö cinco sĩi khĩirjug chukhumjöta sĩsid ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mag khĩirjug chukhumjö narr khʉʉnaujã amachpierr amach lámpara arrjierram aajem. Mamʉ mag arrtarrta chi aceite öbaadeewai deeu ag ee choo awaag awi khĩet chi aceite pʉ arrbajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pari chi khĩirjug khaphʉ narr khʉʉnaun chadau amach lámpara panhapha wëtum dʉ̈i ĩchab khĩet amach pipied deeum boteedeg aceite pʉkha arrjierram aajem, öbaadeewai deeu ag ee choo awaag awia. ");
INSERT INTO noaE_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mamʉ mag chi emkhooi da bëeba aawai, nʉ nʉʉ awi daphögkhabaadee khãidʉtkha phöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mag am khãidʉtkha thʉnʉm eeta, ya edacha pamamua, “Ya pãrau nʉ narr wounan urum; phiidʉtkhabathʉ̈ i khĩirphee oon maag” ajim anʉm ãbmua. ");
INSERT INTO noaE_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Magbaawaita phiidʉtkhawi apuraa amach lámpara khĩir khaug nʉrrjëe aadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Magbaawai mag cinco khĩirjug chukhumjö narr khʉʉnau ʉ̈u amach khãai khĩirjugdam paraa narr khʉʉnag, “Keena, pãach aceitedam eem marag bʉchkhun choo deebat, ya maar lámpara thõogpam” ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pari magbaawai chi khĩirjug paraa narr khʉʉnau amag, “Marau pãrag deebamgui” ajierram anʉm. “Marau pãrag deekhiin, pöm deeba aawai, pãarjã waaurwi maachjã waaurju. Mag khãai chi peerjem di aar mawi pãach athee për athamit” ajierram anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Amachig magbaawai amach athee aceite për awaan ërëubaadëmich, amau nʉ narr emkhooi barchëjim aajem. Mag barchëwi oocheewai ich dʉ̈i dubaag ʉ̈u khĩir khaug narr khʉʉnan ʉ̈u ich dʉ̈i wai dubjim aajem, ich jua pʉrju aar. Mag phë wai dubwi chi puertdijã phãar sĩujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Maimua ag khur nʉʉ awiata mag cinco amach lámpara athee aceite jʉraan wëttarr khʉʉn bëewi, “Señor, Señor, maar weeu athá, ya maar bëejimgui” ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pari magbaawai chi emkhooirau, “Mua pãar khaugba chitʉm. Mua dubpibamgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mag nem ĩgkhaadam jaauwi deeu marag magjim: ’Pãarjã daupeen khĩirjug chukhu narr khʉʉnjö daaugajãr thʉbagkhamapha nʉm khai, daukhananaa khĩir khaug nʉisit. Pãrau mʉch chi Emkhooi Iewaa bëeju edjã khaugba, ni chi orajã khaugba nʉm. Mʉʉn dëgölpta barchëjugui a jaaumajim marag. ");
INSERT INTO noaE_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mag jaaumamua deeu ich Jesuupai magjim: ’Mʉchta mʉg durr gaai chi Pörkha pierrum ed mʉch athee wajapha phidkhaajerr khʉʉnag amachpierr nem wajapham jigjuun, ãbmua ich piyonnaan dʉ̈i arrjöta ajugui ajim. Mag ich piyonnaan dʉ̈i mʉgta ajim aajem: Mag wounau deeum durr maagpamua ich piyonnaan ãbam aig thʉ̈rkhanaa ich phatkhonau phidkhamkhĩir amag jaau pʉajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ãbakhaíg phatkhon cinco mil deewi, ãbakhaíg dos mil maimua ãbakhaíg mil deejim aajem, ichdëu oowai ʉ̈u amachdëu phidkhamajupierr. Mag amachpierr phatkhon jigpʉ̈iwi petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mag i petaawai chi piyón mag cinco mil autarrau ag phatkhonau phidkhabaadëwi ag ʉ̈r deeu cinco mil gan aujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maimua ãbakhai dos mil autarraujã agjö agua phidkhawi deeu ag ʉ̈r dos mil gan aujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mamʉ ãbakhai milpai autarraun mawia, jẽbdi khörnaa warag ag ee bëp sĩujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Maimua ag khur nʉʉ awia deeu bëejim aajem, chi phatkhon pap. Mag bëewi mag ich maagpamua phatkhon jigtarr autarr khʉʉn deeu thʉ̈rkhʉʉipʉ̈ijim aajem, kharrchata agdaujö ganmajĩ a khap aag. ");
INSERT INTO noaE_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nacha chi cinco mil autarr bëejim aajem. Mag bëewi ag ʉ̈r ichdëu cinco mil gan autarr chi papag deechëwia irig, “Señor, pua mʉrʉg cinco mil werpʉarrau ag ʉ̈r mua agjö cinco mil gan aujim; cha khërʉm pʉ phatkhon” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Magbaawai chi patrón jöoirau irig, “Ʉ̈u khërʉmgui” ajim anʉm. “Pʉ chadcha piyón wajaphamʉu; pua mua jaautarr thum agjö abarm. Mʉg phatkhon pöm khaba deetarrau pua jãgbarpí, jãgtarr jũrr mua pʉrʉg warag ʉ̈r deekhimgui” ajim anʉm. Magnaa irig, “Ierrag dubwia mʉ dʉ̈i onee abá” ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mag khur dos mil autarr bëewi maguajã agjö, “Señor, pua mʉrʉg dos mil deetarr ʉ̈r muajã agjö dos mil gan aujim; cha khërʉm pʉ phatkhon” aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Magbaawai chi patronau magʉgjã, “Pʉjã chadcha piyón wajaphamʉu; pua mua jaautarr thum agjöo abarmgui” ajim anʉm irig. “Phatkhondam pöm khaba deetarrau pua ʉ̈u jãgbarm khai, ag jũrr mua pʉrʉg warag ʉ̈r deejugui” ajim anʉm. “Jãgbarpí pʉjã ĩchab ierrag dubwi mʉ dʉ̈i onee abá” ajim aajem magʉgjã agjö. ");
INSERT INTO noaE_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Maimua milpai autarrjã bëejim aajem. Pari magua chan warm khʉʉn dënjö phidkhawi gan auba arr aawai sĩi warag, “Señor, mua pʉ khaphʉ chitʉmgui ajim anʉm, pʉ õor dʉ̈i atcha sĩerrʉm. Mua pʉ phatkhonau phidkhawi gantarr akhiin, pua sĩi chi ʉ̈rʉm mʉ jua eem khecheu aukhamgui” ajim anʉm, “pʉ dën sĩi chikham jua phithur atarrta pʉch dënjö aajeewai. ");
INSERT INTO noaE_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mʉchdëu mag khaphʉ chitaawai, pʉ phatkhonau mʉ phidkhaba, warag mua jẽb eeta bëp sĩujim. Magtarr aawai cha simgui” ajim anʉm, “pʉ phatkhon pʉchdëu werpʉatarrpierr.” ");
INSERT INTO noaE_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Magbaawai chi patronau irig, “Pʉʉn pʉchta khaibagnaa khusëug sĩerrʉmgui” ajim anʉm. “Pua mʉ õor dʉ̈i mag chitʉm khaphʉ simta, ");
INSERT INTO noaE_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿jãgwi mʉ phatkhon warag banco ee deen mabajĩ” ajim anʉm jũrr irig, “mʉg mʉch barbaicheewai ʉ̈rʉʉpai bãau sim oochëmkhĩir?” ");
INSERT INTO noaE_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Magnaa aig narr khʉʉnag warag mag mil wai sĩerr i jua eem khecheunaa jũrr diez mil wai sĩerragta deepi jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mag nem ĩgkhaa jaau öwia ich Jesuu magjim: ’Ich agjöta sĩebahab ĩchab Ẽwandam athee nem wau nʉmjã. Ar Ẽwandam athee nem wawaag nem par daúa ooba aajem khʉʉn dʉ̈in irua ich garmuajã ajapha aju, amau chokhõgba i athee nem wau naawai. Mamʉ mag nem waumapha nʉm khʉʉn dʉ̈i chan magba, ichdëu amag nem deetarrjã warag am jua eem khecheu aumaju. ");
INSERT INTO noaE_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Magnaa, Mag chi patronau chi khusëumie dʉ̈i arrjö, amach khĩircha am serbiibag phënaa khĩchag ee barkhʉʉipi jaaujugui ajim, mamta am gaai wajaug bëemkhĩir. Mag irua khĩchag a sĩerran khĩmie durr igwiata mag sĩejim. ");
INSERT INTO noaE_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Mʉch chi Emkhooi Iewaata ʉ̈gtharmua mʉch chognaan angelnaanau phʉʉr thuur bëem edan, mʉchta chi Rey aawai mʉch khu juupjem wajappha sim gaaita jupchëjugui ajim, õor dʉ̈i mʉchdëu khap nem wawaag. ");
INSERT INTO noaE_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Magbaawai õor durrpierram khʉʉnta thum mʉch chognaanag mʉch aig phë au bëepiju. Mag thum ãba biirdʉbaicheewaita oveja thʉajem pastorrau chi ovejanaandam amach ag apha khĩet paanaa chĩbjã agjö amach ag apha khĩet paajemjö ajugui ajim, õor dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mag jaaumamua ich Jesuu i iek mag ed ich dënkha nʉm khʉʉnta ich juachaar gar thʉ̈rkhʉʉinaa jũrr khaigbam khʉʉnta khĩet ich juawë gar thʉ̈rkhʉʉimaju aajem. ");
INSERT INTO noaE_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Magnaa mag ich juachaar gar nʉm khʉʉnag ichta Rey aawai ichdëuta amag, “Pãar, mʉ Ayau ʉ̈u abarm khʉʉn, ierrag dubbat mʉ dʉ̈i jooba wënʉrraag” aju anaabá. “Mʉg durr ompaa nʉwe mʉch Aai dʉ̈imua pãrag nem deeju atarr ĩsta chadcha mʉ Ayau pãachigcha deegpamgui” aju anʉm, “pãachdëu mʉ dʉ̈i ʉ̈u atarr jũrr.” ");
INSERT INTO noaE_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Magnaa amag, “Pãrauta mʉ jãsöo jẽedʉ khitaawaijã ʉ̈u mʉrʉg thachdam deejierramgui” aju anaabá; “öbichaaga thʉnaawaijã ʉ̈u mʉrʉg dödam döpijierram; mʉch maba aajem khʉʉn ee chitaawaijã pãrauta pãach aig jẽramkhĩir ʉ̈u mʉrʉg didam jaaujierramgui” aju anʉm; ");
INSERT INTO noaE_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","“khajũadam chukkhu chiraawaijã pãrauta ʉ̈u mʉrʉg deekhërjierram; mʉ mor mas chiraawaijã pãrauta ʉ̈u mʉ oothurjierram; cárcel deg preso chiraawaijã agjö pãrauta ʉ̈u mʉ oothurjierramgui” aju anaabá ich Jesuucha, am khĩir jãsenkha iekhamamua. ");
INSERT INTO noaE_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mag amachig magbaawai mag i juachaar gar nʉm khʉʉnau jũrr irig “Señor, ¿jãagwai mag pʉ jãsöo khitʉm marau pʉ jãogjĩ?” a jëeuju anaabá, amachdëu i khĩircha ooba aajerr aawai. “¿Jãagwai mag pʉ öbissi khitʉm oobaawaijã marau pʉrʉg dödam döpijĩ? ");
INSERT INTO noaE_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pʉ iek mag maach aig jẽramkhĩir marau pʉrʉg maach dijã jaaunaa khajũadamjã chukkhu aawai deejeejim anʉm, ¿ma jãagwai ajĩma?” aju anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","“Pʉ iek mag pʉ mor mas sĩewaijã marau oothurwi, cárcel deg preso sĩewaijã agjö marau pʉ oothurjim anʉm, ¿ma jãagwai ajĩ, marau pʉ ooba aajerrta?” aju anaabá, jũrr irig amach garmua. ");
INSERT INTO noaE_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Magbaawai deeu ich Jesuu amag, “Pãrau chadcha mʉchcha chan oobajierram, pari pãrau jãg dau aphʉʉ khithëe arr khʉʉndam dau aug khaugwi am dʉ̈i jãgtarr aig, mʉchchata dau aug khaug nʉmjö naabajieb” aju aajem amag. ");
INSERT INTO noaE_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Warm khʉʉnag mag iekhawi ichdëupai jũrr mag chi khaigbam khʉʉn ich juawë gar nʉm khʉʉnag, “Jöpai mʉ aigmua chawag ërëubaadët” aju anʉm. “Pãar mʉ Ayau chi maldisiem khʉʉn aawai pãadëu khĩmie durr mepeer ich chognaan dʉ̈i sĩemkhĩir wautarr aarta ërëubaadët” aju anʉm, “õtdau uu wëjöm thõojã khaugba ich mag sĩerrʉm ee naaimaag.” ");
INSERT INTO noaE_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mag iekhamamua ĩchab amag amach khĩircha, “Pãrau chan mʉ jãsöo jẽedʉ khitaawaijã mʉrʉg thachdam khöpibajierram; öbichag khitʉmjã maachig, ‘Cha khërʉm dödam döju khai’ abajierram” aju anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","“Õor mʉch khaugbam khʉʉn eemjö phʉʉrdʉ chitaawaijã pãrau mʉrʉg didam deebajierram, pãach aig jẽermkhĩir. Khajũadam chukkhu daaupamaa aawaijã put sördamjã deeba; mor massi chiraawaijã mʉ oon wëtba; ni cárcel deg chiraawaijã mʉ oon wëtbajierramgui” aju anʉm amag amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pari amachig magbaawai jũrr amau irig, “Señor, ¿jãagwai mag pʉ jãsöo öbissinaa pʉch maba aajem eeta jẽerju dijã chukkhu khitʉm marau bʉ̈ʉrjã pʉ asekasbajĩ?” aju anʉm. “¿Jãagwai mag pʉ khajũadamjã chukkhu daaupamam marau pʉ oojĩ? ¿Jam mag pʉ mor massi marau oojĩ, wa cárcel deg sim khãijã marau pʉ oon wëtbajĩ?” aju anaabá, amachdëu magbajim amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pari ichig magbaawai, makhʉʉnagjã irua magju anʉm: “Chadcha mʉkhʉʉn wounaan dau aphʉʉ wënʉrraawai pãrau bʉ̈ʉrjã am dau aug khaugba arran, jãan mʉchchata pãrau dau aug khaugba nʉm khabajieb, am mʉchdëu pʉ̈iwiata jãg wënʉrrarr aawai” aju anʉm ĩchab amachigcha. ");
INSERT INTO noaE_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Maimua ya ãbmiecha iekha oogpamua maar dakhĩir, ’Muata mag iekhabarm khʉʉnan khĩmie durrta wëtjugui ajim, mamta ich mag dau aphʉʉ wënʉrraag. Mamʉ õor wäjäaun mag mʉch juachaar gar atham khʉʉnan, mʉch dʉ̈ita ich mag iiu nʉisijugui ajim, ich mag wënʉrraag. ");
INSERT INTO noaE_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesuu mag mʉg atag deeu ich bëeju khap amkhĩir mag jaau dichtarr khur, maach ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnagta deeu magjim ich igwi: ");
INSERT INTO noaE_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pãrau khaphʉ nʉmgui ajim, mʉigmua khãai numí nʉm ee phiesta Pascua burrju. Mʉg phiesta eeta õrau mʉch chi Emkhooi Iewaa pʉr deejugui ajim, pakuls gaai meerphë thõomkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ya mag phiesta burrju khãai numpai waaur nʉm ee, phadnaan chi pörkha nʉm khʉʉn jöoin chi thierrnaan dʉ̈i ãba biirdʉjierram aajem, phadnaan thumaam khʉʉn pör Caifás di aig. ");
INSERT INTO noaE_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mag ãba biirdʉtarran, Jesús imeraa pʉr auwi thõopʉ̈yaag ãba ibëpaag ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mamʉ mag i thõopʉ̈yaag ẽkha nʉmta amachdëupai deeu, —Õor pöm mʉg thʉnʉm meeukhapimaaugau, mʉg phiesta ee chan i chig aba, phiesta dichtarr khurta thõopʉ̈ijugui ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mag nʉm ee Jesús woundam Simón anʉm di aig sĩejim, Betania phöbör ee. Ich mag Simón anʉmpai ibʉʉr wauwi “phĩe paraa khitarr” a thʉ̈ʉrjeejim. ");
INSERT INTO noaE_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mag di aig mes gaai i thach khö oo simta, ʉʉi ãb jʉ̈gdee didam durrkhudau alabastro anʉm dën boteedidam wau khitʉm dʉ̈i dubchëjim. Mag jʉ̈gdee nem parhẽpaaga sĩerrʉm. Mag waibëewi Jesús pör ee sĩi choopʉ̈ichëjim. ");
INSERT INTO noaE_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mag i pör ee choobapʉ̈im oobaawai maach chi Jesús dʉ̈i wënʉrrarr khʉʉn ee ãaur khʉʉn mʉ khapeen meeukha phöbaadëwi, —¿Khantheeta jãg jʉ̈gdee parhẽpagkham sĩi ãr choobapʉ̈ima? ajierram, ");
INSERT INTO noaE_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","nem parhẽpag përpʉ̈iwi ag phatkhonau dau aphʉʉm khʉʉndamag ʉ̈u nemdam au deeju ãb sĩerrtá. ");
INSERT INTO noaE_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mamʉ am mag iekha nʉm ich Jesuu ũr sĩerr aawai, —¿Khantheeta pãrau chikham khĩir naaupi nʉma? Irua ʉ̈uta jʉ̈gdeeu mʉ pör khooi sĩebahab ajim amag. ");
INSERT INTO noaE_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mʉig eegar dau aphʉʉ khithëem khʉʉnan pãrau ich jãg pãach dʉ̈i oo wai wënʉrraju, mamʉ mʉ chan tag pãar khĩir chitabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mʉg ʉʉirau jʉ̈gdeeu mʉg mʉ khooibarmʉn maach jöoin i aawai maach meeunau aajemjö mʉ aukhërju edam athee ag nawe ya mʉ kha phuur sim khabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cha mʉ iekha chirʉm iekhau mʉg atag pawiajã durrpierr Ẽwandamau õor peerdʉajem iek jaau wënʉrrʉm dʉ̈i ĩchab mʉg ʉʉirau mʉ dʉ̈i mʉgbarmjã jaaub khaba jaaujugui ajim. Mag, ooba arr khʉʉnaujã ĩchab i iigjeeju a jaaujim ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Maach i khapeen i dʉ̈i doce ogdʉba wënʉrraajerr khʉʉn ee ãb Judas Iscariote a thʉ̈r sĩerrau phadnaan chi pörnaan aar mawia ");
INSERT INTO noaE_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","amag, —Mua pãachig Jesús pʉr deebaawai, ¿pãrau kharr mʉrʉg phag nʉ? aimajim aajem. Magbaawai amachdëu, —Marau pʉrʉg treinta piezas deejugui ajim anaabá. Magbaawai chadcha ich magʉm gaai i ëugar i përpʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Magtarr aigmua Judaan sĩi ãba phadnaan chi pörnaanag Jesús pʉr deejuuta ẽkha nʉrraajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Maach jöoin i aawai pan levadura chukhu wauwia khoojem ag seman ee ya warrpem khãai ãb ãspa ëebaadëm ed maach ich dʉ̈i wënʉrraajem khʉʉnauta marau ich Jesuug, —¿Jamta nemkhoo jaram ovejadam thõonaa khö nʉ? a jëeu naajim, khap aag. ");
INSERT INTO noaE_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mag ichig jëeubaawai ichdëu marag, —Jerusalén woun ãb sim aar ërëubaadët ajim. Maimua magʉg mua jaaupʉ̈i chirʉm abat: “Ya mʉch thõju gayaa pamaawai, pʉ di aigta nemkhoo jaram ovejadam wauwi pãar dʉ̈i ãba khöm khõsi chirʉm” abat ajim chi wëtju khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Magbaawai chadcha ichdëu jaautarrjö, maar khapeenau wëtwi, ichdëu jaaupʉ̈itarrjö jaauwimawi, i na mag nemkhoo jaram ovejadam wauwimajierram. ");
INSERT INTO noaE_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Maimua ich ẽudee ökharta bëewi, ya khĩsu aadëm ee maach doce i dʉ̈i wënʉrraajerr khʉʉn thum ãba i dʉ̈i thach khö naajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mag ãba khö nʉmuata ichdëu marag magjim: —Cha mʉ iekha chirʉm iekhau mʉig maach ãba nʉm khʉʉn ee ãbmua wir aig mʉ oomapham khʉʉnag mʉ pʉr deeju ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mag ũrbaawai, chadcha maar ökhĩirjuu aphöbaadëjim. Mag nʉm iekhau jũrram khʉʉnau irig, “Señor, ĩsin mua khãijãa agam” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mag jũrram khʉʉnau ichig jëjëeu khaawai magjim: —Chi mag wir aig mʉ khaibag waujuun nau mʉ dʉ̈i ãbam thëp ee pan sĩ khöbarmʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Magnaa ichdëu, —Oo nʉm dau eyaa Emkhooi Iewaa chadcha Ẽwandam iek phã sĩsidʉm gaai jaau simjö wajappha dau aug wawaagpaama ajim. Pari apkhiitʉ mʉ mag aphʉʉ amkhĩir wir aig mʉ përtarr woun. Jãgʉm wounaan thaababa arr akhiin ʉ̈ucha akhamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Magbaawai Judaau ichdëu khabajim amkhĩir, —Maestro, ĩsin mua khãijãa agam ajim. Magbaa Jesuu irig, —Chadcha pʉchdëu khabá pua khaphʉ jaaubapʉ̈im; pʉchdëu khabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mag iyʉ̈ʉ thach khö nʉmua Jesuu pandam jua ee aunaa, Ẽwandamag ag paar ʉ̈u ajim anaa khõreunaa marag ʉapʉ̈ijim. Magnaa, —Khöbat, mʉ mʉ morou ajim, chi pan igwi. ");
INSERT INTO noaE_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Maimua jũrr vino jarrdam auwi, ag paarjã agjö Ẽwandamag ʉ̈u ajim anaa deeu marag ʉapʉ̈ijim. Magnaa, —Döbat, mʉʉn mʉ bagau; ich jãg ãbam jarr eepai döpetat ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mʉg jarr eem vinodam döbarmta warrgarwe Ẽwandamau õor dʉ̈i iek deeju aajerrau. Mamʉ mʉg iekhan iek iiuriugui ajim. Mʉ bag mʉg vinojö khitʉm ãrbarmuata Ẽwandamau õor khaibag thum chugpaa aujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pari mʉg döbarmjö chan tag döba, ãba mʉchta mʉch Ayau thumaam khʉʉn Pörkhapibarm edta deeu ũwaai pãar dʉ̈i döjugui ajim. Pari mag ed maach oobarm chan ĩsimjöpai khaba, oneechata aju, nem thʉnʉm thum chi iiur aju aawai a jaaujim ich Jesuu maachigcha. ");
INSERT INTO noaE_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mag maach ich dʉ̈i ãba wënʉrraajerr khʉʉn ich dʉ̈i ãba mes gaai iyʉ̈ʉ thach khö aaipawi, meukhaarjã Ẽwandam iek Salmos anʉm gayam auwia, Olivo durrsĩig wëtjim. ");
INSERT INTO noaE_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mam panaa Jesuu marag, —Ẽwandam iek phã sim gaai, “Mua chi pastor thõobapäaiwai chi ovejanaandam parhooba aaidʉju” a simjö, ĩsim edaar pãrau mʉ mʉch ap barpʉawi thumaa aaidʉtkhajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mamʉ ũwaai phiidʉwia mʉch iiu chirsiewai pãar na mawia Galilea chiraimajugui a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Magbaawaita Pedroou jũrr irig, —Thumaam khʉʉnau pʉch ap barpʉawiajã mua chan pʉ barpʉabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Magbaa Jesuu jũrr, —Pedro, cha mʉ iekha chirʉm iekhau nau ãthãrr bĩeju nawe biek thãrjup pua õrag bʉ̈ʉrjã mʉ khaugba chitʉm ajuwai ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mamʉ Jesuu ichig magbaawai chará warag Pedroou irig, —Pʉ thõbaimam aar dʉ̈i thõimaju awiajã mua chan pʉ khaugba chitʉm a iekhabamgui ajim. Irua magbarm dʉ̈i maach chi khapeenaujã thumaam khʉʉnau ich mag iekhajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Maigmua jũrr nemjĩirdö Getsemaní anʉmʉg maar phë arrjim. Maimua mam barwi, —Mʉig nʉisit, mʉ chum ʉ̈gthaag jëwaakhemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Maimua thãrjuppaim khʉʉn dʉ̈i petajim. Mag ich dʉ̈i phë arrtarr khʉʉn ãb Pedro ajim, maimua tagam khʉʉn numí jöoi Zebedeo chaain ajim, Santiago Juan dʉ̈i. Mam paaukhabaimaawai am iek ökhĩirjuuga aadëmua gaai machaaga aadëjim aajem, chi Jesús. ");
INSERT INTO noaE_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mag simua amag, —Mʉʉn dëgölp gaai machgau ökhĩirjuuga aadëm; ãba mʉch thõjuuta khĩirju chirʉmgui ajim. Pãar mʉig nʉisit, mamʉ mʉ dʉ̈i daukhana abat. Oob khãimiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Amag mag jaau pʉawi ichin am bigaau am warphaapai sĩeimajim aajem. Magnaa jẽkhʉt thʉkhöonaa khĩeb jẽb gaai dagau dʉrnaa ʉ̈gthaag jëeumamua, “Tata, pua khõs akhiin, atcha mʉ dau aphʉʉ apibakhamgui” ajim anʉm. “Deeum nem waubarmuajã agjö õor peerdʉ auju ayaa akhiin, mʉ gaai machag mʉgcha ãwatbakham. Pari mʉchdëu khõsi chirʉmjö khaba, pʉchdëu khõsimjöta mʉ dʉ̈i abá” a jëeumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mag ich Ayag jëeu sĩi awi am oon bëejim aajem. Maimua oocheewai am khãi nʉmta oochëjim anaabá. Magbaawai Pedroogta, —Pãar chan oradam ãbjãta mʉ dʉ̈i daukhana khaba nʉm. ");
INSERT INTO noaE_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jãg khãi nʉʉ aju khãai Ẽwandamagta jëeu nʉʉ abathʉ̈ ajim anʉm, dösãtag ʉdʉʉr pãach thʉ aupim ugua. Mua oowai pãrau pãach ödiiwan chadcha jëeum khõsi durrumta, pari daphökgauta pödbam ajim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Maimua ichin deeu ũwaai mawia jëeubaadëmua ich Ayag, “Tata, pua mʉ mʉg dau aug waupibaju ayaa akhiin ʉ̈u akhamgui” a khitaajeejim anʉm; “mamʉ ichiita mʉ aphʉʉ aju aai chirʉm khai, agjö ʉ̈u sim. Mʉ dʉ̈i pʉchdëu am aig abá” a jëeumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mag jëeu sĩi awi deeu am oon bëewaijã, mag i khapeen irua phë arrtarr khʉʉn daphökgau pödjã dau ẽeba sĩi khãidʉtkha thʉnʉmta oochëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mag khãidʉtkha thʉnʉm oobaichee deeu ich sĩerr aar mawia ich ag iekpai deeu ich Ayag jajawagmajim aajem. Ma biek thãrjupam ajim aajem, mag jëeu sim. ");
INSERT INTO noaE_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Maimua ũwaai oon bëewaijã agtha ich khapeen khãidʉtkha thʉnʉm oobaichee amag, —¿Agtha pãar sĩi khãi gaaita nʉ? ajim anʉm. Ya pekau pöm sĩsidʉm khʉʉnag mʉch chi Emkhooi Iewaa pʉr deeju ora pabaichëbahab. ");
INSERT INTO noaE_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Phiidʉtkhabathʉ̈, maimua maach khapeen aar wëttarraugui ajim anʉm. Mʉ oomapham khʉʉnag mʉ pʉr deeju wounan ya dakpa urumgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mag maar aig bëewi agtha ich Jesús maar dʉ̈i iyʉ̈ʉ dʉnʉm ee, ich mag maach i khapeen doce narr eem ãb Judas anʉmta õor pochag urajim. Mag wëdurum khʉʉnan ãaur khʉʉn espaar jua panhapha bëe thʉnaawai tagam khʉʉn pa dʉ̈ijã bëe thʉnaajim. Makhʉʉn, phadnaanau jöoin chi pörnaan dʉ̈imua pʉ̈itarr khʉʉn ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mag chadcha õor pochag bëewi ya chi Judaau ag nawe, “Nau mua pãach dakhĩir khĩir ʉ̈ʉ athamta pʉr athat” a jaau wai sĩerr aawai ");
INSERT INTO noaE_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ich dʉ̈i wënʉrrʉm khʉʉn dakhĩraa ichdëu jaautarrjö Jesús dʉ̈i ãba dʉnʉʉuwimawi irig, —Maestro, ¿jãgpai chirʉ́? anaa i khĩir ʉ̈ʉ athajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Magbaa Jesuu irig, —Pʉch õor awaan bëetarr jöpai pʉr athaad perá ajim. Magbaawai tagam khʉʉnau dʉ̈i aig bëewi Jesús pʉrphöbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mag i pʉrphöbaadëm oobaawai maar eem khʉʉnau ãbmua ich espaar sʉrr a jẽu athawi chi phadnaan thumaam khʉʉn pör ag chog aig sĩerr kachta oorthubapʉ̈ijim. ");
INSERT INTO noaE_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Magbaawai Jesuu irig, —Jöpai pʉch espaar ich deg phĩ sĩubá ajim. Pua khaugba sĩeb ajim, esparau wërbʉnaa õor khëch nʉm khʉʉn agjö esparauta khëchmaju. ");
INSERT INTO noaE_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mua mʉch chig apibaju akhiin, mʉch Ayag jëeubaawai irua mʉ thʉamkhĩir Ẽwandam chognaan pöoma milam khʉʉn apha doce ejércitos khãijã deepʉ̈ijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mamʉ mʉch thʉamkhĩir mua jëeubaawai mag õor pöm deepʉ̈ikhiinjã, ¿jãga Ẽwandam iek phã sĩsidʉm gaai mʉ igwia jaau sim thum ich agjö abarju? ajim Pedroog. ");
INSERT INTO noaE_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mag iekhapʉ̈iwia jũrr ich pʉr awaan bëetarr khʉʉnagta, —¿Pãrau oowain mʉʉn sĩi õor nem jĩgkhanaa õor thõomiejöta chirab ajim jãg pãrau sĩi mʉ aig jua ee jierrnempan appai bëeg athee? Ag na ed ëepierr pãrag mua Aai i jëeujem deg Ẽwandam i jaaujeewai bʉ̈ʉrjã pãrau mʉ pʉr aubajierram. ");
INSERT INTO noaE_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pari pãrau ĩs mʉ dʉ̈i mʉmʉgkhamʉn, jãan warrgar Ẽwandam i jaaumienau jaautarr thum ag eyaa öbërmkhĩrau ajim. Ya irua mag iekhabarm ee, ĩchab maach chi khapeenaujã chi Jesús ich appai werpʉawia parhoob dʉrmid phöbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mag i pʉr awaan bëetarr khʉʉnau warre phadnaan pör Caifás aarta athaadëjierram, mamta Moiseeu ley phã pʉarr jawaag chi machnaan dʉ̈i jöoin chi thethemnaanpa dʉ̈i ãba biirdʉ narr aawai. ");
INSERT INTO noaE_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mag amau i athaadeewai Pedro iek iruata warppaimua oopʉ̈pʉ̈igmamua mag chi phadnaan pör aig di ũjãrr dubimajim aajem. Mag dubwi, “Mʉigmua ookhim jãga aju khai” awia, Aai i jëeujem di thʉajem khʉʉn ohoodö nʉm aig dʉ̈i jupimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Maagwai phadnaan chi pörnaanau judionaan Asamblea eem khʉʉn dʉ̈imua chi Jesuu nem wauba arrta sëukha i gaai thʉpʉ̈iju ẽkhaajeejim anaabá, magʉm gaaimua i thõopäaig. ");
INSERT INTO noaE_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mamʉ par mag jũrram khʉʉnau sëukha i gaai nem parhooba thʉpʉ̈iju ẽkha nʉmjã pödba aajeejim aajem. Mamagkham ee, õor numí chi sëumien bëewi, ");
INSERT INTO noaE_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Mʉg wounau maar dakhĩir, iruan mʉg Aai i jëeujem di pogueupʉ̈inaa khãai thãrjuppaim ee deeu ëu dʉnʉʉuju a iekha sĩejimgui ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Magbaawai chi phadnaan pöröu dʉnʉʉunaa Jesuug, —¿Pua am iekha nʉm ũr chirʉ́? ¿Khan jãgwi jãg pʉ iekhamapha sĩ? ¿Pua chadcha mag iekhajĩ wa iekhabajĩ? Jaaubá ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pari magʉmjã Jesús bʉ̈ʉrjã jʉ̈ʉ aba, warag khĩuu sĩsijim aajem. Mag ich iek ʉ̈khaba abaawai deeu irig chi phadnaan pöröu, —Maach Ẽwandam ich mag iiu sĩerrʉm iek gaai thʉwi muata pʉrʉg “Jaaubá” a chirʉm. ¿Pʉʉta chadcha Ẽwandam Iewaa ichdëucha jʉr auwia pʉ̈iju jaaujerrá? Marag jaaubá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Magbaa Jesuu irig, —Pua khabá ag eyaa jaaubapʉ̈im ajim anʉm. Mʉ cha iekha chirʉm iekhau mʉg woun Emkhooi Iewaa Ẽwandam chi jua thierr bigaau i juachaar gar oo sim pãrau pãach daujãau oowi edjã baug ee urumjã oojurau a iekhajim aajem, aig narr khʉʉn dakhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mag ũrbaawai chi phadnaan pöröu ich khajũa mor gayamta sʉrr abarmʉn, warre nem pöm jẽ werbpʉ̈ijim anaabá. Magnaa, —Mʉg wounau iekha sim chan ʉ̈u khaba sim. Maach wounaan thum ãba thʉnʉmta iita mag Ẽwandam Iewaa anaab. Ya pãrau pãach jʉ̈gʉucha ũrbarm. ");
INSERT INTO noaE_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Khani maadëu tag ũrm ig nʉ? ajim anʉm, ich khapeenag. Magbaawai mag khapan aig pos thʉnarr khʉʉnau, —Í chadcha kulp pöm sĩebahab; magua warre thõopʉ̈iju aaita simgui ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Magnaa i khĩir gaaijã ichö thunaa i gaai mas waumajim anaabá. Pogkha i khĩidadcha juajãau deenaa ");
INSERT INTO noaE_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","irig, —Pʉchta chadcha warrgarwe ich Ẽwandamaucha jʉr auwia pʉ̈iju aajerr khai, magan jaaubá: ¿khaíuta pʉ khĩidadcha dee sĩ? aajeejim anʉm jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mag chi thethem khʉʉnau Jesús dʉ̈i mamag khaawai Pedro iek i daaugajãr ũjãrr oo chirajim aajem. Mag i oo chirʉm aigta, mag degam ʉʉi chi di khʉʉn chog bëewia irig, —Pʉjã ĩchab jãg Jesús Galileapierr dʉ̈i nʉrraajemʉugui aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pari ichig magbaicheewai i iek irua thum aig narr khʉʉn dakhĩir, —Mua khaugbam pʉ khan ata iekha sim khai; mua magʉm wounan khaugba chitʉm a chirajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ichig magbaicheewai i iek mag ich chirarr aigmua daaugajãrm puertdi aar majim aajem. Mamʉ mamjã agjö deeum ʉʉirau i oobaawai maguajã ich aig narr khʉʉnag, —Jãg wounan Jesús Nazaretpierr dʉ̈i nʉrraajemʉuwai ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pari magbaawai magʉgjã ichdëu, irua magʉm Jesús khaugbam a chirajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Maimua magtarr khur nʉʉpai awi i iek maig ich dʉ̈i di ũjãrr narr khʉʉnaupai deeu irig, —Marau oowai pʉjã chadcha i dʉ̈i wënʉrraajerr khʉʉn eemʉu. Pʉ iekha sim gaaipai merag chukkhu simgui ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Magbaawaita irua warag khĩir mor chigpai iekhamamua, —Chadcha mua magʉm wounaanjã khaugab chitʉmta pãrau mʉrʉg mag naaba a chirajim anaabá ich Pedroou. Mamʉ irua mag iekhabapʉ̈im dʉ̈icha ãthãrrta kekerekee ahbar. ");
INSERT INTO noaE_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mag ãthãrr iek ũrbaawaita ich Pedroou jaauwai i khĩir eyaa dʉnʉisijim anʉm, Jesuu ichig “Nau ãthãrr bĩeju nawe pua biek thãrjup õrag mʉ khaugba chitʉm a iekhaju” atarr. Mag khĩir ee dʉnʉisim abarmʉn chadau gaai machaaga aadëmua dawag öbërwi warre ö jãsenag aadëmua bĩe chirʉʉ ajim aajem, ichdëu jaauwai. ");
INSERT INTO noaE_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Maimua ya ãspabaadeewai phadnaan chi pörnaan judionaan tagam khʉʉn agjö chi thethem khʉʉn dʉ̈i biirdʉnaa deeu iekhawi warre Jesús thõopʉ̈iju khĩirju phöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mag amach ap iekhawi, jʉ̈gadau jua bʉʉrkhanaa, Pilatoota Romaam reíu pʉ̈iwia gobernadorkha sĩerr aawai, irigta thõopi jaaumkhĩir i aar arrjierram. ");
INSERT INTO noaE_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mag Jesús thõopi jawamkhĩir Pilato aar jua bʉʉrnaa athaadëm ũrbaawai chi Judaau deeu ũwaai thumaa ewag khĩirjuwia, chi phadnaan pörnaan chi thierrnaan dʉ̈i nʉm aar mawi, mag Jesús paar ichig phatkhon phagtarr thum ũwaai amag deeimajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mag deeimawia magjim anʉm: —Jãg woun bʉ̈ʉrjã nem khaigba wautarrjã chukhu khitʉmta pãrag pʉr deetarr gaaimua, mʉʉn chadcha pekau pöoma waubarm. Jã chan bʉ̈ʉrjã iekkhõr chukhu sĩejimgui ajim anʉm. Pari magbaawai amachdëu jũrr irig, —¡Idëu mag simgui ajim anʉm; maata magan maar gaai mas sĩeba! Maigjã pʉchta pʉ mag chirabahab ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Amachdëu ichig magbaawai mawia chi phatkhon Aai i jëeujem deg barpʉawi igbaadëjim aajem. Mag mawi, ichdëupai pa gaai ʉ̈gthaa jʉ̈gad jʉ̈naa, thoom khẽu ich ö gaai jʉ̈naa, baudʉ ich ö jorrkaa thõojim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mag barpʉabajeewai phadnaan chi pörnaanau chi phatkhon phë auwi, —Mʉg phatkhon õor thõoju paarta phagtarr aawai pöd maadëu ofrenda ee ausĩubamgui ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Maimua ag khur deeu amach ap iekhawia ag phatkhonau jẽbta për auju ajierram aajem, durr warpmua õor bëe nʉm khʉʉn meebaawai ag ee aukhëraag. Mag phatkhon Jesús param arrau jẽb për autarr, Campo del Alfarero a thʉ̈r sĩejim. ");
INSERT INTO noaE_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mag jẽb gaaita Judaau ich thõotarr aawai ĩs ewag pawiajã mag jẽb agtha “bag ãrtarr param phatkhonau jẽb për autarr” a thʉ̈r sĩerrʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Amau mag phatkhonau mag jẽb për atham aig, ĩchab magju nawe Ẽwandam i jaaumie Jeremías khararrau iekhatarr eyaa öbërjim agjö. Irua nawe iekhatarr mʉg ajim: “Israelnaanau chi precio jaautarrpierr treinta piezas auwi ");
INSERT INTO noaE_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ag phatkhonau el Campo del Alfarero për aujierram, maach Pör Ẽwandamau mʉrʉg jaautarr ipierr” a phã sim. ");
INSERT INTO noaE_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mag arrwi chadcha Pilato na wai naaimajim aajem. Magbaa Pilatoou irig, —¿Chadcha pʉʉta judionaan Reí? a jëeujim anʉm. Magbaawai Jesuu irig, —Pua khabá khaphʉ jaaubapʉ̈imgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mamʉ irua mag iekhabarm ũrbaawai phadnaan chi pörnaanau chi thethem khʉʉn dʉ̈imua warag i ëugar sëukha i khaibag jaauphöbaadëjim anaabá. Mamʉ ich khĩir mamagkhamjã Jesuu bʉ̈dam ãbjã iekhaba, warag khĩuu sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mag am iek ʉ̈khaba aawai deeu ich Pilatooupai irig, —Pua chan pʉch khĩir mag iekha nʉmjã ũrbahab, sĩi khĩuu jʉmaag ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pari par ich Pilatooucha magtarrjã, ni bʉ̈ ãbjã jʉ̈ʉ abajim aajem. Mag ich khĩircha iekha nʉmjã sĩi khĩuu ichig khabamjö sim oowi Pilatoou ich ödegpai, “Mua õor mʉg ooba chitʉmgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mag ag nawejã mag phiesta ee paawai õrau jaaubarm presota chi gobernadorrau sĩi ich jãg öbeerpäaijeejim. ");
INSERT INTO noaE_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Maagwai preso ãb sĩi thʉ̈rphöo sĩerrʉm sĩejim, Barrabás a thʉ̈r sim. ");
INSERT INTO noaE_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mag õrau jaaubarm presota sĩi öbeerpäaijerr aawai, Pilatoou ich ödegpain Jesuuta sĩi öbeerpʉ̈im khõsi sĩerr aawai, mag õor pöm wëjömʉg jëeumamua, —¿Chijãata pãrau sĩi ich jãg pʉapʉ̈ipim khõsi nʉ: Barrabás, wa Jesús ich Ẽwandamau pʉ̈iju aajerr anʉm? a jëeujim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chi Pilatoou khaphʉ sĩejim aajem, amau amachdëu Jesuu nem wau nʉrrarrjö pöd nem waubam gaaimuata mag i pʉr dee wai narr. ");
INSERT INTO noaE_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Magnaa õor dakhĩir ich juupjem sie gaai oo sĩsijim anʉm. Mag oo simta i ʉʉirau irig, —Jãg wounan õor wajaphamʉuwai; oob jã chan khaibag waupi jaaum. Edaar mʉ khãai khõrkhaa khaibag khãai khõrkha ʉajim i gaaimua a jaaupʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mamʉ mag nʉm ee, chi phadnaan pörnaanau tagam khʉʉn chi thethem khʉʉn dʉ̈imua warag õor wawikha thʉnʉʉujim anʉm, sĩi Barrabaata öbeerpi jaaunaa Jesús thõopi jajaau amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ya mag wawikha thʉnʉm ee, deeu chi gobernadorrau jëeumamua amag, —Mʉg numí nʉm aig, ¿chijãata pãrau sĩi chigjã aba öbeerpʉ̈ipim khõsi nʉ? a jëeujim anʉm. Magbaawai amachdëu Barrabaata öbeerpi jajaau aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Magbaa deeu Pilatoou amag, —Magan jãg Jesús mag warrgarwe ich Ẽwandamau pʉ̈iju jaaujerrta mʉg nʉrrʉm anʉm dʉ̈i ¿mua jãgajuma? ajim anʉm. Magbaawai thumaam khʉʉnau ihãba, “Pa gaaita meerpbapʉ̈pʉ̈i” aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Magbaa, —¿Pari khan nemta irua khaigba waujĩma, pãrau mag warre i thõopi jaau nʉm? ajim anʉm chi Pilatoou. Ichdëun sĩi pʉapʉ̈im khõchgau par mag jëeu ohookhamjã warag pa gaaita meerppi jajaau aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoou Jesús pʉapʉ̈iju ẽkha nʉm pödba sĩi waragta õor phogdʉmam oobaawai dö aibëepiwi thumaam khʉʉn dakhĩir jua sũgpʉ̈ijim aajem. Magnaa, —Pãrau mʉg woun iekkhõr chukhu simta thõomʉn mʉ chan bʉ̈ʉrjã kulp chukhu chirʉm, maan ya pãach appaim nemeu; mʉ gaai thʉmiet ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Magbaawai thumaam khʉʉnau sereu phöbaadëmua warag, —Marau pʉ gaai thʉbam; maachta maach chaain dʉ̈i kulp paraa nʉisibajupa ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mag chadcha amachdëu jaau narrjö, Pilatoou Barrabaata sĩi öbeerpʉ̈iwia, Jesús wʉpi jaaunaa, pakuls gaai meerppʉ̈imkhĩir warre soldaaun jua ee thʉsĩepʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Magbaawai gobernador di aar arrwi mam pabaimaawai chi soldaaunau amach khapeen khapan thʉ̈rkha auwi amach jãrrcha wai naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Magnaa i khajũa ʉ̈rʉm ẽerpʉ̈inaa, jũrr dewam phuríi simta jũapipʉ̈inaa, ");
INSERT INTO noaE_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","miu dën wërjũchkha simta pörsirkha jũapipʉ̈ijierram aajem. Magnaa ĩchab i juachaar gar padamjã joothʉpʉ̈ijierram anaabá. Magnaa mag amach rey anʉmua i wau nʉmuata i khĩirphee jĩepör phõbkhanaa, —¿Jãgpai chirʉ́ Judionaan Rey? aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Magnaa jũrram khʉʉnau bëewi, i gaai ichö thunaa, i jua ee amachdëu padam joopʉ̈itarraupai i pörchajã wʉmaajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mag i dau aphʉʉ wau wai nʉʉ awia, amachdëu irig khajũa jũapitarr deeu ẽer auwia, ich khajũa chaardamta deeu jũapinaa, maimuan chadau pa gaai meerphëpäain athaadëjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mag wai öbërwi ag dʉ̈i wëtumua khʉd ee woun ãb Simón anʉm deeum phöbördam Cirene anʉm eem dʉ̈i thẽujierram aajem. Mag dʉ̈i oobaawai chi soldaaunau jũrr ajués magʉgta Jesuu pakuls arrmatarr arrpijierram. ");
INSERT INTO noaE_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mag arrmamua buchagdam Gólgota anʉm aar paaukhabaimajim. Mag Gólgota aawai “pörpá durrsĩ” aawaiu. ");
INSERT INTO noaE_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mag mam paaukhabaimaa vino iel anʉm dʉ̈i nem achaaga waaurëu simta dömkhĩir deejierram. Mamʉ Jesuu sĩi bʉ̈rʉʉ dö oowi tag döbajim. ");
INSERT INTO noaE_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ya pakuls gaai meerphënaa jiirjop sĩuwia, amach chi meerphë narr soldaaunaupai, khaíuta chi khajũa jʉ̈abarju khai awi, jẽb gaai mokdaudam baraag paaukhajierram aajem, mag nʉmua gan aumaag. ");
INSERT INTO noaE_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Maimua mag chi khajũa amachpierr wai nʉisiewai thʉa nʉmua warag khʉt ohoodö aphöbaadëjim anaabá, chi pakuls dakha. ");
INSERT INTO noaE_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","I meerphë jiir wëjöm pör ʉ̈r ẽsapdau phãkha sim gaai jaau sĩejim, khan gaaimuata i mag wai naajĩ. Chi ẽsapdau gaai “Chamʉʉta Jesuu, Judionaan Rey” a phã sĩejim. ");
INSERT INTO noaE_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mag i meerphë wai nʉm dʉ̈i ĩchab i bigaau chi nem jĩgmien numí agjö pa gaai amach khĩkhĩetdö meerphë sĩujierram: ãb i juachaar gar, ãb i juawë gar. ");
INSERT INTO noaE_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mag i meerphë wai narr õor diichjem dakha arr aawai dich nʉm khʉʉnaujã i wau nʉm iekhau warag irig eerpanaa ʉ̈i phʉʉrphʉʉrnaa, ");
INSERT INTO noaE_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Wa jãgʉm khaba puan mag Aai i jëeujem dijã thum pogueupʉ̈inaa deeu khãai thãrjuppaim ee ëu dʉnʉʉuju aajerrta, jãg pua wir aig pʉchpai peerdʉ aubama. Pʉ chadcha Ẽwandam Iewaa khai, magan jãg pakuls gaaimua eeg ʉʉrbabaad aajeejim irig. ");
INSERT INTO noaE_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mag nʉm dʉ̈i chi phadnaan pörnaanau, Moiseeu ley phã pʉarr jawaag chi machnaanau tagam khʉʉn chi thierrnaan dʉ̈imua irig, ");
INSERT INTO noaE_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Deeum khʉʉnan peerdʉ autarrta pʉchta pödbahabma. Pʉ judionaan rey khabá; maar dakhĩir jãg pakuls gaaimua eeg ʉʉrbabaad. Mag oobaawain chadau marau ʉ̈khaju aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pʉ iek mag Ẽwandamau pʉ chig apibaju anarr aawai, chadcha ichdëu pʉ khõsi sim khai, nau irua pʉ khaigpër auju. Magaag pʉchdëuchajã pʉ Ẽwandam Iewaa anarrau aajeejim irig, ya pakuls gaai pawiajã. ");
INSERT INTO noaE_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jũrram khʉʉnau irig mamagkham ũrwi mag chi khaibagnaan numí i bigaau agjö jiir ʉid thʉnarr khʉʉnaupa warag i wau iekha naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Edausĩe thʉnʉm ee, dëgölp edau khĩbaadëm abarmʉn sĩi warre edaramjöta jöisijim. Mag khĩ thʉnʉʉ awia edau phʉʉibaajër las tres naata deeu aardʉbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Magbaadëm ee Jesuu thet, “Elí, Elí, ¿lema sabactani?” ajim anaabá. Mag sim aig maach meúan, “Aay, Ẽwandam, ¿khantheeta pua mʉ mʉg dau aphʉʉ chirʉmjã mʉrʉg oobamjöo aadëma?” a khitʉm ajim. ");
INSERT INTO noaE_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ãaur khʉʉn aig narr khʉʉnau mag i iekhabarm ũrtarr aawai jũrr amach khapeenag, —Keena, pãadë ũrbat: Maguan warrgar Ẽwandam i jaaujerr Elías khararrta ich aig thʉ̈r simwai anaajim, irua iekhatarr khaugbam gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Irua magbarm bʉ̈rre ãbmua khaphigbaadëwi, putjö ũũphë khitʉm gaai vino adchuchúu simta dorrdʉnaa waibëewi, pa gaai bʉʉrnaa i i aig ʉa aujim, ag gaaim bereu dömkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pari ãbmua i dʉ̈i mamagkham ee, ãaur khʉʉnau jũrr, —Idëu i sĩubá, daau nau Eliaau i jãigmua eeg jiirpʉ̈yaan pierrju aajeejim. ");
INSERT INTO noaE_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mag jöchkhërʉʉ awia, thet äa a khitawia, warag chaaupabaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mag i chaaupabaadëm dʉ̈i ĩchab Aai i jëeujem deg ierrgajãrcha put nem parrg thuur ëu wëjorrta ʉ̈gthaamua eeg sʉrr abarmʉn warre jãrrcha thoophem numiita jijirar jöisijim. Magbarm dʉ̈i ʉʉur theega duuibaadëmua mokpörpa thörrchëchëukham dʉ̈i ");
INSERT INTO noaE_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","õor aukhërtarr jẽbdipa weeudʉtkhamam ee, khëchtarr khʉʉnta deeu phiidʉtkhawi iiu nʉrrjëe aadëjim. Mag deeu iiutarr khʉʉn ʉ̈u wajapha Ẽwandam iek ʉ̈kha durrumta ötarr khʉʉn ajim. ");
INSERT INTO noaE_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Makhʉʉn Jesús iiu phiidʉtarr ẽudee amach jẽbdegmua öbërdʉtkhawi Jerusalén phöbör ee wëtjierram. Mag am phöbör ee naaimatarrjã õor khapankham khʉʉnau oojierram. ");
INSERT INTO noaE_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Magbaawaita capitán soldaaun dʉ̈i Jesús pakuls gaai jiir wëjöm eegar narr khʉʉnau mag ʉʉur theeg duuibaadëm ee, mamagkham oophöbaadee jãphierr nʉm iekhau warag, —Mʉg wounan chadchata Ẽwandam Iewaa ajim ajierram. ");
INSERT INTO noaE_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mag i pʉr auju nawejã ĩchab ʉʉin i juag oojerr khʉʉn khapan Galileamua i dʉ̈i bëetarr aawai makhʉʉnau i dʉ̈i mamagkham warpmua oo naajim. ");
INSERT INTO noaE_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mag warpmua oo narr ee naajim: María Magdalena, ãbakhai María, Santiago dʉ̈i Josenaan am ãd, maimua jöoi Zebedeo chaain ãdjã dʉ̈i aig sĩejim. ");
INSERT INTO noaE_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Maimua ya phãarmam ee, rik José anʉm bëejim. Ich mag woun Judea durr phöbördam Arimatea anʉm aram ajim. Chi Jesús thõoju nawe ya ichdëujã Jesús igar sĩejim. ");
INSERT INTO noaE_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mag sĩewai Pilato aar mawia ya Jesús mee khërʉm mordam aukhëraan maag jëeuwimajim aajem. Mag jëeubaimaa Pilatoou ich soldaaunag deepi jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Magbaa Joseeu mawia, ya chi meemdam eeg paa auwi, arrwi, dĩesdam memerkhögjã chukhu bäpphä khitʉm ee pʉrëunaa, ");
INSERT INTO noaE_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ag nawe ichdëu ich athee durrbʉ̈ khõpag ee jẽbdi iiur khörpitarr ee aukhërthurjim, wajapcharan ich jẽb gaaima. Magnaa mokpör pöm simua chi jẽbdi i ee wajapha joothʉ pʉawia igbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mamʉ mag chi José Arimateapierr petamjã María Magdalena chan maba, ãbakhai María dʉ̈i amach numpai chi aphʉʉmdam aukhërtarr jẽbdi aig ohoodö nʉisijim. ");
INSERT INTO noaE_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ag noram sĩi jua ʉ̈ʉijerr ed, wajapcharan sabarhedma, chi phadnaan pörnaan Moiseeu Ẽwandam iek phã pʉarr wajapcha ʉʉrkhaajerr khʉʉn dʉ̈i Pilato aar wëtwia ");
INSERT INTO noaE_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","irig, —Marau khĩir eyaa nʉmgui ajim anʉm, jãg sëunem nem jaau sĩerrarrau jaauwai, iin meewiajã khãai thãrjup nʉm ee deeu iiu phiidʉju a iekhatarr. ");
INSERT INTO noaE_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Magtarr aawai khãai thãrjup soldaaunag chi jẽbdi aig thʉapibá; magba akhiin eeu dëgölp chi khapeenau edaar bëewia, chi binaan amach jua khap ausĩunaa, naspawia chadchata deeu iiu phiidʉjim adukham. Magta aju atheen magan warram khãai warag atchata sëukha nem jaau nʉisijugui ajierram aajem, Pilatoog. ");
INSERT INTO noaE_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Magbaawai Pilatoou amag, —Pãachdëu mag nʉm khai, magan soldaaunan ar thʉnʉm. Phë arrwi pãachdëu khõchagpierr chi jẽbdijã wajapha phãarnaa jʉʉrthʉ pʉabajët ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Magbaawai chadcha soldaaun phë arrwi mag chi jẽbdi ee mokdau joothʉ sĩerr ʉ̈rjã wajapha dusnagjö simua jʉʉrthʉpʉ̈ijierram anaabá. Magnaa chi soldaaunag khãai thãrjup ogdʉba aig thʉapi jaaujierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jua ʉ̈i khëutarr noram, domighed edpherre agtha khĩsu nʉwe María Magdalenaau deeum ʉʉi agjö María a thʉ̈r sĩerr dʉ̈i Jesús aukhërtarr jẽbdi aar oon wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mag nʉm ee Ẽwandam chog ʉ̈gtharmua bëewi mag mokpör chi jẽbdi ee joothʉ sĩerr chaaug pʉrëubapäaiwai ʉʉur theega duuijim. Mag chi mok chaaug pʉrëupʉ̈iwia warag ag ʉ̈r oo sim ooimajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chi Ẽwandam chog khĩir eerpaawai sĩi pagthʉm dau phʉr jẽer atham bʉ̈ oo nʉmjö sĩejim anʉm, maimua i khajũa sĩi bäpphä sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldaaun chi jẽbdi thʉa narr khʉʉn mag oobaawai jãphierr wajaugau kha duuiphöbaadëwi sĩi warag chi meemjö jẽkhʉt thuphãau aphöbaadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pari mag chi soldaaun thuphãau aphöbaadëm ee, chi Ẽwandam chogau chi ʉʉinag, —Oob jãphierrmiet ajim anʉm. Mua khaphʉ chirʉmgui ajim anʉm, pãrau Jesuuta jʉr wënʉrrʉm, ar amau pakuls gaai meerphë thõotarr. ");
INSERT INTO noaE_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mʉig ich aukhërtarr eemua phiidʉwi petaawai ya mʉig khaba sim. Pãach daujãau i aukhërtarr ee oon bëejurauma ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Magnaa amag, Ërëubaadët, maimua i khapeen aar, “ya iiu phiidʉwi pãar na Galileaag petajim, nau jamta pãrau i ooimajugui” a jaaubaimat ajim anʉm chi Ẽwandam chogau. ");
INSERT INTO noaE_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Am iek amachig magbaawai aigmua apuraa ërëubaadëjim anaabá. Jãphierraa naajieb mamʉ agjö onee naajim aajem, amachig mag Jesús phiidʉbarm a jaaubaawai. Mag warag khajapha bʉ̈ chʉp wëtjim aajem, maach chi khapeenag jaauwimaag. ");
INSERT INTO noaE_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mag am eerpamjö wëtumta ich Jesús am khĩirphee öbërchëwi amag saludaachëjim anaabá. Mag amachig iekhabaichee i khaug athaawai i bʉ̈khʉrr phõbkhanaa i bʉ̈ʉta ud athajierram aajem, irig jëeumamua. ");
INSERT INTO noaE_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Magbaawai ichdëu amag, —Oob nem ökhö amiet ajim anʉm. Jãg jãphierr wënʉrraju khãai, mʉ khapeen aar wëtwi Galileaag wëtpi jaaubat, nau jamta amau mʉ ooimaju a jaaubaimat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mag ich dʉ̈icha oowia chi khapeen aar jawaan dʉdʉrkhamich, soldaaun chi jẽbdi thʉa narr khʉʉn eem ãaur khʉʉnau phöbör ee wëtwi chi phadnaan pörnaanag jaauwimajierram anaabá, mag chi mok chawag pʉrëupʉ̈inaa ag ʉ̈r jup sim amachdëu ootarr maimua chi Jesujã ich aukhërtarr ee ooba khãidu parii aadëm. ");
INSERT INTO noaE_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mamʉ magbaawai chi phadnaan pörnaanaujã ag bʉ̈rre tagam judionaan chi thethemnaan thum thʉ̈rkhanaa ibëpjierram anaabá, soldaaunag Jesús iiu phiidʉbarm igwi sëukha nem ĩgkhapieg. Magnaa ĩchab chi soldaaunau sëukha nem jaaubarm paarjã phatkhon pöm phagju ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ya mag amach ap chi iekham arr aawai chi soldaaun wawimamua amag magjierram anʉm: —Õrag jaauwai edaar pãach khãi nʉmich chi khapeen bëewiata chi aukhërtarr eem jĩgkha arrwi amachdëu khap wai nʉm a jaaubat ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mag pãar khãitarr gobernadorrau ũrwia pãar dʉ̈i khaigba amʉn, marau maachdëuchata i dʉ̈i iekhawi maachig paa auju. Magbaawai pãar chig abajugui ajierram anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mag, chadcha amachig phagbaawai, õrag jaauwaijã, am khãi nʉmichta chi khapeen bëewi jĩgkha arrjierram a jaaujim anaabá. Magtarr aawaita ĩs ewag pawiajã judionaan eyan agtha Jesús chan phiidʉba maach chi khapeenauta arrwi maach jua khap bëp sĩujim a jaaujem. ");
INSERT INTO noaE_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mag Marianaanau maachig Galileaagta wëtpi naajim a jaaubaawai maach chi khapeen thum once Galileaag wëtjim, ich Jesuu maachig nʉpi jaautarr buchagdam gaai ãba i dʉ̈i oog. ");
INSERT INTO noaE_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Maimua mam pawia ya ich Jesús warp urum maachdëu oophöbaadeewai Ẽwandam chi Ayagamjö irig jëeu naajim; mamʉ mag irig jëeu nʉm ee, maar khapeen ãaur khʉʉnau ar khabampii naajim. ");
INSERT INTO noaE_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mag nʉm ee warag maar aig bëewi maar dʉ̈i iyʉ̈ʉmamua magjim: —Ya mʉ Ayau mʉrʉg ʉ̈gtharm khʉʉn dʉ̈ijã iek theeg apinaa mʉig eegarm khʉʉn dʉ̈ijã iek theeg apibarmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Magua mua pãragan, mʉ matarr khur pãach ap paaukhabaadee durrpierr aaidʉbaadët a chirʉmgui ajim; magnaa thumaam khʉʉnag amach meupierr mʉg pãach peerdʉtarr iekta jaaunaa chi ʉ̈khamam khʉʉnagjã pãach dënjö mʉchta amach Pörkhapibat ajim. Magnaa ĩchab Ẽwandam chi Aai thʉ̈r gaai, chi Iewaa thʉ̈r gaai maimua ich Ẽwandam Akhaar thʉ̈r gaai pör choopetat ajim, mag chi ʉ̈khamam khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mag nʉm dʉ̈i ĩchab mua pãachig jaaujerrjö Ẽwandamau nem waupi jaaumamta i ipierraa waupi jaaubat ajim, ich jãg pãachdëujã mʉ ipierr wënʉrrʉmjö. Mʉʉn mʉchin Jöoirau mʉg durr i agkha nʉm aar ich mag ed ëepierr pãar dʉ̈i chitajugui a jaau pʉajim maachigcha.");
INSERT INTO noaE_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Warrcha maach peerdʉajem iek jawaag Jesucristo Ẽwandam Iewaa bëetarran mʉgta ajim aajem: ");
INSERT INTO noaE_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Warr jöoingar Ẽwandam i jaaumie Isaías khararrag Ẽwandamau ich iek phãpiewai ich Chaai pʉ̈ijuuta jaaujim anaabá. Pari mag ich Chaai pʉ̈iju na deeum igwia ich Chaairagta magjim anʉm: “Iewaa, mua pʉ na mʉch iek jaaujem pʉ̈iju. Mag wounauta pʉ na pʉ maju ee õrag pʉ barju jajawagmaju, thumaam khʉʉnau pʉ iek ũrm khõsi sĩi pʉ nʉ naamkhĩir” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Mag woun ajappai õor barba aajem aar sĩejemuata ich aar õor barbaimaawai pʉ jaaumamua, ‘Ya maach Pör bëeimʉʉ sim’ a jaaumaju, pʉ igwia. Mag pʉ igmamua, ‘I bëeju nawe pãach thãar khĩir khaugbat’ a jaaumaju, thãraucha khõsi pʉ iek ʉ̈khamkhĩir.” Magta ajim aajem Ẽwandamau ich Iewaag, Juan igwia. ");
INSERT INTO noaE_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mag chi Ẽwandam Iewaa maju na i jaau nʉrrarr Juan ajim aajem, chi õor pör choomie. Warrgarwe chi Juan igwia mag nʉrraju jaautarr aawaita chadcha thum ich agjöo öbëbërgmamua Juanau õrag, “Pãach khaibag ãsie ewag khĩirjuwia, Ẽwandamag chugpaapi jëeuwia, mʉrʉg pãach pör choopibat; magbaawai Ẽwandamau chadcha pãar khaibag chugpaapʉ̈iju” a jaaujeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mag irua jaau nʉrrʉm ũrbaawai bëejeejim aajem: Judea durram khʉʉn dʉ̈i Jerusalén phöbör eem khʉʉnpa, i iek ũraan. Mag amach jʉ̈gʉucha ũrwia, ãsie ewag amach khaibag khĩirjuwia, meerba jaaunaa amach pör choopibaawai, Juanau am pör choopʉ̈imajim aajem, döjã Jordán ee. ");
INSERT INTO noaE_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan chi õor pör choomie khajũan camello ëu dënta kha sĩejim aajem. I ãi jʉ̈ajemjã nemhëu dën ajim aajem. Maagwai irua khoojerr, asphit ajim anaabá pamiel dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mag wounau õrag jaauwai, “Mʉg ed gaai mʉ ẽudee jöpcha woun ãb bëejugui” aajeejim anʉm. “Ma mʉ khãaijã ʉ̈rcha iek theeg sim. Mag mʉ khãaijã ʉ̈rʉʉcha iek theeg sĩewaita mʉ chan mʉg chirʉm aig sĩi i chogkhaagpaijã serbiiba chirʉm. ");
INSERT INTO noaE_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Muan sĩi dödamaupai pãar pör choo chirʉm. Pari ichcha bëem ed gaai ichdëun pãrag ich Ẽwandam Akhaarchata deejugui” aajeejim aajem õrag, mag Jesús bëeju igwia. ");
INSERT INTO noaE_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mag Juanau õor pör choo nʉrrʉm jaarta Jesucristo Ẽwandam Iewaa bëejim aajem, Galilea durram phöbör Nazaretmua. Mag ich aig pierrwai Juanau döjã Jordán ee i pör choopʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mag pör choowia dö eemua öbëraau oowai, edaujãata weeudʉbaadëm eemua Ẽwandam Akhaarta duburjöo khitʉm i gaai jupcheeg wëwëwë urum oojim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Magbarm ee ĩchab ʉ̈gtharmua õor iekjö, “Iewaa, pʉʉta mʉ Chaai mʉchdëu jãsehne wai chitʉmʉu; pʉ gaaimua mʉ onee chiraajem” abarmjã ũrjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mag pör choo aaipawi i durrpabaadëm ee, ich Ẽwandam Akharaucha warp õor chukag ee i warrjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mag mam mawia cuarenta días sĩejim anaabá, durr warp õor chukag ee, maach khoojem nemkham ee. Mag i sim aigta dösãtau bëewia irig sëukhabaichëjim anaabá, i khũgur awaag. Maigmua chi dösãt petarr ẽudee jũrr Ẽwandam chognaanauta ʉ̈gtharmua bëewia i khĩir jãsenkhachëjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mag khur Jesús majim aajem Galilea durr, õrag “Ẽwandamau õor thumta ich dënkha aum khõsi sim” a jawaan. Mag i maawai rey Erodeeu Juan pʉr auwi cárcel deg pʉ̈itarr khur ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mag Ẽwandam iek jawaanta marr aawai ichpai igwia jaaumamua, “Warrgurwe Ẽwandamau Juan ẽudee woun ãb pʉ̈iju a jaaujerr ĩsta barbaichëmgui” ajim anʉm. “Maagwai ĩsin chad Ẽwandamau thumaam khʉʉn ich dënkha aum khõsita sim. Pari magaagan pãach khaibag ãsie ewag khĩirjunaa iseg nʉm dʉ̈i thãraucha maach peerdʉajem iekta ʉ̈khabat” aajeejim aajem ich Jesuucha õrag. ");
INSERT INTO noaE_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Biek ãb Jesús thʉrrdö Galilea anʉm igaau nʉrrʉmua õor numí dö ʉrëu nʉm ooimajim aajem. Makhʉʉn Simón ajim aajem ich naam Andrés anʉm dʉ̈i. Ich makhʉʉn dö ʉamien ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Makhʉʉnag Jesuu, —Idëu pãach red pʉawia mʉ dʉ̈ita wëttarrau ajim anʉm. Ich jãg pãach mʉg sĩi dö ʉa gaaipai nʉmjö, mʉg atag jũrr mʉ iek õrag jaau gaaipaita nʉisijugui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mag chadcha amachig magbarm bʉ̈rre amach red pʉawia Jesús dʉ̈i ërëujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mag ërëubaadeeu ag atkhajãrpai deeu õor numí botedam ee amach red thʉrrdʉ sĩsidʉm kha nʉm ooimajim aajem. Makhʉʉn jöoi Zebedeo chaain ajim aajem, Santiago Juan dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Makhʉʉnjã Jesuu ëeurrjim anaabá ich dʉ̈i. Magbaa amach aai Zebedeo ich phidkhaajem khʉʉn dʉ̈i bote ee pʉawia i dʉ̈i wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mag wëtwi, Capernaum phöbör ee barwia, jua ʉ̈ʉijem ed aadeewai, judionaan Ẽwandam iek jaaujem ee mawia, õrag Ẽwandam iek jaaubaadëjim aajem, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mag irua jaaumam ũrwia, aig õor i iek ũr narr khʉʉn jʉ̈gderraa naajim aajem, amachdëu ũurwai Jesuu jũrr Moiseeu ley phã pʉarr jawaag chi khaphʉm khaphʉm aajem khʉʉn khãyaujã jaau khapcha jaaumam ũrwia. ");
INSERT INTO noaE_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mag Jesuu Ẽwandam iek jaau sim aig woun ãb mor ee bën khaigbam wai sim sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Mag wounau Jesús oo athaawai chi bën i mor ee simuata thet äa anaa irig, —¡Jesús Nazaretpierr! Idëu maar sĩi khajapha sĩubá ajim anʉm. Puan sĩi maar öpäainta urum. Mua pʉ khaphʉ chirʉmgui ajim anʉm, pʉ jammua urú. Pʉ Ẽwandam Iewaa ʉ̈gtharmua bëetarr khabahab, warrgurwe Ẽwandamau pʉ̈iju a jaaujerr ajim anaabá irig chi mepeer garmua. ");
INSERT INTO noaE_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Magbaawai jũrr Jesuu chi meperagta meeukhanaa, —Khĩu abá. Pʉchta warag jãg woun mor eemua öbërbaad ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesuu mag iekhabaa, chi mepeer mag woun mor eemua wiwiug öbërbaadeeu, warre jẽkhʉt phʉphʉrgpʉ̈iwia, chi wounta iek chuk pʉajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Õrau amach daúa mag oobaawai dauderraa nʉm iekhau amach wir aigpai, “¿Jãga jãg wounau iekhaawai meperaupa i ipierraa nʉma?” anaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesuu mag woun mor eem mepeer jʉrbapʉ̈im jöpchata Galilea durr ee maimua ag bigaau phöbördam nʉnʉidʉm eem magwe khakhapdö jöisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mag judionaan Ẽwandam iek jaaujem deg Jesuu õrag Ẽwandam iek jaau sĩewia öbëraau igbaadëjim aajem, Simón Andrés dʉ̈i joobaajerr di aar. Mag i mam dʉ̈i i khapeen numí wëtjim aajem. Makhʉʉn, Santiago ajim aajem Juan dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mag wëtwia Jesús deg pabaimaawai aiguim khʉʉnau irig jaaujim aajem, Simón phaauhũan put ee khʉʉumieu mor mas sim. ");
INSERT INTO noaE_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ichig mag jaaubaa, aar dubwia, i jua gaai pʉrnaa ʉ̈gthaag phiriu aujim anaabá. Mag phiriu atham bʉ̈rre chi khʉʉumiejã thumbabaadeewai warag phiidʉwia am jãogjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Maimua ya edau khëubaadëm ee, õrau amach aaunaan khamor machag khĩirpierr wai narr khʉʉn dʉ̈i dösãt bënëu sĩsidʉmpa Jesús aig waibëemajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mag warag thum phöbör eem khʉʉn bëewia i sim di aig puertdi igaauta daaugajãrm magwe pos aphöbaadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mag, sĩi khajapham khamor machag khĩirpierr wai sĩsidʉm ich aig aubëemarr khʉʉn monaaumam dʉ̈i ĩchab mepeenpa õor mor ee sĩsid arr jʉr wërpmajim aajem. Chi mepeenau i khaphʉ naajim anaabá, i chadcha Ẽwandam Iewaakha sim. Mamʉ ich Jesuu bʉ̈ʉrjã amag iekhapiba aajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesuu ichdëu mag õor pöm monaautarr ag noram edaraawe phiidʉwia phöbör igaau warphaapai ich ap majim aajem, õor chukag ee, Ẽwandamag jëwaan. ");
INSERT INTO noaE_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Magbaawai Simonau tagam khʉʉn ich khapeen dʉ̈imua i jʉr wënʉrrawi oobaimaawai ");
INSERT INTO noaE_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","irig jaaujierram aajem, õor thumaam khʉʉnau mag i jʉr wënʉrrʉm. ");
INSERT INTO noaE_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mamʉ magbaawai jũrr ichdëu amag magjim anʉm: —Chawag dewam phöbör dakhapaim aarta wëttarrau, jũrr mamaam khʉʉnagjã Ẽwandam iek agjö jawaag. Warrjã mag jawaanta mʉ bëejimgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ich mag Jesuu Galilea durr õor nʉnʉidʉmpierr Ẽwandam iek jaau nʉrranaa judionaan Ẽwandam iek jaaujem degjã jaaujeejim aajem. Mag nʉrrʉmua õor mor ee mepeer khaigbam wai sĩsidʉmjã warre dau daau öbeerpʉ̈i maajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Biek ãb woun phĩe kha dodoso sim Jesús aig bëewia i khĩirphee kanieu phõbkhachëwia irig, —Pua khõs chirʉm khai, mʉg phĩedau warre mʉ gaaimua chugpaabapʉ̈i aichëjim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Magbaa Jesuu i dau aug khaugwi i gaai pʉrnaa irig, —Mua pʉ monaaupʉ̈im khõsi chirʉm. Monaau chirsí magan ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Magwia Jesuu irig, Mua mʉg pʉch monaaubarm oob õrag jawam ajim anʉm. Magju khãai nacha Jerusalén mawia Aai i jëeujem degam phadëg pʉch mor oopibaimá. Maimua Moiseeu iek phãtarr gaai jaau simjö pʉch monaaubarm paar nemchaain ofrendakha deebá ajim anʉm, pʉch mʉg monakha chirsim õrag khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mamʉ Jesuu mag ich monaautarr õrag jaaupiba arrta ich nʉrrʉmpierr jaaubaadëjim anaabá. Mag gaaimua Jesús tag phöbör ee parhooba öbërju khaba, õor chukag chʉʉita sĩsijim aajem. Mamʉ magʉm ãba, mam phöbör igaau i sim aar durrpierram khʉʉn i aar baarjeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesuu mag woun monaaupʉ̈itarr khur khãai khapancha khaba nʉm ee, phöbör Capernaum anʉmʉg majim aajem. Mag mawia barbaimaawai sĩi phöbör eem khʉʉnau i barbaimam khakhapdö jöisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mag amachdëu i deg pabaichëm khaug athaawai aig bëe thʉnʉmua õor pöm pos sĩi puertdi igaaum magwe phẽu thʉnʉisijim anʉm. Jesuu mag pos thʉnʉm khʉʉnag Ẽwandam iek jaau sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mag nʉm ee õor jayapam khʉʉnau woun ãb khapá jʉser khitʉmta pa bʉʉrkham gaai jiir aibëejierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mag aibëewi Jesús sim aar mag woun wai dubaag ẽkha naajim aajem; pari mag puertdi igaau õor phẽu thʉnʉm khurau pöd ierrag wai dubju khaba aawai, ʉ̈gthaa dihëu ʉ̈r waaidʉtkhawia, chi Jesús sim ʉ̈rʉʉ dihëu magar auwi, chi pa bʉʉrkham gaai jʉ̈gadau jʉ̈khanaa mag chi khapá jʉser khitʉm eeg jiir burrpʉ̈ijierram anaabá, Jesús sim aigcha, amach aaunaan monaaupʉ̈iju khaphʉ narr aawai. ");
INSERT INTO noaE_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesuu amau mag khĩirju nʉmjã khaphʉ sĩerr aawai chi khapá jʉser khitʉmʉgta, —Pʉ pekau thum ya mua chugpaabapʉ̈imgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mamʉ mag iekhabarm ũrwia Ẽwandam iek jawaag ithee chi machnaan aig narr khʉʉnau amach wir aigpai, ");
INSERT INTO noaE_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ma chijãg wounta Ẽwandam dau na mag khaigba i jũur iekha sĩma? Ãba Ẽwandamau khabam chan maach pekau chugpaa auba aajem” ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mamʉ amau amach ödegpai mag khĩirju nʉmjã Jesuu khaphʉ sĩerr aawai amag, —¿Pãrau khanthee pãach ödeg jãg khaigbata khĩirju nʉma? ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Wa mag pekau chugpaabarmjã dau daau ooba naawai pãrau khĩirjuawai chadcha phithurg chukhu thumaam khʉʉnau mag iekhaju aai nʉm a nʉwa? Mamʉ mua irig, “Phiidʉwia pʉch pa bʉʉrkham ãbamʉg phë auwia petá” akhiin, õrau amach daúacha ooju, i monaau sĩsi wa monaauba khãijã ich mag sĩsim. Magua pãrau mʉ dënjö chan cha mua jawaagpamjö abajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mamʉ mʉch chi Emkhooi Iewaa Ẽwandamau ich juapá deetarrau chadcha mʉg jẽb gaai õor pekaujã chugpaaju aai chirʉm pãrag khap amkhĩir, mua pãrag oopikhimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Magnaa chi khapá jʉser khitʉmʉgta, —Phiidʉwia, pʉch put ãbamʉg juurwia, pʉch diig petá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Magbaawai ag bʉ̈rre chadcha phiidʉwia, ich wai bëetarr pa bʉʉrkham dʉ̈i ich putpa ãbamʉg phë auwia, thumaam khʉʉn dakhĩir nem moná dawag öbërbaadëjim anaabá. Mag öbërbaadëm oowi aig narr khʉʉn dauderraa nʉisijim anʉm. Mag nʉm iekhau Ẽwandam thö iekhamamua, “Ẽwandam, ag na marau bʉ̈ʉrjã mʉg nem ooba aajemta ĩsta chadcha pua marag pʉch jua theeg oopibarm. Pʉchta chadcha chi jua thierriu Ẽwandam” anaajim aajem, irig jëeumamua. ");
INSERT INTO noaE_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesuu Capernaum phöbör ee mag woun monaautarr khur petajim aajem deeu Galilea thʉrrdöog. Mag mawia i barbaimaawai, ich aig jũrram khʉʉn phẽphẽeukhamua õor pos aadeewai, amag Ẽwandam iek jaaubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mag jaau sĩewi petaau jöoi ãb Alfeo anʉm iewaa Leví anʉmta ooimajim anʉm. Mag Leví Romaam gobierno dën dëbpaar jëeujem arr aawai õrau ichig dëbpaar phagaan bëejem ag mes bigaau päar sĩejim anʉm. Mag oobaimaawaita Jesuu irig, “Mʉ dʉ̈i marrau” abaawai, phiidʉwi, chadcha i dʉ̈i petajim anaabá, i kha ogdʉba nʉrraag. ");
INSERT INTO noaE_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Biek ãb Jesús ich khapeen dʉ̈i Leví di aig thach khö sĩejim aajem. Maig naajim aajem ĩchab ich Leví khapeen agjö gobierno dën dëbpaar jëeujem khʉʉn. Maimua ĩchab õor khapan i ẽudee bëetarr aawai amach khaibagau thʉ̈rphöokham khʉʉnpa aig thʉnaajim aajem, Jesús dʉ̈i ãbam mes gaai thach khoowai. ");
INSERT INTO noaE_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mag i makhʉʉn dʉ̈i ãba thach khö sim aig fariseonaanau Ẽwandam iek jawaag chi machnaan dʉ̈imua chi Jesús dʉ̈i wënʉrraajerr khʉʉnagta jëeuchëjierram anʉm: —¿Jãga jãg pãar maestro sĩi dëbpaar jëeujem khʉʉn dʉ̈i pekau pöm sĩsidʉm khʉʉnpa ãba thach khö sĩ? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mamʉ amau mag iekhabarm ũrwia Jesuu amag magjim anʉm: —Kha monakha nʉm khʉʉnau chan doctor igba aajem. Mor masim khʉʉnta doctor iigjem. Mʉ chan bʉ̈ʉrjã pekau chukhu wajapha khithëem aajem khʉʉn jʉraanjã bëeba, mʉʉn õor pekau pöoma khithëem khʉʉn peerdʉ awaanta bëejimgui ajim anaabá, khĩirjug iiur aumkhĩir. Maguata mag am pekau pöm nʉmjã igba, am dʉ̈i thach khö chirabahab ajim anʉm, amjã Ẽwandam dënkha awaag. ");
INSERT INTO noaE_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Khãai ãb fariseonaan igar nʉm khʉʉn Juan chi õor pör choomie khapeen dʉ̈i thach khöba sʉrkha naajim aajem. Mag nʉm ee õrau Jesús sim aar wëtwia irig maguimajierram anʉm: —Fariseonaan igar nʉm khʉʉn maimua Juan khapeenjã sʉrkha nʉmta, ¿khan jãgwia pʉ dʉ̈i wënʉrraajem khʉʉnta jãg sʉrkhaba nʉ? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Magbaa Jesuu amag magjim anʉm: —Pãrau oowai, ¿chi jua pʉr sim woun onee ich ʉʉi dʉ̈i thach khö nʉmich, irua õor ich jua pʉr nʉm ee thʉ̈rtarr khʉʉn sĩi bëewia ökhĩirjuu ohoodö naajẽ, sʉrkhaawai bʉ̈ʉrjã thach khöba? Magba aajem. ");
INSERT INTO noaE_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Magua ich agjö mʉ dʉ̈i wënʉrraajem khʉʉnjã sʉrkhaba nʉm. Am sʉrkhajuun, mʉg atag mʉ am jaaijö am dʉ̈i chitʉm pʉr atham ed gayan chadau am amach khĩrauta sʉrkhawia ĩchab thachjã khöba nʉisip aju, gaai machgau. Mamʉ mʉʉgwaiwe chan am sʉrkhaju khaba nʉmgui ajim anʉm, agtha mʉ am dʉ̈i chiraawai. ");
INSERT INTO noaE_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Magnaa, ’Pãadë khĩirjubat ajim anʉm. Pãraun chadcha pãach jöoinau jaaujerrjö thach khöba sʉrkha nʉm. Mamʉ pãrau jãg mua iek iiur jaau chirʉmjã khõsinaa agjö warrgarm khĩirjug chi jöoijã agtha khõsi wënʉrrʉmʉn, magan mag khĩirjugan sĩi put iiur auwia jũrr khajũa jöoi gaai phẽekhabarmjöta sĩsim. Ãbmua khãijã put iiuriu khajũa jöoi gaai phẽekhakhiin, mag put iiur i pächdʉbaadëmua chi kha sim ee thʉrrdʉbaadeeu warag ich warr sĩerr khãaijã nem wäg sĩsiju. Magua chi mʉ iek ʉ̈kha simua chan mʉg iek iiur mua jaau chitʉmjã ʉ̈khanaa pöd amach jöoin ijã agjö ʉʉrkhaju khaba simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wa magbam khai, vino õrr achpamkhĩir nemhëu jöoi dën thũrkha sim ee pʉbarmjöta aju: Chi vino õrr achpabaadeewai, chi nemhëu jöoiraa sĩewai, ãwatba jẽgdʉbaadee chi vinojã ãrbaadëm dʉ̈i chi nemhëujã ya tag serbiiba sĩsiju. Maguata vino õrr achpamkhĩran, agjö nemhëu iiur eeta pʉajemgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Khãai ãb jua ʉ̈ʉijem ed Jesús ich khapeen dʉ̈i trigodö ee dich wëtumua chi khapeenau trigo phierr ahaug wëtmajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mag trigo phierr nʉm oowia Moiseeu Ẽwandam iek phã pʉatarr wajapcha ʉʉrkhaajem khʉʉnau Jesuug, —Pʉdë oobá: Jua ʉ̈i nʉm ed aawai bʉ̈ʉrjã phidkhaju khaba nʉmta pʉ khapeenau jãg trigo phierrnaa khö wënʉrrʉmwai ajierram anʉm. ¿Pua chan khaugbahab ajierram anʉm, jãgpai phierr nʉmjã nem pöm eeu nʉm dʉ̈i ãba sim? ");
INSERT INTO noaE_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Magbaa jũrr Jesuu amag magjim anʉm: —Mamʉ ¿khani mʉ khapeenau khaigba abar? Magan ¿pãrau chan Ẽwandam iek phã sim gaai thʉ̈ʉrwai bʉ̈ʉrjã khaugbata aajeeb, rey David khakhitarrau ich khapeen dʉ̈imua amach jãsöo aphöbaadee pan khötarr? ");
INSERT INTO noaE_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pãrau khaphʉ nʉmgui ajim anʉm, warr Abiatar phadnaan pörkha sim jaar David ich khapeen dʉ̈i Aai i jëeujem deg dubwia ag ee pan ofrendajö Ẽwandam ithee wai narr khöpʉ̈itarr. Mag pan parhoobam khʉʉnau khöju khaba, ãba phadëupaita khöju aai sĩejim anaabá. Mag sĩerrta ichdëujã khöwi ich khapeenagjã deejimgui ajim anʉm amag. Mamʉ mag khötarr paarjã Ẽwandamau am chig abajim. ");
INSERT INTO noaE_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesuu amag mag iekhawi ichdëupai deeu ũmaai amag magjim anʉm: —Jua ʉ̈ʉijem edan, ʉ̈u õordam jua ʉ̈i wënʉrramkhĩirta Ẽwandamau deejim; mamʉ mag nʉm chan mag jua ʉ̈ʉijem ed sʉrkha wënʉrrʉm gaaimuata maach ʉ̈u wënʉrrʉm anʉm khabam. ");
INSERT INTO noaE_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Maguata mʉch chi Emkhooi Iewaa mʉg jẽb gaaijã iek theeg chirʉmuata thumaam khʉʉnag khan nemta wauju aai nʉ a jaauju aai chirʉmgui ajim anʉm, jua ʉ̈ʉijem ed awiajã. ");
INSERT INTO noaE_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Biek ãb deeu jua ʉ̈ʉijem ed Jesús mawi Judionaan Ẽwandam iek jaaujem deg dubimajim aajem. Maig woun ãb ooimajim anʉm thoom juadam jʉsar khitʉm. ");
INSERT INTO noaE_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Maig naajim aajem ĩchab fariseonaan, Moiseeu Ẽwandam iek phã pʉatarr wajapcha ʉʉrkhaajem khʉʉn. Makhʉʉnau Jesuug bʉ̈ʉrjã dau thõba naajim anʉm, amach dakhĩir Jesuu jua ʉ̈ʉijem ed mag woun monaaubapäaiwai irig, “Jãgan pua chan jua ʉ̈ʉijem edjã ʉʉrkhabata chirab” a iekhaag, mag nʉm dʉ̈i ĩchab magʉm gaaimua thethem khʉʉnagjã i khaibag waupi jawaag. ");
INSERT INTO noaE_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mamʉ Jesuu amau mag khĩirju nʉm khaphʉ sĩerr aawai warag chi jua jʉsar khitʉmʉgta, —Phiidʉwia dayag pidú, maimua mau õor jãrr dʉnʉʉubaichë ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Magnaa jũrr chi fariseonaanagta, —Pãrau oowai ¿khan nemta maadëu wauju aai nʉ ajim anʉm, jua ʉ̈ʉijem ed? ¿Õordam dʉ̈i ajapha aju wa õor khaibag wauju? ¿Õor peerdʉ auju, wa õor thõoju? ¿Khani ʉ̈ucha sĩ? a jëeujim anʉm amag. Mamʉ amachig mag jëeutarr ni ãbmuajã bʉ̈ʉrjã i iek ʉ̈khabajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mag ni ãbmuajã ich iek ʉ̈khaba abaawai amag khĩir masi eerpanaa warag ökhĩirjuu aadëjim anʉm, ichdëu oowai amau bʉ̈ʉrjã wir aig amach khapeen dau ee aug khaugba nʉm oowia. Magwia chi jua jʉsar khitʉmʉgta, —Dayag jua ʉabá ajim anʉm. Mag chadcha i ipierr ʉ̈gthaag jua ʉabaawai warre jua monakkha sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mag chi fariseonaanau amach dakhĩir mag woundam monaaubapʉ̈im oobaawai khĩir machgau warag amachta daau paaukhabaadëjierram aajem. Maimua rey Erodes igarm khʉʉn chi thethemnaan dʉ̈i ãba biirdʉwia, “Jãga akhiin maadëu jãg Jesús pʉr auwia thõopʉ̈ikhamgui” a khĩirju nʉisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Maigmua Jesuu ich khapeen ich dʉ̈i phë arrjim aajem, ich ag Galilea eepai thʉrrdö pöoma simʉg. Mag i mam dʉ̈i õor khapaana Galileapien Judeapienpa wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesuu mag õor mor masim khʉʉn monaau nʉrrʉm a ũrphöbaadeewai õor pöoma i aig bëe thʉnʉisijim anaabá: Jerusalenpien, phöbör Idumea anʉm aram khʉʉn, döjã Jordán anʉm ee edau öbeerjem garm khʉʉn, maimua phöbör Sidón anʉm dʉ̈i Tiro dakha phöbördam nʉnʉidʉm eem khʉʉnpa bëejierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mag õor pöm bëe thʉnaawaita Jesuu ich khapeenag ya ag nawe jaau wai sĩejim aajem, sĩi ich ithee bote khĩir khaug wai naamkhĩir, atcha õor pöm aadeewai thet ich phẽeuthʉ aum ugua ag ee waaidʉag. ");
INSERT INTO noaE_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ich mag ed Jesuu õor pöoma monaaukhapʉ̈ijim aajem. Mag õor pöm monaaumam amach daúa oo narr aawaita warag jũrram khʉʉnau i gaai juaucha pʉrchëm iigjeejim anaabá, amachjã monaaumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mag õor pöm wëjöm ee naajim aajem ĩchab, mor ee thõthõrrsöm bën paraa sĩsidʉm khʉʉn. Magʉm khʉʉnau Jesús oowai warag aig bëenaa, i khĩirphee kanieu phõbkhanaa wiwiukhamuata, “Pʉʉn chadcha Ẽwandam Iewaau” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mamʉ Jesuu chi mepeenag meeurrau sĩiujeejim anaabá, thumaam khʉʉn jʉ̈gdaar mag ich jaau wënʉrram ugua. ");
INSERT INTO noaE_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mag Jesuu õor pöm monaau nʉrrarr khur durrsĩ gaai waaidʉwia ich dʉ̈i wënʉrrarr khʉʉn eem ichdëu khõsim khʉʉn ich aig thʉ̈rkha aujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mag ich aig thʉ̈rkha auwia mag õor khapan ich dʉ̈i wënʉrrʉm khʉʉn eem ichdëucha doce jʉr aujim aajem, ich iek õor ee jaau wënʉrramkhĩir pʉ̈yaag. Ich makhʉʉnta ich iek jaaujem khʉʉnkha thʉ̈rjim aajem, apostolnaan. ");
INSERT INTO noaE_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Maimua mag doce jʉr autarr khʉʉnag ĩchab ich jua theegjã deejim aajem, ich dënjö õor mor masim khʉʉn monaaunaa mor ee mepeer khaigbam sĩsidʉmpa jʉr wërpmamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mag ichdëu doce jʉr autarr khʉʉn thʉ̈r, mʉkhʉʉn ajim: Simón, (ichpai Jesuu Pedro a thʉ̈rjim); ");
INSERT INTO noaE_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, jöoi Zebedeo iewaa, (ichpai ĩchab Jacobo aajeejim); Juan, agjö jöoi Zebedeo iewaa, chi Santiago eeum; (Makhʉʉn Santiago Juan dʉ̈ita amach numwe Jesuu “Boanerges” a thʉ̈rjim aajem, am ibʉʉr wau thʉ̈r; mag “Boanerges” a sim aiguin, khõrg pagthʉmjö sĩerrjëem a simʉu.) Maimua mag tag ");
INSERT INTO noaE_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, (ichpai Leví a thʉ̈r sĩejim); Tomás, Santiago, chi Alfeo iewaa, (ichpai agjö Jacobo a thʉ̈r sĩejim); Tadeo, (ichpai Judas anaa Lebeo aajeejim); Simón chi Cananista, maimua ");
INSERT INTO noaE_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, (ich maguata ewag pawi thethem khʉʉnag Jesús pʉr deeju ajima, i thõomkhĩir). Mag ich khapeen ich dʉ̈icha ogdʉba wënʉrraju khʉʉn jʉrkha auwi degag bëejierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mag bëewi õrau i deg pabaichëm khaug athaawai i aig õor pöoma biirdʉbaadëjim aajem. Mag õor pöm bëe thʉnaawai bʉ̈ʉrjã jua par khabam gaaimua Jesujã thach khöba ni i khapeenjã pöd thach khöba naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús aar mag õor pöm jũrr phẽphẽeukham gaaimua pöd thachjã khöba sim a ũr athaawai chi khodnaanau i awaan wëtjierram aajem, lökiebaadeewaita mag thachjã khöba simpii awia. ");
INSERT INTO noaE_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mag nʉm dʉ̈i ĩchab Moiseeu Ẽwandam iek phã pʉatarr jawaag chi machnaan Jerusalén phöbör eemua bëetarr khʉʉnaujã i igwia, “Jãan dösãtnaan pör Beelzebú aajem dʉ̈i khapeerkha sĩewai ag juapaauta jãg õor mor eem mepeenjã dau daau jʉrkhʉʉi nʉrrabahab” anaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mamʉ am mag iekha nʉm ich Jesuu khaphʉ sĩerr aawai warag ich aig am thʉ̈rkha auwi amag, —Mua pãrag jëeu ookhimgui ajim anʉm: ¿Pãrau khĩirjuawai meperau ichdëupai wir aig ichjöm khʉʉn dawag jʉrkhʉʉiju khai? Meperau chan bën khaigbam chawag jʉrba aajemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gobiernoou khãijã õor pöm ich igar thʉnʉm jãrrcha thöonaa amach wir aigpai wërbʉpikhiin, amach wir aigpai öbapäaiwai mag gobierno ich mag nem jua theeg sĩerrabaju. ");
INSERT INTO noaE_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wa magbam khai, woun ãb ich chaain dʉ̈ipai meeukhawi amach wir aigpai wërbʉkhiin, warag aaidʉju. ");
INSERT INTO noaE_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ich agjöta simgui ajim anʉm, mepeerjã. Meperau wir aig amach eepai juurhi phiriupʉ̈ikhiin, magan warre amach öpʉ̈ijuuta ẽkha phöbaadëm. ");
INSERT INTO noaE_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Magnaa amag, ’Pãadë mʉ sëu awi wajapha khĩirjubat ajim anʉm. ¿Khaíu mʉg nʉm aig sĩi ãb jierrnem wajapham dʉ̈i ich di thʉa sim aig dubwi i nem jĩgkhaju khai? Sĩi khapanaam khʉʉnau wa i khãai ʉ̈rʉʉcharamua i ibʉʉr auwi khabam chan pöd i nem jĩgkhabam. Ich agjöta sĩebahab ajim anʉm, mepeerjã. Mʉ i khãai jua theeg khaba chirakhiin, muajã pöd õor mor eem mepeen jãg dau daau jʉr wërpbajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mag iekhamamua ich Jesuupai amag magjim aajem: ’Pãadë pãach jʉ̈gʉucha wajapha ũrbat cha mua jawaagpam: Ẽwandamaun chadcha õor khaibag thumaa chugpaaju, am parhoob iekhamarrpa thum. ");
INSERT INTO noaE_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mamʉ pekau ãb sim, maan mua Ẽwandam Akhaar jua theegau nem wau chitʉm oo nʉmta warag mepeer gaai thʉ nʉmʉu. Mag pekau chan Ẽwandamau bʉ̈ʉrjã perdonaabamgui ajim anʉm, i Akhaar igwiata mag iekha naawai. Magua Ẽwandam Akhaar igwiata mag khaigba iekhamʉn, mag wounan Ẽwandam dʉ̈i iekkhõr pöomata ich mag chirsijugui ajim anʉm, perdonaajã khaugba. ");
INSERT INTO noaE_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesuu amag mag iekhatarran, Moiseeu Ẽwandam iek phã pʉarr jawaag chi machnaanau ich Jesús igwia “Jãan Beelzebú dʉ̈i khapeerkha sĩewaita jãg nem jua theeg õor mor eem mepeenjã jʉrkhʉʉi nʉrrʉm” a iekha narr aawai ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mag nʉm ee ich Jesús ãd i eeugpeen dʉ̈i i aig bëejierram aajem. Mamʉ sĩi õor pöm thʉnʉm khurau pöd i aar dubba, daaugajãrpai nʉisiwia jũrr amach garmuata dawag i thʉ̈r naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Magbaawai i aig narr khʉʉnau irig, —Pʉ ãdau pʉ eeugpeen dʉ̈imua pʉ ʉ̈phʉʉinpa daaugajãr pʉ jʉr wënʉrrʉm, pʉ dʉ̈i iekhaag aajem a jaaujierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Magbaa ichdëu amag, —¿Chijã agá mag mʉ ãd, maimua chijã khʉʉn agá mag mʉ eeugpeen? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Magnaa ich bigaau ohoodö narr khʉʉnag eerpanaa magjim anʉm: —Chamʉ khʉʉnta mʉ ãd anaa mʉ eeugpeenau. ");
INSERT INTO noaE_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mʉrʉgan Ẽwandamau khõsimjö nem wau nʉm khʉʉnta mʉ ãd anaa mʉ ʉ̈phʉʉinau, maimua ĩchab makhʉʉnta mʉ khodnaanau ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Deeu ũmaai Jesuu Galilea thʉrrdö igaau Ẽwandam iek õrag jaaubaadëjim aajem. Mag irua jaau sim ũurwai, sĩi õor pöoma ich bigaau pos phʉʉrbaadeewai, aig bote sĩerr ee waaidʉwia, dö jãrraapai oo jöisijim aajem, jũrr mammua jawaag. Magbaawai õor pöm mag thʉnarrau durrpaimuata i iek ũr naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mag mos igaau õor pos thʉnʉmʉg ejemplodampa jaaumamua, —Mua pãrag nem ĩgkhaadam jaaukhim; wajapha mʉ iek ũrbat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Maimua magjim aajem: —Biek ãb, woun ãb trigo dau phöon majimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mag mawi chi nemjĩir dau irua phötarr, ãaurag bʉ̈ diichjem ee burrjim aajem. Magbaa nemchaain bëewia sĩi thumaa khökhʉʉipʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Maimua ãaur khʉʉn sĩi mokpör jojoodög eeta burrjim aajem, ajappai jẽb chukhu sĩerr ee. Makhʉʉnan chi tharrphëen ʉ̈u jöpcha tharrphëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mamʉ mag durrkhu ʉ̈rʉʉ sim iekhau pöd ierr khaar jẽrkhaba ʉ̈rʉʉta khaarkha khëkhëd arr aawai, ed pechag wʉʉbaadeeu, sĩi ë nanauk aadëmua phuabaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Maigmua ĩchab tagam phötarr, miudö arr ee burrwia, chi miiuta nemjĩir khãaijã bãau khaphí bãauwi, sĩi chi nemjĩirdam ichdëuta pör pʉrëu ich magpai dau aphʉʉ nʉisijim aajem, sirphʉg ee ag gaai jopjã jopba. ");
INSERT INTO noaE_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mamʉ tagam ʉ̈u jẽb wajaug ee burrtarran wajaug öbërwia ʉ̈u nem ajaug sĩi phur jopjim aajem, nem bich dapag maimuajã bich thʉʉ, maimua pogkha bich daii; mamʉ mag sĩsidʉm chan bʉ̈ʉrjã chi vano chukhu. ");
INSERT INTO noaE_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mag ĩgkha öbaadeewai aig ich iek ũr narr khʉʉnag, ’Keena, jʉ̈g ʉ̈rʉʉnaa chamʉg nem ĩgkhaadam mua jaaubarm wajapha ũrbat ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mag Jesús aig õor pos thʉnaawia ya õor jigdʉdʉ khabaadëm ee, õordam agtha i dakhapai i khapeen dʉ̈i ãba ohoodö narr khʉʉnau khap aag irig jëeujierram aajem: —Ma chaig pua nem ĩgkhaadam jaau sĩerrau ¿khani jaau simma? Marag jaaubá ajierram anʉm, wajapcha khaphʉ aag ithee. ");
INSERT INTO noaE_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Magbaa Jesuu amag magjim aajem: —Pãrau khaugam khõsi ũr naawai mʉchdëun warre pãrag khaphʉ api chirʉm, jãgata Ẽwandam õor thãar ee sĩeicheejẽ. Pari ar i iek bʉ̈ʉrpaijã ʉ̈khabam khʉʉnag sĩi nem ĩgkha nʉmuapaita jaaujemgui ajim anʉm, ");
INSERT INTO noaE_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","maagwai mag sĩi khajapham nem ĩgkhaadamjöpai ũurwai par amau amach jʉ̈gʉucha ũrnaa amach dakhĩir nem wau nʉm oo nʉmjã oobamjö amkhĩir; mag nʉm gaaimua Ẽwandamagjã amach khaibag chugpaapi jëeuba aawai Ẽwandamau am khaibagjã chugpaaba amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Maimua amag, ’¿Mʉg nem ĩgkhaadam merag chukhu khitʉmjã pãrau khaugbata nʉ? ajim anʉm. Mʉg phithur khaba simjã khaugba nʉm chan magan deeum nem jaaukhiinjã ¿pãrau jãga khaugjuma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cha mua nem ĩgkhaadam pãrag jaaubarmʉn mʉga simgui ajim anʉm: Chi nemjĩir dau phö nʉrrarr woun, woun ãb Ẽwandam iek õor ee jaau nʉrrʉmjöta sim. ");
INSERT INTO noaE_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maagwai mag chi nemjĩir dau õor bʉ̈ diichjem ee burrtarr, sĩi ar Ẽwandam iek jaau nʉm ũurjem khʉʉnta jaau simgui ajim anʉm. Mag ũrnaa bʉchkhun khaugtarrdam meperau bëewia pör eem warre khĩir akhoopibapäaiwai ũrba arrjöo thʉba nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Maagwai ãaur khʉʉn, chi nemjĩir dau ar mokpör jojoodög ee burrtarrjöta naabahab ajim anʉm. Ẽwandam iek õrau jaau nʉm amach jʉ̈gʉucha ũurwai warrpemʉn amau khõchag ʉ̈kha nʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pari mag chi nemjĩir wajap khaar khaba arrjö agtha Ẽwandam iek gaai ubʉ khaba naawai, mag Ẽwandam iek amachdëu ʉ̈kha nʉm gaaimua amach phithurg aunaa, bigaaum khʉʉnaujã amach dʉ̈i khaigbajujö aadeewai, sĩi warag agʉg oobamjö öbërwi weetjemgui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Maagwai ãaur khʉʉn sĩi nemjĩir dau miudö arr ee burrtarrjöta nʉmgui ajim anʉm. Amau ĩchab Ẽwandam iek ũrm khõsi ũr nʉm, ");
INSERT INTO noaE_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pari ãsie deeu ewag khĩirjuajerram. Am khĩirjugan ãba riknaan khajuuta khĩirju sĩsidʉm, nem thum paraa aag. Mag khĩirju sĩsidʉm gaaimuata ĩchab, mag nemjĩir sirphʉg ee aadeewai sĩi dau aphʉʉ chëba nʉisierrjö, Ẽwandam iekjã thãraucha ʉ̈khawi i ithee nem wajapha wawaagjã serbiiba thʉnaabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pari ãaur khʉʉn thʉnʉmgui ajim anʉm, ar Ẽwandam iek thãraucha ʉ̈khawi, i dau na agchanaa, nem wajapha waaujem khʉʉn. Magʉm khʉʉnau ar Ẽwandamau nem wajapha waupi jaauwaijã nem par daúa ooba aajem. Mag waum khõsi wau naawai amachdëu nem wauju ayagpierr waaujem: ãaur khʉʉnau nemjĩir chi chëmiejö dʉ̈rrcha, ãaur khʉʉnau agpierrpai, maimua ãaur khʉʉnau bʉchkhunpai. Mamʉ thumaam khʉʉnau ichiita ichdëu khõsimjö aajem a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mag jaautarr khur amag magjim aajem: ’Pãrau oowai, ¿khaíu õtdau paanaa sĩi bathẽe eegar wa nem bʉ̈ ee khãijã ausĩiujẽ? Õrau mag ausĩuba aajemgui ajim anʉm. Õtdaun paanaa dau garta ausĩiujemgui ajim anʉm, dau araraa oog. ");
INSERT INTO noaE_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ich jãgta sĩebahab ajim anʉm agjö Ẽwandam iekjã. Ĩswe chan õrau agtha wajappai khaugba nʉm, jãga Ẽwandamau õor peerdʉ auju. Mamʉ jãg õt bʉ̈ʉg nem oowai dawaa oojemjö, mʉg atagta amau wajapcha khaphʉ nʉisijugui ajim anʉm. Chi mag khaugba nʉm khʉʉnan agtha khĩchag ee nem oo nʉmjöta nʉmgui ajim anʉm, bʉ̈ʉrjã khaugba. ");
INSERT INTO noaE_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Magwi ich Jesuupai, ’Jʉ̈g ʉ̈rʉʉnaa cha mua jaau chirʉmjö abat ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Maimua magjim aajem: Pãrau mua nem jaau chirʉmta pãach thãraucha ʉ̈kham khõsinaa, pör ee aunaa warag khaugam khõsi amʉn, ich Ẽwandamau agjö pãar pör öphër apiju, ich iek ajapcha khaphʉ amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ar chi thãar onee ũrm khõsi ũr nʉm khʉʉnag Ẽwandamau warag khĩirjug deejugui ajim anʉm, ich iek khapcha amkhĩir. Mamʉ ar ũrmaphapai ũr nʉm khʉʉn khĩirjug eemʉn, cha mua jaau chirʉmjö deeu ich iek sĩepiba, khecheu aumajugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mag jajawagmamua ĩchab ich Jesuupai, ’Pãrag deeum ejemplodam jaaukhimgui ajim anʉm, jãga aajẽ õrau mag mʉ iek ʉ̈kham khõsi ʉ̈khawi amach thãar ee aauwai. Mag mʉ iek amach thãar ee au nʉmʉn, woun ãbmua nemjĩir daudam jĩir sĩubarmjöta simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mag jĩir sĩubaawai tharrphëwia edaram magwe bãau ëëekham. Mamʉ mag bãau ëëekham chan chi jĩirtarraujã bʉ̈ʉrjã khaugba sim, jãga mag ich appai bãaumamua ʉ̈gthaa papagmá. ");
INSERT INTO noaE_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Maan mag simʉn, ya jẽb ee sĩewai chi jẽbëuta ich appaimua mag bãaupi sim khabahab. Nacha tharrphëwi bãau sim, maimua dʉ̈rrcha aadeewai bi phũphũid aadëwi ũũi jöisim. ");
INSERT INTO noaE_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maimua mag thʉnʉʉ awi ya phur aadëm. Mag phur aadeewai thumaam khʉʉnau ya khaphʉ nʉmgui ajim anʉm, thʉʉju aai aadëm. Magbaawai thʉʉwi deg paa thʉnʉʉujem. Ich agjöta simgui ajim anʉm ĩchab mʉ iekjã: Õrau khaugmampierr bãbãwagmamjöta sim, warag ich Ẽwandamau khõsimjö wënʉrraa khaphʉ paaukhamaawai. ");
INSERT INTO noaE_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesuu mag jaaumamua, ’¿Pãrau khaphʉ nʉ, jãga sim abarí Ẽwandam iek mua jaau chitʉm, maimua khanjöta sim a mua pãrag jaaubarkhiin? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mʉg mua jaau chitʉm iekhan, mostaza daudam woun ãbmua ich dikhu gaau jĩir sĩubarmjöta simgui ajim anʉm. Ichta nemjĩir daudam thumaam khʉʉn khãaijã bʉ̈rʉʉcha khitʉm. ");
INSERT INTO noaE_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pari mag bʉ̈rʉʉ khitʉmta jẽb ee jĩir khërbarmʉn sĩi pabʉ̈ pöm ãdëe bãaujem. Magbaawai nemchaain bëewi chi piu gaai amach di ëeujem. Ich agjöta simgui ajim anʉm ĩchab mʉg Ẽwandam iek mua pãrag jaau chitʉmjã: Mʉʉgwaiwe chan khapan khabata ʉ̈kha durrum; pari mag durrumuata warag nem pöm aaidʉbapäaiwai õor khapankham khʉʉnauta ʉ̈khaju a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mag ejemplodampa jaaumamuata Ẽwandamau maach peerdʉ aaujem iek Jesuu jaaujeejim aajem, magʉm gaaimua wajapcha khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mamʉ ejemplo chuk chan mag õor pöm wëjömʉg bʉ̈ʉrjã nem jaauba aajeejim anaabá. Mag ejemplodamaupa nem jaaumatarrta ich khapeen dʉ̈i amach appai aadeewain deeu wajapha amag jaaujeejim aajem, wajapcha khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ich ag edpai ya kheeuraa aadëm ee, Jesuu ich khapeenag, —Wëttarrau ajim aajem, dö khĩijãr thʉrrdö igaau. ");
INSERT INTO noaE_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Maimua chadcha õor aig narr khʉʉn phëpʉawi, ya ich Jesús bote ee waaidʉwia oo wëjorr aawai, chi khapeenau i joo arrjim aajem. Mag am wëtum dʉ̈i deeum bote aig narrjã agjö am dʉ̈i wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mag am döjãrr paaukha phöbaaderr agtha pöm khaba nʉm ee, phũ theeg wëbaadëmua sĩi phũasdau baupa jöisijim anʉm. Mag phũas baupa aadëmua bote ee phũasdau sog bëbëekhamua ya chi boteeu ãwatbajujö ierrpamaa ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mamʉ mag nʉm ee ich Jesús bote khua pörkhau gaai sĩiuba khãi jörrajim aajem. Magbaawai i khapeenau jãphierr nʉm iekhau i phiriupʉ̈iwia irig, —¡Maestro, phiidʉbá! Pua chan mʉg maach khöomamjã khaugbahab ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Magbaa Jesús phiidʉwia mag phũ theeg thʉnʉmʉg meeurrau sĩunaa ĩchab phũas meeukha thʉnʉmʉgjã “Thumbabaad” abaawai, warre döjã meuu sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Magwi ich khapeenagta, —¿Khan jãgwi pãar jãg atcha jãphierr nʉma? ¿Pãrau mʉ mʉg pãach dʉ̈i mʉ chitʉmjã khaugbata nʉ ajim anʉm, jãgcha jãphierraag? ");
INSERT INTO noaE_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jesuu amach dakhĩir mag phũas dʉ̈i phũpa meeukha thʉnarr thumba atham oowia dauderraa nʉm iekhau, “Keena, ¿mʉʉn khanim wounta jãg phũujã phũas dʉ̈imua i ipierraa nʉma?” a jëjëeu aajeejim anaabá amach wir aigpai. ");
INSERT INTO noaE_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mag khodjörröo awia Gadara durr phẽeubaimajierram aajem, ich ag thʉrrdö eepai thoom igar. ");
INSERT INTO noaE_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mag phẽeubaimawia Jesús bote eemua waaidʉwia durrpabaadëm ee, i khĩirphee woun ãb dösãt bënëu bar simta durr ujã aarmua i aig khaphig bëejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mag woun sĩi ujã ee õor aukheerjem jẽbdegpai sĩejeejim anaabá. Mag sim chan par õrau pʉr aunaa cadenau jʉ̈ sĩsiukhamjã pöd jʉ̈ wai naaba aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mag juapa theeg sĩewaita biek khapan parii õrau cadenau bʉ̈ jʉ̈naa juapa jʉ̈ sĩsiukhamjã, sĩi warag chi cadenta thʉrrëu pʉpʉa aajeejim anʉm, ni ãbmuajã pöd pʉr wai sĩeba. ");
INSERT INTO noaE_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mag simʉn edaram magwe sĩi pabʉ̈ eeta nʉrranaa ujã ʉ̈rʉm magwe nʉrraajeejim anaabá. Mag nʉrrʉmʉn sĩi parhooba ääagmamua mokdau juajã gar aunaa ichdëupaita ich phãrmaajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mamʉ mag nʉrrʉmua warpwe Jesús oo athaawai sĩi warag i simʉgta khaphig bëewia i khĩirphee phõbkhabaichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mag phõbkhachënaa thet wiiu anaa irig, —¡Jesús, cha Ẽwandam ʉ̈gthaa phuu nʉm Iewaa! ¿Khantheeta pua mʉ mʉg khaibag waubaichëma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chi wounau ich garmua Jesuug mag iekhatarran, maan Jesuu ya ag nawe chi mepeer mag woun mor ee simʉg chawag öbërpi jaautarr aawaita irua mag iekhajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Magbaa Jesuu irig, —¿Pʉ khan a thʉ̈ʉrjẽwi? ajim anʉm. Magbaa chi wounau, —Mʉʉn “Mepeen Phöbör” a thʉ̈ʉrjemgui ajim aajem, maar nem khapan sĩerrjëe aawai. ");
INSERT INTO noaE_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ich mag wounau irig ö bʉ̈rʉʉ aadëp aajeejim anʉm, maigmua warp chi mepeen jʉrkhʉʉipʉ̈im ugua. ");
INSERT INTO noaE_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Maig dakha durr bʉ̈khʉrr khũsnaan khapan phathau jʉr khö wënʉrrarr aawai ");
INSERT INTO noaE_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","chi mepeenau, —Magan ar chum khũsnaan khapan thʉnʉm aar maar pʉ̈iwi jũrr jãkhʉʉn khũsnaan eeta marag dubpi jaaubá ajierram anʉm Jesuug. ");
INSERT INTO noaE_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Magbaa chadcha Jesuu mag chi woun mor eem mepeenag öbeerpi jaauwi, jũrr mag khũsnaan khapan dos miljö narr eeta dubpi jaaubaawai, chadcha makhʉʉn eeta dubphöbaadëjim anaabá. Mag mepeen khaigbam pöm khũsnaan ee dubphöbaadeewai sĩi parhooba khaphig phöbaadëwi ithurmʉg ʉ̈rmua thʉrrdö ee dʉrbagkha sĩi dö ee jogaa khëchdubjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mag oobaawai ajap jãphierrwi chi thʉa narr khʉʉn parhooba khaphig phöbaadëjierram anʉm, õrag jawaan. Mag wëtwi phöbör eejã jaauwi maimua phöbör igaau di ããbdö nʉnʉidʉm eem khʉʉnagjã thumwe jaaumajierram aajem. Amachig mag jaaumaawai ag bʉ̈rre õrau aar oon weetjeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mag wëtwia Jesús aar barimawia ooimaawai, chi woun mag dösãt dʉ̈i sĩerr khajũa wajapha jũawia maach khĩir ich mʉg jup oo sim ooimajierram anaabá, sĩi magʉm bën khaigbam pöm mor ee chukhu sĩerrjö, monakha. Mag oowai õor dauderraa naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mamʉ mag amach daúacha Jesuu mag woun bën chugpaapʉ̈iwia chi khũsnaanjã lökiewi dö ee jogaa khëchtarr orr khʉʉnau jũrr deeum khʉʉnag nem ĩgkhamajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Chi ag perás joobaajerr khʉʉnau mag ũrbaawai Jesuug jajaau aajeejim anʉm, amach durrmua chawag mamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mag ich jʉrbaadeewai, deeu maag awi, ich bëetarr boteeg mawi ag ee waaidʉbaadëjim aajem. Mag i mam oobaa mag chi dösãt bën wai sĩerrau ich arrmkhĩir irig jëeujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pari Jesuu ich dʉ̈i arrbajim aajem. Sĩi irig warag, —Pʉch diig mawia pʉch khodnaanag jaaubamí ajim anʉm, jãga Ẽwandamau ʉ̈u pʉ dau ee aug khaugwia pʉ monaaubar. ");
INSERT INTO noaE_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jesuu ichig magbaawai chadcha i ipierr mawia Decápolis durr phöbör nʉnʉidʉm ee õrag jaaumajim anʉm, Jesuu i dau aug khaugwi ʉ̈u i bën chugpaatarr. Mag jaaumam ũrwi thumaam khʉʉnta jʉ̈gderraa naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mag chadcha Jesús deeu Gadaramua dʉrbawia, thoom igar nacha ich sĩerr aar barbaimaawai, õor pöm i bigaau phʉʉrbaadëjim anʉm. Magbaawai pöd durragjã maba, ich aigpai dö igaau sĩsijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mag õor pöm phẽphẽeukham ee, woun ãb Jairo a thʉ̈r sim i aig bëejim aajem. Mag jöoi judionaan Ẽwandam iek jaaujem deg chi pörnaan thʉnʉm eem ajim aajem. Mag bëewia, Jesús bʉ̈khʉrr phõbkhachëwia, ");
INSERT INTO noaE_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","chaigpamamua, —Mʉ khaan parba jã eemuapai khërʉmta oo pʉajim, mʉ di aar marraugui ajim anʉm. Mua khaphʉ chirʉm, puata mʉ kha jua pʉrmʉn ʉ̈u i peerdʉ aujugui ajim anʉm ich Jairoou. ");
INSERT INTO noaE_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mag Jairoou ich di aar ëeurrbaicheewai Jesús chadcha i dʉ̈i majim aajem. Mag i mam dʉ̈i ĩchab õor pöm i ẽudee phẽeudʉ wëtmajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mag õor khapan pos wëtum ee ʉʉi ãb sĩejim aajem, doce años sĩi phõmieu bar sim. ");
INSERT INTO noaE_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mag khitʉmʉn wajap ʉʉi dau aug waaujeejim anʉm, doctornaanag ich monaaupiju ẽkha nʉmjã pödba aawai. Parii bënhë gaai ich phatkhondam wai khërarr thum gastaapʉ̈itarrjã bʉ̈ʉrjã monaauba, waragta eeg pamaa ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ich mag ʉʉyau ũr athajim anʉm, Jesuu õor mor masim khʉʉn monaau nʉrrʉm. Ichdëu mag ũrbaawai i aar õor pos thʉnʉm ee thet phẽeudʉ mawia ëugarmua meraa i khajũa gaaipai sĩi pʉrimajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Irua mag meraa pʉrimatarran, ich ödegpai, “Sĩi mua i khajũadam gaai pʉrbarmuapai mʉ monaau ʉisiju” a khĩirjuwiata mag pʉrimajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mag chadcha irua Jesús khajũa gaai pʉrbarm bʉ̈rre chi phõmie mag thʉnarrjã warre thʉbabaadee warre ich mag monaau sĩsijim anʉm. Magbaa ʉʉyau ĩchab warre ich kha jʉʉubaadëmjã khaug athajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mamʉ ĩchab mag ich gaai pʉrbaichëm bʉ̈rre Jesuu khaug athajim anʉm, Ẽwandam juapá ich gaai simua ʉʉi ãb monaaubapʉ̈im. Magbaa Jesuu mag õor pos thʉnʉmʉg eerpanaa, —¿Khaíuta mʉ khajũa gaai pʉrbaichëma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Magbaawai jũrr ich khapeenaupai irig, —¿Jãga mag khaíuta mʉ gaai pʉrbaichë aju? Pua oobahab, õor khapan pʉch aig phẽphẽeukham. Mag nʉmʉ mag “Khaíuta mʉ gaai pʉrbaichë” a sĩeb ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mamʉ mag jëeu buburrkhamjã ni ãbmuajã ichig jaauba aawai ich bigaau õor nʉm khʉʉnagta oophʉʉrdʉdʉ aajeejim anʉm, mag ich khajũa gaai pʉrchëtarr ookhaawai. ");
INSERT INTO noaE_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mamʉ mag meraa i gaai pʉrtarrta ich khaug athaawai jãphierr nʉm iekhau sĩi kha duui Jesús aig bëewia i khĩirphee kanieu phõbkhabaichëjim anaabá. Magwi chadcha meerba jaaujim anʉm, mag ichdëu i khajũa gaai pʉrtarr. ");
INSERT INTO noaE_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mag ichig meerba jaaubaawai Jesuu irig, —Mua pʉch monaauju khaphʉ mʉ gaai pʉrchëtarr gaaimua, ʉ̈u pʉ monaauwi peerdʉjã peerdʉ ʉisimgui ajim anʉm. Ya pʉ monakha ʉisiewai pʉch diig maju aai ʉmgui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús agtha mag iekha dʉnʉm ee, mag judionaan Ẽwandam iek jaaujem degam chi pör Jairo anʉm di aarmua õor bëewi irig, —Kakë, ya aaunaanaujã pöd ãwatba abarm; idëu Maestro sĩubá ajierram anʉm irig. Ya par maach aar i mabajup ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pari Jesuu amau mag jaaubaichëmjã asekasba, chi Jairoogta, —Oob khĩirjum; sĩi mag khãai warag pʉch chaai oo wai chitaju khĩirjugta wai chirsí ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Maimua ya warag Jairo dʉ̈i i di aar mam arr aawai ich mam dʉ̈i õor khapan arrbajim aajem. Ãba ich dʉ̈i arrtarr khʉʉnan Pedro dʉ̈i Santiago ajim aajem, maimua Juan; makhʉʉn thãrjuppai arrjim aajem ich dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mag wëtwia di aar barimawia ooimaawai Jairo deg sĩi bĩep sereu thʉnʉm dʉ̈i õor phogdʉ thʉnʉmjö thʉnʉm ee jũrram khʉʉnau ʉ̈apëpërkhamta ũrimajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Magbaa ich Jesuu ierr mag am sereu thʉnʉm aar dubwia amag, —¿Khantheeta mag atcha sereu thʉnʉ́ma? ajim anʉm. Oob bĩemiet. Chaai meeba sĩi khãi khërʉm khabahab ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mamʉ Jesuu mag chaai meeba sĩita khãi sim abaawai aig narr khʉʉnau warag i wau iekha naajim anaabá. Mamʉ ich gaai iukha nʉmjã am iek asekasba, warag thumaam khʉʉnag dawag öbërpi jaauwi, chi binaandam dënnaan maimua ich khapeen thãrjup ich dʉ̈i phë arrtarr khʉʉnpaita ich dʉ̈i ierrag dubpijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mag chi binaandam aar dubwi, i juadam gaai pʉr aunaa irig, —Talita, kum ajim anʉm. (Mag sim aiguin maach meúan, “Ʉʉikhaardam, phiidʉbaad” a simʉu.) ");
INSERT INTO noaE_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Magbarm bʉ̈rre chadcha phiidʉwia õor dakhĩir monakha dʉr nʉnʉʉu khabaadëjim anaabá. Mag oobaawai chi dënnaan maimua ich Jesús khapeenpa warre dauderraa nʉisijim anʉm. Ich mag chi daupeerdam Jesuu phiriu autarr, doce años sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mag phiriu auwi chi chaairag thachdam deepi jaaujim anʉm, khömkhĩir. Mamʉ mag daupeerdam ichdëu phiriu autarr chan bʉ̈ʉrjã aig narr khʉʉnag jaaupibajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mag chaai chi meem arrta deeu phiriu auwia, Jesús ich bãautarr durr phöbör Nazaret anʉmʉg petajim anʉm. Mag i petam dʉ̈i i khapeenjã i dʉ̈i wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mag mawi barimawia, ya jua ʉ̈ʉijem ed pabaadee, maar meeun Ẽwandam iek jaaujem deg mawi Ẽwandam iek jaaubaadëjim aajem. Mag irua jaaumam ũrwia aig õor pöm thʉnarr khʉʉnau jʉ̈gderraa nʉm iekhau amach wir aigpai jëjëeukhamua mag naajim anʉm: —¿Magʉm iek ichdëu jamta khaugjimta mag iek pöm jaaumáma? ¿Jãga jãg õor monaau nʉrrʉ́ma? anaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Keena, pãrau oowai, ¿ich mʉg woun kalpinter khabá anaajim anʉm, María iewaa? I eeugpeenauwai, Santiago, José, Judas maimua Simón. I ʉ̈phʉʉin khabahab ĩchab ar mʉig ich mʉg phöbör ee naajem khʉʉn; maagwai ichjã maadëu khaphʉ nʉm, ich mʉiguim aawai. ");
INSERT INTO noaE_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pari magbaa Jesuu amag magjim anʉm: —Chadcha deeum durram khʉʉnaun mʉg Ẽwandam iek jaau wënʉrrʉm khʉʉnag eenaa am dʉ̈i ajapha aba aajeeb. Pari mag sim jũrr dich bãautarr durrpai chan am kha khõchkhabanaa amach khodnaanau ni amach dʉ̈i ãbam deg joobaajem khʉʉnaujã am kha isëe aajemgui ajim anʉm amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mag warag maig chan Jesuu õor mor masi narr khʉʉn thum jua pʉrbajim aajem, amachdëu mag irua jaau sim ʉ̈khaba arr gaaimua. Daudam khapan khaba ichdëu jua pʉrtarr khʉʉnpai monaaupʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mag ichdëu Ẽwandam iek jaau khitʉm ʉ̈khaba nʉm oowi ich Jesúpata warag thumaa khĩirjuwi ökhĩirjuu aadëjim anaabá. Magbaawai ichta warag mawi jũrr aigmua phöbördam dakha sĩsidʉm ee Ẽwandam iek jaau nʉrraajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mag nʉrrʉmua Jesuu biek ãb ich khapeen doce ich dʉ̈i ogdʉba wënʉrraajerr khʉʉn ãbam aig thʉ̈rphë auwi nunumdö pʉ̈yaagpajim aajem. Mag pʉ̈yaagpamua ĩchab ich juapa theegjã amag deemajim anʉm, mag juapaau õor mor eem dösãt bën khaigbampa ich dënjö jʉr wërpmamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Magwia ĩchab khʉd ee khömaagjã bʉ̈ʉrjã amag nem inag arrpiba, ni talegdijöm, thachjöm, ni phatkhonjã arrpibajim aajem. Ãba arrpitarran bordondampaita arrju aai nʉm ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ich agjö zapatjã amachdëu jũa narrdampai arrpiwi khajũajã amach mor gayam dʉ̈ipaita wëtju aai nʉm a jaaujim aajem, deeum theg jũjũa aagjã arrba. ");
INSERT INTO noaE_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mag jaauwi ĩchab, —Pãach wënʉrrʉmpierr pãachig di jaaubarm degpai kheeupaawai khãibat ajim anaabá, pãach maigmua chawag wët nʉm ora. ");
INSERT INTO noaE_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dëgölp khãijã õrau amach deg pãach dubpiba abaawai, wa pãachdëu amachig Ẽwandam iek jaau nʉm khãijã ũrba abaawai, warre amach dakhĩirwe pãach bʉ̈ gayam jẽb ʉʉrphë ʉʉrphënaa pãachta ërëubaadët ajim anʉm. Pãrau magmʉn magbarmuapai amag, “Pãach jãg Ẽwandam iek ũrba abarm gaaimua ich dʉ̈ita khĩir khaphʉ abat” anʉmʉugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amachig magbaawai chadcha ërëubaadëwia phöbörpierr õrag Ẽwandam iek jaaumamua, “Pãach pekau pöoma nʉm ãsie ewag khĩirjuwia Ẽwandamagta chugpaapi jëeubat” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mag jaau wënʉrrʉmua ĩchab dösãt bënëu baarjerr khʉʉn mor eem bën khaigbampa jʉr wërpnaa, pabʉ̈ olivo anʉm khaúa õor khamor masim khʉʉnjã kha phurnaa, Ẽwandamag jëeubaa õor pöm monaaupʉ̈i maajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesuu mag õor mor masim khʉʉn pöm monaau nʉrrʉm gaaimua sĩi õor ee thʉ̈rphöo sĩejim aajem. Mag nʉm ee Rey Erodeeu ũr athajim anʉm, irua nem wau nʉrrʉm. Mag ichdëu ũr athaawai Jesuuta Juanpii awi, “Maan Juan õor pör choomie khararrta deeu iiu phiidʉwia mag nʉrrʉm; maguata mag õor mor masim khʉʉnpa monaau nʉrrabahab” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mamʉ irua mag sim ee bigaaum khʉʉnau, “Jã warr jöoingar Ẽwandam i jaaumie Elías aajerr khabahab” aajeejim anʉm, Jesús igwia. Mamʉ jũrr magbaawai ãaur khʉʉnau, “Jã sĩi warr jöoingar Ẽwandam i jaaujerr khʉʉnjö Ẽwandam iek jaaujem khabahab” aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jũrram khʉʉnau mamagkham ũrbaawai chi rey Erodeeu, “Mʉrʉg chan ma chan deeum khabam. Mua khĩirjuawain maan Juan chi õor pör choomieu, ar mua i ö thʉappʉ̈ipitarr. Ichta deeu iiuwia mag nʉrrabahab” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Irua mag sĩerran mʉg ajim aajem: Maata ich Erodeeu ich naam Felipe ʉʉi Erodías anʉmta khecheu auwi ag dʉ̈i sĩejim anaabá. Mag itheeta Juanau chi reíg, “Pua pöd pʉch naam jua eem ʉʉi khecheu auwi pʉch ʉʉikha auju khaba simgui” ajim anʉm. Mamʉ sĩi ichig magbaawai warag Juan pʉr aupi jaauwi, cárcel deg phãar sĩupinaa, cadenau jʉ̈ sĩupijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mamʉ mag nʉm ee chi Erodes ʉʉi Erodías anʉmuan Juanau mag iekhatarr gaaimua thõopimjã khõsi thʉnaajim anaabá. Pari mag nʉmta pöd thõoba aajeejim anʉm, mag chi jayau thõomkhĩir jaaubam aawai. ");
INSERT INTO noaE_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mag nʉm dʉ̈i chi rey Erodeeujã Juan ökhö aajeejim anaabá, irua oowai Juanau chadcha Ẽwandam dau na nem agcha waunaa ãba i iekpai jaaujerr aawai. Maguata Juanau ichigcha ikhʉaba iekhamamjã magʉmjã igba, warag ũrm khõsi i iek ũrnaa sĩi ich ödegpai, “¿Jãgata akhiina?” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mag nʉm ee Erodeeu ich año cumplii nʉm ed phiejãb pöm waupijim aajem, phiesta khaag. Magwi chi thethemnaan ich garcharam khʉʉn dʉ̈i, comandantenaan maimua Galileapien agjö chi thierrnaanpa ãba thʉ̈rkhʉʉipʉ̈ijim aajem, ich aig thach khoon bëemkhĩir. Magbarm eeta ĩchab Erodiaaujã Juan khaibag wauju dawaa phithurg chukkhu oo athajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mag am thach khö nʉmta, chi Erodías kha bëewia õor dakhĩir jemkhabaichëjim anʉm. Mag jemkhabarm chi reíu ich dʉ̈i ãba thach khö narr khʉʉn dʉ̈imua khõigjierram aajem. Mag wajapha jemkhabarm oobaawaita chi reíu ich bãaurrag, —Pʉchdëu nem khõsim mʉrʉg jëeubá, mua pʉrʉg deeju pʉchdëu nem igbarm ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mamʉ mag ichig nem jëeupipikhamjã chi dauperau bʉ̈ʉrjã jëeuba aawai ichdëuta deeu pʉaba irig, —Chadcha mʉch imeerba parhoobam nem pʉchdëu khõsim mʉrʉg jëeubarm mua pʉrʉg deebajupa. Pua mʉg durr mʉchdëu jʉ̈a chirʉm eem jãrrcha khãijã mʉrʉg jëeukhiinjã, ichiita mua deeb khaba pʉrʉg deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Chi rey Erodeeu pʉaba ichig mag jëeupipikhamjã jëeuju khaugba aawai ich ãd aar mawi jũrr ich ãdagta jaauwimajim anaabá, ichig khĩirjugdam deemkhĩir. Magbaa chi ãdau ich khaag, —Pʉchig Juan pörta thʉapnaa thëp ee deepi jaaujuma ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ich ãdau ichig mag jaaubarm bʉ̈rre deeu ich bãaurr jöoi aar mawia irig, —Rey ajim anʉm, muan nauwe pʉrʉg Juan õor pör choomie pörta thʉapwia mʉchig thëp ee deepim khõsi ʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mamʉ ich bãaurrau mag ichig Juan pörta jëeubaawai chi rey warre ökhĩirjuu aadëjim anʉm. Pari mag ich bãaurrau ichdëu nem khõsim thumwe jëeuwiajã õor dakhĩir ich imeerba deeju a iekhatarr aawai mag ãsie deebamjã abajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Magbaa ag bʉ̈rre ich soldaaun ãb pʉ̈ijim anʉm, Juan ö thʉapnaa ich aig chi pör appai aibëemkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Magbaawai chi soldaaunau chadcha Juan cárcel deg sim aar mawia, i ö thʉappʉ̈inaa, chi pör appai thëp ee chi dauperag deechëjim anaabá. Mag ichig deebaicheewai jũrr ich ãdag deejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mag Juan cárcel deg pʉr wai narr ö thʉapbapʉ̈im a ũrbaawai i khapeenau chi mordam cárcel degmua arrwia aukhërthurjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Magtarr khur Jesús khapeen mag ichdëu pʉ̈itarr khʉʉn deeu i aig barchëjierram aajem. Mag bëewia deeu ãbam aig naaicheewai amachdëu õrag Ẽwandam iek jaaujerr dʉ̈i õor monaaumarrpa thum irig jaauchëjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mamʉ mag jũrram khʉʉn phẽphẽeukham gaaimua thachdam khoogpaijã bʉ̈ʉrjã jua par khaba narr aawai mag am nem ĩgkha öpinaa jũrr ich Jesuu amag, —Õor chukag ee maach appai jua ʉ̈yaan wëttarrau ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Magwia chadcha amach appai aig botedam sĩerr ee ërëubaadëjim aajem, õor chukag aar. ");
INSERT INTO noaE_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pari mag am wëtum õor khapankham khʉʉnau oopʉ̈ijierram aajem. Amachdëu mag oobapäaiwai, i barjujã khaphʉ narr aawai, jũrr khʉd ee khaphig phöbaadëwi, amachta i barju nawe bardʉtkhaimawia i nʉ naaimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Maimua barimawia ooimaawai chadcha õor pöoma pos thʉnaajim anʉm, i nawe. Õor pöm mag wëjöm Jesuu oowai i dau ee aphʉʉ durrajim anʉm, sĩi nemchaain papjã chukhu wënʉrrʉmjö narr aawai. Ichdëu mag oobaawai amag Ẽwandam iek jaau wai sĩi ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mag jaau simua ya kheeuraa aadeewai i khapeenau irig, —Ya edau khëumamgui ajim anʉm. Mag nʉmta maach chan thach khöjujã chukhu nʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Maach dʉ̈i mʉig õor pöm thʉnʉm khʉʉnag wëtpi jaaubá ajim anʉm, õordam di dakhapaim aar wa magbam khai phöbör dakham aar khãijã amach khoog thach për awaan wëtamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ichig magbaawai jũrr ich Jesuu amachigta, —Am pʉ̈iju khãyau pãachdëuta amag thach deejurauma ajim anʉm. Magbaa chi khapeenau jũrr irig, —¿Magan õor pöm mʉg wëjöm thum thach khöpiegan doscientos denariota pan gaaipai aupi sĩeb? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Magbaa Jesuu amag, —¿Pãrau pandam kharr wai nʉwi? ajim anʉm. Chukhu nʉm khai, õrag jëeu oobat, khaíu phiejãb waibëejĩ ich khoog khãijã, maimua mʉrʉg jaaubat ajim anʉm. Magbaawai chadcha wëtwi, õrag jëeu ohoogmamua ãbmua pandam cinco maimua ãwarrdam numí wai sim oobaawai, deeu i aig bëewia, ich mag irig jaauchëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Magbaa ich Jesuu õor khapan mag thʉnarr khʉʉnag phũak ʉ̈r khapanaa phʉʉr ohoodö juppi jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Amachig mag juppi jaaubaawai chadcha warphaa poso phʉʉr nʉnʉid, phʉʉr nʉnʉid, ohood aphöbaadëjim anʉm, amach khĩkhĩratdö pogkha chi khapanag cincuenta, maagwai pogkha cien; õor pöm mag thʉnarr thumaa ich mag ohood thʉnʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Magbaawai Jesuu mag pan cinco narr dʉ̈i mag ãwarr dau numí narrpa phë auwia, ʉ̈gthaag eerpanaa, Ẽwandamag ʉ̈u ajim anaa chi pan thorreunaa, jũrr ich khapeenag ʉapʉ̈imajim aajem, tagam khʉʉnag jigmamkhĩir. Ich agjö chi ãwarrjã agdaujö thumaam khʉʉnag jigpʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Magdamaupai maig õor thʉnarr khʉʉn thum biwaauwia imie phöbaadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mag imie phöbaadeewai chi pan ãwarr dʉ̈i sobtarrau thʉbʉt doce ipiirkha aujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mag chi thach khötarr khʉʉn khapanag emkhooin appai cinco mil naajim aajem, ʉʉinjã beerba chaainjã beerba. ");
INSERT INTO noaE_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mag thach khö aaipawia Jesuu ich khapeenag, —Pãar mʉ na thoom igar Betsaidaag dʉrbagkhabaadët ajim anʉm, maimua jam phöbör eeta mʉ nʉbaimat. Mʉʉn nau mʉg õor ërëu thʉnʉm thum oopʉ̈iwiata majugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Maimua chadcha mag õor wëtum khʉʉn thum oopʉ̈iwiata durrsĩ gaai petajim aajem, Ẽwandamag jëwaan. ");
INSERT INTO noaE_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mag ich khapeen bote ee ich na pʉ̈itarr aawai, ya khëubaadeewai, döjãrr wëtmajim aajem. Maagwai Jesús ich appai thʉbawi agtha durrsĩ gaai Ẽwandamag jëeu sĩejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mammua Jesuu oowai i khapeen amach juadamau ökhar ẽkha wëtmajim anʉm, khĩir garmua phũ theeg wë thʉnʉm ee. Mag amach juadamau ẽkha wëtum oobaawai ãspajuag am ẽkha auwimajim aajem, sĩi döjã ʉ̈rpai mamua. Pari mag am ẽkha autarrjã sĩi khajapha am aig dichaagpamjöo sĩejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mamʉ mag sĩi döjã ʉ̈rta nʉrrʉm oo athaawai akhaarpii awia jãphierr nʉm iekhau ääa khaphöbaadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ma chan mag ãbpaimuajã ooba, amach thumaam khʉʉnauta oo narr aawai, amach thumta jãphierr naajim aajem. Pari mag sereubaadëm bʉ̈rre ich Jesús garmua amag, —Keena, oob jãphierrmiet; mʉ khabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Magnaa am bote ee waaidʉbaadee chi phũjã warre thumbamamua thumbabaadëjim aajem. Mag oobaawai i khapeen warre dauderraa nʉisijim anʉm, ");
INSERT INTO noaE_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ag noram Jesuu amach dakhĩir pan ãwarr dʉ̈i khapanjã khaba narraupai õor pöm thʉnarr thach khöpitarrjã khĩir ee paba. Jesuu ich juapá oopi sim khaphʉ aju aai nʉmta warag magʉmjã khĩirjuba sĩita jãphierr naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Maimua warag ãba ërëubaadëwi thoom igar deeum durr Genesaret anʉm phẽeubagkhabaimaawai warre amach wëttarr bote jʉ̈ sĩujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mag jʉ̈ sĩuwia ya am durr paaukhabaadeewai aig õor narr khʉʉnau warre Jesús khaug athajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Amachdëu mag i khaugphöbaadeewai, amach dakham khʉʉnag i barbaichëm khap amkhĩir, jũrr jaau nʉrrjëe aphöbaadëjim anʉm. Amachdëu mag ũrphöbaadeewai phöbörpierr aaunaanpanau amach aaunaan pa bʉʉrkham gaaipa i sim aig aibëemajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús nʉrrʉmpierr phöbör ee didam khapan khaba nʉnʉidʉm ee maimua sĩi durr didam ããbdö nʉnʉidʉm eem magwe i na kaaijã ee amach aaunaan aubëenaa irig, —Maar aaunaanag pʉch khajũahidam gaaipai khãijã pʉrpibá aajeejim anʉm, monaaumkhĩir. Mag chadcha thum i khajũa gaai pʉrmam khʉʉnan warre monaaukha maajeejim aajem, mag sĩi pʉrbarmuapai. ");
INSERT INTO noaE_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Khãai ãb Jerusalén phöbör eemua Jesús aig bëejierram aajem, Moiseeu Ẽwandam iek phã pʉatarr wajapcha ʉʉrkhaajem khʉʉn dʉ̈i ich ag Ẽwandam iekpai jawaag chi machnaanpa. ");
INSERT INTO noaE_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mag bëewia amachdëu oowai i khapeen juajã ʉbata thach khö nʉm oobaawai ʉ̈u khabata nʉm ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Amau mag iekha narran, amach chi judionaan thum amach jöoin i pʉaba warrgarwe thach khoopierr ajapha jua ʉnaa khoojemta warm khʉʉnau ich jãg juajã sũgba khö narr aawaita mag iekha naajim anaabá. Maguata am meeun chan jua ʉb khaba chan thach khöba aajeejim aajem, Ẽwandam dau na amach ãrju awia. ");
INSERT INTO noaE_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maguata merrkau ee udthurwia bëeujã, amach jöoinau jaaujemjö, jua ʉba chan pöd thach khöba aajem aajem. Mag tag amau nem waaujem khĩir khapan thʉnʉm amach warrgarm khʉʉn jöoin i pʉaba, maguata amau thum amach dö doojem jarr, thëp, jiedöpjömjã thum ʉkhapʉ̈iwi ĩchab amach khãaijem putjã thum jãkhapäaijem anaabá.) ");
INSERT INTO noaE_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Amach ich mag sĩerrjëem khapta chi fariseonaanau maestronaan dʉ̈imua ich Jesuug, —¿Khan jãgwia pʉ khapeenau warrgurwe maach jöoinau jaaujem ipierraa khaba, sĩi juajã ʉba ich jãgta thach khö nʉma? ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mag ichig jëeubaa jũrr ich Jesús garmua amag magjim anʉm: —Pãach jãg Ẽwandam iek gayam pãachdëu nem jaaujemjö khaba jũrr ag chaaur nem wau sĩerrjëem khapta Ẽwandamau ich i jaaumie jöoi Isaías khararrag pãach igwia ich iekhatarr iek mʉg phãpijimgui ajim anʉm: “Pãran sĩi par iekhaupaita mʉ iek ʉ̈kha nʉm ʉ̈kha nʉm aajem. Pari mag nʉm chan par chadcha thãraucha ʉ̈khabamta mag sĩerrjëem. Pãach mag nʉm gaaimua pãar thãar chan mʉ dakhajã khaba, sĩi mʉ warpta thʉnʉm. ");
INSERT INTO noaE_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jãg nʉm aiguin parii pãach iphithur pãrau mʉrʉg jëeuju. Pãrau jaau nʉmjã sĩi wir aig pãach khĩirjugpaiu; jã mʉ iek khabam” ajim warrgarwe Ẽwandamau, pãar igwia. ");
INSERT INTO noaE_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Mag chirʉmʉn pãachdëujã Ẽwandamau nem jaau sim ipierraa khaba, sĩi pãach jöoin iigta ee am khõchgau warag irua nem jaau sim ichaaur sĩi pãach juagam nem ʉkhakha aju appai khap sĩerrjëe aawaita mag chirʉmgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Amag mag iekhapʉ̈iwi ichdëupai ĩchab magjim anʉm: ’Sĩi pãach jöoin iigta ʉ̈rcha ee am khõchgau pãrau Ẽwandam iek chaar gaai jaau simta warag asekasmapha aajem. ");
INSERT INTO noaE_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jãgju khapta warrgarwe jöoi Moisés khararrau, “Pʉch aai pʉch ãd dʉ̈i jãsenenaa ökhö abá” ajim anʉm. Maimua, “Ar iwiir ãbmua khãijã ich aai wa ich ãd khãijã thõpnaa ãaukha simʉn, maan warreta thõopʉ̈iju aai nʉm” a sim. ");
INSERT INTO noaE_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pari Ẽwandamau ich iek gaai mag jaau simta jũrr pãar iek mag ãbmua khãijã dich ayag wa dich ãdag khãijã, “Pãrau ig nʉm mua wai chirab mamʉ pöd mua deeju khabam, ya thum Ẽwandam itheem aawai” a iekhaju aai sim anʉm, dich dënnaan dau aug khaugba. ");
INSERT INTO noaE_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Magnaa pãar iek mag ya chi mag iekhabarmua chan mag dich dënnaan iwiir ãb khãijã dau aphʉʉ khërʉm oowiajã agʉg oobamjö aju aai sim aajem anʉm, bʉ̈ʉrjã agʉg ooba. ");
INSERT INTO noaE_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jãg pãach jöoin iigta ee nʉmua pãrau Ẽwandamau nem waupi jaau simta warag isegpʉ̈i nʉm khabahab ajim anʉm amag. Mag nʉmta ewagam khʉʉnagjã pãrau ich magta khaugpi wëtum; mamʉ magpaijã khaba, mag tag pãrau nem khaigba jaaujem nem khĩir khapan thʉnaabahab ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesuu mag iekhawia ich aig õor thʉ̈rkha aunaa amag, —Pãadë thumaam khʉʉnau mʉ iek wajapha ũrbat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mʉg jẽb gaai chadcha õor pekaudam paraa khithëem. Pari sĩi parhooba thach khö nʉmuapai chan Ẽwandam na õor ãrba aajem. Ẽwandam na õor ãrpiejemʉn pãach thãar ee nem khaigbam khĩirjunaa iekhaawaita pãachdëupai pãach ãrpiejemgui ajim anʉm.  ");
INSERT INTO noaE_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Magnaa amag, Jʉ̈g ʉ̈rʉʉnaa wajapha ũrbat ajim anʉm cha mua pãrag jaau chirʉm. ");
INSERT INTO noaE_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesuu õrag mag iekhawia ichta jũrr aigmua chaaug petajim aajem. Maimua ya deg paaukhabaimaawai chi khapeenauta deeu ich ag iekpai irig jëeu naajim aajem, amachig jaaumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mag ichig jëeubaawai jaaumamua, —¿Wa mag chan pãraujã agtha mag iek khaugbata naab? ajim anʉm amag. Mua khabá pãrag, “Sĩi thach khö nʉm gaaimuapai chan pekau paarpaba aajem” a chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Thachdam khö nʉmʉn sĩi buch eepaita sĩeimaajem, thãar eejã dubba. Mag buch eepai sĩewi chëbapäaiwai deeu chukhu aadeejemgui a jaaumajim aajem. Irua mag sĩerr aiguin Ẽwandamau maachig nem khömkhĩir deetarr chan ni ãbjã khaigba khaba sĩsidʉm a sim ajim. ");
INSERT INTO noaE_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mag iekhamamua pʉaba ich Jesuu amag, —Õor pekau paarpa nʉmʉn thãar eemua khĩirjug khaigbam öbër nʉmuata pekau paarpa nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","¿Khan jãgwia mag sĩ? Thãar eeta magʉm khĩirjugjã thum ompaa auwia mammuata dawag öbër thʉnaawaima ajim anʉm. Mammuata öbër thʉnʉm: dich ʉʉi khabam dʉ̈i khapes aju khĩirjug, nem jĩgkhaju khĩirjug, maimua õor thõoju khĩirjug. ");
INSERT INTO noaE_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Mag tag öbër nʉm: chikham nemta dich dënkha aum khõsi aju khĩirjug, deeum ʉʉin wauju khĩirjug, parhooba nem khaigbam nem wauju khĩirjug, chikham khũgurju khĩirjug, chikham ãaukha iekha nʉm, wir aig dich thö nʉm, maimua sĩi donjö khĩirjug chukhu nem wau nʉm. ");
INSERT INTO noaE_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Magʉm nem thum thãar eemua dawag öbërdʉtkha thʉnʉmuata Ẽwandam dau na õor pekau paarpapiejem a jaaumajim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesuu maig õrag jaau sĩewia petajim aajem, Tiro durr Sidón dʉ̈i nʉmʉg. Mag mawia õor aig jẽerimajim aajem. Mamʉ mag ich deg pabaimamjã õrag khaugpimapha sĩejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mag ich khaugpimapha sim ãba, ʉʉikhaardam thõthõrrsöm bënëu baarjerr ãdau mag i barbaimam ũr athaawai, Jesús aar mawia i khĩirphee kanieu phõbkhabaimajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mag ʉʉi deeum durr Sirofenicia anʉm durram ajim anaabá. Ich mag ʉʉirau Jesús aar mawia chaigpaimajim anʉm, ich chaai mor eem thõthõrrsöm bën öbeerpʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Magbaa, judionaan khabam khʉʉn chan agtha monaauju khaba chirʉm awi, Jesuu ich mag ʉʉirag ogthompai, —Idëu nacha Ẽwandam chaainta thachdam khöpi athá. Mua pua jaau simjö pʉ chaaita nacha monaaukhiin, mua oowai dich chaainag deeju arr panta khecheunaa saakienag deebarmjö ajugui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Magbaa chi ʉʉyau pʉaba, —Señor, pua jaau simʉn chadau. Pari iin saakienaujã chaain jua bigaau chi pichag mes eegar khʉimam khoojemgui ajim anʉm. Maagjeewai mʉ Israelpie ʉʉi khaba ʉab mamʉ, ¿pua mʉ chaaijã dau aug khaugbaju khai? ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Magbaata Jesuu irig, —Pʉch jãg iekha ʉm gaaimua pʉ chaai mor eem mepeer ya öbërbaadëm. Ya pʉ pʉch diig maju aai ʉmgui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mag Jesuu ichig “Pʉch diig maju aai ʉm” abaawai, chadcha mawia ooimaawai, i chaai chadcha monakha put ee werba jẽer sim ooimajim aajem, Jesuu jaautarrjö chi mepeer ya i mor eemua öbërbaaderr aawai. ");
INSERT INTO noaE_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mag chaai monaaupʉ̈itarr khur Jesús majim aajem, Tiromua Galilea thʉrrdöog. Mag mamua Sidón phöbör ee dichwia Decápolis durrjã agjö dichjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mag Galilea pabaimaawai õrau i aig waibëejim anaabá, woun ãb kach khĩsunaa meu khʉkhʉaa khitʉm. Mag chi waibëetarr khʉʉnau Jesuug chaigpaimajim anʉm, amach aaunaandam gaai pʉrbarmua monaaupʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Magbaawai Jesuu chi woun mag kachdam khĩsunaa meu khʉkhʉaa khitʉm ich ap chawag arrnaa, i kach ee jĩgpiriu phĩ oonaa, deeu ich jĩgpir gaaipai ichöoujã omnaa, jũrr i meukhĩir gaai jãrpʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Maimua ʉ̈gthaag eerpanaa, jãphö duraa ʉ̈inaa chi wounag, “¡Efata!” ajim anʉm. Mag sim aiguin maach meúan “¡Kach aardʉbaad!” a sim ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesuu mag iekhabarm bʉ̈rre mag kach khĩsu sĩerrjã warre kach aardʉbaadëm dʉ̈i chi meukhĩirjã agjö nem wajaug agua iekha sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Magbaawai õor aig narr khʉʉnag, —Mʉg mua jãg woun monaaubarm oob chikhamnag jaaumiet ajim anʉm ich Jesuu. Mamʉ mag amachig jaaupiba arr ãba, warag amachdëu jaaum aig jaaujeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mag oowia õor thum dauderraa nʉm iekhau i igwia, “Jesuuwan nem thum wajaphata wau nʉrraajem. Maguata kach khĩsum khʉʉnjã kach aardʉpinaa meu meraam khʉʉnjã wajapha iekhapimaajem” a iekha naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Biek ãb deeu ũmaai Jesús aig õor pöoma biirdʉbaichëjim aajem. Mag nʉm ee bʉ̈ʉrjã thach khöju chukhu narr aawai Jesuu ich khapeenta ich aig thʉ̈rkha aunaa amagta magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Õor pöm mʉg thʉnʉm mʉ dau ee dau aphʉʉ durrum. Ya khãai thãrjup pam am maach aigmua bʉ̈ʉrjã ogdʉba, thachdam khöjujã chukhu durrumgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ich jãg thachdamjã khöpiba amach diig pʉ̈ikhiin, khʉd ee wëtumua jãdaúa phʉrëuju, pöd amach di aarjã barba. Magʉm ãaur khʉʉn chará warpmua bëe nʉm aawai pöd barba khãijã ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mamʉ Jesuu amachig magbaawai jũrr chi khapeen garmuata irig, —Mʉg maach õor chukag ee nʉm, ¿jamaam thach maadëu amag deebarju? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Magbaawaita Jesuu amag —¿Pãrau pan dau kharr wai nʉ? abaawai, amachdëu, —Marau pandam sietepai wai nʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mag pan siete wai nʉm abaawai Jesuu mag õor pöm wëjömʉg, —Jẽkhʉt jupkhabat ajim anʉm. Magnaa mag pan siete narrdam jua ee phë aunaa, ag paar Ẽwandamag ʉ̈u ajim anaa thorreuwia, jũrr ich khapeenag ʉapʉ̈imajim aajem, mag õor pöm thʉnʉmʉg jigmamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mag dʉ̈i ĩchab ãwarrdamjã daudam khapan khaba wai narr aawai mag paarjã Ẽwandamag ʉ̈u ajim anaa jũrr deeu amag ʉapʉ̈imajim aajem, õrag jigmamkhĩir. Magbaawai chadcha chi khapeenau ichdëu jaautarrjö thumaam khʉʉnag jigpʉ̈ijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mag jig phʉʉrdʉdʉgmamua agdaujö amachdëu khöm aig khöwi, khʉd biwaau phöbaadee thumjã khöpʉ̈iba, thʉbʉt siete ipiirkha aujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mag khöjujã chukhu narr ee irua jãogtarr khʉʉn chi khapanag cuatro mil naajim aajem. Mag khö dichwi amachig wëtpi jaaubaawai, ërëubaadee, ");
INSERT INTO noaE_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ich Jesujã deeu bote ee waaidʉjim aajem. Magbaawai chi khapeenau deeum durr Dalmanutaag i joo arrjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mag mawia ya chi Jesús barbaimam khaugphöbaadeewai i aig bëejierram aajem, fariseonaan. Mag bëewia ogthom daau chadcha i Ẽwandamau pʉ̈itarrta jãg nʉrrʉm khai a khap aag awi irig, —Magan maar dau na ag na õrau nem ooba aajem nem waubá aichëjierram anʉm irig, marau oog ithee. ");
INSERT INTO noaE_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ichig magbaicheewai chadcha am ipierr waukhiinjã ich iek ʉ̈khabaju khap warag sĩi jãphö duraa ʉ̈inaa, —¿Khan atchata mua pãar dakhĩir nem wau chitajuuta pãrau mag mʉrʉg nem waupi jaau nʉma? ajim anʉm amag. Mua chan pãar dau na bʉ̈ʉrjã nem waubamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Amag mag iekhapʉ̈iwi ichta warag am aigmua petajim aajem. Maimua mag mawi ich khapeen dʉ̈i bote ee waaidʉwi ag khĩirphee dʉrbajim aajem, ich ag thʉrrdö eepai. ");
INSERT INTO noaE_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mag wëtumjã khĩir ee pab jap ee khoogjã khöju arrba awi pandam dau ãbpaita wai khodjörrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mag ërëu phöbaadëwia khodjörröm ee, Jesuu ich khapeenag, —Khĩir khaphʉ wënʉrrat ajim anʉm. Oob fariseonaan bën maimua Erodes bënjã jãg levadurajö sim pãach gaai dʉrbapimiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Amachig mag iekhabaawai amach khoog panjã chukhu naawaita mag iekha simpii awi jũrr wir aig amach eepai mag pan aubëeba arrta ig naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pari Jesuu amachig mag iekhabarmjã bʉ̈ʉrjã khaugba naajim aajem. Mag ichdëu iekhabarmjã khaugba warag sĩi ich ichaaur iyʉ̈ʉ nʉm khaug athaawaita amag magjim anʉm: —¿Pãach ödegan pãraun sĩi pan chukhum gaaimuata mua pãachig magjimpii naab? ajim anʉm. Mua maata pãrag jaauba chirʉm. Jãgan jãg nʉm aiguin pãrau chan mua nem waaujemjã agtha khaugbata naabma ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pãar dau paraanaa kachjã wai nʉm; pari mag nʉmta sĩi dau khĩsumjönaa kachjã khĩsumjöta nʉm. Pãrau mua nem wau chitʉm oojemjã, ¿khĩir ee paba nʉ, ");
INSERT INTO noaE_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ar pandam cincopai narrau mua õor cinco mil narr jãogtarr? Thumaam khʉʉn khö dichwia imie phöbaadeewai, ¿thʉbʉt kharr ipiirkha aujĩ, chi sob? Amachig mag jëeubaa i khapeenau, —Thʉbʉt khapan docen ãb ipiirkha aujimgui ajierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Magbaawai deeu ichdëu amag, —Maimua agjö ar pandam sietepai narrau mua õor cuatro mil narr jãogtarr edjã, ¿amau khötarr sob thʉbʉt kharr phë aujĩwi? ajim anʉm. Magbaawai, —Thʉbʉt siete ipiirkha aujimgui ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Magbaawaita ichdëu, —Chadma ajim anʉm. Mamʉ pan igju awiajã, ¿pãrau chan deeu mua ompaa aujujã khĩirjubata naab? ajim anʉm. Mua chan levadura chaar jaauba, fariseonaanau nem khaigba jaaujemta jaau chirʉm; pari mag nʉmta pãrau pöd khaug auba nʉmgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mag wëtmamua Betsaida phöbör ee barimajim aajem. Mag barbaimaawai õrau woun ãb dau khĩsu khitʉm i aig waibëewi irig chaigpachëjierram aajem, i gaai pʉrbaawai i dau monaaumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Magbaa Jesuu mag chi daudam khĩsu khitʉm jua gaai pʉrnaa chawag phöbör igaau arrjim anʉm. Mag arrwi i dau ichöou phuurnaa i gaai pʉrnaa irig, —¿Pua ʉ̈u oo chirʉ́wi? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Magbaa chi dau khĩsu khitʉmua, —Ëera, mua õor pabʉ̈jö sĩsidʉmta dʉrdʉr nʉrrjëem oo chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Magbaawai deeu Jesuu i dau ëudam aaithʉ aaithʉnaa irig, —Deeu dau ẽe oobá ajim anʉm. Magbaawai chadcha deeu dau ẽe oobarau warre warp dawaa ich mag oo sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mag dau khĩsu sĩerr monaau sĩsiewai Jesuu ich diig pʉ̈yaagpamua irig tag phöbör ee bëepiba jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús mag woun ãb dau khĩsu sĩerr monaaupʉ̈itarr khur ich khapeen dʉ̈i durr Cesarea de Filipo anʉm eem phöbördam nʉnʉidʉmʉg majim aajem. Mag wëtumua ich Jesuu amag, —Õrau mʉ igwia iyʉ̈ʉ nʉm ũurwai, ¿am iek mʉ khai aajẽ? ¿Pãrau ũrba aajẽ? a jëeujim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jesuu amachig mag jëeubaa chi khapeenau irig jũrram khʉʉnau, —Am iek pʉ Juan chi õor pör choomie aajem. Deeum khʉʉnau jaauwai, pʉʉta Elías aajem, warrgar Ẽwandam i jaaujerr. Maagwai pogkha jaauwai, pʉ sĩi warrgar agjö Ẽwandam i jaaujerr khʉʉn eem aajemgui ajierram aajem irig. ");
INSERT INTO noaE_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Magbaa jũrr amachigcha, —¿Ma pãachdëujãma? ¿Pãrau khĩirjuawai mʉ khai agá? a jëeujim anʉm amag. Magbaawai Pedroou, —Pʉʉn Cristoou ajim anʉm, warrgarwe ich Ẽwandamaucha jʉr auwia õor peerdʉ aumkhĩir pʉ̈iju jaaujerr. ");
INSERT INTO noaE_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mamʉ Pedroou ichig magbaawai, —Chadcha pua ag eyaa jaaubapʉ̈im, mamʉ oob bʉ̈ʉrjã chikhamnag jawam ajim anʉm. Warm khʉʉnagjã jaaupibajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Maimua Jesuu wir aig ichpai jaaumamua magjim anʉm ich khapeenag: —Mʉch chi Emkhooi Iewaa chadcha dau aphʉʉ aju aai chirʉm. Mʉ dau ãaukha isegwia Jerusalenpie jöoin chi thethem khʉʉnau phadnaan chi pörkha nʉm khʉʉnaupa Moisés iek jawaag chi machnaan dʉ̈imua mʉ thõomkhĩir pʉr deejugui ajim anʉm. Mamʉ amau mag mʉ thõowiajã khãai thãrjupam ee phiidʉwi deeu mʉ iiu chirsijugui a jaaujim aajem ich khapeenag. ");
INSERT INTO noaE_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mag, ich dau aug wauju ich khapeenag ũramkhĩir ajapha jaaumajim aajem. Mag irua iekhabarm ũrbaawai Pedroou Jesús chawag warrwia irig, —¿Khantheeta pʉ mag iekha sĩma? Õrau pʉ dʉ̈i magju khaba nʉmgui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pedroou mag iekhabaawai Jesuu tagam khʉʉn ich khapeenag ewag phʉʉrba eerpanaa jũrr Pedroogta khĩir masi, —Jöpkhaa mʉ aigmua chawag petá ajim anʉm. Pua chan Ẽwandamau nem waum ig simjã khaugba, sĩi parhoobam khʉʉnjöta khĩirju simgui ajim anʉm. Meperauta pʉrʉg mag iekhapi sĩebahab ajim anaabá irig. ");
INSERT INTO noaE_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Magwia Jesuu ich aig õor thʉnarr khʉʉn dʉ̈i ich khapeenpa ãba thʉ̈rkha aunaa magjim anʉm: —Chadcha pãrau mʉ iek pãach thãraucha ʉ̈kha nʉm khai, ed ëepierr magan mua nem waupi jaau chirʉm appaita waubat ajim anʉm, “Mʉchdëuta khap chirʉm mʉchdëu nem wauju” a iekhaba. Mʉ gaaimua chikhamnau dau aphʉʉ pãach thõoju khĩirjuwia khãijã, magʉmjã igba, waragta ʉ̈khanaat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ar chi mʉg jẽb gaai mʉ gaaimua bʉ̈ʉrjã phithurg aumapha wënʉrrʉm khʉʉn chan meem edjã ʉ̈gthar öbërbamgui ajim anʉm. Magarrau ar chi mua nem jaau chirʉm waum khõchgauta amach nemjã khĩirjuba sĩi warag mʉ gaaimua wa mʉg õor peerdʉajem iek gaaimua khãijã dau aphʉʉ anʉm khʉʉnan chadau ʉ̈gtharcha öbërjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Magnaa amag, Pãrau oowai ¿khan wajaug sĩ ajim anʉm, woun ãbmua mʉg durr thum ichdëupai jʉ̈a wai sĩsim, pari mag sim meebaadee khĩmie durr petam? ¿Irua ich durr thum ich dʉ̈i arrju aai sĩ? Pöd arrbam. ");
INSERT INTO noaE_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Khanta mʉg jẽb gaai atcha nem parhẽpagcha sĩerrʉ́ ajim anʉm, agua dich akhaar ʉ̈gthar phag wai öbëraag? ");
INSERT INTO noaE_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Maimua ãbmua khãijã ĩs mʉg õor pekau pöomanaa Ẽwandam iekjã thãraucha ʉ̈khaba thʉnʉm eeta mʉ gaaimua wa sĩi mʉ iekdam jaaujupai khãijã õor dakhĩir chigaa amʉn, mʉg mʉch chi Emkhooi Iewaajã thumaam khʉʉn Pörkhanaa mʉch Aai jua theeg dʉ̈i ʉ̈gthar i chognaan thʉnʉm khʉʉnpa mʉg durr chachaan bëem edjã ĩchab ich khĩircha eerpanaa chigaa warag, “Mua bʉ̈ʉrjã pʉ khaugba chitʉm” a iekhajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mag iekhamamua ĩchab, ’Mʉ cha iekha chirʉm iekhau ãaur khʉʉn cha mʉ iek ũr nʉm khʉʉn chan mʉchta nem jua theeg thumaam khʉʉn Pörkha bëeju edamjö aadëm oobam aigjã meebajugui a jaaumajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mag ich khapeen ãaur khʉʉnag amach daúa ich oopiju jaautarr khur seis días nʉm ee Jesús durrsĩ pöm sim gaai majim aajem. Mag ich mam dʉ̈i õor thãrjuppai phë arrjim aajem. Makhʉʉn Pedro ajim aajem Santiago dʉ̈i, maimua Juan. Mag wëtwi ya durrsĩ gaai nʉmta amau oo nʉm dakhĩraa Jesús khĩir chaaupabaadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Magbaadëmua sĩi i mor gayam khajũa jũa sĩerrpa bʉ̈ʉnaa phuumjö aadëjim anʉm ich bäpgau. Khajũa atcha bäphä magjö chan õrau bʉ̈ʉrjã jã auba aajem aajem. ");
INSERT INTO noaE_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Magbaadëm ee oowai warrgarm jöoin Moisés dʉ̈i Elíata iyʉ̈ʉ dʉnʉnʉihdʉ naajim aajem Jesús dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Amachdëu mag oobaawaita Pedro iek irua Jesuug mag chirajim anʉm: —Maestro, nem ajaug chi agamjö maar mʉig nʉm. Marau pãar ithee rãichdidam thãrjup ëu deeju: ãb pʉ ithee, ãb Elías ithee, maimua ãb Moisés ithee. ");
INSERT INTO noaE_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mamʉ Pedroou Jesuug mag di ëu deeju a iekhatarran, maan amach chi khapeenta jãphierr nʉm iekhau pöd iekhajujã khaugba aawaita irua mag iekhajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mag am jãphierr nʉm ee, dëgölp sĩi edjã eemua jʉʉnthumie baug bëewi, am jöodʉ athaicheewai, sĩi ag ee ierr paaukhabaadëjim anʉm. Magbarm ee woun iekjö, “Chamʉʉta mʉ Iewaa mʉchdëu jãsehne wai chitʉmʉugui” ajim anʉm, “õor peerdʉ aumkhĩir mʉchdëucha jʉr autarr. Irua nem jaau simta ipierraa abat” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Maimua deeu chi jʉʉnthumie chukhu aadëm ee, amau oowai i dʉ̈i mag õor numí narr ooba, Jesús ich appaita oo dʉnʉm oojierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mag durrsĩe naawia jerag wëdurumua Jesuu mag ich khapeen thãrjup ich dʉ̈i arrtarr khʉʉnag amachdëu ootarrjã deeum khʉʉnag jaaupiba, sĩi amach thãar eepaita khaphʉ apijim aajem, ich chi Emkhooi Iewaa meewia deeu iiu phiidʉ nʉm ora. ");
INSERT INTO noaE_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Magtarr aawai chadcha chi khapeenau bʉ̈ʉrjã õrag jaauba aajeejim aajem. Pari mag nʉmʉn wir aig amach eepain iyʉ̈ʉ nʉmua, —¿Ma khani maachig jaau sĩejimta mag i meewia deeu i iiu phiidʉju a sĩejĩma? aajeejim anaabá amach appai. ");
INSERT INTO noaE_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mag amach appai mamag nʉʉ awi alphin ichigcha, —¿Khan jãgwia Ẽwandam iek jawaag chi machnaanau jaauwai mag Ẽwandamau Cristo pʉ̈iju na Eliata bëeju aajẽ? a jëeujierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Magbaawaita Jesuu amag, —Chadma, chi machnaanau jaaujemjö, Eliata nacha bëema ajim anʉm. Pari mag i bëeju jaautarran, mag Ẽwandamau pʉ̈iju aajerr õrag nʉpi jaaumkhĩirta bëeju jaaujim. Pari Elían ya udthurjim. Mamʉ mag i udthuurwai, Ẽwandam iek phã sim gaai jaau simjö, õrau i dʉ̈i amachdëu ampierr awi warag i thõopʉ̈ijierram. Magtarr aawai ¿pãrau khĩirjuawai õrau mʉ dʉ̈ijã i dʉ̈i atarrjö abaju khai ajim aajem, ich jãg Ẽwandam iek phã sĩsidʉm gaai mʉch chi Emkhooi Iewaa igwia wauju a jaau simjö? ");
INSERT INTO noaE_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mag iyʉ̈ʉ wëdurumua tagam ich khapeen nueve narr aig pachënaa oowai, õor pöm warpham magwe phʉʉr thʉnʉm jãrrta Ẽwandam i jawaag chi machnaan garmua am dʉ̈i ijẽjẽbkham oochëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mag õor pöm thʉnarr khʉʉnau amach dakhĩir Jesús barbaichëm oophöbaadee onegau i khĩirphee pochag phöbaadëwi i dʉ̈i saludaa nʉmua, “Ʉ̈uchata jãg pʉ barbaichëm” ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mag chi machnaan garmua ich khapeen dʉ̈i ijẽjẽbkham oobaicheewai, —¿Pãar khan iekta ig nʉma? ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Magbaa mag õor pos thʉnʉm eemua ãbmua magjim anʉm: —Maestro, mua mʉch iewaa aibëejimgui ajim anʉm, i mor eem bënëu pöd iekhapiba sĩi ichʉp wai sĩewai, pʉrʉg warre jẽu werbamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mʉg khitʉm barbaadeewain sĩi jẽkhʉt bäjä aimaajem. Magbaadëmua sĩi isaphun bau aadëm dʉ̈i thet khierrpa kũkũerr khabaadëmua phithierrii aadeejemgui ajim anʉm. Mag bar nʉmua warag nem dau aauga pabaadëmgui ajim anʉm. Mua pʉ khapeenag jaaujim, amag mʉch chaai mor eem bën warre jẽupʉ̈imkhĩir. Pari ni ãbmuajã pödbajim a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Magbaawai Jesuu ich khapeenagta magjim anaabá: —Pãrau chan jãg chaai Ẽwandamau monaaupʉ̈ijujã khĩirjubata nʉm. Pãrau jãg Ẽwandam jua theeg simjã khĩirjubamjö nʉm, ¿ich jãgta sĩi mua ãwat chitaju aai chirʉ́ pãrau oowai? ajim anʉm. ¿Khan atchata pãrau mʉ pãach dʉ̈i chitapim ig nʉma ajim anʉm, ajapcha ʉ̈khaag? Magnaa, Mag chaai mʉ aig aipidut ajim anaabá amag. ");
INSERT INTO noaE_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Magbaawai chadcha chi chaai i aig aibëejierram aajem. Mag aipierrwai, chi chaai mor ee mag chi mepeer simua Jesús khĩir eerpa athaawai, sĩi eeupemjö ich bënëu barbaadëmua warre jẽkhʉt bäjä aimajim anʉm. Mag bäjä aimaa sĩi parhooba bʉ̈ thʉthʉg khabaadëm dʉ̈i ipëgchöo isaphun bau aadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ich dakhĩir magbaadeewaita Jesuu chi ayag, —¿Pʉ chaai jãg bënëu barbaaderr ya dʉ̈rrʉ̈ʉ sĩwi? ajim anʉm. Magbaa chi ayau, —Jãan ich bʉ̈rʉʉ khitʉwe ich jãg baarjemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Khar chará jãg barbaadëmua chi meperau õtdau eejã barpʉ̈inaa dö eejã barpäaijemgui ajim anʉm, i thõopäaig. Maagjeewaita mua pʉrʉg chaigpa chirʉmgui ajim anʉm. Pua ʉ̈u i monaaupʉ̈iju aai chirʉm khai, maar dau aug khaugwi mʉ chaai monaaubapʉ̈i ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Magbaawai Jesuu irig, —¿Jãgwi mag pua mʉrʉg “ʉ̈u i monaaupʉ̈iju aai chirʉm khai” a sĩwi? ajim anʉm. Ar Ẽwandam gaaita ʉ̈kha nʉm khʉʉn ithee chan bʉ̈ʉrjã phithurm nem chukhum. Maagwai puajã chadcha thãraucha ʉ̈khamʉn, pʉ chaaijã monaaubajup ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Magbaa chi ayau, —Muan chadcha ʉ̈kha chirʉmgui ajim anʉm. Mamʉ pua mʉch chaai monaauju khĩirjugta ʉ̈rcha mʉrʉg khĩirjupibá ajim anʉm, warag Ẽwandamag ʉ̈khaag. ");
INSERT INTO noaE_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mag nʉm ee Jesuu oowai ich aig õor pöm biirdʉdʉkham oobaawai chi chaai mor ee mepeer simʉgta meeurrau aadëwi, —Mepeer, pʉchdëuta mʉg chaai jãg kach khĩsunaa meu meraa wai simgui ajim anʉm. Magnaa, Mʉ iekhau jöpai chaai mor eemua öbërbaad, maimua tag i mor ee dubaag khabamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mag Jesuu ichig meeurrau aadeewai chi mepeer wiiu a baubaadëjim anaabá. Mag baubaadëmua chi chaai deeu ich bënëu barbaadëwi, jẽkhʉt bäjä aimawia, warre chi meemjö bʉ̈ʉrjã mimig chukhu apʉ̈ijim anʉm. Mag aig õor pöm pos thʉnarr khʉʉnau amach dakhĩir mag chi thõmjö aadëm oobaawai, “Chadcha ya meebaadëbahab” anaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mamʉ amau mag meebaadëm anʉm ee, Jesuu chi chaai jua gaai pʉrnaa ʉ̈gthaag phiriu athajim anʉm. Mag ich jua gaai pʉrnaa phiriu athaawai dʉ̈i phiidʉ warag bʉ̈jãau dʉnʉisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mag chaai mor eem mepeer jʉrpʉ̈iwi ërëubaadeeu, ya amach ap deg paaukhabaimaawai, iyʉ̈ʉ nʉmua Jesuug, —¿Khan jãgwi jãg chaai mor ee bën khaigbam wai sĩerr marau pöd öbeerpi aubajĩ? a jëeujierram anʉm chi khapeenau. ");
INSERT INTO noaE_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mag ichig jëeubaawaita, —Mua pãrag jaaukhimgui ajim anʉm: Jãg mepeer khĩir õor mor eemua jʉrpäaigan, jãan sĩi thachjã khöba ãba Ẽwandamagpai jëeu nʉʉ aawaita jʉrpäaijemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Maig naawia ërëu phöbaadëwia Galilea durr dichjim aajem. Mamʉ Jesuu mag õrau ich pʉr auwi ich thõoju anʉmta ich khapeenag jaau sĩerr aawai amach nʉmjã õrag khaugpimapha sĩejim aajem. Mag jaaumamua amag maagjeejim anʉm: —Mʉch chi Emkhooi Iewaan õrau chi thierrnaanag pʉr deeju. Mag pʉr deebaawai amau mʉ thõopʉ̈iju. Mamʉ mag amau mʉ thõojup mamʉ, ag khur khãai thãrjup nʉm ee deeu iiu phiidʉjugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mamʉ amachig mag jaaumamjã pöd i iekha sim khaugba aajeejim anaabá. Mag amachdëu pöd khaugba aawai jëwaag ẽkhaajeejim anʉm; mamʉ inagau awi ich mag jëeubajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mag iyʉ̈ʉ wënʉrrʉmua phöbör Capernaum anʉm ee barimajim aajem. Mag barwia ya deg paaukhabaimaawai ichdëu amag, —Maach khʉd ee daaig wëduraawai pãar ¿khan ata iyʉ̈ʉ wëduraa ajĩ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mamʉ amachig mag jëeubaawai, chi khapeenau ni ãbmuajã i iek ʉ̈khaba, sĩi khĩuu nʉisijim anʉm, khʉd ee wëdurumua chijãata amach eepai thumaam khʉʉn khãai ʉ̈rʉʉcha sĩ a chikham ipeer ahaug wëdurarr khap. ");
INSERT INTO noaE_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mag ich iek ʉ̈khaba abaawai am na jẽkhʉt jupwi dʉ̈i amach thum ich bigaau thʉ̈rkha auwia amag magjim aajem: —Ãbmua khĩirjuawai ichta tagam khʉʉn khãaijã ʉ̈rpai am khõsi sim khai, magan ichta warag thumaam khʉʉn khãaijã serbiibachanaa sĩi ich khapeen chogkhaju aai simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Magnaa chaaidam thʉ̈r auwia, am dakhĩir chi chaaidam jua ee jiir auwi amag magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Mʉg chaai agtha ich juau paba aawai serbiiba khitʉmjö õor thʉnʉm thum mua khõsi chitʉm. Pãrau mʉ dënjö mʉg khithëem ãb khãijã jãsenkhawia pãach di aig aumʉn magan pãrau mʉchchata khĩir jãsenkhabarmjö abarm ajim anʉm. Mag pãrau ʉdʉraa pãach aig mʉ baarpi nʉm aiguin magan pãrau mʉ Aaijã khõsi nʉmgui ajim anʉm, ichdëuta mʉ pʉ̈itarr aawai. ");
INSERT INTO noaE_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mag ũrwia Juanau, —Maestro ajim anʉm. Marau woun ãb oojim, mag wounau iekhamamua pʉ thʉ̈r thʉ̈rnaa õor mor eem mepeenag öbeerpi jaaubaawai chadcha öbeerpʉ̈i maajeejim. Mamʉ maarjö pʉ dʉ̈i nʉrraba aajemuata mag sĩewai marau irig tag õor mor eem mepeen jʉrkhʉʉipiba jaaujimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Magbaa Jesuu amag, —¿Khanthee pãrau irig magjierrá ajim anʉm, idëu õor jua pʉrpiba? Mag wounau mʉ thʉ̈r gaaita mag õor monaau nʉrrʉm khai, magan irua wajaphata nem wau sim khabahab ajim anʉm, mʉ ëugar khaigba jaauba. ");
INSERT INTO noaE_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maadëu nem wau nʉm oo simjã maach ichaaurjã khaba warag maach juapierr oo sim wounan, magan maan maach dʉ̈i sĩewaiu ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Maimua ich agjö ãbmua khãijã pãar Cristo khapeen aawai pãrag nemdam bʉ̈rʉʉm khãijã deebarm wounan, Ẽwandamau agjö irig nem wajapham deeb khaba deeju a chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Pari magba ãbmua khãijã mʉ chaai mʉg mʉ iek ʉ̈kha khërʉmta pekau ee burrpimʉn, Ẽwandam dʉ̈ita iekkhõr pöoma sĩsiju. Mamʉ mag Ẽwandam dʉ̈ita iekkhõr paarpaju khãai, ichdëupai ich ö gaai mokpör pömkham jʉ̈naa phũas ee baudʉkhiin ʉ̈ucha ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Maimua agjö pʉch juaupaita pʉ pekau waupi sim khai, ag garm jua warag warre thʉapbapʉ̈i. Idëu pʉ jua bisi Ẽwandam aar barwiajã ʉ̈u simgui ajim anʉm, pʉch jua numwe monakha khĩmie durr õtdau uu thõojã khaugba wëjöm ee maju arr khãai.  ");
INSERT INTO noaE_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mam chan mag õtdau uu thʉnʉmjã bʉ̈ʉrjã thõba ni ag eem ödömiejã khëchaa khaugba sĩerrʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wa pʉ bʉ̈ʉu khãijã agjö pʉ pekau ee burrpi sim khai, magan mag bʉ̈jã warag thʉapbapʉ̈i. Bʉ̈ numwe monakha khĩmie durr maju arr khãai, Ẽwandam aar bʉ̈ bisi öbërwiajã ʉ̈ucha simgui ajim anʉm.  ");
INSERT INTO noaE_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mam chan mag õtdau uu thʉnʉmjã thõba ni ag eem ödömiejã khëchba ich mag sĩerrʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wa pʉ daúa khãijã pʉ pekau waupi sim khai, magan mag dau warag jẽubapʉ̈i. Pʉch dau numwe monakha khĩmie durr Ẽwandamag pʉch barpʉ̈ipiju khãai, dau bese khãijã pʉʉta Ẽwandam dënkha simʉn ʉ̈ucha simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mam khĩmie durr chan ödömiejã khëchaa khaugba ich mag domkha thʉnʉm dʉ̈i mag õtdau uu thʉnʉmjã thõba ich mag sĩerrʉmgui ajim anʉm. Maguata muan pãragan, pekau waumaaugau dau chukhumjö oobamjönaa magʉm nem khaigbam wawaagjã jua chukhumjö abat a chirʉmgui ajim anʉm, bʉ̈ʉrjã wauba. ");
INSERT INTO noaE_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Mua pãrag mag chirʉmʉn, chikhamnau pãach thum pãar wajap dau aug waupiju aawaita mag chirʉmgui ajim anʉm. Mamʉ Ẽwandamau ʉdʉraa mag pãar dau aug waupi nʉmʉn, sĩi pãach ich dʉ̈i chadcha ubʉ wënʉrrʉm khai a khap aagta magpi sim. Pãar dʉ̈i mag sim aig, nemek mod ãrm ugua phö sĩiujemjö, mag phithur wënʉrrʉm gaaimua warag pãarjã agjö ich dʉ̈i ajapha wënʉrramkhĩirta pãar dʉ̈i mag simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Thakharan chadcha nem wajaphamʉu. Mamʉ mag sim nakha aadëkhiin, ¿khaíu magʉm thakhaar igju khai? ajim anʉm. Jãg thakharauta nem thum sĩpha apiejemjö abat, pãach khapeen dʉ̈i nem wajapha wau nʉmua agdaujö thumaa khõinaa wënʉrraag a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús mag Capernaum phöbör eemua deeum durr Judeaag mawia jũrr döjã Jordán igaau edau öbeerjemʉg petajim aajem. Mag amach ee pabaimam khaug auwi ich aig õor pöoma pos aicheewai ichdëu ag na õrag jaaujerrjö mag õor pöm thʉnʉmʉg Ẽwandam iek jaaubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mag nʉm ee fariseonaan i aig bëejierram aajem. Makhʉʉnau juau ogthom Jesús imeraa pʉr awaag awi irig jëeumamua, —¿Chadchata pua oowai maach emkhooinau dich ʉʉi pʉaju aai nʉ wa pʉaju khaba nʉ? a jëeujierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ichig mag jëeubaawai jũrr ich Jesús garmua amag, —Moiseeu Ẽwandam iek phã pʉarr gaai, ¿khan a jaau sĩwi? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Magbaa amachdëu, —Moiseeu jaauwain maadëu dich ʉʉi pʉaju aai nʉm a jaau pʉajim aajem. Sĩita ʉʉi pʉagpaawai wajapha ẽsap phãnaa ag gaai, “Ya mua pʉ pʉa chirʉm” a jaauju aai nʉmgui ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Magbaawaita Jesuu amag, —Pãadë khĩu ũrbat ajim anʉm. ¿Pãrau khaphʉ nʉ, khan gaaimua Moiseeu mag phã pʉajĩ? Irua mag phã pʉatarran, pãach jʉ̈g theeg sĩsidʉm gaaimuata mag phã pʉajimgui ajim anʉm, chadcha. ");
INSERT INTO noaE_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pari warrgarwe ich Ẽwandamau maach ompaawaijã emkhooi ʉʉi dʉ̈ita ompaajimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Magtarr aawaita emkhooi ich ʉʉi dʉ̈i pabaadëmʉn ich dënnaan kha ogdʉajemgui ajim anʉm, ya ich ʉʉi dʉ̈ita ãba nʉrraag. ");
INSERT INTO noaE_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ya magbarm aigmuan warran agdaujö amach appai naajerrta õor ãbpaimjö ich mag nʉisiejem. Ya mag nʉisim chan ya tag amach ããbdö nʉrrjëe aba, õor ãbpaimjö nʉisiejem. ");
INSERT INTO noaE_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mag warrgarwejã ich Ẽwandamauta mag papitarr aawai pöd iwiir ãbmuajã i ichaaur awi dich õor pʉaju khaba nʉmgui ajim anʉm Jesuu amag. ");
INSERT INTO noaE_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Maimua magtarr khur deg paaukhawijã chi khapeen garmuata deeu ich ag iekpai irig jëeu naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mag ichig jëeubaawaita Jesuu amag, —Ich ʉʉi pʉawia deeum ʉʉita au simʉn magan pekauta wau simgui ajim anʉm, ich ʉʉi chaar khabam dʉ̈ita mag sĩewai. ");
INSERT INTO noaE_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wa magba chi ʉʉirau khãijã ich jaai pʉawia deeum emkhooita aumʉn magan agjö pekauta wau simgui ajim anʉm, ich jaai chaar khabam dʉ̈ita sĩewai. ");
INSERT INTO noaE_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mag nʉm ee õrau Jesús aig amach chaain waibëe thʉnʉisijim aajem, am gaai pʉrnaa am kõit Ẽwandamag jëeumkhĩir. Pari mag jũrram khʉʉnau chaain waibëbëekham oowi jũrr chi Jesús khapeenauta chi aibëe nʉm khʉʉnag meeurrau sĩujierram aajem, tag aibëepimaaugau. ");
INSERT INTO noaE_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mamʉ amau mag õrag meeukha iekha nʉm oobaawaita Jesuu jũrr amachigta agjö meeurraunaa, —Idëu õrag amach chaaindam mʉ aig waibëepibat ajim anʉm. ¿Khanthee pãrau amag bëepiba jaau nʉ? Chi jöoin awiajã chamʉ khʉʉn chaainjö mʉ iek ʉ̈khakharrsö ʉ̈kha nʉm khʉʉnta mʉg jẽb gaaijã ʉ̈u wënʉrrawia ʉ̈gtharjã onee wënʉrrabajup ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mamʉ chi ʉ̈gthar öbërju khĩirju nʉm khʉʉnaujã mʉkhʉʉn chaain dënjö ʉ̈khabam chan pöd öbërbamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mag iekhapʉ̈inaa, Jesuu am dakhĩir warag chi chaain ich jua ee jiirkha aunaa, am pör ʉ̈r jua ausĩunaa, am kõit wajapha Ẽwandamag jëeumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Maigmua Jesús chawag maagpam ee, woun ãb i aig khaphig bëejim aajem. Mag bëewia i khĩirphee kanieu phõbkhachëwia irig magchëjim anʉm: —Maestro, pʉʉta chadcha maestro ajapham aawai pʉrʉg jëwaan bëejim: ¿Mua khani jãgju aai chirʉ́ ʉ̈gthar öbëraag? Mʉrʉg jaaubá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Magbaawai Jesuu irig, —¿Khanthee pua mʉrʉg chi ajapham a sĩ? Õor ajapham chan chukhum. Ajaphamʉn ãba Ẽwandamta ich appai ajapha sĩerrʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Pua khaphʉ sĩebá ajim anʉm, Ẽwandamau ich iek Moiseeg phãpitarr gaai: “Oob dich õor khabam dʉ̈i khapes am; oob õor thõom; oob nem jĩgkham; oob chikham ëugarjã sëukha nem ĩgkham; oob sëukha chikhamnaanjã khũgurm; maimua pʉch dënnaanjã jãsene abá” a sim? ");
INSERT INTO noaE_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Magbaawai chi woun mag irig jëeuchëtarrau —Maestro, mʉch bʉ̈rʉʉwe mag pua jaaubarm thum mua ʉʉrkha chitabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mag wounau mag iekhabaawai Jesuu i dau ee aug khaug paraa eerpanaa irig, —Mamʉ agtha pua nem khĩir ãb wauju waaur wai sĩebahab ajim anʉm. Pʉch diig mawia, nem thum pʉchdëu wai sim përkhʉʉipʉ̈inaa, mag phatkhon jũrr dau aphʉʉ khithëem khʉʉnag thum jigbapʉ̈i ajim anaabá. Maimuan chadau mʉ ẽudee pidú ajim anʉm, chadcha mʉ dʉ̈i chitam khõsi chirʉm khai. Pua magmʉn ʉ̈gthar pawiajã bʉ̈ʉrjã augchëba phatkhon khãai nem ajapham pömta wai chirsijugui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesuu ichig mag iekhabaawai warre ökhĩirjuu ich diig petajim anaabá, chadcha phatkhon paraam arr aawai. ");
INSERT INTO noaE_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ichdëu mag nem jaaubarm ipierraa amaaugau warag ökhĩirjuu petam oowi, ich bigaau narr khʉʉn khĩir eerpa phʉʉrdʉnaa, ich dʉ̈i ogdʉba wënʉrrarr khʉʉnagta, —Keena, pãadë oobat ajim anʉm. Phatkhon paraam khʉʉnta Ẽwandam chi Pörkha sim aar öbëraagan, chadcha thethe simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesuu mag iekhabarm ũrwia warre jʉ̈gderraa aphöbaadëjim anaabá. Pari magwi deeu ich Jesuupai amag, —¡Aay, chaaina! Ar phatkhon ithee wʉrpa aajem khʉʉnta Ẽwandam chi Pörkha sim aar öbëraagan, chadcha phithur sĩerrʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Phatkhonpanta ʉ̈gthar Ẽwandam chi Pörkha sim aar öbërju khãyau, camello pöm jãg maach wounaan khãaijã ʉ̈rpai sĩerrʉmta phithurg chukhu nobeeu kach ee thoogar öbër dichjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jesuu mag jaaubaawai chará warag jʉ̈gderraacha nʉm iekhau jũrr amach eepai wir aig amach khapeenag, —Mag khai, magan ¿khaita peerdʉagáwa? anaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Magbaa Jesuu amag eerpanaa, —Õragan chadcha phithurgma ajim anʉm, mag ũurwai. Mamʉ Ẽwandamag chan bʉ̈ʉrjã phithurg chukhu simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Magbaawai Pedroou irig, —Maraun chad maach nem wai narrjã ewag khĩirjuba, thum phëpʉawi pʉ dʉ̈i ogdʉba wënʉrrabma ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Magbaa jũrr ich Jesuu magjim anʉm: —Pedro, mua chadcha mag chirʉm: Ar mʉ gaaimua wa mʉ iek jaaum khõchgau khãijã amach di, amach eeugpeen, amach ʉ̈phʉʉin, amach dënnaan, amach ʉʉi, amach chaain, wa amach nemjĩir khãijã khũchpaim ithee werpʉpʉakham khʉʉnagan, ");
INSERT INTO noaE_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mʉg jẽb gaai agtha nʉwejã amach eeugpeen, amach ʉ̈phʉʉin, amach ãd, amach chaain, amach nemjĩirpa thum mʉ gaaimua okhoomarr khãyaujã ʉ̈r warag ag atcha deejugui ajim anʉm. Ajap õrau am dau aug wauwiajã mag wënʉrrʉmʉn chadau, mʉg atagjã durr iiur gaai mʉch dʉ̈ita ich mag wënʉrramkhĩir mʉch aarchata phë aujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pari mag ed ãaur khʉʉn ar mʉig eegar aawai amachta chikham khãaijã ʉ̈rʉʉcha nʉm aajerr khʉʉnta ʉ̈gthar Ẽwandam aar paaukhaimaawaijã jũrr serbiibacha aajerrjöo nʉisijugui ajim anʉm. Maimua jũrr ar mʉ gaaimua chikhamnau serbiibag pheejerr khʉʉnta jũrr warm khʉʉn khãaijã ʉ̈rʉʉcha nʉisijugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Maigmua phöbör Jerusalenag khʉdau ma sim ee majim aajem, ich khapeen dʉ̈i deeum khʉʉnpa. Mag wëtumua ich Jesuuta pör garcha am na maa ajim anʉm. Mamʉ mag chi ẽudee wëtmarr khʉʉnan thãar paraata wënʉrrajim aajem, ich Jesuucha ag nawe õrau ich thõoju jaautarr ya khaphʉ narr aawai. Mamʉ mag am thãar paraa wënʉrrʉm Jesuu khaphʉ sĩerr aawai, ich dʉ̈i ogdʉba wënʉrraajerr khʉʉn doce khĩet thʉ̈rkha auwia Jerusalén phöbör eem khʉʉnau ich dʉ̈i khaigba aju jaaumamua magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Pãrau khaphʉ nʉm, maach Jerusalenag wëtum; nau maach mam barbaimaawai mʉch chi Emkhooi Iewaa mʉg chirʉmʉn thethemnaanag mʉ pʉr deejugui ajim anʉm. Magbaawai makhʉʉnau jũrr maach meeun khabam khʉʉnag mʉ thõopi jaauwi durr chaauram khʉʉn jua ee mʉ thʉsĩepʉ̈ijugui ajim aajem, makhʉʉnaujã mʉ dʉ̈i amachdëu ampierr amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Magbaawai makhʉʉnau mʉ wau iekhanaa, mʉ jʉ̈gadaujã wʉnaa, mʉ gaaijã ichö thunaa, amachdëu am aig mʉ dʉ̈i awia, ãbmiecha paawai amau mʉ thõopʉ̈ijugui ajim anʉm. Pari mag amau mʉ thõowiajã khãai thãrjup nʉm ee deeu mʉ iiu phiidʉjugui a jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mag wëtum ee jöoi Zebedeo chaainau, ajapcharan Santiagoouma Juan dʉ̈imua irig, —Maestro, marau pʉrʉg nemdam jëeum ig naajimgui ajim anʉm. ¿Pua maar khĩir jãsenkhawi maachdëu jëeubarmjö abaju khai? ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Magbaa Jesuu amag, —¿Pãrau jãgata mua pãach dʉ̈i apim khõsi nʉma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Magbaawai amachdëu irig, —Marau pʉrʉg jaaum ig nʉmʉn mʉg atag pʉchta thumaam khʉʉn Pörkha bëewi mʉg durr thum jʉ̈abaadeewaijã maar numiim khʉʉnagta pʉch bigaau juppibá ajierram anʉm, pʉch dʉ̈i iek theeg amkhĩir: ãb pʉch juachaar gar, maimua ãb pʉch juawë gar. ");
INSERT INTO noaE_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Magbaawaita ich Jesús garmua amag, —Pãrau chan sĩi pãachdëu nem jëeu nʉmjã khaugbata nʉmgui ajim anʉm. ¿Pãrau khĩirjuawai mag pãachta warm khʉʉn khãaijã ʉ̈rpai aag chikhamnau pãach dau aug wau nʉmjã mʉ dënjö ãwatwi mʉ thõm edjã mʉ dʉ̈i thõju aai nʉ? ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Magbaawai chi Santiagoou Juan dʉ̈imua, —Ëera, marau ãwatbajup ajierram anʉm. Mamʉ magbaawaita Jesuu amag, —Pãrau chadcha õrau pãach dau aphʉʉ wau nʉmjã ãwatwi mʉ thõbarmjö thõma ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pari magbarm gaaimuapai chan mag mʉch juachaar gar wa juawë gar khãijã mʉch dʉ̈i ãba juppiju chan mua pöd jaauju khaba chirʉmgui ajim anʉm, Ẽwandamauta ichdëu khap jaauju aawai. ");
INSERT INTO noaE_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mamʉ mag Santiagoou Juan dʉ̈imua amach dakhĩir Jesuug magbaawai chi khapeen diez narr khʉʉnau jũrr am dʉ̈ita meeukha naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mamʉ magbaawai Jesuu amach thum ãbam aig thʉ̈rkha auwia amag magjim anʉm: —Pãrau meraajã khaba nʉm, chadcha sĩi mʉg jẽb gaai õor pörkhawi amachdëuta gobernaajem khʉʉnaun amachta chi pörnaan aawai iek theeg nʉm awia amach khãai jua eegpaim khʉʉn dʉ̈i amachdëu ampierr aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pari jũrr pãrau pöd am dënjö magju khaba nʉm, pãach eepai. Magju khãai ãbmua khãijã pãach eepai ichta thumaam khʉʉn khãai ʉ̈rʉʉ am khõsi sim khai, magan jũrr ich garmuata ich khapeenau nem mag abaawaijã am ipierr nʉnʉʉu aju aai simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Maagwai ar ichta ʉ̈gthar pawiajã Ẽwandamau ich garcha juppi ahau apim khõsi sim khai, magan sĩi ichta parhoobam khʉʉn chogkhaju aai simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mʉ pãar khãai Emkhooi Iewaakha chirʉmjã mag sĩi mʉch garmua chikham chogaagjã bëebajim. Mʉ bëetarran, sĩi chikhamnag mʉch chogamkhĩirta bëejimgui ajim anʉm, mag chitʉmua chikham jua machgau thõwi mag thõbarm gaaimua õor pöm sĩi amach pekau ee preso sĩsidʉmjö nʉm khʉʉn öbeerkhapäain. ");
INSERT INTO noaE_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mag wëtumua Jericó phöbör ee barimajierram aajem. Maig khũchpai naawia deeu am ërëubaadëm dʉ̈i õor pöm wëtjim aajem. Maimua ya am phöbör eemua öbërwi wëtumta khʉd bigaau woun ãb dau khĩsu khitʉm Bartimeo anʉmta õor ërëu dich nʉm khʉʉnag nemdam jëeuwai oo khërʉm ooimajierram aajem. Mag woundam jöoi Timeo anʉm iewaa ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mag dau khĩsu khitʉmua ich dakha Jesús Nazaretpierr dichmam khaug athaawai ääakhamua, —Jesús, pʉʉta rey David khachitarr ag chaain ewagam khʉʉn Iewaau marau nʉ narr. Mʉ ap chitʉm mʉ dau ee aug khaugbahur aajeejim anʉm, ich dau monawaan bëemkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mag chi dau khĩsu khitʉmua ääa khabaadeewai Jesús dʉ̈i õor wëtmarr khʉʉnau irig meeurrarrau aajeejim anʉm, khĩupamkhĩir. Mamʉ magbaawai chará warag thet ääakhamua, —Jesús, pʉʉta rey David khakhitarr ag chaain ewagam khʉʉn Iewaau marau nʉ narr. Mʉ ap chitʉm mʉ dau aug khaugbahur aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesuu mag ääakham ũr athaawai dʉnʉisiwia chi dau khĩsu khitarr awaan mapijim aajem. Magbaawai chadcha i awaan wëtwi chi wëttarr khʉʉnau irig, —¡Khĩirdam ubʉ phiidʉbaad! Jesuu pʉ thʉ̈r sĩebahab. I aar marrau ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ichig magbaawai ich ag bʉ̈rre ich khajũa ʉ̈r joothʉ jũa sĩerr barwerbpʉ̈iwi phiidʉ dʉnʉisinaa Jesús aar petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mag chadcha ich aar dʉnʉʉubaimaawai Jesuu irig, —¿Khani pua mʉrʉg pʉch dʉ̈i apim khõsi chirʉ́? a jëeujim anʉm. Magbaa chi daudam khĩsu khitʉm garmua jũrr irig, —Maestro, muan pʉrʉg mʉch dauta monaaupʉ̈ipim khõsi chirʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Magbaawai Jesuu irig magjim anʉm: —Chadcha muata pʉch dau monaauju khaphʉ khĩirju chirarr gaaimua ʉ̈u pʉ monaau chirsim. Ya pʉ pʉch diig maju aai chirʉmgui ajim anʉm. Irua mag iekhabarm bʉ̈rre chadcha dau eerdʉ sĩsiwi ich bi eem daujö daujã wajaug sĩsijim anaabá. Mag ich dau monaaubapäaiwai warag i dʉ̈i petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús ich khapeen dʉ̈i mamua durrsĩ Olivo anʉm gaai naaimajim aajem, phöbör numí ãba dakha nʉm khĩirphee. Mag phöbör numí ãba dakha narr thʉ̈r, ãb Betfagé ajim, maagwai ãbakhai Betania. Maig durrsĩ gaai nʉmua ich khapeen numí thʉ̈rkha auwi pʉ̈yaagpamua magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Cha maach khĩirphee phöbördam sim ee ërëubaadët ajim anʉm. Nau chi phöbör ee dub nʉm aig pãrau burrodam pa gaai jʉ̈ khërʉm ooimaju. Mag burrodam gaai chan agtha ni ãbmuajã waaidʉba khitʉm. Ma pãrau ẽerwia aipidut ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ãbmua khãijã bëewi pãachig, “¿Khanthee jãg nemchaai pãrau ẽer arraag ẽkha nʉ?” a jëeubaawai, sĩi ithũu irig, mʉ igwia, mua ig chiraawaita arrum, mamʉ deeu ũmaai jöpcha deen bëeju a jaaubat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Maimua chadcha ërëu phöbaadëwia, amachig jaautarrjö burrodam khʉd bigaau puertdi dub nʉm dakha ö jʉ̈ khërʉm oobaimaawai, sĩi ẽer auwimajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Magbaawai aig õor narr khʉʉnau amag, —¿Pãar khanta jãig jãg nʉma, jamag pãrau chikham nemchaai ẽer arrú? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Magbaawai Jesuu amachig jaaupʉ̈itarrjö jaaubaawai ʉdʉraa warag amag arrpijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mag chadcha warrwi Jesús sim aar pabaimaawai chi khapeenau amach khajũa ʉ̈r joothʉ jũajemua chi burro phõpá ʉ̈r theer sĩujierram aajem. Magbaawai Jesús ag ʉ̈r waaidʉbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Magbaawai õor khapan i dʉ̈i wëdurarr khʉʉnau amach khajũa ʉ̈r joothʉ jũa narr ẽerkhanaa, i maju khʉd ee theerkhamam dʉ̈i jũrr ãaur khʉʉnaujã khʉd bigaau papiujöm bʉbrëunaa, agjö i maju ee wërphogkha majierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mag i mam dʉ̈i õor pöm i na pos wëtmaawai i ẽudeejã agjö khapaana pʉʉrthʉmajim anʉm. Mag õor pöm sĩi wëtum khʉʉnau serereugmamua mag naajim anʉm: “Ʉ̈ucha abarm Ẽwandam, ich mʉʉta pʉchdëu pʉch jũrr pʉ̈ibarmʉu. Ijöm khʉʉn chan chukhum. ");
INSERT INTO noaE_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Pua maar Reikhamkhĩir pʉ̈iju a jaaujerr chadcha pierrumgui” aajeejim anʉm. “¡Ʉ̈ucha abarm Ẽwandam! Warr jöoi David reikha sĩerrjö ichta jũrr Reikhaju khaphʉ nʉm gaaimua, pʉrʉg ʉ̈u abarm anʉm. Ʉ̈gtharm magwe onee aju aai nʉmgui” aajeejim anʉm, Jesús thö iekha nʉmua. ");
INSERT INTO noaE_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mag wëtumua Jerusalén phöbör ee barimajierram aajem. Mag barimawia, Aai i jëeujem diig mawia, ag ee dubwia, dijã thumaa eerpa phʉʉrdʉpʉ̈iwia, deeu öbërbaadëjim aajem. Mag öbërbaadëwia ya edau kheeuraa aadëm ee Betaniaag petajim aajem, ich khapeen doceem dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ag noram mag phöbör Betania anʉm eemua Jerusalenag wëtumua Jesús jãsöo aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mag i jãsöo nʉrrʉmta warpmua pabʉ̈ igo anʉm ëpõo khʉd bigaau dʉnʉm oo athajim anʉm. Magbaa aar dakha oon majim aajem, ag gaai chi nemjõ ya chi wawam nʉmpii awia. Pari ag chee jaar khaba arr aawai ni pör ãbjã ag gaai oobajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mag ichdëu ag gaai pör ãbjã ooba abaawai chi pabʉ̈ʉgta wounagamjö, —Pʉch jãg sim gaaimua mʉg atagjã ich jãg chëba sĩerrajugui ajim anʉm. Irua mag iekhatarrjã i khapeenau ũrjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Maimua deeu Jerusalén phöbör ee barchëwia, Aai i jëeujem di aar manaa ooimaawaijã, sĩi Aai i jëeujem degta nem peerwai õor pöm pos sereu wëjöm ooimajim anaabá. Magbaa Jesuu mag nem për narr khʉʉn thum dawag jʉrkhʉʉinaa ag ee õrag phatkhon cambie narr khʉʉn mes dʉ̈i dubur për narr khʉʉn mespa jẽkhʉt sĩepʉ̈imajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Magnaa tag iwiir ãbamʉgjã Aai i jëeujem deg nem inag dʉ̈i dichpibajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Maimua amag, —Pãrau khaphʉ naabá ajim anʉm, Ẽwandamau ich iek phã pʉarr gaai, “Mʉg diin sĩi durrpierram khʉʉnau bëewi ag ee Aai i jëeujem diiu” a sim. Mag simta pãachdëuta ag ee nem parhẽpag për nʉmua sĩi chikham khũguurjem dikha wai naabma a iekhajim aajem, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesuu mag iekhabarm phadnaan pörnaanau Moiseeu Ẽwandam iek phã pʉarr jawaag chi machnaan dʉ̈imua ũrbaawai, amach appai biirdʉwi, iekhawi, “Jãga akhiin maadëu jãg Jesús thõopʉ̈ikhamgui” anaajim aajem. Mamʉ irua nem jaau sim ũrwi thumaam khʉʉnau i igar narr aawai ũmaai deeu ãsie khĩirjuajeejim anaabá, mag i igar nʉm khʉʉnau jũrr amach dʉ̈ita meeukhaju khĩirjuwia. ");
INSERT INTO noaE_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mamʉ amau mag khĩirju nʉm ee, ya edau khëubaadee Jesús ich khapeen dʉ̈i mag phöbör eemua warag amachta chawag wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Maimua ag noram deeu Jesuu ich khapeen dʉ̈i ich ag khʉd ee wëtumua oowai mag irua iekhatarr igo sĩi chi khaar aram magwe phuhu thʉnaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mag phuu thʉnʉm oobaawai Pedroou, —Maestro, pʉdë oobá, pua tag chëpiba jaautarr igo bʉ̈jã sĩi phua thʉnʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Magbaawai thumaam khʉʉnagta Jesuu magjim aajem: —Pãach nem wawaag iekhaawai chadcha Ẽwandamau pãachdëu jaaubarmjö apiju khĩirjunaata iekhabat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mua chadcha pãrag mag chirʉm: Ãbmua khãijã durrsĩigta wounagamjö iekhabaawai chadcha ichdëu jaaubarmjö ich ipierraa aju khĩirjunaata “Jãigmua mawia jũrr phũas eeta dʉnʉʉubaimá” akhiin, chadcha Ẽwandamau ichdëu mag iekhabarmjö apijugui ajim anʉm, ichdëu mag iekhabarmjö Ẽwandamau chadcha magpiju khĩirjunaata iekha sĩewai. ");
INSERT INTO noaE_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Maimua ĩchab, ’Pãachdëu Ẽwandamag nem ig nʉm jëeuwai chadcha irua pãachig deeju khaphʉnaa ya pãach jua ee wai nʉmjöta jëeumʉn, magan chadcha irua pãrag pãachdëu nem ig nʉm deeb khaba deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Maimua pãachdëu Ẽwandamag jëwaagpaawai pãach garmua wa pãach khapeenau khãijã pãach dʉ̈i khaigba nʉm khai, agdaujö perdón jëeuwia, tag magʉm iek igba warag khĩir okhoopʉ̈iwia, magba arrjö am dʉ̈i dau parii abat ajim anʉm. Pãrau magmʉn ĩchab maach Aai ʉ̈gthar chirʉmʉgjã pãrau pãach pekau chugpaapi jëeubaawai irua chugpaapʉ̈iwia tag pãach dʉ̈i magʉm iek bʉ̈ʉrjã igbajugui ajim anʉm.  ");
INSERT INTO noaE_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pari pãrauta pãach khapeen wir aig perdonaabam chan, maach Aai ʉ̈gthar chirʉmuajã ich agjö pãar pekau chugpaabamgui a jaaumajim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Maimua deeu Jesús Jerusalén phöbör ee barchëwia Aai i jëeujem deg dubjim aajem. Mag dubwi agtha ierr simta, i aig phadnaan chi pörkha nʉm khʉʉn bëejierram aajem, Ẽwandam iek Moiseeu phã pʉarr jawaag ithee chi machnaan dʉ̈i judionaan Asamblea eem khʉʉnpa. ");
INSERT INTO noaE_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Makhʉʉnau bëewia irig, —¿Khai thöwiata jãg mʉig nem për narr khʉʉn pua dawag jʉr wërppʉ̈ijĩ? ¿Khaíuta jãg pʉrʉg pʉchta nem iek theeg apijĩ? Marag jaaubá aichëjierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ichig mag jëeubaicheewaita jũrr ich Jesús garmua amag, —Magan muajã ĩchab pãrag jëeu ookhimgui ajim anʉm. Mua jëeubarm pãrau mʉrʉg jaaumʉn, magan muajã ich agjö pãrag jaauju, khai thöwiata mua jãg nem wau chitʉ́. ");
INSERT INTO noaE_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Maimua ichdëupai, Nacha mʉrʉg jaaubat ajim anʉm: ¿Khaíuta Juan pʉ̈ijĩ õor pör choo nʉrramkhĩir; Ẽwandamauta pʉ̈ijĩ wa sĩi mʉg jẽb gayam khʉʉnau ajĩ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Amachig mag jëeubaawai sĩi warag jaaujujã khaugba, amach wir aigpai iyʉ̈ʉ nʉmua, —Maadëu irig, “Juan õor pör choomien Ẽwandamauta pʉ̈ijim” akhiin, jũrr irua maachig, “Magʉmta, ¿khan jãgwia pãrau irua jaau nʉrrarr ʉ̈khabajierrá?” ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wa magba maadëu irig, “Juanan sĩi õrau pʉ̈iwiata jãg nʉrrajim” akhiinjã, jũrr phöbörpienta maach dʉ̈i meeukhajugui ajim anaabá, amau chadcha Juan õor pör choomieu Ẽwandam iekta jaau nʉrraajerr khaphʉ narr aawai. ");
INSERT INTO noaE_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mag amach appai jaauju khaugba iyʉ̈ʉ naawia warag Jesuug, —Marau pöd jaauju khaugbamgui ajierram anʉm. Magbaawai jũrr ich Jesús garmua amag, —Mua pãrag nem jëeutarr pãrau mʉrʉg jaauba aawai muajã pãrag jaaubamgui ajim anʉm, khai thöwiata mua mʉg nem wau chitʉ́. ");
INSERT INTO noaE_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Maimua Jesuu ich aig õor pos thʉnʉm khʉʉnag mʉg nem ĩgkhaadam jaaumamua magjim anʉm: —Woun ãbmua uvadö jĩirjim aajem. Mag jĩirwia ag igaau ajapha thuur phʉʉrdʉpʉ̈iwi ich agjö aig di ëu khërjim aajem, ag eegar chi uva chö piirjʉwaag. Magnaa ĩchab didamjã nasãdjö ʉ̈gthaa ëu dʉnʉʉujim aajem, ag gaaimua warp dawaa oo phʉʉrdʉdʉ aag. Mag nem thum aaipa sĩuwi, chawag mam khõchkhabaadeewai, chi nemjĩirdö deeum khʉʉnag alquilaapʉ̈iwi, ichin jũrr deeum durr warp petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mag mam mawi sĩi awia, ya uva waaubaadëm khĩirjunaa, jöoirau ich chog ãb pʉ̈ijim aajem, chi thʉa narr khʉʉn aar, ich paatëm ich ithee deepʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pari mag irua ich chogdam pʉ̈itarr di garm khʉʉnau sĩi amach aar barpinaa pʉrphöbaadëwi, wʉ wai nʉʉ awia, sĩi deeu ich jua kharraa jʉrbapäaiwai, ich juadam parii barjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Magbaawai ich mag jöoi chi uva papau dewam ich chog pʉ̈ijim aajem. Mamʉ majã agjö amach aar barpinaa, warm dʉ̈i atarr khãaijã atcha wʉ wai nʉmua pörjã khõoppʉ̈iwi, sĩi i khĩir parhooba iekha thʉnʉʉuwia, ĩchab jʉrpʉ̈ijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Magbaawai jöoirau deeum pʉ̈ijim aajem. Ma paawai chará amach aar barpinaa warre thõopʉ̈ijierram anaabá. Magtarr khurjã ich mag ich chognaan khapan päaijeejim aajem, mamʉ makhʉʉnjã warm khʉʉn atarrjö ĩchab khar sĩi mas wauwi päaijeejim anʉm; magbajuun warre thõopäaijeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Maimua ya ãbmiecha tag pʉ̈ijujã chukhu aadeewai ich iewaa ãbpai khitaawai bʉ̈ʉrjã chig aba aajerrta pʉ̈ijim aajem. I khĩirjugan ich chaai aawai i ögkhaju awiata pʉ̈ijiebma. ");
INSERT INTO noaE_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mamʉ par ich jöoi iewaa ãba sĩi amach aar barpinaa amach wir aigpai, “Keena, chamʉʉta chi iewaa aawai mʉguata mʉg atagjã jũrr ich aai nemjĩir jʉ̈aju khabahab” ajierram anʉm. “Jãg sĩpí warre maadëu i thõopʉ̈ijugui” ajierram anʉm, mʉg uvadö jũrr maach dënkha awaag. ");
INSERT INTO noaE_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mag, chadcha khapanaam khʉʉnau pʉrphöbaadëwi, thõopʉ̈inaa, chi uvadö igaau ëudʉ deethurjierramgui a jaaumajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Maimua mag nem ĩgkhaadam öpʉ̈iwia ich iek ũr narr khʉʉnag magjim aajem: ’Pãrau khĩirjuawai ĩsjã agtha mag uvadö sim anaa chi thʉa narr khʉʉnjã ich akhʉʉnpai akhiin, ¿jãgaju khai ajim anʉm, magʉm wounaan dʉ̈i? Par irua ich chaai ãbpai khitʉm pʉ̈itarrpata mag thõobapʉ̈im oobaawai, mawia warre amach thum khëchpʉ̈iwia, ich uvadö jũrr deeum khʉʉnagta jaau pʉabjëjugui ajim anʉm ichdëupai. ");
INSERT INTO noaE_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Magnaa amag, ’¿Pãrau Ẽwandam iek phã sim gaai thʉ̈ʉrwai ooba aajẽ ajim anʉm, “Di ëu narr khʉʉnau isegtarr dibigta jũrr chi dihãd jãrramkha sĩsim” a sim? ");
INSERT INTO noaE_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","“Ẽwandam maach Pöröuta mag dibig wajaphamjö api sĩewai õrau oowaijã ʉ̈uuta oo nʉm” a phã simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesuu mag nem ĩgkhaadam jaau simua amachta jaau sim khaug athaawai chi fariseonaanau maestronaan dʉ̈imua Asamblea eem khʉʉnaupa ãba ich maigwe i pʉr aum ig naajim anaabá; mamʉ mag i pʉr athaawai jũrr õrau amachta khaigbaju khĩirjuwia warag i dichba amachta ërëujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Magbaawai chi pörnaanau Jesús aar fariseonaan pʉ̈ijierram aajem rey Erodes igar narr khʉʉn dʉ̈i, makhʉʉnau i dʉ̈i iyʉ̈ʉmamua nem jëeumam khãijã khaugba ipeerdʉ iekhabapäaiwai magʉm gaaimua i pʉr awaag ithee. ");
INSERT INTO noaE_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Magbaawai makhʉʉnau ërëuwia i aar barimawia irig maguimajierram anʉm: —Maestro, marau khaphʉ nʉm, pua nem agchata jaaujem. Pua mag sĩi pʉchdëu oowai magjöo abaawai mag awi parhoobjã nem jaauba, ante pua chadchata thumaam khʉʉnag jaaujemgui ajim anʉm, jãgata aju aai nʉ Ẽwandamau nem jaau sim eyaa wënʉrraag. Pua chan sĩi õrau amachdëu nem jaaum aig nem jaau nʉmʉgjã pʉch khũgurpiba, wa sĩi pʉchdëu oowai magjöo abaawai ag bʉ̈rre sĩi magau aba aajem. Magua marau pʉrʉg jëeum ig nʉmgui ajierram anʉm: ¿Chadchata maach meeun judionaanaujã durrpierram khʉʉn rey Roma sĩejemʉgta impuesto phagju aai nʉ wa phagju khaba nʉ? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mamʉ mag amau sĩi ich imeraa pʉr awaagta mag ichig jëeubaichëm khaphʉ sĩerr aawai amag magjim anʉm: —¿Pãrau khantheeta sĩi mʉ imeraa pʉr auju ẽkha nʉma? Daaig phatkhon chi dau daí mʉ aig aipidut; mua pãrag oopikhimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Magbaawai chadcha irig phatkhon chi dau daídam deejierram anaabá. Mag deebaawai jũrr ich Jesús garmua amag, —Pãrau chamʉg phatkhon gaai, ¿khai khĩirta oo nʉ, maimua ĩchab ag gaai khai thʉ̈rta phã sĩ? ajim anʉm. Magbaawai amachdëu, —Romaam rey César khĩir khabahab ich thʉ̈r dʉ̈i ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Magbaawai Jesuu amag, —Pãrau mag khaphʉ nʉm khai, magan reíg ich paat deenaa, Ẽwandamagjã agjö ich paat deebat ajim anʉm. Amachig magbaawai sĩi jʉ̈gderraa nʉisim iekhau warag amachta khĩu nʉisijim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Biek ãb agjö Jesús aig bëejierram aajem saduceonaan. Makhʉʉnau jaauwai ya maachta meebaadëm chan tag bʉ̈ʉrjã maach akhaar iiuba aajem aajem. Amach mag nem jaau sĩerrjëem gaaimua iyʉ̈ʉmamua juau ogthom irig magjierram anaabá: ");
INSERT INTO noaE_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, jöoi Moisés khararrau Ẽwandam iek phã pʉarr gaai jaauwai, woun ãb ʉʉi paraa simta mag ʉʉi dʉ̈i chaaijã chukhu meemʉn jũrr chi khod ãbam wai sim khai, magua ich ag ʉʉipai auju aai sim a sim, ag dʉ̈i ich naamʉu chaain ooba arr aawai jũrr i ithee oo deeg, mag oo deebarm i chaainkha nʉisimkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maimua amachdëupai warag irig nem ĩgkhamamua magjierram anʉm: ’Biek ãb ãbam khod appai emkhooin siete naajim aajem. Am naam chi nacharamua ʉʉi auwia ich mag chaai chukhu wënʉrrʉm ee meejim aajem, chi emkhooi. ");
INSERT INTO noaE_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Magbaawai jũrr chi eeumʉu wir aig ich khojaaupai auwi mag dʉ̈ijã agjö chaai ooba, chi emkhooita meejim aajem. Magbaa jũrr ich mag ʉʉipai ag eeumʉu auwia mag dʉ̈ijã chaai ooba, agjö ich naamkhʉʉnjö meejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ich mag ewagjã ãbam ʉʉiraupai mag siete narr thum thegdʉpʉ̈itarrjã ni ãbam dʉ̈ijã chaai oobajim anaabá. Maimua ya ẽudeecha paawai chi ʉʉijã agjö meejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Magua marau pʉrʉg khap aag ithee jëeum ig nʉmgui ajierram aajem: Khëchtarr khʉʉn mʉg atag Ẽwandamau deeu phiriutkha atham edjã mag amach thumaam khʉʉnau ãbam ʉʉipai autarr aawai, ¿chijãata chi jaai khʉ chaarkhajuma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Magbaawaita Jesuu amag magjim anaabá: —Pãrau chan bʉ̈ʉrjã Ẽwandam iek phã simjã khaugba, ni i jua theegjã khaugba nʉm gaaimuata sĩi warag khĩirjug chaaurta khĩirju nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ötarr khʉʉn deeu iiu phiidʉtkha phöbaadëm chan bʉ̈ʉrjã jua pʉpʉr abaju, ya am ʉ̈gtharm Ẽwandam chognaan thʉnʉm khʉʉnjö nʉisiju aawai. ");
INSERT INTO noaE_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mag õor ötarr khʉʉnjã deeu iiuju khap aag ¿pãrau Moiseeu Ẽwandam iek phã pʉarr gaai thʉ̈rba aajẽ? Ag gaai Ẽwandamau Moiseeg, “Mʉʉta pãar jöoin Abrán khararr Ẽwandam anaa ĩchab jöoi Isá khararr ag Ẽwandamau, maimua Jacob khararr dënjã agjö” a sim. ");
INSERT INTO noaE_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Ẽwandam chan oob mag sĩi chi khëcham khʉʉn Ẽwandam khabam. Ẽwandaman chi iwam khʉʉn Ẽwandamau” a phã sim. Irigan nawe khëchtarr khʉʉn awiajã agtha iiu nʉmgui ajim anʉm. Magnaa, Pãachta chadcha sĩi chaaurta khĩirju nʉmgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moiseeg Ẽwandamau ich iek phãpitarr iek jawaag chi machnaan eem ãbmua mag am ijẽjẽbkham ũr sĩi awi, Jesuu ich dakhĩir wajapha ag eyaa jaaubapäaiwai, jũrr i aig bëewi irig, —¿Chijãata Ẽwandam iek phã pʉarr gaai maachig nem waupi jaau sim eem chi ʉ̈rʉʉcharam agá? ¿Khanta ʉ̈rʉʉcha Ẽwandamau maachig waupim khõsi sĩ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Magbaa Jesuu mag wounag, —Ẽwandamau ich iek gaai nem waupi jaau sim chi ʉ̈rʉʉcharamʉn mʉgta phã simgui ajim anʉm: “Ũrbathʉ̈ keena, israelnaan: Maach Pör Ẽwandaman ichta ãbpai thumaam khʉʉn Pörkha sĩerrʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Maach Pör Ẽwandam sĩi par iiupai khaba, pʉch thãrauchata khõsinaa pʉchdëu wauju ayaampierr ichdëu khõsimjö abá” a sim. Maata Ẽwandamau nem jaau sim chi ʉ̈rʉʉcharamʉugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Maimua ãbakhai ag garm ich agjöpaimʉʉ sĩebahab ajim anʉm. Ma sĩi, “Pʉch khapeenjã wir aig pʉchjö daupii abá” a simgui ajim anʉm. Ẽwandamau nem waupi jaau sim gaai chamʉ khʉʉn numiim khãai ʉ̈rpaim chan chukhumgui ajim anaabá irig. ");
INSERT INTO noaE_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Magbaawai mag chi machdamau jũrr irig, —Maestro, ʉ̈u pua ag eyaa jaaubapʉ̈im, jãan chadaugui ajim anʉm. Maach Ẽwandaman ich appaita sĩerrʉm; ijöm chan tag chukhum. ");
INSERT INTO noaE_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ẽwandamta dich thãraucha khõsinaa dich khapeenjã daupii nʉmta Aai i jëeujem deg mawia nemchaain khapan thõonaa phaa nʉmua ʉ̈gthaag jëeu nʉm khãaijã ajapcha simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesuu oowai mag wounau chadcha agcha ich iek ʉ̈khabaawai irig, —Pʉʉn pöm waaurba chirʉmgui ajim anʉm, Ẽwandamta pʉch Pörkhapieg. Bigaaum khʉʉnau mag oobaawai ãbmuajã tag irig jëeubajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Aai i jëeujem deg Ẽwandam iek jaau sĩewia jũrr ich garmua aig narr khʉʉnag magjim anʉm: —¿Khan jãgwia Moiseeu Ẽwandam iek phã pʉatarr jawaag chi machnaan iek mag Cristo rey David khararr ag chaain ewagam khʉʉn dën aajẽ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ich Daviiuchajã Ẽwandam Akharau ichig iekhapibaawai ich ag Mesías igwiapai “maach Pör” abajieb. Ante irua phã pʉarr gaai mag simgui ajim anʉm: “Maach Pör Ẽwandamau maach Pörög ‘Mʉch iek theeg chirʉmjö aag mʉ dʉ̈i ãba mʉ juachaar gar jupbá ajim, pʉch oomapha aajem khʉʉn thum mua pʉch jua ee pʉrkha dee nʉm ora.’ ” ");
INSERT INTO noaE_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mag ich David khararrauchajã Ẽwandamau pʉ̈iju aajerr igwia “maach Pör” a iekhatarrta, ¿jãga pãar iek í David chaain ewagam khʉʉn dënpai aju aajẽ? Mag sĩi ich chaaipai aju akhiin, ich paarmua mag “maach Pör” abakhamgui ajim anʉm amag. Mag i ijẽjẽbkham õor pöm aig thʉnarr khʉʉnau i iek ũrm khõsi ũr naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesuu Ẽwandam iek jaaumamua magjim aajem: —Moiseeu Ẽwandam iek phã pʉatarr jawaag chi machnaan dʉ̈i khai, khĩir khaphʉ abat ajim anʉm. Jãkhʉʉnan sĩi khajũa bʉ̈ duurg jũanaa kaaijã ee õrau amach saludaawaijã amach thö iekhapim khõsita sĩerrjëem ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jãkhʉʉnan amach Ẽwandam i jaaujem deg weetwaijã amachta pör garcha thumaam khʉʉnag khĩir jʉrkha juupjem, amachta warm khʉʉn khãaijã wajapcha nʉm awia. Maimua õor chaauram khʉʉnau amach aar thach khömkhĩir thʉ̈ʉrwaijã, parhooba jupba, amachdëuta khãidu wajapcharam jʉ̈a au sĩerrjëemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Khoopaa ʉʉin dau aphʉʉm dijã khechthʉg aumaajerram. Mamʉ mag sĩerrjëemta chadcha amach magba chithëem amkhĩir, Ẽwandamag jëeuphöbaadëmjã pʉa chʉuu aphöbaadeejemgui ajim anʉm. Pari amach jãg sĩerrjëem paran Ẽwandamaujã am gaai jua khʉaba deejugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Biek ãb Jesús Ẽwandamag jëeujem deg am phatkhon phiejem khĩirphee oo sĩejim aajem. Mag oo simua jũrr bëe thʉnʉm khʉʉnau ag ee phatkhon pʉapʉ̈i ërëu dich thʉnʉmta eerpa oo sĩejim anaabá. Irua oowai riknaanaun phatkhon pöm dee naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mamʉ riknaanau mag phatkhon dʉ̈rrcha dee pʉa nʉm ee, khoopaa ʉʉi ãb aphʉʉ khitʉm bëejim aajem. Mag bëewi phatkhon chi dau daídam numpai wai sĩerr warre mag numwe ag ee dee pʉapʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mag khoopaa ʉʉyau phatkhon bʉ̈rʉʉ wai khërarrdam thum deebarm oowia Jesuu ich khapeen ich aig thʉ̈rkha auwia, —Keena, mua pãrag jaaukhimgui ajim anʉm. Jãg khoopaa ʉʉi dau aphʉʉ khitʉmua phatkhon bʉ̈rʉʉ deejieb mamʉ, Ẽwandam dakhĩiran tagam khʉʉn khãaijã ʉ̈rʉʉchata deebarmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Warm khʉʉnaun sĩi amach dën sobtarr eemta Ẽwandamag dee naabahab. Mamʉ jãg khoopaa ʉʉi aphʉʉ khitʉmua chan magba, ich dën ãbmiecha agua ich thach khöju arrdamta warre thum deebarmgui a jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mag Aai i jëeujem deg sĩewia öbërbaadeewai i ogdʉba wënʉrraajerr khʉʉn eem ãbmua chi Jesuug, —Maestro, pʉdë oobá ajim anʉm, mokpör dapkhamua sĩi di ooimʉ joothʉthʉʉd ëu dʉnʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Magbaawai Jesuu irig, —Ar jãg di dap dʉnʉnʉidʉm pua oo chirabá; jãg thʉnʉm chan mok pör ãbjã ãbam ʉ̈r ich jãg ajapha joothʉthʉʉd sĩerrabam. Jãg thʉnʉmʉn sĩi thumaa õrau pogueupʉ̈ijuuta jãg dʉnʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Maigmua ërëubaadeeu mag Aai i jëeujem di khĩirphee durrsĩ Olivo anʉm gaai sĩeimajim aajem, ich khapeen dʉ̈i. Maimua barwi ya i jẽkhʉt jupbaimaawai Pedroou, Santiago, Juan maimua Andrés dʉ̈imua amach jayapam khʉʉnau irig jëeumamua magjierram anʉm: ");
INSERT INTO noaE_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Pʉ iek mag jãg mokdau joothʉthʉʉd thʉnʉm thum õrau pogueupʉ̈iju anʉm, ¿ma jãagwaichata magjuma? ajim anʉm. ¿Khan jãg nʉm gaaimua cha pʉchdëu jaau simjö Ẽwandamau ijaaurjö oopijuma ajierram anʉm, mag Aai i jëeujem di pogueupʉ̈imʉʉ pam? ");
INSERT INTO noaE_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Magbaawai Jesuu amag, —Magan mua pãrag jaaukhimgui ajim anʉm. Maimua jaaubaadëwia, Keena, khĩir khaphʉ wënʉrrathʉ̈; oob chikhamnag pãach ʉdʉraa khũgurpimiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mua pãrag mag chirʉmʉn, mʉg atag paawai õor khapankham khʉʉnau amach iekpai mʉ iek gaai thʉwia, “Mʉʉta ag Cristoou Ẽwandamau pʉ̈iju aajerr” awia, õor pöm khũgurmaju aawaita mag chirʉmgui ajim anʉm. Pari makhʉʉnau pãachig magwia khãijã oob pãrau am iek ʉ̈khamiet ajim anaabá, am wawimamua. ");
INSERT INTO noaE_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Juurhi phiidʉju theega jajaaukhamjã pãrau ũrjugui ajim anʉm. Mamʉ pãachdëu mag ũurwai oob jãphierrmiet. Ichiita jerrba chadcha ich mag aju. Magjup mamʉ ma chan agtha Ẽwandamau pãar i agkha nʉm khabamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Magbaadëm dʉ̈i ĩchab durr mʉg wëjöm ee amach eepai jũrr durr chaauram khʉʉn dʉ̈i wërbʉjurau, amachta jũrr chikhamnaan khãyau ʉ̈rpai am khõchgau. Mag nʉm dʉ̈i ĩchab durrpierr ʉʉur theega duuimam dʉ̈i jãdau theegjã burrju. Mamʉ mag nʉmʉn sĩi warrpem Jöoirau õor dau aug waupi simʉugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pãach mordam wir aig ʉʉrkhabathʉ̈. Thethem khʉʉnag pãar pʉr deewi judionaan Ẽwandam iek jaaujem degjã pãar gaai amau mas deemaju. Mʉ gaaimua pãar khaibag waumkhĩir amau pãar gobernadornaan aarjã warrwi reinaan aarjã warrmaju. Mamʉ magʉm khʉʉn aar pãar warrwaita warag pãrau mʉ iek jaauwímʉcha amag jaaujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ẽwandamau mʉg durr i agkhaju nawe mʉg õor peerdʉ aaujem iekhan ichiita thumaa durr warpham magwe meupierr jaaudubjugui ajim anʉm ĩchab. ");
INSERT INTO noaE_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mag pãach pʉr aauwai, thethemnaan khĩirphee iekhaagpaawai, oob pãrau, “¿Khan ata mʉ iekhajuuta mʉgbaadëma?” a khĩirjumiet ajim anʉm. ¿Khan jãgwi mua mag chirʉ́? Ya maig chan pãar pãach khĩirjugdamaupai iekhabam; magbaadëm aiguin ich Ẽwandam Akharauta pãrag iekhamkhĩir khĩirjug deeju aawaita mua mag chirabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mag jaran wir aig khod ãbam khʉʉnjã chi ʉ̈khaba sim garmua ʉ̈u mʉ iek ʉ̈kha khërʉm thethemnaanag jaaupʉ̈imaju, ich khodpai wir aig thõomkhĩir. Amach dënnaanjã mʉ gaaimua thõomkhĩir thethemnaanag jaaupʉ̈imaawai chi dënnaanaujã ich agjö ajugui ajim anʉm, amach chaain dʉ̈i wir aig. ");
INSERT INTO noaE_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pãachdëu mʉ iek ʉ̈kha durrum gaaimuajã thumaam khʉʉnau pãar oomapha aju. Mamʉ magʉm gaaimua phithur dau aug wau nʉmjã igba mʉ dʉ̈i ubʉ khërʉmʉn ʉ̈u peerdʉjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ẽwandam i jaaumie Daniel khararrau jaautarrjö, Aai i jëeujem deg ierr phadnaankha nʉm khʉʉnjã dubba aajem aarta woun ãb bëewia ichta maig ierr sĩeichëm oobaawai, Judea durr nʉm khʉʉn pabʉ̈ ee durr dapag ee dʉrbat ajim anʉm. (Mʉg iek phã sim gaai oonaa thʉ̈r simua wajapha khaphʉ abá.) ");
INSERT INTO noaE_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ich maagwai jua ʉ̈ʉiwai ich dihëu ʉ̈r khãijã sim khai, ich nem phë awaan awi oob tag ierrag dubam. ");
INSERT INTO noaE_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wa magba di chaaur ich phidag ee khãijã sim khai, oob tag degag mam, ich khajũajöm khãijã jʉraan. ");
INSERT INTO noaE_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mamʉ ¡ë, apdurr ajim anʉm, magbaadëm jaar ar ʉʉin jõor khithëem khʉʉn, maimua ĩchab ʉʉin ar chaaindam daumeraa jũd döpi wai durrum khʉʉn! ");
INSERT INTO noaE_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Magju nawe pãrau Ẽwandamagta jëeubat ajim anʉm, eeu dëgölp magbaadëwia edau khõrg jaar khãijã pãach dau aphʉʉ wënʉrradukham. ");
INSERT INTO noaE_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mag jaarta wajappha õor dau aug waujupa. Mag jaar õor dau aug waujujö chan Ẽwandamau mʉg jẽb ompaaju nawejã ooba, ni ag khurjã agjö chan abaju ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mamʉ magbaadëm ich Ẽwandamau bʉ̈ʉrjã khãai eeg bʉchdʉ auba ich mag warag apikhiin, ni ãbjã peerdʉbaju. Pari ar ich iek ʉ̈kha nʉm khʉʉn daupigau, irua khãai khapan deeju atarr ʉ̈u magcha deebajugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Magbaadëm ee õrau pãachig, “Oobat, chamʉʉta warrgarwe Ẽwandamau pʉ̈iju aajerrauwai” aawai, oob ʉ̈khamiet. Wa magbam khai, “Ar simta ichiuwai” aawaijã, oob ʉ̈khamiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mua mag chirʉmʉn amach iiupai amta Ẽwandamau pʉ̈ijim anʉm khʉʉn dʉ̈i Ẽwandam i jaaumien anʉm khʉʉnjã sĩi sëukha chikham khũgur wënʉrraju aawaita mag chirʉmgui ajim anʉm, khap amkhĩir. Makhʉʉnaun chadcha Ẽwandamauta amach pʉ̈ijim amkhĩir, ag na õrau nem ooba aajempa õor dauderraa wau wënʉrraju. Mag nem wau wënʉrrʉmua ich Ẽwandamaucha jʉr auwi ich iek ʉ̈khapi autarr khʉʉnpa khũgur ẽkhajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Magnaa amag, Mua ya pãrag jaaubarmgui ajim anʉm, magju nawe khap amkhĩir; maagwai pãrag mʉch bëeju nawe khĩir khaphʉ abat a chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Mag õor ajappha dau aug wau dichtarr khur ĩchab ãsdawam edaujã khĩwia edaram edau argjã khĩjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Magbaadëm dʉ̈i phĩdagjã edjã eemua khʉibaadeewai tagam nem Ẽwandamau nem waumatarr edjã ee sĩsidʉmpata sĩi parhooba amach sĩsid arr chaaur aaidʉ jörrjëe thʉnʉisijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Magbaawaita thumaam khʉʉnau mʉch chi Emkhooi Iewaa chadcha edjã baug ee dau daau urum oojurau. Ya maig mʉg jẽb gaaim khʉʉn thum chachbaadëm aawai mʉchta nem jua theeg thumaam khʉʉn Pörkha bëejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mag mʉch pierrum dʉ̈i mua mʉch chognaan durrpierr aaidʉpʉ̈ijugui ajim anʉm, mʉchdëu mʉch ithee jʉr autarr khʉʉn thum ãbam aig biirdʉ aumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mag jajawagmamua, ’Pãrag khap amkhĩir mua jaaukhimgui ajim anʉm: Pãrau khaphʉ nʉm, mʉig Israel durr igo khër khukhuur aadëmʉn thumaam khʉʉnau ya chadcha döchʉumie burrju dakpapakham aajem. ");
INSERT INTO noaE_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ich agjöta ajugui ajim anʉm ĩchab, mʉch chi Emkhooi Iewaa bëeju gaai paawaijã. Cha mua nem jaau chirʉm thum ich ag ee öbëbërgmam pãach daúa oobaawai, khaphʉ abat ajim anʉm: ya mʉch chi Emkhooi Iewaajã deeu bëeimʉʉ chirʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mua pãrag mag aai i jëeujem di õrau pogueupʉ̈iju a chirʉmʉn, cha õor thʉnʉm khʉʉn khëchju nawe, cha mʉchdëu jaau chirʉmjö thumaa chadcha ajugui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Edaujãjã mʉg jẽb dʉ̈i thum chukhu aadëju, mamʉ cha mua pãrag jaau chirʉm chan sëukhaawai khabam; jãan thumaa ich ag ee öbëbërgmajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Mamʉ mag mʉ bëeju ed chan ni ãbmuajã khaugbamgui ajim anʉm. Ẽwandam chognaan ʉ̈gthar thʉnʉm khʉʉnaujã khaugba, ni mʉchdëujã khaugba, ãba ich mʉ Ayaupaita mag mʉ bëeju orajã khaphʉ simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Mag pãachdëu mʉ bëeju orajã khaugba naawai muan pãragan, nem parhoobam nem wauba Ẽwandamagpaita jëeu nʉʉ jëeu nʉʉ abat a chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mag mʉ bëejuun, woun ãb deeum durr maagpaawai ich chognaanag chi morkhʉ dënjö ich di thʉamkhĩir jaaunaa, amachpierr phidagjã jaaukhawi, chi puertdi thʉajemʉgjã ajapha oopaar jaau pʉawi petarrjöta simgui ajim anʉm. Maagwai pãar chi di gar nem thʉa nʉisierrjöta nʉmgui ajim anʉm ich khapeenag. ");
INSERT INTO noaE_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mamʉ pãrau ni ãbmuajã mag mʉ bëeju khaugba naawai sĩi wajaphata khĩir khaug nʉisit ajim anʉm, mʉ bëewaim ithee. Pãrau khaugbam, khan orata mʉ bëeju: kheeuraa aadëm ee, edachanaa, ãspa urumua ãthãrr bĩebaadëm ee, wa edpherre khãijã, ni ãbmuajã khaugbamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Eeu sĩi dëgölp mʉ dʉnʉʉubaicheewai mʉ dʉ̈i wëtaag pãar agtha khĩir khaugba khãi nʉmjö nʉm khãijã oochëdukham. ");
INSERT INTO noaE_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Cha mua pãrag mag jaau chirʉm chan sĩi pãragpaijã khabam; maan thumaam khʉʉn itheeta mag jaau chirʉmgui ajim anʉm. Maguata muan pʉaba, khĩir khaugbathʉ̈ a chirʉmgui ajim anʉm, mʉ bëewaim ithee. ");
INSERT INTO noaE_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jesuu mag ich khapeenag ich mawia deeu bëeju jaauwai nemkhoo pömaam burraag khãaidam numpai waaur sĩejim aajem. Mag phiesta ĩchab Pascua a thʉ̈ʉrjem; ajapcharan maar meeun judionaanau pan sĩi ich jãg levadura chukhu wauwia seman ëntër khoojem ag semanma. Mag phiesta burrju khãai khapan khaba waaur nʉm ee, phadnaan chi pörnaanau Moiseeu Ẽwandam iek phã pʉatarr jawaag chi machnaan dʉ̈imua ãba biirdʉwi khĩirjug jʉr naajim anaabá, nemdam bʉ̈ʉr abarm gaaimua Jesús imeraa pʉr auwi thõopʉ̈yaag. ");
INSERT INTO noaE_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amach ödegpain mag i thõopʉ̈iju khĩirju naajieb mamʉ, jũrr tagam khʉʉnau, “Keena, mʉg nemkhoo ee maadëu i thõoba sĩuju. Magba akhiin õor pöm mʉg wëjöm maach dʉ̈ita meeukhaju” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mag nʉm ee Jesús Betania phöbördam ee mawi woun Simón anʉm deg thach khö sĩejim aajem. Ich mag Simón ibʉʉr wauwi “phĩe paraa khitarr” a thʉ̈ʉrjeejim aajem. Maig i thach khö simta, ʉʉi ãb jʉ̈gdee didam durrkhudau alabastro anʉm dën boteedidam wau khitʉm dʉ̈i dubchëjim aajem. Mag ee jʉ̈gdee narrdo anʉm dën thũpaaga sim ipir aibëejim aajem. Mag jʉ̈gdee khĩir nem parhẽpag sĩerrʉm. Mag sim dʉ̈i jua ee dubchëwi, chi boteedidam ö khõorpnaa, õor dakhĩir Jesús pör ee choopʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mes gaai i dʉ̈i ãba thach khö narr khʉʉnau amach daúa mag jʉ̈gdee parhẽpagkhamta sĩi i pör ee choobapʉ̈im oobaawai ãaur khʉʉnau wir aigpai amach khapeenag, —Keena, ¿khantheeta jãg jʉ̈gdee parhẽpag simta sĩi jãg ãr choobarma? ajierram anʉm, ");
INSERT INTO noaE_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","jãg sĩi par ãr chooju khãai, parhẽphʉ përpʉ̈iwia ag phatkhonau ʉ̈u dau aphʉʉm khʉʉn khĩirdam jãsenkhaju aai sĩerrtá. ");
INSERT INTO noaE_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mag bigaaum khʉʉnau magbaawaita jũrr ich Jesuu amag, —¿Khantheeta pãrau mag ʉʉi khĩir naau iekha nʉma? ajim anaabá. Jãgbarmua irua mʉ dʉ̈i ʉ̈u abarm khabahab; idëu i sĩi khajapha sĩubat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dau aphʉʉm khʉʉndaman pãrau pãach ee ich jãg oo wai wënʉrrajugui ajim anʉm. Maagwai pãachdëu nemdam deem khõsim aig pãrau amag deeju aai naabahab; pari mʉ chan pãrau pãach ee ich mag mʉ oo wai wënʉrrabaju. ");
INSERT INTO noaE_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mʉg ʉʉirau ichdëu khĩirjuawai ajapcha simjöta abarbahab mʉ dʉ̈i. Mʉg mʉ pör ʉ̈r jʉ̈gdeeu choobarmua mʉ meebaadeewai aukhëraan arrju nawe ya irua mʉ kha phuur sim khabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Magnaa, Ĩs mua chadcha pãrag mag chirʉmgui ajim anʉm: Mʉg atag pawiajã durrpierr Ẽwandamau õor peerdʉ aaujem iek jaau wënʉrrʉm dʉ̈i ĩchab mʉg ʉʉirau mʉ dʉ̈i mʉgbarmjã jaaub khaba jaauju. Mag, ooba arr khʉʉnaujã ĩchab i iigjeejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mag phadnaan chi pörnaanau Moiseeu Ẽwandam iek phã pʉatarr jawaag chi machnaan dʉ̈imua ich Jesús dakhãu wai nʉm ee, ich dʉ̈i doce wënʉrraajerr eem ãb Judas Iscariote a thʉ̈r sĩerrau phadnaan chi pörkha nʉm khʉʉn dʉ̈i iekhaan majim aajem, jãga ichdëu amag Jesús pʉr deeju a jawaag. ");
INSERT INTO noaE_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Maimua mawia chadcha Judaau amachig Jesús pʉr deeju a ũrbaawai chi phadnaan pörkha nʉm khʉʉn oneeu phöbaadëwia chi Judaag phatkhonpa deeju ajierram anaabá. Ichig mag phatkhonpa deeju abaawai chará ãba i imeraa pʉr auwia warre amag amach jua ee deeju khĩirjugpaita wai sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan levadura chukhu wauwia warrpem phiesta burr nʉm edcha judionaanau nemkhoo jaram ithee ovejadam thõowia edau khëubaadeewai khoojem. Magua ich mag edcha Jesús khapeenau irig, —¿Jampaita marau pʉ na phiejãb wauwimaju aai nʉma? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mag ichig jëeubaawai ich khapeen eem numí ich aig thʉ̈rkha auwi pʉ̈yaagpamua amag, —Pãar maar na Jerusalén phöbörög ërëubaadët ajim anʉm. Nau pãar ya phöbör ee paaukhabaimaawai pãrau woun ãb döthũr ee dö jöi arrum ooimajugui ajim anʉm. Mag woun döthũr dʉ̈i mam oobaawai i ẽudee wëtwi, ");
INSERT INTO noaE_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","i dubbaimam deg dʉ̈i dubwia, chi dikhʉʉg mʉ imeerba, “Maestroou pʉrʉg jëeupijim, ¿jamta í ich khapeen dʉ̈i ãba nemkhoo jaram thach khöju aai chirʉ́?” a jëeubat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Magbaawai mag wounau pãar ʉ̈gthaa warrwia dijã pöoma sĩi wajappha jar sim pãrag jaauju. Maigta phiejãb wauwia sĩi maar na wajapha nem khĩir khaug sĩubat ajim anʉm, mag ich khapeen ichdëu pʉ̈iju khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesuu amachig magbaawai, chadcha i ipierr Jerusalén phöbörög ërëuwia ooimaawai, chadcha amachig jaautarrjö ooimajierram anaabá. Mag oobaimaawai maig mag nemkhoo jaram ovejadam wai narr wauwia sĩi i baraata oo nʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mag ich na numí pʉ̈itarr aawai ya kheeuraa aadëm ee, tagam khʉʉn dʉ̈i barjim aajem, warm khʉʉnau phiejãb wau wai narr aar. ");
INSERT INTO noaE_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mag barbaimaawai thach thöikhawia ya ãba mes gaai khö nʉmua Jesuu amag, —Keena, mua warre pãrag jaaukhimgui ajim anʉm: Mʉ cha iekha chirʉm iekhau maach khapeer mʉig maach dʉ̈i ãba thach khö simuapai thethem khʉʉnag mʉ pʉr deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jesuu amachig mag iekhabarm ũrwia warre ökhĩirjuu nʉisijim anaabá. Mag ökhĩirjuu nʉm iekhau jũrram khʉʉnau irig jëjëeu aajeejim anʉm, chijãguata magju khap aag awi. ");
INSERT INTO noaE_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mamʉ par mag ichig jëjëeukhamjã amag chi thʉ̈rjã jaauba, sĩi, —Pãach mʉg doce nʉm eem ãb mʉ khö chirʉm thëp ee ich panau sĩkhö sim wounauta mʉ khaibag waujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mʉ dʉ̈i magbarmua Emkhooi Iewaan Ẽwandam iek phã sim gaai jaau simjö ich ag eyaata öbëbërgmam. Mamʉ ¡ë, apkhiitʉ chi mag mʉ përpʉ̈i sim woun! Ante magju khapnaa thaababa arr amuan ʉ̈ucha akhamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Maimua mag iyʉ̈ʉ thach khö nʉmua Jesuu pan jua ee auwia, Ẽwandamag ʉ̈u ajim anaa khõreunaa amag ʉapʉ̈inaa, —Mʉg pan khöbat. Mʉ mʉ morougui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Maimua ich agjö jarrdamjã jua ee auwia, ag paar Ẽwandamag ʉ̈u ajim anaa, deeu amag ʉapʉ̈ijim aajem. Magbaawai thumaam khʉʉnau ag eem döjierram aajem. Mag ʉapʉ̈iwia ich Jesuupai magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Jãg döbarmʉn mʉ bagau, warrgarwe Ẽwandamau õor dʉ̈i iek deeju aajerr. Mamʉ mʉg iekhan iek iiuriugui ajim anʉm. Mʉg pãar ithee mʉ bag mʉg vinojö khitʉm ãrbarmuata Ẽwandamau, ĩsmua atagan chadau pãar peerdʉ wënʉrraju aai nʉm a jaau simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Maimua, Mua warre pãrag jaaukhimgui ajim anʉm: Mʉg vino döbarm aigmua mua chan tag döba, ãba Ẽwandamta thumaam khʉʉn Pörkha sĩsim edta deeu ag khãyaujã ajapcharamta döjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesús mag ich khapeen dʉ̈i ãba mes gaai iyʉ̈ʉ thach khö naawia, meukhaarjã Ẽwandam iek Salmos anʉm gaaim auwia, Olivo durrsĩig ërëujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mag wëtwia mam pabaimaawai ich Jesuu amag magjim anʉm: —Nau pãach thumaam khʉʉnau mʉ mʉch appai barpʉaju. ¿Jãgwi mag chirʉ́? Ich warrgarwe Ẽwandam i jaaumienau Ẽwandam iek phã pʉarr gaai ich mag aju a sĩewaima. Mag amau phã pʉarr gaai jaauwai, Ẽwandamau ʉdʉraa chi nemchaain pap õrag thõopiju a sim, mʉ igwia. Mag mʉ thõopʉ̈yaag pʉr athaawai pãar sĩi nemchaainjö parhoob pãach papjã khaugba, chawag aaidʉju a phã simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pari mag mʉ thõopʉ̈iwiajã deeu iiu phiidʉwia mʉchta pãar na majugui ajim anʉm, Galileaag. Mamta deeu pãar dʉ̈i oojugui ajim anʉm ich khapeenag. ");
INSERT INTO noaE_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jesuu mag iekhabaawai Pedroou irig magjim anʉm: —Mʉ khapeenau pʉ ogdʉwia chawag aaidʉtkhawiajã mʉ chan bʉ̈ʉrjã pʉ aigmua chawag ogdʉbamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pedroou ichig magbaawai Jesuu irig, —Pʉ mag iekha chirab mamʉ, cha mʉ iekha chirʉm iekhau nau ãspajuag ãthãrr biek numí bĩeju nawe õrau pʉchig jëeubaawai pua biek thãrjup mʉ khaugba chitʉm ajugui ajim anʉm ichigcha. ");
INSERT INTO noaE_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Magbaa Pedroou jũrr irig, —Pʉ thõbaimam aar thõimaju awiajã mua chan pʉ kha ogdʉbajugui ajim anʉm. Pedroou mag ijẽjẽb khaawai tagam khʉʉnaujã ich agjö, “Maraujã pʉ kha ogdʉbaju” a iekha naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesuu ich khapeen ich dʉ̈i phë arrwia nemjĩirdö Getsemaní anʉm ee barwia amag, —Mʉ chum Ẽwandamag jëwaan mamich, pãar mʉig nʉisit ajim anʉm tagam khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Magpet awi thãrjuppai ich dʉ̈i phë arrjim aajem: Pedro, Santiago maimua Juan. Maimua amach appai aphöbaadëm aig, Jesús nem ökhĩirjuuga aadëmua gaai machaaga aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ich magbaadeewai ichdëu amag magjim anʉm: —Mʉʉn dëgölp gaai machgau ökhĩirjuuga aadëm; ãba mʉch thõjuuta khĩirju chirʉmgui ajim anʉm. Pãar mʉig nʉisit, mamʉ daukhana abat. Oob khãimiet ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Magpet awi ichin ag atgajãrpai kanieu phõbkhanaa, jẽb gaai dagau dʉrnaa, Ẽwandamag jëeumamua i gaai machag ãwatpibaju akhiin ʉ̈u akham a jëeumajim aajem. Magnaa, ");
INSERT INTO noaE_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Tata, pʉ ithee chan bʉ̈ʉrjã phithurm nem chukhum. Pua khõs chirʉm khai mʉ peerdʉ athá ajim anʉm, mʉ dau aphʉʉ aju nawe. Pʉrʉg mua jëeu chirʉm, mamʉ mʉchdëu khõsi chirʉmjö khaba pʉchdëu khõsimjöta abá mʉ dʉ̈i a jëeumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mag jëeu sĩewi am aig bëewi oocheewai am khãi nʉmta oochëjim anaabá. Magbaawai jũrr Simonagta, —Pʉʉn sĩita khãi chirabma. Pʉ chan oradam ãbjã pöd daukhana aju khabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sĩi jãg khãi nʉʉ aju khãai Ẽwandamagta jëeubat ajim anaabá, dösãtag ʉdʉʉr pãach thʉ aupim ugua. Mua oowai pãach ödiiwan chadcha pãrau jëeum khõsi durrumta pari daphökgauta pödba nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mag iekha pʉawi deeu am aigmua petajim aajem. Maimua Ẽwandamag ichdëu nacha jëeu sĩerrjö ich ag iekpai iekhamamua deeu jëeumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mag jëeu sĩi awia deeu oon bëewaijã, i khapeen daphökgau pödjã dau ẽeba, sĩi khãidʉtkha thʉnʉmta oochëjim anaabá. Mag daphökgau pödjã dau ẽepiba thʉnaawai Jesuu amachig iekhabaichëmjã pöd i iek ʉ̈khaju khaugba naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mag biek thãrjupam gaaijã agtha khãidʉtkha thʉnʉm oobaicheewaita deeu amag, —¿Agtha pãar sĩi khãai gaaita nʉ? Khãigap nem pʉabat ajim anʉm. Pekau pöm sĩsidʉm khʉʉnag mʉch chi Emkhooi Iewaa pʉr deeju ora pabaichëbahab. ");
INSERT INTO noaE_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Phiidʉtkhabat, maimua maach khapeen aar wëttarrau ajim anʉm. Mʉ oomapham khʉʉnag mʉ pʉr deeju wounan ya dakpa urumgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús agtha mag iekha dʉnʉm ee, ich khapeenpai mag doce narr eem ãb Judas anʉmta õor pochag urajim anʉm. Mag wëdurum khʉʉnan ãaur khʉʉn sĩi espaar jua panhapha bëe thʉnaawai tagam khʉʉn sĩi pa dʉ̈ijã bëe thʉnaajim aajem. Makhʉʉn phadnaan chi pörkha nʉm khʉʉnau Ẽwandam iek jawaag chi machnaanau tagam khʉʉn jöoin chi pörnaan dʉ̈imua pʉ̈itarr khʉʉn ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mag chadcha õor pochag bëewi ya chi Judaau ag nawe, “Nau mua mawia pãach dakhĩir khĩir ʉ̈ʉ athamta pʉr auwia athaadët” a jaau wai sĩerr aawai, ");
INSERT INTO noaE_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","chadcha ich dʉ̈i wënʉrrʉm khʉʉn dakhĩraa ichdëu jaautarrjö Jesús dʉ̈i ãba dʉnʉʉuwimawia irig, “Maestro, ¿jãgpai chirʉ́?” anaa i khĩir ʉ̈ʉ athajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Magbarm bʉ̈rre chi soldaaunau Jesús phʉʉr thuur auwia i pʉrphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mamʉ chi khapeen i dʉ̈i wënʉrrarr khʉʉnau amach dakhĩir mag amach khapeer pʉrphöbaadëm oobaawai ãbmua ich espaar chi baindegam sʉrr a jẽu aunaa waa phadnaan thumaam khʉʉn pör ag chog kachta bis abarmʉn oorthu werbpʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mag ich pʉrphöbaadeewai Jesuu amag, —¿Pãrau oowain mʉʉn sĩi õor nem jĩgkhanaa õor thõomiejöta chirab ajim anʉm, jãg pãrau sĩi mʉ aig jua ee jierrnem panhappai bëeg ithee? ");
INSERT INTO noaE_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ag na ed ëepierr pãrag mua Aai i jëeujem deg Ẽwandam i jaaujeewai bʉ̈ʉrjã pãrau mʉ pʉr auba arrta ĩsta chadcha pãrau mʉ pʉr auju ed ajimgui ajim anʉm. Pari pãrau mʉ dʉ̈i mʉgbarmʉn, jãan mʉ igwia ich Ẽwandam iek phã sim gaai jaau sim thumaa ich ag ee öbëbërg mamkhĩirta chadcha mʉgbarmgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Chi khapeenau mag amach dakhĩir amach Pör pʉrphöbaadëm oobaawai tag irigjã ooba, sĩi warag khaphig phöbaadëwia ich appai barpʉajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mamʉ mag amau ich appai i werpʉawia athaadëm ee, ẽwan ãb sĩerrauta sĩi börrjöoupai öpʉʉrnaa dʉ̈i i ẽudee maa ajim aajem. Mamʉ chi soldaaunau mag woun dʉ̈i mam oo athaawai i pʉr awaag ẽkha naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pari mag ich gaai pʉrbaichee sĩi warag am jua ee chi börrjö jẽu pʉawi ich jãg mor kharr khaphigbaadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Soldaaunau mag Jesús pʉr auwia ãb mag phadnaan thum thʉnʉm khʉʉn pörkha sim aar warrjierram aajem. Mag mam i wai dubphöbaadeewai aig pos aimajierram anaabá: tagam khʉʉn chi phadnaan pörkha nʉm khʉʉn, judionaan Asamblea eem chi pörnaan, maimua agjö Moiseeu Ẽwandam iek phã pʉarr jawaag chi machnaanpa thum ãba. ");
INSERT INTO noaE_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mag i pʉr athaadëm ẽudee ĩchab Pedroou sĩi warppaimua oopʉ̈pʉ̈ig mawia phadnaan pör sĩejem ag di ũjãrr dʉ̈i dubwi jupimajim aajem, guardianaan Aai i jëeujem di thʉajem khʉʉn bigaau. Mag jupimawi i iek õt uu thʉnʉm bigaau dʉ̈i chi guardianaanpa ãba õt khãai oo chirsijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Maagwai phadnaan chi pörnaanau judionaan Asamblea eem khʉʉn dʉ̈imua chi Jesuu nem wauba arrta sëukha i gaai thʉpʉ̈iju ẽkhaajeejim anaabá, magʉm gaaimua i thõopäaig. Mamʉ chadcha irua bʉ̈ʉrjã nem khaigba wauba sĩerr aawai ");
INSERT INTO noaE_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","parii i khaibag waupi jaau nʉm khʉʉnaujã sëukha nem ĩgkham khõchgau amach iekpai parhoob jaaubaadëphʉmjã pöd i pʉr auba aajeejim aajem, mag ihãbajã khaba sĩi aaiphur nem jaauphöbaadëp aawai. ");
INSERT INTO noaE_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Warm khʉʉnau mamagkham ee, jũrr deeum khʉʉn bʉ̈jãau paaukhabaadëwi chi thethemnaanag ich khĩircha, ");
INSERT INTO noaE_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Marau maachdëucha i iekha sim ũurwain, irua mʉg Aai i jëeujem di õrau da ëu auba arrjã sĩi thum pogueupʉ̈iwia, õor juajã igba, khãai thãrjuppaim ee deeu ëu dʉnʉʉuju a iekha sim ũrjimgui aajeejim anaabá jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mamʉ par jũrram khʉʉnau mamagkhamjã ihãbajã deeba, sĩi warag maadëujã khaugbata jaauphöbaadëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Magbaa chi phadnaan pöröu sĩi mag õor pos thʉnʉm ee phiidʉbaadëwi Jesuug, —¿Pua am iek ũr chirʉ́? ¿Khan jãgwi jãg pʉ iekhamapha sĩ? ajim anʉm. ¿Pua chadcha mag iekhajĩ wa iekhabajĩ? Jaaubá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mamʉ magʉmjã Jesuu bʉ̈ʉrjã jʉ̈ʉjã aba, sĩi warag khĩuu sĩsijim anaabá. Mag ich iek ʉ̈khaba abaawaita deeu chi phadëu pʉaba jëeumamua irig, —¿Pʉʉta chadcha Ẽwandam Iewaa ichdëucha jʉr auwi pʉ̈iju jaaujerrá? Marag jaaubá ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Magbaa Jesuu, —Ëera, chadcha mʉʉugui ajim anʉm. Mʉg atag pãrau mʉ Ẽwandam thumaam khʉʉn khãaijã jua theeg ʉ̈rpai sĩerrʉm bigaau i juachaar garcha jup chirʉmjã oowi ʉ̈gtharmua edjã baug ee urumjã pãach daúacha deeu mʉ oobajup ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesuu ich dakhĩir mag iekhabarm ũrbaawai chi phadnaan pöröu ich khajũa mor gaai jũa sĩerrta sʉrr abarmʉn warre jẽbpʉ̈ijim anaabá, khĩir machgau. Magwia ich khapeenag, —Keena, ¿khan atchata maadëu deeum khʉʉnau jaau nʉmta ũrm ig nʉma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya irua ich iiucha jaau sĩebahab ajim anʉm. Pãrau thumaam khʉʉnau i iekhabarm ũrbarm, chadcha irua Ẽwandam dau na khaigba iekhabarm. ¿Pãrau mʉg woun dʉ̈i jãga aju khĩirju nʉ keena? ajim anʉm ich khapeenag. Magbaawai thumaam khʉʉnau ihãba, —Jãan iekkhõr pöm sĩewai ichiita thõopʉ̈ijugui ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Magphöbaadëwi ãaur khʉʉnau warag i khĩir gaai ichöoujã thunaa, putiujã i dau phãarjʉ̈naa, i gaai mas waunaa, juajãaujã khĩidadcha deejeejim anʉm. Magnaa ogthom irig, —¿Khaíuta pʉ gaai mas deejĩ? Magan jaaubá aajeejim anʉm. Mag jũrram khʉʉnau i mag wai naawai chi Aai i jëeujem di thʉajem guardianaanaujã dʉ̈i i khĩidadcha deejeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mam ierr Jesús dʉ̈i mamag khaawai Pedro iek i di ũjãrr chirajim aajem, daaugajãr. Maig i chirʉmta i aig ʉʉi ãb bëejim aajem, phadnaan thumaam khʉʉn pörkha sim ag chog. ");
INSERT INTO noaE_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mag ʉʉirau Pedro õt khãai sim oobaicheewai i khĩir eerpa wai dʉnʉʉ awia irig, —Pʉjã ĩchab Jesús Nazaretpierr dʉ̈i nʉrraajem khabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ichig magbaawai i iek irua, —Mʉ khabam, mua khaugbam pua khaita jaau sim khai a chirajim anʉm. Magwia warag dawag mawia puertdi daaugajãrm aar i oothẽu chiirbaimamta, ãthãrrta kekerekee aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Maimua deeu ũmaai chi ʉʉirau ichdëu i oobaawai aig õor thʉnarr khʉʉnag, —Chamʉg woun chadcha Jesús dʉ̈i nʉrraajerr khabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mag, biek numiim gaaijã Pedroou irua magʉm Jesús khaugba chitʉm ajim anʉm. Mamʉ ag khur nʉʉpai awia deeu ũwaai aig narr khʉʉnau, —Chadcha pʉʉn ĩchab Jesús khaperau. Pʉ Galileapierr khabahab ajim anʉm. Maguata pʉ iekha sim ũurwaijã pʉ iek gaai merag chukhu sĩsim khaphöbaadëjim anʉm irig jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pari ichig mag nʉʉ paawai Pedro iek warag irua chi Jesús igwia, —Chadcha mua magʉm woun khaugab chitʉmta mʉrʉg mag naab. Mʉ sëukha chirʉm khai, Ẽwandamau mʉ gaai jua khʉaba deeju aai simgui a chirajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedroou mag irua chan bʉ̈ʉrjã Jesús khaugba chitʉm a iekhabarm ee, deeu ũmaai chi ãthãrrta kekerekee ajim anaabá. Mag ãthãrr biek numí bĩe dichdimaawaita Pedroou warre Jesuu ichig iekhamatarr khĩir eyaa aadëjim anʉm, “Ãthãrr biek numí bĩeju nawe pua biek thãrjup õrag bʉ̈ʉrjã mʉ khaugba chitʉm a iekhaju” ichig Jesuu jaautarr. Ichig magtarr thumaa khĩirju athaawaita warre ökhĩirjug machag aadëmua icharaucha ö jãsehne bĩe chirʉʉ ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Maimua ag ãspaau edpherre thum chi thethemnaan ãbam aig podpajierram aajem, khĩirjug jʉrwi Pilato aar paawai Jesús khaibag waupiju jaau khaphʉ jawaag. Maig naajim aajem: phadnaan chi pörkha nʉm khʉʉn, Moiseeu Ẽwandam iek phã pʉarr jawaag chi machnaan, judionaan eem jöoin chi thierrnaan maimua tagam khʉʉn agjö chi Asamblea eem khʉʉnpa thʉnaajim aajem. Makhʉʉnauta amach thumaam khʉʉnau Jesús jua jʉ̈khanaa Pilato aar arrjierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mag ich aar wai barbaimaawai Pilatoou ich Jesuug —¿Chadcha pʉʉta judionaan Reí? a jëeujim anʉm. Magbaawai Jesuu irig, —Pua khabá khaphʉ jaaubapʉ̈im ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mag warag chi phadnaan pörkha nʉm khʉʉnau ich khĩircha iek pöm amachdëu jaaum aig sëukha iekhamatarr igwia ");
INSERT INTO noaE_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","deeu ũmaai Pilatoou irig, —¿Khan jãgwi pʉ iekhamaphamjö sĩ? ajim anʉm. ¿Pua ũrbahab, jũrram khʉʉnau pʉch khĩircha pʉch khaibag waupi jaau nʉm? ");
INSERT INTO noaE_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mamʉ parii Pilatoou ichig mag jëeu ahaukhamjã sĩi warag khĩuu abaawai ich ödegpai, “Wounaan mʉg oohba chitʉm” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatoou ag nawejã añopierr mag phiesta Pascua anʉm burrwai presonaan eem ãb parhoobam chi phöbörpienau jëeubarm öbeerpäaijeejim. ");
INSERT INTO noaE_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Maagjerr aawai ich mag jaar woun ãb Barrabás anʉmta deeum khʉʉn dʉ̈i cárcel deg preso sĩejim, ichdëu gobierno dʉ̈i õor meeukhapiwia ag meeukhaa ee õor thõotarr gaaimua. ");
INSERT INTO noaE_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mag nemkhoopierr preso ãb sĩi öbeerpäaijerr aawai chi phöbörpien ãbam aig biirdʉwia ag na Pilatoou ichdëu aajerrjö preso ãb öbeerpʉ̈imkhĩir irig jajaau aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ichig magbaawaita Pilatoou amag, —¿Pãrau judionaan Rey Jesuuta mʉrʉg öbeerpʉ̈ipi nʉ? a jëeujim anaabá jũrr amag. ");
INSERT INTO noaE_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Irua mag Jesuuta öbeerpʉ̈im khõsi sĩerran, phadnaan chi pörkha nʉm khʉʉnau sĩi amachdëu Jesuu nem wau nʉrrarrjö pöd nem waubam gaaimua iekkhõr wau nʉm iekhauta mag i pʉr dee wai nʉm khaphʉ sĩerr aawaita mag iekhajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","¡Ih! Mamʉ Pilatoou mag iekhabaawai chará chi phadnaan pörkha nʉm khʉʉnau sĩi warag õor wawikha thʉnʉʉujim anʉm, thumaam khʉʉnau ãba Barrabaata sĩi ich jãg weeupʉ̈ipi jajaau amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mag Barrabaata sĩi öbeerpʉ̈ipim khõchkha nʉm ũrbaawai deeu Pilatoou, —¿Mag judionaan Rey anʉm dʉ̈i mua jãgajuma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Magbaawai warag serereukhamua Jesús warre pakuls gaaita meerphëpi jajaau aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Magbaa jũrr Pilatoou amag, —¿Pari khan nemta irua khaigba waujĩma ajim anʉm, pãrau mag warre i thõopi jaau nʉm? Mamʉ irua magbaawai chará warag ich mag pakuls gaaita meerphëpi jajaau aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mag warag serereukhamjã pʉaba aawai, õor pöm mag thʉnʉm jũrr ich dʉ̈ita meeukham ugua, chadcha am ipierr Barrabaata weeupʉ̈ipi jaaujim anaabá. Maimua chi Jesús jũrr wʉpi jaaunaa pakuls gaai meerphëpʉ̈imkhĩir warre amach jua ee deepʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Magbaawai chi soldaaunau Pilato sĩejem ag di ũjãrr chi Jesús warrwia soldaaun thum ãbam aig thʉ̈rkha aujierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mag warrnaa, irig khajũa khichphë khĩir jũapinaa, ich agjö miu dën wërjũch phʉʉrthʉ waunaa, pör gaai pörsirkha jũapipʉ̈ijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mag jũapipʉ̈inaa juau ogthom chi soldaaunaupai i wau iekhamamua, —¿Jãgpai chirʉ́ judionaan Rey? aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mag wai nʉmua i pörchajã paau wʉnaa, khĩirchajã ichöou thunaa, sĩi i wau nʉm iekhau i khĩirpheejã kanieu phõbkhakha aajeejim anʉm, amach rey anʉmua. ");
INSERT INTO noaE_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mag i dau aphʉʉ wau wai nʉʉ awia, amachdëu irig khajũa khichphë khĩir jũapitarr deeu ẽer auwia, ich khajũa chaardamta deeu jũapipʉ̈inaa, pakuls gaai meerphëpäain athaadëjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mag Jesús pakuls gaai meerphëpäain arrum ee, am khĩirphee woun ãb Simón anʉm ich phidag eemua ich diig urajim aajem. Mag woun Cirenepierr ajim aajem, Alejandro dʉ̈i Rufo anʉm am aai. Chi soldaaunau mag Simón oobaawai jũrr ajués irigta Jesuu pakuls arrmaa atarr arrpijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mag ërëu phöbaadëwi buchagdam Gólgota anʉmʉg arrjierram aajem. Maach meúan mag Gólgota anʉmʉn Pörpá Durrsĩ a simʉu. ");
INSERT INTO noaE_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Maig Jesuug vino mirra ee waaurëu sim döpiju ẽkhajierram anaabá, khaparr aadëmua gaai machag thʉnʉm ãwatamkhĩir. Mamʉ Jesuu bʉ̈ʉrjã döbajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mag dee nʉmjã döba abaawai ich mag pakuls gaai meerphëpʉ̈ijierram anaabá. Mag meerphëpʉ̈iwia, khaíuta i khajũa wai sĩsiju khai awi, chi soldaaunau i khajũa jũajerr ʉ̈r phatkhon bar jemkha nʉmua amachpierr agdaujö gan aumajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mag amau i pakuls gaai meerphëpäaiwai ya edaupherr garm las nueve thʉnaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mag i meerphë wai narr pakuls gaai i pör ʉ̈r ẽsapdau phã sĩejim anaabá. Mamʉ mag nem khaigbam wautarr jaauju chukhu arr aawai sĩi “Judionaan Rey” a phã sĩejim. ");
INSERT INTO noaE_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mag i meerphëbapʉ̈im dʉ̈i ĩchab agjö nem jĩgkhaajem khʉʉn numí amach khĩkhĩetdö i bigaau pakuls gaai meerphëgkhapʉ̈ijierram aajem: ãb i juachaar gar, maagwai ãbakhai i juawë gar.  ");
INSERT INTO noaE_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mag nʉm aiguin warrgarwe Ẽwandam i jaaumienau phã pʉarr gaai, “Chi khaigbam khʉʉn jãrr wai naaju” a iekhatarrjã thum chadcha ag eyaata öbër sim. ");
INSERT INTO noaE_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mag i pakuls gaai meerphë wai nʉm aig dich nʉm khʉʉnaujã i wau nʉm iekhau irig eerpanaa, ʉ̈iphʉʉrphʉʉrnaa, “Wa jãgʉm khabá, puan mag Aai i jëeujem dijã thum pogueupʉ̈inaa deeu khãai thãrjuppaim ee ëu dʉnʉʉuju aajerrta, ");
INSERT INTO noaE_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","jãg pua wir aig pʉchpai peerdʉ auwia jãg pakuls gaaimua eeg ʉʉrbabáma” aajeejim anʉm, dich nʉm khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sĩi dich nʉm khʉʉnaujã irig mag iekha ërëu dich thʉnaawai ich agjö phadnaan chi pörnaanaujã Moiseeu Ẽwandam iek phã pʉarr jawaag chi machnaan dʉ̈imua amach ee wir aigpai, “Bigaaum khʉʉnan peerdʉ autarrta jũrr wir aig ichpai chan pöd peerdʉ auba sim” a iekha naajim anaabá, i waauwai. ");
INSERT INTO noaE_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Magnaa ichigcha iekhamamua, —Israelam Rey, ¿pʉch khabá õor peerdʉ aumkhĩir Ẽwandamau pʉ̈itarr? Magan pakuls gaaimua eeg ʉʉrbabaad anaajim aajem. Pʉ chadcha maar dakhĩir eeg ʉʉrbamʉn, maach daúacha oobaawai marau pʉ iek ʉ̈khaju anaajim anʉm irig. Ich dʉ̈icha mag ãba õor numí agjö pakuls gaai narr khʉʉnaujã irig iek khaigba iekha naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ich mag ed edausĩe thʉnʉm ee dëgölp edau khĩbaadëm abarmʉn sĩi warre edaramjöta jöisijim anaabá. Mag khĩ thʉnʉʉ awia edau phʉʉibaajër las tres naata deeu edau aardʉbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ich mag edau khĩbaadëm ee Jesuu thet äa a khitawia, “Eloi, Eloi, ¿lema sabactani?” ajim anʉm. Mag sim aig maach meúan: “Aay Ẽwandam, ¿khantheeta pua mʉ mʉg dau aphʉʉ chirʉmjã mʉrʉg oobamjöo aadëma?” a simʉu. ");
INSERT INTO noaE_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Magbaawai aig õor narr khʉʉnau Jesuu mag iekhabarm ũrbaawai jũrr amach khapeenag, —Keena, pãadë ũrbat. Maguan warrgarm Ẽwandam i jaaumie Elías khararrta ich aig thʉ̈r simwai ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Magbaawai ãbmua khaphigbaadëwia, putjö ũũpphë khitʉm gaai vino adchuchúu simta dorrdʉnaa aibëewi, pa gaai bʉʉrnaa, i i aig ʉa aujim aajem, ag gaaim bereu dömkhĩir. Magnaa ichdëupai warm khʉʉnag, —Jãgnaan chad idëu sĩi ootarraugui ajim anʉm, daau chadcha Eliaau bëewi i eeg jiirbapʉ̈ichëju. ");
INSERT INTO noaE_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pari mag nʉm ee deeu Jesuu thet äa a khitawia warre chaaupabaadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Magbarm bʉ̈rre ĩchab Aai i jëeujem deg ierr dijã garcha put nem parrg sim ëu wëjorrta sĩi ʉ̈gthaamua eeg sʉrr abarmʉn warre jãrrcha thoophem numí jijirar jöisijim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mag Jesús äa awia meebaadëm oobaawai chi soldaaun am capitán chi Jesús jiir wëjöm khĩirphee oo dʉnarrau, —Chadchata jãgan mʉg wounan Ẽwandam Iewaaugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Maig ĩchab ʉʉinjã naajim aajem. Makhʉʉn ʉʉinau sĩi warppaimua eerpa durruu ajim anʉm. Chi maig narr khʉʉn, María Magdalena ajim aajem, ãb agjö María a thʉ̈r sĩerrpa. Mag María Santiago ãd anaa ĩchab José ãd ajim aajem. Maig deeum ʉʉi Salomé anʉmjã dʉ̈i sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ich makhʉʉn ʉʉinauta i Galilea ee nʉrraawaijã i dʉ̈i wënʉrrʉmua irua nemdam iigwaijã thumaa irig au dedee aajeejim aajem. Maagjerr aawai Jerusalenagjã i dʉ̈i bëewia dʉ̈i aig naajim anaabá. Pari makhʉʉn appaijã khaba, mag tag ʉʉin khapan am dʉ̈i bëetarr khʉʉnjã ĩchab aig naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Amau mag i dau aphʉʉ wai khëumaa arran sĩi nem thum khĩir khaug sĩiujem ed ajim, jua ʉ̈i kheeujem noram. ");
INSERT INTO noaE_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mag ya kheeuraa aadëm ee, woun ãb judionaan Asamblea eem José Arimateapierr majim aajem, Pilato aar. Mag woun ĩchab chi thethem ajim anaabá. Mag wounaujã ĩchab Ẽwandamau maach peerdʉ aumkhĩir pʉ̈iju jaaujerr bëeju anʉmta nʉajeejim aajem. Ich mag wounauta Pilato aar mawia ");
INSERT INTO noaE_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","irig jëeuwimajim aajem, chi meemdam arrwi aukhëraan maag. Mag Jesús meebaadëm a ũrbaawai Pilato warre jʉ̈gderraa aadëjim anʉm, irua khĩirjuawain Jesús meeba agtha iiu sĩeju aai simta mag meebaadëm a ũrbaawai. Magbaa Pilatoou chi capitán mag dʉ̈i meerphë nʉm aar sĩerrjã thʉ̈rpʉ̈ijim aajem, magʉg khap jëeu oog. ");
INSERT INTO noaE_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Maimua chi capitán bëewia chadcha meebaadëm a jaaubaawai Pilatoou Joseeg arrmkhĩir jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Magbaawai Joseeu dĩesdam për auwia, mawia, mag Jesús chi meemdam pakuls gaaim eeg jiir aunaa agua ajapha pʉrëupʉ̈ijim aajem. Magnaa ag nawe jẽbdi durrbʉ̈ khõpag ee chi khörm sĩerr ee aukhërwia chi jẽbdi i ee ajapha mok pör pöm simua joothʉ pʉajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mag chi binaandam jẽbdeg aukhërbarm ʉʉin numiim khʉʉnau warppaimua oo naajim aajem. Makhʉʉn ʉʉin ãb María Magdalena ajim anʉm, maimua ãbkhai José ãd agjö María a thʉ̈ʉrjerr ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mag thumaam khʉʉn jua ʉ̈i kheeujem ed khëubaadeewai María Magdalena, ãbakhai María Santiago ãd maimua Salomé dʉ̈i amach thãrjupam khʉʉnau jʉ̈gdee përkha sĩujierram aajem, agua Jesús kha phuraan maag. ");
INSERT INTO noaE_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Maimua ag noram domighed ãspa ëebaadeewai edaupherre õor mor dawaa aadëm ee, i aukhërtarr jẽbdi aar oon wëtjierram aajem, mag jʉ̈gdeeu i kha phuraag. ");
INSERT INTO noaE_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mag wëtwi amach appai khʉd ee, —Keena ¿khaíuta chi jẽbdi ʉ̈rʉm mok maachig chawag pʉrëu deejuuta mʉg wëtúma? a iyʉ̈ʉ wënʉrrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mamʉ mag iyʉ̈ʉ wëtmamua barimanaa ooimaawai, chi jẽbdi i ee mok pör pöm simua joothʉ sĩerr jũrr chawag pʉrëupʉ̈i thʉnʉm ooimajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Magbaawai warag ierr dubwi ooimaa, woun ãb ẽwanaa khitʉmta sĩi khajũa bäpphä khajũa bʉ̈ etherr jũa simta mag jẽbdeg juachaar gar jup oo sim ooimajierram aajem. Amachdëu mag oobaawai warre jãphierr phöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mag ʉʉin jãphierr phöbaadëm oowi chi woun khajũa bäpphä jũa sĩerrau amag, —Oob jãphierrmiet ajim anʉm. Mua khaphʉ chirʉm, pãrau Jesús Nazaretpierr ar pakuls gaai meerphë thõotarrta jʉr wënʉrrʉm. Pari i mʉig khaba sĩebahab ajim anʉm, ya iiu phiidʉwi petarr aawai. Pãadë oobat i aukhërtarr ee sĩi khãidu parii simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Maimua amag, Ërëubaadëwi i khapeen tagam khʉʉnagjã jaauwi Pedroogjã jaaubat ajim anʉm: “Ichin ya pãar nawe Galileaag petam. Nau jamta i ooimaju” a jaaubat ajim anʉm, ichdëu amachigcha ag nawe jaautarrjö. ");
INSERT INTO noaE_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Amachig magbaawai jãphierr nʉm iekhau bʉ̈ duui durrumta eerpamjö dawag öbërdʉtkhawi khaphig phöbaadëjim aajem. Maimua chi Jesús khapeen aar bardʉtkhaimaawaijã, agtha jãphierr narr aawai, bʉ̈ʉrjã iwiir ãbam khʉʉnagjã jaaubajierram aajem.  ");
INSERT INTO noaE_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Maimua mag domighed ãspaau Jesús iiu phiidʉwia María Magdalenaagta nacha ich oopijim aajem, i aig öbërchëwia. Ich mag ʉʉi mor eem ajim aajem, ag nawe ich Jesuu mepeen khaigbam khʉʉn siete dau daau jʉrkhʉʉipʉ̈itarr. ");
INSERT INTO noaE_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ichdëu mag oobaawai chi Jesús dʉ̈i wënʉrraajerr khʉʉn gaai machgau bĩe durrum aar mawia amag jaauwimajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mamʉ mag amachig ich daúacha Jesús iiu phiidʉwi nem moná nʉrrʉm oojim a jajaaukhamjã i iek ʉ̈khabajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Magtarr khur deeu ũwaai deeum khĩir thegnaa ich khapeen numí phöbör eemua khʉd ma sim ee wëtmarr khʉʉnagjã ich oopijim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mag amachig ich oopibaawai makhʉʉnaujã agjö deeu ewag wëtwi ich agjö chi i dʉ̈icha ogdʉba wënʉrraajerr khʉʉnag jaauwimajierram aajem. Pari makhʉʉn iekjã bʉ̈ʉrjã ʉ̈khabajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Maimua ãbmiecharam gaai paawai Jesuu ich khapeen once ãbam aig thach khö narr aig bëewia ich oopijim aajem. Maimua iyʉ̈ʉmamua amag meeurrau sĩujim anaabá. Mag meeurrau sĩutarran, maan ich iiu phiidʉwi nʉrrʉm ootarr khʉʉnau jaau nʉmjã amach jʉ̈g theegau bʉ̈ʉrjã ʉ̈khaba arr gaaimuata mag meeurrau sĩujim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Maimua ich Jesuu magjim anʉm amag: —Jãimua ërëu phöbaadëwi Ẽwandamau õor peerdʉ aaujem iekta durrpierram magwe thumaam khʉʉnag jaaupetat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chi mʉ iek ʉ̈khawi ich pör choopi sim khʉ ʉ̈u peerdʉju. Mamʉ chi mʉ iek jaau nʉm ũr simjã ʉ̈khaba sim chan Ẽwandamau i peerdʉ auba warag i isegpʉ̈ijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chi mʉ iek thãraucha ʉ̈kha nʉm khʉʉnau mʉchdëu aajerrjö, mua mʉch juapá deebarmua õor mor eem mepeerjã öbeerpi jaaubaawai chadcha dau daau öbeerpʉ̈imajugui ajim anʉm. Magnaa ĩchab deeum meu ich meu khabamta ag nawe iekhaajerrjö iekhaju. ");
INSERT INTO noaE_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nemkhõr benen paraam gaai juau pʉrbaawai khaakhiinjã bʉ̈ʉrjã chig abaju. Õor thõojem pakhër khãijã õrau döpipʉ̈iwiajã bʉ̈ʉrjã chig abaju; mag nʉm dʉ̈i ĩchab õor mor masim khʉʉn kõit Ẽwandamag jëeunaa am gaai juadamau pʉrbarmuapai monaaupʉ̈imaju a jaaujim aajem. Mua pãrag mag nem waupi chirʉmʉn, mag pãachdëu wau nʉm gaaimua õraujã mʉ iekta pãrau jaau nʉm khap amkhĩraugui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesuu ich bʉ̈ ogdʉba aajerr khʉʉnag mag jaau aaipabaadeewai ich Ẽwandamaucha maach Pör Jesús ich aar aujim anaabá, ʉ̈gthar. Mag Jesús ʉ̈gthar pabaimaawai warre ich Ẽwandam bigaau i juachaar garta jupimajim aajem, ag nawe ichdëu amag jaaujerrjö. ");
INSERT INTO noaE_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Magbaawai i khapeenau wëtwi chadcha amachig jaautarrjö durrpierram magwe maach peerdʉajem iek õrag jaau wënʉrrajim aajem. Mag amau jaau wënʉrrʉmpierr ĩchab ich Jesuu am juag oojeejim anaabá, ag na õrau ooba aajem nempa amag waupi sim gaaimua. Magʉm gaaimuata õrau chadcha khaphʉ aajeejim aajem, amau i iekta jaau nʉm.");
INSERT INTO noaE_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teófilo, khapeer wʉ̈jʉ̈u: Mʉg ẽsap gaai murua pʉrʉg jawaagpam Jesuu õrag iekhamatarr dʉ̈i irua nem waumatarrpa ãba. Pua khaphʉ sim, jũrram khʉʉnau ich mʉg iekpai phã ẽkha nʉm warrpem irua nem waubaaderr aarmua irua nem jaaumatarrpa. Maadëu khaphʉ nʉm, magʉm thum chadcha ajim. Maagwai õraujã thum ich ag iekpai maach ee khakhapdö wëjöm, ");
INSERT INTO noaE_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ar warrcha irua nem waubaaderr amach daúacha ootarrta õrag jaaujerr khʉʉnau maachigjã jaautarrjö. ");
INSERT INTO noaE_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Maguata muajã ĩchab phãju khĩirjubaadëjim, pʉ athee. Mamʉ mʉg phãju nawe, sĩi año khapan i dʉ̈i ãba wënʉrraajerr khʉʉn dʉ̈i khaar aarmua khĩeb ö nʉm aar estudie chirʉʉ awia ĩsta pʉrʉg phã deepʉ̈i chirʉm jöoi Teófilo. ");
INSERT INTO noaE_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mʉg murua pʉrʉg phã deepʉ̈i chirʉmʉn, pʉchdëu thʉ̈rbaawai Jesús igwia õrau jaau nʉm pua ũurjemʉn chadcharam iekhau a khap amkhĩrau. ");
INSERT INTO noaE_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Murua pʉrʉg jaaum ig chirʉmʉn mʉgau: Erodes Judea durr reikha sim jaar ĩchab sĩejim aajem phad Zacarías a thʉ̈r sim, judionaan eem. Mag Zacarías warrgar phad Abías khakhitarr dʉ̈i ãba phadnaan phidkhaajerr khʉʉn chaain ewagam khʉʉn dën arr aawai ĩchab Abianaan ajim aajem. Chi Zacarías ʉʉi Elizabed a thʉ̈r sĩejim aajem. Majã ĩchab warrgar phad Aarón a thʉ̈ʉrjerr ag chaain ewagam khʉʉn kha ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ich mag jöoi Zacarías anʉm ich ʉʉi dʉ̈i Ẽwandam dakhĩir ajapha wënʉrraajeejim aajem, i ipierraa. Mag gaaimua ãbmuajã am ëugar iek chigaapai iekhaba aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mamʉ mag wënʉrrʉmjã chi ʉʉi bʉ̈ʉrjã chaai ooba khitarr aawai chaai ãbjã chukhu naajim aajem. Mag chaaijã chukhu nʉmta ya amach numwe jöoiraa khithëe ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Mag nʉm ee jũrr Abianaanta Ẽwandamag jëeujem deg phidkhaju seman arr aawai mag jöoi Zacarías anʉmta ag deg phidkha sĩejim aajem, ich khapeen ich dʉ̈i ãba phidkhaajerr khʉʉnpa, warm khʉʉnaujã semanpierr ich mag phidkha diichjerrjö. Mamʉ mag phadnaan khapan thʉnaajerr aawai ed ëepierr ãb jʉr auwia Ẽwandam atheem incienso phaan duubjeejim anʉm. Amach warrgarwejã ich maagjerr aawai mag edjã mag nʉmua jöoi Zacarías thʉ̈rta öbërjim aajem, mag incienso phaag. ");
INSERT INTO noaE_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mag ich thʉ̈rta öbërtarr aawai ierr Ẽwandamag incienso phaajem ag nasãd wau khërʉm aar simich, daaugajãr amach biirdʉajem aigpaita sĩi õor pöm Ẽwandamag jëeu khodthʉnaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mag í agtha ierr Ẽwandamag jëeu sim ee, Ẽwandam chogta ʉ̈gtharmua bëewia i khĩirphee dʉnʉʉubaichëjim anʉm, chi incienso phaajem ag nasãd wau sim bigaau juachaar gar. ");
INSERT INTO noaE_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacariaau mag oo athaawai khĩir ëu awia warag jöoi kha duuibaadëjim aajem, jãphierr nʉm iekhau. ");
INSERT INTO noaE_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mamʉ magbaawai chi Ẽwandam chogau irig, —Zacarías, oob jãphierram ajim anʉm. Pua Ẽwandamag jëeu chitʉʉ aajerr ĩsta irua pʉ iek ʉ̈khabarm: Pʉ ʉʉi Elizabed bi ee pawia pʉrʉg chaai oo deejugui ajim anʉm. Mag chaai thaaba khërsiewai pua i thʉ̈rdam Juan a thʉ̈rjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Magbaawain chadau pʉ onee chirsiju. Mag nʉm dʉ̈i ĩchab õor pöm onee ajurau, i thaababarm abarm amachdëu ũr athaawai. ");
INSERT INTO noaE_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mag chaairau bi eewe Ẽwandam Akhaar ich gaai phẽs wai khitajugui ajim anʉm. Mag chaairau ich erraawe vinojã döba, ni nag deeum khĩir awia khãijã bʉ̈ʉrjã ich i ee auba ich mag khitajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mag chaai jöoipawia Ẽwandam iek jaaubaadeewaita israelnaan khapaana ãsie amach mor khĩirjuwia deeu eeupemjö maach Pör Ẽwandam iek ʉ̈khajurau, warrgar amach jöoinau ʉ̈khaajerrjö a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","I gaaimuata õor ee Ẽwandamau ich jua theeg oopijugui ajim anʉm, warrgar ich i jaaumie Elías khakhitarr dʉ̈i aajerrjö. Irua Ẽwandam i jaau nʉrrʉm ũrwia, jöoin amach chaain dʉ̈i khajap khaba wënʉrraajerr khʉʉnjã khõinaa wënʉrranaa ĩchab i iek ũrmapha aajerr khʉʉnaujã amach jöoin warrgarm khʉʉn dënjö i ipierraa aju, maagwai Ẽwandamau mag am Pörkhaju päaiwaijã amach thãraucha khõsi i iek ũrmkhĩir a jaauchëjim aajem chi Ẽwandam chogau. ");
INSERT INTO noaE_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Magbaawai jöoi Zacariaau, —Mamʉ ¿jãga magbarju? ajim anʉm, chi Ẽwandam chogag. Ya mʉg mʉ jöoiraa chirʉm, maimua mʉ ʉʉijã ĩchab ũanaa khitʉmta ¿jãga mag chaai oobarju? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Magbaa jũrr chi Ẽwandam chogau irig, —Zacarías, mʉʉn Gabriel a thʉ̈ʉrjemgui ajim anʉm. Mʉchta Ẽwandam garcha i bʉ̈khʉrr phidkhaajem. Ichdëu mʉ pʉ̈iwiata pʉ aig mʉ bëejimgui ajim anʉm, cha mʉchdëu iek jaau chirʉm jawaan. ");
INSERT INTO noaE_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mamʉ mʉg murua pʉchig jaau chirʉm pʉchdëu ʉ̈khaba abarm gaaimua, pʉ meu meraa chirsijugui ajim anʉm, bʉ̈ʉrjã iekhaba. Maimua ya chi chaai atham edta deeu pʉ iek eerdʉjugui ajim anʉm. Murua pʉrʉg mag jaau chirʉmʉn, chadcha thum mʉchdëu cha jaau chirʉmjöo aju a jaaumajim aajem, chi Ẽwandam chog ʉ̈gtharmua bëetarrau. ");
INSERT INTO noaE_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Magʉmich daaugajãr õor pöm Ẽwandamag jëeuwai pos thʉnarr khʉʉnau i nʉ nʉmua jũrr amach khapeenag, —Keena, ¿jãga abarmta mʉg jöoi Zacarías jãg da öbërchëbáma? anaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mamʉ mag nʉm ee öbërcheewaijã pöd õrag iekhaba, iekham ig nʉmjã sĩi juaupaita jajaau aajeejim anʉm, pöd iek öbërba aawai. Magbarm aigta khaugaa aphöbaadëjim anaabá, Ẽwandamau khãijã dau daau irig iekhachëwiata mag sĩsim. Maigmua atag ich mag jöoi meu meraa khërsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Maimua ich phidkha sĩerr seman thum öbër ëebaadeewai ich diig petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Maimua mag chi Ẽwandam chogau jaauthurtarr khur chadcha jöpcha Elizabed bi eepajim anaabá. Mag ich jõorbaadeewai dawagjã öbërba, cinco meses sĩi degpai sĩejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mag degpai simua, “Maach pör Ẽwandamauta mʉʉn eeg oobarmgui” aajeejim anʉm. “Chaai chukhu aawai õor ee khĩir naa ʉrraajerrjã tag mʉ chigag chukhu ʉrraju. Ʉ̈ucha jãgbarm Ẽwandamau” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Magtarr khur seis meses dichwia nʉm ee, Ẽwandamau ʉ̈gtharmua deeu ich chog Gabriel pʉ̈ijim aajem, jũrr Galilea durr phöbördam Nazaret a thʉ̈r sim ee daupeer õor meraa khitʉm María a thʉ̈r sĩerr aar. ");
INSERT INTO noaE_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mag daupeer woun ãb José anʉm dʉ̈i jua pʉraag ya iek deewi sĩejim aajem. Mamʉ mag iek deewi nʉmjã José bʉ̈ʉrjã agtha María dʉ̈i khapes aba naajim aajem. Chi José anʉm warrgar rey David khakhitarr ag chaain ewagam khʉʉn dën ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mag ich chogbapäaiwai chi Ẽwandam chog bëewi chi daupeer sim aar dubwia irig, —¿Jãgpai ʉ María? Onee abá aichëjim anʉm. Ẽwandamau nem ajapha aag ʉʉin khapan thʉnʉm ee pʉʉta jʉr atham. María, chadcha Ẽwandam maach Pöröu pʉʉta eeg oobarmgui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mag ũrbaawai khĩirju sĩi awia ich ödegpai “¿Jãgwia irua mʉrʉg mag iekhabaichë?” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Magbaawai chi Ẽwandam chogau, —Oob khĩirjum, pʉʉta Ẽwandamau ʉ̈u eeg oobarbahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pua chaai emkhooidam paarpaju. Mag chaai Jesús a thʉ̈rbá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ichta thumaam khʉʉn khãai ʉ̈rʉʉcha sĩerraju, maimua ichpai Cha Ʉ̈gthaa Phuu Nʉm ag Iewaa a thʉ̈rjugui ajim anʉm. Maagwai maach Pör Ẽwandamau irigta israelnaan thumaam khʉʉn Reikhapiju, warrgar pãach jöoin David khararrag khapitarrjö. ");
INSERT INTO noaE_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mag ichta thumaam khʉʉn Pörkhabaadëm aigmua atag i jua theeg bʉ̈ʉrjã öba, ich mag sĩerraju a jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Magbaawai Mariaau chi Ẽwandam chogag, —Mamʉ mʉg agtha mʉ õor meraa jaaijã chukhu ʉmta, ¿jãga magbarjuma? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Magbaawai chi Ẽwandam chogau magjim anʉm: —Jãan ich Cha Ʉ̈gthaa Phuu Nʉm ag Akhaar pʉ gaai sĩeicheewaita pʉ jõorjugui ajim anʉm, ich iiu aawai. Mag gaaimua mʉg chaai pua oobarm bʉ̈ʉrjã khaibag chukhu auwia ich mag khitaju. Ich Ẽwandamauta ich iiu pʉ bi ee papi sim dën aawai i thʉ̈r Ẽwandam Iewaa a thʉ̈rjugui a jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maimua warag irig, Pʉdë ũrbá ajim anʉm, pʉ naamhũan Elizabed ũanaa khitab mamʉ, iruajã chaai emkhooi paarpajugui ajim anʉm ĩchab. Õrau pöd irua chaai oobaju aajerrjã ya seis meses simgui ajim anʉm, bi ee patarr. ");
INSERT INTO noaE_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ẽwandam athee chan bʉ̈ʉrjã phithurm nem chukhumgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Magbaa Mariaau magjim anʉm: —Mʉʉn Ẽwandamau nem jawaata ũr ʉmgui ajim anʉm, ichdëu nem jaaubarmpierr aag. Mag khai magan Ẽwandamau cha pua jaau simjö aju aai sim mʉ dʉ̈i ajim anʉm. Mag jaau pʉawia chi Ẽwandam chog deeu ʉ̈gthar petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mag Ẽwandam chogau ichig iek jaauthurtarr khur khãai khapancha khaba nʉm ee, Mariaau ich naamhũan Elizabed oon majim aajem Judea durr, durr dapag ee phöbördam khërʉm ee. ");
INSERT INTO noaE_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mag petawia, jöoi Zacarías di aar barwia, ich naamhũanag, —¿Jãgpai ʉ Elizabed? aimajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mag Mariaau ichig iekhabaichëm ũrbaawai warre ũan Elizabed bi eem chaaita pogogor khabaadëjim anaabá. Magbarm dʉ̈i ich ũan Elizabed gaaijã Ẽwandam Akhaar phẽs aicheewai onegau Mariaag, ");
INSERT INTO noaE_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","—Kadam, pʉchta ãba chadcha ʉʉin khapan thʉnʉm ee Ẽwandamau ʉ̈uhcha abarm; maimua pʉ chaaijã ʉ̈ucha khitajugui ajim anʉm, õor ee Ẽwandam na. ");
INSERT INTO noaE_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Khanii mʉg mʉ aphʉʉ ʉrrʉmua mua khap ʉajĩ pʉ maach Pör ãdkha simua mʉch oon bëeju. Ʉ̈u pʉ bëejimgui ajim anʉm María. ");
INSERT INTO noaE_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jãguata pʉ iekhabaichëm mʉchdëu ũr atham dʉ̈i, mʉ chaai agtha bi ee khërʉmuajã khaug athaawai, thʉgdʉdʉ khabaadëjimgui ajim anaabá, onegau. ");
INSERT INTO noaE_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","María, Ẽwandam chogau pʉchig jaauchëtarr iek pʉchdëu ʉ̈khatarr gaaimua chadcha pʉʉta onee ʉrraju. Maach Pör Ẽwandamau ich chog dʉ̈i pʉrʉg jaaupʉ̈itarr iekhan thum ichdëu jaautarrjöo chadcha öbëbërgmajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Magbaawai Mariaau Ẽwandamag jëeumamua magjim aajem: “Ẽwandam, pʉchta ãba maar Pör aawai mʉch thãrauchata pʉrʉg ʉ̈u ajim a ʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mʉ thãar onee ʉm Ẽwandam, pʉch maar peerdʉajemuata mʉch dʉ̈i mʉgbarm gaaimua. ");
INSERT INTO noaE_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chadcha puan mʉ dʉ̈i pʉchdëu ampierr aju aai sim. Õrau oowai sĩi mʉg maadëu nem igab ʉrrʉmta pua mʉ jʉr atham. Pua mʉ dʉ̈i mʉgbarm gaaimua ĩsmua atag ich mag õrau mʉ igwia, ‘¡Maagwai jãg ʉʉi onee khaba ʉabá!’ ajurau. ");
INSERT INTO noaE_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pʉchdëupaita chadcha maar thum wai dʉnʉm. Pʉchdëu mʉ dʉ̈i mʉgbarm gaaimua õrau pʉ jua theeg khaphʉ nʉisiju. ");
INSERT INTO noaE_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mʉg atagjã ar pʉch ipierraam khʉʉnan ich jãg pua am dau ee aug khaug paraa chitaju. ");
INSERT INTO noaE_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pʉ jua theegjöm khʉʉn chan mʉg jẽb gaai ooba aajem. Wir aig amach thöo aajerr khʉʉnjã ya pʉ jua eegar paaukhabaadëm. ");
INSERT INTO noaE_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mʉg jẽb gaai chi thethem thethem aajem khʉʉnjã iek theeg chukhu isegkhʉʉiwia jũrr aphʉʉ maadëu igbajöjöo khithëem khʉʉnta pua pör phiriupʉ̈imaajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aphʉʉ jãdaúa durrumjö khithëem khʉʉnaujã pʉrʉg jëeuwai pua amachdëu nem ig nʉm thum deejem. Mamʉ riknaan, jũrr pua dau aug ee päaijem, pʉch igba nʉm kõit. ");
INSERT INTO noaE_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ẽwandam, pua nawe pʉch iekhatarr khĩir akhooba, chadcha ĩsta pʉch chognaan israelnaan ʉ̈u eeg oogpam, pʉchdëu warrgarwe maar jöoinag jaaujerrjö. ");
INSERT INTO noaE_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nacha jöoi Abranag jaauwai, i chaain ewagam khʉʉn eem ãb thaababarmuata maar peerdʉ auju atarr aawai, ĩs ewag nassi pawiata chadcha ich mag abarm.” Maga ajim aajem Mariaau Ẽwandamag jëeumamua i thö iekhatarr. ");
INSERT INTO noaE_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mag María ich naamhũan Elizabed oon mawia i di aig ed thãrjupjö sĩejim aajem. Mag sĩi awiata deeu ich diig petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mag María i aig sĩewia petarr khur ya ich auju ed aadeewai ũan Elizabedau chaai chi emkhooidam oojim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mag Ẽwandamau ʉ̈u i eeg oowia jõorpitarr chaai atham a ũrbaawai am dʉ̈i di dakha naajerr khʉʉnau chi Elizabed khodnaan dʉ̈imua am aig bëewia irig, “Ʉ̈uta Ẽwandamau pʉ chaai oopibarm; pʉ chaai gaaimua maarjã onee nʉmgui” aajeejim anʉm, jũrr bëe thʉnʉm khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Maimua mag autarr ocho días aadëm ee, deeu chi Elizabed aig i khapkhʉʉn dʉ̈i i khodnaanpa bëe thʉnʉisijierram aajem, chi chaai mehëudam phʉʉrbichpʉ̈i nʉm oon. Mag bëewi chadcha phʉʉrbichpʉ̈ijim aajem. Mamʉ chi chaai thʉ̈r chi dënnaanau agtha jaauba narr aawai bigaaum khʉʉnaun chi chaaidamjã ich aai gaaita Zacarías a thʉ̈rm ig naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamʉ magbaawai chi ãdau, —Ʉ̈ʉ̈, i thʉ̈r chan mag khabam. Mʉ chaairan Juan ata thʉ̈rjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Magbaawai amachdëu jũrr irig, —¿Khan jãgwia pua i mag thʉ̈rm ig ʉ? Pãar ee ãbjã mag thʉ̈r chukhu sĩebahab ajierram anʉm, mag gaai i thʉ̈raag. ");
INSERT INTO noaE_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Magbaawai jũrr chi ayag, —¿Pʉ chaai khan a thʉ̈r nʉ? a jëeujierram aajem. Mamʉ mag jöoi meu meraa khitʉmta kachpa khĩ thʉnarr aawai, jũrram khʉʉnau mag parhooba juau jajaaukhamua ichig jëeu nʉm khaug athaawai, ");
INSERT INTO noaE_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","jũrr ich garmua tabaldam jëeuwia, ag gaai “Iin Juan ata thʉ̈rju” a phãnaa, amag oopijim anaabá. Mag oopibaawai thum aig thʉnarr khʉʉnau amach ödegpai, “¿Khan ajaug gaaimuata ãba mag gaaita chaai thʉ̈rm ig nʉma?” ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mamʉ mag phãnaa irua oopibarm dʉ̈icha ĩchab ich jöoi Zacarías iek eerdʉ sĩsijim anaabá. Magbaawai Ẽwandamag jëeumamua magjim anʉm: —Ʉ̈uhcha jãg pʉchdëu jaautarrjöo abarm, Ẽwandam. Mʉ ũan chaai thaabaawaita pua mʉ iek eerdʉpiju atarr aawai ya chadcha deeu mʉ iek eerdʉ chirsim. Ĩsin chadau mʉch meukhudamaucha pʉrʉg ʉ̈u ajim a chirʉm Ẽwandam ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","Mag oobaawai thum aig narr khʉʉnau, “Jãan ich iiuta jãgpibarm” a khĩirju nʉisijierram anaabá. Maimua ërëu phöbaadëwia amach wënʉrrʉmpierr amachdëu oomatarr thum ich mag jajawag wëtmarr aawai Judea durr ee didam ããbdö khëkhëdʉm eem khʉʉnaupa khakhapdö ich mag sĩi bĩi jöisijim aajem. Mamʉ mag chi jaau wënʉrrʉm khʉʉn iek ũrmam khʉʉnau thumaa khĩirjuwia amach wir aigpai, “Mag chaaidam mʉg atag jöoipabaadeewai, ¿jãgata khitajuuta mag jaau nʉma, bʉ̈rʉʉ khitwe mag nʉm?” aajeejim anʉm. Mag, ich Ẽwandamau bʉ̈rʉʉwe ich khõchagpierr bãaupʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ich ag ed agtarr khur nʉʉpai awia jöoi Zacarías gaai Ẽwandam Akhaar phẽs aicheewai Ẽwandam i jaaujem khʉʉn dënjö iekhamamua María chaai igwia magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ẽwandam, ʉ̈uhcha pua pʉch chaain eeg oowia ĩsin chad maar peerdʉ awaagpam. Magua maar onee nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Warrgar pʉ chog David khakhitarr ag chaain ewagam khʉʉn eemta pua chi jua thierr maar athee pʉ̈ibapʉ̈im, maar peerdʉ aumkhĩir, ");
INSERT INTO noaE_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ich warrgarwe pʉch i jaaumienau õrag jaaujerrjö. ");
INSERT INTO noaE_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Amau jaauwai mag ‘Pʉchdëu pʉ̈ibarmuata maar peerdʉ auju’ aajeejim, ‘thum maach oomapha aajem khʉʉn jua eemua, maimua ĩchab chi dajãumie maach khũgurwia pekau ee burrpieg ẽkha sĩerraajem jua eemuajã agjö.’ Maagjerr ĩsta ʉ̈u ag ed pabaichëmgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","“Ẽwandam, pʉchdëu maar jöoin israelnaan dʉ̈i iek deetarr bʉ̈ʉrjã khĩir akhooba, ʉ̈u pua maar dau ee aug khaugbarm. ");
INSERT INTO noaE_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mag iek deetarr ed pua pʉch iiucha jöoi Abranag jaauwai, pua maar peerdʉ auju ajim, ");
INSERT INTO noaE_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","maach oomapham khʉʉn ögkhaba, ni dösãtjã ögkhaba, ");
INSERT INTO noaE_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ãba pʉch dʉ̈ipai ajapha wënʉrramkhĩir, tag bʉ̈ʉrjã pekau wau wënʉrram ugua.” ");
INSERT INTO noaE_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mag nacha Mariaau chaai ooju igwia iekha dichtarr khur jũrr ich chaai igmamuata jöoirau magjim anʉm: “Iewaadam, pʉʉta Cha Ʉ̈gthaa Phuu Nʉm ag i jaaumie a thʉ̈rju. Puata maach Pör maju ee i na õrag, ‘Maach peerdʉajem ya bëeimʉʉ sim’ a jaaumaju, ya mag jaaubarm ũrwia õrau i pierrwai amach thãraucha khõsi i iek ʉ̈khamkhĩir; ");
INSERT INTO noaE_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","maimua amag maach peerdʉajem iek jaaubaawai amach khaibag thumaa ãsie ewag khĩirjuwia Ẽwandamag chugpaapi jëeumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Magaag atheeta Ẽwandamau maach thumaam khʉʉn khĩir jãsenkhawia ich Chaai pʉ̈i sim, peerdʉju khaugba aawai pöd ʉ̈gthar öbërbaju aajerr khʉʉnpa peerdʉ aumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mag amach peerdʉju pierrum khaphʉ aadëmʉn, sĩi õor khĩchag ee nʉmjö nʉm khʉʉnau ãspa urum khaug athamjö warag ãspapiwia khʉd chaar ee paaukhabaadëmjö Ẽwandam dʉ̈i khõinaa wënʉrraju.” Ma ajim aajem jöoi Zacariaau ich iek eerdʉtarr ed iekhatarr. ");
INSERT INTO noaE_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Maimua chi Juandam bãaumam dʉ̈i Ẽwandamau ich Akhaarta i gaai phẽs deejim anaabá, ich dʉ̈i ubʉ nʉrrʉmua ich iek jaau khaug amkhĩir. Jöoipawia, ich ap õor chukag ee warp mawia sĩejeejim aajem. Maimua Ẽwandamau ich iek Israelpienag ũrpiju ed aadeewaita chi Juanau õrag jaaubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mag Juan thaaba nʉm jaar ya ĩchab Mariajã pömcha waaurba sĩejim aajem, Jesús gaai. Mag nʉm ee chi rey César Augustoou ich thethem khʉʉnag jaaujim aajem, jũrr makhʉʉnau ichdëu durr jʉ̈a sim ee õor nʉnʉidʉmpierr jaaubaa amach thʉ̈r phãkhapi mamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mag õor thʉ̈r phãkhatarr warrpem ajim aajem, Cirenio anʉm Siria durr gobernadorkha sim jaar. ");
INSERT INTO noaE_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mag iek aaidʉ nʉm jaar jaautarrjö, thumaam khʉʉn amach jöoin phöbörpierr wëtjierram anaabá, amach thʉ̈r phãkhamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Magua Josejã ĩchab ich jöoin phöbör ee majim aajem, ich thʉ̈r phãmkhĩir. Ich José Galilea durr joobaajeejim anʉm, phöbör Nazaret anʉm ee. Mamʉ jöoingarm rey David khakhitarr ag chaain ewagam khʉʉn dën arr aawai chi David thaabatarr phöbör Belén anʉmʉgta majim anaabá, Judea durr. ");
INSERT INTO noaE_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mag ich mam dʉ̈i María arrjim aajem, ag nawe iek deewia jua pʉrju anarr aawai. Maagwai María ya auwimʉʉ sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mag wëtwia, Belén bardʉtkhaimawia, khãai khapan khaba nʉm ee María chaai aujim aajem, warrpemdam. ");
INSERT INTO noaE_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mamʉ amach jẽraag di ajaphamjã baauba sĩi phak khãaijem degta narr aawai putdam ee pʉrëunaa phak thakhaar sẽejemdam uthur khërʉm eeta werba khërjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mag chaai thaababarm dakha phʉʉrsã sim ee õor naajim aajem, edaar amach oveja thʉa nʉm khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mag amach nemchaain thʉa nʉmta, dëgölp phʉr jẽer atham dʉ̈i arar jöi sim ee, Ẽwandam chog ich Jöoirau pʉ̈itarrta am khĩirphee barjopbaichëjim anaabá. Mag oobaawai jãphierr phöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Magbaa chi Ẽwandam chogau amag, —Oob jãphierrmiet. Mʉʉn sĩi pãrag iek ajapham jawaanta bëejimgui ajim anʉm. Mʉg murua pãrag iek jaaubarmua pãar israelnaan thum onee ajurau, pãachdëu ũrmampierr. Murua pãrag iek jawaan bëetarran mʉgaugui ajim anʉm: ");
INSERT INTO noaE_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ĩsta Belén phöbör ee chaai thaababarm, warrgarwe õor thumaam khʉʉnau nʉajerr Chaai. Mʉg chaairauta mʉg atag õor peerdʉ aujugui ajim anʉm. Ichta Cristoou maach Pör. ");
INSERT INTO noaE_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mʉch sëukha chirʉm am ugua, nauwe ërëubaadët ajim anʉm, Belén phöbörög. Mam barbaimaawai chi chaaidam putdam ee pʉrëunaa phak thakhaar sẽejem uthur khitʉm ee aukhërʉm pãrau ooimaju a jaaujim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chi Ẽwandam chogau mag jaaubarm ee, i khapeen ijöm khʉʉn khapan edjã ee pʉʉrthʉbaichëjim anaabá, sëukhabarmjö abarm ee. Magbaawai makhʉʉnau Ẽwandamag jëeu nʉmua, ");
INSERT INTO noaE_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ẽwandam, ʉ̈u abarm ʉ̈gtharm magwe. Ʉ̈u pua pʉch Iewaa pʉ̈ibarmgui” anaajim anʉm. “Mʉg pʉchdëu i pʉ̈ibarm gaaimua mʉg durr jöoi gaaijã pʉchdëu jʉr aumam khʉʉnan pʉ dʉ̈i khõinaa wënʉrraju” anaajim anaabá, Ẽwandamag jëeumamua. ");
INSERT INTO noaE_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mag thʉnʉʉ awia chi Ẽwandam chognaan deeu ʉ̈gthar ërëubaadeewai chi nemchaain thʉa narr khʉʉnau jũrr wir aigpai amach khapeenag, —Keena, magan Belenag wëttarrau ajim anʉm, Ẽwandam chogau jaauwai mag chaaidam eeu au khitʉm anʉm oon. ");
INSERT INTO noaE_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mag wëttarrau awia, chadcha eerpamjö ërëuwia ooimaawai, chadcha chi chaaidam ewaa au khitʉm phak thakhaar sẽejem ee aukhërʉm ooimajierram anaabá. Maig i bigaau chi ãd José dʉ̈i naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mag amach daúa oobaimaawai chi Ẽwandam chogau amachig jaautarr thum jũrr amag ĩgkhaimajierram anʉm. Mag jaauwia, öbërwia, deeu amach nemchaain aar wëtumuajã amachdëu õor oomampierr ich mag jajawag wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mag chi oveja thʉamienau nem ĩgkhakhag wëtum ũrwia thum chi ũrmarr khʉʉn jʉ̈gderraa nʉisijim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mamʉ mag amau jaau nʉm ũrtarr thum Mariaau khaphʉ sĩerrjã bʉ̈ʉrjã bĩi aba, ich thãar eepai ich mag khaphʉ wai sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mag chi nemchaain thʉamienau amach daúacha oonaa amach jʉ̈gʉucha ũrtarrpa ig wëtumua, onee Ẽwandam thö iekhakhag wëtumua, “Ẽwandam, ĩsin chadau purua ʉ̈u abarm. Pʉjö wajaugkham chan õor chukhum” a serereug wëtwia deeu amach nemchaain aar phʉʉrsã ee naaimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chi chaai autarr ocho días aadëm ee, jöoingarwe amach i arr aawai nacha i mehëudam phʉʉrbichpʉ̈iwia warre i thʉ̈rdam Jesús a thʉ̈rjierram aajem, chi Ẽwandam chogau warrcha Mariaag jaaucheewai thʉ̈rju a jaautarrjö. ");
INSERT INTO noaE_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maimua ĩchab magtarr khur ed ãbjö aadëm ee, Jerusalén phöbör ee Aai i jëeujem deg chi Jesudam aibëejierram aajem phadëg oopien, Moiseeu Ẽwandam iek phãtarr gaai jaau simjö ag ipierr. Mag aibëewia Ẽwandamag i kõit ʉ̈u ajim anaa warag irig jëeumamua, “Ẽwandam, cha khërʉm maar chaaidam; puata i khap chirʉm mʉg atagjã. I dʉ̈i pʉchdëu ampierr abá” ajierram anʉm, “pʉchigpai khĩirju bãaumkhĩir.” Mag amau jëeutarran amach chaai Ẽwandamag deeg ajim, warrgar Moiseeu jaautarrjö. ");
INSERT INTO noaE_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mag Moisés iek gaai Ẽwandamau mag sim: “Thum emkhöi chaai chi nacha oomamdam pãrau mʉrʉg deemaju.” ");
INSERT INTO noaE_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maimua ĩchab, “Jãbaukhitʉm wa dubur chaaindam khãijã dau numí deebat” a sim “ag chaai paar.” Maagjerr aawai chadcha duburdam khëchwia chi chaai Ẽwandamag dee nʉm anʉmua i kõit jëeujierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Maagwai Jerusalén phöbör ee woun ãb Simeón a thʉ̈r sim sĩejim aajem, Ẽwandam dau na ajapha khitanaa i ipierraa khitaajerr. Ich mag jöoirau ĩchab nʉajeejim aajem, warrgarwe Ẽwandamau jöoinag jaauwai irua ich Chaai pʉ̈ibarmuata israelnaan peerdʉ auju a jaaujerr Chaai. Mag jöoi gaai Ẽwandamau ich Akhaar phẽs wai sĩejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Magua ich mag Ẽwandam Akharau ichig jaautarr aawai jöoi Simeonau khaphʉ sĩejim aajem, ich daúacha ooju maach Pör Ẽwandamau mʉg jẽb gaai Cristota Reikhamkhĩir pʉ̈iju a jaaujerr. ");
INSERT INTO noaE_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Magtarr aawai mag chi Jesudam Aai i jëeujem deg wai nʉm edcha ich mag jöoi Simeón anʉmjã ĩchab ich Ẽwandam Akharau agʉg i arrjim aajem. Mag José María dʉ̈imua jöoingarwe Moiseeu iek phã pʉatarr gaai jaaujemjö chaai dʉ̈i aag Aai i jëeujem deg bardʉtkhabaimaawai, ");
INSERT INTO noaE_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ich mag jöoi Simeonau chi chaaidam jiir auwia Ẽwandam thö iekhamamua, ");
INSERT INTO noaE_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ẽwandam, mʉʉn pʉ chogau” ajim anʉm, “maagwai pʉ mʉ Pöröu; ");
INSERT INTO noaE_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ĩsin chad ya pʉch aar mʉ auju aai chirʉmgui” ajim anʉm, “pʉ aar khõinaa chiraimaag. Pʉchdëu nawe mʉrʉg oopiju a jaaujerr ya chadcha mʉch daúacha oobarmgui” ajim anʉm. “Mʉg chaairauta jöoipaawai õor peerdʉ auju. ");
INSERT INTO noaE_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Chadcha mʉg chaai õor thumaam khʉʉn atheeta pua pʉ̈ibarm. ");
INSERT INTO noaE_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mag, i gaaimuata durr chaauram khʉʉnaujã Israelpien thö iyʉ̈ʉ ajurau. Maimua i jöoipa sĩsiewai ĩchab Israelpien khabam khʉʉn atheejã õtdaujö sĩsiju, amachdëu jãga amjã peerdʉju aai nʉ a khap amkhĩir” a iekhamajim anʉm jöoyau. ");
INSERT INTO noaE_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mag chaaidam bʉ̈rʉʉ khitʉmta jöoipa khërsiewai, jãgata õor eejã sĩerraju khai a thumaa jaaubarm ũrbaawai, amach appai, “Maach chaai ¿jãgata khitajuuta, bʉ̈rʉʉ khitwe mag jaau nʉma?” ajierram anʉm chi dënnaanau. ");
INSERT INTO noaE_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Maimua Simeonau chi dënnaanagta jũrr, —Pãach numwe Ẽwandamau pãar mʉg atagjã ʉ̈u wai nʉisijugui ajim anʉm. Magnaa chi ãdagcha, María, Ẽwandamau mʉg ich Iewaa pʉ̈ibarm gaaimua, chadcha mʉg Israel durram khʉʉn pöm ʉ̈gthar öbërjugui ajim anʉm. Mamʉ ĩchab Israel durram khʉʉnaupai i oomapham iekhau amach jãrr i phʉʉr thuur auju. Pʉch chaai mag dau aphʉʉ wai nʉm oobaawai pʉchta thuthuíu thoopbapʉ̈imjö aphʉʉ i athee pʉ bĩe ʉrrajugui ajim anʉm, gaai machgau. Mag i aphʉʉ wai nʉm aigta merag chukhu ajugui ajim anʉm, chijã khʉʉnauta i khõsi aju maimua chijã khʉʉnauta i oomapha khãijã aju a jaaumajim aajem ich chi ãdagcha. ");
INSERT INTO noaE_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Maig ĩchab ũan Ana anʉmjã sĩejim aajem, agjö Ẽwandam i jaaumie. Mag Ana apkhʉ̈ʉ jöoi Fanuel khararr ag kha ajim aajem. Maagwai ich jöoi Fanuel anʉm warr jöoingar Asernaan a thʉ̈ʉrjerr khʉʉn eem ajim aajem. Mag ũan Ana warrpem ich jaai autarr dʉ̈i siete añospai nʉm ee khoopawia ich mag tag jaaijã auba khitʉmua ya ũanaa khitajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mag ũanaa ochenta y cuatro años khitʉmjã chawag maba, edaram magwe Aai i jëeujem degpaita sĩejeejim aajem, sʉrkha simua Ẽwandamag jëwaag. ");
INSERT INTO noaE_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mag agtha María ich chaai dʉ̈i Aai i jëeujem deg nʉm ee, mag ũan Ana anʉmjã bëewi Ẽwandamau ich Chaai pʉ̈itarr khaug athaawai irig, “Ʉ̈u ajim Ẽwandam; purua maar peerdʉ awaag pʉ̈iju aajerr chaai barbaicheewai mʉ onee ʉmgui” ajim anʉm. Magnaa mag ich Ẽwandamaucha pʉ̈iju a jaautarr ĩchab nʉajerr khʉʉnag chi chaaidam igwia, “Ich Ẽwandamau jaautarrjö chamʉguata mʉg atag maach peerdʉ auju ag Chaaidamauwai” aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Maimua Ẽwandamau ich iek Moiseeg phãpitarr gaai jaau sim ipierraa thum wau dichdimaawai deeu amach Nazaret phöbörög bëejierram aajem, Galilea durr. ");
INSERT INTO noaE_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mag chaai ich dʉ̈rrpapagmampierr warag khĩirjug khaphʉ pamajim anaabá. Mag nʉm dʉ̈i ich Ẽwandamau ich khõchagpierrta bãaupijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús dënnaan añopierr Jerusalenag weetjeejim aajem, nemkhoo pömaam jaar paawai. ");
INSERT INTO noaE_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mag añopierr weetjerr aawai, Jesús doce años aadeewai, ĩchab Jerusalenag majim aajem, ich dënnaan dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Maimua chi nemkhoo dichdimaawai õor pöm amach durrag ërërëukham ee, ĩchab José María dʉ̈i amach phöbörög wëtjim aajem. Mamʉ Jesús am dʉ̈i maba, thʉba sĩsijim anaabá. Mamʉ i thʉbabarmjã chi jöoinau khaugbajierram aajem, deeum khʉʉn dʉ̈i urumpii awia. ");
INSERT INTO noaE_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","45","Mag deeum khʉʉn dʉ̈i õor khapanag ee urumpii awiata ich mag khãaim ãb wënʉrra khëumamua i jʉʉrjeejim anʉm. Mamʉ amach khodnaanag jëeuwia amach khap khʉʉnagjã jëeukha ohookham ooba abaawai ag noram deeu ewag bëejierram anaabá, i jʉr wëdurumua. ");
INSERT INTO noaE_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ich ag ed kheeuraa Jerusalén barchëjierram aajem. Maimua ag noram ãspaau jʉrphöbaadeeuta Aai i jëeujem deg Ẽwandam iek jawaag chi machnaan dʉ̈ita Ẽwandam iek iigwai iyʉ̈ʉ oo sim ooimajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Maagwai aig thum chi ũr narr khʉʉn jʉ̈gderraa thʉnaajim aajem, chi machnaanau jëeumam chaairauta am dënjö nem khaug am iek ʉ̈khapʉ̈pʉ̈igmam ũrwia. ");
INSERT INTO noaE_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mag chi machnaan jãrr sim oobaicheewai, chi jöoinau amach wir aigpai, —¡Mʉgah! Pʉdë oobá, mʉigta sĩebma ajierram anʉm. Magbaawai chi ãdau magjim anʉm ich chaairag: —¿Khantheeta mʉgcha maar phithurg waupibarma? Pʉ jʉr wënʉrrʉmua marau pʉ khĩirju nʉʉ ajimwai ajim anʉm, ich chaairag. ");
INSERT INTO noaE_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Magbaawai chi chaairau amag magjim anʉm: —¿Pãrau khaugbata nʉ, mʉ mʉig mʉch Aai iek õor dʉ̈i ig iyʉ̈ʉ chiraju aai chirʉm? ");
INSERT INTO noaE_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mamʉ chi chaairau amachig mag iekhabarm chi jöoinau pöd khaugba, parhoobata ũrpʉ̈ijierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Maimua ich dënnaan dʉ̈i öbërwia ãba amach phöbör Nazareeg wëtjim aajem. Maimua ewag pawiajã ich dënnaan ipierraa ich mag khitajim anaabá. Mamʉ ich chaairau mamagkhamjã Mariaau ich thãar eepain thum khapphʉ aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mag nʉm ee warag Jesús dʉ̈rrpamampierr ĩchab khĩirjug khaug pamajim anaabá. Maagwaita Ẽwandam dau na agchanaa ĩchab õor eejã khajappha nʉrraajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Woun Tiberio anʉm reikhabaaderr aigmua quince años aadëm ee, gobernadornaan jayap naajim aajem: Judea durr: Poncio Pilato Galilea durr: Erodes Iturea durr Traconite durr dʉ̈i: Felipe (Erodes naam, aai gaaimua) Abilinia durr: Lisanias ");
INSERT INTO noaE_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Makhʉʉn chi gobernadornaankha nʉm jaar ĩchab phadnaan pörkha narr khʉʉn Anás ajim aajem Caifás dʉ̈i. Ich mag jaarta ĩchab Ẽwandamau jöoi Zacarías iewaa Juan õor chukag ee sĩerrag jaaujim aajem, ich iek õor ee jajawag mamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ẽwandamau ichig mag jaaubaawai chadcha petawia döjã Jordán igaau khĩeb jajawagmamua maagjeejim anʉm: “Pãar pekau pöoma naawai pãach khaibag ãsie ewag khĩirjuwia Ẽwandamag chugpaapi jëeubat. Mag jëeubaa Ẽwandamau pãach khaibag chugpaabapäaiwaita mua pãar pör choopʉ̈imajugui” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","I mag nʉrraju igwia warrgarwe Ẽwandam i jaaumie Isaías a thʉ̈ʉrjerrau mʉg phã pʉajim: “Woun ãb ajappai õor barba aajem aar sĩejemuata ich aar õor barbaimaawai, ‘Maach Pör ya bëeimʉʉ sim’ aju. ‘I bëeju nawe pãach thãar khĩir khaugbat’ aju, ‘thãraucha khõsi i iek ʉ̈khaag. ");
INSERT INTO noaE_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pari mag ʉ̈khaagan pãach khaibagau pãach thãar jãg sĩi durr dapag eem dö khõrgjö ãkhãrag sĩsidʉmjã jẽb dau dʉ̈ii paa nʉmjö ajaug paapʉ̈ipetat’ aju. ‘Pãach khĩirjug khʉd jũjũrkhimjö sĩsidʉmjã khʉd khajapha wʉʉinaa bubuchdög dau dʉ̈ii jiirthẽubapʉ̈imjö abat’ aju. ");
INSERT INTO noaE_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mag thum ajaug paapʉ̈iwia khĩir khaug nʉisiewain chadau Ẽwandamau maach peerdʉju pʉ̈ibarm thumaam khʉʉnau khĩircha ooju” a phã sim. Ich mag Juanau maach thãarta khʉd wʉʉi nʉmjö waupi jaau nʉrrarran, warrgarwejã irua mag jaau nʉrraju ya chi phãm arr aawaita nassi pawi chadcha mag jaau nʉrrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mag ũrwia irig amach pör choomkhĩir õor pöm bëe thʉnʉm khʉʉnag maagjeejim anʉm ichdëu: —Chi khaibagnaan, ¿khaíu pãrag jaauwai Ẽwandamau maach i agkham ed sĩi pör chootarr gaaimuapaita pãar i jua machag ãwatbaju a jaaujĩ? ");
INSERT INTO noaE_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sĩi pãach pör choopi nʉmuapai chan irua pãar aubam. Ẽwandam jua machgau dau aphʉʉ amapha nʉm khai, pãach khaibag thumaa ãsie ewag khĩirjuwia, Ẽwandamag isegpi jëeuwia, chadcha Ẽwandam iek ʉ̈khaajem khʉʉnjö abat ajim anʉm, pãach khapeen dʉ̈ijã. Oob pãrau chikhamnaan dënjö, pãachjã warrgar pãach jöoi Abrán khararrjö Ẽwandam dʉ̈i khapeerkha nʉm awi, “Maran Abrán chaainau; mag i chaainkha nʉmta, ¿jãga Ẽwandamau mag maar dau aphʉʉ apibarju?” a khĩirjumiet. Sĩi mag Abrán chaainkha nʉm gaaimuapaita mag ʉ̈gthar öbeerjem akhiin, mokdau mʉg thʉnʉmjã Ẽwandamau õrag paapʉ̈iwia makhʉʉnjã ĩchab Abrán chaainau aju aai sim. Abrán chaai chaar awiajã ichiita Ẽwandam jua machag ãwatab khaba ãwatju. Mag khõch khaba nʉm khai, pãach khaibagta warre Ẽwandamag isegpi jëeubat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pãrau khaphʉ naabá, nemjĩir khaigbamʉn thu wërpmaajem. Ich agjöta simgui ajim anʉm ĩchab Ẽwandamaujã pãar dʉ̈i. Ya irua pãar chachimʉʉ sim. Ar õor amach khaibag isegwia Ẽwandamag chugpaapi jëeuba nʉm khʉʉnan pa thupʉ̈iwia jʉser aadee örpʉ̈i nʉmjöta ajugui ajim anʉm, ich Ẽwandamau am dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mag jaaumam ũrwia, õrau irig —¿Magan maraujã jãga aju aai nʉ, Ẽwandam jua machag ãwatmaaugau? a jëeujierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Magbaa ichdëu magjim anʉm amag: —Khajũa theg jũaju paraa nʉm khʉʉnau bʉ̈ʉrjã jũaju chukhu khithëem khʉʉnag deepetat. Maagwai agjö nem khoojemdam wai nʉm khʉʉnau ĩchab chukhum khʉʉn dʉ̈i jig khöbat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Maig ĩchab bëejierram aajem gobierno dën dëbpaar jëeujem khʉʉn, agjö amach pör choopʉ̈imamkhĩir. Mag bëewia makhʉʉnaujã irig jëeumamua, —Maestro, maraujã ¿jãga aju aai nʉ? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Magbaawai ichdëu amag, —Oob leíu jaau sim khãyau athuucha õor jua eem phatkhon jëeumiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Maimua jũrr soldaaun bëewia, makhʉʉnaujã irig, —Magbaa maraujã ¿jãgajuma? aichëjierram anʉm. Magbaa ich Juanau magjim anʉm chi soldaaunag: —Oob tag chikham jua eem nem ajués khechthʉg aumiet. Wa pãachta emkhooin awia chikham khũgur jãphierrpinaa khãijã chikham phatkhondam au chithëe amiet. Maimua oob pãrau, “Mʉrʉgan bʉ̈rʉʉta phaagjem, muan waragta ig chirʉm” amiet ajim anʉm. Pãachig phag nʉmdam dʉ̈ipai onee nʉisit a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mamagkham ũrwia, õrau jũrr amach khapeenag, “Ĩsin ich mʉ khãijãa Ẽwandamau nawe pʉ̈iju a jaaujerrá agam” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Amau mag iekha nʉm Juanau ag nawe ũr wai sĩerr aawai thumaam khʉʉn jʉ̈g daar magjim anʉm: —Mua pöd pãar thãar ajaug paa aubam. Muan sĩi dödamaupaita pãar pör choo chirʉmgui ajim anʉm. Mamʉ ẽudee ãb urumta mʉ khãyaujã jua theeg ʉ̈rcha sim. Jãguan chad ich Akhaarjã pãrag deewia pãar khaibagjã õtdau ee warre örbapʉ̈imjöta aju. Mʉ chan mʉg chirʉm aig sĩi i chogkhaagpaijã serbiibata chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Magnaa amag, Khĩir khaphʉ abat, Ẽwandaman ya bëeimʉʉ simgui ajim anʉm. I bëem ed i iek ʉ̈kha nʉm khʉʉnan arrozdö pöm wëjorr phierrwia ajapha ãkha thʉnʉʉubarmjöta aju. Maagwai ar i iek ʉ̈khamapha arr khʉʉn, jũrr chi arroz bʉ̈ thʉʉtarrta sĩi ãbamʉg päardʉnaa örbapʉ̈imjö aju. Makhʉʉnan bʉ̈ʉrjã õtdau thõo khaugba sĩerrʉm eeta ich Ẽwandamaucha barkhʉʉipʉ̈iju a jaaujeejim anʉm, Juanau ich aig bëe nʉm khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mag jaautarr aigmuajã ich mag iek khĩir pogkhe jaau khitʉmua õor wawiejeejim anaabá, jãga thumaam khʉʉn Ẽwandamau peerdʉ auju aai sĩ. ");
INSERT INTO noaE_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Mag jaar chi gobernador Erodeeu ich naam Felipe ʉʉi Erodías anʉm khecheu auwia ag dʉ̈i sim khaug athaawai Juanau irig iekhajim aajem. Mamʉ mag irig iekhatarr chan mag sĩi ich wach ʉʉi dʉ̈i sim atheepaijã khaba, ich nem parhooba khaigba waaujem kõitpata irig iekhajim anaabá. Mamʉ magʉmjã bʉ̈ʉrjã i iek ũrba, warag chi Erodeeu Juan cárcel deg phãar sĩupijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mamʉ mag Erodeeu chi Juan cárcel deg phãarpiju nawejã õor pöm pör choojerr aawai, khãai ãb Jesujã bëewia Juanag ich pör choopibaawai, ĩchab i pör choopʉ̈ijim aajem. Mag ich pör choo aaipabaadeewai Ẽwandamag jëeujim anaabá. Mag ich Ayag jëeu sim eeta edaujã weeudʉ jöisim eemua ");
INSERT INTO noaE_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ẽwandam Akhaar duburjö khitʉmta dau daau bëewia i ʉ̈r jupchëjim anʉm. Mag jupbaichëm dʉ̈i edjã eemua woun iekjö, “Iewaa, pʉʉta mʉ Chaai mʉchdëu jãsehne wai chitʉmʉu, pʉ gaaimua mʉ onee chiraajem” abarmjã ũrjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesuu warrpem Ẽwandam iek õrag jaauwai treinta añosjö sĩejim aajem. Iin Ẽwandam Iewaa ajieb mamʉ, õraun José iewaa chaarpii aajeejim. Ich Jesús bãaurrjöoi Joseeta Elí iewaa ajim aajem. Maagwai Elí Matat iewaa ajim; ");
INSERT INTO noaE_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat Leví iewaa; Leví Melqui iewaa; Melqui Jana iewaa; Jana José iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías iewaa; Matatías Amós iewaa; Amós Nahúm iewaa; Nahúm Esli iewaa; Esli Nagai iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat iewaa; Maat Matatías iewaa; Matatías Semei iewaa; Semei Josec iewaa; Josec Judá iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanán iewaa; Joanán Resa iewaa; Resa Zorobabel iewaa; Zorobabel Salatiel iewaa; Salatiel Neri iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui iewaa; Melqui Adi iewaa; Adi Cosam iewaa; Cosam Elmadam iewaa; Elmadam Er iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Jesús iewaa; Jesús Eliezer iewaa; Eliezer Jorim iewaa; Jorim Matat iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví iewaa; Leví Simeón iewaa; Simeón Judá iewaa; Judá José iewaa; José Jonam iewaa; Jonam Eliaquim iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea iewaa; Melea Mena iewaa; Mena Matata iewaa; Matata Natán iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David iewaa; David Isaí iewaa; Isaí Obed iewaa; Obed Booz iewaa; Booz Sala iewaa; Sala Naasón iewaa; Naasón Aminadab iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab Admin iewaa; Admin Arni iewaa; Arni Esrom iewaa; Esrom Fares iewaa; Fares Judá iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacob iewaa; Jacob Isá iewaa; Isá Abrán iewaa; Abrán Taré iewaa; Taré Nacor iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug iewaa; Serug Ragau iewaa; Ragau Peleg iewaa; Peleg Eber iewaa; Eber Sala iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán iewaa; Cainán Arfaxad iewaa; Arfaxad Sem iewaa; Sem Noé iewaa; Noé Lamec iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalén iewaa; Matusalén Enoc iewaa; Enoc Jared iewaa; Jared Mahalaleel iewaa; Mahalaleel Cainán iewaa; ");
INSERT INTO noaE_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enós iewaa; Enós Set iewaa; Set Adán iewaa; Adán Ẽwandam iewaa, ich Ẽwandamaucha i omparr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mag pör choowia Jesús Ẽwandam Akhaar ich gaai phẽs wai sim petajim aajem Jordán eemua, mag ich pör chootarr aigmua. Mag mamta ich ag Ẽwandam Akharaupai Jordán igaau durr õor chukag chʉʉi i warrjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mam cuarenta días sĩejim aajem, bʉ̈ʉrjã thach khöba. I mag sim ee dösãtau bëewia i khĩirjug meerkha Jöoi dau na ʉ̈u khabam nem waupiju ẽkhaajeejim anaabá. Mag cuarenta días dichdimaawaita eeupemjö Jesús jãsöo aadëjim aajem. Mag i jãsöo aadëm ee, dösãtau i khũgur auju khĩirjuwia ");
INSERT INTO noaE_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","irig, —Chadcha pʉ Ẽwandam Iewaa khai, mʉg mokdau panag paabapʉ̈i ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Magbaawai Jesuu magjim anʉm: —Ẽwandam iek phã sim gaai jaauwai, “Sĩi thach khöju appai khap amkhĩir irua maach ompaabajim” a sim. “Irua maach ompaatarran, mag thach appai khĩirjuju khãyau ich ipierraa wënʉrramkhĩirta maach ompaajim” a phã simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Maimua Ẽwandamau ʉdʉraa warag dösãtag Jesús warrpijim aajem, durrsĩ pöm sim gaai. Mag warrwia mag durr pöm ʉ̈gthaa sim gaaimuapai, sëukhabarmjö abarm ee, mʉg jẽb gayam durr warpham magwe thum irig oopijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mag oopiwia magjim anʉm, chi dösãt garmua irig: —Mua pʉrʉgta durr mʉg wëjöm dʉ̈i ag gaai nem thʉnʉmpa thum deejugui ajim anʉm, pʉchta thumaam khʉʉn pörkhanaa thʉ̈rphöo chirsimkhĩir. Mua mʉchdëu deem khõsim khʉʉnag deeju aai chirʉmgui ajim anʉm, mʉch dën aawai. ");
INSERT INTO noaE_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mamʉ magaagan sĩi jĩepöröu phõbkhanaa mʉrʉgta Ẽwandamagamjö jëeubá ajim anaabá. Pua mʉrʉg mag jëeumʉn, mʉg durr thumwe pʉch dënëu ajim anʉm chi dösãtau. ");
INSERT INTO noaE_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Magbaawai Jesuu chi dösãtag, —Ẽwandam iek phã sim gaai jaauwai, “Pãar Pörön Ẽwandamau; ãba irigpaita jëeubat, maimua ãba i iekpaita ipierraa abat” a simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Maimua Ẽwandamau deeu ʉdʉraa dösãtag Jesús warrpijim aajem, jũrr Jerusalén phöbörög. Mam barwia Aai i jëeujem di nem pöm dʉnʉm ʉ̈r chi sĩ gaai warrwia magjim anʉm chi dösãt garmua Jesuug: —Pʉ chadcha Ẽwandam Iewaa khai, magan mʉg ee baubaad ajim anʉm. Pʉ chig aba khabahab. ");
INSERT INTO noaE_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ẽwandam iek phã sim gaai “Ich Ẽwandamau ich chognaan pʉ̈iju” a sĩebahab, “pʉ thʉa wënʉrramkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Maagwai mʉg ee pʉ baudʉkhiinjã, amau sĩi amach jua eeta pʉ jãau aubajup, buju aimaau pʉ chig am ugua. ¡Baubaad! ajim anʉm, chi meperau Jesuug. ");
INSERT INTO noaE_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Magbaawaita Jesuu magjim anʉm: —Mamʉ ĩchab Ẽwandam iek phã sim gaai jaauwai, “Ẽwandamau chadcha pãach thʉaju awi oob nem parhoob amiet” a sĩebahab ajim anʉm, chi meperag. ");
INSERT INTO noaE_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ich mag warag chi dösãtau Jesuug ich ipierraa amkhĩir nem khĩirpierr jajaaukham bʉ̈ʉrjã pödba abaawai, sëukha chi khũgur petajim aajem ichta. ");
INSERT INTO noaE_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Jesús agtha Ẽwandam Akhaar ich gaai phẽs wai sim majim aajem deeu Galilea durr, ich berrag. Mag barwia judionaan Ẽwandam iek jaaujem di sĩsidʉmpierr jaaujeejim aajem. Maagwai durr chaauram khʉʉnaupa irua jaau nʉrrʉm khakhapdö aphöbaadeewai thumaam khʉʉnau i igar nʉmua, “Ʉ̈uta mag jaau nʉrrabahab” aajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Maimua Nazareeg bëejim aajem, ich bãautarr phöbörög. Mag bëewia jua ʉ̈ʉijem ed pabaadeewai judionaan Ẽwandam iek jaaujem deg dubjim aajem, ag na ich duubjerrjö. Mag dubwia, õrag ũrmkhĩir Ẽwandam iek thʉ̈raag phiidʉ dʉnʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mag i dʉnʉisiewai ãbmua irig ʉapʉ̈ijim aajem, jöoingarm ẽsap chi pʉʉrthʉm, Ẽwandam i jaaumie Isaías khararrau phãtarr. Maimua chi ẽsap pʉʉrthʉm gaai jʉrnaa thʉ̈rbaadëjim anʉm. Irua thʉ̈r sĩerr aig mag sĩejim aajem: ");
INSERT INTO noaE_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ẽwandamauta mʉ jʉr autarr aawai ich Akhaar mʉ gaai phẽs wai sim, aphʉʉm khʉʉnag jãga ichdëu am peerdʉ auju a jaaumkhĩir. Irua mʉ pʉ̈itarran, õor amach khaibag ee presonaanjö nʉm khʉʉnag, ‘Ya pãar öbërm iek öbërju aai nʉm’ a jaaumkhĩir ajim; dau khĩsumjö nʉm khʉʉnagjã, ‘Ya pãrau wajapha ooju aai nʉm’ a jaaumkhĩir; chikhamnau dau aphʉʉ waaujem khʉʉn dau aug khaugwia peerdʉ aumkhĩir; ");
INSERT INTO noaE_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","maimua õrag, ‘Ĩs chad mʉg jaarta Ẽwandamau pãar dʉ̈i nem ajapcha aju ed barbaichëm’ a jaaumkhĩirta mʉ pʉ̈ijim” ajim anʉm, thʉ̈rmamua. ");
INSERT INTO noaE_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Maimua thʉ̈r aaipabaadeewai ichig chi ẽsap pʉʉrthʉm deetarrag deeu ʉapʉ̈iwia oo sĩsijim aajem, ichdëu thʉ̈r sĩerr iekpai jawaag. Magbaawai thum aig narr khʉʉnau ãba irigta eerpapaad thʉnʉisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mag ichig eerpapaad aphöbaadeewai amag magjim anʉm: —Ĩsta chadcha pãach thumaam khʉʉn dakhĩir mʉg Ẽwandam iek phã sim gaai ichdëu jaautarrjöo abarmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mag ũrwia thumaam khʉʉnau i wajapha ig iyʉ̈ʉ naajim anʉm. Mag nʉm dʉ̈i irua iekdam ũrimʉ iekhamam ũrwia thum jʉ̈gderraa aphöbaadëjim anaabá. Mag ũrwia, jũrr amach wir aigpai, —Keena, ¿mʉg woun José iewaa khabamá? ¿Khani mag iekha oo simma? anaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Magbaawai Jesuu magjim anʉm: —Pãrau mʉchig “Chadcha médico khai, pʉchdëupai pʉch monaaubapʉ̈i” a iekhaju mua khaphʉ chirʉmgui ajim anʉm. Magnaa amag, Pãrau ũurwai Capernaum durr mua nem khĩir pogkhe waaujem anaawai, mʉigjã magan agjö waupi jaaujugui ajim anʉm, mʉ iek ʉ̈khamapham iekhau. ");
INSERT INTO noaE_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mamʉ keena, pãadë oobat, muajã mag chirʉmgui ajim anʉm: Chi mʉg Ẽwandam iek jaau wënʉrraajem khʉʉn chan dich dö ee ãba naajem khʉʉnau ãbjã kha khõchkhaba aajemwai. ");
INSERT INTO noaE_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mʉch sëukha chirʉm am ugua pãrag jaaukhim: Pãrau khĩir eyaa nʉmgui ajim anʉm, jöoingar Ẽwandam iek jaaumie Elías khararr monakha aawai Israel durr año thãrjup awia jãrr bʉ̈ʉrjã noseg chëba arr anʉm. Mag gaaimua Judea durr thum jãdau theega burrtarr anʉmjã pãrau ũurjem. ¿Pãrau khĩirjuawai mag jaar ĩchab khoopaa ũanaan dau aphʉʉm chukhu ajĩ Israel durr? Chukhu ajim aju aai khaba nʉm; khapan thʉnaajim. ");
INSERT INTO noaE_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mamʉ magʉmjã ni iwiir ãbam aarjã Ẽwandamau Elías pʉ̈ibajim. Mamag pʉ̈iju khãyau Sidón durr phöbör Sarepta anʉm ee khoopaa ʉʉi ãb sĩerr aarta Ẽwandamau pʉ̈ijimgui ajim anʉm, magʉgta i jãogamkhĩir. ¿Jãgwi? Ich durram khʉʉn eepai pʉ̈imuan i khõchkhabaju khaphʉ arr aawaima. Maguata warag deeum durragta pʉ̈ijimgui ajim anʉm, ich meeun khabam ee. ");
INSERT INTO noaE_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ĩchab khĩir eyaa abat: Israel durr Ẽwandam iek jaaumie Eliseo khararr monakha aawai ĩchab õor kokobé bënëu bar sĩsidʉm khapaana thʉnaajim. Mamʉ mag thʉnarr khʉʉn iwiir ãbjã Ẽwandamau irig monaaupi jaauba, ãba Siria durr woun Naamán aajerr appaita monaaupijim. ¿Jãgwi? Ẽwandamau oowai amach israelnaan eepai pʉ̈imuan, amach eempai aawai bʉ̈ʉrjã amach khamor machag monaauju khĩirjubaju ich Ẽwandamau khaphʉ sĩerr aawaima ajim anʉm ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesuu mag iekhabarm ũrbaawai aig narr khʉʉn thum i dʉ̈i meeukha phöbaadëjim anaabá, amach khĩir iekhabapäaiwai. ");
INSERT INTO noaE_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mag meeukha nʉmua warag phiidʉtkha phöbaadëwia, phöbör eemua jʉrpʉ̈iwia, ich ag phöbör eepai durrsĩ gaai durr pör waaidʉ i warrjierram aajem, mammua ithurmʉg ee i sĩepäaig. ");
INSERT INTO noaE_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mamʉ mag nʉm ee sĩi am jãrr dichwia petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Maimua magtarr khur deeu Jesús Galilea durr phöbör Capernaum anʉmʉg bëejim aajem. Mag bëewia õor jua ʉ̈ʉijem ed pabaadeewai õrag jaaujeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mag irua jaau sim aig i iek ũrwia õor jʉ̈gderraa thʉnaajim anʉm, chi khaphʉm khaphʉm aajem khʉʉn khãyaujã ichdëuta jaau khaphʉcha jaaumam ũrwia. ");
INSERT INTO noaE_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mag judionaan Ẽwandam iek jaaujem deg ĩchab sĩejim aajem, woun ãb mor ee bën khaigbam wai sim. Mag wounau Jesús oobaadeewai chi bën i mor ee simuata thet äa anaa, ");
INSERT INTO noaE_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Jesús, Nazaretpierr! Idëu maar sĩi khajapha sĩubá ajim anʉm. Pʉʉn warre maar öpäainta urum. Mua pʉ khaphʉ chirʉm, pʉ jammua urú. Pʉ Ẽwandam Iewaa ʉ̈gtharmua bëetarr khabahab, warrgurwe Ẽwandamau pʉ̈iju jaaujerr ajim anaabá, chi mepeer garmua. ");
INSERT INTO noaE_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Magbaawai Jesuu chi bënëg meeurraunaa, —Khĩu abá. Pʉchta warag jãg woun mor eemua öbërbaad ajim anʉm. Magbaawai chadcha chi mepeer öbërbaadëmua warre chi wounta jẽkhʉt barwerbpʉ̈ijim anaabá. Mamʉ magtarrjã chig aba, deeu khĩir eerdʉwia, warramjö monakha sĩsijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mag oowia thumaam khʉʉn dauderraa nʉmua amach eepai, “¿Khanim wounaan juapa theegta jãg mepeenag öbeerpi jaauwaijã i ipierraa öbër nʉma? Keena, mʉig ag na maadëu mʉg chan ooba aajemwai” a iekhaphöo thʉnaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesuu magtarr sĩi ag bigaau phöbördam nʉnʉidʉm eem magwe bĩi thʉnʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Maimua mag woun mor eem mepeer jʉr pʉawia Ẽwandam iek jaaujem degmua öbërwia petajim aajem, Simón di aar. Maimua barimawia ooimaawai, Simón phaauhũanta khʉʉumieu mas thʉnʉm ooimajim anaabá. Magbaawai mag ũan monaaupʉ̈imkhĩir, õrau Jesuug chaigpa naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Magbaawai i werba jẽer sim bigaau dʉnʉʉuwimawia chi khʉʉumieg khĩesir iekhabaawai warre chi khʉʉumie meeudʉbaadëjim anaabá. Mag khʉʉumie meeudʉbaadeewai ag bʉ̈rre phiidʉwia am jãogaagpajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Maimua edau khëubaadeewai aaunaan paraa arr khʉʉnau amach aaunaan khamor machagpierr Jesús aig aubëemajierram aajem. Magbaawai Jesuu chi mor masim khʉʉn gaai pʉr oomamuapai thum monaaupʉ̈imajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mag pʉr oomamua õor mor ee bën paraa arrpa jẽu wërpmajim anaabá. Chi mepeenaujã Ẽwandamau i pʉ̈itarr khaphʉ narr aawai, “Pʉʉn Ẽwandam Iewaau” a ääag öbërdʉtkha maajeejim anʉm. Mamʉ Jesuu tag amag iekhapiba meeurrau sĩumajim aajem, õrag ich jaaum ugua. ");
INSERT INTO noaE_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Maimua ya ãspabaadeewai aigmua chawag mawia õor chukag aar ich appai sĩeimajim anʉm. Mamʉ Capernaumpienau i jʉr wënʉrrʉʉ awia baau athaimaawai tag i chawag pʉ̈imapha sĩi amach aigpaita sĩepim khõsi naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mamʉ ichdëu amag, —Mʉigpai chiraba mʉ chawag maju aai chirʉmgui ajim anʉm, ĩchab deeum phöbör eejã õrag “Ẽwandamta ya thumaam khʉʉn Pörkhaimʉʉ sim” a jaauwia, ĩchab am peerdʉju khĩirju nʉm khai, irigta ʉdʉraa amach Pörkhapiju aai nʉm a jawaan, mag atheeta Ẽwandamau mʉ pʉ̈itarr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mag jaauwia, Capernaumpai sĩeba, ich mag phöbörpierr judionaan biirdʉajem deg Ẽwandam iek jaau nʉrraajeejim aajem, Galilea durr. ");
INSERT INTO noaE_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Biek ãb Jesús thʉrrdö Genesaret anʉm igaau sim aig õor pöoma podpachëwia thet phẽeudʉ i phʉʉr thuur warrmajierram aajem, Ẽwandam iek ũrm khõchgau. ");
INSERT INTO noaE_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mag nʉm ee ichdëu bote numí mos gaai barhʉidʉ nʉm oo athajim anʉm. Ag ee chi morkhʉʉn chukhu naajim anʉm, dö ʉrëuthurwia dö igaau amach red ʉ narr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Magbaawai chi bote dau ãb Simón dën arr aawai irig jëeuwia, ag ee waaidʉwia, ichigpai bʉchkhun döjãrragaa ich warrpijim aajem. Magnaan chadau jupwia mammua õor khapan thʉnʉmʉg Ẽwandam iek jaaubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Maimua mag iekha öbaadeewai chi Simonag, —Döjãrr wëbapʉ̈i, maimua chi red dubpʉ̈inaa deeu ʉrëu oobat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Magbaawai Simonau jũrr magjim anʉm: —Aay, edaar maach daúa bʉ̈ʉrjã khãiba parii ʉrëu ëedʉtkhamaamjã bʉ̈ʉrjã marau pʉr aubajim. Mamʉ pʉ iek aawai deeu mua chach oojukë ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Maimua chadcha mag dubpʉ̈iwia jiir oowai ãwarr pöoma thʉnʉmua chi red dau thʉrrdʉmaa ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Magbaawai amach khapeen deeum bote ee narr khʉʉnag jua thõthõi khaphöbaadëjim anʉm, amach juag oon bëemkhĩir. Mag chadcha warm khʉʉn bëewia jiir athaawai bote numwe ipiir aujierram anaabá. Mag, bote numí narr ãba peer joothũpjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Mag Jesús ipierraa arr gaaimuapai ãwarr pöm pʉr atham oobaawai Pedro dʉ̈i jap ãbam ee narr khʉʉnaupa, “¿Mʉʉn khanim wounta ag na mʉg ooba aajemta ãwarr pöm mʉg pʉr aupibarma?” a khĩirju nʉisijim anʉm. Ich mag bʉ̈rre Simón Pedroou Jesús bʉ̈khʉrr phõbkha thʉnaaimawia irig, —Señor, oob mʉ dʉ̈i ãba nʉrram. Mʉʉn atcha pekau pöoma chirʉm pʉ mʉ dʉ̈i nʉrraag ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Maagwai Pedro khapeen ãbakhai bote ee narr khʉʉnaujã ĩchab amach khapeenau khĩirju narrjö khĩirju nʉisijim anaabá. Mag bote ee naajim aajem Zebedeo chaain, Santiago Juan dʉ̈i. Mamʉ Jesuu chi Simonag, —Simón, oob khĩirjum ajim anʉm. Warr pʉch sĩi dö ʉa gaaipai chitarrjö, ĩsmua atagan pʉʉn jũrr mʉ iekta õrag jaau gaaipaita chirsijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Maimua dö igaau paaukhachëwia warag i dʉ̈i mam iek ërëubaadëjim anaabá, amach nem thum pʉawia. ");
INSERT INTO noaE_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Maimua biek ãb Jesús deeum phöbör ee sim aig woun ãb kokobé bënëu sĩi phĩe kha dodos sim barchëjim aajem. Mag wounau oo athaawai jẽkhʉt phõbkhanaa, jẽb gaai dagau dʉrnaa, chaigpamamua irig, —Señor, pua khõs chirʉm khai, mʉg phĩedau warre mʉ gaaimua chugpaabapʉ̈i aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Magbaawai Jesuu i gaai pʉrnaa, —Mua pʉ monaaum khõsi chirʉm; monaau chirsí magan ajim anʉm. Magbarm bʉ̈rre chi phĩe kha dodos chirarr monaau sĩsiewai mor ajappha sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mag ya monaau sĩsiewai, Jesuu irig magjim anʉm: —Pʉch mʉgbarm oob chikhamnag jawam. Magju khãyau nacha Jerusalén mawia Aai i jëeujem degam phadëg pʉch mor oopibaimá. Maimua Moiseeu iek phãtarr gaai jaau simjö pʉch monaaubarm paar nemchaain ofrendakha deebá ajim anʉm, pʉch mʉg monaau sĩsim õrag khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ich Jesús mag gaaimua sĩi warag õor ee thʉ̈rphöo sĩsijim anaabá. Maagwaita warag õor pöm biirdʉdʉ aajeejim anʉm i iek ũraag, maimua ĩchab amach monaaupʉ̈i mamkhĩirjã agjö. ");
INSERT INTO noaE_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mamʉ magʉm ãba, Jesús chawag maajeejim aajem, ich appai õor chukag chʉʉi Ẽwandamag jëwaag. ");
INSERT INTO noaE_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Biek ãb Jesuu Ẽwandam iek jaau sim aig fariseonaan dʉ̈i Ẽwandam iek athee chi machnaanpa ohood thʉnaajim. Makhʉʉn phöbördam nʉnʉidʉmpierrmua bëetarr khʉʉn ajim aajem: Galilea durrmua bëetarr khʉʉn, Judea durrmua bëetarr khʉʉn, maimua ĩchab Jerusalenpienpa dʉ̈i naajim aajem. Maagwai Ẽwandam juapa theeg i gaai sĩejim anʉm, õor monawaag. ");
INSERT INTO noaE_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mag nʉmta õrau woun ãb khapá jʉser khitʉmta pa bʉʉrkham gaai waiduraa ajierram aajem, Jesús sim aar wai dubwia i khĩirphee werba sĩwaag, monaaupʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mamʉ dubju ẽkha nʉm õor pöm thʉnʉm khurau pöd dubba abaawai, dihëu ʉ̈r waaidʉtkha phöbaadëwia, nem wäg waunaa, chi pa bʉʉrkham gaai jʉ̈gadau jʉ̈khanaa, chi aaunaanpa eeg jiir burrpʉ̈ijierram aajem, õor jãrr Jesús iekha oo sim khĩirpheecha. ");
INSERT INTO noaE_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mag ich aig wai burrbaichëm oobaawai, irua chi wounaan ö akhaar ãba iruata amach aaunaan monaaupʉ̈iju khĩirju nʉm khaphʉ sĩerr aawai, chi khapá jʉser khitʉmʉgta, —Pʉ pekau thum ya chugpaa sĩsimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mag ũrwia fariseonaan dʉ̈i Ẽwandam iek athee chi machnaanpa aig narr khʉʉnau amach ödegpai, “¿Chijãg wounta Ẽwandam na mag iekha sĩma? ¿Khaíu mʉig pekau chugpaaju aai sĩ? Ẽwandamau khabam chan pekau chugpaa auba aajem” anaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mamʉ Jesuu amau mag khĩirju nʉm khaphʉ sĩerr aawai amag magjim anʉm: —¿Khantheeta pãar jãg thãar khaigba khĩirju sĩsid aajẽma? ");
INSERT INTO noaE_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Wa mag pekau chugpaabarmjã dau daau ooba naawai pãrau khĩirjuawai chadcha phithurg chukhu thumaam khʉʉnau mag iekhaju aai nʉm a nʉwa? Chadcha thumaam khʉʉnau mag iekhaju aaima. Mamʉ mua irig “Phiidʉwi dʉrdʉr abá” akhiin, õrau amach daúacha ooju, i monaau sĩsi wa monaauba khãijã ich mag sĩsim. Magua pãrau mʉ dënjö chan cha mua jawaagpamjö abajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mamʉ mʉch chi Emkhooi Iewaata chadcha Ẽwandamau juapá deetarrau mʉg jẽb gaai pekau chugpaagjã jua theeg chirʉm a khap amkhĩir, pãrag oopikhimgui ajim anʉm. Maimua chadcha chi khapá jʉser khitʉmʉgta, —Phiidʉbá. Pʉch put juurwia, pʉch diig petá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Magbarm bʉ̈rre thumaam khʉʉn dakhĩir phiidʉbaadëwia, ich waibëetarr pa bʉʉrkham dʉ̈i putpa phë auwia, ich diig petajim anaabá. Mag mamua, “Ĩsin chadau Ẽwandam purua mʉ ʉ̈u abarm” a ijẽjẽbag majim anʉm, onegau. ");
INSERT INTO noaE_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mag chi woun phiidʉbaadëm oowia aig narr khʉʉn thum dauderraa nʉm iekhau, “Jãan ich iiuta jãgbarm” anaa ĩchab, “Ĩs Ẽwandamauta maadëu mʉg ooju khĩirjuba narrjã oopibarm” anaajim aajem, amach ap pawiajã. ");
INSERT INTO noaE_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Maigmua öbërwia igbaadeeu ooimajim aajem, woun ãb Leví a thʉ̈r sim. Mag woun õrau dëbpaar phagaan bëejem aig mes gaai päar sĩejim aajem, gobiernoog õrau dëbpaar paraa nʉm jëeu nʉm phidagta phidkha sĩerr aawai. Magʉgjã Jesuu, —Mʉ dʉ̈i marrau ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Magbaawai chadcha Leviiu phiidʉwia ich phidagjã khaugba, i dʉ̈i petajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Maimua ich di aar barwia phiejãb pöm waupijim anʉm, Jesús khöpieg. Mag nʉm dʉ̈i ĩchab ich khapeen thʉ̈rkhʉʉijim aajem, ich aig thach khoon bëemkhĩir. Magbaawai dëbpaar jëeujem khʉʉn khapan wëdurum dʉ̈i parhoobam khʉʉnpa bëewia ãba thach khö naajim aajem, Jesús dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mamʉ magbaawai chi ajapcha Moiseeu Ẽwandam iek phã pʉatarr ʉʉrkhaajem khʉʉnau Ẽwandam iek athee chi machnaan dʉ̈imua Jesús khapeenagta, —¿Khan jãgwiata pãar jãg gobierno dëbpaar jëeujem khʉʉn dʉ̈i pekau pöm sĩsidʉm khʉʉnpa ãba thach khö nʉma? a jëeujierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Magbaawai Jesuu magjim anʉm amag: —Kha monakha nʉm khʉʉnau chan doctor igba aajem; ãba mor masi nʉm khʉʉnauta doctor iigjem. ");
INSERT INTO noaE_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mʉ chan bʉ̈ʉrjã pekau chukhu ajappha khithëem aajem khʉʉn jʉraanjã bëeba, mʉʉn õor pekau pöoma khithëem khʉʉn peerdʉ awaanta bëejimgui ajim anʉm, khĩirjug iiur aumkhĩir. Maguata mag am pekau pöm nʉmjã igba, am dʉ̈i mʉ thach khö chirabahab ajim anʉm, amjã Ẽwandam dënkha awaag. ");
INSERT INTO noaE_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Maigmua Jesús ich khapeen dʉ̈i öbër phöbaadëm ee, õor bëewia Jesuug magchëjierram anʉm: —¿Khan jãgwia Juan dʉ̈i wënʉrraajem khʉʉnau thach khö nʉmjã ʉ̈iba sʉrkhanaata Ẽwandamag jëeujem daar, pʉ khapeenau sʉrkhaba aajẽ? Chi ajapcha Moiseeu Ẽwandam iek phã pʉatarr ʉʉrkhaajem khʉʉn igar nʉm khʉʉnaujã agjö sʉrkhaajem, mamʉ pʉ khapeenau chan ajap magba aajerram. ¿Jã khan jãgwiauma? a jëeujierram aajem irig. ");
INSERT INTO noaE_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Magbaawai ichdëu amag magjim anʉm: —¿Pãrau oowai chi jua pʉr sim woun onee ich ʉʉi dʉ̈i thach khö nʉmich, irua õor thʉ̈rtarr khʉʉn sʉrkha nʉm awia sĩi ökhĩirjuu ohoodö naajẽ bʉ̈ʉrjã thach khöba? ");
INSERT INTO noaE_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Magba aajem. Ich agjöta nʉmgui ajim anʉm mʉ khapeenjã. Am magjuun mʉ am jaaijö am dʉ̈i chitʉm pʉr atham ed gayan chadau am amach khĩrauta sʉrkhawia, ĩchab thachjã khöba nʉisip aju, gaai machgau. Mamʉ mʉʉgwaiwe chan am sʉrkhaju khaba nʉmgui ajim anʉm, agtha mʉ am dʉ̈i chiraawai. ");
INSERT INTO noaE_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Maimua ichdëupai magjim aajem: —Pãach khajũa jẽbaadeewai, ¿pãrau oowai khaíu dich khajũa iiur gaaim jẽnaa jũrr chi jöoi gaai khaajẽ? Maadëu magkhiin dich khajũa ajaphamta ãrpʉ̈iju. Maimua mag phẽebarmjã khĩir ãba khaba daau phẽe wëjöm thumaam khʉʉnau ooju. Ich agjöta sim ĩchab mʉg iek iiur mua jaau chirʉmjã. Chi mʉ iek ʉ̈kha simua chan mʉg iek iiur mua jaau chitʉmjã ʉ̈khanaa pöd amach jöoin ijã agjö ʉʉrkhaju khaba simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mʉg mʉ iek ʉ̈kha nʉmʉn maadëu vino nemhëu iiur ee pʉajemjöta sim. Pãrau khaphʉ nʉmgui ajim anʉm, vino õrr nemhëu jöoi ya chi pʉajem ee pöd pʉju khaba sim. Mag pʉkhiin chi vino õrr achpabaadeewai, chi nemhëu jöoiraa sĩewai ãwatba jẽgdʉbaadee, chi vinojã ãrbaadëm dʉ̈i chi nemhëujã ya tag serbiiba sĩsiju. ");
INSERT INTO noaE_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Maguata vino õrran agjö nemhëu iiur eeta pʉajem; maagwai chi nemhëujã jẽgdʉba, chi vinojã ãrbamgui ajim anʉm ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mag iekhakhagmamua, Pãrau khaphʉ nʉmgui ajim anʉm, chi vino ach doo khaug nʉm khʉʉnag am döphö thʉnʉm aig chi õrr deeimakhiin, amau “Ʉ̈ʉ̈, maraun chi achta ig nʉm, jãata marag ajapcha sim” aju. Ich agjöta pãrau mʉ iek ũrmapha, warag pãach iita pʉaba wënʉrram khõsi nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Biek ãb jua ʉ̈ʉijem ed Jesús ich khapeen dʉ̈i trigo phur wëjöm ee dich wënʉrrajim aajem. Mag dich wëtumua i khapeenau trigo chi bichpa thʉrrëunaa chi dau juajãagpai sigthʉnaa khö wëtmajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mag khö nʉm oowia chi ajapcha Moiseeu Ẽwandam iek phã pʉatarr ʉʉrkhaajem khʉʉnau amag, —Pãadë oobat, jua ʉ̈i nʉm ed aawai bʉ̈ʉrjã phidkhaju khaba nʉmta pãrau jãg trigo phierrnaa khö wënʉrrʉm. ¿Pãrau chan khaugbahab ajim anʉm, jãgpai phierr nʉmjã nem pöm eeu nʉm dʉ̈i ãba sim? ");
INSERT INTO noaE_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Magbaawai jũrr Jesuu amag —Mamʉ ¿khani mʉ khapeenau khaigba abar? ajim anʉm. ¿Magan pãrau bʉ̈ʉrjã Ẽwandam iek phã sim gaai thʉ̈ʉrwai ooba aajeeb, Daviiu ich dʉ̈i wënʉrrarr khʉʉn dʉ̈imua amach jãsöo aphöbaadeewai Ẽwandam atheem pan khötarr? ");
INSERT INTO noaE_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pãrau khaphʉ nʉm, jãga irua Ẽwandamag jëeujem deg dubwia Ẽwandam atheem pan nasãd gaai phë sĩerr aujĩ. Mag pan parhoobam khʉʉnau khöju khaba, ãba phadëupaita khöju aai sĩejim. Mag khaphʉ sĩerrta irua khöwia ĩchab ich dʉ̈i wënʉrrarr khʉʉnagjã deejimgui ajim anʉm. Mamʉ mag khötarr paarjã Ẽwandamau am chig abajim. ¿Magtarr pãrau khaugbata nʉ? ajim anʉm amag, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Maimua mag jaau dichwia ichdëupai, —Mʉʉn Ẽwandam Iewaa Emkhooirau. Muruata thumaam khʉʉnag khan nemta wauju aai nʉ a jaauju aai chirʉmgui ajim anʉm, jua ʉ̈ʉijem ed awiajã. ");
INSERT INTO noaE_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Maimua biek ãb agjö jua ʉ̈ʉijem ed ich Jesús judionaan biirdʉajem deg dubwia Ẽwandam iek jaau sĩejim aajem. Maig ĩchab sĩejim aajem woun ãb, juachaar garm juadam sĩi jua jʉser khitʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Maagwai judionaan chi machnaan dʉ̈imua chi ajapcha Moiseeu Ẽwandam iek phã pʉatarr ʉʉrkhaajem khʉʉnau Jesuug dau thõba thʉnaajim anʉm, eeu irua jua ʉ̈ʉijem edjã igba õor jua pʉrwia monaaubaawai magʉm gaaimua ichigcha õor dakhĩir “Pua chan jua ʉ̈ʉijem edjã bʉ̈ʉrjã ʉʉrkhabata sim” a iekhaag. ");
INSERT INTO noaE_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mamʉ ichdëu khaphʉ sĩejim anaabá, amau mag khĩirju nʉm. Mag gaaimua chi woundam jua jʉser khitʉmʉg, —Dayag pidú, mau õor jãrrcha dʉnʉʉubaichë ajim anʉm. Magbaawai chadcha bëewia õor jãrrcha dʉnʉʉuchëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mag dʉnʉʉubaicheewai Jesuu magjim anʉm: —¿Pãrau oowai khan nemta maadëu wauju aai nʉ jua ʉ̈ʉijem ed? ¿Õordam dʉ̈i ajapha aju, wa õor khaibag wauju? ¿Õor peerdʉ auju, wa õor thõoju? ¿Khani ʉ̈ucha sĩ? ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mamʉ mag jëeunaa õor thumaam khʉʉn khĩir eerpa phʉʉrdʉdʉkham ich iek ʉ̈khaba abaawai jũrr chi jua jʉser khitʉmʉgta, —Dayag jua ʉabá ajim anʉm. Mag chadcha i ipierr jua ʉabaawai warre jua monakkha sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mamʉ amach dakhĩir magbaawai i dʉ̈i khĩir machag aphöbaadëm iekhau warag öbërdʉtkhawia, —Keena, maadëu jãgata akhiin jãg Jesús thõopʉ̈ikham anaajim anʉm, amach appai. ");
INSERT INTO noaE_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mag Jesuu jua ʉ̈ʉijem edam magwe õrag jaau nʉrrʉm ed gaai durrsĩ gaai waaidʉjim aajem, Ẽwandamag jëwaag. Mam eddurr pöm ich mag Ẽwandamag jëeu ëejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Maimua ãspabaadeewai ich dʉ̈i wënʉrraajerr khʉʉn ich aig thʉ̈rkha auwia mag khapanag eem doce khĩet jʉr aujim aajem. Makhʉʉnta i chognaan i iek jaaujem khʉʉnkha thʉ̈rjim anaabá, apostolnaan. ");
INSERT INTO noaE_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mʉkhʉʉn irua jʉr autarr khʉʉn thʉ̈rʉu: Simón, (ichpai Jesuu Pedro a thʉ̈rjim); Andrés, (chi Simón eeum); Santiago, (ichpai ĩchab Jacobo a thʉ̈r sĩejim); Juan, (chi Santiago eeum); Felipe, Bartolomé, ");
INSERT INTO noaE_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, (ichpai Leví a thʉ̈r sĩejim); Tomás, Santiago, (chi Alfeo iewaa; ichpai agjö Jacobo a thʉ̈r sĩejim); Simón, (Celotenaan ee sĩerr); ");
INSERT INTO noaE_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, (ichpai Tadeo anaa Lebeo a thʉ̈ʉrjerr, deeum agjö Santiago aajerr eeum); maimua Judas Iscariote, (ich maguata ewag pawi chi thethem khʉʉnag Jesús pʉr deeju ajima i thõomkhĩir). ");
INSERT INTO noaE_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Maimua ich Jesús dʉ̈i durrsĩe narr khʉʉnpa thum ãba ʉʉrba bëewia phëeurëgdam ee naaichëjim aajem. Maig agjö ich dʉ̈i wënʉrraajerr khʉʉn khapan biirdʉ thʉnʉm ee, ĩchab deeum durram khʉʉnpa õor pöm thʉnaajim anaabá: Judea durrmua bëetarr khʉʉn, Jerusalenmua bëetarr khʉʉn, maimua phũas igaau phöbör Tiro anʉm dakha naajerr khʉʉn dʉ̈i Sidón perasöm khʉʉnpa thʉnaajim aajem. Ãaur khʉʉn i iek ũrm khõchgau, maagwai tagam khʉʉn sĩi amach monaaupʉ̈i mamkhĩirta mag bëewi naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mag chadcha bën khaigbam khĩirpierr õor mor ee sĩsid arrjã thum jʉr wërppʉ̈inaa monaaupʉ̈imajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mag oowia thumaam khʉʉnau i gaai pʉrm iigjeejim anʉm, amach monaaumkhĩir, amachdëu oowai sĩi i gaai pʉr nʉmuapaijã Ẽwandam jua theeg ich gaai wai simuata bënëgjã ich jua jʉmpiba monaaupʉ̈pʉ̈ikham oowia. ");
INSERT INTO noaE_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mag õor mor masim khʉʉnpa thʉnarr thum monaaukhapʉ̈iwia ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnagta eerpanaa magjim anʉm, ich Jesuupai: —Pãar mʉg mʉ iek ũrm khõchgau dau aphʉʉ wënʉrrʉm khʉʉnta onee abat, mʉg atag pãachta Ẽwandam dʉ̈i ãba jooba wënʉrraju aawai. ");
INSERT INTO noaE_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Onee abat ajim anʉm, pãar ar Ẽwandamau waupim khõsim nem wawaagta jãsöomjö nʉm khʉʉn. Jãgtarr jũrr mʉg atag pãar bʉ̈ʉrjã augchëba wënʉrrajugui ajim anʉm. Onee abat, pãar mʉ gaaimua dauhi paraa durraajem khʉʉn; mʉg atag pãar ökhĩirjug khaugba wënʉrrajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Onee abat ajim anʉm, mʉch chi Emkhooi Iewaa iek ʉ̈kha nʉm gaaimua pãach chikhamnau kha ukhurnaa amach aigmua khãijã warag di chaaur pãach jʉʉrwai. Onee abat, chikhamnau pãach wau iekhamamua khãijã, “Jãg woun chan õor ajapham khabam” a iekhaawai. ");
INSERT INTO noaE_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Õrau pãach dʉ̈i mag nʉm jaar oob ökhĩirjuu amiet ajim anʉm. Mag khãyau warag onee abat ajim anaabá; pãar mag nʉm jũrran ʉ̈gtharin pãar athee nem ajapham pöomata thʉnʉm. Ĩs mʉg pãar mʉ gaaimua dau aphʉʉ wau nʉmjö wënʉrraajeejim warrgarwejã, Ẽwandam i jaaujerr khʉʉn. Mamʉ ĩs ʉ̈gthar Ẽwandam dʉ̈i ya am onee nʉmgui a iekhamajim anaabá, am wawí nʉmua. ");
INSERT INTO noaE_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mag iekhakhagmamua ichdëupai, ’Mamʉ ¡ë apdurr ajim anʉm, õor amach phatkhonta thö iyʉ̈ʉ aajem khʉʉn! Am amach phatkhonag ee am khõchgau Ẽwandam igba arr jũrr, amau mʉg atag oomaa ajurau ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Ë, apdurr ajim anʉm, mʉg jẽb gaai nem thum paraa bʉ̈ʉrjã augchëba aajem khʉʉn! Jãgtarr khʉʉnta jũrr mʉg atag dau aug ee wëtju. ¡Ë, apdurr ajim anʉm, ar sĩi onee am khõchgau bʉ̈ʉrjã amach mor ewag khĩirjuwia ökhĩirjuupaijã aba aajem khʉʉn! Amachdëu ampierr am khõchgau Ẽwandam igba arr jũrr pöd amach ʉ̈gthar öbërba aawai, mʉg atag am icharaucha bĩe nʉisijugui ajim anʉm. Maimua ĩchab, ");
INSERT INTO noaE_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Ë, apdurr ajim anʉm, ar thumaam khʉʉnau pãar ëugar, “Jãan chad woun ajapham pamá” a ig iyʉ̈ʉ aawai! Warrgarwejã par chadcha Ẽwandam i chaar khabamta jaaujerr khʉʉn ëugarjã ich magta iekhaajeejim, pãar jöoinau. Õrau mag am ëugar õor ajapham aajeejieb mamʉ, maadëu khaphʉ nʉmgui ajim anʉm, am pöd Ẽwandam aar öbërba arr. ");
INSERT INTO noaE_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Mag jaaumamua Jesuu magjim aajem ich iek ũr narr khʉʉnag: ’Pãach dʉ̈i iekkhõr paraam khʉʉn kha khõsinaa pãach oomapha aajem khʉʉn dʉ̈ijã nem ajapham waubat. ");
INSERT INTO noaE_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pãach chikhamnau thõp iekhaawai magʉm iekjã igba, warag am kõit Ẽwandamag jëeubat. Maimua pãach ãaukha iekhabaadëm pʉa chʉuu aawaijã, dʉ̈i ãaukha iekhaju khãyau, warag Ẽwandamagta am kõit jëeubat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chikhamnau khãijã pʉch gaai mas deewai oob i gaai agjö deem. Mag khãyau ʉdʉraa pʉch gaai mas apibá. Wa pʉch camis khãijã ãbmua khechthʉg aum iigwai warag tagam khajũajã ʉdʉraa irig arrpibá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wa pʉch nem khãijã ãbmua khechthʉg aum iigwai, meeukhaju khãyau, okhooju awiajã idëu warag arrpibá. Õrau pʉchig nem jëeuwai ö ajapha magʉm aba deebá. Wa ãbmua khãijã khũchpaim athee pʉch nemdam jëeu arrwai oob, “Jöpkhaa mʉ in deebahur” am ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chikhamnau pʉch dʉ̈i khaigba apimapha sim khai, pʉch garmuajã oob i dʉ̈i khaigba am. Õrau pʉch dʉ̈i apim khõsimjöta pʉch garmuajã am dʉ̈i abá ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Magnaa mag ichdëu parhoobam khʉʉnjö apiba sim igwi, ’Pãadë khĩirjubat ajim anʉm: Pãrau pãach jãsenem khʉʉnpaita daupii akhiin, ¿maig khan ajaug sĩ? Bʉ̈ʉrjã Ẽwandam iek ʉ̈khabam khʉʉnaujã amach kha khõsim khʉʉn chan oomap khaba sĩerrjëemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wa pãrau pãach juag oojem khʉʉn juagpaita agjö ookhiin, ¿maigjã khan ajaug sĩ? Mag nʉm aig ʉ̈u khaba sim. Ẽwandam iek ʉ̈khaba aajem khʉʉnaujã jũrr agdaujö chikham juag oojemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pãrau pãachdëu nem deebarmjö pãachig deejöjöo khĩirju nʉm khʉʉnagpaita nem deekhiin, ¿maigjã pãar jãga nʉ? ¿Ich agjö aba aajẽ ajim anʉm, Ẽwandam amach thãar ee chukhu nʉm khʉʉnaujã, deeu agjö amachig nem deemkhĩir? ");
INSERT INTO noaE_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Magua muan pãragan, pãach dʉ̈i iekkhõr paraam khʉʉnjã warag kha khõsita abat a chirʉmgui ajim anʉm. Maimua am dʉ̈i ö ajapha abat ĩchab, pãach nemdam khũchpaim athee khãijã jëeu arrwai tag deen bëebaju khãijãa jãg deebapʉ̈im a iekhaba. Pãrau ö ãkhãrag chukhu magmʉn, ʉ̈gtharin pãar athee nem ajapham pöoma thʉnʉmgui ajim anʉm. Ĩchab pãar mag wënʉrrʉmʉn magan pãar chadcha Cha Ʉ̈gthaa Phuu Nʉm ag chaainaugui ajim anʉm. Ẽwandamau õrau khĩirjuajemjöta khĩirjuajem akhiin, ãba õor ajapham khʉʉnagpaita irua nem deejeekham. Mamʉ i magba thumaam khʉʉn dʉ̈i ajapha khitʉm, õor khaibagjã igba, ni mag ich ajaug khitʉm paarjã õrau ichig ʉ̈u ajim abajujã khĩirjuba. Magua pãraujã agjöta aju aai nʉmgui ajim anʉm, pãach khapeen khaibagjã igba. ");
INSERT INTO noaE_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Maachin thumaam khʉʉn dau aug khaug paraata anʉm, ar jãg maach Aai ʉ̈gthar simuajã agjö maach thumaam khʉʉn dau aug khaaugjẽpirau. ");
INSERT INTO noaE_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Oob chikham ĩgkham khõchgaupai chan chikham pekau phëmiet, eeu Ẽwandamau pãach chach nʉm ed magʉm iek igdukham pãach dʉ̈i. Oob “Jãg wounan chad khaibag ee pʉ̈iju aai sim” amiet, eeu pãach iek gaaimuapai Ẽwandamau pãachta khaibag ee pʉ̈idukham. Chikhamnau pãach dʉ̈i khaigba aawai sĩi warag ich mag khĩir akhoobapʉ̈it, tag magʉm iekjã igba. Pãrau pãach khapeen dʉ̈i magmʉn, magan Ẽwandamaujã pãar dʉ̈i agjö ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pãach khapeenag nem ĩgkhaba deemʉn, Ẽwandamaujã pãrag nem ĩgkhaba deeju. Pãrau pãach khapeenag nem deebarm jũrr, irua pãrag ʉ̈r ag khãyau phẽsu ipiirnaa pör simii deeju. Mamʉ pãrau pãach khapeenag chachnaata nem dee nʉmʉn, magan Ẽwandamaujã ich agjöpai pãrag deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mag ejemplodam khĩir pogkhe jaaumamua, ’Pãadë khĩirjubat ajim anʉm. Woun ãb dau khaugba simua ich khapeer agjö dau khĩsu khitʉm jua gaai pʉr arrkhiin, ãb bʉ̈ëu subaadeeu ¿amach numwe burrbaju khai? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","¿Pãrau oowai eeu woun nem khaug simua ichig jaau sim khãyau atcha nem khaug sĩejẽ? Ichig nem jaaumam thum khaugbapäaiwain chadau ich maestro dënjö nem khaug sĩsiejemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Pʉch dau ee pasur pöm sim joothʉ thʉnʉm nacha noi aubam aig, ¿jãga pua pʉch khapeer dau eem pasurdam bʉ̈rʉʉ khitʉm noi awaag agá? Maachin nacha dich khĩirjunaata iekha nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wa magbam khai, ¿jãga ãbmua ich khaperag “Daai kakë, mua pʉ dau eem pasurdam noi aukhim” aju, mamʉ ich dau eejã ag khãyau nem pöm sim joothʉ thʉnʉm noi auba simta? Sĩi chikham jaaum khõchgaupai chan dich wir aig khĩirjubanaa pöd mag iekhaju khaba nʉmgui ajim anʉm. Khĩirjug chukdam, nacha dich dau eem pasurta noi auba aajeeb, wajapha oog; maimuan chadau jũrr dich khapeer dau eemjã agjö noipʉ̈i nʉm. Magua dichta nacha khĩirjuba aajeeb chikham jawaag. Dichjã agjö chirʉm chan pöd dich khapeen jaauju khabamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mag jajawagmamua, ’Maach jaauju khʉʉn chukhu awiajã maachin dich iekha nʉm gaaimuata õrag dich khap apiejemgui ajim anʉm, õor wäjäauná wa õor khaigbam khʉʉná. Pãrau khaphʉ nʉmgui ajim anʉm, nemjõ ãkhãraa cheejem igwia, “Jãg nemjõon chad ajapha khitabma” aba aajem; maagwai jũrr nemjõ ajapham igwiajã, “Jãg nemjõon chi ãkhãrau” aba aajem. ");
INSERT INTO noaE_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","¿Pãrau oowai pahach gaai nemjõ khũwaa chë sim oojẽ? Kũpud dënjã miel wie nʉm ooba aajem. ");
INSERT INTO noaE_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ich agjöta nʉm ĩchab maach wounaanjã. Õor khĩirjug ajapham khʉʉnau nem ajapham nemta iekha nʉm, amau nem ajaphata wauju khĩirju naawai; mamʉ ö ãkhãraam khʉʉnaun iekhaawaijã nem khaigbamta iekha nʉm, am ödi sĩi nem khaigbamta wauju khĩirju sĩsid aawai. Magta õraun maach iyʉ̈ʉ nʉm ũr nʉm gaaipai warre khaphʉ aajem, khanim woun agá: woun ajapham wa woun khaigbam. ");
INSERT INTO noaE_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Pãrau mua nem jaau chirʉm ipierraa khaba nʉmta, ¿khanthee mʉ igwia sĩi par iiupai “Pʉʉta maar Pöröu” aajẽ? ");
INSERT INTO noaE_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Mua pãrag jaaukhimgui ajim anʉm. Ar chi mʉ aig bëewia mʉ iek ũrnaa mua nem jaau chirʉm ipierraa nem waaujem khʉʉnan, biek ãb woun di ëwaag jẽbdi khörkha sĩi awia durrkhudau ee ierr ich dibʉ̈ jukhanaa di ëutarr wounjöta nʉmgui ajim anʉm. Ya mag aaipa dʉnʉisim ee, döãd pöm bëewia ag gaai dö uu thʉnarrjã chʉyëupʉ̈iba ich mag sĩsijim anaabá, dibʉ̈ ierr jukha sĩerr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mamʉ ar chi mʉ iek ũrtarrta bʉ̈ʉrjã ag ipierraa khaba nʉm khʉʉnan, jũrr agjö woun ãb sĩi khomariipai dibʉ̈ jukhanaa di ëutarrjöta nʉmgui ajim anʉm. Mag khomariipai ëu sĩerr aawai aaipa dʉnʉisim ee, ĩchab noseg pöm chë thʉnʉʉ arr khur döãd pöm pierrwai, dö uu thʉnʉʉ awia sĩi dö badag ʉʉrsirpʉ̈ijim anaabá. Mag, nem thumaa okhoojimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mag õor pöm wëjorrag iek jaau ö dichtarr khur Capernaum phöbörög petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mag Capernaum phöbör ee capitán ãb sĩejim aajem, soldaaun pör. Mag capitán chog ãb irua ʉ̈rcha daupii aajerrta mor mas parhba tag ãwatbajujö thʉnaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mag nʉm ee chi capitanau ũurwai Jesuu õor monaau nʉrrʉm a ũrbaadeewai, judionaan ee jöoin chi thethem khʉʉn jʉrwia pʉ̈ijim aajem Jesús aar, makhʉʉnau chi Jesuug chaigpa phöbaadeewai ich chog monaaupäain ich di aar mamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Mag chadcha ërëuwia, chi Jesús sim aar bardʉtkhaimawia, mag capitán chog mor mas simta phʉʉrba jajaau nʉʉ awia, chaigpa nʉmua irig magjierram anʉm: —Pua capitán di aar i chog monaaun makhiin ʉ̈u akham. I chan maachjö judío khabam, mamʉ maach meeun kha khõsi sĩerrʉmgui ajierram anʉm. Irua maar Ẽwandam iek jaaujem dijã par ëu deejim, ich phatkhonau. Jãgʉm wounaan di aran chadcha pʉ maju aai chirʉm. Pua khõs akhiin maran pʉ awaanta bëejimgui ajierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Magbaawai chadcha am dʉ̈i majim aajem. Mamʉ ya chi aaunaan wai nʉm di dakha wëtum ee, chi capitanau ich aig narr khʉʉn dʉ̈i iek jaaupʉ̈ijim aajem, Jesús aar. Magbaawai wëtwi barimawia irig, —Capitán iek, pʉ mapimaaugau khabam aajem, mamʉ i iek í Ẽwandam dau na ʉ̈u khaba chirʉm aajem, pʉ i di aar maag. ");
INSERT INTO noaE_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ich mag chirʉm khap, ichcha pʉ aig bëeba abarm aajem, pöd pʉ dʉ̈i khĩircha iyʉ̈ʉ aju khaba aawai. Mamʉ pua khõs akhiin, ich maupaimua ich chog monaaupi naajim. I iek pʉch iiu aawai chadcha monaauju aajem. ");
INSERT INTO noaE_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","I iek iruajã ich gaaita khaphʉ chitʉm aajem, ichjã ĩchab ich pörnaan jua eegpai chitaawai. Mag chirab mamʉ, iruajã ĩchab soldaaun ich jua eegar phë wai chirʉm aajem. Makhʉʉnag ãbamʉg khãijã “Pet” aawai maajem aajem, ipierraa. Maimua deeumʉgjã “Pidú” aawai bëejem aajem. Maimua ich chogagjã “Mʉgta abá” abaawai i ipierraa aajem aajem. Magua, maupaimua pua i chog monaaupi jaaumʉn, chadcha monaauju irua khaphʉ chirʉm aajem a jaauchëjierram aajem, Jesús aig. ");
INSERT INTO noaE_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Capitán judío khaba simuata mag iek jaaupʉ̈itarr warm khʉʉnau ichig jaaubaichëm ũrbaawai Jesús jʉ̈gderraa aadëmua ich ẽudee õor pos wënʉrrarr khʉʉnagta, —Keena, pãadë oobat. Mʉg maach israelnaan ee mʉg woun dënjö ʉ̈kha nʉm chan agtha mua ooba chitʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Maimua chi iek jawaan bëetarr khʉʉn deeu ewag wëtwia di aar ooimaawai, maig warppaimua am barju nawe Jesuu monaaupʉ̈itarr aawai mag chi capitán chog mor mas khërarr monakkha khërʉm ooimajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesús Capernaum phöbör ee mag capitán chog monaaupʉ̈iwia öbëraau phöbördam Naín anʉmʉg petajim aajem. Mag i mam dʉ̈i i khapeen khapan wëtmam ee, agjö deeum khʉʉn pöm pos wëtmajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mag mamua phöbör ee dubaag puertdi sim aig dakha pachënaa oowai õor binaan bëpaan warrumta oo athajim anʉm. Ma, khoopaa ũan chaai ichta ãbpai khitarr ajim aajem. Mag binaandam arrum dʉ̈i ĩchab ag phöbör eem khʉʉn õor khapaana wëdurajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Maimua aar barwia maach Pör Jesuu khoopaa ũan ich chaai athee dau aphʉʉ khërʉm oobaawai irig, —Oob bĩem ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Magnaa warag aig bëewia chi binaan arrum pa gaai pʉrbaicheewai chi arrmaa arr khʉʉn dʉnʉisijierram aajem. Magbaawai chi binaan ẽwan sĩerrag, —Mʉ iekhau phiidʉbaad ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Magbaawai ag bʉ̈rre chi mee khërarrdam phiidʉwia ʉ̈u deeu iyʉ̈ʉ aadëjim anaabá. Magbaa Jesuu chi ãdagta, —Ar khërʉm, pʉch chaai athaad ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Magbaawai thumaam khʉʉn jãphierr nʉm iekhau Ẽwandamag jëeumamua, “Chadcha Ẽwandam, ʉ̈u pua maar eeg oo chirʉm. Ʉ̈u pua jãg chaai chi meem arr phiriu atham” ajierram anʉm. Magnaa ĩchab amach wir aigpai, “Keena, ĩsin chadchata maach ee jöoingarmjö Ẽwandam i jaaumie sĩeichëchëm” khajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mag Jesuu chaai phiriu autarr Judea durr thumaam khʉʉnau khakhapdö aphöbaadeewai ichta warag thʉ̈rphöo sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juanaujã ĩchab Jesuu mag nʉrrʉm thum khaphʉ aadëjim aajem, ich khapeenau ich sim aar jaaubaimaawai. Magbaawai ich khapeen numí thʉ̈rkha auwia ");
INSERT INTO noaE_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesús aar pʉ̈ijim aajem, makhʉʉnau irig “¿Pʉʉta chadcha nawe Ẽwandam i jaaumienau bëeju a jaaujerrá, wa ar khabam khai warag ich jãg nʉag?” a khap jëeumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Magbaawai chadcha ërëuwia Jesús sim aar barwia irig maguimajierram anʉm: —Juan chi õor pör choomieu maar pʉ aig pʉ̈ijim, ichig jaaupʉ̈imkhĩir. ¿Pʉʉta chadcha nawe Ẽwandam i jaaumienau bëeju a jaaujerrá, wa marau deeumta nʉju aai nʉwa? Marag ajapha jaaubá marau khap aag aimajierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Magbaawai, —Pãrag oopikhimgui awi, am dakhĩir Jesuu khamor machag sĩsidʉm pöm monaaunaa bën khaigbam wai sĩsid arr khʉʉnjã monaaupʉ̈imajim anaabá. Mag nʉm dʉ̈i ĩchab õor dau khaugba khithëe arr khʉʉnjã dau monaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Maimuan chadau magjim anʉm, chi Juanau chogtarr khʉʉnag: —Ërëubaadëwia Juan aar jaaubaimat, pãach jʉ̈gʉucha ũrwia pãach daúacha mʉg oobarm. Irig, “Dau khaugba khëkhëd arr khʉʉn dau ajapha thʉnʉm abat; bʉ̈ wëdʉ wëdʉ sĩsid arr khʉʉnjã ya ajapha nʉrrjëem; kach khĩsu arr khʉʉnaujã ajapha ũr sĩsidʉm; chi meem arr khʉʉnjã deeu iiu nʉrrjëem; maimua aphʉʉm khʉʉnagjã ĩchab õor peerdʉajem iek jaau chirʉm” a jaaubaimat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ĩchab irig, “Chi mʉ iek ʉ̈khawia ogdʉba mʉ gaai ʉ̈kha chirʉm wounan i onee ich mag chitaju” a jaaubaimat ajim anʉm, mag ichig jëeuwimarr khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Maimua chi Juanau chogpʉ̈itarr khʉʉn ërëu phöbaadeewai chi Juan igwiata Jesuu õrag magjim anʉm: —Pãrau Jordán igaau woun õrag Ẽwandam i jaau nʉrrʉm oon weetwai, ¿sĩi woun iek theeg chukhu phũu choomaar sõsõii jũurba ahau aajemjökhamta oon wëtjierrá? Magʉm woun khabajimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Magan ¿khanim wounta oon wëtjierráma? ¿Woun khajũa ajappha jũa simta oojupii awia oon wëtjierrá? Pãrau khaphʉ nʉmgui ajim anʉm, khajũa ajapha jũanaa thach biwaa khoojem khʉʉnan sĩi phöbör ee di ooimʉm eeta naajem, reinaan dʉ̈i ãba. ");
INSERT INTO noaE_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mamʉ pãrau magjömta ooimabajierram. Pãrau ooimatarran woun ãb Ẽwandam i jaau nʉrrʉm ajim. Mamʉ mua pãrag jaaukhimgui ajim anʉm: Juan chan warrgar Ẽwandam i jaaujerr khʉʉnjöpai khaba, am khãyaujã ʉ̈rʉʉchata sim. ");
INSERT INTO noaE_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","I igwia Ẽwandamau ich i jaaumienag warrgarwe ich iek phãpitarr gaai jaauwai: “Jãata irua mʉ na pʉ̈iju ajim, ichdëuta mʉ na mʉ maju ee õrag jaaumaawai thumaam khʉʉnau mʉ iek ũrm khõsi sĩi mʉ nʉ naamkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Magua muajã pãrag mag chirʉmgui ajim anʉm ich Jesuu: Warrgar Ẽwandam i jaaujerr khʉʉn eejã Juan chi õor pör choomie khãyau ʉ̈rʉʉcharam chan ãbjã chukhu ajim. Mamʉ chi mʉ iek ũrwia, mua nem waubarmjã khaphʉnaa, Ẽwandamta ich thãar ee au sim wounan chad, maadëu nem igba khitawiajã, Juan khãyaujã khapcha aju, jãga Ẽwandam ichdëu õor peerdʉ atham thãar ee sĩeicheejẽ. ");
INSERT INTO noaE_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Pãrau khaphʉ nʉmgui ajim anʉm, chi Juanau jaau nʉrrʉm ũr narr khʉʉn ee thumaam khʉʉnau dëbpaar jëeujem khʉʉnaupa amach khaibag ãsie ewag khĩirjuwia irig pör choopi nʉmua Ẽwandamagta, “Ẽwandam, chadcha puata maar thãar khap chirʉm. Ʉ̈u pua Juanag jaaupiwia marag pʉch iek khaugpibarm” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mamʉ chi Moiseeu Ẽwandam iek phãtarr ajapcha ʉʉrkhaajem khʉʉnau chi machnaan dʉ̈imua chan magba, Ẽwandamau am thãar eejã warm khʉʉn dʉ̈ímjö am ig sim warag isegjierram. Mag gaaimua warag Juanagjã amach pör choopibajierramgui ajim anʉm, amachta ajapcha nʉm awia. ");
INSERT INTO noaE_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Maimua maach Pör Jesuu mag jaaumamua magjim aajem: ’Pãar ĩsim khʉʉn, ¿jãga nʉm abarí? Mua pãrag jaaukhim: ");
INSERT INTO noaE_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pãar ar Juan isegwi mʉjã iseg nʉm khʉʉnan, chaain jemkha nʉmua amach khapeen dʉ̈i khĩir auphöbaadëmjöta nʉmgui ajim anʉm. Warm khʉʉn garmua, “Maar dʉ̈i karris sir nʉm gaai onee jemkhabahut” aawaijã jemkhamapha nʉm. Maimua jũrr, “Magan sĩi ökhĩirjuu õor mee wai nʉm aiguimjö ohoodö abat” aawaijã magjã khõchkhaba nʉm. Pãarjã magta naawai, ¿khani khõsi nʉmma? ");
INSERT INTO noaE_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pãar ee Juan chi õor pör choomie nʉrraajeewai irua ajap thach khöba sʉrkhaajeejim, Ẽwandamag jëwaag. Magʉm vino chará bʉ̈ʉrjã döbajim. Mamʉ mag oowai pãrau, “Jãan mepeer dʉ̈i khapeerkha sĩewaita sĩi ich jãg aai thach khöba nʉrraajem” a iekhaajem pãrau. ");
INSERT INTO noaE_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mamʉ ĩs mʉch chi Emkhooi Iewaa chaar bëewia pãach dʉ̈i parhooba thachdam khönaa vinodamjã dö khitaawai jũrr magjã khõchkhaba, warag pãrau mʉ ëugar thach bipöm khönaa vino pigjã chitʉm aajem. Magnaa gobierno dëbpaar jëeu nʉmua õor khũguurjem khʉʉn dʉ̈ijã khapeerkhanaa pekau pöm sĩsidʉm khʉʉn dʉ̈ipa khapeerkha chitʉm a iekhaajerramgui ajim anʉm, mʉjã iseg nʉm iekhau. ");
INSERT INTO noaE_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Magnaa amag, Mamʉ ar chi Ẽwandamau khĩirjug deetarraucha khĩirju nʉm khʉʉnau chan magba, amau chadcha khaphʉ nʉmgui ajim anʉm, chijã khʉʉnta ich Ẽwandamaucha pʉ̈itarr khʉʉn agá. ");
INSERT INTO noaE_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Biek ãb chi ajapcha Moiseeu Ẽwandam iek phã pʉatarr ʉʉrkhaajem khʉʉn eem woun ãb Simón anʉmua Jesús ich dʉ̈i ãba thach khömkhĩir ich di aar ëeurrjim aajem. Magbaawai chadcha mag woun di aig bëewia, ich atheem thöi khërʉm aig jupwia, dijã ee ãba phʉʉr khöphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Maagwai ag phöbör ee sĩejim aajem, kachaloo ʉʉi ãb parhoobam emkhooin dʉ̈i sĩerrarr. Mag ʉʉirau Jesús Simón di aig thach khö sim khaug athaawai jʉ̈gdee didam durrkhudau alabastro anʉm dën boteedidam wau khitʉm dʉ̈i bëejim aajem i aig. ");
INSERT INTO noaE_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mag bëewia i ëugarmua i bʉ̈khʉrr phõbkhachëwia bĩemamua i bʉ̈ ʉ̈r ich dauchö thëutkhamam ich pörbʉ̈ʉupai jãrpʉ̈imajim anʉm. Magnaa i bʉ̈ ʉ̈ʉ au, ʉ̈ʉ aunaa, jʉ̈gdeeu choomajim anaabá, i bʉ̈ gaai. ");
INSERT INTO noaE_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Chi Jesús thʉ̈rpʉ̈itarr wounau mag oobaawai ich ödegpai, “Mʉg woun chadcha Ẽwandam i jaaumie chaar akhiin, irua warre khaug aukhamgui ajim anʉm, khanim ʉʉirauta jãg ich bʉ̈ gaai pʉrbaichë. Majã pekau pöoma simua ich gaai pʉr simta bʉ̈ʉrjã khaugba simgui” ajim anʉm ich ödegpai. ");
INSERT INTO noaE_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Magbaawai Jesuu chi Simonag, —Simón, pʉdë mʉ iek ũrbarí ajim anʉm. Magbaawai jũrr chi Simonau Jesuug, —Maestro, magan mʉrʉg jaaubarim ¿khan agá? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Magbaawai Jesuu jaaubaadëjim aajem irig. Mag jaaumamua, —Biek ãb wounau õor numiim khʉʉnag phatkhon prestaajimgui ajim anʉm: ãbakhaíg cien denarios deewia warmʉg diez denarios deejim. ");
INSERT INTO noaE_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mamʉ amau phagpʉ̈yaag chukhu narr aawai, “Idëu mua sĩi ich jãg okhoopikhim; oob mʉrʉg phagmiet” ajim anʉm, chi morkhʉʉu. Mag jaauwia Simonag, —¿Chijãgua pua khĩirjuawai ʉ̈rcha i daupii aju khai? a jëeujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Magbaawai Simonau, —Mua oowain chi phatkhon dʉ̈rrcha paraa sĩerraujöo simgui ajim anʉm. Magbaawai Jesuu jũrr irig, —Simón, maiguin chadcha pua ag eyaa jaaubarmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Magnaa chi ʉʉirag eerpanaa Simonag magjim aajem: —Simón, ¿pua mʉg ʉʉi oo chirabá? Pʉdë khĩirjubarí. Pʉ di aig mʉ barcheewai pua mʉrʉg dödamjã jöi deebajimgui ajim anʉm, mʉ bʉ̈ sũgamkhĩir. Mag khãyau mʉg ʉʉirau ich dauchöoupai mʉ bʉ̈ ompʉ̈iwia ich pörbʉ̈ʉupai deeu jãrbapʉ̈im. ");
INSERT INTO noaE_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mʉ barcheewai pua mʉ khĩir ʉ̈ʉnaa, “Pʉ ʉ̈u bëejimjã” abajimgui ajim anʉm. Mag khãyau mʉg ʉʉirau mʉ barchëtarr aigmua ich mag mʉ bʉ̈ ʉ̈ʉ ahaukham. ");
INSERT INTO noaE_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pua aceitedamaujã mʉ pör phuurbajimgui ajim anʉm, mʉ barcheewai. Magtarr mʉg ʉʉirau jʉ̈gdeeuchata mʉ bʉ̈ gaai choowia phuurpʉ̈ijimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ĩs mʉgbarm pʉdë khĩirjubarí ajim anʉm, chi Simonag. Mʉg ʉʉirau mʉ dʉ̈i mʉgbaichëmʉn ich pekau pöoma sĩerr thum chugpaabapʉ̈im jũrrta “Ʉ̈u ajim” a sim khabahab. Chi pekaujã bʉ̈rʉʉm khaba arr aawai ichdëu agjö dʉ̈rrcha mʉ kha khõsi ʉm a sim khabahab ajim anʉm, jãg sim aig. Ich jãgta sĩebahab cha mua pʉrʉg nem ĩgkha chirʉmjã. Ãbmua khãijã ichig dëbpaar paar nʉm khʉʉnag tag phagpiba perdonaamʉn, chi dëbpaar pöomacha sĩerr garmua ʉ̈rʉʉcha i daupii aju. Maagwai bʉ̈rʉʉpai paraa sĩerrau i daupii ajup mamʉ, warm dënjöcha khabaju. Magua ich perdonaatarrpierrpai sĩi irig “Ʉ̈u ajim” ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Maimua jũrr chi ʉʉiragta oonaa, —Pʉ khaibag thum chugpaa sĩsimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Magbaawai i dʉ̈i ãba ohoodö narr khʉʉnau amach wir aigpai iyʉ̈ʉ nʉmua, —Keena, ¿mʉ chijãg woun agá, jãg pekaupa chugpaa sim? ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mamʉ amau mag khĩirju nʉmjã igba warag chi ʉʉiragta, —Oob khĩirjum. Ʉ̈u pʉ peerdʉ ʉisimgui ajim anʉm, pʉchdëu ʉ̈khatarr gaaimua. Pʉch diig maju aai ʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Maigmua maau Jesús phöbörpierr nʉrrʉmua ĩchab phöbör chaaur didam khapan khaba khëkhëdʉm eem magwe nʉrrajim aajem, maach peerdʉajem iek jaauwai. Mag jaau nʉrrʉmua, —Ẽwandamta ya thumaam khʉʉn pörkhaimʉʉ sim. Pãar peerdʉm khõsi nʉm khai, irigta ʉdʉraa pãach phẽethʉgpibat aajeejim anʉm, ichta pãach Pörkhamkhĩir. I dʉ̈i ĩchab wënʉrrajim aajem ichdëu doce jʉr autarr khʉʉn, ");
INSERT INTO noaE_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","maimua ĩchab ʉʉin ichdëu am mor eem mepeen jʉr wërpnaa sĩi khajapham khamor machagau sĩsid arr monaaukhapʉ̈imatarr khʉʉnjã agjö. Chi ʉʉin mag i dʉ̈i wënʉrrarr khʉʉn, dau ãb María ajim aajem ĩchab am dën Magdalena aajerr. Ich mag ʉʉi mor eem ajim aajem Jesuu mepeen siete jʉr wërptarr. ");
INSERT INTO noaE_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ãbakhai Juana ajim aajem, woun Chuza anʉm ʉʉi. Ich mag woun Chuza anʉmuata rey Erodes nem thum ich dënjö khaphʉ aajeejim anaabá. Maimua ãb agjö nʉrraajeejim aajem, Susana anʉm. Maimua mag tag ʉʉin khapan agjö thʉnaajim aajem, amach di aarmua nemdam aibëe nʉm iiu, i jãog wai wënʉrraajerr khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mag Jesús phöbörpierr maach peerdʉajem iek jaau nʉrrʉm jaar, khãai ãb phöbörpierram khʉʉn i aig bëejierram aajem. Maimua thum ãbam aig biirdʉbaadeewai amag nem ĩgkhamamua magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Biek ãb woun nemjĩir dau phoon majim aajem. Maimua mag mawia phö nʉrrʉmua ãaur chi nemjĩir daudam bʉ̈ diichjem ee burrtarr bʉ̈ʉu jẽb ee joothʉgmam dʉ̈i nemchaain bëewia sĩi khökhʉʉipʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Maimua ãaurag mokpör jojoodög ee burrtarr tharrphëjim anʉm, mamʉ mag perasöm jẽb durrkhu ʉ̈rʉʉ sĩerr aawai jẽb jʉsarm gaaimua pöd khaar khaba, sĩi phua khëchjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mag phö nʉrrʉmua ĩchab ãaur khʉʉn miudö arr ee burrjim aajem. Mamʉ chi miuta ʉ̈rpabaadeewai nemjĩirdam õt khaba, sĩi ich magpai aphʉʉ nʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Maagwai tagam khʉʉn jẽb wajaug ee burrjim aajem. Makhʉʉnan chadau öbërwia chëbaadeewai khaarpierr bich thʉʉ jopmajim aajem. Mag jaaumamua, aig narr khʉʉnag, —Keena, jʉ̈g ʉ̈rʉʉnaa chamʉg nem ĩgkhaadam mua jaau chirʉm ajapha ũrbat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Magbaawai i khapeenau irig jëeumamua, —Cha pua nem ĩgkhaadam jaau dichdimam, ¿khan aawaiuma? Marau pöd khaugba abarm, marag jaaubá ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Magbaawai ichdëu magjim anʉm amag: —Pãrau khaugam khõsi ũr naawai, mʉchdëun warre pãrag khaphʉ apiejem, jãgata Ẽwandam õor thãar ee sĩeicheejẽ. Mamʉ warm khʉʉnagan sĩi khajapham nem ĩgkhaadamjöpaita ĩgkhaajemgui ajim anʉm, amau oo nʉmta oobamjö amkhĩir, maimua ũr nʉmjã bʉ̈ʉrjã khaugbamjö amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Maimua amag, ’Mua pãrag jaaukhimgui ajim anʉm, ich Jesuu. Pãrau pãachig jaaupi nʉmʉn mʉgaugui ajim anʉm: Chi nemjĩir dau wounau phöthurtarr, Ẽwandam iek õrag jaau nʉmta jaau simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Maagwai chi nemjĩir dau khʉdjã ee burrmarr, õor Ẽwandam iek sĩi par jʉ̈gʉupai ũurjem khʉʉnaugui ajim anʉm. Amau Ẽwandam iek jaau nʉm ũr nʉm, mamʉ meperau bëewia khũgurbaicheewai ũrba arrjö thãar ee Ẽwandam iek chukhu thʉba nʉm, khʉdjã eem nemjĩir dau nemchaainau khöpʉ̈itarrjö. ");
INSERT INTO noaE_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Maagwai mokpör jojoodög ee nemjĩir dau burrmarr, ar maach khapeenau Ẽwandam iek ũurwai onee ʉ̈khaajem khʉʉnaugui ajim anʉm. Mamʉ thãraucha ʉ̈kha nʉm khaba aawai, nemjĩir dau pöd khaar khaba aajemjö khũchpai ʉ̈khawia iseg pʉajem. Maagwai ʉ̈kha nʉm anʉmta mag iek ajapham gaaimua meperau khaigba aicheewai deeu Ẽwandam iekta isegwia warr amach naajerrjö wënʉrram khõsi nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Maagwai nemjĩir dau sirphʉg dʉ̈i öbërwia õt khaba bãautarr, jũrr ar maach khapeen ihãsisisdöm khʉʉnta jaau simgui ajim anʉm. Amau Ẽwandam iek ũrm khõsi ũr nʉm, mamʉ deeu amach khĩirjug eepai, “Jãgʉm gaaimua pöd mʉ phatkhon auba khãijã chitaju,” wa magbam khai, “Mua chadcha ʉ̈khakhiinjã pöd parhooba mʉchdëu ampierr abaju” a khĩirjuajem. Mag gaaimua mag nemjĩirdam aphʉʉ bãauwia pöd chëba arrjö ĩchab Ẽwandam athee nem ajapha wawaagjã pödba, sĩi serbiibata nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mamʉ jũrr chi nemjĩir jẽb ajaug ee burrtarr, ar õrau Ẽwandam iek amach thãraucha ʉ̈khaa chaar ʉ̈khaajem khʉʉnta jaau simgui ajim anʉm. Magʉm khʉʉnau sĩi par jʉ̈gʉupai ũrba aajem. Amachdëu ʉ̈kha nʉm gaaimua dau aug wauju akhiinjã, majã am gaai mas khaba simgui ajim anʉm, Ẽwandam athee nem ajapha waum khõchgau. ");
INSERT INTO noaE_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ya pãachig jaaubaawai pãrau khaphʉ nʉisim, mamʉ ĩchab mʉg pãachdëu ũrbarmjã pãrau sĩi pãach atheepai wai naaju aai khaba nʉmgui ajim anʉm. ¿Khaíu õtdau paanaa bathẽe eegar wa sĩi nem bʉ̈ ee khãijã ausĩiujẽ? Õtdaun paanaa warre dijã garta ausĩiujemgui ajim anʉm, thumaam khʉʉn dau araraa amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ĩswe chan õrau agtha ajap khaugba nʉm, jãga Ẽwandamau õor peerdʉ auju. Mamʉ mʉg atagta amach daúacha õt bʉ̈ʉg nem waibëenaa oo nʉmjö amau khap aju. Chi mag khaugba nʉm khʉʉnan agtha khĩchag ee nem oo nʉmjöta nʉm, bʉ̈ʉrjã khaugba. ");
INSERT INTO noaE_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ajapha khĩirjubat ajim anʉm, jãga pãrau ũr nʉ. Ar chi thãar onee ũrm khõsi ũr nʉm khʉʉnag Ẽwandamau warag khĩirjug deeju, ich iek khapcha amkhĩir. Mamʉ ar ũrmaphapai ũr nʉm khʉʉn khĩirjug eemʉn, cha mua jaau chirʉm deeu Ẽwandamau ich iek sĩepiba khecheu aujugui ajim anʉm, ũrmapha naawai. ");
INSERT INTO noaE_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mag nʉm ee ich Jesús ãd ich chaain dʉ̈i i aig bëejierram aajem. Mamʉ õor pöm wëjöm khurau pöd i sim aarcha dubba, daaugajãrpai naaichëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Magbaawai õrau irig, —Pʉ eeugpeen pʉ ãd dʉ̈i daaugajãr nʉm. Am iek pʉ dʉ̈i oom khõsi nʉm aajem ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mamʉ magbaawai ichig mag jaauchëtarr khʉʉnag Jesuu magjim: —Mʉrʉgan mʉig Ẽwandam iek ũrwia ag ipierraa nʉm khʉʉnta ĩchab mʉ eeugpeenjönaa mʉ ãdjö sĩsidʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Maimua biek ãb Jesuu ich khapeenag, “Dökhĩrag wëttarrau” awia, chadcha döjãrr paaukhabaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Maimua ya am mag döjãrr khodjörröm ee, ich Jesús khãibaadëjim anʉm. Mag i khãi jörrömta, phũãd pöm bëewia phũasdau dapag baupa aadeewai sosookhamua japau ãwatbajujö aadëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Amachdëu mag oophöbaadeewai i khãi jörröm aar mawia, —¡Maestro, phiidʉbaad! Ya maachin khöogpamgui ajierram anʉm. Magbaawai phiidʉwia, phũ theeg thʉnʉmʉg meeurrau sĩunaa, ĩchab chi phũasagjã meeurrau sĩubaawai, tag phũjã wëba phũasdaujã baupa khaba, warre sĩi döjã meuu jöisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Maimua jũrr ichdëu amag, —Keena ajim anʉm, ¿mʉg pãar mʉ dʉ̈i khodjörrömjã nem ökhöta nʉ? Jãgan pãrau chan mʉ pãach dʉ̈i chitʉmjã khaugbata naab ajim anʉm, jãgcha jãphierraag. Mag amach dakhĩir phũ dʉ̈i phũaspa warre thumba atham oobaawai jãphierrnaa dauderraa nʉmua amach appai ökharii, —Keena, ¿khanim wounta mʉg phũugjã iekhanaa phũasagjã iekhaawai i ipierraa aajẽma? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mag wëtmamua khodjörröo awia Gerasa durr barjierram aajem, ich ag thʉrrdö eepai thoom igar Galilea khĩirphee. ");
INSERT INTO noaE_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mag Gerasa durr barimawia Jesús durrpabaadeewai i khĩirphee woun ãb phöbör eemua öbërchëjim aajem. Mag woun ich warrgarwe dösãt bënëu sĩpwia ich mag bar nʉrraajeejim anaabá. Mag gaaimua nawe degmua mawi, tag degjã khaba, ãba ujã ʉ̈rpai khãinaa, khajũa kharraa ich mag sĩerrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mag wounau Jesús oo athaawai dëgölp wiiu a i bʉ̈khʉrr phõbkhabaimawia chaigpamamua thet irig magjim anʉm: —Jesús, Cha Ʉ̈gthaa Phuu Nʉm Iewaa, ¿khantheeta pua mʉ mʉgbaichëma? Oob mʉ chig a chiram ajim anʉm, chi mepeer garmua Jesuu ichig woun mor eemua öbërpi jaaubaawai. Mag chi mepeer ajap thierrpa sĩerr aawai ʉ̈iba baarjeejim anaabá. Mag barbaadeewai parii cadenau jʉ̈naa grillos anʉm eejã bʉ̈ khõokha sĩsiukhamjã i atheem khaba aajeejim anʉm. Sĩi warag caden thʉrrëupʉ̈iwia õor chukag aar warp warrjeejim anaabá, chi meperau. ");
INSERT INTO noaE_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Maimua Jesuu irig, —¿Pʉ khan a thʉ̈ʉrjẽ? ajim anʉm. Magbaa chi wounau, —Mʉʉn “Mepeen Phöbör” a thʉ̈ʉrjemgui ajim anʉm. Irua mag sĩerran, bën pöm ich mor ee dubchë thʉnʉm wai nʉrraajerr aawaita mag sĩejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Magbaawai chi mepeen woun mor ee mag thʉnarrau Jesuug, —Oob warre khĩmie durr chan maar pʉ̈i chiram. ");
INSERT INTO noaE_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mag khãyau ar khũsnaan phathau khö wënʉrrʉm eeta idëu maar dubpibá ajierram anʉm, ag dakha khũsnaan khapan thʉnarr aawai. Magbaawai Jesuu amag ʉdʉraa khũsnaan eeta dubpijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Magbaa chadcha woun mor ee mepeen pöm mag thʉnarr öbërdʉtkhawia jũrr khũsnaan ee naaimaawai, khũsnaanta parhooba khaphig phöbaadëwia ithurmʉg ʉ̈rmua thʉrrdö pöm wëjöm ee dʉrbagkha sĩi khẽu khuurbʉ khëchjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Magbaa chi khũs thʉa narr khʉʉnau amachdëu mag oobaawai jãphierrwia phöbörög khaphig phöbaadëjim anʉm, õrag jawaan. Mag wëtumua ĩchab phöbör chaauraa di nʉnʉidʉm eem khʉʉnagjã jaaumajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mag phöbör ee jaaubaimaawai, chadcha aar oon weetwai, chi woun mor ee bën pöm wai sĩerr wajapha khajũa jũanaa, ag na magba aajerrjö, sĩi ya maach khĩir ich mʉg Jesús khĩirphee jup sim ooimajierram anaabá. Amachdëu mag oobaimaawai jãphierraa aphöbaadëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Magtarr chi ootarr khʉʉnau jũrr chi oon bëe nʉm khʉʉnag jaau naajim anʉm, jãga mag woun dösãtau mag wai nʉrraajerrta ʉ̈u Jesuu monaaupʉ̈ijĩ. ");
INSERT INTO noaE_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Magbaawai Gerasa perasöm khʉʉn pöm aig thʉnarr khʉʉnau jãphierr nʉmua Jesuug chawag mapi jaau naajim anʉm, amach ee sĩepiba. Mag chadcha, Jesús jap ee pabaadëjim aajem, deeu amach berrag wëtaag. ");
INSERT INTO noaE_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mamʉ mag am wëtaagpam ee, chi woun mag dösãt bënëu baarjerrau Jesuug jëjëeu aajeejim anaabá, i dʉ̈i maag. Mamʉ Jesuu i arrba warag irig, ");
INSERT INTO noaE_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Pʉch diigta petá, maimua thumaam khʉʉnag jaaupet ajim anʉm, jãga Ẽwandamau ʉ̈u pʉ eeg oowi pʉ monaaubar. Ichig magbaawai chadcha phöbör ee petawia ich mag jajawag majim aajem thumaam khʉʉnag, jãga Jesuu i dau aug khaugwia ich bën chugpaapʉ̈itarr. ");
INSERT INTO noaE_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mag Jesús deeu ich khapeen dʉ̈i jap ee pawia Galilea durr barimaawai õor pöm sĩi i nʉ khodthʉnaajim aajem. Mag i barbaimam oobaawai thumaam khʉʉnau irig, “Ʉ̈u pʉ bëejim” anaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Mag i barbaimam ee, woun ãb judionaan Ẽwandam iek jaaujem di thʉajem Jairo a thʉ̈r sĩerr i aig bëejim aajem. Mag woun chan tag chaaijã chukhu, ãba chaai ʉʉikhaardam doce añosjö sĩerrdam appai khitʉmta ya meemaa ajim anʉm. Mag tag chaaijã chukhu ãbpai khitʉm meemaa aawaita Jesús bʉ̈khʉrr phõbkhanaa ö bʉ̈rʉʉ aichëjim anʉm, ich di aar arrwia mag ich chaai mor mas khërʉm monaaupʉ̈imkhĩir. Mag ich aig ö bʉ̈rʉʉ aicheewai, ya agʉg wëtumta, warag õrau am phẽeudʉ arrmaa ajim anʉm, pöd majujã khaba. ");
INSERT INTO noaE_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mamʉ õor pöm mag thʉnʉm ee, ĩchab ʉʉi ãb sĩejim aajem, doce años sĩi phõmieu bar sim. Mag ʉʉirau ich phatkhondam thum gastaapʉ̈iwia sĩejim anaabá, doctornaanag ich ëwaupi simua. Mamʉ ãbmuajã pöd i monaau auba aajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mag ʉʉi mag simua Jesús ëugarmua bëewia i khajũahidam gaaipai pʉrchëjim anʉm. Mag irua pʉrbarm bʉ̈rre chi phõmie thʉbabaadeewai warre ich mag monaau sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Magbaawai Jesuu, —¿Khaíuta mʉ gaai pʉrbaichëma? ajim anʉm. Mamʉ ãbmuajã jaauba aawai Pedroou ich khapeen dʉ̈imua, —Maestro, khaíu abarjugui ajim anʉm. Pʉch aig õor phẽeudʉdʉkham khʉʉnau khabahab, pua mag chirʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mamʉ Pedroou ichig magbaawai warag Jesuu, —Ʉ̈ʉ̈, sĩi õor phẽeudʉdʉkhamua khabam. Mua khaphʉ chirʉmgui ajim anʉm, juau ogthomta ãbmua mʉig mʉ gaai pʉrbaichëm. Mag pʉrbaicheewai Ẽwandam juapá mʉ gaai simua monaaubapʉ̈imjã mua khaphʉ chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mamʉ chi ʉʉirau ũurwai ichdëu meraa pʉrchëtarrta Jesuu mag ijẽb aadeewai, khĩir naau nʉm iekhau, bʉ̈ duui bëewia i bʉ̈khʉrr phõbkhachëwia, meerba õor thumaam khʉʉn dakhĩir jaaubaadëjim anaabá, khan atheeta irua mag i gaai pʉrchëjĩ, maimua jãga mag pʉrbarm bʉ̈rre i monaau ʉisijĩ. ");
INSERT INTO noaE_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Magbaawai Jesuu irig, —Oob chigaa am ajim anʉm. Mua pʉch monaauju khaphʉ mʉ gaai pʉrchëtarr gaaimua ʉ̈u pʉ monaauwia peerdʉ ʉisim. Pʉch diig maju aai ʉmgui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mamʉ agtha mag i iekha öba nʉm ee, woun ãb bëejim aajem, mag judionaan Ẽwandam iek jaaujem degam chi pör Jairo anʉm di aarmua, i ẽudee. Mag bëewia chi Jairoog, —Kakë, ya aaunaanaujã pöd ãwatba abarm. Idëu Maestro sĩubá. Ya par maach aar i mabajup aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mag jaaubaichëm ũrbaawai Jesuu magjim anʉm chi Jairoog: —Oob khĩirjum. Pua pʉch chaai ʉ̈u oo wai chitaju. Sĩita ãba murua pʉch chaai monaauju khĩirjugta wai chirsí ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Maimua warag wëtwia di aar barimajierram aajem. Mamʉ thuur khërʉm ee chi binaandam wai narr aar chan ich dʉ̈i õor khapan dubpiba, ãba chi dubtarr khʉʉnan, Pedro, Juan, Santiago, maimua chi aai chi ãd dʉ̈ipaita ich dʉ̈i dubpijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mag barwia ooimaawai, thumaam khʉʉn sereeu icharaucha bĩe nʉm dʉ̈i ĩchab ʉ̈apëpërkhamta ooimajim anaabá. Mag oobaimaawai Jesuu amag, —Oob bĩemiethʉ̈. I meeba sĩita i khãi sĩebahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mamʉ irua magbaawai, aig narr khʉʉnau warag i wau iekha naajim anaabá, amachdëu chadcha chi chaai mee sim khaphʉ narr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mamʉ amau mag nʉmjã ũrba, warag dubwia chi binaan juadam gaai pʉrnaa, —¡Ʉʉikhaardam, phiidʉbaad! ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Magbaawai i akhaardam deeu i gaai khëraicheewai ag bʉ̈rre phiidʉbaadëjim anaabá. Mag phiidʉbaadeewai irig thachdam au deemkhĩir jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mag phiidʉbaadëm oobaawai chi dënnaan khĩir ëu awia warre dauderraa nʉisijim anʉm. Maimua ichdëu magwia aig narr khʉʉnag, —Ĩs pãachdëu mʉg oobarm oob chikhamnag jaaumiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Maimua Jesuu ich khapeen doce ich dʉ̈i ogdʉba wënʉrraajerr khʉʉn ãbam aig thʉ̈rkhanaa agdaujö juapá deemajim aajem, ich dënjö õor mor eem mepeen jʉrkhʉʉinaa mor masim khʉʉnjã monaau wënʉrraju ayaa amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mag pʉ̈yaagpamua amag magjim anʉm: —Mua pãar pʉ̈i chirʉm, õrag “Ẽwandamta thumaam khʉʉn Pörkhaimʉʉ sim” a jaaumkhĩir, maimua ĩchab amag “Pãar peerdʉju khai irigta ʉdʉraa pãach Pörkhapibat” a jaau wënʉrramkhĩir. Mag wënʉrrʉmua ĩchab khamor machagjã thum pãrau monaau wënʉrrajugui a jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Maimua ĩchab amag, ’Pãach jua kharr ërëubaadët, bʉ̈ʉrjã nem inag arrba: bordón chukhu, talegdijã chukhu, ni thach ni phatkhonjã oob arrmiet; ich jãg ërëubaadët ajim anʉm, khajũa theg jũajujã chukhu. ");
INSERT INTO noaE_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maimua pãach wënʉrrʉmpierr pãachig di jaaubarm degpai kheeupaawai khãibat ajim anʉm, pãach maigmua wët nʉm ora. ");
INSERT INTO noaE_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mamʉ phöbör ee ni ãbmuajã pãach amach deg dubpiba ni pãach iekjã ũrba abaawai warre amach dakhĩirwe pãach bʉ̈ gaaim jẽb ʉʉrphë ʉʉrphënaa pãachta ërëubaadët ajim anʉm. Pãrau magmʉn magbarmuapai amag “Pãachdëu jãg Ẽwandam iek ũrba abarm gaaimua ich dʉ̈ita khĩir khap abat” anʉmʉugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mag, chadcha Jesuu amachig mag jaaubaawai ërëubaadëwia phöbördampierr jãga Ẽwandamau maach peerdʉajẽ a jaau wënʉrrʉm dʉ̈i ĩchab durrpierr aaunaanpa monaau wënʉrrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rey Erodes anʉmua ũrbaadëjim aajem nem thum Jesuu wau nʉrrʉm. Mag ichdëu ũrbaadeewai khakhaisamjö aadëjim anaabá, jũrram khʉʉnau “Juan chi õor pör choomieta iiu phiidʉwia nʉrraichëm” a jaauchëchëkham ũrwia. ");
INSERT INTO noaE_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mag nʉm dʉ̈i irua ũurwai ãaur khʉʉnau jũrr, “Elías warrgar Ẽwandam i jaaujerrta öbërchëwia jãg nʉrrʉm aajem” a jaau nʉm dʉ̈i agjö bigaaum khʉʉnau jũrr, “Elías khabam khai jãan chadcha jöoingar Ẽwandam iek jaaujerrta deeu phiidʉwia jãg nʉrrʉm” a jaauchë naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mag bĩi wëjöm ũrwia chi Erodeeu ich ödegpai, “Keen, magaag Juanan mua ö thʉappʉ̈ipitarrau. Magan, ¿khai ajuma õrau mag bĩi thʉnʉm?” aajeejim anʉm. Mamʉ parhooba mag jaau thʉnʉm gaaimua ichdëuchata i dʉ̈i oom khõchag sĩejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mag doce ich Jesuucha pʉ̈itarr khʉʉn wënʉrrʉʉ awia bardʉtkhacheeu amachdëu nem wau wënʉrrarr thum irig ĩgkhachëjierram aajem. Magbaawai chi Jesuu chawag am phë arrjim aajem, phöbör Betsaida anʉm igaau õor chukag ee. ");
INSERT INTO noaE_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mamʉ õrau mag i petam khaugpʉ̈itarr aawai i ẽudee pochag wëtjim anʉm. Mag wëtwia ich aar bardʉtkhabaimaawai Jesuu amag, —Ʉ̈u pãar bëejimgui awia, warag amag, Ẽwandamta thumaam khʉʉn Pörkhaimʉʉ simgui ajim anʉm. Pãar peerdʉju khai, irigta ʉdʉraa pãach Pörkhapibat a jaaumajim aajem. Mag jaaumamua ĩchab mor masim khʉʉnpa monaaupʉ̈imajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mag õor monaaupʉ̈pʉ̈ikham ee, warag edau khëuju gar pabaadeewai chi doce ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnau i aig bëewia irig, —Mʉig maach õor chukag eeta nʉpí, phöbör ee wa di dakha nʉnʉidʉm ee khãijã amag wëtpi jaaubá ajierram anʉm, magʉm aar thachdam khöwia khãimkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mamʉ magbaawai Jesuu jũrr amag, —Am pʉ̈iju khãyau, pãachdëuta amag thach deebat ajim anaabá. Magbaawai jũrr amachdëu magjierram anʉm irig: —Maar khöju chukhu nʉm amag deeg; ãba pandamta cinco wai nʉm dʉ̈i ãwarrdamta dau numpai wai nʉm. ¿Jãga õor pöm mʉg thʉnʉm marau jãogbarju? ¿Wa phöbör eeta marau khöju për awaan wëtjuwa? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mag õor pöm thʉnʉm ee emkhooin appai cinco miljö naajim aajem. Magbaa Jesuu amag, —Õrag jaaubat ajim anʉm, ãbam aigpai poso de cincuenta en cincuenta khĩkhĩratdö jupkhamamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mag chadcha i ipierraa õrag jaaubaawai thum ich mag poso phʉʉr ohood aphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Magbaawai ich Jesuu mag pan cinco narr chi ãwarrdam numpai narr dʉ̈i ãba phë auwia, ʉ̈gthaag eerpanaa, Ẽwandamag ʉ̈u ajim anaa, thorreuwia, ich khapeenag ʉapʉ̈imajim aajem, jũrr õrag jigmamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mag jigmamua thumaam khʉʉn biwaauwia imie phöbaadeewai chi pan ãwarr dʉ̈i sobtarrau thʉbʉt doce ipiirkha aujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Khãai ãb Jesús ich dʉ̈i doce ogdʉba wënʉrraajerr khʉʉn dʉ̈i õor chukag ee mawia Ẽwandamag jëeu sĩejim aajem. Mag jëeu dichwia amag, —Õrau mʉ igwia iyʉ̈ʉ nʉm ũurwai, ¿am iek mʉ khai aajẽ? ¿Pãrau ũrba aajẽ? a jëeujim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Magbaawai amachdëu magjierram aajem: —Am iek pʉ Juan chi õor pör choomie aajem; deeum khʉʉnau jaauwai, pʉʉta Elías aajem, warrgar Ẽwandam i jaaujerr; maagwai pogkha jaauwai pʉ sĩi warrgar agjö Ẽwandam i jaaumie arrta deeu iiu phiidʉwia nʉrraichëmjã a jaaujem am dën ajierram aajem jũrr irig. ");
INSERT INTO noaE_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ichig magbaawai, jũrr amachigcha, —¿Ma pãachdëujãma, pãrau khĩirjuawai mʉ khai agá? a jëeujim anʉm. Magbaa Pedroou irig, —Pʉʉn Cristoou, ar warrgarwe ich Ẽwandamaucha õor peerdʉ aumkhĩir pʉ̈iju jaaujerr ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedroou ichig magbaawai, —Chadcha pua ag eyaa jaaubapʉ̈imkë ajim anʉm, mamʉ oob bʉ̈ʉrjã chikhamnag jaaum ajim anʉm. Warm khʉʉnagjã jaaupibajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Maimua magjim anʉm: —Mʉch chi Emkhooi Iewaa chadcha dau aphʉʉ aju aai chirʉm. Mʉ dau ãaukha isegwia Jerusalenpie jöoin chi thethem khʉʉnau phadnaan chi pörkha nʉm khʉʉnaupa Moisés iek jawaag chi machnaan dʉ̈imua mʉ thõomkhĩir pʉr deeju. Mamʉ mag amau mʉ thõowiajã khãai thãrjupam ee phiidʉwia deeu mʉ iiu chirsijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Maimua thumaam khʉʉnag eerpa eerpanaa, —Chadcha pãrau mʉ iek pãach thãraucha ʉ̈kha nʉm khai, magan mua nem waupi jaau chirʉm appaita waubat ajim anʉm, “Mʉchdëuta khap chirʉm mʉchdëu nem wauju” a iekhaba. Mʉ gaaimua chikhamnau pãach dau aphʉʉ thõoju khĩirjuwia khãijã magʉm igba, waragta ʉ̈khanaat. ");
INSERT INTO noaE_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ar chi mʉg jẽb gaai mʉ gaaimua bʉ̈ʉrjã phithurg aumapha wënʉrrʉm khʉʉn chan meem edjã ʉ̈gthar öbërbamgui ajim anʉm. Magarrau ar chi mua nem jaau chirʉm waum khõchgauta amach nemjã khĩirjuba sĩi warag mʉ gaaimuata dau aphʉʉ anʉm khʉʉnan chadau ʉ̈gtharcha öbërjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pãrau oowai, ¿khan ajaug sĩ ajim anʉm, woun ãbmua mʉg durr thum ichdëupai jʉ̈a wai sĩsim, mamʉ mag sim meebaadee khĩmie durr petam; irua ich durr thum ich dʉ̈i arrju aai sĩ? Pöd arrbamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ãb khãijã mʉ gaaimua wa mʉ iek jaauju khãijã õor dakhĩir chigaa amʉn, mag mʉch chi Emkhooi Iewaajã thumaam khʉʉn Pörkhanaa mʉch Aai dʉ̈i ʉ̈gthar i chognaan thʉnʉm khʉʉnpa mʉg durr chachaan bëem edjã muajã ĩchab ich khĩircha eerpanaa chigaa warag, “Mua, bʉ̈ʉrjã pʉ khaugba chitʉm” ajugui ajim ");
INSERT INTO noaE_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cha mʉ iekha chirʉm iekhau ãaur khʉʉn cha mʉ iek ũr nʉm khʉʉn chan mʉchta thumaam khʉʉn Pörkha bëeju edamjö aadëm oobam aigjã meebajugui ajim aajem Jesuu ich khapeenag. ");
INSERT INTO noaE_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mag ich khapeen ãaur khʉʉnag amach daúa ich oopiju jaautarr khur seman ãbjö nʉm ee, durrsĩ gaai Ẽwandamag jëwaan mamua ich dʉ̈i phë arrjim aajem Pedro, Santiago maimua Juan. ");
INSERT INTO noaE_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mag mam wëtwi ich Ayag jëeu simta, dëgölp sĩi bʉ̈ʉmjö aadëjim anaabá, ich mor gaai khajũa jũa sĩerrpa. Maagwai chi khajũa chará sĩi phuumjö aadëjim anʉm, ich bäpgau. ");
INSERT INTO noaE_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","I magbaadëm ee wounaan numí i bigaau dʉnʉʉutkhachëwia i dʉ̈i iyʉ̈ʉ naajim aajem. Mag i dʉ̈i iyʉ̈ʉ narr khʉʉn, jöoingar Moisés khararr ajim aajem Ẽwandam i jaaumie Elías khararr dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mag am iyʉ̈ʉ dʉnʉnʉidʉ aichëm dʉ̈i ĩchab pagthʉm daujö phʉr jẽer athamua mag ãsdaau narrta sĩi warag arar am wʉʉ wai sĩsijim anaabá. Am iyʉ̈ʉ narran, ich Ẽwandamaucha warrgarwe ich i jaaumienag jaautarrjö, Jerusalén phöbör ee õrau i thõojuuta ig iyʉ̈ʉ naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mamʉ maagwai Pedro ich khapeen numí amach ãba wënʉrrarr khʉʉn dʉ̈i sĩi daphökgau pöd dau ẽebajujö thʉnʉmuata oo naajim anaabá, mag Jesús Moisés dʉ̈i Eliapa iyʉ̈ʉ dʉnʉnʉidʉ nʉm. Maagwai ich Jesuun agtha sĩi bʉ̈ʉmjö thʉnʉm dʉ̈i i khajũa chará phuumjöta thʉnaajim anʉm, ich bäpgau. ");
INSERT INTO noaE_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mag ãba dʉnʉnʉidʉ naawia chi warm khʉʉn i aigmua wëtaag ẽkha nʉm ee, Pedroou irig, —Maestro, ʉ̈u chi agamjö nem ajaug maar mʉig nʉm, ¿jãgwia maadëu rãichdi thãrjup ëu aubá? ajim anʉm, ãb pʉ athee, ãb Moisés athee maimua ãb Elías athee. Mamʉ mag sim chan Pedroou ich iekha simjã khaugba simta mag iekha dʉnaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mamʉ mag i iekha dʉnʉm ee, jʉʉnthumie baug bëewia am jöodʉ athaicheewai jãphierr phöbaadëjim anaabá, ag ee ierr paaukhabaadëm oowia. ");
INSERT INTO noaE_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mag jʉʉnthumie ee am ierr paaukhabaadeewai ag eemua woun iekjö, “Chamʉʉta mʉ Iewaa, mʉchdëu jãsehne wai chitʉmʉu, õor peerdʉ aumkhĩir mʉchdëu jʉr autarr. Irua jaau simta ipierraa abat” a iekhabarm ũrjierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Maimua chi woun iekjö sĩerr khĩubaadëm dʉ̈i ĩchab chi jʉʉnthumiejã chukkhu aadëm ee oowai Jesús ich appai oo dʉnaajim anʉm. Mamʉ amachdëu mag ootarrjã ag ed gaai chan bʉ̈ʉrjã deeum khʉʉnag jaauba, sĩi khĩuu nʉisijierram anaabá, nem dau chig ooba arrjö. ");
INSERT INTO noaE_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ag noram ãspaau mam durrsĩ gaai naawi deeu ich khapeen dʉ̈i jër paaukhabaadëm ee, am khĩirphee õor pöoma wëdurajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mag khapan pos wëdurum eemua woun ãb i aig bëewia irig magchëjim anʉm: —Maestro, mʉ chaaidam thõthõrrsö khitʉm pʉ aig aibëejim. ¿Pua mʉ dau aug khaugwia i monaaupʉ̈ibaju khai? Mʉ chan tag chaaijã chukhu ãba mʉgdam appaita wai chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mʉg khërʉm ich bënëu barbaadeewain nem theegta baarjem. Di bäbäjä khabaadëmua ääikham dʉ̈i sĩi isaphunjã bau aadeejem. Mag di bäbäjäkham pʉamjã igba thʉnʉʉ awia bar dichdimaawain gaai machgau sĩita kha aupihba aadeejemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chi mepeer öbeerpʉ̈imkhĩir pʉ dʉ̈i ogdʉba wënʉrraajem khʉʉnag mua jaautarrjã amau pödbajierramgui aichëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Magbaawai Jesuu thumaam khʉʉnag eerpanaa, —Pãran chadcha pãach thãar khaibag gaaimuata pãrau chan jãg chaai Ẽwandamau monaaupʉ̈ijujã khĩirjuba nʉmgui ajim anʉm. ¿Pãrau jãg Ẽwandam jua theeg simjã khaugbamjö nʉm sĩi ich jãgta mua ãwat chitaju aai chirʉ́ pãrau oowai? ¿Khan atchata pãrau mʉ pãach dʉ̈i chitapim ig nʉma ajim anʉm, ajapcha ʉ̈khaag? Magnaa jũrr chi ayagta, Mʉ aig pʉch chaai aipidú ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mag chadcha chi ayau aidurum ee, chi chaai ich bënëu theega barbaadëmua warre jẽkhʉt barwerbpʉ̈ijim anʉm. Magbaawai Jesuu chi mepeer mag chi chaai mor ee simʉg meeurraunaa öbeerpi jaaubaawai warre öbërbaadëjim anaabá. Mag chaai monaaupʉ̈iwia chi ayag, —Ar khërʉm pʉ chaai ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mag Jesuu chaai monaaubarm oowia thum aig narr khʉʉn dauderraa nʉisiwia Ẽwandamagta, “Ẽwandam, pʉchta chadcha mepeen khãyaujã chi jua thierriu. Mepeenau chan pöd pʉ dʉ̈i barbam” ajierram aajem. Tagam khʉʉn mag dauderraa thʉnʉm ee, Jesuu ich khapeenag magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ajapha mʉ iekhaagpam ũrwia khĩir eyaa wai nʉisit. Mʉigmua pömcha khaba nʉm ee, mʉg mʉch chi Emkhooi Iewaa mʉg chirʉmʉn chi thierrnaanag pʉr deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mamʉ chi khapeenau Jesuu amachig mag iekhabarmjã warre khaphʉ aju nem khaba arr aawai pöd khaugbajierram anaabá. Mag amachdëu pöd khaugba abaawai irig jëeujöjöo naawi warag inagau jëeuba, ich magpai nʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Maimua wëtwia amach appai aphöbaadeewai, “Keena, magan mʉg nʉm aig, ¿chijãata ʉ̈rʉʉcha sim khai?” a iyʉ̈ʉ aphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mamʉ Jesuu am khĩirjug khaphʉnaa am thãarjã khaphʉ sĩerr aawai, mag iyʉ̈ʉ nʉm ũrbaa chaaidam jiir auwia ich bigaau dʉnʉʉupi khërnaa amag magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Mʉg chaai agtha ich juau paba aawai serbiiba khitʉmjö õor thʉnʉm thum mua khõsi chitʉm. Pãrau mʉ dënjö mʉg khithëem ãb khãijã jãsenkhawia pãach di aig aumʉn, magan pãrau mʉchchata mag khĩir jãsenkhabarmjö abarmgui ajim anʉm. Mag pãrau ʉdʉraa pãach aig mʉ baarpi nʉm aiguin magan pãrau mʉ Aaijã khõsi nʉm anʉm, ichdëuta mʉ pʉ̈itarr aawai. Mua pãrag jaaukhimgui ajim anʉm: Ar amachdëupai khĩirjuawai thumaam khʉʉn khãyaujã chaai bʉ̈rʉʉmdamjö serbiiba nʉm a khĩirju nʉm khʉʉnta warm khʉʉn khãyaujã ʉ̈rʉʉcha nʉmgui ajim anʉm chadcha, Ẽwandam dau na. ");
INSERT INTO noaE_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Magbaawai Juanau Jesuug, —Maestro, marau woun ãb oojimgui ajim anʉm. Mag wounau iekhamamua pʉ thʉ̈r thʉ̈rnaa õor mor eem meperag öbeerpi jaaubaawai chadcha öbeerpʉ̈i maajeejim. Mamʉ maarjö pʉ dʉ̈i nʉrraba aajemuata mag sĩewai marau irig tag õor mor eem mepeen jʉrkhʉʉipiba jaaujimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Magbaa Jesuu magjim anʉm irig: —¿Khanthee pãrau idëu õor jua pʉrpiba irig magjierrá? Maadëu nem wau nʉm oowia maach ichaaur aba warag maach juapierr oo sim khai, magan maan dʉ̈i maach igar sĩewaiugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ya Jesús deeu ʉ̈gthar ich Aai aar maimʉʉ aadeewai warag thãar phĩiuwia ögkhaba Jerusalenag petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Mamʉ ich na di jʉrwia nem khĩir khaugamkhĩir, ich khapeen eem õor jʉr auwia pʉ̈ijim aajem. Magbaa makhʉʉnau ërëuwia Samaria durr phöbördam pöm khaba khitʉm ee i na di jʉrimajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mamʉ chi Samariapienau Jesús sĩi Jerusalenagta mam a ũrbaawai i athee chan di chukhum ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Magbaawai deeu bëewia mag irig deebaju abarm jaauchëjierram aajem. Mag ũrbaawaita jũrr Santiagoou Juan dʉ̈imua, —Señor, ¿pua oowai mag pʉrʉg di deebam anʉm jũrr marau Ẽwandamag jëeuju aai nʉ ajim anʉm, Elías khararrau jëeubaawai atarrjö am phöbör pábaadëmua uurdʉ khëchpʉ̈imkhĩir? Marag jaaubá ajim anʉm Jesuug. ");
INSERT INTO noaE_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Magbaawai Jesuu amag phʉʉrba oonaa magjim anʉm: —¿Khaíu pãrag jaauwai magta aju aai nʉm ajĩ, õrau dich kha isëe aawai? Chi mag iekhaajem khʉʉnan bʉ̈ʉrjã Ẽwandam iek ũrba aajem khʉʉnta mag iekhaajemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mʉch chi Emkhooi Iewaan mʉg jẽb gaai õor peerdʉ awaanta bëejim. Mʉ mag mʉch garmua warag õor amach pekau ee durrum peerdʉ aubanaa sĩi öpʉ̈yaanjã bëebajimgui ajim anʉm. Mag warre am kach dʉ̈ʉ iekhapʉ̈iwia deeum phöbördamag ërëubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mag ërëubaadëwia agtha barba wënʉrrʉm ee, ãbmua Jesuug, —Señor, mʉʉn pʉ mampierr pʉ dʉ̈i ich jãg chitajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Magbaawai jũrr ich Jesuu irig, —Pʉchdëu mag mʉ dʉ̈i chitam khõsi chirʉm khai, marrau magan ajim anʉm. Mamʉ pʉrʉg jaaukhimgui ajim anʉm: mʉ khãyau pabʉ̈ eem nemchaain amach khãaijem jẽbdi paraam; nem ichpanjã kheeupaawai amach khãaijem khãidu wai sĩsidʉm. Mamʉ mʉch chi Emkhooi Iewaa chan mʉg chitʉm aig khëubaadeewai khãyaag ajapha werba chiraju didamjã chukhu chitʉmgui ajim anʉm. Pʉjã mʉjö magta chitam khõsi chirʉm khai, marrau magan ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Maimua ãbakhaíg jũrr ich garmuata —Marrau mʉ dʉ̈i abaawai, jũrr magua, —Señor, magan idëu nacha mʉ mʉch aai aar mawia i dʉ̈i chirʉʉ apibá. Mʉg atag mʉch juadamaucha jöoi aukhër pʉabajeen chadau mua pʉ ogdʉba chitajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Magbaawai Jesuu irig, —Magju khãai warre mʉ dʉ̈ita marrau ajim anʉm. Idëu ar amach Ẽwandam iek ʉ̈khamaaugau chi thõmjö nʉm khʉʉnag amach binaan bëppibá. Mamʉ pʉ mag khãyau warag õrag jaaubamí ajim anʉm: “Ya Ẽwandam thumaam khʉʉn Pörkhacheeg bëeimʉʉ sim. Pãar peerdʉm khõsi nʉm khai, ichta ʉdʉraa pãach Pörkhapibat” a jaaupet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Magbaawai deeum aig sĩerrau ĩchab irig magjim anʉm: —Señor, mʉjã pʉ dʉ̈i ogdʉba chitaju ĩchab. Mamʉ idëu nacha mʉch di aar mapibá ajim anʉm, mʉch di aig durrum khʉʉnag “ayoo keena” apʉ̈yaan. ");
INSERT INTO noaE_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Magbaa Jesuu magjim anʉm: —Chi mʉ dʉ̈i nʉrrʉm woun chan ag na ichdëu parhooba nem waaujerrjã agtha khĩirju nʉrraju aai khaba sim. Irua magju khĩirju chirʉm chan, pöd Ẽwandam athee nem ajapha waubamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mag jũrram khʉʉnau Jesús dʉ̈i ogdʉba wënʉrraju a thʉnarr khur maach Pör Jesuu ichdëucha õor setenta jʉr auwia khĩir sĩsied nunumdö pʉ̈yaagpajim aajem, ich na ich nʉrrajupierr. ");
INSERT INTO noaE_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mag am pʉ̈yaagpamua magjim anʉm: —Chadcha Ẽwandam i jaau nʉmʉn arrozdö pöm phur wëjömjöta phidag pöoma sim; mag simta chi jaau wënʉrraju khʉʉn chan khapan khaba durrumgui ajim anʉm. Magua mua pãragan, Ẽwandamag jëeubat a chirʉmgui ajim anʉm, warag ich i jaauju khʉʉn khapan jöphëecha ich i jawaan pʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Maimua magjim anʉm amag: —Ërëubaadët. Mamʉ pãadë ũrbat: Mua mʉg pãar pʉ̈i chirʉmʉn, õor khaibagkham eeta wënʉrraju aawai pãran oveja chaaindam khum nem thʉnʉm ee pʉakhʉʉibapʉ̈imjöta abarmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pãach jua kharr ërëubaadët: phatkhon chukhu, putdijã chukhu, maimua zapatdamjã pãach bʉ̈ gayam appai athaadët. Khʉdau ee õor oowaijã iyʉ̈ʉ dʉnʉnʉidʉ nʉʉ aba dichpetat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Parhooba pãach wëtumpierr õor deg duubwai saludaawia, “Maran maach peerdʉajem iek jawaanta bëejim; pãach mʉg di ãbam degam khʉʉnau thumaa ʉ̈khakhiin ʉ̈u akham” abat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pãrau mag jaau wënʉrrʉm ãbmua khãijã ʉ̈kham khõsi ʉ̈khamʉn, ʉ̈u peerdʉwia Ẽwandamau i auju. Mamʉ irua magbamʉn, magan Ẽwandamau mag woun eeg ooba, i dʉ̈i ʉ̈u aju atarr warag pãach dʉ̈ipaita ʉ̈u aju. ");
INSERT INTO noaE_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mag pãach ʉ̈u jẽerpibarm degpai thachjã khöbat, dipierr thach khö wënʉrraba. Mua pãrag mag chirʉmʉn, mag pãach phidkha wënʉrrʉm gaaimua õrau sĩi pãar jãogju aawaita mag chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Phöbör ee pãach dub wënʉrrʉmpierr pãach jẽer nʉm aiguim khʉʉnau nem deewai magʉmjã aba khöbat. ");
INSERT INTO noaE_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Maimua ĩchab magʉm phöbörpierr pãachdëu aaunaan oomam monaaupetat. Mag monaaupʉ̈iwia amag, “Pãrau ĩs mʉg oobarmʉn Ẽwandamauta pãrag ich jua theeg oopi sim” a jaaubat ajim anʉm ĩchab. ");
INSERT INTO noaE_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mamʉ phöbörpierr pãachdëu jaau wënʉrrʉm ũrmapha ni amach degjã pãach öbërpiba abaawai, kaaijã ee öbërnaa, pãach bʉ̈ gayam jẽb ʉʉrphë ʉʉrphënaa, amach khĩircha magbat: ");
INSERT INTO noaE_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pãrau Ẽwandam iek iseg nʉm khai, ni pãar phöbör eem jẽbdampaijã marau maach bʉ̈ gaai arrbam. Mamʉ ya pãrau khaphʉ nʉisim, Ẽwandamau pãach eejã ich jua theeg oopiju atarr oopiba abarm, pãachdëu i iseg nʉm gaaimua.” Magwia ërëubaadët ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mamʉ mua pãrag mag chirʉm: Mag pãachdëu jaau wënʉrrʉm gaaimua pãar isegbarm phöbör eem khʉʉnan, Ẽwandamau mʉg durr i agkham ed gaai Sodomapien khãyaujã ʉ̈rʉʉcha Ẽwandam jua machag ãwatjugui ajim anʉm, ich Jesuupai. ");
INSERT INTO noaE_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mag ich iek iseg nʉm khʉʉn igwia, ’¡Ë, apdurr Corazinpien! ajim anʉm. ¡Ë, apdurr Betsaidapienjã agjö, Ẽwandamau am i agkham ed! Am ee nem ooba aajem nem wau nʉmua Ẽwandamau ich juapá oopitarr Tiro phöbör eeta wa Sidón phöbör ee khãijã wautarr amuan, nawe amau amach khĩirjug khaigbam isegwia sʉrkhakham. Magtarr amuan, amau theerju theerwia ʉ̈r jupnaa, putiu pör börrnaa, khoopa nʉm khʉʉn sʉrkhaajemjö sʉrkhakham. Magnaa amau amach mor ewag ãsie khĩirjuwia Ẽwandamag jëeukhamgui ajim anʉm, amach khaibag chugpaamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Magua Ẽwandamau mʉg durr i agkham ed Corazinpienta Betsaidapien dʉ̈i irua masiicha waupʉ̈ijugui ajim anʉm am gaai, Tiropien dʉ̈i Sidonpien khãyaujã, amachdëu ũrtarrta ʉ̈khaba arr gaaimua. ");
INSERT INTO noaE_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Maagwai Capernaumpien igwiajã, ’¿Khan abarju? ajim anʉm. ¡Ë! Amaun amach thö nʉm, amachta chi wäjäaun awia. Amaun ʉ̈gthar paaukhabaimaawaijã amachta chi pörnaan khaimajupii nʉm. Mamʉ jãkhʉʉn chan Ẽwandamau ich aar öbeerpiba, warag khĩmie durrta barkhʉʉipʉ̈ijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Maimua mag ichdëu pʉ̈iju khʉʉnag magjim anʉm: ’Pãar iek ũrm khõsi ũr nʉm khʉʉnau magan mʉ iekta ũr nʉm ĩchab. Maagwai ar pãar isegbarm khʉʉnau magan mʉpata iseg nʉm. Mag amau mʉ iseg nʉm khai, magan amau mʉ Aaijã ĩchab dʉ̈i iseg nʉm, ichdëuta mʉ pʉ̈itarr aawai. Mag am wawikha wai sĩewian chadau khĩir sĩsied nunumdö wëtpi jaaubaa ërëubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mag ërëuwia, wënʉrrʉʉ athurwia, deeu bardʉtkhacheeu onee magchëjierram maach Pör Jesuug: —Señor, chadcha marau pʉ igwia puata maar pʉ̈ijim anaa mepeenagjã öbeerpi jaauwain sĩita magʉmjã aba, mepeenan öbërmaajeejimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Magbaawai Jesuu amag magjim aajem: —Pãrau mag öbeerpi jaauwai dösãt jua theeg chukhu sĩi jẽkhʉt phʉphʉrg petaphʉm mua khaphʉ chirajim. Jãguata irua mʉ ökhö sĩerrʉmgui ajim anʉm, ichdëu mʉ jua jʉmbaju khap. ");
INSERT INTO noaE_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mua pãar jua theeg apijim, pãach garmuata mepeen dajẽk amkhĩir. Maagwai mʉchdëu pãrag nem waupi jaau chirʉm wau wënʉrrʉmta dösãtau pãar nemkhõrig ʉmnaa döjũrigjã ʉmwiajã pãar bʉ̈ʉrjã chig abaju, mʉ jua theegta pãar gaai sĩewai. ");
INSERT INTO noaE_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mamʉ mag mepeenjã pãach garmuata jʉmpiba nʉm awiapai chan oob onee amiet. Magarrau pãach thʉ̈rta ya ʉ̈gtharm ẽsap gaai phã sĩsim gaaimuan chadau pãar onee aju aai nʉmgui ajim anʉm, ya pãach Ẽwandam aarcha öbërju aawai. ");
INSERT INTO noaE_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mag ich Jesuu pʉ̈itarr khʉʉn deeu bëewia ichig onee nem ĩgkhabaichëm ũrbaawai ĩchab ich Jesujã Ẽwandam Akharau onee apijim aajem. Mag ich onee aadeewai Ẽwandamag jëeumamua magjim anʉm: —Tata, mua pʉrʉg ʉ̈u ajim a chirʉm, pʉchta chadcha ʉ̈gtharm magwe nem thum mʉg wëjöm Pör aawai. Mʉ onee chirʉmgui ajim anʉm, õor amach khĩirjug khaug thöwia nem thum khaphʉm khaphʉm aajem khʉʉnaujã amach peerdʉju iek khaugba arrta jũrr pua khĩirjugdam meraa chaainjö khithëem khʉʉnagta ʉ̈u khaugpibaawai. Chadcha puata nem ajapha waaujem Tata ajim anʉm, pʉchdëu juau am dʉ̈i magju atarr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Maimua jũrr chi aig narr khʉʉnagta magjim anʉm: ’Nem thum mʉg thʉnʉmʉn mʉ Ayau mʉrʉgta deejim. Mamʉ ãbmuajã khaugba sim, khai agá mag Ẽwandam Iewaa. Ãba ich mʉ Ayaupaita khaphʉ simgui ajim anʉm, chadcha mʉ i chaairau. Mʉg nʉm aig ãbmuajã khaugba sim, khai agá mʉ Aai. Ãba mʉch chi Chaairaupaita mʉch Aai khaphʉ chitʉm. Bigaaum khʉʉnau khaphʉ aju awiajã mʉchdëu jaaubarm khʉʉnaupaita ĩchab i khaphʉ aju aai nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Maimua amach ap pawia ich khapeenag eerpa eerpanaa amag, ’Onee abat ajim anʉm, pãach jʉ̈gʉucha mʉ iek ũr nʉm khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Cha mua nem wau chitʉm pãrau pãach daujãau oo nʉmjö, warrgarwe Ẽwandam i jaaumienau reinaan dʉ̈imua amach daúacha oom iigjeejim, mamʉ pöd oobajierram. Amach jʉ̈gʉucha pãrau ũr nʉmjö ũrm iigjeejim, mamʉ pöd ũrbajierram. Mamʉ pãrau magba pãach daúacha oonaa pãach kachiucha ũr nʉm. Magua mua pãrag “Onee abat” a chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Maimua biek ãb Jesuu õor khapan thʉnʉmʉg jaau sim aig, chi Moiseeu phã pʉatarr iek jawaag athee chi machnaan eem ãb phiidʉbaadëwia sĩi i imeraa pʉr awaagpai irig magchëjim anʉm: —Maestro, mʉrʉg jaaubá ajim anʉm. ¿Mua jãgata aju aai chirʉ́ ʉ̈gtharcha öbëraag? ");
INSERT INTO noaE_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Magbaawai jũrr Jesuu irig, —¿Khan a phã sĩ Ẽwandamau ich iek jöoingarwe Moiseeg phãpitarr gaai? ¿Pua ag gaai thʉ̈rba aajẽ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Magbaawai mag chi charrkha chirʉmua magjim anʉm: —Moiseeu Ẽwandam iek phãtarr gaai, “Maach Pör Ẽwandam sĩi par iiupai khaba, pʉch thãrauchata khõsi abá” a sim; maimua ĩchab, “Pʉch khapeenjã agjö agdaujöo kha khõsinaa daupii abá, pʉchjö wir aig” a phã simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Magbaa Jesuu irig, —Ëera, chadcha pua ich ag eyaa jaaubapʉ̈imkë ajim anʉm. Cha pʉchdëu khaphʉ jaau chirʉmjö abamí pʉch khapeen dʉ̈ijã. Pua chadcha thumaam khʉʉn dʉ̈i magmʉn, pʉ ʉ̈gthar öbërjugui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Magbaawai chi charrkha chirʉmua sëukha ichdëu khaugba chirʉm awia deeu, —¿Chijã khʉʉn agáma ajim anʉm mʉ khapeen mag mua daupii aju khʉʉn? ");
INSERT INTO noaE_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Magbaawai Jesuu irig, —Mʉ iek ũrbá, mua pʉrʉg jaaukhimgui ajim anʉm: Woun ãb Jerusalenmua Jericoog khʉdau ma sim ee maa ajim aajem. Mag i ma khitʉmta nem jĩgmien khapan öbërdʉtkhachëwia, i nemdam thum khechthʉgnaa, i mor gayam khajũadampa ẽer auwia, warag phãr wai nʉmua chi meemjö aadeewai sĩi barpʉajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mag chi meemjö jẽer khërʉm ee, ich ag khʉdau eepai phad maa ajim aajem. Mamʉ ichdëu mag oo athaimaawai sĩi warag agʉg oobamjö dichjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Maimua ag khur nʉʉpai awia, deeu ich ag khʉd eepai majim aajem, Levinaan a thʉ̈ʉrjem khʉʉn eem ãb phadnaan dʉ̈i phidkha nʉmua am juag oojem. Mamʉ maguajã i dakha bëenaa, sĩi eerpapet awia, warag oobamjö ich mag petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Maimua mag warm khʉʉn ërëu dichtarr ẽudee agjö maa ajim aajem Samariapierrdam, ich ag khʉd eepai. (Samariapien judionaan dʉ̈in agdaujö jũrr chikham kha khõchkhaba aajeejim. Mamʉ maagjerrta magʉmjã igba,) maguan chadau ichdëu mag oobaimaawai, “Ë, ¿jãan chijãg woundamta jãg dau aphʉʉ jẽer khërʉm?” awia, warag aar mawia, ich athee nemkhau pabʉ̈ olivo anʉm dën vinodampa wai nʉrrarrau bënhëkha i mor mag pepethor sĩsidʉm ee phuurkhanaa, put ee pʉrëunaa, ich cabaai gaai athaadëjim anʉm, ich dʉ̈i ãba. Mag arrwia, õor jẽerjem deg ag dʉ̈i sĩeimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Maimua ag noram ãspaau ya ich ma nʉrrʉmua denariodam numí chi dikhʉʉg werpʉawia magjim anʉm: “Mʉg woundam ajapha oo wai chirsí. Pua i monaau aum khõchgau cha murua phatkhon werpʉabajëm ʉ̈r khãijã werbamʉn, oob khĩirjum” ajim anʉm. “Mʉch bëewai, chi waaurbarm thum mua deeu pʉrʉg phagchëjugui” ajim anʉm. Mag jaau pʉawia petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mag ĩgkha aaipawia, ich Jesuupai mag Ẽwandam i jawaag chi charrkha chirʉmʉg jëeujim aajem: —Pua khĩirjuawai ¿chijãata mag woundam ich appai ma khitʉm ee khapanaam khʉʉnau pʉrnaa mas deetarr ag khapeer aju ayaa sĩ: chi phad, chi Levinaan eem, wa chi Samariapierrdam? ");
INSERT INTO noaE_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Magbaawai ichdëu, —Chi mag jẽer khërʉm oobaimaawai i dau aug khaugtarrma ajim anʉm. Magbaawai Jesuu irig, —Magan mawia i dënjö pʉch oomapham khʉʉn awia khãijã daupii abá ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Maigmua igbaadeeu ich khapeen dʉ̈i ãba mamua deeum phöbördam pöm khaba khitʉm ee barwia ʉʉi ãb Marta anʉm di aig jẽerimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mag Marta anʉm eeum María a thʉ̈r sim sĩejim aajem, i dʉ̈i khod ãbam. Mag María bëewi sĩi Jesús dakha i iekha simpai ũr oo sĩsijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Magʉmich Marta khʉrr igaau jua dʉ̈rrjã khaba thʉnaajim anʉm, õor thum jãogaag ich appaimua phiejãb waauwai. Mag ich jua dʉ̈rr khaba aawai Jesús aig bëewia magchëjim anʉm: —Señor, ¿pua oowai ʉ̈u sĩ, mʉg mʉ jua dʉ̈rr khaba thʉnʉm ee sĩi Mariaau jãg pʉ iekha simpai ũr oo sĩeju? Jãg pua irig jaaubá ajim anʉm, mʉ juag oon mamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Magbaawai Jesuu irig, —Marta, chadcha pʉ jua dʉ̈rr khaba thʉnʉm mua khaphʉ chirʉmgui ajim anʉm. Ajapha õor jãog aum khõchgau pʉ khĩirjugan nem thumaa wauju appaita khĩirju buburrkham. ");
INSERT INTO noaE_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mamʉ sĩi dich bi atheepai nem thum wauju khĩirjuba awiajã ʉ̈u sim. Mariaau pʉ khãyau ajapcha abarm. Jãg sim aig irua Ẽwandam iek ũrm khõchgauta pʉ juagjã ooba abarm. Maagwai mua pöd irig ũrpiba jaauju aai khaba chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Biek ãb Jesús ich Ayag jëeu sĩejim aajem. Mag jëeu aaipabaadeewai ich khapeen eem ãbmua irig, —Señor, jãg Juanau ich dʉ̈i wënʉrrʉm khʉʉnag Ẽwandamag jëeu nʉm jaautarrjö, magan maragjã agjö jaaubá ajim anʉm, maraujã ĩchab irig jëeu khaphʉ aag. ");
INSERT INTO noaE_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Magbaawai ichdëu amag magjim aajem: —Pãach Ẽwandamag jëeuwai magbat: “Ẽwandam, pʉʉta maar Aai ʉ̈gthar chiraajemʉu. Pʉch appaita chadcha pekau chukhu chitʉm. Pʉrʉgta marau maach dʉ̈i pʉchdëu ampierr apinaa pʉchta thumaam khʉʉn Pörkhapim khõsi nʉm. Ʉ̈gtharjã jãg pʉchdëu nem waupi jaau nʉm appai waaujemjö, mʉg jẽb gaaijã thum pʉchdëu jaau simjöta apim khõsi nʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ed ëepierr pua marag khöjudam deebarju. Ẽwandam, maar pekau thum chugpaabapʉ̈i, ");
INSERT INTO noaE_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","maimua ar marau maach dʉ̈i khaigba abarm khʉʉn dʉ̈i tag magʉm iek igba ich mag khĩir okhoopäaijemjö maar dënjã khĩir okhoobapʉ̈i. Oob pua ʉdʉraa chan maar pekau ee burrpi chiram. Mag khãyau warag maar thʉa wai chirsí, phithurg chukhu dösãtau maar ichig paa aum ugua” a jëeubat a jaaujim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mag jaau dichwia jãga Ẽwandamag jëeuju aai nʉm a khap amkhĩir ĩchab amag magjim anʉm: ’Khanim nemjö pʉ pʉch khapkhʉʉn ajapham wai chirʉm. Maimua ya edacha pam ee i aar mawia pua irig, ");
INSERT INTO noaE_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Kakë, mʉ aig mʉ khapkhʉʉndam barbaichëmʉg nemdam deejujã chukhu chiraawai pʉ aig thachdam jëeu awaan bëejim” aimaawai, ");
INSERT INTO noaE_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","irua ierrmua jũrr pʉrʉg, “Idëu mʉ khajapha khãaipibá. Ya mʉ put ee chirʉm; mʉ chaainjã ya khãidʉtkha thʉnaawai pöd mʉ pʉ aar puertdi wewaanjã mabam; pʉ nem ig sim pöd mua deepʉ̈ibam” akhiin, ¿jãgaju khai? ");
INSERT INTO noaE_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mua oowai chan warmua mag iekhawiajã chadcha irua ichdëu nem jëeu sim ig sim khai, ichiita irua warag pʉaba jëjëeu aju. Mag jëjëeukham, ¿jãga mag phiidʉwia irua au deeba abarju? Ichiita i phiidʉjugui ajim anʉm. Mamʉ mag ich khapkhʉʉnau nem ig sim awia khabam. I phiidʉjuun, sĩi idëu ich khãaipiba aawaita irua nem ig sim au deen phiidʉju. ");
INSERT INTO noaE_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ich jãgta aajemgui ajim anʉm agjö Ẽwandamag jëeuwaijã. Magua mua pãragjã pʉaba jëeubat a chirʉm. Magta pʉaba jëeu nʉmʉn, pãachdëu nem igbarm irua deeju. Pãrau i jʉrmʉn, i baauju. I sim aar dubaag pãach weeu aupi jëeumʉn, irua pãar weeu auju. ");
INSERT INTO noaE_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pãrau khaphʉ nʉmgui ajim anʉm, ar õor nem jëeu paraam khʉʉnagan nem deeb khaba deejem. Ar amachdëu nem inag ig nʉm pʉaba jʉr nʉm khʉʉnau baaujem. Maagwai ĩchab chi puertdi sirbaichëm khʉjã weeu auwia dubpiejem. ");
INSERT INTO noaE_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Khaíuta mʉg sim aig ich chaairau thach jëeubaa mokdauta phëdeeju khai? ¿Wa ãwarr khãijã chaairau jëeubaawai ãwarr deeju khãyau nemkhõrta thõo deeju khai? ");
INSERT INTO noaE_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wa magba, ¿nemhãudam khãijã jëeubaawai nemhãu awia döjũrta au deeju khai? Ni ãbmuajã magbamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pãar ö ãkhãraa khithëem khʉʉnaujã pãach chaainau nem jëeuwai ¿nem ajaphamjã ĩgkhaba deeba aajẽ? Ich jãgta aajemgui ajim anʉm maach Aai ʉ̈gthar chiraajemuajã agjö. Chadcha thãrau ichig jëeu simʉgan irua ich Akhaarjã deeb khaba deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Biek ãb Jesuu woun mor ee bën khaigbam wai sim monaau sĩejim aajem. Mag bënëu chi woun pödjã iekhapiba sĩi ichʉp wai sĩejeejim anaabá. Mamʉ Jesuu chi bën öbeerbapʉ̈im bʉ̈rre chi woun deeu iek eerdʉ sĩsiewai iyʉ̈ʉ aadëjim anʉm. Mag oowi thumaam khʉʉn dauderraa naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mamʉ ãaur khʉʉn dʉ̈i aig oo narr khʉʉnau, —Jãg Jesuun dösãtnaan pör Beelzebú dʉ̈i bën dötarr aawai ag juapaauta jãg õor mor eem mepeenjã dau daau jʉrkhʉʉi nʉrraajemgui anaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Magbaa jũrr ãaur khʉʉnau amach ödegpai, “Daau chadcha irua Ẽwandam juapá wai chirʉm khai, deeum nemjã ompaa athaju” awia irig, —Magan chadcha pʉchta Ẽwandamau pʉ̈iju aajerr chaar khai, edjã ee maadëu nem ooba aajem ompaa athá pʉch iekhau ajierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mamʉ magbaa ichdëu amau khĩirju nʉm ajapha khaphʉ sĩerr aawai amag magjim anʉm: —Pãrau oowai, gobiernoou ich igar nʉm khʉʉn jãrrcha thöonaa amach wir aigpai wërbʉpikhiin, ¿mag gobierno warre khʉt mabaju khai? ajim anʉm. Jöoi ãb simua khãijã ich chaain dʉ̈ipai meeukhawia amach wir aigpai wërbʉkhiin, warag aaidʉjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ich magta aju agjö dösãtjã. Ich khapeen dʉ̈ipai wir aig wërbʉ nʉmua amach öpʉ̈pʉ̈i amʉn, pöd ich mag jua theeg khaba sĩerraju, amachdëupai amach khëchmaawai. Pãar iek mag mua dösãtnaan pör Beelzebú juapaauta mepeenjã õor mor eem jʉrkhʉʉi chirʉm anʉm, ");
INSERT INTO noaE_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","chadcha Beelzebú ag juapaauta mua bën khaigbamjã jʉrkhʉʉi chitʉm khai, magan ar pãach eepaim khʉʉnaujã agjö i juapaauta mepeen jʉr wërp nʉm. Mag nʉmta ¿jãgwia pãrau makhʉʉnag chan bʉ̈ʉrjã magʉm aba nʉ? ajim anʉm. ¿Chadcha ich Ẽwandamauta amag magamkhĩir ich juapá dee sim pãachdëu khaphʉ naawai khabá? Pãar iek mag chi dösãtaupaita wir aig ich khaibag waaujem anʉpí, magan jãg chi mʉ dënjö dau daau mepeen jʉr wërp nʉm khʉʉnagchata jëeu oobat daau amau chadcha dösãt juapaauta jãg jʉr wërp nʉm abarju pãrag. Pãach chi mʉrʉg mag iekha nʉm khʉʉnta ag eyaajã khaba iekha naabahab. ");
INSERT INTO noaE_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Muan chadcha Ẽwandam jua theegauta mepeenjã jãg jʉr wërp chitʉm. Mag mepeenjã mua jʉr wërp chirʉm gaaimua pãrau khaphʉ aju aai nʉm, ya ich Ẽwandam chi jua thierrta pãar ee sĩeichëm. Mamʉ magʉmjã pãrau khaugba nʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Dösãtan woun ãb chi jua thierrta jierrnem dʉ̈i ajap khĩir khaugwia ich di thʉa simjöta sĩerrʉmgui ajim anʉm, nem jua theeg. Mag sĩewaita, i khãyau jua eegpaimua chan i sim aig i nem bʉ̈ʉrjã chig abam, ich jua ee thʉnaawai. ");
INSERT INTO noaE_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mamʉ ãb i khãyau thethecharamua bëewi, i dʉ̈i wërbʉwia i pödbapäaiwain chadau, irua ich jierrnem thö chirarr thum khechthʉg auwia i juagam nemjã jũrr ich dënkha auju, ag dʉ̈i ichdëu ampierr aag. Magua mʉʉta dösãt khãai jua theeg chiraawai muata õor eem mepeenjã jʉr wërpju aai chirʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Magua mua mag chirʉmgui ajim anʉm: Ar chi mʉ igar khaba sim woun ichta dösãt igar sim; maimua Ẽwandam iek ʉ̈khapi awaag mʉ ipierr õor ãbamʉg jʉr phëba simuan waragta jʉr wërp simjö simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Bën khaigbam õor mor eemua jʉrpäaiwain warp õor chukag ee phʉrëu nʉrraajem. Mamʉ pöd ich sĩeimaju baauba abaawai khĩirju sĩi awia, “Deeu mʉch chiraajerr deg chiraimaag majugui” awia, deeu ich ag woun jʉrmaajem. ");
INSERT INTO noaE_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mag mawia ooimaawai, chadcha di chaarta ajap thũapwia ãbamʉg nem phëwia ãkha thʉnʉmjö, dijã parii ooimaajem. ");
INSERT INTO noaE_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mag dijã parii oobaimaawai, deeu mawia, ich daumaai ich khapeen ich khãyau khaigbacharam khʉʉn siete jʉr auwia, deeu mag woun mor ee naaicheejem. Magbarm aigmua chi wounjã warr ich sĩerr khãyau warag athuucha khaigba sĩsiejem. ");
INSERT INTO noaE_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús mag iekha sim ee, ʉʉi ãbmua khapanag eemua irig, —Pʉ thaabawia ich jũd gaai pʉ döpi bãautarr ʉʉita Ẽwandamau ʉ̈ucha ajim chadcha. Dich chaaita jãg khitakhiin maach onee khitajugui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Magbaawai jũrr ichdëu, —Jãan chadaugui ajim anʉm, mamʉ mag khãyau ar Ẽwandam iek jaau nʉm ũrwia i ipierraa nʉm khʉʉnta ʉ̈rʉʉcha onee aju aai nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Warag õor pöm ich aig phẽeudʉdʉkham ee, Jesuu amag iekhamamua magjim aajem: —Ĩsim khʉʉn chan warag chi ajaugjã chukhuta thʉnʉm. Oo nʉmjömta warágata amachdëu nem ooba aajempata khĩirpierr ompaa aupi jaau nʉm. Mamʉ mua pãar ipierraa nem waubamgui ajim anʉm. Mag khãyau Ẽwandamau Jonás dʉ̈i arrjö abarm gaaimuata mʉch jua theeg oopiju. ");
INSERT INTO noaE_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Warrgar jöoi Jonás aajerr nemmeeurrkhan buch ee khãai thãrjup sĩethurtarr gaaimua Nínivepienau Ẽwandamau i pʉ̈itarr khaug autarrjö ĩchab, mʉch chi Emkhooi Iewaaujã agjö mʉch iiu phiidʉbarm gaaimuata pãrag khap apiju, chadcha ich Ẽwandamauta mʉ pʉ̈ibarm. Mamʉ magʉmjã pãrau ʉ̈khabajugui ajim anʉm ichdëupai. ");
INSERT INTO noaE_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Magua, ar ĩs mʉg jaar õor mee nʉm khʉʉn Ẽwandamau mʉg atag am phiriutkha auwia chachbarm jaar, Sabá anʉm durrmua rey Salomón oon bëetarr ʉʉiraujã ich ipaarmua ĩchab pãar khaibagta Ẽwandamag ĩgkha thʉnʉʉuju. ¿Jãgwi? Í pãar khãaijã warpmuata Ẽwandamau rey Salomonag khĩirjug deetarr iekha sim ũraan bëetarr aawaima. Mag khãai pãar wir aig nʉm khʉʉnau mʉ Salomón khãaijã ʉ̈rʉʉcha chirʉm iekta ũrmapha nʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mag Ẽwandamau õor i agkhabarm ed Nínivepienaujã ĩchab amach ipaarmua pãar khaibagta warag Ẽwandamag ĩgkha thʉnʉʉuju. ¿Jãgwi? Jonaau Ẽwandam iek amach aar jaaubaimaawai amau magʉmjã aba ʉ̈khatarr aawaima. Mamʉ ĩs mʉ Jonás khãyaujã ʉ̈rʉʉcha chirʉmuata Ẽwandam iek jaau chitʉmjã pãrau ʉ̈khamapha nʉmgui ajim anʉm, amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Maimua mag jajawagmamua ich Jesuupai, ’Mua mag õtdau paanaa sĩi ag ʉ̈r bathẽeu khöo sĩu nʉm ooba chitʉmgui ajim anʉm. Õtdaun paanaa õor dau garta ausĩiujem, thumaam khʉʉn dau araraa amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Maach daun õtdaujöta simgui ajim anʉm, maach mor gaai. Maach daujãata ajapha sim aiguin nem thum dawaata oojem. Ich agjöta simgui ajim anʉm maach thãarjã. Ẽwandam iek ʉ̈khanaa maach thãarta ajapha sim aiguin nem thum Ẽwandamau khõsimjöta waaujem. Mag nʉm aiguin ararag ee nʉmjöta nʉm. Mamʉ magba agtha pãach pekau eeta nʉmʉn magan pãran sĩi khĩchag ee jʉrkha jʉrkha nʉmjöta nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Magua khĩirjug paraa aajeet. Khĩchag ee nʉmjö nʉmta pãach thãar ajapha nʉm awi oob Ẽwandamag pãach isegpimiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mamʉ pekau gaaimua khĩchag ee khaba nʉmjö nʉm khai, magan chadcha pãar ararag chaar eeta nʉm, Ẽwandam dʉ̈i. Mag amʉn magan õtdaúa pãar khĩirphee wʉʉ wai nʉm bʉ̈ʉg nʉmjöta nʉmgui ajim anʉm, i dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mag ich Jesús iekha öbaadëm ee, ãb Moiseeg Ẽwandamau ich iek phãpitarr ajapcha ʉʉrkhaajem khʉʉn eemua i thach khoon ëeurrjim aajem, ich di aar. Magbaawai Jesuu i dʉ̈i mawia, barwia, ãba phʉʉr khöphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mamʉ mag chi Jesús ëeurrtarr wounau oowai Jesús jua ʉbata thach khöbaadëjim anaabá. Magbaa ich ödegpai, “Waa, idëu maach jöoinau jaaujem khaugbamjö jua sũgbata thach khö chitabaa” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mamʉ maach Pör Jesuu mag wounau ich ödeg mag simjã khaphʉ sĩerr aawai irig, —Mʉ iek ũrbá ajim anʉm irig. Pãar fariseonaanan pãach pem aawai sĩi juagam nem chi ʉ̈rʉm memerkhögpaita ajapha ʉkhakha aju khĩirju sĩerrjëemgui ajim anʉm, mag memerkhöm ee khãijã döbaawai Ẽwandam dau na pekau waumaaugau awi. Mamʉ pãachdëu chikham nemdamjã jĩgkha pãach dënkha aunaa chikham khaibag wau nʉm gaaimua pekau pöm nʉm chan isegba ni Ẽwandamag chugpaapi jëeujujã khĩirjuba sĩerrjëemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pãar chi khaphʉm khaphʉm aajem khʉʉnta, ¿jãga jãg khĩirjug chukhumjöta nʉma? ajim anʉm. ¿Pãrau khĩirjuawai Ẽwandamau ʉ̈rʉm nempai oonaa pöd pãar thãar ooba aajẽ, mor ee ierr sĩewai? ¿Nem thum ichdëupai wautarr khabá? ");
INSERT INTO noaE_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nem ajapha jã ʉkhakha aju khãyau, pãach khaibagta Ẽwandamag chugpaapi jëeubat ajim anʉm. Mag pãar morjã thum ajapha nem jã ʉkha thʉnʉisimjö sĩsiewain chadau aphʉʉm khʉʉnagjã nem deem khõsi deeju. ");
INSERT INTO noaE_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mamʉ ¡ë, apdurr ajim anʉm pãar, fariseonaan, Ẽwandamau Moiseeg ich iek phãpitarr iek ajapcha ʉʉrkhaajem aajem khʉʉn! Pãrau chadcha Moiseeu deepi jaautarrjö thum pãach di ũjãrram nemjĩirdam bʉ̈ daiicharam gayampa Ẽwandamag ofrendakha deejem. Mag naab mamʉ, jũrr wir aig pãach khapeen dʉ̈i agpierraanaa Ẽwandamjã khõsi aju chan bʉ̈ʉrjã khĩirjuba sĩerrjëemgui ajim anʉm. Pãrau ʉ̈rcha Ẽwandamta khõsi aju aai nʉmgui ajim anaabá. Magnaan chadau pãachdëu nem dee nʉmjã ich jãg dee wënʉrraju aai nʉmgui ajim anʉm ĩchab. ");
INSERT INTO noaE_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Magnaa amag, Pãran pãach Ẽwandam iek jaaujem deg weetwaijã pãachta pörgarcha thumaam khʉʉnag khĩir jʉrkha juupjerram, pãachta ajapcha nʉm awia. Maimua kaaijã ee weetwaijã thumaam khʉʉnau pãachig saludaa nʉmua pãach thö iekhapim khõsi sĩerrjëemgui ajim anʉm, õor dakhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ë! Pãarjã agjö chi machnaan dʉ̈i Moiseeu phãtarr iek ajapcha ʉʉrkhaajem aajem khʉʉn. Pãrau khaphʉ nʉm, maach meeun ee nawe õor aukhërtarr jẽbdi ʉ̈r dichpiba aajem. Khaugba dichwiajã ichiita maach ãarjem aajem. Ich jãg jẽbdi õor ãrpiejemjöta naabahab ajim anʉm, pãarjã. Pãachdëu nem jaau nʉm gaaimuata agjö õor Ẽwandam dau na ãrpi naabahab, mamʉ magʉmta amau khaugba durrumgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Magbaa chi machnaanpa aig narr aawai ãbmua ũr oo sĩi awia Jesuug magjim anʉm: —Maestro, pua warm khʉʉnag mag iekhabapʉ̈im aig, ĩchab maar khĩirpata iekhabapʉ̈ibahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Magbaa Jesuu irig, —Chadma ajim anʉm. Mamʉ ¡ë, apdurr, pãar chi machnaan ãba! Pãrau chará pãachta chi khaphʉm awia pãachdëu nem jaaum aig jaaujem. Jãg nʉm aig pãrau õor ʉ̈r nem chʉkhʉm jiirpʉ̈pʉ̈ikhamjöta naabahab ajim anʉm. Pãach garmuan pãrau õrag nem jaauwai pãach ipierraata api nʉm. Mamʉ mag nʉm pãachdëu chan waujöjöopaijã khaba aajemgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ë, magʉm pãar chará! Pãar jöoinauta warrgarwe Ẽwandam i jaaujerr khʉʉnjã khëchbajieb ajim anʉm. Pãachdëucha khabajim, mamʉ pãar ya ĩs ewagam khʉʉn awia bʉ̈ʉrjã khĩethuupaijã khaba nʉmgui ajim anʉm. Amau bëptarr jã ʉ̈rjã pãar dën ajapha phʉnaa ooimʉ wau khër nʉmua pãach iiupain pãrau, “Mʉkhʉʉn jöointa chadcha Ẽwandam i jaaujerr khʉʉnau” aajem. ");
INSERT INTO noaE_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mamʉ mua pãrag jaaukhimgui ajim anʉm: Jãg nʉm aig pãrau, “Oobat Ẽwandam i jaaumien maar jöoinau khëchtarr. Mʉʉgwaijã agtha ich jãg wënʉrrʉm akhiin, maraujã agjö khëchju nʉm” a jaau nʉm khabahab ajim anʉm. Magaagta pãar dën warag am jã ʉ̈rjã nem ooimʉ waunaa sirppapiba aba aajeeb ajim anʉm, pãachdëu khëchbajim awia. ");
INSERT INTO noaE_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jãgju khaphʉta Ẽwandamau ich khĩirjug ee ĩchab magjim: “Mua pãar athee õor pʉ̈iju, mʉch i jaau wënʉrramkhĩir. Mag mua jʉr auwia pʉ̈ibarm khʉʉn ãaur khʉʉn khëchpʉ̈iwia ãaur khʉʉn ẽudee sĩi khoojem nem ẽudeemjö ẽkhaju” a jaaujim warrgarwe. Magtarr aawai ĩs ewag pawiajã chadcha pãar ich magta thʉnaabahab. Magua pãadë mʉ iek ũrbat ajim anʉm: ");
INSERT INTO noaE_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ar warrcha mʉg jẽb ich Ẽwandamau ompaatarr aigmua ewag i iek jaau durraajerr khʉʉn khëch nʉm aig bag ãrtarr thum, jũrr ich Ẽwandamau pãar ĩs ewagam khʉʉn gaaita thʉpʉ̈ijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Warrcha Abel thõotarr ed bag ãrtarr aigmua ewagjã khĩeb jöoi Zacarías khararr Aai i jëeujem deg thõo naawai ãrtarr bagpa thum pãach gaaita pajugui ajim anaabá. Jã chan par okhoobam, ichiita Ẽwandamau pãrag jëeub khaba jëeujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mag iekhakhagmamua, ¡Ë, apdurr ajim anʉm pãar, Ẽwandam iek jawaag chi machnaan aajem khʉʉnta! Pãrau khaphʉ nʉmgui ajim anʉm, Ẽwandam iekta ʉ̈gthar dubaag athee yabmejö sim. Mag yabmejö simta pãachdëuta nacha garpawia bʉ̈ʉrjã õrag jaauba nʉmgui ajim anaabá. Pãachjã dubba nʉmta, chi dubam khõsi nʉm khʉʉnagjã pãrau ʉdʉʉr dubpiba nʉmgui ajim anʉm, amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesuu amachig magbaawai, amach chi machnaan fariseonaanpa i dʉ̈i meeukha phöbaadëjim aajem. Maimua warag i dʉ̈i wëtumua i thʉ awaag a i aig phẽeudʉ bëenaa, jũrram khʉʉnau amachdëu khaphʉm irig jëeuphöbaadëjim anaabá, ");
INSERT INTO noaE_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mag amachdëu jëeu nʉm jũrr ich Jesuu ipeerdʉ khãijã jaaubapäaiwai magʉm gaaimua chi thethem khʉʉnag i pʉr deeg. ");
INSERT INTO noaE_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mag nʉm ee warag õor pöoma phẽeudʉdʉkhamua jũrr chikhaman bʉ̈pa khiuthʉgmaajeejim anʉm. Am mamagkham ee, Jesuu ich khapeen ich dʉ̈icha ogdʉba wënʉrraajerr khʉʉnag magjim anʉm: —Khĩir khaphʉ wënʉrrathʉ̈; oob fariseonaan bën levadurajö sim pãach gaai dʉrbapimiet. Mua mag chirʉm aiguin pãrag, “Oob amjö chikham khĩir aawaipaita chadam iekjö iekhanaa pãach ap aadeewai jũrr pãachdëu jaaujemjö khaba nem waumiet” a chirʉmʉugui ajim anʉm. Pãrau am igar phũrrbamʉn, pãach gaai dʉrbabaadeewai sĩi amjö nʉisijugui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mʉg jẽb gaai aawai meraa iekhatarr iek khãijã mʉg atag paawai sĩi ich mag sĩsiwia khĩir akhoog khabam. Maagwai nem meraa wautarr awia khãijã ich mag khaugba sĩsibajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Magnaa ichdëupai, Mua pãrag mag chirʉmgui ajim anʉm: Ar pãrau pãach appai meraa iekhabarm iek mʉg atag paawai jũrr thumaam khʉʉnau khakhapdö ajugui ajim anʉm. Maimua agjö khaugbaju awia puertdi khãijã ajap phãarkhanaa ö sausau iekhatarr iekjã thumaam khʉʉn jʉ̈g daar jũrr khapanag ee thet jaaujugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mag ich khapeenag jajawagmamua ĩchab ich Jesuupai, ’Keena, ar sĩi mʉg amach wir aig chikham kheechjem khʉʉn oob ögkhamiet ajim anʉm. Amau pãar chi ʉ̈rʉmʉn chadcha khëchpʉ̈iwiajã pãar akhaar chan pöd thõo aubamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mamʉ ĩchab mua pãrag jaaukhim, khaita pãrau ökhö aju aai nʉ: Ẽwandamta ökhö abat ajim anʉm. Jãan chad nem jua theeg sim, pãar thõowia pãar akhaarjã khĩmie durr barpʉ̈yaag a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Pãrau oowai phatkhondam pöm khabamua nemchaaindam cinco për auba aajẽ? Erraam gaai mag am përpʉ̈imaajeeb mamʉ, ich Ẽwandamau chan am chigjã aba, ajaphata oo phë wai sĩejem. ");
INSERT INTO noaE_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maagwai oob khĩirjumiet ajim anʉm. Pãar chará nemchaain khãyaujã ʉ̈rʉʉcha irua iigjem. Mag pãachta nemchaain khãyaujã ajapcha nʉm gaaimua, pãar pörbʉ̈ maadëu igbaju ayaa sim khapanagjã irua thum khaphʉ wai simgui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mag jajawagmamua ich Jesuupai magjim anʉm: ’Ar õrau ichig jëeuwai ich imeerba mʉ iek ʉ̈khaajem a jaau sim wounan, mʉg mʉch chi Emkhooi Iewaaujã ĩchab ʉ̈gthar Ẽwandam chognaan thʉnʉm dakhĩir, “Jãan chadcha mʉ garmʉu” ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mamʉ ar õrau ichig jëeuwai khãijã, “Mʉ chan i igarm khabam” a sim wounan, muajã ĩchab ʉ̈gthar Ẽwandam chognaan thʉnʉm dakhĩir ich khĩircha, “Jã chan mʉ dën khabam, mua i khaugba chitʉm” ajugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Amach mʉg jẽb gaai nʉweran amau mʉch chi Emkhooi Iewaa igwia khaigba iekhawiajã amach khaibag Ẽwandamag chugpaapi jëeubaawai ʉ̈u chugpaapʉ̈iju. Mamʉ pekau ãb simgui ajim anʉm, maan mua Ẽwandam Akhaar jua theegau nem wau chitʉm oo nʉmta warag mepeer gaai thʉ nʉmʉu. Mag pekau chan Ẽwandamau bʉ̈ʉrjã khĩir okhoobamgui ajim anʉm, i Akhaar igwiata mag iekha naawai. ");
INSERT INTO noaE_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pãachdëu mʉ iek ʉ̈kha nʉm gaaimua õrau pãach pʉr auwia, pãar khĩir sëukha iekhaag judionaan Ẽwandam iek jaaujem deg arrwia, chi thethem khʉʉn aarjã arrwai, oob “¿Jãgata mua iekhaagau?” wa pʉchig iekhabaawai, “¿Khan ata mua amag iekhaju?” a khĩirjumiet. ");
INSERT INTO noaE_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ya pãar iekhaagpaawai ich Ẽwandam Akharauchata pãrag khĩirjug deejugui ajim anʉm, khĩirjug khaphʉ iekhamamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jesús mag ijẽjẽbkham ee, ãbmua khapanag eemua irig, —Maestro, mʉ naamʉg jigpi jaaubá ajim anʉm, mʉ aai juagam nem pʉatarr eem mʉrʉg agjö jãrrcha deemkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Magbaawai Jesuu irig, —¿Khaíu pʉrʉg jaauwai, muata magʉm nemjã chi thethem khʉʉn dënjö jigpi jaauju aai chirʉm ajĩ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Maimua ĩchab thum aig narr khʉʉnagpa magjim anʉm: —Khĩirjug paraa aajeet. Oob pãrau sĩi nem khĩir thum paarpaju appaita khĩirjumiet ajim anʉm. Pãrau nem thum wai naawia khãijã pãar ëu meebamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mag jaaupʉ̈pʉ̈igmamua ĩchab amag mʉg nem ĩgkhaadam jaaujim aajem: ’Woun ãb phatkhon paraam sĩerrau nem jĩirjim aajem. Mag ich nem jĩirtarr thum eeuwia deg paa auwia oowai chi ãkhaajem di dʉ̈rr khaba thʉnaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Magbaawai khĩirju oo sĩi awia ich wir aigpai, “¿Mua jãgata abarkhiina?” ajim anʉm, “ya mʉg mʉ nem ãkhaajem dijã phẽu thʉnʉm.” ");
INSERT INTO noaE_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mag khĩirju oo sĩi awiata, “Ãa” ajim anʉm ich appai. “Jãgan mua mʉch khöju nem ãkhaajem di jãg thʉnʉm thu wërppʉ̈iwia deeumta jũrr nem dapag ëukha aujugui” ajim anʉm, “khoojem nemjã thum dʉ̈rr awia juagam nempa thum ãba dʉ̈rr amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ya mag ëu aaipagkhanaa ãba paa thʉnʉisiewain chadau sĩi año khapan phithurg chukhu ag eempai au khö chirsijugui” ajim anʉm. Maimua, “¡Jöo! Magbaawain chad mʉg woun sĩi degpai jua ʉ̈inaa, mʉchdëu khöm aig thachjã khönaa, dödöjöjã biwaa döbaadee sĩi onee ajugui” ajim anʉm, ichdëupai ichig. ");
INSERT INTO noaE_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","’Maimua chadcha mag ichdëu khĩirju sĩerrjö di dapag ëukhanaa ag ee thum ãba paa sĩsiewai jũrr Ẽwandamau irig magjim anʉm: “Khĩirjug chukdam, nau ĩsim edaar pʉ meejugui” ajim anʉm. “Mag pʉ meebaadeewai, pʉ nem jãg thʉnʉm paarpaag pʉ phithurg wautarr ¿jãga aagauma?” ajim anʉm. “Par pʉ phithur awia pua tag oobamgui” ajim anʉm Ẽwandamau. ");
INSERT INTO noaE_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mag nem ĩgkhaa ĩgkha öpʉ̈iwia jũrr aig narr khʉʉnagta, ’Ich jãgta aajemgui ajim anʉm ĩchab, ar sĩi mʉg jẽb gaaipai phatkhon pöm paarpawia, nem khĩir thum paraanaa, sĩi Ẽwandamag oobamjöo aajem khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Maimua mag ich dʉ̈icha ogdʉba wënʉrraajerr khʉʉnagta, ’Mua pãrag jaaukhimgui ajim anʉm: Oob pãrau “¿khani khöjuuta maach mʉg nʉma?” awia ökhĩirjuu amiet. Wa magbam khai, ya khajũajã chukhu nʉm, “¿khani jũajuuta mʉg nʉma?” a khãijã khĩirjumiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pãarta nem khoojem nem khãyaujã ajapchanaa khajũa khãyaujã ʉ̈rʉʉcha balee sĩsidʉmgui ajim anʉm, Ẽwandam dau na. Jãg ichdëu pãar ompaatarrjö, pãrau nem ig nʉmjã irua deebajup. ");
INSERT INTO noaE_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pãadë khĩirjubat ajim anʉm, kuerrb jãga naajẽ. Am phidkhaba aajeewai amach thach khöju ãkhaagjã di chukhu naab mamʉ, am augchëba aajemgui ajim anʉm, ich Ẽwandamauta amag phathau deejeewai. Magʉm pãar chará nemchaain khãyaujã ajapcha naawai, ¿jãga irua pãrag ooba abarju? ");
INSERT INTO noaE_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Oob atcha pãachdëu nem ig nʉmta khĩirju nʉʉ amiet ajim anaabá. Mag pãrau pãachdëu khõsimta ig nʉʉ akhiinjã, ¿khaíuta mʉg nʉm aig mag ichdëu khĩirju sim gaaimuapai ich meeju arr ʉ̈r oradam ãbpai khãijã ich iiupiju aai sĩ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pãrau jãg phithur khabam nemdampaijã pödba nʉm, ¿khanthee warag pãachdëu nem ig nʉmjã pödba nʉmta warag ãba aata khĩirju nʉʉ aju aai nʉ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pãadë ar pamaardam ooihmʉ thʉnaajem khĩirjubat. Am ĩchab bʉ̈ʉrjã phidkhajã phidkhaba, ni amach khajũa jũaju khĩirjuwia kha ẽkha nʉʉjã aba aajem. Mag naab mamʉ iwiir ãbmuajã am dʉ̈i barba aajemgui ajim anʉm, ooimʉg athee. Warrgar rey Salomón khararraujã phatkhon pöm paraanaa nem ajaphampa paraa aajerraujã pamaardam ooimʉgjö chan pöd khajũa jũaba aajeejimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pamaar jãg ooimʉ thʉnʉm edau wʉʉbaadëmuapai khiugphëbaadeewai sĩi khʉʉijemjã Ẽwandamau jãg ooimʉ wai sĩejemta, ¿jãgwia pãar pamaar khãyaujã ʉ̈rʉʉcha balee nʉmua nem jëeu nʉmta irua deeba abarju? ¿Wa pãachdëu jëeu nʉmjã pöd deebajupii aajẽwa? ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pãach thach khö nʉm dʉ̈i dödöjö döju chan oob pãrau atcha khĩirjumiet ajim anʉm. Wa jãga pãachdëu nem ig nʉm paarpajujã oob khĩirjumiet. ");
INSERT INTO noaE_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pãrau khaphʉ nʉmgui ajim anʉm, õor thum Ẽwandam iek ʉ̈khabam khʉʉnta magʉm nem khĩirju phöbaadëmjã pʉaba sĩerrjëem. Mamʉ pãar Aai Ẽwandamau pãrau nem ig nʉmjã thum khaphʉ sĩewai pãar chan warm khʉʉnjö magju khaba nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mag khãyau warag Ẽwandam ipierraa ajuuta khĩirjubat. Pãrau chadcha magmʉn, tagam nem pãachdëu igbarmjã irua deeb khaba deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Pãar chi mʉ bʉ̈ ogdʉba wënʉrrʉm khʉʉnan chadcha khapan khaba durrum. Mamʉ khapanag ee pãach appai khapan khaba nʉm awia oob nem ökhö wënʉrramiet ajim anʉm. Pãrau maach Aai ipierraa amʉn, irua ich durr pãar phë arr nʉm ora pãar dʉ̈i nem ajapha aju. ");
INSERT INTO noaE_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pãach nem wai nʉm përkhʉʉimamua chi phatkhon aphʉʉm khʉʉn oomampierr jigpetat ajim anʉm. Magbaawai pãrau ʉ̈gtharm phatkhon jẽeuba aajemta paarpajugui ajim anʉm. Nem ajapham pãrau mag wai nʉisim chan bʉ̈ʉrjã öbam. Ma mʉg jẽb gayam phatkhon khĩir khaba aawai nem jĩgkhaag chi ajaphamʉu awiajã pöd aubam, ni comejenaujã ag ee dikhabamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mʉig jẽb gaai nʉweta nem thum paraa aju khĩirjuju khãyau, ʉ̈gthar paawaita nem thum paarpaju khĩirju wënʉrrʉmʉn magan chadcha pãar khĩirjug ãba Ẽwandam gaaita simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Mag jajawagmamua ich bëeju igwia magjim aajem ĩchab: ’Õrau amach patrón õor jua pʉr nʉm aar matarr deeu bëeju nʉ nʉmua daukhana õtdau phuu nʉajemjö, pãarjã ĩchab ajapha khĩir khaug nʉisit ajim anʉm, mʉ bëeju nʉawai. Mag õrau amach patrón barbaicheewai weeu awaag nʉajemjö, mʉ bëejuuta nʉbat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pãrau khaphʉ nʉmgui ajim anʉm, ar chi chognaan mag daukhana amach patrón nʉ nʉm khʉʉnan onee aju, i barbaicheewai. Mag amau daukhana ich nʉ nʉm oobaicheewai, ichta jũrr chi chogkha simjö am sĩi nʉmich, mes gaai thach thöikhawia am jãogjugui ajim anaabá, ich garmuata. ");
INSERT INTO noaE_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chi chognaan amach patrón edacha pamjã bëeba ni ãspajuag pamjã bëeba sim ee warag daphökagjã igba nʉ nʉm khʉʉnan onee ajugui ajim anʉm, i da bëeba awiajã ich pierrwai amach dʉ̈i ajapha aju khap. ");
INSERT INTO noaE_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pãrau khaphʉ nʉmgui ajim anʉm, ãbmua khãijã ich di aig nem jĩgkhaan bëeju ora khaphʉ akhiin, bʉ̈ʉrjã khãiba warag sĩi thʉa ëeju, ʉdʉʉr ich nem jĩgkhapiba. ");
INSERT INTO noaE_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Magua muan pãragjã “Ich agjöta ajapha khĩir khaug nʉisit” a chirʉmgui ajim anʉm. Pãrau mʉ bëeju ora chan ãbmuajã khaugbam. Pãrau mʉ da bëebajupii nʉm ee, mʉch chi Emkhooi Iewaan dëgölp barchëju a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Magbaawai Pedroou Jesuug, —Señor, pua mag jaau sim, ¿maragpaita pua jaau chirʉ́, wa thumaam khʉʉnagwa? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—Pãragpai khabamgui ajim anʉm; mua mag chirʉmʉn pãach thum chi mʉ iek ʉ̈kha nʉm khʉʉnagau. Magnaa, Pãadë ũrbat ajim anʉm: khanim nemjö patrón ãb simua ich chaaug maagpaawai ich chog ãbamʉg warm khʉʉn pörkhapinaa ich magʉgpai ich nem thum jaau pʉabajëm. ");
INSERT INTO noaE_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Maimua mawi, mam sĩi awi deeu bëewi ichdëu jaau pʉarrjö phidkha sim oobaicheewai, ¿mag jöoi ich chog dʉ̈i onee sim dʉ̈i chi chogjã onee abaju khai? ");
INSERT INTO noaE_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mag ajapha phidkha sim oobaicheewai jöoirau warag ich nem thum magʉgta thʉsĩepʉ̈ijugui ajim anʉm, ich dënjö khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mamʉ magba mag ichig nem jaautarrjã ich ödegpai, “Mʉ patrón chan da bëebam” awi nem khaibag ich khapeen jũrr ich jua eegpaim khʉʉn dʉ̈i ichdëu ampierr anaa, nagjã ichdëu döm aig dönaa, thachjã ichdëu khöm aig khömʉn, ");
INSERT INTO noaE_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","chi dikhʉ bʉ̈ʉrjã irua nʉba sim ee bëewi mamagkham oobaichee, jũrr ichdëu warm khʉʉn dʉ̈i aajerr khãaijã i gaai athuucha wʉnaa, phidag eemuajã barpʉ̈inaa, chi khaigbacharam khʉʉn dʉ̈i ãba sĩujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Magua pãadë mʉ iek ũrbat ajim anʉm: ãbmua khãijã ich patronau ichig nem jaau pʉatarr khaphʉ simta, dëgölp ich oochëjujã khĩirjuba, ni bʉ̈ʉrjã irua nem khõsim nemjã waubamʉn, mag patronau ich bëem ed i gaai mas deejugui ajim anʉm, bʉ̈ʉrjã dau aug khaugba. Ich agjöta ajugui ajim anʉm ĩchab Ẽwandamau, ar ajapha wënʉrraju khaphʉ nʉmta nem khaigba waaujem khʉʉn gaai. ");
INSERT INTO noaE_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mamʉ ãbmuata khaugba aawai nem khaigba waumʉn, Ẽwandamau i gaai mas ab khaba mas ajup mamʉ, agpierrpai deejugui ajim anaabá. ¿Pãrau oowai ar nem dʉ̈rrcha deetarrag agjö ich deetarrpierr dʉ̈rrcha jëeuba aajẽ? ajim anʉm. Mua pãrag magkhimgui ajim anʉm: Thumaam khʉʉnau Ẽwandam athee nemdam bʉ̈rʉʉm awiajã wauju aai nʉm. Ar chi ʉ̈rʉʉcha wauju khaphʉ nʉm khʉʉnag irua ich agpierr dʉ̈rrcha jëeujem. Maimua ar ich athee nem dʉ̈rrcha wauju pödba nʉm khʉʉnag irua agjö ich agpierr bʉchkhunpai jëeujemgui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Mʉʉn mʉg jẽb gaai õor durrum khʉʉn ee mʉch iekta phũak phuu wëjöm ee õtdau dʉrbapʉ̈imjö apienta bëejimgui ajim anʉm, ich Jesuu. Ya mag õtdau pa sim, mamʉ mʉchdëu khõsi chirʉmjö warag uu pa jẽerdʉmaa akhiin ajapcha akhamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mamʉ magaagan õor jua machgau agtha ajappha dau aug wauju waaur chirʉmgui ajim anʉm. Mʉch dʉ̈i õrau magju thumaa khĩirjubaadeewaita ökhĩirjug pöoma chiraajem; mamʉ ichiita ich mag ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pãrau khĩirjuawai mʉ sĩi pãar khõinaa bibigag chukkhu naamkhĩirta bëejĩ? Pãar magamkhĩir khabajim. Mʉg mʉ bëetarran mʉg mʉchdëu Ẽwandam iek õrag jaau chitʉm gaaimua õor khĩirjug aaiphur warag chaaur khĩirju nʉrrjëe amkhĩirjöta bëejimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mua mag chirʉmʉn, mʉg mua jaau chitʉm gaaimua ãbam deg khãijã cinco naajem khai, õor thãrjupam khʉʉnau jũrr numiim khʉʉnau mʉ iek ʉ̈kha durrum khʉʉn ichaaur iekhaju aawaita mag chirʉmgui ajim anʉm. Wa magbam khai, jũrr numpaim khʉʉnau khãijã thãrjupam khʉʉnau khĩirjug ajapham wai durrum khʉʉn igar khaba wënʉrrajugui a jaaumajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magphöbaadeewai chi ayau mʉ iek ʉ̈kham khõsi ʉ̈kha sim ee, jũrr chi chaairau mʉ iek ʉ̈khamapha ajugui ajim anʉm. Ʉʉinjã agjö, chi ãdau mʉ iek ʉ̈kham khõsi ʉ̈kha sim ee, jũrr chi khaau bʉ̈ʉrjã mʉ iek ʉ̈khamapha ajugui ajim anʉm. Wa magbam khai, chi phaauhũanau mʉ iekdam ich ãigog jaau khitaawai, jũrr chi ãigou ich phaauhũan ichaaur ajugui ajim anʉm, mʉ iek ʉ̈khamaaugau. ");
INSERT INTO noaE_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Maimua õor khapan ĩchab aig narr aawai amagjã magjim anʉm: ’Edau duubjem garta edjã khĩbaadeewai, “Nosegan urum” aajem pãrau; chadcha ich maagjemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Maimua ar phũ khãijã dokhẽu garmua phua thʉnʉisiewai, “Edau pechag wʉʉju aawai” aajem pãar iek; magʉm ed chadcha ich mag pechag kheeujemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pãrau magʉmjã khaug ahau aajemta, ¿jãgwia ĩs pãrau pãach daúa mua nem wau chitʉm oo nʉmjã pöd khaug auba nʉ ajim anʉm, mʉ chadcha ich Ẽwandamau pʉ̈iju jaaujerr chaarkha chirʉm? ");
INSERT INTO noaE_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mag jajawagmamua ich Jesuupai amag, ’¿Jãgwia pãrau pãach wir aigpai pãach Ẽwandam na khaigba nʉm khaug auwia pöd “Maran chadcha khaigba nʉm” aba nʉ? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mua pãrag jaaukhimgui ajim anʉm: Ãbmua khãijã leinaanag pʉ khaibag waumkhĩir pʉch jawaan arrwai chi thethemnaan aar barwi jaauju nawe i dʉ̈i ajapha iyʉ̈ʉ awi khõinaa nʉisit a chirʉmgui ajim anʉm. Magbamʉn chi thethemnaanau guardianaanag pʉ pʉr deebaawai jũrr makhʉʉnau pʉ cárcel deg pʉ̈ibajup ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cha mʉ iekha chirʉm iekhau ya pʉʉta amau mag phãar athamʉn, phatkhon gaaimua arr khai, ãbmiecharam centaaudam phagpʉ̈ibam aigjã amau pʉ öbeerpʉ̈ibajugui ajim anʉm. Mua mag chirʉmʉn, pãach khaibag Ẽwandamag chugpaapiju aai nʉwe chugpaapiwi i dʉ̈i khõinaa ajuuta ẽkhabat a chirʉmʉugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ich mag ed gaai ĩchab ãaur khʉʉn ich Jesús sim aig bëewi irig nem ĩgkha naaichëjim aajem. Mag ĩgkhamamua irig, —Galileapien Aai i jëeujem deg nemchaain khëchwia phaa nʉmua agua Ẽwandamag amach khaibag chugpaapi jëeu naajimgui ajim anʉm. Am mag Ẽwandamag jëeu durrumta, am aig Pilato soldaaun bëewia sĩi am khëchpʉ̈ichëjim aajemgui a jaau naaichëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mag ichig jaaubaicheewaita Jesuu amag, —¿Pãrau khĩirjuawai, mag Pilato soldaaunau dau augjã chukhu khëchpʉ̈itarr khʉʉn warm khʉʉn agjö Galileapienkha thʉnʉm khãyaujã atcha khaibag pöm sĩsid aawaita mag am khëchpʉ̈ijim khai? ajim anʉm jũrr amag. ");
INSERT INTO noaE_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mag gaaimua khabajim, mamʉ mua pãrag jaaukhimgui ajim anʉm: Pãrauta chadcha pãach khaibag thumaa ãsie ewag khĩirjuwia Ẽwandamag chugpaapi jëeubam chan pãachjã dʉ̈i khëchjurau ajim anaabá, amachigcha. ");
INSERT INTO noaE_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Wa pãrau khĩirjuawai, ar thʉrrdö Siloé aajem igaau di pöm sĩerr burrwai õor dieciocho khëchtarr khʉʉnta tagam khʉʉn Jerusalén phöbör ee naajem khʉʉn khãyaujã iekkhõr pömaacha naajĩwa ajim anʉm, Ẽwandam dau na? ");
INSERT INTO noaE_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mag amach appaita Ẽwandam dakhĩir iekkhõr pömaacha narr gaaimuajã khabajimgui ajim anʉm, deeu ichdëupai. Ẽwandam dakhĩran thum ich agjö thʉnʉm, nem khaibag. Pãraujã ĩchab pãach khaibag thumaa khĩirjuwia Ẽwandamag chugpaapi jëeubam chan pãach thum ni ãbjã peerdʉbamgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mag jaau dichwia ichdëupai mʉg nem ĩgkhaa amag jaaujim aajem: ’Woun ãbmua ich uvadö ee nemjõ igo anʉm jĩir wai sĩejim aajem. Khãai ãb jõm khõchag aadeewai aar oon majim anʉm. Mamʉ mag oon maawai bʉ̈ʉrjã chëba sĩi ë meuu dʉnaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Magbaawai di aig pachëwia magjim anʉm, chi nemjĩir jaarjemʉg: “Igo jõm khõchgau año thãrjup pam sĩi aar oo khʉrrkha chirʉm; mamʉ chëba sĩerraawai gaai ooimaba aajem. Jãgan jãg sĩpí warag thubapʉ̈i” ajim anʉm. “Magba par chëbam jãg sĩejemgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Magbaawai, “Patrón jöoi, magan idëu año ãb oo athá” ajim anʉm, chi nemjĩir bʉ̈ phʉajem wounau. “Jãg sim khai, mua warag ag bʉ̈khʉrr wa phʉʉrdʉpʉ̈inaa phʉichichagau i bʉ̈ khuajugui” ajim anʉm, “chëmkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mag bʉ̈ khuabaawai chëmʉn ʉ̈uma” ajim anʉm. “Mamʉ mag bʉ̈ khua nʉmjã ich magpai chëba abarmʉn magan chadau thupʉ̈ijugui” ajim anʉm, chi bʉ̈ jaarjemua. ");
INSERT INTO noaE_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Biek ãb jua ʉ̈i nʉm ed Jesuu Ẽwandam iek jaau sĩejim aajem, judionaan ãba biirdʉwia Ẽwandam iek jaaujem deg. ");
INSERT INTO noaE_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Maig ʉʉi ãb sĩejim aajem. Mag ʉʉi mor machpawia dieciocho años sĩi jã bʉrëu khitaajeejim anaabá, bën khaigbam i mor ee dubwia. Magtarr aigmua pöd bʉ̈ʉrjã phõ khajapha thʉrrkhaba ich mag khitaajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesuu mag oo athaawai dau ee aug khaugwia, i thʉ̈r aunaa irig, ");
INSERT INTO noaE_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","“Mua pʉ monaaukhim” anaa, i ʉ̈r jua ausĩubarm bʉ̈rre phõ thʉrrkha khajappha oo dʉnʉisijim anaabá, monakkha. Mag ich monaaubapäaiwai onegau Ẽwandamag, “Ẽwandam, ĩsin chadau pua mʉ ʉ̈uta abarm. Pʉjö jua theegkham chan mʉg jẽb gaai chukhum. Ʉ̈u abarmgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mamʉ magbaawai mag amach ãba biirdʉ nʉm ag degam chi pörkha sĩerr Jesús dʉ̈i meeukhabaadëwia jũrr khĩir mor chigpai õragta, —Seman gaai seis diaspai phidkhaju aai nʉmgui ajim anʉm. Mag seis diam een chadau pãadëu bëewia pãach monaaupibat ajim anʉm. Mamʉ oob mʉg sĩi jua ʉ̈i kheeujem ed khabajupama ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Magbaawaita maach Pör Jesuu irig magjim anaabá: —Woun sëunem, ¿khantheeta pʉ mag chitʉ́ma? ajim anʉm. Pãar mag jua ʉ̈ʉijem ed bʉ̈ʉrjã phidkhaba aajem anʉmta, ¿khan jãgwia pãrau pãach cabaai wa phak khãijã dö döpien phë arrjẽma? ¿Jãg nʉm chan magan phidkha nʉm khabahab? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pãrau pãach nemchaainjã mag dö döpi khʉrrkha nʉmta, ¿khan jãgwia mʉg ʉʉi ĩchab warrgar jöoi Abrán khararrau ʉ̈khaajerr ag Ẽwandam gaai ʉ̈kha simta pöd i monaauju khaba sĩ, jua ʉ̈ʉijem ed awia? Jãg sim aig ijã ĩchab dieciocho años meperau i pʉrnaa ö jʉ̈ wai simjö simta ẽerpʉ̈i nʉm khabahab ajim anʉm, jãg bënëu i ogdʉpʉ̈imkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesuu mag amach öbeerbapʉ̈im ũrwia i oomapha aajem khʉʉn thum chigaa aphöbaadëjim anaabá, amachta. Mag am chigaa nʉm ee, tagam khʉʉn thum aig narr khʉʉnau amach daúa Jesuu mag nem wau sim oo nʉm gaaimua onee nʉm iekhau Ẽwandamag, “Ʉ̈u chadcha pua marag pʉch jua theeg oopibarm Ẽwandam; ag na marau mʉgjö chan nem ooba aajemgui” a iekha naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mag iekhakhagmamua ĩchab magjim anʉm ich Jesuu: ’¿Pãrau khaphʉ nʉ, jãga sim abarí Ẽwandam iek mua jaau chitʉm, maimua khanjöta sim a mua pãrag jaaubarkhiin? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Magnaa ichdëupai, Mʉg Ẽwandam iekhan mostaza daudam woun ãbmua ich nemjĩir ee jĩirjemjöta sĩerrʉm. Ichta nemjĩir daudam thumaam khʉʉn khãyaujã bʉ̈rʉʉcha khitʉm. Mamʉ mag khitʉmʉn nem bãau khaphí bãauwia sĩi pabʉ̈ pöm ãdëe dʉnʉisiejemgui ajim anʉm. Mag ãdëe dʉnʉisiewai nemchaaindamau ag gaai amach didam ëuphöbaadeejem. Ich agjöta simgui ajim anʉm ĩchab mʉg Ẽwandam iek mua pãrag jaau chitʉmjã. Mʉʉgwaiwe chan khapan khabata ʉ̈kha durrum; pari mag durrumuata warag nem pöm aaidʉbapäaiwai, õor khapankham khʉʉnau ʉ̈khajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Maimua deeu ichdëupai amag, ’Pãrau khĩirjuawai ¿jãga sim abarí Ẽwandamau ich iek aaidʉpi nʉm, maimua jũrr khan dʉ̈ita mua pãrag jaaubarkhiin? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ich iiu aawai ich iek aaidʉpi nʉmʉn, ʉʉi ãbmua arin dʉ̈rrcha sim ee levadura pʉ̈itarrjöta sĩerrʉmgui ajim anʉm. Levadura bʉ̈rʉʉ pʉ̈itarrjã maadëu aaidʉmam chan ooba aajem; mamʉ mag simuan arin thum ʉrpi aaujem. Ich agjöta simgui ajim anʉm ĩchab Ẽwandam iek mʉg mua jaau chitʉmjã. Mʉʉgwaiwe chan õor pöm mʉg wëjöm ee agtha pömcha aaidʉba sim. Mamʉ mʉg atagta durr warpham magwe aaidʉbaadee thumaam khʉʉnau ũrab khaba ũrjugui ajim anʉm, ich Jesuucha. ");
INSERT INTO noaE_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesuu ich mag Ẽwandam iek jaau nʉrraajeejim aajem phöbörpierr, didam khapan khaba dʉnʉnʉidʉm eem magwe ich nʉrrʉmpierr. Mag mamua warag Jerusalenag maa ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","I mag nʉrrʉm ee ãbmua irig, —Señor, ¿ʉ̈gthar öbërju khʉʉnta khapanaacha nʉ wa okhooju khʉʉnta khapanaacha nʉwa? ajim anʉm. Magbaawai Jesuu irig, ");
INSERT INTO noaE_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ʉ̈gthar öbëraagan, puertdidam bʉ̈rʉʉ khitʉm ee dubaagpamjöta aajemgui ajim anʉm. Muan pãragan, mag puertdidam phĩrkhi khitʉm eeta dubju ẽkhabat a chirʉm. Mʉg atag õor pöm ag ee dubam khõsi ajup mamʉ, mag thʉnʉm khʉʉn eem ãbjã pöd dubbajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pãrau dubaag ẽkhawiajã ya chi dikhʉ jöoyau phãarbapʉ̈im chan, par pãrau daaugajãrmua, “Señor, maar weeu athá” awiajã, jũrr ierrmua irua pãrag, “¿Pãar jamaam khʉʉnauma? Pãar chan mʉ aiguim khʉʉn khabamgui” aju, warag weeu aubaju aawai. ");
INSERT INTO noaE_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Magbaawai pãach weeu aumkhĩir, pãrau irig magjurau: “¿Pua maar khaugbata chirʉ́? Maar pʉ dʉ̈i ãba thach khoojerr khʉʉn khabahab. Pʉ khabajieb maar maestro. Pua ante maar phöbör ee Ẽwandam i jaauba aajeejieb” aju irig. ");
INSERT INTO noaE_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mamʉ magbaawai irua ĩchab pãrag magju: “Ya mua pãrag jaaubarm. Mua chan tag pãar khaugbam. Pãach sĩi nem khaigbam appai wau wënʉrraajerr khap, pãadëu warag pãachta mʉ aigmua chawag ërëubaadët” a iekhajugui ajim anʉm, Ẽwandamau pãrag. ");
INSERT INTO noaE_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pãrau oowai chadcha pãach daaugajãrpai thʉbagkha nʉisim oobaawai, pãrau icharaucha sereeu öo thʉnʉmua, warag gaai machgaupa ihesse aadëphʉmua, pãrau oojugui ajim anʉm: jöoi Abrán, Isá, Jacob, maimua tag warrgarwe Ẽwandam i jaaujerr khʉʉn ich dʉ̈i ãba i bigaau onee ohoodö nʉm. Maagwai pãachta khõinaa am mag onee nʉmjö i dʉ̈i wënʉrraju aajerr khʉʉnta pãran ich mag iseg nʉisim iekhaugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Maigta pãar khĩir machag ajugui ajim anʉm, pãach pöd dubba nʉm daar durrpierram khʉʉnpata dub thʉnʉm oowia. Maig thʉnaaju: edau öbeerjem garm khʉʉn, edau duubjem garm khʉʉn maimua deeum durram khʉʉnpa bëemawia Ẽwandam dʉ̈i ãba onee thach khoog ohood aphöbaadëjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mag Ẽwandamau õor i agkhabaadëm ed ar mʉg jẽb gaai aawai amachta warm khʉʉn khãaijã ajapcha nʉm aajem khʉʉnta khapan khabacha öbërju. Mag khãyau ar chikhamnau serbiibag phëejem khʉʉnta khapanaacha Ẽwandam sim aar öbërjugui ajim anʉm, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ich mag edcha Ẽwandamau Moiseeg ich iek phãpitarr ajapcha ʉʉrkhaajem khʉʉn Jesús aig bëewi irig, —Rey Erodeeu pʉ thõopäaig ẽkha sim. Pʉchta mʉigmua jöpkhaa igbaad aichëjierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Magbaawai ichdëu amag magjim anʉm: —Ërëubaadëwi irig, “Ich iphithur idëu mag sim; mʉg ed gayan mʉʉn ichiita ich mʉg õor mor ee bën khaigbampa jʉr wërpnaa ich mʉg õor monaau chitaju” a jaaubaimat ajim anʉm, mʉ imeerba. Magnaa ĩchab, Ya mʉ phidag öimʉʉ pamam; ");
INSERT INTO noaE_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","mag agtha öba sĩewai ich mʉg mʉch phidag öpʉ̈ibam aarjã ogdʉba jaau chitʉmua Ẽwandam i jaaujem khëchmien phöbör ee barjugui ajim anʉm, Jerusalén. ¡Jãga mag mʉjã ĩchab Ẽwandam i jaaumieta Jerusalén phöbör chaaur amau mʉ thõobarjugui! ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Maimua Jerusalenpienta warag ʉ̈apërwia magjim anʉm: ’¡Ë! ¡Aay, Jerusalenpien! Pãraun chadcha warrgarweta Ẽwandamau ich i jaaumkhĩir chogpʉ̈i nʉm khʉʉnjã kha khõchkhaba, pãrau warag mokoujã am bar wai nʉmua khëchpʉ̈imaajemgui ajim anʉm. Biek khapan mua pãrag jaaujeejim, ãthãrr ʉʉirau ich chaaindam thumaa ich ich eegar thʉa wai juupjemjö, pãar thʉa wai chitaag. Mamʉ magtarrjã pãachdëuta bʉ̈ʉrjã mag khõchkhabajierramgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jãgtarrau nau pãrau oomaa abarjugui ajim anʉm. Nau mʉ mʉg chitʉʉ awia petaawai Ẽwandamau sĩi di pariim ee wouchnaan phëpʉabaajemjöta thʉbagkha nʉisijugui ajim anʉm, pãran. Magbarm aigmua chan tag pãrau mʉ oobamgui ajim anʉm. Pãrau mʉ oojuun, ãba ya pãachdëucha deeu mʉ urum oowia, “Ʉ̈uchata Ẽwandam, pua pʉch jũrr pʉch Chaaita maar athee Reikha pʉ̈ibarm” anʉm aigta pãrau deeu mʉ oojugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Khãai ãb fariseonaan eem ãb ĩchab chi pörkha simua Jesús ëeurrjim aajem, ich di aar i dʉ̈i ãba thach khoog. Mag ed sĩi jua ʉ̈ʉijem ed arr aawai amachdëun ãba irigta eerpapa aajeejim anaabá, eeu dëgölp mag pöd bʉ̈ʉrjã nem wauju khabam edta bʉ̈ʉr khãijã jua peerthʉ nem waubaawai magʉm gaaimua i imeraa pʉr awaag. ");
INSERT INTO noaE_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mag am thach khö nʉm aig bëewi sĩejim aajem ĩchab, woun ãb kha ööodö khitʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mag oobaawai warag iyʉ̈ʉ nʉmua Jesuu chi machnaanag jëeunaa ĩchab chi fariseonaanagjã jëeumamua, —¿Pãrau oowai mʉg jua ʉ̈i nʉm ed õor mor masim khʉʉn monaauju aai sĩ, wa monaauju aai khaba sĩwi? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mamʉ mag amachig Jesuu jëeubarm ũr nʉmjã ni ãbmuajã jʉ̈ʉ abajierram anaabá. Mag amachig khabamjö warag khĩuu abaawai mag chi kha ööodö khitʉm ich aig thʉ̈rnaa, i gaai pʉrbaawai monaaupʉ̈iwia, irig, —Pʉ maju aai chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Maimua jũrr ich dʉ̈i ãba thach khoog aig narr khʉʉnag magjim anʉm: —Pãar cabaai khãijã wa pãar phak khãijã jẽbdeg burrwia pöd ich ap öbërba sĩsim oobaawai, ¿khaíuta ag bʉ̈rre mawia ich nemchaai jẽu aubaju khai ajim anʉm, sĩi jua ʉ̈ʉijem ed awia? ");
INSERT INTO noaE_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mamʉ ich iek ʉ̈khamkhĩir par irua mag jëeu ohookhamjã ni ãbmuajã i iek ʉ̈khabajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Maimua Jesuu oowai, jũrram khʉʉnau amachig jaauba nʉm ee amachdëuta sie ajapcharam jʉr aunaa nacha ohood aadeewai, chi thʉ̈rkhʉʉipʉ̈iwia bëetarr khʉʉnag magjim anʉm, am wawimamua: ");
INSERT INTO noaE_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Dëgölp ãbmua khãijã ich jua pʉr nʉm phiesta ee pãach thʉ̈r aauwai, oob pãach khĩrau chan sie ajapcharamta ookhanaa pãachta pör garcha jupmiet ajim anʉm. Magbam eeu mag sie pãach khãyau chi thethem khʉʉn athee wai nʉm gaai khãijã pãach jupdukham. ");
INSERT INTO noaE_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mag pãachta sie ajapcharam gaai ohoodö nʉm aig, chi jua pʉr chirʉm wounau bëewi pãrag “Phiidʉtkhabat, mʉg sie deeum khʉʉn atheemʉu” aicheewai, eeu dëgölp pãar khĩir naauwia jũrr õor ëugarcha khĩir naa ohoodö aimadukham ajim anʉm, tagam khʉʉn dakhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Magju khãai ãbmua khãijã ich jua pʉr nʉm phiesta ee pãach thʉ̈r aauwai pãachta warm khʉʉn ëugarcharam sie gaai jupbat ajim anaabá. Pãar mam ohoodö nʉm oobaawai, chi jua pʉr chirʉm wounau pãrag, “Keena, jũrr mau na jupbahut” abaawai, chigag chukhu pãachta warm khʉʉn na ohoodö aimaju. ");
INSERT INTO noaE_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mag, pãrag mag chirʉmʉn, ar amach thöwia chikham dʉ̈i athuucha aajem khʉʉnta jũrr mʉg atag paawai am Ẽwandamag chaigpa oo sĩsidʉ aju. Maimua ar mag amach dʉ̈i athuu nʉm khʉʉn ichaaurjã magʉm aba sĩi warag serbiibamjö aajerr khʉʉnta jũrr mʉg atag paawai Ẽwandamau warm khʉʉn khãyaujã ʉ̈rpai apiju ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Maimua ich thach khömkhĩir thʉ̈rtarrag magjim anʉm ich Jesuu: ’Deeu pʉch phiejãb dʉ̈rrcha wauwia thach khömkhĩir õor thʉ̈ʉrwai oob sĩi pʉch khapkhʉʉn appai thʉ̈rkhʉyam ajim anʉm, ni pʉch khodnaan, ni sĩi thʉ̈r khodpaim khʉʉn appaijã thʉ̈rba, ni sĩi phatkhon paraam khʉʉn pʉch dʉ̈i ãba di dakha naajem khʉʉn appaijã oob thʉ̈rkhʉyam. Pua magʉm khʉʉnta khĩirjuwia thʉ̈rkhʉʉimʉn, magan amaujã agjö wauwia pʉ thʉ̈r athaawai deeu pʉrʉg phagbarmjöta aju. ");
INSERT INTO noaE_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Magju khãai pʉch phiejãb pöm waupʉ̈iwia thach khoog õor thʉ̈ʉrwai dau aphʉʉm khʉʉndamta thʉ̈rbá ajim anʉm: ar bʉ̈ bisi wa juadam khãijã bisi khithëem khʉʉn, ar khu thũuiba thũuiba khithëem khʉʉn, wa ar dau khĩsu khithëem khʉʉn khãijã. ");
INSERT INTO noaE_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pua mag khithëem khʉʉn dʉ̈ita magmʉn, amau chadcha pʉ dʉ̈i pöd agjö abaju, mamʉ magtarr paar Ẽwandamauta jũrr pʉ onee apiju. Ar i iek ʉ̈kha durrumua khëchtarr khʉʉn deeu iiu phiidʉ nʉm jaar, magtarr jũrran ichdëuta pʉrʉg phagjugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mag Jesús iyʉ̈ʉ sim ũrwia, ãb i dʉ̈i ãba thach khö sĩerrau irig, —Ʉ̈gthar pawiajã ich mʉg cha maach nʉmjö Ẽwandam dʉ̈icha thach khö sim wounan chadcha i onee ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ichig magbaawai jũrr Jesuu irig, —Mua pʉrʉg nem ĩgkhakhimgui ajim anʉm. Magnaa, Jöoi ãb sĩejim aajemgui ajim anʉm. Mag jöoirau õor khapankham khʉʉnag jaau wai sĩejim aajem, ichdëu phiejãb pöm waubapäaiwai makhʉʉn thum ich aig thach khoon bëemkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Maimua chadcha phiejãb wauwia, ya thach khöju ed aadeewai, chi patrón jöoirau ich chog pʉ̈ijim aajem, ich dʉ̈i iekhatarr khʉʉn aar jaaubaimaawai thach khoon bëemamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Maimua mawia, chi chogau jajawagmampierr bëemaaugau, jũrr pogkha jaaumaajeejim aajem, chi bëeju arr khʉʉnau. Nacha jaauwimatarr aiguimua magjim anʉm: “Chaig ewaa jẽb për autarr oon maju chiraawai mʉ pöd mabam; idëu ẽudeem athee khërtarrau” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Maimua ãbakhai aar jaaubaimaawai maguajã agjö, “Mʉ pöd mabam, phak emkhooin diez eeu përkha autarr phidag ee wai jẽraan phë arrju aawai. Jãgba akhiin chadau mʉ makhamgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ich mag jajawagmamua ẽudeecharam aar jaaubaimaawai magua paawai magjim anʉm: “Mʉ maju ajieb mamʉ, mʉch ʉʉi dʉ̈i ewaa pa chiraawai pöd mabajugui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Magbaawai mag chi iek jaau chitarr woun deeu ich appai bëewi ichig warm khʉʉnau jaaumarrjöo jũrr ich patronag jaauchëjim aajem. Mag ũrbaawai jöoi khĩir machag thʉnʉmua magjim aajem, ich chogag: “Petá” ajim anʉm, “deeu. Maimua jöpkhar jũrr kaaijã ee ar dau aphʉʉ khithëem khʉʉn phë aipidú ajim anʉm: ar bʉ̈ bisi wa juadam khãijã bisi khithëem khʉʉn, khu thũuiba thũuiba khithëem khʉʉn, maimua ar dau khĩsu khithëem khʉʉnpa.” ");
INSERT INTO noaE_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mag jaaubaawai chi chogau mawia, ichdëu jaaupʉ̈itarrjö awia, deeu barchëwia magjim aajem, ich patronag: “Mua thum pʉchdëu jaautarrjö abarm. Mamʉ magʉmjã agtha õor khapaana dʉ̈rr aju simgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Magbaawai ich jöoirau deeu magjim anʉm, ich chogag: “Jũrr phöbör igaau mawia parhooba ar ich jãg dau aphʉʉ khithëem khʉʉn thum pʉchdëu oomam phë aipidú” ajim anʉm, “warre õrau di dʉ̈rrkhaba sĩwaag. Pʉch iek ʉ̈khaba abaawai amag thum ajapha jaaumamua ichiita mua am mʉch dʉ̈i thach khömkhĩirta thʉ̈rkhʉʉi chirʉm abá” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya maadëu khaphʉ nʉm, ar nacha thʉ̈rwia bëeba arr khʉʉnau chan amau bʉ̈ʉrjã mʉ thach isĩebajugui ajim anʉm, chi nacha thʉ̈rtarr khʉʉn igwia. ");
INSERT INTO noaE_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mag Jesús mam dʉ̈i i ẽudee õor pöoma wëtmajim aajem. Mag ich ẽudee wëtum khʉʉnag magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ãbmua khãijã mʉ dʉ̈i ogdʉba nʉrraju khĩirju simta khũchpaijã ich dënnaan kha ogdʉmapha wa ich ʉʉi, ich chaain, ich khodnaan khãijã ogdʉmaphanaa ich dau aphʉʉ aju khãijã khĩirju sim chan, pöd mʉ dʉ̈i khapeer khaju khaba simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ar chi mʉ dʉ̈i nʉrram khõsi simuan warre ich phithurg au nʉrrajujã khaphʉ aju aai simgui ajim anʉm, mʉ gaaimua chikhamnau ich thõoju khaphʉ awiajã ich mag mʉ bʉ̈ ogdʉba nʉrraju aawai. Mag ãwatbaju chan, parta idëu khõs mʉ dʉ̈i nʉrrʉm ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Magnaa amag, ’¿Chijãg wounauta ich di ëwaagpaawai nacha khĩirju sĩi abaju khai ajim anʉm, khan nemta phë auju, khachpai igju, wa phatkhon khãijã dʉ̈rr khaba abaawai pöd nem igju thum phë aubaju khãijã khap aag? ");
INSERT INTO noaE_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Magjã khĩirjubanaa, eeu dëgölp di ëuju aadëwia, dibʉ̈ appai khãijã jukha sĩuwia, pöd ëu auba ich mag werba sĩukhiin, bigaaum khʉʉnau ich khĩircha khãijã i wauwia irig, ");
INSERT INTO noaE_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mʉg wounaun par di ëu aubajuuta sĩi dibʉ̈ appai jãg idëu khõs jukhabaadëjim” ajugui ajim anʉm. Ich jãg di ëwaagpaawai khĩirjuajemjöta khĩirjuju aai simgui ajim anʉm mʉ dʉ̈i nʉrraagjã, dich dau aphʉʉ aju khaphʉ simjã magʉm igba warag magʉm ãwat nʉrraag. ");
INSERT INTO noaE_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Magnaa deeum ejemplo igwia, ’Wa magbam khai, ¿khanim reita deeum agjö ichjö reikha sim dʉ̈i juurhi ee ich wërbʉan maju nawe khĩirju sĩi abaju khai ajim anʉm, ajap khap aag? Irua khaphʉ simgui ajim anʉm, warmua soldaaun khapanag veinte mil wai sĩewai ichdëu diez milpai wai sim. Mag juurhi ee maju nawe, ¿irua khĩirju aubaju khai, mag ich soldaaun magcha khapan khaba durrum dʉ̈i warm khʉʉn khapan thʉnʉm aar wërbʉan petaawai ichdëu pödbaju? ");
INSERT INTO noaE_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Irua mag khĩirjumʉn, agtha warm dʉ̈i thẽuju nawe, warp nʉwe khaug aujugui ajim anʉm, ichdëu pödbaju. Magbaawai irua ich soldaaun warm khʉʉn aar chogpʉ̈iju, makhʉʉnau chaigpabaimaawai wërbʉju arrjã wërbʉba warag khõinaa nʉisieg. ");
INSERT INTO noaE_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ich agjöta aajemgui ajim anʉm ĩchab mʉ dʉ̈i khapeerkhaagjã. Mʉʉta nacha pãrau ʉ̈rcha khõsinaa mʉg jẽb gaaim nem pãachdëu khõsim thum isegbam chan, pöd mʉ khapeen aju khaba nʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mag amach nem isegmapham khʉʉn igwi iekhakhagmamua ĩchab, ’Thakharan chadcha nem ajaphamʉugui ajim anʉm; mamʉ mag sim nakha aadëkhiin, ¿khanthee serbiiju? Pöd bʉ̈ʉrjã agua nem phöju khaba, ");
INSERT INTO noaE_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ni jẽb phʉichichag dʉ̈i waaurëunaa nemjĩir bʉ̈ khuagjã serbiiba sĩsiju. Mag serbiiba sĩsiewai sĩi barpʉ̈ijugui ajim anaabá. Ich jãgaugui ajim anʉm ĩchab ar mʉ iek ʉ̈khamaaugau amach nem khõchag thum isegba nʉm khʉʉnjã. Keena, jʉ̈g ʉ̈rʉʉnaa cha mua jaau chirʉm ajapha ũrbat a jaaumajim aajem, ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Biek ãb Jesuu jãga Ẽwandamau õor peerdʉajẽ a jaau sim aig, gobiernoog dëbpaar paar nʉm jëeujem khʉʉn khapan bëe thʉnaajim aajem, chi pekau dapnaanpa, i iek ũraan. ");
INSERT INTO noaE_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Magbaawai chi ajapha Ẽwandamau Moiseeg iek phãpitarr ʉʉrkhaajem khʉʉn, maimua ag iek jawaag athee chi machnaan dʉ̈imua Jesús igwia, —I dën mʉg wounau chan pekau pöm sĩsidʉm khʉʉn awiajã isegba ich jãg warag am dʉ̈i thach khö nʉrraajem anaajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Magbaawai ichdëu am mag iekha nʉm ũrwia, mʉg nem ĩgkhaadam jaaumamua amag magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Khanim nemjö mʉg nʉm aig ãbmua cien ovejas wai sim, maimua ãb okhoobaadeewai, ¿khaíuta tagam khʉʉn dö wajaug ee phëpʉawia mag okhoo khitʉmdam jʉraan mabaju khai? ajim anʉm. Keen, par maadëu dich nemchaai aawai baaubam aigjã ookha khitʉʉ abarju. ");
INSERT INTO noaE_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Maimua mag baau athaawai, ¿khaíuta sĩi onegau dich nemchaaidam ud aibëebaju khai? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Maimua di aig pachëwiajã, ¿khaíuta ich khapkhʉʉn dʉ̈i ich di dakha naajem khʉʉnpa thʉ̈rkhanaa, “Keen, mʉ onee chirʉm, mʉch oveja okhootarrdam oo athaawai” abaju khai? ");
INSERT INTO noaE_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Keena, ich jãgta aajemgui ajim anʉm ĩchab ʉ̈gtharjã: Ar õor khapan amach ajaug thöwia Ẽwandam dʉ̈icha wënʉrrʉm aajem khʉʉn gaaimua onee aju khãyau, pekau pömkham khʉʉn eem ãb khãijã ich khaibag isegwia Ẽwandam ich thãar ee atham ed ʉ̈gtharmpeenjã onee aphöbaadeejemgui ajim anʉm ĩchab. ");
INSERT INTO noaE_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Maimua ĩchab mʉg jaaujim aajem: ’Khanim nemjö ʉʉi ãb simua phatkhon chi dau daí appai diez wai sim, maimua mag eem ãb khãijã okhoobaadeewai, ¿chijãg ʉʉirauta bʉ̈ʉrjã ich phatkhon jʉrba ich mag sĩuju khai? Par jãgan irua ag bʉ̈rre lámpara paanaa, dijã thũapwia, nem pʉaba jʉr sĩi awia, baau athajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Maimua mag baau athaawai, ¿chijãg ʉʉirauta ich khapeen ich di dakha naajem khʉʉn thʉ̈rkha auwia, “Keena, ĩsin mʉʉn onee ʉm, mʉch phatkhondam okhoo wai ʉarr baau athaawai” abaju khai? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Magnaa ich Jesuupai, Ich jãgta ʉ̈gtharjã ĩchab Ẽwandam chognaan onee aphöbaadeejemgui ajim anʉm, ar woun ãb khãijã ich khaibag isegwia khĩirjug ajapham jʉrwia Ẽwandam ich thãar ee atham ed. ");
INSERT INTO noaE_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Maimua jãga Ẽwandamau õrau ich iigwai isegba aajem khap amkhĩir, Jesuu mag ich aig bëetarr khʉʉnag mʉg nem ĩgkhaajã ĩgkhajim aajem ĩchab: —Woun jöoi ãb simua chaain numí wai sĩejim aajem, emkhooin apha. ");
INSERT INTO noaE_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Khãai ãb chi iewaa chi ẽudeemua ich ayag, “Tata, pʉ meebaadeewai marau jʉ̈aju nem warre magan mʉrʉg mʉch jua ee dee chirbá” ajim anʉm. Magbaawai jöoirau chadcha amag jigbaadëjim aajem, amachpierr. ");
INSERT INTO noaE_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mag deetarr khur khãai khapancha khaba nʉm ee, ichig nem deetarr thum përkhʉʉipʉ̈iwia ag phatkhon dʉ̈i warre warp petajim aajem, deeum durr. Mamʉ mam pawia nem oobam gaai ichdëu gastaam aig phatkhon ãr gastaa sĩeimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Maimua mag phatkhon nem parhoobam gaai werba sĩi awia thum öbapʉ̈im ee ĩchab jãdau theega burrjim aajem, i sim durr. Maimua magbaadëm dʉ̈i ya ĩchab jãsogau mas aadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jãsogau ich magbaadeewai woun ãb sĩerr aar mawia parhoobam phidagdam khãijã ichig deemkhĩir jëeuwimajim anʉm. Magbaa magua irig jaaupʉ̈ijim aajem, khũsnaan thʉamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mag chadcha mawia khũsnaan thʉa oo chirʉmua jãsooga aawai chi khũsnaanag phathau deechë nʉm eemta dʉ̈i khöm iigjeejim anʉm, chi khũsnaanau khö nʉm dʉ̈i ãba, bʉ̈ʉr khãijã jãd thõo awaag. Mamʉ magʉmjã ãbmuajã irig “Ya magan khöjuma” aba aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Khãai ãb mag oo chirʉʉ awia thumaa khĩirjumamua ich wir aigpai magjim anʉm: “¡Ë! Mʉ aai di aar i piyonnaan bʉ̈ʉrjã khöju athee augchëba biwaa thʉnʉm ee, mʉchta mʉch khĩir lökgau jãdaúa mʉig mʉ thõo warrumgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Mʉg chirabnaa mʉ majugui” ajim anʉm “mʉch aai aar. Maimua barimawia mua irig ‘Tata, chadcha mua Ẽwandam dakhĩir pekau wauwia pʉ dʉ̈ijã khaigba abarm’ aimaju. ");
INSERT INTO noaE_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","‘Mag gaaimua warramjö pua mʉrʉg pʉch chaai aju khaba sim. Mʉrʉg iewaa aju khãyau sĩi mʉrʉg pʉch piyón abá; mʉ pʉ athee ich mag phidkha chitaju’ a iekhaimaju” khĩirju athajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Mag ich appai iyʉ̈ʉ oo sĩewia baubaadeeu chadcha ich aai aar petajim aajem. Mag mamua agtha di warphaa sĩwe chi ayau oo athajim anʉm, i chaaita dau aphʉʉ ur khitʉm. Magbaawai jöoi thãrau ãwatbajim aajem. Mag warag khaphig mawia ich chaai ö phʉʉr jõinaa khĩir ʉ̈ʉ aujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Magbaawai chi chaairau ich ayag, “Tata, chadcha mua Ẽwandam dakhĩir pekau wauwia pʉ dʉ̈ijã khaigba abarmgui ajim anʉm. Mag gaaimua warramjö pua mʉrʉg pʉch chaai aju khaba chirʉm” ajim aajem ich ayag. ");
INSERT INTO noaE_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mamʉ chi ayau dau aug khaugwia, magʉmjã igba, warag degag arrwia ich chognaanag, “Mʉ chaai athee khajũa chi ajapcharam jʉrwia jũapi sĩubat” ajim anʉm. “Maimua ĩchab sorrtikjã jũapinaa zapatjã chi ajapham jũapibapʉ̈it. ");
INSERT INTO noaE_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Magwia phakdam chi õtpaam authurwia thõobapʉ̈it” ajim anʉm, “maach thum ãba onee khö nʉmua phiesta wawaag. ");
INSERT INTO noaE_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pãrau oo nʉmgui ajim anʉm, mʉ chaai chi meem arrta deeu iiubarmjö abarm; bëebajupii narrta deeu barbaichëm” ajim anʉm. Mag, chadcha phiesta waujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Mamʉ maagwai ich jöoi iewaa chi naam, phidag ee sĩejim aajem. Maimua bëewia di dakha panaa ũr uraa aawai sĩi karris phophookham dʉ̈i tamburrpa bubujukham gaai jemkha khodthʉnʉm khaug athajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mag ũrbaawai ich aai chog ãb thʉ̈rnaa, “¿Khan gaaimua agá eeupemjö mag thʉnarram?” a jëeujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Magbaa chi chogau “Pʉ eeumta bëejimgui” ajim anʉm. “Mag ʉ̈u barbaicheewaita pʉ ayau phakdam chi sebaam wai narr thõopibajieb” ajim anʉm “phiesta wawaag.” ");
INSERT INTO noaE_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mamʉ ichig mag jaaubaawai warag meeukhawia dubmapha daaugajãrpai sĩsijim aajem. Magbaawai öbërchëwia chi ayau ithũu ich iewaag, “Dubtarrau iewaa” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mamʉ ichig magbaawai warag ich ayag, “Pʉdë ũrbá tata” ajim anʉm. “Mʉch erraawe bʉ̈ʉrjã pʉ aigmua ogdʉba, pʉ phidag ee mʉ phidkha chitaajem; pua nem jajaaukham ichaauraapaijã iekhaba chitʉmgui” ajim anʉm. “Mamʉ magʉmjã bʉ̈ʉrjã pua mʉrʉg chĩb chaaidam khãijã deeba aajem, mʉch khapeen dʉ̈i onee khömkhĩirjã. ");
INSERT INTO noaE_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mag khãyau sĩi jãg pʉch phatkhon arrwia parhoob kachaloonaa ʉʉin dʉ̈ipa ãr gastaapʉ̈ithurtarr barbaicheewain chadau, pua phak chi sebaampa thõo chirabma” ajim anʉm, “i khömkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Magbaa jöoirau jũrr ich iewaag magjim aajem: “Mamʉ pua khaphʉ chirabá” ajim anʉm, “chadcha pʉchta mʉ aigmua ogdʉba khitaajeewai mʉ nem mʉg thʉnʉm thum pʉch dën appai thʉnʉm. ");
INSERT INTO noaE_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mamʉ pua oo chirʉmgui” ajim anʉm, “pʉ eeum chi meem arrta phiidʉwi pierrumjö abarm; maach aigmua mawia tag bëebajupii narrta, ĩsta deeu pierrumgui” ajim anʉm. “Magua ĩs chadcha maadëu mʉgju aai naabahab ajim anʉm, i bëetarr gaaimua onee aag.” ");
INSERT INTO noaE_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Maimua Jesuu ĩchab mʉg nem ĩgkhaadam ĩgkhajim aajem, ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnag: —Ãb rik sĩejim aajem. Mamʉ ichdëu ich nem khaugba, deeumʉgta ich nem thum jaau wai sĩejim aajem, magʉgta ich dënjö amkhĩir. Mamʉ khãai ãb chi morkhʉʉu ũurwai i nem aair aba parhooba sĩi ichdëu ampierrta wau sim a ũrbaawai, ");
INSERT INTO noaE_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","thʉ̈rpʉ̈iwia irig magjim anʉm: “¿Khan ajaugta mua ũurwai mag pua bʉ̈ʉrjã mʉ nem aair aba chirʉm anʉ́ma? Mʉ iekhau nauwe jöpkhaa pʉchdëu nem waaujem thum phãkhanaa mʉrʉg oopibá” ajim anʉm, “mua khap aag. Mag oopiwia warre pʉdëu sĩiubaad, tag mua pʉ igbam” ajim anʉm ich khĩircha. ");
INSERT INTO noaE_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Magbaawai chi rik nem thʉa chirarr wounau khĩirju sĩi awia, ich ödegpai, “¿Nau mʉ jãga ajuutaa mʉgbaadëma?” ajim anʉm, “mʉg mʉ patronaujã mʉ jʉrbaadëm. Sirphʉg ee thuthui dʉ̈i phidkhaju serbiiba chirʉm. Parhooba sĩi atcha kaaijã ee nem jëeu chitaagjã khaba chirʉm” ajim anʉm ichdëupai ichig. ");
INSERT INTO noaE_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Maimua ich ödegpai, “Ãa, ya mua khĩirju atham” ajim anʉm, “jãga aju mʉch mʉigmua jʉrbapäaiwai õrau amach deg mʉch öbeerpimkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mag khĩirju auwia chadcha ich patronag dëbpaar paraa narr khʉʉn ããbdö thʉ̈rnaa amag jëeu oomajim aajem. Nacharamʉg, “¿Pua maach patronag kharr paraa chirʉ́?” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Magbaawai warmua, “Muan irig cien latas de aceite paraa chirʉmgui” ajim anʉm. Ichig mag jaaubaawai, “Chadcha pua mag aujim; cha sim ag ẽsap” ajim anʉm. “Mamʉ thʉrrëupʉ̈iwia magan jũrr jöpkharraa cincuenta lataspai phã sĩubá; mua pʉrʉg jãrrpai jëeukhim” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Maimua ãbakhai paar sĩerragjã agjö, “¿Puajã kharr maach patronag paar chirʉ́?” ajim anʉm. Magbaawai chi dëbpaar paraa chirarrau, “Mua irig trescientos sacos de arroz paar chirʉm” ajim anʉm. Magbaawai chi khap aag jëeu sĩerrau, “Chadcha pua mag aujimkë” ajim anʉm. “Cha sim ag ẽsap” ajim anʉm. “Mamʉ thʉrrëupʉ̈iwia jũrr doscientos cincuenta sacospai phã sĩubá” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Magbarm khaug athaawai chi patrón jöoirau ich nem aair aba arr woun igwia ich ödegpai, “Jöo, wounan chadcha khĩirjug khaphʉta chirʉma” ajim anʉm. Maimua jũrr ich iek ũr narr khʉʉnagta magjim aajem, ich Jesuu: ’Chadcha Ẽwandam iek ʉ̈khamaaugau amach khõchagpierr wënʉrraajem khʉʉnta Ẽwandam iek ajapha ʉ̈kha khithëem khʉʉn khãyaujã khĩir ubʉcha sĩerrjëemgui ajim anʉm, amach gar õor thereu awaag. ");
INSERT INTO noaE_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pãadë ũrbat. Phatkhonan chadcha nem parhoobam wau nʉmua ganwia nem khaigbam atheejã iigjem. Mag sĩeb mamʉ, pãach phatkhon aauwai õordam dʉ̈i nem ajapha wau nʉmuata am dʉ̈i khapeen khabat ajim anʉm. Maagwai pãach meebarm ed mʉg jẽb gayam nem tag igba aadeewai jũrr ʉ̈gtharjã makhʉʉn dʉ̈ita nʉisiju, Ẽwandamau pãach ʉdʉraa öbeerpibaawai. ");
INSERT INTO noaE_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Woun ãbmua nemdam bʉ̈rʉʉm awia khãijã ajapha ʉʉrkha simʉn, magan nem dʉ̈rrʉ̈ʉm awiajã ich mag ajapha irua wai nʉrraju. Mamʉ nem bʉ̈rʉʉm awia agʉg oomaphamjö warag ʉdʉraa ãrpi simʉn, magan nem dʉ̈rrʉ̈ʉm chará sĩi ãrpijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mʉg jẽb gaai Ẽwandamau pãachig nem deetarrdampaijã ajapha ʉʉrkhaa meraa nʉmʉn, ¿jãga ich aram nem ajapcharam irua pãrag deebarju? Deebamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chikham nemjã pãrau ajapha ʉʉrkhaba nʉm chan, ¿khaíu pãrag ökhar nem jʉ̈apiju arr khãijã jʉ̈apibarju? Jʉ̈apíbamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ni ãbmuajã pöd patronnaan numiim khʉʉn chogkhaju khaba simgui ajim anʉm. Patronnaan numí akhiin, iwiir ãbpaita ʉ̈rcha kha khõsi aju. Ich agjöta simgui ajim anʉm ĩchab Ẽwandam dʉ̈ijã. Pöd pãrau Ẽwandam khĩrag wʉrpanaa phatkhonagjã wʉrpa aju khaba nʉm. Pãar magta nʉm chan pöd Ẽwandam ipierraa khaba nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mamʉ ĩchab aig fariseonaan phatkhon athee bĩe khithëem khʉʉnaupa chi Jesuu iekhamam ũr narr aawai warag i wau iekha naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Magbaawai Jesuu amag iekhamamua, —Pãran, pãachta ʉ̈rcha phatkhon wai nʉm awia Ẽwandam dau najã ʉ̈ucha nʉm aajeebma; mamʉ chadcha Ẽwandamauta pãar thãar khaphʉ simgui ajim anʉm. Mʉg jẽb gayam khʉʉnaun phatkhonta nem thum mʉg jẽb gaai thʉnʉm khãyau ajapcha sim awia agʉgta ee aajerram. Amag mag nem wajaug sĩeb mamʉ, agua nem khaigba waauwaita sĩi ödömie sẽrkha thʉnʉmjö Ẽwandamau khõchkhaba aajemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mag nem jajawagmamua ĩchab ich iek ũr narr khʉʉnag Jesuu magjim aajem: ’Juan õor pör choomieu Ẽwandam i jaauju naweran pãrau Moiseeu iek phã pʉatarr dʉ̈i Ẽwandam i jaaumienau ẽsap phãtarrpai wai naajimgui ajim anʉm, ag gaai jaau sim ipierr wënʉrraag. Mamʉ Juanau iek iiur Ẽwandam aar öbeerpiejemta wai bëejimgui ajim anʉm, chi wajapcharam. Mag jaauchëtarr aigmua atag mag Ẽwandamta chi Pörkhaimʉʉ sim khaug athampierr, ĩsta õor pöm i ipierraa am ig nʉm, chadcha amach Pörkhabaadeewai i dʉ̈i naam khõchgau. ");
INSERT INTO noaE_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mag iek iiur wai naab mamʉ, jöoingar Ẽwandamau Moiseeg ich iek phãpitarran ich warr sĩejerr agtha ich mag serbii sĩerrʉmgui ajim anʉm. Mʉg durr thum edjãpa chugpawiajã jöoingarwe phã pʉatarr iek chan bʉ̈dam ãbjã okhoobamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Magua ĩsjã warrgarmjö dich ʉʉi isegwia deeum ʉʉi aumʉn pekauta wau simgui ajim anʉm; wa deeumua ʉʉi pʉatarr khãijã aumʉn magan agjö pekauta wau simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Maimua ĩchab mʉg nem ĩgkhaadam jaaujim aajem Jesuu: ’Woun ãb sĩejim aajem, rik. Maan sĩi khajũa parhẽpagkham apphata jũajeejim aajem. Maimua mag nʉm dʉ̈i ed ëepierr sĩi nemkhoo jaramjöta thachjã wau khoojeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mamʉ ĩchab woundam aphʉʉ khitʉm Lázaro a thʉ̈r sim sĩejim aajem, sĩi phĩe kha dodoso khitʉm. Mag khitʉmʉn sĩi chi rik puertdi bigaau õor bʉ̈ eeta oo khëraajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mag khërʉmʉn jãsogau chi rik thach khö sim mes eegar pan perasdam khʉimam khöm khõchag khërʉm ee, saakienauta i phĩedau sẽcheejeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mag khitʉʉ awia chi aphʉʉ khitarrdam meejim aajem. Mag meebaadeewai Ẽwandam chognaan bëewia sĩi i akhaardam ʉ̈gthar Abrán sim aar arrjierram aajem. Mag khur chi rikjã ĩchab meebaadeewai bëp sĩuwia khĩmie durrta öbërjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Maimua ya khĩmie durrpanaa maach gaai machag ãwatbajujö thʉnʉmua ʉ̈gthaag oowai dau warpha Lazarota Abrán bigaau khõinaa päar sim oo athajim anʉm, chi rik arrau. ");
INSERT INTO noaE_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Magbaawai mammua thet, “Jöoi Abrán, mʉ ap chitʉm mʉ dau aug khaugbáa” ajim anʉm. “Lázaro jĩgpirdam gaaipai khãijã dödamau omnaa mʉ aar pʉ̈ibapʉ̈ʉi. Ya mʉʉn ö jʉʉumaam. Õt khierr pechag mʉg thʉnʉmjã mua ãwatbajujöta thʉnʉʉmgui” ajim anʉm ääakhamua. ");
INSERT INTO noaE_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mamʉ magbaawai jöoi Abranau irig magjim anʉm warag: “Khĩir eyaa ajuma” ajim anʉm, “pʉch monakha aawai nem khĩir thum paraanaa bʉ̈ʉrjã augchëba chitarr. Maagwai Lázaro bʉ̈ʉrjã magʉm chukhu i dau aphʉʉ khamor masi khërʉmjã pua irig ooba aajeejim. Mamʉ ĩs mʉig i khõinaa bibigag chukhu chirʉm. Jãigta khĩirjujuma ajim anʉm, jãgwia jũrr ĩs pʉ idawaa chirʉ́, õt khierr pechag ee. ");
INSERT INTO noaE_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pua mag chirab mamʉ, pʉ aar pöd mua Lázaro pʉ̈ibamgui ajim anʉm. Magnaa maach jãrr mʉg dö khõrg sĩi jẽb ithurm jaaba wëjömjö sim ee ¿jãga i maju? Jammuajã pöd bëeju khaba, ni maumuajã pöd maju khabamgui” ajim anʉm jöoi Abranau. ");
INSERT INTO noaE_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Magbaawai chi rik arrau warag chaigpa khitʉmua jöoi Abranag, “Magan jũrr mʉ aai di aarta i chogbapʉ̈i” ajim anʉm, ");
INSERT INTO noaE_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","“mʉ khod ãbam khʉʉn cinco phë wai chirʉm aar, mʉ mʉg chirʉm jaaubaimaawai amach khaibag isegwia khĩirjug ajapham aumkhĩir, magbaawai am meem edjã mʉjö mʉgʉm aar gaai machag ãwataan bëem ugua” ajim anʉm, chi rik arrau. ");
INSERT INTO noaE_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Magbaawai Abranau irig, “Mamʉ amau Ẽwandam iek wai naabahab, Moiseeu chi Ẽwandam i jaaumien dʉ̈imua phã pʉatarr. Amau mag gaai jaau sĩsidʉmta ipierraa aju aai naabahab” ajim anʉm, “pʉ sim aar wëtmapha nʉmʉn.” ");
INSERT INTO noaE_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Magbaawai chi khĩmie durr simua magjim anʉm: “Ʉ̈ʉ̈, mag khabam jöoi Abrán. Sĩi phã sim gaaipai chan amau ʉ̈khabam. Mamʉ ãb meetarrta deeu am aar öbërimawia amag jaauwimakhiin chadau, warre amau amach khaibag isegjurau” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Magbaawai Abranau irig magjim aajem: “Mamʉ amau mag Ẽwandam iek chi phãm wai nʉm gaai jaau sim ʉ̈khaba nʉm chan, magan ãb meewia deeu iiu phiidʉwia amag jawaan makhiinjã, amau ʉ̈khabajugui” ajim aajem, chi rik arrag. ");
INSERT INTO noaE_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesuu magjim aajem ich dʉ̈i wënʉrraajerr khʉʉnag: —Mʉg jẽb gaai ichiita ich jãg õor pekau waupiejem nem paraa aju, mamʉ ¡ë, apkhit! ajim anʉm, chi magʉm nem paraa sim woun. ");
INSERT INTO noaE_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Irua magʉm gaaimua chi mʉ iek ʉ̈kha khërʉmta pekau ee burrpimʉn, ichta Ẽwandam dʉ̈i iekkhõr pöoma sĩsiju. Mamʉ mag Ẽwandam dʉ̈ita iekkhõr paarpaju khãai ichdëupai ich ö gaai mokpör pömkham jʉ̈naa phũas ee baudʉkhiin ʉ̈ucha ajugui ajim anʉm Jesuu. ");
INSERT INTO noaE_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Maimua ĩchab, ’Pãrag jaaukhim, khaphʉ abat ajim anʉm, ich Jesuupai. Pãachjö mʉ iek ʉ̈kha nʉm khʉʉnau khãijã pãach dʉ̈i khaigba abaawai warag dʉ̈i agjö aju khãyau sĩi am wawibat ajim anʉm. Maimua amachdëu mag pãach dʉ̈i khaigba abarm khaug auwia pãachig “Mʉ perdonaabá” aawai, am perdonaawia oob tag bʉ̈ʉrjã magʉm iek igmiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ãbam edpai khãijã biek khapan pãach dʉ̈i khaigba awia, “Kakë mʉ perdonaabá, mua tag jãgbaju” a khʉrrkhakha awia khãijã, ich agpierr i perdonaabat ajim anʉm, tag magʉm iek bʉ̈ʉrjã igba. ");
INSERT INTO noaE_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mag dich khapeen perdonaapi jaaubarm phithuurga sim khĩirjunaa, jũrr ich Jesuu chi doce jʉr autarr khʉʉn garmua irig magjierram aajem: —Señor, Ẽwandamau marag khĩirjug deebam chan pöd marau maach khapeen perdonaabaju. Marag juapá deebá ajierram anʉm, mag pʉchdëu jaau simjö aag. ");
INSERT INTO noaE_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Magbaawai maach Pör Jesuu magjim aajem amag: —Pãrau khĩirjuawai chadcha Ẽwandam jua theeg sim khaphʉnaa pãachdëu nem mag abarmjö apiju khĩirjunaata nem waukhiin, Ẽwandam athee chan phithurm nem chukhu aajeewai, chadcha pãachdëu jajaaukhampierr ich mag pãachdëu jaau nʉmjö ajugui ajim anʉm. Pãar khĩirjug oojem anaa chi pömag mostaza daudam ar maach dau ee paba khitaajemjö khãijã khitakhiin, ar pabʉ̈ pöm simʉg wounagamjö, “Jãigmua mawia jũrr achum phũas ee dʉnʉʉubaimá” abaawai, chadcha pãar ipierraa ajugui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mag jaaumamua ĩchab magjim aajem: ’¿Khaíuta ich chog phidkha sĩi awia barbaicheewai ithũu irig, “Ar pʉ athee ya thach mes gaai thöi khërʉm khöbá” aju khai? ");
INSERT INTO noaE_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mag chan ni ãbmuajã iekhabamgui ajim anʉm. Jãan magju khãai warag, “Jöpkhaa phiejãb wauwia mʉ jãogbá, maimua murua nem ig chirʉm thum phëdeebá; pʉchin nau mʉ khö dichtarr khur ẽudeechata khöju” a iekhaju. ");
INSERT INTO noaE_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Pãrau oowai ãbmua ich chognaanau ich ipierraa nem wau nʉm paar “Ʉ̈u ajim” aajẽ? Ʉ̈u ajim chan abam, ich phidag ichdëu nem wauju atarrta wau sĩewai. Irig jaauba akhiinjã ichiita irua waub khaba waujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ich agjöraugui ajim anʉm pãarjã ĩchab: ya Ẽwandamau pãachig nem jaautarr thum wau öbaadeewai sĩi warag, “Maachin Ẽwandam chognaanpaiu; ichdëu maachig jaautarrpierrpai waubapʉ̈im” abat a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mag jaau sĩewia, warag Jerusalenag mamua didichagmajim aajem, Samaria durr Galilea durr dʉ̈i ãba thẽu nʉm jãrr khʉdau ma sim ee. ");
INSERT INTO noaE_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mag mamua phöbördam pöm khaba khitʉm ee dubbaimaawai i khĩirphee õor diez kokobé bënëu bar khithëem öbërdʉtkhachëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mag öbërdʉtkhachëwia warppaimua irig ääakhamua, —Maestro Jesús, maar apdurrum maar dau aug khaugbahur aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ichig dau aphʉʉ mag durrum oobaawai amag, —Jerusalenag ërëuwia Aai i jëeujem deg phadnaanag pãach kha theerhʉ̈chpibat ajim anʉm. Amachig magbaa chadcha i ipierr ërëubaadëjim aajem. Mag wëtumua agtha barba nʉm ee, amach mor oowai kha ajapha magʉm bën chukhu narrjö naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Amach mag oobaawai, ãbmua deeu ewag khaphig urumua onee, “Ẽwandam, ĩsin chadau puan mʉ dʉ̈i ʉ̈uta abarm; pʉjö jua theegkham chan mʉg jẽb gaai chukhum” a ijẽjẽbag bëejim aajem, ich appai. ");
INSERT INTO noaE_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mag bëewi Jesús bʉ̈khʉrr phõbkha jẽbjã gaai dagau dʉrnaa, “Ʉ̈u ajim” ajim aajem irig, ich monaautarr paar. Chi mag Jesuug ʉ̈u ajim aan bëetarr, Samariapierr ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Magbaawai Jesuu magʉg, —¿Pãar chi monaautarr khʉʉn diez naabajĩ? ¿Jam nʉma ajim anʉm tagam khʉʉn nueve? ");
INSERT INTO noaE_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Amach monaautarr paar Ẽwandamag “Ʉ̈u ajim” aju chukhu arrjö, ãba pʉ appaita deeu khitaichëbma ajim anʉm, deeum durramkha chirʉmta. ");
INSERT INTO noaE_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Maimua ichdëupai mag chi kokobé bënëu bar khitarrag, —Phiidʉwia petá ajim anʉm. Mua jaautarr ipierr pʉch ödegpai, “Chadcha i ipierraa amʉn mʉ monaauju” a khĩirjutarr gaaimua, ʉ̈u pʉ peerdʉwia monaaujã monaau chirsim ajim aajem irig. ");
INSERT INTO noaE_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Khãai ãb chi ajapha Moiseeu Ẽwandam iek phã pʉatarr ʉʉrkhaajem khʉʉnau Jesuug, —¿Jãagwaichata mʉg jẽb gaai Ẽwandam maach Pörkha sĩeichëjuwa? ajierram aajem irig. Magbaa Jesuu amag magjim aajem: —Ẽwandam ichta chi Pörkha sĩeichëju chan oob dau daauta bëeju amiet. ");
INSERT INTO noaE_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mua nem wau chirʉm gaaimua pãrau khaphʉ aju aai nʉm, Ẽwandam ya pãach ee sim; magua irua ich jua oopi simgui ajim anaabá, chadcha ichta thum ich iek ʉ̈kha nʉm khʉʉn Pörkha sĩeichëm khap amkhĩir. Maagwai õrau mʉʉgwaiwe chan, “Mʉgá, ar nʉrrʉ́,” wa “Achum ar sĩ” abajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Makhʉʉnag mag jaauwi jũrr ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnagta magjim aajem: —Mʉg atag pãach appai wënʉrrʉm aig, pãrau mʉch chi Emkhooi Iewaa khĩirjuwia khãaidam ãbpai khãijã ũmaai deeu mʉ dʉ̈i wënʉrram khõsi aju. Mamʉ pöd mag wënʉrrabajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mʉg atag õrau pãachig, “Mʉgá, ar nʉrrʉ́, ya bëejimwai,” wa magbam khai “Achum sim” aawai, oob ʉ̈khawia aar oon wëtmiet ajim aajem. Magua pãachig nem jaauwaijã oob am iek ʉ̈khamiet. ");
INSERT INTO noaE_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mʉch chi Emkhooi Iewaa bëewain, thumaam khʉʉnauta mʉ oojugui ajim anʉm, ich jãg pagthʉm dau phʉr jẽer athaawai edjã thum arar athaajemjö. Magua õrau mag pãachig ya mʉ barbaichëm a jaauwaijã oob ʉ̈khamiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mamʉ magju nawe ichiita mʉ dau aphʉʉ aju aai chirʉmgui ajim anʉm, õor mʉg thʉnʉm khʉʉn jua ee, amachdëuta mʉ kha isëe wai wënʉrraawai. ");
INSERT INTO noaE_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mag mʉg atag mʉch chi Emkhooi Iewaa deeu bëeju gayaa paawai, jöoingar jöoi Noé khakhitarr jaar õor döãdau öpäaiwai amachdëu ampierr thʉnaajerrjöta thʉnaajugui ajim anʉm ĩchab. ");
INSERT INTO noaE_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mag jöoi Noé sim jaar õrau amach okhoojujã khĩirjuba, sĩi phiesta waunaa, thach khöwia, dödöjö döju, maimua jua pʉrjuuta khĩirju naajim. Am mag thʉnʉm ee, jöoi Noeeu ichig Ẽwandamau barco pöm waupi jaautarrjö chadcha wau auwia ag ee dubjim. Mag dubbaadeewai döãd pöm bëewia sĩi õor pöm ödubjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maimua jöoi Lod khachitarr Sodoma phöbör ee sĩejeewaim jaarjã ich agjöta thʉnaajim ĩchab. Am khĩirjugan, ãba thach khöju, dödöjö döju, amachdëu nem khõsimpierr aunaa jũrr amach garmua përju, nem jĩirju maimua di ëujupai ajim. Mamʉ mag nʉmjã Ẽwandam gaai khĩirjuju chan aba aajeejim. ");
INSERT INTO noaE_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mamʉ am mag thʉnʉm ee, jöoi Lod Sodoma phöbör eemua öbërbaadeewai ich Ẽwandamau edjã eemua õtdau khĩir khʉipijim. Mag õtdau khĩirta noseg chë thʉnʉmjö khʉi thʉnʉisimua õor thumaa phaa khëchpʉ̈ijim. ");
INSERT INTO noaE_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jãg amachdëu Ẽwandam khĩirjuba thʉnarrjöta thʉnaajugui ajim anʉm ĩchab, mʉch chi Emkhooi Iewaa deeu mʉg jẽb gaai dʉnʉʉubaichëm edjã. ");
INSERT INTO noaE_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mag jaaumamua ich Jesuupai, ’Mag mʉ pierrum ed ãb khãijã ich dihëu ʉ̈r jua ʉ̈i sim khai, ich nem phë awaan awia oob tag ierrag dubam ajim anʉm; wa magba ich phidkhaajem aar khãijã sim khai, oob ich diig khaphig bëem. ");
INSERT INTO noaE_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Khĩir eyaa abat ajim anʉm: ewag oopiba arr ee Lod ũanau sĩi ich nem khĩirjuwia ewag ootarr jũrrpai Ẽwandamau mag ʉʉi thakharag paapʉ̈itarr. ");
INSERT INTO noaE_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ar chi mʉ iek ʉ̈kha sim gaaimua phithurg ãwatmapha sĩi warag “Eeu jãgʉm gaaimua mʉ thõodukham” a khãijã iyʉ̈ʉ sim khʉʉn warreta okhoo simgui ajim anʉm. Mamʉ ar chi mʉ iek gaaimuata dau aphʉʉ khãijã abarm wounan chadau ʉ̈gtharcha öbërjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mag ich khapeenag jajawagmamua, ’Mag mʉ bëewai õor numí ãbam put ee naajugui ajim anʉm. Mamʉ mua ãbpai mʉch dʉ̈i arrwia, ãb werpʉaju. ");
INSERT INTO noaE_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ʉʉinjã numí ĩchab ãbam molin gaai ba naaju. Mamʉ mua ãbpai mʉch dʉ̈i arrwia, ãbakhai werpʉajugui ajim anʉm.  ");
INSERT INTO noaE_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Õor numí agjö di chaaur naaju. Mamʉ mua ãbpai mʉch dʉ̈i arrwia, ãbakhai werpʉajugui a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Magbaawai i khapeenau irig, —Señor, cha purua jaau sim, ¿jampaita magju khai? a jëeujierram anʉm. Magbaa Jesuu amag, —Jampai agá ajujã khaba simgui ajim anʉm. Pãrau khaphʉ nʉm, nemmí sim aig ãkõs ich khĩrau jupcheejem. Ich agjöta ajugui ajim anʉm ĩchab muajã mʉch iek ʉ̈kha nʉm khʉʉn dʉ̈i; am phë arraag mʉch bëem ed am aigta dau daau urum thumaam khʉʉnau mʉ oojugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ĩchab Jesuu ich khapeenag mʉg nem ĩgkhaadam jaaujim aajem, mag jaaubarm gaaimua amachdëu nem ig nʉm Ẽwandamau da deeba awiajã warag pʉaba irig jëeuju aai nʉm a khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mag jaaumamua magjim anʉm: —Woun ãb chi thethem sĩejim aajem, phöbör ee. Magua bʉ̈ʉrjã ich khapeen ögkhaba ni Ẽwandamjã igba sĩerrajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ich ag phöbör eepai ĩchab sĩejeejim aajem, khoopaa ũan ãb. Mag ũanau bëewia irig, “Mʉ ap ʉrrʉm mʉ khaigpërbá” aajeejim anʉm, “mʉ kha ukhurm khʉʉnau mʉ dʉ̈i atcha jãgam ugua.” ");
INSERT INTO noaE_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mag khoopaa ũan dau aphʉʉ ich aig udkhʉrrkhakhakhamjã bʉ̈ʉrjã i iek asekasmapha sĩi awia khãai ãb magjim aajem: “Mua chadcha Ẽwandam igbanaa mʉch khapeenjã ögkhaba chitab mamʉ, ");
INSERT INTO noaE_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","jãg khoopaa ũan tag mʉch aig bëbëe am ugua, mua chadcha i khaigpërjugui” ajim anʉm. “Magba akhiin, irua idëu mʉ khajap chirbajugui” ajim anʉm, “ich ag iekpai phʉʉrba jajaau aawai.” ");
INSERT INTO noaE_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mag ĩgkha dichwia, ich Jesuupai jũrr amag, ’Pãrau ũrjierramgui ajim anʉm, khan a iekhajĩ mag woun chi thethem nem khaibag sĩerrau. ");
INSERT INTO noaE_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Pãrau oowai ich aig bëbëe nʉʉ paawai khoopaa ũan irua khaigpërbajĩ? Ẽwandamaujã ich chaainau ichig edaram magwe jëeu nʉʉ akhiin, irua makhʉʉnjã eeg oob khaba oojugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Magnaa, Mua pãrag jaaukhimgui ajim anʉm. Ẽwandamagta pãrau mag jëeu nʉmʉn, pãar khaigpërm edjã warre irua pãachdëu khõsi nʉmjö aju pãar dʉ̈i. ¿Mamʉ pãrau khĩirjuawai mag mʉch chi Emkhooi Iewaa bëeju ed õor chadcha mag amach thãraucha Ẽwandamag jëeu durrum khʉʉn agtha naaju khai? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Maimua amachdëupai amachta thumaam khʉʉn khãyaujã ajap pekau chukhu khithëem awia jũrr amach khapeen khaibag pheejem khʉʉnag Jesuu mʉg nem ĩgkhaadam jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Chi nem ĩgkhaadam mʉg ajim aajem: —Wounaan numí Aai i jëeujem deg Ẽwandamag jëwaan wëtjim aajem. Ãb fariseo ajim anʉm, Moiseeg Ẽwandamau ich iek phãpitarr ajapcha ʉʉrkhaajem aajem khʉʉn eem, maagwai ãbakhai gobiernoog õrau dëbpaar paraa nʉm jëeujem ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chi ajapcha Moiseeu phã pʉatarr iek ʉʉrkhaajemua bʉ̈jãaupai oo dʉnʉmua, Ẽwandamag jëeu nʉm anʉmta, ichpai thö iekhamamua magmajim aajem: “Ẽwandam, pʉrʉg ʉ̈u ajim a chirʉm, ʉ̈uta jãg mʉ chikhamnaanjö khaba chitʉm. Mʉ amjö nem jĩignemjã khaba, pekau pömjã khaba, ni deeum ʉʉinjã wauba chitʉmgui” ajim anʉm. “Mʉ chan gobiernoog õrau dëbpaar paraa nʉm khʉʉnag jëeujem ar achum simjöjã khaba chitʉm” a iekhamajim anʉm, ichdëupai ich ajaug thöwia. ");
INSERT INTO noaE_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Maimua warag mag jaaupʉ̈pʉ̈igmamua magjim aajem: “Ẽwandam, mʉʉn semanpierr khãai numí thach khöba sʉrkha chiraajem, pʉrʉg jëwaag. Mag nʉm dʉ̈i ĩchab mʉch phatkhondam oopierr ag eem deeb khaba pʉrʉg dee khitaajemgui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Maagwai jũrr chi gobiernoog paar nʉm khʉʉnag jëeujemdam ich appai ag warphaa oothẽu khërʉmua agjö Ẽwandamag jëeu sĩejim aajem. Mamʉ maan, jũrr ichdëupaijã ich pekau pöm khitʉm khaphʉ sĩerr aawai, gaai machgau warag eeg ʉ̈thʉnaa pör jõjõikhamuata maagjeejim anʉm Ẽwandamag: “Ẽwandam, mʉch chadcha pekau pöm chitʉm khap, pʉrʉg jëeu chirʉm; mʉ ap chitʉm mʉ eeg oobá” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mag numí Ẽwandamag jëeu narr khʉʉn jaau dichwia, chi aig ich iek ũr narr khʉʉnag magjim aajem: ’Ichdëupai Ẽwandamag ichta chi ajapham a chirarr khãyau, ich dau aug khaugpi jëeutarr wounta jũrr Ẽwandam dau na ag najã ich mag bʉ̈ʉrjã khaibag chukhu aajerrjöo sĩebahab ajim anʉm. Mamʉ ar amach thöwia chikham dʉ̈i athuucha aajem khʉʉn, jũrr mʉg atag paawai am Ẽwandamag chaigpa oo sĩsidʉ abarjugui ajim anʉm. Maimua ar mag amach dʉ̈i athuu nʉm khʉʉn ichaaurjã magʉm aba sĩi warag serbiibamjö aajerr khʉʉnta, jũrr mʉg atag paawai, Ẽwandamau warm khʉʉn khãyaujã ʉ̈rpai apiju a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Biek ãb mag jũrram khʉʉnau aaunaan Jesús sim aig wai bëe nʉm ee, chaainpa chi dënnaanau aibëe naajim aajem, am gaai pʉrnaa Ẽwandamag am kõit jëeumkhĩir. Mamʉ mag jũrram khʉʉnau chaain aibëbëekham oowia jũrr chi Jesús dʉ̈i ogdʉba wënʉrraajerr khʉʉnauta mag chi aibëe nʉm khʉʉnag meeurrau sĩujierram aajem, tag aibëepimaaugau. ");
INSERT INTO noaE_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mamʉ amau mag nʉm ee, warag Jesuu chi chaaindam thʉ̈rkhanaa jũrr ich khapeenagta, —Idëu chaain mʉ aig bëepibat ajim anʉm. ¿Khanthee pãrau amag bëepiba jaau nʉ? Chi jöoin awiajã chamʉ khʉʉn chaainjö mʉ iek ʉ̈khakharrsö ʉ̈kha nʉm khʉʉnta mʉg jẽb gaaijã ʉ̈u wënʉrrawia, ʉ̈gtharjã onee wënʉrrajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mamʉ chi ʉ̈gthar öbërju khĩirju nʉm khʉʉnaujã mʉkhʉʉn chaain dënjö ʉ̈khabam chan pöd öbërbamgui ajim anʉm. Mua pãrag mag jaau chirʉmʉn chadcharam iekta jaau chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Biek ãb Jesús sim aig woun ãb chi thethem bëejim aajem, phatkhon paraam. Mag wounau irig, —Maestro, pʉʉta chadcha Maestro ajapham aawai pʉrʉg jëwaan bëejim: ¿Mua khani jãgju aai chirʉ́, ʉ̈gthar öbëraag? Mʉrʉg jaaubá aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Magbaawai Jesuu irig, —¿Khanthee pua mʉrʉg “chi ajapham” a sĩ? Õor ajapham chan chukhumgui ajim anʉm. Ajaphamʉn ãba Ẽwandamta ich appai ajapha sĩerrʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿Pua khaphʉ sĩebá ajim anʉm, Ẽwandamau Moiseeg ich iek phãpitarr gaai: “Oob dich õor khabam dʉ̈i khapes am; oob õor thõom; oob nem jĩgkham; oob chikham ëugarjã sëukha nem ĩgkham; maimua pʉch aai jãsenkhanaa pʉch ãdjã jãsene abá” a sim? ");
INSERT INTO noaE_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Magbaawai chi woun phatkhon paraamua, —Mag pua jaau sim thum mua mʉch bʉ̈rʉʉwe ʉʉrkha chitabahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesuu i mag iekha sim ũrbaawai irig, —Mamʉ agtha khĩir ãb pua waaur wai sĩebahab ajim anʉm. Pʉch nem thum përkhʉʉipʉ̈iwia chi phatkhon aphʉʉ khithëem khʉʉnag jigbapʉ̈i. Maimuan chadau mʉ ẽudee pidú ajim anʉm, mʉ dʉ̈i chitam khõsi chirʉm khai. Pua magmʉn, ʉ̈gthar pawiajã bʉ̈ʉrjã augchëba, phatkhon khãaijã nem ajapham pömta wai chirsijugui ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mamʉ Jesuu ichig mag nem thum përkhʉʉiwia chi phatkhon jigpi jaaubaawai, warre chi woun ökhĩirjuu aadëjim anaabá, chadcha phatkhon paraam arr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesuu oowai mag ichdëu nem jaaubarm gaaimua atcha ökhĩirjug pöm aadëm oowi, —Phatkhon paraam khʉʉnta Ẽwandam chi Pörkha sim aar öbëraagan chadcha thethe simgui ajim anʉm, amach phatkhonagta ʉ̈rcha ee naawai. ");
INSERT INTO noaE_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Phatkhonpanta ʉ̈gthar Ẽwandam chi Pörkha sim aar öbërju khãyau, camello pöm jãg maach wounaan khãaijã ʉ̈rpai sĩerrʉmta phithurg chukhu nobeeu kachdam ee thoogar öbër dichjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesuu mag iekhabarm ũrbaawai aig chi ũr narr khʉʉnau, —Mag khai, magan ¿khaita peerdʉagáwa? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Magbaawai Jesuu amag magjim aajem: —Õragan chadcha phithurgma mag ũurwai, mamʉ Ẽwandamag chan bʉ̈ʉrjã phithurg chukhu simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Magbaawai Pedroou irig, —Maraun chad pʉ dʉ̈i wënʉrram khõchgau maach nem wai narrjã ewag khĩirjuba, sĩi thum phëpʉawi pʉ dʉ̈i ogdʉba wënʉrrabma ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Magbaa ich Jesuu magjim aajem: —Chadcha ar thum chi mʉ gaaimua wa mʉ iek jaaum khõchgau khãijã amach di pʉawia, amach dënnaanjã pʉanaa, amach khodnaan, amach ʉʉin wa amach chaain khãijã khaugba khũchpaim athee phëpʉpʉakham khʉʉnagan chadau, ");
INSERT INTO noaE_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mʉg jẽb gaai agtha nʉwejã mag amach nem okhoomarr khãaijã ʉ̈r ag atcha deewi mʉg atagjã mʉch dʉ̈ita ich mag wënʉrramkhĩir mʉch aarcha phë aujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Maimua ich dʉ̈i doce ogdʉba wënʉrraajerr khʉʉn chaaur khĩet phë arrwia amag magjim aajem: —Pãrag khap amkhĩir mua warre jaaukhimgui ajim anʉm: Pãrau khaphʉ nʉm, ya maach Jerusalenag wëtum. Jerusalén barbaimaawai warrgarwe Ẽwandam i jaaumienau mʉch chi Emkhooi Iewaa igwia phãtarrjö thum ag eyaa öbërjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Magbaawai makhʉʉnau maach meeun khabam khʉʉnag mʉ pʉr deejugui ajim anʉm. Magbaawai makhʉʉnau mʉ wau iekhamam dʉ̈i mʉ khĩir iekhanaa mʉ gaai ichöpa thumaju. ");
INSERT INTO noaE_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Magnaa mʉ wʉ wai nʉʉ awia amau mʉ thõopʉ̈ijugui ajim anʉm. Mamʉ khãai thãrjupam ee deeu mʉ iiu phiidʉju a jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mamʉ i mag iekhabarm amachdëu bʉ̈ʉrjã khaugba, ich mag nʉisijim aajem. Amau ũurwai, Jesuu sĩi parhooba ichdëu iekha simjã khaugbata iekhabapʉ̈imjö ũrpʉ̈ijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús ich khapeen dʉ̈i mag mamua phöbör Jericó anʉm dakha paaukhabaimaawai woun ãb dau khĩsu khitʉm khʉd igaau oo khërʉm ooimajierram aajem, õor ërëu dich thʉnʉm khʉʉnag nem jëeuwai. ");
INSERT INTO noaE_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mag dau khĩsu khitʉmua õor pöm ich aig ërëu dich thʉnʉm khaug athaawai jëeujim aajem, khan jãgwiata mag thʉnʉm khai a khap aag. ");
INSERT INTO noaE_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Magbaawai ãbmua irig, —Jesús, Nazaretpierrta dich nʉrraawai khabahab mʉg õor pöm sereu wëtum ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Magbarm bʉ̈rre chi dau khĩsu khitʉmua thet ääakhamua Jesuug, —¡Jesús, pʉʉta rey David khachitarr ag chaain ewagam khʉʉn Iewaau marau nʉ narr! Mʉ ap chitʉm mʉ dau ee aug khaugbahur aajeejim anʉm, ich dau monawaan bëemkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Magbaawai chi na wëtmaa arr khʉʉnau irig meeurrarrau aajeejim anaabá, khĩupamkhĩir. Mamʉ magbaawai chará waragta, —¡Jesús, pʉʉta rey David khararr ag chaain ewagam khʉʉn Iewaau marau nʉ narr! Mʉ ap chitʉm mʉ dau aug khaugbahur aajeejim anʉm, thet khĩesirnaa. ");
INSERT INTO noaE_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mag ääakham ich Jesuu ũr athaawai dʉnʉisiwia awaan mapijim aajem, ich aigcha aibëemkhĩir. Mag ich aigcha aipierrwai irig, ");
INSERT INTO noaE_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Khani pua mʉrʉg pʉch dʉ̈i apim khõsi chirʉ́? ajim anʉm. Magbaawai chi dau khĩsu khitʉmua, —Señor, muan pʉrʉg mʉch dauta monaaupim khõsi chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Magbaa Jesuu irig, —Magan dau eerdʉbaad ajim anʉm. Chadcha muata pʉch monaaupʉ̈iju khĩirjutarr gaaimua, ʉ̈u pʉ peerdʉwia monaaujã monaau chirsimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesuu magbarm bʉ̈rre chadcha dau eerdʉ sĩsiwia ich bi eem daujö daujã ajaug sĩsijim anaabá. Magbaawai warag i dʉ̈i mamua onee Ẽwandamag jëeumamua, —Ẽwandam, ĩsin chadau pua mʉ ʉ̈uta abarm. Pʉjö jua theegkham chan mʉg jẽb gaai chukhum a ijẽjẽbag majim aajem. Jesuu mag woun dau monaaubarm oobaawai ĩchab mag õor khapan thʉnarr khʉʉnaujã Ẽwandamag jëeumamua irig “Ʉ̈u ajim” ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mag wëtumua ya phöbör Jericó anʉm dakha narr aawai warag Jesús ag phöbör ee dubwia dichmaa ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mag phöbör ee sĩejim aajem woun ãb phatkhon paraam. Ma, Zaqueo ajim aajem, õrau gobiernoog dëbpaar paraa nʉm jëeujem khʉʉn pör. ");
INSERT INTO noaE_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mag wounau Jesús khĩir oog ẽkhaajeejim aajem, mag õor pöm wëjöm eemua. Mamʉ jöointa bʉthʉ khitarr aawai pöd ooba aajeejim anaabá, bʉ̈ dʉ̈rr khabam gaaimua. ");
INSERT INTO noaE_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mag warm khʉʉn pör ʉ̈rmua ichdëu pöd ooba abaawai, na khaphig mawia, pabʉ̈ jeeubahkhar neneree khitʉm gaai waaidʉwia nʉbaadëjim anʉm, ich eegar dichpinaa oog. ");
INSERT INTO noaE_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mag i pa gaai ʉ̈gthaa simta, Jesuu bëewia, ʉ̈gthaag oonaa, i thʉ̈r thʉ̈rnaa irig, —Zaqueo, jöpai eeg ʉʉrbabaad, maimua marrau; ĩsin mʉʉn pʉ aigta jẽerimajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Magbaa chadcha jöpkharraapai ʉʉrbawia, Zaqueoou onee Jesús ich di aar athaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mamʉ chi dʉ̈i wënʉrrarr khʉʉnau oowai, Jesús Zaqueo degta jẽerimaag waaidʉbaadëm oobaawai, thumaam khʉʉnau, —Keena, pãadë oobat. Jesuun, pekau pöoma sim degta waaidʉbaadëmwai anaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Magbaawai Zaqueoou maach Pör Jesús khĩirphee bʉ̈jãau dʉnʉʉunaa irig thumaam khʉʉn dakhĩir, —Ũrbá, mua mʉchdëu nem wai chirʉm eem jãrrcha ar aphʉʉ khithëem khʉʉnag deejugui ajim anʉm. Maagwai iwiir ãbam dën khãijã sëukhawi mua phatkhon khũgur autarr khai, jũrr mua ag khãyau ʉ̈r biek jayap deejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Magbaawai Jesuu irig magjim aajem: —Zaqueo, pʉjã ĩchab jöoi Abrán khararr ag chaain ewagam khʉʉn dënëu, mamʉ ĩsta pua irua ʉ̈khaajerrjö ʉ̈kha chirsimgui ajim anʉm. Mag gaaimua ĩsin chadau pʉchjã peerdʉwia, mʉg degam khʉʉnpa peerdʉju ed pabaadëm. ");
INSERT INTO noaE_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mʉch chi Emkhooi Iewaan chadcha õor amach khaibag gaaimua okhoo khithëem khʉʉn jʉrwia, peerdʉ awaanta bëejimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesuu Zaqueo dʉ̈i ãba nʉmua iekhatarr ũrwia thumaam khʉʉnau khĩirjuawai, Jesuuta Ẽwandamau pʉ̈itarr aawai, Jerusalenmua ya ichta thumaam khʉʉn Pörkhaagpampii naajim anaabá. Mamʉ mag nʉm ee ya chi Jerusalén phöbör dakha narr aawai, amau mag ajappai khaugba khĩirju nʉm ajapha khap amkhĩir, amag mʉg nem ĩgkhaadam jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mag ĩgkhamamua amag magjim anʉm: —Woun ãb sĩejimgui ajim anʉm, thethem iewaa. Ma, ich thʉ̈rbapäaiwai, deeum durr majim aajem, jua theeg apiwia reikhapieg. Mamʉ mag mawia iin deeu bëeju ajiebma. ");
INSERT INTO noaE_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mag chadcha ya ich maagpamua ich chognaan diez thʉ̈rkha auwia, phatkhon agdaujö amachpierr dʉ̈rrcha jigpʉ̈iwia, “Mʉg phatkhon mua pãrag jig pʉa chirʉmʉn, mʉch bëe nʉm ora agua phidkhawia warag ʉ̈r aumkhĩrau” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mamʉ mag woun ich dʉ̈i ãbam durr ee naajem khʉʉnaupaijã i kha khõchkhaba aajeejim aajem. Maagjerr aawai i petam ẽudee õor pʉ̈iwia makhʉʉn dʉ̈i, “Pʉ chan marau maach durr reikhapimapha nʉm” a jaaupʉ̈ijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mamʉ amau mag nʉm ãba, deeu bëewia, ichta ya thumaam khʉʉn rey khabaicheewai, mag ich maagpamua phatkhon jig pʉatarr khʉʉn deeu thʉ̈rkhʉʉipʉ̈ijim aajem, ich phatkhon jigtarrau phidkhawia chi ʉ̈rʉm aumatarr khap aag. ");
INSERT INTO noaE_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Magbaawai chi nacha deetarr bëewi, “Rey, cha khërʉm pʉ phatkhondam. Pua mʉrʉg deetarrau jũrr mua ag ʉ̈r diez veces gan aujim” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Magbaawai chi reíu irig, “Ʉ̈u khërʉm” ajim anʉm. “Pʉ chadcha piyón ajaphamʉu. Mʉg phatkhon pöm khaba deetarrau pua jãgbarm khai, jãgan jãgtarr jũrr mua pʉrʉg phöbör diez deekhimgui ajim anʉm chi reíu, pʉchta ag eem khʉʉn gobernador khamkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Magbaawai ãbmuajã bëewia, irig, “Rey, cha khërʉm pʉ phatkhon” aichëjim anʉm. “Mʉrʉgjã pua dee pʉatarrau cha mua ag ʉ̈r cinco veces gan wai chirʉm” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Magbaawai ĩchab magʉgjã chi reíu, “Puajã jãgan phöbör cinco jʉ̈ajugui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Thumaam khʉʉnag mag jëeukha oomam aawai deeum thʉ̈rpʉ̈ijim aajem. Magua paawai bëewia magchëjim anʉm: “Rey, pua mʉrʉg phatkhon deetarr mua sĩi putdam ee pʉrëunaa ãkha khërjim, akhoom ugua. Magtarr aawai cha sim” ajim anʉm “pʉ phatkhondam, ich agpierrpai. ");
INSERT INTO noaE_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mua pʉ phatkhonau bʉ̈ʉrjã phidkhabajim, pʉch jãg õor dʉ̈i atcha athuu sĩerrʉm khaphʉ chitaawai. Mua agua phidkhawia gantarr akhiin, chi ʉ̈rʉm pua sĩi khecheu aukhamgui” ajim anʉm, “pʉ dën sĩi chikham jua phithur atarrta pʉch dënjö aadëp aajeewai.” ");
INSERT INTO noaE_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Magbaawai chi reíu magjim aajem irig: “Pʉʉta mʉ chog chi khaigbampama. Pʉ gaaita thumaam khʉʉn khusëugan thʉnʉm. Pʉch iiupaita pua mʉ mag jaau chirʉm khai, magan muajã pʉ dʉ̈i pʉchdëu jaau simjö ajugui” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“Pʉ iek mag mʉ athuuchanaa chikham phithurg wautarrta mʉch dënjö aajem anʉpí, ¿jãgwi mʉ phatkhon banco ee deen mabajĩ” ajim anʉm, “mʉch bëewai ʉ̈rʉʉpai bãau sim oochëmkhĩir?” ");
INSERT INTO noaE_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Maimua jũrr thum aig narr khʉʉnag magjim aajem chi reíu: “Jãg ichig deetarrpierrpai wai sim dën khecheunaa, jũrr ar ichig deetarr ʉ̈r diez gan autarragta deebat” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Magbaawai chi aig narr khʉʉnau chi reíg, “Rey, mamʉ ya irua nem pöm wai sim. ¿Khanthee tag irig deeju aai sĩ?” ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Magbaa chi reíu, “Mua pãrag jaaukhimgui” ajim anʉm. “Ar mʉ athee nem wawaag nem par daúa ooba aajem khʉʉn dʉ̈in mua mʉch garmuajã ajapha aju, amau chokhõgba mʉ athee nem wau naawai. Mamʉ ar mag nem waumapha nʉm khʉʉn dʉ̈i chan magba, mʉchdëu amag nem deetarrjã warag am jua eem khecheu aumaju. ");
INSERT INTO noaE_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maimua ĩchab ar chi mʉ khĩir oomaphanaa mʉrʉg amach reikhapimapha narr khʉʉn, mʉig mʉ aig aubëenaa mʉ dakhĩir khëchbapʉ̈it” ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mag jaau dichwia Jesús Jerusalén phöbörög petajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mag mamua phöbör Betfagé anʉm dʉ̈i ãb agjö Betania anʉm dakha durrsĩ Olivo anʉm aar barbaimaawai ich khapeen eem numí thʉ̈rkhanaa pʉ̈yaagpamua amag magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Achá maach khĩirphee phöbördam sim ee ërëubaadët. Nau chi phöbör ee dub nʉm aig pãrau burrodam pa gaai jʉ̈ khërʉm ooimaju. Mag burro gaai chan agtha ni ãbmuajã waaidʉba khitʉm. Ma ẽer aipidut ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ãbmua khãijã bëewia pãachig, “¿Khanthee jãg nemchaai ẽer arraag ẽkha nʉ?” a jëeubaawai, sĩi ithũu irig, mua ig chiraawaita arrum abat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mag jaaubaawai ërëubaadeeu chadcha amachig jaaupʉ̈itarrjöo ooimajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mag oobaimaawai ya chi burrodam aibëeg ẽer nʉm ee, chi papkhʉ bëewia amag, —¿Khanthee pãrau mʉ nemchaai ẽer warrúma? aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Magbaawai amachdëu irig, —Maach Pör Jesuu ig naawaita marau arrubahab ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mag chadcha Jesús aig chi burrodam aibëewi, amach khajũa jũa nʉm ʉ̈r joothʉ jũajem manto anʉm ẽerkhanaa, jũrr chi burro phõ ʉ̈r theernaa, ag ʉ̈r chi Jesús jiirpʉ̈ijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Magbaawai ĩchab warm khʉʉn am dʉ̈i wënʉrrarr khʉʉnaujã agjö mag manto joothʉ jũa narr ẽerkhanaa i maju khʉd ee theerkhamajierram aajem, ichta chadcha am Pöröu awia. ");
INSERT INTO noaE_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Maimua ya durrsĩ Olivo anʉm aigmua ʉʉrba nʉm dakha aadëm ee, õor pöm i ẽudee onee pos wëdurum khʉʉnau amachdëu ag na mag nem ooba aajempa Jesuu waumaajem oojem khĩirjunaa Ẽwandamag jëeu nʉmua ĩchab “Ʉ̈u ajim” a serereu khaphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mag Ẽwandamag jëeu nʉmua, —Ʉ̈ucha abarm Ẽwandam; ich mʉʉta pʉchdëu pʉch jũrr maar Reikha pʉ̈ibarmʉugui ajierram anʉm. Mʉg Rey pʉ̈ibarm gaaimua pʉchdëu jʉr aumam khʉʉnan ʉ̈gtharm magwe pʉ dʉ̈i khõinaa wënʉrraju. Ʉ̈u abarm Ẽwandam. Pʉjöm chan ãbjã chukhumgui ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mag õor pöm wënʉrrʉm ee ĩchab chi fariseonaanjã dʉ̈i wënʉrrarr aawai, mag õor serereukham ũrwia, Jesuug magjierram anʉm: —Maestro, ¿jãgwia pua pʉch igar nʉm khʉʉnag iekhabama, khĩupagkhamkhĩir? ");
INSERT INTO noaE_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Magbaawai ich Jesuu jũrr amag, —Mamʉ amau mag nʉm chadcha khabahab ajim anʉm. Õor mag serereukham khʉʉnag mua iekhabaawai am chadcha khĩuu nʉisikhiinjã, jũrr ar mokdau thʉnʉmua amau serereukharr iekpai wounaan dënjö sereu phöbaadëbajup ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mag wëtumua ya chi Jerusalén phöbör dakhacha aadeewai, phöbör eerpa wai sĩi awia, thumaa khĩirjuwia Jesús bĩebaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mag bĩemamua chi phöbörpien igwia magjim anʉm: —¡Ë, Jerusalenpien! Ẽwandam dʉ̈i pãach khõinaa wënʉrramkhĩir pãachig mua jaaujerr iek pãachdëu isegtarr, ĩs mʉgnaa khãijã deeu ãsie thumaa khĩirjuwia igkhiin, pãar ʉ̈u peerdʉkhamgui ajim anʉm. Mamʉ khanii magʉm iek pãar khĩirjug ee barjupa. ");
INSERT INTO noaE_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pãar jãg nʉʉ awi pãar öju ed barbaicheewai, pãach oomapha aajem khʉʉnau sĩi pãar phʉʉrthuur auchëwia, phöbör igaau warpham magwe pãar öbërm ugua thuur phʉʉrdʉpʉ̈ijugui ajim anʉm. Magnaa pãar öbeerwaim athee oopaar aju, ");
INSERT INTO noaE_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","pãar thum khëchpʉ̈pʉ̈igmamua ni ãbjã bʉ̈ ëuhëu khitʉm ooba sĩwaag. Magbarm aigmua atag di jãg ãbam ʉ̈r joothʉ ëu sĩsidʉmjã tag pãrau ich jãg oobajugui ajim anʉm, Ẽwandamau ich garmua pãach oon bëetarrjã warag i isegtarr gaaimua. ");
INSERT INTO noaE_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Maimua chi Jerusalén phöbör eecha pachëwia, Ẽwandamag jëeujem deg dubwia, ag ee tiendegamjö nem për narr khʉʉnag magjim aajem Jesuu: ");
INSERT INTO noaE_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Ẽwandamau ich igwia ich iek gaai, “Mʉ diin sĩi mʉrʉg jëeujem diiu” a sim. Mag simta pãachdëuta ag ee mʉg nem parhẽpag për nʉmua sĩi chikham khũguurjem dikha wai naabma ajim anʉm. Mag warag meeurraunaa dawag jʉrkhʉʉipʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Magtarr khurjã ed ëepierr ich ag Ẽwandamag jëeujem degpai õrag Ẽwandam iek jaaujeejim aajem. Mamʉ chi phadnaan pörkha nʉm khʉʉnau chi machnaan dʉ̈imua, phöbör eem khʉʉn chi thethemnaan dʉ̈imua meraa i thõopäaig ẽkhaajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mamʉ pöd i chig aju khaba aajeejim aajem, õor pöm thʉnʉm khʉʉnau sĩi ãba i iek ũrm khõchgau bʉ̈ʉrjã i kha ogdʉba aajerr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Khãai ãb Jesús Aai i jëeujem deg dubwia õrag jaau sĩejim aajem, jãga Ẽwandamau am peerdʉ auju. Irua mag jaau sim aig, phadnaan chi pörkha nʉm khʉʉn bëejierram aajem, chi machnaan dʉ̈i judionaan am Asamblea eem chi pörnaanpa. ");
INSERT INTO noaE_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mag bëewia irig, —¿Khai thöwiata jãg mʉig nem për narr khʉʉn pua dawag jʉr wërppʉ̈ijĩ? ¿Khaíuta jãg pʉrʉg pʉchta nem iek theeg apijĩ? Marag jaaubá ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Magbaa Jesuu amag magjim anʉm: —Magan nacha mʉrʉg jaaubat. Muajã ĩchab pãrag jëeu ookhimgui ajim anʉm: ");
INSERT INTO noaE_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Pãrau khĩirjuawai, ¿chadcha Ẽwandamauta Juan pʉ̈ijĩ ajim anʉm, jãg amach khaibag Ẽwandamag chugpaapi jaaunaa õor pör choo nʉrramkhĩir, wa sĩi mʉg jẽb gayam khʉʉnau chogpʉ̈iwiata jãg nʉrrajĩwa? ");
INSERT INTO noaE_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mamʉ mag irua jëeubarmjã pöd ʉ̈khaju khaugba aawai amach appai iyʉ̈ʉ nʉmua amach wir aigpai, —Keena, maadëu irig Ẽwandamauta pʉ̈ijim akhiin, magan jũrr irua maachig, “Jãg magʉmta pãrau irua jaau nʉrrarr ʉ̈khabajierráma” ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wa magba maadëu jũrr, “Ichjöm khʉʉnaupai pʉ̈iwiata jãg nʉrrajim” akhiin, magan õor pöm mʉg thʉnʉm jũrr maach dʉ̈ita meeukhawia, mokou bar wai nʉmuapai maach khëchpʉ̈ijugui ajim anʉm, mʉg phöbör ee thumaam khʉʉnau i igwia, “Chadcha Ẽwandam i jaaumie chaar” aajeewai. ");
INSERT INTO noaE_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mag jaauju khaugba naawia warag, —Marau khaugbam jammuata bëejĩ, ni khaíu pʉ̈iwiata jãg nʉrrajim khai ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Magbaawai Jesuu amag magjim: —Mua pãrag jëeutarr mʉrʉg jaauba aawai muajã pãrag jaaubamgui ajim anʉm, khai thöwiata mua mʉg nem wau chitʉ́. ");
INSERT INTO noaE_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Maimua mag õor pöm thʉnʉmʉg mʉg nem ĩgkhaadam jaaumamua magjim aajem Jesuu: —Woun ãbmua uvadö jĩirjim aajem. Maimua ich chawag mam khõchkhabaadeewai deeum khʉʉnag alquilaapʉ̈iwi, warp deeum durr petawia, mam sĩi aimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mam mag simua ya chee jaar aadëm ee, ich chog pʉ̈ijim aajem, mag dʉ̈i ichig ich paatëm deepʉ̈imkhĩir. Mamʉ mag chi nemjĩir khʉ jöoirau chogtarrdam amach aar barbaimaawai, pʉrnaa, wʉ wai nʉʉ awia, sĩi deeu ich jua kharraa jʉrbapäaiwai, ich juadam parii barjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Magbaawai jöoirau deeum pʉ̈ijim aajem, ich chog. Mamʉ majã amach aar oo barpinaa, parhooba i wau iekha wai nʉʉ awia, warm khãyaujã ʉ̈rʉʉpai wʉnaa, agjö ich jua kharraa jʉr werbajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mag majã ich jua parii barbaimaawai deeum pʉ̈ijim aajem jöoirau. Mamʉ machará mag wʉ wai nʉmua, sĩi maach ëu pöm pepethor aadëmua, bag kha ʉ̈ʉipabaadeewaita ogdʉpʉ̈iwia, jʉrpʉ̈ijierram aajem, ni bʉchkhunpai deejöjöojã khaba. ");
INSERT INTO noaE_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Magbaawai ich jöoi chi uvadö ag papau khĩirju sĩi awia, “¿Mua jãga abarkhiina?” ajim anʉm. Mag khĩirju sĩi awia, “Ãa, jãgan mua mʉch iewaa mʉchdëujã chig aba aajemta pʉ̈ijugui” ajim anʉm, “Tale amau mʉ chaai oophöbaadeewai i ögkhawia i chig abaju” awia. Mag chadcha ich chaai pʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Maimua mag jöoirau ich iewaa ichdëu jãsenecha aajemta pʉ̈iwia urum oobaawai amach appai magjierram anʉm: “Achamʉ́ i iewaa aawai mʉguata mʉg atag mʉg nemjĩirjã jʉ̈aju khabahaba. Keena, jãgan maadëu warre i thõopʉ̈ijugui ajierram anʉm, mʉg nemjĩirdö maach dënkha sĩsimkhĩir.” ");
INSERT INTO noaE_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mag chadcha ʉʉr barchëpinaa, pʉrphöbaadëwi, warp nemjĩirdö igaau arrnaa, mam thõopʉ̈ijierram aajem, ich jöoi iewaa ãba. Mag nem ĩgkhaadam ĩgkha öpʉ̈iwia õrag magjim aajem, ich Jesuupai: —Pãrau khĩirjuawai, ĩsjã agtha mag uvadö sim anaa chi thʉa narr khʉʉnjã ich akhʉʉnpai akhiin ¿jãgaju khai jöoirau magʉm wounaan dʉ̈i? ");
INSERT INTO noaE_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Par irua ich chaai ãbpai khitʉm pʉ̈itarrpata mag thõobapʉ̈im oobaawai, mawia, warre amach thum khëchpʉ̈inaa, ich uvadö jũrr deeum khʉʉnagta jaau pʉabjëjugui ajim anʉm, ichdëupai. Amach jʉ̈g daar Jesuu mag iekhabapʉ̈im ũrbaawai chi aig narr khʉʉnau, —Aay, Ẽwandam, ¿khanthee pua magbaadëju? ajierram aajem, mag uvadö jaau sim gaaimua Ẽwandamau amachta jaau sim khaphʉ narr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Magbaawai Jesuu am khĩir eerpa eerpanaa amag, —¿Khan aawaiuma ajim anʉm, Ẽwandam iek phã sim gaai ar “Di ëu narr khʉʉnau isegtarr dibigta jũrr chi dihãd jãrramkha sĩsim” a sim? ");
INSERT INTO noaE_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Magnaa ichdëupai, Mag dihãd a simʉn mʉ igwiata mag simgui ajim anʉm. Chi mʉ iek ʉ̈khaba sim wounan juau ogthom mag dibig ʉ̈r burrwi ichdëupai ich gaai mas wau simjöta sim; maimua mag ʉ̈khaba nʉrrʉmta meemʉn jũrr mʉ mag dibig pömaamjö chirʉmta i ʉ̈r buudimamjö ajugui ajim anʉm. Jesuu mag sĩerran mag i iek ʉ̈khaba meebaadeewai warre khĩmie durr barpʉ̈ijuuta jaau sĩejim. ");
INSERT INTO noaE_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Irua mag uvadö thʉa narr khʉʉn khaibag sĩsid arr jaau sim gaaimua, phadnaan chi pörkha nʉm khʉʉnau chi machnaan dʉ̈imua khaug athajierram aajem, Jesuu amachta jaau sim. Magbaawai ag bʉ̈rre i pʉr aum igphöbaadëjim aajem. Mamʉ mag i pʉr athaawai phöbör eem khʉʉnau jũrr amachta khaigbaju khĩirjuwia i dichbajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mag amach dʉ̈ita õor meeukhapiju khãai sĩi õor jʉr auwia chi Jesús sim aar pʉ̈ijierram aajem, makhʉʉnau chadcha khaugba aawaita irig jëeu nʉm awia jëeubaimaawai, jaauju khaugba ipeerdʉ khãijã jaaubapäaiwai, magʉm gaaimua gobernador aar i pʉr arraag. ");
INSERT INTO noaE_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mag ërëuwi chadcha irig maguimajierram aajem: —Maestro, marau khaphʉ nʉmgui ajim anʉm, pua chadcha nem agchata jaaujem. Pua mag õor iwiir ãbpaita ʉ̈rcha kha khõsijã khaba, ante pua chadchata thumaam khʉʉnag jaaujem, jãgata aju aai nʉ Ẽwandamau nem jaau sim eyaa wënʉrraag. ");
INSERT INTO noaE_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Magua marau pʉrʉg jëeum ig nʉmgui ajim anʉm: Pua oowai ¿chadchata maach meeun judionaanaujã durrpierram khʉʉn rey Roma sĩejemʉgta impuesto phagju aai nʉ, wa phagju khaba nʉwa? ");
INSERT INTO noaE_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mamʉ Jesuu mag sĩi ich imeraa pʉr awaagpaita ichig jëeuchë nʉm khĩirjugjã khaphʉ sĩerr aawai amag magjim anʉm: —¿Khantheeta pãrau sĩi imeraa mʉ pʉr auju ẽkha nʉma? ");
INSERT INTO noaE_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Daai mʉrʉg phatkhon chi dau daí jʉr deebat, mua pãrag jaaukhimgui ajim anʉm. Maimua au deebaawai amag, —¿Khai khĩirta khai thʉ̈r dʉ̈i ag gaai sĩ ajim anʉm, pãrau oowai? Magbaawai amachdëu, —Romaam rey César khĩir khabahab ajierram aajem, ich thʉ̈r dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Magbaawai deeu ichdëu amag, —Pãrau mag khaphʉ nʉm khai, magan reíg ich paat deenaa Ẽwandamagjã agjö ich paat deebat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mag amachdëu jëeubaawai i ipeerdʉ iekhabarm gaaimuapai phithurg chukhu i pʉr awaan a bëetarrta, warag ich garmua amachig mag jaaubarm ũrwia sĩi jʉ̈gderraa nʉm iekhau warag amachta khĩu nʉisijim aajem. Mag, pöd i pʉr aubajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mag khur Jesús aig bëejierram aajem Saduceonaan. Makhʉʉnau jaauwai, maachta meebaadëm chan tag bʉ̈ʉrjã maach akhaar iiuba aajem aajem. Amach mag nem jaau sĩerrjëem gaaimua iyʉ̈ʉmamua juau ogthom irig magjierram aajem: ");
INSERT INTO noaE_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, jöoi Moisés khararrau Ẽwandam iek phã pʉarr gaai jaauwai, woun ãb ʉʉi paraa simta mag ʉʉi dʉ̈i chaai chukhu meemʉn jũrr chi khod ãbam wai sim khai magua ich ag ʉʉipai auju aai sim a simgui ajierram anʉm, ag dʉ̈i ich naamʉu chaain ooba arr aawai jũrr i athee oo deeg; mag oo deebarm i chaainkha nʉisimkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maimua amachdëupai warag irig nem ĩgkhamamua magjierram aajem: ’Biek ãb ãbam khod appai emkhooin siete naajim aajem. Am naam chi nacharamua ʉʉi auwia, ich mag chaai chukhu wënʉrrʉm ee meejim aajem, chi emkhooi. ");
INSERT INTO noaE_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Magbaawai jũrr chi eeumua aujim anʉm ich ag ʉʉipai. Mamʉ mag dʉ̈ijã pöd chaai ooba, ich mag chaai chukhu meejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Magbaawai ag eeumuajã jũrr ich ag ʉʉipai aujim anʉm. Mamʉ maguajã pöd ag dʉ̈i chaai ooba meejim aajem. Ich mag ewagam khʉʉnjã ãbam ʉʉiraupai warm meemam ẽudee theg ahaugmamua mag ãbam khod appai siete narr thum thegdʉpʉ̈ijim aajem; mamʉ ni ãbmuajã pöd mag ʉʉi dʉ̈i chaai oobajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Maimua ãbmiecha paawai ĩchab chi ʉʉijã meejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Maagwai marau pʉrʉg jëeum ig nʉmʉn mʉgaugui ajierram anʉm: Mag ãbam ʉʉiraupai emkhooin khod ãbampai siete phëtarr aawai mʉg atag thumaam khʉʉn iiu phiidʉtkha nʉm edjã, ¿mag ʉʉi chijãg dënkha sĩsijuma ajierram anʉm: chi nacha autarr dën, wa ẽudeegam khʉʉn dënwa? ");
INSERT INTO noaE_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Magbaawai Jesuu amag magjim aajem: —Mʉg jẽb gayan, õor jua pʉrnaa amach chaainjã jua pʉrpipi aajerram. ");
INSERT INTO noaE_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mamʉ iiu phiidʉwia ʉ̈gtharcha öbër nʉm khʉʉn chan tag jua pʉrpʉr abam, ʉ̈gtharm Ẽwandam chognaanjö tag meeba ich mag nʉisiju aawai. ");
INSERT INTO noaE_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ya am Ẽwandam chognaanjö thʉnʉm dʉ̈i ĩchab Ẽwandam chaainkha thʉnʉmgui ajim anʉm, ich Ẽwandamauchata am phiriutkha autarr gaaimua. ");
INSERT INTO noaE_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Maach meewia deeu iiu phiidʉajem iekhan Moiseeujã jaaujimgui ajim anʉm, pabʉ̈dam neneree khitʉm uurdʉ thʉnʉm ichdëu ootarr jaau sim ag ẽsap ichdëu phã pʉatarr gaai. Mag jaauwai, i iek maach Pör Ẽwandaman jöoingar jöoi Abrán khararr ag Ẽwandam aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ẽwandam chan oob mag chi khëcham khʉʉn Ẽwandam khabam. Ẽwandaman chi iwam khʉʉn dënëu. Irigan nawe meetarr khʉʉn awia khãijã thum chi iwam khʉʉnau a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Irua mag iekhabapʉ̈im ũrwia ãaur khʉʉn chi machnaanjã aig narr aawai makhʉʉnau irig, —Maestro, ʉ̈uchata pua mag iekhabapʉ̈imgui ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mag, Saduceonaanaujã amachdëu pöd i pʉr auba meerkhabapʉ̈im oobaawai tag irig jëeuba ich mag nʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mag khĩu thʉnʉisim ee jũrr Jesuu ich garmuata amag jëeujim anʉm: —¿Jãga pãar iek mag Mesías jöoingar David khararr ag chaain ewagam khʉʉn dën aajẽ, ");
INSERT INTO noaE_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ich Daviiuchajã ichdëu ẽsap phãtarr Salmos anʉm gaai i igwi “maach Pör” a iekhatarrta? ¿Pãrau khĩir ee paba nʉ, Ẽwandamau ich iekhatarr Daviig phãpitarr? Mag irua phãtarr gaai mag sim: “Maach Pör Ẽwandamau magjim maach Pörög: ‘Mʉch iek theeg chirʉmjö aag mʉ dʉ̈i ãba mʉ juachaar gar jupbá ajim, ");
INSERT INTO noaE_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pʉch oomapha aajem khʉʉn thum mua pʉch jua ee pʉrkha dee nʉm ora.’ ” ");
INSERT INTO noaE_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mag ich David khararrauchajã Ẽwandamau pʉ̈iju aajerr igwia “maach Pör” a iekhatarrta, ¿jãgwia pãrau sĩi i David chaain ewagam khʉʉn dënpai aajẽ? Mag sĩi ich chaaipai aju akhiin Daviiu ich paarmua mag “maach Pör” abakhamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maimua õor thumaam khʉʉn jʉ̈g daar Jesuu ich khapeen ich dʉ̈i ogdʉba wënʉrraajerr khʉʉnagta magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Moiseeu Ẽwandam iek phã pʉatarr jawaag chi machnaan dʉ̈i khai khĩir khaphʉ aajeet. Jãkhʉʉnan sĩi khajũa bʉ̈ duurg jũanaa kaaijã ee õrau amachig saludaawaijã amach thö iekhapim khõsita sĩerrjëemgui ajim anʉm. Jãkhʉʉnan amach Ẽwandam i jaaujem deg weetwaijã amachta pörgarcha thumaam khʉʉnag khĩir jʉrkha juupjemgui ajim anʉm, amachta warm khʉʉn khãaijã ajapcha nʉm awia. Maimua di chaaur thach khömkhĩir thʉ̈ʉrwaijã parhooba jupba, khãidu ajapcharamta jʉ̈a au sĩerrjëemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jãkhʉʉnaun sĩita khoopaa ʉʉin juagam nemdamjã khechthʉg aumaajerram. Magnaata sëukha warag am kõit Ẽwandamag jëeu nʉʉ aajemgui ajim anʉm, juau ogthom amach magba nʉm amkhĩir. Mamʉ amach jãg wënʉrrʉm paar, jũrr Ẽwandamau ĩchab am gaai jua khʉabajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mag jaau dichwia ich Jesuu Ẽwandamag jëeujem deg jup oo simua eerpa oo sĩejim aajem, riknaan bëe thʉnʉm khʉʉnau jũrram khʉʉnau amach ofrenda chi phatkhon phiejem ee pʉapʉ̈pʉ̈ikham. ");
INSERT INTO noaE_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mag jũrram khʉʉnau amach ofrenda deechë thʉnʉm ee, ĩchab khoopaa ʉʉi ãb aphʉʉ khitʉm bëejim aajem. Mag ʉʉirau phatkhon chi dau daídam dau numpai wai sĩerr warre mag numwe ag ee pʉapʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Mag oobaawaita Jesuu, —Mʉg khoopaa ʉʉi aphʉʉ khitʉmuata chadcha thumaam khʉʉn khãaijã ʉ̈rʉʉcha deebarmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Riknaanaun Ẽwandamag amach dën chi sobbarm eemta ofrenda deejerram. Mamʉ mʉg khoopaa ʉʉiraun ich dën ãbmiecha agua ich thach khöju arrdamta thum Ẽwandamag deebarmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ãaur aig narr khʉʉnau Aai i jëeujem di ooimʉ õrau nem deematarr dʉ̈i mokdau ajaphamua joothʉthʉʉd ëu dʉnʉm oowia iyʉ̈ʉ naajim aajem. Makhʉʉnag Jesuu magjim aajem: ");
INSERT INTO noaE_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ar mokdau sĩi ajapha joothʉthʉʉd jãg thʉnʉm pãrau oo naabá. Jãg thʉnʉm chan mokpör ãbjã ãbam ʉ̈r ich jãg ajapha joothʉthʉʉd sĩerrabam. Jãg thʉnʉmʉn sĩi thumaa õrau pogueupʉ̈ijuuta jãg dʉnʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Magbaawai i khapeenau irig, —Maestro, pʉ iek mag jãg mokdau joothʉthʉʉd thʉnʉm thum õrau pogueupʉ̈iju anʉm, ma ¿jãagwaichata magjuma? ¿Khan jãg nʉm gaaimua Ẽwandamau ijaaurjö oopijuma ajim anʉm, mag Aai i jëeujem di pogueupʉ̈imʉʉ pam? ");
INSERT INTO noaE_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Magbaawai jaaubaadëmua ichdëu amag magjim aajem: —Keena, khĩir khaphʉ wënʉrrat; oob chikhamnag sĩi ʉdʉraa pãach khũgur aupimiet ajim anʉm. Nau mʉg atag paawai õor khapankham khʉʉnau amach iekpaita mʉ iek gaai thʉwia, “Mʉʉta ag Cristoou” ajurau, “Ẽwandamau pʉ̈iju aajerr. Ĩsta mʉ barbaichëm thumaam khʉʉn Pörkhaag” a iekhamajugui ajim anʉm. Mamʉ amau pãachig maagwaijã oob am iek ʉ̈khamiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mʉg atag paawaijã pãrau juurhi theega thʉnʉnʉmkham ũrjurau, durrpierr. Mag thʉnʉm dʉ̈i ĩchab õor wir aig amach pörnaan dʉ̈ipai meeukhawia sĩi phogdʉ thʉnʉm anʉmjã ũrjugui ajim anʉm. Mamʉ maagwai oob pãrau, “Ĩsin chad Ẽwandamau warreta maach öpʉ̈yaagpam” amiet ajim anʉm. Chadcha magʉm nem thum ich jãg didichagmaju; mamʉ magbaadëmua warag ag bʉ̈rre chan Ẽwandamau õor thum ʉʉrppʉ̈ibamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Maimua ĩchab mʉg durr thum i agkhaju ed gayaa pamamjã khap amkhĩir jajawagmamua magjim aajem: ’Mag thʉnʉisim dʉ̈i ĩchab durr mʉg wëjöm eepai durr chaauram khʉʉn dʉ̈i wërbʉphöo aadëjugui ajim anʉm, amachta jũrr chikhamnaan khãyau ʉ̈rpai am khõchgau. ");
INSERT INTO noaE_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mag nʉm dʉ̈i ĩchab durrpierr ʉʉur theega duuimajugui ajim anʉm. Agjö durrpierr jãdau theega burrnaa khamor machagjã khĩir pogkhe ompamamua õor pöm thuphãphãau ajugui ajim anʉm. Magbaadeewai edjã eejã ĩchab nem dau chigaa ag na ooba aajempata oomam gaaimua õor jãphierrju jaaumajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Mamʉ mag Aai i jëeujem di õrau pogueupʉ̈iwi, pãar öju nawe chikhamnau pãar ẽudee ẽkhawia, pãar pʉrnaa, amach ãba biirdʉwia, Ẽwandam i jaaujem deg pãar arrwia, cárcel degjã pãar arrmajugui ajim anʉm. Mag pãrau mʉ iek ʉ̈kha durrum atheepai amau pãar gobernadornaan aar arrwi reinaan aarjã arrjugui ajim anʉm, pãar khaibag waumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mamʉ magʉm aar mag pãar arrwaita ante pãrau amag mʉ iek jaauwímʉcha jaaujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mag thethem khʉʉn na pãach arrwai oob pãrau pãachdëupai pãach kõit iekhaju khĩirjuwia ag nawe, “¿Mʉ khan ata iekhajuwa?” a khĩirjumiet ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mua pãrag mag chirʉmʉn, iekhamkhĩir mʉchdëuta khĩirjug deeju aawaita mag chirʉm. Mag mʉchdëu iekhapi chiraawai ãbmuajã pãar ichaaur iek thierr khaba, ni pãrau iekha nʉmʉn sëukhaawaiujã abajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ich mag jaran mʉ iek ʉ̈kha nʉm gaaimua pãach dënnaanaupaijã pãar pʉr deemajugui ajim anʉm, chi thethem khʉʉnag. Wa magbam khai, pãach khod ãbam khʉʉnaupai, sĩi thʉ̈r khodpaim khʉʉnau, wa pãach khapkhʉʉn ajaphamua khãijã pãar pʉr deemaju. Mag pʉr deemaawai ãaur khʉʉn khëchpʉ̈inaa ");
INSERT INTO noaE_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","maimua ar juau thõoba abarm khʉʉn jũrr thumaam khʉʉnau oomappha ajugui ajim anʉm, mʉ iek ʉ̈kha durrum gaaimua. ");
INSERT INTO noaE_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mamʉ mʉg jẽb gaai õrau mag pãar oomapha awiajã mua pãar thʉa wai chitajugui ajim anʉm. Amau mag pãar oomapha ajup mamʉ, pãar pörbʉ̈dam chan ãbjã Ẽwandamau chig apibajugui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Õrau mag pãach dʉ̈i khaigba awiajã pãarta warag Ẽwandam dʉ̈i ubʉ wënʉrrʉmʉn, pãar akharan i aar öbërjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mag jajawagmamua jũrr Jerusalén phöbör igwiajã magjim aajem: ’Mamʉ ya ar pãachdëu oowai Jerusalén phöbörta soldaaunau phʉʉr thuurbaadëm oobaawai khap abat ajim anʉm, chadchata ya Jerusalenpienan warm khʉʉnau khëchpʉ̈iwia sĩi di khierr appaita jʉjʉrʉʉ sĩwaagpam. ");
INSERT INTO noaE_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Magbaawai chi Judea durr nʉm khʉʉn, durr dapag ee dʉrbat ajim anʉm; maimua chi Jerusalén phöbör ee nʉm khʉʉn, öbërdʉtkhawia ërëupetat ajim anʉm. Maagwai ar phöbör chaaur amach phidkhaajem aar khãijã nʉm khʉʉn, oob tag ag phöbör ee bëemiet. ");
INSERT INTO noaE_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Magbaadëmʉn, juau ich Ẽwandamau am dʉ̈i magju arr aawai, ich iek phã sim gaai thumaa ichdëu jaautarrjö israelnaan amach khaigba nʉm paar am chachwia am dau aphʉʉ apiegau ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mamʉ ¡ë, apdurr ajim anʉm, magbaadëm jaar ar ʉʉin jõor khithëem khʉʉn, maimua ĩchab ʉʉin ar chaaindam daumeraa wai durrum khʉʉn! Mag járata mʉg Israel durr õor dau aphʉʉta nʉisijupa ajim anʉm. Mua mag chirʉmʉn, õor mʉg thʉnʉm khʉʉn gaaita Ẽwandam khĩir machag burrju aawaita mag chirʉmgui ajim anʉm ich Jesuucha. ");
INSERT INTO noaE_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ãaur khʉʉn juurhi ee warm khʉʉn garmua juau khëchmaju; maagwai tagam khʉʉn mag juurhi ee chi ganbarm khʉʉnau pʉrkhanaa amach dʉ̈i amach durr phë arrmajugui ajim anʉm, durrpierr. Mag deeum durram khʉʉnau Jerusalenpien dʉ̈i mag nʉm, ich Ẽwandamau jaautarr thumaa abam aig chan Jerusalén phöbörön warm khʉʉnauta ich mag pör öbeerpiba wai nʉisijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Maimua ich Jesuu ichpai jaaumamua magjim aajem ĩchab: ’Magbaawai mʉch chi Emkhooi Iewaa bëeimʉʉ aadëmjã khaphʉ ajugui ajim anʉm, ãsdawam edau gaai, edau arg gaai, maimua ĩchab phĩdag gaai. Mag oobaawai õor jãphierrwia warag nem waujujã khaugba aadëm dʉ̈i, gaai machag ökhĩirjug pöoma aphöbaadëjugui ajim anʉm. Maimua phũas dau dapag thʉnʉm iek sĩi edjã ee pũu wëjömpa ũrphöbaadeewai ");
INSERT INTO noaE_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","õor sĩi chi meemjö iek chukjã aadëp ajugui ajim anʉm, warag Ẽwandamau amach dau aphʉʉ apiju khĩirjuwia. Mag jaran edjã eem nem sĩsidʉmpata sĩi parhooba amach nʉnʉid arr chaaur aaidʉ jörrjëe thʉnʉisijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Magbaawaita thumaam khʉʉnau mʉch chi Emkhooi Iewaa chadcha edjã baug ee dau daau urum oojugui ajim anaabá. Ya maig mʉg jẽb gayam khʉʉn thum chachbaadeewai mʉchta nem jua theeg thumaam khʉʉn Pörkha bëejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mamʉ pãachdëu mamagkham oophöbaadeewai warag onee abat. Magbaadeewai ya pãrau khaphʉ nʉmgui ajim anʉm, chikham jua ee pãach dau aphʉʉ wënʉrrʉm ee Ẽwandamau ya pãach peerdʉ auwimʉʉ pam. ");
INSERT INTO noaE_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mag Jesuu deeu ich bëeju jaau simua ĩchab amag mʉg ejemplo jaaujim aajem: ’¿Pãrau ooba aajẽ ajim anʉm, ar igo khër khukhuur aadëm, wa magbam khai deeum pabʉ̈ parhoobam khãijã khër khukhuur aadëm? ");
INSERT INTO noaE_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pãrau khaphʉ nʉm, mʉig Israel durr igo khër khukhuur aadëmʉn thumaam khʉʉnau ya chadcha döchʉumie dakpapakham aajem. ");
INSERT INTO noaE_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ich agjöta ajugui ajim anʉm, ĩchab mʉ bëeju gayaa paawaijã. Ya pãachdëu nem thum mʉchdëu jaau chirʉmjö ohoo khabaadeewai khaphʉ abat ajim anʉm, ya mʉ bëeimʉʉ pam; muan mʉg durr mʉchdëuta jʉ̈a auchëwia mʉchta thumaam khʉʉn pörkhaan urum. ");
INSERT INTO noaE_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mua pãrag mag Aai i jëeujem di õrau pogueupʉ̈iju a jaau chirʉmʉn, cha õor thʉnʉm khʉʉn khëchju nawe cha mʉchdëu jaau chirʉmjö thumaa chadcha ajuuta jaau chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Edaujãjã mʉg jẽb dʉ̈i thum chukhu aadëju, mamʉ cha mua pãrag jaau chirʉm chan sëukhaawai khabam, jãan thumaa ich ag ee öbërjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Khĩir khaphʉ nʉisit ajim anʉm, mʉ bëewai sĩi döo gaaipai nʉm dʉ̈i warag pãach nem ig nʉmta khĩirju nʉm gaaimua mʉ iek ʉ̈khaba, warag thãar theeg sĩi mʉ bëejujã khaugba, okhoppha nʉm pãach oochëpim ugua. ");
INSERT INTO noaE_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mag mʉ bëem edan, ar atarraayau ãwarr baarwai sĩi khöodʉ aaujemjöta, mʉg durr gaai õor thʉnʉm khʉʉn thum ãba dëgölp chachaan bëejugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mamʉ warag Ẽwandamag jëeunaa ajap khĩir khaug nʉisit. Pãrau ich mag pʉaba irig jëeu wënʉrrʉmʉn, nem thumaamua mag õor chachmawiajã bʉ̈ʉrjã pãar chig abajugui ajim anʉm. Maagwai ya mʉch pierrum edjã bʉ̈ʉrjã chigag chukhu pãar mʉ aig mʉ khĩirphee bëe thʉnʉisijugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mag jaau simua ãsdaaupain sĩi Jesuu Aai i jëeujem deg õrag jaaujeejim aajem, Ẽwandam iek. Maimua edaar paawaita jũrr durrsĩ Olivo anʉm gaai mawia ich mam ëejeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ãspa thʉnʉisiewai edaupherre õor pöoma i nʉan weetjeejim anaabá, Aai i jëeujem deg, irua nem jaau sim ũraag. ");
INSERT INTO noaE_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mag ãbmiecha Jesús ich khapeen dʉ̈i Jerusalén phöbör ee nʉm jaar, pan levadura chukhu wauwia khoojem phiesta burrju khãai khapan khaba waaur sĩejim aajem. Ich mag phiestapai ĩchab Pascua a thʉ̈ʉrjem. ");
INSERT INTO noaE_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Maagwai ĩchab phadnaan ee chi pörkha nʉm khʉʉnau agjö judionaan Ẽwandam iek athee chi machnaan dʉ̈imua amach eepai, “Jãgata akhiin bʉ̈ʉrjã õrag khaugpiba jãg Jesús pʉrnaa thõobpʉ̈ikhamgui” anaajim anʉm. “Magba mʉg khapanag eewe pʉr athaawai eeu õor pöm mʉg thʉnʉm maach dʉ̈ita meeukhadukham” a khĩirju naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Amau mag khĩirju nʉm ee, woun ãb Judas a thʉ̈r sim sĩejim aajem, ibʉʉr wauwia ĩchab Iscariote a thʉ̈ʉrjerr. Mag woun ĩchab ich Jesús dʉ̈i i bʉ̈ ogdʉba wënʉrraajerr khʉʉn eem ajim aajem. Mag Jesús dʉ̈i ãba nʉrraajerrta meperau pör meubaadeewai phadnaan chi pörkha nʉm khʉʉn dʉ̈i ĩchab guardianaanjã chi pörkha nʉm khʉʉnpa ãba nʉm aar majim anaabá, jãgata ichdëu amag i pʉr deeju khap jawaan. ");
INSERT INTO noaE_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Maimua barimawia jaaubaawai, amachdëu chi Judas iek amach jʉ̈gaagaa ũrbaawai, oneeu phöbaadëwia warag irig phatkhonjã deeju a iekhajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ichig magbaawai chará warag, —Ich magau magan maach iekhabarm; murua chadcha pãrag i pʉr deejugui ajim anʉm. Magtarr aigmua ãba i pʉr deeju khĩirjugta wai sĩsijim aajem, chi phöbörpienagjã ich khaugpiba. ");
INSERT INTO noaE_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Judaau Jesús ëugar mamagkham ee, pan levadura chukhu wauwia khoojem ed ãspa ëebaadëjim aajem. Mag ed judionaanau nemkhoo edam athee ovejadam wai narr thõowia edau khëubaadeewai khoojeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ich mag edcha Jesuu Pedro dʉ̈i Juan thʉ̈rkhanaa amag magjim anʉm: —Pãar maar na ërëubaadët. Maimua ovejadam për auwia agdamta maar na phiejãb waubaimat ajim anʉm, maach thum ãba khöimaag. ");
INSERT INTO noaE_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Magbaawai amachdëu, —¿Jampaita marau pʉ na phiejãb wauwimaju aai nʉma? a jëeujierram aajem Jesuug. ");
INSERT INTO noaE_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Magbaa chi Jesuu amag, —Chamʉg Jerusalenag khʉd ma sim ee ërëubaadët ajim anʉm. Nau chi phöbör dub nʉm aigcha woun ãb dö jöi authurwia döthũr dʉ̈i degag mam pãrau ooimaju. Magbaawai i dʉ̈i ërëuwia i dubbaimam deg dʉ̈i dubbaimat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mag dubwia chi dikhʉʉg, mʉch chi maestroouta pãar pʉ̈ijim abat, jampaita nau kheeurag maach thum ãba thach khöju aai nʉ a khap jëeumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Magbaawai mag wounau pãrag oopien majugui ajim anʉm, ʉ̈gthaa dijã pöm sim ya sĩi chi khĩir khaugam. Maigta nem thum khĩir khaugwia maar nʉbat ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Magbaawai chadcha i ipierraa ërëubaadeeu thum ichdëu jaaumarrjöo ooimajierram anaabá. Maig, ich na mag ovejadam waupitarr chadcha tagam nempa thum khĩir khaugwia sĩi tagam khʉʉn dʉ̈i i baraata oo nʉisijim aajem, ãba khoog. ");
INSERT INTO noaE_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Maimua khëubaadëm ee Jesús barchëjim aajem, tagam khʉʉn ich khapeen dʉ̈i, Pedro Juan dʉ̈i narr aig. Mag ichdëu jʉr auwia i dʉ̈i ogdʉba wënʉrraajerr khʉʉn deeu thumaa nʉisim ee, ya chi phiejãb wau wai narrjã thöikha sĩsiewai ãba khoog paaukhabaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mag khö nʉmua magjim aajem ich khapeenag: —Keena, chadcha chikhamnaanau juau mʉch thõoju nawe pãar dʉ̈i mʉg nemkhoo edam ovejadam khöm khõchaaga chirajimgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mʉ chan mʉg khöbarm aigmua tag khöba, ãba Ẽwandamta ʉ̈gthar thumaam khʉʉn Pörkha sĩsim edta ũmaai pãar dʉ̈i ãba tagam khʉʉn ichdëu peerdʉ autarr khʉʉnpa deeu maach thum ãba khöjugui ajim anʉm. Mag edta thumaam khʉʉnau warrgar nemkhoo edam oveja thõowai Ẽwandamau amach peerdʉ auju a khĩirjuajerrjö, chadcha amach peerdʉ nʉisim khaphʉ ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Maimua vino jarrdam jua ee auwia Ẽwandamag ʉ̈u ajim anaa, —Ya pʉr athat ajim anʉm. Maimua, Dönaa jũrr ʉapʉ̈ipetat ajim anʉm, agdaujö dö aumamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mʉʉn ãbmieta ĩs pãar dʉ̈i mʉg vinodam dö chirʉmgui ajim anʉm. Mʉg döbarm aigmua tag döba, ãba Ẽwandamta thumaam khʉʉn Pörkha sĩsim edta deeu döjugui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Maimua agjö panjã jua ee auwia, Ẽwandamag ʉ̈u ajim anaa, thorreuwia, amag deenaa, —Mʉg panan mua mʉch morta pãrag dee chirʉm; mʉg atagjã mʉ khĩirjunaa ich mʉgta khabat a jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Maimua ya khö aaipagkhabaadëm ee, deeu chi vino jarrdam jua ee auwia ĩchab, —Mʉg jarr eem vinodam döbarmta warrgarwe Ẽwandamau õor dʉ̈i iek deeju aajerrau; mamʉ mʉg iekhan iek iiuriugui ajim anʉm. Mʉ bag mʉg vinojö ãrbarmuata Ẽwandamau, ĩsmua atagan chadau pãar peerdʉ wënʉrraju aai nʉm a jaau simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pãrag khap amkhĩir warre jaau chirʉmgui ajim anʉm: Mag mʉ bag ãrmkhĩran, maach eem mʉig maach dʉ̈i ãba thach khö simuapaita ich paarmua mʉ pʉr deeju, mʉ oomapham khʉʉnag. ");
INSERT INTO noaE_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mʉʉn chadcha Emkhooi Iewaau, mamʉ magʉm ãba chadcha amau mʉ thõojugui ajim anʉm. Mamʉ Ẽwandamau ich magpiju arr aawai thum ichdëu jaautarrjöo öbëbërgmam. Mamʉ ¡Ë, apkhiitʉ ajim anʉm, mag mʉ thõomkhĩir mʉ pʉr dee chirʉm woun! ");
INSERT INTO noaE_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesús mag iekhabarm ũrwia i khapeenau amach eepai jũrr chikham ipeer ahaukhamua, —¿Chijãguataa wir aigpai mag meer i pʉr deeju khai? anaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Maimua nʉʉpai awia ĩchab amach eepai, “¿Chijãata magan mʉig maach ee ʉ̈rʉʉcha sĩ?” a chikham ipeer ahau khaphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mamʉ magbaawai Jesuu amag magjim anʉm: —Mʉg durr gaai reinaan thʉnʉm khʉʉnan amachta ʉ̈rʉʉcha nʉm awia õor dʉ̈i athuucha sĩerrjëem. Mamʉ mag nʉmta amachta chi thierrnaan awia jũrr õrag amach igwia, “Jãguan chadau maar athee nem ajaphamta waaujem” a iekhapimjã khõsi aajemgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mamʉ pãar ee magju aai khaba nʉmgui ajim anʉm. Mag khãyau chadcha thethem awia khãijã warag serbiibamjöta aju aai sim; maagwai chi pörkha simta jũrr ich chogjöta aju aai simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Magnaa amag, Pãrau khĩirjuawai, ¿chijã chi thethem agá ajim anʉm: sĩi mes gaai thöikha sĩsiewai khoogpai jupcheejem, wa mes gaai chi thëp paajem? Magnaa ichdëupai, Chi ʉ̈rʉʉcha simʉn ya sĩi thöikha sĩsim abaawai khoogpai jupcheejemʉugui ajim anʉm. Magnaa amag, Mʉʉn chadcha pãar Pöröugui ajim anʉm. Mamʉ pãrau oo nʉm, sĩi mʉig mʉ pãar chogkha chitʉmjöo chirʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mamʉ mua ĩchab khaphʉ chirʉmgui ajim anʉm, chadcha pãarta mʉ dʉ̈i ogdʉba ich jãg wënʉrraajem mʉ chitʉmpierr, pãach dau aphʉʉ ajujã khĩirjuba. ");
INSERT INTO noaE_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pãach jãg wënʉrrʉm gaaimua, mua pãrag ĩchab mʉch dʉ̈i õor pörkhapijugui ajim anʉm, mʉ Ayau mʉchta thumaam khʉʉn reikhapibarm dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mag mʉchta thumaam khʉʉn Pörkha chirsim edta deeu maach ãba onee aju. Maimua rey juupjemjöm sie gaai jupkhawia pãachta mʉ dʉ̈i jöoi Jacob khararr chaain doce narr khʉʉn ag chaain ewagam khʉʉn pörkhajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Maimua ĩchab magjim aajem maach Pör Jesuu Simonag: —Simón, dösãtau Ẽwandamag jëeu wai simgui ajim anʉm, pʉ dʉ̈i ichdëu ampierr awia pʉ dau aug waupieg. ");
INSERT INTO noaE_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mamʉ mua jũrr pʉ kõit Ẽwandamag jëeu chirʉmgui ajim anʉm, pʉch khũgurcheewai warre burrm iek burrm ugua. Maagwai ũmaai deeu mʉ thʉ̈r gaai khĩirju chirsiewai pʉchdëupaita jũrr pʉch khapeenag jaauju aai chirʉmgui ajim anʉm, amjã agjö ubʉ nʉisimkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Magbaawai chi Simonau irig, —Señor, mʉʉn pʉ dʉ̈i cárcel deg mawia pʉ thõbarm aar thõimaju akhiinjã maju chirʉm; magʉmjã mʉ gaai mas khabamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Magbaawai Jesuu jũrr irig, —Pedro ajim anʉm, pʉ mag iekha chirʉm ãba, nau õrau pʉchig jëeuwai, ãthãrr bĩeju nawe biek thãrjup purua amag bʉ̈ʉrjã mʉ khaugba chitʉm a jaaujugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Maimua warm khʉʉnagjã magjim aajem: —Ar mua Ẽwandam iek jawamkhĩir pãar putjã chukhu phatkhonjã chukhu sĩi ich jãg zapat theg jũajujã chukhu pʉ̈ijim ed, ¿nem inag athee pãar augchëjierrá? ajim anʉm. Magbaawai chi khapeenau, —Ʉ̈ʉ̈, bʉ̈ʉrjã maar augchëbajimgui ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Magbaawai deeu ichdëupai amag, —Magtarr ĩsin chadau put wai nʉm khai, athaadët; ĩchab phatkhon khãijã wai nʉm khai, athaadët; maimua ãb khãijã espaar chukhu sim khai, ich khajũa përbapʉ̈i ajim anʉm, agua awaag. ");
INSERT INTO noaE_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mua pãrag mag chirʉmʉn, Ẽwandam iek phã sim gaai jaau simjö ya mʉch thõimʉʉ paawaita mag chirʉmgui ajim anʉm. Ẽwandam iek phã sim gaai mʉ igwia jaauwai, “Iin, õor thõomiejöta wai naaju” a sim. Mʉ igwia ich mag phã sim aawai chadcha thum ichdëu jaau sim eyaa öbëbërg maju a jaaumajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Magbaawai amachdëu irig oopinaa, —Señor, ya marau mʉig espaar numí wai nʉmgui ajierram anʉm. Magbaawai ichdëu, —Tag mʉ iekhabam, idëu ich magpai sĩujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Maigmua öbërdʉtkhaau Jesús Olivo durrsĩig petajim aajem, kheeupierr mawia mag durrsĩ gaaimua ich Ayag jëeujerr aawai. Mag i mam dʉ̈i ĩchab i khapeenjã i dʉ̈i wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mag wëtwia ich Ayag jëeujem aig bardʉtkhabaimaawai ich khapeenag, —Ẽwandamag jëeubat ajim anʉm, dösãtag ʉdʉraa pãach phũrreu aupiba mʉ dʉ̈ita ubʉ wënʉrraag. ");
INSERT INTO noaE_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mag jaauwia, ichin am aigmua mawia, juau mokdau barbapäaiwai burrjem ag warphagjöpai sĩeimajim aajem, am bigaau. Maig jẽkhʉt jĩepöröu phõbkhanaa, ʉ̈gthaag eerpanaa, ich Ayag jëeubaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mag jëeumamua, —Tata ajim anʉm, pua khõs akhiin, atcha mʉ dau aphʉʉ apibakham. Deeum nem waubarmuajã agjö õor peerdʉ auju ayaa akhiin, mʉ gaai machag mʉgcha ãwatbakhamgui aajeejim anʉm. Mamʉ pʉchdëuta khap chirʉm; mʉchdëu khõsi chirʉmjö khaba, pʉchdëu khõchagpierrta mʉ dʉ̈i abá a iekhamajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ich Ayag jëeuwai mamagkhamua kha theeg chukhu thʉnʉm ee, ʉ̈gtharmua Ẽwandam chog bëewia irig juapá deechëjim aajem, mag ich dau aphʉʉ aju ãwatamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mag ich dau aphʉʉ aju khĩirjuwia gaai machag thʉnʉmua warag oraa nʉmta, khajapham nemjö thet phʉrëu ahau aajeejim anʉm. Mamagkhamua jʉachë thʉnʉm oowain sĩi jʉa gaai bagpata öbër thʉnʉm thëutkha thʉnaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mag ʉ̈gthaag ich Ayag jëeu sĩi awia, phiidʉwia, ich khapeen oon bëewai sĩi warag ökhĩirjug machgau khãidʉtkha thʉnʉmta oochëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Magbaawai amag, —Phiidʉtkhabathʉ̈ keena ajim anʉm. ¿Khantheeta pãar khãi nʉma? Khãiju khãai Ẽwandamagta jëeubathʉ̈ ajim anʉm, dösãtag ʉdʉraa pãach thʉ aupim ugua. ");
INSERT INTO noaE_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mamʉ agtha Jesús mag iekha dʉnʉm ee, dëgölp am aig õor khapan pos aichëjim anaabá. Mag khapanag ee oowai ich Jesús dʉ̈i doce ogdʉba wënʉrraajerr eem ãb Judas a thʉ̈r sĩerrta am na urajim anʉm. Mag bëewia, Jesús dʉ̈i ãba dʉnʉʉuchëjim anaabá, sĩi khajapha saludaa nʉmjö i khĩir ʉ̈ʉg. ");
INSERT INTO noaE_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Magbaawai Jesuu irig magjim anʉm: —Judas, mʉch chi Emkhooi Iewaa mʉ oomapham khʉʉnag pʉr deeg mʉ khĩir ʉ̈ʉ chirʉmta pʉchigan sĩi saludaa chirʉm a chirabma ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Magbaawai ich Jesús khapeenau amach Pör dau aphʉʉ aju khaug athaawai, —Kakë, ¿marau pʉ kõit esparau am dʉ̈i jãauju jãg nʉ? ajierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mag irig jëeu nʉm ee, ãbmua bis abarmʉn, phadnaan pör ag chog kach juachaar garmta warre oorthubapʉ̈ijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Magbaawai Jesuu ich khapeenag, —Oob jãgmiet; idëu mʉ dʉ̈i amachdëu ampierr apibat ajim anʉm. Magnaa chi kach deeu ich sĩerrjöo khaarpi sĩujim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Maimua Jesuu oowai aig naajim aajem: phadnaan chi pörkha nʉm khʉʉn, judionaan Asamblea eem pörnaan, maimua Ẽwandam i jëeujem di thʉajem khʉʉn chi pörnaanpa thʉnaajim aajem, i pʉr awaan bëetarr khʉʉn. Magbaawai chi Jesuu amag magjim aajem: —¿Pãrau oowain mʉʉn sĩi õor nem jĩgkhanaa õor thõomiejöta chirabama ajim anʉm, jãg sĩi mʉ aig jua ee jierrnempan appai bëeg? ");
INSERT INTO noaE_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ẽwandamag jëeujem deg ed ëepierr pãar dʉ̈i mʉ chiraawai, bʉ̈ʉrjã pãrau mʉ chig aba aajerrta, ĩsta Ẽwandamau pãrag ʉdʉraa mʉ pʉr aupiju ed ajim. Maagwai ĩsta ĩchab chi dösãtjã pãar ʉ̈rpaju ed ajimgui ajim anʉm, mʉ pʉr aumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Maimua Jesús pʉrphöbaadëwia, arrwia, phadnaan pör deg wai dubphöbaadëjim aajem. Maagwai Pedroou warppaimuata i ẽudee oopʉ̈pʉ̈ig warrmaa ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mag chi phadnaan pör aar deethurwia chi Jesús ierr wai nʉmich, jũrr di ũjãrr õt örwia ag bigaau ohood aphöbaadëjim aajem. Magbaawai Pedrojã ĩchab am bigaau oo sĩsijim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mamʉ i mag oo simta, aiguim ʉʉi ĩchab chi phadnaan pör chogkha sim bëewia, i khĩir eerpanaa, warm khʉʉnag, —Chamʉg wounjã ĩchab i dʉ̈i nʉrraajemʉu aichëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Magbaawai Pedroou, —Mua magʉm wounaan ooba chitʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Maimua ag khur nʉʉpai awia jũrr emkhooi ãbmua irig, —Pʉjã am eem khabahab aichëjim anʉm. Magbaawai Pedroou, —Kakë, mʉ chan am eem khabam perá ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Maimua deeu ag khur ora ãbjönaa deeum bëewia maguajã agjö irig, —Chadcha mʉg wounjã i dʉ̈i nʉrraajem khabahab ajim anʉm; jãan Galileapierrauwai ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Magbaawaita Pedroou, —Kakë, mua bʉ̈ʉrjã khaugbam, khan ata pʉ iekha chirʉm khai ajim anʉm. Magbarm bʉ̈rre agtha thumjã Pedro iekha öba nʉm ee, ãthãrrta kekerekee ahbar. ");
INSERT INTO noaE_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mag ãthãrr bĩebaawai maach Pör Jesucristoou ewag phʉʉrba oo nʉʉ ajim aajem, Pedroog. Maigta Pedroou khĩir eyaa aadëjim anaabá, maach Pöröu ichig, “Pedro, ãthãrr bĩeju nawe õrau pʉchig jëeuwai biek thãrjup pua bʉ̈ʉrjã mʉ khaugba chitʉm a iekhaju” a jaautarr. ");
INSERT INTO noaE_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mag khĩir ee dʉnʉisim abarmʉn chadau, gaai machaaga aadëmua dawag öbërwia, warre ö jãsenag aadëmua bĩe sĩi ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Maagwai Jesús pʉr wai nʉm aig oopaar thʉnarr khʉʉnaujã i wau iekhanaa ĩchab moketaupa phãr wai nʉmua i gaai mas waumaajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Magnaa putiu i dau phãarjʉ̈naa jũrram khʉʉnau khĩidadcha juajãau phot anaa irig, —Magan khaug athá, khaíuta pʉ phãrjĩ aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ich mag pʉamjã igba, i wau wai nʉmua warag irig parhoobajã iekhamaajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Maimua ya ãspabaadeewai ãba biirdʉjierram aajem: Asamblea eem chi pörnaan phadnaan pörkha nʉm khʉʉn dʉ̈i Ẽwandam i jawaag chi machnaanpa. Mag biirdʉwia amach Asamblea ee chi Jesús aibëewia irig, ");
INSERT INTO noaE_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Pʉchta chadcha warrgarwe Ẽwandamau õor peerdʉ aumkhĩir jʉr auwia pʉ̈iju aajerrá? Warre marag jaaubá ajierram anʉm, marau khap aag. Magbaawai Jesuu, —Mua pãrag jaaukhiinjã, pãrau mʉ iek ʉ̈khabajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Maimua mʉch garmua jũrr pãrag jëeumakhiinjã, pãrau mʉ iek jʉ̈ʉjã aba ni mʉ pʉapʉ̈ijã pʉapʉ̈ibajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mamʉ nau mʉg atag jöpcha mʉg woun Emkhooi Iewaa Ẽwandam chi jua thierr bigaau i juachaar gar jupimajugui ajim anʉm, Ẽwandam dʉ̈i ãba thumaam khʉʉn Pörkhaag. ");
INSERT INTO noaE_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Magbaawai thumaam khʉʉnau irig, —¿Ãa, magan pʉʉn Ẽwandam Iewaapama? ajierram anʉm. Magbaawai jũrr ichdëu amag, —Pãachdëupa khabá pãrau khaphʉ mʉ aruu a jaau nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Magbaawaita amachdëu, —¿Khan atcha maadëu deeum khʉʉnau jaau nʉmta ũrm ig nʉma? Ya maadëu ũrbarmgui ajierram anʉm, ich iiucha jaaubarm. ");
INSERT INTO noaE_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Maig wai nʉʉ awia, amach thum ãba öbërdʉtkhawia, chi Jesús gobernador Pilato aar arrjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Maimua mam pawia Pilatoog sëukha magphöbaadëjim anʉm, Jesús khĩir: —Marau mʉg wounau pãar ëugar nem khaigbam jaau nʉrrʉm ũrimajim ajierram anʉm, pãar dʉ̈i õor meeukhamkhĩir. Ichdëuta rey Cesaroog dëbpaarjã phagpiba jaaunaa ichdëupaita ĩchab ichta Ẽwandamau pʉ̈iju atarr aajemgui ajierram anʉm, judionaan rey. ");
INSERT INTO noaE_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Magbaawai Pilatoou ich Jesuugcha, —¿Chadcha pʉʉta judionaan Reí? a jëeujim anʉm. Magbaawai Jesuu irig, —Pua khabá chadcha khaphʉ jaaubapʉ̈imgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Magbaawai Pilatoou phadnaan chi pörkha nʉm khʉʉnag maimua tagam khʉʉn aig narr khʉʉnagpa, —Mua mʉg woun gaai bʉ̈ʉrjã nem khaigba ooba chirʉmgui ajim anʉm, i thõopäaig. ");
INSERT INTO noaE_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pilatoou magbaawai chará warag amachdëuta iek khẽgkha phöbaadëwi, —Jãguan chadchata õrag pãar ëugar sëukha nem jaau nʉrrʉmua phöbör meeukhapiju ẽkha simgui ajierram anʉm, pãar dʉ̈i. Judea durr ee thumaam khʉʉnag ich mag jaau nʉrraajem; Galilea durrmua jaaubaaderr ich mag jaau phʉʉrdʉ nʉrrʉmua khĩeb mau pabaichëmgui ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mag Pilatoou ũurwai Jesús Galilea durrmua bëejim a ũrbaawai aig narr khʉʉnag jëeujim aajem, chadcha Galileapierr khai a khap aag. ");
INSERT INTO noaE_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mag jëeuwai chadcha Galilea durram a ũrbaawai, —Ãa, magan Erodes aarta deepʉ̈ijugui ajim anʉm, ichta aram gobernador aawai. Mag chadcha deepʉ̈ijim aajem, mag jaar chi Erodejã agjö Jerusalén phöbör ee sĩerr aawai. ");
INSERT INTO noaE_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Maimua Erodeeu Jesús oo athaawai onee aadëjim anʉm, ag nawe i dʉ̈i oom khõchag sĩerr aawai. Ichdëu ũurjeejim aajem Jesuu nem wau nʉrrʉm. Maagwai ich daúachata nem maadëu ooba aajem irua wau sim oom iigjeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ichdëu mag khĩirju sim gaaimua irig nem khĩir pogkhe jëeumaajeejim aajem. Mamʉ magʉmjã Jesuu bʉ̈ʉrjã i iek jʉ̈ʉ aba aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Maig naajim aajem ĩchab chi phadnaan pörkha nʉm khʉʉn Ẽwandam iek athee chi machnaanpa. Makhʉʉnau warag thet iek khẽgkha, —Chadcha i iekkhõr pöm sĩebahab aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Magbaawai Erodeeu ich soldaaun dʉ̈imua i gaai iukhanaa i serbiibagpa phënaa, —Pãadë oobat, judionaan reikhaju anʉmta dau aphʉʉ oo khërʉm aajeejim anʉm. Magnaa warag juau ogthom i wau nʉmua khajũa ajapham reinaanau jũajem khajũa jũapinaa deeu chi Erodeeu Pilato aar deepʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mag ed Pilato Erodes dʉ̈i khapeer ajapham khajierram aajem, warr magju nawe chan jũrr agdaujö chikham oomapha aajerrta. ");
INSERT INTO noaE_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Deeu Erodeeu Jesús ich aar deebapäaiwai Pilatoou thumaam khʉʉn ãbam aig thʉ̈rkha aujim aajem: phadnaan chi pörkha nʉm khʉʉn, judionaan chi thethem khʉʉn maimua chi phöbörpienjã agjö. ");
INSERT INTO noaE_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Maimua amag magjim anʉm: —Mʉg wounau maar ëugar sëukha nem ĩgkha nʉrrʉm awia pãrau mʉ aig i aibëejierram. Mamʉ mʉchdëucha pãach dakhĩir magʉm khap aag jëeu oowai mʉg woun bʉ̈ʉrjã iekkhõr chukhu simta pãrau ich khĩirchajã mag thʉnarramgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pãrau khaphʉ nʉmgui ajim anʉm, mua Erodes aar i deepʉ̈itarr. Mamʉ Erodeeu oowaijã ichiita mʉg woun bʉ̈ʉrjã khaibag chukhu öbëbërkham. Mʉg sim aig mua oowai mʉg woun khaibag chukhu simgui ajim anʉm, thõopäaig athee. Magnaa amag, ¿Jãgajĩ irua? ");
INSERT INTO noaE_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Muan i pʉapʉ̈iju, mamʉ nacha i wʉpi thʉnʉʉujugui ajim anʉm, pʉapʉ̈iju nawe. ");
INSERT INTO noaE_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Mamʉ mag Pilatoou Jesús pʉapʉ̈iju abaawai warre thumaam khʉʉnau i ãba, —Jesús thõobapʉ̈i, maimua jũrr Barrabaata maraun sĩi khajapha öbeerpʉ̈ipi nʉmgui ajierram anʉm. Mamʉ mag amau preso ãb sĩi öbeerpi jaau narran, añopierr mag phiesta burr nʉm ee paawai mag khaajerr aawaita mag öbeerpi jaau naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mamʉ amau öbërpʉ̈ipi jaautarr Barrabás aajerran cárcel deg sĩejim aajem, ichdëu õor meeukhapiwia mag meeukha nʉm ee õor thõotarr kõit. ");
INSERT INTO noaE_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Magbaa ich Pilatoou Jesús pʉapʉ̈im khõsi sĩerr aawai deeu amag iekhajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mamʉ magbaawai ũmaai deeu sereeu phöbaadëwia ihãba, —Warre jãg Jesús pakuls gaai meerphë thõobapʉ̈it aajeejim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mamʉ pʉaba ya biek thãrjupamua Pilatoou deeu amag, —¿Pari khan nemta irua khaigba waujĩma ajim anʉm, i thõopäaig? Mua chan bʉ̈ʉrjã i khaibag ooba chirʉmgui ajim anʉm, i thõopäaig. Thõoju khãai sĩi wʉnaa i pʉapʉ̈iju jãg sĩ ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Magbaawai chará warag ääakhamua ãba pakuls gaaita meerphëpi jajaau aajeejim anaabá. Ich mag warag sereeu thʉnʉm khĩupaajã khaugba, amachdëuta Pilato khĩupaa sĩujierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Mag nʉʉ paawai Pilatoou am ipierraa jũrr Jesuuta amach jua ee deejim aajem, amach khõchagpierr i dʉ̈i amkhĩir. Maimua ich soldaaunag thõopʉ̈ipi jaaujim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mamʉ maagwai chi Barrabás cárcel deg sĩejim aajem, ichdëu õor meeukhapiwia ich ag meeukhaa eepai õor thõotarr kõit. Mag, cárcel deg sĩerrta weeupʉ̈ipijim aajem, õrau ig narrjö. ");
INSERT INTO noaE_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mag wai naawia Jesús thõopʉ̈yaan athaadeeu, woun Simón anʉm Cirenepierr phöbör ee urum dʉ̈i thẽubaawai, chi soldaaunau Jesuu arrmaa arr pakuls jũrr i öphëeu ʉ̈r jiirpʉ̈ijierram aajem, Jesús mam ẽudee arramkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Maagwai i ẽudee õor pöoma wëdurajim aajem. Mag õor khapanag ee ʉʉinjã ĩchab i ʉ̈apër durrumua i athee bĩe wëdurajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mamʉ Jesuu ewag phʉʉrba oonaa amag, —Jerusalenpie ʉʉin, oob mʉ athee bĩemiet ajim anʉm. Mag khãyau pãach mor dʉ̈i pãach chaain khĩirjunaata bĩebat ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mʉg atagta pãar dau aphʉʉcha aju. Mag jaar ʉʉin pöd chaain ooba arr khʉʉnau amach khapeen chaain dʉ̈i dau aphʉʉ durrum oowia, “Ʉ̈uta jãg mʉ chaai chukhu ʉrrʉm” ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ich mag jaar ĩchab atcha mag dau aphʉʉ wënʉrramaaugau, thõom khõchgau durrsĩigta wounaanagamjö, “Maar ʉ̈r dʉrbagkhabaadët; pãach eegar warre maar bëpbapʉ̈it” a iekhajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Amau mʉ mʉg wai naawia nau mʉ thõobapäaiwai pa ajaphamta sĩi jẽwamkhĩir thubapʉ̈imjö ajugui ajim anʉm. Amau mʉ dʉ̈ijã mʉg nʉm, ¿jãga aju khai ajim anʉm, amachdëu pahachjökham khʉʉn oowai? ");
INSERT INTO noaE_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mag chi Jesús arrum dʉ̈i ĩchab numí chi khaigbam cárcel deg wai narr khʉʉn arrjierram aajem, agjö thõopäaig. ");
INSERT INTO noaE_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Maimua buchagdam “Pörpá durrsĩ” anʉm gaai waaidʉtkhawia pakuls gaai i meerphëpʉ̈ijierram aajem, maimua i bigaau chi khaibagnaanjã agjö, ãb i juachaar gar maimua ãb i juawë gar. ");
INSERT INTO noaE_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Maagwai pakuls gaaimua Jesuu, —Tata, õrau mʉ dʉ̈i mʉg nʉm idëu sĩi ich jãg khĩir okhoobapʉ̈i. Amau amachdëu nem wau nʉmjã khaugba naawaita mʉg mʉ dau aphʉʉ wau nʉm aajeejim aajem. Maagwai chi soldaaunau amach appai, “Magan ¿khaíuta chi khajũa jʉ̈aju khai?” awia, mokdaudam bar nʉmua gan aumajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Maagwain õrau Jesuugta eerpapaad thʉnaajim anʉm. Mag nʉm dʉ̈i chi thethem khʉʉnaujã iukhanaa, i wau iekhanaa, daau irua ichdëupai ich peerdʉ athaju awia irig, —Deeum khʉʉn peerdʉ autarrpí, pʉchjã peerdʉ athá aajeejim anʉm, pʉchta chadcha Cristo chaar Ẽwandamau jʉr auwia pʉ̈itarr khai. ");
INSERT INTO noaE_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Maimua chi soldaaunaujã ĩchab sĩi i waauwaipai irig vino adchuchúu sim dömkhĩir deechënaa jũrram khʉʉnau irig, —Pʉ chadcha judionaan Rey khai, pʉchdëupai pʉch peerdʉ athá aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Maagwai i meerphë jiir wëjöm pör ʉ̈r ẽsapdau phãkha sim gaai jaau sĩejim aajem, khan gaaimuata i mag wai naajĩ. Chi ẽsapdau gaai “Chamʉʉta Jesuu, judionaan Rey” a phã sĩejim aajem. Chi ẽsapdau phã sĩejim aajem griegonaan meúa, latín meúa maimua ebreonaan meúajã agjö. ");
INSERT INTO noaE_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ĩchab i dʉ̈i chi khaibagnaan numí narr aawai ãbmuajã warag i waunaa irig, —¿Pʉ chadcha Ẽwandamau õor peerdʉ aumkhĩir pʉ̈itarr khabá? Magʉmta, ¿jãg pua pʉch peerdʉ auwia, maarjã peerdʉ aubamma? aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mamʉ magbaawai jũrr chi khaperaupai irig meeurraunaa, —¿Maachjã agjö thõopäaig atheeta amau maach mʉig wai nʉmta pua Ẽwandam dakhĩir warag mag iekha chirʉ́? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mag khãyau maachin, chadcha maachdëu khaigba arr gaaimuata mʉg naabahab ajim anʉm. Mamʉ mʉg woun chan bʉ̈ʉrjã pekau chukhu simta amau i mʉg dau aphʉʉ wai nʉmgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Maimua ichdëupai mag iekhapʉ̈inaa jũrr Jesuug, —Ya deeu pʉchta Reikha bëewai oob mʉ khĩir okhoo chiram ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Magbaa Jesuu irig, —Ĩswe pʉ mʉ dʉ̈i durr wʉ̈jʉ̈u durr chiraimaju ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ich mag ed edausĩcha nʉmta dëgölp edau khĩbaadëm abarmʉn edaramjö aadëjim aajem. Mag khĩ thʉnʉʉ awia edau phʉʉibaajër las tresjö naata deeu edau aardʉbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mag edau ãsdawam khĩbaadëm ee, Ẽwandamag jëeujem deg ierrgajãrcha put nem parrg thuur ëu wëjorrta jãrrcha ʉ̈gthaamua eeg sʉrr abarmʉn, warre thoophem numí jijirar jöisijim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mag edau khĩbaadeewai Jesuu thet, —¡Tata! Nau mʉ chaaupabaadeewai puata mʉ akhaardam khap chirʉmgui ajim anʉm. Mag iekha khitʉm ee warag maach chaaupabaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Magbaawai capitán Romapierr aig sĩerrau ichdëu mag oobaawai, —Chadchata jãgan mʉg wounan chi ajapham ajimgui ajim anʉm, Ẽwandam na. ");
INSERT INTO noaE_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Maimua ĩchab aig õor pöm thʉnarr khʉʉnau amach daúa mamagkham oobaawaita ãsie thumaa ewag khĩirjuwia pör jõjõig wëtmajierram aajem, amach diig. ");
INSERT INTO noaE_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mamʉ thum i khapeen Galilea durrmua i dʉ̈i ãba chi ʉʉinpa bëetarr khʉʉnaun warppaimuata mamagkham thum oo naajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mag ed aig sĩejim aajem ĩchab woun ãb José anʉm, Arimateapierr. Chi Arimatea anʉm, Judea durram phöbör ajim aajem. Ich mag José ĩchab judionaan Asamblea eem woun ajapham ajim aajem, Ẽwandam dau na. ");
INSERT INTO noaE_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Maagwaita ich khapeenau Jesús pʉr awaag ibëp naawaijã ich chan am igar khaba sĩejim anaabá. Magua amau i dau aphʉʉ wai naawaijã ichdëu chan dichba aajeejim anʉm. Mag wounau ĩchab Ẽwandamau maach peerdʉ aumkhĩir pʉ̈iju jaaujerr bëeju anʉmta nʉajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ich mag wounauta, Jesús meebaadeewai, Pilato aar mawia chi mor mag mee khërʉm arraag jëeuwimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mag jëeuwimawia, Pilatoou arrju aai sim abaawai, mawia, eeg paawia, dĩesdam ee pʉrëunaa, jẽbdi pöm durrbʉ̈ khõpag ee chi khörm wai sĩerr ee aukhëraan arrjim aajem. Mag jẽbdeg chan agtha õor ãbjã aukhërba khörwia sĩi sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mag i aukhërtarr ed viernes kheeurag ajim aajem, jua ʉ̈ʉijem edam athee nem thum khĩir khaaugjem ed. ");
INSERT INTO noaE_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mam pamjã chi ʉʉin Galilea durrmua i dʉ̈i bëetarr khʉʉnau ich mag ogdʉba, chi jẽbdi aar wëtwia oojierram aajem amach daúacha, jãga Jesús aukhërjĩ. ");
INSERT INTO noaE_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Maimua wëtwia, thũpag phëwia, i kha phuraag sĩi jʉ̈gdee wau sĩujierram anaabá. Maimua noram sĩi degpai jua ʉ̈i khëujierram aajem, Ẽwandamau Moiseeg ich iek phãpitarr gaai jaau simjö. ");
INSERT INTO noaE_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Maimua mag jua ʉ̈i khëutarr noram, domighed edpherre agtha khĩkhĩsu nʉwe, ʉʉin wëtjierram aajem chi jẽbdi aar oon, amachdëu i kha phuraag jʉ̈gdee wau wai narr dʉ̈i. Mag am wëtum dʉ̈i deeum ʉʉinjã am dʉ̈i wëtjim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Maimua ooimaawai, mokpör pömkhamua chi jẽbdi i ee joothʉ phãar sĩerrta chawag pʉrëupʉ̈i thʉnaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Magbaawai warag ag ee dubnaa oowai, maach Pör Jesús mordam ich aukhërtarr ee chukkhu thʉnaajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mag amachdëu ooba abaawai, “Keena, ¿jãga abarmta mʉg maadëu oochëba abarma?” anaajim anʉm. Mag nʉm ee oowai, emkhooin numí sĩi khajũa bʉ̈ʉmjö jũa sĩsidʉmta am khĩirphee dʉnʉʉutkhabaichëjim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Magbaawai jãphierr ajaugau pöd am khĩir eerpaba sĩi eeg ʉ̈thʉ phöbaadeewai makhʉʉnau amach garmua amag magjierram anʉm: —¿Chi monakhamta khanthee pãrau i jʉr wënʉrrʉmma ajierram anʉm, mʉg jẽbdi õor khëraag watarr ee? ");
INSERT INTO noaE_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","I ya iiu phiidʉwia petabahab. Magua mʉig khaba simgui ajim anʉm. Khĩir eyaa abat ajim anʉm, Galilea durr aawaiwe ichdëu pãachig, Emkhooi Iewaa pekau pömkham khʉʉnau i pʉr aunaa pakuls gaai i meerppʉ̈iju jaaujerr; mamʉ khãai thãrjupam ee deeu ich iiu phiidʉju jaautarrjã khĩir eyaa abat ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Magbaawaita chadcha i iekhatarr khĩir ee dʉnʉisijierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Magbaa chi jẽbdi aigmua wëtwia, chi dʉ̈i wënʉrraajerr once narr khʉʉnag thum amachdëu ootarrjöo jaauwimajierram aajem. Ich mag thum aig narr khʉʉnagjã ich agjö jaaujierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mag chi ʉʉin ich Jesuu once jʉr autarr khʉʉn aar iek jaauwimarr khʉʉnan, María Magdalena ajim aajem, Juana dʉ̈i, María Santiago ãdpa, mag tag ĩchab tagam ʉʉinpa. ");
INSERT INTO noaE_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mamʉ ʉʉinau nem ĩgkha nʉm chi Jesús khapeenau ũurwai sëukha nʉmjöo aawai ʉ̈khabajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mamʉ Pedroou mag ũrbaawai phiidʉbaadëwia jẽbdiig khaphigbaadëjim anʉm. Maimua ag ee ierr ooimaawai, ãba i pʉrëu sĩerr put appaita ooimajim anaabá. Ichdëu mag oobaawai ich diig mamua ich ödegpain, “¿Jãga awiata jãg ich aukhërtarr ee chukkhu thʉnʉ́ma?” a khĩirjubaadëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Maimua ich ag edpai õor numí phöbör Emaús anʉmʉg wëtjim aajem. Mag Emaús phöbör Jerusalenmua once kilómetros sĩejim aajem chi warphag. ");
INSERT INTO noaE_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mag ërëubaadëwia khʉd ee Jesús igwia, “¿Jãgataa i aukhërtarr eejã jãg sĩi khãidu parii thʉnʉ́ma?” a iyʉ̈ʉ wëtmajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mamʉ am mag iyʉ̈ʉ jũrr chikham i jũrr jaaupʉ̈pʉ̈ig wëtumta, amau ig narr Jesuhchata bëewia am wëtum dʉ̈i maa ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mamʉ amach bigaau mag nʉrrʉmjã pöd khaug auba, sĩi deeum khʉʉnpiita naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mag wëtumua ich garmuata, —Keena, ¿pãar khandam jaauwaita mʉg iyʉ̈ʉ wënʉrrʉ́ma? ¿Jãga jãg pãar ökhĩirjuumjö wëtmá? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Magbaawai ãb Cleofas aajerrau irig, —Maadëu khan iek agájã amapha simgui ajim anʉm. Thumaam khʉʉnau khakhapdö thʉnʉm, jãgajĩ Jerusalén phöbör ee. Pʉjã ĩchab ag phöbör ee mʉg nemkhoo dichtarrta, ¿ãba pʉchdëupaita khaugba chirʉ́? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Magbaawai ich Jesuu amag, —¿Khani jãgjierráma ajim anʉm, mʉg nemkhoo ee? Magbaa amachdëu irig jaaumamua, —Jesús Nazaretpierrma ajierram anʉm, Ẽwandam i jaaumie. Irua Ẽwandam jua theegau nem khĩir pogkhe waaujeejim. Maimua jãga Ẽwandamau maach peerdʉ aaujẽ a jaauwaijã õrau khakhapdö aajeejimgui ajim anʉm, chadcha Ẽwandam iekta jaau sim. ");
INSERT INTO noaE_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mamʉ mag khitarrta phadnaan chi pörnaanau chi thethem khʉʉn dʉ̈imua Pilatoog pʉr deebajieb ajim anʉm, jũrr ich soldaaunag pakuls gaai meerphë thõopi jaaumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amau i jãgbajupii awia marau khĩirjuawai ichdëuta israelnaan thum Romapien jua eemua pör öbeer aujupii naajimgui ajim anʉm. Mag khĩirju naajieb mamʉ, viernes i thõotarr ya khãai thãrjup pamgui ajim anʉm, ĩsim khurau i dau aphʉʉ abarm. ");
INSERT INTO noaE_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Mag nʉm ee warag ʉʉin maarjö i igar ʉ̈kha nʉm khʉʉnau ĩs edaupherre khĩsu nʉwe jẽbdi aar oothurwia maach jʉ̈gderraata jaauchëjierramgui ajim anʉm. Am iek khabá mag chi aukhërtarr ee ooimaawai, chukkhu, sĩi Ẽwandam chognaanta aig naajim anʉm. Makhʉʉnau amag jaauwai, Jesús iiu sim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mag jaaubaichëm ũrwia agjö maach eem khʉʉnaucha chi jẽbdi aar oon weetwai chadcha ʉʉinau jaau narrjö sĩi khãidu parta ooimajierram aajem a ĩgkhamajierram irig. ");
INSERT INTO noaE_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","26","Magbaawaita jũrr ichdëu amag, —Pãarta khĩirjug chukkhu nʉmá ajim anʉm. Ẽwandam i jaaumienau phãtarr gaai thum ich magta öbëbërg maju a jaaujierram, cha pãachdëu mʉrʉg jaau nʉmjö; mamʉ pãrau ʉ̈khamaphata naabahab ajim anʉm. Pãrau khĩirjuawai, ¿í ich Ẽwandamaucha jʉr autarr aawai ich jãg dau aphʉʉ aju aai khaba sĩejĩ? Mag khabamgui ajim anʉm. Ya nawe ich mag phã sĩerr aawai ich mag dau aphʉʉ aju aai sĩebajieb ajim anʉm. Mamʉ ĩchab chi jʉr autarr khʉʉu deeu iiupiwia ichta thumaam khʉʉn Pörkhapiju a simjã agjö mag Ẽwandam i jaaumienau jaaubajieb ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Maimua jũrr ichdëuta warag amag jaaubaadëjim anaabá. Nacha Moiseeu phãtarr gaaimua jaaupʉ̈pʉ̈ig khĩeb chi Ẽwandam i jaaumienau phã pʉatarr gayam magwe, ich igwia bëeju a jaau sĩsidʉm thum ajapha jaaudubjim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mag iyʉ̈ʉ wëtumua phöbördam Emaús anʉm ee amach di aar barimajierram aajem. Mamʉ mam pabaimaawai ich Jesuu warag am dakhĩir sĩi dicham ig sĩejim anʉm, juau ich thʉamkhĩirjö. ");
INSERT INTO noaE_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Magbaawai amachdëu irig, —Maar aig khãibajë. Ya atcha edau kheeuraa sĩebahab; khʉd pʉ khëujuwai ajierram anʉm. Magbaawai chadcha am dʉ̈i sĩsijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mag am dʉ̈i thʉbawia, ãba ohoodö thach khoogpamua pan ich jua ee auwia, Ẽwandamag ʉ̈u ajim anaa, thorreuwia, amag ʉapʉ̈ijim aajem, ag na ichdëu aajerrjö. ");
INSERT INTO noaE_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Magbaawaita dau eerdʉ phöbaadëmjö warre i khaug athajierram anaabá. Mamʉ mag ich khaug atham ee, dau përbarmjö arrau, am jãrr sĩerrta dëgölp chukkhu aadëjim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Magbaawai amach wir aigpai, —Keen, jãguata mʉch thãar eepain muan ich khãijãa a chirajimgui ajim anʉm ãbmua; maimua ĩchab maach dʉ̈i khʉd ee iyʉ̈ʉ urumua Ẽwandam iekpa thumaa ajapha jaaupʉ̈pʉ̈igmam ũrwiajã mua khaugaa aadëjimgui ajim anʉm ich khaperag. ");
INSERT INTO noaE_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mag amach ap iyʉ̈ʉ naawia ich ag bʉ̈rre deeu bëejierram aajem Jerusalén phöbörög, amach khapeen narr aar jawaan. Maimua oocheewai, chi Jesús khapeen i dʉ̈i ogdʉba wënʉrraajerr khʉʉn once thumaa ãbam aig podpa thʉnʉm oochëjierram aajem, tagam khʉʉn ĩchab Jesús igar ʉ̈kha narr khʉʉnpa ãba. ");
INSERT INTO noaE_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Maigjã ũrimaawai amach thumaam khʉʉnau, “Keena, chadchata maach Pörön iiu phiidʉbarmwai; ya Simonagjã ich oopibarm” a jaau nʉmta ũrimajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mag amachig jaaubaawai, amachdëujã jũrr warm khʉʉnag maguimajierram aajem: —Keena, magan maraujã pãrag jaaukhimgui ajierram anʉm, maachdëu i ootarr: Irua khabá maar ẽkha auwia khʉd ee maar i dʉ̈i ãba wëtjima ajim anʉm. Mamʉ mag khʉd ee ãba wëttarrjã marau pöd i khaug auba, sĩi ãba thach khö nʉm aig pan thorreuwia ichdëu ag na jiigjerrjö jigbaadëm aigta, marag ich khaugpimjö khaugpibaawai, marau i khaug aujimgui ajierram anʉm jũrr amach khapeenag. ");
INSERT INTO noaE_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mag agtha am ich ag iekpai jũrr jaauphöo thʉnʉm ee chi Jesús am jãrr dʉnʉʉuchëwia, —¿Jãgpai nʉ keena? Oob jãphierrmiet, mʉ khabahab aichëjim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mag sĩi dëgölp amach jãrr dʉnʉʉubaicheewai jãphierr nʉm iekhau sĩi i akhaarta oo nʉmpii naajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mamʉ mag jãphierr nʉm oobaawai ichdëu amag, —¿Khanthee pãrau pãach khĩirjug eepai “mʉʉta akhaar” anʉ́? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pãar iek mag mʉ akhaar anʉm, pãadë oobat mʉ jua maimua mʉ bʉ̈jã agjö. Chadcha mʉch khabahab ajim anʉm. Mʉ gaaicha pʉrbahut, magnaa ajapha oobat ajim anʉm. ¿Pãrau akhaar gaai pʉrju aai nʉ, mʉ gaai pʉr nʉmjö? Akhaar chan mor chukhu sĩerrʉmgui ajim anʉm, woun khaba aawai. ");
INSERT INTO noaE_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Magnaa chadcha amag ich juajãjã oopinaa, ich bʉ̈jã oopijim anaabá, chadcha mag gaaimua ichta chikhamnau pakuls gaai meerphë thõotarr ag wounau a khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mamʉ mag ichcha oo nʉmjã sĩi warag onegnaa dauderraamjö nʉm gaaimua ʉ̈khaba narr aawai ich Jesús garmuata deeu amag, —¿Keena, pãrau nem inagdam khoog chukhu nʉwi? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Magbaawai amachdëu ãwarrdam wai narr aawai chi phaamdam irig deejierram aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mag ichig deebaawai auwia am dakhĩir khöpʉ̈ijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mag ãwarrdam khö aaipawiata amag, —Keena, mʉg mʉch õrau thõojuuta mua pãrag jaaujeejimgui ajim anʉm, agtha maach ãba wënʉrraajeewaijã. Moiseeu Ẽwandam iek phãtarr gaai mʉ igwia jaau simjö, ichiita ich jãg mʉch dau aphʉʉ ajujã jaaujeejimgui ajim anʉm, mua pãrag. Maimua Ẽwandam i jaaumienau phãtarr gaaijã jaaunaa Daviiu ẽsap Salmos anʉm phãtarr gaaijã mʉ igwia ich mag phã sĩsid aawai, chadcha ichdëu jaautarrjöo thum ag eyaa öbërjimgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Maimua mag ichdëu Ẽwandam iek gaai phã sĩsidʉm jaautarr khap amkhĩir, ichdëupai am pör öphërg apijim anaabá. Magbaawain chadau i igwia Ẽwandam iek gaai phã sĩsidʉmjã thum khaphʉ nʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Magnaa amag magjim aajem ich Jesuupai: —Ich magta phã sim Ẽwandam iek gaai. Maguata chadcha mʉch chi Cristo ich Ẽwandamaucha jʉr autarr awiajã dau aphʉʉ meeju aai chirajimgui ajim anʉm. Mamʉ ĩchab khãai thãrjupam ee iiu phiidʉju arrjã jaau simgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mag mʉch chi Cristo iiu phiidʉbarm ootarr khʉʉnauta amachdëu ootarr nacha Jerusalenpienag jaaunaa ĩchab durrpierram khʉʉnagjã jaaujugui ajim anʉm, jãgata khĩirjug ajapham jʉrbaawai Ẽwandamau amach khaibag chugpaaju aai sim thumaam khʉʉnag khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mag pãrauta mʉ meewia iiu phiidʉtarrjã pãach daúacha ootarr aawai pãarta chi jaauju khʉʉnaugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mag jaaumamua ich Jesuucha amag, Pari magaagan mʉgtarr khur jöpcha murua pãar athee pʉ̈ijugui ajim anʉm Ẽwandam Akhaar, ich mʉ Ayaucha deeju a jaautarr. Mamʉ mʉig Jerusalén phöbör eepai nʉisit ajim anʉm, mag Akhaar bëe nʉm ora. Ʉ̈gtharmua ich Ẽwandamau pʉ̈ibapʉ̈im edta pãar gaai phẽs sĩeichëjugui ajim anʉm, pãachdëu ootarr thumaam khʉʉnag jaau khaphʉ jaau wënʉrramkhĩir. ");
INSERT INTO noaE_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Maimua ãbmiecha paawai phöbör eemua ich Jesuu am phë arrjim aajem phöbör Betania anʉmʉg khʉdau ma sim ee. Mam phöbör igaau pabaimaawai ʉ̈gthaag jua ʉanaa Ẽwandamag jëeumamua, —Tata, puata mʉg atagjã mʉkhʉʉn wounaan ich jãg ʉ̈u am phë wai chitajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mag am khĩir onee iekhamamua, am dakhĩraa edjã baug ee ʉ̈gthaa papagmamua, warag oohba pamamua Ẽwandamau ich aar ʉ̈gthar athajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mag i ʉ̈gthaag mam oobaawai jẽb gaai kanieu phõbkhanaa irig, —Pʉjöm chan wounaan mʉg atagjã marau oobam. Pʉchta chadcha ãba maar Pöröu ajierram aajem. Mag jëeu durrawia, deeu Jerusalenag onee wëtjim aajem, amachig jaautarrjö. ");
INSERT INTO noaE_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Maimua Jerusalén phöbör ee pawiajã ich mag ed ëepierr Aai i jëeujem deg wëtwia jëeu durraajeejim aajem.");
INSERT INTO noaE_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Warrgar bʉ̈ʉrjã nem ompaaba nʉwe Ẽwandam sim dʉ̈i chi Iewaajã sĩejim aajem. Ich mag chi Iewaapai ĩchab Ẽwandamau. ");
INSERT INTO noaE_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mag, ich warrgarwe Ẽwandam dʉ̈i ãba sĩerrajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ẽwandamau i dʉ̈imuata nem thʉnʉmjã thum ompaajim anaabá. Mag amach numiim khʉʉn jua aawai bʉ̈ʉrjã irua nem wauba arr chan chukhum. ");
INSERT INTO noaE_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ichdëuta maach akhaarjã iiupi aaujem. Maagwai i gaaimuata ararag bʉ̈ʉg oo nʉmjö maadëu khaphʉ nʉm, jãga sĩerrʉ́ ich Ẽwandam chi Aaijã, mag khaphʉ apieg ich chi Iewaata thumaam khʉʉn athee õtdau paa dʉnʉmjö sĩewai. ");
INSERT INTO noaE_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mag ichdëuta ich Aai khap apieg õtdau paa dʉnʉmjö sĩewai mʉg durr ich khaibagau sĩi edau khĩejö simuajã pöd i thõo auba aajem. ");
INSERT INTO noaE_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ich mag jaar ĩchab woun ãb Juan a thʉ̈r sim sĩejim aajem, Ẽwandamau jʉr autarr. ");
INSERT INTO noaE_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Maguan sĩi ich ẽudee deeum woun ãb bëejuuta jaau nʉrrajim aajem, mag wounta khĩchag ee õt paa dʉnʉmjö sim a jaaubaawai õor thumaam khʉʉnag mag iekta ʉ̈khamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ich Juan chan mag woun ichdëu bëeju a jaau nʉrrarr khaba, sĩi mag õtdaujö sim bëeju jaaumkhĩirpai jʉr autarr ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Magtarr aawaita chadcha mag irua jaaujerr woun i ẽudee bëebajieb, Ẽwandam Iewaa. Ichdëuta ich gaaimuapai thumaam khʉʉnag Ẽwandam jãga sĩerrʉ́ a khap apiejem. ");
INSERT INTO noaE_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mag bëewia mʉg durr ichdëu ompaatarr gaai sĩeichëjim. Pari mʉg durr gaai jooba nʉm khʉʉnau i khaug auba, sĩi parhoobam khʉʉnpii ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ich durr gaai bëetarrta, mag amach ee pierrumjã õrau i igbajierram. ");
INSERT INTO noaE_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pari i isegba ʉ̈u warag i iek ʉ̈kha nʉmua warag irigta amach peerdʉpitarr khʉʉnan ichdëujã warag Ẽwandam chaainag paapʉ̈imajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mag i chaainkha nʉm chan sĩi mʉg eegarm khʉʉnjö chaai paarpam khõchgau khapese awia paarpa autarr khabam. Mag i chaainkha nʉmʉn, sĩi Ẽwandamau ich garmuata ich iiu aawai ich chaainkha au nʉmʉu. ");
INSERT INTO noaE_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mag, Ẽwandam Iewaata wounag pawia mʉig eegar sĩeichëjim. Ichta Ẽwandam Chaai ãbpai khitʉmuata ich iiu aawai ich Aai ipierraa nem khĩir pogkhe wau nʉrrarr marau oojim. Magta i gaaimua marau khaphʉ nʉisijim, jãga Ẽwandam chi Ayaujã maach jãsene sĩerrʉ́. ");
INSERT INTO noaE_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","I jaauwiata mag Juan õor pör choomie khararrau õrag, “Mʉ ẽudee urumta mʉ khãaijã iek theeg ʉ̈rpai simgui” aajeejim, ichta i thaabaju nawe sĩerr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ichta Ẽwandam Iewaa maach dʉ̈i wajapha khitaawai maachdëu nem ig nʉmjã öo khaugbata ich mag dedee aajem. ");
INSERT INTO noaE_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ẽwandamau Moiseeg ley phãpiewai sĩi jãga wënʉrraju aai nʉ a khap amkhĩirpai phãpijim. Pari jũrr Ẽwandamau ich Iewaa Jesucristo päaiwai, ichta ich Chaai chaar aawai, warre ich gaaimuata i jãga chitʉ́ a khaphʉnaa ĩchab maach ichdëu khõsi simjã khap amkhĩirta pʉ̈ijim. ");
INSERT INTO noaE_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ãbmuajã Ẽwandam chi Aai chan bʉ̈ʉrjã ooba aajem. Pari ich chi Chaai ãbpai khitʉmjã ich Aai dʉ̈i ãbam Ẽwandamkhanaa i dʉ̈i ãba sĩejeewai i oo nʉm gaaimuata chi Aaijã warag maadëu khaphʉ paaukhamam, í jãga sĩerrʉ́. ");
INSERT INTO noaE_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mag Ẽwandamau pʉ̈iju jaaujerr bëeju anʉm ich ẽudee urum Juanau jaau nʉrrarr ed gaai Jerusalén phöbör eemua judionaan chi pörkha narr khʉʉnau phadnaan pʉ̈ijierram, Levinaan a thʉ̈ʉrjerr khʉʉn dʉ̈i, makhʉʉnau chi Juan aar wëtwia irig, “¿Pʉ khaíuma? ¿Pʉʉta nawe Ẽwandamau pʉ̈iju a jaaujerrá?” a khap jëeumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Chadcha mag wëtwia ichig jëeubaimaawai Juanau amag, —Mʉ chan nawe Ẽwandamau pʉ̈iju a jaaujerr khabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Magbaawai deeu amachdëupai, —Magan ¿pʉ khaíuma? ¿Pʉ Elías khabá? abaawai, jũrr ichdëu, —Mʉ chan Elías khabamgui ajim amag. Magbaa deeu amachdëupai, —¿Wa pʉ warrgarwe ich Ẽwandamaucha ich i jaaumkhĩir jʉr auju a jaaujerráwa? a jëeubaawai, jũrr amag, —Ʉ̈ʉ̈, mʉ majã khabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pari magʉmjã pʉaba, —¿Pʉ khaíuma? ajierram. Pua marag pʉch jaaubam, ¿marau khan a jaaubaimaagauma maach pʉ̈itarr khʉʉnag? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Magbaawai Juanau amag magjim: —Mʉʉn warrgar Ẽwandam i jaaumie Isaías khararrau jaautarrjö, ajappai õor barba aajem aar chiraajemʉugui ajim. Mʉʉn sĩi, “Maach Pör bëeimʉʉ sĩewai i bëeju nawe pãach thãar khĩir khaugbat thãraucha khõsi i iek ʉ̈khaag” a jaaujemʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pari mag khap aag irig jëwaan bëetarr khʉʉnjã Moiseeu phã pʉarr iek wajapcha ʉʉrkhaajerr khʉʉnau pʉ̈itarr khʉʉn ajim, fariseonaan. Maguata amachta chi thierrnaan awia irig mag nʉrrapimaphapaim iekhau irig, ");
INSERT INTO noaE_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Pʉ iek mag warrgarwe ich Ẽwandamau pʉ̈iju a jaaujerrjã khaba, Eliajã khaba, Ẽwandam i jaaujerrjã khabam anʉmta, magan ¿jãgwi pua õor pör choo simma? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Magbaawai Juanau, —Muan sĩi dödamaupaita õor pör choo chitʉmgui ajim. Pari pãach ee woun ãb sim, ichta ich Ẽwandamaucha pʉ̈iju a jaaujerrau. Ma agtha pãrau khaugba naabahab, mamʉ i barcheewai khĩir khaug naamkhĩirta ag nawe mua õor pör choo chitʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Maata mʉ ẽudee urum. Mʉ chan sĩi i chogkha chitaagpaijã serbiiba chirʉmgui ajim, Jesús igwia. ");
INSERT INTO noaE_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mag i khap aag irig jëeuchëtarr thum i iekhamarrpa döjã Jordán anʉm igaau phöbördam Betania anʉm ee ajim, ich Juan khararrau õor pör choo sĩerr aig. ");
INSERT INTO noaE_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mag ichig jëeuchëtarr khʉʉn dʉ̈i iyʉ̈ʉ sĩerr noram Juanau oowai, mag irua amag jaau sĩerr Jesuuta i aig ur nʉrrajim. Mag ich aig urum oo athaawai ich aig narr khʉʉnag, —Pãadë oobat ajim: Ẽwandamau pʉ̈itarr ar ur khitʉm. Jãguata corderodamjö ʉdʉraa ich thõopibarmua õor thumaam khʉʉn pekau chugpaa aujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jãg igwiata norr mua pãrag, “Mʉ ẽudee ãb urumta mʉ khãaijã iek theeg ʉ̈rpainaa ichta mʉ khãyaujã warrgarwe ich mag sĩerrʉmgui” ajim Juan chi õor pör choomieu. ");
INSERT INTO noaE_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mag jaaumamua, Mʉchdëujã khaugba chirajimgui ajim, iita ich Ẽwandamaucha pʉ̈itarr. Pari ĩsin chad mua khaphʉ chirʉmgui ajim, ich khabahab maachdëu nʉ narr. Mamʉ mʉg maach israelnaanag i khap amkhĩirta muan jãg õor pör choo chitʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Maimua mag jajawagmamua, ĩchab ewag pawi ichdëu ootarr igwiajã Juan chi õor pör choomieu, —Muan mʉch daúacha Ẽwandam Akhaarta duburjö khitʉmta ʉ̈gtharmua bëewia Jesús gaai jupbaichëmjã oojimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ag nawe chan mua khaugba chirajimgui ajim, iita warrgarwe Ẽwandamau pʉ̈iju a jaaujerrkha sim. Mamʉ mʉg õor pör choomkhĩir mʉch pʉ̈itarrauta mʉchigcha, “Ar pʉch dakhĩraa chi Akhaar ʉ̈gtharmua bëewia woun ãb sim gaai jupbaicheewai pua khaphʉ aju, mag wounauta ich Ẽwandam Akhaarcha õrag deemaju” a jaautarr aawai, ");
INSERT INTO noaE_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ĩsin chadau mua i khaphʉ chirʉmgui ajim, mag mʉchig jaautarrjö bëewi i gaaita jupbaichëm mʉch daúacha ootarr aawai. Maguata ĩchab mua khaphʉ chirʉmgui ajim Juanau Jesús igwia, i chadchata Ẽwandam Iewaau. ");
INSERT INTO noaE_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Maimua ag noram agtha mag phöbördam Betania anʉm aig mʉ chirajim, mʉch khapeen dʉ̈i, maach maestro Juan khararrpa ãba. ");
INSERT INTO noaE_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mag maig maar nʉmta, Jesús dich nʉrrʉm oobaawai maar maestroou, —Pãadë oobat: Jãata Ẽwandamau pʉ̈itarrauwai ajim, corderodamjö ʉdʉraa ich thõopibarmua õor peerdʉ aumkhĩir pʉ̈itarr. ");
INSERT INTO noaE_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Maach jʉ̈g daar maach maestro Juanau mag iekhabarm ũrbaawai Jesús ẽudee maar wëtjim. ");
INSERT INTO noaE_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mag dichmamua ewag oowai, maar ich ẽudee wëtum khaug athaawai marag, —¿Pãar khanta jʉr wënʉrrʉ́ma? ajim. Magbaawai marau jũrr irig, —Maestro, ¿pʉ jam chiraajẽ? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Magbaawai Jesuu marag, —Magan mʉ dʉ̈i wëttarrau ajim, mʉ chiraajem aar khaugaan. Magbaa chadcha i dʉ̈i wëtwi i sĩerr aar maar barimajim. Mamʉ ya maagwai kheeuragam las cuatrojö sĩerr aawai warag ich maig khëujim. ");
INSERT INTO noaE_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mag Juanau Jesús jaau sim ũrwia ãb agjö mʉ dʉ̈i ẽudee matarr Andrés ajim, Simón Pedro dʉ̈i khod ãbam. ");
INSERT INTO noaE_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mag Andrés anʉmua ich naam Simón jʉraan mawia oobaimaawai irig, —Ya ĩsin chadau maran warrgarwe Ẽwandamau Mesías pʉ̈iju a jaaujerr dʉ̈ita oobarmgui ajim anʉm. (Mag Mesías aawai griego meúa Cristo aawaiu.) ");
INSERT INTO noaE_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Maimua chadcha chi Simón ich dʉ̈i aibëejim, maar Jesús dʉ̈i narr aig. Mag ich aig waipierrwai Jesuu chi Simonag, —Pʉ Simón khabahab ajim, Jonás iewaa. Pari ĩsmua atag pʉ Cefas a thʉ̈rjugui ajim. (Mag Cefas aawai griegonaan meúa Pedro aawaiu. Mag Pedro a sim aig mokpör aawaiu.) ");
INSERT INTO noaE_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ag noram Jesús jũrr Galilea durr maju aadëjim. Mag nʉm ee Felipe dʉ̈i oojim. Mag oobaawai irig, —Felipe, mʉ dʉ̈i marrau ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Mag woundam Felipe anʉm phöbördam Betsaida anʉm eem ajim, Andrés dʉ̈i Pedropa ãba naajerr phöbör eem. ");
INSERT INTO noaE_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Maimua jũrr Felipeeu deeum woun Natanael anʉm jʉraan mawia, irig maguimajim aajem: —Natanael, maran ya Jesús dʉ̈ita wënʉrrʉmgui ajim anʉm, ar Nazaret phöbör ee woun ãb José aajem ag iewaa dʉ̈i. Ich jãg igwiata Moisés khararrau ẽsap phã pʉarr gaaijã jãg jaaunaa, Ẽwandam i jaaumienaujã jãg jaauba aajeejieba aimajim aajem Felipeeu. ");
INSERT INTO noaE_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Magbaawai chi Natanaelau Felipeeg, —Ʉ̈khabamgui ajim anʉm. ¿Khaíu pʉrʉg jaauwai mag Nazaret phöbör eemuata õor chi thethemkha öbërju a jaaujĩ? ajim anʉm. Mamʉ magbaawai chi Felipeeu, —Magan oobahur ajim anʉm, khap aag. ");
INSERT INTO noaE_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Magbaawai chadcha i dʉ̈i bëejim. Mag bëewia ya ich aig pabaicheewai Jesuu irig —Achá khitaichëm israel chaardam. Mʉg woundaman chadchata ö akhaar wajaphata chirabpama ajim ichigcha. ");
INSERT INTO noaE_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jesuu ichig mag iekhabarm ũrbaawai Natanaelau irig, —¿Jãga pua mag mʉ ö akhaar ajapha chirʉm khaphʉ chirʉ́? ajim. Magbaa Jesuu irig, —Felipeeu pʉ mawag ëeurrju nawe, ar pʉch dikhu gaau igo bʉ̈ eegar sĩewai, mua pʉ oobajieb ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Magbaa Natanaelau, —Maestro, pʉʉn chadchata Ẽwandam Iewaau. Pʉch khabahab ajim, israelnaan Rey marau nʉ narr. ");
INSERT INTO noaE_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Magbaa Jesuu irig, —¿Igo bʉ̈ eegar mʉchdëu pʉch ootarr a jaaubaawaita pua mʉrʉg mag chirʉ́? Ĩsta pua ag khãyaujã nem wajapcharam oogpabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Maimua ich Jesuupai ĩchab maach thum ich dʉ̈i khapeerkha aumarr khʉʉnag, —Mua pãrag jaaukhimgui ajim: Cha iekha chirʉm iekhau chadcha mʉch chi Emkhooi Iewaa aigta Ẽwandam chognaan ʉ̈gtharmua eegjã bëenaa deeu ʉ̈gthaa waaidʉtkhakhakham oojugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Magtarr khur khãai thãrjup nʉm ee, Galilea durr phöbördam Caná anʉm ee õor jua pʉr naajim. Maig Jesús ãdjã dʉ̈i sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mag jua pʉr nʉm ee, ich Jesujã thʉ̈rpʉ̈iwia aig sĩerr aawai i ãdau irigta, ");
INSERT INTO noaE_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","—Vino thumaa öbaadëmwai ajim. ");
INSERT INTO noaE_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Magbaa chi chaairau irig, —¿Pua khanthee mʉrʉg mag sĩ? Mʉch nem wau chitʉm gaaimua agtha õrag mʉch khaugpiju ora khaba sĩebahab ajim ich ãdag. ");
INSERT INTO noaE_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pari ich iewaau ichig magbaawai chi phiejãb wau narr khʉʉnagta warag ich ũan Mariaau, —Irua pãachig nem mag aawai i ipierraa abat ajim. ");
INSERT INTO noaE_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Judionaan amach i aawai Ẽwandam na amach wajapha nʉm aag jua dʉ̈i bʉ̈pa ʉpʉ̈pʉ̈i aajeejim. Magua, magaag athee döjã iigjerr aawai mag phiesta ee thũr mokdau dën dʉ̈rrcha khithëem seis wai naajim. Makhʉʉn thũr ee de cincuenta a setenta litros dʉ̈rr aajeejim, dö. ");
INSERT INTO noaE_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Maimua Jesuu mag chi phiejãb wau narr khʉʉnag makhʉʉn thũr döou ipiirkhapi jaaujim. Mag chadcha ich ipierr ipiirkhabapäaiwai amag, ");
INSERT INTO noaE_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","—Jãimua ag eem jöi arrwia chi phiesta ee nʉm khʉʉn pörkha simʉg dö oopibamit ajim. Magbaa chadcha ichdëu jaautarrjö i ipierr dö oopijierram. ");
INSERT INTO noaE_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pari mag chi phiesta ee nʉm khʉʉn pöröu mag dö atarrta vinoog paa simjã khaugbata dö sĩejim. Ãba chi phiejãb wau narr khʉʉnaupaita khaphʉ naajim, amach dakhĩir arr aawai. Mag dö oowi chi pörkha sĩerrau chi jua pʉr chirarr woundam thʉ̈r auwi ");
INSERT INTO noaE_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","irig magjim: —Thumaam khʉʉnau vino chi wajapcharamta nacha õrag jiigjerram; maimua mag dö nʉʉ awiata jũrr parhoobam vino jiigjerramgui ajim. Pari pua magba ewaata chi wajapcharam jigaagpamgui ajim irig, mag dö atarrta vinoog paa simjã khaugba. ");
INSERT INTO noaE_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mag Galilea durr phöbördam Caná anʉm ee dö vinoog paatarrta warrpem õrau nem ooba aajem Jesuu wautarr ajim, mag wau sim gaaimua ich jua theeg oopieg. Mag, maach i dʉ̈i wënʉrraajerr khʉʉnaujã warag wajapcha i khaphʉ nʉisijim, chadcha Ẽwandamau warrgarwe pʉ̈iju a jaaujerr dʉ̈ita maach wënʉrrʉm. Magta marau warag i iek ʉ̈kha nʉisijim. ");
INSERT INTO noaE_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Maimua magtarr khur ich ag Galilea durr eepai deeum phöbördam Capernaum anʉmʉg maar phë arrjim, ich ãd dʉ̈i ich eeugpeenpa. Mag phöbördam ee khãaidam khapanaa maar naaimajim. ");
INSERT INTO noaE_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judionaan phiesta Pascua aajem burrju gayaa arr aawai Jesús Jerusalenag majim. ");
INSERT INTO noaE_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Maimua irua ooimaawai, Aai i jëeujem degta sĩi phakjã përnaa, ovejajã përnaa, duburjã përnaa maimua sĩi õrag phatkhon cambie nʉm khʉʉnpata ohood thʉnʉm ooimajim. ");
INSERT INTO noaE_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ichdëu mag oobaimaawai maar dakhĩraa aig jʉ̈gad werba sĩsid arr jãaupʉrnaa agua bobojog thum amach phak dʉ̈i ovejapa dawag jʉrkhʉʉipʉ̈ijim. Magnaa chi phatkhon cambie narr khʉʉn mesjã jẽkhʉt sĩekhʉʉipʉ̈pʉ̈i khabaadeewai am phatkhonjã sĩi parhooba khuyiupʉ̈imajim. ");
INSERT INTO noaE_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Magnaa chi dubur për narr khʉʉnag, —Jöpkhaa pãach nemchaain mʉigmua phë athaadët; mʉ Aai di chan sĩi pãrau merrkaúg paapäaig khabamgui ajim amag. ");
INSERT INTO noaE_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Irua mag iekhabaawai maar khĩir ee dʉnʉisijim, Ẽwandam iek phã sim gaai, “Ẽwandam, pʉrʉg jëeujem di kõitan mʉʉn nem aneeme chitaawai ag gaaimua mʉʉn õor jua ãwatab khaba ãwatju” a phã sim. ");
INSERT INTO noaE_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mag amach dakhĩir dawag õor jʉrkhʉʉibapʉ̈im oobaawai judionaan chi pörnaanau irig, —Pʉchdëu Ẽwandam di kõit jãg chirʉpí, pʉ iek mag pʉʉta Ẽwandamau warrgarwe pʉ̈iju a jaaujerr anaawai magan maar dakhĩir ag na marau nem ooba aajem ich Ẽwandam dënjö waubá ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Magbaawai ich Jesuu warag amag, —Pãrau magta oom khõsi nʉm khai, magan mʉg di chʉyëubapʉ̈it; magbaa khãai thãrjup nʉm ee mua deeu ëu dʉnʉʉujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Magbaawai chi judionaanau irig, —Mʉg Aai i jëeujem di ëu awaag cuarenta y seis años phidkhatarrta, ¿puata mag khãai thãrjuppaim ee deeu ëu dʉnʉʉujũu? ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pari Jesuu mag amag di a simjã chi di chaar igwia khaba, ich mor igwiata mag sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","I mag iekhatarr aawaita, amau i thõowia deeu iiu phiidʉtarr khurjã maach chi i dʉ̈i ogdʉba wënʉrrarr khʉʉnaun i iekhatarr khĩir eyaa naajim. Mag warag warrgarwe Ẽwandam iek phã sĩsidʉm gaai Jesús igwia phã sĩsidʉmjã wajapcha khaphʉnaa ich Jesuu ich iiucha maachig nem jaaujerrjã warag marau khaphʉ nʉisijim. ");
INSERT INTO noaE_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mag Jerusalenag mawia am phiesta Pascua ee simua ich iiu aawai ag na õrau nem ooba aajempa wautarr oowia õor khapanaam khʉʉnau i iek ʉ̈khajierram. ");
INSERT INTO noaE_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pari mag õrau ich iek ʉ̈kha nʉm anʉmjã ichdëu wajapha khaphʉ sĩejim, õrau chadcha thãraucha ich iek ʉ̈khaba nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pari mag khaug aumamjã õrau ichig jaaubamta sĩi ichdëupaita õor thumaam khʉʉn thãar khaug aumaajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Woun ãb sĩejim, Moiseeu Ẽwandam iek phã pʉatarr wajapcha ʉʉrkhaajem khʉʉn eem, Nicodemo a thʉ̈r sĩerr. Maan judionaan eem chi thethem ajim ĩchab. ");
INSERT INTO noaE_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mag wounau edaar Jesús aig bëewia irig, —Maestro, marau khaphʉ nʉmgui ajim, chadcha Ẽwandamauta pʉ pʉ̈ijim, ich iek marag jaaumkhĩir. Í pʉ dʉ̈i sĩewai merag chukhu simgui ajim, jãg ag na õrau nem ooba aajempa pʉchdëu wau sim gaaimua. Magba aawai ni ãbmuajã jãg pua nem wau simjö wauba nʉmgui ajim. Magua mʉ pʉ aigta bëejimgui ajim, Ẽwandam chi Pörkha sim aar jãga mʉ i dʉ̈i chirsiju mʉchig khap jaaumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Magbaawai Jesuu irig, —Pʉdë ũrbarí, mua pʉrʉg jaaukhimgui ajim: Chi deeu eeupemjö thaababa sim chan pöd Ẽwandam ichta chi Pörkha sim aar öbërbamgui ajim, i chaai khaba sĩewai. ");
INSERT INTO noaE_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Magbaawai Nicodemoou irig jëeumamua, —¿Pari jãga ya mʉg maach chi jöoi chirʉm deeu thaababarju? ajim. ¿Wa deeuta dich ãd bi ee dubju aai sĩwa ajim, ũwaai thaababaag? ");
INSERT INTO noaE_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Magbaawai jũrr Jesuu deeu ũwaai, —Ʉ̈ʉ̈, mua chan sĩi thaabaa chaar thaaba nʉm jaauba chirʉmgui ajim. Mua mag eeupemjö thaabaju a chirʉmʉn, Juanau pör choo simua jaaujerrjö Ẽwandam Akharag dich khĩirjug chi iiurig paapʉ̈ipi nʉmta jaau chirʉmgui ajim. Magbam chan pöd Ẽwandam sim aar öbërbam, agtha i dën khaba sĩewai. ");
INSERT INTO noaE_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maach ãdau maach thaaba nʉmʉn sĩi mʉig eegarpai wënʉrraagau. Pari Ẽwandam Akhaar au nʉmuata deeu thaababarmjö nʉmʉn chadau jũrr ʉ̈gthar pawiajã ich mag wënʉrraagau ajim. ");
INSERT INTO noaE_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pari mua mag pãach thumaam khʉʉnta deeu thaabaju aai nʉm a chirʉm ũrwia oob atcha jʉ̈gderraa amgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ẽwandam Akhaar au nʉmʉn phũ wë thʉnʉmjöta simgui ajim. Phũun parhooba ich wëm aig nem theeg juu urum ũurjem, pari pöd khaugba aajem, jammuata urú wa jamagta ma. Ich agjöta simgui ajim, Ẽwandam Akhaarjã õor ee sĩeicheewai. Chi Akhaar bʉ̈ʉrjã ooba nʉm, pari mag simuata ich iiu aawai eeu thaababarmjö maach khĩirjug chi iiurig paapäaijemgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Magbaawai deeu ich Nicodemooupai Jesuug, —Pua mag sim aig, ¿jãga aawaiuma? ajim irig. ");
INSERT INTO noaE_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Magbaawai Jesuu irig magjim: —¿Pʉʉta israelnaan ee maestro aawai õrau iigjemta mʉg mua Ẽwandam Akharauta khĩirjug ajaug paapäaijem jaau chirʉmjã khaugbata chirab? ");
INSERT INTO noaE_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pʉdë ũrbarí, pʉrʉg jaaukhimgui ajim: Maraun chadcha maachdëu khaphʉm nemta jaaunaa maach daúacha ootarrta jaaujem, mamʉ pãrau ʉ̈khamapha nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Magnaa irig, Mʉig eegarm nemdampai mua jaau chirʉmjã pãrau ʉ̈khamapha nʉm, ¿jãga ʉ̈khaagauma ajim, ya Ẽwandam khĩirjugcha mua pãachig jaaubaadeewai? ");
INSERT INTO noaE_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Agtha iwiir ãbjã ʉ̈gthar Ẽwandam sim aar maba sim, i khĩirjug khap aag; ãba i aarmua bëetarr wounaupaita Ẽwandam khĩirjugan khaphʉ simgui ajim, õrag jawaag; wajapcharan mʉch chi Emkhooi Iewaama. Mʉch khabahab ajim, Ẽwandam aarmua bëetarr aawai deeu i aar maju. ");
INSERT INTO noaE_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pari magaag atheyan, israelnaan õor maba aajem ee jãg Moiseeu phë wai nʉrraawai Ẽwandamau irig bronce dën nemkhõrkha waunaa pa gaai ʉ̈gthaa jiirjoppi jaautarrjö, ich agjöta ĩchab mʉch chi Emkhooi Iewaajã pa gaai jiirjopju aai chirʉmgui ajim, magbarmua õor peerdʉju ayaa amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wajapcharan mag nemkhõrkha wau sim pa gaai jiir wëjorragta oobaawai monaaujerrjö, chi mʉrʉgta ich peerdʉ aupi sim khʉʉn peerdʉwia Ẽwandam aarcha öbërwia ich mag iiu sĩerrajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Pari magaagta Ẽwandamau oowai mʉg durr gaaim khʉʉn thum ya chi okhoomta nʉm khaphʉ arr aawai, ich garmuata am peerdʉ aum khõchgau mʉ ich Iewaa ãbpai khitʉmta am kõit thõmkhĩir pʉ̈ijimgui ajim, magbarm gaaimua chi mʉrʉgta amach peerdʉ aupi nʉm khʉʉn chan okhooba, mʉig eegarwejã ich dënkhanaa ich aar öbërwia ich mag ich dʉ̈i wënʉrramkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ẽwandamau mʉ pʉ̈itarr chan, sĩi õor khaibag waupi jaaumkhĩir khaba, sĩi am peerdʉ aumkhĩirta mʉ pʉ̈ijimgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Mʉch chi Ẽwandam Iewaa iekta ʉ̈khanaa mʉ ig sim woun chan Ẽwandamau isegwia khĩmie durr barpʉ̈ibam. Pari ar mʉ igba sim chan ya sĩi barpʉ̈ijupaita simgui ajim, ichdëu Ẽwandam Iewaa mʉchta ãbpai chitʉmta igba arr gaaimua ichdëupaita wir aig ich isegpi jaau simjö sĩewai. ");
INSERT INTO noaE_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mag amachdëupai wir aig amach isegpimjö nʉmʉn, nem khaigbamta waum khõchgau Ẽwandam Iewaa igba nʉm gaaimuau. Amach mag nʉm gaaimuata mag õor peerdʉ awaag õtdau paa dʉnʉmjö chirʉm bëewaijã mʉ igba nʉmgui ajim, ich mag khĩchag eeta meraa nem wau nʉmjö naam khõchgau. ");
INSERT INTO noaE_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Maguata ar thum Ẽwandam dau na nem khaigba wau nʉm khʉʉnan jũrr mag õtdau paa dʉnʉmjö chirʉmta oomapha aajemgui ajim. Mag mʉ oomapha naawaita mʉ igjã igba nʉm, mag amach meraa nem wau nʉm khaugam ugua awia. ");
INSERT INTO noaE_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pari magba ar jũrr nem wajapham appai waum khõsi aajem khʉʉnau chan mʉ isegba, warag mag õtdau paa dʉnʉmjö chirʉmta iigjerramgui ajim, Ẽwandamau khõsi simjöta nem agcha wauju khaphʉnaa amachdëu mag wajapha nem wau nʉm bigaaum khʉʉnagjã khap amkhĩir. Magta Jesuu Nicodemoog, jãga Ẽwandamta chi Pörkha sim aar ijã chiraimaju aai chirʉ́ a jaaujim. ");
INSERT INTO noaE_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mag phiesta Pascua dichtarr khur Jesuu maar phë arrjim Jerusalenmua chawag, ich ag Judea durr eepai. Maig nʉmua õor pör choojeejim. ");
INSERT INTO noaE_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ich mag jaar ĩchab Juanaujã agtha õor pör choo nʉrrajim aajem, maagwaiwe chan agtha i cárcel deg pʉ̈iba narr aawai. Mag i õor pör choo sĩerr aig Enón a thʉ̈r sim, Salim dakha. Maigta dödam naphʉ khërarr aawai õor pör choojeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pari õrau jaauwai mag nʉm ee ĩchab ãaur Juan dʉ̈i wënʉrraajerr khʉʉn garmua jũrr judío ãb aig sĩerr dʉ̈i chikham ipeer ahaukhamua, “Magan ¿khaíu pör choobarmta wajapcha sĩ, Jesuu pör choobarm wa maar maestroou choobarmwa?” anaajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mag ijẽjẽb nʉʉ awia warag ich Juan aarcha wëtwia ichigcha, —Maestro, ar chum Jordán igaau edau öbeerjem igar, pʉchdëucha marag jaauwai Ẽwandamau pʉ̈itarr a sĩerr wounaujã ĩchab õor pör choo nʉrrʉm aajemgui ajim anʉm. Maagwai õor pöm ʉ̈rcha i aarta phẽphẽeukham aimajierram aajem irig. ");
INSERT INTO noaE_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Magbaawai Juanau amag, —Oob iekkhõr waumiet ajim anʉm. Ẽwandamauta ichdëu khap õrag jaauba aajeeb, ichdëu khõsi simjöta nem waumkhĩir. Mag sĩewai ichdëuta juau irig jãgpi sĩebahab ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pãach jʉ̈gʉucha khabá pãrau ũr naajimgui ajim anʉm, ar mua “Mʉ chan warrgarwe ich Ẽwandamau pʉ̈iju a jaaujerr khaba, sĩi i bëeju na i jaau chitʉmʉu” a chiraawai. Magua mag i aarta ʉ̈rcha õor phẽphẽeu awiajã mʉ onee chirʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pãrau ooba aajẽ ajim anʉm, jua pʉr nʉm khʉʉnjã: chi ʉʉi dʉ̈i nawe iek deewi simta chi jayau; pari chi mag eeu pa nʉm khʉʉn paairinkha sim dʉ̈i am bigaau simjã ĩchab onee aajem. Maarjã ich agjöta naabahab Jesús dʉ̈i. I jãg sim aig woun ãb eeu ʉʉi au simjöta sĩebahab. Magua amau jãg i aarta phẽphẽeukham aig, mʉjã dʉ̈i ĩchab onee chirʉmgui ajim anʉm, sĩi õrag i jaau chitʉmua. ");
INSERT INTO noaE_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iita mʉ khãaijã warag thʉ̈rphöo pamaawai mʉ jũrr i khãai eeg papagmam; pari mag nʉm aig ʉ̈u sim a iekhamajim aajem, ich chi õor pör choomieu Jesús igwi. ");
INSERT INTO noaE_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Maimua mag iekhamamua ich Juan chi pör choomieupai Jesús igwia, ’Iita ʉ̈gtharmuacha bëetarr aawai ichta chadcha maach thumaam khʉʉn khãyaujã ʉ̈rʉʉcha sĩebahab ajim anʉm. Pari mʉ magba sĩi pãachjö mʉig eegarmpai aawai mʉg eegarm khʉʉn dënjöpaita jaau chirʉmgui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mamʉ irua magba, mʉ khãaijã ʉ̈gtharmta ichdëucha oowia ichdëucha ũrtarrta jaau sĩebahab ajim anʉm Jesús igwia. Mamʉ magʉmjã khapancha khaba nʉm i iek ʉ̈kha durrum khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pari ar ʉ̈u i iek ʉ̈kha durrum khʉʉnaun mag ʉ̈kha nʉmua, “Ẽwandamaun chadchata iekha sĩerrʉm” anʉm khabahab ajim anʉm, Jesús igwia i Iewaa a iekhaawai. ");
INSERT INTO noaE_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Í chadcha ich Ẽwandamauchata pʉ̈itarr aawai ich Ẽwandam khĩirjugta jaau simgui ajim anʉm, magamkhĩirta irig ich Akhaarjã phẽs dee sĩewai. ");
INSERT INTO noaE_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chi Ayaujã ich Chaai jãsene wai sĩewai nem thʉnʉmjã thum ãba irigta jaaubajieb. ");
INSERT INTO noaE_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Magtarr aawai chadcha chi Ẽwandam Iewaagta ich peerdʉ aupi sim khʉʉn mʉg eegarwejã ya ich dënkha sĩsimgui ajim anʉm, i aar öbërwia i dʉ̈i ich mag nʉrraag. Pari Ẽwandam Iewaa iekta ʉ̈khaba abarm chan i aarjã öbërba, warag i gaaita Ẽwandamau ich khĩir machag meeupʉ̈ijugui ajim aajem, ich Juanau ich dʉ̈i wënʉrraajerr khʉʉnag. Magta Juan chi õor pör choomieu Jesús thö iekhamajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mag Juan chi õor pör choomie dakha maach Pör Jesujã sĩerr aawai fariseonaanau khaug athajierram, Juan aar maju khãai ʉ̈rcha Jesús ẽudeeta õor pos aadëphʉm. Mag nʉm dʉ̈i ĩchab khaug athajierram, Juan aram khãyaujã ʉ̈rcha Jesuugta õrau amach pör choopi nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mamʉ wajapcharan ich Jesuujã chooba, maach i dʉ̈i wënʉrraajerr khʉʉnauta õran pör choojeejim. ");
INSERT INTO noaE_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mag, fariseonaanau Jesús aarta ʉ̈rcha õor poposkham khaphʉ aphöbaadëm ich Jesuujã khaug athaawai Judea durrmua jũrr ichta warag Galileaag petajim. Magbaawai maar i dʉ̈i wëtjim. ");
INSERT INTO noaE_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mag wëtumua ichiita Samaria durr dichab khaba dichju ajim. ");
INSERT INTO noaE_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mag wëtmaa awia ich Samaria durrpai phöbördam Sicar a thʉ̈r sĩerr aig maar barjim, jöoi Jacob khararrau jẽb për auwia ich meebaadeewai ich iewaa José aajerrag werpʉatarr dakha. ");
INSERT INTO noaE_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mag jẽb ich chaairag werpʉatarr gaai posjã sĩejim, ich jöoi Jacob khararrau khörpitarr pos. Mag wënʉrrʉmua ich Jesús ya khajeeu sĩerr aawai mag pos aar mawia ag i dakha jupimajim. Maagwai ya edausĩe paimʉʉ sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mag nʉm ee maar phöbör ee wëtjim, maach athee khöju për awaan. Mag maar ërëubaadeewai Jesús ich appai oo chirʉm eeta, i iek Samariapie ʉʉi ãb mag pos eem dö jöyaan bëejim aajem. Mag ich aig pierrwaita irua, —Mʉrʉg bʉchkhun dödam doog jöi deebá a chirajim aajem irig. ");
INSERT INTO noaE_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mamʉ judionaan Samariapien dʉ̈i dau parii iyʉ̈ʉ aba aajerr aawai, mag ichig dö jëeubaawai chi ʉʉirau irig magjim aajem: —Pãar judionaan chan maar Samariapien dʉ̈i iekhajã mapha aajem khʉʉnta, ¿khanthee pua mʉrʉg dö jëeu sĩwi? ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Magbaawai jũrr Jesuu irig, —Ẽwandamau pʉch athee nem deeg wai sim khaphʉnaa khaíuta pʉchig dö jëeu simjã khaphʉ akhiin, pʉch garmuata pua mʉrʉg dö jëeukhamgui ajim anʉm. Magbaawai mua pʉrʉg õor iiupiejem döota deekhamgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ichig magbaawai jũrr chi ʉʉi garmua, —Señor, pari pua chi jöi aujujã chukhu sim, mʉg pos jã naug sim eem pua pöd jöi aubamgui ajim anʉm. ¿Jamaam dö mag maach iiupiejem anʉm mʉrʉg deeg agá? ");
INSERT INTO noaE_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Jam pua mʉiguim khãaijã dö wajapcharam bawaag agá? ajim anaabá. Nachgarwe maar jöoi Jacob khararrauta mʉg pos marag werpʉajim. Ag eem ichdëujã döwia, i chaainaujã döwia, i nemchaainaujã döjierram. Magtarrta, ¿pua ag khãyaujã wajapcharam dö ig chirʉ́? ajim anʉm. ¿Wa pʉʉta i khãaijã ʉ̈rpai chirʉ́wa ajim aajem, mʉg khãai dö wajapcharam bawaag? ");
INSERT INTO noaE_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Magbaawaita Jesuu irig magjim aajem: —Cha mʉ iekha chirʉm iekhau, mʉg pos eem dö dö nʉm khʉʉnan thum ichiita deeu öbisi aphöbaadeewai ũwaai dö döm khõsi ajugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pari mua dee chirʉm dö khĩirta dö nʉm khʉʉn chan bʉ̈ʉrjã öbichag chukhu ich mag wënʉrraju. Mag amachdëu döbarmpaita am mor ee ich mag khumdʉ öbër sĩsimjö sĩejugui ajim aajem, ich mag Ẽwandam dënkha nʉisieg. ");
INSERT INTO noaE_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Magbaawai jũrr chi ʉʉi garmua, —Señor, magan mag dö khĩir mʉrʉg deebá ajim anʉm, tag öbichag khaugba aadeewai mʉg pos eem döjã jöyaan bëeba aag. ");
INSERT INTO noaE_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Magbaawaita Jesuu, —Magan pʉch jaai athamí a ajim anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Magbaa chi ʉʉirau, —Mʉ chan jaai chukhu ʉmgui ajim anʉm. Mag jaai chukhu ʉm abaawai Jesuu irig, —Pʉchigan pʉ jaai chukhu ʉabma ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pʉ jaai aum cinco auwia sim. Maimua cha pʉchdëu wai simjã, magan jã chan pʉ jaai khabahabma. Pʉʉn chadcha wajapha khĩirjunaata iekha ʉmgui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mag ich öbeerbapʉ̈im ũrbaawaita irig, —Mua oowai pʉjã dau bʉ̈ʉmjöta simgui ajim anʉm, mʉ mag ʉrrʉm khap aag. ");
INSERT INTO noaE_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Maimua ichdëupai, Maar jöoin Samariapienaun mʉg Gerasim durr gaaita Ẽwandamag jëeujeejimgui ajim aajem chi durrsĩig jua ʉanaa. Pari pãar judionaan iek mag ãba Jerusalenam Aai i jëeujem degpaita Ẽwandamag jëeuju aai nʉm aajem. Pua oowai, ¿jamta chadcha irig jëeuju aai nʉwi? a jëeujim aajem irig. ");
INSERT INTO noaE_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Magbaawai Jesuu irig, —Pʉdë mʉ iek ũrbarí ajim anʉm: Ya mʉg atag paawai pãrau khĩirjubaju, mʉg durrsĩ gaaita Ẽwandamag jëeuju wa Jerusalén mawiata Ẽwandamag jëeuju. Magbarm aigmua parhooba pãach nʉm aigmua irig jëeuju aai aphöbaadëjugui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pãar Samariapienau chan Ẽwandamag jëeu nʉm anʉmjã wajap i khaugba nʉmta irig jëeujem. Pari maar judionaanaun chadau, maach meeun eem ãb öbërbarm gaaimuata Ẽwandamau õor peerdʉtkhaju khaphʉ naawai, irigta jëeujemgui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pari ĩs irig jëeu chaar jëeu nʉm khʉʉnaun mʉg atag paawai warag Ẽwandam Akharau khõsi simjö jëeujugui ajim anʉm, ya amau Ẽwandam jãga sĩerrʉ́ a khaphʉ naawai. Ichig mag jëeu nʉm khʉʉnta ich Ẽwandamaujã iigjemgui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ẽwandam chan maachjö mʉg mor chukhu sim, Akhaar aawai. Maguata ʉ̈khaa chaar ʉ̈kha nʉmuata ich Ẽwandam Akharau khõsi simjöta irig jëeuju aai naabahab a chirajim aajem chi ʉʉirag. ");
INSERT INTO noaE_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Magbaawai jũrr chi ʉʉirau irig, —Ʉ̈ʉjʉ̈, mua khaphʉ ʉmgui ajim anʉm, Cristo anʉm bëeju, warrgarwe ich Ẽwandamau pʉ̈iju a jaaujerr. Mag ich pierrum edta ichdëucha thumaa wajapha jaauchëjugui ajim anʉm, jãga sĩerrʉ́ Ẽwandam. ");
INSERT INTO noaE_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Magbaawai, —Mʉʉta ag Cristo warrgarwe ich Ẽwandamau pʉ̈iju a jaaujerr khabahab; ich ag wounta ĩs pʉ dʉ̈i iyʉ̈ʉ chirabahab ajim anʉm Jesuu, warre ich jaauwia. ");
INSERT INTO noaE_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Am mag iyʉ̈ʉ nʉm eeta maar bardʉtkhachëjim. Maimua mag Samariapie ʉʉi dʉ̈ita iyʉ̈ʉ nʉm oobaicheewai chadcha maar dauderraa naajim. Pari magʉmjã ãbmuajã irig, “¿Pʉ khanta irig jëeu sĩ, wa khan ata pãar iyʉ̈ʉ naajĩjã?” abajim. ");
INSERT INTO noaE_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mag Jesuu ichig, “Mʉʉta Ẽwandamau pʉ̈iju a jaaujerr khabahab” abaawai, ich döthũr werpʉawia phöbörög khaphigbaadëjim. Mag mawia barwia õrag, ");
INSERT INTO noaE_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Mau mʉ daupierr oobahuthʉ̈ ajim anʉm, pos aar woun ãb simua, mua ichigjã jaauba arrta, mua nem waaujem thumaa khaphʉ mʉrʉg jaaubarm. Mua khĩirjuawai, jãata warrgarwe Ẽwandamau pʉ̈iju a jaaujerrjöo simgui aimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mag chi ʉʉirau amach aar jaaubaimaawai chadcha phöbör eem khʉʉnaujã Jesús oon wëtju aphöbaadëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pari mag chi ʉʉi phöbör ee nʉrrʉmich, ya maar deeu i aig paaukhachëwi narr aawai marau irig, —Maestro, thachdam khö athá aajeejim. Pari mag ichig thach khöpi jaaubaawai jũrr, ");
INSERT INTO noaE_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Mʉ thach khöju wai chirabahab, pari mag thach khĩir pãrau khaugba nʉmgui ajim ichdëu. ");
INSERT INTO noaE_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Warag maachig magbaawai jũrr, —¿Wa ãbmua i athee thach khömkhĩir deethurtarr aawaita mag sĩwa? aajeejim marau. ");
INSERT INTO noaE_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pari maar mag iekha nʉm ũrbaawai Jesuu marag, —Mua mag thach khöju wai chirʉm a chirʉmʉn, Ẽwandamauta mʉ pʉ̈itarr aawai irua khõsi simjöta nem wau chirʉmʉugui ajim, mʉchig phidag jaaupʉ̈itarr thumaa öpʉ̈yaag. ");
INSERT INTO noaE_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pãrau nemjĩir phierraag agtha ed jayap waaur nʉm aajeebma. Pari mua jũrr pãrag, pãach bigaau õor pöm trigo phur wëjömjö thʉnʉmta oobat a chirʉm. Jãg trigo phur wëjöm apuraa eeujemjö, jãkhʉʉnagta Ẽwandam iek jaaubat a chirʉmgui ajim, amag ʉ̈khamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Õor jãg thʉnʉmʉg Ẽwandam iek jaau nʉmta nemjĩir phierr nʉmjö phidkha nʉm khʉʉnag chan Ẽwandamau phagab khaba phagjugui ajim. Mag amau i athee õor gan aumam khʉʉnan ich mag i dʉ̈i wënʉrraagau. Ya mag nʉisim aig chi nacha i iek jaautarrjã onee awia ẽudee jaaumamua ʉ̈khapi atham khʉʉnjã chi nacha jaautarr dʉ̈i ãba onee ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ar õrau, “Chi nemjĩir jĩir simuan sĩi jĩirmam, pari khar chan pöd ichdëupai eeuba aajem” aawain chadcharauwai ajim. ");
INSERT INTO noaE_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iin chadcha deeum khʉʉnauta nacha chi phidagan ëudʉ aujierram; pari magtarrta jũrr pãachta am phidag gaaimua wajapcha aju. Pãach chi bʉ̈ʉrjã phithurg auba narrta nemjĩir phierramkhĩirjöta mua pãar pʉ̈i chirʉm a jaaumajim marag, maachdëu ich iek jaau wënʉrrʉmua õrag ʉ̈khapi aumaju igwia. ");
INSERT INTO noaE_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mag chadcha ʉʉi dö jöyaan khitawia, “Jesuu bʉ̈ʉrjã ichig jaaubamta mua nem waaujem thumaa khaug athajim” a jaaubaimaawai, mag Samaria durr phöbördam sĩerr ee õor khapankham khʉʉnauta i iek ʉ̈kha nʉm iekhau, “Magan chadcha ich Ẽwandamaucha pʉ̈iju aajerrau” awia chi Jesús oon bëejierram. ");
INSERT INTO noaE_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Maimua chadcha mag bëewi chi Jesús aig barchëjierram, chi phöbör eemua bëetarr khʉʉn. Mag i aig paaukhachëwia irig, —Mʉig maar aig khãibajë ajierram. Ichig magbaawai chadcha thʉbawia khãai numí sĩejim am phöbör ee. ");
INSERT INTO noaE_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mag khãai numiim ee ichdëucha jaau sim ũrwia, warag khapanaacharam khʉʉnauta i iek ʉ̈khajierram. ");
INSERT INTO noaE_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mag amachdëucha Jesuu jaau sim ũrwia ʉ̈khatarr khʉʉnau chi ʉʉirag, —Ya ĩs chan sĩi pua jaau sim ũrwiapai khaba, maach jʉ̈gʉucha i iek ũrwiata marau ʉ̈kha nʉmgui aajeejim. Ya chadcha marau khaphʉ nʉm, jãguata chadcha durrpierr ich iek ʉ̈kha nʉm khʉʉn thum peerdʉ auju khabahab aajeejim jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Jesús mag Jerusalenmua mawi, Samaria phöbördam ee khãai numí sĩeimawi, warag ich maa arrag petajim, Galileaag. Mamʉ mag phiesta dichtarr khur Jerusalén thʉbaba arran, ag na ichdëu iekhatarrjö, chi Ẽwandam iek jaaujem khʉʉn chan ãbjã amach durr ee ãba naajem khʉʉnaupaijã kha khõchkhaba aajeewai ajim. Magta ich thaabatarr durrmua warag Galileaag petajim, ich bãautarr durr. ");
INSERT INTO noaE_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mag maa awia Galilea durr barbaimaawai, mamaam khʉʉnau ʉ̈u i wajapha amach ee barpijierram, i dʉ̈i ãba Jerusalén phiesta Pascua anʉm ee naawai irua nem wautarrjã thum amach daúa oo narr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mag Galilea durr paimawia deeu Canaag majim, ag na ichdëu dö atarrta vinoog paatarr phöbörög. Maagwai ĩchab Capernaum phöbör ee sĩejim woun ãb rey dʉ̈i phidkhaajem, chi thethem. Mag dën chaai mor mas sĩejim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mag chi thethemua Jesús Judeamua bëewia jũrr Galilea barbaichëm a ũrbaawai i aar mawia irig chaigpamamua, —Mʉ chaai ya pödba khërʉmta oo pʉajim; mʉ ap chitʉm mʉ di aar marrau aichëjim, mʉ chaai monaaupäain. ");
INSERT INTO noaE_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pari magbaawai Jesuu irig, —Pãrau chan pãach daúacha ag na õrau nem ooba aajem wau nʉm oobam aigjã Ẽwandam jua theeg mʉ gaai sim ʉ̈khaba sĩerrjëemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pari magbaawai chi thethem garmua warag irig, —Señor, mʉ ap chitʉm jöpai mʉ chaai oomierrau, meeju nawe. Ya parba khërʉmta mua oo pʉabajieb ajim. ");
INSERT INTO noaE_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Magbaa, —Oob atcha khĩirjum, pʉ chaaidam nauwe monaaubajup ajim Jesuu. Ichig magbaawai ich chaai meejujã khĩirjuba, Jesuu ich chaai monaaupʉ̈ijuuta ãba khĩirjumamua ich diig petajim. ");
INSERT INTO noaE_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mag ich diig mam ee i chognaan i khĩirphee bëewia i dʉ̈i oobaicheewai irig, —Pʉ chaaidam monakha khërʉm ajierram anaabá. ");
INSERT INTO noaE_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Magbaa ichdëu amag jëeujim aajem, khan ora chaai deeu khĩirdam inaa aadëjĩ. Mag amachig jëeubaawai, —Norr kheeurag la una naawia warre khʉʉumie meeuba khërsijimgui ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Magbaawai chi ayau ich ödegpai, “Magan mag orata Jesuu mʉrʉg ‘Oob atcha khĩirjum, pʉ chaai monaaubajup’ a iekhajiebma” ajim aajem. Mag ich chaaidam monaaubapʉ̈im oobaawai ichdëujã ʉ̈khanaa i deg dʉ̈i ãba naajerr khʉʉnaujã thum chadcha Jesuuta Ẽwandam Iewaa warrgarwe ichdëu pʉ̈iju aajerrau awia i iek ʉ̈kha nʉisijim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mag chaai parba khërʉm warppaimua monaaupʉ̈itarrta Judeamua bëewi Jesuu Galilea durr biek numiim õor dakhĩir ag na amau mag ooba aajem wautarr ajim, mag chaai monaautarr gaaimua ichta Ẽwandamau pʉ̈itarr a õrag khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Magtarr khur Jerusalén phöbör ee judionaan phiesta wai narr aawai, Jesús deeu agʉg petajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mag Jerusalén phöbör ee dubaag “Ovejanaan Puertdi” a thʉ̈r sim dakha thʉ̈rrdö juau wautarr estanque anʉm sim. Mag thʉrrdö thʉ̈r ebreonaan meúa Betesda aajem. Mag thʉ̈rrdö igaau pórticos anʉm cinco naajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma, sĩi jʉserg eegar arr aawai mor masim khʉʉn khapan thũphãau thʉnaajeejim: dau khĩsu khithëem khʉʉn, bʉ̈ wëdʉ wëdʉ khithëem khʉʉn, maimua sĩi juadam wa mor ëntër khãijã kha chʉkhʉ khithëem khʉʉnpa. Maig nʉmua dö waaurëwaata nʉ naajim, ");
INSERT INTO noaE_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kharii Ẽwandam chog ʉ̈gtharmua bëewia mag dö waaurëu pʉabajëm ee chi nacha dubbaimamta monaaujerr aawai ag ee dubaag. Mag dö waaurëu pʉabajëm ee chi nacha dubbaimamʉn parhoobam khamor machag wai sĩerr khãijã monaaub khaba monaaujeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mag mor masim khʉʉn pöm thũphãau wëjöm ee sĩejim ĩchab woun ãb treinta y ocho años, sĩi kha chʉkhʉ aawai pöd ich appaijã phiidʉba khitʉm. ");
INSERT INTO noaE_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mag werba khërʉm Jesuu oobaimawia mag año khapan dau aphʉʉ khërʉmjã khaug athaawai irig, —¿Pʉ monaaum khõsi chirʉ́wi? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Magbaawai chi mor masi khërarrau, —Señor, mʉʉn monaaum khõchag chirʉm; pari chi dö waaurëu sĩubaawai ag ee mʉ jiirpʉ̈iju khʉʉn chukhu aawaita pöd monaauba chirʉmgui ajim. Maadëu ag ee dubaag ẽkhaawai maach nawe ãbmua ag ee paajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Magbaawai Jesuu irig, —Magan phiidʉwia dʉrdʉr abá; maimua pʉch put juurwia athaad ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ichig magbarm bʉ̈rre chadcha warrjã ich mag monakha sĩerrjöta phiidʉ dʉnʉisiwia dʉr nʉnʉʉu khabaadëjim. Maimua ich put juur auwia ag dʉ̈i petajim. Pari mag i monaautarr ed jua ʉ̈ʉijem ed arr aawai, ");
INSERT INTO noaE_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Moiseeu phã pʉarr iek wajapha ʉʉrkhaajerr khʉʉnau irig, —Ĩs chan pua jãg put chʉgag jiir wai nʉrraju khaba simgui ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pari ichig magbaawai chi woundamau amag, —Pari chi mʉ monaaupʉ̈itarrauta mʉrʉg “Pʉch put juurwia athaad” atarr aawaita mua arrubahab ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Magbaawai amachdëu, —¿Chijãguata pʉrʉg mag sĩejĩ? ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pari mag i monaaupʉ̈iwia ich Jesujã sĩi õor khapanag ee dubbaaderr aawai pöd i khaugpʉ̈iba arr gaaimua, ĩs mag thʉ̈r thʉ̈rnaa mag wounauta mʉrʉg mag jaaujimjã abajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Maimua ag khur Jesuu ich ag woundamcha Aai i jëeujem deg oobaimaawaita irig, —Ya ʉ̈u pʉ jãg monaau chirsipí, oob tag pekau wau chitam. Eeu magbamʉn jũrr pʉch gaai ag khãai atcha khãijã adukham ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesuu ichig magbaawai judionaan chi pörnaan aar mawia amag jaauwimajim aajem, Jesuuta chadcha ich monaautarr. ");
INSERT INTO noaE_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mag gaaimua judionaan chi pörnaanau chan warag Jesús khõchkhaba aajeejim, mag amach dakhĩir jua ʉ̈ʉijem edam magwe õor monaaujerr aawai. Amagan mag nʉmdampai phidkha nʉm dʉ̈i ãba sĩerr aawai jua ʉ̈i nʉm ed pöd magju khaba sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pari Jesuu mag chi judionaanau khĩirju nʉmjã khaphʉ sĩerr aawai amag, —Jua ʉ̈ʉijem edam magwe mʉ Ayaujã õor dau aug khaaugjeewai muajã ich agjöta chirʉm khabahab ajim amag. ");
INSERT INTO noaE_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesuu amach jʉ̈g daar mag iekhabaawai chará waragta i thõopʉ̈im khõchkha phöbaadëjierram. Pari wajapcharan amach dënjö jua ʉ̈ʉijem edjã ʉʉrkhaba sim gaaimuapaijã khaba, am jʉ̈g daar Ẽwandam igwia i Aai a iekhaawaita mag i thõom iigjeejim, mag sim aig magan iita Ẽwandam dʉ̈i ãba chirabma awia. ");
INSERT INTO noaE_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Pari Jesuu warag, —Mʉch chi Chaairaujã mʉch Ayau nem waupim khõsi sim khaugba akhiin, muajã mʉch khĩrau chan waubajugui ajim. Magba irua nem waupim khõsi sim mʉchdëu khaphʉ chiraawaita muajã chadcha waaujemgui ajim Jesuu chi judionaanag. ");
INSERT INTO noaE_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mag ich mʉ Ayaujã mʉ khõsi aajeewai ichdëu nem waupim khõsim thum mʉrʉg khap apiejemgui ajim. Maagjeewai ĩsmua atagta mua nem wau chirʉm gaaimua pãrau i jua oogpamgui ajim. Ante mʉg woun monaautarr khãaijã ʉ̈rʉʉcha mua nem waumaju. Mag oowiata pãar dauderraa ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ich jãg chi Ayaujã õor mee nʉm khʉʉnjã phiriutkha auwia ich mag ich dʉ̈i wai sĩejemjö, mʉch chi Chaairaujã mʉchdëu magam khõsim khʉʉn dʉ̈in ich agjö ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ich Ẽwandam chi Ayaujã ichdëu chan jaauba, mʉch chi Chaairagta jaaupiejem, õor ich aar auju wa auba isegju, ");
INSERT INTO noaE_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mag gaaimua ich jãg mʉ Aai thö iyʉ̈ʉ aajemjö mʉch chi Chaaijã agjö thumaam khʉʉnag thö iekhamkhĩir. Mag sĩewai mʉch chi Chaairagjã eenaa wajapha mʉ thö iekhaba nʉm khʉʉnau chan magan mʉ Aaijã thöba nʉmgui ajim, ichdëu mʉ pʉ̈itarrta mʉ mʉg chitʉmjã igba naawai. ");
INSERT INTO noaE_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Mʉ cha iekha chirʉm iekhau chi mʉg mua jaau chitʉm iekta ũrwia ʉ̈kha simuan Ẽwandam iekta ʉ̈kha simgui ajim, chadcha ichdëuta mʉ pʉ̈iwia mag ich iek jaaupitarr aawai. Mag ʉ̈khabarm wounan Ẽwandamau ya ich dënkha auwia ich mag i dʉ̈i sĩsim iekhau. Magbarm woun gaai Ẽwandamau ichdëu õor i agkha nʉm edjã mas abajugui ajim, warr ich khaibag eepai chi thõmjö sĩerrta ich mag iiu nʉrraag ya chi peerdʉm aawai. ");
INSERT INTO noaE_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chadcha ĩsta pãar mag chi thõmjö nʉm khʉʉnaujã mʉch chi Ẽwandam Iewaa iekcha ũrju ed pabaichëmgui ajim. Mag mʉ iek ũrwia ʉ̈kha nʉm khʉʉnan warre Ẽwandam dënkhanaa mʉg atagjã ich mag iiu nʉisijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ich jãg chi Ayaujã ichdëuta õor iiupiejemjö, ich dënjö amkhĩir mʉch chi Chaairagjã agjö ich jua theeg deejimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mag nʉm dʉ̈i ĩchab mʉrʉgta õor ich aar auju wa auba isegju a jaaumkhĩirjã iek theeg apijimgui ajim, mʉchta Emkhooi Iewaa aawai. ");
INSERT INTO noaE_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mag muata õrag amach khĩircha jawaagjã iek theeg chirʉm a ũrwia oob jʉ̈gderraa amiet. Pari chadcha mʉchdëuta mʉg atag ötarr khʉʉnagjã amach bëptarr jẽbdegmua öbeerpi jaaubaawai deeu iiu phiidʉtkhajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chi nem wajapha waaujerr khʉʉnan tag meeba ich mag Ẽwandam dʉ̈i wënʉrraagta phiidʉtkhaju; pari nem khaigbamta waaujerr khʉʉnan Ẽwandamau amach isegwia khĩmie durrta barkhʉʉiju abarm ũraagpaita phiidʉtkhajugui a jaaumajim ich Jesuucha. ");
INSERT INTO noaE_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Mʉ Ayauta mʉ pʉ̈itarr aawai irigjã jëeuba sĩi mʉch khĩrau chan pöd mua nem wauba chitʉmgui ajim. Maguata, mʉch Ayau jaaubaawaita mua agpierr nem waaujem; mag ichdëu jaau sĩewai nem agchata waaujemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mua mʉch igwia mʉchdëupaita mʉ iek theeg chirʉm akhiin, mua magju khaba chirʉmgui aju õrau, tag mʉ ipierr jaau nʉm khʉʉn chukhu aawai. ");
INSERT INTO noaE_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pari ãb simgui ajim, ma mʉ Ayau. Iruata mʉ kõit chadcha nem agcha jaaujem. Mua khaphʉ chirʉmgui ajim, mag irua nem jaau sim chadcharau. ");
INSERT INTO noaE_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pãrau Juan aar õor pʉ̈ijierramgui ajim, iita Ẽwandamau pʉ̈iju aajerrá a khap jëeumkhĩir. Magbaawai irua, í chan ar khabam, ãb i ẽudee urumta aruugui ajim, mʉ igwia. Ichdëu mag pãrag jaaupʉ̈itarr chadcha ajimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pari mʉ chan mag sĩi õraupaita jaauju aai nʉmjã abam. Mua mag Juan igamjö chirʉmʉn, irua nem jaaujerr ʉ̈khawia pãach peerdʉtkhamkhĩrau ajim. Mʉ wajapcha khaphʉnaa jaauju aai sim chan mʉig eegarm khabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanan chadcha lámpara dau wajaug phuu dʉnʉmjö sĩejim, muata õor peerdʉ auju aai chirʉm a jawaag. Mag irua jaau nʉrrarr ũurwai pãach jʉ̈gaagaa arr aawai khũchpain pãar onee ajierramgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pari Juanau sĩi idamaupai jaau nʉrraajerr khãai mua wajapcharam wai chirʉmgui ajim, aguata Ẽwandamau mʉch pʉ̈ijim a khap apieg. Ma, õrau ag na nem mag ooba aajem waaujem ag jua theegaugui ajim. Mag jua theegau mʉ Ayau nem khĩir pogkhe waupi jaautarr aawai, õor dakhĩir mag waauwai, chadcha ichdëuta mʉ pʉ̈ijim a jaau sim khabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pãrau oojã ooba ni i iekjã ũrba naab mamʉ, ich mʉ Aai mʉ pʉ̈itarraujã agjö mʉ igar sim a sim, ichdëuta warrgarwejã mʉ igwia ich iek gaai phãpitarr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pari mag ichdëu mʉ pʉ̈iwia mua jaau chitʉmjã pãachdëu ʉ̈khaba naawai pöd i iekjã pãrau pãach thãar ee auba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pãraun sĩi Ẽwandam iek phã sĩsidʉm gaai thʉ̈rnaa ag gaai jaau sĩsidʉm ʉʉrkha nʉmuata pãach peerdʉjupii awia thʉ̈ʉrjerram. Pari par mag ag gaai thʉ̈ʉrwai mʉ igwia jaau sĩsidʉm oo nʉmta, pãrau pãach thãar theeg nʉm gaaimua ");
INSERT INTO noaE_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","bʉ̈ʉrjã mʉ igba nʉmgui ajim, ich mag iiu wënʉrram khõsi nʉm anʉmta. ");
INSERT INTO noaE_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Mua chan mag pãrag sĩi mʉchig ee amkhĩirta nem wauba chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mua khaphʉ chirʉm, pãrau chan thãraucha Ẽwandam khõchkhaba nʉmta sĩi par iiupai i khõsi nʉm aajerram. ");
INSERT INTO noaE_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mʉʉn ich mʉ Aai iekhau pʉ̈iwiata mʉg chitʉm; pari magʉmjã mua mag jaauwai pãrau mʉ iek ʉ̈khaba nʉmgui ajim. Mamʉ jũrr ãb sĩi ich khĩraupai bëewiata pãrag magchëkhiin, mag iekhan chadau pãrau ʉ̈khajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Jãga pãrau mua nem jaau chirʉm ʉ̈khabarju ajim, jãg Ẽwandam ichta ãbpai khitʉmta pãachdëu nem wau nʉm gaaimua onee apiju khĩirjubanaa ãba pãach khapeenagpaita pãach thöpim khõsi thʉnʉm? ");
INSERT INTO noaE_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Oob pãach jãg nʉm paar muata Ẽwandamag pãach khaibag waumkhĩir irig nem ĩgkha thʉnʉʉuju amiet ajim amag. Chi Ẽwandamag pãar ĩgkhajuun Moiseeuta pãar ĩgkhabajup, sĩi irua phã pʉarr iek wajapha ʉʉrkha nʉmuata pãach ʉ̈gthar öbërpiju anʉmta chadcha irua phã pʉarr thum ipierraajã khaba naawai. ");
INSERT INTO noaE_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Chadcha pãrau Moiseeu phã pʉatarr thumta ipierraa nʉm akhiin, ichdëu Ẽwandam iek phã pʉarr gaai mʉ igwia jaau pʉarr aawai, pãrau mʉ iekjã ʉ̈kha naakhamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pari irua mʉ igwia mag phã pʉarrjã pãrau ʉ̈khab nʉm, ¿jãga ĩs mʉchdëucha jaau chirʉmjã ʉ̈khabarju? ajim amag amach khĩircha. ");
INSERT INTO noaE_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Magtarr khur deeu Jesús petajim, ag khĩirpheepai thʉrrdö pöm Galilea a thʉ̈r sim ee. Ich ag thʉrrdöpai ĩchab Tiberias a thʉ̈ʉrjem. ");
INSERT INTO noaE_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mag i ag khĩirphee petaawai õor pöm i ẽudee ërëubaadëjim, amachdëu mag õor mor masim khʉʉn pöoma monaaumamua i jua theeg oojerr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mag mawia maar na buchagdam gaai waaidʉwia jupbaimaawai maarjã i bigaau jupimajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Maagwai judionaan phiesta Pascua aajem ya burrju ʉ̈rʉʉ sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesuu oowai mag ich ẽudee õor pöoma bëewia pos aichëm oobaawai Felipeegta, —Felipe, õor pöm mʉg wëjöm athee ¿jamta maadëu khöju bawaagauma? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pari ichdëu Felipeeg mag sĩerran, daau irua khan abarju khai awiata mag sĩejim. Mamʉ ich Jesuu ichdëu khap nem wauju khĩirju sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Magbaa Felipeeu irig, —Doscientos denarios wai nʉm anaa sĩi pan appai aukhiinjã, agdaujö dau ããbdöjã dʉ̈rrkhabajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Magbaawai maar khapeer ãb Simón Pedro eeum Andrés a thʉ̈ʉrjerrau, ");
INSERT INTO noaE_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ãb mʉig chaaidam simuata pandam cinco wai nʉrrʉmgui ajim, maimua ãwarrdam dau numí. Pari õor pöm mʉg wëjöm, ¿khanii jãgpaimua dʉ̈rr abarju? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Andreeu magbaawai Jesuu jũrr maragta, —Magan amag thum ohoodö api jaaubat ajim. Mag jaaubaawai chadcha thumaa phũak ee ohood aphöbaadëjim. Mag õor pöm wëjöm ee emkhooin appai cinco miljö naajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Maimua Jesuu makhʉʉn pandam ich jua ee phë auwia, Ẽwandamag ʉ̈u ajim anaa, jũrr marag ʉapʉ̈imajim, jũrr õor pöm mag ohood wëjömʉg jigmamkhĩir. Maimua jũrr chi ãwarrdam paarjã ich agjö Ẽwandamag ʉ̈u ajim anaa agjö jigpijim, amachdëu khöm aig khömkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Maimua ya thumaam khʉʉn biwaauwia tag khömapha aphöbaadeewai, sĩi barpʉ̈iju khãai, Jesuu marag phëpi jaaujim. ");
INSERT INTO noaE_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Maimua chadcha marau thumaa phënaa oowai, mag pandam cincopai narrta thʉbʉt doce ipiirkha aujim, chi sobau. ");
INSERT INTO noaE_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Õor pöm mag thʉnarr khʉʉnau amach daúacha Jesuu ich iiu aawai mag ag na amau mag ooba aajerrta mag waubarm oobaawai jũrr amach eepai, “Chadcha mʉg wounta ich Ẽwandamaucha ich i jaaumkhĩir jʉr auwi pʉ̈iju a jaaujerrauwai” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mag nʉmua warag ajués ich pʉr arrwia amach reikhapim ig nʉm ichdëu khaug athaawai warag durrsĩeg petajim, mam ich appai sĩeimaag. ");
INSERT INTO noaE_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Maimua ya edau khëubaadeewai maar jerag bëewia, thʉrrdö ee burrdʉtkhachëwia, ");
INSERT INTO noaE_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","jũrr jap ee paaukhabaadëjim, ag khĩirphee phöbör Capernaum anʉmʉg wëtaag. Mag maar döjãrr paaukhabaadëm ee warag khĩssu aadëjim. Maagwai ich Jesús agtha bëeba sĩerr aawai maar dʉ̈i maba thʉba sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mag ya maar döjãrr wëtumta, phũ theeg wëbaadeewai sĩi phũas baupa aadëjim. ");
INSERT INTO noaE_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ya maagwai maar döjãrr naajim. Cinco khabamʉn seis kilómetros khãijã naajim, döi aigmua chi warphag. Mag nʉm eeta marau oowai, Jesuuta döjã ʉ̈r durramjö dʉdʉrg urum oophöbaadëjim. Mag oophöbaadeewai maar jãphierr phöbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pari mag maar jãphierr phöbaadeewai ichdëu marag, —Oob jãphierrmiet, mʉ khabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Magbaawai warag marau maach jap ee i thʉ̈r aujim. Mag maar dʉ̈i jap ee pabaadeewai sëukhabarmjö abarm ee jöpchata ya maar maach maa arr aar naaimajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ag noram ãspaau thoom igar thʉbagkhatarr khʉʉnau khaug athajierram aajem, jap ãbpai aig sĩerr ee maar ërëubaadëm. Mag maar weetwai chi Jesús maar dʉ̈i maba arrjã khaphʉ naajim aajem ĩchab. ");
INSERT INTO noaE_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mag nʉm ee ich ag thʉrrdö eepai phöbör Tiberias anʉm aarmua bote bëewia, mag ag noram Jesuu pan cinco ich jua ee aunaa ag paar ʉ̈u ajim anaa õrag khöpitarr dakha jopdʉtkhachëjim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mag chadcha amachdëu oowai, Jesús aig khaba ni maar i dʉ̈i wënʉrraajem khʉʉnjã aig khaba nʉm khaug athaawai, mag bote jopdʉtkhachëtarr ee jũrr döjãrr paaukhabaadëjim aajem Capernaumag, Jesús ẽudee i jʉr wëtumua. ");
INSERT INTO noaE_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Maimua mag wëtwia chadcha ag khĩirphee Jesús sim oobaimaawai irig, —Maestro, ¿khan orata pʉ mau pabaadëjĩma? ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Magbaawai Jesuu amag, —Chadcha pãrau mʉ jʉr wënʉrrʉmʉn, sĩi pãach thach biwaau khöpitarr aawaita pãrau mʉ jʉr wënʉrrʉmgui ajim. Mamʉ ĩs mag mua jãg pãach dakhĩir wautarr gaaimua mua jaau chitʉm ʉ̈khakhimjã aba nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jãg sĩi biwaau thach khöm khõchgaupai mʉ ẽudee ẽkha wënʉrraju khãyau, tag bʉ̈ʉrjã jãsöo apiba ich mag pãach iiupiejem pan khĩirta athat ajim amag. Mʉch chi Emkhooi Iewaauta mag pan pãar athee wai chirʉm. Mʉch Aai Ẽwandamau pãrau ag na mag nem ooba aajem waumkhĩir juapá deetarrauta nem waaujeewai pãrau mʉ iek ʉ̈khanaa ichdëuta mʉ pʉ̈itarrjã khaphʉ aju aai nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Magbaawai amach garmua jũrr irig, —¿Marau khani wauju aai nʉ ajierram, Ẽwandamau nem waupim khõsi simjö aag? ");
INSERT INTO noaE_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Magbaawai Jesuu amag magjim: —Ẽwandamau pãrag waupim khõsi simʉn, mʉʉta warrgarwe ichdëu pʉ̈iju a jaaujerr aawai mua nem jaau chitʉmta pãrag ʉ̈khapim khõsi simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Magbaawai deeu amachdëu irig, —Pua deeu maar dakhĩir ag na marau ooba aajemta waukhiin chadau marau chadcha pʉ Ẽwandamauta pʉ̈ijim aju. ¿Mamʉ khani pua wau nʉ? ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maimua amachdëupai, Maar jöoin õor chukag durr wënʉrraajeewai Moiseeu “maná” anʉm ʉ̈gtharmua khʉipitarrta khöjierramgui ajierram. Ich Ẽwandam iek phã sim gaai jaauwaijã, “Ʉ̈gtharmua pan khʉipiwia amag khöpijim” a sim. Maagwai puajã, ¿khani wau nʉ? ajierram deeu irig. ");
INSERT INTO noaE_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Magbaawai Jesuu amag, —Pari Moiseeu khabajimgui ajim amag pan deetarr; mʉ Ayau khabajieb ajim. Maimua ĩsjã agtha ich mʉ Ayauta ʉ̈gtharm pan pãrag dee sĩebahab; pari ĩsimʉn warr pãar jöoinag deejerr khãaijã chi wajapcharamʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Magnaa ichdëupai ich igwi, Pari mag pan ich Ẽwandamauta dee sĩewai ʉ̈gtharmuachata bëejimgui ajim, õor iiupi awaag. ");
INSERT INTO noaE_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Magbaawai amachdëu irig, —Señor, magan mag pan marag ich mag dee chitá ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Magbaa Jesuu, —Wajapcharan mʉchpai khabahab ajim, mag pan õor iiupiejem. Mʉig eegarin par pãar thach pöm biwaau khöwiajã deeu jãsooju. Biwaau dö döwiajã deeu öbisi aju. Mamʉ chi mʉ iek ʉ̈khanaa mʉʉta au sim chan tag deeum igbajugui ajim, ich peerdʉ aumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mamʉ chaig mʉchdëu pãrag jaau chirarrjö, pãraun mʉ oo naab mamʉ, bʉ̈ʉrjã mʉ iek ʉ̈khaba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Thum mʉ Ayau mʉ iek ʉ̈khapi nʉm khʉʉnaun mʉ ig nʉm. Mag mʉch ig nʉm khʉʉnan mua aub khaba aujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mʉ chan sĩi mʉchdëu am aig nem wawaagjã ʉ̈gtharmua bëebajim. Mʉʉn mʉch Ayau mʉchig nem mag abaawai i ipierr aagta bëejimgui ajim, ichdëuta mʉ pʉ̈itarr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ich chi mʉ pʉ̈itarr Jöoiraujã khõsi simʉn, mag ya mʉch õorkha thʉnʉm khʉʉn eem ãbjã okhoopiba, sĩi mʉg durr ö nʉm edjã deeu phiriutkha aupim khõsita simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mʉ Ayaun, ar mʉ igwia “Jãata chadcha i Iewaau” anaa mʉ iek ʉ̈kha nʉm khʉʉnta mʉg atag pawiajã ich mag ichjö iiu wënʉrrapim khõsi sim. Pari magaagan mʉg atag mʉg durr ö nʉm edjã mʉchdëuta am phiriutkha aujugui ajim ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Irua magbarm ee chi judionaan sereu phöbaadëjim, Jesuu amach jʉ̈gdaar “Mʉʉta ʉ̈gtharmua bëetarr Panau” a iekhabaawai. ");
INSERT INTO noaE_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mag sereu phöbaadëwi amach eepai, —Keena, pari ¿chamʉg Jesús maachdëu oo bãautarr khabá anaajim, José iewaa? Mag simta ¿jãga mag iita ʉ̈gtharmua bëetarr abarju? Magan maadëuta i dënnaan khaugba naab, i mag iekha chirʉm anaajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Magbaawai jũrr ichdëu amag, —¿Khantheeta pãachig iekhaawaijã pãar dën warag magta iekhaajerráma? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Chadcha ich mʉ Ayauta mʉ pʉ̈itarr aawai ichdëuta mua õrag jaau chitʉmjã ʉ̈khapibam chan ni ãbmuajã pöd mʉ iek ʉ̈khabamgui ajim. Ichdëu ʉ̈khapibaawai ʉ̈khabarm khʉʉnan chadau mʉg durr ö nʉm edjã deeu mua am phiriutkha aujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ẽwandam i jaaujerr khʉʉnau ẽsap phã pʉarr gaai jaauwai, ich Ẽwandamauta ich õorkha nʉm khʉʉnag jaaukhamaju a sim, ich iek khaugmamkhĩir. Ichdëucha magtarr aawaita ar thum i iek ũrnaa ʉ̈u i khaugphömam khʉʉnaun mʉjã igjuraugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mua mag chirʉm chan mag õrau i oojeewai aba chirʉm. Ãba i oowia i khaphʉ simʉn, mʉchta i sim aarmua bëetarr aawai mʉchdëupaita i oojemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Magnaa, Mua mag chirʉmgui ajim: Chi mʉ iek ich thãraucha ʉ̈kha simʉn mʉg atagjã ich mag Ẽwandam dënkha sĩsim iekhau. ");
INSERT INTO noaE_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mʉʉta chadcha õor ich mag iiu wënʉrrapiejem Panaugui ajim deeu Jesuu, ich igwia. ");
INSERT INTO noaE_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pãar jöoinaun chadcha õor chukag ee durr phʉʉr wënʉrraawai maná khöjierram. Amau mag maná khöjierrab mamʉ, ichiita khëchjierramgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mamʉ mua jaau chirʉm pan chan mag maná khĩir khabam. Mua mag ʉ̈gtharmua bëetarr pan a chirʉmʉn, mʉch jaauwiata mag chirʉmgui ajim. Chi mag panta khöbarm wounan ich magta iiu sĩsim iekhau. ");
INSERT INTO noaE_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mʉchta mag pan ʉ̈gtharmua bëetarr õor iiupiejem khabahab ajim. Mag panta khö simʉn ich magta iiu sĩsiju. Mamʉ mag panjö mua pãrag deeju a chirʉmʉn, thumaam khʉʉn iiu wënʉrraju aai amkhĩir am kõit ʉdʉraa mʉch thõopijuuta jaau chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Amach pem aawai, Jesuu mag iekhabapʉ̈im ũrwia, deeu sereu phöbaadëwia amach eepai, “¿Jãga jãg simua maachig ichta pankha khöpibarju?” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jũrram khʉʉnau mamagkham ũrwia Jesuu amag magjim: —Mʉ cha iekha chirʉm iekhau ar mʉch chi Emkhooi Iewaa modta khöwia mʉ bagjã döba sim chan pöd ich mag iiu nʉrrabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Magarrau chadcha chi mʉ mod khöwia mʉ bagjã dö sim khʉʉn chadau meewiajã deeu iiu phiidʉwia ich mag iiu sĩsim iekhau ajim. Pari magaagan mʉg atag mʉg durr ö nʉm edjã mʉchdëuta deeu ũwaai i phiriu aujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mua mag chirʉmʉn, mʉ modouta mʉ bag ãrbarm dʉ̈imua chadcha õor iiupi auju aawaita mag chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chi mʉ mod khönaa mʉ bagjã dö simʉn mʉ dʉ̈i khapeerkham iekta khapeerkha sĩsiju. Maagwai mʉch garmuajã i dʉ̈i ich mag khapeerkha chirsijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mʉ Aai mʉ pʉ̈itarrjã mee khaugba sĩerraawai mʉchjã i gaaimuata ich mag iiu chitʉm. Maagwai ĩchab chi mʉ modta thachjö wajap khö sim khʉʉn, ich jãg mʉjã mʉch Aai gaaimuata ich mag iiu chitaajemjö, mag wounjã ĩchab mʉ gaaimuata mʉg atag pawiajã ich mag iiu sĩsijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Muan pãragan mag pãar jöoinau maná khoojerr khĩir khaba, ʉ̈gtharmua bëetarr panta khöpi jaau chirʉmgui ajim. Mag maná õor ich mag iiupiejem khĩir khaba arr aawai par amau khö durrajieb pari mag khö nʉm gaaimuata Ẽwandamau am auju abajim. Mamʉ cha mua pan jaau chirʉmta khöbarmʉn chadau Ẽwandamau auwi ich mag ich dʉ̈i wai sĩsijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesuu amag mag iekhatarran Capernaum phöbör ee judionaan Ẽwandam iek jaaujem di wai narr eeta mag jaaumajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesuu mag jajawagmam ũrwia õor pöm i ẽudee wënʉrraajerr khʉʉn ee ãaur khʉʉnau, “Keena, mʉg wounan dau lökta nem jaau nʉrrʉm, ¿khaíu i ipierr abarju?” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pari amach eepai mamagkham ich Jesuu khaug athaawai amag magjim: —¿Mua mag jaau chirʉm ũrwia pãar thãar ee khaigba nʉ? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Magan pãach dakhĩir Emkhooi Iewaa deeu ũwaai warr ich sĩerr aar sĩeimaag ʉ̈gthaa papagmam ookhiinjã, pãrau ¿jãga khĩirjukhajĩma? Mag ookhiinjã ¿mʉ chadcha ʉ̈gtharmua bëebajim ajupá? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Magnaa warre amag, Mua mag mʉch mod khöpi jaau chirʉm chan mʉch mod chaarta jaauba chirʉmgui ajim. Mʉ modon chadcha pãrau khöwiajã jãgua chan bʉ̈ʉrjã pãar peerdʉ aubajugui ajim, Ẽwandam Akharauta õor iiupiejeewai. Mag mʉ mod chaarta khöju khĩirjuju khãai, cha mua pãach kõit ʉdʉraa mʉch thõopiju jaau chirʉmta ʉ̈khapi chirʉmgui ajim, chi mag ʉ̈kha nʉm khʉʉnauta Ẽwandam Akhaar õor iiupiejem wai nʉisiju aawai. ");
INSERT INTO noaE_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pari mua mag jaau chirʉm ee pãar ee ãaur khʉʉnau mʉ iek ʉ̈khaba thʉnʉmgui a iekhamajim. Jesuu amag mag iekhatarran, warrgarwejã chijã khʉʉnauta i iek chadcha ʉ̈khaba naaju a khaphʉnaa chijãguata wir aig i oomapham khʉʉnagjã ich pʉr deeju a khaphʉ sĩerr aawaita mag iekhapʉ̈ijim. ");
INSERT INTO noaE_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Maguata mag iekhamamua, —Chadcha ich mʉ Ayauta mua õrag jaau chitʉmjã ʉ̈khapibam chan, pöd ãbmuajã ʉ̈khabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesuu mag iekhatarr aigmua õor pöm i dʉ̈i wënʉrraajerr khʉʉn eem khʉʉnaujã i kha ogdʉ pʉawia ya tag i dʉ̈i khaba nʉisijim. ");
INSERT INTO noaE_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mag õor pöm ich aigmua ërëu thʉnʉm oobaawai maach ichdëucha ich dʉ̈i doce ogdʉba wënʉrramkhĩir thʉ̈rkha autarr khʉʉnagjã, —¿Pãarjã warm khʉʉnjö wëtam khõsi nʉwi? ajim marag. ");
INSERT INTO noaE_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Magbaawai Simón Pedroou irig, —Señor, mag wëtwiajã, ¿khai aar maar ërëubaadëju? Ãba pʉchdëupaita õor iiupiejem iek wai sĩebahab ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Maguata marau pʉ iek ʉ̈khajim. Maimua marau khaphʉ nʉm, pʉ chadcha Ẽwandam Iewaa pekau chukhu khitʉm khabahab ajim, ichdëu pʉ̈iju a jaaujerr. ");
INSERT INTO noaE_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Simón Pedroou ichig magbaawai Jesuu jũrr, —Chadcha mʉchdëuta mua pãar doce thʉ̈rkha aujimgui ajim, mʉch dʉ̈i ogdʉba wënʉrramkhĩir. Magjieb mamʉ pãar ee ãb meperau pör meu simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesuu mag sĩerran, Simón Iscariote iewaa Judas aajerr igwiata mag sĩejim. Mag Judas chadcha ĩchab ichdëucha maar doce thʉ̈rkha autarr eem ajim. Pari magua i kha ukhurm khʉʉnag ich pʉr deeju khaphʉ sĩerr aawaita mag iekhajim marag. ");
INSERT INTO noaE_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Magtarr khur ich Jesús Galilea durr phöbördam nʉnʉidʉmpierr phʉʉrdʉ nʉrrajim. Ich tag Judea durr mamapha sĩejim, judionaan chi pörnaanau ich thõog ẽkhaajerr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pari mag i phʉʉr nʉrrʉm ee, judionaan phiesta Las Enramadas anʉm burrju khãai khapan khaba waaur narr aawai, ");
INSERT INTO noaE_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ich eeugpeenaupai irig, —Mʉig Galileapai sĩeba Judeaagta petá ajierram, jamjã pʉchig ee aajem khʉʉnag pʉchdëu nem wau sim oomkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maadëu thumaam khʉʉnag dich khaphʉ apim khõsi chirʉm chan, sĩi dich appaita meraa nem wauba aajem. Jãg pʉch nem wau sim thumaam khʉʉnag khap amkhĩirta waubá ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mamʉ ich eeugpeenaupai irig mag narran, irua amach dakhĩir mag nem wau sim oo nʉmjã amach paarmua ich Ẽwandamau pʉ̈iju a jaaujerr khabam aajerr aawaita juau ogthom irig mag naajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ich eeugpeenaupai ichig magbaawai Jesuu amag, —Pãragan ora thum wajaphamgui ajim, phiesta ee maag. Pari agtha mʉch maju ora khaba sĩewai mʉʉgwaiwe chan mʉ mabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Pãar chan pöd õrau oomapha abam, pãachjã am igar naawai. Magarrau mʉʉn chadau amau oomapha wai nʉmgui ajim, amachdëu nem khaigba wau nʉm mua amach khĩircha jaaujeewai. ");
INSERT INTO noaE_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Magnaa amag, Pãachta pãach phiesta ee wëtjurauma ajim. Mamʉ agtha mʉch maju ora khaba aawai mʉʉgwaiwe chan mʉ mabamgui ajim ich eeugpeenag. ");
INSERT INTO noaE_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Amag mag iekhapʉ̈iwia ich chan maba, chadcha Galilea sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pari mag ich eeugpeen wëttarr khur nʉʉ awia ökharta am ẽudee petajim, ich Jesús. Pari mag matarrjã õrag ich mam khaugpiba meraata petajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Maagwai judionaan chi pörnaanau chi phiesta ee i jʉrphöo thʉnʉmua, “¿Jamta simta jãg oobáma?” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mag nʉm dʉ̈i ĩchab sĩi bigaaum khʉʉnaujã i igwia, “Jãg wounan ãba nem wajaphampaita wau khitaajem” a iyʉ̈ʉ aawai, jũrr ãaur khʉʉnau, “Ʉ̈ʉ̈, ¿jãga õor wajapham abarju jãg sĩi õor khũgur nʉrraajem?” aajeejim aajem jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pari mag iekha nʉmjã sĩi parhooba thumaam khʉʉnag ũrmkhĩir khaba, amach appaita mamag aajeejim anaabá, magʉm gaaimua judionaan chi pörnaanau jũrr amach dʉ̈ita khaigbaju khĩirjuwia. ");
INSERT INTO noaE_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pari jũrram khʉʉnau mamagkham ee, mag nʉm dʉ̈i ĩchab chi phiestajã seman jãrr pamam eeta barwia, Aai i jëeujem deg dubwia, õrag Ẽwandam iek jaau sĩeimajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mag irua nem jaaumam ũrwia judionaan chi pörnaan jʉ̈gderraa nʉmua, “¿Jãga jãg estudietarrjã chukhu sĩerrʉmta magʉm nemjã jaau khaauga sĩma?” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Amau mag iekha nʉm ũrwia jũrr ich Jesuu amag, —Mua nem jaau chirʉm chan sĩi mʉch iekpai khabamgui ajim. Mua nem jaau chirʉmʉn mʉch pʉ̈itarr wounau mʉchig jaaupitarrta jaau chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ãbmua Ẽwandam ipierr nem waum khõsi sim khai, magua khaphʉ ajugui ajim, chadcha mua Ẽwandam iekta jaau chirʉ́ wa sĩi mʉch iekpaita jaau chirʉ́. ");
INSERT INTO noaE_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sĩi ar amach khĩirjug eemuapai iekha nʉm khʉʉnan sĩi õrag amach thö iekhamkhĩirta iekhaajerramgui ajim. Pari magba ar sĩi dich chogpʉ̈itarrta wajapha ig iyʉ̈ʉ amkhĩir nem jaau nʉm khʉʉnan, chadcha ichdëu jaaupitarr iekta ich agpierrpai jaaujemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Magnaa ichdëupai amag, ’¿Moiseeu chadcha pãar atheeta ley phã pʉabajĩ? ajim. Magtarrjã pãrau iwiram ãbmuajã ag gaai jaau sim ipierraa aba aajemgui ajim. ¿Ag gaai ĩchab õorjã thõopiba jaau sĩebá? ajim. Mag simta, ¿jãgwia pãrau mʉ thõom ig nʉmma? ajim judionaan chi pörnaanag. ");
INSERT INTO noaE_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Magbaawai chi ũr narr khʉʉnau irig, —Pʉʉn chadcha dösãtauta pör meu simgui ajierram. ¿Khaíu pʉ thõom ig nʉmta pua mag sĩ? ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Magbaa Jesuu amag magjim: —Chadcha pãar thumaam khʉʉn dakhĩir jua ʉ̈ʉijem edta mua õor monaaujim. Magtarr aawai ãba maata pãrau ig naabma ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pãach garmuan pãrau mʉrʉg mag naabma, pari khĩir eeya abat: Moiseeu jaauju nawe ya pãach jöoinau ich maagjerr aawai, ¿warag Moiseeujã pãrag chaain mehëudam ich mag phʉʉrbichpi jaau pʉabajĩ? Magtarr aawai ¿jua ʉ̈ʉijem edam magwe pãrau ag ipierr aba aajẽ pãach chaain dʉ̈i? ¿Pari jãg nʉm aigjã phidkha nʉm khabá? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mamʉ ich jãg Moiseeu jaau pʉarr ichaaur amaaugau sabarhedam magwe pãachdëun chaain mehëu phʉʉrbich nʉmta, ¿jãgwia mua sĩi sabarhed woun monaautarr oowiapai pãar mʉ dʉ̈i meeukha nʉ? ajim, mua sabarhedjã ʉʉrkhaba chirʉm awia. ");
INSERT INTO noaE_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Magnaa amag, Chikham jaauju nʉm khai, wajapha khĩirjunaata nem agcha jaaubat; pari oob jãg sĩi pãach khõchagpierrta nem jaaumiet ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mag khapanag dakhĩir Aai i jëeujem deg ijẽjẽbkham oowia chi Jerusalenpien chi pörkha narr khʉʉn ee ãaur khʉʉnau jũrr amach khapeenag, —¿Chamʉ́ ar amau thõopäaig pʉr auju ẽkha nʉm woun khabá cha ijẽjẽbkham? aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Jãga jãg õor pöm thʉnʉm dakhĩir amachigcha mag iekhamamjã bʉ̈ʉrjã i chig aba nʉmma? ¿Wa ya chi thethecharam khʉʉnaujã, “Jãata chadcha warrgarwe ich Ẽwandamaucha pʉ̈iju jaaujerr” a nʉwa? aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pari mag khai, maadëu khaphʉ nʉmgui aajeejim, jam agá i durr. Mamʉ chadcha ich Ẽwandamau pʉ̈iju a jaaujerrcha bëewai chan ãbmuajã khaugbaju, jammuata bëeju khai. Magua jã ar khabamgui aajeejim jũrram khʉʉnau, chadcha ich Galileapierrkha sim khaphʉ narr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mamʉ jũrram khʉʉnau mamagkham ũrwia mag Aai i jëeujem deg ichdëu jaau sĩerr aigmua ich Jesuu khĩesir iekhamamua, —Magan pãraun mʉch chi wounjã khaphʉnaa ĩchab mʉ durrjã khaphʉ naabma ajim. Pari mʉ chan pãrau khĩirju nʉmjö sĩi mʉch khĩrau bëetarr khabam. Mʉʉn ãb pãrau khaugba naab mamʉ, bʉ̈ʉrjã sëu chukhu sĩerrʉmuata pʉ̈ijimgui ajim. Ma pãrau khaugba nʉmgui ajim, khai agá. ");
INSERT INTO noaE_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mʉchdëun mua i khaphʉ chirʉmgui ajim, i aar chirawia bëetarr aawai. Ichdëuta mʉ pʉ̈ijimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Amachig magbapäaiwai warag i pʉr auju khĩirjujierram. Pari agtha Ẽwandamau i pʉr aupiju ora khaba arr aawai ni ãbmuajã i pʉr auba, sĩi ich magpai sĩujierram. ");
INSERT INTO noaE_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ãaur khʉʉnau i dʉ̈i mag nʉm ee, ãaur khʉʉn khapan aig narr khʉʉnau ʉ̈kha nʉm iekhau, —Daau mag nʉm ich Ẽwandamaucha pʉ̈iju a jaaujerr pierrwaijã, mʉg Jesuu nem wau nʉrrʉm khãaijã ʉ̈rʉʉcha ag na õrau nem ooba aajem waubarju a iekha naajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Moiseeu phã pʉarr iek wajapcha ʉʉrkhaajem khʉʉnau ũurwai õrau Jesús igar iekha nʉm ũrbaawai amach garmua phadnaan chi pörkha narr khʉʉn dʉ̈imua guardianaan chi Aai i jëeujem di thʉajerr khʉʉn pʉ̈ijierram, i pʉr aumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pari mag ich pʉr aumkhĩir ich aar õor pʉ̈i nʉmjã ich Jesuu khaphʉ sĩerr aawai amag, —Khũchpaita pãar dʉ̈i mʉ mʉig eegar chitabahab. Mʉʉn deeu mʉch pʉ̈itarr aar maju chirʉmʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mag mʉ petaawai pãrau mʉ jʉrju, pari pöd mʉ baau aubajugui ajim, mag mʉ chiraimaju aar pãar barju khaba naawai. ");
INSERT INTO noaE_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jesuu mag iekhabapʉ̈im ũrwia, chi judionaan sereu phöbaadëwia, jũrr amach wir aigpai, “¿Jamag maju jaau simta mag pöd maadëu i baaubaju anʉm? ¿Wa deeum durr mawia jũrr parhoobam khʉʉnag jawaan maju igwiata mag sĩwa?” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“¿Khan a simʉu mag maadëu i jʉrwiajã pöd i sim aar chan barbaju anʉm?” aajeejim amach eepai. ");
INSERT INTO noaE_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ya ãbmiecha chi phiesta ö nʉm edta chi wajapcharam ajim. Mag ed Jesuu dʉnʉʉunaa thet iekhamamua õrag, —Ãb khãijã öbisi sim khai, mua wai chirʉm dö khĩirta döbá ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ich Ẽwandam iek phã sim gaai jaau simjö, chi mʉ iekta ʉ̈kha sim thãarbʉ̈ eemuan ich mag sĩi õor iiupiejem döota khumdʉ öbër sĩsimjö sĩeju ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mag sim aiguin Jesuu i iek ʉ̈khabarm khʉʉnaun Ẽwandam Akhaarta auju a sim ajim. Pari maagwai chan agtha chi Ẽwandam Akhaar bëeba sĩejim, ich Jesujã agtha ich Aai aar ʉ̈gthar maba sĩerr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesuu mag iekhabarm ũrbaawai ãaur aig narr khʉʉnau, “Mʉg wounan chadcha Ẽwandamau ich i jaaumkhĩir jʉr autarrta jãg nʉrrʉm” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Maagwai ãaur khʉʉnau jũrr, “Keena, jãan warrgarwe ich Ẽwandamau pʉ̈iju aajerr wounauwai” anʉm ee, tagam khʉʉnau, “Ʉ̈ʉ̈, mag khabam; jãg woun chadcha cha jaau nʉmjö warrgarwe ich Ẽwandamau pʉ̈iju jaaujerr akhiin, Galileapierr khabakham” aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“Ẽwandam iek phã sim gaai jaauwai, Mesías mag warrgarwe ich Ẽwandamau pʉ̈iju jaautarran rey David khararr khod aju aajem, i chaain ewagam khʉʉn bi eem aju aawai. Maimua i thaabaawaijã Belén phöbör eeta auju a sim, ich Davijã Belenpierr arr aawai. Magua mʉg woun chan ag Mesías khababam” khajierram jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mag Jesús igwia jũrram khʉʉnau pogkha jaauphöo thʉnʉm gaaimua, ãaur khʉʉn i igar naawai ãaur khʉʉnau i khõchkhaba iekha nʉrrjëe ajim. ");
INSERT INTO noaE_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ãaur khʉʉnaun ich Jesuuta warag preso pʉr arraag ẽkha naajim, pari mag nʉmta ãbmuajã i pʉr auba sĩi sĩujierram. ");
INSERT INTO noaE_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mag amachig jaaubaawai chadcha chi Aai i jëeujem di thʉajerr khʉʉn wëtwia, deeu bëewia, jũrr fariseonaan phadnaan chi pörnaan dʉ̈i ãba narr aar wëtjierram aajem. Magbaawai makhʉʉnau amag, —¿Jãgwia pãrau i pʉr aibëebajĩ? ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Magbaa chi guardianaanau amag magjierram aajem: —Marau chadcha i pʉr aubëeba arran, maachdëu ũurwai sĩi parhoobam khʉʉn iekhaajemjö khabata nem jaau sĩerr aawaita pʉr aubëebajimgui ajierram aajem amag. ");
INSERT INTO noaE_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Magbaawai chi fariseonaanau chi guardianaanag, —¿Pãachpata ʉdʉraa khũgurpi nʉ ajierram aajem, mag iekhaag? ");
INSERT INTO noaE_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Maach meeun judionaan chi pörnaanaun khaphʉnaa maach chi fariseonaanaujã khaphʉ nʉmgui ajierram aajem, jãg woun chan Ẽwandamau pʉ̈iju jaaujerr Mesías khaba sim. ");
INSERT INTO noaE_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sĩi phöbör ee parhoobam khʉʉnaun chadcha arpii naama. ¿Pari khani jãkhʉʉnau Moiseeu phã pʉarr ley khap nʉ? Jãkhʉʉn Ẽwandamau igbaju khʉʉn aawai sĩi chi maldisiem khʉʉn khabahab ajierram anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Magbaawaita tagam khʉʉnau mag nʉm ee, ag na biek ãb edaar ich Jesús dʉ̈i iyʉ̈ʉ athurtarr ag fariseo Nicodemo aajerrau ich khapeen ijũrr magjim anʉm: ");
INSERT INTO noaE_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Keena, pari Moiseeu maachig ley werpʉatarr gaai jaauwai, khan gaaimuata mag woun khaibag wawaagpá a khap aag wajapha i iek ũr auba chan pöd õor ãbjã khaibag waupi jaauju khaba nʉm a simta, ¿jãga pãar mag iekha nʉ? ajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Magbaa warm khʉʉnau irig, —¿Pʉchjã agjö Galileapierrá i kõit mag iekhaag? Mag chirabnaa, pʉdë Ẽwandam iek phã sim gaai jʉrbarí ajim anʉm. ¿Khaíu jaauwai mag Galileamuata Ẽwandam i jaaujem ãb khãijã öbërju a sĩ? ajierram anʉm irig.  ");
INSERT INTO noaE_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mag, chi phiestajã öbaadeewai warag thum agdaujö amach diig ërëubaadëjim. ");
INSERT INTO noaE_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mag amach diig ërëubaadeewai ich Jesús jũrr Olivo durrsĩig petajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Maimua ag noram edpherre deeu bëewi Aai i jëeujem deg sĩeichëjim. Mag i maig sĩeichëm khaug athaawai i aig õor bëe thʉnʉisijim. Magbaawai khʉt jupwi Ẽwandam iek jawaagpajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pari mag ya irua jaaubaadëm eeta, Ẽwandam iek jawaag chi machnaanau fariseonaan dʉ̈imua i aig ʉʉi waibëejierram. Mag ʉʉi ich jaai khabamuata wau wai sim ooimawia mag i aig waibëejierram. Mag waibëewia thumaam khʉʉn jʉ̈g daar ");
INSERT INTO noaE_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesuug magjierram: —Maestro, mʉg ʉʉi ich jaai khabamuata wau wai sim ooimajierramgui ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moiseeu ley phã pʉarr gaai jaauwai, mʉgʉm ʉʉinan mokou bar wai nʉmua warreta thõopʉ̈ipi jaau sim. ¿Pua oowai jãga aju aai sĩ? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pari amau mag irig jëeu narran, jũrr chaauraapai khãijã jaaubaawai juau ogthom ich magʉm gaaimuapai i khaibag wawaag ajima. Pari ichig mag jëeu nʉmjã ũrbamjö, chi Jesús warag eeg ʉ̈thʉnaa jĩgkhẽúapai jẽb gaai phãpʉ̈i phãpʉ̈i oo sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pari magʉmjã pʉaba mag ichig phʉʉrba jëjëeu khaawaita dʉnʉʉunaa amag, —Pãachdëu khaphʉ jaau naawai pãach ee ar bʉ̈ʉrjã pekau chukhu nʉm khʉʉnauta nacha i barjurauma ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mag iekhapʉ̈iwia, deeu eeg ʉ̈thʉ oo sĩsiwi, ũwaai jẽb gaai jĩgkhẽúa phãpʉ̈i phãpʉ̈i oo sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mag chi ʉʉi waiberr khʉʉnau Jesuu amachig mag iekhabapʉ̈im ũrbaawai jöoiraacharam khʉʉnta nacha ökhar ããbdö wët ahaugmamua tagam khʉʉnjã khĩrab ërëudubjierram. Ãba chi ʉʉi appaita maba aig sĩsijim. Mag ya amach numpai aadeewaita ");
INSERT INTO noaE_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","deeu dʉnʉʉunaa chi ʉʉiragta, —¿Jam nʉ pʉ aiberr khʉʉn? ¿Ãbmuajã pʉ mokou barba ërëubaadëjĩ? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Magbaawai chi ʉʉirau, —Ʉ̈ʉ̈, ni ãbmuajã mʉ chig abajimgui ajim. Magbaa deeu ich Jesuupai irig, —Muajã pʉ chig abam. Petá, pari jãimua oob tag pʉch jaai khabam dʉ̈i khapes amgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mag khur deeu aig õor narr khʉʉnag Jesuu magjim: —Mʉʉta mʉg durr gaai wënʉrrʉm khʉʉn atheem õtdauu; chi mʉ dʉ̈ita nʉrrʉm chan tag bʉ̈ʉrjã khĩchag ee nʉrrabamgui ajim, mʉchdëuta i iiupinaa Ẽwandam khĩirjugjã khaugpi chiraawai. ");
INSERT INTO noaE_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Magbaawai chi fariseonaanau irig magjierram: —Puan pʉchdëupaita wir aig pʉch jaau sim. Jãg pua jaau sim chan bʉ̈ʉrjã baleeba simgui ajierram, pʉchdëupaita pʉch jaau sĩewai. ");
INSERT INTO noaE_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Magbaawai Jesuu amag magjim: —Muan mʉchdëupaita mʉch jaau chirab mamʉ, mua nem jaau chirʉmʉn chadcha balee simgui ajim. ¿Khan jãgwi mag chirʉ́? Mua mʉch bëetarr khaphʉnaa mʉigmua petaau mʉch chiraimajujã mua khaphʉ chiraawaita mag chirʉmgui ajim. Pari pãach iekhõoin pãachdëun chad mʉ khaugba nʉmta mag mʉ jaau naabma ajim jũrr amag. ");
INSERT INTO noaE_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pãraun pãachdëu oowai magjöo abaawaita sĩi pãach khĩirjug eemuapaita mag chikham jaaujemgui ajim. Pari mua pãar dënjö sĩi mag õor jaauba chitʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Muata õor jaau chirakhiin, sĩi mʉch appaimuata jaau chirʉm khaba aawai muan chadcha nem agchata jaaujugui ajim, ich mʉ pʉ̈itarrauta mʉ ipierr jaau sĩewai; ajapcharan ich mʉ Ayauma. ");
INSERT INTO noaE_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pãrag Moiseeu ley phã pʉarr gaai jaauwai, “Destignaan numiim khʉʉnauta chadcha nem ãba jaau nʉmʉn, makhʉʉnau jaau nʉm chadcha balee sim” a sim. ");
INSERT INTO noaE_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mag ley gaai destignaan numiim khʉʉnauta ãba jaauju aai nʉm a sĩewai, maar chi jaau nʉm khʉʉnjã numí naabahab: Dau ãb, mʉchpaiu; maimua ãbakhai, mʉ Ayaugui ajim, chi mʉ pʉ̈itarr. Magua mua mʉch igwia mʉʉta mʉg durr gaai wënʉrrʉm khʉʉn athee õtdauu aawaijã chadcha balee simgui ajim, mʉch Aai dʉ̈imuata mag jaau chiraawai. ");
INSERT INTO noaE_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Magbaawai chi fariseonaanau, —Magan ¿jam sĩ pʉ aai? ajierram irig. Magbaawai Jesuu, —Pãrau chan mʉjã khaugba, ni mʉ Aaijã khaugba nʉmgui ajim. Pãrau mʉ oo naawai mʉ khaphʉ naakhiin, ĩchab mʉ Aaijã khaphʉ naakhamgui ajim, i jãga sĩerrʉ́. ");
INSERT INTO noaE_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesuu mag iekhamarr, Aai i jëeujem deg ofrenda phëwi ag ãkhaajem aigta mag iekhamajim, ichpai jaau simua. Pari agtha i pʉr auju ed khaba arr aawai mag ichpai jaau sĩerr gaaimua i pʉr aum ig narrjã ãbmuajã i pʉr aubajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Maimua ag khur nʉʉpai awi deeu ich Jesuupai aig narr khʉʉnag magjim: —Mʉ petaawai pãrau mʉ jʉrju, pari ãbmuajã mʉ baaubamgui ajim. Pãarta pekau ee wënʉrrʉmʉn, ich ag eepai pãar khëchwi mʉ mam aarjã pãar pöd barbamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mamʉ irua mag simjã khaugba, chi judionaanau warag amach khapeenagta, —¿Wa juau ichdëupai ich thõopʉ̈iju khĩirju sĩewaita mag i sĩeimam aar pöd maach barbaju a sĩwa? aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pari sĩi warag mag khaugbata jaau nʉm ũrwia Jesuu amag magjim: —Mua pãrag mag chirʉmʉn, pãar mʉig eegarm khʉʉn aawai ich mʉig eegarpai nʉisijuuta jaau chirʉm. Pari mʉ ʉ̈gtharm aawai deeu mʉch chirarr aar majugui ajim. Magnaa amag, Pãar mʉg jẽb gayam khʉʉn khabahab, pari mʉ chan pãarjö mʉg jẽb gayam khabamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Maguata pãrau mʉʉta ich Ẽwandamau pʉ̈iju a jaaujerr khabampii awia mʉ igbam chan, chaig mʉchdëu jaau chirarrjö, pãach pekau eepai khëchwi mʉ mam aarjã pãar pöd barbamgui ajim amag. ");
INSERT INTO noaE_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mag ũrwia chi judionaanau ichigcha, —¿Magan pʉ khaíuma? abaawai, ich Jesuupai deeu amag iekhamamua magjim: —Ya mua pãrag mʉch jaaujeewai, ¿khan atcha tag mua jaaubarju? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mʉch garmuan mua pãar jaauju akhiin, jaauju pöoma chirʉm. Mamʉ magʉmta jaauba, ãba chi mʉ pʉ̈itarrau jaaupitarrpierrpaita jaau chitʉmgui ajim. Pãrau mʉ iek ʉ̈khamapha naab mamʉ, mua jaau chirʉmʉn thum chadcharaugui ajim, chi mʉ pʉ̈i simjã chadchata iekhaajeewai. ");
INSERT INTO noaE_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pari mag ich Aai igwia par jajaaukhamjã pöd khaugbajierram. Mag ichdëu jajaaukhamjã khaugba abaawaita ");
INSERT INTO noaE_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","amag magjim: —Jãg nʉʉ awia ya pãachdëucha mʉch chi Emkhooi Iewaa pakuls gaaicha meerphënaa jiirjop sĩubaawaita pãrau mʉ igwia, “Jãgan chadchata ich Ẽwandamau pʉ̈iju aajerr ajiebma, jãguata jãg sĩi ich khĩrau nem wauba aajeejim” ajurau. Maiguin chadau pãrau khaphʉ ajugui ajim, mua ãba mʉch Ayau mʉchig jaaupimampaita õragjã jaaujerr. ");
INSERT INTO noaE_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ich chi mʉ pʉ̈i sim mʉ dʉ̈i sĩewai, mua mʉch Ayau nem khõsimpaita waaujeewai irua sĩi mʉrʉg oobamjöo aba aajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesuu mag iekhabarm ũrwia õor pöm i iek ʉ̈khajierram. ");
INSERT INTO noaE_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Maimua ich Jesuupai judionaan mag ich iek ʉ̈khatarr khʉʉnag magjim: —Pãarta jãg cha mua jaau chirʉm iek pãachdëu ʉ̈khabarmta ogdʉba ich mag mʉ ipierr wënʉrrʉmʉn, magan chadcha pãar mʉ khapeenaugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mag amʉn magan chadcharam iekta pãrau khaugju. Mag chadam iek pãachdëu ʉ̈khabarmua ya tag pãar chikham chogkhaba nʉisijugui ajim amag. ");
INSERT INTO noaE_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Magbaawaita jũrr tagam khʉʉn agjö aig narr khʉʉnau, —Maran jöoi Abrán chaain ewagam khʉʉnau; maar mag sĩi chikhaman chognaanjã khaba nʉmgui ajierram. Mag nʉmta, ¿jãga pʉ iek mag pʉ iek ʉ̈khabarmuata tag chikham chogkhaba nʉisiju a sĩ? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Magbaawai Jesuu jũrr amag, —Ar pekau waaujem khʉʉnan chadcha thum pekau chognaanaugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pãrau khaphʉ nʉm, sĩi chikham chogkha phidkha sim chan, ich phidkha sim degam khʉʉn chaai khaba aawai, am dʉ̈i sĩerram iek sĩerraba aajem. Pari chi dikhʉ chaai magba, thaababarwe am chaaikha sĩsierr ich mag am dʉ̈i sĩsiejemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pekaúa pãar ich chognaanjö wai simta mʉch chi Ẽwandam Iewaauta mag pekau jua eemua pãar öbeer athamʉn, ya tag i chog khaba, chadcha öbërm iekta öbër nʉisijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Magnaa, Mua khaphʉ chirʉmgui ajim, pãar Abrán chaainkha nʉm. Pari mag i chaain anʉmta pãachdëu mʉ iek ũrmapha nʉm gaaimua warag mʉ thõopʉ̈imjã khõsi nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Muan mʉch Aai dʉ̈i chiraawai i dʉ̈i khaugtarrta pãrag jaaujem. Maagwai pãraujã ich agjö pãach ayau pãachig jajaaukhamta waaujemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Magbaawai deeu amachdëu, —Maar ayan Abranaugui ajierram. Mamʉ magbaawai ich Jesuu amag, —Pãachdëu jaau nʉmjö pãar chadcha Abrán chaain akhiin, ich Abranau aajerrjöta pãraujã aajeekhamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pari magba aawai ich Ẽwandamaucha mʉchig jaautarrta meerba jaau chitaawaijã pãrau warag mʉ thõopʉ̈im khõsita aajemgui ajim. Abranau chan jãg pãar dënjö chikham thõoju ẽkhaba aajeejimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Magnaa, Pãar chan Abrán chaain khabamjöta nʉmgui ajim. Maguata jãg pãach aai chi ãbakhaíu nem waaujemjöta pãachdëujã aajemgui ajim. Magbaawai amachdëu sereu phöbaadëwi, —Maar chan noo chaain khabam. Maran aai ãbpaita wai nʉmgui ajierram: Ẽwandam. Ẽwandamta maar Aai charaugui ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Magbaawai Jesuu magjim: —Chadcha Ẽwandamta pãar Aai akhiin, pãrau mʉjã daupii wai naakhamgui ajim, ich Ẽwandamau pʉ̈iwiata cha pãar dʉ̈i mag iekha oo chiraawai. Mʉ chan sĩi mʉch khĩrau bëetarr khabam; mʉʉn ich Ẽwandamaucha ich aarmua pʉ̈iwiata mʉg chitʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mag ijẽjẽbagmamua ich Jesuupai amag, Mua khaphʉ chirʉmgui ajim, jãgwi pãrau pöd mua jaau chitʉm iek khaugba nʉ. Jãg khaugba nʉmʉn, pãachdëu ũrmaphamjö ũr naawaiugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Magnaa amag, Pãar aai mepeer khabahab ajim. Maguata pãar i dënkha naawai irua nem jajaaukhamta waum khõchkhaajerram. Mepeer warrgarwe õor thõomie khabahab ajim. Irua nem jaau sim chan bʉ̈ʉrjã chadam iek khabamta jaau sĩerrʉm. Irua chadcha nem jaautarr chukhum. Jãg irua sëukha nem jaauwai ich khapta jaauba aajeeb ajim, sëunem sĩerraawai. Magua ichta sëu paraam khʉʉn aaikha sĩerrabahab ajim amag. ");
INSERT INTO noaE_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pãach mag i chaainkha naawaita mua chadcha nem jaau chitʉmjã pãrau ʉ̈khaba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Pãar mʉg thʉnʉm ee, ¿khaíu bʉ̈ʉrjã sëukhaba mʉrʉg, “Pʉ pekau wai sim” aju aai sĩ? ajim amag. Mʉ chan bʉ̈ʉrjã pekau chukhu chitʉmgui ajim. Mag chitaawai muan chadcha nem agchata jaau chitʉm. Pari magʉmjã ¿jãgwi pãrau ʉ̈khaba aajemma? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ar chadcha Ẽwandam chaainkha nʉm khʉʉnaun i iek õrau jaau nʉm ũurwaijã ʉ̈kham khõsi ʉ̈khaajerram. Pari pãar Ẽwandam chaain khaba aawai pãrau i iek ʉ̈khaba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mag amachig, “pãar chan Ẽwandam chaain khabamgui” abaawai, chi judionaanau irig, —Chadchata pʉʉn jãgan Samariapierrau, maimua dösãtauta pʉ pör meu sĩebahab ajierram ichigcha. ");
INSERT INTO noaE_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Magbaawai Jesuu, —Mʉ dösãtau pör meuba chirʉmgui ajim. Mʉg chitʉm aiguin mʉʉn sĩi mʉch Aaita thö iekha chitʉm. Pari maagwai jũrr pãrau mʉ Aaijã ögkhaba, warag mʉchta dösãtaujã pör meu chirʉm aajemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mʉ Ayaun chadcha õraujã mʉrʉgta ee apim khõsi sĩeb mamʉ, mʉchdëu chan mʉrʉgta ee abat aba chitʉmgui ajim. Pari jãg pãrau mʉ iseg nʉm paran ichdëuta pãar dʉ̈i ichdëu khap ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Magnaa, Ĩs mua chadcha chi mua jaau chirʉm ipierraa sim woun chan thõbaju a chirʉmgui ajim ich Jesuu. ");
INSERT INTO noaE_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pari magbaawai chará chi judionaanau, —Ĩsta chadcha marau wajapha pʉ khaphʉ nʉm: Pʉʉn chadcha pör ee dösãt wai simuata mag iekhapi simgui ajierram. ¿Khani Abranjã meewia maimua tagam khʉʉn agjö Ẽwandam i jaaujerr khʉʉnjã thumaa ötarrta mag pʉ ipierraa nʉm khʉʉn chan khëchbaju a nʉ? ");
INSERT INTO noaE_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Wa pʉʉta maar aai Abrán khararr khãaijã atcha chirʉ́wa? ajierram. ¿Pua khaugbata sĩ ajierram, Abrán meewia tagam khʉʉn chi Ẽwandam iek jaaujerr khʉʉnjã thum ötarr? Magtarrta, ¿pʉ khai agá ajierram irig, mʉig maar ee mag pʉch thö iekhacheeg? ");
INSERT INTO noaE_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Magbaa Jesuu, —Mua mʉchdëupaita mʉch thö iekhakhiin, mua mag mʉch thö chirʉmjã bʉ̈ʉrjã baleeba simgui ajim. Pari chadcha chi mʉ thö iekhanaa mʉchta thumaam khʉʉn khãaijã ʉ̈rpai api simʉn ich mʉ Ayaugui ajim. Wajapcharan ar pãrau i igwia pãar Ẽwandam aajemma, jãguata thumaam khʉʉn khãaijã mʉchta ʉ̈rpai api simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mag pãachdëun, iita pãach Ẽwandam anaab mamʉ, pãrau i khaugba nʉmgui ajim. Muan chad i khaphʉ chirʉm. Mua chadcha i khaphʉ chirʉmta i khaugbam akhiin, maiguin mʉʉn sëunem pãar dʉ̈i ãbata chirʉm. Pari mua chadcha i khaphʉ chitʉm; magua mua i ipierraata nem waaujemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pãar jöoi Abrán onee ajim, Ẽwandamau ichig chaai deebarmua jũrr chaain ĩiubaadeeu ewag paawai mʉ bëejujã khaphʉ sĩerr aawai. Maimua ya chadcha mʉ pierrum oobaawaijã i onee ajimgui ajim amag. ");
INSERT INTO noaE_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Magbaawai chi judionaanau ich Jesuug, —Mag iekha sim chan agtha cincuenta añojã khaba sim. Mag simta, ¿mag pua Abrán oojim a sĩ? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Magbaa ich garmua, —Mʉʉn Abrán thaabaju nawe ich mag chirajimgui ajim amag. ");
INSERT INTO noaE_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Amachig magbaawai chará ya mokou i baraag ẽkha naajim. Pari mag nʉm ee, sĩi ich iiu aawai, õor ee theerbabag warag ichta daaupabaadëjim, Aai i jëeujem degmua. ");
INSERT INTO noaE_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mag ich mokou baraag ẽkha nʉm ee, Aai i jëeujem degmua öbërwia Jesuu woun ãb bi eewe dau khĩsu thaabatarr ooimajim. ");
INSERT INTO noaE_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mag oobaimaawai maach i dʉ̈i ogdʉba wënʉrraajerr khʉʉnauchata marau maach Maestroog jëeujim, ajapcharan ich Jesuugma, jãgwi mag woun dau khĩsu thaabajĩ: ¿ich dënnaan pekau gaaimua ajĩ, wa ichdëucha pekau wautarr gaaimua ajĩ? ");
INSERT INTO noaE_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mag ichig jëeubaawai Jesuu magjim marag: —Jã chan ich pekau gaaimua khaba, ni ich dënnaan pekau gaaimuajã khabajimgui ajim. Jãg thaabatarran, jãan jãg dau khĩsu sim gaaimua Ẽwandamau ich jua theeg õrag oopiegta jãg thaabapijimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Magnaa marag, Pãrau khaphʉ nʉmgui ajim, ãsdaaupaita phidkhaajem. Edau khëubaadeewai tag phidkhaba aajem. Ich agjöta simgui ajim, Ẽwandamau nem waupi sim wawaagjã. Magua muajã mʉch meebam aig chan jua ʉ̈ʉijem ed awiajã mʉch pʉ̈itarrau jaaupʉ̈itarr phidag pʉaba ich mag wau chitajugui ajim. Magbamʉn mʉg chitawi mʉ meebaadeewai ya tag magʉm phidag wauju khaba aadëjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mʉʉta mʉig eegar mʉg jẽb gaai chirʉm aiguin mʉchta õor atheem araragaugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Maimua mag iekhanaa, jẽb gaai ichö thunaa, mag ichö eepai jẽb wãwakha waunaa, agua chi dau khĩsu khitarr dau phuurpʉ̈ijim. ");
INSERT INTO noaE_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Mag phuurpʉ̈inaa irig, —Jãimua Siloé ee mawia pʉch dau sũgbapʉ̈imí ajim. Mag thʉrrdö Siloé anʉm maach meúan “pʉ̈itarr” a simʉu. Ichig mag jaaubaawai chadcha chi dau khĩsu khitʉmua mawia ich dau sũgbapäaiwai daujã wajaug aadëjim anaabá. Mag, ag na dau khĩsu khaba sĩerrjö dau monakkha ich di aar barjim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mag daujã wajaug sĩsim oobaawai i dʉ̈i di dakha naajerr khʉʉnau maimua ag nawe sĩi dich nʉm khʉʉnag i nem inagdam jëeu sim oojerr khʉʉn dʉ̈imua amach wir aigpai, “¿Ma, jã ar dau khĩsu khitarr sĩi õor dich nʉm khʉʉnag dau aphʉʉ nemdam jëeujerr khabamá?” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Magbaawai ãaur khʉʉnau, “Chadcha, ichma” anʉm ee, jũrr bigaaum khʉʉnau, “Ãã, jã chan ar khabam, sĩita arjöo simgui” aajeejim aajem. Pari magbaawai amau mag nʉm ee, jũrr ichdëu, “Mʉ ich ar khabahab” aajeejim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Amachig magbaawai, —¿Magan jãga jãg pʉ daujã wajaug aadëjĩma? a jëeujeejim anʉm amach garmua. ");
INSERT INTO noaE_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Magbaawai ichdëu, —Jãan woun ãb ar Jesús aajemuata ichö ee jẽb wãwakha waunaa, agua mʉ dau phuurnaa mʉrʉg, “Chum Siloé ee mawia pʉch dau sũgbapʉ̈imí” abaawai, chadcha mua i ipierr mawia mʉch dau sũgbapäaiwaita chadcha mʉ daujã wajaug aadëjimgui aajeejim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Magbaawai deeu amachdëu irig jëeumamua, —¿Jam sĩ mag pʉ dau monaautarr woun? abaawai, —Mua khaugbam jam sim khai aajeejim anʉm ichdëu. ");
INSERT INTO noaE_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Pari Jesuu mag ichö jẽb ee waaurëunaa woundam dau khĩsu khitarr monaautarr jua ʉ̈i kheeujem ed arr aawai fariseonaan aar i warrjierram aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mag amach aar wai barbaimaawai irig jëeumamua, —¿Jãga jãg pʉ daujã wajapha chirsijĩ? ajierram anʉm. Magbaawai i iek irua jaaubaadëwi, —Ichö ee jẽb waaurëunaa mʉ dau phuurpʉ̈inaa, ʉpi jaaubaawai, i ipierr awiata mua wajapha oo chirsijimgui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Irua magbaawai chi fariseonaan ee ãaur khʉʉnau, —Chi pʉ dʉ̈i magtarr woun chan magan Ẽwandamau pʉ̈itarr khabam; maguata mʉg jua ʉ̈ʉijem edjã ʉʉrkhaba simgui ajierram aajem. Pari maagwai jũrr ãaur khʉʉnau, —Pari i Ẽwandamau pʉ̈itarr khaba akhiin, ¿jãga irua jãg Ẽwandam jua theegau õor monaaubarju? Pekau paraam khʉʉnau chan pöd i dënjö jãgbamgui aajeejim anʉm. Amach magphöbaadëm gaaimua warag amach eepaijã ihãba iekhaba nʉm iekhau ");
INSERT INTO noaE_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","warag chi dau khĩsu khitarragta, —Pua khĩirjuawai ¿khanim woun agá? Pʉ dauta irua monaautarr aawai puata i jaauju aai chirʉmgui aajeejim anʉm irig. Magbaawaita ichdëu, —Mua oowai merag chukhu sim, jãan ich Ẽwandam jua theegau nem wau nʉrrʉmta jãg nʉrrʉmgui ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pari mag dau khaugba khitarrta dau wajapha monaau sĩsimjã judionaan chi pörnaanau ʉ̈khamapha naajim anaabá. Mag ʉ̈khamaaugau, i iek warag i dënnaanta thʉ̈rkha auwi amagta, ");
INSERT INTO noaE_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Chadcha mʉg woun pãar chaairá? ajim anʉm. ¿Pãachdëujã pãrau chadcha bi eeweta dau khaugba thaabajim anʉ́? Magtarrta ¿jãga ĩs jãg dau wajapha oo simma? a jëeujierram aajem chi dënnaanagcha. ");
INSERT INTO noaE_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Magbaawai chi dënnaanau, —I chadcha maar chaai khabahab; aauwai chadcha bi eeweta dau khĩsu khitabajieb ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pari i dau monaautarr chan marau khaugba nʉm, jãga awiata ĩs jãg dau wajapha sĩsi, ni khaíuta i dau monaaubarm khai. Ichigchata jëeubat ajierram anʉm. Ya i chi jöoi aawai ichdëuta irua pãrag jaauju aai sĩebá ajierram aajem amag. ");
INSERT INTO noaE_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pari amau jaaumapha magpai jaau narran, ar Jesús igwiata chadcha ich warrgarwe pʉ̈iju aajerrta jãg nʉrrʉm a iekha nʉm khʉʉnan judionaan chi thethem khʉʉnau Ẽwandam iek jaaujem degjã tag dubpiba aag ya ibëp nʉm khaphʉ narr aawaita magpai jaau naajim anaabá. ");
INSERT INTO noaE_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Maguata amau sĩi, “Ichigta jëeubat, ya i chi jöoi khabahab ichdëucha pãrag khap jawaag” aajeejim aajem warag chi fariseonaanagta. ");
INSERT INTO noaE_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Magbaawai i iek chi thethemnaanau deeu ichchata thʉ̈r aunaa, —Chadcha Ẽwandam dakhĩir meerba marag jaaubá ajierram anʉm. Oob Jesuuta pʉch monaaujim am. Marau khaphʉ nʉmgui ajierram anʉm, jãan pekau pöm sĩerrʉm. ");
INSERT INTO noaE_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Magbaawai ichdëu, —Mua chan khaugba chirʉm, í mag pekau pöm sĩ wa pekau chukhu sĩ a chirajim aajem irua. Ãba mua khaphʉ chirʉmʉn, warr chadcha mʉ dau khĩsu chirajim, pari magtarrta ĩs mua wajapha oo chirʉm. Maata mua khaphʉ chirʉmgui ajim anʉm amag. ");
INSERT INTO noaE_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Magbaawai ũwaai amachdëu wajapha jëjëwagmamua, —¿Ma jãga ajĩma pʉ dʉ̈i? ¿Khanta jãgjĩ pʉ dau eerdʉpieg? ajierram anʉm irig. ");
INSERT INTO noaE_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Magbaawai ichdëu, —Ya khabá mua pãrag jaaubarmgui ajim anʉm. Magʉmjã pãrau ʉ̈khab nʉm. Mag nʉmta ¿khan atchata deeu ũwaai jaaupi nʉmma? ¿Wa mag jaaubaawai i iek ʉ̈khawia pãachjã i khapeenkhaagwa? ajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Magbaawai irig ich khĩircha iekha thʉnʉʉuwia magjierram aajem: —Pʉchin pʉ i igar chirama; pari maran Moisés igarta nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Marau khaphʉ nʉmgui ajim anʉm, Moiseegan ich Ẽwandamauchata iekhajim; pari jã chan marau khaugbamgui ajierram aajem, jammuata jãg nʉrraichëjim khai. ");
INSERT INTO noaE_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Magbaata irua mag chirajim aajem: —Ʉ̈khabam. Magan pãrau chan khaugba naabma ajim anʉm, jammuata i bëejĩ; pari mag simuata mʉ dau monaaupʉ̈ijim. ");
INSERT INTO noaE_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Maadëu khaphʉ nʉmgui ajim anʉm, sĩi parhooba pekau pömkham khʉʉn iek Ẽwandamau ũrba aajem. Irua ũurjemʉn, ichig jëeunaa ich ipierraa nem wau nʉm khʉʉn iekta ũurjem. ");
INSERT INTO noaE_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pãraujã khaphʉ nʉmgui ajim anʉm, bʉ̈ʉrjã ag na õrau mʉg mʉjö bi eewe dau khĩsu thaabatarr khʉʉn dau wajaug paa au nʉm anʉm ũrba aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mʉg mʉ dau wajapha apitarr woun ich Ẽwandamau pʉ̈itarr khaba akhiin, irua jãgʉm nem pöd wauba aajeekhamgui ajim aajem amag. ");
INSERT INTO noaE_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amachig magbaawai sereu phöbaadëwi irig, —Pʉ sĩi dau aug pekau pöm thaabatarrta, ¿khani mag sĩma? ¿Wa puata maar khãaijã khapcha sĩwa ajierram anaabá, marag jawaag? Maimua tag Ẽwandam iek jaaujem degjã dubpiba, warag amach aigmua i jʉrpʉ̈ijierram aajem. ");
INSERT INTO noaE_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chi judionaanau mag woundam dʉ̈i magtarr Jesuu khaug athajim. Maimua ag khur chi woundam oobaimaawai ich Jesuu irig, —¿Pua chadcha Emkhooi Iewaa iek thãraucha ʉ̈kha chirʉ́? a jëeujim. ");
INSERT INTO noaE_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Magbaawai jũrr ichdëu, —Señor, ¿ma khaiuma? Mʉrʉg wajapha jaaubá ajim, mua khaphʉ aadeewai i iek ʉ̈khaag. ");
INSERT INTO noaE_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Magbaawai, —Pari ya khabá pua mʉ oo sima; mʉchta pʉ dʉ̈i iyʉ̈ʉ chirabahab ajim jũrr ich Jesús garmua irig. ");
INSERT INTO noaE_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jesuu ichig magbaawai, i khĩirphee thʉkhöonaa irig, —Señor, ĩsin mua chadcha khaphʉ chirʉmgui ajim, pʉʉta ich Ẽwandamau pʉ̈itarrau. ");
INSERT INTO noaE_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Magbaawai Jesuu irig magjim: —Mʉ bëetarran, khaíuta chadcha Ẽwandam iek ʉ̈kha sĩ wa khaíuta ʉ̈khaba sĩ a khap amkhĩirta bëejimgui ajim. Ar dau khĩsu khithëem khʉʉnjö amach khaibag ee nʉm khaphʉ nʉm khʉʉn peerdʉ aunaa ĩchab ar jũrr wajapha nʉm anʉm khʉʉnta amach pekau gaaimua khĩchag eemjö nʉm jawaanta bëejimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesuu magbarm ũrwia fariseonaan eem ãaur khʉʉn aig narr khʉʉnau irig, —Pʉrʉgan magan maran dau khĩsuta naabma ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Magbaawai Jesuu, —Pãar chadcha dau khĩsu naawaita jãg naakhiin, pãar pãach pekau gaaimua kulp pömcha khaba naakhamgui ajim. Mamʉ magba pãar iek mag wajapha khaphʉ nʉm anʉmta juau jãg nem khaigba waum khõchgau mʉ igbam gaaimuata, pãar Ẽwandam dʉ̈i iekkhõr pöoma nʉmgui ajim Jesuu amag. ");
INSERT INTO noaE_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Maimua mag iekhamamua Jesuu amag mʉg ejemplo jaaujim: —Ar oveja phãarkha thʉnʉm aar dubaag ẽkha simta puertdi garmua dubba sĩi chi thuur phʉʉrdʉ sim ʉ̈rta waaidʉ dich sim wounan, maan sĩi nem jĩgmie aawaita mag simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pari magba puertdi garmuata dub simʉn, ma chi pastorrau, chi thʉa. ");
INSERT INTO noaE_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Magʉg mag chi oveja ierr phãarkha thʉnʉm puertdi aig simuajã ʉdʉraa dubpijugui ajim. Mag dubwi chi pastor amach oo phë wai nʉrraajemua aawai amach thʉ̈r gaai thʉ̈rbaimaawai amachdëujã i khaug aaujerram. Mag warag dawag phë arrwia ");
INSERT INTO noaE_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ya thum daau paaukhabaadeewai, am na dʉnʉisie amachdëujã i ẽudee weetjemgui ajim, ya amach ich mag phë wai nʉrraajem dʉ̈i aawai. ");
INSERT INTO noaE_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pari magba jũrr õor amachdëu khaugbam khʉʉnauta am thʉ̈rchëkhiin, mag dʉ̈i chan wëtba, warag parhoobata khaphig phöbaadëjugui ajim, i ökgau. Amau amachdëu õor khaugbam khʉʉn iekjã khaphʉ aajemgui a jaaumajim Jesuu. ");
INSERT INTO noaE_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesuu mag amag jaaumarran, jãg chi oveja thʉajemua ich nemchaain oopaar phë wai nʉrraajemjö iruajã ich iek ʉ̈kha nʉm khʉʉn dʉ̈i ich agjöta aajem a sim ajim. Pari mag jaaumamta aig i iek ũr narr khʉʉnau pöd khaug auba, sĩi oveja chaarta jaau simpii naajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Maimua deeu ich ag iekpai igwia Jesuu amag, —Muan chadcha pãrag, “Mʉʉta makhʉʉn oveja duubjem puertdiiu” a chirʉmgui ajim, õor i iek ʉ̈kha nʉm khʉʉnan i gaaimuata ʉ̈gtharjã öbërju igwia. ");
INSERT INTO noaE_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Maimua chi fariseonaan khĩir iekhamamua, ’Ar mʉ bëeju nawe sëukha amachdëupai amauta Ẽwandam iek jaau nʉm awia sĩi õor khũgurnaa amachigta ee apiejem khʉʉnan nem jĩgkhamienaugui ajim. Pari jãg oveja charau amachdëu õor khaugbam khʉʉn iek asekasba aajemjö, mʉg chadcha mʉ iek ʉ̈kha nʉm khʉʉnau chan par am mag sëukha wënʉrrajieb mamʉ, am iek asekasbajierramgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Magnaa amag, Mʉʉta puertdi charau; chi mʉ iek ʉ̈kha nʉm gaaimuata peerdʉ nʉm khʉʉnan chadcha mʉ dënkham iekta mʉ dënkha nʉisimgui ajim. Chi mag nʉisim khʉʉnagan, jãg chi pastorrau ich nemchaain wajapha oopaar phũak khöpi wai nʉrraajemjö, muajã ĩchab am thʉa wai chitajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Pari magba ar sëukha chikham khũguurjem khʉʉnan, chikham õorta jũrr amachig paa aumam gaaimua chikhamnaan ovejata jĩgkha aumamjö sĩerrjëemgui ajim. Mag nʉmʉn pari sĩi amach iek ʉ̈khabarmuata chadcha peerdʉju a jaauwai warag ʉdʉʉr ʉ̈gtharcha öbërpiejem iekjã ũrpiba, õor khĩirjug ãrpʉ̈i nʉmta mag nʉrrjëe aajemgui ajim. Mamʉ mʉ chan am dënjö magaagta bëebajim. Mʉʉn sĩi mʉchdëu Ẽwandam iek jaau chitʉmta ʉ̈khabarmʉn, ich mag i dënkha wënʉrranaa mʉig eegarwejã onee amkhĩirta bëejimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Magnaa, Mʉʉta Pastor chaar chi wajapcharamʉugui ajim. Pastor chi wajapham abarmʉn ich nemchaain peerdʉ awaagjã ichta ʉdʉraa thõopiejemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pari magba ar pastor anʉm khʉʉnjã sĩi phatkhon atheepai thʉnʉm khʉʉnan, lobou nemchaain pʉraan urum oowaijã warag amachta khaphigbaadeejem. Amach nemchaain khaba aawai bʉ̈ʉrjã am gaai mas khaba sim. Mag warag parhooba nemchaain dau aphʉʉ aaidʉpiejemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mag warag pastornaan anʉmta amachdëupa ögkhawia khaphig phöbaadeejemgui ajim, nemchaain thʉam khõchgau khaba sĩi phatkhon atheepaita naawai. ");
INSERT INTO noaE_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Maimua mag iekhamamua deeu ichdëupai, ’Mʉʉta Pastor chaar chi wajapcharamʉugui ajim ich igwia. Ich jãg mʉ Ayau wajapha mʉch khaphʉnaa muajã mʉch Aai khaphʉ chitʉmjö, mʉch igar nʉm khʉʉnjã mua khaphʉ chitʉm; maagwai amachdëujã mʉ khaphʉ aajemgui ajim. Chadcha mʉch dën aawai mua am kõit ʉdʉraa mʉch thõopijugui ajim, am peerdʉ awaag. ");
INSERT INTO noaE_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pari agjö deeum khʉʉn thʉnʉmgui ajim, mʉg israelnaan khabam khʉʉn. Makhʉʉnjã mua ãbamʉg jʉr phë aujugui ajim, amaujã mʉ iek ũrbaawai ʉ̈khamkhĩir. Mag, israelnaan dʉ̈i pap ãbam dënkha nʉisiewai mʉchta am Pastorkha chitajugui ajim, amach thum ãba thʉa wai chitaag. ");
INSERT INTO noaE_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Magua, mag pastor wajaphamjö õor kõit ʉdʉraa mʉch thõopiju aawai mʉ Ayau mʉ daupii wai simgui ajim. Pari mag ʉdʉraa mʉch thõopiwiajã deeu iiu phiidʉjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mag mʉch thõopiju a chirʉm chan, ajués chikhamnauta mʉrʉg magpi naawai khaba, mʉch khĩrauta õor kõit mʉch thõopijugui ajim, am peerdʉ awaag. Mʉ Ayau mʉrʉg magta apitarr aawai mua chadcha ʉdʉʉr mʉch thõopiju aai chirʉm. Pari deeu ũwaai mag iiu phiidʉagjã jua theeg chirʉmgui ajim am jʉ̈g daar. ");
INSERT INTO noaE_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Pari chi judionaan chi pörnaanau Jesuu mag iekhabarm ũrbaawai, amach pem aawai, deeu ũwaai sĩi chum aaiphur iyʉ̈ʉ ihãbajã khaba nʉisim iekhau, ");
INSERT INTO noaE_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","khapankham khʉʉnau warag amach khapeenag, —¿Khanthee pãrau i iek ũr nʉma? Jã sĩi ich pör ee dösãt bën wai simua lököo sĩewaita mag iekha sĩebahab aajeejim, chi Jesús igwia. ");
INSERT INTO noaE_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pari magbaawai ãaur khʉʉnau mag nʉm ee, jũrr warm khʉʉnau, —Pãar dak pör ee dösãt bën paraam khʉʉnau i dënjö mag iekhajupa anaajim. ¿Wa pãrau khĩirjuawai meperau dau khĩsum khʉʉnjã daujã wajaug apiju aai sĩwa? aajeejim, ich Jesuu bi eewe dau khĩsu thaabatarr monaautarr igwia. Jesuu mag iekhatarr mag phiesta Las Enramadas anʉm dichtarr khur ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Maimua ag khur nʉʉ awia Jerusalén phöbör ee deeum phiesta wau naajim, Aai i jëeujem di ëu aaipawia di theerthʉgtarr phiesta. Magtarrta ewag pawiajã ich ag edau paawai ich mag phiesta waaujeejim. Mag phiesta noseg jaar ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Maigta Jesús phʉʉrdʉ nʉrrajim daaugajãr Aai i jëeujem di bigaau, “Pórtico de Salomón” a thʉ̈r sim ee, dijãjö nem pöm wëu wëjöm ee. ");
INSERT INTO noaE_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","I mag nʉrrʉmta judionaan khapan i aig pos aichëwia irig, —¿Jãagwaita pua marag meerba pʉch jaaujuuta jãg sĩma? Pʉʉta chadcha warrgarwe ich Ẽwandamaucha pʉ̈iju aajerr khai, warre marag jaaubá ajierram, marau khap aag. ");
INSERT INTO noaE_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Magbaawai ich Jesuu amag, —Mua khabá ya pãrag jaaubarm, pari pãrau ʉ̈khamapha nʉmgui ajim. Mʉ Ayau mʉchig waupitarrjö wau chitʉm oo nʉm gaaimua pãrau khaphʉ aju aai nʉm, mʉ chadcha ichdëu pʉ̈itarr. ");
INSERT INTO noaE_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pari chaig mʉchdëu jaau chirarrjö, pãar mʉ igar khaba naawai, mua mag mʉ Ayau mʉ pʉ̈ijim a jaau chirʉmjã pãrau ʉ̈khaba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Chadcha mʉ dënkha nʉm khʉʉnaun, jãg ovejanaanau iek gaaipai amach pastor khaug aaujemjö, mʉjã khaphʉ nʉm, mʉ khai agá; maagwai mʉchdëujã mua am khaphʉ chitʉmgui ajim. Mag mʉ khaphʉ naawai mʉʉta am na dʉnʉisimʉn, amachdëujã mʉ ẽudee weetjemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Magbaawai mʉchdëuta mʉch Aai aar am öbërju aai apiejem, tag okhooba sĩi i chaainkha ich mag wënʉrramkhĩir. Ya magbarm chan ni ãbmuajã mʉ jua eem khechthʉg aubamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mʉ Aai ichta thumaam khʉʉn khãaijã ʉ̈rpai sĩerrʉmuata mʉrʉg makhʉʉn deejimgui ajim. Mag ichta ʉ̈rpai sĩerrʉmua deetarr aawai ãbmuajã i jua eemjã pöd khecheubamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Magnaa, Mʉ mʉch Aai dʉ̈in maran ich ãbampaiugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Amachig magbaawai chará chi judionaan ũwaai sereu phöbaadëwi deeu i mokou barm ig naajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pari mag nʉm ee Jesuu amag magjim: —Mʉ Ayau ich jua theeg mʉrʉg deetarrau mua chadcha pãar dakhĩir nem wajapham pöm khĩir pogkhe wauwia chirʉm. Pari mag nem khĩir pogkhe wautarr ee, ¿chijãg gaaimuata pãrau mʉ mokou barm ig nʉ? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Magbaawai chi judionaan chi pörnaanau, —Marau chan mag pua nem wajapha waaujem gaaimuata pʉ mokou baraagpam aba nʉm. Marau chadcha pʉ mokou barm ig nʉmʉn, pʉch iek gaaimuapaita pʉ barm ig nʉmgui ajierram irig, mʉg maach ãba thum agdaujöpai thʉnʉmta pʉ iek mag pʉʉn Ẽwandamau anaawai. ");
INSERT INTO noaE_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Magbaawai ich Jesuu amag, —¿Pãrau oowai mua magju khaba chirʉ́? ajim. ¿Pãrau khĩir eyaa khaba nʉ, ar Ẽwandamau pãar jöoinag ich iek phãpitarr gaai, “Pãran ẽwandamnaanau” a phã sim? ");
INSERT INTO noaE_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Irua magtarran ich i jaaumkhĩir jʉr autarr khʉʉn igwiata mag sĩejimgui ajim. ¿Pari makhʉʉnjã agjö mʉig eegarm khʉʉn khabajĩ? Magua maadëu khaphʉ nʉmgui ajim, ich Ẽwandamauta mag phãpitarr aawai mua mag mʉʉn Ẽwandam Iewaau a chirʉm aig pãrau mua khaigba iekha chirʉm aju khaba nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ich Ẽwandamauta ich aarmua mʉ jʉr auwia mʉg jẽb gaai pʉ̈itarrta, ¿jãga pãrau mʉrʉg mag mua khaigba iekha chirʉm abarju, mua Ẽwandamag Aai icheewai? ");
INSERT INTO noaE_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Pãachdëu oowai mua mʉch Ayau nem waaujem khĩir waubata chirʉm khai, magan oob mʉ iek ʉ̈khamiet ajim. ");
INSERT INTO noaE_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pari pãachdëu oowai muajã irua nem waaujemta wau chirʉm khai, mʉ iek ʉ̈khaba awiajã khaphʉ abat ajim: ich Ẽwandam chi Aaijã mʉ dʉ̈i sim, maagwai mʉchjã mʉch Aai dʉ̈i chirʉm. ");
INSERT INTO noaE_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pari ich Jesuu magbaawai ũwaai i pʉr auju ẽkhajierram. Pari ich pʉr aupiba, ʉ̈u peerdʉ kheerbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Maimua mawia ag na Juan chi õor pör choomieu Jordán ee õor pör choo sĩerr gar dʉrbawia maig sĩsijim, edau öbeerjem gar. ");
INSERT INTO noaE_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mag i maig sĩeimaawai õor pöm i aar wëtwia amach eepai, —Keena, chadcha Juanau chan mʉg Jesús dënjö ag na õrau nem ooba aajemjã wauba khitajim. Mamʉ irua ich mʉg woun igwia nem jaaujerran, chadcha thumaa ich ag eeta jaaumajimgui ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Maig irua Ẽwandam iek jaau sim ũrwia õor khapankham khʉʉnau i iek ʉ̈khajierram. ");
INSERT INTO noaE_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Biek ãb phöbördam Betania anʉm ee woundam Lázaro anʉm mor machpajim aajem. Ich Lázaro ʉ̈phʉʉin numí wai sĩejim, María Marta dʉ̈i. Makhʉʉn dʉ̈ita sĩejeejim ich. ");
INSERT INTO noaE_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ich mag Lázaro ʉ̈phʉi Mariaau ajim, maach Pör Jesús bʉ̈ ʉ̈r jʉ̈gdeeu choonaa ich pörbʉ̈ʉupai jʉʉupʉ̈itarr. ");
INSERT INTO noaE_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mag amach ẽphemkhöi mor machpawia warag eeg pamaawaita amach numiim khʉʉnau õor jʉr auwia ich Jesús aig pʉ̈ijierram, jawaan mamkhĩir. Magbaawai chadcha bëewia, —Señor, pʉ khapkhʉʉn chi wajapham pua ʉ̈rcha iigjemjã pödba khërʉmgui a jaauchëjim Jesuug. ");
INSERT INTO noaE_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pari ichig mag jaaubaa sĩi warag, —Jãg khamor machagau chan i meem iek meebamgui ajim. Jãan sĩi jãg khamor machag gaaimua Ẽwandamta thumaam khʉʉn khãaijã ʉ̈rpai sim anaa mʉchjã i Iewaa aawai agjö chirʉm a khap amkhĩirta jãgpijimgui ajim ich Jesuu mag ichig iek jaauchëtarrag. ");
INSERT INTO noaE_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesuu chadcha Marta dʉ̈i Mariajã oomap khaba ni ich Lazarojã oomap khaba aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mamʉ mag simta mag Lázaro mor mas sim ichig jaaubaichëmjã maba, warag khãai numí mag maach narr aig sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Maimua ag khur ya khãai numí naata marag ichdëu, —Deeu Judeaag wëttarraugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Magbaawai marau irig, —Maestro, ¿ĩschapai ich jamaam khʉʉnau peer pʉch mokou bar thõotarr khʉʉn aarta deeu pʉ mam ig sĩ? anaajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Magbaawai jũrr ichdëu marag, —Pari agtha amau mʉ thõoju ora khaba sĩebahab ajim. ¿Pãrau oowai mʉg edau ãspapakham doce oras sĩeba aajẽ? ajim. Ãsdawan maach dichmam aig mawiajã bʉ̈ waaur thʉthʉgag maba aajemgui ajim, ãsdaau aawai. ");
INSERT INTO noaE_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pari maach edaarta chitaju atheen, sĩi bʉ̈ëu subaadeeu khãijã buudimajugui ajim, khĩchag ee aawai. Mag agtha ag ora khaba sĩewai araragagta chitʉmjö õrau mʉ chig abajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Maimuata sĩi awia, —Maach khapkhʉʉn Lázaro ya khãibaadëm; pari mua deeu i phiriupäain majugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Magbaata marau irig mag naajim: —Señor, mag khãibaadëm khai, magan ʉ̈u i khĩirdam inaa aadëm. Mag khai magan ʉ̈u pör khoordʉjugui anaajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pari Jesuu mag Lázaro khãibaadëm a sĩerran, maan iin ya i meebaadëmta jaau sim ajiebma. Pari mag simta maraun khaugba, sĩi khãai chaar khãibaadëmta jaau simpii naajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Maimuata ya warre marag, —Lázaro meejimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pari ʉ̈uta mʉ i aar khaba chirajimgui ajim. Magba akhiin nau jãg chi mee sim mua pãach dakhĩir phiriu aujujã oobakham. Mamʉ chadcha Ẽwandam jua theeg mʉ gaai sim khap amkhĩir, i aarcha oon wëttarrau ajim marag. ");
INSERT INTO noaE_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mag irua oon wëttarrau abaawai maar eem ãb maar khapeer am dën ibʉʉr wauwia Meís a thʉ̈ʉrjerrau, —Keena, magan maachjã i dʉ̈i wëttarrau ajim, i dʉ̈i ãba khëchimaag. Irua mag sĩerran, Judeapienau peer ich Jesús thõotarr aarta deeu ögkhaba maagpam igwiata mag sĩejim. Mag Meís anʉm, i thʉ̈r chaar Tomás ajim. Mag, chadcha Jesús mam dʉ̈i maarjã i dʉ̈i wëtjim. ");
INSERT INTO noaE_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mag wëtwia ũrimaawaijã, ya khãai jayap sim a jaau naajim, chi Lázaro aukhërtarr. ");
INSERT INTO noaE_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mag chi meetarr phöbör Betania anʉm Jerusalén dakha kilómetros thãrjupjö sĩejim baraag. ");
INSERT INTO noaE_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jerusalenmua mag dakha sĩewai judionaan khapan weetjeejim aajem, Marta María dʉ̈i nʉm aar, mag amach numpai aphöbaadeewai amach ẽphemkhöi khĩirjuwia atcha gaai machgau ökhĩirjuu apimaaugau awia. ");
INSERT INTO noaE_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mag nʉm ee Martaau ũr athajim aajem, ya Jesús amach dakpamam. Mag khaug athaawai i khĩirphee oon bëejim. Pari María maba, deg sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mag bëewia ya Jesús dʉ̈i thẽubaicheewai chi Martaau irig, —Señor, pʉ mʉig sĩerr akhiin, mʉ ẽphemkhöi mʉg dau aphʉʉ abakhamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pari mua khaphʉ ʉmgui ajim, pua Ẽwandamag jëeubaawai pʉchdëu jëeubarmpierr irua aju. ");
INSERT INTO noaE_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Magbaawai Jesuu irig, —Marta, pʉ ẽphemkhöi deeu iiu phiidʉjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Magbaa Martaau, —Chadcha mua khaphʉ ʉmgui ajim, mʉg atag ötarr khʉʉn thum deeu phiidʉtkha nʉm edan ijã dʉ̈i phiidʉju. ");
INSERT INTO noaE_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Magbaawai irig Jesuu magjim: —Muata õor phiriu aunaa ich mag wai chirsiejem. Chi mʉ iekta ʉ̈kha sim khʉʉn meewiajã deeu iiujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maimua ar mʉig eegarwejã mʉ iekta thãraucha ʉ̈khawia mʉ dënkha thʉnʉm khʉʉn chan meem iek meebam. Makhʉʉnan meewiajã deeu phiidʉtkhawia ich mag nʉisijugui ajim. Magnaa irig, —¿Pua mʉ mag iekha chirʉm chadcha ʉ̈kha ʉwi? ajim chi Martaag. ");
INSERT INTO noaE_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Magbaawai chi Martaau, —Señor, mua khaphʉ ʉmgui ajim, pʉ chadcha ich Ẽwandam Iewaau. Pʉʉta warrgarwe ich Ẽwandamau ich iek jaaumkhĩir mʉg jẽb gaai pʉ̈iju aajerr khabahab ajim irig. ");
INSERT INTO noaE_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maimua Jesús dʉ̈i mag iekha dʉnaawia, chi Martaau ich eeum aar mawia, ökharii i kach gawaa, —María, maach Maestro ya chum phöbör igaau sĩeichëm. I iek pʉ dʉ̈i iekhaag aajemgui aimajim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mag chadcha ichig mag jaaubaimam bʉ̈rre Jesús aig bëejim. ");
INSERT INTO noaE_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Maagwai chan agtha Jesús phöbör ee dubba, Marta dʉ̈i ootarr aigpai sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pari mag María apuraa öbërbaadëm oobaawai judionaan am khĩir jãsenkhaag am aig bëewia narr khʉʉnau chi binaandam aukhërtarr aarta bĩen mampii awia dʉ̈i i ẽudee pochag bëejim. ");
INSERT INTO noaE_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mag bëewi, Jesús aig barchëwi, i bʉ̈khʉrr phõbkhanaa irig, —Señor, pʉ mʉig sĩerr akhiin, mʉ ẽphemkhöi mʉg dau aphʉʉ abakhamgui ajim, bĩemamua. ");
INSERT INTO noaE_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mag warag ich dakhĩir bĩebaadëm dʉ̈i chi judionaan i dʉ̈i bëetarr khʉʉnjã bĩephöbaadëm oobaawai ichpa ö jãsenaaga aadëmua gaai machaaga aadëjim. ");
INSERT INTO noaE_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mag warag ich aig narr khʉʉnagta, ¿Jampaita aukhërjierrá? a jëeujim. Magbaa amachdëu, —Señor, achum khabahab; oomierrau ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mag gaai machag aadëmua ich Jesujã bĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mag Jesús bĩebaadëm oowia chi judionaanau, —Keena, pãadë oobat: Jãgan chadchata irua i jãsene aajeejimwai aajeejim jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pari makhʉʉnau mag nʉm ee, agjö bigaaum khʉʉnau jũrr, —Ichta mʉig sĩerr akhiin, jãg dau khĩsu khitʉm monaautarrjö, ¿mʉg Lazarojã irua monaaubakham khai? aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mag mawia ya chi aukhërtarr aar pabaimaawai deeu gaai machag aadëjim. Chi binaan aukhërtarr jẽbdi, nawe durrbʉ̈ ee chi khörm ajim. Mag simta mok pör pöm simuata sĩi chi jẽbdi i ee joothʉ wai naajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Mag aig pachëwia Jesuu chi aig narr khʉʉnag chi mokpör chawag pʉrëupʉ̈ipi jaaujim. Magbaawai Martaau irig, —Señor ya maach aukhërtarr khãai jayap sim aawai ya maach ãr khërabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Magbaawai Jesuu irig, —Mamʉ mua khabá chaigjã pʉrʉg, mua i phiriu auju pʉch thãar ee khaphʉ ʉm khai, pua chadcha Ẽwandam jua theeg ooju a chirajimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mag chi mok chawag pʉrëupi jaautarr aawai chadcha chawag pʉrëupʉ̈ijierram. Magbaawai Jesuu ʉ̈gthaag eerpanaa Ẽwandamag, —Tata, mua pʉrʉg ʉ̈u ajim a chirʉmgui ajim, mʉg mʉchdëu jëeu chirʉm pua ʉ̈u mʉ iek ʉ̈khabaawai. ");
INSERT INTO noaE_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mua khaphʉ chirʉmgui ajim, mua pʉchig jëeuwai pua mʉ iek ʉ̈khaajem. Pari magʉm ãba, ichiita thumaam khʉʉn jʉ̈g daar mua thet mag ʉ̈u ajim a chirʉmgui ajim, thumaam khʉʉnag chadcha pʉchdëuta mʉ pʉ̈ijim a khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mag iekhawia deeu ichdëupai jũrr mag chi meem jẽb deg sĩerragta i thʉ̈rcha thʉ̈rthʉ̈rnaa thet, —Lázaro, dawag öbërbaichë ajim. ");
INSERT INTO noaE_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Magbaawai maach chi meem arrta chadcha dawag öbërchëjim. Oowai ich aukhërtarr ich mag bʉ̈ aarmua khĩeb mor thum dĩes baúa pʉrëunaa ödi aigmua ʉ̈gthaag pörpa khĩir jãarjemua pʉrëu simta öbërchëjim. Mag öbërbaicheewai aig narr khʉʉnag, —Jãimua jãg put ẽerkhabapʉ̈it ajim, idëu ich diig mamkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mag Jesuu Lázaro phiriu autarr amach daúacha ootarr gaaimua, judionaan khapan María dʉ̈i bëetarr khʉʉnau khaphʉ nʉisijim, chadcha Jesús ich Ẽwandamau pʉ̈itarr. Mag warag i igar nʉisijim. ");
INSERT INTO noaE_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pari mag thʉnʉm ee, ãaur khʉʉn warag fariseonaan aar wëtjim. Mag wëtwi Jesuu mag õor phiriu athamta ĩgkhaimajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Magbaawai chi fariseonaan, phadnaan chi pörkha narr khʉʉn dʉ̈i ãba, tagam khʉʉn chi thierrnaanpa biirdʉjierram aajem. Mag biirdʉnaa amach eepai jũrr amach khapeenagta, —Keena, ¿maadëu jãga ajuma jãg woun dʉ̈i? ajierram anʉm. Jãguan chadchata maach dauderraa ag na õrau nem ooba aajempata wau nʉrrʉm. ");
INSERT INTO noaE_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Maadëu ʉdʉraa irig jãgʉm nem waupi nʉmʉn, thumaam khʉʉnta i igar paaukhawia amach reikhapiju. Magbaawai Romapien chi thethemnaan bëewia, jũrr maach Aai i jëeujem diita pogueupʉ̈inaa, maachjã dau aug waujugui ajierram aajem. ");
INSERT INTO noaE_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mamʉ ãaur khʉʉnau mamagkham ee, ãb mag añoou phadnaan thum thʉnarr khʉʉn pörkha sĩerr Caifás a thʉ̈ʉrjerrau ich khapeenag, —Pãrau chan bʉ̈ʉrjã khĩirjubata iekha nʉmgui ajim anʉm. ");
INSERT INTO noaE_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Magnaa ichdëupai, Mua oowai wajapcha ajuun, mag pãrau jaau nʉmjö maach thumaam khʉʉnta dau aphʉʉ apiju khãai, jãg appaita maach thumaam khʉʉn kõit thõopiju aai simgui ajim anaabá, Jesús igwia. ");
INSERT INTO noaE_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pari wajapcharan Caifaau mag iekhatarr chan ich khĩirjugjã khabajim. Wajapcharan mag añoou ichta thum phadnaan thʉnarr khʉʉn pör arr aawai ich Ẽwandamau mag iekhapibaawaita mag iekhajim, Jesuuta judionaan thʉnʉm kõit thõju igwia. ");
INSERT INTO noaE_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pari magbarm chan ĩchab judionaan kõitpai khaba, ewag paawai thum ich chaainkhaju khʉʉn kõitpa thõju a sim ajim, judionaan khabam khʉʉn awiajã, magbarmua ich chaain durrpierram khʉʉnta khod ãbamkha awaag. ");
INSERT INTO noaE_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ya Caifaau mag iekhatarr aawai magtarr aigmua judionaan chi thethemnaanau ãba ibëpwia warre Jesús thõoju khĩirjugta wai nʉisijim. ");
INSERT INTO noaE_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesuu ya mag ich thõoju khĩirju nʉm khaphʉ sĩerr aawai ya tag judionaan ee parhooba nʉrraba aajeejim. Mag gaaimua ichta warag Judea durrmua warp petajim, phöbördam Efraín anʉmʉg. Mam chan õor pömcha khaba naajeejim. Maig maar i dʉ̈i naaimajim, i kha ogdʉba wënʉrraajerr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mag phöbör Efraín anʉmʉg weetwai judionaan phiesta Pascua aajem burrju dakpapa khajim. Amach i arr aawai, mag phiesta ʉ̈rʉʉ arr aawai, õor pöm Jerusalenag ërërëu khajim, Pascua burrju nawe khĩir khaugaag, amach jöoinau jaaujerrjö domer nʉmua amach khaibag barpäain. ");
INSERT INTO noaE_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mag wët thʉnʉmuan Jesuuta jʉrphöo aajeejim. Maimua ya Aai i jëeujem degcha paaukhaimawiajã i bëebaju khĩirjuwia jũrr amach khapeenagta, —Keena, ¿pãrau khĩirjuawai mʉg phiesta ee i bëeju khai? aajeejim aajem. ");
INSERT INTO noaE_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Maagwai chi fariseonaanau phadnaan chi pörkha narr khʉʉn dʉ̈imua ya õrag jaaukha wai naajim aajem, chi Jesús sim khaug athaawai amachig jaaumkhĩir, mag amachig jaaubaawai sĩi i pʉr awaan wëtaag. ");
INSERT INTO noaE_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Maimua mag phiesta Pascua burraag seis diaspai waaur nʉm eeta, ich Jesús Betania anʉmʉg mam dʉ̈i maarjã wëtjim. Mag Betania phöbör eeta mag woundam Lázaro anʉm ichdëu phiriu autarrjã sĩejeejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mag i barbaimaawai maiguim khʉʉnau wajap phiejãb wauwia Jesús khöpiju aphöbaadëwia chadcha waujierram. Maimua ya thum wau aaipa sĩsiewai chi Lázaro ʉ̈phʉi Martaau chi nemek thöi jijig khajim. Maagwai maar thach khö nʉm aig ĩchab ich Lazarojã dʉ̈i thach khö sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mag nʉmta ich Lázaro ʉ̈phʉi ãbakhai María jʉ̈gdee narrdo chaar dën nem parhẽpagkham dʉ̈i dubchëjim. Mag dubchëwia, chigagjã igba, agua Jesús bʉ̈ sũgnaa deeu ich pörbʉ̈ʉupai jʉʉupʉ̈ijim. Mag nem thũpag sĩewai mag irua Jesús bʉ̈ agua sũgbaadee sĩi dijã ëntër thʉ̈ap jöisijim. ");
INSERT INTO noaE_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Mag oobaawai maar eem ãb maar khapeer Judas Iscariote a thʉ̈ʉrjerrau magjim: —Ë, jãg jʉ̈gdee trescientos denariom gaai përpʉ̈iju aai sĩerrta, ¿khanthee sĩi jãg ãr choobaadëma, agua aphʉʉm khʉʉndamag nemdam audeeju aai sĩerrtá? ajim. Ich mag Judaauta ewag pawiajã ich Jesús oomapha aajerr khʉʉnag i pʉr deeju ajiebma. ");
INSERT INTO noaE_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pari Judaau mag iekhatarr chan sĩi chadcha aphʉʉm khʉʉndam khĩirjuwia khaba, nem jĩgmie arr aawaita mag iekha sĩejim. Ichdëuta maach thumaam khʉʉn phatkhon di wai nʉrraajerr aawai õrau maachig deemam aukhërmamjã ichdëu jĩgkham aig jĩgkhaajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Judaau mag iekhabaawai Jesuu irig, —Idëu irig jʉ̈gdeeu mʉ bʉ̈ sũgpibá ajim. Jã i dën nau jöpcha mʉ meebaadeewai agua mʉ kha phuraag sĩi ãkha wai sĩerr khabahab ajim irig. ");
INSERT INTO noaE_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Magnaa, Aphʉʉm khʉʉnan ich mag pãrau pãach ee oo wai wënʉrraju; pari mʉ chan ich mag pãar khĩir chitabajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mag Jesús Betania sĩeichëmjã chi judionaan Pascua dichaag bëetarr khʉʉnau khaug athaawai khapan i oon bëejierram. Pari mag bëe thʉnʉm chan i oogpaijã khaba, ich Jesuu Lázaro phiriu auwia maach ich mʉg sim oogpata bëe naajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Pari mag Jesuu i iiu autarr gaaimua, judionaan pöm tag amach igar khaba jũrr Jesuu jaau nʉrrʉmta ʉ̈kha thʉnʉisierr aawai, chi phadnaan pörnaanau jũrr ich Lazaropata dʉ̈i thõopʉ̈ijugui aphöbaadëjim. ");
INSERT INTO noaE_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mag Jesús dʉ̈i maar Betania paaukhachëtarr noram Jerusalenmua ũrphöbaadëjim aajem, i barju. Maagwai ya õor pöoma Jerusalén phöbör ee thʉnaajim aajem, mag phiesta athee wëttarr khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mag ũrphöbaadeewai õrau sothark piujöm thʉrrphënaa ag jua panhapha i khĩirphee bëejierram. Maimua ich dʉ̈icha oobaicheewai serereukhamua onegau, “Ʉ̈ucha abarm Ẽwandam. Ich mʉʉta pʉchdëu maar israelnaan athee pʉch jũrr pʉ̈ibarmʉu. Ichta maar Reikhaju aawai pʉchdëuta i ʉ̈u wai chitajugui” aajeejim jũrram khʉʉnau. ");
INSERT INTO noaE_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mag wëtumua ya ag nawe Ẽwandam iek phã sim gaai ich Jesús igwia jaau simjö, burrodam ʉ̈r waaidʉwia warag ag gaaita mamua phöbör ee ich mag dubjim. Mag chi Ẽwandam iek phã sim gaai: ");
INSERT INTO noaE_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sionpien, onee abat. Pãadë oobat: ar pãar Rey sĩi parhoobam khʉʉnjö burrodam gaaita urum” a sim. ");
INSERT INTO noaE_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eeu i mamag khabaadeewai chan maach chi dʉ̈i wënʉrraajerr khʉʉnau chan marau bʉ̈ʉrjã khaugba naajim, jãgwiata mamag khajĩ. Maimua ya nassi pawia ich Aai aar ʉ̈gthar petarr khurta marau khaphʉ aphöbaadëjim, ya ag nawe i jãgju Ẽwandam iek phã sĩsidʉm gaai jãg jaau sim aawai juaujö jãgtarr. ");
INSERT INTO noaE_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Mag õor pöm Jesús khĩirphee oon bëetarran, irua Lázaro chi meem ya jẽbdeg sĩerrta deeu phiriu autarr chi ootarr khʉʉnau jajaaukham ũrwia i oom khõchgauta mag i khĩirphee bëejierram. ");
INSERT INTO noaE_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pari maagwain jũrr chi fariseonaanau amach khapeenagpaita, —Keena, pãrau oo nʉm, jãg sĩi amag iekha nʉmuapai chan maadëu pöd maachig paa aubamgui aajeejim. Magnaa, Oojurauma, jãg thumaam khʉʉnta sĩi i igar paaukhamamgui aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mag Pascua ee õor pöm Jerusalén wëttarr khʉʉn ee ĩchab judionaan khabam khʉʉnjã thʉnaajim, Aai i jëwaan bëetarr khʉʉn. ");
INSERT INTO noaE_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Makhʉʉnau Felipe aig bëewia irigta, —Kakë, marau Jesús dʉ̈i iyʉ̈ʉ am khõsi nʉmgui aichëjierram. Mag Felipeegta jëeuchëtarran amachjö judionaan khabam ee bãautarr aawai ajim, amach kõit Jesuug iekhamkhĩir. Chi Felipe phöbördam Betsaida anʉm eem ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Magbaawai Felipeeu jũrr agjö maar khapeer ãb Andrés anʉmʉg jaauwia amach numiim khʉʉnau jũrr ich Jesús aarcha jawaan wëtjim. ");
INSERT INTO noaE_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mag wëtwia judionaan khabam khʉʉnau ich jʉr wënʉrrʉm a jaaubaicheewai amjã peerdʉ awaag ʉdʉraa ich thõopiju jaaubaadëmua magjim: —Ya ĩsta chadcha mʉch chi Emkhooi Iewaa chikhamnau thõoju gayaa pamamgui ajim, mag amau mʉ thõobarmua mʉchta Ẽwandamau thumaam khʉʉn khãaijã ʉ̈rpai apieg. ");
INSERT INTO noaE_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","¿Pãrau ooba aajẽ ajim, nemjĩir dau ĩiu awaagjã jãga aajẽ? Jẽb ee jĩirbam chan maan ich mag sĩsim, bʉ̈ʉrjã ĩiuba. Magarrau jĩir sĩuwia öbër sĩsiewain chadau chëbaadëmua ich jĩirtarr khãaijã ʉ̈r aaujem. Ich agjöta mʉjã meeju aai chirabahab ajim, mag mʉch meebarm gaaimua õor pöm peerdʉ awaag. ");
INSERT INTO noaE_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ich agjö khaphʉ abat ajim: Ar mʉig eegar aawai mʉ gaaimua bʉ̈ʉrjã ich chig apimapha sim chan meewaijã ʉ̈gthar öbërbam. Pari mʉ gaaimuata ich dau aphʉʉ ajujã khĩirjuba mʉ iek ʉ̈kha nʉrrʉmʉn chadau meewiajã ʉ̈gtharchata öbërwia mʉg atagjã ich mag iiu sĩerrajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maimua ĩchab chi chadcha mʉ chogkhanaa mʉ dʉ̈i nʉrram khõsi simʉn, ichdëu khõchagpierr nem wauba, mʉchdëu nem waupim khõsimpaita wau nʉrraju aai sim. Mag amʉn magan am wënʉrrʉmpierr mʉchjã am dʉ̈i chitajugui ajim. Ãbmua magta mʉ chogkha nem wau nʉrrʉmʉn, mʉ Ayaujã ich khĩircha i thö iekhajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Maimua mag jaaumamua ĩchab, ’Ĩs chadcha thumaa khĩirjuwia mʉ ökhĩirjug pöoma chirʉmgui ajim, chikhamnau mʉch thõoju dakkha pamaawai. Mag chirab mamʉ am jua ee thõmaaugaujã mua mʉch Ayag, “Tata, mʉ peerdʉ athájã” abamgui ajim, warrjã mag atheeta mʉ bëetarr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Maimua sĩi ich Ayag, —Tata, muan mʉch gaaimuata sĩi thumaam khʉʉnaujã pʉrʉgta ãba ee apim khõsi chirʉmgui ajim. Pari irua magbaawai ʉ̈gtharmuata woun iekjö, —Ya pʉ gaaimua õrau mʉrʉg ee abarm; pari ichiita warag mʉchig ee apijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pari edjã eemua Ẽwandamauta woun iekjö irig magbarm ũrbaawai aig õor narr khʉʉnau sĩi pagthʉmpii naajim. Maagwai ãaur khʉʉnau jũrr, —Ẽwandam chogauta ʉ̈gtharmua irig iekha sim khabahab aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pari amau mag nʉm ee, ich Jesuu thumaam khʉʉnag iekhamamua magjim: —Mʉg pãrau woun iekjö ũrbarm chan sĩi mʉchigpai ich iek ũrmkhĩir khabamgui ajim. Jãan jãg ich iek ũrpitarr gaaimua ichdëu mʉ iek ʉ̈kha sim pãrag khap amkhĩirta pãrag jãg iekhajimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ya ĩsta chikhamnau mʉ thõoju gayaa pamam. Mag mʉ isegwi mʉ thõobarm gaaimuata khaigbam khʉʉn thumaam khʉʉn dʉ̈i Ẽwandamau ichdëu khap ajugui ajim. Mag õor kõit mʉ thõobarm gaaimuata ĩchab mepeer mʉg durr gaai ichta chi pörkha sĩerrʉmjã Ẽwandamau pödpʉ̈im iek pödpʉ̈ijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pari ĩchab mag ʉ̈gthaa õor khapanag dakhĩir mʉ jiirjop sĩuwia thõobarmuata mʉch iek ʉ̈khamam khʉʉnan mua thumaa mʉchig paa aumajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesuu mag iekhamarran mag dau aphʉʉ pakuls gaai ich thõju jaau sim ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mamʉ irua mag iekhabarm ũrwia õrau irig, —Ẽwandam iek phã sim gaaimua marau khaphʉ nʉmgui ajierram, ich Ẽwandamaucha pʉ̈ibarm chan meeba ich mag sĩerraju a sim. Pari mag simta, pʉ iek mag pʉʉta ich Emkhooi Iewaa anʉmta, ¿jãga mag Emkhooi Iewaata ʉ̈gthaa pakuls gaai thõbarju? Magan, ¿ma khanim Emkhooi Iewaa agá? ajierram irig. ");
INSERT INTO noaE_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Magbaawai Jesuu amag ejemplo jaaumamua warag ichta Emkhooi Iewaa ich Ẽwandamau pʉ̈itarr khap amkhĩir magjim: —Ĩsweran pãrau agtha õtdau paa dʉnʉmjö mʉ oo wai nʉmgui ajim. Pari nau jöpcha ya tag pãar khĩir mʉ chitabaju. Magua agtha mʉ iek ũr nʉwe ʉ̈khabat ajim, khĩirjug khaigbamta pãach gaai ʉ̈rpam ugua. ¿Pãrau ooba aajẽ khĩchag ee wëtum khʉʉn? Amau amach wënʉrrʉmjã khaugba aajem. Chi mʉ iek ʉ̈khaba nʉm khʉʉnjã ich agjöta thʉnʉmgui ajim, amach okhoo nʉmjã khaugba. ");
INSERT INTO noaE_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Magnaa ichdëupai ich igwia, Mag õtdaujö sim agtha pãach ee wai nʉwe ʉ̈khabat ajim, ich mag mʉ dʉ̈i ararag ee wënʉrraag. Mag iekha sĩewia õor eemua igbaadeeu i sĩeimamjã tag õrau khaugba, ãba maach appaita i dʉ̈i naaimajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Parii Jesuu maach meeun judionaan khapan thʉnʉm dakhĩir nem khĩir pogkhe waumamua ich jua oopipi aajerrjã wajappai i iek ʉ̈khaba aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pari mag amau ʉ̈khamapha narran, ich Ẽwandam i jaaumie Isaías khararrau phã pʉarr eyaa öbërmkhĩir ajim. Irua phã pʉarr mʉg ajim: “Señor, parii pʉ iek jaau nʉmjã õrau ʉ̈khamapha ajugui” ajim. “Amau khaug aubajugui” ajim, “mag nem wau nʉm gaaimua puata pʉch jua theeg oopi sim.” ");
INSERT INTO noaE_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Magta chadcha ʉ̈khaba naajim. Amau mag ʉ̈khabaju igwia ich Isaiaaupai ĩchab, ");
INSERT INTO noaE_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ẽwandamau am dau khĩpinaa kach theegjã apiju” a phãjim, “oo nʉmjö nʉmta oobamjö amkhĩir, maimua ũr nʉmjö nʉmta ũrbamjö amkhĩir. Magba akhiin amau amachdëu oonaa ũr nʉmjã khaphʉ aawai, amach khaibag ãsie ewag khĩirjuwia Ẽwandamag amach peerdʉ aupiju” a phãjim Isaiaau ich Ẽwandamaucha ichig jaaumatarr. Pari Ẽwandamau judionaan mag thãar theeg apitarran, año khapan par ich iek ũrpitarrjã ʉ̈khamapha arr aawaita magpijim. ");
INSERT INTO noaE_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiaau ag nawe ichdëu ootarrjö magta phã pʉajim, ya Cristo mʉig eegar maach ich mʉg sĩeicheewaijã õrau i dau aphʉʉ wauwia thõoju khaphʉ sĩerr aawai. Pari magʉm ãba, Ẽwandamau ichta thumaam khʉʉn khãaijã ʉ̈rpai apijujã khaphʉ sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mag judionaan thumaam khʉʉnau chan Jesús iek ʉ̈khabajierrab mamʉ, ãaur khʉʉnaun ʉ̈u i iek ʉ̈khajierram; chi ʉ̈kha narr khʉʉn ee chi thierrnaanpa thʉnaajim. Pari mag ʉ̈kha nʉmta chi fariseonaanau, tag amach culto ee dubpimaaugau amach jʉr wërppʉ̈iju ögkhawia, amach khaugpiba aajeejim. ");
INSERT INTO noaE_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Maagjeejieb mamʉ amachdëu mag ʉ̈kha nʉm anʉmjã tagam khʉʉnagjã khaugpimapha narran, Ẽwandamau khõsimjö aju khãyau, sĩi mʉg dich khapeen ãba thʉnʉm khʉʉnagta amach ëugar khaigba iekhapimaaugau ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Biek ãb ijẽjẽbkhamua judionaan ich iek ũr narr khʉʉnag Jesuu thet magjim: —Chi mʉ iek ʉ̈kha simuan mʉ iek appai ʉ̈khaba ĩchab mʉ Aai iekpata ʉ̈kha simgui ajim, ich iek jaaupitarrta mua jaau chitaawai. ");
INSERT INTO noaE_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maagwai mʉ oobarmuan ĩchab ich chi mʉ pʉ̈itarrchata ya oobarmjö simgui ajim, maar ich ãba naawai. ");
INSERT INTO noaE_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mʉʉta mʉg durr gaai thum khĩchag eemjö jooba nʉm khʉʉn athee õtdaujö bëejimgui ajim, maagwai chi mʉ iekta ʉ̈kha nʉm khʉʉn chan sĩi tag khĩchag ee okhoo wënʉrrʉmjö khaba ararag eeta wënʉrramkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pari ar mʉ iek ũr nʉmjã mʉ ipierraa aba nʉm khʉʉn chan, mʉ mag warrjã mʉg durr khaibag wawaagta bëeba arr aawai, mua khabam ajim am khaibag waupi jaauju. Mʉʉn sĩi õor peerdʉ awaagta bëejimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pari mag chi mʉ isegnaa mua nem jaau chirʉm ipierraajã khaba nʉm khʉʉnan, sĩi amachdëupaita wir aig amach khaibag waupi jaaubarm, amachdëu isegtarr iekhaupaita Ẽwandamau õor i agkham edjã deeu am khĩir phʉʉrju aawai. ");
INSERT INTO noaE_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chi mʉ iek iseg nʉm khʉʉnaun khaphʉ aju aai nʉmgui ajim, sĩi mʉch khĩrauta mʉch iekham aig iekhaba chitʉm. Mʉ Ayauta mʉ pʉ̈itarr aawai, ichdëuta mua iekhamajujã jajawag maawai, ich agpierrpaita jaau chitʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mua mʉchdëujã khaphʉ chirʉmgui ajim, chi mʉ Ayau nem jaaupʉ̈i sim ipierraa nʉm khʉʉnan ʉ̈gthar öbërwiajã ich mag i dʉ̈i iiu wënʉrraju. Magua, mua nem jaau chitʉmʉn, mʉch Ayau mʉchig jaaupi jaautarrjöta jaau chitʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ya phiesta Pascua anʉm burrju khãai ãbpai waaur sĩejim. Maagwai Jesuu khaphʉ sĩejim, ya ichdëu mʉg durr werpʉawi deeu ich Aai dʉ̈i ãba sĩeimaju ed pabaadëm. Thum mʉg jẽb gaai maar ich dënkha durrarr khʉʉnan bʉ̈ʉrjã chig aba jãsehne aajeejim. Maagjerr aawai ya ãbmiecha amau i thõoju ed paawaijã agtha ichdëu maar khõsi sim khaphʉ apijim. ");
INSERT INTO noaE_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Amau i magju ed maar i dʉ̈i thum ãba thach khö naajim, ya kheeuraa pamamua. Maagwain Judas Iscarioteen ya meperau pör meu thʉnaajim, Jesús oomapha aajem khʉʉnag i pʉr deeg. Chi Judas woun ãb Simón anʉm iewaa ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesuu khaphʉ sĩejim, ich Ayau ichigta nem thum jaaunaa ʉ̈gtharmua ich pʉ̈itarr aawai deeu i aar maju. ");
INSERT INTO noaE_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mag khaphʉ sĩerr aawai thach khö oo sĩewi, phiidʉbaadëwi, ich khajũa ʉ̈rʉm ẽernaa, jũrr toayaauta ãi jʉ̈ sĩsijim. ");
INSERT INTO noaE_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Magnaa thëp pör pömaam ee dö choonaa maar bʉ̈ ʉbaadëjim. Mag ʉnaa ichdëupai deeu mag toayaau wajapha jʉser jʉʉupʉ̈imajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mag ʉkhapʉ̈pʉ̈igmamua ya Simón Pedro dën ʉag abaawai chi Simón Pedroou irig magjim: —Señor, ¿puata mʉ bʉ̈ ʉagá? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Magbaawai Jesuu irig, —Mua ĩs pãar dʉ̈i mʉg chirʉm pua pöd khaugba khabahab; pari ökharta pua khap abajup ajim, jãgwiata mua mʉg pãar bʉ̈ ʉ chirajĩ. ");
INSERT INTO noaE_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Magbaawai chará warag Pedroou irig, —Señor, pʉʉta mʉ khãai ʉ̈rpai sĩewai pʉrʉg chan mua mʉch bʉ̈ ʉpibamgui ajim. Magbaawai jũrr Jesuu chi Simón Pedroog, —Pua mʉrʉg pʉch bʉ̈ ʉpimapha chirʉm khai, magan ya tag pʉ mʉ dʉ̈i nʉrraju khaba simgui ajim irig. ");
INSERT INTO noaE_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Magbaawaita Simón Pedroou irig, —Señor, mag khai magan oob mʉ bʉ̈ appai ʉm. Mʉ bʉ̈jã ʉnaa, mʉ juajã ʉnaa mʉ pörpa sũurbapʉ̈i ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pari magbaawai Jesuu irig, —Ar ya wajapha domerwia nʉm khʉʉn tag domerju igba naabahab, ãba bʉ̈ appai ʉju aai nʉmgui ajim. Pãar thum khabahab mamʉ ya pãar wajapha domer nʉmjö thãar wajapha naabahab; ãba ãbpaita pãar ee domerbamjö thãar wajap khaba simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Irua mag maar ee ãb thãar wajap khaba sim a sĩerran, maach eem ãbmua imeraa wir aig ich pʉr deeju khaphʉ sĩerr aawaita mag sĩejim. ");
INSERT INTO noaE_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mag Jesuu maar bʉ̈ ʉkhapʉ̈iwia, ũwaai ich khajũa jũapʉ̈inaa deeu mes gaai jupchëjim. Mag jupchëwia marag, —Ĩsin chadau mua pãrag jaaukhimgui ajim, khantheeta mua pãar dʉ̈i mʉg chirajĩ. ");
INSERT INTO noaE_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Chadcha pãrau mʉrʉg Maestro anaa Señor aajem; pãrau mag nʉm aig agchata iekha nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mag mʉ pãar Maestro anaa pãar Pörkha chirʉmuata pãar bʉ̈ mʉg ʉbarpí, pãraujã agjö jũrr chikham chogkha nʉmjö agdaujö dich khapeen bʉ̈ ʉju aai naabahab ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mʉg pãar bʉ̈ ʉbarmua mua pãrag ejemplota dee chirʉmgui ajim, pãragjã mʉch dënjö amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Pãadë khĩirjubat. Sĩi chikham chogkha nʉm khʉʉn chan amach pörnaan khãai ʉ̈rpai khaba, ni sĩi piyonnaankha nʉm khʉʉnjã amach patronnaan khãai ʉ̈rpai khaba aajemgui ajim. Ich agjöta naabahab ajim maachjã. Mʉ pãar Pörkha chirʉmuata pãach dʉ̈i jãgbarm oowia oob pãachta pãach khapeen khãaijã ʉ̈rpai nʉm a khĩirjuwia, “Maar chan chikham chogkhaju khaba nʉm” a khĩirjumiet ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pãrau ya mʉ iek ũrbarm; pãrauta mua nem jaautarr khĩirjunaa chadcha mʉ ipierraa mʉch dënjö nem wau wënʉrrʉmʉn, pãar onee wënʉrrajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mag pãar onee wënʉrraju a chirʉm chan, pãar thumaam khʉʉn igwiata mag jaauba chirʉmgui ajim, ãb pãar eem cha mʉchdëu jaau chirʉmjö onee khabaju aawai. Mua khaphʉ chirʉmgui ajim, chadcha mʉchdëucha jʉr autarr khʉʉn thãar. Pari ichiita Ẽwandam iek phã sim gaai “Mʉ dʉ̈i ãbam mes gaai thach khoojerraupaita ãsie mʉ khaibag wauju” a phã simjö, chadcha ich ag ee öbërmkhĩirta mua jãjã jʉr aujimgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ya mua ag nawe pãrag jaau chirʉmgui ajim, maagwai ya eeupemjö magbaadeewaijã pãrag mʉʉta chadcha ich Ẽwandamaucha jʉr auwia pʉ̈itarrau a khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ãbmua mag wir aig mʉ khaibag waujup mamʉ, ichiita pãran mua pʉ̈i chirʉmgui ajim. Magua khaphʉ abat: Mua mʉch iek jaaumkhĩir pʉ̈i chirʉmta õraujã ʉ̈u pãar iek ũrm khõsi ũrnaa ʉ̈kha nʉmʉn magan mʉchdëucha jaaubarmta ʉ̈khabarmjö abarmgui ajim. Mag mʉ iek ũrm khõsi ũr nʉm khʉʉnaun magan ĩchab ich mʉ pʉ̈itarr iekchata ũr nʉmgui ajim ich Jesuu marag. ");
INSERT INTO noaE_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Marag mag iekhawia warag ichta gaai machaaga aadëmua, —Chadcha mʉ cha iekha chirʉm iekhau pãar eem khʉʉnau ãbmua wir aig imeraa sĩi chikhamnag mʉ pʉr deejugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pari irua warre chi thʉ̈rcha jaauba arr aawai marau khaugba, sĩi jũrr chikham khĩirta agdaujö eerpag eerpag naajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Maagwai mʉ i bigaau i dʉ̈i ãba thach khö oo chirajim, mʉʉta ʉ̈rcha ichdëu jãsene aajerr aawai. ");
INSERT INTO noaE_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mag mʉchta i bigaau chirarr aawai Simón Pedroou mʉrʉg juaupai jaaujim, khai igwiata mag sĩ a khap jëeumkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Magbaawai mua chi Jesús simʉgaacha ĩiudʉnaa irig, —Señor, mag pua jaau sim, ¿khai igwiata mag sĩwi? a chirajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Magbaawai ich Jesuu mʉrʉg, —Oobá, pʉrʉg oomkhĩir mua pan omnaa agʉgcha deekhimgui ajim. Magnaa chadcha pan khõreunaa, omnaa, Judaagta deejim, woun ãb Simón Iscariote anʉm ag iewaag. ");
INSERT INTO noaE_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mag Jesuu ichig pan omnaa ʉabaawai atham bʉ̈rre mepeer mag chi Judas pör ee dubtarrta warag ʉ̈rpabaadëjim. Magbaawai Jesuu irig, —Pʉchdëu wauju khĩirju simjö jöpai waubá ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pari mʉ khapeen dʉ̈i ãba thach khö narr khʉʉnau pöd khaugbajierram, jãgwiata irig mag sĩejim khai. ");
INSERT INTO noaE_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ich chi Judaauta maar thumaam khʉʉn phatkhon dijã wai nʉrraajerr aawai maraun sĩita irig phiesta ee nem igjuuta për awaan mamkhĩir jaau simpii naajim; wa magbam khai, aphʉʉm khʉʉndamag khãijã ag eem deepi jaau sim khãijã anaajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mag ichig pan ʉabapäaiwai, auwia, khöpʉ̈iwia, warre öbërbaadëjim maar aigmua. Maagwai ya edaar ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mag ya Judas öbërbaadeewai Jesuu magjim marag: —Ĩsta ya chadcha mʉch chi Emkhooi Iewaa jua theeg chirʉm thumaam khʉʉnau oogpam. Maagwai jũrr mʉ gaaimua Ẽwandamau ich jua theegjã oopiegpamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mʉch chi Emkhooi Iewaau Ẽwandam jua theeg mʉg oopi chirʉmjö, ich Ẽwandamaujã ĩchab nau jöpcha mʉ jua theeg oopijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mag iekhamamua ich thõoju igwia, ’Chaaina, mʉʉn sĩi khũchpaita pãar dʉ̈i chirajugui ajim. Mʉ petaawai parii pãrau mʉ jʉrju. Pari na mʉchdëu judionaan chi thierrnaan dakhĩir iekha chirarrjö, mʉʉgwaiwe chan pãar mʉ chiraimam aar pöd barju khaba naawai ");
INSERT INTO noaE_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","pãrag iek iiurta jaau pʉakhim. Ma, mʉgaugui ajim: Jũrr agdaujö chikham kha khõsi abat. Mua jãg pãach khõsi wai chitʉmjö, pãraujã agjöta pãach khapeen kha khõsi abat. ");
INSERT INTO noaE_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Magta pãrau chadcha agdaujö chikham kha khõsi amʉn, thumaam khʉʉnau khaphʉ ajugui ajim, chadcha pãar mʉ khapeenkha nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mag i iekha öpinaa Simón Pedroou irig, —Señor, ¿pʉ jamag mamta mag sĩ? ajim. Magbaawai ich Jesuu irig, —Ĩswe chan pöd pʉ mʉ dʉ̈i mabam; pari ökharta ich agjö pʉ mʉ ẽudee majugui ajim Pedroog. ");
INSERT INTO noaE_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Magbaawai deeu ich Pedrooupai irig, —Señor, pari ¿khan jãgwi ĩswe mʉ pʉ dʉ̈i pöd maju khaba chirʉ́? ajim. Pʉ gaaimuan thõju akhiinjã mʉʉn thõju chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Magbaawai Jesuu irig, —¿Chadcha mʉ gaaimua pua ʉdʉraa pʉch thõopiju chirʉ́wi? ajim. Mʉ cha iekha chirʉm iekhau nau õrau pʉchig jëeuwai ãthãrr bĩeju nawe biek thãrjup pua amag bʉ̈ʉrjã mʉ khaugba chitʉm ajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Maimua maach thumaam khʉʉnag, —Oob jãg tag ökhĩirjuunaa atcha khĩirju nʉʉ amiet ajim. Mʉ chan chadcha tag pãar khĩir chitabaju; pari mua pãach pʉabajeewai oob Ẽwandamaujã pãach iseg sim amiet. Magju khãai mua pãachig jawaagpamta khĩir eyaa abat ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Magnaa, Mʉ Aai sim durran di khapan õor joobaju pöoma thʉnʉmgui ajim. Mag õor joobaju pöm chukhu akhiin, mua pãrag, “Mʉʉn pãar naaimamkhĩir di khĩir khaugaagta pãar na mam” abakhamgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mʉ pãar na mamgui ajim; maimua ya nem thum khĩir khaug sĩsiewai ũwaai mʉ bëejugui ajim, pãar phë awaan, mʉch chirʉm aig dʉ̈i ogdʉba ich mag wënʉrramkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ya pãrau khaphʉ nʉmgui ajim, mʉ jamag ma, maimua mag mʉ chiraimam aarjã jãga barju. ");
INSERT INTO noaE_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Magbaawai maar eem ãb maar khapeer Tomás aajerrau jũrr irig, —Señor, marau khaugba nʉmgui ajim, pʉ jamagta ma; mag nʉm, ¿jãga marau pʉ aar barjujã khap abarju? ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Magbaawai ich Jesuu, —Mʉchpaita ʉ̈gthar maajem khʉd khabahab ajim. Mʉ gaaimuata chadam iekjã pãrau khaphʉ nʉm. Mʉchdëuta mʉg jẽb gaaiwe õor Ẽwandam dënkhapiejem. Ãba mʉ gaaimuapaita õran mʉ Aai aar barju aai nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Magua, pãrau ya mʉ khaphʉ nʉm khai, magan ĩchab mʉ Aaijã khaphʉ nʉmgui ajim. Mag i khaphʉ naab mamʉ, nau amau mʉ thõobarm aigmua atagta wajapcha i khaphʉ ajugui ajim, i jãga sĩerrʉ́, mʉ oo nʉm gaaimua ichchata oo nʉmjö naawai. ");
INSERT INTO noaE_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Magbaawai jũrr Felipeeu ich Jesuug, —Señor, magan marag maach daúachata pʉch Aai oopibá, mag oobaawai marau khaphʉ nʉisijugui ajim, i jãga sĩerrʉ́. ");
INSERT INTO noaE_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Magbaawaita Jesuu irig, —Nawe pãar dʉ̈i mʉ ich mag chitaajemta, ¿agtha pãrau mʉ khaugbata nʉwi? ajim. Chi mʉ oojemuan ya mʉ Aaijã oowia sĩebahab. Mag nʉmta ¿khan atchata warag mʉch Aaipata pãachig oopim khõchkha nʉma? ajim maach thumaam khʉʉnagta. ");
INSERT INTO noaE_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Magnaa chi Felipeeg, ¿Pua ʉ̈khabata sĩ ajim, mua mag mʉ mʉch Aai dʉ̈i chiraawai mʉ Aaijã mʉ dʉ̈i sim a chirʉm? Maguata mua nem jaau chitʉm chan sĩi mʉch ipaita jaau chitʉm khabam. Mua nem wau chitʉmjã mʉchdëuta mag wau chitʉm aju khabam; ajapcharan ich mʉ Aai mag mʉ dʉ̈i sĩejemuata waaujemgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Magnaa deeu maach thumaam khʉʉnag, Chadcharau keena; mʉ chadcha mʉch Aai dʉ̈i chirʉm, maagwai ich mʉ Aaijã mʉ dʉ̈ita simgui ajim. Mua mag jaau chirʉm pãrau ʉ̈khamapha nʉm khai, sĩi mua nem wau chirʉm gaaimua khãijã chadcha Ẽwandam mʉ dʉ̈i sim abat ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Pãadë mʉ iek ũrbat: Chadcha chi mʉ iekta ʉ̈kha simuan mua nem wau chirʉmjö waunaa ag khãai ʉ̈rʉʉchajã waumajugui ajim, mʉch Aai aar pawia mammuajã mua mʉch juapá deeju aawai. ");
INSERT INTO noaE_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pãar chadcha mʉch dënkha naawai pãrau pãachdëu nem khõsim thum mʉ Ayagta mʉ iek gaai thʉwiata jëeumʉn, mua pãar dʉ̈i mag pãachdëu jëeu nʉmjö ajugui ajim, mʉchdëu pãar dʉ̈i mag chirʉm gaaimua ich mʉ Aaita chi jua thierriu a khap amkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mag pãar chadcha mʉ dënkha naawai pãrau mʉ Ayagta nem jëeu nʉmʉn, muajã chadcha jerrba mag pãachdëu jëeu nʉmjö ajugui ajim pãar dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mag iekhakhagmamua ĩchab marag, ’Pãrau chadcha mʉ daupii nʉm khai, mua pãachig nem jaautarr thum ipierraa abat ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pãrau magmʉn, mʉch Aai aar paawai mua irig pãar athee dewam mʉch jũrr pʉ̈ipi jaaujugui ajim, pãar dʉ̈i ogdʉba ich mag pãar khĩir jãsenkha wai nʉrramkhĩir. Ma ich Ẽwandam Akharaugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Magbaawai irua ich Akhaar pʉ̈iju. Pari ma, mʉg jẽb gaai sĩi parhoobam khʉʉnau pöd aubajugui ajim, amau i oojã oobanaa khaugjã khaugba naawai. Mag amau i khaugba nʉm ee, ichdëun pãrag ich khaugpinaa chadam iekjã khaphʉ apijugui ajim, ichta pãar thãar ee sĩenaa mʉg atagjã ich mag pãar dʉ̈i sĩerraju aawai. ");
INSERT INTO noaE_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mag iekhakhagmamua, ’Wouchnaanjö chan mua pãar dau aphʉʉ phëpʉabamgui ajim. Mawiajã mʉʉn ũwaai deeu pãar dʉ̈i chiraichëjugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nau mʉigmua jöpcha pöm khaba nʉm ee, mʉg jẽb gaai mʉ iek ʉ̈khaba nʉm khʉʉnau tag mʉ oobaju. Pari mag amau mʉ ooba awiajã pãar dʉ̈in deeu maach oojugui ajim. Mag deeu maach oobaawaita pãrau khaphʉ ajugui ajim, pãachjã mʉchjö ich mag iiu wënʉrraju. ");
INSERT INTO noaE_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mag mʉ iiubarm edta chadcha mʉ mʉch Aai gaaita chirʉm pãrau wajapcha khaphʉ nʉisiju. Ich mag edta ĩchab pãrau khaphʉ nʉisijugui ajim, pãachjã mʉ dʉ̈i naawai mʉchjã jũrr pãar dʉ̈i chitaju. ");
INSERT INTO noaE_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Chi mua nem jaautarr ũrnaa mʉ ipierraa simuan magan chadcha mʉ daupii sim a sim. Mag chi mʉ daupii simʉn, ĩchab mʉ Ayaujã i daupii ajugui ajim. Mag mʉ Ayau i daupii abaawai mʉchdëujã i khõsinaa warag mʉch khĩirjugchata khap apijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Magbaawaita Judaau (chi Iscarioteeu khaba mamʉ) irig, —Señor, ¿jãga mag maragpaita pua pʉch khaugpijuma ajim, pʉch iek ʉ̈khaba nʉm khʉʉnagpa pʉch khaugpiba? ");
INSERT INTO noaE_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Magbaawai Jesuu irig, —Chi mʉ daupii simuata mʉ ipierraa nem wauju aawaima ajim; maagwai iita mʉ Ayaujã ĩchab daupii abajup ajim. Mag maata mʉ Ayaujã daupii wai sĩewai maach numiita i dʉ̈i ãba i thãar ee jooba wënʉrrajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mamʉ chi mʉ ipierraata nem wauba sim chan mʉ khõchkhaba aawaiugui ajim. Magnaa, Cha pãrau mʉ iekha chirʉm ũr nʉm chan mʉch iekpai khaba, jãan mʉch pʉ̈itarrau iek jaaupitarr iekhaugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Pãar dʉ̈i agtha chirʉwe ya mua pãrag thumaa jaaubarm. ");
INSERT INTO noaE_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pari mʉ jũrr mʉ Ayau ich Akhaar pãar khĩir jãsenkhamkhĩir pʉ̈ibaawai maguata jũrr pãrag nem thumaa jaaunaa mua pãachig jaaujerrjã deeu thumaa pãrag khĩir eyaa apijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mag iekhamamua, ’Mʉchjã onee chiraawai mʉch petaawai pãarjã mua oneenaa khõinaata phëpʉajugui ajim. Mag pãar oneenaa khõinaa nʉisim chan sĩi mʉg jẽb gayamjö khũchpai khaba, ich mag nʉisim iekhau ajim. Mag mʉ mam a chirʉm ũrwia oob ökhĩirjuu amiet, ni nem ökhöjã amiet ajim marag. ");
INSERT INTO noaE_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Pãrau mʉ iek ũrjierramgui ajim, mʉ mʉch Aai aar mawia deeu pãach aig bëeju a chirʉm, pãar dʉ̈i chitaag. Pãrau chadcha mʉ khõsi nʉm akhiin, mag mʉ mam a chirʉm ũrwiajã pãar onee naakhamgui ajim, mʉch Aai mʉch khãaijã ʉ̈rpai sim dʉ̈ita chiraimaawai mʉch Aai dʉ̈i ãba mʉchpata õrau thö iekhaju aawai. ");
INSERT INTO noaE_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ĩswe ag nawe ya pãrag jaau chirʉmgui ajim, eeupemjö chadcha mag mʉch mawi deeu pierrwaijã mʉchdëu pãachig jaaujerr khĩir eyaanaa ag iek gaaita warag ubʉ ʉ̈kha nʉisimkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mepeerta mag mʉ khãai ʉ̈rpai sĩewai khabam, pari mʉg jẽb gaai ichta chi pörkha sĩerrʉmua ich õor pʉ̈iwia mʉ pʉr awaan wëdurum aawai ya pömcha pãar khĩir chitabajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pari ichiita ich mag ʉdʉraa mʉch thõopiju aai chirʉmgui ajim, mʉch iek ʉ̈kha nʉm khʉʉnau mua chadcha mʉch Aai khõsi chitaawai ichdëu mʉchig jaautarrpierrta wau chitʉm khap amkhĩir. Mag iekhapʉ̈iwia warag, —Maachta mʉigmua wëttarraugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Mamʉ mag wëttarrau atarrta warag iyʉ̈ʉ nʉmua magjim Jesuu, ichpai igwia: —Mʉʉta chi uva kharau, maagwai mʉ Aai chi jĩirjem anaa chi jaarjemʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pãar sĩi mʉ khãu nenergau. Wajapcharan pãran mʉ Ayau khõsi simjö nem wawaagta mʉ dënkha nʉmgui ajim. Pari mag mʉ khãu nenergkha nʉmta khãu ãb khãijã pöd jopba simʉn, mʉ Ayau warag thʉapnaa barpʉ̈iju. Pari ʉ̈uta chëwia jop simʉn, warag wajaphata irua jar khëkhër ajugui ajim, warag chëmkhĩir. ");
INSERT INTO noaE_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pãran ya nemjĩir arg ee nʉmjöta nʉmgui ajim, mua pãachig nem jaautarr thum ipierraa ʉ̈kha nʉm gaaimua. ");
INSERT INTO noaE_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mag pãachta mʉ khãu nenergkha naawai oob mʉ ogdʉmiet ajim. Jãg chi khãu chaar gaaimua thʉadʉbaadeewai chi neer ich appai pöd chëba warag phuajemjö, pãarjã ich agjö mʉ dʉ̈ita khapeer khaba nʉm chan, pöd Ẽwandam athee nem wajapha waubamgui ajim. Magua mʉ dʉ̈ita ich jãg ogdʉba nʉisit ajim, mʉch garmuajã jãg pãar ogdʉba chitaajemjö. ");
INSERT INTO noaE_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mag iekhamamua deeu ichdëu jaautarrjö, ’Mʉʉta chi uva khaar charaugui ajim, ich igwia. Maagwai pãar sĩi mʉ khãu nenergau. Chi mʉ dʉ̈ita ogdʉba simʉn chadcha Ẽwandam athee nem wajapham pöoma waujugui ajim, mʉch garmuajã i ogdʉba chiraawai. Mʉ gaaimua khabam chan bʉ̈ʉrjã pãrau pöd nem wajapham waubajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Chi mʉ dʉ̈i narr khʉʉnta amach garmua mʉ kha ogdʉ nʉm khʉʉnan warag uva khãu bʉ̈ʉrjã chëba aajemjö isegpʉ̈ijugui ajim, mʉ gaaita khaar khaba naawai. Magʉm khʉʉnan mʉ Ayau oowaijã, chi khãu thʉrrptarr phuabaadeewai örpäaijemjöta nʉmgui ajim, i athee nem wauba sĩi parta naawai. ");
INSERT INTO noaE_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Pãrau mʉ kha ogdʉba mua pãachig jaautarr ipierraata wënʉrrʉmʉn, pãachdëu nem waupim khõsimta mʉrʉg jaaubat, magbaa mua waub khaba waujugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ar pãrau mʉ Ayau nem waupim khõsi simjöta wajapha nem waauwain pãrau warag i thʉ̈rphöota api nʉmgui ajim. Pãach mag nʉm gaaimua õrau khaphʉ aju, pãar chadcha mʉ khapeenkha nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ich jãg mʉ Ayaujã mʉch khõsi wai sĩejemjö, muajã pãar khõsi chitʉm. Ich jãg pãach nʉmjöta nʉisit ajim, mua ich jãg pãar khõsi chitaag. ");
INSERT INTO noaE_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ich jãg mʉjã mʉch Ayau jaautarr ipierraa chitʉm gaaimua mʉ Ayau mʉch khõsi wai sĩejemjö, pãraujã mua pãachig jaautarr ipierraata wënʉrrʉmʉn, pãrau khaphʉ ajugui ajim, chadcha mua pãach khõsi chirʉm. ");
INSERT INTO noaE_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Mua pãrag mag iekha chirʉmʉn, mʉch onee chirʉmjö pãachjã warag wajapcha onee amkhĩraugui ajim. Pãar mag mʉjöta onee nʉmʉn magan mʉg eegarm oneg khaba, oneg chaarta wai nʉisim. ");
INSERT INTO noaE_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mua pãrag jaau pʉa chirʉmʉn, mʉchdëujã ich jãg pãar daupii chirʉmjö pãach eepaijã jũrr agdaujö chikhamnaan daupii abat a chirʉmʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maadëu dich khapeen athee nem waauwai amag khaphʉ apiejem, chadcha maadëu am khõsi nʉm; pari mag nem wau nʉm khãai ʉ̈rpai simʉn, am kõitjã ʉdʉraa dich thõopi chirʉmta chadcha am daupii chirʉm anʉmʉugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pãrau mua nem jaau chirʉmta ipierraa amʉn, magan pãarta mʉ khapeenaugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","’Sĩi chikham chogkha nʉm khʉʉnau chan amach patronnaanau nem wau nʉmjã khaugba aajeewai ya mua tag pãar sĩi mʉch chognaan gaai thʉ̈rbam. Mag thʉ̈rju khãai sĩi mua mʉch khapeen ata thʉ̈rjugui ajim, ya mʉch Ayau jaaupitarrjã thumaa meerba pãrag jaau wai chiraawai. ");
INSERT INTO noaE_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Warrjã pãrau pãach garmuata pãach Pörkhamkhĩir mʉ jʉr auba mʉch garmuata pãar jʉr autarr aawai, mua pãar pʉ̈i chirʉmgui ajim, wëtwia õrag mʉ iek aaidʉ jaaumamua õor mʉch igar paa aumamkhĩir. Pãrau magmʉn, magan mʉ iek gaai thʉwia mʉ Ayag nem jëeuwaijã thum irua deeb khaba deejugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Deeu mua pãrag, agdaujö jũrr dich khapeen daupii abat a chirʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Ar mʉ iek ʉ̈khab nʉm khʉʉnau pãach oomapha aawai khĩir eyaa abat ajim: pãar oomapha aju nawe mʉʉta amau nacha oomapha ajierram. ");
INSERT INTO noaE_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pãraujã am dënjö mʉ iek ʉ̈khaba nʉm akhiin, amau pãar daupii akham, amach igar nʉm khʉʉn dʉ̈i aajemjö. Pari pãar am eemua mua mʉch athee jʉr autarr aawai amau pãar oomapha nʉmgui ajim, ya pãar amach dʉ̈i khaba naawai. ");
INSERT INTO noaE_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","¿Chaig mua jaau chirarr pãrau khĩir eyaa khaba nʉ? Sĩi chikham chogkha nʉm khʉʉn amach patronnaan khãai ʉ̈rpai khaba aajem. Magua, amau mʉ dʉ̈i khaigba aajerr aawai pãarjã ich agjö amau khaibag waujugui ajim. Maagwai ich jãg mua jaau chitʉm iek ãaur khʉʉnau ʉ̈khatarr aawai pãar iekjã agjö amau ʉ̈khajugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amau mag amachdëu am aig pãar khaibag wauju a chirʉmʉn, pãach mʉ dʉ̈i khapeerkha nʉm gaaimuata pãar dʉ̈i amau magju. Pari mag nʉmʉn, mʉ pʉ̈itarr Ẽwandam amachdëu khaugbam gaaimuata pãar dʉ̈i amau magjugui ajim marag. ");
INSERT INTO noaE_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Mʉ bëebanaa mua amag bʉ̈ʉrjã mʉʉta Ẽwandam Iewaau anaa am peerdʉ aujujã jaauchëbamuan, amachdëu mʉ isegtarr gaaimua Ẽwandam dʉ̈i am iekkhõr chukhu naakhamgui ajim. Pari mua amag mʉch meerba jaautarrta amau mʉ isegtarr aawai ãbmuajã khaugba aawaita mʉ iek ʉ̈khabajim aju khaba simgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pari amau khaugba nʉmgui ajim, mʉ oomapha nʉm aig ĩchab ich mʉ Aaipata amachdëu oomapha nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Õrau ag na wauba aajem nempa mua am dakhĩir waujimgui ajim, magʉm gaaimua khãijã ʉ̈khamkhĩir. Mua mag wauba arr akhiin, amachdëu mʉ isegtarr gaaimua chadcha am Ẽwandam dʉ̈i iekkhõr chukhu naakham. Pari ya amach daúacha mag ootarrjã ʉ̈khabanaa warag mʉ oomap nʉm aig, ich chi mʉ pʉ̈itarrpata oomapha nʉmgui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pari juaujö amau mag nʉmʉn, amachdëu wajapha ʉʉrkhaajem iek gaai phã simjö, “Bʉ̈ʉrjã iekkhõr chukhum paarta mʉ oomap ajurau” a simjö, chadcha ich ag ee öbërmkhĩrau a jaaumajim ich Jesuu marag. ");
INSERT INTO noaE_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","27","’Pari õrau mag pãar oomapha nʉm ee, mʉchdëu jaau chirarrjö, mʉch ipaarmua mʉch Ayag ich Akhaar pʉ̈ipi jaaujugui ajim, pãar khĩir jãsenkhamkhĩir. Mag pierrwain chadau ichta mʉ destigkhajugui ajim, ichdëuta pãrau õrag chadam iek jaaupimamua ĩchab mʉjã jãga chitʉ́ a khaugpimaju aawai. Pari wajapcharan pãachjã mʉ destignaanaugui ajim, mua warrcha mʉch Aai iek jaaubaaderr aigmua pãachta mʉ dʉ̈i ogdʉba wënʉrraawai. ");
INSERT INTO noaE_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Mua pãrag ag nawe mag õrau pãar oomapha aju a chirʉmʉn, ya pãach dʉ̈i chadcha magphöbaadeewaijã mua pãachig jaaujerrta khĩir eyaanaa warag ubʉ nʉisimkhĩrau ajim. ");
INSERT INTO noaE_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ya amauta pãar dʉ̈i magphöbaadëmʉn, pãran amau amach eemua jʉr wërppʉ̈iwia amach culto waaujem eejã tag dubpibajugui ajim. Mamag nʉʉ awia juauchajã pãar khëchmaju. Mag pãar khëch nʉm khʉʉnau amachdëupain Ẽwandamau pãar dʉ̈i magpi sĩewaita mag nʉm ajurau. ");
INSERT INTO noaE_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mag amau pãar dau aug wau nʉmʉn, agtha bʉ̈ʉrjã mʉ Aai khaugba ni mʉjã khaugba aawaiu. ");
INSERT INTO noaE_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ya mua pãrag ag nawe mag jaau chirʉmʉn, ya chadcha pãach mag am jua ee dau aphʉʉ aadeewaijã mua pãachig amau pãach dʉ̈i magju a jaaujerr khap amkhĩraugui ajim. ’Mag mʉch gaaimua pãar dau aphʉʉ ajujã warrcha mʉch khapeenkha awaag pãar thʉ̈rkha aauwaiwe mua chadcha pãrag jaaubajimgui ajim, agtha pãar dʉ̈i amau magju wají narr aawai; mag nʉm dʉ̈i ĩchab mʉchcha pãar dʉ̈i chitaawai. ");
INSERT INTO noaE_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pari ĩs ya mʉch chirarr aar mʉch pʉ̈itarr dʉ̈i ãba chiraan mam aawai warre pãrag jaau chirʉmgui ajim. Pari mag mʉ mam a chirʉm ũrwia oneenaa ni ãbmuajã, “¿Jãgata sĩ mag pʉ sĩeimaju durrjã?” aba, ");
INSERT INTO noaE_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","sĩita warag ökhĩirjuu nʉm, pãach appai aphöbaadeewai pãach dau aphʉʉ aju khĩirjuwia. ");
INSERT INTO noaE_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pari mag mʉ maju a chirʉmʉn, chadcha pãach wajapcha amkhĩraugui ajim. Mʉ maba akhiin, Ẽwandam Akhaar mag pãar khĩir jãsenkhajujã bëebaju. Magarrau mʉ petaawain chadau mʉchdëuchata mʉch jũrr mag pãar khĩir jãsenkhajujã pʉ̈ijugui ajim. ");
INSERT INTO noaE_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mag ichcha pierrwain chadau ichdëuta wajapha õrag khaphʉ apijugui ajim, khan gaaimuata Ẽwandam dʉ̈i mag iekkhõr paraa nʉ, khan agá Ẽwandam dau na agpierraa nem wau nʉm, maimua jãga ich Ẽwandamaujã ichdëu khap aju ich iek ʉ̈khaba nʉm khʉʉn dʉ̈i. ");
INSERT INTO noaE_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ichdëuta amag khaug aupijugui ajim, amachdëu mʉ iek ʉ̈khaba nʉm gaaimua mag Ẽwandam dʉ̈i iekkhõr paraa nʉm. ");
INSERT INTO noaE_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ichdëuta amag khĩirjupi aujugui ajim, chadcha mʉchjã agpierraa Ẽwandam dau na nem wau chitarr gaaimua ũwaai mʉch Aai aar chiraimam. Mag mʉ mam pabaadeewai pãrau tag mʉ ooba