﻿USE sofia;
DROP TABLE IF EXISTS sofia.nnw_vpl;
CREATE TABLE nnw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nnw_vpl WRITE;
INSERT INTO nnw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nə̀ń, Zwezi-*Kərisə dwíí tə dəkuu nə yɩ nətʋ: Zwezi-Kərisə yɩ pɩ̀ʋ́ *Davidə nàʋ́, Davidə yɩ *Abərahamə nàʋ́. ");
INSERT INTO nnw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abərahamə lʋrɩ *Yɩzakə, Yɩzakə lʋrɩ *Zwakɔbə, Zwakɔbə lʋrɩ Zwida də ʋ nubɩa. ");
INSERT INTO nnw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zwida də ʋ kan Tamarə lʋrɩ Pere də Zera. Pere lʋrɩ Esəron. Esəron ma lʋrɩ Aramə. ");
INSERT INTO nnw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramə ma lʋrɩ Amɩnadabə. Amɩnadabə lʋrɩ Nasʋn. Nasʋn lʋrɩ Saləma. ");
INSERT INTO nnw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saləma də ʋ kan Rahabə lʋrɩ Bozə. Bozə də ʋ kan Rutə ma lʋrɩ Ɔbɛdə. ");
INSERT INTO nnw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ɔbɛdə lʋrɩ Yɩzayi. Yɩzayi lʋrɩ Davidə. Pɩ̀ʋ́ Davidə də Yiri kan tə ma lʋrɩ Salʋmʋn. ");
INSERT INTO nnw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salʋmʋn lʋrɩ Rʋbʋamə. Rʋbʋamə lʋrɩ Abɩa. Abɩa lʋrɩ Aza. ");
INSERT INTO nnw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza lʋrɩ Zwʋzafatə. Zwʋzafatə ma lʋrɩ Yoramə. Yoramə lʋrɩ Ɔzɩasə. ");
INSERT INTO nnw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ɔzɩasə ma lʋrɩ Yotamə. Yotamə ma lʋrɩ Ahazə. Ahazə lʋrɩ Ezekɩasə. ");
INSERT INTO nnw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekɩasə lʋrɩ Manase. Manase ma lʋrɩ Amʋn. Amʋn lʋrɩ Zwʋzɩasə. ");
INSERT INTO nnw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zwʋzɩasə ma lʋrɩ Yekʋnɩa, də ʋ nubɩa tə Yɩzərayɛlə lɩ̀à tə ka pɛ̀e ka ja va *Babɩlɔnə máŋá tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ba Babɩlɔnə vəli kwa nə, Yekʋnɩa lʋrɩ Swɩalətɩɛlə. Swɩalətɩɛlə ma lʋrɩ Zʋrʋbabɛlə. ");
INSERT INTO nnw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zʋrʋbabɛlə lʋrɩ Abiudə. Abiudə ma lʋrɩ Elɩakimə. Elɩakimə ma lʋrɩ Azorə. ");
INSERT INTO nnw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorə lʋrɩ Sadokə. Sadokə lʋrɩ Ahimə. Ahimə lʋrɩ Elɩʋdə. ");
INSERT INTO nnw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elɩʋdə ma lʋrɩ Elɩazarə. Elɩazarə lʋrɩ Matanə. Matanə ma lʋrɩ Zwakɔbə. ");
INSERT INTO nnw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zwakɔbə lʋrɩ Zwʋzɛfə Mari barɩ. Mari tə nə lʋrɩ Zwezi, ba nə boŋə Kərisə. ");
INSERT INTO nnw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yɩzərayɛlə lɩ̀à dwíə́ fugə banɩa nə wulə Abərahamə də Davidə pwərə wa, tə fugə banɩa də ga ya Davidə də Yɩzərayɛlə lɩ̀à tə ka pɛ̀e ka ja va Babɩlɔnə pwərə wa, tə fugə banɩa duən də yɩ tə zɩgɩ kʋ mʋ̀ Babɩlɔnə vəli təntə kʋ ja va Kərisə lʋrʋ. ");
INSERT INTO nnw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nə̀ń nətʋ, ba nə lʋrɩ Zwezi-*Kərisə. Ʋ nuu Mari yà yɩ Zwʋzɛfə bwàlʋ́, ʋ nə càrɩ̀, sə ʋ swe. Kʋ twá Yɩɩ-*Siŋu tə dɩ̀àn nə, Mari ma ja pùə́, də ʋ də Zwʋzɛfə tə yə̀rì duən ndə kan də bɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ʋ barɩ Zwʋzɛfə ʋ nə yɩ cɩ́gá tíú, yà ba pɩ̀à, sə ʋ kə cavɩra Mari nə. Kʋ mʋ̀ nə pɩn, ʋ yà pɩ̀à, sə ʋ twá tɩa tɩa ʋ ma yá wa. ");
INSERT INTO nnw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zwʋzɛfə yà nə jə ka pubʋŋa təntə, *Yuu-Tiu *malɩka twi, ka swɩ̀n ʋ con ʋ pandwɩa wa, ka wʋ́: «*Davidə nàʋ́ Zwʋzɛfə, Mari bìú tə pùə́ tə, ʋ nə jə, yɩ ka twi də Yɩɩ-Siŋu tə dɩ̀àn. Kʋ mʋ̀ nə pɩn, dàn ká pa fən ja mʋ́, sə n tì wá ndə n kan nə. ");
INSERT INTO nnw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ʋ wá lʋra bibɛɛ, n ga wá kə ʋ yɩrɩ Zwezi, kʋ mʋ̀ də̀ń nə yɩ ʋ wá jon *Yɩzərayɛlə lɩ̀à ba cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tə mʋ̀ yìə̀n təntə mama twi tə tʋn, sə Yuu-Tiu sʋgʋ tə, ʋ nə twá ʋ nii *sʋ̀sʋ̀nʋ̀ tə nə, ʋ ma swɩ̀n tə nii ma sú. Ʋ swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Nə̀ń, kacɩɩn tə, ʋ nə tə yə̀rì bɛɛ, wá ja pùə́, ʋ wá lʋra bìú, ba ga wá bon wá Emanuwɛlə». (Kʋ mʋ̀ də̀ń nə yɩ: ‹Yɩɩ wulə də nəba›.) ");
INSERT INTO nnw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zwʋzɛfə nə zàn dwɩan nə, ʋ twá kʋ tə nə, Yuu-Tiu malɩka tə nə swɩ̀n, ʋ ga ja ʋ kan tə ʋ kə ʋ con. ");
INSERT INTO nnw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yá ba dàń nə wà duən yəni ndə kan də bɛɛ nə, kʋ ja va Mari bìú tə, ʋ nə dɩga ʋ yɩrɩ Zwezi tə, lʋrʋ. ");
INSERT INTO nnw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Máŋá tə, ba nə lʋrɩ Zwezi Bɛtələhɛmə nə, kʋ nə wulə Zwide nagwanaa wa, kʋ yɩ pɩ̀ʋ́ *Erodə pàrɩ̀ máŋá wa. Yənu tɩ̀án nan yɩɩ yipɩan con, ba bà *Zwerizalɛmə wa. ");
INSERT INTO nnw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yənu tɩ̀án tə bwe ba wʋ́: «*Zwifə-ba pɩ̀ʋ́ tə, ba nə lʋrɩ tə wa yə̀n? Nə nɩ ʋ kacɩlacɔ yɩɩ yipɩan con, mə nə twi, sə nə pa wá dun». ");
INSERT INTO nnw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pɩ̀ʋ́ Erodə nə nì ŋwɛn təntə, ʋ də Zwerizalɛmə tɩʋ lɩ̀à mama pwìí cʋ̀gʋ̀. ");
INSERT INTO nnw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ʋ ken Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án də Yɩɩ nii *yənu tɩ̀án tə mama duən nə, sə ʋ bwe ba ʋ lwarɩ bwálɩ́ tə, ba nə mɛ, sə ba lʋra *Kərisə. ");
INSERT INTO nnw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ba ma swɩ̀n ʋ con, ba wʋ́: «Kʋ yɩ Bɛtələhɛmə tɩʋ nə, kʋ nə wulə Zwide nagwanaa wa, ndə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə nə pʋ́pʋ́nɩ́ nətʋ tə, ʋ swɩ̀n ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Kʋ mʋ̀ Bɛtələhɛmə təntə, kʋ nə wulə Zwida lʋʋ wa kʋ cɩ́gá jə funə Zwida tɩan təntə wa. Kʋ mʋ̀ wa nə pɩ̀ʋ́ wá nan, sə ʋ yɩ̀rɩ̀ *Yɩzərayɛlə lɩ̀à tə nə yɩ à mʋ̀ Yɩɩ lɩ̀à›.» ");
INSERT INTO nnw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erodə dàń ma twá tɩa tɩa ʋ bon yənu tɩ̀án tə, sə ʋ bwe ba zəni ʋ lwarɩ kacɩlacɔ tə naŋʋ máŋá. ");
INSERT INTO nnw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yá ʋ dàń tʋn ba Bɛtələhɛmə nə, ʋ wʋ́: «Á vələ á bwe á lwarɩ bìsɩ̀ná tə yoo zəni. Á nə nɩ wá, sə á pìí á bà á swɩ̀n à con, sə à də va à pa wá dun». ");
INSERT INTO nnw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ba nə cʋgʋ pɩ̀ʋ́ tə nii ba zwɛ̀e, ba kɛ̀eń ba zʋ cwəŋə. Yá kacɩlacɔ tə, ba nə nɩ yɩɩ yipɩan con tə, wulə ba yáá kʋ vəli. Máŋá tə, kʋ nə yí bìsɩ̀ná tə yipaa bwálɩ́, kʋ cə́n kʋ zɩgɩ. ");
INSERT INTO nnw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ba nə nɩ kacɩlacɔ tə, ba pwìí poli zənzən. ");
INSERT INTO nnw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba zʋa dìə̀ tə wa, ba ga na bìsɩ̀ná tə də ʋ nuu Mari. Ba tʋa tɩa bìsɩ̀ná tə yáá con, ba pa wá dun. Ba kʋ̀rɩ̀ ba zɩla, ba lɩ wiən tə, tə kwənə nə dáá, ba ma də zìlə́ bìsɩ̀ná tə yuu wa. Ba pɩn wá sɩ́án də tɩralɩ yirə duən, ba nə ma boŋə ‹ansansə› də ‹mirə›. ");
INSERT INTO nnw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kʋ kwa nə, Yɩɩ dàń bɩrɩ ba ba pandwɩa wa, də ba kʋ́ʋ̀ dàn ká twá Erodə con ba ma vìí. Ba dàń ma tì cwəŋə don ba va ba lʋʋ. ");
INSERT INTO nnw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yənu tɩ̀án tə viru kwa nə, *Yuu-Tiu *malɩka nan ka swɩ̀n Zwʋzɛfə con ʋ pandwɩa wa, ka wʋ́: «Zàn, n tì bisɩmaa tə də ʋ nuu, n ja dəri, n va *Ezwipətə lʋʋ wa. Vəli, n ya lá, də n ma dànɩ̀ à kori, *Erodə nə wá pɩ̀à wá, sə ʋ pa ba gʋ tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Zwʋzɛfə zàn tɩtɩn nə, ʋ tì bisɩmaa tə də ʋ nuu ʋ ja va Ezwipətə lʋʋ. ");
INSERT INTO nnw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ʋ yɩn lá kʋ ja va kʋ yí Erodə tɩan, sə kʋ tə Yuu-Tiu nə twá ʋ nii *sʋ̀sʋ̀nʋ̀ tə nə, ʋ ma swɩ̀n tə nii sú. Yɩɩ nii sʋ̀sʋ̀nʋ̀ tə swɩ̀n Zwezi yoo, ʋ wʋ́: «À bon à bìú à lɩ Ezwipətə lʋʋ wa». ");
INSERT INTO nnw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Máŋá tə wa, *Erodə nə twi ʋ bà ʋ lwarɩ də, yənu tɩ̀án tə yɩ ba gɩgarɩ wá, ʋ lɩŋa zàn zənzən. Ʋ dàń tʋn, sə ba gʋ Bɛtələhɛmə də kʋ lʋʋ nii bisɩmabarɩ tə mama, ba nə yí bɩna bələ də ba tə, ba nə tə wà yí. Erodə fwa kʋ nətʋ, ndə ʋ nə nì yənu tɩ̀án tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mə kʋ twá nətʋ, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Zweremi sʋgʋ tə nii ma sú. Ʋ swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ba nì bubwiə Rama tɩʋ wa, kwirə də zɩra. Kʋ yɩ bìsɩ́ná tə nuu Rasɛlə nə kwi ʋ bìsɩ́ná nə, yá ʋ ga ba sɛ̀e, sə ba kòrì wá, ba kʋ́ʋ̀ nə tə̀lə́ lʋʋ wa yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kʋ kwa nə, Erodə tɩga. Yá *Yuu-Tiu *malɩka twi Zwʋzɛfə con ʋ pandwɩa wa *Ezwipətə lʋʋ wa, ka swɩ̀n ʋ con, ka wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Zàn, n tì bisɩmaa tə də ʋ nuu n ja va *Yɩzərayɛlə lʋʋ. Lɩ̀à tə, ba yà nə pɩ̀à, sə ba lɩ bisɩmaa tə mɩɩ tə, ba tɩga». ");
INSERT INTO nnw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zwʋzɛfə ma zàn, ʋ tì bisɩmaa tə də ʋ nuu ʋ ja va Yɩzərayɛlə lʋʋ. ");
INSERT INTO nnw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Fən jɩn wá, sə ʋ jə̀ń Zwide nagwanaa wa, ʋ nə nì də, Arəkelayisə nə jə̀ə́ ʋ nyɩna *Erodə padaʋ tə yuu wa yɩrɩ. Yá Yɩɩ kwè Zwʋzɛfə ʋ pandwɩa wa, də ʋ vəli Galile nagwanaa. ");
INSERT INTO nnw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ʋ vəli ʋ jə̀ń tɩʋ don nə, ba nə boŋə ‹*Nazarɛtə›. Mə kʋ twá nətʋ Yɩɩ nii *sʋ̀sʋ̀nà tə sʋgʋ tə nii ma sú, ba swɩ̀n Zwezi yoo, ba wʋ́: «Ba wá bon wá Nazarɛtə tíú». ");
INSERT INTO nnw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Máŋá don wa, bɛɛ don yɩn lá, ʋ yɩrɩ nə yɩ *Zwan-Batisə. Kʋ bɛɛ təntə twi ʋ nan Zwide kasɔɔ lanworu tə wa, ʋ kàrɩ̀ Yɩɩ yoo, ʋ bɩrɩ lɩ̀à nə. ");
INSERT INTO nnw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ʋ yà swɩ̀n, ʋ wʋ́: «Máŋá bwələ, sə Yɩɩ də́ ʋ pàrɩ̀ tə lɩ̀à mama yuu wa. Kʋ mʋ̀ nə pɩn, á vəvərə á kwa, á ma sá á cʋna!» ");
INSERT INTO nnw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mə Zwan-Batisə yoo nə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi yà swɩ̀n Yɩɩ sagɩ tə wa, ʋ wʋ́: «Kʋ yɩ bɛɛ nə bubwi kasɔɔ lanworu wa, ʋ wʋ́: ‹Á kwɩ̀án *Yuu-Tiu cwəŋə tə, sə á cɛ̀e ʋ cwəmɩnɩ tə, sə tə ya mənə mənə›.» ");
INSERT INTO nnw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zwan yà zʋa nyʋgʋma kʋran gànʋ̀, ʋ ga vwa tànʋ̀ voru ʋ tàŋá nə. Ʋ yà də́ jərən də tʋran. ");
INSERT INTO nnw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kʋ nə zɩgɩ *Zwerizalɛmə, kʋ ja va Zwide nagwanaa, kʋ va kʋ kɩkarɩ Zwurədɛn mʋnaa tə nii mama, lɩ̀à yà twi ʋ con. ");
INSERT INTO nnw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba dàń swɩ̀n ba cʋna tə, ba bɩrɩ Zwan, yá ʋ ga zɩga lá ʋ li ba Zwurədɛn mʋnaa tə wa, kʋ twá də Yɩɩ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Zwan-Batisə nə nɩ *Farɩzɩan-ba də *Sadɩsɩan-ba də, ba nə twi zənzən ʋ con, sə ʋ lə ba də nɩ́á tə wa, ʋ swɩ̀n ba con, ʋ wʋ́: «Á mʋ̀ dəkwaa dwíí-ba! Wàà nə bɩrɩ aba də, á wàá á dəri á jén Yɩɩ lɩŋa tə yáá nə, tə nə bɩ̀àn? ");
INSERT INTO nnw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kʋ nə yɩ nətʋ, sə á twá á tʋtʋnan nə, á ma bɩrɩ də, á vəvəri á kwa á ma sá á cʋna. ");
INSERT INTO nnw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Á jə cɩ́gá, sə á swɩ̀n də, *Abərahamə yɩ á nɩbɛɛ, yá kʋ cɩcɩ tə wà yí. À mʋ̀ nə swɩ̀n kʋ á con də, Yɩɩ wàá kapana tə tə ʋ lwànɩ́, ʋ pɩn tə jì Abərahamə nɩ̀án. ");
INSERT INTO nnw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nə wàá kʋ nətʋ tə nə tì, nə ma maŋa ndə dèrí nə manwarɩ kʋ wulə tɩ̀án dəkurən nə. Tɩ̀ʋ́ tə mama, kʋ bɩa nə ba ywán, ba wá goŋi kʋ, ba kə mən nə. ");
INSERT INTO nnw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","À mʋ̀ li aba nɩ́á wa, sə kʋ ma bɩrɩ də, á wulə á vəvəri á kwa, sə á ma sá á cʋna. Yá lìù don, ʋ dɩ̀àn nə dáá, tə doni nə, wà pú à kwa ʋ bà. À jɩɩn mùrì, sə à tì ʋ nɛɛ natʋra, à ja pú ʋ kwa. Ʋ mʋ̀ nə wá lə aba Yɩɩ-*Siŋu də mən wa. ");
INSERT INTO nnw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ʋ jə ʋ wocəri fɩyaʋ ʋ jɩ̀àn wa, ʋ kwɛn ʋ cə̀rì ʋ wobɩa tə, ʋ pwɛ̀e tə də wopulə tə, ʋ lɩ duən wa. Ʋ pɛ̀e wobɩa tə, ʋ kə ʋ pulu wa, ʋ ga sʋrɩ wosanan tə mən wa, tə nə ba də̀ŋì». ");
INSERT INTO nnw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Zwezi dàń ma nan Galile nagwanaa, ʋ bà *Zwan-Batisə con Zwurədɛn mʋnaa tə nii nə, sə Zwan lə wá nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yá Zwan yà ba pɩ̀à, sə ʋ sɛ̀e, ʋ swɩ̀n, ʋ wʋ́: «À mʋ̀ nə mɛ, sə n lə nə nɩ́á tə wa, mə kʋ nə n mʋ̀ nə pìí n bà à con?» ");
INSERT INTO nnw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Zwezi ma le wá, ʋ wʋ́: «Yá, sə kʋ ya nətʋ sɩ́ʋ́n nə, kʋ nə mɛ, sə nə tʋn won tə mama, kʋ nə ziən kʋ pa Yɩɩ nə yɩrɩ». Zwan dàń ma sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yá máŋá tə, ʋ nə ləgə Zwezi nɩ́á tə wa, ʋ nan ʋ zwɛ̀e, də nə̀ń, lanworu nə kʋ súrí, Zwezi ga na Yɩɩ-*Siŋu tə, kʋ cwi ʋ yuu wa ndə gunpwənə nə. ");
INSERT INTO nnw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yá kori dàń ga nan Yɩɩ sàń nə, kʋ wʋ́: «Ʋ tə yɩ à biswənə tə, ʋ nə poli à pùə́». ");
INSERT INTO nnw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yɩɩ-*Siŋu tə dàń ma ja Zwezi, kʋ ja va kasɔɔ lanworu wa, sə *Sɩtana də́də́n, sə ʋ yigu wá, ʋ pa ʋ tʋn yokʋkwɩʋn. ");
INSERT INTO nnw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ʋ vwə nii dɩan sapwilə, yɩcaʋ də tɩtɩn, yá niən dàń jɩn wá. ");
INSERT INTO nnw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sɩtana ma boli ʋ nii, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Də n nə yɩ Yɩɩ-Biu cɩ́gá mama, sə n pa nii, sə kapana tə tə jì wodiu». ");
INSERT INTO nnw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Zwezi ma le wá, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Kʋ tà wodiu cɩcɩ nə wàá mɩɩ kʋ pɩn lìù nə. Kʋ yɩ sʋgʋ tə də mama, kʋ nə naŋa Yɩɩ nii, nə pɩn mɩɩ lìù nə›.» ");
INSERT INTO nnw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sɩtana dàń ma ja wá, ʋ va tɩʋ tə, kʋ nə yɩ Yɩɩ nyiən tə wa, ʋ tún *Zwifə-ba Yɩɩ *dìə̀ tə yuu wa, ");
INSERT INTO nnw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Kʋ tə, kʋ nə yɩ n yoo, Yɩɩ wá pa nii ʋ *malɩkɛ nə, sə tə tì mʋ́ tə jɩ̀àn wa, n naa dàn ká mà kapan nə›. Kʋ mʋ̀ yɩrɩ nə, n nə yɩ Yɩɩ-Biu cɩ́gá mama, sə n fan n tʋ tɩa». ");
INSERT INTO nnw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zwezi ma le wá, ʋ wʋ́: «Kʋ kʋ́ʋ̀ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹N wà mɛ, sə n də́də́n, sə n yigu n *Yuu-Tiu tə, ʋ nə yɩ Yɩɩ, n pa ʋ tʋn yokʋkwɩʋn›.» ");
INSERT INTO nnw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sɩtana ma kʋ́ʋ̀ ja wá, ʋ dɩ̀ paan nədarʋ nədarʋ yuu wa, ʋ ga pa ʋ ywàń ʋ na lʋʋ pàrɩ̀ də tə zəni tə mama. ");
INSERT INTO nnw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «À wá pa mʋ́ wiən tə tə mama, də n nə tʋa à yáá con, n pa nə dun». ");
INSERT INTO nnw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Zwezi ma le wá, ʋ wʋ́: «Kɛ̀eń lá nə, Sɩtana! Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Pa dun n Yuu-Tiu nə, ʋ nə yɩ n Yɩɩ, sə n dàn ká tʋn won don, də kʋ nə tà kʋ tə cɩcɩ, ʋ nə swə›.» ");
INSERT INTO nnw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sɩtana dàń ma yá Zwezi, malɩkɛ ga fàrʋ́ tə yí Zwezi yɩra, tə tʋŋa tə pɩn wá. ");
INSERT INTO nnw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zwezi twi ʋ nì máŋá don wa də, ba ken Zwan bàń dìə̀ wa. Kʋ mʋ̀ nə pɩn, ʋ zàn ʋ va Galile nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ʋ nan *Nazarɛtə, ʋ va ʋ jə̀ə́ Kapɛrənayimə nə, kʋ nə bwələ Galile mʋnaa tə nii Zabɩlon də Nɛfətali nagwanɛɛ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ʋ tʋn kʋ nətʋ tə, sə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi sʋgʋ tə nii ma sú, ndə ʋ nə swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","«Ba mʋ̀ lɩ̀à təntə, ba yà nə jə̀ə́ yikunu wa Zabɩlon də Nɛfətali nagwanɛɛ tə wa, tə nə wulə mʋnaa tə cwəŋə tə vàn nə, də Zwurədɛn mʋnaa tə kwa con, də ba tə, ba nə wulə Galile nagwanaa tə wa, kʋ nə yɩ lɩ̀à tə, ba nə tà *Zwifə-ba, bwálɩ́, dàń nɩ poni nəfarʋ. Poni nan ba lɩ̀à təntə nə, ba yà nə jə̀ə́ kʋ yikunu lʋʋ nii tə wa, kʋ nə yɩ tɩan bwálɩ́». ");
INSERT INTO nnw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kʋ mʋ̀ máŋá təntə wa nə, Zwezi zàn ʋ wulə ʋ kàrɩ̀, ʋ wʋ́: «Máŋá bwələ, sə Yɩɩ də́ ʋ pàrɩ̀ tə lɩ̀à mama yuu wa. Kʋ mʋ̀ nə pɩn, á vəvərə á kwa, á ma sá á cʋna!» ");
INSERT INTO nnw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zwezi nə wulə Galile mʋnaa tə nii nə, ʋ vəli, ʋ nɩ nubɩa bələ, ba nə yɩ fəlijana. Kʋ mʋ̀ nə yɩ Simon tə, ba nə boŋə Piyɛrə, də ʋ nubiu Andəre. Ba dàń yà wulə ba dɩlɩ ba fələ gə̀gə̀lù mʋnaa tə wa, ba ma janɩ fələ. ");
INSERT INTO nnw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Á bɩ̀àn á twá à nə, à dàń wá pa, á pɩ̀à lɩ̀à, sə ba twá à mʋ̀ Zwezi nə». ");
INSERT INTO nnw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lala də ba dʋgʋ ba fələ gə̀gə̀lə̀n tə lá, ba ga twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ʋ kɛ̀eń lá, ʋ va yáá mancɩn, də ʋ na lɩ̀à bələ duən də, ba nə yɩ nubɩa. Kʋ mʋ̀ nə yɩ Zwakə də Zwan, ba nə yɩ Zebede bɩa. Ba də ba nyɩna Zebede yà wulə nɩ́á yuu bori wa, ba kwɛn ba fələ gə̀gə̀lə̀n. Zwezi ma bon ba. ");
INSERT INTO nnw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lala də, ba də kʋ́ʋ̀ yá ba nɩ́á yuu bori tə də ba nyɩna tə, ba ga twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kʋ kwa nə, Zwezi jiru Galile nagwanaa tə mama wa, ʋ ma kàrɩ̀ *Zwifə-ba *jə́rə́ dii tə wa. Ʋ dàń swɩ̀n sʋywáŋʋ́ tə, ʋ bɩrɩ də, Yɩɩ wá də́ ʋ pàrɩ̀ tə lɩ̀à mama yuu wa. Yá ʋ ga zwɛ̀e yayɩran mama, ʋ ga pɩn yazurə ba tə nə, ba nandaran nə wà ce. ");
INSERT INTO nnw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ʋ yɩrɩ nan Siri lʋʋ nii tə mama wa. Ba dàń ga ja lɩ̀à tə mama, ba nə də́ càn, ba twi ʋ con. Kʋ mʋ̀ nə yɩ lɩ̀à tə, yayɩran yiri mama nə jə, də lɩ̀à tə, *zinə nə jə, də ba tə, ba nə twɩ kwaran, də gwanɩ. Zwezi dàń ga zwɛ̀e ba mama yayɩran tə. ");
INSERT INTO nnw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lalʋʋ nan Galile nagwanaa wa, də Tɩan Fugə nagwanaa tə wa, də Zwide nagwanaa wa, də *Zwerizalɛmə wa, də Zwurədɛn mʋnaa tə vàn don nə, kʋ bà, kʋ twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kʋ máŋá tə wa, Zwezi nɩ lalʋʋ. Ʋ dàń ma dɩ̀ ʋ jə̀ə́ paan yuu wa. Ʋ karbɩa tə fàrʋ́ ba yí ʋ yɩra. ");
INSERT INTO nnw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yá ʋ dàń wulə ʋ twá yìə̀n tə tə nə, ʋ ma kàrɩ̀ ba. ");
INSERT INTO nnw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Zwezi swɩ̀n, ʋ wʋ́: «Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə yə̀ə́ də, ba yɩ zʋra Yɩɩ yáá con, Yɩɩ pàrɩ̀ tə nə yɩ ba mʋ̀ nyiən yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə yɩ pucʋnɩ lɩ̀à, Yɩɩ nə wá zùrì ba bɩcanɩ yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə yɩ pubwanʋ tɩ̀án, ba nə wá tɩnɩ lʋʋ yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ka tʋn Yɩɩ fɩra nə yɩ ndə wodiu nə, kʋ niən nə jə ba, kʋ ga yɩ ndə nɩ́á nə, kʋ nanyʋnɩ nə jə ba, ba mʋ̀ lɩ̀à təntə yɩra nə wá zùrì yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə dəri ləzwənə yinəgə zənzən, Yɩɩ nə wá dəri ba də yinəgə zənzən yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə yɩ bɩcapon lɩ̀à, ba nə wá na Yɩɩ də ba yɩ́á yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə pɩ̀à, sə nimarʋ ya lá, Yɩɩ nə wá ja ba ʋ bon ʋ bɩa yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə twá Yɩɩ cɩ́gá tə nə, kʋ pa ba də́ càn, Yɩɩ pàrɩ̀ tə nə yɩ ba mʋ̀ nyiən yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Á yana pupwən wa, máŋá tə wa, ba nə twɩn aba, ba nə ken aba càn wa, ba nə swɩ̀n kʋnkʋn yolwan yiri mama, ba pɩn aba, à mʋ̀ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Á pɩan á sú də pupwən, á ŋwɩ́rán nə dáá, tə dànɩ̀ aba Yɩɩ con yɩrɩ. Yɩɩ nii *sʋ̀sʋ̀nà tə, ba nə yɩn á yáá, mə nətʋ nə ba ken ba càn wa». ");
INSERT INTO nnw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á yɩ ndə nakwan nə lʋʋ wa, sə kʋ ma ya ywánɩ́. Yá nakwan nyaŋa nə nan, bɛ̀eɛ̀e nə ba kʋ́ʋ̀ wá fwa, sə ka ma ja nii? Ka kʋ́ʋ̀ ba funə jə, də kʋ nə tà, ba wá dɩlɩ ka kàrá wa, sə lɩ̀à nɩŋɩ ba kɛ̀eń». ");
INSERT INTO nnw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á yɩ ndə poni nə lʋʋ wa. Ba nə lwə̀ tɩʋ paan yuu wa, kʋ tɩʋ tə wàrɩ̀ kʋ sə̀gə̀. ");
INSERT INTO nnw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ba bá sʋrʋ cànʋ́, ba tì, ba sə̀gə̀ cənbo də̀ń. Kʋ yɩ ba yàá tì kʋ ba zɩgɩ canzɩlʋ yuu, sə kʋ poni pɩ̀rʋ̀ ba tə mama, ba nə wulə dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mə nətʋ nə á poni tə mɛ, sə kʋ pəpəli ləzoni yáá con. Kʋ mɛ, sə ba na á zəni tə, á nə fwa, sə ba ma pa dun á nyɩna Yɩɩ tə nə, ʋ nə wulə Yɩɩ *sàń nə». ");
INSERT INTO nnw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á dànà ká bʋ́n də, à yɩ à twi, sə à pa Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə tə, də Yɩɩ nii *sʋ̀sʋ̀nà tə kàrà tə jén. Kʋ tà à twi, sə à pa tə jén, kʋ yɩ à twi, sə à pa tə cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Máŋá tə mama, lanworu də tɩa tə mɛ nə wá yà lá, Yɩɩ nii tə, ʋ nə pɩn Moyizə nə, tə wa yobiə də tətə wàrɩ̀ ka lɩ, halɩ ka nə swə ka yɩ nəmənbiə nətʋ mama, kʋ ja vələ tə nii ka sú. ");
INSERT INTO nnw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kʋ mʋ̀ nə pɩn, lìù tə mama, ʋ nə pɩn Yɩɩ nii təntə wa yobiə də tətə jén, ʋ ga kwè lɩ̀à duən, sə ba fwa ndə ʋ nə, ʋ mʋ̀ lìù təntə wá jì talɩkwa lìù Yɩɩ *sàń nə. Yá lìù tə, ʋ nə twá tə nii nə, ʋ ga swɩ̀n, sə ba sɛ̀e tə nii, kʋ tíú tə wá yà ləzwənfarʋ Yɩɩ sàń nə. ");
INSERT INTO nnw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kʋ mʋ̀ nə pɩn, á nə ba Yɩɩ cɩ́gá tə nə twá, á doni *Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə də *Farɩzɩan-ba, á bá zʋ Yɩɩ pàrɩ̀ tə wa, abada». ");
INSERT INTO nnw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nì də, ba swɩ̀n nɩbara-ba tə con nə, ba wʋ́: ‹N wà mɛ, sə n gʋ lìù. Lìù tə, ʋ nə gʋa lìù, kʋ mɛ, sə ba bʋ̀rɩ̀ ʋ bʋ̀rà, sə ba cʋ̀gʋ̀ wá.› ");
INSERT INTO nnw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yá à mʋ̀ swɩ̀n kʋ á con: Lìù mama lɩŋa nə zàn ʋ nubiu yuu wa, kʋ mɛ, sə ba bʋ̀rɩ̀ ʋ bʋ̀rà, sə ba cʋ̀gʋ̀ wá. Də lìù nə twɩn ʋ don, ʋ wʋ́: ‹N yɩ lakʋkwɩʋn›, ʋ mɛ, sə ba bʋ̀rɩ̀ ʋ bʋ̀rà *Zwifə-ba yun tɩ̀án, ba nə bʋ̀rɩ̀ *bʋ̀rà tə, yáá con. Də lìù nə wʋ́ ʋ don ‹yuu tə̀lə́›, ʋ mɛ, sə ʋ va mən dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mə kʋ mʋ̀ nə pɩn, n nə pɩ̀à, sə n fwa n *joŋi Zwifə-ba Yɩɩ *dìə̀ wa, n ga bʋ́n də, n nubiu zɩga n nə, ");
INSERT INTO nnw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","n mɛ, sə n yá n joŋi tə Yɩɩ dìə̀ tə wa, n ga va n də n nubiu tə kə duən nə. Kʋ kwa nə, n dàń wàá n twi, n fwa n joŋi tə. ");
INSERT INTO nnw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kə cɩ́gá, sə n mʋ̀ də n jarɩ don kə duən yuu, máŋá tə wa, á nə wulə cwəŋə wa, á ma vəli lɩ̀à tə nə bʋ̀rɩ̀ bʋ̀rà yáá con, sə ʋ dàn ká kə mʋ́ ba jɩ̀àn wa. Kʋ dàn ká yà talɩkwa kʋ pa mʋ́, də ba nə wá kə mʋ́ bàń dìə̀ nəcɩra jɩ̀àn wa, sə ba kə mʋ́ bàń dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: N bá nan ka bàń dìə̀ təntə wa, də nə wà kʋ jɩŋɩ təntə talɩkwa darɩsɩ mama ŋwɩ́n n zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nì də, ba swɩ̀n, ba wʋ́: ‹N wà mɛ, sə n cwàrɩ̀›. ");
INSERT INTO nnw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yá à mʋ̀ swɩ̀n kʋ á con nə də: Bɛɛ mama nə wá ywàń kan, ʋ fɩra ga zʋ wá, ʋ mʋ̀ bɛɛ təntə dí yáá ʋ cwàrɩ̀ də kʋ kan tə ʋ waa con. ");
INSERT INTO nnw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kʋ nə yɩ, kʋ wá twá n jɩzən yii nə, n ma tʋn cʋna, kʋ mɛ, sə n vuru kʋ n dʋgʋ yɩŋʋnɩ də mʋ́. Kʋ kʋkwa kʋ pa mʋ́, də n nə zʋa Yɩɩ *sàń tə wa də yii nədʋ, kʋ doni də, n nə zʋa mən dìə̀ də n yɩra tə mama. ");
INSERT INTO nnw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Də kʋ nə kʋ́ʋ̀ wá twá n jɩzən nə, sə n ma tʋn cʋna, sə n gwəŋə kʋ n dʋgʋ yɩŋʋnɩ də mʋ́. Kʋ kʋkwa kʋ pa mʋ́, də n nə zʋa Yɩɩ sàń tə wa də jɩkuku kʋ doni də, n nə zʋa mən dìə̀ də n yɩra tə mama». ");
INSERT INTO nnw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Kʋ tə swɩ̀n, kʋ súrí lá: ‹Lìù tə, ʋ nə dʋgʋ ʋ kan, ʋ mɛ, sə ʋ pa wá ʋ dʋgʋ tə sagɩ.› ");
INSERT INTO nnw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yá à mʋ̀ dàń swɩ̀n kʋ á con: Bɛɛ tə, ʋ nə dʋgʋ ʋ kan, kʋ ga tà ʋ cwàrɩ̀, kʋ pɩn cwəŋə, sə kan tə fwa kacwan, də ʋ nə swe bɛɛ don nə. Yá lìù tə, ʋ nə tì kan, bɛɛ don nə dʋgʋ, ʋ də tətə cwàrɩ̀ də kʋ kan tə». ");
INSERT INTO nnw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nì də, ba swɩ̀n nɩbara-ba tə con nə, ba wʋ́: ‹N wà mɛ, sə n dù də won tə, n nə yə̀ə́ də, n bá fwa. Də n nə duə, n wà mɛ, sə n kwɩ̀án n nii *Yuu-Tiu yáá con.› ");
INSERT INTO nnw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yá à mʋ̀ dàń swɩ̀n á con də, á wà mɛ, sə á dù. Á dànà ká tì lanworu tə á ma dù, kʋ nə yɩ Yɩɩ padaʋ tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Á dànà ká tì tɩa tə á ma dù, kʋ nə yɩ Yɩɩ nə tuŋə ʋ nɛɛ lá yɩrɩ. Á dànà ká tì *Zwerizalɛmə yɩrɩ á ma dù, kʋ mʋ̀ nə nə yɩ pɩ̀ʋ́ nəfarʋ tə tɩʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dàn ká dù n kə n tɩ̀àn yuu wa, n nə wàrɩ̀ n yukʋʋ nədʋ tətə, n pa ka pɩ̀rɩ̀, nə à yə̀ə́ ka beri tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Á nə mɛ, sə á swɩ̀án ndə awo, á swɩ̀n ndə awo. Á nə kʋ́ʋ̀ mɛ, sə á swɩ̀án ndə ɔn ɔn, á swɩ̀n ndə ɔn ɔn. Á nə súrí yoo don lá, kʋ yɩ kʋ nan *Sɩtana». ");
INSERT INTO nnw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nì də, ba swɩ̀n, ba wʋ́: ‹Də lìù nə lá n yii, sə n də lá ʋ yii. Də lìù nə kén n yeli, sə n də kén ʋ yeli.› ");
INSERT INTO nnw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yá à mʋ̀ dàń wʋ́: Á dànà ká zɩgɩ wʋlwanyɩna tə nə. Də lìù nə mà n jɩzən pɩpara nə, sə n vəvəri n jɩgwiə nyiən tə, də n pa ʋ mà kʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Də lìù nə pɩ̀à, sə ʋ pa ba bʋ̀rɩ̀ n bʋ̀rà, sə ʋ ma jon n gànʋ̀, yá kʋ tíú, sə ʋ jon n gasɔɔ də. ");
INSERT INTO nnw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Də lìù kálʋ́ mʋ́, sə n ja wá n va kilomɛtərə nədʋ, sə n ja wá n va kilomɛtərə bələ. ");
INSERT INTO nnw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pa lìù tə nə, ʋ nə lòrì won n con. Dàn ká vɩ, sə n jɩŋa lìù tə, ʋ nə pɩ̀à, sə ʋ jɩŋa won n con». ");
INSERT INTO nnw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nì də, ba swɩ̀n, ba wʋ́: ‹N mɛ, sə n sóní n yɩra lìù tə, n ga zɩgɩ n dʋŋʋ nə›. ");
INSERT INTO nnw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yá à mʋ̀ dàń swɩ̀n á con, à wʋ́: Á swənə á dʋŋa, á ga lòrì Yɩɩ á pa ba tə nə, ba nə keni aba càn wa. ");
INSERT INTO nnw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kʋ nətʋ nə wá pa, á wànɩ́ á ya á nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ *sàń nə, bɩa. Kʋ yɩ cɩ́gá, ʋ mʋ̀ Yɩɩ tə nə pɩn yɩcaʋ pén wʋlwanyɩna də pubwanʋ tɩ̀án mama yuu wa. Ʋ pa dwà nɩ̀ ba tə yuu wa, ba nə yɩ cɩ́gá tɩ̀án, də ba tə, ba nə yɩ kʋnkʋn yìə̀n tɩ̀án yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Də kʋ nə yɩ ba tə, ba nə swə aba cɩcɩ nə á swə, kʋ ba ŋwɩ́rán jə, á nə mɛ, sə á dàn Yɩɩ con. Lanpolɩna tətə də fwa kʋ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Də á nə jʋ̀nɩ̀ ba tə nə yɩ á nubɩa *Kərisə yɩrɩ cɩcɩ, kʋ nətʋ ba lìù mama gwárɩ́. Ba tə, ba nə yə̀rì Yɩɩ tətə, də fwa kʋ nətʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Á mɛ, sə á ya lɩ̀à tə, á yoo mama nə ziən, ndə á nyɩna Yɩɩ tə nə wulə Yɩɩ sàń nə, yoo mama nə ziən nətʋ». ");
INSERT INTO nnw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á cɩa á tɩ̀àn nə, sə á dànà ká tʋn á cɩ́gá yìə̀n tə ləzoni mama yáá con, sə lɩ̀à mama na aba. Də á nə fwa kʋ nətʋ, á bá na ŋwɩ́rán á nyɩna Yɩɩ tə con, ʋ nə wulə Yɩɩ *sàń nə. ");
INSERT INTO nnw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Də n nə pɩ̀à, sə n pa yɩlori won, dàn ká fwa zuzugu, sə kʋ pa lɩ̀à mama yɩ́á ya n yuu wa, ndə níə́ bələ tɩ̀án tə nə fwa nətʋ *Zwifə-ba *jə́rə́ dii tə wa, də coŋi yuu. Mə ba fwa nətʋ, sə ləzoni ma pa ba dun. Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ba lɩ̀à təntə dí yáá ba na ba ŋwɩ́rán, ba zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Də n dàń nə pɩ̀à, sə n pa yɩlori won, fwa ndə n jɩgwiə tə wà mɛ, sə ka lwarɩ won tə, n jɩzən tə nə fwa. ");
INSERT INTO nnw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pa, sə yɩlori won təntə, n nə pɩn, ya yosəgu n mʋ̀ də n nyɩna Yɩɩ cɩcɩ pwərə wa. Yá n nyɩna Yɩɩ tə, ʋ nə nɩ kʋ tə, n nə sə̀gə̀ n fwa tə, wá pa n ŋwɩ́rán». ");
INSERT INTO nnw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Máŋá tə wa, á nə jʋ̀nɩ̀ Yɩɩ, á dànà ká ya ndə níə́ bələ tɩ̀án tə nə, ba nə swə, sə ba zàn ba zɩgɩ yɩɩ nə *Zwifə-ba *jə́rə́ dii tə wa, də coŋi yuu, ba jʋn Yɩɩ, sə lɩ̀à mama na ba. Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ba dí yáá ba na ba ŋwɩ́rán, ba zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","N mʋ̀ dàń nə pɩ̀à, sə n jʋn Yɩɩ, zʋ n dəyaa wa, n pɩn n mimii, n ga jʋn n nyɩna Yɩɩ tə, ʋ nə wulə kʋ yisəgə bwálɩ́ təntə wa. Yá n nyɩna Yɩɩ tə, ʋ nə nɩ kʋ tə, n nə sə̀gə̀ n fwa tə, wá pa n ŋwɩ́rán. ");
INSERT INTO nnw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Də á nə jʋ̀nɩ̀ Yɩɩ, máŋá tə wa, á dànà ká pa á níə́ sʋ̀ràn tə doni jɩɩn, ndə ba tə nə, ba nə yə̀rì Yɩɩ. Ba mʋ̀ nə bʋŋa də, ba níə́ sʋ̀ràn ka bwé də ka bwé nə wá pa, sə Yɩɩ le ba. ");
INSERT INTO nnw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Á dànà ká ya ndə ba nə, á nyɩna Yɩɩ tə nə dí yáá ʋ yə̀ə́ kʋ tə, kʋ nə mɛ də aba, də á tə wà kʋ lòrì ʋ con tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Á nəŋə, á nə mɛ, sə á jʋn Yɩɩ nətʋ: Nə nyɩna Yɩɩ tə, n nə wulə Yɩɩ *sàń nə! N yɩrɩ mɛ də dun. ");
INSERT INTO nnw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bàá, n də́ n pàrɩ̀ tə tɩa yuu wa. N fɩra tə mɛ, sə kʋ tʋn tɩa yuu wa, ndə Yɩɩ sàń nə. ");
INSERT INTO nnw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pa nəba nə zə̀n nii wodiu, kʋ nə mɛ nəba. ");
INSERT INTO nnw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kwɛn nə cʋna, n lɩ nə mʋ̀ də n mʋ̀ pwərə wa, ndə nə də nə kwɛn lwanɩ tə, lɩ̀à nə tʋn nə yɩra, nə lɩ nə mʋ̀ də ba pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","N dàń jon nəba kʋ tə wa, kʋ nə lwara. Dàn ká pa yoo yí nəba, kʋ nə wá yigu nəba, kʋ kə yokʋkwɩʋn wa. N mʋ̀ nə tɩ pàrɩ̀, də dɩ̀àn, də dun, tə nə ba zwɛ̀e abada. Amɩɩna! ");
INSERT INTO nnw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Á nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ sàń nə, ʋ wá kwɛn á cʋna ʋ lɩ á mʋ̀ də wá pwərə wa, də á də nə kwɛn ba tə, ba nə cʋ̀gʋ̀ á nə, cʋna á lɩ á mʋ̀ də ba pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yá á nə vɩga, sə á kwɛn ba cʋna tə, á lɩ á mʋ̀ də ba pwərə wa, á nyɩna Yɩɩ də bá kwɛn á cʋna tə ʋ lɩ á mʋ̀ də wá pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Máŋá tə wa, á nə vwə á nii, á dànà ká cʋ̀gʋ̀ á yáá, ndə níə́ bələ tɩ̀án tə nə. Ba mʋ̀ yàá lwàń ba yéé, sə lɩ̀à mama yəni də, ba vwə ba níə́. Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ba dí yáá ba na ba ŋwɩ́rán, kʋ zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yá n mʋ̀, máŋá tə wa, n nə vwə n nii, sə n pùlì n yáá, n ga zàŋá n yuu, ");
INSERT INTO nnw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sə lɩ̀à dàn ká yəni də, n vwə n nii, də kʋ nə tà n nyɩna Yɩɩ cɩcɩ, ʋ nə wulə kʋ yisəgə bwálɩ́ təntə wa. Yá n nyɩna Yɩɩ tə, ʋ nə nɩ kʋ tə, n nə sə̀gə̀ n fwa tə, wá pa n ŋwɩ́rán». ");
INSERT INTO nnw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á dànà ká pa tɩa ka tə yuu wa wiən tə, tə kwənə nə dáá, ka pɩ̀à nə ja á bɩan nə. Wiən təntə mama wá zwɛ̀e, ndə kwìù nə dí tə, ndə lugu nə sɩnɩ kʋ pʋ nə. Ŋwɩna də wàá tə ba zwɩ ba ŋwɩ̀n dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Á pɩ̀à jɩjə tə, kʋ nə wulə Yɩɩ con, á tún á tɩ̀àn nə, kʋ mʋ̀ nə kwìù wàrɩ̀ kʋ də́, kʋ ga ba sɩnɩ ndə lugu nə kʋ pʋ. Ŋwɩna də wàrɩ̀ kʋ ba zwɩ ba ŋwɩ̀n Yɩɩ *sàń tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","N wiən tə, tə kwənə nə dáá, tə wulə lá nə, n waa də yàá ya lá». ");
INSERT INTO nnw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Ləzwənə yɩ́á tə ya ndə n yɩra cànʋ́ nə. Də n yɩ́á tə nə zurə, n yɩra tə mama yàá pɩ̀rɩ̀ də poni. ");
INSERT INTO nnw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yá də n yɩ́á tə nə ba ziən, n yɩra tə mama yàá ya yikunu wa. Də n poni təntə, kʋ nə wulə n yɩra wa, nə yɩ yikunu, tə yikunu tə yiri lwara». ");
INSERT INTO nnw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lìù tə̀lə́, ʋ nə wàá ʋ tʋŋa, ʋ pɩn yun tɩ̀án bələ nə. Ʋ nə fwa kʋ, ʋ wá sóní ʋ don, ʋ ga dʋ́n ʋ don tə. Ʋ wá sɛ̀e ʋ don nii, ʋ ga vɩ ʋ don nii. Á wàrɩ̀ á twá duən, á tʋŋa á pɩn Yɩɩ də tɩa yuu jɩjə nə. ");
INSERT INTO nnw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kʋ mʋ̀ nə pɩn, à wʋ́: Á dànà ká pa, á mɩɩ tə twara ja aba, də kʋ tə, á nə wá də́, nə à yə̀ə́ á nə wá nyʋ, nə à yə̀ə́ də kʋ tə, á nə wá zʋ á yɩra nə. Á mɩɩ tə jə funə kʋ doni wodiu. Yá á yɩra tə də jə funə tə doni gànʋ̀. ");
INSERT INTO nnw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Á ywàŋá zənbii, tə nə pəri yɩɩ nə! Tə ba dwì, tə ga ba ce, tə ba pɛ̀e, tə keni təkələ wa. Yá á nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ *sàń nə, pɩn tə nii wodiu. Á ba zənbii kʋkwa zənzən, naaa? ");
INSERT INTO nnw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Á wà twara tə, ʋ nə jə nə wàá ʋ mɩɩ tə, kʋ təni mancɩn tətə? ");
INSERT INTO nnw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Bɛ̀eɛ̀e dàń nə pɩn, á pa gànʋ̀ twara jə aba? Á ywàŋá á jə́n kárɩ́ gapunə nə naŋa nətʋ, tə ba tʋŋa, tə ma ba gànʋ̀ də swɩ. ");
INSERT INTO nnw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","À mʋ̀ nə swɩ̀n kʋ á con də, pɩ̀ʋ́ *Salʋmʋn tətə də ʋ jɩjə tə mama, ʋ wà gànʋ̀ zwɩ, kʋ nə ziən kʋ doni tə gapunə təntə nədʋ də. ");
INSERT INTO nnw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yá Yɩɩ dàń nə ywàŋá tə mʋ̀ gɛɛ təntə yuu, tə nə yɩ tʋtʋ, də á mʋ̀ á nə ja funə zənzən á doni tə, ʋ wá ywàń á yuu nətə? Tə mʋ̀ gaʋ, tə nə wulə kárɩ́ wa zə̀n, wá kʋ̀, ba kə mən wa jwɩan nə, Yɩɩ dàń wá zʋ aba də ganan nətə. Á wà á waa ken à nə wuuu! ");
INSERT INTO nnw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Á kʋ́ʋ̀ dànà ká pa twara ja aba, də kʋ tə, á nə wá də́, də kʋ tə, á nə wá nyʋ, də kʋ tə, á nə wá zʋ á yɩra nə. ");
INSERT INTO nnw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tə wiən təntə yɩ ba tə, ba nə yə̀rì Yɩɩ nə pɩ̀à tə, ba ba sìí. Yá á mʋ̀ nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ sàń nə, yə̀ə́ kʋ tə nə mɛ aba. ");
INSERT INTO nnw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Á kənə dɩ̀àn á dí yáá, á pɩ̀à Yɩɩ pàrɩ̀ tə də ʋ cɩ́gá tə, yá kʋ kwa nə, Yɩɩ wá pa aba tətə mama, tə nə mùrì aba. ");
INSERT INTO nnw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Á dànà ká pa twara ja aba də jwɩan yoo, jwɩan nə wá ja kʋ yoo, kʋ ja bà yɩrɩ. Dɩɩn mama də kʋ yoo!» ");
INSERT INTO nnw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á dànà ká bʋ̀rɩ̀ duən bʋ̀rà, sə Yɩɩ də dàn ká bʋ̀rɩ̀ á bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ba wá bʋ̀rɩ̀ á də bʋ̀rà, ndə á nə bʋ̀rɩ̀ lɩ̀à tə duən bʋ̀rà nətʋ. Won tə, á nə ja maŋa, á pɩn lɩ̀à tə nə, kʋ mʋ̀ nə Yɩɩ wá ja man, ʋ pa á də nə. ");
INSERT INTO nnw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bɛ̀eɛ̀e nə pɩn, n ywàŋá gabiu tə, kʋ nə wulə n nubiu yii wa, yá n ga ba baŋa tə na, ka nə wulə n mʋ̀ yii tə wa? ");
INSERT INTO nnw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","N dàń wá twá nətə, n ma swɩ̀n n nubiu con, n wʋ́: ‹Yá, sə à lɩ gabiu tə n yii wa›, n ga jə baŋa tə n tətə yii tə wa? ");
INSERT INTO nnw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Níə́ bələ tíú! Dí yáá, n lɩ baŋa tə n yii tə wa. Kʋ kwa nə, n yɩ́á wá na lá zəni, sə n ma lɩ n nubiu tə yii gabiu tə. ");
INSERT INTO nnw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Á dànà ká pa wiən, tə nə ya Yɩɩ nyiən, kukuri nə, sə tə ma pìí tə dɩŋɩ aba. Á dànà ká dɩlɩ á kana bɩan zanan twərən yáá nə, tə nə wá nɩŋa tə, tə kə tə nɛɛ də̀ń yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á lwərə, yá ba wá pa aba! Á pɩ̀à, yá á wá na! Á mà mimii nə, yá ba wá súrí, ba pa, á zʋ! ");
INSERT INTO nnw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Lìù mama nə lòrì, ba wá pa mʋ́. Lìù mama nə pɩ̀à ʋ wá na. Yá ba ga wá súrí, ba pa lìù tə nə, ʋ nə mà mimii nə. ");
INSERT INTO nnw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Á wàà nə wulə lá, ʋ nə wá sɛ̀e, ʋ tì kapan ʋ pa ʋ bìú nə, də ʋ bìú tə nə lòrì wodiu ʋ con? ");
INSERT INTO nnw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nə à yə̀ə́ ʋ wá pa wá dən, də ʋ nə lòrì wá fəli? ");
INSERT INTO nnw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Á mʋ̀ ləzwənwʋlʋnyɩna-ba, á nə yə̀ə́ ka pa wozəŋə á bìsɩ́ná nə, kʋ dàń wá yà nətə kʋ pa á nyɩna Yɩɩ tə nə, ʋ nə wulə Yɩɩ *sàń nə, də á nə lòrì wá won? Ʋ mʋ̀ dàń wá pa aba wiən tə, tə nə ziən tə doni. ");
INSERT INTO nnw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kʋ tə, á nə pɩ̀à, sə ba fwa á yɩra, á də fwa kʋ á duən yɩra. Mə nətʋ nə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, saga tə, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə, bɩrɩ, sə ba fwa». ");
INSERT INTO nnw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Mimifarʋ wulə, kʋ cwəŋə nə wala, kʋ twagʋ nə yɩ mwálɩ́ mwálɩ́. Yá kʋ ja aba, kʋ vələ jɩ́ʋ́n bwálɩ́ nə, lɩ̀à zənzən ga dáá ba nə twá kʋ. Mimii pɩpɩan də ga wulə, kʋ cwəŋə tə twagʋ nə cà. Yá kʋ mʋ̀ nə ja aba, kʋ vəli mɩɩ bwálɩ́ nə, kʋ nə ba zwɛ̀e Yɩɩ con. Yá lɩ̀à ga ba dáá, ba nə twá kʋ. Á dàń twá mimii pɩpɩan tə, á ma zʋ!» ");
INSERT INTO nnw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á cɩa á tɩ̀àn nə də kʋnkʋn sʋ̀sʋ̀nà-ba! Ba wá bà á con ndə pee nə vəli pee con, yá ba ga yɩ ndə buyurən nyankwan nə, tə nə wá ja pee tə. ");
INSERT INTO nnw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Á wá twá ba tʋtʋnɛɛ nə, á ma lwarɩ ba. Ba ba lwɛ, nə à yə̀ə́ kacan kwe casʋʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tɩzəŋu yàá zɩn bizəŋə. Yá tɩkʋkwɩʋn də yàá zɩn bɩa kʋkwɩnan. ");
INSERT INTO nnw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tɩzəŋu wàrɩ̀ bɩa kʋkwɩnan kʋ zɩŋa, yá tɩkʋkwɩʋn də wàrɩ̀ bɩa tə nə ziən, kʋ zɩŋa. ");
INSERT INTO nnw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tɩ̀ʋ́ tə mama, kʋ nə ba bɩa, tə nə ziən zɩŋa yɩ, ba wá gwəŋə kʋ, ba dɩ mən nə. ");
INSERT INTO nnw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mə nətʋ nə, á wá twá, á ma yəni lɩ̀à tə, ba nə yɩ kʋnkʋn sʋ̀sʋ̀nà tə». ");
INSERT INTO nnw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Kʋ tà ba tə mama, ba nə boŋə nə ‹*Yuu-Tiu, Yuu-Tiu› nə wá zʋ Yɩɩ pàrɩ̀ tə wa. Kʋ yɩ ba tə cɩcɩ, ba nə fwa à nyɩna Yɩɩ fɩra tə, ʋ nə wulə Yɩɩ *sàń nə. ");
INSERT INTO nnw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yɩɩ bʋ̀rà tə dɩɩn nə wá yí, lɩ̀à zənzən wá swɩ̀n, ba wʋ́: ‹Yuu-Tiu, Yuu-Tiu! Nə wà n yɩrɩ tə, nə twá, nə ma swɩ̀n Yɩɩ nii sʋ̀ràn, naaa? Nə wà n yɩrɩ tə, nə twá, nə ma lɩ *zinə lɩ̀à yuu wa, naaa? Nə wà n yɩrɩ tə, nə twá, nə ma fwa yomɩlan, naaa?› ");
INSERT INTO nnw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kʋ kwa nə, à dàń wá swɩ̀n də ba nəpon nəpon, à wʋ́: ‹À mʋ̀ wà aba yəni, abada. Á vələ kwa à səpuni nə, á mʋ̀ yokʋkwɩnan-ba!› » ");
INSERT INTO nnw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Kʋ mʋ̀ nə pɩn, lìù tə mama, ʋ nə cʋga à sʋ̀ràn tə, ʋ ga twá tə nii nə, ʋ wá yà ndə wʋbʋŋa tíú nə, ʋ nə lwə̀ ʋ dìə̀ pɩ̀ʋ̀ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dwà nəfarʋ nə twi, bun sú tə palɩ. Dwà vʋʋ nəfarʋ tə fɩrʋ dìə̀ tə, yá won mama wà ka fwa, ka dəkuu nə zɩga pɩ̀ʋ̀ tə yuu wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yá lìù tə, ʋ nə cʋga à sʋ̀ràn tə tə, à nə swɩ̀n sɩ́ʋ́n, ʋ ga ba tə nii nə twá, ʋ wá yà ndə ləyigə nə, ʋ nə lwə̀ ʋ dìə̀ kasɩlʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dwà nəfarʋ nə twi, bun sú tə palɩ. Dwà vʋʋ nəfarʋ ma fuli, kʋ zɩgɩ ka dìə̀ tə nə, ka làń ka tʋ, bɔɔɔ! Ka cʋ̀gʋ̀ mɩ́ámɩ́án». ");
INSERT INTO nnw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Máŋá tə wa, Zwezi nə swɩ̀n tə yìə̀n təntə, ʋ zwɛ̀e, kʋ gwárɩ́ lɩ̀à tə zənzən də kʋ kàrà təntə yiri. ");
INSERT INTO nnw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ka də Yɩɩ nii *yənu tɩ̀án tə kàrɩ̀ tə nə tà nədʋ yɩrɩ. Zwezi kàrà tə yà bɩrɩ də, Yɩɩ nə ken dɩ̀àn ʋ jɩɩn wa, sə ʋ swɩ̀n tə sʋ̀ràn təntə. ");
INSERT INTO nnw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zwezi nan paan yuu, ʋ cú. Yá lalʋʋ dàń púə́ ʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kʋ máŋá tə wa, də nə̀ń dayarʋ don nə kʋ twi, ʋ tʋ ʋ yáá con, ʋ ga wʋ́: «*Yuu-Tiu, də n nə swə, n wàá n pɩn à dayan tə zwɛ̀e, sə à də jì ləzwənzəŋu». ");
INSERT INTO nnw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Zwezi ma te ʋ jɩɩn ʋ nə, ʋ dwen ʋ yɩra, ʋ ga wʋ́: «À swə, sə n dayan tə zwɛ̀e». Lala də ʋ dayan tə zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Zwezi ga swɩ̀n ʋ con, ʋ wʋ́: «Ja n nii zəni! Dàn ká swɩ̀n kʋ lìù con. N dàń nə vəli, n bɩrɩ n tɩ̀àn *Zwifə-ba Yɩɩ *joŋwanʋ tə. N dàń ga pa wiən tə, ʋ nə wá ja fwa *joŋi tə, ndə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, nə bɩrɩ Yɩɩ sagɩ tə wa, sə dayaran pa, də ba dayan tə nə zwɛ̀e. Kʋ mʋ̀ nə wá bɩrɩ də, n dayan tə cɩ́gá zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Máŋá tə wa, Zwezi nə zwɩ Kapɛrənayimə, *Romə-ba pamana bíí yuu tíú don twi, ʋ lòrì wá saŋʋ, ");
INSERT INTO nnw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ʋ wʋ́: «*Yuu-Tiu, à tʋtʋnbiu tə́gə́ sàń nə, ʋ nandɛɛ tɩga, ʋ ga də́ càn zənzən». ");
INSERT INTO nnw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Zwezi ma swɩ̀n, ʋ wʋ́: «À wá va, à zwɛ̀e ʋ yayɩgʋ tə». ");
INSERT INTO nnw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pamana yuu tíú tə ma swɩ̀n, ʋ wʋ́: «Yuu-Tiu, à jɩɩn mùrì, sə n zʋ à dìə̀ wa. N dàń pa nii cɩcɩ, yá à tʋtʋnbiu tə yayɩgʋ tə wá zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","À də tətə yɩ lɩ̀à duən nə tɩ nə, à də ga tɩ pamana duən. À nə swɩ̀n pamanʋ tə don con, à wʋ́: ‹Vəli!› Ʋ wá va. À nə bon wà don, à wʋ́: ‹Bàá!› Ʋ wá bà. Yá à nə swɩ̀n à tʋtʋnbiu con, à wʋ́: ‹Fwa kʋ tə!› Ʋ wá fwa kʋ». ");
INSERT INTO nnw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Máŋá tə, Zwezi nə nì tə sʋ̀ràn təntə, tə poli ʋ pùə́ zənzən, ʋ ga swɩ̀n ba tə con, ba nə twá ʋ nə, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə̀lə́ *Yɩzərayɛlə lʋʋ nii tə wa, ʋ nə ken ʋ waa Yɩɩ nə, ndə bɛɛ wà tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","À mʋ̀ nə tə swɩ̀n kʋ, á con nə: Lɩ̀à zənzən, ba nə tà *Zwifə-ba, ndə Romə-ba pamana yuu tíú wà tə nə, wá nan yɩɩ yipɩan con də yɩɩ yizwɩa con, ba bà ba jə̀ń Yɩɩ pàrɩ̀ tə wa də *Abərahamə də *Yɩzakə də *Zwakɔbə. ");
INSERT INTO nnw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yá Yɩzərayɛlə lɩ̀à tə, Yɩɩ *sàń tə yà nə kwɛn, kʋ tún ba nə, wá na də, ba dɩlɩ ba kàrá wa yikunu tə wa. Kʋ bwálɩ́ təntə wa, ba wá bubwi, ba ga dɩŋa ba jɩfwɩ ba fɩfaga.» ");
INSERT INTO nnw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zwezi dàń ma swɩ̀n pamana yuu tíú tə con nə, ʋ wʋ́: «Vəli n bwálɩ́! Yoo tə n nə lòrì, kʋ wá tʋn, n nə ken n waa à nə, tə yɩrɩ». Yá mə kʋ mʋ̀ máŋá təntə wa nə, pamana yuu tíú tə tʋtʋnbiu tə nɩ ʋ tɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kʋ kwa nə, Zwezi vələ Piyɛrə sàń. Máŋá tə wa, ʋ nə zʋa Piyɛrə dìə̀, ʋ nɩ də, waran jə Piyɛrə tɩnkan, ʋ ga tə́gə́. ");
INSERT INTO nnw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zwezi dwen ʋ jɩɩn nə, yá waran tə zwɛ̀e, ʋ ga nyɩ́ ʋ zàn lala, ʋ wulə ʋ tanɩ, sə ʋ ma lɩ Zwezi vəri. ");
INSERT INTO nnw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Máŋá tə, dədəni nə yí, ba ja lɩ̀à zənzən, *zinə nə wulə ba yuu wa, ba bà Zwezi con. Ʋ nii sʋgʋ cɩcɩ nə ken tə zinə təntə mama cwəŋə nə, yá yayɩran tə tɩ̀án mama ga zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mə kʋ twá nətʋ, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi nii tə ma sú, ndə ʋ nə swɩ̀n, ʋ wʋ́: «Ʋ mʋ̀ nə jon nə càn, də nə yayɩran mama ʋ zɩn.» ");
INSERT INTO nnw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zwezi nɩ də lalʋʋ twá ʋ kwa. Ʋ dàń ma pa nii ʋ karbɩa tə nə, sə ba bɛn mʋnaa tə bəbəru tə don nə. ");
INSERT INTO nnw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kʋ máŋá təntə wa, Yɩɩ nii *yənu tíú don ma fàrʋ́ ʋ yí ʋ yɩra, ʋ ga swɩ̀n, ʋ wʋ́: «Karnyɩna, à mʋ̀ wá twá n nə, bwálɩ́ mama, n nə vələ». ");
INSERT INTO nnw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Zwezi ma le wá, ʋ wʋ́: «Ciləcərən jə tə bʋran tə zwɩ, zənbii də ma jə tə pwalan, yá *Ləzwənə-Biu tə mʋ̀ ba bwálɩ́ ja, ʋ nə wá kə ʋ yuu lá». ");
INSERT INTO nnw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ʋ karbiu don də ma swɩ̀n, ʋ wʋ́: «*Yuu-Tiu, pa nə cwəŋə, sə à də́ yáá à va à gùrì à nyɩna, sə à ga fwa ʋ luə». ");
INSERT INTO nnw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zwezi ma le wá, ʋ wʋ́: «Twá à nə! Yá, sə tɩga tə tɩ̀án tə, ba nə ba mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con, jə gùrì ba tɩga». ");
INSERT INTO nnw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kʋ kwa nə, Zwezi də ʋ karbɩa tə dɩ̀gà nɩ́á yuu bori wa, sə ba bɛn vàn tə don nə. ");
INSERT INTO nnw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Naa nədʋ, vʋʋ nəfarʋ nə kʋ zàn, kʋ jə nɩ́á tə, kʋ mà kʋ pwí nɩ́á yuu bori tə yuu nə. Yá Zwezi mʋ̀ yà dwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ʋ karbɩa tə dàń ma yí ʋ yɩra, ba zɩ̀n wá, ba ga wʋ́: «*Yuu-Tiu, jon nəba, nə pɩ̀à, sə nə tɩ!» ");
INSERT INTO nnw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Zwezi ma le ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, fən jə aba nətʋ? Á ba á waa keni à nə wuuu, naaa?» Ʋ ma zàn, ʋ baa vʋʋ tə, də mʋnaa tə nii nə. Tə dàń ma zɩgɩ. Yá bwálɩ́ tə mɛ siii. ");
INSERT INTO nnw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kʋ gwárɩ́ lɩ̀à tə mama kʋ bwálɩ́ tə wa, ba ga bwe ba tɩ̀àn, ba wʋ́: «Bɛɛ wà tə tà ndə lɩ̀à mɛ nə. Vʋʋ də mʋnaa mɛ zìlí ʋ nii!» ");
INSERT INTO nnw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kʋ kwa nə, Zwezi galɩ mʋnaa tə, ʋ lɛ ʋ zʋ Gadara nagwanaa wa. Kʋ máŋá tə wa, də nə̀ń bara bələ *zinə nə jə, ba twi ba jə́rí Zwezi. Ba mʋ̀ bara təntə yà yɩ ba wulə pɩ̀ràn bʋran wa, ba nə kʋa, ba ma kəni tɩga. Yá lìù də mama yà kwàrɩ̀ kʋ bwálɩ́ təntə wa ʋ twá ba yɩrɩ, ba yà nə tʋŋa yolwan zənzən yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba dàń ma bubwi, ba wʋ́: «Yɩɩ-Biu, bɛ̀eɛ̀e nə n pɩ̀à də nəba? Kʋ yɩ n twi, sə n kə nəba càn wa, də kʋ máŋá tə wà yí, naaa?» ");
INSERT INTO nnw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Twərən zənzən yà wulə yáá nə, tə də́ wodirən. ");
INSERT INTO nnw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Zinə tə ma lòrì Zwezi, tə wʋ́: «Də n nə wá dɩŋa nəba, sə n yá, sə nə va nə zʋ twərən tə». ");
INSERT INTO nnw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Zwezi ma le tə, ʋ wʋ́: «Á vələ!» Tə dàń ma nan tə yá ba bara bələ tə, tə va tə zʋ twərən tə wa. Lala twərən tə dəru, tə bəbəli paan tə yuu, tə tʋ mʋnaa tə nɩ́á tə wa, tə tɩ. ");
INSERT INTO nnw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Twərən nəcɩra tə dəri, ba va tɩʋ tə wa. Ba vəli, ba man kʋ tə mama, kʋ nə yí ba, də ba mʋ̀ bara bələ təntə. ");
INSERT INTO nnw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tɩʋ tə tɩ̀án mama dàń nan, ba va ba jə́rí Zwezi. Yá ba nə twi, ba na Zwezi, ba dàń lòrì wá, sə ʋ nan, ʋ yá ba tɩʋ tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zwezi kʋ́ʋ̀ pìí ʋ zʋ nɩ́á yuu bori tə, ʋ bɛn mʋnaa tə, ʋ va ʋ yí ʋ tətə tɩʋ Kapɛrənayimə. ");
INSERT INTO nnw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ba jɩn gwànʋ́ don, ba bà ʋ con tɩtaʋ wa. Máŋá tə, Zwezi nə nɩ də, lɩ̀à təntə ken ba waa ʋ nə, ʋ swɩ̀n gwànʋ́ tə con, ʋ wʋ́: «À dabɛɛ, pa n jɩɩn dàn! À kwɛn n cʋna tə, à lɩ n mʋ̀ də Yɩɩ pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kʋ mʋ̀ təntə yɩrɩ Yɩɩ nii *yənu tɩ̀án tə dàń ma swɩ̀n ba waa con, ba wʋ́: «Bɛɛ wà tə swɩ̀n, ʋ twɩn Yɩɩ nə!» ");
INSERT INTO nnw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Zwezi nə lwarɩ ba pubʋŋɩ tə, ʋ dàń ma bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á ma jə pubʋŋɩ tətə yiri á waa nə? ");
INSERT INTO nnw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kʋ kwà nə yɩ mwálɩ́, kʋ doni kʋ don, də à nə swɩ̀n, à wʋ́: À kwɛn n cʋna, à lɩ n mʋ̀ də Yɩɩ pwərə wa, nə à yə̀ə́ də à nə wʋ́: Zàn yɩɩ nə, n va! ");
INSERT INTO nnw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","À yɩ à pɩ̀à, sə á yəni də, Yɩɩ ken dɩ̀àn *Ləzwənə-Biu jɩɩn wa, tɩa yuu wa yəbə, sə ʋ kwɛn cʋna, ʋ lɩ lɩ̀à də Yɩɩ pwərə wa». Ʋ dàń ma swɩ̀n gwànʋ́ tə con, ʋ wʋ́: «Zàn yɩɩ nə, n tì n tɩtaʋ tə, n va n sàń!» ");
INSERT INTO nnw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bɛɛ tə nyɩ́ ʋ zàn, ʋ vələ ʋ sàń. ");
INSERT INTO nnw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Máŋá tə, lalʋʋ tə nə nɩ kʋ nətʋ, fən zwa lɩ̀à tə. Ba dàń ga wulə ba pɩn dun Yɩɩ nə, ʋ nə ken dɩ̀àn nətʋ ləzwənə də nyan don jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Zwezi nə kɛ̀eń ʋ vələ yáá, ʋ nɩ bɛɛ don, ba nə boŋə Matiə, də ʋ jə̀ə́ ʋ joŋə lanpoo ʋ tʋtʋnan dìə̀ wa. Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Zàn n bà, n twá à nə!» Matiə ma zàn, ʋ twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Zwezi də ʋ karbɩa tə vəli Matiə sàń. Ba nə wulə ʋ dìə̀ wa, ba də́ máŋá tə wa, lanpolɩna tə duən də cʋna lɩ̀à tə duən də twi ba yà wulə ba də́ də ba. ");
INSERT INTO nnw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","*Farɩzɩan-ba tə nɩ ba nətʋ, ba dàń bwe Zwezi karbɩa tə, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, á karnyɩna tə ma də́ də lanpolɩna də cʋna lɩ̀à tə?» ");
INSERT INTO nnw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Zwezi nə nì kʋ, ʋ le ba, ʋ wʋ́: «Lɩ̀à tə, ba yɩra nə zurə nə ba dɩmʋtʋrʋ pɩ̀à. Kʋ yɩ yayɩŋa nə pɩ̀à dɩmʋtʋrʋ». ");
INSERT INTO nnw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ súrí lá, ʋ wʋ́: «Á vələ, á pɩ̀à Yɩɩ sagɩ tə wa yoo tə də̀ń, kʋ nə wʋ́: ‹À swə, sə á dəri duən yinəgə zənzən, à ba á *joŋi won pɩ̀à.› Cɩ́gá, kʋ tà à twi, sə à bon cɩ́gá tɩ̀án, kʋ yɩ à twí, sə à bon cʋna lɩ̀à tə». ");
INSERT INTO nnw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Zwan karbɩa twi Zwezi con, ba bwe wá, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, nə mʋ̀ də *Farɩzɩan-ba tə yàá vwe nə níə́, yá n mʋ̀ karbɩa tə ga ba ba níə́ vwe?» ");
INSERT INTO nnw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Zwezi ma le ba, ʋ wʋ́: «Bɛɛ nə pɩ̀à ʋ vwa ʋ kan fúrú, ʋ dabara yàá bà, sə ba twá ba də́ fúrú tə diŋə tə. Á bʋŋa də, ba wá vwe ba níə́, ba dàn ká də́ wodiu tə, yá fúrú bɛɛ ga wulə də ba? Yá máŋá dàń wá bà, fúrú bɛɛ tə bá ya lá. Kʋ mʋ̀ máŋá təntə wa, ba dàń wá vwa ba níə́. ");
INSERT INTO nnw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Lìù tə̀lə́, ʋ nə wá tì gantwandʋn, ʋ ma pú gangwɩrʋ, gantwandʋn tə nə wá vuri gangwɩrʋ tə vàn don yɩrɩ, yá kʋ bʋʋ tə dàń wá doni də́ yáá tə tətə. ");
INSERT INTO nnw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ba ma ba swana, tə nə wulə tə zaŋa, lwé ba kəni purə nədwara wa. Kʋ nətʋ tə nə fwa, purə tə wá pwin. Swana tə mama wá lwá tɩa, yá purə tə wá va bwàná. Ba mɛ, sə ba kə swana, tə nə wulə tə zaŋa, purə nədʋra wa, sə swana tə, də purə tə mɛ dàn ká cʋ̀gʋ̀». ");
INSERT INTO nnw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Də Zwezi tə nə zɩga lá, ʋ swɩ̀n tə sʋ̀ràn təntə *Zwan-Batisə karbɩa tə con, *Zwifə-ba *jə́rə́ dìə̀ don yuu tíú don twi, ʋ tʋ Zwezi yáá con, ʋ ga wʋ́: «À bʋ̀á tɩga, kʋ nə dɩ́án mancɩn. Yá n ya bà, n tún n jɩ̀àn ʋ yuu wa, sə ʋ mɩɩ ga ya lʋʋ». ");
INSERT INTO nnw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zwezi də ʋ karbɩa tə ma zàn ba pú ʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kʋ máŋá tə wa, kan don yɩ lá, ʋ tàŋá nə twi, ka ba zɩga, kʋ nə yí bɩna fugə bələ. Ʋ ma twá Zwezi kwa, ʋ fàrʋ́ ʋ yí ʋ yɩra, ʋ ga dwen ʋ gànʋ̀ nii nə. ");
INSERT INTO nnw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kan tə yà swɩ̀n ʋ waa con: «À nə ken cɩ́gá, à dwen ʋ gànʋ̀ tə cɩcɩ nə, à yayɩgʋ tə wá zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zwezi nə pìí ʋ vəvəri, ʋ na wá, ʋ swɩ̀n, ʋ wʋ́: «À nakʋa, dàn n jɩ̀àn! N ken n waa à nə, kʋ mʋ̀ nə pɩn, n na yazurə». Də naa nədʋ, kan tə yayɩgʋ tə zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Zwezi ma kɛ̀eń, ʋ yí jə́rə́ dìə̀ tə yuu tíú tə sàń. Kʋ máŋá tə wa, də wuwurə də lalʋʋ, ba nə bubwi, yà súə́ lá nə. Zwezi ma swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Á naŋa lá nə, bʋ̀á tə wà tɩ, kʋ yɩ ʋ dwɛ̀e». Lɩ̀à tə dàń yà ma wulə ba mʋŋa Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Máŋá tə wa, ba nə lɩ lalʋʋ tə kàrá wa, Zwezi zʋa dìə̀ tə wa. Ʋ jɩn bʋ̀á tə jɩɩn nə, bʋ̀á tə ga nyɩ́ ʋ zàn. ");
INSERT INTO nnw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kʋ mʋ̀ yoo təntə kʋ́ʋ̀ súə́ tɩa mama. ");
INSERT INTO nnw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Máŋá tə, Zwezi nə nan *Zwifə-ba *jə́rə́ dìə̀ yuu tíú tə kàrá wa, ʋ vìrí, lilirən bələ duən dəri, ba bubwi ʋ kwa, ba wʋ́: «Pɩ̀ʋ́ *Davidə nàʋ́, dəri nə yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zwezi nə yí sàń, máŋá tə wa, lilirən tə fàrʋ́ ba yí ʋ yɩra. Ʋ dàń ma bwe ba, ʋ wʋ́: «Á pɩn cɩ́gá də, à wàá kʋ yoo tə à tʋŋa naaa?» Ba ma le wá, ba wʋ́: «Awo, *Yuu-Tiu». ");
INSERT INTO nnw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Zwezi dàń ma dwen ba yɩ́á nə, ʋ ga swɩ̀n, ʋ wʋ́: «Kʋ nətʋ tə wá twá á nə ken á waa à nə, kʋ ma tʋn». ");
INSERT INTO nnw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lala də ba yɩ́á tə súrí, tə na lá. Zwezi ma dù sú ba nii nə, ʋ wʋ́: «Á cʋga zəni, á dànà ká pa lìù mama nì kʋ». ");
INSERT INTO nnw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yá ba tə vəli, ba swɩ̀n Zwezi yoo, ba sú tɩa mama. ");
INSERT INTO nnw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Máŋá tə wa, Zwezi nə vìrí, ba jɩn bəru, ba bà ʋ con. Bəru tə yà wàrɩ̀ kʋ swɩ̀n, *zini yà nə bəbəni wá yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Zwezi ma lɩ kʋ mʋ̀ zini təntə, bəru tə nii ga pórí, ʋ wulə ʋ swɩ̀n. Kʋ yoo tə yà gwárɩ́ lɩ̀à tə, ba dàń ga swɩ̀n, ba wʋ́: «Nə tə wà kʋ tə don nɩ *Yɩzərayɛlə lʋʋ nii wa!» ");
INSERT INTO nnw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","*Farɩzɩan-ba dàń ma swɩ̀n, ba wʋ́: «Kʋ yɩ zinə yuu tíú tə nə pɩn wá nii, ʋ ma lɩ zinə tə!» ");
INSERT INTO nnw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zwezi jiru tɩfaran tə də tɩan tə mama wa, ʋ swɩ̀n Yɩɩ sʋywáŋʋ́ tə. Ʋ bɩrɩ də, Yɩɩ wá də́ ʋ pàrɩ̀ lɩ̀à mama yuu wa. Ʋ yàá zwɩ ʋ kàrɩ̀ *Zwifə-ba *jə́rə́ dii tə wa. Yá ʋ ga zwɛ̀e yayɩŋa yayɩran yiri mama, ʋ ga pɩn yazurə ba tə nə, ba nandaran nə wà cé. ");
INSERT INTO nnw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ʋ nə nɩ lɩ̀à tə, ba yinəgə jɩn wá, lɩ̀à tə jɩ̀àn yà nə gwàrɩ̀, ba pwìí ga cʋ̀gʋ̀ tə yɩrɩ. Ba yà yɩ ndə pee nə, tə nə ba payɩrʋ jə. ");
INSERT INTO nnw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ʋ dàń ma swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Kárá tə wiən bɩga zənzən, yá tʋ̀tʋ̀nà ga ba dáá. ");
INSERT INTO nnw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Á dàń wá lòrì kárá tə tíú, sə ʋ tʋn tʋ̀tʋ̀nà, sə ba za ʋ wiən tə». ");
INSERT INTO nnw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Dɩɩn don nə, Zwezi bon ʋ karbɩa fugə bələ tə, sə ba bà, sə ʋ ken dɩ̀àn ba jɩɩn wa, sə ba wànɩ́ ba lɩ *zinə. Yá ba ga zwɛ̀e yayɩŋa yayɩran, ba ga pɩn yazurə ba tə nə, ba nandaran nə wà cé. ");
INSERT INTO nnw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ʋ karbɩa fugə bələ tə, ba nə yɩ ʋ *tʋntʋna, tə yɩra nə nətən: Ba təntən lìù nə yɩ Simon, ba nə boŋə Piyɛrə, də ʋ nubiu Andəre. Kʋ súrí Zwakə də ʋ nubiu Zwan nə, ba nə yɩ Zebede bɩa. ");
INSERT INTO nnw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Kʋ súrí Filipə də Barətelemi də Toma də Matiə, ʋ nə yɩ lanpolɩnʋ. Kʋ súrí Aləfe bìú Zwakə də Tade, ");
INSERT INTO nnw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","də Simon tə, ba nə boŋə ‹Kananitə›. Kʋ súrí Yisəkariyɔtə Zwidasə, ʋ nə jɩn Zwezi ʋ pa ʋ dʋŋa nə. ");
INSERT INTO nnw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Zwezi tʋn ba *tʋntʋna fugə bələ tə, ʋ ga pa ba nii, ʋ wʋ́: «Á dànà ká va lɩ̀à tə, ba nə tà *Zwifə-ba con, nə à yə̀ə́ Samari tɩ̀án tɩan tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Á vələ *Yɩzərayɛlə lɩ̀à tə cɩcɩ con, ba nə nyɩn ndə pee nə, tə nə jén. ");
INSERT INTO nnw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Á vələ, á swɩ̀n ba con də, máŋá tə bwələ, sə Yɩɩ də́ ʋ pàrɩ̀ tə lɩ̀à tə mama yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Á pɩan yayɩŋa yayɩran zwɛ̀e, á bwiən tɩga, sə á zwɛ̀e dayaran dayan, sə ba jì ləzwənzəŋə, á ga lɩ *zinə lɩ̀à yuu wa. Á pɩan tʋtʋ, ba nə pɩn aba tʋtʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Á dànà ká tì səbiu, ba nə fwa də sɩ́án, nə à yə̀ə́ ba nə fwa də cɩnɩa, nə à yə̀ə́ səbimɩnɩ á ganjɩga wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Á dànà ká tì lɔ̀ɔ̀, nə à yə̀ə́ gànʋ̀ don, á súrí kʋ tə nə, á nə zʋa. Á dànà ká tì natʋra duən, nə à yə̀ə́ daduu, tʋ̀tʋ̀nʋ̀ nə wá na ʋ nii wodiu yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Á nə yí tɩfarʋ, nə à yə̀ə́ tɩʋ, sə á pɩ̀à lìù tə, ʋ nə mɛ, á zʋrɩ kʋ tíú bwálɩ́ nə, kʋ ja vələ á viru. ");
INSERT INTO nnw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Dìə̀ tə, á nə zʋa ka wa, sə á jʋn lɩ̀à tə, ba nə wulə ka wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Də ka mʋ̀ dìə̀ təntə lɩ̀à tə nə wá sɛ̀e ba jon aba, sə Yɩɩ pa á jʋ̀nà tə pa ba bɩcanɩ sìə́. Yá ba nə vɩga aba, sə kʋ tə Yɩɩ nə pɩn tə, pìí kʋ bà á con. ");
INSERT INTO nnw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kʋ nə ya dìə̀ wa, nə à yə̀ə́ tɩʋ wa, ba nə vɩga, sə ba pa á zʋ, nə à yə̀ə́, sə ba cʋgʋ á sʋ̀ràn tə, á virə kʋ bwálɩ́ tə nə, á ga zwarɩ á nɛɛ purən á lwá ba yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ mʋ̀ tɩʋ təntə bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə *Sodɔmə də Gomɔrə lɩ̀à bá na càn, ndə kʋ tɩʋ tə tɩ̀án nə». ");
INSERT INTO nnw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á cʋga zəni! À tʋŋa aba ndə pee nə buyurən nyankwan tətəŋi wa. Kʋ mʋ̀ təntə yɩrɩ, á cɩa á tɩ̀àn nə ndə dɩŋa nə, sə á ga yà sənbwen ndə gunponi nə. ");
INSERT INTO nnw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ba wá ja aba, ba va lɩ̀à tə nə bʋ̀rɩ̀ bʋ̀rà yáá con. Yá ba ga wá mà aba də fɩfɩran *Zwifə-ba *jə́rə́ dii tə wa. Kʋ mʋ̀ nə pɩn, á cɩa á tɩ̀àn nə də lɩ̀à tə. ");
INSERT INTO nnw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ba wá ja aba, ba va pɛ̀egá tə də yáá tɩ̀án tə, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, con à mʋ̀ Zwezi yɩrɩ. Kʋ nətʋ tə wá tʋn, sə kʋ ma bɩrɩ ba tətə, də dwíə́ tə duən mama lʋʋ mama wa, ba nə tà Zwifə-ba, kʋ tə, Yɩɩ nə fwa. ");
INSERT INTO nnw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yá ba nə jɩn aba, ba va lɩ̀à tə nə bʋ̀rɩ̀ bʋ̀rà yáá con, á dànà ká pa kʋ tə, á nə wá swɩ̀n twara ja aba. Kʋ máŋá tə wa, Yɩɩ nə wá kə kʋ tə, á nə mɛ, sə á swɩ̀n, á nii wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kʋ tà á mʋ̀ nə wá swɩ̀n, kʋ wá yà á nyɩna Yɩɩ *Siŋu tə, kʋ nə wulə də aba, nə wá swɩ̀n kʋ pa aba. ");
INSERT INTO nnw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Lɩ̀à wá ja ba nubɩa ba pa, sə ba gʋ, yá bɩa nyɩna-ba də wá tʋn kʋ nyɩnyɩga də ba bɩa. Bɩa wá zàn, ba zɩgɩ ba nyɩna-ba nə, ba gʋ ba. ");
INSERT INTO nnw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lɩ̀à tə mama wá dʋ́n aba à mʋ̀ yɩrɩ. Yá lìù tə, ʋ nə wá ja pɩ́nʋ́, ʋ zɩgɩ ʋ dɩ̀àn kʋ yoo tə, kʋ va kʋ zwɛ̀e, kʋ tíú wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ba nə fɩfɩn aba tɩʋ wa, sə á dəri á nan á va kʋ don. Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á bá wànɩ́ *Yɩzərayɛlə tɩan tə mama, á va, də *Ləzwənə-Biu tə wà pìí ʋ bà. ");
INSERT INTO nnw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Karbiu tə̀lə́, ʋ nə dwə ʋ karnyɩna. Tʋtʋnbiu tə̀lə́, ʋ nə dwə ʋ yuu tíú. ");
INSERT INTO nnw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yá karbiu nə ya ndə ʋ karnyɩna nə, kʋ cɩcɩ mɛ. Tʋtʋnbiu də nə ya ndə ʋ yuu tíú nə, kʋ cɩcɩ mɛ. Yá ba nə jɩn dìə̀ tíú, ba bon Beləzebilə, ba wá pa yɩra tə nə dwə nətʋ ʋ dìə̀ lɩ̀à nə?» ");
INSERT INTO nnw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á dànà ká dəri ləzoni! Kʋ tə mama nə sə̀gə̀ nə wá nan poni nə yɩrɩ. Yá kʋ tə nə yɩ dìə̀ yoo wá nan kàrá. ");
INSERT INTO nnw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kʋ tə, à nə swɩ̀n á con yikunu wa, sə á swɩ̀n kʋ yɩcaʋ wa. Kʋ tə, á nə nì á zɩan wa, sə á cə̀rí kʋ dəyun wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Á dànà ká dəri ba tə, ba nə wàá yɩra tə cɩcɩ ba gwɩ, ba ga wàrɩ̀ jə̀rə́ tə won ba fwa. Yá á dərə lìù tə mʋ̀, ʋ nə wàá á yɩra tə, də á jə̀rə́ tə ʋ cʋ̀gà mən dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ba ba zənbii bələ yoli səbilugu nədʋ, naaa? Yá kʋ nədʋ tətə wàrɩ̀ tɩa kʋ twɩ, də á nyɩna Yɩɩ nə wà nii pɩn. ");
INSERT INTO nnw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yá Yɩɩ gàlɩ̀ á yukʋran tə mama á yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Á dànà ká pa fən ja aba. Á kʋkwa zənbii tə nə dáá». ");
INSERT INTO nnw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lìù tə mama, ʋ nə wá swɩ̀n lɩ̀à yáá con nə də, ʋ yə̀ə́ à mʋ̀ Zwezi, à də wá bɩrɩ à nyɩna Yɩɩ, ʋ nə wulə Yɩɩ *sàń nə, də ʋ yɩ à mʋ̀ cɩ́gá nə tɩ wá. ");
INSERT INTO nnw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yá lìù tə, ʋ nə bɩrɩ lɩ̀à yáá con də, ʋ yə̀rì nə, à də wá bɩrɩ à nyɩna Yɩɩ yáá con, ʋ nə wulə Yɩɩ sàń nə, də à də yə̀rì wá». ");
INSERT INTO nnw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á dànà ká bʋ́n də, kʋ yɩ à twí, sə à kə bɩcan sìə́ tɩa yuu wa. Kʋ tà à twí kʋ mʋ̀ yɩrɩ, kʋ yɩ lagʋrɩ sɩ̀ʋ́ nə, à ja bà. ");
INSERT INTO nnw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","À twi, sə à kə pwɩa lɩ̀à pwərə wa: Sə bìú zɩgɩ ʋ nyɩna nə, sə bʋ̀á zɩgɩ ʋ nuu nə, sə bikɩnɩ zɩgɩ ʋ barɩ nuu nə. ");
INSERT INTO nnw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Lìù dʋŋa wá yà ʋ dìə̀ lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Lìù tə, ʋ nə swə ʋ nuu də ʋ nyɩna, ʋ doni nə, kʋ tíú tə wà mɛ, sə ʋ ya à karbɩa tə wa lìù. Lìù tə, ʋ nə swə ʋ bìú, nə à yə̀ə́ ʋ bʋ̀á ʋ doni nə, kʋ tíú tə wà mɛ, sə ʋ ya à karbɩa tə wa lìù. ");
INSERT INTO nnw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Lìù tə, ʋ nə pɩ̀à, sə ʋ twá nə, kʋ tíú mɛ, sə ʋ sɛ̀e ʋ də́ càn də nə, kʋ ja vəli ʋ tɩan dagarʋ tə yuu wa. Kʋ nə tà nətʋ, ʋ wà mɛ, sə ʋ ya à karbɩa tə wa lìù. ");
INSERT INTO nnw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Lìù tə, ʋ nə pɩ̀à, sə ʋ jon ʋ mɩɩ tə, ʋ wá kwɩ̀n kʋ nə. Yá lìù tə, ʋ nə wá kwɩ̀n ʋ mɩɩ tə nə à mʋ̀ yɩrɩ, ʋ wá na mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lìù tə, ʋ nə sɛ̀e aba, kʋ tíú sɛ̀e nə. Yá lìù tə, ʋ nə sɛ̀e nə, kʋ tíú sɛ̀e lìù tə, ʋ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Lìù tə, ʋ nə jɩn Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə zəni, ʋ nə yɩ Yɩɩ nii sʋ̀sʋ̀nʋ̀ yɩrɩ, Yɩɩ wá pa wá Yɩɩ nii sʋ̀sʋ̀nʋ̀ ŋwɩ́rán. Yá lìù tə, ʋ nə jɩn cɩ́gá tíú tə zəni, ʋ nə yɩ cɩ́gá tíú yɩrɩ, Yɩɩ wá pa wá cɩ́gá tíú ŋwɩ́rán. ");
INSERT INTO nnw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Lìù nə kwán nazunə wùrú zʋŋa tətə, ʋ pa à karbiu tə don jɩmurinyʋga tətə nə, ʋ nə yɩ à karbiu tə yɩrɩ, cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ʋ bá kwɩ̀n ʋ ŋwɩ́rán nə Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Máŋá tə wa, Zwezi bɩrɩ kàrà təntə ʋ karbɩa fugə bələ tə nə, ʋ zwɛ̀e, ʋ dàń lɛ ʋ va, sə ʋ kàrɩ̀ Yɩɩ sʋ̀ràn tə nə yɩ nətʋ, ʋ bɩrɩ lɩ̀à tə nə, kʋ mʋ̀ nagwanaa təntə tɩan tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kʋ máŋá təntə wa, də Zwan wulə bàń dìə̀ wa. Ʋ zɩgɩ ʋ bàń dìə̀ tə wa, ʋ nì də, ba swɩ̀n Zwezi-*Kərisə tʋtʋŋɩ tə yoo. Ʋ dàń ma lɩ ʋ karbɩa tə duən, sə ba va ba bwe Zwezi, ba jə́n: ");
INSERT INTO nnw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«N mʋ̀ nə yɩ lìù tə, Yɩɩ nə swɩ̀n də, ʋ wá bà, nə à yə̀ə́ nə mɛ, sə nə dɩ̀àn ʋ don?» ");
INSERT INTO nnw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Zwezi ma le ba, ʋ wʋ́: «Á vələ á man á bɩrɩ Zwan nə kʋ tə, á nə nì, á ga na də, à fwa: ");
INSERT INTO nnw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lilirən yɩ́á súrí, gwànɩ́ vəli, dayaran dayan zwɛ̀e, ba ga jì ləzwənzəŋə, zɩbʋŋa zɩan súrí, tɩga bwin ba naŋa. Yá zʋra də ga nə̀ń Yɩɩ sʋywáŋʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pupwən lɩ̀à nə ya lɩ̀à tə, ba nə bá vɩ nə, ba dʋgʋ kʋ tə yɩrɩ, à nə fwa». Máŋá tə wa, Zwan karbɩa tə nə vìí, Zwezi zàn ʋ wulə ʋ swɩ̀n Zwan yoo, ʋ bɩrɩ lalʋʋ tə nə, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","«Ləzwənyiri nətə nə, á vəli á balɩ kasɔɔ lanworu tə wa? Kʋ tà lìù tə, ʋ nə nyɩn ndə mancanɩ nə, vʋʋ nə vuvugə. ");
INSERT INTO nnw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ləzwənyiri nətə nə, á dàń vəli á na? Kʋ tà lìù tə, ʋ nə zʋa ganmʋla. Ba tə, ba nə zwɩ ganmʋla, tà ba wulə pɛ̀egá dii wa naaa? ");
INSERT INTO nnw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ləzwənyiri nətə nə, á dàń vəli á na? Kʋ tà Yɩɩ nii *sʋ̀sʋ̀nʋ̀, naaa? Awo! À mʋ̀ nə swɩ̀n kʋ á con də, kʋ lìù təntə dwə Yɩɩ nii sʋ̀sʋ̀nʋ̀ tətə. ");
INSERT INTO nnw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kʋ lìù təntə yoo pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Nə̀ń, à mʋ̀ Yɩɩ nə tʋn à tʋ̀tʋ̀nʋ̀, sə ʋ də́ n yáá, sə ʋ kwɛn n cwəŋə tə ʋ pa mʋ́›. ");
INSERT INTO nnw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lʋʋ ləzoni wa, ba nə lʋrɩ, lìù wà lá yɩn, ʋ nə doni Zwan-Batisə. Yá lìù tə, ʋ nə yɩ ləzoni tə mama nəmanbiə Yɩɩ pàrɩ̀ tə wa, tə dwə wá. ");
INSERT INTO nnw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kʋ nə zɩgɩ Zwan-Batisə máŋá tə wa, kʋ ja bà zə̀n, lɩ̀à pɩ̀à, sə ba də́ Yɩɩ pàrɩ̀ tə ba pa ba tɩ̀àn nə də dɩ̀àn. Yá kʋ yɩ lɩ̀à tə, ba nə yɩ dɩ̀àn tɩ̀án nə nɩ kʋ. ");
INSERT INTO nnw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yɩɩ pàrɩ̀ tə yoo dí yáá kʋ pʋ́pʋ́nɩ́ Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, sagɩ tə wa. Yɩɩ nii sʋ̀sʋ̀nà tə mama ga swɩ̀n kʋ yoo, kʋ ja bà kʋ yí Zwan máŋá tə. ");
INSERT INTO nnw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Də á nə pɩ̀à, sə á sɛ̀e à nii, Zwan yɩ kʋ mʋ̀ Eli tə, ba nə dí yáá ba swɩ̀n ʋ yoo. ");
INSERT INTO nnw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni!» ");
INSERT INTO nnw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Zə̀n ləzoni tə yɩ à wá tì ba, à ma man də bɛ̀eɛ̀e? Ba nyɩn ndə bìsɩ́ná nə, ba nə jə̀ə́ yəə kanporu wa, ba ga boŋə duən, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Nə wúrú wii nə kə á nə, sə á sa, á ga wà sɛ̀e! Nə nun pucʋnɩ nuŋi nə pa aba, á ga wà kwi!› ");
INSERT INTO nnw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mə zə̀n lɩ̀à tə də yɩ nətʋ. Zwan nə twi, ʋ ma ba wodiu nəzəŋu də́, ʋ ga ba swana nywɩ̀n, ba swɩ̀n, ba wʋ́, də *zinə nə jə wá. ");
INSERT INTO nnw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kʋ kwa nə, *Ləzwənə-Biu tə nə twi, ʋ mʋ̀ ma də́ wodiu nəzəŋu, ʋ ga nywɩ̀n swana, ba kʋ́ʋ̀ swɩ̀n, ba wʋ́: ‹Nə̀ń, bɛɛ wà tə, ʋ yoyuu nə yɩ ka də́, də ka nyʋ swana, ka sú. Ʋ yɩ lanpolɩna tə də cʋna lɩ̀à tə dabɛɛ!› Yá wʋbʋŋa tíú yɩ ʋ yàá twá ʋ yofwaŋa nə, ʋ ma bɩrɩ də, ʋ jə wʋbʋŋa». ");
INSERT INTO nnw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Zwezi dàń wulə ʋ caga lɩ̀à tə nii nə, ʋ nə tʋn ʋ yomɩlan tə zʋnɩ ba tɩan wa, ba ga wà ba kwa vəvəri, ba ma sá ba cʋna tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yomɩlan tə, tə nə fwa á pwərə wa, yiri yà nə fwa Tirə də Sidon tɩan tə wa, tə tɩan təntə lɩ̀à yà wá zʋ pucʋnɩ ganan, ba ga pɩ̀rɩ̀ ba yɩra də tʋ̀nʋ̀. Kʋ mʋ̀ nə pɩn, càn wá tʋ á mʋ̀ Korazɩn tɩ̀án yuu wa! Kʋ mʋ̀ nə pɩn, càn wá tʋ á mʋ̀ Bɛtəsayɩda tɩ̀án yuu wa! ");
INSERT INTO nnw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mə kʋ mʋ̀ nə pɩn, à swɩ̀n kʋ á con: Bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə, Tirə də Sidon tɩ̀án càn ba yí á mʋ̀ tɩan bələ təntə lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sə á mʋ̀ Kapɛrənayimə tɩ̀án, á bʋŋa də, á yuu wá dwen yɩɩ nə, naaa? Abada! Yomɩlan tə, tə nə fwa á pwərə wa yiri, yà nə fwa *Sodɔmə wa, Yɩɩ yà bá cʋ̀gʋ̀ kʋ tɩʋ tə. Kʋ mʋ̀ nə pɩn, á wá mʋ̀rɩ̀, á cú á yí mən dìə̀. ");
INSERT INTO nnw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mə kʋ mʋ̀ nə pɩn, à swɩ̀n kʋ á con: Bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə wá yí, á wá də́ càn, á doni Sodɔmə tɩ̀án». ");
INSERT INTO nnw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kʋ máŋá tə wa, Zwezi swɩ̀n Yɩɩ con, ʋ wʋ́: «À nyɩna tə, n nə tɩ lanworu də tɩa, à kəni n lɛ̀eɛ̀e. N bɩrɩ yìə̀n tətə lɩ̀à tə nə, ba nə mun ba tɩ̀àn. Yá n ga sə̀gə̀ tə ba tə nə bʋŋa də, ba yɩ wʋbʋŋa də yənu tɩ̀án yáá nə. ");
INSERT INTO nnw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","À nyɩna, n mʋ̀ cɩ́gá nə swə, sə kʋ nətʋ tə tʋn». ");
INSERT INTO nnw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À nyɩna Yɩɩ ken wiən tə mama à jɩɩn wa. Lìù mama yə̀rì Yɩɩ-Biu tə, də kʋ nə tà à nyɩna Yɩɩ tə. Lìù də mama ma yə̀rì à nyɩna Yɩɩ tə, də kʋ nə tà Yɩɩ-Biu tə, də lìù tə, Yɩɩ-Biu tə nə swə, sə ʋ súrí ʋ yɩ́á ʋ bɩrɩ wá. ");
INSERT INTO nnw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Á bɩ̀àn à con, á mʋ̀ lɩ̀à tə mama, á nə zɩn á yun zɩla á gwàrɩ̀! Yá à wá pa aba sìə́. ");
INSERT INTO nnw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Á yá, sə à kə aba cwəŋə nə, ndə nɩan nə, tə tíú nə ken daʋ tə bɩan nə, ʋ vaŋa, à nə yɩ pubwanʋ, də ka mun tɩ̀án nə à jə tə yɩrɩ. Á ga wá na sìə́ á pa á tɩ̀àn nə. ");
INSERT INTO nnw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","À bɩan daʋ tə, kʋ nə wá kə aba cwəŋə nə, tə ba dun jə. Yá kʋ zɩŋʋ ga ba cà də». ");
INSERT INTO nnw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dɩan təntə nii nə, Zwezi də ʋ karbɩa tə twá kárɩ́ wa, ba kɛ̀eń *Zwifə-ba *sìə́ dɩɩn nə. Ʋ karbɩa tə kén mɩna yun, ba dɩŋɩ, niən yà nə jə ba yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kʋ máŋá tə wa, *Farɩzɩan-ba nə nɩ kʋ nətʋ, ba swɩ̀n Zwezi con, ba wʋ́: «Nə̀ń, n karbɩa tə nə fwa kʋ tə, kʋ nə wà mɛ, sə ba fwa sìə́ dɩɩn nə». ");
INSERT INTO nnw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Zwezi ma le ba, ʋ wʋ́: «Á wà Yɩɩ sagɩ tə kàrɩ̀, á na kʋ tə, pɩ̀ʋ́ *Davidə tətə nə fwa dɩɩn don nə, də ʋ kwa lɩ̀à tə, də niən nə jɩn ba, naaa? ");
INSERT INTO nnw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ʋ zʋa Yɩɩ *dìə̀ tə wa. Yá ʋ mʋ̀ də ʋ kwa lɩ̀à tə dí dipɛn tə, kʋ nə wulə Yɩɩ dìə̀ tə wa, kʋ yà ga wà mɛ, sə ba də́ kʋ. Yá nə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, yà ga pa cwəŋə Yɩɩ *joŋwana tə cɩcɩ nə, sə ba mʋ̀ nə də́ Yɩɩ dìə̀ dipɛn təntə. ");
INSERT INTO nnw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nə à yə̀ə́, kʋ yɩ á wà Yɩɩ nii tə, ʋ nə pɩn Moyizə nə, sagɩ tə kàrɩ̀, á na də, Yɩɩ joŋwana tə ba sìə́ dɩɩn tə nii zìlí, kʋ ga tà cʋna ba tʋn Yɩɩ yáá con, də tʋtʋnan tə, ba nə tʋŋa Yɩɩ dìə̀ tə wa, kʋ dɩɩn təntə nə, naaa? ");
INSERT INTO nnw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yá à mʋ̀ dàń nə swɩ̀n kʋ á con də, won don wulə yəbə, kʋ nə dwə Yɩɩ dìə̀ tə. ");
INSERT INTO nnw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹À ba á *joŋi pɩ̀à, à nə pɩ̀à, sə á yà lɩ̀à tə, á nə dəri yinəgə zənzən›. Də á yà nə nì sʋ̀ràn təntə də̀ń, á yà bá manwarɩ á bʋ̀rɩ̀ lɩ̀à tə duən, ba nə wà cʋ̀gʋ̀, bʋ̀rà á zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","*Ləzwənə-Biu tə nə tɩ sìə́ dɩɩn tə». ");
INSERT INTO nnw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zwezi kʋ́ʋ̀ nan lá, ʋ va *Zwifə-ba *jə́rə́ dìə̀ don wa. ");
INSERT INTO nnw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Bɛɛ don yà wulə lá, ʋ jɩɩn nə tɩga. Lɩ̀à duən ma bwe Zwezi, ba wʋ́: «N jə cwəŋə, sə n zwɛ̀e yayɩgʋ *sìə́ dɩɩn nə, naaa?» Yá kʋ yà yɩ ba pɩ̀à, sə ba twá nətʋ, ba ma swɩ̀n ba zɩgɩ Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Zwezi ma le ba, ʋ wʋ́: «Lìù tə̀lə́ á wa, ʋ nə jə piə nədʋ cɩcɩ, ka ga tʋ gwàlʋ́ wa, kʋ nə lù, sìə́ dɩɩn nə, yá ʋ ga yá ka, ʋ bá lɩ. ");
INSERT INTO nnw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sə ləzwənə ba piə kʋkwa zənzən, naaa? Kʋ mʋ̀ nə pɩn, nə jə cwəŋə, sə nə fwa kʋ tə nə ziən, sìə́ dɩɩn nə». ");
INSERT INTO nnw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Zwezi dàń ma swɩ̀n bɛɛ tə con, ʋ wʋ́: «Làrɩ́ n jɩɩn tə à con!» Bɛɛ tə ma làrɩ̀ kʋ, kʋ ga jì nəzəŋu ndə kʋ don tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","*Farɩzɩan-ba nə nɩ kʋ nətʋ, ba nan ba vìí. Ba dàń vəli ba kə duən nə, ba vʋrʋ ba jə́n, ba nə wá twá nətʋ, ba ma gʋ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Máŋá tə, Zwezi nə lwarɩ kʋ nətʋ, ʋ kɛ̀eń kʋ bwálɩ́ təntə wa. Yá lalʋʋ púə́ ʋ kwa. Ʋ pɩn yazurə yayɩŋa tə mama nə. ");
INSERT INTO nnw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yá ʋ dàń ga dù sú ba nii nə, sə ba dàn ká swɩ̀n kʋ tə, ʋ nə yɩ ba bɩrɩ lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mə kʋ twá nətʋ, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi nii sʋ̀ràn tə ma sú: ");
INSERT INTO nnw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nə̀ń, à tʋ̀tʋ̀nʋ̀ tə nə, à nə kúrí, ʋ mʋ̀ nə yɩ lìù tə, à nə swə, ʋ nə poli à pùə́. À wá pa à *Siŋu tə wá. Yá ʋ ga wá bɩrɩ à cɩ́gá tə lʋʋ dwíə́ tə mama nə. ");
INSERT INTO nnw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ʋ də lìù bá tʋ́tʋ̀nɩ́ duən, ʋ ga bà zɩ̀n ʋ kori, ʋ kə yɩɩ nə. Ba bá na wá də ʋ zɩga coŋi yuu, ʋ swɩ̀n sʋ̀ràn. ");
INSERT INTO nnw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ʋ bá cʋ̀gʋ̀ lìù tə, ʋ nə ba dɩ̀àn jə, ʋ nə nyɩn ndə mɩʋ nə, kʋ nə kén kʋ zìə̀. Yá ʋ bá sɛ̀e ʋ cʋ̀gʋ̀ lìù tə, ʋ nə nyɩn ndə cànʋ́ nə, ʋ mən nə ba dáá. Mə nətʋ nə, ʋ wá tʋn wuuu, kʋ ja vələ, lɩ̀à tə nə wá sɛ̀e Yɩɩ cɩ́gá tə. ");
INSERT INTO nnw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yá lʋʋ dwíə́ tə də mama wá kə ba yala ʋ yuu wa». ");
INSERT INTO nnw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kʋ kwa nə, ba jɩn bɛɛ don, ba bà Zwezi con. Bɛɛ təntə yà yɩ *zinə nə ja, ʋ ga yɩ liliu də bəru. Zwezi pɩn wá yazurə, yá ʋ súrí ʋ nii ʋ wulə ʋ swɩ̀n, ʋ ga na wiən. ");
INSERT INTO nnw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kʋ gwárɩ́ lalʋʋ tə. Yá lɩ̀à tə mama dàń ga swɩ̀n Zwezi yoo, ba wʋ́: «Ʋ yɩ pɩ̀ʋ́ *Davidə nàʋ́ tə naaa?» ");
INSERT INTO nnw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yá *Farɩzɩan-ba tə nə nɩ kʋ nətʋ, ba swɩ̀n, ba wʋ́: «Ʋ wàá *zinə ʋ lɩ lɩ̀à yuu wa, kʋ nə yɩ Beləzebilə, ʋ nə yɩ zinə tə mama pɩ̀ʋ́, nə pɩn wá tə dɩ̀àn təntə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Zwezi nə yə̀ə́ ba pubʋŋɩ təntə, ʋ dàń le ba, ʋ wʋ́: «Payuu lɩ̀à nə zɩga duən nə, kʋ payuu tə wá cʋ̀gʋ̀. Tɩʋ, nə à yə̀ə́ dìə̀ tɩ̀án nə zɩga duən nə, tə tʋrɩ nə ga. ");
INSERT INTO nnw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Də *Sɩtana nə dɩŋɩ Sɩtana, ʋ yɩ ʋ zɩga ʋ tətə nə. Yá ʋ ga yɩ ʋ tətə payuu nə ʋ cʋ̀gà. ");
INSERT INTO nnw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Á wʋ́, də kʋ yɩ Beləzebilə, zinə pɩ̀ʋ́ tə nə pɩn nə dɩ̀àn tə. Kʋ mʋ̀ nə pɩn, à wàá zinə à lɩ lɩ̀à yuu wa. Sə á bɩa tə də yɩ wàà dɩ̀àn nə, ba ma lɩ zinə tə? Mə kʋ mʋ̀ nə pɩn, á bɩa tə tətə nə wá bʋ̀rɩ̀ á bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yá kʋ cɩ́gá nə yɩ kʋ twá Yɩɩ-*Siŋu tə dɩ̀àn, à ma lɩ zinə tə, kʋ nətʋ tə bɩrɩ də, Yɩɩ də́ ʋ pàrɩ̀ lɩ̀à yuu wa á tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Lìù tə̀lə́, ʋ nə wá zʋ ladɩa dìə̀, ʋ ŋʋ ʋ wiən, kʋ nə tà ʋ dí yáá, ʋ vwa ladɩa tə ʋ tún. Kʋ kwa nə, ʋ dàń wá wànɩ́ ʋ pɛ̀e kʋ tíú tə dìə̀ wiən tə mama. ");
INSERT INTO nnw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Lìù tə, ʋ nə tə̀lə́ à kwa, zɩga à nə. Yá lìù tə, ʋ nə ba à nə saŋa, ʋ kəni duən nə, kʋ tíú yɩ ʋ làgà. ");
INSERT INTO nnw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mə kʋ mʋ̀ nə pɩn, à swɩ̀n kʋ á con: Yɩɩ wá kwɛn ləzoni cʋna yiri mama, də ba tʋran yiri mama, ba nə twɩn ʋ mʋ̀ Yɩɩ, ʋ lɩ ʋ mʋ̀ də ba pwərə wa. Yá lìù tə, ʋ nə twɩn Yɩɩ-Siŋu tə, ʋ cʋna ba kwɛn tə nan, abada. ");
INSERT INTO nnw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lìù tə mɛ, ʋ nə wá swɩ̀n sʋgʋ, kʋ nə zɩga *Ləzwənə-Biu tə nə, kʋ tíú wàá ʋ cʋna kwɩʋn ʋ nɩ. Yá lìù tə, ʋ nə swɩ̀n sʋgʋ ʋ zɩgɩ Yɩɩ-Siŋu tə nə, kʋ tíú wàrɩ̀ ʋ cʋna kwɩʋn ʋ nɩ, zə̀n də jwɩan, abada». ");
INSERT INTO nnw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Tɩ̀ʋ́ yɩ ba twá kʋ bɩa nə, ba ma lwarɩ kʋ tɩyiri. Kʋ mʋ̀ nə pɩn, tɩ̀ʋ́ nə ziən, kʋ bɩa də ziən, tɩ̀ʋ́ nə ba ziən, kʋ bɩa də ba ziən. ");
INSERT INTO nnw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Á nyɩn ndə dəkwaa dwíí nə! Á wʋlʋŋʋ tə nə pɩn, á wàrɩ̀ yozəŋu á swɩ̀n á nii wa. Á tətə yə̀ə́ də, nii sʋgʋ nə yàá bɩrɩ kʋ tə, kʋ nə wulə waa nə. ");
INSERT INTO nnw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ləzwənzəŋu yàá pɩn yozəŋə naŋa ʋ waa con. Yá ləzwənkʋkwɩʋn də yɩ yokʋkwɩnan nə, ʋ yàá pɩn tə naŋa ʋ waa con. ");
INSERT INTO nnw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","À mʋ̀ nə swɩ̀n kʋ á con: Bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə, Yɩɩ wá bʋ̀rɩ̀ ləzoni bʋ̀rà ba sʋ̀ràn tə mama yɩrɩ, ba nə swɩ̀n, tə nə yɩ tʋtʋ. ");
INSERT INTO nnw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kʋ dàń yɩ kʋ wá twá n nii sʋ̀ràn nə, ba ma yəni də, n yɩ cɩ́gá tíú Yɩɩ yáá con. Yá n nii sʋ̀ràn nə wá pa, ba lwarɩ də, Yɩɩ wá bʋ̀rɩ̀ n bʋ̀rà, sə ʋ cʋ̀gʋ̀ mʋ́». ");
INSERT INTO nnw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","*Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə duən də *Farɩzɩan-ba tə duən twi, ba yí Zwezi, ba swɩ̀n, ba wʋ́: «Karnyɩna, fwa Yɩɩ dɩ̀àn mɩmɩnʋ, sə nə yɩ́á na kʋ!» ");
INSERT INTO nnw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Zwezi ma le ba, ʋ wʋ́: «Á mʋ̀ zə̀n lɩ̀à tə! Á yɩ lakʋkwɩnan, á ba Yɩɩ cɩcɩ nə twá. Yá á mʋ̀ nə pɩ̀à, sə á na Yɩɩ dɩ̀àn mɩmɩnʋ. Á bá na mɩmɩnʋ nədʋ də tətə, də kʋ nə tà yoo tə, kʋ nə yí Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Zwʋnasə. ");
INSERT INTO nnw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kʋ Zwʋnasə təntə nə fwa dɩan batwa, tɩtɩn də yɩcaʋ, fəli pùə́ wa. Mə nətʋ nə, *Ləzwənə-Biu tə də wá fwa ləbəri wa. ");
INSERT INTO nnw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə, Ninivə tɩ̀án wá zàn ba zɩgɩ zə̀n lɩ̀à ba tə nə. Ba wá bʋ̀rɩ̀ á bʋ̀rà, sə ba cʋ̀gʋ̀ aba, ba mʋ̀ nə sɛ̀e, ba vəvərə ba kwa ba ma sá ba cʋna, Zwʋnasə nə bɩrɩ ba Yɩɩ sʋgʋ tə yɩrɩ. Yá lìù ga wulə yəbə, ʋ nə dwə Zwʋnasə. ");
INSERT INTO nnw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Etiyopi pakan tə wà ja zɩgɩ ʋ dàn, sə ʋ ma nan yɩŋʋnɩ, ʋ bà ʋ cʋgʋ pɩ̀ʋ́ *Salʋmʋn yənu sʋ̀ràn tə. Bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə, kʋ mʋ̀ kan təntə wá zɩgɩ á mʋ̀, zə̀n lɩ̀à ba tə nə, ʋ wá bɩrɩ aba də, á tə̀lə́ cɩ́gá wa. Yá lìù ga wulə yəbə, ʋ nə dwə Salʋmʋn». ");
INSERT INTO nnw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Máŋá tə wa, *zini nə nan kʋ yá lìù, kʋ yàá jijiri kasɔɔ lanworu wa, kʋ ma pɩ̀à bwálɩ́, sə kʋ kə kʋ yuu lá, yá kʋ bá yizwɩa bwálɩ́ na. ");
INSERT INTO nnw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kʋ mʋ̀ nə pɩn, kʋ yàá swɩ̀n, kʋ wʋ́: ‹À wá pìí, à va à dìə̀ tə wa, à nə nan à yá.› Kʋ pìí kʋ bɩ̀àn, də dìə̀ tə zwarɩ, kʋ kwɛn zəni zəni kʋ tún lá. Yá lìù ga tə̀lə́ kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kʋ dàń wá va, kʋ ja zinə barpɛ duən, tə waa nə lɩŋa tə doni kʋ, kʋ súrí kʋ tɩ̀àn nə. Tə dàń wá zʋ tə jə̀ə́, yá ʋ mʋ̀ lìù təntə dí yáá wá kʋkwanɩ ʋ sɩ́ʋ́n. Mə kʋ wá yà nətʋ, kʋ pa zə̀n lakʋkwɩnan tə nə». ");
INSERT INTO nnw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Kʋ kwa nə, Zwezi zʋa dìə̀ wa. Máŋá tə wa, ʋ nə wulə ʋ swɩ̀n də lɩ̀à tə, ʋ nubɩa də ʋ nuu twi, ba zɩga kàrá wa, sə ba na wá. ");
INSERT INTO nnw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lìù don ma swɩ̀n Zwezi con, ʋ wʋ́: «Cʋgʋ zəni, n nuu də n nubɩa wulə kàrá wa, ba pɩ̀à, sə ba swɩ̀n n con». ");
INSERT INTO nnw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zwezi ma le kʋ tíú tə, ʋ wʋ́: «Wàà nə yɩ à nuu, bə̀rə́ ga nə yɩ à nubɩa?» ");
INSERT INTO nnw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Zwezi ma zɩ̀n ʋ jɩɩn, ʋ làrɩ̀ ʋ karbɩa tə con, ʋ ga swɩ̀n, ʋ wʋ́: «Á ywàŋá, à nuu də à nubɩa nə, ba wulə yəbə. ");
INSERT INTO nnw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kʋ yɩ lìù tə mɛ, ʋ nə fwa kʋ tə, à nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ *sàń nə pɩ̀à, kʋ tíú nə yɩ à nubiu, də à nakʋa, də à nuu». ");
INSERT INTO nnw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kʋ dɩɩn təntə nə, Zwezi nan dìə̀ tə wa, ʋ va ʋ jə̀ə́ mʋnaa tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lɩ̀à zənzən kʋ́ʋ̀ púə́ ʋ yuu nə. Ʋ dàń ma kʋ́ʋ̀ zàn, ʋ zʋ nɩ́á yuu bori wa, ʋ jə̀ə́ lá. Lalʋʋ tə kʋ́ʋ̀ púə́ nɩ́á tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ʋ dàń ma twá zwansɩsarɩ nə, ʋ ma kàrɩ̀ ba yìə̀n zənzən, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","«Wodùrú don nə nan, sə ʋ dù. Ʋ nə yí ʋ mɩ́ wobɩa tə kárá tə wa, tə wobɩa tə vàn don tʋa cwəŋə yuu. Zənbii ma bà, tə də́ tə. ");
INSERT INTO nnw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tə vàn don də tʋa kapataran tɩa wa, tɩran nə ba dáá lá. Kʋ bwálɩ́ tə nə, wobɩa tə nan lala, kʋ nə yɩ tɩtalʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Máŋá tə, yɩɩ nə bɩga, kʋ dí tə wobii tə, tə ga tɩ tə kʋ̀, tə dəkurən nə wà tɩa zwɩ zəni yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wobɩa tə vàn don də kʋ́ʋ̀ tʋa casʋran tɩa wa. Tə nə pén máŋá tə wa, casʋran tə boru tə pú wobii tə yuu nə, tə dàń ga sɩ̀nɩ̀ tə tɩ. ");
INSERT INTO nnw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yá wobɩa tə vàn don tʋa tɩa nəzəŋu wa, tə mʋ̀ wobɩa təntə zàn tə zɩn bɩa. Tə duən zɩn bɩa bíí. Tə duən də zɩn bɩa sapwɩtwa. Tə duən də zɩn bɩa fɩtwa. ");
INSERT INTO nnw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni!» ");
INSERT INTO nnw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zwezi karbɩa tə fàrɩ́ ba yí ʋ yɩra, ba bwe wá, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, n twá zwansɩsarɩ nə, n ma swɩ̀n lɩ̀à tə con?» ");
INSERT INTO nnw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Zwezi ma le ba, ʋ wʋ́: «Á mʋ̀ wàá Yɩɩ pàrɩ̀ yìə̀n tə, tə nə sə̀gə̀ tə də̀ń, á nì á pɩn á tɩ̀àn nə. Yá ba duən tə ba kʋ pubʋŋa təntə jə. ");
INSERT INTO nnw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kʋ mʋ̀ nə pɩn, lìù tə, ʋ nə jə pubʋŋa mancɩn, Yɩɩ wá súrí kʋ, ʋ ga wá yà pubʋŋa tíú. Yá lìù tə, ʋ nə ba pubʋŋa jə, Yɩɩ wá jon mancɩn tə tətə, ʋ nə jə. ");
INSERT INTO nnw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mə kʋ mʋ̀ nə pɩn, à twá zwansɩsarɩ à ma swɩ̀n lɩ̀à tə con, ba yɩ́á nə cə̀ lá, ba ga ba na, ba cʋga, yá ba ga ba kʋ də̀ń nə̀ń tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mə kʋ twá nətʋ, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi nii tə ma sú. Ʋ swɩ̀n, ʋ wʋ́: ‹Á zɩan wá nì zəni, á ga ba nì tə də̀ń. Á wá ywàŋá zəni, á ga ba won mama na. ");
INSERT INTO nnw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ba lɩ̀à təntə yáá tə̀lə́ də won mama. Ba zɩan swɩn. Ba yɩ́á pú. Ba ba pɩ̀à, sə ba yɩ́á də na won mama. Ba ga ba pɩ̀à, sə ba nì yoo. Ba mʋ̀ nə ba pɩ̀à, sə ba lwarɩ yoo ba pubʋŋa wa. Ba mʋ̀ nə kʋ́ʋ̀ bá vəvərə ba kwa ba ma sá ba cʋna, sə à mʋ̀ Yɩɩ zwɛ̀e ba yayɩran tə›.» ");
INSERT INTO nnw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Zwezi kʋ́ʋ̀ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á mʋ̀ dàń yɩ pupwən lɩ̀à, á mʋ̀ yɩ́á nə na lá, á zɩan də ga nə̀ń tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Yɩɩ nii *sʋ̀sʋ̀nà də cɩ́gá tɩ̀án dáá, ba nə sóní, sə ba yà na kʋ tə, á nə na á ga nə̀ń. Yá ba ga wà kʋ nɩ, ba ga wà tə nì də». ");
INSERT INTO nnw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nəŋə, wodùrú tə zwansɩsara tə də̀ń: ");
INSERT INTO nnw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lìù tə mama, ʋ nə cʋga Yɩɩ pàrɩ̀ sʋ̀ràn tə, ʋ ga ba kʋ də̀ń nə̀ń, yɩ ndə cwəŋə tə nə, wobɩa tə nə tʋa ka nii nə. *Sɩtana yàá bà, ʋ lɩ kʋ tə, kʋ nə tʋa ba waa nə. ");
INSERT INTO nnw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wobɩa tə nə tʋa kapataran tɩa tə wa, nə yɩ ndə lìù tə nə, ʋ nə nì Yɩɩ sʋgʋ tə, ʋ sɛ̀e lala də pupoli. ");
INSERT INTO nnw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yá Yɩɩ sʋgʋ tə wà ʋ mʋ̀ lìù təntə pubʋŋa tə wa zwɩ zənzən, ʋ ga ba dɩ̀àn jə kʋ wa. Yá càn nə yí wá, nə à yə̀ə́ ba nə wʋwalɩ wá Yɩɩ sʋgʋ tə yɩrɩ, ʋ yàá pìí ʋ yá Yɩɩ cwəŋə. ");
INSERT INTO nnw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wobɩa tə nə tʋa casʋran tə wa, nə yɩ ndə lìù tə nə, ʋ nə nì Yɩɩ sʋgʋ tə, yá lʋʋ wiən twara də ka pɩ̀à jɩjə nə súə́ ʋ pubʋŋa tə. Tə wiən təntə mɛ dàń yà pú Yɩɩ sʋgʋ yuu nə. Kʋ mʋ̀ lìù təntə con, Yɩɩ sʋgʋ tə wà də̀ń jɩn kʋ pa wá. ");
INSERT INTO nnw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yá wobɩa tə nə tʋa tɩa nəzəŋu tə wa, nə yɩ ndə lìù tə nə, ʋ yàá cʋgʋ sʋgʋ tə, ʋ ga sɛ̀e kʋ zəni. Ʋ dàń yàá tʋŋa yozəŋə, ndə wobɩa nə zɩŋa bɩa nətʋ. Kʋ don zɩn bɩa bíí. Kʋ don də zɩn bɩa sapwɩtwa. Kʋ don zɩn bɩa fɩtwa». ");
INSERT INTO nnw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Zwezi kʋ́ʋ̀ bɩrɩ zwansɩsara don, ʋ wʋ́: «Á nəŋə, kʋ tə nə nyɩn də Yɩɩ pàrɩ̀ tə. Bɛɛ don dùə̀ wodwii nəzəŋu ʋ kárá wa. ");
INSERT INTO nnw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tɩtɩn don nə, lɩ̀à nə dwɛ̀e máŋá wa, ʋ mʋ̀ bɛɛ təntə dʋŋʋ twi, ʋ dù gakʋkwɩʋn bɩa kárá tə wa, ʋ ga lɛ. ");
INSERT INTO nnw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Máŋá tə, wiən tə nə yí pwìí janʋ, gakʋkwɩʋn tə də nan, kʋ zɩga. ");
INSERT INTO nnw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bɛɛ tə tʋ̀tʋ̀nà ma bà, ba swɩ̀n ʋ con, ba wʋ́: ‹Yuu tíú, n yà dùə̀ wozəŋə n kárá tə wa, sə gakʋkwɩʋn kʋ tə də nan yə̀n nə?› ");
INSERT INTO nnw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ʋ ma le ba, ʋ wʋ́: ‹Kʋ yɩ dʋŋʋ nə fwa kʋ›. Tʋ̀tʋ̀nà tə ma pìí ba bwe wá, ba wʋ́: ‹N ba pɩ̀à, sə nə va nə mùrí kʋ gaʋ təntə, naaa?› ");
INSERT INTO nnw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Bɛɛ tə ma le ba, ʋ wʋ́: ‹Ɔn ɔn! Á nə mùrí gakʋkwɩʋn tə, á wá mùrí mɩna tə də, á kə lá. Kʋ mʋ̀ yɩrɩ nə, á dànà ká fwa kʋ! ");
INSERT INTO nnw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Á yaga tə mama, á pa, tə bɩ. Yá tə zagʋ máŋá nə yí, à dàń wá swɩ̀n wocerə tə con, à wʋ́: Á díə́ yáá, á gɩan gamʋʋ tə, á vwa púlə́ púlə́, sə nə kə mən nə! Á dàń ga kén mɩna tə, á kə pulu wa!› » ");
INSERT INTO nnw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zwezi kʋ́ʋ̀ bɩrɩ zwansɩsara don, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə yɩ ndə wobiu nəmaa nə, lìù nə tì ʋ dù ʋ kárá wa. ");
INSERT INTO nnw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kʋ mʋ̀ wobiu nəmaa tə nə yɩ wobɩa mama wa nəmaa. Yá kʋ dàń nə pén, kʋ yuu yàá doni tɩbii tə mama yun. Kʋ yàá fwa tɩ̀ʋ́, zənbii bà, tə fwa tə pwalan kʋ yuu wa». ");
INSERT INTO nnw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zwezi kʋ́ʋ̀ bɩrɩ zwansɩsara don, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə yɩ ndə sabwarɩ nə, kan nə ken mun zʋŋɩ batwa wa. Tə mama dàń ga zàn tə fʋlɩ». ");
INSERT INTO nnw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tə yìə̀n tə mama yɩ Zwezi twá zwansɩsarɩ nə, ʋ ma bɩrɩ tə lɩ̀à tə nə. Ʋ yàá ba yoo swɩ̀n, də kʋ nə tà ʋ twá zwansɩsarɩ nə. ");
INSERT INTO nnw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ʋ fwa kʋ nətʋ, sə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə sʋ̀ràn tə nii ma sú. Ʋ nə swɩ̀n, ʋ wʋ́: «À wá súrí à nii, à ma twá zwansɩsarɩ, nə à bɩrɩ ba yìə̀n tə, tə nə sə̀gə̀, máŋá tə wa, Yɩɩ nə fwa lʋʋ». ");
INSERT INTO nnw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Zwezi kɛ̀eń ʋ yá lalʋʋ tə, ʋ ga va sàń. Ʋ karbɩa tə ma pú ʋ kwa, ba va ba yí wá, ba ga wʋ́: «Gwin kárá tə gakʋkwɩʋn tə zwansɩsara tə də̀ń, n bɩrɩ nəba». ");
INSERT INTO nnw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Zwezi ma le ba, ʋ wʋ́: «Lìù tə, ʋ nə dwì mɩna nəzəŋə tə, nə yɩ *Ləzwənə-Biu tə. ");
INSERT INTO nnw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kárá tə nə yɩ lʋʋ. Wodwii nəzəŋu tə nə yɩ Yɩɩ pàrɩ̀ lɩ̀à tə. Gakʋkwɩʋn tə nə yɩ *Sɩtana lɩ̀à tə. ");
INSERT INTO nnw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dʋŋʋ tə, ʋ nə dwì kʋ mʋ̀ gaʋ təntə nə, yɩ Sɩtana. Woceri tə nə yɩ lʋʋ zaŋʋ. Tʋ̀tʋ̀nà tə, ba nə za wiən tə, nə yɩ Yɩɩ *malɩkɛ tə. ");
INSERT INTO nnw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nətʋ ba nə pùrì gakʋkwɩʋn tə, ba kəni mən nə, mə kʋ wá yà nətʋ, lʋʋ zaŋʋ dɩɩn nə. ");
INSERT INTO nnw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ləzwənə-Biu wá tʋn ʋ malɩkɛ. Tə wá lɩ lɩ̀à tə mama ʋ pàrɩ̀ tə wa, ba nə pɩn lɩ̀à duən twá ba nə, ba ma dʋgʋ Yɩɩ tə, ba jén, də ba tə, ba nə tʋŋa yokʋkwɩnan tə. ");
INSERT INTO nnw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yá tə ga wá dɩlɩ ba mən bwálɩ́ wa. Kʋ bwálɩ́ təntə wa, ba wá bubwi, ba ga dɩŋa ba jɩfwɩ ba fɩfaga. ");
INSERT INTO nnw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yá ba tə, ba nə yɩ cɩ́gá tɩ̀án, ba wá pəpəli ndə yɩcaʋ nə ba nyɩna Yɩɩ pàrɩ̀ tə wa. Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni!» ");
INSERT INTO nnw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə nyɩn ndə wiən tə, tə kwənə nə dáá, tə nə sə̀gə̀ kárá don wa. Bɛɛ ma na tə, ʋ tì ʋ kwɛn ʋ sə̀gə̀. Ʋ pùə́ nə poli zənzən tə, ʋ vəli ʋ yə̀ kʋ tə mama, ʋ nə jə, ʋ də́, ʋ ga pìí ʋ bà, ʋ yə̀ kʋ kárá təntə». ");
INSERT INTO nnw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə nyɩn ndə bayolu nə fwa nətʋ, də ʋ nə pɩ̀à kana bɩan zanan nəzəŋə. ");
INSERT INTO nnw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Máŋá tə, ʋ nə nɩ kʋ nədʋ, kʋ nə ziən zənzən, ʋ vəli ʋ yoli ʋ wiən mama, ʋ nə jə, ʋ ga bà, ʋ yə̀ kʋ mʋ̀ kana bɩan zàŋʋ́ təntə». ");
INSERT INTO nnw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə kʋ́ʋ̀ nyɩn ndə fəlijana nə. Ba yàá dɩlɩ gə̀gə̀lù mʋʋ wa, kʋ ga janɩ fələ yiri mama. ");
INSERT INTO nnw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Máŋá tə, kʋ nə súə́, fəlijana tə yàá van, kʋ ba lɩ bəbəru yuu, ba ga jə̀ń tɩa, ba kúrí fələ tə. Ba kəni fəlizəŋə tə fɩyaran wa, ba ga dʋga tə tə, tə nə ba ziən. ");
INSERT INTO nnw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mə nətʋ nə, kʋ wá yà lʋʋ zaŋʋ máŋá wa. *Malɩkɛ wá bà, tə pwɛ̀e wʋlʋnyɩna də cɩ́gá tɩ̀án duən nə, ");
INSERT INTO nnw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sə tə ma dɩlɩ ba mən bwálɩ́ tə wa. Kʋ bwálɩ́ təntə wa, ba wá bubwi, ba ga dɩŋa ba jɩfwɩ ba fɩfaga». ");
INSERT INTO nnw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Máŋá tə wa, Zwezi nə zwɛ̀e zwansɩsarɩ tə, ʋ bwe ʋ karbɩa, ʋ wʋ́: «Á nì tə yìə̀n tə mama də̀ń?» Ba ma le wá, ba wʋ́: «Awo». ");
INSERT INTO nnw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «*Zwifə-ba Yɩɩ nii *yənu tíú mama, ʋ nə jigə Yɩɩ pàrɩ̀ tə karbiu, nyɩn ndə dìə̀ tíú nə, ʋ nə lɩ wodʋra də wodwara ʋ wiən tə, tə kwənə nə dáá, wa». ");
INSERT INTO nnw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Máŋá tə wa, Zwezi nə swɩ̀n zwansɩsarɩ təntə ʋ zwɛ̀e, ʋ lɛ kʋ bwálɩ́ tə wa, ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ʋ dàń vəli ʋ nyɩna tɩʋ. Ʋ nə vəli ʋ yí lá, ʋ zʋa *Zwifə-ba *jə́rə́ dìə̀ wa, ʋ wulə ʋ kàrɩ̀ lantə. Yá kʋ dàń gwárɩ́ lɩ̀à tə mama, ba nə yɩn kʋ bwálɩ́ təntə wa. Ba ma swɩ̀n, ba wʋ́: «Yə̀n nə nə ʋ nɩ wʋbʋŋa kʋ tə? Yá kʋ yɩ kʋ twá nətə, ʋ ma fwa yomɩlan tə tə? ");
INSERT INTO nnw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kʋ tà ʋ mʋ̀ nə yɩ kapənta tə bìú tə, naaa? Ʋ nuu tə yɩrɩ nə tà Mari, naaa? Zwakə də Zwʋzɛfə də Simon də Zwidə tà ʋ nubɩa, naaa? ");
INSERT INTO nnw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yá ʋ nakwana tə mama mʋ̀ tətə yà tə̀lə́ nə tətəŋi wa, naaa? Yə̀n nə nə ʋ nɩ tə dɩ̀àn təntə?» ");
INSERT INTO nnw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yá kʋ mʋ̀ təntə dàń pɩn, ba yà ba wá sɛ̀e. Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Ba yàá zìlí Yɩɩ nii *sʋ̀sʋ̀nʋ̀ bwálɩ́ mama nə, yá ʋ nyɩna tɩʋ nə də ʋ dìə̀ wa, ba ba wá zìlí». ");
INSERT INTO nnw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kʋ bwálɩ́ tə wa, Zwezi wà yomɩlan zənzən fwa, ba nə ba Yɩɩ nii sɛ̀e tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kʋ mʋ̀ máŋá təntə wa, *Erodə, ʋ nə yɩ Galile nagwanaa tə yáá tíú, nì də, ba swɩ̀n Zwezi yoo. ");
INSERT INTO nnw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ʋ swɩ̀n ʋ kwa lɩ̀à con, ʋ wʋ́: «Kʋ yɩ *Zwan-Batisə nə pìí ʋ bwin ʋ nan. Mə kʋ mʋ̀ nə pɩn, ʋ wàá yomɩlan ʋ fwa». ");
INSERT INTO nnw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kʋ yɩ cɩ́gá, Erodə yà pɩn, ba ja Zwan, ba vwa ba kə bàń dìə̀ wa. Erodə yà fwa nətʋ, ʋ zʋnʋ Filipə kan Erodɩadə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Zwan yà swɩ̀n Erodə con, ʋ wʋ́: «Kʋ wà mɛ, sə n jon Erodɩadə n ma fwa n kan». ");
INSERT INTO nnw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erodə yà pɩ̀à cwəŋə, sə ʋ ma gʋ Zwan, yá lalʋʋ tə fən yà jə wá, ba yà nə bʋŋa də, Zwan ya Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dɩɩn don twi kʋ yí, kʋ nə yɩ Erodə lʋrʋ cànà dɩɩn. Erodɩadə bʋ̀á dàń ma sa candərə tə yáá con, Erodə pùə́ ga poli zənzən. ");
INSERT INTO nnw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ʋ dàń ma dù, ʋ wʋ́, ʋ wá pa wá kʋ tə mama, ʋ nə pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bʋ̀á tə nuu nə nì kʋ, ʋ swɩ̀n bʋ̀á tə con, sə ʋ va ʋ swɩ̀n Erodə con, ʋ wʋ́: «À pɩ̀à, sə n kə Zwan-Batisə yuu zʋŋa wa, n pa nə yəbə!» ");
INSERT INTO nnw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kʋ cʋ̀gʋ̀ pɩ̀ʋ́ Erodə pùə́, yá kʋ nə twá ʋ nikanɩ tə nə candərə tə yáá con, ʋ pɩn nii, sə ba pa kʋ bʋ̀á tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ʋ dàń ma tʋn lìù, sə ʋ gwəŋə Zwan yuu bàń dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba tún ʋ yuu tə zʋŋa wa, ba ja bà, ba pa bʋ̀á tə nə, ʋ ma jon kʋ, ʋ pa ʋ nuu nə. ");
INSERT INTO nnw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zwan karbɩa ma bà, ba tì ʋ tɩgɩ tə, ba gùrì. Yá ba ga va ba swɩ̀n Zwezi con, kʋ tə nə tʋn. ");
INSERT INTO nnw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Máŋá tə nə, Zwezi nə nì kʋ yoo təntə, ʋ nan lá nə. Ʋ vəli ʋ zʋ nɩ́á yuu bori, ʋ va bwálɩ́ nə, kʋ nə vàn kʋ nan kwa, ʋ cɩcɩ. Yá lalʋʋ tə nì kʋ. Ba dàń ma nan tɩan tə wa də nɛɛ, ba pú Zwezi kwa, ba vələ nɩ́á tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Máŋá tə wa, Zwezi nə nan nɩ́á yuu bori tə wa, ʋ nɩ lalʋʋ tə. Ba lɩ̀à tə yinəgə jɩn wá. Ʋ dàń ma wulə ʋ zwɛ̀e ba yayɩŋa yayɩran. ");
INSERT INTO nnw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Máŋá tə, tɩa nə yí, Zwezi karbɩa tə fàrʋ́ ba yí ʋ yɩra, ba wʋ́: «Máŋá wulə ka lɛ, yá bwálɩ́ tə ga ba yigə. Pa lalʋʋ tə pìí, kʋ va tɩan tə wa, kʋ yə̀ wodiu». ");
INSERT INTO nnw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zwezi ma le ba, ʋ wʋ́: «Ba wà mɛ, sə ba vìí. Á tətə pɩan ba wodiu, sə ba də́!» ");
INSERT INTO nnw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yá ba swɩ̀n ʋ con, ba wʋ́: «Nə mʋ̀ yɩ dipɛn bonu də fələ bələ cɩcɩ, nə nə jə». ");
INSERT INTO nnw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Á jana tə, á ja bà yəbə!» ");
INSERT INTO nnw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kʋ kwa nə, ʋ dàń ma pa nii lalʋʋ tə nə, ʋ wʋ́, kʋ jənə gaʋ tə yuu wa. Ʋ dàń ma tì dipɛn bonu tə də fələ bələ tə, ʋ zɩ̀n ʋ yáá ʋ kə yɩɩ nə, ʋ ga kə Yɩɩ lɛ̀eɛ̀e. Ʋ fʋ fʋ dipɛn tə, ʋ ga tì ʋ pa ʋ karbɩa tə nə, ba tàrɩ̀ lalʋʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ba lìù mama dí ʋ sú. Yá Zwezi karbɩa tə ga pɛ̀e tə mumunə tə, ba sú fɩyaran fugə bələ. ");
INSERT INTO nnw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ba tə mama nə dí nii yí ndə bara mʋ̀rʋ̀ bonu nə, kana də bìsɩ́ná nii ba lá nə də́. ");
INSERT INTO nnw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kʋ kwa nə, lala Zwezi kálʋ́ ʋ karbɩa tə, ʋ pa ba zʋ nɩ́á yuu bori tə wa. Ʋ pɩ̀à, sə ba dí yáá, ba va ba dɩ̀àn wá mʋnaa tə bəbəru tə don nii nə, sə ʋ ga kə lalʋʋ tə cwəŋə nə. ");
INSERT INTO nnw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yá máŋá tə nə, ʋ nə dʋgʋ lɩ̀à tə, ʋ dɩ̀gà paan yuu bwálɩ́ nə, kʋ nə nan kwa con, sə ʋ jʋn Yɩɩ. Tɩa yí, də ʋ cɩcɩ nə jə̀ń lá. ");
INSERT INTO nnw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nɩ́á yuu bori tə yà manwarɩ, kʋ wulə mʋnaa tə tətəŋi wa. Nɩkulə tə yà wulə tə mà kʋ, vʋʋ tə yà nə fuli kʋ zɩga ba nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tɩbɩnakʋnʋn wa, Zwezi zàn ʋ zɩga nɩ́á tə yuu wa, ʋ ma vəli ʋ karbɩa tə con. ");
INSERT INTO nnw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yá máŋá tə, ba nə nɩ wá, ʋ vəli nɩ́á tə yuu wa, fən zʋa ba zənzən, ba ga swɩ̀n, ba wʋ́: «Kʋ yɩ wojijiru!» Ba dàń ma wulə ba mà bayalan níə́, fən nə zʋa ba yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Zwezi ma swɩ̀n ba con lala, ʋ wʋ́: «Á dàŋá á jɩ̀àn! Kʋ yɩ à mʋ̀! Á dànà ká pa fən ja aba!» ");
INSERT INTO nnw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyɛrə ma swɩ̀n, ʋ wʋ́: «*Yuu-Tiu, kʋ nə yɩ n mʋ̀ cɩ́gá, pa, sə à də va nɩ́á tə yuu wa, à bà n con». ");
INSERT INTO nnw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Zwezi ma swɩ̀n, ʋ wʋ́: «Bàá yəbə!» Piyɛrə nan nɩ́á yuu bori tə wa, ʋ va nɩ́á tə yuu, ʋ vələ Zwezi con. ");
INSERT INTO nnw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yá máŋá tə nə, ʋ nə nɩ də vʋʋ tə dáá, fən zʋa wá. Yá máŋá tə, ʋ nə wulə ʋ mʋ̀rɩ̀ nɩ́á tə wa, ʋ mà nii, ʋ wʋ́: «Yuu-Tiu, jon nə!» ");
INSERT INTO nnw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lala, Zwezi te ʋ jɩɩn, ʋ ja wá, ʋ ga swɩ̀n, ʋ wʋ́: «Nə̀ń, n nə wà n waa ken à nə wuuu, nətʋ! Bɛ̀eɛ̀e nə pɩn, n ma bɛ̀eé?» ");
INSERT INTO nnw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba mama bələ ma pɛ̀e duən, ba zʋ nɩ́á yuu bori tə wa. Yá vʋʋ tə də zɩgɩ. ");
INSERT INTO nnw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Zwezi karbɩa tə mama, ba nə yɩn nɩ́á yuu bori tə wa, tʋa ʋ yáá con, ba ga wʋ́: «N cɩ́gá yɩ Yɩɩ-Biu!» ");
INSERT INTO nnw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ba nə galʋ mʋnaa tə, ba zwɛ̀e, ba zʋa Zwenezarɛtə nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ba nə yí tɩa ba zwɛ̀e də kʋ bwálɩ́ təntə, lɩ̀à tə lwarɩ Zwezi. Ba dàń ma man bwálɩ́ mama nə də, Zwezi twi. Ba ja yayɩŋa zənzən, ba bà ʋ con. ");
INSERT INTO nnw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba lòrì wá, sə ʋ yá, sə ba dwen ʋ gànʋ̀ cɩcɩ nii nə. Yá lɩ̀à tə mama, ba nə dwen kʋ nə, ba yàá na yazurə. ");
INSERT INTO nnw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kʋ kwa nə, *Farɩzɩan-ba də *Zwifə-ba Yɩɩ nii *yənu tɩ̀án nan *Zwerizalɛmə, ba bà, ba bwe Zwezi, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«N karbɩa tə, ba ba ba jɩ̀àn sɩn, ba ma də́ wodiu, ndə kʋ nə mɛ nətʋ. Bɛ̀eɛ̀e nə pɩn, ba ba nə nɩbara yofwamɩnan tə nii zìlí?» ");
INSERT INTO nnw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Zwezi ma le ba, ʋ wʋ́: «Á mʋ̀ dàń yɩ, bɛ̀eɛ̀e nə pɩn, á də ba Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, nii zìlí, á yofwamɩnan tə yɩrɩ? ");
INSERT INTO nnw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yɩɩ yà swɩ̀n, ʋ wʋ́: ‹Zìlí n nuu də n nyɩna. Yá lìù tə, ʋ nə zɩrɩ ʋ kə ʋ nuu də ʋ nyɩna nə, ʋ mɛ, sə ba gʋ wá›. ");
INSERT INTO nnw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yá á mʋ̀ bɩrɩ də, lìù nə swɩ̀n ʋ nuu də ʋ nyɩna con nə, ʋ wʋ́: ‹N tori tə, à yà nə wá ma san mʋ́, yɩ à tún, sə kʋ ya *joŋi, kʋ pa Yɩɩ nə›. Kʋ mʋ̀ tíú təntə kʋ́ʋ̀ tà kálʋ́, sə ʋ zìlí ʋ nuu də ʋ nyɩna. ");
INSERT INTO nnw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mə nətʋ nə á goŋi Yɩɩ sʋgʋ tə, á dʋga, sə á ga twá á yofwamɩnan tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Níə́ bələ tɩ̀án-ba! Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi yà jə cɩ́gá də, ʋ nə dí yáá ʋ swɩ̀n á yoo, fuən mama, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Lɩ̀à-ba tə yɩ ba zìlí à mʋ̀ Yɩɩ də ba nii cɩcɩ. Yá ba waa ga ŋʋ́ná də nə. ");
INSERT INTO nnw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ba yɩjʋnɩ tə yɩ tʋtʋ. Kʋ tə, ba nə kàrɩ̀ ba bɩrɩ, nə yɩ ləzoni kàrà də ba yofwamɩnan nə, tə yɩrɩ›.» ");
INSERT INTO nnw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kʋ kwa nə, Zwezi bon lalʋʋ tə, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á cʋga, á ga nì kʋ tə! ");
INSERT INTO nnw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kʋ tà won tə, kʋ nə zwɩ ləzwənə nii, nə pɩn, ʋ bɩcan yɩ nəzonu Yɩɩ yáá con. Kʋ yɩ won tə, kʋ nə naŋa ʋ nii wa nə pɩn, ʋ bɩcan yɩ nəzonu Yɩɩ yáá con». ");
INSERT INTO nnw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Zwezi karbɩa tə dàń ma fàrʋ́ ba yí ʋ yɩra, ba ga swɩ̀n, ba wʋ́: «N yə̀ə́ də, n sʋgʋ tə dí *Farɩzɩan-ba tə?» ");
INSERT INTO nnw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zwezi ma le, ʋ wʋ́: «À nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ *sàń nə, wá múrí tɩ̀ʋ́ tə mama, ʋ nə wà cwén. ");
INSERT INTO nnw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Á yaga Farɩzɩan-ba! Ba yɩ ndə lilirən nə vaŋa lilirən nə. Yá də liliu nə van ʋ don liliu, ba mama bələ wá tʋ gwàlʋ́ wa». ");
INSERT INTO nnw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyɛrə ma swɩ̀n ʋ con, ʋ wʋ́: «Bɩrɩ zwansɩsara tə də̀ń nəba!» ");
INSERT INTO nnw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Zwezi ma swɩ̀n, ʋ wʋ́: «Á də tə yɩ lɩ̀à tə, á nə wàrɩ̀ yoo də̀ń á nì? ");
INSERT INTO nnw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Á yə̀rì də, kʋ tə mama nə zwɩ lìù nii, yàá va ʋ pùə́ wa. Kʋ kwa nə, kʋ yɩ ʋ yàá twa kʋ, ʋ dʋgʋ kaduəyuu bwálɩ́ nə. ");
INSERT INTO nnw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yá kʋ tə nə naŋa nii wa, yɩ kʋ zɩgɩ waa kʋ ma naŋa. Mə kʋ mʋ̀ dàń nə pɩn, ləzwənə bɩcan yɩ nəzonu Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kʋ yɩ ləzwənə waa nə, pubʋŋɩ kʋkwɩnan yàá nan, tə yugə wá, tə pɩn ʋ gwɩ lɩ̀à, tə pɩn ʋ cwàrɩ̀, tə pɩn ʋ ŋwɩ̀n, tə pɩn ʋ kʋnɩ kʋnkʋn, ʋ keni lɩ̀à nii nə, tə pɩn ʋ kʋkʋlɩ Yɩɩ yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mə tə mʋ̀ nə pɩn, ləzwənə bɩcan yɩ nəzonu Yɩɩ yáá con. Kʋ tà ka də́, də n nə wà n jɩ̀àn sɩn nə, wàá kʋ pɩn, ləzwənə bɩcan yanɩ nəzonu Yɩɩ yáá con». ");
INSERT INTO nnw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kʋ kwa nə, Zwezi lɛ lá nə, ʋ va nagwanaa tə wa, Tirə də Sidon tɩan tə nə wulə kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kan don, ʋ nə yɩ Kanan lʋʋ nii tɩ̀án bʋ̀á, nan bwálɩ́ təntə wa, ʋ bà Zwezi con, ʋ ga bubwi, ʋ wʋ́: «*Yuu-Tiu, pɩ̀ʋ́ *Davidə nàʋ́, dəri à yinəgə! *Zini wʋwalɩ à bʋ̀á, kʋ kəni càn ʋ nə zənzən». ");
INSERT INTO nnw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yá Zwezi wà yoo swɩ̀n. Ʋ karbɩa tə ma fàrʋ́ ba yí ʋ yɩra, ba lòrì wá, ba wʋ́: «Swɩ̀n ʋ con, sə ʋ vìí! Ʋ nə púə́ nə kwa, ʋ fwa zuzugu tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Zwezi ma le, ʋ wʋ́: «Yɩɩ tʋn nə *Yɩzərayɛlə dwíí tə cɩcɩ con, ba nə yɩ ndə pee nə, tə nə jén». ");
INSERT INTO nnw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yá kan tə twi, ʋ tʋ ʋ yáá con, ʋ ga swɩ̀n, ʋ wʋ́: «Yuu-Tiu, san nə!» ");
INSERT INTO nnw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Zwezi ma le, ʋ wʋ́: «Kʋ wà mɛ, sə ba tì bìsɩ́ná wodiu, ba dɩlɩ kukurbii yáá». ");
INSERT INTO nnw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kan tə ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Awo, kʋ yɩ cɩ́gá Yuu-Tiu, yá kukurbii tə dàń nə də́ mumunə tə, tə nə naŋa tə tɩ̀án tə jɩɩn, tə twɩ tɩa». ");
INSERT INTO nnw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Zwezi dàń ma pìí ʋ le wá, ʋ wʋ́: «Kan, n cɩ́gá ken n waa à nə, mɩ́ámɩ́án. Kʋ tə, n nə pɩ̀à tə wá jì». Kʋ máŋá təntə wa, də ʋ bʋ̀á tə nɩ yazurə. ");
INSERT INTO nnw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Zwezi kʋ́ʋ̀ zàn, ʋ vìí tə bwálá təntə wa. Ʋ vəli Galile mʋnaa tə nii nə, ʋ dɩ̀ paan don yuu wa, ʋ jə̀ə́ lá. ");
INSERT INTO nnw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lalʋʋ dàń ga twi ʋ con, də ba wa gwànán, də lilirən, də ləzwənkɩkaran, də bərən, də yayɩŋa duən zənzən. Ba jɩn ba mama ba va Zwezi yáá con, yá ʋ ga zwɛ̀e ba yayɩran. ");
INSERT INTO nnw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kʋ gwárɩ́ lalʋʋ tə zəni, də máŋá tə, ba nə nɩ bərən tə swɩ̀n, ləzwənkɩkaran wiən nə twe, gwànán nə vəli, də lilirən nə na. Ba dàń wulə ba bwɩ *Yɩzərayɛlə Yɩɩ tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zwezi dàń bon ʋ karbɩa tə, ʋ swɩ̀n ba con, ʋ wʋ́: «Lalʋʋ tə yinəgə jə nə, ba nə wulə də nə dɩan batwa nətən, ba ga ba won jə, ba də́ tə yɩrɩ. À ba pɩ̀à, sə à pa ba vìí də niən. Ba dɩ̀àn wàá tə zwɛ̀e cwəŋə yuu, ba twɩ». ");
INSERT INTO nnw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Karbɩa tə ma bwe wá, ba wʋ́: «Yə̀n nə, nə wá na wodiu, nə pa lalʋʋ kʋ tə mama də́ kʋ sú, bwálɩ́ kʋ tə wa, won mama nə tə̀lə́?» ");
INSERT INTO nnw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Zwezi ma bwe ba, ʋ wʋ́: «Dipɛn bagalɩ nə, á jə?» Ba ma le wá, ba wʋ́: «Dipɛn barpɛ də fəlibii mancɩn nə wulə». ");
INSERT INTO nnw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kʋ kwa nə, ʋ dàń pɩn nii lalʋʋ tə nə, sə ba jə̀ń tɩa. ");
INSERT INTO nnw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ʋ dàń ma tì dipɛn barpɛ tə, də fələ tə, ʋ kə Yɩɩ lɛ̀eɛ̀e, ʋ fʋ fʋ tə, ʋ pa ʋ karbɩa tə nə, ba ma tàrà lalʋʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ba lìù mama dí ʋ sú. Karbɩa tə ga pɛ̀e tə mumunə, tə nə ga, ba sú tìí barpɛ. ");
INSERT INTO nnw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ba tə mama, ba nə dí tə yí, ndə bara mʋ̀rʋ̀ banɩa nə. Kana də bìsɩ́ná nii ba lá nə də́. ");
INSERT INTO nnw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Zwezi nə pa, lalʋʋ tə vìí kwa nə, ʋ zʋa nɩ́á yuu bori tə wa, ʋ va Magadan nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","*Farɩzɩan-ba də *Sadɩsɩan-ba fàrʋ́ ba yí Zwezi yɩra, sə ba ma wànɩ́ ba ja ʋ də̀ń nə. Ba lòrì wá, sə ʋ twá mɩmɩnʋ nə, ʋ ma bɩrɩ ba də, ʋ dɩ̀àn tə yɩ tə nan Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Də yɩcaʋ nə pɩ̀à, kʋ zʋ, á yàá swɩ̀n, á wʋ́: ‹Tɩa tə wá yà zəni, lanworu tə nə yɩ nəsɩan yɩrɩ.› ");
INSERT INTO nnw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yá jɩjʋ fuən fuən, á yàá swɩ̀n, á wʋ́: ‹Dwà wá nà zə̀n, tɩa tə yáá nə beri yɩrɩ.› Á wàá tɩa yáá nə yɩ nətʋ á lwarɩ, yá á ga wàrɩ̀ sɩ́ʋ́n máŋá kʋ tə Yɩɩ mɩmɩnan tə də̀ń á lwarɩ. ");
INSERT INTO nnw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Á mʋ̀ zə̀n lɩ̀à tə, á yɩ lakʋkwɩnan, á ba Yɩɩ cɩcɩ nə twá. Yá á mʋ̀ nə pɩ̀à, sə á na Yɩɩ dɩ̀àn mɩmɩnʋ. Á bá na mɩmɩnʋ nədʋ də tətə, də kʋ nə tà yoo tə, kʋ nə yí Zwʋnasə». Ʋ dʋgʋ ba lá, ʋ ga ja kʋ ʋ lɛ ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Máŋá tə nə, karbɩa tə nə lɛ mʋnaa tə bəbəru tə don nə, ba yà swɛ̀eé, sə ba tì dipɛn, ba kə ba yuu. ");
INSERT INTO nnw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yá Zwezi swɩ̀n ba con, ʋ wʋ́: «Á zurə á yɩra, á cɩa á tɩ̀àn nə zəni də *Farɩzɩan-ba də *Sadɩsɩan-ba sabwarɩ tə!» ");
INSERT INTO nnw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Karbɩa tə ma swɩ̀n duən con, ba wʋ́: «Ʋ swɩ̀n nətʋ, nə nə wà dipɛn tì tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Zwezi yəni kʋ tə, ba nə swɩ̀n, ʋ dàń ma bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á swɩ̀n də, kʋ yɩ á nə wà dipɛn jɩn, á ja bà tə nə pɩn, à swɩ̀n sabwarɩ yoo? Á na, á nə ba á waa keni à nə mɩ́ámɩ́án nətʋ! ");
INSERT INTO nnw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Á tə ba nə̀ń, naaa? Á lie á tɩ̀àn dipɛn bonu tə yoo, à nə pwɛ̀e à pa lɩ̀à mʋ̀rʋ̀ bonu tə nə. Sə á lìí dipɛn fɩyaran tə nii, á nə pɛ̀e, á ja vìí! ");
INSERT INTO nnw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yá á tə lie á tɩ̀àn dipɛn barpɛ tə yoo, à nə pwɛ̀e à pa lɩ̀à mʋ̀rʋ̀ banɩa tə nə. Sə á lìí dipɛn tìí tə nii, á nə pɛ̀e, á ja vìí! ");
INSERT INTO nnw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bɛ̀eɛ̀e nə pɩn, á wà nì də, kʋ tà dipɛn tətə yoo nə, à swɩ̀n á con? Á cɩa á tɩ̀àn nə də Farɩzɩan-ba də Sadɩsɩan-ba sabwarɩ tə». ");
INSERT INTO nnw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Karbɩa tə dàń lwarɩ də, kʋ tà dipɛn sabwarɩ nə, Zwezi swɩ̀n, sə ba cɩ̀ ba tɩ̀àn nə də kʋ, kʋ yɩ Farɩzɩan-ba də Sadɩsɩan-ba kàrà tə yoo, nə ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zwezi vəli nagwanaa don wa, kʋ nə bwələ tɩʋ don, ba nə boŋə ‹Filipə Sezare›. Ʋ bwe ʋ karbɩa tə, ʋ wʋ́: «Bɛ̀eɛ̀e nə lɩ̀à tə swɩ̀n *Ləzwənə-Biu tə yuu wa?» ");
INSERT INTO nnw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ba ma le, ba wʋ́: «Lɩ̀à duən wʋ́, n yɩ *Zwan-Batisə, ba duən wʋ́, n yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli, ba duən də ga wʋ́, n yɩ Yɩɩ nii sʋ̀sʋ̀nʋ̀ Zweremi, nə à yə̀ə́ Yɩɩ nii sʋ̀sʋ̀nà tə don». ");
INSERT INTO nnw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Zwezi ma bwe ba, ʋ wʋ́: «Sə á mʋ̀ con nə, wàà nə á wʋ́, à yɩ?» ");
INSERT INTO nnw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piyɛrə ma le, ʋ wʋ́: «N yɩ *Kərisə, Yɩɩ tə, ʋ nə wulə mɩɩ wa, tə bìú». ");
INSERT INTO nnw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Zwʋnasə bìú Simon, n yɩ pupwən lìù, kʋ nə tà ləzwənə nə bɩrɩ mʋ́ kʋ yoo tə yɩrɩ. Kʋ yɩ à nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ *sàń nə. ");
INSERT INTO nnw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yá à mʋ̀ nə swɩ̀n kʋ n con: N yɩrɩ nə yɩ Piyɛrə, kʋ də̀ń nə yɩ pɩ̀ʋ̀. À wá kə à lɩ̀à tə púlí tə kʋ mʋ̀ pɩ̀ʋ̀ təntə yuu wa, ndə lìù nə tún dìə̀ dəkuu pɩ̀ʋ̀ yuu nətʋ. Tɩan də tə dɩ̀àn mama, tə ba wànɩ́ tə cʋ̀gʋ̀ kʋ púlí təntə. ");
INSERT INTO nnw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","À wá pa mʋ́ Yɩɩ pàrɩ̀ borbɩa tə. Kʋ tə, n nə wá vɩ tɩa yuu wa, kʋ wá yà nətʋ Yɩɩ *sàń də nə. Kʋ tə, n nə wá sɛ̀e tɩa yuu wa, kʋ wá yà nətʋ Yɩɩ sàń də nə». ");
INSERT INTO nnw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kʋ kwa nə, Zwezi dùə̀ sú ʋ karbɩa tə nii nə, sə ba dàn ká swɩ̀n kʋ, ba pa lìù mama yəni də, ʋ mʋ̀ nə yɩ Kərisə. ");
INSERT INTO nnw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kʋ nə zɩgɩ kʋ máŋá təntə wa, Zwezi swɩ̀n ʋ karbɩa tə con, də kʋ yɩ kálʋ́, sə ʋ va *Zwerizalɛmə. Mə kʋ mʋ̀ tɩfarʋ tə wa, ʋ wá də́ càn zənzən *Zwifə-ba *nəkwɩna, də ba Yɩɩ *joŋwana yun tɩ̀án, də ba Yɩɩ nii *yənu tɩ̀án-ba yáá con. Ba wá gʋ wá, yá dɩan batwa nii nə, ʋ wá pìí ʋ bwin ʋ nan. ");
INSERT INTO nnw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyɛrə dàń ma bon Zwezi, ʋ ja nan kwa, ʋ ga caga ʋ nii nə, ʋ wʋ́: «*Yuu-Tiu, Yɩɩ dàn ká ja bà! Kʋ tə bá yí mʋ́, abada». ");
INSERT INTO nnw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yá Zwezi dàń pìí ʋ vəvəri, ʋ swɩ̀n Piyɛrə con, ʋ wʋ́: «Ja pɩ̀à bwálɩ́, *Sɩtana! N cɩ̀gà à cwəŋə nə, n nə ba bʋŋa ndə Yɩɩ nə, n nə yɩ n bʋŋa ndə ləzoni nə tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Zwezi ma kʋ́ʋ̀ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Lìù tə mama nə pɩ̀à, sə ʋ bà ʋ twá à nə, sə kʋ tíú kʋ́ʋ̀ dàn ká tì ʋ tɩ̀àn, ʋ ma fwa ʋ təntɩan puswənə. Kʋ tíú mɛ, sə ʋ sɛ̀e, ʋ twá ʋ də́ càn, də nə kʋ ja vələ ʋ tɩan dagarʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Lìù tə, ʋ nə pɩ̀à, sə ʋ jon ʋ mɩɩ tə, ʋ wá kwɩ̀n kʋ nə. Yá lìù tə, ʋ nə wá dʋgʋ ʋ mɩɩ tə à mʋ̀ yɩrɩ, kʋ tíú wá na mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kʋ funə wa yə̀n nə kʋ pa lìù nə, də ʋ nə nɩ tɩa yuu jɩjə tə mama, yá ʋ ga kwɩ̀n mɩɩ tə nə, kʋ nə ba zwɛ̀e Yɩɩ con? Won wulə ləzwənə nə wá pa, sə kʋ ma yə̀ ʋ mɩɩ tə kʋ jon, naaa? ");
INSERT INTO nnw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","*Ləzwənə-Biu tə wá bà, ʋ nyɩna Yɩɩ dun tə wa də ʋ *malɩkɛ. Yá ʋ wá ŋwɩ́n lìù mama, ndə ʋ nə tʋn nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ba tə duən, ba nə wulə yəbə bá tɩ də ba nə wà Ləzwənə-Biu tə nɩ, ʋ twi də ʋ pàrɩ̀ tə». ");
INSERT INTO nnw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dɩan bardʋ kwa nə, Zwezi jɩn Piyɛrə də Zwakə, ʋ súrí Zwakə nubiu Zwan nə, ʋ ja ba ʋ va paan nədarʋ yuu, ʋ də ba cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ʋ lwàń ʋ tɩ̀àn ba yɩ́á yuu, ʋ yáá wulə ka pəpəli, ndə yɩcaʋ nə. Yá ʋ ganan də lwàń nəpwənə, ndə poni nə. ");
INSERT INTO nnw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yá ʋ karbɩa tə dàń na *Moyizə də Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli, ba swɩ̀n də Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyɛrə dàń ma swɩ̀n Zwezi con, ʋ wʋ́: «*Yuu-Tiu, kʋ ziən də, nə nə wulə yəbə. Də n nə pɩ̀à, à wá pú gansilə batwa yəbə. N mʋ̀ nədʋ, Moyizə nədʋ, Eli də nədʋ». ");
INSERT INTO nnw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ʋ nə wulə ʋ swɩ̀n máŋá tə wa, də bakwan kʋ nə cɩcɩlɩ twi, kʋ pú ba yuu nə. Yá kori ga nan kʋ wa, kʋ wʋ́: «Ʋ tə yɩ à biswənə tə, ʋ nə poli à pùə́. Á cʋga ʋ nii!» ");
INSERT INTO nnw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Máŋá tə nə, karbɩa tə nə nì kori təntə, fən jɩn ba zənzən, ba tʋ tɩa ba yáá yuu. ");
INSERT INTO nnw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Zwezi fàrʋ́ ʋ yí, ʋ dwen ba yɩra, ʋ ga swɩ̀n, ʋ wʋ́: «Á zaŋa yɩɩ nə! Á dànà ká pa fən ja aba!» ");
INSERT INTO nnw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba nə zɩ̀n ba yéé, ba kə yɩɩ nə, ba kʋ́ʋ̀ wà lìù don nɩ, ba súrí Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba nə nan paan tə yuu ba cwi, Zwezi pɩn ba nii, ʋ wʋ́: «Á dànà ká swɩ̀n yoo kʋ tə, á bɩrɩ lìù mama nə, kʋ jə vələ, *Ləzwənə-Biu tə tɩan də ʋ ka pìí ka bwin». ");
INSERT INTO nnw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zwezi karbɩa tə dàń ma bwe wá, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, *Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə wʋ́, də Eli nə wá dí yáá, ʋ bà?» ");
INSERT INTO nnw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ʋ ma le ba, ʋ wʋ́: «Eli mɛ, sə ʋ cɩ́gá bà, ʋ kwɛn tə mama. ");
INSERT INTO nnw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","À mʋ̀ dàń nə swɩ̀n kʋ, á con: Eli manwarɩ ʋ bà, lɩ̀à tə ga wà lwarɩ. Yá ba tì wá, ba ma fwa ba tə swə tə. Mə nətʋ nə, ba wá kə Ləzwənə-Biu tə càn wa». ");
INSERT INTO nnw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Karbɩa tə dàń ma lwarɩ də, kʋ yɩ *Zwan-Batisə yoo nə ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Máŋá tə, ba nə yí bwálɩ́ tə, lalʋʋ tə nə wulə, bɛɛ don fàrʋ́ ʋ yí Zwezi yɩra, ʋ tʋ ʋ nadwana yuu ʋ yáá con, ʋ ga swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«*Yuu-Tiu dəri à bìú tə, ʋ nə twɩ kwaran, tə yinəgə, ʋ na càn zənzən. Kʋ nə zàn ʋ wàá, ʋ twɩ mən wa, nə à yə̀ə́ nɩ́á wa. ");
INSERT INTO nnw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","À ja wá, à bà n karbɩa tə con, yá ba wà wá wànɩ́ ba pa, ʋ na yazurə». ");
INSERT INTO nnw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zwezi ma swɩ̀n, ʋ wʋ́: «Á mʋ̀ zə̀n lɩ̀à-ba, á tə nə ba Yɩɩ nii sɛ̀e, á ga fwa yotələn! Dɩan bagalɩ nə à tə wá yà də aba? Kʋ yɩ à wá ja pɩ́nʋ́ kʋ mɛ nətə də aba? Á jana bisɩmaa tə, á ja bà à con!» ");
INSERT INTO nnw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Zwezi ma swɩ̀n ʋ zɩgɩ *zini tə nə. Kʋ ma nan kʋ yá bisɩmaa tə, ʋ ga na yazurə, naa nədʋ. ");
INSERT INTO nnw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Karbɩa tə ma fàrʋ́ ba yí Zwezi tətə yɩra, ba bwe wá, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, nə wà wànɩ́ nə lɩ zini tə?» ");
INSERT INTO nnw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Zwezi ma le, ʋ wʋ́: «Kʋ yɩ á nə ba á waa keni à nə wuuu tə yɩrɩ. Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Də á nə ken á waa à nə, ka nə dáá ndə gabiu nəmanbiə nə, á wá wànɩ́ á swɩ̀n paan ka tə con: ‹Zàn yəbə, n pə̀ń lá con›, yá kʋ ga wá zàn. Won tə̀lə́, á nə ba wànɩ́, á fwa».  ");
INSERT INTO nnw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yá kʋ dàń nə yɩ yɩjʋnɩ də nivori nə nə kʋ wá twá, ba ma lɩ kʋ zini yiri kʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Máŋá tə, Zwezi də ʋ karbɩa tə nə wulə ba vəli Galile nagwanaa tə wa, Zwezi swɩ̀n ba con, ʋ wʋ́: «*Ləzwənə-Biu tə mɛ, sə ba ja wá, ba kə ləzoni jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ba wá gʋ wá, yá dɩan batwa nii nə, ʋ wá pìí ʋ bwin ʋ nan». Karbɩa tə pwìí cʋ̀gʋ̀ zənzən kʋ yoo təntə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Máŋá tə wa, Zwezi də ʋ karbɩa tə nə yí Kapɛrənayimə, *Zwifə-ba Yɩɩ *dìə̀ lanpolɩna tə fàrʋ́ ba yí Piyɛrə yɩra, ba ga bwe wá, ba wʋ́: «Á karnyɩna tə ŋwɩ́n Yɩɩ dìə̀ lanpoo tə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyɛrə ma le, ʋ wʋ́: «Awo, ʋ ŋwɩ́n kʋ». Máŋá tə wa, Piyɛrə nə zwɩ dìə̀ tə wa, Zwezi nə təntən ʋ swɩ̀n, ʋ wʋ́: «Simon bɛ̀eɛ̀e nə n bʋŋa yoo kʋ tə yuu wa? Wàà nə ŋwɩ́n lanpoo, ʋ pɩn tɩa yuu pɛ̀egá nə? Wàà nə yàá lá wiən, ʋ pɩn tɩa yuu pɛ̀egá nə? Kʋ ya tɩʋ tɩ̀án, nə à yə̀ə́ vərə nə yàá fwa kʋ?» ");
INSERT INTO nnw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyɛrə ma le, ʋ wʋ́: «Vərə nə». Zwezi swɩ̀n ʋ con, ʋ wʋ́: «Kʋ nətʋ tə nə, tɩʋ tɩ̀án tə mʋ̀ tɩ ba tɩ̀àn, ba ba won ŋwɩ́n. ");
INSERT INTO nnw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yá, sə nə dàn ká cʋ̀gʋ̀ lanpolɩna tə pwìí nə, vəli mʋnaa tə wa, n dɩlɩ gwala nɩ́á tə wa. Təntən fəli tə nii, n nə wá ja, súrí kʋ nii, n wá na səbiu lá, kʋ nə wá ŋwɩ́n à də mʋ́ lanpoo». ");
INSERT INTO nnw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kʋ máŋá tə wa, karbɩa tə fàrʋ́ ba yí Zwezi yɩra, ba bwe wá, ba wʋ́: «Wàà nə dwə nə mama Yɩɩ pàrɩ̀ tə wa?» ");
INSERT INTO nnw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zwezi ma bon bisɩmaa, ʋ zɩgɩ wá ba tətəŋi wa, ");
INSERT INTO nnw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ʋ ga swɩ̀n, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á nə wà lwàń, á jì ndə bìsɩ́ná nə, á bá zʋ Yɩɩ pàrɩ̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lìù tə, ʋ nə wá doni á mama Yɩɩ pàrɩ̀ tə wa, yɩ lìù tə, ʋ nə wá mun ʋ tɩ̀àn, ʋ ga jì ndə bisɩmaa nə. ");
INSERT INTO nnw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Lìù tə, ʋ nə jɩn bisɩmabiə zəni, ndə wà tə nə à mʋ̀ yɩrɩ, kʋ yɩ à mʋ̀ tətə nə, kʋ tíú jɩn zəni». ");
INSERT INTO nnw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yá lìù tə, ʋ nə pɩn, labwana təntə, ba nə keni ba waa à nə wuuu, don twá ʋ nə, ʋ dʋgʋ Yɩɩ cwəŋə tə, ka jén, kʋ wá kʋkwanɩ kʋ tíú con nə, də ba nə vwə kapan nəfarʋ ʋ bɩan nə, ba ja va ba dɩ mʋʋ nɩ́á də̀ń nə. ");
INSERT INTO nnw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Lɛɛ wá yà tɩa yuu də yìə̀n nə dáá, tə nə pɩn ləzoni fwa cʋna! Tə mʋ̀ yìə̀n təntə də wàrɩ̀, tə zwɛ̀e tɩa yuu wa. Yá lɛɛ dàń nə wá yí lìù tə, ʋ nə wá pa, ʋ don fwa cʋna. ");
INSERT INTO nnw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kʋ nə yɩ də kʋ wá twá n jɩɩn nə, nə à yə̀ə́ n naa nə, sə n ma fwa cʋna, gwəŋə tə n dɩlɩ yɩŋʋna də mʋ́. Kʋ kʋkwa kʋ pa mʋ́, də n nə nɩ mɩɩ tə Yɩɩ con, də jɩɩn kuku, nə à yə̀ə́ də naa kuku, kʋ doni, də n nə jə jɩ̀àn tə mama, nə à yə̀ə́ nɛɛ tə mama, ba ga tì mʋ́ ba dɩlɩ mən wa, tə nə ba dəŋə. ");
INSERT INTO nnw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kʋ nə kʋ́ʋ̀ yɩ kʋ twá n yii nə, n ma fwa cʋna, ja kʋ, n lɩ n dʋgʋ yɩŋʋna də mʋ́. Kʋ kʋkwa kʋ pa mʋ́, də n nə nɩ mɩɩ Yɩɩ con də yii nədʋ, kʋ doni, də n nə jə yɩ́á bələ, ba ga tì mʋ́ ba dɩlɩ mən dìə̀ tə wa». ");
INSERT INTO nnw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À mʋ̀ nə swɩ̀n kʋ á con nə: Á cɩa á tɩ̀àn nə, á dànà ká gwiən labwana tə, ba nə ba dun jə. Ba wa ladʋa də tətə. Máŋá mama ba *malɩkɛ nə zɩga à nyɩna Yɩɩ yáá con, ʋ nə wulə Yɩɩ *sàń nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","*Ləzwənə-Biu tə twi tɩa yuu, sə ʋ jon lɩ̀à tə, ba nə jén, ʋ pa Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Də lìù nə jə pee bíí, ka nədʋ ga jén, ʋ wá yá tə sapwɩnɩa də fugə də nʋgʋ tə duən tə paan tə yuu wa, ʋ ga va ʋ pɩ̀à ka tə, ka nə jén tə. Bɛ̀eɛ̀e nə á bʋŋa kʋ yuu wa? ");
INSERT INTO nnw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ʋ ga nə nɩ ka, ʋ pùə́ wá poli, kʋ mʋ̀ piə təntə yɩrɩ, kʋ doni tə sapwɩnɩa də fugə də nʋgʋ tə duən tə, tə nə wà jén tə. ");
INSERT INTO nnw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mə nətʋ nə, á nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ sàń nə, də ba pɩ̀à, sə ba mʋ̀ labwana təntə nədʋ jén». ");
INSERT INTO nnw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Də n nubiu nə cʋ̀gʋ̀, n nə vəli n yí wá, n ga bɩrɩ wá ʋ cʋna tə, n mʋ̀ də wá bələ pwərə wa. Ʋ nə cʋgʋ n nii, də n jon wá, n kə cwəŋə nə. ");
INSERT INTO nnw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yá ʋ dàń nə nə vɩga, sə ʋ cʋgʋ n nii, tì lìù nədʋ, nə à yə̀ə́ lɩ̀à bələ, n súrí n tɩ̀àn nə, sə kʋ ma yà ndə kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Kʋ mɛ, sə kʋ ja lɩ̀à bələ, ba nə yə̀ə́ kʋ yoo tə, nə à yə̀ə́ lɩ̀à batwa.› ");
INSERT INTO nnw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yá ʋ tə nə vɩga, sə ʋ cʋgʋ ba nii, sə n swɩ̀n kʋ *Kərisə lɩ̀à púlí tə con. Yá ʋ tə nə vɩga, sə ʋ cʋgʋ lɩ̀à təntə, sə n tì wá, n ma fwa ndə lìù tə nə, ʋ nə yə̀rì Yɩɩ, nə à yə̀ə́ ndə lanpolɩnʋ nə». ");
INSERT INTO nnw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ tə, á nə wá vɩ tɩa yuu wa, kʋ wá yà nətʋ Yɩɩ *sàń də nə. Kʋ tə, á nə wá sɛ̀e tɩa yuu wa, kʋ wá yà nətʋ Yɩɩ sàń də nə. ");
INSERT INTO nnw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Cɩ́gá mama, à mʋ̀ nə kʋ́ʋ̀ swɩ̀n kʋ á con: Kʋ nə ya á lɩ̀à bələ, də nə ken duən nə tɩa yuu wa, sə á ma lòrì won mama yɩjʋnɩ wa, à nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ sàń nə, wá pa kʋ aba. ");
INSERT INTO nnw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Cɩ́gá, bwálɩ́ tə nə, lɩ̀à bələ, nə à yə̀ə́ batwa nə ken duən nə à mʋ̀ yɩrɩ tə nə, à wulə ba tətəŋi wa». ");
INSERT INTO nnw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Piyɛrə dàń ma fàrʋ́ ʋ yí Zwezi yɩra, ʋ ga bwe wá, ʋ wʋ́: «*Yuu-Tiu, nɛɛ bagalɩ nə à mɛ, sə à sɛ̀e à kwɛn yoo à lɩ à mʋ̀ də à don pwərə wa, ʋ nə cʋ̀gʋ̀ à nə, máŋá mama wa? Sə kʋ ya nɛɛ barpɛ, naaa?» Zwezi ma le wá, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","«À wà swɩ̀n də nɛɛ barpɛ nə mɛ, à wʋ́, sə kʋ ya nɛɛ sapwɩtwa də fugə dəkurən barpɛ. ");
INSERT INTO nnw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kʋ mʋ̀ nə pɩn, Yɩɩ pàrɩ̀ tə nyɩn ndə pɩ̀ʋ́ don nə zàn, sə ʋ ma jon ʋ jɩŋa ʋ tʋ̀tʋ̀nà con, ʋ kə duən nə. ");
INSERT INTO nnw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ʋ nə wulə ʋ gàlɩ̀ máŋá tə wa, ba jɩn tʋ̀tʋ̀nʋ̀ tə don, ba bà ʋ con, ʋ jɩŋɩ nə yí sɩ́án səbikʋlan mʋ̀rʋ̀ fugə (10 000). ");
INSERT INTO nnw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kʋ bɛɛ təntə yà ba won jə, sə ʋ ma ŋwɩ́n səbiu təntə. Ʋ yuu tíú tə ma pa nii, sə ba ja wá ba yə̀ ndə yoŋu nə, sə ba ga yə̀ ʋ kan də ʋ bɩa də kʋ tə mama, ʋ nə jə, sə jɩŋɩ tə ma wànɩ́ kʋ ŋwɩ́n. ");
INSERT INTO nnw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tʋ̀tʋ̀nʋ̀ təntə ma tʋ tíú tə yáá con, ʋ ga lòrì wá, ʋ wʋ́: ‹Ja pɩ́nʋ́ də nə! À wá ŋwɩ́n n jɩŋɩ tə mama!› ");
INSERT INTO nnw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ʋ yuu tíú tə dəri ʋ yinəgə. Ʋ yá jɩŋɩ tə, ʋ pa wá. Yá ʋ ga dʋgʋ wá, ʋ pa ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tʋ̀tʋ̀nʋ̀ təntə nə nan, ʋ jə́rí ʋ tʋ̀tʋ̀nʋ̀ don, ʋ cɩnɩa səbikʋlan bíí nə wulə ʋ yuu wa, ʋ pùrì ʋ kələru nə ʋ kaŋa, ndə ʋ ka gʋ wá, ʋ ga wʋ́: ‹Ŋwɩ́n à jɩŋɩ tə, kʋ nə wulə n yuu wa!› ");
INSERT INTO nnw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ʋ tʋtʋndon tə ma tʋ ʋ nɛɛ nə ʋ yáá con, ʋ lòrì wá, ʋ wʋ́: ‹Ja pɩ́nʋ́ də nə! À wá ŋwɩ́n mʋ́!› ");
INSERT INTO nnw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yá ʋ wà kʋ sɛ̀e. Ʋ pɩn ba ja wá, ba kə bàń dìə̀, sə ʋ ya lá, kʋ ja vələ, ʋ nə wá ŋwɩ́n jɩŋɩ tə. ");
INSERT INTO nnw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Máŋá tə wa, tʋ̀tʋ̀nà tə duən nə nɩ kʋ nətʋ tə, ba pwìí cʋ̀gʋ̀ zənzən. Yá ba ga va ba tún kʋ mama, ba bɩrɩ ba yuu tíú tə. ");
INSERT INTO nnw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yuu tíú tə dàń ma pa, ba ja kʋ tʋ̀tʋ̀nʋ̀ təntə ba bà, ʋ ga wʋ́: ‹Tʋtʋnwʋlʋnyɩan! À yá à jɩŋɩ tə, à pa mʋ́, n nə lòrì nə, sə à fwa kʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","N də yà mɛ, sə n dəri n twadon tə yinəgə, ndə à nə dəri n yinəgə nətʋ.› ");
INSERT INTO nnw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yuu tíú tə lɩŋa zàn zənzən, ʋ ma pa, ba ja tʋ̀tʋ̀nʋ̀ təntə, sə ba mà wá, kʋ ja vələ, ʋ nə wá ŋwɩ́n jɩŋɩ tə». ");
INSERT INTO nnw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Zwezi dàń ma súrí lá, ʋ wʋ́: «Mə nətʋ nə à nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ *sàń nə, wá tʋn aba, də á lìù mama nə wà sɛ̀e ʋ kwɛn ʋ də ʋ don yìə̀n ʋ lɩ ba pwərə wa, də ʋ waa mama». ");
INSERT INTO nnw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Máŋá tə wa, Zwezi nə kàrɩ̀ ʋ zwɛ̀e, ʋ nan Galile nagwanaa tə wa, ʋ va Zwide nagwanaa wa, Zwurədɛn mʋnaa tə vàn don nə. ");
INSERT INTO nnw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lalʋʋ púə́ ʋ kwa, ʋ ga zwɛ̀e ba yayɩŋa yayɩran, kʋ bwálɩ́ təntə wa. ");
INSERT INTO nnw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","*Farɩzɩan-ba tə duən fàrʋ́ ba yí ʋ yɩra, ba bwe wá, sə ba ma ja ʋ də̀ń nə, ba wʋ́: «Kʋ mɛ, sə bɛɛ dʋgʋ ʋ kan yoo mama də̀ń nə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Zwezi ma le, ʋ wʋ́: «Á wà kàrɩ̀, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Máŋá tə, Yɩɩ nə fwa lʋʋ, ʋ fwa bɛɛ də kan, ");
INSERT INTO nnw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ʋ ga swɩ̀n, ʋ wʋ́: Kʋ mʋ̀ yɩrɩ nə, bɛɛ wá nan ʋ yá ʋ nuu də ʋ nyɩna, ʋ ga vwa ʋ tɩ̀àn ʋ kan nə. Yá ba mɛ bələ dàń wá jì won nədʋ›.» ");
INSERT INTO nnw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Zwezi swɩ̀n ʋ súrí lá, ʋ wʋ́: «Yá ba kʋ́ʋ̀ ba yà lɩ̀à bələ, ba dàń wá yà won nədʋ. Ləzwənə mama kʋ́ʋ̀ wa mɛ, sə ʋ dàn ká pwɛ̀e kʋ tə, Yɩɩ nə vwə duən nə!» ");
INSERT INTO nnw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farɩzɩan-ba ma bwe wá, ba wʋ́: «Bɛ̀eɛ̀e dàń nə pɩn Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, ma pa nii də, bɛɛ nə pɩ̀à ʋ dʋgʋ ʋ kan, sə ʋ pa wá ka kwa kasweri sagɩ?» ");
INSERT INTO nnw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Zwezi ma le, ʋ wʋ́: «Moyizə pɩn cwəŋə, sə á dʋgʋ á kana tə, á zɩbaniun tə yɩrɩ. Yá máŋá tə wa, Yɩɩ nə fwa lʋʋ, kʋ yà tà nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","À mʋ̀ nə swɩ̀n kʋ á con: Bɛɛ tə, ʋ nə dʋgʋ ʋ kan, kʋ ga tà ʋ jɩn wá kacwan wa, ʋ ga swe kan don, ʋ mʋ̀ bɛɛ təntə fwa bacwan». ");
INSERT INTO nnw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ʋ karbɩa tə ma swɩ̀n ʋ con, ba wʋ́: «Də kʋ nə yɩ nətʋ kʋ pa bɛɛ nə ʋ kan con nə, ʋ nə wà swe nə kʋkwa». ");
INSERT INTO nnw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Lɩ̀à mama wàrɩ̀ kʋ yoo təntə də̀ń ba nì, də kʋ nə tà ba tə, Yɩɩ nə pɩn, sə ba nì kʋ də̀ń, cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yìə̀n dáá zənzən, tə nə káŋá lɩ̀à nə, sə ba dàn ká swe. Ba duən yɩ ba lʋrɩ ba nətʋ. Ba duən də yɩ lɩ̀à nə pɩn, ba jì batanɩ ba wàrɩ̀ kan ba swe. Ba talɩkwa lɩ̀à tə yɩ ba tə, ba nə tà Yɩɩ pàrɩ̀ yìə̀n tə yɩrɩ, ba ba swe. Lìù tə, ʋ nə wàá kʋ də̀ń ʋ nì, sə ʋ nì!» ");
INSERT INTO nnw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lɩ̀à jɩn bìsɩ́ná, ba bà Zwezi con nə, sə ʋ tún ʋ jɩ̀àn ba yuu wa, ʋ lòrì Yɩɩ ʋ pa ba. Yá ʋ karbɩa tə dàń wulə ba caga ba nii nə. ");
INSERT INTO nnw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Á yaga bìsɩ́ná tə, sə ba bà à con nə! Á dànà ká cɩ̀ ba nə! Yɩɩ pàrɩ̀ tə nə yɩ ba tə, ba nə nyɩn ndə ba nə tə nyiən». ");
INSERT INTO nnw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ʋ nə tún ʋ jɩ̀àn ba yuu ʋ zwɛ̀e, ʋ zàn kʋ bwálɩ́ tə nə, ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bɛɛ don fàrʋ́ ʋ yí Zwezi yɩra, ʋ ga bwe wá, ʋ wʋ́: «Karnyɩna, bɛ̀eɛ̀e nə à mɛ, sə à tʋn, kʋ nə ziən, sə à ma na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con?» ");
INSERT INTO nnw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Zwezi ma le wá, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, n ma bwe nə kʋ tə yuu wa, kʋ nə ziən? Lìù nədʋ cɩcɩ nə ziən. Də n nə pɩ̀à, sə n na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con, sɛ̀e n twá Yɩɩ *nii yìə̀n tə nə, ʋ nə pɩn *Moyizə nə». Ʋ ma bwe wá, ʋ wʋ́: «Yɩɩ nii yoo kʋ kaa tətə?» ");
INSERT INTO nnw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Zwezi ma le, ʋ wʋ́: «Dàn ká gʋ lìù! Dàn ká cwàrɩ̀! Dàn ká ŋʋ! Dàn ká kʋna kʋnkʋn, n kə lìù nii nə! ");
INSERT INTO nnw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Zìlí n nuu də n nyɩna nii! Sóní n yɩra lìù ndə n tətə nə!» ");
INSERT INTO nnw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Balandʋrʋ tə ma swɩ̀n ʋ con, ʋ wʋ́: «À twá Yɩɩ nii yìə̀n təntə mama nə. Bɛ̀eɛ̀e don nə à kʋ́ʋ̀ mɛ, sə à fwa?» ");
INSERT INTO nnw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Zwezi ma le wá, ʋ wʋ́: «Də n nə pɩ̀à, sə n ya lìù tə, Yɩɩ yìə̀n tə nə bɩga n yuu wa, vəli n tì n wiən tə mama, n nə jə, n yoli, n ga pa səbiu tə zʋra nə. Yá n wá na wiən tə, tə kwənə nə dáá, Yɩɩ *sàń nə. Kʋ kwa nə, n dàń bà n twá à nə!» ");
INSERT INTO nnw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yá máŋá tə wa, balandʋrʋ tə nə nì tə mʋ̀ yìə̀n təntə, ʋ vìí də pucʋnɩ, ʋ nə yɩ jɩjə nəfarʋ tíú tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zwezi dàń ma swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ cà zənzən kʋ pa jɩjə tíú nə, sə ʋ zʋ Yɩɩ pàrɩ̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yá à mʋ̀ nə swɩ̀n kʋ á con nə: Nyʋgʋma ka twá gancɩɩn bʋʋ kʋ nan yɩ mwálɩ́, kʋ doni jɩjə tíú nə pɩ̀à, sə ʋ zʋ Yɩɩ pàrɩ̀ tə wa». ");
INSERT INTO nnw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Máŋá tə nə, karbɩa tə nə nì tə yìə̀n təntə, kʋ gwárɩ́ ba zəni. Yá ba ga swɩ̀n, ba wʋ́: «Də kʋ nə yɩ nətʋ, wàà dàń nə wá wànɩ́ ʋ na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con?» ");
INSERT INTO nnw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zwezi ma ywàń ba, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Ləzoni mʋ̀ con kʋ wàrɩ̀! Yá tə mɛ wàá Yɩɩ mʋ̀ con». ");
INSERT INTO nnw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyɛrə dàń ma swɩ̀n, ʋ wʋ́: «Ywàń, nə dʋgʋ won mama, nə ga twá n nə. Kʋ dàń wá yà nətə kʋ pa nəba?» ");
INSERT INTO nnw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Máŋá wá bà, *Ləzwənə-Biu tə nə wá jə̀ń ʋ dun padaʋ tə yuu, lʋʋ nədʋn tə wa. Á mʋ̀ karbɩa fugə bələ tə, á nə twá à nə, á də wá jə̀ń padaran yuu wa. Kʋ máŋá tə wa, á də wá bʋ̀rɩ̀ *Yɩzərayɛlə dwíí dəkurən fugə bələ tə lɩ̀à bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yá lìù tə mɛ, ʋ nə wá taa à mʋ̀ yɩrɩ, ʋ nan ʋ yá ʋ dii, nə à yə̀ə́ ʋ nubɩa, nə à yə̀ə́ ʋ nakwana, nə à yə̀ə́ ʋ nuu, nə à yə̀ə́ ʋ nyɩna, nə à yə̀ə́ ʋ bìsɩ́ná, nə à yə̀ə́ ʋ kárɩ́, ʋ wá na ŋwɩ́rán nɛɛ bíí. Kʋ tə nə súrí lá, ʋ wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Təntən lɩ̀à dáá, ba nə wá yà talɩkwa lɩ̀à. Yá talɩkwa lɩ̀à də ga dáá, ba nə wá yà təntən lɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Nə̀ń, Yɩɩ pàrɩ̀ tə nə nyɩn nətʋ: Kárá tíú don nan jɩjʋ fuən fuən, sə ʋ pɩ̀à tʋ̀tʋ̀nà, ʋ kə ʋ kárá wa. ");
INSERT INTO nnw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Máŋá tə, ʋ nə nɩ ba, ʋ sɛ̀e, sə ʋ ŋwɩ́n ba cɩnɩa səbikʋlʋ nədʋ, ndə kʋ nə mɛ nətʋ tə dɩɩn mama. Yá ʋ ga tʋn ba, sə ba va ba tʋn ʋ kárá tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ʋ tə pìí ʋ nan lugu nʋgʋ máŋá wa jɩjʋ nə, ʋ kʋ́ʋ̀ na ba duən ba jə̀ə́ tʋtʋ. ");
INSERT INTO nnw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ʋ ma swɩ̀n ba con, ʋ wʋ́: ‹Á vələ, sə á də tʋn à kárá tə wa. Yá à ga wá pa á də nə, ndə kʋ nə mɛ nətʋ!› ");
INSERT INTO nnw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ba də ma kɛ̀eń ba va lá nə. Yɩcaʋ lugu fugə bələ máŋá wa, bɛɛ tə kʋ́ʋ̀ nan. Dədəni lugu batwa máŋá wa, ʋ kʋ́ʋ̀ ʋ nan ʋ fwa, ndə dí yáá tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yá kʋ nə kʋ́ʋ̀ yí dədəni lugu bonu, ʋ nan ʋ ma kʋ́ʋ̀ na ba duən, ba nə zɩga. Ʋ ma bwe ba, ʋ wʋ́: ‹Bɛ̀eɛ̀e nə pɩn, á zɩga yəbə jɩjʋ tə mama, á ga ba won fwa?› ");
INSERT INTO nnw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ba le wá, ba wʋ́: ‹Kʋ yɩ lìù nə wà nəba tì, sə nə tʋn.› Ʋ ma swɩ̀n ba con, ʋ wʋ́: ‹Haya! Á də vələ, á tʋn à kárá tə wa!› ");
INSERT INTO nnw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Dədəni nə twi kʋ yí, kárá tə tíú swɩ̀n ʋ lìù tə, ʋ nə ywàŋá ʋ tʋtʋnan tə yuu con, ʋ wʋ́: ‹Bon tʋ̀tʋ̀nà tə, sə n pa ba lìù mama ʋ ŋwɩ́rán. N wá zɩgɩ talɩkwa lɩ̀à tə, à nə tì tə, n ja va ba tə, à nə dí yáá à tì tə.› ");
INSERT INTO nnw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ba tə, ba nə vəli dədəni nii lugu bonu máŋá wa, ba tʋn tə twi ba yí. Ba lìù mama nɩ cɩnɩa səbikʋlʋ nədʋ nədʋ. ");
INSERT INTO nnw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Máŋá tə, ba tə, ba nə təntən ba tʋn tə nə twi, ba yà bʋŋa də, ba wá na ba doni ba duən tə. Yá ba dàń pɩn ba də lìù mama nə, cɩnɩa səbikʋlʋ nədʋ nədʋ, ndə nətʋ tə, ba nə pɩn ba duən tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba na nɩ kʋ nətʋ, ba wulə ba ŋʋŋwɩn kárá tə tíú yuu wa, ");
INSERT INTO nnw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ba ga swɩ̀n, ba wʋ́: ‹Tʋ̀tʋ̀nà tə, n nə talɩkwa n tì tə, tʋn lugu nədʋ cɩcɩ, yá n ga ŋwɩ́n ba ndə nə nə. Nə mʋ̀ ga tʋn nə gwàrɩ̀ dɩɩn tə mama wa, yɩcaʋ tə nyʋa nə yuu wa, jɩjʋ tə mama›. ");
INSERT INTO nnw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yá kárá tə tíú dàń le ba wá don, ʋ wʋ́: ‹À dabɛɛ, à wà mʋ́ gɩgɩrɩ. N sɛ̀e, sə n tʋn cɩnɩa səbikʋlʋ nədʋ yɩra dɩɩn wa, kʋ tà nətʋ, naaa? ");
INSERT INTO nnw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jon n ŋwɩ́rán, n ja kɛ̀eń lá nə! À wá pa talɩkwa lìù tə də ŋwɩ́rán ndə n nə. ");
INSERT INTO nnw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","À ba cwəŋə jə, sə à fwa kʋ tə, à nə swə, də à səbiu, naaa? Nə à yə̀ə́ kʋ yɩ à nə yɩ pubwanʋ tíú tə nə pɩn n jə wʋgwɩʋ də nə?› » ");
INSERT INTO nnw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zwezi ma swɩ̀n ʋ súrí, ʋ wʋ́: «Mə nətʋ nə, təntən lɩ̀à wá yà talɩkwa lɩ̀à, yá talɩkwa lɩ̀à də wá yà təntən lɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dɩɩn don nə, Zwezi zʋa cwəŋə, ʋ vələ *Zwerizalɛmə. Máŋá tə wa, ʋ nə wulə cwəŋə tə yuu wa, ʋ bon ʋ karbɩa fugə bələ tə, ʋ ja nan kwa, ʋ ga swɩ̀n ba con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Á cʋga zəni, nə wulə cwəŋə wa, nə ma vələ Zwerizalɛmə. Mə tɩʋ təntə wa nə, ba wá ja *Ləzwənə-Biu tə, ba kə *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án, də Yɩɩ nii *yənu tɩ̀án jɩ̀àn wa. Ba wá bʋ̀rɩ̀ ʋ bʋ̀rà, sə ba gʋ wá. ");
INSERT INTO nnw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ba wá kə wá lɩ̀à tə, ba nə yə̀rì Yɩɩ, jɩ̀àn wa. Ba wá mʋn wá, ba wá mà wá, ʋ yɩra lá, ba ga wá paa wá dagarʋ yuu wa. Yá dɩan batwa nii nə, Yɩɩ wá pìí ʋ bwin wá, ʋ lɩ tɩan wa». ");
INSERT INTO nnw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kʋ kwa nə, Zebede bɩa tə nuu dàń ma fàrʋ́ ʋ yí Zwezi yɩra də ʋ bɩa tə. Ʋ tʋa ʋ yáá yuu, sə ʋ lòrì won ʋ con. ");
INSERT INTO nnw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zwezi ma bwe wá, ʋ wʋ́: «Bɛ̀eɛ̀e nə n pɩ̀à?» Kan tə ma le, ʋ wʋ́: «À pɩ̀à, sə n pa nii də, à bɩa bələ tə, ba nə zɩga, wá jə̀ń ladʋa n jɩzən nə, ʋ don n jɩgwiə nə, n pàrɩ̀ tə máŋá wa». ");
INSERT INTO nnw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Zwezi ma le kan tə də ʋ bɩa tə, ʋ wʋ́: «Á yə̀rì kʋ tə, á nə lòrì. Á wá wànɩ́ á zɩgɩ á dàn càn tə, à nə wá də́ naaa?» Ba ma swɩ̀n ʋ con, ba wʋ́: «Nə wàá». ");
INSERT INTO nnw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zwezi ma swɩ̀n, ʋ wʋ́: «Á cɩ́gá wá zɩgɩ á dàn tə. Yá kʋ tà à mʋ̀ nə mɛ, sə à pa nii də, lìù wà tə nə wá jə̀ń à jɩzən nə, nə à yə̀ə́ à jɩgwiə nə. Tə bwálá təntə yɩ à nyɩna Yɩɩ nə kwɛn, sə ʋ pa lɩ̀à tə nə, tə nə mɛ də ba, kʋ tà à mʋ̀». ");
INSERT INTO nnw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Máŋá tə nə, karbɩa fugə tə duən tə nə nì kʋ, ba lɩŋa zàn ba nubɩa bələ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zwezi dàń ma bon ba mama tə, ʋ kə duən yáá, ʋ ga wʋ́: «Á yə̀ə́ də, lʋʋ pɛ̀egá yàá jə̀ə́ ba lɩ̀à yuu wa, ba fɩfɩn ba. Yá də ləzwənfaran tə də yàá də́ pàrɩ̀ ba lɩ̀à yuu wa də dɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yá nətʋ nə wà mɛ, sə kʋ fwa á mʋ̀ pwərə wa. Á lìù tə, ʋ nə pɩ̀à, sə ʋ yà ləzwənfarʋ, ʋ mɛ, sə ʋ yà á tʋtʋnbiu. ");
INSERT INTO nnw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yá á lìù tə, ʋ nə pɩ̀à, sə ʋ yà á yáá tíú, ʋ mɛ, sə ʋ yà á yoŋu. ");
INSERT INTO nnw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mə nətʋ nə, *Ləzwənə-Biu tə tà ʋ twi, sə ʋ pa lɩ̀à tʋn, ba pa wá. Ʋ yɩ ʋ twi, sə ʋ tʋn ʋ pa lɩ̀à nə. Yá ʋ ga pa ʋ mɩɩ tə ndə ŋwɩ́rán nə, sə ʋ ma jon lɩ̀à kapʋpʋ ba cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Máŋá tə wa, Zwezi də ʋ karbɩa tə nə naŋa Zweriko, lalʋʋ púə́ Zwezi kwa. ");
INSERT INTO nnw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lilirən bələ tə nə jə̀ə́ cwəŋə nii nə nì də, Zwezi twi ʋ lɛ. Ba dàń ma wulə ba bubwi, ba wʋ́: «*Yuu-Tiu, pɩ̀ʋ́ *Davidə nàʋ́, dəri nə yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lɩ̀à tə yà wulə, ba caga ba nii nə, də ba táŋá ba níə́. Yá ba dàń tə kwɛn ba bubwi zənzən, ba wʋ́: «Yuu-Tiu, pɩ̀ʋ́ Davidə nàʋ́, dəri nə yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zwezi ma zɩgɩ, ʋ bon ba, ʋ ga bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə á pɩ̀à, sə à fwa à pa aba?» ");
INSERT INTO nnw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ba ma le wá, ba wʋ́: «Yuu-Tiu, pa, sə nə yɩ́á tə na lá». ");
INSERT INTO nnw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Zwezi dəri ba yinəgə, ʋ ga dwen ba yɩ́á nə. Lala də ba bara bələ təntə yɩ́á tə súrí. Yá ba dàń ga pú ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zwezi də ʋ karbɩa dàń vəli, ba bwələ *Zwerizalɛmə. Máŋá tə, ba nə yí Bɛtəfazwe nə, kʋ nə wulə *oliviye tɩ̀án paan tə con, Zwezi lɩ ʋ karbɩa tə bələ, ʋ tʋn, ");
INSERT INTO nnw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á vələ yáá tɩʋ tə wa, á wá na bɩnakan də kʋ bìú, tə nə vwə. Á kʋra tə, á ja bà à con. ");
INSERT INTO nnw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lìù nə bwe aba, sə á swɩ̀n də, *Yuu-Tiu nə pɩ̀à tə. Yá ba dàń wá yá aba, ba pa á ja tə á vìí lala». ");
INSERT INTO nnw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mə nətʋ nə, kʋ twá, sə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə sʋ̀ràn tə nii ma sú. Ʋ swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Á swɩ̀án Siyon lɩ̀à con nə: Nə̀ń, n pɩ̀ʋ́ tə nə ʋ bɩ̀àn n con. Ʋ súə́ də bɩcabwanʋ. Ʋ dɩ̀gà bɩnakan yuu. Ʋ dɩ̀gà bɩnabiə yuu, ka nə yɩ bɩnakan tə, ka nə mɩ̀ zɩla zɩŋʋ, bìú.» ");
INSERT INTO nnw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Karbɩa tə dàń ma va, ba fwa kʋ tə, Zwezi nə pɩn ba nii, sə ba fwa. ");
INSERT INTO nnw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba jɩn bɩnakan tə də bɩnabiə tə, ba ja bà, ba lɩ ba ganan ba tún tə yuu, ba pa Zwezi dɩ̀ ʋ jə̀ə́. ");
INSERT INTO nnw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lalʋʋ tə wa lɩ̀à zənzən làrɩ̀ ba ganan cwəŋə tə wa. Ba duən də ga za tɩ̀án vʋran, ba tuŋə cwəŋə tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lɩ̀à tə, ba nə wulə Zwezi yáá ba vəli, də ba tə, ba nə wulə ʋ kwa tə, zɩ̀n ba kwərə yɩɩ nə, ba ma bwɩ Zwezi nə, ba wʋ́: «Ozana pɩ̀ʋ́ *Davidə nàʋ́ tə yuu wa! Yɩɩ wá fwa zəni lìù tə yɩra, ʋ nə bɩ̀àn Yuu-Tiu yɩrɩ yuu wa! Ozana Yɩɩ sàń nə!» ");
INSERT INTO nnw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Máŋá tə nə, Zwezi nə zʋa Zwerizalɛmə wa, lɩ̀à tə mama wulə ba kukuri, də ba bwe, ba wʋ́: «Wàà nə yɩ kʋ bɛɛ wà tə?» ");
INSERT INTO nnw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lalʋʋ tə le, kʋ wʋ́: «Kʋ yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Zwezi tə, ʋ nə nan *Nazarɛtə, kʋ nə wulə Galile nagwanaa wa». ");
INSERT INTO nnw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kʋ kwa nə, Zwezi zʋa *Zwifə-ba Yɩɩ *dìə̀ dəwoo tə wa, ʋ ga dɩŋɩ lɩ̀à tə mama, ba nə yoli, də ba tə nə yə̀ kʋ bwálɩ́ tə wa. Ʋ yigu tabɩlan tə, lɩ̀à tə nə lárɩ́ səbɩa tə yuu, ʋ vəvəri ʋ pú tɩa. Ʋ ga yigu lɩ̀à tə, ba nə yoli nasara gunponi tə, gwələ ʋ dɩ tɩa. ");
INSERT INTO nnw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Ba wá bon à dìə̀ tə «yɩjʋnɩ dìə̀».› Yá á mʋ̀ janɩ ka, á ma fwa ŋwɩna yisəgə bwálɩ́!» ");
INSERT INTO nnw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lilirən də gwànɩ́ fàrʋ́ ba yí ʋ yɩra Yɩɩ dìə̀ dəwoo tə wa. Yá ʋ ga zwɛ̀e ba yayɩran. ");
INSERT INTO nnw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə, nə nɩ yomɩlan tə, ʋ nə fwa, bìsɩ́ná tə ga wulə Yɩɩ dìə̀ dəwoo tə wa, ba bubwi, ba wʋ́: «Ozana pɩ̀ʋ́ *Davidə nàʋ́ tə yuu wa!» Kʋ zɩ̀n ba lɩŋa. ");
INSERT INTO nnw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ba dàń swɩ̀n Zwezi con, ba wʋ́: «N nə̀ń kʋ tə, bìsɩ́ná tə nə swɩ̀n?» Zwezi ma le ba, ʋ wʋ́: «Awo, à yə̀ə́ kʋ də̀ń. Á wà kʋ tə kàrɩ̀, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, naaa? Kʋ pʋ́pʋ́nɩ́, kʋ wʋ́: ‹N pɩn bìsɩ́ná də bìsɩ́nɩ́ tətə də pa mʋ́ dun›.» ");
INSERT INTO nnw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kʋ kwa nə, ʋ yá ba, ʋ ga nan *Zwerizalɛmə nə, ʋ va Betani. Mə kʋ tɩʋ tə wa, ʋ vəli ʋ jʋ. ");
INSERT INTO nnw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kʋ tɩpʋrʋ tə nə, máŋá tə wa, Zwezi nə pìí ʋ bɩ̀àn *Zwerizalɛmə wa, niən yà jə wá. ");
INSERT INTO nnw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ʋ nɩ kapɩrʋ don cwəŋə tə vàn nə, ʋ ma fàrʋ́ ʋ yí kʋ nii, yá kʋ yɩ vʋran cɩcɩ nə, ʋ nɩ kʋ yuu wa. Ʋ dàń ma swɩ̀n kapɩrʋ tə con, ʋ wʋ́: «N kʋ́ʋ̀ ba pìí n zɩn bɩa, abada!» Lala də kapɩrʋ tə kʋa nəkʋrʋ. ");
INSERT INTO nnw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Karbɩa tə nə nɩ kʋ nətʋ tə, kʋ gwárɩ́ ba zənzən. Ba dàń ma bwe Zwezi, ba wʋ́: «Kʋ yɩ kʋ twá nətə, kapɩrʋ tə ma kʋ̀ lala nətʋ?» ");
INSERT INTO nnw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Zwezi ma le ba, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Də á nə keni á waa à nə wuuu, á nə ba bɛ̀eé, kʋ tà kʋ tə, à nə fwa kapɩrʋ tə yɩra, cɩcɩ nə, á wá wànɩ́ á fwa. Yá á dàń wá wànɩ́ á swɩ̀n paan ka tə con, á wʋ́: ‹Zàn lá, n va, n tʋ mʋʋ wa!› Yá kʋ yoo tə wá tʋn. ");
INSERT INTO nnw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Də á nə keni á waa à nə wuuu, á wá na kʋ tə mama, á nə lòrì Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zwezi zʋa *Zwifə-ba Yɩɩ *dìə̀ tə wa, ʋ wulə ʋ kàrɩ̀. Kʋ máŋá tə wa, Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də ba *nəkwɩna fàrʋ́ ba yí ʋ yɩra, ba ga bwe wá, ba wʋ́: «Wàà tətə dɩ̀àn nə, n ma fwa yìə̀n tə tə ba? Wàà nə ken dɩ̀àn təntə n jɩɩn wa?» Zwezi ma le ba, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","«À də kʋ́ʋ̀ wá bwe aba yoo nədʋ cɩcɩ. Á nə le nə, kʋ kwa nə, à də dàń wá swɩ̀n lìù tə, ʋ nə ken dɩ̀àn à jɩɩn wa, à ma fwa tə yìə̀n tə. ");
INSERT INTO nnw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wàà nə ken dɩ̀àn Zwan jɩɩn wa, sə ʋ lə lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ tə? Kʋ ya Yɩɩ, nə à yə̀ə́ ləzoni?» Kʋ pɩn ba dàń wulə ba tʋ́tʋ̀nɩ́ duən, ba ga swɩ̀n duən con, ba wʋ́: «Nə nə le, nə wʋ́: ‹Kʋ ya Yɩɩ nə ken dɩ̀àn Zwan jɩɩn wa›, ʋ wá bwe nəba, ʋ wʋ́: ‹Bɛ̀eɛ̀e dàń nə pɩn, á ma wà cɩ́gá à sʋgʋ tə nə pɩn?› ");
INSERT INTO nnw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nə ma nə kʋ́ʋ̀ swɩ̀n, nə wʋ́: ‹Kʋ yɩ ləzoni nə ken dɩ̀àn ʋ jɩɩn wá›, nə mɛ, sə nə dəri lalʋʋ tə fən, lɩ̀à tə mama nə bʋŋa də, Zwan yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ba dàń ma le Zwezi, ba wʋ́: «Nə yə̀rì». Zwezi də ma le ba, ʋ wʋ́: «À də bá swɩ̀n lìù tə, ʋ nə ken dɩ̀àn à jɩɩn wa, à ma fwa tə yìə̀n təntə». ");
INSERT INTO nnw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Zwezi kʋ́ʋ̀ súrí zwansɩsara tə don lá, ʋ wʋ́: «À wá bɩrɩ aba zwansɩsara don, sə á swɩ̀n kʋ tə, á nə bʋŋa kʋ yuu wa: Bɛɛ don yà jə bɩa bələ. Ʋ dàń ma swɩ̀n təntən bìú tə con, ʋ wʋ́: ‹À bìú, vəli à kárá tə wa, n tʋn zə̀n kʋ tə!› ");
INSERT INTO nnw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ʋ ma le, ʋ wʋ́: ‹À ba vələ›. Yá kʋ nə vəli yáá, ʋ pìí ʋ lwàń pubʋŋa, ʋ ga vu kárá tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kʋ kwa nə, nyɩna tə ma swɩ̀n bìú tə don tə con, kʋ mʋ̀ yoo nədʋ tə. Ʋ də ma le wá, ʋ wʋ́: ‹À nyɩna, à wá va›. Yá ʋ wà vəli. ");
INSERT INTO nnw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bɛ̀eɛ̀e nə á bʋŋa kʋ yoo tə yuu wa? Á mʋ̀ con nə, ba wàà nə twá ʋ nyɩna tə fɩra nə?» Ba le, ba wʋ́: «Kʋ yɩ təntən lìù tə nə». Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lanpolɩna tə də kacwaran tə wá də́ yáá, ba zʋ Yɩɩ pàrɩ̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zwan yɩ ʋ twi á con nə, sə ʋ bɩrɩ aba cɩ́gá cwəŋə tə. Yá á ga wà cɩ́gá pɩn ʋ sʋgʋ tə nə. Yá lanpolɩna tə də kacwaran tə mʋ̀ pɩn cɩ́gá ʋ sʋgʋ tə nə. Yá də á nə nɩ kʋ tə kwa nə, á tə wà á kwa vəvəri, á ma sá á cʋna, sə á ma pa cɩ́gá ʋ sʋgʋ tə nə». ");
INSERT INTO nnw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á cʋga zwansɩsara don! Kárá tíú don cwɛn divɛn tɩ̀án kárá. Ʋ kɩkarɩ ka də dabwaʋ. Ʋ kʋ̀ gwàlʋ́ kapataʋ wa, sə ba ma kaŋɩ divɛn tɩ̀án bɩa tə. Yá ʋ dàń ga lwà vuun, sə ba ma cɩ̀ kárá tə nə. Kʋ kwa nə, ʋ tì kárá tə, ʋ yá vala duən jɩ̀àn wa, ʋ ga va cwəŋə. ");
INSERT INTO nnw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Máŋá tə, divɛn tɩ̀án bɩa koru nə yí, ʋ tʋn ʋ tʋ̀tʋ̀nà, ʋ pa ba va vala tə con, sə ba jon ʋ tori. ");
INSERT INTO nnw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yá vala tə dàń jɩn ʋ tʋ̀tʋ̀nà tə, ba mà ʋ don, ba gʋ ʋ don, ba ga dɩlɩ batwa nii lìù tə də kapana ba gʋ. ");
INSERT INTO nnw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kárá tə tíú tə kʋ́ʋ̀ tʋn tʋ̀tʋ̀nà tə duən, də ba nə dáá ba doni dí yáá tʋ̀tʋ̀nà tə. Yá vala tə tə tʋn ba, də ndə ba nə dí yáá ba tʋn nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ʋ dàń ma tʋn ʋ tətə bilʋra ba con, ʋ ga bʋ́n ʋ waa con, ʋ wʋ́: ‹Ba wá zìlí à bìú tə›. ");
INSERT INTO nnw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yá máŋá tə wa, vala tə nə nɩ bìú tə, ba dàń swɩ̀n duən con, ba wʋ́: ‹Á nəŋə lìù tə, ʋ nə wá bà ʋ tɩnɩ kárá tə. Nə gwɩa wá, yá nə wá tɩnɩ ʋ kárá tə›. ");
INSERT INTO nnw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba dàń ma ja wá, ba dɩlɩ kárá tə kwa con, ba ga gʋ wá». ");
INSERT INTO nnw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Zwezi ma bwe ba, ʋ wʋ́: «Máŋá tə nə, kárá tə tíú nə wá bà, bɛ̀eɛ̀e nə ʋ wá fwa vala tə?» ");
INSERT INTO nnw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ba ma le wá, ba wʋ́: «Ʋ wá gʋ ba ləzwənlwan təntə, ʋ bá dəri ba yinəgə. Ʋ dàń ga wá jon ʋ kárá tə, ʋ pa vala duən nə, ba nə wá lɩ ʋ tori wozagʋ máŋá wa». ");
INSERT INTO nnw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Zwezi dàń swɩ̀n, ʋ wʋ́: «Á wà kàrɩ̀ kʋ tə, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Kapan tə, də̀lwə̀rə́ tə yà nə vɩga ba dʋgʋ vàn nə, nə pìí kʋ jì dìə̀ nigwancɩɩn wárɩ́, kʋ yoo nə cà. Kʋ yɩ *Yuu-Tiu nə fwa kʋ. Yá kʋ yɩ yozəŋu kʋ pa nəba›.» ");
INSERT INTO nnw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ súrí lá, ʋ wʋ́: «Mə kʋ mʋ̀ nə pɩn, à mʋ̀ nə swɩ̀n kʋ á con: Yɩɩ wá lɩ aba ʋ pàrɩ̀ tə wa, ʋ ga pa dwíí don lwàń kʋ ya lá, kʋ nə sɛ̀e ʋ nii, yá kʋ ga tʋŋa zəni. ");
INSERT INTO nnw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lìù tə mama, ʋ nə wá tʋ kʋ kapan tə, də̀lwə̀rə́ tə yà nə dʋgʋ vàn nə, yuu wa, ʋ wá nyʋnyʋgʋ ʋ tɩ̀àn kʋ nə. Yá kʋ nə kʋ́ʋ̀ tʋa lìù yuu wa, də kʋ wá tɩtaga wá!» ");
INSERT INTO nnw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án-ba, də *Farɩzɩan-ba cʋgʋ Zwezi zwansɩsarɩ təntə, ba ga lwarɩ də, kʋ yɩ ba mʋ̀ nə, ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba dàń pɩ̀à cwəŋə, sə ba ma ja wá. Yá ba ga dəri lalʋʋ tə yɩ́á, ba nə tì Zwezi, ba ma fwa ndə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ nə tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zwezi tə kʋ́ʋ̀ twá zwansɩsarɩ nə, ʋ swɩ̀n ba con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Á nəŋə, Yɩɩ pàrɩ̀ tə nə yɩ nətʋ: Pɩ̀ʋ́ don bon lɩ̀à ʋ bìú fúrú diŋə nə. ");
INSERT INTO nnw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ʋ tʋn ʋ tʋ̀tʋ̀nà, sə ba bon lɩ̀à tə, sə ba bà diŋə tə bwálɩ́ nə. Yá ba wà sɛ̀e, sə ba bà boŋə tə. ");
INSERT INTO nnw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ʋ ma kʋ tʋn tʋ̀tʋ̀nà tə duən də nii kʋ tə, ʋ wʋ́: ‹Á swɩ̀án lɩ̀à tə con də, à wodiu tə fwa kʋ zwɛ̀e. À gʋa à nabɛɛ də à vàná tə, tə nə jə nʋga, tə mama sírí ken kʋ zwɛ̀e. Á bɩ̀àn fúrú diŋə tə!› ");
INSERT INTO nnw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yá lɩ̀à tə, ʋ nə bon tə, tà nə wà kʋ yoo tə tì, ba ma fwa kaka, ba ga zàn, ba va ba yìə̀n kwɩʋn nə. Ʋ don va ʋ kárá wa, ʋ don va ʋ yolu. ");
INSERT INTO nnw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ba duən tə jɩn tʋ̀tʋ̀nà tə, ba fɩfɩn ba, ba gʋ. ");
INSERT INTO nnw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pɩ̀ʋ́ tə lɩŋa dàń zàn. Ʋ tʋn ʋ pamana, ʋ pa ba va, ba gʋ kʋ mʋ̀ lagʋra təntə, ba ga sʋrʋ ba tɩʋ. ");
INSERT INTO nnw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ʋ dàń ma swɩ̀n ʋ tʋ̀tʋ̀nà tə con nə, ʋ wʋ́: ‹Fúrú tə wodiu fwa kʋ zwɛ̀e. Yá lɩ̀à tə, à nə bon tə, wà kʋ diŋə mɛ. ");
INSERT INTO nnw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Á dàń vələ cwəywərə tə wa, á bon ba tə mama, á nə nɩ lá, sə ba bà wodiu tə nə.› ");
INSERT INTO nnw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tʋ̀tʋ̀nà tə vəli coŋi tə yuu, ba kə lɩ̀à tə mama duən nə, ba nə nɩ lá. Ba ken ləzwənzəŋə də ləzwənkʋkwɩnan duən nə. Mə kʋ twá nətʋ, fúrú tə diŋə dìə̀ nii ma sú də lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pɩ̀ʋ́ tə dàń zʋa, sə ʋ ywàń lɩ̀à tə, ba nə twi boŋə tə. Yá ʋ dàń nɩ lìù don, ʋ nə wà gànʋ̀ zwɩ, kʋ nə mɛ də fúrú tə. ");
INSERT INTO nnw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ʋ ma swɩ̀n ʋ con, ʋ wʋ́: ‹À dabɛɛ, kʋ yɩ n twá nətə, n ma zʋ yəbə, n ga wà gànʋ̀ zwɩ, kʋ nə mɛ də fúrú tə?› Yá kʋ bɛɛ tə táŋɩ́ ʋ nii. ");
INSERT INTO nnw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pɩ̀ʋ́ tə dàń ma swɩ̀n ʋ tʋ̀tʋ̀nà tə con, ʋ wʋ́: ‹Á vwiə ʋ nɛɛ də ʋ jɩ̀àn, á ga tì wá, á dɩlɩ kàrá wa yikunu tə wa. Kʋ bwálɩ́ təntə wa, ʋ wá bubwi, ʋ ga dɩŋa ʋ jɩfwɩ ʋ fɩfaga›.» ");
INSERT INTO nnw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yɩɩ boŋə lɩ̀à zənzən. Yá ba mancɩn nə, Yɩɩ yàá kúrí». ");
INSERT INTO nnw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","*Farɩzɩan-ba tə dàń vʋrʋ, ba kə duən nə, sə ba jə́n, ba nə wá fwa nətʋ, ba ma ja Zwezi kʋ tə, ʋ nə wá swɩ̀n, yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba dàń ma tʋn ba lɩ̀à, də *Erodə kwa lɩ̀à, sə ba va, ba swɩ̀n Zwezi con, ba wʋ́: «Karnyɩna, nə yə̀ə́ də, n yɩ cɩ́gá tíú. N ga bɩrɩ Yɩɩ cwəŋə tə də cɩ́gá, n ga ba lìù yii dəri, n yáá nə tə̀lə́ də dun tə ləzoni nə jə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bɩrɩ nəba n pubʋŋa yoo kʋ tə yuu wa: Yɩɩ *nii pɩn cwəŋə, sə nə ŋwɩ́n, nə à yə̀ə́, sə nə dàn ká ŋwɩ́n lanpoo, nə pa *Romə-ba pɩ̀ʋ́ nəfarʋ tə nə?» ");
INSERT INTO nnw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yá Zwezi dàń nə lwarɩ ba wʋlʋŋʋ pubʋŋɩ tə, ʋ le ba, ʋ wʋ́: «Níə́ bələ tɩ̀án-ba, bɛ̀eɛ̀e nə pɩn, á maŋa, sə á ja à də̀ń nə? ");
INSERT INTO nnw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Á bɩra nə səbikʋlʋ tə, ba nə ma ŋwɩ́n lanpoo tə». Ba ma lɩ cɩnɩa səbikʋlʋ don, ba kə ʋ yáá con. ");
INSERT INTO nnw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Zwezi dàń ga bwe ba, ʋ wʋ́: «Wàà yuu də ʋ yɩrɩ nə ba pʋ́pʋ́nɩ́ yəbə?» ");
INSERT INTO nnw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ba ma le wá, ba wʋ́: «Romə-ba pɩ̀ʋ́ nəfarʋ tə nə». Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Á ŋwɩ́án kʋ tə nə yɩ Romə-ba pɩ̀ʋ́ nəfarʋ tə nyiən, á pa wá, sə á ga ŋwɩ́n kʋ tə nə yɩ Yɩɩ nyiən, á pa Yɩɩ də nə». ");
INSERT INTO nnw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Máŋá tə nə, ba nə nì kʋ liu təntə, kʋ gwárɩ́ ba zənzən. Ba ma yá wá, ba ga vìí. ");
INSERT INTO nnw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","*Sadɩsɩan-ba mʋ̀ bɩrɩ də, tɩga ba pìí ba bwin ba naŋa. Dɩɩn don nə, ba wa lɩ̀à duən twi Zwezi con. Ba bwe wá, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Karnyɩna, nə̀ń kʋ tə, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ *nii tə wa, ʋ nə pɩn *Moyizə nə. Kʋ swɩ̀n, kʋ wʋ́: ‹Bɛɛ nə tɩga, də ʋ ba bìú jə, ʋ nyánʋ́ mɛ, sə ʋ də́ ʋ kadənu tə, sə ʋ mʋ̀ lʋra bìú, ʋ pa wá›. ");
INSERT INTO nnw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nə dàń jɩn nubɩa barpɛ də nəba. Təntən tíú tə swe, ʋ tɩ ʋ yá kan tə, ʋ pa ʋ nyánʋ́ don nə, də ʋ tə wà bìú, ʋ nə lʋrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mə kʋ yɩ nətʋ, kʋ pa bələ nii lìù tə, də batwa tíú tə, kʋ ja va kʋ gúrí ba mama barpɛ tə. ");
INSERT INTO nnw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ba mama tə tɩan kwa nə, kan tə də twi, ʋ bà, ʋ tɩ. ");
INSERT INTO nnw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dɩɩn tə nə, tɩga nə wá bwin ba nan, ba wàà nə wá tɩnɩ kan tə ba barpɛ tə wa? Ba mama tə jɩn wá, ba fwa ba kan». ");
INSERT INTO nnw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Zwezi ma le ba, ʋ wʋ́: «Á dwə á tɩ̀àn, á nə yə̀rì Yɩɩ sagɩ tə də Yɩɩ dɩ̀àn tə də̀ń yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Máŋá tə, tɩga nə wá pìí ba bwin ba nan, bara də kana bá swe duən nə. Yá ba dàń wá yà ndə *malɩkɛ nə Yɩɩ *sàń wa. ");
INSERT INTO nnw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Á wà kàrɩ̀ kʋ tə, Yɩɩ nə swɩ̀n tɩga ka bwin ka nan tə yuu wa, naaa? Ʋ swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹À yɩ Yɩɩ tə, *Abərahamə də *Yɩzakə də *Zwakɔbə nə jʋ̀nɩ̀›.» Zwezi ma swɩ̀n, ʋ súrí lá, ʋ wʋ́: «Kʋ nətʋ bɩrɩ də, Yɩɩ yɩ lɩ̀à tə, ba nə wulə mɩɩ wa Yɩɩ, ʋ tà tɩga Yɩɩ». ");
INSERT INTO nnw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kʋ gwárɩ́ lɩ̀à tə, ba nə cʋgʋ ʋ kàrà tə. ");
INSERT INTO nnw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Máŋá tə wa, *Farɩzɩan-ba nə nɩ də, ʋ pɩn *Sadɩsɩan-ba tə nii pú, ba bon ba kə duən nə. ");
INSERT INTO nnw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ba wa lìù don, ʋ nə yɩ *Zwifə-ba Yɩɩ nii *yənu tíú bwe Zwezi yoo don, sə ʋ ma ja ʋ də̀ń nə, ʋ bwe wá, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Karnyɩna, sə Yɩɩ *nii yìə̀n tə, ʋ nə pɩn *Moyizə nə wa, nəfarʋ nə yɩ kʋ kwa?» ");
INSERT INTO nnw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Zwezi ma le wá, ʋ wʋ́: « ‹N mɛ, sə n sóní *Yuu-Tiu, ʋ nə yɩ n Yɩɩ də n waa mama. N sóní kʋ tə nə ziən kʋ pa Yɩɩ nə. N bʋ́n Yɩɩ yoo máŋá mama›. ");
INSERT INTO nnw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mə kʋ mʋ̀ nə yɩ Yɩɩ nii yoo tə, kʋ nə yɩ tə wa nəfarʋ, kʋ nə dwə tə mama. ");
INSERT INTO nnw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nə̀ń kʋ tə, kʋ nə púə́ kʋ kwa, kʋ də yoo nə cà zənzən: ‹N mɛ, sə n sóní n yɩra lìù ndə n nə swə n tətə nətʋ›. ");
INSERT INTO nnw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yɩɩ nii tə, ʋ nə pɩn Moyizə nə, saga tə, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə kàrɩ̀ tə mɛ yɩ tə twá tə mʋ̀ Yɩɩ nii yìə̀n bələ təntə kwa». ");
INSERT INTO nnw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","*Farɩzɩan-ba yà kun duən nə, Zwezi dàń ma bwe ba bwiə kʋ tə: ");
INSERT INTO nnw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Bɛ̀eɛ̀e nə á bʋŋa *Kərisə yuu wa? Ʋ yɩ wàà nàʋ́?» Ba ma le wá, ba wʋ́: «Ʋ yɩ pɩ̀ʋ́ *Davidə nàʋ́». ");
INSERT INTO nnw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Zwezi kʋ́ʋ̀ ma bwe ba, ʋ wʋ́: «Kʋ dàń yɩ nətə, Yɩɩ-*Siŋu tə ma pa, Davidə bon Kərisə ‹*Yuu-Tiu›? Davidə swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Yuu-Tiu Yɩɩ swɩ̀n à Yuu-Tiu con, ʋ wʋ́: Bàá, jə̀ń à jɩzən nə, də à ma kəni n dʋŋa n nɛɛ də̀ń nə!› ");
INSERT INTO nnw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Də Davidə nə bon wá ʋ Yuu-Tiu, kʋ dàń yɩ Kərisə wá twá nətʋ, ʋ ma kʋ́ʋ̀ yà Davidə nàʋ́ də?» ");
INSERT INTO nnw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ba lìù nədʋ də kʋ́ʋ̀ wá wànɩ́ ʋ le wá yoo, kʋ kwa nə. Yá kʋ nə zɩgɩ kʋ dɩɩn təntə nə, lìù kʋ́ʋ̀ wà də́də́n, sə ʋ bwe wá bwiə. ");
INSERT INTO nnw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Zwezi dàń ma swɩ̀n lalʋʋ tə də ʋ karbɩa tə con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«*Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə də *Farɩzɩan-ba tə yɩ ba twi ba jon *Moyizə yuu nə. Ba mʋ̀ nə mɛ, sə ba gwin Yɩɩ *nii tə, ʋ nə pɩn Moyizə nə, də̀ń ba bɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kʋ mɛ, sə á zìlí ba nii, á ga tʋn kʋ tə mama, ba nə swɩ̀n á con nə. Yá á nə dànà ká fwa, ndə ba tə fwa tə, ba nə ba kʋ tə, ba nə bɩrɩ tə, nii nə twá yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kʋ yɩ, ndə ba nə vwe zɩla tə nə dù, ba tì ba kəni lɩ̀à vaparan wa. Yá ba ga ba sɛ̀e, ba dwen tə yɩra də ba jɩfʋa tətə. ");
INSERT INTO nnw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ba fwa ba tʋtʋnɛɛ mama, sə lɩ̀à ma na ba. Kʋ mʋ̀ nə pɩn, ba kəni Yɩɩ saga ba tə́lə́ nə, nə à yə̀ə́ ba vànà nə, tə nə dwə. Ba ganan nyanʋ yɩ nəwalan nəwalan, tə níə́ ga jə luloŋə nəmanbii. ");
INSERT INTO nnw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Də ba nə vəli diŋə bwálɩ́ nə, ba swə tətəŋi yíjàá. Də ba nə vəli Zwifə-ba *jə́rə́ dii wa, ba swə dun gwələ yuu jàá. Ba swə, sə lɩ̀à tʋ tɩa ba jʋn ba kanporu wa. ");
INSERT INTO nnw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ba ga swə, sə lɩ̀à bon ba ‹karnyɩna-ba›. ");
INSERT INTO nnw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yá á mʋ̀, á dànà ká pa, ba ja aba, ba bon ‹karnyɩna-ba›, á mama tə nə yɩ nubɩa *Kərisə yɩrɩ, yá á karnyɩna də ga yɩ nədʋ tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Á dànà ká bon lìù mama tɩa yuu wa ‹à nyɩna›, á nyɩna nə yɩ nədʋ, á nə jə, wà tə, ʋ nə wulə Yɩɩ *sàń nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Á dànà ká pa, ba bon aba ‹yáá tɩ̀án›, á yáá tíú tə, á nə jə, nə yɩ nədʋ, ʋ mʋ̀ nə yɩ Kərisə, tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Á wa ləzwənfarʋ tə, ʋ nə dwə ba duən tə, mɛ, sə ʋ mʋ̀ nə yà á tʋtʋnbiu. ");
INSERT INTO nnw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Lìù tə, ʋ nə zɩ̀n ʋ tɩ̀àn, Yɩɩ wá mun kʋ tíú. Yá lìù tə, ʋ nə mun ʋ tɩ̀àn, Yɩɩ wá zɩ̀n wá yɩɩ nə». ");
INSERT INTO nnw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lɛɛ wá yí aba, *Zwifə-ba Yɩɩ nii *yənu tɩ̀án-ba də *Farɩzɩan-ba, á nə yɩ níə́ bələ tɩ̀án tə yɩrɩ! Á cɩ̀gà lɩ̀à tə yáá nə, ba dàn ká zʋ Yɩɩ pàrɩ̀ tə wa. Á tətə ba zwɩ, á ga ba yá á pɩn lɩ̀à tə, ba nə pɩ̀à ba zʋ nə, sə ba zʋ. ");
INSERT INTO nnw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lɛɛ wá yí aba, Yɩɩ nii yənu tɩ̀án-ba də Farɩzɩan-ba, á nə yɩ níə́ bələ tɩ̀án tə yɩrɩ! Á vɩrɩ kadənə wiən, á ga fwa yɩjʋnɩ á ba zwɛ̀e ləzoni yáá con, sə á ma bɩrɩ də, á yɩ ləzwənzəŋə. Mə kʋ mʋ̀ nə pɩn, Yɩɩ wá bʋ̀rɩ̀ á bʋ̀rà, ʋ ga cʋ̀gʋ̀ aba mɩ́ámɩ́án! ");
INSERT INTO nnw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Lɛɛ wá yí aba, Yɩɩ nii yənu tɩ̀án-ba də Farɩzɩan-ba, á nə yɩ níə́ bələ tɩ̀án tə yɩrɩ! Á vəli mʋʋ tə də tɩa tə yuu mama, á ma pɩ̀à ladʋa tətə, ʋ nə wá sɛ̀e ʋ zʋ á Zwifə-ba *yɩjʋncwəŋə tə wa. Yá á nə nɩ kʋ lìù, á yàá pa, ʋ jì mən dìə̀ lìù, nɛɛ bələ ʋ doni aba. ");
INSERT INTO nnw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lɛɛ wá yí aba, á mʋ̀ ləzwənlilirən-ba! Á wʋ́: ‹Lìù nə twá Zwifə-ba Yɩɩ *dìə̀ tə yɩrɩ nə, ʋ ma dù, kʋ dùrə̀ tə ba wá də́. Yá kʋ nə yɩ Yɩɩ dìə̀ sɩ́án tə yɩrɩ nə, ʋ ma dù, kʋ dùrə̀ tə wàá wá, kʋ də́›. ");
INSERT INTO nnw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ləyigi də lilirən-ba! Kʋ kwà nə jə funə kʋ doni kʋ don? Sɩ́án tə nə dwə naaa, nə à yə̀ə́ Yɩɩ dìə̀ tə, ka nə pɩn, tə mʋ̀ sɩ́án tə jì Yɩɩ nyiən, nə dwə? ");
INSERT INTO nnw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Á tə kʋ́ʋ̀ wʋ́: ‹Lìù nə nə twá Yɩɩ *joŋi kúrí tə nə, ʋ ma dù, kʋ dùrə̀ tə wàrɩ̀ wá kʋ də́. Yá ʋ nə nə twá də joŋi won tə nə, kʋ nə wulə joŋi kúrí tə yuu wa, ʋ ma dù, kʋ dùrə̀ tə wàá wá kʋ də́›. ");
INSERT INTO nnw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lilirən-ba! Kʋ kwà nə jə funə kʋ doni kʋ don? Joŋi won tə mʋ̀ naaa, nə à yə̀ə́ joŋi kúrí tə, kʋ nə pɩn, joŋi won tə yɩ Yɩɩ nyiən tə nə dwə? ");
INSERT INTO nnw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Lìù tə, ʋ nə dùə̀ joŋi kúrí tə, ʋ dùə̀ də kʋ yuu wiən tə mama. ");
INSERT INTO nnw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Lìù tə, ʋ nə dùə̀ də Yɩɩ dìə̀ tə, ʋ yɩ ʋ dùə̀ də ka mʋ̀ də Yɩɩ tə, ʋ nə wulə ka wa. ");
INSERT INTO nnw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Lìù tə, ʋ nə dùə̀ də Yɩɩ *sàń tə ʋ yɩ, ʋ dùə̀ də Yɩɩ padaʋ tə, də Yɩɩ tətə, ʋ nə jə̀ə́ kʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lɛɛ wá yí aba, Yɩɩ nii yənu tɩ̀án-ba də Farɩzɩan-ba, á nə yɩ níə́ bələ tɩ̀án tə yɩrɩ! Á pɩn á fugə nii nyiən Yɩɩ nə, də kʋ nə swə, kʋ yɩ dəŋə wiən nəmanbii tətə. Yá á yáá ga tə̀lə́ də yìə̀n tə yoo nə də́ lá, Yɩɩ nii tə nə bɩrɩ. Tə mʋ̀ nə yɩ cɩ́gá də ka dəri yinəgə zənzən də ka twá Yɩɩ də pùə́ nədʋ. Mə tə mʋ̀ yà nə á mɛ, sə á tʋn, á ga kəni á yáá tə duən tə də con. ");
INSERT INTO nnw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ləzwənlilirən-ba! Á loni bʋnbʋnɩ á nanywɩa wa. Yá á ga ləri nyʋgʋma mʋ̀ puŋi! ");
INSERT INTO nnw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Lɛɛ wá yí aba, Yɩɩ nii yənu tɩ̀án-ba də Farɩzɩan-ba, á nə yɩ níə́ bələ tɩ̀án tə yɩrɩ! Á yàá sɩn wùrú zʋŋa də zʋŋa kwa, yá tə waa ga sú də ŋwɩ̀ràn wiən də á pusoni wokʋkwɩnan. ");
INSERT INTO nnw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farɩzɩan liliu! Dí yáá n sɩn wùrú zʋŋa tə waa tə. Yá kʋ kwa tə də wá yà zəni. ");
INSERT INTO nnw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lɛɛ wá yí aba, Yɩɩ nii yənu tɩ̀án-ba də Farɩzɩan-ba, á nə yɩ níə́ bələ tɩ̀án tə yɩrɩ! Á yɩ ndə ləbərə nə, ba nə pɩrɩ tə kwa zəni. Yá tə waa tə ga sú də tɩga kurən də wopʋpʋnan yiri mama. ");
INSERT INTO nnw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mə á də yɩ nətʋ. Kàrá con, á yɩ cɩ́gá tɩ̀án. Yá á waa con á yɩ níə́ bələ tɩ̀án, á ga sú də yokʋkwɩnan!» ");
INSERT INTO nnw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lɛɛ wá yí aba, *Zwifə-ba Yɩɩ nii *yənu tɩ̀án-ba də *Farɩzɩan-ba, á nə yɩ níə́ bələ tɩ̀án tə yɩrɩ! Á lwè Yɩɩ nii *sʋ̀sʋ̀nà tə ləbərə, á ga kwɛn lɩ̀à tə, ba nə yɩ cɩ́gá tɩ̀án, ləbərə. ");
INSERT INTO nnw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yá á dàń swɩ̀n, á wʋ́: ‹Kʋ nə yɩ nə yɩn lá nə nɩbara-ba máŋá wa, nə yà bá sɛ̀e, nə twá ba nə, nə gʋ Yɩɩ nii sʋ̀sʋ̀nà tə›. ");
INSERT INTO nnw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kʋ mʋ̀ tə yɩrɩ, á tətə bɩrɩ də, á yɩ ba tə, ba nə gʋa Yɩɩ nii sʋ̀sʋ̀nà tə, dwíí tə lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kʋ mʋ̀ nə pɩn, á dànà ká yá, á fwa kʋ tə, á nɩbara-ba tə nə dɩga kʋ də̀ń, ba fwa tə, á zwɛ̀e! ");
INSERT INTO nnw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Á nyɩn ndə dɩŋa nə, ndə dəkwaa dwíí nə! Kʋ yɩ á bʋŋa də, á wá twá nətə, á ma jén mən dìə̀ tə bʋ̀rà tə yáá nə? ");
INSERT INTO nnw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Á cʋga zəni! Kʋ mʋ̀ nə pɩn, à wá tʋn Yɩɩ nii sʋ̀sʋ̀nà də wʋbʋŋa tɩ̀án də Yɩɩ nii yənu tɩ̀án. Á wá gʋ ba duən, á paa ba duən dagaran yuu wa. Á wá mà ba duən də də fɩfɩran Zwifə-ba *jə́rə́ dii tə wa. Yá á ga wá dɩŋa ba kwa, á ja twá á tɩfaran tə wa, á vələ. ");
INSERT INTO nnw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kʋ nətʋ tə nə wá tʋn, sə kʋ pa Yɩɩ tʋ̀tʋ̀nà tə mama gʋrɩ tə ya á yuu zɩlɩ. Kʋ nə zɩgɩ cɩ́gá tíú Abɛlə nə, kʋ ja va Zakari, Baraswi bìú tə, á nə gʋa Yɩɩ dìə̀ tə də Yɩɩ *joŋi kúrí tə tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ba lɩ̀à təntə mama gʋrɩ tə càn tə wá tʋ á mʋ̀, zə̀n lɩ̀à tə yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «*Zwerizalɛmə tɩ̀án-ba, Zwerizalɛmə tɩ̀án-ba! Á mʋ̀ lɩ̀à tə, á nə gwɩ Yɩɩ nii *sʋ̀sʋ̀nà tə, á ga dɩlɩ ba tə, Yɩɩ nə tʋn á con, də kapana! Nɛɛ bagalɩ nə à sóní, sə à kə aba à səpuni nə, ndə cə̀rú nə yàá kə kʋ cəbii kʋ vànà də̀ń nə, yá á ga wà kʋ sɛ̀e! ");
INSERT INTO nnw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Á nəŋə, Yɩɩ dʋgʋ ʋ *dìə̀ tə, ka nə wulə á con, mɩ́ámɩ́án. ");
INSERT INTO nnw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yá də kʋ mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ nə mɛ sɩ́ʋ́n nə, á kʋ́ʋ̀ bá na nə, kʋ ja vələ, á nə wá swɩ̀n, á wʋ́: ‹Yɩɩ wá fwa zəni lìù tə yɩra, ʋ nə bɩ̀àn *Yuu-Tiu yɩrɩ yuu wa!› » ");
INSERT INTO nnw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kʋ kwa nə, Zwezi nan *Zwifə-ba Yɩɩ *dìə̀ tə wa, ʋ vìrí. Kʋ máŋá tə wa, ʋ karbɩa tə fàrʋ́ ba yí ʋ yɩra, sə ba pa ʋ ywàń Yɩɩ dìə̀ tə nə lwə̀ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Zwezi dàń swɩ̀n, ʋ wʋ́: «Á ba kʋ nətʋ tə na? Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kapan nədʋ tətə bá ga yəbə, kʋ nə wá pə̀ń kʋ don yuu wa. Tə mama mɩ́ámɩ́án wá lwá tɩa». ");
INSERT INTO nnw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kʋ kwa nə, Zwezi nə jə̀ə́ *oliviye tɩ̀án paan yuu wa, ʋ karbɩa tə fàrʋ́ ba yí ʋ yɩra, ba mʋ̀ də wá cɩcɩ. Ba taa ʋ yɩra ba bwe wá, ba wʋ́: «Bɩrɩ nəba máŋá tə, kʋ yoo tə nə wá tʋn, də mɩmɩnan, tə nə wá bɩrɩ nəba də, n pìí n bɩ̀àn də lʋʋ zaŋʋ máŋá yí». ");
INSERT INTO nnw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zwezi le ba, ʋ wʋ́: «Á cɩa á tɩ̀àn nə, sə lìù mama dàn ká gɩgarɩ aba. ");
INSERT INTO nnw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lɩ̀à zənzən wá ja à yɩrɩ, ba bà. Ba lìù mama ga wá swɩ̀n, ʋ wʋ́: ‹À mʋ̀ nə yɩ *Kərisə›. Yá ba ga wá gɩgarɩ lɩ̀à zənzən. ");
INSERT INTO nnw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Á wá dí yáá, á nì kʋ̀ʋ̀ yoo də kʋ bwələ. Yá á tə kʋ́ʋ̀ wá nì də, kʋ̀ʋ̀ tə yí. Á dànà ká pa fən ja aba. Kʋ mɛ, sə kʋ nətʋ tə yí. Yá kʋ tà lʋʋ zaŋʋ máŋá nə yí. ");
INSERT INTO nnw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dwíə́ tə lʋʋ mama wa wá ta tə zɩgɩ duən nə. Yá payuu wá ta kʋ zɩgɩ kʋ don payuu nə. Niən də tɩa səsəgu wá yà bwálá kapʋpʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tə mʋ̀ yìə̀n təntə mama wá yà, ndə kan pùə́ təntən yɩŋa nə, ʋ lʋrɩ máŋá wa. ");
INSERT INTO nnw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yá ləzoni wá pa, ba ja aba, ba kə càn wa, ba ga wá gʋ aba. Lɩ̀à mama mɩ́ámɩ́án wá dʋ́n aba à mʋ̀ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kʋ mʋ̀ máŋá təntə wa, lɩ̀à zənzən wá pìí, ba yá nə. Ba wá gwin duən də̀ń, ba ga wá dʋ́n duən. ");
INSERT INTO nnw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kʋnkʋn nii sʋ̀sʋ̀nà zənzən wá nan, ba ga wá gɩgarɩ lɩ̀à zənzən. ");
INSERT INTO nnw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yokʋkwɩnan wá sú tɩa, kʋ pa lakapʋpʋ sonu fʋ kʋ mun. ");
INSERT INTO nnw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yá lìù tə, ʋ nə jɩn pɩ́nʋ́ wuuu, ʋ dàn ká pìí ʋ kə ʋ kwa, ʋ va ʋ gúrí, ʋ wá na mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ba wá kàrɩ̀ sʋywáŋʋ́ tə, kʋ nə bɩrɩ, Yɩɩ nə wá də́ ʋ pàrɩ̀ tə nətʋ, lɩ̀à yuu wa. Lʋʋ mama wa, ba wá bɩrɩ kʋ lɩ̀à tə mama nə, sə ba nì kʋ. Kʋ kwa nə, lʋʋ dàń wá zàn». ");
INSERT INTO nnw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á wá na kʋ tə, ba nə ma boŋə ‹wokʋkwɩʋn› tə, kʋ nə cʋ̀gà. Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Daniyɛlə swɩ̀n kʋ yoo də, kʋ wá jə̀ń *Zwifə-ba Yɩɩ *dìə̀ tə wa. (Sə lìù tə, ʋ nə kàrɩ̀, zùrì ʋ yɩra!) ");
INSERT INTO nnw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kʋ máŋá tə wa, sə lɩ̀à tə, ba nə wá yà Zwide nagwanaa con, dəri ba dɩ̀ pɛɛn. ");
INSERT INTO nnw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lìù tə, ʋ nə wá yà dəyuu wa, kʋ́ʋ̀ dàn ká cú, ʋ tì ʋ dìə̀ wiən, ʋ ja vìí. ");
INSERT INTO nnw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yá lìù tə də, ʋ nə wá yà kárá wa, dàn ká pìí ʋ va sàń, sə ʋ tì ʋ gànʋ̀ don. ");
INSERT INTO nnw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kʋ wá yà lɛɛ máŋá təntə wa, kʋ pa kana tə nə, ba nə jə pwìí, də ba tə nə, bɩa nə ŋwà ba nyʋnɩ nə! ");
INSERT INTO nnw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Á lòrì Yɩɩ, sə á dəru tə dàn ká ya waran máŋá wa, nə à yə̀ə́ Zwifə-ba *sìə́ dɩɩn nə, ");
INSERT INTO nnw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kʋ máŋá təntə càn tə nə ba don ja yɩrɩ. Tə yiri wà lá yɩn lʋʋ nə jə̀ń kʋ jɩjʋ mama, kʋ ja bà kʋ yí zə̀n. Yá tə yiri don də ga bá yà lá, abada. ");
INSERT INTO nnw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kʋ nə tà Yɩɩ pɩn nii, sə tə máŋá tə pwàrɩ̀ ka mun yɩrɩ, lìù yà bá yà lá ʋ na mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. Yá tə máŋá tə dàń fʋa ka mun lɩ̀à tə yɩrɩ, Yɩɩ nə kúrí. ");
INSERT INTO nnw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lìù dàń nə swɩ̀n á con, ʋ wʋ́: ‹Á ywàŋá, *Kərisə wulə yəbə!› Nə à yə̀ə́: ‹Ʋ wulə lá con!› Á dànà ká sɛ̀e kʋ tíú nii. ");
INSERT INTO nnw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kʋnkʋn Kərisə-ba də kʋnkʋn nii sʋ̀sʋ̀nà wá bà. Ba wá tʋn yikunu dɩ̀àn mɩmɩnan nə dáá də yomɩlan, sə ba ma gɩgarɩ lɩ̀à tə tətə, Yɩɩ nə kúrí tə. Də kʋ nə wàá, sə ba lɩ ba Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Á cʋga zəni! À mʋ̀ nə dí yáá, à swɩ̀n kʋ á con nə. ");
INSERT INTO nnw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Də lìù nə swɩ̀n á con nə, ʋ wʋ́: ‹Á nəŋə, ʋ wulə kasɔɔ lanworu wa!› Á dànà ká va lá nə! Nə à yə̀ə́ lìù nə swɩ̀n á con nə, ʋ wʋ́: ‹Á nəŋə, ʋ sə̀gə̀ dìə̀ wa!› Á dànà ká sɛ̀e kʋ tíú nii. ");
INSERT INTO nnw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndə dwà pɩpɩlʋ nə yàá pɩ̀rʋ̀ lanworu, kʋ zɩgɩ yɩɩ yipɩan, kʋ ja va yɩɩ yizwɩa tə, mə nətʋ *Ləzwənə-Biu tə wá pìí ʋ bà. ");
INSERT INTO nnw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kʋ wá yà, ndə kʋ nə swɩ̀n, kʋ wʋ́: ‹Bwálɩ́ tə nə wotɩgʋ nə wulə, dilən yàá kun duən nə lá›.» ");
INSERT INTO nnw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Kʋ máŋá təntə càn tə kwa nə, yɩcaʋ tə wá jì yikunu. Cànà tə kʋ́ʋ̀ bá ja poni. Kacɩlacɛ wá nan lanworu wa, tə tʋ. Yá dɩ̀àn tə, tə nə wulə lanworu tə wa də wá gugurə. ");
INSERT INTO nnw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kʋ kwa nə, mɩmɩnʋ wá nan lanworu wa, kʋ nə bɩrɩ *Ləzwənə-Biu túrí tə. Tɩa yuu ləzoni mama dàń wá bubwi, ba wá na Ləzwənə-Biu tə bakwan tə wa, də ʋ bɩ̀àn də dɩ̀àn də dun, tə nə dáá. ");
INSERT INTO nnw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nabwana kori nəfarʋ wá wúrú. Yá ʋ ga wá tʋn ʋ *malɩkɛ tə tɩa saparan banɩa tə mama nə. Tə wá kə lɩ̀à tə, ʋ nə kúrí tə mɛ duən nə». ");
INSERT INTO nnw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nəŋə, yoo tə, à nə pɩ̀à, sə à twá kapɩrʋ tə kàrà tə, nə à swɩ̀n: Máŋá tə nə, kʋ nɛɛ tə nə yɩ wabwalan, yá kʋ ga twè vʋran, á yə̀ə́ də, sii bwələ. ");
INSERT INTO nnw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kʋ nətʋ tə pɩ̀à kʋ bɩrɩ də, á dàń nə nɩ tə mʋ̀ wiən tə də tə yí, á mɛ, sə á lwarɩ də, yoo tə bwələ, sə kʋ tʋn. ");
INSERT INTO nnw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ yoo təntə wá tʋn, də zə̀n lɩ̀à tə mama, ba nə wulə tɩa yuu wa, tə wà tɩ, ba zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lanworu də tɩa mɛ wá jén, yá à sʋ̀ràn tə mʋ̀ bá jén, abada!» ");
INSERT INTO nnw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lìù mama yə̀rì dɩɩn tə, nə à yə̀ə́ máŋá tə, yìə̀n təntə nə wá tʋn. *Malɩkɛ tə Yɩɩ *sàń nə, də Yɩɩ-Biu tə tətə yə̀rì kʋ. À nyɩna Yɩɩ cɩcɩ nə yə̀ə́ kʋ. ");
INSERT INTO nnw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Máŋá tə *Ləzwənə-Biu tə nə wá pìí ʋ bà, yìə̀n tə wá yà, ndə tə nə yɩn nətʋ Nowe máŋá tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kʋ yɩ nətʋ, máŋá təntə wa, də dwà nəfarʋ tə, tə nə wà twi. Kʋ máŋá tə wa, lɩ̀à tə yà də́, ba nywɩ̀n, ba swe duən nə, də ba swe ba bwɩ̀ɩ́ lɩ̀à yuu wa, kʋ ja va dɩɩn tə, Nowe nə zʋa nɩ́á yuu bori nəfarʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba wà yoo mama bɛ̀eé, kʋ ja va kʋ yí máŋá tə, dwà nəfarʋ tə nə twi, kʋ pɛ̀e ba mama. Mə kʋ wá yà nətʋ də Ləzwənə-Biu tə nə wá pìí ʋ bà. ");
INSERT INTO nnw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kʋ máŋá tə wa, bara bələ wá yà kárɩ́ wa. Yɩɩ wá tì ʋ don, ʋ ga yá ʋ don lá. ");
INSERT INTO nnw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kana bələ wá gà mun duən nə, nʋŋʋ yuu wa. Yɩɩ wá tì ʋ don, ʋ ga yá ʋ don lá. ");
INSERT INTO nnw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Á dànà ká dwɛ̀e, á nə yə̀rì máŋá tə, á *Yuu-Tiu tə nə wá bà yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Á cʋga kʋ tə zəni: Də dìə̀ tíú yà nə yə̀ə́ máŋá tə, ŋwɩ̀àn nə wá bà tɩtɩn nə, ʋ bá dwɛ̀e. Yá ʋ ga bá yá, sə ŋwɩ̀àn tə kén ʋ dìə̀ tə, ʋ zʋ ka wa. ");
INSERT INTO nnw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mə kʋ mʋ̀ nə pɩn, á də kənə á sírí, Ləzwənə-Biu tə nə wá bà máŋá tə wa, á nə ba bʋŋa yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Wàà dàń nə yɩ kʋ mʋ̀ tʋ̀tʋ̀nʋ̀ təntə, ʋ nə sɛ̀e nii də pùə́ nədʋ, ʋ ga cɩ̀ ʋ tɩ̀àn nə, ʋ yuu tíú nə pɩn wá cwəŋə, sə ʋ ywàń tʋ̀tʋ̀nà tə duən tə yuu, sə ʋ pa ba wodiu, máŋá tə nə, kʋ nə mɛ? ");
INSERT INTO nnw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kʋ tʋ̀tʋ̀nʋ̀ təntə wá yà pupwən wa, də yuu tíú tə ka pìí ka bà dìə̀ wa nə, ʋ nə yí wá, də ʋ wulə kʋ tʋtʋŋɩ tə wa! ");
INSERT INTO nnw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Yuu tíú tə wá pa wá cwəŋə, sə ʋ ywàń ʋ wiən tə mama yuu. ");
INSERT INTO nnw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yá də kʋ mʋ̀ tʋ̀tʋ̀nʋ̀ təntə nə yɩ lakʋkwɩʋn, ʋ wá swɩ̀n ʋ waa con, ʋ wʋ́: ‹À yuu tíú tə dánɩ́, ʋ bá bà sɩ́ʋ́n›. ");
INSERT INTO nnw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yá ʋ ga zàn, ʋ tʋ ʋ duən tʋ̀tʋ̀nà tə yuu wa, ʋ mà ba, ʋ ga zʋ diŋu də sanyʋra wa, ʋ mʋ̀ də sanyʋra tə duən. ");
INSERT INTO nnw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kʋ mʋ̀ nə wá pa, ʋ yuu tíú tə wá bà dɩɩn don nə, ʋ dɩ̀ ʋ yuu, máŋá tə wa, ʋ nə ba wá dànɩ̀. ");
INSERT INTO nnw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ʋ dàń wá kə kʋ tʋ̀tʋ̀nʋ̀ təntə càn wa zənzən. Yá ʋ ga wá pa, ʋ tì níə́ bələ tɩ̀án tori, bwálɩ́ təntə nə, ʋ nə wá bubwi, ʋ ga dɩŋa ʋ jɩfwɩ ʋ fɩfaga». ");
INSERT INTO nnw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə kʋ́ʋ̀ wá yà ndə kacɩan fugə nə, ba tì ba cànán ba nan, sə ba jə́rí bɛɛ don, ʋ nə pɩ̀à, sə ʋ vwa ʋ kan fúrú. ");
INSERT INTO nnw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ba wa kacɩan bonu yà yɩ ləyigi, ba bonu tə duən də ga yɩ wʋbʋnyɩna tə. ");
INSERT INTO nnw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ba tə, ba nə yɩ ləyərən tə, tì ba cànán tə, ba ga wà nʋga tì, sə ba ma cɩ̀ ba tɩ̀àn nə. ");
INSERT INTO nnw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yá ba tə mʋ̀, ba nə yɩ wʋbʋnyɩna tə, tì nʋga kunkoli də ba cànán. ");
INSERT INTO nnw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bɛɛ tə dàń nə dánɩ́, ʋ ba twi, kacɩan fugə tə mama twá duən, ba dwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tɩa nə gwəŋə ka tàrà máŋá wa, kori bubwi, kʋ wʋ́: ‹Á nəŋə, fúrú bɛɛ tə nə! Á naŋa, á va á jə́rí wá!› ");
INSERT INTO nnw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kacɩan tə dàń ma wùrù ba zàn, ba wulə ba kwɛn ba cànán. ");
INSERT INTO nnw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ba wa ləyərən tə swɩ̀n ba wʋbʋnyɩna tə con, ba wʋ́: ‹Á pɩan nəba á nʋga tə mancɩn, nə cànán tə nə wulə tə dəŋi yɩrɩ›. ");
INSERT INTO nnw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ba wʋbʋnyɩna tə ma swɩ̀n, ba wʋ́: ‹Abada, kʋ wàrɩ̀, ka nə bá yí nə mʋ̀, də á mama kənu yɩrɩ. Á vələ, á yə̀ yəə wa!› ");
INSERT INTO nnw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ba dàń ma kɛ̀eń ba va, sə ba yə̀ nʋga tə. Kʋ máŋá təntə wa, fúrú bɛɛ tə twi, ʋ yí, ba tə bonu tə, ba nə ken ba sírí ba zwɛ̀e, ba dànɩ̀ wà tə. Ba twá ʋ nə, ba zʋ fúrú dìə̀ tə wa, sə ba də́ fúrú diŋə tə. Yá lìù ga tagʋ mimii tə. ");
INSERT INTO nnw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kʋ kwa nə, kacɩan tə duən tə twi, ba yí, ba ga bubwi, ba wʋ́: ‹Yuu tíú, yuu tíú, súrí mimii tə, sə nə zʋ!› ");
INSERT INTO nnw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Yá fúrú bɛɛ tə le, ʋ wʋ́: ‹Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: À yə̀rì aba!› » ");
INSERT INTO nnw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zwezi dàń ma súrí lá nə, ʋ wʋ́: «Á dànà ká dwɛ̀e, á nə yə̀rì dɩɩn tə, nə à yə̀ə́ máŋá tə, *Ləzwənə-Biu tə nə wá pìí ʋ bà». ");
INSERT INTO nnw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə kʋ́ʋ̀ yɩ, ndə bɛɛ don nə pɩ̀à, ʋ va cwəŋə. Ʋ dàń ma bon ʋ tʋ̀tʋ̀nà, ʋ tì ʋ jɩjə, ʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ʋ pɩn sɩ́án səbikʋlan bonu ʋ don nə, ʋ pa sɩ́án səbikʋlan bələ ʋ don də nə, ʋ ga pa sɩ́án səbikʋlʋ nədʋ talɩkwa lìù tə nə. Ba lìù mama jon kʋ tə nə mɛ ʋ dɩ̀àn. Ʋ dàń ga vìí. ");
INSERT INTO nnw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tʋ̀tʋ̀nʋ̀ tə, ʋ nə nɩ sɩ́án səbikʋlan bonu tə, vəli lala ʋ yolu də kʋ səbiu tə, ʋ na sɩ́án səbikʋlan bonu duən, ʋ súrí lá nə. ");
INSERT INTO nnw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ʋ tə də, ʋ nə nɩ sɩ́án səbikʋlan bələ tə, də fwa nətʋ, ʋ də ga na sɩ́án səbikʋlan bələ duən, ʋ súrí. ");
INSERT INTO nnw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yá ʋ tə, ʋ nə nɩ sɩ́án səbikʋlʋ nədʋ tə, tíú vəli ʋ kʋ̀ bʋʋ tɩa, ʋ sə̀gə̀ ʋ yuu tíú səbiu tə lá. ");
INSERT INTO nnw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kʋ nə dɩ́án dɩ́án, tʋ̀tʋ̀nà tə yuu tíú pìí, ʋ bà. Ʋ dàń ken ʋ tʋ̀tʋ̀nà tə duən nə, sə ʋ jə́n, bɛ̀eɛ̀e nə ba fwa də ʋ səbiu tə. ");
INSERT INTO nnw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ʋ tə, ʋ nə nɩ sɩ́án səbikʋlan bonu tə fàrʋ́ ʋ yí ʋ yɩra, ʋ ga bɩrɩ wá sɩ́án səbikʋlan bonu tə duən tə, ʋ nə nɩ ʋ súrí lá tə, ʋ ga wʋ́: ‹Yuu tíú, n yà pɩn nə sɩ́án səbikʋlan bonu. Nə̀ń, tə bonu duən nə, à nɩ à súrí lá nə›. ");
INSERT INTO nnw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ʋ yuu tíú ma swɩ̀n ʋ con, ʋ wʋ́: ‹Kʋ ziən, n yɩ tʋtʋnzəŋu, n ga sɛ̀e à nii də pùə́ nədʋ. N tʋŋa zəni wiən tə wa, tə nə ba funə jə zənzən. Kʋ mʋ̀ tə yɩrɩ, à dàń wá pa n ywàń wiən tə yuu wa, tə nə jə funə zənzən. Bàá, n ga yà pupwən wa də nə›. ");
INSERT INTO nnw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tʋ̀tʋ̀nʋ̀ tə, ʋ nə nɩ sɩ́án səbikʋlan bələ tə də fàrʋ́ ʋ yí, ʋ də ga wʋ́: ‹Yuu tíú, n yà pɩn nə sɩ́án səbikʋlan bələ. Nə̀ń, tə bələ duən nə, à nɩ à súrí lá nə.› ");
INSERT INTO nnw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ʋ yuu tíú ma swɩ̀n ʋ con, ʋ wʋ́: ‹Kʋ ziən, n yɩ tʋtʋnzəŋu, n ga sɛ̀e à nii də pùə́ nədʋ. N tʋŋa zəni wiən tə wa, tə nə ba funə jə zənzən. Kʋ mʋ̀ tə yɩrɩ, à dàń wá pa n ywàń wiən tə yuu wa, tə nə jə funə zənzən. Bàá, n ga yà pupwən wa də nə›. ");
INSERT INTO nnw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kʋ kwa nə, tʋ̀tʋ̀nʋ̀ tə, ʋ nə nɩ sɩ́án səbikʋlʋ nədʋ tə də fàrʋ́ ʋ yí, ʋ ga wʋ́: ‹Yuu tíú, à yà yə̀ə́ də, n yɩ lìù tə, n yoo nə dà. N yàá za bwálɩ́ tə nə, n nə wà dwì. N ganɩ bwálɩ́ tə nə, n nə wà wobɩa mɩ́. ");
INSERT INTO nnw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Fən jɩn nə, yá à vəli à kʋ̀ tɩa, à sə̀gə̀ n səbiu tə lá. Nə̀ń, n səbiu tə nə, n jon›. ");
INSERT INTO nnw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ʋ yuu tíú ma swɩ̀n ʋ con, ʋ wʋ́: ‹Tʋtʋnkʋkwɩʋn! Yayɩnyɩan! N yə̀ə́ də, à za bwálɩ́ tə nə, à nə wà dwì. À ganɩ bwálɩ́ tə nə, à nə wà wobɩa mɩ́. ");
INSERT INTO nnw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kʋ nə yɩ nətʋ tə, n yà wá tún à səbiu tə səbiu daka wa. Yá à túrí tə wa nə, à yà wá jon à səbiu tə də kʋ yuu nywarɩ›. ");
INSERT INTO nnw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yuu tíú tə dàń ma swɩ̀n ʋ lɩ̀à tə con, ʋ wʋ́: ‹Á joŋə sɩ́án səbikʋlʋ nədʋ tə ʋ con, á pa lìù tə nə jə sɩ́án səbikʋlan fugə tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ba wá pa lìù tə nə, ʋ nə jə, yá kʋ tíú wá yà jɩjə tíú. Yá lìù tə, ʋ nə ba jə, ba wá jon mancɩn tə də, ʋ nə jə. ");
INSERT INTO nnw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kʋ mʋ̀ tʋtʋnkʋkwɩʋn təntə, á dɩla wá kàrá wa yikunu tə wa. Kʋ bwálɩ́ təntə wa, ʋ wá bubwi, ʋ ga dɩŋa ʋ jɩfwɩ ʋ fɩfaga›.» ");
INSERT INTO nnw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Máŋá tə nə, *Ləzwənə-Biu tə nə wá bà də ʋ dun də ʋ *malɩkɛ tə mama, ʋ wá jə̀ń ʋ dun padaʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Lʋʋ dwíə́ tə mama wá kun duən nə ʋ yáá con. Yá ʋ dàń wá pwɛ̀e lɩ̀à tə duən wa, ndə payɩrʋ nə pwɛ̀e pee də bʋ̀nɩ́ duən wa. ");
INSERT INTO nnw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ʋ wá kə pee tə ʋ jɩzən nə, ʋ ga kə bʋ̀nɩ́ tə də ʋ jɩgwiə nə. ");
INSERT INTO nnw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ʋ mʋ̀ pɩ̀ʋ́ tə dàń wá swɩ̀n ba tə con, ba nə wulə ʋ jɩzən nə, ʋ wʋ́: ‹Á mʋ̀ lɩ̀à tə, à nyɩna Yɩɩ nə pɩ̀à, sə ʋ fwa zəni á yɩra, á bɩ̀àn, á tɩnɩ Yɩɩ pàrɩ̀ tə. Yɩɩ kwɛn kʋ ʋ tún lá nə, sə ʋ pa aba, lʋʋ nə fwa máŋá tə wa. ");
INSERT INTO nnw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Niən jɩn nə, yá á ga pa nə wodiu. Nanyʋnɩ jɩn nə, yá á ga pa nə nɩ́á, à nyʋ. À yɩn vee, yá á ga ja nə, á kə á con. ");
INSERT INTO nnw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","À yɩn yatanwala tíú, yá á ga pa nə gànʋ̀, à zʋ. À yɩn yayɩŋʋ, yá á ga ywarɩ nə. À yɩn bàń dìə̀ wa, yá á twi á na nə›. ");
INSERT INTO nnw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Cɩ́gá tɩ̀án tə dàń wá le wá, ba wʋ́: ‹Yuu-Tiu, máŋá kwà wa nə, nə nɩ mʋ́ də niən jə, nə ga pa mʋ́ wodiu, n də́. Nə à yə̀ə́ də nanyʋnɩ jə, nə ga pa mʋ́ nɩ́á, n nyʋ? ");
INSERT INTO nnw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Máŋá kwà wa nə, nə jɩn mʋ́, nə kə nə con nə, də n yɩ vee, yá nə ga zʋ mʋ́ gànʋ̀, də n yɩ yatanwala? ");
INSERT INTO nnw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Máŋá kwà wa nə, nə nɩ mʋ́ də n yɩ̀, nə à yə̀ə́ də n wulə bàń dìə̀ wa, nə ga va nə na mʋ́?› ");
INSERT INTO nnw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ʋ mʋ̀ pɩ̀ʋ́ tə dàń wá le ba, ʋ wʋ́: ‹Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Nɛɛ tə mama, á yà nə fwa kʋ à nubiu tə nədʋ yɩra, ʋ nə swə ʋ yɩ ba mɛ labwanʋ də tətə, kʋ yɩ à mʋ̀ yɩra nə, á fwa kʋ.› ");
INSERT INTO nnw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kʋ kwa nə, ʋ mʋ̀ pɩ̀ʋ́ tə wá swɩ̀n ba tə con nə, ba nə wulə ʋ jɩgwiə nə, ʋ wʋ́: ‹Á fàrá, á nan kwa à yɩra! Á mʋ̀ lɩ̀à tə, Yɩɩ nə zɩrɩ, ʋ kə á nə, á vələ mən tə wa, tə nə ba dəŋə, tə nə kwɛn tə tə́gə́ lá nə tə pa *Sɩtana də ʋ malɩkɛ nə! ");
INSERT INTO nnw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Niən jɩn nə, yá á ga wà nə pɩn à də́, nanyʋnɩ jɩn nə, á ga wà nə pɩn à nyʋ. ");
INSERT INTO nnw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","À yɩn vee, á ga wà nə jɩn, á kə á con. À yɩn yatanwala tíú, á ga wà nə gànʋ̀ pɩn à zʋ. À yɩn yayɩŋʋ, à yɩ bàń dìə̀ wa, á ga wà nə nɩ›. ");
INSERT INTO nnw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ba də kʋ́ʋ̀ wá le, ba wʋ́: ‹Yuu-Tiu, máŋá kwà wa nə, nə nɩ mʋ́ də niən jə, nə à yə̀ə́ də nanyʋnɩ jə, nə à yə̀ə́ də n yɩ vee, nə à yə̀ə́ də n yɩ yatanwala, nə à yə̀ə́ də n yɩ yayɩŋʋ, nə à yə̀ə́ də n wulə bàń dìə̀ wa. Yá nə ga wà mʋ́ san?› ");
INSERT INTO nnw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ʋ mʋ̀ pɩ̀ʋ́ tə wá le ba, ʋ wʋ́: ‹Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Nɛɛ tə mama, á nə wà kʋ fwa lìù nədʋ yɩra, ʋ nə swə ʋ yɩ labwanʋ də, kʋ yɩ à mʋ̀ yɩra nə, á wà kʋ fwa. ");
INSERT INTO nnw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ba mʋ̀ dàń wá va càn bwálɩ́ nə, tə nə ba zwɛ̀e. Yá cɩ́gá tɩ̀án tə wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con›.» ");
INSERT INTO nnw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Máŋá tə wa, Zwezi nə fwa ʋ kàrɩ̀ tə mama, ʋ zwɛ̀e, ʋ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Á yə̀ə́ də, kʋ ga dɩan bələ, sə *Pakə cànà də́. Ba wá twá cànà təntə nə, ba ma ja *Ləzwənə-Biu tə, ba pa, sə ba paa wá dagarʋ yuu wa, sə ʋ tɩ». ");
INSERT INTO nnw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án də ba *nəkwɩna dàń kun duən nə Kayifə Yɩɩ joŋwana yun tɩ̀án nəkwɩa dəwoo wa. ");
INSERT INTO nnw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ba vʋrʋ ba kə duən nə, sə ba tʋn yɩ́á swɩan, ba ja Zwezi, ba gʋ. ");
INSERT INTO nnw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba swɩ̀n, ba wʋ́: «Nə wà mɛ, sə nə ja wá cànà tə máŋá wa, sə gurəgurə dàn ká zàn lalʋʋ tə tətəŋi wa». ");
INSERT INTO nnw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zwezi yà wulə Betani nə, Simon tə, ʋ yà nə yɩ dayarʋ, dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kan don fàrʋ́ ʋ yí ʋ yɩra. Ʋ yà jə pɩ̀ʋ̀ kapan kunkoli, ba nə boŋə ‹alɩbatɩrɩ›. Kʋ nii yà súə́ də tɩralɩ nʋga, kʋ kwənə nə dáá. Ʋ lwá kʋ mʋ̀ tɩralɩ nʋga təntə Zwezi yuu wa də máŋá tə, ba nə wulə ba də́. ");
INSERT INTO nnw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Máŋá tə wa, Zwezi karbɩa tə nə nɩ kʋ mʋ̀ təntə, kʋ wà ywánɩ́ yɩ kʋ pa ba, ba ga swɩ̀n duən con, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, ʋ ma cʋ̀gʋ̀ wofarʋ kʋ tə? ");
INSERT INTO nnw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ba yà wàá kʋ tɩralɩ nʋga tə ba yoli səbifarʋ. Yá ba ga pɩn səbiu tə zʋra nə». ");
INSERT INTO nnw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zwezi dàń lwarɩ də, kʋ yɩ nətʋ nə ba swɩ̀n, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e yɩrɩ nə á ma cʋ̀gà kan tə pùə́ nə? Kʋ tə, ʋ nə tʋn ʋ pa nə, kʋ ziən. ");
INSERT INTO nnw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Zʋra wulə də aba máŋá mama. Yá à mʋ̀ ga bá ya də aba máŋá mama. ");
INSERT INTO nnw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kan tə lwá tɩralɩ nʋga tə à yɩra, sə ʋ ma kwɛn nə à ləbəri wa. ");
INSERT INTO nnw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Bwálɩ́ tə mama wa, ba nə wá swɩ̀n kʋ sʋywáŋʋ́ təntə, lʋʋ mama wa, ba wá man kʋ tə, kan wà tə nə tʋn, sə ba ma wá lìí ʋ nə». ");
INSERT INTO nnw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Zwezi karbɩa fugə bələ tə wa ladʋa don, ba nə ma boŋə Zwidasə Yisəkariyɔtə, vəli ʋ yí *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə. ");
INSERT INTO nnw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ʋ vəli ʋ swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e nə á wá pa nə, də à nə ken Zwezi á jɩ̀àn wa?» Ba dàń ma gàlà cɩnɩa səbikʋlan fɩtwa, ba pa wá. ");
INSERT INTO nnw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kʋ nə zɩgɩ kʋ máŋá təntə nə, Zwidasə dàń yà pɩ̀à cwəŋə nəzəŋu, sə ʋ ma kə Zwezi ba jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kʋ yɩ cànà tə dɩɩn tə nə, *Zwifə-ba də́ dipɛn tə, kʋ nə ba sabwarɩ kəni. Kʋ təntən dɩɩn tə nə, Zwezi karbɩa tə twi, ba bwe wá, ba wʋ́: «Yə̀n nə n pɩ̀à, sə nə tanɩ *Pakə cànà wodiu tə?» ");
INSERT INTO nnw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Á vələ tɩʋ tə wa, lìù don con, á swɩ̀n kʋ tíú con, də karnyɩna wʋ́: ‹À tɩan máŋá yí. Kʋ yɩ n mʋ̀ bwálɩ́ nə nə, à wá də́ Pakə cànà tə də à karbɩa tə›.» ");
INSERT INTO nnw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Karbɩa tə fwa kʋ tə, Zwezi nə pɩn nii, sə ba fwa. Ba tʋŋa, ba ga tanɩ Pakə wodiu tə. ");
INSERT INTO nnw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Máŋá tə dədəni nə yí, Zwezi də ʋ karbɩa fugə bələ tə dàń twi, ba jə̀ń duən nə, ba wulə ba də́. ");
INSERT INTO nnw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Máŋá tə wa, ba nə wulə ba də́, Zwezi swɩ̀n, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á lìù don wá ja nə ʋ pa». ");
INSERT INTO nnw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Karbɩa tə pwìí cʋ̀gʋ̀ zənzən. Ba dàń ma bwe wá ladʋ ladʋ, ba wʋ́: «*Yuu-Tiu, kʋ ya à mʋ̀, naaa?» ");
INSERT INTO nnw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Zwezi ma le, ʋ wʋ́: «Lìù tə, ʋ nə kuli ʋ dipɛn tə də nə zʋŋa tə wa, mə kʋ tíú nə wá ja nə ʋ pa. ");
INSERT INTO nnw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","*Ləzwənə-Biu tə wá tɩ, ndə kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa nətʋ. Yá kʋ dàń wá yà càn kʋ pa lìù təntə nə, ʋ nə wá ja Ləzwənə-Biu tə, ʋ pa. Ba yà nə wà kʋ bɛɛ tə lʋrɩ, kʋ yà kʋkwa!» ");
INSERT INTO nnw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zwidasə, ʋ mʋ̀ lìù tə, ʋ nə wá ja Zwezi, ʋ pa tə swɩ̀n, ʋ wʋ́: «Karnyɩna, kʋ yɩ à mʋ̀, naaa?» Zwezi ma le, ʋ wʋ́: «Mə kʋ nə n swɩ̀n, n mʋ̀ nə!» ");
INSERT INTO nnw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Máŋá tə wa, Zwezi də ʋ karbɩa nə wulə ba də́, Zwezi tì dipɛn, ʋ kə Yɩɩ lɛ̀eɛ̀e kʋ yɩrɩ. Kʋ kwa nə, ʋ fʋa fʋa kʋ, ʋ tì ʋ pa ʋ karbɩa tə nə, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á joŋə kʋ tə, á də́! Kʋ yɩ à yɩra tə nə». ");
INSERT INTO nnw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kʋ kwa nə, ʋ tì divɛn wùrú zʋŋa, ʋ kə Yɩɩ lɛ̀eɛ̀e ka yɩrɩ. Kʋ kwa nə, ʋ tì ka, ʋ pa ba, ʋ ga wʋ́: «Á mama tə nywɩan divɛn tə! ");
INSERT INTO nnw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cɩ́gá, kʋ tə yɩ à mʋ̀ jana nə. Jana təntə nə bɩrɩ á də Yɩɩ *nimarʋ tə. Jana təntə nə wá nan lɩ̀à zənzən yɩrɩ, sə Yɩɩ kwɛn ba cʋna ʋ lɩ ʋ mʋ̀ də ba pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","À mʋ̀ nə swɩ̀n kʋ á con: Kʋ nə mɛ zə̀n, à kʋ́ʋ̀ bá nyʋ divɛn kʋ tə, kʋ ja vələ dɩɩn tə, à nə kʋ́ʋ̀ wá nyʋ kʋ də aba à nyɩna Yɩɩ *sàń nə». ");
INSERT INTO nnw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ba nun cànà tə nuŋi. Kʋ kwa nə, ba dàń ga pɛ̀e duən, ba va *oliviye tɩ̀án paan tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zwezi dàń ma swɩ̀n ʋ karbɩa tə con nə, ʋ wʋ́: «Á mama wá vɩ nə á dʋgʋ tɩtɩn kʋ tə tətə nə. Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹À wá gʋ payɩrʋ tə, yá ʋ pee tə wá laga duən yáá nə›.» ");
INSERT INTO nnw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yá máŋá tə wa, à nə wá pìí à bwin à nan, kʋ kwa nə, à wá va à dɩ̀àn aba Galile nagwanaa wa». ");
INSERT INTO nnw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyɛrə ma swɩ̀n, ʋ wʋ́: «Ba duən tə mama nə wá vɩ mʋ́ ba dʋgʋ, à mʋ̀ bá mʋ́ vɩ à dʋgʋ, abada». ");
INSERT INTO nnw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Zwezi ma le wá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: Zə̀n tɩtɩn kʋ tə tətə mama, də cəbɩʋ tə wà kwi, n wá tɛn nɛɛ batwa də, n yə̀rì nə». ");
INSERT INTO nnw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyɛrə ma le wá, ʋ wʋ́: «À bá tɛn mama də, à yə̀rì mʋ́, də kʋ nə swə kʋ yɩ, à wá tɩ də mʋ́». Ʋ karbɩa tə duən tə də swɩ̀n kʋ mʋ̀ yoo nədʋ təntə. ");
INSERT INTO nnw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zwezi də ʋ karbɩa tə dàń vəli ba yí bwálɩ́ don, ba boŋə ‹Zwesemane›. Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Á jənə yəbə, də à vələ yáá, sə à jʋn Yɩɩ». ");
INSERT INTO nnw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ʋ dàń ma ja Piyɛrə də Zebede bɩa bələ tə, ʋ kə ʋ kwa. Yá pucʋnɩ nəfarʋ wulə kʋ zwɩ wá. ");
INSERT INTO nnw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Tɩan pucʋnɩ súə́ nə. Á jənə yəbə, á dànà ká dwɛ̀e, ndə à nə ba dwɛ̀e nətʋ». ");
INSERT INTO nnw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ʋ dàń ma va yáá mancɩn, ʋ tʋ tɩa ʋ yáá yuu, ʋ ga lòrì Yɩɩ, ʋ wʋ́: «À nyɩna, də kʋ nə wàá kʋ tʋŋa, sə n twiən n lɩ yacara tə tə, n yá nə. Kʋ nə tà, sə kʋ twá, ndə à mʋ̀ nə nə pɩ̀à nətʋ. Yá kʋ dàń mɛ, sə kʋ yà, ndə n mʋ̀ nə nə swə nətʋ». ");
INSERT INTO nnw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kʋ kwa nə, ʋ pìí ʋ bà ʋ karbɩa batwa tə con, yá ʋ nɩ də, ba dwɛ̀e. Ʋ ma swɩ̀n Piyɛrə con, ʋ wʋ́: «Á wà wànɩ́, sə á súrí á yɩ́á á yà də nə lugu nədʋ də tətə? ");
INSERT INTO nnw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Á súrə́ á yɩ́á, á ga lòrì Yɩɩ, sə ʋ san aba, sə *Sɩtana dàn ká wànɩ́ aba, ʋ də́də́n, sə ʋ yigu ʋ pa á tʋn yokʋkwɩʋn. Ləzwənə pubʋŋa mʋ̀ yàá pɩ̀à, sə kʋ fwa zəni, yá ʋ yɩra tə ga ba dɩ̀àn jə kʋ fwa kʋ». ");
INSERT INTO nnw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ʋ ma kʋ́ʋ̀ pìí ʋ va nɛɛ bələ nii nə, ʋ tə kʋ́ʋ̀ lòrì Yɩɩ, ʋ wʋ́: «À nyɩna, də yacara tə nə wàrɩ̀ tə lɛ, də à nə wà tə dí, sə n mʋ̀ puswənə tə nə tʋn!» ");
INSERT INTO nnw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ʋ ma kʋ́ʋ̀ pìí ʋ bà ʋ karbɩa tə con, yá ʋ kʋ́ʋ̀ nɩ də, ba dwɛ̀e, ba wàrɩ̀ ba yɩ́á ba súrí, dwɩan tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zwezi ma kʋ́ʋ̀ lɛ, ʋ yá ba, ʋ va yɩŋʋna. Ʋ kʋ́ʋ̀ lòrì Yɩɩ nɛɛ batwa tə nii nə, ʋ tə ga bwé tə sʋ̀ràn təntə tətə. ");
INSERT INTO nnw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ʋ kʋ́ʋ̀ pìí ʋ bà ʋ karbɩa tə con, ʋ ga wʋ́: «Á tə yɩ á tə́gə́, á dwɛ̀e? Á nəŋə, máŋá tə, ba nə wá ja *Ləzwənə-Biu tə, ba kə cʋna lɩ̀à tə jɩ̀àn wa, tə bwələ. ");
INSERT INTO nnw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Á zaŋa, nə vìí! Á nəŋə, bɛɛ tə, ʋ nə wá ja nə, ʋ pa tə nə, ʋ bwələ!» ");
INSERT INTO nnw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zwezi yà tə wulə ʋ swɩ̀n, də Zwidasə yí. Ʋ yà yɩ ʋ karbɩa fugə bələ tə wa, lìù don. Lalʋʋ yà wulə ʋ kwa də ba jɩ̀àn lagʋrɩ sɩ̀án də dangwələn. Ba yɩ *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə də ba *nəkwɩna tə nə tʋn ba. ");
INSERT INTO nnw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lìù tə, ʋ nə wá ja Zwezi ʋ pa tə yà bɩrɩ kʋ mʋ̀ lɩ̀à təntə, ba nə púə́ ʋ kwa tə, mɩmɩnʋ tə, ʋ nə wá twá, sə ʋ ma bɩrɩ Zwezi. Ʋ dàń ma swɩ̀n, ʋ wʋ́: «Lìù tə, à nə wá kʋkwalɩ tə, mə ʋ mʋ̀ nə, á pɩ̀à. Á jana kʋ lìù təntə». ");
INSERT INTO nnw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zwidasə fàrʋ́ lala ʋ yí Zwezi yɩra, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «À jʋ̀nɩ̀ mʋ́, karnyɩna!» Ʋ dàń ga kʋkwalɩ wá. ");
INSERT INTO nnw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Zwezi dàń ma swɩ̀n ʋ con, ʋ wʋ́: «À dabɛɛ, kʋ tə, n nə twi, sə n fwa, fwa kʋ lala». Ba duən tə dàń ma fàrʋ́ ba yí, ba ja Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lìù don, ʋ nə yɩn də Zwezi cʋ̀rʋ́ ʋ lagʋrɩ sɩ̀ʋ́, ʋ ma za Yɩɩ joŋwana yun tɩ̀án nəkwɩa tʋ̀tʋ̀nʋ̀ zɩɩn, ʋ gwəŋə. ");
INSERT INTO nnw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zwezi ma swɩ̀n kʋ tíú tə con, ʋ wʋ́: «Lɩ̀à tə mɛ, ba nə cʋ̀rɩ́ lagʋrɩ sɩ̀ʋ́, ba ma gwɩ, ba də yɩ lagʋrɩ sɩ̀ʋ́ nə wá gʋ. Kʋ mʋ̀ tə yɩrɩ, pìí, n kə n lagʋrɩ sɩ̀ʋ́ tə kʋ bwálɩ́ nə. ");
INSERT INTO nnw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","N yə̀rì də, à wàá à nyɩna Yɩɩ saŋʋ à lòrì, ʋ ga wàá ʋ tʋŋa *malɩkɛ kapʋpʋ púlə́ fugə bələ lala, naaa? ");
INSERT INTO nnw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yá kʋ dàń nə yɩn nətʋ, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, nii wá fwa nətə kʋ ma sú. Də tə nə swɩ̀n də, kʋ wá twá nətʋ, kʋ ma tʋn». ");
INSERT INTO nnw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zwezi dàń ma swɩ̀n lalʋʋ tə con nə, ʋ wʋ́: «Á twi də lagʋrɩ sɩ̀án də dangwələn, sə á ma ja nə, ndə à yɩ ŋwɩ̀àn tə, à nə gwɩ lɩ̀à. Dɩɩn mama, à jəni *Zwifə-ba Yɩɩ *dìə̀ tə wa, à kàrɩ̀ lá nə, á ga ba nə janɩ. ");
INSERT INTO nnw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yá tə yìə̀n tə mama dàń yí, sə kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ nii *sʋ̀sʋ̀nà saga tə wa, nii ma sú». Ʋ karbɩa tə mama dàń ma dəri, ba yá wá. ");
INSERT INTO nnw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lɩ̀à tə, ba nə jɩn Zwezi tə ja wá, ba va *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa Kayifə con. Lantə nə, Yɩɩ nii *yənu tɩ̀án tə də Zwifə-ba *nəkwɩna tə yà kun duən nə. ");
INSERT INTO nnw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyɛrə yɩn Zwezi kwa yɩŋʋna, ʋ ja va Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə dəwoo wa. Ʋ vəli ʋ zʋ ʋ jə̀ə́ kàrá tə wa, ʋ də Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə tʋ̀tʋ̀nà, sə ʋ ma na nətʋ tə, kʋ nə wá zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yɩɩ joŋwana yun tɩ̀án tə də Zwifə-ba yun tɩ̀án tə, ba nə bʋ̀rɩ̀ *bʋ̀rà tə mama yà pɩ̀à lɩ̀à, ba nə wá swɩ̀n kʋnkʋn yoo, ba kə Zwezi yuu wa, sə ba ma gʋ wá. ");
INSERT INTO nnw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lɩ̀à zənzən nan, ba kʋnɩ kʋnkʋn ba keni Zwezi nii nə. Yá də kʋ mama ba wà yoo nɩ, sə ba kə ʋ yuu wa. Talɩkwa, talɩkwa nə, bara bələ duən nan ba zɩgɩ tətəŋi wa, ");
INSERT INTO nnw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ba ga wʋ́: «Bɛɛ wà tə swɩ̀n, ʋ wʋ́: ‹À wàá Yɩɩ *dìə̀ tə à mà, à ga pìí à lwà ka dɩan batwa nii nə›.» ");
INSERT INTO nnw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə zàn, ʋ swɩ̀n Zwezi con, ʋ wʋ́: «N ba yoo le, naaa? Bɛ̀eɛ̀e nə lɩ̀à ba tə swɩ̀n, ba kəni n yuu wa?» ");
INSERT INTO nnw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yá Zwezi púə́ ʋ nii. Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À lòrì mʋ́, taa Yɩɩ tə, ʋ nə wulə mɩɩ wa tə yɩrɩ, n le nəba, də n cɩ́gá nə yɩ *Kərisə, Yɩɩ-Biu». ");
INSERT INTO nnw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zwezi ma le wá, ʋ wʋ́: «Mə kʋ yɩ nətʋ, ndə n tətə nə swɩ̀n tə. Yá à mʋ̀ nə swɩ̀n kʋ á con, à súrí lá: Kʋ nə zɩgɩ sɩ́ʋ́n, á wá na *Ləzwənə-Biu tə, ʋ jə̀ə́ Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, jɩzən vàn nə. Á wá na wá də, ʋ naŋa lanworu bakwan tə wa, ʋ bɩ̀àn». ");
INSERT INTO nnw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə dàń ma cɩrʋ ʋ gànʋ̀ də lɩŋa, ʋ ga swɩ̀n, ʋ wʋ́: «Ʋ twɩn Yɩɩ! Nə kʋ́ʋ̀ ba lɩ̀à pɩ̀à, sə ba bɩrɩ nəba yoo don! Á nì sɩ́ʋ́n kʋ tə, ʋ nə twɩn Yɩɩ. Bɛ̀eɛ̀e nə á bʋŋa kʋ yuu wa?» ");
INSERT INTO nnw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ba le wá, ba wʋ́: «Ʋ mɛ, sə ba gʋ wá». ");
INSERT INTO nnw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ba dàń ma pi mɩmɩan, ba lwá ʋ yáá wa. Yá ba ga mà wá də jɩgungulə. Ba duən farʋ ʋ pɩpara nə, ");
INSERT INTO nnw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ba ga wʋ́: «Kərisə, lwarɩ lìù tə, ʋ nə mà mʋ́!» ");
INSERT INTO nnw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyɛrə yà jə̀ə́ dəwoo tə wa. Tʋtʋnbʋa don fàrʋ́ ʋ yí ʋ yɩra, ʋ ga wʋ́: «N də yà wulə də Zwezi Galile tíú tə». ");
INSERT INTO nnw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yá ʋ tɛn lɩ̀à tə mama yáá con nə, ʋ wʋ́: «À yə̀rì kʋ tə, n nə pɩ̀à, sə n swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kʋ kwa nə, ʋ nə zàn, ʋ vələ dəwoo tə mimii kwə́lə́ wa, tʋtʋnbʋa tə don də kʋ́ʋ̀ nɩ wá, ʋ ma swɩ̀n lɩ̀à tə con, ba nə wulə kʋ bwálɩ́ tə nə, ʋ wʋ́: «Ʋ tə yɩ də Zwezi *Nazarɛtə tíú tə». ");
INSERT INTO nnw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyɛrə ma kʋ́ʋ̀ tɛn, ʋ dù, ʋ wʋ́: «À mʋ̀ yə̀rì kʋ bɛɛ təntə». ");
INSERT INTO nnw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kʋ nə fwa mancɩn, ba tə, ba nə zɩga lá tə fàrʋ́ ba yí Piyɛrə yɩra, ba ga swɩ̀n, ba wʋ́: «Cɩ́gá mama, n yɩ ba wa lìù. N nii sʋgʋ tətə bɩrɩ bwálɩ́ tə, n nə nan». ");
INSERT INTO nnw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piyɛrə ma kʋ súrí ʋ nii, ʋ wulə ʋ dwì də ʋ poli ʋ kəni ʋ tɩ̀àn nə, ʋ wʋ́: «À yə̀rì kʋ bɛɛ təntə!» Kʋ máŋá təntə tətə wa nə, cəbɩʋ kwi. ");
INSERT INTO nnw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yá Piyɛrə dàń lìí kʋ tə, Zwezi nə swɩ̀n ʋ con nə, ʋ wʋ́: «Də cəbɩʋ tə nə wà kwi, n wá tɛn nɛɛ batwa, də n yə̀rì nə!» Ʋ dàń nan, ʋ ga kwi yinənkurə. ");
INSERT INTO nnw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jɩjʋ fuən fuən *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə mama də ba *nəkwɩna tə kun duən nə, ba vʋrʋ, sə ba gʋ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba jɩn wá, ba vwa ba ja va ba pa *Pilatə nə, ʋ nə yɩ yáá tíú, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún. ");
INSERT INTO nnw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Máŋá tə wa, Zwidasə, ʋ nə jɩn Zwezi ʋ pa, tə nə nɩ də, ba wá gʋ Zwezi, ʋ zʋa pucʋnɩ nəfarʋ wa. Ʋ dàń ma pìí ʋ ja səbikʋlan fɩtwa tə, ʋ ja va ʋ pa *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə də ba *nəkwɩna tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ʋ swɩ̀n ba con, ʋ wʋ́: «À cʋ̀gʋ̀, à nə pɩn, ba gʋ lìù tə, ʋ nə wà yoo cʋ̀gʋ̀ tə yɩrɩ». Yá ba dàń le wá, ba wʋ́: «Nə mʋ̀ yáá tə̀lə́, kʋ ywàŋá mʋ́!» ");
INSERT INTO nnw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zwidasə dɩlɩ səbiu tə Zwifə-ba Yɩɩ *dìə̀ tə wa, ʋ ga vìí. Ʋ vəli ʋ kùrú ʋ tɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yɩɩ joŋwana yun tɩ̀án tə tì səbiu tə, ba ga wʋ́: «Kʋ culi, sə nə kə kʋ nə Yɩɩ dìə̀ səbiu daka wa, kʋ nə yɩ səbiu tə, ba nə ŋwɩ́n, ba ma gʋ ləzwənə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba nə vʋrʋ ba kə duən nə, kʋ kwa nə, ba tì kʋ səbiu təntə, ba ma yə̀ nəkənmarʋ don kárá, sə ba ma fwa vərə ləbərə bwálɩ́. ");
INSERT INTO nnw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mə kʋ mʋ̀ nə pɩn, kʋ kárá təntə yɩrɩ nə yɩ ‹jana kárá›, kʋ ja bà, kʋ yí zə̀n. ");
INSERT INTO nnw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mə kʋ twá nətʋ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Zweremi sʋ̀ràn tə nii ma sú, ʋ nə wʋ́: «Ba tì səbikʋlan fɩtwa tə, kʋ mʋ̀ nə yɩ səbiu tə, *Yɩzərayɛlə lɩ̀à tə nə jə̀ń ba vʋrʋ, ba ŋwɩ́n ba pa wá. ");
INSERT INTO nnw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yá ba tì kʋ, ba ma yə̀ nəkənmarʋ tə kárá, ndə nətʋ tə *Yuu-Tiu nə pɩn nə nii, sə à swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kʋ kwa nə, ba ja Zwezi ba va yáá tíú *Pilatə con, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún. Yáá tíú dàń ma wulə wá ʋ bwe, ʋ wʋ́: «N mʋ̀ nə yɩ *Zwifə-ba pɩ̀ʋ́ tə?» Zwezi ma le wá, ʋ wʋ́: «Mə kʋ yɩ nətʋ, ndə n nə swɩ̀n tə». ");
INSERT INTO nnw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Zwezi ga wà yoo mama le yìə̀n tə yuu wa, Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə də ba *nəkwɩna tə nə swɩ̀n, ba ja zɩgɩ ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatə dàń ma swɩ̀n ʋ con, ʋ wʋ́: «N ba tə tə mama nə̀ń, ba nə swɩ̀n, ba ja zɩga n nə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yá Zwezi kʋ́ʋ̀ wà wá le kʋ yoo tə yuu wa mɩ́ámɩ́án. Kʋ dàń ga gwárɩ́ yáá tíú tə zənzən. ");
INSERT INTO nnw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","*Pakə cànà mama nə yí, yáá tíú tə yàá pa, ba dʋgʋ bàń dìə̀ lìù tə, lalʋʋ tə nə lòrì, sə ʋ dʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yá kʋ mʋ̀ máŋá təntə wa, bàń dìə̀ lìù don yɩn lá, ba nə boŋə Barabasə, ʋ yɩrɩ nə nan zənzən. ");
INSERT INTO nnw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yáá tíú *Pilatə dàń ma bwe lɩ̀à tə nə kun duən nə tə, ʋ wʋ́: «Wàà nə á pɩ̀à, sə à dʋgʋ: Barabasə, nə à yə̀ə́ Zwezi tə, ba nə boŋə *Kərisə tə?» ");
INSERT INTO nnw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Cɩ́gá, Pilatə yà yə̀ə́, ba nə ja Zwezi, ba bà ʋ con, tə də̀ń. Kʋ yɩ wʋgwɩʋ yɩrɩ nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Máŋá tə wa, Pilatə nə wulə bʋ̀rà tə bwálɩ́ nə, ʋ kan pɩn lìù bà, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Tɩtɩn kʋ tə nə, à dí càn zənzən cɩ́gá tíú wà tə yɩrɩ à pandwɩa wa. Kʋ mʋ̀ yɩrɩ nə, dàn ká kə n tɩ̀àn ʋ yìə̀n wa!» ");
INSERT INTO nnw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə də ba *nəkwɩna tə vəvəri lɩ̀à tə pubʋŋa, ba kə ba con, ba pa ba lòrì Barabasə ba dʋgʋ, ba ga pɩ̀à, sə ba gʋ Zwezi mʋ̀. ");
INSERT INTO nnw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yáá tíú tə bwe ba, ʋ wʋ́: «Ba wàà tətə nə á pɩ̀à, sə à dʋgʋ ba bələ tə wa?» Ba ma le, ba wʋ́: «Barabasə!» ");
INSERT INTO nnw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatə ma bwe, ʋ wʋ́: «Kʋ dàń yɩ à wá fwa Zwezi tə, ba nə boŋə Kərisə tə nətə?» Ba mama ma le, ba wʋ́: «Pa, sə ba paa wá dagarʋ yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yáá tíú ma bwe, ʋ wʋ́: «Bɛ̀eɛ̀e yokʋkwɩʋn nə ʋ fwa?» Yá ba dàń ken ba dɩ̀àn mama lá, ba bubwi, ba wʋ́: «Pa, sə ba paa wá dagarʋ yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Máŋá tə, Pilatə nɩ də, ʋ wàrɩ̀ won mama ʋ fwa, yá lɩ̀à tə ga kwɛn ba cə̀rí ba súrí lá, ʋ tì nɩ́á, ʋ ma sɩn ʋ jɩ̀àn lalʋʋ tə yáá con, ʋ ga wʋ́: «À yáá twá ka tə̀lə́ cɩ́gá tíú wà tə tɩan tə wa! Kʋ yɩ á mʋ̀ yoo!» ");
INSERT INTO nnw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lalʋʋ tə mama le, ba wʋ́: «Ʋ tɩan tə yoo wá tʋ nə mʋ̀, də nə bɩa yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatə dàń ma dʋgʋ Barabasə. Ʋ pa ba mà Zwezi də kafɩran, ʋ yɩra lá, ba ga tì wá, ba pa, sə ba paa dagarʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yáá tíú *Pilatə pamana tə jɩn Zwezi, ba va bʋ̀rà dìə̀. Yá pamana tə duən tə mama dàń twi, ba kun ʋ yuu nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba jɩn ʋ ganan tə, ba lɩ, ba ga zʋ wá də gasɔɔ nəsɩan. ");
INSERT INTO nnw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kʋ kwa nə, ba dàń sʋa casʋran yupuu, ba pú ʋ yuu nə. Yá ba ga kə mɩʋ daduu ʋ jɩzən wa. Ba dàń ga tʋ ba nadwana nii nə, ʋ yáá con, ba mʋn wá, ba wʋ́: «Nə jʋ̀nʋ̀ mʋ́, *Zwifə-ba pɩ̀ʋ́!» ");
INSERT INTO nnw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba pi mɩmɩan ba lwá ʋ nə, ba ga jon mɩʋ daduu tə, ba ma mà ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Máŋá tə wa, ba nə mʋn wá, ba zwɛ̀e, ba jɩn gasɔɔ tə ba lɩ, ba ga kʋ́ʋ̀ pìí ba zʋ wá ʋ tətə ganan tə. Ba dàń ga ja wá ba va, sə ba paa dagarʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pamana tə nə ja Zwezi, ba naŋa tɩʋ tə nii wa, ba jə́rí bɛɛ don, ʋ yɩrɩ nə yɩ Simon, ʋ nə yɩ Sirɛnə tíú. Pamana tə kálʋ́ wá, ba pa ʋ zɩn Zwezi dagarʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba yí bwálɩ́ don, ba nə boŋə ‹Goləgʋta›, kʋ də̀ń nə yɩ ‹yuzʋŋa bwálɩ́›. ");
INSERT INTO nnw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yá lá nə, ba pɩn divɛn, ba nə gùlí yacara tɩ̀ʋ́, kʋ nə cà, tə wa, Zwezi nə, sə ʋ nyʋ. Ʋ nə də́də́n kʋ ʋ nii nə, ʋ vɩga, sə ʋ nyʋ kʋ. ");
INSERT INTO nnw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba paa wá dagarʋ tə yuu wa, ba ga tá kwé, ba ma tara ʋ ganan. ");
INSERT INTO nnw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ba ga kori ba jə̀ə́ lá, sə ba cɩ̀ ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ʋ yuu con nə, ba ken pʋ́pʋ́ná duən lá nə, tə nə bɩrɩ won tə, kʋ nə pɩn, ba ma gʋ wá. Tə wʋ́: «Ʋ tə nə yɩ Zwezi, *Zwifə-ba pɩ̀ʋ́ tə». ");
INSERT INTO nnw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba pa ŋwɩna bələ, ba nə gwɩ lɩ̀à tə, kʋ máŋá tə wa, kʋ bwálɩ́ təntə nə də Zwezi. Ʋ don yɩ Zwezi jɩzən yuu, ʋ don tə yɩ ʋ jɩgwiə yuu. ");
INSERT INTO nnw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lɩ̀à tə, ba nə twá lá, ba lɛ yàá vuvugu ba yuu, ba ga twɩn wá. ");
INSERT INTO nnw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ba yàá swɩ̀n ʋ con, ba wʋ́: «N mʋ̀ lìù tə, n yà nə pɩ̀à, sə n mà Zwifə-ba Yɩɩ *dìə̀ tə, n ga lwà ka dɩan batwa nii nə. N tətə dàń jon n tɩ̀àn, də n nə ya Yɩɩ-Biu, sə n nan dagarʋ tə yuu wa, n cú!» ");
INSERT INTO nnw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án-ba tə də *nəkwɩna tə də yà wulə ba mʋŋa Zwezi, ba ga wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ʋ wàá lɩ̀à duən ʋ joŋə, yá ʋ wàrɩ̀ ʋ tətə ʋ joŋə! Ʋ tà *Yɩzərayɛlə pɩ̀ʋ́, naaa? Ʋ dàń nan dagarʋ tə yuu, ʋ cú sɩ́ʋ́n, sə nə ga kə nə waa ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ʋ pɩn ʋ tɩ̀àn Yɩɩ nə. Yɩɩ nə swə wá, sə ʋ jon wá, sɩ́ʋ́n nə. Ʋ swɩ̀n də, ʋ yɩ Yɩɩ-Biu». ");
INSERT INTO nnw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yá ŋwɩna tə, ba nə gwɩ lɩ̀à tə, ba nə paa dagaran tə yuu ʋ səpuni nə, də wulə ba twɩn wá, ndə ba duən tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kʋ nə zɩgɩ lugu fugə bələ máŋá wa, yikunu púə́ tɩa tə mama nə, kʋ ja va dədəni lugu batwa. ");
INSERT INTO nnw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lugu batwa tə nə yí, Zwezi bubwi ʋ kə yɩɩ nə də ʋ lʋʋ sʋgʋ, ʋ wʋ́: «Eli, Eli, lama sabatanɩ!» Kʋ də̀ń nə yɩ: «À Yɩɩ, à Yɩɩ, bɛ̀eɛ̀e nə pɩn, n ma vɩ nə n dʋgʋ?» ");
INSERT INTO nnw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lɩ̀à tə duən yà nə wulə lá nì ʋ kori, ba ga swɩ̀n, ba wʋ́: «Ʋ boŋə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli!» ");
INSERT INTO nnw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba wa don dəri lala, ʋ va ʋ tì canfɩnsɩʋ ʋ lə divɛn nyʋnʋ wa. Ʋ tì kʋ ʋ vwa mɩʋ nii nə, ʋ làrɩ̀ Zwezi nə, sə ʋ nyʋ. ");
INSERT INTO nnw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yá ba duən tə dàń swɩ̀n, ba wʋ́: «Zɩgɩ, nə wá na də, Eli nə wá bà, ʋ jon wá!» ");
INSERT INTO nnw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zwezi ma bubwi ʋ kə yɩɩ nə, ʋ ga tɩ. ");
INSERT INTO nnw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yá *Zwifə-ba Yɩɩ *dìə̀ tə wa, mimii gànʋ̀ tə zɩgɩ yɩɩ nə, kʋ cɩrɩ, kʋ cú kʋ ja tɩa, kʋ pwɛ̀e bələ. Tɩa tə səsəgi, pɩran kapana ga lwa. ");
INSERT INTO nnw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ləbərə súrú, yá lɩ̀à tə zənzən, ba nə yɩ Yɩɩ nə tɩ, ba yà nə tɩga, pìí ba bwin, ba nan tɩga wa. ");
INSERT INTO nnw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Zwezi bwiun tə kwa nə, lɩ̀à təntə nan ləbərə tə wa, ba va tɩʋ tə, kʋ nə yɩ Yɩɩ nyiən wa. Yá lɩ̀à zənzən ga na ba lá nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","*Romə-ba pamana bíí yuu tíú də pamana tə, ba nə cɩ̀ Zwezi nə, tə mama nɩ tɩa tə səsəgu tə, də kʋ tə mɛ, kʋ nə yí. Fən dàń jɩn ba zənzən, ba ga wʋ́: «Ʋ cɩ́gá yà yɩ Yɩɩ-Biu». ");
INSERT INTO nnw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kana, ba nə dáá, də yà twá Zwezi kwa, də ʋ tə yà wulə Galile nagwanaa wa, sə ba tʋn ba pa wá. Ba də yà zɩga yɩŋʋna, ba ga ywàŋá. ");
INSERT INTO nnw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ba wa kana duən nə yɩ: Mari Madəlɛnə, də Mari, ʋ nə yɩ Zwakə də Zwʋzɛfə nuu, də kan don, ʋ nə yɩ Zebede bɩa tə nuu. ");
INSERT INTO nnw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dədəni nə twi kʋ yí, jɩjə tíú don twi, ʋ nə nan Arimate, ʋ yɩrɩ nə ya Zwʋzɛfə. Ʋ də yà yɩ Zwezi karbiu. ");
INSERT INTO nnw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ʋ vəli ʋ yí *Pilatə, ʋ ga lòrì cwəŋə, sə ʋ gùrì Zwezi. Pilatə dàń ma pa cwəŋə, sə ba pa wá Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ʋ ma tì wá, ʋ pəpəni ʋ kə ganpon wa, ");
INSERT INTO nnw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ʋ ja wá ʋ va ʋ tún ləbəri nədʋn wa, ʋ nə pa ba kʋ̀ pɩ̀ʋ̀ kapan wa, ʋ tətə yɩrɩ. Kʋ kwa nə, ʋ bəbəli pɩ̀ʋ̀ kapan nəfarʋ, ʋ ma pú ləbəri tə nii nə, ʋ ga vìí. ");
INSERT INTO nnw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Madəlɛnə tə, də Mari tə don də yà yɩn lá. Ba yà jə̀ń ləbəri tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kʋ tɩkʋnɩ yà yɩ *Zwifə-ba *sìə́ dɩɩn tə. Yá Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də *Farɩzɩan-ba twá duən, ba va ba yí Pilatə. ");
INSERT INTO nnw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ba ga swɩ̀n, ba wʋ́: «Yuu tíú, nə yə̀ə́ də, kʋ mʋ̀ kʋnkʋnʋ təntə, máŋá tə wa, ʋ tə nə wà tɩ tə, ʋ yà swɩ̀n, ʋ wʋ́: ‹Dɩan batwa nii nə, à wá pìí à bwin à nan tɩan wa›. ");
INSERT INTO nnw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kʋ mʋ̀ tə yɩrɩ, pa nii, sə ba cɩ̀ ləbəri tə nə, kʋ ja vələ dɩan batwa. Ʋ karbɩa tə dàn ká bà, ba ŋʋ̀ wá. Yá kʋ kwa nə, ba ga swɩ̀n lalʋʋ tə con nə, ba wʋ́: ‹Ʋ pìí ʋ bwin, ʋ nan tɩga wa›. Kʋ mʋ̀ talɩkwa kʋnkʋn təntən càn wá doni dí yáá nyiən tə». ");
INSERT INTO nnw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatə ma swɩ̀n, ʋ wʋ́: «Á nəŋə, pamana nə, sə ba cɩ̀ ləbəri tə nə. Á vələ á cɩ̀ ləbəri tə nə, ndə á nə pɩ̀à nətʋ». ");
INSERT INTO nnw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ba dàń ma va, ba kwɛn ba sun ləbəri tə nii zəni, ba tún pamana lá, sə ba cɩ̀ kʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","*Zwifə-ba *sìə́ dɩɩn tə nə zwɛ kwa nə, Mari Madəlɛnə, də Mari tə don twi jɩjʋ fuən fuən, sə ba na ləbəri tə. ");
INSERT INTO nnw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Naa nədʋ, də tɩa tə səsəgi zənzən, *Yuu-Tiu *malɩka nan yɩɩ nə, ka cú ka bəbəli kapan tə, ka tún vàn nə, ka ga jə̀ń kʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malɩka tə yà nyɩn ndə dwà pɩpɩlʋ nə. Yá ka ganan tə yɩ nəpwənə ndə janfɩnpon nə. ");
INSERT INTO nnw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Fən tì pamana tə, ba wulə ba vɩvaga, ba ga tɩ, ba kʋ̀ yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malɩka tə ma swɩ̀n kana tə con, ka wʋ́: «Á dànà ká pa fən ja aba. À yə̀ə́ də, á pɩ̀à Zwezi, lìù tə, ba nə paa dagarʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ʋ tə̀lə́ yəbə, ʋ pìí ʋ bwin ʋ nan tɩan wa, ndə ʋ yà nə swɩ̀n kʋ nətʋ. Á bɩ̀àn, á ywàń bwálɩ́ tə, ʋ yà nə pə̀ń. ");
INSERT INTO nnw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Á dàń vələ lala, á swɩ̀n ʋ karbɩa tə con, də Zwezi pìí ʋ bwin ʋ nan tɩan wa. Ʋ dàń ga dí yáá ʋ vələ, sə ʋ dàn ba Galile nagwanaa wa, sɩ́ʋ́n nə. Mə lá nə, ba wá na wá. Mə kʋ tə nə à jə, sə à swɩ̀n á con». ");
INSERT INTO nnw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ba kɛ̀eń lala, ba vìí ləbəri tə nii nə, də fən də pupoli nəfarʋ. Ba ga dəri ba va, ba pa ŋwɛn təntə Zwezi karbɩa tə nə. ");
INSERT INTO nnw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Naa nədʋ, də Zwezi twi ʋ jə́rí ba, ʋ ga wʋ́: «À jʋ̀nɩ̀ aba!» Kana tə fàrʋ́ ba yí ʋ yɩra, ba tʋ ba nadwana nii nə, ba ja ʋ nɛɛ nə, ba ga pa wá dun. ");
INSERT INTO nnw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Á dànà ká pa fən ja aba. Á vələ, á swɩ̀n à nubɩa tə con, ndə ba vələ Galile nagwanaa. Mə lá nə, ba wá na nə». ");
INSERT INTO nnw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Máŋá tə wa, kana tə nə pìí ba vəri, pamana tə duən, ba nə cɩ̀ ləbəri tə nə, pìí ba bà *Zwerizalɛmə wa. Ba swɩ̀n *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə con, kʋ tə mama, kʋ nə yí. ");
INSERT INTO nnw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yɩɩ joŋwana yun tɩ̀án tə bon jə́rə́ ba mʋ̀ də Zwifə-ba *nəkwɩna tə. Ba nə vʋrʋ ba kə duən nə, ba zwɛ̀e kwa nə, ba pɩn səbifarʋ pamana tə nə, ");
INSERT INTO nnw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ba ga swɩ̀n ba con, ba wʋ́: «Á wá swɩ̀n də, Zwezi karbɩa tə nə twi tɩtɩn nə, ba ŋʋ̀ wá, də á dwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Də yáá tíú, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, tə nì kʋ, nə yə̀ə́ nə tə wá swɩ̀n ʋ con nətʋ, sə wʋwala dàn ká yí aba». ");
INSERT INTO nnw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pamana tə jon səbiu tə, ba ga twá ba nii nə, ndə ba nə swɩ̀n nətʋ. Mə nətʋ nə, kʋ yoo tə carɩ kʋ sú Zwifə-ba pwərə wa, kʋ ja bà zə̀n. ");
INSERT INTO nnw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zwezi karbɩa fugə nədʋ tə vəli Galile paan tə yuu, Zwezi nə bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Máŋá tə nə, ba nə nɩ wá, ba pɩn wá dun. Ba wa lɩ̀à duən ga bɛ̀eé, də kʋ yɩ ʋ mʋ̀. ");
INSERT INTO nnw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Zwezi fàrʋ́ ʋ yí, ʋ ga swɩ̀n, ʋ wʋ́: «Yɩɩ ken dɩ̀àn tə mama Yɩɩ *sàń nə, də tɩa yuu wa à jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Á vələ, á yí dwíə́ tə mama lʋʋ mama wa, sə á ja ba, á fwa à karbɩa. Á liə ba nɩ́á wa, kʋ twá də nyɩna Yɩɩ, də Yɩɩ-Biu tə, də Yɩɩ-*Siŋu tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Á ga kàrɩ̀ ba, sə ba twá kʋ tə mama nii nə, à nə bɩrɩ aba. Á cʋga zəni, à wá yà də aba, dɩɩn mama, kʋ ja vələ lʋʋ zaŋʋ».");
INSERT INTO nnw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kʋ yɩ máŋá tə, Yɩɩ-Biu Zwezi-*Kərisə sʋywáŋʋ́ tə nə twi. ");
INSERT INTO nnw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi sagɩ tə wa, Yɩɩ swɩ̀n Zwezi yoo: «Ywàń, à tʋn à tʋntʋnʋ n yáá nə, sə ʋ kwɛn cwəŋə ʋ pa mʋ́. ");
INSERT INTO nnw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kʋ yɩ bɛɛ nə bubwi kasɔɔ lanworu wa, ʋ wʋ́: ‹Á kwɩ̀án *Yuu-Tiu cwəŋə tə, sə á cɛ ʋ cwəmɩnɩ tə, sə tə ya mənə mənə›.» ");
INSERT INTO nnw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kʋ mʋ̀ tʋntʋnʋ təntə yɩ *Zwan-Batisə. Nətʋ nə ʋ nan kasɔɔ tə wa, ʋ swɩ̀n Yɩɩ yoo ʋ bɩrɩ lɩ̀à nə, ʋ wʋ́: «Á vəvərə á kwa á ma sá á cʋna. Á pɩan, ba lə aba nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. Yá Yɩɩ dàń wá kwɛn á cʋna tə, ʋ lɩ á mʋ̀ də wá pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zwide nagwanaa lɩ̀à mɛ də Zwerizalɛmə tɩʋ lɩ̀à twi ʋ con. Ba dàń swɩ̀n ba cʋna ba bɩrɩ Zwan, yá ʋ ga zɩga lá ʋ li ba Zwurədɛn mʋnaa tə wa, kʋ twá də Yɩɩ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zwan yà zʋa nyʋgʋma kʋran gànʋ̀, ʋ ga vwa tànʋ̀ voru ʋ tàŋá nə. Ʋ yà də́ jərən də tʋran. ");
INSERT INTO nnw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ʋ dàń kàrɩ̀ Yɩɩ yoo ʋ bɩrɩ lɩ̀à tə nə, ʋ wʋ́: «Lìù don, ʋ dɩ̀àn nə dáá tə doni nə, ʋ pú à kwa ʋ bà. À jɩɩn mùrì, sə à tʋ à nadwana nii nə, sə à kʋrʋ ʋ natʋra. ");
INSERT INTO nnw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","À mʋ̀ ləgə aba nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ, yá ʋ mʋ̀ wá pa, Yɩɩ-*Siŋu tə sú aba». ");
INSERT INTO nnw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Zwezi dàń nan *Nazarɛtə tɩʋ wa, Galile nagwanaa wa, ʋ bà *Zwan con. Zwan ləgə wá Zwurədɛn mʋnaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Máŋá tə, Zwezi nə naŋa nɩ́á tə wa, ʋ nɩ lanworu də kʋ súrí, yá Yɩɩ-*Siŋu tə cúə́ ʋ yuu wa ndə gunpwənə nə. ");
INSERT INTO nnw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kori dàń ga nan Yɩɩ sàń nə, kʋ wʋ́: «N yɩ à biswənə tə, ʋ nə poli à pùə́». ");
INSERT INTO nnw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kʋ kwa nə, Yɩɩ-*Siŋu tə yigu Zwezi, kʋ pa ʋ va kasɔɔ lanworu wa. ");
INSERT INTO nnw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ʋ yɩ kasɔɔ tə wa dɩan sapwilə. Kʋ bwálɩ́ tə nə, *Sɩtana də́də́n, sə ʋ yigu wá, ʋ pa ʋ tʋn yokʋkwɩʋn. Zwezi də ganaŋa yà nə wulə duən nə. *Malɩkɛ dàń yà ga tʋŋa tə pɩn wá. ");
INSERT INTO nnw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kʋ kwa nə, ba nə ken Zwan bàń dìə̀ wa, Zwezi vəli Galile nagwanaa. Ʋ swɩ̀n ʋ kàrɩ̀ Yɩɩ sʋywáŋʋ́ tə lá, ");
INSERT INTO nnw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ʋ ga swɩ̀n, ʋ wʋ́: «Máŋá tə, Yɩɩ nə lɩ ʋ tún, tə yí. Yá máŋá bwələ, sə Yɩɩ də́ ʋ pàrɩ̀ tə lɩ̀à mama yuu wa. Kʋ mʋ̀ nə pɩn, á vəvərə á kwa, á ma sá á cʋna, á ga sɛ̀e Yɩɩ sʋywáŋʋ́ tə». ");
INSERT INTO nnw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Zwezi nə wulə Galile mʋnaa tə nii nə ʋ vəli, ʋ nɩ Simon də ʋ nubiu Andəre, ba nə yɩ fəlijana. Ba dàń yà wulə ba dɩlɩ ba fələ gə̀gə̀lù mʋnaa tə wa, ba ma janɩ fələ. ");
INSERT INTO nnw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Á bɩ̀àn à mʋ̀ con, à dàń wá pa, á pɩ̀à lɩ̀à, sə ba twá à mʋ̀ Zwezi nə». ");
INSERT INTO nnw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lala də ba dʋgʋ ba fələ gə̀gə̀lə̀n tə lá, ba ga twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ʋ nə kɛ̀eń ʋ va yáá mancɩn də ʋ na Zwakə də ʋ nubiu Zwan, ba nə yɩ Zebede bɩa. Ba yà wulə ba nɩ́á yuu bori wa, ba kwɛn ba fələ gə̀gə̀lə̀n. ");
INSERT INTO nnw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Lala də Zwezi bon Zwakə də Zwan. Ba nan ba yá ba nyɩna Zebede də ʋ tʋ̀tʋ̀nà tə nɩ́á yuu bori tə wa, ba ga twá Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Zwezi də ʋ karbɩa tə yí Kapɛrənayimə tɩʋ. *Zwifə-ba *sìə́ dɩɩn nə, Zwezi zʋa Zwifə-ba *jə́rə́ dìə̀ wa, ʋ ga wulə ʋ kàrɩ̀. ");
INSERT INTO nnw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lɩ̀à tə cʋga wá, ʋ kàrà tə gwárɩ́ ba zənzən. Ʋ yɩ ʋ kàrɩ̀ ba də dɩ̀àn, Yɩɩ nə ken ʋ jɩɩn wa. Kʋ mʋ̀ nə pɩn, ʋ nə ba yɩ ndə Yɩɩ nii *yənu tɩ̀án tə nə. ");
INSERT INTO nnw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kʋ máŋá tə wa, bɛɛ don, *zini yà nə jə, zʋa Zwifə-ba jə́rə́ dìə̀ tə wa. Zini tə bubwi, kʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Bɛ̀eɛ̀e nə n pɩ̀à fwa nə yɩra, *Nazarɛtə Zwezi? N yɩ n twi, sə n cʋ̀gʋ̀ nəba. À yə̀ə́ mʋ́. N ya lìù, ʋ nə lɩ ʋ tún Yɩɩ cɩcɩ yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zwezi dàń caga zini tə nii nə, ʋ wʋ́: «Pú n nii, n ga nan n yá bɛɛ tə!» ");
INSERT INTO nnw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Zini tə vuvugu bɛɛ tə, kʋ ga nan də kʋ mà nii. ");
INSERT INTO nnw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kʋ kələ lɩ̀à tə mama, ba ga bwe duən: «Bɛ̀eɛ̀e nə yɩ kʋ tə? Kàrà dʋ̀n kʋ pɩn də dɩ̀àn. Kʋ mʋ̀ bɛɛ təntə pɩn zini zìlí ʋ nii wa». ");
INSERT INTO nnw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Naa nədʋ, Zwezi yɩrɩ súə́ tɩa mama Galile nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Zwezi də ʋ karbɩa tə nan *Zwifə-ba *jə́rə́ dìə̀ wa, ba ga va Simon də Andəre sàń. Zwakə də Zwan də yà wulə də ba. ");
INSERT INTO nnw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Waran yà jə Simon tɩnkan, ʋ ga tə́gə́. Máŋá tə Zwezi nə yí, ba swɩ̀n ʋ yoo ba bɩrɩ wá. ");
INSERT INTO nnw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Zwezi fàrʋ́ ʋ yí ʋ yɩra, ʋ ja ʋ jɩɩn nə, ʋ van wá ʋ zɩ̀n gədoo tə yuu. Ʋ waran tə zwɛ̀e, ʋ ga zàn, ʋ wulə ʋ tanɩ, sə ʋ ma lɩ Zwezi vəri. ");
INSERT INTO nnw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Máŋá tə dədəni nə yí, yɩɩ nə zʋa kwa nə, lɩ̀à tə mama tì ba yayɩŋa də lɩ̀à tə *zini nə jə, ba ja va Zwezi yáá nə. ");
INSERT INTO nnw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tɩʋ tə lɩ̀à mama yà kun dìə̀ tə mimii yáá nə. ");
INSERT INTO nnw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Zwezi dàń zwɛ̀e lɩ̀à kapʋpʋ yayɩran tə yirə yirə yà nə jə ba, ʋ ga dɩŋɩ zinə zənzən ʋ lɩ lɩ̀à yuu wa. Ʋ wà yá ʋ pa zinə tə swɩ̀n, ʋ yà nə yə̀ə́ də, tə yə̀ə́ wá yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kʋ tɩa nə pʋrɩ, Zwezi zàn ʋ nan tɩʋ tə wa, də tɩbɩlakʋnʋ tə wà yí. Ʋ vəli bwálɩ́ tə, won mama nə tə̀lə́. Lantə nə, ʋ dàń zɩga ʋ jʋ̀nɩ̀ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon də karbɩa tə duən zàn ba bɩbarɩ, ba twarɩ ʋ nɛɛ. ");
INSERT INTO nnw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Máŋá tə wa, ba nə nɩ wá, ba swɩ̀n ʋ con: «Lɩ̀à tə mama pɩ̀à mʋ́». ");
INSERT INTO nnw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zwezi ma le ba, ʋ wʋ́: «Nə vələ bwálá tə duən də səpuni tɩan tə wa. À pɩ̀à, sə à kàrɩ̀ lantə də, mə kʋ yɩrɩ nə à twi». ");
INSERT INTO nnw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Zwezi dàń ma jiru Galile nagwanaa tə mɛ wa, ʋ ma kàrɩ̀ *Zwifə-ba *jə́rə́ dii tə wa, yá ʋ ga dɩŋɩ *zinə ʋ lɩ lɩ̀à yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dayarʋ don twi Zwezi con, ʋ tʋ ʋ nadwana nii nə ʋ yáá con, ʋ ga lòrì wá, ʋ wʋ́: «N nə swə, n wàá n pɩn à dayan tə zwɛ̀e, sə à də jì ləzwənzəŋu». ");
INSERT INTO nnw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ʋ yinəgə jɩn Zwezi, ʋ te ʋ jɩɩn ʋ nə, ʋ dwen ʋ yɩra, ʋ ga swɩ̀n, ʋ wʋ́: «À swə, sə n dayan tə zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lala də dayan tə zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kʋ kwa nə, Zwezi pɩn bɛɛ tə vìí, ʋ ga bɩrɩ wá yìə̀n tə nə cà, ʋ nə mɛ, sə ʋ va ʋ tʋn. ");
INSERT INTO nnw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Ja n nii zəni! Dàn ká swɩ̀n kʋ lìù con. N dàń nə vəli, n bɩrɩ n tɩ̀àn *Zwifə-ba Yɩɩ *joŋwanʋ tə nə. N dàń ga pa wiən tə, ʋ nə wá ma fwa *joŋi tə, ndə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, nə bɩrɩ Yɩɩ sagɩ tə wa, sə dayaran pa, də ba dayan tə nə zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yá bɛɛ tə vəli, ʋ man bwálɩ́ mama kʋ tə, kʋ nə yí wá. Kʋ mʋ̀ yɩrɩ, Zwezi yà kʋ wàrɩ̀ ʋ vəli ʋ naŋa tɩʋ mama wa, pwənə pwənə. Ʋ yàá mɛ kwa con, bwálá tə, lɩ̀à nə ba bwələ. Yá ba ga tə naŋa bwálá mama, ba twi ʋ con. ");
INSERT INTO nnw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kʋ kwa nə, Zwezi pìí ʋ va Kapɛrənayimə, yá lɩ̀à dàń nì də ʋ wulə dìə̀ don wa. ");
INSERT INTO nnw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lɩ̀à zənzən twi ba kun duən nə. Halɩ bwálɩ́ mama yà súə́, yá bwálɩ́ ya kʋ́ʋ̀ tə̀lə́ kàrá wa, mimii tə yáá nə. Zwezi yà wulə ba ʋ kàrɩ̀ Yɩɩ sʋywáŋʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lɩ̀à duən twi də gwànʋ́ don, ba wa bara banɩa ga zɩŋa gwànʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lɩ̀à tə nə dáá tə pɩn, ba yà wàrɩ̀ wá Zwezi nə ba bɩrɩ. Ba dàń ma dɩ̀ ba poru bʋʋ dəyuu tə wa, kʋ mɛ də bwálɩ́ tə Zwezi nə wulə. Ba dàń ga twá bʋʋ tə, ba cú gwànʋ́ tə nə tə́gə́ ʋ tɩtaʋ tə wa, dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zwezi nə nɩ də, bara tə ken ba waa ʋ nə, ʋ dàń swɩ̀n gwànʋ́ tə con, ʋ wʋ́: «À dabɛɛ, à kwɛn n cʋna tə, à lɩ n mʋ̀ də Yɩɩ pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yɩɩ nii *yənu tɩ̀án yà nə jə lá, yà bʋŋa ba waa con nə, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Bɛ̀eɛ̀e nə pɩn, bɛɛ wà tə swɩ̀n nətən? Kʋ yɩ Yɩɩ nə, ʋ twɩn! Wàà nə wàá cʋna ʋ kwɛn ʋ lɩ ʋ mʋ̀ də Yɩɩ pwərə wa? Kʋ yɩ Yɩɩ cɩcɩ!» ");
INSERT INTO nnw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Zwezi zəzən ʋ lwarɩ kʋ tə, ba nə bʋŋa, ʋ waa con, yá ʋ ga swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á ma jə pubʋŋɩ tətə yiri á waa con? ");
INSERT INTO nnw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Də à nə swɩ̀n gwànʋ́ tə con, à wʋ́: ‹À kwɛn n cʋna tə, à lɩ à mʋ̀ də Yɩɩ pwərə wa›, nə à yə̀ə́, à nə wʋ́: ‹Zàn yɩɩ nə, n tì n tɩtaʋ, n vìí!› Kʋ kwa nə yɩ mwálɩ́? ");
INSERT INTO nnw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yá à dàń pɩ̀à, sə á yəni də, Yɩɩ ken dɩ̀àn *Ləzwənə-Biu jɩɩn wa tɩa yuu wa, sə ʋ kwɛn cʋna, ʋ lɩ ʋ mʋ̀ də Yɩɩ pwərə wa». Zwezi dàń ga swɩ̀n sʋ̀ràn tətə gwànʋ́ tə con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«À mʋ̀ nə swɩ̀n kʋ n con nə: Zàn, n tì n tɩtaʋ, n va n sàń». ");
INSERT INTO nnw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Máŋá tə wa, lɩ̀à tə mama yà nə wulə ba ywàŋá, lala də bɛɛ tə zàn, ʋ tì ʋ tɩtaʋ, ʋ vìrí. Kʋ gwárɩ́ ba mama, ba dàń ga bwɩ Yɩɩ nə, ba ga swɩ̀n, ba wʋ́: «Nə tə wà kʋ tə ba tə nyɩnyɩga nɩ!» ");
INSERT INTO nnw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zwezi pìí ʋ va Galile mʋnaa tə nii nə. Lalʋʋ zənzən yà twi ʋ con, ʋ kàrɩ̀ ba. ");
INSERT INTO nnw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ʋ nə kɛ̀eń, ʋ nɩ Aləfe bìú Levi, də ʋ jə̀ə́ ʋ joŋə lanpoo. Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Zàn, n bà, n twá à nə!» Levi dàń zàn, ʋ twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kʋ kwa nə, Zwezi də ʋ karbɩa tə vələ Levi sàń nə, sə ba də́ wodiu. Lɩ̀à tə, ba nə joŋə lanpoo, də cʋna lɩ̀à duən, ba yà wulə ba də́ də ba. Ba mʋ̀ ləzwənyirə tə yà dáá, ba nə pwí ʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yɩɩ nii *yənu tɩ̀án tə, ba yà nə wulə *Farɩzɩan-ba kwa də yà wulə lá nə. Ba nɩ Zwezi də ʋ wulə ʋ də́ də lɩ̀à tə, ba nə joŋə lanpoo, də cʋna lɩ̀à duən. Ba dàń swɩ̀n Zwezi karbɩa tə con, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, ʋ ma də́ də lɩ̀à tə, ba nə joŋə lanpoo, də cʋna lɩ̀à tə?» ");
INSERT INTO nnw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Zwezi ma nì kʋ, yá ʋ dàń swɩ̀n ba con, ʋ wʋ́: «Lɩ̀à tə, ba yɩra nə zurə, ba dɩmʋtʋrʋ pɩ̀à, kʋ yɩ yayɩŋa nə pɩ̀à dɩmʋtʋrʋ. À wà twi, sə à bon cɩ́gá tɩ̀án, yá cʋna lɩ̀à tə». ");
INSERT INTO nnw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Dɩɩn don nə, Zwan karbɩa də *Farɩzɩan-ba yà vwə ba níə́. Lɩ̀à dàń twi ba bwe Zwezi, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn Zwan karbɩa də Farɩzɩan-ba tə yàá vwe ba níə́, yá n mʋ̀ karbɩa tə ga ba ba níə́ vwe?» ");
INSERT INTO nnw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Zwezi ma le ba, ʋ wʋ́: «Bɛɛ nə pɩ̀à ʋ vwa ʋ kan fúrú, ʋ dabara yàá bà, sə ba twá ba də́ fúrú tə diŋə tə. Á bʋŋa də, ba wá vwe ba níə́, ba dàn ká də́ wodiu tə, yá fúrú bɛɛ ga wulə də ba? ");
INSERT INTO nnw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yá máŋá dàń wá bà, fúrú bɛɛ tə nə ba ya lá. Kʋ mʋ̀ máŋá təntə wa, ba dàń wá vwə ba níə́. ");
INSERT INTO nnw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Lìù tə̀lə́, ʋ nə wá fʋ gantwandʋn ʋ ma pú gangwɩrʋ. Kʋ nətʋ tə nə fwa, gandʋn tə wá vuri gangwɩrʋ tə vàn don, yá bʋʋ tə dàń wá doni də́ yáá tə tətə. ");
INSERT INTO nnw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yá lìù mama ba swana tə nə wulə tə zaŋa lwé ʋ kəni purə nədwara wa. Kʋ nətʋ tə nə fwa, tə mʋ̀ swana tə wá pa purə tə pwin, yá swana tə də purə tə mɛ wá va bwàná. Kʋ mɛ, sə ba kə swana tə nə wulə tə zaŋa purə nədʋra wa». ");
INSERT INTO nnw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","*Zwifə-ba *sìə́ dɩɩn don nə, Zwezi yà twá kárɩ́ wa ʋ kɛ̀eń. Ʋ karbɩa tə ma vəli də ba kén mɩna yun tə cwəŋə tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","*Farɩzɩan-ba tə dàń ma swɩ̀n Zwezi con, ba wʋ́: «Ywàń, bɛ̀eɛ̀e nə pɩn, n karbɩa tə fwa kʋ tə, kʋ nə wà mɛ, sə kʋ fwa sìə́ dɩɩn nə?» ");
INSERT INTO nnw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zwezi ma le ba, ʋ wʋ́: «Á tə wà kàrɩ̀ pɩ̀ʋ́ *Davidə yoo naaa? Bɛ̀eɛ̀e nə ʋ fwa máŋá tə wa, niən tə nə jɩn ʋ də ʋ kwa lɩ̀à tə, yá wodiu də ga tə̀lə́ ba də́? ");
INSERT INTO nnw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ʋ zʋa Yɩɩ *dìə̀ tə wa, ʋ də́ dipɛn tə, kʋ nə wulə lá nə. Abɩatarə yà nə yɩ *Zwifə-ba Yɩɩ *joŋwanʋ yuu tíú kʋ máŋá tə wa. Yá Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, yà pɩn cwəŋə Yɩɩ joŋwana tə cɩcɩ nə, sə ba mʋ̀ nə də́ Yɩɩ dìə̀ dipɛn təntə. Yá Davidə tì tə, ʋ də́ ʋ ga lɩ tə duən ʋ pa ʋ lɩ̀à tə nə». ");
INSERT INTO nnw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Zwezi kʋ́ʋ̀ swɩ̀n ba con, ʋ wʋ́: «Yɩɩ yà ʋ fwa sìə́ dɩɩn, sə kʋ ma kwɛn ləzoni, ləzwənə tà ba fwa sìə́ dɩɩn yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kʋ mʋ̀ nə pɩn, *Ləzwənə-Biu tə ma tɩ sìə́ dɩɩn tə də tətə». ");
INSERT INTO nnw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kʋ kwa nə, Zwezi pìí ʋ zʋ *Zwifə-ba *jə́rə́ dìə̀ tə wa. Yá bɛɛ don yà wulə lá, ʋ jɩɩn nə tɩga. ");
INSERT INTO nnw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lɩ̀à duən yà pàlɩ̀ Zwezi, ba ga cʋga ʋ nə, sə ba jə́n ʋ nə wá pa ʋ yayɩgʋ tə zwɛ̀e Zwifə-ba *sìə́ dɩɩn tə nə. Ba yà pɩ̀à, sə ba twá nətʋ, ba ma swɩ̀n, ba zɩgɩ Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zwezi swɩ̀n bɛɛ tə, ʋ jɩɩn nə tɩga, tə con, ʋ wʋ́: «Zàn yɩɩ nə, lɩ̀à tə mɛ yáá con!» ");
INSERT INTO nnw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ʋ dàń ga bwe lɩ̀à tə, ba nə ywàŋá tə, ʋ wʋ́: «Bɛ̀eɛ̀e nə Yɩɩ *nii tə swɩ̀n, sə ba fwa sìə́ dɩɩn nə? Yozəŋu nə à yə̀ə́ yolwan? Kʋ mɛ, sə à jon bɛɛ tə mɩɩ, à kə lʋʋ, nə à yə̀ə́, sə à yá wá ʋ cʋ̀gʋ̀?» Yá ba yà ba le. ");
INSERT INTO nnw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Zwezi ywàń ba mɛ də lɩŋa. Ʋ pùə́ ga cʋ̀gʋ̀ zənzən ba yuu wa, ba pubʋnkʋkwɩnan tə yɩrɩ. Ʋ dàń ma swɩ̀n bɛɛ tə con, ʋ wʋ́: «Làrɩ́ n jɩɩn tə à con!» Ʋ ma làrɩ̀ kʋ, kʋ ga lwàń kʋ jì jɩɩn nəzəŋu. ");
INSERT INTO nnw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","*Farɩzɩan-ba tə zàn ba nan ba vìí. Ba vəli ba na *Erodə kwa lɩ̀à, ba vʋrʋ ba jə́n, ba nə wá twá nətʋ, ba ma gʋ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zwezi də ʋ karbɩa tə nan lɩ̀à tə wa, ba va Galile mʋnaa tə nii nə. Lalʋʋ tə púə́ ʋ kwa. Ba yà naŋa Galile də Zwide nagwanɛɛ, ");
INSERT INTO nnw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","də *Zwerizalɛmə tɩʋ, də Yidime nagwanaa, də nagwanaa tə, kʋ nə wulə Zwurədɛn mʋnaa tə vàn tə don nə, də lʋʋ tə, kʋ nə bwələ Tirə də Sidon tɩ̀án tə. Lalʋʋ təntə mɛ yà twi Zwezi con, ba yà nə nì kʋ tə mama, ʋ nə fwa tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Zwezi dàń ma swɩ̀n ʋ karbɩa tə con, sə ba kwɛn nɩ́á yuu bori nəmanbiə ba tún lá ʋ nə, lɩ̀à tə dàn ká nyin wá yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kʋ yɩ cɩ́gá, yayɩŋa tə mama fàrʋ́ ba yí, sə ba dwen ʋ yɩra, ʋ nə wulə ʋ zwɛ̀e lɩ̀à zənzən yayɩran yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yá máŋá tə nə, *zinə tə nə yàá na wá, lɩ̀à tə, zinə tə nə jə, tə yàá tʋ ʋ yáá nə ba mà nii, ba ga wʋ́: «N yɩ Yɩɩ-Biu». ");
INSERT INTO nnw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yá Zwezi dàń yàá caga zinə tə nii nə, sə tə dàn ká swɩ̀n kʋ tə, ʋ nə yɩ. ");
INSERT INTO nnw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kʋ kwa nə, Zwezi dɩ̀gà paan don yuu wa, ʋ ga bon lɩ̀à tə, ʋ nə pɩ̀à, kʋ tɩ̀án ma bà. ");
INSERT INTO nnw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ʋ lɩ ba wa lɩ̀à fugə bələ. Ʋ kúrí ba, sə ba ya də wá, ");
INSERT INTO nnw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sə ʋ pa ba va ba swɩ̀n Yɩɩ sʋgʋ tə. Ʋ pa ba dɩ̀àn, sə ba ma wànɩ́ ba dɩŋa *zinə ba lɩ lɩ̀à yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ba lɩ̀à fugə bələ tə nə yɩ: Simon, Zwezi nə ken ʋ yɩrɩ Piyɛrə, ");
INSERT INTO nnw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebede bɩa Zwakə də Zwan, Zwezi pɩn ba yɩrɩ Bwanɛrəzwɛsə, kʋ də̀ń nə yɩ: ‹ləzoni, ba nə nyɩn ndə dwà baga nə›, ");
INSERT INTO nnw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andəre, də Filipə, də Barətelemi, də Matiə, də Toma, də Aləfe bìú Zwakə, də Tade, də Kananitə Simon, ");
INSERT INTO nnw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","də Yisəkariyɔtə Zwidasə, ʋ tə ʋ nə jɩn Zwezi ʋ pa ʋ dʋŋa nə tə. ");
INSERT INTO nnw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kʋ kwa nə, Zwezi pìí ʋ va sàń. Lɩ̀à tə dáá kʋ pa Zwezi də ʋ karbɩa tə yà wàrɩ̀ ba də́. ");
INSERT INTO nnw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ʋ dìə̀ lɩ̀à nə nì tə yìə̀n tə, máŋá tə nə, ba zàn ba bà, sə ba ja wá. Ba yà wʋ́: «Ʋ yuu tə̀lə́». ");
INSERT INTO nnw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","*Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə yà nə nan *Zwerizalɛmə ba bà lá yà swɩ̀n, ba wʋ́: «*Zinə pɩ̀ʋ́ tə, ba nə boŋə ‹Beləzebilə›, nə wulə ʋ yɩra, ʋ mʋ̀ ga nə tɩ wá. Kʋ yɩ zinə tə mama pɩ̀ʋ́ tə nə pɩn wá dɩ̀àn, sə ʋ ma lɩ zinə tə lɩ̀à yuu wa». ");
INSERT INTO nnw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Zwezi dàń ma bon ba, ʋ swɩ̀n ba con də zwansɩsarɩ: «Nətə nə *Sɩtana wá wànɩ́ ʋ dɩŋa ʋ tətə? ");
INSERT INTO nnw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Á ywàŋá á jə́n: Payuu lɩ̀à nə zɩga duən nə, kʋ payuu tə tʋrɩ nə ga. ");
INSERT INTO nnw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dìə̀ tɩ̀án nə zɩga duən nə, kʋ tʋrɩ nə ga. ");
INSERT INTO nnw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kʋ mʋ̀ tə yɩrɩ, Sɩtana nə tɛ ʋ tɩ̀àn, ʋ lʋʋ tə nə pwɛ̀e, ʋ dɩ̀àn tə wàrɩ̀ lá tə yanɩ, tə wá zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lìù mama wàrɩ̀ ladɩa dìə̀ wa ʋ zwɩ ʋ ŋwɩ̀n ʋ wiən, də ʋ dɩ̀àn nə ba wá dwə, sə ʋ dí yáá ʋ vwa wá. Kʋ kwa nə, ʋ dàń wàá won mama ʋ tì ʋ dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Yɩɩ wá kwɛn ləzoni cʋna yiri mama, də ba tʋran yiri mama, ba nə twɩn ʋ mʋ̀ Yɩɩ, ʋ lɩ ʋ mʋ̀ də ba pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yá lìù tə mɛ, ʋ nə wá twɩn Yɩɩ-*Siŋu tə, Yɩɩ ba kʋ tíú cʋna kwɛn ʋ lɩ ʋ mʋ̀ də wá pwərə wa, mama. Kʋ cʋna təntə ba zwɛ̀e, abada». ");
INSERT INTO nnw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zwezi swɩ̀n ba con nətʋ, ba yà nə swɩ̀n də, zinə wulə ʋ yɩra tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kʋ kwa nə, Zwezi nubɩa də ʋ nuu twi, ba zɩga kàrá wa, ba ga tʋn lìù, sə ʋ bon wá. ");
INSERT INTO nnw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lalʋʋ yà jə ba kɩkarɩ Zwezi, yá ba ga swɩ̀n ʋ con, ba wʋ́: «Cʋgʋ zəni, n nuu də n nubɩa wulə kàrá wa, ba bwe n yoo». ");
INSERT INTO nnw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ʋ ma le, ʋ wʋ́: «Wàà nə yɩ à nuu, bə̀rə́ ga nə yɩ à nubɩa?» ");
INSERT INTO nnw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ʋ dàń ga ywàń lɩ̀à tə, ba nə jə ba kɩkarɩ wá, ʋ ga swɩ̀n, ʋ wʋ́: «Á ywàŋá, à nuu də à nubɩa nə ba wulə yəbə. ");
INSERT INTO nnw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kʋ yɩ lìù tə mɛ, ʋ nə zìlí Yɩɩ nii nə yɩ à nubiu, də à nakʋa, də à nuu». ");
INSERT INTO nnw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Dɩɩn don nə, Zwezi yà kʋ́ʋ̀ wulə ʋ kàrɩ̀ Galile mʋnaa tə nii nə. Lɩ̀à zənzən twi ba kɩkarɩ wá, kʋ pa ʋ zàn ʋ zʋ nɩ́á yuu bori wa ʋ jə̀ə́. Kʋ nɩ́á yuu bori tə yà zɩga mʋnaa tə wa bəbəru tə nii nə. Lɩ̀à tə mʋ̀ ga jə̀ə́ tɩa, buu tə bəbəru nə. ");
INSERT INTO nnw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Zwezi yà twá zwansɩsarɩ, ʋ ma bɩrɩ ba yìə̀n zənzən. Ʋ kàrà tə wa, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Á cʋga, wodùrú nan, sə ʋ dù. ");
INSERT INTO nnw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ʋ dàń nə wulə ʋ mɩ́ wodwii tə, kʋ vàn don tʋa cwəŋə yuu. Zənbii twi tə də́ tə. ");
INSERT INTO nnw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kʋ vàn don tʋa kapataʋ tɩa wa, tɩran nə ba dáá lá. Kʋ bwálɩ́ tə nə, wobɩa tə nan lala, kʋ nə yɩ tɩtalʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Máŋá tə, yɩɩ nə bɩga, kʋ dí wobii tə, tə ga tɩ tə kʋ̀, tə ŋʋnan nə wà tɩa zwɩ zəni yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wodwii tə vàn don tʋa casʋran tɩa wa. Tə nə pén máŋá tə nə, casʋran tə boru tə pú wobii tə yuu nə, tə dàń ga sɩ̀nɩ̀ tə tɩ. Tə wà won mama fwa. ");
INSERT INTO nnw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yá tə duən tʋa tɩa nəzəŋu wa, tə boru tə kwɛn, tə zɩn bɩa: Tə duən zɩn bɩa fɩtwa, tə duən sapwɩtwa, yá tə duən bíí». ");
INSERT INTO nnw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zwezi dàń ma swɩ̀n ʋ súrí lá, ʋ wʋ́: «Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni!» ");
INSERT INTO nnw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Máŋá tə, Zwezi yà nə ŋʋ́ná də lɩ̀à tə, ba tə, ba nə boli ʋ nii, də ʋ karbɩa fugə bələ tə lòrì, sə ʋ gwin zwansɩsara tə də̀ń ʋ bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ʋ ma le ba, ʋ wʋ́: «Á mʋ̀ wàá Yɩɩ pàrɩ̀ yìə̀n tə, tə nə sə̀gə̀ tə də̀ń á nì, á pɩn á tɩ̀àn nə. Yá lɩ̀à tə, ba nə ba à nə twá, tə mʋ̀ yɩ zwansɩsarɩ nə, ba wá twá ba ma nì yìə̀n tə mama. ");
INSERT INTO nnw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kʋ dàń wá pa, ba ywàń, ba ga ba na. Kʋ wá pa ba cʋgʋ, ba ga ba kʋ də̀ń nə̀ń. Ba yà nə nə̀ń kʋ də̀ń, ba yà wá lwàń ba pubʋŋa, ba ga va Yɩɩ con. Yá Yɩɩ yà wá kwɛn ba cʋna tə ʋ lɩ ba mʋ̀ də wá pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kʋ kwa nə, Zwezi swɩ̀n ʋ karbɩa tə con ʋ wʋ́: «Á yə̀rì zwansɩsara ka tə də̀ń? Nətə nə á dàń wá fwa á ma yəni tə duən tə mɛ? ");
INSERT INTO nnw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wodùrú tə nə dwì tə yɩ ndə lìù tə nə, ʋ nə swɩ̀n Yɩɩ sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ləzoni duən yɩ ndə cwəŋə tə nii nə, wodwii tə yàá nə tʋ kʋ wa. Ba nə zəzən ba nì Yɩɩ sʋgʋ tə, lala də *Sɩtana twi, ʋ lɩ kʋ ba waa. ");
INSERT INTO nnw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yá ba duən də yàá yɩ ndə kapataʋ tɩa nə, wodwii tə nə tʋa kʋ wa. Ba mʋ̀ yàá nə nì sʋgʋ tə, ba yàá sɛ̀e kʋ lala də pupoli. ");
INSERT INTO nnw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yá Yɩɩ sʋgʋ tə wà ba mʋ̀ lɩ̀à təntə pubʋŋa tə wa zwɩ zənzən, ba ga ba dɩ̀àn jə kʋ waa. Ba nə dí càn, də ba nə wʋwalɩ ba Yɩɩ sʋgʋ tə yɩrɩ, ba yàá pìí ba yá Yɩɩ cwəŋə. ");
INSERT INTO nnw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ba duən də yɩ ndə casʋran tɩa nə, wodwii tə nə tʋa lá. Ba yàá nì sʋgʋ tə, ");
INSERT INTO nnw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yá lʋʋ kʋ tə wiən twara jə ba zənzən. Ba swə ka pɩ̀à jɩjə. Lʋʋ wiən duən də fɩra jə ba. Tə wiən təntə mɛ yàá pú Yɩɩ sʋgʋ tə yuu nə, tə pa sʋgʋ tə kʋ́ʋ̀ wàrɩ̀ won kʋ fwa. ");
INSERT INTO nnw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ləzoni duən yɩ ndə tɩzəŋu nə, wodwii tə nə tʋa lá. Ba yàá nì sʋgʋ tə, ba sɛ̀e kʋ. Kʋ mʋ̀ nə pɩn, ba yɩ ndə wobɩa nə, tə nə zɩŋa bɩa. Ba duən zɩn bɩa fɩtwa, ba duən sapwɩtwa, yá ba duən bíí». ");
INSERT INTO nnw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kʋ kwa nə, Zwezi kʋ́ʋ̀ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Lìù tə̀lə́, ʋ nə wá sʋrʋ cànʋ́ ʋ tún garwa də̀ń nə, nə à yə̀ə́ gədoo də̀ń nə. Kʋ yɩ ʋ wá tún kʋ canzɩlʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Won tə mama nə sə̀gə̀ wá na, yá won tə mama yà nə wulə yikunu wa, wá nan poni nə». ");
INSERT INTO nnw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zwezi dàń ma swɩ̀n ʋ súrí lá, ʋ wʋ́: «Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni!» ");
INSERT INTO nnw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Zwezi kʋ́ʋ̀ swɩ̀n ba con, ʋ wʋ́: «Á cɩa á tɩ̀àn nə də kʋ tə, á nə nə̀ń. Yɩɩ wá pa aba kʋ tə, á də nə pɩn lɩ̀à duən nə. Yá ʋ ga wá pa aba, ʋ doni kʋ tə, á nə pɩn. ");
INSERT INTO nnw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ba wá pa lìù tə nə, ʋ nə jə ba súrú lá. Yá ʋ tə nə ba jə, ba wá jon mancɩn tə tətə, kʋ nə wulə ʋ con». ");
INSERT INTO nnw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á ywàŋá nətʋ tə, Yɩɩ nə də́ ʋ pàrɩ̀ tə. Kʋ yɩ ndə bɛɛ don nə dùə̀ ʋ kárá. ");
INSERT INTO nnw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kʋ kwa nə, ʋ pəni də ʋ zaŋa dɩɩn mama, yá kʋ máŋá tə wa, wobɩa tə pén, tə ga bori. Bɛɛ tə yə̀rì nətʋ tə, kʋ nə fwa. ");
INSERT INTO nnw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tɩa tə yàá pa wobɩa tə pén tə bori ka tətə nə. Sɩsɩʋ yàá də́ yáá kʋ nan. Kʋ kwa nə, kʋ yàá lʋra, kʋ ga kə bɩa. ");
INSERT INTO nnw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Máŋá tə, wobɩa tə nə bɩga, bɛɛ tə yàá zàn, ʋ za wiən tə də ʋ sɩ̀ʋ́. Kʋ nətʋ tə bɩrɩ də, wiən zagʋ máŋá yí». ");
INSERT INTO nnw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Bɛ̀eɛ̀e nə nə wàá nə ma maŋa Yɩɩ pàrɩ̀ tə? Bɛ̀eɛ̀e zwansɩsara nə nə wàá nə tì nə ma maŋa kʋ? ");
INSERT INTO nnw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kʋ yɩ ndə wobiu nəmanbiə nə, ba nə dùə̀. Kʋ mʋ̀ nə yɩ wobɩa tə mama nəmaa. Yá kʋ dwiu kwa nə, kʋ yàá pén. ");
INSERT INTO nnw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kʋ yàá boru, kʋ jì nədarʋ, kʋ doni dəvʋran mama. Kʋ nɛɛ tə yàá dara, zənbii tətə wàá tə pwalan tə kəni kʋ yuu wa». ");
INSERT INTO nnw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nətʋ nə Zwezi yà twá də zwansɩsarɩ zənzən, ndə tə tə nə, ʋ ma swɩ̀n Yɩɩ sʋgʋ tə ʋ bɩrɩ lɩ̀à tə nə. Ʋ yàá swɩ̀n Yɩɩ sʋgʋ tə ba con ndə nətʋ tə, ba nə wá wànɩ́ ba nì kʋ də̀ń. ");
INSERT INTO nnw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ʋ yàá ba swɩ̀n, də kʋ nə tà də zwansɩsarɩ. Yá ʋ dàń nə wulə də karbɩa tə cɩcɩ, ʋ yàá yá zwansɩsarɩ tə, ʋ ga gwin tə yìə̀n tə mama ʋ bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kʋ dɩɩn tə tətə nə kʋ dədəni nə, Zwezi swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Nə vələ mʋnaa tə vàn tə don nə!» ");
INSERT INTO nnw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ba dàń nan lalʋʋ tə wa. Ʋ karbɩa tə jɩn wá də nɩ́á yuu bori tə, ʋ nə wulə kʋ wa, ba ja vìí. Nɩ́á yuu bwərə duən yà bwələ də wá. ");
INSERT INTO nnw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kʋ kwa nə, vʋʋ nəfarʋ zàn, kʋ mà nɩ́á kʋ kəni nɩ́á yuu bori tə wa, kʋ pa kʋ swí. ");
INSERT INTO nnw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Zwezi yà tə́gə́ kʋ kwa con, ʋ dwɛ̀e ʋ ganpuri yuu wa. Ʋ karbɩa tə ma zɩ̀n wá, ba swɩ̀n ʋ con, ba wʋ́: «Karnyɩna, nə wá tɩ! Kʋ yoo ba mʋ́ jə?» ");
INSERT INTO nnw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zwezi ma zàn, ʋ baa vʋʋ tə nii nə, yá ʋ ga swɩ̀n mʋnaa nɩ́á tə con, ʋ wʋ́: «Pa n zəzugu tə nyʋ lá!» Kʋ máŋá tə wa, vʋʋ tə zɩgɩ. Yá bwálɩ́ tə mɛ zùrì siii. ");
INSERT INTO nnw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Zwezi dàń ga swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, fən jə aba nətʋ? Á ba á waa kəni à nə wuuu, naaa?» ");
INSERT INTO nnw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yá fən yà jə ba zənzən. Ba dàń swɩ̀n duən con, ba wʋ́: «Bɛɛ wà tə tà ndə lɩ̀à mɛ nə. Vʋʋ də mʋnaa mɛ zìlí ʋ nii!» ");
INSERT INTO nnw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kʋ kwa nə, Zwezi yí Galile mʋnaa tə vàn don nə, Zwerazenɩan-ba nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Ba nan nɩ́á yuu bori tə wa. Kʋ máŋá tə wa, bɛɛ don twi ʋ jə́rí Zwezi. *Zini yà jə kʋ bɛɛ təntə. Ʋ yɩ ʋ nan pɩ̀ràn bʋran wa. Ʋ yà wulə tə pɩ̀ràn bʋran tə wa, ba nə kʋa, ba ma kəni tɩga. Lìù yà tə̀lə́, ʋ nə wàá wá ʋ vwe də banzala tətə. ");
INSERT INTO nnw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kʋ nɛɛ ce duən, ba nə vwə ʋ nɛɛ də lugu ŋoni, ba vwə ʋ jɩ̀àn də banzala, yá ʋ kàrʋ́ banzala tə də lugu ŋoni tə. Lìù mama dɩ̀àn yà wà wá yí. ");
INSERT INTO nnw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Máŋá mama, tɩtɩn də yɩcaʋ, ʋ yàá jírí tɩga pɩ̀ràn bʋran ba tə wa də pɛɛn yuu wa. Ʋ mà nii də ʋ bɩ̀rɩ̀ ʋ yɩra ʋ kàrɩ́ də kapana. ");
INSERT INTO nnw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ʋ nɩ Zwezi yɩŋʋna, ʋ dàń ma dəri ʋ bà, ʋ tʋ ʋ yáá con. ");
INSERT INTO nnw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ʋ ga bubwi zənzən, ʋ kə yɩɩ nə, ʋ wʋ́: «Zwezi, Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, bìú, bɛ̀eɛ̀e nə n pɩ̀à à con nə? À lòrì mʋ́, sə n taa Yɩɩ yɩrɩ, dàn ká kə nə càn wa». ");
INSERT INTO nnw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Zwezi yà swɩ̀n ʋ con, ʋ wʋ́: «Zini, n nan bɛɛ tə yɩra!» ");
INSERT INTO nnw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zwezi dàń ma bwe, ʋ wʋ́: «N yɩrɩ nə ya bɛ̀eɛ̀e?» Kʋ ma le wá, kʋ wʋ́: «À yɩrɩ nə yɩ ‹buruburu›.» Kʋ yɩ cɩ́gá, zinə zənzən yà dáá bɛɛ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yá kʋ dàń lòrì pwəpwə, sə ʋ dàn ká dɩŋa tə, ʋ lɩ lʋʋ nii tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Twərən zənzən yà wulə kʋ bwálɩ́ tə nə paan yɩra, tə də́ wodirən. ");
INSERT INTO nnw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Zinə tə ma lòrì Zwezi, sə ʋ kə tə twərən tə yɩra. ");
INSERT INTO nnw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Zwezi ma pa tə cwəŋə. Zinə tə dàń ma nan bɛɛ tə yɩra, tə zʋ twərən tə. Tə yí mʋ̀rʋ̀ bələ. Tə mama mɩ́ámɩ́án nan paan tə yuu, tə tʋ mʋnaa tə wa, tə tɩ. ");
INSERT INTO nnw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Twərən nəcɩra tə dàń dəri, ba va ba swɩ̀n kʋ yoo tə tɩʋ tə də tɩbii tə wa. Lɩ̀à dàń zàn ba va ba ywàń kʋ tə, kʋ nə tʋn. ");
INSERT INTO nnw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba twi ba yí Zwezi də bɛɛ tə, ʋ yà nə jə zinə buruburu tə. Ʋ yà jə̀ə́, ʋ zʋ ganan, ʋ yɩ́á ga na tɩa. Fən zʋa ba. ");
INSERT INTO nnw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Twərən nəcɩra tə man kʋ tə mama, ba nə nɩ ba bɩrɩ lɩ̀à tə. Ba man kʋ tə nə yí bɛɛ tə, zinə tə yà nə jə, tə ma nan tə zʋ twərən tə. ");
INSERT INTO nnw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ba dàń ma lòrì Zwezi, sə ʋ nan ba nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zwezi nə pɩ̀à, sə ʋ zʋ nɩ́á yuu bori tə, bɛɛ tə, ʋ yà nə jə zinə zənzən, tə lòrì wá, sə ʋ yá ʋ pa ʋ twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yá Zwezi dàń vɩga, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Pìí, n va n dìə̀ n lɩ̀à con, n man kʋ tə mama, *Yuu-Tiu nə dəri n yinəgə zənzən ʋ ma fwa ʋ pa mʋ́». ");
INSERT INTO nnw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bɛɛ tə ma va nagwanaa tə wa, ba nə boŋə ‹Tɩan-Fugə› tə, ʋ man won tə mama, Zwezi nə tʋn ʋ pa wá. Kʋ gwárɩ́ lɩ̀à tə mama, ba nə cʋgʋ ʋ nii sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zwezi pìí ʋ va mʋnaa tə vàn tə don nə də nɩ́á yuu bori tə. Lalʋʋ twi, kʋ kɩkarɩ wá, də ʋ zɩga mʋnaa tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","*Zwifə-ba *jə́rə́ dìə̀ don yuu tíú twi ʋ con. Ʋ yɩrɩ nə yɩ Zwayirisə. Ʋ nə nɩ Zwezi, ʋ tʋa ʋ nɛɛ nə, ");
INSERT INTO nnw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ʋ ga lòrì pwəpwə, sə ʋ san ʋ nə. Ʋ swɩ̀n, ʋ wʋ́: «À bʋ̀á wulə ʋ tɩ». Ʋ dàń lòrì wá, ʋ wʋ́: «Bàá, n tún n jɩ̀àn ʋ yuu wa, sə n ma jon wá tɩan jɩɩn wa, sə ʋ mɩɩ ga ya lʋʋ». ");
INSERT INTO nnw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zwezi vəli də Zwayirisə. Lalʋʋ púə́ ʋ kwa də kʋ nɩŋɩ ʋ nɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Yá kan don yà wulə ba wa, ʋ tàŋá nə twi ka ba zɩga, kʋ nə yí bɩna fugə bələ. ");
INSERT INTO nnw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ʋ dí càn zənzən máŋá tə wa, ʋ nə ywarɩ ʋ tɩ̀àn dɩmʋtʋra zənzən con. Ʋ cʋ̀gʋ̀ wiən tə mɛ, ʋ nə jə, kʋ ga tə ba kʋkwa. Kʋ dàń yà kwɛn kʋ jə wá zənzən. ");
INSERT INTO nnw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ʋ nì Zwezi ŋwɛn. Ʋ dàń twi lalʋʋ tə wa, ʋ twá Zwezi kwa con, ʋ dwen ʋ gànʋ̀ nə. ");
INSERT INTO nnw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ʋ yà swɩ̀n, ʋ wʋ́: «À nə kən cɩ́gá, à dwen ʋ ganan tə cɩcɩ nə, à yayɩgʋ tə wá zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naa nədʋ, də ʋ jana tə lwagʋ tə zɩga, ʋ ga na ʋ tɩ̀àn, ʋ yayɩgʋ tə nə zwɛ̀e yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kʋ máŋá tə wa, Zwezi lwarɩ də dɩ̀àn nan ʋ yɩra. Ʋ dàń vəvəri lalʋʋ tə tətəŋi wa, ʋ bwe, ʋ wʋ́: «Wàà nə dwen à ganan nə?» ");
INSERT INTO nnw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ʋ karbɩa tə ma swɩ̀n ʋ con, ba wʋ́: «N na də, lalʋʋ tə wulə mʋ́ kʋ yugə tɩa tə mama, yá n ga bwe, də wàà nə dwen n yɩra». ");
INSERT INTO nnw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yá Zwezi yà wulə ʋ ywàŋá, sə ʋ lwarɩ lìù tə nə fwa kʋ nətʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fən zʋa kan tə, ʋ dàń ga vɩvaga, ʋ yà nə yə̀ə́ yoo tə nə yí wá yɩrɩ. Ʋ dàń ma bà ʋ tʋ Zwezi nɛɛ nə, ʋ swɩ̀n cɩ́gá mama ʋ con. ");
INSERT INTO nnw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Zwezi ma swɩ̀n, ʋ wʋ́: «À nakʋa, n nə ken n waa à nə tə yɩrɩ, Yɩɩ jon mʋ́. Vəli də bɩcan sìə́, n yayɩgʋ tə zwɛ̀e mɩ́ámɩ́án». ");
INSERT INTO nnw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Zwezi nə wulə ʋ swɩ̀n nətʋ tə, də lɩ̀à nan jə́rə́ dìə̀ yuu tíú tə sàń, ba bà ba swɩ̀n ʋ con, ba wʋ́: «N bʋ̀á tə mɩɩ zwɛ̀e. N kʋ́ʋ̀ wà mɛ, sə n wʋwalɩ karnyɩna tʋtʋ». ");
INSERT INTO nnw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yá Zwezi wà sʋ̀ràn təntə con tan, ʋ swɩ̀n jə́rə́ dìə̀ yuu tíú tə con, ʋ wʋ́: «Dàn ká pa fən ja mʋ́, kə n waa cɩcɩ à nə». ");
INSERT INTO nnw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ʋ wà yá ʋ pa lìù mama kwé ba, də kʋ nə tà Piyɛrə, də Zwakə, də ʋ nyánʋ́ Zwan. ");
INSERT INTO nnw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba nə yí jə́rə́ dìə̀ yuu tíú tə sàń, Zwezi nɩ lɩ̀à tə, ba yà wulə ba fwa zəzugu, ba kwi, də ba mà nii. ");
INSERT INTO nnw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ʋ zʋa dìə̀ tə wa, ʋ swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e yɩrɩ nə á fwa zəzugu nətən, yá á ga kwi? Bisɩmaa tə wà tɩ, ʋ yɩ ʋ dwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba dàń wulə ba mʋŋa wá. Ʋ ma pa ba mama nan, ʋ ga yá bʋ̀á tə nuu də ʋ nyɩna, də ba tə, ba yà nə yɩn də wá. Ʋ dàń zʋa bwálɩ́ tə, bisɩmaa tə nə wulə. ");
INSERT INTO nnw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ʋ jɩn bʋ̀á tə jɩɩn nə, ʋ ga swɩ̀n ʋ con də ʋ lʋʋ sʋgʋ, ʋ wʋ́: «Talɩta kumi!» - Kʋ də̀ń nə yɩ: Bisɩmakana, à mʋ̀ nə swɩ̀n kʋ n con: Zàn yɩɩ nə! ");
INSERT INTO nnw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bisɩmakana tə zəzən ʋ nyɩ́ ʋ zàn ʋ vəli. Ʋ yà jə bɩna fugə bələ. Ba nə nɩ kʋ nətʋ tə, kʋ gwárɩ́ ba mama, kʋ nə dɩ̀gà ba yuu zənzən yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yá Zwezi dàń dùə̀ súú ba nii nə, də ba dàn ká pa, sə lìù mama lwarɩ kʋ. Kʋ kwa nə, ʋ swɩ̀n ba con, ʋ wʋ́: «Á pɩan wodiu bʋ̀á tə nə, sə ʋ də́!» ");
INSERT INTO nnw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Zwezi nan kʋ mʋ̀ bwálɩ́ tə nə, ʋ va ʋ nyɩna sàń. Ʋ karbɩa yà kwé wá. ");
INSERT INTO nnw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*Zwifə-ba *sìə́ dɩɩn nə, ʋ yà wulə ʋ kàrɩ̀ Zwifə-ba *jə́rə́ dìə̀ wa. Lɩ̀à zənzən yà nə cʋga wá, kʋ gwárɩ́ ba, yá ba ga swɩ̀n, ba wʋ́: «Yə̀n nə ʋ yə̀ə́ yìə̀n tətə mama? Bɛ̀eɛ̀e nə yɩ wʋbʋŋa kʋ tə, ʋ nə jə, də yomɩlan tə tə mɛ, ʋ nə tʋŋa? ");
INSERT INTO nnw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kʋ tà ʋ mʋ̀ nə yɩ kapənta tə, ʋ nə yɩ Mari bìú tə naaa? Kʋ tà ʋ mʋ̀ nə yɩ Zwakə də Zwoze də Zwidə də Simon zʋnʋ tə naaa? Ʋ nakwana tə tə̀lə́ nə wa yəbə naaa?» Yá kʋ nətʋ dàń pɩn, ba yà ba wá sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Ba yàá zìlí Yɩɩ nii *sʋ̀sʋ̀nʋ̀ bwálɩ́ mama nə, yá ʋ nyɩna sàń nə də ʋ dwíí tɩ̀án wa, də ʋ dìə̀ wa, ba ba wá zìlí». ");
INSERT INTO nnw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Zwezi wà wànɩ́ ʋ fwa yomɩlan duən lá, də kʋ nə tà, ʋ nə tún ʋ jɩ̀àn yayɩŋa mancɩn yuu wa, ʋ ma zwɛ̀e ba yayɩran. ");
INSERT INTO nnw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ba yà nə wà Yɩɩ *nii sɛ̀e, tə gwárɩ́ wá. Kʋ kwa nə, Zwezi jírú ʋ kàrɩ̀ bwálɩ́ təntə tɩan tə mama wa. ");
INSERT INTO nnw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ʋ dàń ma bon ʋ karbɩa fugə bələ tə, ʋ tʋn ba bələ bələ. Ʋ pɩn ba dɩ̀àn, sə ba lɩ *zinə lɩ̀à yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ʋ pɩn ba nii, ʋ wʋ́: «Á dànà ká tì won mama á kə á yuu. Á dànà ká ja wodiu də lɔ̀ɔ̀ də səbiu á ganjɩgɩ wa, á ja nan cwəŋə. Á tiə daduu, á kənə natʋra, á nə dànà ká zʋ ganan bələ». ");
INSERT INTO nnw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ʋ swɩ̀n ba con, ʋ wʋ́: «Máŋá tə, á nə yí tɩʋ wa, sə á mé dìə̀ tə wa, á nə zʋa, kʋ jə vəli á nə wá nan kʋ mʋ̀ tɩʋ təntə wa. ");
INSERT INTO nnw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tɩʋ don lɩ̀à nə vɩga, sə ba ja aba, nə à yə̀ə́, sə ba cʋgʋ aba, á naŋa lá. Á zwara á nɛɛ purən, sə kʋ ya ba yuu yoo». ");
INSERT INTO nnw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ʋ karbɩa tə dàń ma va ba kàrɩ̀ lɩ̀à, ba wʋ́, ba mɛ, sə ba bà Yɩɩ con, sə ba vəvəri ba kwa, ba ma sá ba cʋna. ");
INSERT INTO nnw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba dɩŋɩ zinə zənzən ba lɩ, ba zwɛ̀e yayɩŋa zənzən yayɩran də ba kəni nʋga ba yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Zwezi ŋwɛn súə́ bwálɩ́ mama, yá pɩ̀ʋ́ *Erodə də dàń yà nì ʋ yoo. Lɩ̀à duən yà swɩ̀n də, Zwezi tətə nə yɩ *Zwan-Batisə ʋ nə pìí ʋ bwin, ʋ nan tɩan wa. Mə kʋ mʋ̀ nə pɩn, ʋ jə dɩ̀àn, ʋ ma tʋŋa yomɩlan. ");
INSERT INTO nnw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yá ba duən də yà wʋ́, ʋ yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli. Ba duən də wʋ́, ʋ yɩ fuən Yɩɩ nii sʋ̀sʋ̀nà tə wa lìù don. ");
INSERT INTO nnw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erodə nì kʋ, ʋ ga swɩ̀n, ʋ wʋ́: «Kʋ yɩ Zwan nə! À pɩn ba gwəŋə ʋ yuu, yá ʋ pìí ʋ bwin». ");
INSERT INTO nnw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kʋ yɩ cɩ́gá, Erodə tətə yà nə pɩn ba ja Zwan, ba vwa, ba kə bàń dìə̀ wa. Erodə yà fwa nətʋ, ʋ zʋnʋ Filipə kan Erodɩadə yɩrɩ, ʋ nə jon. ");
INSERT INTO nnw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Zwan yà ma swɩ̀n, ʋ wʋ́: «Kʋ wà mɛ, sə n jon n zʋnʋ kan». ");
INSERT INTO nnw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kʋ yɩrɩ nə Erodɩadə lɩŋa yà zaŋa zənzən Zwan yuu wa, ʋ yà ga jə kʋ ʋ bɩcan wa. Ʋ yà pɩ̀à cwəŋə, sə ʋ ma gʋ Zwan. Yá ʋ yà wàrɩ̀. ");
INSERT INTO nnw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erodə yà dəri Zwan, ʋ yà nə yə̀ə́ də, ʋ yɩ cɩ́gá tíú, ʋ ga yɩ Yɩɩ nə tɩ tə yɩrɩ. Ʋ dàń ma cɩ̀ ʋ nə. Ʋ yàá nə cʋga ʋ sʋ̀ràn tə, kʋ yàá gwárɩ́ wá, yá ʋ yàá cʋgʋ wá də puswənə. ");
INSERT INTO nnw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erodə lʋrɩ dɩɩn cànà nə twi kʋ yí, kʋ yɩn yuywaŋʋ kʋ pa Erodɩadə nə. Erodə dàń zàn ʋ fwa wodirən zənzən, ʋ pa ləzwənfaran tə nə, də pamana yun tɩ̀án tə nə, də Galile nagwanaa yáá tɩ̀án tə nə. ");
INSERT INTO nnw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erodɩadə bʋ̀á zʋa ʋ sa. Ʋ sɩʋ tə yɩn ywánɩ́ kʋ pa Erodə də ʋ candərə tə nə. Pɩ̀ʋ́ Erodə dàń ma swɩ̀n bʋ̀á tə con, ʋ wʋ́: «Lòrì won tə mama, n nə pɩ̀à, à wá pa kʋ mʋ́». ");
INSERT INTO nnw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ʋ dàń ga wʋ́, ʋ dùə̀: «À wá pa mʋ́ won tə mama, n nə pɩ̀à, kʋ nə swə kʋ yɩ à lʋʋ tə fan də». ");
INSERT INTO nnw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bʋ̀á tə dàń ma nan, ʋ bwe ʋ nuu: «Bɛ̀eɛ̀e nə à mɛ, sə à lòrì?» Ʋ nuu ma wʋ́: «Swɩ̀n ndə Zwan-Batisə yuu nə n pɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bʋ̀á tə ma dəri ʋ va ʋ swɩ̀n pɩ̀ʋ́ tə con, ʋ wʋ́: «À pɩ̀à, sə n gwəŋə Zwan-Batisə yuu tə sɩ́ʋ́n sɩ́ʋ́n n kə zʋŋa wa n pa nə». ");
INSERT INTO nnw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pɩ̀ʋ́ pùə́ cʋ̀gʋ̀, yá ʋ yà ba pɩ̀à, sə ʋ vɩ, ʋ nə dùə̀ ʋ candərə tə yáá con tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ʋ dàń ma zəzən ʋ tʋn pamanʋ don, sə ʋ va ʋ gwəŋə Zwan yuu ʋ ja bà. Pamanʋ tə nan ʋ va bàń dìə̀ tə wa, ʋ gwəŋə Zwan yuu. ");
INSERT INTO nnw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ʋ tì kʋ ʋ kə zʋŋa wa, ʋ ja bà ʋ pa bʋ̀á tə nə. Bʋ̀á tə ja nan ʋ pa ʋ nuu nə. ");
INSERT INTO nnw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Máŋá tə Zwan karbɩa tə nə nì kʋ, ba twi, ba tì ʋ tɩgɩ tə ba gùrì. ");
INSERT INTO nnw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zwezi *tʋntʋna tə pìí ba bà ʋ con. Ba man ba bɩrʋ wá won tə mama, ba nə fwa, də ba nə kàrɩ̀ lɩ̀à tə nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lɩ̀à tə nə twi, də ba pìí ba vìrí, tə yà dáá zənzən, kʋ pa ba wàrɩ̀ wodiu ba jəni ba də́. Kʋ mʋ̀ nə pɩn, ʋ ma swɩ̀n ba con, ʋ wʋ́: «Á twaga à nə, sə nə nan kwa con bwálɩ́ tə nə, lìù nə tə̀lə́, sə á wànɩ́ á sìí mancɩn». ");
INSERT INTO nnw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ba dàń zàn ba tì nɩ́á yuu bori tə, ba va bwálɩ́ tə, lɩ̀à nə ba bwələ. ");
INSERT INTO nnw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yá lɩ̀à zənzən nɩ ba, ba ga lwarɩ ba. Ba nan tɩan tə mama, ba va bwálɩ́ tə nə də nɛɛ, də Zwezi də ʋ karbɩa tə tə wà lá yí. ");
INSERT INTO nnw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zwezi də ʋ karbɩa tə nə nan nɩ́á yuu bori tə wa máŋá tə, ʋ nɩ lɩ̀à tə mama, ba yinəgə jɩn wá, ba yà nə yɩ ndə pee nə, tə nə ba payɩrʋ jə yɩrɩ. Ʋ dàń ma zàn ʋ kàrɩ̀ ba yìə̀n zənzən. ");
INSERT INTO nnw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Máŋá tə wa, tɩa nə ja kʋ yí, Zwezi karbɩa tə fàrɩ́ ba yí, ba swɩ̀n ʋ con, ba wʋ́: «Tɩa yí, yá won mama tə̀lə́ bwálɩ́ kʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pa, sə lɩ̀à tə pìí ba va tɩʋ tə wa də tɩbii tə wa, ba yə̀ wodiu». ");
INSERT INTO nnw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Zwezi ma le ba, ʋ wʋ́: «Á tətə pɩan ba wodiu, sə ba də́!» Ba dàń ma swɩ̀n ʋ con, ba wʋ́: «Nə ba səbiu zənzən jə, sə nə ma yə̀ wodiu nə pa lɩ̀à ba tə nə». ");
INSERT INTO nnw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Zwezi dàń ma bwe ba, ʋ wʋ́: «Dipɛn bagalɩ nə wulə á con? Vələ á jə́n!» Ba nə ywàń tə kwa nə, ba twi ba swɩ̀n ʋ con, ba wʋ́: «Nə jə dipɛn bonu də fələ bələ». ");
INSERT INTO nnw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kʋ kwa nə, Zwezi pɩn nii ʋ karbɩa tə nə, ʋ wʋ́: «Á pɩan lɩ̀à tə jə̀ń púlə́ púlə́ galɩʋ tə yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ba dàń ma pa ba jə̀ń tɩa, bíí bíí, də finu finu. ");
INSERT INTO nnw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kʋ kwa nə, Zwezi tì dipɛn bonu tə də fələ bələ tə, ʋ zɩ̀n ʋ yáá yɩɩ nə, ʋ kə Yɩɩ lɛ̀eɛ̀e. Ʋ fʋ fʋ dipɛn tə ʋ pa karbɩa tə nə, sə ba ma tara lalʋʋ tə. Ʋ tàrɩ̀ fələ bələ tə, də ʋ pa ba mɛ nə. ");
INSERT INTO nnw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ba lìù mama dí ʋ sú. ");
INSERT INTO nnw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ba pɛ̀e dipɛn tə də fələ tə mumunə, tə nə súə́ fɩyaran fugə bələ. ");
INSERT INTO nnw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bara yɩ mʋ̀rʋ̀ bonu ba wa, ba nə dí wodiu tə. ");
INSERT INTO nnw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kʋ kwa nə, Zwezi zəzən ʋ pa ʋ karbɩa tə zʋ nɩ́á yuu bori tə wa, sə ba də́ yáá, ba galʋ mʋnaa tə vàn don nə Bɛtəsayɩda tɩʋ con. Ʋ mʋ̀ tətə dàń wá kə lɩ̀à tə cwəŋə nə. ");
INSERT INTO nnw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ʋ nə pɩn ba vìí tə máŋá wa, ʋ dɩ̀gà paan don yuu wa, sə ʋ jʋn Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tɩa yí máŋá tə nə, nɩ́á yuu bori tə də karbɩa tə yà wulə mʋnaa tə tətəŋi wa, yá Zwezi cɩcɩ ga wulə tɩa. ");
INSERT INTO nnw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ʋ nɩ də, ʋ karbɩa tə na càn də nɩ́á yuu bori tə ka va, vʋʋ yà nə fuli kʋ naŋa bwálɩ́ tə, ba nə vələ tə yɩrɩ. Tɩbɩlakʋnʋ nii nə, ʋ zàn ʋ wulə nɩ́á tə yuu wa ba səpuni nə, ʋ vəli mancɩn mancɩn. ");
INSERT INTO nnw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yá máŋá tə nə, karbɩa tə nə nɩ wá də, ʋ vəli nɩ́á tə yuu wa, ba bʋ́n də, kʋ yɩ wojijiru. Ba dàń ma mà nii, ");
INSERT INTO nnw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","fən yà nə zʋa ba zənzən yɩrɩ. Zwezi ma ʋ swɩ̀n ba con lala, ʋ wʋ́: «Á dàŋá á jɩ̀àn! Kʋ yɩ à mʋ̀ nə! Á dànà ká pa fən ja aba!» ");
INSERT INTO nnw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kʋ kwa nə, ʋ dàń zʋa nɩ́á yuu bori tə wa, ba səpuni nə, yá vʋʋ tə ga zɩgɩ. Kʋ gwárɩ́ ʋ karbɩa tə zənzən. ");
INSERT INTO nnw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ba nə nɩ Zwezi də, ʋ fʋa dipɛn tə, ba yà tə wà ʋ dɩ̀àn tə də̀ń lwarɩ. Ba pubʋŋɩ yà wà yí. ");
INSERT INTO nnw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zwezi də ʋ karbɩa tə galɩ mʋnaa tə ba zwɛ̀e, ba cú tɩa Zwenezarɛtə nagwanaa wa. Lantə nə, ba zɩgɩ ba nɩ́á yuu bori tə. ");
INSERT INTO nnw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba nə cúə́, də lɩ̀à tə zəzən ba lwarɩ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bwálɩ́ tə mama lɩ̀à nə nì də, Zwezi wulə lɩ̀à tə yàá nan nagwanaa tə mama, ba janɩ yayɩŋa ba ja twi ba tɩtaran yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bwálɩ́ tə mama Zwezi nə vəli, kʋ yɩ tɩan wooo, tɩfaran wooo, tɩbii wooo, lɩ̀à yàá ja ba yayɩŋa, ba va ba tún jə́rə́ bwálá nə. Ba yàá lòrì wá, sə ʋ yá ʋ pa ba dwen ʋ gànʋ̀ nii nə. Lìù tə mama yàá nə dwen ʋ gànʋ̀ tə nii nə, kʋ tíú yayɩgʋ yàá zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Farɩzɩan-ba də Yɩɩ nii *yənu tɩ̀án duən nə nan *Zwerizalɛmə ba bà. Ba twi ba kɩkarɩ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba mɩ̀nɩ̀ də, Zwezi karbɩa tə duən yàá də́ wodiu də ba jɩdurən. Kʋ də̀ń nə yɩ, ba wà ba jɩ̀àn sɩn ndə nətʋ tə nə, kʋ nə mɛ. ");
INSERT INTO nnw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farɩzɩan-ba də *Zwifə-ba tə duən mɛ yà twá yofwamɩnan tə nə, ba nyɩna-ba nə yá ba pa ba. Ba yà ba də́, də ba nə wà ba jɩ̀àn sɩn zəni. ");
INSERT INTO nnw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ba nə nan jə́rə́ bwálɩ́ də ba bà, ba yàá də́ yáá ba sɩn ba jɩ̀àn, ba dàń ga də́. Ba twá dí yáá nə zənzən, sə ba də Yɩɩ yìə̀n ma kwɛn duən nə, ndə ka sɩn wùrú zwɩɩn, də lugu zwɩɩn, də nəkəni nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farɩzɩan-ba də Yɩɩ nii yənu tɩ̀án tə dàń ma bwe Zwezi, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn n karbɩa tə ba nyɩna-ba yofwamɩnan tə nə twá? Ba də́ wodiu də jɩ̀àn, tə nə wà sɩn». ");
INSERT INTO nnw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Zwezi ma le ba, ʋ wʋ́: «Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi yà jə cɩ́gá, də ʋ nə dí yáá ʋ swɩ̀n á mʋ̀ níə́ bələ tɩ̀án tə yoo, ndə kʋ yà nə pʋ́pʋ́nɩ́ nətən: ‹Lɩ̀à-ba tə yɩ ba zìlí à mʋ̀ Yɩɩ də ba nii cɩcɩ, yá ba waa ga ŋʋ́ná də nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ba yɩjʋnɩ tə yɩ tʋtʋ, kʋ tə, ba nə kàrɩ̀ ba bɩrɩ nə yɩ ləzoni kàrà, də ba yofwamɩnan tə yɩrɩ›.» ");
INSERT INTO nnw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Zwezi swɩ̀n ba con, ʋ wʋ́: «Á yá Yɩɩ bɩra tə kwa, á ga twá ləzoni yofwamɩnan nə». ");
INSERT INTO nnw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Zwezi dàń ga súrí lá, ʋ wʋ́: «Á vɩga Yɩɩ bɩra tə mwálɩ́ mwálɩ́, sə á ga twá á tətə yofwamɩnan nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, cɩ́gá swɩ̀n, kʋ wʋ́: ‹Zìlí n nuu də n nyɩna! Yá lìù tə, ʋ nə zɩrɩ ʋ kə ʋ nuu də ʋ nyɩna nə, ʋ mɛ, sə ba gʋ wá›. ");
INSERT INTO nnw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Yá á mʋ̀ bɩrɩ də, lìù wàá ʋ swɩ̀n ʋ nuu də ʋ nyɩna con, ʋ wʋ́: ‹N tori tə, à yà nə wá ma san mʋ́ tə yɩ à tún, sə kʋ yɩ *joŋi kʋ pa Yɩɩ nə›. Kʋ də̀ń nə yɩ ‹kɔrəban› də Zwifə-ba sʋgʋ. Yá á dàń pɩn cwəŋə lìù nə, sə ʋ dàn ká kʋ́ʋ̀ san ʋ nuu də ʋ nyɩna nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mə á yofwamɩnan tə, á nə kàrɩ̀ lɩ̀à tə nə nə, á twá á ma lɩ Yɩɩ sʋgʋ tə nywarɩ. Á fwa yìə̀n duən zənzən tə nə nyɩn ndə tə nə». ");
INSERT INTO nnw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zwezi ma kʋ́ʋ̀ bon lɩ̀à tə, ʋ swɩ̀n ba con, ʋ wʋ́: «Á mama cʋga, á ga nì kʋ tə də̀ń. ");
INSERT INTO nnw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Won tə mama nə naŋa kàrá con, kʋ zwɩ ləzwənə wa, wàrɩ̀ wá kʋ cʋ̀gà. Won tə nə naŋa ləzwənə waa, kʋ mʋ̀ won tə nə wàá wá kʋ cʋ̀gà». ");
INSERT INTO nnw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni! ");
INSERT INTO nnw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Máŋá tə, Zwezi nə nan lɩ̀à tə wa ʋ zʋ dìə̀, ʋ karbɩa tə bwe wá kʋ zwansɩsara təntə də̀ń nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ʋ dàń ma swɩ̀n, ʋ wʋ́: «Á də tə yɩ lɩ̀à tə, á nə wàrɩ̀ yoo də̀ń á nì? Á ba nə̀ń də, won tə nə twá nii kʋ zʋ lìù waa wàrɩ̀ wá kʋ cʋ̀gà? ");
INSERT INTO nnw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Á yə̀rì də, wodiu tə ba ʋ pubʋŋa tə wa zwɩ. Kʋ yɩ ʋ pùə́ wa nə kʋ zwɩ, yá kʋ kwa nə, ʋ yàá twa kʋ ʋ dʋgʋ kaduəyuu bwálɩ́ nə». Tə mʋ̀ sʋ̀ràn tə nə nə Zwezi twá ʋ ma swɩ̀n də, wodiu tə̀lə́, kʋ nə jə durən Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yá ʋ ga kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Won tə, kʋ nə naŋa ləzwənə yɩra nə pɩn ʋ bɩcan yɩ nəzonu Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lìù waa con nə pubʋŋɩ kʋkwɩnan yàá nan, tə pɩn ʋ cwàrɩ̀, ʋ ŋwɩ̀n, ʋ gwɩ, ");
INSERT INTO nnw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ʋ pɩ̀à lɩ̀à kana, lɩ̀à duən wiən jə yimən tə pa wá, ʋ tʋŋa wʋlʋŋʋ, ʋ gɩgarɩ lɩ̀à, ʋ kʋkʋlɩ Yɩɩ yɩrɩ tə, ʋ yii zwɩ lɩ̀à wiən, ʋ cəgə lɩ̀à, ʋ fwa fwiə, ʋ ga yə̀rì ʋ yáá. ");
INSERT INTO nnw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tə mʋ̀ yokʋkwɩnan tə mama yɩ ləzwənə waa nə tə naŋa, yá tə ga pɩn ʋ bɩcan yɩ nəzonu Yɩɩ yáá con». ");
INSERT INTO nnw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kʋ kwa nə, Zwezi kɛ̀eń lá, ʋ va nagwanaa don wa, Tirə tɩʋ tə nə wulə lá. Ʋ zʋa dìə̀ don wa, yá ʋ ga ba pɩ̀à, sə lìù lwarɩ ʋ nii nə, yá ʋ dàń nə wà wànɩ́ ʋ cɩ̀, sə ba dàn ká nì ʋ ŋwɛn. ");
INSERT INTO nnw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kan don yà nì Zwezi yoo. Ʋ yà jə bʋ̀á, *zini yà wulə kʋ bʋ̀á təntə yuu wa. Ʋ dàń ma zàn ʋ bà ʋ tʋ Zwezi nɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kan tə yà yɩ *Gərɛkə. Ba lʋrɩ wá Fenisi nagwanaa wa, Siri nə tɩ lá. Ʋ lòrì Zwezi, sə ʋ dɩŋɩ zini tə ʋ lɩ ʋ bʋ̀á tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yá Zwezi swɩ̀n kan tə con, ʋ wʋ́: «Də́ yáá n yá n pa dìə̀ lɩ̀à də ba sú, ka tì bìsɩ́ná wodiu ka dɩlɩ kukurbii yáá, nə ba ziən yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ʋ ma le wá, ʋ wʋ́: «Karnyɩna, kʋ yɩ cɩ́gá! Yá kukuri tə yàá də́ wodimumunə tə, bìsɩ́ná tə nə yá ba pɩn tə twɩ tɩa nə». ");
INSERT INTO nnw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «N nə le nə nətʋ tə yɩrɩ, n wàá n pìí n vìrí, zini tə nan n bʋ̀á tə yɩra». ");
INSERT INTO nnw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ʋ pìí ʋ va ʋ sàń, ʋ na ʋ bisɩmaa tə də ʋ tə́gə́ gədoo yuu wa. Zini tə ga nan ʋ yɩra. ");
INSERT INTO nnw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zwezi nan nagwanaa tə wa, Tirə tɩʋ nə wulə lá, ʋ twá Sidon tɩʋ. Ʋ zɩgɩ lá ʋ va ʋ twá Tɩan-Fugə nagwanaa tə wa, ʋ va Galile mʋnaa tə vàn nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ba jɩn bɛɛ don ʋ zɩan nə bwɩn, ʋ ga bəbe ba ja va ʋ con. Ba lòrì Zwezi, sə ʋ tún ʋ jɩɩn bɛɛ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zwezi ma ja ʋ cɩcɩ ʋ ja nan lɩ̀à tə wa, ʋ va yɩŋʋna. Ʋ tì ʋ jɩfwɩ ʋ tɩrɩ bɛɛ tə zɩan wa. Ʋ lɩ mɩmɩan, ʋ ma dwen bɛɛ tə nəndəli nə. ");
INSERT INTO nnw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ʋ zɩ̀n ʋ yáá yɩɩ nə, ʋ sìí fʋʋn, ʋ ga swɩ̀n də ʋ lʋʋ sʋgʋ, ʋ wʋ́: «Efata!» - Kʋ də̀ń nə yɩ: ‹Súrí n tɩ̀àn.› ");
INSERT INTO nnw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Naa nədʋ də bɛɛ tə zɩan tə súrí, ʋ nəndəli kòlù, ʋ ga swɩ̀n zəni. ");
INSERT INTO nnw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zwezi ma swɩ̀n lɩ̀à tə mama con də, ba dàn ká man kʋ, ba bɩrɩ lìù nə. Yá ba tə zəzəgi kʋ, ba pa kʋ nan kàrá wa. ");
INSERT INTO nnw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kʋ dàń ga gwárɩ́ lɩ̀à zəni. Ba dàń yàá swɩ̀n, ba wʋ́: «Won tə mama, ʋ nə fwa ziən zəni. Ʋ pɩn zɩbʋŋa nə̀ń, bərən ga swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kʋ máŋá tə wa, lɩ̀à zənzən yà kʋ́ʋ̀ kun duən nə, ba yà ga ba won mama jə, sə ba də́. Zwezi dàń bon ʋ karbɩa tə, ʋ swɩ̀n ba con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Lalʋʋ tə yinəgə jə nə, nə ba nə wulə də nə dɩan batwa nətən, yá ba ga ba won jə, ba də́ tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","À nə pɩn ba vìí də niən, ba dɩ̀àn wá zwɛ̀e, ba nan ba tʋ cwəŋə yuu, ba wa lɩ̀à duən nə nan yɩŋʋna yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ʋ karbɩa tə ma le wá, ba wʋ́: «Nə wàrɩ̀ ba dipɛn nə pɩn, ba də́ ba swí, bwálɩ́ kʋ tə wa, won mama nə tə̀lə́». ");
INSERT INTO nnw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zwezi ma bwe ba, ʋ wʋ́: «Dipɛn bagalɩ nə á jə?» Ba ma le, ba wʋ́: «Dipɛn barpɛ». ");
INSERT INTO nnw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ʋ dàń ma pa nii lalʋʋ tə nə, sə ba jə̀ń tɩa. Ʋ dàń ga tì dipɛn barpɛ tə, ʋ kə Yɩɩ lɛ̀eɛ̀e, ʋ fʋ fʋ tə, ʋ pa ʋ karbɩa tə nə, ba ma tara lɩ̀à tə. ");
INSERT INTO nnw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ba yà tə jə fəlibii də. Zwezi ken Yɩɩ lɛ̀eɛ̀e fələ tə yɩrɩ, ʋ ga swɩ̀n ʋ karbɩa tə con, sə ba tàrà tə ba pa lɩ̀à tə nə. ");
INSERT INTO nnw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ba lìù mama dí ʋ sú. Karbɩa tə ga pɛ̀e tə mumunə, tə nə ga, ba sú tìí barpɛ. ");
INSERT INTO nnw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yá ba yà ga yí lɩ̀à mʋ̀rʋ̀ banɩa. Zwezi dàń pɩn ba vìí. ");
INSERT INTO nnw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kʋ kwa nə, Zwezi də ʋ karbɩa tə zəzən ba zʋ nɩ́á yuu bori tə, ba va Daləmanʋta nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","*Farɩzɩan-ba tə twi, ba wulə ba swɩ̀n də Zwezi. Ba pɩ̀à, sə ba ja ʋ də̀ń nə. Ba lòrì wá, sə ʋ tʋn yomɩlʋ don ʋ ma bɩrɩ ba də, ʋ dɩ̀àn tə yɩ tə nan Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zwezi sìí fʋʋn ʋ kə ʋ waa, ʋ ga swɩ̀n, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn zə̀n lɩ̀à ma pɩ̀à, sə à fwa Yɩɩ dɩ̀àn mɩmɩnʋ à bɩrɩ ba? Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: À bá fwa Yɩɩ dɩ̀àn mɩmɩnʋ mama à bɩrɩ ba». ");
INSERT INTO nnw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Zwezi dàń kɛ̀eń ʋ ga yá ba, ʋ pìí ʋ zʋ nɩ́á yuu bori tə wa, ʋ va mʋnaa tə vàn don nə. ");
INSERT INTO nnw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ʋ karbɩa tə yà swɛ̀eé, sə ba tì wodiu. Ba yà jə dipɛn nədʋ cɩcɩ nɩ́á yuu bori tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Á zurə á yɩra, á cɩa á tɩ̀àn nə zəni də *Farɩzɩan-ba sabwarɩ tə. Á cɩa á tɩ̀àn nə də *Erodə sabwarɩ tə». ");
INSERT INTO nnw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ʋ karbɩa tə ma swɩ̀n ba pwərə wa, ba wʋ́: «Kʋ yɩ nə nə ba dipɛn jə, tə nə pɩn ʋ ma swɩ̀n nətʋ». ");
INSERT INTO nnw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Zwezi lwarʋ kʋ tə, ba nə wʋ́, ʋ dàń ma bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn á ma wʋ́: ‹Kʋ yɩ nə nə ba dipɛn jə tə yɩrɩ nə›? Á tə wà lwarʋ! Á tə wà kʋ də̀ń nì! Á pubʋŋa wà yí! ");
INSERT INTO nnw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Á jə yɩ́á, tə ba lá na! Á jə zɩan tə ba nə̀ń! Á tə wà lìí! ");
INSERT INTO nnw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Máŋá tə wa, à nə fʋa dipɛn bonu tə à pa bara mʋ̀rʋ̀ bonu tə nə, á pɛ̀e tə mumunə á sú fɩyaran bagalɩ?» Ʋ karbɩa tə le, ba wʋ́: «Fɩyaran fugə bələ». ");
INSERT INTO nnw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Sə máŋá tə wa, à nə fʋa dipɛn barpɛ tə à pa lɩ̀à mʋ̀rʋ̀ banɩa tə nə, dipɛn mumunə tìí bagalɩ nə á tì?» Ba le wá, ba wʋ́: «Tìí barpɛ». ");
INSERT INTO nnw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Yá á ga tə ba nə̀ń?» ");
INSERT INTO nnw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zwezi də ʋ karbɩa tə dàń vəli ba yí Bɛtəsayɩda tɩʋ. Lantə nə, lɩ̀à jɩn liliu don, ba ja bà Zwezi con, ba lòrì wá, sə ʋ dwen ʋ yɩra, sə ʋ súrí ʋ yɩ́á tə. ");
INSERT INTO nnw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Zwezi jɩn liliu tə jɩɩn nə, ʋ van wá ʋ ja nan tɩʋ tə kwa con. Ʋ dàń ga lɩ mɩmɩan mancɩn ʋ kə bɛɛ tə yɩ́á yuu wa. Ʋ tún ʋ jɩ̀àn ʋ yuu, ʋ ga bwe wá, ʋ wʋ́: «N wàá won n nɩ?» ");
INSERT INTO nnw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Liliu tə súrí ʋ yɩ́á, ʋ ga le, ʋ wʋ́: «À na ləzoni, à na ba ndə tɩ̀án nə, yá ba ga vəli». ");
INSERT INTO nnw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zwezi kʋ́ʋ̀ tún ʋ jɩ̀àn bɛɛ tə yɩ́á yuu. Liliu tə nə ywàń ʋ yáá mənə mənə, ʋ yɩ́á tə dàń na wiən tə mama pwənə pwənə. Ʋ nɩ yazurə. ");
INSERT INTO nnw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Vəli n sàń! Dàn ká va tɩʋ tə wa!» ");
INSERT INTO nnw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zwezi də ʋ karbɩa dàń ja ba yáá ba man Filipə Sezare tɩan tə con. Ba nan cwəŋə yuu, ʋ ma bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə lɩ̀à tə swɩ̀n à yuu wa?» ");
INSERT INTO nnw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba ma le wá, ba wʋ́: «Ba duən wʋ́, n yɩ *Zwan-Batisə. Ba duən wʋ́, n yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli. Ba duən də wʋ́, n yɩ Yɩɩ nii sʋ̀sʋ̀nà tə wa lìù don». ");
INSERT INTO nnw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Zwezi ma kʋ́ʋ̀ bwe ba, ʋ wʋ́: «Sə á mʋ̀ con nə? Wàà nə á wʋ́, à yɩ?» Piyɛrə ma le, ʋ wʋ́: «N yɩ *Kərisə». ");
INSERT INTO nnw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Zwezi dàń ma dù súú ba nii nə, sə ba dàn ká swɩ̀n kʋ lìù mama con. ");
INSERT INTO nnw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kʋ kwa nə, Zwezi yà wulə ʋ kàrɩ̀ ʋ karbɩa tə, ʋ wʋ́: «*Ləzwənə-Biu mɛ, sə ʋ də́ càn zənzən. *Zwifə-ba *nəkwɩna, də Yɩɩ *joŋwana yun tɩ̀án, də Yɩɩ nii *yənu tɩ̀án wá vɩ wá ba dʋgʋ. Ba wá gʋ wá, kʋ nə yí dɩan batwa, ʋ wá pìí ʋ bwin». ");
INSERT INTO nnw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ʋ yàá maŋa kʋ, ʋ bɩrɩ ba pwənə pwənə. Piyɛrə dàń ma bon wá ʋ ja nan kwa con, ʋ wulə ʋ caga ʋ nii nə. ");
INSERT INTO nnw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yá Zwezi dàń pìí ʋ vəvəri, ʋ ywàń ʋ karbɩa tə duən tə, ʋ ga caga Piyɛrə nii nə, ʋ wʋ́: «Ja pɩ̀à bwálɩ́, *Sɩtana, n nə yɩ n bʋŋa ndə ləzoni nə, n ba bʋŋa ndə Yɩɩ nə tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kʋ kwa nə, Zwezi bon ʋ karbɩa tə də lɩ̀à tə, ʋ kə duən nə, ʋ swɩ̀n ba con, ʋ wʋ́: «Lìù tə mama nə pɩ̀à, sə ʋ bà ʋ twá à nə, kʋ tíú kʋ́ʋ̀ dàn ká fwa ʋ təntɩan puswənə. Kʋ tíú mɛ, sə ʋ sɛ̀e ʋ twá ʋ də́ càn də nə, kʋ ja vələ ʋ tɩan dagarʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kʋ yɩ cɩ́gá, lìù tə, ʋ nə pɩ̀à, sə ʋ jon ʋ mɩɩ tə, ʋ wá kwɩ̀n kʋ nə. Yá lìù tə, ʋ nə wá dʋgʋ ʋ mɩɩ tə à mʋ̀ yɩrɩ də Yɩɩ sʋywáŋʋ́ tə swɩʋn yɩrɩ, kʋ tíú wá jon ʋ mɩɩ. ");
INSERT INTO nnw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kʋ funə wa yə̀n nə kʋ pa lìù nə, də ʋ nə nɩ tɩa yuu jɩjə tə mama, yá ʋ ga kwɩ̀n mɩɩ tə nə, kʋ nə ba zwɛ̀e Yɩɩ con? ");
INSERT INTO nnw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Won wulə ləzwənə nə wá pa, sə kʋ ma yə̀ ʋ mɩɩ tə kʋ jon, naaa? ");
INSERT INTO nnw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Zə̀n ləzoni tə yáá tə̀lə́ də Yɩɩ, ba ba Yɩɩ nii zìlí. Yá lìù dàń nə dəri cavɩra, sə ʋ bɩrɩ də, ʋ ya à mʋ̀ nə tɩ, ʋ ga dəri cavɩra, sə ʋ swɩ̀n à sʋywáŋʋ́ tə, *Ləzwənə-Biu tə bá sɛ̀e ʋ jon kʋ tíú, máŋá tə, ʋ nə wá pìí ʋ bà də *malɩkɛ ʋ nyɩna tə dun tə wa». ");
INSERT INTO nnw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zwezi kʋ́ʋ̀ swɩ̀n ba con, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lɩ̀à duən, ba nə wulə yəbə, bá tɩ, də ba nə wà Yɩɩ pàrɩ̀ tə nɩ də, kʋ bɩ̀àn də dɩ̀àn». ");
INSERT INTO nnw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kʋ dɩan bardʋ kwa nə, Zwezi bon Piyɛrə də Zwakə də Zwan, ʋ ja dɩ̀ paan nəfarʋ yuu, ba də wá cɩcɩ. Ba nə dɩ̀gà ba yí lá, ʋ lwàń ʋ tɩ̀àn ba yɩ́á yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ʋ ganan tə yà cɩcɩlɩ. Tə yà pɩ̀rɩ̀ tə doni nətʋ tə, ləzwənə nə wàá ka pɩn tə pɩ̀rɩ̀ tɩa yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kʋ kwa nə, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli də *Moyizə nan ʋ karbɩa batwa tə nə. Ba yà wulə ba swɩ̀n də Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyɛrə dàń swɩ̀n Zwezi con, ʋ wʋ́: «Karnyɩna, kʋ ziən də, nə nə wulə yəbə. Nə dàń wá pú gansilə batwa, n mʋ̀ nədʋ, Moyizə nədʋ, Eli də nədʋ». ");
INSERT INTO nnw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyɛrə yà yə̀rì kʋ tə də̀ń, ʋ nə swɩ̀n, ʋ də karbɩa tə duən yà nə zəzəgə zənzən yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bakwan don nan kʋ pəri Moyizə də Eli yuu nə. Bakwan tə wa Yɩɩ kori swɩ̀n lá, kʋ wʋ́: «Ʋ tə nə yɩ à biswənə, á cʋga ʋ nii sʋgʋ». ");
INSERT INTO nnw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Naa nədʋ, də karbɩa tə ywàń ba səpuni nə, yá ba kʋ́ʋ̀ wà lìù mama nɩ. Zwezi yà yɩ ʋ cɩcɩ də ba. ");
INSERT INTO nnw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba nə naŋa paan tə yuu ba cwi, Zwezi pɩn karbɩa tə nii, ʋ wʋ́: «Á dànà ká man kʋ tə, á nə nɩ tə, á bɩrʋ lìù mama. Á jana kʋ á nii nə, kʋ ja vələ *Ləzwənə-Biu tə ka pìí ka bwin tɩga wa». ");
INSERT INTO nnw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ba zìlí ʋ nii, yá ba dàń yà bwe duən, ba wʋ́: «Ka tɩ ka pìí ka bwin, tə də̀ń nə yɩ bɛ̀eɛ̀e?» ");
INSERT INTO nnw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Karbɩa tə dàń ma bwe Zwezi, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn Yɩɩ nii *yənu tɩ̀án tə ma wʋ́, də Yɩɩ nii sʋ̀sʋ̀nʋ̀ Eli nə wá də́ jonu tə yáá ʋ bà lʋʋ?» ");
INSERT INTO nnw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ʋ ma le ba, ʋ wʋ́: «Eli nə mɛ, sə ʋ də́ yáá ʋ bà ʋ kwɛn wiən tə mɛ ʋ kə duən nə. Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Ləzwənə-Biu wá də́ càn zəni. Lɩ̀à ga wá nyáŋá wá. Tə də yìə̀n tə wá tʋn cɩ́gá.› ");
INSERT INTO nnw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yá à mʋ̀ nə swɩ̀n kʋ á con: Eli cɩ́gá nə twi, lɩ̀à duən ja wá, ba ma fwa kʋ tə, ba nə pɩ̀à, ndə kʋ nə pʋ́pʋ́nɩ́ nətʋ tə!» ");
INSERT INTO nnw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kʋ kwa nə, Zwezi də ʋ karbɩa batwa tə, Piyɛrə də Zwakə də Zwan pìí ba va karbɩa tə duən tə con. Máŋá tə, ba nə twi ba yí, lɩ̀à zənzən yà kɩkarɩ karbɩa tə duən tə. Yɩɩ nii *yənu tɩ̀án yà wulə ba tʋ́tʋ̀nɩ́ də karbɩa tə. ");
INSERT INTO nnw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Máŋá tə wa, lɩ̀à tə nə nɩ Zwezi, ba zəzəgə, yá ba ga dəri ba va, sə ba jʋn wá. ");
INSERT INTO nnw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zwezi bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə á wulə á tʋ́tʋ̀nɩ́ duən pwərə wa?» ");
INSERT INTO nnw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bɛɛ don ma le lɩ̀à tə wa, ʋ wʋ́: «Karnyɩna, à bìú nə à ja bà n con. *Zini jə wá, kʋ pa ʋ nii dəŋə. ");
INSERT INTO nnw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Máŋá tə mama, zini tə nə zàn ʋ nə, kʋ yàá dɩ wá tɩa. Ʋ mɩmɩan pàlɩ̀, ʋ yələ ga za duən nə, ʋ ga yàá kʋ. À lòrì n karbɩa tə, sə ba lɩ zini tə ʋ yuu wa, ba ga wà kʋ dɩ̀àn jɩn». ");
INSERT INTO nnw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zwezi ma swɩ̀n karbɩa tə con, ʋ wʋ́: «Á mʋ̀ zə̀n lɩ̀à-ba, á tə nə ba Yɩɩ nii sɛ̀e. Dɩan bagalɩ nə à tə wá yà də aba? Kʋ yɩ à wá ja pɩ́nʋ́ kʋ mɛ nətə də aba? Á jana wá, á ja bà à con!» ");
INSERT INTO nnw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba jɩn bìú tə, ba pa wá. Máŋá tə, zini tə nə nɩ Zwezi, kʋ vuvugu bìú tə zəni. Bìú tə tʋa tɩa ʋ bəbəli, yá ʋ mɩmɩan ga pàlɩ̀. ");
INSERT INTO nnw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zwezi dàń ma bwe bìú tə nyɩna, ʋ wʋ́: «Kʋ dɩan bagalɩ nə ʋ yɩ nətən?» Ʋ nyɩna tə ma swɩ̀n, ʋ wʋ́: «Kʋ yɩ ʋ bìsɩ́nɩ́ mama nə. ");
INSERT INTO nnw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nɛɛ kapʋpʋ, zini tə yàá yigu wá, kʋ dɩ mən wa, nə à yə̀ə́ nɩ́á wa, sə kʋ gʋ wá. Yá n nə wàá won n fwa, sə n dəri nə yinəgə, n ga san nə nə». ");
INSERT INTO nnw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zwezi ma swɩ̀n, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn n le də, à nə wàá won à fwa? Won mama wàá kʋ pa lìù tə nə, ʋ nə keni ʋ waa Yɩɩ nə». ");
INSERT INTO nnw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Naa nədʋ də bìú tə nyɩna cə̀rí ʋ kə yɩɩ nə, ʋ wʋ́: «À ken à waa Yɩɩ nə, yá n dàń nə san nə, sə à kʋ́ʋ̀ dàn ká bɛ̀eé». ");
INSERT INTO nnw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Zwezi nə na də, lɩ̀à dəri ba twi ba nə tə, ʋ baa zini tə nii nə, ʋ wʋ́: «Zini tə nə cɩ̀ kʋ pɩn lìù ba swɩ̀n də lìù ba nə̀ń, à mʋ̀ nə pɩn nii, sə n nan bìú tə yɩra. N kʋ́ʋ̀ dàn ká pìí n zʋ wá mama!» ");
INSERT INTO nnw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zini tə mà nii, kʋ vuvugu bìú tə zənzən, kʋ ga nan. Bìú tə yà yɩ ndə ʋ tɩga, kʋ pa, lɩ̀à duən yà nə zɩga lá, yà swɩ̀n də, ʋ tɩga. ");
INSERT INTO nnw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yá Zwezi jɩn ʋ jɩɩn nə, ʋ van wá ʋ zɩ̀n. Bìú tə zàn ʋ zɩga yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zwezi nə vəli sàń máŋá tə nə, ʋ də ʋ karbɩa tə cɩcɩ nə wulə, ba dàń bwe wá, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, nə wà wànɩ́ nə lɩ zini tə?» ");
INSERT INTO nnw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Zwezi ma le ba, ʋ wʋ́: «Kʋ yɩ yɩjʋnɩ cɩcɩ nə wàá zini kʋ tə yiri kʋ lɩ!» ");
INSERT INTO nnw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Zwezi də ʋ karbɩa tə nan lantə, ba twá Galile nagwanaa. Zwezi yà ba pɩ̀à, sə ba lwarɩ ʋ bwálɩ́, ");
INSERT INTO nnw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ʋ yà nə kàrɩ̀ ʋ karbɩa tə yɩrɩ. Ʋ swɩ̀n ba con, ʋ wʋ́: «Lɩ̀à wá tì *Ləzwənə-Biu. Ʋ wá zʋ ləzoni jɩ̀àn wa. Ba wá gʋ wá. Kʋ dɩan batwa dɩɩn nə, ʋ wá pìí ʋ bwin». ");
INSERT INTO nnw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yá ʋ karbɩa tə wà sʋgʋ tə də̀ń nì, ba ga dəri fən, sə ba bwe wá. ");
INSERT INTO nnw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Zwezi də ʋ karbɩa tə dàń yí Kapɛrənayimə tɩʋ. Máŋá tə, ba yà nə wulə dìə̀ wa, Zwezi bwe ʋ karbɩa tə, ʋ wʋ́: «Bɛ̀eɛ̀e də̀ń nə nə á tʋ́tʋ̀nɩ́ duən, də nə nə wulə cwəŋə tə yuu wa?» ");
INSERT INTO nnw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ba yà púə́ ba nii, ba yà nə yɩ ba tʋ́tʋ̀nɩ́ duən, sə ba lwarɩ lìù tə, ʋ nə wá yà ba yuu wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zwezi dàń ma jə̀ń tɩa, ʋ ga bon ʋ karbɩa fugə bələ tə, sə ba boli ʋ yɩra. Ʋ swɩ̀n ba con, ʋ wʋ́: «Lìù tə, ʋ nə pɩ̀à, sə ʋ yà yuu wa, kʋ tíú tə mɛ, sə ʋ ya ba mama wa nəmaa. Ʋ ga mɛ, sə ʋ tʋn ʋ pa ba mɛ nə». ");
INSERT INTO nnw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ʋ dàń ga tì bisɩmabiə, ʋ zɩgɩ ba yáá con. Ʋ kʋkwalɩ wá ʋ kə ʋ nyʋnɩ nə, ʋ ga swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Lìù tə, ʋ nə jɩn bisɩmabii ba tə don zəni à mʋ̀ yɩrɩ, kʋ yɩ à mʋ̀ tətə nə kʋ tíú jɩn zəni. Yá lìù tə, ʋ nə jɩn nə zəni, kʋ tíú bɩrɩ də, ʋ jɩn lìù tə, ʋ nə tʋn nə, zəni». ");
INSERT INTO nnw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zwan swɩ̀n Zwezi con, ʋ wʋ́: «Karnyɩna, nə nɩ bɛɛ don ʋ ja n yɩrɩ tə, ʋ ma lɩ *zinə, yá ʋ ga tə̀lə́ də nəba. Nə yà swɩ̀n də, ʋ ba cwəŋə jə, sə ʋ fwa kʋ, ʋ nə tə̀lə́ də nəba tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yá Zwezi dàń le ba, ʋ wʋ́: «Á dànà ká cɩ̀ ʋ nə, á yaga wá, sə ʋ fwa! Lìù tə, ʋ nə wá twá à yɩrɩ tə nə, ʋ ma fwa yomɩlʋ, ʋ wàrɩ̀ à yolwan ʋ pìí ʋ swɩ̀n sɩ́ʋ́n sɩ́ʋ́n. ");
INSERT INTO nnw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Cɩ́gá, lìù tə, ʋ nə ba nə nə zɩga, yɩ nə lìù. ");
INSERT INTO nnw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Lìù nə pɩn aba wùrú zʋŋa də nɩ́á, á nə yɩ à mʋ̀ *Kərisə lɩ̀à yɩrɩ, cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con, kʋ lìù təntə bá kwɩ̀n ʋ ŋwɩ́rán nə Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kʋ kwa nə, Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lìù tə, ʋ nə pɩn, labwana təntə, ba nə keni ba waa à nə wuuu, don twá ʋ nə, ʋ dʋgʋ Yɩɩ cwəŋə tə, ka jén, kʋ wá kʋkwanɩ kʋ tíú con nə, də ba nə vwə kapan nəfarʋ ʋ bɩan nə, ba ja va, ba dɩ mʋʋ wa. ");
INSERT INTO nnw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Də kʋ nə wá twá n jɩɩn nə, n ma tʋn cʋna, sə n gwəŋə kʋ. N nə zʋa mɩɩ tə wa, kʋ nə ba zwɛ̀e Yɩɩ con, də jɩɩn nədʋ, kʋ kʋkwa n nə zʋa mən dìə̀ wa də jɩ̀àn bələ. Tə mən təntə nə ba dəŋi. ");
INSERT INTO nnw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lantə, zʋnzʋran wulə, tə nə də́ yɩra, tə ga ba tɩ, yá mən tə ga ba dəŋi abada. ");
INSERT INTO nnw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Də kʋ nə wá twá n naa nə, n ma tʋn cʋna, sə n gwəŋə ka. N nə zʋa mɩɩ tə wa, kʋ nə ba zwɛ̀e Yɩɩ con, də naa nədʋ, kʋ kʋkwa n jə nɛɛ bələ, yá n ga zʋ mən dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lantə, zʋnzʋran wulə, tə nə də́ yɩra, tə ga ba tɩ, yá mən tə ga ba dəŋi abada. ");
INSERT INTO nnw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Də kʋ nə wá twá n yii nə, n ma tʋn cʋna, sə n lɩ kʋ dʋgʋ. N nə zʋa Yɩɩ pàrɩ̀ wa də yii nədʋ, kʋ kʋkwa n nə jə yɩ́á bələ, yá n ga zʋ mən dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lantə, zʋnzʋran wulə, tə nə də́ yɩra, tə ga ba tɩ, yá mən tə də ga ba dəŋi abada. ");
INSERT INTO nnw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Càn mən wá cú lìù mama yuu wa. Tə wá kwɛn lìù mama tə lɩ cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nakwan yɩ won, kʋ nə ziən. Yá ka nyɩŋa nə nan, á kʋ́ʋ̀ wàrɩ̀ ka á pɩn ka pìí ka janɩ nyɩŋa. Á yana ndə nakwan nə, á ga ya də duən də bɩcan sìə́». ");
INSERT INTO nnw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zwezi nan ʋ yá kʋ bwálɩ́ tə. Kʋ kwa nə, Zwezi vəli Zwide nagwanaa wa, Zwurədɛn mʋnaa tə vàn don nə. Lɩ̀à zənzən kʋ́ʋ̀ twi ba pú ʋ yuu nə. Ʋ yà kàrɩ̀ ba, ndə ʋ yàá nə fwa máŋá mama nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","*Farɩzɩan-ba duən fàrʋ́ ba yí wá, sə ba ja ʋ də̀ń nə. Ba dàń bwe wá, ba wʋ́: «*Zwifə-ba Yɩɩ *nii yìə̀n tə, ʋ nə pɩn *Moyizə nə, yàá pa cwəŋə bɛɛ nə, sə ʋ dʋgʋ ʋ kan?» ");
INSERT INTO nnw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Zwezi ma pìí ʋ bwe ba, ʋ wʋ́: «Kàrà kwà nə Moyizə bɩrʋ aba?» ");
INSERT INTO nnw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba ma wʋ́: «Moyizə pɩn cwəŋə bɛɛ nə, sə ʋ pʋ́pʋ́nɩ́ ka kwa kasweri sagɩ, ʋ ga dʋgʋ ʋ kan». ");
INSERT INTO nnw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Zwezi ma swɩ̀n, ʋ wʋ́: «Moyizə pʋ́pʋ́nɩ́ kʋ mʋ̀ bɩra tə ʋ pa aba, á zɩbaniun tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yá kʋ nə zɩgɩ máŋá tə nə, Yɩɩ nə fwa wiən mɛ, Yɩɩ fwa ləzwənə, ʋ fwa bɛɛ də kan. ");
INSERT INTO nnw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mə nətʋ nə kʋ pʋ́pʋ́nɩ́, kʋ wʋ́: ‹Kʋ mʋ̀ yɩrɩ nə, bɛɛ wá nan ʋ yá ʋ nuu də ʋ nyɩna, ʋ ga vwa ʋ tɩ̀àn ʋ kan nə. ");
INSERT INTO nnw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yá ba mɛ bələ wá jì won nədʋ›.» Zwezi swɩ̀n ʋ súrí lá, ʋ wʋ́: «Yá ba kʋ́ʋ̀ bá yà lɩ̀à bələ, ba dàń wá yà won nədʋ. ");
INSERT INTO nnw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ləzwənə mama kʋ́ʋ̀ wa mɛ, sə ʋ pwɛ̀e won tə, Yɩɩ nə vwə duən nə». ");
INSERT INTO nnw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Máŋá tə, ba nə zʋa dìə̀, ʋ karbɩa tə kʋ́ʋ̀ bwe wá tə mʋ̀ yìə̀n tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ʋ swɩ̀n ba con, ʋ wʋ́: «Bɛɛ tə, ʋ nə dʋgʋ ʋ kan, ʋ ga swe ʋ don, kʋ yɩ bacwan nə ʋ fwa də təntən kan tə. ");
INSERT INTO nnw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nətʋ nə, kan də kʋ́ʋ̀ nə dʋgʋ ʋ barɩ, ʋ ga va ʋ swe bɛɛ don, ʋ də kʋ́ʋ̀ yɩ kacwan nə ʋ fwa». ");
INSERT INTO nnw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lɩ̀à yà jɩn bìsɩ́ná ba ja ba Zwezi con, sə ʋ dwen ba yɩra. Yá ʋ karbɩa tə dàń wulə ba caga ba nii nə. ");
INSERT INTO nnw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Zwezi nə nɩ kʋ, ʋ lɩŋa zàn. Ʋ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á yaga bìsɩ́ná tə, sə ba bà à con. Á dànà ká cɩ̀ ba nə. Lɩ̀à tə, ba nə yɩ ndə bìsɩ́ná tə nə, nə wá yà də Yɩɩ ʋ pàrɩ̀ tə diŋə wa. ");
INSERT INTO nnw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Də lìù nə ba sɛ̀e, ʋ jì ndə bisɩmaa, ʋ ba wànɩ́ Yɩɩ pàrɩ̀ tə wa ʋ zʋ abada». ");
INSERT INTO nnw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kʋ kwa nə, ʋ kʋkwalɩ bìsɩ́ná tə ʋ kə ʋ nyʋnɩ nə, yá ʋ tún ʋ jɩ̀àn ba yuu wa. Ʋ lòrì Yɩɩ ʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zwezi yà ma vìrí, də bɛɛ don dəri, ʋ yí wá. Ʋ tʋ ʋ nadwana nii nə Zwezi yáá con, yá ʋ ga bwe wá, ʋ wʋ́: «Karnyɩna, n yɩ pubwanʋ tíú. Bɛ̀eɛ̀e nə à mɛ, sə à fwa, sə à ma na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con?» ");
INSERT INTO nnw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Zwezi ma le wá, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, n ma boŋə nə pubwanʋ tíú? Lìù tə̀lə́, ʋ nə yɩ pubwanʋ tíú, də kʋ nə tà Yɩɩ cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","N yə̀ə́ Yɩɩ *nii yìə̀n tə, ʋ nə pɩn *Moyizə nə: ‹Dàn ká gʋ lìù! Dàn ká cwàrɩ̀! Dàn ká ŋʋ̀! Dàn ká kʋna kʋnkʋn n kə lìù nii nə! Dàn ká gɩgarɩ lɩ̀à! Zìlí n nuu də n nyɩna nii!› » ");
INSERT INTO nnw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bɛɛ tə ma le wá, ʋ wʋ́: «Karnyɩna, à zìlí Yɩɩ nii yìə̀n təntə mɛ, də à tə yɩ bisɩmaa». ");
INSERT INTO nnw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zwezi ywàń bɛɛ tə də sonu. Ʋ dàń ma swɩ̀n ʋ con, ʋ wʋ́: «Won nədʋ nə ga, sə n fwa: Vəli n yə̀ wiən tə mɛ nə wulə n con. N tì tə səbiu tə n pa zʋra nə. Yá n wá na wiən tə, kwənə nə dáá Yɩɩ *sàń nə. Kʋ kwa nə, n dàń bà n twá à nə». ");
INSERT INTO nnw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yá máŋá tə, bɛɛ tə nə nì sʋ̀ràn təntə, ʋ yáá cʋ̀gʋ̀. Ʋ kɛ̀eń ʋ vìí, ʋ yà nə yɩ wiən zənzən tíú yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zwezi ywàń ʋ karbɩa tə, də ba nə kəkəli wá, ʋ dàń ga swɩ̀n ba con, ʋ wʋ́: «Kʋ bá yà mwálɩ́ kʋ pa jɩjə tɩ̀án nə, sə ba zʋ Yɩɩ pàrɩ̀ tə wa». ");
INSERT INTO nnw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sʋ̀ràn tə gwárɩ́ ʋ karbɩa tə zəni. Yá Zwezi kʋ́ʋ̀ pìí ʋ swɩ̀n ba con, ʋ wʋ́: «À bɩa-ba, Yɩɩ pàrɩ̀ tə wa zwɩʋ cɩ́gá tà mwálɩ́. ");
INSERT INTO nnw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nyʋgʋma ka twá gancɩɩn bʋʋ kʋ nan yɩ mwálɩ́, kʋ doni jɩjə tíú nə pɩ̀à, sə ʋ zʋ Yɩɩ pàrɩ̀ tə wa». ");
INSERT INTO nnw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sʋ̀ràn tə kwɛn tə gwárɩ́ ʋ karbɩa tə, ba dàń ga swɩ̀n duən nə, ba wʋ́: «Kʋ nə yɩ nətʋ, lìù tə̀lə́, Yɩɩ nə wá wànɩ́ ʋ jon kʋ tíú ʋ cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zwezi ywàń ba ʋ ga swɩ̀n, ʋ wʋ́: «Kʋ yɩ won tə, ləzoni nə wàrɩ̀ ba fwa, yá kʋ tà Yɩɩ mʋ̀! Yɩɩ mʋ̀ wàá won mama ʋ fwa». ");
INSERT INTO nnw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piyɛrə dàń ma swɩ̀n ʋ con, ʋ wʋ́: «Ywàń, nə dʋgʋ won mama, nə ga twá n nə». ");
INSERT INTO nnw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zwezi ma le wá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù nə taa à mʋ̀ də Yɩɩ sʋywáŋʋ́ tə yɩrɩ, ʋ nan ʋ ga yá ʋ sàń, nə à yə̀ə́ ʋ nubɩa, də ʋ nuu, də ʋ nyɩna, də ʋ bɩa, də ʋ kárɩ́. ");
INSERT INTO nnw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kʋ tíú wá na sɩ́ʋ́n máŋá kʋ tə wa dii, də nubɩa, də ninə, də bɩa, də kárɩ́, kʋ nədʋ mama nɛɛ bíí. Yá ʋ ga wá də́ càn də. Yá máŋá tə, kʋ nə wulə yáá kʋ bɩ̀àn, ʋ wá na mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Təntən lɩ̀à dáá, ba nə wá yà talɩkwa lɩ̀à. Yá talɩkwa lɩ̀à də ga dáá, ba nə wá yà təntən lɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zwezi də ʋ karbɩa tə yà wulə cwəŋə yuu ba vələ *Zwerizalɛmə. Zwezi yà wulə ba yáá ʋ vəli. Ʋ karbɩa tə pwìí cʋ̀gʋ̀, yá fən ga zʋ lɩ̀à tə nə twá ba kwa. Zwezi kʋ́ʋ̀ bon ʋ karbɩa fugə bələ tə ʋ kə duən nə. Ʋ man won tə nə wá yí wá sɩ́ʋ́n nə, ʋ bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ʋ swɩ̀n ba con, ʋ wʋ́: «Á cʋga zəni, nə wulə cwəŋə wa, nə ma vələ Zwerizalɛmə. Mə tɩʋ təntə wa nə, ba wá ja *Ləzwənə-Biu tə, ba kə Yɩɩ *joŋwana yun tɩ̀án də Yɩɩ nii *yənu tɩ̀án jɩ̀àn wa. Ba wá bʋ̀rɩ̀ ʋ bʋ̀rà, sə ba gʋ wá. Ba wá kə wá lɩ̀à tə, ba nə yə̀rì Yɩɩ, jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ba wá mʋn wá, ba pi mɩmɩan ba lwá ʋ yuu wa. Ba wá mà wá ʋ yɩra lá, yá ba ga gʋ wá. Yá dɩan batwa nii nə, Yɩɩ wá pìí ʋ bwin wá, ʋ lɩ tɩan wa». ");
INSERT INTO nnw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kʋ kwa nə, Zebede bɩa tə, Zwakə də Zwan, twi Zwezi bɩan nə, ba swɩ̀n ʋ con, ba wʋ́: «Karnyɩna, nə pɩ̀à, sə n tʋn kʋ tə, nə nə lòrì tə n pa nəba». ");
INSERT INTO nnw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zwezi ma bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə á pɩ̀à, sə à tʋn à pa aba?» ");
INSERT INTO nnw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba ma le, ba wʋ́: «Máŋá tə, n nə wá də́ n pàrɩ̀ tə, pa nə jə̀ń nə boli n yɩra dun gwələ yuu, ʋ don n jɩzən nə, ʋ don də n jɩgwiə nə». ");
INSERT INTO nnw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Á yə̀rì kʋ tə, á nə lòrì. Á wá wànɩ́ á zɩgɩ á də́ càn tə, à nə wá də́ naaa? Á ken á sírí, sə á kə á tɩ̀àn yacara tə wa, ndə à nə naaa?» ");
INSERT INTO nnw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba dàń ma le wá, ba wʋ́: «Nə wàá». Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Kʋ yɩ cɩ́gá, á wá də́ càn tə, à nə wá də́. Á wá kə á tɩ̀àn yacara tə wa, tə nə wá yí nə. ");
INSERT INTO nnw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yá kʋ tà à mʋ̀ nə mɛ, sə à pa nii, də lìù wà tə nə wá jə̀ń à jɩzən nə, nə à yə̀ə́ à jɩgwiə nə. Yɩɩ nə kwɛn tə mʋ̀ bwálá tə, ʋ tún lɩ̀à tə nə, tə nə mɛ də ba, kʋ tà à mʋ̀». ");
INSERT INTO nnw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Máŋá tə ʋ karbɩa fugə tə duən nə nì kʋ, ba lɩŋa zàn Zwakə də Zwan yuu. ");
INSERT INTO nnw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zwezi dàń ma bon ba mama ʋ swɩ̀n, ʋ wʋ́: «Á yə̀ə́ də lɩ̀à tə, ba nə tì ba tɩ̀àn ndə pɛ̀egá nə, yàá wʋwalɩ ba lɩ̀à tə, ba nə jə̀ə́ ba yuu wa, ndə ba ywəŋə nə. Yá ladɩra tə yàá pa ba lwarɩ ba dɩ̀àn nii nə. ");
INSERT INTO nnw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yá kʋ mʋ̀ nə wà mɛ, sə kʋ fwa á pwərə wa. Á lìù tə, ʋ nə pɩ̀à, sə ʋ yà ləzwənfarʋ, kʋ tíú mɛ, sə ʋ yà á tʋtʋnbiu. ");
INSERT INTO nnw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Á lìù tə, ʋ nə pɩ̀à, sə ʋ yà á yáá tíú, kʋ tíú mɛ, sə ʋ yà á mɛ yoŋu. ");
INSERT INTO nnw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","*Ləzwənə-Biu tə nə tà ʋ twi, sə ʋ jə̀ń, sə ba tʋn ba pa wá yɩrɩ. Ʋ yɩ ʋ twi, sə ʋ tʋn ʋ pa lɩ̀à nə, sə ʋ pa ʋ mɩɩ ndə ŋwɩ́rán nə, sə ʋ ma jon lɩ̀à kapʋpʋ ba cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zwezi də ʋ karbɩa tə dàń vələ ba yí Zweriko tɩʋ. Ba də lɩ̀à zənzən nə nan tɩʋ təntə wa, ba vələ *Zwerizalɛmə. Ba nə nan máŋá tə wa, də Time bìú Barətime, liliu don, yà jə cwəŋə nii nə ʋ lòrì. ");
INSERT INTO nnw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ʋ nə nì də, kʋ yɩ *Nazarɛtə Zwezi, ʋ dàń wulə ʋ boŋə, ʋ wʋ́: «Zwezi, *Davidə nàʋ́, dəri à yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lɩ̀à zənzən caga ʋ nii nə, sə ba pa, ʋ pú ʋ nii. Yá ʋ dàń nə kwɛn ʋ cə̀rí ʋ kəni yɩɩ nə, ʋ wʋ́: «Davidə nàʋ́, dəri à yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zwezi ma zɩgɩ ʋ swɩ̀n, ʋ wʋ́: «Á boŋə wá!» Ba dàń ma bon liliu tə, ba ga swɩ̀n ʋ con, ba wʋ́: «Pa n jɩ̀àn ja dɩ̀àn, zàn yɩɩ nə, ʋ boŋə mʋ́». ");
INSERT INTO nnw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Liliu tə dʋgʋ ʋ ganyaʋ lala, ʋ zàn ʋ va Zwezi con. ");
INSERT INTO nnw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Zwezi ma bwe wá, ʋ wʋ́: «Bɛ̀eɛ̀e nə n pɩ̀à, sə à fwa à pa mʋ́?» Liliu tə ma le wá, ʋ wʋ́: «Karnyɩna pa, sə à yɩ́á tə kʋ́ʋ̀ na». ");
INSERT INTO nnw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «N wàá n vìrí! N nɩ yazurə, n nə ken n waa à nə tə yɩrɩ». Naa nədʋ, də ʋ na lá. Ʋ dàń ma pú Zwezi kwa cwəŋə tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zwezi də ʋ karbɩa tə vəli ba yí *Zwerizalɛmə. Ba twá Bɛtəfazwe də Betani tɩan tə wa *oliviye tɩ̀án paan tə səpuni nə ba lɛ. Zwezi ma tʋn ʋ karbɩa bələ. Ʋ swɩ̀n ba con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Á vələ tɩʋ tə nə wulə á yáá. Á nə zəzən á yí, á wá na bɩnabiə də ka vwə. Lìù mama tə wà ka yuu jə̀ń. Á kʋra ka á ja bà. ");
INSERT INTO nnw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yá lìù nə bwe aba, ʋ wʋ́: ‹Bɛ̀eɛ̀e nə pɩn, á ma fwa kʋ?›, sə á swɩ̀n ʋ con: ‹*Yuu-Tiu nə pɩ̀à ka›. Á nə swɩ̀n nətʋ, kʋ tíú tə wá yá ʋ pa á ja ka á bà yəbə sɩ́ʋ́n sɩ́ʋ́n». ");
INSERT INTO nnw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ba nə vəli ba cɩ́gá nɩ bɩnabiə kàrá wa cwəŋə yuu, də ka vwə dìə̀ don mimii nə. Ba ma kʋrʋ ka. ");
INSERT INTO nnw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lɩ̀à tə duən yà nə wulə lá bwe ba, ba wʋ́: «Bɛ̀eɛ̀e nə á wulə á fwa? Bɛ̀eɛ̀e yɩrɩ nə á ma kʋ̀rɩ̀ bɩnabiə ka tə?» ");
INSERT INTO nnw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Karbɩa tə ma le lɩ̀à tə nətʋ, Zwezi yà nə swɩ̀n ba con. Lɩ̀à tə ma yá ba, ba vìí. ");
INSERT INTO nnw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba jɩn bɩnabiə tə ba ja va, ba pa Zwezi nə. Ba tún ba ganan bɩ̀nà tə yuu, Zwezi dɩ̀ ʋ jə̀ə́. ");
INSERT INTO nnw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lɩ̀à zənzən làrɩ̀ ba ganan cwəŋə tə wa. Ba duən də làrɩ̀ tɩ̀án vʋran, ba nə za ba kárɩ́ wa. ");
INSERT INTO nnw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lɩ̀à tə, ba nə wulə Zwezi yáá ba vəli, də ba tə, ba nə wulə ʋ kwa, cə̀rí ba kəni yɩɩ nə, ba wʋ́: «Ozana Yɩɩ *sàń nə! Yɩɩ wá fwa zəni lìù tə yɩra, ʋ nə bɩ̀àn Yuu-Tiu yɩrɩ yuu wa! ");
INSERT INTO nnw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yɩɩ wá fwa zəni pàrɩ̀ tə yuu wa, kʋ nə bɩ̀àn! Yɩɩ wá fwa zəni nə nɩbɛɛ pɩ̀ʋ́ *Davidə pàrɩ̀ tə yuu wa, kʋ nə kʋ́ʋ̀ pìí kʋ bɩ̀àn! Dun mɛ wa Yɩɩ sàń nə ʋ con». ");
INSERT INTO nnw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kʋ kwa nə, Zwezi zʋa Zwerizalɛmə wa, ʋ va Yɩɩ *dìə̀ tə wa. Ʋ nə ywàń wiən tə mɛ ʋ zwɛ̀e, tɩa tə yí tə. Ʋ dàń nan ʋ də ʋ karbɩa fugə bələ tə va Betani. ");
INSERT INTO nnw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kʋ tɩa nə pʋrɩ, Zwezi də ʋ karbɩa tə nə naŋa Betani máŋá tə wa, niən jɩn Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ʋ nɩ kapɩrʋ don yɩŋʋna, kʋ yà nə jə vʋran. Ʋ vəli ʋ ywàń, sə ʋ jə́n ʋ wá na bɩa kʋ yuu. Máŋá tə, ʋ nə yí tɩ̀ʋ́ tə yɩra, vʋran cɩcɩ ya nə wulə, kapɩra bɩʋ máŋá yà tə nə wà yí yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Zwezi dàń ma swɩ̀n kapɩrʋ tə con, ʋ wʋ́: «N kʋ́ʋ̀ ba zɩn bɩa, sə lìù də́!» Ʋ karbɩa tə nì kʋ tə, ʋ nə swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kʋ kwa nə, Zwezi də ʋ karbɩa tə yí *Zwerizalɛmə. Zwezi zʋa *Zwifə-ba Yɩɩ *dìə̀ dəwoo tə wa, ʋ ga dɩŋɩ lɩ̀à tə mama, ba nə yoli, də ba tə, ba nə yə̀, kʋ bwálɩ́ tə wa. Ʋ dɩŋɩ lɩ̀à tə. Ʋ yigu ba tə nə lárɩ́ səbɩa tabɩlan, də ba tə, ba nə yoli nasara gunponi tə gwələ ʋ dɩ tɩa. ");
INSERT INTO nnw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ʋ ga kʋ́ʋ̀ ba yá ʋ pɩn lìù mama zɩŋa won ʋ ja twá Yɩɩ dìə̀ tə wa ʋ lɛ. ");
INSERT INTO nnw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kʋ kwa nə, Zwezi kàrɩ̀ ba, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Ba wá bon à dìə̀ tə «lʋʋ dwíə́ tə mama yɩjʋnɩ dìə̀».› Yá á mʋ̀ janɩ ka á ma fwa ŋwɩna yisəgə bwálɩ́!» ");
INSERT INTO nnw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Zwezi kàrà tə yà zʋa lɩ̀à tə zəni. Máŋá tə, Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án, də Yɩɩ nii *yənu tɩ̀án nə nì kʋ mʋ̀ təntə, ʋ fən zʋa ba. Ba dàń pɩ̀à nətʋ tə, ba nə wá twá ba ma pa ba gʋ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dədəni nə yí, Zwezi də ʋ karbɩa tə nan Zwerizalɛmə wa. ");
INSERT INTO nnw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kʋ tɩa nə pʋrɩ, jɩjʋ fuən fuən, Zwezi də ʋ karbɩa tə nə twá cwəŋə tə, ba nɩ kapɩrʋ tə, də kʋ kʋa kʋ yí kʋ ŋʋnan. ");
INSERT INTO nnw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyɛrə ma lìí kʋ tə, kʋ nə fwa dɩan tə nə, ʋ ma swɩ̀n Zwezi con, ʋ wʋ́: «Karnyɩna, ywàń kapɩrʋ tə, n nə zɩrɩ n kə kʋ nə tə kʋa». ");
INSERT INTO nnw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Zwezi ma swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Cɩ́gá mama, à swɩ̀n kʋ á con: Á kənə á waa Yɩɩ nə! ");
INSERT INTO nnw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Lìù wàá paan con ʋ swɩ̀n, ʋ wʋ́: ‹Zàn lá n va, n tʋ mʋʋ wa›. Də ʋ nə ba kʋ bɛ̀eé ʋ waa con, də ʋ nə pɩn cɩ́gá də, kʋ tə, ʋ nə swɩ̀n tə mɛ, sə kʋ tʋn, kʋ cɩ́gá wá tʋn nətʋ. ");
INSERT INTO nnw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kʋ mʋ̀ yɩrɩ nə, à ma swɩ̀n á con, à wʋ́: Á nə jʋn Yɩɩ á ga lòrì won ʋ con, á kənə á waa də á nɩ kʋ won təntə. Á ga wá na kʋ won tə. ");
INSERT INTO nnw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Máŋá tə, á nə wulə á jʋ̀nɩ̀ Yɩɩ, á nə jə yoo də lìù, sə á kwɛn kʋ, á lɩ á mʋ̀ də kʋ tíú pwərə wa. Á nə fwa kʋ nətʋ, á nyɩna Yɩɩ tə, ʋ nə wulə Yɩɩ *sàń nə, də ʋ wá kwɛn á cʋna tə, ʋ lɩ á mʋ̀ də ʋ mʋ̀ pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yá á dàń nə vɩga, sə á kwɛn yoo, á lɩ á mʋ̀ də lɩ̀à tə pwərə wa, á nyɩna Yɩɩ tə də, ʋ nə wulə Yɩɩ sàń nə, wá vɩ, sə ʋ kwɛn á də cʋna tə, ʋ lɩ á mʋ̀ də ʋ mʋ̀ pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zwezi də ʋ karbɩa tə kʋ́ʋ̀ pìí ba va *Zwerizalɛmə. Zwezi nə wulə *Zwifə-ba Yɩɩ *dìə̀ tə wa ʋ vəli, máŋá tə nə, Yɩɩ *joŋwana yun tɩ̀án, də Yɩɩ nii *yənu tɩ̀án, də Zwifə-ba *nəkwɩna vəli ba yí wá. ");
INSERT INTO nnw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ba bwe wá, ba wʋ́: «Dɩ̀àn taa nə, n ma fwa yìə̀n tə tə? Wàà nə pɩn mʋ́ cwəŋə, sə n fwa tə?» ");
INSERT INTO nnw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Zwezi ma le ba, ʋ wʋ́: «À wá bwe aba yoo nədʋ. Á nə wànɩ́ á le nə, à də dàń wá le aba. À wá man won tə nə pɩn, à ma fwa yìə̀n təntə. ");
INSERT INTO nnw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wàà nə ken dɩ̀àn Zwan jɩɩn wa, sə ʋ lə lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ tə? Kʋ yɩ Yɩɩ, nə à yə̀ə́ ləzoni? Á nə wàá, sə á le nə!» ");
INSERT INTO nnw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kʋ pɩn, ba dàń wulə ba tʋ́tʋ̀nɩ́ duən, ba ga swɩ̀n duən con, ba wʋ́: «Nə nə le, nə wʋ́: ‹Kʋ ya Yɩɩ nə ken dɩ̀àn Zwan jɩɩn wa›, ʋ wá bwe nəba, ʋ wʋ́: ‹Bɛ̀eɛ̀e dàń nə pɩn, á ma wà cɩ́gá ʋ sʋgʋ tə nə pɩn?› ");
INSERT INTO nnw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yá nə ma wàrɩ̀ nə le də, kʋ yɩ ləzoni nə ken dɩ̀àn ʋ jɩɩn wa». Ba swɩ̀n nətʋ, ba yà nə dəri lɩ̀à tə fən yɩrɩ. Lɩ̀à tə mama yà yə̀ə́ də, Zwan yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ cɩ́gá cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ba dàń ma le Zwezi, ba wʋ́: «Nə yə̀rì». Zwezi də ma swɩ̀n ba con, ʋ wʋ́: «À də bá swɩ̀n lìù tə, ʋ nə ken dɩ̀àn à jɩɩn wa, à ma fwa tə yìə̀n təntə». ");
INSERT INTO nnw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zwezi ma zàn ʋ swɩ̀n *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə, də ba *nəkwɩna tə con də zwansɩsara ka tə, ʋ wʋ́: «Bɛɛ don cwɛn ʋ divɛn tɩ̀án kárá. Ʋ kɩkarɩ ka də dabwaʋ. Ʋ kʋ̀ gwàlʋ́ kapataʋ wa, sə ba ma kaŋɩ divɛn tɩ̀án bɩa tə. Yá ʋ dàń ga lwà vuun, sə ba ma cɩ̀ kárá tə nə. Kʋ kwa nə, ʋ tì kárá tə ʋ yá vala duən jɩ̀àn wa, ʋ ga va cwəŋə. ");
INSERT INTO nnw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Máŋá tə, divɛn tɩ̀án bɩa tə koru nə yí, ʋ tʋn tʋ̀tʋ̀nʋ̀ don vala tə con. Ʋ pɩ̀à ʋ divɛn tɩ̀án bɩa tə vàn don. ");
INSERT INTO nnw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Máŋá tə, ʋ nə yí lá, vala tə jɩn tʋ̀tʋ̀nʋ̀ tə ba mà, ba pa ʋ pìí ʋ vìí də ʋ jɩkʋrɩkɛ. ");
INSERT INTO nnw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kárá tə tíú kʋ́ʋ̀ pìí ʋ tʋn tʋ̀tʋ̀nʋ̀ don, ba mà ʋ yuu ba kàrɩ́, ba ga twɩn wá. ");
INSERT INTO nnw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kárá tə tíú kʋ́ʋ̀ pɩn tʋ̀tʋ̀nʋ̀ don va, ba gʋa ʋ mʋ̀ təntə. Ba ga tʋn kʋ nyɩnyɩga tʋ̀tʋ̀nà zənzən duən yɩra. Ba mà ba duən, ba gʋ ba duən. ");
INSERT INTO nnw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kʋ dàń yà ga bɛɛ nədʋ cɩcɩ kárá tíú tə con. Ʋ mʋ̀ bɛɛ tə nə yɩ ʋ biswənə. Ʋ dàń ma talɩkwa ʋ tʋn ʋ bìú tə vala tə con. Ʋ dàń swɩ̀n ʋ waa con, ʋ wʋ́: ‹Ba wá zìlí à bìú tə!› ");
INSERT INTO nnw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yá vala tə də swɩ̀n duən con, ba wʋ́: ‹Á ywàŋá, ʋ tə nə wá bà ʋ tɩnɩ bwálɩ́ tə, ʋ nyɩna tɩan kwa nə. Nə gwɩa wá, sə nə dàń ga ja kárá tə›. ");
INSERT INTO nnw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba dàń ma ja bìú tə, ba gʋ wá, ba dɩlɩ ʋ tɩgɩ tə kárá tə kwa con». ");
INSERT INTO nnw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Zwezi dàń ma bwe, ʋ wʋ́: «Bɛ̀eɛ̀e nə kárá tə tíú dàń wá fwa? Kʋ yɩ, ʋ wá va ʋ kárá tə wa, ʋ gʋ vala tə mama, ʋ ga tì kárá tə ʋ kə lɩ̀à duən jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Á kàrɩ̀ Yɩɩ sagɩ tə wa, ba nə pʋ́pʋ́nɩ́, kʋ wʋ́: ‹Kapan tə, də̀lwə̀rə́ tə yà nə vɩga ba dʋgʋ vàn nə, kʋ mʋ̀ nə pìí kʋ jì dìə̀ nigwancɩɩn wárɩ́, kʋ yoo nə cà. ");
INSERT INTO nnw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","*Yuu-Tiu nə ken, sə kʋ ya nətʋ, yá kʋ yɩ yozəŋu kʋ pa nəba›.» ");
INSERT INTO nnw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yɩɩ joŋwana yun tɩ̀án tə, də Yɩɩ nii yənu tɩ̀án tə, də Zwifə-ba nəkwɩna tə yà yə̀ə́ də, zwansɩsara tə yɩ, Zwezi ma swɩ̀n ba mʋ̀ con. Ba dàń pɩ̀à, sə ba ja wá. Yá ba dàń yà nə dəri lɩ̀à tə fən. Ba yá wá, ba ga vìí. ");
INSERT INTO nnw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án, də Yɩɩ nii *yənu tɩ̀án, də ba *nəkwɩna tʋn *Farɩzɩan-ba duən, də *Erodə kwa lɩ̀à duən Zwezi con, sə ba ma ja ʋ də̀ń nə də bwiə don. ");
INSERT INTO nnw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba twi ba swɩ̀n ʋ con, ba wʋ́: «Karnyɩna, nə yə̀ə́ də, n yɩ cɩ́gá tíú. N ba lìù yii dəri, n yáá nə tə̀lə́ də dun tə ləzwənə nə jə yɩrɩ. Yá n ga bɩrɩ Yɩɩ cwəŋə tə də cɩ́gá. Swɩ̀n bɩrʋ nəba: Yɩɩ nii pɩn cwəŋə, sə nə ŋwɩ́n, nə à yə̀ə́, sə nə dàn ká ŋwɩ́n lanpoo, nə pa *Romə-ba pɩ̀ʋ́ nəfarʋ tə nə? Kʋ yɩ kálʋ́, sə nə ŋwɩ́n kʋ mʋ̀ naaa, nə à yə̀ə́ kʋ wà mɛ?» ");
INSERT INTO nnw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yá Zwezi yà yə̀ə́ də, ba yɩ níə́ bələ tɩ̀án. Ʋ ma swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn á ma pɩ̀à, sə á ja à də̀ń nə? Á pɩan nə cɩnɩa səbikʋlʋ nədʋ, sə à jə́n». ");
INSERT INTO nnw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba ma ja kʋ don ba ja bà, Zwezi dàń ma bwe ba, ʋ wʋ́: «Wàà yuu də ʋ yɩrɩ nə ba pʋ́pʋ́nɩ́ yəbə?» Ba ma le wá, ba wʋ́: «Romə-ba pɩ̀ʋ́ nəfarʋ tə nə!» ");
INSERT INTO nnw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Á ŋwɩ́án kʋ tə nə yɩ Romə-ba pɩ̀ʋ́ nəfarʋ tə nyiən, á pa wá, sə á ga ŋwɩ́n kʋ tə nə yɩ Yɩɩ nyiən, á pa Yɩɩ də nə!» Ʋ liu tə, ʋ nə le ba tə gwárɩ́ ba. ");
INSERT INTO nnw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Sadɩsɩan-ba mʋ̀ bɩrɩ də, tɩga bá pìí ba bwin ba naŋa. Ba wa lɩ̀à duən dàń twi Zwezi con, ba bwe wá, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Karnyɩna, *Moyizə pʋ́pʋ́nɩ́ Yɩɩ *nii kʋ tə, ʋ pa nəba, ʋ wʋ́: ‹Bɛɛ nə tɩga, ʋ yá ʋ kan nə, yá ʋ də ʋ kan tə wà bìú lʋrɩ, ʋ nyánʋ́ mɛ, sə ʋ tì kadənu tə. Ʋ lʋra bɩa ʋ nə, ʋ ma tún dwíí ʋ pa ʋ zʋnʋ tə nə tɩga tə nə›. ");
INSERT INTO nnw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yá nubɩa barpɛ duən yà nə wulə. Nəkwɩa tə swe, ʋ tɩ də ʋ tə wà bìú lʋrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Bələ tíú tə tì kadənu tə, ʋ də tɩga də ʋ ba bìú jə. Kʋ tətə nə tʋn batwa tíú tə də yɩra, də ba duən tə mɛ. ");
INSERT INTO nnw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kadənu tə dí nubɩa barpɛ tə mɛ duən kwa nə. Yá ʋ də ba lìù mama ga wà bìú duən nə lʋrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ba mɛ barpɛ tə jɩn wá, ba ma fwa ba kan. Kʋ mʋ̀ tə yɩrɩ, dɩɩn tə nə tɩga nə wá pìí ba bwin, wàà nə wá tɩnɩ kan tə?» ");
INSERT INTO nnw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zwezi ma le ba, ʋ wʋ́: «Á dwá á tɩ̀àn. Á nə yə̀rì Yɩɩ sagɩ tə, á ma yə̀rì Yɩɩ dɩ̀àn tə də yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Máŋá tə tɩga nə wá pìí ba bwin ba nan, bara də kana bá swe duən. Yá ba dàń wá yà ndə *malɩkɛ nə Yɩɩ *sàń wa. ");
INSERT INTO nnw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Á wà kàrɩ̀ kʋ tə, Yɩɩ nə swɩ̀n Moyizə sagɩ tə wa, tɩga ka pìí ka bwin ka nan tə yuu wa, naaa? Ʋ swɩ̀n yoo tə, kʋ nə nan Moyizə nə tuni tə wa. Lá nə Yɩɩ swɩ̀n Moyizə con, ʋ wʋ́: ‹À yɩ Yɩɩ tə, *Abərahamə də *Yɩzakə də *Zwakɔbə nə jʋ̀nɩ̀›.» ");
INSERT INTO nnw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Zwezi ma swɩ̀n ʋ súrí lá, ʋ wʋ́: «Kʋ nətʋ bɩrɩ də, Yɩɩ yɩ lɩ̀à tə, ba nə wulə mɩɩ wa Yɩɩ, ʋ tà tɩga Yɩɩ. Á dwá á tɩ̀àn mɩ́ámɩ́án». ");
INSERT INTO nnw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yɩɩ nii *yənu tíú don nì də, Zwezi də *Sadɩsɩan-ba wulə ba tʋ́tʋ̀nɩ́ duən. Ʋ yəni də, Zwezi le ba zəni. Ʋ dàń ma fàrʋ́ ʋ yí ʋ yɩra ʋ bwe wá, ʋ wʋ́: «Yɩɩ *nii yoo kwà nə dwə tə mama?» ");
INSERT INTO nnw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zwezi ma le wá, ʋ wʋ́: «Nə̀ń yoo kʋ tə, nə dwə tə mama. ‹*Yɩzərayɛlə-ba, á cʋga! *Yuu-Tiu don tə̀lə́, də kʋ nə tà Yɩɩ. Ʋ mʋ̀ nə yɩ nə Yuu-Tiu. ");
INSERT INTO nnw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","N mɛ, sə n sóní Yuu-Tiu, ʋ nə yɩ n Yɩɩ də n waa mama. N sóní kʋ tə nə ziən kʋ pa Yɩɩ nə. N bʋ́n Yɩɩ yoo máŋá mama. N kə n kajaŋa mama n pɩn Yɩɩ nə.› ");
INSERT INTO nnw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","N ga nə̀ń bələ nii nyiən: ‹N mɛ, sə n sóní n yɩra lìù, ndə n nə swə n tətə nətʋ›. Yɩɩ nii yoo don kʋ́ʋ̀ tə̀lə́, kʋ nə dwə tə tə bələ tə». ");
INSERT INTO nnw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yɩɩ nii yənu tíú tə ma swɩ̀n Zwezi con, ʋ wʋ́: «Karnyɩna, kʋ ziən. Kʋ tə, n nə swɩ̀n tə yɩ cɩ́gá cɩcɩ: Yɩɩ yɩ nədʋ, yá yɩa duən tə̀lə́ tə súrí ʋ mʋ̀ nə. ");
INSERT INTO nnw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ləzwənə mɛ, sə ʋ sóní Yɩɩ də ʋ waa mɛ. Ʋ mɛ, sə ʋ sóní kʋ tə nə ziən kʋ pa Yɩɩ nə. Ʋ mɛ, sə ʋ bʋ́n Yɩɩ nə máŋá mama. Ʋ mɛ, sə ʋ kə ʋ kajaŋa tə mama Yɩɩ nə. Ʋ mɛ, sə ʋ sóní ʋ yɩra lìù ndə ʋ tətə nə. Kʋ mʋ̀ nə kʋkwa ka gʋ vàná ka sʋrʋ ka pa Yɩɩ nə, də ka ŋwán wiən yiri mama». ");
INSERT INTO nnw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zwezi nɩ də, ʋ le də yənu, ʋ dàń ma swɩ̀n, ʋ wʋ́: «N ba ŋʋ́ná də Yɩɩ pàrɩ̀ tə». Kʋ kwa nə, lìù mama waa dɩ̀àn yà kʋ́ʋ̀ wà yí, sə ʋ kʋ́ʋ̀ bwe Zwezi bwiə don. ");
INSERT INTO nnw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zwezi nə wulə ʋ kàrɩ̀ lɩ̀à *Zwifə-ba Yɩɩ *dìə̀ wa, ʋ dàń bwe bwiə tə tə: «Nətə nə Yɩɩ nii *yənu tɩ̀án tə wàá ba swɩ̀n ba wʋ́, *Kərisə ʋ nə yɩ jonu tə, Yɩɩ nə kúrí, yɩ *Davidə nàʋ́? ");
INSERT INTO nnw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yɩɩ-*Siŋu tə cúə́ Davidə tətə yuu wa, ʋ ga swɩ̀n, ʋ wʋ́: ‹*Yuu-Tiu Yɩɩ swɩ̀n à Yuu-Tiu con, ʋ wʋ́: «Bàá jə̀ń à jɩzən nə, də à ma kəni n dʋŋa n nɛɛ də̀ń nə, sə n nɩŋa ba!» › ");
INSERT INTO nnw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Də Davidə tətə nə ja Kərisə, ʋ ma boŋə ‹Yuu-Tiu›, ʋ dàń wá twá nətə, ʋ ma kʋ́ʋ̀ ya ʋ nàʋ́ də?» Lɩ̀à zənzən yà cʋga Zwezi sʋ̀ràn tə də pupoli. ");
INSERT INTO nnw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ʋ swɩ̀n ba tə con, ʋ nə kàrɩ̀ tə, ʋ wʋ́: «Á cɩa á tɩ̀àn nə də Yɩɩ nii *yənu tɩ̀án tə. Ba mʋ̀ nə swə, sə ba zʋ gandaran ba ja jijiri. Ba ga swə, sə ba jʋn ba jə́rə́ bwálá wa. ");
INSERT INTO nnw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ba twá lá, ba kúrí gwələ tə, ba nə nàn zəni, *Zwifə-ba *jə́rə́ dii tə wa. Ba jəni bwálá nəzəŋə nə, diŋə nəfaran wa. ");
INSERT INTO nnw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba vɩrɩ kadənə wiən, ba ga fwa yɩjʋnɩ ba ba zwɛ̀e, ləzoni yáá con, sə ba ma bɩrɩ də, ba yɩ ləzwənzəŋə. Yɩɩ wá bʋ̀rɩ̀ ba bʋ̀rà, ʋ ga cʋ̀gʋ̀ ba mɩ́ámɩ́án». ");
INSERT INTO nnw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kʋ kwa nə, Zwezi jə̀ń Yɩɩ səbiu daka yikənə bwálɩ́ tə bɩan nə, *Zwifə-ba Yɩɩ *dìə̀ wa. Zwezi yà ywàŋá nətʋ tə, lɩ̀à nə kəni səbiu tə. Wiən tɩ̀án yà pɩn səbiu zənzən. ");
INSERT INTO nnw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kadənu zʋrʋ don twi ʋ tì səbibii bələ ʋ kə lá. ");
INSERT INTO nnw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Zwezi dàń ma bon ʋ karbɩa tə, ʋ swɩ̀n ba con, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Won tə, kan tə nə ken lá dáá, kʋ doni lɩ̀à tə mɛ nyiən. ");
INSERT INTO nnw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ba duən tə yɩ səbiu tə nə pàlɩ́ nə ba ken lá. Yá ʋ mʋ̀ də ʋ zʋrɩ tə mɛ, ʋ ken kʋ tə mama, ʋ yà nə jə, kʋ tə, ʋ yà nə ma kʋnɩ ʋ tɩ̀àn». ");
INSERT INTO nnw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Zwezi yà nə naŋa *Zwifə-ba Yɩɩ *dìə̀ tə wa máŋá tə nə, ʋ karbiu tə don swɩ̀n ʋ con, ʋ wʋ́: «Karnyɩna, ywàń Yɩɩ dìə̀ tə! Kʋ lwə̀ zəni! Kʋ ziən yii wa! Kʋ lwə̀ də kapana nəfaran!» ");
INSERT INTO nnw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zwezi ma le wá, ʋ wʋ́: «Dəfaran tə tə, n nə na, tə mɛ wá tʋ tə pú dɩɩn don nə. Kapan nədʋ tətə bá pə̀ń kʋ don yuu wa. Tə mama mɩ́ámɩ́án wá lwá tɩa». ");
INSERT INTO nnw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zwezi jə̀ń *oliviye tɩ̀án paan tə yuu wa. Kʋ paan tə wulə *Zwifə-ba Yɩɩ *dìə̀ tə yáá con. Ʋ karbɩa Piyɛrə də Zwakə də Zwan də Andəre cɩcɩ yà nə wulə də wá, ba bwe wá, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Man máŋá tə, kʋ nə wá tʋn n bɩrɩ nəba, də won tə, kʋ nə yɩ mɩmɩnʋ, kʋ nə bɩrɩ máŋá tə, tə wiən təntə mama nə wá bà». ");
INSERT INTO nnw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Zwezi ma le ba, ʋ wʋ́: «Á cɩa á tɩ̀àn nə, sə lìù mama dàn ká gɩgarɩ aba. ");
INSERT INTO nnw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lɩ̀à zənzən wá ja à yɩrɩ ba bà. Ba lìù mama ga wá swɩ̀n, ʋ wʋ́: ‹À mʋ̀ nə yɩ *Kərisə!› Yá ba wá gɩgarɩ lɩ̀à zənzən. ");
INSERT INTO nnw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Á nə nì kʋ̀ʋ̀ ŋwɛn də kʋ bwələ, á nə nì kʋ̀ʋ̀ ŋwɛn də kʋ ŋʋ́ná, fən dàn ká ja aba. Nətʋ nə kʋ mɛ, sə kʋ tʋn, yá kʋ ga tə tà lʋʋ zaŋʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dwíə́ tə lʋʋ mama wa wá ta, tə zɩgɩ duən nə. Yá payuu wá ta kʋ zɩgɩ kʋ don payuu nə. Tɩa wá səsəgi bwálá kapʋpʋ nə, niən də ga wá yà lá. Kʋ wá nyɩn ndə kapuə pùə́ yàá nə zàn ka yɩ̀, sə ʋ lʋra. ");
INSERT INTO nnw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Á cɩa á tɩ̀àn nə! Lɩ̀à wá ja aba, ba ma bʋ̀rɩ̀ bʋ̀rà. Ba wá mà aba də fɩfɩran *Zwifə-ba *jə́rə́ dii wa. Ba wá ja aba, ba ja va yáá tɩ̀án, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, də pɛ̀egá yáá con à mʋ̀ yɩrɩ, sə á swɩ̀n kʋ tə, á nə yə̀ə́ á bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yɩɩ sʋywáŋʋ́ tə mɛ, sə kʋ mʋ̀ nə də́ yáá kʋ swɩ̀n kʋ bɩrɩ lʋʋ tə mɛ nə, kʋ kwa nə, tə yìə̀n tə wá bà. ");
INSERT INTO nnw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yá máŋá tə nə, ba nə wá ja aba, sə ba ma bʋ̀rɩ̀ bʋ̀rà, kʋ tə ba tə, á nə wá swɩ̀n, á dànà ká də́ yáá á pa, kʋ mʋ̀ yoo ja aba. Kʋ máŋá tə wa, sə á swɩ̀n sʋ̀ràn tə nə wá bà á nii wa, tə nə ba á mʋ̀ naŋa, tə yɩ tə naŋa Yɩɩ-*Siŋu tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Lɩ̀à wá ja ba nubɩa ba pa, sə ba gʋ, yá bɩa nyɩna-ba də wá tʋn kʋ nyɩnyɩga də ba bɩa. Bɩa wá zàn ba zɩgɩ ba nyɩna-ba nə, ba gʋ ba. ");
INSERT INTO nnw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lɩ̀à tə mama wá dʋ́n aba, à mʋ̀ yɩrɩ. Yá lìù tə, ʋ nə wá ja pɩ́nʋ́, ʋ zɩgɩ ʋ dɩ̀àn kʋ yoo tə, kʋ va kʋ zwɛ̀e, kʋ tíú wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Á wá na wokʋkwɩʋn tə nə cʋ̀gà, də kʋ wulə bwálɩ́ tə nə, kʋ nə wà mɛ. (Sə lìù tə, ʋ nə kàrɩ̀, zùrì ʋ yɩra!) Kʋ máŋá tə wa, sə lɩ̀à tə, ba nə wá yà Zwide nagwanaa con, dəri ba dɩ̀ pɛɛn. ");
INSERT INTO nnw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lìù tə, ʋ nə wá yà dəyuu wa, kʋ́ʋ̀ dàn ká cú, ʋ dàn ká zʋ ʋ dìə̀, ʋ tì ʋ zɩla. ");
INSERT INTO nnw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yá lìù tə də, ʋ nə wá yà kárɩ́ wa, dàn ká pìí ʋ va sàń ʋ tì ʋ gànʋ̀ don. ");
INSERT INTO nnw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kʋ wá yà lɛɛ máŋá təntə wa, kʋ pa kana tə nə, ba nə jə pwìí, də ba tə nə, bɩa nə ŋwà ba nyʋnɩ nə! ");
INSERT INTO nnw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Á lòrì Yɩɩ, sə tə mʋ̀ càn təntə dàn ká yí yɩdɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kʋ mʋ̀ dɩan tə nii nə, càn tə wá doni càn tə mɛ nə yɩ lá. Kʋ nə zɩgɩ máŋá tə, Yɩɩ nə fwa lʋʋ, woyiri nətʋ tə wà twi, yá càn yiri təntə də kʋ́ʋ̀ bá bà abada. ");
INSERT INTO nnw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","*Yuu-Tiu nə wà dɩan tə nii lɩ ʋ ga ga, lìù mama yà bá jon ʋ mɩɩ. Yá ʋ dàń lɩ tə nii ʋ ga ga, ʋ lɩ̀à tə, ʋ nə kúrí, sə ba ya ʋ nyiən tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lìù dàń nə swɩ̀n á con, ʋ wʋ́: ‹Á ywàŋá, *Kərisə wulə yəbə!›, nə à yə̀ə́: ‹Á ywàŋá, ʋ wulə lá con!› Á dànà ká sɛ̀e kʋ tíú nii. ");
INSERT INTO nnw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kʋnkʋn Kərisə-ba də kʋnkʋn nii sʋ̀sʋ̀nà wá bà. Ba wá tʋn yikunu dɩ̀àn mɩmɩnan də yomɩlan. Də kʋ nə wàá, ba wá gɩgarɩ lɩ̀à tə tətə, Yɩɩ nə kúrí. ");
INSERT INTO nnw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Á mʋ̀ dàń ya cɩa á tɩ̀àn nə! À dí yáá à man tə à bɩrɩ aba. ");
INSERT INTO nnw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kʋ máŋá tə nə, càn təntə kwa nə, yìə̀n zənzən wá tʋn: Yɩcaʋ tə wá jì yikunu. Cànà tə kʋ́ʋ̀ bá ja poni. ");
INSERT INTO nnw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kacɩlacɛ wá nan lanworu wa tə tʋ. Yá dɩ̀àn tə, tə nə wulə lanworu tə wa, də wá gugurə. ");
INSERT INTO nnw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ba dàń wá na *Ləzwənə-Biu tə bakwan tə wa, də ʋ bɩ̀àn də dɩ̀àn tə nə dáá, də dun. ");
INSERT INTO nnw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ʋ wá tʋn *malɩkɛ lʋʋ sapara banɩa tə nə, lʋʋ yɛɛ tə mɛ nə, sə ba kə lɩ̀à tə, Yɩɩ nə kúrí, tə duən nə». ");
INSERT INTO nnw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á nəŋə yoo tə, à nə pɩ̀à, sə à twá kapɩrʋ tə kàrà tə nə, à swɩ̀n: Máŋá tə nə, kʋ nɛɛ tə nə yɩ wobwalan, yá kʋ ga twè vʋran, á yə̀ə́ də, sii bwələ. ");
INSERT INTO nnw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mə kʋ yɩ nətʋ, də á nə nɩ tə wiən təntə, à nə swɩ̀n tə yoo, á mɛ, sə á lwarɩ də, *Ləzwənə-Biu túrí tə bwələ. Ʋ wulə cwəŋə wa, ʋ yí ʋ zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ yoo təntə wá tʋn, də zə̀n lɩ̀à tə mama, ba nə wulə tɩa yuu wa, tə wà tɩ ba zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lanworu də tɩa mɛ wá jén, yá à sʋ̀ràn tə mʋ̀ bá jén, abada!» ");
INSERT INTO nnw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Lìù mama yə̀rì dɩɩn tə, nə à yə̀ə́ máŋá tə, yìə̀n təntə nə wá tʋn. *Malɩkɛ tə Yɩɩ *sàń nə, də Yɩɩ-Biu tə tətə yə̀rì kʋ. À nyɩna Yɩɩ cɩcɩ nə yə̀ə́. ");
INSERT INTO nnw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Á cɩa á tɩ̀àn nə, á dànà ká dwɛ̀e, á nə yə̀rì máŋá tə kʋ nə wá tʋn yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","À vəru də à ka pìí ka bà wá yà nətʋ: Bɛɛ don vələ cwəŋə. Ʋ nan ʋ yá ʋ sàń ʋ pa ʋ tʋ̀tʋ̀nà nə. Ʋ pɩn ba lìù mama tʋtʋŋɩ. Yá ʋ ga swɩ̀n lìù tə nə cɩ̀ mimii tə nə, sə kʋ tíú súrú ʋ yɩ́á zəni. ");
INSERT INTO nnw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Á dàń súrə́ á yɩ́á zəni, á nə yə̀rì máŋá tə, dìə̀ tíú nə wá pìí ʋ bà yɩrɩ. Ʋ nə pìí ʋ bà, ʋ dɩ̀ á yuu, ʋ wà mɛ, sə ʋ na aba, də á dwɛ̀e. Ʋ túrí tə wàá dədəni kʋ yanɩ, nə à yə̀ə́ tɩtɩn kwɩʋn nə, cəbɩa kurə máŋá wa, nə à yə̀ə́ jɩjʋ nə. ");
INSERT INTO nnw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kʋ tə à nə swɩ̀n á con yəbə, kʋ mʋ̀ nə à swɩ̀n lɩ̀à tə mɛ con: Á súrə́ á yɩ́á!» ");
INSERT INTO nnw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kʋ ga dɩan bələ, sə *Pakə cànà tə də́. Kʋ máŋá tə wa nə, *Zwifə-ba tə yàá də́ dipɛn tə, kʋ nə ba sabwarɩ kəni. *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án, də Yɩɩ nii *yənu tɩ̀án yà pɩ̀à, sə ba tʋn yɩ́á swɩan, ba ja Zwezi ba gʋ. ");
INSERT INTO nnw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ba yà swɩ̀n də duən, ba wʋ́: «Nə wà mɛ, sə nə ja wá cànà tə máŋá wa, sə gurəgurə dàn ká zàn lalʋʋ tə tətəŋi wa». ");
INSERT INTO nnw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zwezi yà wulə Betani nə, Simon tə, ʋ yà nə yɩ dayarʋ, dìə̀ wa. Máŋá tə wa, ʋ wulə ʋ də́, kan don zʋa. Ʋ yà jə pɩ̀ʋ̀ kapan kunkoli, ba nə boŋə ‹alɩbatɩrɩ›. Tɩralɩ nʋga yà wulə kʋ wa, kʋ yɩ ba fwa narədə paa tətə, yá kʋ kwənə də ga dáá. Ʋ lwə kunkoli tə, ʋ tì tɩralɩ nʋga tə ʋ lwá Zwezi yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kʋ wà ywánɩ́ yɩ kʋ pa lɩ̀à tə duən yà nə jə̀ə́ lá, yá ba dàń swɩ̀n duən con, ba wʋ́: «Tɩralɩ nʋga kʋ tə ka cʋ̀gʋ̀ tə ba də̀ń jə. ");
INSERT INTO nnw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ba yà wàá kʋ ba tì ba yə̀ cɩnɩa səbikʋlan biətwa, ba pɩn səbiu tə zʋra nə». Ba lɩŋa dàń zàn zəni kan tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yá Zwezi swɩ̀n ba con, ʋ wʋ́: «Á yaga wá sənbwen. Bɛ̀eɛ̀e yɩrɩ nə á ma cʋ̀gà ʋ pùə́ nə? Kʋ tə, ʋ nə fwa ʋ pa nə, tə ziən. ");
INSERT INTO nnw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Zʋra wulə də aba máŋá mama. Á wàá ba zəni á fwa máŋá tə, á nə swə. Yá à mʋ̀ ga bá ya də aba máŋá mama. ");
INSERT INTO nnw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ʋ fwa ʋ dɩ̀àn maŋa. Ʋ manwarɩ ʋ lwə́ tɩralɩ nʋga à yɩra nə, sə ʋ ma kwɛn tə, tə nə wá zʋ ləbəri wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Bwálɩ́ tə mama wa, ba nə wá swɩ̀n Yɩɩ sʋywáŋʋ́ tə lʋʋ mama wa, ba wá man kʋ tə, kan wà tə nə tʋn, sə ba ma lìí ʋ nə». ");
INSERT INTO nnw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yisəkariyɔtə Zwidasə, Zwezi karbɩa fugə bələ tə wa lìù don, dàń vəli ʋ swɩ̀n *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə con də, ʋ mʋ̀ pɩ̀à, sə ʋ kə Zwezi ba jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba nə nì kʋ nətʋ, kʋ poli ba pùə́. Ba dàń ga swɩ̀n də, ba wá pa wá səbiu. Zwidasə dàń yà wulə ʋ pɩ̀à cwəŋə nəzəŋu, sə ʋ ma kə Zwezi ba jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kʋ yɩ cànà tə təntən dɩɩn tə nə, *Zwifə-ba nə də́ dipɛn tə, kʋ nə ba sabwarɩ kəni. Kʋ dɩɩn tə nə, ba yàá gʋ pabii, sə ba ma fwa *Pakə cànà wodiu. Kʋ máŋá tə wa, Zwezi karbɩa tə bwe wá, ba wʋ́: «Yə̀n nə n pɩ̀à, sə nə va nə tanɩ Pakə cànà wodiu?» ");
INSERT INTO nnw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Zwezi dàń ma tʋn ʋ karbɩa bələ, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á vələ *Zwerizalɛmə wa. Á wá jə́rí bɛɛ də ʋ zɩŋa nɩ́á kwàrá, sə á pú kʋ bɛɛ tə kwa. ");
INSERT INTO nnw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bwálɩ́ tə, ʋ nə zʋa, sə á swɩ̀n dìə̀ tə tíú con, á wʋ́: ‹Karnyɩna bwe, sə ʋ jə́n dìə̀ tə, ʋ də ʋ karbɩa tə nə wá də́ Pakə cànà wodiu ka wà tə, wa yə̀n?› ");
INSERT INTO nnw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ʋ dàń wá bɩrɩ aba dəyuu dìə̀ nəfarʋ don, də ba kwɛn ka də zɩla, tə nə mɛ. Mə lá nə á wá tanɩ nə cànà tə wodiu». ");
INSERT INTO nnw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ʋ karbɩa tə vəli tɩʋ tə wa, ba nɩ tə yìə̀n tə, ndə Zwezi yà nə man ʋ bɩrɩ ba nətʋ tə. Ba dàń ga tanɩ Pakə cànà wodiu tə lá nə. ");
INSERT INTO nnw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Máŋá tə dədəni nə yí, Zwezi twi də ʋ karbɩa fugə bələ tə. ");
INSERT INTO nnw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Máŋá tə, ba nə jə̀ń, ba wulə ba də́ tə, Zwezi swɩ̀n, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á mʋ̀ lɩ̀à tə, á nə wulə á də́ də nə, á lìù don wá ja nə ʋ pa». ");
INSERT INTO nnw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ʋ karbɩa tə mɛ pwìí cʋ̀gʋ̀, yá ba dàń ga wulə wá, ba bwe duən də̀ń nə, ba wʋ́: «Kʋ ya à mʋ̀, naaa?» ");
INSERT INTO nnw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Zwezi ma le ba, ʋ wʋ́: «Kʋ yɩ á mʋ̀ fugə bələ tə wa lìù don nə. Kʋ tíú də twá ʋ kuli ʋ dipɛn tə də nə zʋŋa nədʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","*Ləzwənə-Biu wá tɩ, ndə kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa nətʋ tə. Yá kʋ dàń wá yà càn kʋ pa lìù təntə nə, ʋ nə wá ja Ləzwənə-Biu tə ʋ pa. Ba yà nə wà kʋ bɛɛ tə lʋrɩ, kʋ yà kʋkwa». ");
INSERT INTO nnw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Máŋá tə wa, ba nə wulə ba də́, Zwezi tì dipɛn, ʋ kə Yɩɩ lɛ̀eɛ̀e kʋ yɩrɩ. Kʋ kwa nə, ʋ fʋa fʋa kʋ, ʋ pa ʋ karbɩa tə nə, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á joŋə kʋ tə, kʋ yɩ à yɩra tə nə!» ");
INSERT INTO nnw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kʋ kwa nə, ʋ tì divɛn wùrú zʋŋa, ʋ kə Yɩɩ lɛ̀eɛ̀e ka yɩrɩ, ʋ ga tì ka ʋ pa ba. Ba mɛ nyʋa. ");
INSERT INTO nnw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Zwezi swɩ̀n ba con, ʋ wʋ́: «Kʋ tə yɩ à mʋ̀ jana nə. Jana təntə nə bɩrɩ á də Yɩɩ *nimarʋ tə. Jana təntə nə wá nan, lɩ̀à zənzən yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: À kʋ́ʋ̀ bá nyʋ divɛn kʋ tə, kʋ ja vələ dɩɩn tə, à nə kʋ́ʋ̀ wá nyʋ kʋ Yɩɩ *sàń nə». ");
INSERT INTO nnw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kʋ kwa nə, ba nun cànà tə nuŋi, ba ga zàn ba va paan tə yuu wa, ba nə boŋə ‹*oliviye tɩ̀án paan›. ");
INSERT INTO nnw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zwezi swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á mama wá vɩ nə á dʋgʋ. Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹À wá gʋ payɩrʋ tə, pee tə wá laga duən yáá nə›. ");
INSERT INTO nnw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yá máŋá tə wa, à nə wá pìí à bwin à nan, kʋ kwa nə, à wá va à dɩ̀àn aba Galile nagwanaa wa». ");
INSERT INTO nnw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyɛrə ma swɩ̀n ʋ con, ʋ wʋ́: «Lɩ̀à mama nə swə ba vɩ mʋ́ ba dʋgʋ, à mʋ̀ bá mʋ́ vɩ à dʋgʋ». ");
INSERT INTO nnw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Zwezi ma le wá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: Zə̀n tɩtɩn kʋ tə tətə mama, də cəbɩʋ tə wà kwi nɛɛ bələ, n wá tɛn nɛɛ batwa də, n yə̀rì nə». ");
INSERT INTO nnw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piyɛrə ma kwɛn ʋ swɩ̀n ʋ kə yɩɩ nə, ʋ wʋ́: «À bá swɩ̀n mama də, à yə̀rì mʋ́, də kʋ nə swə kʋ yɩ, à wá tɩ də mʋ́». Ʋ karbɩa tə duən tə də swɩ̀n kʋ mʋ̀ yoo nədʋ təntə. ");
INSERT INTO nnw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kʋ kwa nə, Zwezi də ʋ karbɩa tə dàń vəli ba yí bwálɩ́ tə, ba nə boŋə ‹Zwesemane›. Zwezi swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á jənə yəbə, də à vələ yáá, sə à jʋn Yɩɩ». ");
INSERT INTO nnw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ʋ jɩn Piyɛrə də Zwakə də Zwan, ʋ ja va yáá. Yá fən də pucʋnɩ wulə tə zwɩ wá. ");
INSERT INTO nnw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Tɩan pucʋnɩ súə́ nə. Á jənə yəbə, á dànà ká dwɛ̀e!» ");
INSERT INTO nnw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ʋ dàń ma va yáá mancɩn, ʋ tʋ tɩa ʋ yáá yuu, ʋ ga lòrì Yɩɩ, ʋ wʋ́: «Kʋ yà nə wàá, sə càn máŋá kʋ tə va yɩŋʋna kʋ yá nə». ");
INSERT INTO nnw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ʋ swɩ̀n, ʋ wʋ́: «Baba, à nyɩna, wiən tə mɛ wàá tə tʋŋa n con nə. Pa, sə yacara tətə twiən tə yá nə. Yá kʋ nə tà, sə kʋ tʋn, ndə à mʋ̀ nə pɩ̀à nətʋ, kʋ yɩ, sə kʋ tʋn ndə n mʋ̀ nə nə pɩ̀à nətʋ tə». ");
INSERT INTO nnw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kʋ kwa nə, ʋ pìí ʋ bà ʋ karbɩa batwa tə con, də ba dwɛ̀e. Ʋ ma bwe Piyɛrə, ʋ wʋ́: «Simon, n dwɛ̀e naaa? N wà wànɩ́ n súrí n yɩ́á, n dɩ̀àn nə lugu nədʋ də tətə? ");
INSERT INTO nnw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Á súrə́ á yɩ́á, á ga lòrì Yɩɩ, sə ʋ san aba, sə *Sɩtana dàn ká wànɩ́ aba, ʋ də́də́n, sə ʋ yigu, ʋ pa á tʋn yokʋkwɩʋn. Ləzwənə pubʋŋa mʋ̀ yàá pɩ̀à, sə kʋ fwa zəni, yá ʋ yɩra ga ba dɩ̀àn jə kʋ fwa kʋ». ");
INSERT INTO nnw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ʋ kʋ́ʋ̀ lɛ ʋ va yɩŋʋna, ʋ lòrì Yɩɩ, ʋ tə ga bwé tə sʋ̀ràn təntə tətə. ");
INSERT INTO nnw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ʋ ga kʋ́ʋ̀ pìí ʋ bà ʋ karbɩa tə con. Ʋ kʋ́ʋ̀ yí də ba dwɛ̀e, ba wàrɩ̀ ba yɩ́á ba súrí dwɩan tə yɩrɩ. Ba yà kʋ́ʋ̀ yə̀rì yoo tə, ba nə wá swɩ̀n ʋ con. ");
INSERT INTO nnw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ʋ nə pìí ʋ bà kʋ batwa tə nə, ʋ swɩ̀n ba con, ʋ wʋ́: «Á tə yɩ á tə́gə́ á dwɛ̀e? Kʋ mɛ nətʋ! Máŋá yí. Á nəŋə, ba wá ja *Ləzwənə-Biu, ba kə cʋna lɩ̀à tə jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Á zaŋa yɩɩ nə, nə virə! Á nəŋə, bɛɛ tə nə wá ja nə ʋ pa, tə bwələ yəbə». ");
INSERT INTO nnw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zwezi yà tə wulə ʋ swɩ̀n, lala də Zwidasə yí. Ʋ də yà yɩ ʋ karbɩa fugə bələ tə wa lìù don. Lalʋʋ yà wulə ʋ kwa də ba jɩ̀àn lagʋrɩ sɩ̀án də dangwələn. Ba yɩ *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án, də ba *nəkwɩna tə yà nə tʋn ba. ");
INSERT INTO nnw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zwidasə, bɛɛ tə nə wá ja Zwezi ʋ pa tə, bɩrɩ lɩ̀à tə nətʋ tə, ʋ yà nə wá fwa: «Bɛɛ tə, à nə wá ja à kʋkwalɩ tə, mə ʋ mʋ̀ nə, á nə pɩ̀à. Á jana wá, á cɩa ʋ nə zəni». ");
INSERT INTO nnw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Máŋá tə Zwidasə nə yí, lala də ʋ fàrʋ́ ʋ yí Zwezi yɩra, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Karnyɩna!» Ʋ dàń ga kʋkwalɩ wá. ");
INSERT INTO nnw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ba duən tə dàń ma ja Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yá karbɩa tə yà nə wulə lá tə wa lìù don cʋrɩ ʋ lagʋrɩ sɩ̀ʋ́, ʋ ma za Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə tʋ̀tʋ̀nʋ̀ zɩɩn ʋ gwəŋə. ");
INSERT INTO nnw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Zwezi swɩ̀n ba con, ʋ wʋ́: «Á twi də lagʋrɩ sɩ̀án də dangwələn, sə á ma ja nə, ndə à yɩ ŋwɩ̀àn tə, à nə gwɩ lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dɩɩn mama, à yà wulə də aba, à yà kàrɩ̀ lɩ̀à *Zwifə-ba Yɩɩ *dìə̀ tə wa, á ga wà nə jɩn. Yá kʋ tə dàń tʋn, sə kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa nii ma sú». ");
INSERT INTO nnw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ʋ karbɩa tə mɛ dàń yá wá, ba ga dəri. ");
INSERT INTO nnw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Balandʋrʋ don yà púə́ Zwezi kwa. Ganyaʋ cɩcɩ nə ʋ yà bɩbarɩ. Lɩ̀à tə yà pɩ̀à, sə ba ja wá, ");
INSERT INTO nnw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yá ʋ pɩ̀rʋ́ ʋ jon, ʋ dʋgʋ ganyaʋ tə, ʋ ga dəri də ʋ yaswələ. ");
INSERT INTO nnw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lɩ̀à tə jɩn Zwezi, ba ja va *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə sàń. Yɩɩ joŋwana yun tɩ̀án tə, də Zwifə-ba *nəkwɩna tə, də Yɩɩ nii *yənu tɩ̀án tə yà kun kʋ bwálɩ́ təntə nə. ");
INSERT INTO nnw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyɛrə yà púə́ Zwezi kwa yɩŋʋna. Ʋ zʋa Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə dəwoo wa. Ʋ jə̀ə́ lantə də Yɩɩ *dìə̀ lɩ̀à tə nə cɩ̀ ka nə, ʋ ywèrì mən. ");
INSERT INTO nnw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yɩɩ joŋwana yun tɩ̀án tə, də yun tɩ̀án tə duən mama, ba nə bʋ̀rɩ̀ *bʋ̀rà tə, yà pɩ̀à yoo, sə ba kə Zwezi yuu wa. Ba yà pɩ̀à, sə ba gʋ wá, yá ba ba yoo mama na. ");
INSERT INTO nnw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lɩ̀à nə dáá yà kʋnɩ kʋnkʋn ba kəni Zwezi nii nə, yá ba níə́ yà ba duən twá. ");
INSERT INTO nnw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ba duən dàń ma zàn ba kʋna kʋnkʋn tə tə, ba kə ʋ nii nə, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Nə nì də, ʋ swɩ̀n, ʋ wʋ́: ‹À wá mà Zwifə-ba Yɩɩ dìə̀ ka tə, lɩ̀à nə lwə̀. Dɩan batwa nii nə, à wá lwà ka don, ka nə bá yà ləzoni nə lwə̀›.» ");
INSERT INTO nnw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yá də kʋ mʋ̀ yoo təntə mɛ, ba níə́ yà tə ba duən twá. ");
INSERT INTO nnw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə dàń ma zàn lɩ̀à tə mɛ yáá nə, ʋ bwe Zwezi, ʋ wʋ́: «N ba yoo le, naaa? Bɛ̀eɛ̀e nə lɩ̀à ba tə swɩ̀n, ba kəni n yuu wa?» ");
INSERT INTO nnw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yá Zwezi púə́ ʋ nii, ʋ ga ba yoo swɩ̀n. Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə kʋ́ʋ̀ bwe wá, ʋ wʋ́: «N yɩ *Kərisə tə, ʋ nə yɩ Yɩɩ tə, ba nə bwɩ, ʋ nə bìú naaa?» ");
INSERT INTO nnw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Zwezi ma le, ʋ wʋ́: «À mʋ̀ nə yɩ wá. Á ga wá na *Ləzwənə-Biu, də ʋ jə̀ə́ Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, jɩzən nə. Á wá na wá də ʋ naŋa lanworu bakwan tə wa, ʋ bɩ̀àn». ");
INSERT INTO nnw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə dàń ma cɩrʋ ʋ gànʋ̀ də lɩŋa, ʋ ga swɩ̀n, ʋ wʋ́: «Nə kʋ́ʋ̀ ba lɩ̀à pɩ̀à, sə ba bɩrɩ nəba yoo don. ");
INSERT INTO nnw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Á nì, ʋ nə swɩ̀n ʋ twɩn Yɩɩ nətʋ. Bɛ̀eɛ̀e nə á bʋŋa kʋ yuu wa?» Ba mɛ dàń ma swɩ̀n də, ʋ mɛ, sə ba bʋ̀rɩ̀ ʋ bʋ̀rà, sə ba gʋ wá. ");
INSERT INTO nnw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ba duən dàń ga pi mɩmɩan ba lwá Zwezi yuu wa. Ba pú ʋ yɩ́á nə, ba mà wá də jɩgungulə, yá ba ga swɩ̀n ʋ con, ba wʋ́: «Lwarɩ lìù tə nə fwa mʋ́ kʋ tə!» Yɩɩ dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə jɩn Zwezi, ba farʋ ʋ pɩpara nə. ");
INSERT INTO nnw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piyɛrə yà tə nə wulə dəwoo tə wa, də nə̀ń Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə tʋtʋnbʋa nə ʋ yí. ");
INSERT INTO nnw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ʋ nɩ Piyɛrə, də ʋ wulə ʋ ywèrì mən tə, ʋ ywàń wá zəni, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «N mʋ̀, n də yà wulə də *Nazarɛtə Zwezi tə». ");
INSERT INTO nnw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yá Piyɛrə dàń tɛn, ʋ wʋ́: «À yə̀rì kʋ tə, n nə wulə n swɩ̀n tə, à ba kʋ də̀ń nə̀ń». Ʋ nə zàn ʋ nan dəwoo tə wa, ʋ zʋ kwələ wa, cəbɩʋ nə kʋ kwi. ");
INSERT INTO nnw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yá tʋtʋnbʋa tə nə nɩ wá kʋ́ʋ̀ zàn ʋ swɩ̀n lɩ̀à tə, yà nə wulə lá tə con, ʋ wʋ́: «Bɛɛ wà tə yɩ ba wa lìù don». Piyɛrə ma kʋ́ʋ̀ tɛn kʋ. ");
INSERT INTO nnw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kʋ fwa mɛ̀e, də lɩ̀à tə, ba nə wulə lá, tə kʋ́ʋ̀ swɩ̀n Piyɛrə con, ba wʋ́: «N də cɩ́gá yɩ ba wa lìù don, n də nə yɩ Galile tíú tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piyɛrə dàń ma dù, ʋ wʋ́: «Sə Yɩɩ cʋ̀gʋ̀ nə, də à nə kʋnɩ. À dùə̀ də, à yə̀rì bɛɛ tə, á nə swɩ̀n ʋ yoo». ");
INSERT INTO nnw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kʋ máŋá tə nə, də cəbɩʋ tə kʋ́ʋ̀ kwi nɛɛ bələ nii nə. Piyɛrə dàń ma lìí kʋ tə, Zwezi yà nə swɩ̀n ʋ con, ʋ wʋ́: «Də cəbɩʋ tə nə wà kwi nɛɛ bələ, n wá tɛn nɛɛ batwa də, n yə̀rì nə». Ʋ dàń ma wulə ʋ kwi. ");
INSERT INTO nnw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jɩjʋ fuən fuən, *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án, də ba *nəkwɩna, də Yɩɩ nii *yənu tɩ̀án, də yun tɩ̀án tə duən mɛ, ba nə bʋ̀rɩ̀ *bʋ̀rà tə, kun duən nə, ba vʋrʋ, sə ba na won tə, ba nə wá ma fwa Zwezi. Ba jɩn wá, ba vwa ba ja va ba pa *Pilatə nə. ");
INSERT INTO nnw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatə dàń bwe wá, ʋ wʋ́: «N mʋ̀ nə yɩ Zwifə-ba pɩ̀ʋ́ tə?» Zwezi ma le wá, ʋ wʋ́: «Mə kʋ yɩ nətʋ, ndə n nə swɩ̀n tə!» ");
INSERT INTO nnw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yɩɩ joŋwana yun tɩ̀án yà jə yìə̀n, ba ja zɩga Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatə ma kʋ́ʋ̀ kwɛn ʋ bwe wá, ʋ wʋ́: «N nə̀ń yìə̀n tə, ba nə kəni n yuu wa! N bá sʋgʋ jə?» ");
INSERT INTO nnw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yá Zwezi kʋ́ʋ̀ wà yoo mama le, kʋ pa kʋ gwárɩ́ Pilatə. ");
INSERT INTO nnw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","*Pakə cànà mama nə yí, *Pilatə yàá dʋgʋ bàń dìə̀ lìù don, wà tə lɩ̀à tə mama nə yàá lòrì, sə ʋ dʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bɛɛ don, ba nə boŋə Barabasə, yà wulə bàń dìə̀ wa. Ʋ yà wulə lá də lɩ̀à duən, ʋ də ba nə sugu lɩ̀à, ba kə *Romə-ba yáá tɩ̀án tə nə, máŋá don wa, yá ba ga gʋ lìù yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lalʋʋ tə dàń ma dɩ̀ Pilatə con. Ba ma lòrì wá kʋ tə, ʋ yàá nə fwa ʋ pa ba Pakə cànà máŋá mama wa, sə ʋ fwa kʋ ʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatə ma bwe ba, ʋ wʋ́: «Á pɩ̀à, sə à dʋgʋ *Zwifə-ba pɩ̀ʋ́ tə naaa?» ");
INSERT INTO nnw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ʋ yà yə̀ə́ Yɩɩ *joŋwana yun tɩ̀án tə nə ja Zwezi ba bà ʋ con tə də̀ń. Ba pɩn wá Zwezi, ba yà nə jə wʋgwɩʋ də wá tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yá Yɩɩ joŋwana yun tɩ̀án tə sugu lalʋʋ tə, sə ba lòrì Pilatə, sə ʋ dʋgʋ Barabasə mʋ̀ʋ́. ");
INSERT INTO nnw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatə ma kʋ́ʋ̀ bwe lɩ̀à tə, ʋ wʋ́: «Bɛ̀eɛ̀e nə á dàń pɩ̀à, sə à ja ʋ tə, á nə ma boŋə ‹Zwifə-ba pɩ̀ʋ́› tə, à ma fwa?» ");
INSERT INTO nnw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ba ma le wá, də ba cə̀rí, ba wʋ́: «Pa, sə ba paa wá dagarʋ yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatə ma bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e yokʋkwɩʋn nə ʋ fwa?» Yá ba kʋ kwɛn ba cə̀rí, ba kə yɩɩ nə, ba wʋ́: «Pa, sə ba paa wá dagarʋ yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatə yà pɩ̀à, sə ʋ poli lalʋʋ tə pùə́, ʋ dàń ma zàn ʋ dʋgʋ Barabasə, ʋ pa ba. Kʋ kwa nə, ʋ pɩn ba mà Zwezi də fɩfɩran, ʋ ga tì wá ʋ pa, sə ba paa wá dagarʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pamana tə jɩn Zwezi, ba ja zʋ yáá tíú tə dəwoo wa, bʋ̀rà dìə̀ tə nə wulə lá. Ba dàń ga bon ba duən pamana tə mɛ. ");
INSERT INTO nnw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ba tì gansɩan mwin, ba ma zʋ Zwezi, ba sʋ casʋran yupuu, ba tún ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ba dàń ga wulə ba jʋ̀nɩ̀ wá, ba wʋ́: «Nə jʋ̀nɩ̀ mʋ́, *Zwifə-ba pɩ̀ʋ́!» ");
INSERT INTO nnw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ba dàń ga mà ʋ yuu nə də mɩʋ. Ba pi mɩmɩan ba lwá ʋ yuu wa. Ba dàń ga toli ba nadwana yuu, ba kwé tɩa ʋ yáá con. ");
INSERT INTO nnw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba nə mʋn wá ba zwɛ̀e, ba lɩ gansɩan mwin tə, ba ga kʋ́ʋ̀ pìí ba zʋ wá ʋ tətə ganan tə. Kʋ kwa nə, ba jɩn wá ba va, sə ba paa dagarʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Máŋá tə, Zwezi də pamana tə nə wulə cwəŋə wa, ba jə́rí bɛɛ don, ba nə boŋə Sirɛnə Simon. Ʋ yɩ Alɛkəzandərə də Rifisə nyɩna. Ʋ yà yɩ ʋ naŋa ʋ kárá wa. Pamana tə kálʋ́ ba pa ʋ zɩn Zwezi dagarʋ tə. ");
INSERT INTO nnw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba jɩn Zwezi ba ja va bwálɩ́ don, ba nə boŋə ‹Goləgʋta›. Kʋ də̀ń nə yɩ ‹yuzʋŋa bwálɩ́›. ");
INSERT INTO nnw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba yà pɩ̀à, sə ba pa wá divɛn, ba nə gùlí yacara tɩ̀ʋ́, ba nə boŋə ‹mirə› tə wa, yá Zwezi vɩga. ");
INSERT INTO nnw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kʋ kwa nə, ba paa wá dagarʋ tə yuu wa. Ba tá kwé ba ma tara ʋ ganan, sə ba na kʋ tə, ba lìù mama nə wá tì. ");
INSERT INTO nnw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ba paa wá jɩjʋ lugu nʋgʋ máŋá wa. ");
INSERT INTO nnw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Daʋ tə yuu, ba ken pʋ́pʋ́ná duən lá nə, tə nə bɩrɩ won tə, kʋ nə pɩn, ba ma gʋ wá. Kʋ pʋ́pʋ́nɩ́, kʋ wʋ́: ‹*Zwifə-ba pɩ̀ʋ́›. ");
INSERT INTO nnw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ba paa ŋwɩna bələ duən, ba nə gwɩ lɩ̀à, kʋ máŋá tə wa kʋ bwálɩ́ təntə nə də Zwezi. Ʋ don yɩ ʋ jɩzən yuu, ʋ don tə yɩ ʋ jɩgwiə yuu. ");
INSERT INTO nnw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kʋ tʋn nətʋ, sə kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, nii ma sú: «Ba gàlɩ̀ wá ba kə yolwanfwana wa». ");
INSERT INTO nnw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lɩ̀à tə, ba nə twá lá, ba lɛ yàá vuvugu ba yuu, ba ga twɩn wá: «Həyi! N mʋ̀ lìù tə, n yà nə pɩ̀à, sə n mà Zwifə-ba Yɩɩ *dìə̀ tə, n ga lwà ka don dɩan batwa nii nə. ");
INSERT INTO nnw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","N tətə dàń jon n tɩ̀àn! Nan dagarʋ tə yuu n cú». ");
INSERT INTO nnw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə də yà mʋŋa Zwezi, ba ga swɩ̀n duən con, ba wʋ́: «Ʋ wàá lɩ̀à duən ʋ joŋə, yá ʋ wàrɩ̀ ʋ tətə ʋ joŋə. ");
INSERT INTO nnw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ʋ mʋ̀ lìù tə, ʋ nə wʋ́, ʋ yɩ *Kərisə tə, ʋ nə yɩ *Yɩzərayɛlə pɩ̀ʋ́, ʋ dàń nan dagarʋ tə yuu ʋ cú sɩ́ʋ́n. Nə nə nɩ kʋ mʋ̀ təntə, nə dàń wá kə nə waa ʋ nə». Lɩ̀à tə, ba yà nə paa Zwezi səpuni nə də yà twɩn wá. ");
INSERT INTO nnw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yikunu púə́ tɩa tə mɛ nə, kʋ nə zɩgɩ yɩcaʋ lugu fugə bələ máŋá, kʋ ja va dədəni lugu batwa. ");
INSERT INTO nnw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yá lugu batwa máŋá nə yí, Zwezi bubwi ʋ kə yɩɩ nə də ʋ lʋʋ sʋgʋ, ʋ wʋ́: «Eloyi, Eloyi, lama sabatanɩ?» Kʋ də̀ń nə yɩ: «À Yɩɩ, à Yɩɩ, bɛ̀eɛ̀e nə pɩn, n ma vɩ nə n dʋgʋ?» ");
INSERT INTO nnw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lɩ̀à tə duən yà nə wulə lá nì ʋ kori, ba ga swɩ̀n, ba wʋ́: «Á cʋga, ʋ boŋə Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli». ");
INSERT INTO nnw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ba lìù don dəri ʋ va ʋ tì canfɩnsɩʋ, ʋ lə divɛn nyʋnʋ wa. Ʋ tì kʋ ʋ vwa mɩʋ nii nə, ʋ làrɩ̀ Zwezi nə, sə ʋ nyʋ. Ʋ ga swɩ̀n, ʋ wʋ́: «Á zɩga, nə wá na də, Eli nə wá bà ʋ cú wá dagarʋ tə yuu». ");
INSERT INTO nnw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yá Zwezi bubwi ʋ kə yɩɩ nə, ʋ mɩɩ ga zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","*Zwifə-ba Yɩɩ *dìə̀ tə wa, mimii gànʋ̀ zɩgɩ yɩɩ nə, kʋ cɩrɩ kʋ cú tɩa, kʋ pwɛ̀e bələ. ");
INSERT INTO nnw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","*Romə-ba pamana bíí yuu tíú yà nə zɩga Zwezi yáá con, nɩ nətʋ ʋ nə tɩga, ʋ swɩ̀n, ʋ wʋ́: «Bɛɛ tə cɩ́gá yà yɩ Yɩɩ-Biu!» ");
INSERT INTO nnw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kana duən də yà zɩga yɩŋʋna, ba ywàŋá. Mari Madəlɛnə, də Zwakə nəmaa də Zwoze nuu Mari, də Salome də yà wulə ba wa. ");
INSERT INTO nnw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ba kana təntə yà púə́ Zwezi kwa, máŋá tə, ʋ yà nə wulə Galile nagwanaa wa, ba tʋŋa ba pɩn wá. Kana duən də yà wulə lá, ba nə twá ʋ nə ba va *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Dədəni twi kʋ yí, ba ga wulə ba kəni *Zwifə-ba *sìə́ dɩɩn tə sírí. Kʋ máŋá tə wa, Arimate Zwʋzɛfə yí bwálɩ́ tə wa, ba nə paa Zwezi. Zwʋzɛfə yà wulə lɩ̀à tə wa, ba nə bʋ̀rɩ̀ bʋ̀rà tə. Ʋ yà yɩ lìù tə lɩ̀à mɛ nə zìlí. Ʋ yà dànɩ̀ Yɩɩ pàrɩ̀ tə, kʋ nə wá bà wiən tə mɛ yuu wa. Zwʋzɛfə wà fən dəri, sə ʋ va *Pilatə con, ʋ lòrì cwəŋə, sə ʋ gùrì Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Máŋá tə wa, Pilatə nə nì də Zwezi manwarɩ ʋ tɩ, tə gwárɩ́ wá zəni. Ʋ dàń ma tʋn ba bon pamana yuu tíú, sə ʋ bwe wá: «Zwezi cɩ́gá tɩga kʋ dɩ́án naaa?» ");
INSERT INTO nnw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Máŋá tə, pamana yuu tíú tə nə le wá, ʋ dàń pɩn cwəŋə Zwʋzɛfə nə, sə ʋ tì Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zwʋzɛfə vəli ʋ yə̀ ganpon. Ʋ cú Zwezi dagarʋ tə yuu wa. Ʋ pəpəni wá də gànʋ̀ tə, ʋ ja va ʋ tún ləbəri wa, ba nə kʋa pɩ̀ʋ̀ kapan wa. Kʋ kwa nə, ʋ yigu kapan nəfarʋ, ʋ ma sun bʋʋ tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari Madəlɛnə, də Zwoze nuu Mari yà wulə ba ywàŋá bwálɩ́ tə, ba nə kəni Zwezi. ");
INSERT INTO nnw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","*Zwifə-ba *sìə́ dɩɩn tə nə kɛ̀eń, Mari Madəlɛnə, də Zwakə nuu Mari, də Salome yə̀ tɩralɩ, ba ja kʋ ba va, sə ba ma tùrì Zwezi yɩra. ");
INSERT INTO nnw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kʋ dɩɩn tə jɩjʋ fuən fuən, yɩɩ pɩ́ʋ́n máŋá wa, ba zàn ba va ləbəri tə bwálɩ́ nə. ");
INSERT INTO nnw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba yà swɩ̀n duən con, ba wʋ́: «Wàà nə wá bəbəli kapan, tə nə wulə ləbəri tə nii nə, ʋ pa nəba?» ");
INSERT INTO nnw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yá máŋá tə, ba nə ywàń, ba nɩ də, ba bəbəli kapan nəfarʋ tə ba tún səpuni nə. ");
INSERT INTO nnw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba dàń nə zʋa ləbəri tə wa, ba nɩ balandʋrʋ don, də ʋ jə jɩzən yuu, ʋ zʋ gandarʋ nəpon. Fən ma zʋ ba. ");
INSERT INTO nnw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yá ʋ dàń swɩ̀n ba con, ʋ wʋ́: «Á dànà ká pa fən ja aba. *Nazarɛtə Zwezi tə, ba nə paa dagarʋ yuu nə, á pɩ̀à? Ʋ pìí ʋ bwin ʋ nan tɩan wa, ʋ kʋ́ʋ̀ tə̀lə́ yəbə. Á ywàŋá bwálɩ́ tə, ba yà nə ken wá. ");
INSERT INTO nnw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Á dàń vələ á swɩ̀n Piyɛrə, də ʋ karbɩa tə duən tə con, də ʋ dí yáá ʋ vələ, sə ʋ dàn aba Galile nagwanaa wa. Mə lá nə, á wá na wá, ndə ʋ yà nə swɩ̀n á con nətʋ tə». ");
INSERT INTO nnw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ba dàń nan ləbəri tə wa, ba dəri ba va yɩŋʋna, ba yà nə yɩ ba vɩvaga tə yɩrɩ. Fən yà jə ba. Yá ba ga wà yoo lìù mama con swɩ̀n, fən yà nə jə ba tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zwezi bwin ʋ nan *Zwifə-ba *sìə́ dɩɩn tɩkʋnɩ jɩjʋ fuən fuən, ʋ dí yáá ʋ bɩrɩ ʋ tɩ̀àn Mari Madəlɛnə nə. Kʋ mʋ̀ Mari tə yɩra nə ʋ yà dɩŋɩ *zinə barpɛ tə. ");
INSERT INTO nnw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari jɩn kʋ ŋwɛn tə ʋ va ʋ man ʋ bɩrɩ ba tə, ba yà nə yɩ də Zwezi. Ʋ twi də ba yà wulə ba kwi, ba pwìí yà nə cʋ̀gʋ̀ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ba nə nì də, Zwezi wulə mɩɩ wa, yá də Mari nɩ wá, ba wà kʋ sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kʋ kwa nə, Zwezi kʋ́ʋ̀ pìí lwàń yiri don, ʋ bɩrɩ ʋ tɩ̀àn ʋ karbɩa tə bələ duən nə. Ba yà wulə cwəŋə yuu ba vəli gaʋ. ");
INSERT INTO nnw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba mʋ̀ pìí ba bà, ba man kʋ, ba bɩrʋ ba duən tə nə. Ba də tə wà sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kʋ zwɩʋ wa, Zwezi pìí ʋ bɩrɩ ʋ tɩ̀àn ʋ karbɩa fugə də nədʋ tə nə, də ba wulə ba də́. Ʋ caga ba nii nə, ba nə ba Yɩɩ nii sɛ̀e, də ba zɩbaniun tə yɩrɩ, ba nə vɩga mɩ́ámɩ́án, sə ba sɛ̀e lɩ̀à tə nii, ba nə nɩ Zwezi, ʋ bwiun tə kwa nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Á vələ lʋʋ tə mama wa, á swɩ̀n Yɩɩ sʋywáŋʋ́ tə á bɩrɩ lɩ̀à mɛ nə. ");
INSERT INTO nnw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Lìù tə nə ken ʋ waa Yɩɩ nə, yá ba ga lə kʋ tíú nɩ́á wa, kʋ twá də *Kərisə yɩrɩ, Yɩɩ wá jon wá ʋ cʋna wa. Yá lìù tə, ʋ nə bá kə ʋ waa Yɩɩ nə, Yɩɩ wá bʋ̀rɩ̀ kʋ tíú bʋ̀rà, ʋ ga cʋ̀gʋ̀ wá. ");
INSERT INTO nnw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Á nəŋə Yɩɩ dɩ̀àn mɩmɩnan tə, tə nə wá twá ba tə nə, ba nə ken ba waa Yɩɩ nə: Ba wá lɩ *zinə lɩ̀à yɩra à yɩrɩ yuu nə. Ba wá swɩ̀n sʋ̀ràn yiri duən tə, ba nə yə̀rì. ");
INSERT INTO nnw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba nə jɩn dɩŋa, nə à yə̀ə́ ba nə nyʋa fanan, tə bá fwa ba won mama. Ba wá tún ba jɩ̀àn yayɩŋa yuu wa, ba yayɩran ga wá zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","*Yuu-Tiu nə swɩ̀n ba con tə kwa nə, ʋ dɩ̀gà yɩɩ. Ʋ jə̀ə́ Yɩɩ jɩzən vàn nə. ");
INSERT INTO nnw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ʋ karbɩa tə dàń zàn, sə ba va ba swɩ̀n Yɩɩ sʋywáŋʋ́ tə bwálɩ́ mama nə. Yuu-Tiu yà saŋa ba tʋtʋŋɩ tə wa, ʋ ga twá Yɩɩ dɩ̀àn mɩmɩnan nə ʋ bɩrɩ ba də, sʋgʋ tə yɩ cɩ́gá.");
INSERT INTO nnw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","À yáá tíú Teofilə, yìə̀n tə, tə nə tʋn nə pwərə wa, lɩ̀à zənzən də́də́n, sə ba pʋ́pʋ́nɩ́ tə, ba tún. Ba tún yìə̀n təntə, ndə tə tɩ̀án tə nə nɩ tə, kʋ máŋá tə wa, tə nə tʋn. Kʋ ga ya ba yuu zɩlɩ, sə ba swɩ̀n Yɩɩ sʋgʋ tə. Mə kʋ mʋ̀ nə pɩn, kʋ nə yí à də, à də ma bwe zəni yìə̀n tə yuu wa, tə nə tʋn, kʋ máŋá tə nə. Yá kʋ ya ziən, kʋ pa à mʋ̀ nə, sə à pʋ́pʋ́nɩ́ tə à pa aba, ndə kʋ nə zɩgɩ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","À fwa kʋ nətʋ tə, sə n ma wànɩ́ n lwarɩ kàrà tə cɩ́gá tə, n nə nɩ tə. ");
INSERT INTO nnw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Máŋá tə wa, *Erodə nə yɩ Zwide nagwanaa tə wa pɩ̀ʋ́, Yɩɩ *joŋwanʋ don yà yɩ lá, ba ma boŋə Zakari. Ʋ də yɩ Abɩa púlí tə wa Yɩɩ joŋwanʋ don. Ʋ kan yɩrɩ nə Elizabɛtə. Ʋ ya *Arɔn Yɩɩ joŋwanʋ nəkwɩa dwíí tə wa bʋ̀á. ");
INSERT INTO nnw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ba mɛ bələ yà yɩ cɩ́gá tɩ̀án Yɩɩ yáá con, ba ga zìlí yìə̀n tə mama, Yɩɩ nə nə pɩn ʋ *nii tə yuu wa zəni. Ba ba yoo jə, ba nə wá caga ba nii nə kʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elizabɛtə yà yɩ kadɩŋʋ. Kʋ mʋ̀ nə pɩn, ba yà ba bìú jə, yá ba mɛ bələ tə də ga kwɩn. ");
INSERT INTO nnw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dɩɩn don nə, kʋ yà twi kʋ yí Zakari dwíí púlí tə, sə ba tʋn Yɩɩ tʋtʋŋɩ tə. Kʋ mʋ̀ nə pɩn, Zakari yà wulə *Zwifə-ba Yɩɩ *dìə̀ tə wa, ʋ fwa kʋ tʋtʋŋɩ tə, ");
INSERT INTO nnw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ndə kʋ nə yɩ Yɩɩ joŋwana tə yofwamɩʋ nə. Kʋ tʋa Zakari yuu wa, sə ʋ zʋ bwálɩ́ tə wa, kʋ nə yɩ Yɩɩ nyiən nə, ʋ sʋrɩ tɩralɩ ʋ pa Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Máŋá tə wa, ʋ nə wulə ʋ sʋrɩ tɩralɩ tə, lalʋʋ tə mama yà zɩga kàrá wa, ba jʋ̀nɩ̀ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","*Yuu-Tiu *malɩka twi, ka nan Zakari nə. Ka twi ka zɩga *joŋi kúrí tə jɩzən nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Máŋá tə, Zakari nə nɩ ka, ʋ bɩcan dɩŋɩ, ʋ ga zəzəgə. ");
INSERT INTO nnw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yá malɩka tə dàń swɩ̀n ʋ con, ka wʋ́: «Dàn ká pa fən ja mʋ́, Zakari. Yɩɩ nì n yɩlori tə: N kan Elizabɛtə wá lʋrɩ bibɛɛ ʋ pa mʋ́, n ga wá kə ʋ yɩrɩ Zwan. ");
INSERT INTO nnw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ʋ wá yà pupwən nəfarʋ, ʋ pa mʋ́. Yá lɩ̀à zənzən də ga wá jwɛ ʋ lʋrɩ tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ʋ wá yà ləzwənfarʋ Yuu-Tiu yáá nə. Ʋ bá nyʋ divɛn, nə à yə̀ə́ swana yiri mama. Ʋ wá sú də Yɩɩ-*Siŋu tə, də ʋ tə wulə ʋ nuu pùə́ wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ʋ wá van *Yɩzərayɛlə lɩ̀à zənzən, ʋ ja bà Yuu-Tiu tə con, ʋ nə yɩ ba Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ʋ tətə nə wá va ʋ tɩ̀àn nə, Yɩɩ yáá nə, də Yɩɩ-Siŋu dɩ̀àn tə, tə nə yɩ də Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli. Ʋ wá pa nyɩna də bɩa kə duən nə. Ʋ wá ja ba tə, ba nə vɩ nii, ʋ ja bà cɩ́gá tɩ̀án tə, ba nə jə wʋbʋŋa con. Ʋ wá tanɩ lɩ̀à tə, ʋ pa ba ma dɩ̀àn Yuu-Tiu». ");
INSERT INTO nnw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakari dàń ma swɩ̀n malɩka tə con, ʋ wʋ́: «À wá twá nətə à ma lwarɩ də, kʋ yɩ cɩ́gá? À də à kan mama nə kwɩn». ");
INSERT INTO nnw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malɩka tə ma le wá, ka wʋ́: «À yɩrɩ nə ya Gabəriyɛlə. À mʋ̀ nə wulə Yɩɩ yáá nə, à tʋŋa à pɩn wá. Ʋ tʋn nə, sə à swɩ̀n n con, sə à ga pa mʋ́ sʋywáŋʋ́ kʋ tə. ");
INSERT INTO nnw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yá n wà à sʋ̀ràn tə cɩ́gá pɩn, tə nii ga wá sú, də tə máŋá nə yí. Mə kʋ mʋ̀ nə pɩn, nə̀ń n wá jì bəru, n bá wànɩ́ n swɩ̀n, kʋ ja va dɩɩn tə, tə yìə̀n tə nii nə wá sú». ");
INSERT INTO nnw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kʋ máŋá təntə wa, kʋ gwárɩ́ lalʋʋ tə, kʋ yà nə dànɩ̀ Zakari kàrá wa, ʋ dánʋ́ tə yɩrɩ Yɩɩ dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yá ʋ nə nan máŋá tə wa, ʋ yà kʋ́ʋ̀ wàrɩ̀ də ba ʋ swɩ̀n. Lɩ̀à tə dàń ma lwarɩ də, kʋ ya ʋ nɩ won, kʋ nə nan Yɩɩ, Yɩɩ dìə̀ tə wa. Ʋ jɩ̀àn nə, ʋ ma swɩ̀n ba con, ʋ nii ga də̀ŋə̀. ");
INSERT INTO nnw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakari dàń tʋn Yɩɩ dìə̀ tə wa ʋ zwɛ̀e, ʋ pìí ʋ va ʋ sàń. ");
INSERT INTO nnw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kʋ nə twi kʋ bà, kʋ dánɩ́ kwa nə, ʋ kan Elizabɛtə jɩn pùə́, yá ʋ dàń yɩ dìə̀ wa cànɩ̀ bonu. Kʋ máŋá tə wa, ʋ swɩ̀n ʋ tɩ̀àn con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Nə̀ń kʋ tə, Yuu-Tiu nə pɩ̀à, sə ʋ fwa ʋ pa nə: Sɩ́ʋ́n nə ʋ pɩ̀à, sə ʋ lɩ nə, kʋ tə wa, kʋ nə yɩ nə kana cavɩra lɩ̀à yáá con». ");
INSERT INTO nnw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabɛtə pùə́ tə janʋ cànɩ̀ bardʋ máŋá wa, Yɩɩ tʋn *malɩka Gabəriyɛlə Galile nagwanaa tɩʋ don nə, ba nə boŋə ‹*Nazarɛtə›. ");
INSERT INTO nnw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ʋ tʋn wá kacɩɩn don con, ʋ tə nə yə̀rì bɛɛ, ʋ yɩrɩ nə yɩ Mari. Ʋ yɩ Zwʋzɛfə bwàlʋ́, ʋ nə pɩ̀à, sə ʋ swe. Zwʋzɛfə tə nan pɩ̀ʋ́ *Davidə dwíí tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malɩka tə yí, ka swɩ̀n Mari con, ka wʋ́: «Ya pupwən wa, Yɩɩ fwa pubwanʋ n yɩra. *Yuu-Tiu wulə də mʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tə yìə̀n tə wʋwalɩ Mari zənzən, ʋ ga bwe ʋ tɩ̀àn yoo tə, kʋ mʋ̀ jʋnʋ təntə nə pɩ̀à kʋ swɩ̀n ʋ con. ");
INSERT INTO nnw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malɩka tə dàń swɩ̀n ʋ con, ka wʋ́: «Mari, dàn ká pa fən ja mʋ́. Yɩɩ fwa pubwanʋ n yɩra. ");
INSERT INTO nnw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nə̀ń n wá ja pùə́, n ga wá lʋra bìú, n wá kə ʋ yɩrɩ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ʋ wá yà ləzwənfarʋ, ba ga wá bon wá ‹Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, bìú›. Yuu-Tiu Yɩɩ wá pa ʋ jì pɩ̀ʋ́, ndə ʋ nɩbɛɛ Davidə nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yá ʋ ga wá tɩnɩ də pàrɩ̀ *Yɩzərayɛlə lɩ̀à tə yuu wa máŋá mama. Ʋ pàrɩ̀ tə bá zwɛ̀e də mama». ");
INSERT INTO nnw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari ma swɩ̀n malɩka tə con, ʋ wʋ́: «Kʋ nətʋ tə ya kʋ wá zɩgɩ nətə, sə à nə yə̀rì bɛɛ?» ");
INSERT INTO nnw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malɩka tə ma le Mari, ka wʋ́: «Yɩɩ-*Siŋu tə wá bà n yuu wa. Yá Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, dɩ̀àn tə wá pú n yuu nə, ndə ywárɩ́ nə. Mə kʋ mʋ̀ nə wá pa bisɩmaa tə, n nə wá lʋra tə, ya Yɩɩ nə tɩ, ba ga wá bon wá Yɩɩ-Biu. ");
INSERT INTO nnw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elizabɛtə, ʋ nə yɩ n dwíí tíú, də wá lʋra bìú tə don, də ʋ kazʋnɩ tə mama. Ba yà wʋ́, ʋ wàrɩ̀ bìú ʋ lʋrɩ, yá sɩ́ʋ́n nə, ʋ wulə ʋ pùə́ cànɩ̀ bardʋ wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Won tə̀lə́, Yɩɩ nə wàrɩ̀ ʋ fwa». ");
INSERT INTO nnw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari dàń ma swɩ̀n, ʋ wʋ́: «Nə̀ń à yɩ Yuu-Tiu tʋtʋnbʋa, sə kʋ fwa nətʋ, ndə n nə swɩ̀n kʋ». Malɩka tə dàń ma kɛ̀eń ka yá wá. ");
INSERT INTO nnw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kʋ kwa nə, Mari bɩbarɩ, ʋ zàn ʋ zʋ cwəŋə, ʋ ma vələ lala tɩʋ don nə, kʋ nə wulə Zwide nagwanaa vàn tə con, kʋ nə jə pɛɛn tə. ");
INSERT INTO nnw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ʋ vəli ʋ yí, ʋ zʋ Zakari dìə̀ wa, ʋ jʋn ʋ kan Elizabɛtə. ");
INSERT INTO nnw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Máŋá tə wa, Elizabɛtə nə nì Mari jʋ̀nà tə, Elizabɛtə bisɩmaa tə lulugu ʋ pùə́ wa. Elizabɛtə ga sú də Yɩɩ-*Siŋu tə, ");
INSERT INTO nnw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ʋ bubwi ʋ kə yɩɩ nə, ʋ ga wʋ́: «Yɩɩ fwa zəni n yɩra, n duən kana wa. Yɩɩ wá fwa zəni n bisɩmaa tə yɩra, n nə wá lʋra! ");
INSERT INTO nnw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","À mʋ̀ də nə yɩ wàà, *Yuu-Tiu nuu ma bà à sàń? ");
INSERT INTO nnw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nə̀ń máŋá tə, à nə nì n jʋ̀nà tə, à bisɩmaa tə lulugu də pupwən à pùə́ wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","N pɩn cɩ́gá kʋ tə, nə Yuu-Tiu nə pɩn, ba swɩ̀n n con də, kʋ nii tə wà sú. Kʋ mʋ̀ nə pɩn, n yɩ pupwən tíú». ");
INSERT INTO nnw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari dàń ma swɩ̀n, ʋ wʋ́: «À bwɩ *Yuu-Tiu nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","À pùə́ poli, Yɩɩ nə jon nə à cʋna tə wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yɩɩ bʋ́n à də nyiən don yoo, ndə ʋ tʋtʋnbʋa nə. Cɩ́gá, sɩ́ʋ́n dàń nə, lʋʋ ləzwənə dwíí mama wá swɩ̀n də, à mʋ̀ yɩ pupwən tíú. ");
INSERT INTO nnw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, fwa yìə̀n, tə nə ziən zəni, ʋ pa nə. Ʋ yɩrɩ ziən, kʋ ba don ja. ");
INSERT INTO nnw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ʋ wá dəri lɩ̀à tə nə zìlí wá yinəgə zənzən, máŋá də máŋá, kʋ nə ba zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ʋ tʋn yìə̀n nəfaran, ʋ ma bɩrɩ ʋ dɩ̀àn tə. Ʋ dɩŋɩ ləzoni tə, ba nə jə fwiə, ba dəri ba jén duən yáá nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ʋ zɩ̀n pɛ̀egá tə nə jə dɩ̀àn, ba padaran yuu ʋ dɩ, ʋ ga zɩ̀n ba tə, ba nə mun ba tɩ̀àn, ʋ kə yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ʋ pɩn wiən zənzən, ba tə nə, ba nə ba jə ba də́. Ʋ pɩn, jɩjə tɩ̀án pìí ba vìí də jɩkʋrɩkɛ. ");
INSERT INTO nnw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ʋ twi, sə ʋ san *Yɩzərayɛlə lɩ̀à nə, ba nə yɩ ʋ tʋtʋnbɩa. Ʋ lìí máŋá mama, sə ʋ dəri ba yinəgə zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ʋ kàn nii nə nɩbara-ba con də, kʋ wá yà nətʋ máŋá mama. Ʋ kàn kʋ mʋ̀ nii təntə, ʋ pa *Abərahamə də ʋ dwíí nə». ");
INSERT INTO nnw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari fwa ndə cànɩ̀ batwa nə Elizabɛtə con. Kʋ kwa nə, ʋ ma pìí, ʋ va ʋ sàń. ");
INSERT INTO nnw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabɛtə lʋrʋ máŋá nə yí, ʋ twi ʋ bà, ʋ lʋrɩ bibɛɛ. ");
INSERT INTO nnw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elizabɛtə yɩra lɩ̀à də ʋ dwíí tɩ̀án nì də, *Yuu-Tiu dəri ʋ yinəgə zənzən. Ba də pùə́ dàń ma poli də wá, kʋ yoo tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ba *goŋi bìsɩ̀ná tə, ʋ dɩan nana dɩɩn nə. Kʋ máŋá tə wa, ba yà pɩ̀à, sə ba pa wá ʋ nyɩna Zakari yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ʋ nuu dàń ma swɩ̀n, ʋ wʋ́: «Ɔn ɔn! À wà sɛ̀e. Ʋ yɩrɩ wá yà Zwan». ");
INSERT INTO nnw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba ma swɩ̀n ʋ con, ba wʋ́: «Lìù mama tə̀lə́ n dwíí tə wa, ʋ nə jə kʋ mʋ̀ yɩrɩ təntə». ");
INSERT INTO nnw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ba dàń ma bwe ʋ nyɩna də jɩ̀àn, sə ba jə́n, bɛ̀eɛ̀e yɩrɩ nə ʋ wá pa ʋ bìú tə nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakari ma lòrì ba, sə ba pa wá pʋ́pʋ́nʋ́ daborubiə, ʋ dàń ma pʋ́pʋ́nɩ́ kʋ yuu wa, ʋ wʋ́: «Ʋ yɩrɩ nə yɩ Zwan». Kʋ gwárɩ́ ba mama mɩ́ámɩ́án. ");
INSERT INTO nnw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kʋ máŋá tə wa, Zakari nii kʋ́ʋ̀ pórí, kʋ wàá yìə̀n kʋ́ʋ̀ swɩ̀n. Ʋ súrí ʋ nii ʋ kə yɩɩ nə, ʋ ma bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kʋ dɩ̀gà lɩ̀à tə mama yuu, ba nə bwələ lá. Zwide nagwanaa pɛɛn yuu lɩ̀à tə mama yà swɩ̀n tə mʋ̀ yìə̀n təntə yoo. ");
INSERT INTO nnw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ba tə mɛ, ba nə nə̀ń tə yìə̀n təntə yà dwɩ tə yoo, ba ga bwe ba tɩ̀àn, ba wʋ́: «Kʋ bisɩmaa təntə dàń wá yà nətə?» Yɩɩ dɩ̀àn tə cɩ́gá yà wulə də wá. ");
INSERT INTO nnw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yɩɩ-*Siŋu tə súə́ bisɩmaa tə nyɩna Zakari, kʋ pa ʋ swɩ̀n Yɩɩ nii sʋ̀ràn tə tə, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«À wá bʋ *Yɩzərayɛlə lɩ̀à *Yuu-Tiu Yɩɩ tə nə. Yɩɩ ywàń ba yuu, ʋ ga yə̀ ba ʋ jon. ");
INSERT INTO nnw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ʋ tʋn lìù, sə ʋ lɩ nəba nə yoo wa mɩ́ámɩ́án. Kʋ mʋ̀ lìù tə, ʋ nə wá lɩ nəba nə yoo tə wa, yɩ ʋ nan ʋ tʋ̀tʋ̀nʋ̀ pɩ̀ʋ́ *Davidə dwíí tə wa, ");
INSERT INTO nnw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ndə ʋ nə twá ʋ nii *sʋ̀sʋ̀nà tə nə, ʋ ma swɩ̀n, kʋ máŋá nə ba yigə. ");
INSERT INTO nnw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ʋ yà kàn nii də, ʋ wá lɩ nəba nə dʋŋa də lɩ̀à tə, ba nə culi nəba, jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yɩɩ lìí ʋ *nimarʋ tə yoo. Ʋ dəri nə nɩbara tə yinəgə zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yɩɩ fwa kʋ nətʋ, ʋ yà nə dùə̀ də nə nɩbɛɛ *Abərahamə də, ");
INSERT INTO nnw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","ʋ wá jon nəba nə dʋŋa tə dɩ̀àn jɩɩn yɩrɩ. Kʋ nətʋ nə wá wànɩ́ nə bʋ ʋ nə də zìlə́. Kʋ nətʋ tə, sə nə ma wànɩ́ nə yà lɩ̀à tə, nə nə yɩ Yɩɩ nə tɩ, nə ga tə yɩ cɩ́gá tɩ̀án Yɩɩ yáá con, dɩɩn mama, nə mɩɩ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","N mʋ̀ con nə, à bìú, n wá va Yuu-Tiu yáá con nə, sə n ma kwɛn ʋ cwəŋə. Kʋ mʋ̀ nə pɩn, ba wá bon mʋ́ Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, nii *sʋ̀sʋ̀nʋ̀. ");
INSERT INTO nnw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yá n mʋ̀, à bìú, n wá bɩrɩ Yɩɩ lɩ̀à tə də, Yɩɩ wá jon ba ba cʋna wa ʋ ga kwɛn tə, ʋ lɩ ʋ mʋ̀ də ba pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nə Yɩɩ tə swə nəba zənzən, ʋ ga dəri nə yinəgə zənzən. Ʋ wá pa poni nan yɩɩ, kʋ pɩpɩlɩ nə yuu con ndə yɩcaʋ nə pén. ");
INSERT INTO nnw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Poni tə wá san ba tə nə wulə yɩkunu wa, də ba tə nə wulə tɩan fən wa. Kʋ mʋ̀ poni tə nə wá kə nəba cwəŋə tə wa, kʋ nə jə bɩcan sìə́». ");
INSERT INTO nnw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bisɩmaa tə bori, yá ʋ pubʋŋa də ga daŋa kʋ súrí lá. Ʋ yɩ kasɔɔ lanworu wa, kʋ ja va dɩɩn tə, ʋ nə bɩrɩ ʋ tɩ̀àn Yɩzərayɛlə lɩ̀à tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kʋ máŋá təntə wa, pafarʋ Ogisətə pɩn nii, sə ba gàlà ʋ lʋʋ ləzoni tə mama. ");
INSERT INTO nnw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kʋ mʋ̀ təntən lagala tə fwa, də Kirinisə nə ya Siri nagwanaa tə yáá tíú, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún. ");
INSERT INTO nnw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lɩ̀à tə mama vəli, ba pʋ́pʋ́nɩ́ ba tɩ̀àn ba dəkuu bwálɩ́ nə. ");
INSERT INTO nnw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Zwʋzɛfə də nan *Nazarɛtə nə, kʋ nə wulə Galile nagwanaa wa, ʋ va Zwide nagwanaa tə wa, pɩ̀ʋ́ *Davidə tɩʋ, ba nə boŋə ‹Bɛtələhɛmə›, ʋ də ʋ bwàlʋ́ Mari. Ba vəli lá, Zwʋzɛfə nə yɩ Davidə nàʋ́ tə yɩrɩ. Mari tə, ʋ nə pɩ̀à, sə ʋ swe Zwʋzɛfə nə, tə pùə́ yí. Ʋ də Zwʋzɛfə vəli lá, sə ba pʋ́pʋ́nɩ́ ba tɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Máŋá tə wa, ba nə wulə Bɛtələhɛmə nə, ʋ bìú tə lʋrʋ yí. ");
INSERT INTO nnw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mari lʋrɩ bibɛɛ, ʋ kacarɩ bìú. Vərə dii tə mama yà súə́. Kʋ mʋ̀ nə pɩn, Mari baa ʋ bìú də ganan, ʋ ga tì wá ʋ tún vàná kurəbori wa. ");
INSERT INTO nnw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kʋ mʋ̀ nagwanaa təntə tətə wa, payɩra yà cɩ̀ ba vàná nə tɩtɩn nə, gaʋ wa. ");
INSERT INTO nnw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","*Yuu-Tiu *malɩka twi, ka nan ba nə. Yá Yɩɩ poni tə pɩrɩ ba kʋ kɩkarɩ, fən ga zʋ ba zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yá malɩka tə swɩ̀n ba con, ka wʋ́: «Á dànà ká pa fən ja aba. À ja sʋywáŋʋ́ à bà, sə à pa aba, kʋ nə wá poli *Yɩzərayɛlə lɩ̀à mɛ pwìí zənzən: ");
INSERT INTO nnw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tɩtɩn kʋ tə nə, ba lʋrɩ lìù tə, ʋ nə wá jon aba á cʋna wa, pɩ̀ʋ́ *Davidə tɩʋ wa. Ʋ mʋ̀ nə yɩ *Kərisə, ʋ nə yɩ Yuu-Tiu. ");
INSERT INTO nnw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Á nəŋə nətʋ tə, á nə wá twá, á ma lwarɩ wá: Á wá na bìsɩ̀ná, ba nə baa wá də ganan, ba tún wá vàná kurəbori wa». ");
INSERT INTO nnw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Naa nədʋ, malɩkɛ kapʋpʋ nan Yɩɩ sàń, tə bà tə súrí ka tə nə, tə bwɩ Yɩɩ nə, tə wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Dun wulə Yɩɩ con, ʋ nə wulə ʋ *sàń nə, ʋ bɩcan sìə́ tə wá yà tɩa yuu wa ləzoni tə, ʋ mʋ̀ Yɩɩ nə swə, pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Máŋá tə wa, *malɩkɛ tə nə pìí tə dɩ̀ Yɩɩ *sàń nə, payɩra tə swɩ̀n duən con, ba wʋ́: «Nə dàń vələ nə yí Bɛtələhɛmə nə. Kʋ mɛ, sə nə na kʋ tə nə tʋn lá nə, kʋ tə *Yuu-Tiu nə pɩn nə yəni tə». ");
INSERT INTO nnw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba twi lala ba yí lá, ba na Mari də Zwʋzɛfə də bìsɩ̀ná tə. Bìsɩ̀ná tə tə́gə́ vàná kurəbori tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ba nə nɩ bìsɩ̀ná tə, ba tún kʋ tə mama, malɩka tə nə swɩ̀n ba con, kʋ bìsɩ̀ná tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kʋ gwárɩ́ ba tə mama, ba nə nì kʋ tə, payɩra tə nə swɩ̀n ba con. ");
INSERT INTO nnw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ʋ mʋ̀ Mari də jɩn tə yìə̀n təntə mama ʋ waa con, ʋ ga bʋŋa tə nə də ʋ waa mama. ");
INSERT INTO nnw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kʋ kwa nə, payɩra tə pìí ba vìrí də ba bwɩ Yɩɩ nə, ba ga pɩn wá dun tə tə mama yɩrɩ, ba nə nì ba ga na. Ba bwɩ ʋ nə, yìə̀n tə mama nə fwa nətʋ, ndə malɩka tə nə swɩ̀n ba con, tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bìsɩ̀ná tə lʋrɩ dɩan nana dɩɩn nə, ba *goŋi wá, ba ga kə ʋ yɩrɩ Zwezi. Mə kʋ yɩrɩ təntə *malɩka tə bɩrɩ də, ʋ nuu tə wà ʋ pùə́ jɩn. ");
INSERT INTO nnw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kʋ kwa nə, máŋá yí, sə Mari də twá kʋ tə nə, Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, nə bɩrɩ, sə kʋ fwa kan nə lʋrɩ kwa nə. Zwʋzɛfə də Mari dàń ma tì bisɩmaa tə, ba ja va *Zwerizalɛmə nə, sə ba pa wá *Yuu-Tiu Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kʋ yɩ ndə kʋ nə pʋ́pʋ́nɩ́ Yuu-Tiu nii tə wa nətʋ, kʋ wʋ́: «Lìù mama cárɩ́ bisɩmabara yɩ, ba wá tún vàn nə, sə ʋ ya Yɩɩ cɩcɩ nə tɩ». ");
INSERT INTO nnw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ba də fwa kʋ *joŋi tə, ndə Yuu-Tiu nii tə nə pɩ̀à nətʋ. Kʋ yɩ kʋ fwa də gunponi bələ, nə à yə̀ə́ nasara gunpobii bələ. ");
INSERT INTO nnw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bɛɛ don yà wulə *Zwerizalɛmə wa, ba ma boŋə Simeyon. Kʋ bɛɛ təntə yà yɩ cɩ́gá tíú Yɩɩ yáá con, ʋ twá Yɩɩ cwəŋə tə zəni, ʋ yà ga dànɩ̀ lìù tə, ʋ nə wá zùrì *Yɩzərayɛlə lɩ̀à tə bɩcanɩ. Yɩɩ-*Siŋu tə yà wulə də Simeyon. ");
INSERT INTO nnw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kʋ yà pɩn, ʋ yəni də, ʋ bá tɩ, də ʋ nə wà *Kərisə nɩ də ʋ yɩ́á. Kərisə tə, *Yuu-Tiu nə kúrú, sə ʋ tʋn. ");
INSERT INTO nnw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yɩɩ-Siŋu tə nə pɩn, Simeyon lwarɩ də, ʋ mɛ, sə ʋ va *Zwifə-ba Yɩɩ *dìə̀ tə wa. Máŋá tə, Zwezi nuu də ʋ nyɩna tə nə ja ba bisɩmaa tə, ba ja bà, sə ba ma fwa kʋ tə, Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, nə pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon tì wá, ʋ kə ʋ nyʋnɩ nə, ʋ ga pa dun Yɩɩ nə, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","«Sɩ́ʋ́n nə, kʋ tə Yɩɩ nə swɩ̀n də, kʋ wá tʋn tə jigə: Yuu-Tiu, à nɩ lìù tə, n nə tʋn, sə ʋ jon lɩ̀à ba cʋna wa, də à tətə yɩ́á. Kʋ mʋ̀ yɩrɩ nə, n dàń wàá n tʋ̀tʋ̀nʋ̀ tə n yá, sə ʋ tɩ də bɩcan sìí. ");
INSERT INTO nnw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","N tanɩ lìù təntə lʋʋ ləzoni mɛ yɩ́á yuu. ");
INSERT INTO nnw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kʋ lìù təntə yɩ ndə poni nə, kʋ nə wá pa lʋʋ dwíə́ tə mama yəni mʋ́. Kʋ ga wá pa dun Yɩzərayɛlə lɩ̀à tə nə, ba nə yɩ n mʋ̀ lɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeyon yìə̀n tə, ʋ nə swɩ̀n Zwezi yuu wa, yà gwárɩ́ Zwezi nuu də ʋ nyɩna zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon lòrì Yɩɩ, sə ʋ fwa zəni Zwezi də ʋ nuu də ʋ nyɩna yuu wa. Ʋ swɩ̀n Zwezi nuu Mari con, ʋ wʋ́: «Yɩɩ kúrú bisɩmaa ka tə, sə ʋ twá ʋ nə, ʋ ma bʋ̀rɩ̀ Yɩzərayɛlə lʋʋ lɩ̀à zənzən bʋ̀rà, ʋ ga sɛ̀e ba duən də zənzən. Ʋ wá yà lìù tə, ʋ nə wá bɩrɩ də, Yɩɩ tʋŋa ʋ pɩn ləzoni nə, yá ba ga vɩ wá. Bisɩmaa tə wá pa pubʋŋɩ, tə nə wulə waa, nan poni nə. ");
INSERT INTO nnw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yá n mʋ̀, bìú tə nuu, n wá na càn. Tə càn tə wá cʋ̀gʋ̀ n bɩcan mɩ́ámɩ́án, ndə lagʋrɩ sɩ̀ʋ́ nə pórí won nə. Ʋ wá pa lɩ̀à zənzən swɩ̀n kʋ tə, kʋ cɩ́gá nə wulə ba waa». ");
INSERT INTO nnw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Yɩɩ nii *sʋsʋnkana don, ʋ yɩrɩ nə yɩ Anə, də yɩ *Zwifə-ba Yɩɩ *dìə̀ wa. Ʋ yɩ Fanʋwɛlə bʋ̀á, Azɛrə dwíí dəkuu tə wa. Ʋ bɩna yà dáá. Ʋ swe ʋ kacɩɩn máŋá wa, yá bɩna barpɛ nii nə, ʋ barɩ tə tɩga ʋ yá wá. ");
INSERT INTO nnw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ʋ yà kʋ́ʋ̀ ba barɩ jə. Ʋ bɩna dàń yà dáá, ʋ yà jə bɩna sapwɩnɩa də banɩa. Ʋ yàá va ʋ wulə Yɩɩ dìə̀ tə wa, tɩtɩn də yɩcaʋ, ʋ ma tʋŋa Yɩɩ tʋtʋŋɩ tə. Ʋ vwe ʋ nii, ʋ ga jʋ̀nɩ̀ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anə də nə twi, ʋ zʋ Zwifə-ba Yɩɩ dìə̀ tə wa, də Zwezi də ʋ nuu də ʋ nyɩna wulə lá, ʋ də wulə ʋ pɩn dun Yɩɩ nə. Ʋ dàń swɩ̀n bisɩmaa tə yoo lɩ̀à tə mama con, ba yà nə dànɩ̀, sə Yɩɩ yə̀ *Yɩzərayɛlə lɩ̀à ʋ jon. ");
INSERT INTO nnw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Máŋá tə wa, Zwezi nuu də ʋ nyɩna tə nə tʋn kʋ tə mama, *Yuu-Tiu Yɩɩ *nii tə nə pɩ̀à tə, ba dàń pìí, ba ja wá, ba va ba tɩʋ *Nazarɛtə, kʋ nə wulə Galile nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bisɩmaa tə bori, ʋ wʋbʋŋa ga súrí. Ʋ yà jə wʋbʋŋa zənzən, yá Yɩɩ ga fwa ʋ pubwanʋ tə ʋ yɩra. ");
INSERT INTO nnw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bɩnɩ mama Zwezi nuu də ʋ nyɩna yàá va, ba də́ *Pakə cànà tə *Zwerizalɛmə wa. ");
INSERT INTO nnw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Máŋá tə wa, Zwezi nə jə bɩna fugə bələ, ʋ nyɩna-ba jɩn wá, ba ja kə lá, ba va cànà təntə, kʋ nə yɩ ba yofwamɩʋn. ");
INSERT INTO nnw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cànà tə nə zwɛ̀e, ba pìí ba vìí, yá ba bìú Zwezi mʋ̀ mɛ Zwerizalɛmə nə, ʋ nyɩna-ba yà ga wà kʋ lwarɩ. ");
INSERT INTO nnw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba yà bʋŋa də, Zwezi wulə ʋ twaduən tə con, cwəŋə tə yuu. Ba vəli dɩɩn pɩrɩ, ba dàń ga zɩgɩ lá, ba pɩ̀à wá ba nubɩa də ba dabara con. ");
INSERT INTO nnw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yá ba dàń ba wá na. Ba dàń ma ga ba pìí ba va Zwerizalɛmə, sə ba pɩ̀à wá lá. ");
INSERT INTO nnw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dɩan batwa nii nə, ba nɩ Zwezi *Zwifə-ba Yɩɩ *dìə̀ wa, də ʋ jə̀ə́ Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə tətəŋi wa. Ʋ wulə ʋ cʋga ba, yá ʋ ga bwe ba yìə̀n. ");
INSERT INTO nnw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ʋ yənu tə də yìə̀n tə ka le gwárɩ́ ba tə mama, ba yà nə cʋga wá. ");
INSERT INTO nnw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Máŋá tə wa, ʋ nuu də ʋ nyɩna tə nə nɩ wá, kʋ yà gwárɩ́ ba zəni. Ʋ nuu ma swɩ̀n ʋ con, ʋ wʋ́: «À bìú, bɛ̀eɛ̀e nə pɩn, n ma fwa nəba nətən? Nə̀ń, n yoo yà jɩn à də n nyɩna zəni, nə ma twá lá, nə pɩ̀à mʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ʋ ma le, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á pɩ̀à nə? Á mɛ, sə á lwarɩ də, à mɛ, sə à ywàń à nyɩna yìə̀n yuu nə». ");
INSERT INTO nnw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yá ba wà kʋ tə də̀ń nì, ʋ nə pɩ̀à, sə ʋ swɩ̀n ba con nə. ");
INSERT INTO nnw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Zwezi dàń ma pìí, ʋ twá ba nə, ʋ va *Nazarɛtə. Ʋ sɛ̀e ʋ nyɩna-ba tə nii. Ʋ nuu jɩn tə yìə̀n təntə mama ʋ waa nə, ʋ ga lìí tə yoo. ");
INSERT INTO nnw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zwezi bori ʋ kəni lá, ʋ wʋbʋŋa də ga súrí, ʋ dàń ga pɩn pupoli Yɩɩ də ləzoni nə. ");
INSERT INTO nnw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Yɩɩ kori tə twi Zakari bìú Zwan con nə, kasɔɔ lanworu tə wa, pafarʋ Tibɛrə pàrɩ̀ tə bɩna fugə də bonu máŋá wa. Kʋ máŋá təntə wa, də Ponsə *Pilatə nə tɩ Zwide nagwanaa, pɩ̀ʋ́ *Erodə də ma tɩ Galile nagwanaa. Yá Erodə zʋnʋ, pɩ̀ʋ́ Filipə də yà tɩ Yitire nagwanaa də Tərakonitə nagwanaa, pɩ̀ʋ́ Lisaniyasə də yà tɩ Abilɛnə nagwanaa. Anə də Kayifə də yà yɩ *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩna. ");
INSERT INTO nnw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Zwan dàń zàn ʋ jijiri Zwurədɛn mʋnaa tə yɩra nagwanaa tə mama wa. Ʋ dàń ma kàrɩ̀ Yɩɩ yoo ʋ bɩrɩ lɩ̀à nə, ʋ wʋ́: «Á vəvərə á kwa á ma sá á cʋna. Á pɩan ba lə aba nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. Yá Yɩɩ dàń wá kwɛn á cʋna tə, ʋ lɩ á mʋ̀ də ʋ mʋ̀ pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mə nətʋ nə, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi pʋ́pʋ́nɩ́ ʋ sagɩ tə wa, ʋ wʋ́: ‹Kʋ yɩ bɛɛ don nə bubwi kasɔɔ lanworu wa, ʋ wʋ́: «Á kwɩ̀án *Yuu-Tiu cwəŋə tə, sə á cɛ ʋ cwəmɩnɩ tə, sə tə ya mənə mənə. ");
INSERT INTO nnw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Buu gwàlʋ́ mama wá sùń, pɛɛn də dədwələn mama wá cú, tə mɛ də tɩa, cwəŋə gogwələn tə mama wá kwɩ̀án, cokʋkwɩnan tə mama wá pàrɩ̀, tə mɛ duən. ");
INSERT INTO nnw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yá lɩ̀à mama wá na nətʋ, Yɩɩ nə wá jon ba ba cʋna wa»›.» ");
INSERT INTO nnw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lɩ̀à kapʋpʋ yà nə twi Zwan con, sə ʋ lə ba nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. Ʋ dàń yà swɩ̀n ba con, ʋ wʋ́: «Á mʋ̀ dəkwaa dwíí-ba! Wàà nə bɩrɩ aba də, á wàá á dəri á jén Yɩɩ lɩŋa tə yáá, tə nə bɩ̀àn? ");
INSERT INTO nnw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kʋ nə yɩ nətʋ, sə á twá á tʋtʋnan nə, á ma bɩrɩ də, á vəvəri á kwa á ma sá á cʋna. Á jə cɩ́gá, sə á swɩ̀n də, *Abərahamə yɩ á nɩbɛɛ, yá kʋ cɩcɩ tə wà yí. À mʋ̀ nə swɩ̀n kʋ á con də, Yɩɩ wàá kapana tə tə ʋ lwànɩ́ ʋ pɩn, tə jì Abərahamə nɩ̀án. ");
INSERT INTO nnw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nə wàá kʋ nətʋ tə nə tì, nə ma maŋa ndə dèrí nə manwarɩ kʋ wulə tɩ̀án dəkurən nə. Tɩ̀ʋ́ tə mama, kʋ bɩa nə ba ywán, ba wá goŋi kʋ, ba kə mən nə». ");
INSERT INTO nnw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lɩ̀à tə dàń ma bwe wá, ba wʋ́: «Bɛ̀eɛ̀e nə, nə dàń mɛ, sə nə fwa?» ");
INSERT INTO nnw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ʋ ma le ba, ʋ wʋ́: «Lìù tə, ʋ nə jə ganzʋbii bələ, ʋ mɛ, sə ʋ pa nədʋ ʋ tə nə, ʋ nə ba jə. Yá ʋ tə də, ʋ nə jə wodiu ʋ də́, ʋ də mɛ, sə ʋ fwa nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lanpolɩna də twi, sə ʋ lə ba də nɩ́á tə wa, kʋ twá də Yɩɩ yɩrɩ tə, ba ga bwe Zwan, ba wʋ́: «Karnyɩna, nə mɛ, sə nə fwa nətə?» ");
INSERT INTO nnw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ʋ ma le ba, ʋ wʋ́: «Á dànà ká pa ba ŋwɩ́n, ba doni kʋ nii tə, ba nə ŋwɩ́n!» ");
INSERT INTO nnw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pamana də bwe wá, ba wʋ́: «Nə mʋ̀ dàń yɩ bɛ̀eɛ̀e nə, nə mɛ, sə nə fwa?» Ʋ ma le ba, ʋ wʋ́: «Á dànà ká kálʋ́ lìù, nə à yə̀ə́ á kʋna á kə ʋ nii nə, á ma jon kʋ tíú səbiu də dɩ̀àn. Á dàń pɩan á ŋwɩ́rán tə cɩcɩ nə mɛ aba». ");
INSERT INTO nnw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lalʋʋ tə yà dànɩ̀ də yala, yá ba lìù də mama yà bʋŋa, ʋ ga bwe ʋ tɩ̀àn, də kʋ nə tà Zwan nə ya *Kərisə. ");
INSERT INTO nnw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zwan dàń ma swɩ̀n ba mɛ con, ʋ wʋ́: «À mʋ̀ li aba də nɩ́á, kʋ twá də Yɩɩ yɩrɩ, yá lìù don ʋ dɩ̀àn nə dáá, tə doni nə, wá bà. À jɩɩn mùrì, sə à kʋ̀rʋ̀ ʋ nɛɛ natʋra. Ʋ wá lə aba Yɩɩ-*Siŋu tə wa də mən. ");
INSERT INTO nnw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ʋ jə ʋ wocəri fɩyaʋ ʋ jɩ̀àn wa, ʋ kwɛn ʋ cə̀rì ʋ wobɩa tə, ʋ pwɛ̀e tə də wopulə tə, ʋ lɩ duən wa. Ʋ pɛ̀e wobɩa tə, ʋ kə ʋ pulu wa, ʋ ga sʋrɩ wasanan tə mən wa, tə nə ba də̀ŋə̀». ");
INSERT INTO nnw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yá kʋ tə ya, Zwan twá kwìə̀ zənzən nə, ʋ ma swɩ̀n Yɩɩ sʋywáŋʋ́ tə lalʋʋ tə con nə. ");
INSERT INTO nnw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kʋ máŋá təntə wa, Zwan vəli ʋ caga pɩ̀ʋ́ *Erodə nii nə, ʋ nə jon ʋ zʋnʋ kan Erodɩadə, ʋ ma fwa ʋ kan, tə yɩrɩ, kʋ súrí ʋ nə fwa yokʋkwɩnan duən, də tə nə dáá, yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erodə dàń tə súrí yolwan tə don lá, ʋ pa, ba ja Zwan, ba kə bàń dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lalʋʋ tə mama nɩ́á tə liu kwa nə, Zwan ləgə Zwezi də nɩ́á tə wa. Kʋ kwa nə, ʋ nə wulə ʋ jʋ̀nɩ̀ Yɩɩ, lanworu tə súrí. ");
INSERT INTO nnw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yá Yɩɩ-*Siŋu tə cúə́ ʋ yuu wa, ndə won nə, kʋ nə ja yɩra, ndə gunpwənə nə. Yá kori dàń ga nan Yɩɩ *sàń nə, kʋ wʋ́: «N yɩ à biswənə tə, ʋ nə poli à pùə́.» ");
INSERT INTO nnw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zwezi dɩga ʋ tʋtʋŋɩ tə də̀ń, də ʋ jə ndə bɩna fɩtwa nə. Ʋ yà ya ndə ba nə bʋŋa tə, Zwʋzɛfə bìú. Zwʋzɛfə tə, ʋ nə yɩ Eli bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ʋ nə yɩ Matatə bìú, ʋ nə yɩ Levi bìú, ʋ nə yɩ Mɛləki bìú, ʋ nə yɩ Yanayi bìú, ʋ nə yɩ Zwʋzɛfə bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ʋ nə yɩ Matatɩasə bìú, ʋ nə yɩ Amosə bìú, ʋ nə yɩ Nahumə bìú, ʋ nə yɩ Esəli bìú, ʋ nə yɩ Nagayi bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ʋ nə yɩ Maatə bìú, ʋ nə yɩ Matatɩasə bìú, ʋ nə yɩ Səmeyin bìú, ʋ nə yɩ Yoze bìú, ʋ nə yɩ Yoda bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ʋ nə yɩ Yʋanan bìú, ʋ nə yɩ Reza bìú, ʋ nə yɩ Zorobabɛlə bìú, ʋ nə yɩ Swɩalətɩɛlə bìú, ʋ nə yɩ Neri bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ʋ nə yɩ Mɛləki bìú, ʋ nə yɩ Adi bìú, ʋ nə yɩ Kʋzamə bìú, ʋ nə yɩ Ɛləmadamə bìú, ʋ nə yɩ Erə bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ʋ nə yɩ Zwezi bìú, ʋ nə yɩ Eliezɛrə bìú, ʋ nə yɩ Yorimə bìú, ʋ nə yɩ Matatə bìú, ʋ nə yɩ Levi bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ʋ nə yɩ Simeyon bìú, ʋ nə yɩ Zwida bìú, ʋ nə yɩ Zwʋzɛfə bìú, ʋ nə yɩ Yonamə bìú, ʋ nə yɩ Elɩakimə bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ʋ nə yɩ Meleya bìú, ʋ nə yɩ Mena bìú, ʋ nə yɩ Matata bìú, ʋ nə yɩ Natan bìú, ʋ nə yɩ *Davidə bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ʋ nə yɩ Yɩzayi bìú, ʋ nə yɩ Obɛdə bìú, ʋ nə yɩ Bozə bìú, ʋ nə yɩ Saləmon bìú, ʋ nə yɩ Naasʋn bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ʋ nə yɩ Amɩnadabə bìú, ʋ nə yɩ Adəmin bìú, ʋ nə yɩ Arəni bìú, ʋ nə yɩ Esərʋmə bìú, ʋ nə yɩ Pere bìú, ʋ nə yɩ Zwida bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ʋ nə yɩ *Zwakɔbə bìú, ʋ nə yɩ *Yɩzakə bìú, ʋ nə yɩ *Abərahamə bìú, ʋ nə yɩ Tera bìú, ʋ nə yɩ Nahɔrə bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ʋ nə yɩ Sərugə bìú, ʋ nə yɩ Rehu bìú, ʋ nə yɩ Pelɛgə bìú, ʋ nə yɩ Ebɛrə bìú, ʋ nə yɩ Swila bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ʋ nə yɩ Kayinamə bìú, ʋ nə yɩ Arəfakəzadə bìú, ʋ nə yɩ Sɛmə bìú, ʋ nə yɩ Nowe bìú, ʋ nə yɩ Lemɛkə bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ʋ nə yɩ Matɩsalɛmə bìú, ʋ nə yɩ Enokə bìú, ʋ nə yɩ Yerɛdə bìú, ʋ nə yɩ Malelɩɛlə bìú, ʋ nə yɩ Kenamə bìú, ");
INSERT INTO nnw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ʋ nə yɩ Enosə bìú, ʋ nə yɩ Sɛtə bìú, ʋ nə yɩ Adamə bìú, ʋ nə yɩ Yɩɩ bìú. ");
INSERT INTO nnw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kʋ máŋá tə wa, Zwezi nə súə́ də Yɩɩ-*Siŋu tə, ʋ nan Zwurədɛn mʋnaa tə con nə, də Yɩɩ-*Siŋu tə, kʋ nə wulə də wá. Kʋ jɩn wá, kʋ va kasɔɔ lanworu wa. ");
INSERT INTO nnw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","*Sɩtana də́də́n, sə ʋ yigu wá, ʋ pa ʋ tʋn yokʋkwɩʋn lá dɩan sapwilə. Tə dɩan təntə mama nə, ʋ wà wodiu dí. Yá tə dàń nə zwɛ̀e kwa nə, niən dàń jɩn wá. ");
INSERT INTO nnw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sɩtana dàń swɩ̀n ʋ con, ʋ wʋ́: «Də n nə ya Yɩɩ-Biu cɩ́gá mama, sə n pa nii kapan kʋ tə nə, sə kʋ jì wodiu». ");
INSERT INTO nnw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Zwezi ma le wá, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Kʋ tà wodiu cɩcɩ nə wàá mɩɩ kʋ pɩn lìù nə!› » ");
INSERT INTO nnw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sɩtana ma ja wá, ʋ va ban ʋ súrí lá, ʋ pa ʋ ywàń tɩa yuu pàrɩ̀ tə mama, naa nədʋ, ");
INSERT INTO nnw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Ba pɩn nə tə wiən tə mama, à ga wàá tə à pɩn lìù tə nə, à nə pɩ̀à. N nə sɛ̀e, sə n tʋ à yáá con, n pa dun nə, à wá pa mʋ́ dɩ̀àn tə tə mama, də tə pàrɩ̀ tə dun tə». ");
INSERT INTO nnw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Zwezi ma le wá, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Pa dun n *Yuu-Tiu Yɩɩ tə nə, sə n dàn ká tʋn won don, də kʋ nə tà kʋ tà cɩcɩ, ʋ nə swə›.» ");
INSERT INTO nnw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sɩtana ma kʋ́ʋ̀ ja wá ʋ va *Zwerizalɛmə, ʋ tún *Zwifə-ba Yɩɩ *dìə̀ tə yuu wa, ʋ ga swɩ̀n, ʋ wʋ́: «Də n nə yɩ Yɩɩ-Biu cɩ́gá mama, sə n zɩgɩ yəbə, n fan n tʋ tɩa. ");
INSERT INTO nnw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Yɩɩ wá pa nii ʋ *malɩkɛ nə n yɩrɩ, sə tə cɩ̀ n nə. ");
INSERT INTO nnw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yá tə wá tì mʋ́ tə jɩ̀àn wa, sə n naa dàn ká mà kapan nə›.» ");
INSERT INTO nnw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Zwezi ma le wá, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Dàn ká də́də́n Yuu-Tiu tə, ʋ nə yɩ n Yɩɩ, sə n yigu, ka pa ʋ tʋn yokʋkwɩʋn!› » ");
INSERT INTO nnw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ʋ nə də́də́n Zwezi yigu yiri mama, sə ʋ yigu, kʋ pa ʋ tʋn yokʋkwɩʋn ʋ zwɛ̀e, Sɩtana kɛ̀eń ʋ vìí ʋ yá wá, də kʋ ma kʋ́ʋ̀ vəli máŋá don, kʋ nə wá tʋ kʋ mɛ. ");
INSERT INTO nnw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Zwezi pìí ʋ va Galile nagwanaa tə wa də Yɩɩ-*Siŋu tə dɩ̀àn tə. Ba dàń ma zàn, ba swɩ̀n ʋ yoo, kʋ nagwanaa təntə mama wa. ");
INSERT INTO nnw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ʋ yà kàrɩ̀ *Zwifə-ba *jə́rə́ dii tə wa nə, yá lɩ̀à tə mɛ yà wulə ba pɩn wá dun. ");
INSERT INTO nnw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zwezi vəli *Nazarɛtə. Mə kʋ bwálɩ́ tə nə nə, ʋ bori. *Zwifə-ba *sìə́ dɩɩn nə, ʋ zʋa ba *jə́rə́ dìə̀ wa, ndə kʋ nə ya ʋ yofwamɩʋn nə. Ʋ zàn yɩɩ nə, sə ʋ kàrɩ̀ Yɩɩ sagɩ tə. ");
INSERT INTO nnw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba dàń ma tì Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi sagɩ tə, ba pa wá. Ʋ ja sagɩ tə ʋ súrí, ʋ dàń ga kàrɩ̀ bwálɩ́ tə, kʋ nə pʋ́pʋ́nɩ́, kʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«*Yuu-Tiu Yɩɩ-*Siŋu tə wulə à yuu wa. Kʋ kúrú nə, sə à pa sʋywáŋʋ́ tə zʋra nə. Ʋ tʋn nə, sə à swɩ̀n bàń dìə̀ lɩ̀à tə con də, Yɩɩ wá jon ba, sə à ga swɩ̀n lilirən con, də ba wá na lá, sə à swɩ̀n lɩ̀à tə, ba nə wulə càn wa, də Yɩɩ wá jon ba, ");
INSERT INTO nnw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","sə à swɩ̀n máŋá tə, Yuu-Tiu nə kúrí, sə ʋ ma fwa pubwanʋ ba yɩra». ");
INSERT INTO nnw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kʋ kwa nə, Zwezi púə́ sagɩ tə, ʋ tì ʋ pa jə́rə́ dìə̀ tʋ̀tʋ̀nʋ̀ tə nə, ʋ ga jə̀ə́. Lɩ̀à tə mama, ba nə wulə jə́rə́ dìə̀ tə wa, zɩ̀n ba yɩ́á, ba kə ʋ yuu. ");
INSERT INTO nnw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Kʋ tə ba tə, Yɩɩ nə swɩ̀n kʋ bwálɩ́ təntə wa, à nə kàrɩ̀ də á nə nì tə, nii dàń súə́ zə̀n kʋ tə, máŋá kʋ tə tətə wa, á nə nì kʋ». ");
INSERT INTO nnw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ba mama dàń ga bwɩ Zwezi nə, ʋ pubwanʋ sʋ̀ràn tə yɩrɩ, ʋ nə swɩ̀n, tə yà ga gwárɩ́ ba. Ba swɩ̀n, ba wʋ́: «Kʋ tà ʋ mʋ̀ nə yɩ Zwʋzɛfə bìú tə naaa?». ");
INSERT INTO nnw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «À yə̀ə́ də, á wá swɩ̀n zwansɩsarɩ ka tə à con nə: ‹Dɩmʋtʋrʋ, zwɛ̀e n tətə yayɩgʋ tə!› Á tə kʋ́ʋ̀ wá swɩ̀n à con, á wʋ́: ‹Nə nì kʋ tə, n nə fwa Kapɛrənayimə tɩʋ tə wa. Fwa tə mʋ̀ yìə̀n təntə də yəbə n tɩʋ tə wa›.» ");
INSERT INTO nnw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ʋ ma kʋ́ʋ̀ swɩ̀n ʋ súrí lá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Yɩɩ nii sʋ̀sʋ̀nʋ̀ tə̀lə́, ba nə sɛ̀e wá ʋ təntɩan tɩʋ wa. ");
INSERT INTO nnw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","À mʋ̀ nə swɩ̀n kʋ á con, kʋ yɩ cɩ́gá: Yɩɩ nii sʋ̀sʋ̀nʋ̀ Eli máŋá tə wa, dwà wà nɩ̀, bɩna batwa də cànɩ̀ bardʋ. Kʋ dàń yà dɩga niən nəfarʋ *Yɩzərayɛlə lʋʋ nii tə wa. Kʋ máŋá tə wa, kadənə yà dáá zənzən lá nə. ");
INSERT INTO nnw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yá Yɩɩ wà Eli tʋn ba ladʋa con, də kʋ nə tà kadənu tə con, ʋ nə wulə Sarɛpəta tɩʋ wa, kʋ nə wulə Sidon nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yɩɩ nii sʋ̀sʋ̀nʋ̀ Elize máŋá tə wa, dayaran də zənzən yà wulə Yɩzərayɛlə lʋʋ nii tə wa. Yá ba wa ladʋa dayan wá zwɛ̀e, də ʋ jì ləzwənzəŋu, də kʋ nə tà Naman cɩcɩ, ʋ nə nan Siri nagwanaa wa». ");
INSERT INTO nnw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lɩ̀à tə mɛ Zwifə-ba jə́rə́ dìə̀ tə wa nə nì tə yìə̀n təntə tì lɩŋa zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba zàn ba van Zwezi, ba ja nan tɩʋ tə wa, kʋ yà nə lwə̀ paan don yuu wa, sə ba lɩ wá paan tə yuu, ba dɩlɩ tɩa. ");
INSERT INTO nnw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ʋ dàń ma twá ba tətəŋi wa, ʋ nan ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zwezi vəli Kapɛrənayimə tɩʋ Galile nagwanaa wa. Yá ʋ dàń ma wulə ba ʋ kàrɩ̀ *Zwifə-ba *sìə́ dɩɩn nə. ");
INSERT INTO nnw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ʋ yà swɩ̀n də dɩ̀àn, kʋ mʋ̀ nə pɩn, kʋ gwárɩ́ lɩ̀à tə zənzən də ʋ kàrà təntə yiri. ");
INSERT INTO nnw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Zwifə-ba *jə́rə́ dìə̀ tə wa, bɛɛ don yà wulə lá, *zini yà nə wʋwalɩ wá. Ʋ mà nii zənzən, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aa! Bɛ̀eɛ̀e nə n pɩ̀à fwa nə yɩra, *Nazarɛtə Zwezi? Nə yə̀ə́ də, kʋ ya n twi, sə n cʋ̀gʋ̀ nəba. À yə̀ə́ zəni lìù tə, n nə yɩ. N yɩ lìù, ʋ nə lɩ ʋ tún Yɩɩ cɩcɩ yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Zwezi dàń caga zini nii nə, ʋ wʋ́: «Pú n nii, n ga nan n yá bɛɛ tə!» Zini tə dɩlɩ wá tɩa, lɩ̀à tə mɛ yáá nə, kʋ ga nan, kʋ yá wá, kʋ wà wá lwanɩ fwa. ");
INSERT INTO nnw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kʋ dɩ̀gà ba mama yuu zənzən, yá ba dàń ga swɩ̀n duən con, ba wʋ́: «Bɛ̀eɛ̀e sʋgʋ nə yɩ kʋ mʋ̀ təntə? Kʋ mʋ̀ bɛɛ təntə yàá baa də dɩ̀àn, ʋ ga pɩn zinə zìlí ʋ nii wa, tə ga naŋa də». ");
INSERT INTO nnw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yá ba dàń swɩ̀n Zwezi yoo, bwálɩ́ mama kʋ nagwanaa təntə wa. ");
INSERT INTO nnw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Zwezi nan *Zwifə-ba *jə́rə́ dìə̀ tə wa, ʋ va Simon sàń. Waran yà ja Simon tɩnkan zənzən. Ba dàń ma lòrì wá, sə ʋ pa wá yazurə. ");
INSERT INTO nnw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ʋ ma kwá ʋ yuu con. Yá ʋ ga baa ʋ pa nii, sə waran tə zwɛ̀e. Waran tə zwɛ̀e tə yá wá, yá ʋ zàn lala, ʋ wulə ʋ tanɩ, sə ʋ ma lɩ Zwezi vəri. ");
INSERT INTO nnw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yɩɩ nə zʋa kwa nə, ba jɩn ba tə mama, yayɩran yirə yirə nə ja, ba ja bà Zwezi con. Ʋ tún jɩ̀àn ba lìù mama yuu wa, ʋ zwɛ̀e ba yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Zinə də nan tə yá yayɩŋa zənzən, də tə bubwi, tə wʋ́: «N yɩ Yɩɩ-Biu». Yá Zwezi dàń baa tə nii nə də sʋ̀ràn, tə nə dà. Ʋ pɩ̀à, sə ʋ cɩ̀ tə nə, sə tə dàn ká swɩ̀n, tə mʋ̀ nə yə̀ə́ də, ʋ yɩ *Kərisə tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tɩa nə twi ka pʋrʋ, Zwezi nan tɩʋ tə wa, ʋ va kwa con bwálɩ́ tə, lìù nə tə̀lə́. Lalʋʋ dàń twá lá, ba pɩ̀à wá. Máŋá tə, ba nə twi, ba na wá, ba yà kʋ́ʋ̀ vəli, sə ba cɩ̀ ʋ nə, ʋ dàn ká kɛ̀eń ʋ yá ba. ");
INSERT INTO nnw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yá Zwezi swɩ̀n ba con, ʋ wʋ́: «À mɛ, sə à kàrɩ̀ də à swɩ̀n sʋywáŋʋ́ tə tɩan tə duən də wa, à bɩrɩ də, Yɩɩ wá də́ pàrɩ̀ ba yuu wa. Mə kʋ yɩrɩ nə, Yɩɩ tʋn nə». ");
INSERT INTO nnw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ʋ dàń ma twá lá ʋ kàrɩ̀ Zwide nagwanaa tə wa *Zwifə-ba *jə́rə́ dii tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dɩɩn don nə, Zwezi yà zɩga Zwenezarɛtə mʋnaa tə nii nə, lalʋʋ tə ga kɩkarɩ wá. Ba yugə duən, sə ba ma cʋgʋ Yɩɩ sʋywáŋʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ʋ nɩ nɩ́á yuu bwərə bələ bəbəru tə nii nə. Fəlijana tə yà nan ba nɩ́á yuu bwərə tə wa, ba cú, sə ba sɩn ba fələ gə̀gə̀lə̀n. ");
INSERT INTO nnw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zwezi dɩ̀gà nɩ́á yuu bori tə don wa, kʋ tə nə yɩ Simon nyiən, ʋ ga lòrì wá, sə ba fàrʋ́ ba nan bəbəru tə yɩra, ba va yáá mancɩn nɩ́á tə wa. Máŋá tə wa, ʋ nə jə̀ń nɩ́á yuu bori tə wa ʋ zwɛ̀e, ʋ wulə ʋ kàrɩ̀ lɩ̀à tə. ");
INSERT INTO nnw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ʋ nə kàrɩ̀ ʋ zwɛ̀e, ʋ swɩ̀n Simon con, ʋ wʋ́: «Van nɩ́á yuu bori tə, n ja va naluŋə bwálɩ́ nə. Kʋ kwa nə, sə á dɩlɩ á fələ gə̀gə̀lə̀n tə, sə á ma gwàn». ");
INSERT INTO nnw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon ma le wá, ʋ wʋ́: «Karnyɩna, nə tʋn tɩtɩn tə mama, nə ga wà won nɩ. Yá à wá twá n nii tə nə, à dɩlɩ fələ gə̀gə̀lə̀n tə». ");
INSERT INTO nnw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ba dàń ma dɩlɩ tə, yá ba jɩn fələ zənzən. Kʋ pa ba gə̀gə̀lə̀n tə wulə tə kàrɩ́. ");
INSERT INTO nnw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ba dàń ma gwɛn ba twaduən tə, ba nə wulə nɩ́á yuu bori tə don wa, sə ba bà ba san ba. Ba nə twi, ba kòrí fələ, ba sú ba nɩ́á yuu bwərə tə mɛ bələ. Tə ga tə pɩ̀à, sə tə mʋrɩ nɩ́á tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Máŋá tə wa, Simon Piyɛrə nə nɩ də, fələ tə nə dáá zənzən nətʋ, ba nə jɩn, kʋ dɩ̀gà ʋ yuu zənzən, də ba tə mɛ, ba nə yɩn də wá. Ʋ dàń tʋa ʋ nadwana nii nə Zwezi yáá con, ʋ ga swɩ̀n, ʋ wʋ́: «Nan kwa, n ga yá nə, *Yuu-Tiu, à nə ya cʋna lìù yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kʋ yɩn nətʋ də Simon tʋtʋnduən tə, ba nə yɩ Zebede bɩa, ba nə boŋə Zwakə də Zwan. Yá Zwezi dàń swɩ̀n Simon con, ʋ wʋ́: «Dàn ká pa fən ja mʋ́. Kʋ nə zɩgɩ sɩ́ʋ́n nə, n wá pɩ̀à lɩ̀à, sə ba twá à mʋ̀ Zwezi nə». ");
INSERT INTO nnw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ba dàń ma lɩ ba nɩ́á yuu bwərə tə, ba tún bəbəru yuu nə. Kʋ kwa nə, ba yá tə mɛ lá, ba ga twá Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dɩɩn don nə, Zwezi yà nə wulə tɩʋ don nə. Də nə̀ń, bɛɛ don, ʋ nə goŋi dayan, ʋ zwɛ̀e mɩ́ámɩ́án twi ʋ bà, ʋ tʋ Zwezi yáá con, ʋ ga lòrì wá, ʋ wʋ́: «*Yuu-Tiu, də n nə swə, n wàá n pɩn à dayan tə zwɛ̀e, sə à jì ləzwənzəŋu». ");
INSERT INTO nnw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zwezi ma te ʋ jɩɩn ʋ nə, ʋ dwen ʋ yɩra, ʋ ga wʋ́: «À swə, sə n dayan tə zwɛ̀e». Lala də dayan tə zwɛ̀e, ka ga yá wá. ");
INSERT INTO nnw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zwezi ma pa nii kʋ tə wá, ʋ wʋ́: «Dàn ká swɩ̀n kʋ yoo tə lìù mama con. Yá n dàń vəli n bɩrɩ n tɩ̀àn n nə nyɩn nətʋ tə *Zwifə-ba Yɩɩ *joŋwanʋ tə nə. N ga fwa *joŋi tə, ndə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə bɩrɩ Yɩɩ sagɩ tə wa, sə ba fwa dayaran pa, də ba dayan tə nə zwɛ̀e. Kʋ mʋ̀ nə bɩrɩ wá də, n dayan tə cɩ́gá zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Də kʋ mɛ, Zwezi yɩrɩ tə ga tə súə́ tɩa mama. Lalʋʋ twi, ba kun ʋ yuu nə, sə ba cʋgʋ wá, ba ga pa ʋ zwɛ̀e ba yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yá Zwezi dàń yà lɩ ʋ tɩ̀àn, ʋ ja va kasɔɔ lanworu wa, ʋ ma jʋ̀nɩ̀ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dɩɩn don nə, Zwezi yà wulə ʋ kàrɩ̀. *Farɩzɩan-ba də Yɩɩ nii *yənu tɩ̀án tə yà jə̀ə́ ʋ bɩan nə. Ba yà nan Galile nagwanaa tɩan tə mama wa, də Zwide nagwanaa tɩan tə mama wa, də *Zwerizalɛmə tə wa, ba bà. *Yuu-Tiu dɩ̀àn tə yà wulə də Zwezi tə ga pɩn ʋ zwɛ̀e yayɩŋa yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bara duən zɩn gwànʋ́ don tɩtaʋ wa, ba ja bà ba yí. Ba pɩ̀à, sə ba ja wá, ba zʋ dìə̀ tə wa, ba tún Zwezi yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yá ba yà yə̀rì bwálɩ́ tə, ba nə wá twá, sə ba ja wá ba zʋ, lɩ̀à tə dánɩ́ tə yɩrɩ. Ba dàń ma twá dəyuu wa, ba te wá, ba ga dɩ̀ ba poru dəyuu tə, ba twá lá nə, ba cú gwànʋ́ tə lalʋʋ tə tətəŋi wa Zwezi yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zwezi nə nɩ də, ba ken ba waa ʋ nə, ʋ dàń swɩ̀n yayɩŋʋ tə con, ʋ wʋ́: «À dabɛɛ, à kwɛn n cʋna tə à lɩ n mʋ̀ də Yɩɩ pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yɩɩ nii yənu tɩ̀án tə də Farɩzɩan-ba tə wulə, ba bʋŋa ba waa con nə, ba wʋ́: «Wàà nə yɩ kʋ bɛɛ tə, ʋ nə swɩ̀n nətʋ ʋ twɩn Yɩɩ nə? Wàà nə wàá cʋna ʋ kwɛn ʋ lɩ ʋ mʋ̀ də Yɩɩ pwərə wa? Kʋ yɩ Yɩɩ cɩcɩ!» ");
INSERT INTO nnw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Zwezi lwarɩ ba pubʋŋɩ tə, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á ma jə pubʋŋɩ tə tə yiri á waa nə? ");
INSERT INTO nnw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Də à nə swɩ̀n, à wʋ́: ‹À kwɛn n cʋna à lɩ à mʋ̀ də Yɩɩ pwərə wa›, nə à yə̀ə́, à nə wʋ́: ‹Zàn yɩɩ nə, n va!› - Kʋ kwà nə yɩ mwálɩ́? ");
INSERT INTO nnw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yá à dàń pɩ̀à, sə á yəni də, Yɩɩ ken dɩ̀àn *Ləzwənə-Biu jɩɩn wa tɩa yuu wa, sə ʋ kwɛn cʋna ʋ lɩ ʋ mʋ̀ də Yɩɩ pwərə wa». Zwezi dàń ga swɩ̀n sʋ̀ràn tətə gwànʋ́ tə con, ʋ wʋ́: «À mʋ̀ nə swɩ̀n kʋ n con nə: Zàn n tì n tɩtaʋ, n va n sàń!» ");
INSERT INTO nnw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lala bɛɛ tə zàn lɩ̀à tə mɛ yáá con, ʋ tì ʋ tɩtaʋ tə, ʋ yà nə tə́gə́ kʋ yuu wa tə, ʋ ja kɛ̀eń ʋ sàń, də ʋ bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kʋ gwárɩ́ ba mama zənzən. Kʋ də dɩ̀gà ba mama yuu wa, ba dàń ga bwɩ Yɩɩ nə, ba wʋ́: «Nə zə̀n nɩ yogwaran nə, tə nə wà nɩ abada». ");
INSERT INTO nnw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kʋ kwa nə, Zwezi nan, ʋ ga na lanpolɩnʋ. Ʋ yɩrɩ nə yɩ Levi, də ʋ jə̀ə́ ʋ joŋə lanpoo. Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Zàn n bà, n twá à nə!» ");
INSERT INTO nnw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi ma zàn, ʋ yá ʋ wiən mama, ʋ ga twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kʋ kwa nə, Levi bon Zwezi, sə ʋ də́ ʋ dìə̀ wa. Lanpolɩna zənzən də lɩ̀à duən də twi, yá yà wulə ba də́ də ba. ");
INSERT INTO nnw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Farɩzɩan-ba də Yɩɩ nii *yənu tɩ̀án tə, ba nə wulə ba vàn tə yuu tə ŋʋŋwɩn, ba ga swɩ̀n Zwezi karbɩa tə con, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, á ma də́ də á nywɩ̀n də lanpolɩna-ba, də cʋna lɩ̀à?» ");
INSERT INTO nnw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Zwezi ma le ba, ʋ wʋ́: «Lɩ̀à tə, ba yɩra nə zurə, ba dɩmʋtʋrʋ pɩ̀à, kʋ ya yayɩŋa nə pɩ̀à dɩmʋtʋrʋ. ");
INSERT INTO nnw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","À wà twi, sə à bon cɩ́gá tɩ̀án. Kʋ ya cʋna lɩ̀à tə, à twí, sə à bon, sə ba vəvəri ba kwa, ba ma sá ba cʋna tə». ");
INSERT INTO nnw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lɩ̀à duən swɩ̀n Zwezi con, ba wʋ́: «Zwan karbɩa tə mʋ̀ yàá vwə ba níə́ nɛɛ kapʋpʋ, ba jʋ̀nɩ̀ Yɩɩ, ndə *Farɩzɩan-ba fwa nətʋ. Yá n mʋ̀ karbɩa tə mʋ̀ ga də́ də ba nywɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Zwezi ma le ba, ʋ wʋ́: «Bɛɛ nə pɩ̀à ʋ vwa ʋ kan fúrú, ʋ dabara yàá bà, sə ba twá ba də́ fúrú tə diŋə tə. Á bʋŋa də, ba wá vwe ba níə́, ba dàn ká də́ wodiu tə, yá fúrú bɛɛ ga wulə də ba? ");
INSERT INTO nnw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yá máŋá dàń wá bà, fúrú bɛɛ tə nə bá ya lá. Kʋ mʋ̀ máŋá təntə wa, ba dàń wá vwa ba níə́». ");
INSERT INTO nnw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Zwezi dàń ma swɩ̀n zwansɩsara ba con, ʋ wʋ́: «Lìù tə̀lə́, ʋ nə wá cɩrʋ gandʋn, ʋ ma pú gandwan. Kʋ nətʋ tə nə fwa, ʋ wá cʋ̀gʋ̀ gandʋn tə, yá gantwandʋn tə ga bá jə̀ń gandwan tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yá lìù mama ba swana, tə nə wulə tə zaŋa, lwé ʋ kəni purə nədwara wa. Kʋ nətʋ tə nə fwa, tə mʋ̀ swana tə wá pa, purə tə pwin. Swana tə mama wá lwá tɩa, yá purə tə wá va bwàná. ");
INSERT INTO nnw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kʋ mɛ, sə ba kə swana, tə nə wulə tə zaŋa, purə nədʋra wa. ");
INSERT INTO nnw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yá lìù tə̀lə́, ʋ nə wá nyʋ swana, tə nə zàn tə zwɛ̀e, ʋ ga pìí ʋ lòrì swana, tə nə wulə tə zaŋa. Cɩ́gá, ba yàá swɩ̀n, ba wʋ́: ‹Swana tə nə zàn tə zwɛ̀e, tə nə ywán›.» ");
INSERT INTO nnw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","*Zwifə-ba *sìə́ dɩɩn don nə, Zwezi twá kárɩ́ wa ʋ kɛ̀eń, ʋ karbɩa tə kén mɩna yun, tə ba pʋpwaga ba jɩ̀àn wa, ba dɩŋɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","*Farɩzɩan-ba tə duən dàń ma swɩ̀n, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, á fwa kʋ tə, kʋ nə wà mɛ, sə ba fwa sìə́ dɩɩn nə?» ");
INSERT INTO nnw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Zwezi ma le ba, ʋ wʋ́: «Á wà Yɩɩ sagɩ tə kàrɩ̀, á na kʋ tə, pɩ̀ʋ́ *Davidə tətə nə fwa dɩɩn don nə, də ʋ kwa lɩ̀à tə, də niən nə jɩn ba naaa? ");
INSERT INTO nnw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ʋ zʋa Yɩɩ *dìə̀ tə wa, ʋ tì dipɛn tə, kʋ nə wulə lá nə, ʋ də́ ʋ ga lɩ ʋ pa ʋ lɩ̀à tə nə. Yá nə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, yà ga pa cwəŋə Yɩɩ *joŋwana tə cɩcɩ nə, sə ba mʋ̀ nə də́ Yɩɩ dìə̀ dipɛn təntə». ");
INSERT INTO nnw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Zwezi tə kʋ́ʋ̀ pìí, ʋ swɩ̀n ba con nə, ʋ wʋ́: «*Ləzwənə-Biu tə nə tɩ sìə́ dɩɩn tə tətə». ");
INSERT INTO nnw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","*Zwifə-ba *sìə́ dɩɩn don nə, Zwezi zʋa ba *jə́rə́ dìə̀ don wa, ʋ wulə lá ʋ kàrɩ̀. Bɛɛ don yà wulə lá, ʋ jɩzən vàn tə tɩga. ");
INSERT INTO nnw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Zwifə-ba Yɩɩ nii *yənu tɩ̀án də *Farɩzɩan-ba tə yà pàlɩ̀ Zwezi, ba ga cʋga ʋ nə, sə ba jə́n, də ʋ nə wá zwɛ̀e lìù yayɩgʋ kʋ sìə́ dɩɩn tə nə. Ba fwa kʋ nətʋ tə, ba yà pɩ̀à cwəŋə, sə ba twá kʋ nə, ba kʋnɩ ba kə ʋ nii nə, ba nə zɩga ʋ nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yá Zwezi yà yə̀ə́ ba pubʋŋɩ tə zəni. Ʋ dàń ma swɩ̀n bɛɛ tə con, ʋ jɩɩn tə nə tɩga, ʋ wʋ́: «Zàn yɩɩ nə, n zɩgɩ yəbə lɩ̀à tə mɛ yáá con!» Bɛɛ tə ma zàn ʋ zɩgɩ lá. ");
INSERT INTO nnw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kʋ kwa nə, Zwezi swɩ̀n ba con, ʋ wʋ́: «À bwe aba yoo kʋ tə: Bɛ̀eɛ̀e nə Yɩɩ *nii tə swɩ̀n, sə ba fwa sìə́ dɩɩn nə? Yozəŋu nə à yə̀ə́ yolwan? Kʋ mɛ, sə à jon bɛɛ tə mɩɩ, à kə lʋʋ, nə à yə̀ə́, sə à yá wá, ʋ cʋ̀gʋ̀?» ");
INSERT INTO nnw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ʋ zɩ̀n ʋ yáá ʋ ywàń ba mɛ tə, ʋ ga swɩ̀n bɛɛ tə con, ʋ wʋ́: «Làrɩ́ n jɩɩn tə à con!» Ʋ ma fwa kʋ, kʋ ga lwàń, kʋ jì jɩɩn nəzəŋu. ");
INSERT INTO nnw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ba nə nɩ kʋ nətʋ tə, lɩŋa súə́ Yɩɩ nii yənu tɩ̀án tə də Farɩzɩan-ba, ba dàń ga vʋrɩ kʋ tə yuu wa, ba nə wá fwa Zwezi. ");
INSERT INTO nnw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kʋ máŋá təntə wa, Zwezi dɩ̀gà paan yuu wa, ʋ jʋn Yɩɩ wuuu tɩtɩn tə mama, ʋ wà dwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tɩa nə twi ka pʋrɩ, ʋ bon ʋ karbɩa tə, ʋ kúrí ba wa lɩ̀à fugə bələ, ʋ kə ba yɩrɩ *tʋntʋna: ");
INSERT INTO nnw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon tə, ʋ nə bon ʋ yɩrɩ don Piyɛrə, də ʋ nubiu Andəre, də Zwakə, də Zwan, də Filipə, də Barətelemi, ");
INSERT INTO nnw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","də Matiə, də Toma, də Aləfe bìú Zwakə, də Simon tə, ba nə boŋə ‹*Zelotə›, ");
INSERT INTO nnw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","də Zwakə bìú Zwidə, də Zwidasə Yisəkariyɔtə, ʋ tə ʋ nə wá ja Zwezi ʋ pa ʋ dʋŋa nə. ");
INSERT INTO nnw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zwezi nan paan tə yuu ʋ cú, ʋ də ʋ karbɩa fugə bələ tə, ba ga va ba zɩga bwálɩ́ don nə, kʋ nə mɛ duən. Yá ʋ karbɩa zənzən duən də lɩ̀à duən zənzən yà wulə lá. Ba lɩ̀à təntə yà nan Zwide nagwanaa də *Zwerizalɛmə tə wa də Tirə də Sidon mʋʋ nii tɩan tə mama. Ba yà twi, sə ba nì ʋ kori, sə ba ga pa ʋ zwɛ̀e ba yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba tə, *zinə nə wʋwalɩ, nɩ yazurə. ");
INSERT INTO nnw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dɩ̀àn yà naŋa ʋ yɩra, tə zwɛ̀e yayɩran. Kʋ mʋ̀ nə pɩn, lalʋʋ tə mama kəni dɩ̀àn, sə ba dwen ʋ yɩra. ");
INSERT INTO nnw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Zwezi dàń ma ywàń ʋ karbɩa tə, ʋ ga swɩ̀n, ʋ wʋ́: «Á yana pupwən wa, á mʋ̀, á nə yɩ zʋra, Yɩɩ nə tɩ aba tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Á yana pupwən wa, á mʋ̀ niən nə jə sɩ́ʋ́n, á nə wá də́ wodiu á sú tə yɩrɩ. Á yana pupwən wa, á mʋ̀ lɩ̀à tə, á nə kwi sɩ́ʋ́n, á nə wá mʋn tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Á yana pupwən wa, á mʋ̀ lɩ̀à tə, ləzoni nə vɩga ba dʋgʋ, ba twɩn aba, ba swɩ̀n tə tə, tə nə ba ywán ba pɩn aba, *Ləzwənə-Biu tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Á yana pupwən wa máŋá tə wa, də kʋ nətʋ nə yí, á faŋa də pupwən ŋwɩ́rán nəfarʋ nə dànɩ̀ aba Yɩɩ *sàń nə yɩrɩ. Mə nətʋ nə ba nɩbara ba tə wʋwalɩ Yɩɩ nii *sʋ̀sʋ̀nà tə. ");
INSERT INTO nnw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lɛɛ nə wá yí á mʋ̀, á nə yɩ wiən tɩ̀án, á nə dí yáá, á na á pupwən tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Á yana pucʋnɩ wa, á mʋ̀ tə wodiu nə wà mùrì sɩ́ʋ́n nə, niən nə wá ja aba yɩrɩ. Á yana pucʋnɩ wa, á mʋ̀, á nə mʋŋa, á nə wá yà luə wa, á ga wá kwi tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Á yana pucʋnɩ wa, də lɩ̀à mama nə bwɩ á nə. Mə kʋ ya nətʋ nə ba nɩbara tə də ba kʋnkʋn sʋ̀sʋ̀nà tə fwa». ");
INSERT INTO nnw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«À mʋ̀ nə swɩ̀n kʋ á con, á mʋ̀ tə ba, á nə cʋga nə: Á swənə á dʋŋa! Á fwa zəni ba tə yɩra, ba nə dʋŋa aba! ");
INSERT INTO nnw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Á lòrì Yɩɩ, sə ʋ fwa zəni ba tə yuu wa, ba nə zɩrɩ ba kəni á nə! Á lòrì Yɩɩ á pa lɩ̀à tə nə, ba nə wʋwalɩ aba. ");
INSERT INTO nnw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Də lìù nə mà n pɩpara nədʋ nə, sə n vəvəri kʋ don tə, sə ʋ mà. Də lìù nə tì n gasɔɔ, yá, sə ʋ tì n ganbiə, də ʋ kə lá. ");
INSERT INTO nnw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pa lìù tə mama nə, ʋ nə lòrì won n con. Yá lìù nə tì kʋ tə, kʋ nə ya n mʋ̀ nyiən, dàn ká bwe wá kʋ yoo nə, sə ʋ kwan kʋ ʋ pa mʋ́. ");
INSERT INTO nnw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kʋ tə, n də nə pɩ̀à, sə ba tʋn ba pa mʋ́, tʋn kʋ, n pa ba duən tə nə. ");
INSERT INTO nnw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Də á nə swə lɩ̀à tə, ba nə swə aba cɩcɩ, bɛ̀eɛ̀e jwɩan dɩɩn won nə, á wá dɩ̀àn? Ba tə də tətə ba nə yɩ cʋna lɩ̀à, də swə lɩ̀à tə, ba nə swə ba! ");
INSERT INTO nnw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Də á nə fwa zəni ba tə cɩcɩ yɩra, ba də nə fwa á ba zəni, á wá fwa nətʋ, á ma dɩ̀àn jwɩan won? Ba tə də tətə, ba nə yɩ cʋna lɩ̀à də fwa nətʋ! ");
INSERT INTO nnw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yá də á nə jɩŋɩ á wiən ba tə cɩcɩ, á nə yə̀ə́ də, ba wá pìí ba pa aba kʋ tə, ba nə jɩŋɩ, á dàń wá twá nətə, á ma na kʋ jwɩan won? Ba tə, ba nə yɩ cʋna lɩ̀à, də yàá jɩŋɩ duən də səbiu, ba ga twi ba ŋwɩ́n, ndə nətʋ nə, ba nə jɩŋɩ kʋ. ");
INSERT INTO nnw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kʋ dàń nə ya á mʋ̀: Á swənə á dʋŋa, á fwa ba zəni! Á jɩŋa á ga lɩ yala á waa də, ba wá ŋwɩ́n aba. Á wá na ŋwɩ́rán tə nə dáá Yɩɩ con, á ga wá yà Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, bɩa, Yɩɩ nə ywán, ʋ pa ləzwən-yə̀rì-jwɩan də wʋlʋnyɩna-ba nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Á pɩan á dəri yinəgə zənzən, ndə á nyɩna Yɩɩ də nə dəri yinəgə zənzən nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á dànà ká bʋ̀rɩ̀ duən bʋ̀rà, sə Yɩɩ də dàn ká bʋ̀rɩ̀ á bʋ̀rà. Á dànà ká kə ba duən tə càn wa, Yɩɩ də bá kə aba càn wa. Á kwɩ̀án ba duən tə yìə̀n tə, á lɩ á mʋ̀ də ba pwərə wa, Yɩɩ də wá kwɛn á cʋna tə, ʋ lɩ á mʋ̀ də wá pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Á pɩan ba duən nə, Yɩɩ də wá pa aba. Ʋ wá lwá á garwa tə wa maŋʋ tə, kʋ nə ziən, kʋ nə zʋzʋgʋ, kʋ ga sú zəni kʋ pàlɩ́. Yɩɩ wá ywàń á maŋʋ tə, á nə maŋa á pɩn ba duən tə nə, ʋ ma man ʋ pa á də nə». ");
INSERT INTO nnw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Zwezi ma kʋ́ʋ̀ tì zwansɩsara kʋ tə, ʋ sɩsarɩ ba, ʋ wʋ́: «Liliu wàrɩ̀ ʋ don liliu ʋ vaŋa, kʋ ya kʋnkʋn, naaa? Kʋ nə nə yɩn nətʋ, ba mama wá tʋ bʋʋ wa. ");
INSERT INTO nnw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Karbiu tə̀lə́ ʋ nə dwə ʋ karnyɩna, yá ʋ dàń nə kálʋ́ ʋ tɩ̀àn ʋ kàrɩ̀ ʋ zwɛ̀e, ʋ wá yà ndə ʋ karnyɩna nə. ");
INSERT INTO nnw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Bɛ̀eɛ̀e nə pɩn, n ywàŋá gabiu tə, kʋ nə wulə n nubiu yii wa, yá n ga ba baŋa tə na, ka nə wulə n tətə yii tə wa? ");
INSERT INTO nnw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","N wá twá nətə, n ma swɩ̀n n nubiu con, n wʋ́: ‹À nubiu, yá, sə à lɩ gabiu kʋ tə, kʋ nə wulə n yii tə wa›, n mʋ̀ ga ba baŋa tə, ka nə wulə n tətə yii tə wa na? Níə́ bələ tíú, dí yáá n lɩ baŋa tə n yii tə wa. Yá n dàń wá na lá zəni, sə n ma lɩ gabiu tə, kʋ nə wulə n nubiu tə yii tə wa». ");
INSERT INTO nnw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Tɩzəŋu ba bìú kʋkwɩʋn zɩŋa, yá tɩkʋkwɩʋn ba bìú nəzəŋu zɩŋa. ");
INSERT INTO nnw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tɩ̀ʋ́ mama yɩ kʋ bìú nə nə, ba yàá ma lwarɩ kʋ. Ba ba lwɛ nə à yə̀ə́ kacan kwe casʋʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ləzwənzəŋu yàá pɩn yozəŋə naŋa kʋ tə nə súə́ ʋ waa con. Yá ləzwənkʋkwɩʋn də yɩ yokʋkwɩnan nə, ʋ yàá pɩn tə naŋa ʋ waa con. Ləzwənə nii yɩ kʋ tə nə súə́ ʋ waa nə, kʋ swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á ja nə á boŋə ‹*Yuu-Tiu, Yuu-Tiu›, á ga ba fwa kʋ tə, à nə wʋ́. ");
INSERT INTO nnw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Lìù tə mama, ʋ nə twi à con, ʋ cʋga à sʋ̀ràn tə, yá ʋ ga twá tə nii nə, à wá bɩrɩ aba lìù tə, ʋ də wá nə nyɩn duən. ");
INSERT INTO nnw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ʋ ya ndə lìù tə nə, ʋ nə wulə ʋ lwè dìə̀. Ʋ kʋa tɩa tə zənzən, kʋ zʋ, yá ʋ ga tún ka dəkuu tə kapataʋ yuu wa. Dwà nɩ́á nə twi, navwə tə mà dìə̀ tə, yá kʋ wà wànɩ́ kʋ gùrì ka, ka nə lwə̀ zəni yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lìù tə, ʋ nə cʋgʋ, ʋ ga wà kʋ nii nə twá yɩ ndə bɛɛ nə, ʋ nə tún ʋ dìə̀ dəkuu tɩtalʋ yuu wa, ʋ ga wà ka də̀ń kwɩ̀. Navwə nə twi kʋ mà ka, ka tʋa mwálɩ́ mwálɩ́, yá ka cʋna bwálɩ́ yɩn dánɩ́». ");
INSERT INTO nnw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Máŋá tə wa, Zwezi nə swɩ̀n lalʋʋ tə con, ʋ zwɛ̀e, ʋ kɛ̀eń ʋ va Kapɛrənayimə. ");
INSERT INTO nnw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kʋ bwálɩ́ tə nə, *Romə-ba pamana bíí yuu tíú don yà jə ʋ tʋtʋnbiu don, ʋ yoo nə cà kʋ pa wá. Kʋ tʋtʋnbiu təntə yà yɩ̀, ʋ pɩ̀à, sə ʋ tɩ. ");
INSERT INTO nnw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Máŋá tə wa, pamana bíí yuu tíú tə nə nì Zwezi ŋwɛn, ʋ tʋn *Zwifə-ba *nəkwɩna duən, sə ba lòrì wá, sə ʋ bà ʋ jon ʋ tʋtʋnbiu tə mɩɩ, ʋ kə lʋʋ wa. ");
INSERT INTO nnw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba twi Zwezi con, ba ga lòrì wá pwə pwə, ba wʋ́: «Kʋ bɛɛ tə mɛ, sə n pa wá n saŋʋ. ");
INSERT INTO nnw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ʋ swə nə lʋʋ lɩ̀à tə, yá ʋ mʋ̀ nə pa, ba lwà nə *jə́rə́ dìə̀ tə». ");
INSERT INTO nnw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Zwezi dàń ma pú ba kwa ʋ kɛ̀eń. Ʋ nə bwələ pamana bíí yuu tíú tə dìə̀ tə, ʋ zwɛ̀e, də pamana bíí yuu tíú tə tʋn ʋ dabara Zwezi con, ba swɩ̀n ʋ con, ba wʋ́: «*Yuu-Tiu, dàn ká wʋwalɩ n tɩ̀àn n súrí lá, à jɩɩn nə mùrì, sə n zʋ à dìə̀ wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mə kʋ mʋ̀ nə pɩn, à wà nɩ, sə à tətə bà n yáá con. N dàń pa nii cɩcɩ, yá à tʋtʋnbiu tə yayɩgʋ tə wá zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","À də tətə yɩ lɩ̀à duən nə tɩ nə, à də ga tɩ pamana duən. À nə swɩ̀n pamana tə don con, à wʋ́: ‹Vəli!› Ʋ wá va. À nə bon wà don, à wʋ́: ‹Bàá!› Ʋ wá bà. Yá à nə swɩ̀n à tʋtʋnbiu con, à wʋ́: ‹Fwa kʋ tə!› Ʋ wá fwa kʋ». ");
INSERT INTO nnw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Máŋá tə nə, Zwezi nə nì tə sʋ̀ràn təntə, tə poli ʋ pùə́. Ʋ pìí ʋ vəvəri, ʋ ga swɩ̀n lalʋʋ tə con, ba nə twá ʋ kwa, ʋ wʋ́: «À mʋ̀ nə swɩ̀n kʋ á con: À tə wà lìù nɩ *Yɩzərayɛlə lɩ̀à tə wa, ʋ nə keni ʋ waa Yɩɩ nə wuuu, ʋ dwən wà tə». ");
INSERT INTO nnw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lɩ̀à tə, ʋ nə tʋn tə ma pìí, ba va pamana bíí yuu tíú tə dìə̀ wa, ba na tʋtʋnbiu tə, də ʋ jə̀ə́ də yazurə. ");
INSERT INTO nnw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kʋ kwa nə, Zwezi vəli tɩʋ don, ba nə boŋə ‹Nayɛn›. Ʋ karbɩa tə də lɩ̀à zənzən yà twá də wá. ");
INSERT INTO nnw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Máŋá tə nə, ʋ nə bwələ tɩʋ tə nii, də ba ja tɩgɩ don, ba vələ ləbərə bwálɩ́ wa. Kʋ tɩgɩ tə yɩ kadənu don bidʋa. Tɩʋ tə lɩ̀à yà dáá zənzən, ba nə wulə də kan tə. ");
INSERT INTO nnw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Máŋá tə *Yuu-Tiu nə nɩ kadənu tə, ʋ yinəgə zʋa wá zəni, ʋ ma swɩ̀n ʋ con, ʋ wʋ́: «Dàn ká kwi!» ");
INSERT INTO nnw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ʋ ma fàrʋ́ ʋ yí, ʋ dwen tɩga tɩtaʋ tə yɩra, lɩ̀à tə nə zɩŋa tɩgɩ tə, ma zɩgɩ. Zwezi ma swɩ̀n, ʋ wʋ́: «Bisɩmaa, à pɩn nii mʋ́, zàn yɩɩ nə!» ");
INSERT INTO nnw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tɩgɩ tə ma kwɩ̀án ʋ zàn, ʋ ga wulə ʋ swɩ̀n. Zwezi ma tì wá, ʋ pa ʋ nuu nə. ");
INSERT INTO nnw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kʋ gwárɩ́ lɩ̀à tə mama zənzən, ba dàń ga bwɩ Yɩɩ nə, ba wʋ́: «Yɩɩ nii *sʋ̀sʋ̀nʋ̀ nəfarʋ twi nə pwərə wa! Yá Yɩɩ twi, sə ʋ san ʋ lɩ̀à nə tə nə». ");
INSERT INTO nnw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yá Zwide nagwanaa də kʋ tɩbii tə mama tə nə kɩkarɩ kʋ lɩ̀à nì kʋ tə, Zwezi nə fwa. ");
INSERT INTO nnw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zwan karbɩa tə swɩ̀n kʋ mama ʋ con. ");
INSERT INTO nnw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Zwan ma bon ba wa lɩ̀à bələ. Ʋ tʋn *Yuu-Tiu con, sə ba bwe wá: «N mʋ̀ nə yɩ lìù tə, Yɩɩ nə swɩ̀n də, ʋ wá bà, nə à yə̀ə́ nə mɛ, sə nə dɩ̀àn ʋ don?» ");
INSERT INTO nnw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ba nə vəli, ba yí Zwezi yɩra, máŋá tə nə, ba swɩ̀n ʋ con, ba wʋ́: «Zwan-Batisə tʋn nəba n con nə, sə nə bwe mʋ́, nə jə́n: ‹N mʋ̀ nə yɩ lìù tə, Yɩɩ nə swɩ̀n də, ʋ wá bà tə, nə à yə̀ə́ nə mɛ, sə nə dɩ̀àn ʋ don?› » ");
INSERT INTO nnw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kʋ máŋá təntə wa, Zwezi zwɛ̀e yayɩŋa zənzən yayɩran də ba nandatɩran. Ʋ lɩ *zinə ba yuu wa, ʋ ga pɩn lilirən zənzən yɩ́á súrí. ");
INSERT INTO nnw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kʋ kwa nə, ʋ dàń ma le Zwan karbɩa tə, ʋ wʋ́: «Á vələ á man á bɩrɩ Zwan nə kʋ tə, á nə nɩ, á ga nì də à fwa: Lilirən yɩ́á súrí, gwànɩ́ vəli, dayaran dayan zwɛ̀e, ba ga jì ləzwənzəŋə, zɩbʋŋa zɩan súrí, tɩga bwin ba naŋa. Yá zʋra də ga nə̀ń Yɩɩ sʋywáŋʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pupwən lɩ̀à nə yɩ lɩ̀à tə, ba nə ba nə vɩ nə, ba dʋgʋ kʋ tə yɩrɩ, à nə fwa». ");
INSERT INTO nnw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Máŋá tə wa, Zwan karbɩa tə nə vìí, Zwezi zàn ʋ wulə ʋ swɩ̀n Zwan yoo, ʋ bɩrɩ lalʋʋ tə nə, ʋ wʋ́: «Ləzwənyiri nətə nə á vəli á balɩ kasɔɔ lanworu tə wa? Kʋ tà lìù tə, ʋ nə yɩ ndə mancanɩ nə, vʋʋ nə vuvugə. ");
INSERT INTO nnw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ləzwənyiri nətə nə á dàń vəli á na? Kʋ tà bɛɛ, ʋ nə zʋa ganmʋla. Lɩ̀à tə, ba nə zwɩ ganmʋla, ba ga wulə ywánɩ́ wa, tà ba wulə pɛ̀egá dii wa, naaa? ");
INSERT INTO nnw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ləzwənyiri nətə nə á dàń vəli á na? Kʋ tà Yɩɩ nii *sʋ̀sʋ̀nʋ̀, naaa? Awo! À mʋ̀ nə swɩ̀n kʋ á con, də kʋ lìù təntə dwə Yɩɩ nii sʋ̀sʋ̀nʋ̀ tətə. ");
INSERT INTO nnw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kʋ lìù tə yoo pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Nə̀ń, à mʋ̀ Yɩɩ nə tʋn à tʋntʋnʋ n yáá con, sə ʋ kwɛn n cwəŋə tə, ʋ pa mʋ́›.» ");
INSERT INTO nnw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Zwezi kʋ́ʋ̀ swɩ̀n ʋ súrí lá, ʋ wʋ́: «À mʋ̀ nə swɩ̀n kʋ á con: Lʋʋ ləzoni wa, ba nə tʋrɩ, lìù wà lá yɩn, ʋ nə doni Zwan. Yá lìù tə, ʋ nə yɩ ləzoni tə mama nəmanbiə Yɩɩ pàrɩ̀ tə wa, tə dwə wá. ");
INSERT INTO nnw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lalʋʋ tə mɛ, də lanpolɩna tə yà cʋga wá. Ba lwarɩ də, Yɩɩ nə yɩ cɩ́gá, ba ga pa Zwan lə ba nɩ́á tə wa, kʋ twá də Yɩɩ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yá *Farɩzɩan-ba tə mʋ̀ də Yɩɩ nii *yənu tɩ̀án tə mʋ̀ vɩga kʋ tə, Yɩɩ nə dí yáá ʋ tanɩ ʋ tún, sə ʋ pa ba, ba ga vɩ, sə Zwan lə ba nɩ́á tə wa, kʋ twá də Yɩɩ yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Zə̀n ləzoni tə yɩ à wá tì ba, à ma man də bɛ̀eɛ̀e? Ba yɩ ndə wàà nə? ");
INSERT INTO nnw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ba yɩ ndə bìsɩ́ná nə, ba nə jə̀ə́ yəə kanporu wa, ba nə boŋə duən, ba swɩ̀n, ba wʋ́: ‹Nə wúrú wii nə kə á nə, sə á sa, á ga wà sɛ̀e. Nə nun pucʋnɩ nuŋi, nə pa aba, á ga wà kwi!› Mə zə̀n lɩ̀à tə də yɩ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Zwan-Batisə nə twi, ʋ ma ba wodinʋnʋ də́, ʋ ga ba swana nywɩ̀n, á swɩ̀n, á wʋ́: ‹Zinə nə jə wá›. ");
INSERT INTO nnw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kʋ kwa nə, *Ləzwənə-Biu tə nə twi, ʋ mʋ̀ ma də́ wodiu nəzəŋu, ʋ ga nywɩ̀n swana, á kʋ́ʋ̀ swɩ̀n, á wʋ́: ‹Nə̀ń, bɛɛ wà tə, ʋ yoyuu nə yɩ ka də́, də ka nyʋ swana ka sú. Ʋ yɩ lanpolɩna tə də cʋna lɩ̀à tə dabɛɛ!› » ");
INSERT INTO nnw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kʋ twá də ba tə, ba nə sɛ̀e wá, Yɩɩ yənu tə ma bɩrɩ kʋ tɩ̀àn ndə cɩ́gá nə. ");
INSERT INTO nnw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dɩɩn don nə, *Farɩzɩan don bon Zwezi, sə ʋ də́ də wá. Zwezi ma va kʋ bɛɛ tə bwálɩ́ nə, ba jə̀ə́ wodiu tə yuu wa, sə ba də́. ");
INSERT INTO nnw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kan don dàń yà yɩn tɩʋ tə wa, ʋ yà nə yɩ kan tə, ʋ nə yɩ cʋna kan. Kan təntə nì də, Zwezi jə̀ə́ Farɩzɩan tə bwálɩ́ nə, sə ʋ də́. Ʋ dàń ma ja pɩ̀ʋ̀ kapan kunkoli, ba nə boŋə ‹alɩbatɩrɩ›, ʋ bà. Kʋ nii yà nə súə́ də tɩralɩ nʋga. ");
INSERT INTO nnw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ʋ zɩga Zwezi kwa con, ʋ nɛɛ con nə. Ʋ wulə ʋ kwi, ʋ ga lwé ʋ yinɩa ʋ ma tɛ Zwezi nɛɛ, ʋ ja ʋ yukʋran ʋ ma pupugu tə mama. Kʋ kwa nə, ʋ kʋkwalɩ Zwezi nɛɛ tə ʋ lwé tɩralɩ nʋga tə ʋ nɛɛ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farɩzɩan tə, ʋ nə bon Zwezi, nə nɩ kʋ nətʋ, ʋ dàń swɩ̀n ʋ tɩ̀àn con nə, ʋ wʋ́: «Bɛɛ wà tə yà nə ya Yɩɩ nii *sʋ̀sʋ̀nʋ̀, ʋ yà wá yəni kan wà tə nə dwen ʋ yɩra nə ya lìù tə: Kan tə yɩ cʋna kan». ");
INSERT INTO nnw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Zwezi dàń ma swɩ̀n Farɩzɩan tə con, ʋ wʋ́: «Simon, à ja yoo à swɩ̀n n con nə». Simon ma le, ʋ wʋ́: «Swɩ̀n, karnyɩna!» ");
INSERT INTO nnw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ʋ dàń ma swɩ̀n, ʋ wʋ́: «Lìù don jɩŋa yà wulə lɩ̀à bələ yuu wa, ʋ don yà jə cɩnɩa səbikʋlan biənu, ʋ don də cɩnɩa səbikʋlan finu. ");
INSERT INTO nnw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ʋ nɩ də, ba lìù mama wàrɩ̀ jɩŋɩ tə ʋ ŋwɩ́n. Ʋ yá tə, ʋ ma ca ba bələ tə. Ba wàà nə wá sóní wá, ʋ doni ʋ don, ba bələ tə wa?» ");
INSERT INTO nnw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon ma le wá, ʋ wʋ́: «À bʋŋa də, kʋ wá yà wà tə, ʋ jɩŋɩ tə nə dáá tə tíú». Zwezi ma le wá, ʋ wʋ́: «N ja cɩ́gá!» ");
INSERT INTO nnw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ʋ pìí ʋ vəvəri ʋ yáá ʋ kə kan tə con, ʋ ga swɩ̀n Simon con, ʋ wʋ́: «N na kan wà tə? À zʋa n dìə̀, n ga wà nə à nɛɛ nɩ́á pɩn. Yá kʋ kan wà tə mʋ̀ ya ʋ yinɩa nə, ʋ ma tɛ à nɛɛ, ʋ ga pupugu tə də ʋ yukʋran. ");
INSERT INTO nnw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","N wà nə jə́rí n kʋkwalɩ n kə n nyʋnɩ nə. Kʋ kan wà tə mʋ̀ tə wà sìí də ʋ nə kʋkwalɩ à nɛɛ tə, à nə zʋa tə mama. ");
INSERT INTO nnw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","N wà nʋga lwé à yuu wa, yá ʋ mʋ̀ lwá tɩralɩ nʋga à nɛɛ yuu wa! ");
INSERT INTO nnw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mə kʋ mʋ̀ nə pɩn, à wʋ́: Ʋ sonu nəfarʋ tə, ʋ nə bɩrɩ tə, nə pɩn, də ʋ cʋna tə mɛ, sə tə kwɛn tə nan. Yá lìù tə, ba nə wà ʋ cʋna kwɛn zənzən ba lɩ, ʋ də bá bɩrɩ sonu zənzən». ");
INSERT INTO nnw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zwezi dàń ma swɩ̀n kan tə con, ʋ wʋ́: «N cʋna tə kwɛn tə nan n mʋ̀ də Yɩɩ pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ba tə, ba nə də́ də wá tə wulə ba ŋʋŋwɩn ba tɩ̀àn con nə, ba wʋ́: «Wàà nə yɩ lìù tə, ʋ wàá ʋ kwɛn lɩ̀à cʋna, ʋ lɩ ba mʋ̀ də Yɩɩ pwərə wa?» ");
INSERT INTO nnw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yá Zwezi dàń swɩ̀n kan tə con nə, ʋ wʋ́: «N keni n waa à nə wuuu, kʋ mʋ̀ nə pɩn, Yɩɩ ma jon mʋ́ n cʋna wa. Ve də bɩcan sìə́!» ");
INSERT INTO nnw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kʋ kwa nə, Zwezi vəli ʋ twá tɩan tə də tɩbii tə wa, ʋ kàrɩ̀ də ʋ swɩ̀n sʋywáŋʋ́ tə, ʋ bɩrɩ də, Yɩɩ də́ pàrɩ̀ ba yuu wa. Karbɩa fugə bələ tə yà wulə ʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kʋ súrí kana duən nə, ba nə jon ba tɩ̀àn *zinə də yayɩran jɩɩn. Kʋ yɩ Mari tə, ba nə boŋə ‹Mari Madəlɛnə›, Zwezi nə lɩ zinə barpɛ ʋ yuu wa, ");
INSERT INTO nnw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","də Suza, ʋ nə ywàŋá *Erodə tʋtʋnan tə yuu, kan Zwanə, də Sɩzanə, də kana duən, ba nə dáá. Ba mʋ̀ kana təntə tì ba jɩjə, ba ma san Zwezi də ʋ karbɩa tə nə. ");
INSERT INTO nnw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lɩ̀à tə naŋa tɩan də tɩan, ba twi Zwezi con. Lɩ̀à tə nə twi, ba kun duən nə ba dáá, máŋá tə wa, ʋ tì zwansɩsara kʋ tə ʋ sɩsarɩ ba, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Wodùrú don nə nan, sə ʋ dù wodwii. Ʋ dàń nə wulə ʋ mɩ́ wodwii tə kárá tə wa nə, kʋ vàn don tʋa cwəŋə yuu. Ba nɩŋɩ kʋ yuu ba kɛ̀eń, yá zənbii dí kʋ. ");
INSERT INTO nnw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kʋ vàn don də tʋa kapataʋ tɩa wa. Yá wobɩa tə nə nan tə zwɛ̀e, tə kʋa, zuni nə wà tə yí yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wobɩa tə vàn don də tʋa casʋran tɩa wa, tə də casʋran tə mɛ twá duən, tə boru, yá casʋran tə dàń púə́ wobii tə yuu nə, tə dàń ga sɩ̀nɩ̀ tə tɩ. ");
INSERT INTO nnw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yá tə vàn don də tʋa tɩzəŋu wa, wobɩa tə zàn tə bori tə kə yun. Kʋ nədʋ mama zɩn bɩa bíí». Zwezi dàń ma swɩ̀n ʋ kə yɩɩ nə, ʋ wʋ́: «Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni!» ");
INSERT INTO nnw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Zwezi karbɩa tə bwe wá, sə ʋ gwin zwansɩsara tə də̀ń, ʋ bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ʋ ma le ba, ʋ wʋ́: «Á mʋ̀ wàá Yɩɩ pàrɩ̀ yìə̀n tə, tə nə sə̀gə̀ tə də̀ń, á nì, á pɩn á tɩ̀àn nə. Lɩ̀à tə duən mʋ̀ con nə, kʋ yɩ zwansɩsarɩ nə, à wá swɩ̀n ba con, ba yɩ́á nə cə̀ lá, ba ga ba na, ba cʋga, yá ba ga ba kʋ də̀ń nə̀ń». ");
INSERT INTO nnw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Zwezi dàń swɩ̀n, ʋ wʋ́: «Zwansɩsara tə də̀ń nə nətən: Wodwii tə yɩ ndə ya Yɩɩ sʋgʋ tə nə. ");
INSERT INTO nnw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lɩ̀à duən yɩ ndə cwəŋə vàn nə, wobɩa nə twɩ lá: Ba nə̀ń, yá *Sɩtana yàá bà, ʋ lɩ sʋgʋ tə ba waa wa, sə ʋ ma cɩ̀ ba nə, sə ba dàn ká kə ba waa Yɩɩ nə, sə ʋ ga jon ba ba cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ba duən də yɩ ndə kapataʋ tɩa nə. Ba nə nì Yɩɩ sʋgʋ tə, ba yàá jon kʋ də pupwən. Yá ba ba kʋ yá, ba pɩn kʋ zwɩ ba pubʋŋa wa. Ba yàá ken ba waa Yɩɩ nə, máŋá kukuə wa, yá dədəŋu nə yí ba, máŋá don wa, ba yàá tʋ. ");
INSERT INTO nnw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wobɩa tə nə tʋa casʋran tə wa, yɩ ndə ba tə nə, ba nə nə̀ń, yá ba ga yá ba pa twara, də ka pɩ̀à jɩjə, də lʋʋ wiən fɩra jə ba, tə dàń ga pú Yɩɩ sʋgʋ tə yuu nə ba waa. Sʋgʋ tə ba bɩa keni, tə nə wá wànɩ́ tə bɩ. ");
INSERT INTO nnw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wobɩa tə nə tʋa tɩzəŋu tə wa, yɩ ndə ba tə nə, ba nə cʋga Yɩɩ sʋgʋ tə, ba ga twá kʋ nə zəni də ba cɩ́gá mama. Kʋ tɩ̀án tə yàá ja pɩ́nʋ́ wuuu, ba dàn ká pìí ba kə ba kwa, ba tʋŋa zəni, ndə wobɩa nə zɩŋa bɩa nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Lìù tə̀lə́, ʋ nə wá sʋrʋ cànʋ́, ʋ tì ʋ pú garwa də̀ń nə, nə à yə̀ə́ ʋ tì ʋ tún gədoo də̀ń. Kʋ yɩ ba yàá tì kʋ ba tún canzɩlʋ yuu, sə lɩ̀à tə mɛ nə zwɩ dìə̀ tə wá na poni. ");
INSERT INTO nnw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Won tə mama nə sə̀gə̀ wá na, yá won tə mama yà nə wulə yikunu wa, wá nan poni nə. Yá lɩ̀à tə mama wá lwarɩ kʋ. ");
INSERT INTO nnw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Á zurə á yɩra, də á cʋgʋ tə yiri tə, á nə cʋga: Ba wá pa ʋ tə nə, ʋ nə jə ba súrí, yá ba wá jon mancɩn tə tətə ʋ tə con, ʋ nə bʋŋa də, ʋ jə». ");
INSERT INTO nnw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Zwezi nubɩa tə də ʋ nuu twi ba na wá, yá ba ga wàrɩ̀ ʋ yɩra ba yí, lalʋʋ tə nə dáá tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ba ma swɩ̀n kʋ Zwezi con nə, ba wʋ́: «N nuu tə də n nubɩa tə zɩga kàrá wa, ba ga pɩ̀à, sə ba na mʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yá Zwezi dàń swɩ̀n ba mɛ con, ʋ wʋ́: «À nuu də à nubɩa nə yɩ ba tə nə cʋga Yɩɩ sʋgʋ tə, ba ga twá kʋ nii nə». ");
INSERT INTO nnw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dɩɩn don nə, Zwezi də ʋ karbɩa tə vələ ba zʋa nɩ́á yuu bori wa. Ʋ swɩ̀n ba con nə, ʋ wʋ́: «Nə vələ mʋnaa tə vàn tə don nə». Ba dàń ma vìí. ");
INSERT INTO nnw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Máŋá tə, ba nə wulə nɩ́á tə yuu wa, ba vəli, Zwezi mʋ̀ tə́gə́ ʋ dwɛ̀e. Naa nədʋ, vʋʋ nəfarʋ zàn kʋ fuli mʋnaa tə yuu wa. Nɩ́á yuu bori tə ja kʋ swí. Kʋ dàń yà ga yɩ càn, kʋ pa ba pɩ̀à ba tɩ. ");
INSERT INTO nnw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Karbɩa tə fàrʋ́ ba yí Zwezi yɩra ba zɩ̀n wá, ba ga swɩ̀n ʋ con, ba wʋ́: «Karnyɩna, karnyɩna! Nə wá tɩ!» Zwezi ma zàn, ʋ baa vʋʋ tə də nakulə tə nii nə, tə ma tʋ. Yá bwálɩ́ tə mɛ zùrì, siii. ");
INSERT INTO nnw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Zwezi ma swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á ba á waa keni à nə wuuu, naaa?» Yá fən yà jə ba, də kʋ dɩ̀gà ba yuu wa. Ba dàń swɩ̀n duən con, ba wʋ́: «Bɛɛ wà tə tà ndə lɩ̀à mɛ nə. Vʋʋ də nakulə mɛ zìlí ʋ nii!» ");
INSERT INTO nnw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ba yɩ də nɩ́á yuu bori, ba va ba yí Zwerazenɩan-ba nagwanaa wa, kʋ nə wulə mʋnaa tə vàn tə don nə, Galile nagwanaa yáá nə. ");
INSERT INTO nnw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zwezi nə cúə́ tɩa ʋ zwɛ̀e, tɩʋ tə bɛɛ don twi, ʋ jə́rí wá. *Zinə yà nə vəvəri kʋ bɛɛ təntə yuu. Kʋ nə ba yigə, kʋ bɛɛ təntə yà kʋ́ʋ̀ ba gànʋ̀ zwɩ, ʋ ga ba dìə̀ də zwɩ, ʋ yà yɩ ʋ wulə pɩ̀ràn bʋran wa, ba nə kʋa, ba ma keni tɩga. ");
INSERT INTO nnw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kʋ máŋá təntə, bɛɛ təntə nɩ Zwezi, ʋ mà bubwiə, ʋ tʋ ʋ yáá con, ʋ ga zɩ̀n ʋ kori ʋ kə yɩɩ nə, ʋ wʋ́: «Zwezi, Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, bìú, bɛ̀eɛ̀e nə n pɩ̀à à con nə? À lòrì mʋ́, dàn ká kə nə càn wa!» ");
INSERT INTO nnw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ʋ swɩ̀n kʋ nətʋ, Zwezi nə baa zini tə nii nə, sə kʋ nan kʋ yá wá yɩrɩ. Kʋ zinə tə yàá dɩ̀ wá nɛɛ kapʋpʋ. Ba dàń yà yàá vwa bɛɛ tə jɩ̀àn də ʋ nɛɛ də banzala də lugu ŋoni, sə ba ma wànɩ́ ba ja wá ba tún. Yá ʋ yàá karʋ banzala tə, zinə tə ga yàá van wá, kʋ ja va kasɔɔ lanworu wa. ");
INSERT INTO nnw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zwezi ma bwe kʋ, ʋ wʋ́: «N yɩrɩ nə ya bɛ̀eɛ̀e?» Kʋ ma le wá, kʋ wʋ́: «À yɩrɩ nə ya ‹buruburu›.» Kʋ yɩ cɩ́gá, zinə zənzən yà dáá ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yá tə zinə təntə yà lòrì Zwezi, sə ʋ dàn ká dɩŋa tə, ʋ kə bʋʋ tə, kʋ də̀ń nə lù zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Twərən zənzən yà wulə kʋ bwálɩ́ tə nə, tə pɩ̀à wodiu paan don yuu wa. Zinə tə lòrì Zwezi, sə ʋ pa cwəŋə tə, sə tə va tə zʋ twərən tə yɩra. Ʋ ma pa tə cwəŋə. ");
INSERT INTO nnw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zinə tə dàń ma nan bɛɛ tə con, tə va tə zʋ twərən tə. Twərən tə mama ma bəbəri tə cú, tə tʋ mʋnaa tə wa, tə gʋ tə tɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Máŋá tə wa, lɩ̀à tə, ba nə cɩ̀ twərən tə nə, nə nɩ kʋ mʋ̀ təntə kʋ tʋn, ba dəri ba ja kʋ ŋwɛn təntə, ba va ba swɩ̀n tɩʋ tə də tɩbii tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lɩ̀à tə nan, sə ba jə́n won tə nə fwa. Ba yí Zwezi nii, ba nɩ bɛɛ tə, zinə tə nə nan tə yá. Ʋ jə̀ə́ Zwezi səpuni nə, ʋ zʋ ganan, ʋ ga yə̀ə́ ʋ yáá zəni. Fən ma zʋ ba. ");
INSERT INTO nnw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ba tə, ba nə nɩ tə mɛ tə, swɩ̀n ba bɩrɩ, kʋ nə fwa nətʋ, zinə tə ma nan bɛɛ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kʋ nagwanaa tə lɩ̀à tə mama dàń ma lòrì Zwezi, sə ʋ vìí, fən zʋa ba zənzən yɩrɩ. Zwezi ma zʋ nɩ́á yuu bori tə wa, sə ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yá bɛɛ tə, zinə tə nə nan tə yá, twi ʋ lòrì Zwezi, sə ʋ yá ʋ pa ʋ twá ʋ nə. Yá Zwezi pìí wá, ʋ ga wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Pìí, n va n dìə̀, sə n ga swɩ̀n n bɩrɩ kʋ tə, Yɩɩ nə fwa n yɩra». Bɛɛ tə dàń ma pìí ʋ va, ʋ swɩ̀n tɩʋ tə mɛ wa kʋ tə, Zwezi nə fwa ʋ pa wá. ");
INSERT INTO nnw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Máŋá tə nə, Zwezi nə pìí ʋ naŋa mʋnaa tə bəbəru tə don nə, ʋ bɩ̀àn, lalʋʋ tə jə́rí wá, ba yà dànɩ̀ wá yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kʋ bwálɩ́ tə nə, bɛɛ don, ba nə boŋə Zwayirisə, ʋ yà nə yɩ *Zwifə-ba *jə́rə́ dìə̀ yuu tíú, twi ʋ bà ʋ tʋ Zwezi nɛɛ nə. Ʋ lòrì Zwezi, sə ʋ bà ʋ sàń nə, ");
INSERT INTO nnw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ʋ yà nə ja bʋ̀á nədʋ, ʋ bɩna nə yí ndə fugə bələ nə, ʋ yà nə wulə ʋ tɩ yɩrɩ. Zwezi vələ lá máŋá tə wa, lalʋʋ tə púə́ ʋ yuu nə, də ba nɩŋɩ ʋ nɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yá kan don yà wulə ba wa, ʋ tàŋá nə twi ka ba zɩga, kʋ nə yí bɩna fugə bələ. Ʋ yà cʋ̀gʋ̀ ʋ wiən mama dɩmʋtʋra con. Yá lìù mama wà wànɩ́, sə ʋ zwɛ̀e ʋ yayɩgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ʋ ma twá Zwezi kwa con, ʋ fàrʋ́ ʋ yí ʋ yɩra, ʋ ga dwen ʋ gànʋ̀ nii nə. Naa nədʋ, də ʋ jana tə lwagʋ tə zɩga. ");
INSERT INTO nnw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Zwezi ma bwe, ʋ wʋ́: «Wàà nə dwen à yɩra?» Ba mama tə wà sɛ̀e də, ba fwa yoo, Piyɛrə dàń ma swɩ̀n, ʋ wʋ́: «Karnyɩna, lalʋʋ tə nə púə́ n yuu nə, ba ga nɩŋɩ n nɛɛ nə». ");
INSERT INTO nnw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yá Zwezi le, ʋ wʋ́: «À nɩ də, dɩ̀àn nan à yɩra. Kʋ mʋ̀ nə pɩn, à yə̀ə́ də, lìù dwen à yɩra». ");
INSERT INTO nnw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kan tə nə nɩ də, ba jɩn ʋ də̀ń nə, ʋ twi ʋ bà ʋ tʋ Zwezi nɛɛ nə, də ʋ vɩvaga. Ʋ dàń ma tún lɩ̀à tə mɛ yáá con won tə, kʋ nə pɩn, ʋ ma dwen Zwezi yɩra, də kʋ nə twá nətʋ, ʋ yayɩgʋ tə ma zwɛ̀e naa nədʋ. ");
INSERT INTO nnw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «À nakʋa, n nə keni n waa à mʋ̀ nə tə yɩrɩ, Yɩɩ jon mʋ́. Vəli də bɩcan sìə́!» ");
INSERT INTO nnw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Máŋá tə wa, Zwezi nə wulə ʋ swɩ̀n nətʋ, lìù don nan jə́rə́ dìə̀ yuu tíú tə sàń, ʋ bà ʋ swɩ̀n ʋ con, ʋ wʋ́: «N bʋ̀á tə mɩɩ zwɛ̀e. N kʋ́ʋ̀ dàn ká wʋwalɩ karnyɩna tʋtʋ». ");
INSERT INTO nnw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Zwezi nə nì kʋ tə, ʋ swɩ̀n jə́rə́ dìə̀ yuu tíú tə con, ʋ wʋ́: «Dàn ká pa fən ja mʋ́! N ya kə waa cɩcɩ à mʋ̀ nə wuuu, yá ʋ wá na yazurə». ");
INSERT INTO nnw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Máŋá tə wa, ba nə yí sàń, Zwezi wà sɛ̀e, sə ʋ pa lɩ̀à tə mama twá ʋ nə ʋ bá zʋ, də kʋ nə tà Piyɛrə də Zwan də Zwakə, də bisɩmaa tə nuu də ʋ nyɩna. ");
INSERT INTO nnw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ba mama tə kwi, də ba zɩra bisɩmaa tə yɩrɩ. Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Á dànà ká kwi. Ʋ wà tɩ, kʋ yɩ ʋ dwɛ̀e!» ");
INSERT INTO nnw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ba wulə ba mʋŋa Zwezi, ba nə yə̀ə́ də, bʋ̀á tə yɩ ʋ tɩga yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yá Zwezi jɩn ʋ jɩɩn nə, ʋ ga swɩ̀n ʋ kə yɩɩ nə, ʋ wʋ́: «Bisɩmaa, zàn yɩɩ nə!» ");
INSERT INTO nnw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ʋ pìí ʋ bwin, ʋ ga zàn naa nədʋ. Zwezi ma pa nii, sə ba pa wá wodiu. ");
INSERT INTO nnw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kʋ dɩ̀gà ʋ nyɩna-ba yuu zənzən, yá Zwezi swɩ̀n ba con də, ba dàn ká swɩ̀n kʋ tə, kʋ nə tʋn lìù mama con. ");
INSERT INTO nnw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zwezi ken ʋ karbɩa fugə bələ tə duən nə, ʋ ga pa ba nii də dɩ̀àn, sə ba lɩ *zinə lɩ̀à yuu wa, sə ba ga zwɛ̀e yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ʋ dàń ma tʋn ba, sə ba va ba kàrɩ̀ ba bɩrɩ də, Yɩɩ də́ ʋ pàrɩ̀ tə lɩ̀à yuu wa, sə ba ga zwɛ̀e yayɩŋa yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ʋ swɩ̀n ba con nə, ʋ wʋ́: «Á dànà ká tì wiən tətə nətən á ja nan cwəŋə. Tə mʋ̀ nə yɩ: Daduu, də lɔ̀ɔ̀, də wodiu, də səbiu, də ganzwɩran bələ. ");
INSERT INTO nnw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bwálɩ́ tə mama á nə zʋrɩ, á yana kʋ dìə̀ tə wa, kʋ ja vələ á viru. ");
INSERT INTO nnw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bwálɩ́ tə mama, ba nə vɩga, sə á zʋ, sə á nan, á yá ba tɩʋ. Á ga zwarɩ á nɛɛ purən, sə kʋ yà ba yuu yoo». ");
INSERT INTO nnw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Karbɩa tə ma vìí, ba vəli tɩan tə mɛ pa wa, ba swɩ̀n sʋywáŋʋ́ tə, ba ga zwɛ̀e yayɩŋa yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Máŋá tə, *Erodə, ʋ nə yɩ Galile nagwanaa tə yáá tíú, nə nì kʋ tə nə wulə kʋ tʋŋa, kʋ gwárɩ́ wá zəni. Lɩ̀à duən yà wʋ́: «Zwan nə pìí, ʋ bwin ʋ nan tɩan wa». Ba duən də wʋ́: «Kʋ ya Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli nə pìí ʋ bà». Ba duən də tə kʋ́ʋ̀ wʋ́: «Fuən Yɩɩ nii sʋ̀sʋ̀nà tə don nə pìí ʋ bwin». Kʋ mʋ́ nə pɩn, Erodə yàá kʋ́ʋ̀ yə̀rì kʋ tə, ʋ nə wulə kʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erodə dàń ma swɩ̀n, ʋ wʋ́: «À pɩn ba gwəŋə Zwan yuu. Wàà tətə dàń nə yɩ bɛɛ təntə à nə nə̀ń ʋ ŋwɛn də ba swɩ̀n nətən?» Ʋ dàń yà ga pɩ̀à, sə ʋ na Zwezi. ");
INSERT INTO nnw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Zwezi *tʋntʋna tə pìí ba bà ʋ con, ba man kʋ tə mama, ba nə fwa, ba bɩrɩ wá. Ʋ ma ja ba, ʋ də ba cɩcɩ ma va, ba nan kwa, tɩʋ don nii nə, kʋ yɩrɩ nə yɩ Bɛtəsayɩda. ");
INSERT INTO nnw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yá lalʋʋ tə lwarɩ kʋ, ba ma zàn ba pú ʋ kwa. Zwezi ma jə́rí ba zəni, ʋ swɩ̀n Yɩɩ pàrɩ̀ tə yoo, ʋ bɩrɩ ba. Ʋ zwɛ̀e ba tə, ba nə pɩ̀à yazurə yayɩran. ");
INSERT INTO nnw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yɩɩ nə wulə kʋ zwɩ máŋá tə wa, tʋntʋna fugə bələ tə fàrʋ́ ba yí Zwezi yɩra, ba ga wʋ́: «Swɩ̀n lalʋʋ tə con, sə ba va tɩan tə də tɩbii tə wa, tə nə bwələ tɩa lá, ba pɩ̀à ba nii wodiu, də yipaa bwálɩ́. Bwálɩ́ kʋ tə nə nə wulə lá, won mama tə̀lə́ wa». ");
INSERT INTO nnw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yá Zwezi swɩ̀n ba con, ʋ wʋ́: «Á tətə pɩan ba wodiu, sə ba də́!» Ba ma le wá, ba wʋ́: «Dipɛn bonu də fələ bələ cɩcɩ nə nə jə. Də nə nə pɩ̀à nə pa wodiu lɩ̀à tə mama nə, nə tətə nə mɛ, sə nə va nə yə̀ kʋ wodiu tə». ");
INSERT INTO nnw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bara mʋ̀rʋ̀ bonu yà nə wulə kʋ bwálɩ́ təntə nə. Zwezi ma swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á pɩan ba jə̀ń ndə finu finu nə púlí mama wa». ");
INSERT INTO nnw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Karbɩa tə twá ʋ nii nə, ba pa ba mama tə jə̀ń tɩa. ");
INSERT INTO nnw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Zwezi tì dipɛn bonu tə də fələ bələ tə, ʋ zɩ̀n ʋ yáá, ʋ kə yɩɩ nə, ʋ ga kə Yɩɩ lɛ̀eɛ̀e. Ʋ fʋ fʋ dipɛn tə, ʋ pa karbɩa tə nə, sə ba ma tara lalʋʋ tə. ");
INSERT INTO nnw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ba mama tə dí, ba sú, ba ga pɛ̀e dipɛn tə mumunə ba sú fɩyaran fugə bələ. ");
INSERT INTO nnw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dɩɩn don nə, Zwezi nə kwɛn ʋ nan kwa ʋ jʋ̀nɩ̀ Yɩɩ, ʋ karbɩa tə ga wulə də wá, ʋ bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə lɩ̀à tə swɩ̀n à yuu wa?» ");
INSERT INTO nnw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ba ma le, ba wʋ́: «Lɩ̀à duən wʋ́, n yɩ *Zwan-Batisə, ba duən wʋ́, n yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli, ba duən də ga kʋ́ʋ̀ wʋ́, kʋ yɩ Yɩɩ nii sʋ̀sʋ̀nʋ̀ tə don nə pìí ʋ bwin ʋ nan». ");
INSERT INTO nnw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Zwezi ma bwe ba, ʋ wʋ́: «Sə á mʋ̀ con nə, wàà nə á wʋ́ à yɩ?» Piyɛrə ma le, ʋ wʋ́: «N yɩ *Kərisə tə, lìù tə, Yɩɩ nə kúrú ʋ tʋn». ");
INSERT INTO nnw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Zwezi ma dù súú ba nii nə, sə ba dàn ká swɩ̀n kʋ lìù con. ");
INSERT INTO nnw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ʋ ga swɩ̀n ʋ súrí lá, ʋ wʋ́: «Kʋ mɛ sə, *Ləzwənə-Biu tə də́ càn zənzən. *Zwifə-ba *nəkwɩna tə, də Yɩɩ *joŋwana yun tɩ̀án, də Yɩɩ nii *yənu tɩ̀án tə wá vɩ wá, ba wá gʋ wá. Yá dɩan batwa nii nə, ʋ wá pìí ʋ bwin ʋ nan». ");
INSERT INTO nnw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ʋ ma swɩ̀n ba mama tə con, kʋ kwa nə, ʋ wʋ́: «Lìù tə mama nə pɩ̀à, sə ʋ bà ʋ twá à nə, kʋ tíú kʋ́ʋ̀ dàn ká fwa ʋ təntɩan puswənə. Ʋ mɛ, sə ʋ sɛ̀e ʋ twá ʋ də́ càn də nə, dɩɩn mama, kʋ ja vələ ʋ tɩan dagarʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kʋ yɩ cɩ́gá, lìù tə, ʋ nə pɩ̀à, sə ʋ jon ʋ mɩɩ tə, ʋ wá kwɩ̀n kʋ nə. Yá lìù tə, ʋ nə wá dʋgʋ ʋ mɩɩ tə à mʋ̀ yɩrɩ, kʋ tíú wá jon ʋ mɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kʋ funə wa yə̀n nə, kʋ pa lìù nə, də ʋ nə nɩ tɩa yuu jɩjə tə mama, yá ʋ ga kwɩ̀n mɩɩ tə nə, kʋ nə ba zwɛ̀e Yɩɩ con, nə à yə̀ə́ ʋ nə cʋ̀gʋ̀. ");
INSERT INTO nnw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lìù nə dəri à mʋ̀ də à sʋ̀ràn tə cavɩra, *Ləzwənə-Biu tə də wá dəri n cavɩra máŋá tə wa, ʋ nə wá bà ʋ dun tə wa, də ʋ nyɩna Yɩɩ də ʋ *malɩkɛ tə dun tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á wa lɩ̀à, ba nə wulə yəbə, mɛ bá tɩ, də ba nə wà Yɩɩ pàrɩ̀ tə nɩ, də kʋ twi». ");
INSERT INTO nnw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ʋ swɩ̀n nətʋ ndə dɩan nana kwa nə, Zwezi jɩn Piyɛrə də Zwan də Zwakə, ʋ ja dɩ̀ ʋ con paan don yuu wa, sə ʋ jʋn Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Máŋá tə nə, ʋ nə jʋ̀nɩ̀ Yɩɩ, ʋ yáá lwàń. Yá ʋ ganan jì nəpon tə pɩpɩlɩ. ");
INSERT INTO nnw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Də nə̀ń, lɩ̀à bələ, ba wulə ba ve də Zwezi. Kʋ yɩ *Moyizə də Eli, ");
INSERT INTO nnw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","nə nan də Yɩɩ dun tə. Ba wulə ba swɩ̀n də Zwezi, ʋ nə mɛ, sə ʋ tɩ ʋ pìí ʋ nan ʋ va Yɩɩ con, kʋ yoo tə nə mɛ, sə kʋ tʋn nətʋ *Zwerizalɛmə wa. ");
INSERT INTO nnw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyɛrə də karbɩa tə duən yà dwɛ̀e tətə, yá ba dàń twi ba zàn, ba ga na Zwezi dun tə, də bara bələ tə, ba nə wulə də wá. ");
INSERT INTO nnw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ba bara bələ tə dàń nə pìrí, ba vìrí máŋá tə wa, Piyɛrə swɩ̀n Zwezi con nə, ʋ wʋ́: «Karnyɩna, kʋ ziən də, nə wulə yəbə. Nə wá pú gansilə batwa, n mʋ̀ nədʋ, Moyizə nədʋ, Eli də nədʋ». Ʋ yà yə̀rì kʋ tə, ʋ nə swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Máŋá tə wa, ba nə wulə ba swɩ̀n nətʋ, bakwan yɩywara púə́ ba yuu nə. Fən zʋa karbɩa tə, də ba nə nɩ bakwan tə, kʋ púə́ ba yuu nə. ");
INSERT INTO nnw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Karbɩa tə nì kori, kʋ nə swɩ̀n bakwan tə wa, kʋ wʋ́: «Wàà tə ya à bìú tə, à nə kúrú. Á cʋga ʋ kori!» ");
INSERT INTO nnw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kori tə nə swɩ̀n kʋ zwɛ̀e kwa nə, Zwezi cɩcɩ nə ba kʋ́ʋ̀ na lá. Karbɩa tə púə́ ba nii. Kʋ máŋá tə wa, ba ba kʋ tə, ba nə nɩ tə, yoo swɩ̀n lìù con. ");
INSERT INTO nnw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kʋ tɩkʋnɩ nə, ba nə nan paan tə yuu ba cú máŋá tə, lalʋʋ twi ba jə́rí Zwezi. ");
INSERT INTO nnw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bɛɛ don bubwi lalʋʋ tə tətəŋi wa, ʋ wʋ́: «Karnyɩna, à lòrì mʋ́, sə n ywàń à bìú tə con! Ʋ mʋ̀ nə yɩ à bidʋa. ");
INSERT INTO nnw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","*Zini tə yàá ja wá, naa nədʋ kʋ pa, ʋ mà nii kʋ zʋzʋgʋ wá də dɩ̀àn, ʋ mɩmanpon ga sùrì. Kʋ yàá wʋwalɩ wá, kʋ ga ba naŋa mwálɩ́ mwálɩ́. ");
INSERT INTO nnw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","À lòrì n karbɩa tə, sə ba lɩ zini tə ʋ yuu wa, yá ba ga wà wànɩ́». ");
INSERT INTO nnw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Zwezi dàń ma le, ʋ wʋ́: «Á mʋ̀ zə̀n lɩ̀à-ba, á tə nə ba Yɩɩ nii sɛ̀e, á ga fwa yotələn! Dɩan bagalɩ nə à tə wá yà də aba, sə à ga ja pɩ́nʋ́ də aba? Ja n bìú tə n ja bà yəbə». ");
INSERT INTO nnw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bìú tə nə fàrʋ́, sə ʋ boli Zwezi yɩra, máŋá tə, zini tə jan wá, kʋ taŋʋ tɩa, kʋ ga vʋvʋgʋ wá zənzən. Yá Zwezi dàń caga zini tə nii nə, ʋ wʋ́, kʋ nan kʋ yá bìú tə. Ʋ tì wá, ʋ pa ʋ nyɩna nə. ");
INSERT INTO nnw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yá Yɩɩ dɩ̀àn nə dáá nə tʋn kʋ mʋ̀ yoo təntə, kʋ dàń gwárɩ́ ba mama zənzən. Ndə yìə̀n tə mama Zwezi nə fwa, tə nə gwárɩ́ lìù mama, ʋ swɩ̀n ʋ karbɩa tə con nə, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Á jana kʋ tə, à nə wá swɩ̀n á con, sɩ́ʋ́n nə zəni: Ba wá ja *Ləzwənə-Biu tə, ba kə ləzoni jɩ̀àn wa, sə ʋ də́ càn». ");
INSERT INTO nnw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ba wà kʋ sʋgʋ tə də̀ń nì. Kʋ dàń yà sə̀gə̀ ba con nə, sə ba dàn ká wànɩ́ kʋ ba nì, yá ba yà kʋ́ʋ̀ wàrɩ̀, sə ba bwe Zwezi kʋ sʋgʋ tə də̀ń nə. ");
INSERT INTO nnw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Zwezi karbɩa tə dɩga tʋ́tʋ̀nɩ́, sə ba ma lwarɩ lìù tə, ʋ nə wá yà ba yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Zwezi lwarɩ ba pubʋŋɩ tə. Ʋ dàń ma tì bisɩmaa ʋ kə ʋ yɩra, ");
INSERT INTO nnw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ʋ ga swɩ̀n, ʋ wʋ́: «Lìù tə, ʋ nə jɩn bisɩmabiə wà tə zəni à mʋ̀ yɩrɩ, kʋ yɩ à mʋ̀ tətə nə kʋ tíú jɩn zəni. Yá lìù tə, ʋ nə jɩn nə zəni, kʋ tíú jɩn lìù tə, ʋ nə tʋn nə zəni. Lìù tə, ʋ nə ya nəmaa á mama wa, kʋ tíú nə ya yuu tíú». ");
INSERT INTO nnw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zwan ma swɩ̀n, ʋ wʋ́: «Karnyɩna, nə nɩ bɛɛ don ʋ ja n yɩrɩ tə, ʋ ma lɩ *zinə. Nə yà swɩ̀n də, ʋ ba cwəŋə jə, sə ʋ fwa kʋ, ʋ nə twá ʋ tà nə wa lìù tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yá Zwezi le wá, ʋ wʋ́: «Á dànà ká cɩ̀ ʋ nə, á yaga wá, sə ʋ fwa! Cɩ́gá, lìù tə, ʋ nə ba á nə zɩga, yɩ á lìù». ");
INSERT INTO nnw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Zwezi ka tɩ də ʋ ka dɩ̀ yɩɩ nə máŋá nə bwələ, ʋ zɩgɩ dɩ̀àn, kʋ máŋá tə wa, sə ʋ va *Zwerizalɛmə tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Zwezi dí yáá ʋ tʋn lɩ̀à ʋ yáá nə. Ba dí yáá ba vu ba zʋ Samari nagwanaa tɩʋ don wa, sə ba kwɛn bwálɩ́ lá ba pa wá. ");
INSERT INTO nnw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yá kʋ tɩʋ tə lɩ̀à vɩga, sə ba sɛ̀e Zwezi, ʋ nə vələ Zwerizalɛmə tə con yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Máŋá tə nə, Zwakə də Zwan nə nɩ kʋ nətʋ, ba swɩ̀n, ba wʋ́: «*Yuu-Tiu n pɩ̀à, sə nə lòrì mən, sə tə nan yɩɩ tə cú, tə dí ba naaa?» ");
INSERT INTO nnw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Zwezi ma pìí ʋ vəvəri ʋ caga ba nii nə. ");
INSERT INTO nnw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ba ma lɛ ba va tɩʋ don nə. ");
INSERT INTO nnw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ba wulə cwəŋə yuu, də bɛɛ don swɩ̀n Zwezi con, ʋ wʋ́: «À wá twá n nə, bwálɩ́ mama, n nə vələ». ");
INSERT INTO nnw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Zwezi ma le wá, ʋ wʋ́: «Ciləcərən jə tə bʋran tə zwɩ, zənbii də ma jə tə pwalan, yá *Ləzwənə-Biu tə mʋ̀ ba bwálɩ́ ja, ʋ nə wá kə ʋ yuu lá». ");
INSERT INTO nnw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ʋ ma swɩ̀n bɛɛ don con, ʋ wʋ́: «Twá à nə!» Yá bɛɛ tə swɩ̀n, ʋ wʋ́: «*Yuu-Tiu pa nə cwəŋə, sə à də́ yáá à va à gùrì à nyɩna, sə à ga fwa ʋ luə». ");
INSERT INTO nnw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Zwezi ma le wá, ʋ wʋ́: «Yá, sə tɩga tə tɩ̀án tə, ba nə ba mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con, gùrì ba tɩga. Yá n mʋ̀ n wá va n swɩ̀n Yɩɩ pàrɩ̀ tə yoo n bɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bɛɛ don ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yuu-Tiu, à wá twá n nə, yá n dàń nə yá nə, sə à va à jʋn à dìə̀ lɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zwezi ma le wá, ʋ wʋ́: «Kʋ yɩ ndə lìù tə, ʋ nə wulə ʋ vàrɩ̀ də nɩan varʋ, yá ʋ ga pìí ʋ palɩ ʋ kwa. Kʋ nətʋ bɩrɩ də, kʋ tíú jə pubʋŋɩ bələ. Ʋ mʋ̀ lìù təntə yiri ba wànɩ́ Yɩɩ pàrɩ̀ tə tʋtʋnan tə ʋ tʋn». ");
INSERT INTO nnw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kʋ kwa nə, *Yuu-Tiu kúrí bara duən sapwɩtwa də fugə də bələ, ʋ tʋn bələ bələ ʋ yáá. Ʋ tʋn ba tɩan tə mɛ wa də bwálá tə mɛ, ʋ tətə yà nə mɛ, sə ʋ va lá. ");
INSERT INTO nnw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ʋ swɩ̀n ba con, ʋ wʋ́: «Kárá tə wiən tə bɩga zənzən, yá wocərə ba dáá, sə ba kə tə dìə̀ wa. Á lorə kárá tə tíú, sə ʋ tʋn wocərə ʋ súrí lá, sə ba kə ʋ wiən tə dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","À tʋŋa aba cwəŋə yuu, ndə pabii nə buyurən tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Á dànà ká tì səbiu, nə à yə̀ə́ lɔ̀ɔ̀ nə à yə̀ə́ natʋra! Á dànà ká zɩgɩ cwəŋə yuu, á jʋn lìù. ");
INSERT INTO nnw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Á nə zʋa sàń wa, sə á dí yáá á swɩ̀n, á wʋ́: ‹Yɩɩ bɩcan sìə́ tə wá yà də aba›. ");
INSERT INTO nnw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Də lìù nə wulə sàń təntə wa, ʋ nə pɩ̀à, sə Yɩɩ pa bɩcan sìə́, á bɩcan sìə́ sʋgʋ tə wá yà də kʋ tíú. Kʋ nə tà kʋ mʋ̀, sə á kwɩ̀n á bɩcan sìə́ sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sàń tə tɩ̀án nə sɛ̀e aba, á yana kʋ sàń tə wa, á də́, á ga nyʋ kʋ tə, ba nə pɩn aba lá, tʋ̀tʋ̀nʋ̀ nə mɛ, sə ʋ də́ ʋ ŋwɩ́rán tə yɩrɩ. Á dànà ká twá dii wa á va! ");
INSERT INTO nnw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Á nə zʋa tɩʋ wa, ba ga sɛ̀e aba, sə á də́ kʋ tə, ba nə pɩn aba. ");
INSERT INTO nnw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Á zwɩ̀á kʋ tɩʋ tə tɩ̀án yayɩŋa yayɩran, á ga swɩ̀n ba con də, máŋá bwələ, sə Yɩɩ də́ ʋ pàrɩ̀ tə lɩ̀à mama yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yá máŋá tə, á nə zʋa tɩʋ wa, ba ga wà aba sɛ̀e, á naŋa coŋi yuu, á ga swɩ̀n: ");
INSERT INTO nnw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Nə pi purən tə nə marʋ nə nɛɛ nə, á tɩʋ tə wa, nə kəni á yuu wa. Yá á nə mɛ, sə á lwarɩ zəni də, máŋá boli, sə Yɩɩ də́ ʋ pàrɩ̀ tə á yuu wa›. ");
INSERT INTO nnw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","À mʋ̀ nə swɩ̀n kʋ á con nə də, bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə, Sodɔmə tɩʋ càn tə bá yí kʋ mʋ̀ tɩʋ təntə». ");
INSERT INTO nnw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Yomɩlan tə tə nə fwa á pwərə wa, yiri yà nə fwa Tirə də Sidon tɩan tə wa, tə tɩan təntə lɩ̀à yà wá zʋ pucʋnɩ ganan, ba ga pɩ̀rɩ̀ ba yɩra də tʋ̀nʋ̀. Kʋ nətʋ bɩrɩ də, ba vəvəri ba kwa, ba ma sá ba cʋna. Kʋ mʋ̀ nə pɩn, càn wá tʋ á mʋ̀ Korazɩn tɩ̀án yuu wa! Kʋ mʋ̀ nə pɩn, càn wá tʋ á mʋ̀ Bɛtəsayɩda tɩ̀án yuu wa! ");
INSERT INTO nnw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mə kʋ mʋ̀ nə pɩn, bʋ̀rà bʋ̀rʋ̀ dɩɩn nə, Tirə lɩ̀à də Sidon tɩ̀án càn tə ba yí á mʋ̀ tɩ̀án bələ təntə lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sə á mʋ̀ Kapɛrənayimə tɩ̀án, á bʋŋa də, á yuu wá dwen yɩɩ nə, naaa? Abada! Á wá cú á yí tɩga bwálɩ́». ");
INSERT INTO nnw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ʋ kʋ́ʋ̀ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Lìù tə, ʋ nə cʋgʋ á sʋgʋ, kʋ tíú cʋgʋ à sʋgʋ. Lìù tə, ʋ nə vɩga aba, kʋ tíú vɩga à də. Yá lìù tə, ʋ nə vɩga nə, kʋ tíú vɩga lìù tə, ʋ nə tʋn nə». ");
INSERT INTO nnw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ba karbɩa sapwɩtwa də fugə də bələ tə, Zwezi nə tʋn tə, pìí ba bà də ba súə́ də pupwən, ba ga swɩ̀n, ba wʋ́: «*Yuu-Tiu, ba *zinə də tətə sɛ̀e nə nii, də nə nə twá n yɩrɩ tə nə, nə ma pɩn tə nii». ");
INSERT INTO nnw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Zwezi ma le ba, ʋ wʋ́: «À nɩ *Sɩtana ʋ tʋa tɩa, ndə dwà pɩpɩlʋ nə. ");
INSERT INTO nnw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Á cʋga: À pɩn aba nii, sə á va dɩŋa də nɩŋa yun wa, sə á ga tɩtaga dʋŋʋ tə də ba dɩ̀àn tə mama. Yá won tə̀lə́, kʋ nə wá fwa aba yoo. ");
INSERT INTO nnw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Á yana pupwən wa, á yɩra nə pʋ́pʋ́nɩ́ sagɩ tə wa Yɩɩ *sàń nə yɩrɩ. Á nə dànà ká pa, á pwìí poli, zinə nə sɛ̀e á nii yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kʋ máŋá təntə wa, Yɩɩ-*Siŋu tə pɩn Zwezi sú də pupwən, ʋ ga swɩ̀n, ʋ wʋ́: «À nyɩna tə, n nə tɩ lanworu də tɩa. À kəni n lɛ̀eɛ̀e. N bɩrɩ yìə̀n tətə lɩ̀à tə nə, ba nə mun ba tɩ̀àn. Yá n ga sə̀gə̀ tə ba tə nə bʋŋa də, ba yɩ wʋbʋŋa də yənu tɩ̀án yáá nə. À nyɩna, n mʋ̀ cɩ́gá nə swə, sə nətʋ tə tʋn. ");
INSERT INTO nnw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","À nyɩna Yɩɩ ken wiən tə mama à jɩɩn wa. Lìù mama yə̀rì Yɩɩ-Biu tə, də kʋ nə tà à nyɩna Yɩɩ tə. Lìù də mama ma yə̀rì à nyɩna Yɩɩ tə, də kʋ nə tà Yɩɩ-Biu tə, də lìù tə, Yɩɩ-Biu tə nə swə, sə ʋ súrí ʋ yɩ́á ʋ bɩrɩ wá». ");
INSERT INTO nnw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kʋ kwa nə, Zwezi pìí ʋ vəvəri ʋ yáá, ʋ kə ʋ karbɩa tə con, ʋ ma ga swɩ̀n ba cɩcɩ con nə, ʋ wʋ́: «Á mʋ̀ dàń yɩ pupwən lɩ̀à, kʋ tə á nə na yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","À mʋ̀ nə swɩ̀n kʋ á con nə də, Yɩɩ nii *sʋ̀sʋ̀nà, ba nə dáá, də pɛ̀egá sóní, sə ba na kʋ tə, á nə na, yá ba ga wà kʋ nɩ. Ba sóní, sə ba nì kʋ tə, á nə nə̀ń. Yá ba ga wà kʋ nì». ");
INSERT INTO nnw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yɩɩ nii *yənu tíú don dàń ma zàn, ʋ bwe Zwezi yoo don, sə ʋ ma ja ʋ də̀ń nə, ʋ wʋ́: «Karnyɩna, bɛ̀eɛ̀e nə à mɛ, sə à fwa, sə à ma na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con?» ");
INSERT INTO nnw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Bɛ̀eɛ̀e nə Yɩɩ swɩ̀n ʋ *nii tə wa, ʋ nə pɩn *Moyizə? N nə̀ń kʋ nətə, də n nə kàrɩ̀ kʋ?» ");
INSERT INTO nnw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ʋ ma le, ʋ wʋ́: «N mɛ, sə n sóní *Yuu-Tiu, ʋ nə yɩ n Yɩɩ, də n waa mama. N sóní kʋ tə nə ziən, kʋ pa Yɩɩ nə. N bʋ́n Yɩɩ yoo máŋá mama. N kə n kajaŋa tə mama n pɩn Yɩɩ nə. Yá n tə mɛ, sə n sóní n yɩra lìù ndə n nə swə n tətə nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Zwezi dàń ma swɩ̀n ʋ con, ʋ wʋ́: «N le zəni! N nə fwa nətʋ, n wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yá Yɩɩ nii yənu tíú tə yà tə pɩ̀à, sə ʋ pa cɩ́gá ʋ tɩ̀àn nə. Ʋ dàń ma bwe Zwezi, ʋ wʋ́: «Wàà nə yɩ à yɩra lìù?» ");
INSERT INTO nnw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zwezi ma le də zwansɩsara, ʋ wʋ́: «Bɛɛ don nan *Zwerizalɛmə, ʋ cwí Zweriko. Máŋá tə wa, ʋ nə wulə cwəŋə tə wa, ʋ vəli, də nə̀ń, ŋwɩ̀nà, ba nə gwɩ lɩ̀à nə, ba fan, ba tʋ ʋ yuu wa, ba vɩra wá, ba lɩ ʋ ganan, ba mà wá, ba ga kɛ̀eń ba yá wá, ʋ bɛlʋ ʋ tə́gə́. ");
INSERT INTO nnw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kʋ zàn kʋ tʋ kʋ mɛ, də *Zwifə-ba Yɩɩ *joŋwanʋ don də twá cwəŋə təntə ʋ cwí Zweriko. Máŋá tə wa, ʋ nə nɩ bɛɛ tə, ʋ lwə ʋ twá cwəŋə tə vàn nə ʋ lɛ ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","*Levitə dwíí tə wa lìù don də kʋ́ʋ̀ twí, ʋ bà ʋ yí kʋ bwálɩ́ tə. Ʋ nə nɩ bɛɛ tə ʋ zwɛ̀e, ʋ lwə ʋ twá cwəŋə tə vàn don, ʋ kɛ̀eń ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yá Samari tə wa lìù don, ʋ də nə vələ ʋ cwəŋə, də twá bwálɩ́ təntə ʋ lɛ. Ʋ də ma va ʋ yí bɛɛ tə, ba nə mà tə yɩra. Máŋá tə wa, ʋ nə nɩ wá ʋ yinəgə jɩn wá zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ʋ kwɛn ʋ fàrʋ́ ʋ yí lá, ʋ lwá divɛn də nʋga ʋ nʋran tə yuu wa. Ʋ vwa tə də gantwan. Kʋ kwa nə, ʋ tì wá, ʋ kə ʋ tətə wodɩʋ yuu wa. Ʋ ja vu, ʋ tún vərə yipaa bwálɩ́ nə. Ʋ ywàń ʋ yuu nə. ");
INSERT INTO nnw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kʋ tɩpʋrʋ nə, ʋ lɩ cɩnɩa səbikʋlan bələ, ʋ pa yipaa bwálɩ́ tə tíú nə, ʋ ga swɩ̀n, ʋ wʋ́: ‹Ywàń, bɛɛ wà tə yuu nə. À nə pìí à bà máŋá tə wa, à wá ŋwɩ́n mʋ́ kʋ tə, n nə cʋ̀gʋ̀ ʋ yɩra à kwa nə›.» ");
INSERT INTO nnw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Zwezi ma swɩ̀n, ʋ wʋ́: «N mʋ̀ waa con, sə ba batwa tə wa lá, wàà nə ya bɛɛ tə, ʋ nə tʋa ŋʋ̀nà tə tətəŋi wa, yɩra lìù?» ");
INSERT INTO nnw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yɩɩ nii yənu tíú tə ma le, ʋ wʋ́: «Kʋ yɩ lìù tə, ʋ nə dəri bɛɛ tə yinəgə zənzən». Zwezi dàń ma swɩ̀n ʋ con nə, ʋ wʋ́: «Mə n də vəli n tʋn nətʋ!» ");
INSERT INTO nnw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Máŋá tə, Zwezi də ʋ karbɩa tə nə pìí ba zʋ cwəŋə, ba vəli ʋ zʋ tɩʋ don wa. Kan, ʋ yɩrɩ nə Marətə ma ja ba zəni ʋ sàń nə. ");
INSERT INTO nnw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kan tə yà ja nyánʋ́, ba ma boŋə Mari. Mari mʋ̀ yà jə̀ə́ Zwezi nɛɛ nə, ʋ cʋga kʋ tə, ʋ nə kàrɩ̀ ba. ");
INSERT INTO nnw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yá Marətə mʋ̀ yà wulə ʋ tʋŋa zənzən. Ʋ ma nan, ʋ ga swɩ̀n, ʋ wʋ́: «*Yuu-Tiu, kʋ ba mʋ́ yoo fwa də, à nyánʋ́ tə nə yá à cɩcɩ ʋ pa à tʋŋa tʋtʋnan tə mama? Swɩ̀n ʋ con, sə ʋ zàn ʋ san nə». ");
INSERT INTO nnw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yuu-Tiu ma le wá, ʋ wʋ́: «Marətə, Marətə, twara ja mʋ́, n ga wʋwalɩ n tɩ̀àn. N wulə yɩɩ nə, n kəkəri wiən nə dáá yɩra. ");
INSERT INTO nnw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yá won nədʋ nə jə də̀ń. Mari mʋ̀ kúrí kʋ tə, kʋ nə ziən, kʋ nə wàrɩ̀ kʋ joŋə ʋ con». ");
INSERT INTO nnw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dɩɩn don nə, Zwezi jʋn Yɩɩ bwálɩ́ don nə. Máŋá tə wa, ʋ nə jʋn ʋ zwɛ̀e, ʋ karbiu tə don bwe wá, ʋ wʋ́: «*Yuu-Tiu, bɩrɩ nəba nə nə wá jʋn Yɩɩ nətʋ, ndə *Zwan nə bɩrɩ kʋ ʋ karbɩa tə nə nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Zwezi ma le ba, ʋ wʋ́: «Máŋá tə nə, á nə jʋ̀nɩ̀ Yɩɩ, sə á swɩ̀n ndə: ‹Nə Nyɩna Yɩɩ! N yɩrɩ mɛ də dun! Bàá, n də́ n pàrɩ̀ tə tɩa yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pa nəba nə nii wodiu tə, kʋ nə mɛ nəba, dɩɩn mama. ");
INSERT INTO nnw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kwɛn nə cʋna n lɩ nə mʋ̀ də n mʋ̀ pwərə wa, ndə nə də nə kwɛn lwanɩ tə, lɩ̀à nə tʋn nə yɩra, nə lɩ nə mʋ̀ də ba pwərə wa. N dàn ká pa yoo yí nəba, kʋ nə wá yigu nəba, kʋ kə yokʋkwɩʋn wa›.» ");
INSERT INTO nnw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Zwezi kʋ́ʋ̀ swɩ̀n ba con nə, ʋ wʋ́: «Də á wa lìù nə ja ʋ dabɛɛ, ʋ ma zàn ʋ va ʋ con tɩtɩn kwɩʋn nə, ʋ swɩ̀n ʋ con, ʋ wʋ́: ‹À dabɛɛ don nan cwəŋə ʋ bà, ʋ dɩ̀ à yuu, à ga ba won ja à pɩn wá. Kʋ mʋ̀ nə yɩrɩ nə, à dabɛɛ, jɩŋa nə dipɛn batwa!› ");
INSERT INTO nnw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Də ʋ də nə zɩgɩ ʋ dìə̀ tə wa, ʋ le, ʋ wʋ́: ‹Yá nə sənbwen! Mimii taŋʋ kʋ zwɛ̀e, à də à bɩa tə́gə́ nə zwɛ̀e. À kʋ́ʋ̀ wàrɩ̀ à zaŋa à pɩn mʋ́ dipɛn.› ");
INSERT INTO nnw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kʋ nətʋ tə! À mʋ̀ nə swɩ̀n kʋ á con nə də, ʋ wá zàn ʋ pa tə wá. Kʋ nə tà ʋ nə yɩ ʋ dabɛɛ tə cɩcɩ yɩrɩ. Kʋ yɩ ʋ nə ba vìí, ʋ tə nə wá zɩŋɩ lá, ʋ mà mimii tə nə yɩrɩ. Mə kʋ mʋ̀ yɩrɩ ʋ wá zàn, ʋ pa wá kʋ tə mama, ʋ nə pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","À mʋ̀ ga nə swɩ̀n á con, à wʋ́: Á lorə, yá ba wá pa aba! Á pɩ̀à, á ga wá na! Á mà mimii nə, yá ba wá súrí ba pa á zʋ. ");
INSERT INTO nnw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lìù mama nə lòrì, ba wá pa wá. Lìù mama nə pɩ̀à, ʋ wá na. Yá ba ga ba wá súrí ba pa lìù tə nə, ʋ nə mà mimii nə. ");
INSERT INTO nnw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Də á wa lìù nə ya nyɩna, ʋ nə wà sɛ̀e, ʋ pa dən ʋ bìú tə nə, də ʋ bìú nə lòrì wá fəli, naaa? ");
INSERT INTO nnw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nə à yə̀ə́, ʋ wá pa wá nə̀n, də ʋ nə lòrì wá cacalɩ? ");
INSERT INTO nnw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Á mʋ̀ ləzwənwʋlʋnyɩna-ba, á nə yə̀ə́ ka pa wozəŋə á bɩa nə. Kʋ dàń wá yà nətə, kʋ pa á nyɩna Yɩɩ tə nə, ʋ nə wulə Yɩɩ *sàń nə, də á nə lòrì wá won. Ʋ mʋ̀ dàń wá pa aba ʋ *Siŋu tə». ");
INSERT INTO nnw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Dɩɩn don nə, Zwezi wulə ʋ lɩ *zini bɛɛ don yuu wa, kʋ nə pɩn bɛɛ tə nii ba swɩ̀n. Máŋá tə, zinə tə nə nan, bəru tə zàn, ʋ wulə ʋ swɩ̀n. Kʋ dàń gwárɩ́ lalʋʋ tə zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ba wa lɩ̀à swɩ̀n, ba wʋ́: «Kʋ ya Beləzebilə, zinə tə mama pɩ̀ʋ́ tə, nə pɩn wá dɩ̀àn, ʋ ma lɩ zinə lɩ̀à yuu wa». ");
INSERT INTO nnw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ba duən yà pɩ̀à ba ja ʋ də̀ń nə. Ba ma wʋ́, ʋ fwa yomɩlʋ ʋ bɩrɩ ba, sə ba ma yəni də, ʋ dɩ̀àn tə naŋa Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Zwezi yə̀ə́ ba pubʋŋɩ tə, ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Payuu lɩ̀à nə zɩgɩ duən nə, kʋ payuu tə wá cʋ̀gʋ̀, kʋ dii wá tʋ duən yuu nə. ");
INSERT INTO nnw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Də *Sɩtana nə pwɛ̀e ʋ zɩga ʋ tətə nə, ʋ payuu tə bá wànɩ́ kʋ yà lá. Á wʋ́ Beləzebilə nə pɩn nə dɩ̀àn, à ma lɩ zinə tə. ");
INSERT INTO nnw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kʋ nə yɩ Beləzebilə nə pɩn nə dɩ̀àn tə, kʋ mʋ̀ nə pɩn, à wàá zinə à lɩ lɩ̀à yuu wa. Sə á bɩa tə də yɩ wàà dɩ̀àn nə, ba ma lɩ zinə tə? Mə kʋ mʋ̀ nə pɩn, á bɩa tə tətə nə wá bʋ̀rɩ̀ á bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Cɩ́gá, kʋ yɩ də Yɩɩ dɩ̀àn nə, à ma lɩ zini tə, kʋ nətʋ tə bɩrɩ də, Yɩɩ də́ ʋ pàrɩ̀ lɩ̀à yuu wa á tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ladɩa nə cɩ̀ ʋ sàń nə də ʋ kwatara wiən, ʋ jɩjə wiən tə́gə́ tə bwálɩ́ nə, fən ga tə̀lə́. ");
INSERT INTO nnw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kʋ wàá kʋ yí də lìù don, ʋ də nə kʋ́ʋ̀ yɩ ladɩa, ʋ doni twi. Kʋ tíú wá ja dìə̀ tə tíú də dɩ̀àn, ʋ jon ʋ kwatara wiən tə, ʋ yà nə jə tə dɩ̀àn. Yá ʋ dàń wá wànɩ́ ʋ pɛ̀e ʋ wiən tə ʋ tàrɩ̀. ");
INSERT INTO nnw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Lìù tə, ʋ nə tə̀lə́ à kwa, zɩga à nə. Yá lìù tə, ʋ nə ba nə saŋa, ʋ keni duən nə, kʋ tíú yɩ ʋ làgà». ");
INSERT INTO nnw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Máŋá tə wa, *zini nə nan kʋ yá lìù, kʋ yàá jijiri kasɔɔ lanworu wa, kʋ ma pɩ̀à bwálɩ́, sə kʋ kə kʋ yuu lá. Kʋ nə wà yizwɩa bwálɩ́ nɩ, kʋ yàá swɩ̀n, kʋ wʋ́: ‹À wá pìí, à va à dìə̀ tə wa, à nə nan, à yá.› ");
INSERT INTO nnw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kʋ pìí kʋ bɩ̀àn, də dìə̀ tə zwarɩ, kʋ kwɛn zəni zəni kʋ tún lá. ");
INSERT INTO nnw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kʋ dàń wá va, kʋ ja zinə barpɛ duən, tə waa nə lɩŋa tə doni kʋ, kʋ súrí kʋ tɩ̀àn nə, kʋ ja bà kʋ tíú tə nə. Tə dàń wá zʋ tə jə̀ə́, yá ʋ mʋ̀ lìù təntə dí yáá wá kʋkwanɩ ʋ sɩ́ʋ́n». ");
INSERT INTO nnw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zwezi swɩ̀n nətʋ, ʋ va ʋ zwɛ̀e, máŋá tə wa, kan don swɩ̀n ʋ con lɩ̀à tə tətəŋi wa, ʋ wʋ́: «Pupwən wulə kan tə nə, ʋ nə lʋrɩ mʋ́, n nə ŋwà ʋ yɩlɩ!» ");
INSERT INTO nnw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yá Zwezi dàń le, ʋ wʋ́: «Pupwən wa ba tə nə, ba nə cʋga Yɩɩ sʋgʋ tə, ba ga sɛ̀e kʋ nii!» ");
INSERT INTO nnw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lalʋʋ tə nə púə́ Zwezi yuu nə, máŋá tə wa, ʋ zàn ʋ swɩ̀n, ʋ wʋ́: «Á mʋ̀ zə̀n lɩ̀à ba tə á nə yɩ lakʋkwɩnan, á lòrì Yɩɩ dɩ̀àn mɩmɩnʋ. Yá á bá na mɩmɩnʋ nədʋ də tətə, də kʋ nə tà mɩmɩnʋ tə, Yɩɩ nə twá də ʋ nii *sʋ̀sʋ̀nʋ̀ Zwʋnasə ʋ bɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kʋ tə Zwʋnasə nə fwa, kʋ yɩ mɩmɩnʋ kʋ pa lɩ̀à nə, ba nə wulə Ninivə tə wa. Mə nətʋ nə *Ləzwənə-Biu tə də wá yà mɩmɩnʋ, ʋ pa zə̀n lɩ̀à tə nə. ");
INSERT INTO nnw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bʋ̀rɩ̀ tə bʋ̀rʋ̀ dɩɩn nə, Etiyopi pakan tə wá zàn ʋ zɩgɩ zə̀n lɩ̀à ba tə nə. Ʋ wá bʋ̀rɩ̀ á bʋ̀rà, sə ba cʋ̀gʋ̀ aba, ʋ mʋ̀ nə nan bwálɩ́ kʋ nə ŋʋ́ná ʋ bà, sə ʋ cʋgʋ pɩ̀ʋ́ *Salʋmʋn yənu sʋ̀ràn tə yɩrɩ. Yá lìù ga wulə yəbə, ʋ nə dwə Salʋmʋn! ");
INSERT INTO nnw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bʋ̀rà tə bʋ̀rʋ̀ dɩɩn nə, Ninivə tɩ̀án wá zàn ba zɩgɩ zə̀n lɩ̀à ba tə nə. Ba wá bʋ̀rɩ̀ á bʋ̀rà, sə ba cʋ̀gʋ̀ aba, ba mʋ̀ nə sɛ̀e ba vəvəri ba kwa, ba ma sá ba cʋna, Zwʋnasə nə swɩ̀n Yɩɩ sʋgʋ tə ba con nə yɩrɩ. Yá lìù ga wulə yəbə, ʋ nə dwə Zwʋnasə!» ");
INSERT INTO nnw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Ləzwənə bá sɛ̀e ʋ sʋrʋ cànʋ́ ʋ tì ʋ sə̀gə̀, nə à yə̀ə́ ʋ tì ʋ pú garwa də̀ń. Də kʋ nə tà, sə ʋ tì ʋ tún canzɩlʋ yuu, sə ba tə, ba nə zwɩ, sə ba na poni. ");
INSERT INTO nnw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ləzwənə yɩ́á tə ya ndə n yɩra tə cànʋ́ nə. Də n yɩ́á tə nə zurə, n yɩra tə mama yàá pɩ̀rɩ̀ də poni. Yá də n yɩ́á tə nə ba ziən, n yɩra tə mama ya yikunu wa. ");
INSERT INTO nnw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","N dàń nə zùrì n yɩra, sə poni tə nə wulə n yɩra tə dàn ká jì yikunu. ");
INSERT INTO nnw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Də n yɩra tə mama nə wulə poni wa, n bwálɩ́ ga wà gɛ, kʋ nə wulə yikunu wa kʋ mama pɩan wá yà poni wa, ndə cànʋ́ nə pɩ̀rɩ̀ mʋ́ də kʋ poni mɛ pɩan». ");
INSERT INTO nnw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Zwezi nə swɩ̀n ʋ zwɛ̀e, máŋá tə nə, *Farɩzɩan don bon wá, sə ʋ də́ ʋ bwálɩ́ nə. Zwezi ma zʋ ʋ jə̀ə́, sə ʋ də́. ");
INSERT INTO nnw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kʋ gwárɩ́ Farɩzɩan tə də, ʋ nə nɩ Zwezi, ʋ də́ ʋ ga wà ʋ jɩ̀àn sɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","*Yuu-Tiu dàń ma swɩ̀n ʋ con, ʋ wʋ́: «Nə̀ń, á nə ya nətʋ á mʋ̀ Farɩzɩan-ba tə. Á yàá sɩn wùrú zʋŋa tə də zʋŋa tə kwa, yá á waa con súə́ də ŋwɩ̀ràn pubʋŋɩ də wʋlʋŋʋ. ");
INSERT INTO nnw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Á mʋ̀ ləyigi-ba! Yɩɩ tə, ʋ nə fwa kwa tə, ʋ mʋ̀ nə fwa waa tə də. ");
INSERT INTO nnw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Á pɩan zʋra nə mʋ̀, kʋ tə nə wulə á wùrú zʋŋɩ wa də á zʋŋɩ wa. Kʋ máŋá təntə wa, á bɩcanɩ yɩ nəpon Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Càn wulə də aba, á mʋ̀ Farɩzɩan-ba! Á pɩn wiən tə, á nə nɩ fugə nii nyiən, də davʋran yiri tətə mama fugə nii nyiən. Yá á ga ba cɩ́gá də sonu nə keni ndə Yɩɩ nə pɩ̀à nətʋ. Kʋ ga ya mə kʋ mʋ̀ nə á mɛ, sə á fwa, á yà wà mɛ, sə á dʋgʋ kʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Càn wulə də aba Farɩzɩan-ba! Á swə, sə á jə̀ń yáá gwələ yuu *Zwifə-ba *jə́rə́ dìə̀ wa, á ga swə, sə ba jʋn aba, ba zìlí ba jə́rə́ bwálá wa. ");
INSERT INTO nnw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Càn wulə də aba! Á ya ndə ləbərə nə, ba nə ba na, ba nə yə̀rì ba ga vəli tə yuu». ");
INSERT INTO nnw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yɩɩ nii *yənu tíú tə don ma swɩ̀n ʋ con, ʋ wʋ́: «Karnyɩna, n nə swɩ̀n nətʋ, kʋ ya nə də nə n twɩn!» ");
INSERT INTO nnw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Zwezi ma le, ʋ wʋ́: «Càn wulə á də Yɩɩ nii yənu tɩ̀án tə yuu wa, á nə zɩŋa lɩ̀à də zɩla, tə nə wàrɩ̀ tə zɩŋa, yá á tətə ba tə yɩra janɩ də á jɩfʋa nədʋ tətə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Càn wulə də aba, á nə wulə á lwè ləbərə nəzəŋə, á pɩn Yɩɩ nii *sʋ̀sʋ̀nà tə nə. Ba mʋ̀ Yɩɩ nii sʋ̀sʋ̀nà təntə yɩ á nɩbara ba nə gʋa! ");
INSERT INTO nnw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Á twá nətʋ á ma bɩrɩ də, á də swə kʋ tə, á nɩbara-ba tə nə fwa tə, də pupwən. Ba gʋa Yɩɩ nii sʋ̀sʋ̀nà tə, yá á də wulə á lwè ba ləbərə. ");
INSERT INTO nnw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mə kʋ mʋ̀ nə pɩn, Yɩɩ ma twá ʋ wʋbʋŋa tə nə, ʋ ma swɩ̀n, ʋ wʋ́: ‹À wá tʋn Yɩɩ nii sʋ̀sʋ̀nà də Yɩɩ *tʋntʋna ba nə. Ba wá gʋ ba wa lɩ̀à duən, ba ga wá wʋwalɩ ba duən də.› ");
INSERT INTO nnw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kʋ mʋ̀ tə yɩrɩ nə, ba wá bʋ̀rɩ̀ zə̀n lɩ̀à bʋ̀rà Yɩɩ nii sʋ̀sʋ̀nà tə mɛ gʋrɩ tə də̀ń nə ba nə gʋa, də jɩjʋ mama. ");
INSERT INTO nnw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kʋ nə zɩgɩ Abɛlə gʋrɩ nə, kʋ ja va Zakari gʋrɩ tə nə, ba nə gʋa Yɩɩ dəyaa tə də *joŋi kurə tə pwərə wa. Cɩ́gá, à mʋ̀ nə swɩ̀n kʋ á con nə: Ba wá bʋ̀rɩ̀ zə̀n lɩ̀à bʋ̀rà tə mʋ̀ lagʋrɩ təntə mɛ yɩrɩ! ");
INSERT INTO nnw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Càn wulə də aba, Yɩɩ nii yənu tɩ̀án tə. Á lɩ borbiu tə, kʋ nə wàá kʋ pɩn cwəŋə aba, sə á ma súrí yənu mimii. Á tətə ba zwɩ, á ga kʋ cɩ̀gà lɩ̀à tə nə, ba nə pɩ̀à, sə ba zʋ». ");
INSERT INTO nnw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Máŋá tə nə, Zwezi nə vìí kʋ bwálɩ́ tə nə, Yɩɩ nii yənu tɩ̀án tə də Farɩzɩan-ba tə lɩŋa yɩn tə zàn Zwezi yuu wa. Ba dàń zàn, ba bwe wá bwiə mama yoyirə yirə yuu wa, ");
INSERT INTO nnw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","sə ba ma kə cɩ́gá, ba twá ʋ nii sʋ̀ràn nə, ba ma ja wá. ");
INSERT INTO nnw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lɩ̀à tə twi, kʋ máŋá təntə wa, ba tʋ duən nə mʋ̀rʋ̀ də mʋran, ba ga ba vəli duən nɛɛ yun wa. Zwezi ma dí yáá, ʋ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á cɩa á tɩ̀àn nə də *Farɩzɩan-ba níə́ bələ tə nə, kʋ nə yɩ ndə sabwarɩ nə, kʋ nə yàá ŋʋ̀nɩ̀. ");
INSERT INTO nnw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kʋ tə mama, kʋ nə sə̀gə̀, wá nan poni nə. Yá kʋ tə mama, kʋ nə yɩ dìə̀ yoo, wá nan kàrá. ");
INSERT INTO nnw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mə kʋ mʋ̀ nə pɩn, kʋ tə mɛ, á nə wá swɩ̀n yikunu wa, wá zəzəgi yɩcaʋ wa. Yá kʋ tə á nə wá sʋsʋnɩ lìù zɩɩn nə dìə̀ wa, kʋ nə sùń, wá cə̀rí dəyun wa». ");
INSERT INTO nnw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ̀: «À swɩ̀n kʋ á con, à dabara-ba: Á dànà ká dəri lɩ̀à tə, ba nə gwɩ yɩra, yá ba ga wàrɩ̀ won don kʋ kwa nə, ba fwa ba súrí lá. ");
INSERT INTO nnw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","À wá bɩrɩ aba lìù tə, á nə mɛ, sə á dəri. Á dərə lìù tə, ʋ nə wàá aba, ʋ dɩlɩ mən dìə̀ wa, də ʋ nə gwa aba kwa nə. Cɩ́gá, à swɩ̀n kʋ á con, mə ʋ mʋ̀ nə á mɛ, sə á dəri! ");
INSERT INTO nnw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ba ba zənbii bonu yoli səbilurən bələ, naaa? Yá Yɩɩ ga ba ka nədʋ nə swɛ̀eé. ");
INSERT INTO nnw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yá Yɩɩ gàlɩ̀ á yukʋran tə mama á yuu wa. Á dànà ká pa fən ja aba. Á kʋkwa zənbii tə nə dáá!» ");
INSERT INTO nnw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À mʋ̀ nə swɩ̀n kʋ á con nə: Də lìù nə swɩ̀n lɩ̀à yáá con nə, də ʋ yə̀ə́ à mʋ̀ Zwezi, *Ləzwənə-Biu tə də wá bɩrɩ Yɩɩ *malɩkɛ tə yáá con də, ʋ yɩ ʋ mʋ̀ cɩ́gá nə tɩ wá. ");
INSERT INTO nnw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yá lìù tə, ʋ nə wá bɩrɩ də, ʋ yə̀rì nə, lɩ̀à yáá con, Ləzwənə-Biu tə də wá bɩrɩ Yɩɩ malɩkɛ tə yáá con, də ʋ yə̀rì wá. ");
INSERT INTO nnw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Lìù tə mɛ, ʋ nə wá swɩ̀n sʋgʋ, ʋ zɩgɩ Ləzwənə-Biu tə nə kʋ tíú wàá ʋ cʋna kwɩʋn ʋ nɩ. Yá lìù tə, ʋ nə wá twɩn Yɩɩ-*Siŋu tə, kʋ tíú wàrɩ̀ ʋ cʋna kwɩʋn ʋ nɩ, abada. ");
INSERT INTO nnw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ba wá ja aba ba va *Zwifə-ba *jə́rə́ dii wa, nə à yə̀ə́ tɩʋ tɩ̀án yáá con nə, sə ba bʋ̀rɩ̀ á bʋ̀rà. Kʋ máŋá tə wa, á dànà ká pa kʋ tə, á nə wá fwa, sə á ma jon á tɩ̀àn, nə à yə̀ə́ kʋ tə, á nə wá swɩ̀n, yoo ja aba. ");
INSERT INTO nnw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yɩɩ-Siŋu tə wá kàrɩ̀ aba, kʋ máŋá təntə wa, kʋ tə á nə mɛ, sə á swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Lalʋʋ tə wa, lìù don wulə ʋ swɩ̀n Zwezi con, ʋ wʋ́: «Karnyɩna, swɩ̀n à nubiu con, sə ʋ tàrà də nə, wiən tə nə nyɩna nə yá də nəba». ");
INSERT INTO nnw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Zwezi le wá, ʋ wʋ́: «À dabɛɛ, wàà nə tún nə, sə à bʋ̀rɩ̀ á wiən bʋ̀rà, nə à yə̀ə́, sə à tàrà á wiən?» ");
INSERT INTO nnw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ʋ ma pìí ʋ swɩ̀n ba mɛ con nə, ʋ wʋ́: «Á zurə á yɩra, á cɩa á tɩ̀àn nə zəni də lɩ̀à duən wiən ka ja yimən tə pa aba. Ləzwənə mɩɩ cɩ́gá tà kʋ wulə ʋ wojan wa, də ʋ nə swə ʋ yá jɩjə tíú nəfarʋ də». ");
INSERT INTO nnw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ʋ dàń ma sɩsarɩ zwansɩsara kʋ tə ba con, ʋ wʋ́: «Bɛɛ don kárɩ́ wodirən bɩga zəni. ");
INSERT INTO nnw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ʋ dàń ma dʋ̀ ʋ ga swɩ̀n ʋ tɩ̀àn con, ʋ wʋ́: ‹À wá fwa nətə? À ba bwálɩ́ jə, à keni à wodirən tə mɛ lá›. ");
INSERT INTO nnw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ʋ ma ga ʋ swɩ̀n ʋ tɩ̀àn con, ʋ wʋ́: ‹Nə̀ń, kʋ tə à nə wá fwa: À wá mà à təkələ tə, à pìí à lwà nəfaran, à pɛ̀e à mɩbɩa tə mama, də à wiən tə duən à kə tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kʋ kwa nə, à dàń wá swɩ̀n à tɩ̀àn con, à wʋ́: Bìú, n jə wiən zənzən, n də́ kʋ nə ja vələ bɩna də bɩna, n dàń wá piən, n sìí n nyʋ, n də́ cànà!› ");
INSERT INTO nnw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yá Yɩɩ swɩ̀n ʋ con, ʋ wʋ́: ‹Bɛɛ ləyəru! Tɩtɩn kʋ tə tətə nə, n mɩɩ wá zwɛ̀e! Yá wiən tə mama nə kwɛn n tún n tɩ̀àn nə wá jì lìù don nyiən!› » ");
INSERT INTO nnw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zwezi ma súrí lá, ʋ wʋ́: «Mə kʋ wá yà nətʋ kʋ pa lìù tə nə, ʋ nə pɛ̀e wiən tə, tə kwənə nə dáá, ʋ pɩn ʋ tɩ̀àn nə, yá ʋ ga ba won ja Yɩɩ yáá con nə». ");
INSERT INTO nnw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kʋ kwa nə, Zwezi swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Nə̀ń, won tə nə pɩn à swɩ̀n á con nə, à wʋ́: Á dànà ká pa á mɩɩ twara ja aba, də kʋ tə, á nə wá də́, nə à yə̀ə́ də kʋ tə, á nə wá zʋ á yɩra nə. ");
INSERT INTO nnw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Á mɩɩ tə jə funə, kʋ doni wodiu. Yá á yɩra tə də jə funə, kʋ doni gànʋ̀. ");
INSERT INTO nnw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Á ywàŋá batɩɛnkanan. Tə ba dwì, tə ma ba ce, tə ba pɛ̀e tə kəni təkələ wa. Yá Yɩɩ ga pɩn tə tə nii wodiu! Á kʋkwa zənbii tə mama zənzən! ");
INSERT INTO nnw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Á wa twara tə, ʋ nə jə, wàá ʋ mɩɩ tə kʋ təni mancɩn tətə? ");
INSERT INTO nnw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Də á nə wàrɩ̀ kʋ tə nə mun tətə á fwa, bɛ̀eɛ̀e dàń nə pɩn yoo don twara jə aba? ");
INSERT INTO nnw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Á ywàŋá á jə́n kárɩ́ gapunə nə naŋa nətʋ, tə ba tʋŋa tə ma ba gànʋ̀ də swɩ. À mʋ̀ nə swɩ̀n kʋ á con nə də, pɩ̀ʋ́ *Salʋmʋn tətə də ʋ jɩjə tə mama, ʋ wà gànʋ̀ zwɩ, kʋ nə ziən kʋ doni gapunə təntə nədʋ də. ");
INSERT INTO nnw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yá Yɩɩ dàń nə ywàŋá tə mʋ̀ kárɩ́ wa garan tətə yuu, tə nə yɩ tʋtʋ, də á mʋ̀, á nə jə funə zənzən á doni tə, ʋ wá ywàń á yuu nətə? Tə mʋ̀ garan wulə kárɩ́ wa zə̀n tə nə, wá kʋ̀, ba dɩ mən nə jwɩan nə, Yɩɩ dàń wá zʋ aba də ganan nətə! Á wà á waa ken à nə wuuu! ");
INSERT INTO nnw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Á dànà ká gʋ á tɩ̀àn á pɩ̀à máŋá mama kʋ tə, á nə wá də́, də kʋ tə, á nə wá nyʋ. ");
INSERT INTO nnw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kʋ ya lɩ̀à tə, lʋʋ nə tɩ ba, ba nə yə̀rì Yɩɩ tə, nə gwɩ ba tɩ̀àn ba pɩ̀à tə mʋ̀ təntə máŋá mama. Yá á mʋ̀ á ja nyɩna Yɩɩ, ʋ nə yə̀ə́ kʋ tə nə mɛ aba. ");
INSERT INTO nnw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Á təntən á kə á yáá lá, á pɩ̀à Yɩɩ pàrɩ̀ tə, yá kʋ kwa nə, Yɩɩ wá pa aba tə tə mama, tə nə mùrì aba». ");
INSERT INTO nnw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Dàn ká pa fən ja mʋ́, pulibiə, kʋ nə ywán də á nyɩna tə yɩrɩ, sə ʋ pa á twá á də́ ʋ pàrɩ̀ tə. ");
INSERT INTO nnw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Á yəgə á wiən, á ga pa tə səbiu tə, á nə nɩ, zʋra nə! Á tíə́ səbɩa lwaran tə, tə nə ba cʋ̀gà. Á pɩ̀à Yɩɩ *sàń wozəŋə tə mʋ̀ wiən tə, tə nə wàrɩ̀ tə jén, abada. Tə wiən təntə ŋʋ̀nà nə wàrɩ̀ tə ba yí, zʋnzʋran də ga wàrɩ̀ tə cʋ̀gà. ");
INSERT INTO nnw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bwálɩ́ tə nə, á wiən tə, tə kwənə nə dáá, nə wulə lá, mə lá nə á waa tə də wulə». ");
INSERT INTO nnw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á vwiə á tàŋá də voru, sə á sʋrʋ á canan, á ja! ");
INSERT INTO nnw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Á yana ndə lɩ̀à tə nə, ba nə dànɩ̀ ba yuu tíú, ʋ naŋa fúrú vwiu cànà ʋ pìí ʋ bɩ̀àn, ʋ nə mà, sə ba súrú ba pa, ʋ zʋ. ");
INSERT INTO nnw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pupwən wá yà də tʋ̀tʋ̀nʋ̀ tə yuu tíú nə wá bà, ʋ na də, ba nəŋə! Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Ʋ wá vwa ʋ tàŋá ʋ pa, ba jə̀ń wodiu yuu wa. Yá ʋ ga twá ba ladʋa ladʋa nii nə, ʋ pa ba, ba də́. ");
INSERT INTO nnw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ʋ nə twi tɩtɩn kwɩʋn nə, nə à yə̀ə́ tɩbɩnakʋnʋ wa, yá ʋ ga na də, ba nəŋə, ba wá yà pupwən wa! ");
INSERT INTO nnw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","À wá tì, à ma man kʋ tə: Də dìə̀ tíú yà nə yə̀ə́ máŋá tə, ŋwɩ̀àn yàá nə wá bà, ʋ yàá bá yá wá, ʋ pa ʋ zʋ dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Á kənə á sírí, á də nyiən nə. *Ləzwənə-Biu tə wá bà, máŋá tə nə, á nə ba bʋŋa». ");
INSERT INTO nnw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyɛrə dàń ma swɩ̀n, ʋ wʋ́: «*Yuu-Tiu, zwansɩsara tə yɩ nə cɩcɩ nyiən mʋ̀ naaa, kʋ yɩ lɩ̀à mama nyiən?» ");
INSERT INTO nnw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yuu-Tiu ma le, ʋ wʋ́: «Wàà dàń nə yɩ kʋ mʋ̀ tʋ̀tʋ̀nʋ̀ yuu tíú təntə, ʋ nə jə pùə́ nədʋ, ʋ ga jə wʋbʋŋa. Ʋ nə wá yà tʋ̀tʋ̀nà tə duən tə yuu wa, sə ʋ pa ba wodiu, máŋá tə nə, kʋ nə mɛ. ");
INSERT INTO nnw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kʋ tʋ̀tʋ̀nʋ̀ təntə wá yà pupwən wa, də yuu tíú tə ka pìí ka bà dìə̀ wa nə, ʋ nə yí wá də ʋ wulə kʋ tʋtʋŋɩ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","À mʋ̀ nə swɩ̀n kʋ á con, cɩ́gá mama: Yuu tíú tə wá pa wá, ʋ wiən tə mama yuu ywàŋʋ́. ");
INSERT INTO nnw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yá də kʋ mʋ̀ tʋ̀tʋ̀nʋ̀ təntə, nə swɩ̀n ʋ təntɩan con nə, ʋ wʋ́: ‹À yuu tíú tə dánɩ́, ʋ ba twi.› Ʋ dàń zàn ʋ tʋ ʋ tʋtʋnduən tə yuu wa, ʋ mà ba, ʋ ga zʋ diŋu də sanyʋra wa, sə ʋ bʋbʋnɩ. ");
INSERT INTO nnw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kʋ mʋ̀ tə wa nə, yuu tíú tə dàń wá bà dɩɩn don nə, ʋ dɩ̀ tʋ̀tʋ̀nʋ̀ tə yuu wa, máŋá tə wa, ʋ nə ba wá dànɩ̀. Ʋ dàń wá kə kʋ tʋ̀tʋ̀nʋ̀ təntə càn wa zənzən, kʋ ja vəli ʋ tɩan. Ʋ ga wá pa ba kə ʋ mʋ̀ də lɩ̀à tə, ba nə yə̀rì Yɩɩ bwálɩ́ nədʋ. ");
INSERT INTO nnw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tʋ̀tʋ̀nʋ̀ tə, ʋ nə yə̀ə́ kʋ tə, ʋ yuu tíú nə pɩ̀à, yá ʋ ga ba ʋ sírí keni, ʋ ga ba kʋ tə fwa ʋ yuu tíú nə pɩ̀à, ʋ wá na kafɩʋ yɩ́á zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kʋ ga nə ya tʋ̀tʋ̀nʋ̀ tə, ʋ nə yə̀rì kʋ tə, ʋ yuu tíú nə pɩ̀à nə tʋn, yìə̀n tə nə mɛ, sə ba mà wa tə yɩra ba wá mà kafɩʋ yɩ́á mancɩn. Lìù tə nə, ba nə pɩn zənzən, ba wá jon kʋ tíú con nə zənzən. Lìù tə con nə, ba nə tún zənzən, ba wá bwe kʋ tíú con nə, ba jon ba pàlɩ́ lá». ");
INSERT INTO nnw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À yɩ à twi, sə à kə mən tɩa yuu wa. Yá à swə zənzən, sə tə manwarɩ tə sʋrʋ! ");
INSERT INTO nnw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","À mɛ, sə ba kə nə càn wa, ndə ba nə ləgə lìù nɩ́á wa. Yá à wulə pucʋnɩ zənzən wa, kʋ ja vələ máŋá tə, kʋ nii nə wá sú! ");
INSERT INTO nnw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Á bʋŋa də à twi, sə à kə bɩcan sìə́ tɩa yuu wa, yá kʋ tà nətʋ. À mʋ̀ nə swɩ̀n kʋ á con də, kʋ yɩ pwɩa, à wá kə tɩa yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kʋ nə zɩgɩ sɩ́ʋ́n, lɩ̀à nə yɩ bonu dìə̀ wa ba wá pwɛ̀e, batwa zɩgɩ bələ nə, bələ zɩgɩ batwa nə. ");
INSERT INTO nnw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nyɩna wá zɩgɩ bìú nə, bìú wá zɩgɩ nyɩna nə. Nuu wá zɩgɩ bʋ̀á nə, bʋ̀á də ga wá zɩgɩ nuu nə. Barɩ nuu wá zɩgɩ ʋ bikɩnɩ nə, bikɩnɩ də wá zɩgɩ ʋ barɩ nuu nə». ");
INSERT INTO nnw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zwezi kʋ́ʋ̀ swɩ̀n lalʋʋ tə con nə, ʋ wʋ́: «Máŋá tə wa, á nə nɩ bakwan, də kʋ zaŋa yɩɩ yizwɩa con, də á swɩ̀n, lala, á wʋ́: ‹Dwà wá nà›. Yá mə kʋ mʋ̀ nə yàá tʋn. ");
INSERT INTO nnw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yá də á nə nɩ vʋʋ kʋ fuli, kʋ naŋa jɩzən vàn yuu, á yàá swɩ̀n, á wʋ́: ‹Tɩa tə wá cɛn›. Yá mə kʋ mʋ̀ nə yàá tʋn. ");
INSERT INTO nnw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Níə́ bələ tɩ̀án-ba! Á wàá lʋʋ yuu də lanworu mɩmɩnan tətə mʋ̀ də̀ń á lwarɩ. Kʋ dàń ya nətə, á ma wàrɩ̀ sɩ́ʋ́n máŋá tə mʋ̀ yáá á lwarɩ?» ");
INSERT INTO nnw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Zwezi kʋ́ʋ̀ swɩ̀n ʋ súrí lá, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á ba na á tɩ̀àn con nə, á tə mɛ, sə á tʋn nətʋ tə? ");
INSERT INTO nnw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Á nəŋə kʋ nyɩnyɩga: Kə cɩ́gá, sə n də n jarɩ don kə duən nə, də á tə nə wulə cwəŋə wa. Kʋ nə tà kʋ mʋ̀, kʋ wàá kʋ pɩn, ʋ kəni mʋ́ lìù tə nə bʋ̀rɩ̀ bʋ̀rà tə jɩɩn wa. Sə kʋ dàn ká yà talɩkwa kʋ pa mʋ́, də ba nə wá kə mʋ́ bàń dìə̀ nəcɩrʋ jɩɩn wa, sə ba dɩlɩ mʋ́ bàń dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kʋ ya cɩ́gá mama nə, à swɩ̀n n con: N bá nan ka bàń dìə̀ təntə wa, də n wà kʋ jɩŋɩ təntə talɩkwa tanya tə ŋwɩ́n». ");
INSERT INTO nnw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kʋ máŋá təntə wa, lɩ̀à duən twi, ba swɩ̀n Zwezi con Galile nagwanaa lɩ̀à tə yoo, *Pilatə nə pɩn ba gʋ. Máŋá tə wa, ba nə wulə ba gwɩ vàná ba ma fwa *jwəŋə, ba pɩn Yɩɩ nə, ba gʋa ba də. Ʋ guli ba jana də vàná tə jana duən wa. ");
INSERT INTO nnw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Zwezi ma le ba, ʋ wʋ́: «Á bʋŋa də, ba mʋ̀ Galile tɩ̀án təntə, ba nə gʋa nə, yà lɩ̀à, ba nə yɩ cʋna lɩ̀à, ba dwən Galile tɩ̀án tə duən tə, kʋ yoo təntə nə yí ba tə yɩrɩ, naaa? ");
INSERT INTO nnw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","À mʋ̀ nə swɩ̀n kʋ á con də, á nə wà vəvəri á kwa, á ma sá á cʋna, á də mama wá tɩ ndə ba nə. ");
INSERT INTO nnw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Silowe bə́rə́ naa tə ba nə lwə̀, ba ja dɩ̀ ban ban tə tʋa, kʋ mà lɩ̀à fugə nana kʋ gʋ. Á bʋŋa də, ba mʋ̀ nə cʋ̀gʋ̀, ba dwən *Zwerizalɛmə tɩ̀án tə duən tə, naaa? ");
INSERT INTO nnw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","À mʋ̀ nə swɩ̀n də aba, nətʋ dɩ̀án. Yá də á nə wà vəvəri á kwa, á ma sá á cʋna, á mama wá tɩ ndə ba nə». ");
INSERT INTO nnw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kʋ kwa nə, Zwezi ma swɩ̀n zwansɩsara kʋ tə ba con nə, ʋ wʋ́: «Bɛɛ yà jə kapɩrʋ, kʋ nə wulə ʋ kárá wa. Ʋ twi, sə ʋ kwa kapɩra, yá ʋ ga wà won mama nɩ. ");
INSERT INTO nnw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ʋ dàń ma swɩ̀n kárá tə vala tə con nə, ʋ wʋ́: ‹Nə̀ń, bɩna batwa nə à yàá bà, à pɩ̀à kapɩra kapɩrʋ tə yuu wa, à ga ba won mama na. Gwəŋə kʋ! Kʋ jon bwálɩ́ tə tʋtʋ›. ");
INSERT INTO nnw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yá kárá tə valʋ tə le wá, ʋ wʋ́: ‹Yuu tíú yá kʋ də̀də̀n kʋ tə, də à wá kʋ̀ kʋ də̀ń tə mama, à kɩkarɩ à kə bɩbana. ");
INSERT INTO nnw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nətʋ dɩɩn don, kʋ wá zɩn bɩa bɩnɩ don nə. Kʋ nə tà nətʋ, sə n dàń pa ba gwəŋə kʋ›.» ");
INSERT INTO nnw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","*Zwifə-ba *sìə́ dɩɩn nə, Zwezi wulə ʋ kàrɩ̀ ba *jə́rə́ dìə̀ don wa. ");
INSERT INTO nnw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kayayɩŋʋ don də yà wulə lá nə. Kʋ nə jə bɩna fugə də nana, *zini yà jɩn wá kʋ gori, kʋ pa ʋ yà kʋ́ʋ̀ wàrɩ̀ ʋ kwànɩ́ mɩ́ámɩ́án. ");
INSERT INTO nnw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Máŋá tə nə, Zwezi nə nɩ kan tə, ʋ bon wá, ʋ ga swɩ̀n, ʋ wʋ́: «N jon n tɩ̀àn n yayɩgʋ tə jɩɩn». ");
INSERT INTO nnw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ʋ tún ʋ jɩ̀àn ʋ yuu wa, yá lala ʋ kwɩ̀án, ʋ ga wulə ʋ bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yá jə́rə́ dìə̀ yuu tíú tə lɩŋa zàn, də Zwezi nə zwɛ̀e kʋ mʋ̀ kan təntə yayɩgʋ tə sìə́ dɩɩn nə. Ʋ dàń ma swɩ̀n lalʋʋ tə con, ʋ wʋ́: «Dɩan bardʋ wulə á nə mɛ, sə á tʋn, á bɩ̀àn tə mʋ̀ dɩan təntə nə, á pa ba zwɛ̀e á yayɩran tə, á ga yá sìə́ dɩɩn tə!» *Yuu-Tiu ma le wá, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","«Níə́ bələ tɩ̀án-ba! Sìə́ dɩɩn nə, á ba yàá kʋ̀rɩ̀ á naʋ, nə à yə̀ə́ á bɩ̀nà, á pa kʋ nyʋ nɩ́á. ");
INSERT INTO nnw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Sə kʋ mʋ̀ kan wà tə, ʋ nə yɩ *Abərahamə nàʋ́ *Sɩtana nə vwə, bɩna fugə də nana, kʋ yà mɛ, sə à kʋ̀rɩ̀ wá ʋ ŋwanɩ tə wa, sìə́ dɩɩn nə». ");
INSERT INTO nnw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Zwezi liu tə ken ʋ dʋŋa tə mama də cavɩra, yá lalʋʋ tə mɛ pùə́ poli Zwezi tʋtʋnzəŋə tə mɛ yuu wa, ʋ nə tʋŋa. ");
INSERT INTO nnw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zwezi ma swɩ̀n, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə də bɛ̀eɛ̀e nə nyɩn? Bɛ̀eɛ̀e nə à wàá kʋ à ma maŋa? ");
INSERT INTO nnw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kʋ yɩ ndə wobiu nəmanbiə nə. Bɛɛ don dàń tì kʋ, ʋ dù ʋ dəŋə vara wa. Kʋ ma pén kʋ fwa tɩ̀ʋ́, zənbii də ga bà, tə fwa tə pwalan kʋ nɛɛ wa». ");
INSERT INTO nnw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Bɛ̀eɛ̀e nə à wàá Yɩɩ pàrɩ̀ tə, à ma maŋa? ");
INSERT INTO nnw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kʋ yɩ ndə sabwarɩ nə, kan don nə tì mun zʋŋa yiə batwa, ʋ kə kʋ wa. Tə mama dàń ga zàn tə fʋlɩ». ");
INSERT INTO nnw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zwezi twá tɩan də tɩbii wa, ʋ kàrɩ̀ ʋ ga vələ *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lìù don ma bwe wá, ʋ wʋ́: «*Yuu-Tiu, lɩ̀à mancɩn nə wá jon ba tɩ̀àn, sə ba ja mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con?» Zwezi ma le ba, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Á kənə dɩ̀àn, sə á twá mimii pɩpɩan tə, á ma zʋ. À mʋ̀ nə swɩ̀n kʋ á con nə, lɩ̀à zənzən wá pɩ̀à, sə ba zʋ ba ga bá wànɩ́. ");
INSERT INTO nnw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Máŋá tə nə, dìə̀ tíú nə wá zàn, ʋ swaga ʋ mimii, á wá ga kàrá wa. Á wá mà mimii nə, á ga swɩ̀n, á wʋ́: ‹Yuu-Tiu, súrú n pa nə zʋ!› Ʋ wá le aba, ʋ wʋ́: ‹À yə̀rì bwálɩ́ tə, á nə nan!› ");
INSERT INTO nnw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Á dàń wá swɩ̀n ʋ con, á wʋ́: ‹Nə dí, nə ga nyʋ də mʋ́. N kàrɩ̀ nə tɩʋ coŋi wa›. ");
INSERT INTO nnw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ʋ tə kʋ́ʋ̀ wá swɩ̀n á con nə, ʋ wʋ́: ‹À yə̀rì bwálɩ́ tə, á nə nan. Á fàrá á nan kwa à bɩan nə, á mʋ̀ mama, á nə tʋn yokʋkwɩnan›. ");
INSERT INTO nnw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Á vələ bwálɩ́ tə nə, á nə wá bubwi, á ga dɩŋa á jɩfwɩ á fɩfaga, máŋá tə, á nə wá na á nɩbara *Abərahamə də *Yɩzakə də *Zwakɔbə də Yɩɩ nii *sʋ̀sʋ̀nà tə mama Yɩɩ pàrɩ̀ tə wa. Yá ba ga wá dɩlɩ á mʋ̀ bə́rə́ kwa! ");
INSERT INTO nnw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Lɩ̀à wá nan saparan banɩa tə mɛ, ba bà ba fwa diŋə Yɩɩ pàrɩ̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kʋ mʋ̀ nə pɩn, lɩ̀à tə duən, ba nə ya talɩkwa lɩ̀à sɩ́ʋ́n tə, dàń wá yà təntən lɩ̀à. Yá ba tə, ba nə ya təntən lɩ̀à sɩ́ʋ́n tə, wá yà talɩkwa lɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kʋ máŋá təntən wa, *Farɩzɩan-ba wa lɩ̀à duən twi, ba yí Zwezi yɩra, ba ga wʋ́: «Nan yəbə, n va bwálɩ́ don, *Erodə nə pɩ̀à, sə ʋ pa, ba gʋ mʋ́ yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Zwezi ma le ba, ʋ wʋ́: «Á vələ á swɩ̀n kʋ mʋ̀ bɛɛ təntə, ʋ nə ja yɩpʋrɩ ndə zwəŋə də, à lɩ *zinə, à ga zwɛ̀e yayɩran, zə̀n də jwɩan. Yá dɩan batwa nii nə, à wá zwɛ̀e à tʋtʋŋɩ. ");
INSERT INTO nnw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yá kʋ mɛ, sə à lɛ à va à cwəŋə tə zə̀n də jwɩan də kaan, kʋ nə wà mɛ, sə ba gʋ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ bwálɩ́ don nə, də kʋ nə tà *Zwerizalɛmə nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Zwerizalɛmə tɩ̀án-ba, Zwerizalɛmə tɩ̀án-ba, á mʋ̀ lɩ̀à tə, á nə gwɩ Yɩɩ nii *sʋ̀sʋ̀nà tə, á ga dɩlɩ ba tə, Yɩɩ nə tʋn á con, də kapana! Nɛɛ bagalɩ nə, à sóní, sə à kə aba à səpuni nə, ndə cə̀rú nə yàá kə kʋ cəbii kʋ vànà də̀ń nə, yá á ga wà kʋ sɛ̀e! ");
INSERT INTO nnw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Á nəŋə, Yɩɩ wá dʋgʋ ʋ *dìə̀ tə, ka nə wulə á con, mɩ́ámɩ́án. Yá də kʋ mama, à mʋ̀ nə swɩ̀n kʋ á con: Á kʋ́ʋ̀ bá na nə, kʋ ja vələ, á nə wá swɩ̀n, á wʋ́: ‹Yɩɩ wá fwa zəni lìù tə yɩra, ʋ nə bɩ̀àn *Yuu-Tiu yɩrɩ yuu wa!› » ");
INSERT INTO nnw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","*Zwifə-ba *sìə́ dɩɩn don nə, Zwezi vəli *Farɩzɩan-ba yuu tíú don sàń, sə ʋ də́ wodiu. Yá ba yɩ́á ga wulə ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bɛɛ don, yayɩgʋ nə yàá fʋlɩ wá, zɩga Zwezi yáá con nə. ");
INSERT INTO nnw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zwezi ma bwe Yɩɩ nii *yənu tɩ̀án tə də Farɩzɩan-ba, ʋ wʋ́: «Nə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, pɩn cwəŋə, nə à yə̀ə́ kʋ wà pɩn cwəŋə, sə ba zwɛ̀e yayɩgʋ nə sìə́ dɩɩn nə?» ");
INSERT INTO nnw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yá ba taŋɩ ba nii. Zwezi dàń ma jə wá ʋ zwɛ̀e ʋ yayɩgʋ tə, ʋ ga pa ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ʋ dàń swɩ̀n ba con nə, ʋ wʋ́: «Á lìù bìú, nə à yə̀ə́ ʋ naʋ nə, tʋa vəli wa sìə́ dɩɩn nə, kʋ tíú yàá lɩ kʋ lala. Nə à yə̀ə́, kʋ tà nətʋ?» ");
INSERT INTO nnw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba wà wànɩ́ wá ba le kʋ yoo tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Zwezi nɩ nətʋ lɩ̀à tə, ba nə twi diŋə tə nə, kúrí bwálá ba jəni. Ʋ dàń ma sɩsarɩ zwansɩsara kʋ tə, ʋ ma swɩ̀n ba mama tə con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Də lìù nə bon mʋ́ ʋ fúrú vwiu cànà wa, dàn ká va n jə̀ń ləzwənfaran yijaa nə. Ba wàá ləzwənfarʋ don ba boŋə, ʋ nə dwən mʋ́. ");
INSERT INTO nnw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yá dìə̀ tə tíú, ʋ nə bon á mɛ bələ tə, wàá ʋ twi, ʋ swɩ̀n n con, ʋ wʋ́: ‹Zàn n yá bwálɩ́ tə, n pa kʋ tíú nə›. Kʋ máŋá tə wa, kʋ wá yà kaŋʋ kʋ pa mʋ́, sə n zàn də cavɩra, n va n jə̀ń kwa con nə. ");
INSERT INTO nnw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kʋ mʋ̀ tə yɩrɩ nə, ba nə bon mʋ́ diŋə, sə n va jə̀ń kwa con, sə máŋá tə wa, lìù tə, ʋ nə bon mʋ́, nə wá bà, sə ʋ swɩ̀n n con nə, ʋ wʋ́: ‹À dabɛɛ, bàá, dɩ̀ yuu con bwálɩ́ nəzəŋu nə!› Kʋ mʋ̀ tə kwa nə, kʋ wá yà dun kʋ pa mʋ́ lɩ̀à tə mɛ yáá con, n də ba nə də́. ");
INSERT INTO nnw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lìù tə mama, ʋ nə wá zɩ̀n ʋ tɩ̀àn yɩɩ nə, ʋ wá cú. Yá lìù tə, ʋ nə wá mun ʋ tɩ̀àn, yuu wá kə yɩɩ nə». ");
INSERT INTO nnw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Zwezi dàń ga swɩ̀n lìù tə con, ʋ nə bon wá diŋə tə, ʋ wʋ́: «Máŋá tə, n nə bon diŋə, kʋ nə swə kʋ yɩ yɩcaʋ, nə à yə̀ə́ dədəni, dàn ká bon n dabara, nə à yə̀ə́ n nubɩa, nə à yə̀ə́ n dìə̀ lɩ̀à, nə à yə̀ə́ n səpuni jɩjə lɩ̀à. Də n nə bon ba, ba də wá wànɩ́ mʋ́ ba bon. Yá ba wá twá nətʋ, ba ma ŋwɩ́n mʋ́. ");
INSERT INTO nnw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yá n dàń nə fwa cànà wodiu, sə n bon zʋra, də ləzwənkɩkaran, də gwanan, də lilirən. ");
INSERT INTO nnw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","N pùə́ wá poli, ba nə bá wànɩ́ tə ba ŋwɩ́n yɩrɩ. Yɩɩ nə wá ŋwɩ́n mʋ́ máŋá tə wa, ba tə, ba nə yɩ cɩ́gá tɩ̀án tə nə wá bwin ba nan». ");
INSERT INTO nnw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tə yìə̀n təntə kwa nə, lìù tə, ba nə bon tə wa lìù don swɩ̀n Zwezi con, ʋ wʋ́: «Pupwən wulə də lìù tə, ʋ nə wá də́ wodirən cànà Yɩɩ pàrɩ̀ tə wa!» ");
INSERT INTO nnw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Zwezi sɩsarɩ zwansɩsara kʋ tə, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Bɛɛ don ken diŋə nəfarʋ, ʋ ga bon lɩ̀à zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wodiu tə diŋə máŋá wa, ʋ tʋn ʋ tʋ̀tʋ̀nʋ̀, sə ʋ swɩ̀n lɩ̀à tə con, ʋ nə bon tə, ʋ wʋ́: ‹Á bɩ̀àn sɩ́ʋ́n, wiən tə mɛ sírí ken›. ");
INSERT INTO nnw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yá ba ladʋa mama lwàń ʋ nii də, ʋ bá bà bɛɛ tə con nə. Təntən bɛɛ tə swɩ̀n tʋ̀tʋ̀nʋ̀ tə con, ʋ wʋ́: ‹À nɩ kárá yá kʋ mɛ, sə à va à na ka. À lòrì mʋ́, sə n yá nə, à ba wànɩ́›. ");
INSERT INTO nnw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ʋ don də swɩ̀n ʋ con, ʋ wʋ́: ‹À yə̀ nɩan fugə, à ga vələ, sə à də́də́n tə. À lòrì mʋ́, sə n yá nə, à ba wànɩ́›. ");
INSERT INTO nnw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ʋ don də kʋ́ʋ̀ ma swɩ̀n, ʋ wʋ́: ‹À dàń nə swe sɩ́ʋ́n. Kʋ mʋ̀ nə pɩn, à wàrɩ̀ lá à vəli›. ");
INSERT INTO nnw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tʋ̀tʋ̀nʋ̀ tə ma pìí ʋ va ʋ yuu tíú tə con, ʋ pa wá ba nə le nətʋ. Dìə̀ tíú tə lɩŋa zàn, ʋ ga swɩ̀n ʋ tʋ̀tʋ̀nʋ̀ tə con, ʋ wʋ́: ‹Vəli lala tɩʋ tə cwəŋə yuu, də kanporu wa, sə n ja zʋra də ləzwənkɩkaran, də lilirən, də gwanan, n ja bà›. ");
INSERT INTO nnw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kʋ nə kɛ̀eń mancɩn, tʋ̀tʋ̀nʋ̀ tə twi, ʋ swɩ̀n, ʋ wʋ́: ‹Yuu tíú, nə twá n nii tə nə, yá bwálɩ́ tə ga lá›. ");
INSERT INTO nnw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yuu tíú tə ma kʋ́ʋ̀ swɩ̀n ʋ tʋ̀tʋ̀nʋ̀ tə con, ʋ wʋ́: ‹Vəli gaʋ coŋi yuu dabwaran yɩra nə, sə n kálɩ́ lɩ̀à tə, sə ba zʋ, sə à dìə̀ tə sú. ");
INSERT INTO nnw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","À mʋ̀ nə swɩ̀n kʋ á con: Lɩ̀à tə, ba nə dí yáá, ba bon tə nədʋa də bá də́ à wodiu tə!› » ");
INSERT INTO nnw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lalʋʋ púə́ Zwezi kwa cwəŋə yuu. Ʋ ma pìí ʋ vəvəri, ʋ swɩ̀n ba con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Lìù tə, ʋ nə twi à con, kʋ tíú mɛ, sə ʋ lɩ ʋ nuu, də ʋ nyɩna, də ʋ kan, də ʋ bìsɩ́ná, də ʋ nubɩa, də ʋ nakwana, də ʋ tə təntɩan mɩɩ tə sonu yoo ʋ waa. Kʋ nə tà nətʋ, ʋ bá yà à karbiu. ");
INSERT INTO nnw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Lìù tə, ʋ nə pɩ̀à, sə ʋ ya à karbiu, kʋ tíú mɛ, sə ʋ sɛ̀e ʋ də́ càn də nə. Kʋ càn təntə yɩn də ʋ nə tɩga dagarʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Də á lìù nə pɩ̀à, sə ʋ lwà bə́rə́ naa, kʋ dɩ̀ ban ban, kʋ tíú mɛ, sə ʋ jə̀ń tɩa ʋ dí yáá, ʋ pɩ̀à dìə̀ tə səbiu nii, sə ʋ ga jə́n, də ʋ nə ja səbiu kʋ yí, sə ʋ ma lwà ka ʋ zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kʋ nə tà kʋ mʋ̀, ʋ nə dɩga ka də̀ń, ʋ ga wà zwɛ̀e. Ba dàń tə mɛ, ba nə wá na kʋ nətʋ, wá mʋn kʋ tíú, ");
INSERT INTO nnw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","də ba swɩ̀n, ba wʋ́: ‹Bɛɛ wà tə dɩga ʋ dìə̀ də̀ń, ʋ ga wà zwɛ̀e›.» ");
INSERT INTO nnw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Pɩ̀ʋ́ don nə pɩ̀à, sə ʋ va ʋ ta ʋ don pɩ̀ʋ́. Ʋ dàń dí yáá ʋ jə̀ń, ʋ bʋ́n ʋ jə́n, də ʋ nə wàá pamana mʋ̀rʋ̀ fugə, ʋ ma tɛ ʋ dʋŋʋ tə pamana mʋ̀rʋ̀ sapʋa. ");
INSERT INTO nnw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ʋ nɩ də, ʋ wàrɩ̀, ʋ wá tʋn lɩ̀à, sə ba pa kori pɩ̀ʋ́ tə don tə nə də, ʋ tə ba bwələ, sə sìə́ ya ba pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Kʋ nətʋ tə nə, á lìù mama wàrɩ̀ à karbiu ʋ yanɩ, də kʋ tíú nə wà vɩ ʋ wiən tə mɛ, ʋ nə jə». ");
INSERT INTO nnw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Nakwan ya won, kʋ nə ziən. Yá ka nyɩŋa nə nan, ba kʋ́ʋ̀ wàrɩ̀ ka ba pɩn ka pìí ka janɩ nyɩŋa. ");
INSERT INTO nnw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ka kʋ́ʋ̀ ba ziən, ka pa tɩa də nə, ka ma kʋ́ʋ̀ wàrɩ̀ kárá wa ka kəni, sə kárá tə wiən bɩ zəni. Ka dàń ya ba wá dʋgʋ kàrá wa. Lìù mama dàń mɛ, sə ʋ kə dɩ̀àn, ʋ súrí ʋ zɩan, ʋ cʋgʋ zəni!» ");
INSERT INTO nnw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lanpolɩna tə, də lɩ̀à tə duən tə, ba nə yɩ cʋna lɩ̀à, tə mama fàrʋ́ ba yí Zwezi yɩra, sə ba cʋgʋ ʋ sʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Farɩzɩan-ba də *Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə ŋʋŋwɩn, ba wʋ́: «Bɛɛ wà tə də cʋna lɩ̀à sɛ̀e ba wulə duən nə, ʋ ga də́ də ba». ");
INSERT INTO nnw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zwezi dàń ma sɩsarɩ zwansɩsara kʋ tə, ʋ ma sɩsarɩ ba, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Bɛ̀eɛ̀e nə á bʋŋa yoo kʋ tə yuu wa? Bɛɛ nə jə pee bíí, yá tə wa nədʋ ga jén. Ʋ wá yá tə sapwɩnɩa də fugə də nʋgʋ tə duən tə gaʋ tə wa. Ʋ dàń ga va ʋ pɩ̀à ka tə, ka nə jén tə, wuuu ʋ va ʋ na ka. ");
INSERT INTO nnw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ʋ dàń nə nɩ ka, ʋ pùə́ poli, ʋ tì ka ʋ kə ʋ para wa, ʋ ja va ʋ sàń nə. ");
INSERT INTO nnw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Máŋá tə wa, ʋ nə yí ʋ sàń nə, ʋ wá bon ʋ dabara də ʋ yɩra lɩ̀à, ʋ swɩ̀n, ʋ wʋ́: ‹Á fwa pupwən, ndə à mʋ̀ nə, à nə nɩ à piə tə, ka nə yà jén tə yɩrɩ›. ");
INSERT INTO nnw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mə nətʋ nə, à swɩ̀n á con nə, də pupwən wá yà Yɩɩ sàń nə, də cʋna lìù nədʋ nə nə vəvəri ʋ kwa, ʋ ma sá ʋ cʋna tə. Kʋ dwən lɩ̀à sapwɩnɩa də fugə də nʋgʋ, ba nə bʋŋa, də ba yɩ cɩ́gá tɩ̀án, ba nə ba bʋŋa də ba mɛ, sə ba vəvəri ba kwa, ba ma sá ba cʋna tə». ");
INSERT INTO nnw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Kan nə ja cɩnɩa səbikʋlan fugə, nədʋ ga jén yoo. Ʋ dàń sʋrʋ cànʋ́, ʋ zwarʋ dìə̀ tə, ʋ ga pɩ̀à kʋ zəni, ʋ na. ");
INSERT INTO nnw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ʋ nə twi, ʋ bà ʋ na kʋ, ʋ bon ʋ budonən, də ʋ yɩra lɩ̀à, ʋ ga swɩ̀n, ʋ wʋ́: ‹Á yana pupwən wa də nə, à nə nɩ à səbikʋlʋ tə, kʋ nə jén tə yɩrɩ!›. ");
INSERT INTO nnw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mə kʋ nətʋ tə nə, à swɩ̀n á con nə, də Yɩɩ *malɩkɛ yàá na pupwən zənzən Yɩɩ *sàń nə, də cʋna lìù nədʋ nə vəvəri ʋ kwa, ʋ ma sá ʋ cʋna». ");
INSERT INTO nnw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Bɛɛ don jə bɩa bələ. ");
INSERT INTO nnw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ba wa nəmaa tíú tə swɩ̀n ʋ nyɩna tə con, ʋ wʋ́: ‹À nyɩna, pa nə n jɩjə tori tə, à nə mɛ, sə à na›. Ʋ nyɩna tə ma tàrà ʋ jɩjə wiən tə ʋ pa ʋ bɩa bələ tə nə. ");
INSERT INTO nnw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kʋ nə fwa dɩan bələ, ba nəmaa tíú tə yə̀ ʋ tori tə, ʋ də́ ʋ ga nan, ʋ va lʋʋ, kʋ nə ŋʋ́ná. Kʋ mʋ̀ bwálɩ́ tə wa nə, ʋ cʋ̀gʋ̀ ʋ jɩjə tə mama mɩɩ kʋkwɩʋn tə wa, ʋ nə tì ʋ tɩ̀àn ʋ kə. ");
INSERT INTO nnw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Máŋá tə wa, ʋ nə cʋ̀gʋ̀ ʋ jɩjə tə mɛ ʋ zwɛ̀e, niən nəfarʋ twi, tə tʋ lʋʋ təntə wa, yá ʋ dàń kʋ́ʋ̀ ba won mama jə. ");
INSERT INTO nnw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ʋ dàń ma va, ʋ pɩ̀à tʋtʋŋɩ tɩʋ tə lìù don con. Kʋ tíú ma tì wá, ʋ pa ʋ va ʋ kárɩ́ wa, ʋ pa ʋ cɩ̀ ʋ twərən nə. ");
INSERT INTO nnw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ʋ yà swə, sə ʋ twá ʋ də́ twərən tə wodirən tə, yá lìù mama ga ba tə wá pɩn. ");
INSERT INTO nnw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ʋ dàń ma jə̀ń ʋ bʋ́n ʋ càn tə yuu wa, ʋ ga swɩ̀n ʋ tɩ̀àn con nə, ʋ wʋ́: ‹À nyɩna tʋ̀tʋ̀nà tə mama də́ wodirən ba gɛ, yá à ga tɩ də niən yəbə! ");
INSERT INTO nnw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","À wá pìí à va à nyɩna tə con, à ga wá swɩ̀n ʋ con, à wʋ́: À nyɩna, à cʋ̀gʋ̀ Yɩɩ nə, à ma cʋ̀gʋ̀ n də nə. ");
INSERT INTO nnw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","À kʋ́ʋ̀ wà mɛ, sə n ywàń nə ndə n bìú nə. N dàń tì nə, n ma fwa ndə n tʋ̀tʋ̀nʋ̀ tə don nə.› ");
INSERT INTO nnw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ʋ dàń ma tʋ cwəŋə wa, ʋ pìí ʋ bɩ̀àn ʋ nyɩna tə con. Də ʋ tə nə ŋʋ́ná də ba dìə̀, ʋ nyɩna nɩ wá, ʋ yinəgə ga tì wá. Ʋ dəri ʋ va ʋ jə́rí wá, ʋ pùrì wá ʋ kə ʋ nə, ʋ ga kʋkwalɩ wá. ");
INSERT INTO nnw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bìú tə dàń ma swɩ̀n ʋ con nə, ʋ wʋ́: ‹À nyɩna, à cʋ̀gʋ̀ Yɩɩ nə, à ma cʋ̀gʋ̀ n də nə. À kʋ́ʋ̀ wà mɛ, sə n ja nə n bon n bìú›. ");
INSERT INTO nnw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yá ʋ nyɩna tə swɩ̀n ʋ tʋ̀tʋ̀nà con, ʋ wʋ́: ‹Á jana gànʋ̀ tə kʋ zəni, nə dwən tə duən tə mama, á ja bà lala, á ma zʋ wá. Á kənə jɩfɩlɩ ʋ jɩfʋa nə də natʋra ʋ nɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Á jana napwala tə, nə nə kʋnɩ, kʋ tún nʋga tə, á ja bà á gʋ. Nə fwa pupwən diŋə. ");
INSERT INTO nnw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","À bìú tə, á nə na, yà tɩga, yá ʋ dàń pìí ʋ bwin ʋ nan tɩan wa, ʋ yà jén, yá à pìí à na wá›. Ba dàń ma wulə ba fwa pupwən diŋə. ");
INSERT INTO nnw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kʋ máŋá təntə wa, də kʋ bɛɛ tə bìú nəkwɩa tə wulə kárɩ́ wa. Máŋá tə, ʋ nə pìí, ʋ bà ʋ bwələ sàń, ʋ nì gwaran kori, ba ga sɛ. ");
INSERT INTO nnw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Máŋá tə, ʋ yí sàń, ʋ bon ʋ nyɩna tə tʋtʋnbiu tə don ʋ bwe, sə ʋ na kʋ tə nə fwa tə də̀ń. ");
INSERT INTO nnw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tʋtʋnbiu tə ma le wá, ʋ wʋ́: ‹N nyánʋ́ tə nə pìí ʋ bà. N nyɩna ma pa, ba gʋ napwala tə, nə nə kʋnɩ ka jɩgɩ tə, ʋ nə pìí ʋ na ʋ bìú tə də ʋ yɩra zurə yɩrɩ›. ");
INSERT INTO nnw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bìú nəkwɩa tə lɩŋa ma zàn, ʋ ga vɩ, sə ʋ zʋ dìə̀ tə wa. Ʋ nyɩna ma nan, sə ʋ ja wá, ʋ ja zʋ. ");
INSERT INTO nnw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yá bìú tə le ʋ nyɩna, ʋ wʋ́: ‹À nyɩna, cʋgʋ yəbə! Bɩna kapʋpʋ nə, à tʋŋa à pɩn mʋ́. Yá à ga wà n nii vɩ yoo nədʋ wa. Yá n ga wà nə bʋna tətə də pɩn, sə à ma fwa pupwən diŋə, sə à də à dabara də́. ");
INSERT INTO nnw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yá máŋá tə, n bìú wà tə nə pìí ʋ bà, ʋ mʋ̀ tə, ʋ nə dí n jɩjə tə mama ʋ zwɛ̀e də kacwara, mə ʋ mʋ̀ tə nə nə n pa, ba gʋ napwala tə, ka nə ja nʋga tə ba pa!› ");
INSERT INTO nnw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ʋ nyɩna tə ma swɩ̀n, ʋ wʋ́: ‹À bìú, n wulə máŋá mama də nə. Yá kʋ tə mama à nə ja yɩ n mʋ̀ nyiən. ");
INSERT INTO nnw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yá nə mɛ, sə nə fwa pupwən diŋə. N nyánʋ́ tə, n nə na tə, yà tɩga. Yá ʋ ma pìí ʋ bwin ʋ nan tɩan wa. Ʋ yà jén, yá à ga pìí à na wá!› » ");
INSERT INTO nnw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zwezi swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Jɩjə tíú don nə wulə ʋ yà jə lìù, ʋ nə ywàŋá ʋ tʋtʋnan yuu. Ba ma bà ba swɩ̀n ʋ con də, lìù tə, ʋ nə ywàŋá ʋ tʋtʋnan yuu, tə gɩgɩrɩ ʋ wiən tə. ");
INSERT INTO nnw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yuu tíú tə ma bon wá, ʋ ga swɩ̀n, ʋ wʋ́: ‹Bɛ̀eɛ̀e nə, à nə̀ń n yuu wa? Bɩrɩ nə, n nə tʋn n tʋtʋŋɩ tə nətʋ, n nə kʋ́ʋ̀ wàrɩ̀ à tʋtʋnan tə yuu n ywàŋá tə yɩrɩ›. ");
INSERT INTO nnw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bɛɛ tə ma swɩ̀n ʋ tɩ̀àn con, ʋ wʋ́: ‹À yuu tíú tə wá dɩŋɩ nə à tʋtʋŋɩ tə wa. À dàń wá fwa nətə? À ba dɩ̀àn jə, sə à ma vara à də́, cavɩra ga wá ja nə, sə à lòrì, à də́. ");
INSERT INTO nnw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","À yə̀ə́ kʋ tə, à nə wá fwa. Máŋá tə nə, à nə wá kwɩ̀n à bwálɩ́ tə nə, sə lɩ̀à wá ja nə, ba kə ba dìə̀ wa›. ");
INSERT INTO nnw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ʋ dàń ma pa, ʋ yuu tíú jɩjɩŋa tə mama bà nədʋ nədʋ. Ʋ ma swɩ̀n təntən tíú tə con, ʋ wʋ́: ‹Bagalɩ nə wulə n mʋ̀ də à yuu tíú tə pwərə wa?› ");
INSERT INTO nnw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ʋ ma le wá, ʋ wʋ́: ‹Nʋga barikiə bíí›. Bɛɛ tə ma swɩ̀n, ʋ wʋ́: ‹Nə̀ń n jɩŋɩ sagɩ tə nə, jə̀ń tɩa lala, n pʋ́pʋ́nɩ́ barikiə finu›. ");
INSERT INTO nnw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ʋ ma kʋ́ʋ̀ swɩ̀n ʋ don də con, ʋ wʋ́: ‹Sə n mʋ̀, bagalɩ nə wulə n yuu wa?› Ʋ də ma le, ʋ wʋ́: ‹Mɩna ganlwaran biənu›. Bɛɛ tə ma swɩ̀n ʋ con, ʋ wʋ́: ‹Nə̀ń, n jɩŋɩ sagɩ tə, pʋ́pʋ́nɩ́ biənɩa.› ");
INSERT INTO nnw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kʋ mʋ̀ lìù təntə, ʋ nə ywàŋá tʋtʋnan tə yuu, ʋ nə yɩ ʋ nə tʋŋa kʋnkʋn yìə̀n tə, yuu tíú tə bʋ̀à ʋ nə, ʋ nə fwa kʋ swɩan təntə yɩrɩ. Kʋ yɩ cɩ́gá, lɩ̀à tə, ba nə yɩ lʋʋ kʋ tə nə tɩ ba, yə̀ə́ swɩan ba doni lɩ̀à tə, ba nə ya poni lɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zwezi ma súrí lá, ʋ wʋ́: «Yá à mʋ̀ nə swɩ̀n á con, à wʋ́: Á jana lʋʋ jɩjə ka tə, á ma pɩ̀à dabara. Máŋá tə wa, á wiən tə nə twí tə zwɛ̀e, sə ba wànɩ́ ba sɛ̀e aba dii tə wa, tə nə bá cʋ̀gà. ");
INSERT INTO nnw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Lìù tə, ʋ nə yɩ pùə́ nədʋ tíú yobii wa, ʋ wá yà pùə́ nədʋ tíú yofaran tə də wa. Lìù tə, ʋ nə tʋŋa kʋnkʋn yìə̀n yobii wa, ʋ wá tʋn kʋnkʋn yìə̀n yofaran tə də wa. ");
INSERT INTO nnw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Də á nə wà pùə́ nədʋ tɩ̀án yɩn á kʋnkʋn yìə̀n tətə, ka ja tʋn waa nə, wàà nə wá pa aba cɩ́gá cɩ́gá wozəŋə tə, naaa? ");
INSERT INTO nnw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Də á nə wà pùə́ nədʋ tɩ̀án yɩn də lìù don jɩjə wiən, wàà nə wá pa aba jɩjə wiən tə, tə nə yɩ á təntɩan nyiən? ");
INSERT INTO nnw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tʋtʋnbiu tə̀lə́, ʋ nə wàá ʋ tʋŋa, ʋ pɩn yun tɩ̀án bələ nə. Ʋ nə fwa kʋ, ʋ wá sóní ʋ don, ʋ ga dʋ́n ʋ don. Ʋ wá sɛ̀e ʋ don nii, ʋ ga vɩ ʋ don nii. Á wàrɩ̀ á twá duən á tʋŋa á pɩn Yɩɩ, də tɩa yuu jɩjə nə». ");
INSERT INTO nnw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Farɩzɩan-ba tə, ba nə swə səbiu tə, cʋgʋ Zwezi sʋ̀ràn tə, ba ga zàn ba wulə ba mʋŋa wá. ");
INSERT INTO nnw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Á yɩ lɩ̀à tə, á nə bɩrɩ á tɩ̀àn də, á yɩ cɩ́gá tɩ̀án ləzoni yáá con, yá Yɩɩ yə̀ə́ á bɩcan tə waa tə. Kʋ tə kʋ nə jə funə ləzoni yáá con nə, ya wopʋ̀pʋ̀nʋ̀ Yɩɩ yáá con nə. ");
INSERT INTO nnw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kʋ jɩjʋ nə, kʋ yà yɩ Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə saga tə, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə yà nə tʋŋa. Kʋ twi kʋ zɩgɩ Zwan nə. Kʋ kwa nə, ba swɩ̀n sʋywáŋʋ́, ba wʋ́, Yɩɩ wá də́ ʋ pàrɩ̀ tə, yá lìù də mama ya ʋ kəni dɩ̀àn, sə Yɩɩ də́ pàrɩ̀ ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lanworu tə də tɩa wàá tə jén mwálɩ́ mwálɩ́, yá won ga wàrɩ̀ Yɩɩ nii tə mancɩn də kʋ cʋ̀gà. ");
INSERT INTO nnw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Lìù tə mama, ʋ nə dʋgʋ ʋ kan, ʋ ga swe ʋ don, ʋ fwa bacwan. Yá lìù tə, ʋ nə swe kan tə, ʋ barɩ nə dʋgʋ, ʋ də fwa bacwan». ");
INSERT INTO nnw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Zwezi ma sɩsarɩ, ʋ wʋ́: «Jɩjə tíú don nə yɩn lá, ʋ nə zwɩ gansɩan mwin, də gankɩkalan nəpon tə dɩɩn mama. Ʋ yà wulə ywánɩ́ wa, ʋ ga də́ kʋ tə, kʋ nə ziən. ");
INSERT INTO nnw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lalaŋʋ don də yɩn lá, ba nə boŋə Lazarə, ʋ yɩra nə súə́ də nʋran. Ʋ yà tə́gə́ jɩjə tíú tə dìə̀ mimii nə. ");
INSERT INTO nnw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ʋ yàá pɩ̀à, sə ʋ də́ womunə tə, tə nə naŋa wodiu tabɩlʋ tə yuu nə, tə twɩ. Kʋ nə dwən nətʋ, kukuri twi, tə dàlɩ̀ ʋ yɩra nʋran tə. ");
INSERT INTO nnw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Dɩɩn don nə, zʋrʋ tə twi ʋ tɩ, yá *malɩkɛ tì wá, tə ja va Yɩɩ *sàń, *Abərahamə səpuni nə. Jɩjə tíú tə də twi ʋ tɩ, ba ma gùrì wá. ");
INSERT INTO nnw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jɩjə tíú tə wulə, ʋ də́ càn zənzən tɩga bwálɩ́ tə nə. Ʋ zɩ̀n ʋ yáá ʋ kə yɩɩ, ʋ ga na Lazarə, ʋ jə̀ə́ yɩŋʋnɩ Abərahamə səpuni nə. ");
INSERT INTO nnw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ʋ dàń ma mà nii, ʋ wʋ́: ‹À nyɩna Abərahamə dəri à yinəgə, à nə də́ càn zənzən mən tətə wa yɩrɩ. Tʋn Lazarə, sə ʋ kə ʋ jɩfʋa nii nɩ́á wa, ʋ ma zùrì à nəndəli›. ");
INSERT INTO nnw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yá Abərahamə dàń swɩ̀n, ʋ wʋ́: ‹À bìú, lìí n tɩ̀àn də, n nɩ wiən zənzən n tɩa yuu yanʋ tə wa. Yá Lazarə mʋ̀ ya lìù tə, ʋ nə dí càn də càn ʋ mɩɩ tə wa. Sɩ́ʋ́n nə, ʋ bɩcan dàń zùrì, n mʋ̀ ga wulə càn wa. ");
INSERT INTO nnw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kʋ tə nə dwən tətə, woru nəfarʋ wulə nə də aba pwərə wa. Yá lɩ̀à tə, ba nə pɩ̀à, sə ba zɩgɩ á con, ba bà nə con kʋ wàrɩ̀. Nə də ga wàrɩ̀ á con nə vəli›. ");
INSERT INTO nnw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jɩjə tíú tə ma swɩ̀n, ʋ wʋ́: ‹À lòrì mʋ́, à nyɩna, sə n tʋn Lazarə à nyɩna dìə̀ wa nə. ");
INSERT INTO nnw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","À ja nubɩa bonu lá nə. Tʋn Lazarə, sə ʋ va ʋ swɩ̀n ba con, sə ba də dàn ká bà càn bwálɩ́ kʋ tə nə›. ");
INSERT INTO nnw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abərahamə ma le, ʋ wʋ́: ‹N nubɩa tə jə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə saga tə, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə. Ba mɛ, sə ba twá sʋgʋ tə nii nə, kʋ nə pʋ́pʋ́nɩ́ saga tə wa›. ");
INSERT INTO nnw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jɩjə tíú tə swɩ̀n, ʋ wʋ́: ‹Kʋ cɩcɩ wà yí, à nyɩna Abərahamə. Lìù dàń nə pìí ʋ nan tɩga con nə, ʋ va ʋ yí ba, ba wá vəvəri ba kwa, ba ma sá ba cʋna›. ");
INSERT INTO nnw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yá Abərahamə tə swɩ̀n ʋ con, ʋ wʋ́: ‹Də ba nə bá sɛ̀e Yɩɩ nii tə, ʋ nə pɩn Moyizə nə saga tə nii, də Yɩɩ nii sʋ̀sʋ̀nà saga tə nii, ba bá sɛ̀e lìù don də nii, də kʋ tíú nə swə, sə ʋ nan tɩga wa də›.» ");
INSERT INTO nnw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zwezi swɩ̀n ʋ karbɩa tə con nə, ʋ wʋ́: «Yìə̀n wá yà lá, tə nə wá pa lɩ̀à dʋgʋ Yɩɩ cwəŋə tə ka jén. Yá lɛɛ wulə də lìù tə, ʋ nə pɩn ləzoni fwa cʋna! ");
INSERT INTO nnw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kʋ wá kʋkwanɩ kʋ tíú con nə, də ba nə vwə kapan nəfarʋ ʋ bɩan nə, ba dɩ mʋʋ nɩ́á wa, də ʋ nə pa ba labwana tʋn cʋna. ");
INSERT INTO nnw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Á cɩa á tɩ̀àn nə zəni! Də lìù tə, ʋ yɩ n nubiu *Kərisə yɩrɩ, nə fwa cʋna, swɩ̀n ʋ con də n yaŋwɩan mama. Yá də ʋ nə vəvəri ʋ kwa, ʋ ma sá ʋ cʋna tə, sə n kwɛn tə n lɩ n də wá pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Də n nubiu nə cʋ̀gʋ̀ n nə, nɛɛ barpɛ də dɩɩn nədʋ wa, yá də kʋ nɛɛ təntə mama, ʋ yàá bà ʋ swɩ̀n n con də, ʋ pɩ̀à, sə ʋ vəvəri ʋ kwa, ʋ ma sá ʋ cʋna tə, sə n də kwɛn tə n lɩ ʋ pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","*Tʋntʋna tə swɩ̀n *Yuu-Tiu con, ba wʋ́: «Pa nə waa tə, nə nə kəni n nə súrí wuuu!» ");
INSERT INTO nnw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ʋ ma le, ʋ wʋ́: «Də á nə keni á waa Yɩɩ nə mancɩn tətə, yá kʋ ga yɩ ndə wobiu nəmanbiə nə, á wàá tɩ̀ʋ́ nəfarʋ con, á swɩ̀n: ‹Gʋ n zàn n va n cwɛn mʋʋ tə wa!› Yá kʋ wá sɛ̀e á nii». ");
INSERT INTO nnw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zwezi kʋ́ʋ̀ ma swɩ̀n, ʋ wʋ́: «Á wa lìù mama bá sɛ̀e, ʋ fwa yoo kʋ tə: Lìù nə jə tʋtʋnbiu, ʋ nə vəli kárá ʋ vàrɩ̀, nə à yə̀ə́ ʋ cɩ̀ vàná nə, də ʋ nə pìí ʋ bɩ̀àn, kʋ tíú tə bá swɩ̀n ʋ con də, ʋ bà lala, sə ʋ də́. ");
INSERT INTO nnw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ʋ wá swɩ̀n tʋtʋnbiu tə con nə, ʋ wʋ́: ‹Kwɛn wodiu, n kə duən nə, zʋ n tʋtʋnganan, n tì à wodiu, n tún n pa nə, à də́ à ga nywɩ̀n. Kʋ kwa nə, sə n də dàń də́, n ga nyʋ›. ");
INSERT INTO nnw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tʋtʋnbiu tə bá ja jʋ̀nà ʋ nə, ʋ nə tʋn kʋ tʋtʋŋɩ tə, ʋ pa wá tə yɩrɩ? ");
INSERT INTO nnw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mə kʋ yà nətʋ, kʋ pa á də nə: Máŋá tə nə, á nə wá fwa kʋ tə mama, ba nə yà bɩrɩ aba, á swɩ̀án, á wʋ́: ‹Nə ya tʋtʋnbɩa, kʋ ya nə tʋtʋŋɩ, nə nə tʋn mʋ̀ʋ́›.» ");
INSERT INTO nnw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Zwezi twá Samari də Galile nagwanɛɛ sʋswɩan tə wa, ʋ kɛ̀eń, ʋ ma vəli *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ʋ nə vəli ʋ zʋ tɩʋ don wa nə, ʋ nə zwɩ, də dayaran fugə nə tə bɩ̀àn, sə tə jə́rí wá. Ba twi, ba zɩga yɩŋʋna, ba ga bubwi, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Karnyɩna Zwezi, dəri nə yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Zwezi nɩ ba, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á vələ á bɩrɩ á tɩ̀àn *Zwifə-ba Yɩɩ *joŋwana tə nə!» Máŋá tə wa, ba nə pìí ba vələ lá nə, ba dayan tə zwɛ̀e, ba ga jì ləzwənzəŋə. ");
INSERT INTO nnw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ba wa lìù don nə nɩ də, ʋ yɩra tə zùrì, ʋ pìí ʋ nɛɛ tə nə, ʋ bɩ̀àn, ʋ ga zɩ̀n ʋ kori, ʋ kə yɩɩ nə, ʋ bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ʋ twi ʋ bà, ʋ tʋ Zwezi nɛɛ nə, ʋ ga kə ʋ lɛ̀eɛ̀e. Kʋ mʋ̀ bɛɛ təntə yà yɩ Samari tíú. ");
INSERT INTO nnw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Ba mama fugə tə nɩ yazurə. Kʋ tà cɩ́gá naaa? Sə ba nʋgʋ tə duən tə wa yə̀n? ");
INSERT INTO nnw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba lìù mama wà bʋ́n, sə ʋ pìí ʋ bà ʋ kə Yɩɩ lɛ̀eɛ̀e, kʋ nə tà də vee wà tə?» ");
INSERT INTO nnw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Zwezi dàń ma swɩ̀n ʋ con, ʋ wʋ́: «Zàn, n va! N nə keni n waa à mʋ̀ nə wuuu tə yɩrɩ, Yɩɩ jon mʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dɩɩn don nə, *Farɩzɩan-ba tə twi, ba bwe Zwezi, ba wʋ́: «Máŋá kwa nə, Yɩɩ wá zɩgɩ ʋ də́ pàrɩ̀ tə?» Ʋ ma le ba, ʋ wʋ́: «Yɩɩ pàrɩ̀ tə yɩ kʋ yàá bà kʋ pa, ba wànɩ́ ba na kʋ. ");
INSERT INTO nnw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ba bá swɩ̀n, ba wʋ́: ‹Á nəŋə, kʋ wulə yəbə!› Nə à yə̀ə́: ‹Kʋ wulə lá con!› Yɩɩ wulə ʋ də́ ʋ pàrɩ̀ tə á tətəŋi wa». ");
INSERT INTO nnw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ʋ dàń ma swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Máŋá don wá bà, á nə wá pɩ̀à, sə á na *Ləzwənə-Biu dɩan tə tə wa dɩɩn nədʋ cɩcɩ, yá á bá wànɩ́ kʋ á na. ");
INSERT INTO nnw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ba wá swɩ̀n á con, ba wʋ́: ‹Á ywàŋá yəbə!› Nə à yə̀ə́: ‹Á ywàŋá lá con!› Yá á dànà ká va lá, á dànà ká dəri á va lá nə. ");
INSERT INTO nnw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ndə dwà pɩpɩlʋ nə yàá pɩpɩlɩ lanworu tə wa, kʋ zɩgɩ kʋ də̀ń nə, kʋ pɩ̀rʋ̀ kʋ ja va kʋ yuu nə, mə nətʋ tə Ləzwənə-Biu tə wá yà ʋ dɩɩn tə nə, ʋ nə wá pìí ʋ bà. ");
INSERT INTO nnw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yá kʋ dàń mɛ, sə ʋ də́ càn zənzən, sə zə̀n lɩ̀à ga vɩ wá. ");
INSERT INTO nnw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Máŋá tə, Ləzwənə-Biu tə nə wá pìí ʋ bà, yìə̀n tə wá yà ndə tə nə yɩn nətʋ Nowe máŋá tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kʋ máŋá tə wa, lɩ̀à tə yà də́, ba nywɩ̀n, ba swe duən nə, də ba swe ba bwɩ̀ɩ́ lɩ̀à yuu wa, kʋ ja va dɩɩn tə, Nowe nə zʋa nɩ́á yuu bori nəfarʋ tə wa. Dwà nəfarʋ tə dàń twi, kʋ gʋ ba mama. ");
INSERT INTO nnw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kʋ wá yà ndə lɩ̀à tə, ba nə yɩ lá Lɔtə máŋá tə wa. Lɩ̀à tə yàá də́, ba nywɩ̀n, ba yə̀ ba ga yoli, ba dwì, ba ga lwè dii. ");
INSERT INTO nnw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yá máŋá tə, Lɔtə nə nan *Sodɔmə tɩʋ wa, mən də jirəbuu dwà twi tə nà, tə gʋ ba mama. ");
INSERT INTO nnw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mə kʋ wá yà nətʋ, máŋá tə, Ləzwənə-Biu tə nə wá bà. ");
INSERT INTO nnw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kʋ máŋá tə nə, lìù tə, ʋ nə wá yà dəyuu wa, kʋ́ʋ̀ wà mɛ, sə ʋ cú, ʋ zʋ dìə̀ wa, ʋ tì ʋ zɩla tə nə wulə lá. Mə kʋ wá yà nətʋ, kʋ pa lìù tə nə, ʋ nə wá yà kárá wa, ʋ kʋ́ʋ̀ wà mɛ, sə ʋ pìí ʋ bà sàń. ");
INSERT INTO nnw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Á lie á tɩ̀àn Lɔtə kan tə yoo! ");
INSERT INTO nnw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Lìù tə, ʋ nə wá pɩ̀à ʋ tɩ̀àn nə, sə ʋ jon ʋ mɩɩ tə, ʋ wá kwɩ̀n kʋ nə. Yá lìù tə, ʋ nə wá kwɩ̀n ʋ mɩɩ tə nə, wá na mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","À mʋ̀ nə swɩ̀n kʋ á con, à wʋ́: Kʋ tɩtɩn təntə nə, lɩ̀à bələ wá piən gədoo yuu. Yɩɩ wá tì ʋ don, ʋ ga yá ʋ don lá. ");
INSERT INTO nnw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kana bələ wá gà mun duən nə nʋŋʋ yuu wa. Yɩɩ wá tì ʋ don, ʋ ga yá ʋ don lá. ");
INSERT INTO nnw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bara bələ wá yà kárá wa, Yɩɩ wá tì ʋ don, ʋ ga yá ʋ don lá.» ");
INSERT INTO nnw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Karbɩa tə ma bwe wá, ba wʋ́: «*Yuu-Tiu yə̀n nə nə, kʋ mʋ̀ təntə wá fwa?» Ʋ ma le, ʋ wʋ́: «Bwálɩ́ tə nə, wotɩgʋ nə wulə, dilən də yàá kun duən nə lá». ");
INSERT INTO nnw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Zwezi kʋ́ʋ̀ sɩsarɩ zwansɩsara kʋ tə. Ʋ bɩrɩ ʋ karbɩa tə nə, sə ba ma lwarɩ də, ba jɩ̀àn mɛ, sə tə dàn máŋá mama yɩjʋnɩ wa. ");
INSERT INTO nnw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ʋ ma swɩ̀n, ʋ wʋ́: «Lìù don nə wulə, ʋ nə bʋ̀rɩ̀ bʋ̀rà tɩʋ don nə. Ʋ ba Yɩɩ zìlí, ʋ ga ba ləzwənə tì, ʋ ma fwa won tətə. ");
INSERT INTO nnw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kʋ mʋ̀ tɩʋ təntə wa, kadənu don də wulə lá nə, ʋ twi, máŋá mama, ʋ yí wá, sə ʋ bʋ̀rɩ̀ ʋ bʋ̀rà. Ʋ yàá swɩ̀n bɛɛ tə con nə, ʋ wʋ́: ‹Bʋ̀rɩ̀ à də à jarɩ don tə bʋ̀rà tə!› ");
INSERT INTO nnw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lìù nə bʋ̀rɩ̀ bʋ̀rà tə vɩga kʋ nɛɛ kapʋpʋ. Kʋ kwa nə, ʋ ma bà ʋ swɩ̀n ʋ tɩ̀àn con nə, ʋ wʋ́: ‹À cɩ́gá ba Yɩɩ zìlí, à ga ba ləzwənə tì, à ma fwa won tətə. ");
INSERT INTO nnw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yá kadənu wà tə nə wʋwalɩ nə tə yɩrɩ, à wá bʋ̀rɩ̀ ʋ bʋ̀rà tə. Kʋ nə tà kʋ mʋ̀, ʋ wá bà máŋá mama, ʋ ja à bɩan nə›.» ");
INSERT INTO nnw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kʋ kwa nə, *Yuu-Tiu tə ma swɩ̀n, ʋ wʋ́: «Á cʋga kʋ tə, lìù wʋlʋnyɩn tə nə bʋ̀rɩ̀ bʋ̀rà nə swɩ̀n! ");
INSERT INTO nnw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mə Yɩɩ wá twá nətʋ, ʋ ma pa cɩ́gá tə, á nə lòrì ʋ con tɩtɩn də yɩcaʋ. Ʋ bá dɩ́án, ʋ ma san ba. ");
INSERT INTO nnw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","À mʋ̀ nə swɩ̀n kʋ á con nə də, ʋ wá pa ba cɩ́gá tə, ba nə pɩ̀à tə lala. Yá máŋá tə, *Ləzwənə-Biu tə nə wá bà, ʋ wá na lɩ̀à, ba nə keni ba waa Yɩɩ nə lɩ̀à tə wa, ba nə wulə tɩa yuu naaa?» ");
INSERT INTO nnw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zwezi sɩsarɩ zwansɩsara kʋ tə, ʋ pa lɩ̀à tə nə, ba nə bʋŋa də, ba yɩ cɩ́gá tíú Yɩɩ yáá nə, ba ga ba ba duən tə jələ. ");
INSERT INTO nnw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ʋ swɩ̀n, ʋ wʋ́: «Bara bələ vələ *Zwifə-ba Yɩɩ *dìə̀ wa, sə ba jʋn Yɩɩ. Ʋ don yɩ *Farɩzɩan, ʋ don ma yɩ lanpolɩnʋ. ");
INSERT INTO nnw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farɩzɩan tə zɩga ʋ cɩcɩ, ʋ ga jʋ̀nɩ̀ Yɩɩ, ʋ wʋ́: ‹Yɩɩ, à keni n lɛ̀eɛ̀e, à nə tà ndə ləzoni tə duən nə, ba nə yɩ lɩ̀à tə, ba nə vɩrɩ lɩ̀à wiən də dɩ̀àn, də lɩ̀à, ba nə tʋŋa kʋnkʋn yoo, də lɩ̀à, ba ga cwàrɩ̀ tə yɩrɩ. À keni n lɛ̀eɛ̀e, à nə tà ndə lanpolɩnʋ ʋ tə nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","À vwe à nii nɛɛ bələ dɩan barpɛ wa. Yá à ga pɩn mʋ́ won mama, à nə nɩ fugə nii nyiən›. ");
INSERT INTO nnw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lanpolɩnʋ tə mʋ̀ ga zɩga dìə̀ tə vàn don nə. Ʋ wàrɩ̀ ʋ yáá tətə ʋ zɩ̀n, ʋ keni yɩɩ nə. Yá ʋ dàń yɩ ʋ wulə ʋ zɛ ʋ jɩ̀àn, ʋ ga swɩ̀n, ʋ wʋ́: ‹Yɩɩ dəri à yinəgə à yɩ cʋna lìù!› » ");
INSERT INTO nnw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Zwezi ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À mʋ̀ nə swɩ̀n kʋ á con də, kʋ mʋ̀ bɛɛ təntə nɩ cɩ́gá Yɩɩ yáá con, ʋ ja pìí ʋ va ʋ dìə̀. Yá kʋ nə tà Farɩzɩan tə mʋ̀. Lìù tə mama, ʋ nə wá zɩ̀n ʋ tɩ̀àn kʋ tíú wá cú. Yá lìù tə, kʋ tíú nə wá kə ʋ tɩ̀àn tɩa, Yɩɩ wá zɩ̀n kʋ tíú yɩɩ nə». ");
INSERT INTO nnw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lɩ̀à yà jɩn bìsɩ́ná ba bà Zwezi con, sə ʋ dwen ba yɩra. Zwezi karbɩa tə nə nɩ kʋ nətʋ, ba dàń wulə ba caga ba nii nə. ");
INSERT INTO nnw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yá Zwezi pɩn ba ja bìsɩ́ná tə, ba fàrʋ́ ba yí lá, ʋ ga swɩ̀n, ʋ wʋ́: «Á yágá bìsɩ́ná tə, sə ba bà à con nə! Á dànà ká cɩ̀ ba nə! Yɩɩ pàrɩ̀ tə nə yɩ ba tə, ba nə yɩ ndə ba nə nyiən. ");
INSERT INTO nnw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Də lìù nə bá sɛ̀e, ʋ jì ndə bisɩmaa, ʋ ba wànɩ́ Yɩɩ pàrɩ̀ tə wa ʋ zʋ». ");
INSERT INTO nnw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","*Zwifə-ba yuu tíú don lòrì Zwezi, ʋ wʋ́: «Karnyɩna n yɩ pubwanʋ tíú. Bɛ̀eɛ̀e nə à mɛ, sə à fwa, sə à ma na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con?» ");
INSERT INTO nnw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Zwezi ma le wá, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, n ma boŋə pubwanʋ tíú? Lìù tə̀lə́, ʋ nə yɩ pubwanʋ tíú, də kʋ nə tà Yɩɩ cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","N yə̀ə́ Yɩɩ *nii yìə̀n tə, ʋ nə pɩn *Moyizə: ‹Dàn ká cwàrɩ̀! Dàn ká gʋ! Dàn ká ŋʋ! Dàn ká kʋna kʋnkʋn, n kə lìù nii nə! Zìlí n nuu də n nyɩna nii!› » ");
INSERT INTO nnw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bɛɛ tə le, ʋ wʋ́: «À twá tə mʋ̀ Yii nii yìə̀n təntə mama nii nə, də à tə ya bisɩmaa». ");
INSERT INTO nnw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Zwezi nə nì kʋ mʋ̀ təntə nətʋ, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Won nədʋ tə nə ga, sə n fwa: Yə̀ tə tə mɛ, n nə jə, n ga tàrà səbiu tə n pa zʋra nə. Yá n wá na wiən tə, kwənə nə dáá, Yɩɩ *sàń nə. Kʋ kwa nə, n dàń bà, n twá à nə». ");
INSERT INTO nnw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yá máŋá tə wa, bɛɛ tə nə nì tə sʋ̀ràn təntə, ʋ pùə́ cʋ̀gʋ̀ mɩ́ámɩ́án, ʋ yà nə yɩ jɩjə nəfarʋ tíú yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Zwezi nə na də, ʋ pùə́ cʋ̀gʋ̀ tə, ʋ swɩ̀n, ʋ wʋ́: «Kʋ cà zəni, kʋ pa jɩjə tɩ̀án nə, sə ba zʋ Yɩɩ pàrɩ̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nyʋgʋma ka twá gancɩɩn bʋʋ kʋ nan, yɩ mwálɩ́, kʋ doni jɩjə tíú nə pɩ̀à, sə ʋ zʋ Yɩɩ pàrɩ̀ tə wa». ");
INSERT INTO nnw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lɩ̀à tə, ba nə cʋga Zwezi tə, swɩ̀n, ba wʋ́: «Kʋ nə yɩ nətʋ, wàà nə wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con?» ");
INSERT INTO nnw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Zwezi ma le, ʋ wʋ́: «Won tə, ləzoni nə wàrɩ̀ ba fwa, Yɩɩ mʋ̀ wàá kʋ ʋ fwa». ");
INSERT INTO nnw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyɛrə dàń ma swɩ̀n, ʋ wʋ́: «Ywàń, nə dʋgʋ nə wiən mɛ, nə ga twá n nə». ");
INSERT INTO nnw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù nə taa Yɩɩ pàrɩ̀ tə yɩrɩ, ʋ nan ʋ ga yá ʋ sàń, nə à yə̀ə́ ʋ kan, də ʋ nubɩa, də ʋ nuu, də ʋ nyɩna, də ʋ bɩa, ");
INSERT INTO nnw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kʋ tíú wá na ʋ doni kʋ tə, ʋ nə dʋgʋ tɩa yuu wa yəbə. Yá máŋá kʋ tə wa, də máŋá tə mɛ, kʋ nə bɩ̀àn, ʋ wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Zwezi jɩn ʋ karbɩa fugə bələ tə, ʋ kə ʋ con, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á cʋga zəni, nə wulə cwəŋə wa, nə vələ *Zwerizalɛmə, yá mə lá nə, Yɩɩ nii *sʋ̀sʋ̀nà tə níə́ sʋ̀ràn tə mama, ba nə swɩ̀n *Ləzwənə-Biu tə yuu wá, nii wá sú. ");
INSERT INTO nnw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ba wá ja wá, ba pa lɩ̀à tə nə, ba nə ba nə yə̀rì Yɩɩ. Ba wá mʋn wá, ba twɩn wá, ba pi mɩmɩan, ba kə ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ba wá mà wá, ʋ yɩra lá, ba ga gʋ wá. Yá dɩan batwa nii nə, Yɩɩ wá pìí ʋ bwin wá, ʋ lɩ tɩan wa». ");
INSERT INTO nnw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Karbɩa tə wà kʋ də̀ń nì mancɩn də. Tə sʋ̀ràn təntə də̀ń yà sə̀gə̀. Yá ba yà ga yə̀rì yoo tə, Zwezi nə swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dɩɩn don nə, Zwezi bwələ tɩʋ, ba nə boŋə ‹Zweriko›. Liliu don yà jə̀ə́ cwəŋə yuu, ʋ lòrì. ");
INSERT INTO nnw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ʋ nì də, lalʋʋ tə nə lɛ tə, ʋ ma bwe, ʋ wʋ́: «Bɛ̀eɛ̀e nə?» ");
INSERT INTO nnw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ba ma swɩ̀n ʋ con də, kʋ yɩ Zwezi, ʋ nə yɩ *Nazarɛtə tíú tə nə twá lá nə ʋ lɛ. ");
INSERT INTO nnw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ʋ dàń ma bubwi, ʋ kə ʋ nə, ʋ wʋ́: «Pɩ̀ʋ́ *Davidə nàʋ́, Zwezi, dəri à yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ba tə, ba nə wulə yáá nə, ba vəli tə caga ʋ nii nə, ba wʋ́, ʋ pú ʋ nii lá. Yá ʋ tə kwɛn ʋ bubwi zənzən, ʋ wʋ́: «Davidə nàʋ́ dəri à yinəgə!» ");
INSERT INTO nnw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Zwezi ma zɩgɩ, ʋ ga pa, ba ja wá ba bà ʋ con. Máŋá tə nə, ba nə jɩn wá, ba yí lá, Zwezi bwe wá, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Bɛ̀eɛ̀e nə n pɩ̀à, sə à fwa à pa mʋ́?» Ʋ ma le, ʋ wʋ́: «*Yuu-Tiu pa, sə à kʋ́ʋ̀ na». ");
INSERT INTO nnw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «N kəni n waa à mʋ̀ nə. Kʋ mʋ̀ yɩrɩ nə, sə n yɩ́á tə pìí tə na lá. Yɩɩ jon mʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Naa nədʋ, də ʋ na lá, ʋ ga twá Zwezi kwa, də ʋ bwɩ Yɩɩ nə. Lɩ̀à tə mama nɩ kʋ nətʋ. Yá ba dàń ga wulə ba bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zwezi yà twá Zweriko tɩʋ wa, ʋ lɛ. ");
INSERT INTO nnw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Bɛɛ don yà wulə lá, ba nə boŋə Zaswe. Ʋ yà yɩ lanpolɩnʋ yuu tíú, ʋ ga yɩ jɩjə tíú. ");
INSERT INTO nnw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ʋ yà pɩ̀à, sə ʋ na lìù tə, ʋ nə yɩ Zwezi. Yá ʋ nə yɩ ləzwənkukuə, tə pɩn ʋ wàrɩ̀ Zwezi ʋ nɩ, lalʋʋ tə yà nə púə́ ʋ yuu nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zaswe dàń ma dəri, ʋ va yáá cwəŋə tə yuu, Zwezi nə wá twá. Ʋ dɩ̀ tɩ̀ʋ́ yuu, sə ʋ ma wànɩ́ ʋ na Zwezi, ʋ nə wá lɛ. ");
INSERT INTO nnw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zwezi nə twi, ʋ yí kʋ bwálɩ́ təntə, ʋ zɩ̀n ʋ yáá yɩɩ nə, ʋ ga swɩ̀n Zaswe con, ʋ wʋ́: «Zaswe, cú tɩa lala! Kʋ mɛ, sə à zə̀n zʋrʋ n dìə̀ wa». ");
INSERT INTO nnw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaswe dàń pìí lala, ʋ cú tɩa, ʋ ga ja Zwezi ʋ zʋ ʋ dìə̀ də pupwən. ");
INSERT INTO nnw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lɩ̀à tə mama nə nɩ kʋ nətʋ, ba ŋʋŋwɩn, ba ga swɩ̀n, ba wʋ́: «Bɛɛ wà tə zàn ʋ va ʋ zʋrʋ cʋna lìù wà tə dìə̀ wa». ");
INSERT INTO nnw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaswe dàń ma fàrʋ́ ʋ yí *Yuu-Tiu yɩra, ʋ ga swɩ̀n, ʋ wʋ́: «Yuu-Tiu nə̀ń, à wá pa à jɩjə tə fan zʋra nə. À nə gɩgɩrɩ lìù, à jon ʋ won, à wá pìí à pa kʋ tíú tə, kʋ won tə nɛɛ banɩa». ");
INSERT INTO nnw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Zwezi ma swɩ̀n Zaswe con, ʋ wʋ́: «Zə̀n kʋ tə, Yɩɩ jon lɩ̀à tə, ba nə wulə dìə̀ təntə wa, ba cʋna wa. Zaswe də bɩrɩ də, ʋ yɩ *Abərahamə nàʋ́ cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","*Ləzwənə-Biu tə yɩ ʋ twi, sə ʋ pɩ̀à, ʋ ga jon lɩ̀à tə, ba nə jén ba cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ba nə wulə, ba cʋga tə yìə̀n təntə, Zwezi kʋ́ʋ̀ sɩsarɩ zwansɩsara, ʋ súrí lá. Ʋ bɩrʋ lɩ̀à tə, ba nə bʋŋa də, ʋ nə bwələ *Zwerizalɛmə, ʋ nə yí lá nə ʋ zwɛ̀e, Yɩɩ wá də́ ʋ pàrɩ̀ tə sɩ́ʋ́n sɩ́ʋ́n. ");
INSERT INTO nnw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ʋ dàń swɩ̀n, ʋ wʋ́: «Pabiu don nə vəli lʋʋ nii, kʋ nə ŋʋ́ná, sə ba pa wá pàrɩ̀, sə ʋ ga pìí ʋ bà. ");
INSERT INTO nnw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sə ʋ ga zɩgɩ lá nə, ʋ vìí ʋ pɩn, ʋ tʋ̀tʋ̀nà tə wa lɩ̀à fugə bà ʋ yáá nə. Ʋ tì sɩ́án səbikʋlʋ nədʋ nədʋ, ʋ pa ba, ʋ ga swɩ̀n ba con, ʋ wʋ́: ‹Á ywələ də səbiu kʋ tə, də à ma pìí à bɩ̀àn›. ");
INSERT INTO nnw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yá ʋ lʋʋ nii lɩ̀à tə ba wá swə. Ba dàń ma twá ʋ də̀ń wa, ba tʋn lɩ̀à, ba wʋ́: ‹Nə ba bɛɛ wà tə pɩ̀à, sə ʋ yà nə pɩ̀ʋ́›. ");
INSERT INTO nnw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ʋ pìí ʋ nan kʋ lʋʋ tə, ʋ bà ʋ pàrɩ̀ tə pɩ́rɩ́ kwa nə. Ʋ pa ba bon tʋ̀tʋ̀nà tə, ʋ nə pɩn səbiu tə, sə ʋ jə́n kʋ tə, ba nə nɩ. ");
INSERT INTO nnw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Təntən lìù tə fàrʋ́ ʋ yí, ʋ ga wʋ́: ‹Yuu tíú, à nɩ sɩ́án səbikʋlan fugə nywarɩ də sɩ́án səbikʋlʋ nədʋ tə, n nə pɩn nə›. ");
INSERT INTO nnw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yuu tíú tə ma swɩ̀n ʋ con, ʋ wʋ́: ‹N yɩ tʋtʋnzəŋu, n ga sɛ̀e à nii də pùə́ nədʋ. N tʋn zəni wiən tə wa, tə nə ba funə jə zənzən. Kʋ mʋ̀ tə yɩrɩ, à pɩn mʋ́ cwəŋə, sə n də́ pàrɩ̀ à tɩan fugə yuu wa›. ");
INSERT INTO nnw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bələ nii lìù tə də fàrʋ́ ʋ yí lá nə, ʋ ga wʋ́: ‹Yuu tíú, à nɩ sɩ́án səbikʋlan bonu nywarɩ, à súrí kʋ tə nə, n nə pɩn nə tə›. ");
INSERT INTO nnw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yuu tíú tə ma kʋ́ʋ̀ swɩ̀n ʋ də con, ʋ wʋ́: ‹N mʋ̀, à pɩn n də cwəŋə, sə n də́ pàrɩ̀ à tɩan bonu yuu wa›. ");
INSERT INTO nnw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tʋ̀tʋ̀nà tə wa lìù don mʋ̀ fàrʋ́ ʋ yí, ʋ ga wʋ́: ‹Yuu tíú nə̀ń, n sɩ́án səbikʋlʋ tə nə. À tì kʋ à ja va, à pəpəni à sə̀gə̀ gànʋ̀ nii nə. ");
INSERT INTO nnw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","N fən yà jə nə, n nə yɩ lìù tə, n yoo nə dà tə yɩrɩ. N yɩ lìù tə, n nə tì kʋ tə, n nə wà tún, n ga ce kʋ tə, n nə wà dwì›. Ʋ yuu tíú tə ma le wá, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‹N yɩ tʋtʋnkʋkwɩʋn. À wá twá n nii sʋ̀ràn tə nə, à ma bʋ̀rɩ̀ n bʋ̀rà. N n yə̀ə́ də, à yɩ lìù tə, à yoo nə dà, də à tì kʋ tə, à nə wà tún, à ga ce kʋ tə, à nə wà dwì. ");
INSERT INTO nnw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bɛ̀eɛ̀e dàń nə pɩn, n wà à səbiu tə jɩŋɩ, n pa baywələ nə? À nə twi nətən, à yà wá jon kʋ də kʋ yuu nywarɩ›. ");
INSERT INTO nnw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ʋ dàń ma swɩ̀n lɩ̀à tə con, ba nə wulə lá, ʋ wʋ́: ‹Á joŋə sɩ́án səbikʋlʋ nədʋ tə ʋ con, á pa lìù tə nə jə sɩ́án səbikʋlan fugə tə nə›. ");
INSERT INTO nnw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ba dàń ma swɩ̀n ʋ con, ba wʋ́: ‹Yuu tíú, sə ʋ nə də́ yáá ʋ jə sɩ́án səbikʋlan fugə!› ");
INSERT INTO nnw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‹À mʋ̀ nə swɩ̀n kʋ á con: Ba wá pa lìù tə nə, ʋ nə jə. Yá lìù tə, ʋ nə ba jə, ba wá jon mancɩn tə, də ʋ nə jə. ");
INSERT INTO nnw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Á mʋ̀, á jana à dʋŋa tə, ba nə ba pɩ̀à, sə à də́ pàrɩ̀ ba yuu wa, á ja bà yəbə. Á gwɩa ba à yɩ́á yuu!› » ");
INSERT INTO nnw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Zwezi nə swɩ̀n nətʋ kwa nə, ʋ zàn ʋ wulə lɩ̀à tə yáá, ʋ vələ *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ʋ nə bwələ Bɛtəfazwe də Betani tɩan də paan tə nii nə, ba nə boŋə ‹*oliviye tɩ̀án paan› tə, ʋ lɩ ʋ karbɩa tə wa lɩ̀à bələ, ʋ tʋn yáá, ");
INSERT INTO nnw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ʋ ga swɩ̀n, ʋ wʋ́: «Á vələ tɩʋ tə nə wulə yáá. Á nə vəli, á yí lá, á wá na bɩnabiə. Bɩ̀nà təntə, ka nə vwə lá, lìù tə wà ka yuu jə̀ń. Á kʋ̀rà ka á ja bà yəbə. ");
INSERT INTO nnw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lìù nə bwe aba, ʋ wʋ́: ‹Bɛ̀eɛ̀e nə, á pɩ̀à, sə á ja ka á ma fwa?› Á swɩ̀án kʋ tíú tə con də, kʋ ya *Yuu-Tiu nə pɩ̀à ka». ");
INSERT INTO nnw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Karbɩa tə vəli, ba na bɩ̀nà tə ndə Zwezi nə swɩ̀n nətʋ. ");
INSERT INTO nnw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba nə wulə ba kʋ̀rɩ̀ bɩ̀nà tə, ka tɩ̀án bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á kʋ̀rɩ̀ bɩnabiə ka tə?» ");
INSERT INTO nnw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ba ma le, ba wʋ́: «Kʋ yɩ Yuu-Tiu nə pɩ̀à ka». ");
INSERT INTO nnw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba dàń ma ja bɩnabiə tə, ba va Zwezi con. Ba lɩ ba ganan, ba tún ka tàŋá wa. Ba dàń pa Zwezi dɩ̀ ʋ jə̀ə́ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bɩnabiə tə nə zàn də Zwezi ka vìrí, máŋá tə wa, lɩ̀à tə làrɩ̀ ba ganan cwəŋə tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Zwezi nan oliviye tɩ̀án paan tə yuu ʋ zìní ʋ cú, ʋ ba ʋ bwələ Zwerizalɛmə nə. Kʋ máŋá tə wa, ʋ karbɩa tə yà dáá zənzən, ba ga sú də pupwən zənzən, ba zɩ̀n ba kwərə, ba ma bwɩ Yɩɩ nə yomɩlan tə mama yɩrɩ, ba nə nɩ. ");
INSERT INTO nnw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ba yà bwɩ Yɩɩ nə, ba wʋ́: «Yɩɩ wá fwa zəni pɩ̀ʋ́ tə yɩra, ʋ nə bɩ̀àn ʋ mʋ̀ Yuu-Tiu yɩrɩ yuu wa! Bɩcan sìə́ də dun wulə lìù tə con, ʋ nə wulə Yɩɩ *sàń nə!» ");
INSERT INTO nnw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","*Farɩzɩan-ba wa lɩ̀à duən, ba də yà nə wulə kʋ lalʋʋ tə wa, swɩ̀n Zwezi con, ba wʋ́: «Karnyɩna, swɩ̀n n karbɩa tə con, sə ba pú ba nii». ");
INSERT INTO nnw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Zwezi ma le ba, ʋ wʋ́: «À mʋ̀ nə swɩ̀n kʋ á con: Də ba nə swə ba pú ba nii, kʋ ba kwɛ̀e, kapana tə nə wá fwa kʋ zuzugu təntə». ");
INSERT INTO nnw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Máŋá tə nə, Zwezi nə bwələ *Zwerizalɛmə tə, ʋ nə nɩ kʋ ʋ zwɛ̀e, ʋ kwi kʋ lɩ̀à tə yɩrɩ, ʋ ga swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Á mʋ̀ Zwerizalɛmə tɩ̀án, á yà wàá zə̀n dɩɩn kʋ tə yəni, á ma lwarɩ yìə̀n tə, á nə wá twá tə nə, á ma na bɩcan sìə́! Yá sɩ́ʋ́n nə, tə yìə̀n təntə sə̀gə̀ á yáá nə. Á yɩ́á wàrɩ̀ tə tə nɩ! ");
INSERT INTO nnw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dɩan wá bà, tə tʋ á yun wa, n dʋŋa wá kʋ̀ bʋran ba kɩkarɩ aba, ba wá kəkəli aba ba kə tətəŋi wa, ba ga pú á yun nə tɩa mama. ");
INSERT INTO nnw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ba wá cʋ̀gʋ̀ aba mɩ́ámɩ́án, ba ga pupugu Zwerizalɛmə tə, də lɩ̀à tə mama, ba nə wulə kʋ wa. Ba bá yá kapan nədʋ, kʋ pə̀ń kʋ don yuu wa, á tɩʋ tə wa. Tə yìə̀n tə mɛ wá yí, á nə wà lwarɩ máŋá tə, Yɩɩ nə twi, sə ʋ san aba tə yɩrɩ!» ");
INSERT INTO nnw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Zwezi zʋa *Zwifə-ba Yɩɩ *dìə̀ dəwoo tə wa, ʋ dɩŋɩ baywələ lá nə, ");
INSERT INTO nnw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ʋ ga swɩ̀n ba con, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹À dìə̀ tə mɛ, sə ka yà yɩjʋnɩ dìə̀›. Yá á mʋ̀ janɩ ka, á ma fwa ŋwɩna yisəgə bwálɩ́». ");
INSERT INTO nnw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Zwezi yà kàrɩ̀ dɩɩn mama Yɩɩ dìə̀ tə wa. Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə, də lɩ̀à tə, ba nə yɩ lalʋʋ tə yáá tɩ̀án tə, yà pɩ̀à cwəŋə, sə ba pa ba gʋ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yá ba yà yə̀rì kʋ tə, ba nə wá fwa, lalʋʋ tə lɩ̀à tə mama nə yà fin ba yɩ́á ba kəni ʋ sʋ̀ràn tə con yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dɩɩn don nə, Zwezi yà wulə ʋ kàrɩ̀ Yɩɩ sʋywáŋʋ́ tə, ʋ bɩrɩ lɩ̀à nə, *Zwifə-ba Yɩɩ *dìə̀ tə wa. Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə, də ba *nəkwɩna tə twi ba yí wá. ");
INSERT INTO nnw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ba dàń swɩ̀n ʋ con, ba wʋ́: «Bɩrɩ nəba lìù tə nə ken dɩ̀àn n jɩɩn wa, n ma fwa yìə̀n tə tə, nə à yə̀ə́ wàà nə ken dɩ̀àn təntə n jɩɩn wa?» ");
INSERT INTO nnw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Zwezi ma le ba, ʋ wʋ́: «À də wá bwe aba yoo. ");
INSERT INTO nnw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Á swɩ̀n, á bɩrɩ nə: Wàà nə ken dɩ̀àn Zwan jɩɩn wa, sə ʋ lə lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ tə? Kʋ ya Yɩɩ, nə à yə̀ə́ ləzoni?» ");
INSERT INTO nnw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kʋ pɩn ba dàń wulə ba tʋ́tʋ̀nɩ́ duən, ba ga swɩ̀n duən con, ba wʋ́: «Nə nə le, nə wʋ́: ‹Kʋ ya Yɩɩ nə ken dɩ̀àn Zwan jɩɩn wa›, ʋ wá bwe nəba, ʋ wʋ́: ‹Bɛ̀eɛ̀e nə pɩn, á wà cɩ́gá ʋ sʋgʋ tə nə pɩn?› ");
INSERT INTO nnw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yá nə nə swɩ̀n, nə wʋ́: ‹Kʋ yɩ ləzoni nə ken dɩ̀àn ʋ jɩɩn wa›, lɩ̀à tə mama wá dɩlɩ nəba də kapana ba gʋ, lɩ̀à tə yə̀ə́ zəni ba waa con də, Zwan yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mə kʋ mʋ̀ nə pɩn, ba le, ba wʋ́, ba yə̀rì lìù tə nə ken dɩ̀àn Zwan jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Zwezi də ma le ba, ʋ wʋ́: «À də bá swɩ̀n lìù tə, ʋ nə ken dɩ̀àn à jɩɩn wa, à ma fwa tə yìə̀n təntə». ");
INSERT INTO nnw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kʋ kwa nə, Zwezi wulə ʋ sɩsarɩ zwansɩsara lalʋʋ tə con, ʋ wʋ́: «Bɛɛ don cwén divɛn tɩ̀án kárá. Ʋ tì ka ʋ yá də tʋtʋnvala duən, sə ba ywàń ka yuu, sə ʋ ga ŋwɩ́n ba də tɩ̀án tə bɩa vàn don. Kʋ bɛɛ tə dàń ga va lʋʋ nii don wa, sə ʋ dànɩ̀ lá. ");
INSERT INTO nnw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tɩ̀án tə bɩa tə bɩga máŋá tə, ʋ tʋn ʋ tʋ̀tʋ̀nʋ̀ don tʋtʋnvala tə con, sə ba pa wá ʋ kárá tɩ̀án bɩa tə tori. Yá kárá tə tʋ̀tʋ̀nà tə mà tʋ̀tʋ̀nʋ̀ tə ba dɩŋa, ba dʋgʋ ba pa ʋ pìí ʋ vìí də jɩkʋrɩkɛ. ");
INSERT INTO nnw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kárá tə tíú tə kʋ́ʋ̀ pìí ʋ tʋn ʋ tʋ̀tʋ̀nʋ̀ don. Yá kárá tə tʋtʋnvala tə kʋ́ʋ̀ mà ʋ də ba twɩn wá, ba ga dɩŋa wá ʋ vìí tʋtʋ. ");
INSERT INTO nnw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ʋ tə kʋ́ʋ̀ pìí ʋ tʋn tʋ̀tʋ̀nʋ̀ batwa nii nyiən. Ba mà ʋ mʋ̀ tə, də ba pɩra wá, ba ga dɩŋa wá, ba pa ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kárá tə tíú dàń ma bwe ʋ tɩ̀àn won tə, ʋ nə kʋ́ʋ̀ wá fwa. Ʋ dàń ma bʋ́n ʋ waa con, ʋ wʋ́: ‹À wá tʋn à biswənə tə lá nə, dɩɩn don, ba wá zìlí à bìú tə mʋ̀›. ");
INSERT INTO nnw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yá máŋá tə, kárá tə tʋtʋnvala tə nə nɩ bìú tə, də ʋ bɩ̀àn, ba swɩ̀n duən con nə, ba wʋ́: ‹Á nəŋə, lìù tə nə wá tɩnɩ kárá tə. Nə gwɩa wá, sə kárá tə yà nə mʋ̀ nyiən›. ");
INSERT INTO nnw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba ma ja wá, ba dɩlɩ kárá tə kwa, ba ga gʋ wá». Zwezi dàń ma bwe, ʋ wʋ́: «Bɛ̀eɛ̀e nə kárá tə tíú dàń wá ma fwa ba tʋtʋnvala təntə? ");
INSERT INTO nnw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kʋ yɩ ʋ wá va ʋ kárá tə wa, ʋ gʋ tʋtʋnvala tə mama, ʋ ga tì kárá tə, ʋ kə lɩ̀à duən jɩ̀àn wa». Máŋá tə, lɩ̀à tə nə nì tə sʋ̀ràn təntə, ba le, ba wʋ́: «Sə kʋ nətʋ tə dàn ká yí, abada». ");
INSERT INTO nnw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yá Zwezi ywàń ba yéé wa, ʋ ga swɩ̀n, ʋ wʋ́: «Á wàrɩ̀ sʋgʋ kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə də̀ń á nì. ‹Kapan tə, də̀lwə̀rə́ tə yà nə vɩga ba dʋgʋ vàn nə, kʋ mʋ̀ nə pìí kʋ jì dìə̀ nigwancɩɩn wárɩ́, kʋ yoo nə cà›. ");
INSERT INTO nnw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Lìù tə mama, ʋ nə wá tʋ kʋ yuu wa, ʋ wá nyʋnyʋgʋ ʋ tɩ̀àn kʋ nə. Yá kʋ kapan tə nə kʋ́ʋ̀ tʋa lìù yuu wa, də kʋ wá tɩtaga wá!» ");
INSERT INTO nnw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kʋ máŋá təntə wa, *Zwifə-ba Yɩɩ *joŋwana yun tɩan tə, də Yɩɩ nii *yənu tɩ̀án tə yà pɩ̀à, sə ba ja Zwezi, ba yà yə̀ə́ də, zwansɩsara tə yɩ ʋ ma swɩ̀n ba mʋ̀ con yɩrɩ. Ba yà pɩ̀à, ba fwa kʋ nətʋ tə, yá lalʋʋ tə fən yà ga jə ba. ");
INSERT INTO nnw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","*Zwifə-ba Yɩɩ nii *yənu tɩ̀án tə də Yɩɩ *joŋwana yun tɩan dàń yà wulə ba mɩnɩ Zwezi. Ba twá tɩa ba yə̀ lɩ̀à, ba tʋn ʋ nə. Ba lɩ̀à tə tì ba tɩ̀àn ba fwa ndə ləzwənzəŋə nə. Ba pɩ̀à ba twá bwiə nə, ba ma ja Zwezi, ba kə lɩ̀à tə jɩɩn, ba nə bʋ̀rɩ̀ bʋ̀rʋ̀, sə ba pa wá yáá tíú tə, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún. ");
INSERT INTO nnw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ba lɩ̀à tə bwe Zwezi, ba swɩ̀n, ba wʋ́: «Karnyɩna, nə yə̀ə́ də, sʋgʋ tə, kʋ nə naŋa n nii, də kàrà tə, n nə kàrɩ̀, tə yɩ cɩ́gá. N ba ləzwənə yii dəri, n yáá nə tə̀lə́ də dun tə, ləzoni nə jə yɩrɩ. Yá n ga bɩrɩ Yɩɩ cwəŋə də cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yɩɩ *nii pɩn cwəŋə, sə nə ŋwɩ́n, nə à yə̀ə́, sə nə dàn ká ŋwɩ́n lanpoo, nə pa *Romə-ba pɩ̀ʋ́ nəfarʋ tə nə?» ");
INSERT INTO nnw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yá Zwezi yà lwarɩ ba swɩan tə, ʋ ma swɩ̀n ba con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Á pɩan nə cɩnɩa səbikʋlʋ yəbə! Wàà yuu də ʋ yɩrɩ nə ba pʋ́pʋ́nɩ́ yəbə?» Ba ma le, ba wʋ́: «Romə-ba pɩ̀ʋ́ nəfarʋ tə nə». ");
INSERT INTO nnw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Mə á ŋwɩ́án kʋ tə nə yɩ Romə-ba pɩ̀ʋ́ nəfarʋ tə nyiən, á pa wá, sə á ga ŋwɩ́n kʋ tə nə yɩ Yɩɩ nyiən, á pa Yɩɩ də nə!» ");
INSERT INTO nnw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ba kʋ́ʋ̀ wà wànɩ́ yoo ba pìí ba swɩ̀n, ʋ con. Lalʋʋ tə yáá nə, ba púə́ ba nii, kʋ nə dɩ̀gà ba yun wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Sadɩsɩan-ba wa lɩ̀à duən twi Zwezi con. Mə ba mʋ̀ nə wʋ́ lìù ba tɩ, ʋ pìí ʋ bwin ʋ naŋa tə. Ba twi ba bwe wá, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Karnyɩna, kʋ pʋ́pʋ́nɩ́ Yɩɩ *nii nə, ʋ nə pɩn *Moyizə nə ka tə ʋ pa nəba, ʋ wʋ́: ‹Bɛɛ nə tɩga, ʋ yá ʋ kan nə, yá ʋ də ʋ kan tə wà bìú lʋrɩ, ʋ nyánʋ́ mɛ, sə ʋ tì kadənu tə. Ʋ lʋra bɩa ʋ nə, ʋ ma tún dwíí ʋ pa ʋ zʋnʋ tə nə tɩga tə nə›. ");
INSERT INTO nnw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yá nubɩa barpɛ duən yà nə wulə. Ba nəkwɩa tíú tə ma swe kan, ʋ tɩ ʋ yá wá, də ʋ wà bìú ʋ nə lʋrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bələ tíú tə də tì kan tə ʋ tɩ, də ʋ də wà ba bìú duən nə jə. ");
INSERT INTO nnw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Batwa nii nyiən tə də tì kan tə ʋ tɩ, də ʋ də wà ba bìú jə. Kʋ nətʋ tə fwa ba nubɩa barpɛ tə mɛ yɩra. Ba mama tɩga də ba lìù nədʋ ba bìú jə də kadənu tə. ");
INSERT INTO nnw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kʋ kwa nə, kan tə də twi ʋ bà ʋ tɩ. ");
INSERT INTO nnw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Máŋá tə wa, tɩga nə wá bwin ba nan, ba nubɩa barpɛ tə wàà dàń nə wá ja kan tə, ʋ ma fwa ʋ kan? Ba mama barpɛ tə yəni kan tə, ndə ba kan nə lʋʋ wa». ");
INSERT INTO nnw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Zwezi ma le ba, ʋ wʋ́: «Bara tə də kana tə nə wulə zə̀n tə, ba swe duən. ");
INSERT INTO nnw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yá lɩ̀à tə nə kúrí, sə ba yà də Yɩɩ *sàń nə, ba ka bwin tə kwa nə kʋ́ʋ̀ bá swe duən. ");
INSERT INTO nnw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba kʋ́ʋ̀ bá tɩ. Ba wá yà ndə *malɩkɛ nə. Ba wá yà Yɩɩ bɩa. Ʋ lɩ ba tɩan wa, ʋ kə mɩɩ wá. ");
INSERT INTO nnw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yɩɩ dí yáá, ʋ bɩrɩ *Moyizə nə də, tɩga wàá ba bwin ba naŋa máŋá tə wa, ʋ nə swɩ̀n ʋ con kasɔɔ lanworu tə wa. Moyizə bon Yɩɩ tə, ʋ nə yɩ ləzoni *Yuu-Tiu Yɩɩ tə, nə nɩbara *Abərahamə də *Yɩzakə də *Zwakɔbə nə jʋ̀nɩ̀. ");
INSERT INTO nnw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kʋ nətʋ bɩrɩ də, Yɩɩ yɩ lɩ̀à tə, ba nə wulə mɩɩ wa, Yɩɩ, ʋ tà tɩga Yɩɩ. Lɩ̀à tə mama, ba nə wulə də Yɩɩ, nə yɩ lɩ̀à tə, ba nə wulə mɩɩ wa ʋ yáá con yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yɩɩ nii yənu tɩ̀án tə wa lɩ̀à duən ma swɩ̀n, ba wʋ́: «Karnyɩna, n le zəni!» ");
INSERT INTO nnw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lɩ̀à tə dàń ga pú ba nii, fən jə ba, sə ba kʋ́ʋ̀ bwe Zwezi yìə̀n duən. ");
INSERT INTO nnw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Kʋ yɩ kʋ wá twá nətə, lɩ̀à tə ma swɩ̀n də, *Kərisə yɩ pɩ̀ʋ́ *Davidə nàʋ́ cɩcɩ, naaa? ");
INSERT INTO nnw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pɩ̀ʋ́ Davidə tətə pʋ́pʋ́nɩ́ ʋ gwaran sagɩ tə wa, ʋ wʋ́: ‹*Yuu-Tiu swɩ̀n à Yuu-Tiu con, ʋ wʋ́: «Bàá jə̀ń à jɩzən nə, ");
INSERT INTO nnw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","də à ma kəni n dʋŋa n nɛɛ də̀ń nə, sə n nɩŋa ba!» › ");
INSERT INTO nnw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Də Davidə nə boŋə Kərisə ʋ ‹Yuu-Tiu›, kʋ dàń wá twá nətʋ, kʋ pa Davidə yuu tíú pìí ʋ yà ʋ nàʋ́?» ");
INSERT INTO nnw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lɩ̀à tə mama nə wulə ba cʋga Zwezi, máŋá tə wa, ʋ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Á cɩa á tɩ̀àn nə də Yɩɩ nii *yənu tɩ̀án tə. Ba mʋ̀ nə swə, sə ba zʋ gandaran, ba ga jijiri, ba ga swə, sə ba jʋn ba jə́rə́ bwálá wa. Ba twá lá, ba kúrí gwələ tə, ba nə nan zəni *Zwifə-ba *jə́rə́ dii tə wa. Ba jəni bwálá nəzəŋə nə, diŋə nəfaran wa. ");
INSERT INTO nnw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba vɩrɩ kadənə wiən, ba ga fwa yɩjʋnɩ, ba ba zwɛ̀e, ləzoni yáá con, sə ba ma bɩrɩ də, ba yɩ ləzwənzəŋə. Yɩɩ wá bʋ̀rɩ̀ ba bʋ̀rà, ʋ ga cʋ̀gà ba mɩ́ámɩ́án». ");
INSERT INTO nnw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zwezi nə wulə ʋ ywàŋá máŋá tə wa, ʋ nɩ jɩjə tɩ̀án də, ba wulə ba dɩ səbiu *Zwifə-ba Yɩɩ *dìə̀ səbiu daka tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ʋ nɩ kadənu don, ʋ nə yɩ zʋrʋ. Ʋ ken səbibii bələ daka tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kʋ kwa nə, ʋ pìí ʋ swɩ̀n, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kadənzʋrʋ təntə ken səbiu, ʋ doni ba duən tə mama. ");
INSERT INTO nnw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ba duən tə yɩ səbiu, tə nə bʋ́rɩ́ nə, ba tì ba pa. Ʋ mʋ̀ yɩ kʋ tə nə ga ʋ jɩɩn də̀ń nə nə, sə ʋ ma yə̀ ʋ də́, ʋ tì ʋ pa». ");
INSERT INTO nnw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lɩ̀à duən yà wulə ba swɩ̀n *Zwifə-ba Yɩɩ *dìə̀ tə yoo, ba wʋ́: «Kʋ cɩ́gá ziən zəni, də kʋ kapana nəzəŋə, ba nə sarɩ, də wiən duən, ba nə pɩn Yɩɩ nə, tə nə ken, sə tə ma nàn kʋ». ");
INSERT INTO nnw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Zwezi ma le ba, ʋ wʋ́: «Á ywàŋá tə wiən tə mama. Máŋá don wá bà, kapan nədʋ tətə bá pə̀ń kʋ don yuu wa. Tə mama mɩ́ámɩ́án wá lwá tɩa». ");
INSERT INTO nnw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lɩ̀à tə bwe Zwezi, ba wʋ́: «Karnyɩna, máŋá ka wa nə, kʋ wá tʋn? Bɛ̀eɛ̀e won nə wá yà mɩmɩnʋ, kʋ nə bɩrɩ máŋá tə, tə wiən təntə nə wá bà?» ");
INSERT INTO nnw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Zwezi swɩ̀n, ʋ wʋ́: «Á cɩa á tɩ̀àn nə, á dànà ká pa ba gɩgarɩ aba. Lɩ̀à zənzən wá ja à yɩrɩ, ba bà. Ba lìù mama ga wá swɩ̀n, ʋ wʋ́: ‹À mʋ̀ nə yɩ *Kərisə›, yá ‹Wiən tə mɛ yígúrə́ máŋá yí›. Á dànà ká twá ba kwa. ");
INSERT INTO nnw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Á wá nì də, lʋʋ ləzoni duən zàn, ba wulə ba tɛ duən. Lɩ̀à duən wá zàn, ba vɩ ba yun tɩ̀án nii. Á dànà ká pa fən ja aba. Tə yìə̀n təntə mɛ, sə tə tʋn. Yá kʋ tà lʋʋ zaŋʋ máŋá nə yí sɩ́ʋ́n sɩ́ʋ́n nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Dwíə́ tə lʋʋ mama wa wá ta, tə zɩgɩ duən nə. Yá payuu wá ta, kʋ zɩgɩ kʋ don payuu nə. ");
INSERT INTO nnw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tɩa wá səsəgi zənzən. Kʋ súrí niən də yayɩpwaran nə. Yá bwálá kapʋpʋ nə, wiən wá bà tə, nə wá kə fən lɩ̀à waa, tə duən də ga wá nan lanworu wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Də tə yìə̀n təntə tə wá yí, ba wá ja aba, ba wʋwalɩ ba ja aba. Ba va *Zwifə-ba *jə́rə́ dii lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà yáá con, sə ba bʋ̀rɩ̀ á bʋ̀rà, ba ga kə aba bàń dìə̀ wa. Á nə sɛ̀e à nii tə yɩrɩ, ba wá ja aba, ba va pɛ̀egá də yáá tɩ̀án, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kʋ mʋ̀ wʋwala təntə, nə wá pa aba cwəŋə, sə á ma swɩ̀n kʋ tə, á nə yə̀ə́ à yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kʋ mʋ̀ nə pɩn, á wà mɛ, sə á də́ yáá á pa kʋ tə, á nə wá swɩ̀n, á ma jon á tɩ̀àn, tə yoo ja aba. ");
INSERT INTO nnw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","À mʋ̀ tətə nə wá kə yənu sʋ̀ràn á nii wa. Kʋ pa ba tə, ba nə swɩ̀n, ba zɩga á nə, bá wànɩ́ ba ja nii, ba ma tʋ́tʋ̀nɩ́ á nii wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Á ninə-ba, də á nyɩna-ba, də á nubɩa, də á dabara tətə nə wá ja aba, ba pa lɩ̀à tə nə, ba nə bʋ̀rɩ̀ bʋ̀rà. Lɩ̀à duən wá tɩ á waa. ");
INSERT INTO nnw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lɩ̀à tə mama wá dʋ́n aba à mʋ̀ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yá won mama bá fwa aba, abada. Á yukʋʋ nədʋ tətə bá jén. ");
INSERT INTO nnw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kʋ wá twá á pɩ́nʋ́ nə, á ma na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Zwezi kʋ́ʋ̀ ma swɩ̀n, ʋ wʋ́: «Á nə wá na də, pamana kɩkarɩ *Zwerizalɛmə, sə ba ta kʋ, máŋá tə, á mɛ, sə á yəni də, kʋ cʋna máŋá bwələ. ");
INSERT INTO nnw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kʋ máŋá tə wa, sə ba lɩ̀à tə, ba nə wá yà Zwide nagwanaa con, dəri ba dɩ̀ pɛɛn. Ba tə, ba nə wá yà Zwerizalɛmə wa nə, mɛ, sə ba dəri ba nan, ba yá tɩʋ tə. Ba tə, ba nə wá yà tɩbii tə wa kʋ́ʋ̀ dàn ká pìí ba zʋ Zwerizalɛmə wa nə. ");
INSERT INTO nnw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tə dɩan təntə nə, Yɩɩ wá fwìn ʋ lɩŋa kʋ máŋá təntə wa. Yá kʋ wá twá nətʋ, kʋ pa yìə̀n tə mɛ, Yɩɩ nii *sʋ̀sʋ̀nà tə nə pʋ́pʋ́nɩ́ tə nii ma sú. ");
INSERT INTO nnw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kʋ wá yà lɛɛ máŋá təntə wa, kana tə nə, ba nə jə pwìí, də ba tə nə, bɩa nə ŋwà ba nyʋnɩ nə. Kʋ lʋʋ təntə lɩ̀à wá də́ càn zənzən, Yɩɩ lɩŋa ga wá zàn ba yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kʋ lʋʋ tə lɩ̀à dʋŋa wá gʋ ba duən də lagʋrɩ sɩ̀ʋ́, ba ga ja ba duən ba fwa bàń dìə̀ lɩ̀à lʋʋ níə́ kapʋpʋ wa. Lɩ̀à tə nə ba *Zwifə-ba wá mà Zwerizalɛmə tɩ̀án, ba pú duən yuu ba nɩŋɩ ba kɛ̀eń. Ba wá fwa kʋ, kʋ ja vələ máŋá tə, ba dɩ̀àn nə wá bà tə zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Zwezi kʋ́ʋ̀ ma swɩ̀n, ʋ wʋ́: «Yìə̀n wá tʋn yɩcaʋ tə nə pén tə waa. Tə wá tʋn cànà tə də kacɩlacɛ tə wa. Fən zənzən wá zʋ lɩ̀à tə nə wulə tɩa yuu wa, vʋʋ tə də mʋʋ nakulə tə zuzugu nəfarʋ tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kʋ tə nə bɩ̀àn tɩa yuu wa tə, fən wá gʋ lɩ̀à, ba nə wá bʋ́n kʋ yoo. Dɩ̀àn tə nə wulə lanworu tə wa wá gugurə. ");
INSERT INTO nnw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kʋ kwa nə, ba dàń wá na *Ləzwənə-Biu tə bakwan tə wa, də ʋ bɩ̀àn də dɩ̀àn də dun tə nə dáá. ");
INSERT INTO nnw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Máŋá tə, tə yìə̀n təntə nə wá wulə tə tʋŋa, á zɩan á yun yɩɩ nə, á kwɛn á tɩ̀àn á zɩgɩ mənə mənə, á ga ywàń. Yɩɩ wá jon aba á jɩɩn wa, sɩ́ʋ́n sɩ́ʋ́n». ");
INSERT INTO nnw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kʋ kwa nə, Zwezi swɩ̀n, ʋ wʋ́: «Á ywàŋá kapɩrʋ də tɩ̀án tə duən: ");
INSERT INTO nnw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Máŋá tə, á nə nɩ tə zɩan tə də, tə wulə tə twe, lìù nə bá swɩ̀n á con də, wocəri máŋá bwələ. ");
INSERT INTO nnw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mə kʋ yɩ nətʋ, də á nə nɩ tə yìə̀n tə, tə twi tə tʋn á lwara də, Yɩɩ pàrɩ̀ diŋə tə bwələ. ");
INSERT INTO nnw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ yoo təntə wá tʋn, də zə̀n lɩ̀à tə mama, ba nə wulə tɩa yuu wa, tə wà tɩ ba zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lanworu də tɩa wá jén, yá à sʋ̀ràn tə mʋ̀ bá jén, abada!» ");
INSERT INTO nnw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Zwezi kʋ́ʋ̀ ma swɩ̀n, ʋ wʋ́: «Á cɩa á tɩ̀àn nə, á dànà ká pa swanyʋa də wiən tə, á nə pɩ̀à, sə á ma yà lʋʋ wa twara jon á pubʋŋɩ tə. Kʋ nə tà nətʋ, kʋ dɩɩn tə wá dɩ̀ á yuu wa naa nədʋ. ");
INSERT INTO nnw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kʋ dɩɩn tə nə, kʋ wá yà ndə waya nə, kʋ nə janɩ ganaŋa, kʋ pa lɩ̀à tə mama nə, ba nə wulə tɩa ka tə mama yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Á dànà ká dwɛ̀e, á jʋ̀nà Yɩɩ máŋá mama, sə á ma wànɩ́ á ja dɩ̀àn á jon á tɩ̀àn kʋ tə jɩɩn wa, kʋ nə wá bà. Nətʋ nə á wá wànɩ́ á zɩgɩ *Ləzwənə-Biu tə yáá nə». ");
INSERT INTO nnw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yɩcaʋ wa, Zwezi yà kàrɩ̀ *Zwifə-ba Yɩɩ *dìə̀ tə wa. Tɩtɩn nə ʋ yà nan, ʋ va ʋ pʋrɩ tɩa *oliviye tɩ̀án paan tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jɩjʋ fuən fuən lalʋʋ tə mama yà dəri, ba va ʋ con, Yɩɩ dìə̀ tə wa, ba cʋga wá. ");
INSERT INTO nnw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Cànà tə *Zwifə-ba nə də́ dipɛn tə, kʋ nə ba sabwarɩ kəni tə, ba nə boŋə ‹*Pakə› cànà tə, máŋá yí kʋ zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə, yà pɩ̀à cwəŋə, sə ba ma gʋ Zwezi, yá ba yà dəri lɩ̀à tə fən. ");
INSERT INTO nnw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","*Sɩtana dàń ma ja Zwidasə, Zwezi karbɩa fugə bələ tə wa lìù don, ba nə boŋə ‹Yisəkariyɔtə›, ʋ zʋ. ");
INSERT INTO nnw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Zwidasə vəli, ʋ vʋrʋ də *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ *dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə yun tɩ̀án tə, ʋ bɩrɩ ba nətʋ tə, ʋ nə wá twá tə, ʋ ma kə wá ba jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba lɩ̀à tə pwìí poli zəni. Ba dàń kàn nii də, ba wá pa wá səbiu. ");
INSERT INTO nnw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zwidasə də ba ken duən yuu, ʋ dàń ga pɩ̀à cwəŋə nəzəŋu tə, ʋ nə wá twá ʋ ma kə wá ba jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dɩan tə, ba nə yàá də́ dipɛn tə, kʋ nə ba sabwarɩ kəni, tə twi tə yí. Kʋ təntən dɩɩn tə nə nə, ba mɛ, sə ba gʋ pabii, ba ma fwa *Pakə cànà tə wodiu. ");
INSERT INTO nnw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Zwezi dàń ma tʋn Piyɛrə də Zwan, ʋ swɩ̀n ba con, ʋ wʋ́: «Á vələ, á tanɩ wodiu tə, á pa nəba, sə nə də́». ");
INSERT INTO nnw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ba ma bwe wá, ba wʋ́: «Yə̀n nə n pɩ̀à, sə nə tanɩ kʋ mʋ̀ wodiu təntə?» ");
INSERT INTO nnw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Zwezi swɩ̀n ba con nə, ʋ wʋ́: «Á cʋga zəni! Máŋá tə wa, á nə wá zʋ tɩʋ tə wa, á wá jə́rí bɛɛ don, ʋ nə zɩŋa nɩ́á kwàrá. Á wá pú kʋ bɛɛ tə nə, á zʋ sàń tə wa, ʋ nə zwɩ. ");
INSERT INTO nnw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Á ga swɩ̀n dìə̀ tə tíú con, ʋ wʋ́: ‹Karnyɩna bwe, sə ʋ jə́n dìə̀ tə, ʋ də ʋ karbɩa tə nə wá də́ Pakə cànà wodiu ka wà tə, wa yə̀n?› ");
INSERT INTO nnw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ʋ dàń wá bɩrɩ aba dəyuu dìə̀ nəfarʋ don, də kʋ wa zɩla. Mə lá nə, á wá tanɩ Pakə cànà wodiu tə». ");
INSERT INTO nnw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ʋ karbɩa tə dàń ma va, ba na tə yìə̀n tə mama, ndə Zwezi nə man, ʋ bɩrɩ ba nətʋ. Ba dàń ga kə Pakə cànà wodiu tə sírí lá nə. ");
INSERT INTO nnw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cànà tə wodiu diŋə máŋá yí, Zwezi də ʋ *tʋntʋna tə dàń twi ba jə̀ń duən nə, sə ba wulə ba də́. ");
INSERT INTO nnw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ʋ swɩ̀n ba con, ʋ wʋ́: «À sóní zəni, sə nə mama tə kə duən nə, nə də́ *Pakə cànà wodiu kʋ tə, də à càn máŋá tə wà yí. ");
INSERT INTO nnw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yá à mʋ̀ nə swɩ̀n kʋ á con: À kʋ́ʋ̀ bá pìí à də́ kʋ tə, kʋ ja vələ máŋá tə, ba nə wá nì kʋ cànà təntə də̀ń, Yɩɩ pàrɩ̀ tə wa». ");
INSERT INTO nnw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ʋ dàń ma tì wùrú zʋŋa tə, ʋ kə ʋ con, ʋ ga kə Yɩɩ lɛ̀eɛ̀e. Kʋ kwa nə, ʋ swɩ̀n, ʋ wʋ́: «Á joŋə á nyʋ, á tàrà duən! ");
INSERT INTO nnw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","À mʋ̀ nə swɩ̀n kʋ á con: À kʋ́ʋ̀ bá nyʋ divɛn də aba, kʋ nə zɩgɩ sɩ́ʋ́n, kʋ ja vələ máŋá tə, Yɩɩ nə wá də́ ʋ pàrɩ̀ tə». ");
INSERT INTO nnw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kʋ kwa nə, ʋ tì dipɛn tə, ʋ kə Yɩɩ lɛ̀eɛ̀e kʋ yɩrɩ. Kʋ kwa nə, ʋ fʋa fʋa kʋ, ʋ pa ba, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Kʋ yɩ à yɩra tə nə, kʋ nə pɩn aba. Á dàń fwa kʋ nətʋ tə, á ma lìí à yoo». ");
INSERT INTO nnw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ba nə dí ba zwɛ̀e, máŋá tə wa, Zwezi kʋ́ʋ̀ tì divɛn wùrú zʋŋa wa, ʋ fwa nətʋ, də ʋ pa ba, ʋ ga swɩ̀n, ʋ wʋ́: «Divɛn kʋ tə wùrú zʋŋa ka tə wa nə yɩ à jana tə, tə nə yɩ Yɩɩ *nimarʋ dʋ̀n tə, tə nə wá nan á yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Á ywàŋá, lìù tə, ʋ nə wá ja nə, ʋ pa tə, wulə də nə, wodiu kʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","*Ləzwənə-Biu tə mɛ, sə ʋ vìí, ndə kʋ nə mɛ nətʋ, yá kʋ wá yà càn kʋ pa lìù tə nə, ʋ nə wá ja wá, ʋ pa». ");
INSERT INTO nnw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ba dàń ma wulə ba bwe duən, sə ba jə́n, wàà nə wá fwa kʋ yoo təntə ba wa. ");
INSERT INTO nnw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zwezi karbɩa tʋ́tʋ̀nɩ́ duən, sə ba jə́n, ba wa nə mɛ, sə ʋ jə̀ń ba mama yuu wa. Kʋ mʋ̀ nə pɩn, tʋ́tʋ̀ná dàń twi, tə tʋ ba tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Zwezi swɩ̀n ba con, ʋ wʋ́: «Pɛ̀egá də́ dɩ̀àn ba lʋʋ dwíə́ tə mama yuu wa. Yá ba boŋə lʋʋ pabɩa mʋ̀ ‹lɩ̀à tə, ba nə fwa zəni›. ");
INSERT INTO nnw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yá kʋ wà mɛ, sə kʋ ya nətʋ á mʋ̀ con. Lìù tə, ʋ nə yɩ ləzwənfarʋ á wa, mɛ, sə ʋ ya ndə bisɩmabiə nə. Yá lìù tə, ʋ nə tɩ aba, mɛ, sə ʋ ya ndə lìù tə nə, ʋ nə tʋŋa ʋ pɩn aba. ");
INSERT INTO nnw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Lìù tə, ba nə tuŋə wodiu, ba pɩn, ʋ də́, də ʋ tə, ʋ mʋ̀ nə nə tuŋə kʋ, ba wàà nə dwə ʋ don? Kʋ tà lìù tə, ʋ nə də́ tə, naaa? Á wa nə, à mʋ̀ Zwezi, à yɩ ndə lìù tə nə, ʋ nə tʋŋa, ʋ pɩn aba. ");
INSERT INTO nnw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Á yɩ lɩ̀à tə, á nə yɩ də nə, dɩɩn mama à càn tə də máŋá tə wa, yìə̀n nə yugu nə, sə tə pa à tʋn yokʋkwɩʋn. ");
INSERT INTO nnw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","À swə, sə á də də́ kʋ pàrɩ̀ təntə, ndə à nyɩna nə pɩn, sə à də də́ kʋ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Á wá də́ cànà də nə, à pàrɩ̀ dìə̀ tə wa. Á wá jə̀ń padaran yun á bʋ̀rɩ̀ *Yɩzərayɛlə dwíə́ dəkurən fugə bələ tə bʋ̀rà». ");
INSERT INTO nnw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Zwezi swɩ̀n Simon Piyɛrə con, ʋ wʋ́: «Simon, Simon, cʋgʋ! *Sɩtana lòrì cwəŋə, sə ʋ zɩzaga aba, ndə ba nə zɩzaga wobɩa, sə ba lɩ tə də tə wopulə duən wa. ");
INSERT INTO nnw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yá à dàń jʋn Yɩɩ à pa mʋ́, sə n waa tə, n nə ken Yɩɩ nə tə, dàn ká jén. Máŋá tə wa, n nə wá pìí n bà à con, sə n dàn n nubɩa jɩ̀àn». ");
INSERT INTO nnw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon Piyɛrə le wá, ʋ wʋ́: «*Yuu-Tiu, à ken à sírí, sə à zʋ bàń dìə̀ də mʋ́, sə à tɩ də mʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Zwezi ma le wá, ʋ wʋ́: «Piyɛrə, à mʋ̀ nə swɩ̀n kʋ n con: N wá tɛn də, n yə̀rì nə zə̀n, nɛɛ batwa, də cəbɩʋ tə wà kwi». ");
INSERT INTO nnw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Zwezi swɩ̀n ba con, ʋ wʋ́: «Də à yà nə tʋn aba, à ga swɩ̀n də, á dànà ká tì səbiu, nə à yə̀ə́ lɔ̀ɔ̀, nə à yə̀ə́ natʋra, bɛ̀eɛ̀e yà nə mùrì aba?» Ba ma le wá, ba wʋ́: «Won mama wà nəba mùrì». ");
INSERT INTO nnw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Zwezi ma kʋ́ʋ̀ le, ʋ wʋ́: «Sɩ́ʋ́n nə, sə lìù tə, ʋ nə jə səbiu, sə ʋ tì, sə lìù tə, ʋ nə jə lɔ̀ɔ̀, sə ʋ tì, sə lìù tə, ʋ nə ba lagʋrɩ sɩ̀ʋ́ jə, sə kʋ tíú yə̀ ʋ gandarʋ, ʋ də́ yáá, ʋ ma yə̀ lagʋrɩ sɩ̀ʋ́. ");
INSERT INTO nnw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","À mʋ̀ nə swɩ̀n kʋ á con: Kʋ mɛ, sə kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa nii ma sú, tə tʋn à yɩra: ‹Ba gàlɩ̀ wá, ba ma cen yolwanfwana nii nə›. Cɩ́gá, kʋ tə nə pʋ́pʋ́nɩ́ à yuu wa, tə bɩ̀àn, sə kʋ jì». ");
INSERT INTO nnw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Karbɩa tə le, ba wʋ́: «*Yuu-Tiu, nə̀ń lagʋrɩ sɩ̀án bələ». Zwezi ma le ba, ʋ wʋ́: «Kʋ mɛ nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kʋ kwa nə, Zwezi nan, ndə ʋ dɩan mɛ nə fwa nətʋ tə, ʋ va *oliviye tɩ̀án paan tə yuu wa. Ʋ karbɩa tə ga púə́ ʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Máŋá tə wa, ʋ nə vəli, ʋ yí kʋ bwálɩ́ təntə, ʋ swɩ̀n ba con, ʋ wʋ́: «Á lòrì Yɩɩ, sə ʋ san aba, sə *Sɩtana dàn ká wànɩ́ aba, ʋ də́də́n, sə ʋ yigu, ʋ pa á tʋn yokʋkwɩʋn». ");
INSERT INTO nnw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ʋ dàń ga fàrʋ́ ʋ nan kwa, ʋ va yáá mancɩn, ndə lìù ka dɩlɩ kapan, kʋ va kʋ tʋ bwálɩ́ nə, ʋ tʋ ʋ nadwana yuu, ʋ ga lòrì Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ʋ dàń swɩ̀n, ʋ wʋ́: «À nyɩna, də n nə pɩ̀à kʋ, pa, sə yacara tətə twiən tə yá nə. Yá à pɩ̀à, sə n mʋ̀ puswənə nə tʋn, sə à mʋ̀ nyiən tə ga kwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","*Malɩka dàń ma zàn Yɩɩ *sàń nə, ka bà ka nan Zwezi nə, ka cú ka dàn ʋ jɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Zwezi pùə́ cʋ̀gʋ̀ zənzən. Kʋ mʋ̀ nə pɩn, ʋ lòrì Yɩɩ də dɩ̀àn zənzən. Ʋ tɩlʋŋʋ palɩ ndə jana nə, kʋ loni, kʋ twɩ tɩa. ");
INSERT INTO nnw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ʋ nə lòrì Yɩɩ ʋ zwɛ̀e, ʋ zàn ʋ pìí ʋ bà ʋ karbɩa tə con. Yá ʋ twi, də ba pwìí cʋ̀gʋ̀. Kʋ mʋ̀ nə pɩn, ba tə́gə́ ba dwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ʋ swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á dwɛ̀e? Á zaŋa, á ga lòrì Yɩɩ, sə Sɩtana dàn ká wànɩ́ aba ʋ də́də́n, sə ʋ yigu, sə ʋ pa, á tʋn yokʋkwɩʋn». ");
INSERT INTO nnw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zwezi nə wulə ʋ swɩ̀n, máŋá tə wa, də nə̀ń lɩ̀à nə ba bɩ̀àn. Lìù tə, ba nə boŋə Zwidasə, ʋ də nə yɩ Zwezi karbɩa fugə bələ tə wa, lìù don, yà nə wulə ba yáá, ʋ vəli. Ʋ fàrʋ́ ʋ yí Zwezi yɩra, sə ʋ kʋkwalɩ wá. ");
INSERT INTO nnw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Mə kʋ wá twá kʋkwalʋ nə, n ma ja *Ləzwənə-Biu n pa!» ");
INSERT INTO nnw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lɩ̀à tə nə wulə də Zwezi tə, nə na yoo tə, kʋ nə bɩ̀àn, ba swɩ̀n, ba wʋ́: «*Yuu-Tiu, nə wá za də lagʋrɩ sɩ̀án, naaa?» ");
INSERT INTO nnw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ba wa lìù don ma cʋ̀rɩ́ lagʋrɩ sɩ̀ʋ́, ʋ ma za *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tʋ̀tʋ̀nʋ̀ jɩzən zɩɩn, ʋ gwəŋə. ");
INSERT INTO nnw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «Á yágá, kʋ mɛ nətʋ!» Ʋ ma dwen bɛɛ tə zɩɩn tə nə, ʋ ga zùrì kʋ. ");
INSERT INTO nnw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kʋ kwa nə, Zwezi swɩ̀n Yɩɩ joŋwana yun tɩ̀án tə, də Yɩɩ *dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə yun tɩ̀án tə, də Zwifə-ba *nəkwɩna tə con, ba nə twi, sə ba ja wá tə, ʋ wʋ́: «Á twi də lagʋrɩ sɩ̀án də dangwələn, sə á ma ja à nə, ndə à yɩ ŋwɩ̀àn tə, à nə gwɩ lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","À yà wulə də aba dɩɩn mama, Zwifə-ba Yɩɩ dìə̀ tə wa, á ga wà nə jɩn. Yá máŋá kʋ tə yɩ á mʋ̀, də lìù tə, ʋ nə yɩ yikunu pɩ̀ʋ́ tə nyiən». ");
INSERT INTO nnw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba nə jɩn Zwezi, ba ja wá, ba va *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə dìə̀ wa. Piyɛrə púə́ ba kwa yɩŋʋna. ");
INSERT INTO nnw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ba ken mən, ba jə̀ə́ tə yáá, Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə kàrá tətəŋi wa. Piyɛrə də twá ʋ jə̀ə́ ba tətəŋi wa lá. ");
INSERT INTO nnw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tʋtʋnbʋa don nə nɩ wá, mən tə yáá nə, ʋ ywàń wá zən, ʋ ga swɩ̀n, ʋ wʋ́: «Bɛɛ wà tə də yɩn də Zwezi!» ");
INSERT INTO nnw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yá Piyɛrə tɛn, ʋ wʋ́: «À nakʋa, à yə̀rì wá!» ");
INSERT INTO nnw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kʋ nə fwa mancɩn, bɛɛ don də nə kʋ́ʋ̀ ʋ nɩ wá, ʋ swɩ̀n, ʋ wʋ́: «N də wulə ba lɩ̀à tə wa». Piyɛrə ma le bɛɛ tə, ʋ wʋ́: «À twá à tə̀lə́ ba wa!» ");
INSERT INTO nnw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kʋ nə lɛ ndə lugu nədʋ nə, lìù don də tə zɩgɩ dɩ̀àn, ʋ wʋ́: «Cɩ́gá mama, bɛɛ wà tə də yɩ Galile tíú. Ʋ də yɩn də Zwezi». ");
INSERT INTO nnw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piyɛrə le, ʋ wʋ́: «À dabɛɛ, à yə̀rì kʋ tə, n nə swɩ̀n!» Kʋ máŋá tə wa, ʋ nə wulə ʋ swɩ̀n, də cəbɩʋ kwi. ");
INSERT INTO nnw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","*Yuu-Tiu pìí ʋ vəvəri, ʋ ywàń Piyɛrə. Piyɛrə dàń lìí kʋ tə, Yuu-Tiu nə swɩ̀n ʋ con nə, ʋ wʋ́: «Zə̀n, də cəbɩʋ tə nə wà kwi, n wá tɛn nɛɛ batwa də, n yə̀rì nə». ");
INSERT INTO nnw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyɛrə dàń nan, ʋ ga kwi yinənkurə. ");
INSERT INTO nnw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bara tə nə jə Zwezi tə wulə ba mʋŋa wá də ba mà. ");
INSERT INTO nnw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba yàá pú ʋ yɩ́á nə, ba ga bwe wá, ba wʋ́: «Lwarɩ lìù tə, ʋ nə mà mʋ́!» ");
INSERT INTO nnw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba swɩ̀n sʋ̀ràn duən, tə nə twɩn Yɩɩ, ba pa wá. ");
INSERT INTO nnw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tɩa nə twi ka pʋrɩ, máŋá tə wa, *Zwifə-ba *nəkwɩna, də Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə twi, ba kun duən nə, ba ga pa ba ja Zwezi, ba ja bà ba yun tɩ̀án tə, ba nə bʋ̀rɩ̀ *bʋ̀rà tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ba swɩ̀n, ba wʋ́: «Swɩ̀n nə con də, n nə yɩ *Kərisə». Zwezi ma le ba, ʋ wʋ́: «À nə swɩ̀n kʋ á con, á bá pa kʋ cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","À ma nə bwe aba bwiə nədʋ, á bá le nə. ");
INSERT INTO nnw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kʋ nə zɩgɩ sɩ́ʋ́n, *Ləzwənə-Biu tə wá jə̀ń Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, jɩzən vàn nə». ");
INSERT INTO nnw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ba mama tə dàń ma swɩ̀n, ba wʋ́: «Kʋ mʋ̀ yɩrɩ nə, n yɩ Yɩɩ-Biu?» Zwezi ma le ba, ʋ wʋ́: «À yɩ wá, ndə á nə swɩ̀n nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba dàń ma swɩ̀n, ba wʋ́: «Nə kʋ́ʋ̀ ba lɩ̀à pɩ̀à, sə ba bɩrɩ nəba yoo don. Nə tətə nì kʋ ʋ nii wa». ");
INSERT INTO nnw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","*Zwifə-ba *nəkwɩna, də Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə mama ken duən, ba zàn ba ja Zwezi, ba ja va *Pilatə yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ba swɩ̀n ba zɩgɩ Zwezi nə, ba wʋ́: «Nə nɩ bɛɛ wà tə, də ʋ sugə nə lʋʋ dwíí tə, ʋ kəni *Romə-ba nə. Ʋ cɩ̀, sə ba dàn ká ŋwɩ́n lanpoo, ba pa Romə-ba pɩ̀ʋ́ nəfarʋ tə nə, ʋ ga wʋ́, ʋ mʋ̀ nə yɩ *Kərisə, kʋ də̀ń nə yɩ pɩ̀ʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatə dàń ma wulə wá ʋ bwe, ʋ wʋ́: «N mʋ̀ nə yɩ Zwifə-ba pɩ̀ʋ́ tə?» Zwezi ma le wá, ʋ wʋ́: «Mə kʋ yɩ nətʋ, ndə n nə swɩ̀n tə». ");
INSERT INTO nnw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatə ma swɩ̀n Yɩɩ joŋwana yun tɩ̀án tə, də lalʋʋ tə con, ʋ wʋ́: «À ba yolwan na bɛɛ wà tə yuu wa». ");
INSERT INTO nnw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yá ba tə zɩgɩ dɩ̀àn kʋ yuu wa, ba swɩ̀n, ba wʋ́: «Ʋ kàrà tə, ʋ nə kàrɩ̀ Zwide nagwanaa tə mama wa, sugə lɩ̀à tə, ka kəni Romə-ba nə, kʋ nə zɩgɩ Galile nagwanaa, kʋ ja ba kʋ nan yəbə». ");
INSERT INTO nnw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Máŋá tə wa, *Pilatə nə nì tə yìə̀n təntə, ʋ bwe, sə ʋ lwarɩ, də Zwezi nə yɩ Galile tíú. ");
INSERT INTO nnw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","8","Ʋ nə twi, ʋ nì də, kʋ yɩ nətʋ, ʋ lwarɩ də, ʋ nan pɩ̀ʋ́ *Erodə payuu tə wa. Kʋ dɩan dáá, Erodə nə nì də, ba swɩ̀n Zwezi yoo. Ʋ pɩ̀à, sə ʋ na Zwezi, ʋ də yà bʋŋa də, Zwezi wá fwa yomɩlʋ don, ʋ bɩrɩ wá. Erodə də yà twi kʋ máŋá tə wa, *Zwerizalɛmə wa. Kʋ mʋ̀ nə pɩn, Pilatə pa, ba ja Zwezi, ba va, ba pa Erodə nə. Máŋá tə wa, ʋ nə nɩ Zwezi, ʋ pùə́ poli zənzən. ");
INSERT INTO nnw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pɩ̀ʋ́ Erodə bwe Zwezi bwiə kapʋpʋ, yá Zwezi ga wà wá le. ");
INSERT INTO nnw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Yɩɩ nii *yənu tɩ̀án tə də yà zɩga lá, ba swɩ̀n sʋlwana ba zɩga Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodə də ʋ pamana tə wulə ba mʋŋa wá. Ba nə mʋn wá, ba zwɛ̀e, ba tì ganmʋlɩ, ba ma zʋ wá, ba ga pa ba pìí ba ja wá, ba va Pilatə con. ");
INSERT INTO nnw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kʋ dɩɩn tə nə, pɩ̀ʋ́ Erodə də Pilatə pìí ba jì dabara, ndə kʋ tà ba mʋ̀ yà nə dʋŋa duən fuən. ");
INSERT INTO nnw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","*Pilatə ken *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án, də Zwifə-ba yun tɩ̀án tə, də lalʋʋ tə duən nə, ");
INSERT INTO nnw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á jɩn bɛɛ wà tə, á ja bà, á ga á wʋ́, ʋ sugə lɩ̀à, ʋ kəni *Romə-ba nə. À mʋ̀ nə bwe wá á yáá con, à mʋ̀ wà yolwan nədʋ nɩ, tə mʋ̀ yìə̀n təntə wa, á nə swɩ̀n á zɩgɩ ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pɩ̀ʋ́ *Erodə də wà yoo nɩ ʋ yuu wa. Kʋ mʋ̀ nə pɩn, ʋ pa ba pìí ba ja wá, ba bà nə con. Bɛɛ wà tə wà yoo fwa, kʋ nə mɛ, sə ba gʋ wá, kʋ yɩrɩ nə. ");
INSERT INTO nnw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","À dàń wá pa, ba mà wá, ba ga tì wá ba dʋgʋ». ");
INSERT INTO nnw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kʋ yà yɩ kálʋ́, *Pakə cànà mama nə yí, sə ba dʋgʋ bàń dìə̀ lìù nədʋ. ");
INSERT INTO nnw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ba mama tə twá duən, ba bubwi, ba wʋ́: «Pa, ba gʋ wà tə, sə ba ga dʋgʋ Barabasə!» ");
INSERT INTO nnw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Kʋ Barabasə təntə zàn ʋ sugu *Zwerizalɛmə tɩ̀án, ʋ kəni Romə-ba nə, máŋá don wa. Kʋ tə súrí lagʋrɩ don nə, ʋ nə fwa. Kʋ mʋ̀ nə pɩn, ba yà jɩn wá, ba kə bàń dìə̀. ");
INSERT INTO nnw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatə nə pɩ̀à, sə ʋ dʋgʋ Zwezi tə, ʋ dàń pìí ʋ kʋ́ʋ̀ tì sʋgʋ, sə ʋ swɩ̀n lɩ̀à tə con. ");
INSERT INTO nnw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lɩ̀à tə dàń cə̀rí, ba wʋ́: «Pa, sə ba paa wá dagarʋ yuu wa! Pa, sə ba paa wá dagarʋ yuu wa!» ");
INSERT INTO nnw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatə kʋ́ʋ̀ bwe, ʋ swɩ̀n ba con, nɛɛ batwa nii nə, ʋ wʋ́: «Bɛ̀eɛ̀e yokʋkwɩʋn nə, ʋ fwa? À mʋ̀ wà yoo nɩ ʋ yuu wa, kʋ nə mɛ, sə ba gʋ wá kʋ yɩrɩ. À dàń wá pa, ba mà wá, à ga tì wá ba dʋgʋ». ");
INSERT INTO nnw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yá lɩ̀à tə dàń tə bubwi, ba kəni yɩɩ nə, ba wʋ́, ʋ pa, sə ba paa Zwezi dagarʋ tə yuu wa. Ba bubwiə tə kálɩ́ Pilatə. ");
INSERT INTO nnw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatə ma sɛ̀e, sə ʋ fwa kʋ tə, ba nə pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ʋ ma tì Zwezi, ʋ pa ba, sə ba ma fwa kʋ tə, ba nə pɩ̀à. Ʋ dàń ga dʋgʋ bɛɛ tə, ba nə lòrì. Ʋ mʋ̀ lìù tə, ʋ nə sugə lɩ̀à duən ʋ kəni Romə-ba nə, ʋ ga fwa lagʋrɩ də. Kʋ mʋ̀ nə pɩn, ba ma kə wá bàń dìə̀. ");
INSERT INTO nnw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pamana tə nə ja Zwezi, ba vəli máŋá tə wa, ba jə́rí bɛɛ don, ba nə boŋə ‹Simon, Sirɛnə tíú›, də ʋ naŋa gaʋ ʋ bɩ̀àn. Ba jɩn kʋ bɛɛ tə, ba jon Zwezi dagarʋ tə, ba ma zɩn wá, ʋ ja pìí ʋ wulə Zwezi kwa. ");
INSERT INTO nnw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lɩ̀à zənzən púə́ Zwezi kwa, də kana ba nə wori, ba ga zalɩ ba jɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Zwezi ma pìí ʋ vəvəri, ʋ swɩ̀n ba con, ʋ wʋ́: «*Zwerizalɛmə tɩ̀án kana-ba, á dànà ká kwi á pa à mʋ̀ nə! Á kwíə́ á pa á mʋ̀ də á bɩa nə! ");
INSERT INTO nnw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Máŋá don wá bà, ba nə wá swɩ̀n, ba wʋ́: ‹Pupwən wulə də kana tə, ba nə wàrɩ̀ bìú ba lʋrɩ. Pupwən wulə də ba tə, ba nə wà lʋrɩ də mama. Pupwən wulə də ba tə, bìú wà ba nyʋnɩ nə nyʋa›. ");
INSERT INTO nnw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kʋ máŋá tə wa, lɩ̀à wá lòrì pɛɛn, sə tə tʋ ba yuu nə, də ba lòrì dədwələn, sə tə də pú ba yuu nə. ");
INSERT INTO nnw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Də ba nə fwa à mʋ̀, à nə yɩ ndə dalɩʋ nə nətʋ, ba wá fwa á mʋ̀, Zwerizalɛmə tɩ̀án, á nə yɩ ndə dakʋran nə, ba dwen nətʋ». ");
INSERT INTO nnw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pamana tə nə jə Zwezi, ba vələ, sə ba gʋ, máŋá tə wa, ba jɩn yolwanfwana bələ, də ba kə lá, ba súrí Zwezi nə, sə ba gʋ də wá. ");
INSERT INTO nnw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pamana tə nə vəli, ba yí bwálɩ́ tə, ba nə boŋə ‹yuzʋŋa bwálɩ́› tə, máŋá tə, ba paa Zwezi dagarʋ tə yuu lá nə. Ba paa yolwanfwana bələ tə də dagaran bələ duən yuu, ʋ don ʋ jɩzən yuu, ʋ don tə də ʋ jɩgwiə yuu. ");
INSERT INTO nnw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «À nyɩna, ba yə̀rì kʋ tə, ba nə fwa. Kʋ mʋ̀ yɩrɩ nə, kwɛn ba cʋna tə, n lɩ n mʋ̀ də ba mʋ̀ pwərə wa». Ba tá kwé, ba ma tàrà ʋ ganan. ");
INSERT INTO nnw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lɩ̀à zɩga lá, ba ywàŋá kʋ tə nə fwa. *Zwifə-ba yun tɩ̀án tə mʋ̀ wulə ba mʋŋa wá, ba ga swɩ̀n, ba wʋ́: «Ʋ jon lɩ̀à duən, ʋ nə yɩ *Kərisə tə, Yɩɩ nə kúrí, sə ʋ jon ʋ tətə». ");
INSERT INTO nnw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pamana tə də wulə ba mʋŋa wá, ba fàrʋ́ ba yí ʋ yɩra, ba làrɩ̀ divɛn nyʋnʋ ʋ nə, ");
INSERT INTO nnw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ba ga swɩ̀n, ba wʋ́: «N cɩ́gá nə yɩ Zwifə-ba pɩ̀ʋ́, sə n tətə dàń jon n tɩ̀àn!» ");
INSERT INTO nnw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ba ken pʋ́pʋ́ná duən ʋ yuu con nə, ba wʋ́: «Ʋ tə nə yɩ Zwifə-ba pɩ̀ʋ́». ");
INSERT INTO nnw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yolwanfwanʋ tə don, ba nə paa dagarʋ tə yuu, də wulə ʋ twɩn wá, ʋ wʋ́: «N nə yɩ Kərisə, jon n tətə tɩ̀àn, sə n ga jon nəba, n kə lá!» ");
INSERT INTO nnw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ʋ don tə dàń caga ʋ nii nə, ʋ ga swɩ̀n, ʋ wʋ́: «N mʋ̀, n ba Yɩɩ fən dəri, n mʋ̀ lìù tə, n mʋ̀ də ʋ mʋ̀ mɛ, nə wulə tə càn tətə wa? ");
INSERT INTO nnw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kʋ yɩ kʋ twá, nə mʋ̀ tʋtʋnɛɛ nə. Kʋ mʋ̀ nə pɩn, nə mʋ̀ bələ tə mɛ, sə nə də́ càn tə tə. Yá ʋ mʋ̀ wà won mama fwa, kʋ nə lwara». ");
INSERT INTO nnw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kʋ kwa nə, ʋ swɩ̀n Zwezi con, ʋ wʋ́: «Lìí à yoo, máŋá tə wa, n nə wá də́ n pàrɩ̀ tə». ");
INSERT INTO nnw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Zwezi ma le wá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: Zə̀n, n wá yà də nə Yɩɩ *sàń nə». ");
INSERT INTO nnw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Kʋ nə zɩgɩ lugu fugə bələ máŋá wa, yɩcaʋ tə kʋ́ʋ̀ ba poni jə, yikunu ga púə́ tɩa tə mama nə, kʋ ja va dədəni lugu batwa. *Zwifə-ba Yɩɩ *dìə̀ mimii gànʋ̀ tə cɩrɩ bələ. ");
INSERT INTO nnw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zwezi bubwi ʋ kə yɩɩ nə, ʋ ga swɩ̀n, ʋ wʋ́: «À nyɩna, à ken à mɩɩ tə n jɩɩn wa». Ʋ nə swɩ̀n tə sʋ̀ràn tə kwa nə, nə ʋ mɩɩ zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","*Romə-ba pamana bíí yuu tíú tə nə nɩ kʋ tə nə tʋn, ʋ pɩn dun Yɩɩ nə, ʋ ga swɩ̀n, ʋ wʋ́: «Cɩ́gá mama, bɛɛ wà tə yà yɩ cɩ́gá tíú». ");
INSERT INTO nnw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lalʋʋ tə mama nə twi, ba na yoo tə nə tʋn, pìí ba vìrí, də ba zalɩ ba jɩ̀àn nə də pucʋnɩ. ");
INSERT INTO nnw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ba tə mama nə yə̀ə́ Zwezi, də kana tə nə kwé wá ba nan Galile nagwanaa, də yà zɩga yɩŋʋna, ba ga ywàŋá won tə nə tʋŋa. ");
INSERT INTO nnw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Bɛɛ don yà wulə lɩ̀à tə nə bʋ̀rɩ̀ bʋ̀rà tə wa, ʋ yɩrɩ nə Zwʋzɛfə. Ʋ nan *Zwifə-ba tɩʋ don, ba nə boŋə ‹Arimate›. Ʋ yɩ cɩ́gá tíú, ʋ ga jə bɩcabwanʋ də. Ʋ yà yɩ lìù tə, ʋ nə dànɩ̀, sə Yɩɩ də́ ʋ pàrɩ̀ tə. Ʋ mʋ̀ bɛɛ təntə wà sɛ̀e, ʋ twá ʋ duən tə nə bʋ̀rɩ̀ bʋ̀rà tə ba yofwanɛɛ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ʋ vəli ʋ yí *Pilatə, ʋ ga lòrì cwəŋə, sə ʋ gùrì Zwezi. ");
INSERT INTO nnw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ʋ lɩ wá dagarʋ tə yuu, ʋ kə tɩa, ʋ pəpəni kʋ, ʋ kə ganpon wa. Ʋ dàń ja wá va, ʋ tún ləbəri wa, ba nə kʋa pɩ̀ʋ̀ kapan wa, ba nə tə wà lìù lá ken. ");
INSERT INTO nnw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Zwifə-ba *sìə́ dɩɩn tə yà bwələ. Kʋ mʋ̀ nə pɩn, lɩ̀à tə mama wulə ba kəni ba sírí. ");
INSERT INTO nnw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kana tə nə nan Galile nagwanaa, ba twá Zwezi kwa, ba bà tə kwé Zwʋzɛfə, ba va ba na ləbəri tə, də nətʋ tə, ba nə ken Zwezi bʋʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ba nə pìí, ba vìí, ba tanɩ tɩralɩ də tɩralɩ nʋga, ba kə duən nə. Ba sìí, kʋ kwa nə, ndə Yɩɩ *nii yìə̀n tə, ʋ nə pɩn *Moyizə nə, nə bɩrɩ, sə kʋ fwa nətʋ tə *sìə́ dɩɩn nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","*Zwifə-ba *sìə́ dɩɩn tə tɩkʋnɩ nə, kana tə zàn jɩjʋ fuən fuən, ba zɩn tɩralɩ tə, ba nə kwɛn, ba ja va ləbəri tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba nə vəli ba yí lá nə, ba nɩ də, kapan tə bəbəli, kʋ nan ləbəri tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ba dàń zʋa ba yí lá, ba ga na də, *Yuu-Tiu Zwezi tɩgɩ tə tə̀lə́ lá nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba nə yà yə̀rì kʋ tə, ba nə wá swɩ̀n kʋ yuu wa, də nə̀ń lɩ̀à bələ, ba nə zʋa ganpwənə, tə nə cɩcɩlɩ, ba twi, ba nan ba nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Fən dàń nə zʋa ba, yá ba kə ba yáá tɩa. Lɩ̀à tə dàń swɩ̀n ba con, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, á pɩ̀à lìù tə, ʋ nə wulə mɩɩ wa, tɩga wa? ");
INSERT INTO nnw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ʋ tə̀lə́ yəbə. Ʋ pìí ʋ bwin ʋ nan tɩan wa. Á pirə á lìí á tɩ̀àn nətʋ tə, ʋ nə swɩ̀n á con, də ʋ tə wulə Galile nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ʋ swɩ̀n, ʋ wʋ́ də, kʋ mɛ, sə ba ja *Ləzwənə-Biu tə, ba pa lɩ̀à tə nə, ba nə yɩ cʋna lɩ̀à, sə ba paa wá dagarʋ yuu, sə ʋ ga pìí ʋ bwin ʋ nan dɩan batwa nii nə». ");
INSERT INTO nnw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ba dàń ma pìí ba lìí Zwezi sʋ̀ràn tə yoo. ");
INSERT INTO nnw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ba nan ləbəri tə wa, ba pìí ba ja tə yìə̀n təntə mama, ba va ba swɩ̀n Zwezi *tʋntʋna fugə nədʋ tə də lɩ̀à tə duən tə mama con. ");
INSERT INTO nnw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ba mʋ̀ kana təntə, ba nə swɩ̀n tə yìə̀n tə tʋntʋna tə con nə yɩ: Mari Madəlɛnə, Zwanə, Zwakə nuu Mari, də ba duən tə nə yɩn də ba. ");
INSERT INTO nnw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yá tʋntʋna tə bʋ́n də, kana tə sʋ̀ràn tə yɩ yomanan. Kʋ pa, ba wà tə cɩ́gá nə pɩn. ");
INSERT INTO nnw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yá Piyɛrə də kʋ́ʋ̀ zàn ʋ dəri, ʋ va ləbəri tə nii nə. Ʋ nə kwá tɩa ʋ ywàń, ʋ nɩ ganan tə, ba nə ma pəpəni Zwezi tə, də tə cɩcɩ nə tə́gə́ tɩa. Kʋ yoo tə nə tʋn tə gwárɩ́ wá. Ʋ ma pìí ʋ va sàń. ");
INSERT INTO nnw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kʋ dɩɩn tə tətə nə, Zwezi karbɩa bələ yà vələ tɩʋ don, ba ma boŋə ‹Emayisə›. Kʋ tɩʋ tə də *Zwerizalɛmə yí kilomɛtərə fugə nədʋ. ");
INSERT INTO nnw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba yà wulə ba swɩ̀n yìə̀n tə mama nə tʋn tə yoo. ");
INSERT INTO nnw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba nə wulə ba swɩ̀n tə yìə̀n təntə, máŋá tə wa, Zwezi twi, ʋ də ba kə duən, ba vəli cwəŋə tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba nɩ wá, yá won yà cɩ̀gà, kʋ pa ba wà wá lwarɩ. ");
INSERT INTO nnw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ʋ swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e yuu wa nə, á ve də á vəli?» Ba cwən ba zɩgɩ, ba yéé ga ŋwɩ̀ń. ");
INSERT INTO nnw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ba wa lìù don, ba nə boŋə Kəleyopasə, ma le wá, ʋ wʋ́: «N mʋ̀ cɩcɩ nə yɩ vee, n nə wulə Zwerizalɛmə wa, n nə yə̀rì yìə̀n tə, tə nə tʋn lá, dɩan tətə nii nə?» ");
INSERT INTO nnw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ʋ ma le ba, ʋ wʋ́: «Bɛ̀eɛ̀e yìə̀n nə?» Ba ma le wá, ba wʋ́: «Yoo tə nə yí *Nazarɛtə Zwezi, ʋ nə yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀, ʋ nə jɩn dɩ̀àn Yɩɩ də *Yɩzərayɛlə lɩ̀à tə mama yáá con, ʋ tʋtʋnan də ʋ nii sʋ̀ràn wa nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nətʋ tə nə Yɩɩ *joŋwana yun tɩ̀án, də lɩ̀à tə nə bʋ̀rɩ̀ bʋ̀rà yáá tɩ̀án tə nə jɩn wá ba pa, ba bʋ̀rɩ̀ ʋ gʋrɩ bʋ̀rà, ba ga pa, ba paa wá dagarʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yá nə də yà ga jə yala də, ʋ mʋ̀ yà nə wá jon Yɩzərayɛlə lʋʋ lɩ̀à. Yá də kʋ mama, zə̀n kʋ tə dɩan batwa nə tə yìə̀n tə nə tʋn. ");
INSERT INTO nnw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kʋ nə dwən nətʋ, nə púlí tə wa kana duən gwárɩ́ nəba zənzən. Kana təntə vəli, kʋ jɩjʋ tə fuən fuən ləbəri tə nii nə, ");
INSERT INTO nnw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ba ga na də, Zwezi tɩgɩ tə tə̀lə́ lá nə. Ba pìí ba bà, ba wʋ́, *malɩkɛ nan ba nə, tə ga swɩ̀n ba con, tə wʋ́, Zwezi wulə ʋ mɩɩ wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nə wa lɩ̀à duən, ba nə yɩn də nəba, vəli ləbəri tə nii, ba ga na tə yìə̀n tə, ndə kana tə nə swɩ̀n nətʋ tə, yá ba wà Zwezi nɩ». ");
INSERT INTO nnw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Á mʋ̀ lɩ̀à tə, á nə ba yuu jə, á ga wà cɩ́gá pɩn lala Yɩɩ nii sʋ̀sʋ̀nà tə sʋ̀ràn tə mama nə: ");
INSERT INTO nnw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","*Kərisə tə, Yɩɩ nə tʋn tə, yà mɛ, sə ʋ də́ càn nətʋ, sə ʋ ma zʋ ʋ dun tə wa». ");
INSERT INTO nnw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ʋ dàń ma twá *Moyizə, də Yɩɩ nii sʋ̀sʋ̀nà tə duən tə nii sʋ̀ràn tə nə, ʋ man yoo tə mama Yɩɩ sagɩ tə nə swɩ̀n ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Máŋá tə, ba nə vəli, ba bwələ tɩʋ tə, Zwezi fwa, ndə ʋ lɛ ʋ vələ yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ba dàń ma kálɩ́ wá, ba swɩ̀n ʋ con, ba wʋ́: «Zɩgɩ də nəba, yɩɩ tʋa, tɩa yí kʋ zwɛ̀e». Ʋ ma zʋ, ʋ zʋrɩ ba con. ");
INSERT INTO nnw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ba nə wulə ba də́ máŋá tə wa, ʋ tì dipɛn tə, ʋ kə Yɩɩ lɛ̀eɛ̀e, ʋ ga fʋ kʋ, ʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ba yɩ́á súrú ʋ yuu wa, ba nə lwarʋ wá ba zwɛ̀e, ʋ jén ba yáá con. ");
INSERT INTO nnw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba dàń ma swɩ̀n duən nə, ba wʋ́: «Ʋ nə swɩ̀n də nəba, ʋ gùlí yìə̀n tə də̀ń, tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, ʋ bɩrɩ nəba cwəŋə tə yuu, yá ba nə bɩcan nə də́ nə?». ");
INSERT INTO nnw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ba bɩbarɩ ba zàn lala, ba pìí ba va Zwerizalɛmə. Ba vəli ba na karbɩa fugə nədʋ tə, də ba twá duən tə, ba kun duən nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Karbɩa fugə də nədʋ dàń ma swɩ̀n ba con, ba wʋ́: «*Yuu-Tiu cɩ́gá mama pìí ʋ bwin, ʋ nan tɩan wa, ʋ bɩrɩ ʋ tɩ̀àn Simon nə». ");
INSERT INTO nnw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ba lɩ̀à bələ tə dàń ma man kʋ tə nə yí ba cwəŋə tə yuu wa, ba bɩrɩ ba. Ba twi, ba man də, ba lwarʋ də, kʋ yɩ ʋ mʋ̀, máŋá tə wa, ʋ nə wulə ʋ fwɩ dipɛn tə. ");
INSERT INTO nnw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ba nə wulə ba swɩ̀n máŋá tə wa, Zwezi tətə twi, ʋ bà, ʋ nan ba tətəŋi wa, ʋ ga jʋn ba, ʋ wʋ́: «Bɩcan sìə́ wá yà də aba!» ");
INSERT INTO nnw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ba zəzəgə, fən ga zʋ ba zənzən, ba bʋŋa də, kʋ yɩ ciru nə nan ba nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, kʋ ma gwárɩ́ aba, yá pubʋnyirə tə tə də ga wulə də aba? ");
INSERT INTO nnw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Á ywàŋá à jɩ̀àn də à nɛɛ. Kʋ cɩ́gá yɩ à mʋ̀! Á dwiən à yɩra, á ga na! Ciru ba yatana də kurən jə, ndə à nə jə tə, à zɩga nətən». ");
INSERT INTO nnw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ʋ nə wulə ʋ swɩ̀n kʋ nətʋ, ʋ bɩrɩ ba ʋ jɩ̀àn də ʋ nɛɛ. ");
INSERT INTO nnw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pupwən zʋa ba, ba ga tə wà cɩ́gá pɩn, ba zwɛ̀e, kʋ nə gwárɩ́ ba tə yɩrɩ. Zwezi bwe ba, ʋ wʋ́: «Á ba won jə yəbə, ba nə də́, naaa?» ");
INSERT INTO nnw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba ma pa wá fəli kɩkaʋ, kʋ nə wùə̀. ");
INSERT INTO nnw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ʋ jon kʋ, ʋ də́ ba mama tə yɩ́á wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Zwezi swɩ̀n ʋ *tʋntʋna tə con, ʋ wʋ́: «Mə kʋ nə, à nə swɩ̀n á con, də à nə yɩn də aba. À swɩ̀n də yìə̀n tə mama, ba nə pʋ́pʋ́nɩ́ Yɩɩ *nii tə wa, ʋ nə pɩn *Moyizə nə, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə wa, də gwaran saga wa, à yuu wa mɛ, sə tə nii sú». ");
INSERT INTO nnw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ʋ súrí ba yɩ́á, sə ba nì yìə̀n tə də̀ń, tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ʋ swɩ̀n ba con, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ saga təntə wa, kʋ wʋ́ də, *Kərisə mɛ, sə ʋ dí càn, ʋ tɩ, ʋ ga pìí ʋ bwin ʋ nan tɩan wa, dɩan batwa nii nə. ");
INSERT INTO nnw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kʋ mɛ, sə ba zɩgɩ *Zwerizalɛmə nə, ba swɩ̀n ʋ yɩrɩ yuu wa sʋywáŋʋ́ tə, ba pa lʋʋ dwíə́ tə mama nə. Ba bon ba, sə ba vəvəri ba kwa, sə ba ma sá ba cʋna, sə Yɩɩ ga kwɛn tə ʋ lɩ ʋ mʋ̀ də ba pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Á yɩ lɩ̀à tə, á nə wàá á bɩrɩ, də á nɩ yìə̀n təntə. ");
INSERT INTO nnw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kʋ tə, à nyɩna nə kàn nii də à wá pa aba tə, kʋ wá bà á yuu wa. Yá á nə mɛ, sə á yà tɩʋ tə wa, kʋ ja vələ, á nə wá sú də dɩ̀àn tə, tə nə wá nan Yɩɩ nə, tə bà». ");
INSERT INTO nnw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Zwezi jɩn ba, ʋ ja va Betani tɩʋ con, ʋ zɩ̀n ʋ jɩ̀àn, ʋ lòrì Yɩɩ, sə ʋ fwa zəni ba yuu wa. ");
INSERT INTO nnw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Máŋá tə, ʋ nə wulə ʋ fwa zəni ba yuu wa, ʋ zàn ʋ pwɛ̀e də ba, ʋ ga zàn ʋ dɩ̀ yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ba də tʋa ba nadwana yuu, ba ga bʋ ʋ nə. Yá kʋ kwa nə, ba pìí ba va *Zwerizalɛmə də pupwən. ");
INSERT INTO nnw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dɩɩn mama ba yàá va *Zwifə-ba Yɩɩ *dìə̀ tə wa, ba bwɩ Yɩɩ nə.");
INSERT INTO nnw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Yɩɩ sʋgʋ tə yà nə wulə, də lʋʋ tə wà fwa. Sʋgʋ tə wulə də Yɩɩ. Yá kʋ mʋ̀ sʋgʋ tə yà nə yɩ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Də lʋʋ tə wà fwa, kʋ mʋ̀ yà nə wulə də Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yɩɩ twá də kʋ mʋ̀ sʋgʋ tə, ʋ ma fwa won mama. Won mama tə̀lə́, kʋ nə tà kʋ mʋ̀ sʋgʋ təntə, nə Yɩɩ ma fwa kʋ. ");
INSERT INTO nnw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mə kʋ mʋ̀ sʋgʋ təntə nə pɩn mɩɩ ləzoni nə. Yá kʋ mʋ̀ nə pɩn poni ləzoni nə. ");
INSERT INTO nnw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Poni yàá pɩpɩlɩ yikunu wa. Yá yikunu tə wà poni yáá nə cɩ̀. ");
INSERT INTO nnw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yɩɩ nə tʋn bɛɛ don, ʋ yɩrɩ nə yɩ Zwan. ");
INSERT INTO nnw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ʋ mʋ̀ nə yə̀ə́ poni tə. Ʋ dàń twi, sə ʋ bɩrɩ poni nə yɩ nətʋ, sə lɩ̀à tə mama twá ʋ nii sʋ̀ràn tə nə, ba kə ba waa lìù tə nə, ʋ nə yɩ poni. ");
INSERT INTO nnw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zwan tətə yà nə tà poni tə. Ʋ yɩ ʋ twi, sə ʋ bɩrɩ poni nə yɩ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sʋgʋ təntə nə yɩ cɩ́gá cɩ́gá poni. Kʋ mʋ̀ nə twi lʋʋ wa, kʋ pɩrʋ ləzoni mama. ");
INSERT INTO nnw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kʋ mʋ̀ Yɩɩ sʋgʋ təntə yà nə wulə lʋʋ tə wa. Yɩɩ twá sʋgʋ tə nə, ʋ ma fwa lʋʋ. Yá lɩ̀à tə lʋʋ nə tɩ ba ga wà kʋ lwarɩ. ");
INSERT INTO nnw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kʋ sʋgʋ təntə twi kʋ dwíí tɩ̀án con, ba lʋʋ nii wa, yá ba ga wà kʋ sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lɩ̀à tə mama, ba nə sɛ̀e kʋ, yá ba kə ba waa kʋ nə, kʋ pɩn cwəŋə ba mʋ̀ lɩ̀à təntə nə, sə ba jì Yɩɩ bɩa. ");
INSERT INTO nnw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ba nə ya Yɩɩ bɩa, kʋ tà kʋ twá də ləzoni lʋrɩ, nə à yə̀ə́ ləzwənə fɩra nə. Kʋ yɩ kʋ twá də Yɩɩ fɩra, ba ma yɩ ʋ bɩa. ");
INSERT INTO nnw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kʋ mʋ̀ Yɩɩ sʋgʋ təntə jigə ləzwənə. Lìù təntə yɩn nə tətəŋi wa. Nə nɩ ʋ dun tə. Dun təntə yɩ ʋ nyɩna Yɩɩ nə pɩn wá. Kʋ yɩ bidʋa kələn tə dun nə. Ʋ súə́ də pubwanʋ də cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zwan swɩ̀n ʋ yoo, ʋ bɩrɩ ʋ bubwi, ʋ wʋ́: «Mə ʋ mʋ̀ yoo nə à swɩ̀n də, lìù don wulə à kwa ʋ bɩ̀àn. Ʋ mʋ̀ nə dwə nə. Ʋ yà dí yáá ʋ wulə, də à tə tə̀lə́. ");
INSERT INTO nnw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nə mama nɩ nə tori ʋ jɩjə tə wa. Nə nɩ tə pubwanʋ nəfarʋ tə wa. Nə nɩ tə, tə pú duən kwa, wuuu. ");
INSERT INTO nnw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yɩɩ twá də *Moyizə, ʋ ma pa nəba ʋ *nii tə. Yá ʋ kʋ́ʋ̀ twá də Zwezi-*Kərisə, ʋ ma fwa ʋ pubwanʋ tə nə yɩra, ʋ ga pa nəba ʋ cɩ́gá tə. ");
INSERT INTO nnw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lìù tə wà Yɩɩ nɩ mama. Bidʋa kələn tə nə pɩn, ba lwarɩ Yɩɩ. Ʋ mʋ̀ də Yɩɩ nə yɩ nədʋ, ʋ ga wulə ʋ nyɩna Yɩɩ səpuni nə». ");
INSERT INTO nnw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","*Zwifə-ba yun tɩ̀án nə zɩgɩ *Zwerizalɛmə nə, ba tʋn Yɩɩ *joŋwana tə, də *Levi dwíí tə wa lɩ̀à duən Zwan con. Ba dàń vəli ba yí wá, ba bwe wá, ba wʋ́: «N mʋ̀ nə yɩ wàà?» Nə̀ń, kʋ tə, Zwan nə swɩ̀n ʋ bɩrɩ, kʋ máŋá tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zwan swɩ̀n kʋ cɩ́gá tə, ʋ bɩrɩ ba, ʋ wʋ́: «À mʋ̀ nə tà *Kərisə!» ");
INSERT INTO nnw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ba tə ma bwe wá, ba wʋ́: «N mʋ̀ dàń nə yɩ wàà? N yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ Eli naaa?» Ʋ ma le ba, ʋ wʋ́: «À mʋ̀ nə tà Eli!» Ba tə ma bwe wá, ba wʋ́: «N yɩ Yɩɩ nii sʋ̀sʋ̀nà tə naaa?» Ʋ ma kʋ́ʋ̀ le, ʋ wʋ́: «À mʋ̀ nə tà Yɩɩ nii sʋ̀sʋ̀nà tə!» ");
INSERT INTO nnw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ba dàń ma swɩ̀n ʋ con, ba wʋ́: «N mʋ̀ dàń nə yɩ wàà? Nə pɩ̀à kori, sə nə ja pìí nə va nə pa lɩ̀à tə nə, ba nə tʋn nəba. Bɛ̀eɛ̀e nə n tətə bʋŋa də, n yɩ?» ");
INSERT INTO nnw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Zwan-Batisə ma le, ʋ wʋ́: «À yɩ bɛɛ tə, Yɩɩ nii sʋ̀sʋ̀nʋ̀ *Ezayi nə swɩ̀n ʋ yoo də, ʋ bubwi kasɔɔ lanworu wa, ʋ wʋ́: ‹Á kwɩan *Yuu-Tiu cwəŋə tə, á pa ka ya mənə mənə›.» ");
INSERT INTO nnw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lɩ̀à tə, ba yà nə tʋn Zwan-Batisə con, ba duən yà yɩ *Farɩzɩan-ba. ");
INSERT INTO nnw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ba ma bwe wá, ba wʋ́: «N mʋ̀ nə nə tà Kərisə, n ma kʋ́ʋ̀ tà Eli, n ma kʋ́ʋ̀ tà Yɩɩ nii sʋ̀sʋ̀nʋ̀ tə, bɛ̀eɛ̀e nə pɩn, n dàń ma li lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ?» ");
INSERT INTO nnw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zwan-Batisə ma le ba, ʋ wʋ́: «À mʋ̀ yɩ à li lɩ̀à tə nɩ́á wa. Yá á tətəŋi wa lìù wulə lá, á nə yə̀rì wá. ");
INSERT INTO nnw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ʋ mʋ̀ nə wá pú à kwa ʋ bà. À jɩɩn mùrì, sə à kʋ̀rɩ̀ ʋ nɛɛ natʋra tətə». ");
INSERT INTO nnw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yoo kʋ tə mama yà yɩ Betani nə, nə kʋ tʋn, Zwurədɛn mʋnaa tə bɩbɩn tə don nə, Zwan yà nə li lɩ̀à tə nɩ́á tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kʋ tɩpʋrɩ nə, Zwan-Batisə na Zwezi də, ʋ ma bɩ̀àn ʋ con. Ʋ ma swɩ̀n Zwezi yoo lɩ̀à tə con, ʋ wʋ́: «Á nəŋə, Yɩɩ *pabiə tə, ka nə lɩ lɩ̀à mama cʋna. ");
INSERT INTO nnw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mə ʋ mʋ̀ yoo nə à swɩ̀n də, ʋ yɩ bɛɛ tə, ʋ nə wá pú à kwa ʋ bà. Ʋ mʋ̀ nə dwə nə. Ʋ yà dí yáá ʋ wulə, də à tə tə̀lə́. ");
INSERT INTO nnw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","À mʋ̀ yà yə̀rì wá. À mʋ̀ yɩ à twi, sə à lə lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. À twi, sə à pa *Yɩzərayɛlə lɩ̀à lwarɩ wá». ");
INSERT INTO nnw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Zwan kʋ́ʋ̀ swɩ̀n yoo kʋ tə, ʋ bɩrɩ, ʋ wʋ́: «À mʋ̀ yà yə̀rì wá. Yá Yɩɩ tʋn nə, sə à bà à lə lɩ̀à nɩ́á wa. Ʋ tʋn nə, ʋ ga swɩ̀n də, à wá na Yɩɩ-*Siŋu tə, kʋ cúə́ lìù yuu wa. Mə kʋ tíú nə li lɩ̀à Yɩɩ-*Siŋu tə wa. À dàń nɩ Yɩɩ-Siŋu tə, kʋ nan yɩɩ nə, ndə gunpwənə nə, kʋ cú kʋ jə̀ə́ Zwezi yuu wa. ");
INSERT INTO nnw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yá à nɩ kʋ, à swɩ̀n à bɩrɩ də, ʋ mʋ̀ nə ya Yɩɩ-Biu tə». ");
INSERT INTO nnw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kʋ tɩpʋrɩ nə, Zwan kʋ́ʋ̀ pìí ʋ bà lá, ʋ mʋ̀ də ʋ karbɩa bələ. ");
INSERT INTO nnw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ʋ nɩ Zwezi, də ʋ ma kɛ̀eń, ʋ ma swɩ̀n ʋ yoo, ʋ wʋ́: «Á nəŋə, Yɩɩ *pabiə tə nə!» ");
INSERT INTO nnw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Zwan karbɩa bələ tə nì kʋ sʋgʋ təntə. Ba dàń púə́ Zwezi kwa. ");
INSERT INTO nnw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Zwezi vəvəri ʋ ywàń, də kʋ yɩ ʋ mʋ̀ kwa nə ba púə́. Ʋ ma bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə á pɩ̀à?» Ba ma le wá, ba wʋ́: «Rabi, (kʋ də̀ń nə yɩ karnyɩna), n yɩ n zʋrɩ yə̀n nə?» ");
INSERT INTO nnw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Zwezi ma le ba, ʋ wʋ́: «Á bɩ̀àn, yá á wá na!» Ba dàń vəli, ba na bwálɩ́ tə, Zwezi yà nə wulə. Ba də wá yɩn duən nə kʋ dɩɩn tə nə. Kʋ yà yɩ ndə dədəni nii lugu banɩa nə. ");
INSERT INTO nnw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Karbɩa bələ tə, ba nə nì Zwan sʋ̀ràn tə, ba ga pìí ba twá Zwezi nə tə, lìù don yɩrɩ nə yɩ Andəre. Ʋ yɩ Simon Piyɛrə nyánʋ́. ");
INSERT INTO nnw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andəre dàń dí yáá, ʋ va ʋ yí ʋ tətə zʋnʋ Simon, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Nə mʋ̀ nɩ lìù tə, ʋ nə yɩ Mesi tə». Mesi də̀ń yɩ *Kərisə. ");
INSERT INTO nnw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andəre dàń ma ja Simon, ʋ va Zwezi con. Zwezi ma ywàń Simon, ʋ ga swɩ̀n, ʋ wʋ́: «N mʋ̀ nə yɩ Zwʋnasə bìú Simon. Ba wá bon mʋ́ Sefasə, kʋ mʋ̀ də̀ń nə yɩ ‹kapan›.» ");
INSERT INTO nnw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kʋ tɩpʋrɩ nə, Zwezi yà pɩ̀à, sə ʋ va Galile nagwanaa wa. Ʋ dàń ma va ʋ jə́rí Filipə. Zwezi swɩ̀n Filipə con, ʋ wʋ́: «Twá à nə!» ");
INSERT INTO nnw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipə yà yɩ Bɛtəsayɩda tíú. Andəre də Piyɛrə də nan kʋ mʋ̀ tɩʋ təntə. ");
INSERT INTO nnw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipə də vəli ʋ jə́rí Natanayɛlə. Ʋ ma swɩ̀n Natanayɛlə con, ʋ wʋ́: «Nə nɩ Zwezi. Ʋ yɩ *Nazarɛtə tíú, ʋ ga yɩ Zwʋzɛfə bìú. Mə ʋ yoo nə swɩ̀n Yɩɩ *nii sagɩ tə wa, ʋ nə pɩn *Moyizə nə, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə wa». ");
INSERT INTO nnw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayɛlə ma swɩ̀n Filipə con, ʋ wʋ́: «Wozəŋu wàá Nazarɛtə nə kʋ naŋa naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Filipə ma le wá, ʋ wʋ́: «Bàá, yá n wá na!» Zwezi na Natanayɛlə, də ʋ ma bɩ̀àn ʋ con, ʋ ma swɩ̀n ʋ yoo, ʋ wʋ́: «Á nəŋə, lìù tə, ʋ nə yɩ *Yɩzərayɛlə lìù cɩ́gá cɩ́gá. Ʋ ba lɩ̀à gɩgɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayɛlə ma bwe Zwezi, ʋ wʋ́: «N yə̀ə́ nə yə̀n nə?» Zwezi ma le wá, ʋ wʋ́: «À nɩ mʋ́, də n yà tə wulə kapɩrʋ tə də̀ń, də Filipə tə wà mʋ́ bon». ");
INSERT INTO nnw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayɛlə dàń ma pìí, ʋ wʋ́: «Rabi, n mʋ̀ nə yɩ Yɩɩ-Biu tə! N mʋ̀ nə ga yɩ Yɩzərayɛlə lɩ̀à pɩ̀ʋ́!» ");
INSERT INTO nnw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «À nə swɩ̀n də, à yà nɩ mʋ́ kapɩrʋ tə də̀ń nə, tə dàń nə pɩn, n kə n waa à nə. N tə wá na yofaran, tə nə dwə tətə». ");
INSERT INTO nnw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Zwezi ma swɩ̀n, ʋ súrí lá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á wá na lanworu də kʋ súrí. Yá Yɩɩ *malɩkɛ dɩ̀ də tə cwi *Ləzwənə-Biu tə yuu con». ");
INSERT INTO nnw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dɩan bələ kwa nə, ba vwə fúrú Káná nə, Galile nagwanaa tə wa. Zwezi nuu də yɩn lá. ");
INSERT INTO nnw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ba bon Zwezi də ʋ karbɩa tə də, ba nə wàá, sə ba bà, kʋ fúrú tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Máŋá don wa, divɛn tə, ba nə nywɩ̀n cànà tə wa, twi tə zwɛ̀e. Zwezi nuu tə dàń swɩ̀n ʋ con, ʋ wʋ́: «Ba kʋ́ʋ̀ ba divɛn jə». ");
INSERT INTO nnw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Zwezi ma le ʋ nuu tə, ʋ wʋ́: «Kan, bɛ̀eɛ̀e n pɩ̀à də nə? À tʋtʋnan máŋá tə wà yí!» ");
INSERT INTO nnw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ʋ nuu tə ma swɩ̀n tʋtʋnbɩa tə con, ʋ wʋ́: «Á fwa kʋ tə mama, ʋ nə wá swɩ̀n á con». ");
INSERT INTO nnw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sawurən bardʋ, ba nə fwa də kapana, yà zɩga kʋ bwálɩ́ tə wa. Kʋ nədʋ mama ya zwɩ litərə sapwɩtwa, nə à yə̀ə́ bíí. *Zwifə-ba yà kəni nɩ́á tə wa, ba ma sɩn ba tɩ̀àn, ndə kʋ nə yɩ ba yofwamɩʋn, ba fwa nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Á kənə nɩ́á á sú sawurən tə tə!» Tʋ̀tʋ̀nà tə ma kə nɩ́á ba sú tə nii. ");
INSERT INTO nnw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Á dàń kwaŋa, á ja va á pa lìù tə nə, ʋ nə ywàŋá wodirən tə yuu». Ba ma kwán tə, ba ja va, ba pa kʋ tíú nə. ");
INSERT INTO nnw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lìù tə, ʋ nə ywàŋá wodirən tə yuu, jon nɩ́á təntə, tə nə jigə divɛn tə, ʋ nyʋ mancɩn. Ʋ yà yə̀rì divɛn təntə mʋ̀ nə nan lá bwálɩ́. Yá tʋ̀tʋ̀nà tə, ba nə kwán nɩ́á tə mʋ̀ yà yə̀ə́. Lìù tə, ʋ nə ywàŋá wodirən tə yuu, dàń ma bon kanbarɩ tə, ");
INSERT INTO nnw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ʋ swɩ̀n ʋ con, ʋ wʋ́: «Lɩ̀à tə mama yàá dí yáá, ba pa divɛn tə, kʋ nə ywán zənzən. Yá máŋá tə wa, lɩ̀à tə nə nyʋa ba sú, kʋ kwa nə, ba dàń yàá pa ba divɛn tə, kʋ nə ba ywán zənzən. N mʋ̀ yá divɛn tə, kʋ nə ywán, kʋ bà kʋ yí sɩ́ʋ́n». ");
INSERT INTO nnw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mə Zwezi dɩga ʋ Yɩɩ dɩ̀àn mɩmɩnan tə də̀ń nətʋ. Kʋ yoo təntə tʋn Káná nə, Galile nagwanaa tə wa. Kʋ twá nətʋ, Zwezi ma bɩrɩ ʋ dun tə. Yá ʋ karbɩa tə ken ba waa ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kʋ mʋ̀ təntə kwa nə, ʋ mʋ̀ də ʋ nuu, də ʋ nyáná tə, də ʋ karbɩa tə vəli Kapɛrənayimə. Ba wà kʋ tɩʋ təntə wa yɩn ba dánɩ́, ba fwa dɩan bagalɩ cɩcɩ kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","*Zwifə-ba *Pakə cànà tə yà bwələ. Zwezi ma zàn, ʋ va *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ʋ nə yí lá, ʋ vəli *Zwifə-ba Yɩɩ *dìə̀ dəwoo tə wa. Ʋ dàń nɩ baywələ lá, də ba wulə ba yoli nɩan, də pee də nasara gunponi. Ʋ na lɩ̀à duən də, ba nə tún ba tabɩlan, ba ma lárɩ́ səbɩa. ");
INSERT INTO nnw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Zwezi ma zàn ʋ ja ŋoni, ʋ ma fwa fɩfɩʋ, ʋ ma dɩŋɩ ba mʋ̀ də ba nɩan tə, də ba pee tə mama, ʋ lɩ Yɩɩ dìə̀ dəwoo tə wa. Ʋ yigu səbilara tə səbɩa tə, ʋ lwá tɩa. Ʋ yigu ba tabɩlan tə, ʋ vəvəri ʋ pú tɩa. ");
INSERT INTO nnw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Zwezi dàń ma swɩ̀n lɩ̀à tə, ba nə yoli nasara gunponi tə con, ʋ wʋ́: «Á lɩa tə mʋ̀ wiən təntə yəbə! Á dànà ká tì à nyɩna Yɩɩ dìə̀ tə, á ma fwa yolu dìə̀!» ");
INSERT INTO nnw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Zwezi nə fwa nətʋ, ʋ karbɩa tə lìí ba tɩ̀àn, də kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: «Sonu tə, à nə jə à pa n dìə̀ tə nə, yɩ ndə mən nə, tə də́ à bɩcan wa». ");
INSERT INTO nnw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Zwifə-ba yun tɩ̀án dàń ma bwe Zwezi, ba wʋ́: «Bɛ̀eɛ̀e Yɩɩ dɩ̀àn mɩmɩnʋ nə, n wá fwa n bɩrɩ nəba, sə nə ma lwarɩ də, n jə cwəŋə, sə n fwa yoo kʋ tə yiri?» ");
INSERT INTO nnw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Zwezi ma le ba, ʋ wʋ́: «Á cʋ̀gá Yɩɩ dìə̀ ka tə. Yá à wá pìí à lwà ka, dɩan batwa nii nə». ");
INSERT INTO nnw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Zwifə-ba yun tɩ̀án ma swɩ̀n, ba wʋ́: «Ba fwa bɩna sapwilə də bardʋ, sə ba ma lwà Yɩɩ dìə̀ ka tə, ba pa, ka zwɛ̀e. Yá n mʋ̀ dàń wʋ́, n wá lwà ka dɩan batwa nii nə?» ");
INSERT INTO nnw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Zwezi yà nə swɩ̀n, də Yɩɩ dìə̀ tə, kʋ yà yɩ ʋ tətə yɩra tə yoo nə, ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kʋ mʋ̀ nə pɩn, ʋ karbɩa tə lìí ba tɩ̀àn, də ʋ yà swɩ̀n kʋ yoo təntə, ʋ nə pìí ʋ bwin ʋ nan tɩan wa, kwa nə. Yá ba dàń pɩn cɩ́gá kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, də sʋgʋ tə nə, Zwezi nə swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","*Pakə cànà tə máŋá wa, Zwezi yà wulə *Zwerizalɛmə nə. Lɩ̀à zənzən ken ba waa ʋ nə, Yɩɩ dɩ̀àn mɩmɩnan tə yɩrɩ, ba nə nɩ də, ʋ fwa. ");
INSERT INTO nnw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yá Zwezi bɩcan yà wà sɩn ba yuu wa. Ʋ yà yə̀ə́ kʋ tə, ba mama nə yɩ. ");
INSERT INTO nnw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Zwezi yà tà lìù tə, ba nə mɛ, sə ba swɩ̀n kʋ tə lìù nə yɩ, ba bɩrɩ wá. Ʋ tətə yə̀ə́ kʋ tə, kʋ nə wulə ləzwənə bɩcan wa. ");
INSERT INTO nnw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bɛɛ don yà wulə *Farɩzɩan-ba wa, ʋ yɩ *Zwifə-ba pɩ̀ʋ́, ʋ yɩrɩ nə yɩ Nikodɛmə. ");
INSERT INTO nnw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dɩɩn don nə, ʋ zàn ʋ va Zwezi con tɩtɩn nə, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Karnyɩna, nə yə̀ə́ də, n yɩ lìù tə, Yɩɩ nə tʋn, sə n kàrɩ̀ nəba. Kʋ mʋ̀ nə pɩn, n ma fwa Yɩɩ dɩ̀àn mɩmɩnan tə, lìù mama nə wàrɩ̀ ʋ fwa, də Yɩɩ nə tə̀lə́ də kʋ tíú». ");
INSERT INTO nnw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Zwezi ma le wá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: Lìù nə wà ʋ tɩ̀àn lʋrɩ lʋrdʋn, ʋ wàrɩ̀ Yɩɩ pàrɩ̀ tə wa lìù ʋ yanɩ». ");
INSERT INTO nnw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛmə ma swɩ̀n Zwezi con, ʋ wʋ́: «Nətə nə lìù wá lʋrɩ ʋ tɩ̀àn lʋrdʋn, də ʋ nə yɩ nəkwɩa? Ʋ kʋ́ʋ̀ wàá ʋ pìí ʋ zwɩ ʋ nuu pùə́ wa, sə ʋ lʋrɩ wá, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Zwezi ma le wá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: Də lìù nə wà twá də nɩ́á, də Yɩɩ-*Siŋu tə, ʋ ma lʋrɩ ʋ tɩ̀àn, ʋ wàrɩ̀ Yɩɩ pàrɩ̀ tə wa, ʋ zwɩ. ");
INSERT INTO nnw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lɩ̀à tə, ba nə yɩ bɛɛ də kan nə lʋrɩ, ba yɩ ləzwənə dwíí nə tɩ ba. Yá lɩ̀à tə, ba nə yɩ Yɩɩ-Siŋu tə nə lʋrɩ, ba də yɩ Yɩɩ-Siŋu tə nə tɩ ba. ");
INSERT INTO nnw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dàn ká pa kʋ dɩ̀ n yuu, də à nə swɩ̀n n con, à wʋ́: Á mɛ, sə á lʋrɩ á tɩ̀àn lʋrdʋn. ");
INSERT INTO nnw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vʋʋ yɩ kʋ fuli bwálɩ́ tə nə, kʋ nə swə. N yàá nə̀ń kʋ zəzugu, n ga yə̀rì bwálɩ́ tə, kʋ nə naŋa, nə à yə̀ə́ bwálɩ́ tə, kʋ nə vələ. Mə kʋ yɩ nətʋ də lìù tə mama, Yɩɩ-Siŋu tə nə lʋrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛmə dàń ma bwe Zwezi, ʋ wʋ́: «Nətə nə kʋ nətʋ tə wàá kʋ tʋŋa?» ");
INSERT INTO nnw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Zwezi ma le wá, ʋ wʋ́: «N yɩ karnyɩna, n yɩrɩ nə nan *Yɩzərayɛlə wa. N ga yə̀rì yìə̀n tə tə? ");
INSERT INTO nnw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: Nə yàá swɩ̀n kʋ tə, nə nə yə̀ə́. Nə ga swɩ̀n nə bɩrɩ aba kʋ tə, nə nə nɩ. Yá á ba nə sʋgʋ joŋə. ");
INSERT INTO nnw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Á ba cɩ́gá pɩn à sʋ̀ràn tə nə, də à nə swɩ̀n tɩa ka tə yuu yìə̀n tə yoo á con. Nətə nə á dàń wá pa cɩ́gá à sʋ̀ràn tə nə, də à nə wá swɩ̀n Yɩɩ sàń yìə̀n tə yoo á con? ");
INSERT INTO nnw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lìù mama tə wà Yɩɩ sàń nə dɩ̀, də kʋ tà *Ləzwənə-Biu tə, ʋ nə nan Yɩɩ sàń, ʋ cú. ");
INSERT INTO nnw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","*Moyizə fwa dən, ʋ kə yɩɩ nə daʋ yuu wa, ʋ zɩgɩ lɩ̀à tə mama yáá con. Mə nətʋ tətə nə ba mɛ, sə ba zɩ̀n Ləzwənə-Biu tə də ba kə yɩɩ nə lɩ̀à mama yáá con. ");
INSERT INTO nnw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yá lìù tə mama, ʋ dàń nə ken ʋ waa ʋ nə, ʋ wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Cɩ́gá, Yɩɩ sóní lɩ̀à mama zənzən. Kʋ mʋ̀ nə pɩn, ʋ pa ʋ bidʋa kələn tə, sə lìù tə mama, ʋ nə ken ʋ waa ʋ nə, ʋ kʋ́ʋ̀ dàn ká jén mama. Yá ʋ wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yɩɩ mʋ̀ yà wà ʋ bìú tə tʋn lʋʋ wa, sə ʋ bʋ̀rɩ̀ lɩ̀à bʋ̀rà. Yɩɩ tʋn wá, sə ʋ jon lɩ̀à ba cʋna tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Lìù tə, ʋ nə keni ʋ waa ʋ nə wuuu, ba kʋ́ʋ̀ bá bʋ̀rɩ̀ kʋ tíú bʋ̀rà. Yá lìù tə, ʋ nə ba ʋ waa keni ʋ nə, kʋ tíú bʋ̀rà dí yáá ka bʋ̀rɩ̀, ʋ nə ba ʋ waa keni Yɩɩ bidʋa kələn tə nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Á nəŋə, nətʋ tə gʋrɩ bʋ̀rà tə nə wá twá, kʋ ma bà. Poni twi lʋʋ wa, yá ləzoni ga sóní yikunu, ba doni poni tə, ba nə tʋŋa yolwana tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Lìù tə mama, ʋ nə tʋŋa yolwana, ʋ culi poni, ʋ ga ba poni wa naŋa. Fən ja wá, də dɩɩn don ʋ tʋtʋnkʋkwɩnan tə nə wá nan poni tə nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yá lìù tə, ʋ nə twá cɩ́gá cwəŋə, ʋ yàá bà poni wa, sə ʋ tʋtʋnɛɛ tə nan poni tə wa, sə lɩ̀à mama na, də ʋ tʋtʋŋɩ mama twá Yɩɩ fɩra nə». ");
INSERT INTO nnw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kʋ mʋ̀ təntə kwa nə, Zwezi karbɩa tə kwé wá, ba va Zwide nagwanaa wa. Ʋ mʋ̀ də ba dàń yà wulə lá, ʋ ga li lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zwan də yà wulə Enon nə, kʋ nə bwələ də Salimə. Nɩ́á yà dáá kʋ bwálɩ́ tə wa. Ʋ dàń li lɩ̀à nɩ́á wa. Yá lɩ̀à dàń yà twi ʋ con, sə ʋ lə ba nɩ́á tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kʋ máŋá tə wa, də ba tə wà Zwan ken bàń dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zwan karbɩa tə, də *Zwifə-ba yuu tíú don, zɩ̀n tʋ́tʋ̀ná ba pwərə wa. Ba tʋ́tʋ̀ná tə yɩ nətʋ lìù nə wá sɩn ʋ tɩ̀àn də nɩ́á, ndə ba nə mɛ, sə ba fwa nətʋ, ba ma zìlí Zwifə-ba yofwamɩʋn tə. ");
INSERT INTO nnw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Zwan karbɩa tə zàn ba va ba yí wá, ba swɩ̀n ʋ con, ba wʋ́: «Karnyɩna, lìù don yà yɩn də mʋ́, Zwurədɛn mʋnaa tə kwa con. N swɩ̀n ʋ yoo n bɩrɩ nəba. Nə̀ń, ʋ də wulə ʋ li lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. Yá lɩ̀à tə mama vələ ʋ mʋ̀ con». ");
INSERT INTO nnw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zwan ma le, ʋ wʋ́: «Ləzwənə mama wàrɩ̀ won ʋ nɩ, də kʋ nə tà kʋ tə, Yɩɩ nə ken kʋ dɩ̀àn ʋ jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Á tətə yə̀ə́, də à swɩ̀n à bɩrɩ də, à mʋ̀ nə tà *Kərisə tə. À yɩ Yɩɩ nə tʋn nə, sə à ya Kərisə yáá, à bà. ");
INSERT INTO nnw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kʋ yɩ ndə lìù nə, ʋ nə jə ʋ kan, ʋ nə pɩ̀à, sə ʋ swe. Kanbarɩ nə tɩ ʋ kan. Yá kanbarɩ tə dabɛɛ tə, ʋ nə jə̀ń ʋ səpuni nə, ʋ yàá cʋga kanbarɩ tə sʋgʋ. Ʋ pùə́ ya poli kanbarɩ tə sʋ̀ràn tə yɩrɩ. Mə à pupoli tə dáá zənzən nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kʋ mʋ̀ tə yɩrɩ, Zwezi dun mɛ, sə tə súrí, wuuu, sə à mʋ̀ dun ga mun». ");
INSERT INTO nnw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Lìù tə nə nan Yɩɩ, wulə lɩ̀à tə mama yuu wa. Lìù tə, ʋ nə yɩ tɩran nə fwa, ʋ yɩ tɩa tə nə tɩ. Yá ʋ yàá swɩ̀n ndə lìù tə nə, ʋ nə yɩ tɩa nyiən. Lìù tə, ʋ nan Yɩɩ *sàń, ʋ wulə lɩ̀à tə mama yuu wa. ");
INSERT INTO nnw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Lìù təntə yàá swɩ̀n kʋ tə ba tə, ʋ nə nɩ də ʋ nə nì, ʋ bɩrɩ. Yá lìù mama ga ba ʋ sʋgʋ tə joŋə. ");
INSERT INTO nnw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lìù tə, ʋ nə sɛ̀e ʋ sʋgʋ, kʋ tíú bɩrɩ də, Yɩɩ ya cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Lìù tə, Yɩɩ nə tʋn, ʋ yàá swɩ̀n Yɩɩ sʋ̀ràn tə. Yá Yɩɩ yàá pa wá ʋ mʋ̀ Yɩɩ-*Siŋu tə zənzən. ");
INSERT INTO nnw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nə nyɩna Yɩɩ swə ʋ bìú tə. Yá ʋ ken won mama ʋ jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Lìù tə, ʋ nə keni ʋ waa Yɩɩ-Biu tə nə wuuu, ʋ jə mɩɩ tə, kʋ ba zwɛ̀e Yɩɩ con. Yá lìù tə, ʋ nə wà Yɩɩ-Biu tə nii zìlí, ʋ bá na mɩɩ. Yá Yɩɩ lɩŋa tə zaŋa ʋ yuu wa, máŋá mama». ");
INSERT INTO nnw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","*Farɩzɩan-ba nì də, Zwezi na karbɩa, ʋ doni Zwan. Ʋ ga li lɩ̀à də nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ, ʋ doni wá. Kʋ cɩ́gá yà tà Zwezi tətə nə li lɩ̀à tə nɩ́á wa. Kʋ yà yɩ ʋ karbɩa tə. *Yuu-Tiu nə lwarɩ kʋ, ʋ dàń zàn ʋ nan Zwide nagwanaa tə wa, ʋ va Galile nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yá Zwezi nə pɩ̀à, sə ʋ va Galile nagwanaa tə wa, kʋ yà mɛ, sə ʋ twá Samari nagwanaa wa ʋ lɛ. ");
INSERT INTO nnw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ʋ dàń vəli ʋ yí Samari nagwanaa tə tɩʋ don, ba nə boŋə ‹Sikarə›. Kʋ tɩʋ təntə yà bwələ də *Zwakɔbə kárá tə, ʋ nə pɩn ʋ bìú Zwʋzɛfə nə. ");
INSERT INTO nnw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Zwakɔbə vɩlɩ yà wulə kárá təntə wa. Zwezi vəli ʋ gwàrɩ̀. Ʋ dàń twi ʋ jə̀ə́ vɩlɩ tə nii nə. Kʋ máŋá təntə yà yɩ ndə yɩcaʋ lugu fugə bələ nə. ");
INSERT INTO nnw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Zwezi karbɩa tə mʋ̀ yà vəli tɩfarʋ tə wa, sə ba yə̀ wodiu. Samari tɩ̀án kan don twi, sə ʋ tan nɩ́á vɩlɩ tə wa. Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «À lòrì nɩ́á, sə à nyʋ!» ");
INSERT INTO nnw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kan tə ma le wá, ʋ wʋ́: «À mʋ̀ yɩ Samari tɩ̀án kan. Yá n mʋ̀ ga yɩ *Zwifə. Bɛ̀eɛ̀e nə pɩn, n ma lòrì nɩ́á à con, sə n nyʋ?» Zwifə-ba də Samari tɩ̀án yofwamɩnan yà tà nədʋ. Kʋ mʋ̀ nə pɩn, ʋ swɩ̀n nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Zwezi ma pìí ʋ le kan tə, ʋ wʋ́: «N yə̀rì won tə, kʋ nə yɩ Yɩɩ tarpɩʋn tə. Yá n yə̀rì lìù tə, ʋ nə lòrì, sə n pa wá nɩ́á, sə ʋ nyʋ. N yà nə yə̀ə́ kʋ tíú, n mʋ̀ yà nə wá lòrì nɩ́á ʋ con, sə n nyʋ. Yá ʋ wá pa mʋ́ nɩ́á, tə nə pɩn mɩɩ». ");
INSERT INTO nnw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kan tə ma kʋ́ʋ̀ swɩ̀n Zwezi con, ʋ wʋ́: «Yuu-Tiu, n dàń nə ba won jə, kʋ nə wàá nɩ́á kʋ taŋa. Yá vɩlɩ tə də də̀ń ma lù. N dàń wá na nɩ́á təntə yə̀n, tə nə pɩn mɩɩ? ");
INSERT INTO nnw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Vɩlɩ kʋ tə, yɩ nə nɩbɛɛ Zwakɔbə nə pɩn nəba. Ʋ tətə Zwakɔbə, də ʋ bɩa, də vàná tə mama, nyʋa kʋ nɩ́á. N bʋŋa də, n mʋ̀ nə dwə wá, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Zwezi ma kʋ́ʋ̀ le kan tə, ʋ wʋ́: «Lìù mama nə nyʋa vɩlɩ kʋ tə nɩ́á tə, nanyʋnɩ tə wá pìí kʋ ja wá. ");
INSERT INTO nnw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yá lìù nə nyʋa nɩ́á tə, à nə wá pa wá, nanyʋnɩ kʋ́ʋ̀ ba pìí kʋ ja kʋ tíú mama. Yá nɩ́á tə, à nə wá pa kʋ tíú nə, nɩ́á təntə wá jì nabuliyii ʋ waa, tə dəri wuuu, tə pɩn wá mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kan tə ma kʋ́ʋ̀ lòrì Zwezi, ʋ wʋ́: «Yuu-Tiu, pa nə nɩ́á təntə, sə nanyʋnɩ kʋ́ʋ̀ dàn ká pìí kʋ ja nə. Sə à kʋ́ʋ̀ dàn ká pìí à bà, à tan nɩ́á yəbə». ");
INSERT INTO nnw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Zwezi ma swɩ̀n kan tə con, ʋ wʋ́: «Vəli, n bon n barɩ, sə á bà yəbə!» ");
INSERT INTO nnw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kan tə le Zwezi, ʋ wʋ́: «À ba barɩ jə!» Zwezi ma kʋ́ʋ̀ swɩ̀n kan tə con, ʋ wʋ́: «N jə cɩ́gá, sə n swɩ̀n də, n ba barɩ jə. ");
INSERT INTO nnw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","N jɩn bara bonu. Yá n barɩ tə, n nə jə sɩ́ʋ́n nə, ʋ də tà n barɩ. N swɩ̀n cɩ́gá à con!» ");
INSERT INTO nnw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kan tə dàń ma swɩ̀n Zwezi con, ʋ wʋ́: «Yuu-Tiu, à na də, n yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀. ");
INSERT INTO nnw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nə nɩbara Samari tɩ̀án yà pɩn dun Yɩɩ nə paan ka tə yuu wa. Yá á mʋ̀ Zwifə-ba mʋ̀ bɩrɩ də, bwálɩ́ tə, ba nə mɛ, sə ba pa dun Yɩɩ nə, yɩ kʋ wulə *Zwerizalɛmə wa». ");
INSERT INTO nnw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Kan, pa cɩ́gá à sʋgʋ tə nə. Máŋá bɩ̀àn, kʋ máŋá təntə nə twi, lɩ̀à kʋ́ʋ̀ ba va paan ka tə yuu wa, sə ba pa dun Yɩɩ nə. Kʋ ma ba ya Zwerizalɛmə wa, nə á wá pa dun nyɩna Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Á mʋ̀ Samari tɩ̀án, á yə̀rì lìù tə, á nə pɩn dun wá. Nə mʋ̀ Zwifə-ba, nə yə̀ə́ lìù tə, nə nə pɩn dun wá. Lwarɩ də, Yɩɩ nə twá Zwifə-ba, ʋ ma joŋə ləzoni ba cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Máŋá bɩ̀àn. Yá kʋ máŋá tətə yí sɩ́ʋ́n. Yá cɩ́gá cɩ́gá lɩ̀à tə, ba nə pɩn dun Yɩɩ nə tə, dàń wá twá Yɩɩ-Siŋu tə də cɩ́gá nə, ba ma pa dun nyɩna Yɩɩ nə. Mə ba mʋ̀ Yɩɩ jʋ̀nà təntə yiri nə, nyɩna Yɩɩ pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yɩɩ yɩ Siŋu. Yá lɩ̀à tə, ba nə pɩn wá dun mɛ, sə ba pɩn wá dun, də Yɩɩ-Siŋu tə saŋʋ, də cɩ́gá mama». ");
INSERT INTO nnw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kan tə ma swɩ̀n Zwezi con, ʋ wʋ́: «À yə̀ə́ də Mesi tə, ba nə boŋə *Kərisə, wá bà. Ʋ nə twi, ʋ wá swɩ̀n tə mama yáá, ʋ bɩrɩ nəba». ");
INSERT INTO nnw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Zwezi ma swɩ̀n kan tə con, ʋ wʋ́: «À mʋ̀ nə yɩ kʋ lìù təntə tətə! À mʋ̀, à nə swɩ̀n n con». ");
INSERT INTO nnw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Máŋá don wa, Zwezi karbɩa tə dàń pìí ba bà. Kʋ dɩ̀gà ba yuu də, kʋ tə nə pɩn Zwezi swɩ̀n də kan tə. Ba lìù mama də wà Zwezi bwe, ʋ wʋ́: «Bɛ̀eɛ̀e nə n pɩ̀à kan tə con?» Nə à yə̀ə́: «Bɛ̀eɛ̀e yoo nə n swɩ̀n kan tə con?» ");
INSERT INTO nnw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kan tə dàń yá ʋ kwàrá tə, ʋ ga va tɩfarʋ tə wa, ʋ swɩ̀n lɩ̀à tə con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Á bɩ̀àn, á nə̀ń bɛɛ, ʋ nə swɩ̀n won tə mama, à nə fwa. Dɩɩn don, kʋ wá ya Kərisə nə». ");
INSERT INTO nnw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Samari tɩ̀án dàń nan ba tɩʋ tə wa, ba bà Zwezi con. ");
INSERT INTO nnw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kʋ twi kʋ yí máŋá don wa, Zwezi karbɩa tə yà wulə ba lòrì wá, ba wʋ́: «Karnyɩna, yá, sə n də́ wodiu!» ");
INSERT INTO nnw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «À jə wodiu, à nə də́. Yá á ga yə̀rì kʋ wodiu təntə». ");
INSERT INTO nnw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ʋ karbɩa tə dàń swɩ̀n duən con, ba wʋ́: «Mə kʋ nə yɩ lìù nə ja wodiu, ʋ bà ʋ pa wá, sə ʋ də́, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «À wodiu nə yɩ, sə à fwa kʋ tə nə yɩ lìù tə, ʋ nə tʋn nə, tə fɩra. À mɛ, sə à tʋn ʋ tʋtʋnan tə, à pa tə nii sú. ");
INSERT INTO nnw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Á tətə swɩ̀n də, kʋ ga cànɩ̀ banɩa, sə ba za wiən. À mʋ̀ swɩ̀n kʋ á con, á zɩan á yɩ́á á kə yɩɩ nə, á ga jə́n kárɩ́ tə nə pɩ̀rɩ̀ nətʋ, tə pɩ̀à zagʋ. ");
INSERT INTO nnw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lìù tə, ʋ nə za tə, ʋ də́ yáá ʋ na ʋ ŋwɩ́rán. Yá ʋ ga kəni wobɩa tə duən nə. Wobɩa tə, ʋ nə kəni duən yɩ lɩ̀à tə, Yɩɩ nə van ba, ʋ jon, sə ba na mɩɩ, kʋ nə ba zwɛ̀e ʋ con. Kʋ mʋ̀ nə wá pa wodùrú tə, də lìù tə nə za mɛ wá yà pupwən wa. ");
INSERT INTO nnw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kʋ mʋ̀ yɩrɩ nə, yoo kʋ tə, ba nə swɩ̀n tə, yɩ cɩ́gá: ‹Lìù yàá dù, ʋ don ga za›. ");
INSERT INTO nnw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","À tʋn aba, à pa á va á za kárá wiən, á ga wà ka wa tʋn mama. Lɩ̀à duən nə dí yáá ba tʋn ka wa. Á mʋ̀ yɩ tori nə, á tì tʋtʋŋɩ tə nywarɩ wa». ");
INSERT INTO nnw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kan tə bɩrɩ də, Zwezi swɩ̀n ʋ con, won tə mama, ʋ nə fwa. Kʋ mʋ̀ nə pɩn, Samari tɩ̀án zənzən nan tɩʋ tə wa, ba bà, ba kə ba waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ba tə twi Zwezi con, ba lòrì wá, sə ʋ ya də ba. Yá Zwezi fwa dɩan bələ ba con. ");
INSERT INTO nnw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lɩ̀à duən zənzən tə ken ba waa Zwezi nə, sʋ̀ràn tə yɩrɩ, ʋ mʋ̀ Zwezi tətə nə swɩ̀n ba con. ");
INSERT INTO nnw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ba dàń ma swɩ̀n kan tə con, ba wʋ́: «Kʋ kʋ́ʋ̀ tà n sʋ̀ràn tə nə pɩn, nə kə nə waa ʋ nə. Nə tətə dàń nì ʋ sʋ̀ràn tə. Kʋ mʋ̀ nə pɩn, nə yə̀ə́ cɩ́gá mama də, ʋ joŋə lɩ̀à mama ba cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Zwezi fwa dɩan bələ kʋ bwálɩ́ təntə wa. Kʋ kwa nə, ʋ zàn ʋ lɛ ʋ va Galile nagwanaa. ");
INSERT INTO nnw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Zwezi tətə nə swɩ̀n də, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ ba zìlə́ nɩ ʋ tətə nyɩna tɩʋ wa. ");
INSERT INTO nnw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yá Zwezi nə yí Galile, Galile tɩ̀án tə sɛ̀e, ba jon wá, ba də yà nə vəli *Zwerizalɛmə *Pakə cànà tə, ba ga na kʋ tə mama, ʋ nə tʋn kʋ cànà tə wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Zwezi kʋ́ʋ̀ pìí ʋ va Káná, kʋ nə wulə Galile nagwanaa tə wa. Mə kʋ mʋ̀ tɩʋ təntə wa nə, ʋ lwàń nɩ́á tə, ʋ pa tə jì divɛn. Pɩ̀ʋ́ don kwa lìù yà wulə Kapɛrənayimə nə, ʋ bìú yà nə yɩ̀. ");
INSERT INTO nnw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ʋ yà nì də, Zwezi nan Zwide nagwanaa tə wa, ʋ bà Galile. Ʋ dàń twi ʋ yí Zwezi yɩra, ʋ ga lòrì wá, ʋ wʋ́: «À lòrì mʋ́, sə n bà Kapɛrənayimə, n zwɛ̀e yayɩgʋ tə, kʋ nə pɩ̀à, kʋ gʋ à bìú tə». ");
INSERT INTO nnw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Máŋá mama, á nə wà Yɩɩ dɩ̀àn mɩmɩnan də yomɩlan nɩ, á ba sɛ̀e, á kəni á waa à nə». ");
INSERT INTO nnw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pɩ̀ʋ́ kwa lìù tə ma swɩ̀n Zwezi con, ʋ wʋ́: «*Yuu-Tiu, bà à sàń, də à bìú tə tə wà tɩ». ");
INSERT INTO nnw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Zwezi ma kʋ́ʋ̀ pìí ʋ le wá, ʋ wʋ́: «Vəli n sàń, n bìú tə wulə ʋ mɩɩ nə!» Bɛɛ tə pɩn cɩ́gá Zwezi sʋgʋ tə nə. Yá ʋ dàń ga lɛ, ʋ vìrí. ");
INSERT INTO nnw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Máŋá tə, ʋ nə tə wulə cwəŋə wa, ʋ ma vəli ʋ sàń, də ʋ tʋtʋnbɩa nə ba twi, ba jə́rí wá cwəŋə tə wa, ba swɩ̀n ʋ con, ba wʋ́: «N bìú tə nɩ yazurə, ʋ wulə ʋ mɩɩ nə». ");
INSERT INTO nnw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ʋ ma bwe ba, sə ʋ jə́n máŋá ka wa nə, ʋ nɩ yazurə. Ʋ tʋtʋnbɩa tə ma swɩ̀n ʋ con, ba wʋ́: «Dɩan dɩɩn tə dədəni nii lugu nədʋ máŋá wa nə, yalɩŋa tə dʋgʋ wá». ");
INSERT INTO nnw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bìú tə nyɩna tə dàń lwarɩ də, kʋ ya máŋá tə tətə wa, Zwezi nə swɩ̀n ʋ con də, ʋ bìú tə nɩ yazurə, ʋ wulə ʋ mɩɩ nə. Kʋ dàń pɩn ʋ mʋ̀ də ʋ dìə̀ lɩ̀à mama kə ba waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kʋ mʋ̀ Yɩɩ dɩ̀àn mɩmɩnʋ təntə, nə yɩ bələ nii nyiən, Zwezi nə fwa, də ʋ nə nan Zwide ʋ va Galile. ");
INSERT INTO nnw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kʋ kwa nə, *Zwifə-ba dí cànà don. Zwezi dàń ma zàn ʋ va *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Zwerizalɛmə wa, càrʋ́ yà wulə mimii don nii nə, ba nə boŋə kʋ mimii təntə ‹pabii mimii›. *Ebərə-ba sʋgʋ wa, ba yà jə càrʋ́ təntə, ba boŋə ‹Bɛtɛsəda›. Càrʋ́ təntə yà jə napakʋlan bonu. ");
INSERT INTO nnw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yayɩŋa kapʋpʋ, də lilirən, də gwanan, də kwanan yà nə tə́gə́ napakʋlan təntə wa. Ba yà tə́gə́ lá, ba dànɩ̀ də, càrʋ́ tə nɩ́á tə dwanɩ. ");
INSERT INTO nnw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Máŋá don wa, *malɩka yàá cú, ka dwanɩ nɩ́á tə. Lìù tə, ʋ nə dí yáá, ʋ zʋ nɩ́á tə wa, də tə nə dwan tə zwɛ̀e, kʋ tíú yàá na yazurə. Də ʋ yayɩgʋ tə nə swə, kʋ ya nətʋ mama. ");
INSERT INTO nnw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bɛɛ don də yà tə́gə́ lá də ʋ yayɩgʋ, kʋ nə jə bɩna fɩtwa də nana. ");
INSERT INTO nnw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zwezi yà dí yáá ʋ yə̀ə́ də, kʋ bɛɛ təntə nə yɩ̀ kʋ dánɩ́. Zwezi nə nɩ bɛɛ tə ʋ tə́gə́, ʋ bwe wá, ʋ wʋ́: «N pɩ̀à, sə n na yazurə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yayɩŋʋ tə ma le wá, ʋ wʋ́: «*Yuu-Tiu, à ba lìù jə, sə ʋ ja nə ʋ kə nɩ́á tə wa, máŋá tə wa, tə nə dwanɩ. Tə nə wulə tə dwanɩ, à nə pɩ̀à, sə à yí lá nə, də lìù don dí yáá, ʋ zʋ, də à tə wà yí». ");
INSERT INTO nnw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Zàn yɩɩ nə, n tì n sara tə, n vìí!» ");
INSERT INTO nnw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Naa nədʋ, də bɛɛ tə yayɩgʋ tə zwɛ̀e, ʋ zàn, ʋ tì ʋ sara tə, ʋ vìrí. Kʋ mʋ̀ yoo təntə yɩ, kʋ tʋn *Zwifə-ba *sìə́ dɩɩn nə. ");
INSERT INTO nnw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kʋ mʋ̀ nə pɩn, Zwifə-ba yun tɩ̀án tə dàń ma swɩ̀n bɛɛ tə, ʋ nə nɩ yazurə tə con, ba wʋ́: «Zə̀n dɩɩn tə yɩ sìə́ dɩɩn. Kʋ culə, sə n zɩn n sara tə!» ");
INSERT INTO nnw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bɛɛ tə ma pìí ʋ le ba, ʋ wʋ́: «Lìù tə, ʋ nə zwɛ̀e à yayɩgʋ tə, swɩ̀n à con, də à zàn, à tì à sara tə, à ga vìí». ");
INSERT INTO nnw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Zwifə-ba yun tɩ̀án tə dàń ma bwe wá, ba wʋ́: «Wàà nə yɩ kʋ lìù təntə, ʋ nə swɩ̀n n con də, n zàn, n tì n sara tə, n ga vìí?» ");
INSERT INTO nnw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yá bɛɛ tə, ʋ yayɩgʋ tə nə zwɛ̀e tə, də yà yə̀rì kʋ lìù tə, ʋ nə zwɛ̀e kʋ. Zwezi yà lɛ ʋ vìí lalʋʋ tə yɩrɩ, ba yà nə wulə kʋ bwálɩ́ tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kʋ kwa nə, Zwezi pìí ʋ na bɛɛ təntə Zwifə-ba Yɩɩ *dìə̀ tə wa, ʋ ma swɩ̀n ʋ con, ʋ wʋ́: «Cʋgʋ zəni, sɩ́ʋ́n nə n nɩ yazurə, n kʋ́ʋ̀ dàn ká pìí n tʋn cʋna, sə yoo don, kʋ nə dwə kʋ tə, kʋ́ʋ̀ dàn ká pìí, kʋ yí mʋ́». ");
INSERT INTO nnw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Bɛɛ tə dàń vəli, ʋ swɩ̀n Zwifə-ba yun tɩ̀án tə con də, kʋ ya Zwezi nə zwɛ̀e ʋ yayɩgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kʋ mʋ̀ yɩrɩ nə, Zwifə-ba yun tɩ̀án dàń zàn, ba zɩga Zwezi nə, kʋ nə yɩ ba sìə́ dɩɩn tə nə, ʋ fwa kʋ yoo təntə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Zwezi ma le ba, ʋ wʋ́: «À nyɩna Yɩɩ yɩ ʋ tʋŋa wuuu, də sɩ́ʋ́n mama, à də yɩ à tʋŋa». ");
INSERT INTO nnw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Zwezi sʋgʋ təntə kʋ́ʋ̀ súrí lá, kʋ pa Zwifə-ba yun tɩ̀án tə dàń kwɛn, ba pɩ̀à cwəŋə, sə ba gʋ wá. Kʋ tà ʋ nə cʋ̀gʋ̀ ba sìə́ dɩɩn tə cɩcɩ nə pɩn, ba pɩ̀à, ba gʋ wá. Kʋ yɩ ʋ nə kʋ́ʋ̀ swɩ̀n də, Yɩɩ nə ya ʋ nyɩlʋra tə yɩrɩ. Kʋ nətʋ pɩ̀à kʋ bɩrɩ də, ʋ jə ʋ tɩ̀àn, ʋ ma man də Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Zwezi dàń pìí ʋ swɩ̀n Zwifə-ba yun tɩ̀án tə con, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Yɩɩ-Biu tə wàrɩ̀ won mama ʋ fwa ʋ tɩ̀àn nə. Kʋ tə, Yɩɩ-Biu tə nə na, də ʋ nyɩna Yɩɩ fwa, ʋ də yàá fwa kʋ. ");
INSERT INTO nnw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yɩɩ swə ʋ bìú tə. Yá ʋ dàń yàá bɩrɩ wá kʋ tə mama, ʋ mʋ̀ Yɩɩ tətə nə fwa. Ʋ wá bɩrɩ tʋtʋnan, tə nə dwə tə tə, ʋ bìú tə nə, sə kʋ ma gwárɩ́ aba. ");
INSERT INTO nnw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kʋ yɩ cɩ́gá, à nyɩna Yɩɩ yàá bwin tɩga, ʋ pa ba mɩɩ. Kʋ mʋ̀ nə pɩn, Yɩɩ-Biu tə də pɩn mɩɩ lɩ̀à tə nə, ʋ nə pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kʋ tə súrí lá, à nyɩna Yɩɩ ba lìù mama bʋ̀rà bʋ̀rɩ̀. Ʋ yá bʋ̀rà tə mama ʋ bìú tə jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ʋ fwa kʋ nətʋ, sə lɩ̀à tə mama pa dun ʋ bìú tə nə, ndə ba nə pɩn dun nyɩna Yɩɩ nə. Nyɩna Yɩɩ nə tʋn bìú tə. Lìù tə, ʋ nə ba dun bìú tə nə pɩn, kʋ tíú ba dun pɩn nyɩna tə də nə. ");
INSERT INTO nnw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə, ʋ nə cʋga à sʋ̀ràn tə, ʋ ga kəni ʋ waa lìù tə nə, ʋ nə tʋn nə wuuu, kʋ tíú jə mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. Yá Yɩɩ bʋ̀rà tə, kʋ ba də́ wá. Ʋ yɩ ʋ twá də tɩan, ʋ ma na mɩɩ Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Máŋá bɩ̀àn, yá kʋ máŋá təntə yí sɩ́ʋ́n tətə. Tɩga tə də wá nì Yɩɩ-Biu tə kori. Yá ba tə, ba nə nì ʋ kori tə, ba ga sɛ̀e ʋ kori tə, ba wá na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndə nətʋ nyɩna Yɩɩ nə jə mɩɩ ʋ tətə jɩ̀àn wa, mə nətʋ nə ʋ pɩn ʋ bìú tə də jə mɩɩ ʋ jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yɩɩ ken dɩ̀àn ʋ bìú tə jɩɩn wa, sə ʋ bʋ̀rɩ̀ lɩ̀à bʋ̀rà, ʋ nə ya *Ləzwənə-Biu tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Máŋá don bɩ̀àn, á dànà ká pa yìə̀n tə tə dɩ̀ á yuu. Kʋ máŋá tə wa, lɩ̀à tə mama, ba nə wulə ləbərə wa, wá nì Ləzwənə-Biu tə kori. ");
INSERT INTO nnw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lɩ̀à tə nə tʋn zəni wá bwin ba nan, ba ya mɩɩ wa, kʋ nə ba zwɛ̀e Yɩɩ con. Ba tə də, ba nə tʋn lwanɩ, wá bwin ba nan, sə Yɩɩ bʋ̀rɩ̀ ba bʋ̀rà». ");
INSERT INTO nnw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kʋ kwa nə, Zwezi kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À mʋ̀ wàrɩ̀ won mama à fwa à tɩ̀àn nə, də kʋ nə tà kʋ tə, Yɩɩ nə bɩrɩ nə, sə à bʋ̀rɩ̀ kʋ bʋ̀rà. Yá à bʋ̀rà tə də ga yɩ cɩ́gá cɩcɩ. À pɩ̀à, sə à fwa lìù tə, ʋ nə tʋn nə tə fɩra. À ba pɩ̀à, sə à fwa à tətə fɩra. ");
INSERT INTO nnw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Də à tətə nə swɩ̀n à tɩ̀àn yoo, kʋ sʋgʋ tə bá lá nə də́. ");
INSERT INTO nnw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kʋ yɩ lìù don nə swɩ̀n à yoo ʋ bɩrɩ. À ga yə̀ə́ də, kʋ tə, ʋ nə swɩ̀n à yuu wa, yɩ cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Á tʋn lɩ̀à Zwan con, ʋ də swɩ̀n cɩ́gá tə, ʋ bɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","À mʋ̀ tà ləzwənə nə mɛ, sə ba swɩ̀n à yoo. À swɩ̀n yoo kʋ tə, sə kʋ jon aba á cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zwan yɩ ndə cànʋ́ nə, kʋ poni nə pɩ̀rɩ̀ aba. Kʋ mʋ̀ nə pɩn, á sɛ̀e, á poli á pùə́ də wá, máŋá mancɩn wa. ");
INSERT INTO nnw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kʋ tə Zwan nə swɩ̀n à yuu wa, yoo wulə kʋ nə dwə kʋ. À nyɩna Yɩɩ pɩn nə tʋtʋnan, sə à tʋn. Tə tʋtʋnan tə, à nə tʋŋa nə bɩrɩ də, kʋ ya nyɩna Yɩɩ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nyɩna Yɩɩ tə, ʋ nə tʋn nə, yə̀ə́ kʋ tə, à nə yɩ. Á tə wà ʋ kori nì, mama. Á ga tə wà ʋ yáá nɩ á yii wa. ");
INSERT INTO nnw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Lìù tə, Yɩɩ nə tʋn, á wà á waa ken kʋ tíú nə. Kʋ mʋ̀ nə pɩn, á ba ʋ sʋgʋ tə sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Á kàrɩ̀ kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, á ma pɩ̀à mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. Kʋ Yɩɩ sagɩ təntə nə bɩrɩ kʋ tə, à nə yɩ. ");
INSERT INTO nnw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yá á ba pɩ̀à, sə á bà à con, sə á na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","À mʋ̀ ba pɩ̀à, sə ləzoni nə pa dun nə. ");
INSERT INTO nnw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","À yə̀ə́ aba də, á ba Yɩɩ sonu tə jə. ");
INSERT INTO nnw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","À mʋ̀ twi lʋʋ wa à nyɩna Yɩɩ yuu yɩrɩ, yá á wà nə sɛ̀e. Yá lìù don nə twi lʋʋ wa ʋ tətə yuu yɩrɩ, á wá sɛ̀e kʋ tíú. ");
INSERT INTO nnw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Á dun yɩ á tətə nə pɩn duən nə, á ga kʋ́ʋ̀ ba dun tə, Yɩɩ cɩcɩ nə wá pa aba, pɩ̀à. Kʋ mʋ̀ nə pɩn, á kʋ́ʋ̀ ba á waa kəni Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Á dànà ká bʋ́n də, à mʋ̀ nə wá kə talɩ á yuu wa, à nyɩna Yɩɩ yáá con. Á ja yala *Moyizə nə. Ʋ mʋ̀ Moyizə nə wá kə talɩ á yuu wa. ");
INSERT INTO nnw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kʋ yɩ à mʋ̀ yoo Moyizə pʋ́pʋ́nɩ́. Á yà nə kəni á waa Moyizə nə, á yà wá kə á waa à də nə wuuu. ");
INSERT INTO nnw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Á wà cɩ́gá pɩn kʋ tə, Moyizə nə pʋ́pʋ́nɩ́ tə nə. Kʋ mʋ̀ nə pɩn, á bá cɩ́gá à də sʋgʋ tə nə pɩn». ");
INSERT INTO nnw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kʋ kwa nə, Zwezi zàn, ʋ va Galile mʋnaa tə vàn tə don nə. Mʋnaa təntə yɩrɩ don yà nə yɩ ‹Tiberiyadə mʋnaa›. ");
INSERT INTO nnw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lalʋʋ tə nɩ Yɩɩ dɩ̀àn mɩmɩnan tə, Zwezi nə fwa. Ʋ yàá zwɛ̀e yayɩŋa tə yayɩran. Kʋ mʋ̀ nə pɩn, lɩ̀à zənzən yà púə́ ʋ kwa. ");
INSERT INTO nnw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zwezi də ʋ karbɩa tə dɩ̀gà, ba jə̀ə́ paan yuu wa. ");
INSERT INTO nnw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kʋ máŋá tə wa, də *Zwifə-ba cànà tə, ba nə boŋə ‹*Pakə› tə bwələ. ");
INSERT INTO nnw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Zwezi zɩ̀n ʋ yáá, sə ʋ ywàń, də nə̀ń lalʋʋ nə, kʋ bɩ̀àn ʋ con. Ʋ ma swɩ̀n Filipə con, ʋ wʋ́: «Nə wá na dipɛn yə̀n, nə yə̀, nə pa lɩ̀à ba tə mɛ də́?» ");
INSERT INTO nnw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Zwezi nə swɩ̀n kʋ nətʋ Filipə con, kʋ ga yɩ, sə ʋ ma ja Filipə də̀ń nə, ʋ tətə yà yə̀ə́ kʋ tə, ʋ nə wá fwa. ");
INSERT INTO nnw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipə ma le wá, ʋ wʋ́: «Nə nə yə̀ dipɛn cɩnɩa səbikʋlan biələ (200) də tətə, ba lìù mama wàrɩ̀ dipɛn kuku ʋ nɩ». ");
INSERT INTO nnw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Zwezi karbiu tə don, ba nə boŋə Andəre, ʋ nə yɩ Simon Piyɛrə nubiu, dàń ma le Zwezi, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Dipɛn bonu, ba nə fwa də ɔrəzə mun, də fələ bələ nə wulə bisɩmabara don con yəbə. Kʋ bɩrɩ də, tə yɩ ndə tʋtʋ nə, lɩ̀à zənzən ba tə yáá con». ");
INSERT INTO nnw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Gaʋ yà dáá kʋ bwálɩ́ təntə wa. Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Á pɩan lɩ̀à tə mama jə̀ń tɩa». Bara tə yí ndə mʋ̀rʋ̀ bonu (5 000) nə, ba nə mɛ tɩa ba jə̀ə́. ");
INSERT INTO nnw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Zwezi tì dipɛn tə, ʋ ga kə Yɩɩ lɛ̀eɛ̀e. Ʋ nə kən Yɩɩ lɛ̀eɛ̀e ʋ zwɛ̀e, ʋ tàrɩ̀ ba də tə, ʋ ga tàrɩ̀ fələ tə, də ʋ pa ba. Ba lìù tə mama, ʋ nə jə̀ń tɩa, ʋ nɩ tori, ndə ʋ nə pɩ̀à nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Máŋá tə wa, ba mama nə dí ba sú, Zwezi swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á pɛ̀egà dipɛn mumunə tə, tə nə gá tə, sə tə won mama dàn ká jén». ");
INSERT INTO nnw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Zwezi karbɩa tə pɛ̀e dipɛn mumunə tə. Tə súə́ fɩyaran fugə bələ. Kʋ ga yɩ dipɛn bonu tə, lɩ̀à tə nə dí, ba gá. ");
INSERT INTO nnw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lɩ̀à tə nə nɩ Yɩɩ dɩ̀àn mɩmɩnʋ təntə, Zwezi nə fwa, ba swɩ̀n, ba wʋ́: «Cɩ́gá mama, bɛɛ wà tə nə yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə, ʋ nə mɛ, sə ʋ bà lʋʋ wa». ");
INSERT INTO nnw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Zwezi lwarɩ də, ba wá bà, ba ja wá dɩ̀àn yuu wa, sə ba ma fwa ba pɩ̀ʋ́. Ʋ kʋ́ʋ̀ zàn ʋ kwɛn ʋ fàrɩ́, ʋ va paan tə yuu, ʋ cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kʋ dədəni nii nə, Zwezi karbɩa tə vəli, ba nan mʋnaa tə nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ba zʋa nɩ́á yuu bori wa, sə ba bɛn, ba va Kapɛrənayimə. Kʋ tɩʋ tə wulə mʋnaa tə kwa. Tɩa yà bəbəri ka zwɛ̀e, də Zwezi tə wà ba con vəli, ʋ yí. ");
INSERT INTO nnw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Vʋʋ dàń nyɩ́ kʋ zàn, kʋ fuli də dɩ̀àn. Mʋʋ tə nɩ́á dàń ga zaŋa yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Zwezi karbɩa tə ye nɩ́á tə, kʋ yí ndə kilomɛtərə bonu, nə à yə̀ə́ bardʋ. Kʋ máŋá tə wa, ba dàń nɩ Zwezi, də ʋ vəli nɩ́á tə yuu wa, ʋ ma bɩ̀àn ba nɩ́á yuu bori tə con. Fən dàń yà zʋa ba. ");
INSERT INTO nnw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Zwezi swɩ̀n ba con, ʋ wʋ́: «Kʋ ya à mʋ̀ nə, á dànà ká pa fən ja aba!» ");
INSERT INTO nnw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ba yà pɩ̀à ba tì wá, ba kə nɩ́á yuu bori tə wa. Kʋ máŋá tə wa, də nɩ́á yuu bori tə dwen bəbəru tə yɩra, bwálɩ́ tə nə, ba yà nə vəli tə. ");
INSERT INTO nnw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kʋ tɩpʋrɩ nə, lalʋʋ, kʋ yà nə wulə bəbəru tə don tə nə, lwarɩ də nɩ́á yuu bori nədʋ nə wulə lá. Ba lwarɩ də, Zwezi wà ʋ karbɩa tə nɩ́á yuu bori tə wa zwɩ, kʋ yɩ ba cɩcɩ nə vìí. ");
INSERT INTO nnw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nɩ́á yuu bwərə duən nan Tiberiyadə, tə bà tə yí bwálɩ́ tə nə, ba nə dí dipɛn tə, Yuu-Tiu Zwezi nə kən Yɩɩ lɛ̀eɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lalʋʋ tə lwarɩ də, Zwezi də ʋ karbɩa tə tə̀lə́ lá, ba dàń zʋa nɩ́á yuu bwərə təntə wa, ba vəli Kapɛrənayimə, sə ba pɩ̀à Zwezi. ");
INSERT INTO nnw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lalʋʋ tə vəli, kʋ na Zwezi mʋnaa tə bəbəru tə don nə. Ba ma bwe wá, ba wʋ́: «Karnyɩna dədwə nə n twi yəbə?» ");
INSERT INTO nnw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Zwezi le ba, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ tà á nə nɩ Yɩɩ dɩ̀àn mɩmɩnan tə, nə pɩn á twá lá á pɩ̀à nə. Kʋ ya dipɛn tə, á nə dí á sú, tə nə pɩn, á twá lá á pɩ̀à nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Á dànà ká tʋn wodiu cɩcɩ yɩrɩ, kʋ nə wàá kʋ cʋ̀gà. Á tʋŋa wodiu tə yɩrɩ, kʋ nə wulə wuuu, kʋ ga pɩn mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. *Ləzwənə-Biu tə nə wá pa aba kʋ wodiu təntə. À nyɩna Yɩɩ pɩn ʋ nii tə nə, sə à tʋn à pa wá». ");
INSERT INTO nnw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ba ma bwe Zwezi, ba wʋ́: «Bɛ̀eɛ̀e nə nə mɛ, sə nə fwa, sə nə ma tʋn tʋtʋnan tə, Yɩɩ nə swə?» ");
INSERT INTO nnw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Zwezi le ba, ʋ wʋ́: «Won tə, kʋ nə ya Yɩɩ tʋtʋŋɩ tə, ʋ nə swə, kʋ mʋ̀ nə yɩ, sə á kə á waa lìù tə nə, ʋ mʋ̀ Yɩɩ nə tʋn». ");
INSERT INTO nnw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ba dàń swɩ̀n ʋ con, ba wʋ́: «Bɛ̀eɛ̀e Yɩɩ dɩ̀àn mɩmɩnan nə, n wá fwa, n bɩrɩ nəba, sə kʋ pa, nə kə nə waa n nə? Bɛ̀eɛ̀e tʋtʋŋɩ nə n wá tʋn? ");
INSERT INTO nnw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kʋ máŋá ba yigə, nə nɩbara-ba tə yɩn kasɔɔ lanworu tə wa. Kʋ bwálɩ́ təntə wa, ba dí wodiu, ba nə boŋə ‹manə›. Kʋ tʋn, ndə kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ‹Yɩɩ pɩn, wodiu nan Yɩɩ sàń nə, kʋ bà, kʋ pa ba, ba də́›.» ");
INSERT INTO nnw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Zwezi ma le ba, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Kʋ tà *Moyizə nə pɩn aba dipɛn tə, kʋ nə nan Yɩɩ sàń tə. Kʋ ya à nyɩna Yɩɩ nə pɩn aba cɩ́gá cɩ́gá dipɛn tə, kʋ nə nan Yɩɩ sàń kʋ bà. ");
INSERT INTO nnw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dipɛn tə, Yɩɩ nə pɩn, kʋ mʋ̀ nə yɩ lìù tə, ʋ nə nan Yɩɩ sàń ʋ cú. Ʋ mʋ̀ nə pɩn mɩɩ ləzoni nə». ");
INSERT INTO nnw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lɩ̀à dàń swɩ̀n Zwezi con, ba wʋ́: «*Yuu-Tiu, pa nəba wodiu təntə dɩɩn mama!» ");
INSERT INTO nnw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Zwezi dàń ma swɩ̀n ʋ bɩrɩ ba, ʋ wʋ́: «À mʋ̀ nə yɩ wodiu tə, kʋ nə pɩn mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. Lìù tə, ʋ nə twi à con, niən kʋ́ʋ̀ bá ja kʋ tíú mɩ́ámɩ́án. Lìù tə, ʋ də nə ken ʋ waa à nə, nanyʋnɩ kʋ́ʋ̀ bá ja kʋ tíú mɩ́ámɩ́án. ");
INSERT INTO nnw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","À dàń swɩ̀n kʋ á con, á nɩ nə də, yá á tə ba á waa kəni à nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Lɩ̀à tə mama, à nyɩna Yɩɩ nə pɩn nə, wá bà à con. Yá lìù tə, ʋ nə twi à con, à bá vàrɩ̀ kʋ tíú à dʋgʋ, abada. ");
INSERT INTO nnw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kʋ tà à nan Yɩɩ à cú, sə à tʋn à tətə fɩra. Kʋ yɩ, sə à tʋn lìù tə, ʋ nə tʋn nə, fɩra. ");
INSERT INTO nnw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Á dàń nəŋə, kʋ tə nə yɩ lìù tə, ʋ nə tʋn nə tə, fɩra. Ʋ ba pɩ̀à, sə lɩ̀à tə mama, ʋ nə pɩn nə, tə ladʋa tətə jén. Kʋ ya ʋ pɩ̀à, sə à bwin ba mama, à zɩ̀n tɩan wa, à kə mɩɩ tə wa, kʋ nə ba zwɛ̀e ʋ con, lʋʋ zaŋʋ máŋá nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","À nyɩna Yɩɩ fɩra nə ya kʋ tə nətən. Ʋ pɩ̀à, sə lìù tə mama, ʋ nə nɩ Yɩɩ-Biu tə, ʋ ga kə ʋ waa ʋ nə, sə kʋ tíú na mɩɩ tə, kʋ nə ba zwɛ̀e ʋ con. Yá à wá bwin wá, à zɩ̀n tɩan wa, à kə mɩɩ tə wa, kʋ nə ba zwɛ̀e Yɩɩ con, lʋʋ zaŋʋ máŋá nə». ");
INSERT INTO nnw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","*Zwifə-ba yun tɩ̀án ŋʋŋwɩn Zwezi yoo duən con, də ʋ nə swɩ̀n, ʋ wʋ́: «À mʋ̀ yɩ wodiu, kʋ nan Yɩɩ sàń kʋ cú». ");
INSERT INTO nnw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba dàń swɩ̀n, ba wʋ́: «Kʋ tà Zwezi, ʋ nə yɩ Zwʋzɛfə bìú tə, naaa? Nə yə̀ə́ ʋ nuu də ʋ nyɩna. Bɛ̀eɛ̀e nə pɩn, ʋ ma kʋ́ʋ̀ pìí ʋ swɩ̀n də, ʋ yɩ ʋ nan Yɩɩ sàń, ʋ bà?» ");
INSERT INTO nnw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Zwezi ma le ba, ʋ wʋ́: «Á dànà ká ŋʋŋwɩn duən con! ");
INSERT INTO nnw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lìù mama wàrɩ̀ à con ʋ twi, də à nyɩna Yɩɩ tə, ʋ nə tʋn nə tə, nə wà kʋ tíú van, ʋ pa nə, sə à bwin wá à zɩ̀n tɩan wa, lʋʋ zaŋʋ máŋá nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kʋ pʋ́pʋ́nɩ́ Yɩɩ nii *sʋ̀sʋ̀nʋ̀ saga tə wa, kʋ wʋ́: ‹Yɩɩ nə wá kàrɩ̀ ba mama›. Lìù tə mama, ʋ nə cʋgʋ à nyɩna Yɩɩ sʋgʋ tə, ʋ ga sɛ̀e ʋ kàrà tə, ʋ wá bà à con. ");
INSERT INTO nnw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kʋ nətʋ ba pɩ̀à kʋ bɩrɩ də, lìù don nɩ à nyɩna Yɩɩ. Kʋ yɩ lìù tə, ʋ nə nan Yɩɩ con, ʋ mʋ̀ nə nɩ à nyɩna Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə, ʋ nə ken ʋ waa à mʋ̀ nə, ʋ jə mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","À mʋ̀ nə yɩ wodiu tə, kʋ nə pɩn mɩɩ ləzwənə nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Á nɩbara-ba tə dí wodiu tə, ba nə boŋə ‹manə›, kasɔɔ lanworu tə wa, yá ba tɩga. ");
INSERT INTO nnw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yá wodiu tə, kʋ nə nan Yɩɩ sàń, kʋ cú tə, kʋ mʋ̀ ya yiri don. Lìù tə, ʋ nə dí kʋ, ʋ kʋ́ʋ̀ bá tɩ. ");
INSERT INTO nnw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","À mʋ̀ yɩ wodiu tə, kʋ nə pɩn mɩɩ, kʋ nə nan Yɩɩ sàń kʋ cú. Lìù tə, ʋ nə dí kʋ wodiu təntə, ʋ wá yà mɩɩ wa, kʋ nə ba zwɛ̀e Yɩɩ con, abada. À yɩra tə nə yɩ wodiu təntə, à nə wá pa, sə ləzoni na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Zwifə-ba yun tɩ̀án tʋ́tʋ̀nɩ́ duən, kʋ yoo təntə yɩrɩ, ba swɩ̀n, ba wʋ́: «Kʋ wá twá nətə, sə bɛɛ wà tə ma pa nəba ʋ yɩra tə, nə də́?» ");
INSERT INTO nnw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Də á nə wà *Ləzwənə-Biu tə yɩra tə dí, á nə wà à jana tə nywɩ̀n, á ba mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con, tə jə á tɩ̀àn nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lìù tə, ʋ nə dí à yɩra tə, ʋ nə nyʋa à jana tə, ʋ jə mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. Yá à wá bwin wá à zɩ̀n tɩan wa, á kə mɩɩ wa, kʋ nə ba zwɛ̀e, lʋʋ zaŋʋ máŋá nə. ");
INSERT INTO nnw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","À yɩra tə yɩ cɩ́gá cɩ́gá wodiu. Yá à jana tə də yɩ cɩ́gá cɩ́gá nanywɩa. ");
INSERT INTO nnw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Lìù tə, ʋ nə dí à yɩra tə, ʋ ga nyʋ à jana tə, kʋ tíú wulə də nə, à də ga wulə də wá. ");
INSERT INTO nnw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","À nyɩna Yɩɩ nə tʋn nə. Ʋ mʋ̀ nə jə mɩɩ. Kʋ mʋ̀ nə pɩn, à twá də wá, à də ma jə mɩɩ. Yá lìù tə, ʋ nə dí nə, ʋ də wá twá nə ʋ jə mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nə̀ń, wodiu təntə, kʋ nə nan Yɩɩ sàń kʋ cú, tə də̀ń nə. Kʋ wodiu təntə ba yɩ ndə wodiu tə, à nɩbara-ba nə dí, yá ba tə ga tɩ tə. Lìù tə, ʋ nə dí wodiu təntə, ʋ wá yà mɩɩ wa, kʋ nə ba zwɛ̀e Yɩɩ con, abada». ");
INSERT INTO nnw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Zwezi swɩ̀n sʋ̀ràn təntə, máŋá tə wa, ʋ nə wulə Kapɛrənayimə nə, Zwifə-ba *jə́rə́ dìə̀ tə wa, ʋ kàrɩ̀. ");
INSERT INTO nnw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Zwezi karbɩa tə cʋgʋ ʋ sʋ̀ràn tə, ba zwɛ̀e. Kʋ kwa nə, ba zʋnɩ swɩ̀n, ba wʋ́: «Kàrà ka tə dà ka lɛ, lìù mama wàrɩ̀ ka tə n sɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Zwezi yà yə̀ə́ ʋ waa con də, ʋ karbɩa tə ŋʋŋwɩn yoo təntə yɩra. Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Kʋ yoo təntə gwàrɩ̀ á vànà, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Sə á dàń nə nɩ *Ləzwənə-Biu tə, də ʋ ma dɩ̀ bwálɩ́ tə nə, ʋ ya nə wulə, kʋ wá yà nətə kʋ pa aba? ");
INSERT INTO nnw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kʋ ya Yɩɩ-*Siŋu tə nə pɩn mɩɩ ləzwənə nə. Ləzwənə dɩ̀àn mʋ̀ ya tʋtʋ. Sʋ̀ràn tə, à nə swɩ̀n á con, tə mʋ̀ nə yɩ Yɩɩ-Siŋu tə, tə mʋ̀ ga nə yɩ mɩɩ tə. ");
INSERT INTO nnw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lɩ̀à duən wulə á tətəŋi wa, ba nə ba ba waa kəni à nə». Zwezi yà dí yáá, ʋ yə̀ə́ lɩ̀à tə, ba nə wà ba waa ken ʋ nə. Ʋ yà dí yáá, ʋ yə̀ə́ lìù tə, ʋ nə wá ja ʋ mʋ̀, ʋ pa. ");
INSERT INTO nnw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ʋ tə bwé ʋ swɩ̀n, ʋ wʋ́: «Mə kʋ mʋ̀ nə pɩn, à ma swɩ̀n á con də, lìù mama wàrɩ̀ à con ʋ twi, də à nyɩna Yɩɩ nə wà cwəŋə pɩn kʋ tíú nə». ");
INSERT INTO nnw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kʋ nə mɛ, kʋ máŋá təntə wa, ʋ karbɩa tə zʋnɩ pìí ba yá wá, ba kʋ́ʋ̀ ba ʋ nə twá. ");
INSERT INTO nnw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Zwezi ma swɩ̀n karbɩa fugə bələ tə con, ʋ wʋ́: «Á mʋ̀ ba pɩ̀à, sə á vìí naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piyɛrə ma le wá, ʋ wʋ́: «*Yuu-Tiu, wàà con nə, nə wá pìí nə va? N mʋ̀ nə jə sʋ̀ràn tə, tə nə pɩn mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yá nə mʋ̀ ken nə waa n nə, nə ga yə̀ə́ də, n mʋ̀ nə yɩ lìù tə, n nə yɩ Yɩɩ nə tɩ». ");
INSERT INTO nnw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Zwezi le ba, ʋ wʋ́: «Kʋ tà à mʋ̀ nə kúrí á mʋ̀ lɩ̀à fugə bələ tə mɛ, naaa? Kʋ ya nətʋ, yá á wa lìù don yɩ *Sɩtana». ");
INSERT INTO nnw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kʋ yà yɩ Zwidasə Yisəkariyɔtə, ʋ nə yɩ Simon bìú tə, yoo nə, Zwezi yà swɩ̀n nətʋ. Karbɩa fugə bələ tə wa, mə ʋ mʋ̀ Zwidasə tə, nə wá ja Zwezi, ʋ pa. ");
INSERT INTO nnw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kʋ mʋ̀ təntə kwa nə, Zwezi yàá jijiri Galile nagwanaa tə wa. *Zwifə-ba yun tɩ̀án pɩ̀à wá, sə ba gʋ. Kʋ mʋ̀ nə pɩn, ʋ yà kʋ́ʋ̀ ba pɩ̀à, sə ʋ jijirə Zwide nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kʋ máŋá tə wa, də Zwifə-ba cànà tə, ba nə boŋə ‹silə cànà›, tə bwələ. ");
INSERT INTO nnw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Zwezi nyáná tə dàń ma swɩ̀n ʋ con, ba wʋ́: «Nan yəbə! N va Zwide, sə n karbɩa tə wànɩ́ ba na yìə̀n tə, n nə tʋŋa. ");
INSERT INTO nnw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Lìù tə, ʋ nə pɩ̀à, sə ba lwarɩ kʋ tə, ʋ nə yɩ, ʋ ba ʋ yìə̀n sə̀gə̀ ʋ fwa. Yìə̀n tə tə, n nə tʋŋa nətən, n dàń tʋn tə, sə lɩ̀à mɛ na mʋ́». ");
INSERT INTO nnw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ʋ nyáná tə sʋgʋ təntə bɩrɩ də, ba wà ba waa ʋ nə ken. ");
INSERT INTO nnw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Zwezi ma swɩ̀n ba con, ʋ wʋ́: «À mʋ̀ máŋá tə wà yí. Á mʋ̀ con nə, máŋá mama ziən, ka pa aba. ");
INSERT INTO nnw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ, wàrɩ̀ á mʋ̀ ba dʋŋa. À mʋ̀ swɩ̀n də, ba tʋtʋnɛɛ tə ba ziən. Kʋ mʋ̀ nə pɩn, ba dʋŋa nə. ");
INSERT INTO nnw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Á mʋ̀ vəli cànà tə! À mʋ̀ tə ba cànà təntə vəli sɩ́ʋ́n, à máŋá tə wà yí». ");
INSERT INTO nnw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ʋ swɩ̀n sʋ̀ràn təntə ba con. Yá ʋ pìí ʋ wulə Galile nə. ");
INSERT INTO nnw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Zwezi nyáná tə vəli cànà tə. Kʋ kwa nə, ʋ də tətə zàn ʋ va lá. Ʋ nə vəli tə, ʋ sə̀gə̀ ʋ tɩ̀àn. Ʋ wà ʋ tɩ̀àn bɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","*Zwifə-ba yun tɩ̀án yà twá lá, ba pɩ̀à Zwezi cànà tə wa, də ba bwe, ba wʋ́: «Ʋ wa yə̀n nə?» ");
INSERT INTO nnw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lalʋʋ tə sʋsʋnɩ duən nə zənzən ba tətəŋi wa, ʋ yuu wa. Ba duən swɩ̀n, ba wʋ́: «Ʋ yɩ bɛɛ tə, ʋ nə tʋŋa zəni». Ba duən də kʋ́ʋ̀ wʋ́: «Ɔn ɔn! Kʋnkʋn nə! Ʋ mʋ̀ nə pɩn lalʋʋ tə gugurə». ");
INSERT INTO nnw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Fən yà jə lɩ̀à tə, Zwifə-ba yun tɩ̀án tə yɩrɩ. Kʋ mʋ̀ nə pɩn, ba lìù də mama yà ba Zwezi yoo swɩ̀n nəpon nəpon ʋ nii wa. ");
INSERT INTO nnw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Máŋá tə, cànà tə nə zʋa ka tətəŋi wa, Zwezi zàn ʋ va *Zwifə-ba Yɩɩ *dìə̀ tə wa. Ʋ wulə ʋ kàrɩ̀ lɩ̀à tə. ");
INSERT INTO nnw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kʋ gwárɩ́ Zwifə-ba yun tɩ̀án tə, ba ga swɩ̀n, ba wʋ́: «Bɛɛ ʋ tə wà kàrɩ̀. Kʋ dàń nə fwa nətə, ʋ ma yə̀ə́ Yɩɩ sagɩ tə zəni zəni?» ");
INSERT INTO nnw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Zwezi le ba, ʋ wʋ́: «Kàrà tə à nə kàrɩ̀, kʋ tà kʋ nan à tətə. Kʋ yɩ kʋ nan Yɩɩ tə, ʋ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Lìù tə, ʋ nə sɛ̀e, sə ʋ tʋn Yɩɩ fɩra, kʋ tíú wá lwarɩ, à kàrà kʋ tə nə nan Yɩɩ, nə à yə̀ə́ də kʋ nə yɩ à tətə sʋ̀ràn. ");
INSERT INTO nnw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Lìù tə, ʋ sʋ̀ràn nə naŋa ʋ tətə, kʋ yɩ ʋ pɩ̀à, sə ʋ pa dun ʋ tətə nə. Yá lìù tə, ʋ nə pɩ̀à, sə ʋ pa dun lìù don nə, kʋ tíú nə tʋn wá, ʋ yàá swɩ̀n cɩ́gá. Yá kʋnkʋn yoo tə̀lə́ də wá. ");
INSERT INTO nnw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","*Moyizə nə pɩn aba Yɩɩ *nii tə. Yá á lìù mama ba kʋ nii zìlí. Bɛ̀eɛ̀e dàń nə pɩn, á pɩ̀à, sə á gʋ nə?» ");
INSERT INTO nnw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lalʋʋ tə le wá, kʋ wʋ́: «N yɩ *zinə nə jə mʋ́! Wàà nə pɩ̀à, sə ʋ gʋ mʋ́?» ");
INSERT INTO nnw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zwezi kʋ́ʋ̀ le ba, ʋ wʋ́: «À tʋn yoo nədʋ, kʋ ga gwárɩ́ á mama. ");
INSERT INTO nnw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyizə pɩn aba nii, sə á *gwəŋə bɛɛ. Ʋ pɩn kʋ nii təntə, kʋ ga tà ʋ mʋ̀ nə dɩga ka gwəŋə tə də̀ń. Kʋ yɩ kʋ nan də á nɩbara-ba. Yá á gwəŋə bɛɛ Zwifə-ba *sìə́ dɩɩn tə də tətə nə. ");
INSERT INTO nnw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Á gwəŋə lìù sìə́ dɩɩn tə nə, sə á dànà ká cʋ̀gʋ̀ Yɩɩ nii tə, ʋ nə pɩn Moyizə nə. Bɛ̀eɛ̀e nə pɩn, á lɩŋa zaŋa à yuu wa, də à nə pɩn ləzwənpɩrɩ nə yazurə sìə́ dɩɩn nə? ");
INSERT INTO nnw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Á dànà ká ywàń də yɩ́á, á ma bʋ̀rɩ̀ bʋ̀rà. Á nə wá bʋ̀rɩ̀ bʋ̀rà, sə á pa kʋ twá də cɩ́gá». ");
INSERT INTO nnw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","*Zwerizalɛmə tɩ̀án duən swɩ̀n, ba wʋ́: «Kʋ tà bɛɛ wà tə nə, ba pɩ̀à, sə ba gʋ tə, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nə̀ń, ʋ nə ʋ zɩga ʋ swɩ̀n ʋ fɩra lɩ̀à tə mama yáá con, ba ga ba yoo mama ʋ con swɩ̀n. Yá nə yun tɩ̀án tə lwarɩ də, ʋ mʋ̀ nə yɩ lìù tə, ʋ nə yɩ *Kərisə tə cɩ́gá mama, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lìù tə, ʋ nə yɩ Kərisə, wá bà. Ʋ nə twi, lìù mama bá yəni bwálɩ́ tə, ʋ nə nan. Yá kʋ nə yɩ bɛɛ wà tə mʋ̀, nə yə̀ə́ bwálɩ́ tə, ʋ nə nan». ");
INSERT INTO nnw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Máŋá tə wa, Zwezi nə wulə ʋ kàrɩ̀ *Zwifə-ba Yɩɩ *dìə̀ tə wa, ʋ swɩ̀n ʋ kə yɩɩ nə, ʋ wʋ́: «Á bʋŋa də, á yə̀ə́ nə? Á yə̀ə́ à nə nan lá, cɩ́gá mama, naaa? À tətə nə wà lʋʋ twi à tɩ̀àn nə, kʋ ya lìù nə tʋn nə. Á yə̀rì lìù tə, ʋ nə tʋn nə. Kʋ lìù təntə nə yɩ cɩ́gá tíú. ");
INSERT INTO nnw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mə ʋ mʋ̀ con nə, à nan. Ʋ mʋ̀ nə tʋn nə. Kʋ mʋ̀ nə pɩn, à mʋ̀ yə̀ə́ wá». ");
INSERT INTO nnw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zwezi nə swɩ̀n kʋ nətʋ tə, ba dàń pɩ̀à, sə ba ja wá. Yá ba lìù mama jɩ̀àn wà ʋ yɩra dwən. Máŋá tə wà yí, sə ba ja wá. ");
INSERT INTO nnw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lalʋʋ tə wa, lɩ̀à zənzən ken ba waa ʋ nə, ba ga swɩ̀n, ba wʋ́: «Kərisə tə nə twi lʋʋ wa, ʋ wá fwa Yɩɩ dɩ̀àn mɩmɩnan, ʋ doni tətə bɛɛ wà tə nə fwa, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","*Farɩzɩan-ba nì kʋ tə, lɩ̀à tə nə ŋʋŋwɩn ba tətəŋi wa, Zwezi yɩrɩ. Ba mʋ̀, də Yɩɩ *joŋwana yun tɩ̀án tə dàń tʋn Yɩɩ dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə, sə ba ja wá. ");
INSERT INTO nnw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Zwezi swɩ̀n ba con, ʋ wʋ́: «À tə wulə də aba, máŋá mancɩn wa. Kʋ kwa nə, à wá pìí à va lìù tə con, ʋ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bwálɩ́ tə, à nə vəli, á wàrɩ̀ lá á twi. Kʋ mʋ̀ nə pɩn, á wá pɩ̀à nə. Yá á bá na nə». ");
INSERT INTO nnw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Zwifə-ba yun tɩ̀án dàń bwe duən, ba wʋ́: «Yə̀n nə, ʋ wá va, sə nə ba wá nɩ? Kʋ yɩ ʋ pɩ̀à, sə ʋ va Zwifə-ba con, ba nə wulə *Gərɛkə-ba tɩ̀án tə wa, naaa? Kʋ dàń nə ya, ʋ pɩ̀à ʋ kàrɩ̀ Gərɛkə-ba, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Sʋgʋ təntə də̀ń nə yɩ bɛ̀eɛ̀e? Ʋ swɩ̀n də, nə wá pɩ̀à wá, yá nə bá na wá. Ʋ tə swɩ̀n də, bwálɩ́ tə, ʋ nə vəli, nə wàrɩ̀ lá, nə vəli». ");
INSERT INTO nnw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Cànà tə talɩkwa dɩɩn tə yɩn dɩɩn nəfarʋ. Zwezi dàń zàn ʋ zɩga yɩɩ nə, ʋ swɩ̀n, ʋ wʋ́: «Də nanyʋnɩ nə jə lìù, sə ʋ bà à con, ʋ nyʋ nɩ́á. ");
INSERT INTO nnw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Lìù tə, ʋ nə keni ʋ waa à nə wuuu, nɩ́á wá nan ʋ con tə dəri. Nɩ́á təntə pɩn mɩɩ. Mə nətʋ nə, kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa». ");
INSERT INTO nnw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Zwezi nə swɩ̀n nətʋ tə, kʋ ya Yɩɩ-*Siŋu tə yoo nə, ʋ swɩ̀n. Kʋ mʋ̀ Siŋu təntə nə Yɩɩ nə wá pa lɩ̀à tə nə, ba nə keni ba waa ʋ nə wuuu. Zwezi yà tə wà ʋ dun tə wa pìí ʋ dɩ̀. Kʋ mʋ̀ nə pɩn, ʋ yà tə wà pɩn, Yɩɩ-Siŋu tə bà lʋʋ wa. ");
INSERT INTO nnw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lalʋʋ tə wa lɩ̀à duən nə nì tə sʋ̀ràn təntə, ba swɩ̀n, ba wʋ́: «Bɛɛ wà tə cɩ́gá ya Yɩɩ nii *sʋ̀sʋ̀nʋ̀ tə!» ");
INSERT INTO nnw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ba duən də swɩ̀n, ba wʋ́: «Ʋ mʋ̀ nə yɩ *Kərisə!» Ba duən də tə kʋ́ʋ̀ swɩ̀n, ba wʋ́: «Kərisə tə mɛ, sə ʋ nan Galile nagwanaa wa?» ");
INSERT INTO nnw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kərisə wá nan pɩ̀ʋ́ *Davidə dwíí tə wa. Yá kʋ wá yà Bɛtələhɛmə nə. Mə Bɛtələhɛmə tɩʋ təntə wa nə Davidə nan. Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kʋ mʋ̀ nə pɩn, lɩ̀à tə dàń ma pwɛ̀e duən wa, Zwezi yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lalʋʋ tə wa lɩ̀à duən yà pɩ̀à, sə ba ja wá. Yá ba lìù mama jɩ̀àn wà ʋ yɩra dwən. ");
INSERT INTO nnw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Lɩ̀à tə, ba nə tʋn, sə ba ja Zwezi, dàń ma pìí ba va *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də *Farɩzɩan-ba con. Ba bwe, ba wʋ́: «Bɛ̀eɛ̀e nə pɩn, á ma wà Zwezi jɩn, á ja á bà?» ");
INSERT INTO nnw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lɩ̀à təntə ma le ba, ba wʋ́: «Lìù mama tə wà sʋgʋ swɩ̀n, ndə bɛɛ təntə nə». ");
INSERT INTO nnw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farɩzɩan-ba ma pìí ba bwe ba, ba wʋ́: «Yá á mʋ̀ tətə wà á tɩ̀àn dʋgʋ, á pa ʋ gɩgarɩ aba? ");
INSERT INTO nnw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Lìù wulə yun tɩ̀án tə, də Farɩzɩan-ba wa, ʋ nə ken ʋ waa Zwezi nə, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lalʋʋ təntə, kʋ nə yə̀rì Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, wá cʋ̀gʋ̀». ");
INSERT INTO nnw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farɩzɩan-ba wa lìù don, də ya yɩn lá, ʋ yɩrɩ nə Nikodɛmə. Ʋ mʋ̀ nə dí yáá ʋ va Zwezi con, máŋá don wa. Ʋ zàn ʋ swɩ̀n ba duən tə con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kʋ nə twá də Yɩɩ nii tə, ʋ nə pɩn Moyizə nə, nə wàrɩ̀ lìù bʋ̀rà nə bʋ̀rɩ̀, də ʋ nə wà ʋ nii tún, ʋ bɩrɩ nəba, sə nə cʋgʋ ʋ sʋgʋ, nə lwarɩ kʋ tə, ʋ nə fwa». ");
INSERT INTO nnw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ba ma le Nikodɛmə, ba wʋ́: «N də tətə yɩ Galile tíú, naaa? Vəli, n kàrɩ̀ kʋ tə, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa. N wá na də, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ nədʋ mama tə wà Galile nan!» ");
INSERT INTO nnw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kʋ kwa nə, ba lìù də mama zàn, ʋ va ʋ sàń. ");
INSERT INTO nnw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yá Zwezi vəli *oliviye tɩ̀án paan tə yuu. ");
INSERT INTO nnw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kʋ tɩpʋrɩ jɩjʋ tətə nə, Zwezi kʋ́ʋ̀ pìí ʋ va *Zwifə-ba Yɩɩ *dìə̀ tə wa. Lalʋʋ tə mama twi ʋ con. Yá ʋ dàń ga jə̀ə́ tɩa, ʋ kàrɩ̀ ba. ");
INSERT INTO nnw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kʋ máŋá tə wa, Yɩɩ nii *yənu tɩ̀án tə, də *Farɩzɩan-ba jɩn kan don, ba ja bà. Ba zɩgɩ kan tə lɩ̀à tə mama yáá con. Kan təntə yà yɩ ba dɩ̀gà ʋ yuu, də ʋ wulə ʋ cwàrɩ̀. ");
INSERT INTO nnw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yá ba swɩ̀n Zwezi con, ba wʋ́: «Karnyɩna, kan wà tə yɩ, ba zàn ba ja nəpon nəpon də, ʋ wulə ʋ cwàrɩ̀. ");
INSERT INTO nnw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","*Moyizə pɩn nəba nii Yɩɩ *nii sagɩ tə wa, sə nə dɩlɩ kayirə təntə də kapana nə gʋ. N mʋ̀ dàń wʋ́ bɛ̀eɛ̀e?» ");
INSERT INTO nnw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba yà swɩ̀n kʋ nətʋ tə, sə ba ma ja Zwezi də̀ń nə, sə ba dàń twá kʋ nə, ba kə yoo ʋ nii nə. Zwezi kwá tɩa, ʋ ja ʋ jɩfʋa, ʋ ma pʋ́pʋ́nɩ́ tɩa. ");
INSERT INTO nnw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ba dàń nə tə zɩga lá, ba bwe wá, ʋ kwɩ̀án yɩɩ nə, ʋ swɩ̀n ba con, ʋ wʋ́: «Á wa lìù tə, ʋ tə nə wà cʋna fwa, sə ʋ dí yáá, ʋ tì kapan, ʋ ma dɩlɩ kan tə». ");
INSERT INTO nnw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yá ʋ kʋ́ʋ̀ pìí ʋ kwá, ʋ wulə ʋ pʋ́pʋ́nɩ́ tɩa. ");
INSERT INTO nnw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Máŋá tə, ba nə nì kʋ nətʋ tə, kʋ zɩgɩ ba nəkwɩa tíú tə nə, ba nan nədʋ nədʋ, ba va ba zwɛ̀e. Yá kʋ ga Zwezi cɩcɩ də kan tə, ʋ nə zɩga ʋ yáá con. ");
INSERT INTO nnw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Zwezi dàń ma kwɩ̀án yɩɩ nə, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Kan, lɩ̀à tə, ba nə pɩ̀à, ba kə yoo n yuu wa, tə wa yə̀n nə? Ba lìù mama wà mʋ́ yoo fwa, sə kʋ cʋ̀gʋ̀ mʋ́, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kan tə ma le Zwezi, ʋ wʋ́: «*Yuu-Tiu, lìù mama tə̀lə́». Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «À də nə bá fwa mʋ́ yoo, sə à cʋ̀gʋ̀ mʋ́. Vəli, n dàń nə kʋ́ʋ̀ dàn ká pìí n tʋn cʋna, mɩ́ámɩ́án». ");
INSERT INTO nnw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Zwezi dàń kʋ́ʋ̀ pìí, ʋ swɩ̀n lɩ̀à tə con, ʋ wʋ́: «À mʋ̀ nə yɩ ləzoni poni. Lìù tə, ʋ nə twá də nə, kʋ tíú bá va yikunu wa, abada. Yá ʋ wá na poni tə, kʋ nə pɩn mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kʋ yuu wa, *Farɩzɩan-ba swɩ̀n ʋ con, ba wʋ́: «N tətə nə swɩ̀n n tətə yoo. Kʋ mʋ̀ nə pɩn, n sʋgʋ tə ba də̀ń jə». ");
INSERT INTO nnw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Zwezi ma le ba, ʋ wʋ́: «Də à nə swə à swɩ̀n à tətə yoo, kʋ yɩ cɩ́gá. À mʋ̀ yə̀ə́ bwálɩ́ tə, à nə nan lá à bà, à ga yə̀ə́ à tə vəli lá. Á mʋ̀ yə̀rì bwálɩ́ tə, à nə nan lá, á ma kʋ́ʋ̀ yə̀rì bwálɩ́ tə, à nə vəli. ");
INSERT INTO nnw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Á mʋ̀ yàá twá də ləzoni yənu nə, á ma bʋ̀rɩ̀ lɩ̀à bʋ̀rà. À mʋ̀ ba lìù mama bʋ̀rà bʋ̀rɩ̀. ");
INSERT INTO nnw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yá à mʋ̀ nə wá bʋ̀rɩ̀ lìù bʋ̀rà də, kʋ yàá ya kʋ cɩ́gá wa. Kʋ tà à cɩcɩ. À nyɩna Yɩɩ tə, ʋ nə tʋn nə, ʋ yàá wulə də nə. ");
INSERT INTO nnw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kʋ pʋ́pʋ́nɩ́ Yɩɩ *nii sagɩ tə wa, ʋ nə pɩn *Moyizə nə ʋ pa aba, də lɩ̀à bələ nə swɩ̀n yoo nədʋ, kʋ yoo tə yɩ cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","À mʋ̀ swɩ̀n à tətə yoo, yá à nyɩna tə, ʋ nə tʋn nə, ʋ də swɩ̀n kʋ yoo təntə». ");
INSERT INTO nnw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba dàń ma swɩ̀n ʋ con, ba wʋ́: «N nyɩna tə wa yə̀n nə?» Zwezi le ba, ʋ wʋ́: «Á yə̀rì à tətə, á ma yə̀rì à nyɩna tə də. Də á nə yə̀ə́ nə, á wá yəni à nyɩna tə də». ");
INSERT INTO nnw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zwezi yà wulə *Zwifə-ba *Yɩɩ dìə̀ tə wa, səbɩa tə nə kəni lá bwálɩ́ nə, ʋ kàrɩ̀ lɩ̀à tə. Mə kʋ bwálɩ́ tə wa, ʋ swɩ̀n sʋ̀ràn təntə. Kʋ máŋá təntə wa, də ʋ janʋ máŋá tə wà yí. Kʋ mʋ̀ nə pɩn, lìù mama wà wá jɩn. ");
INSERT INTO nnw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zwezi kʋ́ʋ̀ pìí ʋ swɩ̀n lɩ̀à con, ʋ wʋ́: «À mʋ̀ wá vìí, á wá pɩ̀à nə, á ga. Yá á wá tɩ á cʋna tə wa. Á wàrɩ̀ bwálɩ́ tə, à nə vələ, á vəli». ");
INSERT INTO nnw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","*Zwifə-ba yun tɩ̀án dàń swɩ̀n duən con, ba wʋ́: «Ʋ nə swɩ̀n də, nə wàrɩ̀ bwálɩ́ tə, ʋ nə vələ tə, nə vəli, kʋ bá ya ʋ pɩ̀à, ʋ gʋ ʋ tɩ̀àn?» ");
INSERT INTO nnw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Zwezi le ba, ʋ wʋ́: «Á dəkuu yɩ kʋ wulə tɩa ka tə yuu, à mʋ̀ dəkuu ga yɩ kʋ nan Yɩɩ. Á mʋ̀ sàń nə yɩ lʋʋ kʋ tə, à mʋ̀ tà lʋʋ kʋ tə lìù. ");
INSERT INTO nnw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kʋ mʋ̀ nə pɩn, à ma swɩ̀n á con də, á wá tɩ á cʋna tə wa. Á nə wà cɩ́gá pɩn də, à mʋ̀ nə yɩ lìù tə, ʋ nə wulə máŋá mama, wuuu, á wá tɩ á cʋna tə wa». ");
INSERT INTO nnw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba ma bwe wá, ba wʋ́: «N mʋ̀ nə yɩ wàà?» Zwezi le ba, ʋ wʋ́: «À dí yáá à swɩ̀n á con kʋ jɩjʋ tə mama. ");
INSERT INTO nnw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Á yuu yìə̀n dáá zənzən, à nə mɛ, sə à swɩ̀n tə yoo á con. Lìù tə, ʋ nə tʋn nə, yɩ cɩ́gá tíú. Yá kʋ tə, ʋ nə bɩrɩ nə, kʋ mʋ̀ nə, à də swɩ̀n lɩ̀à con, ba nə yɩ lʋʋ nə tɩ». ");
INSERT INTO nnw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ba yà wà lwarɩ də, kʋ ya nyɩna Yɩɩ yoo nə, ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Zwezi dàń ma swɩ̀n ba con, ʋ wʋ́: «Máŋá tə, á nə wá zɩ̀n *Ləzwənə-Biu tə, á kə yɩɩ nə, kʋ máŋá tə wa, á dàń wá lwarɩ də, à mʋ̀ nə yɩ lìù tə, à nə wulə máŋá mama, wuuu. Á wá lwarɩ də, à ba won mama fwa à tɩ̀àn nə. Yá à sʋ̀ràn tə yɩ kʋ tə à nyɩna Yɩɩ nə kàrɩ̀ nə, à swɩ̀n à bɩrɩ lɩ̀à tə. ");
INSERT INTO nnw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Máŋá mama, à fwa kʋ tə, lìù tə, ʋ nə tʋn nə, nə swə. Kʋ mʋ̀ nə pɩn, ʋ wulə də nə. Ʋ wà nə yá à cɩcɩ». ");
INSERT INTO nnw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Máŋá tə wa, Zwezi swɩ̀n kʋ nətʋ tə, lɩ̀à zənzən ken ba waa ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Zwezi swɩ̀n *Zwifə-ba con, ba nə keni ba waa ʋ nə, ʋ wʋ́: «Á nə jon à sʋ̀ràn tə, á zìlí tə nii, də á cɩ́gá yɩ à karbɩa. ");
INSERT INTO nnw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kʋ nətʋ nə wá pa á lwarɩ cɩ́gá tə. Yá cɩ́gá tə nə wá jon aba á cʋna tə wa, sə á tɩnɩ á tɩ̀àn». ");
INSERT INTO nnw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Zwifə-ba tə ma pìí ba le Zwezi, ba wʋ́: «Nə mʋ̀ yɩ ba lʋrɩ nəba *Abərahamə dwíí tə wa. Nə mʋ̀ wà lìù yoŋu yɩn mɩ́ámɩ́án. Kʋ fwa nətə, n ma wʋ́: ‹Á dàń wá tɩnɩ á tɩ̀àn?› » ");
INSERT INTO nnw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Zwezi ma le ba, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə mama, ʋ nə tʋŋa cʋna, ʋ yɩ cʋna yoŋu. ");
INSERT INTO nnw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yá yoŋu tà ʋ wulə sàń wa, máŋá mama. Sàń tə bìú nə wulə sàń tə wa, máŋá mama wuuu. ");
INSERT INTO nnw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Də Yɩɩ-Biu tə dàń nə jon aba á cʋna wa, á wá tɩnɩ á tɩ̀àn, cɩ́gá cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","À yə̀ə́ də, ba lʋrɩ aba Abərahamə dwíí tə wa. Á ba à sʋ̀ràn tə joŋə. Kʋ mʋ̀ nə pɩn, á pɩ̀à, sə á gʋ nə. ");
INSERT INTO nnw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kʋ tə, à nyɩna nə pɩn à na, kʋ mʋ̀ nə à swɩ̀n á con. Á də yɩ kʋ tə, á də nyɩna tə nə bɩrɩ aba, nə á cʋga, nə á tʋŋa». ");
INSERT INTO nnw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba kʋ́ʋ̀ pìí ba le wá, ba wʋ́: «Nə nyɩna nə yɩ Abərahamə!» Zwezi ma swɩ̀n ba con, ʋ wʋ́: «Də á cɩ́gá nə nan Abərahamə dwíí tə wa, á mɛ, sə á fwa kʋ tə Abərahamə nə fwa. ");
INSERT INTO nnw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Á nə pɩ̀à, sə á gʋ nə, à mʋ̀ lìù tə, à nə swɩ̀n cɩ́gá tə, Yɩɩ nə bɩrɩ nə á con, Abərahamə wà kʋ nyɩn don fwa. ");
INSERT INTO nnw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kʋ yɩ á nyɩna tə tʋtʋnan nə, á tʋŋa». Ba ma kʋ́ʋ̀ swɩ̀n ʋ con, ba wʋ́: «Nə tà bɩa tə, ba nə lʋrɩ yirə duən nə. Nə nyɩna yɩ nədʋ, kʋ mʋ̀ nə yɩ Yɩɩ». ");
INSERT INTO nnw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Zwezi le ba, ʋ wʋ́: «Də Yɩɩ cɩ́gá yà nə yɩ á nyɩna, á yà wá sóní nə. Kʋ ya Yɩɩ con nə, à nan à bà. Kʋ tà à tətə nə twi à tɩ̀àn nə, kʋ ya ʋ mʋ̀ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bɛ̀eɛ̀e nə pɩn, á ba à sʋgʋ tə də̀ń nə̀ń? Kʋ yɩ á nə ba pɩ̀à, sə á sɛ̀e à sʋ̀ràn tə. ");
INSERT INTO nnw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Á nyɩna nə yɩ *Sɩtana. Kʋ mʋ̀ nə pɩn, á pɩ̀à á tʋn á nyɩna təntə fɩra yìə̀n. Kʋ jɩjʋ mama, ʋ yɩn lagʋrʋ. Ʋ wà cɩ́gá swənə mama. Yɩɩ cɩ́gá ga tə̀lə́ ʋ con. Máŋá tə, ʋ nə kʋnɩ kʋnkʋn tə, ʋ sʋ̀ràn yàá yɩ, ndə ʋ tətə nə yɩ nətʋ. Ʋ yɩ kʋnkʋnʋ tə, ʋ nə ya kʋnkʋna nyɩna. ");
INSERT INTO nnw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","À mʋ̀ yɩ, à nə swɩ̀n cɩ́gá tə nə pɩn, á ba nə cɩ́gá pɩn. ");
INSERT INTO nnw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Á wa lá, wàà nə wàá ʋ bɩrɩ də, à tʋn cʋna? Də kʋ nə yɩ cɩ́gá nə à swɩ̀n, bɛ̀eɛ̀e nə pɩn, á ma ba nə cɩ́gá pɩn? ");
INSERT INTO nnw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Lìù tə, ʋ nə ya Yɩɩ nyiən, ʋ yàá cʋgʋ Yɩɩ sʋ̀ràn tə. Á tà Yɩɩ nyiən. Kʋ mʋ̀ nə pɩn, á ba Yɩɩ sʋ̀ràn tə cʋga». ");
INSERT INTO nnw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","*Zwifə-ba yun tɩ̀án tə dàń ma swɩ̀n Zwezi con, ba wʋ́: «Nə ba cɩ́gá jə, sə nə swɩ̀n də, n yɩ Samari tíú, yá *zinə də wulə n yuu wa, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Zwezi le ba, ʋ wʋ́: «Zinə tə̀lə́ à yuu wa. Kʋ yɩ à mʋ̀ bwɩ à nyɩna Yɩɩ nə. Yá á mʋ̀ wulə á muŋə nə. ");
INSERT INTO nnw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","À mʋ̀ ba à dun pɩ̀à. Lìù nədʋa nə wulə, ʋ nə pɩ̀à dun tə, sə ʋ pa nə. Ʋ mʋ̀ ga nə bʋ̀rɩ̀ lɩ̀à bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə, ʋ nə zìlí à sʋ̀ràn tə nii, ʋ bá tɩ abada». ");
INSERT INTO nnw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Zwifə-ba yun tɩ̀án ma swɩ̀n ʋ con, ba wʋ́: «Sɩ́ʋ́n nə, nə dàń nə yə̀ə́ də, n yɩ zinə nə wulə n yuu wa. *Abərahamə tɩga, Yɩɩ nii *sʋ̀sʋ̀nà tə də tɩga. Yá n mʋ̀ swɩ̀n də, lìù nə zìlí n sʋ̀ràn tə nii, ʋ bá tɩ abada. ");
INSERT INTO nnw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","N dwə nə nɩbɛɛ Abərahamə, ʋ nə tɩga, naaa? Yɩɩ nii sʋ̀sʋ̀nà tə də tɩga. N mʋ̀ bʋŋa də n yɩ wàà?» ");
INSERT INTO nnw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Zwezi le ba, ʋ wʋ́: «Kʋ nə yɩ à tətə nə pɩn dun à tɩ̀àn nə, tə dun tə yɩ tʋtʋ. Kʋ yɩ à nyɩna Yɩɩ tə nə pɩn dun nə. Ʋ mʋ̀ lìù tə, á nə swɩ̀n də, ʋ yɩ á Yɩɩ tə. ");
INSERT INTO nnw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Á mʋ̀ yə̀rì wá, à mʋ̀ ga yə̀ə́ wá. Də à nə swɩ̀n də, à yə̀rì wá, à ya kʋnkʋnʋ ndə á nə. À yə̀ə́ wá, à ga jə ʋ sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Á nɩbɛɛ Abərahamə pùə́ poli də, ʋ nə bʋ́n də, ʋ wá na à túrí dɩɩn tə. Ʋ nɩ kʋ dɩɩn tə, yá ʋ yɩn pupwən wa». ");
INSERT INTO nnw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Zwifə-ba yun tɩ̀án swɩ̀n ʋ con, ba wʋ́: «N tə nə ba bɩna finu jə, yá n nɩ Abərahamə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Zwezi le ba, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: À mʋ̀ yà wulə, də ba tə wà Abərahamə lʋrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kʋ mʋ̀ sʋgʋ təntə yuu wa, ba pɛ̀e kapana, sə ba ma dɩlɩ wá. Kʋ mʋ̀ nə pɩn, Zwezi sə̀gə̀, ʋ nan Zwifə-ba Yɩɩ *dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dɩɩn don nə, Zwezi tì cwəŋə don, ʋ lɛ. Ʋ nə ma lɛ, máŋá tə wa, ʋ nɩ bɛɛ don. Ba lʋrɩ wá liliu. ");
INSERT INTO nnw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Zwezi karbɩa tə ma bwe wá, ba wʋ́: «Karnyɩna, ba lʋrɩ bɛɛ tə liliu. Wàà nə tʋn cʋna? Kʋ yɩ ʋ mʋ̀, nə à yə̀ə́ ʋ nyɩna-ba nə tʋn cʋna, kʋ ma pa ʋ yɩ liliu?» ");
INSERT INTO nnw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Zwezi le ba, ʋ wʋ́: «Kʋ tà ʋ mʋ̀ nə tʋn cʋna, nə à yə̀ə́ ʋ nyɩna-ba nə tʋn cʋna. Kʋ yɩ kʋ yí nətʋ, sə Yɩɩ tʋtʋnan tə twá ʋ nə, tə bɩrɩ tə tɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","À mɛ, sə à tʋn Yɩɩ tʋtʋnan tə, də tɩa tə wà yí. Ʋ mʋ̀ Yɩɩ nə tʋn nə. Tɩa nə twi ka yí, lìù mama kʋ́ʋ̀ bá wànɩ́ ʋ tʋn. ");
INSERT INTO nnw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Máŋá tə wa, à nə tə wulə lʋʋ wa, à yɩ ləzwənə poni». ");
INSERT INTO nnw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Zwezi nə swɩ̀n tə sʋ̀ràn təntə kwa nə, ʋ pi mɩmɩan tɩa, ʋ ma bu tɩran mancɩn. Ʋ ga fwa tɩran təntə, ʋ ma tà liliu tə yɩ́á nə. ");
INSERT INTO nnw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yá ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Vəli càrʋ́ tə wa, ba nə boŋə ‹Silowe›, n kwán nɩ́á, n ma puli n yáá tə». Silowe tə də̀ń nə yɩ ‹lìù, ba nə tʋn›. Liliu tə vəli, ʋ puli ʋ yáá tə. Ʋ pìí ʋ bɩ̀àn, máŋá tə, ʋ yɩ́á tə pórí tə na lá zəni. ");
INSERT INTO nnw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ʋ jə̀ń duən, də ba tə, ba nə dí yáá, ba na wá də, ʋ lòrì tə, dàń ma swɩ̀n, ba wʋ́: «Kʋ tà bɛɛ wà tə, yà nə jə̀ə́ tɩa, ʋ lòrì tə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ba duən swɩ̀n, ba wʋ́: «Mə ʋ nə». Ba duən də swɩ̀n, ba wʋ́: «Kʋ tà ʋ mʋ̀. Kʋ yɩ ʋ nyɩnyɩga». Bɛɛ tə tətə dàń ma swɩ̀n, ʋ wʋ́: «Kʋ cɩ́gá ya à mʋ̀!» ");
INSERT INTO nnw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ba dàń ma bwe wá, ba wʋ́: «Nətə nə kʋ twá, n yɩ́á tə ma pórí?» ");
INSERT INTO nnw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ʋ ma le ba, ʋ wʋ́: «Bɛɛ tə, ba nə boŋə Zwezi tə, nə fwa tɩran, ʋ ma tà à yɩ́á tə nə, ʋ ga swɩ̀n à con, sə à va à puli à yáá tə càrʋ́ tə wa, ba nə boŋə ‹Silowe›. À ma va lá, à nə puli à yɩ́á tə à zwɛ̀e, kwa nə, à yɩ́á tə na lá». ");
INSERT INTO nnw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ba tə ma bwe wá, ba wʋ́: «Bɛɛ təntə wulə yə̀n nə?» Ʋ ma le ba, ʋ wʋ́: «À yə̀rì ʋ bwálɩ́». ");
INSERT INTO nnw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ba dàń ma ja bɛɛ tə, ʋ yɩ́á tə nə pórí tə, ba ja va *Farɩzɩan-ba con. ");
INSERT INTO nnw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Dɩɩn təntə yɩn *Zwifə-ba *sìə́ dɩɩn, yá Zwezi ga fwa tɩran, ʋ ma pórí bɛɛ tə yɩ́á. ");
INSERT INTO nnw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kʋ mʋ̀ nə pɩn, Farɩzɩan-ba də kʋ́ʋ̀ bwe bɛɛ tə, ba wʋ́: «Kʋ fwa nətə, n yɩ́á tə ma pórí?» Ʋ le ba, ʋ wʋ́: «Zwezi fwa tɩran mancɩn, ʋ kə à yɩ́á tə nə. À vəli à puli à yáá tə. Mə kʋ nə, à na lá». ");
INSERT INTO nnw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kʋ yoo təntə yuu wa, Farɩzɩan-ba wa lɩ̀à swɩ̀n, ba wʋ́: «Kʋ bɛɛ təntə wà Yɩɩ nan. Kʋ mʋ̀ nə pɩn, ʋ ba sìə́ dɩɩn tə nii zìlí». Ba duən də kʋ́ʋ̀ swɩ̀n, ba wʋ́: «Nətə nə cʋna lìù wá twá, ʋ ma fwa Yɩɩ dɩ̀àn mɩmɩnʋ tətə yiri?» Kʋ nətʋ tə pɩn ba pwɛ̀e duən wa. ");
INSERT INTO nnw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ba kʋ́ʋ̀ bwe bɛɛ tə, ʋ yà nə yɩ liliu tə, ba wʋ́: «N mʋ̀ con, n bʋŋa də bɛɛ təntə, ʋ nə pórí n yɩ́á tə, yɩ wàà?» Bɛɛ tə ma le ba, ʋ wʋ́: «Ʋ yɩ Yɩɩ nii *sʋ̀sʋ̀nʋ̀». ");
INSERT INTO nnw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Zwifə-ba yun tɩ̀án tə wà cɩ́gá pɩn də, ʋ tətə yà yɩn liliu, yá ʋ yɩ́á tə ga pórí. Kʋ mʋ̀ nə pɩn, ba ma bon ʋ nuu də ʋ nyɩna. ");
INSERT INTO nnw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ba nə twi ba yí lá, ba bwe ba, ba wʋ́: «Bɛɛ wà tə cɩ́gá ya á mʋ̀ bìú, naaa? Cɩ́gá mama, á wʋ́ ʋ yɩ ba lʋrɩ wá liliu? Kʋ dàń fwa nətə, ʋ ma na lá?» ");
INSERT INTO nnw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ʋ nuu də ʋ nyɩna tə ma le, ba wʋ́: «Nə yə̀ə́ də, ʋ ya nə mʋ̀ bìú, yá ʋ ga yɩ ba lʋrɩ wá liliu. ");
INSERT INTO nnw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kʋ nə fwa nətʋ, ʋ dàń ma na lá sɩ́ʋ́n nə, nə yə̀rì kʋ mʋ̀. Nə ma kʋ́ʋ̀ yə̀rì lìù tə də, ʋ nə pórí ʋ yɩ́á tə. Á bwiə ʋ tətə, ʋ də yɩ nəkwɩa, ʋ wàá ʋ tətə yoo ʋ swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Zwifə-ba yun tɩ̀án fən yà jə ʋ nuu də ʋ nyɩna tə. Kʋ mʋ̀ nə pɩn, ba swɩ̀n kʋ nətʋ tə. Zwifə-ba yun tɩ̀án yà ken nii nədʋ, sə ba dɩŋɩ lìù tə mama, ʋ nə wá swɩ̀n də, Zwezi nə yɩ *Kərisə, ba lɩ ba *jə́rə́ dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kʋ mʋ̀ nə pɩn, ʋ nuu də ʋ nyɩna tə ma swɩ̀n də, ʋ də yɩ nəkwɩa, ba bwiə ʋ tətə. ");
INSERT INTO nnw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farɩzɩan-ba kʋ́ʋ̀ bon liliu tə, ʋ yɩ́á tə nə pórí tə, nɛɛ bələ nii nə, ba swɩ̀n ʋ con, ba wʋ́: «Swɩ̀n cɩ́gá Yɩɩ yáá con. Nə mʋ̀ yə̀ə́ də, bɛɛ wà tə yɩ cʋnʋ». ");
INSERT INTO nnw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ʋ le ba, ʋ wʋ́: «Də ʋ nə yɩ cʋnʋ, à mʋ̀ yə̀rì kʋ. Yoo nədʋ nə, à yə̀ə́. À yà yɩ liliu, yá sɩ́ʋ́n nə à yɩ́á dàń na lá». ");
INSERT INTO nnw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba ma swɩ̀n ʋ con, ba wʋ́: «Nətə nə, ʋ fwa mʋ́? Kʋ yɩ ʋ fwa nətə, ʋ ma pwə́rə́ n yɩ́á tə?» ");
INSERT INTO nnw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Bɛɛ tə kʋ́ʋ̀ le ba, ʋ wʋ́: «À dí yáá à swɩ̀n kʋ, à bɩrɩ aba, yá á wà kʋ cʋgʋ. Bɛ̀eɛ̀e nə pɩn, á pɩ̀à, sə à kʋ́ʋ̀ pìí à bwé kʋ? Kʋ yɩ á də tətə pɩ̀à, sə á jì ʋ karbɩa, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ba dàń twɩn wá, ba ga swɩ̀n, ba wʋ́: «Kʋ yɩ n mʋ̀ nə ya ʋ karbiu, nə mʋ̀ yɩ *Moyizə karbɩa. ");
INSERT INTO nnw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nə yə̀ə́ də, Yɩɩ swɩ̀n Moyizə con. Ʋ tə ba tə mʋ̀, nə yə̀rì bwálɩ́ tə, ʋ nə nan». ");
INSERT INTO nnw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bɛɛ tə ma le ba, ʋ wʋ́: «Mə kʋ yoo təntə nə gwárɩ́ nə də, á nə yə̀rì ʋ nə nan lá, yá ʋ ga pórí à mʋ̀ yɩ́á. ");
INSERT INTO nnw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nə yə̀ə́ də, Yɩɩ ba cʋnʋ yɩjʋnɩ le. Kʋ ya lìù tə, ʋ nə zìlí Yɩɩ nii, ʋ ga tʋŋa Yɩɩ fɩra nə, Yɩɩ yàá cʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nə tə wà nì mama abada də, lìù pórí liliu yɩ́á, ba nə lʋrɩ wá, də ʋ yɩ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Də bɛɛ təntə yà nə wà Yɩɩ nan, ʋ yà wàrɩ̀ won mama, ʋ tʋŋa». ");
INSERT INTO nnw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ba ma le wá, ba wʋ́: «N tətə mama yɩ ba lʋrɩ mʋ́ cʋna wa, n ga pɩ̀à, sə n kàrɩ̀ nəba!» Ba dàń ma dɩŋɩ wá, ba lɩ ba jə́rə́ dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zwezi dàń nì də, Farɩzɩan-ba dɩŋɩ bɛɛ tə, ʋ yà nə yɩ liliu tə, ba lɩ ba jə́rə́ dìə̀ tə wa. Zwezi ma jə́rí bɛɛ tə, ʋ bwe wá, ʋ wʋ́: «N ken n waa *Ləzwənə-Biu tə nə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bɛɛ tə le Zwezi, ʋ wʋ́: «Kʋ mʋ̀ nə yɩ wàà, *Yuu-Tiu? À swə, sə à kə à waa ʋ nə». ");
INSERT INTO nnw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «N yɩ́á cə kʋ tíú yuu wa. Mə ʋ mʋ̀ nə wulə ʋ swɩ̀n n con, sɩ́ʋ́n nə!» ");
INSERT INTO nnw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bɛɛ tə dàń ma swɩ̀n, ʋ wʋ́: «Yuu-Tiu, à ken à waa n nə». Yá ʋ ga tʋ ʋ nadwana yuu, ʋ bʋ Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zwezi dàń ma swɩ̀n, ʋ wʋ́: «À twi lʋʋ kʋ tə wa, sə à bʋ̀rɩ̀ lɩ̀à bʋ̀rà. À pa lilirən yɩ́á pórí, à ga pa lɩ̀à tə, ba yɩ́á nə na lá, lwàń ba jì lilirən». ");
INSERT INTO nnw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farɩzɩan-ba lɩ̀à duən yà wulə kʋ bwálɩ́ tə wa. Ba nə nì tə sʋ̀ràn təntə, ba bwe Zwezi, ba wʋ́: «Nə də yɩ lilirən, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zwezi le ba, ʋ wʋ́: «Á yà nə ya lilirən, á yà ba cʋna jə. Á dàń nə swɩ̀n də, á na lá. Kʋ mʋ̀ nə pɩn, á cʋna tə wulə wuuu». ");
INSERT INTO nnw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Zwezi kàrɩ̀ lɩ̀à tə də zwansɩsarɩ, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə, ʋ nə twá mimii, ʋ ma zwɩ patuu wa, kʋ tíú nə yɩ payɩrʋ tə. Yá lìù tə, ʋ nə ba patuu mimii twá, ʋ ma zwɩ, ʋ ga twá kʋ bwálɩ́ don, ʋ ma zwɩ, kʋ tíú yɩ ŋwɩ̀àn, ʋ ga yɩ lagʋrʋ. ");
INSERT INTO nnw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lìù tə, ʋ nə cɩ̀ patuu tə nii nə, ʋ yàá súrí kʋ mimii, ʋ pa payɩrʋ tə nə. Yá pee tə ga cʋga tə payɩrʋ tə kori. Ʋ yàá bon ʋ piə mama də ka yɩrɩ, ʋ ma lɩ tə patuu tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ʋ nə lɩ pee tə mama, ʋ zwɛ̀e, ʋ dàń yàá ya tə yáá, pee tə ga pú ʋ kwa. Kʋ nətʋ bɩrɩ də, tə yə̀ə́ ʋ kori swɩ́án. ");
INSERT INTO nnw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pee tə bá sɛ̀e, tə pwí lìù don kwa. Tə yə̀rì ʋ kori swɩ́án. Kʋ mʋ̀ nə pɩn, tə nə nɩ lìù don, tə wá dəri, tə jén ʋ yáá nə». ");
INSERT INTO nnw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zwezi kàrɩ̀ lɩ̀à tə də zwansɩsara tə, ba ga wà yoo tə, ʋ nə pɩ̀à, sə ʋ swɩ̀n ba con, tə də̀ń nì. ");
INSERT INTO nnw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ súrí lá, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: À mʋ̀ nə yɩ patuu tə mimii. ");
INSERT INTO nnw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Lɩ̀à tə mama, ba nə dí à yáá, ba bà tə yɩ ŋwɩna də lagʋra. Yá pee tə wà ba cʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","À mʋ̀ nə yɩ ndə mimii nə. Lìù tə, ʋ nə twá də nə, ʋ ma zʋ Yɩɩ wá jon kʋ tíú. Ʋ wàá ʋ zwɩ də ʋ naŋa ndə pee tə nə, ʋ ga wá na ʋ nii wodiu də. ");
INSERT INTO nnw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ŋwɩ̀àn mʋ̀ yɩ ʋ yàá bà, sə ʋ ŋʋ, sə ʋ gʋ, sə ʋ cʋ̀gʋ̀. À mʋ̀ yɩ à twi, sə à tɩ, sə lɩ̀à tə ma na mɩɩ, sə ba na mɩɩ, kʋ nə ywán cɩ́gá cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","À mʋ̀ nə yɩ payɩrʋ nəzəŋu. Payɩrʋ nəzəŋu yàá ja ʋ mɩɩ, ʋ ma lárɩ́ ʋ pee yuu nə. ");
INSERT INTO nnw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yá lìù tə, ʋ nə cɩ̀ pee nə, sə ba ŋwɩ́n wá, kʋ tíú mʋ̀ yɩ səbiu tə nə, ʋ ywàŋá. Yá pee tə tà ʋ mʋ̀ nyiən. Kʋ mʋ̀ nə pɩn, ʋ nə nɩ buyuru, də nyankwan kʋ bɩ̀àn, ʋ yàá dʋgʋ pee tə, ʋ ga dəri ʋ jén. Buyuru tə dàń yàá tʋ pee tə wa, kʋ ja tə, kʋ laga tə duən yáá nə. ");
INSERT INTO nnw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kʋ nətʋ dàń bɩrɩ də, ʋ yɩ ʋ tʋŋa səbiu yɩrɩ, pee tə yoo ba wá jə. ");
INSERT INTO nnw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","À mʋ̀ nə yɩ payɩrʋ nəzəŋu tə. À yə̀ə́ à pee tə, à pee tə də ga yə̀ə́ nə. ");
INSERT INTO nnw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mə nətʋ nə, à mʋ̀ də à nyɩna Yɩɩ tə yə̀ə́ duən. Ʋ yə̀ə́ nə à də ga yə̀ə́ wá. À ja à mɩɩ, à ma lárɩ́ à pee yuu nə. ");
INSERT INTO nnw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","À tə jə pee duən, tə nə tə̀lə́ patuu kʋ tə wa. À mɛ, sə à pɩ̀à tə pee təntə, də à ja bà. Pee tə mama dàń wá nì à kori. Kʋ dàń wá yà patuu nədʋ, yá payɩrʋ tə də wá yà nədʋ. ");
INSERT INTO nnw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","À pɩn à mɩɩ tə, sə à kʋ́ʋ̀ pìí à jon. Kʋ mʋ̀ nə pɩn, à nyɩna Yɩɩ swə nə. ");
INSERT INTO nnw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lìù mama wàrɩ̀ à mɩɩ tə, ʋ lɩ ʋ tɩ̀àn nə. À mʋ̀ tətə nə ja cwəŋə, sə à pa à mɩɩ tə, à mʋ̀ nə ma ja cwəŋə də, sə à pìí à jon à mɩɩ tə. À nyɩna Yɩɩ nə pɩn nə kʋ nii təntə». ");
INSERT INTO nnw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zwezi sʋ̀ràn təntə kʋ pɩn, Zwifə-ba yun tɩ̀án tə kʋ́ʋ̀ pìí ba pwɛ̀e duən wa. ");
INSERT INTO nnw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba wa lɩ̀à zənzən yà swɩ̀n, ba wʋ́: «*Zini nə wulə ʋ yuu wa, ʋ ga nyàŋà. Á dànà ká cʋgʋ ʋ sʋ̀ràn tə!» ");
INSERT INTO nnw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ba duən də swɩ̀n, ba wʋ́: «Zini nə wulə lìù yuu wa, ʋ wàrɩ̀ sʋ̀ràn tətə ʋ swɩ̀n. Lìù tə zini nə jə, ʋ wàrɩ̀ lìù yɩ́á ʋ pórí». ");
INSERT INTO nnw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ba yà wulə ba də́ cànà don, ka nə yɩ *Zwifə-ba Yɩɩ *dìə̀ tə nii súrú bɩnɩ cànà, *Zwerizalɛmə nə. Kʋ máŋá tə yà yɩ waran máŋá. ");
INSERT INTO nnw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Zwezi vəli Yɩɩ dìə̀ tə wa. Ʋ jijiri bwálɩ́ tə nə, ba nə boŋə ‹Salʋmʋn napakʋlʋ›. ");
INSERT INTO nnw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zwifə-ba yun tɩ̀án kɩkarɩ wá, ba ga swɩ̀n ʋ con, ba wʋ́: «N pɩ̀à, sə nə bɛ̀eé n yoo nə waa con, wuuu, kʋ jə vələ dɩɩn don? Swɩ̀n kʋ nə con nəpon nəpon də, n cɩ́gá nə yɩ *Kərisə». ");
INSERT INTO nnw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Zwezi ma le ba, ʋ wʋ́: «À dí yáá à swɩ̀n kʋ á con, yá á wà cɩ́gá pɩn à sʋgʋ tə nə. Yìə̀n tə, à nyɩna Yɩɩ nə pɩn nii, à ma fwa, tə mʋ̀ nə bɩrɩ lìù tə, à nə ya. ");
INSERT INTO nnw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Á twá á tə̀lə́ à pee tə wa. Kʋ mʋ̀ nə pɩn, á wà cɩ́gá pɩn à sʋgʋ tə nə. ");
INSERT INTO nnw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","À mʋ̀ pee tə cʋga à kori. À də yə̀ə́ tə swɩ́án, yá tə ga pwí à kwa. ");
INSERT INTO nnw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","À pɩn tə mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con. Tə kʋ́ʋ̀ bá jén, abada. Yá lìù də mama kʋ́ʋ̀ wàrɩ̀ tə, ʋ lɩ à jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","À nyɩna Yɩɩ dɩ̀àn tə dwə won mama. Ʋ mʋ̀ nə pɩn pee tə nə. Yá lìù mama kʋ́ʋ̀ wàrɩ̀ tə, ʋ lɩ ʋ mʋ̀ nyɩna Yɩɩ jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","À mʋ̀ də à nyɩna Yɩɩ ya nədʋ». ");
INSERT INTO nnw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Zwifə-ba yun tɩ̀án kʋ́ʋ̀ pɛ̀e kapana, sə ba ma dɩlɩ Zwezi, ba gʋ. ");
INSERT INTO nnw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Zwezi ma bwé, ʋ swɩ̀n ba con, ʋ wʋ́: «À nyɩna Yɩɩ dɩ̀àn tə pɩn, à tʋn tʋtʋnzəŋə zənzən, á yɩ́á yuu wa. Kʋ ka tətə yɩrɩ nə, á pɩ̀à, sə á dɩlɩ nə, á gʋ?» ");
INSERT INTO nnw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zwifə-ba yun tɩ̀án le wá, ba wʋ́: «Kʋ tà nə pɩ̀à nə dɩlɩ mʋ̀, nə gʋ, n nə tʋn tʋtʋnzəŋu yɩrɩ. N swɩ̀n n twɩn Yɩɩ. N də ya ləzwənə, n ga pɩ̀à, n ja n tɩ̀àn, n ma fwa Yɩɩ». ");
INSERT INTO nnw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Zwezi le ba, ʋ wʋ́: «Kʋ pʋ́pʋ́nɩ́ á sagɩ tə wa də, Yɩɩ swɩ̀n də, á yɩ yɩa. ");
INSERT INTO nnw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kʋ mʋ̀ sagɩ təntə wa, Yɩɩ swɩ̀n ləzoni con, ʋ ga ja ba, ʋ boŋə ‹yɩa›. Nə ga yə̀ə́ də, nə wàrɩ̀ kʋ tə, Yɩɩ nə swɩ̀n ʋ sagɩ tə wa nə, nə pɩn kʋ jén lá. ");
INSERT INTO nnw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","À mʋ̀ ya nyɩna Yɩɩ nə kúrí nə, ʋ kə vàn nə, ʋ tʋn lʋʋ kʋ tə wa. Yá à dàń swɩ̀n də, à yɩ Yɩɩ-Biu. Á dàń fwa nətə, á ma wʋ́, də à twɩn Yɩɩ? ");
INSERT INTO nnw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Də à nə bá à nyɩna Yɩɩ tʋtʋnan tə tʋŋa, á dànà ká pa nə cɩ́gá! ");
INSERT INTO nnw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yá à dàń nə tʋŋa à nyɩna Yɩɩ tʋtʋnan tə, á mɛ, sə á pa nə cɩ́gá. Á nə ba pɩ̀à, sə á pa nə cɩ́gá, kʋ mɛ, sə á tà tʋtʋŋɩ tə yɩrɩ, á pa nə cɩ́gá. Kʋ nətʋ wá pa á lwarɩ də, à nyɩna Yɩɩ wulə də nə, à də ga wulə də à nyɩna Yɩɩ». ");
INSERT INTO nnw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ba kʋ́ʋ̀ zàn, ba pɩ̀à, ba ja Zwezi. Ʋ ma jén ba yɩ́á yuu. ");
INSERT INTO nnw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Zwezi kʋ́ʋ̀ pìí, ʋ va Zwurədɛn mʋnaa tə nii nə, bwálɩ́ tə, Zwan nə dí yáá, ʋ lə lɩ̀à tə nɩ́á wa. Ʋ vəli ʋ wulə kʋ bwálɩ́ təntə nə. ");
INSERT INTO nnw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lɩ̀à zənzən twi ʋ con, ba swɩ̀n, ba wʋ́: «Zwan mʋ̀ wà Yɩɩ dɩ̀àn mɩmɩnʋ mama fwa. Yá yìə̀n tə mama, ʋ nə swɩ̀n bɛɛ wà tə yuu wa, tə ya cɩ́gá». ");
INSERT INTO nnw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kʋ bwálɩ́ təntə nə, lɩ̀à zənzən ken ba waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Betani tɩ̀án bɛɛ don, ba nə boŋə Lazarə, tʋa yayɩgʋ. Mə kʋ tɩʋ təntə wa nə, Mari, də ʋ zʋnʋ Marətə də yà wulə. Mari yà nə yɩ kan tə, ʋ nə lwə́ tɩralɩ Zwezi nɛɛ nə, ʋ ga ja ʋ yukʋran, ʋ ma pupugu tə. Ʋ mʋ̀ nabʋa yà nə yɩ Lazarə tə. ");
INSERT INTO nnw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazarə nakwana tə dàń ma tʋn lìù, sə ʋ swɩ̀n Zwezi con, ʋ wʋ́: «*Yuu-Tiu, nə̀ń, n dabaswənə tə tʋa yayɩgʋ». ");
INSERT INTO nnw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Zwezi nə nì kʋ yoo təntə, ʋ swɩ̀n, ʋ wʋ́: «Lazarə yayɩgʋ tə bá gʋ wá. Yayɩgʋ təntə ya Yɩɩ nə pɩ̀à, ʋ twá kʋ nə, ʋ ma bɩrɩ ʋ dun tə, sə ʋ pa, Yɩɩ-Biu tə na dun». ");
INSERT INTO nnw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yá Zwezi yà swə Marətə, də ʋ nyánʋ́ Mari, də Lazarə. ");
INSERT INTO nnw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Zwezi nə nì də, Lazarə yɩ̀ tə, ʋ tə fwa dɩan bələ bwálɩ́ təntə wa, ʋ yà nə wulə. ");
INSERT INTO nnw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kʋ kwa nə, ʋ swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Nə pirə, nə va Zwide nagwanaa tə wa». ");
INSERT INTO nnw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ʋ karbɩa tə ma le wá, ba wʋ́: «Karnyɩna, kʋ yɩ nətə? *Zwifə-ba yun tɩ̀án pɩ̀à, ba dɩlɩ mʋ́ də kapana, ba gʋ lá nə. Kʋ tə wà dɩ̀án, yá n ga tə pɩ̀à, sə n pìí n va lá?» ");
INSERT INTO nnw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Zwezi le ba, ʋ wʋ́: «Dɩɩn wa, lugu fugə bələ nə wulə lá. Lìù nə vəli yɩcaʋ wa, ʋ ba ʋ naa mà won nə. Lʋʋ kʋ tə yɩcaʋ tə dàń nə pɩn ʋ yɩ́á na lá. ");
INSERT INTO nnw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yá lìù nə kʋ́ʋ̀ ʋ lwàń, ʋ vəli tɩtɩn nə, ʋ yɩ́á nə ba poni na tə, ʋ yàá mà ʋ naa won nə». ");
INSERT INTO nnw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Zwezi nə swɩ̀n sʋ̀ràn təntə kwa nə, ʋ swɩ̀n ba con, ʋ wʋ́: «Nə dabɛɛ Lazarə yɩ ʋ dwɛ̀e, yá à mɛ, sə à va à zɩ̀n wá». ");
INSERT INTO nnw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ʋ karbɩa tə ma le wá, ba wʋ́: «Yuu-Tiu, də kʋ nə yɩ ʋ dwɛ̀e, ʋ yayɩgʋ tə wá zwɛ̀e». ");
INSERT INTO nnw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Zwezi yà pɩ̀à, sə ʋ swɩ̀n də, Lazarə yɩ ʋ tɩga. Yá ʋ karbɩa tə mʋ̀ yà bʋŋa də, kʋ cɩ́gá yɩ ʋ dwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Zwezi dàń ma swɩ̀n kʋ nəpon tə ba con, ʋ wʋ́: «Lazarə yɩ ʋ tɩga. ");
INSERT INTO nnw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","À jə pupwən də, á tətə nə yə̀ə́ də, à wà lá vəli tə yɩrɩ. Kʋ mʋ̀ nə wá pa, á kə á waa à nə. Nə dàń vələ ʋ con». ");
INSERT INTO nnw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma tə, ba yà nə boŋə ‹yɩyɔɔ›, ʋ dàń ma swɩ̀n ʋ karbiduən tə con, ʋ wʋ́: «Nə də vələ, nə twá karnyɩna nə, nə tɩ». ");
INSERT INTO nnw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Máŋá tə, Zwezi nə vəli ʋ yí lá, ʋ nɩ də, ba nə gùrì Lazarə, kʋ jə dɩan banɩa. ");
INSERT INTO nnw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani yà bwələ *Zwerizalɛmə, ndə kilomɛtərə batwa nə. ");
INSERT INTO nnw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yá Zwifə-ba tə yà dáá, ba nə twi Marətə də Mari con, sə ba kə ba pupuə ba nabʋa tə tɩan tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marətə dàń nə nì də, Zwezi bɩ̀àn, ʋ nan ʋ va, sə ʋ jə́rí wá. Mari mʋ̀ pìí sàń nə, ʋ jə̀ə́ ba dìə̀. ");
INSERT INTO nnw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marətə nə jə́rí Zwezi, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Yuu-Tiu, də n yà nə yɩn yəbə, à nabʋa tə yà ba tɩ. ");
INSERT INTO nnw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yá də kʋ mɛ, à yə̀ə́ də, máŋá kʋ tə də tətə wa, won tə mama, n nə lòrì Yɩɩ con, Yɩɩ wá pa kʋ mʋ́». ");
INSERT INTO nnw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «N nabʋa tə wá pìí ʋ bwin, ʋ nan tɩan wa». ");
INSERT INTO nnw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marətə le Zwezi, ʋ wʋ́: «À yə̀ə́ də, Yɩɩ wá bwin wá, ʋ lɩ tɩan wa. Kʋ yoo tə wá tʋn, máŋá tə wa, Yɩɩ nə wá bwin tɩga tə, ʋ lɩ tɩan wa, lʋʋ zaŋʋ máŋá nə». ");
INSERT INTO nnw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «À mʋ̀ nə yɩ ka bwin tɩga, à mʋ̀ ga nə yɩ mɩɩ tíú. Lìù tə, ʋ nə keni ʋ waa à nə wuuu, ʋ wá yà mɩɩ wa, də ʋ nə swə, ʋ tɩ də. ");
INSERT INTO nnw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yá lìù tə də, ʋ nə wulə mɩɩ wa, ʋ ga kə ʋ waa à nə, ʋ mʋ̀ kʋ́ʋ̀ bá tɩ, abada. N pɩn cɩ́gá kʋ yoo təntə nə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marətə le Zwezi, ʋ wʋ́: «Awo, Yuu-Tiu, à pɩn cɩ́gá yoo təntə nə də, n yɩ *Kərisə, n ga yɩ Yɩɩ-Biu. N mʋ̀ nə ya lìù tə, ʋ nə mɛ, sə ʋ bà lʋʋ wa». ");
INSERT INTO nnw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marətə nə swɩ̀n kʋ nətʋ tə kwa nə, ʋ pìí ʋ vìí. Ʋ dàń vəli, ʋ bon ʋ nyánʋ́ Mari, ʋ sə̀gə̀, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Karnyɩna twi yəbə, yá ʋ boŋə mʋ́». ");
INSERT INTO nnw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari nə nì tə sʋ̀ràn təntə, ʋ nyɩ́ ʋ zàn lala, ʋ ma vələ Zwezi con. ");
INSERT INTO nnw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Zwezi yà tə wulə bwálɩ́ tə nə, Marətə nə jə́rí wá. Ʋ yà tə wà Betani tɩʋ tə wa zwɩ. ");
INSERT INTO nnw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zwifə-ba yà twi dìə̀ tə wa, sə ba kə Mari pupwən. Ba dàń nɩ wá də, ʋ zàn lala, ʋ naŋa kàrá wa. Ba də ma zàn, ba pú ʋ kwa. Ba yà bʋŋa də, kʋ yɩ ʋ vəli ləbəri tə yuu, sə ʋ kwi. ");
INSERT INTO nnw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ʋ vəli ʋ yí bwálɩ́ tə, Zwezi nə wulə lá. Máŋá tə, ʋ nə nɩ wá, ʋ tʋa Zwezi nɛɛ də̀ń, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Yuu-Tiu, də n yà nə yɩn yəbə, à nabʋa tə yà ba tɩ». ");
INSERT INTO nnw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zwezi dàń nɩ də, Mari yɩ ʋ kwi, yá Zwifə-ba tə, ba nə wulə ʋ kwa, də ga kwi. Kʋ vuvugu ʋ bɩcan, yá pucʋnɩ ga zʋ wá. ");
INSERT INTO nnw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ʋ dàń ma bwe ba, ʋ wʋ́: «Yə̀n nə nə, á gùrì wá?» Ba le wá, ba wʋ́: «Yuu-Tiu bàá, n wá na kʋ bwálɩ́». ");
INSERT INTO nnw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Zwezi dàń wulə ʋ kwi. ");
INSERT INTO nnw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Zwifə-ba dàń ma swɩ̀n, ba wʋ́: «Á nɩ nətʋ tə, ʋ yà nə swə Lazarə». ");
INSERT INTO nnw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ba wa lɩ̀à duən də kʋ́ʋ̀ swɩ̀n, ba wʋ́: «Ʋ mʋ̀ lìù tə, ʋ nə pórí liliu tə yɩ́á tə, ʋ yà kʋ́ʋ̀ wàrɩ̀ ʋ fwa, sə bɛɛ wà tə dàn ká tɩ, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kʋ kʋ́ʋ̀ vuvugu Zwezi bɩcan, yá ʋ dàń ga vələ ləbəri tə nii nə. Ləbəri tə yà yɩ ba kʋa paan wa. Yá kapan dàń yà sun kʋ mimii nə. ");
INSERT INTO nnw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Zwezi swɩ̀n, ʋ wʋ́: «Á surə kapan tə!» Tɩgɩ tə nakʋa Marətə ma swɩ̀n Zwezi con, ʋ wʋ́: «Yuu-Tiu, ʋ dàń lwá sɩ́ʋ́n nə. Kʋ dɩan banɩa nə zə̀n, ba nə gùrì wá». ");
INSERT INTO nnw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Zwezi le wá, ʋ wʋ́: «À wà n con swɩ̀n də, n nə keni n waa à nə, n wá na Yɩɩ dun tə». ");
INSERT INTO nnw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ba dàń ma súrí kapan tə. Zwezi zɩ̀n ʋ yɩ́á ʋ kə yɩɩ nə, ʋ ga swɩ̀n, ʋ wʋ́: «À nyɩna, à kəni n lɛ̀eɛ̀e, n nə le nə tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","À mʋ̀ yə̀ə́ də, n le nə dɩɩn mama. Kʋ dàń yɩ lalʋʋ tə yɩrɩ, kʋ nə wulə yəbə nə, à swɩ̀n kʋ. À pɩ̀à, sə ba pa cɩ́gá də, kʋ yɩ n mʋ̀ nə tʋn nə». ");
INSERT INTO nnw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ʋ nə swɩ̀n kʋ nətʋ tə kwa nə, ʋ swɩ̀n də dɩ̀àn, ʋ kə yɩɩ nə, ʋ wʋ́: «Lazarə, nan yəbə!» ");
INSERT INTO nnw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tɩgɩ tə nan ləbəri tə wa, ʋ jɩ̀àn də ʋ nɛɛ ga vwə də gantwɛn. Yá gànʋ̀ də ga pú ʋ yáá nə. Zwezi ma swɩ̀n lɩ̀à tə con, ʋ wʋ́: «Á kʋra tə, sə ʋ vìí». ");
INSERT INTO nnw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","*Zwifə-ba wa lɩ̀à zənzən, ba yà nə twi Mari con, nɩ kʋ tə Zwezi nə fwa, ba ga kə ba waa ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yá ba wa lɩ̀à duən vəli, ba man kʋ tə, Zwezi nə fwa tə, ba bɩrɩ *Farɩzɩan-ba. ");
INSERT INTO nnw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Farɩzɩan-ba də Yɩɩ *joŋwana yun tɩ̀án tə dàń bon Zwifə-ba yun tɩ̀án duən, ba nə bʋ̀rɩ̀ *bʋ̀rà tə, ba kun duən nə, ba ga swɩ̀n, ba wʋ́: «Bɛɛ tə tʋŋa Yɩɩ dɩ̀àn mɩmɩnan zənzən. Bɛ̀eɛ̀e won nə, nə wá fwa ʋ yɩra? ");
INSERT INTO nnw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Də nə nə yá wá, sə ʋ tʋn tə, lɩ̀à tə mama wá kə ba waa ʋ nə. Yá *Romə-ba lɩ̀à wá bà, ba lɩ nəba, ba ga cʋ̀gʋ̀ nə Zwifə-bə Yɩɩ *dìə̀ tə, də nə dwíí tɩ̀án tə nə lʋʋ tə mama wa». ");
INSERT INTO nnw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Lìù don yɩn ba wa, ʋ nə yɩ Yɩɩ joŋwana yun tɩ̀án nəkwɩa, kʋ bɩnɩ təntə nə, ʋ yɩrɩ nə Kayifə. Ʋ swɩ̀n ba con, ʋ wʋ́: «Á ba yoo mama də̀ń nə̀ń. ");
INSERT INTO nnw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Á bʋŋa zəni, sə á yəni də, bɛɛ nədʋa nə tɩga nə dwíí tɩ̀án tə yɩrɩ, kʋ kʋkwa kʋ pa aba, kʋ doni, ba nə wá cʋ̀gʋ̀ nə dwíí tə mama». ");
INSERT INTO nnw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sʋ̀ràn təntə yà tà ʋ tətə fɩra sʋ̀ràn. Kʋ yɩ ʋ yà nə yɩ Yɩɩ joŋwana yun tɩ̀án nəkwɩa kʋ bɩnɩ təntə nə yɩrɩ. Kʋ mʋ̀ nə pɩn, Yɩɩ twá də wá, ʋ ma swɩ̀n ʋ nii sʋgʋ də, Zwezi mɛ, sə ʋ tɩ Zwifə-ba dwíí tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kʋ nətʋ tə yà tà ba cɩcɩ dwíí tə yɩrɩ nə, ʋ wá tɩ. Kʋ yɩ, sə ʋ pìí ʋ van Yɩɩ bɩa tə, ba nə laga duən yáá nə, ʋ ja bà, ʋ kə duən nə, ʋ pa ba jì dwíí nədʋ. ");
INSERT INTO nnw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kʋ nə zɩgɩ kʋ dɩɩn təntə nə, Zwifə-ba yun tɩ̀án tə ken ba nii nədʋ, sə ba gʋ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kʋ mʋ̀ nə pɩn, Zwezi yà kʋ́ʋ̀ bá jijiri, ʋ vəli Zwifə-ba pwərə wa. Ʋ nan kʋ bwálɩ́ təntə wa, ʋ zʋ nagwanaa don wa, kʋ nə bwələ də kasɔɔ lanworu. Ʋ mʋ̀ də ʋ karbɩa tə yà yɩn nagwanaa təntə tɩʋ don nə, ba nə boŋə ‹Efərayimə›. ");
INSERT INTO nnw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zwifə-ba *Pakə cànà tə yà bwələ. Lɩ̀à zənzən dàń nan nagwanaa təntə wa, ba va *Zwerizalɛmə də cànà tə tə wà yí, sə ba kwɛn ba yìə̀n ba mʋ̀ də Yɩɩ pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Lɩ̀à dàń yà twá lá, ba pɩ̀à Zwezi Zwifə-ba Yɩɩ dìə̀ tə wa, də ba bwe duən, ba wʋ́: «Bɛ̀eɛ̀e nə, á bʋŋa ʋ yoo wa? Á yə̀rì də, ʋ nə wá bà cànà tə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yɩɩ joŋwana yun tɩ̀án tə, də Farɩzɩan-ba yà pɩn nii kʋ tə də, lìù tə mama, ʋ nə yə̀ə́ Zwezi bwálɩ́, sə ʋ swɩ̀n kʋ ʋ bɩrɩ, ʋ pa ba yəni, sə ba va, ba ja wá. ");
INSERT INTO nnw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Zwezi vəli Betani, də *Pakə cànà tə ga dɩan bardʋ, sə ka yí. Mə Lazarə tə, ʋ nə tɩga, Zwezi ma bwin wá tə, yà wulə kʋ tɩʋ təntə nə. ");
INSERT INTO nnw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ba fwa wodiu, ba pa Zwezi nə. Marətə yà nə wulə, ʋ tàrɩ̀ wodiu tə. Lazarə də yɩn lɩ̀à tə wa, ba mʋ̀ də Zwezi nə jə̀ə́, ba də́. ");
INSERT INTO nnw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari dàń tì tɩralɩ nʋga litərə fan, kʋ kwənə nə dáá. Kʋ yɩ ba fwa kʋ də narədə paa tətə. Ʋ twɛ kʋ Zwezi nɛɛ nə, yá ʋ ga ja ʋ yukʋran, ʋ ma pupugu ʋ nɛɛ nə. Dìə̀ tə mama nii súə́ də tɩralɩ nʋga tə lwán tə. ");
INSERT INTO nnw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Karbiu don yɩn karbɩa tə wa, ba nə boŋə Yisəkariyɔtə Zwidasə. Mə ʋ mʋ̀ karbiu təntə, nə wá ja Zwezi, ʋ pa dʋŋa nə. Ʋ zàn ʋ swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Kʋ ya nətə, n ma wà tɩralɩ nʋga kʋ tə yoli səbikʋlan biətwa, sə n pa zʋra nə?» ");
INSERT INTO nnw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yá ʋ nə swɩ̀n kʋ nətʋ tə, kʋ tà zʋra yoo cɩ́gá nə jə wá. Kʋ yɩ ʋ ya ŋwɩ̀àn. Ʋ yà nə jə ba səbɩa lɔ̀ɔ̀ tə, ʋ yàá ŋwɩ̀n səbiu tə, ba nə kəni kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Zwezi dàń ma swɩ̀n Zwidasə con, ʋ wʋ́: «Yá wá sənbwen! Tɩralɩ nʋga kʋ tə yɩ, ʋ lwə́ à nə, sə kʋ ma kwɛn nə dɩɩn tə nə, ba nə wá kə nə ləbəri wa. ");
INSERT INTO nnw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Zʋra wulə də aba máŋá mama. Yá à mʋ̀ ga bá ya də aba máŋá mama». ");
INSERT INTO nnw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","*Zwifə-ba lalʋʋ nì də, Zwezi wulə Betani nə. Ba dàń vəli, ba yí lá, ba pɩ̀à Zwezi. Kʋ kʋ́ʋ̀ tà Zwezi cɩcɩ nə, ba pɩ̀à, sə ba na, kʋ dàń yɩ də Lazarə tə, Zwezi nə bwin ʋ zɩ̀n tɩan wa, nə ba pɩ̀à, sə ba na. ");
INSERT INTO nnw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Zwifə-ba lɩ̀à zənzən yà naŋa ba wa, ba kəni ba waa Zwezi nə, ʋ nə bwin Lazarə ʋ zɩn tɩan tə wa yɩrɩ. Kʋ mʋ̀ nə pɩn, Yɩɩ joŋwana yun tɩ̀án tə yà pɩn nii, sə ba gʋ Lazarə də. ");
INSERT INTO nnw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kʋ tɩpʋrɩ nə, lalʋʋ tə, kʋ nə twi *Pakə cànà tə, nì də, Zwezi wulə cwəŋə wa, ʋ ma bɩ̀àn *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba za kʋra nɛɛ ba ja nan, sə ba jə́rí wá, də ba bubwi, ba wʋ́: «Ozana! Sə dun tə mɛ ya lìù tə yuu wa, ʋ nə bɩ̀àn *Yuu-Tiu yɩrɩ tə yuu nə. Ʋ mʋ̀ lìù təntə nə yɩ *Yɩzərayɛlə pɩ̀ʋ́». ");
INSERT INTO nnw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Zwezi nɩ bɩnabiə, ʋ dɩ̀ ʋ jə̀ə́ ka yuu. Kʋ yoo təntə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Siyon tɩ̀án-ba, á dànà ká pa fən ja aba. Á nəŋə, á pɩ̀ʋ́ tə bɩ̀àn. Ʋ yɩ ʋ jə̀ə́ bɩnabiə yuu wa». ");
INSERT INTO nnw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kʋ máŋá təntə wa, Zwezi karbɩa tə yà wà yìə̀n təntə də̀ń lwarɩ. Zwezi nə bwin, ʋ nan tɩan wa, ʋ na dun Yɩɩ con, kʋ mʋ̀ təntə kwa nə, ba dàń lìí ba tɩ̀àn də, kʋ yɩ ʋ mʋ̀ yoo yà nə pʋ́pʋ́nɩ́, Yɩɩ sagɩ tə wa. Yá ʋ mʋ̀ dàń yɩ ʋ tʋn tə, sə sʋ̀ràn təntə nii sú. ");
INSERT INTO nnw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lalʋʋ, ba nə yɩn də Zwezi, máŋá tə wa, ʋ nə bon Lazarə ləbəri tə wa, ʋ bwin ʋ lɩ tɩan wa, yà wulə ba swɩ̀n kʋ yoo təntə, ba bɩrɩ lɩ̀à nə. ");
INSERT INTO nnw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Zwezi nə tʋn Yɩɩ dɩ̀àn mɩmɩnʋ təntə. Kʋ mʋ̀ nə pɩn, lɩ̀à tə, ba nə nì kʋ, ma bà, sə ba jə́rí wá. ");
INSERT INTO nnw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","*Farɩzɩan-ba dàń ma swɩ̀n duən con, ba wʋ́: «Á tətə na də, á wàrɩ̀ won mama á fwa. Á nəŋə, lalʋʋ tə mama púə́ ʋ kwa». ");
INSERT INTO nnw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","*Gərɛkə-ba lɩ̀à yà twá, ba wulə lɩ̀à tə wa, ba nə twi *Zwerizalɛmə, sə ba bʋ Yɩɩ nə *Pakə cànà tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ba vəli ba yí Filipə con, ʋ mʋ̀ nə nan Bɛtəsayɩda. Kʋ tɩʋ tə nə wulə Galile nagwanaa tə wa. Ba lòrì wá, ba wʋ́: «Yuu tíú, nə pɩ̀à, sə nə na Zwezi!» ");
INSERT INTO nnw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipə də ma va, ʋ swɩ̀n kʋ Andəre con. Ba lɩ̀à bələ tə mɛ dàń vəli, ba swɩ̀n kʋ Zwezi con. ");
INSERT INTO nnw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Zwezi ma le ba, ʋ wʋ́: «Máŋá dàń yí, sə *Ləzwənə-Biu tə na dun. ");
INSERT INTO nnw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Mɩbiu nə wà tɩa də̀ń zwɩ, sə kʋ pʋ, kʋ wá yà mɩbiu nədʋ cɩcɩ, wuuu. Yá kʋ nə pʋa, kʋ kwa nə, kʋ yàá fwa bɩa zənzən. ");
INSERT INTO nnw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Lìù tə, ʋ nə swə ʋ mɩɩ, ʋ wá kwɩ̀n kʋ nə. Yá lìù tə, ʋ tətə mɩɩ tə yoo nə ba wá ja, lʋʋ kʋ tə wa, ʋ ba kwɩ̀n ʋ mɩɩ tə nə. Ʋ wá yà mɩɩ tə wa, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Lìù tə, ʋ nə pɩ̀à, sə ʋ tʋn ʋ pa nə, sə ʋ pú à kwa. Kʋ nətʋ tə dàń wá pa bwálɩ́ tə, à nə wulə, à tʋ̀tʋ̀nʋ̀ tə də wá yà lá. Lìù tə, ʋ nə tʋŋa ʋ pɩn nə, à nyɩna Yɩɩ wá pa kʋ tíú na dun». ");
INSERT INTO nnw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zwezi kʋ́ʋ̀ súrí lá, ʋ wʋ́: «Sɩ́ʋ́n nə, à bɩcan yɩ gurəgurə. À dàń nə kʋ́ʋ̀ wá swɩ̀n bɛ̀eɛ̀e? À kʋ́ʋ̀ wàrɩ̀ à nyɩna Yɩɩ à lòrì, sə ʋ van nə ʋ lɩ càn tətə wa. Kʋ yɩ máŋá ka tə càn tə nə, à twi, sə à də́. ");
INSERT INTO nnw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","À dàń wá lòrì à nyɩna Yɩɩ, sə ʋ pa ʋ yɩrɩ tə na dun». Kori dàń ma swɩ̀n yɩɩ nə, kʋ wʋ́: «À dí yáá à bɩrɩ à dun tə, à tə wá kwɛn à bɩrɩ tə». ");
INSERT INTO nnw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lalʋʋ tə kʋ nə yɩn lá, nì kori təntə, ba dàń swɩ̀n, ba wʋ́: «Kʋ yɩ dwà nə baa». Ba duən də swɩ̀n, ba wʋ́: «Kʋ yɩ *malɩka nə swɩ̀n ʋ con». ");
INSERT INTO nnw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Zwezi dàń ma swɩ̀n, ʋ bɩrɩ ba, ʋ wʋ́: «Kʋ tà à mʋ̀ yɩrɩ nə, kori tə swɩ̀n. Kʋ yɩ á mʋ̀ yɩrɩ nə, kʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sɩ́ʋ́n nə, máŋá yí, sə Yɩɩ bʋ̀rɩ̀ ləzoni bʋ̀rà. Máŋá yí, sə Yɩɩ dɩŋɩ lʋʋ kʋ tə pɩ̀ʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yá kʋ nə yɩ à mʋ̀, máŋá tə wa, ba nə wá zɩ̀n nə yɩɩ nə, à wá van ləzoni mama, à kə à con». ");
INSERT INTO nnw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ʋ yà swɩ̀n kʋ nətʋ tə, sə ʋ ma bɩrɩ ʋ tɩan tə yiri, ʋ nə wá yà nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lalʋʋ tə ma le wá, kʋ wʋ́: «Yɩɩ sagɩ tə bɩrɩ nəba də, *Kərisə tə, ʋ mɛ, sə ʋ ya lá máŋá mama, wuuu, kʋ nə ba zwɛ̀e. Bɛ̀eɛ̀e nə pɩn, n dàń ma swɩ̀n, də kʋ mɛ, sə ba zɩ̀n *Ləzwənə-Biu tə, ba kə yɩɩ nə? Ləzwənə-Biu təntə nə yɩ wàà?» ");
INSERT INTO nnw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Zwezi ma le ba, ʋ wʋ́: «Poni tə wulə á tətəŋi wa, máŋá mancɩn wa. Á vələ poni tə wa, máŋá tə wa, kʋ nə tə wulə də aba, sə yikunu dàn ká bà tə dɩ̀ á yuu. Lìù tə, ʋ nə vələ yikunu wa, ʋ yə̀rì bwálɩ́ tə, ʋ nə vələ. ");
INSERT INTO nnw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Máŋá kʋ tə wa, poni tə nə tə wulə də aba, á mɛ, sə á sɛ̀e poni tə, sə kʋ pa á wànɩ́ á ya poni lɩ̀à». Zwezi nə swɩ̀n sʋ̀ràn təntə kwa nə, ʋ nan ʋ yá ba, ʋ va ʋ sə̀gə̀ ʋ tɩ̀àn bwálɩ́ don nə. ");
INSERT INTO nnw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Zwezi fwa Yɩɩ dɩ̀àn mɩmɩnan zənzən *Zwifə-ba yɩ́á yuu. Yá də kʋ mama ba tə vɩga, sə ba kə ba waa ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kʋ yɩn nətʋ, sə kʋ pa Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi sʋgʋ tə nii ma sú. Ʋ yà swɩ̀n, ʋ wʋ́: «*Yuu-Tiu, wàà nə pɩn cɩ́gá nə sʋgʋ tə nə, nə swɩ̀n nə bɩrɩ? Yuu-Tiu dɩ̀àn tə yɩ ʋ bɩrɩ tə wàà nə?» ");
INSERT INTO nnw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Zwifə-ba yà wàrɩ̀ cɩ́gá ba pɩn Yuu-Tiu sʋgʋ tə nə. Ezayi swɩ̀n kʋ yoo təntə, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Yɩɩ púə́ ba yɩ́á nə, ʋ ga pa ba pubʋŋa jén. Kʋ mʋ̀ nə pɩn, ba yɩ́á kʋ́ʋ̀ ba na. Ba pubʋŋa də wàrɩ̀ yoo də̀ń kʋ lwarɩ. Yá ba wàrɩ̀, ba lwanɩ pubʋŋɩ ba twi Yɩɩ con, sə ʋ jon ba ba yayɩran tə wa». ");
INSERT INTO nnw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezayi dí yáá, ʋ na Zwezi dun tə. Yá kʋ dàń yɩ ʋ mʋ̀ Zwezi yoo nə, ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Də kʋ nətʋ mɛ, Zwifə-ba yun tɩ̀án tə wa lɩ̀à zənzən ken ba waa Zwezi nə. Yá *Farɩzɩan-ba tə yɩrɩ nə, ba yà ba kʋ swɩ̀n ba nii wa, sə ba dàń ka dɩŋɩ ba *jə́rə́ dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kʋ bɩrɩ də, ba yà swə ləzoni dun, ba doni Yɩɩ dun. ");
INSERT INTO nnw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Zwezi bubwi, ʋ wʋ́: «Lìù tə, ʋ nə keni ʋ waa à nə, kʋ tà à mʋ̀ cɩcɩ nə, ʋ keni ʋ waa tə. Kʋ yɩ lìù tə, ʋ nə tʋn nə tə nə, ʋ keni ʋ waa tə wuuu. ");
INSERT INTO nnw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Lìù tə, ʋ nə nɩ nə, ʋ nɩ lìù tə də, ʋ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","À mʋ̀ twi lʋʋ kʋ tə wa, sə à ya poni à pa ləzoni nə. Lìù tə mama, ʋ nə keni ʋ waa à nə, ʋ dàn ká mé yikunu wa. ");
INSERT INTO nnw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Də lìù nə nì à sʋ̀ràn tə, yá ʋ ga ba tə nii nə twá, kʋ tà à mʋ̀ nə bʋ̀rɩ̀ ʋ bʋ̀rà, sə à cʋ̀gʋ̀ wá. À mʋ̀ tà à twi, sə à bʋ̀rɩ̀ lɩ̀à tə, lʋʋ nə tɩ, ba bʋ̀rà. Kʋ ya à twi, sə à jon lɩ̀à ba cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Lìù tə, ʋ nə vɩga nə, ʋ ga wà à sʋ̀ràn tə sɛ̀e, kʋ mʋ̀ yoo təntə nə wá bʋ̀rɩ̀ kʋ tíú bʋ̀rà. Sʋ̀ràn tə, à nə swɩ̀n tə, nə wá bʋ̀rɩ̀ ʋ bʋ̀rà lʋʋ zaŋʋ máŋá wa. ");
INSERT INTO nnw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","À nyɩna Yɩɩ nə tʋn nə. Ʋ mʋ̀ nə ken sʋ̀ràn tə, à nə wá swɩ̀n, də tətə à nə wá kàrɩ̀ à bɩrɩ, à nii wa. Kʋ mʋ̀ nə pɩn, à sʋ̀ràn tə tà à tətə fɩra sʋ̀ràn. ");
INSERT INTO nnw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yá à yə̀ə́ də, à nyɩna Yɩɩ nii tə, ʋ nə pɩn nə, nə pɩn mɩɩ tə, kʋ nə ba zwɛ̀e ʋ con. Kʋ mʋ̀ nə pɩn, kʋ tə à nə swɩ̀n, kʋ yɩ à swɩ̀n ndə nətʋ tə nə, à nyɩna Yɩɩ nə pɩn nii, sə à swɩ̀n kʋ». ");
INSERT INTO nnw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Də tɩa tə nə wà pʋrɩ, sə ba də́ *Pakə cànà tə, Zwezi yà dí yáá ʋ yə̀ə́ də, ʋ máŋá yí. Ʋ yà yə̀ə́ də, ʋ mɛ, sə ʋ yá lʋʋ kʋ tə, sə ʋ pìí ʋ va ʋ nyɩna Yɩɩ con. Zwezi yà sóní ʋ kwa lɩ̀à tə, ba nə wulə lʋʋ kʋ tə wa, yá ʋ tə sóní ba zənzən, ʋ ja lɛ. ");
INSERT INTO nnw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Zwezi də ʋ karbɩa tə yà jə̀ə́ duən nə, ba də́ wodiu. *Sɩtana mʋ̀ yà dí yáá, ʋ kə pubʋŋa Zwidasə Yisəkariyɔtə bɩcan wa, ʋ nə yɩ Simon bìú, sə ʋ pa Zwezi dʋŋa ja wá. ");
INSERT INTO nnw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zwezi yà yə̀ə́ də, ʋ yɩ ʋ nan ʋ nyɩna Yɩɩ con. Yá ʋ yɩ ʋ pìí ʋ vəli ʋ nyɩna Yɩɩ con. Ʋ yə̀ə́ də, ʋ nyɩna Yɩɩ ken wiən tə mɛ dɩ̀àn ʋ jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ʋ dàń nyɩ́ ʋ zàn wodiu tə yuu, ʋ kʋ̀rɩ̀ gànʋ̀ tə, ʋ nə zʋa yuu wa, ʋ tún. Kʋ kwa nə, ʋ tì pʋ̀pɔ̀ɔ́, ʋ vwa ʋ tàŋá nə. ");
INSERT INTO nnw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kʋ kwa nə, ʋ dàń twɛ nɩ́á ʋ kə tasaʋ wa, ʋ ga wulə ʋ sɩn ʋ karbɩa tə nɛɛ. Yá ʋ ja pʋ̀pɔ̀ɔ́ tə, kʋ nə vwə ʋ tàŋá nə, ʋ ma pupugə tə. ");
INSERT INTO nnw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ʋ dàń ma sɩn ba nɛɛ tə, ʋ va ʋ yí Simon Piyɛrə. Simon Piyɛrə ma swɩ̀n ʋ con, ʋ wʋ́: «N mʋ̀ *Yuu-Tiu, n bá sɩn à mʋ̀ nɛɛ tə!» ");
INSERT INTO nnw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zwezi ma le wá, ʋ wʋ́: «Sɩ́ʋ́n nə n tə yə̀rì kʋ tə, à nə fwa tə də̀ń. Yá n wá nì kʋ də̀ń, máŋá don wa». ");
INSERT INTO nnw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyɛrə ma swɩ̀n ʋ con, ʋ wʋ́: «Abada! N bá sɩn à mʋ̀ nɛɛ, mama!» Zwezi le wá, ʋ wʋ́: «Də à nə wà n nɛɛ tə sɩn, n bá ja tori à con». ");
INSERT INTO nnw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Piyɛrə ma swɩ̀n ʋ con, ʋ wʋ́: «Yuu-Tiu, kʋ kʋ́ʋ̀ tà à nɛɛ cɩcɩ nə, n wá sɩn, n dàń sɩn à jɩ̀àn tə, də à yuu tə mɛ». ");
INSERT INTO nnw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Zwezi le wá, ʋ wʋ́: «Lìù tə, ʋ nə swɛ nɩ́á, ʋ kʋ́ʋ̀ ba pɩ̀à, sə ba swɛ ʋ yɩra tə mama, də kʋ nə tà, ʋ nɛɛ ka sɩn. Ʋ yɩra tə mama ziən. Ʋ bɩcan yɩ nəpon Yɩɩ yáá con. Á bɩcan yɩ nəpon. Yá kʋ dàń nə tà á mama». ");
INSERT INTO nnw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ʋ yà yə̀ə́ lìù tə, ʋ nə wá ja wá, ʋ pa. Kʋ mʋ̀ nə pɩn, ʋ ma swɩ̀n də, kʋ tà ba mama bɩcan nə ya nəpon Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Máŋá tə wa, Zwezi nə sɩn ba nɛɛ tə, ʋ zwɛ̀e, ʋ tì ʋ ganan tə, ʋ zʋ, ʋ ga pìí ʋ va ʋ jə̀ə́ ʋ bwálɩ́ nə wodiu tə bɩan nə. Ʋ dàń ga swɩ̀n ba con, ʋ wʋ́: «Á yə̀ə́ kʋ tə, à nə fwa aba, tə də̀ń, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Á boŋə nə, á wʋ́: ‹karnyɩna›, nə à yə̀ə́ ‹Yuu-Tiu›. Kʋ yɩ cɩ́gá nə, á swɩ̀n. À yɩ karnyɩna, à ga yɩ Yuu-Tiu. ");
INSERT INTO nnw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Də à mʋ̀ lìù tə, à nə yɩ Yuu-Tiu, à nə yɩ karnyɩna, à dàń nə sɩn á nɛɛ, á də tətə dàń mɛ, sə á sɩn duən nɛɛ. ");
INSERT INTO nnw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kʋ tə à nə fwa tə, à fwa kʋ, sə kʋ ya nyɩnyɩga, kʋ pa aba, sə á də fwa kʋ duən yɩra, ndə à nə fwa kʋ á yɩra nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: *Tʋtʋnbiu ba ʋ yuu tíú dwə. Tʋntʋnʋ tə, ba nə tʋn, də ma ba lìù tə, ʋ nə tʋn wá, dwə. ");
INSERT INTO nnw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sɩ́ʋ́n nə, á dàń yə̀ə́ kʋ yoo təntə mama. Á fwa kʋ tə, à nə swɩ̀n á con, yá á wá yà pupwən wa». ");
INSERT INTO nnw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Kʋ tà á mama yoo nə à swɩ̀n, à yə̀ə́ lɩ̀à tə, à nə kúrí. Kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, nii mɛ, sə kʋ sú. Kʋ swɩ̀n, kʋ wʋ́: ‹Lìù tə, à mʋ̀ də wa nə wulə, nə də́ wodiu tə duən nə, kʋ tíú vəvəri ʋ zɩga à nə›. ");
INSERT INTO nnw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","À swɩ̀n kʋ yoo təntə á con də, kʋ máŋá tə wà yí. À pɩ̀à, kʋ nə yí, máŋá tə wa, sə á pa cɩ́gá də, à mʋ̀ nə yɩ lìù tə, à nə wulə, wuuu. ");
INSERT INTO nnw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə, ʋ nə sɛ̀e lìù tə, à nə tʋn, kʋ tíú sɛ̀e à tətə. Yá lìù ʋ nə sɛ̀e nə, kʋ tíú sɛ̀e lìù tə, ʋ nə tʋn nə». ");
INSERT INTO nnw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Zwezi nə swɩ̀n tə sʋ̀ràn təntə kwa nə, ʋ bɩcan gugurə, ʋ ga swɩ̀n yoo kʋ tə, ʋ bɩrɩ ba, ʋ wʋ́: «Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á wa lìù don wá ja nə, ʋ pa». ");
INSERT INTO nnw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Karbɩa tə jə̀ə́, ba ywàń duən yɛɛ wa, də ba bwe ba tɩ̀àn, sə ba jə́n, kʋ yɩ wàà yoo nə Zwezi swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Karbɩa tə wa karbiu tə, Zwezi yà nə swə tə, yà nə jə̀ə́ ʋ dà Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piyɛrə dàń ma gwɛn wá, sə ʋ bwe Zwezi ʋ jə́n kʋ yɩ wàà nə, ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Karbiu təntə ma guni ʋ kə Zwezi con, ʋ ga bwe wá, ʋ wʋ́: «*Yuu-Tiu, kʋ tíú nə yɩ wàà?» ");
INSERT INTO nnw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Zwezi le, ʋ wʋ́: «Kʋ tíú nə yɩ lìù tə, à nə wá kuli dipɛn kɩkaʋ zʋŋa tə wa, à lɩ à pa wá». Zwezi dàń ma tì dipɛn, ʋ kuli zʋŋa tə wa, ʋ lɩ ʋ pa Zwidasə Yisəkariyɔtə nə, ʋ nə yɩ Simon bìú. ");
INSERT INTO nnw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Máŋá tə, Zwidasə nə jon dipɛn kɩkaʋ tə, də *Sɩtana zʋa ʋ bɩcan wa. Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Kʋ tə, n nə pɩ̀à, sə n fwa tə, fwa kʋ lala!» ");
INSERT INTO nnw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lɩ̀à tə, ba yà nə jə̀ə́ wodiu tə bɩan nə ladʋa tətə yà wà kʋ tə, Zwezi nə swɩ̀n ʋ con, tə də̀ń lwarɩ. ");
INSERT INTO nnw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kʋ yɩ cɩ́gá, Zwidasə yà nə jə ba səbiu lɔ̀ɔ̀ tə. Kʋ mʋ̀ nə pɩn, ba wa lɩ̀à duən bʋŋa də, kʋ yɩ ndə Zwezi tʋn wá, sə ʋ va ʋ yə̀ cànà tə zɩla, nə à yə̀ə́, sə ʋ pa won zʋra tə nə. ");
INSERT INTO nnw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zwidasə nə jon dipɛn kɩkaʋ tə, mə ʋ ka nan də nə. Kʋ máŋá tə wa, də tɩa yí. ");
INSERT INTO nnw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zwidasə nə nan tə, kwa nə, Zwezi swɩ̀n, ʋ wʋ́: «Sɩ́ʋ́n nə, *Ləzwənə-Biu tə dàń wá na dun. Yá Yɩɩ wá twá wá, ʋ bɩrɩ ʋ dun tə. ");
INSERT INTO nnw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yɩɩ twá də wá, ʋ bɩrɩ ʋ dun tə, yá ʋ wá pa ʋ na dun tə, tə nə wulə ʋ mʋ̀ Yɩɩ con. Ʋ wá pa à na tə dun təntə, sɩ́ʋ́n sɩ́ʋ́n. ");
INSERT INTO nnw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","À bɩa-ba, à dàń yɩ à wulə də aba máŋá mancɩn wa. Kʋ kwa nə, á wá pɩ̀à nə. Sɩ́ʋ́n nə, à dàń swɩ̀n á də con, ndə à nə swɩ̀n *Zwifə-ba con də, bwálɩ́ tə, à nə vəli, á wàrɩ̀ lá, á vəli. ");
INSERT INTO nnw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","À pɩn aba *nii yìə̀n nədʋn: Á swənə duən. Kʋ mɛ, sə á sóní duən, ndə à nə sóní aba nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Də á nə swə duən, mə kʋ wá twá nətʋ, lɩ̀à mama ma lwarɩ də, á ya à mʋ̀ karbɩa». ");
INSERT INTO nnw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kʋ kwa nə, Simon Piyɛrə bwe Zwezi, ʋ wʋ́: «*Yuu-Tiu, yə̀n nə n vələ?» Zwezi ma le wá, ʋ wʋ́: «Bwálɩ́ tə, à nə vələ, n wàrɩ̀ à nə n twá, n vəli lá sɩ́ʋ́n. Máŋá don wa nə, n wá twá à nə n va». ");
INSERT INTO nnw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyɛrə ma swɩ̀n, ʋ wʋ́: «Yuu-Tiu, bɛ̀eɛ̀e nə pɩn, à ma wàrɩ̀ n nə à twá, à vəli lá, sɩ́ʋ́n? À ken à sírí, sə à tɩ n yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Zwezi le wá, ʋ wʋ́: «N ken n sírí cɩ́gá mama, sə n tɩ à yɩrɩ? Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: N wá swɩ̀n də, n yə̀rì nə, nɛɛ batwa, də cəbɩʋ tə wà kwi». ");
INSERT INTO nnw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Zwezi swɩ̀n ʋ karbɩa tə con, ʋ wʋ́: «Á dànà ká pa á bɩcan gugurə. Á kənə á waa Yɩɩ nə, sə á kə á waa à də nə. ");
INSERT INTO nnw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Dii dáá à nyɩna Yɩɩ sàń tə wa, á nə wàá tə wa á yanɩ. Də dìə̀ yà nə tə̀lə́ lá, à yà wá swɩ̀n kʋ á con. À dàń vəli, sə à kwɛn dìə̀ tə, á nə wá yà lá, à tún á nə. ");
INSERT INTO nnw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yá máŋá tə wa, à nə vəli, à kwɛn á bwálɩ́, à zwɛ̀e, à wá pìí à bà à tì aba, à ja va à con. Kʋ nətʋ tə dàń wá pa á də ya bwálɩ́ tə wa, à nə wulə. ");
INSERT INTO nnw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Á yə̀ə́ cwəŋə tə, ka nə vəli bwálɩ́ tə, à nə vələ». ");
INSERT INTO nnw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma ma swɩ̀n ʋ con, ʋ wʋ́: «*Yuu-Tiu, nə dàń nə yə̀rì bwálɩ́ tə, n nə vələ tətə. Nə wá fwa nətə, nə ma lwarɩ kʋ cwəŋə?» ");
INSERT INTO nnw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Zwezi le wá, ʋ wʋ́: «À mʋ̀ nə yɩ cwəŋə, à mʋ̀ nə yɩ cɩ́gá tíú, à mʋ̀ nə yɩ mɩɩ. Lìù mama wàrɩ̀ nyɩna Yɩɩ con, ʋ vəli, də ʋ nə wà à nə twá. ");
INSERT INTO nnw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Də á nə yə̀ə́ nə, á yə̀ə́ à nyɩna Yɩɩ də. Yá sɩ́ʋ́n tətə, á yə̀ə́ wá, á nɩ wá». ");
INSERT INTO nnw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipə ma swɩ̀n Zwezi con, ʋ wʋ́: «Yuu-Tiu, bɩrɩ nəba n nyɩna Yɩɩ tə, kʋ cɩcɩ mɛ nəba». ");
INSERT INTO nnw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zwezi ma swɩ̀n Filipə con, ʋ wʋ́: «Filipə, à wulə də aba, kʋ dɩan kʋ mɛ nətən, yá n tə yə̀rì nə, naaa? Lìù tə, ʋ nə nɩ nə, ʋ nɩ à nyɩna Yɩɩ. Bɛ̀eɛ̀e nə pɩn, n ma swɩ̀n də, à bɩrɩ aba à nyɩna Yɩɩ? ");
INSERT INTO nnw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","N wà cɩ́gá pɩn də, à ya à wulə də à nyɩna Yɩɩ, yá à nyɩna Yɩɩ də ga wulə də nə, naaa? Sʋ̀ràn tə, à nə swɩ̀n á con, kʋ tà à tətə pubʋŋa sʋ̀ràn. À nyɩna Yɩɩ tə, ʋ nə wulə də nə, ʋ mʋ̀ nə tʋŋa ʋ tətə tʋtʋnan. ");
INSERT INTO nnw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Á mɛ, sə á pa cɩ́gá də, à nə swɩ̀n, à wʋ́, à wulə də à nyɩna Yɩɩ, yá à nyɩna Yɩɩ də wulə də nə. Kʋ nə kʋ́ʋ̀ tà nətʋ, á mɛ, sə á pa nə cɩ́gá, tʋtʋnan tə yɩrɩ, à nə tʋŋa. ");
INSERT INTO nnw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Lìù tə, ʋ nə keni ʋ waa à nə, ʋ də wá fwa tʋtʋnan tə, à nə fwa. Ʋ wá fwa tʋtʋnan, tə nə dwə tə. À mʋ̀ dàń vəli à nyɩna Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yá won tə mama, á nə wá twá də à yɩrɩ tə, á lòrì, à wá tʋn kʋ, sə à nyɩna Yɩɩ wànɩ́ ʋ na dun, à mʋ̀ bìú tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Á nə twá də à yɩrɩ tə, á ma lòrì won mama, à wá tʋn kʋ». ");
INSERT INTO nnw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ súrí, ʋ wʋ́: «Də á nə swə nə, á wá zìlí à nii yìə̀n tə. ");
INSERT INTO nnw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","À wá lòrì à nyɩna Yɩɩ, sə ʋ pa lìù tə, ʋ nə wá san aba, bà, ʋ ya də aba, máŋá mama, wuuu. ");
INSERT INTO nnw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kʋ mʋ̀ nə yɩ Yɩɩ-*Siŋu tə, kʋ nə bɩrɩ ʋ cɩ́gá tə. Lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, ba wàrɩ̀ kʋ ba nɩ, ba ma wàrɩ̀ kʋ ba lwàrɩ̀. Kʋ mʋ̀ nə pɩn, ba wàrɩ̀ kʋ ba sɛ̀e. Kʋ wulə də á mʋ̀, yá kʋ wá yà də aba. Kʋ mʋ̀ nə pɩn, á mʋ̀ yə̀ə́ kʋ. ");
INSERT INTO nnw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","À bá yá aba ndə bitaran nə, à wá pìí à bà á con. ");
INSERT INTO nnw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Máŋá mancɩn wa, lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, ba kʋ́ʋ̀ wàrɩ̀ nə ba nɩ. À wulə mɩɩ wa, yá á də wá yà mɩɩ wa. Kʋ mʋ̀ nə pɩn, á mʋ̀ wá na nə. ");
INSERT INTO nnw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kʋ dɩɩn tə nə, á wá lwàrɩ̀ də, à mʋ̀ wulə də à nyɩna Yɩɩ. Á mʋ̀ wá yà də nə, à də ga wá yà də aba. ");
INSERT INTO nnw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Lìù tə, ʋ nə tún à *nii yìə̀n tə ʋ bɩcan wa, ʋ ga zìlí tə nii, kʋ tíú swə nə, cɩ́gá cɩ́gá. À nyɩna Yɩɩ wá sóní lìù tə, ʋ nə swə nə. À də wá sóní wá, yá à wá bɩrɩ à tɩ̀àn wá». ");
INSERT INTO nnw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ʋ karbiu tə don, ba nə boŋə Zwidə, kʋ nə tà Zwidasə Yisəkariyɔtə, ma bwe wá, ʋ wʋ́: «*Yuu-Tiu, bɛ̀eɛ̀e nə pɩn, n ma pɩ̀à, sə n bɩrɩ n tɩ̀àn nəba, yá n ga bá bɩrɩ n tɩ̀àn lɩ̀à tə nə, ba nə yɩ lʋʋ nə tɩ?» ");
INSERT INTO nnw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Zwezi le wá, ʋ wʋ́: «Lìù tə, ʋ nə swə nə, ʋ wá zìlí à sʋgʋ tə nii. Yá à nyɩna Yɩɩ wá sóní wá. À mʋ̀ də à nyɩna Yɩɩ mɛ dàń wá bà ʋ con, nə ya də wá. ");
INSERT INTO nnw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Lìù tə, ʋ nə ba nə swə, ʋ ba à sʋ̀ràn tə nii zìlí. Kʋ tə á nə nə̀ń də, à swɩ̀n nətən, kʋ tà à tətə sʋgʋ. Kʋ yɩ kʋ nan à nyɩna Yɩɩ con, ʋ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","À swɩ̀n kʋ yoo təntə á con də, à tə wulə də aba. ");
INSERT INTO nnw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lìù tə, ʋ nə wá san aba, à nyɩna Yɩɩ nə wá twá də à yɩrɩ tə, ʋ tʋn, kʋ mʋ̀ nə yɩ Yɩɩ-Siŋu tə. Kʋ nə twi, kʋ mʋ̀ nə wá kàrɩ̀ aba yoo mama. Yá kʋ wá lìí aba yìə̀n tə mama, à nə swɩ̀n á con. ");
INSERT INTO nnw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","À yá bɩcan sìə́ də aba, à pɩn aba à tətə bɩcan sìə́ tə. Bɩcan sìə́ tə, à nə pɩn aba, kʋ tà ndə bɩcan sìə́ tə nə, lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, nə pɩn nətʋ. Á dànà ká pa á bɩcan gugurə, á dànà ká pa fən ja aba. ");
INSERT INTO nnw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Á nì, də à nə swɩ̀n á con, à wʋ́: À vìrí yá à wá pìí à bà á con. Də á nə swə nə, á pùə́ mɛ, sə ka poli, à nə vələ à nyɩna Yɩɩ con, tə yɩrɩ. Cɩ́gá, à nyɩna Yɩɩ nə dwə nə. ");
INSERT INTO nnw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","À swɩ̀n tə yìə̀n təntə á con sɩ́ʋ́n nə də, tə máŋá tə wà yí, sə kʋ pa máŋá tə wa, tə nə yí, sə á pa cɩ́gá à sʋgʋ tə nə. ");
INSERT INTO nnw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Lʋʋ kʋ tə pɩ̀ʋ́ tə ma bɩ̀àn. Yá ʋ ba dɩ̀àn mama jə à mʋ̀ yuu wa. Kʋ mʋ̀ nə pɩn, à kʋ́ʋ̀ bá pìí à swɩ̀n á con zənzən. ");
INSERT INTO nnw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yá kʋ mɛ, sə lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, lwàrɩ̀ də, à swə à nyɩna Yɩɩ, yá à ga tʋŋa nətʋ tə, ʋ nə pɩn nə nii, sə à tʋn. Á zaŋa yɩɩ nə, sə nə vìí bwálɩ́ kʋ tə wa». ");
INSERT INTO nnw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ súrí lá, ʋ wʋ́: «À mʋ̀ nə yɩ cɩ́gá cɩ́gá divɛn tɩ̀ʋ́. Yá à nyɩna Yɩɩ tə dàń nə yɩ kʋ tíú. ");
INSERT INTO nnw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naa mama nə wulə à yɩra, ka nə ba bɩa zɩŋa, ʋ yàá gwəŋə ka, ʋ lɩ. Yá naa tə mama, ka nə zɩŋa bɩa, ʋ yàá tá ka, sə ka kwɛn ka zɩn bɩa zənzən, ka súrí lá. ");
INSERT INTO nnw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kàrà tə, à nə kàrɩ̀ aba, ka dí yáá, ka pɩ̀rɩ̀ á bɩcan tə Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Á dàń mara à yɩra, ndə à nə marɩ á yɩra nətʋ. Tɩ̀ʋ́ naa wàrɩ̀ bɩa ka zɩŋa ka tɩ̀àn nə, də ka nə wà tɩ̀ʋ́ tə dəkuu yɩra marɩ. Mə nətʋ á də wàrɩ̀ bɩa á zɩŋa á tɩ̀àn nə, də á nə wà à yɩra marɩ. ");
INSERT INTO nnw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","À mʋ̀ yɩ ndə divɛn tɩ̀ʋ́ dəkuu nə, á mʋ̀ dàń nə yɩ kʋ nɛɛ tə. Naa tə ka nə marɩ à yɩra, à də ga marɩ ka yɩra, ka yàá zən bɩa zənzən. Á wàrɩ̀ won mama á fwa, də à nə tə̀lə́ də aba. ");
INSERT INTO nnw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Lìù tə, ʋ nə wà à yɩra marɩ, ʋ yɩ ndə tɩ̀ʋ́ tə naa nə, ba nə gwəŋə ba dʋgʋ. Yá ka wá kʋ̀. Kʋ kwa nə, ba wá pɛ̀e ka dɛɛ tə wakʋran təntə, ba kə mən wa, sə tə də́. ");
INSERT INTO nnw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Də á nə marɩ à yɩra, yá à sʋ̀ràn tə də ga wulə á bɩcanɩ wa, á lwərə kʋ tə mama, á nə pɩ̀à, yá á wá na kʋ. ");
INSERT INTO nnw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Á nə zɩn bɩa zənzən, á ma bɩrɩ də, á ya à karbɩa, kʋ mʋ̀ nə wá pa dun à nyɩna Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","À swə aba, ndə à nyɩna Yɩɩ nə sóní nə nətʋ. Á dàń pɩan à sonu tə ya á waa. ");
INSERT INTO nnw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Də á nə zìlí à *nii yìə̀n tə, à sonu tə wá yà á waa. Mə nətʋ nə à də zìlí à nyɩna Yɩɩ nii, yá ʋ sonu tə ga wulə à waa. ");
INSERT INTO nnw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","À swɩ̀n kʋ nətʋ tə á con, sə kʋ pa à pupwən tə ya də aba. Yá kʋ wá pa á pupwən tə ya cɩ́gá cɩ́gá pupwən. ");
INSERT INTO nnw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Á nəŋə, à nii yìə̀n nə, à nə pɩn aba: Á swənə duən, ndə à nə sóní aba nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lìù mama con, sonu don kʋ́ʋ̀ tə̀lə́ kʋ, də nə dwə lìù nə tì ʋ mɩɩ, ʋ ma lárɩ́ ʋ dabara mɩa yuu nə. ");
INSERT INTO nnw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Á ya à dabara, də á nə fwa kʋ tə, à nə pɩn nii, sə á fwa. ");
INSERT INTO nnw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","À kʋ́ʋ̀ bá bon aba tʋtʋnbɩa. Tʋtʋnbiu yə̀rì kʋ tə, ʋ tʋtʋnyɩna tə nə fwa. À pɩn á lwarɩ kʋ tə mama, à nyɩna Yɩɩ nə bɩrɩ nə. Kʋ mʋ̀ nə pɩn, à dàń boŋə aba à dabara. ");
INSERT INTO nnw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","À mʋ̀ nə kúrí aba, á mʋ̀ nə wà nə kúrí. À mʋ̀ nə pɩn nii aba, sə á va á zɩn bɩa. Á bɩa tə mɛ, sə ba ya lá, wuuu. Yá won tə mama, á nə twá də à yɩrɩ tə, á ma lòrì à nyɩna Yɩɩ con, ʋ wá pa kʋ aba. ");
INSERT INTO nnw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","À nii tə, à nə pɩn aba, kʋ yɩ, sə á sóní duən». ");
INSERT INTO nnw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ súrí lá: «Də lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, nə dʋŋa aba, á mɛ, sə á lwarɩ də, ba dí yáá ba dʋ́n à tətə. ");
INSERT INTO nnw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Də á yà nə yɩ lɩ̀à tə, lʋʋ nə tɩ aba, ba yà wá sóní aba, á nə yɩ ba mʋ̀ lɩ̀à tə yɩrɩ. À kúrí aba, à van à lɩ ba waa, á tà ba mʋ̀ waa lɩ̀à. Kʋ mʋ̀ nə pɩn, ba ba aba swə. ");
INSERT INTO nnw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Á lie á tɩ̀àn də sʋgʋ tə, à nə swɩ̀n á con: Tʋtʋnbiu ba ʋ tʋtʋnyɩna dwə. Də ba nə fɩfɩn nə, ba wá fɩfɩn á də. Ba nə zìlí à sʋgʋ tə nii, ba wá zìlí á də sʋgʋ tə nii. ");
INSERT INTO nnw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba yə̀rì lìù tə, ʋ nə tʋn nə. Kʋ mʋ̀ nə pɩn, ba wá fwa tə yìə̀n təntə mama á yɩra, à mʋ̀ yɩrɩ nə. ");
INSERT INTO nnw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ba yuu yà bá jə cʋna, də à yà nə wà twi, də à yà nə wà ba con swɩ̀n. Yá sɩ́ʋ́n nə, ba kʋ́ʋ̀ wàrɩ̀ ba swɩ̀n də, ba yə̀rì ba cʋna yoo. ");
INSERT INTO nnw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Lìù tə, ʋ nə dʋŋa nə, ʋ dʋŋa à nyɩna Yɩɩ də. ");
INSERT INTO nnw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Də à yà nə wà tʋtʋnan tʋn, ba tətəŋi wa, lìù don nə wà tə yiri ʋ tʋn, ba yuu yà ba cʋna jə. Sɩ́ʋ́n nə, ba nɩ tʋtʋnan təntə, ba ga tə dʋŋa nə, ba dʋŋa à nyɩna Yɩɩ də. ");
INSERT INTO nnw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kʋ yɩ nətʋ, sə kʋ pa tə nə pʋ́pʋ́nɩ́ ba Yɩɩ sagɩ tə wa, nii sú. Kʋ pʋ́pʋ́nɩ́, kʋ wʋ́: ‹Ba dʋŋa nə, yá kʋ ba də̀ń jə›. ");
INSERT INTO nnw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","À wá pa, à nyɩna Yɩɩ pa lìù tə, ʋ nə wá san aba, bà á con. Ʋ mʋ̀ lìù təntə nə yɩ Yɩɩ-*Siŋu tə. Ʋ yɩ ʋ nan à nyɩna Yɩɩ con. Ʋ mʋ̀ nə wá bɩrɩ aba cɩ́gá tə, ʋ ga wá swɩ̀n à yoo. ");
INSERT INTO nnw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Á də yɩn də nə, kʋ jɩjʋ mama. Kʋ mʋ̀ nə pɩn, á də wá swɩ̀n à yoo, á bɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Zwezi kʋ́ʋ̀ swɩ̀n ʋ súrí lá, ʋ wʋ́: «À dí yáá, à swɩ̀n yìə̀n təntə á con, sə tə máŋá nə yí, á dànà ká pìí á kə á kwa, á yá nə. ");
INSERT INTO nnw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba wá dɩŋɩ aba, ba lɩ *Zwifə-ba *jə́rə́ dii tə wa. Máŋá don tətə wá bà, lìù tə mama, ʋ nə wànɩ́ ʋ gʋ aba, ʋ tə wá bʋ́n də, kʋ yɩ yozəŋu nə, ʋ fwa ʋ pa Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba wà nə yəni, ba ga wà à nyɩna Yɩɩ yəni. Kʋ mʋ̀ nə pɩn, ba wá fwa nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","À swɩ̀n kʋ nətʋ tə á con, sə kʋ máŋá nə yí, sə á pìí á lìí á tɩ̀àn də, à dí yáá à swɩ̀n kʋ á con. À wà kʋ yoo təntə swɩ̀n á con, kʋ jɩjʋ tə mama, à yà nə tə wulə də aba tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ súrí lá, ʋ wʋ́: «Sɩ́ʋ́n nə, à pìí à vələ lìù tə con, ʋ nə tʋn nə. Yá á ladʋa tətə ba nə bwe, sə ʋ jə́n, à vələ yə̀n. ");
INSERT INTO nnw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","À nə swɩ̀n kʋ nətʋ tə á con, kʋ mʋ̀ nə pɩn, á pùə́ cʋ̀gà zənzən. ");
INSERT INTO nnw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kʋ ga yɩ cɩ́gá nə, à swɩ̀n á con. À nə vìí, kʋ mʋ̀ nə wá san aba. Də à nə wà vìí, lìù tə, ʋ nə wá bà ʋ san aba, bá bà. Yá à nə vìí, à wá pa ʋ bà á con. ");
INSERT INTO nnw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Máŋá tə wa, ʋ mʋ̀ lìù tə, ʋ nə wá san aba, nə twi. Ʋ wá bɩrɩ lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, cʋna nə yɩ nətʋ, kʋ tə nə yɩ Yɩɩ cɩ́gá tə, də nətʋ, Yɩɩ nə wá bʋ̀rɩ̀ lɩ̀à bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ba wà ba waa ken à nə. Kʋ mʋ̀ nə pɩn, ba dwé duən ba cʋna tə yoo wa. ");
INSERT INTO nnw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","À vələ à nyɩna Yɩɩ con, yá á kʋ́ʋ̀ bá pìí á na nə. Kʋ mʋ̀ nə pɩn, ba dwé duən Yɩɩ cɩ́gá tə yoo wa. ");
INSERT INTO nnw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yɩɩ dí yáá ʋ bʋ̀rɩ̀ lʋʋ kʋ tə pɩ̀ʋ́ tə bʋ̀rà. Kʋ mʋ̀ nə pɩn, ba dwé duən Yɩɩ bʋ̀rà tə yoo wa. ");
INSERT INTO nnw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","À tə jə yìə̀n duən zənzən, sə à swɩ̀n á con. Á dàń nə tə wàrɩ̀ tə á janɩ. ");
INSERT INTO nnw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Máŋá tə, Yɩɩ-*Siŋu tə, kʋ nə bɩrɩ cɩ́gá tə, nə twi, kʋ mʋ̀ nə wá bɩrɩ aba Yɩɩ cɩ́gá tə mama. Kʋ bá swɩ̀n kʋ tətə sʋ̀ràn. Kʋ ya yìə̀n tə mama, kʋ nə dí yáá kʋ nì, də tə wá bà nə kʋ wá swɩ̀n kʋ bɩrɩ aba. ");
INSERT INTO nnw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kʋ wá jon kʋ tə nə ya à mʋ̀ nyiən, kʋ swɩ̀n kʋ bɩrɩ aba. Yá kʋ dàń wá pa, à na dun. ");
INSERT INTO nnw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Won tə mama, à nyɩna Yɩɩ nə jə, kʋ ya à də nyiən. Kʋ mʋ̀ nə pɩn, à ma swɩ̀n á con də, Yɩɩ-Siŋu tə wá jon kʋ tə nə ya à mʋ̀ nyiən, kʋ swɩ̀n kʋ bɩrɩ aba». ");
INSERT INTO nnw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zwezi kʋ́ʋ̀ swɩ̀n, ʋ súrí lá, ʋ wʋ́: «À mʋ̀ vəli à nyɩna Yɩɩ con. Kʋ wá fwa mancɩn, də á kʋ́ʋ̀ wàrɩ̀ nə á nɩ. Kʋ kwa nə mancɩn, də á kʋ́ʋ̀ wá pìí á na nə». ");
INSERT INTO nnw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zwezi karbɩa tə duən dàń swɩ̀n duən con, ba wʋ́: «Bɛ̀eɛ̀e nə ʋ pɩ̀à, sə ʋ swɩ̀n nə con də, ʋ mʋ̀ wá va ʋ nyɩna Yɩɩ con? Yá kʋ wá fwa mancɩn, də nə kʋ́ʋ̀ wàrɩ̀ wá nə nɩ. Kʋ kwa nə mancɩn, nə kʋ́ʋ̀ wá pìí, nə na wá?» ");
INSERT INTO nnw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ʋ karbɩa tə swɩ̀n, ba wʋ́: «Zwezi nə swɩ̀n nə con də, máŋá mancɩn, nə ba pìí nə na wá, kʋ nətʋ tə də̀ń ya bɛ̀eɛ̀e? Nə yə̀rì kʋ tə, ʋ nə pɩ̀à, sə ʋ swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zwezi yà yə̀ə́ də, ba pɩ̀à ba bwe wá kʋ də̀ń nə. Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «À swɩ̀n kʋ á con də, kʋ wá fwa mancɩn, də á kʋ́ʋ̀ wàrɩ̀ nə á nɩ. Kʋ kwa nə mancɩn, á kʋ́ʋ̀ wá pìí, á na nə. Kʋ mʋ̀ də̀ń nə nə, á bwe duən, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Á wá kwi, á pùə́ cʋ̀gʋ̀, yá lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ, ba mʋ̀ ga wulə ba jwɛ. Pucʋnɩ wà yí aba, yá á pucʋnɩ tə wá lwàń, kʋ jì pupwən. ");
INSERT INTO nnw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kʋ yɩ ndə máŋá tə, kan nə pɩ̀à ʋ lʋra, kʋ nə ya càn kʋ nə pa wá nətʋ. Yá máŋá tə, ʋ nə lʋrɩ bisɩmaa tə, kʋ kwa nə, ʋ yàá sú də pupwən, ʋ nə lʋrɩ ləzwənə, ʋ kə lʋʋ wa tə yɩrɩ. Kʋ mʋ̀ nə pɩn, ʋ yàá swɛ̀eé ʋ càn tə yoo. ");
INSERT INTO nnw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mə kʋ yɩ nətʋ á də con. Á wulə càn wa sɩ́ʋ́n, yá à wá pìí à na aba. Kʋ máŋá tə wa, á dàń wá yà pupwən wa. Yá lìù mama ga bá wànɩ́ ʋ cɩ̀ á pupwən tə yáá nə. ");
INSERT INTO nnw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kʋ dɩɩn təntə nə, á kʋ́ʋ̀ bá bwe nə yoo mama. Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ á con: Won tə mama, á nə wá lòrì à nyɩna Yɩɩ con, ʋ wá pa kʋ aba, à mʋ̀ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Də zə̀n mama, á tə wà à yɩrɩ tə nə twá á lòrì won mama. Á lwərə, yá á wá na, sə kʋ pa á pupwən tə sú. ");
INSERT INTO nnw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","À twá də zwansɩsarɩ, à ma swɩ̀n yìə̀n tə tə á con. Máŋá bɩ̀àn, à nə kʋ́ʋ̀ bá twá də zwansɩsarɩ, à ma swɩ̀n á con. À dàń wá bɩrɩ aba kʋ tə mama, kʋ nə yɩ à nyɩna Yɩɩ yoo, nəpon nəpon. ");
INSERT INTO nnw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Máŋá təntə nə yí, á wá twá də à yɩrɩ tə, á ma lòrì à nyɩna Yɩɩ con. Kʋ tà à pɩ̀à à swɩ̀n də, à wá lòrì à nyɩna Yɩɩ à pa aba. À nyɩna Yɩɩ tətə swə aba, á nə swə nə, á ga pa cɩ́gá də, à ya à nan ʋ con tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","À ya à nan à nyɩna Yɩɩ con, à bà lʋʋ wa. Sɩ́ʋ́n nə, à kʋ́ʋ̀ naŋa lʋʋ wa, à vələ à nyɩna Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ʋ karbɩa tə dàń ma swɩ̀n ʋ con, ba wʋ́: «Á nəŋə, kʋ nə sɩ́ʋ́n nə, n dàń swɩ̀n nəpon nəpon nə con. N kʋ́ʋ̀ ba zwansɩsarɩ nə twá, n ma swɩ̀n nə con. ");
INSERT INTO nnw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sɩ́ʋ́n nə, nə dàń yə̀ə́ də, n yə̀ə́ yìə̀n tə mama, yá n bá pɩ̀à, sə ba bwe mʋ́ bwiə. Kʋ mʋ̀ nə pɩn, nə ma pa cɩ́gá də, n nan Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Zwezi ma swɩ̀n, ʋ wʋ́: «Sɩ́ʋ́n nə, á dàń pɩn cɩ́gá, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Á nəŋə, máŋá don bɩ̀àn, ka yí ka zwɛ̀e tətə. Á wá dəri á jén duən yáá nə. Á lìù mama wá pɩ̀à bwálɩ́ ʋ va. Á wá yá à cɩcɩ. Kʋ máŋá tə wa, à ga tà à cɩcɩ. À nyɩna Yɩɩ wulə də nə. ");
INSERT INTO nnw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","À swɩ̀n kʋ nətʋ tə á con, sə kʋ pa á ya bɩcan sìə́ wa, à mʋ̀ də á mʋ̀ nimarʋ tə yɩrɩ. Á wá də́ càn lʋʋ kʋ tə wa. Á dàń nə daŋa á bɩcan, à mʋ̀ dí dɩ̀àn lʋʋ yuu wa». ");
INSERT INTO nnw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Zwezi nə swɩ̀n kʋ nətʋ tə, ʋ zwɛ̀e, ʋ zɩ̀n ʋ yáá, ʋ kə yɩɩ nə, ʋ ga swɩ̀n, ʋ wʋ́: «À nyɩna Yɩɩ, máŋá yí. Pa à mʋ̀, n bìú tə na dun. Sə n bìú tə də wànɩ́ ʋ bɩrɩ n dun tə. ");
INSERT INTO nnw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","N ken dɩ̀àn nə cwəŋə n bìú tə jɩɩn wa, sə ʋ ya ləzwənə mama yuu wa, sə ʋ wànɩ́ ʋ pa mɩɩ tə, kʋ nə ba zwɛ̀e n mʋ̀ con, lɩ̀à tə mama nə, n nə pɩn wá. ");
INSERT INTO nnw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mɩɩ tə, kʋ nə ba zwɛ̀e, tə nə ya, sə ba lwarɩ, n mʋ̀ Yɩɩ nədʋ tə, n nə yɩ cɩ́gá, də lìù tə n nə tʋn tə, kʋ mʋ̀ nə yɩ Zwezi-*Kərisə. ");
INSERT INTO nnw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","À pɩn, n na dun tɩa yuu yəbə. À tʋn n tʋtʋŋɩ tə, n nə pɩn nə, sə à tʋn tə, à zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","À yà jə̀ə́ n səpuni nə dun wa, də lʋʋ nə tə wà fwa. À nyɩna Yɩɩ, sɩ́ʋ́n nə, n dàń pa, sə à pìí à na à dun təntə n səpuni nə. ");
INSERT INTO nnw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ləzoni tə, ba nə yɩ lʋʋ nə tɩ ba, n tì ba wa lɩ̀à, n pa nə. À pɩn, ba lwàrɩ̀ n mʋ̀ Yɩɩ. Ba yà yɩ n mʋ̀ nə tɩ, ba zìlí n sʋgʋ tə nii. ");
INSERT INTO nnw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ba dàń lwarɩ də, won tə mama, n nə pɩn nə yɩ kʋ nan n con. ");
INSERT INTO nnw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sʋ̀ràn tə, n nə pɩn nə, à swɩ̀n tə ba con, yá ba ga sɛ̀e, ba jon tə. Ba lwarɩ də, à cɩ́gá nan n mʋ̀ con, ba ga pa cɩ́gá də, kʋ yɩ n mʋ̀ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","À lòrì mʋ́ à pɩn ba. À ba mʋ̀ lòrì lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, yɩrɩ. Kʋ yɩ à lòrì mʋ́ lɩ̀à tə yɩrɩ, n nə pɩn nə, ba nə yɩ n mʋ̀ nyiən. ");
INSERT INTO nnw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Won tə mama, kʋ nə yɩ à mʋ̀ nyiən, kʋ yɩ n mʋ̀ nyiən. Kʋ tə ga nə yɩ n mʋ̀ nyiən, kʋ yɩ à də nyiən. Yá ba mʋ̀ lɩ̀à təntə, ba nə yɩ n mʋ̀ nyiən, nə bɩrɩ à dun tə. ");
INSERT INTO nnw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","À mʋ̀ kʋ́ʋ̀ tə̀lə́ lʋʋ wa. Ba mʋ̀ tə ga wulə lʋʋ wa. À mʋ̀ wá bà n con. À nyɩna Yɩɩ, n ba man don ja. N pɩn nə n yɩrɩ tə. À twá n yɩrɩ təntə dɩ̀àn tə nə, à cɩ̀ n lɩ̀à tə nə. Pa, sə ba ya nədʋ, ndə à mʋ̀ də mʋ́ nə yɩ nədʋ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Máŋá tə, à nə yɩn də ba, à yà cɩ̀ ba tə nə, n nə pɩn nə, də n yɩrɩ tə dɩ̀àn tə. Lɩ̀à təntə, n nə pɩn nə, à cɩ̀gà ba nə, yá ba lìù mama wà jén, də kʋ nə tà lìù tə, ʋ nə mɛ, sə ʋ jén. Kʋ yí nətʋ, sə kʋ tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, nii ma sú. ");
INSERT INTO nnw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sɩ́ʋ́n nə, à bɩ̀àn n mʋ̀ con. À swɩ̀n sʋ̀ràn təntə lʋʋ wa, sə kʋ pa, n lɩ̀à tə na à pupwən tə. Sə kʋ mʋ̀ pupwən tə sú ba, cɩ́gá cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","À swɩ̀n n sʋgʋ tə, à bɩrɩ ba. Lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, dʋ́n ba, ba nə tà ba lɩ̀à tə yɩrɩ, ndə à nə tà ba lìù tə nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kʋ tà à lòrì mʋ́, sə n lɩ n lɩ̀à tə lʋʋ wa. À yɩ à lòrì mʋ́, sə n cɩ̀ ba nə, ba dàn ká tʋ *Sɩtana jɩɩn wa. ");
INSERT INTO nnw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ndə nətʋ tə, à nə tà lʋʋ nə tɩ nə. Mə nətʋ ba də tà lʋʋ nə tɩ ba. ");
INSERT INTO nnw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Twá n cɩ́gá tə nə, n pa, sə ba ya n mʋ̀ nə tɩ ba. N sʋgʋ tə nə yɩ kʋ mʋ̀ cɩ́gá tə. ");
INSERT INTO nnw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ndə nətʋ tə, n nə tʋn nə lʋʋ wa, mə nətʋ tətə nə, à də tʋn ba lʋʋ wa. ");
INSERT INTO nnw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","À tà ba mʋ̀ yɩrɩ, à yá à tɩ̀àn à pa mʋ́, sə kʋ pa, ba də ya n mʋ̀ lɩ̀à, cɩ́gá cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kʋ tà à lɩ̀à tə cɩcɩ yɩrɩ nə, à lòrì mʋ́. À lòrì mʋ́ ba tə mama yɩrɩ, ba nə wá twá ba kàrà tə nə, ba ma kə ba waa à nə. ");
INSERT INTO nnw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","À fɩra nə yɩ, sə ba mama ya nədʋ, ndə n mʋ̀ à nyɩna Yɩɩ də à mʋ̀, nə wulə də duən nətʋ. À pɩ̀à, sə ba mʋ̀ də nə mʋ̀ mama ya nədʋ, sə kʋ pa lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, pa cɩ́gá də, kʋ yɩ n mʋ̀ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","À mʋ̀ də n mʋ̀ nə yɩ nədʋ. À pɩn ba dun tə, n nə pɩn nə, sə kʋ pa ba də ya nədʋ. ");
INSERT INTO nnw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","À wulə də ba, n də ga wulə də nə, sə kʋ pa ba wànɩ́ ba ya nədʋ, cɩ́gá cɩ́gá. Kʋ wá pa lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, lwàrɩ̀ də, n mʋ̀ nə tʋn nə. Yá ba wá lwarɩ də, n mʋ̀ sóní ba, ndə n nə sóní nə nətʋ. ");
INSERT INTO nnw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","À nyɩna Yɩɩ, à pɩ̀à cɩ́gá mama, sə à mʋ̀ də lɩ̀à tə, n nə pɩn nə tə, ya bwálɩ́ tə nə, à nə wá yà. Kʋ wá pa, ba na à dun tə. Dun tə, n nə pɩn nə, də lʋʋ tə wà fwa, n nə sóní nə, tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","À nyɩna Yɩɩ tə, n nə yɩ cɩ́gá tíú. Lɩ̀à tə, ba nə yɩ lʋʋ nə tɩ ba, ba mʋ̀ yə̀rì mʋ́. À mʋ̀ ga yə̀ə́ mʋ́. Yá lɩ̀à tə, n nə pɩn nə tə, də lwarɩ də, n mʋ̀ nə tʋn nə. ");
INSERT INTO nnw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","À pɩn ba lwarɩ n yɩrɩ tə. Yá à tə wá bwé, à pa ba lwarɩ n yɩrɩ tə. À fɩra nə yɩ, sə sonu tə, n nə swə nə, tə dàń ya də ba, sə à də tətə wànɩ́ à ya də ba». ");
INSERT INTO nnw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Zwezi nə swɩ̀n kʋ nətʋ tə, ʋ zwɛ̀e kwa nə, ʋ mʋ̀ də ʋ karbɩa tə zàn, ba nan, ba va, ba galʋ nacwəŋə tə, ba nə boŋə ‹Sedəron›. Kʋ mʋ̀ nacwəŋə təntə nii nə, tɩ̀án kárá don yà wulə lá. Ʋ mʋ̀ də ʋ karbɩa tə vəli, ba zʋ ka kwa. ");
INSERT INTO nnw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Máŋá mama, Zwezi də ʋ karbɩa tə yàá vəli ba jəni kʋ bwálɩ́ təntə nə. Kʋ mʋ̀ nə pɩn, Zwidasə dàń ma yə̀ə́ kʋ bwálɩ́. Ʋ mʋ̀ Zwidasə təntə nə wá ja Zwezi ʋ pa. ");
INSERT INTO nnw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zwidasə jɩn pamana púlí, də *Zwifə-ba Yɩɩ *dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə, ʋ ja va kʋ bwálɩ́ təntə nə. Ba mʋ̀ lɩ̀à təntə yà yɩ Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də *Farɩzɩan-ba yà nə tʋn ba. Pamana tə də lɩ̀à duən tə yà jə sɩsɩran mən, də cànán, də kwatara zɩla. ");
INSERT INTO nnw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Zwezi də yà yə̀ə́ yoo tə mama, kʋ nə wá yí wá. Ʋ dàń ma va ʋ yí ba nii, ʋ bwe ba, ʋ wʋ́: «Wàà nə á pɩ̀à?» ");
INSERT INTO nnw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ba le wá, ba wʋ́: «Zwezi, *Nazarɛtə tíú tə!» Zwezi ma swɩ̀n ba con, ʋ wʋ́: «À mʋ̀ nə!» Yá Zwidasə tə, ʋ nə wá ja Zwezi ʋ pa tə, yà zɩga də ba. ");
INSERT INTO nnw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Máŋá tə wa, Zwezi nə swɩ̀n ba con də, kʋ yɩ ʋ mʋ̀ tə, ba twən ba kə ba kwa, ba ga tʋ tɩa. ");
INSERT INTO nnw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Zwezi kʋ́ʋ̀ bwé ʋ bwe ba, ʋ wʋ́: «Wàà nə á pɩ̀à?» Ba də kʋ́ʋ̀ le, ba wʋ́: «Zwezi, Nazarɛtə tíú tə!» ");
INSERT INTO nnw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zwezi kʋ́ʋ̀ le ba, ʋ wʋ́: «À dí yáá, à swɩ̀n á con də, kʋ yɩ à mʋ̀ nə. Də kʋ nə yɩ à mʋ̀ nə, á pɩ̀à, sə á yá bara-ba tə mʋ̀, sə ba vìí». ");
INSERT INTO nnw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kʋ yɩn nətʋ, sə kʋ tə, ʋ nə dí yáá ʋ swɩ̀n, nii ma sú. Ʋ swɩ̀n, ʋ wʋ́: «Lɩ̀à tə, n mʋ̀ à nyɩna Yɩɩ nə pɩn nə, à wà ba lìù mama dʋgʋ». ");
INSERT INTO nnw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Piyɛrə yà jə lagʋrɩ sɩ̀ʋ́. Ʋ dàń ma van ʋ lagʋrɩ sɩ̀ʋ́ tə, ʋ cʋ̀rɩ̀, ʋ ma za Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə tʋ̀tʋ̀nʋ̀ jɩzən zɩɩn, ʋ gwəŋə. Tʋ̀tʋ̀nʋ̀ təntə yɩrɩ nə yɩ Maləkisə. ");
INSERT INTO nnw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Zwezi ma swɩ̀n Piyɛrə con, ʋ wʋ́: «Pìí n tʋrɩ n lagʋrɩ sɩ̀ʋ́ tə kʋ lɔ̀ɔ̀ wa. N bʋŋa də, kʋ wà mɛ, sə yacara tə, à nyɩna Yɩɩ nə pɩn nə yí nə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pamana púlí tə, də ba yuu tíú tə, də *Zwifə-ba Yɩɩ *dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə, Zwifə-ba yun tɩ̀án nə tʋn tə, dàń jɩn Zwezi ba vwa. ");
INSERT INTO nnw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ba dí yáá, ba ja wá, ba va Anə con. Anə yà yɩ Kayifə tɩnbɛɛ. Kayifə yà ga nə yɩ Yɩɩ *joŋwana yun tɩ̀án nəkwɩa kʋ bɩnɩ təntə nə. ");
INSERT INTO nnw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mə Kayifə təntə yà nə kwè Zwifə-ba yun tɩ̀án tə, ʋ wʋ́: «Bɛɛ nədʋa nə tɩga nə dwíí tə yɩrɩ, kʋ kʋkwa kʋ pa aba, kʋ doni, ba nə wá cʋ̀gʋ̀ nə dwíí tə mama». ");
INSERT INTO nnw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piyɛrə də Zwezi karbiu don yà púə́ Zwezi kwa. *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə yà yə̀ə́ karbiu təntə. Kʋ mʋ̀ nə pɩn, ʋ pú Zwezi kwa, ʋ zʋ Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə dəwoo wa. ");
INSERT INTO nnw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yá Piyɛrə mʋ̀ yà zɩga kàrá yáá dəwoo tə mimii nii nə. Karbiu tə don tə, Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə nə yə̀ə́ tə, nan ʋ swɩ̀n kan tə con, ʋ nə cɩ̀ mimii tə nə. Karbiu təntə ga pa Piyɛrə zʋ dəwoo tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tʋtʋnbʋa tə, ʋ nə cɩ̀ mimii tə nə, dàń ma swɩ̀n Piyɛrə con, ʋ wʋ́: «N də yà tà bɛɛ wà tə karbɩa tə wa lìù don, naaa?» Piyɛrə le, ʋ wʋ́: «À mʋ̀ tà ʋ karbiu!» ");
INSERT INTO nnw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Waran yà wulə kʋ máŋá təntə wa. Kʋ mʋ̀ nə pɩn, joŋwana yun tɩ̀án nəkwɩa tʋ̀tʋ̀nà tə, də Yɩɩ dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə yà kən mən, ba zɩga tə yáá, ba ywèrì. Piyɛrə də yà zɩga ba con, ʋ ywèrì mən tə. ");
INSERT INTO nnw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə bwe Zwezi ʋ karbɩa tə, də ʋ kàrà tə yoo yuu wa. ");
INSERT INTO nnw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Zwezi ma le wá, ʋ wʋ́: «À swɩ̀n à sʋ̀ràn tə pwənə pwənə lɩ̀à tə mama yɩ́á yuu. À yàá kàrɩ̀ *Zwifə-ba *jə́rə́ dìə̀ tə wa, də Zwifə-ba Yɩɩ *dìə̀ tə wa, kʋ yɩ bwálá tə nə, Zwifə-ba mama nə yàá kun duən nə. Yá à wà yoo mama sə̀gə̀, à swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bɛ̀eɛ̀e nə pɩn, n kʋ́ʋ̀ pìí n bwe nə? N dàń bwe lɩ̀à tə, ba nə cʋgʋ à sʋ̀ràn tə, bɛ̀eɛ̀e yoo nə à swɩ̀n ba con. Ba mʋ̀ nə yə̀ə́ kʋ tə, à mʋ̀ nə swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Máŋá tə, Zwezi nə swɩ̀n sʋ̀ràn təntə ʋ zwɛ̀e, də Yɩɩ dìə̀ lìù tə nə cɩ̀ ka nə tə don, ʋ yà nə zɩga Zwezi səpuni nə, farɩ Zwezi pɩpara nə, ʋ ga swɩ̀n, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, n ma le Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə nətʋ?» ");
INSERT INTO nnw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Zwezi ma le wá, ʋ wʋ́: «Də kʋ tə, à nə swɩ̀n, tə nə yɩ yolwan, sə n bɩrɩ nəba kʋ lwanɩ tə bwálɩ́. Kʋ dàń nə kʋ́ʋ̀ ya cɩ́gá nə à swɩ̀n, bɛ̀eɛ̀e nə pɩn, n mà nə?» ");
INSERT INTO nnw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anə dàń ma pa, ba ja wá, ba kɛ̀eń də ʋ jɩ̀àn ŋoni tə mɛ, ba ja va joŋwana yun tɩ̀án nəkwɩa Kayifə con. ");
INSERT INTO nnw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kʋ máŋá təntə wa, də Simon Piyɛrə mʋ̀ zɩga mən yáá nə ʋ ywèrì. Ba ma bwe wá, ba wʋ́: «N mʋ̀ tà bɛɛ wà tə karbiu tə don, naaa?» Ʋ tɛn kʋ, ʋ ga swɩ̀n, ʋ wʋ́: «À mʋ̀ tà ʋ karbiu!» ");
INSERT INTO nnw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tʋ̀tʋ̀nà tə tʋ̀tʋ̀nʋ̀ don yɩn lá, ʋ nə yɩ bɛɛ tə, Piyɛrə nə za ʋ zɩɩn tə ʋ gwəŋə, dwíí tíú. Tʋ̀tʋ̀nʋ̀ təntə də kʋ́ʋ̀ bwe Piyɛrə, ʋ wʋ́: «Kʋ tà n mʋ̀ nə, à nɩ tɩ̀án kárá tə wa də wá, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyɛrə tə kʋ́ʋ̀ tɛn kʋ, də kʋ tà cɩ́gá. Kʋ máŋá təntə tətə wa nə, cəbɩʋ kwi. ");
INSERT INTO nnw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kʋ mʋ̀ təntə kwa nə, ba kʋ́ʋ̀ ja Zwezi ba nan Kayifə con, ba va yáá tíú tə, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, bʋ̀rà dìə̀ wa. Kʋ yɩn jɩjʋ fuən fuən. *Zwifə-ba yun tɩ̀án tə wà bʋ̀rà dìə̀ tə wa zwɩ ba culu tə yɩrɩ. Ba cɩ̀gà ba tɩ̀àn nə də durən yoo, sə kʋ pa ba wànɩ́ ba də́ *Pakə cànà tə. ");
INSERT INTO nnw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kʋ mʋ̀ nə pɩn, *Pilatə ma nan ʋ yí ba kàrá wa, ʋ bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e nə bɛɛ wà tə cʋ̀gʋ̀, á nə pɩ̀à, sə á swɩ̀n á zɩgɩ ʋ nə?» ");
INSERT INTO nnw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ba ma le wá, ba wʋ́: «Də ʋ yà nə tà yolwanfwanʋ, nə yà ba ja wá, nə bà nə pa mʋ́». ");
INSERT INTO nnw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kʋ mʋ̀ sʋgʋ təntə yuu wa, Pilatə swɩ̀n ba con, ʋ wʋ́: «Á tətə joŋə wá, á twá á culu tə nə, á bʋ̀rɩ̀ ʋ bʋ̀rà». Zwifə-ba yun tɩ̀án le wá, ba wʋ́: «Nə ba cwəŋə jə, sə nə gʋ lìù». ");
INSERT INTO nnw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zwezi yà dí yáá, ʋ bɩrɩ nətʋ tə, ʋ nə mɛ, sə ʋ tɩ. Kʋ mʋ̀ nə pɩn, kʋ dàń ma ya nətʋ, sə Zwezi sʋ̀ràn tə nii ma sú. ");
INSERT INTO nnw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatə dàń pìí ʋ zʋ bʋ̀rà dìə̀ tə wa, ʋ ga bon Zwezi ʋ bwe, ʋ wʋ́: «N mʋ̀ nə yɩ Zwifə-ba pɩ̀ʋ́, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Zwezi le wá, ʋ wʋ́: «Kʋ tə, n nə swɩ̀n tə, yɩ n tətə nə bʋ́n kʋ, nə à yə̀ə́ kʋ yɩ lɩ̀à nə swɩ̀n à yoo n con?» ");
INSERT INTO nnw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatə ma le, ʋ wʋ́: «À mʋ̀ tà Zwifə. N mʋ̀ dwíí tɩ̀án də ba Yɩɩ joŋwana yun tɩ̀án tə nə ken mʋ́ à jɩ̀àn wa. Bɛ̀eɛ̀e nə n cʋ̀gʋ̀?» ");
INSERT INTO nnw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Zwezi le wá, ʋ wʋ́: «À mʋ̀ pàrɩ̀ tə tà tɩa ka tə yuu wa. À pàrɩ̀ tə yà nə wulə tɩa ka tə yuu wa, à tʋ̀tʋ̀nà yà nə wá ta à yɩrɩ, sə ba dàn ká ja nə, ba pa Zwifə-ba yun tɩ̀án nə. À pàrɩ̀ tə dàń nə tà tɩa ka tə yuu wa». ");
INSERT INTO nnw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatə dàń ma swɩ̀n ʋ con, ʋ wʋ́: «Yá n dàń yɩ pɩ̀ʋ́, naaa?» Zwezi le wá, ʋ wʋ́: «Mə kʋ nə n swɩ̀n, à yɩ pɩ̀ʋ́. Ba lʋrɩ nə, à bà lʋʋ wa, sə à swɩ̀n cɩ́gá tə à bɩrɩ. Yá lìù tə mama, ʋ nə yɩ cɩ́gá lìù, ʋ yàá cʋgʋ à sʋ̀ràn tə». ");
INSERT INTO nnw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatə ma bwe wá, ʋ wʋ́: «Bɛ̀eɛ̀e nə ya cɩ́gá tə?» Ʋ nə bwe kʋ nətʋ tə kwa nə, ʋ kʋ́ʋ̀ pìí ʋ nan Zwifə-ba con. Ʋ swɩ̀n ba con, ʋ wʋ́: «À mʋ̀ wà yoo mama nɩ ʋ yuu wa, kʋ nə mɛ, sə ba gʋ wá, kʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yá kʋ tə nə ya á yofwamɩʋn, bɩnɩ mama *Pakə cànà tə nə yí, à yàá lɩ bàń dìə̀ lìù nədʋ, à dʋgʋ. Á dàń pɩ̀à, sə à dʋgʋ Zwifə-ba pɩ̀ʋ́ tə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ba kʋ́ʋ̀ bubwi, ba wʋ́: «Kʋ tà ʋ mʋ̀! Barabasə nə nə pɩ̀à, sə n dʋgʋ!» Barabasə təntə yà yɩ ŋwɩ̀àn, ʋ nə gwɩ lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kʋ mʋ̀ təntə kwa nə, Pilatə dàń pɩn nii, sə ba ja Zwezi ba mà də fɩfɩran, ʋ yɩra lá. ");
INSERT INTO nnw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pamana tə sʋa casʋran yupuu, ba pú Zwezi yuu nə, ba ga zʋ wá də gasɔɔ nəsɩan mwin. ");
INSERT INTO nnw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ba dàń yàá va ba yí ʋ yɩra, ba swɩ̀n, ba wʋ́: «Nə jʋ̀nɩ̀ mʋ́, Zwifə-ba pɩ̀ʋ́!» Yá ba farɩ ʋ pɩpara nə. ");
INSERT INTO nnw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatə kʋ́ʋ̀ pìí ʋ nan, ʋ swɩ̀n Zwifə-ba yun tɩ̀án tə con, ʋ wʋ́: «Á cʋga, à wá lɩ wá, à ja à nan á con kàrá wa, sə kʋ pa á lwarɩ də, à mʋ̀ ba yoo mama na ʋ yuu wa, kʋ nə mɛ, sə ba gʋ wá kʋ yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Zwezi nan bʋ̀rà dìə̀ tə wa, də casʋran yupuu tə ʋ yuu nə, də gasɔɔ nəsɩan mwin tə ʋ yɩra nə. Pilatə ma swɩ̀n ba con, ʋ wʋ́: «Á nəŋə, bɛɛ tə nə!» ");
INSERT INTO nnw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Máŋá tə, Yɩɩ joŋwana yun tɩ̀án tə, də Yɩɩ *dìə̀ lɩ̀à tə nə cɩ̀ ka nə tə, nɩ wá, ba bubwi, ba wʋ́: «Pa, sə ba paa wá dagarʋ yuu wa! Pa, sə ba paa wá dagarʋ yuu wa!» Pilatə ma swɩ̀n ba con, ʋ wʋ́: «Á tətə joŋə wá, á paa dagarʋ yuu wa. À mʋ̀ ba yoo mama na ʋ yuu wa, kʋ nə mɛ, sə ba gʋ wá kʋ yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Zwifə-ba yun tɩ̀án pìí ba le, ba wʋ́: «Nə jə culu, yá nə culu təntə yɩrɩ nə, ʋ mɛ, sə ʋ tɩ. Ʋ jɩn ʋ tɩ̀àn, ʋ ma jì Yɩɩ-Biu». ");
INSERT INTO nnw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Máŋá tə, Pilatə nə nì sʋ̀ràn təntə, fən kʋ́ʋ̀ kwɛn tə zʋ wá. ");
INSERT INTO nnw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ʋ pìí ʋ zʋ bʋ̀rà dìə̀ tə wa, ʋ ga swɩ̀n Zwezi con, ʋ wʋ́: «N yɩ n nan yə̀n?» Yá Zwezi wà wá le. Pilatə ma pìí ʋ swɩ̀n ʋ con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","«À mʋ̀ con nə, n ba pɩ̀à swɩ̀n, naaa? N yə̀rì də, à dɩ̀àn yí, sə à pa ba paa mʋ́ dagarʋ tə yuu wa? À dɩ̀àn ma kʋ́ʋ̀ yí, sə à pa ba dʋgʋ mʋ́, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Zwezi le Pilatə, ʋ wʋ́: «N ba dɩ̀àn mama jə à yuu wa, də kʋ nə tà dɩ̀àn tə, Yɩɩ nə pɩn mʋ́ tə. Kʋ mʋ̀ nə pɩn, lìù tə, ʋ nə jɩn nə, ʋ pa mʋ́, kʋ tíú cʋna tə nə dwə tə mɛ». ");
INSERT INTO nnw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Zwezi sʋgʋ təntə yɩrɩ, Pilatə dàń pɩ̀à, sə ʋ dʋgʋ wá. Zwifə-ba tə dàń bubwi, ba wʋ́: «N nə dʋgʋ bɛɛ wà tə, də n kʋ́ʋ̀ tà *Romə-ba pɩ̀ʋ́ nəfarʋ tə dabɛɛ. Lìù tə mama, ʋ nə jɩn ʋ tɩ̀àn ma jì pɩ̀ʋ́, kʋ tíú tə yɩ ʋ zɩga pɩ̀ʋ́ nəfarʋ tə nə». ");
INSERT INTO nnw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatə nə nì ba sʋ̀ràn təntə, ʋ pɩn Zwezi nan kàrá wa. Ʋ tətə dàń ga nan, ʋ jə̀ə́ ʋ bwálɩ́ tə nə, ʋ nə jəni, ʋ ma bʋ̀rɩ̀ bʋ̀rà tə. Ba yà ja kʋ bwálɩ́ təntə, ba boŋə ‹kapana bwálɩ́›. *Ebərə-ba sʋgʋ də yà boŋə kʋ ‹Gabata›. ");
INSERT INTO nnw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dɩɩn təntə nə nə, Zwifə-ba yàá wulə ba tanɩ *Pakə cànà tə, sə ba zàn tɩa ba də́ ka. Kʋ máŋá tə yɩn ndə yɩcaʋ lugu fugə bələ nə. Pilatə dàń swɩ̀n Zwifə-ba con, ʋ wʋ́: «Á nəŋə, á pɩ̀ʋ́ tə nə!» ");
INSERT INTO nnw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ba dàń bubwi, ba wʋ́: «Á gwɩa wá! Á gwɩa wá! Pa, sə ba paa wá dagarʋ yuu wa!» Pilatə ma swɩ̀n ba con, ʋ wʋ́: «À pa, sə ba paa á pɩ̀ʋ́ tə dagarʋ yuu wa, naaa?» Yɩɩ joŋwana yun tɩ̀án tə ma le, ba wʋ́: «Nə mʋ̀ ba pɩ̀ʋ́ don jə, də kʋ nə tà Romə-ba pɩ̀ʋ́ nəfarʋ tə». ");
INSERT INTO nnw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilatə dàń ma dʋgʋ Zwezi, ʋ pa ba, sə pamana paa wá dagarʋ yuu wa. Ba ma ja wá, ba ja kɛ̀eń. ");
INSERT INTO nnw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Zwezi tətə nə zɩn ʋ dagarʋ tə, ʋ ja nan tɩʋ tə wa, ʋ va ʋ yí bwálɩ́ tə, ba nə boŋə ‹yuzʋŋa bwálɩ́›. *Ebərə-ba sʋgʋ də yà boŋə kʋ bwálɩ́ təntə ‹Goləgʋta›. ");
INSERT INTO nnw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mə kʋ bwálɩ́ təntə wa nə, pamana tə paa Zwezi dagarʋ tə yuu, yá ba ga paa lɩ̀à bələ, də ba súrí ʋ nə dagaran yuu. Ba paa lìù tə don ʋ vàn tə don nə, Zwezi tətə ga wulə ba tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","*Pilatə pɩn, ba pʋ́pʋ́nɩ́ sʋ̀ràn daborubiə wa, ba kə Zwezi dagarʋ tə yuu wa. Ba pʋ́pʋ́nɩ́, ba wʋ́: «*Nazarɛtə Zwezi, *Zwifə-ba pɩ̀ʋ́ tə». ");
INSERT INTO nnw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bwálɩ́ tə nə, ba nə paa Zwezi dagarʋ tə yuu, yà bwələ də tɩʋ tə nii. Kʋ mʋ̀ nə pɩn, Zwifə-ba dáá zənzən, ba nə kàrɩ̀ pʋ́pʋ́ná təntə. Yá kʋ yà yɩ də Ebərə-ba, də Latɩn-ba, də *Gərɛkə-ba sʋgʋ nə, ba ma pʋ́pʋ́nɩ́ tə. ");
INSERT INTO nnw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə ma swɩ̀n Pilatə con, ba wʋ́: «N nə pʋ́pʋ́nɩ́, də ʋ ya Zwifə-ba pɩ̀ʋ́, kʋ wà mɛ, sə n yá kʋ nətʋ. Kʋ mɛ, sə n pʋ́pʋ́nɩ́, də bɛɛ wà tə nə wʋ́, ʋ yɩ Zwifə-ba pɩ̀ʋ́». ");
INSERT INTO nnw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatə ma le ba, ʋ wʋ́: «Kʋ tə à nə pʋ́pʋ́nɩ́, mə kʋ nə, à pʋ́pʋ́nɩ́». ");
INSERT INTO nnw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pamana tə nə paa Zwezi ba zwɛ̀e, ba tì ʋ ganan tə, ba tún púlə́ banɩa. Kʋ kwa nə, ba tì púlí nədʋ nədʋ, ba pa pamanʋ mama nə. Ba tì ʋ gandarʋ tə, kʋ nə tà ba gwəŋə ba nyɛn, kʋ yɩ ba zɩgɩ kʋ yuu nə, ba sʋ ba bà ba yí kʋ tɩa con. ");
INSERT INTO nnw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ba dàń swɩ̀n duən con, ba wʋ́: «Nə dàn ká kàrɩ́ kʋ, nə pwárá, sə nə lwarɩ lìù tə, kʋ nə wá ya ʋ nyiən». Kʋ nətʋ tə tʋn, sə kʋ pa sʋ̀ràn tə, tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa tə, nii ma sú. Kʋ pʋ́pʋ́nɩ́, kʋ wʋ́: «Ba tàrɩ̀ à ganan, ba ga pwárɩ́ à gandarʋ tə yɩrɩ». Mə kʋ mʋ̀ yoo təntə nə, pamana tə tʋn. ");
INSERT INTO nnw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Zwezi nuu tə, də ʋ nuu nyánʋ́ tə, də Kəlopasə kan Mari, də Mari Madəlɛnə yà zɩga ba bwələ dagarʋ tə yɩra, ba nə paa Zwezi kʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Zwezi nuu tə, də ʋ karbiu tə, ʋ nə swə tə, yà zɩga duən səpuni nə. Zwezi nə nɩ ba, ʋ swɩ̀n ʋ nuu tə con, ʋ wʋ́: «À nuu, nə̀ń, n bìú nə!» ");
INSERT INTO nnw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kʋ kwa nə, ʋ kʋ́ʋ̀ swɩ̀n ʋ karbiu tə con, ʋ wʋ́: «Nə̀ń, n nuu nə!» Yá kʋ nə zɩgɩ kʋ máŋá təntə wa, karbiu tə jon Zwezi nuu Mari, ʋ kə ʋ con. ");
INSERT INTO nnw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yìə̀n təntə kwa nə, Zwezi yə̀ə́ də, yoo mama tʋn kʋ zwɛ̀e. Ʋ dàń swɩ̀n, ʋ wʋ́: «Nanyʋnɩ jə nə». Ʋ swɩ̀n kʋ nətʋ tə, sə sʋ̀ràn tə, tə nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, nii ma sú. ");
INSERT INTO nnw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sawuru yà zɩga bwálɩ́ təntə wa, kʋ nii nə súə́ də divɛn nyʋnʋ. Pamana tə dàń ma tì canfɩnsɩʋ, ba lə divɛn nyʋnʋ təntə wa, ba kə mɩʋ nii nə, ba nə boŋə ‹yizopə›, ba ja va, ba kə Zwezi nii nə. ");
INSERT INTO nnw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zwezi nə nyʋa divɛn nyʋnʋ təntə, ʋ swɩ̀n, ʋ wʋ́: «Yoo mama tʋn kʋ zwɛ̀e». Kʋ kwa nə, Zwezi ken ʋ yuu tɩa, mə ʋ tɩan də nə. ");
INSERT INTO nnw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kʋ yɩ dɩɩn tə, *Zwifə-ba yà nə wulə ba tanɩ ba *sìə́ dɩɩn tə, kʋ yoo nə cà ba nə. Kʋ ya Zwifə-ba sìə́ dɩɩn nəfarʋ. Kʋ mʋ̀ nə pɩn, Zwifə-ba yun tɩ̀án yà ba pɩ̀à, sə tɩga tə ya dagaran tə yuu wa. Ba dàń vəli, ba lòrì *Pilatə, sə ʋ pa ba cwəŋə, sə ba kén lɩ̀à tə nɛɛ, ba nə wulə dagaran tə yuu wa. Ba ga cú kʋ tɩ̀án tɩga tə. ");
INSERT INTO nnw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pamana tə dàń twi, ba kén lɩ̀à tə, ba nə paa ba mʋ̀ də Zwezi tə nɛɛ. Ba kén təntən lìù tə nɛɛ, ba zàn ba kén ʋ don tə də nɛɛ. ");
INSERT INTO nnw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba nə yí Zwezi, ba nɩ də, ʋ mʋ̀ tɩga. Kʋ mʋ̀ nə pɩn, ba kʋ́ʋ̀ wà ʋ mʋ̀ nɛɛ kén. ");
INSERT INTO nnw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yá pamana tə wa lìù don ja cwiin, ʋ ma pórí Zwezi səpuni, lala də jana də nɩ́á ga nan tə lwə́ tɩa. ");
INSERT INTO nnw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Bɛɛ tə, ʋ nə pʋ́pʋ́nɩ́ yìə̀n tə tə ya ʋ nɩ tə, ʋ ma ʋ bɩrɩ tə aba, sə kʋ pa á də pa cɩ́gá ʋ sʋgʋ tə nə. Yá kʋ tə, ʋ nə pʋ́pʋ́nɩ́ tə, yɩ cɩ́gá. Yá ʋ yə̀ə́ də kʋ ya cɩ́gá nə, ʋ swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: «Ʋ yɩra kuu mama wà mɛ, sə kʋ kén». Yìə̀n təntə tʋn, sə kʋ pa sʋ̀ràn təntə nii sú. ");
INSERT INTO nnw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kʋ tə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: «Ba wá ywàń, ba na lìù tə, ba nə pórí tə». ");
INSERT INTO nnw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kʋ kwa nə, Zwʋzɛfə tə, ʋ nə yɩ Arimate tíú, zàn ʋ va ʋ na *Pilatə. Ʋ mʋ̀ Zwʋzɛfə tə yà yɩ Zwezi karbiu. Ʋ yà sə̀gə̀ ʋ tɩ̀àn, ʋ nə dəri *Zwifə-ba yun tɩ̀án tə fən yɩrɩ. Ʋ lòrì cwəŋə Pilatə con, sə ʋ lɩ Zwezi tɩgɩ tə. Pilatə dàń ma pa wá cwəŋə. Zwʋzɛfə dàń vəli ʋ pa ba tì Zwezi tɩgɩ tə. ");
INSERT INTO nnw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmə tə, ʋ dɩɩn nə vəli Zwezi con tɩtɩn tə nə, də ja tɩralɩ, kʋ nə yí ndə kilo fɩtwa nə, ʋ ja bà. Tɩralɩ təntə yà yɩ mirə də alwɛsə nə, ba guli duən wa, ba ma fwa kʋ. ");
INSERT INTO nnw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ba mʋ̀ bələ tə mɛ nə tì Zwezi tɩgɩ tə, ba pəpəni də gantwɛn, ba ga kə tɩralɩ ʋ nə. Mə nətʋ nə Zwifə-ba yàá fwa, də ba nə pɩ̀à, ba gùrì tɩgɩ. ");
INSERT INTO nnw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tɩ̀án kárá yà wulə bwálɩ́ tə wa, ba nə paa Zwezi dagarʋ tə yuu. Ba yà kʋa ləbəri nədʋn kʋ mʋ̀ tɩ̀án kárá tə wa, ba nə tə wà lìù mama kʋ wa ken. ");
INSERT INTO nnw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ba yà wulə ba kəni Zwifə-ba *sìə́ dɩɩn tə sírí. Ləbəri tə bwálɩ́ yà ga bwələ. Kʋ mʋ̀ nə pɩn, Zwʋzɛfə də Nikodɛmə ma tì Zwezi, ba ja va, ba kə kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","*Zwifə-ba *sìə́ dɩɩn tə tɩkʋnɩ nə, jɩjʋ fuən fuən, tɩa nə fwa gana gana máŋá wa, Mari Madəlɛnə zàn, ʋ va ləbəri tə nii nə. Ʋ nə yí lá nə, ʋ nɩ də, kapan tə, kʋ yà nə sun ləbəri tə nii nə, súrí kʋ yá ləbəri tə nə. ");
INSERT INTO nnw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ʋ dàń pìí ʋ dəri, ʋ va ʋ yí Simon Piyɛrə, də karbiu tə, Zwezi yà nə swə tə, ʋ swɩ̀n ba con, ʋ wʋ́: «Ba lɩ *Yuu-Tiu ʋ ləbəri tə wa, yá nə ga yə̀rì bwálɩ́ tə, ba nə ken wá». ");
INSERT INTO nnw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyɛrə də karbiu təntə dàń zàn, ba va ləbəri tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ba mɛ bələ tə yà yɩ ba dəri, yá karbiu tə don tə dəri lala, ʋ doni Piyɛrə. Ʋ dí yáá, ʋ yí ləbəri tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ʋ nə kwá tɩa, sə ʋ ywàń ləbəri tə wa, ʋ nɩ gantwɛn tə, tə tə́gə́ tɩa, yá ʋ wà zwɩ. ");
INSERT INTO nnw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Piyɛrə púə́ ʋ kwa, ʋ yí lá, ʋ lɛ, ʋ zʋ ləbəri tə wa. Ʋ də kʋ́ʋ̀ nɩ gantwɛn tə, tə tə́gə́ tɩa. ");
INSERT INTO nnw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ʋ nɩ gantwan tə də, ba yà nə baa Zwezi yuu nə, də tə mʋ̀ pəpəni kʋ tə́gə́ vàn nə. ");
INSERT INTO nnw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Karbiu tə don tə, ʋ nə dí yáá ʋ yí ləbəri tə nii nə, də dàń zʋa ləbəri tə wa. Ʋ də nɩ kʋ nətʋ, ʋ ga sɛ̀e də, kʋ yɩ cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kʋ máŋá tə wa, ba yà tə wà lwarɩ də, Yɩɩ sagɩ tə wa kʋ bɩrɩ də, Zwezi mɛ, sə ʋ pìí ʋ bwin ʋ nan tɩan wa. ");
INSERT INTO nnw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kʋ kwa nə, karbɩa tə pìí, ba va ba sàń. ");
INSERT INTO nnw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kʋ máŋá təntə wa, Mari mʋ̀ yà zɩga kàrá wa, ləbəri tə nii nə, ʋ kwi. Ʋ nə zɩga lá ʋ kwi nətʋ tə, ʋ kwá tɩa, sə ʋ ywàń ləbəri tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ʋ dàń nɩ *malɩkɛ bələ, tə nə zʋa ganpwənə, tə jə̀ə́ bwálɩ́ tə nə, Zwezi tɩgɩ tə yà nə tə́gə́ lá. Ka don jə̀ə́ yuu con, ka don tə də jə̀ə́ nɛɛ con. ");
INSERT INTO nnw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malɩkɛ tə dàń ma bwe Mari, tə wʋ́: «Kan, bɛ̀eɛ̀e nə pɩn, n ma kwi?» Mari pìí ʋ le ba, ʋ wʋ́: «Ba lɩ à *Yuu-Tiu tə, à ga yə̀rì bwálɩ́ tə nə, ba nə ken wá». ");
INSERT INTO nnw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ʋ nə swɩ̀n kʋ nətʋ tə, ʋ vəvəri, sə ʋ ywàń ʋ nɩ Zwezi, də ʋ zàn ʋ zɩga yɩɩ nə. Ʋ yà ga wà lwarɩ də, kʋ yɩ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Kan, bɛ̀eɛ̀e nə pɩn, n ma kwi? Wàà nə n pɩ̀à?» Mari yà bʋŋa də, kʋ yɩ bɛɛ tə, ʋ nə cɩ̀ tɩ̀án kárá tə nə. Kʋ mʋ̀ nə pɩn, ʋ ma swɩ̀n bɛɛ tə con, ʋ wʋ́: «Yuu tíú, də kʋ nə yɩ n mʋ̀ nə tì Zwezi, sə n bɩrɩ nə bwálɩ́ tə, n nə ken wá, sə à va à tì wá». ");
INSERT INTO nnw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Zwezi le wá, ʋ wʋ́: «Mari!» Də ʋ vəvəri, ʋ ga swɩ̀n Zwezi con, ʋ wʋ́: «Rabuni!» Kʋ də̀ń nə yɩ ‹karnyɩna›. ");
INSERT INTO nnw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «N kʋ́ʋ̀ dàn ká dwen à yɩra, à tə wà à nyɩna Yɩɩ con vəli. Yá vəli n yí à nubɩa tə, n ga swɩ̀n ba con də, à vəli à nyɩna con. Nyɩna təntə nə yɩ á də nyɩna. Ʋ mʋ̀ nə yɩ à Yɩɩ, ʋ ga yɩ á də Yɩɩ». ");
INSERT INTO nnw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari Madəlɛnə dàń vəli, ʋ swɩ̀n kʋ ʋ bɩrɩ Zwezi karbɩa tə nə. Ʋ swɩ̀n ba con də, ʋ nɩ Yuu-Tiu. Ʋ ga tún tə tə mama, Zwezi nə swɩ̀n ʋ con, ʋ bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","*Zwifə-ba *sìə́ dɩɩn tə tɩkʋnɩ dədəni nii nə, Zwezi karbɩa tə yà dəri Zwifə-ba yun tɩ̀án tə fən. Ba dàń yà kun duən nə dìə̀ don wa, ba ga tagʋ ka də borbiu. Zwezi dʋ̀à ʋ nan ba tətəŋi wa, dìə̀ tə wa, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Bɩcan sìə́ wá ya də aba!» ");
INSERT INTO nnw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ʋ nə swɩ̀n sʋ̀ràn təntə kwa nə, ʋ bɩrɩ ba ʋ jɩ̀àn tə, də ʋ səpuni tə. Karbɩa tə súə́ də pupwən, ba nə pìí, ba na *Yuu-Tiu tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Zwezi kʋ́ʋ̀ bwé, ʋ swɩ̀n ba con, ʋ wʋ́: «Bɩcan sìə́ wá ya də aba. Nətʋ tə, à nyɩna Yɩɩ nə tʋn nə, mə nətʋ nə, à də tʋŋa aba». ");
INSERT INTO nnw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sʋ̀ràn təntə kwa nə, ʋ fwɩ vʋʋ ʋ kə ba yuu wa, ʋ ga swɩ̀n ba con, ʋ wʋ́: «Á joŋə Yɩɩ-*Siŋu tə. ");
INSERT INTO nnw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Lɩ̀à tə, á nə wá kwɛn ba cʋna, á lɩ ba mʋ̀ də aba pwərə wa, Yɩɩ də wá kwɛn ba cʋna, ʋ lɩ ba mʋ̀ də wá pwərə wa. Yá lɩ̀à tə, á nə wà ba cʋna kwɛn, á lɩ ba mʋ̀ də aba pwərə wa, Yɩɩ də bá ba cʋna kwɛn, ʋ lɩ ba mʋ̀ də wá pwərə wa». ");
INSERT INTO nnw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma tə, ba nə boŋə ‹yɩyɔɔ›, ʋ də nə yɩn karbɩa fugə bələ tə wa, wà twá ʋ yà lá, máŋá tə wa, Zwezi nə twi tə. ");
INSERT INTO nnw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Karbɩa tə duən tə dàń ma swɩ̀n Toma con, ba wʋ́: «Nə nɩ *Yuu-Tiu». Ʋ ma le ba, ʋ wʋ́: «Də à nə wà cɩan tə bʋran tə nɩ ʋ jɩ̀àn tə wa, à nə wà à jɩfʋa ken ʋ səpuni tə wa, à mʋ̀ bá pa cɩ́gá á sʋgʋ tə nə». ");
INSERT INTO nnw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dɩan nana nii nə, Zwezi karbɩa tə kʋ́ʋ̀ pìí ba kun duən nə dìə̀ təntə wa. Yá Toma də dàń yɩn lá. Mimiə tə yà tagʋ də borbiu, Zwezi ga bà ʋ zɩga ba tətəŋi wa, ʋ ga swɩ̀n, ʋ wʋ́: «Bɩcan sìə́ wá ya də aba!» ");
INSERT INTO nnw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kʋ kwa nə, ʋ swɩ̀n Toma con, ʋ wʋ́: «Kə n jɩfʋa yəbə, sə n ga ywàń à jɩ̀àn tə. Làrɩ̀ n jɩɩn, n kə à səpuni tə nə! N dàń yá n tʋ́tʋ̀ná tə nə, sə n sɛ̀e cɩ́gá tə!» ");
INSERT INTO nnw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma ma le wá, ʋ wʋ́: «N mʋ̀ nə ya à Yuu-Tiu də à Yɩɩ!» ");
INSERT INTO nnw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Zwezi ma swɩ̀n ʋ con, ʋ wʋ́: «Kʋ yɩ n nə nɩ nə, tə nə pɩn, n ma kə n waa à nə. Pupwən lɩ̀à nə yɩ ba tə, ba nə ken ba waa à nə, də ba wà nə nɩ». ");
INSERT INTO nnw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zwezi tʋn Yɩɩ dɩ̀àn mɩmɩnan duən tə nə dáá zənzən, ʋ karbɩa tə yɩ́á yuu. Tə yoo wà pʋ́pʋ́nɩ́ sagɩ kʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yá yìə̀n tətə yɩ tə pʋ́pʋ́nɩ́, sə á pa cɩ́gá də, Zwezi yɩ *Kərisə, ʋ yɩ Yɩɩ-Biu də. Yá á dàń nə keni á waa ʋ nə wuuu, á wá twá də wá, á ma na mɩɩ, kʋ nə ba zwɛ̀e Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kʋ kwa nə, Zwezi kʋ́ʋ̀ bɩrɩ ʋ tɩ̀àn karbɩa tə nə, də ba wulə Tiberiyadə mʋnaa tə nii nə. Nəŋə nətʋ tə, ʋ nə bɩrɩ ʋ tɩ̀àn ba. ");
INSERT INTO nnw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Piyɛrə yɩn lá, də Toma, ba nə boŋə ‹yɩyɔɔ›, Natanayɛlə də yɩn lá, ʋ tɩʋ nə yɩ Káná Galile nagwanaa tə wa, də Zebede bɩa tə, də Zwezi karbɩa bələ duən. Ba lɩ̀à təntə mama yà nə wulə duən nə. ");
INSERT INTO nnw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Piyɛrə ma swɩ̀n ba con, ʋ wʋ́: «À vəli, sə à ja fələ». Ba də ma swɩ̀n ʋ con, ba wʋ́: «Nə də wá twá n nə, nə va». Ba dàń vəli ba zʋ nɩ́á yuu bori wa. Kʋ tɩtɩn təntə nə, ba wà won mama jɩn. ");
INSERT INTO nnw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tɩa nə twi ka pʋrɩ máŋá wa, Zwezi nan ʋ zɩga mʋnaa tə nii nə. Ʋ karbɩa tə yà wà lwarɩ də, kʋ yɩ ʋ mʋ̀. ");
INSERT INTO nnw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Zwezi ma bwe ba, ʋ wʋ́: «À bɩa-ba, á ba wodiu mama jə, naaa?» Ba pìí ba le wá, ba wʋ́: «Nə ba won mama jə!» ");
INSERT INTO nnw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Á dɩla fələ gə̀gə̀lù tə nɩ́á yuu bori tə jɩzən vàn tə yuu, á wá ja fələ». Ba nə dɩlɩ fələ gə̀gə̀lù tə, ba kʋ́ʋ̀ wàrɩ̀ kʋ ba pìí ba vaŋa ba lɩ, fələ nə súə́ kʋ nii yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Karbiu tə, Zwezi yà nə swə tə, dàń ma swɩ̀n Piyɛrə con, ʋ wʋ́: «Kʋ yɩ *Yuu-Tiu!» Simon Piyɛrə yà yɩ ʋ zɩga swələ. Ʋ nə nì də, kʋ yɩ Yuu-Tiu, ʋ tì ʋ gànʋ̀ ʋ zʋ, ʋ ga vwa ʋ voru ʋ tàŋá nə. Kʋ kwa nə, ʋ fan ʋ tʋ nɩ́á tə wa. ");
INSERT INTO nnw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Karbɩa tə duən tə ya ba nɩ́á tə nii ŋʋ́ná zənzən. Bwálɩ́ tə, ba yà nə wulə, də nɩ́á tə nii yà yɩ ndə mɛtərə bíí nə. Ba dàń twi də nɩ́á yuu bori tə. Ba nə pìí ba bɩ̀àn, fələ gə̀gə̀lù tə súə́ də fələ, ba dàń ga vaŋa kʋ. ");
INSERT INTO nnw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba nan nɩ́á tə wa. Máŋá tə wa, ba nə nan, ba nɩ cala tə nə jə mən, fəli də dipɛn ga tə́gə́ tə yuu. ");
INSERT INTO nnw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Zwezi swɩ̀n ba con, ʋ wʋ́: «Á lɩa fələ duən, á nə jɩn sɩ́ʋ́n, á ja bà». ");
INSERT INTO nnw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piyɛrə zʋa nɩ́á yuu bori tə wa, ʋ van fələ gə̀gə̀lù tə, ʋ ja nan bəbəru tə nii nə. Kʋ yà súə́ də fələ kəkərən. Tə mama yɩn bíí də finu də batwa. Yá də tə nə dáá nətʋ tə mama, fələ gə̀gə̀lù tə wà karɩ. ");
INSERT INTO nnw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Zwezi swɩ̀n ba con, ʋ wʋ́: «Á bɩ̀àn, á də́». Fən zʋa karbɩa tə mama, sə ba bwe wá, ba na lìù tə, ʋ nə yɩ. Ba yà lwarɩ də, kʋ ya Yuu-Tiu nə. ");
INSERT INTO nnw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zwezi twən ʋ yí lá, ʋ tì dipɛn tə, də fəli tə, ʋ ma tàrɩ̀ ba. ");
INSERT INTO nnw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mə nɛɛ batwa nə, Zwezi nə bɩrɩ ʋ tɩ̀àn ʋ karbɩa tə nə, ʋ nə pìí ʋ bwin ʋ nan tɩan tə wa, kwa nə. ");
INSERT INTO nnw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ba nə dí ba zwɛ̀e kwa nə, Zwezi swɩ̀n Simon Piyɛrə con, ʋ wʋ́: «Zwʋnasə bìú Simon, n swə nə, n doni ba duən tə, ba nə swə nə, naaa?» Ʋ ma le wá, ʋ wʋ́: «Cɩ́gá, *Yuu-Tiu, n yə̀ə́ də, à swə mʋ́». Zwezi mʋ̀ swɩ̀n ʋ con, ʋ wʋ́: «Ywàń à pabii tə yoo». ");
INSERT INTO nnw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ʋ kʋ́ʋ̀ pìí ʋ swɩ̀n ʋ con, nɛɛ bələ nii nə, ʋ wʋ́: «Zwʋnasə bìú Simon, n swə nə, naaa?» Ʋ də ma kʋ́ʋ̀ le Zwezi, ʋ wʋ́: «Cɩ́gá, Yuu-Tiu, n yə̀ə́ də, à swə mʋ́». Zwezi ma kʋ́ʋ̀ swɩ̀n ʋ con, ʋ wʋ́: «Ywàń à pee tə nə». ");
INSERT INTO nnw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Zwezi tə kʋ́ʋ̀ pìí ʋ swɩ̀n ʋ con, nɛɛ batwa nii nə, ʋ wʋ́: «Zwʋnasə bìú Simon, n swə nə, naaa?» Piyɛrə pùə́ cʋ̀gʋ̀ də, Zwezi nə bwe wá, nɛɛ batwa tə nii nə, də ʋ nə swə wá. Ʋ dàń ma le Zwezi, ʋ wʋ́: «Yuu-Tiu, n yə̀ə́ yoo mama, n yə̀ə́ də, à swə mʋ́». Zwezi ma swɩ̀n, ʋ wʋ́: «Ywàń à pee tə nə. ");
INSERT INTO nnw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cɩ́gá mama, à mʋ̀ nə swɩ̀n kʋ n con: Máŋá tə, n yà nə yɩ balandʋrʋ, n tətə yàá nə vwe n tàŋá voru. Yá n yà ga vəli bwálɩ́ tə, n nə swə. Yá n nə twi, n bà n kwɩn, n wá zɩ̀n n vànà, lìù don ga vwa n tàŋá voru ʋ pa mʋ́. Yá ʋ wá ja mʋ́, ʋ ja va bwálɩ́ tə, n nə bá pɩ̀à». ");
INSERT INTO nnw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zwezi sʋ̀ràn təntə yà yɩ ʋ swɩ̀n, sə ʋ ma bɩrɩ tɩan tə yiri, Piyɛrə nə wá tɩ, sə Yɩɩ ma na dun. Kʋ kwa nə, Zwezi swɩ̀n ʋ con, ʋ wʋ́: «Twá à nə!» ");
INSERT INTO nnw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyɛrə dàń vəvəri, ʋ ywàń ʋ kwa, ʋ na karbiu tə, Zwezi nə swə tə, də ʋ nan ba kwa con, ʋ bɩ̀àn. Mə ʋ mʋ̀ karbiu təntə nə yà guni ʋ kə Zwezi con, máŋá tə wa, ba yà nə wulə ba də́ wodiu tə. Ʋ yà ga bwe wá, ʋ wʋ́: «Yuu-Tiu, wàà nə yɩ lìù tə, ʋ nə wá ja mʋ́, ʋ pa n dʋŋa tə nə?» ");
INSERT INTO nnw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyɛrə nə nɩ wá, ʋ swɩ̀n Zwezi con, ʋ wʋ́: «Sə ʋ tə mʋ̀, Yuu-Tiu, bɛ̀eɛ̀e nə wá yí ʋ mʋ̀?» ");
INSERT INTO nnw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Zwezi ma le wá, ʋ wʋ́: «À nə swə, sə ʋ mʋ̀ ya lá wuuu, kʋ ja vəli máŋá tə, à nə wá pìí à bà, kʋ jə n bɩan nə, naaa? ");
INSERT INTO nnw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","N mʋ̀ twá à nə!» Kʋ mʋ̀ sʋgʋ təntə, Zwezi nə swɩ̀n tə tàá tɩa mama, lɩ̀à tə, ba nə yɩ nubɩa *Kərisə yɩrɩ, tətəŋi wa, ba swɩ̀n də, karbiu təntə mʋ̀ bá tɩ. Zwezi ga wà Piyɛrə con swɩ̀n də, ʋ mʋ̀ bá tɩ. Kʋ yɩ ʋ swɩ̀n ʋ con, ʋ wʋ́: «Də à nə swə, sə ʋ mʋ̀ ya lá, wuuu, kʋ jə vəli máŋá tə, à nə wá pìí à bà, kʋ jə n bɩan nə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mə ʋ mʋ̀ karbiu təntə nə swɩ̀n yìə̀n təntə tə nə tʋn, ʋ ga pʋ́pʋ́nɩ́ tə. Kʋ mʋ̀ nə pɩn, nə ma yə̀ə́ də kʋ tə, ʋ nə pʋ́pʋ́nɩ́, tə yɩ cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zwezi tə tʋn yìə̀n duən, tə nə dáá zənzən. Də ba yà nə pʋ́pʋ́nɩ́ tə nədʋ nədʋ, à bʋŋa də, saga tə, ba nə wá pʋ́pʋ́nɩ́, yà wàrɩ̀ lʋʋ tə tətə wa mɩ́ámɩ́án.");
INSERT INTO nnw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","À dabɛɛ Teofilə, à təntən sagɩ tə wa, à pʋ́pʋ́nɩ́ yìə̀n tə mama, Zwezi nə tʋn də tə tə, ʋ nə kàrɩ̀ ʋ bɩrɩ lɩ̀à nə. Ʋ kàrɩ̀ tə ʋ bɩrɩ ʋ tʋtʋŋɩ tə jɩjʋ mama, kʋ ja va kʋ yí máŋá tə wa, Yɩɩ nə lɩ wá tɩa yuu, ʋ kə ʋ con. Zwezi nə yɩn lʋʋ wa, ʋ kúrí lɩ̀à, ʋ ma fwa ʋ *tʋntʋna. Ʋ twá Yɩɩ-*Siŋu tə dɩ̀àn nə, ʋ ma bɩrɩ ba kʋ tə, ba nə mɛ, sə ba fwa. ");
INSERT INTO nnw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ʋ nə dí càn ʋ tɩ kwa nə, ʋ bɩrɩ ʋ tɩ̀àn ʋ tʋntʋna tə nə də, ʋ cɩ́gá wulə mɩɩ wa. Ʋ bɩrɩ ʋ tɩ̀àn ba wuuu, nɛɛ kapʋpʋ dɩan sapwilə, ʋ ma swɩ̀n Yɩɩ pàrɩ̀ tə yìə̀n, ʋ bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kʋ máŋá təntə wa, Zwezi də ʋ tʋntʋna tə yà jə̀ə́ ba də́ wodiu. Kʋ mʋ̀ wodiu tə yuu, ʋ swɩ̀n ba con, ʋ wʋ́: «Á dànà ká nan *Zwerizalɛmə wa. Á dàná won tə, à nyɩna Yɩɩ nə kàn nii, sə ʋ pa aba. À dí yáá à swɩ̀n kʋ yoo á con: ");
INSERT INTO nnw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zwan ləgə lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ, yá kʋ dàń nə yí yáá mɛ̀e, Yɩɩ wá lə ba ʋ *Siŋu tə wa». ");
INSERT INTO nnw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tʋntʋna tə, ba nə kun duən nə, dàń ma bà ba bwe Zwezi, ba wʋ́: «*Yuu-Tiu, kʋ máŋá təntə wa nə, n wá pìí n tún *Yɩzərayɛlə pàrɩ̀ tə, naaa?» ");
INSERT INTO nnw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ʋ ma le ba, ʋ wʋ́: «Kʋ mʋ̀ təntə ba aba ywàŋá. À nyɩna Yɩɩ tətə nə jə cwəŋə, sə ʋ tún kʋ máŋá tə, də kʋ dɩɩn tə, kʋ nə wá tʋn. ");
INSERT INTO nnw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yá Yɩɩ-Siŋu tə nə twi á yuu wa, á wá na dɩ̀àn, sə á ya à lɩ̀à tə, á nə wàá á bɩrɩ kʋ tə, á nə nɩ à con Zwerizalɛmə wa, də Zwide nagwanaa tə mama wa, də Samari nagwanaa tə mama wa, halɩ, kʋ ja vələ tɩa tə yuu mama». ");
INSERT INTO nnw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Zwezi nə swɩ̀n kʋ mʋ̀ təntə ʋ zwɛ̀e, Yɩɩ pɩn, ʋ zàn ʋ dɩ̀ yɩɩ nə ba yɩ́á yuu. Yá bakwan twi kʋ pú ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ba dàń nə zɩga, ba ywàŋá yɩɩ nə zən, Zwezi zaŋʋ tə máŋá wa, də nə̀ń, bara bələ, ba nə zʋa ganpwənə, nan ba nə. ");
INSERT INTO nnw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ba bwe ba, ba wʋ́: «Galile tɩ̀án-ba, bɛ̀eɛ̀e nə pɩn, á ma zɩga, á ywàŋá yɩɩ nə? Yɩɩ nə tì ʋ mʋ̀ Zwezi tə, ʋ ja dɩ̀ ʋ mʋ̀ Yɩɩ *sàń nə. Ʋ wá pìí ʋ bà nətʋ, ndə á nə nɩ wá də, ʋ dɩ̀ Yɩɩ sàń nə». ");
INSERT INTO nnw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Zwezi-*Kərisə *tʋntʋna tə dàń pìí, ba nan *oliviye tɩ̀án paan tə yuu, ba va *Zwerizalɛmə. Paan tə də Zwerizalɛmə yɩ ndə kilomɛtərə nədʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba nə vəli ba yí Zwerizalɛmə, ba dɩ̀gà dəyuu dìə̀ tə wa, ba nə yàá kun duən nə máŋá mama. Kʋ yɩ Piyɛrə, də Zwan, də Zwakə, də Andəre, də Filipə, də Toma, də Barətelemi, də Matiə, də Aləfe bìú Zwakə, də Simon, ʋ nə yɩ *Zelotə, də Zwakə bìú Zwidə. ");
INSERT INTO nnw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ba mama tə pubʋŋa yà yɩ nədʋ, ba yà ŋwɩ̀ń ba yáá lá ba jʋ̀nɩ̀ Yɩɩ, ba mʋ̀ də kana tə, də Zwezi nuu Mari də Zwezi nyáná tə. ");
INSERT INTO nnw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ba lɩ̀à tə mama, ba nə yɩ nubɩa Kərisə yɩrɩ, ba yà nə kun bwálɩ́ tə wa, yí ndə lɩ̀à bíí də sapʋa nə. Dɩan təntə wa, dɩɩn don nə, Piyɛrə zàn yɩɩ nə ba tətəŋi wa ʋ swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Nubɩa-ba, Yɩɩ sagɩ tə wa, kʋ bɩrɩ də, Yɩɩ-*Siŋu tə pɩn, pɩ̀ʋ́ *Davidə swɩ̀n Zwidasə yoo fuən nə. Kʋ yɩ kálʋ́, sə kʋ nii sú. Ʋ mʋ̀ Zwidasə tə nə yɩn lɩ̀à yáá, ʋ pa ba ja Zwezi. ");
INSERT INTO nnw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zwidasə yà yɩn nə mʋ̀ Zwezi-Kərisə tʋntʋna tə wa lìù. Ʋ də yà jə tori tʋtʋnan tə wa, Zwezi nə tàrɩ̀ ʋ pa nəba. ");
INSERT INTO nnw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ʋ mʋ̀ Zwidasə tə tʋn yoo, kʋ nə lwara zənzən. Ba ga pa wá səbiu kʋ yɩrɩ. Ʋ tì kʋ mʋ̀ səbiu tə, ʋ ma yə̀ kárá. Kʋ mʋ̀ kárá tə wa, ʋ kén ʋ tʋ ʋ yarɩ, ʋ pùə́ pwin, ʋ lʋran nan tə gàrɩ̀ tɩa. ");
INSERT INTO nnw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Zwerizalɛmə lɩ̀à mama nì kʋ mʋ̀ yoo təntə. Ba dàń ma kə kárá tə yɩrɩ də ba sʋgʋ Akɛlədama. Kʋ də̀ń nə yɩ ‹jana kárá›. ");
INSERT INTO nnw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kʋ pʋ́pʋ́nɩ́ gwaran sagɩ tə wa, kʋ wʋ́: ‹Yɩɩ wá pa, ʋ sàń jì digə, lìù mama dàn ká yà lá›. Kʋ tə súrí lá nə, kʋ wʋ́: ‹Yɩɩ wá pa, lìù don jon ʋ yuu nə›. ");
INSERT INTO nnw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kʋ mʋ̀ tə yɩrɩ, kʋ mɛ, sə lìù don, ʋ nə wàá ʋ bɩrɩ də, ʋ nɩ *Yuu-Tiu Zwezi bwiu tə nə súrí nə nə. Ʋ mʋ̀ lìù təntə mɛ, sə ʋ yà lìù tə, ʋ nə yɩn də nəba, máŋá tə wa, nə mʋ̀ də Zwezi nə yà wulə duən nə. Kʋ nə zɩgɩ, Zwan ka lə lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ, kʋ ja va máŋá tə nə, Zwezi nə dɩ̀gà Yɩɩ *sàń nə». ");
INSERT INTO nnw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ba dàń ma lɩ lɩ̀à bələ ba zɩgɩ. Kʋ mʋ̀ nə yɩ Zwʋzɛfə, ba nə boŋə Barəsabasə, ʋ yɩrɩ don də ya Zwisətisə də Matɩasə. ");
INSERT INTO nnw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ba dàń lòrì Yɩɩ, ba wʋ́: «Yuu-Tiu, n mʋ̀ nə yə̀ə́ lìù mama pubʋŋa. Bɩrɩ lìù tə, n nə kúrí lɩ̀à bələ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Sə ʋ ya Zwezi-Kərisə tʋntʋnʋ, sə ʋ tún wá, sə ʋ ya ʋ tʋntʋna, ʋ tʋn tʋtʋŋɩ tə, Zwidasə nə dʋgʋ, ʋ ga va bwálɩ́ tə nə, Yɩɩ nə tún ʋ nə». ");
INSERT INTO nnw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba dàń ma pwárɩ́ kʋ ja Matɩasə. Ʋ mʋ̀ dàń nə ken tʋntʋna fugə nədʋ tə nii nə, ba yà nə ga. ");
INSERT INTO nnw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","*Pantəkɔtə cànà tə dɩɩn nə yí, ba mɛ tə kun duən nə, kʋ mʋ̀ bwálɩ́ nədʋ tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Naa nədʋ, Yɩɩ pɩn zəzugu ndə vʋʋ nəfarʋ nə bà, kʋ sú dìə̀ tə mama nii, ba yà nə jə̀ə́ ka wa. ");
INSERT INTO nnw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Yá ba zəzən ba na wiən ndə mənvoo nə, tə nə nyɩn ndə nəndələ nə, tə twi. Tə mʋ̀ wiən təntə twi, tə pwɛ̀e duən nə, tə jə̀ə́ ba lìù mama yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yɩɩ-*Siŋu tə súə́ ba lìù mama, ba ga wulə ba swɩ̀n sʋ̀ràn yirə duən, kʋ nə pɩn ba, sə ba swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kʋ máŋá təntə nə, lʋʋ nii mama *Zwifə-ba yà twi, ba wulə *Zwerizalɛmə nə. Ba yɩ lɩ̀à tə, ba yà twá Yɩɩ cwəŋə tə nə zəni. ");
INSERT INTO nnw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Zəzugu tə pɩn, lɩ̀à zənzən kɛ̀eń ba va ba kun kʋ bwálɩ́ nə. Ba nə yí lá, kʋ gwárɩ́ ba, də ba lìù mama yà nə nə̀ń ʋ tətə dwíí sʋgʋ, ba nə swɩ̀n lá. ");
INSERT INTO nnw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kʋ gwárɩ́ ba mama, kʋ ga jì yoo ba nə zɩga ba balɩ. Ba dàń ma swɩ̀n duən con, ba wʋ́: «Á nəŋə, lɩ̀à ba tə mɛ, ba nə swɩ̀n nətən tà Galile nagwanaa lɩ̀à naaa? ");
INSERT INTO nnw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yá kʋ dàń twá nətə, nə lìù mama ma nə̀ń ʋ tətə dwíí sʋgʋ lɩ̀à tə nii nə, də ba swɩ̀n? ");
INSERT INTO nnw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Lɩ̀à təntə yà yɩ ba nan Parətə, də Mediə, də Elamə nagwanɛɛ tə wa. Ba duən də yɩ ba nan Mezopotami nagwanaa də Zwide nagwanaa tə wa lɩ̀à, də Kapadɔsə nagwanaa tə wa lɩ̀à, də Pon nagwanaa tə wa lɩ̀à, də Azi nagwanaa tə wa lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kʋ súrí Fərizwi nagwanaa tə wa lɩ̀à nə, də Panfili nagwanaa tə wa lɩ̀à, kʋ ja Ezwipətə lʋʋ nii lɩ̀à, kʋ kə Libi lʋʋ nii lɩ̀à con, kʋ nə pwɛ̀e sɩswɩan də Sirɛnə. Kʋ súrí lɩ̀à tə, ba nə nan *Romə. Lɩ̀à təntə yà yɩ Zwifə-ba, də lɩ̀à tə, ba nə sɛ̀e, ba zʋ Zwifə-ba *yɩjʋncwəŋə tə wa, ");
INSERT INTO nnw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","də Kərɛtə tɩ̀án də Arabi tɩ̀án mama. Kʋ twá nətə, nə lìù mama ma nə̀ń ʋ tətə dwíí sʋgʋ, ba ma bwɩ Yɩɩ nə yofaran tə yɩrɩ, ʋ nə fwa?» ");
INSERT INTO nnw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Halɩ, ba lìù mama yɩ ndə ʋ kʋ́ʋ̀ ba ʋ tɩ̀àn tɩ ba pubʋŋɩ mama jén. Ba dàń swɩ̀n duən con, ba wʋ́: «Yoo kʋ tə dəkuu yɩ bɛ̀eɛ̀e?» ");
INSERT INTO nnw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yá lɩ̀à duən də kʋkʋlɩ ba, ba wʋ́: «Kʋ yɩ swana tə, kʋ yà tə nə wà zàn zənzən nə ba nyʋa ba sú!» ");
INSERT INTO nnw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piyɛrə dàń ma zɩgɩ yɩɩ nə, ʋ mʋ̀ də *tʋntʋna fugə nədʋ tə, ʋ kə ʋ kori yɩɩ nə, ʋ swɩ̀n, ʋ wʋ́: «*Zwifə-ba, də á mʋ̀ lɩ̀à tə mama, á nə wulə *Zwerizalɛmə wa! Á mɛ, sə á yəni yoo kʋ tə! Á cʋga kʋ tə, à nə pɩ̀à, sə à swɩ̀n á con zəni! ");
INSERT INTO nnw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kʋ tà swana nə jə lɩ̀à tə, ndə á mʋ̀ nə bʋŋa nətʋ. Sɩ́ʋ́n nə, yɩɩ tə wà bɩ, kʋ tə yɩ lugu nʋgʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mə kʋ tə yoo nə Yɩɩ twá ʋ nii *sʋ̀sʋ̀nʋ̀ Zwʋwɛlə nə, ʋ ma swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Talɩkwa dɩan tə wa, à mʋ̀ Yɩɩ wá mɩ́ à *Siŋu tə ləzwənyiri mama yuu wa. Á bɩa də á bwɩ̀ɩ́ wá swɩ̀n à nii sʋ̀ràn. À wá pa ləzwəndʋn tə na wiən, tə nə nan à mʋ̀ con, à ga wá bɩrɩ tə duən á bazʋnan nə ba pandwɩa wa. ");
INSERT INTO nnw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tə mʋ̀ dɩan təntə wa, à cɩ́gá wá mɩ́ à Siŋu tə, à tʋtʋnbara də à tʋtʋnkana yuu wa. Yá ba wá swɩ̀n à nii sʋ̀ràn. ");
INSERT INTO nnw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","À wá pa yomɩlan nan yɩɩ nə, à ga pa Yɩɩ dɩ̀àn mɩmɩnan ya tɩa yuu wa: Jana də mən də nywɩ̀ń wá yà lá. ");
INSERT INTO nnw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yɩcaʋ tə wá lwàń kʋ jì yikunu, yá cànà tə wá lwàń ka jì nəsɩan ndə jana nə, sə *Yuu-Tiu dun dɩɩn nəfarʋ tə ga zɩgɩ lá kʋ bà. ");
INSERT INTO nnw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yá lìù tə mama, ʋ nə bon Yuu-Tiu yɩrɩ tə, ʋ wá jon kʋ tíú ʋ cʋna wa›. ");
INSERT INTO nnw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Á mʋ̀ *Yɩzərayɛlə lɩ̀à-ba, á cʋga sʋ̀ràn tə tə! Yɩɩ bɩrɩ də, *Nazarɛtə Zwezi yɩ ʋ mʋ̀ tətə nə pɩn wá nii, kʋ mʋ̀ nə pɩn, Yɩɩ pa ʋ fwa yomɩlan də yogwaran də Yɩɩ dɩ̀àn mɩmɩnan á tətəŋi wa, ndə á tətə nə yə̀ə́ nətʋ. ");
INSERT INTO nnw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yɩɩ yà yə̀ə́ ʋ janʋ tə yoo, kʋ wà ʋ yuu dɩ̀. Ʋ mʋ̀ tətə nə kúrí wá, ʋ tún vàn nə, kʋ nə ba yigə, ndə ʋ nə tanɩ kʋ, sə kʋ ya nətʋ. Ʋ sɛ̀e ʋ pa á ja wá, á pa lɩ̀à tə nə, ba yáá tə̀lə́ Yɩɩ. Ba paa wá dagarʋ yuu, ʋ tɩ. ");
INSERT INTO nnw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yá Yɩɩ dàń cʋ̀gʋ̀ tɩan dɩ̀àn ʋ pìí ʋ bwin wá ʋ lɩ tɩan wa. Tɩan yà wàrɩ̀ wá, tə janɩ tə con mɩ́ámɩ́án. ");
INSERT INTO nnw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pɩ̀ʋ́ *Davidə yà swɩ̀n ʋ yoo, ʋ wʋ́: ‹Máŋá mama, à na Yuu-Tiu à yáá nə. Ʋ wulə à jɩzən vàn nə, sə à dàn ká dʋgʋ Yɩɩ cwəŋə tə. ");
INSERT INTO nnw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kʋ mʋ̀ nə pɩn, à jwɛ à ga swɩ̀n də pupwən. À mʋ̀ nə swə à wá tɩ, də à jə yala, ");
INSERT INTO nnw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","də n bá yá nə tɩga bwálɩ́ nə. N ma bá sɛ̀e, n pa lìù tə n lɩ n tún n cɩcɩ yɩrɩ, sə ʋ pʋ. ");
INSERT INTO nnw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","N bɩrɩ nə coŋi tə, tə nə pɩn mɩɩ. Yá n ga wá ya də nə, n pa à sú də pupwən›. ");
INSERT INTO nnw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","À nubɩa-ba, à jə cwəŋə, sə à swɩ̀n nɩbɛɛ Davidə yoo á con nəpon nəpon. Ʋ tɩga, ba gùrì wá. Də zə̀n mama ʋ ləbəri tə wulə nə tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ʋ yà yɩ Yɩɩ nii sʋ̀sʋ̀nʋ̀, yá ʋ yà yə̀ə́ də, Yɩɩ kàn nii də wá ʋ dù də, ʋ mʋ̀ Yɩɩ wá pa, Davidə nàʋ́ də́ ʋ nɩbɛɛ Davidə pàrɩ̀ tə. ");
INSERT INTO nnw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ʋ nə swɩ̀n də, ba bá yá wá tɩga bwálɩ́ nə, yá ʋ yatana tə bá pʋ, kʋ yɩ *Kərisə nə wá tɩ ʋ pìí ʋ bwin tə yoo nə, ʋ yà yə̀ə́. Yá mə kʋ mʋ̀ yoo nə, ʋ swɩ̀n nətʋ. ");
INSERT INTO nnw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ʋ mʋ̀ Zwezi təntə nə, Yɩɩ pìí ʋ bwin ʋ lɩ tɩga wa, nə mama wàá nə bɩrɩ də, nə nɩ kʋ. ");
INSERT INTO nnw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yɩɩ pɩn, ʋ dɩ̀ ʋ jə̀ə́ ʋ jɩzən vàn nə. Ʋ yà kàn nii də, ʋ wá pa ʋ Siŋu tə. Yá ʋ mʋ̀ Zwezi dàń nə jon Yɩɩ-Siŋu tə nə nyɩna Yɩɩ con, ʋ mɩ́ tɩa yuu. Mə kʋ mʋ̀ nə á nə̀ń, á ga na nətən. ");
INSERT INTO nnw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pɩ̀ʋ́ Davidə tətə wà Yɩɩ *sàń nə dɩ̀, yá ʋ swɩ̀n, ʋ wʋ́: ‹Yuu-Tiu swɩ̀n à Yuu-Tiu con, ʋ wʋ́: «Bàá n jə̀ń à jɩzən vàn nə, ");
INSERT INTO nnw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","də à ma kəni n dʋŋa n nɛɛ də̀ń nə!» › ");
INSERT INTO nnw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yɩzərayɛlə dwíí tə mama dàń mɛ, sə kʋ lwarɩ cɩ́gá cɩ́gá də, Yɩɩ pɩn Zwezi tə, á nə pɩn ba paa dagarʋ tə yuu, jì Yuu-Tiu, ʋ tə zɩgɩ lá ʋ yɩ Kərisə». ");
INSERT INTO nnw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ba cʋgʋ tə mʋ̀ sʋ̀ràn təntə, yá ba bɩcanɩ dí zənzən. Ba dàń ga bwe Piyɛrə də *tʋntʋna tə duən tə, ba wʋ́: «À nubɩa-ba, bɛ̀eɛ̀e tətə nə nə dàń mɛ, sə nə fwa?» ");
INSERT INTO nnw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyɛrə ma le ba, ʋ wʋ́: «Á vəvərə á kwa á ma sá á cʋna, sə Yɩɩ kwɛn ʋ lɩ á cʋna tə á mʋ̀ də wá pwərə wa, sə ba bon Zwezi-*Kərisə yɩrɩ, ba ma lə aba nɩ́á wa, kʋ twá də Zwezi-Kərisə yɩrɩ. Yá kʋ nətʋ tə nii nə súə́, á wá na Yɩɩ-*Siŋu tə tarpɩʋn tə. ");
INSERT INTO nnw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yɩɩ nikanɩ tə yɩ á mʋ̀ də á bɩa, də lɩ̀à tə mama, ba nə ŋʋ́ná nyiən. Kʋ yɩ lɩ̀à tə mama, nə *Yuu-Tiu Yɩɩ nə wá bon ba, sə ba bà ʋ con nyiən». ");
INSERT INTO nnw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Yá Piyɛrə tə tì sʋ̀ràn duən, ʋ swɩ̀n ʋ bɩrɩ ba, ʋ ma kwè ba, ʋ wʋ́: «Á naŋa, á ga yá zə̀n cʋna lɩ̀à tə, sə á jon á tɩ̀àn». ");
INSERT INTO nnw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ba ləgə lɩ̀à tə, ba nə sɛ̀e Piyɛrə sʋgʋ tə, nɩ́á wa, kʋ twá də Zwezi-Kərisə yɩrɩ. Yá kʋ mʋ̀ dɩɩn tə nə, lɩ̀à yí ndə mʋ̀rʋ̀ batwa nə, ba nə súrí Zwezi kwa lɩ̀à tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ba yà ŋwɩ̀ń ba yáá lá də kàrà tə, Zwezi *tʋntʋna tə nə bɩrɩ ba. Ba yà jə *nimarʋ, ba də́ ba wodiu duən nə, yá ba jʋ̀nɩ̀ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yɩɩ yà twá də tʋntʋna tə, ʋ tʋŋa yogwaran də Yɩɩ dɩ̀àn mɩmɩnan zənzən. Kʋ mʋ̀ nə pɩn, ba lìù mama yà dəri fən. ");
INSERT INTO nnw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","*Kərisə lɩ̀à tə mama yà ken duən nə, yá ba mɛ won yà yɩ nədʋ. ");
INSERT INTO nnw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ba yà yoli ba wiən, də won tə mama, ba nə jə. Kʋ tə, ba nə yoli ba na, ba yàá tì kʋ ba tàrà ba pa lìù mama nə, ndə nətʋ tə kʋ nə mɛ də wá. ");
INSERT INTO nnw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ba yà ja pɩ́nʋ́ wuuu, ba dàn ká pìí ba kə ba kwa, ba ga wulə duən nə *Zwifə-ba Yɩɩ *dìə̀ tə wa. Yá ba yàá kun duən nə ba dii wa, ba də́ *Yuu-Tiu nimarʋ wodiu tə, ba ga də́ ba wodiu də pupwən. Ba ga ba yokʋkwɩnan tuŋə ba bɩcanɩ wa. ");
INSERT INTO nnw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ba yàá bʋ Yɩɩ nə, lɩ̀à tə mama pwìí ga poli ba yuu wa. Yá dɩɩn mama Yuu-Tiu yàá súrí lɩ̀à ʋ lɩ̀à púlí tə nii nə, ba nə ken ba waa Zwezi nə, sə ʋ jon ba ba cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dədəni nii lugu batwa máŋá wa, Piyɛrə də Zwan yà vəli *Zwifə-ba Yɩɩ *dìə̀ wa, sə ba jʋn Yɩɩ. Kʋ máŋá təntə yà yɩ Zwifə-ba yɩjʋnɩ máŋá, kʋ nə mɩ̀ ba. ");
INSERT INTO nnw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bɛɛ don, ba nə lʋrɩ wá, də ʋ yɩ gwànʋ́, də yà wulə. Dɩɩn mama, ba yàá ja wá, ba va ba jə̀ə́ Yɩɩ dìə̀ tə mimii nə, ba nə boŋə ‹mimii zaŋʋ›, sə lɩ̀à tə, ba nə zwɩ Yɩɩ dìə̀ tə wa, pa wá yɩlori wiən. ");
INSERT INTO nnw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ʋ mʋ̀ bɛɛ təntə nɩ Piyɛrə də Zwan də, ba pɩ̀à, sə ba zʋ Yɩɩ dìə̀ tə wa, ʋ ma lòrì yɩlori won ba con. ");
INSERT INTO nnw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piyɛrə də Zwan mama ma fin ba yɩ́á, ba kə ʋ yuu, ba ga swɩ̀n ʋ con, ba wʋ́: «Ywàń nəba!» ");
INSERT INTO nnw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Bɛɛ tə ma ywàń ba zən, ʋ ga dànɩ̀, sə ba pa wá won. ");
INSERT INTO nnw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piyɛrə dàń ma swɩ̀n ʋ con, ʋ wʋ́: «À ba səbiu jə, à dàń wá pa mʋ́ kʋ tə, à nə jə. Də *Nazarɛtə Zwezi-*Kərisə yɩrɩ tə, zàn yɩɩ nə, n va!» ");
INSERT INTO nnw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Ʋ ga ja ʋ jɩzən nə ʋ van wá, ʋ zɩ̀n. Də naa nədʋ, bɛɛ tə napɩra də ʋ nɛɛ tə mama dàn, yá ʋ ga fan ʋ zɩga yɩɩ nə, ʋ vəli. Ʋ twá ba nə, ʋ zʋ Yɩɩ dìə̀ tə wa, ʋ vəli də ʋ faŋa, ʋ ga bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yá lalʋʋ tə mama nɩ wá, də ʋ vəli də ʋ bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Lìù mama nə nɩ wá, n yə̀ə́ ʋ swɩ́án. N yə̀ə́ də, ʋ mʋ̀ yà nə jəni Yɩɩ dìə̀ tə, ‹mimii zaŋʋ› tə nə, ʋ lòrì yɩlori wiən tə. Kʋ kə lá lɩ̀à tə zənzən. Kʋ yoo təntə, kʋ nə tʋn bɛɛ tə yɩra, yɩ yogwarʋ kʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bɛɛ tə kʋ́ʋ̀ ba Piyɛrə də Zwan kwa naŋa. Kʋ gwárɩ́ lɩ̀à tə, ba dàń dəri, ba va ba kɩkarɩ ba. Yɩɩ dìə̀ tə bwálɩ́ don nə, kʋ nə jə napakʋlʋ, ba boŋə kʋ napakʋlʋ təntə ‹*Salʋmʋn napakʋlʋ›. ");
INSERT INTO nnw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piyɛrə nə nɩ kʋ mʋ̀ təntə, ʋ swɩ̀n lalʋʋ tə con, ʋ wʋ́: «*Yɩzərayɛlə lɩ̀à-ba, bɛ̀eɛ̀e nə pɩn, kʋ ma gwárɩ́ aba? Bɛ̀eɛ̀e nə pɩn á mama yɩ́á ma cə̀ nə yuu? Á bʋŋa də, kʋ yɩ nə mʋ̀ dɩ̀àn, nə à yə̀ə́ nə ka twá Yɩɩ cwəŋə tə nə zəni yɩrɩ, bɛɛ tə ma zàn ʋ vəli, naaa? ");
INSERT INTO nnw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yɩɩ tə, nə nɩbara *Abərahamə, də *Yɩzakə, də *Zwakɔbə, də nə nɩbara-ba duən nə jʋn tə nə pɩn, ʋ tʋ̀tʋ̀nʋ̀ Zwezi na dun. Ʋ mʋ̀ Zwezi tə, á tətə nə jɩn, á pa *Pilatə nə. Pilatə yà pɩ̀à, sə ʋ dʋgʋ wá, á ga wà sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Zwezi yà yɩ lìù tə, Yɩɩ nə lɩ ʋ tún ʋ cɩcɩ yɩrɩ, ʋ ga yɩ cɩ́gá tíú də. Də kʋ mɛ á vɩga wá, á ga lòrì, sə Pilatə dʋgʋ lagʋrʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Á zɩgɩ kʋ tə nə, pɩ̀ʋ́ Pilatə yà nə pɩ̀à, sə ʋ fwa á kálɩ́ á pa, mɩɩ tíú Zwezi tɩ. Yɩɩ pìí ʋ bwin wá, ʋ lɩ tɩga wa, nə yɩ lɩ̀à tə nə, nə nɩ kʋ. ");
INSERT INTO nnw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Bɛɛ wà tə nətən, á nə na, á yə̀ə́ wá, kʋ ga yɩ Zwezi yɩrɩ tə dɩ̀àn nə pɩn ʋ na yazurə, nə nə ken nə waa Zwezi nə yɩrɩ. Kʋ yɩ ʋ nə ken ʋ waa Zwezi nə tə, kʋ mʋ̀ nə pɩn, ʋ ma na yazurə mɩ́ámɩ́án. ");
INSERT INTO nnw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","À nubɩa-ba, à yə̀ə́ də, á mʋ̀ də á yáá tɩ̀án tə mama yɩ á tʋn kʋ mʋ̀ yoo təntə á ləyəri wa. ");
INSERT INTO nnw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yɩɩ dí yáá, ʋ twá ʋ nii *sʋ̀sʋ̀nà tə mama nə, ʋ swɩ̀n də, *Kərisə wá na càn. Yá sɩ́ʋ́n nə, Yɩɩ sʋgʋ tə nii dàń súə́. ");
INSERT INTO nnw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kʋ mʋ̀ tə yɩrɩ, á vəvərə á kwa á ma sá á cʋna, sə ʋ kwɛn ʋ lɩ á cʋna tə á mʋ̀ də wá pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Á nə fwa nətʋ, *Yuu-Tiu wá pa aba sìə́ máŋá. Yá ʋ wá tʋn Kərisə, ʋ nə kúrí tə, ʋ pa ʋ bà á con. Ʋ mʋ̀ Kərisə tə nə yɩ Zwezi. ");
INSERT INTO nnw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Sɩ́ʋ́n nə, Zwezi jə̀ə́ Yɩɩ *sàń nə, ʋ ma dànɩ̀ won mama nə wá pìí kʋ jì, ndə Yɩɩ nə twá ʋ nii sʋ̀sʋ̀nà tə, ba nə yɩ ʋ nə tɩ, ʋ ma swɩ̀n fuən fuən. ");
INSERT INTO nnw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","*Moyizə swɩ̀n, ʋ wʋ́: ‹Yuu-Tiu Yɩɩ wá lɩ ʋ nii sʋ̀sʋ̀nʋ̀ á nubɩa tə wa, ndə à nə ʋ pa aba. Á cʋga sʋ̀ràn tə mama, ʋ nə wá swɩ̀n á con. ");
INSERT INTO nnw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Lìù tə mama, ʋ nə ba ʋ mʋ̀ Yɩɩ nii sʋ̀sʋ̀nʋ̀ təntə sʋgʋ cʋga, ba wá lɩ wá Yɩɩ lɩ̀à tə dwíí wa›. ");
INSERT INTO nnw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yá Yɩɩ nii sʋ̀sʋ̀nà tə mama, kʋ nə zɩgɩ Yɩɩ nii sʋ̀sʋ̀nʋ̀ Samɩyɛlə nə, kʋ ja va ba duən tə, ba mama swɩ̀n dɩan təntə yoo. ");
INSERT INTO nnw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Á yɩ Yɩɩ nii sʋ̀sʋ̀nà tə bɩa, yá Yɩɩ jɩn *nimarʋ də á nɩbara-ba. Ʋ swɩ̀n *Abərahamə con, ʋ wʋ́: ‹Tɩa yuu lɩ̀à mama wá twá n dwíí nə, sə Yɩɩ fwa zəni ba yɩra›. ");
INSERT INTO nnw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yɩɩ dí yáá, ʋ tàà á mʋ̀ yɩrɩ, ʋ pa ʋ tʋ̀tʋ̀nʋ̀ tə nan, sə ʋ fwa zəni á yɩra. Sə Yɩɩ pa, á lìù mama dàń lwàń ʋ pubʋŋa, ʋ ga yá ʋ yokʋkwɩnan». ");
INSERT INTO nnw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piyɛrə də Zwan yà tə wulə ba swɩ̀n lɩ̀à tə con, də *Zwifə-ba Yɩɩ *joŋwana tə, də lɩ̀à tə, ba nə cɩ̀ Zwifə-ba Yɩɩ *dìə̀ tə nə yáá tíú, də *Sadɩsɩan-ba twi ba yí. ");
INSERT INTO nnw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ba lɩŋa zàn Piyɛrə də Zwan yuu zənzən, ba nə yà kàrɩ̀ lɩ̀à tə, ba ga bɩrɩ də, Zwezi pìí ʋ bwin, ʋ nan tɩan wa tə yɩrɩ. Kʋ kàrà təntə pɩ̀à kʋ bɩrɩ də, lɩ̀à duən tə wá bwin, ba nan tɩan wa. ");
INSERT INTO nnw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kʋ yà yɩ dədəni nii nə. Kʋ mʋ̀ nə pɩn, ba ja ba, ba kə bàń dìə̀, kʋ ja va tɩpʋrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lɩ̀à tə, ba nə cʋgʋ sʋgʋ tə wa lɩ̀à zənzən, ken ba waa Zwezi nə. Ba mama nə ken duən nə, ba yí ndə bara mʋ̀rʋ̀ bonu nə. ");
INSERT INTO nnw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Kʋ tɩa nə pʋrɩ, Zwifə-ba yáá tɩ̀án, də ba *nəkwɩna, də Yɩɩ nii *yənu tɩ̀án, də Yɩɩ joŋwana yun tɩ̀án nəkwɩa Anə tətə, də Kayifə, də Zwan, də Alɛkəzandərə, də lɩ̀à tə mama, ba nə də́ joŋwana yun tɩ̀án dwíí tə wa, vəli ba kun duən nə *Zwerizalɛmə wa. ");
INSERT INTO nnw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba ja Piyɛrə də Zwan tə, ba bà, ba zɩgɩ ba tətəŋi wa, ba ga bwe ba, ba wʋ́: «Kʋ yɩ bɛ̀eɛ̀e dɩ̀àn nə á jə, nə à yə̀ə́ kʋ yɩ wà tətə yɩrɩ nə, á twá á ma pa, gwànʋ́ tə zàn?» ");
INSERT INTO nnw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kʋ máŋá tə wa, Piyɛrə nə súə́ də Yɩɩ-*Siŋu tə, ʋ le ba, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«*Yɩzərayɛlə lɩ̀à yáá tɩ̀án-ba, də ba nəkwɩna-ba, zə̀n kʋ tə, á bwe nəba yozəŋu tə yoo, kʋ nə tʋn gwànʋ́ tə yɩra. Á pɩ̀à, sə á lwarɩ, kʋ nə twá nətʋ, ʋ ma na yazurə. ");
INSERT INTO nnw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kʋ mʋ̀ tə yɩrɩ á mama mɛ, sə á lwarɩ! Sə Yɩzərayɛlə lɩ̀à tə mama lwarɩ! Kʋ yɩ kʋ twá də *Nazarɛtə Zwezi-*Kərisə yɩrɩ tə dɩ̀àn, bɛɛ wà tə ma zɩga á yáá con də yazurə. Á paa ʋ mʋ̀ Zwezi təntə dagarʋ yuu. Yá Yɩɩ dàń bwin wá, ʋ lɩ tɩan wa. ");
INSERT INTO nnw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mə ʋ mʋ̀ yoo nə Yɩɩ sagɩ tə yà dí yáá kʋ swɩ̀n, ʋ wʋ́: ‹Kapan tə, á mʋ̀ də̀lwə̀rə́ tə nə vɩga á dʋgʋ vàn nə, kʋ mʋ̀ nə pìí kʋ jì dìə̀ tə nigwancɩɩn wárɩ́, kʋ yoo nə cà›. ");
INSERT INTO nnw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lʋʋ tə mɛ wa, Yɩɩ wà yɩrɩ lìù don nə pɩn, nə nə wá twá kʋ tíú nə, sə Yɩɩ jon nəba nə cʋna wa. Kʋ mʋ̀ nə pɩn, Yɩɩ twá Zwezi cɩcɩ nə, ʋ ma jon lɩ̀à nə ba cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ba nɩ də, fən ba Piyɛrə də Zwan jə kʋ yoo tə wa, yá kʋ ga gwárɩ́ ba zəni. Kʋ gwárɩ́ ba, ba ga lwarɩ də, ba yɩ lɩ̀à tə, ba nə tà yənu tɩ̀án, ba ga wà kàrà fwa. Ba lwarɩ də, Piyɛrə də Zwan yɩ Zwezi twaduən. ");
INSERT INTO nnw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yá ba nə na bɛɛ tə, ʋ nə nɩ yazurə, ʋ zɩga ba nii nə, ba wàrɩ̀ yoo mama ba le. ");
INSERT INTO nnw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ba dàń ma pa Piyɛrə-ba nan dìə̀ tə, Zwifə-ba yun tɩ̀án, ba nə bʋ̀rɩ̀ *bʋ̀rà tə wa, ba ga swɩ̀n duən con, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Bɛ̀eɛ̀e nə nə wá fwa də bara ba tə? Cɩ́gá mama *Zwerizalɛmə tɩ̀án tə mama yə̀ə́ Yɩɩ dɩ̀àn mɩmɩnan kʋ tə yoo, lɩ̀à təntə nə fwa. Kʋ ba sə̀gə̀, nə də ga wàrɩ̀ kʋ nə tɛn. ");
INSERT INTO nnw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kʋ wà mɛ, sə yoo kʋ tə tàà tɩa mama, kʋ súrí lá lɩ̀à tə wa. Nə dàń wá dù súú ba nii nə, ba kʋ́ʋ̀ dàn ká swɩ̀n, ba za kʋ mʋ̀ Zwezi təntə yɩrɩ, lìù mama con». ");
INSERT INTO nnw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ba dàń ma kʋ́ʋ̀ bon Piyɛrə də Zwan, ba swɩ̀n ba con, sə ba pa kʋ mɛ lá. Ba kʋ́ʋ̀ dàn ká pìí, ba bon Zwezi yɩrɩ, nə à yə̀ə́, sə ba kàrɩ̀ lɩ̀à də kʋ mʋ̀ yɩrɩ təntə. ");
INSERT INTO nnw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piyɛrə-ba ma le, ba wʋ́: «Á tətə ywàŋá kʋ wa, Yɩɩ yáá con kʋ mɛ, sə nə zìlí á mʋ̀ nii, nə ga yá Yɩɩ, naaa? ");
INSERT INTO nnw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kʋ tə nə mʋ̀ nə nɩ də nə yɩ́á, nə ga nì kʋ yoo də nə zɩan, nə wàrɩ̀ kʋ nə nə cɩ̀, nə pa nə ba kʋ yoo swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Zwifə-ba yun tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, kʋ́ʋ̀ caga ba nii nə, ba ga lɩ ba ba dʋgʋ. Lalʋʋ tə mama yɩ ba bwɩ Yɩɩ nə, yoo tə yɩrɩ, kʋ nə tʋn. Kʋ mʋ̀ nə pɩn, ba yà yə̀rì cwəŋə tə, ba nə wá tì, sə ba ma kə ba càn wa. ");
INSERT INTO nnw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bɛɛ tə, Yɩɩ dɩ̀àn mɩmɩnʋ tə nə tʋn ʋ yɩra, kʋ pa ʋ na yazurə tə, bɩna yà dwə sapwilə. ");
INSERT INTO nnw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ba zəzən ba dʋgʋ Piyɛrə də Zwan, ba vəli ba nubɩa tə con. Ba vəli ba man kʋ tə mama, *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə də Zwifə-ba *nəkwɩna tə nə swɩ̀n ba con. ");
INSERT INTO nnw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ba nubiduən tə nə cʋgʋ ba nii tə, ba zwɛ̀e, yá *Kərisə lɩ̀à tə mama ken ba kori yɩɩ nə, ba swɩ̀n Yɩɩ con, ba wʋ́: «*Yuu-Tiu, n mʋ̀ nə fwa lanworu də tɩa də mʋʋ, də wiən tə mama, tə nə wulə tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","N mʋ̀ nə twá n *Siŋu tə nə, n ma kə sʋ̀ràn tə tə nə nɩbɛɛ *Davidə, ʋ nə yɩ n tʋ̀tʋ̀nʋ̀, nii wa. Ʋ swɩ̀n, ʋ wʋ́: ‹Bɛ̀eɛ̀e nə pɩn, lʋʋ dwíə́ tə mama lɩŋa ma zaŋa duən yun wa? Yá lɩ̀à ma jə pubʋŋɩ tə nə ba ziən? ");
INSERT INTO nnw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tɩa yuu pɛ̀egá ken duən nə, yáá tɩ̀án boli duən yɩra, sə ba jì nədʋ, ba ma jan də Yuu-Tiu›. ");
INSERT INTO nnw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Cɩ́gá, *Erodə də Ponsə *Pilatə ken duən nə tɩfarʋ kʋ tə wa. Ba mʋ̀ də lʋʋ dwíə́ tə mama də *Yɩzərayɛlə lɩ̀à, sə ba zɩgɩ n mʋ̀ Yɩɩ cɩcɩ tʋ̀tʋ̀nʋ̀ Zwezi nə, n nə kúrí, sə ʋ ya Kərisə. ");
INSERT INTO nnw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba fwa kʋ tə mama, n dɩ̀àn tə də n pubʋŋa tə yà nə ken kʋ sírí. ");
INSERT INTO nnw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yá sɩ́ʋ́n nə, Yuu-Tiu cʋgʋ ba wʋlwan sʋ̀ràn tə, sə n pa n *tʋntʋna tə swɩ̀n n sʋgʋ tə də bɩcadɩʋ. ");
INSERT INTO nnw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bɩrɩ n dɩ̀àn tə, sə n zwɛ̀e lɩ̀à yayɩran, sə n dɩ̀àn mɩmɩnʋ yìə̀n də yomɩlan twá n mʋ̀ Yɩɩ cɩcɩ tʋ̀tʋ̀nʋ̀ Zwezi yɩrɩ tə nə tə tʋn». ");
INSERT INTO nnw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ba nə lòrì Yɩɩ ba zwɛ̀e máŋá wa, bwálɩ́ tə, ba yà nə jə̀ń tə, vuvugu. Ba mama ga sú də Yɩɩ-Siŋu tə, ba ga swɩ̀n Yɩɩ sʋgʋ tə də bɩcadɩʋ. ");
INSERT INTO nnw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kʋ máŋá tə wa, ba lwarɩ də, *Kərisə lɩ̀à tə mama pubʋŋa yà yɩ nədʋ. Ba lìù mama ba swɩ̀n də, ʋ won yɩ ʋ mʋ̀ cɩcɩ nə tɩ. Ba mama won yà yɩ nədʋ. ");
INSERT INTO nnw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","*Tʋntʋna tə swɩ̀n Zwezi yoo ba bɩrɩ də dɩ̀àn. Ba bɩrɩ də, *Yuu-Tiu Zwezi pìí ʋ bwin ʋ nan tɩga wa. Yá Yɩɩ yà fwa pubwanʋ ba mama yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Won mama yà wà ba wa lìù mama mùrì. Ba wa lìù tə, ʋ nə jə kárɩ́, nə à yə̀ə́ dii, ʋ yàá tì tə ʋ yoli, ʋ ja kʋ kwənə, ʋ ja bà tʋntʋna tə con. Ba dàń yà tàrà səbiu tə, ndə kʋ nə mɛ də lìù mama, ba pa wá. ");
INSERT INTO nnw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Zwʋzɛfə, də yà yɩ bɛɛ don Zwezi tʋntʋna tə nə, ken ʋ yɩrɩ Barənabasə, kʋ də̀ń nə yɩ ‹kwinu›, də yà wulə də ba. Ʋ mʋ̀ Zwʋzɛfə təntə yɩ Levi tə dwíí tə wa lìù. Ba lʋrɩ wá Swipərə lʋʋ nii wa. ");
INSERT INTO nnw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Zwʋzɛfə tə yoli ʋ kárá, ʋ ja kʋ səbiu tə, ʋ bà, ʋ pa tʋntʋna tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Bɛɛ don yà wulə, ʋ yɩrɩ yɩ Ananɩasə, də ʋ kan, ʋ də yɩrɩ yɩ Safɩra. Ʋ mʋ̀ Ananɩasə təntə də ʋ kan ken nimarʋ, ba tì ba kárá, ba yə̀. ");
INSERT INTO nnw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ba dàń ga lɩ kʋ səbiu tə vàn don, ba sə̀gə̀, sə ba ma fwa ba nyiən. Yá ba dàń ga ja kʋ gɩganɩ tə, ba va ba pa Zwezi *tʋntʋna tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piyɛrə dàń ma bwe wá, ʋ wʋ́: «Ananɩasə, bɛ̀eɛ̀e nə pɩn, n ma cʋgʋ *Sɩtana kwìə̀? Kʋ pa n kʋna kʋnkʋn, n kə Yɩɩ-*Siŋu tə nii nə. N lɩ səbiu tə vàn don, n ma fwa n nyiən? ");
INSERT INTO nnw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kárá tə yà nə wà yə̀, ka yà tə n mʋ̀ nyiən, naaa? Yá də ka nə yə̀ tə, ka səbiu tə yà tə tà n mʋ̀ nyiən, naaa? Kʋ yɩ nətə, n ma bʋ́n pubʋŋa kʋ tə yiri n waa con? Kʋ tà ləzoni con nə, n kʋnɩ, kʋ ya Yɩɩ con nə n kʋnɩ». ");
INSERT INTO nnw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananɩasə nə nì tə sʋ̀ràn tə, ʋ tʋa, yá mə ʋ tɩan də nə. Yá fən dàń gən lɩ̀à tə mama, ba yà nə zɩgɩ lá. ");
INSERT INTO nnw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Balandʋra tə nyɩ́ ba zàn, ba pəpəni wá, ba tì ba ja va ba gùrì. ");
INSERT INTO nnw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kʋ nə kɛ̀eń ndə lugu batwa nə, Ananɩasə kan twi ʋ zʋ. Yá ʋ ga wà lwarɩ kʋ tə, kʋ nə tʋn kʋ lɛ. ");
INSERT INTO nnw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyɛrə ma bwe, ʋ wʋ́: «Swɩ̀n cɩ́gá à con! Mə á kárá tə səbiu nə nətən, á nə yə̀ á na?» Kan tə ma le, ʋ wʋ́: «Awo, mə kʋ nii nə». ");
INSERT INTO nnw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piyɛrə dàń ma swɩ̀n ʋ con: «Bɛ̀eɛ̀e nə pɩn, á ma kə kʋ nimarʋ təntə, sə á ma pɩ̀à *Yuu-Tiu Yɩɩ-Siŋu tə nii nə? Haya, nə̀ń lɩ̀à tə, ba nə gùrì n barɩ tə nə, ba wulə mimii nə. Yá ba kʋ́ʋ̀ wá gùrì n də». ");
INSERT INTO nnw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Naa nədʋ, də kan tə də tʋa, kʋ máŋá tə tətə wa, Piyɛrə yáá nə, ʋ tɩ. Balandʋra tə zʋa də ʋ tɩga, ba ma tì ʋ də, ba ja va ba gùrì ʋ barɩ tə səpuni nə. ");
INSERT INTO nnw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Fən gən *Kərisə lɩ̀à púlí tə, də lɩ̀à tə mama, ba nə nì kʋ yoo təntə. ");
INSERT INTO nnw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zwezi-*Kərisə *tʋntʋna tə yà tʋŋa Yɩɩ dɩ̀àn mɩmɩnan zənzən də yomɩlan zənzən, lalʋʋ tə tətəŋi wa. Kərisə lɩ̀à tə mama dàń yà zɩga duən yáá nə, *Salʋmʋn napakʋlʋ tə də̀ń nə. ");
INSERT INTO nnw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yá lìù mama dàń kʋ́ʋ̀ ba lalʋʋ tə wa naŋa, ʋ gùlí ba wa. Yá lalʋʋ tə mama dàń yà ga bwɩ ba nə zəni. ");
INSERT INTO nnw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bara də kana kapʋpʋ, ba nə ken ba waa *Yuu-Tiu nə, dàń yà pùlì ba súrí lá. ");
INSERT INTO nnw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kʋ pa, ba dàń janɩ yayɩŋa, ba naŋa coŋi tə yuu, ba tuŋə gədərən yuu də sarɩ wa. Piyɛrə dàń nə twi ʋ lɛ, sə ʋ yɩywara tə twá ba duən mə yuu. ");
INSERT INTO nnw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lalʋʋ, kʋ nə nan *Zwerizalɛmə nii tɩan duən də dəri kʋ twi də kʋ yayɩŋa, də lɩ̀à, *zinə nə wʋwalɩ ba. Yá ba mama ga na yazurə. ");
INSERT INTO nnw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kʋ máŋá tə wa, *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə, də ba tə, ba nə wulə də wá, kʋ mʋ̀ nə nə ya *Sadɩsɩan-ba tə, dàń zàn də wʋgwɩʋ. ");
INSERT INTO nnw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba jɩn Zwezi-*Kərisə *tʋntʋna tə, ba kə bàń dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yá kʋ tɩtɩn nə, *Yuu-Tiu *malɩka twi, ka súrú bàń dìə̀ mimiən tə, ka lɩ ba, ka ga swɩ̀n ba con: ");
INSERT INTO nnw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Á vələ Zwifə-ba Yɩɩ *dìə̀ tə wa, á swɩ̀n sʋywáŋʋ́ tə, kʋ nə bɩrɩ mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con». ");
INSERT INTO nnw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ba nə nì kʋ sʋgʋ təntə, kʋ jɩjʋ tətə nə, ba zʋa Yɩɩ dìə̀ tə wa, ba ga wulə ba kàrɩ̀. Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə, də ʋ kwa lɩ̀à dàń zàn, ba bon yun tɩ̀án tə, ba nə bʋ̀rɩ̀ *bʋ̀rà tə, də *Yɩzərayɛlə dwíí tə wa *nəkwɩna tə, ba kə duən nə. Ba dàń ga tʋn ba lɩ̀à, sə ba va ba lɩ tʋntʋna tə bàń dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ba lɩ̀à tə dàń nə vəli, ba yí lá, ba wà ba nɩ bàń dìə̀ tə wa. Ba ma pìí ba va, ba tún ba nii, ");
INSERT INTO nnw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ba wʋ́: «Nə vəli, də bàń dìə̀ tə tagʋ, yá pamana tə, ba yà nə cɩ̀gà ba nə tə, də wulə mimiən tə nə. Yá nə dàń súrú, nə wà lìù mama nɩ bàń dìə̀ tə wa». ");
INSERT INTO nnw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Máŋá tə wa, Yɩɩ dìə̀ tə tʋtʋnbɩa yuu tíú tə, də joŋwana yun tɩ̀án tə nə nì sʋ̀ràn təntə, ba kʋ́ʋ̀ yə̀rì kʋ tə, ba nə wá fwa də yoo tə, kʋ nə wá bà yoo təntə kwa nə. ");
INSERT INTO nnw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lìù don kʋ́ʋ̀ twi, ʋ swɩ̀n ba con, ʋ wʋ́: «Á nəŋə, bara tə, á nə ken bàń dìə̀ tə wa, wulə Zwifə-ba Yɩɩ dìə̀ tə wa, ba kàrɩ̀ lalʋʋ tə». ");
INSERT INTO nnw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tʋtʋnbɩa yuu tíú tə də ʋ kwa lɩ̀à tə, dàń vəli sənbwen, ba ja ba ba ja vìí. Lalʋʋ tə yà swə tʋntʋna tə. Yá kʋ yà wàá tʋtʋnbɩa yuu tíú tə də ʋ kwa lɩ̀à tə, ba dɩlɩ də kapana. Kʋ mʋ̀ nə pɩn, ba yà dəri fən, sə ba fɩfɩn tʋntʋna tə. ");
INSERT INTO nnw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kʋ kwa nə, ba jɩn tʋntʋna tə, ba pìí ba va yun tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə yáá con. Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə dàń bwe ba, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Nə wà sɩnɩ nə swɩ̀n á con, sə á kʋ́ʋ̀ dànà ká twà də Zwezi yɩrɩ tə, á ma kàrɩ̀ lalʋʋ tə, naaa? Kʋ nə á pa, á kàrà tə sú *Zwerizalɛmə mama. Á dàń ga pɩ̀à, sə nə mʋ̀ nə zɩn bɛɛ təntə tɩan tə talɩ nə yun wa». ");
INSERT INTO nnw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyɛrə də tʋntʋna tə duən tə dàń ma le, ba wʋ́: «Kʋ tà ləzwənə nii nə, nə mɛ, sə nə zìlí. Kʋ ya Yɩɩ nii nə, nə mɛ, sə nə zìlí. ");
INSERT INTO nnw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yɩɩ tə, nə nɩbara-ba tə nə jʋ̀nɩ̀, nə bwin ʋ mʋ̀ Zwezi təntə, á nə paa dagarʋ tə yuu wa, á gʋ. ");
INSERT INTO nnw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yɩɩ ken wá ʋ dun bwálɩ́ wa, ʋ jɩzən vàn nə, sə ʋ yà pɩ̀ʋ́ tə, ʋ nə wá jon lɩ̀à ba cʋna wa. Ʋ wá san Yɩzərayɛlə lɩ̀à tə nə, sə ba vəvəri ba kwa ba sá ba cʋna tə, sə ʋ ma wànɩ́ ʋ kwɛn ba cʋna tə, ba mʋ̀ də wá pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nə ya yìə̀n təntə, tə nə tʋn tə sʋ̀sʋ̀nà, nə wàá nə swɩ̀n nə bɩrɩ də, nə nɩ tə. Nə mʋ̀ də Yɩɩ-*Siŋu tə, Yɩɩ nə pɩn lɩ̀à tə nə, ba nə zìlí ʋ nii tə». ");
INSERT INTO nnw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yun tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, nə nì tə sʋ̀ràn təntə, ba súə́ də lɩŋa, ba dàń ga pɩ̀à, sə ba gʋ tʋntʋna tə. ");
INSERT INTO nnw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yá bɛɛ don dàń yɩn lá, ʋ yɩrɩ nə yɩ Gamalɩɛlə. Ʋ yɩ *Farɩzɩan-ba púlí tə wa lìù, ʋ nə yɩ Yɩɩ nii *yənu tíú. Ba mɛ yà zìlí wá zənzən. Ʋ nyɩ́ ʋ zàn yun tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə wa, ʋ ga pa nii, sə ba lɩ tʋntʋna tə kàrá wa, máŋá mancɩn. ");
INSERT INTO nnw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kʋ kwa nə, ʋ dàń ma swɩ̀n, ʋ wʋ́: «Á cɩa á tətə nə, á mʋ̀ lɩ̀à tə, á nə ya Yɩzərayɛlə dwíí tə, də won tə, á nə pɩ̀à, á tʋn ba mʋ̀ lɩ̀à təntə yɩra. ");
INSERT INTO nnw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Máŋá kʋ nə lɛ, kʋ tə wà dánɩ́, Tɩdasə də yà zàn, ʋ bɩrɩ də, ʋ jə dun. Lɩ̀à, ba nə yí ndə biənɩa nə, yà nə vəli ba twá ʋ nə. Yá ba gʋa wá, ʋ kwa lɩ̀à tə, də ba tʋtʋnan tə mama jén lá. ");
INSERT INTO nnw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ʋ mʋ̀ təntə kwa nə, Zwidasə, ʋ nə ya Galile tíú, də kʋ́ʋ̀ nan, gàlʋ̀ tə máŋá wa. Ʋ də yà kʋ́ʋ̀ van lalʋʋ tə, ʋ kə ʋ con. Ʋ mʋ̀ təntə də tɩga, ʋ kwa lɩ̀à tə ga jén duən yáá nə. ");
INSERT INTO nnw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kʋ mʋ̀ nə pɩn, à swɩ̀n á con sɩ́ʋ́n nə, sə á dànà ká tan bara-ba tə də con. Á mʋ̀ dàń yá ba, sə ba vìí. Ba tʋtʋŋɩ təntə nə yɩ ləzwənə yɩra kʋ nan, kʋ wá cʋ̀gʋ̀, kʋ jén lá. ");
INSERT INTO nnw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yá kʋ dàń nə ya kʋ nan Yɩɩ, á wàrɩ̀ kʋ á cʋ̀gà, á pa kʋ jén. Á cɩa á tətə nə, kʋ dàn ká bà, kʋ ya á mʋ̀ də Yɩɩ nə jaŋa». ");
INSERT INTO nnw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yun tɩ̀án tə mama dàń sɛ̀e Gamalɩɛlə pubʋŋa təntə. Ba dàń pìí, ba bon tʋntʋna tə, ba pa, ba mà ba də kafɩran. Ba ga caga ba nii nə də, ba kʋ́ʋ̀ kwárɩ́, ba pìí ba twá də Zwezi yɩrɩ tə, ba ma swɩ̀n yoo. Kʋ kwa nə, ba yá ba, ba pa ba vìí. ");
INSERT INTO nnw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tʋntʋna tə nan Zwifə-ba yun tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə con, ba vìí də pupwən, Yɩɩ nə pɩn, ba na dun, ba nə dí càn Zwezi yɩrɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Yá dɩɩn mama, Zwifə-ba Yɩɩ dìə̀ tə wa, də ba sàń nə, ba tə wà kàrà tə də Zwezi-Kərisə sʋywáŋʋ́ tə sʋgʋ nə yaga. ");
INSERT INTO nnw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kʋ máŋá tə wa, Zwezi karbɩa tə dàń pùlì, ba súrí lá zənzən. Ba yà ba *Zwifə-ba tə, ba nə swɩ̀n *Gərɛkə tə, kadənə tə yoo jələ dɩɩn mama ba nii wodiu tarʋ máŋá wa. Kʋ mʋ̀ nə pɩn, ba də dàń ŋʋŋwɩn ba duən tə, ba nə swɩ̀n *Ebərə tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Zwezi-*Kərisə *tʋntʋna fugə bələ tə dàń ma bon Zwezi karbɩa tə mama, ba kə duən nə, ba ga swɩ̀n ba con, ba wʋ́: «Kʋ wà mɛ, sə nə yá Yɩɩ sʋgʋ tə kàrà nə, nə ga pìí nə pa, wodirən tarʋ nə yà nə yuu zɩlɩ. ");
INSERT INTO nnw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nə nubɩa-ba, kʋ mʋ̀ nə pɩn, á kúrə́ á waa bara barpɛ, ba nə swɩ̀n ba lìù mama yozəŋə. Ba lɩ̀à təntə lìù mama mɛ, sə ʋ ya lìù tə, ʋ nə súə́ də Yɩɩ-*Siŋu tə. Ba lɩ̀à təntə lìù mama mɛ, sə ʋ ya wobʋnyiən, sə nə ma kʋ tʋtʋŋɩ təntə, nə ma zɩn ba. ");
INSERT INTO nnw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nə mʋ̀ mɛ, sə nə wànɩ́ nə tɩnɩ nə máŋá tə, nə kə yɩjʋnɩ wa, də nə kàrɩ̀ Yɩɩ sʋgʋ tə, nə bɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kʋ mʋ̀ yoo təntə dàń yɩn ywánɩ́, kʋ pa lalʋʋ tə mama nə. Ba dàń ma kúrí Etɩyɛnə. Ʋ ya bɛɛ tə, ʋ nə ken ʋ waa Zwezi nə zənzən, ʋ ga sú də Yɩɩ-Siŋu tə. Kʋ súrí Filipə, də Prɔswɔrə, də Nɩkanɔrə, də Timon, də Parəmenasə, də Nikolasə nə. Nikolasə ya Antɩʋswə bɛɛ don, ʋ də nə yà zʋa Zwifə-ba *yɩjʋncwəŋə tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ba ja ba, ba va ba bɩrɩ tʋntʋna tə nə. Tʋntʋna tə də ma jʋn Yɩɩ, ba ga tún ba jɩ̀àn lɩ̀à təntə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ba dàń yà swɩ̀n Yɩɩ sʋgʋ tə, ba súrí lá wuuu. Zwezi karbɩa tə nii dàń pùlì, ba súrí zənzən *Zwerizalɛmə nə. Yá Zwifə-ba Yɩɩ *joŋwana kapʋpʋ də twi, ba kə ba waa Zwezi nə, sə ba zìlí ʋ nii. ");
INSERT INTO nnw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yɩɩ pɩn ʋ dɩ̀àn tə də ʋ pubwanʋ tə Etɩyɛnə nə. Kʋ pɩn ʋ tʋŋa yomɩlan də Yɩɩ dɩ̀àn mɩmɩnan nəfaran lalʋʋ tə tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bara duən zàn, ba zɩgɩ ʋ nə. Lɩ̀à təntə yà yɩ *Zwifə-ba *jə́rə́ dìə̀ tə, ba nə boŋə ‹ywəŋə, ba nə jon ba tɩ̀àn› jə́rə́ dìə̀ tə lɩ̀à. Kʋ mʋ̀ nə yɩ Zwifə-ba lɩ̀à duən, ba nə nan Sirɛnə də Alɛkəzandəri. Ba mʋ̀ də Zwifə-ba, ba nə nan Silisi lʋʋ nii tə wa, də Azi nagwanaa tə wa, dàń tʋ́tʋ̀nɩ́ də Etɩyɛnə. ");
INSERT INTO nnw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Etɩyɛnə yɩ wʋbʋŋa tə, Yɩɩ-*Siŋu tə nə pɩn wá nə, ʋ ma swɩ̀n. Yá kʋ dàń pɩn ba wàrɩ̀ ba le. ");
INSERT INTO nnw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ba dàń ma ga ba vwɩn lɩ̀à, sə ba mʋ̀ lɩ̀à təntə dàń nə swɩ̀n ndə: «Nə mʋ̀ nì də, Etɩyɛnə swɩ̀n sʋlwan, ʋ zɩgɩ *Moyizə də Yɩɩ nə». ");
INSERT INTO nnw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ba dàń twá nətʋ, ba sú lalʋʋ tə, də Zwifə-ba *nəkwɩna tə, də Yɩɩ nii *yənu tɩ̀án tə, ba kə ʋ nə. Ba ma ja Etɩyɛnə, ba ja va yun tɩ̀án tə, ba nə bʋ̀rɩ̀ *bʋ̀rà tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba tanɩ lɩ̀à, ba nə wá kʋnɩ kʋnkʋn, ba kə ʋ nii nə, ba ja vu. Kʋnkʋna təntə dàń nə swɩ̀n, ba wʋ́: «Ʋ mʋ̀ bɛɛ təntə nə swɩ̀n sʋ̀ràn, máŋá mama, ʋ ma zɩga nə Zwifə-ba Yɩɩ *dìə̀ tə də Yɩɩ *nii tə nə, ʋ nə pɩn Moyizə nə. ");
INSERT INTO nnw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nə nì də, ʋ swɩ̀n də, ʋ mʋ̀ *Nazarɛtə Zwezi təntə wá cʋ̀gʋ̀ Yɩɩ dìə̀ tə, ʋ ga lwàń Yɩɩ nii tə, Moyizə nə pɩn nəba tə». ");
INSERT INTO nnw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lɩ̀à tə mama, ba yà nə yɩ yun tɩ̀án tə wa, ba nə bʋ̀rɩ̀ bʋ̀rà, yɩ́á dàń fin Etɩyɛnə yuu wa. Yá ba nɩ də, ʋ yáá tə nyɩn ndə *malɩka yáá nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə bwe Etɩyɛnə nə, ʋ wʋ́: «Mə yìə̀n tə nɛɛ nə nətən cɩ́gá?» ");
INSERT INTO nnw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etɩyɛnə ma le, ʋ wʋ́: «À nubɩa-ba, də à nyɩna-ba, á cʋga nə! Yɩɩ tə, ʋ jə dun, nə nan nə nɩbɛɛ *Abərahamə nə. Kʋ máŋá tə wa, də ʋ wulə Mezopotami nagwanaa wa, ʋ tə wà vəli, sə ʋ jə̀ń Aran nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yɩɩ swɩ̀n ʋ con, ʋ wʋ́: ‹Nan, n ga yá n lʋʋ nii, də n dwíí tɩ̀án, sə n ga va lʋʋ nii tə wa, à nə wá bɩrɩ mʋ́›. ");
INSERT INTO nnw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abərahamə ma nan Kaləde, ʋ va ʋ jə̀ń Aran nə. Ʋ nyɩna tɩan kwa nə, kʋ bwálɩ́ təntə wa, Yɩɩ dàń pɩn ʋ nan Aran, ʋ bà lʋʋ nii kʋ tə nətən wa, á nə wulə kʋ wa zə̀n. ");
INSERT INTO nnw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kʋ máŋá tə wa, Yɩɩ wà wá bwálɩ́ pɩn, sə ʋ tɩnɩ kʋ. Ʋ wà bwálɩ́ tətə pɩn, sə ʋ tún ʋ naa kʋ wa. Kʋ ya Yɩɩ kàn nikana mʋ̀ də, ʋ wá pa kʋ lʋʋ nii təntə Abərahamə də ʋ dwíí tə nə, ʋ nə wá kə lʋʋ wa. Abərahamə yà ga tə ba bìú jə. ");
INSERT INTO nnw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Á nəŋə kʋ tə, Yɩɩ nə swɩ̀n: ‹Abərahamə dwíí tə wá jə̀ń lʋʋ nii don nə. Ba wá jì lʋʋ nii təntə ywəŋə, yá ba wá də́ càn bɩna biənɩa. ");
INSERT INTO nnw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lʋʋ tə, ba nə wá yà kʋ tɩ̀án ywəŋə, à mʋ̀ Yɩɩ nə wá bʋ̀rɩ̀ kʋ bʋ̀rà. Kʋ mʋ̀ təntə kwa nə, ba dàń wá bà, ba fwa yɩjʋnɩ bwálɩ́ kʋ tə wa, à nə dí yáá à kàn kʋ nii də ba›. ");
INSERT INTO nnw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yɩɩ dàń ma kàn nikanɩ də Abərahamə. Kʋ mɩmɩnʋ nə ya bɛɛ *gwəŋə tə. Kʋ mʋ̀ nə pɩn, Abərahamə ma goŋi ʋ bìú *Yɩzakə, ʋ lʋrɩ dɩan nana dɩɩn nə. Yɩzakə də nə lʋrɩ *Zwakɔbə, ʋ də goŋi wá. Zwakɔbə də goŋi ʋ bɩa fugə bələ tə, ba nə yɩ nə nɩbara fugə də bələ tə. ");
INSERT INTO nnw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nə nɩbara-ba tə jɩn wʋgwɩʋ də ba nyánʋ́ Zwʋzɛfə, ba ma yə̀ wá lɩ̀à yuu wa, ba nə vəli *Ezwipətə lʋʋ nii. ");
INSERT INTO nnw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Yɩɩ dàń yɩn də wá. Ʋ lɩ wá ʋ wʋwalʋ mama wa. Yɩɩ pɩn ʋ na pubwanʋ də wʋbʋŋa Ezwipətə pɩ̀ʋ́ *Farawon yáá con. Farawon lɩ Zwʋzɛfə ʋ tún, sə ʋ tɩnɩ Ezwipətə lʋʋ nii, də ʋ dìə̀ tə ʋ ywàń tə yuu. ");
INSERT INTO nnw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Niən dàń twi tə zʋ Ezwipətə lʋʋ nii tə, də Kanan lʋʋ nii tə mama wa. Kʋ yɩn càn zənzən, nə nɩbara-ba tə dàń yà kʋ́ʋ̀ ba won na ba də́. ");
INSERT INTO nnw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Zwakɔbə nə nì də, mɩna wulə Ezwipətə nə, ʋ təntən ʋ tʋn nə nɩbara-ba tə naa nədʋ. ");
INSERT INTO nnw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yá ba nə vəli nɛɛ bələ tə nii nə, Zwʋzɛfə pɩn ʋ nubɩa tə lwarɩ wá, Farawon də dàń lwarɩ Zwʋzɛfə dwíí tɩ̀án tə. ");
INSERT INTO nnw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Zwʋzɛfə dàń ma tʋn ʋ pa, ba ja ʋ nyɩna Zwakɔbə də ʋ dìə̀ lɩ̀à, ba nə yí sapwɩtwa də fugə də bonu, ba bà. ");
INSERT INTO nnw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mə nətʋ nə, Zwakɔbə vəli Ezwipətə. Yá mə lá nə, ʋ tɩga. Nə nɩbara tə də mama tɩga lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba zɩn ba tɩga tə, ba jə va Siswɛmə nə, ba gùrì ləbəri tə wa, Abərahamə yə̀ də səbiu Emɔrə bɩa tə con Siswɛmə nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Yá máŋá tə wa, Yɩɩ nikanɩ tə, ʋ nə kàn də Abərahamə nii nə, bwələ, sə kʋ sú, nə dwíí tə dàń pùlì zənzən Ezwipətə nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kʋ kwa nə, pɩ̀ʋ́ don də kʋ́ʋ̀ jon pàrɩ̀ tə, ʋ nə wà Zwʋzɛfə yəni. ");
INSERT INTO nnw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ʋ mʋ̀ pɩ̀ʋ́ təntə dàń nə tʋn yɩ́á swɩan nə dwíí tə yɩra. Ʋ dàń fɩfɩn nə nɩbara-ba tə, ʋ pa, ba vɩ ba bìsɩ̀nɩ́ ba dʋga, sə kʋ pa ba tɩ. ");
INSERT INTO nnw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kʋ máŋá təntə wa nə, ba lʋrɩ Moyizə. Ʋ yɩ binanʋnʋ Yɩɩ yɩ́á yuu. Ba kʋnɩ wá cànɩ̀ batwa ʋ nyɩna dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Máŋá tə wa, ba nə dʋgʋ wá, Farawon bʋ̀á nɩ wá, ʋ tì ʋ ja va, ʋ kʋnɩ, ndə ʋ tətə bilʋra nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ezwipətə tɩ̀án wʋbʋŋa tə nə, ba ma kwè wá. Moyizə yɩ dɩ̀àn tíú, kʋ twá də ʋ nii sʋgʋ də ʋ tʋtʋnɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ʋ bɩna sapwilə nii nə, ʋ ken sírí, sə ʋ va ʋ nubɩa *Yɩzərayɛlə lɩ̀à tə con. ");
INSERT INTO nnw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ʋ nɩ Ezwipətə tíú don də, ʋ wulə ʋ fɩfɩn ʋ dwíí tə wa lìù don. Yá ʋ dàń gʋa Ezwipətə tíú tə, sə ʋ ma wànɩ́ ʋ jon ʋ nubiu tə, Ezwipətə tíú tə yà nə fɩfɩn. ");
INSERT INTO nnw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ʋ yà bʋŋa də, ʋ nubɩa Yɩzərayɛlə lɩ̀à tə yà wá lwarɩ də, kʋ wá twá də wá, sə Yɩɩ ma jon ba. Yá ba wà kʋ lwarɩ. ");
INSERT INTO nnw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kʋ tɩa nə pʋrɩ, ʋ kʋ́ʋ̀ nɩ Yɩzərayɛlə lɩ̀à tə bələ, ba wulə ba mà duən, ʋ ma kʋ́ʋ̀ pɩ̀à, sə ʋ kwɛ̀e ba. Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: ‹À dabara-ba, á yɩ nubɩa, bɛ̀eɛ̀e nə pɩn, á də ma fɩfɩn duən?› ");
INSERT INTO nnw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Yá ba lìù tə, ʋ nə fɩfɩn ʋ don tə, yugu Moyizə, ʋ ga swɩ̀n, ʋ wʋ́: ‹Wàà nə tún mʋ́, sə n ya pɩ̀ʋ́, sə n bʋ̀rɩ̀ bʋ̀rà nə yuu wa? ");
INSERT INTO nnw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","N pɩ̀à, sə n gʋ à də, ndə n dɩɩn nə gʋa Ezwipətə tíú tə, naaa?› ");
INSERT INTO nnw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kʋ sʋgʋ təntə pɩn Moyizə dəri, ʋ va Madɩan nagwanaa wa. Ʋ lʋrɩ bɩa bələ, kʋ lʋʋ nii təntə wa. ");
INSERT INTO nnw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kʋ bɩna sapwilə nii nə, *malɩka nan ʋ nə, kasɔɔ lanworu tə wa, *Sinayi paan tə yuu, mənvoo kʋ nə jə tuni wa. ");
INSERT INTO nnw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Kʋ yiri tə gwárɩ́ Moyizə. Ʋ dàń ma va, sə ʋ ywàń kʋ ʋ lwarɩ. Ʋ dàń ma nì *Yuu-Tiu kori, kʋ nə wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹À yɩ Yɩɩ tə, n nɩbara-ba tə nə jʋ̀nɩ̀! À yɩ Yɩɩ tə, n nɩbara Abərahamə, də Yɩzakə, də Zwakɔbə, ba nə jʋ̀nɩ̀!› Moyizə dàń vɩvaga, yá ʋ kʋ́ʋ̀ ba wʋdɩʋ jə, sə ʋ ywàń. ");
INSERT INTO nnw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yuu-Tiu dàń ma swɩ̀n ʋ con, ʋ wʋ́: ‹Lɩ n natʋra tə n nɛɛ nə! Bwálɩ́ təntə, n nə zɩga lá, yɩ à mʋ̀ tətə bwálɩ́. ");
INSERT INTO nnw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","À nɩ wʋwalʋ tə à lɩ̀à tə wulə kʋ wa Ezwipətə nə. À nì ba yinəgə kwirə tə. Yá à cuə, sə à jon ba ba càn tə wa. N dàń bàá sɩ́ʋ́n nə, à wá tʋn mʋ́ Ezwipətə nə›.» ");
INSERT INTO nnw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Etɩyɛnə ma kʋ́ʋ̀ swɩ̀n ʋ súrí lá, ʋ wʋ́: «Ʋ mʋ̀ Moyizə təntə, ba yà tɛn, ba ga swɩ̀n, ba wʋ́: ‹Wàà nə tún mʋ́, sə n yà pɩ̀ʋ́ də n bʋ̀rɩ̀ nə bʋ̀rà?› Mə ʋ mʋ̀ nə Yɩɩ tʋn, sə ʋ yà pɩ̀ʋ́, də ʋ lɩ ba ba càn wa. Kʋ twá də malɩka tə, ʋ nɩ tuni tə wa, saŋʋ. ");
INSERT INTO nnw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ʋ mʋ̀ nə lɩ ba Ezwipətə lʋʋ nii tə wa. Kʋ twá də ʋ nə tʋn yomɩlan də Yɩɩ dɩ̀àn mɩmɩnan yìə̀n, Ezwipətə lʋʋ nii tə wa, də ‹mʋʋ nəsɩan› tə wa, də kasɔɔ lanworu tə wa bɩna sapwilə. ");
INSERT INTO nnw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mə ʋ mʋ̀ Moyizə təntə nə swɩ̀n Yɩzərayɛlə lɩ̀à tə con, ʋ wʋ́: ‹Yɩɩ wá lɩ á wa lìù, sə ʋ yà Yɩɩ nii *sʋ̀sʋ̀nʋ̀, ndə à mʋ̀ nə›. ");
INSERT INTO nnw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Máŋá tə nə, Moyizə nə yɩn də Yɩzərayɛlə púlí tə kasɔɔ lanworu tə wa, ʋ nə yɩn də nə nɩbara-ba tə, ʋ ga ya də malɩka tə. Ʋ mʋ̀ con nə malɩka tə swɩ̀n Sinayi paan tə yuu wa, ʋ ga jon Yɩɩ sʋgʋ tə, kʋ nə pɩn mɩɩ ʋ pa nəba. ");
INSERT INTO nnw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nə nɩbara-ba tə yà ba pɩ̀à, sə ba zìlí ʋ nii. Ba vɩga wá, ba pubʋŋa ga pìí, kʋ wulə Ezwipətə lʋʋ nii nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kʋ mʋ̀ nə pɩn, ba swɩ̀n *Arɔn con, ba wʋ́: ‹Fwa yɩa, n pa nəba, sə tə yà nə yáá. Ʋ mʋ̀ Moyizə təntə, ʋ nə pɩn, nə nan Ezwipətə lʋʋ nii tə wa, nə kʋ́ʋ̀ yə̀rì kʋ tə, ʋ nə jigə›. ");
INSERT INTO nnw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kʋ mʋ̀ dɩan təntə wa, ba fwa woŋwanʋ, kʋ nə nyɩn ndə nabiə nə, ba ga gʋ wiən, ba ma fwa *joŋi kʋ mʋ̀ woŋwanʋ təntə yuu wa. Ba dàń ga jwɛ kʋ mʋ̀ won təntə yɩrɩ, ba tətə nə fwa. ");
INSERT INTO nnw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yɩɩ ma vəvəri ʋ kwa, ʋ ma te ba, ʋ ga yá ba, kʋ pa, ba dàń jʋ̀nɩ̀ yɩcaʋ də cànà də kacɩlacɛ tə, lanworu tə wa. Yoo təntə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ twá də Yɩɩ nii sʋ̀sʋ̀nà tə, kʋ wʋ́: ‹Yɩzərayɛlə lɩ̀à-ba, á bɩna sapwilə tə mɛ kasɔɔ lanworu tə wa, á fwa joŋə, də á gwɩ vàná, á pɩn nə, naaa? ");
INSERT INTO nnw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kʋ yɩ á zɩn yɩɩ Molɔkə gansili tə, də á yɩɩ Ronfan kacɩlacɔ tə, á tətə nə fwa. Tə mʋ̀ kʋnkʋn yɩa təntə mama yɩ á tətə nə fwa, sə á bʋ tə nə. Kʋ mʋ̀ nə pɩn, à dàń wá pa, á va á galɩ *Babɩlɔnə lʋʋ nii yuu›. ");
INSERT INTO nnw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kasɔɔ lanworu tə wa, á nɩbara-ba yà jɩn Yɩɩ *wulu gansili tə. Kʋ yɩ kʋ fwa ndə nətʋ tə, Yɩɩ nə swɩ̀n Moyizə con, sə kʋ fwa, ndə Moyizə tətə nə nɩ kʋ yiri tə. ");
INSERT INTO nnw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nə nɩbara tə, ba də nə kʋ́ʋ̀ púə́ ba kwa, də nə kʋ́ʋ̀ jon kʋ mʋ̀ gansili təntə, ba zɩn, máŋá tə wa, Zwozuwe də nə kʋ́ʋ̀ yɩn ba yáá tíú, ba ja bà lʋʋ nii kʋ tə wa. Yɩɩ ma san ʋ ta lʋʋ nii təntə tɩ̀án, ʋ dɩŋɩ ba yáá con. Yɩɩ wulu gansili tə yɩn bwálɩ́ kʋ tə wa, kʋ ja va kʋ yí pɩ̀ʋ́ *Davidə pàrɩ̀ tə máŋá. ");
INSERT INTO nnw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidə nɩ yuywaŋʋ Yɩɩ yáá con, ʋ dàń ma lòrì cwəŋə, sə ʋ lwà bwálɩ́ ʋ kə Zwakɔbə Yɩɩ tə lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yá kʋ yɩ *Salʋmʋn nə lwə̀ dìə̀ təntə. ");
INSERT INTO nnw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yɩɩ tə, ʋ nə wulə ban ban, ga ba dìə̀ tə, ləzwənə nə lwə̀, wa yanɩ. Yɩɩ nii sʋ̀sʋ̀nʋ̀ swɩ̀n də, Yuu-Tiu swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Lanworu tə nə yɩ à padaʋ, yá tɩa tə mʋ̀ yɩ goli, à naa cɩcɩ kə tún bwálɩ́. Bakʋn dìə̀ yiri nə, á wàá á lwè, á pɩn nə? Bwálɩ́ kʋkwa wa nə, à wàá à pəni, à sìí? ");
INSERT INTO nnw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kʋ tà à mʋ̀ nə fwa won mama, naaa?› ");
INSERT INTO nnw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Á mʋ̀, á yɩ lɩ̀à tə, á yɩ vɩʋ lɩ̀à. Á mantɩa á gwəŋə bɛɛ. Yá á waa tə də á zɩan mʋ̀ ba Yɩɩ sʋgʋ tə sɛ̀e, Yɩɩ-*Siŋu tə nə swɩ̀n á con. Á də á nɩbara-ba tə nə yɩ won nədʋ. ");
INSERT INTO nnw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yɩɩ nii sʋ̀sʋ̀nà tə wa, ba wà tətə nə, á nɩbara-ba tə nə wà fɩfɩn? Lɩ̀à tə, ba nə dí yáá ba swɩ̀n cɩ́gá tíú tə túrí tə yoo, á nɩbara-ba tə nə gʋa ba. Yá mə kʋ lìù təntə, á də kʋ́ʋ̀ gɩgɩra á gʋ. ");
INSERT INTO nnw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Á mʋ̀ yɩ lɩ̀à tə, á nə twá də malɩkɛ, á ma na Yɩɩ *nii tə, ʋ nə pɩn Moyizə nə. Yá də kʋ nətʋ mɛ, á wà kʋ nii təntə zìlí». ");
INSERT INTO nnw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Etɩyɛnə nə tún ʋ nii wuuu, ʋ va ʋ zwɛ̀e. Ʋ sʋ̀ràn tə ma pɩn, ba bɩcanɩ sú də lɩŋa ʋ yuu wa. Ba ga vwa ba nipʋrʋ. ");
INSERT INTO nnw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Etɩyɛnə, súə́ də Yɩɩ-*Siŋu tə, ʋ zɩ̀n ʋ yáá ʋ kə lanworu tə wa, ʋ ga na Yɩɩ dun tə, də Zwezi ʋ zàn ʋ zɩga Yɩɩ jɩzən vàn nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ʋ ma swɩ̀n, ʋ wʋ́: «Á cʋga, à na lanworu tə kʋ súrí, yá *Ləzwənə-Biu tə zɩga Yɩɩ jɩzən vàn tə yuu». ");
INSERT INTO nnw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ba mama dàń ma mà cə̀rí zəgə zəgə ba sun ba zɩan, ba ga gàrɩ̀ duən ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ba tùrì wá, ba ja nan tɩʋ tə nii nə. Ba dàń ga wulə ba dɩlɩ wá də kapana, sə ba gʋ. Balandʋrʋ don, ʋ yɩrɩ nə yɩ Solə nə cɩ̀gà lɩ̀à tə, ba nə dɩlɩ Etɩyɛnə, ganan nə. ");
INSERT INTO nnw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Máŋá tə wa, ba nə wulə ba dɩlɩ wá də kapana tə, Etɩyɛnə lòrì Zwezi, ʋ wʋ́: «*Yuu-Tiu Zwezi, jon à siŋu tə n kə n con». ");
INSERT INTO nnw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ʋ ga jə̀ń ʋ nadwana yuu, ʋ bubwi, ʋ wʋ́: «Yuu-Tiu, dàn ká jələ cʋna tə tə, n kə ba yuu wa». Etɩyɛnə nə swɩ̀n tə sʋ̀ràn təntə, ʋ zwɛ̀e kwa nə, ʋ mɩɩ zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Solə də yà bɩrɩ də, Etɩyɛnə mɛ tɩan. Kʋ dɩɩn təntə nə, ba dàń fɩfɩn *Kərisə lɩ̀à púlí tə mama, kʋ nə wulə *Zwerizalɛmə wa. Ba mama dəri ba pwɛ̀e duən yáá nə, ba yá tà Zwezi-*Kərisə *tʋntʋna tə cɩcɩ. Ba dəri ba va Zwide nagwanaa tə də Samari nagwanaa tə mama wa. ");
INSERT INTO nnw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bara-ba nə zìlí Yɩɩ nii zəni tì Etɩyɛnə, ba gùrì, ba ga kwi zənzən ʋ yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Solə mʋ̀ dàń yɩ ʋ kəni dɩ̀àn, sə ʋ cʋ̀gʋ̀ Kərisə lɩ̀à púlí tə. Ʋ twá dii də dii wa ʋ vəli, ʋ ma janɩ bara də kana, ba nə ken ba waa Zwezi nə, ʋ pa ba kəni bàń dìə̀. ");
INSERT INTO nnw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ba tə, ba nə dəri ba pwɛ̀e duən yáá tə, dàń tə swɩ̀n Zwezi-Kərisə sʋywáŋʋ́ tə, bwálɩ́ tə mama, ba nə vəli. ");
INSERT INTO nnw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipə vəli ʋ zʋ Samari nagwanaa tə tɩfarʋ tə wa, ʋ wulə ʋ swɩ̀n Zwezi-*Kərisə sʋywáŋʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lalʋʋ tə mama, kʋ nə kun duən nə, nii yà yɩ nədʋ, kʋ ma cʋga Filipə sʋgʋ tə zəni zəni də waa nədʋ. Lɩ̀à tə yà nə̀ń, ba ga na Yɩɩ dɩ̀àn mɩmɩnan tə, Filipə nə tʋŋa. ");
INSERT INTO nnw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Cɩ́gá, *zinə nan, tə yá lɩ̀à zənzən nə də tə bubwi. Yá gwanan zənzən yayɩran zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kʋ yɩn pupwən nəfarʋ kʋ mʋ̀ tɩfarʋ təntə wa. ");
INSERT INTO nnw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Bɛɛ don yà dí yáá, ʋ wulə kʋ tɩfarʋ tə wa, ʋ yɩrɩ nə yɩ Simon. Ʋ də yà pɩn dun ʋ tɩ̀àn nə, ʋ yà fwa jinəmori, ʋ ma gwárɩ́ Samari lalʋʋ tə zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kʋ yà nə zɩgɩ bisɩmabii nə, kʋ ja va kʋ yɩ bazʋnan nə, ba mama mɩ́ámɩ́án yà twá ʋ nə, də ba swɩ̀n, ba wʋ́: «Ʋ tə mʋ̀ yɩ Yɩɩ dɩ̀àn tə tətə, ba nə boŋə ‹dɩ̀àn nəfarʋ›.» ");
INSERT INTO nnw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ʋ yà gwárɩ́ ba, máŋá kʋ nə darɩ də ʋ jinəmori tʋtʋnɛɛ tə. Kʋ mʋ̀ nə pɩn, ba yà twá ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yá Filipə dàń twi, ʋ swɩ̀n Yɩɩ pàrɩ̀ tə, də Zwezi-Kərisə yɩrɩ tə yoo, ʋ bɩrɩ ba. Kʋ mʋ̀ nə pɩn, bara də kana mama dàń pìí ba yá jinəmori tə, ba kə ba waa Zwezi sʋywáŋʋ́ tə nə, ba ga pa, ba lə ba nɩ́á wa, kʋ twá də Zwezi-Kərisə yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon də tətə ken ʋ waa Zwezi nə. Yá ba ga lə wá nɩ́á tə wa, kʋ twá də Zwezi-Kərisə yɩrɩ tə. Ʋ dàń zɩga Filipə səpuni nə, kʋ ga gwárɩ́ wá zənzən, ʋ nə na Yɩɩ dɩ̀àn mɩmɩnan də dɩ̀àn wiən, tə nə tʋŋa tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Zwezi *tʋntʋna tə, ba yà nə wulə *Zwerizalɛmə wa, dàń nə nì də, Samari tɩ̀án sɛ̀e Yɩɩ sʋgʋ tə, ba dàń tʋn Piyɛrə də Zwan lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ba də nə vəli, ba yí Samari tɩ̀án tə, ba lòrì Yɩɩ ba pa ba, sə Yɩɩ-*Siŋu tə wànɩ́ kʋ cú ba yun wa. ");
INSERT INTO nnw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kʋ yà tə wà ba lìù yuu wa cwi, kʋ ya Filipə ləgə ba nɩ́á wa, *Yuu-Tiu Zwezi yɩrɩ nə cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Piyɛrə də Zwan dàń ma tún ba jɩ̀àn ba yun wa, Yɩɩ-Siŋu tə ga cú ba yun wa. ");
INSERT INTO nnw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Máŋá tə nə, Simon nə nɩ də, Yɩɩ-Siŋu tə ya kʋ twá Zwezi-Kərisə tʋntʋna tə jɩ̀àn ka tún yuu wa, kʋ ma nɩ, ʋ pɩn ba səbiu. ");
INSERT INTO nnw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ʋ ga swɩ̀n, ʋ wʋ́: «Á pɩan dɩ̀àn tə tə à də nə, sə lìù tə mama, à də nə tún à jɩɩn ʋ yuu wa, sə Yɩɩ-Siŋu tə cú kʋ tíú yuu wa». ");
INSERT INTO nnw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piyɛrə dàń vɩga səbiu tə, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Yɩɩ wá cʋ̀gʋ̀ n mʋ̀ də n səbiu tə mɛ, n nə bʋ́n də Yɩɩ tarpɩʋn tə wàá kʋ yə̀ də səbɩa tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","N tori tə̀lə́ yoo kʋ tə wa, kʋ ga tà n yáá con yoo. N pubʋŋa tə ba cɩ́gá nə twá Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vəvəri n kwa, n ma sá n cʋna tə, sə n yá n wʋlʋŋʋ tə, sə n lòrì Yuu-Tiu də, kʋ nə wàá, sə ʋ kwɛn n cʋna tə n mʋ̀ də wá pwərə wa, n pubʋnkʋkwɩʋn kʋ tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","À na də, n waa tə lwara zənzən, n ga yɩ kʋnkʋn yìə̀n yoŋu». ");
INSERT INTO nnw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon ma swɩ̀n, ʋ wʋ́: «Mə á tətə lòrì Yɩɩ á pa nə, sə tə tə mama á nə swɩ̀n tə, nədʋ tətə dàn ká yí nə». ");
INSERT INTO nnw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piyɛrə də Zwan dàń kàrɩ̀ Yuu-Tiu sʋgʋ tə, ba bɩrɩ Samari tɩ̀án nə. Kʋ kwa nə, ba bələ tə pìí ba va Zwerizalɛmə. Ba nə ma vìrí, ba tə swɩ̀n sʋywáŋʋ́ tə ba bɩrɩ Samari tɩbii zənzən wa. ");
INSERT INTO nnw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dɩɩn don nə, *Yuu-Tiu *malɩka twi, kʋ swɩ̀n Filipə con, kʋ wʋ́: «Zàn, n va lʋʋ jɩzən saparʋ yuu, sə n tì kasɔɔ cwəŋə tə, ka nə nan *Zwerizalɛmə nə, ka vəli Gaza». ");
INSERT INTO nnw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipə zàn ʋ vəli, də nə̀ń Etiyopi tɩ̀án batana nə, ʋ nə yɩ ba lʋʋ nii tə kapɩʋ minisə. Kapɩʋ tə yɩrɩ nə yɩ Kandasə. Ʋ mʋ̀ batana təntə yà nə ywàŋá kapɩʋ tə wiən tə mama yuu, tə kwənə nə dáá. Ʋ mʋ̀ bɛɛ təntə yà vəli Zwerizalɛmə, ʋ jʋn Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ʋ dàń jə̀ə́ ʋ səsen tərəko wa, ʋ pìí ʋ ma vìrí, ʋ ga kàrɩ̀ Yɩɩ sagɩ tə wa, Yɩɩ nii *sʋ̀sʋ̀nʋ̀ *Ezayi nə pʋ́pʋ́nɩ́. ");
INSERT INTO nnw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yɩɩ-*Siŋu tə swɩ̀n Filipə con: «Vəli ʋ boli səsen tərəko kʋ tə yɩra». ");
INSERT INTO nnw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipə dəri ʋ boli kʋ yɩra, ʋ nì Etiyopi minisə tə nə kàrɩ̀ Yɩɩ nii sʋ̀sʋ̀nʋ̀ Ezayi pʋ́pʋ́ná tə. Ʋ dàń ma bwe wá, ʋ wʋ́: «N nə̀ń kʋ tə, n nə kàrɩ̀, tə də̀ń?» ");
INSERT INTO nnw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Minisə tə ma le, ʋ wʋ́: «À wá fwa nətə, à ma nì kʋ də̀ń, də lìù nə wà à nə san?» Ʋ ma bon Filipə, ʋ pa, ʋ bà ʋ zʋ səsen tərəko tə wa, ʋ jə̀ə́ ʋ səpuni nə. ");
INSERT INTO nnw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sagɩ tə wa bwálɩ́ tə, minisə tə yà nə kàrɩ̀ tə nə, yɩ kʋ tə: «Ba jɩn wá ndə piə nə, ba ja va nangʋra dìə̀ wa. Ʋ yɩ ndə *pabiə nə ka nii nə ba swɩ̀n, də ba nə swə ba fɩnɩ ka kʋran də. Ʋ wà ʋ nii súrí. ");
INSERT INTO nnw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ʋ dí càn də yinəgə mama. Yá tə mama wa, ba tə wà wá cɩ́gá pɩn. Wàà nə wá man, ʋ bɩrɩ ʋ máŋá lɩ̀à tə, sə ba ma lwarɩ yoo də̀ń? Ba lɩ ʋ mʋ̀ mɩɩ lʋʋ kʋ tə wa». ");
INSERT INTO nnw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Minisə tə dàń tə ma swɩ̀n Filipə con, ʋ wʋ́: «À lòrì mʋ́, Yɩɩ nii sʋ̀sʋ̀nʋ̀ tə yɩ wàà tətə yoo nə ʋ swɩ̀n nətʋ? Kʋ yɩ ʋ tətə, nə à yə̀ə́ kʋ yɩ lìù don yoo?» ");
INSERT INTO nnw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kʋ máŋá təntə wa, Filipə dàń twá kʋ pʋ́pʋ́ná təntə nə, ʋ ma swɩ̀n Zwezi sʋywáŋʋ́ tə, ʋ bɩrɩ minisə tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ba vəli wuuu, ba va ba yí yáá, də nə̀ń, nɩ́á nə. Minisə tə ma swɩ̀n, ʋ wʋ́: «Nə̀ń nɩ́á nə, bɛ̀eɛ̀e dàń nə cɩ̀gà, sə n li nə nɩ́á tə wa kʋ twá də Zwezi-*Kərisə yɩrɩ tə?» ");
INSERT INTO nnw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipə swɩ̀n, ʋ wʋ́: «Də n nə ken n waa mama, kʋ yoo təntə wàá kʋ tʋŋa». Minisə tə ma pìí ʋ le, ʋ wʋ́: «À ken à waa də Zwezi-Kərisə yɩ Yɩɩ-Biu». ");
INSERT INTO nnw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Minisə tə pɩn, ʋ səsen tərəko tə zɩgɩ. Filipə də minisə tə cúə́, ba mʋ̀ bələ tə zʋ nɩ́á tə wa, Filipə ma lə minisə tə nɩ́á tə wa, kʋ twá də Zwezi-Kərisə yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Máŋá tə nə, ba nə pìí ba nan nɩ́á tə wa, Yuu-Tiu Siŋu tə tì Filipə, yá minisə tə kʋ́ʋ̀ ba wá na. Yá ʋ súə́ də pupwən, ʋ ga tì cwəŋə, ʋ vìrí. ");
INSERT INTO nnw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Yɩɩ-Siŋu tə ken Filipə Azɔtə nə. Ʋ zɩgɩ Azɔtə, ʋ twá tɩfaran duən wa, ʋ va ʋ nan Sezare. Ʋ dàń ga swɩ̀n sʋywáŋʋ́ tə tɩan tə mama wa, ʋ nə twá tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Máŋá don wa, Solə mʋ̀ yɩ ʋ tə wulə ʋ fɩfɩn *Yuu-Tiu karbɩa tə, ʋ ga pɩ̀à ba gʋrɩ. Ʋ dàń vəli *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə con. ");
INSERT INTO nnw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ʋ lòrì, sə ʋ pa saga ʋ mʋ̀ Solə nə, ʋ nə wá bɩrɩ Zwifə-ba *jə́rə́ dii tə wa, tə nə wulə Damasə nə. Solə pɩ̀à, sə ba lwarɩ də, ʋ jə cwəŋə, ʋ nə nɩ lɩ̀à, ba nə zʋa Zwezi cwəŋə tə wa, kʋ nə yɩ bara, nə à yə̀ə́ kana, sə ʋ vwa ba, ʋ jə bà *Zwerizalɛmə wa. ");
INSERT INTO nnw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Máŋá tə wa, ʋ nə wulə cwəŋə tə wa, də ʋ dàń yà bwələ Damasə, naa nədʋ, də poni nan yɩɩ nə, kʋ pɩpɩlɩ kʋ kɩkarɩ wá. ");
INSERT INTO nnw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ʋ tʋa tɩa, ʋ ga nì kori, kʋ nə swɩ̀n ʋ con, kʋ wʋ́: «Solə, Solə, bɛ̀eɛ̀e nə pɩn, n ma fɩfɩn nə?» ");
INSERT INTO nnw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ʋ dàń ma le, ʋ wʋ́: «N mʋ̀ nə yɩ wàà, Yuu-Tiu?» Yuu-Tiu dàń ma swɩ̀n, ʋ wʋ́: «À mʋ̀ nə yɩ Zwezi tə, n nə fɩfɩn. ");
INSERT INTO nnw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Zàn yɩɩ nə, sə n va tɩfarʋ tə wa, ba wá bɩrɩ mʋ́ kʋ tə, n nə mɛ, sə n fwa». ");
INSERT INTO nnw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bara tə, ba nə yà kwé wá tə mʋ̀, yɩ ba zɩga cùrù. Ba nì kori tə mʋ̀, yá ba dàń nə wà lìù mama nɩ. ");
INSERT INTO nnw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Solə nyɩ́ ʋ zàn yɩɩ nə, ʋ yɩ́á tə súrí, yá ʋ dàń nə bá won mama na. Ba jɩn ʋ jɩɩn nə, ba ga van wá, ba ja va Damasə. ");
INSERT INTO nnw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ʋ fwa dɩan batwa, də ʋ tə ba lá na. Ʋ ba də́, ʋ ba nywɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kʋ tɩʋ təntə tətə wa, Zwezi karbiu don də yɩn Damasə nə, ʋ yɩrɩ nə yɩ Ananɩasə. Yuu-Tiu bɩrɩ ʋ tɩ̀àn wá, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Ananɩasə!» Ʋ ma sɛ̀e, ʋ wʋ́: «Nə̀ń à nə, Yuu-Tiu!» ");
INSERT INTO nnw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yuu-Tiu dàń ma swɩ̀n ʋ con, ʋ wʋ́: «Zàn, n tì cwəŋə tə, ba nə boŋə ‹cwəmənə mənə› tə, n va Zwidasə sàń nə! Vəli, n pɩ̀à bɛɛ don, ʋ yɩrɩ nə yɩ Solə. Ʋ yɩ Tarəsə tíú. Ʋ wulə ʋ jʋ̀nɩ̀ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","À pɩn, ʋ na bɛɛ don, ʋ yɩrɩ nə yɩ Ananɩasə. Ʋ mʋ̀ bɛɛ təntə twi ʋ zʋ, ʋ ga tún ʋ jɩɩn ʋ yuu wa, sə ʋ yɩ́á tə pìí tə na lá». ");
INSERT INTO nnw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananɩasə ma le, ʋ wʋ́: «Yuu-Tiu, à nì bɛɛ təntə yìə̀n lɩ̀à zənzən nə swɩ̀n də, ʋ fwa lɩ̀à tə yɩra, ba nə yɩ n mʋ̀ nə tɩ, Zwerizalɛmə nə. ");
INSERT INTO nnw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yá Yɩɩ joŋwana yun tɩ̀án tə ken dɩ̀àn ʋ jɩɩn wa yəbə, sə ʋ vwa lɩ̀à tə mama, ba nə yɩ n mʋ̀ Yuu-Tiu nə tɩ». ");
INSERT INTO nnw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yá Yuu-Tiu tə pìí ʋ swɩ̀n, ʋ wʋ́: «Vəli, ʋ mʋ̀ bɛɛ təntə yɩ à kúrú wá à lɩ, sə à ma tʋn. Ʋ wá bɩrɩ à yɩrɩ tə dwíə́ tə mama lʋʋ mama wa, pɛ̀egá yáá con, *Yɩzərayɛlə lɩ̀à tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yá à dàń wá bɩrɩ wá càn yiri tə mama, ʋ nə mɛ, sə ʋ də́ à yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananɩasə dàń ma nan ʋ vìí. Máŋá tə wa nə, ʋ nə vəli ʋ yí, ʋ zʋa dìə̀ tə wa. Ʋ tún ʋ jɩɩn Solə yuu wa, ʋ ga swɩ̀n, ʋ wʋ́: «Solə, à nubiu, Yuu-Tiu Zwezi tə, ʋ nə nan n nə cwəŋə tə wa, də n ma bɩ̀àn tə, ʋ mʋ̀ nə tʋn nə, sə n yɩ́á tə ma wànɩ́ tə pìí tə na lá, sə n sú də Yɩɩ-*Siŋu tə». ");
INSERT INTO nnw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kʋ máŋá tə tətə wa, kʋ fwa ndə wiən pʋran nə nan Solə yɩ́á tə wa, tə tʋ. Ʋ yɩ́á tə dàń ga na lá. Ʋ ma zàn, ʋ pa, ba lə wá nɩ́á wa, kʋ twá də Zwezi-*Kərisə yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kʋ kwa nə, ʋ dí wodiu, yá ʋ dɩ̀àn dàń pìí tə bà. Solə yɩn də Zwezi karbɩa tə, ba yà nə wulə Damasə nə, ndə dɩan bagalɩ nii nə. ");
INSERT INTO nnw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ʋ zàn lala, ʋ swɩ̀n Yɩɩ sʋgʋ tə, *Zwifə-ba *jə́rə́ dii tə wa, ʋ bɩrɩ də, Zwezi yɩ Yɩɩ-Biu. ");
INSERT INTO nnw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lɩ̀à tə mama nə nì Solə sʋ̀ràn tə, kʋ gwárɩ́ ba, ba dàń ga swɩ̀n, ba wʋ́: «Kʋ tà bɛɛ wà tə, yà nə fɩfɩn lɩ̀à tə, ba nə boŋə Zwezi yɩrɩ tə *Zwerizalɛmə wa, naaa? Mə kʋ nə tà ʋ yà twi yəbə, sə ʋ kʋ́ʋ̀ vwa ba duən, ʋ ja va Yɩɩ *joŋwana yun tɩ̀án tə yáá con, naaa?» ");
INSERT INTO nnw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kʋ máŋá təntə wa, Solə dɩ̀àn dàń nə kwɛn tə súrí, wuuu. Ʋ vuvugə Zwifə-ba tə, ba nə wulə Damasə wa, ʋ bɩrɩ də, Zwezi nə yɩ *Kərisə. ");
INSERT INTO nnw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kʋ dàń vəli, kʋ yí máŋá don wa, *Zwifə-ba yun tɩ̀án tə ken nimarʋ, sə ba gʋ Solə. ");
INSERT INTO nnw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Solə dí yáá ʋ gɩgan ʋ lwarɩ ba pubʋŋa təntə. Ba dàń yà cɩ̀ mimiən tə nə, tɩtɩn də yɩcaʋ, ba ma pɩ̀à wá, sə ba lɩ ʋ mɩɩ. ");
INSERT INTO nnw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kʋ nətʋ dàń pɩn, ʋ karbɩa tə ken wá fɩyafarʋ wa, tɩtɩn don nə, ba ga twá bə́rə́, ba cú wá. ");
INSERT INTO nnw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Máŋá tə, ʋ nə pìí ʋ va *Zwerizalɛmə wa, ʋ kɛ̀eń lala, ʋ va ʋ wulə də Zwezi karbɩa tə. Ba də mama dàń yà dəri wá, ba yà ba bʋŋa də, ʋ yɩ Zwezi karbiu tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barənabasə dàń bon wá, ʋ kə ʋ con, ʋ ja wá, ʋ ja va Zwezi-*Kərisə *tʋntʋna tə con. Barənabasə dàń man ʋ bɩrɩ ba kʋ tə, kʋ nə tʋn cwəŋə tə wa, Solə ma na *Yuu-Tiu. Ʋ man Yuu-Tiu nə swɩ̀n Solə con nətʋ, də Solə nə kàrɩ̀ Damasə nə pwənə pwənə də Zwezi yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kʋ kwa nə, Solə də tʋntʋna tə dàń vəli Zwerizalɛmə wa. Yá Solə swɩ̀n Yɩɩ sʋgʋ tə pwənə pwənə də Yuu-Tiu yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Solə swɩ̀n, ʋ ga tʋ́tʋ̀nɩ́ Zwifə-ba tə, ba nə swɩ̀n *Gərɛkə. Ba mʋ̀ təntə mʋ̀ dàń yà pɩ̀à ba lɩ ʋ mɩɩ. ");
INSERT INTO nnw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lɩ̀à tə, ba nə yɩ ʋ nubɩa Kərisə yɩrɩ tə dàń nə lwarɩ kʋ, ba ja wá, ba va Sezare ba pa ʋ va Tarəsə. ");
INSERT INTO nnw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mə kʋ twá nətʋ *Kərisə lɩ̀à púlí tə dàń ma na sìə́ Zwide də Galile də Samari nagwanɛɛ tə mama wa. Ba jɩ̀àn daŋa tə súrí wuuu, ba ga zìlí *Yuu-Tiu nii, yá Yɩɩ-*Siŋu tə də dàń saŋa ba, kʋ pɩn ba pùlì ba súrí wuuu. ");
INSERT INTO nnw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyɛrə yà nan ʋ twá lá, ʋ vəli bwálá tə mama, ʋ ma nɩ lɩ̀à tə, ba nə yɩ Kərisə nə tɩ. Ʋ dàń vəli ba duən con, ba də nə yà wulə Lida nə. ");
INSERT INTO nnw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ʋ nə vəli ʋ yí lá, ʋ nɩ bɛɛ, ʋ yɩrɩ nə yɩ Ene. Ʋ yɩ gwànʋ́, ʋ yí bɩna nana, ʋ nə tə́gə́ gədoo yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyɛrə ma swɩ̀n ʋ con, ʋ wʋ́: «Ene, Zwezi-Kərisə nə zwɛ̀e n yayɩgʋ tə. Zàn yɩɩ nə, sə n kwɛn n gədoo tə». Naa nədʋ də Ene nyɩ́ ʋ zàn. ");
INSERT INTO nnw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lɩ̀à tə mama, ba nə wulə Lida də Saron vara tə wa nɩ wá. Ba ma lwàń ba pubʋŋɩ tə, ba bà Yuu-Tiu con. ");
INSERT INTO nnw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kan don yà wulə Zwezi karbɩa tə wa Zwafa nə. Ʋ yɩrɩ nə yɩ Tabɩta. Kʋ də̀ń nə yɩ ‹sə́gə́›. Ʋ yà tʋŋa tʋtʋnzəŋə zənzən, də ʋ fwa yɩlori wiən də zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ʋ mʋ̀ kan təntə twi, ʋ tʋ yayɩgʋ, ʋ tɩ kʋ máŋá tə wa. Máŋá tə nə, ba nə swɛ wá, ba zwɛ̀e ba ja wá, ba zʋ ba tún dəyuu dìə̀ don wa. ");
INSERT INTO nnw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida də Zwafa yà bwələ də duən. Kʋ mʋ̀ nə pɩn, Zwezi karbɩa tə yà nì də, Piyɛrə wulə Lida nə. Ba dàń ma tʋn bara bələ ʋ con, sə ba lòrì wá, sə ʋ bà ba con lala, ʋ dàn ká dánɩ́. ");
INSERT INTO nnw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyɛrə zàn, ʋ mʋ̀ də bara tə kə duən ba va. Máŋá tə nə, ba nə vəli ba yí lá, ba yɩn ʋ yáá, ba ja zʋ dəyuu dìə̀ tə wa. Kadənə tə mama dàń kɩkarɩ Piyɛrə də ba kwi, ba ga bɩrɩ wá ganvwirən də ganzʋran Tabɩta yà nə fwa, də ʋ nə yɩn də ba. ");
INSERT INTO nnw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyɛrə dàń ma pa lɩ̀à tə mama nan, ʋ ga tòlì ʋ nadwana yuu ʋ jʋn Yɩɩ. Ʋ pìí ʋ vəvəri ʋ yáá, ʋ kə tɩgɩ tə con, ʋ ga swɩ̀n, ʋ wʋ́: «Tabɩta, zàn yɩɩ nə!» Kan tə súrí ʋ yɩ́á, ʋ nə nɩ Piyɛrə, ʋ zàn ʋ jə̀ə́. ");
INSERT INTO nnw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyɛrə ma te ʋ jɩɩn ʋ nə, ʋ ga van wá ʋ zɩ̀n yɩɩ nə. Kʋ kwa nə, ʋ bon lɩ̀à tə, ba nə yɩ Kərisə nə tɩ tə, də kadənə tə, ʋ ga bɩrɩ ba kan tə də ʋ bwin. ");
INSERT INTO nnw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Zwafa tɩ̀án mama yəni kʋ yoo təntə, lɩ̀à zənzən ga kə ba waa Yuu-Tiu nə. ");
INSERT INTO nnw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyɛrə yɩn Zwafa nə, ʋ dánɩ́ lá nə zənzən gɔ̀ɔ́ don con, ʋ nə nɩŋɩ tànàn, ʋ yɩrɩ nə yɩ Simon. ");
INSERT INTO nnw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Bɛɛ don yà wulə Sezare nə, ʋ yɩrɩ nə yɩ Kɔrənɛyə. Ʋ mʋ̀ bɛɛ təntə yà yɩ pamana púlí don wa yuu tíú, ba nə boŋə kʋ pamana púlí təntə Yitalɩyɛnə. ");
INSERT INTO nnw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kɔrənɛyə yɩ bɛɛ tə, ʋ nə twá Yɩɩ cwəŋə tə nə zəni, ʋ ga zìlí Yɩɩ nii, ʋ mʋ̀ də ʋ dìə̀ lɩ̀à mama. Ʋ yà pɩn yɩlori wiən zənzən zʋra tə nə, ʋ ga jʋ̀nɩ̀ Yɩɩ dɩɩn mama. ");
INSERT INTO nnw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dɩɩn don nə, kʋ vəli kʋ yí ndə dədəni nii lugu batwa máŋá wa nə, Yɩɩ pɩn, ʋ na ʋ *malɩka ʋ yɩ́á wa pwənə pwənə, də ka twi, ka zʋ ʋ con. Yá ka ga swɩ̀n ʋ con, ka wʋ́: «Kɔrənɛyə!» ");
INSERT INTO nnw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ʋ fin ʋ yɩ́á, ʋ kə malɩka tə yuu wa, fən də dàń ga zʋ wá. Ʋ ma le, ʋ wʋ́: «Kʋ yɩ nətə, *Yuu-Tiu?» Malɩka tə ma swɩ̀n ʋ con, ka wʋ́: «N yɩjʋnɩ tə də n yɩlori wiən tə mama, n pɩn zʋra tə nə, dɩ̀gà tə yí Yɩɩ con, ndə *joŋi nə, kʋ nə pɩn, ʋ lìí n yoo. ");
INSERT INTO nnw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sɩ́ʋ́n nə, n dàń tʋn Zwafa nə, sə Simon tə, ʋ yɩrɩ don nə yɩ Piyɛrə, bà. ");
INSERT INTO nnw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ʋ yɩ ʋ wulə Simon tə, ʋ nə yɩ gɔ̀ɔ́ ʋ nɩŋɩ tànàn tə, dìə̀. Ʋ dìə̀ tə yɩ kʋ wulə mʋʋ tə nii nə». ");
INSERT INTO nnw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Máŋá tə nə, malɩka tə, ka yà nə swɩ̀n ʋ con tə, vìí, Kɔrənɛyə bon ʋ tʋtʋnbɩa bələ, də ʋ pamana tə wa pamanʋ nədʋ, ʋ də nə twá Yɩɩ cwəŋə tə nə zəni, ʋ ga tʋŋa ʋ pɩn wá. ");
INSERT INTO nnw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kɔrənɛyə ma man won tə mama, kʋ nə tʋn tə nɛɛ ʋ bɩrɩ ba, ʋ ga tʋn ba Zwafa nə. ");
INSERT INTO nnw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kʋ tɩa nə pʋrɩ, ba nan ba zʋ cwəŋə, ba ma vələ Zwafa. Ba vəli wuuu, ba va ba bwələ Zwafa. Kʋ máŋá tə wa, də Piyɛrə dɩ̀gà dəyuu wa, sə ʋ jʋn Yɩɩ. Kʋ yɩn lugu fugə bələ máŋá wa. ");
INSERT INTO nnw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Niən dàń jɩn Piyɛrə, ʋ ga pɩ̀à won, sə ʋ də́. Máŋá tə wa, ba nə wulə ba fwa wodiu, sə ʋ də́, yiviru tì wá. ");
INSERT INTO nnw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yiviru tə máŋá wa, ʋ nɩ lanworu tə də kʋ súrí. Yá ʋ na won don ndə gansara nəfarʋ nə, ba nə vwa kʋ níə́ banɩa tə nə, də kʋ ma cwi tɩa. ");
INSERT INTO nnw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Vàná yiri mama tə nə vəli də nɛɛ banɩa, də vàná yiri tə mama, tə nə vəli tə pùə́ ban tɩa yuu wa, də zə́ŋə́ yiri mama, tə nə pərə yɩɩ nə, yà nə wulə gansara təntə wa. ");
INSERT INTO nnw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Piyɛrə ma nì kori, kʋ nə wʋ́: «Piyɛrə, zàn, n gʋ, n də́!» ");
INSERT INTO nnw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piyɛrə ma le, ʋ wʋ́: «Yuu-Tiu, à ba tə pɩ̀à, sə à də́. À tə wà won mama dí, kʋ nə yɩ culu won, nə à yə̀ə́ pʋpwalan won». ");
INSERT INTO nnw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nɛɛ bələ nii nə, ʋ kʋ́ʋ̀ nì kori tə: «Won tə, Yɩɩ nə bɩrɩ də kʋ mɛ, dàn ká ywàń kʋ ndə culu won nə». ");
INSERT INTO nnw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kʋ fwa nətʋ nɛɛ batwa. Kʋ kwa nə, won tə dàń pìí, kʋ dɩ̀ yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyɛrə yà tə wà won tə, ʋ nə nɩ, tə də̀ń lwarɩ, də nə̀ń, bara tə, Kɔrənɛyə nə tʋn tə nə, ba bwe Simon dìə̀ tə bwálɩ́ nə, ba bà ba zɩga ʋ mimii yáá nə. ");
INSERT INTO nnw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ba ga bòrì ba kə yɩɩ nə, ba bwe, sə ba jə́n, də Simon tə, ʋ yɩrɩ tə don nə yɩ Piyɛrə tə, wulə yəbə tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyɛrə yà yɩ ʋ tə bʋŋa won tə, ʋ nə nɩ tə yoo. Yɩɩ-*Siŋu tə ma swɩ̀n ʋ con, kʋ wʋ́: «Nə̀ń, bara batwa nə, ba bwe n bwiə. ");
INSERT INTO nnw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Zàn n cú, twá ba nə, n vìí. Dàn ká fwa bábɩ̀á, kʋ yɩ à mʋ̀ nə tʋn ba». ");
INSERT INTO nnw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyɛrə ma cú, ʋ swɩ̀n bara tə con, ʋ wʋ́: «Á nəŋə à nə, à mʋ̀ nə yɩ lìù tə á nə pɩ̀à. Bɛ̀eɛ̀e yoo nə ja aba kʋ bà?» ");
INSERT INTO nnw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ba ma pìí, ba le wá, ba wʋ́: «Kʋ yɩ Kɔrənɛyə nə tʋn nəba n con. Ʋ yɩ pamana yuu tíú, ʋ nə yɩ cɩ́gá tíú, ʋ ga zìlí Yɩɩ nii. *Zwifə-ba tə mama nə swɩ̀n ʋ yozəŋə yoo. Yɩɩ malɩka nə cúə́ ka swɩ̀n ʋ mʋ̀ Kɔrənɛyə tə con, sə ʋ pa n bà ʋ dìə̀, sə ʋ ma nì n sʋ̀ràn». ");
INSERT INTO nnw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyɛrə dàń ma pa ba zʋ, ʋ ga pa ba bwálɩ́. Kʋ tɩa tə nə pʋrɩ, Piyɛrə zàn, ʋ mʋ̀ də ba kə duən ba vìí. Lɩ̀à tə duən, ba nə yɩ ʋ nubɩa Kərisə yɩrɩ, ba nə wulə Zwafa nə, nan, ba kwé wá. ");
INSERT INTO nnw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ba viru tɩpʋrɩ nə, ba yí Sezare. Kɔrənɛyə yà bon ʋ dwíí tɩ̀án, də ʋ dabazəŋə, ʋ dàń ga dànɩ̀ ba. ");
INSERT INTO nnw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Máŋá tə nə, Piyɛrə nə twi ʋ zʋ, Kɔrənɛyə zàn, ʋ va ʋ jə́rí wá, ʋ ga tʋa ʋ nɛɛ nə Piyɛrə yáá con, ʋ jʋn wá zəni zəni. ");
INSERT INTO nnw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piyɛrə ma zɩ̀n wá, ʋ ga swɩ̀n ʋ con, ʋ wʋ́: «Zàn yɩɩ nə, à də yɩ ləzwənə!» ");
INSERT INTO nnw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piyɛrə də Kɔrənɛyə swɩ̀n duən nə, ʋ ga lɛ, ʋ zʋ dìə̀ tə wa. Ʋ zʋa ʋ na lɩ̀à, ba nə dáá zənzən də ba jə̀ə́ duən yáá. ");
INSERT INTO nnw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Piyɛrə ma swɩ̀n ba con, ʋ wʋ́: «Á yə̀ə́ də, Zwifə-ba lìù wà mɛ, sə n ja nimarʋ də vee, nə à yə̀ə́, sə n zʋ ʋ dìə̀ wa. Yá Yɩɩ dàń bɩrɩ à mʋ̀, sə à dàn ká ywàń ləzwənə mama, ndə ʋ nə yɩ cʋna lìù, nə à yə̀ə́, ndə pʋpwalan lìù nə, ʋ nə wà mɛ̀e, sə ba yí ʋ yɩra. ");
INSERT INTO nnw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kʋ mʋ̀ nə pɩn, à ma wà tʋ́tʋ̀nɩ́ də yəbə túrí. Á nə bon nə tə, à dàń pɩ̀à, sə à bwe à jə́n, bɛ̀eɛ̀e nə pɩn á ma tʋn, á pa ba bon nə». ");
INSERT INTO nnw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrənɛyə ma le, ʋ wʋ́: «Kʋ yí dɩan banɩa zə̀n kʋ tə, à wulə à jʋ̀nɩ̀ dədəni nii lugu batwa yɩjʋnɩ tə, à dìə̀ wa nə. Də nə̀ń bɛɛ nə, ʋ nə zʋa gànʋ̀, kʋ nə pɩpɩlɩ, ʋ nan à yáá con. Ʋ ga swɩ̀n ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‹Kɔrənɛyə, Yɩɩ jon n yɩjʋnɩ, ʋ ga lìí n yɩlori wiən tə lìə́. ");
INSERT INTO nnw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","N dàń tʋn lìù Zwafa nə, sə ʋ pa Simon tə, ʋ yɩrɩ tə don nə yɩ Piyɛrə tə, bà. Ʋ yɩ ʋ wulə Simon tə, ʋ nə yɩ gɔ̀ɔ́ ʋ nɩŋɩ tànàn tə, dìə̀ mʋʋ tə nii nə›. ");
INSERT INTO nnw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","À də ma tʋn lìù lala, sə ʋ bà ʋ bon mʋ́. N də nə twi tə, n fwa zəni. Sɩ́ʋ́n nə, nə mama dàń wulə Yɩɩ yáá con, sə nə wànɩ́ nə cʋgʋ won tə mama, Yuu-Tiu nə bɩrɩ mʋ́, sə n swɩ̀n nə con». ");
INSERT INTO nnw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piyɛrə dàń ma swɩ̀n, ʋ wʋ́: «Sɩ́ʋ́n nə, cɩ́gá mama à dàń yə̀ə́ də, Yɩɩ ba lìù kúrí, ʋ ma kwanɩ ʋ don. ");
INSERT INTO nnw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Lʋʋ dwíí tə mama wa nə, lìù tə, ʋ nə zìlí Yɩɩ nii, ʋ ga vəli də cɩ́gá, kʋ tíú təntə ziən ʋ mʋ̀ Yɩɩ yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yɩɩ pɩn ʋ sʋgʋ tə *Yɩzərayɛlə lɩ̀à tə nə, ʋ ma dí yáá, ʋ swɩ̀n ʋ bɩrɩ ba də, bɩcan sìə́ wulə Zwezi-*Kərisə con, ʋ nə yɩ lɩ̀à tə mama Yuu-Tiu. ");
INSERT INTO nnw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Zwan dí yáá ʋ kàrɩ̀ ka lə lɩ̀à nɩ́á wa kʋ twá də Yɩɩ yɩrɩ kàrà te. Kʋ kwa nə, á yə̀ə́ won tə, kʋ nə tʋn. Kʋ tə nə dí yáá kʋ tʋn Galile nagwanaa tə wa, də kʋ tə nə tʋn Zwide nagwanaa tə mama wa. ");
INSERT INTO nnw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Á yə̀ə́ nətʋ tə, Yɩɩ nə pɩn ʋ Siŋu tə də ʋ dɩ̀àn tə Zwezi nə, ʋ nə yɩ *Nazarɛtə tíú. Ʋ mʋ̀ yà nə vəli bwálá tə mama, ʋ fwa zəni də ʋ pɩn yazurə lɩ̀à tə mama nə, ba yà nə wulə *Sɩtana wʋwalʋ tə wa. Yɩɩ yà wulə də wá. ");
INSERT INTO nnw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wiən tə mama, ʋ nə tʋn Zwifə-ba lʋʋ nii tə wa də *Zwerizalɛmə wa, nə nɩ tə də nə yɩ́á. Ʋ yɩ ba paa wá dagarʋ tə yuu wa, ba gʋ. ");
INSERT INTO nnw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Yá Yɩɩ dàń pìí ʋ bwin wá, dɩan batwa dɩɩn nə. Yɩɩ pɩn ʋ tə pìí ʋ nan, ʋ bɩrɩ ʋ tɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kʋ kʋ́ʋ̀ tà lalʋʋ tə mama nə, ʋ wá bɩrɩ ʋ tɩ̀àn, kʋ yɩ lɩ̀à tə, Yɩɩ nə ʋ kúrí, sə ba na wá də ba yɩ́á, nə ʋ wá bɩrɩ ʋ tɩ̀àn. Yɩɩ dí yáá ʋ kúrí ba mʋ̀ lɩ̀à təntə. Nə mʋ̀ yɩ lɩ̀à tə, nə nə dí də wá, nə nyʋ də wá, ʋ ka pìí, ka bwin ka nan tɩga wa, kwa nə. ");
INSERT INTO nnw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Zwezi nə pɩn nii nəba, ʋ wʋ́, nə swɩ̀án nə bɩrɩ lɩ̀à tə nə, sə nə pa ba yəni də, kʋ yɩ ʋ mʋ̀ nə Yɩɩ tún, sə ʋ ya lìù tə, ʋ nə bʋ̀rɩ̀ lɩ̀à tə, ba nə wulə mɩɩ wa, də ba tə, ba nə tɩga də mɛ bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yɩɩ nii *sʋ̀sʋ̀nà tə mama swɩ̀n də, lìù tə mama, ʋ nə ken ʋ waa ʋ mʋ̀ Zwezi nə, ʋ wá kwɛn ʋ cʋna tə ʋ mʋ̀ də Yɩɩ pwərə wa, kʋ twá də ʋ yɩrɩ tə nə». ");
INSERT INTO nnw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piyɛrə nə wulə ʋ swɩ̀n tə sʋ̀ràn təntə, Yɩɩ-Siŋu tə cuə lɩ̀à tə mama, ba nə cʋga sʋgʋ tə, yun wa. ");
INSERT INTO nnw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kʋ gwárɩ́ Kərisə lɩ̀à tə, ba nə kwé Piyɛrə, ba ja bà, ba nə yɩ Zwifə-ba. Kʋ gwárɩ́ ba, də Yɩɩ tarpɩʋn tə, kʋ nə yɩ Yɩɩ-Siŋu tə cuə lɩ̀à tə, ba nə tà Zwifə-ba tə, də yun wa. ");
INSERT INTO nnw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ba dàń yà nə̀ń, ba nə swɩ̀n də sʋyirə duən, də ba ga bwɩ Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Piyɛrə dàń ma swɩ̀n, ʋ wʋ́: «Nə wàá nə vɩ, sə nə lə lɩ̀à tə, ba də nə nɩ Yɩɩ-Siŋu tə, ndə nə tətə nə, nɩ́á wa, naaa?» ");
INSERT INTO nnw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Piyɛrə ma pa nii, sə ba lə ba nɩ́á wa də Zwezi-Kərisə yɩrɩ tə. Kʋ mʋ̀ təntə yuu wa, ba lòrì wá, sə ʋ ya ba nii nə, ndə dɩan bagalɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kʋ máŋá tə wa, Zwezi-*Kərisə *tʋntʋna tə, də lɩ̀à tə duən, ba nə yɩ nubɩa Kərisə yɩrɩ, ba nə wulə Zwide nagwanaa tə wa, twi ba nì də, lɩ̀à tə, ba nə tà *Zwifə-ba tətə, də sɛ̀e Yɩɩ sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Máŋá tə wa, Piyɛrə nə pìí ʋ bà *Zwerizalɛmə wa, Kərisə lɩ̀à tə, ba nə yɩ Zwifə-ba tə, zàn ba wulə ba caga ʋ nii nə, ba swɩ̀n, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«N zʋa lɩ̀à tə, ba nə ba bɛɛ *goŋi, con. Yá n mʋ̀ də ba dí də duən də». ");
INSERT INTO nnw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Piyɛrə dàń tì yoo tə nɛɛ mama, ʋ twarɩ kʋ zɩgɩ nətʋ, kʋ ma tʋn, də kʋ yígúrə́, ʋ bɩrɩ ba nətən: ");
INSERT INTO nnw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«À yà wulə Zwafa wa, à jʋ̀nɩ̀ Yɩɩ, də naa nədʋ yiviru tì nə, Yɩɩ ga pa à na won yɩjʋnɩ tə wa: À nɩ won don ndə gansara nəfarʋ nə, ba nə vwə kʋ níə́ banɩa tə nə, də kʋ naŋa lanworu tə wa, kʋ cwi tɩa. Won tə twi, kʋ bà kʋ yí à nii. ");
INSERT INTO nnw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","À dàń ma ywàń kʋ zən, à ga na tɩa yuu vàná yiri mama, tə nə vəli də nɛɛ banɩa, də ganaŋa də wiən tə, tə nə vəli tə pùə́ ban, də lanworu zə́ŋə́ tə, də tə wulə won tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","À ga nì kori, kʋ swɩ̀n à con, kʋ wʋ́: ‹Piyɛrə, zàn, n gʋ, n də́!› ");
INSERT INTO nnw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","À ma swɩ̀n, à wʋ́: ‹*Yuu-Tiu, à ba tə pɩ̀à, sə à də́. À tə wà won mama dí, kʋ nə yɩ culu won, nə à yə̀ə́ pʋpwalan won!› ");
INSERT INTO nnw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nɛɛ bələ nii nə, kori tə kʋ́ʋ̀ bwe, kʋ zɩgɩ lanworu tə wa, kʋ swɩ̀n: ‹Won tə, Yɩɩ nə bɩrɩ də kʋ mɛ, dàn ká ywàń kʋ ndə culu won nə!› ");
INSERT INTO nnw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kʋ fwa nətʋ nɛɛ batwa. Kʋ kwa nə, tə mama pìí tə dɩ̀ lanworu tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lala də nə̀ń, bara batwa nə, ba tʋn ba, ba nan Sezare, ba bà ba yí dìə̀ tə wa, nə nə wulə. ");
INSERT INTO nnw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yɩɩ-*Siŋu tə swɩ̀n à con, sə à twá də ba à vìí, à dàn ká fwa bábɩ̀á. Lɩ̀à bardʋ kʋ tə, ba nə yɩ nə nubɩa Kərisə yɩrɩ, nə kwé nə, nə ma va nə zʋ Kɔrənɛyə dìə̀. ");
INSERT INTO nnw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ʋ mʋ̀ Kɔrənɛyə tə dàń nə man, ʋ bɩrɩ nəba nətʋ tə, ʋ nə nɩ *malɩka tə ʋ dìə̀ tə wa, də ka nə nan ʋ nə, ka ga swɩ̀n, ka wʋ́: ‹Tʋn lɩ̀à, sə ba va Zwafa nə, ba pɩ̀à Simon tə, ʋ yɩrɩ don nə yɩ Piyɛrə, ba ja bà. ");
INSERT INTO nnw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ʋ mʋ̀ nə wá swɩ̀n sʋ̀ràn n con, n mʋ̀ də n dìə̀ tə mama nə wá twá tə nə, sə Yɩɩ jon aba á cʋna wa›. ");
INSERT INTO nnw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Máŋá tə, à nə wulə à swɩ̀n, Yɩɩ-Siŋu tə cuə ba yun wa, ndə kʋ nə fwa nətʋ tə, kʋ təntən dɩɩn tə nə, nə də yun wa. ");
INSERT INTO nnw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","À dàń ma lìí Yuu-Tiu sʋgʋ kʋ tə yoo, kʋ nə wʋ́: ‹Zwan yɩ nɩ́á wa nə, ʋ ləgə lɩ̀à duən. Yá á mʋ̀ ya Yɩɩ-Siŋu tə wa nə, ba wá lə aba›. ");
INSERT INTO nnw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nə mʋ̀ lɩ̀à tə nə, nə ken nə waa Yuu-Tiu Zwezi-Kərisə nə, mə kʋ pɩrɩ təntə ʋ pɩn nəba. Mə Yɩɩ dàń nə pɩn ba kʋ mʋ̀ pɩrɩ təntə. À mʋ̀ dàń nə kʋ́ʋ̀ yɩ wàà, à ma zɩga Yɩɩ yoo nə?» ");
INSERT INTO nnw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ba nə nì tə sʋ̀ràn təntə kwa nə, ba yá kʋ sʋgʋ tə nə, ba ga bwɩ Yɩɩ nə, ba wʋ́: «Yɩɩ tətə dàń nə pɩn cwəŋə lɩ̀à tə nə, ba nə tà Zwifə-ba tə, sə ba vəvəri ba kwa, ba ma sá ba cʋna, sə ba ga na mɩɩ tə, kʋ nə ba zwɛ̀e ʋ con». ");
INSERT INTO nnw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lɩ̀à tə yà pwɛ̀e duən yáá nə, wʋwalʋ tə yɩrɩ, kʋ nə twi kʋ tə Etɩyɛnə nə swɩ̀n tə yɩrɩ. Ba duən vəli Fenisi nagwanaa, də Swipərə nagwanaa, də Antɩʋswə. Ba ga ba Yɩɩ sʋgʋ tə swɩ̀n lìù don, də kʋ nə tà *Zwifə-ba con. ");
INSERT INTO nnw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bara duən də yɩn ba wa, ba nə yɩ Swipərə, də Sirɛnə tɩ̀án ba nə twi Antɩʋswə. Ba də nə swɩ̀n *Gərɛkə-ba tə con, ba ga swɩ̀n *Yuu-Tiu Zwezi sʋywáŋʋ́ tə, ba bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yuu-Tiu dɩ̀àn tə yɩn də ba, yá lɩ̀à zənzən ken ba waa Zwezi nə, ba ga lwàń ba pubʋŋa, ba bà Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","*Kərisə lɩ̀à púlí tə, kʋ nə wulə *Zwerizalɛmə wa, lɩ̀à twi, ba nì kʋ mʋ̀ yoo təntə. Ba dàń ma tʋn Barənabasə, sə ʋ va Antɩʋswə. ");
INSERT INTO nnw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Máŋá tə nə, ʋ nə yí lá ʋ ga na pubwanʋ tə, Yɩɩ nə pɩn ba, ʋ jwɛ, ʋ ga kwè ba mama, sə ba zɩgɩ ba waa nədʋ tə yuu wa, ba ga vwa ba tɩ̀àn Yuu-Tiu yɩra. ");
INSERT INTO nnw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barənabasə yɩ wʋywanyiən, ʋ nə súə́ də Yɩɩ-*Siŋu tə. Ʋ yà ken ʋ waa Zwezi nə wuuu. Lalʋʋ nə pɩn ba tɩ̀àn Yuu-Tiu nə, ba súrí ba duən tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kʋ kwa nə, Barənabasə nan lá nə, ʋ va Tarəsə, sə ʋ pɩ̀à Solə. ");
INSERT INTO nnw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Máŋá tə, ʋ nə nɩ wá, ʋ ja wá, ʋ va Antɩʋswə. Barənabasə də Solə fwa bɩnɩ pɩ́rɩ́ də Kərisə lɩ̀à púlí tə, ba ga kàrɩ̀ lalʋʋ, kʋ nə dáá zənzən. Mə kʋ zɩgɩ máŋá təntə wa Antɩʋswə nə, ba ma kə Zwezi karbɩa tə yɩrɩ Kərisə lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kʋ dɩan təntə nii nə, Yɩɩ nii *sʋ̀sʋ̀nà nan Zwerizalɛmə, ba bà Antɩʋswə. ");
INSERT INTO nnw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ba wa lìù don, ʋ yɩrɩ nə yɩ Agabisə, nyɩ́ ʋ zàn, ʋ twá də Yɩɩ-Siŋu tə, ʋ ma swɩ̀n də, niən nəfarʋ wá bà tɩa yuu wa bwálɩ́ mama nə. *Kəlodə máŋá tə wa, kʋ niən tə cɩ́gá twi. ");
INSERT INTO nnw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Zwezi karbɩa tə vʋrɩ duən nə, sə ba tʋn saŋʋ ndə nətʋ tə, ba lìù mama nə wàá, sə kʋ va kʋ pa lɩ̀à tə nə, ba nə yɩ ba nubɩa Kərisə yɩrɩ, ba nə wulə Zwide nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ba cɩ́gá fwa kʋ yoo təntə: Ba ken kʋ saŋʋ təntə Barənabasə də Solə jɩ̀àn wa, sə ba ja kʋ, ba va ba pa Kərisə lɩ̀à púlí yáá tɩ̀án tə nə, Zwerizalɛmə nə. ");
INSERT INTO nnw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kʋ máŋá təntə wa, pɩ̀ʋ́ *Erodə dàń zàn, ʋ fɩfɩn *Kərisə lɩ̀à púlí tə wa lɩ̀à duən. ");
INSERT INTO nnw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ʋ pɩn, ba gʋ Zwan zʋnʋ Zwakə də lagʋrɩ sɩ̀ʋ́. ");
INSERT INTO nnw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ʋ nə nɩ də, kʋ yoo təntə ywán kʋ pa *Zwifə-ba yun tɩ̀án, ʋ kʋ́ʋ̀ pɩn nii, sə ba ja Piyɛrə. Kʋ yɩn cànà tə, ba nə də́ də dipɛn tə, kʋ nə ba sabwarɩ kəni, tə máŋá wa. ");
INSERT INTO nnw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ba nə jɩn Piyɛrə ba zwɛ̀e kwa nə, Erodə pɩn, ba kə wá bàń dìə̀, ʋ ga tún pamana púlə́ banɩa, kʋ nədʋ mama nə ja lɩ̀à banɩa, sə ba cɩ̀ ʋ nə. Ʋ pubʋŋa dàń yà nə yɩ, sə ʋ ja wá ʋ va lalʋʋ tə yáá con, *Pakə cànà tə kwa nə. ");
INSERT INTO nnw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piyɛrə dàń yà yɩ ba cɩ̀gà ʋ nə bàń dìə̀ tə wa. Yá Kərisə lɩ̀à púlí tə dàń yà wulə ba lòrì Yɩɩ ba pɩn wá wuuu. ");
INSERT INTO nnw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Dɩɩn tə tɩa nə wá pʋrɩ, sə Erodə pa, ba bʋ̀rɩ̀ ʋ bʋ̀rà, Piyɛrə dwɛ̀e pamana bələ tətəŋi wa, kʋ tɩtɩn tə nə. Ʋ yà yɩ ba vwə wá də banzala bələ, yá ba duən də ga cɩ̀ bàń dìə̀ tə mimii tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Naa nədʋ, də *Yuu-Tiu *malɩka twi, yá poni ga pɩpɩlɩ kʋ pɩ̀rɩ̀ bàń dìə̀ tə wa. Ka pɩpaga Piyɛrə ka zɩ̀n, ka ga swɩ̀n ʋ con, ka wʋ́: «Zàn yɩɩ nə, lala!» Kʋ máŋá tə wa, banzala tə nan ʋ jɩ̀àn nə, tə tʋ. ");
INSERT INTO nnw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malɩka tə swɩ̀n ʋ con, ka wʋ́: «Vwa n tàŋá voru tə lá, sə n ga kə n natʋra». Piyɛrə fwa kʋ nətʋ tə ʋ zwɛ̀e, malɩka tə kʋ́ʋ̀ swɩ̀n ʋ con, ka wʋ́: «Zʋ n gandarʋ tə, sə n ga pú à kwa». ");
INSERT INTO nnw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ba nə nan kàrá wa ba zwɛ̀e, Piyɛrə púə́ kʋ kwa. Yá ʋ yà yə̀rì cɩ́gá mama də kʋ yɩ malɩka nə twi ʋ con. Ʋ yà bʋŋa də, kʋ yɩ Yɩɩ nə pɩn, ʋ na won ʋ pandwɩa wa. ");
INSERT INTO nnw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba vəli, ba lɛ təntən bwálɩ́ tə, ba nə cɩ̀gà kʋ nə, ba tə va ba lɛ kʋ bələ nii nyiən tə, də ba va ba yí lugu mimii tə yáá, kʋ nə naŋa tɩfarʋ tə wa. Kʋ lugu boru təntə də súrí kʋ tɩ̀àn nə, kʋ pa ba. Ba nan, ba va ba jɩrɩ cwəŋə yuu. Naa nədʋ də malɩka tə jén. ");
INSERT INTO nnw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Piyɛrə waa dàń pìí ka bà, ʋ ga swɩ̀n, ʋ wʋ́: «Sɩ́ʋ́n nə, à dàń lwarɩ cɩ́gá də, Yuu-Tiu nə tʋn ʋ malɩka à con, ka ga van nə, ka lɩ Erodə də won tə mama, Zwifə-ba lʋʋ lɩ̀à yà nə dànɩ̀, tə jɩɩn wa». ");
INSERT INTO nnw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ʋ nə bʋ́n kʋ nətʋ, ʋ zwɛ̀e ʋ vəli Mari dìə̀. Mari yɩ Zwan tə, ʋ yɩrɩ don nə yɩ Marəkə, nuu. Lɩ̀à-ba nə dáá yà kun duən nə kʋ dìə̀ təntə wa, ba jʋ̀nɩ̀ Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyɛrə ma kʋkwaga boru tə nə. Tʋtʋnkana don, ʋ yɩrɩ nə ya Rodə, twi ʋ boli mimii tə nii, sə ʋ cʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ʋ lwarɩ Piyɛrə kosʋgʋ tə. Pupoli cɩcɩ súə́ wa, kʋ pa ʋ wà mimii tə súrí. Ʋ dəri, ʋ va dìə̀ tə tətəŋi wa, ʋ swɩ̀n ʋ bɩrɩ də, Piyɛrə wulə mimii tə yáá kàrá wa. ");
INSERT INTO nnw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ba duən tə swɩ̀n ʋ con, ba wʋ́: «N yɩ n nyaŋa». Yá ʋ dàń tə swɩ̀n, də kʋ ya cɩ́gá mama. Ba dàń ma wʋ́: «Kʋ ya ʋ malɩka nə». ");
INSERT INTO nnw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piyɛrə də con nə, ʋ də tə wà boru tə kʋkwagʋ nə yá. Máŋá tə, ba nə súrí boru tə, ba nɩ wá, kʋ ga gən ba. ");
INSERT INTO nnw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ʋ dàń ma ja ʋ jɩɩn, ʋ ma fwa mɩmɩnʋ, sə ba yá zəzugu tə nə, ʋ ga tún, kʋ nə zɩgɩ nətʋ, Yuu-Tiu ma lɩ wá bàń dìə̀ tə wa. Ʋ dàń swɩ̀n ba con, ʋ wʋ́: «Á pɩan Zwakə, də ba duən tə, ba nə yɩ nə nubɩa Kərisə yɩrɩ, tə yəni kʋ». Ʋ ga nan, ʋ va bwálɩ́ don nə. ");
INSERT INTO nnw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kʋ tɩa tə nə pʋrɩ, dwanɩ nəfarʋ dwan pamana tə tətəŋi wa, ba ga bwe duən, ba wʋ́, Piyɛrə yɩ ʋ fwa nətə. ");
INSERT INTO nnw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erodə pɩn ba pɩ̀à wá, yá ba wà wá nɩ. Ʋ dàń ma pa, ba bwe lɩ̀à tə, ba nə cɩ̀gà ʋ nə tə, ʋ ga pa nii də, sə ba gʋ. Kʋ kwa nə, *Erodə nan Zwide nagwanaa tə wa, ʋ va Sezare. ");
INSERT INTO nnw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ʋ lɩŋa dàń yà zaŋa Tirə, də Sidon tɩ̀án yuu wa zənzən. Kʋ tɩan təntə tɩ̀án də ken nimarʋ, sə ba ma wànɩ́ ba bà ba yí wá. Ba dí yáá ba də́ dabarɩ də Bəlasətisə ʋ nə ya pɩ̀ʋ́ Erodə dìə̀ tə yáá tíú. Kʋ kwa nə, ba vəli ba lòrì, sə sìə́ ya ba pwərə wa, ba nagwanaa tə nii wodiu yà nə yɩ kʋ naŋa pɩ̀ʋ́ Erodə nagwanaa tə wa yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kʋ dɩɩn tə nə yí, Erodə tì ʋ paganʋ ʋ zʋ, ʋ ga nan ʋ jə̀ə́ ʋ padaʋ yuu. Ʋ dàń ga swɩ̀n sʋ̀ràn ba con pwənə pwənə. ");
INSERT INTO nnw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Lalʋʋ tə cə̀rí, ba wʋ́: «Kʋ yɩ yɩɩ don nə swɩ̀n, kʋ tà ləzwənə nə swɩ̀n». ");
INSERT INTO nnw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kʋ máŋá təntə tətə wa, *Yuu-Tiu *malɩka mà Erodə ʋ nə wà dun pɩn ʋ mʋ̀ Yɩɩ nə tə yɩrɩ. Kʋ pɩn zʋnzʋran zɩgɩ ʋ waa tə də́ wá, tə nan poni nə, ʋ ga tɩ. ");
INSERT INTO nnw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yá Yɩɩ sʋgʋ tə dàń yɩ kʋ zwɩ kʋ súrí, wuuu. ");
INSERT INTO nnw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barənabasə də Solə tʋtʋŋɩ tə nə zwɛ̀e *Zwerizalɛmə nə, ba jɩn Zwan, ʋ yɩrɩ don nə yɩ Marəkə, ba súrí ba tɩ̀àn nə, ba ja pìí ba bà. ");
INSERT INTO nnw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Yɩɩ nii *sʋ̀sʋ̀nà də karnyɩna-ba də yà wulə *Kərisə lɩ̀à púlí tə wa, kʋ nə wulə Antɩʋswə nə. Kʋ mʋ̀ nə yɩ Barənabasə də Simeyon, ba nə boŋə ‹nəzonu›, də Lisiyisə Sirɛnə tíú tə, də Manayɩn pɩ̀ʋ́ *Erodə bìsɩ̀nɩ́ dabɛɛ tə, də Solə. ");
INSERT INTO nnw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Dɩɩn don nə, ba nə kun duən nə, ba bwɩ *Yuu-Tiu nə, də ba fwa nivori, Yɩɩ-*Siŋu tə dàń swɩ̀n, kʋ wʋ́: «Á kənə Barənabasə də Solə vàn nə tʋtʋŋɩ tə yɩrɩ, à nə pɩn ba». ");
INSERT INTO nnw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ba dàń nə vwə nii, ba ga jʋn Yɩɩ, ba zwɛ̀e kwa nə, ba tún ba jɩ̀àn ba mʋ̀ lɩ̀à bələ təntə yuu wa. Yá ba ga kə ba cwəŋə wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ba mʋ̀ təntə Yɩɩ-Siŋu tə nə tʋn, ba vəli Seləsi, ba zʋ nɩ́á yuu bori, ba va Swipərə nagwanaa. ");
INSERT INTO nnw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ba nə vəli ba yí Salaminə, ba zɩgɩ lá, ba swɩ̀n Yɩɩ sʋgʋ tə *Zwifə-ba *jə́rə́ dii tə wa. Ba jɩn Zwan ba kə ba con, sə ʋ san ba. ");
INSERT INTO nnw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Máŋá tə, ba nə vəli ba jijiri lʋʋ nii təntə wa, ba vəli ba yí Pafɔsə. Ba nɩ jinəmori don, kʋnkʋn nii sʋ̀sʋ̀nʋ̀. Ʋ yɩ Zwifə, ʋ yɩrɩ ga yɩ Barə-Zwezi, ʋ yɩrɩ tə don də *Gərɛkə-ba sʋgʋ nə yɩ Elimasə. Bɛɛ təntə yà wulə də yáá tíú tə, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún. Ʋ yɩrɩ nə yɩ Sɛrəgisə Polisə. Ʋ yɩ yənu tíú. Ʋ mʋ̀ yáá tíú təntə dàń pɩn ba bon Barənabasə də Solə, ʋ ga bɩrɩ də, ʋ swə, sə ʋ nì Yɩɩ sʋgʋ tə. Jinəmori tə dàń zàn ʋ zɩgɩ ba nə, ʋ pɩ̀à, sə ʋ vəvəri yáá tíú tə, sə ʋ dàn ká kə ʋ waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Solə, ʋ yɩrɩ don nə yɩ Polə, ʋ nə súə́ də Yɩɩ-Siŋu tə dàń ma fin ʋ yɩ́á, ʋ kə jinəmori tə yuu wa, ʋ ga swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«N mʋ̀ bɛɛ təntə, n yɩ n súə́ də yɩ́á swɩan yiri mama də wʋlʋŋʋ. N mʋ̀ *Sɩtana bìú! N yɩ cɩ́gá yiri mama dʋŋʋ! Cɩ̀ n tɩ̀àn nə, də Yɩɩ cɩ́gá cwəŋə tə ka cʋ̀gʋ̀. ");
INSERT INTO nnw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sɩ́ʋ́n nə, nə̀ń Yuu-Tiu jɩɩn wulə n yuu wa. N wá jì liliu, yá máŋá don wa nə, n bá na yɩcaʋ tə». Lala, də yikunu púə́ ʋ yuu nə, ʋ dàń ga twá lá, ʋ tɩtɛ ʋ pɩ̀à lɩ̀à, sə ba van wá, ba kə cwəŋə nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Haya, yáá tíú tə nə nɩ kʋ tə, kʋ nə tʋn, Yɩɩ sʋgʋ tə zʋa wa, ʋ ga kə ʋ waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polə də ʋ twaduən tə tì nɩ́á yuu bori Pafɔsə nə, ba va Pɛrəgə, Panfili nagwanaa wa. Yá Zwan mʋ̀ pìí ʋ yá ba Panfili nə, ʋ va *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ba kʋ́ʋ̀ zɩgɩ Pɛrəgə nə, ba va ba yí Antɩʋswə don Pisidi nagwanaa wa. Ba zʋa *Zwifə-ba *jə́rə́ dìə̀ tə wa ba *sìə́ dɩɩn nə, ba jə̀ə́ lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Máŋá tə, ba nə kàrɩ̀ Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə saga tə, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə, ba zwɛ̀e, kʋ kwa nə, jə́rə́ dìə̀ yáá tɩ̀án tə tʋn, sə ba swɩ̀n ba con ndə: «Nə nubibara-ba, də á nə jə kwìə̀, á nə pɩ̀à, sə á ma kwè lɩ̀à tə, á swɩ̀án». ");
INSERT INTO nnw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Polə nyɩ́ ʋ zàn ʋ ja jɩɩn, ʋ ma fwa ba mɩmɩnʋ, ʋ ga swɩ̀n, ʋ wʋ́: «*Yɩzərayɛlə lɩ̀à-ba, də á mʋ̀ lɩ̀à tə, á nə sɛ̀e á zʋ Zwifə-ba *yɩjʋncwəŋə tə wa, á cʋga: ");
INSERT INTO nnw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yɩɩ tə, ʋ nə yɩ nə mʋ̀ Yɩzərayɛlə lɩ̀à Yɩɩ, nə kúrí nə nɩbara-ba tə. Ʋ mʋ̀ nə pɩn, kʋ lɩ̀à təntə pùlì zənzən, máŋá tə wa, ba nə yɩn vərə *Ezwipətə lʋʋ nii tə wa. Yá kʋ twá ʋ vàn tə dɩ̀àn tə nə, ʋ ma pa ba nan lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kʋ dánɩ́ kʋ yí ndə bɩna sapwilə nə, Yɩɩ kálɩ́ ʋ tɩ̀àn, ʋ ma ywàń ba yuu kasɔɔ lanworu tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Yɩɩ cʋ̀gʋ̀ dwíə́ barpɛ Kanan lʋʋ nii tə wa, yá kʋ kwa nə, ʋ pɩn ba mʋ̀ nə tɩnɩ ba lʋʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kʋ nətʋ tə yí ndə bɩna biənɩa də finu (450) nə. Kʋ kwa nə, ʋ pɩn ba yáá tɩ̀án, kʋ ja va kʋ yí Yɩɩ nii sʋ̀sʋ̀nʋ̀ Samɩyɛlə. ");
INSERT INTO nnw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kʋ mʋ̀ təntə kwa nə, ba lòrì pɩ̀ʋ́. Yɩɩ ma pa ba Sayilə, ʋ nə yɩ Kisə bìú Bɛnzwamɛn dwíí dəkuu tə wa. Ʋ də fwa bɩna sapwilə. ");
INSERT INTO nnw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kʋ kwa nə, Yɩɩ vɩga wá, ʋ ga tún *Davidə pàrɩ̀ tə yuu wa. Yɩɩ swɩ̀n Davidə yoo, ʋ wʋ́: ‹À nɩ Yɩzayi bìú Davidə, də ʋ yɩ bɛɛ tə, ʋ nə súə́ à yii, ʋ nə wá tʋn à fɩra wiən tə mama tə sú›. ");
INSERT INTO nnw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mə ʋ mʋ̀ dwíí tə wa nə, Yɩɩ pɩn Zwezi bà, ndə ʋ nə kàn nii nətʋ. Ʋ mʋ̀ Zwezi təntə nə wá jon Yɩzərayɛlə lɩ̀à ba cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Máŋá tə Zwezi tətə nə wà twi, Zwan kàrɩ̀ ʋ bɩrɩ Yɩzərayɛlə lɩ̀à tə mama nə, sə ba vəvəri ba kwa ba ma sá ba cʋna, sə ʋ lə ba nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Zwan mɩɩ nə bwələ, sə kʋ zwɛ̀e, ʋ swɩ̀n, ʋ wʋ́: ‹À mʋ̀ nə tà kʋ tə, á nə bʋŋa də, à yɩ. Á nəŋə, à mʋ̀ kwa nə lìù don wá bà. À jɩɩn mùrì, sə à kʋ̀rɩ̀ ʋ natʋra tətə›. ");
INSERT INTO nnw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","À nubɩa-ba, *Abərahamə dwíí wa nɩ̀án-ba, də á mʋ̀ təntə, á nə zìlí Yɩɩ! Kʋ yɩ nə mʋ̀ con nə, nə Yɩɩ tʋn ʋ sʋgʋ tə, kʋ nə bɩrɩ də, ʋ wàá nəba ʋ joŋə nə cʋna wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Zwerizalɛmə tɩ̀án də ba pɛ̀egá wà Zwezi təntə yəni, ba ga wà Yɩɩ nii sʋ̀sʋ̀nà tə sʋ̀ràn tə də̀ń nì. Kʋ pɩn, ba gʋ wá, sə Yɩɩ nii sʋ̀sʋ̀nà tə sʋ̀ràn tə, ba nə kàrɩ̀ Zwifə-ba sìə́ dɩɩn mama, tə nii sú. ");
INSERT INTO nnw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Də ba nə wà yoo mama nɩ ʋ yuu wa, kʋ nə bɩrɩ də, ʋ mɛ tɩan, ba tə lòrì *Pilatə, sə ʋ pa, ba gʋ wá. ");
INSERT INTO nnw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Yá ba dàń lɩ wá dagarʋ tə yuu wa, ba gùrì ləbəri wa. Kʋ nətʋ tə yà dí yáá, kʋ pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, yá kʋ nii dàń súə́. ");
INSERT INTO nnw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Yɩɩ dàń ma bwin wá, ʋ lɩ tɩan wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ʋ bɩrɩ ʋ tɩ̀àn dɩan də dɩan ba tə nə, ba mʋ̀ də wá nə ken duən, ba nan Galile nagwanaa tə wa, ba va Zwerizalɛmə. Yá sɩ́ʋ́n nə, kʋ tɩ̀án tə nə swɩ̀n sʋywáŋʋ́ tə Yɩzərayɛlə lɩ̀à tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nə də tətə yɩ kʋ mʋ̀ sʋywáŋʋ́ tə nə, nə jə bà, sə nə bɩrɩ aba. Kʋ mʋ̀ nə yɩ won tə, Yɩɩ nə kàn nikanɩ də nə nɩbara-ba tə. ");
INSERT INTO nnw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yɩɩ pɩn kʋ nii sú sɩ́ʋ́n nə kʋ pa nə mʋ̀ nə, nə nə yɩ ba nɩ̀án. Yɩɩ lɩ Zwezi tɩan wa, ʋ kə mɩɩ wa, ndə kʋ nə pʋ́pʋ́nɩ́ bələ nii gwaran sagɩ tə wa, kʋ nə yɩ bələ nii nyiən tə wa, kʋ wʋ́: ‹Kʋ yɩ n mʋ̀ nə ya à bìú! À mʋ̀ nə lʋrɩ mʋ́ zə̀n›. ");
INSERT INTO nnw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yɩɩ yà swɩ̀n, ʋ ka bwin ka nan tə yoo də, ʋ wá bwin wá ʋ lɩ tɩan wa, ʋ kə mɩɩ wa, sə ʋ dàn ká pʋ. Ʋ yà swɩ̀n, ʋ wʋ́: ‹À wá pa aba wozəŋə tə, à nə ken vàn nə, tə nə yɩ cɩ́gá wiən. À kàn tə nikanɩ pɩ̀ʋ́ Davidə con›. ");
INSERT INTO nnw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kʋ mʋ̀ nə pɩn, kʋ tə ma swɩ̀n gwaran sagɩ tə bwálɩ́ don wa, kʋ wʋ́: ‹N bá sɛ̀e n pa ləzwənə tə, ʋ nə yɩ n mʋ̀ nə tɩ, pʋ ləbəri wa›. ");
INSERT INTO nnw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pɩ̀ʋ́ Davidə mʋ̀ twá də Yɩɩ pubʋŋa tə, ʋ ma tʋn ʋ pa Yɩɩ nə ʋ máŋá tə wa. Ʋ nə twi ʋ tɩ, ba gùrì wá ʋ nɩbara-ba tə con, ʋ də ga pʋ. ");
INSERT INTO nnw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yá Zwezi tə, Yɩɩ nə bwin, ʋ kə mɩɩ wa, wà pwɩ. ");
INSERT INTO nnw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","À nubɩa-ba, á lwara də, kʋ yɩ kʋ twá də ʋ mʋ̀ Zwezi tə, ba ma swɩ̀n də, Yɩɩ wá kwɛn nə cʋna tə nə mʋ̀ də wá pwərə wa. Ʋ wá kwɛn á cʋna yiri mama, tə nə wà kwɛn á mʋ̀ də wá pwərə wa, máŋá tə, á nə twá də Yɩɩ nii tə, ʋ nə pɩn Moyizə nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kʋ twá də Zwezi yɩrɩ tə, lìù tə mama, ʋ nə ken ʋ waa ʋ nə, ʋ wá kwɛn kʋ tíú cʋna ʋ mʋ̀ də wá pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Á cɩa á tɩ̀àn nə, sə yoo tə, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ nii sʋ̀sʋ̀nà saga tə wa dàn ká yí aba. Kʋ mʋ̀ yoo tə swɩ̀n, kʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Á mʋ̀ lɩ̀à tə, á nə goni lɩ̀à, á ywàŋá, sə kʋ gwárɩ́ aba, sə á jén lá. À tʋn yoo á lʋʋ wulu wa. Á yà bá sɛ̀e kʋ, də ba yà nə man kʋ ba bɩrɩ aba›.» ");
INSERT INTO nnw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Máŋá tə wa, Polə də Barənabasə nə nan jə́rə́ dìə̀ tə wa, ba lòrì ba, sə ba tə pìí, ba bà sìə́ dɩɩn tə, kʋ nə daa lá tə, ba bwé kʋ yoo təntə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jə́rə́ tə kwa nə, Zwifə-ba zənzən də lɩ̀à tə, ba nə sɛ̀e ba zʋ Zwifə-ba *yɩjʋncwəŋə tə wa, púə́ Polə də Barənabasə kwa. Polə də Barənabasə dàń yà kwè ba ba daŋa ba jɩ̀àn, sə ba zɩgɩ dɩ̀àn zəni Yɩɩ pubwanʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sìə́ dɩɩn tə, kʋ nə daa lá tə nə yí, kʋ yɩ ndə tɩfarʋ tə mama nə twi duən yáá, sə kʋ cʋgʋ Yɩɩ sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yá Zwifə-ba yun tɩ̀án tə nə nɩ kʋ lalʋʋ təntə, kʋ jigə wʋgwɩʋ kʋ pa ba. Yá kʋ dàń yɩ ba twá də tʋran, ba ma swɩ̀n, ba zɩga Polə nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Polə də Barənabasə swɩ̀n ba con pwənə pwənə, ba wʋ́: «Kʋ yɩ á mʋ̀ mama mɩ́ámɩ́án con nə, Yɩɩ sʋgʋ tə yà mɛ, sə kʋ dí yáá kʋ swɩ̀n. Á də vɩ kʋ á dʋga, á ga kʋ́ʋ̀ ba bʋŋa á waa con də, á tətə mɛ, sə á na mɩɩ tə, kʋ nə ba zwɛ̀e Yɩɩ con tə. Kʋ mʋ̀ nə pɩn, nə mʋ̀ dàń wá vəvəri lɩ̀à tə, ba nə tà Zwifə-ba tə con. ");
INSERT INTO nnw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yá mə yoo kʋ tə nə, Yɩɩ pɩ̀à, sə nə fwa. Yɩɩ swɩ̀n, ʋ wʋ́: ‹À tʋn mʋ́, sə n va lʋʋ tə mama wa, sə n ya ndə poni nə. N súrí lɩ̀à tə, ba nə tà Zwifə-ba tə yɩ́á, sə ba lwarɩ də, Yɩɩ wàá ba ʋ joŋə ba cʋna tə wa›.» ");
INSERT INTO nnw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ba tə, ba nə tà Zwifə-ba tə, nə nì kʋ nətʋ tə, ba pwìí poli, yá ba dàń ga bwɩ Yuu-Tiu nə ʋ sʋgʋ tə yɩrɩ. Yá lɩ̀à tə mama, Yɩɩ nə kúrí, sə ba na mɩɩ tə, kʋ nə ba zwɛ̀e ʋ con tə, dàń ken ba waa kʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Yuu-Tiu sʋgʋ tə làrɩ̀ kʋ tà lʋʋ nii tə mama. ");
INSERT INTO nnw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Zwifə-ba yun tɩ̀án tə dàń sugu kana tə, ba nə jə dun, ba nə yà jʋ̀nɩ̀ Yɩɩ, də tɩfarʋ tə nəkwɩna-ba tə, ba kə Polə də Barənabasə nə. Ba fwa nətʋ, ba kə wʋwalʋ Polə də Barənabasə nə, ba ma dɩŋɩ ba ba nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bara bələ təntə də pi ba nɛɛ purən, ba kə ba yuu wa, yá ba ga va Yikoniomə. ");
INSERT INTO nnw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Antɩʋswə nə karbɩa tə yà súə́ də pupwən də Yɩɩ-Siŋu tə. ");
INSERT INTO nnw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Yikoniomə nə, Polə də Barənabasə kʋ́ʋ̀ zʋa *Zwifə-ba *jə́rə́ dìə̀ wa, ndə kʋ don tə də nə. Ba swɩ̀n sʋgʋ kʋ yiri tə nə pɩn Zwifə-ba zənzən də *Gərɛkə-ba kə ba waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yá Zwifə-ba tə, ba nə vɩga, sə ba kə ba waa Zwezi nə tə, sugu ba tə, ba nə tà Zwifə-ba tə, ba kə lɩ̀à tə nə, ba nə yɩ nubɩa *Kərisə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Polə də Barənabasə tə wànɩ́ ba ya lá, kʋ dánɩ́. Fən yà ba ba jə *Yuu-Tiu yɩrɩ, ba ga swɩ̀n pwənə pwənə. Yuu-Tiu pɩn, ba tʋŋa ʋ dɩ̀àn mɩmɩnan də tʋtʋnan tə nə bɩrɩ ʋ dɩ̀àn tə. Tə mʋ̀ nə bɩrɩ də, Yɩɩ sʋ̀ràn tə yɩ cɩ́gá, tə ga bɩrɩ ʋ pubwanʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tɩʋ tə ləzwənbɩa tə pwɛ̀e duən wa. Ba duən yà yɩ Zwifə-ba yun tɩ̀án nə tɩ, ba duən tə də yɩ Zwezi-Kərisə *tʋntʋna tə nə tɩ. ");
INSERT INTO nnw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Zwifə-ba də ba yun tɩ̀án, də ba tə, ba nə tà Zwifə-ba tə, də ba də yun tɩ̀án dàń yà wulə ba tanɩ, sə ba kə Polə də Barənabasə càn wa, sə ba dɩlɩ ba də kapana, ba gʋ. ");
INSERT INTO nnw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Zwezi tʋntʋna tə nə twi, ba lwarɩ kʋ, ba dəri ba va Likaʋni nagwanaa tə tɩfaran tə con, tə nə yɩ Lisətərə, də Dɛrəbe də tə səpunə tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Yá kʋ bwálɩ́ təntə də nə, Polə də Barənabasə vəli ba swɩ̀n sʋywáŋʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisətərə nə, bɛɛ don yà wulə lá nə, ʋ nə yà jə̀ə́ tɩa, ʋ nɛɛ nə tɩga. Ʋ yɩ ba lʋrɩ wá gwànʋ́, yá ʋ dàń yà tə wà yɩɩ nə zàn, ʋ va mama. ");
INSERT INTO nnw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ʋ yà cʋga kʋ tə, Polə nə swɩ̀n. Polə ma ywàń wá zən, ʋ ga na də, ʋ ken ʋ waa Zwezi nə, kʋ nə wàá kʋ pɩn ʋ nɩ yazurə. ");
INSERT INTO nnw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Polə ma swɩ̀n ʋ con də kofarʋ, ʋ wʋ́: «Zàn, n zɩgɩ mənə mənə n nɛɛ tə yuu wa!» Bɛɛ tə fan, ʋ cú ʋ nɛɛ tə yuu wa, ʋ ga wulə ʋ vəli. ");
INSERT INTO nnw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ba nə nɩ kʋ tə, Polə nə fwa tə, lɩ̀à tə bubwi də Likaʋni-ba sʋgʋ, kʋ wʋ́: «Yɩa tə dàń jigə ləzoni, tə cú nə con». ");
INSERT INTO nnw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba yà jə Barənabasə ba boŋə Zeizə, Polə də nə yɩ Ɛrəmɛsə, mə ʋ mʋ̀ yà nə swɩ̀n sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeizə yɩɩ tə dìə̀ yà lwə̀ tɩʋ tə nii nə. Kʋ joŋwanʋ tə jɩn nabɛɛ, ʋ nə nan tə də tɩ̀án punə, ʋ jə bà mimiən tə yáá. Ʋ pɩ̀à, sə ʋ mʋ̀ də lalʋʋ tə fwa joŋi ba pa Zwezi *tʋntʋna tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Polə də Barənabasə nə nì kʋ, ba kàrɩ́ ba ganan, ba ga bɩbarɩ ba vələ lalʋʋ tə con də ba bubwi, ba wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Bɛ̀eɛ̀e won nə, á fwa lá nə, bara-ba? Nə də tətə yɩ ləzoni yiri nədʋ, ndə á də nə. Yá kʋ ya sʋywáŋʋ́ tə, nə kàrɩ̀ nə bɩrɩ aba, sə á dʋgʋ woŋwanʋ tə, sə á lwàń á pubʋŋa tə, á bà Yɩɩ tə, ʋ nə wulə mɩɩ wa, con, ʋ mʋ̀ Yɩɩ tə nə fwa lanworu də tɩa, də mʋʋ tə, də wiən tə mama, tə nə wulə kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bɩna də bɩna tə nə lɛ, Yɩɩ yá dwíə́ tə lʋʋ mama wa, ba nə tà *Zwifə-ba, sə ba tʋn ba fɩra. ");
INSERT INTO nnw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Də kʋ nətʋ mama ʋ tə bɩrɩ ʋ tɩ̀àn, ʋ ga fwa zəni, kʋ twá də, ʋ nə pɩn dwà naŋa yɩɩ nə, ka nɩ̀ ka pɩn á ce, də kʋ máŋá nə yí. Ʋ pɩn aba wodiu kʋ yí aba, ʋ ga sú aba də pupwən». ");
INSERT INTO nnw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Də ba nə swɩ̀n nətʋ tə mama, kʋ tə wà mwálɩ́ yɩn, sə ba ma wànɩ́, ba cɩ̀ lalʋʋ tə nə, kʋ dàn ká fwa joŋi kʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Zwifə-ba yun tɩ̀án tə nan Antɩʋswə də Yikoniomə ba bà. Ba gɩgarɩ lalʋʋ tə, ba ga dɩlɩ Polə də kapana. Ba bʋ́n də, ʋ tɩga, ba tùrì wá, ba ja nan tɩfarʋ tə nii nə. ");
INSERT INTO nnw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yá karbɩa tə nə twi, ba kun ʋ nə tə pɩn Polə pìí ʋ zàn, ʋ zʋ tɩʋ tə wa. Kʋ tɩa tə nə pʋrɩ, ʋ mʋ̀ də Barənabasə vəli Dɛrəbe. ");
INSERT INTO nnw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Máŋá tə, ba nə wànɩ́ ba kàrɩ̀ sʋywáŋʋ́ tə kʋ tɩfarʋ təntə wa, ba ga pa lɩ̀à zənzən jì Zwezi karbɩa ba pìí ba va Lisətərə. Ba zàn lá ba va Yikoniomə, ba zàn Yikoniomə, ba va Antɩʋswə. ");
INSERT INTO nnw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tɩʋ mama wa, ba daŋa karbɩa tə waa, ba swɩ̀n, sə ba zɩgɩ dɩ̀àn, ba nə ken ba waa Zwezi nə tə yuu wa. Ba bɩrɩ də, kʋ mɛ, sə nə twá càn də càn wa, sə nə ma wànɩ́ nə zʋ Yɩɩ pàrɩ̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","*Kərisə lɩ̀à púlí mama wa nə, ba kúrí *nəkwɩna. Ba dàń yàá jʋn Yɩɩ ba vwə ba nii. Kʋ kwa nə, ba yàá tì ba, ba pa *Yuu-Tiu nə, ba nə ken ba waa ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kʋ kwa nə, ba bɛn Pisidi nagwanaa tə, ba va ba yí Panfili nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ba pɩn Pɛrəgə tɩ̀án nì Yɩɩ sʋgʋ tə. Kʋ kwa nə, ba lɛ ba va Atali. ");
INSERT INTO nnw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ba zɩgɩ lá nə, ba tì nɩ́á yuu bori, ba va Antɩʋswə con bwálɩ́ tə nə, ba nə nan. Mə kʋ bwálɩ́ təntə nə, ba ken ba Yɩɩ pubwanʋ tə wa, tʋtʋŋɩ tə yɩrɩ, ba nə vəli ba tʋn. ");
INSERT INTO nnw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Máŋá tə, ba nə yí Antɩʋswə, ba bon Kərisə lɩ̀à púlí tə, ba kun duən nə. Ba dàń ga tún won tə mama, Yɩɩ nə twá də ba ʋ ma tʋn. Ba tə swɩ̀n də, Yɩɩ pɩn cwəŋə lɩ̀à tə, ba nə tà Zwifə-ba nə, sə ba də kə ba waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ba yɩn lá nə, ba dánɩ́ zənzən, ba mʋ̀ də Zwifə-ba karbɩa tə. ");
INSERT INTO nnw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bara duən nan Zwide nagwanaa tə wa, ba bà Antɩʋswə, ba kàrɩ̀ kàrà kʋ tə, ba bɩrɩ lɩ̀à tə, ba nə yɩ nubɩa *Kərisə yɩrɩ tə, ba wʋ́: «Də á mʋ̀ bara tə nə wà *goŋi aba, ndə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, nə bɩrɩ nətʋ tə, Yɩɩ bá jon aba á cʋna tə wa». ");
INSERT INTO nnw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kʋ zɩ̀n tʋ́tʋ̀ná nəfarʋ ba də Polə də Barənabasə tətəŋi wa. Kʋ pɩn Polə də Barənabasə, də ba lɩ̀à duən kə sírí, sə ba va *Zwerizalɛmə, Zwezi-Kərisə *tʋntʋna tə, də Kərisə lɩ̀à púlí yáá tɩ̀án tə con, sə ba lɩ kʋ yoo təntə yáá. ");
INSERT INTO nnw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ba lɩ̀à təntə, Kərisə lɩ̀à púlí tə nə ken cwəŋə tə wa, vəli ba lɛ Fenisi nagwanaa, ba lɛ Samari nagwanaa. Cwəŋə tə wa, ba tə swɩ̀n Kərisə lɩ̀à tə con nətʋ lɩ̀à tə, ba nə tà *Zwifə-ba tə, nə lwàń ba pubʋŋa, ba bà Yɩɩ con. Yá kʋ yoo təntə yà ga pɩn, lɩ̀à tə mama, ba nə yɩ nubɩa Kərisə yɩrɩ, jə pupwən zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ba nə yí Zwerizalɛmə, Kərisə lɩ̀à púlí tə sɛ̀e ba jon Zwezi-Kərisə tʋntʋna tə, də Kərisə lɩ̀à púlí yáá tɩ̀án tə. Yá ba dàń ga twarɩ won tə mama, Yɩɩ nə twá də ba, ʋ ma fwa. ");
INSERT INTO nnw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","*Farɩzɩan-ba púlí tə wa lɩ̀à duən, ba də nə yà ken waa Zwezi nə, dàń zàn ba wʋ́, kʋ mɛ, sə ba yà goŋi ba bara tə, yá ba ga kálʋ́ ba, sə ba zìlí Yɩɩ nii tə, ʋ nə pɩn Moyizə nə. ");
INSERT INTO nnw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tʋntʋna tə də Kərisə lɩ̀à púlí yáá tɩ̀án tə kun duən nə, sə ba balɩ kʋ yoo təntə. ");
INSERT INTO nnw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tʋ́tʋ̀ná nəfarʋ kwa nə, Piyɛrə zàn, ʋ wʋ́: «À nubɩa-ba, á də tətə yə̀ə́ də, Yɩɩ kúrí nə á tətəŋi wa, təntən dɩan tə nə, sə lɩ̀à tə, ba nə tà Zwifə-ba tə, nì Yɩɩ sʋywáŋʋ́ tə à nii wa, sə ba kə ba waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yɩɩ tə, ʋ nə yə̀ə́ ba waa tə, pɩn ba ʋ *Siŋu tə, ʋ nə pɩn nə də nə, sə ʋ ma bɩrɩ də, ba də yɩ ʋ mʋ̀ lɩ̀à, ndə nə də nə yɩ ʋ mʋ̀ lɩ̀à nətʋ. ");
INSERT INTO nnw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yɩɩ wà pwɩa ken nə mʋ̀ də ba pwərə wa. Ʋ sɩn ba bɩcanɩ tə, sə tə ya nəpon ʋ yáá con, ba nə ken ba waa Zwezi nə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Á pɩ̀à, sə á kə zɩlɩ Zwezi karbɩa tə nə, nə nɩbara-ba tə də tətə nə wà kʋ wànɩ́ ba zɩn. Bɛ̀eɛ̀e nə pɩn, á pɩ̀à Yɩɩ nii nə? ");
INSERT INTO nnw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nə yə̀ə́ də, *Yuu-Tiu Zwezi pubwanʋ tə jon ba ba cʋna wa, ndə nə də tətə nə». ");
INSERT INTO nnw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Lalʋʋ tə mama púə́ kʋ nii, yá ba ga cʋga Polə də Barənabasə, ba nə twarɩ Yɩɩ dɩ̀àn mɩmɩnan tə, də yomɩlan tə, Yɩɩ nə twá də ba, ʋ tʋn lɩ̀à tə, ba nə tà Zwifə-ba, con. ");
INSERT INTO nnw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Máŋá tə, ba nə swɩ̀n ba zwɛ̀e, Zwakə dàń swɩ̀n, ʋ wʋ́: «À nubɩa-ba, á cʋga à con. ");
INSERT INTO nnw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon tún nətʋ tə mama, Yɩɩ nə dí yáá, ʋ kúrí lɩ̀à tə, ba nə tà Zwifə-ba tə lɩ̀à, sə ba ya ʋ mʋ̀ lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kʋ sʋgʋ təntə də Yɩɩ nii *sʋ̀sʋ̀nà tə də ga vəli duən nə zəni. Kʋ nə pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa, kʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Kʋ mʋ̀ təntə kwa nə, à wá pìí, à bà à zɩ̀n pɩ̀ʋ́ *Davidə diboo tə, kʋ yà nə tʋa. À wá pìí à lwà kʋ bə́rə́ kɩkaran tə, à zɩgɩ yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kʋ wá pa ləzoni tə gɩganɩ tə pɩ̀à Yuu-Tiu, ba mʋ̀ də dwíə́ tə mama, tə nə tà Zwifə-ba, à nə wá pa à yɩrɩ tə ba. Yuu-Tiu nə swɩ̀n kʋ, ʋ mʋ̀ nə fwa wiən tə mama. ");
INSERT INTO nnw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ʋ mʋ̀ nə pɩn, ba lwarɩ tə yìə̀n təntə, halɩ kʋ máŋá nə, ba yigə!› ");
INSERT INTO nnw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kʋ mʋ̀ nə pɩn, à də yà swə, sə nə dàn ká kə wʋwalʋ lɩ̀à tə nə, ba nə tà Zwifə-ba, ba nə lwàń ba pubʋŋa, ba bà Yɩɩ con. ");
INSERT INTO nnw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","À dàń nə pɩ̀à, sə nə pʋ́pʋ́nɩ́ ba nə, nə pa ba nii, sə ba cɩ̀ ba tɩ̀àn nə də yìə̀n tə tə: Ba dàn ká də́ nàŋʋ́ tə, ba nə gʋa woŋwanʋ nə. Sə ba dàn ká cwàrɩ̀ də duən, ba dàn ká də́ wotɩgʋ nàŋʋ́. Ba dàn ká də́ jana. ");
INSERT INTO nnw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Máŋá don wa, kʋ nə dánɩ́ zənzən, lɩ̀à yɩn tɩfarʋ mama wa, ba nə kàrɩ̀ Yɩɩ nii tə, ʋ nə pɩn Moyizə nə, sagɩ tə, ba bɩrɩ Zwifə-ba *jə́rə́ dii tə wa ba *sìə́ dɩɩn mama nə». ");
INSERT INTO nnw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Zwezi-Kərisə tʋntʋna tə, də Kərisə lɩ̀à púlí yáá tɩ̀án tə, də Kərisə lɩ̀à púlí tə mama dàń bʋ́n də, kʋ mɛ, sə ba kúrí ba waa lɩ̀à duən, sə ba tʋn ba mʋ̀ də Polə də Barənabasə Antɩʋswə nə. Kʋ mʋ̀ nə yɩ Zwidə, ʋ yɩrɩ don nə yɩ Barəsabasə də Silasə. Ba bələ tə yà yɩ yáá tɩ̀án, ba nə jə dun lɩ̀à tə, ba nə yɩ nubɩa Kərisə yɩrɩ, tə tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ba dàń pɩn ba sagɩ kʋ tə, ba nə pʋ́pʋ́nɩ́ kʋ wa, ba wʋ́: «Nə mʋ̀ Zwezi tʋntʋna tə, də Kərisə lɩ̀à púlí yáá tɩ̀án tə, nə nə yɩ nubɩa Kərisə yɩrɩ, nə pʋ́pʋ́nɩ́ sagɩ kʋ tə, nə pɩn á mʋ̀ lɩ̀à tə nə, á nə tà Zwifə-ba, á wulə Antɩʋswə nə, Siri nagwanaa tə wa, də Silisi lʋʋ nii tə wa. Nə jʋ̀nɩ̀ aba. ");
INSERT INTO nnw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nə nì də, lɩ̀à nan nə con, ba ja sʋ̀ràn duən ba bà á con, ba ma gugurə aba ba cʋ̀gʋ̀ á pùə́ nə. Yá kʋ nətʋ tə ga tà nə mʋ̀ nə pɩn kʋ cwəŋə. ");
INSERT INTO nnw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nə mama ken nii nədʋ, nə ga bʋ́n nə na də, kʋ ziən, sə nə kúrí bara nə tʋn ba mʋ̀ də nə nubizəŋə Barənabasə də Polə á con. ");
INSERT INTO nnw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Polə də Barənabasə təntə dʋgʋ ba mɩɩ Yuu-Tiu Zwezi-Kərisə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nə dàń tʋŋa Zwidə də Silasə, sə ba swɩ̀n á con kʋ tə, nə nə pʋ́pʋ́nɩ́ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Yɩɩ-Siŋu tə də nə tətə nə bʋ́n nə na də, kʋ mɛ, sə nə dàn ká kə zɩla yirə duən á yuu wa, də kʋ nə tà yìə̀n tə tə, tə mʋ̀ yoo nə cà. ");
INSERT INTO nnw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tə mʋ̀ nə yɩ: Á dànà ká də́ nàŋʋ́ tə, ba nə gʋa woŋwanʋ nə! Á dànà ká də́ jana, nə à yə̀ə́ vàná, tə nə tɩga nàŋʋ́! Á dànà ká cwàrɩ̀ də duən! Á nə cɩ̀gà á tɩ̀àn nə də tə yìə̀n təntə, də á fwa zəni. Yɩɩ nə wá ya də aba!» ");
INSERT INTO nnw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ba yá lɩ̀à tə, ba də ga va Antɩʋswə. Ba nə yí lá ba bon lalʋʋ tə, ba kə duən nə, ba ga tì sagɩ tə, ba pa ba. ");
INSERT INTO nnw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ba kàrɩ̀ sagɩ tə, ba mama ga jwɛ, kʋ nə dàn ba jɩ̀àn tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Zwidə də Silasə tətə yà yɩ Yɩɩ nii sʋ̀sʋ̀nà. Ba swɩ̀n kʋ dánɩ́, sə ba ma kwè lɩ̀à tə, ba nə yɩ ba nubɩa Kərisə yɩrɩ, sə ba ma dàn ba jɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ba dánɩ́ mancɩn, kʋ kwa nə, lɩ̀à tə, ba nə yɩ ba nubɩa Kərisə yɩrɩ, pɩn ba cwəŋə, sə ba pìí ba va lɩ̀à tə con, ba nə tʋn ba də bɩcan sìə́. ");
INSERT INTO nnw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silasə mʋ̀ pìí ʋ yá də ba. ");
INSERT INTO nnw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Polə də Barənabasə mʋ̀ tə fwa dɩan də dɩan Antɩʋswə nə. Ba də lɩ̀à duən zənzən kàrɩ̀ də ba swɩ̀n Yuu-Tiu sʋgʋ tə sʋywáŋʋ́ tə. ");
INSERT INTO nnw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Dɩan bagalɩ nii nə, Polə ma swɩ̀n Barənabasə con, ʋ wʋ́: «Nə pìə́ nə va tɩfaran tə mama wa, nə nə swɩ̀n Yuu-Tiu sʋgʋ tə lá, nə jə́n nə nubɩa tə yɩ nətə». ");
INSERT INTO nnw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Sə yə̀ə́ Barənabasə yà pɩ̀à ʋ ja Zwan, ʋ yɩrɩ don nə yɩ Marəkə, ʋ súrí ba nə. ");
INSERT INTO nnw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Yá Polə mʋ̀ yà ba pɩ̀à, sə Marəkə twá, ʋ nə dí yáá ʋ pìí ʋ yá ba Panfili nagwanaa tə wa, yá ʋ kʋ́ʋ̀ wà tʋn də ba tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kʋ jigə tʋ́tʋ̀ná nəfarʋ ba pwərə wa, kʋ pa ba pwɛ̀e də duən. Barənabasə jɩn Marəkə, ʋ ma kwé ʋ tɩ̀àn, ba ga tì nɩ́á yuu bori ba va Swipərə nagwanaa. ");
INSERT INTO nnw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Polə kúrí Silasə, lɩ̀à tə, ba nə yɩ ba nubɩa Kərisə yɩrɩ, tə ga tì ba, ba kə Yɩɩ pubwanʋ tə wa, ba də ga vìí. ");
INSERT INTO nnw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ʋ vəli ʋ jijiri Siri nagwanaa də Silisi lʋʋ nii tə wa, ʋ daŋa Kərisə lɩ̀à púlə́ tə jɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Polə vəli Dɛrəbe, ʋ lɛ ʋ va Lisətərə. Lìù don yà wulə lá nə, ʋ nə yɩ Zwezi karbiu, ʋ yɩrɩ nə yɩ Timote. Ʋ nuu yɩ *Zwifə, ʋ də nə ken ʋ waa Zwezi nə. Yá ʋ nyɩna də yɩ *Gərɛkə. ");
INSERT INTO nnw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lɩ̀à tə, ba nə yɩ nubɩa *Kərisə yɩrɩ, Lisətərə nə də Yikoniomə nə, yà swɩ̀n ʋ yozəŋə tə yoo. Polə yà ken sírí, sə ʋ ja wá, ʋ kə ʋ con. ");
INSERT INTO nnw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ʋ dàń ma *goŋi wá Zwifə-ba yɩrɩ, ba nə wulə tə nagwanɛɛ təntə wa. Lɩ̀à tə mama yà yə̀ə́ də, ʋ nyɩna tə yɩ Gərɛkə. ");
INSERT INTO nnw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","5","Tɩfaran tə wa, ba nə twá ba lɛ, ba yàá swɩ̀n kʋ tə, Zwezi-Kərisə *tʋntʋna tə, də Kərisə lɩ̀à púlí yáá tɩ̀án tə nə swɩ̀n ba tún *Zwerizalɛmə nə. Ba swɩ̀n ba con, sə ba zìlí tə nii. Kərisə lɩ̀à púlə́ tə dàń kwɛn tə na dɩ̀àn, sə ba ma kwɛn ba kə ba waa Zwezi nə, yá ba ga súrí dɩɩn mama. ");
INSERT INTO nnw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Yɩɩ-*Siŋu tə cɩ̀gà ba nə, ba dàn ká swɩ̀n Yɩɩ sʋgʋ tə Azi nagwanaa tə wa. Ba dàń ma twá Fərizwi də Galasi nagwanɛɛ tə wa ba lɛ. ");
INSERT INTO nnw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Máŋá tə, ba nə vəli, ba lɛ Misi nagwanaa tə, ba yà ken sírí, sə ba va Bitini nagwanaa. Zwezi Siŋu tə ma vɩ kʋ ba con. ");
INSERT INTO nnw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ba dàń ma twá Misi nagwanaa tə wa, ba va Tərowasə. ");
INSERT INTO nnw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tɩtɩn nə, Yɩɩ pɩn Polə na yoo ʋ dwɩan wa. Ʋ nɩ Masedwanə nagwanaa tə wa bɛɛ don də ʋ zɩga, ʋ dàń ga lòrì wá, ʋ wʋ́: «Bàá Masedwanə, n san nəba!» ");
INSERT INTO nnw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kʋ mʋ̀ yoo təntə pɩn, nə va Masedwanə nə ga yə̀ə́ də, kʋ yɩ Yɩɩ nə pɩn nii nəba, sə nə ja sʋywáŋʋ́ tə, nə va nə bɩrɩ ba. ");
INSERT INTO nnw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nə tì nɩ́á yuu bori Tərowasə nə, nə te mənə mənə nə va Samotərasə nagwanaa tə wa. Kʋ tɩa nə pʋrɩ, nə lɛ nə va Neyapolisə. ");
INSERT INTO nnw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nə zɩgɩ lá, nə va Filipə. Filipə yɩ Masedwanə nagwanaa tə wa tɩfarʋ, kʋ nə dwə tə mama, kʋ nə yɩ *Romə-ba pàrɩ̀, tɩʋ. Nə yɩn kʋ tɩfarʋ təntə wa, ndə dɩan bagalɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Zwifə-ba *sìə́ dɩɩn nə yí, nə nan nə yá tɩfarʋ tə, nə va nacwəŋə don nii nə. Nə bʋ́n də, bwálɩ́ təntə wá ya yɩjʋnɩ bwálɩ́. Nə jə̀ń tɩa, nə dàń swɩ̀n də kana, ba yà nə kun lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kan don yɩn lá, ʋ yɩrɩ nə yɩ Lidi. Ʋ yɩ Tiyatirə tíú. Ʋ yà yoli gansɩan mwin. Kan təntə yà zìlí Yɩɩ fuən. Ʋ dàń yà cʋga sʋgʋ tə. *Yuu-Tiu súrí ʋ yɩ́á, sə ʋ zùrì ʋ yɩra də kʋ tə, Polə nə swɩ̀n tə. ");
INSERT INTO nnw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yá ba ləgə kan təntə də ʋ dìə̀ lɩ̀à nɩ́á wa, kʋ twá də Zwezi-Kərisə yɩrɩ tə. Kʋ kwa nə, ʋ dàń lòrì nəba, ʋ wʋ́: «Á nə wànɩ́ á bʋ́n də, à ken à waa Yuu-Tiu nə, á bɩ̀àn á yá à dìə̀ wa». Yá ʋ kálɩ́ nəba lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dɩɩn don nə, nə ma vəli yɩjʋnɩ bwálɩ́ nə, nə jə́rí tʋtʋnkana don, ʋ nə jə cicirə. Ʋ yàá swɩ̀n lɩ̀à yìə̀n, tə nə wá bà. Kʋ mʋ̀ nə pɩn, ʋ vʋa tə yà pɩn, lɩ̀à tə, ba nə tɩ wá, yà na wiən zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ʋ púə́ nə mʋ̀ də Polə kwa, də ʋ bubwi, ʋ wʋ́: «Lɩ̀à-ba tə yɩ Yɩɩ tə, ʋ nə wulə tə mɛ yuu wa, tʋ̀tʋ̀nà. Ba twi, sə ba swɩ̀n ba bɩrɩ nəba cwəŋə, sə Yɩɩ jon nəba nə cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kan tə tə pìí ʋ bwé kʋ, dɩan də dɩan. Polə waa nan kʋ, ʋ dàń ma pìí ʋ vəvəri, ʋ swɩ̀n ʋ cicirə tə con, ʋ wʋ́: «Də Zwezi-Kərisə yɩrɩ tə, à pɩn mʋ́ nii, sə n nan kan wà tə waa!» Kʋ máŋá tə tətə wa, də tə nan. ");
INSERT INTO nnw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ʋ lɩ̀à tə, ba nə tɩ wá, nə lwarɩ də, ba kʋ́ʋ̀ wàrɩ̀ nywarɩ ba nɩ ʋ yɩra, ba dàń jɩn Polə də Silasə, ba ga van ba, ba ja nan kanporu wa tɩʋ tə yun tɩ̀án yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba ja ba, ba va lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà yáá con, ba ga swɩ̀n, ba wʋ́: «Lɩ̀à-ba tə nə gugurə nə tɩʋ kʋ tə lɩ̀à tə. Ba yɩ Zwifə-ba tə. ");
INSERT INTO nnw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Yá ba mʋ̀ nə kàrɩ̀ nəba kàrà yiri don, kʋ nə wà nəba nii pɩn, nə mʋ̀ Romə-ba lɩ̀à nə, sə nə sɛ̀e, nə à yə̀ə́, sə nə fwa». ");
INSERT INTO nnw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Lalʋʋ tə nyɩ́ kʋ zàn ba zɩga Polə də Silasə nə. Lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə pɩn, ba dí yáá ba ja ba, ba kʋ̀rɩ̀ ba ganan tə, ba ga pa nii, sə ba mà ba də kafɩran. ");
INSERT INTO nnw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ba nə mà ba, ba zwɛ̀e kwa nə, ba ken ba bàń dìə̀ wa. Yá ba dàń ga pa nii lìù tə, ʋ nə cɩ̀ bàń dìə̀ tə nə, sə ʋ cɩ̀ ba nə zəni. ");
INSERT INTO nnw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kʋ tíú təntə də nə nì kʋ nii təntə, ba nə pɩn wá, ʋ də ken ba bàń dìə̀ tə tətəŋi dìə̀ tə wa. Ʋ dàń ga kə daran ba nɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Máŋá tə tɩa nə pwɛ̀e ka tàrà, Polə də Silasə wulə ba jʋ̀nɩ̀ Yɩɩ də ba nuŋə Yɩɩ gwaran tə. Yá bàń dìə̀ lɩ̀à tə ga cʋga ba. ");
INSERT INTO nnw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Naa nədʋ də tɩa tə lulugu zənzən, kʋ pa bàń dìə̀ tə dəkuu tə mama sʋsʋgʋ. Kʋ máŋá təntə tətə wa, mimiən tə mama súrí, yá bàń dìə̀ lɩ̀à tə mama banzala tə kʋ̀rɩ̀. ");
INSERT INTO nnw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bàń dìə̀ cɩ̀rʋ́ tə nə wùrì, ʋ zàn dwɩan wa, ʋ ga na mimiən tə, də tə súrí, ʋ van lagʋrɩ sɩ̀ʋ́ ʋ cʋ̀rɩ́, sə ʋ ma gʋ ʋ tɩ̀àn. Ʋ yà bʋŋa də, bàń dìə̀ lɩ̀à tə mama nan ba dəri ba jén. ");
INSERT INTO nnw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Polə dàń ma bubwi də kofarɩ, ʋ wʋ́: «Dàn ká fwa lwanɩ nədʋ mama n yɩra, nə mama wulə yəbə». ");
INSERT INTO nnw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Bàń dìə̀ nəcɩrʋ tə dàń lòrì mən, ʋ ga bɩbarɩ ʋ zʋ, ʋ tʋ Polə də Silasə yáá con də ʋ vɩvaga. ");
INSERT INTO nnw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kʋ kwa nə, ʋ jɩn ba ʋ ja nan kàrá wa, ʋ ga swɩ̀n, ʋ wʋ́: «Yun tɩ̀án-ba, bɛ̀eɛ̀e nə à mɛ, sə à fwa, sə Yɩɩ jon nə à cʋna tə wa?» ");
INSERT INTO nnw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ba ma le wá, ba wʋ́: «Kə n waa Yuu-Tiu Zwezi nə, yá Yɩɩ wá jon n də n dìə̀ lɩ̀à á cʋna wa». ");
INSERT INTO nnw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Yá ba dàń swɩ̀n Yuu-Tiu sʋgʋ tə, ba bɩrɩ ʋ mʋ̀ də lɩ̀à tə mama, ba nə wulə ʋ dìə̀ wa. ");
INSERT INTO nnw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kʋ máŋá təntə wa, tɩtɩn tə nə, ʋ lɩ ba, ʋ kə ʋ con, ʋ ga sɩn ba yɩra nʋran tə. Kʋ kwa nə, lala də ba ləgə ʋ mʋ̀ də ʋ dìə̀ lɩ̀à nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ʋ pɩn, ba zʋ ʋ dìə̀, ʋ ga pa ba fwa wodiu ba pa ba, ba də́. Yá ʋ mʋ̀ də ʋ dìə̀ lɩ̀à mama fwa pupwən, də ba nə wànɩ́ ba kə ba waa Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tɩa nə pʋrɩ, lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, tʋn lɩ̀à, sə ba swɩ̀n bàń dìə̀ nəcɩrʋ tə con, ba wʋ́: «Dʋgʋ lɩ̀à bələ təntə». ");
INSERT INTO nnw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Bàń dìə̀ nəcɩrʋ tə twi, ʋ swɩ̀n kʋ, ʋ bɩrɩ Polə nə, ʋ wʋ́: «Lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, tʋn ba swɩ̀n, sə à dʋgʋ aba. Á naŋa sɩ́ʋ́n nə, á vìí də bɩcan sìə́». ");
INSERT INTO nnw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Polə dàń swɩ̀n lɩ̀à tə, ba nə tʋn tə con, ʋ wʋ́: «Ba mà nəba lɩ̀à yáá con, ba ga wà nə bʋ̀rà bʋ̀rɩ̀ də. Nə mʋ̀ lɩ̀à tə, nə nə ya Romə-ba lɩ̀à, yá ba ga kə nəba bàń dìə̀ tə wa. Yá sɩ́ʋ́n nə, ba dàń pɩ̀à ba sə̀gə̀ ba lɩ nəba ba dʋgʋ. Abada, kʋ wàrɩ̀! Ba tətə bɩ̀àn, ba lɩ nəba!» ");
INSERT INTO nnw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Lɩ̀à tə, ba nə jɩn tʋŋa tə, ba bà tə pìí ba va ba swɩ̀n tə sʋ̀ràn təntə, ba bɩrɩ lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə nə. Fən zʋa ba, də ba nə nì də, Polə də Silasə yɩ Romə-ba lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ba dàń twi, ba kori ba, ba lɩ ba dʋgʋ, ba ga lòrì ba, sə ba nan ba tɩʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Máŋá tə, Polə də Silasə nə nan bàń dìə̀ tə wa, ba vəli Lidi dìə̀. Ba nɩ lɩ̀à tə, ba nə yɩ ba nubɩa Kərisə yɩrɩ, ba ga kwé ba. Kʋ kwa nə, ba vìí. ");
INSERT INTO nnw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Polə də Silasə twá Anfipolisə də Apoloni, ba kɛ̀eń ba va Tɛsalonikə. *Zwifə-ba yà jə *jə́rə́ dìə̀ lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Polə zʋa ka wa, ndə kʋ nə yɩ ʋ yofwamɩʋn nə. Ʋ fwa Zwifə-ba *sìə́ dɩan tə batwa, ʋ mʋ̀ də ba ma swɩ̀n də duən Yɩɩ sagɩ tə yoo yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ʋ yàá gwin Yɩɩ sagɩ sʋ̀ràn tə də̀ń, ʋ bɩrɩ ba də, *Kərisə yà mɛ, sə ʋ də́ càn, sə ʋ pìí ʋ bwin ʋ nan tɩga wa. Polə swɩ̀n, ʋ wʋ́: «Ʋ mʋ̀ Zwezi tə, à nə swɩ̀n ʋ yoo à bɩrɩ aba, nə yɩ Kərisə». ");
INSERT INTO nnw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Sʋgʋ tə zʋa ba wa lɩ̀à duən, ba ga nan ba súrí Polə də Silasə nə, kʋ súrí lalʋʋ nə, ba nə yɩ *Gərɛkə-ba, yá ba ga zìlí Yɩɩ, də kana duən, ba də nə jə dun kana wa. ");
INSERT INTO nnw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yá Zwifə-ba yáá tɩ̀án kʋ́ʋ̀ zàn də wʋgwɩʋ, ba ja bara duən, ba nə yɩ ləzwənyanan lalʋʋ tə wa, ba ma zɩ̀n lɩ̀à tə lɩŋa, ba ga gugurə tɩʋ tə. Ba vəli ba kun Zwason dìə̀ yáá, sə ba pɩ̀à Polə də Silasə, ba ja bà lalʋʋ tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ba vəli ba wà ba nɩ, ba dàń pìí ba van Zwason, də lɩ̀à duən də, ba nə yɩ ʋ nubɩa Kərisə yɩrɩ, ba ja bà tɩʋ tɩ̀án tə yáá con, də ba bubwi, ba wʋ́: «Lɩ̀à tə, ba nə gugurə nə tɩa yuu lɩ̀à tə mama twi yəbə. ");
INSERT INTO nnw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yá kʋ ya Zwason nə sɛ̀e ʋ jon ba ʋ dìə̀ wa. Ba mʋ̀ lɩ̀à təntə mama tʋtʋnɛɛ də yɩ tə zɩga *Romə-ba pɩ̀ʋ́ nəfarʋ tə nii yìə̀n tə nə. Ba ga tə swɩ̀n də, pɩ̀ʋ́ don wulə, ʋ yɩrɩ nə yɩ Zwezi». ");
INSERT INTO nnw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tə sʋ̀ràn təntə gugurə lalʋʋ tə də tɩʋ tɩ̀án tə. ");
INSERT INTO nnw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kʋ mʋ̀ nə pɩn, Zwason də ba duən tə ŋwɩ́n vwinən, ba pa tɩʋ tɩ̀án tə nə, sə ba dàń ma zɩgɩ lá, ba dʋgʋ ba. ");
INSERT INTO nnw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tɩa nə twi, ka yì máŋá tə wa, lɩ̀à tə, ba nə yɩ Polə də Silasə nubɩa *Kərisə yɩrɩ tə, lɩ ba, ba pa ba va Bere. Máŋá tə, ba vəli ba yí lá, ba vəli *Zwifə-ba *jə́rə́ dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ba mʋ̀ Bere tɩ̀án tə yà ken ba sírí, sə ba cʋgʋ Yɩɩ sʋgʋ tə ba doni Tɛsalonikə tɩ̀án tə. Ba sɛ̀e Yɩɩ sʋgʋ tə də yawala zənzən. Ba yàá bɛ̀eé Yɩɩ sagɩ tə dɩɩn mama, sə ba jə́n kʋ tə, Polə nə swɩ̀n, tə yɩ cɩ́gá, naaa. ");
INSERT INTO nnw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ba lɩ̀à zənzən ken ba waa Zwezi nə. Kʋ súrí *Gərɛkə-ba wa kana zənzən, ba nə ja dun kana wa, də bara zənzən də ken ba waa Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yá Tɛsalonikə Zwifə-ba yáá tɩ̀án tə nə lwarɩ də, Polə wulə ʋ swɩ̀n Yɩɩ sʋgʋ tə, ʋ bɩrɩ Bere tɩ̀án tə nə. Ba twi, ba zɩ̀n ba lɩ̀à tə lɩŋa, ba ga gugurə lalʋʋ tə Bere də nə. ");
INSERT INTO nnw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Lɩ̀à tə, ba nə yɩ Polə nubɩa Kərisə yɩrɩ, ma pa, Polə va mʋʋ tə vàn nə lala, ba ga yá Silasə də Timote mʋ̀ Bere nə. ");
INSERT INTO nnw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lɩ̀à tə, ba nə kwé Polə tə, ja wá ba va wuuu, ba yí Atɛnə. Ba mé lá nə ba pìí ba vìí də Polə tʋŋɩ, sə tə pa Silasə də Timote nə, sə ba bà lala, ba yí wá. ");
INSERT INTO nnw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Máŋá tə, Polə nə dànɩ̀ Silasə də Timote Atɛnə wa, ʋ pùə́ cʋ̀gʋ̀ zənzən də nətʋ, ʋ nə na tɩʋ tə də kʋ súə́ də woŋwanan. ");
INSERT INTO nnw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ʋ mʋ̀ də *Zwifə-ba də lɩ̀à tə, ba nə zìlí Yɩɩ tə, dàń yà ve duən nə *jə́rə́ dìə̀ tə wa. Dɩɩn mama, ʋ yàá vəli kanporu tə wa, ʋ ve də lɩ̀à tə, ʋ nə yàá na lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yipʋrɩnyɩna duən yɩn lá nə, ba də nə swə ka pɩ̀à yənu zənzən. Ba duən yà yɩ yipʋrɩnyɩna, ba nə boŋə ba ‹Epikurɩan-ba›, ba duən də ga yɩ yipʋrɩnyɩna ‹Sətoyisɩan-ba›. Ba duən swɩ̀n, ba wʋ́: «Bɛ̀eɛ̀e nə kʋnkʋn sʋ̀sʋ̀nʋ̀ wá tə pɩ̀à, sə ʋ swɩ̀n?» Ba duən də kʋ́ʋ̀ swɩ̀n, ba wʋ́: «Ʋ yɩ ndə lìù tə, ʋ nə swɩ̀n yɩa duən yoo, nə nə yə̀rì tə yoo». Kʋ wàá nətʋ kʋ yanɩ, ʋ swɩ̀n Zwezi sʋywáŋʋ́ tə. Ʋ ma swɩ̀n ka pìí ka bwin ka nan də yoo. ");
INSERT INTO nnw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Ba dàń ma ja wá, ba ja va bwálɩ́ don, ba nə yàá jə́rí duən, kʋ bwálɩ́ tə nə. Ba boŋə kʋ Arɩʋpazə. Ba dàń ga swɩ̀n ʋ con, ba wʋ́: «N pa nə nə̀ń yodʋra nə zɩɩn wa. Yá nə dàń pɩ̀à, sə nə lwarɩ tə də̀ń. Kʋ mʋ̀ nə pɩn, nə pɩ̀à, sə n twarɩ kàrà nədʋn tə nɛɛ n bɩrɩ nəba». ");
INSERT INTO nnw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atɛnə tɩ̀án də vərə yà nə wulə duən nə. Ba mɛ tʋtʋnan yà nə yɩ, yodʋn ka cʋgʋ də yodʋn ka swɩ̀n, ka bɩrɩ lɩ̀à nə cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","23","Polə nyɩ́ ʋ zàn yɩɩ nə Arɩʋpazə tə wa, ʋ ga swɩ̀n, ʋ wʋ́: «Atɛnə tɩ̀án-ba, à nə twá á tɩʋ tə wa, à jiri à nɩ wiən tə, á nə ŋwanɩ tə nə. À nɩ *joŋi bwálɩ́ don, á nə lwə̀, á pʋ́pʋ́nɩ́ kʋ yuu wa, á wʋ́: ‹Kʋ yɩ yɩɩ tə, á nə yə̀rì nyiən›. Kʋ mʋ̀ nə pɩn, á dí yáá á yɩ lɩ̀à tə, á nə bwɩ wiən zənzən nə. Kʋ yɩ won tə, á nə jʋ̀nà kʋ, á ga yə̀rì kʋ. Mə kʋ mʋ̀ nə à pɩ̀à, sə à swɩ̀n á con. ");
INSERT INTO nnw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yɩɩ tə, ʋ nə fwa tɩa tə də wiən tə mama, tə nə wulə ka wa, ʋ mʋ̀ yɩ lanworu də tɩa mɛ *Yuu-Tiu. Ʋ mʋ̀ Yɩɩ təntə ba dii tə, ləzoni jɩ̀àn nə lwə̀, wa yanɩ. ");
INSERT INTO nnw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ʋ ga kʋ́ʋ̀ ba pɩ̀à, sə ləzoni jɩ̀àn tʋn wiən, tə pa ʋ mʋ̀ Yɩɩ nə. Kʋ dàn ká nyɩn ndə ʋ pɩ̀à, sə ləzoni san wá də won mama. Ʋ mʋ̀ nə pɩn mɩɩ də siŋu, də wiən tə mama ləzoni tə mama nə. ");
INSERT INTO nnw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ʋ mʋ̀ nə twá də bɛɛ nədʋ nə, ʋ ma pa ləzoni pùlì ba wulə tɩa tə yuu mama wa. Ʋ mʋ̀ nə tún máŋá, ʋ pa dwíí mama nə, ʋ ga fwa ba nagwanɛɛ tə sɩswɩan ʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ʋ fwa kʋ nətʋ tə, sə ləzoni ma wànɩ́ ba tɩtɛ, ba ma pɩ̀à ʋ mʋ̀ Yɩɩ ba na. Yɩɩ ga ba ŋʋ́ná də nə lìù mama. ");
INSERT INTO nnw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ʋ mʋ̀ con, nə nə ja mɩɩ, nə ga wàá nə yɩra wa nə dwanɩ. Ʋ mʋ̀ nə pɩn, nə wulə. Á də tətə wa gwɛɛ duən swɩ̀n kʋ, ba wʋ́: ‹Nə də yɩ ʋ dwíí tə wa lɩ̀à›. ");
INSERT INTO nnw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nə dàń nə yɩ Yɩɩ dwíí tə bɩa, nə kʋ́ʋ̀ wà mɛ, sə nə bʋ́n də, Yɩɩ wàá ʋ nyɩn ndə sɩ́án nə, nə à yə̀ə́ ndə cɩnɩa nə, nə à yə̀ə́ ndə kapan nə, ləzoni nə sarɩ də ba təntɩan pubʋŋa. ");
INSERT INTO nnw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yɩɩ yà ba ləzoni tə ləyəri tə máŋá tə ywàŋá, sə ʋ kə ba càn wa. Sɩ́ʋ́n nə, Yɩɩ dàń pɩn nii ləzoni tə mama nə bwala tə mama nə, sə ba vəvəri kwa, ba ma sá ba cʋna. ");
INSERT INTO nnw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Yɩɩ kúrí dɩɩn ʋ tún, ʋ ga lɩ lìù, sə ʋ twá kʋ tíú nə, ʋ ma bʋ̀rɩ̀ tɩa yuu lɩ̀à tə mama bʋ̀rà, ʋ cɩ́gá tə wa. Kʋ mʋ̀ lìù təntə, ʋ nə kúrí tə, ʋ pɩn kʋ tíú pìí ʋ bwin, ʋ nan tɩga wa, sə kʋ pa, lɩ̀à tə mama lwarɩ də, kʋ yɩ cɩ́gá». ");
INSERT INTO nnw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Máŋá tə, ba nə nì də Polə swɩ̀n, ka pìí ka bwin ka nan tɩga wa yoo, ba duən dí bɩyɩrɩ ʋ yuu wa, ba duən tə ga swɩ̀n, ba wʋ́: «Nə tə dànɩ̀ mʋ́ dɩɩn don nə, kʋ yoo təntə yuu wa». ");
INSERT INTO nnw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nətʋ nə kʋ yɩn, Polə dàń ma nan ba tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Də kʋ nətʋ tə mama, bara duən tə vwə ba tɩ̀àn Polə nə, ba ga kə ba waa Zwezi nə. Ba wa lìù don yɩrɩ nə yɩ Denisə, ʋ nə yɩ Arɩʋpazə tə yáá tɩ̀án tə wa lìù don, də kan, ʋ yɩrɩ nə yɩ Damarisə, də lɩ̀à duən də. ");
INSERT INTO nnw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kʋ kwa nə, Polə nan Atɛnə ʋ va Korɛntə. ");
INSERT INTO nnw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ʋ vəli, ʋ yí *Zwifə don lá, ʋ yɩrɩ nə yɩ Akilasə, ʋ nə yɩ Pon nagwanaa tə wa lìù. *Romə-ba pɩ̀ʋ́ nəfarʋ *Kəlodə yà pɩn nii Zwifə-ba mama nə, sə ba nan Romə wa. Kʋ mʋ̀ nə pɩn, Akilasə də ʋ kan Pərisilə də yà nan Yitali nagwanaa, ba bà kʋ máŋá tə wa. Polə vwə ʋ tɩ̀àn kʋ bɛɛ təntə də ʋ kan tə yɩra. ");
INSERT INTO nnw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ba mɛ tʋtʋŋɩ yà yɩ won nədʋ, kʋ mʋ̀ nə yɩ gansilə fwàŋʋ́. Polə dàń ga wulə də ba, ʋ mʋ̀ də ba tʋŋa də duən. ");
INSERT INTO nnw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Polə yà ve də Zwifə-ba də *Gərɛkə-ba *sìə́ dɩɩn mama nə, *jə́rə́ dìə̀ tə wa, ʋ ma swɩ̀n də ba, sə ʋ wànɩ́ ba, ʋ kə ʋ nyiən wa. ");
INSERT INTO nnw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silasə də Timote dàń nə nan Masedwanə nagwanaa tə wa, ba bà, Polə dàń tì ʋ máŋá mama, ʋ ma swɩ̀n sʋgʋ tə. Ʋ swɩ̀n kʋ ʋ bɩrɩ Zwifə-ba nə, də Zwezi nə yɩ *Kərisə. ");
INSERT INTO nnw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Zwifə-ba dàń zàn ba zɩga ʋ nə, ba twɩn wá. Polə dàń ma bɩbaga ʋ ganan kukulu. Ʋ ga swɩ̀n, ʋ wʋ́: «Á tanyɩnɩ tə càn wá pìí kʋ tʋ á tətə yuu wa. Kʋ tà à mʋ̀ yoo. Yá sɩ́ʋ́n nə à dàń wá va lɩ̀à tə, ba nə tà Zwifə-ba tə, con». ");
INSERT INTO nnw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Polə nan lá nə, ʋ va bɛɛ don dìə̀ wa. Ʋ yɩrɩ nə yɩ Titiusə Zwisətisə. Kʋ bɛɛ təntə yɩ lìù tə, ʋ nə zìlí Yɩɩ zəni. Ʋ dìə̀ yà wulə jə́rə́ dìə̀ tə səpuni nə. ");
INSERT INTO nnw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kərisəpisə, ʋ nə yɩ jə́rə́ dìə̀ tə yáá tíú, də ʋ dìə̀ lɩ̀à mama, ken ba waa *Yuu-Tiu nə. Korɛntə tɩ̀án zənzən, ba də nə cʋgʋ Polə sʋ̀ràn tə, ken ba waa Zwezi nə, ba ga lə ba nɩ́á wa, kʋ twá də Zwezi-Kərisə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tɩtɩn nə Polə dwɛ̀e, ʋ na Yuu-Tiu, də ʋ swɩ̀n ʋ con, ʋ wʋ́: «Dàn ká pa fən ja mʋ́! Swɩ̀n, sə n dàn ká pú n nii! ");
INSERT INTO nnw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","À jə lalʋʋ tɩfarʋ kʋ tə wa. À wulə də mʋ́, yá lìù mama ba zɩ̀n ʋ jɩ̀àn, sə ʋ ma fwa mʋ́ lwanɩ». ");
INSERT INTO nnw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Polə yɩn lá nə, bɩnɩ də cànɩ̀ bardʋ, ʋ ma kàrɩ̀ Yɩɩ sʋgʋ tə ba tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kʋ máŋá tə wa, də Galion nə yɩ Akayi nagwanaa tə yáá tíú, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún. Zwifə-ba yáá tɩ̀án ken nii nədʋ, ba ja Polə ba ja va yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, púlí tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ba ga swɩ̀n, ba wʋ́: «Kʋ bɛɛ wà tə yɩ ʋ wulə ʋ yigə lɩ̀à tə, sə ʋ pa ba bʋ Yɩɩ nə yiri don kʋ, də nə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə tə, nə zɩga duən nə». ");
INSERT INTO nnw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Polə nə pɩ̀à, sə ʋ súrí ʋ nii ʋ swɩ̀n, də Galion le Zwifə-ba, ʋ wʋ́: «Kʋ yà nə yɩ kʋnkʋn wiən, nə à yə̀ə́ yokʋkwɩʋn nə ʋ fwa, à yà wá tì máŋá, à ma cʋgʋ á mʋ̀ Zwifə-ba sʋ̀ràn tə ndə cɩ́gá nə. ");
INSERT INTO nnw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kʋ nətən tə dàń nə yɩ á tʋ́tʋ̀nɩ́ duən lɩ̀à yɩra, də á tətə Yɩɩ nii tə, ʋ nə pɩn Moyizə nə tə, də á kàrà tə yuu wa, kʋ mʋ̀ tà à yáá yoo. À ba pɩ̀à, sə à bʋ̀rɩ̀ kʋ bʋ̀rà». ");
INSERT INTO nnw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galion nə swɩ̀n kʋ nətʋ tə, ʋ zwɛ̀e ʋ dʋgʋ ba, sə ba nan lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà púlí tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ba mama dàń jɩn Sosətɛnə, ʋ nə yɩ jə́rə́ dìə̀ tə yáá tíú, ba wulə ba mà wá lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə púlí tə yáá con. Yá Galion tə nə wà pa, kʋ yoo yɩ̀ wá. ");
INSERT INTO nnw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Polə dánɩ́ Korɛntə nə zəni. Kʋ kwa nə, ʋ kʋ́ʋ̀ lòrì cwəŋə lɩ̀à tə con, ba nə yɩ ʋ nubɩa *Kərisə yɩrɩ, ʋ ga tì nɩ́á yuu bori, ʋ mʋ̀ də Pərisilə də Akilasə, ba dàń ma vəli Siri nagwanaa. Polə yà fwa kʋ mʋ̀ nə pɩn, ʋ yà pɩn ba gɩan ʋ yukʋran tə, Sankəre nə, kʋ máŋá tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba vəli ba yí Efɛzə nə, Polə ma yá ʋ twaduən tə lá nə, yá ʋ ga zʋ *Zwifə-ba *jə́rə́ dìə̀ tə wa, ʋ vʋrɩ də ba. ");
INSERT INTO nnw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Zwifə-ba lòrì wá, sə ʋ ya də ba máŋá mancɩn wa. Yá Polə wà kʋ sɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ʋ lòrì cwəŋə ba con, ʋ ga swɩ̀n, ʋ wʋ́: «Yoo nədʋ nə à pɩ̀à, kʋ mʋ̀ nə yɩ, sə à fwa cànà tə, ka nə bɩ̀àn tə *Zwerizalɛmə wa. À tə wá pìí à bà á con, də Yɩɩ nə swə kʋ». Ʋ dàń ga tì nɩ́á yuu bori Efɛzə nə, ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ʋ vəli ʋ twá Sezare nə, ʋ jʋn Kərisə lɩ̀à púlí tə, ʋ ga lɛ ʋ va ʋ cú Antɩʋswə nə. ");
INSERT INTO nnw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Polə fwa máŋá mancɩn Antɩʋswə nə, ʋ ga pìí ʋ va, ʋ jijiri Galasi nagwanaa tə wa də Fərizwi nagwanaa tə wa, ʋ ma daŋa Zwezi karbɩa tə mama jɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","*Zwifə don, ʋ yɩrɩ nə yɩ Apɔlɔsə, ʋ nə ya Alɛkəzandəri tíú, twi ʋ yí Efɛzə. Bɛɛ təntə yə̀ə́ sʋgʋ yáá, ʋ ga yə̀ə́ Yɩɩ saga tə zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ba yà kàrɩ̀ wá *Yuu-Tiu cwəŋə tə yoo wa. Ʋ yà ga jə yawala də kʋ. Apɔlɔsə dàń yà swɩ̀n ʋ bɩrɩ də ʋ kàrɩ̀, ndə nətʋ tə nə, kʋ nə mɛ, Zwezi yoo wa. Ʋ yà fwa kʋ nətʋ tə, ʋ ga yɩ Zwan nə ləgə lɩ̀à tə nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ, tə cɩcɩ nə ʋ yə̀ə́. ");
INSERT INTO nnw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ʋ zàn ʋ wulə ʋ swɩ̀n nəpon nəpon Zwifə-ba *jə́rə́ dìə̀ tə wa. Pərisilə də Akilasə nə cʋgʋ ʋ sʋ̀ràn tə kwa nə, ba jɩn wá, ba kə ba con, yá ba ga bɩrɩ wá Yɩɩ cwəŋə tə də cɩ́gá mama. ");
INSERT INTO nnw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kʋ kwa nə, Apɔlɔsə ken ʋ sírí, sə ʋ va Akayi nagwanaa tə wa. Lɩ̀à tə, ba nə yɩ ʋ nubɩa *Kərisə yɩrɩ, tə dàn ʋ jɩ̀àn, ba ga pʋ́pʋ́nɩ́ sagɩ ba pa Zwezi karbɩa tə nə, ʋ nə yí lá, sə ba ja wá zəni. Ʋ nə vəli ʋ yí lá nə, ʋ san ba tə nə, ba nə ken ba waa Zwezi nə zənzən, kʋ twá də Yɩɩ pubwanʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kʋ yà yɩ kanporu wa nə, ʋ swɩ̀n Zwifə-ba con də barɩ ʋ bɩrɩ ba nəpon nəpon də, ba tə̀lə́ cwəŋə wa. Ʋ tì Yɩɩ saga tə, ʋ twá tə nə, ʋ ma bɩrɩ də, Zwezi nə yɩ Kərisə. ");
INSERT INTO nnw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Máŋá tə wa, Apɔlɔsə nə wulə Korɛntə nə, Polə mʋ̀ vəli ʋ twá pɛɛn tə wa, kʋ lʋʋ nii tə nagwanɛɛ tə wa, ʋ kɛ̀eń ʋ va Efɛzə. Ʋ vəli, ʋ jə́rí Zwezi karbɩa duən. ");
INSERT INTO nnw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ʋ dàń ma swɩ̀n ba con, ʋ wʋ́: «Yɩɩ-*Siŋu tə cuə á yuu wa, máŋá tə wa, á nə ken á waa Zwezi nə, naaa?» Ba ma le wá, ba wʋ́: «Nə tà nə wà nì tətə də, Yɩɩ-Siŋu tə yɩ ba pɩn». ");
INSERT INTO nnw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Polə tə kʋ́ʋ̀ pìí ʋ bwe ba, ʋ wʋ́: «Bɛ̀eɛ̀e wa nə ba dàń ləgə aba, kʋ twá də Yɩɩ yɩrɩ tə?» Ba ma kʋ́ʋ̀ le wá, ba wʋ́: «Kʋ ya Zwan nɩ́á liu tə». ");
INSERT INTO nnw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Polə dàń ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «Zwan ləgə lɩ̀à mama nɩ́á wa, kʋ twá də Yɩɩ yɩrɩ. Kʋ nətʋ bɩrɩ də, ba mɛ, sə ba vəvəri ba kwa, ba ma sá ba cʋna, ba bà Yɩɩ con. Ʋ yàá swɩ̀n lalʋʋ tə con, ʋ wʋ́, ba kəni ba waa lìù tə nə, ʋ nə wulə ʋ mʋ̀ Zwan kwa ʋ bɩ̀àn, kʋ mʋ̀ nə yɩ Zwezi». ");
INSERT INTO nnw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tə sʋ̀ràn təntə kwa nə, ba ləgə ba nɩ́á wa də *Yuu-Tiu Zwezi yɩrɩ tə. ");
INSERT INTO nnw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Polə tún ʋ jɩ̀àn ba yuu wa, yá Yɩɩ-Siŋu tə ga cú ba yuu wa. Ba wulə ba swɩ̀n sʋyirə duən, də ba swɩ̀n Yɩɩ nii sʋ̀ràn. ");
INSERT INTO nnw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bara təntə mama yà yɩ ndə lɩ̀à fugə bələ nə. ");
INSERT INTO nnw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Polə zʋa *Zwifə-ba *jə́rə́ dìə̀ tə wa, ʋ swɩ̀n cɩ́gá tə pwənə pwənə wuuu, cànɩ̀ batwa. Ʋ swɩ̀n ba con də, Yɩɩ wá də́ ʋ pàrɩ̀ tə ba yuu wa. Yá ʋ sʋ̀ràn tə yà ga dɩ ba. ");
INSERT INTO nnw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lɩ̀à duən dàń yɩn lá nə, ba nə za ba vaparan, ba ga vɩ, sə ba kə ba waa Zwezi nə. Yá ba dàń swɩ̀n ba pwé Yuu-Tiu cwəŋə tə lalʋʋ tə yáá con. Polə dàń ma nan ba tətəŋi wa, ʋ jə Zwezi karbɩa tə, ʋ va ʋ kàrɩ̀ ba dɩɩn mama Tiranisə kardiə tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kʋ nətʋ tə dánɩ́ bɩna bələ, kʋ pa Zwifə-ba də *Gərɛkə-ba, ba nə wulə Azi nagwanaa tə wa, nì Yuu-Tiu sʋgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yɩɩ yà twá Polə nə, ʋ tʋŋa ʋ yogwaran tə yiri nə yɩ tə cɩcɩ. ");
INSERT INTO nnw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kʋ yiri tə pɩn, ba pəri ganan nə à yə̀ə́ gantwɛn tə nə dwen Polə yɩra yayɩŋa yuu nə, yá yayɩran tə yàá nan, tə yá ba. *Zinə də naŋa, tə yá ba. ");
INSERT INTO nnw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","*Zwifə-ba duən, ba də nə yà twá lá ba vəli, də́də́n, sə ba ja *Yuu-Tiu Zwezi yɩrɩ tə, ba ma dɩŋa zinə lɩ̀à yuu wa. Ba dàń yàá swɩ̀n, ba wʋ́: «À dwì à kəni á nə də Zwezi tə, Polə nə kàrɩ̀ ʋ yoo tə». ");
INSERT INTO nnw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Lɩ̀à tə, ba nə yà fwa kʋ yoo təntə, yà yɩ bɛɛ don, ʋ yɩrɩ nə yɩ Seva, bɩa barpɛ. Ʋ mʋ̀ Seva təntə yà yɩ Zwifə-ba Yɩɩ *joŋwana yuu tíú don. ");
INSERT INTO nnw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Zini tə dàń ma le ba, kʋ wʋ́: «À yə̀ə́ Zwezi, à ma yə̀ə́ lìù tə, ʋ nə yɩ Polə, sə á mʋ̀, á mʋ̀ nə yɩ bə̀rə́?» ");
INSERT INTO nnw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yá bɛɛ tə, zini tə nə wulə ʋ yuu wa, dàń fan ʋ tʋ ba mama yuu wa. Ʋ jɩn ba duən, ʋ bɩrɩ ba də, ʋ dɩ̀àn dwə ba. Ʋ fɩfɩn ba də dɩ̀àn yiri don, kʋ pa ba dəri dìə̀ təntə wa wala, ʋ ga tún nʋran ba yɩra. ");
INSERT INTO nnw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Zwifə-ba də *Gərɛkə-ba, ba nə yɩn Efɛzə nə, lwarɩ kʋ yoo təntə. Yá fən dàń zʋa ba mama, Yuu-Tiu Zwezi yɩrɩ tə ga na dun. ");
INSERT INTO nnw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ba tə, ba nə ken ba waa Zwezi nə tə, lɩ̀à zənzən naŋa, ba twi ba lòrì, sə Yɩɩ kwɛn ba cʋna ba mʋ̀ də wá pwərə wa, ba ga swɩ̀n ba cɩrɩ tə mama, ba nə fwa. ");
INSERT INTO nnw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ba mʋ̀ lɩ̀à təntə ja ba saga, ba nə ma fwa cɩrɩ, ba bà ba pa ba sʋrɩ tə, lɩ̀à tə mama yáá con. Ba jələ tə səbiu, ba na də kʋ yɩ səbikʋlan mʋ̀rʋ̀ finu (50 000). ");
INSERT INTO nnw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mə nətʋ nə, kʋ dàń twá də Yuu-Tiu dɩ̀àn tə, ʋ sʋgʋ tə ma swɩ̀n, kʋ sú nagwanaa tə mama wa. ");
INSERT INTO nnw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tə mʋ̀ yìə̀n tə nə tʋn tə zwɛ̀e kwa nə, Polə ken ʋ pubʋŋa wa, sə ʋ twá Masedwanə də Akayi nagwanɛɛ tə wa, ʋ lɛ ʋ va *Zwerizalɛmə. Ʋ yà pɩ̀à də máŋá tə wa, ʋ nə yí Zwerizalɛmə, sə ʋ kɛ̀eń, ʋ va ʋ na *Romə. ");
INSERT INTO nnw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ʋ lɩ ʋ lɩ̀à tə, ba nə saŋa wá, lɩ̀à bələ ʋ tʋn Masedwanə nə, kʋ mʋ̀ nə yɩ Timote də Erasətə. Ʋ tətə ga ya Azi nagwanaa tə wa, máŋá mancɩn wa. ");
INSERT INTO nnw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kʋ máŋá təntə wa, təgurə nəfarʋ twi, kʋ ya lá nə, *Yuu-Tiu cwəŋə tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Cɩnayarʋ don yɩn lá, ʋ yɩrɩ nə yɩ Demetəriyisə. Ʋ yà fwa Arətemisə dìə̀ tə, ba nə yàá jʋ̀nɩ̀ ka wa tə, nəmanbii də cɩnɩa. Ʋ dàń yà pɩn lɩ̀à tə, ba mʋ̀ də wá nə tʋŋa tʋtʋŋɩ təntə, na nywarɩ zənzən kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetəriyisə ken ba tə, ʋ mʋ̀ də ba nə tʋŋa kʋ tʋtʋnyiri nədʋ təntə, də ba tə, ba də nə tʋŋa kʋ tʋtʋnyiri təntə yáá tɩ̀án tə duən yáá nə, ʋ ga swɩ̀n ba con, ʋ wʋ́: «À dabara-ba, á mʋ̀ yə̀ə́ də, nə wojan tə yɩ ka naŋa tʋtʋŋɩ kʋ tə nətən wa. ");
INSERT INTO nnw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Á na, á ga nə̀ń kʋ tə, bɛɛ təntə, ʋ yɩrɩ nə yɩ Polə, nə fwa. Kʋ tà Efɛzə cɩcɩ wa, kʋ yɩ də Azi nagwanaa tə də mɛ. Ʋ sʋ̀ràn tə vəvəri lalʋʋ zənzən, də ʋ nə bɩrɩ ba də, yɩa tə, ləzwənə jɩ̀àn nə fwa, tə tà yɩa. ");
INSERT INTO nnw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kʋ yoo təntə wá bà kʋ cʋ̀gʋ̀ nə tʋtʋŋɩ tə. Kʋ ga tà kʋ cɩcɩ, kʋ wá pa yɩkan nəfarʋ Arətemisə dìə̀ tə ya ndə tʋtʋ nə. Kʋ yɩkan təntə wá kwɩ̀n dun tə nə, Azi nagwanaa lɩ̀à, də tɩa yuu lɩ̀à tə mama yà nə pɩn kʋ». ");
INSERT INTO nnw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lɩ̀à tə nə nì tə sʋ̀ràn tə ba zwɛ̀e, ba súə́ də lɩŋa, ba ga bubwi, ba wʋ́: «Efezɩan-ba yɩkan Arətemisə nə dáá!» ");
INSERT INTO nnw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kʋ yoo tə zɩ̀n tɩfarʋ tə mama kʋ zɩgɩ yɩɩ nə. Ba vəli ba kun duən nə bwálɩ́ don nə, ba nə fwa mʋmʋn lá, ba ga van Masedwanə tɩ̀án bələ, ba ja bà. Kʋ mʋ̀ nə ya Gayisə də Arisətarəkə, ba nə yɩ Polə twaduən ʋ vələ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Polə yà pɩ̀à, sə ʋ nan lalʋʋ tə yáá con, ʋ pa ba na wá. Zwezi karbɩa tə ma kán ʋ nə, sə ʋ dàn ká fwa kʋ. ");
INSERT INTO nnw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Azi nagwanaa yáá tɩ̀án duən, ba də nə yɩ Polə dabara, tʋn lɩ̀à, sə ba kwè wá, ʋ dàn ká va bwálɩ́ təntə nə. ");
INSERT INTO nnw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kʋ máŋá təntə wa, lalʋʋ tə gugurə. Ba duən yàá bubwi yiri don, ba duən də bubwi yiri don. Yá ba zʋnɩ tətə yə̀rì won tə tətə yɩrɩ, ba nə kun duən nə. ");
INSERT INTO nnw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ba dàń ma pa Alɛkəzandərə nan lalʋʋ tə wa. Ʋ mʋ̀ Alɛkəzandərə tə yɩ *Zwifə-ba yà nə yigə wá, ba kəni yáá. Yá Alɛkəzandərə də dàń yà ja ʋ jɩ̀àn, ʋ ma fwa mɩmɩnʋ ʋ pɩ̀à, sə ʋ swɩ̀n ʋ ma jon ʋ tɩ̀àn lalʋʋ tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ba nə lwarɩ də, ʋ yɩ Zwifə, ba mama bubwi də kori nədʋ, kʋ dánɩ́ ndə lugu bələ nə, ba wʋ́: «Efezɩan-ba yɩkan Arətemisə nə dáá!» ");
INSERT INTO nnw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kʋ máŋá təntə wa, ba tɩʋ tə sekəretɛrə pɩn, ba yá zəzugu tə nə, ʋ ga swɩ̀n, ʋ wʋ́: «Efezɩan-ba, lìù mama tə̀lə́, ʋ nə yə̀rì də, Efɛzə tɩʋ tə nə cɩ̀ yɩkan nəfarʋ Arətemisə dìə̀ tə, də kʋ pɩ̀ʋ̀ kapan ciciru tə, kʋ nə nan yɩɩ kʋ tʋ, tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kʋ yoo təntə nə ba tʋ́tʋ̀ná jə tə yɩrɩ, á mɛ, sə á ja á tɩ̀àn sənbwen. Á dànà ká bɩbarɩ, á fwa won mama. ");
INSERT INTO nnw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Á jɩn bara-ba tə, á ja á bà yəbə. Ba mʋ̀ nə wà won ŋwɩ̀n nə yɩkan tə dìə̀ tə wa, ba ga wà nə yɩkan tə twɩn. ");
INSERT INTO nnw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Də kʋ nə yɩ Demetəriyisə də tʋ̀tʋ̀nà tə, ba nə wulə də wá, nə ja yoo də lìù, dɩan wulə, ba nə bʋ̀rɩ̀ yìə̀n bʋ̀rà, tɩʋ tə yun tɩ̀án ma wulə. Ba vələ ba bon kʋ tíú lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nə à yə̀ə́, də kʋ nə yɩ yoo don nə wulə, á nə pɩ̀à, sə á swɩ̀n á púlí tə kʋ lɩ̀à tə nə bʋ̀rɩ̀ bʋ̀rà tə nə mɛ, sə kʋ lɩ kʋ yoo təntə yáá. ");
INSERT INTO nnw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kʋ nə tà nətʋ, nə wá bà, nə tì talɩ yoo kʋ tə nətən yɩrɩ kʋ nə fwa zə̀n. Cɩ́gá mama tə̀lə́ yoo kʋ tə wa, nə nə wàá nə bɩrɩ də, kʋ mʋ̀ nə pɩn, nə mɛ, sə nə kun duən nə, nə fwa jara». ");
INSERT INTO nnw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sekəretɛrə tə nə swɩ̀n nətʋ ʋ zwɛ̀e, ʋ pɩn nii, sə lalʋʋ tə vìí. ");
INSERT INTO nnw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Máŋá tə wa, gugurə tə nə zwɛ̀e Efɛzə wa, Polə bon Zwezi karbɩa tə, ʋ kə ʋ con. Ʋ nə kwè ba ʋ zwɛ̀e, kwa nə, ʋ lòrì cwəŋə ba con, ʋ ga zàn, ʋ zʋ cwəŋə, ʋ ma vəli Masedwanə nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Polə twá kʋ lʋʋ níə́ təntə wa, ʋ lɛ də ʋ pɩn kwìə̀ zənzən lɩ̀à tə nə. Ʋ nə lɛ lá nə, ʋ vəli Gərɛsə lʋʋ nii tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ʋ fwa cànɩ̀ batwa lá nə, yá ʋ dàń yà ken ʋ sírí, sə ʋ tì nɩ́á yuu bori ʋ va Siri nagwanaa con. *Zwifə-ba yáá tɩ̀án nə yà ken tɩjaŋa ba ja zɩga ʋ nə. Kʋ mʋ̀ nə pɩn, Polə pìí ʋ kə ʋ pubʋŋa wa, sə ʋ pìí ʋ va Masedwanə nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Lɩ̀à tə, ba yà nə kwé wá, nə yɩ Sopatɛrə, ʋ nə yɩ Pirisə bìú, ʋ tɩʋ nə yɩ Bere. Ba duən də nə yɩ Arisətarəkə də Sekondisə, ba nə yɩ Tɛsalonikə tɩ̀án, də Gayisə ʋ nə yɩ Dɛrəbe tíú, də Timote, kʋ súrí Tiswikə, də Tərofimə nə, ba nə yɩ Azi nagwanaa lɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ba mʋ̀ lɩ̀à təntə dí yáá ba va, ba dɩ̀àn nəba Tərowasə nə. ");
INSERT INTO nnw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nə tətə zʋa nɩ́á yuu bori Filipə nə, cànà tə, ba nə də́ də dipɛn tə, kʋ nə ba sabwarɩ kəni tə nə lɛ, kwa nə. Yá nə dɩan bonu nii nə, nə vəli nə yí ba Tərowasə nə. Nə fwa dɩan barpɛ lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dapanɩ tə təntən dɩɩn tə nə, nə kun duən nə, sə nə mumuni *nimarʋ dipɛn tə, nə də́. Polə dàń yà mɛ, sə ʋ vìí kʋ tɩpʋrɩ nə. Kʋ mʋ̀ nə pɩn, ʋ dàń yà wulə, ʋ ve də lɩ̀à tə, ba nə wulə lá. Ʋ ve ʋ viə tə kʋ dánɩ́ kʋ yí tɩtɩn lugu fugə bələ. ");
INSERT INTO nnw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Cànán yà yɩn dánɩ́ dəyuu dìə̀ tə wa, nə yà nə wulə kʋ wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Yə̀ə́ balandʋrʋ don, ʋ yɩrɩ nə yɩ Etikisə, yà jə̀ə́ təkurə nəfarʋ nii nə. Dwan zàn tə tì wá lɩgɩ, máŋá tə wa, Polə nə tə wulə ʋ viə tə wa. Dwan tə lɩ wá dəyuu dii batwa nii nə, ʋ bà ʋ tʋ tɩa. Ba twi ba zɩ̀n wá, də ʋ tɩga. ");
INSERT INTO nnw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Polə dàń cuə, ʋ kwá ʋ yuu con, ʋ tì wá, ʋ kə ʋ vànà wa, ʋ ga swɩ̀n, ʋ wʋ́: «Á dànà ká pa á pwìí cʋ̀gʋ̀, ʋ mɩɩ tə wulə, ʋ tə wà tɩ». ");
INSERT INTO nnw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Máŋá tə wa, ʋ nə pìí ʋ dɩ̀ dəyuu dìə̀ tə wa, ʋ mumuni dipɛn tə, ʋ ga fʋ ʋ də́. Kʋ kwa nə, ʋ tə pìí ʋ swɩ̀n kʋ dánɩ́ wuuu, kʋ va kʋ yí tɩbɩlakʋnʋ. Kʋ máŋá təntə wa nə, ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ba ja balandʋrʋ tə, ba pìí ba bà də ʋ wulə mɩɩ wa, yá kʋ dàń yɩn jɩdarɩ zənzən kʋ pa ba. ");
INSERT INTO nnw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nə mʋ̀ nə dí yáá, nə zʋ nɩ́á yuu bori tə wa. Yá kʋ dàń tì nəba, kʋ ja va Asosə bwálɩ́ tə nə, nɩ́á yuu bwərə tə nə zɩga lá. Mə kʋ bwálɩ́ təntə wa nə, nə wá tì Polə nɩ́á tə nii nə. Mə nətʋ nə ʋ yà swɩ̀n, ʋ tún də ʋ pɩ̀à, sə ʋ va kʋ bwálɩ́ tə nə də nɛɛ. ");
INSERT INTO nnw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Máŋá tə, ʋ nə twi ʋ yí Asosə nə, nə tì wá nɩ́á tə nii nə, yá nə ga lɛ nə va Mitilɛnə. ");
INSERT INTO nnw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nə kʋ́ʋ̀ zɩgɩ lá nə, nə vìí də nɩ́á yuu bori tə mʋʋ tə yuu wa. Kʋ tɩpʋrɩ nə, nə yí Swio nagwanaa tə vàn nə. Dɩɩn tə, kʋ nə daa lá, nə lɛ nə yí Samosə nagwanaa tə. Nə nə yí Samosə tɩpʋrɩ nə, nə lɛ nə yí Mile. ");
INSERT INTO nnw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Polə yà ken sírí, sə ʋ twá Efɛzə nii nə, ʋ lɛ, sə ʋ dàn ká cʋ̀gʋ̀ ʋ máŋá Azi nagwanaa tə wa. Ʋ yà yɩ ʋ bɩbarɩ də kʋ nə wàá, sə ʋ ya *Zwerizalɛmə nə *Zwifə-ba cànà tə, ba nə boŋə *Pantəkɔtə tə dɩɩn nə. ");
INSERT INTO nnw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kʋ máŋá təntə wa nə, Polə zɩgɩ Mile nə, ʋ tʋn Efɛzə *Kərisə lɩ̀à púlí *nəkwɩna tə nə, sə ba bà. ");
INSERT INTO nnw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Máŋá tə, ba nə twi ba yí ʋ nii, ʋ swɩ̀n ba con, ʋ wʋ́: «Á yə̀ə́ nətʋ, à nə yɩn á tətəŋi wa, kʋ jɩjʋ dɩɩn tə nə, à nə dɩ̀gà à naa Azi nagwanaa wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","À cuə à tɩ̀àn mɩ́ámɩ́án, à ma tʋn à pa *Yuu-Tiu nə də yinɩa *Zwifə-ba càn tə wa, ba nə yà kəni à nə. ");
INSERT INTO nnw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Á yə̀ə́ də, à wà aba won mama sə̀gə̀. À yàá swɩ̀n tə à bɩrɩ aba də, à kàrɩ̀ aba won tə mama, kʋ nə jə funə kʋ pa aba, kanporu tə wa, də dii tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","À swɩ̀n Zwifə-ba con də *Gərɛkə-ba con, sə ba vəvəri kwa, ba ma sá ba cʋna, sə ba kə ba waa Yuu-Tiu Zwezi nə. ");
INSERT INTO nnw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yá sɩ́ʋ́n nə, Yɩɩ-*Siŋu tə kálɩ́ nə kʋ pa, à vəli *Zwerizalɛmə, à ga yə̀rì won tə, kʋ nə wá yí nə lá. ");
INSERT INTO nnw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","À dàń nə yə̀ə́ yoo nədʋ. Tɩfarʋ mama wa nə, Yɩɩ-Siŋu tə yàá swɩ̀n à con də, bàń dìə̀ zʋrɩ, də càn nə dànɩ̀ nə. ");
INSERT INTO nnw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yá à mɩɩ tə yoo ba nə jə kʋ nədʋ mama wa, sə kʋ dàn ká ya, ndə à mɩɩ tə jə funə kʋ pa nə. À mʋ̀ yoo nə yɩ, sə à wànɩ́ à yí à vəli tə yígúrə́, sə à wànɩ́ à tʋn Yuu-Tiu Zwezi tʋtʋŋɩ tə, ʋ nə pɩn nə, sə kʋ nii sú. Sə à swɩ̀n sʋywáŋʋ́ tə à bɩrɩ də, Yɩɩ jə pubwanʋ. ");
INSERT INTO nnw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Yá sɩ́ʋ́n nə á nəŋə, à yə̀ə́ də, á kʋ́ʋ̀ ba pìí á na à yáá. Á mʋ̀ lɩ̀à tə mama, à nə twá á tətəŋi wa, à ga swɩ̀n də, Yɩɩ wá də́ ʋ pàrɩ̀ tə. ");
INSERT INTO nnw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kʋ mʋ̀ nə pɩn, à swɩ̀n kʋ á con zə̀n. Á lìù mama talɩ tə̀lə́ à yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","À wà aba sə̀gə̀ won mama wa. À swɩ̀n kʋ tə mama, kʋ nə yɩ Yɩɩ puswənə tə, à bɩrɩ aba. ");
INSERT INTO nnw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Á dàń cɩa á tətə nə də Kərisə lɩ̀à púlí tə mama nə. Yɩɩ-Siŋu tə nə tún aba púlí təntə yuu wa, sə á ya kʋ cɩ̀rá, á cɩ̀ kʋ nə. Kʋ twá ʋ tətə bìú tə tɩan tə nə, Kərisə lɩ̀à púlí təntə ma yɩ ʋ mʋ̀ nyiən. ");
INSERT INTO nnw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","À yə̀ə́ də lɩ̀à, ba nə yɩ ndə buyurən nyankwɩn nə, wá zʋ á tətəŋi wa, à kwa nə, ba nə bá yá Kərisə lɩ̀à púlí tə. ");
INSERT INTO nnw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Yá á tətə wa, bara wá ya lá nə, ba nə wá zàn ba swɩ̀n kʋnkʋn sʋ̀ràn, sə ba ma van Zwezi karbɩa tə, ba kə ba con. ");
INSERT INTO nnw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kʋ mʋ̀ nə pɩn, á mɛ, sə á cɩ̀ kʋ nə, sə á lìí á tɩ̀àn, də à fwa bɩna batwa tɩtɩn də yɩcaʋ, à ma dí yáá à swɩ̀n á lìù mama con də yinɩa à tuŋə lá. ");
INSERT INTO nnw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Yá sɩ́ʋ́n nə, à pɩn aba Yɩɩ nə, sə ʋ twá ʋ sʋgʋ tə nə, kʋ nə jə dɩ̀àn, kʋ ga bɩrɩ ʋ pubwanʋ tə, ʋ ma kwè aba. Sʋgʋ təntə nə wá pa tori lɩ̀à tə mama nə, ba nə ya Yɩɩ cɩcɩ nə tɩ. ");
INSERT INTO nnw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","À wà lɩ̀à səbiu nə à yə̀ə́ ganan pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Á yə̀ə́ də, kʋ wà nətʋ yɩn. Á nɩ də, à tətə jɩ̀àn nə tʋn tə pa nə, à mʋ̀ də à twaduən tə won mama wa. ");
INSERT INTO nnw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Won mama wa, à bɩrɩ aba də, kʋ mɛ, sə á tʋn, sə á wànɩ́ á san lɩ̀à tə, ba nə ba dɩ̀àn jə nə. Á lie Yuu-Tiu Zwezi sʋ̀ràn tə, ʋ tətə nə swɩ̀n, ʋ wʋ́: ‹N nə pɩn won lìù nə, kʋ jə pupwən kʋ doni, lìù nə pɩn mʋ́ won›.» ");
INSERT INTO nnw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ʋ nə swɩ̀n nətʋ, ʋ tòlì ʋ nadwana yuu, sə ʋ jʋn Yɩɩ də ba mama. ");
INSERT INTO nnw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ba mama tə dàń kwi zənzən, ba ga vwa Polə bɩan nə, ba pùrí wá ba kə ba nyʋnɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pucʋnɩ yà zʋa ba, ʋ nə swɩ̀n ba con də, ba kʋ́ʋ̀ ba pìí ba na ʋ yáá tə yɩrɩ. Kʋ kwa nə, ba kwé wá ba ja va, ba yí nɩ́á yuu bori tə. ");
INSERT INTO nnw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nə mʋ̀ də ba dʋgʋ duən. Kʋ kwa nə, nə zʋa nɩ́á yuu bori nə va mʋʋ tətəŋi Kosə nagwanaa mənə mənə. Kʋ tɩa nə pʋrɩ, nə vəli Rodə mʋʋ tətəŋi nagwanaa tə wa, nə zɩgɩ lá, nə va Patara. ");
INSERT INTO nnw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nə dàń nɩ nɩ́á yuu bori, də kʋ pɩ̀à kʋ bɛn kʋ va Fenisi nagwanaa con. Nə vəli nə zʋ kʋ wa, sə nə kwɛn nə va yɩŋʋnɩ. ");
INSERT INTO nnw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Máŋá tə, nə yɩ́á nə na Swipərə mʋʋ tətəŋi nagwanaa, nə ken kʋ nə jɩgwiə con. Nɩ́á yuu bori tə ga ja nəba, kʋ vəli Siri nagwanaa con, sə nə va nə cú Tirə nə. Mə bwálɩ́ təntə wa nə, nɩ́á yuu bori tə mɛ, sə kʋ cú kʋ zɩla tə. ");
INSERT INTO nnw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nə vəli nə na Zwezi karbɩa tə, nə fwa dɩan barpɛ lá nə. Yɩɩ-*Siŋu tə yigu ba, ba ga swɩ̀n Polə con, ʋ dàn ká va *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Dɩan təntə dàń nə lɛ tə zwɛ̀e, ba mama də ba kana, də ba bɩa kwé nəba, nə va wuuu, nə va nə lɛ tɩfarʋ tə nii. Nə dàń tòlì nə nadwana yuu nə bəbəru tə nii nə, sə nə jʋn Yɩɩ. ");
INSERT INTO nnw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kʋ kwa nə, nə mʋ̀ də ba mʋ̀ dʋgʋ duən, nə ga zʋ nɩ́á yuu bori tə. Yá ba də ga pìí, ba va ba bwálɩ́ nə. ");
INSERT INTO nnw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nɩ́á yuu bori tə ja nəba kʋ nan Tirə, kʋ va Pətolemayisə. Nə jʋn lɩ̀à tə, ba nə yɩ nə nubɩa *Kərisə yɩrɩ, ba nə wulə lá nə, nə ga fwa dɩɩn nədʋ ba con. ");
INSERT INTO nnw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kʋ tɩpʋrɩ nə, nə zàn nə va nə yí Sezare nə. Nə vəli nə zʋ Filipə dìə̀ wa, nə ya lá nə. Ʋ də yɩ sʋywáŋʋ́ tə *sʋ̀sʋ̀nʋ̀. Filipə təntə yà yɩ lɩ̀à barpɛ tə, ba nə san *tʋntʋna tə nə, wa lìù don. ");
INSERT INTO nnw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ʋ yà jə bwɩ̀ɩ́ banɩa, ba tə nə yə̀rì bɛɛ. Ʋ bwɩ̀ɩ́ banɩa təntə yà joŋə Yɩɩ nii sʋ̀ràn, ba swɩ̀n. ");
INSERT INTO nnw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nə dàń nə yɩn lá nə, dɩan tə pùlì, Yɩɩ nii sʋ̀sʋ̀nʋ̀ don, ʋ yɩrɩ nə yɩ Agabisə, nan Zwide nagwanaa tə wa, ʋ bà nə con. ");
INSERT INTO nnw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ʋ tì Polə voru, ʋ ma vwə ʋ tətə nɛɛ də ʋ jɩ̀àn, ʋ ga swɩ̀n, ʋ wʋ́: «Á nəŋə kʋ tə, Yɩɩ-Siŋu tə nə swɩ̀n: ‹Bɛɛ tə, voru kʋ tə nə yɩ ʋ mʋ̀ nyiən, *Zwifə-ba wá vwa wá nətʋ Zwerizalɛmə nə. Yá ba ga wá ja wá, ba kə lɩ̀à tə, ba nə tà Zwifə-ba tə jɩ̀àn wa›.» ");
INSERT INTO nnw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nə nə nì tə sʋ̀ràn tə kwa nə, nə mʋ̀ də bwálɩ́ tə tɩ̀án mɛ san duən nə, nə lòrì Polə, sə ʋ dàn ká va Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Polə dàń ma le, ʋ wʋ́: «Bɛ̀eɛ̀e nə pɩn, á kwi á ma cʋ̀gà à pùə́ nə? À mʋ̀ ken à sírí də kʋ yoo təntə, sə ba vwa nə. Kʋ tà kʋ cɩcɩ, sə à tɩ Zwerizalɛmə nə *Yuu-Tiu Zwezi yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nə nɩ də, ʋ bá sɛ̀e, ʋ pa nə swɩ̀n wá nə dɩ̀, nə kʋ́ʋ̀ wà kʋ nə jɩn kan kan. Nə dàń swɩ̀n, nə wʋ́: «Yuu-Tiu nə wá tʋn ʋ fɩra». ");
INSERT INTO nnw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tə dɩan təntə kwa nə, nə ken nə zɩla, nə ga va *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Zwezi karbɩa duən də twá nə nə, ba nan Sezare ba bà. Yá ba yɩn nə yáá, ba ja va bɛɛ don sàń, ʋ yɩrɩ nə yɩ Mənason. Ʋ yɩ Zwezi karbidwarʋ fuən fuən, ʋ ga yɩ Swipərə tíú. Ʋ mʋ̀ dìə̀ nə nə mɛ, sə nə zʋrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nə nə vəli nə yí Zwerizalɛmə nə, lɩ̀à tə, ba nə yɩ nə nubɩa *Kərisə yɩrɩ, sɛ̀e nəba də pupwən. ");
INSERT INTO nnw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kʋ tɩpʋrɩ nə, nə mʋ̀ də Polə mɛ vəli Zwakə sàń. Yá Kərisə lɩ̀à púlí tə *nəkwɩna tə, də mama twi lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Polə nə jʋn ba ʋ zwɛ̀e, ʋ dàń wulə ʋ tori yìə̀n tə nədʋ nədʋ, Yɩɩ nə twá də ʋ tʋtʋŋɩ tə nə, ʋ fwa lɩ̀à tə, ba nə tà *Zwifə-ba tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ba nə cʋgʋ wá ba zwɛ̀e, ba bʋ̀à Yɩɩ nə. Yá ba dàń swɩ̀n ʋ con, ba wʋ́: «À nubiu, n na Zwifə-ba mʋ̀rʋ̀ dəkurən fugə fugə nə ken ba waa Zwezi nə. Yá ba mama ga jə yawala Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, yoo wa. ");
INSERT INTO nnw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Sɩ́ʋ́n nə, ba swɩ̀n n yoo ba con, də n kàrɩ̀ Zwifə-ba mama, ba nə wulə lɩ̀à tə, ba nə tà Zwifə-ba tətəŋi wa, sə ba vəvəri, ba yá Yɩɩ nii tə, ʋ nə pɩn Moyizə nə. Kʋ mʋ̀ nə yɩ sʋgʋ tə, n nə swɩ̀n ba con, n wʋ́, ba dàn ká *gwəŋə ba bisɩmabarɩ, ba dàn ká twá Zwifə-ba yofwamɩnan tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nə dàń wá fwa bɛ̀eɛ̀e? Nə zán nə yə̀ə́ də, kʋ ba tʋ́tʋ̀ná jə, lalʋʋ tə wá kun duən nə, ba wá lwarɩ də, n twi. ");
INSERT INTO nnw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kʋ mʋ̀ yɩrɩ nə, fwa kʋ tə, nə nə wá swɩ̀n n con. Bara banɩa wulə nə tətəŋi wa, ba nə fwa Yɩɩ lɛ̀eɛ̀e kənu yɩlori. ");
INSERT INTO nnw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ja ba n kə n con, sə n mʋ̀ də ba tanɩ á tɩ̀àn kʋ Yɩɩ lɛ̀eɛ̀e kənu yɩlori tə wa. Yá n ga tì kʋ jɩŋɩ tə n zɩn, sə ba ma fɩna ba yun tə. Lɩ̀à tə mama dàń wá lwarɩ də, cɩ́gá tə̀lə́ kʋ tə wa, ba nə swɩ̀n ba pa mʋ́. Yá ba wá lwarɩ də, n tətə yɩ n twá Yɩɩ nii tə, ʋ nə pɩn Moyizə nə, n ma vəli. ");
INSERT INTO nnw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kʋ nə yɩ lɩ̀à tə, ba nə tà Zwifə-ba tə, ba nə ken ba waa Zwezi nə yoo, nə bʋ́n nə na də kʋ mɛ, sə nə pʋ́pʋ́nɩ́ nə pa ba. Nə swɩ̀n ba con, sə ba cɩ̀ ba tɩ̀àn nə də nàŋʋ́, ba nə gʋa woŋwanan nə, ba dàn ká də́ jana, ba dàn ká də́ wotɩgʋ nàŋʋ́, sə ba dàn ká cwàrɩ̀ də duən də». ");
INSERT INTO nnw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kʋ tɩpʋrɩ nə, Polə jɩn bara təntə, ʋ kə ʋ con. Ʋ mʋ̀ də ba mɛ dàń ga tanɩ ba tɩ̀àn kʋ Yɩɩ lɛ̀eɛ̀e kənu yɩlori tə wa. Kʋ kwa nə, ʋ zʋa Zwifə-ba Yɩɩ *dìə̀ tə wa, ʋ swɩ̀n ʋ bɩrɩ dɩɩn tə, ba yɩlori tə, ba nə tanɩ, tə nə wá zwɛ̀e. Ʋ ga bɩrɩ dɩɩn tə, də *joŋi won tə, ba nə wá pa Yɩɩ nə ba lìù mama yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Máŋá tə nə, dɩan barpɛ tə nə bwələ, sə tə zwɛ̀e, Azi nagwanaa *Zwifə-ba tə nɩ Polə Yɩɩ *dìə̀ tə wa. Ba sugu lalʋʋ tə ba kə ʋ nə, ba ma ja wá. ");
INSERT INTO nnw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ba dàń ga bubwi, ba wʋ́: «*Yɩzərayɛlə bara-ba, á bɩ̀àn á san nəba. Á nəŋə bɛɛ tə, ʋ nə kàrɩ̀ bwálá tə mama, lɩ̀à tə mama con, ʋ ma zɩga nə lʋʋ lɩ̀à tə, də Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, də Yɩɩ dìə̀ kʋ tə nə. Ʋ bɩlɩ ʋ jə *Gərɛkə-ba lɩ̀à duən, ʋ zʋ Yɩɩ dìə̀ tə wa, ʋ ma cʋ̀gʋ̀ kʋ ʋ kə durən kʋ bwálɩ́ təntə wa, kʋ nə yɩ Yɩɩ cɩcɩ nə tɩ». ");
INSERT INTO nnw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Máŋá don wa, ba nɩ Polə də Efɛzə tɩ̀án bɛɛ don, ʋ yɩrɩ nə yɩ Tərofimə tɩʋ tə wa. Yá ba dàń yà bʋŋa də, Polə pɩn ʋ zʋ Yɩɩ dìə̀ tə wa. Kʋ mʋ̀ nə pɩn, ba swɩ̀n nətʋ. ");
INSERT INTO nnw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tɩʋ tə mama sʋsʋgʋ, lalʋʋ ga dəri kʋ naŋa bwálɩ́ mama kʋ twi. Ba jɩn Polə, ba tətəli wá, ba jə nan Yɩɩ dìə̀ tə wa, ba ga pɩn ka mimiən lala. ");
INSERT INTO nnw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Polə dàń yà yɩ ba pɩ̀à, sə ba gʋ. Pamana yuu tíú don ma nì də gugurə zʋa *Zwerizalɛmə mama wa. ");
INSERT INTO nnw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kʋ máŋá tə tətə wa, ʋ nə nì kʋ, ʋ zàn ʋ lɩ pamana də lɩ̀à, ba də nə cɩ̀ ʋ ja dəri, ʋ va ba con. Máŋá tə, ba nə nɩ pamana yuu tíú tə də pamana tə, ba yá Polə maran tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Pamana yuu tíú tə dàń ma bà, ʋ yí lá nə ʋ pùrì Polə, ʋ ga pa nii, sə ba vwa wá də banzala bələ. Kʋ kwa nə, ʋ bwe Polə, sə ʋ na lìù tə, ʋ nə yɩ, də won tə, ʋ nə fwa. ");
INSERT INTO nnw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Lalʋʋ tə tətəŋi wa nə, lɩ̀à duən yà bubwi yiri don, ba duən də bubwi yiri don. Zəzugu tə dàń pɩn ʋ wàrɩ̀ cɩ́gá yoo mama ʋ nì. Kʋ mʋ̀ yɩrɩ nə ʋ pɩn nii, sə ba ja Polə ba va pamana sàń tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Máŋá tə Polə nə dɩ̀gà nətənə tə yuu, kʋ yɩ pamana tə ga ba tì wá, ba zɩn lalʋʋ tə tutugu tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yá tɩʋ tə ləzwənbɩa tə yà tə púə́ ʋ kwa, ba bubwi, ba wʋ́: «Á gwɩa wá!» ");
INSERT INTO nnw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Máŋá tə wa, ba nə pɩ̀à, ba kə Polə pamana sàń tə wa, ʋ swɩ̀n pamana yuu tíú tə con, ʋ wʋ́: «À jə cwəŋə, sə à swɩ̀n yoo n con, naaa?» Pamana yuu tíú tə ma le wá, ʋ wʋ́: «N nə̀ń *Gərɛkə-ba sʋgʋ naaa? ");
INSERT INTO nnw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kʋ nə yɩ nətʋ, sə mə kʋ tà n mʋ̀ nə yɩ Ezwipətə tíú tə, ʋ kanya nə sugu lɩ̀à ʋ kə *Romə-ba nə. Yá ʋ ga jə lagʋra mʋ̀rʋ̀ banɩa (4 000), də ba cəcərə sɩ̀án, ʋ ja va kasɔɔ lanworu tə wa?» ");
INSERT INTO nnw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Polə ma swɩ̀n, ʋ wʋ́: «À mʋ̀ yɩ *Zwifə, Tarəsə tíú, Silisi lʋʋ nii tə wa, kʋ tɩʋ tə yɩrɩ nan. À lòrì mʋ́, sə n pa nə cwəŋə, sə à swɩ̀n lalʋʋ tə con». ");
INSERT INTO nnw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Pamana yuu tíú tə ma pa wá nii, sə ʋ swɩ̀n. Polə dàń zàn ʋ zɩga nətənə tə yuu wa. Yá ʋ ga jə ʋ jɩɩn, ʋ ma fwa mɩmɩnʋ lalʋʋ tə yáá con. Zəzugu tə mama zwɛ̀e. Polə dàń wulə ʋ swɩ̀n lalʋʋ tə con də *Ebərə-ba sʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Polə swɩ̀n, ʋ wʋ́: «À nubɩa-ba də à nyɩna-ba! Á cʋga kʋ tə, à nə jə, sə à swɩ̀n, à ma jon à tɩ̀àn!» ");
INSERT INTO nnw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Máŋá tə, ba nì də, Polə yɩ Ebərə-ba sʋgʋ nə, ʋ ma swɩ̀n ba con, ba kʋ́ʋ̀ kwɛn ba kə sə̀gə̀ sə̀gə̀. Yá Polə dàń swɩ̀n ba con, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«À mʋ̀ yɩ Zwifə, ba lʋrɩ nə Tarəsə nə, kʋ nə wulə Silisi lʋʋ nii tə wa. Mə tɩfarʋ kʋ tə, kʋ nə yɩ Zwerizalɛmə wa, nə ba kʋnɩ nə. Gamalɩɛlə yà nə yɩ à karnyɩna, ʋ nə kàrɩ̀ nə, sə à twá Yɩɩ *nii tə, ʋ nə pɩn nə nyɩna-ba tə nə zəni zəni. À yà jə yawala zənzən də Yɩɩ nyiən tə, ndə á də mama nə yɩ nətʋ tə zə̀n kʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","À tətə fɩfɩn ba tə, ba nə wulə *Yuu-Tiu cwəŋə ka tə wa, à gʋ. À vwə bara də kana à kə bàń dìə̀. ");
INSERT INTO nnw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa tə, də *nəkwɩna tə mama yə̀ə́ kʋ tə, à nə fwa. Ba tətə pɩn nə saga, sə à bɩrɩ Zwifə-ba nubɩa tə nə, ba nə wulə Damasə nə. À vəli kʋ tɩʋ təntə də saga təntə, tə nə pɩn nii nə, sə à vwa lɩ̀à tə, ba nə zʋa Zwezi cwəŋə tə wa, à ja bà Zwerizalɛmə, sə à pa, ba kə ba càn wa. ");
INSERT INTO nnw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","À vəli cwəŋə tə wa, kʋ bà kʋ bwələ lugu fugə bələ, də à dàń yà bwələ Damasə. Kʋ máŋá tə wa, naa nədʋ də poni nəfarʋ nan yɩɩ nə. Kʋ pɩpɩlɩ kʋ kɩkarɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","À tʋa tɩa, à ga nì kori, kʋ nə swɩ̀n à con, kʋ wʋ́: ‹Solə, Solə, bɛ̀eɛ̀e nə pɩn, n ma fɩfɩn nə?› ");
INSERT INTO nnw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","À dàń ma le, à wʋ́: ‹N mʋ̀ nə yɩ wàà, Yuu-Tiu?› Ʋ ma swɩ̀n à con, ʋ wʋ́: ‹À mʋ̀ nə yɩ *Nazarɛtə Zwezi, n nə fɩfɩn.› ");
INSERT INTO nnw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Lɩ̀à tə, à mʋ̀ də ba nə twá duən tə, nɩ poni tə, yá ba nə wà lìù tə, ʋ nə swɩ̀n à con tə, kori nì. ");
INSERT INTO nnw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","À dàń ma swɩ̀n, à wʋ́: ‹Bɛ̀eɛ̀e nə à dàń mɛ̀e, sə à fwa Yuu-Tiu?› Yuu-Tiu ma swɩ̀n à con, ʋ wʋ́: ‹Zàn, n va Damasə, yá mə lá nə, ba wá swɩ̀n n con won tə mama, à nə pɩn nii, sə n fwa›. ");
INSERT INTO nnw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","À yɩ́á yà kʋ́ʋ̀ ba won mama na, poni təntə nə pɩpɩlɩ tə yɩrɩ. Lɩ̀à tə, ba nə yɩn də nə tə nə jɩn à jɩɩn nə, ba van nə, à ma va à yí Damasə. ");
INSERT INTO nnw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Bɛɛ don yɩn lá nə, ʋ yɩrɩ nə yɩ Ananɩasə. Ʋ yà zìlí Yɩɩ nii tə, ʋ nə pɩn *Moyizə nə, zəni zəni. Damasə Zwifə-ba mama yà swɩ̀n ʋ yozəŋə yoo. ");
INSERT INTO nnw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kʋ mʋ̀ bɛɛ təntə dàń twi ʋ yí nə, ʋ swɩ̀n à con, ʋ wʋ́: ‹À nubiu Solə, sə n yɩ́á tə pìí, tə na lá!› Kʋ máŋá tə tətə wa, à yɩ́á tə pórí. Yá à ga na wá. ");
INSERT INTO nnw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ʋ dàń ma swɩ̀n, ʋ wʋ́: ‹Yɩɩ tə, ʋ nə yɩ nə Zwifə-ba nɩbara-ba Yɩɩ nə tún mʋ́, sə n yəni ʋ fɩra tə, sə n na cɩ́gá tíú Zwezi, sə n nì sʋgʋ tə, ʋ tətə nii wa. ");
INSERT INTO nnw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kʋ mʋ̀ nə pɩn, n wá swɩ̀n ʋ yoo lɩ̀à tə mama yáá con. N wá bɩrɩ ba kʋ tə, n nə nɩ də kʋ tə, n nə nì tə. ");
INSERT INTO nnw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Yá sɩ́ʋ́n nə, bɛ̀eɛ̀e nə n dàń kʋ́ʋ̀ dànɩ̀? Zàn yɩɩ nə, n bon Zwezi yɩrɩ tə, sə n pa ba lə mʋ́ nɩ́á wa, sə n cʋna tə durən tə ma sɩn tə nan›.» ");
INSERT INTO nnw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Polə kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À pìí à bà *Zwerizalɛmə wa, yá à dàń yà wulə à jʋ̀nɩ̀ Yɩɩ *Zwifə-ba Yɩɩ *dìə̀ tə wa. Kʋ fwa ndə yiviru nə tì nə, Yɩɩ ga bɩrɩ nə won. ");
INSERT INTO nnw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","À nɩ *Yuu-Tiu də ʋ swɩ̀n à con, ʋ wʋ́: ‹Bɩbarɩ n bà, n lɛ n nan Zwerizalɛmə wa lala, ba bá jon n sʋ̀ràn tə, n nə swɩ̀n n bɩrɩ à yuu wa›. ");
INSERT INTO nnw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Yá à dàń swɩ̀n, à wʋ́: ‹Yuu-Tiu, ba tətə yə̀ə́ zəni də, à yà twá Zwifə-ba *jə́rə́ dii tə wa, à vəli, à ma pɩ̀à ba, sə à pa ba kə ba bàń dìə̀, də à pa ba mà lɩ̀à tə, ba nə keni ba waa n nə. ");
INSERT INTO nnw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Máŋá tə wa, ba nə gʋa n *sʋ̀sʋ̀nʋ̀ Etɩyɛnə, ʋ nə swɩ̀n n sʋgʋ tə, à tətə yɩn lá nə. À ken à nii ba kwa, à ga jon lɩ̀à tə, ba nə gʋa wá ganan, à ja tə nə›. ");
INSERT INTO nnw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ʋ dàń ma swɩ̀n à con, ʋ wʋ́: ‹Vəli, n yɩ à tʋŋa mʋ́ yɩŋʋnɩ dwíí tə, ba nə tà Zwifə-ba tə, con›.» ");
INSERT INTO nnw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lɩ̀à tə cʋgʋ wá, wuuu, kʋ va kʋ yí Polə sʋgʋ təntə yuu wa. Ba dàń zɩ̀n ba kwərə yɩɩ nə, ba ga swɩ̀n, ba wʋ́: «Á gwɩa kʋ mʋ̀ bɛɛ wà tə yiri tə! Kʋ wà mɛ, sə á yá wá á pa ʋ mɩɩ sìí lʋʋ wa!» ");
INSERT INTO nnw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ba bubwi, ba lɩ ba ganan, ba dɩlɩ, ba dʋga, ba ga pɛ̀e purən, ba mɩ́ yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Pamana yuu tíú tə pɩn nii, sə ba kə Polə pamana sàń tə wa, sə ba ga fɩrɩ wá də kafɩʋ, sə ʋ swɩ̀n won tə, kʋ nə pɩn, ba bubwi nətʋ ʋ yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Yá máŋá tə wa, ba nə vwə wá, sə ba mà, Polə swɩ̀n pamana bíí yuu tíú tə con, ʋ yà nə wulə lá, ʋ wʋ́: «N jə nii, sə n mà *Romə-ba bìú, ba nə tə wà ʋ bʋ̀rà bʋ̀rɩ̀, naaa?» ");
INSERT INTO nnw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tə sʋ̀ràn təntə pɩn, pamana bíí yuu tíú tə va ʋ tún tə nii ʋ yuu tíú tə con, ʋ wʋ́: «Bɛɛ tə yɩ Romə-ba bìú, bɛ̀eɛ̀e nə n dàń wá fwa?» ");
INSERT INTO nnw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Pamana yuu tíú tə dàń ma bà, ʋ swɩ̀n Polə con, ʋ wʋ́: «Swɩ̀n à con də, n nə yɩ Romə-ba bìú». Polə ma le wá, ʋ wʋ́: «Awo, à yɩ Romə-ba bìú». ");
INSERT INTO nnw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Pamana yuu tíú tə ma súrí lá nə, ʋ wʋ́: «À mʋ̀ yɩ səbifarʋ nə à ŋwɩ́n, sə à ma jì Romə-ba bìú». Polə də ma kʋ́ʋ̀ swɩ̀n, ʋ wʋ́: «À mʋ̀ yɩ Romə-ba nə lʋrɩ nə». ");
INSERT INTO nnw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Lala də lɩ̀à tə, ba yà nə mɛ, sə ba mà Polə ba pa, ʋ swɩ̀n tə pìí, ba kə ba kwa. Fən dàń yà zʋa pamana yuu tíú tə, də ʋ nə lwarɩ də, Polə yɩ Romə-ba bìú, ʋ nə pɩn ba vwa wá tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kʋ tɩpʋrɩ nə, ʋ nə pɩ̀à, sə ʋ lwarɩ cɩ́gá mama won tə, kʋ nə pɩn *Zwifə-ba bubwi ʋ yuu wa, ʋ pɩn ba kʋ̀rɩ̀ Polə. Ʋ dàń ga pa nii, sə Yɩɩ *joŋwana yun tɩ̀án tə də Zwifə-ba yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ *bʋ̀rà tə, bà duən yáá nə. Kʋ kwa nə, ʋ pɩn Polə cú, ʋ ga zɩgɩ wá ba tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Polə ywàń Zwifə-ba yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, ʋ ga swɩ̀n, ʋ wʋ́: «À nubɩa-ba, à mʋ̀ waa con, à wà yoo nɩ, à nə dwá kʋ wa, Yɩɩ yáá con, kʋ ja bà kʋ yí zə̀n». ");
INSERT INTO nnw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Zwifə-ba Yɩɩ joŋwana yun tɩ̀án nəkwɩa Ananɩasə pɩn nii lɩ̀à tə, ba nə bwələ Polə yɩra, sə ba mà ʋ nii tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Polə dàń ma swɩ̀n ʋ con, ʋ wʋ́: «Yɩɩ wá mà mʋ́, bə́rə́ pwə! N yɩ n jə̀ń, sə n twá də Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, n ma bʋ̀rɩ̀ à bʋ̀rà, yá n yɩ n zɩga Yɩɩ nii təntə nə, də n nə pɩn nii, sə ba mà nə». ");
INSERT INTO nnw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Lɩ̀à tə, ba nə wulə lá nə, swɩ̀n ba wʋ́: «Kʋ yɩ n twɩn Yɩɩ joŋwana yun tɩ̀án nəkwɩa tə». ");
INSERT INTO nnw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Polə ma le, ʋ wʋ́: «À nubɩa-ba, à yà yə̀rì də, kʋ yɩ Yɩɩ joŋwana yun tɩ̀án nəkwɩa. Kʋ dí yáá, kʋ swɩ̀n Yɩɩ sʋ̀ràn saga tə wa, kʋ wʋ́: ‹N wà mɛ, sə n swɩ̀n n lʋʋ nii lɩ̀à tə yáá tíú tə yolwan›.» ");
INSERT INTO nnw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Polə yà yə̀ə́ də, ba púlí tə vàn don yà yɩ *Sadɩsɩan-ba, kʋ vàn don də ga yɩ *Farɩzɩan-ba. Kʋ mʋ̀ nə pɩn, ʋ bubwi Zwifə-ba yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, yáá con, ʋ wʋ́: «À nubɩa-ba, à mʋ̀ yɩ Farɩzɩan. Farɩzɩan-ba nə lʋrɩ nə. Kʋ yɩ à nə pɩn cɩ́gá də, tɩga wàá ba bwin ba naŋa tə, nə pɩn, ba wulə ba bʋ̀rɩ̀ à bʋ̀rà». ");
INSERT INTO nnw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Polə nə swɩ̀n kʋ nətʋ tə, ʋ zwɛ̀e, tʋ́tʋ̀ná nyɩ́ tə zàn Farɩzɩan-ba də Sadɩsɩan-ba pwərə wa. Púlí tə dàń pwɛ̀e púlə́ bələ. ");
INSERT INTO nnw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadɩsɩan-ba mʋ̀ yà swɩ̀n də, tɩga ka bwin ka nan, də *malɩka, də siŋu tə̀lə́. Yá Farɩzɩan-ba də con nə, ba də wʋ́, tə wulə. ");
INSERT INTO nnw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kʋ zɩ̀n tʋ́tʋ̀ná nəfarʋ. Farɩzɩan-ba wa Yɩɩ nii *yənu tɩ̀án dàń ma zàn ba caga kʋ zənzən, ba ga swɩ̀n, ba wʋ́: «Nə ba lwanɩ yiri mama na, kʋ bɛɛ wà tə yuu wa. Kʋ wàá kʋ yanɩ siŋu, nə à yə̀ə́ malɩka nə, swɩ̀n ʋ con». ");
INSERT INTO nnw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tʋ́tʋ̀ná tə dàń nə súrí zənzən tə, kʋ pɩn fən zʋ pamana yuu tíú tə. Ʋ yà bʋŋa də, ba wá za Polə, ba pwɛ̀e kɩkaran ba tətəŋi wa. Kʋ mʋ̀ nə pɩn, ʋ ma pa nii ʋ pamana púlí nə, sə ba lɩ Polə ba tətəŋi wa, ba ja va pamana sàń tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kʋ tɩa tə nə yì, *Yuu-Tiu twi Polə con, ʋ ga swɩ̀n, ʋ wʋ́: «Pa n jɩɩn dàn! Nətʋ tə, n nə swɩ̀n à yoo n bɩrɩ *Zwerizalɛmə nə, kʋ mɛ, sə n tə swɩ̀n à yoo *Romə də wa». ");
INSERT INTO nnw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kʋ tɩa tə nə pʋrɩ, *Zwifə-ba duən ken tɩjaŋa. Ba dùə̀ ba kə ba tɩ̀àn nə, ba ga kə ba sírí, də ba bá də́ wodiu, ba bá nyʋ mama, kʋ ja vəli máŋá tə, ba nə wá gʋ Polə. ");
INSERT INTO nnw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Lɩ̀à tə, ba yà nə fwa kʋ tɩjaŋa təntə yà dwə lɩ̀à sapwilə. ");
INSERT INTO nnw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ba vəli ba yí *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də Zwifə-ba *nəkwɩna tə, ba swɩ̀n ba con, ba wʋ́: «Nə mʋ̀ dùə̀ nə kə nə tɩ̀àn nə, nə ken nə sírí, sə nə dàn ká də́ wodiu, də nə nə wà Polə gwɩ. ");
INSERT INTO nnw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Á mʋ̀ də nə yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ *bʋ̀rà tə, dàń kəni nimarʋ, sə á va á yí pamana yuu tíú tə. Á dàń wá swɩ̀n ʋ con, sə ʋ ja Polə, ʋ bà á yáá con, sə kʋ ya ndə á pɩ̀à, sə á kwɛn á balɩ ʋ yoo tə cɩ́gá cɩ́gá. Nə mʋ̀ ken nə sírí, sə nə gʋ Polə, də ʋ tə wà aba yí». ");
INSERT INTO nnw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Polə nakwabiu nì kʋ tɩjaŋa sʋ̀ràn təntə. Yá ʋ zàn, ʋ va ʋ zʋ pamana sàń tə wa, sə ʋ swɩ̀n Polə con. ");
INSERT INTO nnw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Polə ma bon pamana bíí yuu tíú tə don, ʋ swɩ̀n ʋ con, ʋ wʋ́: «Ja balandʋrʋ wà tə, n va pamana yuu tíú tə con, ʋ jə yoo ʋ pɩ̀à, sə ʋ swɩ̀n ʋ bɩrɩ wá». ");
INSERT INTO nnw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Pamana bíí yuu tíú tə jɩn wá, ʋ ja va ʋ yuu tíú tə con, ʋ ga swɩ̀n, ʋ wʋ́: «Polə, ʋ nə wulə bàń dìə̀ tə wa, nə bon nə, ʋ ga lòrì nə, sə à ja balandʋrʋ wà tə, à bà n con. Ʋ wʋ́ ʋ jə yoo, ʋ pɩ̀à, sə ʋ swɩ̀n ʋ bɩrɩ mʋ́». ");
INSERT INTO nnw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Pamana yuu tíú tə ma ja ʋ jɩɩn nə, ʋ ga ja wá, ʋ nan kwa. Ʋ dàń ma bwe wá, ʋ wʋ́: «Bɛ̀eɛ̀e yoo nə, n jə n pɩ̀à, sə n swɩ̀n n bɩrɩ nə?» ");
INSERT INTO nnw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ʋ ma le wá, ʋ wʋ́: «Zwifə-ba ken nimarʋ, sə ba lòrì mʋ́, sə n jwɩan ja Polə, n ja bà ba yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə yáá con, sə kʋ ya, ndə ba pɩ̀à ba kwɛn ba balɩ ʋ yoo tə zəni. ");
INSERT INTO nnw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Dàn ká cʋgʋ ba lòrì tə. Ba wa lɩ̀à dwə sapwilə ba nə tanɩ, sə ba sə̀gə̀ ba gʋ Polə. Kʋ tɩ̀án tə dùə̀ ba kə ba tɩ̀àn nə, ba dàn ká də́ wodiu mama, ba dàn ká nyʋ nɩ́á, də ba nə wà Polə gwɩ. Ba ken ba sírí ba zwɛ̀e, sɩ́ʋ́n nə, kʋ dàń yɩ ba dànɩ̀, sə n sɛ̀e kʋ yoo təntə». ");
INSERT INTO nnw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Pamana yuu tíú tə ma swɩ̀n ʋ con, sə ʋ dàn ká swɩ̀n kʋ yoo təntə, ʋ bɩrɩ lìù don. Kʋ kwa nə, ʋ pɩn wá cwəŋə, sə ʋ vìí. ");
INSERT INTO nnw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kʋ kwa nə, pamana yuu tíú tə bon pamana bíí yun tɩ̀án bələ, ʋ swɩ̀n ba con, ʋ wʋ́: «Á tana pamana biələ (200), də sɩsadɩra sapwɩtwa də fugə, də pamana biələ (200), ba nə wá tì cwiən, sə tɩtɩn lugu nʋgʋ máŋá wa, sə ba va Sezare. ");
INSERT INTO nnw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Á tana vàná tə, á nə wá dɩ̀ tə yuu, sə kʋ pa á wànɩ́ Polə á ja va á pa yáá tíú Felikəsə nə, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, də yazurə». ");
INSERT INTO nnw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Pamana yuu tíú tə pʋ́pʋ́nɩ́ sagɩ kʋ tə, ʋ pa ba: ");
INSERT INTO nnw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«À mʋ̀ Kəlodə Lɩsɩasə nə pʋ́pʋ́nɩ́ à yáá tíú nəzəŋu Felikəsə nə. À jʋ̀nɩ̀ mʋ́. ");
INSERT INTO nnw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bɛɛ wà tə yɩ *Zwifə-ba yà nə jɩn wá, sə ba gʋ. Kʋ máŋá tə wa, à nì də, ʋ yɩ *Romə-ba bìú, à dàń ma ja pamana púlí à ja va à ma jon wá ba tətəŋi wa. ");
INSERT INTO nnw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","À yà pɩ̀à, sə à lwarɩ won tə yɩrɩ, ba nə zɩga ʋ nə. À ja wá à va ba yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ *bʋ̀rà tə yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","À nɩ də, ba nə zɩga ʋ nə, kʋ ya yìə̀n tʋ́tʋ̀ná yuu wa, tə nə wulə ba tətə Yɩɩ *nii tə wa, ʋ nə pɩn *Moyizə nə. Yá kʋ mʋ̀ təntə kwa nə, won don mama tə̀lə́, kʋ nə bɩrɩ də, ʋ mɛ gʋrɩ, kʋ nə bɩrɩ də, ʋ mɛ, sə ba vwa wá də banzala. ");
INSERT INTO nnw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","À nì də, ba ken nii nədʋ, sə ba ma gʋ kʋ bɛɛ wà tə. Kʋ mʋ̀ nə pɩn, à də kʋ́ʋ̀ pɩn wá mʋ́ lala. À pɩn nii ʋ jara duən tə nə, sə ba bà ba bon wá n yáá con kʋ yoo tə yɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Pamana tə jon ba yuu tíú tə nii, ba ga tì Polə tɩtɩn nə, ba ja va ba yí Antipatərisə. ");
INSERT INTO nnw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kʋ tɩa tə nə pʋrɩ, ba tə, ba nə vəli də nɛɛ tə pìí ba bà pamana sàń tə wa, ba ga yá sɩsadɩra tə, sə ba ja Polə ba yí Sezare. ");
INSERT INTO nnw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ba nə vəli ba yí lá, sɩsadɩra tə pɩn sagɩ tə yáá tíú, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún tə nə, ba ga tì Polə, ba pa wá. ");
INSERT INTO nnw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Yáá tíú tə nə kàrɩ̀ sagɩ tə ʋ zwɛ̀e, ʋ bwe, sə ʋ jə́n Polə yɩ lʋʋ nii kʋ kwa lìù. Ʋ nə nì də, ʋ yɩ Silisi lʋʋ nii tə wa lìù, ");
INSERT INTO nnw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ʋ dàń ma swɩ̀n, ʋ wʋ́: «À wá dɩ̀àn mʋ́, də n jarɩ duən tə nə twi, ba yí máŋá tə wa». Ʋ ga pa nii, sə ba kə wá pɩ̀ʋ́ *Erodə sàń tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Dɩan bonu kwa nə, *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án nəkwɩa Ananɩasə də ba *nəkwɩna tə duən, də bɛɛ don, ʋ yɩrɩ nə yɩ Tɛrətilə, vəli Sezare. Tɛrətilə nə yɩ ba jɩrɩmʋ lìù, ʋ nə pɩ̀à, sə ʋ tún ba nii, sə ba na cɩ́gá. Ba vəli ba bon Polə yáá tíú Felikəsə con, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, sə ba bɩrɩ won tə, ʋ nə cʋ̀gʋ̀. ");
INSERT INTO nnw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Yáá tíú Felikəsə pɩn, ba bon Polə. Yá Tɛrətilə dàń wulə ʋ bɩrɩ wiən tə mama, Polə nə cʋ̀gʋ̀. Ʋ swɩ̀n, ʋ wʋ́: «À nyɩna yáá tíú nəzəŋu Felikəsə, n mʋ̀ nə pɩn, nə jə sìə́ zənzən, kʋ twá də lwanʋ tə, n nə lwàń nə lʋʋ tə wa. Kʋ tə mama, n nə fwa dɩɩn mama, bwálɩ́ mama wa, nə mʋ̀ sɛ̀e kʋ də zìlə́ zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","À ba pɩ̀à, sə nə ja n bɩan nə, nə doni nətʋ. À lòrì mʋ́, sə n cʋgʋ nəba, máŋá mancɩn wa də n wʋywaŋʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nə nɩ də, bɛɛ wà tə yɩ tɩcʋnʋ, ʋ kəni tʋ́tʋ̀ná Zwifə-ba mama pwərə wa, lʋʋ tə mama wa. Ʋ yɩ *Nazarɛtə Zwezi kʋnkʋn yɩjʋncwəŋə tə yáá tíú. ");
INSERT INTO nnw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ʋ də́də́n, sə ʋ cʋ̀gʋ̀ nə mʋ̀ Zwifə-ba Yɩɩ *dìə̀ tə, ʋ kə durən ka nə. Nə ma ja wá, nə yà pɩ̀à, sə nə twá də nə Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, nə ma bʋ̀rɩ̀ ʋ bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Yá pamana yuu tíú Lɩsɩasə dàń twi də dɩ̀àn tə nə dáá, ʋ ma jon wá nə jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ʋ mʋ̀ pamana yuu tíú tə dàń nə pɩn nii ʋ jarɩ duən tə nə, sə ba bà n mʋ̀ yáá tíú Felikəsə con. N də kʋ́ʋ̀ wá bwe wá, sə n lwarɩ won tə mama, kʋ nə pɩn nə zɩga ʋ nə». ");
INSERT INTO nnw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Zwifə-ba ken ba nii tə sʋ̀ràn təntə kwa, ba ga swɩ̀n də, kʋ yɩ nətʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Yáá tíú Felikəsə dàń ma fwa mɩmɩnʋ də Polə, sə ʋ də tún ʋ nii. Polə də kʋ́ʋ̀ wulə ʋ tuŋə ʋ nii, ʋ wʋ́: «À yə̀ə́ də, bɩna pùlì, n nə yɩ nə lʋʋ lɩ̀à tə lìù, n nə bʋ̀rɩ̀ nə bʋ̀rà. Kʋ mʋ̀ nə pɩn, fən ba nə jə yoo kʋ tə wa, sə à bɩrɩ won tə, à nə wá ma jon à tɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kʋ tə ba dɩan fugə bələ dwə à nə vəli *Zwerizalɛmə, sə à bʋ Yɩɩ nə. N nə pɩ̀à kʋ nɛɛ, n wá lwarɩ kʋ. ");
INSERT INTO nnw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ba wà à mʋ̀ də lìù nɩ Zwifə-ba Yɩɩ dìə̀ tə wa, nə à yə̀ə́ Zwifə-ba *jə́rə́ dii tə wa, nə à yə̀ə́ tɩʋ tə wa, də à mʋ̀ də kʋ tíú wulə nə tʋ́tʋ̀nɩ́ duən. Ba wà nə nɩ də, à wulə à gugurə lalʋʋ. ");
INSERT INTO nnw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Yá cɩ́gá mama, ba wàrɩ̀ won tə yɩrɩ, ba nə zɩga à nə, ba bɩrɩ sɩ́ʋ́n nətən. ");
INSERT INTO nnw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Yoo tə, à nə yə̀ə́, sə à swɩ̀n n yáá con, nə yɩ kʋ tə nətən: À yɩ à tʋŋa à pɩn nə nɩbara Zwifə-ba Yɩɩ tə nə, yɩjʋncwəŋə nədʋn tə wa, ba mʋ̀ nə ma boŋə kʋnkʋn yɩjʋncwəŋə. À pɩn cɩ́gá won tə mama nə, kʋ nə pʋ́pʋ́nɩ́ Yɩɩ nii tə, ʋ nə pɩn Moyizə nə, saga tə wa, də Yɩɩ nii *sʋ̀sʋ̀nà saga tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","À jə yala də Yɩɩ, ba də tətə ga jə tə yala təntə. Kʋ mʋ̀ nə yɩ cɩ́gá tɩ̀án də lɩ̀à, ba nə tʋŋa kʋnkʋn, mɛ wá bwin ba nan tɩan wa. ");
INSERT INTO nnw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kʋ mʋ̀ nə pɩn, à də ma kəni à kajaŋa máŋá mama, sə à bɩcan wànɩ́ kʋ ya nəpon Yɩɩ yáá con, də ləzoni yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","À nə nan Zwerizalɛmə wa, kʋ yí bɩna də bɩna. Yá à dàń yà pìí à jə səbiu à bà, sə à ma fwa yɩlori à lʋʋ zʋra tə nə, sə à kə lá, à fwa *joŋi à pa Yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kʋ mʋ̀ yà nə yɩ à tʋtʋŋɩ, máŋá tə wa, ba nə nɩ nə Yɩɩ dìə̀ tə wa. Kʋ máŋá tə wa, à də tanɩ à tɩ̀àn, sə à yoo kwɛn Yɩɩ yáá con. À mʋ̀ də lalʋʋ yà nə wà lá yɩn, gurə gurə də ga wà lá yɩn. ");
INSERT INTO nnw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yá Azi nagwanaa Zwifə-ba duən yà nə mɛ, sə ba bà n yáá con, ba bon nə lá, də yoo nə wulə à mʋ̀ də ba pwərə wa. ");
INSERT INTO nnw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nə à yə̀ə́, sə ba tə nətən bɩrɩ won tə, kʋ nə ya à mʋ̀ nə cʋ̀gʋ̀, máŋá tə wa, à nə tún à nii tə, ba yáá tɩ̀án tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Də kʋ nə tà sʋgʋ nədʋ cɩcɩ, kʋ mʋ̀ nə yɩ à nə bubwi ba tətəŋi wa, à wʋ́: ‹Kʋ yɩ à nə pɩn cɩ́gá də, tɩga wá bwin tə yɩrɩ nə pɩn ba bʋ̀rɩ̀ à bʋ̀rà á yáá con›.» ");
INSERT INTO nnw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikəsə də yà yə̀ə́ kʋ cwəŋə təntə nə yɩ nətʋ mama. Ʋ dàń ma lwàń bʋ̀rà tə, ʋ kə dɩɩn don nə. Ʋ ga swɩ̀n, ʋ wʋ́: «Máŋá tə, pamana yuu tíú Lɩsɩasə nə twi, à wá kwɛn à ywàń á yoo tə wa». ");
INSERT INTO nnw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kʋ kwa nə, Felikəsə pɩn nii pamana bíí yuu tíú tə nə, sə ʋ cɩ̀ Polə nə, sə ʋ pa ʋ tɩnɩ ʋ tɩ̀àn. Ʋ dàn ká cɩ̀ ʋ nubɩa tə nə, də ba nə pɩ̀à ba fwa won ba pa wá. ");
INSERT INTO nnw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kʋ dɩan bagalɩ nii nə, Felikəsə də ʋ kan Dərisilə, ʋ nə yɩ Zwifə-ba bʋ̀á, twi. Yá ʋ dàń pɩn ba bon Polə ʋ bà, ʋ ga cʋgʋ wá, ka kə waa Zwezi-*Kərisə nə yoo yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Polə dàń swɩ̀n bʋ̀rà bʋ̀rɩ̀ yoo wa cɩ́gá nə yɩ nətʋ, də n nə mɛ, sə n yəni n tɩ̀àn jonu nətʋ, də bʋ̀rà tə, ka nə bɩ̀àn, yoo yuu wa. Kʋ nətʋ tə pɩn fən zʋ Felikəsə, ʋ ga swɩ̀n Polə con, ʋ wʋ́: «Nə wá yá nətən, sə n vìí, à nə kʋ́ʋ̀ nɩ máŋá, à wá pìí, à bon mʋ́». ");
INSERT INTO nnw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ʋ yà jə yala də, Polə wá pa wá səbiu. Kʋ mʋ̀ yà nə pɩn, ʋ yàá pa ba bon Polə lala, sə ʋ mʋ̀ də wá ve də duən. ");
INSERT INTO nnw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kʋ fwa bɩna bələ mɛ, kʋ kwa nə, Pɔrəkiyisə Fɛsətisə twi, ʋ jon Felikəsə yuu nə. Felikəsə yà pɩ̀à, sə Zwifə-ba pwìí ya ywánɩ́ ʋ yuu wa. Kʋ mʋ̀ nə pɩn, ʋ yá Polə bàń dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fɛsətisə twi, ʋ jon Felikəsə yuu nə, kʋ lʋʋ nii təntə wa. Dɩan batwa nii nə, ʋ nan Sezare, ʋ va *Zwerizalɛmə. ");
INSERT INTO nnw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","*Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də *Zwifə-ba yáá tɩ̀án tə kʋ́ʋ̀ tún ʋ də con yìə̀n tə nə pɩn ba zɩga Polə nə. ");
INSERT INTO nnw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ba dàń ga swɩ̀n də, tə mʋ̀ yɩrɩ ba lòrì yuywaŋʋ Fɛsətisə con. Ba lòrì wá, sə ʋ san ba, sə ʋ pa Polə bà Zwerizalɛmə, sə ba pwìí poli. Ba yà ken nii nədʋ, sə ba ja Polə ba gʋ cwəŋə wa. ");
INSERT INTO nnw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛsətisə ma le ba də, Polə yɩ ba cɩ̀gà ʋ nə Sezare nə, yá ʋ də tətə mɛ, sə ʋ pìí ʋ vìí, máŋá mancɩn wa. ");
INSERT INTO nnw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ʋ swɩ̀n ʋ súrí lá nə, ʋ wʋ́: «Də á nə swə, sə á pɩ̀à lɩ̀à, ba nə yɩ á yáá tɩ̀án, sə ba twá à nə, sə nə va. Də kʋ bɛɛ təntə nə fwa yolwan, sə ba swɩ̀n ʋ yolwan tə». ");
INSERT INTO nnw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛsətisə fwa dɩan nana, kʋ ja va dɩan fugə, ba tətəŋi wa. Kʋ kwa nə, ʋ pìí ʋ va Sezare. Kʋ tɩpʋrɩ nə, ʋ zʋa ʋ jə̀ə́ bwálɩ́ tə nə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, sə ʋ bʋ̀rɩ̀ yoo tə bʋ̀rà. Ʋ dàń ga pa nii, sə ba jə Polə ba bà. ");
INSERT INTO nnw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Máŋá tə wa, ba nə ja Polə ba bà, Zwifə-ba tə də nan Zwerizalɛmə ba bà. Ba kɩkarɩ wá, ba ga man ʋ yuu yolwan tə nə dáá, tə yoo ga cà zənzən, ba tətə nə wàrɩ̀ tə nɛɛ ba bɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kʋ tə Polə nə wá ma jon ʋ tɩ̀àn, ʋ swɩ̀n, ʋ wʋ́: «À wà lwanɩ fwa won mama wa. À wà Zwifə-ba Yɩɩ *nii tə, ʋ nə pɩn *Moyizə nə, cʋ̀gʋ̀, nə à yə̀ə́ Zwifə-ba Yɩɩ *dìə̀ tə, nə à yə̀ə́ *Romə-ba pɩ̀ʋ́ nəfarʋ tə». ");
INSERT INTO nnw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛsətisə də nə pɩ̀à, sə Zwifə-ba pwìí ya ywánɩ́ ʋ yuu wa, ʋ bwe Polə, ʋ wʋ́: «N pɩ̀à, sə n va Zwerizalɛmə, sə ba bʋ̀rɩ̀ n bʋ̀rà kʋ yɩrɩ, à yáá con, naaa?» ");
INSERT INTO nnw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Polə də ma le, ʋ wʋ́: «À yɩ à zɩga Romə-ba pɩ̀ʋ́ nəfarʋ tə lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə yáá con. Yá mə yəbə nə, ba mɛ, sə ba bʋ̀rɩ̀ à bʋ̀rà. À wà Zwifə-ba won mama cʋ̀gʋ̀, ndə n tətə nə yə̀ə́ kʋ zəni zəni. ");
INSERT INTO nnw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Də à nə ba cɩ́gá jə, à nə fwa won, kʋ nə mɛ, sə ba gʋ nə kʋ yɩrɩ, à bá vɩ, sə ba gʋ nə. Cɩ́gá mama dàń nə tə̀lə́ ba sʋ̀ràn tə wa, ba nə jə zɩga à nə, lìù mama wàrɩ̀ nə n kəni ba jɩ̀àn wa. À mʋ̀ pɩ̀à, sə Romə-ba pɩ̀ʋ́ nəfarʋ tə nə bʋ̀rɩ̀ à bʋ̀rà tə». ");
INSERT INTO nnw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fɛsətisə vʋrʋ də ʋ kwa lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, ʋ ga swɩ̀n Polə con, ʋ wʋ́: «N swɩ̀n də, n pɩ̀à, sə Romə-ba pɩ̀ʋ́ nəfarʋ tə nə bʋ̀rɩ̀ n bʋ̀rà tə, n dàń wá va Romə-ba pɩ̀ʋ́ nəfarʋ tə yáá con». ");
INSERT INTO nnw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kʋ dɩan bagalɩ kwa nə, pɩ̀ʋ́ Agəripa də ʋ nakʋa Berenisə twi Sezare, sə ba jʋn Fɛsətisə. ");
INSERT INTO nnw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ba dɩan tə cé duən lá nə. Fɛsətisə dàń ma tì Polə yoo tə, ʋ man ʋ bɩrɩ Agəripa nə, ʋ wʋ́: «Felikəsə yá bɛɛ don bàń dìə̀ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Yá máŋá tə wa, à nə vəli *Zwerizalɛmə, *Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə, də ba *nəkwɩna tə swɩ̀n, ba zɩgɩ ʋ nə. Ba lòrì, sə ba bʋ̀rɩ̀ ʋ bʋ̀rà, sə ba gʋ wá. ");
INSERT INTO nnw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","À ma le ba də, *Romə-ba culi, sə ba pa nii, sə ba kə bɛɛ càn wa, nə à yə̀ə́, sə ba gʋ wá, də ʋ mʋ̀ də ʋ jara duən tə nə wà ba níə́ tún, sə ʋ bɩrɩ də, ʋ wà yoo cʋ̀gʋ̀, sə ba na də, ba jə cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bɛɛ təntə jara duən tə dàń ma bà yəbə lala, kʋ máŋá tə tətə wa. Ba túrí tə tɩpʋrɩ nə, à jə̀ń bwálɩ́ tə nə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, à ga pa nii, sə ba ja kʋ bɛɛ təntə, ba bà. ");
INSERT INTO nnw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ʋ jara duən tə nə twi, ba tún ba nii, ba wà wànɩ́ ba kə yolwan nədʋ tətə ʋ yuu wa, ndə à yà nə bʋŋa nətʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ba mʋ̀ də wá yà yɩ tʋ́tʋ̀ná duən nə, ba jə də duən, tə nə yɩ ba tətə yɩjʋncwəŋə tə cɩcɩ yuu wa. Ba tʋ́tʋ̀ná tə vàn don də yà yɩ bɛɛ, ʋ yɩrɩ nə yɩ Zwezi, yuu wa, ʋ nə tɩga. Yá Polə mʋ̀ ga swɩ̀n də, ʋ wulə mɩɩ wa. ");
INSERT INTO nnw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","À mʋ̀ con nə, à yə̀rì nətʋ tə, à nə wá fwa kʋ tʋ́tʋ̀ná yiri təntə wa. À dàń ma bwe Polə, də ʋ nə pɩ̀à, sə ʋ va Zwerizalɛmə, sə ba bʋ̀rɩ̀ kʋ bʋ̀rà tə lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Yá Polə də dàń bɩrɩ də, ʋ mʋ̀ swə, sə Romə-ba pɩ̀ʋ́ nəfarʋ tə nə bʋ̀rɩ̀ ʋ bʋ̀rà tə. À dàń pa nii, sə ba cɩ̀ ʋ nə kʋ ja vəli máŋá tə, à nə wá pa ʋ va ʋ pa Romə-ba pɩ̀ʋ́ nəfarʋ tə nə». ");
INSERT INTO nnw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agəripa dàń ma swɩ̀n Fɛsətisə con, ʋ wʋ́: «À də tətə pɩ̀à, sə à nì kʋ bɛɛ təntə nii sʋgʋ». Fɛsətisə ma le wá, ʋ wʋ́: «Jwɩan nə, n wá nì ʋ sʋgʋ». ");
INSERT INTO nnw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kʋ tɩpʋrɩ nə, Agəripa də Berenisə twi də dun zənzən, ba mʋ̀ də lɩ̀à tə, ba nə bʋ̀rɩ̀ bʋ̀rà tə, də tɩʋ tə yáá tɩ̀án tə mɛ kə duən ba zʋ dìə̀ tə wa, ba nə bʋ̀rɩ̀ bʋ̀rà tə. Fɛsətisə ma pa, ba ja Polə, ba ja bà. ");
INSERT INTO nnw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fɛsətisə dàń swɩ̀n, ʋ wʋ́: «Pɩ̀ʋ́ Agəripa, də á mʋ̀ lɩ̀à tə mama, á nə wulə də nəba. Á na bɛɛ wà tə, Zwifə-ba lalʋʋ tə mama nə twi, ba yí nə, də kʋ nə yɩ Zwerizalɛmə nə, nə à yə̀ə́ yəbə tətə, ba bɩrɩ də, kʋ wà mɛ, sə ba yá wá, sə ʋ mɩɩ sìí lʋʋ wa. ");
INSERT INTO nnw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","À mʋ̀ con, à na də, ʋ wà won mama fwa, kʋ nə bɩrɩ də ba mɛ, sə ba gʋ wá kʋ yɩrɩ nə. Ʋ tətə bon ʋ kə Romə-ba pɩ̀ʋ́ nəfarʋ tə nə. Kʋ mʋ̀ nə pɩn, à nɩ də kʋ mɛ, sə à pa ʋ va, ʋ pa wá. ");
INSERT INTO nnw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","À ba cɩ́gá yoo mama jə à pʋ́pʋ́nɩ́ Romə-ba pɩ̀ʋ́ nəfarʋ tə nə, Polə yoo tə yuu wa. Kʋ mʋ̀ yɩrɩ nə, à pɩn ʋ nan á yáá con. Kʋ tə kʋ nə dwə, pɩ̀ʋ́ Agəripa yáá con, sə bwiə tə, ba nə wá bwe wá tə kwa nə, sə à wànɩ́ à na yoo à pʋ́pʋ́nɩ́. ");
INSERT INTO nnw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kʋ nə tà nətʋ, à yə̀rì kʋ yáá də nətʋ tə, à nə wá tʋn bàń dìə̀ lìù Romə-ba pɩ̀ʋ́ nəfarʋ tə nə, yá à ga wà kʋ tə, ʋ nə cʋ̀gʋ̀ bɩrɩ». ");
INSERT INTO nnw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Pɩ̀ʋ́ Agəripa cʋgʋ kʋ tə mama, yáá tíú Fɛsətisə nə swɩ̀n Polə yuu wa, ʋ zwɛ̀e. Kʋ kwa nə, Agəripa swɩ̀n Polə con, ʋ wʋ́: «Cwəŋə wulə ka pa mʋ́, sə n tún n nii n yoo tə yɩrɩ». Polə dàń ma ja ʋ jɩɩn, ʋ ma fwa mɩmɩnʋ, sə ʋ tún ʋ nii. Ʋ swɩ̀n, ʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«À jə pupwən, də zə̀n kʋ tə, à nə wàá wiən tə mama *Zwifə-ba nə zɩga à nə tə yɩrɩ, à swɩ̀n n mʋ̀, à nyɩna pɩ̀ʋ́ Agəripa yáá con. ");
INSERT INTO nnw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","N dí yáá n yə̀ə́ Zwifə-ba yofwamɩnan, də ba tʋ́tʋ̀ná nə yɩ nətʋ mama. Kʋ mʋ̀ nə pɩn, à lòrì mʋ́, sə n cʋgʋ nə də pɩ́nʋ́. ");
INSERT INTO nnw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","À mɩɩ tə wa nə, kʋ nə zɩgɩ à zandwan mama, à yɩ à bori à dwíí tɩ̀án Zwifə-ba tətəŋi wa də *Zwerizalɛmə nə. Kʋ mʋ̀ nə pɩn, Zwifə-ba mama yə̀ə́ nətʋ tə, à nə yɩ. ");
INSERT INTO nnw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ba dí yáá, ba yə̀ə́ nə fuən fuən, də ba nə pɩ̀à, sə ba swɩ̀n cɩ́gá. À yà yɩ à wulə nə *Farɩzɩan-ba yɩjʋncwəŋə tə wa, ka twagʋ yoo nə cà zənzən, ka doni tə mama. ");
INSERT INTO nnw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Yá sɩ́ʋ́n nə, kʋ yɩ yala tə, à nə jə Yɩɩ nikanɩ tə, ʋ nə kàn də nə nɩbara-ba tə, nə pɩn ba wulə ba bʋ̀rɩ̀ à bʋ̀rà. ");
INSERT INTO nnw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nə Zwifə-ba dwíə́ dəkurən fugə bələ tə mɛ, tə nə tʋŋa tə pɩn Yɩɩ nə, tɩtɩn də yɩcaʋ də jə yala təntə. Yá mə yala tə, à nə swɩ̀n tə yoo, à nyɩna pɩ̀ʋ́ Agəripa, tə mʋ̀ nə pɩn Zwifə-ba zɩga à nə. ");
INSERT INTO nnw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","À bwe á mʋ̀ lɩ̀à tə mama, á nə cʋga nə. Bɛ̀eɛ̀e nə pɩn, á ma bʋŋa də, Yɩɩ wàrɩ̀ tɩga ʋ bwin? ");
INSERT INTO nnw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Kʋ nə ya à mʋ̀ con nə, à lìí à tɩ̀àn də, à mʋ̀ yà bʋŋa də, kʋ mɛ, sə à zɩgɩ lɩ̀à tə nə, ba nə jʋ̀nɩ̀ *Nazarɛtə Zwezi yɩrɩ tə nə zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Á nəŋə kʋ tə, à nə fwa Zwerizalɛmə nə. À tətə lòrì cwəŋə Zwifə-ba Yɩɩ *joŋwana yun tɩ̀án tə con, à ma kə *Kərisə lɩ̀à zənzən bàń dìə̀ wa. Yá máŋá tə wa, ba nə pɩ̀à, ba gʋ ba, à də yàá bɩrɩ də kʋ mɛ. ");
INSERT INTO nnw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Máŋá don tətə wa, à yàá kálʋ́ ba Zwifə-ba *jə́rə́ dii tə wa, sə à pa ba twɩn Zwezi. À lɩŋa tə nə zàn zənzən, máŋá tə wa, à fɩfɩn ba, à ja va à yí tɩan tə wa, tə tɩ̀án nə tà Zwifə-ba. ");
INSERT INTO nnw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Kʋ mʋ̀ yuu wa nə, à yà vəli Damasə də dɩ̀àn tə, Yɩɩ joŋwana yun tɩ̀án tə nə ken à jɩɩn wa, də ba nii tə, ba nə pɩn nə. ");
INSERT INTO nnw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","À nyɩna pɩ̀ʋ́, cwəŋə təntə wa, ndə lugu fugə bələ máŋá wa, à nɩ poni. Kʋ nan yɩɩ nə kʋ cú, kʋ pɩpɩlɩ kʋ kɩkarɩ à mʋ̀ də à twaduən tə. Kʋ poni təntə yà dwə yɩcaʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nə mama tʋa tɩa. Yá à dàń ga nì kori, kʋ nə swɩ̀n à con də *Ebərə-ba sʋgʋ, kʋ wʋ́: ‹Solə, Solə! Bɛ̀eɛ̀e nə pɩn, n ma fɩfɩn nə? N nə zɩgɩ à nə, n mʋ̀ nə wá də́ càn›. ");
INSERT INTO nnw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","À ma le, à wʋ́: ‹N mʋ̀ nə yɩ wàà, *Yuu-Tiu?› Yuu-Tiu ma pìí ʋ le nə, ʋ wʋ́: ‹À mʋ̀ nə yɩ Zwezi tə, n nə fɩfɩn. ");
INSERT INTO nnw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Zàn yɩɩ nə, n zɩgɩ n nɛɛ yuu. Nə̀ń, won tə yɩrɩ, à nə nan n nə. N yɩ à kúrí mʋ́, sə n yà à tʋ̀tʋ̀nʋ̀, sə n swɩ̀n yìə̀n tə, à nə pɩn n na, də tə tə, à tə nə wá bɩrɩ mʋ́. ");
INSERT INTO nnw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","À wá jon mʋ́ Zwifə-ba, də dwíə́ tə, ba nə tà Zwifə-ba tə, jɩ̀àn wa. Mə ba mʋ̀ lɩ̀à tə con nə, à tʋn mʋ́, ");
INSERT INTO nnw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","sə n súrí ba yɩ́á. Kʋ dàń wá pa ba nan yikunu wa, ba bà poni wa. Ba wá nan *Sɩtana dɩ̀àn wa, ba bà Yɩɩ con, sə ʋ ma wànɩ́ ʋ kwɛn ba cʋna tə, ʋ lɩ ba mʋ̀ də wá pwərə wa. Yá ba ga wá na tori, ba mʋ̀ də lɩ̀à tə, ba nə pɩn ba tɩ̀àn mɩ́ámɩ́án Yɩɩ nə. Kʋ twá də ba nə ken ba waa à mʋ̀ Zwezi nə›. ");
INSERT INTO nnw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kʋ mʋ̀ təntə yɩrɩ, à nyɩna pɩ̀ʋ́ Agəripa, à mʋ̀ wà won tə, Yɩɩ nə bɩrɩ nə tə, nii vɩga. ");
INSERT INTO nnw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","À təntən à fwa kʋ Damasə nə. À nə zàn lá, kʋ yɩ Zwerizalɛmə. À nə kʋ́ʋ̀ zàn lá, kʋ yɩ Zwide nagwanaa tə mama wa, à lɛ à yí ba tə, ba nə tà Zwifə-ba tə. À swɩ̀n ba con, sə ba vəvəri ba kwa, ba ma sá ba cʋna, ba bà Yɩɩ con, sə ba bɩrɩ də, ba cɩ́gá lwàń, kʋ twá ba tʋtʋnɛɛ nə. ");
INSERT INTO nnw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Mə kʋ yoo təntə yɩrɩ nə, Zwifə-ba jɩn nə ba Yɩɩ *dìə̀ tə wa, ba yà pɩ̀à, sə ba gʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Yá kʋ nə yɩ Yɩɩ nə cɩ̀ à nə tə yɩrɩ, à tə wulə lʋʋ zə̀n kʋ tə. À tə swɩ̀n kʋ yoo ləzwənbii də ləzwənfaran mɛ yáá con. Tə sʋ̀ràn təntə wa, à ba won mama súrí, kʋ tə *Moyizə də Yɩɩ nii *sʋ̀sʋ̀nà tə nə dí yáá, ba swɩ̀n də, kʋ wá bà tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kʋ mʋ̀ nə yɩ Kərisə nə wá də́ càn, ʋ nə wá ya təntən lìù, ʋ pìí ʋ bwin ʋ nan tɩga wa. Ʋ wá swɩ̀n poni tə yoo ʋ bɩrɩ Zwifə-ba də ba tə, ba nə tà Zwifə-ba nə». ");
INSERT INTO nnw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Polə dàń nə caga ʋ tɩ̀àn yɩrɩ nətʋ tə, Fɛsətisə zɩ̀n ʋ kori yɩɩ nə, ʋ wʋ́: «N yɩ n nyaŋa, Polə. N yənu nəfarʋ tə kəni mʋ́ nyɔɔ wa». ");
INSERT INTO nnw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Polə ma pìí ʋ le, ʋ wʋ́: «À ba nyaŋa, à nyɩna pɩ̀ʋ́ nəzəŋu Fɛsətisə. Kʋ yɩ cɩ́gá sʋ̀ràn, tə nə jə də̀ń zəni, nə à swɩ̀n nətʋ. ");
INSERT INTO nnw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Pɩ̀ʋ́ Agəripa mʋ̀ dí yáá, ʋ yə̀ə́ tə yìə̀n təntə. Kʋ mʋ̀ nə pɩn, fən ba nə ja tə yoo wa, sə à swɩ̀n tə. À yə̀ə́ də, ʋ də yə̀ə́ tə nɛɛ mama, yá tə nə wá tʋn, tə nədʋ tətə wà sə̀gə̀. ");
INSERT INTO nnw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","À nyɩna pɩ̀ʋ́ Agəripa, n pɩn cɩ́gá Yɩɩ nii sʋ̀sʋ̀nà tə nə, naaa? À yə̀ə́ də, n pɩn ba cɩ́gá». ");
INSERT INTO nnw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agəripa ma swɩ̀n Polə con, ʋ wʋ́: «Kʋ wá fwa mancɩn, n wá pɩ̀à, sə n pa à jì Kərisə lìù». ");
INSERT INTO nnw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Polə pìí ʋ le wá, ʋ wʋ́: «Də kʋ nə yɩ máŋá mancɩn, nə à yə̀ə́ zənzən, à wá lòrì Yɩɩ, sə n mʋ̀ də lɩ̀à tə mama, á nə cʋga nə zə̀n, sə á yà ndə à nə. Yá sə à jɩ̀àn banzala tə mʋ̀ dàn ká ya á mʋ̀ jɩ̀àn nə». ");
INSERT INTO nnw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pɩ̀ʋ́ Agəripa, də yáá tíú Fɛsətisə, pɩ̀ʋ́ nəfarʋ tə nə lɩ ʋ tún, də Agəripa nakʋa Berenisə, də lɩ̀à tə mama, ba nə bʋ̀rɩ̀ bʋ̀rà tə, ba yà nə wulə də ba, zàn yɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ba nan kwa, ba swɩ̀n duən con, ba wʋ́: «Bɛɛ wà tə ba won mama fwa, kʋ nə mɛ, sə ba gʋ wá kʋ yɩrɩ, nə à yə̀ə́ kʋ nə mɛ, sə ba vwa wá də banzala». ");
INSERT INTO nnw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agəripa dàń ma swɩ̀n Fɛsətisə con, ʋ wʋ́: «N yà wàá kʋ bɛɛ wà tə n dʋga, də ʋ yà nə wà swɩ̀n də, *Romə-ba pɩ̀ʋ́ nəfarʋ tə nə wá bʋ̀rɩ̀ ʋ bʋ̀rà tə». ");
INSERT INTO nnw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Máŋá don wa, yáá tíú Fɛsətisə pɩn nii, sə nə zʋ nɩ́á yuu bori, nə va Yitali nagwanaa wa. Yá ba dàń pɩn Polə də bàń dìə̀ lɩ̀à duən pamana bíí yuu tíú don nə, ʋ yɩrɩ nə yɩ Zwiliyisə. Ʋ yà wulə pamana púlí don wa, ba nə boŋə ‹*Romə-ba pɩ̀ʋ́ nəfarʋ pamana púlí›. ");
INSERT INTO nnw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nə dàń tì nɩ́á yuu bori don, kʋ nə nan Adəramitə. Kʋ mʋ̀ yà nə mɛ, sə kʋ twá tɩan tə nə wulə Azi nagwanaa tə vàn nə, kʋ kɩkarɩ kʋ lɛ. Mə kʋ mʋ̀ nə jə nəba kʋ vìí. Bɛɛ don də yɩn lá, ʋ yɩrɩ nə yɩ Arisətarəkə. Ʋ yɩ Tɛsalonikə tíú, Masedwanə nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kʋ tɩpʋrɩ nə, nə yí Sidon. Romə-ba pamana bíí yuu tíú Zwiliyisə pɩn yuywaŋʋ Polə nə, sə ʋ va ʋ dabara con, sə ba pa wá kʋ tə, ʋ nə pɩ̀à. ");
INSERT INTO nnw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nə zàn lá, nə twá Swipərə nagwanaa tə, kʋ nə wulə mʋʋ tətəŋi wa, vàn nə, sə nə ma kwálɩ́ nə tɩ̀àn nə vʋʋ tə yɩrɩ, kʋ nə zɩga nə nə. ");
INSERT INTO nnw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nə vəli nə bɛn mʋʋ tə, kʋ nə jə Silisi lʋʋ nii tə yɩra, də Panfili nagwanaa tə, nə va nə yí Mira, Lisi nagwanaa tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kʋ bwálɩ́ təntə nə, pamana bíí yuu tíú tə nɩ nɩ́á yuu bori, kʋ nə nan Alɛkəzandəri, kʋ vələ Yitali nagwanaa wa. Ʋ dàń ma pa, nə va nə zʋ kʋ nɩ́á yuu bori təntə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nə fwa dɩan də dɩan, də nɩ́á yuu bori tə yɩ kʋ vəli mancɩn mancɩn. Yá nə dí càn zənzən, nə ma va nə bwələ Kənidə. Vʋʋ tə yà cɩ̀gà nə nə, kʋ pa nə wàrɩ̀ yáá nə vəli kʋ vàn təntə yuu. Nə vəli nə twá Kərɛtə nagwanaa tə, kʋ nə wulə mʋʋ tətəŋi wa, jɩgwiə saparʋ con nə kɛ̀eń nə va nə twá Saləmone, nə lɛ. ");
INSERT INTO nnw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nə dí càn nə ma kɩkarɩ kʋ, nə va nə yí bwálɩ́ don, ba nə boŋə ‹nɩ́á yuu bwərə yizɩga nəzəŋu›. Kʋ mʋ̀ nii nə Lase tɩfarʋ də yà wulə lá. ");
INSERT INTO nnw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nə dɩ́án zənzən, yá nɩ́á yuu bori tə vəli tə dàń yà jə fən zənzən. Kʋ máŋá tə wa də nivori tə lɛ. ");
INSERT INTO nnw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Kʋ mʋ̀ nə pɩn, Polə dàń ma kwè ba, ʋ swɩ̀n ba con, ʋ wʋ́: «À dabara-ba! À na də, nɩ́á yuu bori tə bá va kʋ yí də yazurə. À na də, nətʋ tə kʋ nə ye nɩ́á tə, kʋ yɩ kʋ pɩ̀à, sə kʋ fwa nəba yoo. Kʋ wá ya càn zənzən. Kʋ tà nɩ́á yuu bori tə də kʋ zɩla tə cɩcɩ nə wá jén, kʋ yɩ də nə tətə mɛ». ");
INSERT INTO nnw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kʋ máŋá tə wa, Romə-ba pamana bíí yuu tíú tə yà ken ʋ yala lìù tə nə, ʋ nə pa nɩ́á yuu bori tə vəli, də nɩ́á yuu bori tə tíú nə, ʋ doni Polə sʋ̀ràn tə. ");
INSERT INTO nnw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Bwálɩ́ tə, nɩ́á yuu bwərə tə nə zɩga lá, waran máŋá wa nɩ́á yuu bori wàrɩ̀ lá nə kʋ zɩga. Lɩ̀à tə zʋnɩ dàń ma sɛ̀e, sə ba zɩgɩ lá nə, ba pìí ba fwa kʋ tə mama, ba nə wàá, sə ba yí nɩ́á yuu bwərə yizɩga tə, ba nə boŋə Fenikəsə, kʋ nə wulə Kərɛtə nagwanaa, kʋ nə wulə mʋʋ tətəŋi wa, tə wa. Kʋ bwálɩ́ tə yáá don yà wulə jɩzən saparʋ də yɩɩ yizwɩa wa. Kʋ yáá don də yà wulə jɩgwiə saparʋ də yɩɩ yizwɩa con. Nə yà pɩ̀à, sə nə ya kʋ bwálɩ́ təntə wa, də waran máŋá tə kɛ̀eń. ");
INSERT INTO nnw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Vʋʋ kɩkala wulə kʋ naŋa jɩzən saparʋ con kʋ fuli. Ba dàń yà bʋŋa də, ba pubʋŋa tə pɩ̀à kʋ jì. Kʋ mʋ̀ nə pɩn, ba ma yá nɩ́á yuu bori tə kʋ vìí. Yá ba dàń ga kɩkarɩ, ba boli Kərɛtə nagwanaa mʋʋ tətəŋi wa tə yɩra. ");
INSERT INTO nnw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kʋ wà dɩ́án də dwà vʋʋ don, ba nə boŋə Erakilon, nyɩ́ kʋ zàn, kʋ naŋa nagwanaa tə con, kʋ wulə kʋ fuli. ");
INSERT INTO nnw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nɩ́á yuu bori tə dɩ̀àn wà vʋʋ tə yí. Kʋ mʋ̀ nə pɩn, nə yá nə pa vʋʋ tə yugu nəba, kʋ jə kɛ̀eń. ");
INSERT INTO nnw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Máŋá tə wa, nə nə vəli, sə nə twá mʋʋ tətəŋi wa tɩa nəmanbiə don, ba nə boŋə ‹Kəloda›, jɩzən saparʋ con nə lɛ, kʋ yɩn càn zənzən kʋ pa nəba, sə nə ma wànɩ́, nə van nɩ́á yuu bori tə kwa, nɩ́á yuu boribiə tə, nə kə nə con. ");
INSERT INTO nnw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nə nə wànɩ́ nə van ka, nə pa ka dɩ̀ kwa nə, nə vwə ka, sə ka dàn ká tʋ, nə ga vwə nɩ́á yuu bori tə tətə tətəŋi wa də ŋoni, sə kʋ dàn ká lwa. Fən də yà jə nəba də dɩɩn don, nə nə wá va, nə bwɩn nə tɩ̀àn kasɩlʋ tə nə, kʋ nə wulə Sirətə nə. Nə dàń ma lɩ nɩ́á yuu bori tə wiən duən, tə yà nə pɩn kʋ vəli tə yɩ bwà bwà. Yá mə nətʋ nə, nə dàń ma vəli bwálɩ́ tə mama, vʋʋ tə nə yugə nəba kʋ kəni lá. ");
INSERT INTO nnw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Vʋʋ tə zʋzʋgʋ nəba zənzən də dɩ̀àn. Kʋ tɩa tə nə pʋrɩ, nə lɩ nɩ́á yuu bori tə wa galwaran tə, tə nə dù, nə dʋgʋ. ");
INSERT INTO nnw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kʋ dɩan batwa dɩɩn nə, ba tətə nə lɩ nɩ́á yuu bori tə yɩra zɩla duən, tə nə pɩn kʋ vəli, də jɩ̀àn ba dʋgʋ mʋʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Dɩan də dɩan yɩcaʋ ba naŋa, kacɩlacɛ ba naŋa. Yá vʋʋ nəfarʋ tə mʋ̀ yɩ kʋ fuli də dɩ̀àn, kʋ pa nə pwìí cʋ̀gʋ̀. Nə kʋ́ʋ̀ ba bʋŋa də, nə mɩɩ kʋ́ʋ̀ wá sìí lʋʋ wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nə dɩ́án zənzən nə wà wodiu dí, kʋ fɩra nə ba nəba jə yɩrɩ. Polə dàń ma zàn bara tə tətəŋi wa, ʋ swɩ̀n ba con, ʋ wʋ́: «Á yà mɛ, sə á zìlí à nii tə, sə á kʋ́ʋ̀ dàn ká nan Kərɛtə nə á vìí. Á yà wàá nə ka mɛ mʋʋ kʋ tə wa nətən tə də càn tə tə yáá nə, á cɩ̀. ");
INSERT INTO nnw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Sɩ́ʋ́n nə, à dàń tə kwè aba, sə á dàn á waa. Á lìù nədʋ tətə mɩɩ ba nan, də kʋ nə tà nɩ́á yuu bori tə cɩcɩ nə wá mɛ mʋʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Yɩɩ tə, ʋ nə tɩ nə tə, ʋ mʋ̀ Yɩɩ təntə, à nə tʋŋa à pɩn wá tə, *malɩka twi à con, tɩtɩn tə nə. ");
INSERT INTO nnw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ka swɩ̀n à con, ka wʋ́: ‹Polə, dàn ká pa fən ja mʋ́. Kʋ mɛ, sə n va n nan *Romə-ba pɩ̀ʋ́ nəfarʋ tə yáá con nə. Yá Yɩɩ, n mʋ̀ yɩrɩ nə, ʋ wá lɩ n mʋ̀ də lɩ̀à tə mama, ba nə wulə nɩ́á yuu bori tə wa›. ");
INSERT INTO nnw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","À dabara-ba, kʋ mʋ̀ nə pɩn, à ma wʋ́, á daŋa á jɩ̀àn. À ken à waa Yɩɩ nə də kʋ tə, ʋ nə swɩ̀n tə, kʋ wá tʋn, ndə ʋ nə swɩ̀n kʋ à con nətʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nə wá va nə lwá mʋʋ tətəŋi wa tɩa don yuu». ");
INSERT INTO nnw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nə dɩan fugə də banɩa tɩtɩn nə, də nə tə wulə mʋʋ tə, ba boŋə Mediterane tə yuu wa, nə vin vʋʋ tə wa. Kʋ tɩtɩkwɩʋn nə, lɩ̀à tə, ba nə pɩn nɩ́á yuu bori tə vəli tə, bʋ́n ba waa con də, kʋ yɩ ndə nə bwələ tɩa don bəbəru. ");
INSERT INTO nnw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ba lɩ won don, ba nə ma maŋa nɩ́á, ba dɩlɩ nɩ́á tə wa. Ba nɩ də, tə luŋə yɩ mɛtərə fɩtwa də barpɛ. Ba kʋ́ʋ̀ vəli yáá mancɩn, ba bwé ba dɩlɩ kʋ. Ba nɩ də, kʋ luŋə yɩ mɛtərə sapʋa də nana. ");
INSERT INTO nnw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Fən yà jə ba, də nɩ́á yuu bori tə nə wá va kʋ bwɩn kapana nə nɩ́á tə wa. Kʋ mʋ̀ nə pɩn, ba dàń ma pɩn nɩ́á yuu bori tə vəli tə mun. Ba dàń yà yɩ ba dànɩ̀, sə tɩa pʋrɩ də yabɩbara. ");
INSERT INTO nnw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Lɩ̀à tə, ba nə pɩn nɩ́á yuu bori tə, vəli tə dàń yà pɩ̀à, sə ba nan ba yá nɩ́á yuu bori tə. Ba lɩ nɩ́á yuu boribiə tə, ba nə yàá zʋ, ba ma jén tə, ba tún nɩ́á tə yuu. Yá ba ga fwa ndə kʋ yɩ ba pɩ̀à, ba kə nɩ́á yuu bori yɩra wiən tə duən nɩ́á yuu bori tə yáá con də. ");
INSERT INTO nnw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kʋ mʋ̀ nə pɩn, Polə ma swɩ̀n Romə-ba pamana bíí yuu tíú tə, də pamana tə con, ʋ wʋ́: «Də lɩ̀à-ba tə nə wà nɩ́á yuu bori tə wa yɩn, á bá wànɩ́ á nan mʋʋ tə wa». ");
INSERT INTO nnw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Pamana tə dàń ma gwəŋə nɩ́á yuu boribiə tə ŋoni tə, ba ga yá ka, ka tʋ nɩ́á tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kʋ fwa máŋá mancɩn, də tɩa tə wà pʋrɩ, Polə swɩ̀n ba mama con, sə ba də́ wodiu. Ʋ swɩ̀n ba con, ʋ wʋ́: «Nə jə dɩan fugə də banɩa zə̀n nə, á nə dànɩ̀, á ga ba wodiu də́. ");
INSERT INTO nnw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","À dàń swɩ̀n á con, sə á də́ wodiu. Kʋ mɛ, sə á də́ kʋ, sə á ma á wànɩ́ á jon á tɩ̀àn. Á lìù mama bá kwɩ̀n ʋ yukʋʋ nədʋ də tətə nə». ");
INSERT INTO nnw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Polə nə swɩ̀n tə sʋ̀ràn təntə kwa nə, ʋ tì dipɛn, ʋ ga kə Yɩɩ lɛ̀eɛ̀e ba mama yáá con, ʋ ja kʋ ʋ fʋ ʋ wulə ʋ də́. ");
INSERT INTO nnw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ba də mama jɩɩn dàń pìí tə dàn, ba ga də́ wodiu. ");
INSERT INTO nnw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nə yɩn lɩ̀à biələ də sapwɩtwa də fugə də bardʋ (276) nɩ́á yuu bori tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Máŋá tə, ba nə dí wodiu tə, ba sú, ba kòrí mɩna tə nɩ́á yuu bori tə wa, ba dɩlɩ mʋʋ tə wa, sə kʋ dun tə fʋ tə mun. ");
INSERT INTO nnw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Tɩa nə pʋrɩ, máŋá tə wa, lɩ̀à tə, ba nə pɩn nɩ́á yuu bori tə vəli tə, wà kʋ bwálɩ́ tə lwarɩ. Ba nɩ tɩa bwálɩ́ don, ba nə na də ba wàá kʋ bwálɩ́ tə nə ba cwi. Ba dàń ken ba sírí, sə ba pa nɩ́á yuu bori tə zɩgɩ kʋ bwálɩ́ təntə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ba kʋ̀rɩ̀ nɩ́á yuu bori yɩra won tə, ba dʋgʋ mʋʋ tə wa. Kʋ máŋá təntə tətə wa, ba kʋ̀rɩ̀ ŋoni tə, tə yà nə vwə nɩ́á yuu bori tə danyungulən tə, tə nə kəni nɩ́á yuu bori tə cwəŋə wa. Ba ga kə tapoli nɩ́á yuu bori tə yáá con, sə kʋ pa vʋʋ tə yigu ba. Yá ba dàń ma vəli bwálɩ́ tə con, ba nə pɩ̀à ba zɩgɩ lá. ");
INSERT INTO nnw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kʋ máŋá təntə wa, nɩ́á yuu bori tə vəli kʋ bwɩn kasɩlʋ dədolu don nə, kʋ nə wulə navwɩ bələ pwərə wa. Nɩ́á yuu bori tə cən kʋ bwálɩ́ təntə wa. Kʋ yáá con tə dàń yà mʋrɩ kasɩlʋ tə wa, kʋ pa kʋ kʋ́ʋ̀ wàrɩ̀ kʋ sʋsʋga. Yá navwɩ tə dɩ̀àn tə pʋpʋgʋ kʋ kwa con tə mʋ̀. ");
INSERT INTO nnw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Pamana dàń yà pɩ̀à ba gʋ bàń dìə̀ lɩ̀à tə, sə ba lìù mama dàn ká ye nɩ́á tə wa ʋ jén. ");
INSERT INTO nnw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Yá *Romə-ba pamana bíí yuu tíú tə də yà nə pɩ̀à, sə ʋ jon Polə tə, ʋ cɩ̀gà ba nə, sə ba fwa kʋ yoo təntə. Ʋ pɩn nii lɩ̀à tə nə, ba nə yə̀ə́ nɩ́á yiu, sə ba dí yáá ba fan ba tʋ nɩ́á tə wa ba ye, ba nan mʋʋ tə wa. ");
INSERT INTO nnw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kʋ kwa nə, ba duən tə də wá marɩ daran nə, nə à yə̀ə́ nɩ́á yuu bori tə kɩkaran tə nə, ba jə pú ba kwa. Mə nətʋ nə, kʋ yɩn ba mama tə ma nan mʋʋ tə wa, ba mɩɩ nə. ");
INSERT INTO nnw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Máŋá tə wa, nə nə wànɩ́ nə jon nə tɩ̀àn, nə va nə nan, kʋ kwa nə, nə nì də, kʋ nagwanaa təntə yɩrɩ nə yɩ Malətə. ");
INSERT INTO nnw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Kʋ nagwanaa tə tɩ̀án ywàń nə yuu zəni. Kʋ máŋá tə wa, də dwà wulə ka nɩ̀. Ba ma dwén mən nəfarʋ ba pa nəba, sə nə yweri waran tə yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Polə vəli ʋ pɛ̀e damɩnɩ púlí don, sə ʋ ja bà, ʋ kə mən tə nə. Yá máŋá tə, mən tə bárɩ́ nə mà damɩnɩ tə nə, dəkwaa cʋ̀rɩ́ ka nan tə wa, ka dɩŋɩ ʋ jɩɩn nə ka marɩ lá. ");
INSERT INTO nnw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Máŋá tə wa, kʋ nagwanaa təntə lɩ̀à tə nə nɩ dəkwaa tə, də ka gwə Polə jɩɩn tə nə, ba swɩ̀n duən con, ba wʋ́: «Kʋ tə nətən bɩrɩ də, cɩ́gá mama bɛɛ wà tə yɩ lagʋrʋ. Kʋ mʋ̀ nə pɩn, ʋ ma wànɩ́ ʋ nan mʋʋ tə wa, yá Yɩɩ cɩ́gá tə yɩrɩ, ʋ tə pɩ̀à, sə ʋ gʋ wá». ");
INSERT INTO nnw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Polə ma vɩvaga dəkwaa tə, ʋ kwɩan ʋ dɩ mən tə wa. Yá kʋ tà nə wà wá yɩ̀ də tətə. ");
INSERT INTO nnw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Lɩ̀à təntə dàń yà yɩ ba dànɩ̀, sə Polə jɩɩn tə ŋʋnɩ, nə à yə̀ə́, sə ʋ tʋ tɩa, ʋ tɩ naa nədʋ. Ba dàń dɩ̀àn wuuu, ba ga na də, yokʋkwɩʋn mama ba Polə jə. Kʋ máŋá təntə wa nə, ba kʋ́ʋ̀ pìí ba lwàń ba pubʋŋɩ tə, ba swɩ̀n də, ʋ yɩ yɩɩ don. ");
INSERT INTO nnw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kʋ bwálɩ́ təntə yà bwələ də kʋ nagwanaa tə yáá tíú tə sàń. Kʋ nagwanaa tə yáá tíú tə yɩrɩ yà nə yɩ Pibəliyisə. Mə ʋ mʋ̀ nə jon nəba, ʋ kə ʋ dìə̀ də dabarʋ. Nə fwa dɩan batwa lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Kʋ máŋá tə wa, də Pibəliyisə nyɩna yà tə́gə́. Yalɩŋa də pʋŋʋ yà nə jə wá. Polə zàn ʋ zʋ ʋ con, ʋ jʋn Yɩɩ, ʋ tún ʋ jɩ̀àn bɛɛ tə yuu wa, ʋ zwɛ̀e kʋ yayɩgʋ tə. ");
INSERT INTO nnw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kʋ mʋ̀ yuu wa nə, kʋ nagwanaa mʋʋ tətəŋi wa tə yayɩŋa tə duən twi, yá ba də yayɩran zwɛ̀e. ");
INSERT INTO nnw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ba zìlí nəba zənzən, yá nə viru máŋá wa, ba pɩn nəba won tə mama, nə yà nə pɩ̀à, sə nə na. ");
INSERT INTO nnw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nə fwa cànɩ̀ batwa Malətə nagwanaa mʋʋ tətəŋi tə wa. Yá cànɩ̀ batwa təntə kwa nə, nə zʋa Alɛkəzandəri nɩ́á yuu bori wa. Kʋ nɩ́á yuu bori təntə yà yɩn kʋ nagwanaa təntə wa, waran máŋá tə mama. Kʋ yɩra yà jə mɩmɩnʋ, ba nə boŋə ‹Diyəsəkirə›. ");
INSERT INTO nnw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nə vəli nə twá Sirakisə, nə fwa dɩan batwa lá nə. ");
INSERT INTO nnw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Nə zɩgɩ lá, nə va nə yí Rezwiyo. Kʋ tɩpʋrɩ nə, vʋʋ nyɩ́ kʋ zàn lʋʋ jɩzən saparʋ yuu. Vʋʋ təntə pɩn nə zʋ nɩ́á yuu bori nə vìí. Kʋ dɩan bələ nii nə, nə vəli nə yí Puzɔlə. ");
INSERT INTO nnw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kʋ tɩʋ təntə wa, nə nɩ lɩ̀à tə, ba nə yɩ nə nubɩa *Kərisə yɩrɩ, ba ga lòrì nəba, sə nə fwa dɩan barpɛ ba con. Yá mə kʋ yɩ nətʋ, nə ma va nə yí *Romə. ");
INSERT INTO nnw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Lɩ̀à tə, ba nə yɩ nə nubɩa Kərisə yɩrɩ, ba nə wulə kʋ tɩʋ təntə wa, yà dí yáá ba nì nə ŋwɛn. Yá ba dàń zàn ba va, wuuu, ba bà ba yí bwálɩ́ don, ba nə boŋə ‹Forimə Apiyisə›. Ba duən lɛ, ba va ba yí bwálɩ́ don, də ba nə boŋə ‹Tərowa Tavɛrənə›, sə ba ma jə́rí nəba. Polə nə nɩ ba, ʋ ken Yɩɩ lɛ̀eɛ̀e, ʋ waa ga pìí ka dàn. ");
INSERT INTO nnw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kʋ kwa nə, nə nə yí Romə. Pamana bíí yuu tíú tə dàń ma kən bàń dìə̀ lɩ̀à tə yáá tíú tə jɩɩn wa. Yá ba dàń pa nii, sə Polə mʋ̀ ya bwálɩ́ don nə, ʋ mʋ̀ də pamanʋ tə, ʋ nə cɩ̀ ʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kʋ dɩan batwa nii nə, ʋ bon *Zwifə-ba yáá tɩ̀án tə, ʋ kə duən yáá nə. Ʋ tì sʋ̀ràn tə tə, ʋ swɩ̀n ba con, ʋ wʋ́: «À nubɩa-ba, də à nə wà won mama fwa, kʋ nə zɩga nə lʋʋ kʋ tə lɩ̀à tə nə, nə à yə̀ə́ nə nɩbara-ba yofwamɩnan tə nə, ba jɩn nə, ba kə bàń dìə̀. Yá kʋ yɩ *Zwerizalɛmə nə, ba ken nə Romə-ba jɩ̀àn wa. ");
INSERT INTO nnw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ba nə bwe nə, à ma tún à nii, ba nɩ də, won mama yà tə̀lə́ à yuu wa, kʋ nə bɩrɩ də, kʋ mɛ, sə ba gʋ nə. Ba mʋ̀ yà pɩ̀à ba dʋgʋ nə. ");
INSERT INTO nnw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Yá Zwifə-ba yáá tɩ̀án tə vɩga, ba zàn ba zɩga à nə. Kʋ mʋ̀ nə pɩn, kʋ ya kálʋ́ kʋ pa nə, sə à swɩ̀n də à bʋ̀rà tə yɩ Romə-ba pɩ̀ʋ́ nəfarʋ tə nə wá bʋ̀rɩ̀ ka. Yá à ga wà pubʋŋa jén, sə à kə talɩ à lʋʋ tə yuu wa. ");
INSERT INTO nnw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kʋ mʋ̀ yoo təntə yɩrɩ nə, à lòrì, sə à na aba, sə à swɩ̀n kʋ á con. Yala tə, *Yɩzərayɛlə dwíí tə nə jə tə, nə pɩn bàń dìə̀ banzala tə wulə à jɩ̀àn nə». ");
INSERT INTO nnw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ba ma le wá, ba wʋ́: «Nə wà sagɩ nɩ, kʋ nan Zwerizalɛmə, Zwide nagwanaa tə wa, kʋ bà n yɩrɩ. Yá nə nubiu nədʋ də tətə wà nə con twi, ʋ də́ tɩjaŋa, nə à yə̀ə́, sə ʋ swɩ̀n n yolwan. ");
INSERT INTO nnw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nə dàń nə pɩ̀à, sə nə nì n nii wa, kʋ tə n nə bʋŋa. Nə dí yáá nə yə̀ə́ də, bwálɩ́ mama kʋ mʋ̀ kʋnkʋn yɩjʋncwəŋə kàrà tə yàá ja tʋ́tʋ̀ná, kʋ bà». ");
INSERT INTO nnw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ba dàń lɩ dɩɩn ba tún, ba pa Polə nə. Kʋ dɩɩn tə nə yí, lɩ̀à zənzən twi. Ba yí bwálɩ́ tə nə, ʋ yà nə wulə. Ʋ sʋgʋ tə wa, ʋ bɩrɩ də, Yɩɩ wá də́ pàrɩ̀. Yá ʋ dàń twá Yɩɩ *nii tə nə, ʋ nə pɩn *Moyizə nə də Yɩɩ nii *sʋ̀sʋ̀nà tə saga tə nə, ʋ ma swɩ̀n ba, ʋ janɩ kʋ tə, kʋ nə yɩ Zwezi yoo yuu wa. Ʋ zɩgɩ kʋ yoo təntə yuu wa jɩjʋ mama, ʋ ja va ʋ yí kʋ dədəni nə. ");
INSERT INTO nnw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Sʋ̀ràn tə ʋ nə swɩ̀n, tə zʋa ba duən, yá ba duən də ga vɩ, sə ba pa tə cɩ́gá. ");
INSERT INTO nnw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Máŋá tə, ba dàń nə pìí ba vìrí də ba tʋ́tʋ̀nɩ́ duən, Polə dàń swɩ̀n sʋ̀ràn tə tə, ʋ súrí lá, ʋ wʋ́: «Yɩɩ-*Siŋu tə jə cɩ́gá, kʋ ma twá də Yɩɩ nii sʋ̀sʋ̀nʋ̀ *Ezayi, kʋ swɩ̀n á nɩbara-ba con, kʋ wʋ́: ");
INSERT INTO nnw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹Vəli lʋʋ kʋ tə lɩ̀à tə con, n swɩ̀n n wʋ́: Á wá nì zəni, yá á bá lwarɩ kʋ də̀ń. Á wá ywàń zəni, yá á bá na kʋ. ");
INSERT INTO nnw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Lalʋʋ kʋ tə lɩ̀à tə bɩcanɩ tɩga. Ba swɩn ba zɩan, ba pú ba yɩ́á, sə dɩɩn don ba dàn ká na də ba yɩ́á, sə ba dàn ká nì kʋ ba zɩan wa. Ba bá pɩ̀à, sə ba lwarɩ kʋ də̀ń ba bɩcanɩ wa, sə kʋ pa, ba lwàń ba pubʋŋa, ba bà à mʋ̀ Yɩɩ con, sə à pa ba yazurə›. ");
INSERT INTO nnw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Á lwara də, sʋywáŋʋ́ tə, kʋ nə bɩrɩ də, Yɩɩ wá jon aba á cʋna wa, Yɩɩ tʋn kʋ, ʋ pa lɩ̀à tə nə, ba nə tà Zwifə-ba. Ba mʋ̀ wá cʋgʋ kʋ». ");
INSERT INTO nnw_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Máŋá tə wa, ʋ nə swɩ̀n kʋ nətʋ tə, Zwifə-ba vìí də ba tʋ́tʋ̀nɩ́ duən zənzən. ");
INSERT INTO nnw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Polə fwa bɩna bələ mɛ bwálɩ́ təntə wa, ʋ yà nə jon, ʋ ŋwɩ́n kʋ yuu nə. Ʋ sɛ̀e ʋ joŋə lɩ̀à tə mama, ba nə twi ʋ con, sə ba na wá. ");
INSERT INTO nnw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ʋ yàá swɩ̀n də, Yɩɩ wá də́ ʋ pàrɩ̀ tə, də ʋ kàrɩ̀ ba *Yuu-Tiu Zwezi-Kərisə yoo. Ʋ yà fwa kʋ nətʋ tə, yá fən də ga ba wá jə kʋ yoo wa mama. Yá yoo də mama wà ʋ nə cɩ̀.");
INSERT INTO nnw_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","À mʋ̀ Polə yɩ Zwezi-*Kərisə tʋtʋnbiu. À mʋ̀ nə pʋ́pʋ́nɩ́ sagɩ kʋ tə. Yɩɩ kúrí nə, sə à ya ʋ *tʋntʋnʋ. Ʋ lɩ nə, ʋ tún vàn nə, sə à swɩ̀n ʋ sʋywáŋʋ́ tə, à bɩrɩ lɩ̀à nə. ");
INSERT INTO nnw_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Yɩɩ yà dí yáá, ʋ twá də ʋ nii *sʋ̀sʋ̀nà tə, ʋ ma kàn sʋywáŋʋ́ təntə nikanɩ, fuən fuən. Yá kʋ yoo dàń pʋ́pʋ́nɩ́ Yɩɩ sagɩ tə wa. ");
INSERT INTO nnw_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Kʋ sʋywáŋʋ́ təntə swɩ̀n ʋ bìú Zwezi-Kərisə yoo, ʋ nə yɩ nə *Yuu-Tiu. Ʋ jigə ləzwənə, ba ga lʋrɩ wá pɩ̀ʋ́ *Davidə dwíí tə wa. Yá Yɩɩ twá də ʋ *Siŋu tə, ʋ ma bwin wá, ʋ lɩ tɩan wa, yá ʋ dàń ga bɩrɩ də, cɩ́gá mama, ʋ yɩ ʋ bìú tə, ʋ nə jə dɩ̀àn. ");
INSERT INTO nnw_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kʋ twá də ʋ mʋ̀ Zwezi-Kərisə, Yɩɩ ma fwa ʋ pubwanʋ tə nə yɩra, ʋ ga tún nəba, sə nə ya ʋ tʋntʋna. Ʋ fwa kʋ nətʋ tə, sə nə va nə swɩ̀n ʋ sʋgʋ tə, nə bɩrɩ dwíə́ tə mama lʋʋ mama wa nə, ba nə tà *Zwifə-ba, sə ba zìlí ʋ nii, kʋ twá ʋ yɩrɩ tə nə. Kʋ nətʋ twá ba nə keni ba waa ʋ nə wuuu. ");
INSERT INTO nnw_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","7","Á mʋ̀ *Romə tɩ̀án də wulə ba mʋ̀ lɩ̀à təntə wa, Zwezi-Kərisə nə kúrí, sə ba ya ʋ lɩ̀à. Kʋ dàń ya á mʋ̀ mama nə, à pʋ́pʋ́nɩ́ à pɩn. Yɩɩ swə aba, ʋ kúrí aba, sə á ya ʋ mʋ̀ nyiən. Nə nyɩna Yɩɩ də nə Yuu-Tiu Zwezi-Kərisə nə wá fwa pubwanʋ á yɩra, ba ga pa aba bɩcan sìə́. ");
INSERT INTO nnw_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tɩa yuu bwálɩ́ mama nə, lɩ̀à nə̀ń də, á keni á waa Zwezi-*Kərisə nə. Kʋ mʋ̀ nə pɩn, à dí yáá, à twá də Zwezi-Kərisə, à ma kəni à nyɩna Yɩɩ lɛ̀eɛ̀e, á mama yɩrɩ. ");
INSERT INTO nnw_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","1