﻿USE sofia;
DROP TABLE IF EXISTS sofia.nnq_vpl;
CREATE TABLE nnq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nnq_vpl WRITE;
INSERT INTO nnq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lungolo lwa Yesu Kilisto, kibelei cha Daudi, ngi kibelei chu Ulaimu. ");
INSERT INTO nnq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Kuboka pu Ulaimu kuika Nngwana Daudi, yenje ngi ibelei yenie, Ulaimu ngapoto mwana Isaka, Isaka ngapoto mwana Yakobo, Yakobo ngapoto mwana Yuda, ni inunu yakwe, ");
INSERT INTO nnq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ngapoto mwana Felisi na Zela amamundu bakiba Atamali, Pelisi ngapoto mwana Esiloni, Esiloni ngapoto mwana Lami. ");
INSERT INTO nnq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lami ngapoto mwana Aminadabu, Aminadabu ngapoto mwana Nashoni na Nashoni ngapoto na mwana selemani, ");
INSERT INTO nnq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Selemani ngapoto mwana Boazi amamundu Laabu. Boazi ngapoto mwana Obedi amamundu Lutu, Boazi na Lutu bakibanga achikibelei ba Obedi, Obedi ngapoto mwana Yese, ");
INSERT INTO nnq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese nga ngapoto mwana Nngwana Daudi. Daudi ngapoto mwana Solomoni amamundu abakiba anaba Uliya. ");
INSERT INTO nnq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni ngapoto mwana Leoboamu, Leoboamu ngapoto mwana Abiya. Abiya ngapoto mwana Asa, ");
INSERT INTO nnq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ngapoto mwana Yaashafati, Yaashafati ngapoto mwana Yolamu, Yolamu ngapoto mwana Uzia, ");
INSERT INTO nnq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia ngapoto mwana Yotamu, Yotamu ngabe na mwana, Aazi ngapoto mwana Ezekia. ");
INSERT INTO nnq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekia ngapoto mwana Manase, Manase ngapoto mwana Amoni, Amoni ngapoto mwana Yosea. ");
INSERT INTO nnq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosea ngapoto mwana Yekonia, na akanung'una. Kingobu chenie kikiba kiamo Akayahudi kapeleka kukilambo chuku Babiloni. ");
INSERT INTO nnq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kuboka pikitamo cha Akayahudi kujenda ku Babiloni, Yekonia ngapoto mwana Shetieli, Shetieli ngapoto mwana Zelubabeli. ");
INSERT INTO nnq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli ngapoto mwana Abiudi, Abiudi ngapoto mwana Eliakimu, Eliakimu ngapoto mwana Azoli. ");
INSERT INTO nnq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli ngapoto mwana Sadoki, Sadoki ngapoto mwana Akimu, Akimu ngapoto mwana Eliudi. ");
INSERT INTO nnq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi ngapoto mwana Eliazeli, Eliazeli ngapoto mwana Matani, Matani ngapoto mwana Yakobo, ");
INSERT INTO nnq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo ngapoto mwana Yusufu, ojwakiba angwana ba Maliamu amama ba Yesu ojwakonda Kilisto. ");
INSERT INTO nnq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Penia ikapeta ibelei komi na ncheche kuboka pu Ulaimu mpaka Daudi, ni ibelei komi na ncheche kuboka pa Daudi mpaka pa Akayahudi pabatoligwa ubanda Kujenda ku Babiloni, ni ibelei komi na ncheche kuboka pabatoligwa ubanda kuika kingobu cha Kilisto Nkomboi. ");
INSERT INTO nnq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kubelekwa kwa Yesu Kilisto kukiba yene, Maliamu amamundu Yesu akankobeka Yusufu. Nambu tangu nu kutamangaje pamwe andi pibi analome na akege, Maliamu ngabonekana abi na ndumbo kuwecho gwa Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Magambu Yusufu akiba na majendo ga mbone nnongi ja Nnoongo, apaije kunkoya oni Maliamu, ngapala kunneka kukunyegela. ");
INSERT INTO nnq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pakiba akaacha genia Mpakachi jwa Angwana kuboka Kumbengu ngampitila mumaloto kulenga, “Yusufu, mwana jwa Daudi, makajobokaje kuntola Maliamu kube aanabinu magambu ndumbo ejabinajo kuwecho gwa Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Abakupoto mwana munalome mumpa liina lyakwe Yesu, magambu jwenio nga ojwapakakombola bandu bakwe mumabaja gabe.” ");
INSERT INTO nnq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Genia goa gapitila lilenganile lilobe lya Angwana elibalenga kupete nnondoli jwa Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Munkege jwangamanya analome aiba na ndumbo apotola mwana munalome, nangweto binkema Imanueli” kulenga, “Nnoongo abi pamwe natwenga.” ");
INSERT INTO nnq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu apajimuka mulugono, ngatenda genia agalenga mpakachi jwa Angwana kuboka Kumbengu, nganto Maliamu kube aanamundu. ");
INSERT INTO nnq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nambu bagolokingeje kindanda chimweje mpaka Maliamu apapotola mwana munalome Yusufu ngampe liina mwana jwenio Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu abelekwa kukilambo chuku Beteleemu kunkoa gwa Kuyudea, kingobu Helode pakiba Nngwana. Kingobu tu kuboka pu kubelekwa, akamanyi ba ndondwa ngabaika Kuyelusalemu kuboka kumbwani. ");
INSERT INTO nnq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ngabakonya, “Kibiko kilemba, chikibelwike ojwabakube Nngwana jwa Akayahudi? Tulubweni lutondwa lwakwe kuboka kumbwani natwe tuikita kunng'ongalela.” ");
INSERT INTO nnq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nngwana Helode pajoa genia, ngaechuka muno pamwe na boa abatama Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Helode ngabakemanga akakolongwa ba Akakung'i boa na akaboli ba malagilo ga Musa, ngabakonyanga, “Kilisto Nkomboi apakubelekwa koo?” ");
INSERT INTO nnq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Angweto ngabajanga, “Apakubelekwa kukilambo chuku Beteleemu, nkoa gwa Yudea. Andi piandikigwe na nnondoli jwa Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mwe Beteleemu kilambo cha Kuyuda, mwe machokochokoje panakati ji ilambo Ikuyuda, gambu kwinu apakupiti kilongoi ojwapakalongaleya bandu bango, bu Kuisilaeli.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Penia Helode ngabakemanga pantemela akamanyi ba ndondwa, ngaba konyanga kingobu gani pulupitila lutondwa. ");
INSERT INTO nnq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kuboka penia ngabatuma bajendange ku Beteleemu ngabalagi, “Nnyendange makaingikiye nhwalo gwa mwana jwenio, anda mampatite unetele nhwalo gwenio nane nyende nakang'ongalele.” ");
INSERT INTO nnq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kuboka pa kapenikia angwana, akamanyi ba ndondwa ngabajabula. Penia lutondwa lubalubona kingono cha kalelo kumbwani ngulwalongaleya mpaka ngulujenda kujema panani pakiba mwana. ");
INSERT INTO nnq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pubulubona lutondwa lwenio ngabaala mwojo muno. ");
INSERT INTO nnq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ngabajingila unyumba ngabammona mwana jwenio pamwe na amamundu Amaliamu, ngabakilikitila, ngabanng'ongalela. Kuboka penia ngabakulugula mikoba jabe ngabampe hupo, jaabu nu ubani na mauta ga bei ngolongwa agakemigwa manemane. ");
INSERT INTO nnq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Penia ngababuja kachabe kundela jenge gambu Nnoongo akatekakelebuya mumaloto bakammujije Helode. ");
INSERT INTO nnq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kuboka pa akageni kujabula, mpakachi jwa Angwana kuboka kumbengu ngampitila Yusufu mumaloto ngannenge, “Nnyimuke muntole mwana pamwe na amamundu ntilile kukilambo cha Kumisili. Ntamanga kwenio mpaka pambakunnengela, gambu Helode apa kunkoma mwana jwenio.” ");
INSERT INTO nnq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yene Yusufu ngajimuka, ngantola mwana na amamundu, ngababokanga kilo kujenda Kumisili. ");
INSERT INTO nnq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ngabatama kwenio mpaka Helode pajomokaga. Kilebe chenie kipitila kupala lilobe libalongela Angwana kupete nnondoli jwa Nnoongo lilenganile, “Nganankema manango kuboka Kumisili.” ");
INSERT INTO nnq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode apang'anyama kutenda akamanyi ba ndondwa bala batekunkoloya, ngachimwa muno. Ngalagi ingota yoa ikinalome ya kilambo chuku Beteleemu na eibi papipi jakwe eibi nayaka ibena kubuja unyuma ikomigwe. Atenda genia akombakela machoba kuboka pagaika akamanyi ba ndondwa. ");
INSERT INTO nnq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yene nga pagalenganila malobe agalenga Nnondoli jwa Nnoongo Yelemia, ");
INSERT INTO nnq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lilobe lijoanika kukilambo chuku Lama nguto nukokaleka muno. Laeli aiguti ingota yakwe, na apaije kumpembeleya, magambu yoa ijomwike.” ");
INSERT INTO nnq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kuboka pu kujomoka Helode, Mpakachi jwa Angwana kuboka kumbengu ngampiti Yusufu mumaloto ukwako Kumisili. ");
INSERT INTO nnq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ngannenge, “Nyimuke muntole mwana na amamundu mmuje kukilambo cha Kuisilaeli, magambu abapalangita kunkoma mwana jwenio bawilangite.” ");
INSERT INTO nnq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufu ngajimuka ngantola mwana pamwe na amamundu ngababuja kukilambo chuku Isilaeli. ");
INSERT INTO nnq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nambu Yusufu pajoa kita Akelao Atawala Kuyudea paali pa awamundu Helode, ngajoboka kujenda kwenio. Kuboka pukunkelebuya mumaloto, ngajenda kunkoa guku Galilaya, ");
INSERT INTO nnq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na ngaami kukilambo chi Kunazaleti. Yene ngagalenganila malobe agalenga Nnondoli jwa Nnoongo, “Binkema Nnazaleti.” ");
INSERT INTO nnq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Machoba genia Yohana Mmatichi ngapitila papongoti kukilambo cha Kuyudea ngatumbu katangachi bandu. ");
INSERT INTO nnq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ngalenga, “Nnapange mabaja ginu. Magambu Kingwana chu kumbengu kibandakile!” ");
INSERT INTO nnq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana jwenio, nga ojwannenga Isaya ojwakiba nnondoli jwa Nnoongo apalenga, “Mundu achobe papongoti kanonoya kulenga, ‘Mapanganakie Angwana ndela jabe, mmeke kipola ndela jabe!’” ");
INSERT INTO nnq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana akwinda ngobo ejilokigwe namajuni ga nyama ojwakemigwa ngamia, nu luunga lu limbendela akwinda mukibuno chakwe, chakulya chakwe kikiba maige na buchi gu kupongoti. ");
INSERT INTO nnq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bandu kuboka kukilambo cha Kuyelusalemu nu Kuyudea, ni ilambo yoa ibi umbwega ju lukemba lwa Yolidani ngabannyendelela. ");
INSERT INTO nnq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ngabalapanga mabaja gabe, na jwenio ngababatichanga mulukemba lwa Yolidani. ");
INSERT INTO nnq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nambu Yohana pababonanga Mafalisayo na Masadukayo ajingi bukunhwikalila kupala babatichigwe, ngalenga, “Mangweto machamajoka! Beneke abannengi nhwotwi kujepa lilaka lya Nnoongo eliika? ");
INSERT INTO nnq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ntendange agalaya kutenda nnapangite mabaja. ");
INSERT INTO nnq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Makaachangaje kutenda nhwotwile kujepa lilaka kukuneme, ‘Awabito ana Ulaimu.’ Nannenge Nnoongo aotwi kagatenda mabwe aga gabe ingota yu Ulaimu. ");
INSERT INTO nnq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Libago libekigwe pamanhina ga mikongo, kila nkongo gwangapambika ubakupenguligwa nu kuleke pamwoto. ");
INSERT INTO nnq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nenga nammatichanga kwa mache kulaya nnapangite mabaja ginu. Nambu ojwapakuika kuboka pangunenga akweti uwecho muno kumbeta ne, nenga kuotoje kupoto ilatu yakwe. Jwenio ammatichanga kwa Uhuke jwa Chwapi na kwa mwoto. ");
INSERT INTO nnq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jwenio akamwi kipalwe chakwe chukupete mapemba. Aikongola mapemba nukubeka mukikokwe, nambu mapoi aitinia mwoto gwangaimika.” ");
INSERT INTO nnq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kuboka penie Yesu ngaboka kukilambo chuku Galilaya ngaika mulukemba lwa Yolidani, kupala abatichigwe na Yohana. ");
INSERT INTO nnq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nambu Yohana ngatumbu kunkanalila kulenga, nenga mbaligwa kubatichigwa na mwenga, “Lele, mwe nhwika kwango nenga?” ");
INSERT INTO nnq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nambu Yesu ngannyanga, “Ngoe magaleke genia gabe yene. Gambu genia nga agapala Nnoongo.” Penia Yohana ngajeketela. ");
INSERT INTO nnq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kuboka pa Yesu kubatichigwa, ngapita umache. Kingobu ucho mbengu ngijiekuka, ngammona Uhuke jwa Nnoongo akauluka anda ngunda nukutola panani jakwe. ");
INSERT INTO nnq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lilobe kuboka kumbengu, ngililenga, “Jwenio nga manango, junampala jwanhalalila.” ");
INSERT INTO nnq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kuboka penia Uhuke jwa Chwapi ngannongaleya Yesu mpaka kupongoti kupala alondoigwe na Mmaja. ");
INSERT INTO nnq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ngapunga machoba alubaini kilo na mui pangalye kilebe chachoa pajomola ngajijoa njala. ");
INSERT INTO nnq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mmaja nganhwikalila, ngannenge, “Anda mwenga Mamwana ba Nnoongo, magaamuliche mabwe aga gabe mikate.” ");
INSERT INTO nnq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nambu Yesu ngajanga, “Iandikigwe Mumajandiko Gachwapi, ‘Mundu alama kukulye nkate tuje, nambu ku kila lilobe elyalonge Nnoongo.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kuboka penia Mmaja ngantola Yesu mpaka kukilambo chu Kuyelusalemu, Kilambo cha Chwapi, ngammeka kunani pulengo gwa Nyumba ja Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ngannenge, “Anda mwe Mamwana ba Nnoongo mikileke pae gambu andikigwe, Nnoongo maamulicha akapakachi bakwe kuboka kumbengu kwa magambu ginumwe, mabannyanganga kumaboko gabe, kata mukikipotekaje mumaganga.” ");
INSERT INTO nnq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kwa magambu genia Yesu ngajanga kulenga, uyo Mumajandiko Gachwapi, iandikigwe, “Makategaje Angwana ana Nnoongo binu.” ");
INSERT INTO nnq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kuboka penia Mmaja ngantola Yesu mpaka kunani kukitombi kitandamau, ngannaya kingwana chi ilambo yoa ya padunia na gwambone gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Mmaja ngannenge, “Yenie yoa nhotwi kumpe mwe anda nkilakatile nu kung'ongalela.” ");
INSERT INTO nnq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Penia Yesu ngannenge, “Nnyabule mwe Malichetani! Iandikigwe Mumajandiko Gachwapi, ‘Magongalela Angwana ana Nnoongo binu na mabegelela benia jika jabe.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Penia Mmaja nganneka Yesu, akapakachi kuboka kumbengu ngabaika ngabammegalela. ");
INSERT INTO nnq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu pajoa kita Yohana Mmatichi bantabite mukipungo ngajenda Kugalilaya. ");
INSERT INTO nnq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ngaboka kilambo chuku Nazaleti ngajenda kukilambo chuku Kafalanaumu, kilambo chikibi umbwega ja lilaba lya Galilaya, mumpaka gwa kilambo cha Zabuloni na Naftali, ngatama kwenio. ");
INSERT INTO nnq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yene pililenganila lilobe elyalongela Nnondoli Isaya, ");
INSERT INTO nnq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kilambo chuku Zabuloni na Kilambo chuku Naftali, Kujenda kubaali kwiye julukemba lwa Yolidani, ku Galilaya, kilambo cha bandu banga Akayahudi! ");
INSERT INTO nnq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bandu abatama pulubendu bijibweni ndaa. Angweto abatama miwili ja kiu, Lumuli lwamulakile.” ");
INSERT INTO nnq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuboka kingobu chenie Yesu ngatumbu kutangacha ngalenga, “Nnapange mabaja ginu, magambu Kingwana chu kumbengu kibandakile!” ");
INSERT INTO nnq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu pakiba akatyanga umbwega ji lilaba lya Galilaya ngababona bandu abena alungolo akakoki, bandu benia bakiba Simoni ojwa konda Petulo na nnuna gwakwe Andulea bakakoka yamaki ku lipelele mulilaba. ");
INSERT INTO nnq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ngabalenge, “Ungengamange nenga manammekanga mme makakoki ba bandu.” ");
INSERT INTO nnq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kingobu tu ngabagaleka mapelele gabe ngabankengama Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pajenda nnongi kachoko ngababona bange akalongo abena, Yakobo na Yohana, ingota ya Zebedayo. Bakiba muntumbwi pamwe na awamundu Zebedayo, batendekea mapelele gabe. Yesu ngabakema, ");
INSERT INTO nnq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","benia kingobu tu ngubuleka ntumbwi pamwe na awamundu, ngabankengama Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ngajenda kila paali mukilambo chu Kugalilaya kabolanga bandu mu nyumba ju kunng'ongale Nnoongo nu kutangacha Nhwalo Gwambone gu kingwana cha Nnoongo ngabalamia bandu itamwe yoa eibakiba nayo. ");
INSERT INTO nnq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nhwalo gwakwe ngujoanika mukilambo chuku Silia, akatamwe boa bina itamwe ya kila aina nu kulaga, bandu bina michepela, akatamwe kiinduindu, na bandu abakiba bapolite mibele, ngabapeleka kwa Yesu, jwenio ngabalamia boa. ");
INSERT INTO nnq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bandu ajingi ngabankengama kuboka kukilambo chuku Galilaya, kilambo echikibi ni ijiji komi, Kuyelusalemu na Kuyudea na kwie ja lukemba lwa Yolidani. ");
INSERT INTO nnq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu pababona bandu ajingi ngaombe pikitombi ngatama. Akinapunji bakwe ngabannyendelela, ");
INSERT INTO nnq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","jwombe ngatumbu kabolanga, ");
INSERT INTO nnq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mbaya ababi nu uwocho muhuke, gambu Kingwana chu kumbengu nga chabe! ");
INSERT INTO nnq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mbaya ababi nu kuechuka, gambu Nnoongo mabapembelea. ");
INSERT INTO nnq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mbaya mundu jwa jali, gambu mapokela malagano ga Nnoongo! ");
INSERT INTO nnq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mbaya ababi na njala na nyota ju kutenda gapala Nnoongo, Nnoongo mababeka bajukute! ");
INSERT INTO nnq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mbaya ababi na kia, gambu Nnoongo mababonela kia! ");
INSERT INTO nnq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mbaya abampala Nnoongo kwa mwojo chwapi, gambu mabammona Nnoongo! ");
INSERT INTO nnq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mbaya akachikichani, gambu bikemigwa ingota ya Nnoongo! ");
INSERT INTO nnq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mbaya abapotekigwa kwa magambu gu kutenda agapala Nnoongo, gambu Kingwana cha kumbengu nga chabe! ");
INSERT INTO nnq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mbaya mangweto anda bandu bantukine na bamponjite nu kunkopakeya kilebe chachoa chubaja kwa magambu gango nenga. ");
INSERT INTO nnq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nhwalalange mwojo nu kululuta gambu hupo inu ngolongwa kumbengu. Yene ngapaba bonelanga akalondoli ba Nnoongo abakiba tango namangweto kubeje. ");
INSERT INTO nnq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mangweto nga mwinyo panakati ja bandu padunia. Nambu anda mwinyo uoite kulaa kwakwe ipakolelwa na nike? Kuchataje kabele, nambu kuleke panja nu kulebatigwa na bandu. ");
INSERT INTO nnq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mangweto nga lumuli lwa dunia. Kilambo chikichengigwe panani pa kitombi kuotoje kukiia. ");
INSERT INTO nnq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na bandu kupambaje lumuli nu kuluekelela lidebe, nambu kulubeka panani putala, kupala bamulakile bandu boa ababi unyumba. ");
INSERT INTO nnq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mangweto uyo mpaka oti lumuli lwinu lumulike nnongi ja bandu, bagabone maengo ginu gabe chwapi na bakoigwe Awawa binu ababi kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Makakita nhikila kuboya Malagilo ga Musa na maboulo ga akalondolije. Nhikila kuboyaje, nambu nhikila kulenganakia. ");
INSERT INTO nnq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nannenge kweli mpaka mbengu na dunia pipakupeta, napachokoje pa Malagilo ga Musa pukuboigwa, mpaka goa galenganile. ");
INSERT INTO nnq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mundu jwajwoa ojwapakulemwa amuli ejibi njokochoko kupeta joa na kabola bange batendange jenia, jwenio apakube nchokochoko mukingwana chu kumbengu. Nambu jwajo ojwapakagakamula na kabola bange, jwenio apakube nkolongwa mukingwana chu kumbengu.” ");
INSERT INTO nnq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Nannengelanga kweli nukamuje gambone gapala Nnoongo kapeta Mafalisayo na aboli ba Malagilo ga Musa, nnyingije ngu mukingwana chu kumbengu.” ");
INSERT INTO nnq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nnyoaninge kutenda bandu ba lolo balengigwe, ‘Makakomaje! Abapakoma bapa kuhukumigwa.’ ");
INSERT INTO nnq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nambu nenga nannenge, jwajwoa ojwapa kunchimwa nnunu gwakwe apakuhukumigwa. Ojwapa kummembula nnunu gwakwe apakuntakiana kana jumbe na ojwapa kunkema nnuna gwakwe, ‘Matokamau!’ Apaligwa kujingi mumwoto gwangaimika machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Anda mpelike lilumbo lya hupo linu kukitembe cha Nnoongo na penia nkombakile nnunugwinu abi na bulwa na mwenga, ");
INSERT INTO nnq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mileke hupo inu pikitembe, nnyabule oti makachikachane na nnunugwinu, kuboka penia mmuje makapange hupo inu.” ");
INSERT INTO nnq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nchikachane na mundu ojwantakiine kiti mmi undela, makajenda kanajumbe. Andaje ojwantakiine apakunkamuya kana akimu na akimu apa kunkamuya ku linjolinjoli na kubekigwa mukipungo. ");
INSERT INTO nnq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nannenge kweli mpitaje mwenio mpaka nnyomole kulepa uloi gwoa.” ");
INSERT INTO nnq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nnyoaninge kube bandu balengigwe, ‘Makatendaje ngongola!’ ");
INSERT INTO nnq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nambu ne nannenge, ojwapa kunnolakea munkege nu kunnokolela bai ateile nakwe ngongola umwojo gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Anda lio linu lyakalelo lipakunnyambuki kulemwa, muliboye mililekele kutali namwenga! Mbaya kuoya kipagwa chimwe cha mmele gwinu, kuliko kuoya mmele gwoa kukulekeligwa kumwoto gwangaimika machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Anda luboko lwinu lwa kalelo lupakunnyambukia kulemwa, mbaya muluekete mululekele kutali namwenga! Mbaya kuoya kipagwa chimwe cha mmele gwinu, kuliko mmele gwoa ujende kumwoto gwangaimika machoba goa.” ");
INSERT INTO nnq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Uyo ilengigwe, ‘Ojwapakaleka anamundu apaligwa kape talaka.’ ");
INSERT INTO nnq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nambu nenga nannengelanga, mundu jwajoa ojwabaleka aanamundu, nambu tu gambu ga ngongola, jwenio ammeka munkege jwenio abe nngongola na mundu anda antoi munkege jwenio atenda ngongola.” ");
INSERT INTO nnq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kabe nyoininge kube bandu ba lolo balengaligwe, ‘Mikikilekaje channapila, nambu mpaka ntende channapile Kangwana.’ ");
INSERT INTO nnq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nambu nenga nannenge, makalapije. Nu kumbenguje, gambu kwenio nga kukibi kitebu cha Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","na pannemaje, gambu penia nga pukubeka makongono gabe, nuku Yelusalemuje, gambu chenie nga kilambo cha Angwana Akolongwa. ");
INSERT INTO nnq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na makalapije kwa mutwe gwinu, gambu mwe kuotoje kulubeka lunywili lube luhu andaje lupili. ");
INSERT INTO nnq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Andannengite, ‘Elo’, Ibe ‘Elo’, Anda nnengite, ‘Ije’, Ibe ‘Ije’, Chachoa chikipeta genia kiboka kwa Mmaja.” ");
INSERT INTO nnq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ngannyoanga kube galengigwe, ‘Nnyinu anda ammoite lio namwe mammoya lio, nnyinu anda ankolite lino namwe mankola lino.’ ");
INSERT INTO nnq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nambu nenga nannengela, makammukije ubaja mundu mmaja. Mundu anda amputite likopi lijego lya kalelo, mantendebukie lenge. ");
INSERT INTO nnq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mundu anda ampelike kamahakama kupala kutola lichati linu munnekele nilikoti linu atole. ");
INSERT INTO nnq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu anda anhwamuliche kupotola nhwigo gwakwe mwanja gwa maili jimwe mpotola maili ibena. ");
INSERT INTO nnq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ojwapakunyopa kilebe mumpe, makannyimaje ojwaika kunnyaika kilebe.” ");
INSERT INTO nnq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ngannyoa kutenda ilengigwe, ‘Mumpale nndami nyinu, na manchimwe nngondwa jwinu.’ ");
INSERT INTO nnq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nambu nannenge, mapalange akangondwa binu, na majopele ku Nnoongo abampoteka, ");
INSERT INTO nnq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kupala mmegange makinangota ba Awabinu ababi kumbengu. Gambu benia bamulakila lumuli lwabe bandu boa akabaja na bambone, na kakomelekea ula bandu bambone na bandu akabaja. ");
INSERT INTO nnq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bo, mpakupata upo nike ku Nnoongo, kwa kapala abampalanga mangweto tu? Magambu ata akatocha kodi bakamulanga ugo! ");
INSERT INTO nnq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Anda mapatangite abali akalongo binu tu, ngimikikamwa ni kiyono? Mbone na bandu bangammanya Nnoongo bakamu ugogo! ");
INSERT INTO nnq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mmeganga makambone, anda Awabinu bu kumbengu pababi bambone!” ");
INSERT INTO nnq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ntamanga maha makakamuje itendwa yambone kupala mmonekane nnongi ja bandu. Awawa binu ababi kumbengu bampeje hupo.” ");
INSERT INTO nnq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pamampe kilebe nhwocho, makalandulije. Makabe mandendemunduje andi bandu ababikitenda bambone pababeganga unyumba ju kunng'ongale Nnoongo nu undela kupala bandu balumbalile. Nannenge kweli, bai bapatangite hupo yabe tegatega. ");
INSERT INTO nnq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nambu mwe pamankola nhwocho wala nng'anja gwinu jwa mpalana akamanyaje panteile. ");
INSERT INTO nnq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mpange kilebe chinu kukuiya na Awawa binu ba kumbengu ababibona ilebe iigwe mabampa hupo inu.” ");
INSERT INTO nnq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Panng'ongalela, makabeje andi bandu akandendemundu. Angweto kupala kujema munyumba ju kunng'ongale Nnoongo nu umbwega ja ndela kupala bandu babone. Nanenge kweli Angweto bapatangite hupo yabe. ");
INSERT INTO nnq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nambu mwe papakunng'ongalela Nnoongo, nnyingile kuchumbi chinu nu kujigala nniango, nng'ongalela ka Awawa binu bangabonekana. Na benia Awawa binu abagabona agaiigwe mabampa hupo.” ");
INSERT INTO nnq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Panng'ongalela, makalonge malobe nduuje andi apabatenda bandu bangammanya Nnoongo. Magambu angweto bapemele Nnoongo jwabe bajoange gambu ga malobe gabe majingi. ");
INSERT INTO nnq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Makabe andi angwetoje. Gambu Awawa binu bagamanyi malola ginu tango nakajopaje. ");
INSERT INTO nnq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mpaligwa kugongalela yene, ‘Awawa bito mammi kumbengu, lina linu lya chwapi likoliigwe, ");
INSERT INTO nnq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kingwana chinu kiike, Lyampala libe kudunia andi kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mutupe lele chakulya chito. ");
INSERT INTO nnq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mugalekekeye malemwa gito, Andi twe putugalekekeya malemwa ga ababutulemwite. ");
INSERT INTO nnq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mukutubekaje mumitambo, nambu mutukombole na Mmaja.’ Magambu kingwana nga chinu na makakala, nu ukolongwa machoba goa pangapela. Unhyo. ");
INSERT INTO nnq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Anda malekekiye bandu malemwa gabe, Awawa binu ba kumbengu maba nnekekeya uyo. ");
INSERT INTO nnq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nambu anda kalekekeyaje bandu malemwa gabe, na Awawa binu bannekekeyaje malemwa ginu.” ");
INSERT INTO nnq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pampunganga, makabeje andi bandu ababikitenda bambone angweto kubeka lukenja kumio jabe babonekane na bandu bamanye kita batekupunga nannenge kweli angweto balepigwe hupo yabe. ");
INSERT INTO nnq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nambu mwenga, pampunga mpakala mauta umutwe jinu na nkuye kumio jinu nu kwemulila nywili inu, ");
INSERT INTO nnq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ibe mundu jwajwoa akamanyaje kiti nte kupunga, imanyekane tu na Awawa binu bangabonekana. Na Awawa binu abagabona agaiigwe bampa hupo.” ");
INSERT INTO nnq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mikikibekeje ilebe padunia, mwenio idudu na nguu kualabia na akajibi kujingila nu kujiba. ");
INSERT INTO nnq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nambu mikibekele lupambo kumbengu kwenio idudu na nguu kuotoje kualabia, na akajibi kujingije nu kujiba. ");
INSERT INTO nnq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gambu machoba goa apulubi lupambo lwinu na mwojo gwinu uba upo.” ");
INSERT INTO nnq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mio nga lumuli lwa mmele. Anda mio ginu gabi chwapi na mmele gwinu gwoa upakube mulumuli. ");
INSERT INTO nnq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nambu anda mio ginu mabou mmele gwinu gwoa ubakube mulubendu. Bai anda lumuli olubi nkati jinu ngulubendu, mmanya lwenio ngu lubendu lukujogoya!” ");
INSERT INTO nnq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Abije mundu ojwaotwile kabegele akangwana abele. Gambu apakunchimwa jumwe nu kumpala jonge. Apakube na jumwe nu kummembu jonge. Nhwotwaje kummegelela Nnoongo nu uloi.” ");
INSERT INTO nnq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nga kwa mana nannengelanga, makapweleje ndya nike na nywanike na wala ngobo yukwinda. Bo, bwomi gwambonije kupeta chakulya na ngobo yambone kupeta mmele? ");
INSERT INTO nnq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Miloleke ijuni ikamanyai ibi kupandaje nu kuunaje, na ikwetije ikokwe. Nambu Awawa binu bu kumbengu kipe kulye. Bo mangweto mamboneje kupeta ijuni? ");
INSERT INTO nnq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Bene kati jinu kwa magambu ga mbwele yabe, baotwile kukijonjake kingobu chukulama pangaje lichoba limwe?” ");
INSERT INTO nnq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kwanike kube na mbwele ya ikwindo? Magalolakeye maloba ga kamanyai pagalembulila. Gabi kamuje maengo wala kutendakea ikwindo. ");
INSERT INTO nnq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nambu nannengelanga, wala bene Angwana ana Solomoni pamwe nu ukolongwa gwakwe gwoa banakwindaje chwapi andi pagabi maloba aga. ");
INSERT INTO nnq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Anda ibi Nnoongo agakwindiya manyai ga mpongoti agabi leleno na malabo kagalekela kumwoto, bo, Nnoongo ankwindiaje mangweto muno? Makangweto mina imani njokochoko!” ");
INSERT INTO nnq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Makapweleje kutenda, ‘Tupakulye nike?’ Andaje ‘Tupakunywe nike?’ Andaje ‘Tupakwinda nike!’ ");
INSERT INTO nnq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gambu genia goa bagabegelela bandu bangammanya Nnoongo. Awawa binu ababi kumbengu bagamanyi agampala goa. ");
INSERT INTO nnq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nambu ntumbu kikibegelela oti kingwana cha Nnoongo kupeta goa na agapala Nnoongo, penia Nnoongo mampage goa nu kujonjekea. ");
INSERT INTO nnq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bai, makapweleje ga malabo, gambu malabo ikweti malola gakwe. Kila lichoba likibegele lyene.” ");
INSERT INTO nnq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Makahukumuje bandu, manhwika kuhukumuligwa na Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","gambu pamahukumula ajinu na mangweto mpakuhukumigwa uyo, ni kipemo chamapeme bange ucho echapakumpeme Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mboni mwe milibona lipandi mulio lya nnunagwinu, na kongo lipalamandi elibi mulio linu kulibonaje? ");
INSERT INTO nnq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nhwotobo kunnenge ‘Nnunu gwinu, nnyeme nammoye lipandi mulio linu na kongo mmene nkweti lipalamandi mulio linu? ");
INSERT INTO nnq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mwe mandendemundu! Mmoye oti lipandi elibi mulio linu penia pampakulola tela kuboya kipalamandi chikibi mulio lya nnuna gwinu.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mikipeje imbwa ilebe yachwapi, kupala yakagalambukaje nu kunkwalambula mmene mangweto, na makagalekeleje magolobe lulu inu kupala gakalebataje. ");
INSERT INTO nnq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nnyope, mangweto mampata, mpalepale na mangweto mamibona, nng'ombange oti mangweto mabannyogola.” ");
INSERT INTO nnq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mundu jwajoa jwajopa kupata, ojwapalapala kiibona, na ojwagomba oti kunnyogolela. ");
INSERT INTO nnq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bo, abi mundu kati jinu anda mwana gwakwe annyopite nkate kumpa libwe? ");
INSERT INTO nnq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Andaje ajopite chamaki kumpa lijoka? ");
INSERT INTO nnq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anda yene mangweto mammilingite makabaja mmanyi kipe ingota inu ilebe yambone. Mmanya Awawabinu bu kumbengu bapakape gambone muno abajopa. ");
INSERT INTO nnq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Matendelange bandu bange andi gamagapala bantendele mangweto. Yene ngapagabi Malagilo ga Musa na maboulo ga akalondoli ba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nnyingilange pa nniango ogubi nchokochoko, magambu ndela ejijenda kukujomoka ngolongwa na nniango gwa kujingi mwenio nkolongwa, abajenda ndela jenie ajingi. ");
INSERT INTO nnq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nambu ndela ejijenda kubwomi njokochoko na nniango gu kujingi mweno nchokochoko na bandu achoko tu abijibona ndela jenie. ");
INSERT INTO nnq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ntamanga maha na akalondoli bu uwangi angweto bakaika kwinu kunja bakabonekana andi mambelele, nambu nkati jabe mamei makale. ");
INSERT INTO nnq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mamanya ku itendwa yabe. Bo bandu kutongola zabibu munkongo gwa miba, andaje mbendembe mumpengo? Ije! ");
INSERT INTO nnq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nkongo gwambone kupambika ngokwa yambone, na nkongo mmaja kupambika ngokwa mbaja. ");
INSERT INTO nnq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nkongo gwambone kupambikaje ngokwa mbaja, na nkongo mmaja kupambikaje ngokwa inachwapi. ");
INSERT INTO nnq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila nkongo gwanga pambika ngokwa inachwapi kueketigwa nu kuuleke pamwoto. ");
INSERT INTO nnq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kwa yene, mamanyanga akalondoli buwangi ku itendwa yabe. ");
INSERT INTO nnq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ngiti kila mundu ojwapa kungema ‘Angwana, Angwana,’ Ajingila mukingwana cha kumbengu, nambu jwajo tu ojwapakutenda agabapala Awawa ababi kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bandu ajingi binnengela lichoba lyene lya hukumu, ‘Angwana, Angwana! Kwa liina linu ngututangacha nhwalo gwinu na kwa liina linu ngutuboya michepela nu kulaya ikobo ijingi!’ ");
INSERT INTO nnq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Penia manalengela, ‘Numanyije mangweto, mmokange nnongi jango, mangwetomwe makabaja!’ ");
INSERT INTO nnq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Yene kila mundu ojwajoa malobe gango na kugakamula, malandana na mundu juna malango, ojwachengite nyumba jakwe panani piliganga. ");
INSERT INTO nnq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ula ngijikoma, ngemba ngitwele mache, kimbonga ngikiika na kujiputa nyumba. Nambu nyumba jigwije kwa magambu jikachengigwa panani pa liganga. ");
INSERT INTO nnq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nambu mundu jwajwoa jwajoa malobe gango nu kugakamuje, malandana na mundu jwapunganikwe ojwachengite nyumba jakwe panani pimiyangi. ");
INSERT INTO nnq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ula ngijikoma ngemba ngitwele mache kimbonga ngikiika ngijiputa nyumba jenie ngijigwe. Kabe luwindu lwakwe lukiba lukolongwa muno!” ");
INSERT INTO nnq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","“Yesu pajomola kulenga malobe genia, nkengeni gwa bandu nguomongwa kwa maboulo gakwe. ");
INSERT INTO nnq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Abola andi akaboli babeje ba Malagilo ga Musa, nambu jwombe abola kukinala.” ");
INSERT INTO nnq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu pauluka kuboka pikitombi, kikuta cha bandu ajingi ngikinkengama. ");
INSERT INTO nnq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngaika mundu jumwe juna maloi, ngakilikitila nukulenga, “Ananhota andampaile nhwotwi kunyeguya.” ");
INSERT INTO nnq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ngatondobeya luboko lwakwe kunkunyula mundu jwenio nu kulenga, “Mbala nnyeguke.” Kingobutu mundu jwenio ngajeguka maloi gakwe. ");
INSERT INTO nnq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Penia Yesu ngannenge, “Mpenakia, makannengeje mundu jwajwoa, nambu nnyende mikikilaye kakung'i na makapange hupo jaamulicha Musa kachalakicha kutenda nnamite.” ");
INSERT INTO nnq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu paika pikilambo chuku Kafalanaumu pannyini, kilongoi jumwe jwa Loma nganyendelela, ngampembela annyangate, ");
INSERT INTO nnq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ngalenga, “Ananhota mpakachi jwango abi ukaja ntamwe lola na atekupola.” ");
INSERT INTO nnq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu ngannengela “Mainka kunnamiya.” ");
INSERT INTO nnq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kilongoi jwenio ngannenge Yesu, “Ananhota, mbaligweje mwe nnyingi unyumba jango. Nambu nnenge lilobe limwe tu mpakachi jwango malama. ");
INSERT INTO nnq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gambu nane uyo namundu nambi pae jikinala cha akinanhota bango, ngweti manjolinjoli ababi pae jango. Anda nannengi jumwe, ‘Nnyende!’ Na jwenio kujenda, anda nannengi jumwe, ‘Nhwike!’ Na jwenio kuika, na andanannengi mpakachi jwango, ‘Nkamule kilebe eche!’ Na jwenio kamula.” ");
INSERT INTO nnq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu pajoa genia, ngaomongwa muno, ngabalenge bandu abakiba bakankengema, “Nannenge kweli nanammonaje mundu jwajoa Kuisilaeli pano ojwakweti imani ngolongwa andi ojo. ");
INSERT INTO nnq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nannenge kweli, bandu ajingi mabaika kuboka kumbwani nu kundonde, benia mabatamanga pamwe pampapala na Ulaimu na Isaka na Yakobo kukingwana chu kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nambu angweto abapaligwe kube mukingwana cha Nnoongo papakulekeligwa panja, pulubendu, kwenio bapakugutanga nu ukeya mino.” ");
INSERT INTO nnq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kuboka penia Yesu ngannenge kilongoloi jwa Loma, “Nnyabule ukaja na ikabe andi punhwamini.” Na mpakachi jwakwe ngalama kingobu uchache. ");
INSERT INTO nnq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu ngaika kachakwe Petulo, ngabakolela akimundu akege Petulo bagolilwike pikindanda, atamwe. ");
INSERT INTO nnq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ngabakamu luboko amama benia kitamwe ngachaboka ngabajema na kabegelela. ");
INSERT INTO nnq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Piika kimuyo, ngabannetela bandu ajingi abakibanga bakachikila nchepela, jwenio kukulenga Lilobe tu, michepela ngijitila na ngabalamianga bandu boa. ");
INSERT INTO nnq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Atenda genia kupala galenganile malobe agalongela Nnondoli jwa Nnoongo jwakemigwa Isaya kulenga, “Jwenio mwene atoile uwina gwito, apotwile itamwe ito.” ");
INSERT INTO nnq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu paubona nkengeni gwa bandu guntindile ngabaamulicha akinapunji bakwe bajomboke kujenda kwiye ji lilaba. ");
INSERT INTO nnq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mmoli jumwe ju Malagilo ga Musa ngannyendele Yesu ngannengela, “Aboli ne mbakunkengama kila kumpakujenda.” ");
INSERT INTO nnq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu ngannyanga, “Mabwea gakweti nduka, ni ijuni yu kunani ikweti uhui, nambu Mwana jwa Mundu akwetije paali pu kubeka mutwe gwakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Penia jumwe kati ja akinapunji bakwe ngannenge Yesu, “Angwana, nanji uneke nyende oti nakachike awabango.” ");
INSERT INTO nnq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nambu Yesu ngajanga, “Ungengame milekange mitui ichike mitui mijakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu ngaombe muntumbwi na akinapunji bakwe ngabankengama. ");
INSERT INTO nnq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kingobu ucho kimbonga kikolongwa ngikipitila mulilaba na mawimbi ngaga tumbu kuwekela ntumbwi. Nambu Yesu akiba agochi lugono. ");
INSERT INTO nnq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Akinapunji ngabajenda kunnyimuya, ngabalenga, “Angwana, mutukombole, tubakujomo!” ");
INSERT INTO nnq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu ngabalenge, “Mangweto mmi na imani njoko mboni mmi na mbwele?” Ngajinuka ngakikalapila kimbonga na mawimbi, ngukube jee. ");
INSERT INTO nnq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bandu boa ngabaomongwa, ngabalenga, “Ojo mundu nike? Ata upepo na mawimbi gatenda nnyoa!” ");
INSERT INTO nnq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu paika pikilambo chu Kugadala kwiye ja lilaba, na kwenio bandu abena abakiba ni michepela ngabakongana nabo bakabokela kamakabuli. Bandu benia bakiba bina kujogoya muno, kabe abonikije mundu jukujiga kupeta ndela jenie. ");
INSERT INTO nnq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Benia ngaba tumbu kuchobela mwe ma Mwana ba Nnoongo kibi nike natwe? Bo, nhwikila kutupoteka tango kuwikaje kingobu chene? ");
INSERT INTO nnq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Papipi na penia pakiba na magolobe nduu agachungigwa. ");
INSERT INTO nnq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Michepela ngajannenge Yesu, “Anda mutuboite mutuleke takagajingi magolobe gala.” ");
INSERT INTO nnq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ngajilenge, “Aja nnyendange” Penia ngijiboka mu bandu bala ngijijingi mumagolobe. Kipenga choa ngikielela pilichela, nukujingi mulilaba magolobe goa ngagawe na mache. ");
INSERT INTO nnq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Akachungi ba magolobe ngabatilanga, ngabajenda kunnyini. Kwenio ngabalandulila ilebe yoa eipitile na bandu bi michepela. ");
INSERT INTO nnq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kuboka penia bandu boa bapannyini ngababoka ngabannyendele Yesu, pabammonaga ngabampembela aboke pikilambo chabe. ");
INSERT INTO nnq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu ngaombe muntumbwi ngajomboka lilaba nukuwika kukilambo chatama. ");
INSERT INTO nnq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bandu bange ngabannete mundu ojwapolite mmele gwoa bang'onike pikindanda. Yesu apaibona imani yabe, ngannenge mundu jwenio ojwapolite, “Nnimbe mwojo manango mabaja ginu galekikigwe.” ");
INSERT INTO nnq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Penia bange akaboli ba Malagilo ga Musa ngabatumbu kuwacha, “Mundu ojo antukana Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ngamanya mawacho gabe, ngakonya, “Mboni nhwachanga mabaja mumyoju jinu? ");
INSERT INTO nnq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chako chikibi kindema muno, kulenga, ‘Nagalekakiye mabaja ginu’ andaje kulenga, ‘Nnyeme nnyende?’ ");
INSERT INTO nnq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngoe mbala mmanyange kutenda Mwana jwa mundu, akweti kinala chu kulekekeya mabaja ga bandu padunia.” Penia ngannenge jwenio jwapolite, “Nnyinuke, ntole kindanda chinu, nnyabule kachinu.” ");
INSERT INTO nnq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mundu jwenio jwapolite ngajinuka ngajabula kachakwe. ");
INSERT INTO nnq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bandu boa ba pankengeni pabagabona genia agatendigwe ngabaomongwa nu kunnumba Nnoongo ojwabapi bandu kinala chenia. ");
INSERT INTO nnq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ngaboka penia, na pakiba akajabulaga, ngammona mundu jumwe ojwakemigwa Matayo, atamite panyumba ju kutocha kodi. Ngannengela, “Ungengame.” Na jwenio Matayo ngajinuka ngankengama. ");
INSERT INTO nnq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu pakiba kachakwe Matayo akalya chakulya, akatocha kodi ajingi na akabaja ngabaikanga kutama pamwe nakwe na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo pabagabona genia, ngagalenge akinapunji ba Yesu, “Mboni aboli binu balye pamwe na akatocha kodi na akabaja?” ");
INSERT INTO nnq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ngabajoa, ngalenga, “Bandu banga itamwe kunkokaje nng'anga, nambu akatamwe nga abankoka nng'anga. ");
INSERT INTO nnq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nambu nnyende mikikibolange mana ga malobe ga Nnoongo agalenga, ‘Mbala, kia ngiti lilumboje.’ Gambu inkila kakema bandu ababikibona bamboneje nambu bandu bina mabaja.” ");
INSERT INTO nnq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Penia akinapunji bakwe Yohana Mmatichi ngabannyendelela Yesu, ngabankonya, “Mbone twenga na Mafalisayo tubikupunga pajingi, nambu akinapunji binu babi kupungaje?” ");
INSERT INTO nnq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu ngabajanga, “Bo abakokigwe kumpapala gwa kutola akege bapaligwa ukokaleka na kingobu akoano babi pamwe nabo? Kubeje! Nambu kingobu makiika penia akoano mababoigwa panakati jabe kingobu chenie nga cha kupunga. ");
INSERT INTO nnq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Bandu kubekaje kibamba cha ngobo nhyono mungobo ng'ona. Gambu kibamba chenie kibakujonjekeya kupapula ngobo ng'ona jenie. ");
INSERT INTO nnq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uyo bandu kubekaje divai nhyono mukitumba kigona. Anda batei yene umanya kitumba kipakupachuka na divai jipakujitika, bandu babekanga divai nhyono mukitumba kiyono, na yoa kitumba na divai maiba tegatega.” ");
INSERT INTO nnq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu pakiba akalenga genia kilongoi jumwe jwa Akayahudi ngaika ngannitila nukulenga, “Kamwale jwango ajomwike kingobu uchenje nambu mwe chonde tujende makammeke luboko lwinu malama.” ");
INSERT INTO nnq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu ngajinuka ngajabula pamwe na kilongoi jwenio na akinapunji bakwe ngabakengama. ");
INSERT INTO nnq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nu munkege jumwe, ntamwe ncholo kwa yaka komi nibena, ngankengama Yesu unyuma, ngakunyula lilombola li lutando lwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Akawacha kumwojo jakwe kutenda, “Anda ngunywile tu lutando lwakwe manama.” ");
INSERT INTO nnq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ngatendabuka ngammona munkege ngannenge, “Manango nnimbe mwojo imani jinu jinnamiye.” Munkege jwenio ngalama kingobu ucho. ");
INSERT INTO nnq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kuboka penia Yesu ngaika kachakwe kilongoi jwenio. Na pababona bandu bakajemba pilimbi na bandu kuguta, ");
INSERT INTO nnq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ngabalenge, “Mpitange panja! Kamwale ojo awije, atekugoche tu.” Nambu benia ngaba nhweka. ");
INSERT INTO nnq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nkengeni gwa bandu pupita panja, Yesu ngajingi unyumba, ngankamula luboko kamwale jola na jwenio ngajema. ");
INSERT INTO nnq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nhwalo gwenio gujoanika kilambo choa. ");
INSERT INTO nnq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ngaboka penia, na apakiba undela, bangalola akabena ngabankengama nu kuchobela, “Mwana jwa Daudi, mutubone kia!” ");
INSERT INTO nnq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu pajingila unyumba, bangalola akabena ngabannyendelela, Yesu ngabakonya, “Bo, nhwamininge kube nenga nhotwile kunnamiya?” Angweto ngabajanga, “Elo Angwana.” ");
INSERT INTO nnq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Penia Yesu ngankunyula mio gabe, ngalenga, “Pibi imani inu itende uyo!” ");
INSERT INTO nnq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mio gabe ngagaoto kulola. Yesu ngabakelebuya kukalipa, “Makannengeje mundu jwajwoa kilebe chenje!” ");
INSERT INTO nnq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nambu angweto ngababokanga, nu kutangacha kilebe chenie chatei Yesu kilambo choa. ");
INSERT INTO nnq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bandu abakiba bakajendanga kachabe bange ngabannete mundu jumwe jwakiba bubu magambu akiba na nchepela. ");
INSERT INTO nnq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kingobutu puboigwa nchepela mundu jwenio ngalonge kabele. Bandu ngabaomwongwa nu kulenga, “Kilebe eche chanabonekanaje pakilambo chenje cha Isilaeli.” ");
INSERT INTO nnq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nambu Mafalisayo ngagalenga, “Aboya michepela kwa makakala ga nkolongwa ju michepela.” ");
INSERT INTO nnq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ngatyanga mwilambo yoa na ijiji. Ngababola mumajumba gabe gu kugongalela nukutangacha Nhwalo Gwambone gwa kingwana cha Nnoongo na kulamiya itamwe yoa na kubinia kwoa. ");
INSERT INTO nnq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu apababona nkengeni gwa bandu, ngababone kia kwa magambu bakibanga lola na mbwele andi mambelele ganga nchungi. ");
INSERT INTO nnq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Penia ngabalenge akinapunji bakwe, “Mauno majingi nambu akakamwa maengo achoko. ");
INSERT INTO nnq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Majopange angwana ba mauno bakinge akakamu maengo baunange mauno gakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ngabakema akinapunji bakwe komi na abena, ngabapeganga inala yu kuboya michepela na kulamia itamwe nu kubinia kwoa. ");
INSERT INTO nnq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ganga nga maina ga achandundame komi na abena, jukutumbula, Simoni ojwakemigwa Petulo na nnunagwakwe Andulea, Yakobo na nnunagwakwe Yohana yene ingota ya Zebedayo, na Yohana, ");
INSERT INTO nnq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batolomayo, Tomasi na Matayo ojwakiba ntocha kodi, Yakobo mwana jwa Alufayo, na Tadei, ");
INSERT INTO nnq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni nkola Nkananayo, na Yuda Isikalioti ojwang'aluka Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu ngabakinga benia komi na abena na kape malagilo ganga, “Makajendaje kubandu bangammanya Nnoongo, andaje muilambo ya Akasamalia. ");
INSERT INTO nnq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nambu nnyendange kunyumba ya bandu bu Kuisilaeli abaobite andi mambelele. ");
INSERT INTO nnq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pannyendanga kutangacha nhwalo gwa Nnoongo nnenga, ‘Kingwana chu kumbengu kibandakile!’ ");
INSERT INTO nnq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nnamiange akatamwe, mayoyange abawile, majeguyange bina maloi, mmoyange michepela. Mpatangita bule, na mangweto mpanganga bule. ");
INSERT INTO nnq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Makapotoje jaabu andaje uloi, andaje madini agakemigwa feza andaje liaba mumiuku jinu. ");
INSERT INTO nnq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mumwanja gwinu makapotoje nkoba gukujope ilebe undela, ni mikogo mibenaje, ni ilatu yengeje, bokola jengeje. Mana nkamwa maengo apaligwa kupoke chapala. ");
INSERT INTO nnq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Anda nhwike pikilambo mumpalanga mundu jwajwoa ojwabi lachi kumpokela na ntamanga na jwenio mpaka pampakuboka kilambo chenie. ");
INSERT INTO nnq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Apanhwika panyumba malengela, ‘Tengela jibe kwinu.’ ");
INSERT INTO nnq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Anda akakola nyumba bajeketile abali jinu, umanya tengela jinu jitama pamwe na angweto. Nambu anda bampokije bai tengela jinu jimmujila mmene makangweto. ");
INSERT INTO nnq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Anda mundu jwajoa akanite kumpokela andaje kumpenikia bai pampakuboka panyumba jenie andaje kilambo chenie mpyatanga litukunda mumakongono ginu. ");
INSERT INTO nnq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nannenge kweli lichoba lya hukumu bandu bikilambo chenie bapakupata hukumu ngolongwa kupeta hukumu jijapatite bandu bu Kusodoma na Gomola. ");
INSERT INTO nnq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Lele, ne nankinga mangweto andi mambelele panakati ja mamei. Mmaganga makakalamui andi lijoka, na mmaganga mangakijonga andi ngunda. ");
INSERT INTO nnq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ntamanga maha na bandu, gambu bapakumpeleka kamabalacha nu kumputanga bokola mumajumba gabe gu kugongalela. ");
INSERT INTO nnq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mabampelekanga kwa akatawala na akangwana kwa magambu gangune, kupala kuchalakicha kwabe nu kubandu bangammanya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pabapakumpeleka kamabalacha makapweleje kilebe champakulongela kingobu anda kiike mampatanga chukulongela. ");
INSERT INTO nnq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gambu mpakulonge mangwetumweje nambu apakulonge Uhuke jwa Nnoongo ojwabi nkati jinu. ");
INSERT INTO nnq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mundu anng'aluka nnunagwakwe akomigwe, na awawa banng'aluka mwana gwabe, ni ingota mayajingalila achikibelei mundu na kakomanga. ");
INSERT INTO nnq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bandu boa bapakunchimwa mangweto kwa magambu ga liina lyango. Nambu ojwapakuimbalila mpaka kupela, nga ojwapakomboka. ");
INSERT INTO nnq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bandu anda bampoteka pikilambo chimwe ntilila kilambo chenge. Nannenge kweli nyomoje mwanja gwinu muilambo yoa ya Kuisilaeli nukuikaje Mwana jwa Mundu. ");
INSERT INTO nnq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Napunji kapetaje aboli bakwe, na mmanda nkolongwaje kapeta angwana. ");
INSERT INTO nnq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Napunji apala abe andi aboli mundu na mmanda apala abe andi angwana mundu. Anda munanhota pakaja bankema Belizebuli mmanya akalongamundu bapakemigwa maina mabaja muno. ");
INSERT INTO nnq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Makajobokaje bandu benia. Kila chikiekeligwe kiba kuekuligwa, na kila chikiigwe kiba kubonekana. ");
INSERT INTO nnq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chinannenge pulubendu, mikilenga pandaa, na kilebe chimikijoa chakang'ing'iigwa ntandachanga pukongolou. ");
INSERT INTO nnq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Makajogopaje abakoma mmele, nambu kuotwaje koma na kiuke. Mbaya kunyogopa Nnoongo jwaotwile kukoma mmele na kiuke nukunneke kumwoto gwangaimika machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Iyebele ibena iuchigwa yumuni nhwano. Nambu kibije ata kiyebele chimwe chekigwe paye pangapala Awabinu bu kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nambu kwinu mangweto nywili yu mutwe gwinu ibalangigwe yoa. ");
INSERT INTO nnq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kwa yene makajogopaje, mangweto mwe mambone muno kupeta iyebele ijingi! ");
INSERT INTO nnq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kila mundu ojwanyeketela pabandu, nane uyo manannyeketela nnongi ja Awabango ababi kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nambu jwajwoa ojwapakungana pabandu, nane manakana nnongi ja Awabango ababi kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Makakita nhikila kubeka tengelaje padunia. Nambu nhikila kubeka tengelaje nambu upanga. ");
INSERT INTO nnq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gambu nhikila kubeka kupwilikana panakati ja mundu na awamundu, panakati ja nhwenja na amamundu, panakati ja nkoano na akimundu. ");
INSERT INTO nnq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na angondwa ba mundu biba akalongomundu. ");
INSERT INTO nnq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Abapala awamundu andaje amamundu kumbeta nenga, benia babi kumbalaje nenga. Abapampala mwana munalome mwana munkege kumbeta nenga, kupaligwaje kube napunji. ");
INSERT INTO nnq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mundu jwangapotola nchalaba gwakwe nu kungengama, kupaligwaje kube napunji jwango. ");
INSERT INTO nnq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mundu jwajoa ojwaagabala bwomi gwakwe, apakuoya na ojwaoya bwomi gwakwe kwa magambu gangu nenga, apakupata. ");
INSERT INTO nnq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Abampoke mangweto bamboke nenga, na abamboke nenga bapoke abandumite. ");
INSERT INTO nnq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mundu jwajoa ojwampoke nnondoli kwa magambu ga nnondoli, mapokela hupo yu ulondoli. Ojwampoke mundu jwa mwojo gwambone kwa magambu ga mwojo gwambone apokela upo ya mwojo gwambone. ");
INSERT INTO nnq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nannengelanga kweli, jwajoa ojwapakumpe mundu jumwe kati ja akachoko aba kata ja mache gukunywe gambu jwenio napunji jwango, apelelwaje kupoke hupo yakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu pajomola kapeganga akinapunji bakwe malagilo ngaboka penia, ngajenda kubola na katangachila bandu mwilambo yuku Galilaya. ");
INSERT INTO nnq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana Mmatichi pakiba mukipungo ngajoa ilebe yatenda Yesu Kilisto. Yohana ngabatuma akinapunji bakwe bankonye Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kulenga, “Bo, mwe nga jwajo ojwaika andaje tunnende jonge?” ");
INSERT INTO nnq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ngabajanga, “Nnyendange makannenge Yohana ilebe imijoa ni kibona, ");
INSERT INTO nnq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bangalola kulola, nangwaba kujenda, bina maloi batenda kujeguigwa na bangajoa kujoa, abawile kuyoka na akahocho katangachilanga Nhwalo Gwambone. ");
INSERT INTO nnq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mbaya mundu jwajo jwangabe na mbwele nane!” ");
INSERT INTO nnq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Akinapunji ba Yohana pabajabulanga, Yesu ngatumbu kalengelanga bandu minhalo ja Yohana, “Majendanga kulolanga nike kupongoti kola? Bo, mapala kilibona linyai elipoge mboga? ");
INSERT INTO nnq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lele nnyela kulola nike? Nnyela kunnola mundu ojwakwindite ngobo inakualala? Bandu abakwindite ngobo inakualala batamanga mumajumba gi kingwana. ");
INSERT INTO nnq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Unengelange nnyela kummona meneke? Nnondoli? Eluwe, kweli Yohana akiba kupeta nnondoli. ");
INSERT INTO nnq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jwenio nga ojwalengigwa Mumajandiko ga Chwapi. ‘Nnoongo alenga, mbakunkinga mmanda jwango, annongolele nu kumpanganakia ndela jinu.’ ");
INSERT INTO nnq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nannenge kweli, panakati ja ingota yoa eibelwike nu munkege anapitije ojwabi nkolongwa kumpeta Yohana Mmatichi. Nu uyo na jwajo ojwabi nchokochoko muno mukingwana chu kumbengu jwenio nga nkolongwa kumpeta Yohana. ");
INSERT INTO nnq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuboka kingobu cha Yohana mpaka ngoe, kingwana cha kumbengu kitoligwa na bandu bina makakala, na bandu bina makakala bapalanga kukitola kwa makakala. ");
INSERT INTO nnq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kuboka pukutumbula mpaka kingobu cha Yohana, akalondoli boa na Malagilo ga Musa galondola ilebe i kingwana chu kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Anda nhwotolinge kujeketela kube Yohana nga Eliya ojwalengigwa apakuika. ");
INSERT INTO nnq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Juna machikilo ajoe! ");
INSERT INTO nnq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bandu bangoe balandine na nike? Andi achakakombo abatamangite pachoko, bakalengelana kuboka kikuta chimwe kukilenge chenge, ");
INSERT INTO nnq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tunhwonalinge ng'oma nambu mangweto nhwinangitije! Tunnyembilinge minhambo jukokaleka mangweto nng'utangitije!’ ");
INSERT INTO nnq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohana ngaika, akiba kupunga na anywije divai, angweto ngabalenga, ‘Akweti nchepela.’ ");
INSERT INTO nnq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana jwa Mundu ngaika, kulye nu kunywe, angweto ngabalenga, ‘Mummone mundu ojo, kupojoka nu kulobela, nng'anja gwa akatocha kodi na bina mabaja!’ Nambu uwecho gwa Nnoongo ubonekana gwambone kuboka muitendwa yakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kubokapenia Yesu ngatumbu kakalapila bandu bi ilambo yatenda ikobo ijingi nambu bandu ba kwenio balapangitije mabaja gabe. ");
INSERT INTO nnq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kulaga mwe! Kilambo chu Kukolasini, kulaga kilambo chu Kubetisaida! Gambu ikobo yanatenda kachinu ilaigwe kukilambo chu Kutilo na Kusidoni bandu bakwe kabi bakwindangite ngobo ya magunia nu kupakala maliu kulaya balapite. ");
INSERT INTO nnq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nannenge kweli, ipakube kindema kwa bandu ba Tilo na Sidoni kuimbalila hukumu jabe lichoba lya hukumu, kupeta mangweto. ");
INSERT INTO nnq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na mwenga, ma Kafalanaumu, bo, mikitondabeya mpaka kumbengu? Manhwuluigwa mpaka kumambi! Gambu, ikobo yanatei kwinu yakatendigwe Kusodoma, kilambo chenie chakaba tango mpaka lele. ");
INSERT INTO nnq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nambu nannenge, lichoba lya hukumu mwenga mpakupata hukumu ngolongwa kupeta ja Kusodoma!” ");
INSERT INTO nnq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kingobu chenia Yesu ngalenga, “Nannumba mwe Mawawa, Mangwana bu kumbengu na padunia, magambu ilebe yene maiite bandu bunuwecho na bina malango, ngamaekulila akinangota. ");
INSERT INTO nnq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Elo, Awawa yene nga pampaile. ");
INSERT INTO nnq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Awabango bangamwiye ilebe yoa. Abije ojwammanyi Mwana nambu Awawa, na abije ojwabamanyi Awawa nambu Mwana, na jwajo ojwapai Mwana kunhwekulila. ");
INSERT INTO nnq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nhwike kwango mmowa mannaganga nu kutopiigwa ni miigo nenga manampomolea. ");
INSERT INTO nnq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mikitabange kingolingoli chango, mikibole kwango, gambu nenga nanuu nu kunyenyepa umwojo na mangweto mma na laa mumyojo jinu. ");
INSERT INTO nnq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gambu kingolingoli chango kakataje nu nhwigo gwango nnyojou.” ");
INSERT INTO nnq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kingobu chenie, Yesu akiba akapeta mumigonda ja ngano Lichoba li Kupomolela. Akinapunji bakwe ngabalola njala, ngabatumbu kuchwamula miejo ja ngano, ngabamemena. ");
INSERT INTO nnq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo pababonanga genia, ngabankonya Yesu, “Nnola, akinapunji binu batendanga kilebe changapaligwa mumalagilo gito Lichoba li Kupomolela.” ");
INSERT INTO nnq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu ngabajanga, “Bo, nchomangitije patenda Daudi pamwe nakajakwe kingobu apabakiba na njala? ");
INSERT INTO nnq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jwenio ngajingi unyumba ja Nnoongo ngalye mikate ejibekigwe nnongi ja Nnoongo. Jwenio na akajabe bapaligwije kulye mikate jenie nambu akakung'i tu. ");
INSERT INTO nnq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bo, nchomangitije kitabu cha Malagilo ga Musa agalenga kila Lichoba li Kupomolela akakung'i baalabia Malagilo gi Lichoba li Kupomolela unyumba ja Nnoongo, nambu babi kabalangije kutenda babi malemwa? ");
INSERT INTO nnq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bai, nannengelanga yene pambano abi nkolongwa kupeta nyumba ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Makagamanyi gangano, ‘Mbala kia ngiti lilumboje.’ Kabi mahukumwije bandu banga malemwa. ");
INSERT INTO nnq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gambu Mwana jwa Mundu akweti uwecho ata Lichoba li Kupomolela.” ");
INSERT INTO nnq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ngaboka penia ngajenda kunyumba jabe ji kugongalela. ");
INSERT INTO nnq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mweno akiba mundu jumwe ojwapolite luboko. Bandu ngabankonya Yesu, “Bo, ipaligwe kunnamia mundu Lichoba li Kupomolela?” Bakonya genia kupala kuntega alemwe bantakiane. ");
INSERT INTO nnq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nambu Yesu ngabalengela, “Tulenge kati jinu anda abi mundu jwakweti limbelele lyakwe elitumbakile mulichela, bo, ampukije nukumpia Lichoba li Kupomalela? ");
INSERT INTO nnq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nambu mundu nga jwambone kupeta limbelele! Ipaligwe kutenda gambone Lichoba li Kupomolela.” ");
INSERT INTO nnq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kubokapenia ngannenge mundujo, “Ntondobeye luboko lwinu.” Ngatondobeya, luboko ngululama ngulube andi longe. ");
INSERT INTO nnq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mafalisayo ngagapita panja ngababeka machabuli gu kunkoma Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nambu Yesu pamanya nhwalo gwenio ngaboka paali penia. Bandu ajingi ngabankengama, ngabalamiyanga akatamwe boa. ");
INSERT INTO nnq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ngabaamulicha kutenda bakalenge banduje minhalo jakwe, ");
INSERT INTO nnq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kupala galenga nnondoli Isaya galenganile, ");
INSERT INTO nnq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nnole mpakachi jwango junumpambwile, jwambala anhalalile kumwojo. Mbakubeka kihuke chango panani jakwe, jwenio atangacha hukumu jango kwa bandu bangammanya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Abeje nimitau wala manjega, wala lilobe lyakwe lijoanikaje undela. ");
INSERT INTO nnq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nnai ogubugujwike ntwekuje na lumuli oluchikichila aimiyaje, mpaka papakubeka hukumu ja chwapi jitawale. ");
INSERT INTO nnq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kwa jwenio bandu bangammanya Nnoongo babakube nilihyobalelo.” ");
INSERT INTO nnq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Penia bandu ngabannete Yesu mundu jumwe jwangalola na akiba bubu magambu akiba na nchepela. Yesu ngannamiya mpaka ngaotola kulola nu kulongela. ");
INSERT INTO nnq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nkengeni gwoa gwa bandu nguomongwa ngabalenga, “Pangaje ojo nga Mwana jwa Daudi?” ");
INSERT INTO nnq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nambu Mafalisayo pabajoa genia, “Ngabalenga mundu ojo abenga michepela ku uwecho gwa Belizebuli nkolongwa ju michepela.” ");
INSERT INTO nnq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu, amanyi mawacho gabe ngabalengela, “Kingwana chachoa anda kibaganike ikuta ikuta itumbakane, kujendeke yaka nduje, ni kilambo chachoa andaje lungolo lwalwoa lukibagine ikuta ikuta eijomana lupakugwe. ");
INSERT INTO nnq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Anda lichetani lijomana ni Lichetani lijakwe likitumbakania lyene kingwana chakwe kilamabo? ");
INSERT INTO nnq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mangweto nnengabo kutenda nijibenga michepela kwa makakala ga Belizebuli, abankengama mangweto babenga michepela kuwecho gwabeneke? Kwa magambu genia angweto nga abapakunhwukumula. ");
INSERT INTO nnq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nambu anda nijibenga michepela kwa makakala ga Uhuke jwa Nnoongo, mmanyanga kingwana cha Nnoongo kiike kwinu. ");
INSERT INTO nnq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Abije mundu ojwapakuoto kujingi munyumba ja mundu juna makakala nu kumpoka ilebe yoa, mpaka antabe oti mundu jwenio? Penia apakuoto kumpoka ilebe yoa. ");
INSERT INTO nnq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mundu jwajwoa jwanganonda nenga, angana nenga, na jwajoa jwangakongola pamwe na nenga, atenda kuambugana. ");
INSERT INTO nnq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa magambu genia nannenge bandu mabalekekeigwa mabaja na matukano gabe goa, nambu balekekeaje kwa mabaja gu kuntukana Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kabe, ojwalenga lilobe li kunkana Mwana jwa Mundu malekekiigwa, nambu ojwalenga lilobe li kunkana Uhuke jwa Chwapi, alekekeiigwaje, napaduniaje, na wala Kumbenguje. ");
INSERT INTO nnq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nkongo gwambone kupambika kwakwe makuba kwambone na nkongo mmaja kupambika kwakwe kuba kubaja. Nkongo umanyikana kukupambika ngokwa yakwe. ");
INSERT INTO nnq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mangwetomwe machamajoka nhwotwabo kulenga kilebe chambone na kongo mmene makabaja? Gambu mundu alonge agaboka umwojo. ");
INSERT INTO nnq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu jwambone apiya agabi gambone kuboka mumwojo gwakwe, na mundu mmaja apiya mabaja kuboka mumwojo gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nannengalanga, lichoba lya hukumu kila mundu apaligwa kujanga kila lilobe lyalongela lyangapaligwa. ");
INSERT INTO nnq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gambu kwa malobe ginu mannyeketeligwa kube mambone, na kwa malobe ginu manhukumigwa kube mabaja.” ");
INSERT INTO nnq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kuboka penia akaboli ba Malagilo ga Musa na Mafalisayo ngabannenge Yesu, “Aboli, tupala kuibona iingi yi ikobo kuboka kwinu.” ");
INSERT INTO nnq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“Jwombe ngabajanga bandu bangoe akabaja banga mmanya Nnoongo!” Bapala iingi yi ikobo bapatangaje, nambu bapata kikobo cha nnondoli Yona. ");
INSERT INTO nnq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kitama chatama Yona mulutumbo lwa chamaki machoba matatu kilo na mui, ngipipakube ku Mwana jwa Mundu papakutama nkati mulutope. ");
INSERT INTO nnq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bandu bi kilambo chu Kuninawi mabapitila kingobu cha hukumu, na angweto buluhukumula lungolo londo kube na malemwa. Gambu bandu ba Kuninawi balapanga kwa matangacho ga Yona, na pamba abi Nkolongwa kupeta Yona! ");
INSERT INTO nnq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Linyongolo lya kubanda mapitila mangobu bandu bamba pabapa kuhukumigwa, magambu jwenio ngaboka kachakwe kutaali ngaika kupenikia gambone ga Solomoni napamba abi nkolongwa kumpeta Solomoni. ");
INSERT INTO nnq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nchepela anda ubengigwe kwa mundu, utindila tindila papongoti pajomo kupala paali apomolele anda kupataje. ");
INSERT INTO nnq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Penia alongela jika, ‘Mambuja kachango kumokitage.’ Nambu pupakubuja nikijikole jibi janga kilebe jipyagiligwe nu ilekaileka, ");
INSERT INTO nnq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","aijenda kujitola jengi michepela saba, jinamakakala kupeta jwenio, na jwenio kuika kunnyingilila mundujo na ali ja mundu jwenio jibakube mbaja kupeta pitumbula. Ngipipakube ku bandu akabaja.” ");
INSERT INTO nnq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu akiba tango akalongela nankengeni gwa bandu kingobu amamundu ni inuna yakwe pabaika nu kujema panja. Bapala kulonge nakwe. ");
INSERT INTO nnq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bai mundu jumwe ngannenge, “Amabinu na inuna inu babi panja, bapala kulonge na mwe.” ");
INSERT INTO nnq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nambu Yesu ngannyanga mundu jwenio, “Amabango ngabeneke? Ni inuna yango nga beneke?” ");
INSERT INTO nnq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Penia ngatondobea luboko lwakwe kalangila akinapunji bakwe, ngalenga, “Angwetwa nga Amabango ni inuna yango! ");
INSERT INTO nnq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Jwajwoa ojwakamwa agabapala Awabango ababi kumbengu, jwenio nga nnuna gwango na nnombwango Amabango.” ");
INSERT INTO nnq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lichoba ulyo, Yesu ngaboka panyumba jenie, ngajenda kutama umbwega ji lilaba. ");
INSERT INTO nnq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ikuta ya bandu ngintindila mpaka Yesu ngaombe muntumbwi ngatama. Bandu boa bakajema umbwega ji lilaba, ");
INSERT INTO nnq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","penia Yesu ngabalenge malobe majingi kukulandanikia. “Mpenikiange! Mpandi ngajenda kumicha mbeju. ");
INSERT INTO nnq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pakiba akamicha mbeju, yenge ngitola pandela, ijuni ngiika ngionyola. ");
INSERT INTO nnq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yenge ngitola pamaganga pangabe nu lutope lujingi. Ngimalika chokwe magambu lutope lukiba lujingije. ");
INSERT INTO nnq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lumu pulubala ngijoma, na magambu mikega jakwe jikiba janga makakala, ngilembuka. ");
INSERT INTO nnq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yenge ngitola pimikongo jamiba, na miba ngikola nu kuibalakia. ");
INSERT INTO nnq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yenge ngitola pulutope lwa mbone, ngimalika na ngipambika muno, yenge mbonje mia jimwe, yenge sitini na yenge salasini. ");
INSERT INTO nnq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na juna machikilo ajoe!” ");
INSERT INTO nnq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Akinapunji bakwe ngabannyendelela, ngabankonya, “Mbona mwe nnonge na bandu kukulandanakia?” ");
INSERT INTO nnq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu ngabajanga, “Mangwetomwe nkweti upeele gu kumanya chili ji kingwana chu kumbengu, nambu angwetwa bakwetije.” ");
INSERT INTO nnq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Magambu mundu juna kilebe majonjekeigwa, nambu jwanga kola kilebe, na chache kichoko cha kweti kipakutoligwa. ");
INSERT INTO nnq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nganonge nabo ku kulandanakia, kwa magambu babi kulola nambu kuibonaje, babi kupenekia nambu kujoaje nu kumanyaje. ");
INSERT INTO nnq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwabe galenganile agalenga nnondoli Isaya, “ ‘Kupenakia mabapenakia, nambu bamanyangaje. Kulola mannola, nambu mibonaje. ");
INSERT INTO nnq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Magambu malango ga bandu bamba gapunganikwe, baibangite machikilo gabe, mio bachwilile gabe. Makaloile kwa mio ginu, andaje maka joine kwa machikilo ginu, makamanyi kwa malango ginu, nu kundendebukia, balenga Angwana, nane kabinalamiinge.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu ngalenga kabele, “Nambu mbaya mangweto, gambu mio ginu gabikulola na machikilo ginu gabikujoa. ");
INSERT INTO nnq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nannenge kweli, akalondoli ba Nnoongo na bandu bambone ajingi bapaile kugabona gamagabona, bakagabonaje, nu kugajoa gamagajoa, bakagajoaje. ");
INSERT INTO nnq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mangweto mpenakiange na mikibole kulandanakia kwa mpandi. ");
INSERT INTO nnq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mundu ojwajoa nhwalo gu Kingwana cha Nnoongo nu kuumanyaje, ngatela na mbeju eitoi pandela, Mmaja kuika nu kuboya chikipandigwe mumwojo gwa mundu jwenio. ");
INSERT INTO nnq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeju ipandigwe pamaganga andi mundu ojwajoa lilobe lya Nnoongo kulipokela chokwe nu kuala mwojo. ");
INSERT INTO nnq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nambu kolaje ngega nkati jakwe, aijendekea kuliagabala lilobe lyene kingobu tu, kingobu chu kulaga ni michwembo apajipitila magambu ga lilobe lyene, kuotwaje kujendekea. ");
INSERT INTO nnq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeju eitoi panakati ja miba andi mundu ojwajoa lilobe lyene, nambu kwa mbwele ja dunia na uloi kupala kulilimbalakia lilobe lyenie na jwenio kujendekeaje kulikengama. ");
INSERT INTO nnq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbeju eipandigwe pulutope lwa mbone andi mundu ojwajoa lilobe lyenie na kulimanya, nu kupambika ngokwa, bange mya na bange sitini na bange salasini.” ");
INSERT INTO nnq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ngabalenge bandu kulandanakia konge, “Kingwana chu kumbengu kilandine yene. Mundu ojwapandite mbeju yambone munng'onda gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nambu bandu pabakiba lugono, nngondwa jwakwe ngaika nukupanda manyai panakati ja ngano, nukujabula. ");
INSERT INTO nnq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mbeju pimalika nu kutumbu kubeula manyai ngagatumbu kubonekana. ");
INSERT INTO nnq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Akapakachi ba nkola nng'onda ngabannyendelela, nu kunnenge, ‘Angwana, mbemelela makapanda mbeju ya mbone munng'onda gwinu. Lele manyai gaboka koo?’ ");
INSERT INTO nnq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jwenio ngabajanga, ‘Nngondwa nga ojwatei yenie’. Akapakachi bakwe ngabankonya, ‘Bo, mpaile tujende takagajikule?’ ");
INSERT INTO nnq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Jwombe ngabajanga, ‘Ije, makatenda yeneje mannyikula manyai pamwe na ngano. ");
INSERT INTO nnq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Magaleke gakole pamwe mpaka pagapakuika mauno. Kingobu chenie nailengala akauni, nkongolange oti manyai ntabe makendeka nu kupamba mwoto. Nambu ngano nkongolange makabeke mikikokwe chango.’” ");
INSERT INTO nnq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu ngabalengela bandu kulandanakia konge, “Kingwana cha kumbengu kilandine yene. Mundu ngapanda mbeju njokonjoko, munng'onda gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yenie ibi mbonji njokonjoko kupeta mbeju yoa, nambu anda imalike iba ngolongwa kupeta ipandwa yoa. Ukola nukube nkongo nkolongwa ni ijuni yu kunani kuika kuchenga mihui mundambi yakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ngabalengela kulandanakia konge, “Kingwana cha kumbengu kilandine yene. Amama bamwe abatoi amila ngabatindagana na madebe mabele na nusu ga unga, penia unga gwoa ngutupa.” ");
INSERT INTO nnq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ngabalenge bandu genia goa kukulandanakia. Alongije chachoa panga landanakia. ");
INSERT INTO nnq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ibe ilenganile na lilobe lyalenga Nnondoli jwa Nnoongo. “Nongela nabo kukulandanakia, mbakupiya gangamanyikana kuboka pijipanganigwe dunia.” ");
INSERT INTO nnq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Penia Yesu ngatabuka bandu bala, ngajingi unyumba. Akinapunji bakwe ngabannyendelela ngabannengela, “Mutulandulile kulandanakia kwa manyai munng'onda.” ");
INSERT INTO nnq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu ngabajanga, “Mpandi jwa mbeju ya mbone nga Mwana jwa Mundu. ");
INSERT INTO nnq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nng'onda gola nga dunia. Mbeju ya mbone nga bandu ababi ba Kingwana cha Nnoongo nga chabe. Nambu manyai nga bandu bi Mmaja. ");
INSERT INTO nnq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nngondwa ojwapandita manyai gala nga Mmaja. Mauno nga kupela kwa ile yoa na akauni nga akapakachi ba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Andi yene manyai apagakonjaligwa nu kugapamba mwoto, ngapaipa kube lichoba lya kiama. ");
INSERT INTO nnq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana jwa Mundu mabakinga Akapakachi bakwe kuboka kumbengu bakongalange bandu kuboka mukingwana chakwe boa abajambukia ilebe ibaja, na boa abakamu mabaja, ");
INSERT INTO nnq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kalekela pilibomba lya mwoto kwenio bapakuguta nu kuyaga mino. ");
INSERT INTO nnq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Penia bandu bambone bala bapakung'ala andi lichoba mukingwana cha Awawa mundu. Juna machikilo ajoe. ");
INSERT INTO nnq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Kingwana chu kumbengu kilandine yene. Mundu jumwe ngaibona jaabu, ngaiya kabele. Ngaala mwojo muno, ngajenda kuucha ilebe yakwe yoa eyakiba nayo, ngajenda kuemela nng'onda gwenio. ");
INSERT INTO nnq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kabe Kingwana chu kumbengu kilandine yene mundu ojwapalapala lulu. ");
INSERT INTO nnq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Papata lulu jimwe ja mbone muno, ngajenda kuucha ilebe yoa eyakweti, ngaemela lulu jene. ");
INSERT INTO nnq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kabe, Kingwana cha kumbengu kilandine yene. Akakoki bange balekile lipelele mulilaba, ngilijonja yamaki ya aina ndu. ");
INSERT INTO nnq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pilitwelela, ngabaliuta pajomo ngabatama, kuchagula yamaki yambone ngababekanga mulipakacha yabe, yangambone ngabailekela. ");
INSERT INTO nnq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Paipakube lichoba lya kiama, akapakachi ba kumbengu bapitilanga babagana akabaja na bambone, ");
INSERT INTO nnq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na kalekela pamwoto bandu akabaja, kwenio bapakuguta nu kuyaga mino.” ");
INSERT INTO nnq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu ngakonya, “Bo, magamanyi genia?” Ngabajeketelanga, “Elo.” ");
INSERT INTO nnq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jwombe ngabalenge, “Aboli ba Malagilo ga Musa ababe napunji bi Kingwana chu kumbengu balandine na nkola nyumba ojwapiya munkoba gwakwe ilebe igona na iyono.” ");
INSERT INTO nnq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu pajomola kulenga kulandanakia kwenio ngaboka paali penia, ");
INSERT INTO nnq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ngabuja kachakwe. Kwenio ngabe bakabolanga bandu munyumba jabe ja kugongalela mpaka ngabaomongwa, ngabalenga. “Jwenio apatite ko malango aga? Na apatite ko makakala ga ukamula ikobo? ");
INSERT INTO nnq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bo, ojo mwana jwa pundi chalamala joje? Bo, amamundu Amaliamu na akakaka mundu acha Yakobo na Yusufu na simoni na Yuda? ");
INSERT INTO nnq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bo, akalombo mundu babilingiteje upamba na twenga? Lele, apatite ko genia goa?” ");
INSERT INTO nnq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngababe na mbwele nakwe. Nambu Yesu ngabalengela, “Nnondoli kupataje ichima kachakwe na kubandu bakwe nambu kubandu bange, kupata ichima.” ");
INSERT INTO nnq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nayene penia alaiteje ikobo ijingi kwa magambu gwangaamini gwabe. ");
INSERT INTO nnq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kingobu chenie, Helode ojwakiba Nngwana jwa kilambo cha Galilaya, ngajoa yoa yakamula Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ngabalenge akapakachi bakwe, “Mundu ojojo nga Yohana Mmatichi, atekuyoka kuboka kwa abawile, nga magambu makakala gi ikobo ikamu maengo nkati jakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helode nga ojwaamulicha kuntaba Yohana mikipungo, ngantaba mitondolo na kummeka mikipungo kwa magambu ga Helodia, jwenio akiba nhwana gwa nnuna gwakwe Filipo. ");
INSERT INTO nnq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gakiba mangobu Yohana akannenge Helode, “Ipaligweje mwenga kutola munkege ojo kube nhwanagwinu!” ");
INSERT INTO nnq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode ngapala kunkoma Yohana, nambu ajogopa bandu magambu Yohana akiba Nnondoli jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lichoba lya mpapala gu kombokela kubelekwa kwa Helode, kamwale jwa Helodia atekuina nnongi ja akageni. Helode ngaala mwojo, ");
INSERT INTO nnq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mpaka Helode ngalagana kumpe kamwali jwenio kilebe cha chochoa chapa kujopa mapata. ");
INSERT INTO nnq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na kongo amamundu bakankwelekeya, ajope ngajopa, “Umbe upamba mutwe gwa Yohana Mmatichi mulichinia.” ");
INSERT INTO nnq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nngwana Helode ngaechuka nambu kwa magambu gu kulapila kwakwe na kwa magambu akageni bampapala ngaamulicha apate. ");
INSERT INTO nnq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Helode ngantuma mundu, ajende mukipungo akanhwekete mutwe Yohana. ");
INSERT INTO nnq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mutwe gwakwe nguletigwa mulichinia, ngabampe kamwale jwenio, jwombe ngabapeleke amamundu. ");
INSERT INTO nnq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Akinapunji ba Yohana ngabaika, ngabatola mmele gwa Yohana ngabachika. Kuboka penia ngabajenda kunnandulila Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu pajoa genia, ngaboka paali penia muntumbwi, ngajenda paali pantemela nambu bandu ngabamanya ngabankengama kuboka muilambo. ");
INSERT INTO nnq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Apauluka muntumbwi, ngaubona nkengeni nkolongwa gwa bandu, ngababone kia, ngabalamiya akatamwe babe. ");
INSERT INTO nnq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Piika kimuyo, akinapunji bakwe ngabannyendelela ngabannenge, “Pamba papongoti, na ngoe kutipike, maleke bandu bajabule kiilambo yabe bakaemele yakulya.” ");
INSERT INTO nnq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ngabajanga, “Bakajabulangaje, mapegange mangweto ilyo.” ");
INSERT INTO nnq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nambu angweto ngabannenge, “Tukweti mikate nhwano tu na yamaki ibele.” ");
INSERT INTO nnq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu ngalenga, “Unetelange pamba.” ");
INSERT INTO nnq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ngabaamulicha bandu batame pae pamanyai. Penia Yesu ngatola mikate nhwano jela na yamaki ibena yela, ngalola kunani kumbengu, ngannumba Nnoongo. Kuboka penia ngametula mikate, ngabape akinapunji bakwe, na akinapunji bakwe ngababaganakia bandu. ");
INSERT INTO nnq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bandu boa ngabalye nu kujukuta. Kuboka penia akinapunji ngabalokota imbolopolo iigile ngabatwele ikapo komi ni ibena. ");
INSERT INTO nnq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abalilangite bakiba akinalome elufu nhwano pangabalanga akikege ni ingota. ");
INSERT INTO nnq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kingobucho, Yesu ngabalengela akinapunji bakwe baombe muntumbwi, balongalele kwiye jililaba kingobu mwene bannekite akatabuka bandu. ");
INSERT INTO nnq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kuboka pakatabuka bandu ngaombe pikitombi jika jakwe kunng'ongalela Nnoongo. Piika kimuyo, jwenio akiba kwenio jika jakwe, ");
INSERT INTO nnq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na kingobu ntumbwi gwenio puika panakati ji lilaba, nambu ngube mukomo gambu gu upepo gukaibi ntumbwi gwenio. ");
INSERT INTO nnq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kilo kupabandakila kuche Yesu ngabajendelela akinapunji bakwe akajenda panani ja mache. ");
INSERT INTO nnq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Akinapunji bakwe pabammona akajenda panani pamache ngabajogopa muno, ngabalenga, “Lihoka” ngabachobela chamila kwa mbwele. ");
INSERT INTO nnq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kingobu ucho Yesu ngalonge nabo, “Nkotokange, nga nenga. Makajogopaje!” ");
INSERT INTO nnq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo ngannengela Yesu, “Angwana, anda kweli mwenga unenge ne nyende panani ja mache nhike kwenio.” ");
INSERT INTO nnq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu ngannengela, “Aja, nhwikage.” Petulo ngauluka muntumbwi, ngajenda panani pa mache, ngannyendele Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nambu paubona upepo gola, ngajoboka, ngatumbu kumilwa, ngaguta kulilobe likolongwa “Angwana, ungole!” ");
INSERT INTO nnq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Penia Yesu ngatondabeya luboko lwakwe, ngankamula nu kunnenge, “Mwe mammi na imani njokochoko! Mbone nnoila mbwele?” ");
INSERT INTO nnq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kubokapenia ngabaombelanga muntumbwi, nu upepo ngukotoka. ");
INSERT INTO nnq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Akinapunji boa abakiba nkati ja ntumbwi ngaba nng'ongolela ngabalenga “Kweli mwenga ma Mwana jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ngabajomboka lilaba, ngabajenda Kugenesaleti. ");
INSERT INTO nnq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bandu ba kwenio ngabamanya kutenda jwenio nga Yesu. Ngabalandulila ngijoanika, kilambo choa, ngabannetela akatamwe boa. ");
INSERT INTO nnq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ngabannyopa bankunyule lubiniko lwa ngobo jakwe, na penia boa abankunywile ngabalama. ");
INSERT INTO nnq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Penia Mafalisayo na akaboli ba Malagilo ga Musa ngabaika kuboka kukilambo cha Kuyelusalemu, ngannyendelela Yesu, ngabankonya, ");
INSERT INTO nnq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mboni akinapunji binu kagaagabaje Malagilo gatupokila kuboka kwa akaokobito? Ukuyanga kwa mboneje maboko tango nukulyeje!” ");
INSERT INTO nnq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu ngabajanga, “Mboni mangwetumwe kuagabaje Amuli ja Nnoongo nambu kugapala maboulo ginu mmene? ");
INSERT INTO nnq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nnoongo alenga, ‘Kajoa awabinu na amabinu,’ Na ‘Jwajoa ojubatukana awamundu andaje amamundu akomigwe.’ ");
INSERT INTO nnq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nambu mangwetumwe mmolananga yene anda mundu anda akweti kilebe chakape awamundu andaje amamundu, nambu anda alengite ‘Kilebe chenje nampi Nnoongo.’ ");
INSERT INTO nnq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ipaligwije kabele kajoa awamundu andaje amamundu! Penia nga pimililemwa lilobe lya Nnoongo ku ukengama malagilo ginu mmene. ");
INSERT INTO nnq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mangweto mamikitenda mambone! Isaya alondola tela pammile! ");
INSERT INTO nnq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nnoongo alenga, ‘Bandu aba bannyali kwa malobe tu, nambu myojo jabe jibi kutaali nane. ");
INSERT INTO nnq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kung'ongale kwabe kwambonije, mana ilebe ibabolana nga malagilo ga bandu tu, benia bakitanga gangonenga!’ ” ");
INSERT INTO nnq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu ngaukema nkengeni gwa bandu, ngaulengela, “Umbenekiange na mmanyange! ");
INSERT INTO nnq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kilebe echikimmeka mundu mumalemwa chekijingi mukanoje, nambu chache echikipita mukano chenie nga echammeka mundu mumalemwa.” ");
INSERT INTO nnq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Penia akinapunji bakwe ngabannyendelela ngabannengela, “Bo, mwe mmanyi kube Mafalisayo bakate kuchimwanga pabagajoa malobe ginu?” ");
INSERT INTO nnq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nambu Yesu ngabajanga, “Kila kipando changa panda Awawa bango bukumbengu, kipakujikuligwa.” ");
INSERT INTO nnq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Malekange bene akangweto! Angweto banga lola, akilongoi ba bangalola, na jwangalola anda annongalie jwangalola, boa mabatumbukila mulibomba.” ");
INSERT INTO nnq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo ngalenga, “Mutulandulile kulandanakia kwenio.” ");
INSERT INTO nnq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu ngalenga, “Namangwetumwe mmanyije? ");
INSERT INTO nnq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bo, mmanyangitije kutenda kilebe chachoa chikijingi mukano kijenda mulutumbo na mwenakandae kupita panja kucholo? ");
INSERT INTO nnq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nambu ilebe eipita mukano kujenda panja iboka umwojo na yenie nga eimmeka mundu mumalemwa. ");
INSERT INTO nnq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gambu umwojo gaboka mawacho mabaja, na ngongola, na malaya, na kujiba, na uwangi na matukano. ");
INSERT INTO nnq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Genia nga agammeka mundu kube nchapu. Nambu kulye ilyo pangakuya maboko anda apabalagila nkamulange, genia gammekaje mundu kube nchapu.” ");
INSERT INTO nnq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu ngaboka paali penia ngajenda kutama kukilambo chu Kutilo na Kusidoni. ");
INSERT INTO nnq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Amama bamwe kabila ja Kanaani ba kilambo chenie ngabanhwikalila, ngatondabea lilobe, “Angwana, mwana jwa Daudi, umone kia! Kamwale jwango alaga na nchepela.” ");
INSERT INTO nnq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nambu Yesu annyangiteje lilobe. Akinapunji bakwe ngabannyendelela, ngabannenge, “Maleke bajabule kachabe magambu butukengama kengama kupeta kuchobela.” ");
INSERT INTO nnq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu ngajanga, “Bandumiteje nambu kunyumba ja bandu bikilambo chi Kuisilaeli abaobite andi mambelele.” ");
INSERT INTO nnq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Penia amama benia ngabaika, nu kikileke pae ja makongono gakwe, ngabalenga, “Angwana ungole.” ");
INSERT INTO nnq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ngajanga, “Chwapije kutola yakulya yi ingota nu kiilekele imbwa.” ");
INSERT INTO nnq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Benia ngabajanga, “Kweli, Angwana, nambu ata imbwa kulye imbolopolo eitola kuboka pa mecha ja akaokamundu.” ");
INSERT INTO nnq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Penia Yesu ngabajanga, “Amama, imani jinu ngolongwa! Itendi uyo kwinu andi pampala.” Na kingobucho kamwale jwakwe ngalama. ");
INSERT INTO nnq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ngaboka penia ngajenda umbwega ja lilaba lya Galilaya, ngaombe pikitombi, ngatama. ");
INSERT INTO nnq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bandu ajingi muno ngabanhwikalila, nukunnetela abalemile na bangalola na nangwaba na akabubu na bange ajingi abakiba akatamwe, ngababeka nnongi ja makongono gakwe, na jwombe Yesu ngabalamiya. ");
INSERT INTO nnq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nkenga gwa bandu gwenio nguomongwa muno pababonanga akabubu bakalongela, abalemile balamite na nangwaba bakajenda na bangalola bakalolanga, bandu ngabannumba Nnoongo jwa Kuisilaeli. ");
INSERT INTO nnq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ngabakema akinapunji bakwe, ngalenga, “Nabone kia bandu aba magambu babilangite pamwe nane machoba matatu, na wala bakwetangiteje chakulya. Mbaije kalekanga bajabule pangalye chakulya, ngana kuindukanga undela.” ");
INSERT INTO nnq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Akinapunji ngabankonya, “Pamba tubi papongoti, tupata koo chakulya cha kape bandu ajingi anda aba?” ");
INSERT INTO nnq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ngabakonya, “Nkwetangite mikate milenga?” Ngabajanga “Saba na yamaki njoko.” ");
INSERT INTO nnq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu ngabaamulicha bandu batamange pae. ");
INSERT INTO nnq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ngajitola mikate saba na yamaki, ngannumba Nnoongo ngametula ngabape akinapunji, bombe ngababaganakia bandu. ");
INSERT INTO nnq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Boa ngabalye nukujukuta. Kuboka penia ngabalokota imbolopolo ngitwele ikapo saba. ");
INSERT INTO nnq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Angweto abalilangita akinalome bakibanga elufu ncheche, pangabalanga akikege ni ingota. ");
INSERT INTO nnq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu ngabatabukanga, ngabaleka nu kuombe muntumbwi, ngajenda kingonu cha kilambo cha Magadani. ");
INSERT INTO nnq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo ngabannyendele Yesu, kupala kuntega ngabannyopa balaye iingi yi ikobo kuboka kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nambu Yesu ngabajanga, “Anda iike kimuyo mangweto kulenga, ‘Kunanioko kubi jegwa kuba kuche gwicho, magambu kunani kukele,’ ");
INSERT INTO nnq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na kindabindabi kulenga, ‘Ula majikoma, magambu maunde gabi titili.’ Mangwetomwe kumanya muno iingi yu kugalambuka machoba kukulola kunani, nambu kumanyaje mangobu ganga. ");
INSERT INTO nnq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bandu bangoe akabaja! Bapala iingi yi ikobo, nambu kipataje kikobo chachoa ila kikobo cha Yona.” Ngabalekanga ngajabula. ");
INSERT INTO nnq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Akinapunji bakwe kuboka pa kujomboka kwiye ja lilaba ngaba kombakela kutenda batekulibalila kupoto mikate. ");
INSERT INTO nnq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu ngabalengela, “Mmegange mio na ntamanga maha na maboulo mabaja ga Mafalisayo na Masadukayo.” ");
INSERT INTO nnq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nambu angweto ngabataukana, “Balenga genia kwa magambu tupotwije mikate.” ");
INSERT INTO nnq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu ngamanya mawacho gabe, ngabalenge, “Mangwetomwe mmi na myojo michoko! Mboni nkonyana nhwalo gwangakola mikate? ");
INSERT INTO nnq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bo, mmanyangiteje tango? Mmikombakeje panametula mikate nhwano magambu ga bandu elufu nhwano? Bo, makatweleya ikapo ilenga ya imbolopolo? ");
INSERT INTO nnq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na mikate saba jela jabalya bandu elufu ncheche, bo, makalokota ikapo ilenga ya imbolopolo? ");
INSERT INTO nnq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mboni manamanyangaje kube nongila nhwalo gu mikateje? Ntamanga maha na maboulo mabaja ga Mafalisayo na Masadukayo!” ");
INSERT INTO nnq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Penia akinapunji ngabamanya goa kube balengila batame maha na maboulo mabaja ga Mafalisayo na Masadukayo. ");
INSERT INTO nnq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu paika kukilambo cha papipi na Kukaisalia okwo Kufilipi, ngabakonya akinapunji bakwe, “Bandu balenga Mwana jwa Mundu nga meneke?” ");
INSERT INTO nnq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngabannyanga, “Bange balenga mwe Yohana Mmatichi, na bange Eliya, na bange Yelemia andaje jumwe kati ja Akalondoli.” ");
INSERT INTO nnq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu ngabakonya, “Na mangweto bo, nnenga ne nabeneke?” ");
INSERT INTO nnq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulo ngajanga, “Mwenga nga Kilisto Mwana jwa Nnoongo ojwabi mmomi.” ");
INSERT INTO nnq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu ngalenga, “Mbaya mwenga Simoni mwana jwa Yona, gambu munduje ojwanhwekule kumanya kilebe chenje, nambu Awawa bango ababi kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nane nannenge mwe, Petulo, panani ja liganga lende mbakubeka kikuta cha bandu abunhwamini Kilisto, na milyango ju kumambi jaotwaje. ");
INSERT INTO nnq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mbakumpe mbungulo ya Kingwana chu kumbengu, chachoa champakutaba padunia nu kumbengu uyo kitabigwe, na champakulugula padunia nu kumbengu uyo kibakuluguka.” ");
INSERT INTO nnq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Penia Yesu ngabakelebuya akinapunji bakwe bakannengeje mundu kutenda jwombe nga Kilisto. ");
INSERT INTO nnq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuboka kingobu chenie Yesu ngatumbu kalenge kipola akinapunji bakwe, “Mpaka nyende oti Kuyelusalemu na kwenio mbakupotekigwa muno kuboke kakinanhota na akakung'i akolo na akaboli ba Malagilo ga Musa. Mbaukomigwa, nambu lichoba lya tatu mayoigwa.” ");
INSERT INTO nnq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Penia Petulo ngantola pantemela, ngatumbu kunkalapila, “Ikabe yeneje Angwana! Nhwalo gongo gumpataje mwe!” ");
INSERT INTO nnq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nambu Yesu ngatendebuka ngannenge Petulo, “Malichetani mmuje unyuma jango! Mwe ntenda kunhwibilikia. Mawacho ginu ga Nnoongoje nambu ga mundu.” ");
INSERT INTO nnq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kuboka penia Yesu ngabalenge akinapunji bakwe, “Mundu jwajoa anda apala kube ndundame jwango, mpaka oti akikane mwene na aupotole nchalaba gwakwe na angengame. ");
INSERT INTO nnq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gambu mundu ojwapala kukombola bwomi gwakwe mwene apakuoya, ");
INSERT INTO nnq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","nambu mundu ojwapakuoya bwomi gwakwe kwa magambu gango nenga, maupata. Bo, mundu apakukikonja anda apatite ile yoa ya padunia na kongo aoite bwomi gwakwe? Andaje mundu apakupanga nike kibe bada ja bwomi gwakwe? ");
INSERT INTO nnq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gambu, Mwana jwa Mundu apakuika mukibumo cha Awawa mundu pamwe na akapakachi bakwe bu kumbengu, na penia nga papakunnepa hupo yakwe kila mundu tela na itendwa yakwe. ");
INSERT INTO nnq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nannenge kweli, babile bandu upamba bijomokaje pangammona Mwana jwa Mundu akaika mukingwana chakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kuboka pa machoba sita, Yesu ngabatola Petulo na Yakobo na Yohana ununagwakwe, ngabajenda nabo jika jabe mpaka kukitombi kitandamau. ");
INSERT INTO nnq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kwenio, pabannolekea ngabammona Yesu ngagalambuka kumio nnongi jabe, kumio jakwe ngukung'ala anda lichoba na ngobo yakwe ngibe nhuu anda lumuli. ");
INSERT INTO nnq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kwenio Musa na Eliya ngabapitila, ngababe bakalongela nakwe Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Penia Petulo ngannenge Yesu, “Angwana, chwapi twe kube pamba! Anda mpaile njenga iteba itatu chimwe chinu, chimwe cha Musa na chimwe cha Eliya.” ");
INSERT INTO nnq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pakiba tango akalongela, liunde liuu ngilyaekelelanga, na lilobe ngilijoanika kuboka muliunde lyenie. “Jonjo nga Manango jwanampala, ojwanhalali mwojo, mampenakiange jwenio!” ");
INSERT INTO nnq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Akinapunji pabalijoa lilobe ngabagweganga manguku, ngabajogopa muno. ");
INSERT INTO nnq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu ngabajendelela, ngabakunyula, ngalenga “Nnyemange, makajogopaje!” ");
INSERT INTO nnq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pabalola kunani bammwenije mundu, nambu Yesu jikajakwe. ");
INSERT INTO nnq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pabaulukanga pikitombi, Yesu ngabakelebuya, “Makannengeje mundu ilebe eimibweni mpaka Mwana jwa Mundu papakuyoigwa kuboka kwa abawile.” ");
INSERT INTO nnq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kuboka penia akinapunji bakwe ngabankonya Yesu, “Mboni aboli ba Malagilo ga Musa balenga kita mpaka oti Eliya aike?” ");
INSERT INTO nnq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ngabajanga, “Kweli, Eliya atenda kuika kubeka ilebe yoa telatela. ");
INSERT INTO nnq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nambu nannengelanga Eliya aike na bandu bammanyije, ngabantenda pabapalanga. Mwana jwa mundu apakupotekigwa uyo mumaboko gabe.” ");
INSERT INTO nnq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Penia akinapunji bakwe ngabamanyanga kube balandulila nhwalo gwa Yohana Mmatichi. ");
INSERT INTO nnq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pabanhwikalila kabele nkengeni gwa bandu, mundu jumwe ngannyendelela Yesu, ngakilakitila nnongi jakwe, ");
INSERT INTO nnq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ngalenga “Angwana, mammone kia manango magambu akweti kiinduindu, kabe alaga muno, jwombe pa jingi agwele pamwoto nu umache. ");
INSERT INTO nnq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nganalete akinapunji binu, nambu baotwije kunnamiya.” ");
INSERT INTO nnq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ngabalengela, “Mangweto mabandu banga imani! Ndama namangweto mpaka lii? Nanhwimbilila mpaka lii? Mannetange mwano pamba!” ");
INSERT INTO nnq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu ngaukalapila nchepela, na gwenio nguboka na mwana ngalama kingobucho. ");
INSERT INTO nnq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kuboka penia akinapunji ba ngabannyendelela Yesu kuntemela, ngabankonya, “Mboni twe tuotwije kuuboya nchepela gola?” ");
INSERT INTO nnq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ngabajanga, “Kwa magambu nkwetije imani.” Nanenge kweli makabi na imani njokochoko andi mbeju ya aladali kabi nhwotolinge kukilenge kitombi, “Mmoke pamba nnyende papa, na chenie kujenda. Makaotolinge ukamwa kila kilebe!” ");
INSERT INTO nnq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nambu genia kuwechekanaje mpaka kupunga na kugongalela. ");
INSERT INTO nnq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pabakiba pamwe okwo kikilambo cha Galilaya, Yesu ngabalengela, “Mwana jwa Mundu ajenda ukamuigwa ku bandu. ");
INSERT INTO nnq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bapankoma nambu lichoba lya itatu mayoka.” Akinapunji ngabaechuka muno. ");
INSERT INTO nnq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pabaika kukilambo cha Kafalanaumu bandu ba ukongola uloi gwa kodi ja Nyumba ja Nnoongo ngabanyendelela Petulo, ngabankonya “Bo, Aboli binu babi kulepa kodi?” ");
INSERT INTO nnq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo ngajanga, “Umwo, babi kulepa.” Petulo pajingila unyumba, tango nukulongeje, Yesu ngankonya, “Simoni mwe nnolabo? Mangwana ga padunia gakongola kodi kuboka kubeneke? Kuboka kwa akakola Kilambo andaje kuboka kwa akageni?” ");
INSERT INTO nnq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo ngajanga, “Kuboka kwa akageni” Yesu ngannengela, “Aja ngayene, akakola Kilambo bapaligweje kulepa. ");
INSERT INTO nnq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nambu kukupala bakachimwaje, nnyende kulilaba makabeke ndoana, ntola chamaki ju kutumbula kolwa nhwekula kano jakwe, na nkati mukolela uloi tela na kulepa kodi. Ntola kwa magambu gangu nenga na magambu ginu mwenga.” ");
INSERT INTO nnq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kingobu chenie akinapunji ngabannyendelela Yesu, ngabankonya, “Bene ababi akolongwa kukingwana cha kumbengu?” ");
INSERT INTO nnq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu ngankema mwana jumwe, ngannyemeka nnongi jabe, ");
INSERT INTO nnq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","penia ngalenga, “Nannenge kweli, anda nu kugalambukaje nukube andi ingota, nnyingije Mukingwana cha kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jwajoa ojwakibeka nuu mwene nukube andi mwana ojo, nga nkolongwa mukingwana chu kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jwajoa ojwampokela mwana jumwe andi ojo ku liina lyango, amboke nenga. ");
INSERT INTO nnq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Jwajoa ojwapa kukunnyambuki jumwe jwa akachoko kujileka imani, ikabi mbaya bantabalile liganga lya kuyagila muntandala nu kuntumbukia mubaali. ");
INSERT INTO nnq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kabe nnyo mabandu bapadunia kabeke ipengu bandu abajeketile na bange buleke mojo! Ipengu mpaka ipitile nambu kulaga kwa mundu jwenio ojwapakijambuki ipitile! ");
INSERT INTO nnq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Anda luboko andaje lukongono lwinu lupakummeka ipengu, muluekete nu kululeke kutaali! Mbaya kwinu kujingila mubwomi manga luboko au lukongono telaje nu kulekeligwa pamwoto gwa ngaimika machoba goa pangapela, kongo mmi na maboko na makongono goa mabele. ");
INSERT INTO nnq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na lio linu anda lipa kumpeleya, muliboye nulekela kutaali na mwe. Mbaya mwe kujingi mubwomi mmi na chongo, telaje nu kulekeligwa pamwoto gwangaimika machoba goa kongo mmi na mio goa mabele. ");
INSERT INTO nnq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ntama maha! Makammembulaje jumwe kati ja angwetwa achoko. Nannenge, Akapakachi babe ba kumbingu babilangite kila kingobu nnongi ja Awawa ababi Kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gambu Mwana jwa mundu aika kakombolanga abaobite. ");
INSERT INTO nnq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nnolanga bo? Mundu anda akweti mambelele mia jimwe, anda liobite limwe, atenda bo? Kugaleka gaga makomi tisa na tisa kukitombi, kujenda kulipala lyale eliobite. ");
INSERT INTO nnq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anda alipatite, nannenge kweli, apakuala mwojo muno kupeta tisini na tisa gangaoba na tisa. ");
INSERT INTO nnq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Uyo, Awawa binu ba Kumbengu kupalaje kuoba najumweje panakati angwetwa akachoko. ");
INSERT INTO nnq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mundu anda annemwite, munyendelele muka nkelebuye kiti mmilangite makangweto jika. Anda anyoine mumpatite nnyinu. ");
INSERT INTO nnq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Anda anyoineje, muntola mundu jumwe au abena pamwe na mwe kupala kwa malobe ga akachaili abena andaje atatu kila kilebe kiba tela. ");
INSERT INTO nnq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Anda kunyowangaje mangweto, mikilengala kikuta cha bandu abunhwamini Kilisto. Na aba kwinu andi mundu jwanga mmanya Nnoongo na akatocha kodi. ");
INSERT INTO nnq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nannenge kweli, champakutaba padunia nu kumbengu uyo kitabigwe, na champakulugula padunia nu kumbengu uyo kibakuluguka. ");
INSERT INTO nnq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kabe nannenge, makabena anda nnyeketaline padunia pano kukilebe chachoa champakujopa kilebechenie Awawa bango ba kumbengu mabatenda kilebe chenie. ");
INSERT INTO nnq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mana papoa pala pabakongana abena au atatu kwa liina lyango, nne mbi upo panakati jinu.” ");
INSERT INTO nnq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kuboka penia Petulo ngannyendelela Yesu, ngankonya, “Angwana, bo nnunugwango anda anemwite nannekekeya palenga? Pasaba?” ");
INSERT INTO nnq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ngannyanga, “Nnenga pasaba tuje,” nambu pasaba mala pasabini. ");
INSERT INTO nnq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nga magambu Kingwana chu kumbengu kilandine na Nngwana jumwe ojwakagula ichabu ya akapakachi bakwe. ");
INSERT INTO nnq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Patumbula kagula, ngabannetela mundu jumwe juna ligambo lya talanta elufu komi. ");
INSERT INTO nnq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mundu jwenio akwetije chukulepa, penie Angwana ngabaamulicha auchigwe, jwenio na aanamundu, ingota ni ilebe yoa eyakweti, kupala ligambo lilepigwe. ");
INSERT INTO nnq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Penia, mpakachi jwenio ngakilikatila nnongi jabe ngalenga, “ ‘Nhwimbalile, ne manannepa ligambo lyango lyoa.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Angwana benia ngabankole kia, ngabannekekeya ligambo lyoa, ngabanneka ajabule kachake. ");
INSERT INTO nnq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nambu mpakachi jwenio ngaboka, ngankolela mpakachi nnyakwe ojwakiba ni ligambo nakwe dinali mya jimwe. Ngankamula pantandala ngalenga, ‘Nnepe ligambo linu!’ ");
INSERT INTO nnq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mpakachi nnyakwe jwenio ngakilikatila ngannyopa, ‘Nhwimbalile nanji manannepage.’ ");
INSERT INTO nnq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nambu jwenio ajeketileje ngabantaba mikipungo mpaka papakulepa ligambo. ");
INSERT INTO nnq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Akapakachi ajabe pabagabona ngabakokaleka muno, ngabajenda kalenge Angwanamundu nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Penia Angwana ba ngabankema mpakachi jola, ngaba nnenge, ‘Mwenga mapakachi mabaja muno!’ Ngunyopa, nane ngununekekeya ligambo linu lyoa. ");
INSERT INTO nnq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","‘Bo, ipaligweje namwe kummone kia mpakachi nnyinu andi ne panankolila kia.’ ");
INSERT INTO nnq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Penia Angwana benia ngabachimwa muno, ngabantaba mukipungo mpaka papakulepa ligambo lyoa.” ");
INSERT INTO nnq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu ngajomole kulenga, “Yene uyo Awawa bango bukumbengu pabapa kuntenda kila mundu anda kalekekea akajinu kumwojo gwinu gwoa.” ");
INSERT INTO nnq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu pajomola kulenga malobe genia, ngaboka kukilambo chuku Galilaya, ngajenda kukilambo chuku Yudea, kwiye ja lukemba lwa Yolidani. ");
INSERT INTO nnq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nkenga gwa bandu ngugunkengama kwenio, jwombe ngabalamiyanga abakiba ni itamwe. ");
INSERT INTO nnq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Gange Mafalisayo ngaganhwikalila, ngagajiga kunkonya kukuntega, “Bo, ipaligwije mundu kaleka aanamundu kwa malemwa gagoa gala?” ");
INSERT INTO nnq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ngabajanga, “Bo, nchomangiteje Majandiko Gachwapi kutenda pukutumbula Nnoongo ojwampangania mundu akammeka munalome nu munkege. ");
INSERT INTO nnq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Penia Nnoongo ngalenga, ‘Kwa magambu genia mundu baleka awamundu na amamundu, aba pamwe na aanamundu, na benia baba bamwe.’ ");
INSERT INTO nnq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nayene benia abena kabeje nambu mmele gumwe. Bai chalondine Nnoongo mundu akikilekaniaje.” ");
INSERT INTO nnq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nambu Mafalisayo ngagankonya, “Mboni Musa atujeketile analome kaandaki talaka aanamundu na kaleka?” ");
INSERT INTO nnq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu ngabajanga, “Musa annyeketile kaleka akaanabinu magambu gu kujundupa kwa myojo jinu. Nambu ikiba yeneje kingobu cha pangania dunia. ");
INSERT INTO nnq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nannengelanga, mundu jwajwoa anda balekite aanamundu nukutola bange atenda ngongola, nambu kwale ibe munkege jwenio akiba nngongola.” ");
INSERT INTO nnq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Akinapunji bakwe ngabannengela, “Anda ibi yene nhwalo gwa analome na akege, mbaya ukotoka kutola akege.” ");
INSERT INTO nnq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu ngabalengela, “Boaje abaotwile kulipokela lilobe lyene, nambu baba tu Nnoongo ababekigwe kutama uwolo. ");
INSERT INTO nnq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gambu ibi ilebe ijingi ibabeka bandu bakotoke kutola akege, bange kwa magambu kibelekwa, bange kwa magambu ga bandu babekite kube yenela, na bange baamulinge bene akangweto kutolaje akege kwa magambu ga Kingwana cha Kumbengu. Ojwaotwile kulipokela lilobe lyenie alipokela.” ");
INSERT INTO nnq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Penia Yesu ngabannetela ingota ichokoichoko aibeke maboko aigongalele, nambu akinapunji bakwe ngabaikelebuya. ");
INSERT INTO nnq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu ngalenga, “Mileke ingota iike kwango mikiikanakiaje, magambu Kingwana cha kumbengu cha bandu ababi andi ingota yene.” ");
INSERT INTO nnq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ngaibeke maboko kuboka penia ngaboka penia. ");
INSERT INTO nnq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu jumwe nganhwikalila Yesu, ngankonya, “Aboli, ndenda kilebe nike chambone nupate bwomi gwa machoba goa pangapela?” ");
INSERT INTO nnq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu gannengela, “Mboni mwe ungonya nhwalo gwa kilebe echikibi chambone? Abi jumwe tu jwambone. Andampala kujingila mubwomi gwa machoba goa pangapela magajali malagilo ga Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mundu jola ngankonya, “Malagilo gako?” Yesu ngajanga, “Makakomaje na ngongolaje na makajibaje na makabe machaili ba unhwangije, ");
INSERT INTO nnq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","majoe awabinu na amabinu, na mumpale nndami nnyinu anda pimikipala mmene.” ");
INSERT INTO nnq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kakombo jwenio ngannenge Yesu, “Genia goa nagaagabile, ndenda nike chenge?” ");
INSERT INTO nnq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu ngannengela, “Andampaile kube telatela, nnyende makauche ilebe inu uloi gwene makape akaocho namwe mamma na nkoba kumbengu, kuboka penia nhwika ungengame.” ");
INSERT INTO nnq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kakombo pagajoa genia, ngajabula kachakwe na kongo achimwite magambu akiba nuloi muno. ");
INSERT INTO nnq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Penia Yesu ngabalengela akinapunji bakwe, “Nannenge kweli ipakube kujundupa muno kwa mundu juna uloi kujingila mukingwana chu kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kabe nannenge kindema muno ngamia kupeta pililanga lya chingana, kumpeta mundu juna uloi kujingi mukingwana chu kumbengu.” ");
INSERT INTO nnq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Akinapunji bala pabajoa genia ngabaomongwa muno ngabankonya Yesu, “Nga meneke ojwapakuoto ukomboka?” ");
INSERT INTO nnq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ngabalolakeya, ngabajanga, “Kwa bandu kilebe chenje kuwechakanaje, nambu ku Nnoongo ilebe yoa kuwechakana.” ");
INSERT INTO nnq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kuboka penia Petulo ngalenga, “Natwe bo? Tuilekite ilebe ito yoa tunkengime mwenga! Tubakupata nike?” ");
INSERT INTO nnq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ngabalengela, “Nannenge kweli, Mwana jwa Mundu papakutama pikitebu chu kutawala chi kibumo chakwe Padunia Nhyono, mangwetomwe mangengaminge ntamanga muitebu komi ni ibele makagahukumula makabi komi na mabena ga kilambo cha Kuisilaeli. ");
INSERT INTO nnq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na mundu jwajoa jwajilekite nyumba andaje akanuna mundu andaje akalombo andaje awawa andaje amama andaje ingota andaje migonda, kwa magambu gangu nenga, mapokela mala pa mia muno na maipata bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nambu ababi bukutumbula ngoe mababa bukujomolela, na ababi bukujomolela mababa bukutumbula. ");
INSERT INTO nnq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kingwana chu kumbengu kilandine andi yene. Mundu nkola nng'onda gwa mizabibu, jwenio ngaboka kindabi kilokilo kabeka bandu akamwa maengo mung'onda gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ngapangana nabo kalepa uloi kulichoba penia ngabapeleka kunng'onda gwa mizabibu. ");
INSERT INTO nnq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ngaboka kindabi saa tatu, ngababona bange bandu bajemite kuchoko, banga mahengo. ");
INSERT INTO nnq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ngabalenge, ‘Nnyendange na mangweto makakamu mahengo munng'onda gwango nenga manannepa pipaligwe.’ ");
INSERT INTO nnq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ngabajabula. “Bena akola nng'onda ngababoka kabele saa sita na saa tisa, ngabatenda uyo. ");
INSERT INTO nnq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na kimuyo saa komi na jimwe, ngababoka kabele, ngabakolela bandu bajemite pachoko pala. Ngabakonyanga, ‘Mboni nnyemangite pambano mui joa na chankamwaje?’ ");
INSERT INTO nnq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na ngweto ngabajanga, ‘Kwa magambu abije mundu jukutupe mahengo.’ Bombe ngabalenge, ‘Namangweto nnyendange kunng'onda gwango gwa mizabibu.’ ");
INSERT INTO nnq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Apiika kimuyo, akola nng'onda ngabannenge ojwabeka uloi gwabe, ‘Makeme akamwa mahengo malepange uloi gwabe, katumbula ababakabe bukujomolela, na kajomolela abatumbalaga.’ ");
INSERT INTO nnq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ngabaikanga abakemigwa saa komi na jimwe, ngabapokela kila mundu uloi gwakwe gwa lichoba limwe. ");
INSERT INTO nnq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Abatumbula bala pabaika, bapemelela bapata tondoba. Nambu nangweto ngabapata uyo uloi gwa lichoba limwe. ");
INSERT INTO nnq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pabapokela uloi gwabe, ngabatumbu kakokalakea akola nng'onda. ");
INSERT INTO nnq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ngabalenga, ‘Bandu bamba abamakemita bukujomolela bakamula mahengo kukingobu cha saa jimwe tu, mboni mutubekite tela nabombe natwe tuimbalile liengo linakanonopa mui joa na lumu?’ ");
INSERT INTO nnq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nambu ngabannyanga jumwe katijabe, ‘Aganja, namponjiteje. Bo, tulagineje kunnepa uloi gwa lichoba limwe? ");
INSERT INTO nnq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ntole uloi gwinu, nnyabule. Mbala kunnepa uyo mundu jukujomolela kunkema tela na mwe. ");
INSERT INTO nnq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bo, mbaligwije ukamwa genia muloi gwango pambala? Bo, umone lwina magambu ne mbi namwojo gwa mbone?’ ” ");
INSERT INTO nnq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu ngajomole kulenga, “Yene, ababi bukujomolela ngoe bapakube bukutumbula na bukutumbula bapakube bukujomolela.” ");
INSERT INTO nnq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu pakiba akajenda kukilambo cha Kuyelusalemu, ngabatola akinapunji komi na abele bala kuntemela, undela ngabalengela, ");
INSERT INTO nnq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mpenakiange! Tujenda Kuyelusalemu, na kwenio Mwana jwa Mundu apabakamuigwa kwa akakung'i akolo na akaboli ba Malagilo, na angweto bapa kunhukumu akomigwe. ");
INSERT INTO nnq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bapankamuya kwa bandu bangabe Akayahudi bapa mmekanga nhwenyo, aputigwe bokola na bapankoma kukummamba panchalaba, nambu lichoba lya tatu mayoigwa.” ");
INSERT INTO nnq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Penia aanaba Zebedayo ngabannyendele Yesu bakiba pamwe ningota yabe, ngabakilakitila nu kunnyopa kilebe. ");
INSERT INTO nnq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu ngabakonya, “Bo, mpala nike?” Amama benia ngabajanga, “Unengele kube ingota yango ibena yeno maitama jumwe kalelo na jonge kangeja mu Kingwana chiinu.” ");
INSERT INTO nnq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu ngaijanga ikakombo “Mmanyije nnyopanga ni. Bo, nhwotwile kunywe kikombe cha malago chambakunywe nenga?” Ngabannyanga, “Tuotwile.” ");
INSERT INTO nnq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu ngabalengela, “Kweli manywa kikombe chango, nambu kutama kalelo andaje kangeja liengo lyangoje kubeka, kilebe chenia mabapata babala ababekiligwe tayali na Awawa bango.” ");
INSERT INTO nnq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pabajoa genia akinapunji bange komi bala, ngaba chimwanga benia akabena. ");
INSERT INTO nnq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yene Yesu ngabakemanga boa ngalenga, “Mmanyi kube akiilongoi ba bandu ba ilambo batawala bandu babe kwa makakala, na akiilongoi babe bakweti amuli ngolongwa kwabe. ");
INSERT INTO nnq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nambu mangwetomwe ikabe yeneje. Nambu mundu ojwapala kube nkolongwa panakati jinu abe oti mpakachi jwa mmoa, ");
INSERT INTO nnq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na mundu ojwapala kube jukutumbula, panakati jinu mpaka oti abe mmanda jwinu. ");
INSERT INTO nnq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Na uyo ne Mwana jwa Mundu nhikila kutumikigwaje, nambu kutumika na kuboya bwomi gwango ibe nakombole bandu ajingi.” ");
INSERT INTO nnq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu paboka kukilambo cha Yeliko na akinapunji bakwe, nkengeni nkolongwa gwa bandu ngugunkengama. ");
INSERT INTO nnq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Penia pakiba na bangalola akabena batamangite umbwega ja undela, na pabajoa kube Yesu apeta penia, ngabatondabeya lilobe. “Angwana, Mwana jwa Daudi, mutubone kia!” ");
INSERT INTO nnq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nkenga gwa bandu ngugwakalapila na kalenge bakotokange. Nambu angweto ngabayanga kuchobela, “Angwana, Mwana jwa Daudi, mutubone kia!” ");
INSERT INTO nnq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ngajema, ngabakemanga na kakonya, “Mpalanga nantendelange nike?” ");
INSERT INTO nnq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ngabannyanga, “Angwana, tujopa tuoto kulola!” ");
INSERT INTO nnq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu ngababone kia ngabakunyula mio gabe, na kingobu ucho ngabaotolanga kulola, ngabankengama. ");
INSERT INTO nnq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na akinapunji bakwe pababandakila Kuyelusalemu na kuika ku Betifage pi kitombi cha Mizeituni, ngabakinga akinapunji bakwe abele, ");
INSERT INTO nnq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ngabalengela, “Nnyendange mpaka kukijiji echikibi nnongi jinu na mamilikolela liponda litabigwe na mwana jwakwe magakulugule na magalete kwango. ");
INSERT INTO nnq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Anda mundu ankonyangite, munnengela, bagapala Angwana, jwombe mannekelanga kingobucho.” ");
INSERT INTO nnq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kile chenje kipitila kupala gaga agalengigwe na nnondoli jwa Nnoongo galenganile, ");
INSERT INTO nnq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mikilengele kilambo cha Sayuni, Nnole, Nngwana gwinu atendakuika! Juna kia na aliombi liponda, mwana liponda, mwana jwa liponda.” ");
INSERT INTO nnq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yene, akinapunji bala ngabajabulanga ngabakamwa anda Yesu apabalagalinge. ");
INSERT INTO nnq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ngibilitola liponda lela na mwana jwakwe, ngabatandika ngobo yabe panani ji liponda na Yesu ngatama panani jakwe. ");
INSERT INTO nnq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nkenga nkolongwa gwa bandu ngabatandika ngobo yabe undela, na bandu bange ngabatema matutwe ngabagajanjaya undela. ");
INSERT INTO nnq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nkenga gwa bandu abakiba nnongi ja Yesu na abakiba unyuma ngabatumbu kutondabe lilobe kulenga, “Alumbigwe Mwana jwa Daudi! Abe ni kindimba ojwaika ku liina lya Angwana! Alumbigwe Nnoongo kunani kumbengu!” ");
INSERT INTO nnq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu paika Kuyelusalemu, bandu boa ba kilambo chenie ngababe ni kijonga, ngaba konyana, “Ojo nga meneke?” ");
INSERT INTO nnq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Bandu abakiba pankengeni gwenio ngabalenga, jwenio nga nnondoli Yesu kuboke ku Nazaleti kukilambo cha ku Galilaya.” ");
INSERT INTO nnq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu ngajingi mu Nyumba ja Nnoongo, ngababenga bandu abakiba bakaucha nu kuemela ilebe mwenio. Ngapendangula mecha ya abajangangana uloi, na itebu ya abauchanga njeba, ");
INSERT INTO nnq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ngabalengelanga, “Iandikigwe mumajandiko Gachwapi, Nnoongo alengite Nyumba jango jikemigwa nyumba ja kugongalela. ‘Nambu mangweto mijibeka kube nyumba jakajibi.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bangalola na nangwaba ngaba nnyendelela Yesu ku Nyumba ja Nnoongo, Yesu ngabalamiya. ");
INSERT INTO nnq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Akakung'i akolo na aboli ba Malagilo ga Musa ngabachimwanga apabagabona gukuomongwa agakamula Yesu na kabe ingota apainonoya malobe mu Nyumba ja Nnoongo balenga, “Alumbigwe Mwana jwa Daudi.” ");
INSERT INTO nnq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nhyene ngabankonya Yesu, “Bo, nnyoaje echibalongela?” Yesu ngabajanga, “Elo, mbetakujoa! Bo manachomaje mumajandiko gangano? ‘Mibolangite ingota na ilemba, mpakupata ukoigwa okukulenganile.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu ngabaleka, ngapita panja ja kilambo nu kujenda ku Betania, ngagoloka kwenio. ");
INSERT INTO nnq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu apakiba akabuja ku nnyini kindabindabi, ngabe na njala. ");
INSERT INTO nnq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ngaubona nkongo ntini umbwega ja ndela ngaujendelela, nambu aukolela gwanga ngoko nambu maamba tu. Penia ngaulengela, “Makapambikaje kabe ngoko pangapela!” Kingobu ucho nkongo gwenio ngujoma. ");
INSERT INTO nnq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Akinapunji apabaubona ngabaomongwa bakalenga, “Mboni nkongo ntini gola ujomite kukingobu tu?” ");
INSERT INTO nnq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ngabajanga, “Kweli nannengelanga, anda mmilingite ni imani panga mbwele, nhwotwile kutenda ngiti yene tuje, nambu ata mikikilengi kitombi chenje, ‘Nnyikuke mikikileke mubaali,’ Maiba uyo. ");
INSERT INTO nnq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na anda mmi kuamini, chochoa echimpakujopa kukugongalela, mampata.” ");
INSERT INTO nnq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ngajingi Munyumba ja Nnoongo, ngababolanga. Apakiba akabola, akakung'i akolo na akinanhota ngabankonya, “Nkamwa ile yenje kukinala gani? Bene abampi kinala chenie?” ");
INSERT INTO nnq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu ngabajanga, “Na nenga mbakunkonya kilebe chimwe, anda unyangangite, na nenga nannyanga ndenda ikobo yenje kukinala gani. ");
INSERT INTO nnq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nankonyanga yene, bo, uwecho gwa Yohana gu kubaticha uboka kwa bene? Bo, uboka ku Nnoongo andaje kubandu?” Nambu ngabatumbu kutaukana beneakangweto jika, “Anda tulengite, ‘Uboka kumbengu,’ Apakutukonya, ‘Mboni nhwaminingije?’ ");
INSERT INTO nnq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Andatulengite, ‘Ubokita kubandu,’ Tujogopa nkengeni gwa bandu magambu boa bajeketalinge kube Yohana nga nnondoli.” ");
INSERT INTO nnq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Penia, ngabannyanga Yesu, “Tumanyije.” Jwombe Yesu ngabalengela, “Nane uyo nannengeje ngamwa ilebe yenje kukinala gani. ");
INSERT INTO nnq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mangweto nnolangabo? Mundu jumwe akiba na ingota ibele. Ngannengelanga jwajo jwa kutumbula, ‘Manango, lele nnyende makakamu maengo kunng'onda gwa mizabibu.’ ");
INSERT INTO nnq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kakombo jwenio ngabalengela, ‘Ngana!’ Nambu mwenakandae ngagalambuya mawacho, ngajenda ukamu mahengo. ");
INSERT INTO nnq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Awawa bala ngabannengela mwana jwabe jwa pili uyo, jwombe ngajanga, ‘Elo awawa manyabulage!’ Nambu ajeije kamu mahengo. ");
INSERT INTO nnq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bo, mene kati ja abele ojwakalenganakia gabapala awawa mundu?” Ngabajanga, “Jwajo mwana jwakutumbula.” Penia, Yesu ngabalengela, “Kweli nannengelanga, akatocha kodi na bina ngongola bapakunnongalela kujingila mu Kingwana cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Magambu Yohana ngaika kwinu kunnaya kutenda gapala Nnoongo, namangweto munhwaminije, nambu akajopa kodi na akangongola ngabannyeketela. Nambu magabweni genia goa, mangweto nng'ambwikeje mumyojo jinu, na nnyeketelingije.” ");
INSERT INTO nnq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu ngalenga, “Mpenikiange kulandanakia konge. Mundu jumwe juna nyumba ngalema nng'onda gwa mizabibu, ngautindikia ubego na ngaemba liliba lya ukamangila zabibu na uyo ngachenga kilendo mwenio. Kubokapenia ngabajaika akalemi, ngajenda mwanja kujenda kilambo cha kutaali. ");
INSERT INTO nnq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kingobu cha mauno apachaika, ngabakinga akapakachi bakwe kwa akalemi bala, batolange lipungu lyabe lya mauno. ");
INSERT INTO nnq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Akalemi bala ngabapukilanga akapakachi benia, jumwe ngabamputa na jonge ngabankoma na jonge ngabamputa mabwe. ");
INSERT INTO nnq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mundu jwenio ngabakinga kabe akabanda bange, bakiba nduu kupeta mwanja gwa kutumbula. Akalemi bala ngabatenda uyayela. ");
INSERT INTO nnq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pukujomolela ngankinga mwana jwakwe kongo akawacha, ‘Pangaje mabannyoa manango.’ ");
INSERT INTO nnq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nambu akalemi bala apabammona mwanajwabe ngabalengelana bombe ku bombe, ‘Jonjo nga nnichi, tankome ibe tutole ulichi gwakwe!’ ");
INSERT INTO nnq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Penia, ngabampukila, ngabampia panja ja nng'onda gwenio gwa mizabibu, ngabankoma.” ");
INSERT INTO nnq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu ngabalengela, “Ngoe, jwenio nkola nng'onda gwa mizabibu, apapakuika, apakakamwa ni akalemi?” ");
INSERT INTO nnq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bombe ngabannyanga, “Apakakoma akabaja benia, na nng'onda gola apakape akalemi bange abapampe lipungu lya mauno kingobu cha mauno.” ");
INSERT INTO nnq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Penia Yesu ngabalengelanga, “Bo, nchomangitije kile chenje Mumajandiko Gachwapi? ‘Libwe elibilikanangite akachengi ngoe nga libwe likolongwa lyambone. Angwana nga abatei kile chenje, kabe kilebe chenie nga chukuomongwa muno kwito!’” ");
INSERT INTO nnq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu ngajendekea kulongela, “Ku yene nannengela, Kingwana cha Nnoongo makiboigwa kwinu na kape bandu ba ilambo yenge ina kupambika ngoko agapala Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mundu anda agweli panani ja libwe lende apakutwekuka ipande, nambu ojulipakung'welela lipa kuntimba. ");
INSERT INTO nnq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Akakung'i akolo na Mafalisayo apabajoa kulandanakia kwakwe ngabamanya kutenda balenga angweto. ");
INSERT INTO nnq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Penia ngabapalapala ndela ja kumpukila, nambu bajogopanga bandu gambu angweto bamanyi kutenda jwenio akiba nnondoli jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ngalongela nabo kabele kukulandanakia, ");
INSERT INTO nnq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kingwana cha kumbengu kilandine yene, nngwana akampanganakia mwana jwakwe munalome mpapala gwa kutolana. ");
INSERT INTO nnq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngabatuma akapakachi kakemanga bandu abakakokigwe kumpapala, nambu bandu abakokigwe bapailingeje kuika. ");
INSERT INTO nnq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngabakinga kabe akapakachi bange, akalenga, ‘Makalengele abakokigwe, ilyo yango ibi tayali ngoe, likambako lya ng'ombe ni likoga lina kunoga lichinjigwe, kila kilebe kibi tela, nhwikange kumpapala!’ ");
INSERT INTO nnq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nambu bandu abakokigwe baagabije na ngabajabulanga kachabe, jumwe kung'onda gwakwe na jonge kamaengo gakwe, ");
INSERT INTO nnq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na bange ngabapukila akabanda bala ngabatukana, ngaba komanga. ");
INSERT INTO nnq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nngwana jola ngachimwa muno, ngagakinga manjolinjoli gakwe bakakomange akakomi benia na kukijocha kilambo chabe. ");
INSERT INTO nnq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Penia ngabalengela akapakachi bakwe, ‘Ilyo ya mpapala ibi tela kweli, nambu abakokigwe bapaligweje. ");
INSERT INTO nnq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ngoe nnyendange kundela na baboa bala abampa kakolela makemange baike kumpapala.’ ");
INSERT INTO nnq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Akapakachi bala ngababoka, ngabajenda ku nnyini, ngabaleta bandu boa, abaja na bambone. Nyumba ja mpapala ngijitwelela akageni. ");
INSERT INTO nnq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nngwana apajingila kalola akageni, ngammona mundu jumwe ojwakwinditeje ngobo ya mpapala. ");
INSERT INTO nnq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nngwana ngankonya, ‘Maganja, nnyingilabo pamba panga ngobo ja mpapala?’ Nambu jwombe ngatama nuu. ");
INSERT INTO nnq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Penia nngwana ngabalengela akapakachi, ‘Mantabange makongono na maboko makannekele panja pulubendu, kwenio apakuguta nu kuyaga mino.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu ngajomolela kulongela, “Ajingi bakokigwe, nambu achoko bapambuligwe.” ");
INSERT INTO nnq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kubokapenia, Mafalisayo ngabajabulanga, ngabapangana ndela ja kunyonja Yesu kwa malobe gakwe. ");
INSERT INTO nnq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Penia, ngabakinga akinapunji babe pamwe na abankengama Helode. Ngabankonya, “Aboli, tumanyi kutenda mwenga nga mamundu mannonge kweli, nu kutenda mmola kweli ja ndela ja Nnoongo, kunnyogopaje mundu jwajoa, gambu liengo lya mundu nga kileje kwinu. ");
INSERT INTO nnq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mutulengele lele nnolabo, tupaligwa kulepa kodi kwa nkolongwa jwa Loma?” ");
INSERT INTO nnq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nambu Yesu ngamanya mawacho gabe mabaja, ngabalengela, “Mangweto mamikitenda mabandu ba mbone, mboni unyiganga kupala unyonjange? ");
INSERT INTO nnq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Unayange uloi gwa kulepa kodi.” Angweto ngabampikia uloi. ");
INSERT INTO nnq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu ngabakonya, “Kumio kwa beneke na liina lyabeneke?” ");
INSERT INTO nnq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ngabannyanga, “Ja nkolongwa jwa Loma.” Penia Yesu ngabalengela, “Tela, mampe nkolongwa jwa Loma agabi gakwe nkolongwa jwa Loma, na ga Nnoongo mampe Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Apabajoa yene ngabaomongwa, ngabanneka na ngabajabulanga. ");
INSERT INTO nnq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lichoba lyene, Masadukayo abalenga abawile bayokaje ngabannyendele Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ngabannenge, “Aboli, Musa alenga mundu andawile na kaleka akege gwangabe na mwana, nnung'una mundu batole malekwe, kupala bampotole nnung'una gwakwe ingota. ");
INSERT INTO nnq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ngoe, pito pano pakiba na akalongo saba. Jwa kutumbula ngatola munkege kuboka penia ngawe panga kube na ingota, ngannekela nnongamundu munkege nanhwele jwenio. ");
INSERT INTO nnq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngibe uyo nnongamundu jonge, na jwa tatu mpaka jwa saba. ");
INSERT INTO nnq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kuboka pa akalongo benia boa kuwe, munkege jola uyo ngawe. ");
INSERT INTO nnq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bo, lichoba lya kuyoka abawile akege benia mababa anhanaba beneke kati ja akalongo saba bala? Gambu boa saba ngabantola.” ");
INSERT INTO nnq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ngabajanga, “Mangweto ntekulemwa magambu magamanyije Majandiko Gachwapi na makakala ga Nnoongo! ");
INSERT INTO nnq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nambu lichoba li kuyoka bandu mababa anda akapakachi bu kumbengu, batolaje akege wala kutoligwaje na analome. ");
INSERT INTO nnq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nambu nhwalo gu kuyoka abawile, manachomangaje agannengalinge Nnoongo? Annengalinga, ");
INSERT INTO nnq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nenga na Nnoongo ba Ulaimu na Isaka na Yakobo.’ Jwenio ngiti Nnoongo jwa abawileje nga Nnoongo jwa ababi bwomi.” ");
INSERT INTO nnq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nkenga gwa bandu gwenio apaujoa yene nguomongwa maboulo gakwe. ");
INSERT INTO nnq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo apabajoa Masadukayo bakwetingitije kilebe chenge chikunkonya Yesu, ngabakongana pamwe. ");
INSERT INTO nnq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jumwe kati jabe, mmoli jwa Malagilo ga Musa, ngankonya Yesu kukuntega, ");
INSERT INTO nnq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Aboli, amuli jako ejibi ngolongwa mu Malagilo ga Musa?” ");
INSERT INTO nnq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu ngajanga, “ ‘Mapale Angwana Nnoongo jwinu ku mojo gwinu gwoa na kukiuke chinu choa na kwa malango ginu goa.’ ");
INSERT INTO nnq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jenje nga amuli ngolongwa ja kutumbula. ");
INSERT INTO nnq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Japabele jilandana na jenie, ‘Mampale nndami nnyinu anda apamikipala mmene.’ ");
INSERT INTO nnq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagilo goa ga Musa na majandiko ga akalondoli ba Nnoongo gahyobalela amuli yenje ibena.” ");
INSERT INTO nnq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafalisayo apabakongana pamwe, Yesu ngabakonyanga, ");
INSERT INTO nnq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mangweto nnolangabo nhwalo gwa Kilisto nkomboi? Bo, nga Mwana jwa beneke?” Ngabajanga, “Mwana jwa Daudi.” ");
INSERT INTO nnq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu ngabalengela, “Kubabole kwa makakala gu Uhuke jwa Chwapi, Daudi ankema jwombe Angwana? Gambu ngalenga, ");
INSERT INTO nnq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Angwana ngabalengela Angwana bango, ntame kingonu chango cha kalelo, mpaka nabekange akangondwa binu pae ja makongono ginu.’ ");
INSERT INTO nnq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Anda, ibi, Daudi ankema Kilisto Nkomboi ‘Angwana,’ Baotwabo kube mwana gwakwe?” ");
INSERT INTO nnq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Abije mundu jwajoa ojwakaotola kunnyanga lilobe. Nu kuboka lichoba ulyo abije ojwakajiga kabe kunkonya kilebe. ");
INSERT INTO nnq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Penia Yesu ngaulenge nkengeni gwa bandu pamwe na akinapunji bakwe, ");
INSERT INTO nnq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Akaboli ba Malagilo na Mafalisayo bakweti uwecho gwa kulenganakia Malagilo ga Musa. ");
INSERT INTO nnq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mapenikiange nu kamula goa gabapa kunnengela. Nambu makajigaje itendwa yabe, gambu babikulenganikiaje gabatangacha. ");
INSERT INTO nnq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kutaba minhigo mitopeu na katweka bandu mumapamba, nambu benia angweto bakanite nu kutondabea lukonji bijipotole. ");
INSERT INTO nnq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Angweto bakamulanga ilebe yabe yoa kupala babonange bandu. Bakwindanga lumundi eilembigwe Majandiko Gachwapi muibongi na mumaboko gabe, nu kuchonela nducha miniko ya makoti gabe. ");
INSERT INTO nnq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kupala paali pina ichima mumipapala na itebu eibekigwe nnongi mumajumba gu kugongalela. ");
INSERT INTO nnq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kupala kalamukia kakinanhota mungongano nu kupala ukemigwa na bandu, ‘Aboli.’ ");
INSERT INTO nnq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nambu mangweto makakemigwaje ngu ‘Aboli.’ Gambu aboli binu bamwe na mangweto mmowa makalongo. ");
INSERT INTO nnq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na mukankemaje mundu jwa jwoa ‘Awawa’, Padunia pano, gambu Awawa binu bamwe tu ababi kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na makakemigwaje ‘Makilongoi,’ Gambu kilongoi jwinu jumwetu nga Kilisto Nkomboi. ");
INSERT INTO nnq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ojwabi nkolongwa panakati jinu abe oti mpakachi jwinu. ");
INSERT INTO nnq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ojwa kitondobe Nnoongo aba kunhuluya, na ojwa kiuluya Nnoongo aba kuntondobea.” ");
INSERT INTO nnq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mpakulaga makaboli ba Malagilo ga Musa na Mafalisayo, mamikitenda kube mambone! Nnyigalanga nniango gu kingwana chu kumbengu kubandu abapakujingi mukingwana chi kumbengu. Mmene mangweto kujingije mwenio, nambu maibilikia abapala kujingi mwenio.” ");
INSERT INTO nnq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kupotekigwa akaboli ba Malagilo ga Musa na Mafalisayo, mamikibeka bambone! Kaponjanga akananhwele nu kukikopekeya kube mabandu bambone kwa kugongalela kwinu kukoola. Kwa magambu genia mpakupata hukumu ngolongwa. ");
INSERT INTO nnq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mpakulaga akaboli ba Malagilo na Mafalisayo, bandu mamikibeka bambone! Ntyanganga mubaali nu mwilambo yoa kupala mumpate mundu aamini andi punhwamini mmene mangweto, pamampata mummeka abe jukujenda kumwoto gwangaimika machoba goa kupeta mmene mangweto!” ");
INSERT INTO nnq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mpakulaga akalongoi bangalola! Mangweto nnenga ‘Kita mundu anda alapile ku nyumba ja Nnoongo, kilapi chenie nhwaloje, nambu anda ajilapile jaabu ja Munyumba ja Nnoongo, kilapi chenie kiunamatile.’ ");
INSERT INTO nnq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mangweto makajinga mangalola! Chako chikibi chambone muno, jaabu andaje Nyumba ja Nnoongo ejibeka jaabu kube chwapi? ");
INSERT INTO nnq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kabe nnenga ‘Kita mundu anda akilapali kitembe cha Nnoongo nhwaloje nambu anda alilapali lilumbo elibekigwe panani ja kitembe cha Nnoongo kilapi chenie kiunamatile.’ ");
INSERT INTO nnq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mangweto mangalola! Chako chikibi chambone muno, lilumbo lela andaje kitembe cha Nnoongo chikibeka lilumbo kube chwapi? ");
INSERT INTO nnq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ojwa lapalila kitembe cha Nnoongo akilapalila kitembe chenie pamwe na ilebe yoa eibekigwe panani jakwe. ");
INSERT INTO nnq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ojwa jilapali nyumba ja Nnoongo ajilapili nyumba ja Nnoongo pamwe na Nnoongo ojwabi mwenio. ");
INSERT INTO nnq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ojwajilapalila mbengu akilapalila kitebu cha kingwana cha Nnoongo, na jwatamila.” ");
INSERT INTO nnq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mpakulaga makaboli ba Malagilo ga Musa na Mafalisayo, mamikitenda mambone! Ntochanga bandu lipungu lya komi, ni itimbilo andi yene maamba gina kunungila na manjanu na kongo milekanga ilebe yambone ya Malagilo andi yene haki, kia, na imani. Genie nga agapaligwe kugaagabala na gange. ");
INSERT INTO nnq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Makilongoi mangalola! Kuboya libembe mukunywe, nambu kumila ngamia! ");
INSERT INTO nnq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mpakulaga makaboli ba Malagilo ga Musa na Mafalisayo, mikitenda mambone! Kujeleya ikombe na ntungati kunja, nambu nkati mukuleka kutweli ilebe iyampatangita ku upoki na ubaja. ");
INSERT INTO nnq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mafalisayo mangalola! Nnyeleye oti kikombe nkati na kunja mapaba chwapi uyo. ");
INSERT INTO nnq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mpakulaga makaboli ba Malagilo ga Musa na Mafalisayo mikibeka kube mambone! Mmilingite andi makabuli agapakaigwe chwakala panja gabonekana chwapi nambu nkati gatweli iyupa ya mitui na kila ikokoloko ichapu. ");
INSERT INTO nnq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nu uyo, mangweto mmonekana na bandu kunja andi mabandu bambone nambu nkati ntwelalinge ubaja. ");
INSERT INTO nnq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mpakulaga makaboli ba Malagilo ga Musa na Mafalisayo mikibeka mabandu bambone! Nchengele makabuli gakalondoli na kugalembekeya makabuli ga bandu bambone. ");
INSERT INTO nnq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nnenga, ‘Kita twe tukabi kingobu cha kaokabito tukabi pamweje kakomanga akalondoli!’ ");
INSERT INTO nnq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yene nchalakichanga mmene kutenda mangweto nga ingota ya bandu ababakomangita akalondoli. ");
INSERT INTO nnq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aja, nnyomolekeange liengo lela elibatumbula akaokabinu! ");
INSERT INTO nnq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mangweto majoka ni ingota ya majoka gina uchungu! Nhwechangabo kujepa hukumu ja mwoto gwangaimika machoba goa? ");
INSERT INTO nnq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne nannetelanga mangweto akalondoli na bandu bina malango na akaboli, na bange mpakakomanga na kabambanga munchalaba na bange mpakaputa iboko munyumba inu yu kugongalela na kapalapala muilambo yoa. ");
INSERT INTO nnq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kulaga kubakuika kwinu magambu ga myai ja bandu boa bambone ejijitigwe panani ja nnema. Kuboke ukomigwa kwa Abeli ojwakiba jwanga malemwa, mpaka ukomigwa kwa Zakalia, mwana jwa Balakia, ojumunkoma panakati ja pachwapi ni kitembe chukupangi lilumbo. ");
INSERT INTO nnq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nannenge kweli, kwa magambu ga ukoma kwinu, mabandu ba ngoe mpa kuhukumuligwa. ");
INSERT INTO nnq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mwe ma Yelusalemu, Mwe ma Yelusalemu! Makomanga akalondoli na kaputa maganga akapakachi ba Nnoongo abakingite kwinu! Palenga nyigite kuikongola ingota yinu kwango andi ngoko apaikongola yana yakwe nkati ja mapapanilo gakwe, nambu mapaije. ");
INSERT INTO nnq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na nyumba ja Nnoongo jwinu jilekigwa liami. ");
INSERT INTO nnq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nannenge kweli, umonaje kabe mpaka apampa kulenga, ‘Alumbigwe ojwaika kuliina lya Angwana.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ngaboka pa Nyumba ja Nnoongo, na apakiba akajabula, akinapunji bakwe ngabannyendelela, ngabannaya majumba genia kichenga chabachengite. ");
INSERT INTO nnq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu ngabalengela, “Tela,” Nhwotolinge kugalolakea goa gano! Nannengela kweli, “Libije ata liganga limwe elipakuigala pamba panani ja lenge, kila kilebe makibomoligwa.” ");
INSERT INTO nnq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu apakiba atamite pikitombi cha Mizeituni, akinapunji ngabannyendela kukukiiya, ngabankonya, “Mutulengele ile yenje ipakube lii? Kiingi nike echikipakulaya kuika kwinu na kupela kwa mangobu?” ");
INSERT INTO nnq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ngabajanga, “Mma maha makakoloigwaje na mundu. ");
INSERT INTO nnq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gambu ajingi mabapitila nukulongela kupetela kuliina lyango angweto balenga kila mundu, ‘Nenga nga Kilisto!’ Na angweto bapakaoya bandu ajingi. ");
INSERT INTO nnq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mpakujoanga nhwalo gwa ngondo na manjega ga ngondo, nambu makaechukangaje, gambu genia mpaka gapitile, nambu kupela kwene kubi tango. ");
INSERT INTO nnq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kilambo chimwe kipakuputana na kilambo chenge, kingwana chimwe kipakuputana na kingwana chenge. Pamba na papa papakube na njala na nendemelo ya lutope. ");
INSERT INTO nnq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Genia goa nga anda kutumbwa kwa kubinia kwa kupotola mwana. ");
INSERT INTO nnq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kabe bapampanga mpotakigwe nu ukomigwa. Ilambo yoa ipakunchimwanga magambu ga liina lyango. ");
INSERT INTO nnq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kabe, ajingi bapakuleka mojo gwabe, bapakugalambuka nu kunchimwana. ");
INSERT INTO nnq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bapakupitila akalondoli nduu ba uwangi abapakaoyanga bandu ajingi. ");
INSERT INTO nnq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwa magambu ga kube ubaja nnyingi, kupalana kwa bandu kuba kupunguka. ");
INSERT INTO nnq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nambu ojwapakuimbalila mpaka kupela nga ojwapakomboka. ");
INSERT INTO nnq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kabe Nhwalo Gwambone gu kingwana cha Nnoongo ubakutangachigwa padunia joa, kupala kuchalakicha ku bandu boa ba padunia, penia nga pukupakuika kupela. ");
INSERT INTO nnq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pampa kukibona kilebe kibaja chikilengigwe na nnondoli Danieli kijemite paali pa Chwapi.” Ojwachoma amanya mana gakwe! ");
INSERT INTO nnq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Penia, ababi kukilambo cha Yudea batililange kwitombi. ");
INSERT INTO nnq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ojwabi pikinyanga cha nyumba jakwe akaulukaje kutola kilebe munyumba jakwe. ");
INSERT INTO nnq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ojwabi kunng'onda akabujaje ukaja kutola lutando lwakwe. ");
INSERT INTO nnq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bapakulaga akikege bina ndumbo na akinamama ababi ni ilemba eijonga machoba genia! ");
INSERT INTO nnq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Munnyope Nnoongo kutila kwinu kukabe machoba ga malilije andaje lichoba lya kupomalelaje! ");
INSERT INTO nnq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gambu kingobu chenie kubakube na ukomo nkolongwa na gwanapitije tangu bapanganigwa bandu boa mpaka ngoe nupitije kabele. ");
INSERT INTO nnq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Machoba genia gakabi nu kupunguyaje, akabije mundu jwajwoa ju komboka, nambu Nnoongo atekupunguya machoba genia kwa magambu ga bandu abapambuligwe. ");
INSERT INTO nnq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Anda mundu annengi, ‘Nno, Kilisto Nkomboi abi pamba!’ Andaje ‘Abi papa!’ Makanhwaminije. ");
INSERT INTO nnq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gambu papakupiti makilisto buwangi na akalondoli buwangi. Na benia balayanga iingi ikoloikolo na yukuomongwa yakaoyanga bandu, ata kubandu abapambuligwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mpenekia, nannengelinge tangu nukupitije. ");
INSERT INTO nnq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Anda bannengi, ‘Nnolanga, abi kupongoti!’ Makajendaje kwenio, andaje, ‘Nnolanga, akiite unyumba!’ Makanhwaminije, ");
INSERT INTO nnq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gambu andi njai pijimulika kuboka kumbwani mpaka kundonde, ngapipakube kuika kwakwe Mwana jwa Mundu. ");
INSERT INTO nnq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Paali apubi ntui, ngapagakongana matumbui. ");
INSERT INTO nnq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kingobu tu kuboka pu kulaga kwenio, lichoba liba lubendu na mwei ung'alaje, ndondwa ibakugwe kuboka kumbengu, na makakala ga mbengu gabakutikatika. ");
INSERT INTO nnq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kuboka penia iingi ya Mwana jwa Mundu iba kubonekana kunani, penia makabi goa gapadunia gapakuguta, apagapa kummona Mwana jwa Mundu akaika mumaunde gu kunani, juna makakala na kibumo kikolongwa. ");
INSERT INTO nnq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jwombe apakakinga akapakachi bakwe kuboka kumbengu bina lipenga lina kujemba muno, bakongolange bandu abapambuligwe na Nnoongo, kuboka kujitumbwi dunia mpaka kujipei mbengu. ");
INSERT INTO nnq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mukibolange kikilandanakia na nkongo ntini. Kingobu ndambi yakwe pitumbu kututuba maamba, mmanya kutenda mangobu ga mauno gaike. ");
INSERT INTO nnq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nu uyo mangweto pampakibona ilebe yenie yoa ikapitilaga, mmanya Mwana jwa Mundu abi papipi kuika. ");
INSERT INTO nnq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nannenge kweli, lungolo londo lujebeleje nukupitilaje ilebe yenie. ");
INSERT INTO nnq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mbengu na dunia maipeta, nambu malobe gango gapetaje ngu. ");
INSERT INTO nnq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nambu nhwalo gu lichoba andaje kingobu abije mundu ojwamanyi kiika lii, na akapakachi bukumbenguje na mwanaje, nambu Awawa jika jabe nga abamanyi. ");
INSERT INTO nnq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kuika kwa Mwana jwa Mundu kupa kube andi kingobu cha Nuhu. ");
INSERT INTO nnq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gambu machoba genia tango na ghalikaje bandu batela kulye na kunywe, akinalome na akikege kutolana nu kubutuyana mpaka Nuhu pajingila nkati mu Ntumbwi nkolongwa. ");
INSERT INTO nnq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bakibanga chebwe kiti kiba kupiti nike mpaka galika pijiika kajolanga boa. Yene ngipipakube Mwana jwa Mundu apapakuika. ");
INSERT INTO nnq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kingobu chenie bandu abele ababi kung'onda, jumwe aitoligwa na jonge ailekigwa. ");
INSERT INTO nnq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akikege abena bibaganga bakayaga okole, jumwe aitoligwa na jonge ailekigwa. ");
INSERT INTO nnq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nkelukiange, gambu milimanyije lichoba lyabapakuika Angwana binu. ");
INSERT INTO nnq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Akola nyumba bakamanyi kutenda mwihi abakuika kabi bakelukiye akijilekiteje nyumba jakwe jibomoligwe. ");
INSERT INTO nnq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Na yene mangweto uyo ntamanga maha gambu Mwana jwa Mundu abakuika kingobu changamanyika.” ");
INSERT INTO nnq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu ngajendekea kulenga, “Meneke ojwabi mpakachi jwaaminike na jwambone na jwanga mwojo gwambone? Jwenio ananhota bakwe bammekite kachunga bandu bakwe bapegange chakulya kingobu echikipaligwa. ");
INSERT INTO nnq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mbaya mpakachi jwajo jubapakunkolela ananhota mundu akakamula genia! ");
INSERT INTO nnq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nannenge kweli, bapa kummeka mpakachi jwenio alolele ilebe yakwe yoa. ");
INSERT INTO nnq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nambu anda mpakachi jwenio akilenge mwene, ‘Ananhota bango batenda kuchelwa kubuja,’ ");
INSERT INTO nnq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Penia ngatumbu kaputa akapakachi ajabe, ngatumbu kunywe pamwe nabandu abalobela, ");
INSERT INTO nnq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ananhota mundu baika lichoba lyangamanyika na kingobu changamanyika. ");
INSERT INTO nnq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ananhota bapa kunhweketa ipande nu kummeka pamwe na akabaja. Kwenio apakuguta nu kuyaga mino. ");
INSERT INTO nnq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kingobu chenie, Kingwana chu kumbengu kiba kulandana yene. Akaenja komi bapotolinge muli yabe ngabajenda kapoke akoano. ");
INSERT INTO nnq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Akanhwano bakiba akajinga na akanhwano akambone. ");
INSERT INTO nnq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Akajinga ngabapoto muli yabe, nambu bapotwije mauta gange. ");
INSERT INTO nnq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nambu bina myojo ja mbone ngabapotola mauta muyupa pamwe na muli yabe. ");
INSERT INTO nnq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Magambu anahota ba mpapala bakachelwa kuika, akaenja boa bala ngabatumbu katopa lugono. ");
INSERT INTO nnq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kilo puwiku ngukujoanika na manjega, ‘Anahota bampapala batenda kuika! Nnyendange makapokele!’ ");
INSERT INTO nnq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Akaenja boa ngabajimuka ngabaipangania imuli yabe. ");
INSERT INTO nnq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Akajinga bala ngabalenge bina mwojo gwambone bala, ‘Mutupegange mauta ginu machoko, gambu imuli ito itendakuimika.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nambu angweto bina myojo ja mbone ngabalengela, ‘Ije gututochaje twenga na mangweto. Mbaya nnyendange kuliduka makaemele mmene.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Penia, akaenja akajinga apabajenda kuemela mauta, akoano ngabaika. Na akaenja bala abakiba tela ngabajingalanga pamwe na bombe munyumba ja mpapala, na nniango ngujigaligwa. ");
INSERT INTO nnq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Akaenja ajinga bala ngabaika, ngabakema, ‘Angwana, angwana, mutujogolele!’ ");
INSERT INTO nnq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nambu bombe ngabajanga, ‘Nannengelanga kweli, numanyije mangweto.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Penia, Yesu ngajomolela kulenga, ‘Nkelukiyange, magambu mmanyangitije lichoba lyenie lipakuika lii.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Uyo Kingwana cha Nnoongo kipakube yene. Mundu jumwe ojwakapala kutyanga mwanja, ngabakema akapakachi bakwe, ngababeka bilolele ilebe yakwe. ");
INSERT INTO nnq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ngampe kila mundu tela na uwecho gwakwe, jumwe talanta nhwano yuloi na jonge talanta ibena na nyonjakea talanta jimwe. Kuboka penia ngatyanga. ");
INSERT INTO nnq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mpakachi ojwakapata talanta nhwano ngabeka uloi gwakwe kumundu ojwaucha ilebe ngapata nyonjekea talanta yenge nhwano. ");
INSERT INTO nnq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na jonge jo uyo ojwakapata talanta ibena yuloi ngapata nyonjakea talanta yenge ibena. ");
INSERT INTO nnq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nambu jwajo ojwakapata talanta jimwe ju uloi ngajenda, kuemba libomba pulutope, ngaiya talanta ja ananhota bakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kuboka pa machoba majingi, ananhota benia ngababuja, ngabatama na akapakachi kakonya batei ni muloi gwabe. ");
INSERT INTO nnq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mpakachi ojwakapata talanta nhwano yuloi ngaika apotwile talanta yenge nhwano. Ngalenga, ‘Ananhota, makambe talanta nhwano. Nno mbatite nyonjakea talanta yenge nhwano.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ananhota bakwe ngabannenge, ‘Chwapi, mapakachi mambone manhwaminike. Mmi kuaminika ku ilebe ichokoichoko, mbakunkamuya milolele ilebe ikolongwa. Nhwike nhwalalile pamwe na ananhota binu!’ ” ");
INSERT INTO nnq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mpakachi ojwakapata talanta ibena yuloi ngaika, ngapanga talanta yenge ibena nyonjakea, akalenga, ‘Ananhota, makambe talanta ibena yuloi. Ntole talanta ibena yenge eijonjakike.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ananhota bakwe ngabannengela, ‘Tela, mapakachi mambone mina kuaminika. Mmi kuaminika ku ilebe ichokoichoko, mbankamuya ikolongwa. Nhwike nhwalalile pamwe na ananhota binu.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nambu jwajo ojwakapata talanta jimwe juloi ngaika, ngalenga, ‘Ananhota, manyi mwe mamundu bukujundupa mwojo, mwe nhwuna pangapanda mbeju, nukonja pangamicha mbeju. ");
INSERT INTO nnq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nganyogopa, nganhia uloi gwinu pae pulutope. Ntole chiumbile.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ananhota bakwe ngabannenge, ‘Mwe mapakachi mabaja na makata! Mmanyi kutenda ne nhuna paali pangapanda mbeju, nu kutoteka pangamicha mbeju. ");
INSERT INTO nnq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mpaligwa, kubeka uloi gwango kubenki, nane kabi ndoile ntaji gwango na nyonjakea! ");
INSERT INTO nnq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mampokange uloi gwenio makampe jwajo juna talanta komi. ");
INSERT INTO nnq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gambu, mundu ojwakweti kilebe mapata nu kunnyonjakea. Nambu mundu jwanga kilebe, na chache chapemele akweti kipakutoligwa. ");
INSERT INTO nnq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na mpakachi ojo jwanga nyonjakea, mannekelange panja pulubendu! Kwenio apakuguta nukuyaga mino.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana jwa Mundu ojwabi Nngwana papakuika na mu Kibumo chakwe na akapakachi bakwe boa ba Chwapi, penia atama pikitebu chakwe cha Kingwana cha Kibumo. ");
INSERT INTO nnq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bandu boa bikongananga nnongi jakwe, jwombe maibagana bandu benia ikuta ikuta, andi nchungi apabagana mambelele na mbui. ");
INSERT INTO nnq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mababeka bandu abakamwile agapala Nnoongo kingonu chakwe cha kalelo na bandu akabaja kingonu chakwe cha kangeja. ");
INSERT INTO nnq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Penia Angwana ngabalengela ababi kingonu chakwe cha kalelo, ‘Nhwikange mangweto mampatite kindimba na Awawa bango, mpokelange Kingwana echimpanganikigwe kuboke kupanganigwa kwa dunia. ");
INSERT INTO nnq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Magambu nakiba na njala namangweto ngumbe chakulya, nakiba na nyota mangweto ngumbe mache, nakiba nageni namangweto ngumbokela, ");
INSERT INTO nnq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nakiba makengele mangweto ngungwindia, nakiba natamwe mangweto ngunhwika kunola, nakiba kukipungo mangweto ngunhwika kundyangila.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Penia, bandu abakamwile agapala Nnoongo bajanga, ‘Angwana, lii tammona mmi nanjala natwe ngutumpe chakulya, na mmi na nyota natwe ngutunkenga mache? ");
INSERT INTO nnq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lii tammona mmi mageni natwe ngutumpokela, na manga ngobo natwe ngutunkwindiya? ");
INSERT INTO nnq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lii tammona mmi matamwe andaje mantabigwe natwe ngutuika kunnola?’ ");
INSERT INTO nnq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Angwana mabijanga, ‘Nannenge kweli, kila kilebe chamankamulila jumwe jwa bamba akalongo bango achoko choko, mangamulila nenga.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Penia balengela ababi kingonu chakwe cha kangeja, ‘Mmokange nnongi jango mangweto mannanigwe na Nnoongo! Nnyendange kumwoto gwa machoba goa pangapela ogwapanganikigwa Mmaja na akapakachi bakwe. ");
INSERT INTO nnq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nakiba na njala mangweto umbije chakulya. Nakiba na nyota mangweto umbije mache. ");
INSERT INTO nnq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nakiba nageni mangweto umbokalingije, nakiba makengele, nambu mangweto ungwindiingije ngobo. Nakiba natamwe na nyigiligwe mukipungo, nambu mangweto maikije kunola.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Penia angweto ngabajanga, ‘Angwana, lii tammona mmi na njala au nyota, mmi mageni andaje manga ngobo, mmi matamwe andaje mannyigiligwe, nambu twe tuikije kunnyangata?’ ");
INSERT INTO nnq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Angwana bijanga, ‘Nannenge kweli, kila pamakana ukamula ilebe ku jumwe jwa bandu akachoko choko, nkanangita kungamuli nenga.’ ");
INSERT INTO nnq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bamba bajabulanga kuhukumu janga pela. Nambu abakamula agapala Nnoongo benia bajabulanga kubwomi gwa machoba goa pangapela.” ");
INSERT INTO nnq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu apajomola kubola genia goa, ngabalengela akinapunji bakwe, ");
INSERT INTO nnq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mmanyangite kube gaigi machoba mabena kupakube na Mpapala gwa Pasaka, na Mwana jwa Mundu apangigwa ibe abambigwe munchalaba.” ");
INSERT INTO nnq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kingobu chenie Akakung'i akolo na akananhota mundu ngabakongana pamwe panganya ja Kayafa ojwakiba Nkung'i nkolo. ");
INSERT INTO nnq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ngabapanga ndela ja kunkamula Yesu bankome kukuiya. ");
INSERT INTO nnq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Nambu ngabalenga kile chimwe, chakakamuligwaje kingobu cha mpapala gwa Pasaka ukapitije ukomo kati ja bandu.” ");
INSERT INTO nnq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu akiba ku Betania, kachakwe Simoni, ojwakiba juna maloi, ");
INSERT INTO nnq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","amama bamwe abakiba na chupa echikitweli mauta ga kunungila gabei ngolongwa, nganhwikilila pamecha pala apakiba atamite akalya chakulya, ngannyitila mauta genia umutwe. ");
INSERT INTO nnq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Akinapunji bakwe apabalola genia ngabachimwa, ngabalenga, “Ganike kugatunia?” ");
INSERT INTO nnq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Mauta ganga kabi gauchigwe kubei ngolongwa, nu uloi gwene kape akaocho.” ");
INSERT INTO nnq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu ngamanya echibalongela, ngabalengela, “Mbona machumbuya amama bamba? Batei chwapi ni kile chambone kwango. ");
INSERT INTO nnq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Akaocho mmi nabo machoba goa, nambu ne mbeje pamwe namangweto machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Amama bamba banyitile mauta ibe kumbanganikia kwa machiko gango. ");
INSERT INTO nnq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nannengelanga kweli kutenda, padunia poa pupakutangachigwa Nhwalo Gwambone, kitendwa chenje chibatei amama aba kibakulongaligwa kakombake benia.” ");
INSERT INTO nnq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Penia Yuda Isikalioti, ojwakiba jumwe kati ja baba komi na abele, ngajenda kwa akakung'i akolo, ");
INSERT INTO nnq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ngabalenge, “Mpakumbe kinii anda nang'alwike Yesu?” Ngabammalangi ipande selasini yuloi, ");
INSERT INTO nnq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kuboka kingobu chenie Yuda ngabe akapala ndela ju kunng'aluka Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lichoba lya kutumbula mpapala gwa mikate jangajela Kimela akinapunji ngabannyendela Yesu ngabankonya, “Mpala tukampanganikie ko Chakulya cha Pasaka?” ");
INSERT INTO nnq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu ngabajanga, “Nnyendange kunnyini kumundu jumwe, makannengele, ‘Aboli balenga, kingobu chango kiike, mbakulye Pasaka pamwe na akinapunji bango kachinu.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Akinapunji ngabatenda andi Yesu apabalagila, ngabapangania mpapala gwa Pasaka. ");
INSERT INTO nnq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Piika kimuyo, Yesu ngatama kulye pamwe na akinapunji bakwe komi na abena. ");
INSERT INTO nnq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Apabakiba bakalyaga, Yesu ngalenga, “Nannenge kweli, jumwe panakati jinu apakung'aluka.” ");
INSERT INTO nnq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Akinapunji ngabaechuka muno, ngabatumbu kunkonya Yesu jumwe jumwe, “Angwana, bo nenga?” ");
INSERT INTO nnq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu ngajanga, “Ojwapakulela nkate muntungati pamwe na nenga nga jwenio ojwapakung'aluka. ");
INSERT INTO nnq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana jwa Mundu mawa andi pagalenga Majandiko Gachwapi nhwalo gwa jwenio, nambu, kulaga mundu jwenio ojwapakunng'aluka Mwana jwa Mundu! Yakabi mbaya kwa mundu jwenio anda akabelwikije.” ");
INSERT INTO nnq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda ojwapala kunng'aluka, ngankonya, “Aboli! Bo, nenga?” Yesu ngalenga “Mwe nnengite.” ");
INSERT INTO nnq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pabakiba bakalyaga, Yesu ngatola nkate, ngannumba Nnoongo, ngaumetula, ngabape akinapunji bakwe nu kulenga, “Ntolange nnie, gongo nga mmele gwango.” ");
INSERT INTO nnq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kabe ngatola kikombe, ngalumba, ngabape akalenga, “Nnywegange mmoa,” ");
INSERT INTO nnq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Jenje nga myai jango ejibeka kipola lilagano lya Nnoongo, myai ejichalakicha malagano ga bandu ajingi ibe balekekeigwe mabaja. ");
INSERT INTO nnq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nannengelanga, nyweje kabele divai ja zabibu mpaka lichoba lyale apambakunywe nhyono pamwe na mangweto mu Kingwana cha Awabango.” ");
INSERT INTO nnq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kuboka pu kujemba nhwambo, ngabajenda kukitombi cha Mizeituni. ");
INSERT INTO nnq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Penia Yesu ngabalengela, “Kilo jenje ja lele, mmoa mwenga mpakutila nu kuneka ne, gambu Majandiko Gachwapi galenga, ‘Nnoongo alenga mbakunkoma nchungi, na kipenga cha mambelele kipakupwilikana.’ ");
INSERT INTO nnq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nambu kuboka pu kuyoka kwango, mbakunnongalela ku Galilaya.” ");
INSERT INTO nnq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo ngannenge Yesu, “Ata ikabi boa bannekangite, ne nannekaje.” ");
INSERT INTO nnq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu ngannengela, “Kweli nannengela, kilo ujenje tango nkokoloko nukubekaje, mpakungana patatu.” ");
INSERT INTO nnq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo ngannengela, “Nengaje yenie ata anda napaligwe kuwe pamwe namwe nannekaje.” Akinapunji bange bala ngabalenga uyo. ");
INSERT INTO nnq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Penia Yesu ngajenda pamwe na akinapunji bakwe paali apakemigwa Getisemani, ngabalenge, “Ntamange pamba ne nyenda papa kugongalela.” ");
INSERT INTO nnq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ngantola Petulo pamwe ni ingota ibena ya Zebedayo, ngatumbula kuechuka na kube na nambwele, ");
INSERT INTO nnq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Penia ngabalengela, “Mbi na kuwechuka kukolongwa umwojo papipi nu kuwe. Ntamange pamba nkeluyange pamwe na ne.” ");
INSERT INTO nnq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ngajenda nnongi kachoko, ngagwe manguku, ngagongalela, “Awabango andaiotwile kikombe chenje chambete, nambu ikabe anda apambala neje, ila apampala mwe.” ");
INSERT INTO nnq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kubokapenia ngababuji akinapunji bakwe akatatu bala, ngabakole bagochilinge, ngannenge Petulo, “Mboni makangweto nchipulinge kube mio pamwe nane ata lisaa limwe? ");
INSERT INTO nnq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nkelukiange nukugongalela kupala makalondoigwaje. Uhuke kupala kutenda agapala Nnoongo nambu makakala ga mundu kuotoje.” ");
INSERT INTO nnq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ngajenda kabe mala ja pabele ngagongalela, “Awawa bango, anda iotwile kikombe chikumboteka kipete panga nywe nenga, nambu agampala gakamuligwe.” ");
INSERT INTO nnq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ngabajendela kabele, ngabakolelanga bagochalinge, gambu mio gabe gakiba na lugono. ");
INSERT INTO nnq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu ngabaleka, ngajenda kabele kugongalela mala ja patatu kwa malobe ugaga. ");
INSERT INTO nnq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kabe ngabajendela akinapunji bala, ngabalengela, “Bo, mmi tango makagolokanga nu kupomolela? Nnolange! Kingobu chene kiike, na Mwana jwa Mundu makamuigwa mumaboko ga bandu abakamu mabaja. ");
INSERT INTO nnq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nnyinukange tujende. Atendakuika ojwapakung'aluka!” ");
INSERT INTO nnq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu apakiba tango akalongela nabo, kingobucho ngaika Yuda, jumwe kati ja akinapunji komi na abele. Ngalongwana nabo bandu ajingi bina mapanga na imbonga. Abakiba batumigwe na akakung'i akolo na akananhota ba bandu. ");
INSERT INTO nnq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mundu ojwapala kunng'aluka Yesu, akiba tayali aulaite kiingi nkengeni gwenio kulenga, “Mundu ojumbakunkumbatila ngajwenio. Mampukilange!” ");
INSERT INTO nnq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda ngaunhwegele Yesu nu kulenga, “Aboli, kunchelile,” penia ngankumbatila. ");
INSERT INTO nnq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu ngannengela, “Aganja, nkamule echinhwiki ukamula.” Ngabaika kumpukila Yesu nu kummekanga mumakakala. ");
INSERT INTO nnq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jumwe ja abakiba pamwe na Yesu ngatondabeya luboko, ngaucholomola upanga gwakwe, ngamputa mpakachi jwa Nkung'i Nkolo, ngaunheketa lichikilo. ");
INSERT INTO nnq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu nganengela, “Mmuye upanga gwinu muala, gambu jwajoa ojwaputana ku upanga, mawa nu upanga. ");
INSERT INTO nnq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bo, mmanyangiteje kube kabi nhotwi kajopa Awawa bango nabombe kingobu uchenje kabibanetile kikuta kikolongwa cha bandu komi na mabele cha akapakachi ba Nnoongo? ");
INSERT INTO nnq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nambu ipakulenganila bo Majandiko Gachwapi eilenga kube nga apaipaligwa kube?” ");
INSERT INTO nnq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesu ngaulenge nkengeni gwa bandu, “Bo, unhwikilinge kumbukila kwa mapanga na imbonga anda ne napoki? Machoba goa nakiba Munyumba ja Nnoongo nakabola, na umbukalingeje. ");
INSERT INTO nnq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nambu ganga goa gakamuligwe ibe Majandiko ga alondoli ba Nnoongo galenganile.” Penia akinapunji boa ngabanneka, ngabatilanga. ");
INSERT INTO nnq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bandu benia ababampukila Yesu ngabampeleka kachakwe Kayafa, Nkung'i Nkolongwa, okwabakongana aboli ba Malagilo ga Musa na akananhota. ");
INSERT INTO nnq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo ngankengama kutaali, mpaka mu uwa ja nyumba ja Nkung'i Nkolongwa, ngajingi unyumba pamwe na akalendei aibone ilebe pipakube. ");
INSERT INTO nnq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Akakung'i Akolongwa na Libalacha lya Akayahudi ngabajiga kupala malobe guwangi ibe bankome Yesu, ");
INSERT INTO nnq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nambu bapatangiteje lilobe lyalyoa, na bandu ajingi ngabaika ngabalenga malobe guwangi kujwenio. Ngabajomolela kuika bandu abena, ");
INSERT INTO nnq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ngabalenga, “Mundu ojo alengita kutenda, ‘Anhotwile kujibomo Nyumba ja Nnoongo nu kuchenga kabena kwa machoba matatu.’ ” ");
INSERT INTO nnq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nkung'i Nkolongwa ngajema, ngankonya Yesu, “Bo, nnyangaje lilobe? Bandu aba batenda kunkopakea?” ");
INSERT INTO nnq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nambu Yesu ngatama nuu. Nkung'i Nkolongwa ngannenge, “Nnapile ku Nnoongo ojwabi mmomi anda mwe nga Kilisto Nkomboi, Mwana jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu ngannyanga jwenio, “Elo mwe nnengite. Nambu nannengelanga mmoa, kutumbu ngoe mamammona Mwana jwa Mundu atamite kingonu cha kalelo cha Nnoongo juna uwecho, akaika mumaunde gu kumbengu!” ");
INSERT INTO nnq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Penia, Nkung'i Nkolongwa ngajwepula ngobo yakwe, ngalenga, “Atekuntukana Nnoongo! Tupaije akachaili! Nnyoaninge apantukana Nnoongo! ");
INSERT INTO nnq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mangweto nhwachangabo?” Angweto ngabannyanga, “Akweti malemwa apaligwa kuwe.” ");
INSERT INTO nnq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kabe ngubunhwuni mata kumio, ngabamputa makopi. Bange kongo bakamputa makopi, ");
INSERT INTO nnq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ngabalenga, “Kilisto mutulengele beneke, abamputite!” ");
INSERT INTO nnq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulo akiba atamite panja kuua. Penia, mpakachi jumwe munkege ngannyendela, ngalenga, “Mwe uyo makiba pamwe na Yesu juku Galilaya.” ");
INSERT INTO nnq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petulo ngakana nnongi ja boa akalenga, “Manyije echinnongela,” ");
INSERT INTO nnq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Apakiba akapita paniango, mpakachi jonge munkege ngammona, ngabalengela abakiba penia, “Mundu jwajo akiba pamwe na Yesu juku Nazaleti.” ");
INSERT INTO nnq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo ngakana nukulenga, “Napila yene numanyije mundu jwenio!” ");
INSERT INTO nnq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mwenakandaye kachoko, bandu abakiba penia ngabannyendela Petulo. Ngabannengela, “Kweli, mwe nga nabamwe kati ja angweto, gambu kilonge chinu kibonekana mwe mmoke ku Galilaya!” ");
INSERT INTO nnq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Penia Petulo ngatumbu kulapila kulenga, Nnoongo anhukumule anda nonge uwangi! “Numanyije mundu jwenio!” Kingobu tu nkokoloko ngabeka, ");
INSERT INTO nnq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petulo ngakombakela malobe galenga Yesu, “Tango nkokoloko nukubekaje, mpakungana patatu umanyije ne.” Ngapita panja ngaguta muno. ");
INSERT INTO nnq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pukuchaga, akakung'i akolongwa boa na akinanhota ngababeka machabuli gu kupala kunkoma Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ngabantaba ntondolo, ngabampeleka kunkamuya Pilato, nkolongwa jwa nkoa ojwachaguligwe na kilongoi jwa Loma. ");
INSERT INTO nnq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Penia Yuda jwenio ojwang'alukaga, palola kube Yesu bunhukumwile, ngaganwa, ngababuki akakung'i akolo na akinanhota ipande salasini yuloi yela. ");
INSERT INTO nnq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ngabalengela, “Ndekulemwa kummeka mundu jwanga malemwa akomigwe.” Nambu bombe ngabalenga, “Twe genia gutupata bo? Genia ginu mmene.” ");
INSERT INTO nnq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda ngaulekela uloi gola munyumba ja Nnoongo, ngapita panja, ngajabula ngakikongela. ");
INSERT INTO nnq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Akakung'i akolo ngabatola uloi gola, ngabalenga “Ipaligweje kubeka munkoba gwa nyumba ja Nnoongo kwa magambu uloi gwa ukoma mundu.” ");
INSERT INTO nnq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ngabalagana, ngabaemela nng'onda gwa mmombi pabe paali pa kuchiki akageni. ");
INSERT INTO nnq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mpaka lele nng'onda gwenio ukemigwa, “Nng'onda gwa Myai.” ");
INSERT INTO nnq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Penia malobe ga nnondoli Yelemia ngagalenganila, “Ngabatola ipande makomi matatu ya uloi kulenganila na jwajo jubammeka bei bandu ba Kuisilaeli, ");
INSERT INTO nnq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ngabaemela kwa uloi gwenio nng'onda, anda Angwana apabanagila.” ");
INSERT INTO nnq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ngabannyemeka nnongi ja nkolongwa jwa Nkoa. Penia, ngabankonya, “Bo, mwe nga Mangwana ba Akayahudi?” Yesu ngajanga, “Mwe nnengite.” ");
INSERT INTO nnq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nambu akakung'i akolongwa na akananhota apabakiba bakantakiana, ajangitije lilobe. ");
INSERT INTO nnq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yene Pilato ngankonya, “Bo, mpetakujoaje matakiano genia goa agabapia kwinu mwenga?” ");
INSERT INTO nnq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nambu Yesu ajangitije ata lilobe limwe, ata akolongwa ba Nkoa ngabaomongwa muno. ");
INSERT INTO nnq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lwakiba lukobo lwabe kingobu cha mpapala gwa Pasaka akolongwa ba Nkoa kaleke Akayahudi mundu jumwe ojwatabigwe ojwabampailinge. ");
INSERT INTO nnq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kingobu chenie akiba ojwatabigwe jumwe, lina lyakwe Yesu Balaba. ");
INSERT INTO nnq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yene, bandu apabakongananga pamwe, Pilato ngabakonyanga, “Mpalanga nanneke jwako kati ja abele bamba, Balaba andaje Yesu ojwakemigwa Kilisto Nkomboi?” ");
INSERT INTO nnq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Alenga yene gambu amanyi kibola kutenda bannetanga kwakwe magambu ga bwiu. ");
INSERT INTO nnq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato apakiba atamite pakitebu cha hukumu, anhana mundu ngabapelekela chalamu, “Makankamwa kilebeje mundu jwambone jwenio, gambu lele ndekulaga muno mumaloto magambu jakwe.” ");
INSERT INTO nnq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nambu akakung'i akolongwa na akananhota ngabakwelekea bandu bannyope Balaba ajogoligwe na Yesu akomigwe. ");
INSERT INTO nnq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nkolongwa jwa Nkoa ngakonya, “Jwako kati ja abele bamba ojwampala nanneke?” Ngabannyanga, “Balaba!” ");
INSERT INTO nnq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ngabakonyanga, “Lele, nantendibo Yesu ojwakemigwa Kilisto Nkomboi?” Boa ngabalenga, “Abambigwe!” ");
INSERT INTO nnq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato ngakonya, “Kwa nike? Atei ubaja gani?” Angweto ngabayanga kulenga kanonoya, “Abambigwe panchalaba!” ");
INSERT INTO nnq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato apamanya kube aotwaje chachoa na kijonga kitela kutumbula, ngatola mache, ngakuya maboko nnongi ja bandu, ngalenga, “Ne ngwetije ligambo nhwalo gwa kiu cha mundu jonjo, kwale mmene.” ");
INSERT INTO nnq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bandu boa ngabalenga, “Myai jakwe jibe panani ja mitwe jito na panani ja mitwe ja ingota ito!” ");
INSERT INTO nnq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Penia Pilato ngannekekea Balaba kuboka kukipungo, nambu Yesu ngabakamuya aputigwe iboko na manjolinjoli na abambigwe panchalaba. ");
INSERT INTO nnq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Penia manjolinjoli ga Pilato ngagampeleka Yesu panganya ja boma, nkengeni gwoa ngukongana kuntindiki jwombe. ");
INSERT INTO nnq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ngabanhwula ngobo yakwe, ngabankwindiya ngobo ya kingwana. ");
INSERT INTO nnq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ngabapota ulembalemba gwa miba na ngabankwindiya umutwe, uyo ngabammekela nnai puluboko lwakwe lwa kalelo. Ngabakilikitila nnongi jakwe na ngabammeke nhwenyo bakalenga, “Kunchelile Angwana ba Akayahudi!” ");
INSERT INTO nnq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ngubunhuni mata, ngubuto nnai ngabamputi umutwe. ");
INSERT INTO nnq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kuboka pu kummeke nhwenyo, ngubunhwula lijou lela na ngabankwindiya ngobo yakwe, kuboka penia ngabampeleka kummamba. ");
INSERT INTO nnq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Apabakiba bakajenda, ngabankolela mundu jumwe liina lyakwe Simoni, mundu jwa kilambo cha Kulene, ngabannenge mpoto nchalaba gwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Apabaikanga paali apakemigwa Goligota, mana gakwe, “Paali pi Kitongo cha mutwe,” ");
INSERT INTO nnq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ngabampe divai kutindigana na kile kibaba ntela gukupoya kubinia. Nambu Yesu apapaya ngakana kunywe. ");
INSERT INTO nnq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ngabammamba, uyo ngababagana ngobo yakwe kukubeka kiumbuumbu. ");
INSERT INTO nnq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kuboka pa genia ngabatamanga, ngabannendela. ");
INSERT INTO nnq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panani ja mutwe gwakwe panchalaba ngababeka kibao echibaandike, “Jonjo nga Yesu, Nngwana jwa Akayahudi.” ");
INSERT INTO nnq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Akapoki abena ngababambigwa uyo pamwe na Yesu, jumwe kingonu cha kangeja na jonge kingonu cha kalelo. ");
INSERT INTO nnq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bandu abakapeta penia ngabantukana Yesu nukutikatika mitwe jabe kulenga, ");
INSERT INTO nnq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Mwe! Nnengita nhotwije kujibomola nyumba ja Nnoongo nukuchenga kwa machoba matatu? Ngoe mikikombole mmene. Anda mwe nga Mamwana jwa Nnoongo, nhuluke panchalaba!” ");
INSERT INTO nnq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Akakung'i akolo na akaboli ba Malagilo ga Musa na akananhota uyo ngabammeke nhwenyo bakalenga, ");
INSERT INTO nnq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ngabakombo bange, nambu kukikombola mwene kuotwaje! Jwombe konda Nngwana jwa Akasilaeli! Anda ngoe auluke panchalaba, natwe matunhwamina. ");
INSERT INTO nnq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nganhyobalela Nnoongo nukulenga eti jwombe nga Mwana jwa Nnoongo, Nyeme twetulole anda Nnoongo apaile kunkombola.” ");
INSERT INTO nnq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ababambigwa pamwe ngabantukana uyo. ");
INSERT INTO nnq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ikiba saa sita nalumu mpaka saa tisa kimuyo, lubendu ngulutanda kilambo choa. ");
INSERT INTO nnq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Apaika saa tisa Yesu ngaguta kulilobe likolongwa, “Eloi, Eloi, lama sabakitani?” Mana gakwe, “Nnoongo jwango, Nnoongo, jwango mboni undekuneka?” ");
INSERT INTO nnq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bandu bange abajemangita penia abannyoanga jwenio ngabalenga, “Ankema Eliya.” ");
INSERT INTO nnq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jumwe kati jabe ngabutuka, ngatola litonji na ngalichwika musiki, ngalitabali munnai ngantondobeke Yesu anywe. ");
INSERT INTO nnq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bange ngabalenga, “Nyemetulole anda Eliya maika kunkombola.” ");
INSERT INTO nnq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu ngaguta kabena kanonoya, ngajomoka. ");
INSERT INTO nnq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Panjia ja nkati ja Nyumba ja Nnoongo elibagina pa Chwapi ja Nnoongo ngijipachuka ipande ibena kuboka kunani mpaka pae. Nnema ngulendemela na mabwe ngagapachuka, ");
INSERT INTO nnq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","makabuli ngagajogoka na bandu nduu bachwapi ba Nnoongo abawile ngabayoka. ");
INSERT INTO nnq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Na bombe, kuboka pa kuyoka kwakwe Yesu kuboka kwa abawile, ngabapita mumakabuli na ngabaika mukilambo cha Chwapi Kuyelusalemu na ngababonekana na bandu nduu. ");
INSERT INTO nnq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kilongoi jwa akalenda ba Loma na manjolinjoli agakiba gakannendela Yesu apabalola kulendemela kwa lutope na ilebe eipitile yela, ngabajogopa muno, ngabalenga, “Kweli mundu jonjo akiba Mwana jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Paali penia pakiba na akikege ajingi bakalolanga kwa kutaali. Benia nga abankengama Yesu kuboke ku Galilaya bakantumikia jwombe. ");
INSERT INTO nnq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kati jabe akiba Maliamu Magidalena na Maliamu amama ba Yakobo na Yusufu, pamwe na amama ba ingota ya Zebedayo. ");
INSERT INTO nnq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Apaikiba kimuyo, ngaika mundu jumwe juna uloi kuboke Alimatayo, liina lyakwe Yusufu. Jwombe uyo akiba napunji jwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ngannyendela Pilato, ngajopa bampe mmele gwa Yesu. Pilato ngaamulicha bampe. ");
INSERT INTO nnq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu ngautola mmele gola, ngaubiligila chanda ejibi chwapi, ");
INSERT INTO nnq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ngaubeka nkati ja likabuli lyakwe liyono elikiba liembigwe piliganga. Penia ngalipilimbia libwe likolongwa nnongi ja nniango gu likabuli, ngajabula. ");
INSERT INTO nnq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliamu Magidalena na Maliamu jonge bakiba batamangite kulilolake likabuli. ");
INSERT INTO nnq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Malabo jakwe, lichoba elikengima elikiba lya Kupomolela, akakung'i akolo na Mafalisayo ngabannyendelela Pilato, ");
INSERT INTO nnq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ngabalenga, “Ananhota, tubiukombokela kutenda jwajo nhwangi pakiba mmomi alenga, ‘Kuboka pa machoba matatu mahyoka.’ ");
INSERT INTO nnq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ku yene nhwamuliche likabuli lilendeligwe mpaka lichoba lya tatu ibe akinapunji bakwe bakannyibaje na kalenge bandu kutenda ayokite. Nhwangi gwa kupela gongo upakube mmaja muno kupeta gwago gwa kutumbula.” ");
INSERT INTO nnq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ngabalengela, “Aja, nkweti akalendei, nnyendanga makalendele apanhwotwile.” ");
INSERT INTO nnq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yenie ngabajendanga, ngabalilendela likabuli, ngabalimatila libwe lela na kaleka penia akalendei bakalenda. ");
INSERT INTO nnq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kuboka pi Lichoba li Kupomolela, papipi nu kuche gi lichoba lya jumapili, Maliamu Magidalena na Maliamu jonge ngabajendanga kulola likabuli lela. ");
INSERT INTO nnq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kingobucho ngukupitila kulendemela kukolongwa kwa lutope, mpakachi jwa Angwana ngauluka kuboka kumbengu, ngalipilimbia libwe lela, ngalitamila. ");
INSERT INTO nnq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Abonekana anda njai na ngobo yakwe yakiba nhuu mbuu. ");
INSERT INTO nnq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Akalendei bilikabuli lela ngabalendemela kwa mbwele ngolongwa, na ngababe anda batekuwe. ");
INSERT INTO nnq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nambu Mpakachi jola ngabalenge akikege bala, “Mangweto makajogopaje! Manyi kutenda mampalanga Yesu ojwabambigwe munchalaba. ");
INSERT INTO nnq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Abije pamba ayokite andi palengaga. Nhwikange nnole paali pabammekita. ");
INSERT INTO nnq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nyendange chokwe makalengelange akinapunji bakwe ‘Kube ayokite kuboka kwa abawile, na ngoe annongolela kwako ku Galilaya, kwenio mamammona!’ Aja, ne tayali nannengalinge.” ");
INSERT INTO nnq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kongo bakajogopa nu kualalila, akikege benia ngababoka chokwe pilikabuli ngababe na mbwele muno ngababutuka kujenda kalenge akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kingobucho, Yesu ngakongana nabo, ngabalenge, “Nnumbalile.” Akikege benia ngabannyendelela, ngabakilikitila nnongi jakwe, ngabakamula makongono gabe. ");
INSERT INTO nnq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu ngabalengela, “Makajogopaje! Nnyendange makalengela akalonga bango bajendange Ku Galilaya na kwenio mabakamona.” ");
INSERT INTO nnq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akikege bala apabakiba bakajabulaga, akalendei bange ba likabuli lela ngabajenda kunnyini kulenga kila kilebe kwa akakung'i nhwalo gwa ilebe yoa eipitile. ");
INSERT INTO nnq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ngabakongana pamwe na akanhota na kuboka pa kulongelanga, ngabape akalendei bala uloi nduu, ");
INSERT INTO nnq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bakalenga, “Mangweto nnenga yene, ‘Akinapunji bakwe ngabaika kilo kuujiba mmele gwakwe twe ogutakiba tugochile lugono’ ");
INSERT INTO nnq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na anda Akolongwa ba Loma bamanyi kilechenje na twe matulongela nabo mpaka tulole kube mangweto mpatangaje malola.” ");
INSERT INTO nnq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Akalendei bala ngabautola uloi gola, ngabakamwa anda pababoligwe. Nhwalo gwenio ujoanike kati ja Akayahudi mpaka lele. ");
INSERT INTO nnq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Akinapunji komi na jumwe bala ngabajendanga ku Galilaya kukitombi echabalagila Yesu. ");
INSERT INTO nnq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Apabammona, ngabanng'ongalela, nambu bange bakiba na mbwele. ");
INSERT INTO nnq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ngaika papipi, ngabalengela, “Mbatite kinala choa kumbengu nu kudunia. ");
INSERT INTO nnq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nnyendange, makabeke bandu boa babe akinapunji bango, makabatichanga kuliina lya Awawa na lya Mwana na lya Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mabolange ukamula Malagilo bandu ilambo yoa na makabi goa aganampilangite. Nenga mbi pamwe namangweto machoba goa pangapela, mpaka pijibakupela dunia.”");
INSERT INTO nnq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gongo nga Nhwalo Gwambone gwa Yesu Kilisto, Mwana jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Itumbula andi apiandikigwe na Isaya nnondoli jwa Nnoongo. “Nnoongo ngalenga, ‘Mbakunkinga mmanda jwango annongolele, kumpanganakia ndela jinu.’ ");
INSERT INTO nnq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mundu achobe papongoti, ‘Ntendekeye ndela ja Angwana, mmeke kipola mubapakupeta!’ ” ");
INSERT INTO nnq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana Mmatichi apitila papongoti, ngatangacha na kabaticha bandu, ngabalenge, “Nnapange mabaja ginu nu kubatichigwa, Nnoongo mannekekea mabaja ginu.” ");
INSERT INTO nnq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bandu ajingi kuboka kukilambo cha Yudea nu Kuyelusalemu ngabannyendele Yohana, ngabalapanga mabaja gabe, nukubatichigwa mulukemba lwa Yolidani. ");
INSERT INTO nnq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana akwinda ngobo ji majuni ga ngamia, nu luunga lu limbendela mukibuno chakwe, chakulya chakwe kikiba maige na buchi. ");
INSERT INTO nnq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana ngabalenge bandu, “Munalome ojwapakuika kuboka pango nenga akweti uwecho kumbeta nenga. Mbaligwije kulita ukulugula ngoji yi ilatu yakwe. ");
INSERT INTO nnq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nenga nammatichanga kwa mache, nambu jwenio ammatichanga ku Uhuke jwa Chwapi.” ");
INSERT INTO nnq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Machoba majingije, Yesu ngaika kuboka kukilambo chi Kunazaleti kunkoa gu Kugalilaya, ngabatichigwa na Yohana mulukemba lwa Yolidani. ");
INSERT INTO nnq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kingobutu Yesu papita umache, ngajibona mbengu jiekwike nu Uhuke jwa Chwapi akaika kutola panani jakwe andi ngunda. ");
INSERT INTO nnq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni lilobe ngilijoanika kuboka kumbengu, kulenga, “Mwenga Mamanango manumpala manhwalalile.” ");
INSERT INTO nnq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kingobu tu Uhuke jwa Chwapi ngannongaleya kupongoti, ");
INSERT INTO nnq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kwenio ngatama machoba alubaini, Lichetani ngilinnondoya. Ni inyama ya mpongoti yakiba ukwo, nambu akapakachi kuboka kumbengu ngabaika kummegelela Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana apakiba mukipungo, Yesu ngajenda Kugalilaya ngatangacha Nhwalo Gwambone gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesu ngalenga, “Kingobu chambone kiike, ni kingwana cha Nnoongo kibandakile. Nnapange mabaja ginu nhwamini nhwalo gwambone!” ");
INSERT INTO nnq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu apapeta umbwega ji lilaba li Kugalilaya, ngababona akakoki akabele Simoni nu ununu gwakwe Andulea, bakakokanga yamaki na mapelele. ");
INSERT INTO nnq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ngabalenge, “Ungengamange nenga manammekanga mme makakoki ba bandu.” ");
INSERT INTO nnq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na angweto ngabagalekanga mapelele gabe, ngabankengama. ");
INSERT INTO nnq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Apabaika nnongi kachoko, ngababonanga Yakobo na Yohana, ingota ya Zebedayo. Muntumbwi gwabe bakatendekeanga mapelele gabe. ");
INSERT INTO nnq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu apababonanga, ngakema, angweto ngabankengama Yesu na kaleka awamundu ana Zebedayo muntumbwi pamwe na akakamu maengo. ");
INSERT INTO nnq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na akinapunji bakwe Lichoba li Kupomalela, ngabajendanga Kukafalanaumu, Yesu ngajingi munyumba ji kugongalela, ngabola. ");
INSERT INTO nnq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bandu bao ngabaomongwa maboulo gakwe, gambu abola andi mundu ojwakweti kinala, ngiti andi akaboli babe ba Malagiloje. ");
INSERT INTO nnq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kingobu ucho ngajingi mundu juna nchepela munyumba ji kungongalela ngachobela, ");
INSERT INTO nnq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Mpala ni kwito, Yesu ju Kunazaleti? Bo nhwikila kutujomola? Numanyi mwe, mwe machwapi mankingigwe na Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ngaukalapila nchepela gwenio, “Nkotoke! Mammoke mundu jwenio!” ");
INSERT INTO nnq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nchepela ngugunnyukanyuka mundu jwenio, ngaguta kanonoya, ngammoka mundu jwenio. ");
INSERT INTO nnq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bandu boa ngabaomongwa ngabakonyana, “Chenie nga nike? Maboulo mayono? Mundu jwenio akweti kinala chu kubenga michepela najenie kunnyoa!” ");
INSERT INTO nnq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Minhalo ja Yesu ngijijoanika kilambo choa chi Kugalilaya. ");
INSERT INTO nnq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na akinapunji bakwe pamwe na Yakobo na Yohana ngabapita munyumba ji kugongalela, ngabajenda kachakwe Simoni na Andulea. ");
INSERT INTO nnq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Akimundu Simoni akege, bakiba pikindanda, atamwe, paika Yesu ngabannengela. ");
INSERT INTO nnq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu ngabajendele amama benia, ngabakamula, ngabajinula. Kitamwe ngachaboka, amama benia ngababegelelanga. ");
INSERT INTO nnq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kimuyo bandu ngabannete Yesu akatamwe ndu bina michepela. ");
INSERT INTO nnq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bandu ndu bi kilambo chenie ngabaikanga pulubanja lwa nyumba jenie. ");
INSERT INTO nnq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu ngabalamiyanga bandu ajingi abakiba na itamwe, ngajibenga michepela mijingi, na ngajikanalila kulongela michepela jenie, magambu jamanyi jwenio nga meneke. ");
INSERT INTO nnq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kindabi jakwe, Yesu ngajimuka ngajenda pajika jakwe, kungongalela. ");
INSERT INTO nnq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nambu Simoni na akajakwe ngabampalapala, ");
INSERT INTO nnq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","apabammona ngabanenge, “Kila mundu atenda kumpalapala.” ");
INSERT INTO nnq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu ngabalenge, “Tujende kuijiji yenge eibi papipi, gambu kwenio, mbaligwa kutangacha Nhwalo Gwambone uyo, magambu inkila kwa genia.” ");
INSERT INTO nnq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Penia ngajenda kila kijiji chi Kugalilaya ngatangacha mumajumba gu kugongale nu kubenga michepela. ");
INSERT INTO nnq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mundu jumwe juna maloi ngaika kwa Yesu ngakilikitila ngajopa, “Anda mpaile unyeguye!” ");
INSERT INTO nnq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu ngammone kia, ngatondobea luboko lwakwe, ngankunyula nu kunnenge, “Mbala, nnyeguke!” ");
INSERT INTO nnq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kingobucho maloi ngagammoka mundu jwenio ngajeguka. ");
INSERT INTO nnq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kubokapenia Yesu ngannenge mundu jwenio ajabule nu kunkelebuya, ");
INSERT INTO nnq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Mpenakia, makannengeje mundu jwajoa kilebe chenie. Nambu nnyende mikikilaye kunkung'i jwa Nnoongo. Na makapange lilumbo kukujeguka kwinu andi apaamulicha Musa kupala kachalakicha angweto kutenda nnamite.” ");
INSERT INTO nnq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nambu mundu jwenio, ngajenda ngalandulila nhwalo gwenio kila paali. Nu kulenga ilebe ijingi na Yesu aotwije kabe kujingila mukilambo cha chochoa kukubonekana, ngatama panja, pajikajakwe. Na bandu ngabannyendela kuboka kila paali. ");
INSERT INTO nnq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Machoba majingije, Yesu ngabuja kabele Kukafalanaumu, bandu ngabajoa kutenda abi kachakwe. ");
INSERT INTO nnq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bandu ajingi ngabakongana kwenio kabe kiigije chumbi changa bandu, mpaka panniango na panja poa. Kwenio Yesu ngabatangachila Nhwalo Gwambone. ");
INSERT INTO nnq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bandu akancheche ngabaika bampotwi mundu ojwapolite mmele gwoa ngabanneta kwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwa magambu ga bandu ajingi, baotwije kumpeleka unyumba mwakiba Yesu, penia ngabapojo pikinyanga kipola na Yesu, ngabanhuluya mundu jwenio bang'onike pilikai. ");
INSERT INTO nnq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu apaibona imani yabe, ngannenge mundu jwenio, ojwapolite, “Manango, mabaja ginu galekekiigwe.” ");
INSERT INTO nnq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bange akaboli ba Malagilo ga Musa, abatamangite penia ngabawacha mumyojo jabe, ");
INSERT INTO nnq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Alongebo yene? Antukana Nnoongo! Abije mundu jwaotwi kulekekeya mabaja, Nnoongo tu nga ojwaotwile!” ");
INSERT INTO nnq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kingobu chenie Yesu ngamanya mawacho gabe, ngabakonya, “Mboni nhwachanga genia mumyojo jinu? ");
INSERT INTO nnq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kini chikibi kindema muno kunnenge mundu ojwapolite, ‘Nnekekiigwe mabaja ginu?’ Andaje ‘Kunnenge nnyinuke, ntole likai linu nnyabule’? ");
INSERT INTO nnq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nampala mmanyange kutenda, Mwana jwa Mundu akweti kinala cha kalekekeya bandu mabaja gabe pannema.” Penia ngannenge mundu ojwapolite, ");
INSERT INTO nnq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Na nnenge, nnyeme, ntole likai linu nnyabu kachinu!” ");
INSERT INTO nnq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kingobu bandu boa bakannolekea, mundu jwenio ngajinuka, ngatola likai lyakwe, ngajabula. Bandu boa ngabaomongwa ngabannumba Nnoongo, ngabalenga, “Tanalolaje kilebe andi eche!” ");
INSERT INTO nnq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ngajenda kabele umbwega ji lilaba elikonda Galilaya. Bandu ajingi ngabannyendelela na ngababolanga. ");
INSERT INTO nnq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kingobu apapeta, ngammona ntocha kodi ojwakemigwa Lawi, mwana jwa Alufayo, atamite panyumba ju kutocha kodi. Yesu ngannenge, “Ungengame.” Lawi ngajinuka ngankengama. ");
INSERT INTO nnq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kuboka penia, Yesu apakiba akalya chakulya, kachakwe Lawi. Akatocha kodi ajingi na bina mabaja ngabankengama Yesu na bange ngababe bakalya pamwe na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bange akaboli ba Malagilo ga Musa, abakonda Mafalisayo, apabammona Yesu akalya pamwe na bandu bina malemwa na akatocha kodi ngabakonya akinapunji bakwe, “Mboni alye pamwe na akatocha kodi na bandu bina malemwa?” ");
INSERT INTO nnq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ngabajanga kulenga, “Bandu banga itamwe kunkemaje nng'anga, abankema nng'anga akatamwe. Nhikila kakema bandu ababikibona kube bamboneje, nambu nhikila kakema bina mabaja.” ");
INSERT INTO nnq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Akinapunji ba Yohana Mmatichi na akinapunji ba Mafalisayo batenda kupunganga. Bandu bange ngabaikanga, ngabankonya Yesu. “Mboni akinapunji ba Yohana Mmatichi na ba Mafalisayo batenda kupunganga, nambu akinapunji binu babi kupungaje?” ");
INSERT INTO nnq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ngajanga, “Bo, bandu abakokigwe kumpapala gukutola akege bapaligwa kupunga kingobu akoano babi pamwe nabo? Mangobu pababe pamwe na akoano ipaligwije kupunga. ");
INSERT INTO nnq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nambu, makiika kingobu akoano bapakuboigwa penia nga apabapaligwa kupunga. ");
INSERT INTO nnq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Abije mundu ojwabeka kibamba cha ngobo nhyono mungobo ng'ona, mmanya kibamba kiyono kibakupapu ngobo ng'ona, nu kujonjakea lilanga. ");
INSERT INTO nnq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Abije mundu ojwajela divai nhyono mukitumba kigona, gambu anda atei yene, divai jibakupachula kitumba chenie na divai jipakualabika, ipaligwa divai nhyono kubeka mukitumba kiyono.” ");
INSERT INTO nnq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lichoba limwe li Kupomolela, Yesu na akinapunji bakwe apeta mumigonda ja ngano, undela akinapunji bakwe ngabatumbu kuchwamu myejo ja ngano. ");
INSERT INTO nnq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafalisayo pababonanga ngabankonya Yesu, “Mboni akinapunji binu batendanga gangapaligwa Lichoba li Kupomolela?” Nno ote! ");
INSERT INTO nnq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu ngabajanga, “Bo nchomangitije patenda Daudi nakajakwe apabakiba na njala? ");
INSERT INTO nnq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Daudi ngajingi unyumba ja Nnoongo, ngalye mikate ejibekigwe lilumbo likunnumba Nnoongo. Genia gapitila kingobu Abiasali apakiba Nkung'i nkolongwa. Malagilo galenga Nkung'i tu ojwapaligwe kulye mikate jenie. Nambu ngalye Daudi uyo ngabape bandu bakwe.” ");
INSERT INTO nnq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu ngalenga “Lichoba li Kupomolela libekigwe magambu ga bandu, na bandu babekigweje magambu gu Lichoba likupomolela. ");
INSERT INTO nnq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yene, Mwana jwa Mundu akweti uwecho ata Lichoba li Kupomolela!” ");
INSERT INTO nnq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu ngajingi kabele munyumba ji kugongalela na mwenio akiba mundu ojwapolite luboko. ");
INSERT INTO nnq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Munyumba mwenio bakiba bandu bapala bantakiane Yesu, yene ngabannolekea anda mannamia mundu Lichoba li Kupomolela. ");
INSERT INTO nnq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ngannenge mundu jwenio ojwapolite luboko, “Nhwike nnongi.” ");
INSERT INTO nnq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kubokapenia ngabakonya bandu, “Bo, chako chikipaligwa kutenda mumalagano gito Lichoba li Kupomolela kutenda kilebe chambone andaje kutenda kilebe changambone?” Kukombo bwomi andaje koma? Nambu angweto ngabatamanga nuu. ");
INSERT INTO nnq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Penia Yesu ngabalolakea ku lilaka, ngababone kia kwa magambu ga kujundupa myojo jabe. Napenia ngannenge mundu jwenio, “Ntondobeye luboko lwinu!” Na jwenio ngatondabeya, luboko lwakwe ngululama. ");
INSERT INTO nnq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mafalisayo ngagapita panja, ngababeka machabuli pamwe na bandu ba Helode, kupala ndela ji kunkoma Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ngaboka penia pamwe na akinapunji bakwe, ngabajenda umbwega ji lilaba likolongwa li Kugalilaya, nankengeni nkolongwa gwa bandu ngunkengama. Bandu benia baika kuboka kuilambo ya Galilaya nu Kuyudea, ");
INSERT INTO nnq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kuboke Kuyelusalemu kilambo cha Idumea, kwie ju lukemba lwa Yolidani, ku Tilo na ku Sidoni. Bandu benia ajingi ngabannyendele Yesu kwa magambu ga kujoa ilebe ijingi eyatenda. ");
INSERT INTO nnq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu ngabalenge akinapunji bakwe bampali ntumbwi gumwe, kupala bandu bakamandakije. ");
INSERT INTO nnq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Akiba balamiinge bandu ajingi, na akatamwe boa bapalanga kupekenyela kupala kakunyula. ");
INSERT INTO nnq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bandu bina michepela kila apabammona Yesu, ngabagwe pae nnongi jakwe nu kuchobela, “Mwe Mwana jwa Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nambu Yesu ngabaamulicha kutenda bakalenge banduje kutenda jwenio nga meneke. ");
INSERT INTO nnq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ngaombe pikitombi, ngabakemanga abapaile. Na benia ngabannyendelela, ");
INSERT INTO nnq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ngabapambula bandu komi na abena, ngabakonda achandundame. Ngabalenge, “Nanchagulinge mmegange pamwe na nenga. Na uyo mbakumtumanga kutaali makatangache ku bandu. ");
INSERT INTO nnq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na mampata kinala chu kuboya michepela.” ");
INSERT INTO nnq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Benia komi na abena abapambuligwe, Simoni, Yesu ngampe liina Petulo, ");
INSERT INTO nnq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na Yohana, ingota ya Zebedayo Yesu ngaipe liina lya Boanelige, mana gakwe “Bandu bukulindima,” ");
INSERT INTO nnq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andulea na Filipo na Batolomayo na Matayo na Tomasi na Yakobo mwana jwa Alufayo na Tadei na Simoni Nkanaani, ");
INSERT INTO nnq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yuda Isikalioti ojwanng'aluka Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kubokapenia Yesu ngajabula kachakwe. Bandu ajingi ngabakongana kabele, mpaka Yesu na akinapunji bakwe kuchipu kulye. ");
INSERT INTO nnq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Akalongomundu apabajoa genia, ngabajenda kuntola, magambu bandu balenga, “Ntamwe machonjo!” ");
INSERT INTO nnq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bange akaboli ba Malagilo ga Musa kuboka Kuyelusalemu, ngabalenga, “Akweti Belizebuli, kabe ajibenga michepela kwa makakala ga nkolongwa ju michepela.” ");
INSERT INTO nnq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Penia Yesu ngabakema, ngabalenge kukulandanakia, “Lichetani liotwabo kuliboya Lichetani? ");
INSERT INTO nnq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Anda kingwana chimwe kikibagine ikuta ikuta eijomana, kingwana chenie kipakugwe. ");
INSERT INTO nnq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Anda lungolo lumwe lukibagine ikuta ikuta eijomana, lungolo lwenio lubakupela. ");
INSERT INTO nnq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Anda kingwana chi Lichetani kikibagine ikuta ikuta ichimwine, kingwana chenie kipakugwe nu kujomoka mbyu. ");
INSERT INTO nnq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Abije mundu ojwapakuoto kujingi munyumba ja mundu juna makakala nu kumpoka ilebe yoa, mpaka antabe oti mundu jwenio, penia apakuoto kumpoka ilebe yoa. ");
INSERT INTO nnq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nannenge kweli, Nnoongo mabalekekeya bandu mabaja gabe goa na matukano gabe goa. ");
INSERT INTO nnq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nambu abapakuntukana Uhuke jwa Chwapi balekekeigwaje ngu, babi na mabaja machoba goa pangapela.” ");
INSERT INTO nnq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu alenga yene gambu bannenga “Akweti nchepela.” ");
INSERT INTO nnq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Amamundu Yesu ninung'una yakwe ngaba jenda penia, ngabajema panja, ngabantuma mundu ankeme Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bandu ajingi bakiba batamangite penia kuntindila. Ngabannenge, “Amabinu na inuna inu bankema panja.” ");
INSERT INTO nnq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu ngalenga, “Amabango ni inuna yango nga beneke?” ");
INSERT INTO nnq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Penia ngabalolekea bandu abantindilinge, ngalenga, “Nno! Bamba nga akamabango na inunayango. ");
INSERT INTO nnq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundu jwajwoa ojwakamu agapala Nnoongo, jwenio nga nkaka gwango, nnombo gwango na amama bango.” ");
INSERT INTO nnq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu ngatumbu kubola kabele kiti abi umbwega ja lilaba likolongwa li Kugalilaya. Nkengeni ogukiba penia ukiba nkolongwa penia Yesu ngaombe mutumbwi ngatama mwenio. Na bandu boa ngabatamanga pajomo umbwega ji lilaba likolongwa. ");
INSERT INTO nnq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ngababolanga ilebe ijingi kukulandanakia, ngabalengela, ");
INSERT INTO nnq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mpenekiange! Akiba mundu ojwajenda kumicha mbeju. ");
INSERT INTO nnq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Apamicha mbeju munng'onda, yenge ngitola undela, ijuni ngiika ngionyola. ");
INSERT INTO nnq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yenge ngitola pamaganga panga lutope lujingi. Ngimalika chokwe, magambu lutope lukiba lujingije. ");
INSERT INTO nnq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lumu pulubala, ngilembuka, magambu mikega jakwe jikiba yeluyelu, ngijoma. ");
INSERT INTO nnq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yenge ngitola pimikongo jamiba, na miba ngikola nu kuibalakia ipambikije. ");
INSERT INTO nnq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nambu yenge mbeju ngitola pulutope lwambone, ngimalika, ngikola nukupambika, lumwe mbonji salasini na yenge sitini na yenge mia.” ");
INSERT INTO nnq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kuboka penia ngabalenge, “Juna machikilo ajoe!” ");
INSERT INTO nnq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu apakiba jika jakwe, kati ja abakampenakia ngabanyendelela pamwe na akinapunji bakwe komi na abena, ngabankonya mana gukulonge kukulandanakia kwenio. ");
INSERT INTO nnq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu ngabalengela, “Mangwetomwe nkweti upeele gu kumanya chili ji kingwana cha Nnoongo,” nambu bange ababi panja kila kilebe balengela kukulandanikia, ");
INSERT INTO nnq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ku yenie, “ ‘Balolanga kweli, nambu bijibonaje, Bapenekianga kweli nambu bamanyaje. Bakatei yene kabi mantendebuki Nnoongo, na jwombe kabi balekakiye.’ ” ");
INSERT INTO nnq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kuboka penia Yesu ngabakonyanga, “Mangweto mmanyije kulandanakia kongono? Mmanyabo, kulandanakia konge? ");
INSERT INTO nnq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpandi ngapanda lilobe lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bandu bange babi andi mbeju eitoi pandela, lilobe anda lipandigwe. Lichetani kuika kuliboya. ");
INSERT INTO nnq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bandu bange babi andi mbeju eitoi pamaganga. Kingobu tu pibilijoa lilobe lyenie, kulipokela kukuala mwojo. ");
INSERT INTO nnq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nambu kolaje ngega nkati jakwe, aijendekea kuliagabala lilobe lyene kingobu tu, kingobu chu kulaga ni michwembo apajipitila magambu ga lilobe lyene, kuotwaje kujendekea. ");
INSERT INTO nnq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bandu bange andi mbeju eitoile pamiba. Benia nga abajoa lilobe lyenie, ");
INSERT INTO nnq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nambu mbwele ja bwomi, kupala uloi na tama ji kupala ilebe ndu, kajingila na kuliibilikia lilobe lyenie, na benia kupambikaje ngokwa. ");
INSERT INTO nnq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nambu bandu bange babi anda mbeju eipandigwe pulutope lwambone. Benia kulijoa lilobe, kulipokela, nu kupambika ngokwa, bange salasini na bange sitini na bange mya.” ");
INSERT INTO nnq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ngajendekea kulongela, “Bo, abi mundu ojwapamba lumuli nu kubeka nhwina andaje kuluekelela lidebe? Ije! Nambu kulubeka panani putala. ");
INSERT INTO nnq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kila chikiigwe kiba kubonekana pukongolou na kila chikiekeligwe kiba kuekuligwa. ");
INSERT INTO nnq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Juna machikilo ajoe.” ");
INSERT INTO nnq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Uyo ngabalenge, “Mpenekianga gwicho echimikijoa! Kipemo chimapemelanga bandu bange, ngucho achapakumpeme Nnoongo, kabe nu kunnyonjekea. ");
INSERT INTO nnq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Magambu mundu juna kilebe majonjekeigwa, nambu jwanga kola kilebe, na chache kichoko cha kweti kipakutoligwa.” ");
INSERT INTO nnq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ngajendekea kulongela, “Kingwana cha Nnoongo kibi andi nyene. Mundu apanda mbeju kung'onda gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kilo abe lugono na mui abe mio mangobu genia nga pimalika mbeju nu ukola, jwenio kumanyaje apitendigwa. ");
INSERT INTO nnq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lutope nga olutenda kipandwa kimalike nukola nu kupambika, kutumbu kututuba liamba lilegalau, kubokapenia mwejo, nu kujomolela mbonji nkati ja mwejo. ");
INSERT INTO nnq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Luponji apulukomala, mundu atumbu kupeta na mbopo, gambu mangobu ga mauno gaike.” ");
INSERT INTO nnq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kabe Yesu ngalenga, “Kingwana cha Nnoongo tulandanakie na nike?” “Tulenga kilandine na nike? ");
INSERT INTO nnq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kibi yene. Mundu ngatola mbeju ya haladali eibi njokonjoko kupeta yoa eibi pannema, mundu ngatola nu kupanda pulutope. ");
INSERT INTO nnq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nambu andaipandigwe, kumalika nu kube litutwe likolongwa kupeta mikongo joa ju mung'onda. Ndambi yakwe ikola ni ijuni kuchenga mihui jakwe mundambi yenie.” ");
INSERT INTO nnq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ngabatangachila bandu nhwalo gwakwe, kukulandanakia andi yene, ngalonge nabo na angweto ngabamanya echalongela. ");
INSERT INTO nnq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Alongije chachoa panga landanakia, nambu apakiba pamwe na akinapunji bakwe ngabalenge kila kilebe kipola. ");
INSERT INTO nnq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kimuyo, lichoba ulyo, Yesu ngabalenge akinapunji bakwe, “Tujomboke tujende kwiye ji lilaba.” ");
INSERT INTO nnq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Penia ngubulekanga nkengeni gwa bandu, akinapunji bakwe ngabajingi muntumbwi mwakiba Yesu, ngabajabulanga. Penia pakiba ni mitumbwi jenge. ");
INSERT INTO nnq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kingobucho tu kimboonga kikolongwa ngikitumbula kuguguma, mawimbi ngagaputa ntumbwi na ntumbu gwenio ngutwele mache. ");
INSERT INTO nnq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu akagoloka kuagami nhwagamilo unyuma ja ntumbwi. Akinapunji bakwe ngaba nnyimuya kulenga, “Aboli, bo, mboni kuagabaje tupa kuwe?” ");
INSERT INTO nnq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu ngajimuka, ngakiamulicha ngimbonga, kulenga, “Nkotoke!” Ngagalenge mawimbi, “Nnende!” Penia kimbonga ngikikotoka, na ngukube jee. ");
INSERT INTO nnq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kubokapenia Yesu ngabalenge akinapunji bakwe, “Mboni nnyogopanga? Bo, tango mmilingitije na imani?” ");
INSERT INTO nnq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nambu ngabajogopanga muno, ngabalengalana, “Mundu ni ojo, upepo na mawimbi kunnyoa?” ");
INSERT INTO nnq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na akinapunji bakwe ngabaika kukilambo cha Akagelasi, kwie ji lilaba likolongwa Kugalilaya. ");
INSERT INTO nnq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kingobu Yesu apauluka muntumbwi, ngakongana na mundu aboka kamakabuli. Mundu ojwakiba ni michepela, ");
INSERT INTO nnq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","na atama kamakabuli. Na akibaje mundu ojwaotwile kuntaba kabena mitondolo, ");
INSERT INTO nnq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","kingobu chenge bantabanga pingu ni mitondolo nambu kila mangobu ngaotola kueketa mitondolo nu kutunulana pingu yene, na akibaje mundu ojwaotwile kunhibilikia. ");
INSERT INTO nnq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Atama kamakabuli nu kiitombi kilo na mui, akachobela nu kukikechanga mabwe. ");
INSERT INTO nnq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Akiba kutaali kingobu apammona Yesu, yene ngammutakila, ngakilikitila majugwa nnongi ja Yesu, ");
INSERT INTO nnq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na ngalenga kanonoya, “Yesu, Mwana jwa Nnoongo ojwabi kunani muno! Mpala nike kwango nenga? Ku liina lya Nnoongo, nannyopa makambotekaje!” ");
INSERT INTO nnq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Alongela genia magambu Yesu annengi, “Nchepela nchapu, mumoke mundu jwenio.” ");
INSERT INTO nnq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yene Yesu ngankonya jwenio, “Lina linu mabeneke?” Mundu jwenio ngajanga, “Lina lyango, ‘Matyala,’ Magambu tubi tajingi.” ");
INSERT INTO nnq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kubokapenia jwenio ngannyopa Yesu akajibengaje michepela mukilambo chenie. ");
INSERT INTO nnq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kikiba kipenga kikolongwa chi magolobe papipi na penia pululela kamachela gi kitombi. ");
INSERT INTO nnq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Michepela jenie ngijinnyopa Yesu, “Mutupeleke kwa magolobe, takagajingile.” ");
INSERT INTO nnq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu ngajijeketela, michepela jenie ngijimpita mundu jwenio ngijijingi mumagolobe. Kipenga choa cha magolobe agakiba elufu ibena ngikielela puelelo mpaka kulilaba, ngikijingila mumache. ");
INSERT INTO nnq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Akachungi ba magolobe ngabatilanga, nukutangacha nhwalo gweno kunnyini nu muilambo yoa ibandakile. Bandu ngabaikanga kugabona agapitile, ");
INSERT INTO nnq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","kingobu pabanhwikalila Yesu, ngabammona mundu ujwajo ojwakiba na matyala gi michepela atamite penia, akwinditi ngobo na abi namalango gakwe, na boa ngabajogopanga. ");
INSERT INTO nnq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bandu abibweni ikobo yenie ngabalanduli bandu ikobo eimpatite mundu jwenio ojwakiba na nchepela nhwalo gwa magolobe. ");
INSERT INTO nnq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kuboka penia bandu ngabatumbu kunnyopa Yesu aboke mukilambo chabe. ");
INSERT INTO nnq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kingobu tu Yesu ngaombe muntumbwi, mundu ojwakiba na nchepela ngannyopa kulongwana nakwe. ");
INSERT INTO nnq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu ajeketileje, nambu ngalenga, “Nnyabule kachinu kwakalongo binu makalandulila ilebe yoa Angwana eibantendile na kia jibakweti kwinu mwenga.” ");
INSERT INTO nnq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Penia, mundu jwenio ngajabula, ngatumbu kutangacha kwenio ku Dekapoli ikobo yoa Yesu eyantendile, bandu boa abajoa genia ngabaomongwa. ");
INSERT INTO nnq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kingobu Yesu pajomboka kabele kwie ji lilaba likolongwa, nkengeni nkolongwa gwa bandu nguguntindila, Yesu kiti abi umbwega ji lilaba. ");
INSERT INTO nnq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kuboka penia kilongoi jumwe jwa nyumba ji kung'ongale Nnoongo liina lyakwe Yailo, ngaika penia. Apammona Yesu, ngakilakatila nnongi ja Yesu, ");
INSERT INTO nnq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ngannyopa kulenga, “Nhwenja jwango ntamwe ambajomoka. Chonde tujende, makammeke maboko ginu, jwenio malama nu kube mmomi.” ");
INSERT INTO nnq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kuboka penia Yesu ngajabu nakwe. Bandu ajingi ngabankengama, nukunhwegelela tii nde. ");
INSERT INTO nnq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pakiba nu munkege juna kitamwe cha ncholo kwa yaka komi nibena, ");
INSERT INTO nnq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","aganu kulaguligwa na akaganga ajingi. Nu kutumia uloi gwakwe gwoa, nambu alamitije na ali jakwe ngijibe mbaja. ");
INSERT INTO nnq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Apajoa nhwalo gwa Yesu, na yene ngapekenyela pankengeni gwa bandu kunyuma ngakunyula ngobo yakwe, ");
INSERT INTO nnq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ngawacha kumwojo, “Anda ngunywile tu ngobo jakwe, manama.” ");
INSERT INTO nnq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ngakunyula lutando lwa Yesu, na myai jakwe ngijijoma kingobu ucho, na ngakibona mwene kutenda mmele gwakwe ulamiigwe mulilola lyakwe. ");
INSERT INTO nnq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kingobucho Yesu ngamanya kube makakala gammokite, yene ngabatendebuki bandu bala, ngakonya, “Beneke abakunywi ngobo yango?” ");
INSERT INTO nnq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Akinapunji bakwe ngabannyanga, “Mmikulola bandu apabunhwegelile, mboni nkonya beneke abankunywile?” ");
INSERT INTO nnq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nambu Yesu ngajendekea kulola ammone ojwatei genia. ");
INSERT INTO nnq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Munkege jwenio, ngamanya agampitile, yene ngaika kukilaya kwa mbwele, ngakilikatila, nu kulenga kweli. ");
INSERT INTO nnq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu ngannenge jwenio, “Manango, imani jinu jinnamiye. Nnyabule kwa tengela, nname kitamwe chinu.” ");
INSERT INTO nnq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kingobu Yesu apakiba akalenga genia, bandu kuboka ku nyumba ja Yailo ngabaika nu kunnenge, “Mwana jwinu ajomwike. Ku nike kujendekea kachumbuya Aboli?” ");
INSERT INTO nnq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu ajalitije chibalongila, “Nambu ngannenge jwenio makajobokaje nhwamina tu.” ");
INSERT INTO nnq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ajeketije kujenda na bandu bange nambu Petulo na Yakobo na Yohana, ununa gwa Yakobo. ");
INSERT INTO nnq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ngabaikanga kachakwe Yailo, Yesu ngajoa manjega, nguto nu kokaleka kujingi. ");
INSERT INTO nnq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngajingi unyumba, ngalenga, “Mboni manjega na nguto? Kamwale ajomwikije, atekugoche tu.” ");
INSERT INTO nnq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Angweto ngubunhweka. Penia ngabapiyanga boa panja, nambu ngabakema awamundu mwana na amamundu na akinapunji bakwe atatu, ngabajingilanga kuchumbi omubabeka mmele gwa mwana jwenio. ");
INSERT INTO nnq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ngankamu luboko, ngannenge, “Talitha, kumi,” mana gakwe, “Kamwale, nannenge, nnyimuke!” ");
INSERT INTO nnq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kingobucho ngajema nu kutumbu kutindi tindila. Akiba na yaka komi ni ibena. Kingobu pagapitila genia bandu ngabaomongwa muno. ");
INSERT INTO nnq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nambu Yesu ngabakelebuya kikobo chenie bakannenge munduje, na ngabalenge bampe chakulya. ");
INSERT INTO nnq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ngaboka paali penia ngabuja kachakwe, ngalongwana na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lichoba li Kupomalela ngatumbu kubola mu nyumba ji kungongalela. Bandu ajingi apabannyoa ngabaomongwa, ngabalenga, “Jwenio apatita ko malango aga? Genia malango nike? Na ibabo ikobo andi eyeye?” ");
INSERT INTO nnq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bo, ojo nga jwajoje chalamalajo, mwana jwa Maliamu, na nkaka gwabe akina Yakobo na Yose na Yuda na Simoni? Bo, akalombo mundu nga batamanga upambaje? Penia ngababe na mbwele kwa genia. ");
INSERT INTO nnq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ngabalenge, “Nnondoli kupataje ichima kachakwe andaje kubandu bakwe, nambu kupata ichima kila paali.” ");
INSERT INTO nnq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Penia alaitije ikobo, nambu ngababeke maboko akatamwe ngabalamanga. ");
INSERT INTO nnq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ngaomongwa magambu gwangaamini gwabe. Kuboka penia Yesu ngajenda kuijiji ya papipi na penia ngababola bandu. ");
INSERT INTO nnq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngabakema akinapunji komi na abena pamwe na ngabakinga abena abena. Ngabape kinala chu kubenga michepela, ");
INSERT INTO nnq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ngabakelebuya, “Makapotoje kilebe chachoa mumwanja gwabe nambu bapotola bokola tu bakapotoje yakulya wala nkoba wala uloi muibwindo yabe. ");
INSERT INTO nnq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nkwindanga ilatu nambu makapotoje mikogo mibena.” ");
INSERT INTO nnq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Uyo ngalenga, “Papotipala pabapakumpokela, ntamanga upo mpaka apampakuboka penia. ");
INSERT INTO nnq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Anda nhwike pikilambo na bakanite kumpokela andaje kumpenakia, mmokanga, penia mpyatanga litukunda mumakongono ginu kupala kachalakicha.” ");
INSERT INTO nnq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kuboka penia angweto ngababokanga penia ngabajenda kutaali na penia, ngabatangachanga Nhwalo Gwambone bandu ngabalapa mabaja gabe. ");
INSERT INTO nnq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ngababenga michepela mijingi, ngabapakaya mauta akatamwe ajingi, ngabalamanga. ");
INSERT INTO nnq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nngwana Helode juku Galilaya ngajoa genia goa, gambu Yesu akajoanika kila paali. Bandu bange ngabalenga, “Yohana Mmatichi ate kuyoka, gambu makakala gi ikobo gabi nkati jakwe.” ");
INSERT INTO nnq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bange ngabalenga, “Jwenio nga Eliya.” Bange ngabalenga, “Ojo nnondoli kati ja akalondoli ba lolo.” ");
INSERT INTO nnq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kingobu Helode apajoa genia genie, ngalenga, “Ojo Yohana Mmatichi! Nga jununhweketa mutwe, ate kuyoka.” ");
INSERT INTO nnq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Machoba gu unyuma Helode akaamulicha kuntaba Yohana mukipungo. Helode atenda yene gambu gukutolana na Helodia ojwakiba nhwana gwa nnuna gwakwe Filipo. ");
INSERT INTO nnq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana mmatichi akate kunkelebuya Helode kulenga, “Ipaligwije kutola aanaba ununu gwinu.” ");
INSERT INTO nnq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Munkege jwenio akatekunchimwa muno Yohana, ngapala kunkoma, nambu aotwije magambu annyogopa Nngwana Helodia. ");
INSERT INTO nnq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Na Helode annyogopa Yohana Mmatichi magambu amanyi kutenda mundu jwenio jukiniaje kabe Nchwapi jwa Nnoongo, kabe ngammeka mulenda gwakwe. Helode ngapala kumpenakia Yohana, iganukube kuboka pa kumpenikia, ngaechuka muno. ");
INSERT INTO nnq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kiika kono Helodia ngapata kijemo. Likiba lichoba lya mpapala gu kombakela kubelekwa kwa Helode, ngababeke mpapala nkolongwa, bandu bakwe bi libalacha lyakwe na akolongwa ba akalenda bakwe na achikilongoi buku Galilaya. ");
INSERT INTO nnq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwana jwakwe Helodia munkege ngajingila, ngaina, nganhwalali mwojo Helode na akageni mundu. Yene Nngwana Helode ngannenge kamwale, “Mikipala nike? Unyope nane manampa chachoa echimikipala.” ");
INSERT INTO nnq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kabe ngalagana kulenga, “Chachoa echimpala unyopatu, manumpage, ata nusu ji kingwana chango.” ");
INSERT INTO nnq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yene kamwale ngaboka, ngabakonya amamundu, “Nyopa nike?” Ngabajanga, “Mutwe gwa Yohana mmatichi.” ");
INSERT INTO nnq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kamwale jwenio ngabuja chokwe kangwana ngajopa, “Mbala umbe kingobu uchenje mutwe gwa Yohana mmatichi.” ");
INSERT INTO nnq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yene angwana ngabaechuka muno, nambu kwa magambu ga kulapila kwabe, na kwa magambu akageni abakiba pampapala, baotwije kunkanalila. ");
INSERT INTO nnq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yene nganhwamulicha nnenda alete mutwe gwa Yohana. Nnenda ngajenda mukipungo nganhweketa mutwe Yohana, ");
INSERT INTO nnq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kuboka penia ngaleta mutwe mulichinia ngabampe kamwale, na jwenio ngabape amamundu. ");
INSERT INTO nnq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Akinapunji ba Yohana apabajoa genia, ngabaika ngabatola mmele gwa Yohana ngabachika. ");
INSERT INTO nnq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Achandundame ngababuja, nukongana na Yesu, ngabalenge goa agabateile nu kubola. ");
INSERT INTO nnq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Penia pakiba na bandu ajingi abajenda nu kubuja kwa Yesu na akinapunji bakwe baotwije kulye chakulya yene Yesu ngabalenge angweto, “Tujende paali pantemela kwenio tukaba jika jito mamakapomolela kachoko.” ");
INSERT INTO nnq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yene angweto ngabajendanga jikajabe muntumbwi paali pantemela. ");
INSERT INTO nnq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bandu ajingi ngababona angweto pababokanga, yene ngabamanya kingobu ucho kababilingite, ajingi kuboka kila kilambo, ngababutakilanga ngabalongelela kuika kwenio kwajenda Yesu na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kingobu Yesu apauluka muntumbwi, ngaubona nkengeni gwa bandu, ngababone kia, magambu bakibanga andi mambelele ganga nchungi. Yene ngatumbu kabola ilebe ijingi. ");
INSERT INTO nnq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pilitipika lichoba, akinapunji bakwe ngaba nnyendelela Yesu, ngabannenge, “Paali pamba papongote, na ngoe kutipike. ");
INSERT INTO nnq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mbaya matabukange bandu maleke bajendange kumigonda nu kuijiji ya papipi, bakaemelange ilyo.” ");
INSERT INTO nnq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nambu Yesu ngabalengela, “Mapagange mangweto chakulya.” Akinapunji ngabankonya Yesu, “Bo, mpala tujende takaemele mikate ku uloi ndu, na kapeganga balyagange?” ");
INSERT INTO nnq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yene Yesu ngabakonyanga, “Nkweti mikate milenga? Nnyende makalolange.” Apabalola, ngabannenge, “Jibi mikate nhwano na yamaki ibena.” ");
INSERT INTO nnq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Penia, Yesu ngabalenge akinapunji bakwe matamikange bandu boa ikuta ikuta pina manyai ga chwapi. ");
INSERT INTO nnq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yene bandu ngabatamanga ikuta ikuta ya bandu mia mia na ya bandu amsini amsini. ");
INSERT INTO nnq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kuboka penia Yesu ngatola mikate nhwano na yamaki ibele, ngalola kunani kumbengu, nu kunnumba Nnoongo. Ngametula mikate, na kape akinapunji bakwe babaganakie bandu. Uyo na yamaki ibele ngababaganakia boa. ");
INSERT INTO nnq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bandu boa ngabalye, nu kujukuta. ");
INSERT INTO nnq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Penia akinapunji gabalokotanga imbolopolo yi mikate na yamaki, ngabatweleyanga ikapo komi ni ibena. ");
INSERT INTO nnq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bandu abalile mikate jenie bakiba akinalome elufu nhwano. ");
INSERT INTO nnq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu ngabalengela akinapunji bakwe bajingi muntumbwi, balongalele kujenda ku Betisaida, kwie ja lilaba likolongwa, kingobu chenie ngabanneka akatabuka bandu. ");
INSERT INTO nnq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kuboka pa katabuka bandu ngajenda kukitombi kugongalela. ");
INSERT INTO nnq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Piika kimuyo, ntumbwi gwakiba panakati ji lilaba likolongwa, Yesu akiba kujomo jika jakwe. ");
INSERT INTO nnq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ngaba bonanga akinapunji bakwe bakalaganga kwa kuputa makasia, gambu upepo uuma kubajenda. Papipi nu kuche, Yesu ngabajendelela akinapunji akajenda panani ja mache. Apala kapetanga, ");
INSERT INTO nnq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nambu angweto ngabammona akajenda panani ja mache. Ngabawacha nu kuchobela, “Ele lihoka!” ");
INSERT INTO nnq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Boa apabammona ngabajogopa muno. Kingobucho Yesu ngalonge nabo, “Nkotokange, nenga. Makajogopangaje!” ");
INSERT INTO nnq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kubokapenia ngaombela muntumbwi omubakiba akinapunji bakwe na upepo ngukotoka. Akinapunji ngabaomongwa muno, ");
INSERT INTO nnq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","bakibanga tango kumanya mana ga mikateje. Gambu malango gabe gakiba gapunganikwe. ");
INSERT INTO nnq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ngabajomboka lilaba, ngabaika kukilambo cha ku Genesaleti, ngaba jemekanga ntumbwi gwabe. ");
INSERT INTO nnq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kingobutu apabapita mumtumbwi bandu ngabammanya Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bai, ngabatindila chokwe kukilambo choa, kila abannyoa kutenda Yesu abi kwako ngabampelekela akatamwe bagonike mumakai gabe. ");
INSERT INTO nnq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kila paali Yesu apajenda, kukijiji na kunnyini andaje kumigonda, bandu ngaba bekanga akatamwe pulubanja, ngabannyopa Yesu bakunyule ati lubiniko lwa ngobo jakwe. Benia boa abankunywile ngabalama. ");
INSERT INTO nnq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo gange na akaboli ba Malagilo ga Musa ngagaika kuboka Kuyelusalemu ngabakongana nnongi ja Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ngababona bange akinapunji bakwe bakalya mikate panga kuya maboko andi apagalenga maboulo ga akinanhota babe. ");
INSERT INTO nnq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kwa magambu Mafalisayo na Akayahudi boa bakengama maboulo ga akinanhota, kulyeje kilebe mpaka ukuya maboko mpaka muiwewe, ");
INSERT INTO nnq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","kabe, kulyegangaje kilebe chachoa kuboka kuchoko, mpaka kukijeleya oti. Kubi na malagilo gange gababoligwe kutumbu lolo kujeleya ikombe, yupalia na yombo ya liaba na indanda. ");
INSERT INTO nnq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mafalisayo na akaboli ba Malagilo ga Musa ngabankonya Yesu, “Bo mboni akinapunji binu ukengamaje maboulo agabutulagile akinanhota bito, nambu balye pangakuya maboko?” ");
INSERT INTO nnq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ngabajanga, “Kube nnondoli Isaya annondola kweli! Makangweto makandendemundu, paandika, ‘Nnoongo alenga, bandu aba bannyali kwa malobe tu, nambu myojo jabe jibi kutaali nane. ");
INSERT INTO nnq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kung'ongalela kwabe kwambonije, mana ilebe ibabolana nga malagilo ga bandu tu, benia bakitanga gangonenga!’ ");
INSERT INTO nnq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Magweto mijileka amuli ja Nnoongo nu kugajali maboulo ga bandu.” ");
INSERT INTO nnq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu ngajendekea kulongela, “Mangweto kupunganikwa ukana Malagilo ga Nnoongo gambu gu ukengama maboulo ginu! ");
INSERT INTO nnq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gambu Musa ngaamulicha, ‘Maichimu awabinu na amabinu,’ Na ‘Ojubatukana awamundu andaje amamundu, mpaka akomigwe?’ ");
INSERT INTO nnq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nambu mangwetumwe mmolanga yene, ‘Anda mudu akweti kilebe chakape awamundu andaje amamundu, nambu alenga kilebe chenie Kolibani, mana gakwe chikipangigwe ku Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bai, apaligwaje kabe kape awamundu andaje amamundu.’ ");
INSERT INTO nnq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yenie nga pamilibembula lilobe lya Nnoongo magambu gwa maboulo gammolana. Kabe gabi gange majingi agantendanga andi genia.” ");
INSERT INTO nnq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu ngaukema kabele nkengeni gwa bandu, ngaulengela, “Umbenekiange mmoa, na mmanyange. ");
INSERT INTO nnq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kibije kilebe echikijingi nkati ja mundu kuboka panja echikiotola kummeka mundu kube mmaja. Nambu echikipita nkati ja mundu nga echikimmeka mundu mumalemwa. ");
INSERT INTO nnq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Juna machikilo gukujoa ajoe!” ");
INSERT INTO nnq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Apauleka nkengeni gwa bandu nu kujingi unyumba, akinapunji bakwe ngaba nkonyanga mana ja kulandanakia kwenio. ");
INSERT INTO nnq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu ngabalenge, “Bo, namangwetumwe mmanyangitije? Bo, mmanyangitije kutenda kilebe chikinnyingi mundu kuboka panja, kuotwaje kummeka mundu kube mmaja, ");
INSERT INTO nnq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kwa magambu chenie kijingi mumwojoje, nambu mulutumbo, nu kuboka penia kipita panja kucholo?” Kwa kulenga nyenie, Yesu ngaijeguya ilyo yoa. ");
INSERT INTO nnq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ngajendekea kulenga, “Echikipita nkati ja mundu ngechikimmeka mundu mumalemwa. ");
INSERT INTO nnq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Magambu kuboka nkati ja mundu, mumwojo gwa mundu, gaboka mawacho mabaja na ngongola na bwii na ukoma, ");
INSERT INTO nnq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ngongola na chojo na ubaja na uwangi na upichadi na bwiu na matukano na kupungwanikwa. ");
INSERT INTO nnq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ilebe yenie ibaja yoa iboka nkati ja mundu, na yammeka mundu, kube mmaja.” ");
INSERT INTO nnq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu ngaboka paali penia, ngajenda kukilambo chu Kutilo. Kwenio ngajingila munyumba jimwe na apaije mundu amanye, nambu aotwije kukiiya. ");
INSERT INTO nnq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Munkege ojwakiba na nhwenja juna nchepela, ngajoa nhwalo gwa Yesu. Ngaika kwa Yesu ngakilekela pae ja makongono gakwe. ");
INSERT INTO nnq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Munkege jwenio akiba Mgiliki, kabila jakwe Mfoinike ku Silia. Ngannyopa Yesu ammoye mwana jwakwe nchepela. ");
INSERT INTO nnq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nambu Yesu ngajanga, “Tuipe oti chakulya ingota. Ipaligweje chakulya cha ingota nu kiilekele imbwa.” ");
INSERT INTO nnq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Munkege jwenio ngabajanga, “Angwana, nambu ata imbwa eibi nhwina mwa mecha kulye imbolopolo yi ingota.” ");
INSERT INTO nnq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu ngannengela, “Kwa magambu ga lilobe lyenie, nnyabu kachinu, kwenio mankolela nhwenja gwinu nchepela gummokite!” ");
INSERT INTO nnq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ngajabula kachakwe, ngankolela nhwenja gwakwe agolwike pikindanda, na kweli nchepela gummokite. ");
INSERT INTO nnq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Penia Yesu ngaboka kilambo cha Tilo, ngapetela ku Sidoni ngaika kulilaba likolongwa lya ku Galilaya kwa kupetela kilambo cha Dekapoli. ");
INSERT INTO nnq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bandu bange ngaba nnete mundu ojwakiba bubu jwangajoa, ngabannyopa Yesu ammeke maboko. ");
INSERT INTO nnq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu ngammoya pankengeni gwa bandu, ngammeka ngonji mumachikilo, ngauna mata na ngankamu lulimi. ");
INSERT INTO nnq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kuboka penia Yesu ngalola kunani kumbengu, ngaechuka, “Efatha,” mana gakwe “Nnyogoke.” ");
INSERT INTO nnq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kingobucho mundu jwenio ngaotola kujoa, kitata chakwe ngichammoka, ngaotola kulongela chwapi. ");
INSERT INTO nnq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ngaba amulichanga bakannengeje mundu nhwalo gwenio, nambu apabakelebuya bakalongeje, ngapabalongela muno. ");
INSERT INTO nnq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bao abajoine ngabaomongwa muno. Ngabaomwanga ngabalenga, “Atei goa chwapi, bapi kindimba bangajoa kujoa, na bubu kulongela!” ");
INSERT INTO nnq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kingobu chenie, bandu ajingi ngabakongana kabele. Bandu benia bakwetangitije chakulya, Yesu ngabakema akinapunji bakwe, ngabalengelanga, ");
INSERT INTO nnq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nabonelanga kia bandu aba kwa magambu bakibanga na nenga kwa machoba matatu, wala bakwetangitije chakulya. ");
INSERT INTO nnq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Anda nalekangite bajabulange kachabe kongo babi na njala bapakuinduka undela, gambu katijabe babokangite kutaali.” ");
INSERT INTO nnq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Akinapunji bakwe Yesu ngabankonya, “Pamba tubi papongoti mundu apata koo chakulya chukujukuta bandu boaba?” ");
INSERT INTO nnq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu ngabakonya, “Nkwetingite mikate milenga?” Ngabajanga “Mikate saba.” ");
INSERT INTO nnq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bai, ngabaamulicha bandu batamange pae. Ngajitola mikate saba jela, ngannumba Nnoongo, ngametula, ngabape akinapunji bakwe babaganakiye bandu, nabombe ngababagananikia. ");
INSERT INTO nnq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bombe uyo bakibanga na yamaki njoko. Yesu ngajilumbila, na kalenge akinapunji bakwe jibaganigwe kwa bandu unyae. ");
INSERT INTO nnq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bandu ngabalye, nukujukuta. Ngabalokota imbolopolo ngitwele ikapo saba. ");
INSERT INTO nnq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bandu abalilangita bakiba elufu ncheche. Yesu ngabatabuka bandu na kaleka bajabule, ");
INSERT INTO nnq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na kingobu ucho ngaombela muntumbwi pamwe na akinapunji bakwe, ngajenda kukilambo cha Dalimanuta. ");
INSERT INTO nnq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bange Mafalisayo ngabannyendele Yesu, ngabatumbu kutaukana nakwe. Ngabapala kuntega, kunyenie ngabannyopa alaye iingi yu kumbengu kutenda Nnoongo annyeketile. ");
INSERT INTO nnq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nambu Yesu ngaechuka umwojo, ngalenga, “Mboni bandu bangoe bapala iingi yi ikobo? Nannenge kweli, lungolo londo lupataje iingi yi ikobo.” ");
INSERT INTO nnq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu ngabalekanga, ngaombe kabele mu ntumbwi, nu kutumbu kujomboka kwie ja lilaba likolongwa. ");
INSERT INTO nnq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Akinapunji bate kulibalila kupoto mikate mijingi, bakiba na nkate gumwe tu mu ntumbwi. ");
INSERT INTO nnq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu ngabalengela akinapunji, “Ntamanga maha! Mmaganga mio na amila ja Mafalisayo na amila ja Helode.” ");
INSERT INTO nnq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Akinapunji ngabatumbu konyana benakangweto, “Balenga genia kwa magambu tukwetije nkate gwagwoa.” ");
INSERT INTO nnq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu ngamanya genia agabalengelana, yene ngabakonya, “Mboni nkonyana nhwalo gwangakola mikate? Bo, mmanyangiteje tango? Mawacho ginu matopeu? ");
INSERT INTO nnq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bo, nkwetingite mio na mmi kulolangaje? Nkwetingite machikilo na kujoje? Bo, mmikombakelaje, ");
INSERT INTO nnq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kingobu apanametula mikate nhwano kape bandu elufu nhwano? Ngankongolanga ikapo ilenga ya imbolopolo?” Ngabajanga, “Komi na ibena.” ");
INSERT INTO nnq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu ngakonya kabele, “Apanametula mikate saba jela na kape bandu elufu ncheche, ngankongolanga ikapo ilenga ya imbolopolo?” Ngabajanga, “Saba.” ");
INSERT INTO nnq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngabakonya, “Tango manamanyangaje?” ");
INSERT INTO nnq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ngabaika ku Betisaida, kwenio bandu bange ngabanneta mundu jwangalola kwa Yesu, ngaba nnyopa ankunyule. ");
INSERT INTO nnq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ngankamula luboko jwangalola jwenio, ngampeleka kumbeto ja kijiji. Kuboka pa kunhuni mata mumio gakwe, Yesu ngammeka maboko panani jakwe ngankonya, “Bo, nhwotwile kukibona kilebe chachoa?” ");
INSERT INTO nnq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mundu jwenio ngalola ngalenga, “Elo, nhotwi kabona bandu, nambu babonekana anda mikongo ejijenda.” ");
INSERT INTO nnq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu ngammekela kabele maboko panani pamio. Ngoe mundu jwenio ngakacha mio, mio gakwe ngagaekuka, ngalola kila kilebe gwicho. ");
INSERT INTO nnq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu ngannenge ajabule kachakwe nu kunkelebuya, “Makabujaje kukijiji!” ");
INSERT INTO nnq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kuboka penia Yesu na akinapunji bakwe ngabajenda kuijiji papipi na ku Kaisalia ja Kufilipi. Undela, Yesu ngabakonya akinapunji bakwe, “Bandu balenga nenga na beneke?” ");
INSERT INTO nnq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngabannyanga, “Bange balenga mwenga nga Yohana Mmatichi, bange Eliya na bange jumwe kati ja akalondoli ba Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu ngabakonya, “Na mangweto bo, nnenga nenga nabeneke?” Petulo ngajanga, “Mwenga nga Kilisto Nkomboi ojwapambuligwe na Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kuboka penia Yesu ngabakelebuya makannenge munduje minhalo jango. ");
INSERT INTO nnq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu ngatumbu kabola akinapunji bakwe, “Mwana jwa Mundu mpaka apotekigwe muno nu ukanigwa na akinanhota, akakung'i akolongwa na akaboli ba Malagilo ga Musa. Makomigwa, nambu lichoba lya tatu mayoka.” ");
INSERT INTO nnq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu ngabalengela nhwalo gwenio panga iya. Penia, Petulo ngantola pantemela, ngatumbu kunkalapila. ");
INSERT INTO nnq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nambu Yesu ngatendebuka, ngaba lolekea akinapunji bakwe, ngankalapila Petulo ngalenga, “Mmoke nnongi jango Malichetani! Mawacho ginu gaboka ku Nnoongoje nambu ga bandu.” ");
INSERT INTO nnq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kuboka penia Yesu ngaukema nkengeni gwa bandu pamwe na akinapunji bakwe, ngabalengela, “Anda mundu jwajwoa jola apala kube napunji jwango, mpakaoti akikane mwene, na apotole nchalaba gwakwe, angengame. ");
INSERT INTO nnq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gambu mundu jwajoa ojwapala kukombola bwomi gwakwe mwene, mauoya, nambu mundu ojwaoya bwomi gwakwe kwa magambu gango nenga na kwa magambu ga Nhwalo Gwambone, maukombola. ");
INSERT INTO nnq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mundu apata nike anda ajipatite dunia joa nu kuoya bwomi gwakwe? Kibije! ");
INSERT INTO nnq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kibije kilebe echibaotwi kupanga gambu gwa bwomi gwakwe. ");
INSERT INTO nnq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Anda mundu amone oni nenga na maboulo gango mulungolo londo lwanga nnyali Nnoongo, Mwana jwa Mundu ammonela oni mundu jwenio, mangobu apapakuika mukibumo cha Awamundu pamwe na akapakachi ba Chwapi ba Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu ngajendekea kulenga, “Nannenge kweli, babi bange upamba bawegangaje panga kukibona Kingwana cha Nnoongo chakaika kwa makakala.” ");
INSERT INTO nnq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kuboka pa machoba sita, Yesu ngabatolanga Petulo na Yakobo na Yohana kunani ja kitombi kitandamau jika jabe. Apabajendekea kulola, Yesu ngagalambuka kumiyo nnongi jabe, ");
INSERT INTO nnq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ngobo yakwe nging'ala, ngibe nhuu mbuu, kupeta mundu jwajoa jola padunia ojwaotwi kupula. ");
INSERT INTO nnq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Penia akinapunji akatatu ngabammona Eliya na Musa bakalongela na Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo ngannenge Yesu, “Aboli, chwapi twenga tube pamba. Mbaya tuchenge iteba itatu, chimwe chinu na chimwe cha Musa na chimwe cha Eliya.” ");
INSERT INTO nnq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jwombe nakajakwe ngabajogopa ata akimanyije chu kulongela. ");
INSERT INTO nnq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kuboka penia ngilipitila liunde ngilyawekelela nikiwili chakwe, ni lilobe ngilijoanika kuboke kuliunde, “Jwenio nga Manango ojunampala, mampenakiange!” ");
INSERT INTO nnq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kingobu ucho akinapunji benia ngabalola tii, nambu bammwenije mundu jonge, nambu Yesu jikajakwe tu. ");
INSERT INTO nnq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Apabauluka pikitombi, Yesu ngabakelebuya “Makannengeje mundu jwajwoa ikobo eimibweni, mpaka Mwana jwa Mundu apapakuyoka kuboka kwa abawile.” ");
INSERT INTO nnq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ngibiliagabala lilagilo lyenie, nambu ngabakonyana bene akangweto, “Mana gakwe ni kuyoka kuboka kwa abawile” ");
INSERT INTO nnq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na ngabankonya Yesu, “Mboni akaboli ba Malagilo ga Musa balenga mpaka oti Eliya aike?” ");
INSERT INTO nnq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu ngajanga, “Eliya atenda kuika kubeka ilebe yoa telatela. Uyo, kunike bai iandikigwe Mumajandiko Gachwapi kutenda Mwana jwa Mundu abakupotekigwa muno nu ukanigwa? ");
INSERT INTO nnq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nannenge, Eliya aike, nabandu ngabantenda pabapalanga andi Majandiko apagalenga nhwalo gwakwe.” ");
INSERT INTO nnq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Apabaikanga kwa akinapunji bange bala, ngabaubona nkengeni nkolongwa gwa bandu penia. Na akaboli bange ba Malagilo ga Musa bakiba bakataukana nabo. ");
INSERT INTO nnq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kingobu bandu apabammona Yesu, boa ngaba nhwomwanga muno, ngabammutakila bampate abali. ");
INSERT INTO nnq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu ngabakonya akinapunji bakwe, “Ntaukana nike nangweto?” ");
INSERT INTO nnq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mundu jumwe pankenga gwenio ngajanga, “Aboli, Nannetite manango kwinu, akweti nchepela ogummeka akaotoje kulongela. ");
INSERT INTO nnq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila kingobu apanhwikilila, kung'wiya pae nu kupita liululu nkano, nu kuyagamino nu kube nnyomo mmele gwoa. Nganajopa akinapunji binu buboyange nchepela gwenio nambu baotolingije.” ");
INSERT INTO nnq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu ngabalengela, “Mangweto mabandu banga imani! Ndama namangweto mpaka lii? Nanhwimbilila mpaka lii? Mannetange mwano pamba!” ");
INSERT INTO nnq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ngabampeleka jwenio kwa Yesu. Kingobutu nchepela apaumona Yesu, ngugunng'wia kakombo jwenio pamakongono gakwe, ngagwe pae, ngagalabuka nu kupita liuluulu munkano. ");
INSERT INTO nnq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu ngabakonya awamundu, “Kutumbu li apatakine ni ilebe andi yenieye?” Benia ngabajanga, “Tangu pakiba mwana.” ");
INSERT INTO nnq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Mangobu majingi nchepela upala kunkoma kung'wiki pamwoto nu umache, kupala unkome. Anda nhwotwile, mutubone kia nu mutukole!” ");
INSERT INTO nnq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ngannengela, “Kwanike nnengite anda nhwotwile! Kila kilebe kube kwa mundu ojwaamine.” ");
INSERT INTO nnq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Awawa benia kingobu ucho ngabaguta kanonoya, “Ngweti imani, nambu tegategaje. Unyalie mbe na imani ngolongwa.” ");
INSERT INTO nnq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu apababona bandu ajingi bakajonjekea kuika nnongi jakwe, ngaukalapila nchepela gwenio. “Nchepela mamantenda mwana ojo kube bubu na jwangajoa, nunhwamulicha, mummoke jonjo na makanyingi kabeje!” ");
INSERT INTO nnq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Penia nchepela gwenio nguchobela, ngung'wia kakombo jwenio pae, kubokapenia ngugummoka. Kakombo jola gabonekana anda ntui, na kila mundu ngalenga, “Awile!” ");
INSERT INTO nnq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nambu Yesu ngankamu luboko, nganyinula, na jwenio ngajema. ");
INSERT INTO nnq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kuboka pa Yesu kujabu kachakwe, akinapunji bakwe ngabankonya kuntemela, “Mboni twe tuotwije kuuboya nchepela?” ");
INSERT INTO nnq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu ngabalenge, “Michepela aina jenie kubokaje kindema nambu kukunng'ongalela Nnoongo tu.” ");
INSERT INTO nnq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na akinapunji bakwe ngababoka penia na ngabajabulanga ku Galilaya. Yesu apaije bandu bamanye okwakiba, ");
INSERT INTO nnq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","magambu akiba akabola akinapunji bakwe, Kulengela, “Mwana jwa Mundu mabankamuya kwa bandu na benia mabankomanga, nambu lichoba lya tatu kuboka pu komigwa mayoka kube mmomi.” ");
INSERT INTO nnq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nambu akinapunji bamanyangitije mana ga maboulo genia, ngabajogopa kunkonya. ");
INSERT INTO nnq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ngabaikanga ku Kafalanaumu, na apakiba ukaja, ngaba konyanga akinapunji bakwe, “Ntaukana nike pamakibanga undela mola?” ");
INSERT INTO nnq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nambu angweto bannyangangiteje, magambu undela bakiba bakataukana akolongwa beneke kati jabe. ");
INSERT INTO nnq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu ngatama pae, ngabakema akinapunji komi na abele, ngabalengela, “Mundu andapaile kube jwa kutumbula mpaka oti akibeke mwene kube unyuma ja bowa na kube mpakachi jwa bowa.” ");
INSERT INTO nnq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Penia ngantola mwana nchokochoko, ngannyemeka nnongi jabe. Ngankumbatila, na ngabalenge angweto, ");
INSERT INTO nnq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Abampoke mwana andi jonjo ku liina lyango, bamboke nenga, na abamboke nenga, bamboke ne tuje, nambu uyo bampoke na jwajo ojwandumite.” ");
INSERT INTO nnq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana ngannenge Yesu, “Aboli, tumweni mundu jumwe akajiboya michepela kwa liina linu, na twenga ngutunkanakia magambu jwenio abi pamweje natwe.” ");
INSERT INTO nnq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nambu Yesu ngalenga, “Makankanakiangaje,” Gambu abije mundu ojwatenda ikobo ku liina lyango, nu upopo kulenga mabaja kwango nenga. ");
INSERT INTO nnq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gambu jwangatugaluka twenga abi upandi gwito. ");
INSERT INTO nnq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nannenge kweli mundu jwajwoa ojwampeganga kikombe cha mache gukunywe magambu mangweto mabandu bango ne Kilisto Nkomboi, mmanya apelelwaje kupoke hupo yakwe. ");
INSERT INTO nnq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Jwajwoa ojwapa kunnyambukia jumwe jwa akachoko kujileka imani jakwe kwango nenga, yakabi mbaya kwa mundu jwenio kuntabalila muntandala gwakwe libwe likolongwa lya kuyagila nu kunnekela mubaali. ");
INSERT INTO nnq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Anda luboko lwinu lummeke mumalemwa, mulunhekete! Mbaya mwe kujingila mubwomi gwa machoba goa pangapela panga luboko, kupeta kube na maboko mabele na kujenda kujahanamu, kumwoto gwangaimika machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mwenio, mbeku yakwe kuweje na mwoto gwakwe kuimikaje. ");
INSERT INTO nnq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na lukongono lwinu lumpelie kujileka imani jinu, mulunhekete! Mbaya kujingila mubwomi gwa machoba goa pangapela panga lukongono, kuliko kube na makongono goa mabele nu kulekeligwa kumwoto gwangaimika machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mwenio, ‘Mbeku yakwe kuweje na mwoto gwakwe kuimikaje.’ ");
INSERT INTO nnq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na lio linu anda lyannemukie kujioya imani jinu, miliboye! Mbaya kujingila Mukingwana cha Nnoongo na lio limwe, kuliko kube na mio goa mabele na kunnekela kumwoto gwangaimika machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mwenio ‘mbeku yakwe kuweje, na mwoto gwakwe kuimikaje.’ ");
INSERT INTO nnq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kila mundu majeguigwa kwa mwoto andi lilumbo pilijeguligwa kwa mwinyo. ");
INSERT INTO nnq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mwinyo chwapi, nambu andauoite kulaa kwakwe, maijonjekeigwa na nike? “Mmegange na mwinyo gu kujeguya nkati jinu, nu kutama kutengela kati jinu.” ");
INSERT INTO nnq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ngaboka penia ngajenda kukilambo cha Yudea, kwie ja lukemba Yolidani. Bandu ajingi ngaba nnyendelela kabele, jwombe ngababola kabele anda patenda machoba goa. ");
INSERT INTO nnq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Gange Mafalisayo ngagannyendela, ngagajiga kuntega ngagankonya, “Bo, ipaligwe analome kaleka aanamundu?” ");
INSERT INTO nnq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu ngajanga kukonya, “Musa ampilingite malagilo gani?” ");
INSERT INTO nnq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Angweto ngabajanga, “Musa alenga analome baotwi kaandiki talaka aanamundu na kaleka.” ");
INSERT INTO nnq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu gabalengela, “Musa anhwandikila malagilo genia magambu gu kujundupa kwa myojo jinu. ");
INSERT INTO nnq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nambu apaitumbula, kupanganigwa dunia, ‘Nnoongo apangana munulome na munkege,’ Anda pagalenga Majandiko Gachwapi. ");
INSERT INTO nnq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kwa magambu genie mundu baleka awamundu na amamundu, aba pamwe na aanamundu, ");
INSERT INTO nnq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","benia baba bamwe.’ Nayene benia abena kabeje nambu mmele gumwe. ");
INSERT INTO nnq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Abije mundu ojwaotwile kukilekania Nnoongo echalondine pamwe.” ");
INSERT INTO nnq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Apabajingila kabele unyumba, akinapunji bakwe ngabankonya Yesu unhwalo gwa kile chenie. ");
INSERT INTO nnq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngabalengela, “Mundu ojwanneka nhwanamundu nu kutola jonge munkege antende ngongola nhwanamundu. ");
INSERT INTO nnq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nu uyo, akege ababaleka angwanamundu nu kutolana na bange batende ngongola angwanamundu.” ");
INSERT INTO nnq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bandu bange ngabannetela Yesu ingota ichoko ichoko aibeke maboko, nambu akinapunji ngabakanakia. ");
INSERT INTO nnq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kingobu Yesu pagabona genia, ngachimwa na ngabalengela akinapunji bakwe, “Mileke ingota yene iike kwango, mikiikanakiaje, magambu Kingwana cha Nnoongo nga magambu ga bandu ababi andi ingota yenje. ");
INSERT INTO nnq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nannenge kweli kutenda mundu jwajotijola jwangapokela Kingwana cha Nnoongo anda mwana ajingije mwenio.” ");
INSERT INTO nnq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Penia ngaitola ingota mukuboko jakwe, ngaibeke maboko, ngailumika. ");
INSERT INTO nnq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu apatumbula kabele mwanja gwakwe, mundu jumwe ngammutakila mbelo, ngakilikitila majugwa nnongi jakwe, ngankonya, “Aboli mambone, ndendabole mbate bwomi gwa machoba goa pangapela?” ");
INSERT INTO nnq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ngankonya, “Mboni mwe ungema nambone? Abije jwambone nambu Nnoongo jika jakwe. ");
INSERT INTO nnq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Magamanyi Malagilo, ‘Makakomaje, makabe na ngongolaje, makajibaje, makapia uchaili gwa uangije, makakoloyaje, majoe awawa binu na amabinu.’ ” ");
INSERT INTO nnq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jwombe ngalenga, “Aboli, genia goa nagaagabile tango apanakiba nakakombo.” ");
INSERT INTO nnq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ngannolekea, ngampala, ngannengela, “Nnibalile kilebe chimwe. Nnyende makauche kila kilebe echinkweti, nu uloi gwenio makape akaocho, na mwe mma nankoba kumbengu, kubokapenia nhwike ungengame.” ");
INSERT INTO nnq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mundu jola pagajoa genia, ngabeka ngenja kumio jakwe, ngajabula kachakwe achimwite, magambu akiba nuloi muno. ");
INSERT INTO nnq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ngabalolake tii akinapunji bakwe na kalenge, “Maiba kujundupa ku bandu bina uloi kujingila Mukingwana cha Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Akinapunji ngabaomongwa na malobe gakwe, nambu Yesu ngajendekea kulongela, “Machabanango, kujundupa mundu juna uloi kujingi Mukingwana cha Nnoongo! ");
INSERT INTO nnq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kujundupa muno ku mundu juna uloi kujingila Mukingwana cha Nnoongo ibi kindema muno ngamia kupeta pililanga lya chingana.” ");
INSERT INTO nnq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Akinapunji bakwe ngabaomongwa muno ngabakonyana, “Nga meneke ojwapakuoto ukomboka?” ");
INSERT INTO nnq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ngabalolakeya, ngabajanga, “Kwa bandu kilebe chenje kuwechakanaje, nambu ku Nnoongo ilebe yoa kuwechakana.” ");
INSERT INTO nnq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petulo ngannengela, “Nnole, twenga tuilekite ilebe ito yoa, tunkengime mwenga.” ");
INSERT INTO nnq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu ngalenga, “Elo, nannenge yene, kila mundu jwajoa ojwajilekite nyumba andaje akakolo andaje akalombo andaje amama andaje awawa andaje ingota andaje migonda kwa magambu gangone na kwa magambu ga Nhwalo Gwambone, ");
INSERT INTO nnq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mampokela mala pa mia ngoe. Nyumba na akaka na alombo na amama ningota ni migonda pamwe na kupotekigwa, na mangobu agaika mampata bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nambu bandu ajingi ababi ngoe bukutumbula mababa bukujomolela, na ajingi ababi ngoe bukujomolela mababa bukutumbula.” ");
INSERT INTO nnq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na akinapunji bakwe akiba undela kujenda kukilambo cha Kuyelusalemu. Yesu ngabalongelela akinapunji bakwe, na akinapunji bakwe ngababeganga na mbwele, na bandu abakengima ngabajogopa. Yesu ngabatola kabele akinapunji bakwe komi na abele umbwega, ngatumbu kalengela gaga agapakumpata. ");
INSERT INTO nnq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Mpenakiange! Tujenda Kuyelusalemu, na kwenio Mwana jwa Mundu bapankamuya kwa akakung'i akolongwa na akaboli ba Malagilo ga Musa. Benia bapakunhukumula akomigwe na kunkamuya kwa bandu banga Akayahudi, ");
INSERT INTO nnq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","benia mabantenda nhwenyo, nukunhuni mata, bapakumputa iboko nu kunkoma, nambu lichoba li itatu mayoka.” ");
INSERT INTO nnq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo na Yohana, ingota ya Zebedayo, ngabannyendele Yesu. Ngabannenge, “Aboli, tupala mututende kilebe chitupakunnyopa.” ");
INSERT INTO nnq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu ngabakonya, “Mpala nantendelange nike?” ");
INSERT INTO nnq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngabannyanga, “Apampakutama pikitebu chinu chi kibumo chi Kingwana, tujopa mwe mutupe tutame namwenga, jumwe kingonu chinu cha kalelo na jonge kingonu cha kangeja.” ");
INSERT INTO nnq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ngabalengela, “Mikimanyije echinnyopanga. Nhwotolinge kunywe kikombe cha kupotekigwa echimbaligwa kunywe? Unhwechangite kubatichigwa anda apambakubatigwa?” ");
INSERT INTO nnq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngabajanga, “Tuotwile.” Yesu ngabalengela, “Kweli nhwotwile kunywela kikombe echimbakunywela nu kubatichigwa kundela ejimbakubatichwa. ");
INSERT INTO nnq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nambu nenga ngwetije amuli ja kuchagula beneke abapakutama kalelo andaje kangeja. Nambu Nnoongo ojwapakape paali pennia kwa abachaguligwe.” ");
INSERT INTO nnq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Akinapunji bange komi pabajoa genia, ngabatumbu kachimwa Yakobo na Yohana. ");
INSERT INTO nnq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu ngabakemanga boa pamwe, ngabalengela, “Mmanyi kutenda abawachigwa kube akatawala ba dunia batawalanga kwa makakala bandu babe na akiilongoi babe bina makakala makolongwa kwa bandu bena. ");
INSERT INTO nnq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nambu mangwetomwe ikabe yeneje. Nambu mundu ojwapala kube nkolongwa panakati jinu abe oti mpakachi jwa mmoa, ");
INSERT INTO nnq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ojwapala kube jukutumbula panakati jinu, mpaka oti abe mmanda jwa boa. ");
INSERT INTO nnq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gambu Mwana jwa Mundu aikikutumikigwaje, ila kutumikia, na kuboya bwomi gwakwe kube ukombola kwa bandu ajingi.” ");
INSERT INTO nnq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ngabaikanga ku Yeliko, Yesu na akinapunji bakwe pamwe na bandu ajingi apabakiba bakaboka kukilambo chenie, jwangalola jumwe nnyopi ojwakonda liina lyakwe Batimayo mwana jwa Timayo akiba atamite umbwega ja ndela. ");
INSERT INTO nnq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Apajoa kutenda nga Yesu juku Nazaleti, ngatumbula kuchobela, “Yesu! Mwana jwa Daudi! Umone kia!” ");
INSERT INTO nnq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bandu ajingi ngabankalapila akotoke. Nambu jwombe ngayangala kuchobela, “Mwana jwa Daudi umone kia!” ");
INSERT INTO nnq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu ngajema ngalenga, “Mankemange.” Ngabankemanga jwangalola jwenio. Ngabannenge, “Nnimbe mwojo!” “Nnyeme, atenda nkema mwe.” ");
INSERT INTO nnq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jwombe ngalekela lutando lwakwe, ngaomba kunani, ngannyendele Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ngankonya, “Mpala nantende nike?” Jwangalola jwenio ngajanga, “Aboli, nyopa nhoto kulola.” ");
INSERT INTO nnq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ngannengela, “Nnyende, imani jinu jinnamie.” Kingobu tu jwangalola jwenio ngaotola kulola, na ngankengama Yesu undela. ");
INSERT INTO nnq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Apabakiba bakabandakila Kuyelusalemu, papipi na kilambo cha Betifage na Betania, ngabaika Pikitombi cha Mizeituni. Yesu ngabatuma akinapunji bakwe abele balongelele, ");
INSERT INTO nnq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ngabalengela, “Nnyendange kukijiji echikibi nnongi jinu. Apampakujingi mwenio, mamankolela mwana jwa liponda ajigiligwe, jwombe tango anaombaligwaje na mundu. Mankulugule mannetange. ");
INSERT INTO nnq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Anda mundu ankonyangite, mboni ntendanga nyenela, mannengela, bilipala Angwana na mabilibuya kingobu chenje.” ");
INSERT INTO nnq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ngabajabula, ngabankolela mwana liponda undela bantabali paniango gwa nyumba. Apabakiba pabankulugula, ");
INSERT INTO nnq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bange bandu abakiba bajemangite penia ngabakonya, “Mboni mankulugula mwana liponda jwenio?” ");
INSERT INTO nnq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Akinapunji ngabajanga anda Yesu apabalengalinge, na bandu benia ngabaleka bajabulange. ");
INSERT INTO nnq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ngabampelekela Yesu mwana liponda jwenio, ngabatandikanga ngobo yabe panani ja mwana liponda jwenio na Yesu ngatama panani jakwe. ");
INSERT INTO nnq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bandu ajingi ngabatandika ngobo yabe undela, na kongo bange ngabatema matutwe mumigonda ngabajala undela. ");
INSERT INTO nnq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bandu abakiba nnongi jakwe na abakengima unyuma jakwe, ngabakwaja kulilobe likolongwa kulenga, “Alumbigwe Nnoongo! Nnoongo ampe kindimba ojwapakuika ku liina lya Angwana! ");
INSERT INTO nnq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kibe ni kindimba kingwana chikipakuika cha awabito ana Daudi. Alumbigwe Nnoongo kunani kumbengu!” ");
INSERT INTO nnq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu paika Kuyelusalemu, ngajenda ku Nyumba ja Nnoongo, ngalola kila kilebe ku kuingakia. Nambu kwa magambu jakiba kimuyo, ngajabula ku Betania pamwe na akinapunji bakwe komi na abena. ");
INSERT INTO nnq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Malabu jakwe, apabakiba bakaboka ku Betania, Yesu ngabe na njala. ");
INSERT INTO nnq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ngaubona kutaali nkongo ntini guna maamba majingi. Ngaujendelela alole anda ubi na ngoko yayoa. Nambu apuwikalila, ngaukolela upambikeje ila maamba jika, kwa magambu gwakiba tango mangobu ga kupambika. ");
INSERT INTO nnq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu ngaulenge ntini, “Kuboka lele na machoba goa abije mundu ojwapakulye ngokwa kwinu mwe!” Akinapunji bakwe ngabajoanga malobe genia. ");
INSERT INTO nnq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Apabaikanga Kuyelusalemu, Yesu ngaika ku Nyumba ja Nnoongo na ngatumbu kabenga bandu abakiba bakaucha nu kuemela ilebe mwenio. Ngapendengulana mecha ya bandu abakiba bakajangangana uloi, ni itebu ya bandu abakiba bakaucha njeba, ");
INSERT INTO nnq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","na Yesu annekiteje mundu atole kilebe pulubanja lwa nyumba ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kubokapenia ngababolanga bandu, “Ijandikigwe mu Majandiko Nnoongo alengite, ‘Nyumba jango jikemigwa nyumba ja kugongalela kwa bandu ba ilambo yoa.’ Nambu mangweto mujitei kube nduka ja akabwii!” ");
INSERT INTO nnq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Akakung'i akolo na akaboli ba Malagilo ga Musa apabajoa genia, ngabatumbu kupala ndela ja kunkoma Yesu. Nambu ngabannyogopa, magambu bandu ajingi batenda kuomongwa maboulo gakwe. ");
INSERT INTO nnq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Apiika kimuyo, Yesu na akinapunji bakwe ngababoka pannyini. ");
INSERT INTO nnq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Malabo jakwe kilokilo, apabakiba bakapeta undela, ngububona nkongo ntini gola, unyalite gwoa maamba mpaka mikega. ");
INSERT INTO nnq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo ngaukombakela, ngannenge Yesu, “Aboli, nnole, nkongo ntini ogumubekita nhwilo gola, ujomite!” ");
INSERT INTO nnq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu ngabajanga, “Munhwamini Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nannenge kweli kutenda, Mundu anda akilengile kitombi chenje, ‘Nnyikuke makatumbukile kubaali, panga mbwele kumwojo gwakwe,’ Nambu aamini kutenda ilebe yoa eyalongela, Nnoongo maitenda. ");
INSERT INTO nnq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Magambu genia nannenge mangweto, apang'ongalela nukujopa chochoa ku Nnoongo, nhwamini kutenda mpatite. ");
INSERT INTO nnq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Apannyemanga kugongale ku Nnoongo, mannekekeye kila mundu ojwannemwite chachoa, ibe Awawa binu ababi kumbengu bannekekeya malemwa ginu.” ");
INSERT INTO nnq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nambu panga alekekeya bange, ata Awabinu ababi kumbengu banekekeyaje mangweto malemwa ginu. ");
INSERT INTO nnq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ngabaikanga kabele Kuyelusalemu. Yesu apakiba akajenda ku Nyumba ja Nnoongo, akakung'i akolongwa na akaboli ba Malagilo ga Musa na akananhota ngabannyendela, ");
INSERT INTO nnq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ngabankonya, “Ntenda ile yenie kukinala gani? Bene abampi kinala chenie?” ");
INSERT INTO nnq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ngabalenge, “Na nenga mbakunkonya kilebe, anda unyangangite, na nenga nannyanga ndenda ikobo yenje kukinala gani. ");
INSERT INTO nnq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Unengele, uwecho gwa Yohana gukubaticha uboka kumbengu, andaje uboka kubandu?” Unyangange. ");
INSERT INTO nnq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngabatumbu kutaukana, “Tulengabo? Anda tulengite, ‘Kuboka ku mbengu,’ alenga, ‘Mboni, munhwaminingije Yohana?’ ");
INSERT INTO nnq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nambu anda tulengite, ‘Ubokita kubandu.’ ” Bajogopa bandu ajingi gambu boa baamininge kutenda Yohana akiba kweli nnondoli jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngabannyanga Yesu, “Tumanyije.” Yesu ngabalengela, “Nane uyo nannengeje ngamwa ilebe yenje kukinala gani.” ");
INSERT INTO nnq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu ngalonge nabo kwa kulandanakia, “Mundu jumwe ngalema nng'onda gwa mizabibu, ngalitindikia ubego, ngaemba libomba lya ukamangi zabibu, na ngachenga kilendo. Ngabajaika akibalua bange na ngajenda mwanja kukilambo cha kutaali. ");
INSERT INTO nnq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mangobu ga mauno, ngabankinga mmanda jwabe kwa akalemi, akatolele lipungu lyabe lya mauno li munng'onda gwabe. ");
INSERT INTO nnq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Akalemi benia ngabampukila, ngabamputa, ngabammuyanga utopo. ");
INSERT INTO nnq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngankinga kabele mmanda jonge, jwenio uyo ngabampoteka umutwe nu kuntenda ilebe yaoni. ");
INSERT INTO nnq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akola nng'onda benia ngabankinga kabele mmanda jonge kwa akalemi benia ngabankomanga. Ngabatuma akabanda bange ajingi benia uyo ngabaputigwa, na bange ngabakomigwa. ");
INSERT INTO nnq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ngaika mundu jumwe tu jukuntuma, jwombe mwana jwakwe jwajika ojwampala. Pukujomolela ngankinga jwenio akalenga ‘Manyi mabannyali manango.’ ");
INSERT INTO nnq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nambu akalemi benia ngabalengalana, ‘Jonjo nga mwana jwakwe. Nyeme tankome, nu ulichi gwakwe mauba gwito!’ ");
INSERT INTO nnq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ku nyenie ngabampukila, ngabankoma nu kunnekela kumbeto ja nng'onda.” ");
INSERT INTO nnq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu ngabakonya, “Nkola nng'onda atendabole? Apakuika nakakoma akalemi, nakape bandu bange nng'onda gwa mizabibu. ");
INSERT INTO nnq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bo, nchomangitije Majandiko ganga? ‘Libwe elikanigwe na akachengi, ngoe ligalambwike kube lyambone kupeta goa. ");
INSERT INTO nnq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nhwalo gongo utendigwe na Angwana ana Nnoongo, na lyenie likuomongwa muno kwito!’ ” ");
INSERT INTO nnq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Akiilongoi Akayahudi ngabajiga kumpukila Yesu, magambu bamanyangite kutenda kulandanakia kwenio kukiba kwabe angweto. Nambu bujogopa nkengeni ga bandu, kunyenie ngabanneka, ngabajabulanga. ");
INSERT INTO nnq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gange Mafalisayo na abankengama Helode ngabakinga bakampukile Yesu kwa malobe gakwe. ");
INSERT INTO nnq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ngabannyendelela, nukulenga, “Aboli, tumanyi kutenda mwenga nga mamundu manonge kweli kunnyogopaje mundu jwajoa. Kujalije kinala cha mundu nambu mmola kweli ja ndela ja Nnoongo. Mutulengele, bo, malagilo gito galenga ipaligwe kulepa kodi ku nkolongwa jwa Loma? Tulepe andaje takalepaje?” ");
INSERT INTO nnq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nambu Yesu ngamanya echibapala, ngabajanga, “Mboni nnyiganga kundega? Unete luela nulubone.” ");
INSERT INTO nnq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ngabanete lumwe, jwombe ngabakonya, “Kumiyo na liina lende lyabene?” Ngabajanga, “Kwa Akolongwa ba Loma.” ");
INSERT INTO nnq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu ngabalengela, “Ga Nkolongwa jwa Loma mampa Nkolongwa jwa Loma, ga Nnoongo mampagange Nnoongo. Ngabanhwomwanga muno Yesu.” ");
INSERT INTO nnq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bange Masadukayo, abalenga kubije kuyoka ngabannyendele Yesu, ngabankonya, ");
INSERT INTO nnq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Aboli, Musa atulagila nyene, ‘Mundu andawile na kaleka akege gwangabe na mwana, nnung'una mundu batole malekwe, kupala bampotole nnung'una gwakwe ingota.’ ");
INSERT INTO nnq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bai, pakiba na akalongo saba, nkolongwa ngatola munkege mwene ngawe pangabe na mwana. ");
INSERT INTO nnq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jwapabele ngatola malekwe nawele jwenio, na jwenio uyo ngajomoka pangapoto mwana. Ngibe uyo kwa nnung'una jwa tatu. ");
INSERT INTO nnq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Akanung'na boa saba ngabaweganga pangapoto mwana. Pukujomolela munkege jola uyo ngawe. ");
INSERT INTO nnq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bai, bandu pabapakuyoka, lichoba lya kuyoka bandu, amama benia biba aanaba ba beneke? Kwa magambu boa saba bakiba bantoile.” ");
INSERT INTO nnq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ngabalengela, “Mangweto nnemwangite muno! Mmanyi kwa magambu gwanike? Kwa magambu mmanyingitije Majandiko wala uwecho gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gambu abawilengite apabapakuyoka bitolaje akege wala kutoligwa na analome, bibaganga anda akapakachi ba kumbengu. ");
INSERT INTO nnq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nambu kunhwalo gwa kuyoigwa kwa abawile, bo, nchomangitije Kitabu cha Musa paali pa kindumba echikikiba chakajaka mwoto? Nnoongo ngannengela Musa, ‘Nenga na Nnoongo ba Ulaimu, Nnoongo jwa Isaka na Nnoongo jwa Yakobo.’ ");
INSERT INTO nnq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jwombe nga Nnoongo jwa bandu ababi momi, nambu jwa abawileje. Mangweto ntekulemwa muno.” ");
INSERT INTO nnq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jumwe jwa akaboli ba Malagilo ga Musa ngaika, ngajoa kutaukana kwabe. Ngamanya kutenda Yesu bajanga tela, kunyenie ngannyendelela ngankonya, “Amuli jako ejibi ngolongwa kupeta joa?” ");
INSERT INTO nnq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ngajanga, “Amuli ejibi ngolongwa jenje, ‘Mpenikie, Mangweto bandu ba Kuisilaeli! Angwana ana Nnoongo bito, nga Angwana bito. ");
INSERT INTO nnq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mapale Angwana ana Nnoongo binu kwa mojo gwinu gwoa, kwa kiuke chinu choa kwa malango ginu goa, na kwa makakala ginu goa.’ ");
INSERT INTO nnq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na jibena ngajenje, ‘Mumpale nndami nnyinu anda pimikipala mmene.’ Jibije amuli jenge ejibi ngolongwa muno kuipeta yenje ibena.” ");
INSERT INTO nnq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Penia Aboli ba Malagilo ga Musa ngabannengela Yesu, “Chwapi, Maboli! Kweli, anda apannengite, kutenda Nngwana nga Nnoongo na kuyenie abije nnongo jonge nambu jwenio. ");
INSERT INTO nnq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na kumpala Nnoongo kwa mojo gwinu gwoa na kwa malango ginu goa na kwa makakala ginu goa na kumpala nndami nnyinu anda apamikipala mmene, nhwalo gongo gwa mbone muno kupeta kumpe Nnoongo lilumbo li inyama yu kutinia.” ");
INSERT INTO nnq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu apalola kutenda mundu jwenio annyanga chwapi, ngannengela jwombe, “Mwenga mmi kutaalije na Kingwana cha Nnoongo.” Kuboka penia mundu ajigiteje kunkonya kilebe. ");
INSERT INTO nnq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mangobu Yesu apakiba akabola ku Nyumba ja Nnoongo, ngakonya, “Mboni akaboli ba Malagilo ga Musa balenga kutenda Kilisto Nkomboi ojwapambuligwe na Nnoongo nga Mwana jwa Daudi? ");
INSERT INTO nnq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Uhuke jwa Chwapi annongolea Daudi ngalenga, ‘Angwana ngabalengela Angwana bango, ntame kingonu chango cha kalelo mpaka apambakabeka akangondwa binu pae ja makongono ginu.’ ");
INSERT INTO nnq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi mwene ankema, ‘Angwana’, Bai, Kilisto Nkomboi ojwapambuligwe na Nnoongo iwechakanabo kube mwana jwa Daudi?” Bandu ajingi abampenakia Yesu ngabaalalila muno. ");
INSERT INTO nnq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu apabola angweto, ngalenga, “Magajogopange akaboli ba Malagilo ga Musa, abapala kutyanga na ngobo yabe yina miniko eibambigwe nu kupala kupatigwa abali ni ichima kuchoko, ");
INSERT INTO nnq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","abachagula itebu ina ichima mu nyumba ja kugongalela na paali pina ichima pa mpapala. ");
INSERT INTO nnq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kapokanga ilebe akanawele na kajibanga angweto nyumba yabe, na ukopakea kunng'ongalela Nnoongo muno. Ukumu jabe jiba ngolongwa muno lichoba lya hukumu.” ");
INSERT INTO nnq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu apakiba atamite papipi ni lichanduku lya malumbo, akalolela bandu apabapanga uloi gwabe. Bina uloi ajingi ngaba panganga uloi nduu, ");
INSERT INTO nnq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","penia ngaika nawele nhwocho nu kupanga uloi gwa lyaba ibena. ");
INSERT INTO nnq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Penia Yesu ngabakemanga akinapunji bakwe, ngabalengela, “Kweli nannengelanga, amama nawele aba babekite uloi ndu mulichanduku kapeta boa. ");
INSERT INTO nnq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gambu boa ngabapanga kile echibapatite nyonjakea uloi gwabe, nambu amama aba, bapangite yoa eyabakiba nayo, bapangite yoa eyabakweti babe na bwomi muno.” ");
INSERT INTO nnq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu apakiba akaboka pa Nyumba ja Nnoongo, napunji jwakwe jumwe ngannengela, “Nnole, Aboli! Apagaalile mabwe ganga na nyumba yakwe!” ");
INSERT INTO nnq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu ngajanga, “Mibona nyumba yenje ngolongwa? Libije ati libwe limwe elipakuigala panani ja lenge, kila kilebe makibomoligwa.” ");
INSERT INTO nnq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu apakiba atamite pikitombi cha Mizeituni, ngalola ku Nyumba ja Nnoongo, Petulo na Yakobo na Yohana na Andulea ngabankonya pa ntemela. ");
INSERT INTO nnq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Mutulengele ikobo yenje ipakuika li? Na kiingi nike echikipakubonekana kutenda ikobo yenje ibandakile kupitila?” ");
INSERT INTO nnq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ngabalenge, “Mma maha akankoloya munduje. ");
INSERT INTO nnq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bandu ajingi, mabaika mabikikema liina lyango, kulenga, ‘Nenga nga jwenio!’ Bombe mabaoyanga bandu ajingi. ");
INSERT INTO nnq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pampakujoa nhwalo gwa ngondo papipi andaje kutaali makajogopaje. Ilebe yene mpaka ipitile, nambu kupela kwene kubi tango. ");
INSERT INTO nnq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kilambo chimwe kiputana ni kilambo chenge, kingwana chimwe kiputana ni kingwana chenge, kulendema lutope makuba kila paali na njala. Ikobo yenie iba andi lipyanda lya kubelekwa kwa mwana. ");
INSERT INTO nnq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nambu mangweto mmaganga maha. Bandu mabampelekanga kamabalacha, nu kumputanga bokola mumajumba gabe gu kugongalela. Na bapampeleka nnongi ja akatawala na akangwana kwa magambu gangune, kupala unjalakiche kwabe. ");
INSERT INTO nnq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nambu tangu nu kuikaje pukupela, Nhwalo Gwambone mpaka utangachigwe kwa bandu boa. ");
INSERT INTO nnq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kingobu chabapa kuntakiana nu kumpeleka kamaakama, makapweleje kilebe champakulongela, mangobu pagapakuika, nnengange chachote echimpakupata, gambu mangwetoje andaje mpakulongela, nambu gabakuboka kwa Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mundu anng'aluka nnunagwakwe akomigwe, na awawa banng'aluka mwana gwabe, ni ingota mayajingalila achikibelei mundu na kakomanga. ");
INSERT INTO nnq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bandu boa bapakunchimwa mangweto kwa magambu ga liina lyango. Nambu ojwapakuimbalila mpaka kupela nga ojwapakomboka. ");
INSERT INTO nnq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Apampakulola ‘Libaja’ Lijemite paali pangapakwe, ojwachoma na amanye mana gakwe, penia, ababi ku Yudea batililange kwitombi. ");
INSERT INTO nnq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ojwabi kunani ja kinyanga cha nyumba akaulukaje kujingila munyumba jakwe kutola kilebe. ");
INSERT INTO nnq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ojwabi kunng'onda akabujaje unyuma kutola ngobu jakwe. ");
INSERT INTO nnq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bapakulaga akikege bina ndumbo na akinamama ababi ni ilemba eijonga machoba genia! ");
INSERT INTO nnq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Munnyope Nnoongo kupala ikobo yenie yakapiti mangobu ga malilije. ");
INSERT INTO nnq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Gambu kingobu chenie kubakube kulaga kwenio kwanapitije tangu Nnoongo apapangana dunia mpaka lele, na ipitije kabele. ");
INSERT INTO nnq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nambu Angwana bate kupunguya na yeneje akabije mundu jukomboka. Nambu kwa magambu ga bandu bakwe abapambuligwe, Angwana bapungwiye machoba genia. ");
INSERT INTO nnq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Anda mundu annengi, ‘Nno, Kilisto Nkomboi abi pamba,’ Andaje ‘Abi papa,’ Makanhwaminije. ");
INSERT INTO nnq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gambu papakupiti makilisto buwangi na akalondoli buwangi. Na benia balayanga iingi na yukuomongwa yakaoyanga bandu, ata kubandu abapambuligwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mmaganga maha. Nenga nannengelinge ikobo yoa pangapitila. ");
INSERT INTO nnq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mumachoba genia, kuboka pa kulaga kwenio, lichoba liba lubendu na mwei ung'alaje, ");
INSERT INTO nnq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ndondwa ibakugwe kuboka kumbengu, na makakala ga mbengu gabakutikatika. ");
INSERT INTO nnq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mwana jwa Mundu abakupitila mumaunde kwa makakala makolongwa ni kibumo. ");
INSERT INTO nnq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jwenio apakakinga akapakachi bakwe kuboka kumbengu ingonu yoa ya dunia bakongolange bandu abapambuligwe na Nnoongo kuboka kujitumbwi dunia mpaka kujipei mbengu. ");
INSERT INTO nnq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mukibolange kikilandanakia na nkongo ntini. Kingobu ndambi yakwe pitumbu kututuba maamba, mmanya kutenda mangobu ga mauno gaike. ");
INSERT INTO nnq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nu uyo mangweto pampakibona ilebe yenie yoa ikapitilaga, mmanya Mwana jwa Mundu abi papipi kuika. ");
INSERT INTO nnq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nannengelanga kweli, kingolo chenje kipetaje pangapitila genia goa. ");
INSERT INTO nnq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mbengu na dunia maipeta, nambu malobe gango gapetaje ngu. ");
INSERT INTO nnq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nambu, nhwalo gu lichoba andaje kingobu abije mundu ojwamanyi kiika lii, na akapakachi bukumbenguje, na Mwanaje, nambu Awawa jika jabe nga abamanyi. ");
INSERT INTO nnq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mmegange maha na nkelukiyange, magambu mmanyangitije kingobu chenie kipakuika lii. ");
INSERT INTO nnq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Maiba anda mundu ojwaboka pachakwe kujenda mwanja, nakalekalanga akapakachi bakwe kinala, kila mundu ni liengo lyakwe, nu kuboka penia ngannenge nnendei aba mio. ");
INSERT INTO nnq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nkelukiange, kwa magambu mmanyingitije akola nyumba babuja lii, pangaje iba kimuyo, panakati nakati ja kilo, kindabindabi andaje kindabi. ");
INSERT INTO nnq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Anda aike kingobutu akankolelangaje nng'olokinge. ");
INSERT INTO nnq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aganannenge mangweto, nannenge mmoa, nkelukiange!” ");
INSERT INTO nnq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gakaigala machoba mabena kuika Mpapala gwa Pasaka na Mikate jangajela kimela. Akakung'i akolongwa na akaboli ba Malagilo ga Musa bapalanga ndela ja kumpukila Yesu kwa chili na bankome. ");
INSERT INTO nnq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nambu ngabalenga, “Tukampukije mangobu ga mpapala, bandu bakaikangaje kutendanga kijonga.” ");
INSERT INTO nnq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu akiba ku Betania kachakwe Simoni, ojwakiba juna maloi. Apakiba akalya chakulya, ngabaika amama bamwe abakiba na chupa cha alabasta china mauta gina kunungila muno ga nalido gina bei ngolongwa. Ngakajula chupa chenie, ngannyitila Yesu mauta genia umutwe. ");
INSERT INTO nnq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bandu bange abakibanga penia ngabachimwa nu kulengelana, “Kwa nike kugatunia mauta gangano! ");
INSERT INTO nnq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kabi gauchigwe ku bei ngolongwa, nu kwela kunnepa nkamu maengo kwa yaka itatu, nu uloi gwene kape akaocho!” Ngabakalapila amama benia. ");
INSERT INTO nnq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nambu Yesu ngabalengela, “Malekange! Mboni machumbuya? Batei chwapi ni kile chambone kwango. ");
INSERT INTO nnq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Akaocho mmilingite nabo kila machoba, na kingobu chachoa echimpala, nhwechi kajangata angweto. Nambu mmeje kila machoba na nanenga. ");
INSERT INTO nnq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jwombe ateile apaotwile, aupakie mmele gwango mauta kumbanganila kwa machiko. ");
INSERT INTO nnq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nannengelanga kweli kutenda, padunia poa pupakutangachigwa Nhwalo Gwambone, kitendwa chenje chibatei amama aba kibakulongaligwa kakombake benia.” ");
INSERT INTO nnq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kubokapenia Yuda Isikalioti, jumwe kati ja akinapunji komi na abena, ngajenda kwa akakung'i akolongwa ibe anng'aluke Yesu kwabe. ");
INSERT INTO nnq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Akakung'i akolo ngabaalalila apabajoa nhwalo gwenio, nu kulagila kumpe uloi jwenio. Penia Yuda ngabe akapala ndela ju kunng'aluka Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lichoba lya kutumbula kwa Mpapala gwa Mikate janga jela kimela, lichoba lya mwana limbelele jwa Pasaka kuchinjigwa, akinapunji bakwe ngabankonyanga Yesu, “Mpala tumpanganile ko Mpapala gwa Pasaka?” ");
INSERT INTO nnq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Penia Yesu ngabakinga akabele kati ja akinapunji bakwe ngabalengela, “Nnyendange kunnyini, na mankongana na mundu jumwe ojwapotwi kibega cha mache. Mankengamange, ");
INSERT INTO nnq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mpaka munyumba ejapakujingi, makannengele nkola nyumba, ‘Aboli balenga, chumbi chako echimbakulele mpapala gwa Pasaka pamwe na akinapunji bango?’ ");
INSERT INTO nnq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na jwenio mannayanga chumbi kikolongwa kugolofa, echikipanganigwe kijomoligwe, mpangania mwenio.” ");
INSERT INTO nnq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Akinapunji ngababokanga, ngabajenda kunnyini, ngibikikole kila kilebe tela andi Yesu apabalengalinge, ngabapangania mpapala gwa Pasaka. ");
INSERT INTO nnq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Apiika kimuyo, Yesu ngaika pamwe na akinapunji bakwe komi na abena. ");
INSERT INTO nnq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Apabakibanga bakalyaga, Yesu ngalenga, “Nannengelanga mangweto kutenda jumwe kati jinu apakung'aluka, jumwe kati jinu ojwalye pamwe nanenga.” ");
INSERT INTO nnq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Akinapunji ngabaechuka ngabatumbu kunkonya Yesu, jumwe jumwe, “Bo, nenga?” ");
INSERT INTO nnq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ngabajanga, “Nga mundu jumwe kati jinu mangweto komi na abena, ojwalela nkate pamwe na nenga muntungati. ");
INSERT INTO nnq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwana jwa Mundu mawa andi pagalenga Majandiko Gachwapi nhwalo gwa jwenio, nambu, kulaga mundu jwenio ojwapakunng'aluka Mwana jwa Mundu! Yakabi mbaya kwa mundu jwenio anda akabelwikije!” ");
INSERT INTO nnq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Apabakiba bakalyaganga, Yesu ngatola nkate, ngalumba, ngaumetula na kapaganga akinapunji bakwe, nukulenga, “Ntolange, gongo mmele gwango.” ");
INSERT INTO nnq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kubokapenia ngatola kikombe, nganng'ongolela Nnoongo, ngabapaganga, na boa ngabanyweganga mukikombe chenie. ");
INSERT INTO nnq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu ngalenga, “Jenje nga myai jango ejijitika kwa bandu ndu, myai jango ejichalakicha lilagano lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nannengelanga kweli, nyweje kabele divai mpaka lichoba elimbakunywe divai nhyono ku Kingwana cha Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kuboka pu kujemba nhwambo, ngabajenda kukitombi cha Mizeituni. ");
INSERT INTO nnq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ngabalengela akinapunji bakwe, “Mmoa mwenga mpakutilanga na kuneka ne jika, gambu Majandiko galenga, ‘Nnoongo mankoma nchungi, na mambelele goa magapwilikana.’ ");
INSERT INTO nnq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nambu kuboka pu kuyoka kwango, mbakunnongalela ku Galilaya.” ");
INSERT INTO nnq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo ngajanga, “Ata ikabi boa bannekangite, ne nannekaje!” ");
INSERT INTO nnq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ngannenge Petulo, “Nannenge kweli kutenda tango nkokoloko nu kubekaje pabena kilo, mpakungana patatu kutenda umanyije nenga.” ");
INSERT INTO nnq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nambu Petulo ngajendeke kulenga, “Nengaje yenie, ati nakapaligwe kuwe pamwe na mwenga!” Na akinapunji boa ngabalenga uyo. ");
INSERT INTO nnq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ngabaikanga paali apakemigwa Getisemani, na Yesu ngabalenge akinapunji bakwe, “Ntamange pamba mangobu ne nakagongalela.” ");
INSERT INTO nnq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ngantola Petulo na Yakobo na Yohana. Ngabe na mbwele na ngaechuka muno, ");
INSERT INTO nnq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ngabalenge, “Mbi na kuechuka muno umwojo papipi nu kuwe. Ntamange pamba na nkelukiange.” ");
INSERT INTO nnq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ngajenda nnongi kachoko, ngakileke pae manguku, ngagongalela Nnoongo kutenda, anda iwechikine, akapeteje mangobu genia ga kupotekigwa. ");
INSERT INTO nnq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ngagongalela, “Awabango, kwinu kila kilebe kuwechekana. Umokeye kikombe chenje chukupotekigwa. Nambu ikabe anda apambalaje, nambu pampala mwenga.” ");
INSERT INTO nnq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kubokapenia ngababuji akinapunji bakwe akatatu bala, ngabakole bagochilinge. Ngannenge Petulo, “Simoni, bo, nng'ochile? Nhwotwije ukelukia ata kingobu chimwe?” ");
INSERT INTO nnq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Penia ngabalengela, “Nkelukiange na kugongalela kupala makalondoigwaje. Mwojo utenda kupala, nambu mmele ulegalike.” ");
INSERT INTO nnq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngajenda kugongale kabele, ngabuji malobe ugaga. ");
INSERT INTO nnq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Penia ngabuja kabele, ngabakolelanga bagochalinge. Mio gabe gakiba na lugono. Bamanyangiteje chukunnyanga. ");
INSERT INTO nnq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Apabuja mala ja patatu ngabalengela, “Mmilingite tango makagolokanga nu kupomolela? Itochite! Kingobu kiike! Nnole, Mwana jwa Mundu ngoe bankamuya kwa bandu akabaja. ");
INSERT INTO nnq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nnyinukange tujende. Atendakuika ojwapakung'aluka.” ");
INSERT INTO nnq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu apakiba tango akalongela kingobu Yuda, jumwe kati ja akinapunji bakwe apaika. Ngaika pamwe nankengeni nkolongwa gwa manjolinjoli pamwe na mapanga na imbonga, na ngankamuya kwa akakung'i akolongwa, na akaboli ba Malagilo ga Musa, na akananhota. ");
INSERT INTO nnq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mundu ojwapala kunng'aluka Yesu, akiba tayali aulaite kiingi nkengeni gwenio kulenga, “Mundu ojumbakunkumbatila ngajwenio. Mampukilange na mammekange pulenda.” ");
INSERT INTO nnq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kingobutu Yuda apaika, ngannyendele Yesu nu kulenga, “Aboli!” Penia ngankumbatila. ");
INSERT INTO nnq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kuyene ngabampukilanga Yesu nu kummekanga mumakakala. ");
INSERT INTO nnq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nambu jumwe ojwajemita penia pamwe na Yesu ngaucholomola upanga gwakwe nu kumputa mmanda jwa Nkung'i Nkolongwa, nganhweketa lichikilo. ");
INSERT INTO nnq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Penia Yesu ngabalenge, “Bo, mboni nhwikalinge na mapanga na imbonga kumbukila nenga, anda ne napoki? ");
INSERT INTO nnq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila lichoba nakiba pamwe namangweto nakammolanga ku Nyumba ja Nnoongo, na wala umbukilingije. Nambu Majandiko Gachwapi galenganile.” ");
INSERT INTO nnq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Penia akinapunji boa ngabanneka nu kutila. ");
INSERT INTO nnq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pakiba na kakombo jumwe ojwakiba akankengama Yesu akiba akwindite lutando. Ngabajiganga kumpukila, ");
INSERT INTO nnq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nambu jwombe ngapokonyoka, ngaluleka lutando lola, ngabutuka makengele. ");
INSERT INTO nnq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Penia Yesu ngabantola mpaka ku nyumba ja Nkung'i Nkolongwa, penia bakiba na akakung'i akolongwa boa, ikinanhota na akaboli ba Malagilo ga Musa bakibanga bakonganinge. ");
INSERT INTO nnq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo ngabe kutaali akankengama Yesu, ngajingi mu uwa ja nyumba ja Nkung'i Nkolongwa. Ngatama pamwe na akalendei, akajota mwoto. ");
INSERT INTO nnq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Akakung'i Akolongwa na Libalacha lyoa ngabapalanga uchaili gu kuntakiana Yesu kupala akomigwe, nambu bapatangitije. ");
INSERT INTO nnq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bandu ndu ngabapianga uchaili guwangi ku Yesu, nambu uchaili gwabe ujeketeligweje. ");
INSERT INTO nnq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kubokapenia bandu bange ngabajema kulenga uchaili guwangi ku Yesu, ");
INSERT INTO nnq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ngutunnyoa mundu ojo apalenga, ‘Mbakubomola Nyumba ja Nnoongo ejichengigwe na bandu, nu kuchenga jenge kwa machoba matatu jangachengigwa na bandu.’ ” ");
INSERT INTO nnq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nambu ata angweto, uyo, uchaili gwabe ujeketeligwije. ");
INSERT INTO nnq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nkung'i Nkolongwa ngajema nnongi jabe boa nu kunkonya Yesu, “Bo nnyanguje kwa bandu bamba abantakiana mwenga?” ");
INSERT INTO nnq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nambu Yesu ngatama nu alongije ata lilobe limwe. Nkung'i Nkolongwa ngankonya kabele, “Bo, mwenga nga Kilisto Nkomboi Mwana ojwapambuligwe na Nnoongo juna Kibumo?” ");
INSERT INTO nnq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ngajanga, “Nenga, nga jwenio, kabe mamammona Mwana jwa Mundu atamite kingonu cha kalelo cha Angwana Bina Makakala na akaika mumaunde ga kumbengu!” ");
INSERT INTO nnq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Penia Nkung'i Nkolongwa ngapapula lutando lwakwe kulaya lilaka lyakwe, ngalenga, “Tupaije akachaili! ");
INSERT INTO nnq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nnyoaninge apantukana Nnoongo. Mangweto nhwachangabo?” Boa ngubunhukumula kutenda, apaligwa kuwe. ");
INSERT INTO nnq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bange kati jabe ngabatumbu kunhuni mata Yesu, ngabanhwiba kumio, ngabamputa. Nu kunnengela, “Nnondole nga beneke abamputite!” Ati akalendei ngabantolanga, ngabamputanga makopi. ");
INSERT INTO nnq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petulo akiba tango pae kuua, mmanda jumwe munkege jwa Nkung'i Nkolongwa ngaika. ");
INSERT INTO nnq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Apammona Petulo akajota mwoto, ngannolekea, ngannengela, “Ati mwenga uyo makiba pamwe na Yesu jwa ku Nazaleti.” ");
INSERT INTO nnq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nambu Petulo ngakana. “Numanyije, ati echinnongela mbi kikimanyaje!” Kubokapenia Petulo ngajenda panja kuua. Penia nkokoloko ngabeka. ");
INSERT INTO nnq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mmanda munkege jola apammona kabele Petulo, ngatumbu kabele kalenge bandu abakibanga bajemangite penia, “Mundu jonjo nga jumwe kati jabe!” ");
INSERT INTO nnq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nambu Petulo ngakana kabele. Kingobu tu, bandu abakibanga bajemangite penia ngabannenge Petulo, “Kweli mwenga nga mabamwe kati jabe, gambu mwenga uyo mmoke ku Galilaya.” ");
INSERT INTO nnq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nambu Petulo ngalenga, “Napila yenie kutenda nenga kweli! Nnoongo awechite kunhukumu ne anda nenga uwangi! Numanyi mundu ojunnongela minhalo jakwe!” ");
INSERT INTO nnq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Penia nkokoloko ngabeka kabele, na Petulo ngakombokela Yesu apannengile, “Tango nkokoloko nukubekaje, mpakungana patatu kutenda umanyije ne.” Petulo ngakilikitila nu kuguta. ");
INSERT INTO nnq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pukuchaga, akakung'i akolongwa ngababeka machabuli pamwe na akinanhota na akaboli ba Malagilo ga Musa na Libalacha lyoa, ngabalagana kuntaba Yesu mitondolo, ngabampeleka kunkamuya Pilato. ");
INSERT INTO nnq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato ngankonya Yesu, “Bo, mwe nga Mangwana ba Akayahudi?” Yesu ngajanga, “Elo, mwe nengite.” ");
INSERT INTO nnq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Akakung'i akolongwa bantakiine Yesu ilebe ndu, ");
INSERT INTO nnq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato ngankonya kabele Yesu, “Bo, nnyangaje lilobe? Nnyowa apabanchalakicha mwe.” ");
INSERT INTO nnq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nambu Yesu ajangitije lilobe, mpaka Pilato ngaomongwa. ");
INSERT INTO nnq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila mangobu ga mpapala gwa Pasaka, Pilato akiba na lukobo lwa kaleke mpungwa jumwe ojubampaile. ");
INSERT INTO nnq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kingobu chenie, pakiba na mundu jumwe ojwa kemigwa Balaba, atabigwe mikipungo kwa magambu gu ukoma. ");
INSERT INTO nnq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kingobu pabakongana bandu nu kunnyopa Pilato batendelange lukobo lwakwe. ");
INSERT INTO nnq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato ngabakonyanga, “Bo, mpalanga nannekelange Nngwana jwa Akayahudi?” ");
INSERT INTO nnq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Alenga yene magambu amanyi kutenda akakung'i akolongwa bankamwie Yesu kwakwe kwa magambu ga bwiu tu. ");
INSERT INTO nnq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nambu akakung'i akolongwa ngabakweleke bandu bannyope Pilato banyogole Balaba. ");
INSERT INTO nnq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ngabakonya kabele bandu ba, “Ngoe mpala nantendibo mundu jonjo ojumankemanga Angwana ba Akayahudi?” ");
INSERT INTO nnq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bandu boa ngabatondobea lilobe kabele, “Mammambe panchalaba!” ");
INSERT INTO nnq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nambu Pilato ngabakonya, “Kwa nike! Atei ubaja gani?” Nambu angweto ngabayanga kulenga kanonoya, “Mammambe panchalaba!” ");
INSERT INTO nnq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato apala kaalalila bandu, bai, ngannekeke Balaba apite mikipungo. Ngaamulicha Yesu abambigwe panchalaba. ");
INSERT INTO nnq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Manjolinjoli ngagampeleka Yesu panganya ja boma, ngabakongana ikuta yoa ya manjolinjoli. ");
INSERT INTO nnq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ngabankwindiya Yesu ngobo ya kingwana, ngabapota luchengo lwa miba, ngabankwindiya umutwe. ");
INSERT INTO nnq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kuboka penia ngabatumbu kunnamukia, “Nname muno Mangwana ba Akayahudi!” ");
INSERT INTO nnq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Benia ngabamputa nnai umutwe, ngubunhuni mata, ngaba kilikitila nu kunnitila kunhwenyo. ");
INSERT INTO nnq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kuboka pu kummeke nhwenyo ngubunhwula ngobo ji Kingwana nu kunkwindiya ngobo yakwe kabele. Ngabampeleka kummamba. ");
INSERT INTO nnq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Undela, ngabankole mundu jumwe ojwakemigwa Simoni, ojwaika kunnyini kuboka kung'onda. Manjolinjoli ngaga nhwamulicha aupotole nchalaba gwa Yesu. Simoni akiba jwa kilambo cha Kulene akiba awawa ba Alekizanda na Lufusi. ");
INSERT INTO nnq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Benia ngabantola Yesu ngabampeleka mpaka paali papakemigwa Goligota, mana gakwe, paali pi “Kitongo cha Mutwe.” ");
INSERT INTO nnq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Benia ngabajiganga kumpe divai ejibatindagine na manemane, nambu jwombe ngakana kunywe jenie. ");
INSERT INTO nnq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kuboka penia ngabammambanga nu kubagana ngobo yakwe bene akangweto kukuoma kiumbuumbu bamanye kila mundu chapakupata! ");
INSERT INTO nnq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikiba kindabi nunhwana apabammambanga Yesu panchalaba. ");
INSERT INTO nnq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Litangacho lya lukumbi lwa jwenio liandikigwe yene, “Nngwana jwa Akayahudi.” ");
INSERT INTO nnq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pamwe na jwenio bakabambigwa na akapoki abena jumwe kingonu cha kalelo na jonge kingono cha kangeja. ");
INSERT INTO nnq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Penia ngagalenganila Majandiko Gachwapi agalenga, “Ngaba mmeka pamwe na akabaja.” ");
INSERT INTO nnq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bandu abapetanga paali penia ngabammona Yesu ngabantukana kulenga, “Aha! Nnyenda makabomola Nyumba ja Nnoongo nu kuchenga kwa machoba matatu! ");
INSERT INTO nnq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ngoe nhwuluke panchalaba mikikombole mmene!” ");
INSERT INTO nnq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Akakung'i akolongwa pamwe na Akaboli ba Malagilo ga Musa apabammona Yesu ngabalenga, “Ngabakombo bange, nambu aotwije kukikombola mwene! ");
INSERT INTO nnq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Konda jwenio nga Kilisto Nkomboi, Nngwana jwa Isilaeli! Tummone anda aulwike panchalaba, na twe matunhwamina.” Na baba akabena ababambigwa pamwe na Yesu ba ngabantukana uyo. ");
INSERT INTO nnq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ikiba saa sita nalumu mpaka saa tisa kimuyo lubendu ngulutanda kilambo choa. ");
INSERT INTO nnq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa kimuyo Yesu ngaguta kwa lilobe likolongwa, ngalenga, “Eloi, Eloi, lama sabakitani?” Mana gakwe, “Nnoongo jwango, Nnoongo jwango, mboni uneka?” ");
INSERT INTO nnq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bandu bange abajemangita penia abannyoanga jwenio ngabalenga, “Mpenikie! Ankema Eliya.” ");
INSERT INTO nnq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jumwe kati jabe ngabutuka, ngatola litonji ngalichwika musiki, ngalitabalila munnai ngantondobeke anywe ngalenga, “Nyemitulole anda Eliya maika kunhwuluya panchalaba!” ");
INSERT INTO nnq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ngaguta kanonoya, ngajomoka. ");
INSERT INTO nnq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Panjia ja nkati ja Nyumba ja Nnoongo elibagina pa Chwapi ja Nnoongo ngijipachuka ipande ibena kuboka kunani mpaka pae. ");
INSERT INTO nnq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kilongoi jwa akalenda ba Loma akiba ajemite nnongi ja nchalaba apalola kiwe chawa Yesu, ngalenga, “Kweli mundu ojo akiba Mwana jwa Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akikege bange bakibanga penia bakalola kutaali, pamwe na benia akiba Maliamu Magidalena na Salome, na Malia amama achoko ba Yakobo na Yusufu. ");
INSERT INTO nnq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Benia bankengama Yesu apakiba ku Galilaya na kummegelela. Bange akikege ajingi abaika Kuyelusalemu uyo bakiba penia. ");
INSERT INTO nnq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ikiba kimuyo apaika Yusufu jwa Alimatayo. Jumwe jwa Libalacha lya chilikali juna Madalaka, jwenio alendela Kingwana cha Nnoongo. Likiba lichoba lya kupanganikia kujimukila Lichoba lya Kupomalela. ");
INSERT INTO nnq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yene ngaika Yusufu mundu ju kilambo cha Alimatayo, akiba jumwe kati ji kikuta kikolongwa jwapata ichima muno. Jwombe uyo alendela kuika kingwana cha Nnoongo. Penia ngannyendele Pilato pangajogopa ngajopa bampe mmele gwa Yesu ");
INSERT INTO nnq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ngaomongwa kujoa kita Yesu ajomwike. Ngankema nnenda nkolongwa ngankonya anda Yesu ajomoka tango kindae. ");
INSERT INTO nnq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato apannyoa nnenda nkolongwa kutenda Yesu ajomwike, nganyeketela Yusufu autole mmele gwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu ngaemela ngobo nhuu ja kitani ngauluya pae mmele gwa Yesu ngaubiligila chanda. Ngaubeka mulikabuli elikiba liembigwe piliganga, kubokapenia ngalipilimbia libwe likolongwa nnongi ja nniango gu likabuli. ");
INSERT INTO nnq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliamu Magidalena na Maliamu amamundu Yusufu ngabapabona pububekite mmele gwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kuboka pi Lichoba li Kupomolela kupeta, Maliamu Magidalena na Salome na Maliamu amamundu Yakobo ngabaeme mauta ga kunungila ibe bukupakaye mmele gwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lichoba lya jumapili kindabindabi, ngabajenda kulikabuli, lichoba apalitumbula kupita. ");
INSERT INTO nnq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na angweto ngababe bakalengelana, “Mene ojwapa kutubokea libwe paniango gu likabuli?” ");
INSERT INTO nnq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nambu apabalolanga, ngibilibona libwe liboigwe. Na lyakiba libwe likolongwa muno. ");
INSERT INTO nnq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Apabajingala mulikabuli, ngabammona kakombo jumwe ojwakwindite ngobo nhuu, atamite kingonu cha kalelo, ngabaomongwa muno. ");
INSERT INTO nnq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nambu kakombo jola ngabalengelanga, “Makaomwangaje,” manyi mampalanga Yesu jwa ku Nazaleti ojwabambigwe munchalaba. Ayokite, abije pamba. Nnolanga paali apabakiba banng'onakinge. ");
INSERT INTO nnq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nnyendange makalengelange akinapunji bakwe pamwe na Petulo kutenda apakunnongelelanga kwako ku Galilaya. Kwenio mamammona anda apannengelinge. ");
INSERT INTO nnq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ngababoka pilikabuli pala, bakalendema kukujogopa na mbwele. Bannengalingeje mundu kilebe chochoa, magambu batela kujogopa muno. ");
INSERT INTO nnq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu kuboka pa kuyoka kindabindabi lichoba lya Jumapili, ngatumbula kumpiti Maliamu Magidalena, Yesu ojwammoita michepela saba. ");
INSERT INTO nnq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliamu Magdalena ngajabula, ngabalengela abakiba pamwe na Yesu. Bakiba bakakokaleka nu kuguta, ");
INSERT INTO nnq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","na apabannyoa jwenio akalenga kutenda Yesu abi mmomi nu kutenda Maliamu Magdalena ammweni, baaminingije. ");
INSERT INTO nnq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kuboka penia Yesu ngabapitila akinapunji abena kongo agalambwike kumio. Akinapunji benia bakiba bakajenda kukijiji. ");
INSERT INTO nnq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Angweto uyo ngabajenda, ngabalengela akajabe, nambu angweto uyo baaminingije. ");
INSERT INTO nnq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pukujomolela, Yesu ngabapitila akinapunji bakwe komi na jumwe ogubakiba bakalya. Ngabakalapila muno angweto, magambu gwangaamini gwabe nu kutauka kwabe, gambu baaminingeje abakiba bammweni kuboka pa kuyoka. ");
INSERT INTO nnq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ngabalengela, “Nnyendange kudunia joa makatangachange Nhwalo Gwambone ku kila mundu. ");
INSERT INTO nnq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ojwaamini nu kubatichigwa apaukomboligwa, jwanga amini apakuhukumigwa. ");
INSERT INTO nnq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ni iingi yenje ipaukengamana nababa abaamini, ku liina lyango bapakuboya michepela na bapakulongela kilonge kiyono. ");
INSERT INTO nnq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Anda bakamwi lijoka andaje banywi kilebe chochoa china uchungu, chabengwaje, bapakubeka maboko gabe panani ja akatamwe, nangweto mabalama.” ");
INSERT INTO nnq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kuboka pa Nngwana Yesu kujomo kulonge nabo, ngatoligwa kujenda Kumbengu nu kummeka kingonu cha kalelo cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Akinapunji ngabajenda nu kutangacha kila paali, na Angwana ngabakamwa liengo pamwe na angweto kuchalakicha nhwalo gwenio ku iingi eyikengamana nabo.");
INSERT INTO nnq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mana Teofilo, bandu ajingi baandike ilebe andi pabaotalinge nhwalo gwa ipitile kwito. ");
INSERT INTO nnq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Andi pubutulandulila abakiba akachaili abagabweni, na akapakachi bi lilobe lyenie kutumbu lolo. ");
INSERT INTO nnq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na ialile nane ananhota magambu njomite kukuingikia ilebe yenie kuboka pitumbulaga mbemele iba chwapi kunhwandakila gwe Teofilo nhwalo gongo. ");
INSERT INTO nnq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ndenda yenie kupala mmanye kweli joa ja kila kilebe echimmoligwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kingobu Helode apakiba Nngwana jwa ku Yudea, pakiba na Nkung'i jumwe liina lyakwe Zakalia, jukikuta cha Abiya. Lina lya aanamundu bakemigwa Elizabeti jwombe uyo akiba ju lungolo lwa nkung'i Aluni. ");
INSERT INTO nnq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Boa akabena bakiba bambone nnongi Nnoongo, bakibanga kengama Malagilo ga Angwana ana Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nambu bapatangiteje ingota magambu Elizabeti akiba ntonga na boa akabele bakibanga bagoiminge muno. ");
INSERT INTO nnq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lichoba limwe Zakalia apakiba akakamula liengo lyakwe andi nkung'i mu Nyumba ja Nnoongo, ikiba jamu jakwe jukubegelela. ");
INSERT INTO nnq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Andi pikiba lukobo lwabe Zakalia ngachaguligwa kujenda mu nyumba ja Nnoongo kuukalikia ubani ejibakengama akakung'i, nnongi nkati mwa nyumba ja Nnoongo. Yenie ngajenda nnongi ja Nyumba ngolongwa ja Angwana, ");
INSERT INTO nnq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","kingobucho bandu ajingi bakiba bakonganinge panja kung'ongalela Nnoongo kingobu cha kuukalakia ubani. ");
INSERT INTO nnq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mpakachi jwa Angwana kuboka kumbengu ngampitila Zakalia umwo nnyumba ngajema kingono cha kalelo chikitembe chukuukalakia ubani. ");
INSERT INTO nnq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia apammona mpakachi jwenio ngaomongwa na ngajogopa. ");
INSERT INTO nnq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nambu mpakachi jo nganengela, “Zakalia makajogopaje Nnoongo ajowine kugongalela kwinu na Elizabeti aanabinu mabapotola mwana munalome. Mampa liina lyakwe Yohana. ");
INSERT INTO nnq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mma na laa ngolongwa, na bandu ajingi mabannulatila kwa kubelekwa kwakwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Apakube nkolongwa nnongi ja Angwana, ainyweje divai, wala chukunywe kikale matwelela Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mababuyanga bandu ajingi bu Kuisilaeli Kangwana ana Nnoongo babe. ");
INSERT INTO nnq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jwenio balongalela Angwana akalongoleigwa na makakala nu uhuke andi nnondoli Eliya jwa Nnoongo. Mababeka akawawa na ingota kupalana, mabagalambuya bandu bangajali babe na mawacho gambone, babekanga maha bandu ba Angwana kwa magambu gabe.” ");
INSERT INTO nnq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia ngannengela Mpakachi, kuboka kumbengu numanyabo nhwalo gweniogo? Nane ng'oime na akango unyaela? ");
INSERT INTO nnq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mpakachi ngajanga, “Ne na Gabulieli, nanyema nnongi ja Nnoongo, bangingite nonge namwenga nannenge Nhwalo gwa mbone gongo. ");
INSERT INTO nnq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gambu gwanga amini gwinu mma mabubu. Nhwotoje kulongela mpaka aganannengila galenganile.” ");
INSERT INTO nnq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mangobu genia, bandu bakiba bakannendanga Zakalia ngabaomongwa kukuchelwa kwakwe Unyumba ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Apapita panja aotwije kulongela na bandu ngabamanya kutenda aibweni ikobo Munyumba ja Nnoongo. Aotwije kulongela kilebe, alangila numaboko gakwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakalia apajomola jamu jakwe ja kubegalela Munyumba ja Nnoongo, ngabuja kachakwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kubokapenia Elizabeti aanaba Zakalia ngabapata ndumbo. Nambu ngibikiiya unyumba kwa myei nhwano. ");
INSERT INTO nnq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ngalenga, “Ngoe Angwana banyangite, bamoite oni jango nnongi ja bandu!” ");
INSERT INTO nnq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mwei gwa sita gwa ndumbo ja Elizabeti, Nnoongo ngankinga mpakachi Gabulieli kuboka kumbengu ajende kukilambo cha ku Nazaleti okwo Ku Galilaya, ");
INSERT INTO nnq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa kamwale jumwe, ojwalagine kutolana na mundu jumwe ojwa kemigwa Yusufu jwa lungolo lwa Daudi. Lina lya kamwale jwenio Maliamu. ");
INSERT INTO nnq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mpakachi kuboka Kumbengu ngannyendela ngannengela, “Tengela jibe pamwe namwe! Angwana babi pamwe na mwenga na bampi upeele muno!” ");
INSERT INTO nnq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliamu pajoa malobe genia ngaechuka muno, kugaacha malobe genia mana gakwe nike? ");
INSERT INTO nnq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mpakachi kuboka kumbengu ngannengela, “Makajogopaje Maliamu, Nnoongo ampi upeele. ");
INSERT INTO nnq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mampata ndumbo, mampotola mwana munalome na mampa liina lyakwe Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jwenio maba nkolongwa na akemigwa Mwana jwa Nnoongo ojwabi kunani muno. Angwana ana Nnoongo mabampa kitebu cha Nngwana Daudi aoko mundu, ");
INSERT INTO nnq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","jwenio nga nngwana ju lungolo lwa Yakobo machoba goa pangapela, kingwana chakwe kiba cha machoba goa pangapela!” ");
INSERT INTO nnq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliamu ngannengela mpakachi kuboka kumbengu, “Kilebe chenie kiba bole? Nanenga nanabeje na munulome tangu nabelekwa?” ");
INSERT INTO nnq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mpakachi kuboka kumbengu ngajanga, “Uhuke jwa Nnoongo manhwikilila, na makakala ga Nnoongo maganhwekelela kwa magambu genia Mwana ojwapa kubelekwa akemigwa Nchwapi, akemigwa Mwana jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nkombokela nnongo gwinu Elizabeti, aganu kube mbuja, akweti ndumbo gongo mwei gwa sita ojwamanyakine na bandu kube ntonga. ");
INSERT INTO nnq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwa magambu libije lyangaotola Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliamu ngalenga, “Nenga napakachi ba Angwana, ibe anda apannengite.” Na mpakachi kuboka kumbengu nganneka. ");
INSERT INTO nnq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kuboka pamachoba machoko, Maliamu ngaboka mwanja ngajenda chokwe mpaka kilambo echikibi kuitombi ya Yudea. ");
INSERT INTO nnq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kwenio ngajingi unyumba ja Zakalia ngampata abali Elizabeti. ");
INSERT INTO nnq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti apajoa abali ja Maliamu, kingota cha mulutumbo mwa Elizabeti ngikiina. Elizabeti nganhwikili Uhuke jwa Chwapi, ");
INSERT INTO nnq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ngalongela kwa lilobe likolongwa, “Nkweti kindimba kupeta akikege boa na mwana ojwapakubelekwa akoigwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kunike kilebe kikolongwa kipitilile kwango, ata amama ba Angwana bango baike kwango nenga? ");
INSERT INTO nnq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Apanyoina abali jinu, mwana mulutumbo lwango ngainaina kukuala mojo. ");
INSERT INTO nnq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mbaya mwe manhwamine kutenda kilebe chibalenga Angwana kwinu makilenganila.” ");
INSERT INTO nnq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliamu ngalenga, “Mwojo gwango gwalumba Angwana, ");
INSERT INTO nnq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","uhuke gwango ubi nalaa magambu Nnoongo Nkomboi jwango. ");
INSERT INTO nnq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Magambu bandekungombokela nammanda gwabe nachoko! Kuboka ngoe bandu boa bangema mbaya, ");
INSERT INTO nnq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwa magambu ilebe ikolongwa eyandendi Nnoongo ojwabi Nkolongwa Angwana bandendi kilebe kikolongwa. Lina lyabe bachwapi, ");
INSERT INTO nnq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","kutumbu kibelei chimwe mpaka chenge alaya kia jakwe kwa bandu abannyali, ");
INSERT INTO nnq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","batei ilebe ikolongwa kwa maboko gabe gina makakala bapechengine bandu bina uongwajagi muma wacho ga umojo jabe. ");
INSERT INTO nnq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bauluinge akangwana bina makakala muitebu yabe ngabatondobea bandu bina kunyenyepa. ");
INSERT INTO nnq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bina njala bapi ilebe ya mbone, bandu bina ela balekangite bajendange maboko jika ");
INSERT INTO nnq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Akombakile malagano gakwe agalagana na akinanhota bito, bajangatinge akapakachi bakwe Isilaeli, ");
INSERT INTO nnq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","andi pabalengela akawabito, Ulaimu ni ibelei yakwe yoa pangapela!” ");
INSERT INTO nnq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliamu ngatama na Elizabeti kwa myei mitatu kuboka penia ngabuja kachakwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kingobu cha kukikombola kwa Elizabeti ngikiika, ngapotola mwana munalome. ");
INSERT INTO nnq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Akandami ajabe na akalongamundu apabajoa kutenda Angwana bammoni kia Elizabeti, ngabaala mwojo pamwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lichoba lya nane apalyaika, ngabajenda kunhina mwana, ngabapalanga kumpe liina lya awamundu, Zakalia. ");
INSERT INTO nnq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nambu amamundu ngabalenga, “Lyeneje nambu akemigwe Yohana.” ");
INSERT INTO nnq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bandu ngabannengela Elizabeti, “Abije mundu mulungolo lwakwe juna liina andi lyenele?” ");
INSERT INTO nnq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kuboka penia bandu ngababeke kiingi awamundu bapala balenge liina lya mwana lebilipala. ");
INSERT INTO nnq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia ngajopa kibao chukuandikila na ngaandika, “Liina lyakwe Yohana.” Boa ngabaomongwa! ");
INSERT INTO nnq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Upo Zakalia ngatumbu kulongela kabele, ngannumba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngababeganga na mbwele akandami ajabe boa, nhwalo gwenio ngujoanika mwitombi yoa eibi kukilambo cha Kuyudea. ");
INSERT INTO nnq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kila mundu ojwajoine nhwalo gwenio ngawacha nu ukonya, “Mwana ojo apakubebo?” Magambu ibonekana kipola kube makakala ga Nnoongo gakiba pamwe nakwe. ");
INSERT INTO nnq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia, awamundu Yohana, ngatwele Uhuke jwa Chwapi, ngalenga nhwalo gwa Nnoongo gongo, ");
INSERT INTO nnq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Talumbe Angwana ana Nnoongo bu Kuisilaeli, baike kajangata bandu bakwe na kakombola. ");
INSERT INTO nnq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Butupile nkomboi juna makakala, ju lungolo lwa Daudi mpakachi jwabe. ");
INSERT INTO nnq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Andi palenga kutumbu lolo, kupete kwa akalondoli bakwe ba chwapi. ");
INSERT INTO nnq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kutenda mabutukombola kwa akangondwa bito, nu mumaboko ga boa ababutuchimwa. ");
INSERT INTO nnq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ngabalenga mabakolela kia akananhota bito, nu kombokela lilagano lyabe lya chwapi. ");
INSERT INTO nnq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nnoongo ngampe lilagano nhwoko gwito Ulaimu, ");
INSERT INTO nnq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ngalagila kutukombola kuboka kwa akangondo bito bakabe na mbweleje tabegelele panga mbwele, ");
INSERT INTO nnq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tube tambone andi papala Nnoongo machoba goa gukulama kwito. ");
INSERT INTO nnq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mwe mamanango, mankemigwa, nnondoli jwa Nnoongo ojwabi Nkolongwa muno. Mwenga mamalongalela Angwana, kutendekea ndela jabe, ");
INSERT INTO nnq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ngabalengela bandu bakwe kutenda mabakomboligwa na kalekekeya mabaja gabe. ");
INSERT INTO nnq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nnoongo jwito jwambone na juna kia. Ma auluya lumuli lu komboi nu kutumulikila, ");
INSERT INTO nnq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kamulikilanga kuboke kumbengu boa abatamanga mukiwili cha kiu, atulendele undela tujenda kwa tengela.” ");
INSERT INTO nnq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana ngakola, nukujendekea kummele nu uhuke. Ngatama papongoti mpaka pakilaya kipola ku bandu bu Kuisilaeli. ");
INSERT INTO nnq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Machoba genia Nngwana Agosto ngabeka amuli ngapala bandu boa ba Loma babalangigwe. ");
INSERT INTO nnq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kubalangigwa kwenio kiba kukutumbula, kingobu Kulenio akiba Nkolongwa jwa Nkoa gwa Silia. ");
INSERT INTO nnq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Boa ngabajenda kukiandikicha kila mundu kukilambo chakwe. ");
INSERT INTO nnq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu ngaboka kilambo cha Nazaleti ku Nkoa gwa Galilaya ngajenda kukilambo cha Beteleemu ku Nkoa gwa Yudea kwa belekwa Nngwana Daudi. Yusufu ajenda kwenio magambu akiba ju lungolo lwa Daudi. ");
INSERT INTO nnq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ngajenda kukiandikicha pamwe na Maliamu ojwakalagana kutolana nakwe. Kongo abi na ndumbo, ");
INSERT INTO nnq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Apabakibanga Kubeteleemu, Maliamu lichoba lyakwe lyu kupotola ngiliika, ");
INSERT INTO nnq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ngapoto mwana jwakwe ju litibo munulome, ngankwindia ngobo ngang'oneka mulijola elitendekiigwe kulele ng'ombe, magambu bapatangiteje nyumba jukuiki akageni. ");
INSERT INTO nnq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Penia pakiba akachungi, batendanga kupokelana kilo kulende ilangwa yabe papipi na Betania. ");
INSERT INTO nnq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Akapakachi kuboka kumbengu ngabapitila, na kibumo cha Angwana ngichamulakila tii nde. Ngabajobokanga muno. ");
INSERT INTO nnq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nambu Akapakachi kuboka kumbengu ngabalenga, “Makajogopangaje! Inkila kunetelanga nhwalo gwa mbone gukuala mojo muno kwa bandu boa. ");
INSERT INTO nnq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kwa magambu lele kukilambo cha Daudi abelwike Nkomboi jwinu Kilisto Nngwana ojwalagila Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nachenje kiba kiingi chinu mukikolela kilemba bikikwindiye ngobo pi lijola lya kulele ilangwa.” ");
INSERT INTO nnq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kingobu tu kikuta kikolongwa cha matyala kuboka kumbengu ngababe pamwe na Mpakachi kuboka kumbengu, ngabajembanga nu kunnumba Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","kulenga, “Kibumo ku Nnoongo kunani muno kumbengu, na tengela padunia kwa bandu ababapaile muno.” ");
INSERT INTO nnq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kuboka tu akapakachi kujabu kumbengu, akachungi ngabalengelana, “Tujendange mpaka ku Beteleemu takalole lyenie libutulengile Angwana.” ");
INSERT INTO nnq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yenie ngababutuka mbelo, ngabankole Maliamu na Yusufu ngabammona mwana bang'onike pilijola lya kulele ilangwa. ");
INSERT INTO nnq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Akachungi apabammona mwana, ngabalengela nhwalo gwa mwana ogubujoininge kwa akapakachi. ");
INSERT INTO nnq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Boa abajoininge genia ngabaomongwa na gaga agabalenga akachungi. ");
INSERT INTO nnq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maliamu ngagakombakela na kugawachila muno genia goa mumojo gwakwe. ");
INSERT INTO nnq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Akachungi ngababujanga kongo bakajemba nukunnumba Nnoongo kwa goa gabajoininge na kagabona ngibe tela anda apabakajoanga akapakachi ba kumbengu. ");
INSERT INTO nnq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kuboka pa machoba nane kingobu chukunhwina mwana ngikiika, ngabampe liina Yesu. Liina elyapanga mpakachi kuboka kumbengu tango na ndumboje. ");
INSERT INTO nnq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Machoba apagaika ga mpapala gwa kujeguka Yusufu na Maliamu andi apipaligwe Mumalagilo ga Musa. Yene gabantolanga mwana mpaka Kuyelusalemu kummeka kwa Angwana. ");
INSERT INTO nnq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mumalagilo ga Angwana iandikigwe, “Kila ojwapakubelekwa ju litibo anda abi munulome apangigwa abe Chwapi ka Angwana.” ");
INSERT INTO nnq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Angweto uyo ngabajendanga kumpanga Lilumbo, ngunda ibena andaje mabunda mabena, andi apipaligwe mu Malagilo ga Angwana. ");
INSERT INTO nnq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mangobu genia kukiba na mundu jumwe akemigwa Simioni ojwatama Kuyelusalemu, juna mojo gwa mbone akakamula agapala Nnoongo junakunnyali Nnoongo, ojwakiba akalendela ukomboi gwa Isilaeli. Uhuke jwa Chwapi akiba pamwe nakwe. ");
INSERT INTO nnq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Alengiligwe nu Uhuke jwa Chwapi kube ajomokaje panga mmona Kilisto jwa Angwana. ");
INSERT INTO nnq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Alongaliligwa ni Uhuke jwa Nnoongo, Simoni ngajenda Kunyumba ja Nnoongo na achikibelei ba Yesu ngabanneta mwana kulubanja lwa Nyumba ja Nnoongo andi apipaligwe na Malagilo ga Musa, ");
INSERT INTO nnq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni ngampokela mwana mukuboko jakwe kongo akannumba Nnoongo, kulenga ");
INSERT INTO nnq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ngoe, Angwana, galenganile malagano ginu, nhwotwile kunneka mpakachi jwinu ajende kwa tengela. ");
INSERT INTO nnq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa mio gango nubweni ukomboi oguboka kwinu, ");
INSERT INTO nnq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Gwenio mupanganila bandu boa bubone, ");
INSERT INTO nnq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lumuli ngulwamulikila bandu ba ilambo yenge, nukuleta kibumo kwa bandu binu Kuisilaeli,” ");
INSERT INTO nnq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Awamundu na amamundu Yesu batela kuomongwa ilebe eyalongi Simioni. ");
INSERT INTO nnq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni ngabalumika nu kunnenge Maliamu, amamundu Yesu, “Mwana jonjono apambuligwe na Nnoongo kuoba nukombola bandu ba Kuisilaeli. Jwombe maba kiingi kuboka kwa Nnoongo echikibakatenda bandu ajingi bankana, ");
INSERT INTO nnq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","yene mawacho gabe agagikiite magabekigwa kipola. Kuechuka kupakueketa myojo jabe andi lipanga linakatema.” ");
INSERT INTO nnq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pakiba na nnondoli jumwe munkege mbuja nawele liina lyakwe Ana, biti Fanueli jwa kabi ja Asheli. Ngatama na angwanamundu kwa yaka saba tu kuboka apabatolana. ");
INSERT INTO nnq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Paba mbuja jwa yaka makomi nane na ncheche. Abokiteje pa Nyumba ja Nnoongo, atela kupunga na kugongalela kilo na mui. ");
INSERT INTO nnq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kingobu chenie, ngaika nnongi ngannumba Nnoongo, ngalenga nhwalo gwa mwana kwa bandu boa abakibanga bakalendela ukomboi gwa Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kingobu Yusufu na Maliamu pabajomola kamula genia goa agaamuligwe na Malagilo ga Angwana ngababujanga kachabe Kunazaleti ku Nkoa gwa Galilaya. ");
INSERT INTO nnq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana ngakola, ngabe na makakala, ngabe na malango muno na upeele gwa Nnoongo ngube pamwe nakwe. ");
INSERT INTO nnq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila chaka Achikibelei ba Yesu bakibanga na lukobo lwa kujenda Kuyelusalemu ku Mpapala gwa Pasaka. ");
INSERT INTO nnq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kingobu Yesu apakiba na yaka komi na ibena, ngabajenda boa Kumpapala gwenio anda pulukiba lukobo lwabe. ");
INSERT INTO nnq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Apaupeta Mpapala ngabatumbu mwanja gwa kubuja kachabe, nambu Yesu ngaigala ukwo, Kuyelusalemu panga manya achikibelei bakwe. ");
INSERT INTO nnq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bakitanga abi pamwe nabo mumwanja, ngabajenda lichoba tipi, kiboka chapenia ngabatumbu kumpala pala makalongo na mwaka maganjamundu. ");
INSERT INTO nnq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kwa magambu bammonangiteje, ngababujanga Kuyelusalemu kumpala. ");
INSERT INTO nnq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lichoba lya tatu, ngabankole Kunyumba ja Nnoongo akiba atamite panakati ja akaboli ba Akayahudi, akapenakia na kakonya ilebe. ");
INSERT INTO nnq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Boa abajoininge malobe gakwe ngabaomongwa malango gakwe gambone. ");
INSERT INTO nnq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Achikibelei bakwe apabammona ngabaomongwa. Amamundu, ngabankonya, “Manango, mboni mututei nyeniela? Awabinu na nenga tutelakumpala pala kwa mbwele.” ");
INSERT INTO nnq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ngabajanga, “Mboni mangwetomwe umbala pala? Mmanyangitije, mbaligwa kube Kunyumba ja awabango?” ");
INSERT INTO nnq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nambu bamanyangitije kipola lijango lyenie. ");
INSERT INTO nnq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu ngabuja pamwe nabo Kunazaleti, kwenio ngabajali. Amamundu ngabagabeka mumwojo genia goa. ");
INSERT INTO nnq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu ngajendekea kola nu kube na mojo gwambone nu kujendekea kupaligwa na Nnoongo na bandu. ");
INSERT INTO nnq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ikiba chaka cha komi na nhwano cha utawala gwa Nngwana Tibelio, Pontio Pilato akiba ntawala jwa kilambo cha Yudea, Helode akiba ntawala jwa kilambo cha Galilaya, Filipo nnung'una jwakwe akiba nkolongwa jwa mikoa ja Itulea na Tilakoniti. Lusiana akiba nkolongwa jwa Abilene, ");
INSERT INTO nnq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa bakibanga akakung'i akolongwa. Kingobu chenie lilobe lya Nnoongo apalyanhwikila Yohana, mwana jwa Zakalia kwenio kupongoti. ");
INSERT INTO nnq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yene Yohana ngajenda paali poa pulupakine lukemba Yolidani, ngabatangachi, kulenga, “Nnapange mabaja ginu nu kubatichigwa, Nnoongo mannekekea mabaja ginu.” ");
INSERT INTO nnq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Andi apiandikwe mukitabu cha Isaya ojwakiba nnondoli jwa Nnoongo “Mundu achobe papongoti ‘Mapanganakie Angwana ndela jabe, mmeke kipola mubapakupeta. ");
INSERT INTO nnq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila mabomba nhwelekeange, kila kitombi ni litombi ipakubomoligwa. Apapendite mapagololange ndela ejipendite mmeke kipola. ");
INSERT INTO nnq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na bandu boa mabubona ukomboi gwa Nnoongo!’ ” ");
INSERT INTO nnq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bandu ajingi ngabaikanga kwa Yohana kupala babatichigwe. Yohana ngabalengela, “Mangweto machamajoka! Beneke abannengi nhwotwi kujepa lilaka lya Nnoongo eliika? ");
INSERT INTO nnq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ntendange agalaya kutenda nnapangite mabaja. Makaachangaje kulenga nhwotwile kujepa lilaka kukuneme, Awabito ana Ulaimu, nannenge Nnoongo aotwi kagatenda mabwe aga gabe ingota yu Ulaimu. ");
INSERT INTO nnq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Libago libekigwe pamanhina ga mikongo, kila nkongo gwangapambika ubakupenguligwa nu kuleke pamwoto.” ");
INSERT INTO nnq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bandu ngabankonya, “Lele tutenda bole?” ");
INSERT INTO nnq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ngajanga, “Kila mundu ojwabi na ngobo ibele bammagulile jwangakola na ababi na ilyo balye pamwe.” ");
INSERT INTO nnq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na akatocha kodi ngabaikanga kupala babatichigwe, ngabankonyanga, “Aboli, twenga tutenda bole?” ");
INSERT INTO nnq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ngabalengela, makatochaje kodi nduu kupeta apipaligwa. ");
INSERT INTO nnq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Manjolinjoli gange ngagankonya, “Twenga tutenda bole?” Benia ngabajanga, “Makatolangaje ilebe ya mundu jwajoa kwa makakala na kuntakiana jwajoa kwa kunkopekea. Nnyeketelange na nchala gwinu.” ");
INSERT INTO nnq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bandu ngabatumbu kuhyobalela, ngabatumbu kuwacha na kukikonya iwechikine Yohana kube Kilisto Nkomboi ojwapambuligwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Penia Yohana ngabalengela boa, “Nenga nammatichanga kwa mache, nambu ojwapakuika nkolongwa muno kumbeta nenga. Mbaligweje ukulugula ngoji ya ilatu yakwe. Jwenio mammaticha kwa Uhuke jwa Chwapi na kwa mwoto. ");
INSERT INTO nnq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jwenio akamwi kipalwe chakwe chukupete mapemba, aikongola mapemba nukubeka mukikokwe, nambu mapoi aitinia mwoto gwangaimika.” ");
INSERT INTO nnq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kundela nduu Yohana ngatangacha Nhwalo Gwambone kwa bandu nakapala bileke ndela yabe. ");
INSERT INTO nnq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nambu Yohana ngankalapila Helode, nkolongwa jwa Nkoa, magambu akantola Helodia nhwana gwa nnuna gwakwe na akatenda ilebe ndu ibaja. ");
INSERT INTO nnq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kuboka penia Helode ngakamwa kibaja muno kummeka Yohana mukipungo. ");
INSERT INTO nnq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kuboka pa bandu boa kubatichigwa na Yesu uyo ngabatichigwa. Na apagongalela ku Nnoongo mbengu ngiekuka, ");
INSERT INTO nnq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Uhuke jwa Chwapi nganhwulukila akiba andi njeba. Na lilobe ngilijoanika kuboka kumbengu, kulenga, “Mwenga Mamanango manampala. Undekuhalalila.” ");
INSERT INTO nnq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu apatumbula liengo lyakwe pukubonekana akiba na malenga andi yaka makomi matatu. Akiba mwana munalome bandu bakita Yusufu, ojwakiba mwana munalome jwa Heli. ");
INSERT INTO nnq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli akiba mwana jwa Masati, Masati akiba mwana jwa Lawi, Lawi akiba mwana jwa Meliki, Meliki akiba mwana jwa Yanai, Yanai akiba mwana jwa Yusufu, ");
INSERT INTO nnq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu akiba mwana jwa Masilia, Masilia akiba mwana jwa Amosi, Amosi akiba mwana jwa Nahumu, Nahumu akiba mwana jwa Helisi, Helisi akiba mwana jwa Nagai, ");
INSERT INTO nnq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai akiba mwana jwa Maasi, Maasi akiba mwana jwa Matasia, Matasia akiba mwana jwa Shemeni, Shemeni akiba mwana jwa Yoseki, Yoseki akiba mwana jwa Yuda, ");
INSERT INTO nnq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda akiba mwana jwa Yoanani, mwana jwa Lesa, mwana jwa Zelubabeli, mwana jwa Shetieli, mwana jwa Neli, ");
INSERT INTO nnq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana jwa Meliki, mwana jwa Adi, mwana jwa Kosamu, mwana jwa Elimadamu, mwana jwa Heli, ");
INSERT INTO nnq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana jwa Yoshua, mwana jwa Eliezeli, mwana jwa Yolimu, mwana jwa Matati, mwana jwa Lawi, ");
INSERT INTO nnq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwana jwa Simioni, mwana jwa Yuda, mwana jwa Yusufu, mwana jwa Yonamu, mwana jwa Eliakimu, ");
INSERT INTO nnq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana jwa Melea, mwana jwa Mena, mwana jwa Matasa, mwana jwa Nasani, mwana jwa Daudi, ");
INSERT INTO nnq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana jwa Yese, mwana jwa Obedi, mwana jwa Boazi, mwana jwa Salimoni, mwana jwa Nashoni, ");
INSERT INTO nnq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwana jwa Aminadabu, mwana jwa Adimini, mwana jwa Alini, mwana jwa Esiloni, mwana jwa Pelisi, mwana jwa Yuda, ");
INSERT INTO nnq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana jwa Yakobo, mwana jwa Isaka, mwana jwa Ulaimu, mwana jwa Tela, mwana jwa Naholi, ");
INSERT INTO nnq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana jwa Selugi, mwana Leu mwana jwa Pelegi, mwana jwa Ebeli, mwana jwa Sala, ");
INSERT INTO nnq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwana jwa Kenani, mwana jwa Alufaksadi, mwana jwa Shemu, mwana jwa Nuhu, mwana jwa Lameki, ");
INSERT INTO nnq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana jwa Masusela, mwana jwa Henoki, mwana jwa Yaledi, mwana jwa Mahalaleeli, mwana jwa Kenani, ");
INSERT INTO nnq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana jwa Enoshi, mwana jwa Seti, mwana jwa Adamu, mwana jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu ngaboka mulukemba lwa Yolidani kongo atweli Uhuke jwa Chwapi, ngalongaligwa nu Uhuke jwenio kujenda kupongoti. ");
INSERT INTO nnq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwenio ngalondoligwa na Mmaja kwa machoba alubaini. Mangobu genia goa alije kilebe na yenie kiika kono ngajijoa njala. ");
INSERT INTO nnq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mmaja ngannengela, “Anda mwenga Mamwana ba Nnoongo, miliamuliche liganga ele libe nkate.” ");
INSERT INTO nnq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nambu Yesu ngajanga, “Iandikigwe Mumajandiko Gachwapi, ‘Mundu alama kukulye nkate tuje.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kingobucho Mmaja ngantola Yesu mpaka kunani, ngannaya ingwana yoa ya padunia kukingobu chimwe. ");
INSERT INTO nnq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mmaja ngannenge, “Manampa kinala chi ingwana yoa ni ilebe yakwe yambone. Mbatite yoa yeno na anda mbai kumpe mundu jwajoa nhotwile ngweti kinala chu kumpe mundu jwajwoa ojunampambwile. ");
INSERT INTO nnq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yene yoa maiba inu mwe, anda unng'ongalile.” ");
INSERT INTO nnq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu ngajanga, “Iandikigwe Mumajandiko Gachwapi, ‘Magongalela Angwana ana Nnoongo binu na mabegalela benia jika jabe.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kiboka chapenia Mmaja ngantola Yesu mpaka kukilambo chu Kuyelusalemu, nukummeka kunani pulingo gwa Nyumba ja Nnoongo, ngannengela, “Anda mwe Mamwana ba Nnoongo mikileke pae kuboka pamba. ");
INSERT INTO nnq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gambu Majandiko Gachwapi galenga, ‘Nnoongo maamulicha akapakachi bakwe bannendele.’ ");
INSERT INTO nnq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na kabe, ‘Mabantolanga mumaboko gabe, mikikipotekaje makongono ginu pamaganga.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nambu Yesu ngajanga, “Iandikigwe, makategaje ‘Angwana ana Nnoongo binu.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mmaja apajomola kuntegela kila ndela nganneka oti mpaka kingobu echikipaligwa. ");
INSERT INTO nnq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kiboka chapenia Yesu ngabuja ku Galilaya, kiba na makakala ga Uhuke jwa Chwapi. Minhalo jakwe ngijijoanika ilambo yoa. ");
INSERT INTO nnq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jwombe akiba akabola bandu. Mumajumba gabe ga kugongalela, kila mundu ngannumba. ");
INSERT INTO nnq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bai Yesu ngajenda Kunazaleti, paali okwakolela, Lichoba lya Kupomolela ngajenda kunnyopa Nnoongo, ngajingi unyumba ja kugongalela andi lukobo. Ngajema kuchoma Majandiko Gachwapi. ");
INSERT INTO nnq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ngapoke kitabu cha nnondoli Isaya, ngakiatambula nu kupata paali apapaandikwe nyenie, ");
INSERT INTO nnq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Uhuke jwa Angwana abi pamwe nanenga, gambu atekumbambula nannetelange akawocho Nhwalo Gwambone. Andekumbambula kutangacha nhwalo gwa mbone gwa kabeka bandu agabwa, bangalolanga mabapata kulola kabele, andekunduma kabeka agabwa ababoneligwa, ");
INSERT INTO nnq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na ndangache kingobu kitenda kuika Angwana ana Nnoongo mabakombolanga bandu bakwe.” ");
INSERT INTO nnq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu ngaekelela kitabu, ngampe mpakachi, na ngatama. Bandu boa unyumba ja kunng'ongalela Nnoongo ngabannoleke muno. ");
INSERT INTO nnq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesu ngabalenge, “Paali pamba pa majandiko gachwapi gapitile leleno andi apannyoine nakachoma.” ");
INSERT INTO nnq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bandu boa ngabanchalakicha boa na ngabaomongwa malobe gambone agalongile. Ngabalenga, “Bo, ojo nga mwana jwa Yusufu je?” ");
INSERT INTO nnq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu ngabalenge, “Manyi kutenda mankombokela kulandanakia kongo, ‘Aganga mikilami mmene, na uyo kiboka chapenia maunengela nkamwa upamba pakaja ikobo uyaye einnaya pakachito. Uyo maunengela ukamula ilebe uyaye einnyoine ikamuligwe ku Kafalanaumu.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu ngabalengelanga nyene, “Nnondoli kupataje ichima kukilambo chakwe. ");
INSERT INTO nnq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nambu mpenakiange, kweli pakiba na akaweligwa ajingi kukilambo cha Isilaeli mangobu ga Eliya. Mangobu mbengu pijitabigwa ula ngijikotoka koma kwa yaka itatu na nusu, ngapabe na njala ngolongwa muno kukilambo choa. ");
INSERT INTO nnq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ata nyeniela, Eliya atumigweje kwa mundu jwajoa kwenio Kuisilaeli nambu kwa nhweligwa jumwe tu ojwatama Zalefati kwenio ku kilambo cha Sidoni. ");
INSERT INTO nnq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kabe pikilambo cha Kuisilaeli pakiba na bandu ajingi abakiba bakatama kingobu cha nnondoli jwa Nnoongo Elisha pakiba na bina maloi ajingi. Ata nyeniela akibaje jwajotijola ojwajegwike nambu Naamani tu, mundu jwa kilambo cha Silia.” ");
INSERT INTO nnq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Boa abakibanga ku nyumba ja kugongalela apabajoanga genia ngabachimwanga muno. ");
INSERT INTO nnq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngabajemanga, ngabanhuti panja pa kilambo chabe ngabampeleka kikitombi chibachengita kilambo chabe. Bapala bannekelange pae, ");
INSERT INTO nnq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nambu Yesu ngapeta panakati ja bandu, ngajabula. ");
INSERT INTO nnq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kiboka chapenia Yesu ngajenda ku Kafalanaumu kilambo cha Galilaya, ngababolanga bandu Lichoba lya Kupomolela. ");
INSERT INTO nnq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Boa ngabaomongwa muno kwa maboulo gakwe kwa magambu alongela kukinala. ");
INSERT INTO nnq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na unyumba ja kugongalela mwakiba na mundu juna nchepela ngachobela muno, ");
INSERT INTO nnq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Mwe! Yesu ju Kunazaleti! Mboni mutujingilila? Bo, nhwikila kutujomola? Nammanyi mwe mabeneke, mwe Machwapi ba Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu ngaukalapila nchepela gwenio, “Nkotoke! Mammoke mundu jwenio!” Nchepela nchapu gwenio ngugunng'wia mundu jwenio pae nnongi jabe, ngugummoka panga ntenda kilebe. ");
INSERT INTO nnq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bandu boa ngabaomongwa, ngabalengelana, “Nga malobe ni ganga, gambu kukinala na makakala ajiamulicha michepela jiboke, na jenie kuboka!” ");
INSERT INTO nnq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Minhalo ja Yesu ngijijoanika paali poa ku nkoa gwenio. ");
INSERT INTO nnq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu ngaboka ku nyumba ja kugongolela, ngajenda kachakwe Simoni. Akimundu akege Simoni bakiba atamwe muno, ngabannengela Yesu annamie. ");
INSERT INTO nnq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu ngaika ngajema papipi na atamwe benia, ngakiamulicha kitamwe kimmoke. Kitamwe ngachaboka amama bala kingobucho ngabajinuka, ngabatumbu kabegelelanga. ");
INSERT INTO nnq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lichoba apalyatipikaga, boa abakibanga na itamwe ijingi ngabaletanga kwa Yesu, jwombe ngabeka maboko gakwe panani ja kila mundu ngabalamianga boa. ");
INSERT INTO nnq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Michepela ngijaboka bandu ajingi, ngabachobela, ngabalenga, “Mwe nga Mamwana ba Nnoongo!” Yesu ngabakalapilanga, bajeketelingije kulongela, magambu bamanyangite kube jwenio, nga Kilisto Nkomboi. ");
INSERT INTO nnq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kindabi jakwe Yesu ngaboka na ngajenda pajika jakwe. Bandu ngabatumbu kumpala pala, apabammonanga, ngabapala kunhwibalikia akajabwaje kachakwe. ");
INSERT INTO nnq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nambu jwenio ngabannengela, “Mpaka ndangache oti Minhalo ja Mbone ja Kingwana cha Nnoongo kuilambo yenge, gambu Nnoongo andumita kwa genia.” ");
INSERT INTO nnq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ku yenie ngatangacha mumajumba gu kugongalela kila paali kuilambo yoa ya Yudea. ");
INSERT INTO nnq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lichoba limwe Yesu akiba ajemite umbwega ja lilaba likolongwa lya Genesaleti, na bandu ajingi bakibanga bantindilinge batamangine, kupenikiyanga lilobe lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ngajibona mitumbwi mibele bakautila umbwega ja lilaba likolongwa. Akakoki benia bakibanga baulukinge, bakajoyanga mapelele gabe. ");
INSERT INTO nnq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu ngajingi muntumbwi gumwe ogukiba gwa Simoni, ngannyopa Simoni auegekeye mumache, kutaali kachoko na umbwega ja lilaba likolongwa. Ngatama, ngabola bandu ajingi kongo abi muntumbwi. ");
INSERT INTO nnq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Apajomolaga kubola ngannenge Simoni, “Unhendeche ntumbwi mpaka pa mache majingi, mwenga pamwe na akaganja binu makalekele mapelele ginu mpatange yamaki.” ");
INSERT INTO nnq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni ngalenga, “Ananhota, tukachine ukoka yamaki kilo ndaa panga kupata kilebe. Nambu magambu nnengite, manekela mapelele.” ");
INSERT INTO nnq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kuboka pa kutenda nyeniela ngabapatanga yamaki ndu, ata mapelele gabe ngagatumbu kueketeka. ");
INSERT INTO nnq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ngabakemanga akajabe abakibanga muntumbwi gonge, baike bajangate. Ngabaikanga ngabatwelea yamaki mitumbwi joa mibele mpaka yakiba papipi kumilwa. ");
INSERT INTO nnq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulo apalola genia, ngakilikitila nnongi ja Yesu ngalenga, “Mmoke nnongi jango Angwana! Ne namundu bina mabaja!” ");
INSERT INTO nnq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni pamwe na akajakwe boa ngabaomongwa kwa kupata yamaki ndu nyenie. ");
INSERT INTO nnq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pamwe na genia Yakobo na Yohana ingota ya Zebedayo bakibanga akakoki ajakwe Simoni. Yesu ngannenge Simoni, “Makajogopaje kuboke ngoe mamma makoki ba bandu.” ");
INSERT INTO nnq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kuboka pa kuuta mitumbwi jenia umbwega jililaba likolongwa, ngabailekanga yoa ngabankengama Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu apakiba ku kilambo chimwe cha kwenio, mundu jumwe juna maloi. Apammona Yesu ngagwe manguku ngannyopa Yesu, “Angwana, anda mpaile, unamie.” Kitamwe chenje chammeka mundu abonekane kube jwanga jeguka. ");
INSERT INTO nnq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ngatondabeya luboko lwakwe, ngankunyula nu kulenga, “Mbala nnyeguke!” Kingobucho ngajeguka. ");
INSERT INTO nnq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu nganhwamulicha, “Makannengeje mundu jwajoa, nambu nnyende makakilae kwa akung'i, makapange lilumbo kwa magambu gu kujeguka kwinu andi apaamuliche Musa kukuchalakicha nnamite.” ");
INSERT INTO nnq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nambu minhalo ja Yesu ngijijoanika kila paali, na bandu ajingi ngabakongana kupala bampenakie na kulamiigwa itamwe yabe. ");
INSERT INTO nnq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nambu Yesu ngajabula paali panga bandu ngagongalela kwenio. ");
INSERT INTO nnq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lichoba limwe Yesu akiba akabola, Mafalisayo bange na akaboli ba Malagilo ga Musa kuboka kuijiji yoa ya Ku Galilaya na Yudea na Kuyelusalemu bakibanga batamangite penia. Makakala ga Angwana gakiba pamwe na Yesu kwa magambu ga kalamia akatamwe. ");
INSERT INTO nnq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bandu bange ngabaikanga, bampotwi mundu ojwapolite mmele, banng'onike pikindanda, ngabajiganga kummeka unyumba nnongi ja Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nambu kwa magambu ga bandu ajingi baotolingije kujingi unyumba. Penia ngabaobakela pikinyanga nu kumopo paali, ngabanhuluya mukindanda, ngabammeka nnongi ja Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu apababona babi na imani ngolongwa, ngannengela mundu jweno, “Aganja, mabaja ginu galekekeigwe.” ");
INSERT INTO nnq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Akaboli ba Malagilo ga Musa na Mafalisayo ngabatumbu kukikonyanga, “Mundu ojo mene ojwalonge malobe gu matukano! Nnoongo jika jakwe ojwaotwi kulekekea mabaja!” ");
INSERT INTO nnq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu agamaanyi mawacho gabe, ngabakonyanga, “Kwa nike nhwachanga genia mumyojo jinu? ");
INSERT INTO nnq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lyako elilibi kindema muno kulenga ‘Nnekekiigwe mabaja ginu, andaje kulenga, nnyeme nnyende?’ ");
INSERT INTO nnq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mbala mmanyange kutenda Mwana jwa Mundu akweti kinala cha kalekekeya bandu mabaja gabe padunia.” Penia ngannengela mundu jwenio ojwapolite mmele, “Nnamiigwe, ntole kindanda chinu, nnyabu kachinu.” ");
INSERT INTO nnq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kingobucho mundu jwenio ojwapolite mmele ngajema nnongi jabe boa, ngatola kindanda echakagolokela ngajabu kachakwe kongo kupeta kunnumba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boa ngabaomongwa muno nu kubeganga na mbwele, Ngabannumba Nnoongo nabalenganga, “Lele tibweni ikobo!” ");
INSERT INTO nnq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kiboka penia Yesu ngapita panja, ngammona ntocha kodi jumwe liina lyakwe Lawi, atamite panyumba ju kutocha kodi. Yesu ngannengela, “Ungengame!” ");
INSERT INTO nnq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi ngajema ngaileka ilebe yoa ngankengama Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Penia Lawi ngammeke Yesu mpapala nkolongwa kachakwe. Kati ja akageni pakiba nkengeni nkolongwa gwa akatocha kodi na bandu bange. ");
INSERT INTO nnq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayo bange na akaboli bange ba Malagilo abakiba mu kikuta chabe ngabakokalekea akinapunji ba Yesu. Ngabakonya, “Mboni nnieganga na kunywe pamwe akatocha kodi na bina malemwa?” ");
INSERT INTO nnq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu ngabajanga, “Bandu banga kitamwe kumpalaje nng'anga, nambu abampala bina itamwe. ");
INSERT INTO nnq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Inkila kakema bandu bamboneje balape malemwa, nambu bina malemwa balapange malemwa.” ");
INSERT INTO nnq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bandu bange ngabannenge Yesu, “Akinapunji ba Yohana Mmatichi kupunga kila kingobu nu kugongalela, ata akinapunji ba Mafalisayo batendanga uyo, nambu akinapunji binu kulye nu kunywe.” ");
INSERT INTO nnq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ngajanga, “Bo nkita abakokigwe kumpapala gukutola akege bapaligwa kupunga kingobu akoano babi pamwe na angweto? Kubeje! ");
INSERT INTO nnq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nambu kingobu kipakuika akoano apabapakuboigwa kati jabe penia nga apabapakupunga.” ");
INSERT INTO nnq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu ngabalengela kabe kulandanakia kongo, “Abije mundu kubeka kibamba kiyono mungobo ng'ona. Anda atei nyeniela, mmanya kipakupachula ngobu jenie, kibamba cha ngobo nhyono kilandanaje na ngobo ng'ona. ");
INSERT INTO nnq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Abije mundu ojwajela divai nhyono mukitumba kigona, andatei nyenie divai nhyono jibakupachu kitumba chenie, divai jibakujitika, ni kitumba kipakupachuka. ");
INSERT INTO nnq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nambu ipaligwa divai nhyono kujela munhuku nnyono. ");
INSERT INTO nnq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Abije mundu ojwapala kunywe divai nhyono kuboka pa kunywe ng'ona. Nambu alenga, ‘Ng'ona jela nga chwapi muno.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu akiba akapeta mumigonda ja ngano Lichoba li Kupomolela. Akinapunji bakwe ngabatumbu kupanyila miejo ja ngano, ngabakonyanga kwa maboko, nu kulyeganga. ");
INSERT INTO nnq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Gange Mafalisayo ngagakonya, “Mboni ntendanga ilebe yangapaligwa Mumalagilo Lichoba li Kupomolela?” ");
INSERT INTO nnq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu ngabajanga, “Bo, nchomangitije patenda Daudi nakajakwe kingobu apabakiba na njala? ");
INSERT INTO nnq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daudi ngajingi unyumba ja Nnoongo, ngatola mikate ejibekigwe lilumbo kwa Nnoongo, ngalye na kapeganga akajakwe. Ipaligweje mundu kulyee mikate jenie nambu akakung'i tu.” ");
INSERT INTO nnq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Yesu ngajomo kulenga, “Mwana jwa Mundu akweti uwecho ata Lichoba li Kupomolela.” ");
INSERT INTO nnq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lichoba lenge lya Kupomolela, Yesu ngajenda kunyumba ji kugongalela ngabola. Kwenio akiba mundu ojwapolite luboko lwalelo. ");
INSERT INTO nnq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Akaboli bange ba Malagilo na Mafalisayo ngabapala pala lilemwa li kuntakiana Yesu, ngabannendela bammone akalamie mundu lichoba li Kupomolela. ");
INSERT INTO nnq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nambu Yesu ngamanya mawacho gabe, ngannengela jwajo ojwapolite luboko, “Nnyinuke, nhwike nnongi jango.” Mundu jola ngajenda kujema penia. ");
INSERT INTO nnq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu ngabalengela, “Na nkonyanga, bo, Malagilo gito gutulenge kutenda nike Lichoba li Kupomolela? Kutenda kilebe chambone andaje kutenda kilebe changambone? Kunkombo mundu andaje kunkoma?” ");
INSERT INTO nnq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ngabalolekea boa, Yesu ngalenga, “Ntondabeya luboko lwinu.” Na jwenio ngatenda nyenie na luboko lwakwe ngululama. ");
INSERT INTO nnq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nambu angweto ngabachimwa muno, ngababeka machabuli gukuntende Yesu mabaja. ");
INSERT INTO nnq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kingobu chenie Yesu ngajenda kukitombi kugongalela, ngakelukia kwenio kelu ndaa kunng'ongale Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kindabi jaakwe ngabakemanga akinapunji bakwe, kati jabe ngabapambula komi na abena ngabatinanga liina achandundame, ");
INSERT INTO nnq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni ngantina liina Petulo na nnuna gwakwe Andulea na Yakobo na Yohana na Filipo na Batolomayo, ");
INSERT INTO nnq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo na Tomasi na Yakobo mwana jwa Alufayo na Simoni ojwamanyikana kube nkola kilambo, ");
INSERT INTO nnq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana jwa Yakobo na Yuda Isikalioti ojwa anng'aluka Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu apauluka pikitombi pamwe na achandundame, ngajema pukongolou nkengeni nkolongwa gwa bandu pamwe na akinapunji bakwe bakiba penia. Nkengeni nkolongwa gwa bandu ukiba penia kuboke kuilambo yoa ya Kuyudea na Kuyelusalemu na kuboke kuilambo ya Tilo na Kusidoni, ");
INSERT INTO nnq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ngabaika kumpenakia Yesu nu kulamiigwa itamwe yabe. Angweto abalaga ni michepela ngabaika kuboigwa. ");
INSERT INTO nnq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bandu boa ngabapala kunkunyula, makakala ngagammoka na kalamianga boa. ");
INSERT INTO nnq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu ngabatendebuki akinapunji bakwe, ngalenga, “Mbaya mangweto mammi mahocho, Kingwana cha Nnoongo nga chinu! ");
INSERT INTO nnq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mbaya mangweto mammi na njala ngoe, magambu mmakujukuta! Mbaya mangweto manhwechuka ngoe, mpakuwekanga!” ");
INSERT INTO nnq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mbaya mangweto apabanchimwa bandu, nu kunkana nu kuntukana nu kunkachapianga kwa magambu ga Mwana jwa Mundu! ");
INSERT INTO nnq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nhwalalange mwojo nu kuina, gambu bammeki lilumbo likolongwa kumbengu. Akaokomundu batendanga uyo akalondoli ba Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nambu mpakulaga mangweto mammi nuloi ngoe gambu, kingobu chinu chu kuala mojo kipetite! ");
INSERT INTO nnq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mpakulaga mannyukutanga ngoe, mannyoanga njala! Mpakulaga maunhwekanga ngoe, mpakuechukanga machoba genia!” ");
INSERT INTO nnq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mpakulaga mangweto mmoa babannumbali bandu, akaoko mundu batenda uyo kwa akalondoli buwangi.” ");
INSERT INTO nnq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nambu nannenge mangweto maumbenakia, mapale akangondwa binu, matendelange gambone abanchimwanga, ");
INSERT INTO nnq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","malumikange upeele abammeka nhwilo na magongalelange abantendelanga mabaja. ");
INSERT INTO nnq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Anda mundu amputite lijego limwe mantendebukie lenge. Anda mundu ampokite likoti linu, mannekele na nkogo gwinu. ");
INSERT INTO nnq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mampe mundu jwajote jola ojwannyopa kilebe na anda mundu ampokite kilebe chinu, makannengeje umuikie. ");
INSERT INTO nnq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Matendelange bandu ajingi andi mwe gamagapala bantendele mangweto.” ");
INSERT INTO nnq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Anda mapailinge bandu abampalanga mangweto tu, bo, mpata lilumbo nike? Magambu bina malemwa bapalanga abapala! ");
INSERT INTO nnq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Anda matendelinge gambone abantendelanga gambone mangweto, mpata lilumbo nike? Gambu bina malemwa batenda uyo. ");
INSERT INTO nnq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Anda makopelanga baba tu buhyobalela kunnepa, bo, mpata lilumbo nike? Gambu bina malemwa bakopelana bene akangweto jika, kupala babukiange andi ucho. ");
INSERT INTO nnq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nambu! Gambu mangweto mapalange akangondwa binu na katendelanga gambone, makopelange panga hyobalela kunnepanga na lilumbo linu maliba likolongwa na mangweto mammaganga ingota ya Nnoongo ojwabi kunani. Kwa magambu jwenio jwambone kwa banga lumbo na akabaja. ");
INSERT INTO nnq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mmegange na kia anda Awabinu pababi na kia.” ");
INSERT INTO nnq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Makahukumuje ajinu bandu na Nnoongo ahukumulangaje, makakoleeje bange na mangweto bankoleeje, malekekeange bange na Nnoongo mannekekea. ");
INSERT INTO nnq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mapegange bange na Nnoongo mampa. Elo, mampatangage nukutwele kipemo, nukupolota mukuboko ginu choa chunhwotwi kamula, kwa magambu kipemo echimapemelanga bange ngucho echapakumpeme Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu ngabalandanakia kulenga, “Jwangalola kuotoje kuntandaya jwangalola nnyakwe, anda atei yenie, boa mabatumbukila mulibomba. ");
INSERT INTO nnq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Napunji kapetaje aboli bakwe, nambu kila napunji anda ajomwile maboulo gakwe aba andi aboli bakwe. ");
INSERT INTO nnq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mbona milibona lipandi elibi mulio lya nnunagwinu nambu kulibonaje lipalamandi elibi muliolinu mmene? ");
INSERT INTO nnq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nhwotobo kunnenge nnuna gwinu, ‘Nnyeme nammoye lipandi mulio linu,’ nambu kulolaje lipalamandi elibi mulio linu? Mikitenda mambone mwe! Mmoye oti lipalamandi elibi mulio linu na penia manhwotola kulola kipola kuboya lipandi elibi mulio lya nnuna gwinu. ");
INSERT INTO nnq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nkongo gwambone kupambikaje ngokwa yanga mbone na nkongo mmaja kupambikaje ngokwa yambone. ");
INSERT INTO nnq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kila nkongo umanyika kwa ngokwa eipambika. Bandu kutongoje mandombi munchonda na uyo bandu kutongolaje ngokwa ikemigwa zabibu mumikongo ja miba. ");
INSERT INTO nnq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu jwambone apiya agabi gambone kuboka mumwojo gwakwe, na mundu mmaja apiya mabaja kuboka mumwojo gwakwe. Gambu kano jilongela agatwelile mumwojo gwa mundu. ");
INSERT INTO nnq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mboni ungemanga ‘Angwana, Angwana,’ na kongo kutendangaje ganannengelanga? ");
INSERT INTO nnq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mundu jwa jwoa ojwaika kwango nenga kupenikia malobe gango nukuga agabala jwenio abi, ");
INSERT INTO nnq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","andi mundu ojwachengite nyumba jakwe ngaemba pae na kubeka kijemo panani piliganga. Lukemba ngulutwelela nukunga nyumba jakwe jigwije gambu achengiti gwicho. ");
INSERT INTO nnq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nambu jwajwoa ojwajoine malobe gango nukuagabaje jwenio alandana na mundu ojwachengite nyumba jakwe panga kijemo. Lukemba apulu twelela mache ngagakunga nyumba jenie ngijigwe nu kubomoka, nuluindo lwakwe lukiba lukolongwa!” ");
INSERT INTO nnq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu apajomola kabola bandu goa, ngajenda kukilambo cha Kukafalanaumu. ");
INSERT INTO nnq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kwenio akiba kilongoi jwa akalenda ba Loma jwenio akiba na mmanda jwakwe ojwampaile muno, mmanda jwenio akiba ntamwe lola. ");
INSERT INTO nnq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kingobu kilongoi jwenio apajoa nhwalo gwa Yesu ngabatuma akananhota bange Akayahudi bajendange kunnyopa aike kunnamia mmanda jwakwe. ");
INSERT INTO nnq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bandu benia ngabaika kwa Yesu, ngabampembela muno, kulenga, “Mundu ojo jwambone apaligwa muntendele agapala. ");
INSERT INTO nnq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bapala bandu bito, putuchenga nyumba ji kugongalela jwenio ngatujangata muno.” ");
INSERT INTO nnq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yenie Yesu ngajenda pamwe nabo. Akiba kutaalije na nyumba, kingobu kilongoi pabakinga akaganjamundu bannenge Yesu, “Angwana, mikikichumbuyaje, mbaligweje mwe nnyingi unyumba jango. ");
INSERT INTO nnq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Uyo mbemalije ne kube nambone kwinu. Nambu nnonge lilobe tu mpakachi jwango malama. ");
INSERT INTO nnq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ne uyo namundu nambi pae ji kinala cha akakolongwa, ngweti manjolinjoli pae jango anda nunhwamuliche jumwe, ‘Nnyende!’ Jwenio kujenda. Najonge, ‘Nhwike!’ Jwenio kuika, anda nunhwamuliche mpakachi jwango, ‘Nkamu kilebe chenje!’ Jwenio kamula.” ");
INSERT INTO nnq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu apajoa genia, ngaomongwa, ngabatendebukila bandu ajingi abankengama, ngalenga, “Nanibonaje imani ngolongwa andi eje, Kuisilaeli!” ");
INSERT INTO nnq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Akabanda apababujanga kachabe akilongoi ngabankole mpakachi jola alamite. ");
INSERT INTO nnq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kuboka penia Yesu ngajenda kukilambo chimwe echikikemigwa Naini, pamwe na akinapunji bakwe na nkengeni gwa bandu. ");
INSERT INTO nnq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Apababandakila kuika panniango gwa kilambo ngabapiti bandu bapotwi lijenecha lya kakombo jumwe mwana jwa jiika jwa nanhwele. Bandu ajingi ba kilambo chene bakibanga pamwe na amama benia. ");
INSERT INTO nnq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kingobu Angwana pabammona munkege jwenio, mwojo gwakwe ngutwele kia, ngannenge, “Makagutaje.” ");
INSERT INTO nnq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Penia Yesu ngaegele nu kulikunyula lijenecha na abapotolinge ngabajemanga, Yesu ngalenga, “Kakombo! Nannenge, nnyimuke!” ");
INSERT INTO nnq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mundu jwenio ojwawile ngajinuka ngatumbu kulongela, Yesu ngankamuya kwa amamundu. ");
INSERT INTO nnq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bandu boa ngababe nambwele ngabannumba Nnoongo, kulenga, “Nnondoli nkolongwa jwa Nnoongo apiti kati jito. Nnoongo aike kakombolanga bandu bakwe.” ");
INSERT INTO nnq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Minhalo ja Yesu ngijijoanika mukilambo choa cha Yudea na kuilambo eibandakile. ");
INSERT INTO nnq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kingobu akinapunji ba Yohana apabannengela minhalo jenie joa. Ngabakemanga akinapunji akabele kati jabe, ");
INSERT INTO nnq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na ngabakinga ka Angwana bakakonye, “Mwenga nga jwajo ojwalengigwa atenda kuika, andaje tupaligwa tunnende jonge?” ");
INSERT INTO nnq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kingobu angweto apabaika kwa Yesu, ngabalenga, “Yohana Mmatichi atukingite kwinu tunkonyekeye, ‘Mwenga nga jwajo ojwalengigwa atenda kuika, andaje tupaligwa tunnende jonge?’ ” ");
INSERT INTO nnq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kingobucho, Yesu akiba bakalamianga bandu ajingi abapotekigwa ni itamwe ni michepela mibaja kabekanga bangalola ajingi balole. ");
INSERT INTO nnq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu ngabajanga, “Mmujange, makannengelange Yohana agamagabweni nu kugajoa, bangalola kulola, nangwaba kujenda, bina maloi bajegwike, bangajoa kujoanga abawile kuyoka. Akahocho katangachilanga Nhwalo Gwambone. ");
INSERT INTO nnq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mbaya mundu jwajo jwangabe na mbwele nane!” ");
INSERT INTO nnq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kubokapa akapakachi ba Yohana kujabula, Yesu ngatumbu kalengela bandu ajingi nhwalo gwa Yohana, “Pamajendanga kupongoti kummona Yohana mahyobalela kummona mundu nike? Andaje nnyeilinga kilibona linyai elipoge mboga? ");
INSERT INTO nnq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Lele nnyela kulola nike? Nnyela kunnola mundu ojwakwindite ngobo inakualala? Bandu abakwindanga andi yene kutama kukikikonja, batamanga mumajumba gi kingwana! ");
INSERT INTO nnq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Unengelange nnyela kummona meneke? Nnondoli? Eluwe, kweli Yohana akiba kupeta nnondoli. ");
INSERT INTO nnq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jwenio nga ojwalengigwa Mumajandiko ga Chwapi. ‘Nnoongo alenga, mbakunkinga mmanda jwango, annongolele nu kumpanganakia ndela jinu.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu ngajonjakea, “Nannengelanga Yohana nga nkolongwa muno kupeta mundu jwajwoa ojwatamite padunia pano nambu ojwabi nchokochoko mukingwana cha Nnoongo nga nkolongwa muno kupeta Yohana.” ");
INSERT INTO nnq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bandu boa pabannyoa jwenio, muno akatocha kodi ngubulumba gwambone gwa Nnoongo, benia nga abajeketela kubatichigwa na Yohana. ");
INSERT INTO nnq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nambu Mafalisayo na Akaboli ba Malagilo ga Musa ngabakananga kunnyali Nnoongo na yene ngabakananga kubatichigwa na Yohana. ");
INSERT INTO nnq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu ngajendekea kulongela, “Ngoe nannandanakia na bandu ba bangoe? Balandine na nike? ");
INSERT INTO nnq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Benia babi andi ingota itamangite pachoko. Kikuta chimwe kukilenge chenge, ‘Tunhwonalinge ng'oma ja mpapala gukutolana, nambu nhwinangitije! Tujembite minhambo jukokaleka nambu nng'utangitije!’ ");
INSERT INTO nnq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana Mmatichi ngaika akiba kupunga na anywije divai na mangweto ngamannenga, ‘Akweti nchepela!’ ");
INSERT INTO nnq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana jwa Mundu aike atendakulyee na kunywee na mangweto ngannenganga, ‘Mannolekeange ojo kupojoka nu kulobela, nng'anja gwa akatocha kodi na bina mabaja!’ ");
INSERT INTO nnq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mwojo gwambone gwa Nnoongo ubonakine kube kweli kwa bandu boa abajeketile.” ");
INSERT INTO nnq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo jumwe ngankoka Yesu kulyee chakulya kachakwe, na Yesu ngajingi kachakwe Mfalisayo jwenio, ngatama kulyee. ");
INSERT INTO nnq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kukilambo chenie akiba munkege ojwakiba na mabaja. Apajoa Yesu atenda kulye kwa Mfalisayo, ngatola chupa cha alabasta. Chimauta ginakunungila, gabei ngolongwa muno. ");
INSERT INTO nnq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ngajema papipi pa makongono ga Yesu, apeta kuguta na akanhwolokea manjochi mumakongono ga Yesu. Nukuungula makongono ga Yesu kwa nywili yakwe yu umutwe, ngannamba nu kumbakaya mauta genia. ");
INSERT INTO nnq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kingobu Mfalisayo apagabona genia, ngaacha kumojo gwakwe, “Mundu ojo akabi nnondoli kweli kabi amanyi munkege ojo pabile na kabi amanyi ubaja gwabinago!” ");
INSERT INTO nnq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ngalongela nukulenga, “Simoni, ngweti kilebe chu kunnengela.” Simoni ngannengela, “Elo, Aboli unengele.” ");
INSERT INTO nnq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Penia pakiba na bandu akabele abankopite uloi, Yesu ngatumbula, “Jumwe ngankopa uloi tela na nchala gwa myei makomi mabena. Na jonge tela na myei mibena. ");
INSERT INTO nnq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akibaje kati jabe ojwaotwi kunnepa jwenio, yene jwenio ngabalekekeanga boa akabele. Meneke kati ja akabele benia abapakapala muno Angwana?” ");
INSERT INTO nnq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni ngajanga, “Kweli, jwajo ojwalekekeigwe ligambo likolongwa muno nga ojwabakapala muno Angwana benia.” Yesu ngalenga, “Tela.” ");
INSERT INTO nnq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Penia Yesu ngatendabuka kwa munkege nukunnenge Simoni, “Mamweni munkege jonjo? Ngaika pachinu pano, mambije mache gukuya makongono gango, nambu jonjo anyeliye makongono gango kwa manjochi gakwe nukunhwungula kwa nywili yakwe. ");
INSERT INTO nnq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mwenga umbokije kwa kunamba nambu munkege jonjo akotwikije kunamba makongono gango tangu naikila. ");
INSERT INTO nnq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mwenga umbakiije mauta umutwe jango, nambu munkege anyitile mauta gina kunungila mumakongono gango. ");
INSERT INTO nnq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nannengelanga, munkege ojo alekekigwe mabaja gakwe nduu. Mammona ambala muno. Jwajwoa ojwalekekigwa kachoko, alaya kupala kachoko.” ");
INSERT INTO nnq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Penia Yesu ngannengela munkege, “Mabaja ginu galekekigwe.” ");
INSERT INTO nnq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bange abatamite pamecha ngabatumbu konyana benekangweto, “Jwenio mene mpaka aoto kulekekea mabaja?” ");
INSERT INTO nnq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nambu Yesu ngannengela munkege jola, “Imani jinu inkombwile, nnyabu kwa tengela.” ");
INSERT INTO nnq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chenge kingobu Yesu ngapete kunnyini na kuijiji akatangacha Nhwalo Gwambone gwa Kingwana cha Nnoongo. Akinapunji komi na abele ngabalongwana pamwe. ");
INSERT INTO nnq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na akikege bange Yesu ababoyanga michepela mibaja na kalamianga itamwe, ngalongwana nabo. Benia nga Maliamu, ojwakemigwa Magidalena, jwenio ngaboigwa michepela saba, ");
INSERT INTO nnq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana ahana ba Kuza, nkolongwa jwa maakama ga Nngwana Helode, Suzana na bange ajingi. Akikege benia bakiba bakapanga ilebe yabe kummegele Yesu na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bandu ngubunhwikalila Yesu kuboka kila kilambo, ngube nkengeni nkolongwa, Yesu ngabalenge kulandanakia kongo, ");
INSERT INTO nnq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mpandi ngajenda kumicha mbeju yakwe. Apamicha mbeju, yenge ngitola pandela na akapeta ndela ngabalebatanga na ijuni yu kunani ngionyola. ");
INSERT INTO nnq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yenge ngitola pamaganga na kuboka pa kumalika ngijoma kukupelelwa mache. ");
INSERT INTO nnq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yenge ngitola panakati ja miba, mikongo ja miba apimalika ngiibilikia. ");
INSERT INTO nnq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yenge ngitola pulutope lwambone, ngimalika nukupambika mbonje mia.” Yesu ngalenga, “Juna machikilo ajoe!” ");
INSERT INTO nnq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Akinapunji bakwe ngabankonya Yesu kulandanakia kongo mana gakwe nike, ");
INSERT INTO nnq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu ngajanga, “Mangwetomwe nkweti upeele gu kumanya chili ji kingwana cha Nnoongo. Bange kalengela kukulandanikia, mabalolanga nambu bibonaje nu kupenakia nambu bamanyaje. ");
INSERT INTO nnq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ganga nga mana ga kulandanakia, mbeju nga lilobe lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeju eitoi pandela ilaya bandu abajoa lilobe lyenie, nambu Mmaja kuika kuliboya mumyojo jabe ibe bakaaminije na bakakomboligwaje. ");
INSERT INTO nnq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeju eitoi pamaganga ilaya bandu abajoa lilobe lyenie nu kulipokela kwa kuala mojo. Nambu kujendekeje ukola nkati jabe, kuliamini kukingobu tu nambu magambu bakwetingitije mikega nkati jabe apakiika kingobu cha kulondoligwa, kuchipula. ");
INSERT INTO nnq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeju eitoi pimikongo ja miba ilaya bandu abajoa lilobe lyenie, nambu kubanigwa na mbwele nu uloi nu kupala kukikonja, kuhyobale kwabe kujendekeje. ");
INSERT INTO nnq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbeju eitoi pulutope lwambone ilaya bandu abalijoanga lilobe lyenie ngibilikamula kwa mwojo gwambone na gwa kuaminika. Angweto kuimbalila mpaka kupambika ngokwa. ");
INSERT INTO nnq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Bandu kupambaje lumuli nukuekelela lidebe andaje kulubeka nhwina mwa kindanda. Nambu kulubeka panani putala kupala bandu apabakujingila unyumba balolange ndaa. ");
INSERT INTO nnq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Chachoa chela chikiigwe kiba kubonekana pukongolou, na chachoa chela echikiekaligwe kiba kubonekana nu kupiigwa pukongolou. ");
INSERT INTO nnq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mmegange maha apampenakianga, magambu mundu juna kilebe majonjekeigwa, nambu jwanga kola kilebe, na cha chache kichoko cha kweti kipakutoligwa.” ");
INSERT INTO nnq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Penia amamundu na inung'una yakwe ngabanhwikili Yesu, nambu baotolingije kunhwegelela magambu bandu bakiba ndu. ");
INSERT INTO nnq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundu jumwe ngannenge Yesu, “Amabinu na inuna inu bajemite panja, bapalanga bammone.” ");
INSERT INTO nnq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nambu Yesu ngabalenge bandu boa, “Amabango na inuna yango nga ababilijoa lilobe lya Nnoongo nukuliagabala.” ");
INSERT INTO nnq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lichoba limwe, Yesu ngaobake muntumbwi pamwe na akinapunji bakwe ngabalengela, “Tujomboke tujende kwiye ji lilaba.” Penia ngabatumbu mwanja. ");
INSERT INTO nnq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Apabakiba undela Yesu ngabe lugono. Kingobutu upepo nkolongwa ngutumbu kuguguma, mache ngagatumbu kujingila nkati ja ntumbwi, boa ngababeganga mukulola. ");
INSERT INTO nnq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Akinapunji ngabannyendela Yesu, ngabannyimuya ngabalenga, “Anahota, Anahota! Tutenda kuwe!” Yesu ngajimuka ngauamulicha upepo na mawimbi ga mache ngagakotoka, ngukube jee. ");
INSERT INTO nnq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kibokachapenia Yesu ngabalengela akinapunji bakwe, “Imani jinu jibiko?” Nambu angweto ngabaomongwa nu kujogopa ngabalenga, “Ojo mundu nii? Awamulicha upepo na mawimbi gatenda nnyoa?” ");
INSERT INTO nnq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na akinapunji bakwe ngabajendekea na mwanja gwabe, ngabaikanga kumbwani ku kilambo cha Kugelasi echikibendikine na kilambo cha Ku Galilaya, kwiye ja lilaba likolongwa. ");
INSERT INTO nnq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu apauluka kumbwani, ngakongana na mundu jumwe ojwabokela kunnyini juna nchepela. Kwa mangobu ndu mundu jwenio akiba akwinditije ngobo, akiba kutamaje kachakwe, nambu atama kulikabuli. ");
INSERT INTO nnq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Apammona Yesu, ngaguta kulilobe likolongwa, ngakileke pae nnongi ja Yesu nukulenga, “Mwe ma Yesu ma Mwana ba Nnoongo Nkolongwa! Mpala nii kwango? Nannyopa makambotekaje!” ");
INSERT INTO nnq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Alenga genia magambu Yesu auwamulicha nchepela gwenio gummoke mundu jwenio. Kila kingobu ngugunng'wia, nu kuyenie bandu ngabannyigilila unyumba na maboko gakwe na makongono gakwe ngabantaba mitondolo na pingu, nambu ngaotola kueketa mitondolo na pingu na nchepela ngumutuya jwenio mpaka kupongoti. ");
INSERT INTO nnq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu ngankonya, “Lina linu mabeneke?” Jwombe ngajanga, “Lina lyango na ‘Lityala.’ ” Kwa magambu michepela mijingi jakiba jinhwikalile. ");
INSERT INTO nnq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Michepela jenie ngijinnyopa Yesu akajipelekaje kulibomba lya kumambi. ");
INSERT INTO nnq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Paali penia pakiba na kipenga kikolongwa cha magolobe gatela kulye kukitombi. Penia michepela ngijinnyopa Yesu balekange jijingi kamagolobe, Yesu ngajeketela jijingi kamagolobe. ");
INSERT INTO nnq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Michepela ngijimmoka mundu jwenio ngijijingi mumagolobe. Kipenga choa cha magolobe ngikielela kuwelelo ngikijingi mulilaba ngagawe mumache. ");
INSERT INTO nnq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Akachungi apabalola goa agapitile, ngababutukanga ngabajenda kalengela bandu nhwalo gwenio kunnyini na kumigonda. ");
INSERT INTO nnq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bandu ngabaikanga kulola agapitile, ngabannyendelela Yesu, ngabammonanga mundu ojujimmokite michepela atamite papipi na Yesu, akwindite ngobo, abi na malango gakwe, ngabajogopanga. ");
INSERT INTO nnq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bandu ababikibweni kile chenie ngabalenge bandu bange nhwalo gu kulama kwa mundu jwenio. ");
INSERT INTO nnq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bandu boa bikilambo cha Kugelasi ngababeganga na mbwele muno. Kuyenie ngabannyopa Yesu aboke kilambo chenie. Kuyenie Yesu ngaobakela muntumbwi, ngajabula. ");
INSERT INTO nnq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mundu jola ojwaboigwe michepela ngannyopa Yesu, “Nanenga mbala kulongwana na mwenga.” Nambu Yesu annyeketije, ngannengela, ");
INSERT INTO nnq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mmuje kachinu makalanduli goa Nnoongo agantendile.” Bai mundu jola ngajabula ngapeta kutangacha kila paali kukilambo chenie ilebe yoa Yesu eyantendile. ");
INSERT INTO nnq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu apabuja kingonu chenge cha lilaba, bandu ngabampokelanga, magambu boa bakiba bakannendaga. ");
INSERT INTO nnq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Penia ngaika mundu ojwakemigwa Yailo, kilongoi jwa nyumba ji kugongalela. Ngakilikitila mumakongono ga Yesu, ngannyopa ajabule kachakwe kilongoi jwenio, ");
INSERT INTO nnq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","magambu mwana jwakwe munkege akiba jwenio tu, ojwakiba na yaka komi na ibele, akiba ntamwe lola. Yesu apakiba akajabula, bandu ngabanhwegelela kila kingonu. ");
INSERT INTO nnq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kati jabe pakiba na munkege jumwe ojwakiba ntamwe ncholo kwa yaka komi nibena, akiba ajomwile ilebe yakwe yoa eyakweti kwa akaganga, akibaje mundu ojwaotwile kunnamia. ");
INSERT INTO nnq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Munkege jwenio ngankengama Yesu unyuma, ngakunyula lubiniko lwa ngobo jakwe. Upo ngalama kitamwe chakwe cha ncholo. ");
INSERT INTO nnq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu ngakonya, “Bene abangunywile?” Boa ngabalenga abije mundu ojwankunywile, Petulo ngalenga, “Angwana, bandu ajingi bantindilinge nu kunhwegelela.” ");
INSERT INTO nnq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nambu Yesu ngalenga, “Abile mundu jwangunywile, gambu nikibweni makakala gandekumoka.” ");
INSERT INTO nnq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Munkege jola apalola aotwije kukiia, ngakilaya kongo akalendema kukujogopa, ngakigwia nnongi ja Yesu. Penia nnongi ja boa, ngannandulila Yesu magambu gukunkunyula na apaotwile kulama kingobucho. ");
INSERT INTO nnq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu ngannengela, “Manango, imani jinu jinnamiye. Nnyabula kwa tengela.” ");
INSERT INTO nnq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu apakiba tango akalongela, ngaika mundu jumwe kuboka kachakwe Yailo, kilongoi jwa kitebe chukunng'ongalela Nnoongo. Ngannengela, “Mwana jwinu awile, makachumbuyaje Abouli.” ");
INSERT INTO nnq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nambu Yesu apajoa genia ngannenge Yailo, “Makajogopaje, nhwamina tu, jwenio malamage.” ");
INSERT INTO nnq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu apaika kachakwe Yailo, annengije mundu kujingi unyumba pamwe nabo, nambu Petulo na Yohana na Yakobo na achikibelei mundu ba kamwali jwenio. ");
INSERT INTO nnq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bandu boa bakibanga bakaguta nu ukokaleka kwa magambu gwa mwana. Nambu Yesu ngabalenge, “Makagutangaje, magambu mwana ajomwikije, abi lugono tu!” ");
INSERT INTO nnq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Boa ngabanhwekanga kwa magambu bamanyangite kutenda mwana ajomwike. ");
INSERT INTO nnq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nambu Yesu ngankamu luboko ngannengela, “Manango nnyimuke!” ");
INSERT INTO nnq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bwomi gwakwe ngubuja, kingobucho ngajimuka, Yesu ngabalengela bampe chakulya. ");
INSERT INTO nnq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Achikibelei ba mwana ngabaomongwa muno, nambu Yesu ngabalengela bakannengeje mundu jwajoa jola genia agatendigwe. ");
INSERT INTO nnq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu ngabakemanga akinapunji bakwe komi na abena, ngabapeganga uwecho ni kinala chu kujibenga michepela na kalamianga akatamwe. ");
INSERT INTO nnq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kibokachapenia ngabakinga bajendange kutangacha Kingwana cha Nnoongo na kalamia akatamwe, ");
INSERT INTO nnq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ngabalengela, “Apannyendanga mwanja makapotoje kilebe, mumwanja gwinu, makapotoje nkungucho andaje nkoba andaje chakulya andaje uloi andaje makoti mikogo mibena. ");
INSERT INTO nnq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba jajoa jabapakumpokela ntamanga mwenio mpaka apampakuboka kilambo chenie. ");
INSERT INTO nnq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bandu anda bakanite kumpokela mangweto, mmokange pikilambo chenie na mpyatanga litukunda mumakongono ginu, kupala kuchalakicha kwabe.” ");
INSERT INTO nnq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Akinapunji ngabatumbulanga mwanja kupetela kuijiji yoa, ngabatangacha Nhwalo Gwambone na kalamianga bandu kila paali. ");
INSERT INTO nnq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kingobu Helode, kilongoi jwa Galilaya, kujoa nhwalo gwa ilebe yoa eitendigwe, ngabe na mbwele, magambu bandu bange balenga, Yohana Mmatichi ate kuyoka. ");
INSERT INTO nnq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bange ngabalenga, Eliya apitile na bange ngabalengela jumwe kati ja akalondoli ba lolo ate kuyoka. ");
INSERT INTO nnq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helode ngalenga, “Mutwe gwa Yohana ngununhweketa, nambu jonjo meneke jwanyoa nhwalo gwakwe?” Ngapala muno kummona Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Achandundame ngababujanga ngabannengela Yesu goa agabakamulinge. Yesu ngabatolanga, ngabajenda jikajabe kunnyini ku Betisaida. ");
INSERT INTO nnq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nambu bandu pabamanyanga kwajabwile, ngabankengamanga. Yesu ngabapokelanga, ngabalengela nhwalo gwa Kingwana cha Nnoongo, ngabalamianga abapailinga kulamiigwa. ");
INSERT INTO nnq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lichoba apalyatumbula kutipika, akinapunji komi na abele ngabannyendelela Yesu, nukunnengela, “Matabukange bandu na kaleka bajendange kuijiji ya papipi bakapatange chakulya na pakugoloka, magambu pamba apatubile papongoti.” ");
INSERT INTO nnq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nambu Yesu ngabalengela, “Mapagange mangweto mwenga chakulya.” Ngabajanga, “Tukwetije kilebe nambu mikate nhwano tu na yamaki ibele tu. Pangaje tujende takaemele ilyo ya bandu boa bamba?” ");
INSERT INTO nnq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bakibanga penia akinalome elufu nhwano. Yesu ngabalengela akinapunji bakwe, “Malengelange bandu batamange ikuta ya makomi nhwano, makomi nhwano.” ");
INSERT INTO nnq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kuboka pa akinapunji kutendanga yeniela, ");
INSERT INTO nnq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu ngatola mikate nhwano na yamaki ibele, ngalola kunani kumbengu, ngannumba Nnoongo, ngametula mikate na ngatopolana yamaki ngabapeganga akinapunji bakwe babaganakie bandu. ");
INSERT INTO nnq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bandu boa ngabalye nu kujukuta, ngabalokotanga makombo ga ilyo ngabatweleyanga ikapo komi na ibele. ");
INSERT INTO nnq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lichoba limwe, Yesu akiba kugongalela jika jakwe, akinapunji bakwe ngabankengama. Ngabakonyanga, “Bo, bandu balenganga nenga na beneke?” ");
INSERT INTO nnq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ngabannyanga, “Bange balenganga mwenga nga Yohana Mmatichi na bange Eliya, bange jumwe jwa akalondoli ba lolo ba Nnoongo jwombe ayokite.” ");
INSERT INTO nnq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Penia ngabakonyanga, “Mangwetomwe bo, nnenga ne nabeneke?” Petulo ngajanga, “Mwe nga Kilisto ojwalagiligwe, ojwapambuligwe na Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kiboka chapenia Yesu ngabakelebuya akinapunji bakwe bakannengeje mundu jwajoa nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ngalenga, “Mwana jwa Mundu apaligwa kupotekigwe muno nukanigwa na akinanhota na akakung'i akolo na akaboli ba Malagilo ga Musa. Na apangigwa ukomigwa, nambu lichoba lya tatu mayoka.” ");
INSERT INTO nnq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ngabalengela bandu boa, “Mundu jwajoa anda apaile kungengama, apaligwa akikane mwene na atole nchalaba gwakwe kila lichoba na angengame. ");
INSERT INTO nnq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Magambu mundu ojwapala kukombola bwomi gwakwe mwene mauoya, nambu mundu ojwaoya bwomi gakwe kwa magambu gango maukombola. ");
INSERT INTO nnq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mundu apata nike anda aipatite ilebe yoa ya padunia kwa kukioya mwene? Mbemele kibije! ");
INSERT INTO nnq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Anda mundu amone oni nenga na maboulo gango, uyo Mwana jwa Mundu ammonela oni mundu jwenio mangobu apapakuika ku kibumo chakwe na cha Awawa na cha akapakachi ba chwapi ba kumbengu. ");
INSERT INTO nnq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nannengelanga kweli, kutenda babi bange pamba bawegangaje panga bikibone Kingwana cha Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ikiba lichoba lya nane kuboka pa kulenga genia, Yesu ngabatolanga Petulo na Yohana na Yakobo kunani ja kukitombi kugongalela. ");
INSERT INTO nnq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Apakiba akagongalela, kumiio kwabe ngukugalambuka na ngobo yakwe ngibe nhuu mbuu. ");
INSERT INTO nnq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kingobucho bandu akabele ngababe bakalongela nakwe. Bakibanga Musa na Eliya, ");
INSERT INTO nnq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bapitilanga bakiba bina kibumo ngabalongelanga nhwalo gwa kiu chakwe Yesu chikipa kupitila Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulo na akajakwe bakibanga lugono, nambu ngabajimukanga ngabakibona kibumo cha Yesu na ngababona bandu abele abakiba bajemangite pamwe. ");
INSERT INTO nnq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bandu bala pabakiba bakajabula, Petulo ngannengela Yesu, “Anhota, ialile bole twenga tube pamba! Matuchenga iteba itatu, chimwe chinu, chimwe cha Musa na chimwe cha Eliya.” Kweli akiba amanyije chalongela. ");
INSERT INTO nnq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petulo apakiba tango akalongela, kingobucho liunde ngilipitila na kaekelela ni kiwili chakwe, na liunde lyenie apalyaekelela akinapunji bala ngabajogopanga muno. ");
INSERT INTO nnq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lilobe ngilijoanika kuboka muliunde mola, “Jonjo nga Manango ojunampambwile, mampenakiange.” ");
INSERT INTO nnq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kuboka pa lilobe ukotoka, Yesu ngabonekana abi jikajakwe. Akinapunji ngabatamanga nu kwa nhwalo gwenio, na mangobu genia bannengije mundu jwajotijola minhalo jenie jibijibwenangite. ");
INSERT INTO nnq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Malabo jakwe Yesu pamwe na akinapunji bakwe pabauluka kuitombi, nkengeni gwa bandu ngukongana na Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mundu jumwe ngachobela pankenga gwenio, “Aboli! Ndendakunnyopa, munnolekeye manango kabe manango jwa jika. ");
INSERT INTO nnq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Michepela apajinhwikilila, kingobu tu kuntenda achobele, na kummeka kiinduindu na liululu kumpita munkano, jijendekea kumpoteka muno, kunneka chokweje! ");
INSERT INTO nnq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nganajopanga akinapunji binu buboyange, nambu baotolingije.” ");
INSERT INTO nnq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu ngabalengela, “Mangweto mabandu banga imani! Ndama namangweto mpaka lii? Nanhwimbilila mpaka lii? Mannetange mwano pamba?” Kiboka chapenia ngannengela mundu jola, “Munnete mwana jwinu pamba.” ");
INSERT INTO nnq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mangobu mwana jwenio panhwikilila Yesu, nchepela gola ngugunng'wia pae na kummeka mwana jola kiinduindu. Nambu Yesu ngaukalapila nchepela gwenio, ngannamia mwana na kape awamundu. ");
INSERT INTO nnq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bandu boa ngabaomongwa na uwecho nkolongwa gwa Nnoongo. Bandu bala pabakiba tango bakaomwanga minhalo joa echikitendigwe na Yesu, ngabalengela akinapunji bakwe, ");
INSERT INTO nnq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Makalibililangaje echinannengela! Mwana jwa Mundu ajenda kubekigwa mumaboko ga bandu.” ");
INSERT INTO nnq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nambu akinapunji bamanyingitije mana ga kulenga kwenio. Nhwalo gwenio gwakate kuiigwa kwa akangweto ibe bakamanyangaje na bombe batela kujogopanga kunkonya nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ngukupitila kijonga kati ja akinapunji bala nhwalo gwa meneke kati jabe ojwabi munanhota muno. ");
INSERT INTO nnq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu ngamanya mawacho agabawacha mumyojo jabe, penia ngantola mwana nchokochoko, ngammeka papipi jakwe, ");
INSERT INTO nnq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na ngabalengela, “Mundu jwajotijola ojwampokela mwana andi jonjo ku liina lyango, amboke nenga na jwajotijola ojwamboke nenga, bapoke abandumite. Magambu jwajoa ojwabi nchokochoko kupeta boa kati jinu jwenio nga nkolongwa kupeta boa.” ");
INSERT INTO nnq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana ngalenga, “Ananhota, tumweni mundu jumwe akaboya michepela kwa liina linu natwenga ngutujiga kunkanakia kwa magambu jwombe akibaje munkenga gwito.” ");
INSERT INTO nnq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nambu Yesu ngannengela, “Makankanakiaje magambu mundu jwangankananga mangweto abi kingonu chinu.” ");
INSERT INTO nnq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kingobu apakibandikila cha Yesu kutoligwa kujenda kumbengu, ngajenda Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ngabatuma akapakachi balongolelange, bombe ngabajenda ngabajingilanga kukijiji chimwe cha ku Samalia bampanganile kila kilebe. ");
INSERT INTO nnq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nambu bandu ba kwenio bapalangitije kumpokela, kwa magambu ajenda Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bai akinapunji bakwe kina Yohana na Yakobo pabagabona genia, ngabalenga, “Angwana mpala tukeme mwoto uwike kuboka kumbengu gwatiniyange?” ");
INSERT INTO nnq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu ngabatendebukia, ngabakalapilanga. Majandiko gange gajonjakie, ngalenga, “Mmanyangiteje nkweti mojo gani, magambu Mwana jwa Mundu aikila ukoma banduje, nambu kakombola.” ");
INSERT INTO nnq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kibokachapenia Yesu na akinapunji bakwe ngabajenda kukijiji chenge. ");
INSERT INTO nnq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pabakiba bakajendaga undela, mundu jumwe ngannengela Yesu, “Mbakunkengama kila kumpakujenda.” ");
INSERT INTO nnq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ngalenga, “Mabwea gakweti nduka ni ijuni yu kunani ikweti uhui, nambu Mwana jwa Mundu akwetije paali pu kubeka mutwe gwakwe.” ");
INSERT INTO nnq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ngannengela mundu jonge, “Ungengame.” Nambu jwombe ngalenga, “Angwana, nanji uneke nyende oti nakachike awabango.” ");
INSERT INTO nnq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ngajanga, “Milekange mitui ichike mitui mijakwe. Mwenga nnyende makatangache Kingwana cha Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na mundu jonge ngannengela, “Ananhota manankengamage, nambu unyeketele nakatabuke bandu ababi kachango.” ");
INSERT INTO nnq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ngannengela, “Jwajoti ojwakamu lijembe kulema na kongo kulola unyuma kupaligwaje ku Kingwana cha Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kuboka pa genia Angwana ngabachagu bange makomi saba na mabele, ngabatuma akabele abele, bannongolele ku kila kijiji na paali apapala kujenda. ");
INSERT INTO nnq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ngabalengelanga, “Mauno nga majingi nambu akauni akachoko. Nnyopange kwa akola nng'onda bakinge akauni munng'onda gwakwe. ");
INSERT INTO nnq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lele nnyendange! Nankinga mangweto andi mambelele apagajenda kati ja mamei. ");
INSERT INTO nnq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Makapotoje mumwanja gwinu nhwuku guloi andaje nkoba ni ilatuje, makampataje mundu abali undela. ");
INSERT INTO nnq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Anda nnyingilinge nyumba jajoa, ntumbula kulenga, ‘Tengela jibe munyumba jenje!’ ");
INSERT INTO nnq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Anda mundu jwajipala tengela ampokilinge, nnyeketalange ntamange kwa jwenio, anda abije mundu ojwapakumpokelanga, tengela jinu jibakummuji mmene makangweto. ");
INSERT INTO nnq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ntamanga unyumba jenie na nniagange na nnywegange ibampeganga, gambu ojwakamu maengo apaligwa kulepigwa lipungu lyakwe. Makajendangaje kingobu nyumba jenje kingobu nyumba jaje. ");
INSERT INTO nnq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Anda nhwikilinge pikilambo chochoa na bandu bampokelinge, nnyegange kila echibapa kubeka nnongi jinu, ");
INSERT INTO nnq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","nnamiange akatamwe pikilambo chenie na malengelange bandu, ‘Kingwana cha Nnoongo kibandakile kwinu.’ ");
INSERT INTO nnq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nambu anda nnyingilinge kukilambo chochotiche, changampokelanga, mmokange, pampetanga undela jabe nnenganga, ");
INSERT INTO nnq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ata litukunda mumakongono gito li kilambo chinu tilipyata kwa magambu ginu. Nambu nkombokele, kutenda Kingwana cha Nnoongo kibandakile!’ ");
INSERT INTO nnq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nannenge kweli, lichoba lya hukumu, Nnoongo malaya kia kwa bandu ba Kusodoma kupeta kukilambo chenie! ");
INSERT INTO nnq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kulaga mwe! Kilambo chu Kukolasini, kulaga kilambo chu Kubetisaida! Gambu ikobo yanatenda kachinu ilaigwe kukilambo chu Kutilo na Kusidoni bandu bakwe kabi bakwindangite ngobo ya magunia nu kutama pamaliu kulaya balapite. ");
INSERT INTO nnq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ata nyeniela, lichoba lya hukumu mangwetumwenga mampatanga hukumu ngolongwa kupeta ja bandu ba Tilo na Sidoni. ");
INSERT INTO nnq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na mwenga, ma Kafalanaumu, bo, mikitondabeya mpaka kumbengu? Manhwuluigwa mpaka kumambi?” ");
INSERT INTO nnq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu ngabalengela akinapunji bakwe, “Ojwampenakianga mangweto, ambenakia nenga na ojwakana kumpokelanga mangweto, akana kumboke nenga. Na ojwakana kumboke nenga akana kapoke abandumite.” ");
INSERT INTO nnq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mwenakandae makomi saba na abele ngababujanga babilangite na tengela, ngabalenga, “Angwana, ata michepela jitujoine apatujibengita kwa liina linu.” ");
INSERT INTO nnq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu ngabalengela, “Nginilibona Lichetani apilikiba likaagambuka andi njai kuboka kumbengu. ");
INSERT INTO nnq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mpenekiange, nampilangite kinala chu kulebata majoka na makalambwa, ni kinala chu kuibila makakala ga mmaja. Kibije echikipala kummengwa. ");
INSERT INTO nnq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nambu makaalalilangaje kwa magambu ja michepela jinnyoanga, nambu nhwalalilange kwa magambu maina ginu gaandikwe kumbengu.” ");
INSERT INTO nnq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kingobu chenie Yesu kongo atweli uwecho gwa Uhuke jwa Chwapi, ngalenga, “Nannumba mwe Mawawa, Mangwana bu kumbengu na padunia! Magambu ilebe yene maiite bandu bunuwecho na bina malango, ngamaekulila akinangota. Elo, Awawa yene nga pampaile. ");
INSERT INTO nnq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Awabango bangamwiye ilebe yoa. Abije ojwammanyi Mwana nambu Awawa, na abije ojwabamanyi Awawa nambu Mwana na jwajo ojwapai Mwana kunhwekulila.” ");
INSERT INTO nnq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kibokachapenia Yesu ngabuja kwa akinapunji bakwe, ngabalengela, “Mbaya bandu ababagabona gamagabona mangweto! ");
INSERT INTO nnq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nannengelanga kweli, akalondoli ndu na akangwana ngabapala kulola genia gamagabona mangweto, nambu bakagabonaje, nu kugajoa genia gamagajoa mangweto, nambu bakagajoaje.” ");
INSERT INTO nnq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mundu ojwamanyi gwicho Malagilo ga Musa, ngajiga kuntega Yesu. Ngakonya, “Aboli, ndendabole kupala mbate bwomi gwa machoba goa pangapela?” ");
INSERT INTO nnq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu ngannyanga jwombe, “Iandikigwe bole Mumalagilo? Nhwelibo?” ");
INSERT INTO nnq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mundu jo ngannyanga, “ ‘Mapale Angwana ana Nnoongo binu kwa mwojo gwinu gwoa na kwa kiuke chinu choa na kwa makakala ginu goa na kwa malango ginu goa, na mumpale nndami nnyinu anda pimikipala mmene.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ngannengela, “Tela! Ntendi nyeniela, namwe mannama.” ");
INSERT INTO nnq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nambu mundu ojwamanyi Malagilo ngapala kukiingikia mwene kutenda jwa mbone, penia ngankonya Yesu, “Andami ajango ngabeneke?” ");
INSERT INTO nnq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ngannyanga, “Mundu jumwe akiba kuboka Kuyelusalemu kujenda ku Yeliko. Apakiba undela, ngajingiligwa na akajibi ngabampoka uloi jakwe na kumputa, ngabanneka agolwike penia papipi nu kuwe. ");
INSERT INTO nnq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngapitila nkung'i akiba akapeta ndela jenie, nambu apammona mundu jwenio, ngapeta umbwega. ");
INSERT INTO nnq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Unyaela mundu jwa lungolo lwa Lawi uyo ngapeta penia, ngammona, ngapeta umbwega. ");
INSERT INTO nnq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nambu mundu jwa ku Samalia ojwakiba namwanja ngaika penia apakiba mundu jwenio na apammona ngammone kia. ");
INSERT INTO nnq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ngannyendelela, ngammeka mitela mmaganga gakwe kwa kunnyela mauta na divai na kagatabalila, kibokachapenia nganhwobakea panani pa liponda lyakwe, ngampeleka kunyumba jimwe ja akamageni nganwaya. ");
INSERT INTO nnq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Malabo jakwe ngapanga uloi tela na nchaala gwa machoba mabena, ngabalengela, ‘Mannwae mundu jonjo, na uloi gonge ogubakutumika manannepa apambakubuja.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kingobucho Yesu ngankonya, “Kati jabe akatatu, ngajwaako ojwalaite kube andami bakwe jwajo ojwajingiligwe na akajibi?” ");
INSERT INTO nnq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mundu ojwamanyi Malagilo ngannyanga, “Ngajwajo ojwammoni kia.” Yesu ngannengela, “Nnyende makatendi unyaela.” ");
INSERT INTO nnq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na akinapunji bakwe apabakibanga undela, ngabaika kukijiji chimwe na munkege jumwe ojwakonda Malita, ngampokela kachakwe. ");
INSERT INTO nnq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malita akiba nnombo jwa Maliamu, jwenio ngabatama papipi na Angwana kupenekia maboulo gakwe. ");
INSERT INTO nnq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nambu Malita akiba akakamula maengo majingi, bai ngannyendele Yesu ngannenge, “Angwana mboni kujalije nyeniela alombo bango banekite ngamu maengo jika jango? Bai malengele, banyangate.” ");
INSERT INTO nnq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nambu Angwana ngabannyanga, “Malita, Malita, nnolalola nukuchumbuka kwa ile ijingi, ");
INSERT INTO nnq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nambu kilebe chimwe tu chambone, Maliamu achagwile kilebe chambone chenie abije mundu ojwapala kumpoka.” ");
INSERT INTO nnq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lichoba limwe Yesu akiba pa ntemela kugongalela. Apajomola kugongalela napunji jwakwe jumwe ngannengela, “Angwana, tutenda nnyopa mutubole kugongalela anda Yohana Mmatichi apababola akinapunji bakwe.” ");
INSERT INTO nnq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu ngabalengelanga, “Apanng'ongalela, nnengange nyeniela, ‘Awawa, lina linu lya chwapi likoliigwe, Kingwana chinu kiike. ");
INSERT INTO nnq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taji mutupe chakulya chito cha kila machoba. ");
INSERT INTO nnq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mutulekekeye mabaja gito, andi twenga patalekekeya boa ababutulemwite. Mukutubekaje mumitambo.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kibokachapenia ngabalengela, akinapunji bakwe, “Tulenge nnyito jumwe akweti aganja kachakwe kilo puwiku, ngannyopa, ‘Aganja, nanji ungopele mikate mitatu. ");
INSERT INTO nnq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kwa magambu aganja bango bambetile kachango ababi na mwanja nanenga ngwetije chakape!’ ");
INSERT INTO nnq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jwombe akiba unyumba kabi bajangite, ‘Makanjumbuyaje! Tayali nyigile nnyango. Nenga na ingota yango tugolwike, nhwotije kujimuka nampe.’ ");
INSERT INTO nnq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kweli, iganukube ajimukaje kumpe mikate kwa magambu ga mundu jwenio nng'anja mundu, nambu kwa magambu mundu jwenio akwetije oni ja kujendekea kunnyopa, majimuka kumpe chachotichela chakipala. ");
INSERT INTO nnq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Na yene, nannenge nnyopa tu na mangweto mampata, mpalapala tu namangweto mamikibona, nng'omba tu oti namangweto mabanyogolelanga. ");
INSERT INTO nnq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gambu jwajwoa ojwajopa kupata, ojwapalapala makibona na ojwagomba oti mabannyogolela. ");
INSERT INTO nnq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bo, abi mundu kati jinu anda mwana gwakwe jwapa kumpe lijoka papakujopa chamaki? ");
INSERT INTO nnq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Anda ajopite liyaja, bo, mabampa kipelele? ");
INSERT INTO nnq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Anda mangweto mammi mabaja mmanyangite kipeganga ingota inu ilebe yambone, awabinu bu kumbengu mabampaganga muno, mabapaganga Uhuke jwa Chwapi akangweto abannyopanga!” ");
INSERT INTO nnq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lichoba limwe Yesu aubenga nchepela oguntei mundu jumwe kube bubu. Bai nchepela gwenio ngummoka, mundu jwenio ngaotola kulongela, bandu ajingi ngabaomongwa, ");
INSERT INTO nnq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","nambu kati ja bandu bena ngabalenga, “Ajibenga michepela kwa uwecho gwa Belizebuli nkolongwa ju michepela.” ");
INSERT INTO nnq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bandu bange, ngabajiga kuntega ngabampala alaye iingi ibonekane anda kweli akiba nu uwecho kuboka kumbengu. ");
INSERT INTO nnq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nambu Yesu, akiba amanyi mawacho gabe, ngabalengela, “Kingwana chachotichela echikibaganike ikuta ikuta eigambana, mangobuje kupela, na nyumba jajoa janga chikichana kingobuje kujebelea. ");
INSERT INTO nnq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anda Lichetani likikana lyene, Kingwana chakwe kijemabo? Nnengangabo, menga michepela kwa makakala ga Belizebuli? ");
INSERT INTO nnq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Anda nubenga nchepela kwa makakala ga Belizebuli, ingota yinu ijibenga michepela kuwecho gwa beneke? Kwa magambu genia nga pabapakunhwukumu mangweto kube makawangi. ");
INSERT INTO nnq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nambu anda nijibenga michepela kwa makakala ga Nnoongo, bai mmanyange Kingwana cha Nnoongo kiike kwinu. ");
INSERT INTO nnq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mangobu mundu juna makakala, anda abi na chilaa apalendela nyumba jakwe, ilebe yakwe yoa iba tengela. ");
INSERT INTO nnq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nambu anda aike mundu jonge juna makakala muno kunnyingilila na kunhwotola, jwenio apakapoka chilaa yabe eibahyobalela nu kutola ilebe yoa. ");
INSERT INTO nnq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mundu jwajwoa jwanganonda nenga, angana nenga, na jwajoa jwangakongola pamwe na nenga, atenda kuambugana. ");
INSERT INTO nnq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kingobu nchepela pugummoka mundu, ujenda papongoti kupala paali pu kupomolela. Anda nukupataje akilengela mwene anda mbataje paali pa kupomolela, ‘Mambuja kachango kumokitage.’ ");
INSERT INTO nnq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Apabuja nu kujikolela nyumba jela jipyagiligwe na jibi chwapi. ");
INSERT INTO nnq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aijenda kujitola jengi michepela saba, jinamakakala kupeta jwenio, na jwenio kuika kunnyingilila mundujo na ali ja mundu jwenio jibakube mbaja kupeta pitumbula. Ngoe alijakwe jiba mbaja kupeta patumbulaga.” ");
INSERT INTO nnq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu apakiba akalenga genia, munkege jumwe ojwakiba munkenga gwa bandu, ngalenga kwalilobe likolongwa, “Mbaya munkege ojwampotwile mwenga nu kujonga mabele gakwe!” ");
INSERT INTO nnq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nambu Yesu ngajanga, “Mbaya muno abilijoa lilobe lya Nnoongo nukulijali.” ");
INSERT INTO nnq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bandu pabajonjekeka kuika, Yesu ngabalengela, “Bandu bangoe akabaja. Bipala iingi, nambu bapatangaje kiingi chachoa nambu cha Yona. ");
INSERT INTO nnq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ibi tela na apikiba kwa nnondoli jwa Nnoongo Yona akiba kiingi kwa bandu ba ku Ninawi, unyae Mwana jwa Mundu apapakube kiingi kukingolo chenje. ");
INSERT INTO nnq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Linyongolo lya kubanda mapitila mangobu bandu bamba pabapa kuhukumigwa, magambu jwenio ngaboka kachakwe kutaali ngaika kupenikia gambone ga Solomoni napamba pabi nkolongwa kupeta Solomoni. ");
INSERT INTO nnq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bandu bi kilambo chu Kuninawi mabapitila kingobu cha hukumu, na angweto buluhukumula lungolo londo kube na malemwa. Gambu bandu ba Kuninawi balapanga kwa matangacho ga Yona, na pamba abi Nkolongwa kupeta Yona.” ");
INSERT INTO nnq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Abije mundu ojwapamba lumuli nukuluekelela lidebe andaje kuluekelela lidebe nambu kulubeka panani putala ibe bandu abajingila unyumba bapatange kulola ndaa. ");
INSERT INTO nnq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lio linu ngu lumuli lwa mmele, lio linu anda libi lyambone mmele gwinu gwoa mauba mulumuli, nambu anda lio linu libou mmele gwinu uba mulubendu tetele. ");
INSERT INTO nnq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mmeke gwicho lumuli olubinkati jinu lwakabeje pulubendu. ");
INSERT INTO nnq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Anda mmele gwinu gwoa ubi na lumuli, nukubeje paali pina lubendu, mmele gwenio maung'ala kwambone andi lumuli pulumulika mmele.” ");
INSERT INTO nnq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu apakiba akalongelaga, Mfalisayo jumwe ngankoka kujenda kachakwe kulye chakulya. Yesu ngajenda, ngatama kulye. ");
INSERT INTO nnq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfalisayo ngaomongwa kummona Yesu akalya panga kuya oti. ");
INSERT INTO nnq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Angwana ngannenge, “Mangwetomwenga, Mafalisayo nyeleyanga ikombe na yani panja tu, nambu nkati ntwelelinge upoki na ubaja. ");
INSERT INTO nnq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Makajinga mangweto! Bo, ojwatenganiche panja nga ujwoje ojwatenganiche nkati? ");
INSERT INTO nnq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mpangange malumbo kwa akaocho ilebe eibi nkati, na yenge yoa maiba chwapi kwinu.” ");
INSERT INTO nnq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nambu mpakulaga Mafalisayo magambu ntochanga bandu malumbo mpaka maamba gu kutimbi yakulya, nchicha na maamba gange na kongo kuagabaje katende gambone bandu na mapalano ku Nnoongo. Ipaligwa kiagabala ilebe yenie na yenge. ");
INSERT INTO nnq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mpakulaga Mafalisayo kwa magambu mpalanga kutama nnongi paali pina ichima unyumba ju kugongalela na kumpata abali kwa ichima muchoko. ");
INSERT INTO nnq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mpakulaga, kwa magambu mmi andi makabuli gangabeka alama, bandu kulebata panani jakwe kumanyangaje.” ");
INSERT INTO nnq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jumwe ojwamanyi malagilo ngannengela, “Aboli, malobe ginu gutukachapia na twenga!” ");
INSERT INTO nnq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu ngajanga, “Na mangwetomwe uyo mpakulaganga makaboli ba malagilo! Matwekanga bandu miigo jangapotoleka, kongo mmene mangweto kutondobeaje maboko ata kachoko kajangatanga. ");
INSERT INTO nnq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mpakulaga mangweto! Kwa magambu nchengele makabuli ga akalondoli ba Nnoongo bombe akaokobinu ngabakomanga. ");
INSERT INTO nnq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yene nchalakichanga mmene kutenda makangwetumwe nnyeketela pabatendanga genia akaokabinu, benia ngabakomanga akalondoli, na mangweto nchengele makabuli gabe. ");
INSERT INTO nnq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Malobe ga Nnoongo galenga, ‘Manapelekelanga akalondoli na achandundame, nambu bange mamakomanga, na bange mamapotekanga.’ ");
INSERT INTO nnq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yene bandu ba ngoe bapa kuhukumigwa kwa kakomanga akalondoli ba Nnoongo makihukumigwa kwa magambu ga myai ja akalondoli boa ejijitinike tangu kutumbu apaja panganigwa dunia, ");
INSERT INTO nnq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kuboka komigwa kwa Abeli mpaka komigwa kwa Zakalia jwombe akomigwa panakati ja pachwapi ni kitembe chukupangi lilumbo. Kweli nannenge lungolo londo maluhukumuligwa kwa genia goa. ");
INSERT INTO nnq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mpakulaga akaboli ba malagilo, kwa magambu nng'oyanga lupungulo lwa nniango gwa malango gu kummanya Nnoongo. Mmene makangweto kujingije na maibilikia abapalanga kujingila.” ");
INSERT INTO nnq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Apakiba akaboka penia, Mafalisayo na akaboli abagamanyi malagilo ngabatumbu kutega kwa kunkonya machwali majingi, ");
INSERT INTO nnq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kuntega kupala alonge malobe gangambone banyonje. ");
INSERT INTO nnq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Maelufu ga bandu ngabakongananga pamwe mpaka kulebatana, Yesu ngabalenge oti akinapunji bakwe, “Mme maha na maboulo ga Mafalisayo ga uwangi. ");
INSERT INTO nnq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kila chikiekeligwe kiba kuekuligwa, na changamanyikana makimanyikana. ");
INSERT INTO nnq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Uyo goa agannongi pulubendu, bandu mabagajoa pukongolou, na gowa agannyojela kingobu milyango mujigale, magatangachigwa pikinyanga. ");
INSERT INTO nnq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nannenge makaganja bango, makajogopaje abakoma mmele, kubapenia kuotolangaje kutenda chenge kilebe. ");
INSERT INTO nnq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mananangila ju kunnyogopa, mannyogopange Nnoongo jwombe kuboka pukoma, akweti kinala chu kunneke kumwoto gwangaimika machoba goa. Nhwamina ne, jwenio nga ju kunnyogopa! ");
INSERT INTO nnq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Imanyakine kube iyebele nhwano iyuchigwa kwa yumuni komi, yeneje? Nambu Nnoongo kikilibalije wala chimwe. ");
INSERT INTO nnq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nambu ata nywili ya mutwe gwinu aibalangigwe yoa. Yene makapwelelaje, mangweto mambone kupeta iyebele ijingi. ");
INSERT INTO nnq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nannenge kweli, kila mundu ojwanyeketela pabandu kutenda jwenio nga jwango, Mwana jwa Mundu mannyeketela nnongi ja akapakachi ba Nnoongo kutenda mundu ojo nga jwango. ");
INSERT INTO nnq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nambu mundu jwajotijola ojwambakungana nnongi ja bandu, jwombe makanaligwa nnongi ja akapakachi ba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Jwajotijola ojwalenga lilobe lyu kunkana Mwana jwa Mundu malekekiigwa, nambu ojwantukana Uhuke jwa Chwapi alekekiigwaje. ");
INSERT INTO nnq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pabampeleka mangweto nnongi ja nyumba ja kugongalela nnongi ja akatawala na bina kinala, makapweleje kilebe champakulongela andaje champakulongela. ");
INSERT INTO nnq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Magambu Uhuke jwa Chwapi, kingobucho mammola mangweto chu kulongela.” ");
INSERT INTO nnq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu jumwe ojwakiba pamwe na bandu bala ngannenge Yesu, “Aboli, mannengele nunugwango tubagane ulichi ugubutuleki Awawa bito.” ");
INSERT INTO nnq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu nganyanga, “Maganja bango, beneke abambi ne kube nahakimu ba ilebe andaje nachikachani panakati jinu?” ");
INSERT INTO nnq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ngabalengela boa, “Mmagange maha na tama, gambu bwomi gwa mundu uhyobale kube ni milebe eiyakwetije, wala uloi guba kube.” ");
INSERT INTO nnq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kubokapenia ngabalengela kulandanakia gongo, “Pakiba na mundu juna uloi ojwakweti nng'onda guipambike ilyo ndu. ");
INSERT INTO nnq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mundu jwenio ngawacha kumojo gwakwe, ‘Ndenda bo nenga? Ngwetije paali pa kubeka mauno goa gano? ");
INSERT INTO nnq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ngakilenge mwene, ndenda yene,’ ‘Momolana ikokwe yango nukuchenga kikokwe kikolongwa muno, mwenio mameka ilyo yango yoa ni ilebe yango. ");
INSERT INTO nnq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kuboka penia nikilengela namwene. Ngoeno nkweti lupambo lwa kutumia kwa yaka na yaka. Kutama na bwomi kutama kwa mbone, kulye, nukunywe nukube na laa!’ ");
INSERT INTO nnq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nambu Nnoongo ngannengela, ‘Mwe majinga! Lele kilo bwomi gwinu mautoligwa. Na ilebe yoa yenie eimikibekile maiba yabeneke?’ ” ");
INSERT INTO nnq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu ngajomole kulenga, “Ngapibile kwa mundu ojwakibekela uloi magambu gakwe mwene, nambu jwenio kileje nnongi ja Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kubokapenia Yesu ngabalenge akinapunji bakwe, “Na yene nannenge makapwelejekwa nhwalo gwa chakulya chimikipala kwa bwomi gwinu na ngobo imipala kwa mmele gwinu. ");
INSERT INTO nnq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bwomi kilebe cha mbone kupeta chakulya nammele nga gwambone kupeta ngobo. ");
INSERT INTO nnq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Milibone likongolo, kupandaje mbeju, wala kuunaje na wala ikokwe gakwetije Nnoongo kagalichanga ilyo genia! Mangweto mmi mambone kupeta ijuni! ");
INSERT INTO nnq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bene kati jinu kwa kube na mbwele kuotola kujonjekea bwomi gwakwe? Anda kuotojekilebe hata kichokochoko kwa nike kupwelela kwa ilebe yenge? ");
INSERT INTO nnq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Anda kuotojekilebe hata kichokochoko kwa nike kupwelela kwa ilebe yenge? ");
INSERT INTO nnq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Magabonange maloba ga mpongote apagamalika, kamwaje maengo na kulokaje. Nambu nannenge, mwene Nngwana Solomoni mukibumo chakwe choa akwinditije chwapi andi maloba aga. ");
INSERT INTO nnq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Anda Nnoongo alikwindia yene manyai ga mung'onda agabi leleno na malabo galekeligwa pa mwoto, bo bantendelangaje muno mangweto? Mangweto mabandu bina imani njoko yankweti!” ");
INSERT INTO nnq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Yene makapweleje nukuwacha, nniaganga nike andaje nywaganga nike. ");
INSERT INTO nnq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwa bandu boa bangammanya Nnoongo machoba goa bagabegelela genia goa. Awawa binu bukumbengu bagamanyi goa gampalanga. ");
INSERT INTO nnq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mikibegelelange oti Kingwana cha Nnoongo, na genia gowa mabampaganga.” ");
INSERT INTO nnq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Makajogopangaje, mangweto kikuta kichoko cha akinapunji bango! Gambu Awawa binu bukumbengu bapala kumpe Kingwana. ");
INSERT INTO nnq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nhwuchange yoa eyankwetingite makapegange akanhocho ela yenie. Mijibeke miuku jinu kube chwapi na kukibekela lupambo kumbengu jenie Kwenio jipungukaje, magambu kwenio akabwii kuotoje kujipata na gabije mabongo agaotwi kualabia. ");
INSERT INTO nnq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Penia apalubi lupambo lwinu nga apaupakube mwojo gwinu.” ");
INSERT INTO nnq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mmegange tela kwa goa na muli yinu ibe ikajaka, ");
INSERT INTO nnq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mmegange anda akabanda abalendela angwana babe babuje kuboka kumpapala bajogolele nniango kingobucho echikipaligwe pabapakugomba oti. ");
INSERT INTO nnq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mbaya akabanda ababakakole angwana babe babilingite mio kalenda! Nannenge kweli, benia mabikipangania kabegelela, nakalenge ntamange pukulye na benia kabegelela. ");
INSERT INTO nnq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anda bakabuja panakati ja kilo andaje puiku na kakolela bakakelukianga mbaya jabe akabanda benia! ");
INSERT INTO nnq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mmanyange kube ikabi nkolanyumba akamanyi kingobu mwihi chapakuika, kabi akelukie, na kabi ajilekitije nyumba jakwe jibomaligwe. ");
INSERT INTO nnq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ata mangweto mmegange tela, gambu Mwana jwa Mundu maika mangobu gangamanyika.” ");
INSERT INTO nnq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulo ngalenga, “Angwana, kulandanakia kwenio magambu ga bandu boa?” ");
INSERT INTO nnq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Angwana ngabajanga, “Meneke ojwabi mpakachi jwaaminike na jwambone? Jwenio ananhota bakwe mabammeka alolele akabanda bakwe ibe bape chakulya kingobu echikipaligwa. ");
INSERT INTO nnq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mbaya mpakachi jwojo jubakunkole ananhota mundu akakamula genia! ");
INSERT INTO nnq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kweli mampa kugoya ilebe yakwe yoa. ");
INSERT INTO nnq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nambu anda mpakachi jwenio akilenge mwene, ‘Ananhota bango batenda kuchelwa kubuja,’ kingobucho nu kutumbu kaputanga abanda ajakwe, akinalome na akikege, nukulye nukunywe nukulobela, ");
INSERT INTO nnq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ananhota mundu bibuja lichoba lyangamanyika ni kingobu changamanyika, nu kunhweketa ipande ibena, nu kummeke lipungu lyakwe pamwe na bandu banga amini. ");
INSERT INTO nnq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mmanda ojwamanyi echibapala ananhota bakwe nambu kamwaje andi ipabapala ananhotamundu abakuputigwa muno. ");
INSERT INTO nnq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nambu mmanda jwenio ojwatenda gangapala ananhota bakwe nambu amanyije agabapala anahota bakwe maputigwa kachoko. Ojubampi ijingi malongigwa ijingi, ojubampi kachoko malongigwa kachoko. ");
INSERT INTO nnq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nhikila kupamba mwoto padunia, mbaya gwakabi ujakite! ");
INSERT INTO nnq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngweti ubaticho gwa kupoteka ogumbaligwa nupokele, nubegelela kibegele nike ulenganile! ");
INSERT INTO nnq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nkitanga nhikila kuleta tengela padunia? Na kachokochokoje, tengelaje nambu kulekana. ");
INSERT INTO nnq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kutumbu ngoe, lungolo lwa bandu lukibagana, akatatu kati ja akabele, akabele kati ja akatatu. ");
INSERT INTO nnq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Awawa bankana mwana jwabe munalome, mwana bakana Awamundu, Amama bankana mwana jwabe munkege, mwana munkege bakana amamamundu, akimundu akege bakana ajumbo na ajumbo bakana aniamundu akege.” ");
INSERT INTO nnq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ngaulenge kabe nkengeni gwa bandu, “Apamagabona maunde gakapitila kingonu cha kundonde, nnenganga, ‘Ula majikoma,’ nakweli ukoma. ");
INSERT INTO nnq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Apamubona upepo gukubanda gukagugumaga, nnenganga, ‘Mapaba niliuke lele,’ na kweli kube. ");
INSERT INTO nnq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mangwetomwe makandendemundu mmanyangite kulondola upepo na maunde ni ilebe yu kumbengu kwa nike kumanyaje mangobu ganga? ");
INSERT INTO nnq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mbone kuotolangaje mmene kumanya minhalo ja mbone jukamula? ");
INSERT INTO nnq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maana anda jumunnemwite ampeleka kamaakama yakabi mbaya kwinu kuchikachana nakwe milingiti tango undela, ibe akaikaje kumpeleka nnongi ja akimu na akimu akampange ku nkolongwa jwa manjolinjoli, na angweto kummeka mukipungo. ");
INSERT INTO nnq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nannengela kweli, mpitaje mwenio mpaka apampakujomole kulepa senti ja kujomola ligambo linu.” ");
INSERT INTO nnq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mangobu genia bandu bange ngabaika, ngabannenge Yesu nhwalo gwa bandu ba ku Galilaya abakomigwe na Pilato na myai jabe ngajangabana na myai ji inyama yabapanganga lilumbo kwa Nnoongo kwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu ngabajanga, “Magambu bandu ba ku Galilaya bena bakomigwa kwa magambu genia mpemele kube benia bakiba akabaja kupeta bange aka Galilaya? ");
INSERT INTO nnq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nannenge kweli, na mangweto uyo pangalapa malemwa ginu mpakuwaganga anda bange pabawaga. ");
INSERT INTO nnq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Andaje baba komi na nane abagwelile nnala kwako ku Siloamu, ngabaweganga, nkitanga bombe bakibanga akabaja muno kupeta bandu bowa ba Kuyelusalemu? ");
INSERT INTO nnq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nannenge nyeneje, angweto bakiba na malemwaje nambu mangweto pangalapa majambi ginu, manhwaganga anda bombe.” ");
INSERT INTO nnq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kubokapenia, Yesu ngabalengela kulandanakia kongo, “Mundu jumwe akiba nankongo gwa ngokwa ya zabibu munng'onda gwakwe. Mundu jwenio ngajenda kupala kutongola ngokwa, nambu aikolije. ");
INSERT INTO nnq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngannengela nkamumaengo jwakwe, ‘Nnole, kwa yaka itatu inke kupala ngokwa ya nkongo gongo, nambu mbatiteje kilebe. Muwekete! Kwanike ntumia lutuba lwa lutope panga kilebe?’ ");
INSERT INTO nnq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nambu jwenio ngannyanga, ‘Ananhota, tuleke kabele chaka cheno, manutindikia ntalu nukujela mbolea. ");
INSERT INTO nnq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anda upambike ngokwa manicha, nga chwapi, andaje bai muweketage.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu akiba akabolela munyumba ji kugongalela lichoba lya Kupomolela. ");
INSERT INTO nnq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pena pakiba na munkege jumwe ojwakiba ntamwe kwa yaka komi na nane, magambu nchepela. Mmele gwakwe gukiba na kindunduma ngachipula kujema gwicho. ");
INSERT INTO nnq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu apammona ngankema nukunenge, “Makege, mme agabwa kitamwe chinu kinnekite.” ");
INSERT INTO nnq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu ngammekela maboko gakwe kingobucho mmele gwakwe ngalama kabele, ngannumba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nambu nkolongwa jwa nyumba ja kugongalela ngabachimwa muno magambu Yesu annamia munkege jwenio lichoba lya Kupomolela. Yene ngabalenge bandu babakonganinge penia, “Nkwetingite machoba sita ga kamu maengo, bai nhwikange machoba genia bannamiange itamwe inu, nambu makaikangaje lichoba lya Kupomalela!” ");
INSERT INTO nnq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Penia Angwana ngabajanga, “Mangweto makandendemundu! Mene kati jinu kabi annyogolile ng'ombe jwakwe andaje liponda lyakwe kupita mukitundu ajende kunywe mache, ata ikabi lichoba lyene nga lya Kupomalela? ");
INSERT INTO nnq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngoe, pamba abi biti Ulaimu jwombe Lichetani likate kunnemaya kukingobu cha yaka komi na nane. Bo, ikiba kuwalaje kunnyogolela kutabigwa kwakwe lichoba lya Kupomalela?” ");
INSERT INTO nnq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Apalenga genia, akangondwa bakwe ngabalola oni nambu bandu bange boa ngababeganga na laa kwa magambu ga ilebe ikolongwa yoa eyibantendile. ");
INSERT INTO nnq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu ngakonya, “Kingwana cha Nnoongo kilandine nanike? Nenganakia na nike? ");
INSERT INTO nnq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nga anda mbeju njokonjoko ikemigwa haladali eyapandite mundu jumwe kunng'onda gwakwe, ngimalika na kube nkongo. Ijuni yu kunani ngichenga miu jakwe mu ndambi yakwe.” ");
INSERT INTO nnq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ngakonya kabele, “Nenganakia na nike Kingwana cha Nnoongo? ");
INSERT INTO nnq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nga anda amila ejibatoi amama bamwe ngabatindagana na madebe mabele na nusu ga unga, penia unga gwoa ngutupa.” ");
INSERT INTO nnq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu pajenda Kuyelusalemu ngapete kunnyini na kuijiji, kutangacha Nhwalo Gwambone. ");
INSERT INTO nnq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu jumwe ngakonya, “Bo, Angwana, bandu abapakomboligwa nga achoko?” Yesu ngabalengelanga, ");
INSERT INTO nnq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nkachanange kujingila kwa kupetela nniango ogubi nchokochoko, gambu bandu mabajiganga kujingila nambu baotolangaje. ");
INSERT INTO nnq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mangobu magaika penia akola nyumba bamajinuka nu kujigala nniango, mangweto mijemanga panja na kutumbu kutaukana nniango nukulenga, ‘Angwana mutujogolele nniango.’ Nambu bombe binnyanga ‘Nummaanyije mmokanga kole.’ ");
INSERT INTO nnq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Namangweto mitumbula kunnengela, ‘Twe nga baba tatulila nakunywe pamwe na mwenga, na mwenga ngammola muijiji ito.’ ");
INSERT INTO nnq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nambu bombe bilenga ‘Numanyije mangweto mmokanga ko, mmokange pamba, mangweto nkamwa mabaja.’ ");
INSERT INTO nnq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nga apapapakube na nguto na kuyaga mino, mangobu apampakabonanga Ulaimu na Isaka na Yakobo na akalondoli boa babi mukingwana cha Nnoongo, nambu mmeni mangweto nnekeligwe panja! ");
INSERT INTO nnq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bandu mabaika kuboka kumbwani na kundonde, kuboka kuchanya na kubanda na kutama pa mpapala Mukingwana cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Elo, ababi bukujomolela bibaganga bu kutumbula, na ababi bukutumbula biba bukujomolela.” ");
INSERT INTO nnq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mangobu ugogo, Mafalisayo na bandu bange ngabannyendelela Yesu ngabannengela, “Mmoke pamba nnyabule paali pange, kwa magambu Helode apala kunkoma.” ");
INSERT INTO nnq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu ngabajanga, “Nnyendange makalengele alibwea nyene, ‘Leleno na malabo mengamichepela na kalamia akatamwe, na lichoba lya tatu nijomolela liengo lyango.’ ");
INSERT INTO nnq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ata nyenie, kwa leleno, malabo na papacha, mpaka nyendeke na mwanja gwango, kwa magambu telaje nnondoli akomigwe panja ja Yelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mwe ma Yelusalemu, Mwe ma Yelusalemu! Makomanga akalondoli na kaputa maganga akapakachi ba Nnoongo abakingite kwinu! Palenga nyigite kuikongola ingota yinu kwango andi ngoko apaikongola yana yakwe nkati ja mapapanilo gakwe, nambu mapaije. ");
INSERT INTO nnq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aja! Nyumba jinu jiba ukeba. Nannengelanga, umonaje kabe mpaka apampa kulenga, ‘Alumbigwe ojwaika kuliina lya Angwana.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lichoba limwe lya Kupomalela Yesu ngajenda kulye chakulya kachakwe kilongoi jumwe jwa Mafalisayo, na bandu ngabannolekeya Yesu kukunhwingikia. ");
INSERT INTO nnq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nnongi jakwe Yesu pakiba na mundu jumwe ojwakiba na kitamwe cha kutupa mmele. ");
INSERT INTO nnq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu ngabakonyanga akaboli ba Malagilo ga Musa na Mafalisayo, “Bo kweli andaje ipaligweje kunnamia mundu Lichoba lya Kupomalela?” ");
INSERT INTO nnq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nambu angweto ngaba tamanga nu. Yesu ngankamu ntamwe jwenio, ngannamia na nganneka ajabule. ");
INSERT INTO nnq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kingobutu ngabalenge, “Beneke kati jinu bombe mwana jwabe andaje ng'ombe jwabe akajingi mulibomba kabi bampiitije ata ikabi Lichoba li Kupomalela?” ");
INSERT INTO nnq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Angweto baotolingije kunnyanga. ");
INSERT INTO nnq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu ngaba bona angweto abakokigwe apabakiba bikikipambula paali pa ichima, ngabalengelanga kulandanakia kongo, ");
INSERT INTO nnq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Anda mundu ankokite kumpapala gwa kutola akege, makatamaje paali pa ichima, iotwile akokigwe nngwana jonge jwambone kumpeta mwenga, ");
INSERT INTO nnq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na akola nyumba, abankokite mangweto mabele, mabaika nukunnengela, ‘Malekele benia kitebu chenie.’ Penia mpakola oni nnongi ja boa na ipaligwa kujenda kutama kunyuma. ");
INSERT INTO nnq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nambu anda bankokite kumpapala gwa kutola akege, ntama paali pa mwicho ibe nkolanyumba apapakuika annengele, ‘Aganja, nhwike nnongi pano, paali pambone muno.’ Penia mamiba nikibumo nnongi ja boa abatamangite pamwe na mwenga. ");
INSERT INTO nnq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwa magambu jwajotijola ojwa kitondobe aba kuuluigwa na ojwa kiuluya aba kutondobigwa.” ");
INSERT INTO nnq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Penia Yesu ngannengela na benia abakokite, “Anda mapanganikiinge mpapala nalumu andaje kimuyo, makakokangaje akaganja binu andaje akanuna binu andaje akalonga binu akandamya ajinu ababi binu uloi bakaikangaje na benia mabankokanga, namwenga mamma bannepite chache echi matendelinge. ");
INSERT INTO nnq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ipaligwa apameka mpapala, makokange akaocho, abalemile, nangwaba na bangalola, ");
INSERT INTO nnq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na mwenga mamma mpatite upeele, kwa magambu benia bakwetangitije chu kunnepa. Gambu Nnoongo mampa malepo ginu mangobu bandu bina mojo gwambone apabapakuyoka.” ");
INSERT INTO nnq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jumwe jwa abatamangite pamwe na Yesu apajowa genia ngalenga, “Mbaya mundu ojwa pakutama nu kulye chakulya muki Ngwana cha Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu ngajanga, “Mundu jumwe akabeka mpapala nkolongwa ngabakokanga bandu ajingi. ");
INSERT INTO nnq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kingobu cha mpapala pikiika ngantuma mmanda jwakwe bakalenge bandu baike ilebe yowa ilenganile! ");
INSERT INTO nnq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nambu ngabatumbulanga jumwejumwe kujopa balekekeyange. Ju kutumbula ngannenge mmanda, ‘Emile nng'onda na yene mbaligwa kujenda kulola, nanji nannyopa unneke nakaikaje kumpapala gwinu.’ ");
INSERT INTO nnq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jonge ngalenga, ‘Emile ng'ombe komi ya kulema na mbaligwa kujenda kuijiga nannyopa unneke.’ ");
INSERT INTO nnq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jonge ngalenga, ‘Nanji ndoi akege na yene otoje kuika.’ ");
INSERT INTO nnq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mmanda jola ngabuja kangwana mundu ngalenga goa. Angwana mundu ngabachimwa muno nu kunnenge mmanda jwakwe, ‘Nnyende chokwe kundela na kila kimbatikwa chi kilambo makakeme baikange pamba akahocho na bangalola na nangwaba na abalemalinge boa.’ ");
INSERT INTO nnq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kuboka penia mmanda jola ngalenga, ‘Angwana ilebe yoa ngamwile anda apaunengile, nambu kiigi chumbi chimwe.’ ");
INSERT INTO nnq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Angwana bala ngabannenge mmanda, ‘Nnyende kundela na kila kimbatikwa makaamuliche bandu baikange mpaka nyumba jango jitwelele. ");
INSERT INTO nnq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nannenge kweli mmoa kutenda boa banakokangite ojwapakupaya chakulya cha mpapala gwango!’ ” ");
INSERT INTO nnq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Penia nkengeni nkolongwa gwa bandu pabannyendelela Yesu, ngabatendebukia ngabalenge, ");
INSERT INTO nnq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mundu jwajwoa ojwaika kwango nenga anda nukumbalaje ne kupeta awamundu na amamundu na aanamundu ni ingota yabe na akalombo mundu na akakolo mundu na mwene, kuotoje kube napunji jwango. ");
INSERT INTO nnq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jwajwoa jwangapotola nchalaba gwakwe nu kungengama kuotoje kube napunji jwango. ");
INSERT INTO nnq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Magambu beneke panakati jinu ojwapala kuchenga ulingo nukutama otije kubalanga aimanye ilebe ipaligwa anda maijomolelage? ");
INSERT INTO nnq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Andaje kuboka pukuchimika tu eke nukuchipula kujomola na bandu kunhweka, ");
INSERT INTO nnq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kulenga, ‘Mundu ojo ngatumbu kuchenga nambu ajomwileje.’ ");
INSERT INTO nnq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Andaje Nngwana jwako ojwapala kujenda ukomana na Ngwana nnyakwe, nukutama otije nu kuwacha maotolage, kwa matyala gakwe elufu komi nu kujomana na jwajo juna matyala alufu ichilini? ");
INSERT INTO nnq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Andaloi maotoje mabatuma apakachi kujopa malobe ga tengela nakongo abi kutaali na Ngwana jwenio. ");
INSERT INTO nnq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Uyo abije na jumweje kati jinu ojwapa kube napunji jwango anda nikiilekaje ilebe yakwe yowa. ");
INSERT INTO nnq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwinyo chwapi, nambu anda andauoite kulaa kwakwe, kuotoje kubukia kulaa kwakwe. ");
INSERT INTO nnq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kulaaje nakwa lutopije nakwa lutubaje, bandu kulekela tu. Juna machikilo ajoe!” ");
INSERT INTO nnq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lichoba limwe akatocha kodi na bina mabaja ajingi ngabajenda kumpenekeya Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo na akaboli ba Malagilo ga Musa ngabatumbu kuchonjoya, “Munnolakeye mundu ojo! Babandakila bina mabaja, na kabe atenda kulye nabo.” ");
INSERT INTO nnq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu ngabajanga kwa kulandanakia, ");
INSERT INTO nnq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nhwacha panakati jinu jumwe anda akweti mambelele makomi komi, anda nnoi kube limwe liobite ntenda bole? Mpakagaleka gaga makomi tisa na tisa papongote nu kujenda kulipalapala lyale eliobite mpaka mulibone. ");
INSERT INTO nnq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Anda mulibweni mpakuala mwojo nu kulipoto pilipamba ");
INSERT INTO nnq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nu kubuja nalyo kachakwe. Na kakema akandami ajinu na akamaganja binu pamwe na kalenge benia, ‘Mbi na laa muno nilibweni limbelele lyango iliobite. Aja tuinange!’ ");
INSERT INTO nnq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Uyo, nannenge, papakube na laa kumbengu kwa magambu ga mundu jumwe kulapa mabaja gakwe, kupeta bandu makomi tisa na tisa ababikibona bambone, bangapala kugaleka malemwa gabe. ");
INSERT INTO nnq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Andaje nnolabo? Tulenge akiba munkege jumwe anda akweti uloi komi anda aoite jimwe atenda bole? Apamba lumuli, nu kupyagila nyumba joa na kupala kwa kuingakia muno mpaka kuibona. ");
INSERT INTO nnq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Anda ajipatite, mabakemanga akaganja mundu na akandami mundu nu kulenga, ‘Nhwalalilange pamwe na nenga, magambu nupatite uloi gwango oguobite.’ ");
INSERT INTO nnq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Uyo nannengelanga, nga apabapakualalilanga akapakachi ba Nnoongo kwa magambu ga juna malemwa jumwe ojwalapa.” ");
INSERT INTO nnq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ngajendekea kulongela, “Pakiba na mundu jumwe ojwakiba na ingota ibele ikanalome. ");
INSERT INTO nnq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nchokujola ngabalengela awamundu, ‘Awawa, umbe ulichi gwango.’ Bombe ngababaganakia mali gabe. ");
INSERT INTO nnq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kuboka pa machoba machoko, nchokujola ngaucha ulichi gwakwe, ngaboka mwanja na uloi gwakwe ogwa patite, ngajabwa kilambo cha kutaali kwenio ngajomola uloi gwoa kwa ilebe ya kipuchi. ");
INSERT INTO nnq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Apajomola uloi gwoa, ngukupiti njala ngolongwa mukilambo chenie, jwombe ngatumbu kulolalola. ");
INSERT INTO nnq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ngajopa liengo kwa akola kilambo bakwenio bombe ngabampeleka kunng'onda gwakwe kugape chakulya magolobe. ");
INSERT INTO nnq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Alokalela kulye mangai agagalya magolobe, nambu akibaje mundu ojwampile kilebe chukulye. ");
INSERT INTO nnq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Apatumbula kolamalango, ngawacha, ‘Mboni babi akakamwamaengo ndu ba awabango abalye na kuigaya, na nenga nhwe njala? ");
INSERT INTO nnq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mamuja kawabango na kalengela, Awawa, nijilemwite mbengu, na mwenga uyo nannemwite. ");
INSERT INTO nnq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mbaligwije ata ukemigwa mwana gwinu. Undendi andi jumwe jwa akakamwa maengo binu.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ngatumbu mwanja gwa kubuja ka awamundu. “Apakiba tango abi kutaali, awamundu ngaba mmona, na kwamwojo gwa kia ngabammutakila, ngankumbatila. ");
INSERT INTO nnq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana ngabalengela, ‘Awawa, nijilemwite mbengu na mwe uyo nannemwite. Mbaligwije ata ukemigwa namwana binu.’ ");
INSERT INTO nnq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nambu awamundu ngabalengela akapakachi bakwe, ‘Nnyombaketange! Nnetange ngobo inachwapi makankwindiyange! Makankwindiyange pete ni ilatu! ");
INSERT INTO nnq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Manchinjilange likoga eliatite, tulye nu kualalila! ");
INSERT INTO nnq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwa magambu ga manango jono akiba awile, nambu ngoe abi mmomi, akate kuoba, nambu ngoe abonikine.’ ” Ngaba tumbu kutenda mpapala. ");
INSERT INTO nnq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mangobu genia akakamundu bakiba tango kunng'onda. Apakiba akabandakila kachakwe, ngajoa ilulu na ng'oma. ");
INSERT INTO nnq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ngankema mpakachi jumwe, ngankonya, ‘Kibi nike?’ ");
INSERT INTO nnq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mmanda jwenio ngannengela, ‘Nnuna gwinu abujite ukaja, na awabinu banchinji likoga eliatite kwa magambu bampatite abi telatela.’ ");
INSERT INTO nnq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kakombo jwenio nkolo ngabe nililaka na ngakana kujingila unyumba. Awamundu ngabapita panja nukumpembela ajingile unyumba. ");
INSERT INTO nnq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nambu jwombe ngabajanga, ‘Nkombakele! Yaka yoa nammegalile, nanakanaje amuli jinu. Umbi nike? Umbije ata mwana mbui jumwe nakatendi mpapala na akaganja bango! ");
INSERT INTO nnq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nambu mwana gwinu ojwajitine uloi gwinu kwa upuchi pamwe na akangongola, kingobu tu apaika manchinjile likoga eliatite!’ ");
INSERT INTO nnq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Awamundu ngabannyanga, ‘Manango, mwe mmi pamwe na nenga machoba goa, na kila echimbinacho nga chinu. ");
INSERT INTO nnq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngutupaligwa kutengenecha mpapala na kualalila, kwa magambu ununa gwinu jono, akiba awile, nambu abi momi, akiba aobite, nambu ngoe abonikine.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ngabalengela akinapunji bakwe, “Junauloi jumwe na mpakachi jwakwe. Mpakachi jwenio akatekopakigwa kube alile uloi gwa mundu jumwe, ");
INSERT INTO nnq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mundu juna uloi jola ngankema, ngannengela, ‘Nga nhwalo nike ogunujoa kwinu mwenga? Mmalange eya mpatite na eibokite ya uloi gwango, kwa mana nhwotwije kube mapakachi kabele.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mpakachi jola ngawacha, ‘Angwana bamengite liengo lya ukongola, ngamula nike? Kujenda kulema nhotwije, kujenda kujopajopa andi akahocho nga oni. ");
INSERT INTO nnq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Elo, manyi lyu kamula! Ibe apabapakumenga liengo, bandu bambokelange kachabe.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ngabakemanga abalongigwa na anahota mundu, jumwe. Ngannenge ju kutumbula, ‘Nnongigwa uloi nnenga na angwana bango?’ ");
INSERT INTO nnq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jwenio ngajanga, ‘Mapipa makomi komi ga mauta ga uto.’ Kalani jola ngalenga ntole likalatachi eliandikwe ligambo linu, ‘nhwandika makomi nhwano.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kuboka penia ngankonya jonge, ‘Mwenga nnongigwa uloi nnenga?’ Jwombe ngajanga, ‘Magunia makomi komi ngano.’ Kalani ngalenga, ‘Ntole likalatachi linu eliandikwe ligambo linu nhwandika makomi komi pa nane.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Angwana mundu ngabannumbalila kalani jwenio jwanga aminika, kwa magambu ga kalamuka kwakwe, magambu bandu ba padunia jenje akakalamui kupeta bandu abanhwamini Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu ngajendekea kulongela, “Na yenie nannenge mmekange maganja na bandu kukutumia ilebe ya padunia, ibe pampakujomola bampokele kubwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mundu jwajwoa ojwaba kuaminika kwa kilebe kichokochoko na kikolongwa uyo na jwangaaminika kwa kilebe kichokochoko na kikolongwa uyo kuaminikaje. ");
INSERT INTO nnq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Anda mmi kuaminikaje kugoya uloi mmaja gwa padunia, beneke abapakunkamuya kugoya uloi gwa kweli oguboka kwa Nnoongo? ");
INSERT INTO nnq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Anda mangweto kuaminikaje kugoya ilebe ya mundu jonge, beneke abapakunkamuya ilebe inu? ");
INSERT INTO nnq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Abije mmanda jwaotwile kabegelela akangwana abena, magambu apakunchimwa jumwe nu kumpala jonge andaje apakulongwana na jumwe na kummembula jonge. Kuotoje kummegelela Nnoongo nu ilebe.” ");
INSERT INTO nnq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kingobu Mafalisayo pabajoa genia goa, ngabammembula Yesu magambu angweto bakate kupala muno uloi. ");
INSERT INTO nnq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu ngabalengela benia, “Mangweto mikibekanga kube mabandu bambone nnongi ja bandu, nambu Nnoongo ajimanyi myojo jinu. Magambu ilebe ibonekana yambone nnongi ja bandu yamboneje nnongi ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malagilo ga Musa na majandiko ga akalondoli ba Nnoongo gakiba gakatangachigwa mpaka kingobu cha Yohana Mmatichi, kutumbu penia Nhwalo Gwambone gu Kingwana cha Nnoongo kutangachigwa na kila mundu ajingi kwa makakala. ");
INSERT INTO nnq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nambu kindema kwa mbengu na dunia kujomoka kupeta lunembo lumwe lwa Malagilo ga Musa kuboya. ");
INSERT INTO nnq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mundu jwa jwoa ojwanneka nhwanamundu nu kutola jonge munkege atenda ngongola, na munalome ojwantola munkege ojwalekine na angwana mundu, atenda ngongola. ");
INSERT INTO nnq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Pakiba na Mundu juna uloi na akwinda ngobo ina bei ngolongwa muno na kubeka mipapala machoba goa. ");
INSERT INTO nnq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na penia pakiba na nhwocho jumwe liina lyakwe Lazalo, jwenio akiba na ilonda mmele gwoa na bakibanga kummeka ku mundu juna uloi panniango. ");
INSERT INTO nnq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ahyobalela kulye imbolopolo itola kuboka pa mecha ja juna uloi. Na imbwa ngiika kunnamba ilonda yakwe. ");
INSERT INTO nnq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nhwochojo ngajomoka na akapakachi kuboka kumbengu ngabantola kummeka papipi na Ulaimu kumbengu. Na mundu juna uloi ngajomoka ngabanchika. ");
INSERT INTO nnq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mundu juna uloi pakiba akapotekigwa kumambi, ngajinula mio gakwe ngammona Ulaimu kutaali na Lazalo papipi nakwe. ");
INSERT INTO nnq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ngakema kunonoya, ‘Awawa ana Ulaimu, umone kia, muntume Lazalo ata ikabi kuchwika tu lukonji lwakwe umache, alupe laa lulimi lwango, magambu ndenda kupotekigwa muno na mwoto gongo!’ ");
INSERT INTO nnq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nambu Ulaimu ngalenga, ‘Nkombakela, gwe manango, ngantama na laa ilebe ina chwapi yoa ngampata, na Lazalo ngapata mabaja. Nambu ngoe Lazalo abi mukupomolela na mwenga ntenda kupotekigwa. ");
INSERT INTO nnq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nayene panakati ja twe na mangweto pabi na libomba likolongwa, ibe mundu ojwa pala kuika kongo akaotoje na mundu ojwaboka kongo kuika kwenio akaotoje.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mundu ojwakiba nu uloi ngajanga, ‘Bai awawa lele nannyopa muntume Lazalo ajende kachabe awabango, ");
INSERT INTO nnq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","magambu ngweti inunu yango nhwano bakelebuye kamwa mabaja ibe bakaikaje kongo kupotakigwa.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ulaimu ngajanga, ‘Inunu inu bakweti majandiko ga Musa na akalondoli, bakakelebuya baleke mabajowanga.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mundu juna uloi ngajanga, ‘Awawa ana Ulaimu yeneje nambu anda mundu ayokite kuboka kwa abawile kajendelela mabalapa.’ ");
INSERT INTO nnq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jwombe Ulaimu ngalenga, ‘Anda kajowangaje majandiko ga Musa na akalondoli ba Nnoongo, bajobokangaje ata mundu akayokite kuboka kwa abawile.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ngabalenge akinapunji bakwe, “Iwechikinije pakapitije ipengu eijambukia malemwa, nambu kulaga kwa mundu jwenio ojwapakijambuki ipitile! ");
INSERT INTO nnq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ikabi mbaya kwa mundu jwenio kutabigwa pantandala libwe likolongwa lya kuyagila na kulekaligwa kubaali, kuliko kunnyambukia jumwe jwa akachoko aba kutenda malemwa. ");
INSERT INTO nnq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ntamanga maha! “Andi nnunagwinu annemwite, mankelebuye, anda alapite, mannekekeye. ");
INSERT INTO nnq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na anda annemwite mala saba kwa lichoba, na kila mangobu akabuja kwinu akalenga, ‘Napite,’ ipaligwa munnekekeye.” ");
INSERT INTO nnq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Achandundame ngabalenge Angwana, “Mutujonjekeye imani.” ");
INSERT INTO nnq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Angwana ngabajanga, “Na ati makabi na imani njokochoko andi mbonje njokonjoko andi ya aladali, kabi nhwotolinge kulenge nkongo gongo gwa nkuju, ‘Nnyikuke makakipandakile kubaali,’ kabi gunnyalite. ");
INSERT INTO nnq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tulenge jumwe kati jinu akweti mpakachi jwombe alema kunng'onda andaje achunga mambelele. Bo, apabuja kuboka kunng'onda, binnengela mpakachi jwenio, nnyombakete, nhwiche nnie chakulya? ");
INSERT INTO nnq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ije! Binnengela, ‘Umbanganikie chakulya, mme tela kundumikia mpaka pa mbakujomola kulye na kunywe, kubokapenia namwe nnia na kunywe.’ ");
INSERT INTO nnq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bo, minnumba mpakachi jwenio kwa magambu alenganakie agabannengile? ");
INSERT INTO nnq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na mangweto uyo anda nteile goa agabannengile, nnengange, ‘Twe nga akapakachi tanga nyonjekea, tulenganakie tu gaga agatulengile ukamwa.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu apakiba mumwanja kujenda Kuyelusalemu ngapetela umbwega ja ku Samalia na ku Galilaya. ");
INSERT INTO nnq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Apakiba akajingila mu kijiji chimwe, bandu komi bina maloi ngabakongana nakwe, ngabajemanga kwa kutaali. ");
INSERT INTO nnq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ngaba tondobeanga lilobe ngabalenga, “Yesu Ananhota, mutubone kia!” ");
INSERT INTO nnq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu apababonanga ngabalengela, “Nnyendange mikikilayange kwa akakung'i.” Ngibe apabakiba bakajendanga, ngabajeguka. ");
INSERT INTO nnq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jumwe kati jabe apalola kube alamiigwe, ngabuja akannumba Nnoongo kwa lilobe likolongwa. ");
INSERT INTO nnq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ngakilikitila pae nnongi ja makongono ga Yesu kongo akannumba. Jwenio akiba Nsamalia. ");
INSERT INTO nnq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu ngalenga, “Bo, bandu komije abajeguigwe? Baba tisa babilingite ko? ");
INSERT INTO nnq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Apatikinije jonge ojwabujite kumpe kibumo Nnoongo nambu mundu jonjo tu jwanga Uhyahudi?” ");
INSERT INTO nnq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Penia Yesu ngannengela mundu jwenio, “Nnyeme, nnyabule, imani jinu jinnamie.” ");
INSERT INTO nnq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mangobu gamwe, Mafalisayo ngabankonya Yesu, “Kingwana cha Nnoongo kiika lii?” Jwombe ngabajanga, “Kingwana cha Nnoongo kiika pangabonekana. ");
INSERT INTO nnq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na abije ojwa pakuotola kulenga, ‘Kibi pamba,’ andaje ‘Kibi papa.’ Kwa magambu Kingwana cha Nnoongo kibi nkati jinu.” ");
INSERT INTO nnq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Penia ngabalengela akinapunji bakwe, “Machoba gaika penia mipalanga kulola lichoba limwe lya Mwana jwa Mundu, nambu milibonangaje. ");
INSERT INTO nnq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na bandu binnengela, ‘Nnolange, abi papa!’ Andaje ‘Nnolange, abi pamba!’ Nambu mangweto makabokangaje na makakengamangaje. ");
INSERT INTO nnq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gambu andi njai pijipiti kingobu tu nu kung'ala kunani kingonu chimwe mpaka chenge, ngapipakube lichoba likuika kwakwe Mwana jwa Mundu. ");
INSERT INTO nnq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nambu panga pitila oti genia, apaligwa apotekigwe muno na ukanigwa na kibelei chenje. ");
INSERT INTO nnq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Anda apikiba kingobu cha Nuhu, nga apipakube mumachoba ga Mwana jwa Mundu. ");
INSERT INTO nnq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bandu ngabajendekea kulye na kunywe, kutola akege na kutoligwa na analome mpaka kingobu chenie Nuhu apajingila mu ntumbwi nkolongwa. Ngondo ngijipitila na kapotekanga boa. ");
INSERT INTO nnq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ipakube anda apipitila mangobu ga Lutu. Bandu ngabajendekea kulya na kunywe, kuemela na kuucha, kupanda mbeju na kuchenga. ");
INSERT INTO nnq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nambu lichoba lyenie Lutu apajabula Kusodoma, mwoto na mabwe ga mwoto ngagauluka kuboka kumbengu na kakomanga boa. ");
INSERT INTO nnq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nga apipakube lichoba lyenie Mwana jwa Mundu apapakuekuligwa. ");
INSERT INTO nnq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Lichoba lyenie, jwajoa ojwabi panani ja kinyanga akaulukaje kujenda ukaja kutola ilebe yakwe. Uyo, ojwapakube kunng'onda akabujaje unyuma. ");
INSERT INTO nnq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nkombokelange agagampatite nhwana gwa Lutu. ");
INSERT INTO nnq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mundu jwajoa ojwapala kukombola bwomi gwakwe, apakuoya, na mundu jwajoa ojwauoya bwomi gakwe, apakukombola. ");
INSERT INTO nnq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nannengelanga, lichoba lyenie kilo bandu abele bigolokanga pamwe, jumwe aitoligwa na jonge ailekigwa. ");
INSERT INTO nnq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akikege abena bibaganga bakayaganga okole pamwe, jumwe aitoligwa na jonge ailekigwa.” ");
INSERT INTO nnq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bandu akabele bibaganga kunng'onda, jumwe aitoligwa na jonge ailekigwa. ");
INSERT INTO nnq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Penia ngabankonya, “Nga kole Angwana?” Yesu ngabajanga, “Apubi ntui, ngapagakongana matumbui.” ");
INSERT INTO nnq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kuboka penia Yesu ngabalenge kulandanakia kwa hakimu kupala kabolanga akinapunji kube bagongalelange Nnoongo kila kingobu na bakachipulaje na kachokoje. ");
INSERT INTO nnq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ngabalenge, “Pikilambo chimwe pakiba na hakimu jwenio akiba kunyalije Nnoongo na kaechimuje bandu. ");
INSERT INTO nnq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na pikilambo chenie pakiba na munkege jumwe nawele ojubajendelela machoba goa kajopa kupala ilebe yakwe kuboka kwakangondwa bakwe. ");
INSERT INTO nnq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa machoba majingi hakimu jwenio apaije kunnyeketela apate, nambu kukujomolela ngalenga kumojo jakwe, ‘Nenga ng'anu kube kunnyogopaje Nnoongo na kaechimuje bandu, ");
INSERT INTO nnq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","magambu nawele ojo atenda kunjumbuya, mbakumpe chapala. Andaje apakunjumbuya muno kukuinkalila kila kingobu!’ ” ");
INSERT INTO nnq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Angwana ngabajendekeya kulenga, “Mpenikiye palongila hakimu mmaja. ");
INSERT INTO nnq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nnoongo bajangataje bandu bakwe abapambwile, abanng'utila kilo na mui? Bo, apakuchelwa kapenakia? ");
INSERT INTO nnq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nannenge, apakajangata, kabe chokwe. Bo maikolela imani padunia kingobu Mwana jwa Mundu apapakuika?” ");
INSERT INTO nnq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Uyo Yesu ngabalenge bandu kulandanakia kwa bandu bange abakitenda bandu ba mbone na kabembula bange. ");
INSERT INTO nnq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Penia pakiba na bandu abele ngabajendanga kulubanja lwa nyumba ja kugongalela, jumwe akiba Falisayo na jonge akiba ntocha kodi. ");
INSERT INTO nnq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Falisayo ngajema ngagongalela kumojo na kulenga, ‘Ana Nnoongo, ndenda nnumba, magambu nenga mbi andi bandu bangeje, akapoki na akawangi andaje akangongola. Nannumba kube ne andi ntocha kodi ojoje. ");
INSERT INTO nnq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mbunga machoba mabena kwa wiki, mbanga lipungu lya komi kuilebe yoa yambata.’ ");
INSERT INTO nnq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ntocha kodi ngajema kutaali na wala ajinwikeje kulola kumbengu nambu ngakilikitila kukuechuka nu kulenga, ‘Ana Nnoongo, umone kia nenga nambi na mabaja!’ ” ");
INSERT INTO nnq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu ngalenga, “Nannenge kweli ntocha kodi abuja kachakwe kongo abonekana jwambone nnongi ja Nnoongo. Nambu Mfalisayo joje. Magambu kila ojwa kitondobe aba kuuluigwa na kila ojwa kiuluya aba kutondobaigwa.” ");
INSERT INTO nnq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bandu bange ngabampelekela Yesu ingota ilumikigwe. Akinapunji apabalola genia ngabakanakia, ");
INSERT INTO nnq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","nambu Yesu ngaikema ingota nu kulenga, “Mileke ingota iike kwango mikikanakiaje, magambu Kingwana cha Nnoongo kibekigwe kwa bandu anda benia. ");
INSERT INTO nnq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nkombakela yene! Mundu jwajwoa nukukipokelaje Kingwana cha Nnoongo anda mwana, ajingije mu Kingwana chenie.” ");
INSERT INTO nnq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kilongoi jumwe ngankonya Yesu, “Aboli mambone ndendabole, mbate bwomi gwa machoba goa pangapela?” ");
INSERT INTO nnq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ngankonya, “Kwanike kungema ne nambone? Abije jwambone nambu Nnoongo jika jakwe. ");
INSERT INTO nnq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Magamanyi Malagilo ga Musa, ‘Makabe na ngongolaje, makakomaje na makajibaje na makapanga uchaili gu uwangije kajali awawa binu na amama binu.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jwenio ngalenga, “Genia goa nagaagabile tango apanakiba nakakombo.” ");
INSERT INTO nnq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kingobu Yesu apajoa genia, ngannenge mundu jwenio, “Kiigi kilebe chimwe chikipaligwa kamula. Makauche ilebe yoa einkweti uloi gwene mapegange akahocho na mama manuloi kumbengu, penia nhwike ungengame.” ");
INSERT INTO nnq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nambu mundu jwenio pajoa genia, ngachimwa muno magambu akiba nuloi muno. ");
INSERT INTO nnq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu apalola akachimwa yenie, ngalenga, “Ibibole apibi kujundupa kwa bina uloi kujingila mukingwana cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Elo, nga kindema muno ngamia kupeta pililanga lya chingana, kumpeta juna uloi kujingi mukingwana cha Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bandu ba apabajoanga genia, ngabalenga, “Nga meneke ojwapakuoto ukomboka?” ");
INSERT INTO nnq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ngajanga, “Gangawechekana kwa mundu, ku Nnoongo kuwechakana.” ");
INSERT INTO nnq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petulo ngankonya, “Na twe bole? Tuilekite ilebe ito yoa tunkengime!” ");
INSERT INTO nnq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ngabalengela, “Kweli nannenge, mundu jwajoa ojwalekite nyumba andaje munkege andaje akakamundu andaje achikibelei bakwe andaje ingota kwa magambu ga Kingwana cha Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","apakupokela ndu muno ngoe, na bwomi gwa machoba goa pangapela mangobu agapakuika.” ");
INSERT INTO nnq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ngabatolanga komi na abele umbwega, ngabalenge, “Mpenakiange! Tujenda Kuyelusalemu na kwenio kila kilebe echikiandikigwe na akalondoli ba Nnoongo nhwalo gwa Mwana jwa Mundu makilenganila. ");
INSERT INTO nnq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bapankamuya kwa bandu banga Akayahudi angweto mabantendela gangambone na kunhuni mata. ");
INSERT INTO nnq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mabamputanga iboko na kunkoma, nambu lichoba lya tatu mayoka.” ");
INSERT INTO nnq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nambu angweto bamanyangitije nhwalo gwenio ata kichoko, bakate kuiigwa mana ga malobe genia, na bamanyangitije agagalongaligwe. ");
INSERT INTO nnq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mangobu Yesu apabandakila ku Yeliko, pakiba na mundu jumwe jwangalola atamite papipi akajopa. ");
INSERT INTO nnq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Apajoa nkengeni gwa bandu gwakapeta ngakonya, “Kubi nike?” ");
INSERT INTO nnq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngannengela, “Yesu juku Nazaleti atendakupeta.” ");
INSERT INTO nnq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jwombe ngatondobea lilobe ngalenga, “Yesu, Mwana jwa Daudi, umone kia!” ");
INSERT INTO nnq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bandu abakiba nnongi ngabankalapila ngabannenge akotoke, nambu jwombe ngayangala kuchobela, “Mwana jwa Daudi, umone kia!” ");
INSERT INTO nnq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu ngajema, ngaamulicha bannete nnongi jakwe. Jwangalola jola apaika papipi, Yesu ngankonya, ");
INSERT INTO nnq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mpala nantende nike?” Jwombe ngajanga, “Angwana, nyopa nhoto kulola.” ");
INSERT INTO nnq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ngannengela, “Nname! Imani jinu jinnamie.” ");
INSERT INTO nnq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na kingobu tu jwanga lola jola ngalola, ngankengama Yesu akammegelela Nnoongo. Bandu boa apabalolanga genia, ngabannumba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ngajingila kunnyini ku Yeliko na ngatyanga undela ya munnyini mwenio. ");
INSERT INTO nnq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pakiba na mundu jumwe kwenio liina lyakwe Zakayo ojwakiba nkolongwa jwa akatocha kodi na mundu tajili. ");
INSERT INTO nnq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ngapala kummona Yesu nga meneke, nambu magambu ga bandu ajingi na akiba nnyipi, aotwileje. ");
INSERT INTO nnq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Penia, ngalongalela mbelo, ngaombela unani mwa nkoju ibe aotole kummona Yesu, ojwapeta ndela jenie. ");
INSERT INTO nnq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu apaika paali penia, ngalola kunani na ngannenge Zakayo, “Nhuluke chokwe Zakayo, magambu mpaka ndame kachinu lele.” ");
INSERT INTO nnq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo ngauluka chokwe, ngammpokela Yesu kwa kualalila. ");
INSERT INTO nnq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bandu boa apabalola genia ngabatumbu kokaleka, bakalenga, “Ajabwile kutama na mundu juna malemwa.” ");
INSERT INTO nnq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo ngajema ngannengela Yesu, “Mpenakie, Ananhota! Nenga manapa akaocho nusu ja mali jango, na anda nampokite mundu jwajoa kilebe, manammujichia mala pa ncheche.” ");
INSERT INTO nnq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu ngannengela, “Lele nyumba jenje jikomboligwe magambu angweto uyo kibelei cha Ulaimu. ");
INSERT INTO nnq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mwana jwa Mundu aikile kupalapala na kakombola abaobite.” ");
INSERT INTO nnq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kingobu bandu apabakiba tango bakapenakia genia, Yesu ngabalengela kulandanakia. Penia akiba abandakila Kuyelusalemu, na bandu benia bakita kingobu tu kingwana cha Nnoongo makiika. ");
INSERT INTO nnq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yenie ngabalengela, “Kukiba na mundu jumwe jwa kibelei cha kingwana ojwakiba na mwanja gwa kujenda kilambo cha kutaali ibe apokele liengo lya kingwana, kuboka penia abuje. ");
INSERT INTO nnq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tango nu kubokaje, ngabakema akapakachi bakwe komi, ngabape uloi kila mundu tela na kalengela, ‘Mmanyanga mmene chukutendela uloi gwenio mpaka pambakubuja.’ ");
INSERT INTO nnq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nambu bandu ba kilambo chakwe ngabanchimwa na yenie ngabakinga bandu bajende bakalenge mundu ojwapakummeka abe nngwana, ‘Tampaije jonjo kube nngwana jwito.’ ");
INSERT INTO nnq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Mundu jwenio ngabe nngwana na ngabuja. Na kingobu tu ngabalengela akapakachi benia abapi uloi gola bakemigwe kupala amanye kila mundu apatite nyonjakea gani. ");
INSERT INTO nnq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mpakachi jwa kutumbula ngaika ngalenga, ‘Angwana, mbatite yenge nyonjakea mala pa komi ku uloi ogumbile.’ ");
INSERT INTO nnq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jwombe ngannengela, ‘Chwapi, mwenga mapakachi mambone. Magambu mmi nakuaminika kukilebe kichokochoko, manammeka kube ni kinala kuilambo komi!’ ");
INSERT INTO nnq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mpakachi jwa pili ngaika ngalenga, ‘Angwana mbatite yenge nyonjakea mala pa nhwano ku uloi ogumbile.’ ");
INSERT INTO nnq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jwombe ngannengela, ‘Namwe mma na amuli kuilambo nhwano.’ ");
INSERT INTO nnq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mpakachi jonge ngaika, ngalenga, ‘Angwana, uloi gwinu gongo, ngahia gwicho mukitambala. ");
INSERT INTO nnq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nganyogopa, magambu mamundu makale. Magambu mwe mamundu mantola gangabe ginu, nukutongola changa panda.’ ");
INSERT INTO nnq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jwombe ngannengela, ‘Mwe mapakachi mabaja! Mbanhwukumula kwa malobe ginu! Mamanyi kube nenga namundu nakale, nandola gangabe gango nukutongola panga panda. ");
INSERT INTO nnq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kwa nike, mabekiteje uloi gwango kubenki, nane kabi ndoile pamwe na nyonjakea kingobu apamujite kwango?’ ");
INSERT INTO nnq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Penia, ngabalengela abakiba bajemangite penia, ‘Mammpoke uloi gwenio na makampe mpakachi jwajo jwakweti nyonjakea mala komi.’ ");
INSERT INTO nnq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nambu angweto ngabannengela, ‘Angwana, jwombe tayali akweti nyonjekea mala pakomi ja uloi ogwakiba nago!’ ");
INSERT INTO nnq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jwombe ngabajanga, ‘Kila ojwakweti kilebe mapata nu kunnyonjakea. Nambu jwajo jwanga kola kilebe, ati chache echakweti makitoligwa. ");
INSERT INTO nnq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na ngoe, akangondwa bango abakanangita ne kube nangwana babe, maletange pambano, makomange upamba nnongi jango!’ ” ");
INSERT INTO nnq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu kuboka pa kulongela genia, ngalongalela kujenda Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Apabandakila kuika ku Betifage na ku Betania papipi na kitombi cha Mizeituni, ngabatuma akinapunji bakwe abena, ");
INSERT INTO nnq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ngabalengela, “Nnyendange kukijiji echikibi nnongi jinu. Apampa kuika kukijiji, mamankolela mwana liponda atabaligwe jwanga ombeligwa na mundu. Mankulugulange na mannetange pamba. ");
INSERT INTO nnq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Anda mundu ankonyangite mboni milikulugula, mannengela bilipala Angwana.” ");
INSERT INTO nnq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ngabajabulanga, ngabakolelanga tela andi Yesu apabalengalinge. ");
INSERT INTO nnq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Apabakiba bakankulugula mwana liponda, benekangweto ngabakonya, “Mboni mankulugulanga mwana liponda jonjo?” ");
INSERT INTO nnq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Angweto ngabajanga, “Angwana batenda mpala.” ");
INSERT INTO nnq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ngabampelekela Yesu mwana liponda jola. Penia ngabatandika ngobo yabe panani jakwe, ngabammeka Yesu panani ja liponda. ");
INSERT INTO nnq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu apakiba akajendekea na mwanja bandu ngabatandika ngobo yabe omwakiba akapeta. ");
INSERT INTO nnq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Apaika papipi na Kuyelusalemu, puwelelo gwa kitombi cha Mizeituni, nkengeni nkolongwa gwa akinapunji bakwe ngabatumbu kualalila na kunnumba Nnoongo kulilobe likolongwa kwa ikobo ikolongwa yoa eibibweni, ");
INSERT INTO nnq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ngababe bakalenga, “Abe ni kindimba Nngwana ojwaika ku liina lya Angwana. Tengela kumbengu ni kibumo ku Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Penia acha Mafalisayo bange abakiba munkenga gwenio ngabannenge Yesu. “Aboli, makotoyange akinapunji binu!” ");
INSERT INTO nnq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu ngajanga, “Nannengelanga, anda angwetwa bakotokinge, mamabwe magatondabeya lilobe.” ");
INSERT INTO nnq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu apabandakila muno kukibona kilambo cha Kuyelusalemu, ngabagutila bandu ba Kuyelusalemu, ");
INSERT INTO nnq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akalenga, “Anda makamanyi lele ilebe eileta tengela! Nambu ngoe mibonaje! ");
INSERT INTO nnq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Magambu kingobu makiika akangondwa binu apabapa kuntindikila ndunda ya ngondo nu kuntindilanga nu kunhwibila kila ndela. ");
INSERT INTO nnq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bapa kuntimbatimba mwenga pamwe na bandu binu mumapamanda ginu, bannekeje ati libwe limwe panani ja lenge, magambu mikimanyije kingobu Nnoongo apaika kunkombola.” ");
INSERT INTO nnq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Penia Yesu ngaika pulubanja lwa Nyumba ja Nnoongo, ngatumbula katipa abauchanga ilebe, ");
INSERT INTO nnq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","akalenga, “Iandikigwe Mumajandiko, Nnoongo alenga, ‘Nyumba jango majiba nyumba ja kugongalela.’ Nambu mangweto mijigalambwiye kube nduka ja akabuhi!” ");
INSERT INTO nnq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kila machoba Yesu ngabola pulubanja lwa Nyumba ja Nnoongo. Akakung'i akolongwa na akaboli ba Malagilo ga Musa na akiilongoi ba bandu ngabapala kunkoma, ");
INSERT INTO nnq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nambu bapatangiteje ndela ja kunkoma, magambu bandu boa bakiba bakampenakia, bapalangiteje kupelelwa lilobe. ");
INSERT INTO nnq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lichoba limwe kingobu Yesu apakiba ku Nyumba ja Nnoongo akabola bandu nu kutangacha Nhwalo Gwambone, akakung'i akolongwa na akaboli ba Malagilo ga Musa, pamwe na akinanhota ngabaika, ");
INSERT INTO nnq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ngabannengela, “Mutulengele, nkamu ilebe yenje ku kinala gani? Bene abampi kinala chenie?” ");
INSERT INTO nnq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu ngajanga, “Na nenga mbakunkonya. Unengele, ");
INSERT INTO nnq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","uwecho gwa Yohana gukubaticha uboka kumbengu andaje kubandu?” ");
INSERT INTO nnq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ngabatumbu kutaukana, “Tulengabo? Anda tulengite ‘Kuboka ku mbengu,’ alenga, ‘Mboni, munhwaminingije Yohana?’ ");
INSERT INTO nnq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nambu anda tulengite ‘Kuboka kwa bandu,’ nkengeni ogo gwoa gutuputa mabwe, magambu boa baamininge kutenda Yohana akiba nnondoli jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kuyenie ngabannyanga, “Tumanyije uwecho gwenio ubokita ko.” ");
INSERT INTO nnq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na Yesu ngabalengela, “Nane uyo nannengeje ngamwa ilebe yenje kukinala gani.” ");
INSERT INTO nnq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu ngajendekea kalengela bandu kulandanakia kongo, “Mundu jumwe ngalema nng'onda gwa mizabibu, ngabajaika akalemi, na penia ngaboka mwanja gwa kutaali ngatama kwenio kwa mangobu ndu. ");
INSERT INTO nnq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kingobu cha mauno, mundu jwenio ngankinga mpakachi jwakwe kwa akalemi bala, akatole paali pa ngoko ga nng'onda gwa mizabibu. Nambu akalemi bala ngabamputa mpakachi jwenio, ngabammuya panga kilebe. ");
INSERT INTO nnq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngankinga mmanda jonge, nambu akalemi ngabamputa na jwenio uyo, nu kuntukana na ngabammuya panga kilebe. ");
INSERT INTO nnq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ngankinga mmanda jwa tatu, na jwenio uyo kuboka pu kumpoteka, ngabantipa. ");
INSERT INTO nnq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nkola nng'onda ngawacha, ‘Ndenda nike? Manankinga manango ojunampala, mbemele mabannyali jwenio.’ ");
INSERT INTO nnq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nambu akalemi bala apabammona tu, ngabalengelana, ‘Jonjo nga nnichi. Nyeme tankome ibe ulichi gwakwe ube gwito!’ ");
INSERT INTO nnq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ngabannekela panja ja nng'onda gwa mizabibu nu kunkoma.” Yesu ngakonya, “Jwajo nkola nng'onda batenda nike akalemi benia?” ");
INSERT INTO nnq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Maika na kakoma bandu benia abapile nng'onda, na kajaika akalemi bange nng'onda gwa mizabibu.” Bandu apabajoa genia, ngabalenga, “Ije gakapitilaje!” ");
INSERT INTO nnq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu ngabalolakea ngabakonya, “Majandiko Gachwapi ganga gabi na mana nii? ‘Libwe elibilikanite akachengi ligalambwike kube lyambone kupeta goa.’ ");
INSERT INTO nnq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kila mundu anda agweli panani ja libwe lyenie apakutwekuka ipande, nambu ojulipakung'welela lipa kuntimba.” ");
INSERT INTO nnq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Akaboli ba Malagilo ga Musa na akakung'i akolongwa ngabamanya kutenda kulandanakia kwenio kwabe kuyenie ngabapala kumpitila, nambu bajogopa bandu. ");
INSERT INTO nnq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ngabapala kingobu echikipaligwa. Ngabahonga bandu bange bikikopekeye kube bambone, ngabatuma bannyonje Yesu kukunkonya ilebe, yenie ibe bampukilange nu kummeka mumakakala ni kinala cha akatawala ba Loma. ");
INSERT INTO nnq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bandu bukuingakia benia ngabannenge Yesu, “Aboli, tumanyi kutenda nnenga na kubola ilebe ya kweli, tumanyi kutenda mwenga kupambulaje mundu, mwenga mmola kweli ja ndela ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mutulengele, anda ipaligwa kulepa kodi ku nkolongwa jwa Loma?” ");
INSERT INTO nnq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu ngamanya batenda ntega, ngabalengela, ");
INSERT INTO nnq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Unayange luela. Bo, kumio na nembo ya beneke?” Ngabajanga, “Kwa Nngwana jwa Loma,” ");
INSERT INTO nnq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu ngalenga, “Mampegange Nkolongwa jwa Loma agabi ga Nngwana jwa Loma, na mampegange Nnoongo agabi ga Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Baotolingeje kunnyonja kwa lilobe lyalyoa papa nnongo ja bandu na yenie ngabatama nuu, bakaomwanga lijango lyakwe. ");
INSERT INTO nnq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Penia Masadukayo abalenga kubije kuyoka. Bange kati jabe ngubunhwikalila Yesu nu kulenga, ");
INSERT INTO nnq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Aboli, Musa atulagila nyene, ‘Mundu andawile na kaleka akege gwangabe na mwana nnung'una mundu batole malekwe, kupala bampotole nnung'una gwakwe ingota.’ ");
INSERT INTO nnq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na pakiba na akalongo saba, nkolongwa ngatola munkege mwene ngawe pangabe na mwana. ");
INSERT INTO nnq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jwajo nnongomundu jwa pili ngantola nawele jwenio, jwombe uyo ngawe, ");
INSERT INTO nnq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na jwa tatu uyo. Ikiba yenie kwa boa saba ngabawe pangabe ningota. ");
INSERT INTO nnq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pukujomolela, munkege jola uyo ngawe. ");
INSERT INTO nnq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bo, lichoba lya kuyoka abawile, munkege jwenio aba jwa beneke? Gambu boa saba bakiba bantoile.” ");
INSERT INTO nnq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ngabajanga, “Bandu ba dunia jenje batenda kutolana nu kutoligwa, ");
INSERT INTO nnq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","nambu bandu baba Nnoongo abapambwile kuyoka lichoba lya kupela, batolaje wala kutoligwa. ");
INSERT INTO nnq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mababa anda akapakachi bu kumbengu baweje. Ni ingota ya Nnoongo magambu bayokite kuboka kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na Musa ngachalakicha kube abawile mabayoigwa. Paali pa Majandiko Gachwapi panani ji kindumba chela echikikiba chakajaka mwoto, alenga Angwana anda ‘Nnoongo jwa Ulaimu, Nnoongo jwa Isaka na Nnoongo ja Yakobo.’ ");
INSERT INTO nnq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jwombe nga Nnoongo jwa ababi bwomi, nambu jwa abawileje, magambu kwakwe boa babi bwomi.” ");
INSERT INTO nnq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bange akaboli ba Malagilo ga Musa ngabalenga, “Aboli, nnyangite tela!” ");
INSERT INTO nnq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gambu bajendakije kunkonya yenge ilebe. ");
INSERT INTO nnq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu ngabakonya, “Ilengigwabo kutenda Kilisto Nkomboi ojwapambuligwe na Nnoongo nga nchokolo jwa Daudi? ");
INSERT INTO nnq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi mwene alenga mukitabu cha Zabuli, ‘Angwana ana Nnoongo ngabalengela Angwana bango, Ntame kingonu chango cha kalelo ");
INSERT INTO nnq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka nabeke akangondwa binu kube kitebu cha kubekela makongono ginu.’ ");
INSERT INTO nnq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Anda Daudi ankema jwombe, ‘Angwana,’ lele, iyotobo kube mwana gwakwe?” ");
INSERT INTO nnq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bandu boa apabakiba bakampenekia, Yesu ngabalengela akinapunji bakwe, ");
INSERT INTO nnq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mme maha na akaboli ba Malagilo, abapalanga kutyanga ngongo bakwindangite kanju. Kupalamwe kupatigwa abali na bandu kuichima muchoko, kutama paali pa ichima munyumba ja kugongalela na kutola ichima mumipapala, ");
INSERT INTO nnq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Baponjanga akanawele nyumba yabe kongo bakakopakea kube bambone kwa magongalelo matandamau. Benia bapakupata hukumu ngolongwa muno!” ");
INSERT INTO nnq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ngalola kukuingakia, ngababona matajili apabakiba bakajela malumbo gabe mulichanduku lya Nyumba ja Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ngammona uyo umama jumwe nawele nhwocho akatumbukia mwenio ela ibena njokonjoko. ");
INSERT INTO nnq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ngalenga, “Nannengelanga kweli, umama nawele jonjo nhwocho ajei munkoba kikolongwa muno kapeta boa. ");
INSERT INTO nnq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Magambu bandu bina uloi bange boa bapangangite malumbo gabe kuboke mu nyonjakea ja mali yabe, nambu umama nawele jonjo, nambu nhwocho, apangite kila kilebe echapaligwa kujendekea kulama.” ");
INSERT INTO nnq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Akinapunji bange bakiba bakalongela nhwalo gwa Nyumba ja Nnoongo, libonekana lina kualala na lina mabwe ga bei ngolongwa, pamwe na malumbo agapangigwe kwa Nnoongo. Yesu ngalenga, ");
INSERT INTO nnq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ganga goa agamagabona, kiika kingobu liigalaje ati libwe limwe panani ja lenge, kila kilebe makibomoligwa.” ");
INSERT INTO nnq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ngabankonya, “Aboli, ilebe yenie ipitila lii? Na kiingi nii echikipakulaya kutenda ilebe yenie ibandaki kupitila?” ");
INSERT INTO nnq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ngabajanga, “Mma maha, makakoloigwaje. Magambu bandu ajingi mabapitila nu kulenga kupete lina lyango, ‘Ne nga Kilisto Nkomboi nambambuligwe na Nnoongo!’ Na ‘Kingobu kiike!’ Nambu makakengamangaje. ");
INSERT INTO nnq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pampakujoa nhwalo gwa ngondo na manjega, makajogopaje, magambu mpaka genia gapitile oti, nambu kupela kwa goa tango.” ");
INSERT INTO nnq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ngajendekea kulongela, “Kilambo chimwe kiputana na kilambo chenge, kingwana chimwe kiputana na kingwana chenge. ");
INSERT INTO nnq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kupakube malendemelo makolongwa ga lutope kongo na kongo na njala na tauni. Kupakube na ilebe ya kuomongwa na iingi ikolongwa kuboka kumbengu. ");
INSERT INTO nnq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nambu tango nu kupitilaje genia goa, bapampukilanga, bapampotekange na kumpelekanga munyumba ya kugongalela na kunnyigililanga mukipungo, bapakupelekwa nnongi ja akangwana na akatawala kwa magambu ga ku amini nenga. ");
INSERT INTO nnq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kupala unjalakiche kwabe. ");
INSERT INTO nnq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nnimbange mumyojo jinu, makawachangaje tango na kingobu nhwalo gwa mpakulenga nii, ");
INSERT INTO nnq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","magambu nenga namwene nampeganga malobe ga mbone, ati akangondwa binu baotolangeje kuimbalila wala kupenga. ");
INSERT INTO nnq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Achikibelei binu na akanuna binu na akalongo, mabang'aluka mangweto na angweto mabankoma kati jinu. ");
INSERT INTO nnq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bandu banchimwa mangweto magambu ga liina lyango. ");
INSERT INTO nnq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nambu, ati lunywili lumwe lwa umutwe jinu luobaje. ");
INSERT INTO nnq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kukuimbalila kwinu, mamupokela ukomboi gwinu. ");
INSERT INTO nnq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pampakulola kilambo cha Yelusalemu kitindiligwe na manjolinjoli, penia mmanyanga kutenda kingobu kiike penia kilambo chenie makibomoligwa. ");
INSERT INTO nnq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Penia, ababi ku Yudea batililange kuitombi, ababi kunnyini babokange, na ababi kumigonda bakabujaje kunnyini. ");
INSERT INTO nnq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwa magambu machoba genia nga machoba ga hukumu, ibe goa agaandikwe galenganile. ");
INSERT INTO nnq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bapakulaga akikege bina ndumbo na akinamama ababi ni ilemba eijonga machoba genia! Kwa magambu kupakube na malola makolongwa muno padunia, na kuchimwa kwa Nnoongo kupakaikilila bandu bamba. ");
INSERT INTO nnq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bange bakomigwa kwa upanga, bange batoligwa ubanda muilambo yoa, na kilambo cha Yelusalemu makilebatigwa na bandu ba ilambo yenge, mpaka kingobu chabe kulenganila. ");
INSERT INTO nnq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kupakube na iingi kulichoba na mwei na ndondwa. Ilambo ya padunia ipakube na malola magambu ga mbwele magambu ga luindo lwa mawimbi ga baali. ");
INSERT INTO nnq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bandu mabainduka magambu ga mbwele, bakalolela ikobo eipakujipata dunia, magambu ilebe eibi kumbengu, lichoba na mwei na ndondwa ibakutikatika. ");
INSERT INTO nnq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Penia, Mwana jwa Mundu akaika mumaunde, juna makakala na kibumo ndu. ");
INSERT INTO nnq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kingobu ilebe yenie apaipakutumbula kupitila, nnyemange na kujinula mitwe jinu kunani, magambu ukomboi gwinu ubandakile.” ");
INSERT INTO nnq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Penia Yesu ngabalengela kulandanakia kongo, “Mulolekeyange nkoju na mikongo jenge joa. ");
INSERT INTO nnq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Apamagabona maamba gatumbu kuipuka, mmanya kutenda mangobu ga mauno gaike. ");
INSERT INTO nnq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Uyo, apampa kulola ilebe yenie yakapitila, maumanyanga kube Kingwana cha Nnoongo kibi papipi kuika. ");
INSERT INTO nnq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nannengelanga kweli, kibelei chenje cha ngoe kipetaje panga kupitila genia goa. ");
INSERT INTO nnq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mbengu na dunia maipeta, nambu malobe gango gapetaje. ");
INSERT INTO nnq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mmegange mio! Mumyojo jinu ikaikaje kulemala na ilebe, nnywagi na kubegelela na itamo yenje. Andaje, lichoba lyale lipakunhwikilila kingobu tu. ");
INSERT INTO nnq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Magambu inhwikila anda ntambo boa abatamanga padunia poa. ");
INSERT INTO nnq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mmegange mio, nu kujopa ku Nnoongo mangobu goa ibe nhwotolange kupata makakala ga kupeta chwapi muilebe yenie yoa eipakupitila, nu kujema nnongi ja Mwana jwa Mundu.” ");
INSERT INTO nnq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kingobu cha mui, machoba genia, Yesu akiba akabola bandu ku Nyumba ja Nnoongo, nambu kilo akiba akajenda kukitombi cha Mizeituni nu kutama kwenio. ");
INSERT INTO nnq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kindabi ndabi bandu boa bakiba bakajenda ku Nyumba ja Nnoongo kumpenakia jwombe. ");
INSERT INTO nnq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mpapala gwa mikate janga jeligwa kimela, ogukemigwa Pasaka, ukiba ubandakile. ");
INSERT INTO nnq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Akakung'i akolongwa na akaboli ba Malagilo ga Musa bapalanga ndela ja kunkoma Yesu, nambu bajogopanga bandu. ");
INSERT INTO nnq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lichetani ngilinnyingi Yuda ojwakemigwa Isikalioti, jumwe jwa baba achandundame komi na abena. ");
INSERT INTO nnq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda ngajenda, ngapangana na akakung'i akolongwa na akalenda ba Nyumba ja Nnoongo kube apapa kunng'aluka Yesu kwabe. ");
INSERT INTO nnq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Angweto ngabaalalila nu kulagana nakwe kunnepa uloi. ");
INSERT INTO nnq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda ngajeketela, ngabe akapala ndela jambone ju kunkamuya kwabe pangamanya bandu ajingi. ");
INSERT INTO nnq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lichoba lya mikate janga jeligwa kimela ngiliika. Lyenie nga lichoba lya mwana limbelele jwa lilumbo lya Pasaka. ");
INSERT INTO nnq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Penia Yesu ngabakinga Petulo na Yohana, ngabalenge, “Nnyendange makatupanganakie mpapala ili tupate kulye Pasaka.” ");
INSERT INTO nnq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Angweto ngabankonya, “Mpala tupangania ko chakulya?” ");
INSERT INTO nnq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ngabalengela, “Mpenikiange! Apampakube makajenda kunnyini, mankongana na munulome ojwapotwi kibega cha mache. Mankengamange mpaka munyumba ejapakujingila. ");
INSERT INTO nnq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mannengela nkola nyumba, ‘Aboli bankonya, kibikole chumbi echimbakulele mpapala gwa Pasaka pamwe na akinapunji bango?’ ");
INSERT INTO nnq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jwombe mannangilage chumbi kikolongwa kugolofa chombe kipanganigwe. Mpangania mwenio.” ");
INSERT INTO nnq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ngabajendanga, ngibikikolanga kila kilebe tela andi Yesu apabalengalinge, ngabapangania mpapala gwa Pasaka. ");
INSERT INTO nnq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kingobu apachalenganila, Yesu ngatama kulye chakulya pamwe na achandundame bakwe. ");
INSERT INTO nnq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ngabalengelanga, “Mbaile muno kulye Pasaka jenje pamwe namangweto tango nu kupotekigwa. ");
INSERT INTO nnq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gambu nannengelanga, ndyeje kabele mpaka apipakulenganila Pasaka mu Kingwana cha Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Penia Yesu ngatola kikombe cha divai, ngannumba Nnoongo, ngalenga, “Mpokelange, mmaganange. ");
INSERT INTO nnq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Magambu nannengelanga, nyweje kabele divai ja zabibu mpaka Kingwana cha Nnoongo apikipakuika.” ");
INSERT INTO nnq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kabe ngatola nkate, ngalumba, ngaumetula, ngabapaganga ngalenga, “Gongo nga mmele gwango oguboigwa kamagambu ginu. Ntendange nyenie kukungombokela.” ");
INSERT INTO nnq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ngatenda uyo na kikombe kuboka pukulye, akalenga, “Kikombe chenje nga cha myai jango, ejijitika kwa magambu ginu kupala kulenganakia lilagano liyono. Gongo nga mmele. Ejijitika kwinu, Gange majandiko gakwetije aya jenje. ");
INSERT INTO nnq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nambu, nnolange! Jwajo ojwambakung'aluka abi nane upamba pamecha. ");
INSERT INTO nnq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kweli Mwana jwa Mundu ajenda ukomigwa anda apipangigwe, nambu kulaga kwakwe mundu ojwanng'aluka.” ");
INSERT INTO nnq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Penia ngabatumbu konyana nga meneke kati jito ojwapakamu nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ngukupitila kutaukana kati ja akinapunji benia nhwalo gwa mene kati jabe ojwapakube nkolongwa kupeta bange. ");
INSERT INTO nnq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu ngabalengela, “Akangwana banga Akayahudi kalongolea bandu babe kwa makakala, na angweto ukemigwa akaganja ba bandu. ");
INSERT INTO nnq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nambu ikabe yeneje kati jinu, ibe, jwajo ojwabi nkolongwa panakati jinu nga mpaka abe nchokochoko jwa boa, na ojwabi kilongoi mpaka abe anda mmanda. ");
INSERT INTO nnq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gambu mana, nga meneke ojwabi nkolongwa? Jwajo ojwatama pamecha kulye chakulya. Nambu nenga mbile panakati jinu anda mmanda. ");
INSERT INTO nnq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mangweto makiba nanenga mangobu goa gu kulondoigwa kwango, ");
INSERT INTO nnq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","na andi Awabango apabangamwiye Kingwana, uyo nanenga nankamuyanga mangweto kingwana. ");
INSERT INTO nnq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Manniaganga nu kunywe pamecha jango mu Kingwana chango nu kutama muitebu yi kingwana kugahukumula makabi komi na mabena gi kilambo cha Kuisilaeli. ");
INSERT INTO nnq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Mpenikie! Lichetani lipala lijeketeligwe kuntega mangweto, kuambugana gambone kube mabaja, andi mundu apaeba ngano. ");
INSERT INTO nnq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nambu nenga nannyopile ibe imani jinu jakaobaje. Na mwenga apampakumujila, balimbe mojo akanunabinu.” ");
INSERT INTO nnq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petulo ngannyanga, “Angwana, nenga mbi laachi kujenda pamwe na mwenga kukipungo, na ata kuwe.” ");
INSERT INTO nnq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ngannyanga, “Na nnenge mwe Mapetulo, tango nkokoloko kubekaje leleno mpakungana patatu.” ");
INSERT INTO nnq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kubokapenia Yesu ngabakonya akinapunji bakwe, kingobu panankingangita pangapotola uloi na nhuku na ilatu maka pungukigwa na nikilebe chachoa? Ngabajanga, “Kileje.” ");
INSERT INTO nnq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu ngalenga, “Nambu ngoe jwajwoa juna nhuku guloi mpaka apotole, na jwajwoa jwangakola lipanga mpaka auche likoti na aemele lyene. ");
INSERT INTO nnq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Magambu nannengelanga Majandiko Gachwapi galenga, ‘Akabekigwa kikuta chimwe na akabaja,’ mpaka galenganile, magambu kila eliandikigwe kunenga nenga liba kweli.” ");
INSERT INTO nnq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Akinapunji ngabalenga, “Angwana!” Nnole pamba gabi mapanga mabena, “Jwombe ngalenga, bai!” ");
INSERT INTO nnq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ngaboka pikilambo chenie andi pulukiba lukobo lyakwe ngajenda kukitombi cha Mizeituni, akinapunji bakwe ngabankengama. ");
INSERT INTO nnq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Paika kwenio ngabalengela, “Nng'ongalele kupala makalondoigwaje.” ");
INSERT INTO nnq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kuboka penia ngabaleka ngajenda kutaali pukuoto kuleke mundu liganga, ngakilakatila ngagongalela, ");
INSERT INTO nnq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ngalenga “Awawa, andampaile kikombe chenje chukupotekigwa kimbete kutaali na nenga. Andampaile mwenga ngiti pambai neje.” ");
INSERT INTO nnq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mpakachi kuboka Kumbengu ngampitila kummeka alimbe mojo. ");
INSERT INTO nnq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kiti abi ni nu kuechuka muno, ngagongalela ku kwaja liyuke ngilimpita andi matondogolo ga myai ngagatola pae. ");
INSERT INTO nnq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kuboka pukugongalela ngabajendele akinapunji bakwe ngabakolela bagochile, gambu bakate kuechuka. ");
INSERT INTO nnq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ngabalengela, “Mbone nng'ochelanga? Nnyimukange nng'ongalele, kupala makalondoigwaje.” ");
INSERT INTO nnq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu apakiba tango akalongelaga na nkengeni gwa bandu nguika, akulongalea Yuda, jumwe jwa akinapunji bakwe. Yuda ngajenda kumpata abali Yesu kwa kunkumbatila. ");
INSERT INTO nnq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nambu Yesu ngannenge, “Yuda! Bo, munng'aluka Mwana jwa Mundu kukunkumbatila?” ");
INSERT INTO nnq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Akinapunji bakwe bala apabalola genia ngabalenga, “Angwana, tutumia mapanga gito?” ");
INSERT INTO nnq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na jumwe kati ja akinapunji ngamputa upanga mmanda jwa akung'i akolongwa, nganhweketa lichikilo lyakwe lya kalelo. ");
INSERT INTO nnq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nambu Yesu ngalenga, “Nkotoke! Bai.” Ngalikunyula lichikilo lya mundu jwenio, ngalilamia. ");
INSERT INTO nnq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Penia Yesu ngabalenge akakung'i akolongwa, akananhota ba akalenda ba nyumba ngolongwa ja Nnoongo na akananhota abaikanga kunkamula, “Bo, nhwikangite na mapanga na imbonga kumbukila kube nenga na poki? ");
INSERT INTO nnq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Panakiba na mangweto kila lichoba ku Nyumba ja Nnoongo mambukije. Nambu, chenje ngi kingobu chinu ni kinala chulubendu.” ");
INSERT INTO nnq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Penia ngabampukila, ngabantola nu kujenda nakwe ku nyumba ja Nkung'i Nkolongwa. Petulo akiba akakengama unyuma kutaali. ");
INSERT INTO nnq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mwoto bakakungana mu uwa, na Petulo akiba pamwe na abatamangite kujota mwoto gwenio. ");
INSERT INTO nnq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kingobu munkege jumwe kati ja akabanda apammona Petulo atamite penia papipi na mwoto, nga nnolokeya kipola nu kulenga, “Mundu ojo uyo akiba pamwe na Yesu!” ");
INSERT INTO nnq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nambu Petulo ngakana, ngalenga, “Mwe! Ne nummanyije.” ");
INSERT INTO nnq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kingobu kachoko, jonge mundu ngammona Petulo, ngalenga, “Mwenga mmi pamwe nabo.” Nambu Petulo ngajanga, “Mwe, neje!” ");
INSERT INTO nnq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kingobu kachoko mundu jonge ngalenga uyo, “Kweli ojo abonekana akiba pamwe nabo, aboka kukilambo cha ku Galilaya!” ");
INSERT INTO nnq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nambu Petulo ngajanga, “Angwana ne mbi kumanyaje channongela!” Na kingobucho, ogwakiba tango akalongela, nkokoloko ngabeka. ");
INSERT INTO nnq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Angwana ngabatendebuka ngabannolakeya Petulo na Petulo ngakombakela gaga gabalenga Angwana, “Lele tango nkokoloko nukubekaje mpakungana patatu kutenda ne umanyije.” ");
INSERT INTO nnq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Penia ngapita panja ngaguta muno. ");
INSERT INTO nnq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bandu abanchunga Yesu ngabamputanga nu kummeka nhwenyo. ");
INSERT INTO nnq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Angweto ngabamputanga kongo bunhwekele kumio ngabankonya, “Bamputite beneke? Nnondole!” ");
INSERT INTO nnq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na angweto ngabannongela malobe majingi ga kuntukano. ");
INSERT INTO nnq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","“Pukuchaga, akinanhota na akakung'i akolongwa na akaboli ba Malagilo ga Musa ngabakongana pamwe andi mahakimu, na Yesu ngabanneta nu kummeka nnongi ja Libalacha lyenie.” ");
INSERT INTO nnq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ngabalenga, “Mutulengele mwe Kilisto ojwapambuligwe na Nnoongo?” Yesu ngajanga, “Anda nannengile unhwaminije, ");
INSERT INTO nnq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na anda nankonyite lichwali, nnyangangaje. ");
INSERT INTO nnq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nambu kuboka ngoe Mwana jwa Mundu abakutama kingonu cha kalelo ja Nnoongo juna Makakala.” ");
INSERT INTO nnq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Angweto boa ngabalenga, “Ikonda mwe ma Mwana ba Nnoongo?” Jwombe ngajanga, “Mangweto nnengite, nenga nga jwenio.” ");
INSERT INTO nnq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Angweto ngabalenga, “Bo tupala uchaili gonge? Tubene tujoine palenga!” ");
INSERT INTO nnq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Penia nkengeni gwoa ngujema, ngugumpeleka Yesu ku Pilato, ");
INSERT INTO nnq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ngabatumbula kuntakiana bakalenga, “Tankolela mundu jonjo akaaoya bandu bito, bakanakia bandu kulepa kodi kwa Nkolongwa jwa Loma nu kukikema eti jwombe nga Kilisto Nkomboi ojwapambuligwe na Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato ngankonya Yesu, “Mwe nga Mangwana ba Akayahudi?” Yesu ngajanga, “Mwe nnengite.” ");
INSERT INTO nnq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato ngabalengela akakung'i akolongwa nankengeni gwa bandu, “Mbi kulibonaje lilemwa kwa mundu jonjo.” ");
INSERT INTO nnq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nambu angweto ngabajendekea kulenga, “Babola bandu boa ba ku Yudea babe na kijonga. Atumbula ku Galilaya na ngoe abi pamba.” ");
INSERT INTO nnq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato apajoa genia, ngakonya, “Bo, mundu jonjo jwa ku Galilaya?” ");
INSERT INTO nnq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Apamanya kube Yesu abi pae ji kinala cha Helode, ngampeleka kwa Helode, ojwakiba Kuyelusalemu kingobu chenie. ");
INSERT INTO nnq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode ngaala mwojo muno apammona Yesu, magambu ngajoa minhalo jakwe. Ahyobalela ammone Yesu akatenda ikobo. ");
INSERT INTO nnq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Penia Helode ngankonya Yesu machwali ndu, nambu Yesu ajangiteje lilobe. ");
INSERT INTO nnq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Akakung'i akolongwa na akaboli ba Malagilo ga Musa ngabapitila nnongi na ngabantakiana Yesu ngumbi ndu ngolongolo. ");
INSERT INTO nnq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helode pamwe na manjolinjoli gakwe, ngagankoya oni Yesu nu kuntendela nhwenyo, kuboka penia ngabankwindiya ngobo ja kingwana, ngabammuyanga kwa Pilato. ");
INSERT INTO nnq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Helode na Pilato, pukutumbula bakibanga na bulwa, nambu kuboka lichoba lyenie ngababe maganja. ");
INSERT INTO nnq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato ngakema ngongano ja akakung'i akolongwa na akiilongoi ba bandu, ");
INSERT INTO nnq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na ngabalengela, “Mannetangite mundu jonjo kwango malenga akiba akaoyanga bandu. Ngoe mpenakiange! Kuboka pa kuingakia kilebe chenie nnongi jinu, nammwenije na lilemwa wala limwe nhwalo gwa ngumbi yinu kwakwe. ");
INSERT INTO nnq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nambu ne tuje, ati Helode alibwenije lilemwa lyalyoa magambu ammujikie kwango. Kweli kibije kilebe chachoa echakamwile mundu jonjo cha kupaligwa kuwe. ");
INSERT INTO nnq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kuyenie, amulicha aputigwe iboko, kuboka penia nannekekea.” Majandiko gange gakwetije aya ja ");
INSERT INTO nnq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kila lichoba lya Mpapala gwa Pasaka, Pilato akiba nu lukobo lwa kunnyogolela mpungwa jumwe. ");
INSERT INTO nnq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nambu boa ngabachobela pamwe, “Akomigwe! Mannekeke Balaba kwito!” ");
INSERT INTO nnq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba akiba ajigiligwe mukipungo magambu gu kujambukia kijonga kunnyini uyo pamwe nu ukoma. ");
INSERT INTO nnq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ngapala kunnekekea Yesu, penia ngalongela nabo kabele. ");
INSERT INTO nnq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nambu angweto ngabachobela, “Mammambe munchalaba! Mammambe munchalaba!” ");
INSERT INTO nnq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato ngabalengela mala ja patatu, “Atei ubaja gani? Ne mbi kulibonaje lilemwa elyapaligwa komigwa! Namputa iboko nu kunnekekea.” ");
INSERT INTO nnq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nambu angweto ngabayangala kuchobela kanonoya, kube Yesu kupala abambigwe munchalaba, pukujomolela Pilato ngabajeketela. ");
INSERT INTO nnq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato gatenda agabapalanga gakamuligwe. ");
INSERT INTO nnq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato ngannekeke mundu ojwabampala, ojwakajigiligwa mukipungo gambu gwa kijonga na ukomi, ngankamuya Yesu kwabe bantendelange andi pabapalanga. ");
INSERT INTO nnq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Manjolinjoli apabampeleka Yesu, undela apabakiba bakajabula, ngabakongana na mundu jumwe ojwakemigwa Simoni jwa Kulene, ojwakiba akabokela kunng'onda. Ngabampukila, ngabantweka nchalaba aupotole, kunyuma ja Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nkenga nkolongwa gwa bandu ngugunkengama, kati jabe bakiba akikege abakiba bakakokaleka na kung'utila. ");
INSERT INTO nnq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu ngabagalambukila nu kulenga, “Makina mama ba Kuyelusalemu! Makang'utije nenga, nambu nng'uta kwa magambu ginu na magambu ga ingota yinu. ");
INSERT INTO nnq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Magambu machoba gatenda kuika penia bandu mabalenga, ‘Mbaya jabe akege bangabe na mwana na bangajonga ingota!’ ");
INSERT INTO nnq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kingobu chenie, bandu nga apabapakuilengela itombi, ‘Mutuponelange!’ Ni itombi ichokoichoko, ‘Tuekelelange!’ ");
INSERT INTO nnq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gambu, anda bandu batenda yene kwa nkongo mmehe, ipakubebo kwa nkongo nnyomo?” ");
INSERT INTO nnq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bakibanga bandu akabena uyo, akabaja, bakomigwe pamwe na Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Apabaikanga paali apakemigwe, “Kitongo cha Mutwe,” ngabammamba Yesu penia, pamwe na akabaja abena bala, jumwe kingonu chakwe cha kalelo na jumwe kangeja. ");
INSERT INTO nnq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu ngalenga, “Awawa malekekeyange malemwa gabe magambu bamanyije echibakamula.” Ngababagana ngobo yakwe kwa kuoma kiumbuumbu. ");
INSERT INTO nnq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bandu bakiba penia bakalolela kingobu akiilongoi ba Akayahudi apabantendela nhwenyo, “Akombwile bange, ngoe akikombole mwene, anda jwombe nga Kilisto Nkomboi, ojwapambuligwe na Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Manjolinjoli ngabantende nhwenyo uyo, ngabannyendela ngabampe siki, ");
INSERT INTO nnq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bakalenga, “Anda kweli mwe Mangwana ba Akayahudi, mikikombole mmene.” ");
INSERT INTO nnq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Panani ja nchalaba ngababeka kibao echibaandike yene, “Jonjo nga Nngwana jwa Akayahudi.” ");
INSERT INTO nnq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jumwe kati ja akabaja abakiba babambigwe panchalaba, ngantukana akalenga, “Bo, mweje nga Kilisto Nkomboi ojwapambuligwe na Nnoongo? Mikikombole mmene na twe uyo.” ");
INSERT INTO nnq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nambu mmaja jonge jola ngankalapila nnyakwe akalenga, “Mwe kunnyogopaje Nnoongo? Mwe mpatite hukumu andi ujaje. ");
INSERT INTO nnq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mwe na nenga tupaligwa kupata hukumu jenje, magambu ganga nga malepo ga agatukamwile, nambu mundu ojo akamwije kilebe kibaja.” ");
INSERT INTO nnq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Penia ngannengela Yesu, “Yesu ungombakele ne kingobu apampakujingi mu Kingwana chinu.” ");
INSERT INTO nnq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ngannyanga, “Nannenge kweli, lele mma pamwe na nenga kupepo.” ");
INSERT INTO nnq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ikiba anda saa sita ja mui, lichoba ngilileka kujaka na lubendu nguluekelela dunia joa mpaka saa tisa, ");
INSERT INTO nnq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","panjia ejikiba jibekigwe panakati ja Nyumba ja Nnoongo ngijipachuka ipande ibena kuboka kunani mpaka pae. ");
INSERT INTO nnq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu ngaguta kanonoya, “Awawa, mukuboko jinu nubeka mwojo gwango.” Apajomola kulenga genia ngajomoka. ");
INSERT INTO nnq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Penia kilongoi jwa akalenda ba Loma apalola agapitile, ngannumba Nnoongo akalenga, “Kweli ojo akiba mundu jwa mbone jwa Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bandu boa abakiba bakonganinge penia kulola kilebe chenie, apabalola genia agapitile, ngababuja kachabe bikikiputa itibi yabe kukuechuka. ");
INSERT INTO nnq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Akaganja mundu boa pamwe na akikege bala abankengima kuboka ku Galilaya, ngabajema kutaali bakalolela kilebe chenie. ");
INSERT INTO nnq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kukiba na mundu ojwakemigwa Yusufu, akiba mundu jwa mwojo gwa mbone akatenda agunhwalali Nnoongo na akiba jumwe kati ja bandu bilibalacha likolongwa li Kiyahudi, ");
INSERT INTO nnq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","jwenio ngakana kujeketela chabaamua akilongoi ajabe. Yusufu akiba aboka kukijiji chimwe cha Akayahudi echikikemigwa Alimatayo. Akiba akalendela kuika kwa Kingwana cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ngajenda kwa Pilato, ngajopa bampe mmele gwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Penia ngauluya mmele gwa Yesu kuboka munchalaba, ngaubiligila chanda cha kitani, ngaubeka mulikabuli elikiba baembite piliganga, elikiba tango lyanatumikaje. ");
INSERT INTO nnq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lichoba lyenie likiba ijumaa, nu kupanganikia kwa Lichoba lya Kupomalela. ");
INSERT INTO nnq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akikege abankengema Yesu kuboke ku Galilaya ngabankengama Yusufu na ngibilibona likabuli na mmele gwa Yesu pubekigwe. ");
INSERT INTO nnq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kuboka penia, ngababuja ukaja, ngabapanganila mauta ginakunungila nu kuupakaya mmele gwa Yesu. Lichoba lya Kupomalela ngabapomolela andi apiamuligwe na Malagilo. ");
INSERT INTO nnq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jumapili kindabindabi muno, akikege bala ngabajenda kulikabuli bapotwi mauta ginakunungila agapanganile. ");
INSERT INTO nnq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ngibilikolela libwe lela lipilimbiigwe libi pambwega ja nniango gwa likabuli. ");
INSERT INTO nnq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Apabajingila nkati, bubwenije mmele gwa Nngwana Yesu. ");
INSERT INTO nnq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Apabakibanga tango bakaomwanga ku nhwalo gwenio, kingobutu akinalome abena abakwindite ngobo ina kung'ala muno, bajemite papipi nabo. ");
INSERT INTO nnq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Akikege benia ngababeganga na mbwele, ngabalitanga. Penia bandu bala ngabakonya, “Mboni mampalanga ojwabi mmomi kati ja abawile? ");
INSERT INTO nnq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Abije pamba, ayokite. Nkombokelange agannengelanga apakiba kwako ku Galilaya, ");
INSERT INTO nnq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana jwa Mundu mpaka abekigwe kwa bandu akabaja, angweto mabammamba munchalaba na lichoba lya tatu mayoka.’ ” ");
INSERT INTO nnq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Penia akinamama benia ngabagakombokela malobe gakwe, ");
INSERT INTO nnq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ngababujanga kuboka pilikabuli, ngabapeganga achandundame bala komi na bamwe na akinapunji bange nhwalo gwa ilebe yenie yoa. ");
INSERT INTO nnq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Benia abalenga nhwalo gwenio kwa achandundame nga, Maliamu Magidalena, Yoana na Maliamu amamundu Yakobo, pamwe na akanamama bange ababakalongwana nabo. ");
INSERT INTO nnq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Achandundame ngabagatolanga malobe genia anda gambonije, nyenie baaminingije. ");
INSERT INTO nnq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nambu Petulo ngaboka, ngajabu lubelo mpaka kumambi. Apalita kulinga nkati, ngajibona chanda jika tu. Ngabuja ukaja kongo akaomwanga ku genia agapitile. ");
INSERT INTO nnq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lichoba ulyo, abele kati ja akinapunji bakwe Yesu ngababe bakajenda ku kijiji chimwe echikikemigwa Emau, kulipa kwakwe maili saba kuboka Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bakibanga bakalongelanga genia goa agapitile. ");
INSERT INTO nnq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Apabakibanga bakalongelanga na kugawachila, Yesu mwene ngapitila, ngatyanga pamwe nabo, ");
INSERT INTO nnq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ngabammona kwa mio, nambu bummanyije. ");
INSERT INTO nnq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu ngabakonyanga, “Nnongelangani kongo makajendanga?” Angweto ngabajemanga nu, kumio kwabe bakiba baechwike. ");
INSERT INTO nnq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jumwe ojwakemigwa Keleopa, ngannyanga, “Bo, mwe nga mageni jika jinu Kuyelusalemu mangamanya agapitile kwenio machoba gano?” ");
INSERT INTO nnq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Benia ngabajanga, “Nhwalo nike?” Angweto ngabannyanga, “Nhwalo ogugumpatite Yesu jwa Nazaleti,” ngabannyanga. “Mundu jonjo akiba nnondoli jwa Nnoongo juna uwecho gwa ukamula na kubola nnongi ja Nnoongo na nnongi ja bandu boa. ");
INSERT INTO nnq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Akakung'i na akiilongoi bito ngabampiya aukumigwe kuwe, ngabammamba munchalaba. ");
INSERT INTO nnq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na ngutuhyobalela kutenda jwenio mabakombola bandu ba Kuisilaeli! Genia goa, tangu gapitile lele lichoba lya tatu kuboka pa kutendigwa genia. ");
INSERT INTO nnq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bange akikege ba kachito butujitwie mwojo. Bajeilinge kulikabuli kindabi, ");
INSERT INTO nnq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nambu bubwenije mmele gwakwe. Ngababujanga ngabalenga angweto bapiti mpakachi kuboka kumbengu jwabalengi kube abi mmomi. ");
INSERT INTO nnq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bandu bito bange ngabajabu kuingikia nhwalo gwenio gubalengite akikege, nambu benia bamwenije.” ");
INSERT INTO nnq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kuboka penia Yesu ngabalengela benia, “Mbone mmi makajinga yene, na myojo jinu kujundupa ku amini ilebe yoa ibalenga akalondoli ba Nnoongo! ");
INSERT INTO nnq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Apaligweje Kilisto Nkomboi ojwapambuligwe na Nnoongo kupotekigwa, na yene ajingile mukibumo chakwe?” ");
INSERT INTO nnq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na Yesu ngabalandulila angweto Majandiko goa agannenga mwene, kutumbu kitabu cha Musa na majandiko goa ga akalondoli Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Angweto pabakibandakila kijiji chibikijendelelaga, Yesu ngajiga anda apa kukipeta kujendekea na mwanja, ");
INSERT INTO nnq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nambu benia ngaba nnyopa kulenga, “Ntame upambano natwenga lichoba litipike na lubakube lubendu.” Yenie ngajenda kupomolela na benia. ");
INSERT INTO nnq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ngatama pae kulye nabenia, ngatola nkate, ngannumba Nnoongo ngaumetula ngabapeganga. ");
INSERT INTO nnq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kingobu tu mio gabe ngagaotola kummona Yesu, nambu jwombe ngaoba paali penia. ");
INSERT INTO nnq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ngabalengelana bene kwa bene, “Bo myojo jito jijakiteje nkati jito kingobu apatulandulila Majandiko kundela kola?” ");
INSERT INTO nnq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Benia ngabajimukanga kingobucho ngababuja kukilambo cha Kuyelusalemu, kwenio ngabakolela achandundame komi na jumwe bakonganinge pamwe na bange. ");
INSERT INTO nnq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na ngabalenga, “Angwana bayokite kweli, ampiti Simoni!” ");
INSERT INTO nnq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bandu benia ngabalandulila agapitile kundela, na apabammanya Nngwana apakiba akametula nkate. ");
INSERT INTO nnq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kingobu benia akabena pabalandulila genia, Yesu mwene ngajema panakati jabe nu kulenga, “Tengela jibe kwinu.” ");
INSERT INTO nnq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Angweto ngabajituka nu kube na mbwele, bakita bilibweni lihoka. ");
INSERT INTO nnq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nambu jwombe ngalenga, “Mbone nhwechukanga? Mbone mmi na mbwele mumyojo jinu? ");
INSERT INTO nnq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nnole maboko gango na makongono gango mammanya kube nga nnenga. Umbapayange mmone, magambu lihoka likwetije mmele na iyupa andi pummonanga.” ");
INSERT INTO nnq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ngalenga genia nakalayanga benia maboko na makongono gakwe. ");
INSERT INTO nnq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pabakibanga tango bangaamini magambu ga laa jabe, na kongo bakaomwangwa, jwombe ngabakonya, “Nkweti kilebe chachoa chu kulye?” ");
INSERT INTO nnq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Benia ngabampe kipande cha chamaki ju kuteleka, ");
INSERT INTO nnq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ngatola ngalye boa ngabammona. ");
INSERT INTO nnq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Penia ngabalengela, “Chenje nga chinannengelanga tango panakiba pamwe namangweto, kila kilebe echikiandikigwe nhwalo gwango nenga, mu Malagilo ga Musa na kitabu cha akalondoli, na Zabuli kilenganile lele.” ");
INSERT INTO nnq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Penia ngabawekula mawacho gabe ibe bagamanye Majandiko Gachwapi. ");
INSERT INTO nnq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ngabalengela, “Nga apiandikwe, kube Kilisto Nkomboi mabambigwa na lichoba lya tatu mayoka kuboka kwa abawile, ");
INSERT INTO nnq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","na ku liina lyakwe nhwalo gwa kulapa mabaja na kulekekigwa malemwa mpaka oti utangachigwe mwilambo yoa, kutumbu Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mangweto nga makachaili bu nhwalo gongo. ");
INSERT INTO nnq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ne namwene manunnetela jwajo Awawa ojubalagila. Nambu munnendanga ukongo kunnyini mpaka pampakupoke makakala agaboka kunani.” ");
INSERT INTO nnq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Penia ngabalongolea panja ja nnyini mpaka ku Betania, ngatondobea maboko gakwe kunani, ngabalumika. ");
INSERT INTO nnq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Apakiba akalumika, ngabalekanga, ngatoligwa kumbengu. ");
INSERT INTO nnq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Angweto ngabanng'ongalela, penia ngababujanga Kuyelusalemu babi na laa ngolongwa, ");
INSERT INTO nnq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","mangobu goa ngabatamanga kuibanja ya Nyumba ja Nnoongo bakannumba Nnoongo.");
INSERT INTO nnq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pitumbulaga pakiba jumwe ojwakemigwa Lilobe, jwombe Lilobe akiba kwa Nnoongo, na jwombe akiba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kuboka pitumbula Lilobe akiba pamwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kwa kupetela jweno ilebe yowa ngipanganigwa, kikibaje wala chimwe chikipanganigwe panga jweno. ");
INSERT INTO nnq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jweno akiba kindumbutumbu cha bwomi, na bwomi gweno ukiba lumuli lwa bandu. ");
INSERT INTO nnq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na lumuli lweno lumulika pulubendu, nambu lubendu lweno luotwije kuluimia. ");
INSERT INTO nnq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nnoongo ngantuma mundu jumwe liina lyakwe Yohana, ");
INSERT INTO nnq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ojwaika kachalakicha bandu nhwalo gwa lumuli lweno. Aika kalenge bandu boa nhwalo gwakwe na babapakujoa baamini. ");
INSERT INTO nnq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jweno akiba lumuliloje, nambu aika kachalakicha bandu nhwalo gwa lumuli lweno. ");
INSERT INTO nnq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Londo nga lumuli lwa kweli, lumuli oluika padunia pano na kamulikila bandu boa. ");
INSERT INTO nnq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bai Lilobe akiba padunia pano. Iganu kube Nnoongo apangine dunia kupete jwenio, nambu bandu padunia bummanyije. ");
INSERT INTO nnq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ngaika kachakwe mwene, nambu bandu bakwe bampokije. ");
INSERT INTO nnq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nambu bandu baba abampokilinge, ngubunhwamini ngabape kinala chukube ingota ya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ingota eibelwike kuwecho gwa munduje ngiti kwamakakala ga mmeleje ngiti kupala kwa munduje, ila kuboke kumwene Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jwombe Lilobe ngabe mundu, ojwa tweli upeele nakweli, ngatama kwito. Natwe ngitikibona kibumo chakwe, kibumo echapata ka Awawa mundu andi Mwana jwa jika. ");
INSERT INTO nnq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana ngabachalakicha bandu minhalo ja jwenio, ngalonge kanonoya, “Jwenio nga jwanongila minhalo jakwe kulenga, ‘Aika mundu kuboka pangune nambu nkolongwa kumbeta ne, jwombe akiba ne tango nukubelekwaje.’ ” ");
INSERT INTO nnq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwa magambu ga kulimba kwakwe twe tuboa tupokile upeele nduu. ");
INSERT INTO nnq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nnoongo akatupe Malagilo kupetela kwa Musa, upeele na kweli jituikalila kwa kupetela Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Abije ngu mundu ojwammweni Nnoongo. Mwana jwa nnyika ojwabi tela na Nnoongo na ojwabi pamwe na Awawa, nga ojwatulandulila nhwalo gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Gongo ngu uchaili gwapanga Yohana, kingobu akiilongoi ba Akayahudi bu Kuyelusalemu pabatuma akakung'i na Akalawi ku Yohana bankonye kulenga, “Mwe mabeneke?” ");
INSERT INTO nnq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jwombe Yohana atindije kajanga, ngalenga kipola, “Kilisto neje.” ");
INSERT INTO nnq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Penia ngabankonya, “Bai mwe mabeneke? Bo mwe nga Maeliya?” Yohana ngajanga, “Je, ne je.” Ngabankonya, “Bo, mwenga nga Nnondoli jola?” Jwajo ojwalondoligwe kupitila na atangacha kuika kwa Kilisto. Yohana ngabajanga, “Je.” ");
INSERT INTO nnq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Angweto ngabankonya, “Bai mwe mabeneke? Bo mmene mikilenga mabeneke? Mutulengele, ibe twe takapegange majango angweto ababukingite.” ");
INSERT INTO nnq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana ngajanga, nenga nga jwajo nnondoli Isaya ojwakiba nnondoli jwa Nnoongo ojwalenga minhalo jango, kulenga, “Nenga nga lilobe lya mundu lijoanika pampongoti. Mmeke kipola ndela ja Angwana bapete!” ");
INSERT INTO nnq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bandu benia bakatumigwa na bange ba Mafalisayo, ");
INSERT INTO nnq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bai ngabankonya Yohana, “Andi mwe Kilistoje, wala Eliyaje, wala nnondolije mbona mmaticha bandu?” ");
INSERT INTO nnq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana ngabajanga, “Nenga maticha kwa mache, nambu abi jumwe ajemite panakati jinu jwangammanyanga. ");
INSERT INTO nnq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jweno atendakuika kuboka pangone nambu ne kuotoje kulita na ukulugula ngoji ya ilatu yakwe.” ");
INSERT INTO nnq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ilebe yenie itendigwa okwo ku Betania, kwie ja lukemba Yolidani apakiba akabaticha Yohana. ");
INSERT INTO nnq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Malabo jakwe Yohana ngammona Yesu akanhwikilila, ngalenga, “Ojo nga Mwana Limbelele jwa Nnoongo ojwaboya mabaja ga padunia! ");
INSERT INTO nnq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jwenio nga jwanongila minhalo jakwe kulenga, ‘Kingobu tu kuboka pango ne, abakuika mundu jumwe ojwabi nkolongwa kupeta nenga, magambu akiba tango ne nukubelekwaje.’ ");
INSERT INTO nnq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Namwene ne numanyije, nambu naicha kubaticha kwa mache ili bandu ba Kuisilaeli bumanye.” ");
INSERT INTO nnq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana ngachalakicha yene, “Nammweni Uhuke jwa Chwapi akauluka andi ngunda kuboka kumbengu nu kutola panani jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nenga nummanyije, nambu Nnoongo ojwandumite kubaticha bandu kwa mache akanenge, ‘Mundu ojumpakummona Uhuke jwa Chwapi akatola panani jakwe, jwenio nga ojwabaticha ku Uhuke jwa Chwapi.’ ” ");
INSERT INTO nnq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohana ngalenga, “Nenga noile, na njalakicha ojo nga Mwana jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Malabu jakwe, Yohana akabe penia kabele pamwe na akinapunji bakwe abele. ");
INSERT INTO nnq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Apamona Yesu akapeta, ngalenga, “Nnola! Jweno nga Mwana limbelele jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Akinapunji benia apabannyoa Yohana akalongila malobe genia, ngabankengama Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bai Yesu ngatendabuka, apababonanga akinapunji benia bakankengamaga, ngabakonyanga, “Mpalanga nike?” Bombe ngabajanga, “Labi, ntama koo?” Labi mana gakwe Aboli. ");
INSERT INTO nnq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu ngabalengela, “Tujendange, namangweto mannola.” Jakiba saa komi kimuyo, akinapunji benia ngabalongwana nakwe. Ngabapabona patama, ngabatama nakwe kimuyo choa. ");
INSERT INTO nnq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jumwe kati ja akinapunji abele bala akiba Andulea, nnung'una gwakwe Simoni Petulo. ");
INSERT INTO nnq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andulea akatumbu kunkole Simoni, nnung'una gwakwe, ngannenge, “Tumweni Masia” Masia mana gakwe Kilisto Nkomboi. ");
INSERT INTO nnq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kuboka penia ngampeleka Simoni kwa Yesu. Jwombe Yesu ngannolokea Simoni ngalenga, “Mwenga ngama Simoni mamwana ba Yohana. Nambu kuboka ngoe nkemigwa Kefa.” Kefa ku Kiyunani Petulo, mana gakwe “Libwe.” ");
INSERT INTO nnq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Malabu jakwe Yesu ngaamua kujenda ku Galilaya. Bai ngankolela Filipo ngannengela, “Ungengame.” ");
INSERT INTO nnq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo akiba jwa kilambo chuku Betisaida, kabatamanga Andulea na Petulo. ");
INSERT INTO nnq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jweno Filipo ngankolela Natanaeli, ngannenge, “Tumweni jwajo ojwaandikigwe na Musa mukitaabu cha Malagilo, ojwaba nhwandikinge akalondoli mialo jakwe, yani Yesu Mwana jwa Yusufu, mundu jwa Nazaleti.” ");
INSERT INTO nnq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jwombe Natanaeli ngankonya Filipo, “Bo, kilebe cha mbone kiwechite kuboka ku Nazaleti?” Filipo ngannengela, “Nhwike nnole.” ");
INSERT INTO nnq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu pammona Natanaeli akanhwikililaga, ngalenga mialo jwakwe, “Nnola, ojo nga Mwisilaeli pyuu wala kindondoje nkati jakwe!” ");
INSERT INTO nnq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jwombe Natanaeli ngankonya, “Mwe mmanyitabo?” Yesu ngajanga, “Pamakiba nhwina munkojo, tango Filipo nukunkemaje ne ngunummona.” ");
INSERT INTO nnq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Penia Natanaeli ngannengela, “Aboli, mwe ma Mwana jwa Nnoongo! Mwe mangwana ba Kuisilaeli.” ");
INSERT INTO nnq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ngannengela, “Bo, nhwamini magambu nannengile namweni nhwina munkojo? Mamibona ilebe ikolongwa muno kupeta yenje!” ");
INSERT INTO nnq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu ngajendekea kulenga, “Nannenge kweli, mamukubona kumbengu kukajogoka na akapakachi ba Nnoongo bakajenda kunani nu kuuluka kunani pa Mwana jwa Mundu.” ");
INSERT INTO nnq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lichoba lya tatu pakiba ngongano jukutola kukilambo cha Kana, okwo ku Galilaya. Amamundu Yesu bakiba kweno, ");
INSERT INTO nnq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","jwombe Yesu ate kokigwa penia pa mpapala gwa kutola akege pamwe na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Apajapeta divai, amamundu, ngabannenge Yesu, “Bakwetangitije divai.” ");
INSERT INTO nnq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu ngabajanga, “Amama, makanengeje chikutenda. Kingobu chango tango kuika.” ");
INSERT INTO nnq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Penia amamundu ngabalengela akapakachi, “Chachoa chela achapakunengela ntendange.” ");
INSERT INTO nnq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Akayahudi bakiba na lukobo lwa ukuya, penia pakiba na ibega chita ya mabwe, kila kibega chimwe kijingi madebe mabele au matatu ga mache gukuya. ");
INSERT INTO nnq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu ngabalengela, “Ntweleyange mache mweno muibega.” Ngabatweleya twe mpaka kunani. ");
INSERT INTO nnq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kubokapenia ngabalengela, “Ngoe ntekange mapelekele akilongochi ba mpapala.” Ngabatekanga mache gala, ");
INSERT INTO nnq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Akilongoi ba mpapala apabapaya mache gala, ngaba manya genia gayokite divai, Bombe bamanyije divai jene jibokitako, nambu akapakachi bala bamanyangite jibokitako. Akilongoi ba mpapala ngabakema bene akola mpapala, ");
INSERT INTO nnq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Akilongoi ba mpapala ngabalengela, “Kila mundu kutumbula kupangania oti divai jambone, kubokapenia anda batochike kupanga divai jambone. Nambu mwe mpangite divai jambone mpaka ngoe!” ");
INSERT INTO nnq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu alaya iingi yi ikobo yu kutumbula okwo kukilambo cha Kana, Ku Galilaya, ngalaya kibumo chakwe, na akinapunji bakwe ngabanhwamini. ");
INSERT INTO nnq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kubokapenia, Yesu pamwe na amamundu na inuna yakwe na akinapunji bakwe, ngabajendanga kukilambo chuku Kafalanaumu ngabatamanga paali penia kwa machoba machoko tu. ");
INSERT INTO nnq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mpapala gwa Pasaka ja Akayahudi jikiba jibandakile, yene Yesu ngajenda Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bai ngabakolelanga unyumba jenie bandu bakaucha ng'ombe, mambelele, na ngunda, na bandu abajangangana uloi bakiba batamite pamecha jabe. ");
INSERT INTO nnq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ngatengenecha iboko ya ngoji, ngabenga boa panja ja Nyumba ja Nnoongo pamwe na ng'ombe na mambelele gabe ngaambugana salafu ya abajangangina ela ngapendangula mecha yabe. ");
INSERT INTO nnq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ngabaamulicha baba abauchangita ngunda, “Mmoyange ilebe eye pamba. Makajitendaje nyumba ja Awawa bango kube choko!” ");
INSERT INTO nnq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Akinapunji bakwe ngabakombakela Majandiko Machwapi galenga, “Kupala kwango kwa nyumba jinu ungoma.” ");
INSERT INTO nnq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Akayahudi bange ngabankonya Yesu, “Nnaya kiingi nike chi ikobo kutenda nkweti uwecho gu ilebe yenie?” ");
INSERT INTO nnq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ngabajanga, “Mmomole nyumba eje ja Nnoongo ne manjenga kwa machoba matatu.” ");
INSERT INTO nnq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Penia Akayahudi ngabalenga, “Nyumba ja Nnoongo eje jichengigwa kwa kingobu cha yaka alubaini na chita. Bo, mwe mpakuchenga kwa kingobu cha machoba matatu?” ");
INSERT INTO nnq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nambu Yesu alongela nhwalo gwa nyumba ja Nnoongo, jene ukiba mmele gwakwe. ");
INSERT INTO nnq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bai pubunhyoya, akinapunji bakwe ngabakombokela akiba alongela genia, ngabaaminianga Majandiko Machwapi na malobe gaga galongela Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu apakiba kukilambo cha Kuyelusalemu kumpapala gwa Pasaka, bandu akajingi ngubunhwamini pibibona iingi yi ikobo eyatendaga. ");
INSERT INTO nnq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nambu Yesu akibaje na imani nabo magambu bamanyi boa. ");
INSERT INTO nnq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Penia apaije mundu jwajoa kunchalakicha minhalo ja bandu benia magambu mwene agamanyi goa agabi umojo jabe. ");
INSERT INTO nnq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pakiba na kilongoi jumwe Nhyahudi, jwa kikundi cha Mafalisayo, liina lyakwe Nikodemo. ");
INSERT INTO nnq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lichoba limwe kilo Nikodemo ngannyendelela Yesu nu kunnengela, “Aboli, tumanyi mwenga maboli mantumigwe na Nnoongo. Abije mundu ojwaotwi kulaya iingi yi ikobo eintenda mwe pangabe Nnoongo kube pamwe nakwe.” ");
INSERT INTO nnq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ngannyanga, “Nannenge kweli, abije mundu ojwa pakukibona Kingwana cha Nnoongo pangabelekwa kabele.” ");
INSERT INTO nnq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo ngankonya, “Mundu munaota kuotolabo kubelekwa kabele? Kuotoje kujingila mulutumbo lwa amamundu nukubelekwa kabele!” ");
INSERT INTO nnq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ngannyanga, “Nannenge kweli, abije mundu ojwapakujingi Mukingwana cha Nnoongo nukubelekwaje kwa mache na Uhuke ba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mundu kubelekwa kwa mmele ka awawa na ka mama, nambu kubelekwa kiuke kwa Uhuke ba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Makaomwangaje magambu nannengile mpaka mmelekwe oti kabele. ");
INSERT INTO nnq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Upepo kuuma ukujenda okupala, nnyoa lilobe lyakwe, nambu mmanyije okuuboka wala okujenda. Nga ibi kwa mundu ojwabelekwa kwa Uhuke ba Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ngankonya, “Ile yenje kuotwabo?” ");
INSERT INTO nnq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ngajanga, “Bo, mwenga nga aboli ba Isilaeli na mmanyije ile yenje? ");
INSERT INTO nnq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nannenge kweli, twe tulenga eituibweni na kachalakicha bandu ilebe itibweni, nambu mangweto kujeketeje nhwalo gwito. ");
INSERT INTO nnq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kunhwaminije ne mangobu apanannengile mialo ja padunia pano, mpakunhwaminibo nenga, apambakunnenge ilebe ya kumbengu? ");
INSERT INTO nnq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na abije mundu ojwaakajenda kumbengu ila Mwana jwa Mundu, aulwike padunia kuboka kumbengu.” ");
INSERT INTO nnq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Anda Musa palijinula lijoka lya liyaba kwako kupongoti, unyae Mwana jwa Mundu mpaka ajinuligwe. ");
INSERT INTO nnq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Na kila mundu ojwanhwamini jwombe maba na bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Magambu Nnoongo atekupapala padunia pano muno ata ngammoya Mwana jwakwe jwajika, ibe kila mundu ojwapakunhwamini akaweje nambu apate bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Magambu Nnoongo antumitije Mwana padunia pano kahukumu bandu, nambu kakombolanga. ");
INSERT INTO nnq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Bena abanhwamini Mwana kuhukumuligwaje, nambu benabo banganhwamini bai bahukumuligwe, magambu bunhwaminije Mwana jwa jika jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jenje nga namuna ja hukumu ejipakube, Lumuli luike padunia, nambu bandu bapala lubendu kuliko lumuli, gambu mialo jabe mibaja. ");
INSERT INTO nnq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila mundu ojwatenda gamboneje aluchimwa lumuli, nu kuikaje pulumuli, magambu kupalaje mialo jabe mibaja jibonekane. ");
INSERT INTO nnq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nambu junakujali ukweli aika pulumuli, ili mialo jakwe ibonekane itendigwa kwa kunyali Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kuboka kwa gena, Yesu na akinapunji bakwe ngabaika pikilambo cha Yudea, ngatama kweno pamwe nabo kwa mangobu ngabaticha bandu. ");
INSERT INTO nnq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana uyo akiba akabaticha bandu kweno Kuainoni, papipi na Kusalemu, magambu kweno kwakiba na mache ndu. Bandu ngabannyendelela, jwombe ngababatichanga. ");
INSERT INTO nnq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mangobu gena Yohana akiba tango anajigiligwaje kukipungo. ");
INSERT INTO nnq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mitau ngijipitila kati ja akinapunji bange ba Yohana na Nhyahudi jumwe kuuchu lukobo lwabe lukuya. ");
INSERT INTO nnq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bai akinapunji benia ngabannyendela Yohana nukunnengela, “Aboli, mundu jola ojwakiba pamwe na mwenga kwiye ja lukemba Yolidani, mwenga ngumunchalakicha, ngoe jweno atenda kubaticha, na bandu boa bannyendelela!” ");
INSERT INTO nnq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana ngabajanga, “Mundu aotwije kube na kilebe mpaka ibe kuboka ku mbengu. ");
INSERT INTO nnq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na mmenimangweto nhwotolinge kuchalakicha kutenda nganenga, ‘Nenga Kilistoje, nambu ndumigwe ili nanongalele Kilisto!’ ");
INSERT INTO nnq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Munkege jwatoligwe nkola jwatoile, nambu aganja ba jwatoile ojwajema nukupenikia, kuala mojo muno apabanyoa jwatoile akalenga. Nga laa jango apijikamilika. ");
INSERT INTO nnq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mpaka jweno akoliigwe, na nenga nakakoliigwaje.” ");
INSERT INTO nnq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ojwaika kuboka kunani kumbingu nga anaota kuliko boa, ojwaboka padunia nga jwa padunia, na kalengela ile ya pakilambo. Nambu ojwaika kuboka kumbingu nga anaota kuliko boa. ");
INSERT INTO nnq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jweno agagabweni nu kugajoa nga agachalakicha, nambu abije mundu ojwajeketela nhwalo gwakwe. ");
INSERT INTO nnq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nambu mundu jwajote ojwajeketela nhwalo gwakwe achalakicha Nnoongo nga kweli. ");
INSERT INTO nnq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mwana ojwatumigwe kulongela malobe ga Nnoongo, jweno Nnoongo ampi Uhuke jwakwe changapemeka. ");
INSERT INTO nnq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Awawa bampala mwana na bampile ilebe yoa. ");
INSERT INTO nnq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ojwanhwamini Mwana akweti bwomi gwa machoba goa pangapela, jwangannyali Mwana aibeje na bwomi gwa machoba goa pangapela, nambu kuchimwa kwa Nnoongo kuba kunani jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo ngabajoa Yesu akapata akinapunji ajingi na kabaticha kuliko Yohana. ");
INSERT INTO nnq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nambu ukweli, Yesu akibaje kabaticha bandu ila akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bai Yesu apajoa genia, ngaboka Kuyudea nukubuja Ku Galilaya. ");
INSERT INTO nnq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mumwanja gweno apaligwe kupetela Kusamalia. ");
INSERT INTO nnq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bai ngaika kukilambo chuku Sikali, kilambo chimwe cha ku Samalia, papipi na nng'onda gwa Yakobo gweno oguampile Mwana jwakwe Yusufu. ");
INSERT INTO nnq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Paali penia pakiba na liliba lya Yakobo, jwombe Yesu gambu ja kutotokela kwa mwanja, ngatama umbwega ja liliba. Ikiba nalumu. ");
INSERT INTO nnq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bai munkege jumwe jwa Samalia ngaika kuteka mache, Yesu ngannengela, “Umbe mache nywe.” ");
INSERT INTO nnq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mangobu gena akinapunji bakwe bakiba bajabulinge kunnyini kuemela ilyo. ");
INSERT INTO nnq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nambu munkege jweno ngannyanga Yesu, “Mwenga Mayahudi, nenga nakege ba Kusamalia! Nhwotobo kunyopa maache?” Akayahudi bakiba kujaikanaje ikombe na yani na Akasamalia. ");
INSERT INTO nnq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu nganyanga, “Anda makamanyi kilebe echapanga Nnoongo, nga mene ojwannyopa mache, kabi mannyopite, najweno kabi ampile mache agaleta bwomi.” ");
INSERT INTO nnq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Amama benia ngabalenga, “Angwana nkwetije lindobo lya kutekela mache na liliba linyolike. Mampatako mache gina bwomi? ");
INSERT INTO nnq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Au mwenga mikitenda mananhota muno kapeta awabito Yakobo? Benia ngubutupe liliba lende, na benia bene, ingota yakwe na ilangwa yakwe ngabanywe mache ga liliba lende.” ");
INSERT INTO nnq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ngajanga, “Kila ojwanywe mache ganga maba na nyota kabele. ");
INSERT INTO nnq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nambu abapakunywe mache agambakape neenga, abe kabeje na nyota mache agambakape magaba nkati jakwe chembwe cha mache ga bwomi nu kumpe bwomi gwa machoba goa pangapela.” ");
INSERT INTO nnq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Amama benia ngabannengela, “Angwana, umbe nenga mache genia ili nakabeje na nyota kabele, na nakaikaje kabele pamba kuteka mache.” ");
INSERT INTO nnq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu ngannengela, “Nnyabule makakeme angwanabinu, nhwike pamwe nabo.” ");
INSERT INTO nnq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Munkege jwenio ngannengela, “Ne ngwetije analome.” Yesu ngannengela, “Nnengite kweli nkwetije analome. ");
INSERT INTO nnq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Maana mmi na akinalome anhwano, na bena bantamanabo ngoe angwanabinuje. Penia nnengite kweli.” ");
INSERT INTO nnq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Munkege jwenio ngabalenge, “Angwana, nammona mwe iotwi kube malondoli. ");
INSERT INTO nnq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Akaoko bito bagongalela pikitombi uchenje, nambu Makayahudi paali pinu pukung'ongale Nnoongo nnenga Kuyelusalemu.” ");
INSERT INTO nnq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu ngannengela, “jwenio, nhwamini ne, kingobu kitendakuika penia abagongole Awawa bagongalela pikitombi panoje, nu Kuyelusalemuje. ");
INSERT INTO nnq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Makasamalia mang'ongolela nnoongo jwangammanya, nambu Takayaudi tummanyi ojotung'ongolela, gambu ukomboi uboka kaka Yahudi. ");
INSERT INTO nnq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nambu kingobu kitenda kuika, iba abagongole kwa kweli bagongalela Awawa kuhuke jwa kweli. Gambu Awawa bapala bandu abagongale yenie. Nnoongo ngu uhuke na abagongalela bapaligwa kugongalela kuhuke na kweli. ");
INSERT INTO nnq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nnoongo ngu Uhuke, na bandu abagongalela bapaligwa kugongale kuhuke na kweli.” ");
INSERT INTO nnq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Munkege jwenio ngannenge, “Manyi Masia, jwakonda Kilisto atendakuika, na papakuika jwenio matulengela ilebe yoa.” ");
INSERT INTO nnq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu ngannengela, “Nenga nanonge na mwenga ngajweno.” ");
INSERT INTO nnq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Penia akinapunji bakwe ngababuja, ngabaomongwa kummona akalongela numunkege. Nambu akibaje mundu ojwankonyite munkege, kutenda, “Mpala nike pamba?” Wala Yesu bankonyiteje kulenga, “Mbone nnonge numunkege?” ");
INSERT INTO nnq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Munkege jwenio ngakileka kiulo chakwe ngajenda kunyini kalenge bandu, ");
INSERT INTO nnq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ngajemba chamila kulenga “Nhwikange mmoa makammone mundu ojwanengi ile yango yoa eindendite! Bo, jwenio aotwi kube Kilisto?” ");
INSERT INTO nnq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bandu ngababoka kunyini, ngabannyendele Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kingobucho akinapunji bakwe ngabannenge Yesu kulenga, “Aboli, nnieoti chakulya!” ");
INSERT INTO nnq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nambu Yesu ngabalenge, “Ne ngweti chakulya changikimanya mangweto.” ");
INSERT INTO nnq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Akinapunji bakwe ngabakonyana, “Bo, abimundu ojubaleti chakulya?” ");
INSERT INTO nnq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu ngabalenge, “Chakulya chango, kugakamwa gabapala abatuite nyomole maengo gabe. ");
INSERT INTO nnq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mangweto nnengalenga, ‘jiigi myei nchechetu mauno magaika!’ Nambu ne nannenge, nnolanga migonda jibi tayali kuunigwa! ");
INSERT INTO nnq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nhwuni mapata lipungu lyakwe, na akongo mauno ga bwomi gwa machoba goa pangapela, iba mpandi na nhwuni baalala mojo pamwe. ");
INSERT INTO nnq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kilonge chenje chakweli jonge kupanda na jonge kuuna. ");
INSERT INTO nnq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nenga nantumangite makaunange ilyo yangapiyanga liyuke. Bandu bange bakamwi liengo, nambu mangweto mukikonjanga kuboke muliuke lyaabe.” ");
INSERT INTO nnq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Akasamalia ajingi bi kijiji chenie ngubunhwamini Yesu magambu ga malobe gachalakicha munkege jwenio, kukulenga, “Annengi itendwa yoa eindendite.” ");
INSERT INTO nnq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Akasamalia ngabannyendele Yesu ngabanyopa atame nabo, na jwenio ngatama penia machoba mabele. ");
INSERT INTO nnq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bandu ajingi muno ngabaamini magambu ga nhwalo gwakwe. ");
INSERT INTO nnq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ngabalenge amama benia, “Twenga tuamini magambo ga lilobe linutuje, twetubene tujoine, na tumanyi jwenio nga kweli Nkomboi jwa dunia.” ");
INSERT INTO nnq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kuboka pa machoba mabele Yesu ngaboka penia, ngajenda kukilambo cha Ku Galilaya. ");
INSERT INTO nnq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu mwene ngachalakicha kulenga, “Nnondoli kupataje ichima kukilambo chakwe mwene, nambu kuyenge ilaambo kupata ichima.” ");
INSERT INTO nnq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bai paika kukilambo cha Ku Galilaya, Akagalilaya ajingi ngabampokela. Magambu angweto uyo bakibanga kumpapala gwa Pasaka, ngibibona ikobo yowa yatenda Kuyelusalemu kingobu cha kusikukuu jenie. ");
INSERT INTO nnq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu ngaika kabele kukilambo cha Kana, kunkoa gwa Ku Galilaya, paali pa galambuya maache kube divai. Penia kilongoi jumwe jwa chilikali akiba na mwana ntamwe okwo ku Kafalanaumu. ");
INSERT INTO nnq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bai jweno ofisa apajoa Yesu akiba abokite Kuyudea nukujenda Ku Galilaya, ngannyendela nukunyopa ajende kunnamia mwana jwakwe ojwabi ntamwe lola. ");
INSERT INTO nnq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu ngannengela, “Pangibona iingi yi ikobo nu gukuomongwa miaminije!” ");
INSERT INTO nnq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kilongoi jweno ngabalengela, “Angwana, chonde tujende tango manango nukujomokaje.” ");
INSERT INTO nnq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu ngannengela, “Nyabulage, mwanajwinu malama!” Mundu jweno ngaamini malobe ga Yesu, ngajabula. ");
INSERT INTO nnq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Apakiba undela, ngakongana na akabanda bakwe, ngabannengela, “Mwana jwinu alamite!” ");
INSERT INTO nnq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jwombe ngabakonya mangobugani mwana apalama, ngabajanga, “Licho saa saba mui, kitamwe ngikinneka.” ");
INSERT INTO nnq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Awawa bena ngabakombokela ikiba kingobu ucho Yesu apalenga, “Mwana jwinu malama.” Penia bena ngabaamini pamwe na akalongamundu boa. ");
INSERT INTO nnq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yenie yakiba iingi yi ikobo ya pabele yatenda Yesu apakiba akaboka Kuyudea kujenda Kugalilaya. ");
INSERT INTO nnq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kuboka pa genia, Yesu ngajenda Kuyelusalemu kukiba na mpapala gwa Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kweno Kuyelusalemu, papipi na nniango ogukemigwa nniango gwa limbelele, pakiba na lilaba lya mache elikemigwa kwa Akaebulania Bethzatha, lyene lyakiba na nganya nhwano. ");
INSERT INTO nnq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Munganya mweno mwakiba na akatamwe ajingi bagolokinge, bangalola na nangwaba na babapolite. Bakiba bagalendela mache gatimbunike, ");
INSERT INTO nnq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","magambu kila kingobu Akapachi ba Nnoongo kuboka kumbengu batela kuika nukujingi umache nukutimbugana. Mundu jwajwoa ojwakiba jukutumbula kujingi umache kuboka pa mache kutimbunika ngalama kitamwe chachotichela echabinacho. ");
INSERT INTO nnq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pena pakiba na mundu jumwe ojwakiba ntamwe kwa mangobu ga yaka makomi matatu na nane. ");
INSERT INTO nnq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu apammona mundu jweno agolwike pena ngamanya akiba ntamwe kwa machoba majingi, ngankonya, “Bo, mpala kulama?” ");
INSERT INTO nnq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ntamwe jola ngajanga, “Angwana, nenga ngwetije mundu jwa kumbeleka kumache mangobu apagatimbunika. Kila apanyiga kujingila, mundu jonge kumbengelela.” ");
INSERT INTO nnq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu ngannengela, “Nyinuke, ntole likai linu nnyabule.” ");
INSERT INTO nnq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kingobu tu mundu jweno ngalama, ngatola likai lyakwe ngajabula. Nhwalo gwenio utendigwa lichoba lya kupomalela, ");
INSERT INTO nnq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","nyenie akiilongoi ba Akayahudi ngabannengela mundu jwenio ojwalamiigwe, “Leleno nga lichoba lya kupomalela, kwa Malagilo gito chwapije kutola likai linu.” ");
INSERT INTO nnq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jwombe ngabajanga, “Mundu ojwanamie ne nga jweno jwanengila ntole likai linu nnyabule.” ");
INSERT INTO nnq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bombe ngabankonya, “Bene abannengi ntendi ganga?” ");
INSERT INTO nnq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nambu mundu jweno ojwalamiigwe ammanyije mundu jweno ojwa nnamie, maana Yesu akiba abokite paali penia, pakiba na bandu ajingi. ");
INSERT INTO nnq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kubokapenia, Yesu ngankolela jweno ojwa lamiigwe munyumba ja Nnoongo, nukunnengela, “Nnyoe, ngoe nnamite. Makatenda mabaja kabeje, manhwika kupatikana na chenge kilebe kibaja muno.” ");
INSERT INTO nnq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mundu jweno ngajenda, ngabalengela achi ilongochi ba Akayahudi kutenda Yesu nga ojwanamie. ");
INSERT INTO nnq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Magambu Yesu atenda kilebe chene lichoba lya Kupomalela, Akayahudi ngabatumbu kumpalapala. ");
INSERT INTO nnq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu ngabajanga, “Awawa bango bakamumaengo machoba goa, nane uyo ngamu maengo.” ");
INSERT INTO nnq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Malobe ganga ngagatenda akiilongoi ba Akayahudi ngabapala ndela ja kunkoma Yesu. Bapalanga kunkoma magambu ga kualabia Malagilo ga lichoba lya Kupomolela tuje, ila magambu uyo akalenga kutenda Nnoongo nga Awamundu, na yenie ngakitenda tela na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu ngabajanga, “Nanenge kweli, Mwana kutendaje kilebe jikajakwe, aotwi kutenda chachetu chababona Awamundu bakatenda. Mana chache chabatenda Awawa na mwana uyo kutenda. ");
INSERT INTO nnq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Awawa kumpala mwana, nukunaya kila kilebe chabatenda bene. Mabannangila ilebe ikolongwa kupeta yenje, namangweto mpakuomongwa. ");
INSERT INTO nnq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Andi yene Awawa kayoya abawile na kapeganga bwomi, uyo na Mwana kape bwomi baba abapaile. ");
INSERT INTO nnq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Awawa kuhukumulaje mundu jwajoa jola. Maengo goa ga hukumu bankamwie mwana, ");
INSERT INTO nnq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","na yene kupala bandu boa bannyali Mwana andi pabajali Awawa. Bangankolea Mwana kakoleaje Awawa abantumite. ");
INSERT INTO nnq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nannengelanga kweli, ojwajoa lilobe lyango, nukunhwamini jwajo ojwandumite, akweti bwomi gwa machoba goa pangapela. Ahukumigwaje, nambu apetite kuboka mukiu nukujingi mubwomi. ");
INSERT INTO nnq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nannengelanga kweli, kingobu kitenda kuika, na kabe kiike, penia abawile mabajoa lilobe lya Mwana jwa Nnoongo, nabenia abapakujoa, mabalama. ");
INSERT INTO nnq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Andi yene Awawa apababi kindumbutumbu cha bwomi, uyo pabampi kitoi Mwanagwabe kube kindumbutumbu cha bwomi. ");
INSERT INTO nnq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kabe bampi kinala chaka hukumu, kumagambu jwenio Mwana jwa Mundu. ");
INSERT INTO nnq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Makaomongwaje kilebe chenje. Kingobu kitenda kuika penia boa abawile mabajoa lilobe lyakwe, ");
INSERT INTO nnq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na benia mabayoka, angweto abatendangite gambone bayoka nu kulama, na baba abatendangite mabaja mabayoka nu kuhukumigwa. ");
INSERT INTO nnq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ne kuotoje kutenda kilebe kuuwecho gwango namwene. Ne hukumula andi panyoa kuboka ka Awawa, na hukumu jango nga jakweli. Magambu mbala kutenda pambala namweneje, ila apabapala baba abandumite. ");
INSERT INTO nnq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Andi nikichalakicha na mwene, uchalakichi gwango ujeketiligwaje kube gwa kweli. ");
INSERT INTO nnq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nambu abi jonge ojwa njalakicha ne, ne manyi kutenda goa agalongela mialo jango ne nga ja kweli. ");
INSERT INTO nnq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mangweto ngantuma nhwalo kwa Yohana, na jweno ngauchalakicha ukweli. ");
INSERT INTO nnq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngati ne nhyobale kuchalakicha kwa bandu tuje, nambu nenga ikobo yenje ili mpatange ukomboligwa. ");
INSERT INTO nnq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana akiba anda lumuli, olujaka nu kung'ala, mangweto makibanga tayali kualalila kung'ala kweno kwa kingobu tu. ");
INSERT INTO nnq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nambu ne ngweti kuchalakicha kwango kukolongwa muno kuliko ogwapia Yohana. Kwamaana maengo aganagatenda, maengo agabambile Awawa nagatende, nga aganjalakicha kutenda Awawa nga abantumite. ");
INSERT INTO nnq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Awawa benabo abantumite banjalakicha. Mangweto mpatangitije kujoa lilobe lyabe, wala kukubona kumio kwabe, ");
INSERT INTO nnq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nu nhwalo gwabe kutamaje mumyojo jinu maana munhwaminingije ojwa bantumite. ");
INSERT INTO nnq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mangweto nhwingikia Majandiko Machwapi, nkitangita kutenda nkatijabe mampatanga bwomi gwa machoba goa pangapela. Na Majandiko ugogo aganjalakicha! ");
INSERT INTO nnq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Uyo, namangwetumwe mpailingije kuika kwangune mpatange bwomi. ");
INSERT INTO nnq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ne mbaije kupata kibumo kuboka ku bandu. ");
INSERT INTO nnq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nambu mangwetumwe numanyi, mangweto kupalaje Nnoongo mumyojuje. ");
INSERT INTO nnq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne nhike kwa amuli ja Awawa bango, nambu mangweto kumbokelangaje. Jonge mundu anda aike kwa amuli jakwe mwene, mamumpokela. ");
INSERT INTO nnq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nhwotolangabo kuamini, na kongo mangweto mpalanga kupokelanga kibumo kuboka kwinu mmeni mangweto, wala mmikupalangaje chiipa kuboka kwabe bena ababi jika jabe Nnoongo. Lele nhwaminabo nenga? ");
INSERT INTO nnq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Makakita ne manantakiana kwa Awawa. Musa jwombe mangweto mannhyobalela nga ojwa pa kuntakiana. ");
INSERT INTO nnq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ikabi kweli munhwamini Musa, kabi nhwamininge na ne uyo, magambu Musa aandika minhalo jangone. ");
INSERT INTO nnq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nambu magaaminingije gaga agaandike, miaminiangabo echi nikilongela?” ");
INSERT INTO nnq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kuboka pa gena, Yesu ngajomboka lilaba Galilaya andaje lilaba Tibelia. ");
INSERT INTO nnq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nkenga nkolongwa gwa bandu ngugunkengama, kwa magambu bandu bena bakate kibona iingi yi ikobo eyatenda kalamianga akatamwe. ");
INSERT INTO nnq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu ngaombe pikitombi, ngatama pamwe na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mpapala gwa Akayahudi ejikemigwa Pasaka jakiba jiegalile. ");
INSERT INTO nnq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bai Yesu apalola nukubona nkengeni gwa bandu apuika kwabe, ngankonya Filipo, “Tuemekoo chakulya ili bandu bamba bapatange kulyee?” ");
INSERT INTO nnq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Alenga nyenie kukunnyiga Filipo, gambu amaanyi mwene elya pakutenda. ");
INSERT INTO nnq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo ngannyanga, “Mikate ja ela denali mya mbili jatochangaje bandu bamba ata anda kila mundu jumwe aipata kipande kichokutu!” ");
INSERT INTO nnq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jumwe jwa akinapunji bakwe ojwa kemigwa Andulea, nnung'una Simoni Petulo, ngannengela, ");
INSERT INTO nnq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Abile pamba mwana jumwe ojwabi na mikate nhwano na yamaki ibele. Nambu yene itocha nike kwa bandu ajingi anda bamba?” ");
INSERT INTO nnq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu ngabalengela, “Matamikange bandu.” Pakiba na manyai nduu paali pena. Bai bandu ngabatamanga, bakibanga akina lome elufu nhwano. ");
INSERT INTO nnq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu ngajitola mikate jenie, ngannumba Nnoongo, ngababaganikia bandu abakiba batamangite. Ngatenda uyo na yamakiye, kila mundu ngapata apapaile. ");
INSERT INTO nnq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bandu apabajukuta Yesu ngabalengela akinapunji bakwe, “Nkongolange imbolopolo eiigile yakaobaje.” ");
INSERT INTO nnq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bai ngabakongolanga imbolopolo ya mikate eibaigiinge bandu bala abalilangita, ngabatweleyanga ikapo komi na ibena. ");
INSERT INTO nnq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bandu apabibona iingi yi ikobo yene yakatenda Yesu, ngabalenga, “Kweli jonjo nga Nnondoli ojwaika kudunia.” ");
INSERT INTO nnq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu ngamanya bandu bapalanga kuntola abe nngwana, ngaboka kabele, ngajenda kukitombi jika jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Apiikiba kimuyo akinapunji bakwe ngabaelela mpaka kulilaba, ");
INSERT INTO nnq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","lubendu lukiba lutandite na Yesu akiba tango anaikaje ngabaombela ntumbwi bajomboke kujenda ku Kafalanaumu. ");
INSERT INTO nnq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kingobu tu upepo nkolongwa ngutumbu kuguguma nu kutimbugana mache. ");
INSERT INTO nnq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Akinapunji apabakiba bajendangite kwa maili nhwano au sita, ngaba mmona Yesu akajenda panani ja mache, apaubandakila ntumbwi, ngabajogopanga muno. ");
INSERT INTO nnq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu ngabalengela, “Nga nenga, makajogopangaje!” ");
INSERT INTO nnq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bai ngabapala kuntola Yesu muntumbwi, na mangobu ugo ntumbwi nguika kujomo pabakiba bakajendanga. ");
INSERT INTO nnq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Malabu jakwe nkengeni gwa bandu guigi kwiye ngabamanya pakiba na ntumbwi gumwe tu penia, na Yesu ajingije muntumbwi pamwe na akinapunji bakwe, ila akinapunji bena bakibanga bajendangita jika jabe. ");
INSERT INTO nnq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mitumbwi jenge kuboka Tibelia ngijiika paali pena pabalya mikate bandu Angwana pabajomola kunnumba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bai bandu bena apabamanya Yesu na akinapunji bakwe bakibangaje paali pena, ngabaombela ntumbwi, ngabajabula kukafalanaumu kunkengama Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bandu bena apabankolela Yesu upandi gonge gwa lilaba ngabankonya, “Aboli, nhwikila like pamba?” ");
INSERT INTO nnq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu ngabajanga, “Kweli nannengelanga, umbalanga kwa magambu nnilangite mikate ngannyukuta, ngiti gambu mibweni iingi yi ikobo yangoje. ");
INSERT INTO nnq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mukikibegelelaje chakulya chikialabika, mikibegelele chakulya chikilama cha bwomi gwa machoba goa pangapela. Mwana jwa Mundu ojwapambuligwe na Nnoongo, Awawa ampaganga chakulya chene.” ");
INSERT INTO nnq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Benia ngabankonya, “Tutendi nike kwa gaga gapala Nnoongo?” ");
INSERT INTO nnq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ngabajanga, “Lende nga liengo elyapala Nnoongo, kunhwamini ojwantumite.” ");
INSERT INTO nnq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngabannengela, “Mpakutenda ikobo nike kupala tibone tunhwamini? Mpakutenda nike? ");
INSERT INTO nnq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Akaoko bito ngabalye chakulya echikikemigwa manna kweno kupongoti, anda apagalenga Majandiko Machwapi, ‘Ngabape kulyee nkate kuuluka kumbengu.’ ” ");
INSERT INTO nnq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu ngabalengela, “Nannengela kweli, Musa ampilingitije nkate kuuluka kumbingu. Awawa bango nga abampe mangweto nkate gwa kweli kuboka kumbengu. ");
INSERT INTO nnq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Maana nkate gwa Nnoongo nga jwajo ojwauluka kuboka kumbengu nga ojwaupe bwomi kwa bandu pa dunia.” ");
INSERT INTO nnq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ngabannyopa, “Angwana, mutupe nkate gweno machoba goa.” ");
INSERT INTO nnq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu ngabalengela, “Nenga nga chakulya echichimpe bwomi. Ojwaika kwango ne abeje na njala, ojwaamini abeje na nyota ngu. ");
INSERT INTO nnq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lele, nannengelinge nng'anwa umonangite nambu nhwaminije. ");
INSERT INTO nnq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Boa abambi Awawa mabaika kwango ne. Nane ninekeje panja mundu jwajoa ojwaika kwangone, ");
INSERT INTO nnq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nhike kuboka kumbengu ngati magambu ga ukamu ilebe yangoje, ila kulenganakia pabapala Awawa abandumite. ");
INSERT INTO nnq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na apabapala abo abandumite nga ganga, nakanhwoyaje ata jumwe kati baba abambile, ila kapeganga boa bwomi gwangapela maninnyoya mulichoba lya mwicho. ");
INSERT INTO nnq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maana Awawa bango nga echibapala kila ojubammona Mwana nukunhwamini abe na bwomi gwa machoba goa pangapela, nane maninnyoya mulichoba lyu kujomolela.” ");
INSERT INTO nnq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bai Akayahudi ngabatumbu ukokaleka Yesu magambu alengite, “Ne nga nkate oguulwike kuboka kumbengu.” ");
INSERT INTO nnq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ngabalenga, “Bo, ojo Yesu mwana jwa Yusufuje? Tamanyi awamundu na amamundu. Bai aotobo kulongela aulwike kuboka kumbengu?” ");
INSERT INTO nnq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu ngabalengela, “Nkotokange ukokaleka mangweto jika. ");
INSERT INTO nnq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Abije mundu ojwaotola kuika kwangone panga Awawa abandumite kunhwuta kuika kwangone, nane manunhyoya mundu jwenio lichoba lya mwicho. ");
INSERT INTO nnq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Akalondoli baandikinge, ‘Bandu boa mababoligwa na Nnoongo.’ Mundu jwajoa ojwabajoine Awawa na kukibola kuboka kwabe kuika kwango ne. ");
INSERT INTO nnq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Echinenga nga chenje, abije mundu oju babweni Awawa, ila jwajo ojwabokite kwa Nnoongo, jwenio nga ojubamweni Awawa. ");
INSERT INTO nnq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nannengelanga kweli, mundu ojwaamini akweti bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne nga chakulya chichampe bwomi. ");
INSERT INTO nnq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Akinaota binu ngabalye mana kweno kumpongoti, nambu ngabajomokanga. ");
INSERT INTO nnq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nambu chenje nga chakulya kichiuluka kuboka kumbengu ili jwajoa ojwapakulye ajomokaje. ");
INSERT INTO nnq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne nga chakulya china bwomi echikiulwike kuboka kumbengu. Mundu jwajoa anda alile chakulya chenje, aitama nukupelaje. Na chakulya echimbakumpe nga mmele gwango, ogunuboya ibe bandu boa ba padunia babe na bwomi.” ");
INSERT INTO nnq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ngapenia Akayahudi ngabatumbu kutaukana kati jabe, “Aotobo jonjo kutupe mmele gwakwe tulye?” ");
INSERT INTO nnq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu ngabalengela, “Nannenge kweli, anda nukulyeje mmele gwa Mwana gwa Mundu nu kunywe myai jaakwe, mmegangaje na bwomi nkati jiinu. ");
INSERT INTO nnq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ojwalye mmele gwango nukunywe myai jango akweti bwomi gwa machoba goa pangapela, nane manuhyoya lichoba lyu kujomolela. ");
INSERT INTO nnq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mana mmele gwango nga chakulya cha kweli, na myai jango nga chikunywe cha kweli. ");
INSERT INTO nnq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ojwaulye mmele gwango na kujinywe myai jango, atama nkati jango, na ne ndama nkati jaakwe. ");
INSERT INTO nnq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Andi Awawa pababi amomi bandumite, nane nama kumagambu ga benia. Uyo mundu ojwandye nenga aba kube mmomi uyo kumagambu gangone. ");
INSERT INTO nnq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bai chenje nga chakulya echikiulwike kuboka kumbengu, ngiti andi mana yabalya akinaota bitoje, ngabaweganga. Ojwalye chakulya chenje aba mmomi gwangapela.” ");
INSERT INTO nnq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu alenga genia pakiba akapundicha munyumba jukugongale kwako kukilambo cha Kafalanaumu. ");
INSERT INTO nnq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ajingi ba akinapunji bakwe apabajoa genia, ngabalenga, “Mapundicho ganga gukujundupa! Bene abapakuotola kugapenikia?” ");
INSERT INTO nnq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu ngamanya nukunnengeje mundu kutenda akinapunji bakwe ngabang'ing'iyana kukilebe chenie, ngabakonya, “Bo, kilebe chenje kimmekite mmegange na mbwele? ");
INSERT INTO nnq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ibakubebo pampakummona Mwana jwa Mundu akaombila kujenda kwako kwakiba? ");
INSERT INTO nnq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Uhuke jwa Nnoongo ngaojwaleta bwomi, makakala ga mundu kuoto kileje. Malobe ganannengilaga nga ga Uhuke jwa Nnoongo, na galeta bwomi. ");
INSERT INTO nnq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Iganu kube nyene babile kati jiinu bangaamini.” Yesu alenga nyene amanyi kuboka apitumbulaga beneke bangaamini, uyo na amanyi beneke abapa kung'aluka. ");
INSERT INTO nnq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kuboka penia ngalenga kabele, “Ngakwamana nanengilinge abije jwa otwile kuika kwango nukunhwotoya Awawa bangoje.” ");
INSERT INTO nnq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kuboka mugenia, akinapunji bakwe ajingi ngababuja unyuma nu kulongwana kabeje. ");
INSERT INTO nnq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu ngabakonya baba akinapunji bakwe komi na abena, “Bo, namangwetomwe mpala kuboka uyoyo?” ");
INSERT INTO nnq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petulo nganyanga, “Angwana, tupakujenda kubeneke? Mwe nkweti malobe agaleta bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Twe tuamini, nu tumanyi mwe nga Machwapi ba Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu ngabajanga, “Bo, nanchagulingeje mangweto komi nabena? Iganu kube nyene, jumwe jiinu nga Mmaja!” ");
INSERT INTO nnq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu alongela genia magambu ga Yuda, mwana jwa Simoni Isikalioti. Maana jwenio akiba ngajweno ojwa pakunng'aluka, iganukube akiba jumwe jwa baba akinapunji komi na abena. ");
INSERT INTO nnq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kibokachapena, Yesu ngajenda okwo kukilambo cha Ku Galilaya. Apaije kujenda kukilambo cha Yudea magambu akilongoi ba Akayahudi bakiba bapaila kunkoma. ");
INSERT INTO nnq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mpapala gwa Akayahudi ogukemigwa iteba, ukiba ubandikile. ");
INSERT INTO nnq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bai inuna yakwe nginnengela, “Mmoke pamba nnyende Kuyudea ili akinapunji binu bagabone maengo ga ntenda. ");
INSERT INTO nnq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mundu ukamulaje maengo gakwe kukuiya anda apala kumanyika na bandu. Yene nkamu ilebe yene, mikilaye kwa bandu boa.” ");
INSERT INTO nnq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ata inuna yakwe yunhwaminije. ");
INSERT INTO nnq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bai Yesu ngabalengela, “Kingobu chango chanaikaje. Nambu kwinu mangweto kila kingobu cha mbone. ");
INSERT INTO nnq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bandu boa kunchimwaje mangweto, nambu ne kunjimwa kwa magambu nenga, njalakicha benia bandwa itendwa yabe ibaja. ");
INSERT INTO nnq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mangweto nnyendange ku mpapala gwenio. Ne nyendaje ku mpapala gwenio magambu kingobu chango chambone chanaikaje.” ");
INSERT INTO nnq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Alenga genia kimoka chapenia ngaigala kukilambo cha Ku Galilaya. ");
INSERT INTO nnq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kuboka pa inunu yakwe kujenda kusikukuu, najwombe Yesu ngajenda kusikukuu kwa kukiia. ");
INSERT INTO nnq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Akilongoi ba Akayahudi bakibanga kumpala kusikukuu jene, ngabakonyanga, “Abiko?” ");
INSERT INTO nnq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pakiba na indondo ijingi pankengeni gwa bandu. Bange ngabalenga, “Nga mundu jwambone.” Na bange ngabalenga, “Baoyanga bandu.” ");
INSERT INTO nnq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nambu akibaje mundu ojwajigite kulenga nhwalo gwenio gwa Yesu pabandu kwa kajobokanga akilongoi ba Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mpapala gwenio pagwaba panakati na kati, na jweno Yesu ngajabu kunyumba ja Nnoongo, ngatumbu kupundicha. ");
INSERT INTO nnq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Akilongoi ba Akayahudi ngabaomongwa na kulenga, “Mundu ojo apatita ko ilimu kiti atekuchoma chuleje?” ");
INSERT INTO nnq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Penia Yesu ngajanga, “Mapundicho gambundicha gangoje nambu gabe benia abandumite. ");
INSERT INTO nnq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundu andapai kutenda gaga gapai Nnoongo, mamanya mapundicho gango gaboka kwa Nnoongo, au ne ndenda kulongetu namwene. ");
INSERT INTO nnq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mundu jwa kilonge mwene apala kunnumbalila mundu mwene. Nambu jwa pala kibumo cha abatumite, jwenio nga kuaminika, na nkati jakwe ubije ubaja gwa gwoa gola. ");
INSERT INTO nnq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bo, Musa ampilingitije Malagilo? Ata yene, abije wala jumwe kwinu ojwa kamu malagano mpa kungomilanga nike?” ");
INSERT INTO nnq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Penia bandu ngabanyanga, “Mwe nkweti nchepela! Bene abapa kunkoma?” ");
INSERT INTO nnq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu ngajanga, “Natendite kikobo chimwe, na mangweto ntenda kuomongwa. ");
INSERT INTO nnq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa ampilingite lukobo lwalo lukuina. Ngiti lukobo lwenio luboka ku Musaje nambu luboka kwa akaokolo nambu ngoe mangweto kuwina mwana munalome ata Lichoba Lya Kupomolela. ");
INSERT INTO nnq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bai anda ibi yene mwana munalome kuwina Lichoba Lya Kupomolela kwa magambu Malagilo ga Musa gakaponiaje, mbona lele unjimwalanga magambu ga kunnamia mundu kube tegatega lichoba lya kupomalela? ");
INSERT INTO nnq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Makahukumu ilebe panjatuje, mpanganga hukumu ejipaligwa.” ");
INSERT INTO nnq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bange bandu ba Kuyelusalemu ngabalenga, “Bo mundu jwajo jubampala kunkomajo jwajoje? ");
INSERT INTO nnq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nnolange ngoe! Alongela pukongolou, wala abije mundu ojwannenge kilebe. Bo, au akiilongoi bamanyi jwenio nga Kilisto? ");
INSERT INTO nnq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kilisto papakuika abije mundu jwapa kumanya aboke koo. Nambu twe tumanyi kwaboka mundu ojo!” ");
INSERT INTO nnq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bai Yesu pakiba akapundichaga unyumba ja Nnoongo ngatondobea lilobe nu kulenga, “Mmanyangite ne na mukumanyi kumoka? Ne inkila ku amuli jango namweneje. Ila abo abandumite ne nga ba kweli, na mangweto mumanyije. ");
INSERT INTO nnq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nambu ne nummanyi kumagambu moka kachakwe, jwenio nga ojwandumite.” ");
INSERT INTO nnq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bai bandu bapala kumeka mumakakala, nambu akibaje mundu ojwajigite kunkamula kumagambu kingobu chakwe kikiba tango chanaikaje. ");
INSERT INTO nnq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ajingi abakiba pankenga pala bunhwamininge, ngabalenganga, “Bo, andaike Kilisto matenda ikobo ikolongwa muno kupeta yatei ojo?” ");
INSERT INTO nnq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo gajowine bandu bakajojela malobe genia ga Yesu. Bai angweto pamwe na Akakung'i akolo ngabagakinga manjolinjoli gammeke Yesu mumakakala. ");
INSERT INTO nnq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu ngalenga, “Tango mbi namangweto kingobu tu kubokapenia mbakunyendelela jwajo jwandumite. ");
INSERT INTO nnq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mpakumbala nambu umonangaje, magambu papa pambakube namangweto kuotoje kuika.” ");
INSERT INTO nnq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Achilongochi ba Akayahudi ngabalonge bene kangweto kwa angweto, “Mundu ojo apa kujenda ko pangaoto kumpata? Apakujenda kukilambo cha Akagiliki kubabi bandu bito na kapundicha Akagiliki? ");
INSERT INTO nnq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Abi na mana gani palenga, ‘Mpakumbalanga nambu umbataje, na pamba kube ne mangweto kuotoje kuika?’ ” ");
INSERT INTO nnq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lichoba lya kupela mpapala gwenio ngilikiba likolo, Yesu ngajema ngalenga kulilobe likolongwa, “Mundu ojwabi na nyota aiche kwango anywe. ");
INSERT INTO nnq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Andi Majandiko Machwapi pagalenga, ‘Mundu ojwaamini ne, chembwe cha mache agaleta bwomi gaba kueluka kuboka umojo jakwe!’ ” ");
INSERT INTO nnq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Alenga genia kunenga Uhuke ba Nnoongo pikiba kube kwababala abanhwamini mabakipokela. Kingobu chenie Uhuke ba Nnoongo kikiba tango kuwika kwa magambu Yesu akiba tango anakoigwaje mukingwana. ");
INSERT INTO nnq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bandu bange ababi pankenga pala ngabajoa malobe genia, ngabalenga, “Kweli mundu ojo nga nnondoli!” ");
INSERT INTO nnq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bandu bange ngabalenga, “Ojo nga Kilisto Nkomboi!” Nambu bange ngabalenga, “Bo, kube Nkomboi aboke kukilambo cha Ku Galilaya?” ");
INSERT INTO nnq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Majandiko Machwapi galenga bole? Galenga, “Kilisto aboka kulungolo lwa nngwana Daudi, na apakubelekwa ku Beteleemu kilambo cha nngwana Daudi.” ");
INSERT INTO nnq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yene ngukupitila kupwilikana panakati jankengeni gwa bandu magambu ga Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bandu bange bapala kummeka mumakakala, nambu akibaje mundu jwajigite kunkamula. ");
INSERT INTO nnq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kuboka penia manjolinjoli ngagabuja, akakung'i akolo na Mafalisayo ngabakonya, “Ku nike mannetangiteje?” ");
INSERT INTO nnq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Manjolinjoli ngagajanga, “Abije mundu ojwa akalongela andi palongela mundu ojo!” ");
INSERT INTO nnq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafalisayo ngagakonya, “Bo, namangwetomwe uyo nkoloigwe? ");
INSERT INTO nnq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bo, mummanyije ata kilongoi jumwe au Mfalisayo jwajote jwombe munhwamini? ");
INSERT INTO nnq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nambu nkengeni gongo umanyije Malagilo ga Musa kwa nyene ulanigwe na Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jumwe kati ja Mafalisayo akiba Nikodemo, jwenio atumbwi kunyendelela Yesu. Jwenio ngabalengela, ");
INSERT INTO nnq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bo, Malagilo giito gutujeketela kuhukumu mundu tango nukunnyoaje nu kumanya gatendite?” ");
INSERT INTO nnq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Angweto ngabanyanga kukunkonya, “Bo, namwe uyo mmoka kukilambo cha Ku Galilaya? Aja makagaingikiye Majandiko Machwapi namwe mannola Ku Galilaya kubokeje nnondoli ngu!” ");
INSERT INTO nnq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kuboka penia bandu boa ngabajabula, kila mundu kachakwe. ");
INSERT INTO nnq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu ngajenda kukitombi chikikemigwa Mizeituni. ");
INSERT INTO nnq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Malabo jakwe kindabi tango kilokilo ngajenda kabele ku Nyumba ja Nnoongo. Bandu boa ngabantindilanga, jwombe ngataama ngatumbu kapundichanga. ");
INSERT INTO nnq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Akaboli ba Malagilo na Mafalisayo ngabannetela munkege ojubampuki akatenda ngongola. Ngabanyemeka panakati jabe, ");
INSERT INTO nnq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kuboka penia ngabankonya Yesu, “Apundichi, munkege ojo tampuki akatenda ngongola. ");
INSERT INTO nnq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mumalagilo giito, Musa atupundicha munkege ojwa tunhubwile ugoni andi jonjo aputigwe maganga mpaka kuwe. Mwe nnenga bo?” ");
INSERT INTO nnq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Balenga yene kuntegela Yesu ili bapatange kunkopakea. Nambu Yesu ngalita ngaandika pae nu lukonji. ");
INSERT INTO nnq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pabajendekea kunkonya, Yesu ngajinuka, ngabalengela, “Mundu jwajoa katijinu jwanga majambi abe ju kutumbula kumputa munkege ojo liganga.” ");
INSERT INTO nnq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kuboka penia ngalita kabele, ngabe akaandika pae. ");
INSERT INTO nnq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pabajoa yene ngabatumbu kubokanga jumwe jumwe, balongalela akinanhota. Yesu ngaika jikajaakwe, nu munkegejo ajemite upapa. ");
INSERT INTO nnq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu pajinuka ngankonya munkegejo, “Banduba babiko? Bo, aigije wala jumwe jukunhukumu?” ");
INSERT INTO nnq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Munkege jwenio ngajanga, “Angwana, abije wala jumwe!” Yesu ngannenge, “Nane nunhukumuje. Nnyabule, namakatenda kabeje malemwa.” ");
INSERT INTO nnq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu palongela nabo kabele ngabalenge, “Nenga nga lumuli lwa padunia pano. Mundu jwajoa ojwangengama nenga atyanga ngu mulubendu, ila apakube pa lumuli lwa bwomi.” ");
INSERT INTO nnq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafalisayo ngagannenge, “Mwe mukichalakicha mmene, nayene uchaili gwinu gwambonije.” ");
INSERT INTO nnq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu ngabajanga, “Ataikabi nikichalakicha namwene, uchaili gwango gwa kweli kumagambu nenga manyi kumoka na kunyenda. Nambu mangweto mukumanyije kumoka wala kunyenda. ");
INSERT INTO nnq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mangweto nhukumu kwa mawacho ga mundu tu, nambu ne kunhukumu munduje. ");
INSERT INTO nnq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nambu ata nakanhukumwile, hukumu jango ja kweli magambu mbi jikajangoje. Awawa abandumite babi pamwe na ne. ");
INSERT INTO nnq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iandikigwe Mumalagilo giinu uchaili gwa bandu abele nga kweli ogujeketiligwa. ");
INSERT INTO nnq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ne nikichalakicha namwene, na Awawa abandumite, batenda kunjalakicha uyo.” ");
INSERT INTO nnq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Penia ngabankonya, “Awawa binu babiko?” Yesu ngabajanga, “Mangweto umanyije ne nawala Awawa mamanyije. Makamanyi nenga kabi mamanyi Awawa baango uyo.” ");
INSERT INTO nnq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu alongela malobe genia goa apakiba akapundicha munyumba ja Nnoongo, muchumbi chukupanga lilumbo. Naakibaje mundu jukummeka mumakakala kumagambu kingobu chakwe kikibataango kuika. ");
INSERT INTO nnq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu ngabalenge kabele, “Mwanja na maumbalanga, nambu mpakujomoka namabaja ginu. Kunyenda nenga, mangweto kuotoje kuika.” ");
INSERT INTO nnq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bai akilongoi ba Akayahudi ngabalenga, “Bo, apakikikoma? Mboni alenga, ‘Kunyenda mangweto kuotoje kuika?’ ” ");
INSERT INTO nnq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu ngabajanga, “Mangweto mmokanga upamba pae, nambu nenga mmoka kunani. Mangwetomwe mapadunia pano, nambu nenga napadunia panoje. ");
INSERT INTO nnq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Magambu nannengila mangweto mpakujomoka mumabaja ginu. Anda nukuaminije kutenda, ‘Ne nga jwenio.’ Mpakujomoka na mabaja ginu.” ");
INSERT INTO nnq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Angweto ngabankonya, “Mwe mabeneke?” Yesu ngabajanga, “Nannengalinge kuboka pukutumbula! ");
INSERT INTO nnq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ngweti majingi gukulongela nu gukunhwukumula. Nambu jwajo ojwandumite nga kweli, nane nijilenge dunia ilebe yae tu inijoa kuboka kwabe.” ");
INSERT INTO nnq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bamanyangiteje Yesu akiba alongelanabo kunhwalo gwa Awawa. ");
INSERT INTO nnq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bai Yesu ngabalengela, “Pampakunyinula Mwana jwa Mundu, penia nga pampa kumanya kutenda ‘Ne nga Nenga’. Na ndendaje kilebe namwene, ila nongela gagatu gabambundicha Awawa. ");
INSERT INTO nnq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Baba abandumita babi pamwe nane, benia banekiteje jika yene ngamu ndenda mangobu goa gaga gabaalali mojo.” ");
INSERT INTO nnq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kuboka pukulenga genia bandu ajingi ngabaamini. ");
INSERT INTO nnq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Bai Yesu ngabalengela Akayahudi baba ababunhwamini, “Anda magaagabile mapundicho gango mmaganga makinapunji bango kweli. ");
INSERT INTO nnq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mpakujimanya kweli, na kweli jipakummeka agabwa.” ");
INSERT INTO nnq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Angweto ngabanyanga, “Twe twalungolo lwa Ulaimu, ngu tanabeje takabanda ba mundu jwa jwoa jola. Mmi namana gani pannenga mma kube agabawa?” ");
INSERT INTO nnq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu ngajanga, “Nannenge kweli, kila mundu ojwatenda mabaja nga mmanda jwa mabaja. ");
INSERT INTO nnq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mmanda akwetije kitamo cha machoba goa pakaja, nambu mwana akweti kitamo cha machoba goa. ");
INSERT INTO nnq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Anda Mwana ampilingite agabwa mmakube kweli agabwa. ");
INSERT INTO nnq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Maanyi mangweto malungolo lwa Ulaimu. Ata yene mpakungoma kumagambu mmikugajeketelaje mapundicho gango. ");
INSERT INTO nnq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne nongela gaga gabanangila Awawa, nambu mangweto ntendanga gaga gabannenge awabinu.” ");
INSERT INTO nnq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Angweto ngabanyanga, “Awawa bito Ulaimu!” Yesu ngabalengela, “Ikabi mangweto makinangota ba Ulaimu kabi ntei andi patenda Ulaimu. ");
INSERT INTO nnq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ne nannengile kweli gunujoa ku Nnoongo nambu mangweto mpala kungoma. Ulaimu atenda yeneje! ");
INSERT INTO nnq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mangweto ntendanga ilebe uyaye ibatenda awawa binu.” Angweto ngabannengela, “Twe takanangota ba mumatutweje tukweti awawa bamwe yani Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu ngabalengela, “Ikabi Nnoongo nga awawa binu, kabi umbaile ne, mana ne mmoka ku Nnoongo na ngoe mbi pamba. Nkila kumadalaka gango namweneje ila benia abandumite. ");
INSERT INTO nnq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kunike kumanyaje ganongela? Kumagambu kuotoje kujoa nhwalo gwango. ");
INSERT INTO nnq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mangwetomwe makinangota ba Mmaja na mpalanga ukengama ga awawa binu. Benia bakiba akomi kuboka paitumbalaga, bakwetije kijemo cha kweli, na yene kweli jibije nkati jabe. Kila apabalenga uwangi, balonge mukuboke muali jabe tangu apatumbalaga, mana benia awangi na awawa ba uwangi. ");
INSERT INTO nnq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne nonge kweli, nga kwamana mangweto kuaminije. ");
INSERT INTO nnq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Bene kati jinu abanjalakicha ne ngweti mabaja? Anda nonge kweli mboni kunhwaminije? ");
INSERT INTO nnq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ojwabi jwa Nnoongo kupenakia malobe ga Nnoongo. Nambu mangweto kupenakiaje kumagambu mangwetomwe mabanduje ba Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Akayahudi ngabankonya Yesu, “Bo, tulengiteje kweli mwe makabila ja Samalia, na kabe mmi nanchepela?” ");
INSERT INTO nnq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ngajanga, “Ne ngwetije nchepela, ne naamini Awawa bango, nambu mangweto kuaminije ne. ");
INSERT INTO nnq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne kupalaje kibumo chango namwene. Abile jumwe ojwapala kibumo chenie, Nnoongo nga ojwanumbane, jwombe nga hakimu. ");
INSERT INTO nnq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nannenge kweli, ojwabegelela na mapundicho gango ajomokaje.” ");
INSERT INTO nnq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bai Akayahudi ngabalenga, “Ngoe tumanyi kweli mwe nkweti nchepela! Ulaimu ngawe, na akalondoli booa ngabawe, namwe nnenga eti, ojwabegelela na mapundicho ginu aweje mpaka! ");
INSERT INTO nnq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bo mikitenda makolongwa kapeta Awawa bito Ulaimu nambu bombe bajomwike? Na ata akalondoli bajomwike Mwe mitenda babeneke?” ");
INSERT INTO nnq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu ngabajanga, “Anda nikikoite namwene, kibumo chango kilebeje, ne mbata kibumo Kawawa bango. Bombe mangweto makema ana Nnoongo binu. ");
INSERT INTO nnq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mangwetomwe mamanyije, nambu ne namanyi, andannengite namanyije, mamba nawangi andi mangweto. Ne namanyi na mbikamula nhwalo gwabe. ");
INSERT INTO nnq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ulaimu, Awawa binu, ngabalulutila bilibone lichoba lyango, bombe ngabalibona, ngababe ngalaa.” ");
INSERT INTO nnq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bai Akayahudi ngabannengela, “Mwe tango manaikaje yaka amsini nnengabo kutenda mumweni Ulaimu?” ");
INSERT INTO nnq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu ngabajanga, “Nannenge kweli, tango Ulaimu nukubelekwaje ne mbile.” ");
INSERT INTO nnq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Penia ngabalokota maganga ili bannekelele, nambu Yesu ngakiia, ngapita munyumba ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu apakiba akapeta ngammona mundu jumwe, jwangalola kuboka pabelekwa. ");
INSERT INTO nnq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bai akinapunji ngabankonya, “Aboli, ngabeneke abatei mabaja jwombe mwene au amamundu na awamundu mpaka mundu ojo abelekwe jwangalola?” ");
INSERT INTO nnq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu ngajanga, “Kile chene chapiti kwa magambu ga mabaja gakweje na wala mabaja ga akapotoi bakwe. Ila abelwike jwangalola ili makakala ga Nnoongo gabonekane gakakamu maengo nkati jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Anda kubi tango nalumu tupaligwa kujendekea ukamwa maengo ga baba abandumite, maana kilo kitenda kuika peni mundu aotwaje ukamwa maengo. ");
INSERT INTO nnq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mangobu mbi kudunia, ne nga lumuli lwa kudunia.” ");
INSERT INTO nnq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kuboka pukulonge genia, Yesu ngauna mata pae, ngaunya mandope, ngampakaya jweno jwangalola mumio, ");
INSERT INTO nnq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ngannengela, “Nnyendi makakuye mulilaba lya Siloamu.” (Siloamu maana jakwe, “abatumigwe.”) Penia jweno jwangalola ngajenda, ngakuya, kubokapenia ngabuja abi akalola. ");
INSERT INTO nnq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bai andamya ajabe na baba abakiba bumanyi jweno akiba nhwocho kijopajopa, ngabalenga, “Bo, ojo jwajoje nhwocho na kijopajopa?” ");
INSERT INTO nnq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bange bandu ngabalenga, “Ujojo.” Bange ngabalenga, “Je, ila atekulandana.” Nambu jweno ojwaakabe jwangalola ngalenga, “Nga nenga!” ");
INSERT INTO nnq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bai ngabankonya, “Lele, mio ginu gawekuka bo?” ");
INSERT INTO nnq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na jweno ngabajanga, “Jwajo mundu ojwakemigwa Yesu akatenda mandope, ngambakaya kumio na nganengela, ‘Nnyabu makakuye mulilaba lya Siloamu.’ Penia, ne nganyenda, nganguya, ngambata kulola.” ");
INSERT INTO nnq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ngabankonya, “Jweno abikole?” Najweno ngabajanga, “Ne manyije!” ");
INSERT INTO nnq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kubokapenia ngabampeleka mundu jweno ojwakiba jwangalola kwa Mafalisayo. ");
INSERT INTO nnq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lichoba lyene Yesu apaunya mandope na kuweku mio mundu jweno, lyakiba Lichoba Lya Kupomolela. ");
INSERT INTO nnq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bai Mafalisayo ngabankonya kabele mundu jweno, “Mpatitabo kulola?” Na jweno ngabalengela, “Ambakia mandope mumio, na ne nganguya na ngoe mbikulola.” ");
INSERT INTO nnq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bange Mafalisayo ngabalenga, “Mundu ojo aboka ku Nnoongoje, gambu kuagabaje Malagilo gi Lichoba li Kupomolela.” Nambu bange ngabalenga, “Mundu juna mabaja aotobo kulaya iingi yi ikobo andi yenje?” Ngapabe nu kupwilikana kati jabe. ");
INSERT INTO nnq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mafalisayo ngabankonya kabele mundu jweno ojwakiba jwangalola, “Nnenga anamie mio ginu, chwapi, mwe nnongebo kwa jweno?” Jweno ngabalengela, “Jweno nga nnondoli!” ");
INSERT INTO nnq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Akilongoi ba Akayahudi baaminingeje mundu jweno akiba jwangalola tangu kubelekwa kwakwe na ngoe atenda kulola, mpaka apabakema achikibelei bakwe. ");
INSERT INTO nnq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bai ngabakonya benia achikibelei bakwe, “Bo, jonjo nga kakombo jwinu jwombe mangweto nnenga akabelekwa jwangalola? Ngoe alamitabo?” ");
INSERT INTO nnq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Achikibelei bakwe ngabajanga, “Tumanyi jonjo mwanajwito, na abelwike jwangalola. ");
INSERT INTO nnq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nambu tumanyije apalamita, na tumanyije jwajo ojwanhwekwi mio. Munkonya mwene, jwenio munanhota, aotwile kulongela mwene.” ");
INSERT INTO nnq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Achikibelei bakwe balenga nyenie kwa magambu batenda kujogopanga akikilongoi ba Akayahudi magambu akikilongoi bena bakiba bapataninge kutenda mundu jwajote ojwapa kunyeketela Yesu nga Kilisto bapakumenga panja ja nyumba ja kugongalela. ");
INSERT INTO nnq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nga maana achikibelei bakwe ngabalenga, “Jweno mundu munaota, munkonyanga mwene.” ");
INSERT INTO nnq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bai ngabankema kabele jweno ojwakiba jwangalola, ngabannenge, “Mumpe kibumo Nnoongo! Twe tumanyi mundu jonjo jwannamia nga juna mabaja.” ");
INSERT INTO nnq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jweno ngajanga, “Anda nga juna mabaja ne manyije. Nambu kilebe chimwe nikimanyi, nakiba nangalola, na ngoe ndenda kulola.” ");
INSERT INTO nnq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bai ngabankonya, “Bantendi nike? Bunhwekwibo mio ginu?” ");
INSERT INTO nnq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mundu jweno ngabajanga, “Nyomwi nganannengelanga, na mangweto manyoineje. Kwa nike mpala kumbenikia kabele? Bo, mangweto mpala kube akinapunji bakwe?” ");
INSERT INTO nnq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nambu bena ngabantukana nu kulenga, “Mwe nga manapunji bakwe, nambu twe nga akinapunji ba Musa. ");
INSERT INTO nnq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twe tumanyi Nnoongo alongi na Musa, nambu mundu jonjo tummanyije abokita ko!” ");
INSERT INTO nnq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mundu jweno ngabajanga, “Chene nga kilebe cha kuomongwa! Mangweto mmanyije abokita ko, nambu anhwekwi mio gango! ");
INSERT INTO nnq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumanyi Nnoongo kapenikiangaje bandu bina mabaja, ila ampenikia jwajote ojwannumba na kulenganakia agapala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tangu kutumbwa kwa dunia tanajoaje mundu agawekwile mio ga mundu ojwabelwike Jwangalola. ");
INSERT INTO nnq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anda mundu jonjo akabokitije kwa Nnoongo, kabi aotwije kutenda chachoa.” ");
INSERT INTO nnq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bena ngabannyanga, “Mwe ngammelekwa na kunnela mumabaja, nhwotobo kutubola twenga?” Bai ngabammenga munyumba. ");
INSERT INTO nnq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ngajoa, bakate kummenga munyumba ja Nnoongo bai apankolela jwangalola ngankonya, “Bo, mwe muamini Mwana jwa Mundu?” ");
INSERT INTO nnq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mundu jweno ngajanga, “Angwana, unengele bena beneke, ili mbate kaamini.” ");
INSERT INTO nnq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu ngannengala, “Mamweni, najweno nga ojwalonge na mwe ngoe.” ");
INSERT INTO nnq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bai mundu jweno ngakilikitila ngalenga, “Angwana amini!” ");
INSERT INTO nnq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu ngalenga, “Nenga ikila kuhukumu dunia, ibe bangalola bapatange kulola, na abalola babegange bakalolaje.” ");
INSERT INTO nnq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bange Mafalisayo abakiba pamwe nabo ngabajoa malobe gena, ngabankonya, “Bo nnenga natwe tangalola?” ");
INSERT INTO nnq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu ngabajanga, “Anda makabi bangalola, kabi mmilingitije na malemwa. Nambu ngoe mangweto nnenga, ‘Twe tubikulola, na nyenie ibonekana mmi tango na mabaja.’ ” ");
INSERT INTO nnq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu ngalenga, “Nannenge kweli, jwajoti jola jwangajingila mukitundu cha mambelele kwa kukupetela panniango, nambu kupekenyela na kujingila kwa ndela jenge, jwenio nga nnyibi na mpoki. ");
INSERT INTO nnq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nambu mundu ojwajingila kukupetela paniango, jwenio nga nchungi jwa mambelele. ");
INSERT INTO nnq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nnendei jwa niango gwa kitundu kunnyogolela nchungi, na mambelele kujoa lilobe lyakwe, na benia kagakema mambelele gabe kila limwe kwa liina lyakwe, na kugalongolea panja. ");
INSERT INTO nnq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Anda agapiite panja, na genia mambelele kunkengama, mana gamaanyi lilobe lyabe. ");
INSERT INTO nnq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mambelele genia gaotwije kunkengama nng'eni, ila gapakuntila kwa magambu galimanyije lilobe lyabe.” ");
INSERT INTO nnq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ngabalengelanga kulandanikia kweno, nambu benia bamanyije echapala kalengelanga. ");
INSERT INTO nnq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bai Yesu ngalenga kabele, “Nannenge kweli, ne nga nniango gwa mambelele. ");
INSERT INTO nnq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bange bala boa abaike nnongi jango nga akajibi na akapoki, nabenia mambelele gapenikije. ");
INSERT INTO nnq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ne nga nniango. Ojwajingi kwa kupete kwango ne maikomboligwa. Maijingila na kupita, nu kupata lulela. ");
INSERT INTO nnq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nnyibi kuika kwa magambu ga kujiba, ukoma na kualabiya. Ne inkila mpate kube na bwomi, bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nenga nanchungi jwa mbone. Nchungi jwambone kuboya bwomi gwakwe magambu ga mambelele gakwe. ");
INSERT INTO nnq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mundu jwa kibalua jwombe nchungije, na wala mambelele mali gakweje, apalola limei lyakaika, kagaleka mambelele nukutila, kubokapenia limei kagapukila na mambelele kupwilikana. ");
INSERT INTO nnq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jweno kugajalije mambelele kwa magambu jweno nga mundu jwa nchaala tu. ");
INSERT INTO nnq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nenga nachungi bambone. Nagamanyi mambelele gango, na genia gamanyi ne, ");
INSERT INTO nnq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","anda nyenie Awawa apabamanyi ne, nane apanamanyi Awawa. Nenga nuboya bwomi gwango kwa magambu ga mambelele. ");
INSERT INTO nnq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kabele ngweti mambelele gange gangabe mukitundu chenje. Mbaligwe kagaleta nagenia, nagenia magalijoa lilobe lyango, na mapaba na kipenga chimwe na nchungi jumwe. ");
INSERT INTO nnq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Awawa bambaile ne mana nuboya bwomi gwango mbate kuupokela kabele. ");
INSERT INTO nnq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Abije mundu ojwa amboka bwomi gwango. Ne nuboya kwa iyali yango namwene. Ngweti kinala chu kuboya ni kinala chu kutola kabele. Nyene ngipibi Awawa apabaamuliche ndende.” ");
INSERT INTO nnq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ngukube kabe kupwilikana kati ja Akayahudi kwa magambu ga malobe genia. ");
INSERT INTO nnq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ajingi ngabalenga, “Akweti nchepela, kabe nga machonjo! Ga nike kumpenikia?” ");
INSERT INTO nnq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bange ngabalenga, “Ganga malobe ga junanchepelaje. Bo, nchepela kuotola kagaeku mio ga bangalola?” ");
INSERT INTO nnq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kweno Kuyelusalemu kukiba na chikukuu jukubeka chwapi nyumba ja Nnoongo. Mangobu gena gakiba ga malili. ");
INSERT INTO nnq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jwombe Yesu ngabe akajenda munyumba ja Nnoongo panchana gwa Solomoni. ");
INSERT INTO nnq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bai Akayahudi ngabantindila, ngabankonya, “Mpakutuleka nambwele mpaka lii? Anda mwe nga Kilisto, bai, mutulengele kipola.” ");
INSERT INTO nnq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu ngabajanga, “Nannengelinge, nambu kuaminije. Maengo aga nagatenda ne kwa liina lya Awawa bango gatenda kunjalakicha. ");
INSERT INTO nnq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nambu mangweto kuaminije magambu mangweto mambelele ganguje. ");
INSERT INTO nnq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mambelele gango kulijoa lilobe lyango. Nenga nagamanyi, nagena kungengama. ");
INSERT INTO nnq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nenga nampeganga bwomi gwa machoba goa pangapela, na benia baobangaje machoba goa, wala abije mundu ojwa pakugaotola kagaboya mukuboko jango. ");
INSERT INTO nnq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Awawa bango bombe ngaba mbila gena nga kolongwa kuliko boa, wala abije ojwapakuotola kagaboya mukuboko jabe Awawa. ");
INSERT INTO nnq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nenga na Awawa, tubi jumwe.” ");
INSERT INTO nnq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bai Akayahudi ngabatolanga maganga kabele ili bamputange. ");
INSERT INTO nnq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu ngabalengela, “Nannangilinge maengo majingi kuboka kwa Awawa. Nga gako kati ja ganga agantenda umbutange maganga?” ");
INSERT INTO nnq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Akayahudi ngabannyanga, “Kwamaengo gambone tumputaje maganga, ila magambu gukuntukana Nnoongo! Maana mikitenda mwe ma Nnoongo kongo mwe mamundu tu.” ");
INSERT INTO nnq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu ngajanga, “Bo, iandikigweje Mumalagilo ginu, Nnoongo ngalenga, ‘Mangweto nga milongo?’ ");
INSERT INTO nnq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nnoongo ngajikema milongo baba abapatite malagilo gakwe, natwe tumanyi Majandiko Machwapi galenga ukweli machoba goa.” ");
INSERT INTO nnq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yesu ngajendekea kulongela, “Awawa banyegwiye nu kunduma kudunia, kwa nike nnenga ndenda kutukana magambu nengite, ‘Nenga nga Mwana jwa Nnoongo?’ ");
INSERT INTO nnq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Anda mbi ukamulaje maengo ga Awawa bango, makaaminije. ");
INSERT INTO nnq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nambu andambi kamula, ata ikabi nhwaminingije, makabi kuamini oti maengo gena, mmanyange kutenda, Awawa bango babi nkatijango, nanenga mbi nkatijabe.” ");
INSERT INTO nnq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ngabajiganga kabele kumpukila Yesu, nambu ngapokonyoka mumaboko gabe. ");
INSERT INTO nnq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu ngajabu kabele kwie ja lukemba Yolidani, paali apakiba Yohana akabatiza, ngatama kweno. ");
INSERT INTO nnq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bandu ajingi ngabannyendelela ngabalenga, “Yohana alaiteje iingi yi ikobo yayoa. Nambu gena goa Yohana agalenga gena magambu ga mundu jwenio ga kweli.” ");
INSERT INTO nnq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Paali penia bandu ajingi ngabanhwamini. ");
INSERT INTO nnq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mundu jumwe ojwa konda Lazalo, ojwatama ku Betania, akiba ntamwe. Ku Betania kikiba kilambo echibatama Maliamu na Malita, akalombo mundu. ");
INSERT INTO nnq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliamu nga jweno ojwampakaya Angwana mauta nukunhwungula kwanywili yakwe. Lazalo nkakamundu ngaojwakiba ntamwe. ");
INSERT INTO nnq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bai akalombo bena ngabatuma nhwalo kwa Yesu kutenda, “Angwana, nng'anjagwinu jwamampala ntamwe!” ");
INSERT INTO nnq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu pajoa yene, ngalenga, “Kitamwe chenje kiletaje kiu, nambu kumagambu ga kunkoya Nnoongo, alwalite kitamwe chenje kupala kumpe kibumo Mwana jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ngampala Malita na alombo mundu na Lazalo. ");
INSERT INTO nnq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Paupata nhwalo gwenio Lazalo ntamwe, Yesu ngajendekea kutama paali upo kwa machoba mabele. ");
INSERT INTO nnq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kuboka penia ngabalengela akinapunji baakwe, “Tujende kabele kukilambo cha Kuyudea!” ");
INSERT INTO nnq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Akinapunji ngabalengela, “Aboli! Kingobu kichokotu kipetite kuboka pa Akayahudi pabapala kunkoma na maganga, namwe mpala kujenda kabele kwenioko?” ");
INSERT INTO nnq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ngajanga, “Bo, kingobu cha mui komi ni ibeleje? Bai mundu anda atyangite mui kuotoje ukobala magambu alola ndaa padunia. ");
INSERT INTO nnq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nambu mundu anda ajendite kilo apakobala kumagambu lumuli lubije nkati jaakwe.” ");
INSERT INTO nnq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu pajomola kulongela malobe genia, ngabalengela, “Ng'anjagwito Lazalo abi lugono, nambu ne manyenda kunyimuya.” ");
INSERT INTO nnq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Akinapunji baakwe ngannengela, “Angwana, anda abi lugono, bai malama.” ");
INSERT INTO nnq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Angweto bapemelela Yesu alengita kugoche lugono, bamanyije alenga kiu cha Lazalo. ");
INSERT INTO nnq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bai Yesu ngabalengela kipola, “Lazalo awile! ");
INSERT INTO nnq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nambu mbi na laa kumamagambu giinu, nakibaje na mangweto kwenio, na mpate kuamini. Aja, tujende kachakwe.” ");
INSERT INTO nnq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi ojwakemigwa Mabela ngabalengela akinapunji akajakwe, “Tujende na twe tukawee tuboa!” ");
INSERT INTO nnq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu pajenda kwenio ankolela Lazalo abi mulikabuli machoba ncheche. ");
INSERT INTO nnq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kukijiji cha ku Betania kukiba papipi na kilambo cha Kuyelusalemu, kulipa kwakwe kubi kilomita itatu. ");
INSERT INTO nnq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Akayahudi ajingi bakiba baike kwa Malita na Maliamu kakokalekea kukiu cha nkaka mundu. ");
INSERT INTO nnq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bai Malita pajoa Yesu atendakuika, ngajenda kumpokela, nambu Maliamu ngaika kachakwe. ");
INSERT INTO nnq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malita ngannengela Yesu, “Angwana, makabi upamba, Nhwacha gwito kabi ajomwikeje! ");
INSERT INTO nnq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nambu maanyi mpaka ngoe chachoa cha mpa kunnenge Nnoongo, mampa.” ");
INSERT INTO nnq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu ngannengela, “Nhwacha gwinu mayoka.” ");
INSERT INTO nnq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malita ngajanga, “Manyi mayoka mangobu ga kuyoka, lichoba lya kupela.” ");
INSERT INTO nnq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu ngannengela, “Nenga nga kuyoka na bwomi. Ojwaamini nenga ata akajomwike malama. ");
INSERT INTO nnq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na kila ojwalama na kuamini nenga aweje ngu. Bo, kuamini genago?” ");
INSERT INTO nnq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malita ngannengela, “Elo Angwana! Nenga amini mwenga nga Kilisto, Mwana jwa Nnoongo, jwajo ojwaika padunia.” ");
INSERT INTO nnq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bada ja kulenga genago, Malita ngajenda kunkema Maliamu nnombo mundu, ngannengela pantemela, “Mmoli abi pamba, ankema.” ");
INSERT INTO nnq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jwombe apajoa gena kingobucho ngajinuka, nukunnyendelela Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu akiba anajingije pikijiji, ila akiba tango paali upapa apampokila Malita. ");
INSERT INTO nnq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bai Akayahudi babakiba pamwe kachakwe Maliamu babakiba kumpe pole pabamona ajinwike nukupita panja chokwe, ngabankengama. Bakita akiba kujenda kamakabuli kulombola. ");
INSERT INTO nnq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bai Maliamu apaika paali pena apabi Yesu nukummona ngakilikitila, nukunnengela, “Angwana makabi upamba, akaka bango kabi bawije!” ");
INSERT INTO nnq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu apammona akaguta na Akayahudi babaika pamwe, nangweto uyo baguta, ngabe na chimbaa, na laaje kumwojo gwakwe. ");
INSERT INTO nnq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kibokachapenia ngabankonya, “Mammekiti ko?” Ngabannyanga, “Angwana, nhwike nnole.” ");
INSERT INTO nnq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu ngaguta. ");
INSERT INTO nnq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Akayahudi ngabalenga, “Nnolange apampaile!” ");
INSERT INTO nnq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nambu kati jabe ngabalenga, “Bo, jonjo nganhwekwi mio jwangalola jola, kuotoje kuntenda Lazalo akaweje?” ");
INSERT INTO nnq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bai Yesu akiba na laaje kabele kumwojo, ngaika kamakabuli likabuli lyene lyakiba nduka, liekiligwe kwa libwe! ");
INSERT INTO nnq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ngalenga, “Mmoyange libwe lyene!” Malita, nnombo mundu jwajo ojwawile, ngannengela, “Angwana, tayali atumbu kununga, atamite mulikabuli machoba ncheche!” ");
INSERT INTO nnq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu ngannengela, “Bo, nanengije anda nhwamini mamikibona kibumo cha Nnoongo?” ");
INSERT INTO nnq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bai ngabaliboya libwe lyene. Yesu ngalola kunani kumbingu, ngalenga, “Nanumba ma Awawa kwa magambu umbi kunyoa. ");
INSERT INTO nnq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Maanyi umbi kunyoa machoba goa. Nambu nengite genago magambu ga bandu ababi pamba bapate kuamini kutenda mwenga maundumite.” ");
INSERT INTO nnq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Apajomola kulenga genago, ngakema kwa lilobe likolongwa, “Lazalo! Mpite panja!” ");
INSERT INTO nnq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jwajo ojwakiba ajomwike ngapita panja, kongo bantabite chanda mumakongono na mumaboko, nukumio jakwe kuwekeligwe. Yesu ngabalengela, “Mankulugule, manneke ajabule.” ");
INSERT INTO nnq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bai Akayahudi ajingi bakiba baike kwa Maliamu pabalola gena agatendite Yesu, ngaba nhwamini. ");
INSERT INTO nnq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nambu kati jabe ngabajenda kwa Mafalisayo ngabape nhwalo gwa ikobo eyatendite Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Akakung'i akolo na Mafalisayo ngababe na machabuli makolongwa, ngabalenga, “Tutendi nii? Mundu jonjo alaya iingi yi ikobo nduu muno. ");
INSERT INTO nnq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Anda tunnekite tu bandu boa mabanhwamini, na Akaloma mabaika kualabia nyumba jito ja Nnoongo na kilambo chiito!” ");
INSERT INTO nnq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pena jumwe kati jabe ojwakonda Kayafa, ojwabi nkung'i nkolo chaka chenie, ngalenga, “Mangwetumwenga, mmanyije kilebe! ");
INSERT INTO nnq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bo, mmikulolaje mbaya kwinu mundu jumwe awe kwa magambu ga bandu, kuliko kilambo choa.” ");
INSERT INTO nnq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jweno alenga gena kwa iyali yakwe mweneje, ila magambu jwombe mwene akiba nkung'i nkolo chaka chene, ngalondola kita Yesu mawage magambu ga kilambo chakwe, ");
INSERT INTO nnq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na kwa magambu gabetuje, nambu apate kuleta pamwe ingota ya Nnoongo abapwilikine. ");
INSERT INTO nnq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bai tangu lichoba lyene achikilongochi ba Akayahudi ngababeka njama ja kunkoma Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwagena Yesu atyangitije pakubonekana na Akayahudi, ila ngaboka pena, ngajenda paali papipi na mpongoti, pikilambo cha Kuefulaimu. Ngatama kweno pamwe na akinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mpapala gwa Pasaka gwa Akayahudi gwakiba gubandakile, na bandu ajingi ngabajenda Kuyelusalemu bapaila bikijeguyange tango na mpapala gwenio gwanatumbuje. ");
INSERT INTO nnq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bai ngaba mpala Yesu, na pabakongana pamwe munyumba ja Nnoongo ngabakonyana, “Nnolabo? Ibonikana aikaje ku mpapala, andaje?” ");
INSERT INTO nnq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Akakung'i akolo na Mafalisayo bakiba bapiite amuli anda mundu apamanyi paali apabi Yesu balengele ili bampukile. ");
INSERT INTO nnq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gakaigala machoba sita kube Mpapala gwa Pasaka, Yesu ngajenda kukilambo cha ku Betania kachakwe Lazalo ojwannyoya Yesu kuboka kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kweno ngabampanganikia chakulya cha kimuyo, Malita akiba akatumika. Lazalo akiba pamwe nababa abakibanga pamecha pamwe na Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bai Maliamu ngatola chupa cha mauta gabei, ngampakaya Yesu mumakongono nukuungula kwa nywili yakwe. Unyumba mwoa nginungila luumba lumauta. ");
INSERT INTO nnq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bai Yuda Isikalioti, jumwe kati ja akinapunji komi na abena jwenio ojwapakung'aluka Yesu, ngalenga, ");
INSERT INTO nnq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwanike mauta gena gauchigwije ku bei ngolongwa nu uloi gwene kape akaocho?” ");
INSERT INTO nnq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Alenga genia ngiti kaagaba akaochoje nambu magambu akiba mmeka ela, namagambu akiba mwihi, kwa machoba majingi akiba kujiba munkoba gweno. ");
INSERT INTO nnq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nambu Yesu ngalenga, “Makachumbuyaje amama bamba! Maleke bagabeke magambu ga lichoba lya machiko gango. ");
INSERT INTO nnq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Akaocho mamma nabo machoba goa, nambu mmegangaje nane machoba goa.” ");
INSERT INTO nnq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Akayahudi ajingi ngabajoa Yesu akiba ku Betania. Bai ngabajenda kweno ngiti kumagambu gukummona Yesu tu, unyae bapate kumona Lazalo ojwanyoite Yesu kuboka kwa babawile. ");
INSERT INTO nnq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Akakung'i akolo ngabatenda njama jukunkoma Lazalo, ");
INSERT INTO nnq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","maana kumagambu ga Lazalo Akayahudi ajingi ngabagaluka achilongochi babe, ngabanhwamini Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Malabo jakwe, nkengeni gwa bandu abaika kusikukuu ngabajoa kube Yesu akiba undela kuika Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bai ngabatola makoti gi mitende, ngabajenda kumpokela kongo bakatondobea malobe nu kulenga, “Alumbigwe Nnoongo! Abe ni kindimba jwenio ojwapakuika ku liina lya Angwana. Babe ni kindimba Angwana bu Kuisilaeli.” ");
INSERT INTO nnq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu ngampata mwana liponda jumwe ngaombela panani jakwe anda Majandiko Machwapi apagalenga, ");
INSERT INTO nnq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Makajobokaje, kilambo cha Sayuni! Nnole, Angwana binu batenda kuika, anhwombi mwana liponda.” ");
INSERT INTO nnq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kingobu chenie akinapunji bakwe bamanyingitije ile yene, nambu Yesu apakiba akoigwe, penia ngabakombakela genia gakiba gaandikigwe kunhwalo gwa jweno, na kutenda bandu bakiba bantendila genia. ");
INSERT INTO nnq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bandu ajingi babakiba pamwe nakwe mangobu apabankema Lazalo mulikabuli, nganhyoya kuboka kwa babawile, ngabachalakicha gagapitile. ");
INSERT INTO nnq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kwagenia nkengeni gwa bandu ngujenda kumpokela, gambu boa ngabajoa kita Yesu alaite iingi yi ikobo yenie. ");
INSERT INTO nnq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mafalisayo ngabalengelana, “Mmikulola? Tuotwije kutenda chachoa! Nnolange bandu boa bankengama.” ");
INSERT INTO nnq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pakiba na Akagiliki kati ja bandu babaika kuyelusalemu kugongalela mangobu ga mpapala gwenio. ");
INSERT INTO nnq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Akangweto ngabannyendela Filipo, jwa kilambo chuku Betisaida kweno ku Galilaya, ngabalenga, “Angwana, tupala kummona Yesu.” ");
INSERT INTO nnq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo ngajenda, kunnengela Andulea, boa akabele ngabajenda kunnengela Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu ngabalengela, “mangobu gukoigwa Mwana jwa Mundu gaike! ");
INSERT INTO nnq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nannengelanga kweli, mbonje ya mapemba maigala mbonje tu nambu anda igwile pulundope nukuwe. Anda iwile ipambika mbonji ndu. ");
INSERT INTO nnq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mundu ojwapala bwomi gwakwe, abakuoya, nambu mundu ojwauchimwa bwomi gwakwe padunia jenje maubeka kumagambu ga bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ojwapala kundumikia mpaka angengame oti, magambu genia papotipala pambi nenga penia mpakachi jwango pabakube. Mundu jwajoa ojwandumikia, Awawa bango bapakunnyali jwenio. ");
INSERT INTO nnq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ngoe mwojo gwango utenda kuwechuka, nongela nike? Bo, nenge, ‘Awawa, makakiluchuje kingobu chene kinhikalile?’ Nambu nhikila kwa magambu genia kupala mbete kingobu chukupotekigwa cheno. ");
INSERT INTO nnq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Awawa, mulikoleye liina linu.” Penia lilobe ngililenga kuboka kumbengu, “Nankoliye, na mbakulikoleya kabele.” ");
INSERT INTO nnq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nkenga gwa bandu gukiba ujemite peniapo ngabajoa lilobe lyene, na bange angweto ngabalenga, “Alonge na mpakachi jwa Nnoongo alonginago!” ");
INSERT INTO nnq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nambu Yesu ngabalengela, “Lilobe lyenie lipitila kumagambu gangoneje, ila kumagambu ginu. ");
INSERT INTO nnq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ngoe nga kingobu cha dunia jeno kuhukumigwa, ngoe nkolongwa jwa dunia jeno apakupenduligwa. ");
INSERT INTO nnq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nane pambakujinuligwa kunani ja dunia mbakunhuta kila mundu kwango.” ");
INSERT INTO nnq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu alongela yene alaya apakuwe kiu gani. ");
INSERT INTO nnq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nkenga gwenio ngugwannyanga, “Twe tulengaligwa na Malagilo giito kutenda Kilisto apakutama nukupelaje. Nhwotobo, bai kulenga eti Mwana jwa Mundu apakujinuligwa? Jwenio Mwana jwa Mundu nga meneke?” ");
INSERT INTO nnq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu ngabalengela, “Lumuli lubi tango namangweto kuki ngobu kachoko. Nnyendange tango mminalo lumuli lwenio, ibe lubendu lukampataje, maana ojwajenda mulubendu kumanyaje kwajenda. ");
INSERT INTO nnq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bai kingobu mminalo lumuli lwenio muluamini ili mpatange kube bandu bu lumuli.” Kuboka pa kulongela malobe genia, Yesu ngajabula nu kujoba kutaali na ngweto. ");
INSERT INTO nnq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iganukube Yesu akalaya iingi yi ikobo yenie nnongi jabe, angweto bunhwaminije. ");
INSERT INTO nnq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yene lilobe lyalongila Nnondoli Isaya ngagatimia, “Angwana, ngabene abaamini nhwalo gwito? Na uwecho gwa Angwana ubonikini kubeneke?” ");
INSERT INTO nnq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yene baotwije kuamini, na Isaya ngalenga kabele, ");
INSERT INTO nnq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nnoongo ateila babe injwilii mio gabe, bateilinge ajinga, bakalolangaje kwa mio gabe, bakamanyaje kwa malango gabe, na bakamujilangaje, alenga Nnoongo, kupa nalamiange.” ");
INSERT INTO nnq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya ngalenga malobe gena magambu ngakibona kibumo cha Yesu, ngalenga mialo jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ata nyenie, akiilongoi ajingi ba Akayahudi ngabanhwamini Yesu. Nambu magambu ga Mafalisayo bannyeketilingije pukongolou kukujogopa kata kabenga muiteba yukugongalela. ");
INSERT INTO nnq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bapala kupata kibumo ku bandu kuliko kupata kibumo na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kiboka cha pena Yesu ngalenga kwa lilobe likolo, “Mundu ojwaamini nenga, aamini netuje, ila anhwamini ojwandumite. ");
INSERT INTO nnq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ojwa amona nenga amona ojwandumite. ");
INSERT INTO nnq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nenga nga lumuli, nane inke padunia pano ibe boa abaamini bakabe mulubenduje. ");
INSERT INTO nnq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ojwagajoa malobe gango nambu kugakamulaje, nenga nunhwukumuje, maana ikila padunia kuhukumuje ila kukombola. ");
INSERT INTO nnq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jwanga gakamula malobe gango akweti jwa kunhwukumu. Lilobe lyale lyanongilage lela nga akimu jwabe lichoba lya kupela. ");
INSERT INTO nnq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nenga nongila ku amuli jango namweneje ila Awawa abandumitage nga abaamulicha nonge nike na nengi nike. ");
INSERT INTO nnq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nane manyi amuli jabe jileta bwomi gwa machoba goa pangapela. Bai neenga nenga gagatu gabanagila nenge.” ");
INSERT INTO nnq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Likaiga lichoba limwe kube mpapala gwa Pasaka kujingila, Yesu ngamanya kube kingobu chakwe chukuboka padunia nukujenda kwa Awawa kiike. Akiba bapaile kila kingobu bandu bakwe ababi padunia bapailinge mpaka kupela. ");
INSERT INTO nnq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu na akinapunji bakwe bakiba batamite kulye ndalilo. Mmaja akiba anyeile Yuda, mwana jwa Simoni Isikalioti, mawacho ga kung'aluka Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu amanyi awamundu bankamwie madalaka goa, nukube jweno aboka ku Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bai ngaboka penia pa mecha, ngabeka umbwega lutando lwakwe, ngatola kitambala nukukiundika mukibuno. ");
INSERT INTO nnq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kuboka penia ngajela maache muntungati, ngatumbu kajelea makongono akinapunji bakwe nukuungula nikitambala echi akiundike. ");
INSERT INTO nnq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bai nganhwikili Simoni Petulo, jwombe Petulo ngalenga, “Angwana, mwe mpa kunyelea neenga?” ");
INSERT INTO nnq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu ngajanga, “Echandenda ngoe mikimanyije, nambu mammanya mwenekandae.” ");
INSERT INTO nnq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulo ngannengela, “Mwe unyeleaje makongono!” Yesu ngajanga, “Anda nukunnyeleaje mme nanengaje pamwe kabele.” ");
INSERT INTO nnq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulo nganyanga, “Angwana makanyelea makongono tuje, unyeleye na maboko gango na mutwe uyo.” ");
INSERT INTO nnq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ngannengela, “Ojwa jomwi kujoga apaligwije ukuya ila makongono gambu abi chwapi mmele gwoa, mangweto mmi chwapi nambu mmoaje.” ");
INSERT INTO nnq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ammanyi ojwapakung'aluka, nga maana alenga, “Mmoaje mammi chwapi.” ");
INSERT INTO nnq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pajomola kajelea makongono nukwinda kabele lutando lwakwe, ngatama pamecha ngabalenge, “bo, mmanyingite genia aganantendelinge? ");
INSERT INTO nnq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mangweto ungema aboli na Angwana, mangweto nnonge chambone, ngapambile. ");
INSERT INTO nnq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bai andane nambi naboli na Angwana nannyeleinge mangweto makongono, na mangweto mpaligwa kujeleana makongono. ");
INSERT INTO nnq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nampilingite kulandanakia ibe mangwetumwe ntendi andi panantendilinge ");
INSERT INTO nnq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nannengelanga kweeli, mmanda nkolongwaje kumpeta nngwana mundu, wala ndundame nkolongwaje kupeta jwajo ojwantumite. ");
INSERT INTO nnq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bai anda mmikumanya genia mammaganga mbaya anda magatendite. ");
INSERT INTO nnq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ganga ganongela gano giinu mmoaje. Ne namaanyi banachagwile. Nambu mpaka oti gatimie Majandiko Machwapi agalenga, ‘Jwajo jwali chakulya chango ang'alambwike.’ ");
INSERT INTO nnq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nenga nannengalinge ilebe yenje ngoe tango nukupitilaje, ibe paibakupitila mpatange kuamini kube ‘nga nenga.’ ");
INSERT INTO nnq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nannenge kweli, ojwampoke jwajo junantuma amboke ne, na ojwamboke nenga bapoke abandumite.” ");
INSERT INTO nnq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pajomola kulonge genia, Yesu ngaechuka umwojo ngachalakicha kulenga, “Nannenge kweli, jumwe kati jinu apakung'aluka.” ");
INSERT INTO nnq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Akinapunji ngabalolana, baotwije kumanya bannonge mmene. ");
INSERT INTO nnq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jumwe kati ja akinapunji, jwombe Yesu ojwakampala muno, akiba atamite papipi na Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petulo ngankinyila nukulenga, “Makonye balonge geniago kwa magambu ga beneke.” ");
INSERT INTO nnq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Napunji jwenio ngaegelela papipi muno na Yesu, ngankonya, “Angwana, nga beneke?” ");
INSERT INTO nnq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu ngajanga, “Jwajo jwambakumpe kipande cha nkate chanelite muchaani, ngajweno.” Bai ngatola kipande cha nkate ngalela muchaani ngampe Yuda mwana jwa Simoni Isikalioti. ");
INSERT INTO nnq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda papokela kipande chenie, Lichetani ngilinnyingila. Yesu ngannengela, “Champakutenda ntende chokwe!” ");
INSERT INTO nnq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nambu akibaje wala jumwe kati jabe ojwatamite pamecha ojwaamanyi alenga genia kwa magambu gani. ");
INSERT INTO nnq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwa magambu Yuda akiba mmeka ela kati jabe, bapemelela Yesu annenge Yuda ajende akaemele eipaligwa kusikukuu, andaje annenge apange chachotichela kwa akaocho. ");
INSERT INTO nnq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bai Yuda apajomola kutola kipande cha nkate chela ngapita panja chokwe. Ikiba kilo. ");
INSERT INTO nnq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kuboka tu Yuda, Yesu ngalenga, “Ngoe Mwana jwa Mundu akoigwe, na Nnoongo akoigwe nkati jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na anda kibumo cha Nnoongo kiekwike nkati ja Mwana, bai mwene Nnoongo apakuekula kibumo cha Mwana nkati jakwe mwene, na matenda genia chokwe. ");
INSERT INTO nnq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Akinangota bango, tango mbi namangweto kwa kingobu chenje tu. Mpakumbala, nambu ngoe nanenge gaga ganalengela achilongochi ba Akayahudi, ‘Kunyenda mangweto kuotoje kujenda!’ ");
INSERT INTO nnq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nampeganga amuli nhyono, mpalane andi panampalanga mangweto. ");
INSERT INTO nnq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Anda mpaline mangweto jika, bandu mabamanya mangweto makinapunji bango.” ");
INSERT INTO nnq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulo ngankonya, “Angwana nyenda ko?” Yesu ngajanga, “Kunyenda kuotoje kungengama ngoe, nambu maungengama mwenakandae.” ");
INSERT INTO nnq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulo ngankonya, “Angwana, kwani kuotoje kunkengama ngoe? Mbi laachi kuwe kwa magambu ginu.” ");
INSERT INTO nnq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu ngajanga, “Bo, mmi laachi kuwe kwa magambu gango?” Nannenge tango na nkokoloko kubekaje mpakungana patatu. ");
INSERT INTO nnq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu ngabalengela, “Makaechukaje mumyojo jinu. Muamini Nnoongo, nhwaminiange na nenga uyo. ");
INSERT INTO nnq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kachabe Awawa bango mubi niitamo ndu, ngoe nyenda kupanga paali kwa ajili jiinu. Ikabi yeneje kabi nanengalinge. ");
INSERT INTO nnq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Anda nyabwile kumpanganakia paali kwa ajili jiinu, mambuja kuntolanga ili namangweto mmegange pambi nenga. ");
INSERT INTO nnq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mijimanyingite ndela ja kujenda kweno kunyenda.” ");
INSERT INTO nnq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi ngankonya, “Angwana, tumanyije ukwannyenda, tupakuotobo kujimanya ndela jene?” ");
INSERT INTO nnq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ngajanga, “Nenga nga ndela, na kweeli na bwomi, abije jwaotwile kujenda ka Awawa ila kukupetela kwango. ");
INSERT INTO nnq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngabalengela, anda umanyi nenga, mammanyi na Awawa bango uyo. Na mpaka ngoe mammanyi, kabe mabweni.” ");
INSERT INTO nnq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo ngannengela, “Angwana, mutulangile Awawa, na twe aputupala.” ");
INSERT INTO nnq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu nganyanga, “Ndamite na mangwetumwe kingobu choeche, na gwe Filipo umanyije? Ojwa mweni neenga babweni Awawa. Nhwotobo kulenga ‘mutulangi Awawa’? ");
INSERT INTO nnq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bo Filipo, kuaminije mbi nkati ja Awawa na Awawa babi nkati jango?” Kibokachapena Yesu ngabalengela akinapunji bakwe, “Malobe ganannenge kwa madalaka gangoje, nambu Awawa bababi nkati jango, bakamu maengo gabe. ");
INSERT INTO nnq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mpaligwa kuamini panenga nenga mbi nkati ja Awawa na Awawa babi nkati jango. Andaje, nhwaminiange kwa magambu ga ilebe yandenda. ");
INSERT INTO nnq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nanenge kweeli, ojwanhwamini apakutenda ilebe yambakutenda nenga, abakutenda ata makolongwa muno, kwa magambu nyenda kwa Awawa. ");
INSERT INTO nnq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na chachoa chela champa kujopa kwa liina lyango mandenda, kupala Awawa balumbigwe nkati ja mwana. ");
INSERT INTO nnq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anda unyopangite chachoa chela kwa liina lyango, mandenda. ");
INSERT INTO nnq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Anda umbailinge makamula Malagilo gango. ");
INSERT INTO nnq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nanenga manajopa Awawa nabenia mabampa jonge jukunnyangata, ojwapakutama na mangweto lemulemu pangapela. ");
INSERT INTO nnq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jweno nga Uhuke jwa kweeli jwa Nnoongo. Dunia kuotoje kumpokela magambu kuotoje kummona wala kummanya. Nambu mangweto mumanyi magambu baigi namangweto na babi nkati jiinu. ");
INSERT INTO nnq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nanekangaje mangweto ukeba, mainka kabele kwinu. ");
INSERT INTO nnq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tango kachoko na jene dunia jimonaje kabele nambu mangweto mammona, na magambu ne namomi, namangweto uyo mamma mammomi. ");
INSERT INTO nnq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lichoba lyale palipa kuika mammanya nenga mbi nkati ja Awawa, na mangwetomwe mi nkati jango, nane nkati jinu. ");
INSERT INTO nnq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ojwapokela amuli jango na kujikengama jweno nga ojwambala nenga. Na ojwambala nenga mapaligwa na Awawa bango na nenga manampala na kukilaya kujweno.” ");
INSERT INTO nnq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda jweno Yuda Isikaliotije, ngannengela, “Angwana, kuotolabo mwe kukilaya kwito nukube kuduniaje?” ");
INSERT INTO nnq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu ngannyanga, “Mundu anda ambaile akengame mapundicho gango, na Awawa bango mabampala, natwe matuika nukutama nabo. ");
INSERT INTO nnq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jwangambala ukengamaje maboulo gango. Nililobe elimilijoina lela ngiti lyangoje, ila lyabe Awawa abandumitage. ");
INSERT INTO nnq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nannengilinge ilebe yene mangobu mbitango pamwe na mangweto. ");
INSERT INTO nnq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nambu Nnyangati, jweno Uhuke jwa Chwapi, jwombe Awawa bapakuntuma kwa liina lyango, mammola kila kilebe nukunkombokelanga yoa einanengalinge. ");
INSERT INTO nnq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nanekela tengela, nampeganga tengela jango. Nampe andi pijitenda duniaje, makabe nambweleje wala kuechuka. ");
INSERT INTO nnq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nganyoanga panannengala, ‘Ne ndendakujabula, mambuja kabele kwinu.’ Makambailinge kabi mmi nalaa, kumagambu nyenda ka Awawa, benia akolongwa kumbeta ne. ");
INSERT INTO nnq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nannengelanga genia ngoe tango nukupitilaje, ibe pagapakupitila mme unhwamininge. ");
INSERT INTO nnq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nonge kabeje namangwetomwe ilebe ijingi kumagambu nkolongwa jwa dunia jeno atendakuwika, akwetije makakala kumbeta ne. ");
INSERT INTO nnq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nambu dunia jipaligwa kumanya napala Awawa, ngakwamana ndenda kila kilebe andi Awawa pabaamuliche. “Nnyemange tuboke pamba! ");
INSERT INTO nnq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nenga nzabibu gwa kweli, Awawa bango alemi ");
INSERT INTO nnq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila lutambi nkati jango lwangapambika ngoko benia kuluboya, nakila lutambi olupambike kuluunila kupala lupambike muno. ");
INSERT INTO nnq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mangweto mwe mmilingite chwapi kwa magambu ga nhwalo go gunanengile. ");
INSERT INTO nnq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ntamange nkati jango, nane mandama nkati jinu. Andi yene lutambi kuotwaje jika jakwe kupambika ngoko nukutamaje munkongo gwa zabibu, na yene uyo mangwetomwe kuotwaje kupambika ngoko nukutamaje nkati jango. ");
INSERT INTO nnq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nenga nga nzabibu, mangweto mwe ndambi. Ojwatama nkati jango na ne anda mbi nkati jakwe jweno mapambika ngoko majingi. Mana na neje, nhwotolangaje kutenda chachoa chela. ");
INSERT INTO nnq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundu jwajoa jola anda nukutamaje nkati jango, kunneke panja andi lutambi nu kujoma. Bandu kulokota ndambi andi yene nukuilekela pamwoto itinike. ");
INSERT INTO nnq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Anda ntamite nkati jango na malobe gango anda gatamite nkati jinu, bai, nnyopechachoa chela mampata. ");
INSERT INTO nnq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kibumo cha Awawa bango kibonekane anda mpambike ngoko majingi nukube akinapunji bango. ");
INSERT INTO nnq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nenga nampailinge andi Awawa pabambaile nenga, ntamanga mumapalano gango. ");
INSERT INTO nnq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Anda nkamwile amuli jango mantamanga mumapalano gango, andi yene nenga pangamwile amuli ja Awawa nukutama mumapalano gabe. ");
INSERT INTO nnq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nannengile ilebe yenie mbala laa jango jibe nkati jinu nalaa jinu jikomale. ");
INSERT INTO nnq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jenje nga amuli jango, mpalane andi panampala mangweto. ");
INSERT INTO nnq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gabije mapalano makolongwa muno kupeta mapalano ga mundu jwaboya bwomi gwakwe kumagambo ga kaganja mundu. ");
INSERT INTO nnq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mangwetomwe makaganja bango anda nteilinge ganunhwamulicha. ");
INSERT INTO nnq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mangwetomwe nankema kabeje makapakachi, mana mpakachi kumanyaje gabatenda angwana mundu, nambu nenga nankema mangweto makaganja kumagambu nanandulile goa ganajoa kuboka ka Awawa bango. ");
INSERT INTO nnq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mangweto unjagulingeje ne, nambu ne nanchagwile nukuntuma nnyende mukapambike ngoko, ngoko agalama, bombe Awawa bampe chachoachela champa kujopa kuliina lyango. ");
INSERT INTO nnq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bai amuli jango kwinu nga jenje, mpalane. ");
INSERT INTO nnq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Anda dunia janchimwa mangweto, nkombakela jinjimwite oti nenga. ");
INSERT INTO nnq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Makabi mabandu bapadunia, dunia kabi jimpaile andi bandu baakwe. Nambu kwa magambu mangweto bapaduniaje, ila ne nanchagulinge kuboka padunia, kwa magambu genia dunia janchimwanga. ");
INSERT INTO nnq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nkombokelange aganannengelinge, ‘Mmanda nkolongwaje kumpeta nngwanamundu.’ Anda bandu bambotike ne, bapakumpotekanga namangweto uyo, anda bandu bagapenekia maboulo gango, mabagapenekia naginu uyo. ");
INSERT INTO nnq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nambu genia goa mabantendela mangweto kwa magambu mangweto mwe bango, magambu bumanyije jwajo ojwa ndumite. ");
INSERT INTO nnq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nakabi nukuwikaje nukulonge nabo, bakabinagoje mabaja, nambu ngoe kuotwaje kukikoola kube banga mabaja. ");
INSERT INTO nnq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Abanjimwa nenga, bachimwa Awawa bango uyo. ");
INSERT INTO nnq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ikabi nukutendaje kwabe eibi yangatenda mundu jwajotejola, bakabije na mabaja, nambu ngoe baloile gandendite ngabanjimwanga na Awawa bango uyo. ");
INSERT INTO nnq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nga kwamaana gaga gagaandikigwe Mumalagilo gabe kweli, ‘Batekunjimwanga pangamalemwa.’ ");
INSERT INTO nnq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Papakuika nnyangati, jwenio Uhuke jwa Nnoongo, jwambakuntuma kwinu kuboka kwa Awawa, jweno Uhuke ba Nnoongo, apakunjalakicha ne. ");
INSERT INTO nnq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Namangwetumwe uyo maunjalakicha kwa magambu makiba na ne pamwe pitumbala. ");
INSERT INTO nnq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nannengila genia kupala mikijilekaje imani jinu. ");
INSERT INTO nnq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bandu bapakumenga mangweto mumajumba gabe ga kugongalela. Kabele kingobu kitenda kuika iba kila ojwapakunkoma mangweto akita atenda yapala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bapakuntenda ilebe yene kwa magambu bamanyije Awawa, na bammanyije ne. ");
INSERT INTO nnq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bai nannengile ilebe yene ibe kingobu chakwe echikipakuika nkombokele nanengile. “Nanengilingeje ilebe yenje kuboka pitumbulaga magambu nakiba pamwe na mangweto. ");
INSERT INTO nnq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nambu ngoe nanyendelela jwajo ojwandumite, na abije na jumweje jwangonya nyenda ko? ");
INSERT INTO nnq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwa magambu ngoe nanengelinge ilebe yene, mmilingite echu mumyojo jinu. ");
INSERT INTO nnq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nambu nanengelinge kweli, mbaya jinu mangweto ne nyabule, maana anda nukujabuje Nnyangati jo aikaje kwinu. Nambu anda nyabwile, manantuma kwinu. ");
INSERT INTO nnq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jwombe apapakuika apakalenge kweli bandu bapadunia mabaja gabe, na gapala Nnoongo na hukumu jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Balemwanga kwa magambu ga mabaja, babi kunhwaminije ne. ");
INSERT INTO nnq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Balemwanga kwa magambu ga agapala Nnoongo, kwa yene nyenda kwa Awawa, mangweto umonangaje kabele, ");
INSERT INTO nnq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","na balemwanga ku nhwalo gwa hukumu, nkolongwa jwa dunia jenje ahukumigwe. ");
INSERT INTO nnq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mbinago nduu gu kunengela, nambu ngoe kuotoje kugakamula. ");
INSERT INTO nnq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nambu apapakuika Uhuke jwa kweli mabalongelea kukweli joa, mana ailenga kwa madalaka gakweje, nambu ainengala agapakujoa, na apakunenge ilebe ipakuika. ");
INSERT INTO nnq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jweno apakungoya nenga kwa magambu apakunnengela gaga agapakupata kuboka kwango. ");
INSERT INTO nnq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yoa ibakweti Awawa nga yango, ngamana nengita jweno Uhuke ba Nnoongo apakunenge gaga agapakupata kuboka kwango. ");
INSERT INTO nnq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kingobu tango kachoko mangwetumwe umonaje, nakuboka pakingobu kachoko maumona kabena!” ");
INSERT INTO nnq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Penia akinapunji bakwe bange ngabakonyana, “Babi na mana gako pabatulenge, ‘Tango kingobu kachoko mangweto umonaje, na kuboka pakingobu kichoko maumonage?’ Kabe alenga, ‘Nukube nyenda ka Awawa!’ ” ");
INSERT INTO nnq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bai ngababe bakakonyana, “Babi na mana gako pabalenga, ‘Tango kingobu kichoko?’ Tumanyije echa longela.” ");
INSERT INTO nnq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu ngamanya bapaila kunkonya, bai ngabalenge, “Bo, nkonyana magambu ganongila gala, ‘Tango kingobu kachoko mangweto umonaje, na kuboka pakingobu kachoko maumonanga kabele?’ ");
INSERT INTO nnq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nanenge kweli, mangweto mpakuguta nu kokaleka, nambu dunia jipakube na laa. Mpakuwechuka nambu kuwechuka kwinu kuba kugalambuka kube laa. ");
INSERT INTO nnq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kingobu amama pabakikombola mwana balola kuwechuka magambu ga kubinia kuiike, nambu anda bajomwi kukikombola kukukomboke kabeleje kubinia ko kumagambu ga laa kube mundu abelwike padunia. ");
INSERT INTO nnq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mangwetu mwe uyo mmimukuwechuka ngoe, nambu manunhwikalila kabele, namangweto mpakube na laa mumyojo jinu, na laa jene abije mundu ojwapakuboya kwinu. ");
INSERT INTO nnq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Lichoba lyene minyopaje chachoa. Kweli nanenge, chachoa champakajopa Awawa kuliinalyango, mabampa. ");
INSERT INTO nnq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka ngoe manajopaje chachoa kuliina lyango. Nnyopange mangweto mampata kupala laa jinu jilimbe. ");
INSERT INTO nnq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nanengila ilebe yenje kukichobo nambu kingobu makiika penia nonge kabeje kukichobo, ninengela ndaa ga Awawa. ");
INSERT INTO nnq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lichoba lyene mpakujopa kuliinalyango, na nanengije mbakajopa Awawa kumagambu ginu mangweto, ");
INSERT INTO nnq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","mana Awawa bampala mangweto, kumagambu mangweto umbala ne na nhwamini moka ku Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nenga ngamoka ka Awawa, nganhika padunia nangoche ndenda kujileka dunia na kubuja ka Awawa.” ");
INSERT INTO nnq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bai akinapunji baakwe ngabanenge, “Hoo! Ngoe nnenga kindema muno panga kichobo. ");
INSERT INTO nnq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ngoe tumanyi mwe mmanyi kila kilebe, kibije kilebe chukunkonya mundu jwajoa, na yene tuamine mmoka ku Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu ngaba janga, “Bo, nhwamininge ngoe? ");
INSERT INTO nnq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kingobu kitenda kuika, kabe kiike, iba mangweto mmoa mmaganga mpwilikine kila mundu kachakwe na ne uneka jika jango. Pibile, nambu ne jika jangoje, magambu Awawa babi pamwe na ne. ");
INSERT INTO nnq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nanengelinge ile yenje ili mmegange na tengela kukulondana nanenga. Dunia jipakumpeganga kulaga, nambu nhwimbililange! Ne nijiotwile dunia!” ");
INSERT INTO nnq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu apajomola kulenga genia, ngalola kunani kumbengu, ngalenga, “Awawa, mangobu gaike! Mankoleye Mwana jwinu na jweno Mwana apate kunkoleya. ");
INSERT INTO nnq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Andi yene ngamampe mwanajwinu kinala kubandu boa, kupala mapegange bwomi gu machoba goa pangapela kubenia boa abamapile. ");
INSERT INTO nnq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nabwomi gwa machoba goa pangapela nga gongono, bummanye mwenga mammi jika jinu Nnoongo jwa kweli, nukummanya Yesu kilisto oju muntumite. ");
INSERT INTO nnq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nenga nankolie pamba padunia, ngamilishe liengo eliumbile ndende. ");
INSERT INTO nnq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ngoe, Awawa, ungoleye nnongi jinu kukibumo cha ngweti tangu nukupanganaje dunia. ");
INSERT INTO nnq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nantendite mmanyikane ku bandu baba abaumbile kuboka kudunia. Bakibanga bandu binu, nane ngumbe babe bango. Na benia bilikamulinge lilobe linu. ");
INSERT INTO nnq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ngoe bamanyi kila echiumbile kibokita kwinu. ");
INSERT INTO nnq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nenga napilangite malagilo agaumbile, na benia bapokalinge, bamanyangite kweli mokite kwinu, na baamininge mwenga makande kunduma. ");
INSERT INTO nnq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Najope angweto, nijijope duniaje, nambu najopela bumbile, gambu nga binu. ");
INSERT INTO nnq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Goa gambinago nga ginu, naginu nga gango, na kibumo chango kibonakine mubenia abaumbile. ");
INSERT INTO nnq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na ngoe nhika kwinu. Mbikabeje padunia nambu angweto babi padunia. Awawa Bachwapi! Kwa makakala ga liina linu eliumbile, chonde malolelange gwicho babegange kilebe chimwe. ");
INSERT INTO nnq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Apanakibanabo, nenga nganalolelanga gwicho kumakakala ga liina linu liumbile. Nenga nalolile, abije ata jumwe jwajomwike. Nambu jwajo jumwe mwana jwa obite ili Majandiko Machwapi gatimie. ");
INSERT INTO nnq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bai ngoe nhika kwinu, nanongile ilebe yenje padunia, ili baotolange kutama kwambone mulaa jango. ");
INSERT INTO nnq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nenga napilangite malagilo giinu, na bandu bapadunia ngabaachimwanga, magambu angweto bapaduniaje, andi yene nenga napadunia panoje. ");
INSERT INTO nnq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nyopa maboyange paduniaje, nambu nyopa malolele na jwajo Mmaja. ");
INSERT INTO nnq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Angweto bapaduniaje andi nenga nambi bapikilamboje. ");
INSERT INTO nnq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bajeguye kwa kweli, lilobe linu nga kweli. ");
INSERT INTO nnq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Anda yene ungingita padunia, nane uyo natumangite padunia. ");
INSERT INTO nnq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na kwa magambo gabe namwene nikilumike kupala namangweto uyo bajeguigwe mukweli. ");
INSERT INTO nnq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Najopilanga angwetotuje, nambu najopelanga na bange bandu abapa kuamini nenga kuboka mulilobe lyabe. ");
INSERT INTO nnq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nyopa ili booa babe kilebe chimwe. Awawa! Nyopa babe nkati jito, andi nyene mwe pammile nkati jango nane nkati jinu. Nyopa babe kilebe chimwe ilidunia jipate kuamini mwenga maungingite. ");
INSERT INTO nnq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neenga napilangite kibumo uchache chamamba nenga, ili babe kilebe chimwe andi twe tubi kilebe chimwe. ");
INSERT INTO nnq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nenga mbe nkati jabe namwe mme nkati jango. Nanyopa malimbie na kube kilebe chimwe, ili dunia jimanye mwenga nte kunduma na ntenda kapala angweto andi paumbala nenga. ");
INSERT INTO nnq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Awawa! Mbala aba abaumbile, babe pamwe nane penia pambile, ili bakibone kibumo chaumbile, kwa magambu mambai tango nukupanganaje dunia. ");
INSERT INTO nnq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Awawa Bambone! Dunia jummanyije, nambu ne numanyi, nangweto bamanyi mwenga maundumite. ");
INSERT INTO nnq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nammekite umanyikane kwabe, manyendekea kutenda nyene, ili mapalano gaminago kwango ube nkati jabe, nane mbe nkati jabe.” ");
INSERT INTO nnq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu apalongela genia, ngajenda kwiye ja lukemba olukemigwa Kidiloni, najweno pamwe nakinapunji bakwe. Paali penia pakiba na bositani, najweno Yesu ngajingi mweno pamwe nakinapunji bakwe. ");
INSERT INTO nnq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, ojwang'aluka Yesu, apamaanyi paali pena, kila kingobu Yesu akongana na akinapunji bakwe kweno. ");
INSERT INTO nnq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bai Yuda ngato kikundi cha manjolinjoli na akalenda kuboka kwa akakung'i akolo na Mafalisayo, ngaika nabo pabositani bapotwi muli, niimbelembele na chilaa. ");
INSERT INTO nnq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, kongo akamanya goa agapakumpata, ngapitila, ngabakonya, “Mampalanga meneke?” ");
INSERT INTO nnq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nabenia ngabannyangula, “Yesu jwa ku Nazaleti!” Yesu ngabalengela, “Nganenga.” Yuda ojwa akanng'aluka Yesu, akiba ajemite penia pamwe nabo. ");
INSERT INTO nnq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bai Yesu apabalengelinge, “Nganenga,” ngababuja unyuma, ngabagweganga pae. ");
INSERT INTO nnq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu ngabakonya kabele, “Mampala mene?” Ngabannyangula, “Yesu jwa ku Nazaleti!” ");
INSERT INTO nnq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu ngabalengela, “nanengalinge nganeenga. Anda umbala nenga malekange angweto bajabulange.” ");
INSERT INTO nnq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Alenga genia ili gapate kutimia gaga agaakalenga, “Baba abaumbile nunhwoiteje ata jumwe.” ");
INSERT INTO nnq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petulo akiba na upanga, bai ngaucholomola, nganhweketa lichikilo lya kalelo mmanda jwa akung'i akolo. Mmanda jwenio akemigwa Malukusi. ");
INSERT INTO nnq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bai Yesu ngannenge Petulo, “Mmuye upanga gwinu muala. Bo, nakanyweje kikombe cha matecho echibambi Awawa?” ");
INSERT INTO nnq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kikuta cha akalenda, na akolongwa babe na akalenda ba Akayahudi ngabampuki Yesu, ngabantaba ");
INSERT INTO nnq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ngabampeleka oti kwa Anasi. Anasi nga akimundu analome ba Kayafa, benia bakiba Akung'i Akolongwa chaka chene. ");
INSERT INTO nnq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jwenio Kayafa ngaojwa balengela Akayahudi nga mbaya mundu jumwe awe kumagambu ga bandu. ");
INSERT INTO nnq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petulo pamwe na napunji jonge ngabankengama Yesu. Napunji jonge jweno akate kumanyikana kwa akung'i akolo, uyo ngajingi pamwe na Yesu unyumba panchana pa akung'i akolo. ");
INSERT INTO nnq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nambu Petulo akiba ajemite panja, papipi na nniango. Bai napunji jonge jweno ojwakiba amanyikine kwa akung'i akolo ngapita panja ngalonge na mmanda munkege, nnende nniango, ngannyingia Petulo unyumba. ");
INSERT INTO nnq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Munkege nnenda jwa nniango ngankonya Petulo, “Bo, namwe uyo nga bamwe ba akinapunji ba mundu ojojo?” Petulo ngannenge, “Neje!” ");
INSERT INTO nnq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Akabanda na akalenda bakiba bakoite mwoto kumagambu pakiba na malili, ngaba jotanga mwoto. Jwombe Petulo akiba ajemite pamwe nabo ajota mwoto. ");
INSERT INTO nnq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bai Akung'i Akolongwa ngaba nkonyeke Yesu nhwalo gwa akinapunji bakwe na maboulo gakwe. ");
INSERT INTO nnq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu ngannyangula, “Nongile na kila mundu goa pukongolou. Kila kingobu mbundiche munyumba ja kunyopa Nnoongo na munyumba ja Nnoongo, paali apabakongana Akayahudi boa, na wala nengitije chachoti chela kwa kuiya. ");
INSERT INTO nnq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwa nike ungonyekea nenga? Makonyekea baba abajoaninge nike nalengelinge. Angweto bamanyi aganalengelinge.” ");
INSERT INTO nnq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu palenga genia nnendei jumwe ojwa kiba ajemite penia ngamputa likopi nukulenga, “Bo, nga apamajanga akung'i akolo?” ");
INSERT INTO nnq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ngannyanga, “Anda nengite mabaja, nchalakiche ubaja gweno, nambu anda nengite gambone, mboni umbuta?” ");
INSERT INTO nnq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bai Anasi ngampeleka Yesu abi atabigwe, kwa akung'i akolo Kayafa. ");
INSERT INTO nnq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Petulo akiba penia ajota mwoto. Bai ngabankonya, “Bo, namwe uyo ngabamwe ba akinapunji bakwe?” Jwenio ngakana nukulenga, “Neje!” ");
INSERT INTO nnq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jumwe jwa akapakachi ba Akung'i Akolongwa, nnongo gwa ojwaeketigwa lichikilo na Petulo, ngankonya, “Bo, mwe namwenije kukijongo pamwe na jwenio?” ");
INSERT INTO nnq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petulo ngakana kabele, kingobutu nkokoloko ngabeka. ");
INSERT INTO nnq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bai pakiba kilokilo, ngabantolanga Yesu kuboka kwa Kayafa, ngabampeleka kuboma. Nangweto kupala baotolange kulye Pasaka, bajingilingije unyumba ja boma bakanangita kube nuchaapu. ");
INSERT INTO nnq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kwa nyene, Pilato ngapita panja, ngalenga, “Mmilingiti na machitaka gani na mundu jonjo?” ");
INSERT INTO nnq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ngabannyangula, “Anda jonjo akabi na malemwaje kabi tunetitije kwinu.” ");
INSERT INTO nnq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato ngabalengela, “Aja, muntolange mmenimangweto, maka nhwukumu ukengama na malagilo ginu.” Akayahudi ngaba nnyanga, “Twe tukwetije amuli ja kunkoma mundu jwajotijola.” ");
INSERT INTO nnq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Itendigwa nyenie japata kulenganila malobe agalenga Yesu kulaya apakuwe kiwe nike. ");
INSERT INTO nnq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ngajingi kabe unyumba muboma, ngankema Yesu nukunkonya, “Eti mwe ngama ngwana ba Akayahudi?” ");
INSERT INTO nnq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu ngannyanga, “Bo, genia nga malobe ginu au bange batennengela mialo jango?” ");
INSERT INTO nnq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ngannyangula, “Bo, ne Nayahudi? Bandu binu na akakung'i bannetite kwangone. Ntendite nike?” ");
INSERT INTO nnq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu ngannyanga, “Kingwana chango chapa dunia jenjeje. Anda kingwana chango chakabi cha dunia jenje, akapakachi bango kabibambutanile nakabekigwaje mumaboko ga Akayahudi. Nambu ngoe kingwana chango nga chapambaje.” ");
INSERT INTO nnq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Penia Pilato ngannengela, “Bai mwe nga Mangwana?” Yesu ngajangula, “Mwe nnengite kutenda nenga Nangwana. Nenga melwike kwa magambu genia, na magambu genia nhike padunia nijichalakiche kweli ku bandu kila mundu jwabi mukweli jenie kumbenikia.” ");
INSERT INTO nnq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato ngannenge, “Kweli nga nike?” Pilato apalenga genia, ngabajendele kabele Akayahudi panja, ngabalengela, “Nenga mbikulolaje lilemwa lyalyoa kwakwe. ");
INSERT INTO nnq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nambu lubi lukobo nenga kunnekeke mpungwa jumwe mangobu ga Pasaka. Bai mpalanga nannyogolelange Nngwana jwa Akayahudi?” ");
INSERT INTO nnq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Penia ngabatenda manjega, “Ije! Jwenio je, manyogolele Balaba!” Balaba jwenio akiba mpoki. ");
INSERT INTO nnq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bai Pilato ngaamulicha Yesu atoligwe aputigwe iboko. ");
INSERT INTO nnq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Manjolinjoli ngagaloka ulembalemba gwa miba, ngabankwindiya umutwe, ngagankwindiya ngobo ndandamau jibakwindanga akangwana. ");
INSERT INTO nnq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kunhwikalila nnongi jakwe nukulenga, “Shikamoo, Angwana ba Akayahudi!” Ngabamputa makopi. ");
INSERT INTO nnq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ngapita panja kabele, ngabalengela, “Nnolange, nanneta panja kwinu, mmegange mmanyi neenga nagabwenije malemwa gagoa kwakwe.” ");
INSERT INTO nnq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bai Yesu ngapita panja, akwindite ulembalemba gwa miba nilijou libakwindanga akangwana. Pilato ngabalengela, “Nnolange! Mundu jwene nga ojo.” ");
INSERT INTO nnq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Akakung'i akolo na akalendei pabammona ngabatondobea lilobe, “Mammambe munchalaba! Mammambe munchalaba!” Pilato ngalenga, “Bai mantolange, mmene mangweto makammambe munchalaba, magambu ne nagabwenije malemwa gagoa kwakwe.” ");
INSERT INTO nnq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Akayahudi ngabannyanga, “Twenga tukweti Malagilo, nakagakengama magambu ga Malagilo genia mpaka awe, magambu akitenda Mwana jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato apajoa malobe genia ngajogopa muno. ");
INSERT INTO nnq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bai Pilato ngajingi muboma kabele, ngankonya Yesu, “Mmoka kole mwe?” Nambu Yesu ajangitije. ");
INSERT INTO nnq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato ngannengela, “Kulongelaje na nenga? Bo, umanyije kutenda ngweti kinala chu kunnekekea ni kinala chu kummamba?” ");
INSERT INTO nnq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu ngajanga, “Makabije na kinala chachoa kwango, akabi Nnoongo nukumpeje. Magambu genia, jwajo ojwangamuye ne kwinu abi na mabaja makolongwa muno.” ");
INSERT INTO nnq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato apajoa genia, ngapala ndela jukunnekekea, nambu Akayahudi ngabachobela manjega, “Anda manekakie mundu jonjo, mwe maganjaje na nkolo jwa kilambo cha Loma. Kila mundu ojwakitenda nngwana ankana nkolo jwa kilambo cha Loma!” ");
INSERT INTO nnq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato apajoa malobe geniago, nganneta Yesu panja, ngatama pikitebwe cha hukumu, paali papakemigwa “Sakafu ja Maganga” kwa kilonge cha Akaebulania, ikonda Gabatha. ");
INSERT INTO nnq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ikiba kingobu cha nalumu, lichoba lya kupangania Pasaka. Pilato ngabalenge Akayahudi, “Jwenio Nngwana jwinu!” ");
INSERT INTO nnq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Angweto ngabatondobea lilobe, “Mankome! Mankome! Mamambe munchalaba!” Pilato ngabakonya, Bo, nammambe nngwana jwinu? Akakung'i akolongwa ngabajanga, “Twenga tukwetije angwana nambu nkolongwa jwa Loma tu!” ");
INSERT INTO nnq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Penia, Pilato ngankamuya Yesu mumaboko ga Akayahudi kupala bammambe munchalaba. Bai ngabantola Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na jwenio ngapita panja kongo apotwi nchalaba gwakwe kujenda paali papakemigwa “Kitongo cha Mutwe” Kwa kilonge cha Akaebulania ikonda Goligota. ");
INSERT INTO nnq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Penia nga pabammamba Yesu, uyo bakabamba bandu bange abena, jumwe kingonu cha kalelo na jonge kingonu chakwe cha kangeja, Yesu panakati jabe. ");
INSERT INTO nnq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato ngaandika litangacho ngabeka panani ja nchalaba. Echibaandika, “Yesu ju Kunazaleti, Nngwana jwa Akayahudi.” ");
INSERT INTO nnq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Akayahudi ajingi ngabachoma litangacho lyene, mana paali penia pabambigwa Yesu pakiba papipi na Panyini. Kabe litangacho lyene likaandikigwa kwa kabila ja Kiebulania, Kilatini, na Kigiliki. ");
INSERT INTO nnq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bai akakung'i akolo ngabannenge Pilato, “Makaandikaje, ‘Nngwana jwa Akayahudi ila, Mundu jwenio alengita, nenga nangwana ba Akayahudi.’ ” ");
INSERT INTO nnq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato ngajanga, “Gaandike, andike!” ");
INSERT INTO nnq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Manjolinjoli kuboka pa kumamba Yesu, ngabatolanga ngobo yakwe, ngababagana mapungu ncheche, lipungu limwe kila linjolinjoli. Ngabatolanga na kanju jaakwe, kanju jene jikiba ilokigwe kukipande chimwe tu, janga nchono. ");
INSERT INTO nnq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bai genia manjolinjoli ngagabeka machabuli, “Takapachulaje, nambu tutendi kiumbuumbu jibe jabene.” Nhwalo gweno utendigwa ili gatimie Majandiko ga Machwapi gagalenga, “Ngababagana kikwindo chango, na ngobo yango ngabapigi kula.” Bai yene ngapagatenda manjolinjoli. ");
INSERT INTO nnq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Papipi na nchalaba gwa Yesu bakiba bajemangite Amamundu, na alombo ba amamundu, Maliamu aanaba Kilopa, na Maliamu Magidalena. ");
INSERT INTO nnq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu pababona amamundu, na papipi nabo ajemite jwajo napunji jwampaile, ngabalenge amamundu, “Amama, nnola, jweno nga mwana gwinu.” ");
INSERT INTO nnq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kuboka penia nganenge napunji jo, “Nola, benia nga amabinu.” Na kuboka kingobu chenie napunji jo ngabantola atame kachabe. ");
INSERT INTO nnq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kuboka penia Yesu ngalola goa gatimie, na ili Majandiko Machwapi gapate kutimia, ngalenga, “Nola nyota.” ");
INSERT INTO nnq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Penia pakiba na ntungati utweli siki. Penia ngabachwika litonji musiki ngababeka mulutela lwa isopo, ngabammeka pakano. ");
INSERT INTO nnq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu pachwena siki jenie, ngalenga, “Galenganile!” Kuboka penia ngakotima mutwe, ngajomoka. ");
INSERT INTO nnq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ikiba ijumaa, lichoba li kupangana. Yene kukupala mibele jikatamaje mumichalaba lichoba li Kupomalela, mana lichoba lyene li Kupomalela likiba likolongwa, Akayahudi ngabanyopa Pilato makongono ga benia ababambigwa gatwekuligwe na mibele jabe jiboigwe. ");
INSERT INTO nnq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bai manjolinjoli ngagajenda, ngagatweku makongono ga jwajo mundu ju kutumbula na jwajo jwa pili benia bakiba bakabambigwa pamwe na Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nambu pabanhwikalila Yesu, ngabalola awile, ku yene bantunwije makongono. ");
INSERT INTO nnq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Linjolinjoli limwe ngalyampojola pulubao kwa nkuki, ni kingobu tu ngijipita myai na mache. ");
INSERT INTO nnq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mundu ojwaubweni nhwalo gwenio achalakiche kupala mangweto mpate kuamini genia galongile nga ga kweli, kabe benia bamanyi balonge kweli. ");
INSERT INTO nnq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nhwalo gweno utendigwa kupala Majandiko Gachwapi galenganile, “Kubeje wala kiupa chakwe chimwe chikipa kutwekuligwa.” ");
INSERT INTO nnq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kabe Majandiko gange galenga, “Bandu mabannolakea jwajo jubampojwile.” ");
INSERT INTO nnq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kuboka pa genia, Yusufu ju kilambo cha Alimatayo, ngannyopa Pilato ampe mmele gwa Yesu. Yusufu akiba napunji jwa Yesu, nambu jwachili, gambu bajogopa akiilongoi ba Akayahudi. Bai, Pilato ngajeketela. Yene Yusufu ngajenda, ngautola mmele gwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jwombe Nikodemo jweno akanyendele Yesu machoba ga unyuma kilo, ngaika kongo apotwile kiwanga cha mauta ga manemane na ubani kilo salasini. ");
INSERT INTO nnq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bai ngubutola mmele gwa Yesu, ngaubiligila chanda pamwe na ilebe inakunungila andi lukobo lwa Akayahudi machiko gabe. ");
INSERT INTO nnq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Paali penia pabammamba Yesu pakiba kijongo, ni kijongo chenie likiba likabuli liyono tango lyanga nchika mundu. ");
INSERT INTO nnq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bai kumagambu ga maengo ga Akayahudi ga kupanganikia lichoba lya Kupomolela, na kumagambu likabuli libile, ngabammeka Yesu mwenio. ");
INSERT INTO nnq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kindabi ndabi Jumapili, pakiba tango nu lubendu, Maliamu Magidalena ngajenda kulikabuli ngalibona libwe lela liboigwe paniango gulikabuli. ");
INSERT INTO nnq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bai ngajenda lubelo mpaka kwa Petulo na jwajo napunji jonge ojwampai muno Yesu, ngabalengelanga, “Bammoite Nngwana mulikabuli, na tukumanyije kubummekite.” ");
INSERT INTO nnq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petulo pamwe na napunji jongi jola ngabajendanga kulikabuli. ");
INSERT INTO nnq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Boa akabele babutuka lubelo nambu jwajo napunji jongi jola ngabutuka kumpeta Petulo, ngalongelela kuika kulikabuli ko. ");
INSERT INTO nnq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Palita na kulinga mulikabuli ngakibona chanda, nambu ajingije nkati. ");
INSERT INTO nnq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petulo na jweno ngaika akankengama, ngajingila mulikabuli. Mweno ngakibona chanda, ");
INSERT INTO nnq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na kitambala chache chabantabali Yesu umutwe. Kitambala chenie kikiba pamweje na chanda ila kikiba kitundanigwe kibi pajika jakwe. ");
INSERT INTO nnq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kubokapenia jwajo napunji jwalongalile kuika kulikabuli, ngajingi uyo nkati ngalola, ngaamini. ");
INSERT INTO nnq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bakiba tango banamanyaje Majandiko Machwapi gagalenga mpaka ayoke kuboka kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bai akinapunji benia ngababuja kachabe. ");
INSERT INTO nnq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliamu akiba ajemite panja ja likabuli, akaguta. Kongo abi tango akaguta, ngalita nukulinga mulikabuli, ");
INSERT INTO nnq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ngababona akapakachi abele bakwindite ngobo nhuu, batamite pubugonike mmele gwa Yesu, jumwe kumutwe na jonge kamakongono. ");
INSERT INTO nnq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Akapakachi benia ngabakonya, “Amama mbona ntenda kuguta?” Jwombe ngajanga, “Baboyangite Angwana bango, na nukumanyije kababekite!” ");
INSERT INTO nnq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kuboka pa kulenga genia, ngatendabuka unyuma, ngamona Yesu ajemite penia, nambu amanyije kutenda Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu ngankonya, “Amama, nng'uta nike? Mampala meneke?” Maliamu apemelela jweno nnendei jwa bostani, ngannenge, “Angwana anda mwe ntekumoya, unengele kamabekite, nane nakatole.” ");
INSERT INTO nnq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu nganenge, “Maliamu!” Na jweno Maliamu ngatendabuka nganenge Kiebulania, “Laboni!” Laboni mana gakwe Apundichi. ");
INSERT INTO nnq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu nganenge, “Makangamuje, magambu nanajendaje tango kunani ka Awawa. Nambu nnyende kakanuna bango makalengele, ‘Nyenda kunani ka Awawa bango na Awawa binu, Nnoongo jwango na Nnoongo jwinu.’ ” ");
INSERT INTO nnq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yene Maliamu Magidalena ngajenda kwa akinapunji ngabalenge nhwalo gweno babweni Angwana, na banengi genia. ");
INSERT INTO nnq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ikiba kimuyo ja lichoba lyene lya Jumapili. Akinapunji bakiba bakongine pamwe unyumba, ni milyango jakiba jijigaligwe magambu batenda kajogopa achilongochi ba Akayahudi. Bai Yesu ngaika, ngajema panakati jabe, ngabalenge, “Tengela jibe kwinu.” ");
INSERT INTO nnq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pajomola kulenga genia, ngabalaya maboko gakwe na lubao lwakwe. Bai akinapunji bakwe ngabaala mojo muno kabona Angwana. ");
INSERT INTO nnq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu ngabalenge kabele, “Tengela jibe kwinu! Andi Awawa apabandumite ne na ne nantuma mangweto.” ");
INSERT INTO nnq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kuboka penia ngabalumika angweto na kalenge, “Mpokelange Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Anda malekekeinge bandu mabaja gabe balekekeigwe anda nakalekekeje balekekeigwaje.” ");
INSERT INTO nnq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi jumwe jwa akinapunji komi na abena, ojwa kemigwa Mabela, akibaje pamwe na angweto kingobu paika Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bai baba akinapunji bangiba ngabanenge, “Tabweni Angwana.” Tomasi ngabalenge anda, “Nagabwenije mabalilo ga michumali mukubokojabe na kubeka lukonji lwango palibalilo gena, na kubekaje luboko lwango pulubao lwabe, aminije.” ");
INSERT INTO nnq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bai kuboka pa machoba nane akinapunji bala ngabakongana kabele unyumba, bakiba na Tomasi. Na milyango mujigale, nambu Yesu ngaika ngajema panakati jabe, ngalenga, “Tengela jibe kwinu.” ");
INSERT INTO nnq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kuboka penia ngannenge Tomasi, “Nnete lukonji lwinu pamba na magabone maboko gango, nnete lukonji lwinu na meke pulubao lwango. Makabe na mbweleje, nhwuamini!” ");
INSERT INTO nnq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi nganyanga, “Angwana bango na Nnoongo jwango!” ");
INSERT INTO nnq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu nganenge, “Bo, nhwamini magambu umweni? Mbaya abaamini nukumonaje, nambu baamininge.” ");
INSERT INTO nnq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu akalaya iingi yi ikobo ijingi nnongi ja akinapunji bakwe yenge yangaandikigwa mukitabu chenje. ");
INSERT INTO nnq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nambu yenje iandikigwe ili mpate kuamini Yesu nga Kilisto, Mwana jwa Nnoongo, na kukunhwamini mpatange kube na bwomi kwa makakala ga liina lyakwe. ");
INSERT INTO nnq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kuboka pagenia, Yesu ngabapitila akinapunji bakwe kabele umbwega ja lilaba lya Tibelia. Ngaba pitilanga yene, ");
INSERT INTO nnq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulo, Tomasi ojwa kemigwa mabela, Natanaeli, jukukilambo cha Kana Galilaya, ingota ibele ya Zebedayo na akinapunji bakwe bange abele, bakibanga boa pamwe. ");
INSERT INTO nnq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulo ngabalenge, “Nyenda kulopola yamaki.” Bombe ngabannengela, “Na twe tupakulongwana namwe.” Bai ngabajenda, ngabaombe muntumbwi, nambu kilo jene bapatangitije kilebe. ");
INSERT INTO nnq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pitumbula kuchee, Yesu akajema umbwega ja lilaba likolo. Nambu akinapunji bamanyije kutenda jwenio akiba Yesu. ");
INSERT INTO nnq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Bai Yesu ngabakonya, “Achikakombo mpatiteje yamaki?” Ngabajanga, “Tupatitije kilebe.” ");
INSERT INTO nnq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu ngabalengela, “Nnekele lipelele kingonu chakalelo ja ntumbwi, namangweto mampata yamaki.” Bai ngabalekela lipelele nambu ngoe baotwije kuuta kabele, magambu ikajoloka yamaki. ");
INSERT INTO nnq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Penia napunji jwajo ojwapaligwe na Yesu ngannenge Petulo, “Ngangwana!” Simoni Petulo apajowa Ngangwana, ngakitaba ngobo jakwe maana akiba makengele, ngagoloke umache. ");
INSERT INTO nnq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nambu baba akinapunji bange ngabaika kumbwani na ntumbwi kongo bakauta lipelele elitweli yamaki. Bakiba kutaalije na kujomo, ila bakiba kube kipemo cha meta mia jimwe kuboka muluboga. ");
INSERT INTO nnq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pabaika kujomo ngabaubona mwoto gwa makala upambigwe na panani jakwe pabekigwe yamaki na nkate. ");
INSERT INTO nnq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu ngabalengela, “Nnetange pamba yenge yamaki yannopwile.” ");
INSERT INTO nnq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Bai Simoni Petulo ngaombe muntumbwi, ngajomboka mpaka kujomo lipelele lyale elitweli yamaki ngolongolo mia jimwe na amusini na itatu, naiganukube yamaki ndu yene lipelele linyopwikije. ");
INSERT INTO nnq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu ngabalengela, “Nhwikange nnabuke.” Akibaje wala jumwe kati ja akinapunji jwajigite kunkonya Yesu, “Mwe mabene?” Maana bamanyi benia Angwana. ");
INSERT INTO nnq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu ngaika, ngatola nkate, ngabape. Ngatenda uyo na yamakiye. ");
INSERT INTO nnq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Penia pakiba kingobu cha patatu Yesu kapitila akinapunji bakwe kuboka ja kuyoka kuboka kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pabajomola kulye, Yesu ngankonya Simoni Petulo, “Simoni mwana jwa Yohana! Bo, umbaile nenga kupeta ababa?” Petulo ngajanga, “Umo Angwana, umanyi nenga nampaile mwe.” Yesu ngannengela, “Nng'oye yana yamambelele gango.” ");
INSERT INTO nnq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu ngannenge mala ja pabele, “Simoni mwana jwa Yohana, umbaile?” Petulo ngajanga, “Umo Angwana, umanyi nampaile.” Yesu ngannengela, “Nng'oye mambelele gango.” ");
INSERT INTO nnq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu ngankonya mala ja patatu, “Simoni mwana jwa Yohana, Bo, umbaile?” Petulo ngaechuka magambu ankonyite mala ja patatu, “Umbaile?” Ngannengela, “Angwana, mwe mmanyi goa. Mwe mmanyi kutenda mbi kumpala.” Yesu ngannengela, “Nng'oye mambelele gango. ");
INSERT INTO nnq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nannengela kweli, pamakiba makakombo mayobalile kujenda okumpaala. Nambu pampakube machiokolo mpakutondobea maboko ginu, na mundu jonge apakuntaba na kumpeleka kwangapala kujenda.” ");
INSERT INTO nnq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kukulenga genia, Yesu alondola kiu chapakuwe Petulo na kunkoya Nnoongo. Kuboka penia ngannengela, “Ungengame!” ");
INSERT INTO nnq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Penia Petulo ngatendabuka, ngammona jwajo napunji ojwampaile Yesu akakengama napunji jwenio ngajwajo jwatamita papipi na Yesu kingobu cha kulye ndalilo na kunkonya, “Angwana ngabeneke abapakung'aluka?” ");
INSERT INTO nnq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bai Petulo apammona jweno, ngankonya Yesu, “Angwana, ojo bo?” ");
INSERT INTO nnq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu ngannyanga, “Andambai aigale mpaka pambakuika, ganhusu nike? Ungengame!” ");
INSERT INTO nnq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bai nhwalo gweno nguujoanika kubene akangwetojika napunji jwenio ajomokaje. Nambu Yesu annengije kutenda ajomokaje. Ila ngalenga, “Anda mbala aigale mpaka pambakuika, ganhusu nike?” ");
INSERT INTO nnq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jwenio nga napunji jwachalakicha genia nu kugaandika. Na twe tumanyi agalongile nga kweli. ");
INSERT INTO nnq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ibi ilebe yenge ijingi yatendite Yesu. Yene ikaandikigwe yoa, chimwe chimwe, mbemele ata dunia jene jakabi ikwelitije.");
INSERT INTO nnq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mana Teofilo, Mukitabu chango chinalongola kuandika minhalo joa ejakamula Yesu nu kubola kuboka patumbula maengo gakwe, ");
INSERT INTO nnq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka lichoba elyatoligwa kujenda kumbengu. Apakiba tango nukutoligwaje kujenda kumbengu, ngabapeganga malagilo achandundame abapambuligwe kupetela Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ku kingobu cha machoba makomi ncheche kuboka pa kiu chakwe ngabapitilanga pajingi kwa ndela ndu kulaya akiba mmomi. Ngabammona na jwombe ngalongela nabo nhwalo gwa Kingwana cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na apabakongana pamwe, ngabaamulicha yene, “Makabokaje Kuyelusalemu, nambu nnendelange hupo jibalagila Awawa, ejinnyoininga nakalongela. ");
INSERT INTO nnq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana abaticha kwa mache, nambu kuboka pa machoba machoko, mangweto mammatichigwa ku Uhuke jwa Chwapi.” ");
INSERT INTO nnq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Achandundame apabakongana na Yesu, ngabankonya, “Angwana, kingobu chenje nga echampakabukia Kingwana Kuisilaeli?” ");
INSERT INTO nnq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu ngabalengela, “Mangobu na minhalo jenie gabi mukinala cha Awawa bango, na mpaligweje kumanya gapakube lii. ");
INSERT INTO nnq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nambu kingobu Uhuke jwa Chwapi apapakunhwikilila mangweto, mpakube na makakala na mpakube makachaili bango kati ja Yelusalemu na kati ja kilambo choa cha Yudea na Samalia na mpaka kujipei dunia.” ");
INSERT INTO nnq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu kuboka pukulenga genia, boa bakiba bakannolekea, ngatoligwa kujenda kumbengu, ni liunde ngilinhwekelela bakammonangaje. ");
INSERT INTO nnq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Apabakibanga tango bakalolanga kunani kuliunde apakiba akajabula, kingobu ucho ngababonanga bandu abena abakibanga bakwindangite ngobo nhuu bajemangite papipi nabo, ");
INSERT INTO nnq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","nukulenga, “Mangweto bandu ba ku Galilaya! Mboni nnyemangite kongo makalolanga kunani kumbengu? Yesu jwenio ojwatoligwe kuboka kwinu kujenda kumbengu akaika kabe anda apamammona akajenda kumbengu.” ");
INSERT INTO nnq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Penia achandundame ngababujanga Kuyelusalemu kuboke kukitombi echikikemigwa kitombi cha Mizeituni echikibi papipi kuboka kunnyini. ");
INSERT INTO nnq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Apabaikanga kunnyini ngabajingilanga muchumbi kugolofa mubatamangaga, bakibanga Petulo na Yohana na Yakobo na Andulea na Filipo na Tomasi na Batolomayo na Matayo na Yakobo mwana jwa Alufayo na Simoni Zelote na Yuda mwana jwa Yakobo. ");
INSERT INTO nnq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bamba boa ngabajendekea ukongana pamwe nu kugongalela, pamwe na akikege ndu, na Maliamu umamundu Yesu, na akalongamundu. ");
INSERT INTO nnq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Machoba machoko mwenakandae, kukiba na ngongano ja abajeketilinge, boa bakabandakila kuika bandu makomi komi na makomi mabele, na Petulo ngajema nnongi jabe, ");
INSERT INTO nnq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ngalenga, “Akalongabango, ikiba mpaka oti Majandiko ga Chwapi, galenganile, Uhuke jwa Chwapi alongela kupetela Daudi ngalondola minhalo ja Yuda, ojwa balongelea abampukila Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda akiba jumwe kati jito twe mana akate kupembuligwa tukamule pamwe na maengo aga.” ");
INSERT INTO nnq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jwenio ngaemela nng'onda kuloi gwapata kwa ndela mbaja, ngagwe munng'onda gwenio, ngapachuka lutumbo na matumbo gakwe ngagapita panja. ");
INSERT INTO nnq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kila mundu jwa Yelusalemu ngaujoa nhwalo gwenio, na yene kukilonge chabe ngubukema nng'onda gwenio Hakeli Dama, mana gakwe “Nng'onda gwa Myai.” ");
INSERT INTO nnq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petulo ngalenga, “Magambu, iandikigwe mukitabu cha Zabuli, ‘Nyumba jabe jiigala jika, aitamaje mundu jwajoa nkati jakwe.’ Kabe iandikigwe, ‘Mundu jonge atola paali pa liengo lyakwe.’ ");
INSERT INTO nnq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kuyene, ipaligwa tumpambule mundu jumwe kati ja abalongwana natwenga machoba goa Nngwana Yesu apakiba akatama na twenga. ");
INSERT INTO nnq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jwenio apaligwa kube jumwe jwa abakiba munkenga gwito kingobu Angwana apabakiba bakatyanga pamwe natwe, kuboka kingobu Yohana akabaticha mpaka lichoba lyale Yesu apatoligwa kuboka kwito kujenda kumbengu. Jwenio aba pamwe na twe kuchalakicha kuyoka kwake Yesu Kilisto ojwapambuligwe na Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pena ngabalenga maina ga bandu abele, Yusufu ojwakemigwa Basaba andaje Yusto, na jonge akiba Matia. ");
INSERT INTO nnq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ngabagongalela, “Angwana, mwe mijimanyi myojo ja bandu boa. Yene, mutulangile jwa kati ja abele bamba ojwamanchagwile ");
INSERT INTO nnq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","atole paali pa liengo lya undundame elialilekite Yuda ngajenda paali pakwe mwene.” ");
INSERT INTO nnq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Penia, ngabaoma kiumbuumbu kuchagula kati ja bandu abele, na ojwachaguligwa akiba Matia, ngabammeka munkenga gwa achandundame komi na jumwe. ");
INSERT INTO nnq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Apalyaika lichoba lya Pentekoste, akaumini boa bakiba bakonganinge pamwe. ");
INSERT INTO nnq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kingobutu lilobe ngilijoanika kuboke kunani lilobe elikiba anda lya kimboonga kina makakala, ngilitweleya nyumba joa omubakiba batamangite. ");
INSERT INTO nnq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kabe ngipitila ilebe eibonekana andi nimi ya mwoto, ngibaganika nu kutola panani ja kila mundu. ");
INSERT INTO nnq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Boa ngabatweleigwa Uhuke jwa Chwapi, ngabatumbu kulongelanga kila mundu nikilonge chikigeni andi Uhuke jwa Chwapi apanhwotwiye. ");
INSERT INTO nnq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kwenio Kuyelusalemu bakibanga Akayahudi batamanga penia, bandu bambone kwa Nnoongo, ababokelinge kila kilambo kumbengu. ");
INSERT INTO nnq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Apabilijoanga lilobe lyene, nkengeni nkolongwa gwa bandu nguukongana pamwe. Boa ngabaomongwa muno magambu kila mundu penia ngabajoa akaumini benia bakalongela kilonge chakwe mwene ojwajoa. ");
INSERT INTO nnq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ngabajitukanga nu kuomongwa bakalenga, “Bo, bamba boa abatajoanga bakalongela yene, bandu buku Galilayaje? ");
INSERT INTO nnq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iteibo twe tuboa, tajoa balonge kilonge chito tubene? ");
INSERT INTO nnq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Twe tuboke kukilambo cha Kupatia na bange kukilambo cha Kumedia bange kukilambo cha Kuelamia, bange kukilambo cha Masopotamia na kukilambo cha ku Yudea na kukilambo cha Kapadokia na kukilambo cha Ponto na kukilambo cha Asia, ");
INSERT INTO nnq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kuboka kukilambo cha Fulugia na kuboke kukilambo cha Pamfilia na kuboke kukilambo cha Misili na kuboke kukilambo cha Kulibia papipi na Kulene. Bange bandu pamba akageni kuboke kukilambo cha Loma, ");
INSERT INTO nnq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Akayahudi na bandu bange banga akayahudi abajingi dini ja Kiyaudi, bange kuboke kukilambo cha Kulete na bange kubeke kukilambo cha Alabia. Tuboa twenga tujoa bakalongela kukilonge chito tabene kuminhalo mikolongwa ejatei Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Boa ngabaomongwa nukube na mbwele kongo bakakonyananga, “Genia gabi na mana nii?” ");
INSERT INTO nnq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nambu bandu bange ngabatukananga bakalenga, “Bandu benia bate kulobela!” ");
INSERT INTO nnq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nambu Petulo ngajema pamwe na bange bala komi na jumwe ngatumbula kalengelanga bandu kulilobe lya kanonoya, “Makalongo Makayahudi na mmoa mantamanga pamba pa Yelusalemu, mpenekiange maha ganga gambakunnengela mana gakwe ganga. ");
INSERT INTO nnq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bandu bamba balobalingeje, anda apa nhwachanga, ngoe saa tatu tango kindabi tu. ");
INSERT INTO nnq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Chenje kilebe chikipitile ngaechalenga Yoeli, nnondoli jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nnoongo alengite chenje nga echimbakamula mumachoba ga kupela, Manajelelanga bandu boa Uhuke jwango. Ingota yinu ikinalome na ikikege, ipakulondola unhwalo gwango, ikakombo inu ipakulondola, na akananhota binu mabalota maloto. ");
INSERT INTO nnq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Uyo, ata akapakachi bango, akinalome na akikege, Manajelela Uhuke jwango machoba genia, bombe mabalondola nhwalo gwango. ");
INSERT INTO nnq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Manaya gukuomongwa kunani kamaunde ni iingi pae ja dunia. Kupakube na myai, mwoto na malyoi matopeu, ");
INSERT INTO nnq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","lichoba libakujeligwa lubendu, na mwei upakube nkele anda myai, tango nukuikaje lichoba lyale likolongwa lya kibumo cha Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Penia, mundu jwajoa ojwapakujopa kujangatigwa kwa liina lya Angwana makomboligwa.’ ");
INSERT INTO nnq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mabandu ba Kuisilaeli, mpenakiange malobe ganga! Yesu jwa ku Nazaleti akiba mundu jwenio amuli jakwe jiki Nnoongo ejibonekana kwinu kundela ji ikobo nu gukuomongwa ni iingi, eyakamula Nnoongo kupete jwombe. Mangweto mmene magamanyi ganga, gambu gapitila pamba kati jinu. ");
INSERT INTO nnq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kuboka pitumbulaga mwene Nnoongo ngabeka kube Yesu abekigwe mumaboko ginu, na mangweto ngamankoma kwa kalekelanga bandu akabaja bammambe panchalaba. ");
INSERT INTO nnq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nambu Nnoongo nganhyoya kuboka kwa abawile, ngammeka agabwa kuboke mumakakala ga kiu, magambu kabi iwechakineje kiu kintabe. ");
INSERT INTO nnq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gambu Daudi akalenga minhalo ja jwenio Yesu kulenga, ‘Nganabona Angwana nnongi jango kila kingobu, babi papipi nane, na ne nagaje. ");
INSERT INTO nnq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Na kuyene mwojo gwango ngualalila, kabe malobe gango nganonge kukuala mwojo. Mmele gwango mautama mukuhyobalela, mambomalela kukuhyobalela, ");
INSERT INTO nnq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","magambu mulekaje mwojo gwango kumambi, wala kunneka mmanda jwinu jwa chwapi abole kulikabuli. ");
INSERT INTO nnq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unaite ndela ja bwomi, kube kwinu kumekite kube kuala mwojo.’ ");
INSERT INTO nnq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Makalongo bango, nanengalanga kipola nhwalo gwa Nngwana Daudi anhokabito. Bombe ngabawe na ngabachikwa, kabe ndunda yabe ibi pamba upamba pito mpaka lele. ");
INSERT INTO nnq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kwa nyenie akiba Nnondoli, na ngamanya goa Nnoongo atekunnapila, kutenda apakumpambu jumwe kati ji kibelei chakwe nu kummeka pikitebu chakwe chutawala. ");
INSERT INTO nnq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi ngajibona minhalo ejapakamu Nnoongo nnongi, ku yene ngalenga nhwalo gwa kuyoka kwa Kilisto kingobu echalenga, ‘Bannekiteje kumambi, mmele gwakwe uboliteje mulikabuli.’ ");
INSERT INTO nnq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nnoongo ngannyoya Yesu kuboka kumambi na twe tuboa takachaili ba kunhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu ngajinuligwa kunani nu kummeka kingonu chakalelo ja Nnoongo Awamundu, ngapokela Uhuke jwa Chwapi kuboka ka Awamundu anda apabalagila. Penia ngatujela Uhuke jwenio ngachenie echimikibona nu kukijoa ngoe. ");
INSERT INTO nnq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mana Daudi ajabwije mpaka kumbengu, nambu jwombe ngalenga, ‘Angwana ngabalengela Angwana bango, Ntame kingono chango cha kalelo ");
INSERT INTO nnq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mpaka nabekange akangondwa binu pae ja makongono ginu.’ ");
INSERT INTO nnq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Bandu boa ba Isilaeli, bapaligwa, kumanya kweli kube Yesu, jwenio ojwa mammambangite, nga jwenio Nnoongo ammekite abe Nngwana na Kilisto Nkomboi ojwapambuligwe na Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bandu apabajoanga genia, ngajabinia myojo ngabankonya Petulo na achandundame ajakwe bala, “Akalonga bito, tutenda bole?” ");
INSERT INTO nnq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulo ngajanga, “Kila mundu kati jinu alape mabaja gakwe na abatichigwe kuliina lya Yesu Kilisto, na Nnoongo mannekekea mabaja ginu, na mangweto mampokele lilagano lya Nnoongo lya Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gambu lilagano lyale lyakiba magambu jinu na ingota inu nu kuboa abatamanga kutaali na magambu ga kila mundu ojwa apaukemigwa na Angwana ana Nnoongo bito.” ");
INSERT INTO nnq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petulo ngabakwajilila kulenga gange ndu, akalenga, “Mikikombolange kuboka muhukumu ejiika mulungolo londo lubaja.” ");
INSERT INTO nnq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bandu ajingi abajoininge nhwalo gwakwe ngabajeketela ngababatichigwa, na bandu elufu tatu ngabajonjekeka munkenga gwenio lichoba lyene. ");
INSERT INTO nnq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bamba boa ngabajendekea kukibola kuboka kwa achandundame, kutama pamwe kiulongo, kulye pamwe na kugongalela pamwe. ");
INSERT INTO nnq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iingi yi ikobo nu gukuomongwa majingi ngagakamuligwa kukupetela achandundame penia kila mundu ngabe na mbwele. ");
INSERT INTO nnq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abunhwamine boa ngabajendekea kutama pamwe na ilebe yabe ngababagana na ilebe yabe. ");
INSERT INTO nnq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bakiba bakaucha ilebe yabe na uloi gwabe, nukubagana uloi kuboa, tela na kila mundu apapala. ");
INSERT INTO nnq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ngabajendekea ukongana pamwe machoba goa Munyumba ja Nnoongo, na kingobu cha kulye chakulya ngabalyeganga pamwe mumajumba gabe, ngabalyeganga kukuala mojo, ");
INSERT INTO nnq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ngabannumba Nnoongo, ngabapaligwa na bandu boa. Kila machoba Angwana ngabajonjake bandu mukikuta chabe abakomboligwe. ");
INSERT INTO nnq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lichoba limwe saa tisa kimuyo, Petulo na Yohana bajendanga ku Nyumba ja Nnoongo kingobu cha kunng'ongalela Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pakiba na nnyango gwa Nyumba ja Nnoongo ogukemigwa, Nnyango guna Kualala, pakiba na mundu jumwe nangwaba kuboka pabelekwa. Kila machoba bandu batela mpotola mundu jwenio kummeka pena bajope bandu chochoa kwa abakiba bakajingila Munyumba ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Apammona Petulo na Yohana bakajingila Munyumba ja Nnoongo, ngabajopa bampe chochoa chabakweti. ");
INSERT INTO nnq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petulo na Yohana ngabannolekea muno, jwombe Petulo ngalenga, “Mutulolekeye twe!” ");
INSERT INTO nnq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nangwaba ngabalolakeya, akahyobalela kupokela kilebe kuboka kwabe. ");
INSERT INTO nnq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nambu Petulo ngannengela jwenio, “Ngwetije uloi, nambu nampa chache echingweti, kuliina lya Yesu Kilisto jwa Nazaleti nannengela mwe nnyinuke na nnyende!” ");
INSERT INTO nnq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Penia ngankamula luboko lwa kalelo ngannyinula. Kingobucho makongono na majugwa ga mundu jwenio ngagabe na makakala, ");
INSERT INTO nnq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ngagoloka, ngajema nukutumbula kujenda. Penia ngajingila pamwe nabo mwibanja ya Nyumba ja Nnoongo, akajenda nukuomba omba kongo akankolea Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bandu abakiba penia ngabammona akajenda nukunkolea Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na apabamanya kube nga jwajo ojwakiba akajopajopa papipi na Nnyango guna Kualala gwa nyumba ja Nnoongo, boa ngabaomongwa muno nu kuchipula kumanya agampitile. ");
INSERT INTO nnq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mundu jwenio apakiba tango akalongwana na Petulo na Yohana papakemigwa pa Nchana gwa Solomoni, bandu ngabaomongwa nu kubutukila kwenio. ");
INSERT INTO nnq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petulo apababona bandu bakonganinge, ngabalengela, “Mabandu ba Kuisilaeli, bole mboni nhwomwanga kile chenjeno? Mboni mutulolekeanga muno nkitanga kwamakakala gito andaje nkita ku uwecho gwito twe tubene tantei mundu jonjo aotole kujenda? ");
INSERT INTO nnq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nnoongo jwa Ulaimu na Isaka na Yakobo na Nnoongo jwa akaokabito, ankoliye Yesu Mpakachi jwakwe. Nambu mangweto ngamampukila nukumpeleka kwa akakolongwa na ngamankana nnongi ja Pilato, ati Pilato papala kunnekekea. ");
INSERT INTO nnq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Akiba jwa chwapi na jwa mbone, nambu mangweto ngamankana jwombe, nu kumpala Pilato ampegange mundu jonge ojwakiba nkomi. ");
INSERT INTO nnq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ngamankoma ojwabalongolea bandu mubwomi, nambu Nnoongo nganhoya kuboka kwa abawile, na twe takachaili ba kikobo chenie. ");
INSERT INTO nnq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Makakala ga liina lya Yesu elimpi uwecho nangwaba ojo. Chimikibona nu kukimanya kikamuligwe ku imani ja liina lyakwe, imani kwa Yesu ngaechantei alamite mundu jonjo anda apannolanga mmoa. ");
INSERT INTO nnq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ngoe, mabandu ba Isilaeli, manyi kube mangweto na akiilongoi binu manteilinga Yesu genia gwanga manya gwinu. ");
INSERT INTO nnq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nambu Nnoongo ngalenga kukupetela akalondoli ba Nnoongo kube Kilisto Nkomboi ojwapambuligwe na Nnoongo mpaka apotekigwe, na genia galenganile kube kweli kundela jenje. ");
INSERT INTO nnq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nnapange mabaja ginu, mammujilange Nnoongo ibe jwombe annekekeange mabaja ginu. ");
INSERT INTO nnq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kingobu cha kujeligwa makakala ga kiuke makiika kuboke kwa Angwana, na Nnoongo mankinga Yesu, Kilisto Nkomboi ojwapambuligwe na Nnoongo kwinu. ");
INSERT INTO nnq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mpaka oti jwenio aigale kumbengu mpaka kiike kingobu cha kila kilebe kitendekiigwe ibe iyono, anda Nnoongo apalengita kukupetela akalondoli bakwe bachwapi kutumbu lolo. ");
INSERT INTO nnq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Gambu Musa akalenga, ‘Angwana ana Nnoongo binu bapannetelanga nnondoli, anda ne kuboke kwinu mangweto. Mpaligwa kunnyali kila kilebe echapakunnengela. ");
INSERT INTO nnq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mundu jwajoa jwanga nnyali nnondoli jwa Nnoongo jwenio apakuboigwa nu kubekigwa kutaali na bandu bambone ba Nnoongo nu ukomigwa.’ ");
INSERT INTO nnq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Akalondoli ba Nnoongo boa, kutumbu Samweli na boa abankengime, uyo ngabatangacha minhalo ja ilebe yenje eikamuligwa machoba ganga. ");
INSERT INTO nnq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Malagano agapia Nnoongo kupetela akalondoli bakwe ngaginu, namangweto mmekigwe kube bandu ba lilagano, elyabeka Nnoongo na akaoka binu. Andi apannengela Ulaimu, ‘Kupetela lungolo lwinu, bandu boa bapadunia bapakupata upeele.’ ");
INSERT INTO nnq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yene Nnoongo nganhyoya mpakachi jwakwe, nu kunkinga oti kwinu, kunnumika mangweto kukummeka kila mundu kati jinu auleke ubaja gwakwe gwoa.” ");
INSERT INTO nnq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petulo na Yohana apakiba tango bakalongela na bandu, ngabaika bange akakung'i akolongwa na kilongoi gwa akalenda ba Nyumba ja Nnoongo pamwe na Masadukayo. ");
INSERT INTO nnq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Benia batekuchimwanga muno, magambu achandundame abena bakabolanga bandu kube Yesu akatekuyoka, nhwalo gulaya kipola kube abawile mabayoka babe na bwomi. ");
INSERT INTO nnq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Benia ngabataba angweto mukipungo magambu ikiba kimuyo bajogolalingeje, mpaka kindabi jakwe. ");
INSERT INTO nnq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nambu ajingi abajoa nhwalo gwabe ngabajeketela, na bandu boa abaamine bakiba kupeta elufu nhwano. ");
INSERT INTO nnq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kindabi jakwe, achilongoi ba Akayahudi, akinanhota na aboli ba Malagilo ga Musa ngabakongana pamwe kwenio Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ngabakongana pamwe na Anasi na Kayafa na Yohana na Alekizanda na bange abakiba ba lungolo lwa Akung'i Akolongwa. ");
INSERT INTO nnq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ngababeka achandundame bajeme nnongi jabe, ngabakonyanga, “Mangweto nkamulinge nhwalo gongo kwa makakala ga beneke? Andaje liina lya beneke?” ");
INSERT INTO nnq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petulo, akiba atweli Uhuke jwa Chwapi, ngabajanga, “Akiilongoi na Akinanhota ba bandu, ");
INSERT INTO nnq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mutukonya lele nhwalo gwambone ogwatendigwe mundu ojwakiba nangwaba nu kulama, ");
INSERT INTO nnq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mangweto mmoa mabandu ba Kuisilaeli mpaligwa kumanya kube mundu jonjo lele ajemite nnongi jinu, alamite, kwa makakala ga liina lya Yesu Kilisto ju Kunazaleti, mangweto ojwamankoma munchalaba, nambu Nnoongo ngannyoya kuboka kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu nga jwenio ojugannenga Majandiko Gachwapi. ‘Libwe elimilikananga makachengi lele libi lyambone kupeta goa.’ ");
INSERT INTO nnq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ukomboi kupatikana kwakwe Yesu, magambu libije lina lenge pae ja mbengu mundu ojwatupi Nnoongo atukombole.” ");
INSERT INTO nnq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Akanahota ba libalacha, bumanyi Petulo na Yohana kube bandu banga ilimu ngabaomongwa apababona bakalongela nukujogopaje. Ngabamanya kube balondine na Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nambu apabammona mundu jwajo ojwalamiigwe ajemite pamwe na Petulo na Yohana, baotolingeje kulongela kilebe. ");
INSERT INTO nnq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yene, ngabaamulicha Petulo na Yohana bapitange panja ja Libalacha, na penia ngabatumbu konyana beneakangweto. ");
INSERT INTO nnq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ngabakonyana, “Tatendi bo bandu aba? Kila mundu ojwatama pa Yelusalemu amanyi kikobo chenje chukuomongwa kikamuligwe na angweto, natwe tuotwaje ukana kile chenie. ");
INSERT INTO nnq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nambu kukupala kakanakia nhwalo gongo gukajendakeaje kujoanika kwa bandu, takelabuye bakalongeje na mundu jwajoa kuliina lya Yesu.” ");
INSERT INTO nnq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yene ngabakemanga kabele unyumba, na ngabalengela bakalongeje pukongolou na bakabolaje bandu kuliina lya Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nambu Petulo na Yohana ngabajanga, “Mmanyanga mmene mangweto chikipaligwa ku Nnoongo kunnyali mangweto andaje kunnyali Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gambu twe tuotwaje kotoka kulenga minhalo jaje ejitujibweni nu kujijoa.” ");
INSERT INTO nnq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Penia, akanahota ba Libalacha ngabakalapila, kuboka penia ngabalekekeya. Bahukumwije, magambu bandu boa bakiba bakankoleya Nnoongo magambu ga nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mundu jwenio ojwatendigwa kikobo chu kulamiigwa akiba na yaka alubaini. ");
INSERT INTO nnq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kingobutu Petulo na Yohana kuboka pa kulekekigwa ngababuja kwa akajabe, ngabalenge gaga agalengigwe na akakung'i akolongwa na akinanhota. ");
INSERT INTO nnq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Apabujoa nhwalo gwenio, boa ngababe lyabe limwe kukunnyopa Nnoongo bakalenga, “Angwana, mwe mampangine mbengu na dunia na baali na yoa eibi mwenio! ");
INSERT INTO nnq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ngamammeka mpakachi jwinu, nhwoko gwito Daudi, alenge kwa makakala ga Uhuke jwa Chwapi. ‘Kwa nike bandu banga Akayahudi bachimwanga, Mboni bandu bakamwa ganga mbone? ");
INSERT INTO nnq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Akangwana ba padunia ngibikibeka maha, na akakolongwa ngabakongana pamwe ibe bakanange Angwana na Kilisto Nkomboi ojwapambuligwe na Nnoongo jwakwe.’ ");
INSERT INTO nnq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gambu kweli Helode na Pontio Pilato na bandu ba Isilaeli na bandu banga Akayahudi ngabakongana upamba pannyini kunkana Yesu, Mpakachi jwinu jwa Chwapi, ojwamantei Kilisto Nkomboi ojwapambuligwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Benia ngabakongananga bakamwa ilebe yae eimapaila ikamuligwe kuboka pitumbulaga kuwecho gwinu na kukupala kwinu. ");
INSERT INTO nnq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nambu ngoe, Angwana, nnole kujogoya kwabe, nu mutuotoye twenga, takapakachi binu, tulenge lilobe linu panga jogopa. ");
INSERT INTO nnq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ntondabeye luboko lwinu nnamie bandu, nnaye ikobo na gukuomongwa kulina lya Yesu Mpakachi jwinu jwa Chwapi.” ");
INSERT INTO nnq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Apabajomola kugongalela, paali penia apabakakongana ngapalendemela. Ngabatweleigwa Uhuke jwa Chwapi na boa ngabatumbu kutangacha lilobe lya Nnoongo panga jogopa. ");
INSERT INTO nnq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nkenga gwoa gwa abaamine gwakiba kile chimwe kukupalana na mwojo. Akibaje mundu jwajwoa ojwakiba na kile chochoa akakibeka kube chakwe jika, nambu ngababagana yoa eyabakiba nayo. ");
INSERT INTO nnq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Achandundame ngabachalakicha kwa makakala ndu ga kuyoka kwa Angwana ana Yesu, na Nnoongo ngabape upeele boa. ");
INSERT INTO nnq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Akibaje mundu ojwakapelelwa kilebe. Jwajo ojwakiba na migonda andaje nyumba akiba akaucha, nu kuleta uloi ogwaupatite, ");
INSERT INTO nnq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nukapeganga achandundame, nu uloi gwenio kubagana kila mundu andi papala. ");
INSERT INTO nnq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pakiba na Mlawi jumwe, ojwabelekwa kukilambo cha Kupulo, liina lyakwe Yusufu, achandundame bankema Banaba mana gakwe “Mundu juna kape bandu mojo,” ");
INSERT INTO nnq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","jwombe uyo akiba na nng'onda gwakwe, ngaucha, uloi gwene, ngajenda kakamuya achandundame. ");
INSERT INTO nnq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Akiba mundu ojwakemigwa Anania, na aanamundu Safila ngabauchanga nng'onda gwabe uyo. ");
INSERT INTO nnq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nambu Anania ngabapangana na aanamundu, gonge uloi kukibeke bene akangweto na gonge ngabape achandundame. ");
INSERT INTO nnq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petulo ngankonya, “Anania, mboni Lichetani lintei mwe munkoloye Uhuke jwa Chwapi kukuiya uloi gonge ogumpatite kukuucha nng'onda? ");
INSERT INTO nnq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pamakiba tango nu kuuchaje ukiba gwinu, na kuboka pu kuucha, uloi gwenio ukiba mukinala chinu. Kwa nike ngampangana mumyojo jinu kutenda kilebe anda chenieche? Mankolwi munduje, mankolwi Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania kujoa tu genia, ngagwe, nu kuwe, na bandu boa abajoa nhwalo gwenio ngabajogopa muno. ");
INSERT INTO nnq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Achakakombo ngabaika, ngubutabali chanda mmele gwakwe, ngubupia panja, ngubuchika. ");
INSERT INTO nnq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kubokapa masaa matatu nhwanamundu, nukumanyaje ilebe eipitile, ngajingila unyumba jenie. ");
INSERT INTO nnq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulo ngankonya, “Unengele, uloi gongo nga gwoa ogumpatangite mwenga na angwanabinu kukuucha nng'onda gwinu?” Jwombe ngannyanga, “Elo, gwoa nga gwenio.” ");
INSERT INTO nnq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Penia Petulo ngannengela, “Mboni mwe na angwana binu mpanganinge kunnondola Uhuke jwa Angwana? Bandu ababachikite angwana binu ngoe babi panniango, na bapakumpotola panja na mwe uyo!” ");
INSERT INTO nnq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Upo Safila ngagwe nnongi ja makongono ga Petulo, ngawe. Achakakombo bala apabajingila, ngabammona awile, penia ngabampiya panja, ngabanchika papipi na angwana mundu. ");
INSERT INTO nnq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kikuta cha bandu abunhwamini Kilisto choa pamwe na bandu boa abajoa unhwalo gwenio ngabajogopa muno. ");
INSERT INTO nnq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Achandundame ngabakamwa ikobo na gukuomongwa majingi kati ja bandu. Abaamininge bakiba bakakongananga pamwe panchana gwa Solomoni. ");
INSERT INTO nnq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Akibaje mundu jwangabe munkenga gwenio ojwajigite kube pamwe nabo, ati yenie bandu benia ngabalumbalila. ");
INSERT INTO nnq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bandu abaamine Angwana, akinalome na akikege, ngabajonjeke kube ajingi muno. ");
INSERT INTO nnq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Magambu genia, bandu bakiba bapelekanga akatamwe undela na kagoneka panani ja indanda na makai ibe Petulo papakupeta, ata kiwili chakwe chawekelele bange. ");
INSERT INTO nnq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bandu ajingi ngabaika kuboka kuilambo ya papipi ja Yelusalemu, bakaleta akatamwe na abakiba na michepela, na boa ngabalama. ");
INSERT INTO nnq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Penia Akung'i Akolongwa na akajabe, abakiba bankengeni gwa Masadukayo ba paali penia, ngababone achandundame bwiu, yene benia ngabaamu katakiana. ");
INSERT INTO nnq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ngabapukilanga achandundame ngabajigilila mukipungo. ");
INSERT INTO nnq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nambu kilo mpakachi jwa Angwana kuboka kumbengu ngajogola milyango ja kipungo, ngabapiyanga achandundame panja, na kalengela, ");
INSERT INTO nnq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nnyendange makajeme kwiibanja ya Nyumba ja Nnoongo, na makalengelange bandu kila kilebe nhwalo gwa bwomi gongo nnyono.” ");
INSERT INTO nnq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Achandundame ngabajeketela, ngabajendanga kuibanja ya Nyumba ja Nnoongo kindabi ndabi, ngabatumbu kubola. Nkung'i Nkolongwa na akajabe ngabakemana pamwe akananhota ba Akasilaeli ngibe ngongano ji Kitamo chakananhota, kabe ngabakinga bandu kukipungo balete achandundame. ");
INSERT INTO nnq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nambu akapakachi benia apabaika kwenio bakolalingeje achandundame mukipungo, ngababujanga ku Kulibalacha nu kalengela, ");
INSERT INTO nnq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kingobu putuika kunyumba ja kipungo, tujikolela jijigiligwe milyango joa na akalenda bakalenda pimilyango, nambu apatajogola milyango, tankolije mundu unyumba!” ");
INSERT INTO nnq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kingobu akakung'i akolongwa na kilongoi jwa akalenda ba nyumba ja Nnoongo pabajoa nhwalo gwenio, ngabaomongwa achandundame chapiti kinii. ");
INSERT INTO nnq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ngaika mundu jumwe, ngabalengela, “Mpenakiange! Bandu abamajigilila mukipungo, ngoe babilingite kuibanja ya Nyumba ja Nnoongo, babolanga bandu!” ");
INSERT INTO nnq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Penia kilongoi jwa akalenda jupa Nyumba ja Nnoongo na bandu bakwe ngabajenda ku Nyumba ja Nnoongo, kaletanga achandundame. Baletange kwa makakalaje, magambu bajogopa bandu kaputa mabwe. ");
INSERT INTO nnq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ngabaletanga achandundame, ngabajemeka nnongi ja Kitamo chakananhota, na Nkung'i Nkolongwa ngabakonya angweto. ");
INSERT INTO nnq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ngalenga “Ngatankelebuya makabolaje kuliina lya mundu ojo nambu nnolange echinkamulinge! Ntangachinge maboulo ginu Kuyelusalemu joa na mpalanga tukonda twe tukomite mundu jwenio!” ");
INSERT INTO nnq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petulo na achandundame bange ngabajanga, “Tupaligwa kunnyali Nnoongo, nambu munduje. ");
INSERT INTO nnq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nnoongo jwa akananhota bito ngaunnyoya Yesu kuboka pa mangweto kunkoma kukummamba panchalaba. ");
INSERT INTO nnq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nnoongo ngaunhyoya nukummeka kingonu chakwe cha kalelo, ngabe kilongoi na Nkomboi, ibe bandu ba Isilaeli bapatange kulapa mabaja gabe, ibe balekekekigwe mabaja gabe. ");
INSERT INTO nnq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Na twenga takachaili ba minhalo jenie, pamwe na Uhuke jwa Chwapi jwenio bapile abannyoa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kingobu bandu boa ba Kitamo chakananhota apabajoa genia, ngabachimwa muno, ngabapala kakomanga achandundame. ");
INSERT INTO nnq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nambu Mfalisayo jumwe ojwakemigwa Gamalieli ojwakiba mmoli jwa Malagilo ga Musa na bandu bakampe ichima, ngajema nnongi ja Kitamo chakananhota. Ngalenga achandundame bapiigwe panja kukingobutu, ");
INSERT INTO nnq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","penia ngabalenge bandu ba Kitamo chakananhota, “Mabandu ba Kuisilaeli, mmaganga maha champakatendanga bandu aba. ");
INSERT INTO nnq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nkombokela kube ngapitila mundu liina lyakwe Theuda, ngakilenga jwombe mundu jwa mbone bandu ngababe mia ncheche ngabalondana nakwe. Nambu ngakomigwa, kuboka penia abankengima boa ngabapwilikana na minhalo jakwe ngijiwe. ");
INSERT INTO nnq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kuboka penia, kingobu uchache cha kubalanga bandu, ngapitila Yuda jwa Galilaya. Jonjo uyo ngabauta bandu ngabankengama, nambu jwombe uyo ngakomigwa, na abankengama ngabapwilikana. ");
INSERT INTO nnq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ngoe uyo ne nannengelanga, bandu bamba makatendakileje. Malekange! Anda ibi kile chenje akiletite mundu, makikotoka chene, ");
INSERT INTO nnq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","nambu anda akiletite Nnoongo, nhwotolangaje kukiboya. Mannolanga mmene ntaukana na Nnoongo!” Libalacha ngilijeketela machabuli ga Gamalieli. ");
INSERT INTO nnq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ngabakema achandundame unyumba, ngabaamulicha baputigwe iboko na kakelebuyanga bakabolangaje kabe kuliina lya Yesu, na ngabalekekea bajabulange. ");
INSERT INTO nnq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Achandundame apabapita Mukitamo chakananhota, ngabaala mwojo, magambu Nnoongo babeka angweto bapaligwe ukamuligwa yene magambu ga liina lya Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kila machoba ngabajendanga kubola nu kutangacha Nhwalo Gwambone gwa Yesu Kilisto Nkomboi ojwapambuligwe na Nnoongo kuibanja ya nyumba ja Nnoongo na kachabe bandu. ");
INSERT INTO nnq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Machoba genia, akinapunji apabajonjakea kube ajingi, ngukupitila kokaleka Akayahudi kati ja abaamine abalongela Kigiliki na abalongela Kiebulania. Abalongela Kigiliki ngabakokaleka kutenda akanawele babe batela kalibilila mukubagana ilebe ya kila machoba. ");
INSERT INTO nnq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kuyenie akinapunji komi na abena ngubukema nkengeni gwoa gwa abaamine nu kulenga, “Ipaligweje twenga tuleke kulitangacha lilobe lya Nnoongo tubegele nu kubagana ilebe. ");
INSERT INTO nnq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kuyenie makalongo, nchagulange bandu saba kati jinu abamachalakiche kube bambone na abatweli Uhuke jwa Chwapi, bina malango, natwe matabeka babegele na lyenie. ");
INSERT INTO nnq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na twe, matubegelela nu kugongalela ni liengo lya kutangacha lilobe lya Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nkenga gwoa pamwe na achandundame abachaguligwe, kuyenie ngabampambu Stefano mundu juna imani ngolongwa jwa tweli Uhuke jwa Chwapi, na Filipo na Polokolo na Nikanoli na Timona na Pamena na Nikolao abokela kukilambo cha Antiokia ngajingi dini ja Kiyaudi. ");
INSERT INTO nnq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nkenga ngugwabeka nnongi ja achandundame, angweto ngabanng'ongale Nnoongo na kabeke maboko gabe panani jabe. ");
INSERT INTO nnq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lilobe lya Nnoongo ngilijendeke kujoanika. Na akinapunji Kuyelusalemu ngabajonjake kube ndu muno nankengeni nkolongwa gwa akakung'i ngabapoke imani. ");
INSERT INTO nnq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nnoongo ngannyalia Stefano upeele ndu, ngampe makakala ndu ngabe akakamula ikobo ikolongwa na gukuomongwa kati ja bandu. ");
INSERT INTO nnq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nambu bandu bange ngabapitila bataukane na Stefano. Bandu benia bakiba ba nyumba ja kugongalela ejikemigwa, “Nyumba ja kugongalela ja Bandu ba Agabwa,” angweto babokela Kulene na Kualekizanda, bange babokela ku Kilikia na Asia. ");
INSERT INTO nnq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nambu bunhotolingeje gambu gwa mwojo gwakwe gwambone na Uhuke jwa Nnoongo ojwannongelea kingobu chalongela. ");
INSERT INTO nnq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kuyenie ngabaeme bandu bange balenge nhwangi kulenga, “Tannyoine Stefano akalenga malobe ga kuntukana Musa na ga kuntukana Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa magambu genia, ngabakolakea bandu, akinanhota na aboli ba Malagilo ga Musa. Penia ngabannyendela Stefano, ngabampukila, nu kunneta nnongi ja Kitamo chakananhota. ");
INSERT INTO nnq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ngabaleta akachaili buwangi abalenga, “Mundu ojo kila machoba ajitukana Nyumba ja Chwapi ja Nnoongo na Malagilo ga Musa. ");
INSERT INTO nnq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Magambu tannyoine akalenga eti Yesu jwenio jwa ku Nazaleti apakapabomola pamba na kuboya lukobo olutupokela kwa Musa!” ");
INSERT INTO nnq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Boa abakiba pikitamo chakananhota ngabampikia mio Stefano, ngubukubona kumio jakwe kukiba andi kumio ja mpakachi jwa Nnoongo jwa kumbengu. ");
INSERT INTO nnq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nkung'i nkolongwa ngankonya Stefano, “Bo, ile yenje nga kweli?” ");
INSERT INTO nnq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano ngalenga, “Malongo bango na akinawawa, umbenakiange! Nnoongo juna kibumo ngabapitila awawa bito ana Ulaimu apabakiba kukilambo cha Masopotamia tango nukujendaje kutama kukilambo cha Halani. ");
INSERT INTO nnq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nnoongo ngabalengela, ‘Mmoke pikilambo chinu na mululeke lungolo lwinu na nnyende kukilambo chambakunnaya.’ ");
INSERT INTO nnq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kuyenie, Ulaimu ngaama kilambo chuku Kalidayo, ngajenda kutama kilambo chuku Halani. Kuboka pa kiu cha awamundu, Nnoongo ngammoya kukilambo cha Halani ngaika kutama pi kilambo chenje chantamanga ngoe. ");
INSERT INTO nnq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nnoongo ampije Ulaimu kipande ati chimwe cha kilambo chenje kibe chakwe, ati yene, ngalagila kumpe kilambo chenje kibe chakwe na kibelei chakwe. Kingobu chenie Nnoongo echalagila genia jwombe Ulaimu akwetije mwana. ");
INSERT INTO nnq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nnoongo ngannengela yene, ‘Kingolo chinu makipelekigwa kukilambo echikitawaligwa na bandu bange, na kwenio mababeka babe akabanda na katendanga mabaja kwayaka makomi komi ncheche. ");
INSERT INTO nnq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nambu manahukumula bandu benia abapakummeka ubanda alenga Nnoongo. Kabe manuluboya lungolo lwinu kukilambo chenie luike kung'ongalela ne paali pamba.’ ");
INSERT INTO nnq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kuboka penia Nnoongo ngampe Ulaimu lukobo lukuinigwa kiingi chukulaya lilagano. Yene Ulaimu nganhwina mwana jwakwe Isaka, lichoba lya nane kuboka pa kubelekwa. Isaka uyo nganhwina mwana jwakwe Yakobo. Na Yakobo ngaina ingota yakwe komi ni ibena, ngabenia akaoka bito.” ");
INSERT INTO nnq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ingota ya Yakobo ngibe na bwiu ku ununa gwabe Yusufu nu kunhucha abe mmanda kukilambo cha Misili. Nambu Nnoongo akiba pamwe na Yusufu, ");
INSERT INTO nnq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ngankombola mumalago gakwe goa. Kingobu Yusufu apaika nnongi ja nngwana juku Misili, Nnoongo ngampe malango nu kujeketeligwa nnongi ja Falao, ojwakiba Nngwana juku Misili. Penia Falao ngammeka Yusufu abe nkolongwa ju kilambo chenie na nyumba joa jikingwana. ");
INSERT INTO nnq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kuboka penia, ngukupitila njala ngolongwa pikilambo choa cha Misili na cha Kanaani, ngijileta kulaga muno. Akahoko bito baotwije kupata chakulya chochoa chela, ");
INSERT INTO nnq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","na Yakobo apajoa kutenda ku Misili chakulya kibile, ngaituma ingota yakwe, akaoka bito, bajendange kwenio kwa mala ja kutumbula. ");
INSERT INTO nnq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mumwanja gwabe gwa pabele, Yusufu ngakibeka amanyikane kwa akalongamundu, na Falao ngalumanya lungolo lwa Yusufu. ");
INSERT INTO nnq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yene Yusufu ngalagila nhwalo kwa awamundu na akalongamundu boa, bandu makomi saba na nhwano, baikange ku Misili. ");
INSERT INTO nnq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Penia Yakobo ngajenda ku Misili okwa awaga jwombe na ingota yabe ngabawe. ");
INSERT INTO nnq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mibele jabe ngijiletigwa kukilambo cha Shekemu, ngijichikigwa pilikabuli elyaemela Ulaimu kwa ela, kubandu ba kilambo cha Hamoli.” ");
INSERT INTO nnq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kingobu apachaika cha Nnoongo apange tela na apalagana nu Ulaimu, ichabu ya bandu bala kwako ku Misili yakiba ijonjaki kube ngolongwa muno. ");
INSERT INTO nnq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kuboka pa kupeta machoba ndu, nngwana jumwe jwanga mmanya Yusufu ngatumbu kutawala kwenio ku Misili. ");
INSERT INTO nnq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ngababonela bandu ba kabi jito na katenda ubaja akawabito, kwakaamulicha bipiye ilemba yabe panja iwe. ");
INSERT INTO nnq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kingobu chenie nga chabelekwa Musa, akiba mwana juna kualala muno. Ngabannela unyumba kawamundu kwa myei mitatu, ");
INSERT INTO nnq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na kingobu Musa apapiigwa panja, mwana munkege jwa Falao ngantola, akannele andi mwana jwakwe. ");
INSERT INTO nnq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa ngaboligwa gambone goa ga bandu ba ku Misili ngakola kwa malobe na itendwa.” ");
INSERT INTO nnq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa apakiba na yaka makomi ncheche ngajenda kabona akalongomundu Akasilaeli babone apabatendigwa. ");
INSERT INTO nnq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kwenio ngammona nnyakwe akaboneligwa, ngajenda kunkengela, nu kukubuya ngankoma Mmisili jwenio. ");
INSERT INTO nnq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Akita aka Isilaeli ajakwe kabi bamanyi kutenda Nnoongo ankingite jwombe kabekanga tengela, nambu angweto bamanyije. ");
INSERT INTO nnq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Malabo jakwe, ngababona aka Isilaeli abena bakaputana, ngajiga kabekanga tengela akalenga, ‘Mangweto makalongo, mboni ntenda kubonelana?’ ");
INSERT INTO nnq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nambu ojwakiba akammonela nnyakwe ngankanga Musa kumbwega akakonya, ‘Bene abammekite mwe mme makilongoi na makengi bito?’ ");
INSERT INTO nnq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Bo, mpala kungoma anda apamankoma Mmisili jola licho?’ ");
INSERT INTO nnq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa apajoa genia, ngatila, ngajenda kutama kukilambo cha Midiani kwenio ngapata ingota ibena.” ");
INSERT INTO nnq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Apayaika yaka makomi ncheche, mpakachi jwa Angwana kuboka kumbengu ngampitila Musa pikindumba chikikiba chakajaka mwoto kupongoti papipi na kitombi cha Sinai. ");
INSERT INTO nnq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa ngaomongwa muno kukibona kile chenie, ngaegelela papipi aingakie. Nambu ngalijoa lilobe lya Angwana, ");
INSERT INTO nnq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ne na Nnoongo ba akaokabinu na Nnoongo jwa Ulaimu na Isaka na Yakobo.’ Musa ngalendema kukujogopa muno na ajigiteje kujendekea kulola. ");
INSERT INTO nnq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Angwana ngabannengela, ‘Nhwule ilatu yinu, magambu paali pannyemite pano pachwapi. ");
INSERT INTO nnq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nagabweni mabaja agatendigwa ku bandu bango ku Misili. Nyoine nguto jabe, nane inke kakombola. Nhwike ngoe, mbakunkinga ku Misili.’” ");
INSERT INTO nnq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa jwenio nga jwajo ojwakanigwa na bandu ba Kuisilaeli, apabalenga, ‘Mene ojwammekite mwe mme makilongoi na matawala bito?’ Kukupetela mpakachi jola ojwampitila pikindumba echikikiba chakajaka mwoto, Nnoongo ngankinga Musa jwenio abe ntawala na nkomboi. ");
INSERT INTO nnq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nga ojwabalongelea bandu ba Isilaeli baboke ku Misili ku ukamwa ikobo na gukuomongwa pa kilambo cha Misili nuku baali ja Shamu na kupongoti kukingobu cha yaka makomi ncheche. ");
INSERT INTO nnq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa nga ojwabalengela bandu ba Kuisilaeli, ‘Nnoongo manchagulilinga nnondoli andi ne kuboka kati ja akalongabinu mmene mangweto.’ ");
INSERT INTO nnq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa akiba pamwe na bandu ba Isilaeli pabakongana kwako kupongoti, akiba na akahokabito nga ojwalongela na mpakachi jwa Nnoongo pikitombi cha Sinai. Nga ojwakamuigwa malobe ga bwomi atupe twenga.” ");
INSERT INTO nnq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nambu akaokabito ngabakana kumpenakia jwenio, ngabankanga kumbwega, ngabapala kubuja ku Misili. ");
INSERT INTO nnq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ngabannenge Aluni, ‘Mututendekeye milongo ejipakutulongalea undela, magambu tumanyije agampatite Musa ojwatulongelea tuboke kukilambo cha Misili.’ ");
INSERT INTO nnq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Penia ngibikitendekeya kinyago echikilandine na likoga, ngibikipangi lilumbo nu kukibeke mpapala kukugongalela kilebe chibikitendekekie benekangweto. ");
INSERT INTO nnq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nambu Nnoongo ngaboka kwabe, ngabaleka bagongalele ndondwa yu kumbengu, andi apiandikigwe mukitabu cha akalondoli ba Nnoongo, ‘Mabandu ba Kuisilaeli! Neje inyama imachinja nu kupanga lilumbo ku yaka makomi ncheche kupongoti. ");
INSERT INTO nnq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mangweto mukipotola kiteba cha nnongo Moleki, na kinyago cha lutondwa nnoongo jwinu Lefani, yakiba inyago imatendakea kuigongalela. Kuyenie mbakumpeleka kubanda kutaali kupeta ku Babiloni.’” ");
INSERT INTO nnq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Liteba lyu uchaili likiba pamwe na akaokabito kupongoti, andi Nnoongo apannangila Musa alitendekeye, tela na chache echalaigwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kuboka penia akaokabito ngabapokelana bombe kwa bombe mpaka kingobu cha Yoshua, apabakitola kilambo chache kuboka kwa ilambo eibabenga Nnoongo bandu bakwe nnongi jabe. Kiteba chenie ngikitama penia mpaka kingobu cha Daudi. ");
INSERT INTO nnq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi akate kupaligwa na Nnoongo, na jwombe ngannyopa Nnoongo annyeketele kunchenge kitamo jwenio Nnoongo jwa Yakobo. ");
INSERT INTO nnq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nambu Solomoni nga ojwanchengela Nnoongo nyumba.” ");
INSERT INTO nnq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nambu, Nnoongo Nkolongwa kutamaje munyumba eichengigwe na bandu, anda apalenga nnondoli jwa Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Angwana balenga, mbengu nga kitebu chango chu kutawala, na dunia nga kitebu chukubeka makongono gango. Nyumba nike ejinhwotolinge kunjenge nenga? Paali gani apambakutama? ");
INSERT INTO nnq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ilebe yenje yoa nipanginya neje?’” ");
INSERT INTO nnq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefano ngajendekea kulongela, “Mangwetumwe makamitau!” “Myojo jinu mitopeu na mmi mangajoa kwa Nhwalo gwa Nnoongo! Mmi andi akahoka binu. Mangweto machoba goa mankananga Uhuke jwa Chwapi jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bo, abi nnondoli jwa Nnoongo jwanga mmonela akaoka binu? Ngabakomanga angweto abakingigwe na Nnoongo kutangacha kuika kwakwe jwajo jwambone. Na ngoe mangweto mang'alwikinge nu kunkoma. ");
INSERT INTO nnq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mangweto ngampokela Malagilo agaletigwa kwinu na Mpakachi kuboka kumbengu, nambu magajeketije.” ");
INSERT INTO nnq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bandu abakiba piki Kitamo cha akanahota apabajoa genia, ngabachimwanga muno, nu kuyaga mino kukuchimwa. ");
INSERT INTO nnq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nambu Stefano kongo atweli Uhuke jwa Chwapi, ngalola kunani kumbengu, ngakibona kibumo cha Nnoongo na Yesu ajemite kingonu cha kalelo cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ngalenga, “Nnolange! Nijibona mbengu jiekuligwe na Mwana jwa Mundu ajemite kingonu cha kalelo cha Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Penia, bandu boa abakiba pikitamo cha Akanahota ngabaibanga machikilo gabe kwa maboko gabe ngabatenda manjega. Kabe ngabanng'olokela boa pamwe, ");
INSERT INTO nnq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ngabampia panja ja kilambo, ngabamputa maganga. Akachaili ngababeka makoti gabe pu ulenda gwa kakombo jumwe liina lyakwe Sauli. ");
INSERT INTO nnq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ngabajendekea kumputa Stefano kwa maganga kongo akann'gongolela Nnoongo, kulenga, “Angwana ana Yesu, mupokele mwojo gwango!” ");
INSERT INTO nnq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ngakilikitila majugwa, ngaguta kulilobe likolongwa, “Angwana, makakombakeje kwa magambu gu ubaja gongo.” Kuboka pukulenga genia, ngawe. ");
INSERT INTO nnq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli ngalola ukomigwa kwa Stefano nga tela. Lichoba lyene kikuta cha bandu abunhwamini Kilisto chu Kuyelusalemu ngikitumbu kupotekigwa. Abaamine boa, ngabatumbu kupwilikana papipi na migonda ja ku Yudea na ku Samalia nambu achandundame bapwilikineje. ");
INSERT INTO nnq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bandu abampala Nnoongo ngabanchika Stefano nu kunkokalakea kwa nguto ngolongwa. ");
INSERT INTO nnq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nambu Sauli ngatumbu kukikoma kikuta cha bandu abunhwamini Kilisto. Ngajenda kila nyumba, ngabapia panja abaamine, akinalome na akikege, ngababeka mukipungo. ");
INSERT INTO nnq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abaamine abapwilikine, ngabajenda kila paali bakatangacha Nhwalo Gwambone. ");
INSERT INTO nnq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo ngaika pikilambo chuku Samalia nu kuntangacha Kilisto Nkomboi ojwapambuligwe na Nnoongo kwa bandu ba penia. ");
INSERT INTO nnq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bandu ngabakongana kupenakia nhwalo gwa Filipo nu kuibona ikobo eyaikamula. ");
INSERT INTO nnq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Michepela ngijapita bandu ndu kwa nguto ngolongwa, na bandu ajingi abakiba bapolite mmele na nangwaba ngabalamiigwa. ");
INSERT INTO nnq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kuyenie ngukube na laa ngolongwa pikilambo chenie. ");
INSERT INTO nnq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pakiba na mundu jumwe ojwakemigwa Simoni ojwakiba atei uwabe gwakwe pikilambo chenie kukingobu na kaomwayanga bandu ba Samalia, ngakikema jwombe mundu nkolongwa. ");
INSERT INTO nnq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bandu boa, bunuloi na akaocho, ngabampenakia bakalenga, “Simoni nga makakala ga Nnoongo agakemigwa, ‘Makakala Makolongwa.’ ” ");
INSERT INTO nnq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Simoni ngabauta bandu ajingi nukuomongwa kwa machoba goa kwa magambu ga uwabe gwakwe. ");
INSERT INTO nnq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nambu ngubunhwamini nhwalo gwa Filipo kunhwalo gwa mbone gwa Kingwana cha Nnoongo na kwa liina lya Yesu Kilisto, akinalome na akikege ngababatichigwa. ");
INSERT INTO nnq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na mwene Simoni ngaamini, nu kuboka pa kubatichigwa ngabe akakengamana na Filipo na ngaomongwa apaibona ikobo eikiba ikatendigwa. ");
INSERT INTO nnq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Achandundame ba Kuyelusalemu ngabajoa kube bandu ba Samalia bapokelinge lilobe lya Nnoongo, kuyenie ngabankinga Petulo na Yohana ku Samalia. ");
INSERT INTO nnq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pabaikangaga ngabanng'ongale Nnoongo bape Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gambu kingobu chenie Uhuke jwa Chwapi akiba tango anaikaje kumundu jwajoa kati jabe, bakiba babatichigwe tu kuliina lya Angwana ana Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Penia Petulo na Yohana ngababekelanga maboko abaamine, na angweto ngabapokela Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Penia Simoni ngalola kube abaamine bapokalinge Uhuke jwa Chwapi kwakabekelanga maboko ga achandundame. Kuyenie ngapala kape uloi Petulo na Yohana, ");
INSERT INTO nnq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na ngalenga, “Umbegange na nenga kinala chenie kupala mundu jwajoa ojumba kummeke maboko, apoke Uhuke jwa Chwapi.” ");
INSERT INTO nnq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nambu Petulo ngannyanga jwenio, “Mwe nnyomoke nu uloi gwinu magambu nkita nhwotwile kuemela hupo ya Nnoongo ku uloi! ");
INSERT INTO nnq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nkwetije kilebe chachoa wala mpaligweje muliengo lito, magambu mwojo gwinu ubi telaje nnongi ja mio ga Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kuyenie, nnape ubaja gwinu gongo na majope Angwana na bombe baotwile kunnekekea mawacho ginu. ");
INSERT INTO nnq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gambu ne nammona mwe ntweli bwiu na mapungwa ba ndela jinu mbaja.” ");
INSERT INTO nnq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni ngannenge Petulo na Yohana, “Chonde unnyopele kwa Angwana, ibe lyakambataje wala limwe kati ja genia agannongalinge.” ");
INSERT INTO nnq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kuboka pa Petulo na Yohana kuchalakicha nu kutangacha nhwalo gwa Angwana, ngababuja Kuyelusalemu. Apabakiba bakabuja undela ngabatangacha Nhwalo Gwambone pi ijiji ndu ya Samalia. ");
INSERT INTO nnq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mpakachi jwa Angwana kuboka kumbengu ngannengela Filipo, “Mpanganike nnyende kubanda kupetela ndela ejiboke Kuyelusalemu kujenda ku Gaza.” Ndela jenie kupetekaje machoba ganga. ");
INSERT INTO nnq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipo ngapanganika, ngatumbu mwanja. Kingobucho kukiba na mundu jumwe Muethiopia, mmeka uloi jwa linyongolo jwa Kandeke juku Ethiopia, ojwabekigwe panani ja ilebe yakwe yoa, na akiba ajeile Kuyelusalemu kunng'ongalela Nnoongo na kingobu chenie akiba akabuja kachakwe mumutuka jakwe jukuuta. ");
INSERT INTO nnq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Apakiba mumwanja akiba akachoma kitabu cha nnondoli Isaya. ");
INSERT INTO nnq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Uhuke jwa Chwapi ngannengela Filipo, “Nnyende mpaka ku mutuka makatame papipi najo.” ");
INSERT INTO nnq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo ngabutukila papipi na mutuka, ngannyoa mundu jwenio akachoma paali pa kitabu cha nnondoli Isaya. Penia Filipo ngankonya, “Bo, magamanyi genia ganchoma?” ");
INSERT INTO nnq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mundu jwenio ngannyanga, “Nhotola bo kumanya panga mundu kunongolea?” Penia ngampembela Filipo aombele mumutuka atame pamwe nakwe. ");
INSERT INTO nnq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Paali pa majandiko Gachwapi apakiba akachoma pakiba paandikigwe yene, “Akiba andi limbelele elipelekigwa kuchinjigwa, andi mwana limbelele apatama nuu apabunhweketa majuni. Jwombe alongi kileje. ");
INSERT INTO nnq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ngakachipiigwa na ngajimigwa echapala. Abije jwapakuotola kulongela na lungolo lwakwe, magambu bwomi gakwe padunia uboigwe.” ");
INSERT INTO nnq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mwethopia jwenio ngannengela Filipo, “Unengele, nnondoli jwenio alenga nhwalo nike? Alenga ilebe yenje gambu gakwe mwene andaje magambu ga mundu jonge?” ");
INSERT INTO nnq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Penia, Filipo ngatumbula upapa pa Majandiko Gachwapi, ngannengela Nhwalo Gwambone gwa Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Apabakiba tango bakajenda undela, ngabaika paali pina mache, na ofisa jwenio ngalenga, “Paali pamba mache gabile, bo kinike chikipa kunhwibila kubatichigwa?” ");
INSERT INTO nnq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo ngalenga, “Anda nhwamini kwa mojo gwinu gwoa nhwotwile kubatichitigwa.” Jwombe ngajanga, “Elo, amine kube Yesu Kilisto nga Mwana jwa Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Penia, ofisa ngaamulicha mutuka jela jijeme, na boa Filipo na ofisa ngabaelela kumache, na Filipo ngammaticha. ");
INSERT INTO nnq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Apabapitanga umache Filipo ngatoligwa na Uhuke jwa Angwana. Ofisa amwenije kabele Filipo, nambu ngajendeke na mwanja gwakwe kongo aali mwojo. ");
INSERT INTO nnq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo ajitukila abi kukilambo cha Azoto, ngapeta muilambo yoa akatangacha Nhwalo Gwambone mpaka paika kukilambo chuku Kaisalia. ");
INSERT INTO nnq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kingobu chenie Sauli ngajonjake iticho ya kakoma akinapunji ba Angwana. Ngajenda kwa Akakung'i akolongwa, ");
INSERT INTO nnq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na ngajopa bampe balua ju kulaya ku majumba gukugongalela ga Akayahudi okwo ku Damasko, ibe anda bakolile kwenio akinalome andaje akikege abakengama ndela ja Angwana, bapukile na kaleta Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nambu apakiba undela papipi na kuika ku Damasko, kingobu tu lumuli kuboka kunani ngulummulika tii nde. ");
INSERT INTO nnq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ngagwe pae nu kulijoa lilobe lyakannengela, “Sauli, Sauli! Mboni umboteka?” ");
INSERT INTO nnq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli ngakonya, “Angwana Mwe mabeneke?” Lilobe ngililenga, “Ne na Yesu maumboteka.” ");
INSERT INTO nnq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Nambu ngoe nnyinuke nnyeme, nnyende kunnyini kwenio mamakalengaligwa echimpaligwa ukamula.” ");
INSERT INTO nnq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bandu abatyangita pamwe na Sauli ngabajema penia, bakiba nuu, ngibilijoa lilobe lela nambu bammwenije mundu jwajoa. ");
INSERT INTO nnq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli ngajinuka, apajiga kueku mio gakwe aotwije kukibona kilebe. Penia bandu bala ngabannongolea kukunkamu luboko mpaka ku Damasko. ");
INSERT INTO nnq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sauli ngatama kwa machoba matatu aotwije kulola, na kingobu chenie alije kilebe andaje kunywe chochoa. ");
INSERT INTO nnq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kwenio, ku Damasko pakiba na napunji jumwe ojwakemigwa Anania. Angwana ngabannengela mumalolo, “Anania!” Anania ngajeketa, “Mbi pamba, Angwana.” ");
INSERT INTO nnq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Angwana ngabannengela, “Mpanganike nnyende kundela ejikemigwa Ndela ja Kipola, na kunyumba ja Yuda nkonyeke mundu jumwe ju kuboka ku Taso ojwakemigwa Sauli. Ngoe atenda kugongalela, ");
INSERT INTO nnq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na mumalolo ngammona mundu ojwakemigwa Anania akajingila unyumba kummekela maboko ibe aotole kulola kabele.” ");
INSERT INTO nnq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nambu Anania ngajanga, “Angwana, nyoine minhalo ja mundu ojo kuboke ku bandu ndu, nyoine nhwalo gwa mabaja agabatendelinge bandu ba Nnoongo bu Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na aike pamba abi ni kinala kuboka kwa akakung'i akolongwa kapukilanga boa abanng'ongalela mwenga.” ");
INSERT INTO nnq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Angwana ngabannengela, “Nnyenda tu, magambu nampambwi jwenio abe chombo chango, atangache liina lyango kuilambo yoa na akangwana nu kubandu bu Kuisilaeli. ");
INSERT INTO nnq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne manannaya jwenio goa agapaligwa kupotekigwa magambu gwa liina lyango.” ");
INSERT INTO nnq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania ngajenda, ngajingila munyumba omwakiba Sauli, na ngabeka maboko gakwe panani jakwe. Ngalenga, “Malongo ana Sauli, Angwana ana Yesu abampitila undela kingobu echimakiba makaika pamba, bangingite nenga ibe mpate kulola kabele na ntwele Uhuke jwa Chwapi.” ");
INSERT INTO nnq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Upo ngitola ilebe andi mangalabata ga chamaki kuboke mumio ga Sauli, ngaotola kulola kabele. Ngajema nu ngabatichwa, ");
INSERT INTO nnq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","na kuboka pa kulye chakulya, makakala gakwe ngagammujila. Sauli ngatama machoba machoko pamwe na akinapunji ku Damasko. ");
INSERT INTO nnq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ngajenda mpaka ku majumba gu kugongalela Nnoongo na ngatumbula kutangacha kutenda Yesu nga Mwana jwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Boa abannyoa ngabaomongwa nukonya, bakalenga, “Bo ojo ujwajoje jubakoma bandu Kuyelusalemu abakiba bakagongalela kwa liina lya Yesu? Kabe aikila pamba apaala kapukila bandu benia na kapeleka kwa akakung'i akolongwa?” ");
INSERT INTO nnq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nambu matangacho ga Sauli ngagajonjekea kube na makakala muno, nu kuchalakicha kube Yesu nga Kilisto Nkomboi ojwapambuligwe na Nnoongo, Akayahudi abatamanga ku Damasko bannyangitije jwombe. ");
INSERT INTO nnq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kuboka pa machoba ndu kupeta, Akayahudi ngabakongana pamwe na ngabapangana kunkoma Sauli, ");
INSERT INTO nnq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","nambu Sauli ngalengeligwa njama jenie. Kilo na mui ngabannyobelanga pimilyango ji kujingalila kunnyini ibe bankomange. ");
INSERT INTO nnq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nambu lichoba limwe kilo akinapunji bakwe Sauli ngabantola jwombe ngabampia panja kupete pililanga li lumati, ngubunhuluya nkati ja kikapo kikolongwa. ");
INSERT INTO nnq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli ngabuja Kuyelusalemu na ngajiga kengamana na akinapunji. Nambu bunhwaminije kube akiba napunji, na boa ngabannyogopa. ");
INSERT INTO nnq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Penia Banaba ngaika kunnyangata nu kumpeleka kwa achandundame. Ngabalandulila angweto Sauli apababweni Angwana undela na Angwana ngabalonge nakwe. Ngabalenge uyo Sauli akiba akatangacha ku Damasko ku liina lya Yesu pangajogopa. ");
INSERT INTO nnq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sauli ngatama pamwe na angweto, ngatyanga Kuyelusalemu kwoa akatangacha lilobe lya Angwana panga jogopa. ");
INSERT INTO nnq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kabe uyo ngalongela nukutaukana na Akayahudi abalongela Kigiliki, nambu angweto ngabapala kunkoma. ");
INSERT INTO nnq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Abaamine apabajoa kilebe chenie, ngabantola Sauli, ngabampeleka ku Kaisalia, ngabanneka ajende ku Taso. ");
INSERT INTO nnq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kingobu chenie kikuta cha bandu abunhwamini Kilisto ngikibe tengela Kuyudea nu Kugalilaya nu Kusamalia joa. Ngikibe na makakala nukola na bandu ngabajonjake kube ndu kuwecho gwa Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petulo ngatyanga kila paali ngaika ku bandu ba Nnoongo abatamanga ku Lida. ");
INSERT INTO nnq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kwenio ngankolela mundu jumwe ojwakemigwa Enea ojwakiba apolite mmele kukingobu cha yaka nane akiba agolwike pikindanda. ");
INSERT INTO nnq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petulo ngannengela, “Enea, Yesu Kilisto annamia. Nnyinuke ntandike kindanda chinu.” Upo Enea ngajinuka. ");
INSERT INTO nnq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bandu boa ba Lida na Solani ngabammona Enea, na boa ngababujila Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kukiba na munkege jumwe kukilambo cha Yopa ojwakemigwa Tabitha, Kukiyunani nga Dolika, mana gakwe, Mbala. Munkege jwenio akamula gambone kajangata akaocho. ");
INSERT INTO nnq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kukingobu chenie akiba ntamwe, ngawe. Bandu ngubujoya nchiba gwakwe ngubugoneka muchumbi kugolofa. ");
INSERT INTO nnq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kuyopa kukiba kutalije na ku Lida, na bandu buku Yopa akinapunji pabamanya kutenda Petulo abi ku Lida ngabakinga bandu abena bakannenge Petulo nhwalo gwenio, “Chonde nhwike kongo chokwe.” ");
INSERT INTO nnq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Penia, Petulo ngajabula pamwe nabo. Kuika tu ngabampeleka kugolofa kuchumbi. Kwenio akinawele ajingi ngabantindila Petulo bakaguta nukunnaya ngobo eyachona Dolika kingobu apakiba mmomi. ");
INSERT INTO nnq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulo ngabapia panja boa, ngakilikitila, ngagongalela Nnoongo. Kuboka penia ngautendebukia nchiba ngalenga, “Tabitha, nnyimuke.” Na jwombe ngaekula mio gakwe na apammona Petulo, ngajimuka kutama. ");
INSERT INTO nnq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petulo ngannyangata kunnyinula, kuboka penia ngabakema bandu ba Nnoongo na akanawele, ngabakamuya abi mmomi kwabe. ");
INSERT INTO nnq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nhwalo gwenio ngujoanika kila paali ku Yopa, na bandu ajingi ngabaamini Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petulo ngatama machoba ndu ku Yopa, atama kwa mundu jumwe pundi jwa mambendela ojwakemigwa Simoni. ");
INSERT INTO nnq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kukiba na mundu jumwe ku Kaisalia ojwakemigwa Konelio, nkolongwa jwa kikuta cha manjolinjoli chuku Loma kikemigwa, “Kikuta cha manjolinjoli guku Italia.” ");
INSERT INTO nnq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Akiba mundu jwambone, jwombe pamwe na akalonga mundu boa banng'ongalela Nnoongo, akiba akatenda ile ijingi ya kajangata akaocho ba Kiyaudi na akiba akagongalela Nnoongo kila kingobu. ");
INSERT INTO nnq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ikiba saa tisa kimuyo, mumalolo ngammona mpakachi jwa Nnoongo kuboka kumbengu akajingila unyumba nu kunnengela, “Konelio!” ");
INSERT INTO nnq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konelio ngannoleke muno mpakachi jwenio kukujogopa, ngannengela, “Kibi nike ananhota?” Mpakachi jwenio ngajanga, “Nnoongo annyeketile kugongalela kwinu na malumbo ginu kwa akaocho, na alibilije. ");
INSERT INTO nnq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ngoe makinge bandu ku Yopa bakankeme mundu jumwe ojwakemigwa Simoni, kuliina lenge Petulo. ");
INSERT INTO nnq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jwombe nng'eni jwa Simoni pundi jwa mambendela nyumba jakwe jibi papipi na baali.” ");
INSERT INTO nnq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na mpakachi kuboka kumbengu apajomola kulenga genia ngajabula, Konelio ngabakema akapakachi abena bakachakwe na nnenda, ojwakiba akanng'ongalela Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ngabalengela goa agapitile, ngabakinga ku Yopa. ");
INSERT INTO nnq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Malabo jakwe, bandu akatatu benia kongo babi tango mumwanja, nambu papipi na kuika ku Yopa, Petulo ngaombela kunani ja dali ikiba saa sita mui ibe akagongalele. ");
INSERT INTO nnq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ngijimmina njala ngapala kile chukulye, kingobu chakulya apikikiba chakatelekigwa, ngalola malolo. ");
INSERT INTO nnq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ngajibona mbengu jiwekuligwe ni kilebe andi ngobo jikikiyeka ngolongwa jakauluigwa pae kongo jikamuligwe mumalombola gakwe ncheche. ");
INSERT INTO nnq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nkati ja ngobo jikikiweka jenie mukiba na kila inyama, inyama ina makongono ncheche, inyama eikwaba ni ijuni yu kunani. ");
INSERT INTO nnq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ngalijoa lilobe lyakalenga, “Nnyinuke, Petulo, nchinje nnie!” ");
INSERT INTO nnq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nambu Petulo ngalenga, “Ije, Angwana! Ne nanalyeje kile chochoa chu nhwilo andaje kichapu.” ");
INSERT INTO nnq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lilobe lela ngilijoanika kabele lyakalenga, “Mikikemaje ichapu ilebe eyaijegwiye Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nhwalo gwenio upiti patatu, na pukujomolela yoa ngitoligwa kujenda kumbengu. ");
INSERT INTO nnq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petulo apakiba tango akaomongwa mana ja malolo genia, bandu abakakingigwa na Konelio, kuboka pa kuimanya nyumba ja Simoni, ngabaika nnongi ja nnyango. ");
INSERT INTO nnq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ngabakema nukonya, “Abi nng'eni pamba ojwakemigwa Simoni Petulo?” ");
INSERT INTO nnq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petulo akiba tango akajiga kugamanya malolo gala na penia Uhuke jwa Nnoongo ngannengela, “Mpenakie! Babi bandu akatatu pamba batenda mpalapala. ");
INSERT INTO nnq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nhwuluke chokwe na makapweleje kujenda pamwe nangweto magambu nenga nanakingite.” ");
INSERT INTO nnq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Penia Petulo ngauluka pae, ngabalengela bandu benia, “Nenga nga mundu jumampalapala. Kunike nhwikilinge?” ");
INSERT INTO nnq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Angweto ngabannyanga, “Nkolongwa jwa akalenda Konelio mundu jwambone, ojwanng'ongalela Nnoongo na juna kupata ichima muno nnongi ja Akayahudi boa, atukingite. Ngalengeligwa na mpakachi jwa Chwapi kuboka kumbengu bakinge bandu kwinu, ankoke kachakwe kupala apenakie kilebe chochoa echimpakulongela.” ");
INSERT INTO nnq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petulo ngabapokela unyumba, ngabape paali pu kugoloka kilo. Malabo jakwe, Petulo ngatumbula mwanja pamwe na angweto, na bange abaamine ba kwenio ku Yopa ngabalongwana nakwe. ");
INSERT INTO nnq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lichoba eliika ngabaika ku Kaisalia na kwenio Konelio atela kalenda pamwe na akalongo na akaganja ababakokite. ");
INSERT INTO nnq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petulo apakiba akajingila, Konelio ngapita panja kumpokela, ngakilikitila majugwa nnongi ja Petulo. ");
INSERT INTO nnq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nambu Petulo ngannyinula, ngannengela, “Nnyeme, magabu nenga namundu tu.” ");
INSERT INTO nnq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petulo ngajendekea kulongela na Konelio kongo bakajingila unyumba omwabakolela bandu ajingi bakonganinge. ");
INSERT INTO nnq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petulo ngabalengela, “Mangweto mmene mmanyi kube Nhyahudi jwajoa akanakigwe na malagilo gakwe ga dini kube lyabe limwe na bandu banga Akayahudi. Nambu Nnoongo anaite nakanhwachilaje mundu jwajoa kube nhwilo andaje nchapu. ");
INSERT INTO nnq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwa magambu genia, apaungemangita nhike panga pwelea. Nankonyanga, ungemalinga nike?” ");
INSERT INTO nnq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konelio ngalenga, “Machoba matatu agapetite kingobu andi uchenje, saa tisa kimuyo, nakiba nakagongalela kuchumbi jango. Kingobucho, mundu ojwakiba akwindite ngobo ina kung'ala ngajema nnongi jango, ");
INSERT INTO nnq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ngalenga, ‘Konelio! Kugongalela kwinu na malumbo ginu kwa akaocho Nnoongo ajeketile. ");
INSERT INTO nnq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mankinge mundu ajende ku Yopa akankeme mundu jumwe ojwakemigwa Simoni, ku liina lenge Petulo. Jwombe nng'eni jwa Simoni pundi jwa mambendela papipi na baali.’ ");
INSERT INTO nnq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ku yenie nganagila nhwalo nhwike chokwe na mwe ntei chwapi kuika. Ngoe twe tubi nnongi ja Nnoongo, kupenakia chochoa echibunhwamuliche Angwana kulenga.” ");
INSERT INTO nnq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Penia Petulo ngatumbu kulenga, “Ngoe manyi kube kweli Nnoongo kupembulaje. ");
INSERT INTO nnq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nambu kila kilambo mundu anda akamu gapala Nnoongo kujeketiligwa na jwenio, kujalije mundu kilambo chaboka. ");
INSERT INTO nnq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gongo nga nhwalo Nnoongo ogwaupelika ku bandu ba Isilaeli, akatangacha Nhwalo Gwambone oguleta tengela kundela ja Yesu Kilisto ojwapambuligwe na Nnoongo, ojwabi Nngwana jwa boa. ");
INSERT INTO nnq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mangweto mmanyi nhwalo ogupitile kukilambo choa cha Kuyudea, kutumbu Ku Galilaya kuboka pa Yohana kutangacha nhwalo gwa kubaticha. ");
INSERT INTO nnq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mummanyi Yesu jwa ku Nazaleti Nnoongo apampambwile kukunnyelela Uhuke jwa Chwapi na makakala. Ngajenda kila paali, akatenda gambone na kalamia boa ababoneligwe na Mmaja, gambu Nnoongo akiba pamwe nakwe. ");
INSERT INTO nnq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Natwe takachaili ba minhalo joa ajatenda kukilambo cha Akayahudi na kukilambo cha Yelusalemu. Penia ngabankoma kukummamba panchalaba. ");
INSERT INTO nnq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nambu Nnoongo ngannyoa lichoba lya tatu nu kuntenda abonekane, ");
INSERT INTO nnq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kubandu boaje, nambu kwa baba Nnoongo abapambuligwe babe akachaili bakwe, yani twenga twatulile nu kunywe pamwe nakwe kuboka pa kuyoka kwakwe kuboke kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ngatuamulicha tutangache Nhwalo Gwambone ku bandu boa nu kuchalakicha kutenda jwombe nga ojwapambuligwe na Nnoongo abe akimu jwa ababi ammomi na abawile. ");
INSERT INTO nnq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Akalondoli boa ngabachalakicha nhwalo gwakwe kube kila mundu ojwapakunhwamini malekekigwa mabaja gakwe goa kulina lyakwe.” ");
INSERT INTO nnq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kingobu Petulo apakiba tango akalongela malobe genia, Uhuke jwa Chwapi ngabaulukila boa abakiba bakapenakia nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Akayahudi abaamine abaikalinge pamwe na Petulo kuboke ku Yopa ngabaomongwa kube Nnoongo ngabape hupo ja Uhuke jwa Chwapi uyo bandu banga Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gambu ngabajoanga bakalongela kukilonge kiyono bakankoleya Nnoongo. Petulo ngalenga, ");
INSERT INTO nnq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Bandu bamba bapokile Uhuke jwa Chwapi andi twenga tubene apatumpokile. Bo, abi mundu jwajoa ojwaotwi kakanakia bakabatichigwaje kwa mache?” ");
INSERT INTO nnq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kuyenie, ngaamulicha babatichigwe kuliina lya Yesu Kilisto ojwapambuligwe na Nnoongo. Penia ngabannyopa atame nabo kwa machoba machoko. ");
INSERT INTO nnq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Achandundame na abaamine bange buku Yudea ngabajoa kutenda bandu banga Akayahudi uyo bapokalinge lilobe lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petulo apabuja Kuyelusalemu, Akayahudi abaamine abapala bandu banga Akayahudi bainigwe, ngabanchonjoya kulenga, ");
INSERT INTO nnq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Mwenga ngantama kachabe bandu bangainigwa nu kulye nabo pamwe!” ");
INSERT INTO nnq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Penia Petulo ngabalenge tela nhwalo ogupitila kuboka pututumbulaga, ");
INSERT INTO nnq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kingobu apanakiba nakagongalela kunnyini ku Yopa, nganola malolo. Nginikibona kilebe chikaika pae kikiba andi ngobo jikikiyeka ngolongwa jakauluigwa pae kuboka kumbengu kongo jikamuligwe mumalombola gakwe ncheche, jibekigwe papipi jango. ");
INSERT INTO nnq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nganolakea muno kukuingakia nginibona inyama ina makongono ncheche, inyama ya mpongoti na yukulanga ni inyama eikwaba ni ijuni yukunani. ");
INSERT INTO nnq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kubokapenia nginilijoa lilobe lyakalenga, ‘Petulo nnyinuke, nchinje nnie!’ ");
INSERT INTO nnq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nambu ne nganenga, ‘Ije, Angwana! Chanajingije mukano jango chakulya chu nhwilo andaje kichapu.’ ");
INSERT INTO nnq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lilobe lela ngilijoanika kabele kuboka kumbengu, ‘Mikikemaje ichapu ilebe ijeguigwe na Nnoongo.’ ");
INSERT INTO nnq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nhwalo gwenio upiti patatu, na pukujomolela yoa ngitoligwa kujenda kumbengu. ");
INSERT INTO nnq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Upo, bandu akatatu abakiba bakingigwe kwango kuboka kwa Kaisalia ngabaika kunyumba ejinakiba nakatama. ");
INSERT INTO nnq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Uhuke jwa Nnoongo nganengela nyende pamwe nangweto panga mbwele. Abaamine sita ngabalongwana pamwe na nenga kujenda ku Kaisalia na kwenio ngutuika kachakwe Konelio. ");
INSERT INTO nnq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jwenio ngatulengela apammona mpakachi kuboka kumbengu ajemite kachakwe nukunnenge, ‘Mankinge mundu ajende ku Yopa akankeme mundu jumwe ojwakemigwa Simoni, lengi liina Petulo. ");
INSERT INTO nnq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jwenio mannengela malobe agabakuntenda mwenga nakalongo binu nkomboligwa.’ ");
INSERT INTO nnq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na panatumbala kulongela tu, Uhuke jwa Chwapi ngabaulukila andi apatuulukila twenga pukutumbulaga. ");
INSERT INTO nnq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Penia ngangombakela malobe ga Angwana gabalenga, ‘Yohana abaticha kwa mache, nambu mangweto mammatichigwa ku Uhuke jwa Chwapi.’ ");
INSERT INTO nnq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Anda Nnoongo bapile lilumbo uyo bandu banga akayahudi lilumbo ulyale elyatupa twenga apataamina Angwana ana Yesu Kilisto, bo, ne nabeneke nhoto kunkana Nnoongo?” ");
INSERT INTO nnq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Angweto pabajoa genia, ngabakotoka kutauka na ngaba nkolea Nnoongo, kulenga, “Nnoongo bapi lilanga bandu banga akayahudi lyu kulapa mabaja gabe bapatange bwomi!” ");
INSERT INTO nnq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kuboke kupotekigwa kukupitila kingobu apakomigwa Stefano, abaamine ngaba pwilikana. Bange ngabajenda mpaka kilambo ya Kufoinike na Kukupulo na Kuantiokia bakatangacha nhwalo gwa Nnoongo kwa Akayahudi jika. ");
INSERT INTO nnq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nambu abaamine bange kuboka kukilambo chiku Kupulo na Kulene, ngabajenda kukilambo cha Kuantiokia nu kutangacha Nhwalo Gwambone gwa Angwana ana Yesu ku bandu Akayahudi Bikigiliki. ");
INSERT INTO nnq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Makakala ga Angwana ngagabe pamwe na angweto na bandu ajingi ngabaamini na kabuji Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nhwalo gu kile chenie ngujoanika kikuta cha bandu abunhwamini Kilisto chu Kuyelusalemu, yene ngabankinga Banaba ajende ku Antiokia. ");
INSERT INTO nnq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kingobu apaika kwenio nakabona bandu Nnoongo pabapi upeele ngaala mojo nakakwajalila angweto boa babe na imani ja kweli ka Angwana kumyojo jabe joa. ");
INSERT INTO nnq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba akiba mundu jwambone ojwatweli Uhuke jwa Chwapi na imani, na bandu ajingi ngabautigwa ka Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Penia Banaba ngajenda ku Taso kumpalapala Sauli. ");
INSERT INTO nnq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Apampata, ngabanneta Kuantiokia, na boa abena ngabatama ni kikuta cha bandu abunhwamini Kilisto. Kwenio ku Antiokia, kukutumbula kakema akinapunji aka Kilisto. ");
INSERT INTO nnq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kingobu chenie, bange akalondoli ngabaika ku Antiokia kuboke Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jumwe kati jabe ojwakemigwa Agabo ngajema na kuwecho gwa Uhuke jwa Nnoongo ngalondola kutenda kupakube na njala ngolongwa kuilambo yoa. Njala jenie jikiba kingobu Kilaudio apakiba ntawala. ");
INSERT INTO nnq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Akinapunji ngabaamu kila mundu tela na uwecho gwakwe apeleke chachoa kupala kajangata abaamine abakiba bakatama ku Yudea. ");
INSERT INTO nnq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ngabatenda genia nukupeleka chango yabe kwa akinanhota bi ikuta ya bandu abanhwamine Kilisto kupete maboko ga Banaba na Sauli. ");
INSERT INTO nnq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kingobu chenie, Nngwana Helode ngatumbu kapoteka bange kati ja kikuta cha bandu abunhwamini Kilisto. ");
INSERT INTO nnq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ngankoma ku upanga Yakobo nnongo gwa Yohana. ");
INSERT INTO nnq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Helode palola kube kikobo chenje kite kaalalila Akayahudi, ngajenda kumpuki Petulo. Kile chenie kikamuligwa kingobu cha Mpapala gwa Mikate Jangajeligwa Amila. ");
INSERT INTO nnq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kuboka pukupukaligwa, Petulo ngaba mmeka kukipungo, kwenio ngabammeka alendeligwe muikuta ncheche ina akalenda ncheche ncheche. Helode apanga kumpia Petulo pukongolou kuboka pa mpapala gwa Pasaka. ");
INSERT INTO nnq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petulo apakiba mukipungo, kikuta cha bandu abunhwamini Kilisto kikiba chakagongalela ku Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tango nukuikaje lichoba lyale Helode papala kumpia Petulo puukongolou, licho kilo jakwe Petulo akiba agolwike panakati ja akalendei abena. Akiba atabaligwe mitondolo mibena, na akalenda bakiba bakalendela nniango gwa kipungo. ");
INSERT INTO nnq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Upo, mpakachi jwa Angwana kuboka kumbengu ngajema papipi na jwenio na lumuli ngulumulika chumbi cha kipungo. Mpakachi ngannyukanyuka Petulo pilipamba akalenga, “Nnyinuke chokwe!” Kingobu uchache mitondolo ngijikuluguka kuboke mumaboko gakwe. ");
INSERT INTO nnq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mpakachi ngannengela, “Mikitabe luunga lwinu, nkwinde ilatu yinu.” Ngatenda yene. Kuboka penia mpakachi jwenio ngannengela, “Nkwinde likoti linu, ungengame.” ");
INSERT INTO nnq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petulo ngankengama panja ja kipungo nambu amanyije kutenda genia gakamuligwe na mpakachi jwenio gakiba ga kweli, akita atela kulola malolo. ");
INSERT INTO nnq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ngabapeta pukutumbu ulenda na pukubwelea ulenda, kuboka penia ngabaika pa nniango gwa choma kujenda kunnyini. Nniango gwenio ngujogoka gwene na angweto ngabapita panja. Ngababe kujenda pawe kingobu tu mpakachi jwa Angwana nganneka Petulo. ");
INSERT INTO nnq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petulo ngamanya agampitile, ngalenga, “Ngoe manyi kipola! Angwana bankingite mpakachi jwabe kuboka kumbengu angombole kuboke mumakakala ga Helode nu kuboke mwilebe yoa eibayobalila bandu bu Kuhyahudi ipitile.” ");
INSERT INTO nnq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Apamanya yene ngajenda kachakwe Maliamu umamundu Yohana ojwakemigwa Maluko. Mwenio bandu ajingi bakiba bakonganinge bakagongalela. ");
INSERT INTO nnq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petulo ngagomba oti pa nniango panja na mpakachi jumwe nhwenja ojwakemigwa Loda, ngajenda pa nniango kujekete otina. ");
INSERT INTO nnq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nhwenja jwenio ngalimanya lilobe lya Petulo ngaala mojo muno ngabuja unyumba lubelo nakalenge bandu kutenda Petulo ajemite panja. ");
INSERT INTO nnq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bandu gabannenga nhwenja jo, “Matamwe machonjo!” Nambu jwombe ngayangala kulenga kweli angweto ngabannengela lyenie lihoka lyakwe. ");
INSERT INTO nnq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petulo akiba akajendekea kugomba oti. Pukujomolela ngabajogolanga nniango na pabammona ngabaomongwa. ");
INSERT INTO nnq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petulo ngabaponge luboko batamange nu, ngabalandulila paboigwe mukipungo na Angwana. Penia ngabalagila, “Makannenge Yakobo na bandu bange abaamine,” kubokapenie ngabaleka ngajenda konge. ");
INSERT INTO nnq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pukuchaga, ngukupiti mbwele kati ja akalenda, chikipiti kwa Petulo? ");
INSERT INTO nnq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode ngaamulicha bampalepale nambu baotalingije kumpata. Penia ngaamulicha akalenda bala bakonyange, ngaamulicha bakomigwe. Paulo kubokapenia ngaboka ku Yudea ngajenda ku Kaisalia okwatama kalakala. ");
INSERT INTO nnq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode ngabachimwa bandu bi kilambo chi ku Tilo na Sidoni, nambu angweto ngaba kinga bandu kunnyendele Helode. Na ngweto ngabampata oti Bulasto, ojwakiba nkolongwa jwa Boma ja ngwana Helode. Kubokapenia ngabannyendele Helode kunnyopa kube tengela, magambu kilambo chabe kihyobalela kupata chakulya kuboke kilambo cha Angwana Helode. ");
INSERT INTO nnq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lichoba limwe elipambuligwe na Helode ngakwinda ngobo ikingwana, nukutama kitebu cha kingwana na ngalonge na bandu. ");
INSERT INTO nnq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bandu ngaba chobela kulenga, “Lilobe lende lya munduje, nambu nnongo.” ");
INSERT INTO nnq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Upo mpakachi jwa Angwana nganng'wia Helode pae, magambu ampije kibumo Nnoongo. Ngaleligwa na mabongo nukuwe. ");
INSERT INTO nnq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lilobe lya Nnoongo ngilijendeke kujoanika nu kola. ");
INSERT INTO nnq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba na Sauli ngabajomo liengo lyabe lyabakingigwe ngababuja kabele Kuyelusalemu, uyo ngabantola Yohana ojwakemigwa Maluko. ");
INSERT INTO nnq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kati ji kikuta cha bandu abunhwamini Kilisto Kuantiokia kukiba na akalondoli bange na akaboli. Benia nga Banaba na Simioni ojwakemigwa Mpili, Lukio kuboke ku Kulene, Manaeni ojwannela Nngwana Helode na Sauli. ");
INSERT INTO nnq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Apabakiba bakagongalela kwa Angwana nu kupunga, Uhuke jwa Chwapi ngabalengela, “Umbambulilange Banaba na Sauli, bakamulange liengo elinakemile.” ");
INSERT INTO nnq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ngabapunga nu kugongalela, nu kabekelanga maboko panani jabe, ngabaleka bajabulange. ");
INSERT INTO nnq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banaba na Sauli apabakingigwa na Uhuke jwa Chwapi, ngabajenda mpaka ku Seleukia nu kuboka kwenio ngabaombe mungalaba kujenda Kukupulo. ");
INSERT INTO nnq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kingobu apabaikanga ku Salami, ngabatangacha lilobe lya Nnoongo ku nyumba ya kugongalela ya Akayahudi. Na angweto bakiba na Yohana abe mpakachi jwabe. ");
INSERT INTO nnq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Angweto ngabatyanga kupete kingono chimwe cha kichilu mpaka ku Pafo, okwabankolela mundu jumwe nhwabe ojwakemigwa Bali Yesu, Nhyahudi ojwakitenda nnondoli. ");
INSERT INTO nnq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mundu jwenio akiba nng'anja jwa nkolongwa jwa kichilu, ojwakemigwa Segio Paulo ojwakiba juna malango, ngabakema Banaba na Sauli magambu apala kupenakia lilobe lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nambu nhwabe jwenio Bali Yesu, liina lyenie ku Kukiyunani mankema Elima, ngajiga katauka Banaba na Sauli na kunhwibalakia nkolongwa jwa kichilu akaaminije imani yene. ");
INSERT INTO nnq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Penia Sauli ojwakemigwa Paulo, kongo atweli Uhuke jwa Chwapi, ngampikia mio nhwabe Elima ");
INSERT INTO nnq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kulenga, “Mwe mamwana jwa Mmaja! Namangondwa kukilebe chochoa chambone chapala Nnoongo. Mwe ntweli ndela ndu yubaja na mwe kila kingobu nnyiga kujigalambuya kweli ja Angwana kube uwangi! ");
INSERT INTO nnq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ngoe luboko lwa Angwana lupakunhukumu, mma kinjwilili na milibonaje lichoba kukingobu.” Upo ngongobwi nulubendu ngulunhwikalila Elima na ngabe kinjwilili na ngatumbu kupupukia kongo na kongo akampalapala mundu jukunkamu luboko annongaleye. ");
INSERT INTO nnq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nkolongwa jwenio apalola agapitile, ngaamini, ngaomongwa maboulo ga nhwalo gwa Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo na akajakwe ngabaombe muntumbwi kuboke Kupafo ngabaika Kupega kunnyini Kupamfilia, kwenio Yohana ngabaleka ngabuja Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Angweto ngabajendeke na mwanja kuboke ku Pega mpaka kunnyini ku Antiokia ku Pisidia, na Lichoba lya Kupomolela ngabajingi munyumba ja kugongalela Nnoongo, ngabatama. ");
INSERT INTO nnq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kuboka pa kuchoma kitabu cha Malagilo ga Musa na majandiko ga akalondoli ba Nnoongo, akakolongwa ba nyumba ja kugongalela ngabalagi nhwalo gongo, “Makalongo, anda nkweti nhwalo gwa kalengela bandu kupala balimbe mwojo, nnengange.” ");
INSERT INTO nnq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo ngajema, ngaponga luboko, ngatumbu kulenga, “Mabandu ba Kuisilaeli na bandu manga akaisilaeli mamunng'ongale Nnoongo, umbenakiange! ");
INSERT INTO nnq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nnoongo jwa bandu ba Kuisilaeli ngabapambula akahoka bito na kape indimba muno bandu aba kugeni okwo Kumisili. Nnoongo ngababoya kwenio kuwecho nkolongwa, ");
INSERT INTO nnq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","na ngabaimbali yaka alubaini kupongoti. ");
INSERT INTO nnq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ngabajomo bandu makabila saba kukilambo chi Kanaani na kape kilambo chenie kibe chabe. ");
INSERT INTO nnq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Goaga gatendigwa kwa yaka alubaini nu nhwano. “Kuboka penia ngabape bukuhukumula mpaka kingobu cha nnondoli Samweli. ");
INSERT INTO nnq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Penia ngabajopa bape nngwana, Nnoongo ngabape Sauli mwana jwa Kishi jwa kabi ja Benjamini, kube nngwana jwabe ku yaka alubaini. ");
INSERT INTO nnq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kuboka pu kummoya Sauli, Nnoongo ngampambu Daudi kube nngwana jwabe. Ngachalakicha kulenga, ‘Nammweni Daudi mwana jwa Yese mundu ojwanampala, mundu ojwapakamu goa aganampala akamule.’ ");
INSERT INTO nnq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jwenio nga Yesu ju kibelei cha Daudi, Nnoongo ojwantei Nkomboi jwa bandu bu Kuisilaeli, andi apalagila. ");
INSERT INTO nnq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tango Yesu nu kutumbwaje maengo gakwe, Yohana ngatangacha ku bandu boa bu Kuisilaeli kutenda balape mabaja gabe na babatichigwe. ");
INSERT INTO nnq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na Yohana apabandakila kujomola liengo lyakwe, ngabalenge bandu, ‘Mangweto nhwachanga ne nabeneke? Ne ojumunnenda kuika joje. Nambu mpenekiange! Jwombe maika kuboka pango ne, nane kuotwaje kulugula ngoji yi ilatu yakwe.’ ");
INSERT INTO nnq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Malongo bango bu Kuisilaeli, lungolo lu Ulaimu, na mmandu mmoa manga Makayahudi mamunng'ongale Nnoongo, nhwalo gukomboi gono uletigwe kwito! ");
INSERT INTO nnq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Gambu bandu abatama Kuyelusalemu na akiilongoi babe bummanyije kutenda jwenio nga Nkomboi na bamanyije malobe ga akalondoli ba Nnoongo agachomigwa Machoba goa gu Kupomalela. Na yene bagatei malobe ga akalondoli ba Nnoongo galenganile kukunhwukumu Yesu awe. ");
INSERT INTO nnq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iganukube apatikinije ni lilemwa li ukomigwa, ngabannyopa Pilato anhwukumu ukomigwa. ");
INSERT INTO nnq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Angweto kuboka pu kamula kila kilebe chikilengigwe Mumajandiko Gachwapi kwajwenio, angweto ngubunhwuluya kuboka munchalaba ngaba mmeka mundundangele. ");
INSERT INTO nnq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nambu Nnoongo ngannyoya kuboka kwa abawile, ");
INSERT INTO nnq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","na kwamachoba ndu ngabapiti abatyanga nakwe kuboka ku Galilaya mpaka Kuyelusalemu. Ngoe nga akachaili bakwe ku bandu bu Kuisilaeli. ");
INSERT INTO nnq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na twe tubi pamba kunnetelanga Nhwalo Gwambone, kile chache echalagila Nnoongo kwa akaoko bito, ");
INSERT INTO nnq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ngoe Nnoongo alenganakie magambu ga ingota yabe kukunnyoya Yesu kuboke kwa abawile. Andi piandikigwe mu Zabuli ja pabele, ‘Mwe Mamanango, lele nonge bandu boa bamanye kutenda ne nawabinu.’ ");
INSERT INTO nnq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na chenje nga echalenga Nnoongo ngannyoya jwenio kuboke kwa abawile na annekitije akabola mundundangele. Nnoongo ngalenga, ‘Manampa upeele gwachwapi na gwa kweli gunalagana na Daudi.’ ");
INSERT INTO nnq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nu uyo ngalonge kabele, ‘Mannekaje mmanda jwinu jwachwapi abole mu ndundangele.’ ");
INSERT INTO nnq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Gambu Daudi akabegele agapala Nnoongo kukingobu chakwe, penia ngawe, ngachikigwa pamwe na akaoka mundu na mmele gwakwe ngubola mu ndundangele. ");
INSERT INTO nnq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nambu jwajo ojwayoigwe na Nnoongo kuboke kwa abawile aboliteje. ");
INSERT INTO nnq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tupala mangweto mmanyange, makalongo ba Kuisilaeli, kupete Yesu nhwalo gwa kulekekigwa mabaja utangachigwa kwinu, ");
INSERT INTO nnq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","na kila mundu ojwanhwamini Yesu kulekekigwa mabaja gakwe goa, kile chenie kabi kiwechakineje kundela ja Malagilo ga Musa. ");
INSERT INTO nnq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yene mma maha, gakampataje gaga agalengigwa na akalondoli ba Nnoongo gakampitije mangweto. ");
INSERT INTO nnq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘Mpenekiange, mangweto mammembula! Nhwomwange na nhwobange! Magambu chandenda lele nhwaminangaje kile chenie, ata ikabi mundu akannandulile mangweto!’ ” ");
INSERT INTO nnq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo na Banaba pababokanga munyumba ja kugongalela, bandu ngabakoka baike kabele lenge Lichoba li Kupomolela eliika na balanduli muno nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bandu apababoka pangongano, Paulo na Banaba ngabakengamigwa na Akayahudi ajingi na bandu banga Akayahudi aba amininge dini ja Kiyahudi. Achandundame benia ngabalonge nabo na kakweleka bajendeke kutama mu upeele gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Apalibandakila Lichoba li Kupomalela bange bandu kuboka kunnyini ngabaika kupenikia lilobe lya Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kingobu Akayahudi apabubona nkengeni gwa bandu, ngababe na bwiu, angweto ngabatauka agalenga Paulo nu kuntukana. ");
INSERT INTO nnq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nambu Paulo na Banaba ngabalonge pangajogopa, kulenga, “Lilobe lya Nnoongo likiba mpaka oti lilengigwe kwinu. Nambu kuboka pu kulikana maachangitije kutenda mpaligwa kube na bwomi gwa machoba goa pangapela, tupakunneka mangweto na kajendele bandu banga Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Magambu jenje nga amuli ejibutupi Angwana, ‘Na ntei mwe mme lumuli kwa bandu banga Akayahudi, yene dunia joa majikomboligwa.’ ” ");
INSERT INTO nnq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kingobu bandu banga Akayahudi apabajoa yene, ngaba alamwojo ngubulumbalila nhwalo gwa Angwana, na abapambuligwe kube na bwomi gwa machoba goa pangapela ngabaamine. ");
INSERT INTO nnq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lilobe lya Angwana ngilijoanika kilambo chenie. ");
INSERT INTO nnq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nambu Akayahudi ngabakolekea akikege bunuuwecho biilambo yenge abakiba banga Akayahudi bakagongale Nnoongo na akinalome abajoanika bikilambo chenie. Benia ngabatumbu kapotekanga Paulo na Banaba na kabenga kilambo chenie. ");
INSERT INTO nnq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nambu benia ngabapyata litukunda mumakongono gabe andi kabeka nhwilo kuboka penia ngabajenda Kuikonio. ");
INSERT INTO nnq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nambu akinapunji buku Antiokia ngaba alamwojo na kutwele Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ku Ikonio Paulo na Banaba ngabajenda ku nyumba ja kugongalela ja Nnoongo andi Kuantiokia ngabalongela panga jogopa mpaka Akayahudi ajingi na Akagiliki ngubunhwamini Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nambu Akayahudi bange abakananga kuamini ngabakolakea bandu banga Akayahudi babembu abanhwamini Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo na Banaba ngabatama kwenio kwa machoba majingi, ngabalongela panga jogopa nhwalo gwa Angwana, na Angwana ngabachalakicha nhwalo gwenio gubupiyanga kwa gwambone gwa Angwana, kwa kaotoya kamula ikobo na gukuomongwa. ");
INSERT INTO nnq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bandu bi kilambo chenie ngibikibagana, bange ngababe kingonu cha Akayahudi na bange kwa achandundame. ");
INSERT INTO nnq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Penia bandu bange banga Akayahudi na Akayahudi, pamwe na akilongoi babe, ngabaamua katenda ubaja achandundame na kupala kaputa mabwe. ");
INSERT INTO nnq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kingobu achandundame apabamanya kile chenie, ngabatilila ku Lusta na ku Debe ilambo ya Lukonio na ilambo ya papipi jakwe. ");
INSERT INTO nnq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kwenio ngabatangacha Nhwalo Gwambone. ");
INSERT INTO nnq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kukilambo cha Lusta kukiba mundu ojwakiba nangwaba kuboka pukubelekwa. ");
INSERT INTO nnq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ngatama penia kupenakia malobe galongela Paulo. Paulo ngannolekea kukunhwingakia, apammona mundujo abi ni imani yukuoto kulamiigwa, ");
INSERT INTO nnq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","na ngalenga kulilobe likolongwa, “Nnyeme gwema kwa makongono ginu!” Mundu jwenio ngaomba nu kutumbu kujenda. ");
INSERT INTO nnq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nkenga gwa bandu apaulola genia agatei Paulo, ngabatumbu kutenda manjega kukilonge chabe cha Kilukaonia, kulenga, “Milongo jituikalile kwito jibi andi putubi tubandu!” ");
INSERT INTO nnq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ngabampe Banaba liina lya Zeu na Paulo magambu akiba nnongei ngabampe liina lya Heme. ");
INSERT INTO nnq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nkung'i jwa nnongo ojwakemigwa Zeu ojwakiba nikitembe chakwe kutaali na kilambo ngaleta ng'ombe na maloba nnongi ja nniango, gambu jwenio na akajakwe bapala kupanga lilumbo kwa achandundame. ");
INSERT INTO nnq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nambu achandundame Paulo na Banaba apabajoa echibapala kamula, ngabajwepu ngobo yabe nu kubutukila panakati jankengeni gwa bandu, kongo bakapeta kuchobela, ");
INSERT INTO nnq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kunike mangweto ntendanga yenela? Twe uyo tabandu andi mangweto! Tubi pamba kupala kutangacha Nhwalo Gwambone, kupala mileke ilebe yenie yangapaligwa, mantendebuki Nnoongo ojwabi mmomi, Nnoongo ojwapangine mbengu na dunia baali na yoa eibi nkati jakwe. ");
INSERT INTO nnq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kalakala Nnoongo ngabaleka bandu batendi agabapala. ");
INSERT INTO nnq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nambu Nnoongo akotwikeje kunnayanga iingi kutenda abile, kuilebe yambone, kunkomelanga ula kuboka kumbengu na mauno kukingobu chakwe, ampeganga chakulya nukumpeganga kuala mwojo.” ");
INSERT INTO nnq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Achandundame baganwa kulongela genia baotalingeje kaibi bandu kape lilumbo. ");
INSERT INTO nnq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nambu bange Akayahudi ngabaika kuboka Antiokia nu ku Ikonio, na katenda bandu balondane na angweto, ngabamputa Paulo maganga nu kunhuta mpaka kutali ni kilambo bakita awile. ");
INSERT INTO nnq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nambu akinapunji pabakongana pamwe nu kuntindila, ngajimuka ngabuja kunnyini. Malabo jakwe, jwombe pamwe na Banaba ngabajabula kunnyini ku Debe. ");
INSERT INTO nnq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo na Banaba ngabatangacha Nhwalo Gwambone ku Debe na kapata akinapunji ajingi. Kuboka penia ngababuja ku Lusta na ku Ikonio mpaka ku Antiokia Kupisidia. ");
INSERT INTO nnq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ngabaotoya akinapunji bi ilambo yenie na kape mwojo batame gwicho mu imani. Ngabalenge, mpaka oti tupete mumalago ndu kupala tujingi mukingwana cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulo na Banaba ngabapambu akinanhota ba kila kikuta cha bandu abunhwamine Kilisto kalongeleya akaamine, kuboka penia, kukugongalela nu kupunga, kabeka mulenda gwa Angwana akaamina. ");
INSERT INTO nnq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kuboka pa kupete kilambo chi ku Pisidia, ngabaika ku Pamfilia. ");
INSERT INTO nnq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kuboka pukutangacha Nhwalo Gwambone ku Pega ngabajenda ku Atalia. ");
INSERT INTO nnq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kuboka kwenio ngabajingi mumeli kubuja ku Antiokia kwenio kalakala bakiba mupeele gwa Nnoongo na ngoe kupala bajomole liengo. ");
INSERT INTO nnq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Apabaika ku Antiokia ngababeka ngongano ya kikuta cha bandu abunhwamini Kilisto bapenia, ngabalandulila minhalo joa Nnoongo ejatei pamwe na angweto, na apabajogolile bandu banga Akayahudi nniyango baamini. ");
INSERT INTO nnq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na ngabatama kwa machoba ndu kwenio pamwe na akinapunji. ");
INSERT INTO nnq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bandu bange ngabaika kuboke ku Yudea ku Antiokia ngabatumbu kabolanga abaamine balenga, kulenga, “Mangweto nukuinigwaje nkomboligwaje andi pagapaligwa Malagilo ga Musa.” ");
INSERT INTO nnq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kile chenie ngikibeka ndu ngabatenda Paulo na Banaba balonge nabo, ngiamuligwa Paulo na Banaba pamwe na abaamine akachoko aba nhwamini Yesu buku Antiokia, bajende Kuyelusalemu kalenge achandundame na akinanhota kile chenie. ");
INSERT INTO nnq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Penia kikuta cha bandu abunhwamini Kilisto ngabalondana na angweto apabapetela ku Foinike na Samalia ngabalandulila bandu banga Akayahudi pabantendebuki Nnoongo, nhwalo gwenio ngugwaalali muno abaamine boa. ");
INSERT INTO nnq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kingobu apabaikanga Kuyelusalemu, ngabapokeligwa na kikuta cha bandu abunhwamini Kilisto na achandundame na akinanhota, nangweto ngabalengela nhwalo gwoa Nnoongo ogwatenda pamwe nangweto. ");
INSERT INTO nnq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nambu aba nhwamini Yesu bange abakiba bikikuta cha Mafalisayo ngabajema, kulenga, “Mpaka oti bandu banga Akayahudi bainigwe na kabola bagakengame Malagilo ga Musa.” ");
INSERT INTO nnq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Penia achandundame na akinanhota ngabakongana pamwe nu kuwacha muno nhwalo gwenio. ");
INSERT INTO nnq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kuboka pu konyana muno, Petulo ngajema, ngalenga, “Makalongo bango, mangweto mmanyi kutenda kalakala Nnoongo apala kunjagu nenga kati jinu ndangache Nhwalo Gwambone ku bandu banga Akayahudi, bajoe nukuamini. ");
INSERT INTO nnq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Nnoongo, ojwamanyi mwojo gwa kila mundu, ngachalakicha kutenda bajekatile na kape angweto Uhuke jwa Chwapi andi patupi twenga. ");
INSERT INTO nnq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Abagwije kati jito na angweto, ngajijeguya myojo jabe kuimani. ");
INSERT INTO nnq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Lele, kunike kuntega Nnoongo katweka miigo akinapunji ba Yesu ata akahokabito baotwije kupoto miigo jenie, wala twenga tuotwije kupotola? ");
INSERT INTO nnq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yeneje! Twe tuamine nu komboligwa kwa upeele gwa Angwana ana Yesu, andi apabakomboligwe angweto.” ");
INSERT INTO nnq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kikuta choa ngikitama nuu, kupenakia Banaba na Paulo bakalandulila ikobo na yukuomongwa eikamuligwa na Nnoongo kupete maboko gabe kati ja bandu banga Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Apabajomola kulongela, Yakobo ngalenga, “Makalongo bango, umbenakiange! ");
INSERT INTO nnq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni alandulila agalaya Nnoongo kubandu banga akayahudi kapambu bange kati jabe babe bandu bakwe. ");
INSERT INTO nnq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nhwa gongo ubi tela na malobe ga akalondoli ba Nnoongo. Andi apagalenga Majandiko Gachwapi, ");
INSERT INTO nnq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kuboka paganga mambuja kabena, balenga Angwana, nu kuchenga kabena kiteba cha Daudi chikibomwike. Mandendekea kabele maami gakwe nu kugalimbia. ");
INSERT INTO nnq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Penia bandu boa abaigile mabaika kwango, bandu boa banga Akayahudi bapalapala Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nga apabalenga Angwana, ababikibeka kile chenje kimanyikane.’” ");
INSERT INTO nnq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo ngajendeke kulenga, “Ne mbala yene,” “Takachumbuyaje bandu banga Akayahudi abammuji Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nambu tapelekelange balua kalengelanga makalyegangaje yakulya eipangigwe lilumbo ku inyago, bileke ngongola, bakalyegangaje kinyama chochoa echikipopotoligwe na bakanywegangaje myai. ");
INSERT INTO nnq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gambu Malagilo ga Musa ngagatangachigwa tangu lolo mukila kilambo nu kuchomigwa mumajumba goa gukugongale Nnoongo kila machoba Lichoba li Kupomolela.” ");
INSERT INTO nnq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Achandundame na akinanhota, pamwe na kikuta cha bandu abunhwamini Kilisto boa, ngabaamuanga kapambula bandu kati jabe na kakinga ku Antiokia pamwe na Paulo na Banaba. Angweto ngabampambula bandu abena Yuda ojwakemigwa Basaba na Sila benia boa bakiba akilongoi bi kikuta cha bandu abunhwamini Kilisto, ");
INSERT INTO nnq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","na ngabapeganga balua jenie, “Twenga achandundame na akinanhota, takalongo binu, chalamu chinu mangweto makalongo manga Akayahudi mammelwike nukutama ku Antiokia na ku Silia na ku Kilikia. ");
INSERT INTO nnq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tujoine kutenda bandu bange kuboka kachito ngabantindagana kwa malobe gabe, ngibibeka myojo jinu mumbwele. Nambu twe tatumitije genia. ");
INSERT INTO nnq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nayenie, tuamwi pamwe kampambula bandu achoko na kakinga kwinu pamwe na akaganja bito Banaba na Paulo, ");
INSERT INTO nnq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ababekita bwomi gwabe mungondo magambu gwa liina lya Angwana ana Yesu Kilisto abapambuligwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tankinga Yuda na Sila kwinu, benia angweto mabannengelanga ganga agatugaandike. ");
INSERT INTO nnq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Uhuke jwa Chwapi atulaite kutenda takantwekangaje nhwigo guna kutopa muno kupeta minhalo jenje jambone, ");
INSERT INTO nnq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","makalyegangaje yakulya eipangigwe lilumbo ku inyago, makanywegangaje myai, makalyegangaje nyama ja kinyama chochoa echikipopotoligwe, nnekange ngongola. Mantendanga chwapi anda nnyepangite kamu minhalo jenie. Makajimukage.” ");
INSERT INTO nnq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kuboka pa katabuka, bandu benia ngabaleka ngabajenda ku Antiokia kwenio kukikongine kikuta choa cha bandu abaamine ngabape angweto balua jenie. ");
INSERT INTO nnq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bandu pabachoma balua jenie, malobe gakwe ngagape mojo, ngabaala mojo muno. ");
INSERT INTO nnq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, angweto bakibanga akalondoli ba Nnoongo, ngabalongela na angweto bea bakapa mojo na makakala. ");
INSERT INTO nnq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kuboka pa kutama kukingobu kwenio, bandu abaamine buku Antiokia ngabatabuka kwa tengela, penia ngabaleka nu kubuja kwa ababakingite. ");
INSERT INTO nnq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nambu Sila ngaamu kuigala kwenio. ");
INSERT INTO nnq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo na Banaba ngabaigala ku Antiokia kukingobu, angweto pamwe na bandu ajingi ngababola nu kutangacha lilobe lya Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kuboka pa machoba machoko, Paulo ngannengela Banaba, “Tubuje takatyangile akalongo mukila kilambo okututangiche lilobe lya Angwana, takalole apabajendekea.” ");
INSERT INTO nnq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba ngapala kuntola na Yohana ojwakemigwa Maluko, ");
INSERT INTO nnq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","nambu Paulo apaije kulongwana na Maluko, gambu pukutumbula jwenio ngabaleka ku Pamfilia nukana kujangatana muliengo lyabe. ");
INSERT INTO nnq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Penia, ngukupitila mitau muno kati jabe, ngabalekana. Banaba ngantola Maluko, ngabaombe mungalaba kujenda ku Kupulo. ");
INSERT INTO nnq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Na Paulo ngampambula Sila, bandu abunhwamini Yesu ba paali penia ngaba mmeka pulenda gwa upeele gwa Angwana, ngajabula. ");
INSERT INTO nnq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mumwanja gwakwe ngapetela ku Silia nu ku Kilikia, kukipe makakala kikuta cha bandu abunhwamini Kilisto. ");
INSERT INTO nnq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo ngaika ku Debe na ku Lusta, okwatama napunji jumwe ojwakemigwa Timoteo. Umamundu uyo akiba aamine, akiba Nhyahudi, nambu awamundu bakiba Agiliki. ");
INSERT INTO nnq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoteo ngabanchalakicha kwambone bandu boa abaamine buku Lusta na buku Ikonio. ");
INSERT INTO nnq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo ngampala Timoteo alongwane nakwe, ku yenie nganhwina. Atenda nyene magambu Akayahudi boa abatama penia bamanyi kube awamundu Timoteo bakiba Agiliki. ");
INSERT INTO nnq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Apabakiba bakapeta muilambo yene, ngabalengela bandu abaamine amuli ejiamuligwe na achandundame na akinanhota ba Kuyelusalemu, na ngabalengela angweto bijijali amuli jenie. ");
INSERT INTO nnq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Penia, kikuta cha bandu abunhwamini Kilisto ngikijendeke komala kuimani nu kola kukujonjake bandu kila machoba. ");
INSERT INTO nnq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Angweto ngabatyanga kupete ku kilambo cha Fulugia na kilambo cha Galatia magambu Uhuke jwa Chwapi ngabakanakia batangache nhwalo gwenio kuilambo ya Asia. ");
INSERT INTO nnq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Apabaikanga kumipaka ja Bisinia, ngabajiga kujingila ku ilambo ya ku Betania, nambu Uhuke jwa Yesu ngabakanakia benia. ");
INSERT INTO nnq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kuyenie, ngabapetela ku Bisinia, ngabajenda mpaka ku Toloa. ");
INSERT INTO nnq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kilo jenie, Paulo ngalola malolo agammona mundu jumwe jwa Makedonia ajemite papa nu kunnyopa, “Nnyombeke, nhwike Makedonia mutujangate.” ");
INSERT INTO nnq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kingobutu Paulo pukulola malolo genia, ngutupanganika chokwe kujenda Makedonia, gambu tumanyi kutenda Nnoongo atukemite tatangachile bandu Nhwalo Gwambone. ");
INSERT INTO nnq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kuboke ku Toloa, ngutujenda kwa ngalaba mpaka ku Samotilake, na malabo jakwe ngutuika ku Neapoli. ");
INSERT INTO nnq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuboke kwenio, ngutujenda mpaka kukilambo cha ku Filipi, pannyini pikilambo kikolongwa cha mukilambo cha Makedonia, apapakiba na kingwana cha Loma. Ngututama pikilambo chenie kwa machoba majingi. ");
INSERT INTO nnq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lichoba lya Kupomolela ngutupita panja ja kilambo, ngutujenda pambwega ja lukemba tupemelela penia paali pa Akayahudi pabakongana kunng'ongalela Nnoongo. Ngututama, ngutulongela na akikege abakonganinge paali penia. ");
INSERT INTO nnq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kati ja abakiba bakatupenakia akiba munkege jumwe ojwanng'ongale Nnoongo ojwakemigwa Lidia kuboke ku Tiatila, ojwakiba nhucha ngobo ya bei ngolongwa. Angwana ngubujogola mojo gwakwe ngagapokela malobe ga Paulo agakiba akalongela. ");
INSERT INTO nnq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kuboka pa bandu ba nyumba jakwe kubatichigwa, ngatukoka akalenga, “Anda kweli nnoilinge kube nenga naamini Angwana, nhwikange ukaja ntamange.” Ngatukwajalila tujende. ");
INSERT INTO nnq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lichoba limwe putujenda paali pukugongalela, ngutukongana na mpakachi kamwale ojwakiba na nchepela ogunhwotwiya kulondola agaika. Oju bachumila uloi ndu akangwana mundu kukulondola kwakwe. ");
INSERT INTO nnq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ngankengama Paulo na twenga, akapeta kuchobela nu kulenga, “Angwetwa nga akapakachi ba Nnoongo Nkolongwa Ojwabi kunani! Bantangachilanga ndela ju komboka!” ");
INSERT INTO nnq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ngatenda yene kwa machoba majingi, mpaka Paulo ngachimwa yene ngatendabuka ngaulengela nchepela gwenio, “Ku liina lya Yesu Kilisto nunhwamulicha mampite mundu jonjo!” Nchepela ngugummoka kingobucho. ");
INSERT INTO nnq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Akangwana mundu pabamanya kuhyobale kwabe kupata uloi kupeile, ngabampuki Paulo na Sila ngabautanga mpaka kukitamo chakananhota kwa akakolongwa. ");
INSERT INTO nnq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ngabaleta angweto mpaka ku akilongoi ba Loma nu kulenga, “Bandu bamba Akayahudi na baletanga kijonga pikilambo chito. ");
INSERT INTO nnq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Angweto babola ikobo yangapaligwa muma lagilo gito tubandu ba Loma na tupaligweje kuijeketela ikobo yene nu kamula.” ");
INSERT INTO nnq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nkenga gwa bandu ngabalondana pamwe ngugu nnyingalila Paulo na Sila. Penia Akilongoi ba Loma ngabaulanga ngobo Paulo na Sila na ngaamulicha baputigwe iboko. ");
INSERT INTO nnq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kuboka pa kuputigwa muno, ngabajingia mukipungo, na nnenda jukipungo ngaamulichigwa kabeke ulenda nkolongwa muno. ");
INSERT INTO nnq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nnenda jwenio papokela amuli jenie ngababekanga chumbi cha nkati na katabanga makongono panakati ju lueke. ");
INSERT INTO nnq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Panakati juwiku Paulo na Sila bakiba bakagongalela nukujemba miambo ju kunnumbali Nnoongo na akapungwa bange bakibanga bakajoa. ");
INSERT INTO nnq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kingobutu ngukupiti kulendema kukolongwa kulundope, ngilitikatika nyumba ja kipungo. Upo milyango ngijijogoka na mitondolo ngijikuluguka kuboka mwa akapungwa boa. ");
INSERT INTO nnq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nnenda jwa kipungo pajimukaga, nukujibona milyango jijogwike, apemelela kutenda akapungwa batilangite, nayene ngacholomo upanga gwakwe apalakukikoma mwene. ");
INSERT INTO nnq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nambu Paulo ngakwaja kulilobe likolongwa, “Mikikikomaje mmene! Twe tuboa tubi pamba!” ");
INSERT INTO nnq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nnenda jwa kipungo ngankema mundu alete lumuli, nnenda jwenio ngabutiki unyumba, nu kugwe pamakongono ga Paulo na Sila kongo akalendemela kukujogopa. ");
INSERT INTO nnq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Penia ngabalongaleya panja nukonya, “Ananhota, ndendani mbate komboka?” ");
INSERT INTO nnq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Angweto ngabajanga, “Maamini Angwana ana Yesu na mwe mankomboka pamwe na nyumba jinu joa.” ");
INSERT INTO nnq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Penia angweto ngabatangachi lilobe lya Angwana kumundu jwenio pamwe na bandu boa buunyumba jabe. ");
INSERT INTO nnq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kilo ujo nnenda jwa kipungo ngajenda kajeleya mabanga gabe na benia boa buunyumba jabe ngababatichigwa kingobucho. ");
INSERT INTO nnq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kubokapenia ngabatola Paulo na Sila kachakwe ngabape chakulya chukulye. Beniabo na bandu bunyuumba jabe ngaba alamwojo magambu benia ngoe bunhwamini Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Piika kindabi akakolongwa ba Loma ngabakinga akalenda akolongwa ngabaamulicha, “Maleke bajabule.” ");
INSERT INTO nnq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yene nnenda jwa kipungo ngannenge Paulo, “Akakolongwa ba Loma bapangite amuli kwinu nuku Sila tunnekekeye. Ngoe mmokange nnyabule kwa tengela.” ");
INSERT INTO nnq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nambu Paulo ngabalenge nkolongwa jwa akalenda, “Twe tubonikinije nililemwa lya lyoa, ngubutuputanga nnongi ja bandu na twe tubandu ba Loma! Na benia ngubu tubeka mukipungo. Na ngoe bapalanga kutulekekeya twenga kinunu. Kubeje! Maleke akakolongwa ba Loma baikange kutupia twe.” ");
INSERT INTO nnq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Akakolongwa ba akalenda ngabajenda kulanduli genia kwa akakolongwa ba Loma, na kingobu apabajoa kutenda Paulo na Sila bakibanga bandu ba Loma angweto ngaba jogopa muno. ");
INSERT INTO nnq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yene akolongwa ba Loma ngabajenda kapembelanga, kubokapenia angweto ngabalenge bajabulange Paulo na Sila na kalongolea baboke kilambo chenie. ");
INSERT INTO nnq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo na Sila ngaba pita mukipungo ngabajabu kunyumba ja Lidia. Penia angweto ngaba kongana na bandu abaamini, nukulonge malobe gakape mojo angweto na ngababoka. ");
INSERT INTO nnq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo na Sila ngabajenda ku Kusesalonike kupetela Amfipoli na Apolonia, ngabaika kwenio kwajenda kunyumba ja kugongalela ja Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo ngabe pamwe na angweto anda apibile lukobo lwakwe ngajenda ku nyumba ja kugongalela ja Akayahudi. Kwenio ngalongela nabo bandu kwa Machoba matatu gu Kupomolela, akatumia Majandiko Gachwapi ");
INSERT INTO nnq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","nu kulandulula Majandiko Gachwapi nu kulaya kube kwa magambu gabe Kilisto Nkomboi ojwapambuligwe na Nnoongo apaligwa kupotekigwa na kuyoigwa kuboka kwa abawile. Paulo ngalenga, “Yesu jonjo jwanantangacha kwinu nga Kilisto Nkomboi ojwapambuligwe na Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bandu bange ngabaamini malobe ga Paulo na Sila. Bange bandu abakiba banga Akayahudi, akikege bunuwecho na kikuta kikolongwa cha Akagiliki abanng'ongale Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nambu Akayahudi bange ngababe na bwiu ngabakoka bandu bina ng'omo nu kubeka kikuta. Na kutenda kijonga kunnyini kwoa na ngabajijingilila nyumba ja Yosani, bahyobalela kapatanga mwenio Paulo na Sila kupala bapeleke kubandu. ");
INSERT INTO nnq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nambu bapatangitije, ngubunhwuta Yosani pamwe na abaamine bange mpaka kwa akinanhota bi kilambo nu kuchobela, “Bandu bamba batenda kijonga padunia! Ngoe babi pannyini pano, ");
INSERT INTO nnq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na Yosani bapokilinge kachakwe. Boa abaalabia amuli ja angwana bu Loma, eti balenga kita abi jonge nngwana, ojwakemigwa Yesu.” ");
INSERT INTO nnq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa malobe genia ngababe na mbwele akananhota ba kilambo nankengeni gwa bandu. ");
INSERT INTO nnq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ngabantocha Yosani na akajakwe bapange uloi, penia ngabaleka bajabulange. ");
INSERT INTO nnq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kingobutu apiika kilo, abunhwamini Yesu ngabannenge Paulo na Sila bajabulange kukilambo cha Belea. Pabaika kwenio, ngabajabulanga kunyumba ja kunng'ongalela ja Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bandu bakwenio bakiba bukujoanga muno kupeta bandu bu Kusesalonike. Ngabapenakia malobe kwa chuna muno, ngabaingikia Majandiko Gachwapi kila machoba, kupala bamanye anda gaga agalenga Paulo na Sila gakiba kweli. ");
INSERT INTO nnq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Akajingi kati jabe ngabaamini, na akikege Bikigiliki bina uwecho na akinalome ba Kiyunani uyo ngabaamini. ");
INSERT INTO nnq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nambu Akayahudi ba ku Kusesalonike apabajoa kube Paulo akiba akatangacha malobe ga Nnoongo kwenio ku Belea, ngabajenda kwenio na ngabatumbwa kutenda kijonga na kikolakeya ikuta ya bandu. ");
INSERT INTO nnq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Abunhwamine Yesu ngabanhwindikila chokwe ajabule kumbwani nambu Sila na Timoteo ngabaigala ku Belea. ");
INSERT INTO nnq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bandu ababunhwindikila Paulo ngabajabula pamwe nakwe mpaka ku Atene. Kubokapenia ngababuja pamwe na malagilo kuboka kwa Paulo kutenda Sila na Timoteo bankengame chokwe andaiwechikine. ");
INSERT INTO nnq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kingobu Paulo apakiba akannenda Sila na Timoteo ku Atene, ngachimwa umwojo apalola kilambo chenie pikitweli milongo ji inyago. ");
INSERT INTO nnq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Penia ngalonge nabo munyumba ja kugongalela na Akayahudi na bandu banga Akayahudi abanng'ongalela Nnoongo, nu uyo pukongolou pamwe na bandu boa abapitila penia. ");
INSERT INTO nnq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bange akaboli ba Epikulo na Stoiki uyo ngabataukana nakwe. Bange ngabakonya, “Apakulongela nike ojo mpuchi?” Bange ngabajanga, “Abonekana andi alonge nhwalo gwa milongo ja kigeni.” Balenga genia magambu Paulo akiba akatangacha nhwalo gwa Yesu nu kuyoka. ");
INSERT INTO nnq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yenie ngabantola Paulo, ngabampeleka kitamo chakananhota echikikemigwa Aleopago, ngabalenga, “Tupala kumanya nhwalo gongo nhyono ogumakiba makalongela. ");
INSERT INTO nnq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Yengi ilebe eitijoine kwa machikilo gito ibonekana kutenda ilekaleka kwito. Tupala kumanya nhwalo gwenio ubi na mana gani.” ");
INSERT INTO nnq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bandu ba ku Atene na akageni abakiba bakatama kwenio bapalanga mangobu goa kube bakalandulila nu kupenikia minhalo miyono. ");
INSERT INTO nnq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo ngajema nnongi ja libalacha lya Aleopago, ngalenga, “Bandu ba Atene nammonanga kube mabandu ba dini muno. ");
INSERT INTO nnq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Gambu apanakiba nakatyanga mukilambo chinu nu kupabona paali panng'ongalela, ngunubona utala uandikigwe, ‘Kwa Nnoongo jwangamanyika.’ Jwenio nga jumanng'ongalela, iganukube mummanyije, jwenio nga ojunantangachilanga mangweto ngoe. ");
INSERT INTO nnq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nnoongo, ojwapanganie dunia na yoa eibile, nga Angwana ba mbengu na ilambo, jwenio kutamaje mu nyumba ejichengigwe kamaboko ga bandu. ");
INSERT INTO nnq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kabe kubegeleligwaje kwa maboko ga bandu andi ojwapala kilebe chachoa, kwa magambu jwenio mwene nga ojwabape bandu bwomi, ojubaotoya kupomola na kapeganga bandu ilebe yoa. ");
INSERT INTO nnq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kuboke mu mundu jumwe Nnoongo ngapangana bandu boa abatama padunia joa ngapangana kutumbu kalakala, balame mpaka lii na koo. ");
INSERT INTO nnq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Atenda nyenie, kupala bandu boa bampalepale, pangaje mabammona ati ikabi kukupapaya. Nambu Nnoongo abikutaalije na twe. ");
INSERT INTO nnq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Andi apalenga mundu jumwe, ‘Nkati jakwe twe tutama na tubi kujenda na tubi na bwomi gwito.’ Ibi andi nhwambo gwa mundu jumwe ulenga, ‘Na twe uyo talungolo lwabe.’ ");
INSERT INTO nnq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Bai, twenga ingota ya Nnoongo, ipaligwije kunhwachila Nnoongo kube andi jaabu andaje uloi andaje ata libwe elitengenechigwe na kulembelekea na mundu. ");
INSERT INTO nnq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nnoongo ngakibeka anda abikulolaje kingobu chache bandu apabakiba akajinga. Nambu ngoe, amulicha bandu boa kila paali balapange mabaja gabe. ");
INSERT INTO nnq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwa mana abekite lichoba lyene aihukumula bandu boa andi pipaligwa kwa kupete mundu jumwe ojwapambuligwe na Nnoongo. Nnoongo balenganakiye boa nhwalo gongo kwa kila mundu kukunnyoya mundu jwenio kuboka kwa abawile!” ");
INSERT INTO nnq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kingobu apabannyoa Paulo akalenga nhwalo gwa kuyoka kwa abawile, bandu bange ngabaekanga, nambu bange ngabalenga, “Tupala kunnyoa kabele ku nhwalo gongo!” ");
INSERT INTO nnq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Penia, Paulo ngaboka pangongano. ");
INSERT INTO nnq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nambu bange bandu ngibikilonda na jwenio, nukuamini. Kati jabe bakibanga Dionisi, jumwe kati ja ojwakiba pikitamo cha kanahota echikikemigwa Aleopago, uyo akiba munkege akemigwa Damali na bange bandu. ");
INSERT INTO nnq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kuboka pa genia, Paulo ngaboka ku Atene, ngajenda ku Kolinto. ");
INSERT INTO nnq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kwenio ku Kolito, ngankolela Myahudi jumwe ojwakemigwa Akila, ojwabelwike ku Ponto. Akila pamwe na nhwanamundu ojwakemigwa Pilisika, bakiba babujangite kuboka ku Italia machoba ugo kwa magambu Kaisali Kilaudio akiba amuliche Akayahudi boa babokange ku Loma. Paulo ngajenda kabona, ");
INSERT INTO nnq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na ngatama nabo nukamula maengo pamwe, magambu jwenio akiba pundi mahema andi angweto. ");
INSERT INTO nnq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ngalonge na Akayahudi na Akagiliki munyumba ja kugongalela kila Lichoba li Kupomolela ajiga kauta bunhwamini Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoteo pabaika Makedonia, mangobu goa, Paulo ngatangacha nhwalo, akachalakicha kwa Akayahudi kutenda Yesu nga Kilisto Nkomboi ojwapambuligwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Angweto pabankanga nu kuntukana, ngakung'unda litukunda mungobo yakwe na kalenge, “Myai jinu jiba mumitwe jinu, ne mbi chwapi! Kutumbu ngoe mbakujenda kwa bandu banga Akayahudi.” ");
INSERT INTO nnq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yene ngabalekanga angweto ngajenda kutama ku mundu jumwe jwanga Nhyahudi akemigwa Tito Yusto, ojwanng'ongalela Nnoongo, nyumba jakwe jikiba papipi ja nyumba ja kugongalela. ");
INSERT INTO nnq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo akiba kilongoi jwa nyumba ja kugongalela, ngaba amini Angwana pamwe na nyumba jakwe joa. Na bandu bange ajingi ku Kolinto abubujoine nhwalo gwenio ngabaamini na ngaba batichigwa. ");
INSERT INTO nnq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lichoba limwe kilo Angwana ngabannenge Paulo mumalolo, “Makajogopaje, nnongelatu, ");
INSERT INTO nnq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","magambu ne mbi pamwe na mwenga. Babije abaotwi kuntenda kilebe, bandu ajingi bikilambo chenje bango.” ");
INSERT INTO nnq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kuyene Paulo ngatama kwenio kwa chaka chimwe na myei sita, akabola bandu lilobe lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kingobu Galio apakiba nkolongwa ju Loma jwa Akaya, Akayahudi ngaba kongana pamwe, ngabampukila Paulo, nu kumpeleka kukitamo chakananhota. ");
INSERT INTO nnq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ngabalenga, “Tuntakiana mundu jonjo magambu gwa kakweleya bandu banng'ongale Nnoongo kundela jangapaligwa muma lagilo gito!” ");
INSERT INTO nnq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo kuwakalikaje kulongela Galio ngabalenge Akayahudi, “Mpenikiange mangweto Makayahudi! Ikabi kweli nhwalo gongo ubi na malemwa andaje ubaja kabi nampenikiinge. ");
INSERT INTO nnq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nambu kutumbu pukutaukana nhwalo gwa malobe na maina na malagilo ginu, nhwamuanga mmenimangweto. Mbeje na amuli ja ilebe yenie!” ");
INSERT INTO nnq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Jwombe ngababenge panja ja kitamo chakananhota. ");
INSERT INTO nnq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Angweto boa ngabampukila Sositenesi, kilongoi jwa nyumba ja kugongalela, nu kumputa nnongi ja kitamo chakananhota. Nambu Galio ajalitije kile chenie na pachokochokuje. ");
INSERT INTO nnq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo ngatama na bandu abaamininge ku Kolinto kwa machoba majingi, na ngabaleka ngaombe mungalaba pamwe Pilisika na Akula kujenda ku Silia. Kwenio ku Kenkelea tangu nukutumbuje mwanja ngacheku mutwe gwakwe magambu ga nalili jabekite. ");
INSERT INTO nnq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Angweto ngabaika ku Efeso, Paulo ngabaleka Pilisika na Akila. Ngajenda ku nyumba ja kugongalela ngabeka ngalonge pamwe na Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bandu ngabannyopa ajendeke kutama, nambu ajeketije kutama. ");
INSERT INTO nnq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nambu apakiba akajabula ngalenga, “Andapai Nnoongo maniika kabe kwinu.” Ngaboka ku Efeso mu ngalaba. ");
INSERT INTO nnq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paika ku Kaisalia, ngajenda Kuyelusalemu ngajenda kukipata abali kikuta cha bandu abunhwamini Kilisto, kubokapenia ngajenda ku Antiokia. ");
INSERT INTO nnq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kuboka pukutama machoba majingi ku Antiokia, ngaboka nu kujenda kupete ku ilambo ya Galatia na ku Fulugia, kape makakala akinapunji boa. ");
INSERT INTO nnq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kingobu chenie Nhyahudi jumwe ojwakemigwa Apolo, ojwabelekwa Kualekizanda, ngaika ku Efeso. Akiba nnongei muno na akiba mundu jwagamanyi muno Majandiko Gachwapi. ");
INSERT INTO nnq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Akiba aboligwe ndela jenie ja Angwana, magambu mwojo gwakwe ukiba gwakajaka ngatumbu kukutangacha nu kubola kweli ja Yesu. Iganukube, akabatichigwa ubaticho gwa Yohana tu. ");
INSERT INTO nnq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ngatumbu kulongela panga jogopa munyumba ja kugongalela. Kingobu Pilisika na Akila apabannyoa jwenio ngabantola kujabu nakwe kachabe ngaba mmola majingi ga ndela ja kweli ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Penia Apolo ngaamua kujenda ku Akaya, yene abaamine ba ku Efeso ngabannyangata kaandikilanga akinapunji buku Akaya, bampokele. Kingobu apaika, jwenio ngabajangata muno kwa bandu abaamini ba kwenio abapatite upeele gwa Nnoongo chukube abaamine. ");
INSERT INTO nnq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolo ngabapeta Akayahudi pukongolou akachalakicha Mumajandiko ga Chwapi kutenda Yesu nga Kilisto Nkomboi ojwapambuligwe na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo apakiba ku Kolinto, Paulo ngajenda kupete kujomo ngaika ku Efeso. Kwenio ngabakolela akinapunji bange ");
INSERT INTO nnq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","na ngabakonya angweto, “Mangwetumwe mpokilinge Uhuke jwa Chwapi kuboka pukube makaumini?” Ngabajanga, “Tanajoaje kutenda abi Uhuke jwa Chwapi.” ");
INSERT INTO nnq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo ngabakonya, “Mmatichigwe ku ubaticho gani?” Angweto ngabajanga, “Ubaticho gwa Yohana.” ");
INSERT INTO nnq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo ngabalengela, “Ubaticho gwa Yohana ulaya kutenda bandu balapite malemwa gabe, na Yohana balengala bandu bunhwamini ojwapa kuika yaani, Yesu.” ");
INSERT INTO nnq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Apabajoa genie, ngababatichigwa na ubaticho ku liina lya Angwana ana Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo ngabeka maboko gakwe panani ja angweto, nu Uhuke jwa Chwapi ngabaulukila, ngabatumbu kulonge kilonge kiyono na uyo kutangacha nhwalo gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ngababe jumula bandu komi na abena. ");
INSERT INTO nnq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo ngajenda ku nyumba ja kugongalela na kwa myei mitatu akiba akalongela na bandu panga jogopa, ngabe akataukana na angweto na ngatumbu kalanduli kingwana cha Nnoongo kupala baamini. ");
INSERT INTO nnq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nambu bange bakiba na mitau ngabakana kuamini, na nnongi ja kikuta choa ngabatumbu kulongela ilebe ibaja nhwalo gwa ndela ja Angwana. Kuyene Paulo ngabaleka angweto nu kube na akinapunji, kila machoba ngalonge nabo munyumba ji kubola ja mundu ojwakemigwa Tulano. ");
INSERT INTO nnq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Minhalo jenie ngijijendekea kwa yaka ibena, yene bandu boa abatama kuilambo ya Asia, boa pamwe na Akayahudi na Akagiliki, ngibilijoa lilobe lya Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nnoongo ngakamula ikobo ikolongwa muno kupete Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bandu bakiba bakatola mikunge na ngobo yenge ya maengo eikiba itumiigwe na Paulo, ngibipeleka kwa akatamwe, nangweto ngabalamiigwa itamwe yabe, ni michepela mibaja ngijaboka abakiba ni michepela jenie. ");
INSERT INTO nnq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Akayahudi bange abajenda bakatindila kongo na kongo, ngabajiga kujibenga michepela kutumia liina lya Angwana ana Yesu. Ngibijilenge michepela mibaja, “Nunhwamulicha kwa liina lya Yesu, ojwantangacha Paulo.” ");
INSERT INTO nnq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ingota saba, eikiba ingota ya Nhyahudi nkung'i nkolongwa ojwakemigwa Sikewa, abateilinge genia. ");
INSERT INTO nnq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nambu nchepela mmaja ngugwakonya, “Numanyi Yesu, na numanyi Paulo, nambu mangwetomwe makinabene?” ");
INSERT INTO nnq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Penia mundu ojwakiba na nchepela mmaja ngabagolekela angweto ngabapeta kwa makakala na kaputa. Ningota ya Sekewa ngipita panja mbelo, kongo babi makengele na mabanga. ");
INSERT INTO nnq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Akayahudi boa na bandu banga Akagiliki abatamanga ku Efeso apabajoa genia, boa ngababe na mbwele, na liina lya Angwana ana Yesu ngililumbigwa muno. ");
INSERT INTO nnq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Abaamine ajingi ngabaika, ngabalenga pukongolou ilebe yoa eibakiba bakamulinge. ");
INSERT INTO nnq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na bandu ajingi abakiba akahabe ngabaleta itabu yabe ngabapamba mwoto nnongi ja bandu boa. Ngababalanga bei ja itabu yenie kube iotwi kuika ipandi yuloi elufu amsini. ");
INSERT INTO nnq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ku ndela jenie lilobe lya Angwana ngilijendeke kwela kila paali nu kube na makakala muno. ");
INSERT INTO nnq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kuboka pa ilebe yenie kupitila, Paulo ngaamu umwojo kujenda Kuyelusalemu kupete Kamakedonia na Kuakaya. Ngalenga, “Anda nyabwile kwenio mpaka nyende kabona ku Loma.” ");
INSERT INTO nnq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kuyene ngabakinga akabena Timoteo na Elasto, kati ja akajangati bakwe, ka Makedonia, kingobu jwombe abi tango ku ilambo ya Asia. ");
INSERT INTO nnq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kingobu chenie nga apakiba na kijonga muno ku Efeso magambu gwa ndela ja Angwana. ");
INSERT INTO nnq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kukiba na pundi jwa uloi jumwe ojwakemigwa Demetilio, ojwakiba na liengo lya kubacha inyago ya madini ga ela agabachigwe ibe inyago ya nyumba ja nnongo munkege ojwakemigwa Atemi. Liengo lyakwe lyenie ngilyape mapundi bakwe nyonjakea ngolongwa. ");
INSERT INTO nnq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetio ngabakongolanga benia akakamwa maengo pamwe na bange abakiba na liengo anda lyenie, ngabalengela, “Akakola kilambo, mmanyange kube nyonjekea jito jiboke na kutenda biachala jenje. ");
INSERT INTO nnq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ngoe, nhwotolinge kujoa na kulola mmenimangweto ilebe eyakamula Paulo, pambatuje pa Efeso, nambu ku Asia kwoa. Jwombe ngabalengela bagalambuya bandu ngabajeketela kube milongo jaje ejitengenechigwe na bandu milonguje ata kachoko. ");
INSERT INTO nnq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Yene liengo lito libakubembuligwa nu kube na liina libaja. Yenetuje, nambu nhwalo gwenio uotwi kujibeka nyumba ja nnongo Atemi kube kilebe changa mbone. Penia kulumbaligwa kwa jwenio na kugongaligwa kwajwenio ku bandu ba Asia na dunia joa kubakupela!” ");
INSERT INTO nnq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nkenga gwa bandu pujoa malobe genia, nguchimwa nukutumbu kuchobela, “Atemi nga nkolongwa ku Efeso!” ");
INSERT INTO nnq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pannyini poa ngapabe na kijonga. Kikuta ngikinnyingili Gayo na Alistako, bandu ba Makedonia abatyanga pamwe na Paulo, ngabatila nabo mpaka kukibanja cha kuina ng'oma. ");
INSERT INTO nnq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo mwene apala kujenda nnongi jankengeni gwa bandu kuchindana nabo, nambu akinapunji ngabankanakia. ");
INSERT INTO nnq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Akiilongoi bange bilambu yenie, abakiba akaganjamundu, uyo ngabannagi nhwalo kutenda akikilayaje pikibanja. ");
INSERT INTO nnq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kingobu chenie abakongine boa bakiba bakakwaja, bange nyenela na bange nyenela, magambu ajingi kati jabe bamanyije angweto baikilinga kutenda nike. ");
INSERT INTO nnq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bange bandu bapemelela kutenda Alekizanda nga jwenio, mpaka Akayahudi pabannengela ajendi nnongi. Kubokapenia Alekizanda ngatondobe luboko kwa bandu kupala batamange nuu, na ngatumbu kukikombola. ");
INSERT INTO nnq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nambu angweto pabamanya Alekizanda nga Nhyahudi angweto boa ngabachobela pamwe kilebe ucho kwa kingobu cha masaa mabena, “Atemi nga nkolongwa ku Efeso!” ");
INSERT INTO nnq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Penia kalani jukilambo chenie ngaoto kakotoya. Kulenga, “Makajango buku Efeso, kila mundu amanyi kutenda kilambo chenje cha Efeso nga cha ulenda cha nyumba ja nnongo Atemi na nnendei jwa inyago yae ejigwa kuboka ku mbengu. ");
INSERT INTO nnq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Abije mundu ojwaotwi kana nhwalo gwenio. Kwa yene nkotokange makapotekanaje. ");
INSERT INTO nnq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Maletangite bandu aba pamba baganu kube bijitukinije nyumba ja nnoongo wala nnoongo jwito munkege. ");
INSERT INTO nnq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Anda Demetilio na akakamwa maengo bakwe bakweti lukumbi na mundu jwajoa, tukweti amuli na machoba ga kongana piitamo yito ngumbi baotwi kupeleka kwenio. ");
INSERT INTO nnq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nambu anda nkwetangite minhalo jenge mpelekanga pangongano ejipaligwa ja bandu. ");
INSERT INTO nnq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwa magambu gwa ganga, agapitile leleno butulekaje kututakiana, matukolaje majango ga kajanga.” ");
INSERT INTO nnq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kuboka pa kulonge genia lukumbi ngulupela. ");
INSERT INTO nnq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kuboka pa kijonga kotoka, Paulo ngabakema pamwe akinapunji na ngabalimbi mwojo na ngabatabuka. Ngabaleka ngajenda kilambo chu Makedonia. ");
INSERT INTO nnq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ngapetela kuilambo yenie na kape mojo bandu abaamine kwa malobe ndu. Penia ngaika Kugiliki, ");
INSERT INTO nnq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kwenio ngatama myei mitatu. Ngapanganika kujenda ku Silia apang'anyama kube babi Akayahudi bange bunhwachila mabaja, ngaamua kubuja kupetela ka Makedonia. ");
INSERT INTO nnq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopata mwana jwa Pilo, kuboke ku Belea, ngalongwana nakwe, uyo pamwe na Alistako na Sekundo, kuboke ku Kusesalonike, Gayo kuboke ku Debe, Tukiko na Tolofimo, kuboke kukilambo cha Asia, na Timoteo. ");
INSERT INTO nnq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Angweto ngabalongalela nu kutulenda ku Toloa. ");
INSERT INTO nnq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ngutuombe mungalaba kuboke ku Filipi kuboka pa Mpapala gwa Mikate janga jelwa Kimela, machoba nhwano ngatakolela ku Toloa, kwenio ngututama machoba saba. ");
INSERT INTO nnq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jumamosi kimuyo ngutukongana kulye nkate pamwe. Paulo ngalonge na bandu mpaka kilo puwiku, apanga kujabula malabo jakwe. ");
INSERT INTO nnq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Imbelembele ijingi ikiba yakajaka kuchumbi kugolofa okutukonganaga. ");
INSERT INTO nnq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kakombo jumwe ojwakemigwa Yutiko akiba atamite pilidilicha na kongo Paulo akajendekea kulongela, Yutiko akiba nulugono muno, Paulo apajendekea kulongela ngayanga kugochela na ngagwe kuboke kugolofa ja tatu mpaka pae. Apabanyinulaga, akiba ajomwike. ");
INSERT INTO nnq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nambu Paulo ngauluka pae ngalita ngankumbatila na kalenge bandu, “Makabeganga na mbweleje abi tango bwomi!” ");
INSERT INTO nnq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Penia ngaombela kabele ku golofa, ngametula nkate, ngalye. Kuboka pu kulonge nabo muno angweto, mpaka pilipita lichoba, Paulo ngajabula. ");
INSERT INTO nnq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Akaumini ngabampeleka kakombo jo kachabe, kongo abi momi na ngabaala mojo muno. ");
INSERT INTO nnq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Twenga ngutuombe mumeli ngutujenda kukilambo cha Aso, Tupeta kuntola Paulo. Akutulenge mwene tupete kwenio, magambu ajenda kwenio kupete kilambo kijomo. ");
INSERT INTO nnq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kingobu apakongana na twenga kukilambo cha Aso, ngutuombe mungalaba pamwe ngutujenda ku Mitulene. ");
INSERT INTO nnq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Malabo jakwe ngutujenda kwa ngalaba kuboke kwenio nu kuika kukilambo cha Kio. Lichoba eliika ngutuika ku Samo, na lichoba lenge ngutuika kukilambo cha Mileto. ");
INSERT INTO nnq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo ngaamu kujendeke na mwanja kwa ngalaba mpaka ku Efeso, apaije kuchelwa kuilambo ya Asia. Ngajenda chokwe Kuyelusalemu kubutuki lichoba lya Pentekoste, anda iwechakine. ");
INSERT INTO nnq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kuboke kilambo cha Mileto ngakinga nhwalo ku Efeso, kupala akinanhota bi kikuta cha bandu abunhwamini Kilisto bakongane nakwe. ");
INSERT INTO nnq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kingobu angweto pabaika kwenio ngabalengela, “Mmanyi kutenda kingobu choa nakiba namangweto, kuboka lichoba lya kutumbula panaika kuilambo ya Asia. ");
INSERT INTO nnq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Kukunyenyepa na manjochi twee ngangamwa maengo andi nammanda jwa Angwana kingobu chu ukomo ogunapata magambu gwa itendwa ibaja ya Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mmanyi kutenda nakotwikeje kamula kilebe chachoa chinapaligwa kunnyangata mangweto kukutangacha nu kubola pukongolou nu muikaja. ");
INSERT INTO nnq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kwa Akayahudi na bandu banga Akayahudi nganakelebuyanga balape malemwa gabe nu kummuji Nnoongo na kaamini Angwana ana Yesu. ");
INSERT INTO nnq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Na ngoe, kukunnyoa Uhuke jwa Chwapi nyenda Kuyelusalemu, manyije kwenio chikipakupitila kwango. ");
INSERT INTO nnq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Chinikimanyi nenga kila kilambo Uhuke jwa Chwapi nganenge tango nu kupitaje kutenda ipungo nu kulaga kutenda kunenda. ");
INSERT INTO nnq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nambu bwomi gwango nubona kilebe chamboneje kwango, mbala nenganikie undundame gwango na nyomole liengo lyale libambi Angwana ana Yesu kamula, kuchalakicha Nhwalo Gwambone gupeele gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ndyangite panakati jinu mmoa, kuntangachi Kingwana cha Nnoongo. Na ngoe manyi mmoa ne umonaje kabele. ");
INSERT INTO nnq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yene nannengelanga chengeni, anda mundu jwajoa kati jinu aobite ne ngoligwaje. ");
INSERT INTO nnq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwa magambu ne ngotwikeje kuntangachilanga goa agapala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mmaganga maha mmenemangweto na mikilendele kikuta echampi Uhuke jwa Chwapi. Mmegange makachungi bi kikuta cha bandu ba Nnoongo abunhwamini Kilisto echapata kupete myai ja Mwana jwakwe. ");
INSERT INTO nnq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Manyi kutenda kuboka kwango ne tu, mamei makale gabakuika kwinu, gabeje na kia kukikuta. ");
INSERT INTO nnq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kingobu kitenda kuika bandu bange kuboke mukikuta chinu balongela gu uwangi na kaoyanga akinapunji bakengame angweto. ");
INSERT INTO nnq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mma maha, na nkombakele kutenda kwa manjochi twe, kilo na mui, nakotwikeje kummola mmoa kwa yaka itatu. ");
INSERT INTO nnq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Na ngoe nammekanga mangweto mulenda gwa Nnoongo na nhwalo gwa upeele gwakwe. Jwenio akweti uwecho gwa gukunchenga nu kunhotoya mpatange kindimba cha Nnoongo chababeki bandu bakwe boa abajeguigwe. ");
INSERT INTO nnq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Natoije uloi gwa mundu wala jaabu wala ngobo. ");
INSERT INTO nnq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mmenemangweto mmanyi kutenda nakamula maengo kwa maboko gango kupata gambala na kakajango. ");
INSERT INTO nnq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nannayangite mangweto kila kilebe kukulandanikia ku kamu maengo kukachana kundela jenie tajangata abanying'anyile, tukombakele lilobe lya Angwana ana Yesu bene balenga, ‘Chwapi kupanga kuliko kupokela.’ ” ");
INSERT INTO nnq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kingobu Paulo pajomola kulongela, ngakilakitila majugwa pamwe na angweto nu kunng'ongale Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Boa bakiba bakagutanga ngabankumbatila na ngabatabukana. ");
INSERT INTO nnq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bakibanga nu kuechuka muno magambu balengi bimmonaje kabele. Kuyene ngubunhwindikilanga mpaka ku ngalaba. ");
INSERT INTO nnq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ngatatabuka angweto ngutujabula. Kuboka pu kuombela muntumbwi ngutujenda mpaka ku Kosi, malabo jakwe ngutuika ku Lode, nu kuboke kwenio ngutujenda mpaka ku Patala. ");
INSERT INTO nnq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kwenio ngitijikolela meli ejijenda ku Foinike, kuyenie ngutujingila nu kujabula. ");
INSERT INTO nnq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ngutuika paali aputuotola kukubona ku Kupulo, nu kuboka penia kupete kubanda ku Silia. Ngutuika mpaka ku Tilo, kwenio meli jakiba jakauluya miigo jakwe. ");
INSERT INTO nnq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kwenio ngatakolela akinapunji bange nu ngututama na angweto kwa machoba saba. Kwa makakala gu Uhuke jwa Chwapi ngabannengela Paulo akajendaje Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nambu kingobu cha twe kutama na angweto apikipela, ngutujabula. Angweto boa, pamwe na akahanamundu ni ingota, ngubutuindakila mpaka panja ja kilambo kumbwani, kwenio tuboa ngutukilakitila nu kunng'ongalela Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Penia ngututabukana, twe ngutujingila mumeli na angweto ngababuja kachabe. ");
INSERT INTO nnq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Twenga ngutujendeke na mwanja, kuboke ku Tilo ngutuika ku Tolemaisi, kwenio ngatapata abali abaamine akajito nu kutama nabo kwa lichoba limwe. ");
INSERT INTO nnq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Malabo jakwe ngutuboka ngutuika ku Kaisalia. Kwenio ngututama ku nyumba ja Filipo ojwakiba ntangachi. Filipo ojwakiba jumwe kati ja bandu saba abapambuligwa Kuyelusalemu babe akajangati. ");
INSERT INTO nnq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Akiba na akaenja ncheche abakiba tango bangatoligwa, abalondola nhwalo gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tukiba tutamite penia kwa machoba machoko kingobu tu nnondoli ojwakemigwa Agabo ngaika kuboke ku Yudea. ");
INSERT INTO nnq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Atuikalila twenga, ngatola luunga lwa Paulo, ngakitaba makongono maboko gakwe, nu kulenga, “Uhuke jwa Chwapi alenga yene, mundu juna luunga londo nga apapakutabigwa yene na Akayahudi Kuyelusalemu, nu kunkamuya kwa bandu banga Akayahudi.” ");
INSERT INTO nnq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Apatujoa genia, twenga pamwe na akajito ngutumpembela Paulo akajendaje Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nambu jwenio ngajanga, “Ntendanga nike, mapala kunyituya mwojo kwa nguto andi jenje? Ne mbi tayali ati kukutabigwa tuje Kuyelusalemu nambu ati kuwe kwenio magambu gwa Angwana ana Yesu.” ");
INSERT INTO nnq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Apatuchipula kunhwibila, ngutunneka nu kulenga, “Elibapala Angwana likamuligwe.” ");
INSERT INTO nnq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kuboka pu kutama machoba machoko kwenio, ngutubeka ilebe ito tela nu kujenda Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bange akinapunji kuboke ku Kaisalia ngabajenda pamwe na twenga ngubutupeleka ku nyumba ja Mnasoni ojwabokela ku Kupulo, putukiba tukajenda kutama kukingobu tu. Nasoni akiba ojwaamine jwa machoba majingi. ");
INSERT INTO nnq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kingobu apatuika Kuyelusalemu, abaamine ngubutupokela kwa mbone. ");
INSERT INTO nnq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lichoba eliika Paulo ngalongwana na twenga kujenda kunnola Yakobo, na akinanhota bi likanicha bakiba. ");
INSERT INTO nnq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo ngabapata abali na kalandulila kila kilebe echatei Nnoongo panakati ja bandu banga Akayahudi kupete maengo gakwe. ");
INSERT INTO nnq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kuboka pu kumpenakia jwenio, boa ngabannumba Nnoongo. Kuboka penia ngabalenga, “Malongo ana Paulo, nhwotwi kulola Akayahudi alenga abaamininge, apabakengama Malagilo. ");
INSERT INTO nnq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bajoine kutenda mwe mabolangita Akayahudi abatamanga kwa bandu banga Akayahudi kulenga bakakengamaje Malagilo ga Musa, ni bikiinaje ingota yabe na wala bakakengamaje ikobo ya Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bamanyangite kutenda nhwike. Lele tutenda, bo? ");
INSERT INTO nnq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Yene nguputupala mwe ntende. Pamba babi akinalome ababekite nalili. ");
INSERT INTO nnq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nnyende makalongwane nabo ku mpapala gwa kukijeguya, makalepe chikipaligwa, penia bachekuligwe mitwe yabe. Penia bandu mabamanya kube minhalo jaje ejibijoina kwinu jambonije, gambu mmene ntama nu kengamana na Malagilo ga Musa. ");
INSERT INTO nnq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nambu ku bandu banga Akayahudi abaamininge tapeleki balua kalenge twe tuamwi angweto bakalyeje chakulya cha chochoa chikipangigwe kwa milongo juwangi, andaje myai andaje inyama yayoa ipopotoligwe, ku yenie bapaligwa babe kutaali na ngongola.” ");
INSERT INTO nnq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yene Paulo ngabatolanga bandu bala na lichoba elikengima ngabeka mpapala gukukijeguya pamwe na benia. Kuboka penia ngajenda kuibanja ya nyumba ja Nnoongo na ngabatangachi machoba balenga mpaka kujomola kukijeguya nga lichoba lya kupanga lilumbo lya kila mundu. ");
INSERT INTO nnq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nambu machoba saba genia pagabandakila kupeta, bange Akayahudi kuboka kuilambo ya Asia ngabammona Paulo kuibanja ya nyumba ja Nnoongo. Ngabakolake bandu bampukile Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Angweto ngabachobela, kulenga, “Bandu ba Kuisilaeli mutujangate jonjo nga mundu ojwajenda kila paali kummola kila mundu gangapaligwa ku bandu ba Kuisilaeli, Malagilo ga Musa na nyumba ja Nnoongo. Na ngoe baletite bandu banga Akayahudi ku nyumba ja Nnoongo nu kupabeka paali pa Chwapi uchapu!” ");
INSERT INTO nnq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Balenga yene magambu bammweni Tolofimo kuboke ku Efeso abi pamwe na Paulo pannyini, angweto bapemelela kutenda Paulo antoi jwenio nu kunneta kuibanja ya nyumba ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kilambo choa ngikibe na kijonga na bandu ngabaika kuboka kila kingonu ngabannyingili Paulo nu kunhuti panja ja ibanja ya nyumba ja Nnoongo. Kingobutu milyango ja ibanja ya nyumba ja Nnoongo ngijijigaligwa. ");
INSERT INTO nnq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nkenga gwenio ngujiga kunkoma Paulo, nambu nhwalo gwenio ngaujoa nkolongwa jwa Loma kilongoi jwa manjolinjoli kutenda Yelusalemu joa jibi ni kijonga. ");
INSERT INTO nnq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Upo nkolongwa jwa manjolinjoli ngabatola akalenda na kilongoi ngabajenda kunkengeni gwa bandu. Kingobu bandu apabammona jwenio pamwe na manjolinjoli, ngabakotoka kumputa Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nkolongwa jwa manjolinjoli ngannyendelela Paulo, ngabampukila, nu kuamulicha atabigwe mitondolo mibena. Penia ngakonya, “Ojo mene, na atei nike?” ");
INSERT INTO nnq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bandu bange pankenga gwenio ngabachobela kile chenje na bange chenge. Magambu gwa kijonga chenie, nkolongwa jwa manjolinjoli aotwije kumanya nhwalo ogupitile, kuyenie ngaamulicha bandu bakwe bantole Paulo mpaka muboma. ");
INSERT INTO nnq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pababandakila kuika nakwe pangacha, manjolinjoli genia ngagampotola Paulo magambu gwa kijonga cha bandu. ");
INSERT INTO nnq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Angweto boa ngabankengama kongo bakachobela kulenga, “Mankome jwenio!” ");
INSERT INTO nnq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Manjolinjoli apagapala kunnyingiya Paulo muboma, Paulo ngannengela nkolongwa jwa manjolinjoli, “Nhotwi kunnenge kilebe?” Jwenio ngankonya, “Mmanyi kulongela Kigiliki?” ");
INSERT INTO nnq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Mwe jwajoje Mmisili ojwatumbula kijonga lichana tu na kalongelea akangondwa elufu ncheche mpaka kupongoti?” ");
INSERT INTO nnq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo ngajanga, “Nenga Nhyahudi namelikwa ku Taso ku Kilikia, mundu jwa kilambo echikimanyikana. Chonde nannyopa uneke nongele na bandu.” ");
INSERT INTO nnq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nkolongwa jwa akalenda ngajeketela, yene Paulo ngajema panani ja ngachi ngabapongela luboko bandu bakotoke manjega. Kingobu apabakotokanga, Paulo ngalongela nabo ku Kiebulania, ");
INSERT INTO nnq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Makalongo bango Akayahudi, umbenakiange nikikikombola nnongi jinu!” ");
INSERT INTO nnq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kingobu pabannyoa jwenio akalongela nabo ku Kiebulania, ngabayanga kutama nuhu, na Paulo ngajendeke, ");
INSERT INTO nnq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nenga na Yahudi, melikwa ku Taso ku Kilikia, nambu neligwa upamba pa Yelusalemu nakiba napunji jwa Gamalieli. Ngambata maboulo ga malagilo ga akahoka bito ngamegele kwa mojo gwoa kwa Nnoongo anda mangweto mmene mammi ngoe. ");
INSERT INTO nnq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nganapotekanga na kakoma baba abakengama ndela jenje. Nganapukila akinalome kwa akikege na kajigililanga mukipungo. ");
INSERT INTO nnq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nkung'i nkolongwa na kitamo choa cha akinanhota na akananhota baotolinge kuchalakicha nhwalo gwenio. Kuboka kwabe ngambokela balua ejibaandikila akalongo Akayahudi ababi kwenio ku Damasko. Nganyenda ku Damasko ibe napukile bandu benia natabe kwa mitondolo na kaleta Kuyelusalemu bapotikigwe. ");
INSERT INTO nnq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Apanakiba undela papipi kuika ku Damasko, ikiba saa sita nalumu, lumuli luna kung'ala muno kuboka kumbengu ngulupitila kingobutu ngulumulika ingonu yoa. ");
INSERT INTO nnq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Penia ngang'we pae, nginilijoa lilobe lyakanengela, ‘Sauli, Sauli! Kwa nike umboteka?’ ");
INSERT INTO nnq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ngangonya, ‘Mwe mabeneke, Angwana?’ Nganengela, ‘Nenga nga Yesu jwa ku Nazaleti, jwamampoteka mwenga,’ Ngannyangula. ");
INSERT INTO nnq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Akajango bala ababulubona lumulilo, nambu bajoiningije lilobe lya jwajo ojwalongela na nenga. ");
INSERT INTO nnq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ne ngangonya, ‘Ndendi nike Angwana?’ Bombe Angwana ngabannengela, ‘Nnyeme, nnyende ku Damasko na kwenio mabannengela goa Nnoongo agapala nkamule.’ ");
INSERT INTO nnq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kuboka pu kumulika lumulilo naotwije kulola na nyenie akajango ngabangamula luboko kunongalea mpaka nganhika ku Damasko. ");
INSERT INTO nnq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kukilambo chenie kukiba na mundu jumwe ojwa kemigwa Anania, mundu jwa nng'ongale Nnoongo, juna kujali Malagilo ga Musa, Akayahudi abakiba bakatama ku Damasko ngabachalakicha gwambone gwakwe. ");
INSERT INTO nnq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jwenio ngaika kunola, ngajema papipi na nenga, ngalenga, ‘Malongo ana Sauli, nnole kabele!’ Upo nganola kabele, nganannolakea. ");
INSERT INTO nnq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Penia Anania ngalenga, ‘Nnoongo jwa akanhota bito ampambwile mpate kumanya mapalano gakwe na kummona jwajo mpakachi jwakwe jwambone na kunnyoa mwene akalongela kulilobe lyakwe. ");
INSERT INTO nnq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwa magambu manchalakicha kwa bandu boa makalengela gaga agamagabweni na kugajoa. ");
INSERT INTO nnq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lele, kwa nike nchelwa muno? Nnyeme, na mmatichigwe na kuboigwa mabaja ginu kwa kunng'ongalela jwenio.’ ");
INSERT INTO nnq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ngambuja Kuyelusalemu, na apanakiba nakagongalela kuibanja ya nyumba ja Nnoongo, nganola malolo, ");
INSERT INTO nnq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","nganabona Angwana bakanengela, ‘Chokwe! Mmoke Kuyelusalemu chokwe kwa mana bandu ba penia bajeketeje kuchalakicha kwinu kwango.’ ");
INSERT INTO nnq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nane nganajanga, ‘Angwana, angweto bamanyi kube nenga nganyenda mukila nyumba ja kugongalela kataba na kaputa bandu ababunhwamini mwenga. ");
INSERT INTO nnq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na kingobu nchaili jwinu Stefano apakomigwa, ne namwene nakiba penia, nganyeketela ukomigwa kwakwe nu kulende ngobo ya abakiba bakankoma.’ ");
INSERT INTO nnq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Na Angwana ngabanengela, ‘Nnyende, gambu mbankinga kutaali ku bandu banga Akayahudi.’ ” ");
INSERT INTO nnq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bandu ngabampenaki Paulo mpaka apalenga genia, nambu angweto ngabatumbu kuchobela kulilobe likolongwa, kulenga, “Mammoye jwenio! Mankome jwenio! Apaligwije kulama!” ");
INSERT INTO nnq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ngabajendeke kwajuka, kongo bakanyukanyuka ngobo yabe, na bakalekela matukunda kunani. ");
INSERT INTO nnq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nkolongwa jwa Loma ngabaamulicha bandu bakwe bampeleke Paulo muboma, ngabalengela bampute iboko bamanye kwa nike Akayahudi batela nchobelela jwenio. ");
INSERT INTO nnq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nambu kingobu apabantaba ibe bampute iboko, Paulo ngankonya kilongoi jumwe ojwajemite penia, “Bo, ipaligwe kwinu kumputa iboko mundu jwa Loma tango nu kuhukumigwaje?” ");
INSERT INTO nnq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kilongoi jwenio apajoa yene, ngajenda kwa nkolongwa jwa manjolinjoli ngankonya, “Mpakutenda boo? Ojo mundu juku Loma!” ");
INSERT INTO nnq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kuyenie nkolongwa jwa manjolinjoli ngannyendela Paulo ngankonya, “Unengele, mwe mamundu ba Loma?” Paulo ngajanga, “Elo.” ");
INSERT INTO nnq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nkolongwa jwenio ngalenga, “Mbi na mundu ba Loma kukuemela uloi ndu.” Paulo ngajanga, “Nambu nenga namundu ba Loma kukubelekwa.” ");
INSERT INTO nnq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Upo bandu abajenda kunhwingakia Paulo ngabatila, na nkolongwa jwa manjolinjoli ngajogopa kingobu apamanya kube Paulo akiba mundu jwa Loma nu magambu akantaba mitondolo. ");
INSERT INTO nnq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nkolongwa jwa manjolinjoli ngapala kumanya lukumbi Akayahudi olukiba bammekile Paulo, kuyenie lichoba elikengima ngankulugula Paulo mitondolo na ngaamulicha akakung'i akolongwa na kitamo cha akinahota choa bakongane. Penia nganneta Paulo ngannyemeka nnongi jabe. ");
INSERT INTO nnq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo ngabalolakea muno bandu ba kitamo cha akinahota ngalenga, “Makalongo bango Makasilaeli! Mpaka lele mbi nakatama kwa mojo gwa mbone nnongi ja Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nkung'i nkolongwa Anania ngabaamulicha angweto abajemite papipi na Paulo bampute likopi pakano. ");
INSERT INTO nnq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo ngannengela, “Nnoongo amputa likopi mwenga mammi andi lipamanda elipakaigwe chwakala! Nhwotobo kutama penia nu kuhukumu kuboke Mumalagilo kongo mmene magaalabia Malagilo makaamulicha mbutigwe?” ");
INSERT INTO nnq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bandu abakiba bajemite penia ngabannengela Paulo, “Mantukana Nkung'i Nkolongwa jwa Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo ngajanga, “Makalongo Makasilaeli, namanyije kube ojo nga Nkung'i Nkolongwa. Majandiko Gachwapi galenga, ‘Makalonge mabajaje ku ntawala jwa bandu binu.’ ” ");
INSERT INTO nnq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Penia Paulo apamanya kube kati ja bandu benia gabi Masadukayo na Mafalisayo, Ngatondabeya lilobe nnongi ja kitamo cha akinahota, “Makalongo Makasilaeli! Nenga Nafalisayo, mwana jwa Mafalisayo. Nenga netigwe nnongi ja kitamo chakinanhota magambu gwa kuhyobalela abawile mabayoka.” ");
INSERT INTO nnq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kingobutu kuboka pa kulongela yene, Mafalisayo na Masadukayo ngabatumbu kutaukana muno, bandu benia ngababaganika. ");
INSERT INTO nnq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Gambu Achamasadukayo bakalenga yene bandu bayokaje kuboka pa kuwe na kutenda babije akapakachi kuboka kumbengu na wala uhuke, nambu Mafalisayo kujeketela goa matatu gano. ");
INSERT INTO nnq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bandu ngabayanga kuchobela, bange akaboli ba Malagilo ga Musa ababi munkenga gwa Mafalisayo ngabajema nu kutumbu kulonge kwa makakala muno, “Tubi kukibonaje kile chochoa chela kibaja kumundu jonjo! Pangaje alongi nakwe uhuke andaje mpakachi kuboka kumbengu!” ");
INSERT INTO nnq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Mitau ngijibeka kijonga muno mpaka nkolongwa jwa manjolinjoli ngajogopa kutenda Paulo kabi bantopaline. Kuyenie, ngagaamulicha manjolinjoli gakwe gajingalile kati ja kikuta chenie, bammoye Paulo penia, nu kumpeleka mu boma. ");
INSERT INTO nnq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kilo jenie Angwana ngabajema papipi na Paulo nu kulenga, “Makajogopaje! Anda apamachalakicha bandu nhwalo gwango pamba pa Yelusalemu, nu uyo mpaligwa kalenge kukilambo cha Loma.” ");
INSERT INTO nnq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Apakuchaga, Akayahudi bange ngabakongana pamwe nu kupangana njama. Ngabalapila kutenda balyeje kilebe wala kunywe mpaka apabapankoma Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bakiba bandu kupeta makomi ncheche abapanganila genia pamwe. ");
INSERT INTO nnq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kuboka penia ngabajenda kwa akakung'i akolongwa na akinanhota, bakalenga, “Twenga tutekulapila pamwe takalyeje kilebe mpaka apatupa kunkoma Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ngoe, mangweto pamwe na kitamo cha akinahota nkingange chalamu kwa nkolongwa jwa manjolinjoli kutenda annete Paulo, makakopakea kutenda mpalanga kumanya kipola nhwalo gwakwe jwenio. Nambu twenga tuba tela kunkoma jwenio tango nu kuikaje pamba.” ");
INSERT INTO nnq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nambu mwipa gwakwe Paulo ngajoa machabuli genie, kuyenie ngajenda ku boma nu kunnenge Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Penia Paulo ngankema kilongoi jumwe jwa akalenda ngannengela, “Mantole kakombo jonjo mpaka kwa nkolongwa jwa akalenda, akweti nhwalo gwakalengela bombe.” ");
INSERT INTO nnq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kilongoi jwa akalenda jwenio ngantola kakombo jwenio, ngampeleka kwa nkolongwa jwa akalenda, kulenga, “Ojwajigiligwe Paulo ngangema nenga nukunyopa nannete kakombo jonjo kwinu, magambu akweti nhwalo gukunnengela mwenga.” ");
INSERT INTO nnq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nkolongwa jwa manjolinjoli ngankamula kakombo jwenio luboko, ngajenda nakwe pantemela, nu kunkonya, “Nkweti kini chukunengela?” ");
INSERT INTO nnq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Jwenio ngalenga, “Akayahudi bapangine bannyope mwenga malabo bantole Paulo kukitamo cha akinahota, bakakopakea kutenda kitamo cha akinahota bapala kumanya kipola nhwalo gwa jwenio. ");
INSERT INTO nnq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nambu mwenga makapenakiaje angweto, magambu babi bandu makomi ncheche abapakukiiya nu kunnenda jwombe. Balapilinge balyeje wala kunywe mpaka apabapa kunkoma. Ngoe babilingite tela balendela pampa kuamua mwenga.” ");
INSERT INTO nnq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nkolongwa jwa akalenda nganneka ajabule nu kunnagi, “Makannengeje mundu kutenda unengi nenga.” ");
INSERT INTO nnq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Penia nkolongwa jwa akalenda ngabakema akilongoi abena ba akalenda ngabalengela, “Mpanganie akalenda ichilini bu kujenda ku Kaisalia, pamwe na akaombe falasi makomi saba na akalenda makomi komi mabena bina mikoa, na mme tela kuboka lele saa tatu ja kilo. ");
INSERT INTO nnq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mmekange falasi yenge ya Paulo mumpelekange kwa tengela mpaka kwa ntawala jwa kilambo jwakemigwa Felisi.” ");
INSERT INTO nnq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Penia nkolongwa jwa akalenda ngaandika balua yene, ");
INSERT INTO nnq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Makolongwa ana Felisi chalamu chinu. Nenga Kilaudio Lusia nunhwandikila. ");
INSERT INTO nnq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Akayahudi ngabampukila mundu jonjo na bapala kunkoma. Ngamanya kube akiba mundu jwa Loma, kuyenie nganyenda pamwe na manjolinjoli gango nu kunkombola. ");
INSERT INTO nnq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nganampeleka ku kitamo cha akinahota lyabe mbala kumanya kipola nhwalo gwa lukumbi lwabe. ");
INSERT INTO nnq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ngamanya kube ateije kile chochoa chela echapaligwa kuwe andaje kujigaligwa mukipungo, lukumbi lwene lukiba nhwalo gwa malagilo gabe. ");
INSERT INTO nnq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na kingobu panamanya kutenda Akayahudi bapalanga ndela ja kunkoma jwombe, upo ngaamua kunneta kwinu. Nganalengela abantakiana balete lukumbi lwabe kwinu.” ");
INSERT INTO nnq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Manjolinjoli genia ngagatenda apabaamiluligwe. Ngabantolanga Paulo kilo jenie mpaka ku Antipatili. ");
INSERT INTO nnq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lichoba elikengima manjolinjoli agatyanga kwa makongono ngababuja ku boma na ngabaleka achamanjolinjoli abatyanga mufalasi bajendeke na mwanja pamwe na Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na apabaika ku Kaisalia, ngabampe ntawala jwa kilambo balua jela na kummeka Paulo pulenda gwa benia. ");
INSERT INTO nnq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ntawala jwa kilambo ngachoma balua jenie nu kunkonya Paulo aboke kilambo nike. Pimanyika kutenda aboke kilambo cha Kilikia, ");
INSERT INTO nnq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ngalenga, “Mambenakia lukumbi lwinu apabapakuika abantakiine.” Penia ngaamulicha Paulo alendigwe pulenda gwa panchana gwa Helode. ");
INSERT INTO nnq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kuboka pa machoba nhwano, nkung'i nkolongwa Anania ngaika ku Kaisalia pamwe na akinanhota akachoko pamwe na mundu jwa chalia ojwakemigwa Tetulo. Ngabannyendelela ntawala Felisi nu kumpeleke lukumbi lwa Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulo ngakemigwa na Tetulo ngatumbu kuntakiana Paulo yene, “Anahota Felesi! Ulongoi gwinu gwa mbone uletite tengela kwa machoba majingi na mawacho ginu mayono kukugalambuya iletite ibe chwapi mukilambo chito. ");
INSERT INTO nnq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Genia goa tagapokile kukualali mwojo nu kunnumba muno kila paali. ");
INSERT INTO nnq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nambu, nu kuchelwa, tunnyopa kwa mwojo gwinu gwa mbone, mpenakie nhwalo gwito nchoko. ");
INSERT INTO nnq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tumanyi kutenda mundu jonjo nga jwa ngondo muno. Jwombe atumbula kijonga kwa Akayahudi kila paali padunia nu uyo nga kilongoi jwa chama cha Akanazaleti. ");
INSERT INTO nnq_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kabe ngajitukana nyumba ja Nnoongo, natwe ngutumpukila. Natwe ngutupala kuhukumu kuboke mumalagilo gito. ");
INSERT INTO nnq_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nambu Lusia, nkolongwa jwa manjolinjoli, ngajingilila panakati, ngantola kwa makakala mukuboko jito. ");
INSERT INTO nnq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Anda mankonyite mundu jwenio, mwe mmene maumanya kipola ku jwenio ilebe yoa twenga eyatantakiana. ");
INSERT INTO nnq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Akayahudi ngababe pamwe mukuntakiana jwenio nukulenga kutenda genia goa gakiba kweli. ");
INSERT INTO nnq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","“Penia nkolongwa jwa kilambo ngampongela luboko Paulo alongele, na Paulo ngalenga, “Manyi kube mwe manahakimu ba kilambo chenje kwa yaka ndu, kuyene nhali mwojo kukikobola nnongi jinu. ");
INSERT INTO nnq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mwe mmene nhwotwi kuingakia nu kumanyi kutenda nakiba Kuyelusalemu machoba komi na mabele ganapetaje tangu mujite kwenio. ");
INSERT INTO nnq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Akayahudi bangolalingeje nakataukana na mundu kuibanja ya nyumba ja Nnoongo, wala bangolalingeje nakakolakea bandu, kunyumba ja kugongalela na wala paali popoa kunnyini. ");
INSERT INTO nnq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Na kuotwaje kulonge uchaili gu lukumbi londo lubandakiine. ");
INSERT INTO nnq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Echinyeketela nnongi jinu nga chenje, Nenga nanng'ongalela Nnoongo jwa akinahota bito nakakengama ndela ejibikema ndela jinhwangi. Nambu nenga nhamini kila kilebe echikiandikigwe Mumalagilo ga Musa na muitabu ya akalondoli ba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nenga nunhyobalela Nnoongo, nangweto uyo, kutenda bandu, bambone na akabaja, mabayoka kuboka kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kuyenie ngachana kwa makakala muno kube na mwojo gwa mbone nnongi ja Nnoongo na nnongi ja bandu. ");
INSERT INTO nnq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Panakiba kutaali na Kuyelusalemu kwa yaka ndu kachoko, nganyenda kabe Kuyelusalemu kupeleka uloi ku bandu bango nu kupanga lilumbo. ");
INSERT INTO nnq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ogunakiba nakakamula genia nga apabangolela kuibanja ya nyumba ja Nnoongo, kiti nyomwile kugongalela kukukijeguya. Kukibaje nkengeni gwa bandu andaje kijonga. ");
INSERT INTO nnq_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nambu kukiba na Akayahudi bange kuboke kukilambo cha Asia, benia nga abapaligwa kube nnongi jinu nu kubeka lukumbi lyabe anda kweli bakweti chochoa chukundakiana nenga. ");
INSERT INTO nnq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Andaje, maleke aba ababi pamba balenge lilemwa elibilikolela kwango kingobu apanajema nnongi ja kitamo chabe cha akinahota, ");
INSERT INTO nnq_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","nambu tu malobe ganga aganengita ogunyemita nnongi jabe, ‘Bandakiana lele nnongi jinu magambu gwa kujendeke kuamini kutenda abawile mabayokage.’ ” ");
INSERT INTO nnq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Penia Felisi, ojwakiba ajimanyi ndela jenie kwambone, ngaekalela oti lukumbi lwenio. Ngabalengela, “Mambanga hukumu ja lukumbi londo apapakuika pamba Lusia, nkolongwa jwa manjolinjoli.” ");
INSERT INTO nnq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Penia Felisi nganhwamulicha nkolongwa jwa manjolinjoli ojwakiba akalenda penia ammeke Paulo pulenda, nambu baleke akaganja mundu bantyangile nu kunnete gapala. ");
INSERT INTO nnq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kuboka pa machoba machoko, Felisi ngaika pamwe na nhwanamundu Dulusila ojwakiba Nhyahudi. Ngaamulicha Paulo aletigwe, bampenakia akalongela nhwalo gwa kunhwamini Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nambu kingobu Paulo apajendekea kulongela nhwalo gwa ilebe yaipala Nnoongo, na kikibeka maha mwene na nhwalo gwa lichoba lya hukumu eliika, Felisi ngajogopa, ngalenga, “Ngoe nhwotwi kujabula, tankema kabela apatupakube na napachi.” ");
INSERT INTO nnq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kingobu chenie ahyobalela kutenda Paulo kabi ampi uloi, yene ngabe akankema Paulo kila kingobu nu kulongela nakwe. ");
INSERT INTO nnq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kuboka pa yaka ibena kupeta, Felisi ngato liengo lya Pokio Festo atawale kuboka pa jwenio. Na Felisi ngapala kube jwambone kwa Akayahudi kuyene nganneka Paulo mukipungo. ");
INSERT INTO nnq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo paika ku Kaisalia kuboka pa machoba matatu ngaboka ku Kaisalia, ngaika Kuyelusalemu, ");
INSERT INTO nnq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","akakung'i akolongwa pamwe na akiilongoi ba Akayahudi ngabannete lukumbi lwa Paulo. Ngabampembe Festo, ");
INSERT INTO nnq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","batendele gambone kukunneta Paulo Kuyelusalemu, bakiba bapangine njama ja kunkoma undela. ");
INSERT INTO nnq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nambu Festo ngajanga, “Paulo abi kukipungo ku Kaisalia, na nenga namwene manyenda kwenio machoba uganga. ");
INSERT INTO nnq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Malekange akiilongoi binu bajende ku Kaisalia pamwe na nenga kwenio bakapiange uchaili gwa lukumbi lwenio anda atei chochoa kibaja.” ");
INSERT INTO nnq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo ngatama nangweto kukingobu cha machoba nane andaje komi, kuboka penia ngabuja ku Kaisalia. Kindambi jakwe ngajenda kukitamo cha akinahota, ngaamulicha Paulo aletigwe unyumba. ");
INSERT INTO nnq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kingobu Paulo apaika, Akayahudi abaikanga kuboke Kuyelusalemu ngabantindila ngabatumbu kulenga ngumbi ndu ngolongolo kuntakiana jwenio nambu baotwije kuchalakicha. ");
INSERT INTO nnq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Nambu kwa kukikombola, Paulo ngalenga, “Nenga ndeije lilemwa lyalyoa nhwalo gwa Malagilo ga Akayahudi, andaje nhwalo gwa nyumba ja Nnoongo, andaje nhwalo gwa nngwana nkolongwa jwa Loma.” ");
INSERT INTO nnq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nambu Festo apala kube jwambone kwa Akayahudi na kuyenie ngankonya Paulo, “Bo, mpaile kujenda Kuyelusalemu na kwenio makahukumuligwe nnongi jango nhwalo gwa lukumbi londo?” ");
INSERT INTO nnq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo ngalenga, “Nyemite nnongi ja mahakama ga nngwana nkolongwa jwa Loma, nga pambaligwa kupata hukumu. Ne nalemwitije ubaja gwagoa Akayahudi mwe umanyi kipola. ");
INSERT INTO nnq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Anda nemwite magambu gwa malagilo na ndeile kile chambaligwa komigwa, nyopaje kulekekekigwa magambu gwa chenie. Nambu andi kweli jibeje nhwalo gu lukumbi londo, abije mundu ojwapakumbeleka kwabe. Nyopa lufaa kwa nngwana nkolongwa jwa Loma.” ");
INSERT INTO nnq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festo kuboka pu kulongela na kitamo cha akinahota bakwe, ngannengela Paulo, “Nnyopite lufa kwa angwana ba Loma, mikikombola kangwana ba Loma.” ");
INSERT INTO nnq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Machoba nduje kuboka penia, Nngwana Agilipa na Benike ngabajenda ku Kaisalia kumpata abali nu kumpoke Festo. ");
INSERT INTO nnq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kuboka pukutama machoba machoko kwenio, Festo ngalandulila lukumbi lwa Paulo, “Abi mundu jumwe pamba Felisi anneka mikipungo, ");
INSERT INTO nnq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","na apanajenda Kuyelusalemu, Akakung'i akolongwa ba Akayahudi na akinanhota ngabanete lukumbi kuntakiana Paulo bakapala nunhukumu. ");
INSERT INTO nnq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nambu nenga nganalengela kutenda lukoboje kwa bandu ba Loma kumpia mundu ahukumigwe panga jwatakiinigwe anakonganaje na bandu abantakiine kumio nu kumio nu kumpe kingobu cha kukikombola nhwalo gwa lukumbi lwenio. ");
INSERT INTO nnq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kingobu apabaika pamba, nenga nachelwiteje, nambu malabo jakwe ngandama pikitamo chakananhota nu kuamulicha mundu jwenio aletigwe. ");
INSERT INTO nnq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bandu abantakiana ngabajema nambu bapiiteje lukumbi lubaja anda apannolela. ");
INSERT INTO nnq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nambu kukiba na mitau kachoko pamwe na jwenio nhwalo gwa dini jabe na nhwalo gwa mundu jumwe ojwakemigwa Yesu, ojwawile, nambu Paulo ngakachana kulenga abi momi. ");
INSERT INTO nnq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Namanyije chukamula nhwalo gwa kile chenie, kuyenie nganankonya Paulo anda kabi apaile kujenda kukitamo chakananhota ba Kuyelusalemu magambu gwa lukumbi lwenio. ");
INSERT INTO nnq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nambu Paulo ngajopa lufaa, ngajopa banneke mikipungo mpaka angwana ba Loma pabakujomola lukumbi lwenio. Kuyenie ngaamua atame mikipungo mpaka apambakumpeleka kwa angwana ba Loma.” ");
INSERT INTO nnq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa ngannengela Festo, “Mbala kumpenakia mundu jwenio namwene.” Festo ngajanga, “Mampenakia malabo.” ");
INSERT INTO nnq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Malabo jakwe Agilipa na Benike ngabaika pamwe na ilulu ku nchana gwa lukumbi kongo balongwine na akakolongwa ba manjolinjoli na akiilongoi ba kilambo. Festo ngaamulicha Paulo aletigwe unyumba. ");
INSERT INTO nnq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo ngalenga, “Nngwana Agilipa na mmoa mammilingite pamba pamwe na twenga! Nnongi jinu abi mundu jwenio Akayahudi boa ba pamba na ba ku Kuyelusalemu ngabakwajalila nu kutenda manjega kutenda apaligwije kulama. ");
INSERT INTO nnq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nambu nenga nikibwenije kilebe echateile echikibi kibaja chukupaligwa komigwa. Nambu magambu Paulo mwene ngajopa lufaa ku nkolongwa jwa Loma, ngaamua kumpeleka. ");
INSERT INTO nnq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nambu kingonu chango ngwetije uchaili gu nhwalo gwenio gukuoto kunhwandikila nkolongwa jwa Loma. Ne nga nannetite pamba nnongi jinu na kwinu mangwana ana Agilipa, ibe kuboka pa kunhwingakia, nhotole kube na chukuandika nngwana jwa ku Loma. ");
INSERT INTO nnq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mbemelela kube chwapije mbakamu chukuomongwa kumpeleka ojwajigiligwe panga lenga kipola lukumbi olubantakiana.” ");
INSERT INTO nnq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa ngannengela Paulo, “Nnyeketiligwe kukikombola mmene.” Paulo ngatondabea luboko lwakwe ngalenga yene, ");
INSERT INTO nnq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nngwana Agilipa! Nikibona ngweti upeele lele gu kujopa nnongi jinu nhwalo gwa lukumbi lwoa lwa Akayahudi lubandakiana nenga, ");
INSERT INTO nnq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","muno magambu mwenga mmene mmanyi lukobo lwa Akayahudi na ukomo gwabe, nanyopa yene umbenakie kukunhimbalila. ");
INSERT INTO nnq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Akayahudi bamanyi nenga kuboke ungota gwango. Panatama kutumbu kubandu, kutumbu kukilambo kachango na mpaka Kuyelusalemu. ");
INSERT INTO nnq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Benia bamanyi kwa kingobu choa, na baotwi kuchalakicha, anda bapailinge, kutenda kuboke pukutumbula natama andi jumwe kati ja kikuta china ukale muno mudini jito, yani kikuta cha Mafalisayo. ");
INSERT INTO nnq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na ngoe mbi pamba nhukumigwa kwa magambu gwa kuhyobalela malagano ga Nnoongo galagana na akahokabito. ");
INSERT INTO nnq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Lilagano lyene nga ulyale eligahyobalela makabila komi na mabele ga kilambo chito, kunng'ongalela Nnoongo kwa machoba goa kilo na mui. Angwana, Akayahudi bandakiana kwa magambu gwa kuhyobalela kwenio! ");
INSERT INTO nnq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kwa nike mangweto kuaminije kutenda Nnoongo bayoyanga abawile? ");
INSERT INTO nnq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ne namwene ngaamini kutenda nhotwi kamula ilebe ijingi kulikana liina lya Yesu juku Nazaleti. ");
INSERT INTO nnq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Minhalo jenie nga ejinakamula kwenio Kuyelusalemu. Ne namwene, nakiba bambile kinala kuboka kwa akakung'i akolongwa, ngambata kabeka mukipungo ajingi bandu ba Nnoongo. Angweto apabaukumigwa komigwa, na ne nganyeketela. ");
INSERT INTO nnq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Pajingi nganatendanga bapotekigwe mu nyumba ya kugongalela yoa nakapoteka bijikanange imani yabe. Lilaka lyango kwabe likiba likolongwa ata nganapalanga mpaka ilambo ya kutaali. ");
INSERT INTO nnq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Kwa liengo ulyo, nganyenda ku Damasko, mbi ni kinala na chalamu kuboka kwa akakung'i akolongwa. ");
INSERT INTO nnq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Angwana, panakiba undela, saa sita nalumu, ngunulubona lumuli lwakamulika muno kupeta lichoba jakamulika kuboka kumbengu, ngulundindila nenga na baba akamwanja jango. ");
INSERT INTO nnq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twe tuboa ngutugwe pae, nane nganyoa lilobe lyakanengela ku Kiebulania, ‘Sauli, Sauli! Kwa nike umboteka? Mikipoteka mmene panga kilebe anda liponda eliputa liteke bokola ja angwanamundu.’ ");
INSERT INTO nnq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nenga ngangonya, ‘Nga mabeneke mwe ma Ngwana?’ Bene Angwana ngabajanga, ‘Nenga na Yesu jwenio mwenga mampoteka. ");
INSERT INTO nnq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nambu nnyinuke, nnyeme kwa makongono ginu. Nampitile lele ibe nammeke mme mapakachi na machaili bi ilebe yenje eimibweni, nu kuilebe eimbakunnaya. ");
INSERT INTO nnq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Manankombola na bandu ba ku Isilaeli na bandu banga Akayahudi bombe nenga nankinga kwabe. ");
INSERT INTO nnq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mamaekula mio gabe na kaotoyanga baboke pulubendu na kujingila mulumuli, baboke mu makakala ga Lichetani, bammuji Nnoongo, kupala kukuamini, baotolange kulekekigwa mabaja gabe nu kutola ulichi kati ja baba abajeguigwe ku imani ejibi ku Nnoongo.’ ");
INSERT INTO nnq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kwa yene, Nngwana Agilipa, naotwije kube nimitau kwa malolo genia ga kumbengu. ");
INSERT INTO nnq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nambu natumbula kutangacha kwa bandu buku Damasko, penia kwa baba bandu ba Kuyelusalemu na kilambo choa cha ku Yudea, na uyo kwa bandu ba ilambo yenge. Nganakwajalila baleke mabaja babe bammuji Nnoongo na kulaya kuitendwa kube balapite mabaja gabe. ");
INSERT INTO nnq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa magambu genia, Akayahudi ngabambukilanga mbi munyumba ja Nnoongo, ngabajiga kungoma. ");
INSERT INTO nnq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nambu Nnoongo nganyangata na nyenie mpaka lichoba lya lele nyemite maha nakachalakicha kwa boa, akananhota na ingota. Ganongela nga gaga agakiba akalondoli ba Nnoongo na Musa ngabalenga magapitila, ");
INSERT INTO nnq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","yani apaligwa Kilisto apotekigwe na kube jwa kutumbula kuyoka kuboka kwa abawile, ibe atangache kube lumuli lya ukomboi kwa Akayahudi na bandu banga Akayahudi.” ");
INSERT INTO nnq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo mpaka penia mu kukikombola kwakwe, Festo ngalenga kwa lilobe likolongwa, “Paulo! Mmi namachonjo! Kuchoma kwinu kujingi kummeka machonjo!” ");
INSERT INTO nnq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nambu Paulo ngalenga, “Ngwetije machonjo angwana ana Festo. Chanenga nga kweli jika. ");
INSERT INTO nnq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mwe mangwana mmanyi minhalo jenje, kwa nyenie nhotwile kulongela panga jogopa nnongi jinu. Magambu manyi mwe mijimanyi minhalo jenie magambu kile chenie kitendigwe kukuiyaje. ");
INSERT INTO nnq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Angwana ana Agilipa, bo, mmi na imani na akalondoli ba Nnoongo? Manyi kube nhwamini.” ");
INSERT INTO nnq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Angwana ana Agilipa ngabanga Paulo, “Mpemele kukulonge genia nhwotwi kumeka na Kilisto?” ");
INSERT INTO nnq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo ngajanga, “Nannyopa Nnoongo kutenda, kwa kingobutu andaje kwa mangobu ndu, ngati mwetuje nambu kwa boa abanyoa lele bapatange kube anda apambi nenga, nambu panga mitondolo jenje.” ");
INSERT INTO nnq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Penia nngwana Agilipa na ntawala jwa kilambo na Benike, na boa abakiba pamwe nabo, ngabajema. ");
INSERT INTO nnq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Apababokanga, ngabalengelana, “Mundu ojo ateije kilebe chikipaligwa kunnhwukumula kuwe andaje kipungo.” ");
INSERT INTO nnq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nngwana Agilipa ngannengela Festo, “Mundu ojo kabi alekekigwe anda akabi ajopitije lufaa kwa nkolongwa jwa Loma.” ");
INSERT INTO nnq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kingobu apikiamuligwa tujende kukilambo chuku Italia, ngabammeka Paulo pulenda gwa Yulio ojwakiba kilongoi jwa manjolinjoli kukikuta echikikemigwa, “Kikuta cha Agusto.” ");
INSERT INTO nnq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ngutuombe meli kuboke ku Adilamito ejikiba jakajenda kupete kubandali yenge yi kilambo chenie cha Asia, ngututumbwa mwanja. Alistako, mundu jwa Kamakedonia kuboke Kusesalonike, akiba pamwe na twenga. ");
INSERT INTO nnq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lichoba elikengima ngutuika kubandali ja Sidoni. Yulio ngantende Paulo gambone kukunneka balole akaganja mundu nu kupata ilebe eyapala. ");
INSERT INTO nnq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ngutujendeke na mwanja kuboke penia, nambu magambu upepo gwakiba gwakaguguma kwa makakala muno gukutuikalila nnongi jito, ngutupetela kingonu cha kichilu cha ku Kupulo kwenio upepo gwakiba nduje. ");
INSERT INTO nnq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Penia ngutujomboka baali ja Kilikia na Pamfilia, ngutuika ku Mula, kilambo cha Lusia. ");
INSERT INTO nnq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kwenio kilongoi jola ngajikolela meli jimwe ja Alekizandalia ejikiba jakajenda ku Italia, na yene ngatuombe mwenio. ");
INSERT INTO nnq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kukingobu cha machoba ndu ngutujenda kachokochoko na kukulaga ngutuika papipi na Nido. Magambu upepo gwakiba tango gukutupenga, ngutujendekea nnongi kipola ngutupetela na kingonu cha Kulete papipi na Solomoni kwenio upepo gwakiba nduje. ");
INSERT INTO nnq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ngutupeta pambwega jakwe kachokochoko ngutuika paali apakemigwa, “Bandali jatengela,” papipi na kilambo cha Lasea. ");
INSERT INTO nnq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Machoba ndu gakiba gapetite na lichoba likolongwa lya kuchikichana likiba lipetite. Ngoe ikiba kujogoya kikoko kutyanga mumeli. Kuyenie Paulo ngabakelebuya, ");
INSERT INTO nnq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Makinahota, nubona mwanja gongo kutenda upakube gwa kupotekigwa muno na asala ndu ngiti kwa miigo na meli tuje, nambu uyo kwa bwomi gwito.” ");
INSERT INTO nnq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nambu kilongoi jola agajoa muno ga nahodha na ga juna meli ngabembu ga Paulo. ");
INSERT INTO nnq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Bandali jenie jikiba jambonije kutama machoba ga malili, ajingi ngaba palanga kujendekea na mwanja, andaiwechikine mpaka ku Foinike. Foinike nga bandali ja kilambo cha Kulete ejilola kubanda kundonde na kuchanya kundonde, na kwenio kabibaotwile kutama mangobu ga malili. ");
INSERT INTO nnq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Upepo nchokochoko gwa kubanda ngutumbu kuguguma, angweto bakita bapatangite chabapalanga, nyene ngababoya nanga, ngabaendecha meli papipi muno na kumbwani ja Kulete. ");
INSERT INTO nnq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nambu kipetitije kingobu, upepo nkolongwa ogukemigwa “Upepo gwa Kuchanya” ngutumbwa kuguguma kuboka kukichilu. ");
INSERT INTO nnq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Upepo nguputa melije, na kwa magambu tuotwije kujilongolea meli, ngutujileka jiutigwe na upepo. ");
INSERT INTO nnq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kichelu chimwe echikikemigwa Kauda ngikitukenga kachoko na upepogo, na apatapeta kubanda kwakwe ngutuotola iganukube kwa kulaga muno kubeka gwicho ntumbwi gwa mumeli. ");
INSERT INTO nnq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Angweto ngubuuta ntumbwi nkati, penia ngabajitindikia meli lugoji na kujitaba kwa makakala. Bajogopa kutenda kabi bakwamite umbwega ja baali, kumbwani ja Libia. Kwa nyenie ngabauluyanga matanga na kujileka meli jiutigwe na upepo. ");
INSERT INTO nnq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Upepo nkolongwa gujendekea kuguguma na malabo jakwe ngabatumbu kulekela panja miigo ja meli. ");
INSERT INTO nnq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lichoba lya tatu, ngabatumbwa uyo kulekela mumache ilebe yumumeli kwa maboko gabe bene. ");
INSERT INTO nnq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa machoba majingi tuotwije kulibona lichoba wala ndondwa, upepo ngolongwa ngujendekea kuguguma muno, ata kuhyobalela kwito kwa komboligwa ngagapela. ");
INSERT INTO nnq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kubokapa kutama kingobu kijingi pangalye chakulya, Paulo ngajema panakati jabe, ngalenga, “Akangwana, ikabimbaya anda makambenekie na kotoka mwanja kuboka Kulete. Anda makatei nyene kabitujepite upepo nkolongwa kabi tupatitije asala jenje joa. ");
INSERT INTO nnq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nambu ngoe nannyopanga mme na mojo, abije ata jumwe katijito ojwapakuoya bwomi gwakwe, meli tu nga ejipakuoba. ");
INSERT INTO nnq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Magambu lichana kilo mpakachi jwa Nnoongo kuboka kumbengu jwenio nenga nga bakwe na jwombe ne nanng'ongalela ngambitila, ");
INSERT INTO nnq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","nganengela, ‘Paulo, makajogopaje! Nga mpaka nnyeme nnongi ja Nngwana nkolongwa jwa Loma. Gwambone gwa Nnoongo, ampile bandu boa ababi mumwanja pamwe na mwenga.’ ");
INSERT INTO nnq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nyenie, akangwana, nnimbange mojo! Magambu nanhwamini Nnoongo kutenda iba tela anda apabanengila. ");
INSERT INTO nnq_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nambu nga mpaka matulekeligwa umbwega ja kichilu chimwe.” ");
INSERT INTO nnq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kilo chi lichoba lya komi na ncheche, takiba takautigwa kongo na kongo mu baali ja Adulia. Papipi na kilo puwiku akakamwa maengo bumeli ngabapemelela kube papipi na kujomo. ");
INSERT INTO nnq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Nyene bapalanga kipemo cha baali kwa kuuluya lugoji olukiba lutabigwe na kilebe kitopeu, ngabapala kipemo cha meta makomi ncheche. Uyo ngabapema kabele ngabapata meta makomi matatu. ");
INSERT INTO nnq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kwa magambu ga kujogopa ukolimwa mumaganga, ngabauluyanga nanga ncheche unyuma ja meli, ngabajopa kuche chokwe. ");
INSERT INTO nnq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Akakamwa maengo bu mumeli bapala kutoloka na bakiba bauluinge ntumbwigo mumache, bakakikopakea kutenda bajenda kuuluya nanga nnongi ja meli. ");
INSERT INTO nnq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nambu Paulo ngannengela nkolongwa jwa manjolinjoli na akalenda bakwe, “Anda akakamwa maengo aba kuigaje nkati ja meli, nkomboligwaje.” ");
INSERT INTO nnq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Penia manjolinjoli gala ngagaeketa ngoji eibakiba batabali ntumbwi ngubuleka ujabule na mache. ");
INSERT INTO nnq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Papipi nu kuche, Paulo ngabapembela boa balyegange chakulya, “Kwa machoba komi na ncheche ngoe nnilingitije kilebe. ");
INSERT INTO nnq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kuyenie, chonde nannyopanga nniagange chakulya kwa magambu mikipalanga ibe nhwotolange kulama. Magambu ata lunywili lumwe lwa mitwe jinu luobaje.” ");
INSERT INTO nnq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kubokapa kulenga yene, Paulo ngatola nkate, ngannumba Nnoongo nnongi jabe boa, ngaumetula, ngatumbu kulye. ");
INSERT INTO nnq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Penia boa ngababe na mwojo, nangweto uyo ngabalye chakulya. ");
INSERT INTO nnq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tuboa takiba bandu makomi komi mabele na makomi saba na sita mu meli. ");
INSERT INTO nnq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kila mundu pajukuta chakulya, ngabapunguya kutopa kwa meli kwa kulekela ilyo mubaali. ");
INSERT INTO nnq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Pukuchaga, akakamwa maengo ba mumeli baotwije kukimanya kilambo chache, nambu ngabapabona paali pina nhwangi, ngabaamua kujijemeka kubeka nanga kweno anda iwechekine. ");
INSERT INTO nnq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nyenie ngaeketa nanga na kuileka mubaali, na mangobu ugogo ngabakulugula ngoji eikiba batabalile nchukani, penia ngababeke nanga jimwe nnongi ukamula upepo, ngabajenda kumbwani kola. ");
INSERT INTO nnq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nambu ngabaika paali pa ngongano ibena ja baali na meli ngijikwama. Nnongi kwakiba kujingi pae piminhyangi nukuinainaje. Kunyuma ja meli ngijitumbu kueketeka ipandi pandi ku kuputigwa na mawimbi gina makakala. ");
INSERT INTO nnq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Akalenda bapalanga kakoma akapungwa boa ku kujogopa kube kabibaotwile kuogela mpaka kwie na kutoloka. ");
INSERT INTO nnq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nambu kwa nyenie kilongoi jwa manjolinjoli apala kunkombola Paulo, ngabaibila bakatendanga yaneje. Ngaamulicha abamanyi kuogela batumbu kuomba kuboka mumeli na kuogela mpaka kwie, ");
INSERT INTO nnq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","na bange bakengame bakakamulila mbao andaje mu ipandi ya meli ejieketike. Nga twenga tuboa aputuika tela kwie. ");
INSERT INTO nnq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Aputuika kujomo tengela, ngutumanya kutenda kichelu che kikemigwa Malita. ");
INSERT INTO nnq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bandu ba penia bakiba maganja muno na twenga. Ula jakiba jakatumbula koma na bakiba na malili, kuyenie ngabakoya mwoto, ngubutupokela. ");
INSERT INTO nnq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo ngalokota nhwigo nchokochoko gwa anju na ngakolake pamwoto. Penia, magambu ga mwoto, lijoka ngilipita muanju mola ngilinnyengelela Paulo mukuboko. ");
INSERT INTO nnq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bandu ba penia apabilibona lijoka linyengali mukuboko jakwe ngabalengelana, “Pangaje mundu ojo nkomi, iganukube akombwike mubaali, haki jannekaje ajendeke kulama.” ");
INSERT INTO nnq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nambu Paulo ngalimichila lijoka lyenie pamwoto na apotekigwije ati kachoko. ");
INSERT INTO nnq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bandu bala ngabalolela jwenio atupe andaje kingobucho kabi agwile pae nu kuwe. Kuboka pa kulendela kwa kingobu muno panga lola kutenda Paulo champatite kile chochoa chela changa pemelela, ngabaailicha mawacho gabe ngabalenga, “Jwenio nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Papipi na penia pakiba na nng'onda gwa Pubulio, nkolongwa jwa kichilu chela. Pubulio ngatupokela kwambone, kwa machoba matatu takiba takageni mundu. ");
INSERT INTO nnq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Awamundu Pubulio bakiba pikindanda, atamwe, bakweti mbenduka nu kualicha. Paulo ngajenda muchumbi chabe, nganng'ongalela Nnoongo, ngabeka maboko gakwe panani jabe, ngannamia. ");
INSERT INTO nnq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kingobu apagapitila genia, bandu akatamwe bange boa ba kichilu chenie ngabaika ngabalamiigwa. ");
INSERT INTO nnq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bandu ngubutupe hupo ndu na kingobu pututumbula kabena mwanja, ngababeka nkati ja meli machulupu agatagapaile. ");
INSERT INTO nnq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kuboka pa myei mitatu ngututumbwa kabe mwanja gwito kwa meli jimwe ja kilambo echikikemigwa Alekizandalia ejikemigwa, “Milongo Mabela.” Meli jenie jakiba jijemite pikichilu kingobu cha malili choa. ");
INSERT INTO nnq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ngutuika pikilambo cha Silakusa, ngututama penia kwa machoba matatu. ");
INSERT INTO nnq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kuboka kwenio ngutujenda ngututindila ngutuika kilambo cha Legio. Lichoba elikengima upepo ngutumbu kuguguma kuboka kubanda, na machoba mabele agakengama ngutuika kubandali ja Potioli. ");
INSERT INTO nnq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kwenio ngatakolela abaamine bange benia ngubutujopa tutame na angweto kwa machoba saba. Na ngutuika ku Loma. ");
INSERT INTO nnq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Abaamine buku Loma apabajoa minhalo jito, ngabaika kutupokela kuchoko ja Apio na Mikahawa Mitatu. Paulo apababona ngannumba Nnoongo, ngabe na makakala. ");
INSERT INTO nnq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Aputuika ku Loma, Paulo ngajeketiligwa atame jika jakwe pamwe na linjolinjoli limwe lya kunnenda. ");
INSERT INTO nnq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kuboka pa machoba matatu, Paulo ngabakema pamwe akiilongoi ba Akayahudi ba paali penia. Apabakongana, Paulo ngabalengela, “Makalongo Makasilaeli, nenga, ng'anukube ndeije chachoa kibaja wala kutauka lukobo lya akinahota bito, ngambukaligwa okwo Kuyelusalemu na ngambukaligwa na bandu ba Loma. ");
INSERT INTO nnq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Apabangonya nu kulola kutenda nakibaje ni lilemwa, ngabapala kuneka. ");
INSERT INTO nnq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nambu Akayahudi bange ngabakana kile chenie, nane ngambaligwa kujopa tengela kwa Angwana akolongwa ba Loma, iganukube nakibaje na kilebe chochoa cha katakiana bandu akajango. ");
INSERT INTO nnq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kwa magambu genia nnyopite kongana nu kulongela na mangweto. Ndabigwe mitondolo jenje gambu gwa kilebe echibahyobalela bandu Kuisilaeli.” ");
INSERT INTO nnq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Angweto ngabannengela, “Twenga tupokije balua jajoa jela kuboka ku Yudea, wala nnongo gwito ojwaike pamba kulenga minhalo jenie andaje kile chochoa kibaja nhwalo gwinu mwenga. ");
INSERT INTO nnq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nambu ipaligwa kunnyoa mmene manhwacho ginu, magambu tumanyi kutenda kila paali bandu batenda kutauka kunhwalo gwa kikuta chenie echimmi mwenga.” ");
INSERT INTO nnq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Penia ngabapangania na Paulo lichoba elibapakongana, na bandu ajingi ngabaika kwenio okwakiba akatama. Kuboke kindabi mpaka kimuyo Paulo ngabalandulila na nhwalo gwa kingwana cha Nnoongo na akajiga bajeketele nhwalo gwa Yesu kupete Malagilo ga Musa na majandiko ga akalondoli ba Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bange kati jabe ngabajeketela malobe gakwe, nambu bange baaminingije. ");
INSERT INTO nnq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kuyenie ngabaleka, ngukube na kupwilikana na mumawacho kati jabe. Apabakiba bakajabula, Paulo ngalenga, “Kweli nga tela Uhuke jwa Chwapi agalongela kupete nnondoli Isaya kwa akahoka binu! ");
INSERT INTO nnq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Gambu alenga, ‘Nnyende kwa bandu bamba makalengele, Kupenakia mampenakia, nambu mmanyaje, kulola mannola, nambu mibonaje, ");
INSERT INTO nnq_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","magambu malango ga bandu bamba gatekupunganikwa, baibangite machikilo gabe nu kuchwili mio gabe. Na yeneje, kabi baloi kwa mio gabe, kabi bajoine kwa machikilo gabe, kabi bamanyi kwa malango gabe, nu kung'alambuki, alenga Nnoongo, nane kabi nalamiinge.’ ” ");
INSERT INTO nnq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Penia Paulo ngalenga, “Mmanyange kube, lilobe lya Nnoongo nhwalo gwa ukomboligwa upelekigwe kwa bandu banga Akayahudi. Angweto mabupenakia!” ");
INSERT INTO nnq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulo apajomola kulonge genia, Akayahudi ngababoka kongo bakataukana muno bene akangweto. ");
INSERT INTO nnq_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kukingobu cha yaka ibena Paulo ngabe akatama munyumba ejajaika mwene, ngabe akapokela bandu boa abakiba bakaika kunnola. ");
INSERT INTO nnq_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Akiba akatangacha nhwalo gwa kingwana cha Nnoongo nukubola nhwalo gwa Angwana ana Yesu Kilisto panga jogopa na kwa agabwa.");
INSERT INTO nnq_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nenga Napaulo andika balua jenje, napakachi jwa Yesu Kilisto, nandundame nambambuligwe nukemigwa kutangacha Nhwalo Gwambone gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Kutumbu lolo, Nnoongo akalagi Nhwalo Gwambone kupete akalondoli bakwe andi piandikigwe Mumajandiko Gachwapi. ");
INSERT INTO nnq_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Nhwalo gongo ulenga Mwana jwa Nnoongo, Nngwana jwito Yesu Kilisto, jwenio umundu gwakwe, akiba kibelei cha Daudi, ");
INSERT INTO nnq_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","nhwalo gongo gunnenga Yesu Kilisto Nngwana jwito, ku nhwalo gu Uchwapi gwakwe guki Nnoongo ngalaigwa kuwecho nkolongwa kukuyoigwa kwakwe. ");
INSERT INTO nnq_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kupete kwa lina lya jwenio twenga tupatite upeele gukube tandundame, kupala kundela jakwe talongoleye bandu ba makabila goa bajali kupete imani. ");
INSERT INTO nnq_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mangweto uyo kati ja bandu benia, nkemigwe na Nnoongo mme mabandu ba Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nunhwandikilanga mmoa mammi ku Loma mampaligwa na Nnoongo, ngankemigwa mmegange bandu bakwe ba Chwapi. Awabito ana Nnoongo na Angwana bito ana Yesu Kilisto bampegange upeele na tengela. ");
INSERT INTO nnq_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kukutumbula, nannumba Nnoongo jwango kupete Yesu Kilisto kwa magambu ginu mmoa, magambu imani jinu jijoanika padunia joa. ");
INSERT INTO nnq_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nnoongo nga nchaili jwango echinenga nga kweli, Nnoongo ojunammegelela kwa mwojo gwango gwoa kutangacha Nhwalo Gwambone gwa Mwana jwakwe. Nnoongo amanyi kube mbinkombokelanga, ");
INSERT INTO nnq_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","kingobu choa pang'ongalela. Ngoe nannyopa Nnoongo andapaile, nantyangilange. ");
INSERT INTO nnq_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kwa magambu ndekumpalanga muno kummonanga kupala nammaganakie hupo iboke mukihuke nu kunnimbia mwojo. ");
INSERT INTO nnq_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mana gakwe, yene, kukuamini kwango ne kupakunnimbia mangweto, kuamini kwinu mangweto kupakunimbia nenga. ");
INSERT INTO nnq_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Akalongo bango, mbala mmanye kube pajingi nakapala kuntyangilanga, nambu ikiba ilebe ijingi einhibila kuwika kwinu. Napaile bandu bummanye Yesu kati jinu mangweto andi pikiba kwa bandu banga Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mbaligwa kajendelela bandu boa, Akagiliki na banga Akagiliki, bina kumanya na banga manya. ");
INSERT INTO nnq_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kuyenie mbala kutangacha Nhwalo Gwambone uyo kwinu mangweto mammi kwenio Kuloma. ");
INSERT INTO nnq_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ne kulolaje oni kutangacha Nhwalo Gwambone, gwenio nga makakala ga Nnoongo ogugwakombola boa abaamini, kutumbu Akayahudi na bandu banga Akayahudi uyo. ");
INSERT INTO nnq_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwa magambu Nhwalo Gwambone ulaya kipola kube Nnoongo andi pabatenda bandu kube bambone, nhwalo gwenio utendigwa ku imani, kuboka pukutumbula mpaka kupela, Majandiko Gachwapi galenga, “Mundu ojwabekigwe jwambone kuimani malama.” ");
INSERT INTO nnq_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Lilaka lya Nnoongo lilengigwe kuboka kumbengu kati ja malemwa na ubaja gwoa gwa bandu gwenio kwa ndela yabe mbaja abakana ukweli gwaka manyikanaje. ");
INSERT INTO nnq_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nnoongo bahukumu angweto, magambu ilebe yoa kumanyikana ku nhwalo gwa Nnoongo ibi kipola kwabe, magambu mweni Nnoongo abekite yenie. ");
INSERT INTO nnq_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kutumbu Nnoongo papangania dunia kuwecho gwakwe, nu Unnongo gwakwe gwa machoba goa, iganukube ibikubonekanaje kwa mio, imanyikine kipola. Bandu baotwile kumanya ilebe yenie kuboke ni ilebe eyapanganie Nnoongo. Kwa yenie bakwetije ndela jajoa ja kukikola! ");
INSERT INTO nnq_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Iganukube bamanyi Nnoongo abile, nambu babikumpeje ichima ejipaligwa, kabe nukunnumbaje. Gambu mawacho gabe gabi nikilebije na malango gabe gabi nikilebije, gatweli lubendu. ");
INSERT INTO nnq_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bikitenda kube bina malango, kumbe banga malango. ");
INSERT INTO nnq_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ngabagalambuya kibumo cha Nnoongo ojwalama machoba goa pangapela, nambu bigongalela inyago yukubacha eilandine na mundu jwawe, andaje ijuni andaje inyama andaje ikoko. ");
INSERT INTO nnq_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Kuyenie, Nnoongo ngabaleka batende ilebe yanga mbone ibi mumyojo jabe na kutendelana ilebe ya oni mumibele jabe bene akangweto. ");
INSERT INTO nnq_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bagalambuya kweli ja Nnoongo kube uwangi, bigongalela nu kuibegelela ilebe yapangine mweni Nnoongo, kunneka mwene jwapanginiage, jwapaligwa kulumbigwa pangapela! Unhyo. ");
INSERT INTO nnq_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Yene Nnoongo balekite bakengame tama mbaja. Akikege bagalambwike nu kotoka kapalanga akinalome nu kujingililana bene akangweto. ");
INSERT INTO nnq_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Na akinalome uyo, ngabakotoka kutenda ile yikibelekwa kwa akikege na ngabajingililana angweto kwa angweto. Akinalome ngabatenda ilebe ya oni kwajabe, kwa yene ngabapatanga hukumu jabe ejipaligwa tela na itendwa yabe ibaja. ");
INSERT INTO nnq_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Magambu bandu bakatekana kummanya Nnoongo, Nnoongo ngabaleka mumawacho gabe mabaja, ngabatenda ganga paligwa kutenda. ");
INSERT INTO nnq_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Batwelelinge ubaja na tama ju kupala kube ni ilebe nduu na chojo na kuponja. Batwelelinge bwiu na ukoma na bulwa na uwangi na mawacho mabaja. Kung'ing'ia, ");
INSERT INTO nnq_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","nu ukopekeana, nga bandu abanchimwa Nnoongo, michwembo, bina lunjonjo na kulokaloka, nukujogopaje kutenda ilebe ibaja, kajeketeje achikibelei babe, ");
INSERT INTO nnq_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","kuotwaje kumanya nu kulengenekia malagano gabe, bambonije na kiaje kwa akajabe. ");
INSERT INTO nnq_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bamanyi kube Malagilo gambone ga Nnoongo galenga kube bandu abatamanga yene, bapaligwa kuwe. Na genia ngiti batendanga bene akangweto tuje, nakabe balumbalila bange abatendanga andi genia. ");
INSERT INTO nnq_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yene, maganja, anda mahukumula bange panga paligwa, nhwotoje kukikola, ata makabi mwe mabeneke. Magambu, kwa kahukumu bange, mikihukumula mmene magambu mmene ntenda ilebe andi uyo yamahukumu bange. ");
INSERT INTO nnq_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ngoe tumanyi kube hukumu ja Nnoongo nga ja haki kwa abatenda ilebe andi yenie. ");
INSERT INTO nnq_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nambu mwe maganja mamahukumula abatenda ilebe andi yenie na mwenga uyo ntenda, bo, nkita mamijijepa hukumu ja Nnoongo? ");
INSERT INTO nnq_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Andaje mubembula gwambone gwa Nnoongo, kuimbalila kwakwe muno, pangamanya kube gwambone gwakwe gwenio upala kunnongalea nnape? ");
INSERT INTO nnq_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nambu nkweti mojo gumitau nu kujundupa na nyenie mikibeke hukumu kwa lichoba lyenie lya lilaka lya Nnoongo na hukumu jinu ja kweli ejipakubonekana. ");
INSERT INTO nnq_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Lichoba lyenie Nnoongo mannepa kila mundu kuboke kuitendwa yateile. ");
INSERT INTO nnq_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Abaimbalila nu kujendeke kutenda gambone kukupalapala kibumo ni ichima na bwomi gwa machoba goa pangapela, Nnoongo mabapa bwomi gwa machoba goa pangapela, ");
INSERT INTO nnq_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nambu abapala ilebe yabe bene bijikana kweli nu kupala kengama itendwa ibaja, lipakagwele lilaka lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kulaga na kubinia kupakumpata mundu jwajoa ojwatenda ubaja. Kupakapata Akayahudi oti, uyo na bandu banga Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Nambu Nnoongo mabapa kibumo, ichima na tengela abatenda gambone, Akayahudi oti uyo na bandu banga Akayahudi. ");
INSERT INTO nnq_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Magambu Nnoongo bahukumu bandu boa telatela. ");
INSERT INTO nnq_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Baba abatenda ubaja panga gamanya Malagilo ga Musa mabawaganga iganukube bagamanyije Malagilo. Na baba abakamu ubaja kongo magamanyi Malagilo mabahukumigwa kwa Malagilo. ");
INSERT INTO nnq_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ngiti abajoa Malagilo nga ababi bamboneje nnongi ja Nnoongo, nambu abaagabala Malagilo. ");
INSERT INTO nnq_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Bandu banga Akayahudi bakwetije Malagilo ga Musa, nambu kila apabatenda agabi Malagilo ga Musa genia umwojo jabe, benia angweto babaganga kipemo cha Malagilo iganukube bagamanyije Malagilo ga Musa. ");
INSERT INTO nnq_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Itendwa yabe ilaya kube pagapala Malagilo gaandikigwe mu myojo jabe. Myojo jabe jilaya kile chenie nga kweli, chengi kingobu mawacho gabe katakiana na chengi kingobu kakola. ");
INSERT INTO nnq_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Yenie, kuboke Munhwalo gwa Mbone gongo ogundangacha, nga apipakube mangobu Nnoongo apapakuhukumu ilebe ya bandu eikiite, kwa ndela ja Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Na mwe, bo? Mmene mikikema Mayahudi, magahyobalela Malagilo ga Musa na kulokaloka kube ba Nnoongo, ");
INSERT INTO nnq_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kwa ndela ja Malagilo mmanyi apapala Nnoongo na nhwotwile kupambula kilebe chambone, ");
INSERT INTO nnq_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","mwenga mikibona kube makilongoi ba bangalola na lumuli ku bandu ababi mulubendu, ");
INSERT INTO nnq_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","mikibona kube maboli ba mandokoma na maboli bi kingota, nkweti malango mu Malagilo nu umanyi gwa kweli. ");
INSERT INTO nnq_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Bai mwenga mabolanga bange, mboni mmene mmi kukibolaje? Matangachila bange bakajibaje, nambu mmene mboni nnyiba? ");
INSERT INTO nnq_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Mwenga nnenga, “Makatenda ngongolaje,” na kongo mmene ntenda ngongola? Mwenga mijichimwa milongo ji inyago na kongo mmene nnyiba muiteba yabe? ");
INSERT INTO nnq_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ku kulenga eti nkweti Malagilo ga Nnoongo, bo nnolaje kube kukualabiya Malagilo mammembu Nnoongo? ");
INSERT INTO nnq_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Majandiko Gachwapi galenga, “Magambu ginu Makayahudi, bandu banga Akayahudi bilitukana liina lya Nnoongo!” ");
INSERT INTO nnq_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Anda mmi kagaagabala Malagilo ga Musa, kuinigwa kwinu kupakube kwambone, nambu anda mmi kagaagabaje Malagilo mbaya makainigwije. ");
INSERT INTO nnq_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Anda mundu jwanga Nhyahudi jwangainigwa ojwaagabala Malagilo ga Musa, bo Nnoongo ammalangije kube ainigwe? ");
INSERT INTO nnq_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Bandu banga Akayahudi bapakunhukumula panga paligwa mwenga Mayahudi anda nhwalabiye Malagilo, iganukube nkweti majandiko ga Malagilo na nhwinigwe na angweto bagajeketela Malagilo iganukube bainigweje. ");
INSERT INTO nnq_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ngiti, kila mundu ojwabonekana kunja Nhyahudi nga Nhyahudi jwa kweli na wala mundu kubeje Nhyahudi jwa kweli eti mpaka ainigwe. ");
INSERT INTO nnq_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nhyahudi jwa kweli nga jwajo ojwabi Nhyahudi mpaka mmojo, nga ojwainigwe umwojo. Gongo ngu nhwalo gu Uhuke, ngiti nhwalo gwa majandiko ga Malagiloje. Mundu andi jwenio apatachipa, ngiti kuboka kwa banduje, nambu kuboka ku Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Nhyahudi akweti nike chakapeta bandu banga Akayahudi? Andaje kibi chambone kuboke mukuinigwa? ");
INSERT INTO nnq_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Elo, kibile chambone kuingono yoa. Pukutumbu, Nnoongo ngabapeganga Akayahudi Lilobe lyakwe. ");
INSERT INTO nnq_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Nambu ibabole anda bange bandu bakiba bangaaminika? Bo, kile chenie kibakuboya kuaminika kwa Nnoongo? ");
INSERT INTO nnq_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Napachokuje! Nnoongo nga jwa kweli machoba goa, iganukube kila mundu abi nuwangi. Andi Majandiko Gachwapi pagalenga ku nhwalo gwa Nnoongo, “Anda malobe ginu gabi gambone pamme nulukumbi mwenga kuotola.” ");
INSERT INTO nnq_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nambu, anda ubaja gwito ulaya Nnoongo atenda pipaligwa, tulenga nike? Bo, tulenga atenda telatelaje patuhukumula? Pamba nonge kimundu. ");
INSERT INTO nnq_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Napachokuje! Ikabi yene, Nnoongo akaotolabo kujihukumu dunia? ");
INSERT INTO nnq_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Nambu anda ibi kundela ju uwangi gwango ukweli gwa Nnoongo ubonekana na jwombe abi ni kibumo muno, bai kwanike ndenda kuhukumigwa anda namundu bina malemwa? ");
INSERT INTO nnq_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Andaje tulenga, tukamwa mabaja ibe tupate gambone! Yenie bange nga apabututukana kukututakiana kube tubolite yenie. Mabahukumigwa panga paligwa! ");
INSERT INTO nnq_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tulenga nike? Bo, twenga Takayahudi tambone kapeta bange? Napachokuje! Kwa magambu nengite pukutumbula kube Akayahudi na bandu banga Akayahudi boa batei mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Anda Majandiko Gachwapi pagalenga, “Abije na jumwije ojwabi jwambone, ");
INSERT INTO nnq_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","abije mundu junamalango, wala ojwampalapala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Boa bannekite Nnoongo, boa babi andi batekubola, abije ojwatenda gambone, najumweje. ");
INSERT INTO nnq_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Kano yabe anda makabuli gangaelekea, nimi yabe itweli uangi, ng'omo yabe gapita malobe gina uchungu andi gwa lijoka, ");
INSERT INTO nnq_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","kano yabe itweli minhilo jikubinia. ");
INSERT INTO nnq_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Angweto kutenda chokwe ukoma, ");
INSERT INTO nnq_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","kila pabajenda kwipulana nu kupoteka. ");
INSERT INTO nnq_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Angweto bijimanyije ndela ja tengela, ");
INSERT INTO nnq_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","kunnyogopa ngu Nnoongo.” ");
INSERT INTO nnq_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tumanyi kube Malagilo ga Musa gapalanga ababi Mumalagilo genia, kuyenie kolaje chukopakea, ilambo yoa ibi muhukumu ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Gambu abije mundu jwambone nnongi ja Nnoongo kukutenda pagapala Malagilo ga Nnoongo, liengo lya Malagilo kunnaya tu mundu kube atei mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nambu ngoe, ndela ja Nnoongo ja katenda bandu kube bambone nnongi jakwe jiekuligwe, kabe panga hyobalela Malagilo. Malagilo ga Musa na Majandiko ga akalondoli bachalakicha kilebe chenie. ");
INSERT INTO nnq_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nnoongo batenda bandu babonekane kube bambone nnongi jakwe kwa ndela ja kunhwamini Yesu Kilisto. Nnoongo atenda genia ku bandu boa abaamini. Magambu kubije kubagulana kwakwoa, ");
INSERT INTO nnq_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","bandu boa balemwite na babi kutaali na kibumo cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nambu mu upeele gwa hupo ya Nnoongo, bandu boa batendigwa kube bambone kupete Yesu Kilisto ojwababeka bandu babe agabwa. ");
INSERT INTO nnq_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Nnoongo ngampanga Yesu, kupala kwa myai jakwe, abe ndela ja kabokea bandu mabaja kukuamini kwabe. Atenda genia kupala alaye gapala Nnoongo. Lolo Nnoongo atela kuimbalila mabaja ga bandu panga hukumula, ");
INSERT INTO nnq_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","atenda yene kupala kulaya gwambone gwakwe ku bandu kingobu chenje jwenio nga ojwabi jwambone na kabeka bandu abunhwamini Yesu babonekane kube bambone nnongi ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Tukilumbalila nike? Kibije! Kwa nike? Bo, kwa magambu ga kulenganakia Malagilo ga Nnoongo? Ije! Nambu kwa magambu tunhwamini Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Gambu Nnoongo antenda mundu kube jwambone ki imani na ngiti kukulenganakia Malagiloje. ");
INSERT INTO nnq_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Andaje bo, Nnoongo nga Nnoongo jwa Akayahudi tu, andaje uyo jwa bandu banga Akayahudi? Elo, jwa bandu banga Akayahudi uyo. ");
INSERT INTO nnq_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Nnoongo nga jumwe, jwombe mababeka Akayahudi abainigwe kube bambone kuimani jabe na bandu banga Akayahudi banga inigwa uyo kuimani jabe. ");
INSERT INTO nnq_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Bo, tutumi imani kukuleke kutali Malagilo? Napachokuje, nambu tagajemeka Malagilo. ");
INSERT INTO nnq_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tulenga nike nhwalo gwa aokabito ana Ulaimu? Ilebe nike eibapitile mummele? ");
INSERT INTO nnq_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Anda Ulaimu akabekigwa kube jwambone nnongi ja Nnoongo, kuilebe yateile, akweti kilebe chukulokeloke, ngiti nnongi ja Nnoongoje. ");
INSERT INTO nnq_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Majandiko Gachwapi galenga, “Ulaimu nganhwamini Nnoongo, kukutenda yenie Nnoongo ngammona kube jwambone nnongi jakwe.” ");
INSERT INTO nnq_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Boa abakamu maengo kulepigwa nchaala, nchaala gwenio ngiti hupoje, nambu chabapaligwa kupata. ");
INSERT INTO nnq_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nambu bandu bangahyobalela itendwa yabe, nambu bunhwamini Nnoongo ojwabalekekea akabaja, penia Nnoongo kuliagabala lihyobalelo lya bandu benia na kabona kube bambone nnongi jakwe. ");
INSERT INTO nnq_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Anda Daudi palenga mbaya jakwe mundu ojwabonekana jwambone nnongi ja Nnoongo, pangalolakea itendwa yakwe, ");
INSERT INTO nnq_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Mbaya baba abalekekeigwe malemwa gabe, bombe mabaja gabe gaboigwe. ");
INSERT INTO nnq_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mbaya mundu jwajo Angwana bagabalangaje mabaja gakwe.” ");
INSERT INTO nnq_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Bo, mbaya jenie jalenga Daudi kwa bandu abainigwe tu? Ije! Andaje pamwe na bandu bangainigwa. Magambu tulengite kutenda, “Ulaimu nganhwamini Nnoongo, gambu gwa kuamini kwakwe Nnoongo ngammona kube jwambone nnongi jakwe.” ");
INSERT INTO nnq_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Genia gatendigwa kingobu gani, tango Ulaimu nukuinigwaje? Andaje itendigwa kuboka pa kuinigwa? Tango nukuinigwaje, ngiti kuboka pa kuinigwaje. ");
INSERT INTO nnq_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ulaimu ngajeketela kiingi chu kuinigwa kulaya kutenda ajekataligwe kube jwambone nnongi ja Nnoongo, gambu gu kuhyobalela kwakwe tango nu kuinigwaje. Kwa nyenie, Ulaimu nga awawa ba boa abaamine nu kubekigwa kube bambone nnongi ja Nnoongo gambu gukuamini kwabe iganukube bainigweje. ");
INSERT INTO nnq_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ulaimu uyo aokabito ba boa abainigwe, nambu ngiti magambu gukuinigwa kwabije, nambu kwa magambu gukengama ndela ujaje ja imani ja aokabito ana Ulaimu ejibakengama tango nu kuinigwaje. ");
INSERT INTO nnq_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Nnoongo ngalagana na Ulaimu ni ibelei yakwe kube dunia majiba jabe. Nnoongo atela yene ngiti kwa magambu Ulaimu akaagabala Malagilo ga Musaje, nambu magambu gukunhwamini Nnoongo ngammeka kube jwambone nnongi jakwe. ");
INSERT INTO nnq_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Andaibi lilagano lya Nnoongo libi kwa baba tu ababagakengama Malagilo ga Musa, imani jiba jambonije, uyo lilagano lya Nnoongo liba kile chamboneje. ");
INSERT INTO nnq_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Malagilo ga Musa galeta lilaka lya Nnoongo, nambu pangabe Malagilo, kubeje kualabia Malagilo. ");
INSERT INTO nnq_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Nayene lilagilo likiba muimani, kupala lilagilo lyenie libe, lilame nukujendekea andi hupo kuboka ku Nnoongo kwa boa ababi kukibelei cha Ulaimu, ngiti kwa abahyobale Malagilo ga Musa tuje, nambu uyo kwa abaamini andi patenda Ulaimu. Gambu Ulaimu nga awabito bu Uhuke tuboa, ");
INSERT INTO nnq_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","andi Majandiko Gachwapi pagalenga, “Nammekite mme mawawa ba makabila nduu.” Lilagano lyenie libi kweli nnongi ja Nnoongo nu Ulaimu nganhwamini Nnoongo. Jwenio nga Nnoongo jwabape bwomi bandu abawile, kwa amuli jakwe, ilebe yangabe ibe. ");
INSERT INTO nnq_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ulaimu ngaamini gangaoto kugahyobalela, nayenie, ngibe andi Majandiko Gachwapi galenga, “Awawa bi ilambo ijingi na kibelei chinu kiba nduu!” ");
INSERT INTO nnq_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ulaimu akiba okolo abandakila kube nayaka makomi komi, nambu kuamini kwakwe kupolitije iganukube amanyi kube mmeli gwakwe ukiba andi uwile, nu nhwanamundu Sala akiba ntonga. ");
INSERT INTO nnq_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ulaimu alipwelije lilagano lya Nnoongo, kuamini kwakwe ngukumpe makakala, ngampe kibumo Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Amanyi pe kutenda Nnoongo malenganakia lilagano lyakwe. ");
INSERT INTO nnq_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Nga mana Nnoongo ammona kube jwambone nnongi jakwe. ");
INSERT INTO nnq_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Pilengigwa, “Ngabalangigwa kube jwambone nnongi ja Nnoogo,” ilengigwa magambu gwa jwenio tuje. ");
INSERT INTO nnq_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Genia gaandikigwa pamwe na twenga uyo tatu jeketeligwe kube tambone tatunhwamini Nnoongo ojwanhyoite Yesu Nngwana jwito kuboka kwa abawile. ");
INSERT INTO nnq_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Magambu gwa mabaja gito Yesu ngabekigwa akomigwe, ngayoigwa kube mmomi kupala atubeke twe tambone nnongi ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Gambu tujeketeligwe kubekigwa tambone nnongi ja Nnoongo kuimani, tukweti tengela na Nnoongo kupete Nngwana gwito Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kuimani jito, jwenio atuletite tube mupeele gwa Nnoongo, ogututama nago ngoe. Tuala mwojo kulihyobalelo litukweti likube pamwe mukibumo cha Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Elo, ngiti genia tuje, nambu tualalila mukulaga kwito uyo, magambu tumanyi kutenda kulaga kuleta kuimbalila, ");
INSERT INTO nnq_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","nu kuimbalila kuleta kube mundu jwambone nu kulimba mwojo kuleta kuhyobalela. ");
INSERT INTO nnq_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Na lihyobalelo lyenie liwangije magambu Nnoongo ajeile lipalano lyakwe mumyojo jito ku ndela ja Uhuke jwa Chwapi, jwatupi twenga. ");
INSERT INTO nnq_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Putukiba tanga uwecho, kukingobu chapala Nnoongo Kilisto ngawe kupala atukombole mabaja gito. ");
INSERT INTO nnq_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kindemaje mundu kuwe magambu ga mundu jwambone, pangaje mundu aotwile kujiga kuwe magambu ga mundu jwambone. ");
INSERT INTO nnq_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nambu Nnoongo alaite kube abi kutupala, gambu putukiba tango tana mabaja, Kilisto ngawe kwa magambu gito. ");
INSERT INTO nnq_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Magambu tubekigwe kube tambone muno kwa myai ja Kilisto, ilaya kweli kube kukupete jwenio matukola kuboka mulilaka lya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Takiba takangondwa ba Nnoongo, atuchikachine kupete kiu cha Mwana jwakwe. Ngoe tubi takaganja ba Nnoongo, nga kipola muno kube matukomboligwa kwa bwomi gwa Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Genia tuje, nambu uyo tuala mwojo ku Nnoongo kwa ndela ja Nngwana jwito Yesu Kilisto ojwatuchikachine na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kupete mundu jumwe mabaja ngagajingila padunia na genia ngagaleta kiu. Nhyene kiu kijendekie mu bandu boa, kwa magambu boa batei mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Gambu tango nu kubeje Malagilo mabaja gakiba padunia, nambu mabaja kubalangigwaje kube mabaja panga Malagilo. ");
INSERT INTO nnq_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nambu kutumbu mangobu ga Adamu mpaka mangobu ga Musa, kiu ngikibe panani ja bandu boa, uyo ngikibe nu kubandu bangatenda mabaja tela na Adamu apakana amuli ja Nnoongo. Adamu andi kilandanikio cha Kilisto jwaika. ");
INSERT INTO nnq_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nambu ile ibele yenie ibi telaje, magambu gwa hupo ya tengela ya Nnoongo telaje na mabaja ga Adamu. Kweli kutenda bandu ajingi ngabawe magambu ga mabaja ga mundu jumwe. Nambu upeele gwa Nnoongo ubi nkolongwa muno, hupo yakwe yenie ya tengela kwa bandu ajingi kupete upeele gwa mundu jumwe, Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Hupo ya Nnoongo na mabaja ga mundu jumwe ibi telaje. Mana, kuboka pa lilemwa lya mundu jumwe, Nnoongo ngapanga hukumu, nambu kuboka pa malemwa ga bandu ajingi, Nnoongo ngabaupa upo yakwe kwa kalekekea. ");
INSERT INTO nnq_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kweli kwa mabaja ga mundu jumwe, kiu ngikitumbu kutawala kwa bandu magambu gwa mundu jumwe. Nambu chambone muno echatei mundu jwenio, Yesu Kilisto! Boa abapokela gwambone gwa Nnoongo na hupo yenie nu kutendigwa babonekane bambone nnongi ja Nnoongo, mabatawala mu bwomi kundela ja jwenio jumwe jwenio nga Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Andi yene lilemwa lya mundu jumwe lyahukumula bandu boa panga paligwa, uyo kupete kitendwa chambone cha mundu jumwe bandu boa mababekigwa kube bambone nnongi ja Nnoongo na bwomi. ");
INSERT INTO nnq_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Andi yene kwanga jali kwa mundu jumwe ngukwabeka bandu mumalemwa uyo kuagabala kwa mundu jumwe makabeka bandu ajingi bajeketeligwe nnongi ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Malagilo ga Musa, pagaika itendwa ibaja ngijonjeke kube ndu, nambu mabaja pagakiba ndu, upeele gwa Nnoongo ngube ndu muno. ");
INSERT INTO nnq_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Andi mabaja pagatawala kukuleta kiu, uyo gwambone gwa Nnoongo utawala kukuleta ilebe einhwalali Nnoongo nukuleta bwomi gwa machoba goa pangapela kupete Yesu Kilisto Nngwana gwito. ");
INSERT INTO nnq_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tulenga nike kabele? Tujendekeya kutenda mabaja kupala kindimba cha Nnoongo kijonjake kube ndu? ");
INSERT INTO nnq_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Napachokuje! Tukotwike kutawaligwa na mabaja, tujendekeabo kutama mumabaja? ");
INSERT INTO nnq_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Gambu mmanyi kube twenga tatubatichigwe kulondana na Yesu Kilisto, putubatichigwa ngutulondana na kiu chakwe. ");
INSERT INTO nnq_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Apatabatichigwa kututumbukia mumache ngutulondana na kiu chakwe, ngutuchikigwa pamwe najwenio, kupala andi Kilisto apayoigwe kuboka kwa abawile kukibumo cha makakala ga Awawa, twenga uyo matuba mubwomi nhyono. ");
INSERT INTO nnq_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Gambu andi putulondine nakwe mukuwe, uyo nga putupakulonda nakwe mukuyoka. ");
INSERT INTO nnq_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tumanyi kutenda bwomi gwito gwa kalakala uwile panchalaba pamwe na Kilisto, kupala makakala ga mabaja mumibele jito gaalabiigwe, kuyene takabeje kabe takabanda ba mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Gambu mundu jwajoa ojwawe abi agabwa na mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Andaibi tuwile pamwe na Kilisto, uyo tuamini kutenda matulama pamwe na jwenio. ");
INSERT INTO nnq_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Gambu tumanyi kube Kilisto ayokite, aweje kabele, kiu kintawalaje kabena. ");
INSERT INTO nnq_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Yene, magambu awile pakamwe tu, mabaja gakwetije makakala kujwenio, na ngoe atama kitamo chakwe mutawala gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Na mangweto uyo mikibalangila kube nhwile ku nhwalo gwa mabaja na ntamanga kukummegelela Nnoongo kupete Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Yene, mabaja gakajendekeje kutawala mibele jinu ejiwe, nu kujijeketela tama yakwe. ");
INSERT INTO nnq_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Na makaboyangaje ipagwa imibele jinu kube yombo yukutende mabaja. Mbaya mmeni mangweto mikibekange ku Nnoongo, andi bandu abayoigwe kuboke kwa abawile, mmekange mibele jinu joa kwa agapala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Magambu mabaja gantawalaje kabele, mangweto mmi kulongaleigwaje na Malagilo nambu nnongaleigwa na gwambone gwa Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Tulenga nike? Bo, tutendi mabaja magambu tubije Mumalagilo gambu tubi muupeele gwa Nnoongo? Ije napachokuje! ");
INSERT INTO nnq_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mmanyi kube anda mikibekangite mmene makangweto kube makabanda ba mundu mmaganga kweli makabanda ba mundu jwenio, andaje makabanda ba mabaja mmanya kipakumpata kiu, andaje akabanda abannyali Nnoongo mpakube mambone nnongi jakwe. ");
INSERT INTO nnq_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Nambu nannumba Nnoongo! Kagaagaba maboulo gamaboligwe kumyojo jinu joa, iganukube lolo makiba mabanda ba mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ngammekigwa agabwa kuboka mumabaja, na mmi makabanda bi ilebe yaipala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Pamba nonge kilonge chamachoba goa magambu gwa kulegaleka kwa mibele jinu. Andi kingobu chenge pamabekanga ipagwa inu itendi ilebe ichapu na mabaja ngamme makachapu, uyo ngoe mmekange ipagwa yinu itendi ilebe yapala Nnoongo mmegange chwapi. ");
INSERT INTO nnq_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Pamakiba mabanda ba mabaja makiba agabwa mukutenda ilebe yaipala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Makapatanga nyonjakea nike kuboke mukutendanga ilebe yae eintei mme na oni? Magambu ile yenie yoa kupela kwakwe kuwe! ");
INSERT INTO nnq_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Nambu ngoe mmekigwe agabwa kuboka mubanda gwa mabaja na mmi makapakachi ba Nnoongo. Nyonjakea jankweti ngoe chwapi, kubokapenia mpata bwomi gwa machoba goa pangapela. ");
INSERT INTO nnq_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwa magambu lipungu lya mabaja nga kiu, nambu hupo ejapanga Nnoongo nga bwomi gwa machoba goa pangapela kukulondana na Yesu Kilisto, Angwana bito. ");
INSERT INTO nnq_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Makalongo bango, mammanyanga agambakunnengela, gambu mmoa magamanyangite Malagilo. Malagilo gantawala mundu mangobu abi mmomi. ");
INSERT INTO nnq_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Magambu munkege ojwatoligwe na analome kila kingobu atabigwa na malagilo kingobu angwanamundu pababe bwomi, nambu angwanamundu pabajomoka malagilo genia gantabaje kabena munkege jwenio. ");
INSERT INTO nnq_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Yene munkege jwenio andatoline na analome bange nakongo angwanamundu babi amommi, akemigwa nngongola, nambu anda angwanamundu bajomwike, munkege jwenio aba agabwa mumalagilo na ata akatoline na analome bange, nngongolaje. ");
INSERT INTO nnq_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Yene nga apammilingite makalongo, mangweto uyo nhwilangite, mmi kutawaligwaje na Malagilo gambu mangwetomwe ngi ipagwa ya mmele gwa Kilisto, ngoe mmi bakwe ojwayoigwe kuboka kwa abawile yene tupaligwa kummegele Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Gambu apatakiba takatama kimmele tu, tama mbaja ngijikolakeigwa na malagilo, ubaja ngutenda maengo mummele gwito, nu tuboa ngutugwele mukiu. ");
INSERT INTO nnq_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Nambu ngoe tubi agabwa kuboka mumalagilo, tubokite mukilebe chache echikitubeka tube takabanda. Ngoe tubegelela kabeje na ndela ja lolo ja Malagilo ga Musa agaandikigwe nambu kwa ndela nhyono ja Uhuke. ");
INSERT INTO nnq_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Bo, tulenga, kube Malagilo ga Musa nga mabaja? Napachokuje! Nambu panga Malagilo, nenga kabi manyije kulokalela ilebe yabange nga nike, anda Malagilo gakalengitije, “Makalokaleje.” ");
INSERT INTO nnq_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kukube muamuli jenie, mabaja ngagapata ndela jukolakea mabaja ndu nkati jango. Panga malagilo malemwa kilebe chikiwe. ");
INSERT INTO nnq_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Pukutumbula nenga nakiba namomi kutaali na malagilo, nambu malagilo apagaika, mabaja ngagayoka, ");
INSERT INTO nnq_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","nenga nganhwe. Malagilo genia gakita galete bwomi, nambu kwango ganeti kiu. ");
INSERT INTO nnq_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Gambu, mabaja ngagapata ndela kuboka kwa malagilo, ngagangoloya ne nukungoma. ");
INSERT INTO nnq_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Malagilo gene gabi chwapi na amuli jene jibi chwapi, nga ejipaligwa na jambone. ");
INSERT INTO nnq_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Bo, ikonda kilebe echikibi chambone kijambuki kiu chango? Napachokuje! Apibile nga yene, mabaja gabonekane kipola kube mabaja, gapeti muchache chambone nu kunyambukia kiu chango. Yene mabaja kwa ndela ja malagilo ibonekana kipola kube mbaja muno. ");
INSERT INTO nnq_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tumanyi kube Malagilo gu uhuke, nambu nenga na bammele tu, nenga nhuchigwe kube nabanda ba mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nikimanyije chandenda, magambu chache chinikipala kutendaje, nambu chinikichimwa nga echindenda. ");
INSERT INTO nnq_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Andaibi, ndenda gangapala, ilaya kube nyekete kube malagilo nga gambone. ");
INSERT INTO nnq_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ibonekana kipola neje nandenda kilebe chenie, nambu mabaja agabi nkati jango. ");
INSERT INTO nnq_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Manyi kube ngwetije chambone nkati jango, mu umundu gwango. Kwa magambu, iganukube mbaile kutenda kilebe chambone, kuotoje kulilenganakia. ");
INSERT INTO nnq_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Pambala kutenda kilebe chambone kutendaje, nambu kilebe kibaja changakipala nga chandenda. ");
INSERT INTO nnq_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Anda ndenda gangapala, ilaya kube neje nandenda genia, nambu mabaja agabi nkati jango. ");
INSERT INTO nnq_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Bai ng'anyime lukobo londo, pambala kutenda kilebe chambone, ni kibaja kibi upo. ");
INSERT INTO nnq_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nkati mumwojo gwango nagapala Malagilo ga Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Nambu nola kube gabi malagilo gange agatenda maengo mummele gwango, malagilo gangachikachana na malango gango. Genia gameka mbe nabanda ba malagilo mabaja agatenda maengo mummele gwango. ");
INSERT INTO nnq_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Naocho nenga! Beneke abapakungola kuboka mummele gongo ogumbeleka kukiu? ");
INSERT INTO nnq_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Nannumba Nnoongo ojwatenda genia kwa ndela ja Nngwana jwito Yesu Kilisto! Malango gango gabegele Malagilo ga Nnoongo, nambu mmele gwango ubegele malagilo gubaja. ");
INSERT INTO nnq_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Yene, ngoe hukumu janga paligwa jibije kwa boa abalondine na Yesu Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Magambu, Malagilo gu Uhuke gwa Nnoongo agaleta bwomi ogubi mu Yesu Kilisto gangombwile kuboka mu malagilo mabaja na kiu. ");
INSERT INTO nnq_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nnoongo ngalenganakia kilebe changalenganakia Mumalagilo ga Musa, ngankinga Mwana jwakwe kiti abi na mmele tela na mmele gwito twenga tatubi na malemwa, kwa magambu ga mabaja na kwa mmele gwenio ngagahukumu mabaja. ");
INSERT INTO nnq_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Nnoongo atela genia kupala gaga agapaligwa Mumalagilo galenganile nkati jito, twenga tanga kengama tama ja ilebe ya mmele, nambu kwa makakala gu Uhuke. ");
INSERT INTO nnq_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Baba abatama kukengama pupala mmele, kulongaliigwa na mawacho ga mmele. Nambu abatama kukunkengama Uhuke jwa Chwapi mawacho gabe kulongalaigwe na gaga agapala Uhuke jwa Chwapi. ");
INSERT INTO nnq_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Mawacho ga mmele galeta kiu, nambu mawacho ga Uhuke galeta bwomi na tengela. ");
INSERT INTO nnq_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Gambu ojwatawaligwa na mawacho ga mmele jwenio nngondwa jwa Nnoongo, kujalije Malagilo ga Nnoongo na kuotwaje kugajali. ");
INSERT INTO nnq_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bandu abalongaleigwa na agapala mmele gwa mabaja kuotwaje kunhwalalila Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Nambu mangweto kulongaleigwaje nu pupala mmele gwa mabaja, nambu ntamanga kukengama papala Uhuke, anda ibi Uhuke jwa Nnoongo atama nkati jinu. Jwajwoa jwanga Uhuke jwa Kilisto, jwenio nga jwakuje Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nambu anda Kilisto abi nkati jinu, iganukube mibele jinu jiwile magambu ga mabaja, kwinu Uhuke nga bwomi kwa magambu gukutenda agapala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Anda abi Uhuke jwa Nnoongo ojwanhyoya Kilisto atama nkati jinu, jwenio jwanhyoite Yesu kuboka kwa abawile majipa bwomi mibele jinu ejiwile, matenda yene kupete Uhuke jwakwe ojwatama nkati jinu. ");
INSERT INTO nnq_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Yene, akalongo bango, tukweti liengo, ngiti likutama kukengama agapala mmele gwa mabaje. ");
INSERT INTO nnq_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Magambu anda ntamanga kukengama agapala mmele gwa mabaja mmanya mpala kuweganga. Nambu, anda kwa ndela ja Uhuke miikoma itendwa inu yangambone, mannamanga. ");
INSERT INTO nnq_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Boa abalongaleigwa na Uhuke jwa Nnoongo ngi ingota ya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Magambu, mpokelingije Uhuke jukummeka mangweto makabanda nu kummeka mbwele, nambu mpokilinge Uhuke jukummeka mangweto mme ingota ya Nnoongo, kwa Uhuke jwenio twe tunkema Nnoongo, “Aba,” ikonda, “Awawa!” ");
INSERT INTO nnq_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Na Uhuke jwa Nnoongo mwene achalakicha ni iuke ito kube twenga ngi ingota ya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Lele twenga anda tubi ingota ya Nnoongo, matupokela upeele gwoa Nnoongo ogubabekalinge bandu bakwe, matuba pamwe muulichi gwenio na Kilisto, magambu anda tukilondite mukupotekigwa kwakwe Kilisto, uyo matuba pamwe mukibumo chakwe. ");
INSERT INTO nnq_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nola kube kupotekigwa kwa kingobu chenje cha ngoe ngikilebe chambonije anda tulandanakie na kibumo chache chitupakupata twenga. ");
INSERT INTO nnq_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ipanganyigwe yoa ilende kwa chuuna muno kupala kulola Nnoongo apailaya kipola ingota yakwe. ");
INSERT INTO nnq_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwa mana, ipanganyigwe ibekigwe kube pangaotola, ngiti kukupala yenije, nambu ibekigwe yene kukupala mwene Nnoongo. Na yenie ibi ni lihyobalelo, ");
INSERT INTO nnq_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","magambu ipanganigwa yenie maikomboligwa kuboka mu ubanda gu ubou, iba agabwa mukibumo cha ingota ya Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Magambu, tumanyi mpaka ngoe, ipanganigwe yoa iguta kukubinia andi kubinia kwa kukikombola mwana. ");
INSERT INTO nnq_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Yenetuje, ipanganigwe na twenga tatubi na Uhuke jwenio, ojwabi hupo ikutumbula ya Nnoongo, twe uyo tuguta nkati jito, tulendela tubekigwe kube ingota ya Nnoongo na myojo jito jikomboligwe. ");
INSERT INTO nnq_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Magambu kukuhyobalela kwenio twe tukomboligwe. Nambu lihyobalelo kubeje lyambone andibi tupeta kukibona echituhyobalela. Gambu meneki ojwahyobalela chache chakibona? ");
INSERT INTO nnq_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Anda tukihyobale kilebe tango changakibona, tukilendela kukuimbalila. ");
INSERT INTO nnq_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Uyo, Uhuke abikutujangata mukulegeleka kwito. Magambu twe tumanyije apipaligwe kunnyopa Nnoongo, nambu Uhuke mwene atujopela ku Nnoongo kukulwala kwangalandulila. ");
INSERT INTO nnq_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Jwombe Nnoongo ojwalola mpaka nkati ja myojo ja bandu, amanyi mawacho ga Uhuke jwenio, Uhuke jwenio kajopela bandu ba Nnoongo akengama papala Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tumanyi kube, ilebe yoa ilenganile telatela, Nnoongo atenda maengo pamwe na abampala nakape gambone, yani abakemigwe kwa maengo gakwe. ");
INSERT INTO nnq_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Gambu benia Nnoongo bamanyi kuboka pukutumbula, nga abapambwile balandane na Mwana jwakwe, kupala Mwana abe nkolongwa kati ja akalongo ajingi. ");
INSERT INTO nnq_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Bai baba Nnoongo abapambwile nga benia abakemite na benia abakemite nga abatei kube ingota yakwe na benia batei kube bambone nnongi jakwe benia nga abaletite babe pamwe mukibumo chakwe. ");
INSERT INTO nnq_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Mugenia, tulenga nike kabele? Andaibi Nnoongo abi pamwe na twe, beneke abapakuotola kutukana? ");
INSERT INTO nnq_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Nnoongo ankanakije Mwana jwakwe jwa jika, nambu ngammoya kwa magambu gito twenga tuboa. Anda ibi atei genia, bo, matupeje upeele gwoa? ");
INSERT INTO nnq_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Bo, beneke abapakatakiana abapambuligwe na Nnoongo? Nnoongo mwene kulenga batei babe bambone! ");
INSERT INTO nnq_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Bo, beneke abaotwi kutuhukumula? Babije! Mana Yesu Kilisto nga ojwawile, kabe ngayoka kuboka kwa abawile na atama kingono cha kalelo cha Nnoongo. Jwombe atujopela! ");
INSERT INTO nnq_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nga mene ojwaotola kutulekania na kupalana kwito na Kilisto? Kulaga andaje malola andaje ngondo andaje njala andaje uwocho andaje kupotekigwa andaje kiu? ");
INSERT INTO nnq_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Anda Majandiko Gachwapi apagalenga, “Kwa magambu ginu, tubi mukioya chu kuwe lyoele tipi, tutendigwa andi mambelele gu kuchinjigwa.” ");
INSERT INTO nnq_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nambu, muilebe yenie yoa, matuotola kukutujangata jwenio jwatupaile. ");
INSERT INTO nnq_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Gambu manyi kube kibije kilebe echikiotwi kutulekania lipalano lyabe, nakiuje, nabwomije, wala na akapakachi kuboka kumbenguje andaje makakala gange ga kumbenguje andaje agapitila ngoe andaje agapakupitila andaje uwecho gwagwoa, ");
INSERT INTO nnq_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wala eibi kunani na wala eibi pae wala kipanganigwa chochoa. Kibije echikipanganigwe chachoa echikipakuotola kutukolobana na lipalano lya Nnoongo mu Kilisto Yesu Angwana bito. ");
INSERT INTO nnq_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mwojo gwango anda ulongoleigwa nu Uhuke jwa Chwapi inenge kutenda nonge uwangije. ");
INSERT INTO nnq_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Mbala kulenga yene, mbi nukuwechuka muno nu kubinia kwanga pela umojo gwango. ");
INSERT INTO nnq_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Kwa magambu ga akalongo bango bu lungolo lumwe, ikabi kwa magambu gakajangata angweto tu, kabi nyeketi kubekigwa nhwilo nu kubekigwa kutali na Kilisto kummele. ");
INSERT INTO nnq_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Benia nga bandu ba Kuisilaeli abapambuligwe na Nnoongo kube ingota yabe, ngababeka mukibumo chakwe, ngalagana nabo, ngabape Malagilo na kabola pipaligwa kugongalela. ");
INSERT INTO nnq_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Angweto nga ichokolo ya akahokolo ba Akayahudi na jwenio Kilisto, ku umundu gwakwe, nga julungolo lwabe. Nnoongo jwatawala goa, alumbigwe pangapela! Unhyo. ");
INSERT INTO nnq_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Nongeje kutenda Nnoongo agalambwi malagano gakwe, gambu bandu boa ba Kuisilaeli ngiti bandu ba Nnoongoje. ");
INSERT INTO nnq_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ngiti ibelei yoa yu Ulaimu ngi ingota ipatite lilagoje. Nnoongo ngalonge na Ulaimu kulenga, “Nannagila kupete Isaka mpakupata ibelei.” ");
INSERT INTO nnq_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Mana gakwe, ingota ya Nnoongo ngiti iibelwike kundela ja mmeleje, nambu ingota iibelwike kwa malagano ga Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Lilagano lyene nga lende, “Mangobu agajeketeligwe manhika, Sala maipata mwana.” ");
INSERT INTO nnq_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Yene tuje, nambu uyo Lebeka ngapoto ingota ibele ka awawa bamwe, awawa benia nga anhoka bito ana Isaka. ");
INSERT INTO nnq_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Kupala Nnoongo amanyikane kutenda abi nuwecho gukupambula, tangu niingotaye kubelekwaje na tangu nukumanyaje gambone na mabaja, ");
INSERT INTO nnq_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Nnoongo ngannenge Lebeka, “Nkolo ammegelela unung'una.” Yene kupambu kwa Nnoongo kukengamana nulukemo lwakwe mwene, ngiti itendwa ya munduje. ");
INSERT INTO nnq_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Andi Majandiko Gachwapi pagalenga, “Yakobo nakate kumpala, nambu Esau nakate kunchimwa.” ");
INSERT INTO nnq_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Tulenga nike? Bo, Nnoongo jwa apaligweje? Napachokuje! ");
INSERT INTO nnq_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Magambu akannenge Musa, “Manammonela kia mundu jwajoa junampala kummone kia, manankole kia mundu jwajoa junampala.” ");
INSERT INTO nnq_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Yene, ilebe yoa ihyobalela kia ja Nnoongo, ngiti ukachana andaje kukupala kwa munduje. ");
INSERT INTO nnq_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Magambu Majandiko Gachwapi galenga yene ku Falao, “Nakammeka mangwana ibe kwa ndela jinu, uwecho gwango umanyikane, liina lyango litangachigwe padunia joa.” ");
INSERT INTO nnq_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ibonekana kipola kube, Nnoongo kummone kia mundu jwajoa ojwampala nu kummeka mundu jwajoa abe nimitau. ");
INSERT INTO nnq_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Pangaje maungonya, “Anda ilebe ibi nyenie, Nnoongo aotobo kunng'amba mundu? Beneke abaotola ukana mapalano gakwe?” ");
INSERT INTO nnq_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Nambu, mwe mamundu, nhwotobo kunng'amba Nnoongo? Bo, kibega kiotwile kakonya abombi bakwe, “Mboni umombite yene?” ");
INSERT INTO nnq_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mmombi akweti kinala chukubomba itope papala mwene nu kubomba ibega ibele ku utope ugwo, chimwe chambone muno na chenge chamboneje. ");
INSERT INTO nnq_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nyenie nga apibile ku Nnoongo. Apaila kulaya lilaka lyakwe na kumanyikana uwecho gwakwe. Akiba nu kuimbalila muno, baimbalila bandu abapaligwa kupata lilaka lyakwe, kwa abapaligwe komigwa. ");
INSERT INTO nnq_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Uyo apala kulaya kujoloka kukibumo chakwe echatupongolela twenga tatubi mukia jakwe, tatubekigwe kukipokela kibumo chakwe. ");
INSERT INTO nnq_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Magambu twenga nga baba abakemite, ngati kuboka kwa Akayahudi tuje nambu uyo kuboka kwa bandu ba ilambo yenge. ");
INSERT INTO nnq_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Andi palenga mukitabu cha nnondoli Hosea, “Baba abakiba, bandu bangoje manakemanga, ‘Bandu bango!’ Jwombe, nampaije aikemigwa, ‘Junampala.’ ");
INSERT INTO nnq_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na papa pabalengigwa, ‘Mangwetomwe bandu banguje.’ Penia bikemigwa, ‘Ingota ya Nnoongo ojwabi bwomi.’ ” ");
INSERT INTO nnq_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Jwombe nnondoli Isaya, magambu ga Isilaeli atondobea lilobe, “Ata ikabi ingota ya Kuisilaeli ibi ndu andi nhwangi gwa kumbwani, nambu achokutu abapakomboligwa, ");
INSERT INTO nnq_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Magambu Angwana, bachelwaje kuleta hukumu jabe tegatega kudunia joa.” ");
INSERT INTO nnq_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Andi Isaya apalenga pukutumbula, “Anda Angwana ba matyala bakabi nukutuigakiaje kibelei chenge chu Kuisilaeli, kabitubi andi ku Sodoma, kabitubi anda ku Gomola.” ");
INSERT INTO nnq_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Tulenga nike? Bandu banga Akayahudi bangapalapala ndela ju kubonekana bambone nnongi ja Nnoongo, nambu babekigwe kube bambone, kundela ja imani, ");
INSERT INTO nnq_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","kongo bandu ba Kuisilaeli abapalanga malagilo ga kabeka babe bambone nnongi ja Nnoongo, bapatangitije. ");
INSERT INTO nnq_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Kwa nike? Kwa magambu bahyobale itendwa yabe panga nhwamini Nnoongo. Ngabakoba panani ja, “liganga lyukobala,” ");
INSERT INTO nnq_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","anda pagalenga Majandiko Gachwapi, “Nnola, mbakubeka kukilambo chu Kusayuni liganga elipakakwalambu, liganga elipakabeka bandu bagwegange. Nambu ojwapakuamini aikolaje oni.” ");
INSERT INTO nnq_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Makalongo bango, chambala umwojo gwango ajango Akasilaeli bakomboligwe. Kabe najope ku Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nhotwile kuchalakicha kulenga bandu benia kutenda babi kachana kung'ongale Nnoongo, nambu kugongale kwabe ngiti kukummanya Nnoongo jwa kwelije. ");
INSERT INTO nnq_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Magambu bijimanyangitije ndela ja Nnoongo ejibabeka bandu babe bambone nnongi jakwe, bajigangite kubeka ndela jabe na nyene bijijeketelingije ndela ja Nnoongo ja kubeka babe bambone. ");
INSERT INTO nnq_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Magambu kukuika kwakwe Kilisto, malagilo galenganile, kupala boa abaamini babekigwe bambone nnongi ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Nhwalo gukutenda ilebe yapala Nnoongo kukujali malagilo, Musa aandika yene, “Mundu jwajoa jwalenganakia pagapala Malagilo malama.” ");
INSERT INTO nnq_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Nambu nhwalo gukutenda gapala Nnoongo ku ndela ja imani, ilenga yene, “Makalengaje umwojo gwinu, ‘Bene abapa kujenda mpaka kumbengu?’ Iboneka, munhuluya Kilisto pae, ");
INSERT INTO nnq_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","na makalengaje, ‘Bene abapakuuluka mpaka kumambi?’ Iboneka, kunneta Kilisto kuboka kwa abawile.” ");
INSERT INTO nnq_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Majandiko Gachwapi galenga nyene, “Nhwalo gwenio gwa Nnoongo ubi papipi na mwenga, ubi nkano jinu na kumwojo gwinu” na gwenio nga imani ejitujitangacha. ");
INSERT INTO nnq_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Anda nnyeketile kwa kano jinu kube Yesu nga Angwana nu kuamini kumwojo gwinu kube Nnoongo nganhyoya kuboka kwa abawile, mankomboka. ");
INSERT INTO nnq_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Magambu umwojo mundu kuamini mpaka kujeketeligwa kube jwambone nnongi ja Nnoongo, na kwa kano mundu kujeketela mpaka koligwa. ");
INSERT INTO nnq_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Majandiko Gachwapi galenga, “Kila ojwanhwamini Nnoongo akolaje oni.” ");
INSERT INTO nnq_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Nhwalo gongo kwa boa, kabe ulekinije kati ja Akayahudi na bandu banga Akayahudi, Angwana ba boa nga bamwe, bombe ukina muno kwa boa abannyopa. ");
INSERT INTO nnq_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Magambu Majandiko Gachwapi galenga, “Kila mundu jwapakujopa ku liina lya Angwana, makomboligwa.” ");
INSERT INTO nnq_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Bannyopabole jwenio kongo kunhwaminije? Kabe, bunhwaminabo anda banajoaje nhwalo gwakwe? Na bajoabo nhwalo gwakwe anda abije mundu jukutangacha? ");
INSERT INTO nnq_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na bandu batangachabo anda bakingigweje? Anda pagalenga Majandiko Gachwapi, “Kilebe chu kualala muno kuika kwa baba abatangacha Nhwalo Gwambone!” ");
INSERT INTO nnq_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Nambu boaje abajekatile Nhwalo Gwambone. Na Isaya alenga, “Angwana, nga beneke abaamine nhwalo gwito?” ");
INSERT INTO nnq_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Kuamini kuboke pu kujoa nhwalo, nu nhwalo gwenio uboke mulilobe lya Kilisto. ");
INSERT INTO nnq_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Nambu ngonya, bo, bujoiningije nhwalo gwenio? Elo, bujoininge, anda Majandiko Gachwapi pagalenga, “Lilobe lyabe lijoinike padunia poa, malobe gabe gaike mpaka kujipei dunia.” ");
INSERT INTO nnq_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ngonya kabele, bo, iotwi kube bandu ba Kuisilaeli bamanyangitije? Mwene Musa nga jukutumbula kujanga, “Manammekanga mabonelange bwiu kubandu banga kilambo, manammeka mme na lilaka kwa ilambo ya bandu akatokamau.” ");
INSERT INTO nnq_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Kabe Isaya ajiga kulenga, “Baba bangambalapala bambatite, nikilaite kwabe banga konya nhwalo gwango.” ");
INSERT INTO nnq_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Nambu kwa bandu ba Kuisilaeli alenga, “Lyoele tipi nganatondabekea maboko gango kakemanga bandu abankanite Nnoongo na bangajali.” ");
INSERT INTO nnq_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ngonya, bo, Nnoongo ate kakana bandu bakwe? Napachokuje! Nenga namwene nga Naisilaeli, kibelei cha Ulaimu, jwa kabi ja Benjamini. ");
INSERT INTO nnq_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nnoongo bakanitije bandu bakwe ababapambwile kuboka pitumbulaga. Nkombokela apagalenga Majandiko Gachwapi mangobu Eliya apakokaleka ku Nnoongo nhwalo gwa Kuisilaeli, ");
INSERT INTO nnq_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Angwana, bakomangite akalondoli binu nu kubomola kitembe chinu. Nga ne tu jika jango naigile, kabe bambalapala bangome!” ");
INSERT INTO nnq_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Bo, Nnoongo annyanga bole? Ngannenge, “Nikibekile bandu elufu saba bombe bikigongalelije kinyago Baali.” ");
INSERT INTO nnq_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nga apibi ngoe, babile bandu abaigile benia Nnoongo bapambwi kupeele gwakwe. ");
INSERT INTO nnq_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Kupambu kwakwe kikengamana ni upeele gwakwe. Ngiti kwa magambu ga itendwa yabeje, anda kupambu kukengamana na itendwa ya bandu, upeele gwakwe chikakonda upeeleje kabe. ");
INSERT INTO nnq_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ngoe, bo? Bandu ba Kuisilaeli bapatangitije chibakiba bakapalapala nambu boa abapambuligwe ngibikipata. Bange ngabapungania, ");
INSERT INTO nnq_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","andi Majandiko Gachwapi pagalenga, “Nnoongo agatei malango gabe na mwojo jabe kube mitopeu, mpaka leleno kuotoje kulola kwa mio gabe andaje kujoa kwa machikilo gabe.” ");
INSERT INTO nnq_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Na Daudi alenga, “Michopi jabe jibe ntambo gu kujonjigwa, bagwegange na kahukumula. ");
INSERT INTO nnq_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Mio gabe gabekigwe lubendu gakaotoje kulola. Migongo jabe jipende kwa kulaga kwangapela!” ");
INSERT INTO nnq_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ngonya, bo, Akayahudi bakobalinge nu kugweganga mbyuu? Napachokuje! Kulemwa kwabe kutei ukomboi gwaikalile bandu ba ilambo yenge, kupala Akayahudi babone bwiu. ");
INSERT INTO nnq_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Mabaja ga Akayahudi gajambukie kindimba nduu padunia joa, gwangaamini gwabe uletite kindimba nduu ku bandu bi ilambo yenge. Ibonekana kulenganakia kwabe kubakuleta kindimba nduu muno. ");
INSERT INTO nnq_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ngoe nannengelanga mangweto mabandu manga Akayahudi, gambu ne mbi nandundame ku bandu bange banga Akayahudi, kuyene nokeloke liengo lyango. ");
INSERT INTO nnq_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Kupala nabekange bwiu akakola ilambo ajango pangaje nakombolange katijabe. ");
INSERT INTO nnq_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Magambu andaibi ukanigwa kwabe kuletite dunia jichikachane na Nnoongo, ipakubebo anda pabapa kujeketeligwa na Nnoongo? Abawile bapakuyoka! ");
INSERT INTO nnq_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Andaibi kipande cha nkate chukutumbula kibekigwe chwapi magambu gwa Nnoongo, mmanya kipande choa kibi chwapi magambu gwa jwenio, mikega ja mikongo andajibi jina kualala, ndambi yakwe uyo iba ina kualala. ");
INSERT INTO nnq_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Elo, ndambi yenge ya nzeituni kubositani ngiekatigwa, paali pakwe ngabalondana lutambi lwa nzeituni gwa kupongoti. Mangweto mabandu ba ilambo yenge mmi tela nu lutambi lwa nzeituni gwa kupongoti, ngoe ntumiyanga makakala na malelalela ga nzeituni gu kubositani. ");
INSERT INTO nnq_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Makabembuje baba abaeketigwe andi ndambi! Na ati kikabi chukulokeloke nkombokelanga kube mangwetomweje mamijibeka mikega jibe na makakala, nambu mikega nga ejimpe mangweto makakala. ");
INSERT INTO nnq_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Nambu mannenga, “Ndambi ieketigwa magambu ne mbandakigwe paali pakwe.” ");
INSERT INTO nnq_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Tela! Ieketigwa kwa magambu gukotoka kunhwamini Nnoongo, nambu mwenga nnyema gambu gwa imani jinu, makalokalokaje nambu nnyema kukujogopa. ");
INSERT INTO nnq_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Magambu, anda Nnoongo babonije kia Akayahudi ababi andi ndambi ikibelekwa, nkita mankolela kia mwenga? ");
INSERT INTO nnq_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Nnolaoti, Nnoongo apabi jwakia na nkale. Jwombe nkale kwa baba abagwile, na jwakia kwinu mwenga anda mannyendekea kube mukia jakwe, andaje, namwe uyo manhweketigwa. ");
INSERT INTO nnq_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Na Akayahudi, uyo, anda bakotwike kuamini kwabe mabalonda kabena gambu Nnoongo aotwile kalonda kabena. ");
INSERT INTO nnq_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mangweto mabandu ba ilambo yenge, kukubelekwa andi lutambi lwa nzeituni gwa kupongoti, nambu mmoigwe kwenio nganondigwa mu nzeituni gu kubositani paali panga pinu. Nambu, Akayahudi kukubelekwa andi nzeituni gwa kubositani, maiba kindema muno kwabe kupandakigwa kabele munkongo ugwo gwabe. ");
INSERT INTO nnq_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Makalongo bango, mbala mmanyange nhwalo gongo ogugukiite manhwacha kita nkweti malango muno. Mitau ja Akasilaeli jikiba jikingobu tu, nambu mpaka bandu ba ilambo yenge balengenile kumuji Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Penia nga kilambo choa chu Kuisilaeli apikipa komboligwa, anda pagalenga Majandiko Gachwapi, “Nkomboi maika kuboka Kusayuni, mauboya ubaja gwa kibelei cha Yakobo. ");
INSERT INTO nnq_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Lende nga lilagano elimbakulagana nabo mangobu apambakuboya mabaja gabe.” ");
INSERT INTO nnq_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwa magambu bukana Nhwalo Gwambone, Akayahudi babi akangondwa ba Nnoongo, nambu ngu upeele gwinu mabandu banga Akayahudi. Nambu, magambu gukupambuligwa kwa akahokomundu, maganja tango na Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Magambu Nnoongo anda bandu bapile hupo yakwe na kapambula, kugalambukaje. ");
INSERT INTO nnq_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Kutumbu kalakala mangweto makannemwa Nnoongo, nambu ngoe mmoneligwe kia jakwe kwa magambu ga malemwa gabe. ");
INSERT INTO nnq_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Uyo, na kia ejimpatite mangweto, Akayahudi ngoe banemuki Nnoongo ibe uyo na angweto bapokele ngoe kia ja Nnoongo. ");
INSERT INTO nnq_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Magambu Nnoongo abatabangite bandu boa mu malemwa gabe ibe boa bakolelange kia. ");
INSERT INTO nnq_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Utajili na gwambone na ilimu ja Nnoongo nga ngolongwa muno! Hukumu jakwe kupemekaje na ndela yakwe kumanyikanaje! ");
INSERT INTO nnq_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Andi pagalenga Majandiko, “Bene agabagamanyi mawacho ga Angwana? Bene abaotwi kumpangila? ");
INSERT INTO nnq_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Andaje bene abampi ote kilebe kuboka penia kabukia kabele chenie?” ");
INSERT INTO nnq_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Magambu ilebe yoa ipanganigwa na benia, yoa ibi ku uwecho gwabe nu kukupala kwabe. Kibumo kibe kwabe machoba goa pangapela! Unhyo. ");
INSERT INTO nnq_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Kwa nyene, akalongo bango, magambu Nnoongo nga juna kia ndu, nannyopa kwa mojo gwoa, mpangange mibele jinu kwa Nnoongo ibe lilumbo elibi li mmomi, ilibi chwapi na linakualala. Jenie nga ndela jinu jambone ju kugongalela. ");
INSERT INTO nnq_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Makajigaje ilekaleka ya padunia pano, nambu Nnoongo ang'alambuye nu kutenda mayono mawacho ginu. Penia nga pampakuoto kumanya gapala Nnoongo nu kumanya nhwalo ogubi gwambone, ogunhwalalila nu kulimba. ");
INSERT INTO nnq_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kuboka mu upeele ogwambi Nnoongo, nannengelanga mmoa, mikikibona mambone muno kupeta apampaligweje. Kuwacha kwinu kuba tela na kipemo cha imani andi Nnoongo elyampile kila mundu. ");
INSERT INTO nnq_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Mmele ukweti ipagwa ndu, kila kipagwa kikweti liengo lyakwe. ");
INSERT INTO nnq_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Uyo iganukube twenga tubi tajingi kukulondana na Kilisto, kila jumwe nga kipagwa cha jonge. ");
INSERT INTO nnq_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Tukweti itoi ijingi andi putupatite upeele. Ojwakweti kitoi chukulonge lilobe lya Nnoongo atenda yene tela na kuamini kwakwe. ");
INSERT INTO nnq_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Mundu juna kitoi cha kubegelela na abegelele. Juna kitoi cha kubola na abole. ");
INSERT INTO nnq_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Juna kitoi cha kalimbia mwojo bange na atende nyenie. Juna kabaguli ilebe ajakwe eyakweti na atende kwa mwojo lachi. Kilongoi alongoleya kukachana, juna kia na atenda nyenie kukuala mwojo. ");
INSERT INTO nnq_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Kupalana kwinu kuba kuwangije. Mikichimwange kilebe chachoa kibaja, nambu nkamulila yambone. ");
INSERT INTO nnq_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Mpalanange andi makalongo, kila mundu anhwachila oti nnyakwe kuichima. ");
INSERT INTO nnq_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Makalegelekaje mukachana, nambu nkalamuke mumyojo jinu kwakabegele Angwana. ");
INSERT INTO nnq_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Kuhyobalela kwinu machoba goa kummekange kube nu kuala mwojo, mmegange nu kuimbalila mumalola, kugongalela machoba goa. ");
INSERT INTO nnq_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Majangatange bandu ba Nnoongo bapate ilebe ibipala, mapokelange akamageni ku mwojo gwambone. ");
INSERT INTO nnq_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Malumbilange kindimba boa abampoteka malumbilange makabeka nhwiloje. ");
INSERT INTO nnq_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Nhwalalange mwojo pamwe na abaala mwojo, nng'utange pamwe na abaguta. ");
INSERT INTO nnq_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ntamange kukuchikachana kwambone mangweto jika. Makapalangaje makolomakolo, nambu magabegelele machokomachoko. Mikikibonaje kube mmi namalango muno. ");
INSERT INTO nnq_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Makabuyanaje ubaja kwa ubaja. Mmegelelange ilebe ya mbone nnongi ja boa. ");
INSERT INTO nnq_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Ntendanga andi punhwotolanga na mma natengela na bandu boa. ");
INSERT INTO nnq_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Makaganja bango, makabuyanaje, nambu mannekele Nnoongo kilebe chenie, magambu Majandiko Gachwapi galenga, “Kubuya liengo lyango nenga mamuyage, balenga Angwana.” ");
INSERT INTO nnq_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Gange Majandiko, galenga, “Nngondwa jwinu andabi na njala, mampe chakulya, andabi na nyota, mampe chukunywe. Magambu kukutenda nyenie mamummeka abe na oni ngolongwa andi makala ga mwoto umutwe gwakwe.” ");
INSERT INTO nnq_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Makajeketeje kuchipula na ubaja, nambu muotole ubaja kwa gambone. ");
INSERT INTO nnq_vpl VALUES ("RM13_1","075_13_1","ROM","13","