﻿USE sofia;
DROP TABLE IF EXISTS sofia.nna_vpl;
CREATE TABLE nna_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nna_vpl WRITE;
INSERT INTO nna_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Walangkarrangu purlpi parlparrpa jungka jirni Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pala jungka puru waninyikinyi, ngapapurni waninyikinyi, wiyirr yamarnakinyi janpalu. Waninyikinyi ngunarrijirri warrukurlajartu. Palinymili Pirlurr yananyikinyi ngapanga kankarni. ");
INSERT INTO nna_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Wurrarna Ngarrkalu, “Tili jarra.” Palaja tili jarrinyi palinymili muwarrjaja. ");
INSERT INTO nna_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Yirrirnakanu wurrarna “Ngalypa.” Jinta pirnipulinyi tilipa warrukurla. ");
INSERT INTO nna_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Warrukurla yini marna “Warrukartingarra”, tili yini marna “tilingarra”. Palaja warrukarti jarrinyi, palaja pirrpa-pirrpa jarrinyi. Karrpu wariny turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Wurrarna palanga, “Parlparr jarra, jinta pinaku ngapakupa mujunguku.” ");
INSERT INTO nna_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Pala jarrinyi. Kankarrkurnu yanayi mujungu, ngapa kaniny yakarnaya. ");
INSERT INTO nna_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Pala parlparr yini marna “Parlparrngarra”. Palaja warrukarti jarrinyi, palaja pirrpa-pirrpa jarrinyi. Karrpu wariny turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Wurrarna palanga, “Ngapa kaniny jarra, warajanga jarra, jungka punarra turlpa, ngayarta jarra.” Pala jarrinyi. Kaniny jarrinyi ngapa, jungka yakarna ngayarta. ");
INSERT INTO nna_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Pala jungka punarra yini marna “Warrarnngarra”, pala ngapa wirtujina yini marna “Kujungurrungarra.” Yirrirnakanu wurrarna “Ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Palaja wurrarna, “Turlpayi mungka warinypa wariny, warrulypa warinypa wariny.” Pala jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Jungkaja mungka warinypa wariny turlpanyiyi, jinta mayijartiny, jinta munu. Warruly pukurl warinypa wariny turlpanyiyi, jinta mayijartiny, jinta munu. Yirrirnakanu wurrarna “Ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Palaja warrukarti jarrinyi, palaja pirrpa-pirrpa jarrinyi. Karrpu wariny turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Wurrarna palanga, “Tili jarrayi kanka parlparrja, tili jinaku warrarnja. Palarrangulu warrukartingipa karrpungu tili yinganyaku, partunukupa yurrangaku yinku kalkunaku pukurl.” Pala jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Wirtujinajirri jinapulinyi, janyjapa wirlarra jinapulinyi. Wirtulu tili jinaku yijalu pirrpa-pirrpaja warrurl-warrurlkartijakun, wupartulu tili jinaku yijalu warrukartingi. Panikatarrangu pukun jirnijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Parlparrja wirrirnijaninyi warrarnku tili jinaku, warrukartikupa karrpuku jinta pinaku pukun. Yirrirnakanu wurrarna “Ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Palaja warrukarti jarrinyi, palaja pirrpa-pirrpa jarrinyi. Karrpu wariny turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Wurrarna palanga, “Ngapakarringu yintangapa kujungurrungu kurrngal warinypa wariny jarrayi. Wirrujartiny jarrayi kanka yananyaku.” ");
INSERT INTO nna_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Palaja kujungurrungu kuwiyi wirtujina jirnijaninyi yijangarra. Janpamalu pukun wirturrangupa wuparturrangu, warinypa wariny jirnijaninyi. Pijungapa yintanga janpamalu jirnijaninyi warinypa wariny. Jintapa wiyirr ngapakarringu jirnijaninyi, yintangapa kujungurrungu. Wirrujartiny jirnijaninyi warinypa wariny pukun. Yirrirnakanu wurrarna “Ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ngalypalu muwarr pirnijanaku. Wiyirrku wurrarnajanaku, “Kalkulumarnanyurrinyi ngajulu. Kurrngal jarrulinyurru yija, partanykarrangupa kurrngal kalkulkulinyurrujaninyi yija-yiji.” ");
INSERT INTO nna_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Palaja warrukarti jarrinyi, palaja pirrpa-pirrpa jarrinyi. Karrpu wariny turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Wurrarna palanga, “Jungkanga kuwiyirrangu warinypa wariny jarrayi, warrarnja waninyaku, marnti yananyaku jungkanga, kuwiyirrangu parlkarrkarringupa warnkukarringu, wirturrangupa wuparturrangu.” Pala jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Wiyirr jirnijaninyi. Yirrirnakanu wurrarna “Ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Palaja wurrarna, “Marrngu jilaminyijaninyi nganyjurrukapali. Nyampali wantulupiyi kuwiyirranguku wiyirrku, janpamalukupa wirrujartinykupa jungkanga yananyakatarrangukupa.” ");
INSERT INTO nna_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Marrngu jirni Ngarrkalu palinykapali. Pirirripa mirtawa jirnipulinyi. ");
INSERT INTO nna_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ngalypalu muwarr pirnipulaku. “Kurrngal partanykarrangu kalkulkulinyumpulu yija, yija marrngurrangu wantulupiyi ngunarrijirri. Wiyirrku kuwiyiku nyampali jarrulinyurrujanaka. Nyampali wantulinyurrujanaka janpamalurrangukupa wirrujartinyarrangukupa wiyirrku kuwiyirranguku. ");
INSERT INTO nna_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Warinypa wariny mayi jinarninyurruka, mungkajapa warrulyja mayirrangu wiyirr yinganyarnanyurrinyi. ");
INSERT INTO nna_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kuwiyirrangukupa wirrujartinyarrangukupa wiyirrku jungkanga yananyakatarranguku warruly jinarnijanaka mayijartinypa. Yakarnarnajanaka.” ");
INSERT INTO nna_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yijalu jirnijaninyi. Jipi jinaja yirrirnijaninyi wiyirr Ngarrkalu. Wurrarna, “Ngalypakata yiji.” Wiyirr palajun jirnijaninyi. Palarrangungu karrpurrangungu, parirr warajakartingipa warajanga, jirnijaninyi wiyirr. Palaja warrukarti jarrinyi, palaja pirrpa-pirrpa jarrinyi. Karrpu wariny turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","3","Nyungu warinymaljanga, karrpu 7, munu wariny jinama. Wurrarna pala karrpu, “Purlpi wiyirr jipi jirnirnijaninyi. Warrkamu jarrinyikinyirni, kuwarri warrkamu yakarnarna. Nyungu kuwarri yija munu nganipa wariny jinamarna. Palaja nyungu karrpu wariny, warrkamumajirri. Warrkamu yakarnarna kuwarriku.” ");
INSERT INTO nna_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Palajun jirni Ngarrkalu walangkarr, parlparrpa jungka jirni. Kuwarri wurralamarnanga marrngurranguku, ngani jirnakinyayi. ");
INSERT INTO nna_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Walangkarr yija marrngumili mayi pirraja munu turlpanyamayi, munu wheat-pa rice-pa jinta jijirrarrangu marrngumili. Ngarrka munu ngakarnama ngapa mujunguja, marrngumajirri jungka karlinyaku, warrulyja mayi jungkanga wirrinaku, grow-am jinaku. ");
INSERT INTO nna_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Januku jungkaja turlpanyayi, purlpurl jarrinyiyi, wirrirniyi ngapa jungkanga kanka. ");
INSERT INTO nna_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yuu, yakujun jirni marrngu Ngarrkalu. Kurlurlu mana jungkaja. Pirirri jirni kurlurluja palaja. Pala pirirri milyanga nganyjurnulu palinyju. Palanga pirirringi ngalpanyala wangal Ngarrkaja. Palajalu pirirri wanka jarrinyi. Yini pala pirirri “Adam”. ");
INSERT INTO nna_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Palaja warrarnja, yini pala warrarn Eden, palanga Ngarrkalu wirrirni yinta wirtu, ngalypakata yija. Pirirri yarni manaja, palanga yintanga wirrirni. ");
INSERT INTO nna_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Palanga yintanga mungkarrangu ngalypakatarrangu warinypa wariny wirrirnijaninyi. Mayijartinyarrangu ngalypakatarrangu palanga warinypa wariny. Mungkarrangungu waraja partijirri kaniny wirrirni. Pala mungka yini marna, “Marrngu Wanka Kalkunakata.” Palajangarra marrngulu ngananyaja, wankanyu wantuliny ngarramarnti, marlkarrimajirri wantuliny. Wariny mungka partijirri kaniny jintanga wirrirni, miranu jinapinti pala. Nyungu wariny mungka yini marna “Marrngu Miranu Jinakata Ngalypakupa Kurluku.” ");
INSERT INTO nna_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Pirirri nyarra yintanga Eden-ja wirrirni, jungkakupa karlinyaku yintakupa kalkunaku. ");
INSERT INTO nna_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Palinyja wurrarnala, “Yintanga mungkarranguja wiyirrja mayi ngalkulumanjaninyi. ");
INSERT INTO nna_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Warajaja mungkajaja yakalaman, munu ngananyaku, palaja mungkajaja miranu jinapintija. Yini marnarna pala ‘Marrngu Miranu Jinakata Ngalypakupa Kurluku.’ Palaja mungkaja munu ngananyaku. Ngananyaja palajaja, yija-yiji marlkarri jarruluman.” ");
INSERT INTO nna_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Palaja wurrarna palinyju, “Munu kujurl waninyaku pirirri. Jarrurl jilkurnalu, jarrurljartinymarta wantuliny.” ");
INSERT INTO nna_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Purlpi jungkaja kuwiyirrangupa wirrujartinyarrangu wiyirr jirnijaninyi Ngarrkalu. Pirirrikarti kanyajaninyi, yini yinganyaku palarranguku. Palalu pirirrilu yini yinyajaninyi kuwiyipa wirrujartinypa nganin-nganin. Pirirrija palaja yini kalkurnayi. Palarrangungu wiyirrja munu waraja pirirrikapali, palinyku jarrurl. ");
INSERT INTO nna_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Palaja pirirri kupalya jirni Ngarrkalu, raminyja pirirrija kunyja manali, palaja pirli yamarna majangulu. ");
INSERT INTO nna_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Palaja kunyjaja mirtawa jirni, kanyalu pirirrikarti. ");
INSERT INTO nna_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Palaja wurrarna pirirrilu, “Yartikarra, nyungu ngajukapali! Kawuja ngajuja jirni. Yini ‘Mirtawa’.” ");
INSERT INTO nna_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Palajalu nyungu jina yakarnanganyjurruka Ngarrkalu: Pipipa japartu yakalkulinypulinyi pirirrilu, nyupamarninypa warajanga jarrulinypulu, warajangangarra yija wantulinypulu. ");
INSERT INTO nna_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Palanga yintanga Eden-ja waninyikinyipulu nyuparra, Adam-pa, waninyikinyipulu kurta, ngalypa waninyapulu, kurta pulany. ");
INSERT INTO nna_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kuwiyirrangungu jintangapa jurru mirlkawarrangu waninyikinyi. Mirtawa japirr marna jurrulu, “Ngani wurrarnangu Ngarrkalu? ‘Mayi munu ngananyaku wiyirrja mungkarranguja yintanga’? Palajun muwarr pirningu?” ");
INSERT INTO nna_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Yimpirnili mirtawalu, “Jintarranguja mungkaja yintaja ngalkulupalayi. ");
INSERT INTO nna_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Wurrarnangalayaku Ngarrkalu, ‘Waraja mungkajakun yintanga waninyi, partijirri kaninyja, mungka marramarranga, palaja munu ngananyaku mayi, munu warlinakupa pala mungka, marlkarringimarra’.” ");
INSERT INTO nna_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Jurrulu wurrarnala, mitu marna, “Nyuntu munu marlkarri jarruluman. ");
INSERT INTO nna_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Palamaja mungkaja ngalkuluman, Ngarrkakapali jarruluman, miranu ngalypakupa kurluku. Palaku Ngarrka malyparr karrinyi. Palangamarra wurrarnangu, ‘Munu palamaja mungkaja ngananyaku’.” Mitulu wurrarnalu jurrulu, “Munu pinakarra Ngarrkanga.” ");
INSERT INTO nna_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mayi parrjarn-parrjarnikinyi mirtawalu, kurlkalkalu parrjarnakinyi, ngalypakata. Kurlkali marnakinyi, “Miranu jiliminyi palamalu mayilu.” Ngarrkakapali miranu jarrinyaku karrinyikinyi mirtawa. Palaja nyarrakarti mungkakarti yana, mayi ngartarna, ngana. Jinta nyupanga palinymilingi yinyali. Palinyju pukurl ngana. ");
INSERT INTO nna_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kurlkapirli jarrinyipulu, yirrirnipularninyi kurta waninyikinyipulu. Palaja kurntany jarrinyipulu. Palajalu yarni marnapularninga jirrji parrkajalu wirtujalu. ");
INSERT INTO nna_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Jarurrukartingi Ngarrka jina pinakarrinyipulu jakarr-jakarrkarra yintanga marntija. Wirntijartiny kuku jarrinyipulu mungkarrangungu Ngarrkangamarra. ");
INSERT INTO nna_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pirirriku kamarnalu Ngarrkalu, “Wanyjarningi nyuntu?” ");
INSERT INTO nna_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Puntaju marnalu, “Yuu, yintanga pinakarrinyarnanta nyuntu marntija. Kurta waninyikinyirni. Palajalu wirntijartiny ngaju, kuku jarrinyarnangu.” ");
INSERT INTO nna_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Japirr marna Ngarrkalu, “Nganija miranu jarrinyan kurta waninyikinyin? Nyarraja mungkaja, ‘Marrngu Miranu Jinakata Ngalypakupa Kurluku’, palaja mayi nganan nyuntulu?” ");
INSERT INTO nna_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Pirirrilu wurrarnalu, “Nyuntulu mirtawangarra yinyanyin nyungu. Palaja mungkaja yinyanyi palinyjungarra, mayi nganarna.” ");
INSERT INTO nna_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mirtawa japirr marna Ngarrkalu, “Ngani jirnin nyuntulu?” Wurrarnala, “Jurrulu mitu marnanya, palinyja muwarrja nganarna.” ");
INSERT INTO nna_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","15","Jurrungu wurrarnala Ngarrkalu, “Kurlu yija jirnin nyuntulu. Puntaju kurlu jilamarnanga yija, munu jinta kuwiyirranguku, nyuntukujakun. Ngarlungungarra yankuluman. Kurlurlu ngalkuluman ngarramarnti. Malyparr jilamarnanta mirtawaku, Mirtawa malyparr jilamarnanga nyuntuku. Partanykarrangupa nyuntumili mirtawamilipa kulilu yirrilipiyarninyi. Jurnturtu nyuntu pijurnanga jilamanta yija mirtawamilalu partanyjupa, Jina paliny pijurnanga jilaman yija nyuntulu.” ");
INSERT INTO nna_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mirtawanga wurrarnala, “Parra-parra wirtu yungkulumarnanta yija partanyja kanganyaja. Miranungarra nyuntu partanyja kanganyaja parra-parraku, yirrku yiji pirirriku marrapa karrirrulumanpalu. Nyampali wantulumangu yija nyuntuku.” ");
INSERT INTO nna_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","19","Palaja pirirringi wurrarnala Ngarrkalu, “Mayi nyarra wurrarnarnangu munu ngananyaku. Munu pinakarrimajinpa nyuntulu. Nyuntumilija mirtawaja muwarrja mayi nganan nyuntulu palaja mungkaja. Puntaju warrarn kurlu jilamarna yija ngajulu. Turlpulupiyi parupa jiripa nganin-nganinpa. Nyuntulu mayiku kanyjilamanpa ngarramarnti. Mayiku pirti marrjalu karlinyarruluman, karrpurrangu karrpurrangu ngartarnarruluman, yijalu jirrmilju ngalkulumanta. Marlkarrija, jungka jarruluman. Jipi jirnirninti jungkaja, Kurlurluja jirnirninti. Marlkarrija, jungka jarruluman yarranakanu.” ");
INSERT INTO nna_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Pirirrimarninyju yini marna palinymili mirtawa, “Eve”. Pipi nganyjurruku wiyirrku. ");
INSERT INTO nna_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Palaja wurru karnuja kuwiyija yarni marnapuluka Ngarrkalu, wirrirnipuluku palinyju, Adam-kupa palinymili mirtawaku. ");
INSERT INTO nna_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Palaja Ngarrkalu wurrarna, “Marrngulu munu pinakarrimiji. Mungkaja Marrngu Miranu Jinakataja purlpi ngana. Paliny kuwarri nganyjurrukapali, kurlkapirli waninyi ngalypakupa kurluku. Ngalali palamaja warinyjapa mungkaja, wankanyu kalkunakataja. Palaja wankanyu wantuliny ngarramarnti, marlkarrimajirri wantuliny. Ngampa pilamarna ngajulu ngananyangamarra.” ");
INSERT INTO nna_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Palajangarra Eden-jangarra yintaja ngakarnapulinyi Ngarrkalu. Jalanga ngakarnapulinyi, karlinyaku jungkaku, mayirrangu jungkanga wirrinaku, mayiku pulanymilaku turlpanya jinaku. ");
INSERT INTO nna_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Palaja Ngarrkalu wirrirni angel, kakarra palanga yintanga, wirtu pukun wirrkanapinti. Milya warinykurnu warinykurnu yananyikinyi pala wirtu wirrkanapinti, parrparrpa karra marninyi. Palanga angel-ja wurrarnala Ngarrkalu, “Nyuntulu ngampa pinaku marrngu ngalpanyajaku wangka pala mungkakarti, pala wankanyu kalkunakatakarti mungkakarti.” ");
INSERT INTO nna_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam-pa Eve yanapulu palaja Yitinja. Palaja Eve-lu pujamu kanya. Karra marna, “Partany yinyanyi Ngarrkalu.” Yini paliny Cain. ");
INSERT INTO nna_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Palaja wariny kanya. Yini paliny Abel. Wirtu jarrinyapulu. Pirirrijirri jarrinyapulu. Abel-ju kalkurnakinyijaninyi kukurnjarirrangu. Cain-ju karlinyikinyi jungka. Mayirrangu wirrirnikinyijaninyi jungkanga, turlpanyikinyiyi, ngarnipirnikinyijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Karrpungu warajanga Cain-ju kanya mayi, Ngarrkanga yinyali. ");
INSERT INTO nna_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Palinymilalu marrkalu kanya kukurnjari, marlkarri jirni, kutarrangu ngalypa Ngarrkanga yinyali. Ngarrka ngarlu pikaly jirni Abel-ju. ");
INSERT INTO nna_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Munu pikaly jirnima Cain-ju. Palajalu Cain kuli jarrinyikinyi. Ngumpa wariny jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ngarrkalu wurrarnalu, “Nganija nyuntu kuli jarrinyijin? Nganija ngumpa wariny jarrinyijin? Munu yunturi jarranpili. ");
INSERT INTO nna_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Yinku jinaman, pikaly jarriman. Kurlu jirnikinyin. Yirrkulu nyuntulu jilamanparninyi ngalypa jinaku. Palajalu pikaly jinaluminyin. Munujalu, jiti kurlujartiny jinaluman.” ");
INSERT INTO nna_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ngarrkaku Cain-ju munu pinakarrimalu. Yunturi jarrinyikinyi. Palajalu wurrarnalu marrkaku, “Yankuli jalakarti ngurnungu.” Jalakarti yanapulu. Palaja Cain-ju wirlarna marlkarri marrka palinymili. ");
INSERT INTO nna_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Palajalu Ngarrkalu japirr marna, “Wanyja marrka nyuntumili?” Murrkangunyamarninyju mitu marna, “Munumparla ngaju. Munurla tuku jinakarni.” ");
INSERT INTO nna_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Wurrarnili Ngarrkalu, “Nyuntu mitu karrinyan. Nyuntulu wirlarnan marlkarri. Jungkanga palinymili pijirri waninyi. Nyuntulu yija kurlu jinan. ");
INSERT INTO nna_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Puntaju ngajulu kurlu jilamarnantalu. Jungka kurlu wantulamanga. ");
INSERT INTO nna_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mayirrangupa munu turlpulupiyingu. Kaja ngakalamarnanta. Wirntijartiny yankun-yankuluman warinykartirrangu.” ");
INSERT INTO nna_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain-ju wurrarnalu, “Kararr nganimarta jinajinpa. ");
INSERT INTO nna_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Yankun-yankulumarna warinykartirrangu. Ngurnipali warinyjupa marlkarri wirlalanyili.” ");
INSERT INTO nna_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ngarrkalu wurrarnili, “Warinyju wirlalantili, ngajulu yijalu wirlalamarnanga.” ");
INSERT INTO nna_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Palajalu Cain yana ngunarri. Kakarrakurnu waninyikinyi kaja Yitinja. Ngurnungu warrarn yini marnayi “Parra Yaninyikinyi.” ");
INSERT INTO nna_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nyupa Cain-mili partany kanya, yini Yinuku. Tawun yarni marna Cain-ju, nyaparu jirni pala tawun partanyku palinymilaku, yini marna pala tawun Yinuku pukun. ");
INSERT INTO nna_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoch japartu jarrinyi partany pirirriku, yini Irad. Irad japartu jarrinyi partany pirirriku, yini Methushael. Methushael japartu jarrinyi partany pirirriku, yini Lamech. ");
INSERT INTO nna_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Pala Lamech kujarra mirtawajirri kalkurnapulinyi, Adah-pa Zillah. ");
INSERT INTO nna_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah-lu partany pirirri kanya, Jabal. Walangkarr nyarra Jabal kuwiyirrangu kalkunakatarrangu, mayamajirri, yana-yanikinyiyi tent-arrangujartiny warinyja warinykarti, warruly kanganyaku janamilaku kuwiyiku. ");
INSERT INTO nna_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Markamarniny palinymili yini Tubal. Walangkarr nyarra Tubal musical instruments yarni manakatarrangu, harp-pa flute-pa nganin-nganin. ");
INSERT INTO nna_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah-lu partany pirirri kanya, yini Tubal-Cain. Palinyju yarni marnikinyi yarni manapintirrangu bronze-japa iron-ja. Zillah-lu partany mirtawa kanya pukun, yini Naamah. ");
INSERT INTO nna_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech wurrarnapuluku mirtawakujirri palinymilaku, “Adah-pa Zillah, pinakarrajipulu ngajuku! Wangalangulu ngaju wirlanaja, paliny wirlarnarna marlkarri. ");
INSERT INTO nna_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ngarrkalu wurrarna nganurtulu Cain marlkarri wirlalkuliny, paliny Ngarrkalu wirlalkuliny seven times. Nganurtulu ngaju marlkarri wirlanaja, paliny warinyju wirlalkuliny seventy-seven times!” ");
INSERT INTO nna_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Abel marlkarri waninyaja, Eve-lungarra wariny partany kanya. Karra marna, “Abel wirlarna marlkarri Cain-ju. Ngarrkalu puntaju yinyanyi pujamu wariny.” Yini marna “Seth”. ");
INSERT INTO nna_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth japartu jarrinyi Enosh-ku. Palajaja marrngurrangulu kamarnikinyiyi Ngarrkakupa ngarluja nyurra marnikinyiyi paliny. ");
INSERT INTO nna_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nyungu muwarr yarntarnayi purlpija, Adam-milaku partanykarrangupa karlujipa jamujirrangupa nyirrirnikartijarranguku. ");
INSERT INTO nna_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ngarrkalu marrngurrangu yarni manajalu, palinykapali yarni marnajaninyi. Pirirripa mirtawa yarni marnajaninyi, ngalypa jirnijanaku, ngalypa wurrarnajanaku, yini marnayi “marrngu”. ");
INSERT INTO nna_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam 130 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku. Palinymili partany palinyngarrakapali. Yini marna palinymili partany “Seth”. ");
INSERT INTO nna_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seth ngayarta jarrinyaja, Adam wanka jarrinyikinyi 800 partunurrangu, partanykarrangu pirirripa mirtawa kanyapulujaninyi Adam-jupa Eve-ju. ");
INSERT INTO nna_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam wanka jarrinyi 930 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth 105 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku, Enosh. ");
INSERT INTO nna_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosh ngayarta jarrinyaja, Seth wanka jarrinyikinyi 807 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth wanka jarrinyi 912 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh 90 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku, Kenan. ");
INSERT INTO nna_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan ngayarta jarrinyaja, Enosh wanka jarrinyikinyi 815 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh wanka jarrinyi 905 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan 70 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku, Mahalalel. ");
INSERT INTO nna_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel ngayarta jarrinyaja, Kenan wanka jarrinyikinyi 840 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan wanka jarrinyi 910 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel 65 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku, Jared. ");
INSERT INTO nna_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jared ngayarta jarrinyaja, Mahalalel wanka jarrinyikinyi 830 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel wanka jarrinyi 895 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared 162 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku, Enoch. ");
INSERT INTO nna_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enoch ngayarta jarrinyaja, Jared wanka jarrinyikinyi 800 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared wanka jarrinyi 962 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoch 65 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku, Methuselah. ");
INSERT INTO nna_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Methuselah ngayarta jarrinyaja, Enoch marnti jarrikinyapulu Ngarrka, wirrirni Ngarrka ngarlungu yija 'lived in close fellowship with God'. Wanka jarrinyikinyi 300 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoch wanka jarrinyi 365 partunurrangu, ");
INSERT INTO nna_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","marnti jarrinyapulu Ngarrka, walking in close fellowship with God, palaja karrpu warinyja partarl parrjarnamayi, palanga munu wanima, kanya Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah 187 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku, Lamech. ");
INSERT INTO nna_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamech ngayarta jarrinyaja, Methuselah wanka jarrinyikinyi 782 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah wanka jarrinyi 969 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech 182 partunurrangujartiny jarrinyaja, japartu jarrinyi partany pirirriku. ");
INSERT INTO nna_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamech-ju partany yini marna Noah, wurrarna, . . . . . . . . “May he bring us relief from our work and the painful labour of farming this ground that the Lord has cursed.” ");
INSERT INTO nna_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noah ngayarta jarrinyaja, Lamech wanka jarrinyikinyi 595 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamech wanka jarrinyi 777 partunurrangu, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah 500 partunurrangu jarrinyaja, japartu jarrinyijanaku Shem-pa Ham-pa Japheth. ");
INSERT INTO nna_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Punjaja marrngurrangu kurrngal waninyayi, jirrja yanayi, ngunarrijirringi waninyayi. ");
INSERT INTO nna_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Palaja mirurrurrangulu Heaven-ja pungkanajalurrangu yirrirniyijaninya kurrirrangu, ngalypa yiji yirrinaku, kurlanaku kanyayijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","4","Partanykarrangu turlpanyayi, janamili japartu mirurrupa pipi kurri. Wirtupa mirlkakatapa kurlukata waninyayi. Wiyirrju pinakarrinyiyijanaku, nyurra marnayijaninyi wiyirrju. Palaja wurrarna Ngarrkalu, “Pirlurr Ngaju munu wantuliny marrngurrangunga ngarramarnti. Ngampa pilkulumanjaninyi kurlujartiny jinajamarra, partunurrangunga 120.” ");
INSERT INTO nna_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Marrngurrangu wiyirr kurlu yija jarrinyayi, munu pinakarrimiyi Ngarrkanga, panypanyikinyiyili. Wurrarnakinyayarninyi ngarrakuny kurlujartiny jinaku. ");
INSERT INTO nna_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Palajalu wurrarna Ngarrkalu, “Marrngurrangulu wiyirrju kurlujartiny jinayi. Wurrarnakinyayi ngarrakuny kurlujartiny jinaku. Ngajulu jinajaninyi ngalypa. Kuwarri kurlu yija jarrinyiyi. Palajalu ngarlu wurnmanyarna. ");
INSERT INTO nna_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Marlkarri jilamarnajaninyi marrngurrangu wiyirr, kuwiyirrangupa wirrujartinyarrangu pukun.” ");
INSERT INTO nna_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Warajalujakun marrngulu pikaly jirni Ngarrka. Yini paliny Noah. ");
INSERT INTO nna_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noah Ngarrkanga pinakarrinyikinyi, ngalypa jirnikinyi. Munu kurlu jinama palinyju. ");
INSERT INTO nna_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Partanykarrangujartiny kujarrapa waraja, pirirrimartarrangujartiny, yini Shem, Ham, Japheth. ");
INSERT INTO nna_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","13","Noah-nga wurrarnalu Ngarrkalu, “Jinta wiyirr marrngurrangu kurlujartiny yija waninyikinyayi. Panypanyakinyijiya, munu pinakarrimijiya. Wurrarnakinyiyarninyi ngarrakuny kurlujartiny jinaku, wirlarnakinyiyarninyipa. Palajalu wirlalamarnajaninyi marlkarri wiyirr. ");
INSERT INTO nna_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","16","Box wirtujina nganimarta yarni malaman nyuntulu, boat-ku, mangkurtungamarra. Mungkaja yarni malaman. Kankarni kangkuliny mangkurtulu. Wirtu jilaman yija, makanupa walpurra yarni malaman. ");
INSERT INTO nna_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mangkurtu jilamarnajanaka wirtu. Wirtulu ngapalu kunulinyjaninyi. Nyuntu wanka kalkulumarnanta. ");
INSERT INTO nna_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ngalpuluman, nyuntupa nyupa nyuntumilipa partanykarrangu nyumpalamilipa nyuparrangu janamili. ");
INSERT INTO nna_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Kunmu jilijaninyi kuwiyirrangupa wirrujartinyarrangu, wiyirr jungkanga marnti yananyakatarrangu ngalpa jilamanjaninyi boat-ja wirtujinanga. Kunmu jilamanjaninyi kuwiyirrangu, nyupangkanya nyupangkanya. Warinypa wariny mankulumanjaninyi, ngalpa jinaku boat-ja wirtujinanga. Wankangarra kalkulumarnajaninyi mangkurtungumarra. ");
INSERT INTO nna_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Mayikupa warinypa wariny ngarnipilijanaka, nyurraku pukun mayi boat-ja wuru jilinyurruka.” ");
INSERT INTO nna_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Yijalmarta jirnili Ngarrkanga Noah-lu, boat wirtu yiji yarni marna. Mungkaja yarni marna, makanupa walpurra. Mayipa wirtu warinypa wariny kuru marnapa ngalpa jirni. Yijalu wiyirr jirni Noah-lu muwarrja Ngarrkamilija. ");
INSERT INTO nna_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Palaja wurrarnalu Ngarrkalu, “Jampa pungkaliny ngapa wirtu nyarra. Nyampa jarrayi, boat-ja ngalpayi, nyuntupa nyuntumilirrangu. Nyuntujakun ngalypakata, nyuntujakun pinakarrinyikinyijin. Palajalu nyuntupa nyuntumilirrangu wanka kalkulumarnanyurrinyi. ");
INSERT INTO nna_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Nyarrarrangu kuwiyirrangu yini marnarna 'clean' kaninykurtingi 7 kawajaninyi, nyupangkanya nyupangkanya, pirirripa mirtawa, ngalpa jilijaninyi. Nyarrarrangu kuwiyirrangu yini marnarna 'unclean' kaninykurtingi waraja nyupangkanya kawapulinyi, pirirripa mirtawa, ngalpa jilijaninyi. Nyarrarrangu wirrujartinyarrangu pukun 7 kawajaninyi nyupangkanya nyupangkanya, pirirripa mirtawa, ngalpa jilijaninyi. Mangkurtu wirtujina yananyajalu, nyirrirnikartijarrangu janamili jirrja yankulupiyi warrarnja nyarrakurnujirri. ");
INSERT INTO nna_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Karrpurrangu 7-ja ngapa wirtu yiji ngakalamarna, jurrirti pilkuliny karrpurrangu karrpurrangu, 40 karrpurranguku yija. Jalakartirrangu boat-ja mangkurtulu wirtulu marlkarri wirlalkulinyjaninyi.” ");
INSERT INTO nna_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah-lu wiyirr jirni muwarrja Ngarrkamilija. ");
INSERT INTO nna_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mangkurtu milpanyaja warrarnja wakanyja, Noah 600 partunurrangujartiny. ");
INSERT INTO nna_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ngalpanyayi Noah-pa mirtawa palinymilipa partany pirirri janamili kujarrapa warajapa mirtawarrangu janamili, palarrangujakun, boat-ja ngalpanyiya mangkurtu ngapajamarra. ");
INSERT INTO nna_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Boat-ja kaninykurtinga kanyayi kuwiyirrangupa wirrujartinyarrangu, “clean”-pa “unclean”, jungkanga marnti yananyakatarrangupa, pirirripa mirtawa, Ngarrkamilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Karrpurranguja 7-ja mangkurtu wirtujina turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah 600 partunurrangujartiny jarrinyaja, wirlarraja warajaja, wirlarranga warinyja partijirringa, karrpu 17-ja, kaninykartija jungkaja purlpurlpukarra ngapa wirtu turlpanya, mujunguja ngapa pungkanya pukun, mangkurtu wirtu yiji turlpanya. ");
INSERT INTO nna_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ngapa pungkanya 40 karrpu, pungkanya kawarnikinyi, jurrirti pirnikinyi, pungkanyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Palangarra Noah-pa mirtawa palinymilipa partany pirirri janamili kujarrapa waraja, Shem-pa Ham-pa Japheth, janamili mirtawarrangu pukun, boat-ja ngalpanyiya. ");
INSERT INTO nna_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Wiyirrja kuwiyi, wirtupa wupartu, jarntupa wariny, wirrujartinypa jungkanga yananyakata, pirirripa mirtawa, ngalpanyiya boat-ja ");
INSERT INTO nna_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","muwarrja Ngarrkaja. Palaja jawapirti yamarna Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","20","Mangkurtu 40 karrpuku waninyi. Kankarrkurnu boat ngapalu kanya, ngapanga kankarningi waninyikinyi. Warnkupa mungkapa parlpu yamarnikinyi mangkurtulu. Ngapa raa karntinyi:::, 8 metres kanka warnkumarramarranga. Mangkurtu wirtujina yija. Marntiyarrakartipa nyuparrangu janamilipa kuwiyirrangu boat-ja waninyikinyiyi wanka. ");
INSERT INTO nna_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Jinta marlkarri jarrinyiyi, kuwiyirrangupa wirrujartinyarrangupa jungkanga marnti yananyakatarrangupa marrngurrangu pukun, wiyirr jalakartija, mangkurtulu marlkarri jirnijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Wiyirr jungkanga punarranga ralyu-ralyujartiny marlkarri jarrinyi, mangkurtulu marlkarri kunanyajaninyi wiyirr. ");
INSERT INTO nna_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ngarrkalu jungkaja marlkarri wiyirr. Yirrkulu Ngarrkalu kalkurnukinyijaninyi boat-ja Noah-nga. ");
INSERT INTO nna_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pala mangkurtu yirrku waninyi kanka 150 karrpurrangunga. ");
INSERT INTO nna_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ngarrkalu munu kakurnamajaninyi Noah-pa wiyirr kuwiyirrangupa wirrujartinyarrangu boat-ja. Wangal ngakarna. Ngapa kaniny jarrinyikinyi jinu, kujarrapa kujarra wirlarrarrangungu. ");
INSERT INTO nna_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Pala ngapa purlpurlpa jarrinyikinyi jipi jirni Ngarrkalu, pala ngapa pungkanya mujunguja jipi jirni pukun. ");
INSERT INTO nna_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Mangurtu kaniny jarrinyikinyi jinu, 150 karrpurrangunga. ");
INSERT INTO nna_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Wirlarranga 7-ja, karrpu 17-ja, boat warnkunga kankajirringi kajarna, warnkumarramarranga kankarni, ngapinga, Ararat-ja. ");
INSERT INTO nna_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Yirrkulu ngapa kaniny jarrinyikinyi, kaniny jarrinyikinyi, wirlarranga 10-ja, karrpu 1-ja, miral jarrinyiyi warnkurrangu jurnturtu, ngapapurnija. ");
INSERT INTO nna_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Palaja, karrpuja 40-ja kaarnka ngakarna Noah-lu. Kaarnkalu kanyjirnikinya jungkaku punarrakupa mungkaku. Ngarrakuny yana, munu kulpama. Kanka marra jukurti pirnikinyi. Yarti ngapa yananyajapa jungka punarra jarrinyi, pala kaarnka ngalypa. ");
INSERT INTO nna_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","9","Palaja, karrpuja 7-ja, Noah-lu wariny wirrujartiny ngakarna, kurlukuku. Partarl kanyjirnikinya jungkaku punarraku. Jampa kulpanya boat-karti. Parirr jirrarna Noah, kajarna kurlukuku parirrja, ngalpa jirni kaninykarti boat-ja Noah-lu. ");
INSERT INTO nna_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Karrpungu 7-ja mimarnakinya Noah. Palaja yarrana ngakarna kurlukuku. ");
INSERT INTO nna_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ruka-ruka kulpanya boat-karti, parrka kanya jawanga. Noah-lu wurrarna, “Ngapa kaniny jarrinya kawaninyi.” ");
INSERT INTO nna_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Palaja karrpuja 7-ja, yarrana yakurr marnalu kurlukukuku. Ngarrakuny yana, munu kulpama. Yirrirni jungka. ");
INSERT INTO nna_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noah 601 partunurrangujartiny, wirlarra1-ja, karrpu 1-ja, ngapa yana, jungka punarra jarrinyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Palaja Noah yamanapinti boat-mili yinyji pirni, parrjarn-parrjarna. Jungka yijalu punarra jarrinyikinyi, kararr waninyi jungka. ");
INSERT INTO nna_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","17","Palaja Noah-nga wurrarnalu Ngarrkalu, “Katukalkulinyurru, kuwiyirrangupa wirrujartinyarrangu katu jilkulinyurrujaninyi. Jirrja jarrinyaku jana, kurrngal jarrinyaku ngunarrijirringi.” ");
INSERT INTO nna_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Palaja katukarnayi boat-ja Noah-pa palinymili mirtawapa partanykarrangupa ngarrayarrangupa, nganin-nganin kuwiyirrangupa wirrujartinyarrangu. ");
INSERT INTO nna_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Warnkurrangu wuru jirnijaninyi Noah-lu. Kujarrapa waraja manajaninyi “clean” kuwiyirrangu jarnturrangupa kujarrapa waraja “clean” wirrujartinyarrangu jarnturrangu, Ngarrkanga yinganyaku. Wirlarnajaninyi, warnkunga wurunga kankarni winyjapa majangu kamparnajaninyi tikirlkartijakurl, jurnpakartijakurl. Palajun jirnikinyayi walangkarrangu, Ngarrka pikaly jinaku. ");
INSERT INTO nna_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Puntaju Ngarrkalu wurrarnarninyi yija, “Marrngurrangulu kurlu jirnikinyiyi yija. Palajalu kurlu jirnirni warrarnku wakanyku. Munu yarrana palajun jilamarna. Marrngurranguku miranu ngaju. Partany waninyaja kurlujartinyngarrajakun jirnaku kurrngarnakinyiyarningu. Munu yarrana marlkarri wirlalamarnajaninyi marrngurrangupa kuwiyirrangu wiyirr yija, marrngurrangulu kurlu jinaja. Warajamalja jirnirni. Munu yarranakanu. ");
INSERT INTO nna_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Kuwarringa yurrangapa partunu yajalkulinypularninyi, karrpupa warrukarti yajalkulinypularninyi, parrpakarrapa wararri yajalkulinypularninyi. Palajunngarra jarrulupiyi ngarrakuny.” ");
INSERT INTO nna_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Noah-ngapa partanykarrangungu ngalypalu muwarr pirnijanaku Ngarrkalu. “Partanykarrangu kurrngal kangkulinyurru. Ngunarrijirringi wantulupiyi. ");
INSERT INTO nna_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kuwiyirranguku wiyirrku nyampali wantulinyurru, wirnti wantulupiyi nyurraku kuwiyipa wirrujartinypa marnti yananyakatapa janpamalu. ");
INSERT INTO nna_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kuwarri yinganyarnanyurrinyi ngananyaku jana wiyirr, janpamalupa kuwiyirrangupa wirrujartinyarrangu. Purlpi mayijakun nganinyikinyinyurru. Kuwarringi kuwiyi pukurl ngalkulinyurru. ");
INSERT INTO nna_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pijirri munu ngananyaku nyurralu. Kuwiyi ngananyarrulinyurru, pijirri yakarnarrulinyurra ngananyawayi. ");
INSERT INTO nna_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","7","Marlkarri wirlanaku marrnguku munu. Ngalypaku wantayi marrngukarra. Marrngurrangu ngajukapali jinarnajaninyi. Palajalu munu marlkarri wirlalinyurrulu marrngu. Nganurtulu marlkarri wirlanaja marrngu, palinyngarra marlkarri wirlalkuliny nyurralu puntaju. Kuwiyilupa marlkarri wirlanaja marrngu, puntaju marlkarri wirlalkuliny nyurralu.” ");
INSERT INTO nna_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","10","Muwarr wurrarnajanaku yarrana Ngarrkalu, Noah-ngapa palinymili partanykarrangungupa. “Nyungu muwarr yinganyarnanyurrinyi, nyurrapa, nyurramilirrangupa, kuwiyirrangupa, wiyirrku jungkangaku. ");
INSERT INTO nna_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nyungujalu muwarrjalu ngajumilijalu munu marlkarri wirlalamarnajaninyi marrngurrangupa kuwiyirrangupa nganin-nganin mangkurtulu. ");
INSERT INTO nna_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nyungujajajakurl, jipi wantulinypa. Muwarr kuwarri yinganyarnanyurrinyi, ");
INSERT INTO nna_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ngurnungu wirrirnirni ngajumili rayinpuwu mujungungu. ");
INSERT INTO nna_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Ngakarnarrulumarna nyurraku mujungurrangu ngapajartiny, palanga rayinpuwu ngajumili wirrilamarna mujungungu. Yija yirrilamarna pala. Yirrinaja, yija kurlka jarrulumarna muwarr nyarra ngajulu wurrarnarna. Pala rayinpuwu mujungunga kurlkali marnapinti muwarrku ngajumilaku nyarraku. Pala tarn-tarn muwarr ngajumili nyurrakupa kuwiyirrangukupa, jungkangaku wakanyku. Munu wiyirr marlkarri wirlalamarnajaninyi mangkurtulu. Palajajakunngarra wantulinypa.” ");
INSERT INTO nna_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Palarrangu Noah-mili partanykarrangu, Shem-pa Ham-pa Japheth, boat-ja milpanyayi. (Ham-ngarra japartu Canaan-ku.) Partany kanyayijaninyi kurrngal. Nganyjurru kuwarri palajarrangu wiyirr milpanyinyi. ");
INSERT INTO nna_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Mangkurtuja wirtujinaja Noah jungka karli-karlinyikinyi, vineyard wirrirni, grapes-ku. ");
INSERT INTO nna_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Grapes-ja wayin yarni marna. Karrpu warajanga, wayin minpinaja, karija jarrinyi. Kalikungu karta karrinyi, kurta. ");
INSERT INTO nna_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, Canaan-mili japartu, yirrirni japartumarniny Noah kurta waninyi. Kaliku jalakarti yana, marrkajirringi wurrarnapulaku. ");
INSERT INTO nna_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Palaja Shem-pa Japheth ngapi manapulu, ngurriny manapulu, ngurntinga kanka kanyapulu, purl-purl marnti yanapulu, japartumarniny wartu jirnipulu. Palajunju jinaja warinykarti parrjarnapulu, japartu kurta yirrinangamarra. ");
INSERT INTO nna_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kananakanu karijaja Noah miranu jarrinyi palaku, palajun jirni nyirtingunyalu palinymilalu Ham-ju. ");
INSERT INTO nna_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Palaja yumpu wirrirnala Canaan-ja, Ham-mili partany. “Canaan-ku yumpu jarrulkuliny. Warrkamukatapirrayi wantujanakuli mamajirranguku.” ");
INSERT INTO nna_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","27","Palaja wurrarna Noah, “Ngarrka nyurra malayili marrngurrangulu, Nyampali Shem-ku, wantulali warrkamukata palinymili Canaan! Ngarrkalu warrarn Japheth-mili jirrali! Japheth-pa Shem nganiwarralpirtijartiny jarrupululu, Shem-ku warrkamukata jarrulula!” ");
INSERT INTO nna_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mangkurtuja wirtujinaja Noah 350 partunurrangungu waninyi. ");
INSERT INTO nna_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Partunurrangu 950 waninyi, palaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noah-mili partanykarrangu kujarrapa waraja, (malyurta) Shem-pa (nyirtingunya) Ham-pa (murrkangunya) Japheth. Mangkurtuja wirtujinaku partanyarrangu turlpanyayijanaku. ");
INSERT INTO nna_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japheth-mili partanykarrangu: Gomer, Magog, Madai, Javan, Tubal, Meshech, Tiras. ");
INSERT INTO nna_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer-mili partanykarrangu: Ashkenaz, Riphath, Togarmah. ");
INSERT INTO nna_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan-mili partanykarrangu: Elishah, Tarshish, Kittim, Rodanim. ");
INSERT INTO nna_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nyirrirnikartijarrangu janamili kujungurruwarrangu, boat-ku yarni-yarnirrangu. Jirrja yanayi warrarnarrangukarti. Warajapa waraja warrarn walja ngurrju marnayi, muwarr walja muwarr pinayi. ");
INSERT INTO nna_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham-mili partanykarrangu: Cush, Egypt, Put, Canaan. ");
INSERT INTO nna_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cush-mili partanykarrangu: Seba, Havilah, Sabtah, Raamah, Sabteca. Raamah-mili partanykarrangu: Sheba, Dedan. ");
INSERT INTO nna_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush japartu jarrinyi Nimrod-ku. Nyarra Nimrod nyampalikata jarra-jarrinyi, kamparta, juji-jujirnikinyi Ngarrka. His name means “Let us revolt!” ");
INSERT INTO nna_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kuwiyimartapa yija paliny. Yarti wurrarnikinyiyalu palinyku, “Nyungu pirirri Nimrod-kapali, kuwiyimarta yija, Ngarrka juji-jujinakata.” ");
INSERT INTO nna_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","King jinarninyi warrarnja Babylonia. Palanga warrarn nyungurrangu cities: Babel, Erech, Akkad, Calneh. ");
INSERT INTO nna_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Palaja warrarn jirrarnarningu Assyria-karti. Yarni marna cities, ngapirrangu, Nineveh, Reheboth-Ir, Calah, ");
INSERT INTO nna_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen. (City wirtu yiji pala, partijirri Nineveh-pa Calah). ");
INSERT INTO nna_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Egypt-mili partanykarrangu: Lud, Anam, Lehab, Naphtu, Pathrus, Casluh, Caphtor. (Palarrangu Philistines Casluh-mili nyirrirnikartijarrangu.) ");
INSERT INTO nna_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","Canaan japartu Sidon-ku, murrkangunya palinymili, Heth pukun. (Pala Sidon japartu jarrinyijanaku Sidonians-ku.) Nungujajirri Canaan-mili nyirrirnikartijarrangu: Jebus, Amor, Girgash, Hivi, Arki, Sini, Arvad, Zemar, Hamath. Yarti nyungurrangu wiyirr jirrja yanayi:::, ");
INSERT INTO nna_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","janamili warrarnarrangu Sidon-ja Gerar-karti but not as far as Gaza-kartijakun. Ngurnunguja kakarrakurti Sodom-kartipa Gomorrah-pa Admah-pa Zeboiim, Lasha-martaji. ");
INSERT INTO nna_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nyarrarrangu Ham-mili nyirrirnikartijarrangu, waraja-waraja clan-jartiny walja, warrarnjartiny walja, muwarrjartiny walja. ");
INSERT INTO nna_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem japartu jarrinyijanaku partany pirirrimarta pukun. Shem japartu wiyirrku marrngurranguku warrarnja Eber-nga waninyiyi. ");
INSERT INTO nna_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem-mili partanykarrangu: Elam, Asshur, Arphaxad, Lud, Aram. ");
INSERT INTO nna_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram-mili partanykarrangu: Uz, Hul, Gether, Meshech. ");
INSERT INTO nna_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad japartu Shelah-ku. Shelah japartu Eber-ku. ");
INSERT INTO nna_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kujarra partany pirirri ngayarta jarrinyipulu Eber-ku. Waraja yini Peleg. Nyarra waninyaja marrngurrangu jirrja yanayi. Separated, a reference to the confusing of the language at Babel. Peleg-mili marrka Joktan. ");
INSERT INTO nna_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan-mili partanykarrangu: Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO nna_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO nna_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO nna_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, Jobab. Nyarrarrangu wiyirr Joktan-ja. ");
INSERT INTO nna_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Warrarnarrangu janamili Mesha-ja Sephar-karti, warnkumarramarranga kakarrakurtinga. ");
INSERT INTO nna_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nyarrarrangu Shem-mili nyirrirnikartijarrangu, waraja-waraja family-nga waljanga, warrarnja waljanga, muwarr pirnikinyi muwarr janamili walja “identified by their clans and languages, in their territories and nations.”. ");
INSERT INTO nna_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nyarrarrangu clans Noah-milirranguja pirirrimartarranguja, palajun “arranged by nations according to their lines of descent”. ");
INSERT INTO nna_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Palaja punja waraja muwarr ngarrany muwarr pirnikinyiyi marrngurrangulu. ");
INSERT INTO nna_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kakarrakurnu yana-yananyikinyayi. Parlkarranga wirtungu turlpanyayi, kakarrakurnungu. Yini pala warrarn Babylonia. ");
INSERT INTO nna_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Muwarr pirnayarningu, “Munu jirrja yankuluminyi, ngunarrikurnujirri. Kunmu wantuluminyi. Nyungungungarra wantuluminyi, ngatu. Ngurra wirtu yarni malaminya, warnkukapali pukurl wirtu yarni malaminyi, nganimarta yiji, kankakurnu, parlparrkartijakun. Wiyirrju jintarrangulu nganyjurru wurralapiyinganyjurrinyi. Wurralapiyi, ‘Ngurnungurrangu marrngurrangu Babylonia-nga, yalyjirr waninyayi, miranu yiji jana.’” Parla maninyikinyiya, purikarrangu jirnikinyiya, kamparnakinyiyi wikanga kararr jinaku, kurrngal yarni marnakinyiyi yija. Kulurnu mantarnakinyayijaninyi bitumen-ju. Yarni marnayi, yarni marnayi. ");
INSERT INTO nna_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","6","Ngarrkangarra milpanya pala city-pa tower-ku yirrinaku. Miranu waninyikinyajanaku. Wurrarna palinyju, “Kunmu waninyayi, warajajakun muwarrjartiny. Palajalu nyungungarra jirniyi. Yarti nganiwarralpirtiku karrinyayi, pala jilkulupiyi. Yarranakanu jiti kurlu jiliyili. ");
INSERT INTO nna_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Yuu, palangamarra katukalkunya, nyunypaly jilaminyijanaku muwarr, warinypa wariny muwarr pilipiyi. Palaja munu kurlkapirli wantulupiyarningu.” ");
INSERT INTO nna_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Pala jirni Ngarrkalu. Nyunypaly jirni muwarr janamili. Wiyirr jirrja jirnijaninyi ngunarrijirri. Munu yarranakanu yarni marnamiyi ngurra wirtujina janamili, warnkukapalipa wirtujina yija. Yakarnayi kuta ngarrany, kakuputu yakarniya. ");
INSERT INTO nna_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Yini pala ngurra “Babel”. Pala muwarr “Babel” wurraninyi, “Kakurnayarningu Muwarr Yajarri.” Ngurnjurn-ngurnjurnayarningu muwarrku. ");
INSERT INTO nna_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nyungurrangu nyirrirnikartijarrangu Shem-mili Arpachshad-ja. Mangkurtu jarrinyaja kujarra partunujirrija, Shem 100 partunurrangujartiny, japartu jarrinyi pirirriku partanyku, yini marna Arpachshad. ");
INSERT INTO nna_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Palaja Shem wanka jarrinyikinyi 500 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpachshad 35 partunurrangujartiny jarrinyaja, partany pirirri kanya, Shelah. ");
INSERT INTO nna_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Palaja Arpachshad wanka jarrinyikinyi 403 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah 30 partunurrangujartiny jarrinyaja, partany pirirri kanya, Eber. ");
INSERT INTO nna_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Palaja Arpachshad wanka jarrinyikinyi 403 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber 34 partunurrangujartiny jarrinyaja, partany pirirri kanya, Peleg. ");
INSERT INTO nna_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Palaja Eber wanka jarrinyikinyi 430 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg 30 partunurrangujartiny jarrinyaja, partany pirirri kanya, Reu. ");
INSERT INTO nna_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Palaja Peleg wanka jarrinyikinyi 209 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu 32 partunurrangujartiny jarrinyaja, partany pirirri kanya, Serug. ");
INSERT INTO nna_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Palaja Reu wanka jarrinyikinyi 207 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug 30 partunurrangujartiny jarrinyaja, partany pirirri kanya, Nahor. ");
INSERT INTO nna_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Palaja Serug wanka jarrinyikinyi 200 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor 29 partunurrangujartiny jarrinyaja, partany pirirri kanya, Terah. ");
INSERT INTO nna_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Palaja Nahor wanka jarrinyikinyi 119 partunurrangu, partanykarrangu pirirripa mirtawa kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah 70 partunurrangu jarrinyi, palaja japartu jarrinyi Abram-kupa Nahor-pa Haran. ");
INSERT INTO nna_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","28","Punjaja nyarraja mangkurtuja wirtuja pirirri turlpanya, yini paliny Terah. Ngurrara paliny warrarnja Chaldea-nga. Tawunja waninyikinyi, yiningi Ur-unga. Paliny partanykarrangujartiny kujarrapa waraja, yini Nahor-pa Abram-pa Haran. (Nyarra Haran partanykarrangujartiny, partany yini Lot, kurntaljirri yinijirri Milcah-pa Ishcah.) Wankanyungu Terah-nga, Haran marlkarri jarrinyi, palinymilingi warrarnja, palanga tawunja Ur-unga. ");
INSERT INTO nna_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Warajanga jarrinyipulu Nahor-pa Haran-mili kurntal, Milcah. Warajanga jarrinyipulu Abram-pa Sarai, nyungujirri. ??Translation Team to decide. ");
INSERT INTO nna_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai-lu munu partany kangama, partanymajirri waninyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Palaja Terah-lu yakarna pala tawun. Kanyajaninyi palinymili partany, Abram, palinymili ngarraya, Sarai, palinymili karluji, Lot, janajakun. Karakurnu yananyikinyiyi warrarnkarti warinykarti, Canaan-karti. Partijirri kajarnayi, tawunja yiningi Haran-ja. Palamanga ngatu waninyiyi punja. ");
INSERT INTO nna_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Palamangangarra marlkarri jarrinyi Terah, Haran-ja. Ranyji yija-yiji paliny, partunurrangujartiny kurrngaljartiny, 205-jartiny. ");
INSERT INTO nna_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Purlpi Ngarrkalu wurrarnili Abram-ja, “Yakalaman warrarn nyuntumili, yakalamanjaninyi jarntu marrngurrangu, yakalaman ngurra japartumili. Warrarnkarti warinykarti yankuluman, jurti jilamarnangu, nyuntu palanga turlpanyajalu wurralamarnangu, 'Nyungungarra nyarra warrarn.' ");
INSERT INTO nna_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Yungkulumarnanta jamuji karlujirrangupa kurrngal yiji jarrulupiyi, nyirrirnikartijarrangu pukun. Nyuntu wirtu nyampali jilamarnanta, ngalypa yiji jilamarnangu. ");
INSERT INTO nna_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Jintalupa ngalypa jilipiyingu, puntaju ngalypa jilamarnajanaku ngajulu. Jintalupa kurlu jilapiyingu, puntaju kurlu pilamarnajanaku ngajulu. Nyuntumilirranguja ngalypa jilamarnajanaka wiyirrku marrngurranguku, wiyirrja ngunarrijirri warinyja warrarnjarrangu.” ");
INSERT INTO nna_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Palaja Abram yana, Ngarrkamilija muwarrja. Palanga mirtanya paliny, partunurrangujartiny 75-jartiny. Kanyajaninyi mirtawa palinymili, Sarai, palinymili marrkamili partany pukun, Lot, kanyajaninyi kuwiyirrangupa wurrukarra palinymili. Marrngurrangu pukun kanyajaninyi, wiyirr warrkamukatarrangu palinymili, ngurrju marnajaninyi palanga tawunja, Haranja. Yakarnaya Haran, yananyikinyiyi kurilakurnu, warrarnkarti Canaan-karti. Ngurrarrangu ngurra yananyikinyiyi. Kajarniyi palanga, warrarnja Canaan-ja. ");
INSERT INTO nna_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Yaninyikinyiyi. Partijirri Canaan-ja ngarrany karta karrinyiyi wirtungu mungkamartaji, yarta jirniya ngapingi, palamartaji mungkamartaji yini Moreh. Tawunmartaji Shechem-martaji mungka pala. (Palanga ngarrany kajarniyijanaku palanga warrarnja Canaan-ja ngurrararrangu.) ??Translation Team to decide. ");
INSERT INTO nna_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Palaja Abram-ku miral jarrinyalu Ngarrka, wurrarnili, “Nyungungarra warrarn yungkulumarnajaninyi jamuji karlujirrangu nyuntumili.” Palajalu palanga warnkurrangu kuru marna Abram-ju, wuru jirni. Palanga ngarluja nyurra marna Ngarrka. ");
INSERT INTO nna_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Palaja yanayi kurilakurnu, warnkumarramarrakarti, kakarra ngapija, Bethel-ja. Ngurra yarta jirniyi partijirri Bethel-japa Ai-ngi, palanga kaliku janamili yarni marnayi. Yarrana warnkurrangu kuru marna, wuru jirni, palanga ngarluja nyurra marna Ngarrka. ");
INSERT INTO nna_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Palaja kurilakurnu yananyikinyiyi, ngurrarrangu ngurra, yananyikinyiyi pirrakarti. ");
INSERT INTO nna_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Palaja pala warrarn punarra jarrinyi, ngapamajirripa mayimajirri. Kurluny-kurlunyja waninyikinyiyi Abram-pa palinymilirrangu kuwiyirrangu. Palaja Abram-jupa palinymilirrangulu yakarniyi pala warrarn, karakurnu yanayi palakarti warrarnkarti, ngapikarti, Egypt-karti, ngurraku yarta jinaku palanga. ??Translation Team to decide. ");
INSERT INTO nna_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Yananyajalu Abram-ju wurrarnili mirtawanga palinymilingi, “Nyuntu ngumpa ngalypa. ");
INSERT INTO nna_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ngurnungurrangulu pirirrimartalu Egypt-ja parrjanajalu, nyuntuku karrulupiyingu. Yijapa wurralapiyarningu, 'Pala mirtawa palinymili. Pirirri wirlalkunyalu, mirtawa wankanyu kalkuluminyi.' ");
INSERT INTO nna_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Palangamarra wurralamanjanaku, 'Nyungu mamaji ngajumili.' Palajun jinajalu, munu wirlalaminyiyi, ngalypalu parrjana wirrilaminyiyi.” ");
INSERT INTO nna_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Palanga warrarnja kajarnapulu, Egypt-ja. Ngurrararrangulu Sarai yirrirniyi. Wurrarnikinyiyi, “Pala mirtawa ngumpa ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Warinyarrangulu wirtulu parrjarnikinyiyi paliny, nyampalingi wirtungu janamilingi wurrarniyili, “Payi! Pala mirtawa, marrka Abram-umili, yija-yiji ngumpa ngalypa.” Nyampalilu karra marnajanaku, “Pala mirtawa ngajuku kangkulupijinyurru.” Kanyayalu Sarai nyampalikarti. ");
INSERT INTO nna_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Puntaju Abram yinyala nyampalilu kurrngal kukurnjaripa purlikapa tangkipa kamal, marrngurrangu warrkamukatarrangu, pirirrimartapa mirtawanyjarri. ");
INSERT INTO nna_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Sarai waninyikinyi wirtungu nyampalimilingi ngurranga. Palajunjalu Ngarrkalu nyampalipa wurrku jirnijaninyi palinymilirrangu. Wurrku wirtu yija jarrinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Palaja nyampalilu muwarr ngakarnalu Abram-ku, “Kurtali.” Warnta marna, “Kurlu jirnijin, nyuntulu! Mitu marnanyin, nyungu mirtawa nyuntumili. ??Translation Team to decide. ");
INSERT INTO nna_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nganijalu muwarr pirnin, 'Marrka ngajuku'? Nyuntumilija muwarrja kanyarna mirtawaku. Nyungungarra mirtawa nyuntumili. Kawa! Jipi yarrapulu ngarrakuny!” ?? ");
INSERT INTO nna_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Wurrarnajanaku pirirrimartanga palinymilingi jurtu ngakalapiyi Abram. ?? Translation Team to decide. ");
INSERT INTO nna_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Palaja Abram-ju yakarna Egypt, pirrakarti warrarnkarti Canaan-karti kulpanyi. Kanya palinymili mirtawapa palinymili marrkamurninymili partany, Lot, kanyajaninyi warrkamukatarrangupa wurrukarra wiyirr. ");
INSERT INTO nna_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Palanga Abram kurrngaljartiny yija-yiji kuwiyirrangujartiny, kukurnjari, nanikutu, purlika, tangki, kamal, miji-mijipa warnku, ngani warralpirti. ");
INSERT INTO nna_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ngurrarrangu ngurra yaninyikinyiyi, kulpanyiyi nyarrakarti ngurrakarti Bethel-martaji. ");
INSERT INTO nna_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Palangangarra purlpilu Abram-ju kuru marna warnkurrangu, muwarr pirnikinyalu Ngarrkaku. Kulpanyajalu yarrana ngarluja yiji nyurra marna Ngarrka. ");
INSERT INTO nna_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot pukun palanga waninyikinyi, kuwiyirrangupa warrkamukatarrangu, kurrngaljartiny paliny. (Palanga jinta ngurrararrangu pukun nyarranga warrarnja waninyikinyiyi, Canaan-milirrangupa Periz-milirrangu.) Translation Team to decide: should we use “Canaan-mili” or “Canaanite-mili” ?? ");
INSERT INTO nna_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kuwiyirrangu munuyiji palanga warrarnja. Abram-milalu warrkamukatarrangulupa Lot-milalu warrkamukatarrangulu partarl warrulyku kanyjirnikinyiyi kuwiyirranguku. ");
INSERT INTO nna_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Palajalu pulanymilalu warrkamukatarrangulu kulilu yirrirnikinyiyarninyi. ");
INSERT INTO nna_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram-ju wurrarnili Lot-ja, “Ngali waljajirri. Kulimajirri wantuli, kulimajirri wantulupiyi ngajumilipa nyuntumili warrkamukatarrangu. ");
INSERT INTO nna_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nyungu warrarn wirtu. Jinta pilkularninyi. Ngurrju malaman warrarn nyuntumili. Mankuluman nyuntulu palaji warrarn, ngaju yankulumarna warinykurnu.” ");
INSERT INTO nna_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot-ju parrjarn-parrjarna warrarn kakarrakurnu, yirrirni parlkarra pijumartaji, yini pala piju Jordan. Pala warrarn ngalypa yiji, ngapa wirtujartiny, Zoar-kartijakun, Ngarrkamilikapali Garden-kapali, warrarnkapali Egypt-kapali. Palanga parlkarranga waninyikinyipulu tawunjirri, ngapijirri, Sodom-pa Gomorrah. ");
INSERT INTO nna_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ngurrju marna palangarra warrarn Lot-ju, kakarrakurnu yana. Palajun jinta pirnipularninyi Abram-pa Lot. ");
INSERT INTO nna_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram Canaan-ja warrarnja waninyikinyi, Lot-ju parlkarranga ngurra jirni nyarrajirri tawunmartajijirri, wangka Sodom-martaji ngurra jirni. ");
INSERT INTO nna_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Palarrangu marrngurrangu Sodom-ja panypanyikinyiyili Ngarrkanga. Yija-yiji kurlujartinyarrangu jana. (Yarti Ngarrkalu wirlarnapulinyi palajirri yintajirri, Sodom-pa Gomorrah.) ");
INSERT INTO nna_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Palaja Abram-aja wurrarnili Ngarrkalu, “Nyunguja parrjalaman wiyirr ngunarrijirri, yalinyjakurnupa, kurilakurnu, kakarrakurnupa karakurnu. ");
INSERT INTO nna_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nyungu warrarn wakany yungkulumarnanta, nyuntukupa nyuntumilirranguku jamuji karlujirrangukupa nyirrirnikartijarranguku, ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Kalkulumarnajanaku, kurrngal yiji jarrulupiyi. Nyuntumilirrangu partarl yinipa wirrilipiyijaninyi jintalu. ");
INSERT INTO nna_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Jipi yanka-yankuluman nyungungu warrarnja, parrjalaman. Wiyirr nyuntumilingarra. Yungkulumarnarnta ngajulu.” Palajun wurrarnili Abram-ja. ");
INSERT INTO nna_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Palaja Abram-ju yakarna pala ngurra, warinykarti ngurrakarti yana, mungkarrangungu Mamre-nga waninyikinyi, tawunmartaji, Hebron-martaji. Yarrana wuru jirni warnkurrangu, ngarluja nyurra marna Ngarrka. ");
INSERT INTO nna_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Palaja 4 kings, marrngurrangu kakarnija, ngajarrirrangu, kunmu jarrinyiyi, milpanyiyi wirlanaku Sodom-martajiku ngurrararranguku. Yini janamili King Amraphel Babylonia-ja, King Arioch Ellasar-ja, King Chedorlaomer Elam-uja, King Tidal Goiim-uja. Nyarra King Chedorlaomer-lu purlpi nyampali jinarninyi janaku marrngurranguku Sodom-kurtirrirranguku. Jakurlirnijaninyi kulilu yinganyaku warnkuku wirtuku. Palarrangulu Sodom-kurtirrirrangulu warnku yinganyikinyiyalu punja, 12 partunurrangu. Yartikarra karra marnayarningu, “Kuwarringulu munu yungkuluminya warnku Chedorlaomer, jamiliminyi. Munu pinakarruluminyalu.” ");
INSERT INTO nna_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Palajalu King Chedorlaomer Elam-uja nyampalipa warinyarrangu kingirrangu kakarnija kunmu jirniyijaninyi pirirrimarta kulikatarrangu janamili. Palaja yanayi palarrangu wiyirr kulipartinaku Sodom-kurtirriku ngurrararranguku. Kurilakurnu yananyikinyiyi, Sodom karrkarnayi, pala kara waninyi janaku. Wirlarnayijaninyi Rephaim Ashteroth-Karnayim-unga, Zuzim Ham-unga, Emim parlkarranga Kiriataim-unga, ");
INSERT INTO nna_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Horites warnkumarramarranga Edom-unga. Purrja pirniyijaninyi Elparan-kartijakun, pirrakartijakun. ");
INSERT INTO nna_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Palaja warlirniyi, turlpanyayi Kadesh-karti. (Purlpi pala Kadesh-mili yini Enmishpat.) Wirlarnayi warrarn wakany Amalekite-mili, wirlarnayi Amorites Hazazon Tamar-nga. Yartikarra kurningumarra milpanyiyi Sodom-karti. ");
INSERT INTO nna_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Palaja kingirrangu nyarra tawunjarrangu, ngapija, Sodom-ja, Gomorrah-ja, Admah-ja, Zeboiim-uja, Bela-ja, palarrangulu 5 kingirrangu kunmu jirniyijaninyi kulikatarrangu janamili, jantujartiny. Purrpi yanayijanaku palarrangu 4 kingirrangu kakarnijarrangukarti. ");
INSERT INTO nna_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kulipartirnayarninyi Siddim Valley-nga, Dead Sea-martaji, warrarn-ja mawurla-mawurlanga. Partijirringa martuwaringi pirtirrangu kurrngal, ngapijartiny, bitumen-jartiny. Sodom-japa Gomorrah-ja kingijirri kulingimarra mirti jarrinyaja, pirtirrangungu pungkanyiyi. Jinta 3 kingirrangu warnkumarramarrakarti mirti jarrinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Palaja palarrangulu 4 kingirrangulu kakarnijarrangulu wiyirr mayipa wurrukarra kanyayarningu Sodom-japa Gomorrah-ja. ");
INSERT INTO nna_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nyarra Lot, Abram-mili marrkamili partany, Sodom-ja wanikinyi. Kanyayi Lot-pa kanyayi Lot-mili wurrukarra wiyirr pukun. Jinta marrngurrangu pukun kanyayijaninyi. Yakarniyi yananyaku janamilikartiku warrarnkartiku. ");
INSERT INTO nna_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Palangangarra Abram waninyikinyi mungkamartaji Mamre-milimartaji. Mamre-pa palinymili marrkajirri, Eshcol-pa Aner, jana jarntu Abram-uku. Waraja pirirri kulipartinaja mirti jarrinyi, milpanyalu Abram-karti, wurrarnili, “Palarrangulu kulikatarrangulu kakarnijarrangulu kanyayi pujamu nyuntumili, paliny jananga kanyayi.” ");
INSERT INTO nna_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pala muwarr pinakarrinyajalu Abram-ju kunmu jirnijaninyi pirirrimarta kulikata palinymilirrangu. Palarrangu 318 yanayi Abram-ja. Yajarniyijaninyi palarrangu kakarnijarrangu. Mamre-pa Eshcol-pa Aner pukurl yanayi. Nyirrirnilu yajarnakinyiyijaninyi, kaja yalinyjikurnu yanayi, palakarti warrarnkartijakun, Dan-kartijakun. ");
INSERT INTO nna_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Warrukartingi Abram-ju jinta pirnijaninyi pirirrimarta palinymili, jirrja jirnijaninyi. Palangangarra kakarnijarrangu marrjalu wirlarniyijaninyi, mirtingi jirniyijaninyi ngarramarnti, purrja pirniyijaninyi yalinyjikurnu warrarnkarti warinykarti, Hobah-kartijakun, yalinyjikurnu ngapi, Damascus-ja. ");
INSERT INTO nna_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Palaja Abram-milalu Sodom-japa Gomorrah-ja ngurraramili wurrukarra wiyirr kulpanya manayijaninyi, Lot-pa wurrukarra palinymili, mirtawarrangupa jinta jinmurntuja pukun wiyirr. Palaja kulpanyiyi wiyirr kurilakurnu. ");
INSERT INTO nna_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram ngurrakarti jampa kulpanyikinyi, nyarra Sodom kingi purrpi yana, parlkarranga partijirri kaniny mawurlangarrangu, yiningi Shaveh Valley (wariny yini King's Valley.) ");
INSERT INTO nna_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Pirirri wariny, yini Melchizdek, paliny pukun palanga milpanyalu, Abram-ku kanyalu karlu-karlupa wayin. Nyarra Melchizedek nyampali pala tawunku, Salem-ku. Purlpija paliny pukun yatil waninyikinyi Ngarrkaku, palaku Kankajirri Nyampaliku. ");
INSERT INTO nna_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Nyungulu yatilju Melchizedek-ju wurrarnala Abram-ja, “Miranu nyuntu Ngarraku. Kankajirri Nyampali paliny. Parlparrpa jungkapa kujungurrupa wiyirr pukun jirnijaninyi palinyjungarra. Japirr marnarna Ngarrka ngalypa jilkulumanga. Nyurra malkunyi Ngarrka, Kankajirri Nyampali. Palinyju kartuwarra marnanta, nyuntuku kulikata kakarnijarrangu wirlarnajaninyi ngarramarnti.” Palaja Abram-ju wurrukarraja kulpanya jinaja yinyali. 10-ja purlikarranguja yinyali waraja, 10-ja kukurnjarirranguja yinyali waraja, palajun kuwiyirrangupa wurrupa yinyala Melchizedek. ");
INSERT INTO nna_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Palalu Sodom-ju kingilu wurrarnili Abram-ja, “Wurru kulpanya jinajarrangu kalkulumanparningu. Ngajumili marrngurrangukujakun karrinyarna.” ");
INSERT INTO nna_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Puntaju karra marnalu Abram-ju, “Munu kalkulumarnangu wurrukarra nyuntumili, munu yiji. Ngarrka nyampali wiyirrku, palinyjungarra wiyirr jirnijaninyi, parlparrpa jungkapa kujungurru pukun. Purlpi wurrarnarnalu Ngarrkanga munu kalkulumarnangu wurrukarra nyuntumili, munu wupartupa wara. Nyuntulu wurralanpili, 'Ngajulu yija yinyarnalu Abram wurrukarra palinymili wiyirr.' ");
INSERT INTO nna_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Palajun wurralanpili. Palangamarra munu kangkulamarnangu wurrukarra. Puru mayijakun kalkulamarnajanaku wangalanguku ngajumilaku. Nyungurrangu jinta pukun kanyarnajaninyipa ngajungu, Aner-pa Eshcol-pa Mamre. Yuwajaninyi wurrukarra palarrangu pirirrimarta.” ");
INSERT INTO nna_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Palaja kapukarringi Abram-ja miral jarrinyili Ngarrka. Wurrarnala, “Abram-kayi, wirntiwayi. Kalkulumarnanta ngarramarnti ngajulungarra. Yijalu wurrukarra wirtu yungkulumarnanta.” ");
INSERT INTO nna_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram-ju puntaju karra marnalu, “Nyuntukurra nyampali wiyirrku. Nganijalu yungkuliminyin wurrukarra wiyirr nyuntulu? Yirrku partanymajirri waninyarna. Marlkarri waninyaja ngaju, warrkamukatalu ngajumilalu, Eliezer-lu, Damascus-jirrilu, palinyjungarra mankuliny wurrukarra ngajumili. ");
INSERT INTO nna_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Munu yingamanyin partany. Ngajumili wurrukarra wiyirr mankuliny warrkamukatalu ngajumilalu.” ");
INSERT INTO nna_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Puntaju wurrarnala Ngarrkalu, “Munu warrkamukata nyuntumili, munu Eliezer, munu palinyju mankuliny wurrukarra nyuntumili. Partanyju nyuntumilalu waljalungarra, palinyjungarra mankuliny nyuntumili wurrukarra.” ");
INSERT INTO nna_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Palaja jalakarti kayi marna Abram, wurranala, “Parrjala kanka, ngurnungurrangu parrjalajaninyi panikatarrangu. Kurrngal yiji. Munu yinipa wirrirnakanjaninyi, kurrngal. Nyuntumili jamuji karlujirrangu waljapa nyirrirnikartijarrangu pukun kurrngal yiji jarrulupiyi. Munu yinipa wirrilamanjaninyi, kurrngal yiji.” Palajun wurrarnala Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram-ju pinakarrinyi, yijalu yijalmarta jirnili Ngarrkanga. Palajalungarra Ngarrka pikaly jarrinyili, wurrarnarningu, “Kulimajirralu yirrilamarna Abram, wurralamarna, ‘Jurtu yija paliny’.” ");
INSERT INTO nna_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yarrana Ngarrka muwarr pirnili. “Ngajulungarra purlpi wurrarnarnangu warrarnja Chaldea-nga nyuntumili ngurra yakanaku. Nyungukarti milpanyan ngajumilija muwarrja. Nyungungarra warrarn yungkulumarnanta, nyuntumili wantuliny ngarramarnti.” ");
INSERT INTO nna_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Karra marnalu Abram-ju, “Ngarrkakurra, nyampali wiyirrku nyuntu. Wunyjurru miranu jarrulumarna palaku muwarrku, yija pala?” ");
INSERT INTO nna_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Puntaju Ngarrkalu wurrarnala, “Kuwiyirrangu kangkulupijin, waraja purlika, waraja nanikutu, waraja yuramu. Kangkulupijin pukun waraja kurlukukupa waraja jarrala parl-parl.” ");
INSERT INTO nna_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Palarrangu kuwiyirrangu kanyajaninyi Abram-ju, Ngarrkamilija muwarrja. Wirlarnajaninyi wiyirr, palaja purlikapa nanikutupa yuramu parrkarl pirnijaninyi, jinta pirni. Wirrujartiny munu parrkarl pirnimapulinyi. ");
INSERT INTO nna_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ngurlarn milpanyiyi, kajarniyi kuwiyingi. Abram-ju wirntiji pirnikinyijaninyi, yanayi. ");
INSERT INTO nna_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kara ngalpanyajanga panja karta karrinyi yiji Abram. Kapukarringi kartajalu wirnti yiji turlpanyala. ");
INSERT INTO nna_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Wurrarnala Ngarrkalu, “Pinakarra. Ranyji jarruluman, marlkarri jarruluman warrarnja nyungungu, jungkaranga wirrilipiyinti warrarnja nyungungu. Yarti jamuji karlujirrangu nyuntumili yankulupiyi warinykarti warrarnkarti. Munu janamili warrarn, ngajarrimili warrarn. Palangangarra punja wantulupiyi, partunuku 400-ku. Nyarranga warrarnja ngurrararrangulu marrjalu warrkamuku jilipiyijaninyi, warnkumajirriku, puru mayikujakun. Yijalu nyuntumilirrangu punja kalkulupiyijaninyi kurluny-kurlunyja yiji. Palaja puntajulu palarrangu ngurrararrangu wirlalamarnajaninyi. Palaja nyuntumilirrangu walarni jilamarnajaninyi nyungukartijakun, wurrukarra wirtu kangkulupiyi palaja warrarnja. ");
INSERT INTO nna_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Palanga warrarnja wantulupiyi 400 partunurrangu, palaja kulpulupiyi nyungukarti. Munu kuwarri yungkulumarnajaninyi nyungu warrarn. Yartiku. Kuwarringarra palarrangu ngapirrangu, Amorites, jana nyungungu waninyiyi. Nyungu janamili warrarn. Yarti kurlu jinakatarrangu jarrulupiyi, kurlu yiji. Palajangarra wirlalamarnajaninyi, yija nyungu warrarn yungkulumarnajaninyi nyuntumilirrangu.” Palajun wurrarnala Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Karrpu kara ngalpanyajalu, warrukarti jarrinyajalu, ngapijirri yirrirni Abram-ju, wikapinti jungankatapa tilijartiny, partijirringi kuwiyingi kutarrangungu yananyapulu. ");
INSERT INTO nna_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Palanga minyirrju wurranala Ngarrkalu, “Yija-yiji nyungu warrarn yungkulumarnajaninyi nyuntumilirrangu. Warrarn nyunguja ngurnarrikurnujirri yungkulumarnajaninyi, karakurnu Pijukartijakun Egypt-ja, kakarrakurnu pijukartijakun, palakarti Euphrates-kartijakun. ");
INSERT INTO nna_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Kuwarri nyungu warrarn jintamili marlumili. Palarrangu miralamarnajaninyi warrarnku, yungkulumarnajaninyi nyuntumili jamuji karlujirrangupa nyirrirnikartijarrangu.” ");
INSERT INTO nna_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Palanga warrarnja, Canaan-ja, Abram 10 partunurrangu waninyikinyi. Partanymajirri ngarrany. Pala mirtawa palinymili, Sarai, munu partany kangamalu. Wariny mirtawa kalkurnikinyi Sarai-lu, warrarn warinyja, Egypt-ja, warrkamukata mirtawa Sarai-ku, yini paliny Hagar. ");
INSERT INTO nna_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Palanga Abram-ja wurrarnala Sarai-lu, “Nyupakayi, partanymajirri ngaju. Ngarrkalu jamirnanyi partanyku. Ngajumili warrkamukata mirtawa kangkuluman, mirtawaku kawa, nyumpala karta karrapulu. Yijapa partany kangkulupiji.” Puntaju, “Yuu.” ");
INSERT INTO nna_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Palaja Sarai-lu yinyali Abram pala mirtawa Hagar mirtawaku. ");
INSERT INTO nna_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Karta karrinyipulu, Hagar-pa Abram. Palaja Hagar ngarlungka jarrinyi. Palajalu raka jarrinyalu nyampalingi palinymilingi, Sarai-ngi. “Puru yiji paliny”, wurrarna Hagar-lu. ");
INSERT INTO nna_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Palaja Sarai yunturi jarrinyalu Abram-ku. “Yinyarnanta ngajumili warrkamukata mirtawa ngurranga kalkunaku. Kuwarri ngarlungka jarrinyaja raka jarrinyiji. Kurrparninyin nyuntulurla. Wurralamangu Ngarrkalu, ngaju yiji yija waninyirni.” ");
INSERT INTO nna_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram-ju karra marnalu, “Paliny nyuntumili warrkamukata, nyuntu nyampali palinyku. Nganikupa karrinyanpalu, pala jilamanpalu.” Palaja Hagar kurluny-kurlunyja kalkurnukinyi Sarai-lu. Palajalu pirrakarti mirti jarrinyi Hagar. ");
INSERT INTO nna_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Palanga pirranga warrarnja punarranga kajarna Hagar, janukumartaji. Ngarrkalu miral jarrinyili Angel-kapali. ");
INSERT INTO nna_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Palanga wurrarnala, “Hagar-kayi, warrkamukata mirtawa nyuntu Sarai-mili. Wanyjarnija nyuntu milpanyan? Wanyjarnikarti yaninyan?” Puntaju karra marnalu Hagar-lu, “Wirnti mirti jarrinyarnalu nyampalingamarra.” ");
INSERT INTO nna_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Wurrarnala, “Kulpa nyuntumili mijijikarti, pinakarralu. ");
INSERT INTO nna_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kurrngal yiji jamuji karlujirrangu yungkulumarnanta, partarl yini malamanjaninyi, kurrngal yiji. ");
INSERT INTO nna_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ngarlungku nyuntu. Partany kangkuluman, punulku. Yuu, ngangkurl jirnikinyin, pinakarrinyarnanta. Palajalu yini malaman Ishmael. ");
INSERT INTO nna_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Wirtu jarrinyaja paliny kulikata jarrulinyjanaku wiyirrku marrngurranguku, jana wiyirr kulikatarrangu wantulupiyalu palinyku. Kujurlkarringu wantuliny paliny.” ");
INSERT INTO nna_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Palaja wurrarna Hagar-lu, “Yijalu yirrirnirni Ngarrkangarra, wankanyu waninyarni yija, munu marlkarri wirlarninyi.” Yini marna Ngarrka, “Palinyju Yirrkulu Parrjaninyi”. ");
INSERT INTO nna_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Palajunjalu yini marnayi pala januku, “Wankanyulu Yirrininyi”. ");
INSERT INTO nna_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Palaja Hagar kulpanya Sarai-karti. Palaja partany kanyalu Abram-ku, punulku. ");
INSERT INTO nna_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram 86 partunurrangujartiny. Palangangarra Hagar-lu partany kanya. Abram-ju yini marna Ishmael. ");
INSERT INTO nna_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ranyji jarrinyi Abram, partunurrangu 99-jartiny. Palaja yarrana ngayarta jarrinyili Ngarrka. Wurrarnala, “Ngaju Wariny Yiji, marrjapanu yiji. Jinta wiyirr manyurla yiji ngajungu. Pinakarraji ngajuku, ngungkulu jili ngalypa ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Karluji jamujirrangu kurrngal yungkulumarnanta. Muwarr yija-yiji pala yinyarnangu.” ");
INSERT INTO nna_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Murtingi jurlpi-jurlpi jarrinyalu pirrirn jungkanga kaniny Abram. Ngarrkalu wurrarnala, ");
INSERT INTO nna_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nyungu muwarr ngajumili wirrirnarnangu, yija nyuntu karluji wantulumanjanaku kurrngal marrngurranguku. Nyuntumili karluji jamujirrangupa nyirrirnikartijarrangu jirrja jarrulupiyi warinypa wariny warrarnarrangunga. ");
INSERT INTO nna_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Palajalu kuwarri yini wariny yini marnarnanta. Kuwarringulu nyuntumili yini Abraham. Palalu yinilu wurraninyi, “Kurrngalku Japartu”. ");
INSERT INTO nna_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yuu, kurrngal karluji jamujirrangupa nyirrirnikartijarrangu yungkulumarnanta. Jirrja yankulupiyi kurrngal warrarnarrangukarti kajapa wangka. Palarranguja jinta wirtu nyampalirrangu jarrulupiyi. ");
INSERT INTO nna_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nyungu muwarr nyuntukupa partanykarranguku nyirrirnikartijarranguku, wantuliny ngarrakuny. Japartu wantulumarnanyurruku ngaju. ");
INSERT INTO nna_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Yuu, nyungu warrarn, yini marnayi Canaan warrarn, nyuntupa nyuntumili karluji jamujirrangupa nyirrirnikartijarrangu yungkulumarnanyurrinyi. Kuwarri nyungungu warrarnja waninyan ngajarrikapali. Yarti nyungu warrarn wiyirr nyuntumilirrangumili wantuliny ngarramarnti, japartu wantulumarnajanaku. ");
INSERT INTO nna_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","11","Nyuntupa nyuntumilirrangu nyirrirnikartijarrangu yijalmarta jinaku ngarrakunyju ngajumilaku muwarrku. Kuwarringulu pirirri wiyirr nyurramili partanyja pirirri jilipiyijaninyi. Palajun jinajalu miranu jarrulupiyi marrngurrangu wiyirr nyurraku, ngajumili marrngurrangu nyurrangarra. ");
INSERT INTO nna_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Wupartupani karrpurrangu 8-jartinyngarra waninyajanga pilyi malkulunyurrujaninyi wiyirr. Nyurramili warrkamukatarrangu pukun wirrkalkulunyurrujaninyi. Yijapa warrkamukatamili partany pirirri ngayarta jarrulupiyi nyurramilingi ngurrangarrangu. Palarrangu wirrkalkulunyurrujaninyi. Yijapa warnkulu mankulamanjaninyi warrkamukatarrangu warrarnjarrangu ngajarrimilijarrangu. Palarrangu pukun wirrkalkulunyurrujaninyi. Palajun jilkulunyurru. Yijalmarta jiliyi nyungungu muwarrja ngajumilingi. ");
INSERT INTO nna_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Palarrangu munu yijalmarta jinajarrangu munu ngajumilirrangu wantulupiyi. Panypanyajiyi ngajumilingi muwarrja. Palajalu munu japartu wantulumarnajanaku. ");
INSERT INTO nna_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nyungu wariny muwarr wurrarnarnangu. Mirtawa nyuntumili, Sarai, wariny yinijartiny jarruliny. Kuwarringulu munu Sarai yini malaman. Yini malaman Sarah. ");
INSERT INTO nna_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ngalypa jilamarnalu palinyku, partany yungkulumarnanyumpulinyi, partany kangkulumanga Sarah-lu. Sarah-mili nyirrirnikartijarrangu kurrngal jarrulupiyi. Ngunarrikurnujirri jirrja yankulupiyi, warinypa warinyja warrarnjarrangu kajalapiyi. Jinta palarranguja nyampalirrangu wirtu jarrulupiyi.” ");
INSERT INTO nna_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Murtingi jurlpi-jurlpi jarrinyalu Abram, pirrirn jungkanga kaniny jarrinyalu. Nyarru pirnarningu, wurrarnarningu, “Ranyji yija-yiji ngaju, 100 partunurrangu. Wunyjurru kuwarri japartu jarrulumarna partanyku ngajungarra? Sarah ranyji pukun, 90 partunurrangu. Wunyjurru partany kangkuliny palinyjungarra?” ");
INSERT INTO nna_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Palaja Abraham-ju karra marnalu, “Ngarrkakayi, yijapa ngalypa jilamanpalu partanyku ngajumilaku, Ishmael-ku.” ");
INSERT INTO nna_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Puntaju Ngarrkalu karra marnalu, “Yijalu mirtawalu nyuntumilalu, Sarah-lungarra, partany kangkulumanga. Yini malkuluman Isaac. Paliny kalkulumarna ngajulu, ngajumilija muwarrja, palinyngarrapa palinymilirrangu nyirrirnikartijarrangu. Ngajumili marrngurrangu wantulupiyi ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Japirr marnanyin ngalypa jinaku Ishmael-ku. Yuu, pinakarrinyirninti. Ngalypa jilimarnalu palinyku pukun, yungkulumarna kurrngal marrngurrangu. Partanykarrangujartiny pirirrijartiny 12-jartiny jarruliny paliny. Wirtu nyampali jarrulupiyi. Janamili nyirrirnikartijarrangu kurrngal jarrulupiyi. ");
INSERT INTO nna_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Isaac nyarra, palinyngarra ngajumili wantuliny ngarrakuny, wantulumarnalu japartu palinykungarra. Sarah-lu kangkulumanga kuwarrikapali partunu warinyja.” Palajun Abraham-ja wurrarnala Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Jipi muwarr pinaja Abraham-ku Ngarrka yana. ");
INSERT INTO nna_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Pirirrimarta Abraham-milirrangu palinymilingi ngurranga kurrngal yiji, warrkamukata pirirrimarta pukun, jinta purlpi manajaninyi warnkulu, jinta purlpi ngurli-ngurlija wirtu jarrinyiyi palinymilingi ngurranga. Palangarra karrpungu Abraham-ju kunmu jirnijaninyi pirirrimarta wiyirr palinymilingi ngurranga, mirtanyarrangupa partanykarrangu. Palangangarra karrpungu Ngarrkamilija muwarrja Yayipirayamulu wirrkarnajaninyi pirirrimarta wiyirr. Warinyju wirrkarna paliny pukun. Palanga Abraham ranyji pirirri, 99 partunurrangujartiny. Partany palinymili, Ishmael, 13 partunurrangujartiny. Palangangarra warajanga karrpungungarra wirrkanajajirri pirirri jarrinyipulu, Abraham-pa partany palinymili, Ishmael. ");
INSERT INTO nna_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Palaja yarrana Abraham-ja miral jarrinyili Ngarrka. Abraham ngurranga waninyikinyi wirturrangungu mungkamartaji Mamre-ngi. Karrpu kanka. Parrpakarranga waninyikinyi kalikingi palinymilingi, jawapirtingi. ");
INSERT INTO nna_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Parrjarna, pirirrimarta kujarrapa waraja yirrirnijaninyi, wangka wararr karrinyiyi. Wararr karrinyi Abraham, mirti jarrinyijanaku, murtingi jurlpi-jurlpi jarrinyijanaku. ");
INSERT INTO nna_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Wurrarnajanaku, “Munu pipurru yankulunyurru. ");
INSERT INTO nna_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Jampakurra nyungungu kajalkulunyurru mungkanga mirranja. Mankulumarnanyurraku ngapa, jina ngulyalkulunyurrarninyi. ");
INSERT INTO nna_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mayi pukun kangkulumarnanyurraku. Nganinyaja yankulunyurru.” Wurrarniyili, “Yuu. Ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kalikukarti mirti jarrinyi Abraham, Sarah-nga wurrarnala, “Nyampa jarra! Yuntara marra, martumpirri kampalajanaku.” ");
INSERT INTO nna_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Palaja jalakarti yana, purlika mana, yangupala, jinjimama. Wurrarnala warrkamukatanga, “Nyampa jarra! Nyungu kuwiyi wirlala, kampala.” ");
INSERT INTO nna_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Palajun jinaja Abraham-ju kanya kuwiyipa ngama, yinyajaninyi. Nganinyikinyiyi pirirrimartalu, Abraham mungkamartaji wararr karrinyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Waraja palarrangungu pirirrimartanga Ngarrkangarra. Wurrarnala Abraham-ja, “Wanyjarningi mirtawa nyuntumili, Sarah?” “Kalikungu kaninykarti paliny.” ");
INSERT INTO nna_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Karra marnalu Ngarrkalu, “Yija warajaja partunuja kulpulumarna, partany kangkuliny Sarah-lu, pirirri kangkulumanga.” Wangka, kaninykarti kalikungu, pinakarrinyikinyi Sarah-lu. ");
INSERT INTO nna_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Nyarru pirnikinyirningu, wurrarnarningu, “Ranyji ngaju, ngajumili pirirri pukun ranyji. Ngaju ranyjimarta yiji, munu partany ngajulu kanganyakarni!” ");
INSERT INTO nna_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ngarrkalu wurrarnala Abraham-ja, “Nganija nyarru pirni Sarah? Nganija wurrarnarningu, 'Ranyji yiji ngaju, munu partany ngajulu kanganyakarni.'? ");
INSERT INTO nna_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Munu ngurnjurl yiji ngajuku. Yijalu palajunmarta jilamarnalu. Kulpulumarna warajaja partunuja, yijalu partany kangkuliny Sarah-lu.” Palajun Abraham-ja wurrarnala Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Wirntilu mitu marnalu Sarah-lu, “Munu nyarru pirnamarna.” Puntaju karra marnalu, “Yija, nyarru pirnin.” ");
INSERT INTO nna_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Palaja nyarrarrangu kujarrapa waraja wararr karrinyiyi, yanayi, parrjarnikinyiyi Sodom-karti. Jananga yana-yananyikinyi Abraham. ");
INSERT INTO nna_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yananyajanga Ngarrkalu kurlkarri marnikinyirnangu, “Palarrangu marrngurrangu ngurnungujirri tawunjajirri, Sodom-japa Gomorrah-nga ngurrara, kurlujartiny yiji jana. Yijapa marlkarri wirlalamarnajaninyi ngarrakuny. Wunyjurru, wurralamarnalu Abraham-ja palajunmarta jilirnili? Yuu. Wurralamarnala. ");
INSERT INTO nna_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","19","Ngurrjungulu marnarna Abraham, wurralkulinyjanaku palinymilirranguku pinakarralupijiyi ngarrakunyju, ngungku yiji jilipiyi ngarramarnti. Janalu palajun jinaja ngajulu ngalypa jilamarnajanaku ngajumilija muwarrja. Palajalu ngalypa yiji jilamarnajanaku wiyirrku marrngurranguku, warrarnjarrangu wiyirrja. Abraham yungkulumarnalu jamuji karlujirrangupa nyirrirnikartijarrangu kurrngal, palinymilirrangu kurrngal yija-yiji jarrulupiyi, wirtu nyampalirrangu jarrulupiyi.” ");
INSERT INTO nna_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Palaja Abraham-ja wurrarnala, “Miranu nyuntu palarranguku marrngurranguku Sodom-japa Gomorrah-nga. Pinakarrinyirnijanaku, yirrkulu kurlu yiji jirnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Palaja muwarrja yankulumarna, yirrilimarna. Yijapa pala muwarr pinakarrinyaja yija. Munujalu, miranu jarrulumarna.” ");
INSERT INTO nna_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Palaja palajirri warinyjirri pipurru yanapulu Sodom-karti. Ngarrkapa wararr karrinyipulu Abraham. ");
INSERT INTO nna_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Wurrarnala Abraham-ju, “Yijapakurra jinta Sodom-ja ngalypa jinayi, jurtungu yaninyayi. Wunyjurru? Marlkarri wirlalamanjaninyi palarrangu pukun? ");
INSERT INTO nna_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Yijapa 50 marrngu palanga ngalypakata waninyayi. Wiyirr Sodom-ja ngurrararrangu marlkarri wirlalamanjaninyi? ");
INSERT INTO nna_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Munu wirlanaku ngalypakatarrangu, kurlukatarrangujakun wirlanaku. Ngalypajakun jinaku nyuntulukurra.” ");
INSERT INTO nna_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Karra marnalu Ngarrkalu, “Marrngurranguku ngalypa jinakataku 50-ku munu wirlalamarna pala tawun. Puru yakalamarnajaninyi wiyirr.” ");
INSERT INTO nna_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Karra marnalu Abraham-ju, “Puru ngaju, munu japirr manaku ngajulupirrayi. ");
INSERT INTO nna_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Yijapa 45-jakun ngalypakata palanga tawunja. Wunyjurrukurra? Marlkarri wirlalamanjaninyi wiyirr tawunja?” “Marrngurranguku ngalypakataku 45-ku munu wirlalamarna pala tawun.” ");
INSERT INTO nna_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Yarrana Abraham muwarr pirnalu, “Yijapa 40 ngalypakata palanga waninyayi.” “Ngalypakataku 40-ku munu wirlalamarna pala tawun.” ");
INSERT INTO nna_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Palaja wurrarnala Abraham-ju, “Yarrana japirr malamarnanta, munukurra kulilu yirriliminyinpa, yijapa 30-jakun ngalypakata palanga?” “30-ku ngalypakataku munu wirlalamarna pala tawun.” ");
INSERT INTO nna_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Yarrana Abraham marrpalya waninyi. “Yijapa 20-jakun ngalypakata palanga.” “20-ku ngalypakataku munu wirlalamarna pala tawun.” ");
INSERT INTO nna_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Palaja karra marnalu Abraham, “Yarranakurra warajamaljakun japirr malamarnanta. Munukurra kuli jarrulupijin. Yijapa 10-jakun ngalypakata palanga waninyayi.” Puntaju karra marnalu Ngarrkalu, “Yijalu 10-ku munu wirlalamarna pala tawun.” ");
INSERT INTO nna_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Palaja Abraham-ku muwarr pinaja, Ngarrka yana, Abraham ngurrakarti kulpanya. ");
INSERT INTO nna_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Sodom-karti pipurr yanapulu nyarrajirri warinyjirri. Ngakarnapulinyi Ngarrkalu, miyu marrngujirri pulany, yija angel-jirri palajirri. Jarurrukartingi tawunja kajarnapulu. Palanga Lot, nyarra Abraham-mili marrkamili partany, tawunja kayitingi kajarnakinyi. Yirrirnipulinyi, purrpi yanapulaku. Pirntil kanka jarrinyipulaku, milya kaninyju. ");
INSERT INTO nna_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Wurrarnapulaku, “Milpapulukurra ngurrakarti ngajumilikarti. Jina ngulyalkulunyumpularninyi, wantulunyumpulu mayanga ngajumilingi. Marntungu yankulunyumpulu wanyjarniku karrinyaku yaninyaku nyumpala.” Puntaju karra marnapulalu, “Puru wanta. Nyungungarra parlkarranga wantulupalayi warrukartiku.” ");
INSERT INTO nna_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Yirrkulu japirr marnikinyipulinyi Lot-ju palinymili mayanga kajanaku. Palajalu yanapulu ngurrakarti palinymilikarti. Martumpirri lalypapa warinypa wariny ngalypa mayi kanyapulaku. Nganinyikinyipulu. ");
INSERT INTO nna_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kajarnakinyipulu palanga, Sodom pirirrimarta mayakarti milpanyiya. Wangalangurrangupa mirtarrangu, Sodom pirirrimarta wiyirr, jalakarti ngunarrijirri wararr karrinyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lot-ku kamarniyalu, “Wanyjarningi palajirri pirirrijirri nyuntumilikarti ngurrakarti milpanyapulu? Kawapulinyi nganarnaku!” Palarrangu Sodom pirirrimarta kurla-kurla yiji, palajirriku karrinyiyipulaku. ");
INSERT INTO nna_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Jalakarti yana Lot, jawapirti nyirrirnikarti jatamapu jirni. ");
INSERT INTO nna_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Wurrarnajanaku, “Munu palajunmarta jiliyi! Kurlu yija pala. ");
INSERT INTO nna_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Pinakarrayi yiji. Kurntaljirri ngaju, kurrijirrijartiny. Munu pirirringi karta karrimapulu. Kangkurnupulinyi nyurraku palajirri kurntaljirri. Nganikupa karrulunyurru jilkulunyurrupulinyi. Palajirri pirirrijirri ngajarrijirri, yakaliyipulinyi. Ngurrakarti milpanyapulu ngajumilikarti. Yijalu ngajulu kalkulumarnapulinyi.” ");
INSERT INTO nna_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pala muwarr pinakarrinyaja kuli jarrinyiyi. “Yarra! Yarra! Kajaja nyungukarti milpanyan, kuwarri nyampali jilamanparninyi nganarnaku. Kurlu jilipiyirnangu yija.” Lot warinykurnu jujirniyi, partarl jawapirti ngartarnayalu. ");
INSERT INTO nna_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Palaja palalujirri angel-jujirri purrirnipulu Lot kaninykarti mayanga, jawapirti jatamapu jirnipulu. ");
INSERT INTO nna_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Palaja pampuru jirnipulujaninyi palarrangu Sodom pirirrimarta, munu yirrinakayi. Partarl kanyjirnikinyiyi jawapirtiku. ");
INSERT INTO nna_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wurrarnapulalu Lot-ja, “Nyuntumilirranguja nganurtu nyungungu tawunja? Partanykarrangu? Pujamurrangu? Wurralajanaku nyungu tawun yakalapiyi. ");
INSERT INTO nna_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Jampa nyungu tawun wiyirr yija kampalapalayi. Ngarrka miranu marrngurranguku nyungungu, kurlukata yiji jana. Palinyju nyungukarti ngakarnangalayinyi wiyirrku yijaku kampanaku ngarrakuny.” ");
INSERT INTO nna_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Yana Lot pujamukartijirri, palinymili kurntalmilijirri pilyurrjirri, wurrarnapulaku, “Jampa nyungu tawun kampalkuliny ngarrakuny Ngarrkalu. Nyunguja janyin mirti jarrapulu, marlkarringimarra!” Wurrarnikinyipulu witijakapali, puru panpanyapulalu. ");
INSERT INTO nna_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Pirrpa-pirrpa jarrinyajalu Lot-ja wurrarnapulalu angel-jujirri, “Kawajaninyi mirtawapa kurntaljirri nyuntumili, jalakarti nyungu tawunja wiyirr mirti jarrulunyurru, marlkarringimarra!” ");
INSERT INTO nna_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Panypanyikinyipulaku Lot-ju, munu janyin jarrima paliny. Palaja palajirri angel-jujirri parirrngulu kanyapulujaninyi, janyin yanayi jalakarti tawunja. (Ngarrka paju karrinyalu Lot-ku, palajalu wanka jirnipulu.) ");
INSERT INTO nna_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Palaja wurrarnapulujanaku, “Mirti jarrayi, mirti jarrayi! Munu nyirrirni parrjaliyi! Munu partijirri parlkarranga kajaliyi. Warnkumarramarrakarti pipurru mirti jarrayi, marlkarringimarra!” ");
INSERT INTO nna_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Puntaju Lot-ju karra marnapulaku, “Nyumpalakurra pajulu ngalypa jirnijinyumpulu, wankanyu jirninyinyumpulu. Pinakarrajipulu. Warnkumarramarra kaja yiji. Munu mirti yaninyakarna ngurnungukartijakun. Marlkarri jarrarnili partijirri. ");
INSERT INTO nna_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yirrirnanyumpulu pala tawun, pala wupartu tawun palanga? Mirti jarrulumarna palakartijakun. Tuku wantulumarna palangangarra.” ");
INSERT INTO nna_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Warajalu wurrarnala, “Yuu. Nyurra palakarti yarrayi. Munu kampalamarna pala wupartu tawun. ");
INSERT INTO nna_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","23","Jampa mimalamarnanyurruku. Jampa nyurra palangangarra kajarnaja, jinta warrarn kampalamarna. Palajalu mirti jarrayi!” Karrpu milyapal jarrinyaja Lot-pa kurntaljirri palinymilijirri kajarniyi palanga tawunja. Yini pala wupartu tawun Jawa. ");
INSERT INTO nna_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","25","Palaja parlparrja Ngarrkalu ngakarna warnkukapalirrangu wikajartiny, palajun wirlarnapulinyi palajirri tawunjirri, Sodom-pa Gomorrah. Ngurrararrangu wiyirr marlkarri jarrinyiyi. Parlkarra pukun wirlarna Ngarrkalu, warrarn kurluny-kurluny jarrinyi, warrulymajirri, mungkamajirri. ");
INSERT INTO nna_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mirtawalu Lot-milalu panypanyapulaku angel-milijajirri muwarrja. Sodom-karti nyirrirnikarti parrjarna palinyju, yamarna karamartalu. Pala mirtawa marlkarri jarrinyi, paliny yamarna karamartalu, marlajakapali jirni. ");
INSERT INTO nna_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Marntungu pirrpa-pirrpanga Abraham kulpanya nyarrakarti, palakarti muwarr pirnikinyalupa Ngarrkanga. ");
INSERT INTO nna_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Warnkumarramarraja parrjarna parlkarrakarti, Sodom-kartipa Gomorrah-karti. Jungan kankakurnu yananyikinyi ngurnarrijirri. ");
INSERT INTO nna_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Palajun pala parlkarrangajirri tawunjirri kamparnapulinyi ngarrakuny Ngarrkalu, wirlarnajaninyi marlkarri ngurrararrangu wiyirr yiji. Lot-jakun ngakarna jalanga Sodom-ja marlkarringamarra. Abraham-ku pinakarrinyalu Ngarrkalu, wankanyu jirni Lot. ");
INSERT INTO nna_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot wirnti Zoar-nga waninyaku. Palajalu yakarna pala wupartu tawun, Zoar, yana warnkumarramarrakarti. Palinypa palinymili kurntaljirri jurntingi waninyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yarti marrkanga wurrarnala murrkangunyalu, “Japartu ngalimili ranyji, ngali waninyali pirirrimajirri. Nyungungu warrarnja yija munu waraja pirirri. ");
INSERT INTO nna_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Japartu yungkuli minpinaku wayin. Palaja, yawurr jarrinyaja, palinyja karta karrulupalili. Palajunju partany kangkulupali japartuja ngalimilija.” ");
INSERT INTO nna_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Warrukartingi wayin yinyapulali. Yawurr jarrinyaja murrkangunya palinykarti yana, palinyja karta karrinyili. Turlpanyajapa yananyajapa munumpa waninyi Lot. ");
INSERT INTO nna_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Warinymaljanga marrkanga karra marnalu murrkangunyalu, “Warinyja warrukartingi japartungu karta karrinyirnili. Kuwarringi warrukartingi yarrana wayin yungkulupali. Palaja palinyja karta karruluman nyuntu, palinyja partany kangkuluman.” ");
INSERT INTO nna_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Palanga warrukartingi yarrana japartu pulanymili wayin yinyapulali. Palaja pala nyirti palinyja karta karrinyili. Turlpanyajapa yananyajapa munumpa waninyi Lot. ");
INSERT INTO nna_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Palajun ngarlungka jarrinyipulu Lot-mili kurntaljirri japartumarninyja pulanymilija. ");
INSERT INTO nna_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Partany kanya murrkangunyalu, punulku, yini marna Moab. Palinymili nyirrirnikartijarrangu yini marnayijaninyi Moabites. ");
INSERT INTO nna_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nyirtingunyalu pukun partany kanya, punulku. Yini marna Ben-ammi. Palinymili nyirrirnikartijarrangu yini marnayijaninyi Ammonites. ");
INSERT INTO nna_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham yana Mamre-ja kurilakartikurtirri Canaan-ja. Waninyikinyi palangajirri partijirri ngapinga, Kadesh-pa Shur. Yarti waninyikinyi Gerar. ");
INSERT INTO nna_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Palanga Sarah wurrarnikinyi palinymili mirtawamarniny marrka. Palanga partunurrangu Abimelech nyampali wirtu Gera-ku. Palinyju warrkamukatarrangu ngakarnajaninyi maninyaku Sarah-ku. “Ngajukarti kanganyaku mirtawa ngajumili jarrinyaku.” ");
INSERT INTO nna_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Warajanga warrukartingi Ngarrka ngayarta jarrinyi kapukarringi. Wurrarnala, “Nyuntulu kanyan nyungu mirtawa. Pala mirtawa pirirrijartiny. Palajalu marlkarri jarruluman.” ");
INSERT INTO nna_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech munu ngarrany karta karrimapulu pala mirtawa. Karra marnala, “Nyampali, ngaju munu kurlu jinaja! Yijalu munu wirlalamannganinyi ngajumilirrangu marrngupa. ");
INSERT INTO nna_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham-jungarra wurrarna pala palinymili mirtawa marrka. Palangarra muwarr pirni Sarah-lu. Pala jirnirni yijalu wurrarnarna ‘ngalypa’.” ");
INSERT INTO nna_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ngarrkalu puntajulu wurrarnala kapukarringa, “Yuu, ngaju miranu pala jirnin ngalypakapali wurrarnikinyin, palajalu ngampa pirnirninti jinaku kurlujartinyku ngajuku. Ngampa pirnirninti warlinaku palaku mirtawaku. ");
INSERT INTO nna_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kuwarri, pala mirtawa kulpanya yuwalu palinymili pirirringi. Pala Abraham muwarr pinakata ngajumili. Paliny muwarr pilipiji nyuntuku palajunjamarra, munu marlkarri jarruluman. Wurrarnarnangu palanga minyirri, munujalu nyuntupa nyuntumilipa marrngurrangu marlkarri jarrulunyurru.” ");
INSERT INTO nna_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Karrpu jarrinyajalu warinyja marntungungu Abimelech-ju kuru marnajaninyi nyampalirrangu wiyirr palinymili, wurrarnajanaku Ngarrkaja muwarr. Jana wirnti karrinyiyi yiji. ");
INSERT INTO nna_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Muwarr ngakarnalu Abraham-ku. Minyirrju wurrarnala, “Ngani kurlujartiny jirnarnanga, puntajulu nyuntulu kurlujartinyju jirnin nganarnaka wiyirrku? Yiyja yiji munu jintalupa jirnamayi palajun ngajuku. Work on this: it misses the point that no-one ever SHOULD do that to ANYBODY. ");
INSERT INTO nna_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nganiku jirninpa?” ");
INSERT INTO nna_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham-ju puntajulu, “Wurrarnarnaji, ‘Munu nyarralanga warrarnja pinakarramayalu Ngarrkaku. Wirlalanyiyili marlkarri mankulupiyi ngajumili mirtawa.’ ");
INSERT INTO nna_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Yuu, yija ngajumili marrka pala mirtawa. Paliny ngajumili japartumili partany, munu ngajumili pipimili partany. Pala mirtawa ngalayi warajanga jarrinyalayi. ");
INSERT INTO nna_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Purlpilu Ngarrkalu wurrarnaji, 'Yankuluman warinykarti warrarnkarti.' Ngajulu wurrarnarnala Sarah-ngi, 'Ngalypa jilipijin. Yananyaja warinykartirrangu warrarnkarti, wurralamanjanaku marrngurrangungu, “Ngajumili Abraham mamaji'.” ");
INSERT INTO nna_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Palaja Abimelech-ju kulpanya jinalu mirtawa Abraham-ja, yinyalu warinyarrungupa kukurnjaripa purlikapa warrkumukata pirirrimartapa mirtawanyjarripa. ");
INSERT INTO nna_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Wurrarnala Abraham-ja, “Nyungungu nganarnamili warrarn, nyurra puru wantayi palanga warrarnjakurtirri, munu wirnti karrulunyurru.” ");
INSERT INTO nna_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Wurrarnala Sarah-ngi, “Ngajulu yungkulumarnalu mamajinga nyuntumilinga 1,000 warnkurrangu. Palajalu nyuntumili marrngurrangu miranu wantulupiyingu munu nyuntulu kurlujartiny jirnaman.” ");
INSERT INTO nna_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Purlpilu Ngarrkalu ngampa pirnajaninyi Abimelech-mili mirtawanyjarri partany kanganyaku, Sarah-ngamarra. Kuwarri Abraham-ju japirr marna Ngarrka, Ngarrkalu wankanyu jirni Abimelech, wankanyu jirnijaninyi mirtawa palinymilipa warrkamukatarrangu mirtawanyjarri, yarrana partanyku kanganyaku. ");
INSERT INTO nna_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Palaja Ngarrkalu ngalypalu jinalu Sarah-ku. Palinymili muwarr yija jarrinyalu palinyku. Purlpi Abraham-ja wurrarnala Ngarkalu, “Yija warajaja partunuja kulpulumarna, partany kangkuliny Sarah-lu, pirirri kangkulumanga.” Yijarla pala muwarr. Ngarrkamilija muwarrja partany kanyalu pirirriku Abraham-ku. ");
INSERT INTO nna_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Pala partany palinymili Abraham-ju yini marna Isaac. ");
INSERT INTO nna_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Karrpu 8-jartiny jarrinyaja Abraham-ju wirrkarna, Ngarrkamilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Palanga Abraham ranyji yija, 100 partunurrangujartiny. ");
INSERT INTO nna_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Pikaly yiji Sarah, nyarru pirni. “Ngaju pikaly jirninyi Ngarrkalu. Jinta pinakarrinyaja pikaly jarrulupiyi, nyarru pilipiyi pukun. ");
INSERT INTO nna_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Wurrarnikinyiyi wiyirrju partanymajirri wantulumarnalu Abraham-ku. Kuwarri partany kanyarnalu ranyji jarrinyajaku.” ");
INSERT INTO nna_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Wirtu jarrinyi jukurtu, ngama yakarna. Palanga Abraham-ju wurrarnajanaku warrkamukatanga palinymilingi mayi wirtu kampalapiyijanaku kurrngalku marrngurranguku. Palaja wiyirr milpanyiyi ngurrakarti Abraham-milikarti, pala mayi ngananyikinyiyi, pikaly waninyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ishmael, Hagar-milipa Abraham-mili partany, witilu nyurni marnikinyi Isaac. Palajirri yirrirnipulinyi Sarah-lu, ngarlu kurlu jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Wurrarnala Abraham-ja, “Nyuntu marlkarri jarrinyaja ngajumilalu partanyju, Isaac-ju, wurrukarra nyuntumili mankuliny palinyjujakun. Pala wariny partany, warrkamukata mirtawamili partany, munu palinyju wurrukarra mankuliny nyuntumili. Pala warrkamukata mirtawapa partany palinymili jurtu ngakalapulinyi ngarramarnti.” ");
INSERT INTO nna_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham ngarlu kurlu jirni Sarah-lu muwarrju. Munu jurtu ngakanaku karrinyalu partanyku, palinymilaku waljaku. ");
INSERT INTO nna_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Wurrarnala Ngarrkalu, “Munu ngarlu kurlu wantuluman Ishmael-kupa pipiku palinymilaku. Pinakarrulumanpalu Sarah-ku, palinymilija muwarrja jilkuluman. Purlpi wurrarnanga yungkulumarnanta karluji jamujirrangupa nyirrirnikartijarrangu kurrngal. Isaac-jangarra milpulupiyi jana. ");
INSERT INTO nna_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ishmael pukun partany nyuntumili. Palajalu ngalypa jilamarnalu palinyku pukun, karluji jamujirrangupa nyirrirnikartijarrangu kurrngal yiji yungkulumarnalu.” ");
INSERT INTO nna_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Marntungu pirrpa-pirrpa Hagar-nga mayipa ngapa yinyala Abraham-ju. Ngapapinti Hagar ngurntingi wirrirnili. Palaja jurtu ngakarnapulinyi. Yana-yaninyikinyipulu pirranga, ngapimartaji, Piyajipakurtirri. ");
INSERT INTO nna_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ngapa munu jarrinyipulaku. Palaja partany yakarna Hagar-lu mungkamartaji. ");
INSERT INTO nna_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Wangkamarta yana, kajarna. Wurrarnarningu, “Yija ngajumili partany jampa marlkarri jarruliny. Munu palaku yirrinaku karrinyarnalu.” Ngangkurl jirnikinyi yija partanyku. ");
INSERT INTO nna_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Murrukurru ngangkurl jirnikinyi, pinakarrinyi Ngarrkalu. Parlparrja kamarnala, “Hagar-kayi, munu ngarlu kurlu jarruluman, munu wirnti karruluman. Murrukurru pinakarrinyirni ngangkurl jinaja ngajulu. ");
INSERT INTO nna_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Paliny kalkulumarna ngajulu. Kurrngal yiji jamuji karlujirrangupa nyirrirnikartijarrangu yungkulumarnalu. Kuwarri palinykarti yankuluman, parirrngulu kangkuluman, wararr jilaman.” Palajun wurrarnala Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Palaja Hagar-lu yirrirni, jurti jirnili ngapa Ngarrkalu, purlpurlpu jarrinyikinyi ngapa. Palakarti yana, ngapapinti winya jirni, murrukurruku kanyalu, yinyala ngapa. ");
INSERT INTO nna_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ishmael wirtu jarrinyikinyi, Ngarrkalu kalkurnukinyi. Kuwiyimarta jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Pirranga waninyikinyi, warrarnja yiningi, Paranja. Pipilu mirtawa manalu Egypt-ja. ");
INSERT INTO nna_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Palanga Kingi Abimelech-pa palinymili army-ku nyampali, yini Phicol, yanapulu Abraham muwarr jinaku. Abimilech wurrarnala Abraham-ja, “Ngani warralpirti jirnan nyuntulu, Ngarrka ngalypa jirnangu. ");
INSERT INTO nna_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ngarrkalu parrjarnanganyjurrinyi kuwarri, tarn-tarn muwarr yingkuluman, nyuntu munu mitu marnakanyi, ngajupa ngajumili partanykarrangupa nyirrirnikartijarrangu. Ngajulu ngalypa jirnarnangu. Puntajulu tarn-tarn muwarr yingkuluminyin, nyuntulu ngalypa jilkuluminyin ngajuku, ngalypa jilkuluman nyunguku warrarnku pukun.” ");
INSERT INTO nna_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham-ju wurrarnala, “Yuu, palajun wurrarnarnangu, Ngarrka miranu palaku muwarrku.” ");
INSERT INTO nna_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham-ju wurrarnalu Abimilech well-ku, Abraham-mili warrkamukata karlinyayi, Abimilech-mili warrkamukatarrangulu manayi janakujakun. ");
INSERT INTO nna_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Karra marnalu Abimilech, “Munumpa ngaju palaku. Munu wurrarninyin nyuntulu, kuwarrijakunja pinakarrinyinyi.” ");
INSERT INTO nna_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Palaja Abraham-ju yinyalu kukurnjarirrangupa pulikarrangu, Abrahampa Abimilech muwarr jinipulu. ");
INSERT INTO nna_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham jinta pirnijaninyi 7 kukurnjarirrangu waraja partunujartiny. ");
INSERT INTO nna_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Palaja Abimilech japirr marna, “Nganiku palujun jirnan?” ");
INSERT INTO nna_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Karra marnalu Abraham-ju, “Mankuluman nyungurrangu 7 kukurnjarirrangu. Palajun jirnajalu, wurralaman karlinyarna nyarra well ngajulungarra.” ");
INSERT INTO nna_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Palaja pala well yini marnayi “Beersheba”, “Tarn-tarn Muwarr Well”. ");
INSERT INTO nna_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pala tarn-tarn muwarr jirnaja, Abimilech-pa Phicol yanapulu, kulpanyapulu Philistia-karti, warrarnkarti pulanymilikarti. ");
INSERT INTO nna_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Palanga Abraham-ju Beesheba-nga jarnti jirni mungka, tamarisk mungka, ngarluja nyurra marna Ngarrka, paliny LORD ngarramarntiku. ");
INSERT INTO nna_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham-ju kaliku palinymilirrangu jarnti jirnikinyi warrarn-ja Philistia-nga punja yija. ");
INSERT INTO nna_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Punjaja Abraham yakurr marna Ngarrkalu. Karra marnalu, “Abraham-kayi.” “Yu?” ");
INSERT INTO nna_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Wurrarnala, “Partany walja nyuntumili, pala Isaac, yija ngarlungu nyuntungu paliny. Paliny kangkuluman, kajakarti yankulunyumpulu, warrarnkarti Murayakarti. Warnkumarramarranga waraja warnku jurti jilamarnanta. Palangangarra partany walja nyuntumili marlkarri wirlalaman, kawu palinymili wikanga wirrilaman, kampalaman tikilkartijakun. Palajun jilaman ngajuku.” Pinakarrinyalu Abraham-ju. ");
INSERT INTO nna_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Pirrpa-pirrpanga kartaja wararr karrinyi Abraham. Wika mana, wirrirni tangkingi. Palaja Abraham-pa warrkamukatajirripa Isaac yanayi, ngurnungukarti warrarnkarti, Moriah-karti yananyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kujarraja ngurraja yirrirniyi warnku pala, kajangulu. ");
INSERT INTO nna_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Palinymilingi warrkamukatajirringi wurrarnapulaku, “Nyungungungarra wantapulu tangkipukun. Ngalaya yankulupulayi partanypa ngurnungukarti, palanga kuwiyi yungkulupalayili Ngarrkanga. Palaja nyumpalakarti kulpulupalayi.” ");
INSERT INTO nna_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham-ju wika punyjanga wirrirnili Isaac-ja. Wirrkanapintipa panijartu kanya Abraham-ju. Palaja yanapulu. ");
INSERT INTO nna_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Japartumurninyja wurrarnala Isaac-ju, “Japartukayi!” “Yu?” “Wikapa panijartu kanganyali. Wanyjarningi pala kukurnjari Ngarrkaku wirlalapali?” ");
INSERT INTO nna_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Karra marnalu Abraham-ju, “Ngarrkalungarra kukurnjari yungkulinyngalinyi kampanaku tikirlkarti.” Yaninyikinyipulu. ");
INSERT INTO nna_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kajarnapulu palanga warnkunga, Moriah-nga, purlpi Ngarrkalu wurrarnala Abraham-ja pala. Warnkurrangu kuru marna Abraham-ju, wika kankarni wirrirni, munu jakarnama. Kunymarna partany palinymili, paliny wirrirni wikanga kankarni. ");
INSERT INTO nna_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Palaja wirrkanapinti mana partanyku marlkarri wirlanaku. ");
INSERT INTO nna_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Parlparrja kamarnalu Ngarrkalu, “Abraham! Abraham!” “Yu?” ");
INSERT INTO nna_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Yakala! Munu nyuntumili partany wirlalaman! Puru yakurr marnikinyirninti. Purlpi wurrarnarnangu partany nyuntumili wirlalaman, ngajungu yungkulupijin. Palinyku munu jamirnaminyin. Palaja nyuntuku miranu jarrinyarnanga, nyuntulu yirrkulu wurranajalu jinan ngajungu muwarrja.” Palajun Abraham-ja wurrarnala Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Parrjarna Abraham-ju, wangka yuramu yirrirni, palamili kutajirri mungkanga, mantalji waninyikinyipulu, munu purrirnakarningu. Mana pala kuwiyi, Ngarrkaku marlkarri wirlarnalu. Munu wirlarnama palinymili partany walja, paliny wanka kalkurnu Ngarrkamilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Palaja pala warnku yini marna Abraham-ju “Ngarrka Yinganyakata”. Palajalu kuwarrikartijakun wurrarnayi, “Warnkungu Ngarrkamilingi yungkulinynganyjurrinyi Ngarrkalu.” ");
INSERT INTO nna_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yarrana Abraham-ku kamarnalu parlparrja Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Ngajuku pinakarrinyijin nyuntulu, partanyku waljaku nyuntumilaku munu jamirnaminyin. Palajalu wirrirnarnanga muwarr ngajumili, pala muwarr nyuntuku wantuliny ngarrakuny yija. ");
INSERT INTO nna_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ngalypa yiji jilamarnanga, yungkulumarnarnta kurrngal karlujirrangupa jamujirrangu. Panikatarrangu parlparrja kurrngal yiji, nyuntumilirrangu karlujirrangu pukul kurrngal yiji jarrulupiyi. Jinta malyparr jarrayijanakalu nyuntumilirranguku, wirrilamarnajaninyi warrkamukata nyuntumilirranguku. Nyuntumili marrngurrangu wirrilimarnajanaku nyampalirrangu jintaku. ");
INSERT INTO nna_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nyuntumilirrangulu ngalypa jilipiyijanaku wiyirrku marrngurranguku ngunarrikurnujirringi. Yijalmarta jirnijin nyuntulu. Palajalu ngalypa jilamarnanga palajun.” Palajun muwarr pirnili Ngarrka. ");
INSERT INTO nna_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Palaja Abraham-pa Isaac warrkamukatajirrikarti kulpanyapulupulaku. Palaja yanayi Beersheba-karti. Palanga waninyikinyi Abraham. ");
INSERT INTO nna_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Yarti pinakarrinyi Abraham-ju palinymili marrka Nahor partanykarrangu 8-jartiny, Milcah-lu kanyajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz (murrkangunya), Buz (palinymili marrka pirirri), Kemuel (Yaramumili japartu), ");
INSERT INTO nna_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph, Bethuel ");
INSERT INTO nna_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Rebecca-mili japartu). Milcah-lu kanyajaninyi nyungurrangu partanykarrangu pirirrimarta Nahor-ku, Abraham-milaku marrkaku. ");
INSERT INTO nna_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ruma, Nahor-mili yarungumarniny, palinyju kanyajaninyi Tebah, Gaham, Tahash, Maacah. ");
INSERT INTO nna_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Palaja mirtawa Abraham-mili, pala Sarah, marlkarri jarrinyi. Ranyji yiji paliny, 127 partunurrangujartiny. Wurrjirni palanga, Hebron-ja, warrarnja Canaan-ja. Ngangkurl jinalu Abraham-ju. ");
INSERT INTO nna_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ngangkurl jinaja tawunmilikarti nyampalirrangukarti yana. (Palarrangu marrngurrangu palanga Yitimilirrangu.) Palarranguku muwarr pirnijanaku Abraham. ");
INSERT INTO nna_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngajuku miranu nyurra. Kajaja milpanyarna. Nyungu warrarn munu ngajumiliwayi. Nyungu ngajarrikapali ngaju. Yijapa warrarnkurra yungkuluminyinyurru, palanga kurtu jarrinyija wirrilamarna ngajumili nyupa.” ");
INSERT INTO nna_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","“Yuu, jurnti nyuku jilaman. Wirtu nyampali nyuntu nganarnaku. Jurnti ngalypa mankuluman, palanga mirtawa nyuntumili wirriliman. Munu jamilipiyirninti warrarnku.” ");
INSERT INTO nna_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Pirntil kanka jarrinyijanaku Abraham. ");
INSERT INTO nna_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Karra marnajanaku, “Muwarrkurra pilkulunyurrulu palaku pirirriku, Zohar-milaku partanyku, Ephron-ku. ");
INSERT INTO nna_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Yijapa japirr malkulunyurru jurnti yungkulupiji ngapingi, Machpelah-nga. Pala jurnti warrarnja palinymilingi. Nganiku warnkuku karrinyi palaku, yungkulumarnalu. Yungkulumarna warnku nyungungu, yirrilkulunyurru nyurralu wiyirrju. Palaja pala jurnti ngajumili jarruliny.” ");
INSERT INTO nna_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","11","Pirirri nyarra palangangarra kajarnikinyi, pala Ephron. Wurrarnala Abraham-ja, jintalu pirirrimarta pinakarrinyikinyiyi, “Mirtanyakurra, yungkulumarnanta pala jurnti, pala warrarn jurntimartaji pukun. Mirtawa nyuntumili wirriliman palanga. Wiyirrju nyungurrangulu pirirrimartalu pinakarrinyanyiyi muwarr pirnaja.” ");
INSERT INTO nna_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yarrana ngurrararranguku pirirrimartaku pirntil kanka jarrinyijanaku Abraham. ");
INSERT INTO nna_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Wurrarnala Ephron-ja, “Munu. Warnku yungkulumarnanta warrarnku palaku. Kawa ngajuja nyungu warnku. Palaja pala warrarn ngajumili wantuliny, marlkarri wirrilimarna palanga.” ");
INSERT INTO nna_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Palalu Ephron-ju wurrarnala, “Mirtanyakurra, pinakarraji. Jintalu wuparturla yuwanyiyili, puru warnkurrangu 400. Ngurnipali japirr malarnantala yungkuluminyin warnkurrangu wupartu. Munurti. Munu palajun jilamarna, pala warrarn yungkulumarnanta warnkumajirriku. Jurntingi wirrinaku marlkarri nyuntumili.” ");
INSERT INTO nna_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","“Munu, warnku yungkulumarnanta yiji.” Palangangarra 400 warnku Ephron yinyala Abraham-ju, Ephron-ja muwarrja. ");
INSERT INTO nna_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Palajalu pala jurnti Machpelah-nga Abraham-mili jarrinyi, pala warrarn jurntimartajipa wiyirr mungkarrangu pukun nyarranga warrarnja. Palarrangulu wirtu nyampalirrangulu yirrirnikinyiyi. Miranu jana wiyirr, warrarn nyarra mana warnkulu Abraham-ju. ");
INSERT INTO nna_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Palaja palanga jurntingi marlkarri mirtawa palinymili wirrirni Abraham-ju, jurntingi Machpelah-nga, Mamirija kakarrakurnu, warrarnja Canaan-ja. ");
INSERT INTO nna_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Palajun pala jurntipa warrarn jurntimartaji Abraham-mili jarrinyi ngarramarnti, jungkaraku. ");
INSERT INTO nna_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Palanga ranyji yija Abraham. Ngalypa kalkurnikinyi Ngarrkalu, kuwiyirrangupa wurrukarra munu yiji yinyalu, yijalu ngalypakata jirnili. ");
INSERT INTO nna_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Warajanga karrpungu pirirri kamarna Abraham-ju, mirtanya yiji, warrkamukata wirtu palinymili. Paliny nyampali wiyirrku jintaku warrkamukata Abraham-mili. Palanga warrkamukatanga wurrarnala, “Yankuluman mirtawa kanganyaku partanyku ngajumilaku. Yijalu munu kanganyaku ngurrara mirtawa nyunguja warrarnja. Munurti. Ngajumili walja warrarnkarti yankuluman. Palinyku mirtawa kangkuluman ngajumilirranguja. Parirr wirriliman ngajungu kalpartingi, muwarr yija yungkuluman, palajun jilaman ngajuja muwarrja. Nyuntu miranu Ngarrkaku, parlparrpa jungka jirni palinyjungarra. Nyuntumili muwarr pinakarruliny palinyju. Yijapa panypajinpili, miranu jarrulumangu palinyngarra.” ");
INSERT INTO nna_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Warrkamukatalu nyarralu puntaju karra marnalu, “Yijapa munu milpuliny pala mirtawa. Wurralajili 'Munurti'. Palaja wunyjurru jilamarna ngajulu? Partany nyuntumili kanganyaku warrarnkarti nyuntumilikarti?” ");
INSERT INTO nna_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Karra marnalu Abraham-ju, “Munurti. Munu kangkuluman partany ngajumili ngurnungukarti. ");
INSERT INTO nna_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ngarrka, kanka waninyi paliny, purlpilu yiji wurrarnaji palinyju ngajumili warrarn yakanaku. Palinymili muwarr yija yinyaji, 'Yijalu nyungu warrarn yungkulumarnajaninyi nyuntumili karluji jamujirrangupa janamili nyirrirnikartijarrangu.' Angel palinymili ngakalkuliny walangkarr nyuntuku; jurti jilamangu mirtawa ngajumilaku partanyku palinyjungarra. ");
INSERT INTO nna_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Yijapa wurralamangu palalu kurrilu, 'Munu yajalamarnanta, ngajumilingi waljanga warrarnja wantulumarna.' Palajun wurranaja puru yakalaman, kulpuluman palinymajirri. Munu yiji kangkuluman partany ngajumili ngurnungukarti warrarnkarti mirtawa mananyaku palinyku.” ");
INSERT INTO nna_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Palaja kalpartingi Abraham-ja parirr wirrirni warrkamukatalu nyarralu, palinymili yija muwarr yinyali, wurrarnala, “Yijalu palajun jilamarnanga.” ");
INSERT INTO nna_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Palaja warrkamukatalu nyarralu wurrukarrapa miji-mijipa nganin-nganin kuru marna Abraham-milija. Yijapa kurri Isaac-ku mankuliny, yungkulinyjaninyi pala kurripa palinymili japartupa pipi. Palaja 10 kamalarrangu Abraham-milirrangu manajaninyi, yana ngurnungu warrarnkarti, Mijuputamiyakarti. Yananyikinyi ngurrarrangu ngurra palakartijakun tawunkarti, ngapikarti, Abraham-mili marrka Nayiyu palanga waninyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Warajanga karrpungu, jarurrukartingi, kajarna janukumartaji, jalakarti tawunja. Ngapa purlpurlpukarra marnikinyi palanga. Murtingi jurlpi-jurlpi jirnijaninyi kamal pala janukumartaji. Palakarti milpanyikinyiyi mirtawarnjarri tawunja jarurrukartingi ngapaku mananyaku. ");
INSERT INTO nna_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ngarrkaku muwarr pirnili. “Ngarrkakurra, ngarramarntilu nyuntuku pinakarrinyingu nyampalilu ngajumilalu, Abraham-ju. Yijalu kalkurnan paliny. Ngalypakurra kuwarringi jilimanpalu. Jurti jilipijinpalu kurri partanyku palinymilaku. ");
INSERT INTO nna_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nyungu ngapamartaji ngaju. Tawunja nyungukarti milpanyayi kuwarringarra ngapaku kurrirrangu. ");
INSERT INTO nna_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Waraja japirr malamarna ngapaku wupartuku ngajungu yinganyaku. Yijapa wurralapiji, 'Yuu, nyuntuku nyungungarra ngapa. Kangkulumarna ngapa kamalku nyuntumilirranguku pukun.' Kurrilu muwarr pilkuliny kamalku ngapa yinganyaku, palangarra mirtawa Isaac-ku. Palajun jurti jiliminyin pala kurri. Palajalu miranu jarrulumarnangu nyuntuku, Abraham tuku jinan.” ");
INSERT INTO nna_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ngarrkaku muwarr pinajangangarra, milpanya Rebekah. (Rebekah-mili japartu yini Bethuel. Bethuel-mili pipi yini Milcah, japartu yini Nahor. Nyarra Nahor marrkamurniny Abraham-mili.) ");
INSERT INTO nna_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Kurri nyarra ngumpa ngalypakata. Munu karta karrima pirirringi. Pilyurrmajirri paliny. Rebekah-lu ngapapinti ngurntingi kanganyikinyi. Janukukarti yana, katukarna kaninykurnu, ngapapinti winya jirni, kulpanya karntinyi kankakurnu. ");
INSERT INTO nna_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Jampa purrpi yanalu mirtanya, wurrarnala, “Ngapapintija yuwajikurra ngapa wupartu.” ");
INSERT INTO nna_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Yuu, mirta, nyuntuku nyungungarra ngapa.” Jampangarra ngapapinti ngurntija parirrja wirrirni, ngapa jurtirnalu palinyku. Minpirni. ");
INSERT INTO nna_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Palaja wurrarnala kurrilu, “Mankulumarnajanaku ngapa kamalku pukun, minpilipiyi marlkaku.” ");
INSERT INTO nna_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Jampa ngapa jurtirni kuwiyimilingi minpinapintingi. Palaja mirti kulpanya janukukarti, katukarna, yarrana ngapa nyinirni, kulpanya, ngapa kanganyikinyijanaku kamalarranguku wiyirrku. ");
INSERT INTO nna_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Jamalu parrjarnikinyi palalu mirtanyalu. Wurrarnikinyarningu, “Yijapa nyungu kurri mirtawa Isaac-ku.” ");
INSERT INTO nna_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngapa marlkaku kamalarrangulu minpirniyi. Palaja mirtanyalu kurtanja mana milyapinti miji-miji, parirrpintijirri miji-miji pukun, wirrirnili. ");
INSERT INTO nna_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Karra marnalu, “Nganurtu japartu nyuntumili? Yijapa waraja warrukarti ngajupa ngajumili warrkamukatarrangu ngurranga nyuntumili japartumilingi karta karrulupiyirni?” ");
INSERT INTO nna_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Puntaju karra marnalu, “Japartu ngajumili Bethuel. Nahor-mili partany paliny, pipi palinymili Milcah. ");
INSERT INTO nna_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nganarnanga ngurranga wantulunyurru. Ngurra palparri nganarnamili. Warrulyjartiny kamalkupa nyurramilaku.” ");
INSERT INTO nna_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mirtanya milya kaniny jarrinyalu Ngarrkaku, ngarluja nyurra marna, muwarr pinalu, ");
INSERT INTO nna_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Ngarrkakurra, ngalypa nyuntu. Yarranija, wanka jinannganinyi. Nyuntumili muwarr yinyan ngajumili nyampali Abraham. Yijalu kalkurnanpalu pala muwarr. Pipurrulu kanyanyin nyungukarti, ngajumilikarti nyampalimilirrangukarti, palinymili waljarrangukarti.” ");
INSERT INTO nna_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Palaja pala kurri ngurrakarti pipimilikarti mirti jarrinyi, yimpirnajanaku muwarr mirtanyamili. ");
INSERT INTO nna_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Mamaji Rebekah-mili, yini Laban palanga, palinyju yirrirni palajirri parirrpintijirripa milyapinti. Marrkamurninymili muwarr pinakarrinyi. Palaja mirti jarrinyi mirtanyakarti. Paliny wararr karrinyikinyi janukumartaji, kamalja wangka. ");
INSERT INTO nna_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban-ju karra marnalu, “Pikaly waninyangu Ngarrka. Munu wantuluman nyungungu. Kurtali, nganarnamilikarti ngurrakarti milpuluman. Kaninypirtilu parljurnarnanyurraku nyuntukupa warrkamukatarranguku nyuntumilaku. Palanga karta karrulupiyi nyuntumili kamalarrangu pukun.” ");
INSERT INTO nna_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Yanayi wiyirr Laban-milikarti ngurrakarti. Palanga Laban-ju yinyji pirni jalingipintirrangu kamalja, warruly yinyajaninyi. Palaja ngapa kanyajanaku mirtanyakupa warrkamukatarranguku, jina ngulyanaku. ");
INSERT INTO nna_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Palaja mayi kanyalu mirtanyaku. Wurranala mirtanyalu Laban-japa palinymilinga japartungu Bethuel-ja, “Wurralkurnunyumpuluku nganiku milpanyarna. Palaja ngalkulumarna.” “Yuu, wurralamanngalayiku nganiku milpanyan.” ");
INSERT INTO nna_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Wurrarnapulaku mirtanyalu, “Warrkamukata ngaju Abraham-mili. ");
INSERT INTO nna_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ngajumilaku nyampaliku yiji Ngarrkalu ngalypa jinalu. Wirtu nyampali jirni. Kuwiyirrangu kurrngal yinyali, kukurnjaripa nanikutupa purlikapa kamalpa tangki. Miji-mijipa warnku yinyali, warrkamukata pirirrimartapa mirtawanyjarri pukun. ");
INSERT INTO nna_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Yuu, ranyji waninyikinyi, palinymilalu mirtawalu, Sarah-lu, partany pirirri kanyalu palinyku. Nyampalilu ngajumilalu wiyirr warnkupa kuwiyirrangupa wurrukarra yinyali palangarra partany. ");
INSERT INTO nna_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","Minyirrju wurrarnaji, 'Mirtawa kangkulumanpalu ngajumilaku partanyku. Munu mananyaku ngurrara kurri nyunguja warrarnja, Canaan-ja ngurrara. Ngajumilikarti japartumilikarti warrarnkarti yankuluman, ngajumilirrangukarti yankuluman. Ngurnungujangarra mankulumanpalu mirtawa ngajumilaku partanyku.' Palajun wurrarnaji nyampalilu ngajumilalu. ");
INSERT INTO nna_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Karra marnarnalu, 'Yijapa pala kurri ngajungu munu milpuliny.' ");
INSERT INTO nna_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Karra marnaji, 'Palinymili angel walangkarr ngakalamanga Ngarrkalu. Palalu angel-ju jurti jilamanta kurri, ngajumilingi japartumilirrangungu. ");
INSERT INTO nna_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wurraliyingulu, “Munurti. Munu yungkulupiyirni mirtawaku partanyku Abraham-milaku.” Palajunmarta wurranaja puru yakalaman, kurrimajirri kulpuluman.' Palajun wurrarnaji Abraham-ju. ");
INSERT INTO nna_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Kuwarri turlpanyarna janukungu tawunmartaji nyurramilimartaji. Ngarrkanga wurrarnarnalu, 'Ngarrkakurra, nyampali ngajumili, Abraham, nyuntuku pinakarrinyangu, nyuntumilirrangungu paliny. Kuwarri ngalypa jilipijin. Jurti jilipijin pala mirtawa Isaac-ku. ");
INSERT INTO nna_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nyungungu ngaju janukumartaji. Kurrirrangu ngapaku milpanyaja waraja japirr malamarna, “Yuwajikurra ngapa wupartu ngapapintija nyuntumilija.” ");
INSERT INTO nna_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Yijapa puntaju karra malkulupiji, “Yuu, nyuntuku nyungungungarra ngapa. Ngapa kangkulumarnajanaku nyuntumili kamalarranguku pukun.” Palajun jinaja wantuliny mirtawa Isaac-ku. Jurti jilipijin palangangarra kurri.' ");
INSERT INTO nna_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ngarrkaku muwarr pinajangangarra, milpanya Rebekah, ngapapinti ngurntingi kanganyikinyi. Ngapa mana. Palaja japirr marnarna, 'Yuwajikurra ngapa minpinaku.' ");
INSERT INTO nna_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Nyampalu ngurntija kaniny jirni ngapapinti, karra marnaji, 'Yuu, nyuntuku nyungungungarra ngapa. Kangkulumarnajanaku ngapa nyuntumilirranguku kamalarranguku pukun.' Palaja minpirnarna, palinyju ngapa yinyajaninyi kamalarrangu pukun. ");
INSERT INTO nna_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Palaja japirr marnarna, 'Nganurtu japartu nyuntumili?' Karra marnaji, 'Japartu ngajumili Bethuel. Nahor-mili partany paliny, pipi palinymili Milka.' Palaja kurringi milyapinti wirrirnirnili, parirrpintijirri wirrirnirnili parirrjajirri palinyja. ");
INSERT INTO nna_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mirtawa Isaac-ku jurti jirniji Ngarrkalu ngajumilija nyampalimilija waljarranguja. Palajalu milya kaniny jarrinyirni, ngarluja nyurra marnarna Ngarrka, wurrarnarnala, 'Yarranija. Wanka jirninyin.' ");
INSERT INTO nna_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Yuu, wunyjurru muwarr pilkulinyumpulu? Wurralkulinyumpulalu nyampaliku ngajumiliku, 'Yu'? Nyungu kurri partanyku palinymilaku yungkulunyumpulalu? Munujalu, warinykurnu jilimarna.” ");
INSERT INTO nna_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Puntaju karra marnapulalu Laban-jupa Bethuel-ju, “Nyungungarra jirni Ngarrkalu. Kurri nyarra yankuliny. Munu kunta jinakalayi yananyaja. ");
INSERT INTO nna_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah kangkuluman, yankulunyurru. Nyuntumili nyampalimili partanyku mirtawa jarruliny.” ");
INSERT INTO nna_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pulanymili muwarr pinakarrinyajalu pala mirtanya, Abraham-mili warrkamukata, murtingi julpi-jurlpi jarrinyi, Ngarrkanga wurrarnala, “Yarranija. Wanka jirninyin.” ");
INSERT INTO nna_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Palaja Rebekah-nga yinyali miji-mijipa wurrukarra ngalypakata. Yinyapulinyi Rebekah-mili mamajipa pipi pukun warinypa wariny ngalypakata wurrukarra. ");
INSERT INTO nna_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Palaja mirtanyalupa palinymilalu warrkamukatarrangulu nganayi mayi, wayin minpirniyi. Karta karrinyiyi palangangarra. Marntungu kartaja turlpanyaja mirtanyalu wurrarnapulaku Ripikamilinga mamajingipa pipinga, “Kuwarri ngajumilikarti nyampalikarti kulpulumarna ngaju, kurri pukun kangkulumarna.” ");
INSERT INTO nna_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Karra marnapulalu, “Mimarn-mimalakurra! Pala kurri nyungungu jampa waninyaku, yijapa 10 karrpuku wantuliny. Palaja yankuluman, kurri kangkuluman.” ");
INSERT INTO nna_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Karra marnapulaku, “Ngalypa jirniji Ngarrkalu. Kuwarri jampa kulpanyaku ngajumilikarti nyampalikarti. Munukurra kunta jiliminyinyumpulu.” ");
INSERT INTO nna_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“Mimalakurra. Kurri japirr malkulayi, wunyjurru muwarr pilkuliny.” ");
INSERT INTO nna_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kamarnapulalu. Milpanyaja japirr marnapulu, “Nyungungu mirtanyanga yankuluman?” Rebekah-lu karra marna, “Yuu.” ");
INSERT INTO nna_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Palaja Rebekah ngakarniyi yananyaku mirtanyangapa palinymili warrkamukatarrangunga. Palanga mirtawa mirtawari, purlpi palinyju Rebekah partanyja kalkuna wirtu jirnipa. Paliny pukun ngakarniyi. ");
INSERT INTO nna_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ngalypa muwarr pirniyalu Rebekah-ku. “Yijalu ngalypa jilimanga Ngarrkalu. Karluji jamujirrangu nyuntumilipa nyirrirnikartijarrangu janamili kurrngal yiji jarrulupiyi. Yijapa malyparrkata jarrulupiyijanaku jinta, nyuntumilirrangu nyampali jarrulupiyijanaku palarranguku jintaku malyparrkataku.” ");
INSERT INTO nna_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Palaja kamalarrangungu karntinyiyi Rebekah-pa kumpararrangu palinymili, yajarniyi mirtanya. Palajun mirtanyalu Rebekah wiyi jirni, kulpanyikinyi palinymilikarti nyampalikarti. ");
INSERT INTO nna_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Palanga Isaac Canaan-ja warrarnja kurilakurnungu waninyikinyi, palakurtirringi yintanga, yiningi ngapingi, Lahai-Roi-ngi. ");
INSERT INTO nna_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Warajanga jarurrukartingi jalanga puru marnti yaninyikinyi, kamalarrangu yirrirnijaninyi palinyju, milpanyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kajangulu Rebekah-lu yirrirni Isaac, kamalja katukarna. ");
INSERT INTO nna_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Mirtanya japirr marna, “Nganurtu ngurnungu pirirri, milpayinyi nganyjurrukarti?” “Palangarra nyampali ngajumili, Isaac-ngarra.” Wara ngumpapinti mana, ngumpa yamarnarninyi Rebekah-lu. ");
INSERT INTO nna_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Palaja mirtanyalu wiyirr yimpirnili Isaac-ja. ");
INSERT INTO nna_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Palaja Rebekah kalikukarti kanya Isaac-ju. Kaliku nyarra purlpi pipimili palinymili waninyikinyi. Ngarlu kurlu waninyikinyi pipijalu marlkarrijalu. Kuwarri mirtawa palinymili jarrinyi Rebekah. Ngarlungu yiji jirni Isaac-ju. Palajangarra pikaly jarrinyi, munu paju karrinyamalu palinymilaku pipiku. ");
INSERT INTO nna_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham-ju purlpi yiji mana wariny mirtawa, yaru. Palinymili yini Keturah. ");
INSERT INTO nna_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kanyapulujaninyi 6 pirirrimarta, pulanymili partanykarrangu: Zimran, Jokshan, Medan, Midian, Ishbak and Shuah. ");
INSERT INTO nna_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan japartu jarrinyi Sheba-kupa Dedan-ku. Dedan japartu jarrinyijanaku Ashurites-kupa Letushites-kupa Leummites-ku. ");
INSERT INTO nna_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian-mili partanykarrangu Ephah-pa Epher-pa Hanok-pa Abida-pa Eldaah. Palarrangu wiyirr Keturah-mili. ");
INSERT INTO nna_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Palangangarra wirtu jarrinyiyi. Abraham-ju yinyajaninyi wurrukarra, palaja ngakarnajaninyi warinykarti warrarnkarti, kakarra, Isaac-ngamarra ngakarnajaninyi. Palaja wurrukarra jinta wiyirr palinymili yinyali Isaac, wurrukarra palinymili ngani warralpirti. ");
INSERT INTO nna_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham partunurrangu-partunurrangu waninyi, 175-ja. Palaja mirtanya jarrinyaja marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Palinymili partanyjujirri Isaac-jupa Ishmael-ju wirrirnipulu pulanymili japartu jurntingi kaninykurti, Machpelah-nga. Purlpi palangarra jurnti waninyikinyalu warinymili. Abraham-ju mana warnkulu, warnkurrangu marlu yinyala Ephron palaku jurntikupa jungkaku. Purlpi marlkarri jarrinyaja palinymili mirtawa, Sarah, Abraham-ju wirrirni palanga jurntingi. Palangangarra jurntingi kuwarri palinymilalujirri partanyjujirri wirrirnipulu paliny pukun. ");
INSERT INTO nna_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Palaja Ngarrkalu tuku jirnikinyi Isaac. Isaac-ju ngurra jirni yintanga, ngapingi, Lahai-Roi-ngi. ");
INSERT INTO nna_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Purlpi Abraham karta karrinyipulu Hagar, warrkamukata Egypt-ja Sarah-mili. Hagar-lu partany kanya, Ishmael. ");
INSERT INTO nna_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ishmael japartu jarrinyijanaku pirirri partanykarrangu: Nebaioth, Kedar, Abdeel, Mibsam, ");
INSERT INTO nna_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massah, ");
INSERT INTO nna_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, Kedemah ");
INSERT INTO nna_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Palarrangumili nyirrinikartijarrangu 12 tribes, yini janamili yinyayi tawunkurrangupa ngurrarrangu. ");
INSERT INTO nna_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael 137 partunurrangu jarrinyaja, marlkarri jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ishmael-mili nyirrirnikartijarrangu warrarnja waninyayi Havilah-nga partijirri Shur-nga. Pala warrarn egypt-ja kakarrakurnu, Assyria-karti. Kaja waninyayi Abraham-milirrangu nyirrirnikarijarrangu. ");
INSERT INTO nna_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nyungu muwarr Isaac-mili, partany Abraham-mili. ");
INSERT INTO nna_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac 40 partunurrangu jarrinyaja mirtawaku kanya Rebecca, Bethuel-mili kurntal. Bethuel Aram-jirri pirirri, Mespotamia-ja. Rebecca marrka Laban-ku. ");
INSERT INTO nna_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac-pa palinymili mirtawa punja waninyipulu palanga partanymajirri. Isaac-ju japirr marna Ngarrka, “Partany yungkuluman ngajumili mirtawa.” Pinakarrinyalu Ngarrkalu, palaja pala mirtawa ngayinykarra jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kalkurnikinyipulinyi kujarra partanyjirri ngayinyja. Jinarn-jinarn pirnikinyipulu. Rebekah ngarlu kurlu waninyikinyi. Japirr marna Ngarrka, “Nganija?” ");
INSERT INTO nna_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ngarrkalu wurrarnala, “Kujarra kangkulumanpulinyi pirirrijirri. Wirtu jarrinyaja jinta pilkulinypularninyi. Jamuji karlujirrangu kurrngaljartiny yiji jarrulunypulu. Warinymilirrangu kulijarturrangu jarrulupiyi, warinymilirrangu munu. Marrkamurninymilirrangu nyampali wantulupiyijanaku murrkangunyamurninymilirranguku.” ");
INSERT INTO nna_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Palaja Rebekah-lu kanyapulinyi partanyjirri, pirirrijirri. ");
INSERT INTO nna_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Murrkangunyamurniny ngayarta jarrinyi pilyarripa mampuly-mampuly. Palajalu yini marnapulu Esau. ");
INSERT INTO nna_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Palaja marrkamurniny ngayarta jarrinyi. Warlirnikinyi mamajimurninymili luku. Yini marnapulu Jacob. Palanga Isaac mirtanya waninyikinyi, 60 partunurrangujartiny. ");
INSERT INTO nna_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Palajirri Esau-pa Jacob wirtu jarrinyipulu, pirirri jarrinyipulu. Esau kuwiyimarta. Kuwiyiku yananyikinyi. Jacob ngatu yiji, waninyikinyi ngurranga, warrkamu jarrinyikinyalu japartumurninyku. ");
INSERT INTO nna_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esau-lu kanganyikinyalu kuwiyi japartumurninyku ngananyaku. Murrkangunyamurniny Isaac-ja ngarlungu yija yiji. Nyirtingunyamurniny pipimurninyja ngarlungu yija yiji. ");
INSERT INTO nna_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Warajanga karrpungu kamparnakinyarninga mayi Jacob-ju, pilyarri mayi, pala yini lintil. Kulpanya kuwiyikartija Esau. Janparrja paliny. ");
INSERT INTO nna_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Wurrarnala marrkamurninyja, “Ngaju janparr. Jinta yuwanyi pala pilyarri mayi. (Palajalu yini yinyayi wariny, Edom.) ");
INSERT INTO nna_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob-ju puntaju karra marnalu, “Kulakurra! Wurralapijin yija muwarr nyuntumili. Murrkangunya nyuntu. Yarti japartu ngalimili marlkarri jarrinyaja, wantulumanngalika nyampali nyuntu. Mankuluman wirtumarta wurrukarra. Ngajulu wupartumarta mankulumarna. Wurralaji ngaju wantulumarnangu mamajikapali. Palajun muwarr pinajalu, mayi yungkulumarnanta.” ");
INSERT INTO nna_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau-lu puntaju karra marnalu, “Mayimajirrija marlkarri jarrarnili. Palaja munu mankulumarna wurrukarra, munu mamaji wantulumarnangu. Puru yiji pala. Jinta yuwanyi pala mayi!” ");
INSERT INTO nna_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob-ju puntaju karra marnalu, “Muwarrkurra yinkumarta yungkuluminyin. Palaja yungkulumarnanta mayi.” Esau-lu ngarlungu karra marnarningu, puru nyampaliwayiku waninyaku palinyku, karrinyikinyi wartapirti waninyaku. Muwarr yinyali, “Yuu, nyuntu wanta mamajikapali.” ");
INSERT INTO nna_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Palajalu Jacob-ju martumpirripa pilyarri mayi yinyali. Palaja Esau-lu ngana, minpirni, yana. ");
INSERT INTO nna_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Purlpijangarra punja waninyayi ngapa munu pungkama Abraham-milinga warrarnjakurtirri, yana paliny Gerar-karti. Warinymal yarti waninyi ngapa munu pungkuma Isaac-ku. Paliny yana Gerar-karti, ngapikarti, Abimelech-karti, kingi paliny Philistine-arranguku. ");
INSERT INTO nna_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ngarrka ngayarta jarrinyalu Isaac-ku, wurrarnala, “Munu yaninyaku Egypt-karti, wanta nyungungu warrarnja, wurrarnarnangupa. ");
INSERT INTO nna_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nyungungu wanta, tuku jilamarnanta ngajulu, ngalypa jilamarnangu. Ngajulu yungkulumarnanta wiyirr nyungu warrarn, nyuntumili jamuji karlujirrangupa nyirrirnikartijarrangupa. ");
INSERT INTO nna_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ngajulu kalkulumarna muwarr pala winyjinijalu Abraham-ja. Panikatarrangu kurrngal yiji, partarl yini malkulumanjaninyi. Jamuji karlujirrangupa nyirrirnikartijarrangu kurrngal yiji yungkulumarnanta, partarl yini malkulumanjaninyi. Yungkulumarnajaninyi nyungu warrarn wiyirr. Warinyarrangulu marrngukarralu janalu yirrilipiyi ngajulu ngalypa jirnirninyurrukapa tuku jirnirninyurrukapa. Janalu japirr malamanyiya palajunkapaliku jinaku janakupa. ");
INSERT INTO nna_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abraham-ju ngajumili muwarr wirturrangu tuku jirnikinyijaninyi. Palajunjalu ngajulu nyungurrangu jilamarnanga.” ");
INSERT INTO nna_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Palajalu Isaac palanga Gerar-nga waninyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Pirirrimartalu japirr marnaya palinymilaku mirtawaku, palinyju wurrarnajanaku, “Paliny ngajumili marrka.” Munu wurrarnamajanaku pala mirtawamurniny palinymili. Rebekah kumparakata yiji. Wirnti karrinyikinyi Isaac, “Palarrangulu pirrimartalu marlkarri wirlalaminyili Rebekah mananyaku.” ");
INSERT INTO nna_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Palanga Isaac waninyikinyi punja. Palaja Abimelech-ju parrjarna kaninykurnu mayangangulu, yirrirnipulinyi Isaac-pa Rebekah yarungu jirnikinyipularninyi. ");
INSERT INTO nna_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech-ju muwarr ngakarnalu Isaac-ku, “Ngajukarti milpuluman.” “Pala Rebekah nyuntumili mirtawamurniny! Nganiku wurrarnanpa marrka nyuntuku?!” “Ngajulu kurlkarri marnakinyarninyi, wurralirnili ngajumilingi mirtawanga, 'Nyuntuku mananyaku wirlalinyiyili marlkarri.'” ");
INSERT INTO nna_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“Ngani jirninnganinyi! Waraja ngajumili pirirri yijapa karta karrimapulu nyuntumili mirtawa. Ngarrkalu wirlarnamanganinyi nyuntujalu mitujalu!” ");
INSERT INTO nna_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Wurrarnajanaku palinymilaku marrngurrangungu, “Munu jilkulinyurru kurlujartiny nyunguku pirirrikupa palinymilaku mirtawaku. Yijapa palajun jilkulinyurru marlkarri jarrulinyurru.” ");
INSERT INTO nna_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac-ju wilyki jungkanga wirrirnijaninyi. Ngarrkalu ngalypa jirnikinyalu, warajaja kurtanjaja wilykija mana 100 kurtanarrangu. ");
INSERT INTO nna_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Wurrukarrarrangu palinymili wirtu jarrinyikinyiyalu, munuku munu jarrinyaku, kurrngal yiji kukurnjaripa nanikutupa purlimanpa tangkipa kamalpa. ");
INSERT INTO nna_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Philistine-arrangu ngampany jarrinyiyalu. Abraham-ja wankanyungu ngarrany palinymilalu warrkamukatarrangulu pirti karlinyiyi ngapaku mananyaku. Yijalu ngapa manayi. ");
INSERT INTO nna_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kuwarrilu marlkarrijalu Abraham-ja Philistine-ju ngampanyju yamarnayijaninyi pirtirrangu ngapajartiny. ");
INSERT INTO nna_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelech-ju wurrarnalu Isaac-ja, “Yakalaman warrarn nganarnamili, nyuntu wirtu jarrinyin yiji, munu nganyjurru warajanga waninyaku.” ");
INSERT INTO nna_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac-ju pala warrarn yakarna, ngurra jarnti jirni partijirri kaniny kujarranga warnkungu, yini Gerar Valley. Punja waninyi palanga. ");
INSERT INTO nna_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yarrana karlinyi Isaac-ju nyarrarrangu ngapapinti purlpi yamarnalpiyi Philistine-ju. Yini waraja ngarrany yinyajaninyi warajangarra palinymilalu japartulu yinyaljaninyi. ");
INSERT INTO nna_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Palinymilalu warrkamukatarrangulu karlinyiyi Gerar Valley-ngi pirti, ngapa warrkirnikinyi kaniny warnkunguja. ");
INSERT INTO nna_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kulipartirnayarninyi ngurrararrangulu japarta jirnakatalupa Isaac-milalu japarta jirnakatalupa. Ngurraralu wurrarnayijanaku, “Nyungu nganarnamili ngapa!” Isaac-ju yini marna pala ngapapinti “Kulipartinapintingi”. ");
INSERT INTO nna_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isaac-milalu warrkamukatalu karlinyiyi wariny pirti ngapapinti. Palangamarra kuli partirnayi. Palajunjalu yini marna “Malyparrjartinyju”. ");
INSERT INTO nna_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Palaja yana, wariny karlinyi ngapapinti. Palangamarra munu kulipartirnayi. Yini marna pala ngapapinti, “Warrarn Ngurrku-ngurrkumajirri”. “Ngarrkalu warrarn wirtu jirninganyjurruka yana-yananyaku, wirtu jarruliny nganarnaka kuwiyirrangu wiyirr, nganyjurru pukun.” ");
INSERT INTO nna_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Palaja Isaac yana Beersheba-karti. ");
INSERT INTO nna_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Palanga warrukartingi Ngarrka ngayarta jarrinyalu. “Ngajulungarra tuku jirnirnalu japartuku nyuntumilaku Abraham-ku. Munu wirnti karrinyaku, ngajulu kalkurnarnanta nyuntukupa. Ngajulu winyjirnirnili Abraham-ja, palajalu ngajulu ngalypa jilamarnanga, ngajulu yungkulumarnanta marlu jamuji karlujirrangupa nyirrirnikartijarrangu.” ");
INSERT INTO nna_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaac-ju kuru marna warnkurrangu, ngayinyja nyurra marna Ngarrka. Ngurra jarnti jirni palanga, warrkamukatalu palinymilalu karlinyi pirti ngapapinti wariny. ");
INSERT INTO nna_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelech tamarna, palinymilijartiny yatilpajartiny, Ahuzzath, Phicol pukun kanginyikinyi, nyampali palinymilaku kulikatarranguku. ");
INSERT INTO nna_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac-ju japirr marna, “Nyuntulu kulilu yirrirninyin purlpilu, wurrarnijin yakalamarna nyuntumili warrarn. Nganiku kuwarri milpanyanpa yirrinaku ngajuku?” ");
INSERT INTO nna_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","“Nganarnalu yirrirnayirni Ngarrkalu tuku jirninti. Winyjiliminyirnarninyi nganyjurru. Munu kurlu jirnimiyirninga, ngalypalu jirniyirningu, murru marnayirninti kulimajirrilu. Nganarnalu karrinyiyirna nyuntuku nganarnaku munurla kulilu yirrinaku. Ngarrkalu ngalypa yiji jirninti.” ");
INSERT INTO nna_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaac-ju manajaninyi mayirrangu marlu, mayikupa kuwiyiku kampanaku, wiyirrku ngananyaku. Nganayi mayi, wayinpa minpirniyi warajanga. ");
INSERT INTO nna_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Warinyja karrpungu pirrpa-pirrpanga muwarr winyjirnayirnangu. ");
INSERT INTO nna_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Palaja, “Jipi yarrayi! Yuu, jipi wantiyi!” Jinta pirniyarninyi ngarlu pikalyju. Palangangarra warajanga karrpungu Isaac-milirrangu warrkamukatarrangu milpanyiyalu, wurrarniyili, “Karlinyiyirni wariny pirti, ngapa manayirni!” ");
INSERT INTO nna_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Yini marna pala pirti ngapajartiny, “Shibah”, “Winyjinija Ngapapinti”. Palajunjalu pala tawun yini marnayi palalu yinilu, Beersheba, kuwarrikartijakun. ");
INSERT INTO nna_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau 40 partunurrangujartiny, manapulinyi kujarra mirtawajirri. Palajirri mirtawajirri ngurrara waninyikinyipulu, Hittite-milirranguja. ?? ");
INSERT INTO nna_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isaac-pa Rebekah pikalymajirri waninyikinyipulu ngarrayangamarrajirri. Ngarlu yija kurlu pirnipulupulinyi ngarrayalujirri. ");
INSERT INTO nna_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Mirtanya jarrinyaja Isaac pampuru jarrinyi. Warajanga karrpungu kamarnalu murrkangunyamurninyku, Esau-ku, “Murrkangunya, kurtali!” “Yuu, ngani?” ");
INSERT INTO nna_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Japartulu wurrarnala, “Pinakarra! Ngaju mirtanya jarrinyarni. Marlkarri jarrarnili kuwarri. ");
INSERT INTO nna_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","4","Wankanyin wankanyungu ngajungu, wurralamarnangu muwarr nyuntungu, nyungu muwarr Ngarrkalu ngalypa jilamanga. Pinakarraji, kawajaninyi jantu kuwiyikartilu. Wirlanajalu kampalapijin juri yiji kuwiyi ngajuku. Kuwiyi ngananyajalu wurralamarnangu muwarr, marlkarri jarrinyamarninyju.” ");
INSERT INTO nna_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Muwarr Esau-ngu wurranajalu, Rebekah-lu pinakarrinyikinyalu. Esau yana ngurraja kuwiyikarti. ");
INSERT INTO nna_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Palaja Rebekah-lu wurrarnala nyirtingunyamurninyja, “Pinakarrinyirni japartulu wurrarnikinyili mamajingi, ");
INSERT INTO nna_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Kuwiyikarti yarra, wirlanaja kulpanyajalu, kampalapijin juri yiji kuwiyi. Ngananyajalu wurralamarnangu muwarr ngalypa nyuntungu, marlkarri jarrinyamarninyju.' Palajun wurrarnala mamajingi. ");
INSERT INTO nna_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Pinakarraji nyuntulu, nyirti. ");
INSERT INTO nna_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Yarra, marrapulinyi kujarra wupartujirri nanikutujirri. Wirlanajalu kangkulupijin. Kampalamarnalu japartuku juri yiji kuwiyi, palinymili juri yiji. ");
INSERT INTO nna_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Nyuntulu kuwiyi kangkulumanpalu japartuku. Palaja wurralamangu nyuntungungarra muwarr ngalypakata, marlkarri jarrinyamarninyju.” ");
INSERT INTO nna_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob-ju karra marnalu, “Pinakarraji! Mamaji ngajumili mampuly-mampuly, ngaju kapuraly, mampumajirri. ");
INSERT INTO nna_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Japartulu warlilanyili. Warlinaja miranu jarrajili ngaju nyirti, wurralanyili, “Mitu marnanyin nyuntulu!” Wurralala Ngarrkanga, kurrpalamarnarninyi Ngarrkanga!” ");
INSERT INTO nna_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Pipilu wurrarnala, “Wirntiwayi! Munu kurrpalamanparningu. Ngajulu ngalypa jilamarnanga. Ngajuku pinakarraji. Nanikutujirri kangkulupijin.” ");
INSERT INTO nna_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacob-ju pinakarrinyalu pipimurninyku. Wirlarnapulinyi kujarra nanikutujirri, kanyapulinyi pipimurninykarti. Kamparnalu juri yiji kuwiyi palinymilaku pirirriku. ");
INSERT INTO nna_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Palaja Rebekah-lu mana ngalypakata wurrurrangu murrkangunyamurninymili, Esau-mili, yinyali pala wurru nyirtingunyamurninyja. “Wirrilarningu nyungu wurrurrangu.” ");
INSERT INTO nna_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Palaja manajaninyi kujarrapa waraja kutarrangu kiyirnarrangu nanikutuja, wirrirnili parirrjapa ngalyinga. ");
INSERT INTO nna_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Yinyali murla kuwiyipa martumpirri Jacob-ja. “Kawalu nyungu mayi japartukarti.” ");
INSERT INTO nna_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Palaja kanyalu mayi japartumurninykarti, karra marnalu, “Japartukayi!” “Yuu, nganurtu nyuntu?” ");
INSERT INTO nna_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob-ju mitu marna, karra marnalu, “Ngaju murrkangunya, Esau. Yananyaja kulpanyarnangu kuwiyijartiny, nyarrapa wurrarnajin. Kajala, ngala nyungu juri yiji kuwiyi. Ngananyajalu wurralapijin muwarr Ngarrkalupa ngalypa jilapiji.” ");
INSERT INTO nna_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac-ju karra marnala, “Payi! Nyampalu yiji manan kuwiyi!” Jacob-ju mitulu karra marnalu, “Nyampalilu nyuntumilalu Ngarrkalu nyampalu jurti jirniji kuwiyi.” ");
INSERT INTO nna_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac-ju karra marnalu, “Warinykapalirla muwarr pinan. Kurtali! Warlinajalu miranu jarrulumarnangu.” ");
INSERT INTO nna_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","23","Palaja wangka jarrinyalu, japartulu warlirni. Kiyirnalu palalu nanikutujalu mitu marna Isaac. “Nyuntu muwarr pinan Jacob-kapali, parirr nyuntu Esau-kapali.” ");
INSERT INTO nna_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Yijalmartangulu japirr marna japartumurninyju, “Yija-yiji nyuntu Esau?” “Yuu, ngaju Esau.” ");
INSERT INTO nna_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“Karnaji pala kuwiyi. Ngananyajalu wurralamarnangu ngajumili muwarr.” Jacob-ju kanyalu kuwiyi, yinyali minpinapinti pukurl, pilyarri wayin. ");
INSERT INTO nna_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Palaja ngananyajalu Isaac-ju karra marnalu, “Wangka kurtaliji, yampu malanyi.” ");
INSERT INTO nna_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Milpanyalu, yampu marna. Isaac-ju parntirni Esau-mili wurru. Karra marnalu Jacob-ku, “Ngajumili partany, parntinyan nyuntu warrulykapali, parntinyan warrarnkapali warruly juri yiji. Ngarrkalu kalkurnikinyi pala warrarn. ");
INSERT INTO nna_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ngarrkalu ngakalamangu ngapa warrarnku nyuntumilaku. Marlu mayi turlpulupiyi ngunarrijirri warrulyja nyuntumilingi warrarnja. Yungkulumanta mayi marlupa ngapa minpinaku. ");
INSERT INTO nna_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Marrngu ngunarrija warrarnja warinyarranguja warrkamu jilapiyingu, pinakarrulupiyingu. Nyuntu wantulumanjanaku nyampali marrkamilirranguku, nyuntumili pipimili partanykarrangu murtingi jurlpu-jurlpu jarrulupiyingu jinanga nyuntungu. Jinta panyju karrulupiyingu, japirr malapiyi Ngarrka kurlu jinaku nyuntuku. Puntaju kurlu jilkulinyjanaku Ngarrkalu. Jintalu ngalypa jilapiyingu. Puntaju ngalypa jilkulinyjanaku Ngarrkalu.” Palajun Jacob-ja wurrarnala Isaac-ju. Wurrarnala palajun ngalypa jilkuliny palinyku Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Palaja Jacob yana, yakarna palinymili japartu palanga. Jampa Esau kulpanya kuwiyikartija. ");
INSERT INTO nna_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kamparna kuwiyi jurikata. Kampanajalu kanyala japartukarti. “Japartukayi, kajala! Kuwiyi ngalkuluman nyungu ngajuja. Nganinyajalu wurralapijin Ngarrkamili ngalypakata muwarr. Ngarrkamilalu muwarrju ngalypa jilapijin ngajuku.” ");
INSERT INTO nna_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac-ju japirr marna paliny, “Nganurtu nyuntu?” “Ngaju nyuntumili murrkangunya, Esau.” ");
INSERT INTO nna_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Jampa pinakarrinyi Esau-mili muwarr, jannganka pirni wirntijartiny. “Nganurtulu kuwiyi wirlanajalu yinyaji ngajungu? Jipi kuwiyi nganarna ngajulu, kuwiyi wiyirr. Yinyarnala ngajumili ngalypakata muwarr palinyja. Yuu, Ngarrkalu ngalypa jilkulinypalu muwarrja palaja.” ");
INSERT INTO nna_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Jampa Esau-lu pinakarrinyi pala muwarr ngarlu kurlu jarrinyi. Ngangkurl jirni marrja palanga paliny. Japirr marna japartumurniny palinyju, “Yuwanyi nyuntumili ngalypakata muwarr ngajungu pukun.” ");
INSERT INTO nna_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Palinyju karra marnalu, “Munu yiji! Ngajulu yinyarnala ngajumili ngalypakata muwarr. Nyuntumilalu marrkalu mitu marnanyi muwarrku palaku. Yinyarnala palinyja ngajumili ngalypakata muwarr. Munu yiji yinganyakarnanta pala muwarr.” ");
INSERT INTO nna_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau-lu karra marna, “Ngajumili marrka waninyi marrnguku mitu manaku. Yini yija-yiji ngalypakata Jacob palinyku. Kujarramal mitu marnanyi ngajumilalu marrkalu. Mitu marnanyi mamajikapali wurrarnanyi ngaju. Mitu marnanta muwarrku Ngarrkamilaku, yinyanpili palinyja, munu yingamijin ngajungu. Yungkulupijinkurra ngajungu pukun nyuntumili ngalypakata muwarr! Palajun Ngarrkalu ngalypa jilapiji ngajungu pukun.” ");
INSERT INTO nna_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac-ju karra marnalu, “Wunyjurrulu muwarrju wurralkurnungu, ngajumili partany? Ngajulu wirrirnirni nyuntumili marrka nyampali nyuntuku. Nyuntumilirrangu warrkamu jarrulupiyijanaku palinymilirranguku. Wurrarnarnala palinyja, palinyju mankuliny kurrngal mayipa wayin.” ");
INSERT INTO nna_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau-lu wurrarnala japartumurninyja, “Wupartu muwarr ngalypakata yuwaji! Wurralaji warajajakun ngalypakata muwarr!” Ngangkurl jirni paliny marrja. ");
INSERT INTO nna_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Japartumurninyju karra marnalu, “Nyuntu wantuluman pujunungu warrarnja, ngapapa puru pungkulumangu wupartu nyuntumilingi warrarnja. ");
INSERT INTO nna_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Waninyangkuluman kulikarra palanga. Marrka waninyangkulumangu nyampali nyuntuku. Yartipa jinta kangkulumanpili. Palaja munu jakurlilamanta warrkamuku. Palangarra muwarr yinganyarninta, partany.” ");
INSERT INTO nna_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Palangulu Esau-lu kurlkarri marnikinyi japartumili ngalypakata muwarr Ngarrkaja, yinyali japartumurninyju Jacob-ja. Palajalu Esau panyju karrinyikinyalu marrkamurninyku palinymilaku. Kurlkarri marnikinyi palinyju, “Yartipa marlkarri jarruliny ngajumili japartu. Palinyku ngangkurl jilaminyalu. Palangulu marlkarri wirlalamarnaja marrka.” ");
INSERT INTO nna_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Wariny palaku muwarrku Esau-milaku miranu jarrinyi, wurrarnala pipingi pulanymilingi. Marrkamurninyku kamarnalu Rebekah-lu, wurrarnala, “Nyuntumilalu mamajilu kurlkarri marninyi wirlanaku nyuntuku marlkarri. Puntajulu wirlalapiyi paliny pukun. Ngaju wantulumarna partanymajirri. ");
INSERT INTO nna_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Pinakarraji, marlkarringimarra. Yarra nyunguja. Yarra warrarn warinykarti, ngapikarti, Haran-karti, ngajumili mamajikarti, Laban-karti. ");
INSERT INTO nna_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Palanga wantulumanpili jampakurra. ");
INSERT INTO nna_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Yartipa mamajilu kakulkulinypili nyarrapa mitu marnan. Palaja mamaji ngalypa jarrulumangu nyuntuku, kulimajirri. Palaja muwarr ngakalamarnangu. Ngajulu karrinyarnanyumpuluku wankaku waninyaku, marlkarriwayi.” Palajun Rebekah muwarr pirnili. ");
INSERT INTO nna_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Palaja Rebekah-lu karra marnalu palinymili pirirriku, “Palajirri mirtawajirri Heth-milirranguja, mirtawajirri Esau-milijirri, malyparr jinanyipulu. Yijapa Jacob-ju mirtawa nyunguja warrarnja marrali, Heth-milirranguja. Yijapa palajun jarrinyajanga ngaju panyju karrulumarna wankanyuku waninyaku, marlkarri jarrulumarnajanaku janangamarra.” ");
INSERT INTO nna_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac-ju kamarnalu Jacob-ku, muwarr pinalu ngalypalu, “Nyuntulu mankuluman mirtawa nyungujawayi, Canaan-jawayi. ");
INSERT INTO nna_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nyunguja yankuluman ngunarri warrarn warinykarti, ngapikarti, Mesopotamia-karti. Yankuluman ngurrakarti ngapikarti, Bethuel-karti, nyuntumili jamujikarti. Mankulumanparnanga mirtawa palajangarra, kakajija nyuntumilija, Laban-ja. ");
INSERT INTO nna_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ngarrkalu ngalypa jilamanga nyuntuku, yungkulumanta partanykarrangu marlu, kurrngal yiji wantulkulinyurru. ");
INSERT INTO nna_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngarrkalu palajun jirni Abraham-ku. Nyuntuku palajun jilamanga, partanykarrangukupa. Yungkulumanta nyungu warrarn nyuntungu ngarramarntiku. Kuwarri waninyan ngajarrikapali nyungungu warrarnji. Yarti yungkulumanta nyungu warrarn ngarramarntiku Ngarrkalu. Purlpi wurrarnala Abraham-ja, “Nyungu warrarn wantuliny nyuntumilirranguku.” ");
INSERT INTO nna_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Palajunja Isaac-ju ngakarna Jacob ngunarri. Palaja Jacob Mesopotamia-karti yananyikinyi, kakajiku kanyjirnikinyalu, Laban-ku, ngurranga ngapinga, warrarnja Aram-ja. Pala Laban partany Bethuel-mili. ");
INSERT INTO nna_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Kuwarri miranu Esau, japartulu palinymilalu Isaac-ju ngalypa muwarr Ngarrkaja yinganyajalu Jacob, ngakarna Paddan-Aram-karti mirtawa kanganyaku. Miranu Isaac wurrarnalu, “Munu mankulumanparningu Canaanite mirtawa.” ");
INSERT INTO nna_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Miranu pukun, Jacob purlpi yana Paddan-aram-karti muwarrja pipipa japartuja muwarrja. ");
INSERT INTO nna_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Miranu yija jarrinyi Esau, japartu palinymili panyju karrinyajanaku ngurraraku mirtawanyjarriku, Canaanite mirtawanyjarriku. ");
INSERT INTO nna_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Palajalu Esau yana kakajimili ngurra, Ishmael-mili ngurra, kanya kurntal kakajimili mirtawaku. (Purlpi kanyapulinyi Canaanite-jirri mirtawajirri.) Nyungu kuwarrija mirtawa yini Mahalath. Kangkuji paliny Nebaioth-ku. Nyungu Mahalath Abraham-mili kaparliji, Ishmael-mili kurntal. ");
INSERT INTO nna_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob-ju yakarna pala warrarn Beersheba, yananyikinyi paliny tawunkarti, Haran-karti. ");
INSERT INTO nna_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Karrpu kaniny jarrinyaja palinyju ngurra jirni partijirri. Paliny karta karrinyikinyi jurnturtu warnkunga. ");
INSERT INTO nna_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Palanga palinyju kartanga kapukarri marna. Yirrirni palinyju ngapi, karntinyapinti, katukarnikinyi jungkakarti. Ngarrkamili angel-arrangu jinta karntinyikinyiyi, jinta katukarnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Palanga kapukarringa yirrirni Ngarrka pukun, wararr karrinyikinyili wangka palinymartaji. Jacob-ja wurrarnala, “Ngarrka ngaju. Ngajulungarra kalkurnukinyirnipulinyi Abraham-pa Isaac, nyuntumili karlujipa japartu. Ngajumili pukun palajirri. Nyungu nawu warrarn yungkulumarnanta karta karrinyinpa, nyuntungupa nyuntumili partanykarrangungupa. ");
INSERT INTO nna_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mankulumanjaninyi partanykarrangu marlu. Yankulupiyi ngunarrijirri, karapa kakarra, yalinyjipa kurila. Nyuntumilalu partanykarrangulupa nyuntulu ngalypa jilkulinyurrujanaku marrngurranguku jintakupa warrarn warinyjarrangukupa. ");
INSERT INTO nna_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ngaju wantulumarnanga nyuntungu wanyjarnipa yankuluman. Yarti kulpanya jilamarnanta nyungukarti warrarnkarti. Munu yakalamarnanta, ngaju wantulumarnanga. Ngajulu jilimarnanga nyarrapa wurrarnarnangu.” Palajun muwarr pirnili Jacob-ku Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Palaja kartaja parrily jarrinyi Jacob. Paliny wirnti karrinyikinyi. “Payi. Ngarrka nyungu waninyi, munumpa ngaju, puru karta karrinyikinyirni. Nyungulu ngurralu wirntiji pirninyi. Payi yija nyungu ngurra Ngarrkamili, nyungungu waninyi paliny!” ");
INSERT INTO nna_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Pirrpa-pirrpanga kartaja turlpanya Jacob. Palaja warnku pala mana, jurnturtulupa nyilkarnikinyi, pala wararr jirni, wuyil jurtirni palanga warnkunga. Palajun jirni kurlka jinaku palinyku palanga muwarr pinalu Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Palinyju yini marna pala ngurra Bethel. Palalu yinilu wurrarna “Maya Ngarrkamili”. (Palamartaji ngurramartaji tawun waninyikinyi wangka, purlpi yini marnikinyiyi Luz.) ");
INSERT INTO nna_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Palaja karra marnalu Ngarrkaku, “Nyuntulu wurrarnajin ngajungu wantulupijin, tuku jiliminyin, yungkuluminyin wurrupa mayipa, ");
INSERT INTO nna_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nyuntulu tuku kalkuluminyin, kulpanya jiliminyin ngajumilikarti japartumilikarti ngurrakarti. Ngajuku palajun jilaman, ngajulu pinakarrulumarnanga nganipa wurralapijin. ");
INSERT INTO nna_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ngajulu muwarr pilimarnangu nyungungu warnkupa nyungu wararr jirnirni. Yungkuluminyinpa 10 wurrukarra, palaja kulpanya yungkulumarnanta waraja.” Palajun muwarr pinalu Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Palaja Pijilja yana jinangu. Yartikarra turlpanyajanaku warrarnja warinyja, kakarranga. ");
INSERT INTO nna_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Palaja palinyju parrjarn-parrjarnikinyi, yijalu ngapa karlinaja yirrirni, yamarnikinyi warnkulu wirtulu. Palanga yirrirnijaninyi kujarrapa waraja kurrngalarrangu kukurnjayirrangu, ngapanga wangkamartaji karta-karta karrinyikinyiyi, mimarnikinyiyi ngapaku. ");
INSERT INTO nna_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tuku jirnikinyiyijaninyi palarrangu kukurnjayirrangu, kanginyikinyiyijaninyi ngapa karlinyajakarti. Jampa wiyirr kajanaja ngapanga pala warnku purlu jirnikinyiyi. Minpinajalu kulpanya warnku wirrirnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob-ju karra marnajanaku marrngu tuku kalkunukatarranguku, “Wanyjarnija nyurra?” Puntaju karra marnayalu palinyku, “Nganarna tawunja, ngapija, Haran-ja.” ");
INSERT INTO nna_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Palinyju karra marnajanaku, “Nyurra miranu Laban-ku, Nahor-mili karluji?” “Yuu, nganarna miranu.” ");
INSERT INTO nna_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Ngalypangarra waninyi?” “Yuu, paliny ngalypa waninyi. Parrjala, mirtawa partany palinymili turlpanya kuwarri kukurnjayirrangujartiny.” ");
INSERT INTO nna_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Palinyju karra marnajanaku, “Pinakarrayi. Karrpu kanka ngarrany waninyi. Nganiku kanganyanyurrujaninyi kukurnjayirrangu karrpu kankanga? Nyampalu yuwayijaninyi ngapa, palaja nyampalu kulpanya kawayijaninyi warrulykarti.” ");
INSERT INTO nna_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Puntaju karra marnayalu, “Munu yinganyakupa ngapaku, mimalapiyirnijanaku jinta warinyku kukurnjayirranguku. Yijamarta palajalu warnku nyungu purlu jilipiyirni, palajunjalu yungkulupiyirnijaninyi ngapa.” ");
INSERT INTO nna_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Muwarr pinajalu, kajarnajanaku Rachel japartumurninymili kukurnjayirrangujartiny. Palinyjungarra kalkurnikinyijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jampa yirrirni Rachel-pa kukurnjayirrangu kakamurninymili, Jacob ngapa karlinyajakarti yana, purlu jirni pala wirtu warnku kankakartija, ngapa yinyajaninyi kakamurninymili kukurnjayirrangu. ");
INSERT INTO nna_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Palaja Rachel yampu marna manyjarraja. ");
INSERT INTO nna_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Wurrarnala, “Nyuntumili japartu ngajumilaku pipiku mamaji. Pipi ngajumili Rebekah.” Mirti jarrinyi Rachel pala muwarr wurranaku japartuku palinymilaku. ");
INSERT INTO nna_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pala muwarr pinakarrinyaja nyampa yana Laban pujamumurninykarti. Yampu marna, ngurrakarti kanya. Jacob-ju wurrarnala wunyjurru ngunarrija turlpanyaja warinyja warrarnja waljaja. ");
INSERT INTO nna_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban-ju wurranala, “Nyunturla pujamumurniny walja. Nyungungu wantuluman ngajungu.” Palanga waninyi Jacob, warrkamu jarrinyi kakajimurninyku waraja wirlarra. ");
INSERT INTO nna_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Palaja Laban-ju karra marnalu, “Pujamu nyuntu ngajumili walja. Warrkamu jarrinyikinyijin puru. Kuwarri warrkamuja nganipa yungkulumarnanta?” ");
INSERT INTO nna_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","18","Laban partanykarrangu kurntaljirripa pirirrirrangu. Wariny kurntal Leah, wariny Rachel. Leah jirtamarra kurluny-kurluny. Rachel kumparakata yiji. Jacob Rachel marru marnakinyi, karrinyikinyalu mirtawaku. Palajalu karra marnalu Laban-ku, “Warrkamu jarrulumarnangu partunurranguku 7-ku. Palaja yungkuluminyin Rachel mirtawa.” ");
INSERT INTO nna_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban-ju karra marnalu, “Yuu. Nyuntu yungkulumarnanta Rachel, jintawayinga. Yija nyungungarra wantuluman ngajungu.” ");
INSERT INTO nna_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Palaja warrkamu jarrinyikinyalu kakamurninyku punja, partunurranguku 7-ku. Yija-yiji marru marnakinyi pala mirtawa. Palajalu warrkamu jarrinyikinyi mimarnakinyi partunurrangu 7, kurlkarri marnakinyi karrpu kujarrapa warajakapali warrkamu jarrinyikinyi palaku mirtawaku. ");
INSERT INTO nna_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Palaja karra marnalu kakajimurninyku, “Warrkamu jarrinyarnangu partunurranguku 7-ku. Nyampa yuwaji pilyurr ngajungu.” ");
INSERT INTO nna_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban-ju muwarr ngakarnajanaku palamartajiku marrngurranguku milpanyaku ngurrakarti palinymilikarti. “Mayi ngalkuluminyipulaku nyungukujirri kulunuja wantulinypulu pirirripa mirtawa.” Warrkamukatarrangulu palinymilalu mayi wirtu kamparnayajanaku ngananyaku. ");
INSERT INTO nna_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Warrukarti jarrinyaja Laban-ju pujamumurninykarti kanyalu Leah, Rachel-mili kangkujimurniny, wurrarnala, “Nyungu nawu pilyurr nyuntumili.” ");
INSERT INTO nna_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban-ju wariny mirtawa warrkamuku yinyali Leah-nga, yini Zilpah.) ");
INSERT INTO nna_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Palanga warrukartingi Jacob karta karrinyi Leah-nga. Jampa parrily jarrinyi kartakarralungarra wariny yirrirni Leah! Palanga paliny kuli jarrinyi, karra marnalu kakamurninyku, “Nganija mitu marnanyin? Ngaju warrkamu jarrinyarnangu warinyku mirtawaku, Rachel-ku. Nganija yinyanyan Leah?” ");
INSERT INTO nna_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban-ju karra marnalu, “Nyungu wupartumurniny warlilamarnangu. Walangkarra pilkuliny wirtumurniny. Palajunpinti nganarnamili. ");
INSERT INTO nna_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mimalaman jampa. 7-ja karrpuja jipi jilaminyi nyunguku nyupaku. Palaja yungkulumarnanta wariny nyupa. Palaja warrkamu jarrulupijin 7 partunurrangu wupartumurninyku.” ");
INSERT INTO nna_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob-ju pinakarrikinyalu Laban-ku. “Yuu, yarrana warrkamu jilamarnanga.” Palaja waninyikinyi Leah-nga karrpurranguku 7-ku, palaja Laban-ju yinyali wariny mirtawa, Rachel. ");
INSERT INTO nna_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban-ju wariny mirtawa warrkamuku yinyali Rachel-ja, yini Bilhah.) ");
INSERT INTO nna_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob-ju karrinyikinyalu Rachel-kujakun, yakarl marnakinyi Leah. Palaku mirtawaku Rachel-ku yarrana warrkamu jarrinyikinyalu kakajimurninyku partunurranguku 7-ku. ");
INSERT INTO nna_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ngarrkalu parrjarnakinyi Jacob wunyjurru jarrinyaja. Paju karrinyalu Leah-ku Ngarrka, yinyali Leah-nga partanykarrangu. Palinymili marrkamurniny partanymajirri waninyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Palaja Leah ngayinykarra jarrinyi. Yijalu palinyju mana partany pirirri. Palinyju kurlkarri marna Ngarrka, “Paju karrinyaji Ngarrkalu. Partany yinyanyi nyungu pirirri. Yija ngajumili nyupa ngarluja wantulupiji, nyungu partany manarnalu.” Pala yini marna partany murrkangunya Reuben. Reuben sounds like, “Look! A son!”, and like, “He has seen my misery”. ");
INSERT INTO nna_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Palaja palinyju partany warinymal mana, pirirri. “Ngarrkalu parrjarna ngajumili pirirri, munu karrinyikinyiji, yinyaji partany wariny Ngarrkalu.” Yini marna pala partany Simeon. Simeon sounds like, “One who hears”. ");
INSERT INTO nna_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Palaja partany warinymal mana, pirirri. Palaja karra marna, “Ngajumilinga pirirringa yinyarnalu partanykarrangu pirirrimarta kujarrapa waraja. Kuwarri yiji ngarluja wantulupiji.” Yini marna pala Levi. Levi sounds like, “being attached”, or “feeling affection for”. ");
INSERT INTO nna_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Palaja partany warinymal mana, pirirri. Karra marnalu Ngarrkaku, “Yarranijayi, Ngarrka! Nyurra malamarnanta.” Yini marna pala pirirri Judah. Palaja partanymajirri waninyi punja. Judah is related to the Hebrew word for “Praise”, with the thought that “I will praise the Lord”. (Had she given up on Jacob loving her just because she bore him sons!) ");
INSERT INTO nna_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel waninyikinyi partanymajirri. Paliny miku jarrinyikinyi palinymilaku kangkujiku. Palinyju karra marnalu palaku pirirriku, “Partany ngalilupa mankulupali. Munujalu marlkarri jarrulumarna.” ");
INSERT INTO nna_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob palaja kuli jarrinyi palinymili mirtawaku. “Munu ngajukupa parrjanaku. Munuyiji munu ngaju Ngarrkakapali. Ngarrkalungarra kunta jirnanti partany mananyaku.” ");
INSERT INTO nna_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachel-ju karra marnalu Jacob-ku, “Pala nawu mirtawa, warrkamukata ngajumili, Bilhah. Karta karrulunyumpulu. Palinyjungarra mankulkulupija partany ngajuku. Pala partany wantulupiji ngajuku.” Palajun muwarr pinalu Rachel-ju. ");
INSERT INTO nna_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Palaja yijangarra Jacob karta karrinyi palanga warrkamukatanga mirtawaji. ");
INSERT INTO nna_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah palanga ngayinykarra jarrinyi, pirirri partany mana. ");
INSERT INTO nna_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel-ju karra marna, “Ngajulu japirr marnarna Ngarrka yungkulupiji partany ngajuku. Palinyju pinakarrinyiji, yinyanyi partany pirirri.” Yini marna pala partany Dan. “Dan” means “he judged” or “he vindicated”. Rachel felt vindicated. ");
INSERT INTO nna_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Yarrana ngayinykarra jarrinyi pala warrkamukata mirtawa, palaja partany mana wariny, pirirri. ");
INSERT INTO nna_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel-ju karra marna, “Ngalayi mirarnakinyaliyirnarninyi partanyjamarra, ngajulu yiji mirarnarna partanyku.” Put this sentence into the lexicon! Yini marna pala partany Naphtali. “Naphtali” means, “my struggle”. ");
INSERT INTO nna_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah-lu karra marna, “Kuwarringarra partanymajirri wantulumarna. Ngajumili warrkamukata mirtawa yungkulmarnalu ngajumilinga pirirringa. Palinyju mankuliny partany ngajuku.” ");
INSERT INTO nna_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Palajalu Zilpah-lu partany pirirri kanya Jacob-ku. ");
INSERT INTO nna_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah-lu karra marna, “Yarranijayi!” Yini marna pala partany Gad. “Gad” means, “good fortune”. ");
INSERT INTO nna_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Palajalu Zilpah-lu mana partany wariny, pirirri. ");
INSERT INTO nna_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah-lu karra marna, “Ngaju pikaly jarrinyarna. Mirtawanyjarrilu wurralaminyiyi pikalykata.” Yini marna pala partany Asher. “Asher” means, “happy” ");
INSERT INTO nna_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Yurranga jarrinyijanaku. Marrngurrangulu mananyikinyiyijaninyi palarrangu mayirrangu, ngapirrangu, wiyitirrangu. Palanga Reuben, Leah-mili murrkangunya, yana ngurraja ngunarri. Yirrirnijaninyi pirraja warruly, ngapi, manturayiki. Jinta manajaninyi, kanyajaninyi pipikarti. Rachel-ju japirr marna mirtamarniny kangkuji, “Jinta yuwanyi pala manturayiki partanymili nyuntumilimili.” ");
INSERT INTO nna_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Palanga Leah kuli jarrinyalu. “Jipi kanyajinpa pirirri, nyungukurna kamu karrinyan ngajumilalu partanyju manaja, pala mirrijin ngayinykarra jinaku.” ");
INSERT INTO nna_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jarurrukartingi warrkamuja warruly-warrulyja Jacob kulpanya ngunarrija, ngurrakarti. Leah-lu purrpi karrinyalu. Palaja karra marnalu, “Kuwarringa warrukartinga ngali karta karrulupali. Yinyarnalu ngajumilinga marrkanga jinta manturayiki, partanyju manaja. Palaja karta karrulupali.” Palanga warrukartingi yijangarra karta karrinyipulu. ");
INSERT INTO nna_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ngarrkalu pinakarrinyirri Leah-ku, palaja ngayinykarra jirni. Palaja wariny mana partany, pirirri. ");
INSERT INTO nna_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah-lu karra marna, “Ngajulu yinyarnala ngajumili warrkamukata mirtawa karta karrinyaku ngajumilinga pirirringa. Palajunjalu Ngarrkalu yinyaji partany wariny pirirri.” Yini marna pala partany Issachar. “Issachar” sounds like, “reward” or “my hire”. ");
INSERT INTO nna_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Palajalu palalu Leah-lu wariny mana partany, pirirri. ");
INSERT INTO nna_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Karra marna, “Ngarrkalu ngalypa jirniji ngajunga. Ngajulu kanyarnajaninyi pirirrimarta 6 ngajumilaku pirirriku. Palajunjalu kuwarri wurralapiji yija-yiji mirtawa ngaju.” Yini marna pala partany Zebulun. “Zebulun” probably means “honour”; it also means “gift”. ");
INSERT INTO nna_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Yarti yiji palajalu wariny mana partany, mirtawa. Pala yini mana Dinah. ");
INSERT INTO nna_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Palaja Ngarrkalu pinakarrinyalu Rachel-ku. Purlpija warrarnja Rachel-ju japirr marnikinyi Ngarrka partanykarranguku yinganyaku. Yartikarra pinakarrinyalu. ");
INSERT INTO nna_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Yijangarra ngayinykarra jarrinyi paliny, mana partany, pirirri. Karra marna, “God has taken away my shame.” “Kurntany waninyikinyirni purlpija warrarnja partanymajirri. Yijalungarra Ngarrkalu yinyaji partany. Munu janalu kurntany jiliminyiyi.” ");
INSERT INTO nna_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Yini marna pala partany Joseph 'asap “take away” sounds like “Joseph”, which means “may he add”. Karra marna, “Yijapa yungkuluminyi wariny partany, pirirri.” ");
INSERT INTO nna_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Jampa Joseph-ja ngayarta jarrinyajalu Jacob-ju karra marnalu kakajimurninyku, “Ngaju kulpulumarna ngajumilikarti warrarnkarti waljakarti. ");
INSERT INTO nna_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Yijalu warrkamu jarrinyarnangu palarrangukupa mirtawaku partanykarrangukupa. Nyuntu miranungarra palaku. Kuwarringa kangkulumarnajaninyi palamarrangu. Munu ngajuku ngatu jinaku nyuntulu. Yankulumarna.” ");
INSERT INTO nna_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban-ju karra marnalu, “Pinakarraji. Ngajulu karrinyarnangu nyungunguku waninyaku. Jampa nyuntu turlpanyan ngunarrija purlpi Ngarrkalu ngalypa jirnikinyiji ngajuku, palinyju yinyaji marlu jarnturrangu kuwiyirrangu. Palaku ngaju miranu jarrinyarna maparnja kankarni. Palajunja ngajulu karrinyarnangu purukata wantaji. ");
INSERT INTO nna_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Yini malanyinga nganikupa nyuntu karrinyan, ngajulu yungkulumarnanta nganipa, palaja wantulupijin.” ");
INSERT INTO nna_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob-ju karra marnalu, “Ngaju jipi warrkamu jarrinyarnangu. Tuku jirnirnijaninyi kuwiyirrangu nyuntumilirrangu. Nyuntu miranungarra palaku. ");
INSERT INTO nna_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nyuntu wanikinyin wupartumartarrangujartiny kuwiyirrangujartiny. Jampa ngaju turlpanyarna nyungukarti marlu jarrinyiyinga. Ngaju warrkamu jarrinyarnangu. Palajalu Ngarrkalu tuku jirnikinyinti. Kuwarri ngajulu tuku jilamarnajaninyi ngajumili partanykarrangupa.” ");
INSERT INTO nna_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Laban-ju japirr marnalu, “Ngani yungkulumarnanta? Wurraliji.” Puntaju karra marnalu Jacob-ju, “Munu yinganyakupa warnkuku. Kula, wurralamarnangu. Kuwarringa parrjalamarnajaninyi kuwiyirrangu nyuntumilirrangu, jinta pilamarnajaninyi, kangkulumarnajaninyi warrukurla kukurnjayirrangupa taparl-taparl nanikuturrangu. Palamarninyarrangu. Ngajumili wantulupijiya palarrangu, jinta wiyirr nyuntumili. Yuu, karra malaman nyuntulu, nyuntungu wantulumarnanga, tuku jilamarnajaninyi kuwiyirrangu nyuntumilirrangu nyuntuku. ");
INSERT INTO nna_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Yartipa yirrilaman ngajulu ngalypa jilamarnangu, ngajulu munu mitu manakupa nyuntuku. Nyuntulu parrjalaman palarrangu kuwiyirrangu. Jintamarniny wantulupiyi warrukurla kukurnjayirrangu, jintamarniny wantulupiyi taparl-taparl nanikuturrangu. Yijapa yirrilamanjaninyi warinypa wariny, nyuntu miranu jarruluman ngajulu ngulyulu kanyarnangu.” Palajun karra marnalu. ");
INSERT INTO nna_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Puntaju karra marnalu Laban-ju, “Yuu, ngalypa. Palajun jilaman.” ");
INSERT INTO nna_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","36","Laban-ju mitu marna Jacob. Palangangarra karrpungu palinyju kanyajaninyi wiyirr taparl-taparl nanikuturrangupa wiyirr warrukurlarrangu kukurnjayirrangu, wurrarnajanaku palinymilinga partanykarrangungu pirirrimartanga, “Kawayijaninyi nyungurrangu nanikuturrangupa kukurnjayirrangu ngunarri kaja, tuku jilayijaninyi ngunarringa.” Palajalu muwarrjalu kanyayijaninyi kujarrapa waraja karrpurrangu. Palaja Jacob-ju tuku jirnikinyijaninyi jinta wariny Laban-mili kuwiyirrangu. ");
INSERT INTO nna_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Palanga Jacob-ju ngartarnajaninyi yalyurrangu, wupartu-wupartu karnu pirnijaninyi mirta-mirta marni jarrinyaku. ");
INSERT INTO nna_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Palinyju wirrirnijaninyi palarrangu karnu pinaja yalyurrangu ngapamartaji. Jampa palarrangu kuwiyirrangu turlpanyikinyiyi ngapakarti yirrirnikinyiyijaninyi palarrangu yalyurrangu. Ngapanga wangka jarrinyajalu yumuny jarrinyikinyiyi. Yumuny jarrinyijalu parrjarnikinyiyijaninyi palarrangu yalyurrangu. Palajalu kukurnjayirrangulu kanyayijaninyi wupartupani warrukurla, nanikutulurrangu kanyayijaninyi wupartupani taparl-taparl marnijartiny. ");
INSERT INTO nna_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Palaja palinyju jinta pirnijaninyi palarrangu wupajupanirrangu. Munu wirrirnamajaninyi Laban-milinga kuwiyirrangunga. Palinyju wirrirnijaninyi mirtanya-mirtanyarrangu kuwiyirrangu ngumpa Laban-milikarti. ");
INSERT INTO nna_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Jampa palarrangu kuwiyirrangu marrjapanurrangu yumuny jarrinyikinyiyi Jacob-ju wirrirnijaninyi palarrangu yalyurrangu walangkarra jananga. ");
INSERT INTO nna_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Jampa manyurla-manyurlarrangu kuwiyirrangu yumuny jarrinyikinyiyi, munu wirrirnamajanaku palarrangu yalyurrangu Jacob-ju. ");
INSERT INTO nna_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Palajunjalu Jacob-ju manarninga marlu yiji kukurnjayirrangupa nanikuturrangu. Palinyju kalkurnikinyijaninyi marlu kamalpa tangki, pirirripa mirtawa warrkamukatarrangu pukun. ");
INSERT INTO nna_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Palaja Laban-mili partanykarrangu pirirrimartalu yimpirnikinyiyi Jacob. Janalu karra marnayi, “Jacob-ju wiyirr kanyajaninyi nganyjurrumilaku japartumilaku kuwiyirrangu. Palajunja palinyju kalkurnajaninyi marlu kuwiyirrangu. Palarrangu waninyikiyalu nganyjurrumili japartuku.” Jacob-ju pinakarrinyalu janamilaku muwarrku yimpinajaku. ");
INSERT INTO nna_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Laban-ju malyparr karrinyikinyalu. Jacob miranungarra paliny. ");
INSERT INTO nna_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Palajalu Ngarrkalu karra marnalu Jacob-ku, “Kulpa nyuntumili japartumili warrarnkarti, nyuntumili walja marrngukarti. Ngajulu tuku jilamarnanta.” Palajunju Ngarrkalu karra marnalu. ");
INSERT INTO nna_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Palanga Jacob waninyikinyi ngunarri jalanga, palinymilijartiny kuwiyirrangujartiny. Palaja muwarr ngakarnapulaku palinymilaku mirtawakujirri, Rachel-pa Leah-karti, milpanyaku palinykartiku. ");
INSERT INTO nna_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jampa turlpanyapulu palinyju karra marnapulaku, “Nyumpalamili japartu ngalyparla waninyikinyiji, kuwarringa munu jarrinyiji. Ngaju miranungarra paliny malyparr karrinyiji. Ngarrkalu tuku jirnikinyinyi. Palinyjungarra tuku jirnikinyi ngajumilaku japartuku, tuku jirnikinyinyi ngaju pukun. ");
INSERT INTO nna_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nyumpala miranungarra ngajuku, warrkamu jarrinyirnili nyumpalamilaku japartuku punja. ");
INSERT INTO nna_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Palinyju mitu marnanyi marlumal ngani warralkupa. Ngarrkalu kunta jirnikinyi Laban, munu kulilu yirrinaku ngaju. ");
INSERT INTO nna_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nyumpalamilalu japartulu wurrarnaji ngajunga, 'Nyuntulu kalkulumanjaninyi warrukurlarrangu kukurnjarirrangu puntaju pala warrkamujalu.' Palaja palarrangulu kukurnjarirrangulu kanyayijaninyi partanykarrangu warrukurlarrangu. Nyumpalamilalu japartulu wurrarnaji ngajungu, 'Nyuntulu kalkulumanjaninyi taparl-taparl marnijartinyarrangu nanikuturrangu puntaju pala warrkamujalu.' Palaja palarrangulu nanikuturrangulu kanyayijaninyi partanykarrangu taparl-taparl marnijartinyarrangu. ");
INSERT INTO nna_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kanganyikinyijaninyi kuwiyirrangu nyuntumilija japartuja Ngarrkalungarra, yinganyikinyijaninyi ngajunga. ");
INSERT INTO nna_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Kuwiyirrangu yumuny jarrinyajanga ngajulu kapukarri manarna. Palanga kapukarringa ngajulu yirrirnirni taparl-taparl marnijartiny pirirrimarta nanikuturrangu yumuny jarrinyikinyiyi mirtawanyjarrirrangunga, jinta pirirrimarta nanikuturrangu munu yumuny jarrimiyi. ");
INSERT INTO nna_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Palanga kapukarringa Ngarrkalu muwarr pirniji, 'Jacob-kayi!' 'Yuu, ngani?' ");
INSERT INTO nna_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","13","'Ngaju Ngarrka. Purlpi Bethel-ja miral jarrinyarnanga. Palanga nyarra warnku jarnti jirnin kurlkali manapintiku, wuyilpa jurtirnijin palanga warnkunga, nyuntulu karra marnajin, “Nyuntungu pinakarrulumarnanga.” Ngajulu parrjarnakinyirninti. Miranungarra ngaju Laban-ku, mitu marnikinyinti. Parrjalajaninyi palarrangu kuwiyirrangu. Taparl-taparl marnijartiny pirirri nanikuturrangu yumuny jarrinyiyi, jinta pirirri nanikuturrangu munu yumuny jarrinyikiyi. Kuwarri pinakarraji ngajuku. Yakala nyungu warrarn, kulpa warrarn waljakarti.' Palajun muwarr pirniji Ngarrkalu.” ");
INSERT INTO nna_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel-jupa Leah-lu pinakarrinyipulu Jacob-mili muwarrku. Puntaju karra marnapulalu, “Ngalayimilalu japartulu munu yungkulinyngalayinyi nganipa palinymilija. ");
INSERT INTO nna_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Warinykapali wurrarnangalayinyi. Purlpi warrkamujalu puntaju yinyanta ngalayi nyuntungu. Palangulu kurrngal wurrukarrarrangu manajaninyi. Kuwarri munu kalkurnaka nganipa. ");
INSERT INTO nna_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ngarrkalu kanyajaninyi palinyja wurrukarrarrangu, palarrangu jipi yinyanta nyuntu. Palajalu palarrangu warralpirti kuwarri ngalayimilipa ngalayimili partanykarrangumili. Pinakarralu Ngarrkaku. Jilalu nganipa wurralamangu.” ");
INSERT INTO nna_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","20","Palaja Jacob-ju wurrukarrarrangu maninyikinyijaninyi yakanamarninyju. Munu wurrarnamala Laban-ja. Laban purlpi yana ngurraja wirrkanaku mampuku kukurnjarirranguja. Ngunarrijalu Laban-jalu Rachel-ju kukujarrilu ngulyu marnajaninyi palinymili japartumili ngapirrangu, marni jinajarrangu mangunykapalirrangu. Palaja Jacob-ju manajaninyi kamalarrangu kanganyaku mirtawanyjarrikupa partanykarranguku. Ngakarnajaninyi palinymili kuwiyirrangu walangkarr, kukurnjaripa nanikuturrangupa purlikapa tangki. Jacob-ju palinymili mirtawanyjarrilupa partanykarrangulu yakarnayi pala ngurra Laban-mili kukujarri-kukujarrilu. Palajunju palinyju mitu marna palinymili kakaji. Yana wirntijartiny warrarnkarti Canaan-karti. ");
INSERT INTO nna_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Kurtany pirni pijunga wirtunga, ngapinga, Euphrates-nga. Yana pipurru warnkumarramarrakarti, ngapinga, Gilead-ja. ");
INSERT INTO nna_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kujarrapa warajaja karrpuja, Laban-ju pinakarrinyi Jacob purlpi yana. ");
INSERT INTO nna_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban-ju manajaninyi pirirrimarta, palaja yajarnayi Jacob. 7 karrpurrangu yajarnayi paliny warnkumarramarrakarti warrarnkarti, ngapinga, Gilead-ja. ");
INSERT INTO nna_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Partijirringa Ngarrkalu muwarr pinalu kapukarringa Laban-ja, “Kuliwayi purulu yankulumanpalu Jacob-ku.” ");
INSERT INTO nna_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob-jupa palinymilirrangulupa partanykarrangulupa mirtawanyjarrilu purlpi ngurra jirniyi warnkumarramarranga. Palaja Laban-pa palinymili pirirrimarta kajarnayi Jacob-martaji, ngurra jirniyi palamartaji. ");
INSERT INTO nna_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban-ju warnta marna Jacob. “Nyuntulu mitu marnanyi. Kanyajin ngajumili kurntaljirri, yijangarra jinmurntujirrikapan. Nganija palajun jirnin? ");
INSERT INTO nna_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nganija yanan kukujarri-kukujarrilu? Yananyamarninyju wurrarnamajin. Mayikurra nganamanyi, julurrpa kuntarnamanyi, pikaly wanimanyi. Pikalymarninyju ngakarnamarnanta. ");
INSERT INTO nna_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yampu marnamarnajaninyi ngajumilijirri kurntaljirripa jamujirrangu. Nganija ngampa pirninyin nyuntulu, muwarrmajirrilu kanyanjaninyi? Yijalu mituwalju palajun jirnin. ");
INSERT INTO nna_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Palajunkatanga nyuntungu ngajulu kurlu jilamarnangu yijarla. Munu. Nyuntumilalu japartulu pinakarrinyikinyalu Ngarrkakungarra. Nyarralu Ngarrkalungarra muwarr pirniji ngajunga warrukartinga, wurrarnaji, 'Kuliwayi purulu yankulumanpalu Jacob-ku.' Muwarrjalu palajunjalu puru yakarnarnanta. ");
INSERT INTO nna_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nyuntulu karrinyanpa yirrinaku nyuntumilaku japartuku. Jipi ngalypa. Nganijalu ngajumili ngulyulu marnajinpa mangunykapalirrangu? Pala kurlujartiny yiji! ");
INSERT INTO nna_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob-ju puntaju karra marnalu, “Ngajulu kurlkali marnikinyirninti kangamanpulinyi nyungujirri ngajuja. Wirnti karrinyikinyirni. Palajunjalu yanarna kukujarri-kukujarri. ");
INSERT INTO nna_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Munu ngajulu kangamarnanga nyuntumilirrangu mangunykapalirrangu. Nganurtulupa ngajumilirrangujalu kanyajaninyi palarrangu, pala marrngu wirlanaku marlkarri. Parrjalajaninyi palamarrangu ngajumili wurrukarra. Nganipa yirrilaman nyuntumili, jurtu jilaman nganarnaku nyuntumilingapa pirirrimarta ngajumilinga. Palaja kalkulumanparninga.” Munumpa waninyikinyi Jacob, Rachel-ju yakanamarninyju Canaan-kartiku kukujarrilu kanyalu palinymili japartumili mangunykapalirrangu marni jinajarrangu. Palajalu Jacob palajun muwarr pirni. ");
INSERT INTO nna_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Palajalu Laban ngalpanyalu Jacob-milinga kalikunga. Kanyjirnikinyi palaku mangunykapalirranguku. Munu yirrirnimajaninyi palarrangu palanga. Palaja kanyjirnikinyi Leah-milinga kalikunga, palanga pukun munu yirrirnimajaninyi. Palajalu ngalpanyapulaku kalikunga palamilijirri warrkamu puluku mirtawamilijirriku. Munu, palanga pukun partarl kanyjirnikinyijanaku. Palaja yanalu Rachel-milikarti kalikukarti. ");
INSERT INTO nna_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel-ju purlpi kuku jirnijaninyi palarrangu mangunykapalirrangu, kamalmilingi saddle-ja wirrirnijaninyi. Palaja kajarna palanga saddle-ja. Palinymili japartulu warlirn-warlirnikinyi Rachel-milinga wurrukarranga, munuyiji, munu yirrirnimajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Karra marnalu Rachel-ju palinymili japartuku, “Ngaju munu wararr karrinyikirni, nganarnamilinga mirtawamilinga. Munu jaaly jarrinyaku ngajukupa, nyungukurrapa kajarnarni nyungungu.” Palajunjalu Laban-ju puru kanyjirn-kanyjirnikinyijanaku palinymilirranguku mangunykapalirranguku. ");
INSERT INTO nna_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Palaja palanga Jacob kuli jarrinyi Laban-ku, warnta marna palinymili kakajimurniny. “Munu nganipa ngajulu kurlu jinamarnanga. Nganijalu nyuntulu yirtil marnanyin palajunju? Ngani yija-yiji kurlu jirnirnangu? ");
INSERT INTO nna_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Jipirla wurrukarrarrangu yatirnajinpa. Nganipa wurru yirrirninjaninyi nyuntumili? Yijapa yirrirninjaninyi, wirrilajaninyi nyungungu, yirrilipiyijaninyi nyungurrangulu pirirrimartalu nyuntumilalupa ngajumilalu. Janalu wurralapiyijaninyi nganurtumilipa palarrangu. ");
INSERT INTO nna_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Jipirla ngaju waninyirnangu 20 partunurrangu. Ngajulu tuku jirnikinyirnijaninyi nyuntumili kuwiyirrangu. Palanga nyuntumili kukurnjaripa nanikutu tuku wanikinyiyi. Janalu marlu partanykarrangu kanyayijaninyi. Munu ngajulu nganamarnajaninyi yuramurrangu nyuntumili. ");
INSERT INTO nna_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Jampa kulikatarrangulu yukurrulu pajirnikinyiyijaninyi marlkarri nyuntumili nanikutupa kukurnjari, munu ngajulu kangamarnajaninyi marlkarrirrangu palarrangu jurtu jinaku nyuntungu. Munu. Ngajulu wirrirnirnijaninyi ngajumilirrangu kukurnjaripa nanikutu puntaju palarranguku marlkarrirranguku nyuntumilirranguku. Jampa jintalu marrngurrangulu kukujarri-kukujarrilu ngulyulu mananyikinyiyijaninyi nyuntumilirrangu janyjangapa warrukartinga, ngaju japirr marnikinyinyin palamarranguku wirrinaku. ");
INSERT INTO nna_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Karrpurrangu karrpurrangu ngaju warrkamu jarrinyarnangu parrpakarranga, marlu warrukartinga ngaju wanikinyirni yija warringa. Marlumal ngaju wanikinyirni kartamajirri tuku jirnikinyirnijaninyi nyuntumilirrangu kuwiyirrangu. ");
INSERT INTO nna_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ngaju waninyarnangu 20 partunurrangu. Warrkamu jarrinyarnangu 14 partunurrangu palakujirri mirtawakujirri, nyuntumili kurntaljirri. Palaja ngaju warrkamu jarrinyarna nyuntungu 6 partunurrangu mananyaku kuwiyirranguku ngajuku. Palanga 20 partunurrangungu nyuntulu mitu marnanyin marlumal. ");
INSERT INTO nna_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kartu ngakarnaminyin nyuntulu ngani warralpirtimajirri. Ngarrkalu ngaju tuku jirnikinyinyi. Miranungarra paliny ngajuku, ngaju warrkamu jarrinyarnangu ngalypa nyuntunga, paliny miranungarra nyuntuku, ngurnjul jirnijin. Palajalu warnta marnanta warrukartinga kapukarrilu.” Palajun muwarr pinalu Jacob. ");
INSERT INTO nna_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Palaja Laban-ju puntaju karra marnalu, “Nyungujirri partanyjirri ngajumilijirri, pulanymili palarrangu partanykarrangurrangu ngajumili jamujirrangu. Palarrangu kuwiyirrangu kalkurnanjaninyi nganin-nganinpa palarrangu ngajumilirrangu pukun. Nyuntulu parrjala! Nyungurrangu ngajumilirrangujakun. Yijapa ngajulu kalkulumarnapulinyi ngajumili kurntaljirripa pulanymili partanykarrangu. Munu, puru ngakalamarnajaninyi nyuntungu. ");
INSERT INTO nna_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yuu. Ngali muwarr pilipalirnangu. Wirlanawayi puru wantulupali, wirlanamajirri. Wuru jilipali nyungurrangu warnkurrangu, kurlka jinaku ngaliku.” Palajun Laban-ju karra marnalu. ");
INSERT INTO nna_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Palajalu Jacob-ju warnku wirtu mana, wararr jirni. ");
INSERT INTO nna_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Palaja wurrarnajanaku palinymili pirirrimartanga, “Nyurralupa marrayijaninyi warnkurrangu.” Yijalu manayijaninyi, kunmu jirniyijaninyi warnkunga wirtunga wangka. Palaja wiyirrju nganayi mayi warnkurrangunga wangka. ");
INSERT INTO nna_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Laban-ju karra marnalu Jacob-ku, “Nyungulu kurulu kurlka jilkulinyngalinyi yartipa.” Palinyju yini marna palinymilinga muwarrja, “Kuru kurlka jinapinti.” Jacob-ju pukun yini marna pala warnku warinyja palinymilinga muwarrja, “Kuru kurlka jinapinti.” ");
INSERT INTO nna_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","53","Laban-ju karra marnalu Jacob-ku, “Jinta pinajalu, yankuluman nyuntumili warrarnkarti, ngaju yankulumarna ngajumilikarti. Ngarrkalu parrjalkulinyngalinyi. Kawanjaninyili nyuntulu warinyarrangu mirtawarrangu, yakalanpulinyili nyungujirri kurntaljirri, wirlalanpulinyili ngunarringi. Munumpa wantarnili ngaju. Pinakarraji. Ngarrkalu parrjarnanti. Yirrirnin nyungu warnku wirtu ngajulu wararr jirnirni, nyungupa kuru marnarna. Palarrangu warnkurrangu wantulupiyi kurlka jinaku ngaliku, muwarrpa nyungunga wirrirnali. Ngaju munu yankulumarna nyungungu kurungu ngunarrikarti nyuntukarti kulikarti. Nyuntu pukun munu milpuluman ngajukarti kulikarti nyungungamarra kurungamarra. Warajalupa ngalijalu panypalali nyungungu muwarrja, Ngarrka miranu jarruliny palinyku. Ngalimilalu karlujilujirri, Abraham-jupa Nahor-lu, pinakarrinyikinyipululu Ngarrkanga. Yijapa ngajulu muwarrja palanga panypiyirnili. Palaja yiji palalungarra Ngarrkalu wirlalaminyi ngaju. Yijapa nyuntulu muwarrja palanga panypiyinpili. Palaja yiji palalungarra Ngarrkalu wirlalamanta nyuntu.” Palajun Laban-ju muwarr pinalu Jacob-ku. Palajalu yini marnapulu pala kuru “Mizpah” pukun. Pala wurrarna “Ngarrkalu Yirrkulu Parrjarnangalinyi”. Jacob-ju pinakarrinyalu Laban-mili muwarrku. Palaja karra marnalu, “Ngarrkakungarra ngajumili japartalu Isaac-ju pinakarrinyikinyalu. Nyarra Ngarrka paliny miranu ngajuku. Yijalu pala muwarr kalkurnarninga.” ");
INSERT INTO nna_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Palaja Jacob-ju mana waraja kuwiyi palinymilirranguja, wirlarna, kamparnalu yinganyaku Ngarrkaku. Japirr marnajaninyi pirirrimarta palinymilipa Laban-mili, ngananyaku mayiku palinyja. Ngananyajalu karta karrinyiyi warrukartinga palanga warnkumartaji. ");
INSERT INTO nna_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kurnpungu Laban turlpanya kartaja. Palinyju yampu marnajaninyi palinymili jamujirrangupa kujarra kurntaljirri. Palaja kulpanya palinymili warrarnkarti. ");
INSERT INTO nna_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Palanga Jacob yakarna yananyaku palinymilaku japartumilaku warrarnku. Jampa yananyikinyi jinta Ngarrkamili angel-arrangu purrpi turlpanyiyalu paliny. ");
INSERT INTO nna_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jampa Jacob-ju parrjarnajaninyi palinyju karra marnarningu, “Nyungu ngurra Ngarrkamili!” Pala warrarn palinyju yini marna “Mahanaim”. Pala wurrarna “Kujarra Ngurra Kurrngaljirri”. ");
INSERT INTO nna_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Palaja Jacob-ju ngakarnajaninyi jinta pirirrimarta walangkarr palinymili mamajimurninykarti, Esau-karti, palanga warrarnja waninyikinyi, Edom-ja. ");
INSERT INTO nna_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Palinyju wurrarnajanaku, “Nyungu muwarr kawayi palinykarti, wurralayalu Esau-nga, ngajumili nyampalingi, nyungu muwarr: 'Nyuntumili warrkamu pulukalu, Jacob-ju, palinyju ngakarnanganinyi nyuntukarti. Paliny punja waninyikinyi Laban-ja. ");
INSERT INTO nna_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kuwarringa palinyju kalkurnujaninyi purlikapa tangkipa kukurnjaripa nanikutupa warrkamu puluka mirtawapa pirirri. Palinyju ngakarnanga nyungu muwarr nyuntuku. Yijapa ngarlu ngalypa jarrulumanpili. Yijapa nyuntulu ngalypalu jilimanpalu nganipa.' Palajun muwarr pilkulunyurrulu Esau-nga.” Palinyja muwarrja palarrangu pirirrmarta yanayi purrpi manaku Esau. ");
INSERT INTO nna_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Yarti kulpanyajalu wurrarniyalu Jacob-ja, “Nganarna yanayirnalu nyuntumili mamajikarti, wurrarniyirnalu nyuntumili muwarr. Paliny milpanya purrpi malamanta nyuntu. Paliny 400 pirirrimartajartiny.” ");
INSERT INTO nna_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Pinakarrinyaja pala muwarr Jacob yija-yiji wirnti jarrinyi. Palaja palinyju jinta marnajaninyi palinymili marrngurrangu kujarra kurrngaljirri. Palajunjalu palinyju jinta pirnijaninyi kuwiyirrangu pukun. ");
INSERT INTO nna_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Karra marnarningu, “Yijapa Esau milpuliny warajakarti, wirlalajaninyili. Palanga warinyarrangu mirti jarrulupiyi wankaku.” ");
INSERT INTO nna_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Palaja paliny muwarr pinalu Ngarrkaku, “Nyuntu yija Ngarrka, nyuntulungarra tuku jirnikinyinpulinyi ngajumili karluji Abraham-pa ngajumili japartu Isaac. Nyuntulu karra marnajin ngajuku, 'Kulpa nyuntumili warrarn waljakarti, marrngu waljakarti. Ngajulu tuku jilamarnangu, tuku kalkulumarnanta.' Palajun karra marnajin. ");
INSERT INTO nna_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yija nyuntulu nganipa ngalypa jirnikinyijin. Ngaju puru, mujujakun. Jampa purlpilu ngajulu yakarnarna ngajumili warrarn, ngaju ngunarrija kurtany pirnirni nyungunga pijunga, nyungunga Jordan-ja pijunga, puru yananyikinyirni, mungkajartinyjakun. Ngaju kuwarringa kulpanyarna marlu kuwiyirrangujartinypa marrngurrangu. ");
INSERT INTO nna_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","12","Ngaju wirnti karrinyarna ngajumili mamajiku, Esau-ku. Wirlalanganinyili wiyirr, partanypa pipimurninyarrangu. Nyuntulu wurrarnajin, 'Ngajulu tuku jilamarnanta, ngajulu yungkulumarnanta marlu partanykarrangupa janamilirrangu nyirrirnikartijarrangu.' Palajun karra marnajin. Ngarrkakayi, kuwarringa tuku jilinganinyi. Kunta jili Esau, wirlalanganinyili marlkarri wiyirr.” Palajun karra marnalu Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Palanga Jacob karta karrinyi waraja warrukartinga. Palaja manajaninyi jinta wariny kuwiyirrangu yinganyaku mamajimurninyku. ");
INSERT INTO nna_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","Palinyju manajaninyi nanikuturrangu 200 mirtawanyjarripa 20 pirirrimarta, kukurnjarirrangu 200 mirtawanyjarripa 20 pirirrimarta, kamalarrangu 30 mirtawanyjarripa partanykarrangu janamili, purlika 40 mirtawanyjarripa 10 pirirrimarta, tangki 20 mirtawanyjarripa 10 pirirrimarta. Palarrangu wiyirr jinta pirnijaninyi yinganyaku mamajimurninyja. ");
INSERT INTO nna_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Palinyju wurrarnajanaku palinymili warrkamukatanga pirirrimartanga, “Kangkulinyurrujaninyi nyungurrangu kuwiyirrangu Esau-karti. Yankulunyurru nyirrirnipa walangkarr, kajamarta kajamarta yankulunyurru.” ");
INSERT INTO nna_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Walangkarr pirirringa wurrarnalu, “Jampa ngajumili mamajilu purrpi malamanta japirr malamanta, 'Nganurtu nyuntmili maaja? Wanyjarni yananyan? Nganurtumili palarrangu kuwiyirrangu tuku jinanpalu?' ");
INSERT INTO nna_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Nyuntulu karra malamanpalu puntaju, 'Nyungurrangu kuwiyirrangu Jacob-mili, nyuntumili warrkamu puluka. Palinyju ngakarnajaninyi palinymili nyampaliku, Esau-ku. Nyirrirni milpanya kuwarringa.” Palajun wurrarnalu palaku pirirriku. ");
INSERT INTO nna_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jintanga wurrarnajanaku, “Nyurralu pukun palajun wurralkulunyurru, jampa purrpi malkulunyurrinyi Esau-lu. ");
INSERT INTO nna_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Wurralkulunyurrulu, 'Nyuntumili warrkamu puluka Jacob nyirrirni milpanya nganarnanga.'” Jacob-ju karra marnikinyirningu, “Nyungurrangulu kuwiyirrangulu yijapa ngarlu ngalypa jilkuliny Esau ngajuku. Yartipa yirrilimarnalu, yijapa ngarlu paliny ngalypa jarrulupiji.” ");
INSERT INTO nna_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jampa yanayi palinymili pirirrimarta kuwiyirrangujartiny, Jacob palanga waninyi. ");
INSERT INTO nna_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Warrukartingi palinyju kanyajaninyi palinymili wurrukarrapa mirtawarrangupa partanykarrangu, kurtany pirniyi pijunga, ngapinga, Jabbok-ja, jinangu yanayi ngapanga palanga pijunga ngunarrikarti. Wiyirr yakarnajaninyi ngunarrikarti. Palaja palinyjakun kulpanya. ");
INSERT INTO nna_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Paliny kujurl waninyi palanga. Pirirri ngajarri turlpanyalu. Palanga partarl jungkanga parirrju warlirnikinyipularninyi, palajun partarl jirnikinyipularninyi pirrpa-pirrpakartijakun. ");
INSERT INTO nna_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Palama pirirrilu ngajarrilu partarl warlirni Jacob. Palajunjalu palalu pirirrilu wirlarna Jacob mila nyuku, ");
INSERT INTO nna_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Palaja karra marnalu Jacob-ku, “Pirrpa-pirrpa jarrinyi. Warlinawayi! Yakalanyi!” Jacob-ju karra marnalu, “Nyuntulu wurralapijin ngajuku nganipa ngalypa jilipijin. Palajunwayijalu kakuputulu warlilamarnanta.” ");
INSERT INTO nna_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Palalu ngajarrilu japirr marna, “Nganurtukurra nyuntu yini?” “Ngaju yini Jacob.” ");
INSERT INTO nna_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Palalu ngajarrilu karra marnalu, “Kuwarrijalu munu yini malapiyirninti Jacob. Nyuntumili yini wantuliny Israel. Nyuntu jalypa jirnijaninyi Ngarrkapa marrngurrangu, yakarniyinti, yirrku wararr karrinyin nyuntu. ?? You have struggled with God and with men, and have prevailed over them. ");
INSERT INTO nna_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Palaja Jacob-ju karra marnalu, “Nganurtu yini nyuntu?” Palinyju karra marnalu, “Japirrwayi, munu palajun muwarr japirr malamanyin. Kuwarringa ngajulu ngalypa jilamarnangu.” Palajun karra marnalu Jacob-ku. Palanga palinyju yakarna Jacob palanga, yana ngunarri. ");
INSERT INTO nna_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob-ju karra marnarningu, “Ngajulu parrjarnarna ngumpa Ngarrkamili. Payi! Palinyju munu wirlarnaminyi marlkarri!” Palajunjalu Jacob-ju yini marna pala ngurra “Penuel”. Palalu yinilu wurrarna, “Ngarrkamili Ngumpa.” ");
INSERT INTO nna_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Palaja palanga jampa ngarrany karrpu milyapal jarrinyi. Jacob-ju yakarna pala warrarn, paliny yananyikinyi jarntarni-jarntarni OR yikiti-yikitikarra? mila wirlanaja. ");
INSERT INTO nna_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Palajunjalu kuwiyi wirlanajalu Israel-milirrangulu munu nganamayi majangu milaja. Janalu kurlkali marnayi purlpilu Ngarrkalu wirlarna Jacob mila nyuku. ");
INSERT INTO nna_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Palaja palalu Jacob-ju parrjarna, Esau milpanyikinyi palinykarti 400 pirirrimartajartiny. Wirrirnijaninyi partanykarrangu janamilinga pipimurninyja. ");
INSERT INTO nna_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Wirrirnipulinyi warrkamu puluku mirtawajirri partanypa walangkarr. Pulanymartaji wirrirni Leah-pa partanykarrangu, nyirrirni wirrirni Rachel-pa palinymili partany, Juwujapu. ");
INSERT INTO nna_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Paliny yana walangkarr purrpi marna palinymili mamaji. Jampa yaninyikinyi Esau-karti jurnturtu kaniny jarrinyikinyi 7-mal. ");
INSERT INTO nna_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Palaja Esau puntaju mirti jarrinyalu, palanga pulany yampu marnapularninyi. Ngangkurlji pirnipularninyi, yirrirnipularninyi pikalymarninyju. ");
INSERT INTO nna_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Palaja Esau-lu parrjarn-parrjarnikinyi, yijalu yirrirnijaninyi mirtawanyjarripa partanykarrangu. “Nganurturrangu nyungu kanganyinjaninyi?” “Palamarrangu partanykarrangu yinyanyi Ngarrkalu.” ");
INSERT INTO nna_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Palaja warrkamu puluku mirtawajirripa partanykarrangu milpanyiyi wangka, jana jurnturtu kaniny jarrinyiyi walangkarr Esau-nga. ");
INSERT INTO nna_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Palaja Leah-pa palinymili partanykarrangu milpanyiyi wangka, jana pukun jurnturtu kaniny jarrinyiyi walangkarr Esau-nga. Palaja Rachel-pa palinymili partany, Joseph, pulany pukun jurnturtu kaniny jarrinyipulu walangkarr Esau-nga. ");
INSERT INTO nna_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Palaja Esau-lu japirr marna, “Ngurnungurrangu kuwiyirrangu yirrirnirnijaninyi, nganija ngakarnanjaninyi?” Jacob-ju karra marnalu, “Palamarrangu nyuntuku. Yinganyijalu yijapa ngalypa jarrulupijin.” ");
INSERT INTO nna_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","“Munu, jipi kalkurnurnajaninyi ngajumili. Kalkularninga pala nyuntuku.” ");
INSERT INTO nna_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob-ju karra marnalu, “Yija nyuntu ngalypa waninyikinyijin, munu kuliwayi waninyijin ngajuku. Palajunjalu nyuntulu kangkulumanparninga palarrangu kuwiyirrangu. ");
INSERT INTO nna_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngarrkalu ngalypa jirnikinyiji ngajuku, palinyju yinyaji marlu nganipa. Kawajaninyi palarrangu kuwiyirrangu nyuntuku.” Palajun karra marnalu Jacob-ju. Puntaju Esau-lu karra marnalu, “Yijangarra kangkulumarnajaninyi.” ");
INSERT INTO nna_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Palaja Esau-lu karra marnalu, “Ngali yankuli warajanga, ngaju walangkarr yankulumarna.” ");
INSERT INTO nna_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob-ju karra marnalu, “Ngajumili partanykarrangu manyurlajakun, munu yananyaku nyampakupa. Ngajumili kuwiyirrangu, kukurnjaripa nanikutupa purlika, wupartupanimarninyarrangujartiny tuku jilamarnajaninyi. Kaja yananyijalu karrpunga warajanga marlkarri jarrayili. ");
INSERT INTO nna_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Walangkarr pilijilu ngajuku. Kinti milpulumarna nyirrirni, nyungurrangujartiny. Yartipa turlpalamarnanga nyirrirni nyuntumilikarti ngurrakarti Edom-ja.” ");
INSERT INTO nna_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau-lu karra marnalu, “Yuu, yakalamarnajaninyi nyungurrangu pirirrimarta nyuntungu, milpulkulinyurru nyirrirni.” Puntajulu, “Puru kawajaninyi nyuntumili pirirrimarta. Munu ngaju karrinyarnangu yirrnganaku nyuntuku. Ngalyparla wantulumarna.” Palajun muwarr pinalu Esau-ku. ");
INSERT INTO nna_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Palaja Esau-lu yakarna palinymili marrka, kurila kulpinyi palinymili warrarnkarti, Edom-karti. ");
INSERT INTO nna_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob munu pipurru yanama Edom-karti. Paliny partijirri wararr karrinyi, ngapinga, Succoth-ja. Palanga maya jirni palinyku, kuwiyirranguku jirni pamarrarrangu. Palajalu yini marnayi pala ngurra “Succoth”. Palalu yinilu wurrarna, “Pamarrarrangu”. ");
INSERT INTO nna_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Palaja Jacob-jupa palinymilirrangulu yakarnayi pala Succoth, yanayi kara. Turlpanyayi tawunja, Shechem-ja, warrarnja ngapinga, Canaan-ja. Palinyju ngurra jirni palamartaji tawunmartaji. ");
INSERT INTO nna_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Purlpi pala warrarn palinyju ngurra jirnipa waninyikinyi Hamor-mili, Shechem-mili japartumili. Jacob-ju yinyajaninyi Hamor-milirrangu warnku wirtu palaku warrarnku. ");
INSERT INTO nna_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Palanga palinyju warnku kunmu marnajaninyi. Yini marna pala kunmu warnku El-Eloi-Israel. Palalu yinilu wurrarna, “Ngarrka, pala Israel-mili Ngarrka”. ");
INSERT INTO nna_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Palanga Dinah, kurntal Jacob-milipa Leah-mili, ngurraja jalakarti yanajanaku puru muwarr pinaku ngurrararranguku mirtawanyjarriku. ");
INSERT INTO nna_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Warajalu ngurraralu pirirrilu yirrirni, yini Shechem. Hivite-milirrangungu paliny. Palinymili japartu, yini Hamor, wirtu nyampali waninyikinyi palanga warrarnja paliny. Pala nyarra Shechem-ulu mana kanya pala kurri kurntanymajirrilu, kanya palinymilikarti ngurrakarti, yirrku pirirrimarninyju kurlarnapularninyi, pala mirtawa palaku panyju, partarl yalaji pirnarninyi. ?? ");
INSERT INTO nna_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Wurrarnarningu, “Pala kurri ngalypa yija yiji.” Marru marna yiji pala kurri, ngarlunga palinyja wirrirnarningu, karrinyikinya Dinah-lu puntajulu marru manaku, ngarlungu paliny wirrinaku. ");
INSERT INTO nna_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Wurrarnala japartungu palinymilingi, “Malkulupijin pala Dinah, mirtawa ngajumili jarrinyaku.” ");
INSERT INTO nna_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob-ju pinakarrinyi Shechem-ulu kurlu jini palinymilingi kurntalja. ?? Palinymilirrangu partanykarrangu ngurnarrijalu kuwiyirrangu kalkurnikinyiyi. Paliny jama waninyikinyi, mimarnajanaku kulpanyaku. ");
INSERT INTO nna_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Partanykarranguku kulpanyaku mimanajalu, milpanyalu Hamor, Shechem-umili japartu, muwarr pinaku Jacob-ungu. Jacob-milirrangulu partanykarrangulu pinakarrinyiyi ngurnarrija kulpanyajalu. Wirrilya yiji jarrinyiyalu Shechem-uku. Wurrarniyiyarningu, “Nyarralu Shechem-ulu kurlujartiny jini nganyjurrakupa nganyjurrumilaku japartumilirranguku. Kurlu yiji jini Dinah-ku. Munu yiji palajunkapali jinaku kurntanyja yiji marrnguku.” ");
INSERT INTO nna_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor-lu wurrarnala Jacob-ja, “Partanyju ngajumilalu ngarlungu wirrirni kurntal nyuntumili. Nyuntulu yungkulumanpa mirtawaku palinymili jarruliny. ");
INSERT INTO nna_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nganarnaja mirtawanyjarri mankulunyurrujaninyi, puntaju palajun pukun nganarna yungkulunyurrunganinyi mirtawa nyurramilija. ");
INSERT INTO nna_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Palaja nganarnanga wantulunyurrunganaku wiyirr nyungungu warrarnja, maninyakanu parljulkulunyurrarninga ngurra nyarralanga warrarnja, wurrukarrapa warnkujartinyju mankulunyurru, ngurra walja mankulunyurrarninga pukun.” ");
INSERT INTO nna_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Palaja Shechem-ulu japirrmarnajaninyi, wurrarnajanaku Dinah-milingi japartungupa mamajimurninyarranguku, “Ngalypakurra jilkulupijinyurru. Yungkuluminyinyurru Dinah ngajumiliku mirtawaku jarrinyaku. Palajun jinajalu nganiwarralpirtiku japirr malkuluminyinyurru, palangarra yungkulumarnanyurrinyi ngajulu, ngurnipali kurrngalku yijaku wurrukarraku karrinyanyurru, ngurnipali wirtuku yijaku warnkuku karrinyanyurru, Dinah puntaju yungkuluminyinyurru.” ");
INSERT INTO nna_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jacob-milirrangulu partanykarrangulu kuli ngarrany waninyikinyiyalu Shechem-uku, palinyju kurlujartiny jini Dinah-ku, kurntany yiji jinili ??. Palajunjalu mitulu muwarr piniyipulaku Shechem-ukupa japartuku palinymilaku. ");
INSERT INTO nna_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wurrarnayipulaku, “Munu yiji palajun jinakayirni nganarnalu, Shechem palama partany ngarrany, munu pirirri jarrima. Kurntanyja yiji nganarnaku marrka yinganyaku pirirringa ngapi nyarra partanyja ngarrany. ");
INSERT INTO nna_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","16","Yakujun jilkulunyurru: Nyurra wiyirr pirirrimarta jilayarningu nyurralu. Palajunjalu nganarnamili kurrirrangu yungkulupiyirninyurrinyipa nyurramili kurrirrangu kangkulupiyirnijaninyi nganarnaku. Nganarnalu ngurra jilkulupiyirninyurraku nyurranga, nganyjurru wiyirr wantuluminyi nyarralanga. ");
INSERT INTO nna_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Yijapa nyurra munu pirirrimarta jarrulunyurru, palaja Dinah kangkulupiyirni, yankulupiyirni warrarn warinykarti ngarramarnti.” ");
INSERT INTO nna_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor-lupa Shechem-ju, partanyju palinymilalu, wurrarnapulujanaku, “Yuu, pala ngalypa.” ");
INSERT INTO nna_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shechem-ulu pipurrulungarra palinymilija muwarrja jirni. Yijalu yiji karrinyikinyalu Dinah-ku! Shechem-mili marrngurrangulu yijalu yiji kurlkarri manikinyiyi Shechem nyampalimili pujamumurniny paliny. ");
INSERT INTO nna_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Palinypa japartumurniny tawunkarti gate-karti yanapulujanaku muwarrkarti. Palangangarra mirtanya-mirtanya kajarnikinyiyi, wirtu muwarr kurrngarnakinyiyi. Shechem-ulu nyarra muwarr kanyajanaku. ");
INSERT INTO nna_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Nyungurrangu pirirrimarta jana nganyjurruku jarnturrangu,” wurrarnajanaku. “Japirr malkunyijaninyi wantulupiyi nganyjurruku jana and trade with us ??. Parrjalayi! Nyungu warrarn wirtu nganyjurruku wiyirrku. Kangkuluminyijaninyi kurrirrangu mirtawarrangukupa janamili pirirrimarta warajanga jarrulupiyi kurrirrangungu nganyjurrumilingi. ");
INSERT INTO nna_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nganyjurrumili marrngurrangu pirirrimarta jarrrinyajalu, janakapalingarra, jana wantulupiyi nganyjurruku nganyjurrungu, wakany marrngurrangu wantuluminyi wiyirr. ");
INSERT INTO nna_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Palajun jinajalu, janapa janamili kuwiyirrangupa wurrukarra nganyjurrumili jarrulupiyinganyjurruku! Pinakarruluminyi janaku muwarr janamili, nyungu nganyjurrunga ngatu jarrulupiyi nganyjurruku.” ");
INSERT INTO nna_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Palaja pirirrimarta jinayarningu wiyirrju palanga tawunja. ");
INSERT INTO nna_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kujarrapa waraja karrpurranguja, Shechem-milirrangu parra-parra wirtu jarrinyaja, kujarra Jacob-mili partanyjirri, Simeon-pa Levi, Dinah-mili mamajimurninyjirri, tawunja ngalpanyapulu. Munu ngampa pinayipulinyi. Sword kanyapulu, marlkarri wirlarnapulujaninyi pirirrimarta wiyirr, ");
INSERT INTO nna_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor-pa Shechem pukun. Sword-ju marlkarri wirlarnapulupulinyi, palaja mayaja Shechem-milija kanyapulu Dinah, kulpanyapulu ngurra pulanymilikarti. ");
INSERT INTO nna_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Palajun jinaja, jinta pirirrimarta Jacob-mili turlpanya, yirrinajalu marrngu wiyirr marlkarri, kanyayi wurrkarra wiyirr tawunja. (They did that because their sister had been defiled there.) ");
INSERT INTO nna_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kanyayi kuwiyirrangu — kamalpa purlikapa kukurnjaripa tangki — wiyirr kanyayi tawunjapa janamili warrarnja. ");
INSERT INTO nna_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Mayarranguja kanyayi wurrukarrapa warnkurrangupa nganirn-nganirn. Kanyayi partanykarrangupa mirtawanyjarri pukun, jakurlirniyijaninya jana warrkamukata jarrinyaku janaku. ");
INSERT INTO nna_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yarti Simeon-japa Levi-nga wurrarnapulaku Jacob-ju, “Ngajuku yija kurlujartiny jinanyumpulu! Marrngurrangu nyarralanga warrarnja — wiyirr Canaan-milirrangupa Perizz-milirrangu — kurlkapirli jarrulupijiyi, wurralapiyiya, “Puka pala Jacob!” Nganyjurru kujarrapa warajakapali, jana kurrngal yiji! Kunmu jarrulupiyi, marlkarri wirlalkulupiyinganyjurrinyi wiyirr! Munu jarrulumarna ngaju, ngajumili marrngurrangu wakany munu jarruliny! ");
INSERT INTO nna_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","“Wayirti! Shechem-ju marrka ngalayimili kurlukatakapali jirni??. Ngani jinaku ngalayi? Munujakun jinaku?” ");
INSERT INTO nna_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Palaja Ngarrkalu karra marnalu Jacob-ku, “Yakala nyungu warrarn, yarra Bethel-karti, palanga wantuluman. Palangangarra ngaju miral jarrinyirnangu purlpi, nyuntu wirnti mirti jarrinyikinyin nyuntumili mamajingamarra, Esau-ngamarra. Jampa turlpalaman Bethel-ja warnku kuru malaman, wuru jilaman, palanga nyuntu muwarr pilipijin ngajuku.” Palajun muwarr pinalu Jacob-ku. ");
INSERT INTO nna_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Palaja Jacob-ju muwarr pirnijanaku palinymili mirtawanyjarrikupa palinymili warrkamukatarrangu. Karra marnajanaku, “Yakaliyijaninyi nyurramili ngapirrangu, palarrangu mangunykapalirrangu, warrarnja warinyja. Palaja janpulinyurru, wurru wariny ngalpulunyurru. ");
INSERT INTO nna_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Palaja yakalaminyi nyungu ngurra, yankuluminyi Bethel-karti. Purlpi purlpi ngaju wirnti mirti jarrinyirni Esau-ngamarra. Palangangarra ngajulu kamarnalu Ngarrkaku, palinyju pinakarrinyiji. Palinyjungarra tuku jirnikinyinyi ngaju wanyjarnipa yananyikinyirni. Bethel-jangarra ngajulu kuru malamarnajaninyi warnkurrangu, muwarr pilamarnalu Ngarrkaku palanga.” ");
INSERT INTO nna_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Jacob-milija muwarrja janalu yinyiyili wiyirr janamili mangunykapalirrangu, kurlkapinti ringirrangu pukun yinyiyili. Pirti karlinyi mungkamartaji palinyju, palanga pirtinga yamarnajaninyi. ");
INSERT INTO nna_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Palajalu Jacob-pa palinymilirrangu yaninyikinyiyi Bethel-karti. Ngarrkalu wirntiku jirnijaninyi marrngurrangu ngurrararrangu, munu purrja pinamayi Jacob-arrangumili. ");
INSERT INTO nna_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob-milirrangu kajarniyi Luz-ja, warrarnja ngapinga, Canaan-ja. Palaku Luz-ku wariny yini Bethel. ");
INSERT INTO nna_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Palanga Jacob-ju kuru marna warnkurrangu, muwarr pinalu Ngarrkaku. Purlpi jampa Jacob mirti jarrinyikinyi palinymili mamajingamarra palangangarra yarrana Ngarrka turlpanyalu. Palajangarra Jacob-ju yini marna pala warrarn El-Bethel. Palalu yinilu wurrarna, “Ngarrka Bethel-ja waninyi.” ");
INSERT INTO nna_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Now Deborah, Rebekah's nurse, died and was buried under the oak outside Bethel. Palajalu yini marnayi “Allon Bakuth”. “Oak of weeping” ");
INSERT INTO nna_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jampa Jacob kulpanya palinymili kakajimurninymili warrarnja, yarrana Ngarrka miral jarrinyili Jacob-ja, ngalypa yiji muwarr pinalu. ");
INSERT INTO nna_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Yini wariny yinyalu Jacob, pala yini Israel. Karra marnalu Jacob-ku, “Purlpi nyuntu yini waninyikinyi Jacob. Kuwarringa munu wurralapiyinti 'Jacob' “Deceiver”, yini malapiyinti 'Israel' “Prince with God”. ");
INSERT INTO nna_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ngaju yija Ngarrka, wiyirrku nyurraku nyampali. Ngajulu yungkulumarnanta marlu jamujipa karluji, kurrngal yiji wantulupiyi. Yankulupiyi ngunarrijirri, warrarn warinyarrangukarti. Jinta want ulupiyi wirtu maaja, kingi wantulupiyi. ");
INSERT INTO nna_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Purlpi ngajulu yinyarnalu nyungu warrarn nyuntumili karlujinga, Abraham-ja. Palaja yinyarnalu nyuntumili japartunga, Isaac-ja. Kuwarringa ngajulu yungkulumarnanta nyuntungupa nyuntumili karlujingapa jamujinga, nyirrirnikartijapa yajalapiyi.” Palajun muwarr pinalu Jacob-ku. ");
INSERT INTO nna_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Palaja Ngarrka yakarna paliny. ");
INSERT INTO nna_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Palamangangarra Jacob-ju wararr jirni wirtu warnku, jarnti jirni. Jurtirni wayinpa wuyil warnkunga yinganyaku Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Palanga warrarnja Ngarrkapa miral jarrinyalu palinyju yini marna Bethel. ");
INSERT INTO nna_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Palaja Jacob-milirrangulu yakarniyi Bethel, yaninyikinyiyi ngapikarti, Ephrath-karti. Palinymili mirtawa Rachel ngayinykarra. Kajamarta Ephrath-ja, wupartupani ngayarta jarra-jarrinyikinyi. Rachel yija manyurla, partarl ngayarta jirnikinyi. ");
INSERT INTO nna_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Palinymilalu mirtawaju warrkamukatalu mimarnikinyi partanyku ngayarta jarrinyaku. “Wirntiwayi. Puru wanta, pirirri partany mankuluman.” ");
INSERT INTO nna_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rachel wurrku yiji waninyikinyi, kinti marlkarri jarrinykinyi, marlkarrimarninyju yini marna pala partany Benoni. “Son of my sorrow” Yarti Jacob-ju wariny jirni yini, Benjamin. “Son of my right hand” ");
INSERT INTO nna_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Janalu pirtingi jirniyi Rachel ruwurtumartaji, pala ruwurtu yaninyikinyi Ephrathah-karti. (Kuwarringi pala yini marnayi tawun Bethlehem.) ");
INSERT INTO nna_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob-ju wararr jirni wirtu warnku, jarnti jirni, kankarni jungkanga Rachel-milingi. Pala warnku yirrku waninyi kuwarringipa. ");
INSERT INTO nna_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Palaja Israel-milirrangu pipurru yaninyiyi. Ngurra jirniyi ngunarrikarti ngapinga, Migdal-Eder-nga. ");
INSERT INTO nna_vpl VALUES ("GN35_22a","002_35_22a","GEN","35","22a","22a","Palamartaji waninyaja, Reuben yana Bilhah-karti, Israel-mili yarungu, kalikunga ngalpanya, karta karrinyipulu. Pinakarrinyi palaku Israel-ju. ");
INSERT INTO nna_vpl VALUES ("GN35_22b","002_35_22b","GEN","35","22b","22b","Jacob 12 partany pirirrimartajartiny: ");
INSERT INTO nna_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Partany pirirrimarta Leah-mili: Reuben (Jacob-mili murrkangunya), Simeon, Levi, Judah, Issachar, Zebulun. ");
INSERT INTO nna_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Partany pirirrimarta Rachel-mili: Joseph-pa Benjamin. ");
INSERT INTO nna_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Partany pirirrimarta Bilhah-mili (warrkamukata Rachel-ku): Dan-pa Naphtali. ");
INSERT INTO nna_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Partany pirirrimarta Zilpah-mili (warrkamukata Leah-mili): Gad-pa Asher. Palarrangu partany pirirrimarta Jacob-mili, Paddan-Aram-ja waninyaja ngayarta jarrinyiyi wiyirr. ");
INSERT INTO nna_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Palaja Jacob kulpanya palinymili japartumili ngurrakarti, ngapinga, Mamre-nga, Kiriath-Arba-martaji. (Yini wariny palaku Hebron.) Purlpi purlpija Jacob-mili karlujilupa japartulu ngurra jirnipulu palanga, Abraham-jupa Isaac-ju. ");
INSERT INTO nna_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaac mirtanya yiji jarrinyaja, 180 partunurrangujartinyja, marlkarri jarrinyi. Palinymilalu kujarralu partanyjujirri Esau-lupa Jacob-ju pirtinga jirnipulu palanga. ");
INSERT INTO nna_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob-ju ngurra paljurnu palinymilingi japartumilingi warrarnja, yini marnayi pala warrarn Canaan. ");
INSERT INTO nna_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Wurralamarnanta Jacob-milaku partanykarranguku. Joseph-ju tuku jirnikinyijaninyi palinymili japartumili kukurnjarirrangupa nanikuturrangu. Palanga paliny 17 partunurranguja. Jinta palinymili mamajimurninyarrangu waninyikinyiyi palakurtirri, Bilhah-milipa Zilpah-mili partanykarrangu. Wurrarnikinyili palinymilingi japartungu palinymilirrangulu mamajimurninyarrangulu jampa kulujartiny jirnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Joseph ngayarta jarrinyi jampa palinymilingi japartungu mirtanya jarrinyajalu. Palajalu paliny yija ngarlunga Jacob-ja. Palinymilirranguja wiyirrja partanykarranguja Joseph yija ngarlunga palinymilingi. Yinyala Joseph kuwurtu marnikata long robe — work out best term. ");
INSERT INTO nna_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Palinymilirrangu mamajimurninyarrangu miranu jarrinyiyalu janamilalu japartulu ngarlunga jirni yija marrkamurniny. Palaja kulilu yirrirnikinyiyi, malyparr karrinyikinyiyalu palinyku. ");
INSERT INTO nna_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Warrukartingi warajanga kapukarri marna Joseph-ju, wurrarnajanaku palinymilirrangungu mamajimurninyarrangungu. ");
INSERT INTO nna_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“Pinakarrayi! Wurralamarnanyurraku ngani kapukarri marnarna. ");
INSERT INTO nna_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Paru makanu wirrkarnikinyiyirni, pala paru mayijartiny. Pirntu?? jirnikinyiyirnipa kunyji pirnikinyiyirni jungkanga yakarnikinyiyirnijaninyi. Ngajumili pirntu wararr karrinyi. Nyuntumilirrangu kunmu jarrinyiyi, wupurnijiyi, murtinga jurlpi-jurlpi.” ");
INSERT INTO nna_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Pinakarrinyiyi pala muwarrja paliny mamajimurninyarrangulu kuli jarrinyiyalu. “Wunyjurru? Nyuntu maaja jarrinyaku karrinyan nganarnaku, wurranaku nganarnaku jinaku?” Pinakarrinyajalu kapukarriku wariny muwarr palinymili kulilu yirrirniyi. ");
INSERT INTO nna_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Palaja wariny yarrana kapukarri marna. Mamajimurninyarrangungu wurrarnajanaku, “Pinakarrayiji! Yarrana kapukarri marnarna. Kapukarringi ngajumilingi yirrirnirnijaninyi karrpupa wirlarrapa panikatarrangu 11 wupirnijiyi palarrangu.” ");
INSERT INTO nna_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Palinymili japartulu pinakarrinyajalu warnta marna. “Nganikapali pala kapukarri? Nyuntulu wurrarnan nganarnaku nyuntuku wupinaku jungkakarti? Munu wupilipiyirnangu ngaju, pipi, nyuntumili mamajirrangupa marrka, Pinjamin.” Palajunjalu warnta marna Jacob-ju. ");
INSERT INTO nna_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Joseph-milalu mamajirrangulu yirrkulu ngampan karrinyikinyiyalu. Palinymilalu japartulu kurlkarri marnikinyi ngarrany pala kapukarri. ");
INSERT INTO nna_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Yarti mamajirrangulu kanyayijaninyi janamili japartumili kukurnjaripa nanikuturrangu Shechem-ukurtirringi kanyjirnikinyiya parumarramarraku kuwiyirranguku nganinyaku. ");
INSERT INTO nna_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Japartulu palinymilalu muwarr pinalu Joseph-ku, “Nyuntumilalu mamajirrangulu kalkurnayijaninyi kuwiyirrangu Shechem-ukurtirringi. Ngajulu ngakalamarnanta janaku.” “Yuu. Yankulumarnajanaku, Japartu.” ");
INSERT INTO nna_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","“Kajanajalu japirr malamanjaninyi “Wayirti? Ngalypa waninyinyurru? Wayirti kuwiyirrangupa? Ngalypa waninyiyi?' Kulpulumun ngajukarti, wurralapijin wayirti, ngalypa waninyayi.” Palajalu ngakarna Joseph. Joseph-ju yakarna ngurra, yana jinangu Shechem-ukarti. ");
INSERT INTO nna_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Palanga kajanajalu, munu, kanyjirnijanaku. Kanyjin-kanyjinangulu warinyjulu marrngulu japirr marna, “Nganiku kanyjirnan?” ");
INSERT INTO nna_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Ngaju kanyjirnarnijanaku ngajumiliku mamajirranguku. Wayirti nyuntu miranu wanyjarni kanyayijaninyi kuwiyirrangu?” ");
INSERT INTO nna_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“Purlpi ngarrany yanayi. Pinakarrinyirnijaninyi, 'Yankunyi Dothan-karti'.” Joseph-ju yajarnajaninyi, yirrirnijaninyi wangka Dothan. ");
INSERT INTO nna_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","20","Yirrirniyi kajangulu ngarrany janamili marrka. Wurrarniyirnangu, “Nyungu kapukarri manakata milpayinyi. Jipi wirlalaminyi marlkarringi. Parnpilaminyi pirtingi wirtungu. Wurralaminyili japartungu nganyjurrumilingi, kuwiyilu kulikatalu marlkarri wirlarni, nganayi. ??. Palajalu kapukarrimajirri wantuliny. ");
INSERT INTO nna_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","22","Rueben-ju pinakarrinyikinyi jana muwarr pinaja. “Munu marlkarringa wirlanaku Joseph-ku! Parnpiliminyi nyungu pirtingi wirtungu.” Rueben-ju kurlkarri marnikinyi, “Yarti kulpulumarnalu, mankulumarna marrka pirtija, kangkulumarna nganarnamilikarti japartukarti.” ");
INSERT INTO nna_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Joseph turlpanyijanaku palinymilaku mamajirranguku. Warlirniyi, yinyjil pirniyalu palinymili kuwurtu coat?? marnijartiny, ");
INSERT INTO nna_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","parnpirniyi pirtingi wirtungu, mulyingi yiji. Pirti punarra. It was actually an old water-cistern, dug to hold water, but dry. ");
INSERT INTO nna_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Kajarniyi mayiku nganinyaku. Mayi nganinyangulu yirrirniyijaninyi marrngu taManasseh camel-jartiny pirlurru yajarnikinyiyi. Jinta ngurra warinyja, yini marnayijaninyi Ishmael-milirrangu. (Wariny janamili yini Midian-milirrangu.) Tamarniyi Gilead-ja, yananyayi Egypt-karti. Camel-ju kanganyikinyiyi jurikata jirnikatapa mirrijin warinypa wariny warnkuku maninyaku. ");
INSERT INTO nna_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Malyurtamarninyju Judah-lu wurrarnajanaku, “Munu wirlanaku marlkarriku marrkaku nganyjurramilaku, munu kuku jinaku palinyku kawuku. ");
INSERT INTO nna_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Jinyji pilkunyi warnkuku nyungungurrangu Ishmael-arrangungu. Paliny palama nganyjurramili walja marrka, munu wirlanaku marlkarri.” ");
INSERT INTO nna_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wangka jarrinyijalu marrngurrangu camel-jartinyarrangu jinyji pirniyi mamajirrangulu warnkuku nyungurrangungu. Manayi kuliny-kulinyju, ?? kanganyangulu Egypt-kartijakun. ");
INSERT INTO nna_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Yarti kulpanya Rueben pirtikarti. Munu kanyjirnalu Joseph-ku. Rueben ngarlu kurlu jarrinyi munu kanyjinaja. Wurrukarra palinymili ngartarna marlparrjartinyju. ");
INSERT INTO nna_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kulpanyajanaku mamajirranguku, wurrarnajanaku, “Marrkaku munu kanyjirnirnalu! Ngakumpa jarrinyirni!” ");
INSERT INTO nna_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Wirlarniyi nanikutu, pijirringi nanikutunga wirrirniya kuwurtu Joseph-mili. ");
INSERT INTO nna_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kanyayi kuwurtu janamilikarti japartukarti. “Nyungu yirrili kuwurtu! Yirrirniyirni warrarnja warinyja! Yijapa nyuntumilimili partanymili?” ");
INSERT INTO nna_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yirrirni. “Yijarla pala ngajumilimili partanymili, Joseph-mili! Kuwiyilu kulikatalu nganiyi!” ");
INSERT INTO nna_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Palajalu Jacob wirrilyijartinyju wurrukarra palinymili ngartarna. Wirrirnirnangu kurlujartinyirrangu wurrukarra. Ngangkurlu pirnikinyalu partanyku palinymilaku karrpurrangu karrpurrangu. ");
INSERT INTO nna_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Palinymilalu partanykarrangulu pirirrilupa mirtawalu partarl tuku jirnikinyiyi. Yirrkulu ngangkurlu pirnikinyalu. “Partarl pikaly jiliminyinyurru. Kurluny-kurluny wantulumarna marlkarrikartijakun.” ");
INSERT INTO nna_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nyungungu warrarnja warinykartingi palalurrangu kanganyikinyiyi Joseph Egypt-kartijakun. Palanga kajanajalu jinyji pirniyi warnkuku. Mana marrngulu, yinilu Potiphar-lu. Potiphar nyampali wirtu warrkamu puluka king-ku Egypt-milaku, nyampali jurljarranguku king-milaku. He was captain of the king's personal bodyguard. ");
INSERT INTO nna_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Palamartaji ?? “about that time” — soon after his brothers had sold Joseph as a slave and the traders took him to Egypt Judah-lu yakarna marrkarrangu palinymili, warnkumarramarraja katukarna, yana ngapikarti, Adullam-karti. Ngurra jirni pirirringa, yini Hirah. ");
INSERT INTO nna_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Palanga warrarnja pirirri Canaan-mili nyirrirnikartijanga, yini Shua. Shua partany mirtawajartiny. Judah-lu yirrirni. Yarti warajanga jarrinyapulu. Karta karrinyipulu, mirtawa ngarlungu jarrinyi, pirirri partany kanya, yini marnapulu Er. ");
INSERT INTO nna_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Palaja pirirri wariny partany kanya, yini marnapulu Onan. ");
INSERT INTO nna_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Palaja wariny pirirri partany kanya, yini marnapulu Shelah. Ngayarta jarrinyaja ngurra waninyayi ngapinga, Kezib-ja. ");
INSERT INTO nna_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Punjaja Judah mirtawa kanya, yini Tamar, palinymili murrkangunyaku, Er-ku. ");
INSERT INTO nna_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ngarrka yirrirnikinyi Er, kurlu yija pala pirirri. Palajalu Ngarrka marlkarri wirlarna. ");
INSERT INTO nna_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Palaja Judah-lu wurrarnala Onan-ja, “Nganyjurrumilija mangunyja, pirirri marlkarri jarrinyaja partanymajirri, palinymili marrka karta karrinyaku palinymilinga mamajinga nyupajinga, yirrirnikartijarrangu jinaku mamajiku, mamajimilirrangu jarrulupiyi. Palajun jilaman, karta karrulinyumpulu Tamar-pa. ");
INSERT INTO nna_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan miranu pala partany munu palinymili wantuliny. Palajalu karta karrinyapulu, palinyju parti palinymili jurtirni jungkanga, partany jinangamarra mamajiku. ");
INSERT INTO nna_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ngarrka wurrarna, “Pala pirirri pukurl kurlu yija jirnikinyi!” Palajalu marlkarri wirlarna Onan. ");
INSERT INTO nna_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Palaja Judah-lu wurrarnala ngarraya palinymilingi, Tamar-nga, “Kulpulaman japartumurninykarti ngurrakarti, palanga pirirrimajirri wantuluman. Yarti pujamu ngajumili wirtu jarruliny, Shelah, palanga warajanga wantulinyumpulu.” (Judah mitu-mitu marnala. Kurlkapirli jarrinyarninyi, “Marlkarri jarrala Shelah pukun, mamajikapalijirri!”) Palaja Tamar kulpanya japartumurninykarti, waninyi palinymilingi ngurranga. ");
INSERT INTO nna_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Yarti Judah-mili mirtawa marlkarri jarrinyi. Ngangkurl jinaja, Judah-pa ngapinga, Timnah-karti yana. Warinyarrangulu kukurnjayi palinymili jiyiramu jirnikinyalu. Yanapulu Judah-pa miyirti palinymili Hirah, paliny ngapija, Adullam-ja. ");
INSERT INTO nna_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Warinyju Tamar wurrarnalu kakajimarniny Timnah-karti yankuliny. ");
INSERT INTO nna_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Miranu jarrinyi Tamar Shelah-ku, Judah-mili nyirtingunyaku, purlpi pirirri jarrinyi. Judah-lu Shelah yinyama Tamar-nga, pulany warajanga jarrinyaku. Purlpi matunyaku wurru wartu jirnirnangu Tamar. Pala muwarr pinakarrinyajalu, matunyaku wurru karnu pirnarninyi, wariny wurru wirrirnarninyi, waralu ngumpa wurta jirnarninyi. Palaja yana ngapikarti, Enaim-karti, tawun wupartu pala, ruwurtunga Timnah-karti. Enaim wangkamartaji ruwurtunga kajarna. ");
INSERT INTO nna_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judah Timnah-karti yananyaja Tamar yirrirni, ngumpa warapurni, kurlkarrinyarningu mirtawa kurla-kurla paliny. Munumpa pala mirtawa ngarrayamarniny palinymili! ");
INSERT INTO nna_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yana-yana mirtawakarti ruwurtumartajinga, wurrarnalu, “Yuu, warnkuku wirtuku karrinyanpa?” Japirr marna, “Ngani yungkulupijin?” ");
INSERT INTO nna_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judah-lu puntaju marna, “Kuwiyirranguja ngajumilija ngakalamarna nanikutu.” “Yuu, ngapi kuwarri yungkuluman, yarti jinyji jilamarna nanikutuku.” ");
INSERT INTO nna_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“Ngani yungkulumarnanta kuwarri?” “Nyuntumili seal-pa marntipinti warnu pukun.” Yinyalu palajirri. Palaja karta karrinyipulu. Palajunju ngarlunga jarrinyi Tamar. ");
INSERT INTO nna_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ngurrakarti kulpanyi Tamar, ngumpa wartu jirnarningu yirrinangamarra, matunyamili wurru wirrirnarningu. ");
INSERT INTO nna_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah-lu miyirti ngakarna, Hirah, nanikutujartinyju, mirtawa kanyjinakupa mananyaku palinymili seal-pa marntipinti warnu. Partarl Hirah-lu kanyjirnalu mirtawaku. ");
INSERT INTO nna_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Marrngurrangu Enaim-martaji wurrarnajanaku, “Wanyjarningi pala kurla-kurla mirtawa, purlpi nyungungu ruwurtungumartaji waninyi?” Puntaju karra marnayi, “Munu yiji kurla-kurla mirtawa nyungungumartaji waninyi.” ");
INSERT INTO nna_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hirah kulpanya Judah-karti, wurrarnalu, “Partarl kanyjirnikinyirni. Marrngurrangulu ngurraralu wurrarnajiya, munu yiji kurla-kurla mirtawa palangamartaji.” ");
INSERT INTO nna_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Karra marnalu Judah-lu, “Puru wanta. Palajirri seal-pa marntipinti warnu kalkuli. Ngurrararrangulu pinakarrayali, yijapa nyarru piliyingalikalu. Yijalu jinyji pinaku karrinyarna. Kanyjirnan-kanyjirnan, munu.” ");
INSERT INTO nna_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kujarrapa waraja wirlarrarranguja warajalu Judah-nga wurrarnalu, “Ngarrayamarniny nyuntumili kurla-kurla mirtawa jarra-jarrinyi, paliny ngarlunga.” Puntaju karra marna Judah-lu, “Jalakarti kanganyaja kampanyaku marlkarringa!” ");
INSERT INTO nna_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kanganyakanu muwarr ngakarnalu kakajimurninykarti, “Warajalungarra pirirrilu ngarlunga jirninyi. Parrjala nyungujirri seal-pa marntipinti warnu pukun. Parrjala! Nyuntumili!” ");
INSERT INTO nna_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah miranu jarrinyi palajirriku, wurrarna, “Tamar yijalu jirni. Kurlu jirnirni palinyku. Yinyarnamalu partany ngajumili, Shelah, warajanga jarrinyaku pulany.” Palajangarra Judah munu Tamar-nga karta karrimapulu. ");
INSERT INTO nna_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Partany kanganyaja, miranu jarrinyayi partanyjirri kujarrajartiny! ");
INSERT INTO nna_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Partany kanganyajalu, warajalu parirr jirrarninya. Mirtawalu mana, mirrilyi pilyarri kunyji pirni, wurrarna, “Nyungungarra walangkarra turlpanyi.” ");
INSERT INTO nna_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Palaja parirr purrirna kaninykurti, palaja mamaji palinyku murrkangunya jarrinyi. Palanga mirtawalu wurrarnalu, “Nyungukapalingarra kurtanyan!” Palajalu yini marnayi “Perez” which means, “breaking out”. ");
INSERT INTO nna_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Palaja marrkamarniny kurtanya, pilyarri milyirri parirrja. Yini marnayi “Zerah”. ");
INSERT INTO nna_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nyarrangarrangu Ishmael-milirrangu Joseph kanyayi Egypt-karti, kajanajalu jinyji pirniyi warnkuku. Mana marrngulu, yinilu Potiphar-lu. Potiphar nyampali wirtu warrkamu puluka king-ku Egypt-milaku, nyampali jurljarranguku king-marninymilaku captain of the king's personal bodyguard. ");
INSERT INTO nna_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Joseph warrkamu jarrinyikinyi ngurranga palinymilimilingi nyampalimilingi. Ngarrkalu ngalypa jirnikinyalu. Yatilpa jarrinyi ngurranga Potiphar-milingi. ");
INSERT INTO nna_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potiphar-lu yirrirni ngalypakata jirnikinyijaninyi, Ngarrkalu tuku jirnikinyi, nganipa jirnikinyijaninyi ngalypa. ");
INSERT INTO nna_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Palajamarra pikaly jarrinyalu Joseph-ku, nyampali jirni palamarrangu palinymilingi marrngurrangungapa wurrukarrarrangunga. Joseph-ju tuku jinikinyi pukurl palinymili nyampali. ");
INSERT INTO nna_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ngarrka pikaly jarrinyalu Joseph-ku. Palajunjalu ngalypa jirnikinyalu Potiphar-ku, Joseph-milaku nyampaliku. ");
INSERT INTO nna_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potiphar-lu wurrukarrarrangu yakarnala wiyirr Joseph-ku tuku jinaku. Munu nganipa kurlu jarrimalu Potiphar-ku, ngalypajakun jirnijaninyi Ngarrkalu. Potiphar-lu mayija ngananyajalu karta karrinyikinyi. Wirrilyimajirri, pikaly yiji. Joseph wangalangu yiji, ngumpa ngalypakata kawupa. ");
INSERT INTO nna_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Palaja jampa Potiphar-milalu mirtawalu marru marnikinyi Joseph. Japirr marna, “Karta karruli warajanga.” ");
INSERT INTO nna_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","“Munu ngali karta karrinyaku warajanga! Nyuntu ngajumilimili nyampalimili mirtawa. Wirrirninyi ngaju nyampali palinymilaku wurrukarraku wiyirrku, kalkunaku wiyirrku. ");
INSERT INTO nna_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Munu nyuntuku kanganyaku. Munu ngaju muwarrku Ngarrkaku ngartanaku!” ");
INSERT INTO nna_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Palalu mirtawalu yirrkulu japirr marnikinyi. Palinyju yirrkulu, “Munu ngali karta karruli warajanga.” Munu karta karrimapulu warajanga. ");
INSERT INTO nna_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Warajanga karrpungu Joseph ngalpanya mayanga palinymilimilinga nyampalimilinga warrkamuku jinaku. Jinta pirirrimarta waninyikinyiyi warinykartingi, kajamarta. ");
INSERT INTO nna_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Palalu mirtawalu manalu palinymili kuwurtu, japirr marna karta karrinyaku. Yakanajalu kuwurtu mirtawanga parirrja, Joseph mirti jarrinyi kaninykurtija. ");
INSERT INTO nna_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","14","Mirtawalu warlirnikinyi kuwurtu. Kamarnajanaku warinykurrangu pirirrimartaku. Turlpanyiyalu milpanyajalu mitu marnikinyijanaku. “Ngajumilalu pirirrilu nyungu pirirri kanya nyungukarti mayakarti kurntany jinaku ngajuku. Turlpanyi kaninykarti, karra marnaji, 'Karta karruli warajanga.' Yakal marnarna ngajulu. Kamarnarna marrja. ");
INSERT INTO nna_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Kamanajalu yakarna kuwurtu, mirti jarrinyi mayaja kaninykurtija.” ");
INSERT INTO nna_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kalkurnu kuwurtu kala Joseph-mili, mimarnalu palinymilaku pirirriku kulpanyajaku. ");
INSERT INTO nna_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Potiphar kulpanyajalu palarrangu ngarrany muwarr wurrarnala. “Nyarra pirirri, nyarra Hebrw nyuntulu kanyanpa nyungukarti mayakarti, turlpanyi nyungukarti ngaju kurntany jinaku. ");
INSERT INTO nna_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kamarnarna marrja, yakarna kuwurtu nyungungu mirtimarninyju.” Palajunju mitu marna palinymili pirirri. ");
INSERT INTO nna_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potiphar-lu pinakarrinyijalu wirrilyi karrinyi yiji. ");
INSERT INTO nna_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Palinyju kanya Joseph jurntikarti. Palanga jurntinga kingilu wirrirnikinyijaninyi wirrilyijartinyju. Joseph waninyikinyi palanga jurntinga. ");
INSERT INTO nna_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ngarrkalu munu kakurnama Joseph, jurntingaja kurlkarri marnikinyi paliny. Palajunjalu jurntiku nyampali pikaly jarrinyalu Joseph-ku. ");
INSERT INTO nna_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Wurrarnalu nyampalilu Joseph-ku, “Nyungurrangu marrngu tuku jilamanjaninyi. Nyampali nyuntu yiji jirnirninti, yirrilamanjaninyi warrkamupa jilipiyi jurntinga.” ");
INSERT INTO nna_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ngarrkalupa Joseph-ju jirnikinyipulu marakulalu. Palajalu wiyirr ngalypa jarrinyi. Nyampali jurntiku puru pikaly wanikinyi. Yakarnala wiyirr warrkamu Joseph-ku. ");
INSERT INTO nna_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Jampa palajalu kingi palaja warrarnja wirrilyi jarrinyipulaku kujarraku warrkamu pulukaku. Warinyju tuku jirnikinyalu wayin kingimili, warinymarninyju mayi kamparnikinyalu kingiku. Palalujirri kingi wirrilyi jinapulu. ");
INSERT INTO nna_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Palajalu jurntinga wirrirnapulinyi, palanga jurntinga Joseph waninyikinyi. ");
INSERT INTO nna_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Nyampalilu jurljaku wurrarnalu Joseph-ja, “Tuku jilamanpulinyi palajirri!” Joseph-ju tuku jirnikinyipulinyi punja. ");
INSERT INTO nna_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Warajanga warrukartingi kapukarri marnapulu. ");
INSERT INTO nna_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Karrpunga jarrinyaja yirrirnapulinyi Joseph-ju, wirrilyijartinyjirri. ");
INSERT INTO nna_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","“Nganija nyumpala ngumpa wirrilyijartiny?” ");
INSERT INTO nna_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“Kapukarri marnalayi. Palajirriku kapukarriku ngaliku ngakumpa ngaliyi. Munu wurrarnakayingalayinyi pala muwarr.” “Ngajunga wurralajipulu ngani palajirri kapukarri mananyumpulu. Ngarrka miranu nyumpalamilaku kapukarriku. Palinyju ngaju miranu jilamanyi.” ");
INSERT INTO nna_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Nyampali wayinkulu wurrarnala, “Kapukarri marnarna yirrirnirni mungka kurayipipinti kujarrapa waraja karlkajarrarrangujartiny. Jampa walyakajartiny jarrinyaja pupujartiny jarrinyiyi, jukurtarrangu turlpanyiyi, murla jarrinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Minpinapinti kingimili warlirnarna parirrja. Manarnajaninyi jukurtarrangu, nyitarnarnajaninyi parirrju, wayin jarrinyaku, yinyarnarna kingi.” Palajunju wurrarnala Joseph-ngu. ");
INSERT INTO nna_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph-ju wurrarnala, “Pala kujarra waraja karlkajarrarrangu palalu wurrarna kujarrapa waraja karrpu. ");
INSERT INTO nna_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kujarrapa warajaja karrpuja kingilu wurralkulinyjanaku nyuntu murru malapiyinta jurntija, jipi nyuntu ngalypa, yarrana palinymili warrkamu puluka jilamanta. Nyuntu ngarrany palinymili wayin kanganyakata jarruluman. ");
INSERT INTO nna_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","15","Nyunguja pirtija murru malapiyinta kurlkarri malamanyin. Wurralamanpala kingingi yija, japirr malamanpa murru malamanyi nyunguja pirtija. Purlpilu jintalu marrngurrangulu warlirninyiyi kanyanyiyi ngajumilija warrarnja, Hebrew-mili warrarnja, nyungukarti kanyanyi. Ngajulu munu kurlujartiny jinamarna nganipa nyungungu warrarnja, wata wirrirninyiyi nyungunga jurntinga. Japirr malamanpa kingi yiji nyunguja murru malaminyi jurntija.” ");
INSERT INTO nna_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mayi kampanakatalu muwarr pinakarrinyijaninyi ngalypakatarrangu wurrarnala Joseph-ja, “Ngajulu pukun kapukarri marnarna. Kapara kujarrapa waraja martumurripinti kanganyikinyirnijaninyi jurnturtungu. ");
INSERT INTO nna_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kankakartingi kampanajarrangu warinypa wariny mayi kingiku. Wirrujartinyju ngananyikinyiyi pala mayi kankakartija.” ");
INSERT INTO nna_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","“Nyungu nyuntuku muwarr. Pala kujarra waraja kapararrangu palalu wurrarna kujarrapa waraja karrpu. ");
INSERT INTO nna_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Pala kujarrapa waraja karrpuja kingilu wurralkulinyjanaku kangkulupiyinta nyunguja jurntija kingikartimilirrangu jurljakarti, kingilu wurralkulinyjanaku ngalyi malyalapiyinta. Kawu nyuntu marlkarrija jarnti jilipiyinta karntinga wurrunga. Wirrujartinyju ngalkulupiyinta kawu.” Palajunju wurrarnala Joseph-ju. ");
INSERT INTO nna_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Palaja kujarrapa waraja karrpuja kingilu wurrarnajanaku, “Mayi wirtu kampalkulinyurru nganin-nganin wirtukurrangu warrkamu pulukurranguku ngajumilaku.” Wurrarnalu warinyja, “Marrapulinyi palajirri jurntija nyampali wayinkupa mayi kampanakata.” ");
INSERT INTO nna_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Wayin kanganyakata warrkamu jarrinyalu kingiku ngarrany. ");
INSERT INTO nna_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mayi kampanakata wirlarniyi marlkarri, jarnti jirniyi kawu karntinga mungkanga kingimilija muwarrja. Yija muwarr wurrarnapulaku Joseph-ju palangajirri wayinku nyampalingipa mayi kampanakatanga. ");
INSERT INTO nna_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Palalu wayinku nyampalilu munu kurlkarri marnama Joseph, kakurna ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Yarti kujarra partunuja kingi kapukarri marna. Palanga kapukarringa wararr karrinyikinyi wangka pijunga wirtunga, yini pala piju River Nile. ");
INSERT INTO nna_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Parrjan-parrjanangulu 7 purlikarrangu jinjikatarrangu janpaja turlpanyiyi, pijungu ngananyikinyiyi paru. ");
INSERT INTO nna_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Palaja 7 purlikarrangu pajalimajirri winyjany-winyjany janpaja turlpanyiyi, wararr karrinyikinyiyi wangka pajalikatanga purlikaja. ");
INSERT INTO nna_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Palanga nganayijaninyi wiyirr pajalikatarrangu purlika. Palaja kingi parrily jarrinyi kartaja. ");
INSERT INTO nna_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Palaja karta karrinyi, kapukarri marna wariny. Kapukarringa yirrirni patalyi yini wiyiti, waraja patalyi 7 mayijartiny, ngalypakatajartiny yiji. ");
INSERT INTO nna_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Palaja 7 patalyi kurlujartinyirrangu turlpanyiyi, purangulu wangalju kamparnajaninyi lalka jinangulu. ");
INSERT INTO nna_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Palarrangulu 7 kurlujartinyirrangulu kunanyiyijaninyi ngalypakatarrangu. Kingi parrily jarrinyi kartaja, parrily jarrinyingulu puru kapukarri. ");
INSERT INTO nna_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Marntungu ngawu kanyjil-kanyjil jarrinyikinyi kapukarrikujirri. Muwarr ngakarnajanaku kamanaku warrkamuku maparnpurrjakupa yatilpaku. Wurrarnajanaku pala kapukarrijirri, janapa ngawu kanyjil-kanyjil wurrarnayirnarninyi. Munu nganurtupa miranu palakujirri kapukarriku. ");
INSERT INTO nna_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Palaja wayin nyampalilu wurrarnala, “Kurlkapirli jarrinyirni, muwarr kakurnarnangu. ");
INSERT INTO nna_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Purlpingarra nyuntu wirrilyi jarrinyinngaliyaku kujarraku. Nyuntulu wirrirninngalayinyi nyuntumili mayi kampanakatapa ngaju jurntinga. Wurrarnanpalu nyampalinga jurljaku 'Tukulu parrjalapulinyi palamajirri, mujarri jarriyipululu.' ");
INSERT INTO nna_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Jurntingalu ngaliyalu kapukarri marnaliyi warajanga warrukarti. ");
INSERT INTO nna_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Palamanga wangalangu, paliny Hebrew-milija. Paliny warrkamukata jurljamilaku nyampaliku. Ngaliyalu wurrarnaliyili kapukarri ngalayimili. Wurrarnangaliyaku ngalayimili kapukarrijirri. ");
INSERT INTO nna_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Pala kujarra muwarr yija jarrinyipulu. Yarrana warrkamukata jirninyin, wurrarnanjanaku jurljaku, 'Wirlaliyi palama mayi kampanakata marlkarri'.” Palajunju palalu wayin nyampalilu wurrarnala kingingi. ");
INSERT INTO nna_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pinakarrinyajalu palakurrangu muwarrku kingilu ngakarna jurntikarti walarni jinaku Joseph-ku janyinku. Joseph-ju ngarnka wirrkarnarninyi, wirrirnirnangu wurrukarra ngalypakata. ");
INSERT INTO nna_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kingilu wurrarnala, “Ngajulu kapukarri marnarni, munu nganurtulupa wurrarnakaji pala muwarr. Wurrarnajiyi nyuntu miranu palaku muwarrkurrangu.” ");
INSERT INTO nna_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","“Ngaju munu yatilpa, Ngarrkalu wurralkulinyngaliku pala muwarr.” Palajunju wurrarnala kinginga. ");
INSERT INTO nna_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kingilu wurrarnala, “Ngajumilinga kapukarringa wararr karrinyikinyirni pijunga wangka Nile-ja. ");
INSERT INTO nna_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Yirrirnirnijaninyi 7 purlika pajalikatarrangu turlpanyiyi ngapaja. Janalu ngananyikinyiyi paru. ");
INSERT INTO nna_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Palaja 7 pajalimajirrirrangu turlpanyiyi ngapaja, palarrangu winyjaly-winyjaly yiji. Munu ngajulu yirrirnamalparnajaninyi purlika nyungurrangukapali nyungunga warrarnja Egypt-ja! ");
INSERT INTO nna_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Palangurrangu winyjaly-winyjalyju kunanyiyijaninyi pajalikatarrangu. ");
INSERT INTO nna_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Palaja ngananyijalu waninyiyi winjaly-winyjaly ngarrany. Palaja kartaja parrily jarrinyarni. ");
INSERT INTO nna_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Palaja kapukarri marnarna warinymal. Yirrirnirni patalyi yini wiyiti, waraja patalyi 7 mayijartiny, ngalypakatajartiny yiji. ");
INSERT INTO nna_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Palaja 7 patalyi kurlujartinyirrangu turlpanyiyi, purangulu wangalju kamparnajaninyi lalka jinangulu. ");
INSERT INTO nna_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Palarrangulu 7 kurlujartinyirrangulu kunanyiyijaninyi ngalypakatarrangu. Wurrarnajanaku kapukarri yatilpanga, palalurrangu munu wurrarnamajiyi.” ");
INSERT INTO nna_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph-ju wurrarnala kinginga, “Nyuntumili kapukarrijirri muwarr palajirri warajangarra. Ngarrkalu jurti jinangu ngani jilkuliny kuwarrilu. ");
INSERT INTO nna_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Palarrangulu 7 pajalikatalurrangu purlikalu wurrarnaya 7 partunu ngalypakatarrangu. Waraja ngarrany wurrarnaya 7 ngalypakatarrangulu wiyitilu. Pala kapukarrijirri warajangarra muwarr. ");
INSERT INTO nna_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Palarrangulu 7 winyjaly-winjalyju purlikalu wurrarnaya 7 partunu kurlujartinyirrangu. Waraja ngarrany wurrarnaya 7 kurlujartinyju wiyitilu, purangulu wangalju kamparnajaninyi lalka jinangulu. Palamarrangungu 7 partunungu kurlujartinyirrangunga wuparturrangu mayi ngalkuluminyi. ");
INSERT INTO nna_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Palajun muwarr pirnirninyurraku, Ngarrkalu jurti jinanga yukuyil jilkuliny kuwarri jampamarta. ");
INSERT INTO nna_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Palanga 7 partunungu mayi kalkuluminyi wirtu yiji ngunarrijirringi warrarnjirringi Egypt-ja. ");
INSERT INTO nna_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Palajalu 7 partunurrangulu kurlujartinyirrangulu yajalapiyijaninyi 7 partunurrangu ngalypakatarrangu. Wupartu mayi turlpulapiyi. Kurlujartiny jarruliny yiji nganyjurruku wiyirrku. Kakuluminyi mayi kalkurnalpinyi purpilu marlu. Kurluny-kurlunyja warrarnja yiji wantuluminyi. ");
INSERT INTO nna_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ngarrkalu yinya nyuntunga pala kapukarrijirri jurti jinangu palajun jilkuliny kuwarrimarta. ");
INSERT INTO nna_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Yijapa pinakarrulupijin, kingi, yukuyil jilimin. Kurlkapirlikata mankuluman, nyampali jilaman wiyirrku warrarnku. ");
INSERT INTO nna_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Yijapa wurralamanjanaku warinykurrangu warrkamu pulukukataku kuru malkulupiyijaninyi mayirrangu warinyjirrangu tawunjarrangu. Palalurrangu pirirrimartalu marlu jilapiyi mayi partunungu ngalypajalu, winya jilipiyi tawunjarrangu, tuku jilipiyi nyuntumilijalu muwarrjalu. ");
INSERT INTO nna_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kurlujartinyja partunurrangunga marlu wantulinynganyjurruka mayi. Palaja munu janparrja marlkarri jarruluminyi.” Palajunjalu. ");
INSERT INTO nna_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kingipa palinymili pirirrimarta pinakarrinyiyalu Joseph-ku. “Nyungu muwarr ngalypakatarrangu!” ");
INSERT INTO nna_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kingi muwarr pirnijanaku palinymilaku pirirrimartaku, “Ngarrkamilalu pirlurrju kalkurna Joseph. Munupa nganurtu palinykapali, yatilpa yiji.” ");
INSERT INTO nna_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kingilu muwarr pinalu Joseph-ku, “Ngarrkalu nyuntu miranu jinanta, munu nganurtu nyuntukapali ngalypakata yatilpa. ");
INSERT INTO nna_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Palajalu nyuntu nyampali jinarnanta nyungu warrarnkujirri, ngajumilarrangulu marrngulu nyuntuku pinakarrulupiyangu, janalu jilipiyi nyuntujalu muwarrjalu. Ngaju ngarrany nyampali wantulamarnanga nyuntuku. Nyuntu nyampali wantulumanjanaku jintaku wiyirrku. ");
INSERT INTO nna_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kuwarri ngajulu nyampali jinarnanta wiyirrku Egypt-ku.” ");
INSERT INTO nna_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kingilu palinymili ringi parirrja yinyji pirni, wirrirnili parirrja Joseph-ja. Wurrarnajanaku jintaku wurru wirriliyili Joseph-ja ngalypakatarrangu. Kingilu ngalyinga wirrirnili miji-mijikata chain. ");
INSERT INTO nna_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kingilu yinya Joseph palinymili waraja chariot jarli pinaku. Pirirrimarta jinta marnti yanalpiyi walangkarrangu chariot-ja, kamarnalpiyijanaku warinykurrangu marrngurranguku, “Purlu jarrayi! Purlu jarrayi!” Palajalu kingilu nyampali jirni wiyirrku warrarnku. ");
INSERT INTO nna_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kingilu muwarr pinalu Joseph-ku, “Ngajurla nyampali wiyirrku nyungu warrarnku. Ngajulu nyuntu nyampali wirtu jinarnanta. Nyungunga warrarnja marrngurrangu nyuntuku pinakarrulupiyangu, jilipiyi nyuntujalu yiji muwarrjalu.” Palajunjalu wurrarnala Joseph-ngu. ");
INSERT INTO nna_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46a","Palajalu kingilu yini yinya Joseph wariny, Zaphenath-paneah. Kingilu mirtawa pukun yinyala, yini pala mirtawa Asenath. Palamili mirtawamili japartu yini Potiphera, palapali nyampali muwarrku yatilpamilaku, tawun-ja yini Heliopolis. Palajalu Joseph wirtu yiji nyampali jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN41_46b","002_41_46b","GEN","41","46b","46b","Kingilu nyampali jirni Joseph 30 partunu jarrinyija. ");
INSERT INTO nna_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Palaja 7 partunurrangungu mayi marlu yiji jirniyi. ");
INSERT INTO nna_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Palanga partunurrangungu Joseph yani-yanikinyi ngunarrijirri warrarn, wurrarnikinyijanaku, “Kuru muluyi mayirrangu marlurrangu yiji!” Winya jirnikinyiyi wirturrangu mayarrangu mayarrangu, tawunjarrangu tawunjarrangu palanga warrarnja. ");
INSERT INTO nna_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Palajunju jirni munu marlu yiji. ");
INSERT INTO nna_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Palangarrangu partunurrangu Joseph-milalu mirtawalu partanyjirri kujarra kanyapulinyi mutunyajirri. ");
INSERT INTO nna_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph-ju yini marna walangkarrangumarniny Manasseh. “Ngarrkalu ngalypa jirnilpija, ngajulu kakulumarnajaninyi ngajumili japartumilirrangupa, kakulumarnajaninyi ngajumilarrangulu mamajilurrangu kurlujartiny jirnilpijiya.” Palajunjalu yini marna pala partany Manasseh. ");
INSERT INTO nna_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yini marna nyirrirnikartimarninyja Ephraim. “Marrngurrangulu kurlujartiny jirnijiya nyungu warrarnja. Kuwarri Ngarrkalu yinyaji ngajumilirrangu waljarrangu nyungunga warrarnja.” Palajunjalu yini mirni pala partany Ephraim. ");
INSERT INTO nna_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Palajarrangungaja 7 ngalypa partunuja wanayirti munu pungkumajanaku. ");
INSERT INTO nna_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Palaja 7 kurlujartinyarrangu partunurrangu turlpanyajanaku palajunngarra Joseph-ju purlpi wurrarnajanaku. Warrarnja warinyjarrangu marrngurrangu janparr karrinyikinyiyi, mayimajirringa. Marrngurrangu Egypt-ja mayi kalkurnikinyiyi ngarrany. ");
INSERT INTO nna_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Yarti marrngurrangulu Egypt-ja wiyirr jirniyi mayi janamili. Palajalu yanayalu kingiku, wurrarniyili, “Mayi yuwanganinya!” Paliny muwarr pirnijanaku, “Yarrayalu Joseph-karti. Palinyju wurralkulinyurraku ngani jinaku. Pinakarriyalu.” ");
INSERT INTO nna_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Marrngurrangu wiyirrja warrarnja janparr karrinyikinyiyi. Palaja Joseph-ju wirturranguja mayarranguja mayi Manassehninyi, warnkuku mayi yinganyikinyijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Marrngukarra turlpanyiyi warinyja warrarnjarrangu, jana milpanyikinyiyalu Joseph-ku mayiku maninyaku warnkujartinyju. Marrngurrangu warinyjarrangu warinyjarrangu warrarnja turlpanyiyi Egypt-karti janparr karrinyija, mayiku maninyaku. ");
INSERT INTO nna_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","2","Palanga Joseph-mili japartu Jacob palangangarra waninyikinyi palinymilinga warrarnja. Palanga waninyikinyiyi janparr. Warinyju wurrarnala Jacob-ja, “Mayi kalkurnayi Egypt-ja.” Muwarr pirnijanaku palinymilaku partanykarranguku, “Nganiwanti waninyurru nyungungu? Pinakarrinyirni mayi kalkurnayi Egypt-ja. Yarrayi palakarti, mayi marrayinganyjurruka wanka nyungu waninyaku. Munujalu wurrjiliminyi wiyirr.” ");
INSERT INTO nna_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Japartumilijalu muwarrjalu 10 mamajirrangu Joseph-mili yanayi kurilakarti Egypt-karti. ");
INSERT INTO nna_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Joseph-mili marrkamarniny waninyi ngurranga. Palinymili japartu wirnti karrinyikinyalu, palinyju kurlkarri marnikinyi, “Marrkamarniny marlkarri jarriyili Egypt-ja.” Palajunjalu munu ngakarnama warinyjarrangu palinymilirrangunga partanykarrangunga. ");
INSERT INTO nna_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Palajunjalu Jacob-mili partanykarrangu pirirrimarta kajarniyi Egypt-ja maninyaku mayi. Jinta warinyirrangupa turlpanyiyi palakarti mayiku maninyaku. ");
INSERT INTO nna_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","8","Palanga Joseph nyampali waninyikinyi marrngumilaku warrarnku Egypt-ja. Palinykungarra yaninyikinyiyalu wiyirr mayiku maninyaku. Joseph-mili mamajirrangu turlpanyiyalu mayiku maninyaku palinyjaku, wupurniyalu palinyku. Janalu ngawu marnayi janamili marrka. Palinyju jurtulu yirrirnijaninyi mamajirrangu palinymili. Muwarr pirnijanaku ngawu kanyjil-kanyjil, “Wanyjarnija nyurra milpanyanyurru?!” Wurrarniyili, “Nganarna milpanyiyirni Canaan-ja mayiku maninyaku.” ");
INSERT INTO nna_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kurlkarri marnajaninyi kapukarri, purlpija palinymilirrangu mamajirrangu wupirniyalu. “Mitu marnanyinyurru! Yija-yiji milpanyanyurru nyunguku warrarnku kanganyaku nganarnamilaku Egypt-ku.” Palajunjalu kuli muwarr pinajanaku. ");
INSERT INTO nna_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Munu, Nyampali! Nganarna munu milpanyamayirni yirrinaku warrarnku, milpanyiyirni mayiku maninyaku. ");
INSERT INTO nna_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nganarna partanykarrangu warajamilija japartuja, nganarna munu mitukata. Nganarna munu turlpanyimayirni nyungukarti warrarnku maninyaku, nganarnamili jinaku.” ");
INSERT INTO nna_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Warinymil wurrarnajanaku, “Nyurra turlpanyinyurru warrarn yirrinaku, warrarnku kanganyaku nganarnaja.” ");
INSERT INTO nna_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","“Nganarna partanykarrangu warajamilija pirirrija. Japartu nganarnamili 12 pirirrimartajartiny partanykarrangujartiny. Nyirtingunyamarniny kalkurna japartulu nganarnamilalu Canaan-ja. Wariny marrkamarniny marlkarri.” Palajunjalu wurrarniyili. ");
INSERT INTO nna_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Warinymalja muwarr pirnijanaku, “Nyurra turlpanyinyurru warrarn yirrinaku, warrarnku kanganyaku nganarnaja. ");
INSERT INTO nna_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Yakurr malamarnanyurrinyi. Kawayi ngajukarti nyurramili marrkamarniny. Munujalu munu kulpa malamarnanyurrinyi walarni jarrinyaku nyurramilikarti warrarnkarti. Pala muwarr yija. Wirrilamarnanyurrinyi jurntinga yakurr manaku. ");
INSERT INTO nna_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nyurralu waraja ngakalkulinyurru nyurramilikarti warrarnkarti, palalu warajalu walarni jilkuliny nyurramili marrka. Jinta wiyirr wantulinyurru nyungu jurntinga. Palajunjalu yakurr malamarnanyurraku muwarr nyurramili. Yijapa nyurramili marrka walarni jarruliny ngajukarti. Palajalu palaja muwarrja ngajulu yijal malamarnanyurraku. Munujalu ngajulu mitu yakalamarnanyurrinyi, yija-yiji turlpanyinyurru warrarnku yirrinaku.” ");
INSERT INTO nna_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Palajunjalu muwarrjalu palinymili mamajirrangu jurntingi wirrirnijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Kujarrajalu karrpujalu Joseph yana jurntikarti, wurrarnajanaku, “Ngarrkaku yijalmarta jirninyalu. Ngajulu wurralamarnanyurraku ngani jilkulinyurru. Yijalu pinakarraji, yijapa pinakarrulinyurruji wankanyu wantulinyurru, ngajulu munu wirlalamarnanyurrinyi marlkarri. ");
INSERT INTO nna_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","20","Ngajulu kalkulumarna waraja jurntinga. Wiyirr walarni jarrulinyurrujanaku nyurramilikarti ngurrakarti. Palaja walarni jarrulinyurru nyungukarti nyurramilijartiny marrkajartiny. Palajalu wurrarnajinyurru yija muwarr. Munu marlkarri wirlalamarnanyurrinyi.” Palajunjalu Joseph-ju muwarr pirnijanaku. “Yuu! Palajun jilipiyirni.” ");
INSERT INTO nna_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Palaja muwarr pirnikinyiyi janamili muwarr. “Yijalu kurlu jirninyalu nganyjurrumilaku marrkaku. Munu tuku jinamanyi, yinyanyijanaku nganyjurrumili marrka wala nyungu warnkuku maninyaku. Wirrilyijartinyju ngarlu japirr marnikinyinganinyi, 'Munu yingkuluminyinyurru jananga!' Munu pinakarramayirnalu. Kuwarri yiji kurlu jarrinyi nganarnaka. Yija-yiji kurrparniyirnarninyi.” ");
INSERT INTO nna_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Murrkangunyalu, Rueben-ju, wurrarnajanaku marrkamarninyirrangungu, “Wurrarnarnanyurraku ngajulu munu palajun jinaku nganyjurrumilaku marrkaku. Munu pinakarrimajinyurru. Palajunjalu nganyjurrumili marrka marlkarri. Kuwarri Ngarrkalu yukuyil jirninganyjurrinyi!” ");
INSERT INTO nna_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Muwarr pirnijaku pinakarrinyikinyijanaku Joseph-ju. Jurtulu pinakarrinyikinyijaninyi, jana ngakumpa. Joseph-ju muwarr pirnikinyijanaku wariny muwarr Egypt-mili, warinyju muwarr jurtu jirnikinyi jananga. Jana ngakumpa Joseph miranu janaku muwarrmilaku. ");
INSERT INTO nna_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Palaja pinakarrinyaja mamajirrangurranguku muwarrku Joseph-ju yana kuku jarrinyaku ngangkurli jinaku. Palaja kulpanyajanaku, palinyju muwarr pirnikinyijanaku mamajirranguku. Palinyju kunyji pirni Simeon, miranga jananga. Wurrarnajanaku wiyirrja palinymili mamajirrangunga, “Nyurra yarrayi mayijartiny ngurrakarti nyurramilikarti.” ");
INSERT INTO nna_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Wurrarnala warajanga palinymilinga warrkamu puluku, “Marrajanaka mayi nyungukurrangu, kangkulupiyi janamilikarti warrarnkarti. Winya jilijanaka kurtan. Warnkujalu maninyijalu wirrilijanaku warnku janamilirrangunga kurtanjirrangunga. Wariny yuwajanaka kurtan mayijartiny kangkulupiyi ngananyaku janamilikartiku warrarnkartiku.” Palajalu palinymilalu warrkamu pulukulu jirni Joseph-jalu muwarrjalu. ");
INSERT INTO nna_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Palajalu mamajirrangulu mayi kurtanarrangu wirrirniyi jananga tangkingi. Jipi marnti yanayi, kulpanyayi janamilikarti warrarnkarti. ");
INSERT INTO nna_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Warajanga warrukartingi karta karrinyiyi partijirringa. Warajalu pirli jirni palinymili kurtan, maninyaku mayiku palinymilaku tangkiku. Palinyju yirrirni palinymili warnku kankakartingi mayingi. ");
INSERT INTO nna_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Palinyju kamarnajanaku warinyarranguku, “Nyungu yirriliyi! Ngajumili warnku! Jintalu wirrirni kurtanja, kankakarti mayinga.” Pinakarrinyiyi pala muwarr, palalu muwarrju wirntiji pirnijaninyi yiji. Jana jankanka pirnikinyiyi yiji. Muwarr pirniyirnangu wirntilu, “Ngani jirninganyjurrinyi Ngarrkalu?” ");
INSERT INTO nna_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Palaja kulpanyayi janamili japartukarti, warrarnja Canaan-ja. Yimpirniyili wiyirr nganirrangu jinajalu. ");
INSERT INTO nna_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Maajalu Egypt-jalu muwarr pirni nganarnaku kulilu. ‘Nyurra turlpanyinyurru warrarn yirrinaku nyurramili jinaku!’ ");
INSERT INTO nna_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","‘Munu nganarna palajun jinaku milpanyiyirni. Nganarna yijakata, munu mitukata. Munu turlpanyamayirni yirrinaku warrarnku. ");
INSERT INTO nna_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nganarna pujamu warajamilaku japartuku. Palinyju Manassehninyi 12 partanykarrangu pirirrimarta. Waraja marlkarri, nyirtingunyamarniny kalkurna japartulu nganarnamilalu Canaan-ja.’ ");
INSERT INTO nna_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Palalu pirirrilu nyampalilu wurrarna nganarnaku, ‘Yakurr malamarnanyurrinyi! Nyurralu yakalkulinyurru waraja marrngu, nyungunga ngaliya wantulupalayi. Wiyirr nyurra kulpulinyurru nyurramilikarti warrarnkarti mayijartiny nyurramilakurrangu. ");
INSERT INTO nna_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Palajalu walarni jilkulinyurru ngajukarti nyurramili nyirtingunya. Palaja jirnijalu ngajulu wurralamarnanyurrinya yijakata, munu turlpanyimanyurru warrarnku kanganyaku. Ngajulu yala jilamarna nyurramili walja jurntija. Palajalu mankulinyurru mayirrangu, ngajulu munu ngampa pilamarnanyurrinyi.’ Palajun muwarr pirni nganarnaku.” ");
INSERT INTO nna_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Palaja yanayi yatinaku kurtanku mayiku yirrinaku, palanga kankakarti mayinga warnku janamili yirrirniyi! Warnkulu yirrinajalu jana japartupa janamili wirnti karrinyiyi yiji. ");
INSERT INTO nna_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","“Nganiwanti jirninyurru palajun? Kanyanyurrupulinyi ngajumili pujamujirri. Simeon-majirripa Joseph-majirri waninyirni. Yijalmarta karrinyinyurru kanganyaku Benjamin-ku. Nyurralu kuli jirnijinyurra.” Palajun muwarr pirnijanaku Jacob-ju. ");
INSERT INTO nna_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Mirtamarninyju, Rueben-ju, muwarr pinalu japartuku, “Japartu, ngajulu walarni jilamarnanga nyirtingunya. Munujalu, nyuntulu wirlalamanpulinyi ngajumilijirri partanyjirri marlkarri. Ngajulu tuku jilamarnanga nyirtingunya, tukulu walarni jilamarnanga.” ");
INSERT INTO nna_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","“Munu palajunku! Nyirtingunyamarniny munu yankuliny Egypt-karti! Marlkarri jarriyili partijirri kaniny. Paliny marlkarri jarruliny, ngajupa marlkarri jarrulumarna! Ngaju jipi mirta jarrinyirni. Marlkarri jarrulumarna pajujartiny!” ");
INSERT INTO nna_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Warrarnja waninyi Canaan-ja ngapa munu ngarrany pungkamajanaku. Mayi wupartu yiji wirtu jarrinyijanaka. ");
INSERT INTO nna_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jacob-jupa palinymilalu partanykarrangulu jipi mayi nganayi, pala mayi manayi Egypt-ja. Japartu muwarr pirnijanaku, “Yarrayi Egypt-karti yarrana, mayi marrayinganyjurruka.” ");
INSERT INTO nna_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Judah-lu muwarr pinalu, “Palalu pirirrilu wurrarna nganarnaku yiji, ‘Nyarnikurnu kawayi nyurramili nyirti ngajukarti. Munujalu ngajulu munu muwarr pilamarnanyurraku, munu mayi yingkulumarnanyurrinya.’ ");
INSERT INTO nna_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ngakala pala nyirtingunyapa, palaja yankulupiyirni Egypt-karti mayiku maninyaku nganyjurruku wiyirrku. ");
INSERT INTO nna_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Munu ngarrany yankulupiyirni nyirtingunyamajirri. Palalu nyampalilu Egypt-jalu wurrarna nganarnaku, ‘Nyarni kawayi nyirtingunya. Palaja muwarr pilamarnanyurraku’.” ");
INSERT INTO nna_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jacob-ju warnta marnajaninyi, “Nganiwanti wurrarnanyurralu nyurra marrkajartiny? Kurlu jinajinyurra!” ");
INSERT INTO nna_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Karra marnayalu, “Japirr marnanganinya, ‘Japartu nyurramili wankanyu ngarrany? Wayirti, warinypa kalkurnanyurru marrkapa mamaji?’ Purulu yija muwarr wurrarniyirnili. Nganarna munumparla palinyja, ‘Kangkulunyurru nyungukarti nyurramili nyirtingunya’.” Palajun muwarr pirniyalu janamilaku japartuku. ");
INSERT INTO nna_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah-lu muwarr pinalu japartumarninyku, “Ngajulu tuku jilamarna nyirtingunya. Ngajulu kangkulumarna. Nyampa yankulupiyirni mayiku maninyaku. Palajunja jinajalu wankanyu wantulaminyi wiyirr, munu marlkarri jarrinyaku, nyuntupa nganarnapa nganarnamili partanykarrangu. ");
INSERT INTO nna_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ngajulu tuku jilamarna nyirtingunya, ngajulu walarni jilamarnanga tukulu. Munujalu ngaju nyanyji jilamanyin ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Yanamayirni purlpi ngarrany. Jipijalu walarni jarrimayirni kujarramal.” ");
INSERT INTO nna_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Japartumurninyju wurrarnajanaku, “Yuu! Jipi kawayi nyirtingunya. Ngajulu munu ngampa pilamarnanyurrinyi. Kawayalu mayi palarrangu ngalyparrangu nyunguja warrarnja nyampaliku Egypt-ku: jutipirri, minta ngalypa parntinyakata, mayiku jurikata jinakata (spices), warinypa warinypa mayi jurikata (pistachio nuts and almonds).” ");
INSERT INTO nna_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Warnku nyarra wirrirniyi nyurramilinga kurtanja kulpa jiliyijanaku. Ngurnipali wirrirniyi watarrkulu. Kawayi yarrana warnku mayiku maninyaku. ");
INSERT INTO nna_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kawayi nyirtingunya nyurramili marrka, yarrayi yarrana yirrinaku nyarraku pirirriku. ");
INSERT INTO nna_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ngarrka wirtu yiji. Ngajulu japirr marnarna paju karri nganarnaku, paju karrinyajalu ngakalkulinypulinyi ngajumilijirri partanyjirri, Simeon-pa Benjamin. Yijapa munu ngakalkulinypulinyi, ngaju wantulumarna partanymajirrijirri ngarrakuny.” Palajunju muwarr pirnijanaku palinymilaku partanykarranguku. ");
INSERT INTO nna_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Jacob-milalu partanykarrangulu pirirrimartalu wirrirniyi jinyjipintipa warnkupa kurtanji. Wirrirniyi warnku wata manayi purlpilu, warinyarrangu warnkurrangu yarrana manayi, maninyaku mayiku janaku. Palaja yanayi kanyayi janamilipa marrka, Benjamin. Egypt-karti pipurr yanayi. Egypt-ja kajanaja yanayalu muwarr pinaku Joseph-ku. ");
INSERT INTO nna_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joseph-ju yirrirni marrkamarniny palinymili warinyjarrangungu. Kamarnalu palinymilaku warrkamukataku nyampaliku mayakataku. “Kawajaninyi nyungurrangu marrngurrangu ngajumilikarti mayakarti. Wirlala kuwiyi, kampala nganarnaka. Nyungurrangulu pirirrmartalu mayi ngalkulupiyirni ngajumilinga mayanga karrpunga kankajalu yiji.” ");
INSERT INTO nna_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Palaja warrkamuku nyampalilu kanyajaninyi Joseph-milikarti mayakarti Joseph-milalu muwarrjalu. ");
INSERT INTO nna_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yananyajalu mayakartilu Joseph-mili mamajirrangu wirnti karrinyiyi. Kurlkarri marnikinyiyi, “Wirrilyi jarrinyi warnku nyarra yirrirninyi kurtanjarrangu purlpi. Palajalu ngakarnanganyjurrinyi palinymilikarti mayakarti. Yijalupa warlilinganyjurrinyili, yijalu jilinganyjurrinyili warrkamuku jinaku palinyku ngarrakuny. Yijalupa kawajaninyili nganyjurruka tangki.” Palajunju kurlkarri marnikinyiyarninyi. ");
INSERT INTO nna_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mayanga milyanga jarrinyaja wirntijartinyju muwarr pirniyalu palaku nyampaliku. ");
INSERT INTO nna_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Janalu muwarr pirniyalu, “Nyampalikayi, milpanyiyirni nyungukarti purlpinga mayiku maninyaku. ");
INSERT INTO nna_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Nganarna warlirni jarrinyikinyiyirni nganarnamilikarti warrarnkarti. Yutakartanga waninyiyirni partijirri, yatirniyirni nganarnamili mayipinti kurtanarrangu. Yirrirniyirni nganarnamili warnkurrangu nganarnamilingi kurtanja kankakarti mayinga, warnkurrangu wiyirr waninyikinyi kurtanja! Nganarna ngakumparla nganurtulu warnku wirrirni nganarnamilinga kurtanja. Nganarnalu warlarnikinyiyirninga wiyirr. Nganarnalu wariny warnku kanyayirni maninyaku mayiku nganarnaku.” ");
INSERT INTO nna_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Puntaju karra marnajanaku, “Wirntiwayilu puru. Purlpilu warnku yinyanyinyurru. Nyurralupa nyurramilalu japartulu yijalmarta jirninyurrulu Ngarrkanga. Yijapa palinyju wirrirni warnku nyurramilingi kurtanjirrangu.” Palaja palinyju kanyajanaku Simeon. ");
INSERT INTO nna_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Palaja kanyajaninyi wiyirr kaninykarti Joseph-milinga mayanga, yinyajaninyi ngapa jinaku janpa jinaku. Mayi pukun yinyajaninya tangkikurrangu. ");
INSERT INTO nna_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wurrarnajanaku, “Nyurralu mayi ngalkulunyurru nyungungu kuwarri.” Palanga manayijaninyi wurrukarrangu yinganyaku Joseph-ku kulpanyajalu. ");
INSERT INTO nna_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Joseph walarni jarrinyajalu mayakarti, palinymilalu mamajirrangulu yinyayili jinyjipinti wurrukarrangu palinyku, jana wupirniyalu jinangu palinyja. ");
INSERT INTO nna_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","“Wayirti, ngalypa waninyurru? Japartu nyurramili, wankanyungarra waninyi? Ngalypa waninyi?” ");
INSERT INTO nna_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Yuu, wankanyungarra waninyi.” Palajalu warinymil wupirniyalu. ");
INSERT INTO nna_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Parrjana yirrirni palinymili marrka, Benjamin, pipimarniny partanyjirrimili walja. “Nyungungarra nyirtingunya, wurrarnijinyurru?” “Yuu.” Wurrarnala Benjamin-ja, “Ngarrka paju karruliny nyuntuku.” ");
INSERT INTO nna_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Palaja Joseph yana nyampa jurntikarti palinymilikarti, manyjarrajalu nyirtingunyaku ngangkurl jirnikinyalu. ");
INSERT INTO nna_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ngumpa janpa jinanyarninyi, kulpanyajanaku. Wurrarnajanaku warrkamukataku palinymilaku, “Mayi kawayi nganarnaku!” ");
INSERT INTO nna_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","33","Purlpilu Joseph-milalu warrkamu pulukurrangulu kajana jirnijaninyi mamajirrangu Joseph-milirrangu, murrkangunya wirrirniyi walangkarrkarti, nyirtingunya warinykartingi, wiyirr partijirringi wirrirnayijaninyi. Kajana jirnijaninyi, murrkangunya walangkarr, malyartarrangu, nyirtingunya nyirrirnikarti, Palajunngarra. Pirirrimarta parrjarnikinyarninyi. “Yukuyilpirla ngayarta jarrinyinyi!” Yija yiji ngawu karrinyikinyiyi. Palanga warajanga ngananyikinyiyi, Joseph-pa mamajirrangu palinymilipa Egypt-jarrangupa. Joseph kajarna warajanga table-ja. Palinymili mamajirrangupa nyirtingunyapa warinyja table-ja kajarnikinyiyi. Warinyarrangu kajarnikinyiyi warinyja table-ja, kajamarta kajarnikinyiyi. Egypt-arrangulu munukata kajanakata warajanga Hebrew marrngunga. ");
INSERT INTO nna_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Joseph-ju ngakarnajanaka jinta mayi palinymilija table-ja. Ngakarnalu wirtu yiji palinymilaku marrkaku, Benjaminku. Palanga nganayipa minpirnayipa Joseph-ja, pikaly jarrinyiyi wiyirr. ");
INSERT INTO nna_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yartingi Joseph-ju wurrarnala nyampalingi warrkamukatanga, “Winya jirnijaninyi kurtan mayijartinyju janamili. Warnkurrangu janamili wirrilijanaka kankakarti mayirrangunga. ");
INSERT INTO nna_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kurtanja nyirtingunyamilinga wirrili nyungu ngajumili ngalypakata yiji minpinapinti. Wirrili pala minpinapintipa warnkupa palinymilinga kurtanja.” Palajun wurranala. Palinyju yijalu jirni Joseph-jalu muwarrjalu. ");
INSERT INTO nna_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Pirrpa-pirrpanga mamajirrangupa nyirtingunya yananyayi tangkijartiny janamilikarti ngurra waljakarti. ");
INSERT INTO nna_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Jampa yanayi wangkangarra. Joseph-ju wurrarnala warrkamukatanga, “Yarrajanaku! Purrja pilijaninyi. Wurralajanaku, ‘Ngajumili nyampali ngalypalu kalkurnakinyinyurrinyi. Puntajulu kurlu jirninyurrulu! Nganiwanti minyji marnanyurralu ngalypakata yiji minpinapinti palinymili? ");
INSERT INTO nna_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Palamangarra minpinapinti palinymili minpirni karrpurrangu karrpurrangu. Palamajartinyju minpinapintilu maparn jirnijaninyi pukurl. Nyurralu minyji marnanyurralu. Kurlu yiji jirninyurralu!’ Wurralajanaku palajun muwarr.” ");
INSERT INTO nna_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Palinymilalu warrkamukatalu yajarnajaninyi. Yirrinajalu wurrarnajanaku Joseph-milaja muwarrja. ");
INSERT INTO nna_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Puntajulu, “Nyampali yija, munu palajun muwarr pinaku! Munu palajun jinamayirni. Nganarna munu minyji manakatarrangu. ");
INSERT INTO nna_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Pala warnku yirrirniyirni purlpilu kurtanja nganarnamilinga walarni jirniyirningu nyuntunga Canaan-ja. Nganiku palajun muwarr pinanpa, wurrarnannganinya minyji Manasseh nyuntumilimili nyampalimili minpinapinti palinymilija mayaja? ");
INSERT INTO nna_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kanyjilimanpa palaku minpinapintiku nganarnamilinga kurtanja. Yijapa yirrilaman nganurtumilingi kurtanja, pala marrngu wirlalaman marlkarri. Wiyirr nganarna wantulupiyirni nyungunga, warnku mananyamajirri warrkamu jarrulupiyirni nyuntuku.” ");
INSERT INTO nna_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Puntajulu, “Yuu, yijapa yirrilamarna minpinapinti palamilinga kurtanja, pala waraja marrngu kalkulumarna. Wiyirr nyurra kulpulinyurru nyurramilikarti warrarnkarti.” Palajun muwarr pirnijanaku Joseph-milaku mamajirranguku. ");
INSERT INTO nna_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Yinyji pirniyi nyampalu kurtanarrangu tangkija, jungkanga wirrirniyi, jawa pirli jirniyijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Joseph-milalu warrkamukatalu kanyjirnikinyalu pala minpinapintiku warinypa warinypa kurtanarrangunga. Walangkarranga kanyjirnalu murrkamilinga, palaja malyurtarrangumilingi, nyirrirnikarti kanyjirnalu nyirtingunyamilingi. Pala minpinapinti waninykinyi nyirtingunyamilingi, Benjamin-milinga. ");
INSERT INTO nna_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Wirrilyi karrinyiyi, wurrurrangu kawuja ngartarn-ngartarniyi pajulu yiji-yijalu. ");
INSERT INTO nna_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judah-pa jintapa walarni jarrinyiyi mayakarti Joseph-milikarti. Palangangarra waninyikinyi. Wupirniyalu jungkakarti yiji. ");
INSERT INTO nna_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Paliny muwarr pirnijanaku, “Nganiwanti kurlujartiny jinajinyurru? Ngaju miranu nyurraku. Ngaju miranurla maparn jinaku. Nyurra miranurla ngajuku wanimanyurru.” ");
INSERT INTO nna_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah-lu, “Munu nganarna jurtu muwarrmajirri. Ngarrka miranu nganarnalu kurlu jirniyirni! Warnku maninyamajirri warrkamu jarrulupiyirni nyuntuku, warinyju nyarra kalkurnikinyi minpinapintipa nganarna jinta.” Palajunju muwarr pinalu Judah-lu. ");
INSERT INTO nna_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Joseph-ju karra marnajanaku, “Munu palajun jilamarna. Pala waraja marrngu minpinapintijartiny kalkulumarna nyungu. Nyungu waraja warrkamu jarrulupija. Wiyirr nyurra kulpulinyurru nyurramilikarti japartukarti.” ");
INSERT INTO nna_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Wangka jarrinyalu Judah, karra marnalu, “Nyampali, wirtu nyuntu, nyuntu kingikapali. Munu wirrilyi jarrulupijin, puru muwarr pilamarnangu. ");
INSERT INTO nna_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Purlpilu japirr marnannganinyi, ‘Yija japartu nyurramili wankanyu ngarrany, wayirti kalkurnanyurru warinypa marrkamarniny?’ ");
INSERT INTO nna_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Wurrarnayirnangu purlpilu, “Yuu, nganarnamili japartu wankanyu ngarrany, waraja marrka nganarnamili ngayarta jarrinyi paliny nganarnamilinga japartunga mirtanga yija. Nyirtingunyamili walja yija mamaji marlkarri. Nyungujakun wankanyu palaja pipija, nganarnamilalu japartulu ngarluja yiji palinymili pala. ");
INSERT INTO nna_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nyuntulu wurrarnan nganarnaku, ‘Ngajulu yirrilimarna nyurramili nyirtingunya marrkamarniny. Kawayi ngajukarti.’ ");
INSERT INTO nna_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Palinyju munu yakalkulinypa nganarnamili japartu. Marlkarri jarriyili nganarnamili japartu. ");
INSERT INTO nna_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","‘Wurraliyili nyurramilinga marrkanga nyungukarti milpuliny ngajuku yirrinaku. Munujalu milpanyajalu ngajulu ngampa pilamarnanyurrinyi nyungukarti milpanyaja ngarrakuny.’ Palajun wurrarnan nganarnaka. ");
INSERT INTO nna_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Palaja kulpanyajalu wurrarniyirnili japartungu nyuntuja muwarr. ");
INSERT INTO nna_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Yarti nganarnalu japartulu wurrarna nganarnaku, ‘Kurlpayi yarrana Egypt-karti, mayi marrayi yarrana!’ ");
INSERT INTO nna_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","‘Nganarna munu palakarti yaninyaku. Palalu pirirrilu wurrarna nganarnaku yananyaku palakarti kangkulupiyirni nganarnamili marrka nyirtingunya. Munu kanganyajalu nyirtingunyaku palalu pirirrilu munu muwarr pilkuliny nganarnaku. Nyuntulu ngakalaman nyirtingunya pukun, palaja yankulupiyirni.’ ");
INSERT INTO nna_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","‘Ngajumili mirtawa Rayijil kujarra murtunyajirrijakun kanyapulinyi. Nyurra miranu palaku. ");
INSERT INTO nna_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Waraja partany yana ngarrakuny, ngaju ngawu kanyjil-kanyjil. Yijapa marlkarri, kulikatalu kuwiyilu nganayi ngurnipali. ");
INSERT INTO nna_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kuwarri karrinyinyurru kanganyaku nyirtingunyaku. Palinypa marlkarri jarriyili. Palaja ngajupa wurrjularnala paju karrinyija.’ Palajunju wurrarna nganarnalu japartulu. ");
INSERT INTO nna_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Munu kulpanyaku nganarnamilikarti japartukarti nyirtingunyamajirri. Palajun jilipiyirni, nganarnamili japartu marlkarri jarriyili paju karrinyajalu. ");
INSERT INTO nna_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Marntikartilu nyungukartiku wurrarnarnala japartungu, ‘Ngajulu tuku jilamarna nyirtingunya, walarni jilamarna nyuntukarti. Munujalu ngaju nyanyji jilamanyan ngarrakuny.’ ");
INSERT INTO nna_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","34","Pinakarraji, nyampali. Ngaju munu karrinyirna ngajumilaku japartuku marlkarri jarriyilipa. Ngaju munu karrinyirna walarni jarrinyaku nyirtingunyamajirri. Ngaju wantulumarnanga, warrkamu jilamarnanga kakuputulu. Yijapa ngakalaman nyirtingunya nganarnamilikarti japartukarti.” Palajun muwarr pinalu Joseph-ku. ");
INSERT INTO nna_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph-ju pinakarrinyikinyalu palinymilaku mamajiku. Palaja partarl jama karrinyikinyi. “Jinta nyurra warrkamukatarrangu yarrayi jurntija.” Palarrangujakun yiji waninyiyi kaninykurti jurntinga mamajirrangupa nyirtingunya. Warrkamukatarranu Egypt-jirrirrangu yanayi. ");
INSERT INTO nna_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Joseph ngangkurl jirnikinyi marrja. Marrngulu pinakarrinyiyi kajangulu, warinyju wurrarnajanaku marrngurrangunga kingimilinga mayanga, “Joseph ngangkurlu jirnikinyi marrja.” ");
INSERT INTO nna_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph-ju wurrarnajanaku mamajirrangunga, “Ngajungarra Joseph. Yija yiji japartu nganyjurramili wankanyu waninyi?” Pala muwarr pinakarrinyiyi yija yiji wirnti karrinyiyi. Munu puntaju muwarr pinamayalu. Jama waninyiyi. ");
INSERT INTO nna_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","“Kurtaliyi wangka ngajukarti!” Milpanyiyi palinykarti. “Ngajungarra nyurramili marrka, Joseph. Nyurralu yinyalpirninyurru jananga ngajarrirrangunga warnkuku. Janalu kanyanyiyi nyungukarti. ");
INSERT INTO nna_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Munu wirrilyi jarrinyaku nyurra, munu kulilu yirrilkulinyurrarninyi. Ngarrkalungarra nyungukarti ngakarnanyi, kalkunaku nyurraku wankanyu. ");
INSERT INTO nna_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Punja waninyiyirni ngapa munu pungkama kujarra partunujirringi. 5 partunurrangu turlpulupiyinganyjurruka ngapa wupartu pungkuliny nganyjurraku, mayirrangu munu jarruliny nganyjurruka. ");
INSERT INTO nna_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Palajalu Ngarrkalu ngakarninyi walangkarrangu nyurranga. Ngakarninyi nyungukarti nyurraku kalkunaku wankanyuku, partanykarranguku nyurramilaku pukun. ");
INSERT INTO nna_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Munu nyurralu ngakarnamanyinyurru nyungukarti, Ngarrkalu ngakarninyi. Ngaju wirrirninyi nyampali wiyirrku warrkumukatarranguku kingimilinga mayanga, wirrirninyi nyampali wiyirrku marrngurranguku nyungungu warrarnja, Egypt-ja. ");
INSERT INTO nna_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Yarrayi japartukarti janyin, wurraliyili nyungu muwarr. ‘Yija ngaju, nyuntumili partany, Joseph, wankanyungarra waninyirni. Ngarrkalu ngaju wirrirninyi nyampali wiyirrku marrngku warrarnja Egypt-ja. Kurtaliji nyungukarti warrarnkarti. ");
INSERT INTO nna_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nyuntu wantuluman ngajungu wangka nyungunga, Gothen-ja, nyuntupa partanykarrangu nyuntumilipa karluji jamuji, kaparlijipa kamiji. Kawayijaninyi kukurnjayipa nanikutupa purlimanarrangupa wurrukarra pukun. ");
INSERT INTO nna_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ngajulu tuku jilamarnanta. 5 partunurrangu turlpulupiyinganyjurruka ngapa wupartu pungkuliny nganyjurraku. Nyungunga Gothen-ja tuku jilamarnanyurrinyi wiyirr, mayijartiny wirtujartiny wantulinyurru.’ Pala muwarr wurralala. ");
INSERT INTO nna_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Nyurralu wiyirrju yirrilinyiyi, ngaju yiji nyungu, Joseph muwarr pirnirninyurraku. ");
INSERT INTO nna_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Wurraliyili japartunga ngaju nyampali yiji Egypt-ja. Wurraliyili yirrirninyurru wiyirr nyungunga. Palaja nyungukarti kawayi janyin!” Palajunju wurrarnajanaku Joseph-ju. ");
INSERT INTO nna_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ngamparna marrka, ngangkurlu jirnipularninyi. ");
INSERT INTO nna_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ngamparnajaninyi mamajirrangu, ngangkurlu jirniyi warajanga, palaja kurrngarniyi warajanga. ");
INSERT INTO nna_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kingilu pinakarrinyi, “Joseph-mili mamajirrangu kajarniyi.” Kingipa palinymili warrkamu pulukurrangu pikaly jarrinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kingilu wurrarnala Joseph-ku, “Wurralajanaku nyuntumilirrangu mamajirrangungu kurtanjarrangu mayijartiny wirrilipiyi janamilingi tangkingi, kulpulupiyi janamilikarti warrarnkarti waljakarti. ");
INSERT INTO nna_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Mankulupiyi janamili japartupa palinymilirrangupa, nyarnikurnu turlpulkulinyurru ngajukarti. Warrarn ngajulu yingkulumarnajanaku, warrarn ngalypakata. Marlu mayi ngalypakata ngalkulupiyi. ");
INSERT INTO nna_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Wurrala jinaku mamajirrangunga kangkulupiyi wagon-arrangu maninyaku pipirrangupa partanykarrangupa japartumurniny nyuntumilipa. Milpulupiyi nyarnikurnu wiyirr. ");
INSERT INTO nna_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wurralajanaku janamilirrangu wurrukarra, yakalapiyijaninyi palarrangu wurrurrangu janamilinga warrarnja. Ngajulu yingkulumurnujanaku nyungungu palarrangu wurrukarra, yija yiji ngalypakatarrangu.” Palajun wurrarnala Joseph. ");
INSERT INTO nna_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Palajalu Joseph-ju yinyajaninyi wagon-arrangu kingija muwarrja. Palajalu yinyajaninyi mayi ngananyaku marntiku. ");
INSERT INTO nna_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Parrpakarrarrangu wurrukarra yinyajanaku, ngalypakatarrangu. Marrkamarninyku yinyalu wurrukarra parrpakarrarrangu marlu, warnku wirtu pukul. ");
INSERT INTO nna_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Japartumurninyku yinyajanaku 10 tangki wurrukatajakunarrangu kanganyaku, 10 tangki kanganyaku mayirrangujakun, japartumurninyju ngalkuliny marntiku. ");
INSERT INTO nna_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","“Jipi yarrayi! Munu kurlipatilkuliny nyurru marntijalu.” ");
INSERT INTO nna_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kulpanyiyi Egypt-ja janamilikarti warrarnkarti waljakarti. ");
INSERT INTO nna_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Palaja kajarniyi wurrarniyili janamilingi japartungu, “Joseph wankanyu ngarrany waninyi! Nyampali janaku wiyirrku Egypt-ja!” Jacob panypinyijananga, ngakumpa karrinyi. ");
INSERT INTO nna_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Wurrarniyili muwarrarrangu Joseph-ja. Jurti jirniyili wagon-arrangu Joseph-ja ngakanaja. Palaja Jacob pikaly jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Wurrarnajanaku, “Yijalmarta jirnirni nyurranga yija. Ngajumili partany Joseph wankanyu ngarrany. Yankulumarnalu yirrinaku ngajumilaku partanyku Joseph-ku wankanyulu ngarrany!” ");
INSERT INTO nna_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Palaja Jacob-ju warajanga jirnijaninyi palinymilirrangu kuwiyirrangu, yana kurilakurti ngapikarti, Beersheba-karti. Palanga kuwiyi wirlarna, Ngarrkaku muwarr pinalu, wangkalu yiji muwarr pinangulu “Ngarlu ngalypa jirninyi!” Isaac-ju palinymilalu japartulu muwarr pirnikinyalu palajunngarra Ngarrkaku purlpilu. ");
INSERT INTO nna_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ngarrkalu kamarnalu kapukarri Manassehku, “Jacob! Jacob!” “Yu! Ngani?” ");
INSERT INTO nna_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","4","“Nyungu ngaju, Ngarrka, muwarr pirnirnangu. Nyuntumilalu japartulu yijalmarta jirnikinyiji, ngajulu tuku jirnikinyirni. Ngaju pukurl yankulumarna Egypt-karti, tuku jilamarnanta nyuntupa. Munu wirnti karrinyaku palakarti yananyaku. Marlu karlujirrangupa jamujirrangu yingkulumarnanta palanga. Nyuntungu marlkarri jarrinyajalu Joseph palanga wantuliny nyuntumartaji. Yarti punjajalu yiji nyuntumilirrangu walarni jilamarnajaninyi nyuntumilikarti warrarnkarti.” Palajun muwarr pinalu Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Palaja Jacob-ju yakarna Beersheba yananyaku Egypt-karti. Palinymilarrangulu partanykarrangulu wagon-ja wirrirniyijaninyi janamili japartumarninypa mirtawanyjarripa partanykarrangupa. Kanyayijaninyi wagon-ja, nyarrarrangu wagon-arrangu kingilu ngakarnajanaku. ");
INSERT INTO nna_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Janalu kanyayijaninyi kukurnjayipa purlimanpa wiyirr warinyarrangu kuwiyirrangupa, palaja warrarnja Canaan-ja wurrukarra kanyayijaninyi, wiyirr yanayi Egypt-karti. ");
INSERT INTO nna_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jacob Egypt-karti yananyaja palinymilirrangu wiyirr palinyja yanayi. Murrkangunya Rueben-pa ");
INSERT INTO nna_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","palinymili pirirri partanykarrangu: Hanoch, Pallu, Hezron, Carmi. ");
INSERT INTO nna_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon-pa palinymili pirirri partanykarrangu: Jemuel, Jamin, Ohad, Jachin, Zohar Shaul (partany Canaanite-ja mirtawaja). ");
INSERT INTO nna_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi-pa palinymili pirirri partanykarrangu: Gershon, Kohath, Merari. ");
INSERT INTO nna_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah-pa palinymili pirirri partanykarrangu: Shelah, Perez, Zerah. (Warinyjirri Judah-mili pirirri partanyjirri, Er-pa Onan, marlkarri jarrinyipulu Canaan-ja.) Perez-mili pirirri partanyjirri: Hezron-pa Hamul. ");
INSERT INTO nna_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issachar-pa palinymili pirirri partanykarrangu: Tola, Puah, Jashub, Shimron. ");
INSERT INTO nna_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun-pa palinymili pirirri partanykarrangu: Sered, Elon, Jahleel. ");
INSERT INTO nna_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nyungurrangu pirirri partanykarrangu ngayarta jirnijaninyi Leah-lu, Mesopotamia-nga, palinymili kurntal Dinah pukun. Jacob 33 nyirrirnikartijarrangujartiny Leah-ja. ");
INSERT INTO nna_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad-pa palinymili pirirri partanykarrangu: Zephon, Hagi, Shuni, Eri, Arod, Areli. ");
INSERT INTO nna_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher-pa palinymili pirirri partanykarrangu: Imnah, Ishvah, Ishvi, Beriah, janamili mirtawa partany pukun, Serah. ");
INSERT INTO nna_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Jacob nyungurrangu 16 nyirrirnikartijarrangujartiny Zilpah-ja. Jacob-mili kakaji Laban-ju yinyalu nyarra Zilpah, warrkamukata jarrinyaku paliny Leah-ku. ");
INSERT INTO nna_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacob-milalu mirtawalu Rachel-ju ngayarta jirnipulinyi kujarra pirirri partanyjirri, Joseph-pa Benjamin. ");
INSERT INTO nna_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Egypt-ja waninyaja Joseph pirirri partanyjartinyjirri, Manasseh-pa Ephraim, Asenath ngayarta jirnipulinyi. (Paliny kurntal Potiphera-mili, palapali nyampali muwarrku yatilpamilaku, tawun-ja, ngapi-nga, Heliopolis-ja.) ");
INSERT INTO nna_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjaminpa palinymili pirirri partanykarrangu: Belar, Becher, Ashbel, Gerah, Naaman, Ehi, Rosh, Muppim, Huppim, Ard. ");
INSERT INTO nna_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jacob nyungurrangu 14 nyirrirnikartijarrangujartiny Rachel-ja. ");
INSERT INTO nna_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan-pa palinymili pirirri partany, Hushim. ");
INSERT INTO nna_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali-pa palinymili pirirri partanykarrangu: Jahzeel, Guni, Jezer, Shillem. ");
INSERT INTO nna_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Jacob nyungurrangu 7 nyirrirnikartijarrangujartiny Bilhah-ja. (Jacob-mili kakaji Laban-ju yinyalu nyarra Bilhah, warrkamukata jarrinyaku paliny Rachel-ku.) ");
INSERT INTO nna_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wiyirr Jacob-milirrangu yanayi Egypt-karti, 66 marrngurrangu, Jacob-mili pirirri partanykarrangumili nyuparrangu. ");
INSERT INTO nna_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kujarra pirirri partanyjirri ngayarta jarrinyipulu Egypt-ja, Joseph-ku. Wiyirr Jacob-milirrangu Egypt-ja waninyiyi 70 marrngurrangu. ");
INSERT INTO nna_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob-ju ngakarna walangkarrangu Judah, wurranaku Joseph-ja jampa turlpuliny Gothen-ja, milyangkurl. Jacob-pa jintarrangu nyirrirni yananyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jacob kajanajalu Gothen-ja Joseph miranu, yawartajirri manapulinyi, chariot-ja wirrirnipulinyi, yana palinymilaku japartuku yirrinaku punjaja. Yirrinajalu japartuku ngamparnapularninyi, ngangkurlu jirnipulupa. ");
INSERT INTO nna_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jacob-ju wurrarnala, “Yartikarra! Nyuntungarra yirrinajalu, wankanyu ngarrany, marlkarri jarrulamarna pikaly!” ");
INSERT INTO nna_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph-ju muwarr pirnijanaku palinymilaku mamajirrangukupa wiyirrku palinymilaku japartumilaku marrngurranguku. “Ngaju yankulumarnalu kingiku yirrinaku, wurralamarnala, ‘Ngajumili mamajirrangupa japartumilirrangu wiyirr kajarniyi Canaan-ja. ");
INSERT INTO nna_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nyungurrangu marrngurrangu japarta jinakatarrangu. Kukurnjayipa purlimanpa nanikutupa wiyirr kanyayijaninyi wurrukarrapa.’ Pala muwarrarrangu wurralamarnala kingingi. ");
INSERT INTO nna_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Palaja muwarr ngakalkulunyurruka, ‘Ngajukarti turlpulunyurru yirrinaku.’ Palinyju japirr malkulunyurrinyi, ‘Ngani jirninyurru warrkamuku?’ ");
INSERT INTO nna_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Nyurralu wurralkulinyurrulu, ‘Nganarna partanykarranguja ngarrany japarta jirnikata. Karlujilu nganarnamilalu japartamu jirnikinyijaninyi kuwiyirrangu, japartu nganarnamilalu palajunngarra jirnikinyjaninyi, kuwarrilu nganarnalu palangarra jirniyirni.’ Palangarra wurralkulinyurralu. Palinyju wurralkulinyurraku nyungu warrarnja wantiyi, Gothen-ja, kajakulu wantulunyurru Egypt-arrangungumarra. Palarrangulu Egypt-arrangulu wirrilyi karrinyiyijanaku japarta jirnikataku.” Palajunju wurrarnajanaku Joseph-ju. ");
INSERT INTO nna_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Palaja Joseph yanalu kingiku. “Ngajumili japartupa mamajirrangupa marrka pirirripa kajarniyi Canaan-ja. Kanyayi nanikutupa purlimanpa kukurnjayipa wurrukarra wiyirr. Gothen-ja waninyayi kuwarri.” ");
INSERT INTO nna_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Mamajirrangu 5 kanyajaninyi kingikarti, milyangkurl jirnijaninyi. ");
INSERT INTO nna_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Japirr marnajaninyi kingilu, “Nganikapali warrkamu jirninyurru?” “Japarta jirnikatarrangu nganarna. Karlujilupa japartulu nganarnamilalu kuwiyirrangu japarta jirnikinyipulu, nganarnalu palajunngarra jirniyirni. ");
INSERT INTO nna_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Warrarn Canaan-ja punarra yiji, mayimajirri yiji nganarnamilaku kuwiyiku. Turlpanyiyirni nyungukarti wankanyuku waninyaku. Yijapa wantulupiyirni Gothen-ja? Wurralaman nganarnaku waninyaku palanga?” Palajun wurrarnayili kingingi. ");
INSERT INTO nna_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kingilu wurrarnalu Jospeh-ja, “Nyuntumili japartupa mamajirrangu turlpanyiyi nyuntuku yirrinaku. ");
INSERT INTO nna_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Wantulupiyi Egypt-ja. Jurti jilijanaku warrarn ngalypakata yiji. Jana wantulupiyi Gothen-ja. Yijapa jinta ngalypakata japarta manakata nyampali jilijaninyi ngajumilaku kuwiyirranguku.” Palajun wurrarnalu kingilu. ");
INSERT INTO nna_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph-ju kanyalu japartu palinymili kingiku. Jacob-ju ngalypa muwarr pinalu kingiku. ");
INSERT INTO nna_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","“Wayirti, partunurrangu kurrngal yirrirnan?” ");
INSERT INTO nna_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","“Yananya-yananyakanu yirrirnarnajaninyi puru partunurrangu, munu kurrngal, 130-jakun. Ngurnjularrangu palarrangu. Ngajumili karlujilupa japartulupa marlu yiji partunurrangu yirrirnapulujaninyi. Ngaju munu palajirrikapali.” ");
INSERT INTO nna_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Palaja Jacob-ju japirr marna Ngarrka, “Tuku jilaman yijalu yiji nyungu kingi.” ");
INSERT INTO nna_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Palaja Joseph-ju jurti jirnijaninyi japartupa mamajirrangupa ngalypa yiji warrarn kingijalu muwarrjalu. Palanga jarnti jirnijaninyi mayarrangu tawunmartaji, ngapimartaji, Rameses-martaji. ");
INSERT INTO nna_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph-ju tuku jirnikinyijaninyi japartupa mamajirrangupa janamilirrangu wiyirr. Palinyju yinganyikinyijaninyi mayi. ");
INSERT INTO nna_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Punja yiji waninyi ngapa munu pungkama Egypt-japa Canaann-ja. Mayi wiyirri jarrinyijanaka wiyirrku Egypt-jaku Canaan-jaku. Mayimajirrilu manyurla-manyurla jarrinyiya. ");
INSERT INTO nna_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Punja yiji mayi manikinyiyi warnkujartinyju. Joseph-ju warnku kanya kingi yinyala. Palaja marrngu warnkumajirri waninyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Palaja Egypt-arrangu milpanyiyalu Joseph-ku, wurrarniyili, “Nganarnalu yinyayirninti nganarnamili warnku wiyirr. Nganarna warnkumajirri kuwarri. Nyuntulu yingkulumunnganinyi mayi, wankanyuku waninyaku. Mayimajirringa marlkarri jarriyirnili.” ");
INSERT INTO nna_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","“Kawayijaninyili ngajukarti kukurnjayipa nanikutupa purlimanpa jinta kuwiyi nyurramili, puntajulu yingkulumurnunyurrinyi mayi.” ");
INSERT INTO nna_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kanginyikinyijaninyi Joseph-karti janamili yawartapa kukurnjayipa nanikutupa purlimanpa tangki. Puntajulu mayi yinganyikinyijaninyi. Palajun jirnikinyiyi partunungu warajanga. ");
INSERT INTO nna_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Yarranamal turlpanyiyalu Egypt-arrangu Joseph-ku. “Nyampali, yija wurrarniyirnangu, yinyayirninta purlpilu warnku wiyirr nganarnamili, yinyayirninta kuwiyirrangu wiyirr nganarnamili mayiku maninyaku. Munu yijirla mayimajirri nganarna. Wunyjurrulurti mayi mankulupiyirni warnkumajirrilu? Kalkurnayirni nganarnamili kawupa warrarnjakun. ");
INSERT INTO nna_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nganiku, karrinyanpa marlkarri jarrinyaku nganarna, warrarn nganarnamili kurluny-kurluny jarruliny nganarnamajirri. Yiwanganinya mayi. Puntajulu yingkulupiyirni warrarn nganarnamili kingi, nganarna wiyirr palinymili warrkamukata jarrulupiyirni, nganarna tuku jilapiyirni warrarn palinyku. Yiwanganinya wilyki jungkanga wirrinaku mayi jinaku, palajun jilapiyirni jungkaku ngalypa jinaku, wantulupiyirni wankanyu, munu marlkarri jarrinyaku.” Palajun wurrarnayili Joseph-ja. ");
INSERT INTO nna_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Palajalu Joseph-ju kanyajanaka warrarn kingimila jinaku, puntajulu yinyajaninyi mayi. Palajunjalu warrarnarrangu wiyirr kingimili jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Joseph-ju wiyirr marrngurrangu wirrirnijaninyi Egypt-ja warrkamukata kingiku. Janalu tuku jirnikinyiyalu warrarn palinyku. ");
INSERT INTO nna_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Joseph-ju munu kanyama janaka warrarn yatilparrangukurrangu. Kingilu tuku jirnikinyijaninyi yatilparrangu, palinyju yinyajaninya mayi. ");
INSERT INTO nna_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph-ju muwarr pirnijanaku Egypt-arrangungu, “Ngajulu nyurramili warrarn yinyala kinginga, wirrirnirninyurrinyi palinymili warrkamukata. Puntajulu nyurralu tuku jilkulinyurrulu warrarn palinyku. Nyungurrangu wilyki, wirriliyi jungkanga mayi jinaku. ");
INSERT INTO nna_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Palaja mayijalu murla jarrinyijalu wirrkalkulinyurru. Jinta yingkulinyurrulu kinginga. Kurtan 5-ja 1 yingkulinyurrulu kinginga, 4 kurtan kalkulkulinyurru. Pala nyurramili. Nyurra wiyirr partanykarrangupa mayi kalkululunyurru nganinyaku, jinta kalkulkulunyurru wilykirrangu jungkanga wirrinaku yarti.” Palajun wurrarnajanaku. ");
INSERT INTO nna_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","“Yuu, Nyampali. Yarranija! Wankanyu jirninnganinyi nyuntulu! Warrkamu jilkulupiyirnalu kingiku.” ");
INSERT INTO nna_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Palajunju Joseph-ju nyungu manguny wirrirnijanaku Egypt-arranguku: mayijalu murla jarrinyajalu kurtanja wilykijartinyja 5-ja 1 yinganyaku kingiku. Yatilparrangulujakun kalkurnukinyiyarningu warrarn janamili. Munu kangama warrarn janamili kingilu. Munu janamilija wilykija yingamayalu kingiku. ");
INSERT INTO nna_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Palarrangu Israel-mili marrngurrangu, Jacob-pa palinymili jamuji karlujirrangupa nyirrirnikartijarrangu, jana waninyikinyiyi palanga, Gothen-ja, Egypt-ja. Palanga partanykarrangu marlu jirniyijaninyi. Kurrngal jarrinyiyi yiji. Janalu kuru-kuru marnayijaninyi wurrukarra marlu. ");
INSERT INTO nna_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob ranyji jarrinyi. Egypt-ja waninyi 17 partunurrangu. Jampa marlkarri jarruliny, partunurrangu 147-jartiny. ");
INSERT INTO nna_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","31","Muwarr ngakarnalu palinymilaku pujamuku, Joseph-ku, “Milpuluman.” “Jampa marlkarri jarrulumarna. Muwarr yija yiwaji nyunguku: Marlkarri jarrinyajalu ngaju, munu nyungunga yamalaminyin Egypt-ja, kangkuluminyin kawu ngaju japartumilipa karlujimilikarti warrarnkarti. Palanga yamalaminyin wangka ngajumilinga japartupa karlujinga. Palajun jiliminyin yija? Parirr wirrilamanyin ngajunga kalpartinga partijirri, muwarr nyuntumili yiji yiwaji.” “Yuu, palajun jilamarna.” Palaja Jacob wupirnalu Ngarrkangapa nyurra marna. ");
INSERT INTO nna_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yarti jintalu wurrarniyili Joseph-ja, “Nyuntumili japartu wurrku.” Palinyju kanyapulinyi palinymilijirri pujamu, Manasseh-pa Ephraim, yanayalu yirrinaku Jacob. ");
INSERT INTO nna_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jacob-ja wurrarniyili, “Nyuntumili pujamu kajarna nyuntuku yirrinaku.” Palajunjalu paliny parnturrkarra jarrinyi, kajarna. ");
INSERT INTO nna_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Palinyju wurrarnala Joseph-ja, “Ngarrka Parnturrkata Jarrinyi Yiji ngayarta jarrinyiji ngapinga, Luz-ja, warrarnja Canaan-ja, wurrarnaji 'Ngajulu tuku jilamarnanta. ");
INSERT INTO nna_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ngajulu yingkulumarnanta marlu partanykarrangu, nyuntumilirrangu marrngurrangu kurrngal jarrulupiyi, warinypa wariny marrngurrangu. Ngajulu yingkulumarnajaninya nyuntumilirrangu nyungu warrarn janaku yiji ngarramarntiku kalkunaku.'” ");
INSERT INTO nna_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Palaja Jacob muwarr pinalu Joseph-ku, “Joseph-kayi, nyuntumilijirri partanyjirri ngayarta jarrinyipulu Egypt-ja. Ngajulu kanganyarnapulinyi ngajumilakapalijirri, Rueben-pa Simeon-pa ngajumilimurninykapalijirri. ");
INSERT INTO nna_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Yarti yijapa mankuluman partanykarrangu palarrangu nyuntumilirrangu, munu ngajumilirrangu. Warinyjirrija Ephraim-paja Manasseh-ja warrarn mankulinypulu.” ");
INSERT INTO nna_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nyungu jirnirnarnalu pipiku nyuntumilaku, Rayijilku. Walarni jarrinyajalu Mesopotamia-ja paliny marlkarri jarrinyi Canaan-ja, wangka ngapingi, Ephrath-ja. Paju karrinyangulu yiji.” (Kuwarrija pala Ephrath yini Bethlehem.) ");
INSERT INTO nna_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jacob-ju yirrirnapulinyi partanyjirri Joseph-mili, “Nganurtu nyungu partanyjirri?” ");
INSERT INTO nna_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph-ju puntajulu, “Nyungu partanyjirri ngajumili. Ngarrkalu yinyanyipulu Egypt-ja.” “Kawapulinyi ngajukarti. Ngarrkalu tuku jilkulinypulinyi ngajuja muwarrja.” ");
INSERT INTO nna_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jayikapu ranyji jarrinyaja pani kurlu jarrinyikinyi, partarl yirrirnikinyi. Joseph-ju kanyapulinyalu partanyjirri, palanga ngampalja jirnipulinyipa munyjarnapulinyi. ");
INSERT INTO nna_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Wurrarnala Joseph-ja, “Purlpi wurrarnarna, ‘Munu yarrana yirrinaku nyuntuku ngajulu’, kuwarri Ngarrkalu jinajalu yirrinaku nyuntuku, nyuntumilakupa partanykupa.” ");
INSERT INTO nna_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Manapulinyi Joseph-ju kartingija partanyjirri Jacob-ja, wupirnalu milya kaniny jarrinyalu jungkakarti. ");
INSERT INTO nna_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph-ju wirrirni Ephraim Jacob-ja jampukarti, Manasseh marrjanyukarti. ");
INSERT INTO nna_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Jacob-ju parirrjirri warinykurnu jinarninyi. Palinyju marrjanyukarti parirr wirrirnarninyili jurnturtunga Ephraim, palinyngarra nyirtingunyamarniny, palinyju jampukarti parirr wirrirnarninyili jurnturtunga Manasseh, murrkangunyamarninyja. ");
INSERT INTO nna_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Palaja muwarr pinalu Ngarrkalu ngalypa jilkulinypalu Joseph-ku, tuku jilkulinypulinyi partanyjirri Joseph-milijirri: “Ngajumilalujirri karlujilupa japartulu Ngarrkajalu wurranajalu jirnikinyipulu. Ngajulu karrinyarna Ngarrkakungarra ngalypa jilkulinypulaku nyungukujirri partanykujirri. Ngarrkalu kanyanyi ngarrakuny nyungukartijakun. Ngajulu karrinyarna palinyjungarra ngalypa jilkulinypulaku nyungujirriku. ");
INSERT INTO nna_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ngarrkamilalu angel-ju kartuwarra marninyi kurlujartinyjamarranga. Ngajulu karrinyarna palinykungarra ngalypa jilkulinypulaku nyungujirriku. Ngajulu karrinyarnapulaku kurrngalku partanykarranguku jinaku, jamuji karlujirrangupa nyirrirnikartijarrangupa. Palajunjalu marrngurrangulu kurlkarri malapiyi ngajumili yinipa yini ngajumili karlujimili Abraham-milipa yini ngajumili japartumili Isaac-milipa!” ");
INSERT INTO nna_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Joseph-ju yirrirni Jacob-ju wirrirni parirr marrjanyukarti Ephraim-unga jurnturtunga. Ngarlu kurlu-kurlu jarrinyi. ");
INSERT INTO nna_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Munu palajun, japartu! Nyungu murrkangunyamarniny, parirr marrjanyukarti wirrilarninyili jurnturtunga palinyjangarra!” ");
INSERT INTO nna_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Palinymilalu japartulu panju karrinyili, wurrarnili, “Miranu palaku ngaju, ngajumili partany, miranu palaku! Manasseh-milirrangu marrngurrangu kurrngal jarrulupiyi yiji. Marrkamarninymili marrngurrangu kurrngal jarrulupiyi yiji, palinymili nyirrirnikartijarrangu jintarrangu marrngurrangu jarrulupiyi, warinypa wariny, kurrngal.” ");
INSERT INTO nna_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Jipi palajun muwarr pirnipulaku. Wurrarnapulaku, “Nyurrajalu japirr malapiyi Ngarrkalu ngalypa jinaku jintaku, janalu muwarr pilipiyi, ‘Ngarrkalu ngalypa yiji jirnikinyipulaku Ephraim-kupa Manasseh-ku. Yijapa palajun jilkuliny nyurraku pukun’.” Palajunjalu Jacob-ju wirrirni walangkarrangu Ephraim, Manasseh wirrirni nyirrirnikarti. ");
INSERT INTO nna_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Palaja Jacob-ju wurrarnala Joseph-ngu, “Jampa marlkarri jarrulumarna. Ngarrkalu kalkulkulunyurrinyi, yarti kulpa malkulinyurrinyi warrarnkarti ngajumilikarti karlujimilikartipa japartumilikarti, Canaan-karti. ");
INSERT INTO nna_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nyuntu wirrirnarnanta murrkangunyakapali mamajirranguku. Palanga Canaan-ja purlpija mawurla wirtu jantulu wura marnarnajanaku Hamor-milirranguja. Kuwarri pala warrarn nyuntu yinganyarnanta.” ");
INSERT INTO nna_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","49:1-28 has been omitted at this stage, as being an unknown genre. The contents may be taken literally and thus be very confusing to the Nyangumarta people. For readers struggling with Nyangumarta the details would probably confuse them and discourage from reading further. It can be retained in the English diglot, for those who can read English and wish to know what is in it. ");
INSERT INTO nna_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Palaja Jacob-ju wurrarnajanaku partanykarrangungu palinymilinga 12-ja. “Jampa marlkarri jarrulumarna. Wirrilkulunyurru kawu ngajumili japartungapa karlujinga. Canaan-ja warrarnja wirrilamanyinyurru palanga jurntinga Machpelah-nga, Mamre-ja kakarrakurti, warrarnja Ephron-milinga, Hittite-milinga. Karlujilu Abraham-ulu warnkujartinyju mana pala warrarn, jurnti pukun, warajaja Hittite-ja, yini paliny Ephron. Mana malkarrinyjarriku wirrinaku. ");
INSERT INTO nna_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","32","Palanga jurntingi wirrirniyipulinyi Abraham-pa mirtawa palinymili Sarah, palangangarra wirrirniyipulinyi Isaac-pa mirtawa palinymili Rebecca. Palaja wirrirnarna ngajumili mirtawa pukun, Leah. Palangangarra warajanga jurntinga ngaju wirrilamanyinyurru pukun.” Palajun wurrarnajanaku Jacob-ju. ");
INSERT INTO nna_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nyungu jipi muwarr pinajalu partanyarranguku palinymilaku, karta karrinyi, wurrjurna. ");
INSERT INTO nna_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Palanga Joseph-ju ngampa pirni palinymili japartu, paliny ngangkurlu jirnikinyalu. ");
INSERT INTO nna_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Wurrarnajanaku maparnkarrangukurrangu “Tuku jiliyi marlkarri jarrinyaja kawu japartu ngajumili kalkunaku yartiku.” Janalu wirrirnikinyiyi karamarta nganin-nganin palakapali kawunga puka jarrinyamanyala. ");
INSERT INTO nna_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Karrpurrangu 40 tuku jirnikinyiyi palinymili kawu. Egypt-arrangu ngangkurlu jirnikinyiyalu palinyku. Ngangkurlu jirnikinyiyalu punja, 70 karrpurrangu. ");
INSERT INTO nna_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Joseph-ju muwarr pinajanaku wirturranguku nyampaliku, kingimilaku warrkamukatarranguku. “Ngajumilalu japartulu wurrarnaji, ‘Marlkarri jarrulumarna kuwarrimarta. Marlkarri jarrinyajalu ngajunga kangkulumanyin ngajumilikarti warrarnkarti waljakarti, Canaan-karti. Wirrilamanyin jurntinga tuku jinijalu ngajujalu.’ Palajunjalu yiji winyjinajalu, palajun jirnirni. Muwarr pilijiyalu kingiku ngajuku. Wurraliyili ngaju karrinyirni yaninyaku Canaan-karti ngajumilaku japartuku wirrinaku jurntinga, marlkarri. Palaja kulpulumarna nyungukarti.” ");
INSERT INTO nna_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kingilu muwarr ngakarnalu, “Yuu, yarra Canaan-karti, nyuntumilaku japartuku marlkarriku jurntinga wirrinaku. Kalkulu muwarr nyuntumilaku japartuku.” ");
INSERT INTO nna_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Joseph yana Egypt-ja Canaan-karti palinymilaku japartuku jurntinga wirrinaku. Marlu marrngurrangu yanayi palinyja, warrkamukatarrangu kingimilipa nyampalirrangu kingimilija mayajapa warinyarrangu nyampalipa, yanayi Joseph-ja. ");
INSERT INTO nna_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Joseph-milirrangupa palinymili mamajirrangumilipa yanayi wiyirr, murrukurrurrangujakun yakarnayijaninyi yintanga Gothen-ja. Kukurnjayipa nanikutupa purlimanpa pukun yakarnayi. ");
INSERT INTO nna_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kurrngal wirtu yiji yanayi Joseph-ja. Jinta chariot-ja yanayi, jinta yawartanga jali pirniyi. ");
INSERT INTO nna_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Turlpanyiyi wangka Atad-mili yapanapinti ngurra, kakarra Pijunga Jordan-ja. Palanga waninyiyi 7 karrpurrangu, ngangkurlu jirnikinyiyi Joseph-milaku japartuku. ");
INSERT INTO nna_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ngurrararrangulu pinakarrinyiyijaninyi. Wurrarnayarnangu, “Marrngu Egypt-ja yija yiji ngangkurlu jinayi.” Janalu wariny yinyaya yini pala, Abel-Mizraim. Palalu yinilu wurrarna, “Egypt-jaku Ngangkurlu Jinapinti.” Wangka Pijunga Jordan-ja pala. ");
INSERT INTO nna_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Palajun jirniya Jacob-mili partanykarrangulu wirrirnayi janamili japartu palanga jurntinga Machpela-nga, kakarrakurti Mamre-janga, Canaan-ja. Purlpilu Jacob-milalu karlujilu mana warnkujartinyju pala warrarn jurntijartiny warajaja marrnguja Hittite-milirranguja jurntinga jinaku marlkarrinyjarrinyku. Janalu yijalmarta jirniyalu muwarrku janamilaku japartuku, palanga wirrirnayi paliny pukun marlkarri jarrinyaja. ");
INSERT INTO nna_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Palaja Joseph-pa mamajirrangupa jinta wiyirrpa Egypt-karti kulpanyiyi. ");
INSERT INTO nna_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Palaja palinymili mamajirrangu muwarr pirnikinyarningu, “Joseph-ju ngurnipali panyju nganyjurraku. Purlpilu nganyjurrulu kurlu jirninyalu. Puntajulu yijapa palinyju kurlu jilkulinynganyjurruka.” Jana wirnti karrinyikinyiyili. ");
INSERT INTO nna_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Muwarr ngakarnayalu, “Nganarnamilalu japartulu wurrarna nganarnaku palajun muwarr pilipiyirnangu, ‘Nyuntumilalu mamajirrangulu janalu kurlu jirniyanga. Munu wirrilyi karrulumanjanaku. Pikalyju yirrilijanaku.’ Palangarra muwarr nganyjurrumilija japartuja nyuntuku. Munu wantuluman wirrilyijartiny nganarnaku, ngarlu ngalypa wantuluman nganarnaka.” Pinakarrinyaja pala muwarr paliny ngangkurlu jirni. ");
INSERT INTO nna_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Palaja mamajirrangu turlpanyiyalu, wupirniyalu milya kaniny, jana muwarr pirniyalu, “Nyuntu nganarnaku nyampali, nyuntuja muwarrja jilipiyirni.” ");
INSERT INTO nna_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph-ju muwarr pirnijanaku, “Munu wirnti jarrinyaku, puntaju munu kurlu jilamanyinyurruka. Ngaju munu Ngarrka, ngajulu munu wirlalamarnanyurrinyi. ");
INSERT INTO nna_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nyurralu kurlu jinaku karrinyinyurru, nyurralu yinyanyinyurru jananga ngajarringa warnkuku. Ngarrkalu ngalypa jirninganyjurruka wiyirrku. Palinyju kanyanyi nyungukarti kalkunaku marrngurranguku wankanyuku. Yuu, marlu wurrjirnamayi janparrja, kuwarri wankanyu waninyiyi. ");
INSERT INTO nna_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Munu ngajunga wirnti karrinyurrulu. Ngajulu tuku jilamanyinyurrinyi nyurramilipa partanykarrangu.” Palajun ngalypa muwarr pirnijanaku mamajirranguku. ");
INSERT INTO nna_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph-pa palinymili japartumilirrangu waninyiyi Egypt-ja ngarrany. Joseph yija yiji ranyji jarrinyi, 110 partunurrangu. ");
INSERT INTO nna_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph-mili partany Ephraim, nyirti Joseph-mili, palamili partanykarrangumili partanykarrangu yirrirnijaninyi Joseph-ju. Manasseh, Joseph-mili murrkangunya, partanyjartiny, yini Machir. Palamili pukun partanykarrangu yirrirnijaninyi Joseph-ju. Yirrirnijaninyi partanyjirrimilija karlujirrangu palinyju. ");
INSERT INTO nna_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Palaja Joseph-ju muwarr pirnijanaku mamajirranguku, “Jampamarta wurrjulumarna. Ngarrkalu tuku jilkulinyurrinyi, yarti kangkulinyurrinyi nganyjurrumilikarti warrarnkarti. Winyjirni yinganyaku pala warrarn Abraham-pa Isaac-pa Jacob. Yuu, yarti pala warrarn yingkulunyurrinyi nyurra. ");
INSERT INTO nna_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yuu, kangkulunyurrinyi palakarti warrarnkarti. Nyurralu kangkulunyurru winyja ngajuja yananyajalu. Wurraliyi yiji pala jilkulunyurru.” Wurrarnayalu, “Yija pala jilipiyirni nyuntujalu muwarrjalu.” ");
INSERT INTO nna_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Palaja Joseph wurrjurnu. Paliny 110 partunurrangujartiny. Karamarta wirrirniyi kawunga puka jarrinyamanyala. Palaja kawu wirrirniyi coffin-ja, kalkurnayi palanga, Egypt-ja. ");
INSERT INTO nna_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Purlpi nyungu waraja mirtanya pirirri yana palinymilija warrarnja ngapikarti, pala yini Egypt. Palinymili yini Jacob. Wariny yini paliny Israel. Jacob-mili pujamumurninyarrangu pukun yanayili palinyja, janamilirrangu pukun marrngurrangu. Nyungurrangu yinirrangu Israel-mili partanykarrangu yanayilipa palinyja Egypt-karti: ");
INSERT INTO nna_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","4","Rueben, Simeon, Levi, Judah, Issachar, Zebulun, Benjamin, Dan, Naphtali, Gad, Asher. ");
INSERT INTO nna_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jampa yananyikinyiyi Egypt-karti Jacob-pa palinymili partanykarrangupa Jacob-mili karluji jamujirrangu jana kurrngal yiji, 70 marrngu jana wiyirr. Jacob-mili partany wariny Joseph waninyikinyi palangangarra kaninypirti Egypt-ja. ");
INSERT INTO nna_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Punja waninyiyi palanga, Egypt-ja. Palaja Joseph marlkarri jarrinyi, palaja palinymilirrangu mamajirrangupa janamili partanykarrangu jana pukun wiyirr Jacob-milirrangu marrngurrangu marlkarri jarrinyiyi. ");
INSERT INTO nna_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Janamilirrangu nyirrirnikartijarrangu kurrngal yiji jarrinyiyi, partanykarrangu kurrngal kanganyikinyiyijaninyi kakuputulu, munu jipi jarrimajanaku janamilaku partanykarranguku, kurrngal yiji jana waninyikinyiyi ngurrarrangujartiny ngurnarrikurnujirri palanga warrarnja. ");
INSERT INTO nna_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Yarti punjamarta palaja wariny pirirri wirtu nyampali jarrinyi palaku warrarnku Yijipikupa nyampali palarranguku marrngurranguku palanga warrarnja. Nyungu marrngu yija panypanyakata Juwujapukupa wariny jirnikinyi. Palinyju munu kurlkarri marnama wunyjurru purlpi Joseph-ju ngalypalu tukulu kalkurnikinyijaninyi marrngurrangu Egypt-ja. Nyungu wariny nyampali wirtu, palinyju malyparr karrinyikinyijanaku marrngurranguku Israel-jaku. ");
INSERT INTO nna_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Palalu marrngulu karra marnajanaku Egypt-jaku marrngurranguku, “Pinakarrayi! Palamarrangu marrngurrangu Israel-ja kurrngal yiji jarrinyayi jana. ");
INSERT INTO nna_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nganyjurrulu jipi jilaminyijanaku janalu partanyku kanganyaku. Jampa jinta ngajarrirrangu milpulupiyinganyjurruku kuliku, ngurnipali palamarrangulu marrngurrangulu Israel-jalu kululapiyijaninyi palarrangu ngajarrirrangu kulipatinaku nganyjurrungu. Ngurnipali wirlalapiyinganyjurrinyi ngarrakunyju. Palaja munu warrkamu jilipiyinganyjurruku, mirti yakalapiyinganyjurruku ngarramarntilu. Ngurnipali janangarra nyampali jarrulupiyinganyjurruku. Kuwarringulu kurnta jilaminyijaninyi palarrangu ngarramarntija partanyja kanganyaja. Kurluny-kurlunyja yijanga kalkuluminyijananyi.” ");
INSERT INTO nna_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Janamilija nyampalija muwarrja jirniyi, nyampalirrangu wirrirniyijanaku palarranguku marrngurranguku Israel-jaku. Palarrangulu nyampalirrangulu jakulirniyijaninyi palarrangu marrngu Israel-ja marrjalu warrkamuku, mayarranguku yarni manaku jirniyijaninyi. Kujarra tawunjirri Israel-jalu marrngurrangulu yarni marnayipulinyi, ngapijirri yinijirri, Pijumupa Ramiji. Palangajirri wirtujirri mayajirri yarni marnayipulinyi mayipinti Yijipijaku marrngurranguku. ");
INSERT INTO nna_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yijipijalu yijanga kurluny-kurlunyja kalkurniyijaninyi, yirrku Israel-jalu marrngurrangulu partany kanganyikinyiyijaninyi kurrngal. Jana kurrngal yiji jarrinyiyi, jirrja jarrinyiyi, waninyikinyiyi ngurnarrikurnujirri. Yijipija marrngurrangu wirnti yiji jarrinyiyijanaku palarranguku. Malyparr karrinyiyijanaku palarranguku marrngurranguku Israel-jaku. ");
INSERT INTO nna_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Palaja pajumajirralu yijalu warrkamuku jirniyijaninyi marrjalu palarrangu Israel-jalu marrngurrangu. ");
INSERT INTO nna_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Janalu marrjalu yiji warrkamuku jirniyijaninyi Israel-jalu marrngurrangu, janalu jakulirniyijaninyi yarni manaku mayarranguku ... janalu jakulirniyijaninyi janukuku karlinyaku ngapaku pukun kanganyaku. Yijalu jakulirniyijaninyi warrkamu jinaku marrjalu yiji kakuputulu. ");
INSERT INTO nna_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kujarra mirtawajirri waninyikinyipulu ngayinykarraku kalkunaku palarranguku Israel mirtawanyjarriku. Waraja yini Zipporah, warinymurniny yini Puah. Janamilalu Egypt nyampalilu wurrarnapulaku palajirringi mirtawajirringi, ");
INSERT INTO nna_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ngurnipali Israel-jalu mirtawalu partany wupartu pirirri kangkuliny, marlkarri wirlalkulunyumpulu pala partany. Mirtawanyjarri partanykarrangu jakun kalkulkulunyumpulujaninyi wankanyu. Wiyirr pirirrimartarrangu partanykarrangu marlkarri wirlalkulunyumpulujaninyi jampa miral jarrinyajangarra.” ");
INSERT INTO nna_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Palalujirri mirtawalujirri ngarrakunyju kurlkarri marnikinyipulu Ngarrkangarra. Palajunjalu panypanyapululu palanga nyampalingi. Palanyju munu marlkarri wirlanamapulujaninyi pirirrimarta partanykarrangu ");
INSERT INTO nna_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Palajunjalu palalu nyampalilu Egypt-jalu wariny ngakarnapulaku mananya kulpanyaku. Nyampalilu karra marnapulaku, “Nyumpalalu wankanyu yakarnanyumpulujaninyi pirirrimarta partanykarrangu, munu marlkarri wirlanamanyumpulujaninyi. Nganijalu panypanyijinyumpulu?” ");
INSERT INTO nna_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Puntaju karra marnapulalu, “Munu marlkarri wirlarnakalayijaninyi pirirrimarta partanykarrangu. Israel-jalu mirtawanyjarri munu Egypt-jalu mirtawanyjarrikapali. Israel-jalu mirtawanyjarri marrjapanu yiji, janalu partany janamili kanganyayijaninyi nyampalu. Jampa yananyalayijanaku palarrangukarti. Jampa kajanalayijanaku, janalu purlpi partany kanganyayiyarninga.” Pulanyju mitu marnapulu pala Nyampali. ");
INSERT INTO nna_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Palajunjalu palalujirri mirtawalujirri Ngarrkanga yijalmarta jirnipululu, kalkurnupulujaninyi pirirri partanykarrangu wankanyu. Ngarrka pikaly yiji jarrinyipulaku palakujirri, yinyapulinya walja pukun partanyjirri pulanymili. Israel-jalu marrngurrangu kurrngal yiji jarrinyi kawarniyi. ");
INSERT INTO nna_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Palaja nyampalilu karra marnajanaku Yijipijaku marrngurranguku, “Parnpiliyijaninyi wiyirr Israel-jaja partanykarrangu pirirrimarta pijungu, ngapalu kurnulinyjaninyi. Yakaliyijaninyi mirtawarrangu partanykarrangu wankanyu.” ");
INSERT INTO nna_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Palanga waninyikinyi nyungu waraja Israel-ja (-jaja ?) pirirri. Paliny waraja Levi-milirranguja. Palinymili nyupajimurniny Levi-milirranguja pukun. ");
INSERT INTO nna_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Palalu mirtawalu partany kanya pirirri. Palinyju parrjarna pala partany ngalypa purrpurnkata. Palinyju kuku jirni pala partany kujarrapa warajanga wirlarranga wirntijartinyju nyampalingimarra. ");
INSERT INTO nna_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Yartikarra palinyju munu kuku jinaka pala partany. Palajalu manajaninyi jurlunkurrangu, yarni marna pitikapali, yamarna miljirrkapalilu. Palajalu wirrirni pala partany palanga pitikapalingi, wirrirni pala pitikapali kankarni ngapanga jurlunkurrangungu rirri-rirringi ngapanga. Palajun jirni kuku jinaku palaku partanyku. ");
INSERT INTO nna_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Palamilalu partanymililalu kangkujilu parrjarnikinyi wararrju kajangulumarta. ");
INSERT INTO nna_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Palajalu Pharaoh-mili kurntalmurniny yana pijukarti mirtawarrangu palinymili warrkamukatarrangujartiny. Yana janpakarti janpanyaku. Palarrangu warrkamukatarrangu yananyikinyiyi rirri-rirringi pijungu. Palalu yirrirni pala pitikapali jurlunkurrangungu, ngakarna waraja mirtawa mananya kulpanyaku palinykartiku. ");
INSERT INTO nna_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Palinyju yatirni pala pitikapali, yirrirni partany, ngangkurl jirnikinyi. Palinyju paju karrinyalu palaku, karra marna, “Nyungu waraja Israel-milijarrangu partany.” ");
INSERT INTO nna_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kangkujimurninyju palamilalu partanymilalu karra marnalu nyampalimilaku kurntalku, “Wunyjurru? Yankulumarnajanaku Israel-jaku mirtawanyjarriku mananya kulpanyaku, tuku jilapiyinga nyungu partany nyuntuku.” ");
INSERT INTO nna_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Yu!” Karra marna palalu. Palalu partanymilalu kangkujimurninyju yananyakanu mana palamili partanymili waljangarra pipimurniny. ");
INSERT INTO nna_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Nyampalimilalu kurntalju karra marnalu palaku partanymilaku pipiku, “Kawa nyungu partany, tuku jila, wirtu jilapijinpa. Ngajulu warnku yungkulumarnanta.” Palalu pipimurninyju kanya pala partany palinymilikarti waljakarti ngurrakarti, palinyju tuku jinikinyi. ");
INSERT INTO nna_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Pala partany wirtu jarrinyi. Palajalu palinymilalu waljalu pipimurninyju kanyali Pharaoh-milikarti kurntalmurninykarti. Pala partany palamili pujamu jarrinyalu. Palinyju karra marna, “Ngajulungarra manarna nyungu partany ngapaja, palajunjalu yini malamarna Moses.” ");
INSERT INTO nna_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moses-ju wirtu jarrinyi, pirirri yija yiji jarrinyi. Warajanga karrpungu yanajanaku yirrinaku palinymilirranguku marrngurranguku, palarrangu Israel-ja. Palinyju yirrirnijaninyi yijanga kurluny-kurlunyja waninyikinyiyi, Egypt-jalu nyampalirrangulu yijalu warrkamuku jakurlinikinyiyijaninyi marrjalu. Palaja yirrirni warajalu Egypt-jalu wirlarnikinyi waraja Israel-jaja marrngu, palinymilingarra warrarn walja marrngu. ");
INSERT INTO nna_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moses-ju parrjan-parrjarna, palanga jintaku munu parrjarnajanaku. Palaja wirlarna pala Egypt marrngu marlkarri, palinyju kawu palinymili kuku jini kaninykurti jungkanga, yamarna. ");
INSERT INTO nna_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Karrpu warinyja paliny puru yana-yananyikinyi, yirrirnipulinyi kujarra Israeli-ja marrngujirri kulipatirnikinyipulu. Karra marnalu warajaku, “Nganijalu wirlarnan nyungu pirirri, nyuntumili marrngu walja?” ");
INSERT INTO nna_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Purntaju karra marnalu, “Ngalayaku nganurtulu nyuntu nyampali wirrirnanta? Nganijalu wurrarnan ngajulu kurlujartiny jinarni, palinyju nyungulu ngalypa jini? Nyuntulu marlkarri wirlarnan nyarra Egyptian. Ngajuku pukun karrinyajin marlkarri wirlalaminyin palajun?” Palaja Moses-ju kurlkarri marna, -rninyi? ? “Miranu jana nyungu ngajulu marlkarri wirlarnarna nyarra pirirri.” Paliny wirnti karrinyi. ");
INSERT INTO nna_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Jampa Pharaoh-lu pinakarrinyi Moses-ju marlkarri wirlarna nyarra Egyptian, paliny kuli yiji jarrinyalu. Kurlkarri marna, “Ngajulu marlkarri yija wirlalamarna Moses.” Purlpi nyungu Moses mirti jirni pala Pharaoh-ngimarra wirntijartiny. Paliny yana kakarra warrarn warinykarti, pala warrarn yini Midian. Palamanga wani-waninyikinyi. Warajanga karrpungu milpanyajanaku pala janukungu. ");
INSERT INTO nna_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Paliny palamanga kajarnikinyi, 7 mirtawarrangu kurrinyjarri turlpanyiyi pala janukukarti. Jana kurntalmurniyarrangu priest-ku yini Jethro. (What did we use in Mark's Gospel for 'priest'?) Kurntalmurninyarrangulu tuku jinikinyiyijaninyi kukurnjari janamilaku japartuku. Janalu ngapa nyirnirnikinyiyijanaku janukuja kukurnjariku. ");
INSERT INTO nna_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Palamangangarra jinta pukun pirirrimarta milpanyiyi kukurnjariku tuku jinakata. Shepherd?? Janalu munu-munu jiniyijaninyi pala mirtawanyjarri ngapaja nyirninaja, purrja piniyijaninyi janukuja. Moses-ju purntu karrinyijanaku, palinyju karnti-karntinyijanaku palarrangungu pirirrimartanga, palaja ngapa nyirnirnijanaku pala mirtawanyjarrimilaku kukurnjariku. ");
INSERT INTO nna_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Palarrangu mirtawanyjarri kulpanyiyi janamilikarti japartumili ngurrakarti, Jethro-karti. Palinyju karra marnajanaku, “Nyurra kuwarri nyampa kulpanyanyurru. Wunyjurruja?” ");
INSERT INTO nna_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Janalu puntaju karra marnayalu, “Egypt-ja pirirrilu purntu karrinyinganaku, kartuwarra marnanganinyi jinta kukurnjariku tuku jinakatarrangungamarra. Have we a descriptive word for a 'shepherd'? japartamu jinakata was phonemicised from the English. Yijalu palinyju ngapa nyirrirnijanaku kukurnjariku pukun.” ");
INSERT INTO nna_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Palinyju puntaju karra marnajanaku palinymili kurntalmurninyarranguku, “Wanyjarningi pala pirirri? Nganijalu palamanga yakarnanyurru? Kulpanya marrayi nyungukarti milpulinyi, mayipa nyungungu ngalkulinynganyjurruku.” ");
INSERT INTO nna_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses waninyi pala Jethro-mili ngurranga punja. Palaja Jethro-lu yinya palinymili kurntal Zipporah nyupajimurniny jarrinyalu. ");
INSERT INTO nna_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Palaja partany kanya pirirri. Palaja Moses-ju karra marna, “Ngaju ngajarri warinyja warrarnja. Palajunjalu yini marna palinymili pujamu “Gershom”. How should we handle these puns in names? They were very common in Hebrew culture. Should we Ignore them? Or put them in footnotes? ");
INSERT INTO nna_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Moses waninyi Midian-ja punja yiji. Yarti partunurrangu kurrngalmartaja pala Nyampali Egypt-ja marlkarri jarrinyi. Wariny pirirri nyampali jarrinyi Egypt-ja. Jalypalu ngarrany Egypt-jalu kurluny-kurlunyja kalkunikinyiyijaninyi Israel-ja marrngurrangu, marrjalu yiji warrkamuku jakurlirnikinyiyijaninyi yija ———-??, janalu Ngarrkangarra kurlkarri marnikinyiyipa japirr marnikinyiyi kartuwarra manaku. ");
INSERT INTO nna_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","25","Palinyju pinakarrinyijaninyi, kurlkarri marnajaninyi muwarr nyarra wurrarnajanaku purlpilu mirtanya-mirtanyanga Abraham-japa Isaac-japa Jacob-ja. Purlpilu muwarr nyarra wurrarnajanaku, “Yijalu ngajulu tuku jilamarnanyurrinyi. Ngajulu yungkulumarnajaninyi nyurramili nyirrirnikartija warrarn Canaan. Pala warrarn wantulinyjanaku janamili.” Palajun karra muwarr pinijanaku Abraham-japa Isaac-japa Jacob-ja. Munu pala muwarr kakurnama palinymili, tukulungarra parrjarnikinyijaninyi Israeli-ja marrngurrangu, kurlkangarra waninyikinyijanaku, paju karrinyikinyijanaku. ");
INSERT INTO nna_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses-ju tuku jirnikinyijaninyi kukurnjaripa nanikuturrangu palinymili kakajimurninymili, nyarra pirirri, Jethro, priest? What did we use in Mark's Gospel? waninyikinyi palanga warrarnja Midian-ja. Warajanga karrpungu Moses-ju palarranguku kuwiyiku ngurra marnikinyijanaku warrarnja puru karranga, milpanya wangka marna nyarra warnku wirtu, Warnku Sinai, pala warnku nyarra Ngarrkamili. ");
INSERT INTO nna_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Palamanga Ngarrkalu jurti jinarningu wikakapalilu Moses-ja. Moses-ju parrjarna mungka kampanyikinyi, palinyju miranu jarrinyakanu yirrirni, kurlkapirli jarrinyi, “Pala yija wika kampanyi, munurti palama mungka kampanyaka jurnpakartijakun. ");
INSERT INTO nna_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Wunyjurruja! Nganija pala mungka yirrku waninyi? Kula, wangkangulumartalu parrjalamarna.” ");
INSERT INTO nna_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Jampa yirrirni Moses wangka jarrinyaja Ngarrkalu kamarnalu pala partijirri kaninyjalu mungkangulu, “Moses! Moses!” Puntaju karra marnalu, “Yu? Ngajungarra nyungu.” ");
INSERT INTO nna_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ngarrkalu karra marna, “Munu wangka jarruluman. Nyuntu wararr karrinyan (Holy ground? Hmmm!) jungkanga. Yinji pilarningu jujika nyuntumili. Nyungu jungka ngajumili. Munu wangka milpuluman. ");
INSERT INTO nna_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ngaju Ngarrkangarra, ngajulu nyarra tuku jinikinyirnijaninyi nyuntumili mirtanya-mirtanya walangkarrangu, Abraham-pa Isaac-pa Jacob.” Moses wirnti karrinyalu parrjanaku Ngarrka. Palinyju ngumpa yamarnarninyi. ");
INSERT INTO nna_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Palaja Ngarrkalu karra marnalu, “Ngaju miranungarra janaku ngajumili marrngurranguku Egypt-ja. Palarrangulu maja-majalu kurluny-kurlunyja kalkurnayijaninyi. Janalu kamarnayi yiji ngajuku, janalu karrinyayi kartuwarra manaku nganurtulupa. Ngaju miranu janaku, jana kurluny-kurlunyja waninyayi. ");
INSERT INTO nna_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ngaju milpanyarnajanaku kartuwarra manaku Egyptians-jaja. Ngajulu kangkulumarnajaninyi palamaja warrarnja, warrarn warinykarti, ngalypakarti, walpurrakarti, ngalypakarti yija. Jinta warinyarrangu waninyayi palamanga warrarnja. Marrngurrangu Canaanite-japa Hittite-japa Amorite-japa marrngurrangu, Perizzite-ja pukun, jinta Hivite-japa Jebusite-ja kuwarri waninyayi palamanga. Palamakarti warrarnkarti kangkulumarnajaninyi Israelite-ja marrngurrangu. ");
INSERT INTO nna_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Egypt-jalu kurluny-kurlunyja kalkurnayijaninyi ngajumili marrngurrangu, ngaju miranungarra palaku. Israeli-jalu kamarnikinyiji ngajuku, ngajulu pinakarrinyikinyirnijaninyi. ");
INSERT INTO nna_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Palajunjalu ngajulu ngakalamarnanta Pharaoh-karti Egypt-karti mananya kanganyaku ngajumili marrngurranguku Egypt-ja (“out of”: something other than just -ja).” ");
INSERT INTO nna_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Puntaju karra marnalu Moses-ju Ngarrkaku, “Ngaju kalarti munu nganurtumarta, kurlujartiny yija. Munu yananyakarnalu nyampalikarti Egypt-ja, mananya kulpanyakupa marrngurranguku Israeli-rranguku palamaja.” ");
INSERT INTO nna_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ngarrkalu wurrarnalu, “Yija ngaju yankulumarnangu nyuntungu, jampa kangkulumanjaninyi marrngu Egypt-ja, milpulunyurru yakujani, nyurra malaminyinyurru nyungungu warnkungu. Palanga miranu jarruluman ngajulungarra ngakanarnanta” 'praise me'? 'worship me' ? Add to list of “Key Terms”. ");
INSERT INTO nna_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Palaja Moses-ju karra marnalu, “Jampa yananyakanu wurralamarnajanaku nyuntulu ngakarnanyin, japirr malaminyiyi, 'Nganurtu palinymili yini?' Ngani wurralamarnajanaku?” ");
INSERT INTO nna_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","15","Ngarrkalu wurrararnala Moses-ja, “Ngaju wankanyu ngarramarnti, wurralajanaku nyungu muwarr: 'Wankanyupa Waninyi, palalu ngakarninyi nyungu nyurrakarti. Yawayilungarra tuku jinikinyijaninyi Abraham-pa, Isaac-pa Jacob pukun. Palinyju nyungu ngakarninyi nyurrakarti.' Palajun karralu wurralamanjanaku Israelite-ja marrngurrangungu. Ngajumili yini Yawayi. Yawayingarra yini yini malaminyinyurru, nyurralupa nyurramilalu partanykarrangulupa janamilalu partanykarrangulupa jintalu pukun nyirrirnikartijalu. ");
INSERT INTO nna_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Jampa yananyakanu milpuluman Egypt-ja, kurrngalamanjanaku mirtanya-mirtanyanga Israeli-ja, wurralamanjanaku, 'Ngarrkalu tuku jirnikinyijaninyi nganyjurrumili marrngurrangu walangkarrangu. Palinyju tuku jirnikinyijaninyi Abraham-pa, Isaac-pa, Jacob pukun. Palinymili yini Yawayi, wankanyupa waninyi. Paliny miral jarrinyiji, muwarr nyungu yinyaji, muwarr nyungu nyurraku: 'Ngurinji ?? karrinyangulu parrjarnikinyirninyurrinyi. Palarrangulu Egypt-jalu kurluny-kurlunyja kalkurnikinyiyinyurrinyi, pajumajirralu. Ngaju miranu wiyirrku. ");
INSERT INTO nna_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kuwarri muwarr wirrinarninyurraku, ngajulu kartuwarra malamarnanyurrinyi palarrangu Egypt-arrangungamarra. Ngajulu kangkulumarnanyurrinyi warrarn warinykarti, pala nyarrapa waninyayi marrngurrangu Canaanite-pa Hittite-pa Amorite marrngurrangu, Perizzite pukun, Hivite-pa Jebusite marrngurrangu. Palarrangu marrngurrangu waninyayipa kuwarri. Pala ngalypakata yiji warrarn, kangkulumarnanyurrinyi palamakartingarra. Wurralamanjanaku Israelite-ja marrngurrangungu nyungu ngajumili muwarr.' ");
INSERT INTO nna_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Janalu pinakarrulupiyi muwarr nyuntumili. Palaja nyuntupa jinta wiyirr mirtanya-mirtanya Israeli-ja yankulunyurralu Egyptian-ja nyampalikarti, karra malkulunyurralu, 'Yawayi-lu, nyarralupa tuku jrinanganinyi, paliny miral jarrinyinganaku. Palajunjalu nganarnalu pirrakartiku yaninyaku karrinyayirni, kujarrapa waraja ngurrarrangu ngurnipali yankulupiyirni, kuwiyiku wirlalapiyirnalu Yawayiku.' ");
INSERT INTO nna_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ngaju miranu palaku nyampaliku, munungarra ngakanawayilu yirrku jarrulinyi nyurraku. ");
INSERT INTO nna_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ngaju marrjapanu yija. Ngajulu wirtu yiji jilamarna, ngajulu wirntiji pilamarnajaninyi palamarrangu Egyptians-ja, palarrangulu ngurnjulupiya yiji nganikupa jinaku. Yarti palaja nyampalilu ngakalkulinyurrinyi Egypt-ja. ");
INSERT INTO nna_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","22","Nyurra wurrukarrajartiny yankulunyurru. Wiyirr mirtawanyjarri yankulupiyijanaku Egyptian-jaku mirtawanyjarriku, nyarrapa jinta pukun waninyayijanaku Israeli-mili ngurrangapa, jinta pukun wangkakulupa neighbours?? waninyayi nyarra Egyptian-ja mirtawanyjarri. Japirr malapiyijaninyi silver-kupa gold-ku pukun, parirrpintipa, kurlkapinti. Wurrukarraku pukun japirr malapiyijaninyi. Ngajulu ngalypaku jilamarnajaninyi Egyptian-ja marrngurrangu ngayiny ngalypa yiji wantulupiyinyurruku. Palarrangu wurrukarra yungkulupiyijanaku Israelite-ja mirtawanyjarringi. Pala wurrukarra wirrilkulunyurrujanaku nyurrumilingi partanykarrangungu. Jampa Egypt yakalkulunyurru, wurrukarra janamilingarra kangkulunyurrarninga nyurraku.” ");
INSERT INTO nna_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses-ju puntaju karra marnalu, “Ngurnipali jintalu munu pinakarrulupijiyi ngajuku. Ngurnipali karra malayili, 'Yawayi munungarra miral jarrinyamangu nyuntuku.'” ");
INSERT INTO nna_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ngarrkalu karra marnalu, “Ngani palama warlina kalkurnan nyuntumili parirrja?” Palinyju puntaju karra marnalu, “Mungka.” ");
INSERT INTO nna_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Palinyju karra marnalu, “Jungkanga parnpila!” Moses-ju jungkanga parnpirni, pala jurru jarrinyi. Paliny wirntijartiny mirti jini jurrungumarra. ");
INSERT INTO nna_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ngarrkalu wurrarnala palinyja, “Warntingulu warlinakanu marra.” Palinyju palajunngarra jirni, palinyju warlirni, kulpanyakanu mungka jarrinyi. ");
INSERT INTO nna_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ngarrkalu karra marnalu, “Palajun jilaman. Palaja Israeli-jalu pinakarrulupiyingu nyuntuku. Janalu yijalmarta jilapijiyi muwarr ngajumili. ?? Ngaju, Yawayi, miral jarrinyarnangu nyuntungu. Ngajulungarra tuku jinikinyirnijaninyi nyuntumilirrangu marrngurrangu mirtanya-mirtanya, nyarra tuku jinikinyirnijaninyi, Abraham-pa Isaac-pa Jacob. Palajun miranu jarrulupiyi. ");
INSERT INTO nna_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Parirr wirrilarningu kaninykurti nyuntumili wurrungu.” Moses-ju wirrirnarningu kaninykurti Ngarrkamilingi muwarrja palaja kulpanya purrinajalu yirrirnarningu palinymili parirr yija mirta-mirta pitarr-pitarr wurrkujartiny. ");
INSERT INTO nna_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Palaja Ngarrkalu wurrarnala palinyja, “Yarrana parirr ngalpa jilarningu nyuntumili wurrunga.” ?? Palinyju yarrana ngalpa jinarningu parirr palinymili wurrungu jampa kulpanya purrirni, yirrirni ngalypa yajarri palinymili warinymurninykapali parirrkapali, wurrkumajirri. ");
INSERT INTO nna_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ngarrkalu wurrarnala, “Nyuntulu jurti jilamanjanaku nyarra marntipinti warnu, parrjalapiyi jurru jarruliny, yirrinajalu ngurnipali munu yijalmarta jilapiyingulu nyuntumilingi muwarrja. Palajunjalu nyuntulu jurti jilamanjanaku nyuntu parirr, mirta-mirta jarruliny, wurrkujapa palajalu yarrana ngalypa jarruliny. Yarti ngurnipali yijalmarta jilipiyi Ngajulungarra ngakanarnanta. ");
INSERT INTO nna_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Yirrkulu ngarrany yijalmarta jinaku nyuntungu panypanyjalu, ngapa mankuluman pijuja, Nile pijuja. Nyuntulu jurtilaman purnarranga jungkanga, pala ngapa pijirri jarruliny. ");
INSERT INTO nna_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moses-ju puntaju karra marnalu, “Ngaju munu yananyakarni janaku, ngaju ngunjul-ngunjulkata muwarr pinaku. Muwarr taju-tajukata ngaju jinu muwarr pinarni.” ");
INSERT INTO nna_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ngarrakalu karra marnalu, “Nganurtulu marrngu jawa yinyajaninya? Ngajulungarra. Nganurtulu marrngu jinta muwarrmajirriku jinajaninyi? Nganurtulu jinta kurlka ngawu jinajaninyi? Ngajulungarra. Nganurtulu jinta parrjanaku jinajaninyi? Nganurtulu jinta pampuru jinajaninyi? Ngajulungarra, Yawayi.?? ");
INSERT INTO nna_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nyuntu yankuluman Egypt-karti. Ngajulu wurralamanangu wunyjurrukarra muwarr pilamanjanaku, ngajulungarra muwarr pilamarnangu nyuntungu. ?? ");
INSERT INTO nna_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moses-ju puntaju karra marna, “Ngajuwayi, marrngu warinymarta ngakalaman.” ");
INSERT INTO nna_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Palajun karraja Ngarrka kulimarta jarrinyalu palinyku. Wurrarnala Moses-ja, “Nyuntumili mamaji Aaron, kurlkarri marnanngarra paliny? Ngaju miranu palinyku, paliny muwarrku ngunjunawayikata palarringarra mira karralu jampamartangarra kuwarri turlpulinyi. Nyuntu parrjanakanu pikaly yiji jarruliny. ");
INSERT INTO nna_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ngajulu wurralamarna nyumpuluku wunyjurru karraku muwarr pinaku, nyuntulukurra wurralamanpili palinyja, palaja ngajulu muwarr pilamarna nyumpuluku nyumpalanga kanka. ?? ");
INSERT INTO nna_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Nyuntuku, palinyju muwarr pilkuliny janaku marrngurrangungu. Nyuntulu wurralamanpili ngajumili nyarra muwarr, palinyju nyuntujaja muwarr wurralkuliny janaku jananga. ");
INSERT INTO nna_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kangkuluman warnu nyarra, palamajartinyjungarra jurti jilaman janaku. ?? ");
INSERT INTO nna_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Palaja Moses kulpanyalu palinymili kakajimurninykarti, Jethro-karti. Wurrarnala palinyja, “Puru kurra nyungu kulpanya ngakalaminyin janaku, kulpanya yirrinaku ngajumilirranguku Egypt-ja ngurnipali ngalypapa waninyayi.” “Yuu, ngalypa-ngalypa yarrajanaku.” ");
INSERT INTO nna_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nyungu Moses-janga Midian-jalu ngarrany, Ngarrkalu karra marnalu, “Nyarrarrangu marlkarri wirlanakupa karrinyikinyiyangu, palarrangu marlkarrijakun wiyirr, ngalypanga yankuluman Egypt-karti.” ");
INSERT INTO nna_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Palajun karraja Moses-ju mirtawapa palinymilijirri pujamumurninyjirri pukun, karnti jirnijaninyi donkey-nga. Jampa yananya kawanajalu ngarrany Egypt-karti, nyarra warnu kanganyikinyi pala Ngarrkalupa wurrarnala kanganyaku. ?? ");
INSERT INTO nna_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yarranakanu Ngarrkalu wurrarnala, “Kuwarri nyungu kulpanyan Egypt-karti. Ngajulu nyarra jurti jirnanangu (wonderful things) nyuntulu jilaman (must do). ?? Yijalu jilaman wiyirr palaku king-ju yirrilkuliny. Paliny jalypakata jilamarna, palinyju yirrkulu warlilkulinyjaninyi nyuntumili marrngurrangu. ?? ");
INSERT INTO nna_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Palajalu wurralamanpili king-ja nyungu muwarr Ngajumili: 'Ngaju Yawayi. Israeli-mili nyirrirnikartija jana walja ngajumilirrangu partanykarrangu (first born). ?? ");
INSERT INTO nna_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ngakalamanjaninyi ngajumili marrngurrangu, janalu muwarr pilapijiyipa ngaju yungkuluminyiyi (gifts). Pinakarraji ngajungu. Munujalu ngajulu marlkarri wirlalamarnanga nyuntumili murrkangunyamurniny pujamu.' Palajunkarra muwarr pilamanpalu king-ja.” ");
INSERT INTO nna_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","6","Jintalu wurrarnajiyi nyuntu purlpilu. Ngaju miranukapali waninyikinyirnangu nyuntuku. Kuwarringulu wariny, ngajulu yirrirnirninti waljalu jirtamarralu. Palajunjalu ngaju kurntany yiji ngajumilaku muwarrku, munu yarrana muwarr pilamarna palajun. ");
INSERT INTO nna_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Pikaly yiji nyarrarrangu marrngurrangu yakal manakata kurlujartiny jinakatarrangumilaku muwarrku, munu manal-manal jarrinyayijanaku kurlujartinyarrangumilingi jinangapa munu kulurnayijaninyi palarrangu nyurni manakata Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Pikaly yiji waninyayi kurlkarri manajalu Ngarrkamilaku muwarrku, pinakarrinyayalu ngarrakunyju. ");
INSERT INTO nna_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Miranu nyurra nyarra mungka yintamartaji waninyi, ngalypa kakuputu, mayi karrinyili ngalypakatapa parrka munu tikirl jarrinyakayi. Ngalypakata marrngurrangu palajunngarra mungkakapali. Jurtulu jinayi nganiwarralpirti, ngalypa jarrulinyjanaku. ");
INSERT INTO nna_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Munu yiji yakujun kurlujartiny jinakatarrangu marrngurrangu; jana nyarra ngapikapali, yapinajakapali mayikurnukapali, wangalju kanganyi. ");
INSERT INTO nna_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Ngarrkalu marrjalu wirlalkulinyjaninyi. Palinyju jinta pilkulinyjaninyi, jana munu wantulupiyijanaku palinymilirrangungu. ");
INSERT INTO nna_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Ngarrkalu tukulu kalkunajaninyi palinymilirrangu jurtungu ruwurtungu. Wariny yiji kurlujartiny jinakatarranguku, jana yananyayi yijakarti yiji kurluny-kurlunykarti. ");
INSERT INTO nna_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Kurlujartiny jinakatarrangu marrngurrangu wiyirr marlkarri jarrulupiyi, jana wiyirr yakal manakata Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Ngarrkalungarra tuku jinanyi; ngajulu kalkunarni nganiwarralpirti wankanyu waninyaku. ");
INSERT INTO nna_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Jinta marrngu kurlu jiniyi. Palaja wurrarnayalu Ngarrkanga, “Kurntany jarrinyarnangu”. Puru yakarnajaninyi. Palaja pikaly waninyayi ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Jinta marrngu kurlu jiniyi. Palaja wurrarnayalu Ngarrkanga, “Kurntanyja jarrinyayirni.” Munu mitu marnamayi, munu warnta marnamajaninyi. Kuwarri pikaly waninyiyi kakuputu. ");
INSERT INTO nna_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Purlpi kurlu jinirni, munu wurrarnamarnalu Ngarrkanga. Palajalu ngangkurl jinikinyirni kara wurrpu. Ngangkurlaja manyurla jarrinyirni. ");
INSERT INTO nna_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Karrpurrangu karrpungu, warrukartirrangu warrukarti, nyuntulu kararr jinijin, nyampali! Manyurla yija-yiji jarrinyirni. Yurranga karrpulu yarntalkuliny janpa, punarra jilkuliny. Palakapali warnta marninyin, Nyampali, palangulu tirtirti pinirni, murrjin jarrinyirni, marlkarri jarrimarna. ");
INSERT INTO nna_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Palangulu wurrarnarnangu yija, palakapali jinirni, kurlu jinirni. Munu kuku jarrrimarnangu nyuntunga, kurlka jarrinyirni wurralamarnangu kurlurrangu jinirni. Wurrarnarnangu, “Milya kaniny jarrinyarnangu kurntanyjartiny.” Palajalu puru ngakarninyin ngalypalu kakuputu. ");
INSERT INTO nna_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Palajalu nyuntumili marrngurrangu, palarrangu marrngu miranu nyuntuku, wurranaku nyuntungu nganijartiny muwarrjartiny. Janalu japirr manaku nyuntu, “Ngarrka, ngani jilamarnajanaku nyungurrangu?” Palaja jilipiyi, ngalypa yankulupiyi. Nganipa kurlu milpulinyjanaku, ngapikapali mangkurtu mirti jarrulkuliny marrja pijunga, nyuntulu kalkulumanjaninyi tukulu. Pala mangkurtu munu kanka jarrulinyjanaku, munu kangkulinyjaninyi warnan-warnan. ");
INSERT INTO nna_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Tuku waninyarni nyuntunga. Nganingamarrapa tuku kalkuluminyin. Purntu marnanyin. Palajalu kurntarnarni marrjalu, “Ngarrkalu tukulu kalkurninyi!” ");
INSERT INTO nna_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","9","Nyampalilu wurrarnaji, “Pinakarraji ngajuku! Munu ngakumpa jarrinyaku yawartakapalipa tangkikapali. Wirriliman purayitul yirranga. Munujalu yankulupiyi warinykurnu. Munu ngakumpa jarruluman janakapali. Wirrilimarnanga purayitul nyuntunga? Munu yiji! Ngajumili muwarrjartinyju miranu jilamarnanta, ngani jilaman. Nyuntulu yirrkulu pinakarrlupijin ngajuku. ");
INSERT INTO nna_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Kurlujartinyju marrngulu yirrkulu kurlu jinayarninyi. Ngarrka yirrkulu karrinyijanaku yajarnayipa punjalu, palinyju tukulu kalkulinyjaninyi. ");
INSERT INTO nna_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Nyurra marrngu ngalypa jininyurru, parrjalayi Ngarrka ngani jini! Pikaly jarrayi, raka jarrayi! Nyurra marrngurrangu, nyurralu yajarnakinyinyurra Ngarrka, kamalayi pikalyjartinyju. ");
INSERT INTO nna_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Marrngu jampa kakarra kurnpungu yananya kawanajalu, tili pirrpa-pirrpa jarrinya kawaninyalu. Palajunkapalingarra nyarra yirnkulu jinakatarrangu jiti miranu jarrinya kawanayalu Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Ngalypakatarrangu marrngurrangulu tukulu kalkunayijaninyi janamilirrangu jarnturrangu. Kurlujartiny marrngurrangulu kurlujartinyju kalkunayijaninyi janamili. ");
INSERT INTO nna_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","...nyarra kurlujartinyngarra ngarrakuny jarrinyalu kurlujartinyku marrnguku. ");
INSERT INTO nna_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Jintalu marrngurrangulu kurlkarri marnayi janalu jinayi jurtulu. Kurlu pinayi yijalu yiji, marlkarri jilkulinyjaninyi. ");
INSERT INTO nna_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Nyarra wirtu kari minpinajalu nyuntu marrja muwarr pinakatapa ngawu jarrinyan. Ngakumpa yiji yawurr jarrinyaku. ");
INSERT INTO nna_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Miranu jilaman partany wunyjurruku waninyaku, palinyju kurlkarri malkuliny kakuputulu. ");
INSERT INTO nna_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","21","Pujamukayi, pinakarra! Jurtulu kurlkarri malapa yijanga jurtungu wantuluman. Munu kulunaku jinta wayinku wirtu minpinakatarrangupa lirrjalkatarrangu mayiku. Marrngurrangulu palajunmartalu pujunurrangu jinayarninyi. ");
INSERT INTO nna_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","35","Ngarnurtu ngarlu kurlu yija? Ngarnurtu pikalymajirri? Ngarnurtu ngarrakuny kulipatininyi? Ngarnurtu ngarrakuny warntakata? Ngarnurtulu kalkuninyi pita watarrkulu pungkanyaja? Ngarnurtulu kalkuninyi pani miji-miji? Nyarrarrangu karikarra waninyayi ngarrakuny, yakurr marnayi wayin warinypa wariny. Nyarra wayin ngalypa yiji parrjanakupa juri yiji yakurr manaku. Munu yiji yirni jarruluman palaku. Nyarra pajinajalu kulikatalu jurrulu nyuntu yija wurrku jarruluman, parra-parra wirtu nyarra juntangulu pajinajalu, palajunngarra wayin minpinajalu nyuntu yija wurrku jarruluman. Nyuntulu parrjalamanjaninyi wirntiji pinakatarrangu miyurrangupa muwarr pilaman ngakumpakapali. Nyarra miranu nyurra puwurtuku kujungurrungu wangalpintijartinyku, makanu yiji pala mungka warlirninyipa pala wangalpinti. Pala mungka rurri-rurrinyi wangalja ngurnarrikurnujirri. Palajunngarra marrngu nyarra yawurr kurirra-kurirra marnti yananyi. Palaja karra malkuliny, “Wirlarninyiyi, munu parra-parra pinakarrimarna. Munumpa ngaju jampa wirlarninyiyi. Nyanga parril jarrulumarna yarrana minpinaku?” ");
INSERT INTO nna_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Partanyjungarra kurlkarri malaman Ngarrka, palinyjungarra jirnanta nyuntu. ");
INSERT INTO nna_vpl VALUES ("IS5_11","024_5_11","ISA","5","11","12","Turlpanyanyurru marntungu kurnpungu wayinku minpinaku, palaja yirrkulu minpinanyurru warrukartingi... Nyurralu kurlkarri marnakanyurru Ngarrka, munu yiji! Munumpa nyurra ngani palinyju jininyi. Palinyju wurrarnanyurraku, “Ngajulu wirlalamarnanyurrinyi marrjalu, ngunjul yiji nyurraku mirti jarrinyakupa kuku jarrinyaku.” ");
INSERT INTO nna_vpl VALUES ("IS38_17","024_38_17","ISA","38","17","17","Puru yakarnanyin kurlujartinyja ngajumilingi. ");
INSERT INTO nna_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","6","Nganyjurrumilakungarra kurlujartinyku paliny Ngarrkalu wirlarna. Ngarrkalu wilypirni palinyngarra, palajun jinajalu nganyjurru wanka jirninganyjurrinyi. Nganyjurrulu wiyirrju ngampanjartinyju nganiwarralpirti jinikinyinyi. Munu wirlarnamanganyjurrinyi, palinyngarra wirlarnanganyjurruku nganyjurrumilaku kurlujartinyku. ");
INSERT INTO nna_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","Nyarra nganyjurrumili ngampankata pirlurr yija yiji mitukata. Ngunjul yiji ngalypa jinaku. ");
INSERT INTO nna_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nyungu wurralamarna muwarr, Jiyijaji Kurayiji marrngu jarrinyi. Pipi palinymili Miyiri yinyayili pilyurr Juwujapungu. Juwujapu mimarnikinyalu kanganyaku palinymilikarti ngurrakarti. Palajanga ngayinykarra jarrinyi. Ngarrkamilalu Pirlurrju partany wirrirnili ngayinyja. Palaja muwarr wurrarniyili Juwujapungu, “Miyiri ngayinykarra wupartujartiny.” ");
INSERT INTO nna_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Juwujapulu kurlkarri marna, “Miyiri karta karrinyikinyi pirirrijartiny. Mirtawaku kangkulumarna munu.” Juwujapu ngalypakata, munu kurntany jinaku karrimalu Miyiriku miranga marrngurrangungu. Kurlkarri marnarningu, “Ngakalamarna warntamajirrilu.” ");
INSERT INTO nna_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Palinyju kurlkarri marnikinyi ngarrany. Palajanga kapukarri marna. Kapukarrilu yirrirni yayinyjil, Ngarrkalu ngakarnalu. Wurrarnala yayinyjilju, “Juwujapukayi! Tayipitimili nyuntu. Pinakarra! Munu ngarlu kurlu jarrulumanpalu Miyiriku mirtawaku. Ngarrkamilalu Pirlurrju partany yinyali. Palajalu paliny kalkuluman mirtawa nyuntuku. ");
INSERT INTO nna_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Partany pirirri kangkuliny. Yini malaman Jiyijaji. Marrngurrangu panypanyakatarrangu Ngarrkanga. Palajunjalu Ngarrkalu ngakalajaninyili ngarramarnti. Jiyijajilu kartuwarra malkulinyjaninyi.” Palajun yayinyjilju muwarr pinalu Juwujapuku. ");
INSERT INTO nna_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Purlpilu muwarr Ngarrkaja muwarr pini pirirrilu: “Kumpara, munu ngarrany karta karrima pirirringi, ngayinykarra jarruliny. Partany pirirri kangkuliny. Yini malapiyi Yimanyuwil.” Juwumilingi muwarrja pala yini Ngarrka Nganyjurrungu Waninyi. Palaja Jiyijaji ngayarta jarrinyaja, palaku muwarrku jana miranu, Jiyijajingarra. ");
INSERT INTO nna_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Juwujapu kartaja turlpanya, yayinyjilmilija muwarrja jini. Miriyi kanya palinymilikarti ngurrakarti. Warajanga jiniyipulinyi pirirripa mirtawa. ");
INSERT INTO nna_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Palajanga munu warajanga karta karrimapulu. Mimarnikinyipulalu partanyku ngayarta jarrinyaku. Juwujapulu yini marna partany pala Jiyijaji. ");
INSERT INTO nna_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Palajanga Kingi Yarata nyampali waninyikinyi marrngurranguku palanga warrarnja, Jutiyanga. Palarrangulu marrngulu yini marnikinyiyarninyi Juwurrangu. Palanga Miyirilu partany kanya Jiyijaji tawunja Pijiliyamungu. Jiyijaji ngayarta jarrinyaja jinta pirirrimarta ngajarri warinyja warrarnja kakarraja turlpanyiyi kanyjinaku palinyku. Nyungurrangu pirirrimarta miranukata jana panikatarranguku. Yijalu yirrirniyi panikata kuwarrija parlparrja. Palalungarra kurlkapirli jinijaninyi, nyampali wirtu ngayarta jarrinyi Juwurranguku. Warrarn janamili yakarnayi palaku partanyku yirrinaku. Jirujalamungu kajarniyi. Japirr marnikinyiyijaninyi, ");
INSERT INTO nna_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Wanyjarningi partany pirirri, nyarra nyampali, kingi jarrulunyurraku Juwurranguku? Nganarnalu yirrirniyirni panikata palinymili kakarnilu. Yirrinaja miranu jarrinyiyirni wirtuku nyampaliku ngayarta jarrinyajaku, partany wupartu ngarrany jarrinyi paliny. Nganarna turlpanyiyirni yirrinaku, paliny yinganyapinti yinganyaku.” ");
INSERT INTO nna_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jampa Kingi Yaratalu pinakarrinyijanaku muwarr, yija ngarlu kurlu jarrinyi. Marrngu wiyirr Jirujalamungu pukun ngayiny kurlu jarrinyiyi. ");
INSERT INTO nna_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kuru marnajaninyi yatilarrangupa miranu jinakatarrangu Juwumili Yaratalu. “Pala marrngu wirtu, ngakalkuliny Ngarrkalu, wanyjarningi ngayarta jarruliny?” ");
INSERT INTO nna_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Puntaju wurrarniyili, “Nyungungu ngayarta jarruliny, warrarnja Jutiyanga, tawunja Pijiliyamungu. Purlpi warinyju Ngarrkamilalu muwarr pinakatalu yarntarna muwarr mirli-mirlingi, ");
INSERT INTO nna_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'Marrngurrangu Pijiliyamungu, nyurramili ngurra wupartu yiji. Ngarrkalu ngakalkuliny wirtu yiji nyampali, paliny ngayarta jarruliny nyurramilingi ngurranga. Paliny nyampali jarruliny Ngarrkamilaku marrngurranguku. Palaja wiyirr nyurramilaku ngurraku miranu wantulupiyi.' Palajunngarra muwarr yarntarna Ngarrkaja.” ");
INSERT INTO nna_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yarata miranu jarrinyaku karrinyikinyi, nyanga ngayarta jarrinyi Jiyijaji. Palaja muwarr ngakarnajanaku kukujarrilu ngajarrirranguku kakarrajaku milpanyaku. Japirr marnajaninyi mitulu pukun, “Nyanga pala panikata ngayarta jarrinyi?” ");
INSERT INTO nna_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Palaja Pijiliyamukarti ngakarnajaninyi. “Yarrayi Pijiliyamukarti, kanyjiliyalu tukulu palaku partanyku. Palaja nyungukarti kulpayi, wurralijiyi wanyjarningi paliny. Palaja yankulumarna palakarti, yirrilamarnalu ngajulu yiji, yinganyapinti yungkulumarna pukun.” Yijalu yiji mitu marnajaninyi, partanyku Jiyijajiku marlkarri jinaku karrinyikinyi. ");
INSERT INTO nna_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Palaja yananya kawarniyi Pijiliyamukarti. Pala warajangarra nyarra panikata yirrirniyi, yananyikinyijanaku walangkarr. Palanga kankarni yiji wararr karrinyi mayanga partanyjartinyja. ");
INSERT INTO nna_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Panikata yirrinajalu pikaly jarrinyiyi yiji. ");
INSERT INTO nna_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mayanga ngalpanyiyi kaninykurti. Palaja yirrirniyi partany, pipilu palinymilalu Miyirilu kalkurnikinyi. Murtingi jurlpi-jurlpi jarrinyiyalu partanyku. Janalu yinyayili miji-mijipa mintajirri pukurl, ngalypa parntinyikinyipulu. ");
INSERT INTO nna_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Palaja Ngarrka muwarr pinijanaku kapukarringi. Wurrarnajanaku munu kulpanyaku Yaratakarti. Palaja kulpanyiyi janamilikarti waljakarti warrarnkarti warinykurnu. ");
INSERT INTO nna_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Warrukartingi Juwujapulu kapukarri marna. Yayinyjil Ngarrkaja turlpanyalu. Wurrarnala, “Yaratalu kanyjilkulinypalu partanyku marlkarri wirlanaku. Kuwarringarra turlpa. Kawapulinyi partanypa pipimurniny, mujarri warinykarti warrarnkarti, Yijipikarti. Wantulunyurru palanga. Yarti ngajulu wurralamarnanyurraku kulpanyaku nyungukarti.” Palajun yayinyjil muwarr pinalu. ");
INSERT INTO nna_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Juwujapu kartaja turlpanya. Kanyapulinyi pala partanypa pipimurniny, yanayi warrukartingi. Yanayi Yijipikartijakun. ");
INSERT INTO nna_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","21","Palanga warrarnja waninyikinyiyi Yaratajanga wankanyungu ngarrany. Yaratalu partarl mimarnikinyijanaku marrnguku kakarrajaku. Munu kulpamiyalu, munu wurrarnamiyili pala Pijiliyamungu ngurra Jiyijajipa waninyikinyi. Palaja paliny yija-yiji kuli jarrinyi. Purlpi japirr marnajaninyi kakarraja ngajarrirrangu, “Nyanga pala panikata ngayarta jarrinyi?” Kuwarri kurlkarri marnarningu, “Nyarra panikata ngayarta jarrinyi warajanga ngurnipali partunungu. Partany pirirri wiyirr Pijiliyamungu wirlalamarnajaninyi kujarramajirri partunumajirri, kujarrajartiny partunujartinyarrangu pukun, yijalu wirlalamarnajaninyi marlkarri wiyirr.” Palajalu kamarnajanaku palinymili jurljarranguku. “Pinakarrayi! Pijiliyamukarti yarrayi. Palanga wirlaliyijaninyi wiyirr partany pirirrirrangu kujarramajirri partunumajirrirrangu, kujarrajartiny partunujartinyarrangu pukun wirlaliyijaninyi. Munu waraja yakalkulunyurru wankanyu.” Palarrangulu jurljalu palajun jiniyi, Yaratamilija muwarrja. Palaja marrngurrangu Pijiliyamungu ngangkurl jinikinyiyi yiji partanykarranguku janamilaku. Purlpi yiji Ngarrkamili muwarr pinakata, ngapi, Jirimaya, muwarr pini, “Palanga warrarnja, ngapingi, Ramanga, palanga ngangkurl pinakarrinyiyi. Wariny marrja ngangkurl jininyi. Pala purlpija mirtawa, Rayijil, ngangkurl jininyi paliny, partanykarranguku palinymilaku ngangkurl jininyi yiji. Jintalu kanyayijaninyi. Ngangkurl jinijanaku ngarramarnti.” Palarrangu muwarrarrangu Rayijil mirli-mirlingi yarntarna nyarralu Jirimayalu. Kuwarri palakapali yiji palarrangu marrngu Pijiliyamungu janamilaku partanykarranguku ngangkurl jinikinyijanaku marrja, palajunmarta. Palaja Yarata marlkarri jarrinyi. Yijipingi Juwujapulu kapukarringi yirrirni yayinyjil, Ngarrkalu ngakarna. Wurrarnili, “Pirirri nyarra karrinyikinyalu Jiyijajiku marlkarriku wirlanaku, palinyngarra marlkarri jarrinyi. Turlpa. Kawapulinyi partanymurninypa pipimurniny, kulpayi nyurramilikarti warrarn waljakarti, Yijirayilkarti.” Turlpanya Juwujapu kartaja, kanyapulinyi warrarnkarti waljakarti, Yijirayilkarti. Purlpi yiji wariny Ngarrkamili muwarr pinakata muwarr pini, “Ngarrkalu kanya palinymili partany pirirri Yijipija.” Yarti Jiyijaji Yijipija warrarnkarti waljakarti kulpanyaja, miranu jarrinyiyi marrngurrangu nyarraku purlpijaku muwarrku, pala muwarr wurarna Jiyijajingarra. ");
INSERT INTO nna_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Turlpanyaja Yijirayilja Juwujapulu pinakarrinyi muwarr, partany Yaratamili, ngapi, Yaakala, nyampali jarrinyijanaku marrngurranguku palanga, warrarnja Jutiyanga. Palaja muwarrja wirnti karrinyikinyi palanga warrarnja waninyaku Juwujapu. Kapukarringi Ngarrka muwarr pinalu, palaja muwarrja pipurru yana yalinyjikurnu, warrarnkarti Kaliliyikarti. ");
INSERT INTO nna_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ngurrara jarrinyi tawunja Najarijingi. Purlpi yiji Ngarrkamili muwarr pinakata muwarr pinikinyiyi Jiyijaji, “Wurralapiya paliny, Najarijipirrayi ngurrara”. ");
INSERT INTO nna_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Nyarra kiyirti Ngarrkamilikarti warrarnkarti wujukata yiji. Ngalpanyaku palangangarra. Wariny nyarra kiyirti walpurra, pala nyarra wikakarti wirtukarti, ruwurtu palakarti ngunjulmajirri. Kurrngal marrngurrangu yananyayi palanga ruwurtungu. Kiyirti nyarra Ngarrkamilikarti warrarnkarti wujukatapa ruwurtu palakarti ngunjul-ngunjulmarta. Kujarrapa warajalu marrngurrangulu yirnkulu yirrirnayi pala ruwurtu. ");
INSERT INTO nna_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","31","Marrngulu marlkarri wirlalayintili kawu nyuntu. Wirntiwayi janangamarra. Munu yiji pirlurr nyuntumili marlkarri wirlarnakayinga. Ngarrkakujakun wirnti wanta. Palinyju kampalantili pirlurrpa kawu, Wikanga Wirtungu jurnpakartijakun. Marrngulu munu palajun jinaka. Palajunjalu wirntimajirri wantajanaku. Nyuntumili Japartu Kankajirringi miranu ngani wurralpirtiku. Nyinyirikupa jungkanga pungkanyajaku paliny miranu. Yija paliny miranu nyuntuku pukun. Kurlkuraku jurnturtungu nyuntumilaku paliny miranu, warajapa warajaku, wiyirrku. Palajunjalu wirntiwayi wanta. Nyinyiri puru kurlkarri marninyi Ngarrkalu, nyuntu yijalu yiji kakuputulu kurlkarri marnanti. ");
INSERT INTO nna_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","“Ngunjulkata marrngukayi milpaji ngajukarti, ngunjul wupartumarta jilamarnanga. Kululanyi ngaju, ngalilu ngalypa jilapali...Miranu jarra ngajuja, ngaju tukukatapa rakawayikata... ");
INSERT INTO nna_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jiyijajilu karra marnajanaku, “Ngajulu karrinyarnijanaku partanykarranguku milpanyaku ngajukartiku, munu kurnta jilkulunyurrujaninyi. Ngarlungu jananga yija yiji Ngarrka, janalu pinakarrinyayalu yijalu yiji palinyku. Ngarrkamilirrangulu marrngurrangulu yakujunngarra yija yiji jilkulupiyi.” ");
INSERT INTO nna_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ngalypakata muwarr nyungu, miranu jinarninyurrinyi Jesus-ku. Walja partany Ngarrkamili paliny. ");
INSERT INTO nna_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Purlpimalu Ngarrka muwarr pirnalu pirirriku, yini paliny Isaiah. Palinyja wurrarnala Ngarrkalu, “Nyampali ngakalamarnajanaku marrngurranguku. Wariny palaji walangkarr ngakalamarnalu pala nyampalingi, muwarrjartiny janaku. Pala walangkarr pirirri wantuliny pirranga. Paliny muwarr pilkulinyjanaku, 'Nganyjurrumili nyampali milpuliny. Yarni malayalu jurtu ruwurtu.'” Palajun Ngarrka muwarr pirnalu Isaiah-ku. Palalu Isaiah-lu yarntarnajanaku pala muwarr mirli-mirlingi. ");
INSERT INTO nna_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Punjaja yiji pala marrngu kuwarri milpanya. Yini paliny John. Wurrupirrayi kamalja kurlkura palinymili. Karnulu kunyji pinapintilu nyikarra kunymarnikinyarninyi. Mayi pirraja nganinyikinyi, wajapipa narnngurla. Kurrngal yiji milpanyikinyiyalu pinakarrinyaku John-ku. Warrarnja Judea-japa milpanyikinyiyalu, wirtuja tawunja pukurl, ngapija, Jerusalem-ja. Wurrarnikinyijanaku, “Nyurralu panypanyikinyinyurrulu Ngarrkanga. Kurntany jarrayi! Kurlujartiny jirnikinyinyurru. Yakalaya! Yakujani jarrayi, Ngarrkakarti milpayi! Palaja Ngarrkalu munu kulilu yirrilkulunyurrinyi, ngarlu ngalypa jarrulunyurruku paliny. Palaja ngapanga jilamarnanyurrinyi.” Palajunmarta wurrarnikinyijanaku John-ju. John-mili muwarr pinakarrinyajalu warajalupa warajalu wurrarnikinyiyalu Ngarrkanga, “Yijangarra nyuntungu panypanyikinyirnangu. Kurntanyja waninyarnaji. Nyuntukarti kulpanyaku karrinyarnangu.” Palajunmarta wurrarnikinyiyalu Ngarrkanga. Palaja John-ju ngapanga jirnijaninyi pijungu, ngapingi, Jordan-ja. ");
INSERT INTO nna_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","John-ju wurrarnikinyijanaku, “Kuwarrimarta wariny marrngu milpuliny. Paliny yija-yiji wirtu nyampali. Munu ngajukapali, ngaju puru yiji, mujuja. Nyungu wariny nyampali wirtu. Ngajulu munu yiji jujika palinymili nyinga manaku. ");
INSERT INTO nna_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngajulu puru ngapanga jinarninyurrinyi. Nyungu warinyju ngakalkulunyurruku Ngarrka Pirlurr.” Palajunmarta wurrarnikinyijanaku John-ju. ");
INSERT INTO nna_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Palaja Jesus milpanyili John-karti tawunja Nazareth-ja, warrarnja Galilee-ja. Palanga John-ju ngapanga jirni Jesus palanga pijungu Jordan-ja. ");
INSERT INTO nna_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus ngapaja turlpanyajanga kanka parrjarna. Yirrinajanga parlparr laarr pirni Ngarrkalu. Ngarrka Pirlurr kaninykurnu milpanyala Jesus-karti kurlukukukapali, palinyja kajarnala. ");
INSERT INTO nna_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kankajirrija Ngarrkalu muwarr pirnalu Jesus-ku, “Nyuntu partany ngajumili walja yiji. Ngajungu ngarlungu nyuntu. Ngarlu ngalypa jarrinyarnangu.” ");
INSERT INTO nna_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Palaja Ngarrkamilalu Pirlurrju ngakarna Jesus pirrakarti, warrarn marrngumajirrikarti yiji. ");
INSERT INTO nna_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Palanga waninyikinyi karrpurrangungupa warrukartirrangungu 40-ngi. Palanga waninyajanga yija mirurrulu wirtulu partarl jakurlirnikinya panypanyaku Ngarrkamilaku muwarrku. Munu. Jesus kurlumajirri waninyi ngarramarnti. Kuwiyirrangu kulijarturrangupa pajinakata palanga waninyikinyiyi. Ngarrkalu ngakarnajaninyi angel-arrangu kankajirrija palinyku tuku kalkunaku. ");
INSERT INTO nna_vpl VALUES ("MK1_14a","071_1_14a","MRK","1","14a","14a","Nyampali wirtu Jew-arranguku, King Herod, kuli jarrinyalu John-ku. Wurrarnajanaku soldier-nga, “John warlinakanu jurntingi wirriliyi.” ");
INSERT INTO nna_vpl VALUES ("MK1_14b","071_1_14b","MRK","1","14b","14b","Palaja Jesus-ju yakarna pala warrarn, Judea, yalinyjikurnu yana warrarnkarti, Galilee-karti. Palanga kurrngalja wurrarnikinyijanaku Ngarrkamili muwarr. ");
INSERT INTO nna_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Karra marnikinyijanaku, “Pinakarrayi! Muwarr ngalypakata Ngarrkaja wurrarnarnanyurruku. Nyurralu panypanyikinyinyurrulu Ngarrkanga, munu pinakarrimanyurrulu. Kurntany jarrayi! Kurlujartiny jirnikinyinyurru. Yakalaya! Yijalmarta jiliyalu muwarrja palinymilingi ngalypakatanga. Puntaju pikaly jarrulunyurruku. Palinymilirrangu jilkulunyurrinyi. Nyungukungarra muwarrku purlpija yiji punja mimarnikinyiyi nganyjurrumilalu purlpijalu marlkarrinyjarrilupa kurlumapulu. Nyungukungarra nyurralu pukurl mimarnikinyinyurru.” Palajunmarta wurrarnikinyijanaku Jesus-ju. ");
INSERT INTO nna_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ngarti-ngartingi janpanga yananyikinyi Yintanga Galilee-ngi. Janpa wirtujina pala. Janpamaluku mananyakatajirri yirrirnipulinyi, Simon-pa marrka palinymili Andrew. Parru-parrulu janpamalu mananyikinyipulu. ");
INSERT INTO nna_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wurrarnapulaku Jesus-ju, “Yajalaminyinyumpulu. Ngajulu miranu jilamarnanyumpulinyi Ngarrkaku. Palaja jintanga wurralkulunyumpulujanaku. Yijalmarta jilipiyili Ngarrkanga muwarrja nyumpalamilija, Ngarrkamilirrangu jarrulupiyi. Purlpi parru-parrulu kanganyikinyinyumpulujaninyi janpamalu jungkakarti. Kuwarringulu muwarrju kangkulunyumpulujaninyi marrngu Ngarrkakarti.” ");
INSERT INTO nna_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Palangangarra parru-parru yakarnapulu palinymilija muwarrja, yajarnapulu. ");
INSERT INTO nna_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Palaja jampangarra wangka yana Jesus, warinyjirri yirrirnipulinyi, James-pa marrka palinymili John. Pulanymili japartumurniny yini Zebedee. Tingkingi pulany kajarnikinyiyi japartumurninypa palinymili warrkamukatarrangu. Parru-parru laarr kanganyaja yarni marnikinyiya. ");
INSERT INTO nna_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Palangangarra James-pa John kayi marnapulinyi Jesus-ju. Palinymilija muwarrja palangangarra tingkingi japartumurniny yakarnapulu, warrkamukatarrangupa yakarnapulujaninyi, yajarnapulu Jesus pulanyju. ");
INSERT INTO nna_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Palaja Jesus-ja yanayi palarrangu palakarti tawunkarti, ngapikarti, Capernaum-karti. Palanga milpanyiyi. Sabbath jarrinyi. Sabbath-ja munu warrkamu jarrimiyi marrngurrangulu Jew-arrangulu. Pala manguny janamili. Sabbath waninyikinyijanaku Ngarrkamilaku muwarrku kurlkarri manaku. Town-arrangungu kunmu jarrinyikinyiyi muwarrpintingi mayanga pinakarrinyaku muwarrku Ngarrkamilakupa muwarr pinaku Ngarrkaku. Palanga Capernaum-ja Sabbath jarrinyijanaku, Jesus janamili muwarrpintingi mayanga kaninykarti ngalpanya. Miranu jirnikinyijaninyi Ngarrkaku. Marrngurrangulu pinakarrinyikinyiyalu. ");
INSERT INTO nna_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ngurnjul-ngurnjul jarrinyiyili palinymilija muwarrja. “Yijarla wariny. Nyungu pirirri muwarr jurtukata yiji. Munu nganyjurrumili miranu jinakatarrangukapali. Jana puru muwarr pinakata warinyarrangumilaku muwarrku. Nyungulu Jesus-ju miranu jinanganyjurrinyi jurtulu muwarrju. Yijalu wurrarnili palajun muwarr pinaku Ngarrkalu.” ");
INSERT INTO nna_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Palangangarra ngalpanya muwarrpintingi mayanga pirirri. Mirurrulu ngawu jirnikinyi paliny. ");
INSERT INTO nna_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wirntijartiny paliny, kamarnalu marrjalu, “Jesus Nazareth-ja! Nganiku karrinyannganaku mirurrurranguku? Milpanya wirlalamannganinyi marlkarri jinaku nganarnaku? Miranu ngaju nyuntuku. Ngakarnanta Ngarrkalu. Nyuntu kurlumajirrikata yija Ngarrkamili.” ");
INSERT INTO nna_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus-ju warnta marna pala mirurru, “Jama jarra! Pirirri yakala! Jalakarti yarra!” ");
INSERT INTO nna_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mirurrulu jinarn-jinarn pinakata jirni yija pirirri, palaja kamarna marrja, yakarnalu, yana ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jesus-ku ngurnjul jarrinyiyalu marrngurrangu wiyirr. Wurrarnayarningu, “Nganirti nyungu? Warinymarta muwarr. Muwarr jurtukata paliny. Muwarr wurralili palinyju, nganipa muwarrja palinymilija jirniyili mirurrurrangulu pukun.” ");
INSERT INTO nna_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Palanga Jesus-mili muwarr yitinykarra wurrarna kawarnikinyiyarningu ngunarrikurnujirri warrarnja Galilee-ngi. ");
INSERT INTO nna_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yakanakanu pala muwarrpinti maya Jesus yana ngurrakarti pulanymilikarti, Simon-milipa Andrew-milikarti. Yanapulu pulany pukurl, palajirri warinyjirri, James-pa John. ");
INSERT INTO nna_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon-mili marrukumurniny wurrku waninyikinyi. Mayanga karta karrinyikinyi, parrpakarrajartiny wurrkujartiny. Jampa milpanya Jesus, wurrarniyili pala. ");
INSERT INTO nna_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yanalu, parirr warlirni Jesus-ju, mirtawa wararr karrinyi. Palangangarra wurrkulu yakarna, ngalypa marntiku jarrinyi, mayi kanyajanaku. ");
INSERT INTO nna_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jampa karrpu kaniny ngalpanyaja, warrurl-warrurl jarrinyaja, Jesus-karti kanganyikinyiyijaninyi kurrngal, jinta wurrkujartiny, jinta ngawurrangu mirurruja. ");
INSERT INTO nna_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Marrngurrangu palanga kunmu jarrinyiyi, mayanga jawapirtingi wiyirr milpanyiyili. ");
INSERT INTO nna_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus-ju kurrngal warinypa warinyjartiny wurrkujartiny ngalypa jirnijaninyi, kurrngaljapa jurtu ngakarnajaninyi mirurrurrangu. Miranu waninyiyalu palinyku. Palajalu mirurrurrangu muwarrku kunta jirnijaninyi Jesus-ju. ");
INSERT INTO nna_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Marntungu, karrpumajirri, Jesus kartaja turlpanya, maya yakarna. Palaja tawun yakarna. Jalakarti tawunja, pirrakarti yana, kujurl. Palanga muwarr pirnalu Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kanyjirnikinyiyalu Jesus-ku Simon-jupa warinyarrangulu. ");
INSERT INTO nna_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yirrinajalu wurrarniyili, “Wiyirrju kanyjirnikinyiyangu.” ");
INSERT INTO nna_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wurrarnajanaku, “Munu kuwarri Capernaum-karti kulpuluminyi. Town-arrangukarti warinyarrangukarti yankuluminyi, wurralamarnajanaku Ngarrka. Palajunku jinaku ngakarnanyi Ngarrkalu.” ");
INSERT INTO nna_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilee-ngi yana-yananyikinyijanaku, muwarrpintingi mayarrangungu kurrngal miranu jirnikinyijaninyi Ngarrkakupa jurtu ngakarnikinyijaninyi mirurrurrangu. ");
INSERT INTO nna_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Warajanga karrpungu pirirri milpanyili Jesus-karti. Wurrkujartiny, kurlu yiji karnu paliny. Mangunyja Jew-arrangumilija wiyirr palajartiny wurrkujartiny jalanga kaja waninyaku, kujurl yija, munu ngurranga ngalpanyaku. Pala marrngu milpanyakanu murtingi jurlpi-jurlpi jarrinyalu, ngarlu japirr marna Jesus, “Wanka jiliminyinkurra, karnu ngaju ngalypa jiliminyin. Wunyjurru nyuntulu karrinyanpa?” ");
INSERT INTO nna_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus paju karrinyili. Parirr jirranakanu wurrkujartiny warlirni. “Yuu, karrinyarnangu ngalypa jinaku. Kapuraly yiji jilamarnanta.” ");
INSERT INTO nna_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jampangarra pala wurrku munu jarrinyalu, karnu kapuraly jarrinyi pala marrngu. ");
INSERT INTO nna_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Minyirrju wurrarnala Jesus-ju, “Pinakarra! ");
INSERT INTO nna_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Munu wurralamanjanaku ngalypa jirnirninti ngajulu. Pipurru yatilkarti yarra. Palinyju yijalu parrjalamanta yitinykarra kawu nyuntu, nyuntu karnu kapuraly. Nyuntu miranu palaku mangunyku nyuntumilaku wurrkuku. Purlpimalu Ngarrkalu wurrarnalu Moses-ja mirli-mirlingi yarntanaku. Palinyja muwarrja kukurnjari wankanyu yatilkarti kangkuluman. Palalu yatilju kampalkuliny tikirlkarti, jurnpakartijakun. Palajalu jintalu marrngurrangulu pala yirrinajalu nyuntuku miranu wantulupiyangu, kapuraly nyuntu, wurrkumajirri. Palaja yarranakanu ngurranga ngalpuluman.” Palajun wurrarnili Jesus-ju. Palaja ngakarna yatilkarti. ");
INSERT INTO nna_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pala pirirri munu jama wanima. Panypanyili Jesus-ja. Marntilu yirrkulu wurrarnikinyijanaku nyarrakurnujirri, “Jesus-ju ngalypa jirninyi karnu ngaju.” Palaja muwarrja Jesus munu tawunarrangukarti yanama, munu ngalpama, kurrngaljamarra marrngungamarra. Warrarnja waninyikinyi jalanga. Yirrku milpanyikinyiyalu marrngurrangu ngunarrikurnujirrija. ");
INSERT INTO nna_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Palaja tawunkarti kulpanya Jesus, Capernaum-karti. Palanga wurrarnikinyiyarningu, “Jesus kulpanya!” ");
INSERT INTO nna_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kurrngal palinymilikarti mayakarti milpanyiyi, palinyku pinakarrinyaku. Miranu jirnikinyijaninyi palinyju Ngarrkaku. Marrngurrangu kaninykurti palanga mayanga kurrngal yija, jinta kurrngal jalakartingi palakurtirri wararr karrinyikinyiyi, pinakarrinyikinyiyalu. ");
INSERT INTO nna_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Palanga milpanyiyi marrngu kujarrapa kujarra. Pirirri wurrkujartiny kanganyikinyiyi ngurrinyja, manyurla yija paliny, munu marnti yananyaka. Kanyayili Jesus-karti ngalypa jinaku. ");
INSERT INTO nna_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Partarl ngalpanyiyi mayanga, palanga kurrngal waninyikinyiyi. Wararr karrinyikinyiyi kurrngal yija Jesus-martaji. Palaja kankarni mayanga karntinyiyi. Pirli jirniyi Jesus-martaji kankarni, wurrkujartiny kaninykurnu jirniyi ngurrinyja, Jesus-ja walangkarr. ");
INSERT INTO nna_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Karra marnarningu Jesus-ju, “Yijalmarta jirnijiyi nyungu wurrkujartiny ngalypa jilamarna.” Palaja ngalypalu wurrarnili wurrkujartinyja, “Nyuntulu purlpi panypanyikinyinpili Ngarrkanga. Puntaju munu wirlalamarnanta ngajulu, munu kulilu yirrilamarnanta, nyuntuku ngalypa wantulumarnangu.” ");
INSERT INTO nna_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mayanga palanga kajarnikinyiyi Jew-arrangumili miranu jinakatarrangu kujarrapa waraja. Ngarlu kurlu jarrinyiyi Jesus-ku muwarrku. Kurlkarri marnikinyiyarninyi, ");
INSERT INTO nna_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Munu palajun muwarr pinaku! Karra marnalu, 'Nyuntulu purlpi panypanyikinyinpili Ngarrkanga. Puntaju munu wirlalamarnanta ngajulu, nyuntuku ngalypa wantulumarnangu.' Palajunngarra karra marna. Kurlu yiji muwarr pirni paliny. Ngarrkajakurl palajun muwarr pinaku. Marrngurrangulu munu jinakayi palajunju. Palalungarra Jesus-ju Ngarrkakapali jinarninyi!” ");
INSERT INTO nna_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Janaku miranu Jesus, palajun kurlkarri marnikinyiya janalu, palajunmarta paliny yimpirnikinyiyi. Japirr marnajaninyi, “Nganijalu nyurralu yimpirninyinyurru ngaju palajunju? Wurrarnarnala nyungungu pirirringi, 'Nyuntulu purlpi panypanyikinyinpili Ngarrkanga. Puntaju munu wirlalamarnanta ngajulu, ngalypa wantulumarnangu'. Nyurralu wurrarnanyurru palajun munu wurranaku ngajulu. Wunyjurru muwarr pilamarnalu wurrkujartinyku nyunguku? Yijapa wurralamarnalu, 'Wararr karruluman, ngurriny mankuluman, jinangu yankuluman'. Wayirti? Palinyja palajun wurranaku ngajulu? Muwarrja ngajumilija ngalypa jarrulinypa? Wurrkumajirri jarruliny? ");
INSERT INTO nna_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yuu! Kuwarringarra ngalypa jilamarna nyungu wurrkujartiny. Palajalu wantulunyurru ngajuku miranu, ngajungu yija wurrarnaji Ngarrkalungarra paliny ngalypa jinaku. Wantulunyurru ngajuku miranu, ngajungu yija wurrarnaji Ngarrkalungarra marrnguku kurlujartinyjaku puru yakanaku, janaku ngalypa waninyaku.” Palaja wurrkujartinyja wurrarnala Jesus-ju, ");
INSERT INTO nna_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wararr karruluman, ngurriny mankuluman, ngurrakarti nyuntumilikarti yankuluman.” ");
INSERT INTO nna_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Palangangarra wararr karrinyi pala pirirri, ngurriny mana, jalakarti yana pipurru. Yananya kawanaja wiyirrju parrjarnikinyiyi. Wurrarnikinyiya, “Ngalypa jirni Jesus-ju! Kuwarrijakun! Munu nyungu yirrirniminyi!” Nyurra marnikinyiya Ngarrka, muwarr pirnikinyiyalu, “Yarranijayi! Yija-yiji nyuntu ngalypa!” ");
INSERT INTO nna_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yarranakanu Jesus wirtu ngapamartaji ngarti-ngartingi yananyikinyi, Yintanga Galilee-ngi. Marrngu kurrngal kunmu jarrinyiyili palinyja. Miranu jirnikinyijaninyi Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","15","Kurrngalju Jew-arrangumili mangunyja panypanyakatarrangulu yajarnikinyiyi Jesus. Jananga jinta warnkuku miranakatarrangu. Warrkamu jirnikinyiyi Roman Government-ku palarrangulu, warnkuku mirarnikinyiyijaninyi marrngu Government-milija muwarrja. Ngulyu mananyakata jana. Warnkuku wirtumartaku mirarnikinyiyijaninyi, jinta yinganyikinyiyalu nyampali, jinta kalkurnikinyiyarningu. Karrpurrangu karrpungu Jesus yajarnikinyiyi palarrangukapalilu kurrngalju Jew-arrangumili mangunyja panypanyakatarrangulu pukun. Warajanga karrpungu Yintanga Galilee-ngi Jesus yananyikinyi. Marrngu yirrirni, warnkuku miranakata, paliny yini Levi. Nyungu Levi mayanga warrkamupintingi palinymilingi kajarnikinyi. Yirrinajalu Jesus-ju wurrarnala, “Yajalaminyin ngaju.” Palangangarra warrkamu yakarna palinyju, Jesus yajana kawarna. Palaja Levi-milikarti mayakarti yana Jesus mayiku ngananyaku. Jinta warnkuku miranakatarrangu pukurl milpanyiyi, warinyarrangupa Jew-arrangumili mangunyja panypanyakatarrangu, mayiku ngananyaku palanga. ");
INSERT INTO nna_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Warinyarrangu Jew-arrangumili miranu jinakatarrangu wangka wararr karrinyiyi. Yini marnikinyiyarninyi Pharisee-rrangu. Parrjarniyi Jesus-ju ngananyijanaku palarrangungu Jew-arrangumili mangunyja panypanyakatarrangungu. Wurrarniyijanaku Jesus-milingi marrngurrangungu, “Jesus-ju munu mayi ngananyaku warnkuku miranakatarrangungupa mangunyja panypanyakatarrangungu. Kurlu jirninyi.” Palajun muwarr pirnikinyiyi Pharisee-rrangu. ");
INSERT INTO nna_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pinakarrinyijaninyi Jesus-ju. Puntaju karra marnajanaku, “Maparnkarra munu milpuliny wanka jinaku purrpurnkatarranguku, milpuliny wurrkukatarrangukujakun. Palakapali jinarni ngajulu. Munu milpamarna ngalypakatarranguku kayi manaku Ngarrkakarti. Milpanyarna ngaju Ngarrkanga panypanyakatarranguku kayi manaku Ngarrkakarti, muwarrja palinymilija. Palajalu ngananyarnijanaku palarrangungu.” ");
INSERT INTO nna_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Palaja yarrana muwarrpintingi mayanga ngalpanya Jesus. Sabbath pala karrpu. Palanga mayanga pirirri parirr kurluny-kurluny, tikirlkata, munu rurrinyaka parirr. ");
INSERT INTO nna_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Palanga kajarnayi Pharisee-rrangu pukurl, kujarrapa waraja. Jesus-ku malyparr waninyikinyiyalu. Parrjarn-parrjarnikinyiya. Wurrarnikinyiyarningu, “Kuwarri Sabbath. Yijapa ngalypa jilkuliny wurrkujartiny. Nganyjurrumilija mangunyja pala kurlu. Munu wurrkujartiny ngalypa jinaku Sabbath-ja. Palajun jinaja ngukarriliminyi yija.” Palajunmarta wurrarnikinyiyarningu palarrangulu Pharisee-rrangulu. ");
INSERT INTO nna_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pala pirirringi wurrarnala Jesus-ju, parirr kurluny-kurlunyjartinyja, “Yakujani, nyungukarti milpuluman.” ");
INSERT INTO nna_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","5","Palaja Pharisee-rrangungu wurrarnajanaku, “Pinakarrayi! Miranu nyurra Sabbath-ku, karrpu nganyjurrumili warrkamumajirriku. Ngarrkamilija muwarrja pala. Yuu, mangunyja nganyjurrumilija, wunyjurru jiliminyijanaku marrnguku Sabbath-ja? Ngalypa jiliminyijanaku? Kurlu jiliminyijanaku? Wanka jiliminyijaninyi? Wirlalaminyijaninyi? Wunyjurru? Wurraliyi.” Munu puntaju muwarr pirnamiyalu. Jama waninyikinyiyalu. Pajuwayikatarrangupa jalypakatarrangu jana. Palajalu Jesus-ju kulilu yirrirnijaninyi. Paliny paju karrinyijanaku pukun. Palaja pirirringi parirr kurluny-kurlunyja wurrarnala, “Parirr jirrala.” Parirr jirrarna, ngalypa jarrinyi. ");
INSERT INTO nna_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Palaja palarrangu Pharisee-rrangu yunturi jarrinyiyalu Jesus-ku. Yananya kawarnayi kurrnganaku jintanga, ngapingi, Herod-milingirrangu marrngurrangungu. Kunmu jarrinyiyi, kurrngarnayarningu, “Wunyjurrulu Jesus marlkarri wirlalaminyi?” ");
INSERT INTO nna_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Palaja Jesus-pa palinymili marrngurrangu janpakarti wirtukarti yanayi, Yintakarti Galilee-karti. Kurrngalju paliny yajarniyi. Milpanyikinyiyi pala wirtuja tawunja, ngapija, Jerusalem-ja, warrarnjirrija Judea-japa Idumea-japa ngunarrija Jordan-ja pijuja, palajirrija tawunjajirripa milpanyikinyiyi, Tyre-japa Jayitunja. Pinakarrinyiyi, “Jesus-ju ngalypa jirnijaninyi wurrkujartinyarrangu.” Palaja milpanyikinyiya kurrngal. ");
INSERT INTO nna_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ngalypa jirnijaninyi wurrkujartiny kurrngal. Wangka yija milpanyikinyiyi palinyku nyinga manaku. Palaja marrngurrangungu palinymilingi wurrarnajanaku Jesus-ju, “Ngurrku malanyiyili. Tingki marrajiya. Kajalamarna palanga ngurrku manangamarra.” ");
INSERT INTO nna_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","12","Jintalu Jesus-karti kanganyikinyiyijaninyi jinta marrngurrangu, ngawurrangu jana. Mirurrurrangulu kanganyikinyiyijaninyi. Jesus jampa yirrinakanu, mirurrurrangulu marrngu parnpirnikinyiyijaninyi jungkanga Jesus-ja walangkarr, wirntilu kamarnikinyiyi, “Jesus! Ngarrkamili partany nyuntu!” Wurrarnikinyijanaku minyirrju mirurrurrangungu, “Jama jarra!” Kurnta jirnikinyijaninyi yini manaku “Ngarrkamili Partany” paliny. ");
INSERT INTO nna_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jarurrukartingi Jesus-ju wurrarnajanaku palinymilirrangungu, “Yankuluminyi kakarrakurnu ngapanga ngunarrikarti.” ");
INSERT INTO nna_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Palajalu yakarniyijaninyi marrngu jinta jungkanga, Jesus ngapanga kanyayi tingkingi. Warinyarrangulu pukurl tingkingirrangu yajarniyijaninyi. ");
INSERT INTO nna_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Yananyajanga Jesus karta karrinyi nyirrirni, ngurrinyja, pilawunga, karta karrinyi yija. Palaja partijirri wangal wirtu yija jarrinyi, ngapa pintura jarrinyi, ngalpanyikinyi tingkingi, winya jarrinyikinyijanaku ngapa. Wirnti yiji jarrinyiyi marrngurrangu Jesus-mili. Mintu jirniya. Wurrarniyili, “Miranu jinakatakayi! Yija kunulinynganyjurrinyi ngapalu. Jampangarra marlkarri jarruluminyi. Wanka jilanganinyi! Nganijalu kakurnannganinyi?” ");
INSERT INTO nna_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus kupalyaja wararr turlpanya, wurrarnapulaku, “Wangalkayi, jupa! Janpakayi, kaniny jarra!” Palinymilija muwarrja wangal jupanya palangangarra, ngapa kaniny jarrinyi palajun, wuta jarrinyi. ");
INSERT INTO nna_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus-ju japirr marnajaninyi marrngurrangu palinymili, “Nganija wirnti jarrinyikinyinyurru? Nganijalu munu yijalmarta jirnimijinyurru?” ");
INSERT INTO nna_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ngurnjurnikinyiyalu yija. Wurrarnayarningu, “Pinakarrinyipulalu wangaljupa ngapalu! Palinymilija muwarrja jupanya kawarna wangalpa kaniny jarrinyi yija ngapa. Yija nyampali paliny ngapakupa wangalku! Nganikapali nyungu Jesus? Nganurtu paliny?” Ngurnjurnikinyiya palajun. Palaja wirnti jarrinyiyalu. ");
INSERT INTO nna_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Yananya kawarnikinyiyi tingkingi, ngunarrikarti ngapanga jarrinyiyi. Warrarn pala yini Geraza. Warnkumarramarra pala, jurntijartiny kurrngaljartiny. Geraza-jalu ngurraralu wirrirnikinyiyijaninyi marlkarrirrangu kaninykurti jurntingirrangu. Milpanyakanu tingkija katukarna Jesus. Palinykarti milpanyili pirirri, ngawukata, mirurrulu kanganyikinyi paliny. ");
INSERT INTO nna_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Kurta yananyikinyi, ngurra marnikinyi kaninykurti jurntingirrangu, marlkarrirrangumartaji. Kulikata yiji jirnikinyi mirurrulu. Purlpi jayinju parirrpa jina partarl kunymarnikinyiya marrngurrangulu. Marrjapanu nganimarta jirnikinyi mirurrulu, jayin ngartarnikinyi palalu pirirrilu. ");
INSERT INTO nna_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yana-yananyikinyi jurntingipa warnkurrangungu karrpungupa warrukartingi. Ngawujartinyju kamarn-kamarnikinyipa warnkulu wirrkarnikinyarninyi. ");
INSERT INTO nna_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nyarralu pirirripirrayilu jampa yirrirni Jesus kajamartaja, mirti jarrinyalu purrpi, murtingi jurlpi-jurlpi jarrinyili walangkarr. ");
INSERT INTO nna_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesus-ju wurrarnili mirurrungu, “Pirirri yakala! Jalakarti yarra!” Pirirrilu marrjalu kamarnalu, “Yakalanyi, Jesus! Ngaju nyuntuku miranu. Nyuntumili japartu kankajirri waninyi, yija nyampali paliny kankakupa ngunarrikurnujirriku. Nyuntu palinymili partany walja! Nganiku karrinyan, wirlalkuluminyin? Ngarlu japirr marnarninti, munu ngakalaminyin wikakarti wirtukarti kampanyaku!” Palajun muwarr pirnili mirurrulu Jesus-ku. ");
INSERT INTO nna_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus-ju japirr marna pirirri, “Nganurtu yini nyuntumili?” Wurrarnili, “Yini ngaju 'Marlu'. Mirurrurrangu kurrngal nganarna.” ");
INSERT INTO nna_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngarlu japirr marnikinyiya, “Munu ngakalamannganinyi nyunguja warrarnja.” ");
INSERT INTO nna_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Palanga mawurlungu ngurr-ngurrarrangu waninyikinyiyi, kurrngal, 2,000, warruly ngananyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jesus ngarlu japirr marnikinyiyi mirurrurrangulu, “Ngurr-ngurrkartirrangu ngakalamannganinyi. Wunyjurru? Ngalpulupiyirnijanaku?” ");
INSERT INTO nna_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Karra marnajanaku, “Yuu, yankulunyurru ngurr-ngurrkarti.” Palangangarra pirirri pala yakarnayi, ngurr-ngurrkarti wiyirr yanayi, ngalpanyiyijanaku mirurrurrangu. Palajangarra warnkuja kaninykurnu mirti jarrinyiyi ngurr-ngurr wiyirr, janpanga ngalpanyiyi pipurru, marlkarri jarrinyiyi ngapanga. ");
INSERT INTO nna_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Marrngurrangu ngurr-ngurrku kalkunakatarrangu jinta pirnayarninyi, wirnti mirti jarrinyiyi. Kurrngalja wurrarniyijanaku tawunjapa warrarnja. Palaja kurrngal yirrinaku milpanyiyi. ");
INSERT INTO nna_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus-karti milpanyajalu yirrirniyi nyarra pirirri ngawukatapa palanga waninyikinyi, Jesus-martaji kajarnikinyi, wurrujartiny, mirurrurrangumajirri, ngawumajirri, ngalypa waninyikinyi. Yirrinakanu wirnti jarrinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jinta palamanga wararr karrinyikinyiyipa. Purlpi yirrirnayijaninyi ngurr-ngurr ngapanga ngalpanyaja. Wurrarniyijanaku jampa milpanyajanga, “Nyungulu Jesus-ju mirurrurrangu ngakarnajaninyi pirirrija ngurr-ngurrkartirrangu. Palaja mirti jarrinyiyi warnkuja kaninykurnu, yintanga ngalpanyiyi, ngurr-ngurr wiyirr ngapalu kunanyajaninyi, marlkarri ngarramarnti.” ");
INSERT INTO nna_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Palaja ngurrararrangulu wurrarniyili Jesus-ja, “Yankuluman. Nganarnamili warrarn yakalamannganaka.” ");
INSERT INTO nna_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Palaja tingkingi karntinyi Jesus. Pirirrilu wanka jarrinyajalu Jesus japirr marna, “Milpurnu nyuntungu?” ");
INSERT INTO nna_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Puntaju karra marnalu, “Munu. Nyuntumilirrangukarti kulpulumanjanaku. Wurralamanjanaku Ngarrka paju karrinyingu, ngalypa jinangu yija.” ");
INSERT INTO nna_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Palaja Jesus karakurnu kulpanya ngunarrikarti yintanga. Palinymilija muwarrja pala pirirri kulpanyakanu yana-yananyikinyi palanga warrarnja, kakarra, ngapingi, 10 Town-arrangungu. Wiyirrja yana palarrangungu. Wurrarnikinyijanaku, “Ngarrkalu ngalypa yiji jirnija. Jesus-ju jurtu ngakarnajaninyi mirurru ngajuja. Wanka jirninyi.” Wiyirr palanga wurlka jarrinyiyi, ngurnjurnikinyiyalu Jesus-ku. ");
INSERT INTO nna_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ngarti-ngartingi yintanga Jesus-ja kunmu jarrinyiya kurrngal. ");
INSERT INTO nna_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Milpanya pirirri, yini Jairus. Palinymilingi tawunja muwarrpintiku mayaku nyampali paliny. Jampa yirrirni Jesus murtingi jurlpi-jurlpi jarrinyili walangkarr. ");
INSERT INTO nna_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ngarlu japirr marna, “Partany mirtawa ngajumili wurrku yija, marlkarri jarrali. Milpuluman ngurrakarti ngajumilikarti, warlilaman parirrju. Palaja munu marlkarri jarruliny, wanka wantuliny yija.” ");
INSERT INTO nna_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesus palinyja yana, kurrngalju yajarnikinyiyipulinyi. Ngurrku-ngurrku marnikinyiyarninyi marrngurrangulu. ");
INSERT INTO nna_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nyungulu mirtawalu pukurl yajarna. Wurrku kalkurnikinyi palalu mirtawalu punja, 12 partunurrangu. Pijirri yirrku warrkirnikinyili yija, parra-parra wirtu. ");
INSERT INTO nna_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Warinypa warinykarti maparnkarrarrangukarti yananyikinyi. Munu wanka jirnimiyi. Wurrku wirtu jarrinyikinyili. Palaja warnkumajirri yija, yirrku wurrku waninyikinyi. ");
INSERT INTO nna_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Palinyju pinakarrinyi, “Jesus-ju ngalypa jirnijaninyi wurrkujartiny.” Pinakarrinyakanu wurrarnarningu, “Nyinga malamarna wurrujakun palinymili. Nyinga manakanu ngalypa jarrulumarna yija, wurrkumajirri wantulumarna.” Palajun jirni. Partijirri kaniny wangka milpanyili, nyirrirnilu warlirnalu wurru. ");
INSERT INTO nna_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Palangangarra pijirri paliny warrkinaja jupanya, miranu ngalypa jarrinyi pala mirtawa, pikaly jarrinyi. ");
INSERT INTO nna_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Palangangarra palaku miranu jarrinyi Jesus. Karra marnarningu, “Warajalu nyinga marnanyi, pala purrpurn jarrinyi.” Wararr karrinyi, warinykurnu jarrinyi. Japirr marnajaninyi, “Nganurtulu wurru ngajumili nyinga marnaja?” ");
INSERT INTO nna_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Karra marnayalu palinymilirrangulu, “Nganijalu palajun muwarr pirnin? Kurrngalju ngurrku marnikinyiyinti. Wunyjurrurti japirr marnan, 'Nganurtulu nyinga marnanyi.'?” ");
INSERT INTO nna_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Panypa-panypanyikinyijanaku, yirrkulu parrjarnikinyi. ");
INSERT INTO nna_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pala mirtawa miranu waninyarningu, purrpurn yija, wurrkumajirri. Jannganka pirnikinyi karrartajartiny, milpanya Jesuskarti. Murtingi jurlpi-jurlpi jarrinyili walangkarr palinyja jinanga, wurrarnili yija muwarr jurtu. ");
INSERT INTO nna_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ngalypalu wurrarnala Jesus-ju, “Yijalmarta jirnijin ngalypaku. Palajunjalu kuwarri ngalypa waninyan. Yankuluman wirntimajirri, ngalypa wantuluman. Nyungujajakun. Munu yarranakanu pala wurrku mankuluman.” ");
INSERT INTO nna_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mirtawanga muwarr pinajanga, jinta milpanyiyi nyarraja Jairus-milija mayaja. Jairus-ja wurrarniyili, “Partany mirtawa nyuntumili marlkarri. Pala miranu jinakata yakala. Munu yirrnginaku.” ");
INSERT INTO nna_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus-ju pinakarrinyijaninyi muwarrja. Jairus-ja wurrarnili, “Wirntiwayi, munu ngarlu kurlu jarruluman. Yirrkulu yijalmarta jilipijin.” ");
INSERT INTO nna_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kurrngalju yajarnikinyiyipulinyi Jairus-pa Jesus. Wurrarnajanaku Jesus-ju, “Wantayi.” Palaja Jesus-ju manajaninyi palinymilija kujarrapa warajajakun, Peter-pa James-pa marrka James-mili, John. Jana yanayi Jesus-pa Jairus pukun ngurrakarti Jairus-milikarti. ");
INSERT INTO nna_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yanayi mayanga milyanga, wararr karrinyiyi. Palanga mayanga yirrirniyijaninyi kurrngal. Ngangkurlji pirnikinyiyarninyi partanyku mirtawaku. ");
INSERT INTO nna_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngalpanyakanu Jesus-ju wurrarnajanaku, “Munu ngangkurl jilkulunyurru. Pala partany mirtawa kupalya jarrinyijakun. Munu marlkarri paliny.” ");
INSERT INTO nna_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nyurni marnayi. Munu yijalmarta jirnimiyili muwarrja palinymilingi. Palaja palinyju wurrarnajanaku, “Jalakarti yarrayi.” Palaja palarrangungujakun wurrarnajanaku, pipi japartungu partanymilingipa Peter-ngapa James-ngipa John-ja, “Yankuluminyalu partanykarti.” Palakarti kutukarti partanykarti yanayalu. ");
INSERT INTO nna_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Parirr warlirni Jesus-ju, wurrarnili, “Partanykayi, wararr karra!” ");
INSERT INTO nna_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Palangangarra Jesus-milija muwarrja pirlurr palinymili kulpanyalu. Partany wararr karrinyi, marnti yana jinalu, jurrkarna kujarrapa warajamarta. (Kurrimarta paliny, partunurrangu 12-jartiny.) Yirrinajalu wurlka jarrinyiyi, wurrarnikinyiyarningu, “Yuu, purlpilu nyungukapali munu yirrirniminyi. Marlkarrija wanka jirni.” ");
INSERT INTO nna_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Minyirrju wurrarnapulaku, pipi japartungu pala partanymilingi, “Munu wurralkulunyumpulujanaku wankanyu jirnirni nyungu partany ngajulu.” Palaja wurrarnapulaku, “Partany mayi yungkulunyumpulu.” ");
INSERT INTO nna_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Palaja Jesus yana warrarnkarti palinymilikarti, palinymilirrangulu marrngurrangulu yajarniyi. ");
INSERT INTO nna_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","11","Jesus yananyikinyi tawunarrangukarti, miranu jirnikinyijaninyi Ngarrkamilaku muwarrku. Palaja palinymilirrangu kayi marnajaninyi, wurrarnajanaku, “Marrngurrangukarti Ngakalamarnanyurrinyi, Ngarrka wurralkulunyurrujanaku. Nyungu muwarr wurrarnarninyurruku ngajulu. Kuwarrija jurtu ngakaliyijaninyi mirurrurrangu marrngurranguja, nyurralu. Yankulunyurru, munu warnkupa mayi kangkulunyurru. Wirrilkulunyurrarningu jujika, warajajakun wurru kangkulunyurru, jinta wurrukarra yakalkulunyurru. Yijapa warinyjarrangu tawunja marrngulu wurralkulunyurruku, 'Kurtaliyi, jampa nganarnanga wantulunyurru.' Palinymilingi ngurranga palangangarra wantulunyurru palanga tawunja. Yijapa warinyjarrangu tawunja milpulunyurru, panypalapiyinyurraku, munu janalu japirr malapiyinyurrinyi janamilingi tawunja waninyaku, munu pinakarrulupiyi Ngarrkamili muwarr. Palajunja, munu wantulunyurru palanga tawunja. Kurlurlu jujikaja purany pilkulunyurru. Palajun jinajalu jurti jilkulunyurrujaninyi Ngarrka kuli jarrulinyjanaku, panypanyaja palinymilingi muwarrja. Palaja yakalkulunyurru pala tawun. ");
INSERT INTO nna_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yuu, jipi. Kujarrapa kujarra, palajun yankulunyurru.” Palaja yanayi. Yananyikinyiyi wurrarnikinyiyijanaku marrngurrangungu, “Panypanyikinyinyurrulu Ngarrkanga. Yakalaya kurlujartiny jirnikinyinyurrupa, Ngarrkanga yijalmarta jiliyili!” ");
INSERT INTO nna_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kurrngal mirurru jurtu ngakarnikinyiyijaninyi, kurrngalja wurrkujartinyja wirrirniyijanaku mirrijin, japirr marnikinyiyi Ngarrka, “Ngalypa jilaman nyungu marrngu.” Palaja wurrkujartiny ngalypa jarrinyi. Ngalypa jirnijaninyi Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yarti Jesus-milirrangu ngakanajarrangu kulpanyiyi palinykarti. Wurrarniyili marrngu ngalypa jirnikinyiyijaninyi, mirurru jurtu ngakarnikinyiyijaninyi, marrngu miranu jirnikinyiyijaninyi Ngarrkaku, palajun, Jesus-milija muwarrja. ");
INSERT INTO nna_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Palanga Jesus-karti milpanyikinyiyi marrngurrangu kurrngal yiji. Ngurrku marnikinyiyi ngunarrijirrilu, munu-munu jirnikinyiyijaninyi ngananyaku Jesus-jupa palinymilirrangulu. Palaja Jesus-ju wurrarnajanaku palinymilirrangungu, “Yankuluminyi nganyjurrujakun marrngumajirrikarti warrarnkarti. Jampalu mimalaminyarningu.” ");
INSERT INTO nna_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tingkingi karntinyiyi, marrngumajirrikarti yanayi. ");
INSERT INTO nna_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kurrngalju parrjarnikinyiyijaninyi, janaku miranu, miranupa wanyjarnikartiku yananyi Jesus. Mirti wirlki jarrinyiyi milyanga yintanga ngunarrikarti jinangu, kaninypirti mimarnikinyiyalu. ");
INSERT INTO nna_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus-ju katukanajalu yirrirnijaninyi kurrngal mimarnikinyiyalu kaninypirti. Parrjanakanu ngarlu kurlu jarrinyajanaku. Wurrarnarningu palinyju, “Marrngu nyungurrangu kurluny-kurlunyja waninyayi yija, nyampalimajirri. Jana paparlja waninyayi, ngapikapali, kukurnjarirrangu tuku jinakatamajirri.” Punjalu miranu jirnikinyijaninyi Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ruka-ruka jarrinyi. Yirrkulu pinakarrinyikinyiyalu muwarrjaku. Palinymilirrangulu wurrarniyili, “Ruka-ruka jarrinyi. Town-arrangu kaja. ");
INSERT INTO nna_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Marrngurrangu nyungurrangu ngakalamanjaninyi tawunarrangukarti, mayi mankulupiyarninga.” ");
INSERT INTO nna_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Puntaju Jesus-ju karra marnajanaku, “Yuwayijaninyi mayi nyurralu.” Palinymilirrangulu karra marnayalu, “Mayi munu yinganyakayirnijaninyi nganarnalu! Kurrngalku palamarranguku martumpirri mananyaku warnkulu wirtulujakun. Puru warnku wupartujartinyjakun nganyjurru.” ");
INSERT INTO nna_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Puntaju muwarr pirnijanaku, “Wunyjurrumal martumpirri kalkurnanyurru? Parrjaliyi.” Yirrinakanu wurrarniyili, “Parirr warajakarti martumpirripa wupartujirri janpamalujirri.” ");
INSERT INTO nna_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wurrarnajanaku, “Marrngurrangungu wurraliyijanaku kajanaku.” Wurrarniyijanaku warrulymarramarranga kajanaku kunmurrangupa kunmurrangu. ");
INSERT INTO nna_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kajarniyi palinymilija muwarrja, nyungungu 50-rrangu kunmu waninyikinyiyi, palanga 100-arrangu kunmu waninyikinyiyi. Jinta wiyirr waninyikinyiyi palajun, kunmurrangungu ngunarrijirri waninyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus-ju manajanaku martumpirri, kankakurnu parrjarna, Ngarrkanga wurrarnili, “Nyuntulungarra mayi nyungu yinyannganinyi. Yarranijayi! Wanka jinannganinyi! Nyuntu ngalypakata!” Palajun wurranakanu, martumpirrirrangu ngartarna kutapa kuta, yinyajaninyi palinymilirrangu, wurrarnajanaku, “Nyungurrangu yungkulunyurrujaninyi.” Palajunmarta jirni janpamalujirri pukurl. ");
INSERT INTO nna_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Nganayi kurrngalju. Pirirrimartalu 5,000-ju nganayi pala mayi. Wiyirrju marlkaku nganayi. Palaja palinymilirrangulu mujurrangu manayijaninyi, pitirrangungu wirrirniyi, winya jirniyijaninyi 12 pitirrangu wirturrangu. ");
INSERT INTO nna_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Palaja Jesus-ju wurrarnajanaku palinymilirrangungu, “Tingkingi karntulunyurru, yankulunyurru ngunarrikarti, ngapikarti, Bethsaida-karti. Yarti milpulumarnanyurruku.” Tingkingi yanayi walangkarr. Palaja Jesus-ju jinta wiyirr ngakarnajaninyi ngurrakarti janamilikarti. ");
INSERT INTO nna_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Palaja Jesus karntinyi warnkungu kanka, Ngarrkaku muwarr pinaku. ");
INSERT INTO nna_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Warrukarti jarrinyi. Kujurl waninyikinyi palanga. Palinymilirrangu tingkingi partijirri kaniny ngapanga, kurlungu waninyikinyiyi. Wangal wirtu purrpanyikinyijanaku. ");
INSERT INTO nna_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yirrkulu tingki yananyaku partarl jirnikinyiyi, partarl mungkajartinyju marntiku jirnikinyiyi wangaljamarra wirtungumarra. Jesus-ju kajamartangulu yirrirnijaninyi. Karrpumajirringi milpanyajanaku. Jinangu kankarni ngapanga yananyikinyi. Wangka jarrinya kawarnikinyijanaku. ");
INSERT INTO nna_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Palinymilirrangulu yirrirniyi paliny, ngapanga kankarni nyirrirnilu yajarnikinyijaninyi. Kakurnikinyiyi, wurrarnikinyiyi mirurrukapali milpanyikinyi. Wirnti karrinyikinyiyalu, kamarnayi yija karrartajartiny. ");
INSERT INTO nna_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jesus-ju wurrarnajanaku, “Wirntiwayi. Ngajurla milpanyarni. Kinti jarrayi, ngalypa wantayi.” ");
INSERT INTO nna_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jananga tingkingi karntinyijanaku. Palajangarra wangal jupanya. Palinymilirrangu ngurnjul jarrinyiyalu. Wurrarnikinyiyarningu, “Yuu, parrjaliyi! Ngapanga kankarni yananyikinyi jinangu. Jampa milpanya paliny, palangangarra wangal jupanya.” ");
INSERT INTO nna_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Munu kurlkapirli jarrimiyi. Purlpi yirrirniyi Jesus-ju mayi yinyajaninyi 5,000 pirirrimartanga, wupartu janpamalupa martumpirri. Munu mirlkanga kalkurnumiyi. Yirrku wurrarnikinyiyarningu, “Pururla pala marrngu nganyjurrukapali.” ");
INSERT INTO nna_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Palaja milpanyiyi palanga warrarnja, Genezareth-ja. Ngarti-ngartingi yintanga tingki kunymarnayi mirrilyilu. ");
INSERT INTO nna_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesus katukarna tingkija, palarrangulu ngurrararrangulu yirrirniyi, palangangarra palinyku miranu jarrinyiyalu. ");
INSERT INTO nna_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mirti jarrinyiyi ngunarrijirringi palanga warrarnja, wurrarnikinyiyijanaku, “Jesus milpanya!” Palaja palinykarti wurrkujartiny kanganyikinyiyijaninyi ngurrinyja. ");
INSERT INTO nna_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Palajunngarra jirnikinyiyi tawunjarrangu tawunjarrangu ngurrarrangu ngurranga. Wurrkujartiny kanganyikinyiyijaninyi palinykarti. Town-jarrangu partijirri kaniny parlkarranga jintalu mayipa nganin-nganin warnkuku yinganyikinyiyi. Palanga parlkarranga wurrkujartiny wirrirnikinyiyijaninyi ngurrinyja jungkanga, Jesus-ja wurrarnikinyiyili, “Wurrkujartinyarrangu nyungurrangu karrinyaya wurruku nyinga manaku nyuntumilaku. Wurrupa warlilipiyangu, ngalypa jarrulupiyi.” Yija warlinajarrangu ngalypa jarrinyiyi wiyirr. ");
INSERT INTO nna_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Palaja Jesus-ju yakarna palinymili warrarn. Yalinyjikurnu yana, warinykarti ngajarrimilikarti warrarnkarti, yinikarti Syro-Phoenicia-karti yana. Wangka waninyikinyi tawunmartaji, yini pala Tyre. Mayanga kaninykurti ngalpanya kujurlmarta waninyaku. Karra marnarningu, “Munumpa ngajuku ngurrararrangu. Kakuluminyiyi.” Munu. Partarl karrkarnajanaku. ");
INSERT INTO nna_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Jampa pinakarrinyi Jesus mirtawalu ngurraralu. Wariny paliny mirtawa, munu Jew, Syro-Phoenicia-ja warrarnja. Partany mirtawajartiny pala mirtawa. Mirurrulu jakurlirnikinya palinymili partany. Pala mirtawalu ngurranga palinymilingi partany yakarna, milpanya Jesus-karti, murtingi jurlpi-jurlpi jarrinyili walangkarr, ngarlu japirr marnikinya, “Wupartuja partanyja ngajumilija mirurru jurtu ngakalamanpili.” ");
INSERT INTO nna_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus-ju puntaju ngalypalu karra marnalu, “Partanykarrangulukurra mayi ngalkulupiyi marlkaku, palaja mayi yungkulunyurrujaninyi wupartupani yukurru. Munu miranaku mayi partanykarranguja yinganya parnpinaku wupartupani yukurrurrangukarti.” Palalu muwarrju wurrarnili Jesus-ju, “Marrngurrangu Jew-arrangukurra ngalypa jilamarnajaninyi ngajulu, munu kuwarri ngalypa jilamarnajaninyi marrngurrangu warinyarranguja warrarnarranguja. Yartiku.” ");
INSERT INTO nna_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mirtawalu puntaju karra marnalu, “Yuu, nyampalikayi! Yijarla pala muwarr. Partanykarrangulu mayi ngalkulupiyi, palaja wupartupanilu yukurrulu ngalkulupiyi. Yija partanykarrangulu ngananyayi mayi, wupartupanilu yukurrulu pungkanyaja partanykarranguja parirrja muju-muju ngananyayi.” ");
INSERT INTO nna_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus-ju karra marnalu, “Ngalypa muwarr pirnin! Palaku muwarrku partany nyuntumili ngalypa jilamarna. Yankuluman. Purlpi mirurrulu yakarnanga partany.” ");
INSERT INTO nna_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Palinyja muwarrja yana pala mirtawa, ngurrakarti yana, partany yirrirni. Ngurrinyja kupalya jarrinyi ngalypa. Mirurru purlpi yanalu palinyja. ");
INSERT INTO nna_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Palaja Jesus yarranakanu yalinyjikurnu yana, ngapikarti, Jayitun-karti. Kakarrakurnu, kurilakurnu, warrarnkarti 10 Town-arrangukarti yana, palaja kulpanya Yintakarti Galilee-karti. ");
INSERT INTO nna_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pirirri kurlka ngawu kanyayili, jalin manyurla paliny, partarl-partarl muwarr pirnikinyi. Jesus-ja wurrarniyili, “Parirrju warlilaman palama pirirri, ngalypa jinaku.” ");
INSERT INTO nna_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus-ju jalakarti kanya yirrinangamarra. Parirrjirri wirrirnili pirirringi kurlkangajirri. Palaja janga pirnarningu parirrja, pirirringi jalinja wirrirni. ");
INSERT INTO nna_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Palaja kanka parrjarna Jesus-ju, nganyjurnu wirtu yija. Palaja pirirringi wurrarnili, “Kurlkajirri tarlkarra malapulu.” ");
INSERT INTO nna_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Palinymilija muwarrja palangangarra kurlkajirri pirirri tarlkarra marnapulu, jalin pukurl ngalypa jarrinyi. Palaja muwarr pirni ngalypa pala pirirri. ");
INSERT INTO nna_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus-ju ngurraranga wurrarnajanaku, “Munu warinyjarrangu wurralkulunyurrujanaku ngajulu ngalypa jirnirni kurlkapa jalin pala pirirri.” Jesus-milingi muwarrja panypanyiyili. Yirrkulu wurrarnikinyiyijanaku wiyirrja marrngurrangungu, Jesus-ju palajun jirni palaku pirirriku. ");
INSERT INTO nna_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wiyirrju pinakarrinyiyi, yija wurlka jarrinyikinyiyalu, ngurnjul-ngurnjul jarrinyiyalu. Muwarr pirnikinyiyijanaku marrngurranguku, “Yijalu yinku jirnikinyi Jesus-ju. Jinta muwarrmajirrija muwarrkata jarrinyiyi, jinta kurlka ngawuja pinakarrinyakata jarrinyiyi. Palarrangu pukun ngalypa jirnikinyijaninyi. Munu ngurnjul palinyku.” ");
INSERT INTO nna_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Warajanga karrpungu yarrana kunmu jarrinyiyi kurrngal pirranga. Pinakarrinyikinyiyalu Jesus-ku. Palaja mayi munu jarrinyijanaku. Jesus-ju kayi marnajaninyi palinymilirrangu, wurrarnajanaku, ");
INSERT INTO nna_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Marrngurrangu nyungurrangu punja waninyikinyijiyi ngajungu, karrpurrangungu kujarrapa warajanga. Kuwarri mayi munu jarrinyijanaku. Ngarlu paju karrinyarnijanaku. ");
INSERT INTO nna_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Munu janparr ngakalamarnajaninyi ngajulu warrarnkartirrangu janamilikarti. Yananyakanu janparrjartiny pungkulupiyi. Kajamartaja milpanyiyi jana.” ");
INSERT INTO nna_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Palinymilirrangulu karra marnayalu, “Nyungu marrngumajirri warrarn. Nganurtulu nyungungu kanyjinakanu mayi mankulinyjanaku palarranguku wiyirrku? Kurrngal yija-yiji jana.” ");
INSERT INTO nna_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus-ju japirr marnajaninyi, “Wunyjurrumal martumpirri kalkurnanyurru?” Puntaju karra marnayalu, “7 wuparturrangu martumpirri.” ");
INSERT INTO nna_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","7","Kujarrapa warajamarta wupartupani janpamalu pukun kalkurnayi. Jesus-ju wurrarnajanaku, “Wurraliyijanaku jungkanga kajalapiyi.” Palaja martumpirrirrangu mana, janpamalupirrayi pukun, Ngarrkanga wurrarnala, “Nyuntulungarra nyungu mayi yinyannganinyi. Yarranijayi! Wanka jinannganinyi! Nyuntu ngalypakata!” Palaja ngartarna martumpirrirrangu kutapa kuta, yinyajanaku palinymilirrangungu, janpamalu pukun yinyajanaku, wurrarnajanaku, “Nyungurrangu mayipa kuwiyi yungkulunyurrujaninyi.” Palajun jirniyi. ");
INSERT INTO nna_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Palanga kurrngalju yija nganayi, 4,000-ju marlkaku nganayi pirirrimartalu. Palaja Jesus-ju wurrarnajanaku, “Yuu, jipi yankulunyurru nyurramili warrarnkartirrangu.” Palaja Jesus-milirrangulu muju manayi, 7 wirtu pitirrangungu mujurrangu winya jirniyijaninyi. ");
INSERT INTO nna_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Palaja Jesus tingkingi karntinyi, palinymilirrangu pukun, yanayi palakarti warrarnkarti, ngapikarti, Talamanajakarti. ");
INSERT INTO nna_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus palakarti tawunkarti yana, ngapikarti, Bethsaida-karti. Pirirri wirningi kanyayili jintalu, pampuru yiji paliny, munu yirrirnaka. Ngarlu japirr marnayi Jesus, “Nyinga malaman paliny, ngalypa jinaku.” ");
INSERT INTO nna_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus-ju parirrja kanya pampuru jalakarti tawunja. Janga pirnarningu parirrja, warlirni janga, pirirringi paningi wirrirni, japirr marna, “Yirrirnan?” ");
INSERT INTO nna_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pirirrilu parrjarn-parrjarna, wurrarnili, “Marrngurrangu rangkarr yirrirnarnijaninyi. Mungkarrangukapali jana wurrarnarnajaninyi. Panilu mitu marnanyi. Munu mungkarrangu waninyakayi. Marnti yana-yananyikinyiyi.” ");
INSERT INTO nna_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yarrana Jesus-ju parirrjirri wirrirnipulinyi pirirringi paningi. Pirirrilu tukulu parrjarnikinyi, ngalypalu yirrirni. ");
INSERT INTO nna_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus-ju ngakarna ngurrakarti palinymilikarti. Wurrarnili, “Munu palakarti tawunkarti yankuluman, munu wurralamanjanaku palajun jirnirningu.” ");
INSERT INTO nna_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kujarrapa waraja karrpurranguja Jesus-ju manajaninyi Peter-pa James-pa John, kanyajaninyi warnkukarti wirtukarti. Karntinyiyi pala warnkungu kankajirri. Janajakun yanayi, palarrangu. Palanga janalu kujarrapa warajalu yirrirnikinyiyi Jesus pirrparnikinyi. ");
INSERT INTO nna_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wurru palinymili mirta-mirta jarrinyi, pirrpa jarrinyalu. Yijalu marrngulu munu mirta-mirta yiji jinaka palakapali. ");
INSERT INTO nna_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Palaja palarrangulu kujarrapa warajalu pirirrilu yirrirniyipulinyi yatiljirri, Ngarrkamili muwarr pinakatajirri purlpijajirri pulany, yini wariny Yilayija, wariny Moses. Palajirripa Jesus kurrngarnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter-lu purrpilu muwarr pirnalu Jesus-ku, “Miranu jinakatakayi, nganarna nyungungungarra waninyayirni. Pala ngalypa. Pamarr yarni malapiyirninyurraku, wariny nyuntuku, wariny Moses-ku, wariny Yilayijaku.” ");
INSERT INTO nna_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Palinypa James-pa John wirnti waninyikinyiyi, munumpa waninyikinyiyi yinkuku muwarrku. ");
INSERT INTO nna_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Palanga mujungu milpanya yamarnajaninyi. Ngarrkalu mujungungulu wurrarnajanaku, “Nyungu Jesus ngajumili partany walja, ngarlungu ngajungu paliny. Pinakarrayalu palinyku.” ");
INSERT INTO nna_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Janyinju parrjarn-parrjarniyi, munu yirrirnimiyipulinyi yatiljirri purlpijajirri. Jesus-jakun yirrirniyi. ");
INSERT INTO nna_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Katukana kawarnikinyiyi, Jesus-ju minyirrju wurrarnajanaku, “Jipi yirrirninyinyurru, ngaju pirrpanga waninyikinyirni, yirrirninyurrupulinyi Moses-pa Elijah, wurrarnanyurruku Ngarrkalu mujungungulu. Munu wurralkulunyurrujanaku jintanga. Yarti, marlkarri jarrinyakanu, ngaju wanka turlpulumarna. Palaja wurralkulunyurrujanaku.” ");
INSERT INTO nna_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Palinyja muwarrja munu muwarr pirnimiyijanaku jintaku. Palarrangulujakun kukujarrilu kurrngarnikinyiyarningu. “Nganijalu wurrarnanganyjurruku pala muwarr, 'Marlkarri jarrinyakanu, ngaju wanka turlpulumarna'?” Ngunjurnikinyiya. ");
INSERT INTO nna_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kulpanyakanu milpanyiyijanaku jintakarti Jesus-milirrangukarti. Yirrirniyijaninyi kurrngalja partijirri kaniny. Palanga Jew-arrangumilalu miranu jinakatalu kujarrapa warajalu jalypa pirnikinyiyijaninyi Jesus-milirrangu. ");
INSERT INTO nna_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kurrngalju yirrinakanu wangka yirrirniyi Jesus, wurlka jarrinyiyi, palinykarti purrpi mirti jarrinyiyalu. “Yarranijayi! Milpanyan!” ");
INSERT INTO nna_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus-ju japirr marnajaninyi palinymilirrangu, “Nganijalu jalypa pirninyurrujaninyi?” ");
INSERT INTO nna_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Warajalu pirirrilu karra marnalu, “Miranu jinakatakayi, ngajumili partany kalkurnu mirurrulu, munu muwarr pirnaka. ");
INSERT INTO nna_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mirurrulu warlirni, jungkanga parnpirni. Jawaja janga purlpurlpukarra marnala, rirra pajirnarninyi, kawu kararr yija jarrinyi. Palajalu kanyarnangu nyuntuku, ngalypa jilaman nyuntulu. Nyuntumilirrangu japirr marnarnajaninyi mirurru jurtu ngakanaku palinyja. Munu. Partarl jurtu ngakarniyi.” ");
INSERT INTO nna_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Palaja Jesus-ju wurrarnajanaku palinymilirrangungu, “Nyurralu yija munu yijalmarta jirnimanyurrulu Ngarrkanga. Wunyjurrurti? Yirrku mitu yakanakatarrangu nyurra! Wunyjurrumal wantulumarnanyurraku? Punjalu miranu jilkulumarnanyurrinyi? Palaja yijalmarta jilkulunyurrulu Ngarrkanga? Ngajukarti partany kangkulupijinyurru.” ");
INSERT INTO nna_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kanyayili. Jampa Jesus yirrinajalu mirurrulu warlirni pala partany, jinarn-jinarn pinakata jirni. Palanga jungkanga pungkanya partany, warli-warli kanganyikinyi warinykurnu warinykurnu, janga jawaja warrkirnikinyili. ");
INSERT INTO nna_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus-ju japirr marna japartumurniny partanymili, “Nyanga palajun jarrinyi? Karra marnalu, “Partanyja. ");
INSERT INTO nna_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Marlumal mirurrulu parnpirnikinyi wikangapa ngapanga, marlkarri jinaku yakurr marnikinyi. Paju karrulumannganaku. Yijapa ngalypa jilaman.” ");
INSERT INTO nna_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus-ju puntaju karra marnalu, “Yuu, palinyku ngalypa jinaku miranu ngaju. Nganijalu palalu muwarrju karra marnajin, 'Yijapa ngalypa jilaman'? Ngarrkanga yijalmarta jilamanpalu nyuntulu. Palaja japirr malaman nganikupa Ngarrka, palakungarra miranu yiji paliny, wunyjurru jinaku. Munu ngurnjul Ngarrkaku.” ");
INSERT INTO nna_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Palangangarra japartumurninyju kamarnalu marrjalu, “Yijalmarta jirnirnili Ngarrkanga. Miranu jiliminyinpa yinkuku yijalmarta jinaku!” ");
INSERT INTO nna_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus-ju yirrirnijaninyi kurrngal kunmu jarrinyikinyiyi. Palajalu wurrarnili minyirrju mirurrungu, “Nyuntu mirurru kurlukata, nyungu partany kurlka ngawu jirnin, muwarrku jama jirnin. Yakala. Jalakarti yarra. Munu yarrana paliny kangkuluman.” ");
INSERT INTO nna_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mirurrulu kamarna, partany jinarn-jinarn pinakata jirnikinyi, kurlu yiji. Palaja yakarna, yana ngarramarnti. Pala partany kutukapali. Kurrngalju wurrarnikinyiya, “Marlkarri yija paliny.” ");
INSERT INTO nna_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Parirrja Jesus-ju kanka marna. Palaja wararr karrinyi partany. Ngalypa paliny. ");
INSERT INTO nna_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesus mayanga ngalpanyaja palinymilirrangulu japirr marnayi, “Nganijalu pala mirurru munu jurtu ngakarnamiyirni nganarnalu? Partarl ngakarniyirni.” ");
INSERT INTO nna_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus-ju puntaju karra marnajanaku, “Ngarrkaku muwarr pinajalujakun jurtu ngakalkulunyurru mirurru palakapalingarra.” ");
INSERT INTO nna_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jesus-jupa palinymilirrangulu yakarniyi pala, warrarnja Galilee-ngi yananyikinyiyi. Paliny karrinyijanaku ngurrararrangu kakunaku palinyku. Palinyju palinymilirranguku miranu jinaku karrinyikinya palinyku, jintalu marlkarri wirlalapiyi. Muwarr pirnikinyijanaku, “Ngajuku miranu nyurra, marrngurrangukarti ngakarninyijanaku Ngarrkalu. Jintalu wurrarnikinyiyi ngaju munu ngakarnaminyi Ngarrkalu. Marlkarri wirlanaku karrinyijiya. Yijalu warliliminyiyi, warinyarrangukarti marrngurrangukarti kangkuluminyiyi. Palarrangulu warinyarrangulu marlkarri yiji wirlalaminyiyi. Palaja, warrukartija kujarraja, yija yarranakanu wanka jarrulumarna.” Palajun palinymilirrangungu wurrarnajanaku Jesus-ju. ");
INSERT INTO nna_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Palakupa muwarrku munumpa yija waninyikinyiyalu palinymilirrangu. Malyparr japirr manaku karrinyikinyiyalu puntajuku, kurntany jarrinyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yanayi pala tawunkarti, Capernaum-karti. Mayanga ngalpanyaja palinymilirrangu japirr marnajaninyi Jesus-ju, “Milpanya kawarnikinyinyi nganijalu jalypa pirnikinyinyurrarninyi?” ");
INSERT INTO nna_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jama waninyikinyiyalu. Munu puntaju muwarr pirnimiyalu. Yananyakinyiyi jalypa pirnikinyiyarninyi, palajunju wurrarnayarningu, “Nganurtu nganyjurrungu nyampali wantulinynganyjurruku?” ");
INSERT INTO nna_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kajanakanu Jesus, palinykarti kayi marnajaninyi. Wurrarnajanaku, “Yijapa nyampaliku karrinyanpa, wupartu jilamanparninyi nyuntulu, nyirrirni jilamanparninyi, ngalypa jilkulumanjanaku wiyirrku.” ");
INSERT INTO nna_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Palaja partany kayi marna, wirni manakanu walangkarr jananga wararr jirni. Yampu manakanu wurrarnajanaku, ");
INSERT INTO nna_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yijapa ngalypa jilamanpalu nyungukapaliku partanyku, ngajuku pikaly jinaku. Palangarra ngalypa jirninpalu partanyku, ngajuku pukun palangarra nyarra ngalypa jirnijin. Ngarrkalu ngakarnanyi ngaju. Palajalu ngalypa jilipijinpa ngajuku, pikaly jiliminyin, pikaly jilaman Ngarrka pukun.” ");
INSERT INTO nna_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John-ju wurrarnili Jesus-ja, “Miranu jinakatakayi, pirirri yirrirniyirni, nyuntungu yiningi mirurru jurtu ngakarnikinyijaninyi marrngurranguja. Marrngu pala munu nganyjurramiliwayi. Palaja wurrarniyirnili munu palajun jinaku.” ");
INSERT INTO nna_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus-ju puntaju karra marnalu, “Munu kunta jilinyurrulu. Yija palarrangulu ngalypa wirtu jinajalu yinilu ngajumilalu, marntungu warinyja munu kurlu jintanga wurralkulupiyijanaku ngaju. ");
INSERT INTO nna_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Munu yukuny pinakatarrangu nganyjurruku, purntu manakatarrangu jana. ");
INSERT INTO nna_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yija nyungu muwarr wurrarnarninyurruku, warinyarrangulu nyurraku miranu jarrinyajalu, ngajumili nyurra, palajalupa wupartu ngalypa jilkulupiyinyurruku, yijalu puntaju ngalypa jilkulinyjanaku Ngarrkalu.” ");
INSERT INTO nna_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pipilurrangupa japarturrangulu kanganyikinyiyijaninyi janamilirrangu partanykarrangu Jesus-karti, japirr marnikinyiyi, “Miranu jinakatakayi, japirr malaman Ngarrka ngalypa jinaku nganarnamilaku partanykarranguku.” Jesus-milalu marrngurrangulu warnta marnayijaninyi pipipa japartu. ");
INSERT INTO nna_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yirrinakanu ngarlu kurlu jarrinyi Jesus, wurrarnajanaku, “Karrinyarni partanykarranguku ngajukarti milpanyaku. Munu ngampa pinaku nyurralu. Pikalyju Ngarrkanga yijalmarta jirniyalu, pinakarrinyiyalu muwarrja palinymilingi janalu. ");
INSERT INTO nna_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yija nyungu muwarr wurrarnarninyurruku, nyurralu wiyirrju jilkulunyurru janalukapali, yijalmarta jilkulunyurrulu Ngarrkanga janalukapali. Munu palajunjalu, munu Ngarrkamili jarrulunyurru.” ");
INSERT INTO nna_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Palaja warajapa waraja partanykarrangu palarrangu kartingi jirni, yampu marna, partanyja jurnturtungu kankarni parirr wirrirni, japirr marna Ngarrka, “Partanyku nyunguku ngalypa jilamanpalu.” Palajunju Ngarrka japirr marnikinyijanaku. ");
INSERT INTO nna_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Palaja jampa yananyikinyi Jesus, palinykarti mirti jarrinyi pirirri, murtingi jurlpi-jurlpi jarrinyili walangkarr, wurrarnala, “Miranu jinakatakayi, ngalypakata nyuntu. Marlkarri jarrinyaja, karrinyarni Ngarrkanga wankanyu waninyaku ngarramarnti. Wunyjurru jilamarna ngajulu?” ");
INSERT INTO nna_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus-ju puntaju japirr marna, “Nganijalu palajun muwarrju wurrarnanyin, 'Ngalypakata'? Warajajakun ngalypa, Ngarrkangarra. ");
INSERT INTO nna_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Palinymilaku muwarrku miranu nyuntu. Wurrarnanganyjurruku, 'Munu marrngu marlkarri wirlanaku. Mirtawa nyuntumilijakun kalkuluman, munu warinymili mirtawa kanganyaku. Munu warinymili wurrukarra mananyaku. Munu mitulu wariny marrngu ngukarrinaku. Munu wariny marrngu murra yinganyaku. Nyuntumili pipipa japartuku pinakarrulumanpulaku.'” ");
INSERT INTO nna_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Puntaju karra marnalu, “Miranu jinakata, muwarrja Ngarrkamilingi pinakarrinyikinyirnili partanyjalu ngajulu.” ");
INSERT INTO nna_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus-ju parrjanakanu, ngarlungu palinyja kaniny yija-yiji nyungu pirirri. Wurrarnala, “Nyungu wariny pukun jilaman nyuntulu. Jalamu jilaman nyuntumili wurrukarrarrangu wiyirr. Palaja wiyirr warnku yungkulumanjaninyi pujunungupa janparrkatarrangungu. Palaja yajalaminyin ngajungu. Nyuntulu palajun jinaja, Ngarrkanga yija ngalypanga wantulumanpili ngarramarnti kankajirri.” ");
INSERT INTO nna_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pala pirirri wurrukarrajartinypa warnkujartiny, palarrangujartiny yija wirtujartiny paliny. Palarranguku munu yakanaku karrima. Palajalu Jesus-milaku muwarrku malyparr karrinya. Paju karrinyarningu, milya kaniny jarrinyi pala pirirri, puru yana. ");
INSERT INTO nna_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus-ju palinymilirrangungu wurrarnajanaku, “Ngajumilirrangukayi, pinakarraya muwarrku. Wurrukarra wirturrangujartiny partarl-partarl Ngarrkamilaku jarrinyaku. Ngurnipali kujarrapa warajajakun palinymili jarrulupiyi.” ");
INSERT INTO nna_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Palinyja muwarrja palinymilirrangu parr-parr kurtarniyi. Yarrana Jesus-ju wurrarnajanaku, “Ngajumilirrangukayi, partarl-partarl yija Ngarrkamili jarrinyaku. ");
INSERT INTO nna_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Miranu nyurra pirliku ngapingi, needle-ja milyanga. Wupartu pala. Wunyjurru? Pala pirlingi ngalpuliny kaniny kamal? Munu yiji. Munu yakurr-yakurr malkulinypa. Ngurnjul yija. Palajunmarta wurrukarrajartiny wirtu kurrngaljartiny partarl-partarl yakurr malkulupiyi Ngarrkamili jarrinyaku. Janakungarra ngurnjul yija-yiji. Yijapa kujarrapa warajajakun wurrukarrajartiny wirtujartiny Ngarrkamili jarrulupiyi.” ");
INSERT INTO nna_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Palaja muwarrja palinymilirrangu ngurnjurnikinyiya ngarramarnti. Wurrarnikinyiyarninyi, “Palajalu nganurturti yija Ngarrkanga wankanyu wantuliny ngarramarnti?” ");
INSERT INTO nna_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus-ju minyirrju karra marnajanaku puntaju, “Yijalu marrngulu Ngarrkamilirrangungu munu wirrirnakarningu. Ngarrkalujakun wirrilkuliny marrngu palinyja kankajirri wankanyu ngarramarnti. Yuu. Nganirti yija jinaku karrinyi Ngarrka, palajun jilkuliny palinyju. Munu ngurnjulwayi Ngarrkaku.” ");
INSERT INTO nna_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Palanga Peter-lu wurrarnili, “Pinakarrakurra, ngurrangarrangupa wurrukarra wiyirr yakarnayirnijaninyi nyuntuku yajanaku nganarnalu.” ");
INSERT INTO nna_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus-ju puntaju, “Yija nyungu muwarr wurrarnarninyurruku, nganutulupa ngajuku yajanaku karrinyajalu Ngarrkamilaku muwarrku yimpinaku, yijapa maya yakalapiyijaninyi, mamajipa kangkujipa marrkapa pipipa japartupa partanykarrangupa warrarn mayijartiny yakalapiyi. Yijapa palajun jilipiyi ngajuku pikaly jinaku. ");
INSERT INTO nna_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Wiyirrju palajun jinaja Ngarrkalu kuwarri yungkulinyjaninyi kurrngal mayarrangupa mamajipa kangkujipa marrkapa pipipa partanykarrangupa warrarnarrangu. Nyungu pukun wurrarnarnanyurruku. Jintalu yirrkulu wirlalapiyijaninyi, nyurni malapiyijaninyi, jurntingi wirrilipiyijaninyi. Palajun jilipiyijaninyi. Yuu. Marlkarri jarrinyaja jana, yijalu Ngarrkalu wankanyu jilkulinyjaninyi, Ngarrkanga wantulupiyi ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yija jinta wirtukapali waninyayi kuwarri, yarti, marlkarri jarrinyaja, wupartu jilkulinyjaninyi Ngarrkalu. Jinta wupartu waninyayi kuwarri, yarti, marlkarri jarrinyaja, wirtu jilkulinyjaninyi Ngarrkalu.” ");
INSERT INTO nna_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalem-karti yananyikinyiyi. Jesus walangkarr yananyikinyi. Palinymilirrangu ngurnjurnikinyiyapa ngarlu kurlu jarrinyiyi. Kurrngalju pukun nyirrirnilu yajarnikinyiyi, wirnti karrinyikinyiyi. Yarranakanu Jesus-ju kujurl kanyajaninyi jalakarti palinymilirrangu, muwarr pirnijanaku wunyjurru paliny jilkulupiyi jintalu Jerusalem-ja. ");
INSERT INTO nna_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Pinakarrayi. Jerusalem-karti yananyanyi. Miranu nyurra, Jew-arrangumilalu mangunykatarrangulu wirlanaku karrinyayi ngajuku. Palanga warinyju yungkuluminyijanaku ngaju palarrangungu. Kunmu jarrulupiyi yimpinaku ngajuku. Muwarr jilipijiyi. Palaja karra malapijiyi, 'Marlkarri jinaku.' Palaja ngaju yungkuluminyiyijanaku nyampalirranguku ngajarriku, Roman Government-ja. ");
INSERT INTO nna_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Palarrangulu ngajarrirrangulu yija nyurni malaminyiyi ngaju, ngajungu janga pilipijiyi, wirlalaminyiyi wily pinapintilu, palaja marlkarri wirlalaminyiyi. Palaja, ngurraja kujarraja, wankanyu turlpulumarna.” ");
INSERT INTO nna_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","James-pa John, Zebedee-milijirri partanyjirri, milpanyapulu, Jesus-ja wurrarnapululu, “Miranu jinakatakayi, jilangalayiku waraja?” ");
INSERT INTO nna_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Ngani jilamarnanyumpuluku?” ");
INSERT INTO nna_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Karrpungu warinyja Ngarrkalu wirrilamanta nyampali wirtu yija nyuntu. Nyuntujakun wirtu nyampali wantulumanjanaku wiyirrku ngunarrijirriku marrnguku. Palajun jarrinyaja nyampalijirri jilamanngalayinyi? Ngalaya nyuntungu wangka kajanaku karrinyalayingu, marrjanyukartingipa jampukartingi.” ");
INSERT INTO nna_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Puntaju marnapulaku, “Palaku japirr manajaku munu kurlkapirli jarrinyakanyumpulu. Marrjalu yija ngaju wirlalaminyiyi. Wunyjurru ngajukapali jarrinyaku karrinyanyumpulu? Nyumpala pukun marrjalu wirlaliyinyumpulinyili. Ngani wirntimajirri nyumpala palangamarra? ");
INSERT INTO nna_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Puntaju marnapulalu, “Wirntimajirri waninyalayi.” Jesus-ju wurrarnapulaku, “Yuu, marrjalu yija wirlalapiyinyumpulinyi. Kurlungu yija wirrilipiyinyumpulinyi. ");
INSERT INTO nna_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Munu nyampalijirri jilamarnanyumpulinyi ngajulu. Munu mankulumarnapulinyi nyampali jarrinyaku, wangka ngajumartaji kajalkulinypulu. Ngarrkalujakun pulany mankulinypulinyi, palinyju.” ");
INSERT INTO nna_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jintalu palinymilirrangulu pinakarrinyajalu kuli jarrinyiyipuluku James-kupa John-ku. ");
INSERT INTO nna_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kayi marnajaninyi Jesus-ju, wurrarnajanaku, “Pinakarrayi! Ngajarrirranguku jintangaku warrarnjarranguku miranu nyurra. Janamilalu nyampalirrangulu kurlungu kalkurnayijaninyi, maaja-maaja jarrinyayijanaku marrngurranguku janamilaku. ");
INSERT INTO nna_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nyurralu yija munu palajunmarta jinakanyurru. Nyurranga yijapa waraja nyampali jarrinyaku karruliny, palinyju warrkamu jilkulinyjanaku marrngurranguku jintaku. ");
INSERT INTO nna_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nyurranga yijapa wariny wirtu waninyaku karruliny, palinyju wupartu mujujakapali jilkulinyparninyi. ");
INSERT INTO nna_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Palajun waninyarni ngaju. Ngarrkalu marrngurrangukarti ngakarninyi ngaju. Munu wirtu nyampali jarrinyaku ngaju milpanyarna. Munu palajun jilamarna ngajulu. Ngaju milpanyarna marrngurrangukarti ngalypa jinaku janaku. Marlkarri jarrulumarnajanaku wankanyu jinaku janaku. Ngajulu marlkarri jarrinyajalu wankanyu jilamarnajaninyi kurrngal marrngurrangu ngunarrijirri. Palajalu kurrngal Ngarrkanga kajalapiyi, wankanyu wantulupiyi ngarramarnti.” ");
INSERT INTO nna_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus-pa palinymilirrangupa jinta kurrngal palanga tawunja milpanyiyi, ngapingi, Jericho-nga. Palanga wapirripirri yanayi. Palanga ngunarrikarti wangka yanayili pirirringi, yini paliny Bartimaeus, partany paliny Timaeus-mili. Pampuru paliny, munu yirrirnaka. Ruwurtumartaji kajarnikinyi, warnkukupa mayiku japirr marnikinyijaninyi marrngurrangu milyanga kanka jukurti pirnikinyiyi pipurru palinyja. ");
INSERT INTO nna_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Palanga marrngurrangulu wurrarnayarningu, “Palama pirirri yananyi pipurru Jesus, Nazareth-ja.” Pampurulu pinakarrinyajalu kamarnikinyi, “Jesus-kayi, King David-mili pujamukayi, paju karrulupijinkurra.” ");
INSERT INTO nna_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jintalu warnta marnikinyiyi, wurrarnikinyiyalu, “Jama jarra!” Munu. Marrja kamarnikinyi yija, “Jesus-kayi. Paju karrulupijinkurra.” ");
INSERT INTO nna_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus wararr karrinyi, karra marna, “Paliny kayi malayi.” Palinyja muwarrja pala pampuru kayi marnayi. “Ngarlu ngalypa jarra. Kayi marnanta.” ");
INSERT INTO nna_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Palangangarra ngurriny ngurntingi kalkunaja parnpina wirrirni, janyin wararr karrinyi, Jesus-karti milpanyili. ");
INSERT INTO nna_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus-ju japirr marna, “Ngani jilamarnanga nyuntuku?” “Miranu jinakata, ngaju panijirri ngalypa jiliminyin.” ");
INSERT INTO nna_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Yuu, jipi yankuluman. Yijalmarta jirnijin nyuntulu. Palajalu ngalypa jinarnanta.” Palangangarra panijirri ngalypa jarrinyipulu. Palajangarra yajarnikinyi Jesus palalu pirirrilu ruwurtungu. ");
INSERT INTO nna_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalem-karti wangka jarrinyiyi, warnkungu wirtungu karntinyiyi, yini Mount of Olives. Warnkungu nyarranga kujarra tawunjirri, yini wariny Bethphage, wariny yini Bethany. Palanga Jesus-ju kujarra ngakarnapulinyi palinymilirranguja walangkarr yananyaku. ");
INSERT INTO nna_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Karra marnapulaku, “Palakarti tawunkarti walangkarr yankulunyumpulu. Jampa milpanyakanu, tangki yirrilkulunyumpulu, yangupala, kunymanaja palanga. Munu jarntu jirnimiyi pala. Ruwupu yinji pilipulu mungkaja, tangki yakujani kangkulunyumpulu. ");
INSERT INTO nna_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yijapa warinyju japirr malkulunyumpulinyi, 'Nganijalu pala jirninyumpulu?', karra malkulunyumpulalu, 'Nyampalingarra nyunguku karrinyi. Palaja ngakalkuliny tangki nyungukarti.'” Palajun wurrarnapulaku Jesus-ju. ");
INSERT INTO nna_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Palaja yanapulu, tawunja yangupala tangki yirrirnipulu, mayamartaji, kunymanaja jawapirtingi. Ruwupu mungkaja yinji pirnipulu. ");
INSERT INTO nna_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jintalu wararr karrinyajalu japirr marnayipulinyi, “Nganijalu pala ruwupu yinji pirninyumpulu?” ");
INSERT INTO nna_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Puntaju karra marnapulu muwarrjalu Jesus-milijalu. Palaja yakarnayipulinyi. ");
INSERT INTO nna_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesus-karti kanyapulu. Kujarrapa warajalu ngurrinyarrangu janamili tangkingi wirrirniyi. Karntinyili Jesus. ");
INSERT INTO nna_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kurrngalju janamili ngurrinyarrangu wirrirniyi walpurrakata ruwurtungu walangkarr palinyku. Jintalu parrkarrangu wirrkarnayi ruwurtumartijingi, wirrirniyijaninyi parrka pukurl ruwurtungu. Karrinyayi janalu wirtu nyampali jinaku Jesus-ku, pala nyampali yini marnayi King. Palajalu palajun jirniyalu. ");
INSERT INTO nna_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Jesus-ju jarlingi pirnikinyi tangki, jinta jinangu yananyikinyiyi nyirrirnipa walangkarr palinymartaji. Kamarnikinyiyi, “Ngarrka ngalypa yiji! Palinyja purlpija muwarrja nyungu pirirri ngakarnanganyjurruku, king jarrinyaku nganyjurruku. Nyungu pirirri wantulinynganyjurruku king ngalypakata, palakapali purlpija nyampalikapali, King David-kapali. Kalkulkulinynganyjurrinyi ngalypa ngarramarnti. Ngarrka ngalypakata yija!” Palajunmarta wurrarnikinyiyi marrjalu. ");
INSERT INTO nna_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jerusalem-ja kaninykarti ngalpanya Jesus. Palanga punja waninyikinyi maya wirtujina yija, purlpija yarni marnayi, muwarr pinaku Ngarrkaku palanga. Pala maya yini marnikinyiyi Temple. Palakarti Temple-karti Ngarrkamilikarti yana Jesus. Ngalpanyakanu, tukulu parrjarn-parrjarnikinyi. Purlpi kara ngalpanya karrpu. Palaja Jerusalem-ja jalakarti yanayi Jesus-pa palinymilirrangu pirirrimarta, kulpanyiyi tawunkarti wupartukarti, Bethany-karti. ");
INSERT INTO nna_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Marntungu Bethany-ja Jesus Jerusalem-karti yananyikinyi, janparr karrinyi. ");
INSERT INTO nna_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kaja yirrirni mungka, ngapi, olive mungka, mayikata pala. Parrka marlukata. Jesus palakarti yana, mayiku kanyjin-kanyjinaku. Jampa wangka milpanya, munu, mayimajirri, parrkajakun. ");
INSERT INTO nna_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Muwarr pirnalu palaku mungkaku, “Kuwarringulu mayimajirri wantuluman ngarramarnti. Nyuntuja munu yarrana ngalkulupiyi.” Palajun wurranaja, pinakarrinyiyi palinymilirrangulu marrngurrangulu. ");
INSERT INTO nna_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalem-ja milpanyiyi, Ngarrkamili Temple-karti yanayi. Temple-ja kaninykartingi waninyikinyiyi kurrngal. Palanga jinta kukurnjarijartiny, jinta kurlukukujartiny. Jintalu warnkujartinyju mananyikinyiyijaninyi palarrangu kuwiyi, marlkarri jinakupa yinganyaku Ngarrkaku. Janamili warnku munu yinganyakayi palarranguku kukurnjarikupa kurlukukuku. Warinyjakun warnkujakun, Temple-mili warnkujakun, palajakun yinganyaku. Jintalu kanganyikinyiyijanaku warnku janamili, puntaju yinganyikinyiyijanaku Temple warnku. Mitulu wirtu warnku kanganyikinyiyijanaku, yinganyikinyiyijanaku wupartumarta Temple warnku. Ngalpanyajalu Jesus-ju parnpirni tayipularrangu janamili ngarlu kanka, kurlukukukarramili kajanapintirrangu pukun parnpirni. Jalakarti yirtil marnajaninyi warnkuku yinganyakatarrangupa warnkuku mananyakatarrangu. ");
INSERT INTO nna_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jinta Temple-ja yananyikinyiyi wapirripirri, wurrukarra kanganyikinyiyi. Jesus-ju kunta jirnijaninyi. ");
INSERT INTO nna_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wiyirrja wurrarnajanaku, “Mirli-mirlingi Ngarrkamilingi purlpija warinyju yarntarna nyungu muwarr: 'Ngarrkamili Maya wiyirrku ngunarrijirriku marrnguku. Nyungungu Ngarrkaku muwarr pilipiyalu.' Munu yiji! Kunta jirnikinyinyurrujaninyi yija. Nyurralungarra Ngarrkamili Maya ngulyukatamilirrangu jirninyurru.” ");
INSERT INTO nna_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Palarrangulu Jew-arrangumilalu mangunykatarrangulu pinakarrinyikinyiyalu palinymilaku muwarrku. Wirnti waninyikinyiyalu palinyjamarra. Kukujarrilu wurrarnikinyiyarninyi, “Wunyjurrulu Jesus marlkarri wirlalaminyi?” Jinta wiyirr marrngurrangu karrinyikinyiyalu Jesus-ku. Palinyjalu miranu jinajalu pikaly jirnikinyijaninyi yija. ");
INSERT INTO nna_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jarurrukarti jarrinyaja Jesus-jupa palinymilirrangulu Jerusalem yakarnayi. ");
INSERT INTO nna_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Marntungu yarlipala yananyikinyiyi ruwurtungu Jerusalem-karti, nyarra mitukata mungka yirrirniyi, tikirl. Marlkarri ngarramarnti pala. ");
INSERT INTO nna_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter-lu kurlkarri marna pala muwarr Jesus-mili. Wurrarnili, “Miranu jinakatakayi, parrjala! Pala mungka mayimajirri, warinymaljanga muwarr pirninpalu minyirrju, kuwarri marlkarri yija.” ");
INSERT INTO nna_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus-ju puntaju wurrarnajanaku, “Yijalmarta jilkulunyurrulu Ngarrkanga. ");
INSERT INTO nna_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yija nyungu muwarr wurrarnarninyurruku, yijapa nyuntulu wurralamanpili palanga warnkungu wirtungu rurrinyaku, 'Parnpilarninyi kujungurrungu!' Nyuntumilija muwarrja yijalmarta jinaja, munu mitu yakanaja, palajunngarra jarrulumangu. ");
INSERT INTO nna_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nyungu muwarr pirnarninyurraku, jampa muwarr pirnangkulumanpalu Ngarrkaku, nganikupa japirr malaman, palaku Ngarrkanga yijalmarta jilalu. Palaja palangarra jilamanga. ");
INSERT INTO nna_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jampa muwarr pirnangkulumanpalu Ngarrkaku, kurlka jarruluman, 'Nganurtulu kurlu jirnija ngajuku?' Palaja nyuntulu kurlkarri manajalu munu kulilu yirrilamanpalu, puru yakalaman paliny. Puntaju nyuntumilalu Japartulu Kankajirringulu munu kulilu yirrilamanta, puru yakalamanta nyuntu kurlu jinaja.” ");
INSERT INTO nna_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yarranakanu Jerusalem-ja milpanyiyi. Jesus ngalpanya kaninykurti Ngarrkamilingi Temple-ja. Milpanyiyalu palarrangu Jew-arrangumilaku mangunykatarrangu wiyirr. ");
INSERT INTO nna_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Minyirrju japirr marnayi, “Palarrangu marrngurrangu warinymaljanga Temple-ja yirtil marnanjaninyi jalakarti, nganurtulu wurrarnangu palajun jinaku? Nganurtulu nyampali jirninti nyuntu?” ");
INSERT INTO nna_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus-ju puntaju karra marnajanaku, “Ngajulukurra japirr malamarnanyurrinyi muwarr. Yinku muwarr yungkuluminyinyurru. Palaja wurralamarnanyurruku nganurtulu wurrarniji palajun jinaku. ");
INSERT INTO nna_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wurralapijinyurru, pala pirirri, John, wurrarnikinyijanaku kurlu yakalapiyi, ngapangapa jirnikinyijaninyi. Nganurtulu palajun jinaku wurrarnili John-ja? Wurrarnili Ngarrkalu? Wurrarnili warinyju marrngulu? Nyurralu wurralapijinyurru muwarr.” ");
INSERT INTO nna_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kukujarrilu wurrarnikinyiyarningu. “Wunyjurru muwarr pilaminyi? Yijapa muwarr pilinyili yakujun, 'Wurrarnili Ngarrkalu'. Puntaju palinyju karra malkulinynganyjurruku, 'Palajalu nganijalu palinyja munu yijalmarta jinamanyurrulu?' ");
INSERT INTO nna_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Muwarr wariny wurralanyili. Muwarr pilinyili, 'Wurrarnili puru marrngulu'. Munu! Munurla palajun muwarr pirnakanyi!” Palajun kukujarrilu wurrarnikinyiyarningu. Jana waninyikinyiyi wirnti yiji marrngurrangungamarra. Marrngurrangulu wiyirrju kurlkarri marnikinyiyi yija-yiji John ngakarnajanaku Ngarrkalu, miranu jinaku Ngarrkamilaku muwarrku. ");
INSERT INTO nna_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Palajalu mangunykatarrangulu wirntilu karra marnayalu, “Munumpa nganarna palaku.” Jesus-ju puntaju wurrarnajanaku, “Munu yinku muwarr yingamijinyurru. Puntaju munu wurralamarnanyurruku nganurtulu wurrarniji jalakarti ngakanaku palarrangu marrngurrangu.” ");
INSERT INTO nna_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Warajanga karrpungu Jesus palanga mayanga wirtungu kajarnikinyi, mayanga Ngarrkamilingi, Temple-ja. Wirtu pakuji warnkupinti palanga waninyikinyi. Marrngurrangulu kanganyikinyiyalu warnku Ngarrkaku, wirrirnikinyiyi palanga pakujingi. Jesus wangka palanga warnkupinti pakujimartaji kajarnikinyi. Warnku wirrirnikinyiyi, palinyju parrjarnikinyijaninyi. Jintalu warnkujartinyju kurrngaljartinyju warnku wirtumarta wirrirniyi. ");
INSERT INTO nna_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Palaja mirtawa kampurta pujunu milpanya. Palinymili pirirri purlpi marlkarri jarrinyi. Kujarra wupartujirri warnkujirri wirrirnalu Ngarrkaku. Kujupurru pala. Palajirri yinganyaja warnkumajirri pala mirtawa. ");
INSERT INTO nna_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jesus-ju wurrarnajanaku palinymilirrangungu, “Yirrirninyurru pala pujunu mirtawa? Wupartu yiji warnkujartiny. Palinyju wiyirr wirrirnalu Ngarrkaku. Kuwarri warnkumajirri waninyi mayikupa nganikupa paliny. Yija nyungu muwarr wurrarnarninyurruku, palarrangu warinyarrangu warnku kurrngaljartiny. Kurrngalja puru jinta yinyayili Ngarrkaku. Janalu wupartumarta wirrirniyili Ngarrkaku. Palalu pujunulu kampurtalu mirtawalu wirtumarta wirrirnalu. Palinyju puru wiyirr yinyalu Ngarrkaku.” ");
INSERT INTO nna_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Palanga warrarnja turlparramarta jarrinyajanga Jew-arrangu ngunarrikurnujirrija kunmu jarrinyikinyiyi Jerusalem-ja. Palanga wupartu kukurnjari wirlarnikinyiyijaninyi, waraja maya warinyku, waraja maya warinyku, palajun. Martumpirri lalypa kamparnakinyiyi raparrku jinapintimajirri. Warrukartingi warajanga, wirlarra wirtu jarrinyaja, pala kuwiyipa martumpirri lalypa ngananyikinyiyi. Palajun jirnikinyiyi Ngarrkamilija muwarrja, kurlkarri marnikinyiyi purlpi warrarnja Egypt-ja waninyikinyiyi, kurluny-kurlunyja waninyikinyiyi. Palaja Ngarrkalu wanka jirnijaninyi, kanyajaninyi warrarnja Egypt-ja. Turlparra jarrinyijanaku. Kuwarrimarta Jerusalem-ja jana kunmu jarrinyikinyiyi palaku purlpijaku kurlkarri manaku. Karrpuja kujarraja nyarrarrangu wuparturrangu kukurnjarirrangu wirlalapiyi. Palarrangulu Jew-arrangumili mangunykatarrangulu Jesus-ku kukujarrilu warlinaku karrinyiya, marlkarriku wirlanaku. ");
INSERT INTO nna_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wurrarnikinyiyarningu, “Wunyjurru jiliminyi? Munu warlilkunyi kurlkarri manapintingi partijirringi. Kurrngalju wurrarnayi Ngarrkalu ngakarna Jesus nganyjurruku king jarrinyaku, nganyjurrumili nyampali waninyaku ngarramarnti. Yakujun wurrarnikinyiyi marrngurrangulu. Tuku jilkunyarninyi janangamarra, kukujarrilu jiliminyi yirrinangamarra. Kurlu jiliyinganyjurrakalu janalu.” Palajun muwarr pirnikinyiyarningu palarrangulu mangunykatarrangulu. ");
INSERT INTO nna_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Palanga tawunja Bethany-ngi Jesus milpanya, mayanga kaninykarti ngalpanya ngapimilingi, Simon Leper-milingi. Ngananyikinyiyi, milpanyajanaku mirtawa wupartujartiny parturljartiny. Winya pala, parnti jurikata, ngalypakata yija, warnkulu wirtulu yija mana pala. Mirtawalu milya kankarni ngartarnili nyarraja parturlja, parnti jurikata ngalypakata jurnturtungu Jesus-ja jurtirnili. ");
INSERT INTO nna_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jinta palanga kuli jarrinyiyi, wurrarnikinyiyarningu, “Nganijalu palajun jirni? Kurlu jirni yija. ");
INSERT INTO nna_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yingama warnkuku wirtuku pala parnti jurikata. Wirtu warnku manama. Palaja pala warnku yija yingamajaninyi pujunurranguku.” Palajun muwarr pirnikinyiyi. Mirtawa nyarra yijalu warnta marnayi. ");
INSERT INTO nna_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus-ju puntaju wurrarnajanaku, “Yakaliya paliny. Nganijalu warnta marnanyurru? Yija ngalypakata jirnija. ");
INSERT INTO nna_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nyurranga pujunurrangu wantulupiyi ngarramarnti nyungungu. Karrpurrangu karrpungu jana warnku yungkulunyurrujaninyipa. Munu nyurranga ngaju punja wantulumarnanyurruku. Jampa wantulumarna, palaja marlkarri jarrulumarna. ");
INSERT INTO nna_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yijalu ngalypa jirnija palinyju. Nyungu parnti jurikata ngalypakata kawungu ngajungu jurtirniji kuwarrilu palinyju ngalypa jinaku jungkaraku yartiku. ");
INSERT INTO nna_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yija nyungu muwarr wurrarnarninyurruku, ngunarrijirringi ngaju wurralapiyijanaku marrngurrangungu wiyirrja, wurralapiyijanaku pukurl nyungulu mirtawalu palajun jirnija. Kurlkarri malapiyi nyungu mirtawa.” ");
INSERT INTO nna_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Palaja waraja pirirri yana nyarrarrangukarti Jew-arrangumili yatilarrangukarti. Paliny yini Judas Iscariot, Jesus-milirrangungu waraja paliny. Wurrarnajanaku yatilarrangungu, “Ngajulu kangkulumarnanyurrinyi Jesus-karti. Jurti jinaja, warlilkulunyurru.” ");
INSERT INTO nna_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Palinymili muwarr pinakarrinyaja pikaly jarrinyiyi, wurrarniyili, “Yijapa palajun jilaman, warnku yija yungkulupiyirninti.” Palaja Jutaja mimarnikinya, kurlkarri marnikinyi palinyju, “Nyanga kangkulumarnajaninyi Jesus-ku warlinaku?” ");
INSERT INTO nna_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nyarra karrpu jarrinyijanaku wupartu kukurnjari wirlanaku Jew-arrangulu. Palanga karrpungu palinymilirrangulu japirr marnayi Jesus, “Wanyjarnikarti yankulupiyirni jilkulupiyirni kaninypirtilu nganyjurrulu palaku kukurnjarikupa lalypaku martumpirriku ngananyaku?” ");
INSERT INTO nna_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Palinymilirranguja kujarra manapulinyi, wurrarnapulaku, “Yankulunyumpulu, Jerusalem-ja ngalpulunyumpulu. Pirirrilu ngapapintijartinyju purrpija kululkulinyumpulinyi. Paliny yajalkulunyumpulu. ");
INSERT INTO nna_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wirtungu mayanga ngalpuliny. Ngalpulunyumpulu pukun. Kaninykarti yirrilkulunyumpulu pala ngurrara. Muwarr pilkulunyumpulalu, 'Nganarnamilalu miranu jinakatalu wurrarnangu, “Wanyjarningi ruwumu yarta jilaman, palangangarra mayi ngalkulupiyirni, pala kukurnjaripa lalypa martumpirri, ngajulupa ngajumilirrangu marrngurrangulu?”' ");
INSERT INTO nna_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Palinyju jurti jilkulunyumpulinyi wirtukata ruwumu. Palanga jilkulunyumpulu kaninypirtilu nganyjurruku.” ");
INSERT INTO nna_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yanapulu. Jerusalem-ja ngalpanyapulu, palajun jarrinyipulaku Jesus-milija muwarrja yija. Palanga yarta jirnipulu kaninypirtilu. ");
INSERT INTO nna_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jarurrukartingi milpanyiyi Jesus-pa jinta palinymilirrangu. ");
INSERT INTO nna_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mayi ngananyikinyiyi, wurrarnajanaku Jesus-ju, “Yija nyungu muwarr wurrarnarninyurruku, nyurraja warajalu kurntanymajirrilu muwarr kangkulinyjanaku yatilarrangukarti, warliliminyiyi. Palinyjungarra kuwarri ngananya nganyjurrungu nyungungu.” ");
INSERT INTO nna_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Paju karrinyiyi, ngarlu kurlu jarrinyiyi palinymilirrangu. Japirr marnikinyiya warajapa warajalu, “Wunyjurru? Ngajulu?” ");
INSERT INTO nna_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Puntaju Jesus-ju karra marnajanaku, “Nyurrajangarra warajalu palajun jilkuliny, martumpirri malya jilkulupalayi palinyju, nganyjurrungu nyungungu pala. ");
INSERT INTO nna_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Marlkarri jarrinyaku ngaju muwarrja Ngarrkamilija, ngajuku mirli-mirlingi Ngarrkamilingi yarntarniyi palajun purlpi. Palaku pirirriku palajun jinajaku kuwarrijaja palinykungarra kurluny-kurluny jarruliny yiji ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mayi ngananyikinyiyi Jesus-ju mana martumpirri, Ngarrkanga wurrarnala, “Nyuntulungarra martumpirri nyungu yinyannganinyi. Yarranijayi! Wanka jinannganinyi!” Palaja ngartanakanu yinyajaninyi kutarrangu, wurrarnajanaku, “Marrayi, mayi nyungu ngalayi. Nyungulu martumpirrilu kurlkapirli jilkulunyurrinyi kawuku ngajumilaku. Jampa jintalu kawu ngaju yija wirlalaminyiyi. Kuwarringulu martumpirri ngananyangkulunyurru, kurlkarri malaminyinyurru ngaju kawu, janalu wirlarninyiyi marlkarri.” ");
INSERT INTO nna_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Palaja minpinapintingi wayin mana, Ngarrkanga wurrarnala, “Nyuntulungarra wayin nyungu yinyannganinyi. Yarranijayi! Wanka jinannganinyi!” Yinyajaninyi, warajapa warajalu minpirniyi. ");
INSERT INTO nna_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wurrarnajanaku, “Nyungulu wayinju kurlkapirli jilkulunyurrinyi pijirriku ngajumilaku. Ngajumili pijirri warrkilkuliny ngajungu marlkarringi marrngurranguku kurrngalku. Yijalu Ngarrkalu ngakarnanyi marrngurrangu jurtuku muwarrku yinganyaku. Ngajulu marlkarri jarrinyajalu nyarra jurtu muwarr Ngarrkaja yija yakalamarnajanaku. Nyurralu wayin minpinangkulunyurru, kurlkarri malkulunyurru pijirri ngajumili, marlkarri jarrinyarna ngaju marrnguku kurrngalku. ");
INSERT INTO nna_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yija nyungu muwarr wurrarnarninyurruku, nyungungu warrarnja munu yarranakanu wayin minpilimarna ngajulu. Yarti Ngarrkalu, ngajumilalu japartulu, ngaju wirriliminyi nyampali wiyirrku. Palaja yarrana minpilamarna ngajumilirrangungu.” ");
INSERT INTO nna_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Palaja yinma Ngarrkaku kurntarniyi, palakarti Mount of Olives-karti yanayi. ");
INSERT INTO nna_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yananya kawarnikinyiyi Jesus-ju wurrarnajanaku, “Yija-yiji ngaju yakalaminyinyurru nyurralu. Mirti-mirti jarrulunyurru jirrja.” Jesus miranu nyunguku Ngarrkamilija Muwarrja. Palajun purlpilu yarntarna warinyju mirli-mirlingi Ngarrkamilingi, “Ngarrkalu wirlalkuliny marlkarri kukurnjarirrangumili nyampali, kukurnjarirrangu wiyirr mirti jarrulupiyi jirrja.” Miranu Jesus, pala muwarr palinyngarra. Ngarrkalu yini marnikinyi Jesus kukurnjariku nyampali, yini marnikinyijaninyi palinymilirrangu warrkamu pulukurrangu kukurnjarirrangukapali. Ngarrkalu palajun muwarr pirni, palinyju marlkarri wirlalkuliny Jesus, wiyirr mirti jarrulupiyi palinymilirrangu marrngurrangu. ");
INSERT INTO nna_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Palaja Jesus-ju wurrarnajanaku, “Marlkarri jarrinyakanu ngaju, yarrana wanka jarrulumarna. Galilee-karti yija yankulumarna, ngaju walangkarr jarrulumarnanyurruku.” ");
INSERT INTO nna_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter-lu karra marnalu, “Jintalu yakalayintili, munu yakalamarnanta ngajulu.” ");
INSERT INTO nna_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Puntaju Jesus-ju karra marnalu, “Yija nyungu muwarr wurrarnarningu, warrukartingi nyungungungarra kujarrapa warajamalja ngaju wurralamanjanaku, mitu malamanjaninyi, 'Munumparla palinyku ngaju.' Palajun muwarr pilamanjanaku. Palaja rooster-lu kamalkuliny kujarramal.” ");
INSERT INTO nna_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Puntaju Peter-lu karra marnalu, “Palangarra yija munu wurralamarnajanaku. Wirlalinyiyili, marlkarringi munu yiji yijalu palajun wurralamarnajanaku.” Jintalu wiyirrju Jesusmilirrangulu palajun pukun muwarr Jesus-ja wurrarniyili. ");
INSERT INTO nna_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Milpanyiyi palakarti, ngapikarti, Gethsememane-karti. Palinymilirrangungu wurrarnajanaku, “Kajalkulunyurru nyungungu. Ngarrkaku muwarr pilamarnalu.” ");
INSERT INTO nna_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Palinyju kanyajaninyi Peter-pa James-pa John, yanayi walangkarr wangkangarra. Jesus ngarlu kurluny-kurluny yija jarrinyi. ");
INSERT INTO nna_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Palaja wurrarnajanaku, “Ngarlu wurnmanyarni ngarramarnti ngaju. Paju karrinyaja yijapa marlkarri jarrulumarna. Nyungungu wantulunyurru, mintu wantulunyurru, jarrurlju kalkuluminyinyurru.” ");
INSERT INTO nna_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Palaja Jesus wangka yanajanaku, pajulu warnti pirnarninyi jungkanga, palaja marrja yija muwarr pirnikinyili Ngarrkaku. Wurrarnala, “Japartukayi, ngajumili japartu walja, nganikupa karrinyanpa, pala jilaman. Yija marlkarri jinaku karrinyajiyi marrngulu jintalu. Munu marlkarriku karrinyakarna. Nyuntulu kunta jilamanjaninyi. Palaku karrinyarna ngajulu. Puru yakalamarna. Nyuntu karrinyanpa jintalu wirlalaminyiyi marlkarri, puru marlkarri wirlalaminyiyi. Munu kunta jilamarnajaninyi.” ");
INSERT INTO nna_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesus-ju kulpanyakanu yirrirnijaninyi, kupalya jarrinyiyi palarrangu kujarrapa waraja. Peter-nga wurrarnala, “Nganija Simon Peter-kayi, nyuntu kupalya jarrinyan? Jampapa parrily waniman?” ");
INSERT INTO nna_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Wurrarnajanaku, “Parrily wantulunyurru, Ngarrkaku muwarr pilkulunyurrulu. Mirurrulu kawanyurrinyili, kurlu jilinyurrulu. Nyurralu yirrkulu Ngarrkanga yijalmarta jinaku karrinyinyurru, yija nyurra manyurla jarrinyanyurru. Palajalu japirr malkulunyurru Ngarrka, tuku jilkulunyurrinyi.” ");
INSERT INTO nna_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Palaja yarranakanu Jesus yana, yarrana Ngarrkaku muwarr pirnikinyili, nyarralungarra muwarrju. ");
INSERT INTO nna_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yarranakanu palarrangukarti kujarrapa warajakarti kulpanyajanaku. Yarrana kupalya jarrinyiyi. Kupalyakarra karrinyikinyiyi. Kurntanyja waninyikinyiyarningu. ");
INSERT INTO nna_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Yarranakanu Jesus yana, muwarr pirnili Ngarrkaku, yarranakanu kulpanya wurrarnajanaku, “Yirrku kupalya jarrinyinyurru? Jipi! Parrily jarrayi! Palamalungarra marrngulu ngaju yajarnikinyinyipa warrukartingi kuwarringi ngaju jurti jirninyijanaku kurlujartinyja marrngurrangungu. Warliliminyiyi. Parrjalayi! Kuwarringarra milpayinyi. Wararr karrayi! Purrpi malaminyijaninyi.” ");
INSERT INTO nna_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jampa Jesus-ju muwarr pirnikinyijanaku, wangkapalaji milpanya Jutaja. Jesus-milirrangungungarra paliny. Palinyja milpanyiyi kurrngal, jantujartiny, wirrkanapintipa yurluku. Jew-arrangumilalu mangunykatarrangulu ngakarniyijaninyi. ");
INSERT INTO nna_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jutajalu purlpi wurrarnajanaku jinmurntu jinakatarrangungu nyungu muwarr: “Yampu malamarna waraja. Palinyngarra warlilkulunyurru, tukulu kangkulunyurru!” ");
INSERT INTO nna_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jampa Jutaja milpanyakanu, Jesus-karti yana, kayi marna “Miranu jinakata”, yampu marna. ");
INSERT INTO nna_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Palanga Jesus marrjalu warlirniyi. ");
INSERT INTO nna_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Warajalu Jesus-milirrangungulu palanga wararr karrinyajalu wirrkanapintijartinyju walyi malyarnili marrnguku. Kurlkajakun wirrkarna. Nyarra marrngu warrkamukata Wirtu Yatilmili. ");
INSERT INTO nna_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Palaja Jesus-ju japirr marnajaninyi, “Nganijalu yurlukujartinypa wirrkanapintijartiny milpanyanyurru ngajuku warlinaku, jinmurntu jinaku? Ngaju kulikatawayi, ngulyukatawayi. ");
INSERT INTO nna_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Karrpurrangu karrpungu Ngarrkamilingi Temple-ja miranu jirnikinyirnijaninyi. Nyurra palangangarra waninyikinyinyurru. Nganijalu munu jinmurntu jirniminyinyurru palanga? Mirli-mirlingi Ngarrkamilingi purlpi yija yarntarna ngajuku, palajun jiliminyinyurru. Palajun jiliyi. Munu kunta jilamarnanyurrinyi.” ");
INSERT INTO nna_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Palaja palinymilirrangulu Jesus yakarnayi ngarramarnti, mirti jarrinyiyi yija jana wiyirr. ");
INSERT INTO nna_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Warinyju, yangupalalu pirirrilu, Jesus yajarnikinyi. Palinyju kawu yamarnarninyi waralu warajalujakun. Jintalu jinmurntu jinaku partarl warlirniyi. ");
INSERT INTO nna_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Palinymili wara yakarna, mirti jarrinyi kurta. ");
INSERT INTO nna_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yatilarrangupa miranu jinakatarrangupa mirtanyarrangu mayanga wirtujinanga kunmu jarrinyikinyiyi. Pala maya Wirtu Yatilmili. Jinmurntu jinakatarrangulu palakarti mayakarti kanyayi Jesus. ");
INSERT INTO nna_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter-lu yajarnikinyijaninyi, kajamartalu, Wirtu Yatilmilingi mayanga kiyirtingi ngalpanya paliny pukun. Pala maya wirtujina yiji, ruwumurrangu nyarrakurnujirri, courtyard-jartiny partijirri kaniny. Peter palangangarra courtyard-ja ngalpanya. Palanga partijirringi warrkamukatarrangu kajarnikinyiyi, Wirtu Yatilmilirrangu marrngurrangu jana. Parrpa jirnikinyiyiyarninyi wikanga. Peter kajarnajanaku, parrpa jarrinyaku. ");
INSERT INTO nna_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mayanga palarrangulu yatilarrangulupa nyampalirrangulu, wiyirrju Wirtulu Kimitilu, malyparr karrinyiyalu Jesus-ku. Palinyku marlkarri jinaku karrinyiyalu. Kanyjirnikinyiyijanaku marrngurranguku muwarr pinaku, mitu manaku, “Ngajulu yirrirnirni Jesus-ju panypanyala Ngarrkamilingi mangunyja.” ");
INSERT INTO nna_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kurrngalju mitulu muwarr kanganyikinyiyi Jesus. Warinypa wariny muwarr janamili, janamilirrangu muwarr rurru pirnayarninyi. ");
INSERT INTO nna_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jinta wararr karrinyiyi, nyungu mitulu muwarr kanyayi Jesus, ");
INSERT INTO nna_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Paliny muwarr pirni, pinakarrinyiyirni nganarnalu, 'Ngarrkamili Temple, yarni marnayi marrngulu, yija ngartalamarna ngajulu, karrpurrangungu kujarrapa warajanga wariny Temple yarni malamarna ngajulu, munu marrngulu palajun yarni marnakayi.'” Palajunju mitu marnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Janalu pukun muwarrarrangu warinykurnu jirnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Palaja wararr karrinyi Wirtu Yatil, walangkarr wararr karrinyijanaku. Wurrarnili Jesus-ja, “Ngukarri marnikinyiyinti. Nyuntulu puntaju karra marnamanjanaku. Ngani muwarr pilamanjanaku?” ");
INSERT INTO nna_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesus jama waninyi, munu muwarr pirnama. Yarrana Wirtulu Yatilju wurrarnili, “Ngarrkalu ngakalkulinynganyjurruku partany walja, nyampali wirtu waninyaku nganyjurruku. Wunyjurru? Ngani wurrarnanparningu? Nyuntungarra nyarra Ngarrkamili?” ");
INSERT INTO nna_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Puntaju Jesus-ju, “Yuu, palangarra ngaju. Yirriliminyinyurru ngaju, kajalamarna Ngarrkamartaji, marrjanyukartingi palinyja. Palaja yirriliminyinyurru kankajirrija mujungungu kulpulumarna.” ");
INSERT INTO nna_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Palaja muwarrja Wirtulu Yatilju wurru palinymili ngartarnarningu. (Jew-arrangulu kuli jarrinyajalu palajun jirnikinyiyi purlpilu.) Karra marnajanaku, “Nyurralu pinakarrinyinyurru palinymili kurlu muwarr. Muwarrja palinymilija yijalu jakurl kanganyamajirri miranurla nyurra. Wunyjurru wurralkulunyurrulu?” Puntaju kulpanya wurrarniyili wiyirrju, “Yija marlkarriku wirlanaku.” ");
INSERT INTO nna_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jintalu janga pirnikinyiyili Jesus-ja. Palanga ngumpa paliny kunymarniyi waralu, parirrju wirlarnikinyiyi. Nyurni marnikinyiyi, “Nganurtulu wirlarnanta?” Palanga marrngurrangulu Wirtulu Yatilmilalu kanyayi, parirrju parlju wirlarnikinyiyi. ");
INSERT INTO nna_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Palajun jarrinyikinyi Jesus-ku, Peter yirrku kaniny waninyikinyi, courtyard-ja. Warrkamukata mirtawa milpanyili, Wirtumili Yatilmili paliny. ");
INSERT INTO nna_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter yirrirni wikanga wangka, parrpa jarrinyikinyi. Jurtu yirrinajalu wurrarnili, “Pala Jesus, Nazareth-ja, yija palinymilirranguja nyuntu.” ");
INSERT INTO nna_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peter-lu mitu marna, “Palinyku munumparla ngaju. Kakurnarnanta muwarr nyuntumili!” Palanga jampa yananyikinyi Peter jawapirtikarti, kiyirtikarti, rooster-lu kamarna palanga. ");
INSERT INTO nna_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mirtawalu jawapirtimartajingi yirrirni, wararr karrinyajarrangungu wurrarnajanaku marrngungu, “Nyungu pirirri waraja Jesus-milirranguja.” ");
INSERT INTO nna_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yarrana Peter-lu kunta jirni, “Munu!” Yarti palarrangulu wararr karrinyajalu wurrarniyili, “Yijarla Jesus-mili nyuntu. Galilee-ja nyuntu.” ");
INSERT INTO nna_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Palaja Peter-lu wurrarnajanaku, “Yija muwarr pirnirni. Ngajuku miranu Ngarrka. Mitu muwarrja ngaju wirlalinyili Ngarrkalu. Nyarra pirirri wurrarnijinyurru, yija palaku ngaju munumpa!” ");
INSERT INTO nna_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Palaja kamarna rooster-lu. Peter-lu pinakarrinyakanu, kurlka jarrinyi yija muwarr Jesus-mili, “Kujarrapa warajamalja ngaju wurralamanjanaku, mitu malamanjaninyi, 'Munumparla palinyku ngaju'. Palajangarra rooster-lu kamalkuliny kujarramal.” Palajun purlpi Jesus-ju wurrarnala Peter-nga. Peter tarlkarra manakanu kurlkapirli jarrinyi, palajunngarra palinyju jirni. Ngarlu wurnmanya kurntanyjartiny, ngangkurl jirnikinyi. ");
INSERT INTO nna_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pirrpa-pirrpa jarrinyaja kunmu jarrinyiyi yatilarrangupa miranu jinakatarrangupa mirtanyarrangupa jinta wiyirr nyampalirrangu, Wirtungu Kimitingi. Muwarr yimpirniyarningu. “Kangkuluminyi Jesus Roman-karti.” Palaja Jesus kunymarniyi, kanyayi Roman-karti wirtukarti nyampalikarti, yini paliny Pilate. Paliny Roman-milija warrarnja, Roman-milalu King-ju wirrirni Pilate nyampali Jew-arranguku. ");
INSERT INTO nna_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate-ju japirr marnikinyi Jesus, “Wunyjurru? Jew-arrangumili King nyuntu?” Jesus-ju puntaju marna, “Nyuntu palajun muwarr pirnan.” ");
INSERT INTO nna_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yatilarrangulu mitulu ngukarrirnikinyiyi Jesus, “Nganarnamilingi mangunyja panypanyikinyili palinyju.” ");
INSERT INTO nna_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Palaja yarranakanu Pilate-ju wurrarnili, “Pinakarrajaninyi, palarrangulu ngukarrirnikinyiyinti. Puntaju karra malaman?” ");
INSERT INTO nna_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jama waninyikinyi Jesus, munu puntaju marnamalu. Pilate-ju ngurnjul jarrinyikinyalu. ");
INSERT INTO nna_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Purlpi turlparrarrangu turlparranga, Jew-arrangulu kukurnjaripa lalypa martumpirri ngananyikinyiyi, Pilate-ju yinyji pirnikinyijanaku marrngu jinmurntuja, waraja ngakarnikinyijanaku. Nganurtuku karrinyikinyiya Jew-arrangu, palaku japirr marnikinyiyalu, palangarra Pilate-ju ngakarnikinyijanaku. ");
INSERT INTO nna_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","11","Palaja kuwarri kurrngal kunmu jarrinyiyi Jew-arrangu, Pilate-ku japirr manaku, “Jinmurntuja yinyji pilamannganaku waraja.” Pilate miranu jarrinyijanaku, yatilarrangulu mikulu yirrirniyili Jesus-ja, palajalu kanyayili. Palaja japirr marnajaninyi Pilate-ju, “Ngakalamarnanyurruku Jesus, Jew-arrangumili King?” Yatilarrangulu purlpilu wurrarnikinyiyijanaku Jew-arranguku marrngurranguku, jakurlirniyijaninyi japirr manaku Pilate-ku, “Yinyji pilamannganaku pala wariny pirirri, yini Barabbas.” Pala Barabbas jinmurntungu waninyikinyi, jinta pukurl palinykapali. Purlpi kuli partirniyijanaku Roman soldier-rrangungu, Roman-arrangu kujarrapa waraja marlkarri wirlarniyijaninyi. ");
INSERT INTO nna_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nyarraku Barabbas-ku japirr marnikinyiyi, puntaju Pilate-ju japirr marnajaninyi, “Pala Barabbas yinyji pilirnili, palaja wunyjurru jilirnili ngajulu nyungu wariny, pirirri yini marnanyurru 'Jew-arrangumili King'?” ");
INSERT INTO nna_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Puntaju kamalu karra marnikinyiyili, “Paliny nayilamu jilaman mungkanga. Palajun jinajalu marlkarri wirlala.” ");
INSERT INTO nna_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Yarranakanu Pilate-ju japirr marnajaninyi, “Nganijalu? Ngani kurlu jirni palinyju?” Kamarnikinyiyi yija marrjalu, “Paliny nayilamu jili mungkanga.” ");
INSERT INTO nna_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jew-arranguku pikaly jinaku karrinyi Pilate. Palaja Barabbas yinyji pirnijanaku, Jesus yinyajanaku soldier-nga, wurrarnajanaku wilypurnjartinyju wirlanakupa mungkanga nayilamu jinaku. ");
INSERT INTO nna_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldier-rrangulu kanyayi Jesus ngurrakarti janamilikarti, mayanga wirtujinanga ngalpanyiyi, courtyard-ja kaniny partijirringi kanyayi. Jinta soldier-rrangu kayi marnayijaninyi, “Kurtaliyi nyungukarti.” Palaja wurruku palinymilaku mirarniyi, Pilate-ja muwarrja Jesus wilypurnjartinyju wily pirniyi. Palaja nyurni marnikinyiyi yija. ");
INSERT INTO nna_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Manayi ngurriny pilyarri, ngalypakata yija, wirrirniyili. Mungkaja yirijartinyarrangu manayi, yarni marnayi ngapi, mangkakapali, wirrirniyili jurnturtungu Jesus-ja. ");
INSERT INTO nna_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Palaja nyurni marnikinyiyi, wurrarnikinyiyili, “King Jew-arranguku yija nyuntu.” ");
INSERT INTO nna_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mungkalu jurnturtu wirlarnikinyiyi, palinyja janga pirnikinyiyili, murtingi jurlpi-jurlpi jarrinyaja jinanga palinyja milya kaniny jungkanga jarrinyikinyiyili. Palajunmarta jirnikinyiyi palinyku nyurni manaku, wirtukapali paliny janaku. ");
INSERT INTO nna_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jipi nyurni manakanu, paliny ngurrinyku ngalypakataku mirarniyi, wurru palinymilingarra wirrirniyili. Palaja mungka wirtu palinyja ngurntingi wirrirniyi, palinyju kanganyaku, jinangu marntiku jirniyi jalakarti, ngapikarti, Golgotha-karti, mungkanga nayilamu jinaku, palanga marlkarri jinaku. ");
INSERT INTO nna_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Partijirri jarrinyaja soldier-rrangulu pirirri warlirniyi, ngajarri. Warrarnja Cyrene-ja paliny, yini Simon. Japartu Alexander-milipa Rufus-jumili. Jerusalem-karti milpanyikinyi. Roman soldier-rrangulu warlirniyi, jakurlirniyi kuliny-kulinyju paliny palaku wirtuku mungkaku kanganyaku, pala mungka Jesus-ku. ");
INSERT INTO nna_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Golgotha-nga milpanyiyi. (Pala yini Golgotha Jew-arrangumilingi muwarrja Pinka-Pinka wurrarnayi.) ");
INSERT INTO nna_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Palanga Jesus partarl yinyayi wayin mirrijinjartiny minpinaku. Parra-parrangamarra pala mirrijin. Jesus-ju munu minpirnama. ");
INSERT INTO nna_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","26","Soldier-rrangulu mungkanga nayilamu jirniyi, parirrjirri nayilamu jirniyi, jinajirri pukun. Mirli-mirlingi yarntarnayi nyungu muwarr, “Nyungu Jew-arrangumili King”, wirrirniyi pala kankarni mungkanga palinymartaji. Marntungu karrpu kanka jarrinyi, yarlipala, nayilamu jirniyi mungkanga Jesus. Palaja wurruku palinymilaku witi karrinyiyi, nganurtulu kangkulinypa pala. ");
INSERT INTO nna_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ngulyukatajirri nayilamu jirniyipulinyi warinyjajirri mungkangajirri palinymartaji, marrjanyukartipa jampukarti. ");
INSERT INTO nna_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Marrngurrangulu jukurti-jukurtilu parrjarnikinyiyi wangkalu nyurni marnikinyiyi paliny. Karra marnikinyiyalu, “Wurrarnan ngartalaman Ngarrkamili Temple, nyuntulu, karrpurrangungu kujarrapa warajanga yarni malaman. ");
INSERT INTO nna_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Katukala mungkaja, yinyji pinakanu wanka jilarninyi nyuntulu!” ");
INSERT INTO nna_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Palajunju wurrarnikinyiyi palarrangulu mangunykatarrangulu pukun, nyurni marnikinyiyi Jesus. Wurrarnayarningu, “Jinta wanka jirnikinyijaninyi. Munu palinyju wanka jinakarninyi. ");
INSERT INTO nna_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Purlpi wurrarnikinyi palinyju, 'Ngaju ngakarnanyi Ngarrkalu. Jew-arrangumili King ngaju.' Jampa katukalkuliny mungkaja paliny. Palajangarra nganyjurrulu yijalmarta jiliminyalu palinyja.” Mungkangapa ngulyukatalujirri pulanyju pukun nyurni marnikinyipulu Jesus. ");
INSERT INTO nna_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","Karrpu partijirringi parlparr warrukurla jarrinyi. Warrukurla palajunngarra waninyikinyi ruka-rukakartijakurl. Palaja Jesus marrja muwarr pirni, purlpimalulu muwarrju japirr marna Ngarrka, “Yiluyi, Yiluyi, lama japakajani?!” Pala muwarrju wurraninyi, “Ngarrkakayi! Ngarrkakayi! Nganijalu parnpina wirrirnanyin nyuntulu?” ");
INSERT INTO nna_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jintalu palangapa wararr karrinyajalu pala muwarr pinakarrinyajalu wurrarniyi, “Pinakarrayi! Kayi maninyi palinyju pala purlpija pirirri, Ngarrkamili Muwarr Pinakata, Yilayija.” ");
INSERT INTO nna_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Waraja mirti milpanya, wara malya jirni wayinja, milyanga mungkanga wirrirni, kanka jirni Jesus-ja jawanga, jangka jirnili ngumanaku Jesus-ju. Wurrarnajanaku, “Kula! Parrjalkunya! Yijapa milpuliny Elijah palinyku mungkaja kaniny jinaku.” ");
INSERT INTO nna_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Palaja Jesus-ju kamarna yija, warajamal nganyjurnu, wurrjirni. ");
INSERT INTO nna_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jerusalem-ja Ngarrkamilingi Temple-ja kaninykarti milyanga Ngarrkamilijakun pala. Wirtu Yatiljakun ngalpanyangkuliny palanga, munu jinta marrngurrangu. Walangkarr pala Ngarrkamilingi wilitiny jarrinyikinyi wirtu ngurriny. Ngampa pirnikinyi pala, ngalpanyangamarra marrngurrangungumarra. Jampa Jesus marlkarri jarrinyi pipurrungarra ngurriny pala laarr kanya yija, kankajirrija kaninykurnu jungkakartijakurl. ");
INSERT INTO nna_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ngapingi, Golgotha-nga, pala Roman soldier nyampali Jesus-martajingi wararr karrinyikinyi walangkarr parrjarnikinyi. Palaja yirrirnajalu palajun marlkarri jarrinyi Jesus, wurrarna, “Yijangarra nyungu pirirri Kankajirrikarringumili Partany.” ");
INSERT INTO nna_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Palanga kurrngal mirtawarrangu wararr karrinyikinyiyi, kajamartangulu parrjarnikinyiyi. Purlpi, Jesus yananyikinyi Galilee-ngi, palarrangulu mirtawarrangulu yajarnikinyiya, palinyku mayi kamparnikinyiyalupa nganin-nganin. Galilee-ja yajarniya paliny Jerusalem-karti. Kuwarri parrjarnikinyiyi kajamartangulu. Jananga Mary Magdalene-pa Salome-pa wariny Mary. (Pala wariny Mary pipi palinyngarra pulanyku, James Wupartukupa Joses-ku). ");
INSERT INTO nna_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Palakurtirra pirirri, yini Joseph. Paliny ngapija, tawunja Aramathea-ja. Nyampali paliny, mirtanya, Wirtu Kimiti marrngu paliny. Palinyku ngalypa wurrarnikinyiyalu wiyirrju. Punja mimarnikinyi, wurrarnikinyi, “Jampa Ngarrkalu ngakalkuliny wirtu, palinyjungarra milpanyajalu ngalypalu kalkulkulinynganyjurrinyi ngarramarnti.” Palangarra Joseph marrpalya yanalu nyampalikarti, Pilate-karti, japirr marna, “Kawu kangkulumarna Jesus, jungkaranga wirrilamarna?” Purlpi ruka-ruka. Jampa karrpu kara ngalpuliny. Palaja Sabbath jarrulinyjanaku, Jew-arrangumili karrpu Ngarrkaku. Janamilija mangunyja munu warrkamu jarrinyaku jana. Palangamarra Jesus kawu marlkarri jungkaranga wirrinaku karrinyikinyalu Joseph-ju palanga ruka-ruka. ");
INSERT INTO nna_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ngurnjulju japirr marna Pilate-ju, “Purlpi marlkarri jarrinyi paliny?” Soldier nyampali kayi marna, japirr marna, “Punja marlkarri waninyi Jesus?” ");
INSERT INTO nna_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Palalu soldier-lu nyampalilu wurrarnala, “Yuu, purlpi marlkarri paliny.” Palaja Pilate-ju wurrarnili Joseph-ja, “Yuu, kawu paliny marlkarri kangkuluman.” ");
INSERT INTO nna_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph store-karti yana, mana warnkulu wara makanu mirta-mirta, ngalypakata yija. Mungkaja Jesus kawu marlkarri kaniny jirni, waralu kunymarna, wakany kawu yamarna. Palaja jurntikarti kanya. Pala jurnti kapulyakata warnkungu purlpija wirrkarniyi jungkaraku. Palanga kaninykarti wirrirni Jesus kawu marlkarri. Palaja warnku wirtujina jujirni jurntikarti, jawapirti yamarna yijalu ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mirtawajirrilu parrjarnikinyipulu, nyarralujirri, Mary Magdalene-lupa wariny Mary-lu. Parrjarnikinyipulu Jesus kanya wirrirni Joseph-ju jurntingi, palanga yirrirnipulu. ");
INSERT INTO nna_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabbath-ja, kara ngalpanyajalu, yarranakanu warrkamu jilipiyi Jew-arrangulu. Palangarra kara ngalpanyajanga, yanayi store-karti Mary Magdalene-pa Salome-pa wariny Mary. Manayi warnkulu ngalypakatarrangu yangkanapintirrangu, parnti jurikata yija, kawungu yangkanaku Jesus-ja. ");
INSERT INTO nna_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wiyikingi yanayi pirrpangangarra palakarti jurntikarti. Jampa karrpu milyapal jarrinyajanga jurntingi milpanyiyi palanga. ");
INSERT INTO nna_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Yananya kawarnikinyiyi muwarr pirnikinyiyarningu, “Pala yamanapinti warnku, jurntingi jawapirtingi, nganyjurrulu munu rurriji pirnakanyi, warnku wirtujina yija. Nganurturrangulu rurriji pilipiyinganyjurruku pala warnku?” Jampa milpanyajalu yirrirniyi, parrjarniyi nyarra warnku purlpi rurriji pirni warinyju. ");
INSERT INTO nna_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Palaja jurntingi ngalpanyiyi, yirrirniyi yangupala pirirri, wurrujartiny mirta-mirtajartiny, marrjanyukarti kajarnikinyi. Wirnti karrinyikinyiya mirtawanyjarri. ");
INSERT INTO nna_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Palinyju wurrarnajanaku, “Wirntiwayi! Yija kanyjirnanyurralu kawuku Jesus-ku Nazareth-jaku, nyarra purlpi mungkanga nayilamu jirniyi. Marlkarri jarrinyaja yija wanka jirni Ngarrkalu. Munu nyungungu kuwarri. Parrjaliyi! Nyungungungarra wirrirniyi. Nyunguja yana. ");
INSERT INTO nna_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yankulunyurru, nyungu muwarr wurralkulunyurrujanaku Peter-ngapa jintanga Jesus-milirrangungu, 'Paliny Galilee-karti walangkarr yankulunyurruku. Palangangarra yirrilkulunyurru, palinyja muwarrja yija.'” ");
INSERT INTO nna_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jalakarti yanayi palarrangu mirtawanyjarri, jurntija mirti jarrinyiyi. Wirnti yija, jannganka pirnikinyiyipa ngurnjurnikinyiya yija. Wirntilu jintanga munu muwarr pirnimiyijanaku warinyarranguku. (Warinyju nyungu muwarr yarntarna, Jesus marlkarri jarrinyaja wankanyu waninyi, miral jarrinyijanaku palinymilirrangungu.) ");
INSERT INTO nna_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wiyikingi marntungu, pirrpa-pirrpamajirringi, Jesus yarrana wanka jarrinyi, turlpanya. Miral jarrinyili Mary Magdalene-nga. Purlpi palinyjangarra Jesus-ju jurtu ngakarnajaninyili 7 mirurru. ");
INSERT INTO nna_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Kuwarri yirrinakanu Jesus Mary yana palinymilirrangukarti. Kulurnikinyiyarninyi janalu. Wurrarnajanaku, “Nyampali nganyjurrumili, Jesus, munu marlkarri wanima. Marlkarri jarrinyaja wanka jarrinyi, yirrirnarna ngajulu.” Mary-nga munu yijalmarta jirnimiyili. Panypanyiyili muwarrja. ");
INSERT INTO nna_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ruka warinyjirri Jerusalem-ja jalakarti yanapulu. Purlpi Jesus-ja yijalmarta jirnikinyipululu. Kuwarri Jesus miral jarrinyapulaku. Pulanyju warinykapali wurrarnapulu, palinyngarra kakurnapulu. ");
INSERT INTO nna_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Palaja, miranu jarrinyaja, kulpanyapulu Jerusalem-karti, jintanga palinymilirrangungu wurrarnapulujanaku, “Jesus wanka yija. Yirrirnalayi ngalayalu.” Puru pinakarrimiyipulinyi, munu yijalmarta jirnimiyipulaku. ");
INSERT INTO nna_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Palaja, ngananyikinyiyi, miral jarrinyijanaku Jesus palinymilingi 11 marrngurrangungu. Yijalu warnta marnajaninyi. Warinyarrangulu Jesus wanka yirrinajalu purlpi wurrarniyijanaku, yirrkulu jalypalu jirnikinyiyi, palarrangulu 11 marrngurrangulu munu yijalmarta jirnimiyijanaku. Palajalu Jesus-ju warnta marnajaninyi. ");
INSERT INTO nna_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Palaja wurrarnajanaku, “Warrarnjirringi wiyirrja yananyakanu, wurralayijanaku marrngungu wiyirrja Ngarrkamili ngalypakata muwarr. ");
INSERT INTO nna_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kurrngalju yijalmarta jilipijiya ngajungu. Warinyju ngapanga jinaku janaku. Jana marlkarri jarrinyaja, Ngarrkalu wankanyu kalkulkulinyjaninyi ngarramarnti. Jintalu munu yijalmarta jilipijiya ngajungu. Jana marlkarri jarrinyaja, Ngarrkalu jurtu ngakalkulinyjaninyi ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ngajungu yijalmarta jinakatarrangulu ngajungu yiningi mirurru jurtu ngakalapiyijaninyi marrngurranguja. Muwarr warinyarrangu muwarr pilipiyi. ");
INSERT INTO nna_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Jurru watarrkulu marrayili, yijalu munu marlkarri jilkulinyjaninyi palalu jurrulu. Marlkarri jinapinti watarrkulu minpiliyili, yijalu munu kurlu jilkulinyjaninyi palalu kurlujartinyju. Janalu wirrilipiyijanaku parirrju wurrkujartinyjarrangu, Ngarrka japirr malapiyi ngalypa jinaku, yijalu Ngarrkalu ngalypa jilkulinyjaninyi wurrkujartiny. Yijalmarta jinakatarrangulu palajun jilipiyi. Palaja marrngurrangu miranu jarrulupiyijanaku warrkamu jirnirni ngarramarnti ngajulu yijalmarta jinakatarrangungu.” Palajun Nyampali Jesus muwarr pirnajanaku. ");
INSERT INTO nna_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Palaja Ngarrkalu kanya kanka, wirrirni marrjanyukartingi wangka yija palinyja. Palanga wirrirni Jesus wirtu yija nyampali wiyirrku ngunarrikurnujirriku. ");
INSERT INTO nna_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesus-milirrangulu yananyakanu wurrarnikinyiyijanaku ngunarrikurnujirringi marrngurrangungu Ngarrkamili muwarr ngalypakata. Yirrkulu Nyampalilu Jesus-ju warrkamu jirnikinyi palinymilirrangungu, marrngurranguku jurti jinaku janamili muwarr yija jurtu. JIPI. ");
INSERT INTO nna_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jiyijajilu wurrarnikinyijanaku marrnguku Ngarrka. Kurrngalju palanga pinakarrinyikinyiyalu. Kurlujartiny marrngurrangupa pukun milpanyikinyiyalu palinykarti pinakarrinyaku. ");
INSERT INTO nna_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Palanga kurrngalja kujarrapa waraja miranu jinakatarrangu janamilaku Juwumilaku mangunyku. Jinta pukun palanga, yini marnikinyiyarninyi Pariji. Palarrangulu Parijilupa miranu jinakatarrangulu parrjarnikinyiyi Jiyijaji. Wurrarnikinyiyarningu, “Nyungu Jiyijaji kurrngarnajanaku kurlujartinyku marrnguku, mayipa nganinyi janamilingi ngurranga palinyju. Palajun kurlujartiny.” ");
INSERT INTO nna_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jiyijaji miranu janaku wunyjurru wurrarnikinyiyarningu. Palajalu yimpirnajanaku palinyju nyungu muwarr miranu jinaku janaku. ");
INSERT INTO nna_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nyungu pinakarrayi! Ngurnipali warajalu nyurraja kalkulajaninyili 100 kukurnjari ngunarringi pirranga. Palaja ngurnipali waraja kukurnjari ngawu kanyjil-kanyjil yarrala. Ngani jilaman nyuntulu? Yakalamanjaninyi jinta 99 kukurnjari pirranga. Palaja tukulu kanyjilamanpalu warajaku kukurnjariku ngawu kanyjil-kanyjil jarrinyajaku. ");
INSERT INTO nna_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Maninyajalu nyuntu ngarlu yija pikaly jarruluman. Nyuntulu mankuluman pala kukurnjari waraja ngawu kanyjil-kanyjil. Palaja kangkuluman nyuntungu warntaranga, walarni jilaman ngurrakarti. ");
INSERT INTO nna_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Palaja nyuntulu kamalamanjanaku nyuntumilaku marrngurranguku, 'Kurtaliyi nyungukarti! Nyungu kukurnjari ngajumili ngawu kanyjil-kanyjil jarrinyi pirrangapa. Yijalu manarna. Kuwarri ngarlu pikaly waninyarni. Pikaly wantunyi!” ");
INSERT INTO nna_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Palaja Jiyijajilu wurrarnajanaku, “Yu! Nyuntu yija pikaly jarrinyin nyuntumilija kukurnjari maninyajalu. Yakujun kankarni Ngarrkapa yayinyjilarrangu palinymili pikaly jarrulupiyi marrnguja waraja kurlujartiny jinaja kulpanya Ngarrkakarti. Pikaly waninyayi 99 marrnguku ngalypakataku, Ngarrka yajarniyipa. Yijangarra pikaly yiji jarrulupiyalu warajakujakun marrnguku kurlujartinyja jinajapa wirlki jarrinya jina warajanga, kulpanya yajanaku Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Palaja yimpirnijanaku nyungu wariny muwarr Jiyijajilu. “Ngurnipali 10 warnku turrku-turrku kalkulali mirtawalu. Palaja ngurnipali kurlu jilkuliny waraja. Ngani jilkuliny palinyju? Tili jilkuliny tilipinti, maya purumu jilkuliny, tukulu kanyjilkulinypa nyarrakurnujirri. ");
INSERT INTO nna_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Maninyajalu kamalkulinyjanaku marrnguku jintaku, 'Kurtaliyi nyungukarti! Warnku nyarra kurlu jinirni, yijalu manarna! Kuwarri ngarlu pikaly waninyarni. Pikaly wantunyi!” ");
INSERT INTO nna_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Palaja Jiyijajilu wurrarnajanaku, “Yu! Yakujun kankarni Ngarrkapa yayinyjilarrangu palinymili pikaly jarrulupiyi marrnguja waraja kulpanyaja kurlujartiny jinaja. ");
INSERT INTO nna_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Palaja wurrarnajanaku nyungu wariny muwarr, “Purlpi waninyikinyi pirirri kujarrajartiny pirirrijartinyjirri. ");
INSERT INTO nna_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Warajanga karrpungu nyirtingunyamurninyju wurrarnala japartumurniny pulanymili, 'Japartukayi, marlkarri jarrinyajalu nyuntu ngalayalu mankulupalayi warrarn nyuntumili. Jinta pili ngalayaka warrarn kuwarri, ngajumili yungkulupijin kuwarri.' Palaja yijalu jinta pinipuluka pala japartumurninyju. ");
INSERT INTO nna_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Palaja nyirtingunyamurninyju palinymili warrarn jinta yinyajaninyi warnkuku, yakarna ngurra, kaja yana warrarn warinykarti. Palanga warrarnja palarrangujartiny warnkujartinyju kurlu pinikinyijaninyi. Karipa minpirnikinyi, witi karrinyikinyipa, yijalu kurlu pinarninga wiyirrju palinymilalu warnkulu. ");
INSERT INTO nna_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Palaja paliny ngurnjurnikinyi, warnkumajirri. Palaja palanga warrarnja ngapamajirri jarrinyi, mungkapa warruly tikirl jarrinyikinyiyi. Mayimajirripa marrngurrangu palanga warrarnja waninyikinyiyi. Nyirtingunya pala pirirri janparr karrinyikinyi. ");
INSERT INTO nna_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Palaja palinyju kurlkarri marnikinyi, 'Wunyjurru mayi mankulumarna nganinyaku? Warrkamuku japirr malamarnajaninya. Palaja yijamarta yungkuluminyiyi mayi warrkamuja.' Warrkamu jinikinyalu ngurraraku. Palalu ngurraralu wurrarnala, 'Nyungu ngajumili ngurr-ngurr kalkulumanjaninyi, mayipa yungkulumanjaninyi.' ");
INSERT INTO nna_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Palaja ngurr-ngurrpa kalkurnikinyijaninyi. Nyampalilu munu yingama mayi paliny nganinyaku. Paliny yija janparr karrinyikinyi mayipirrayiku ngurr-ngurrmilaku. ");
INSERT INTO nna_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yartikarra yija paliny kurlkapirli jarrinyi. 'Ngajumili japartumili warrkamu puluka mayi nganinyayi ngalypakata marlkaku yiji. Ngaju nyungungu janparr karrinyarni, janparrja marlkarri jarrarnili. ");
INSERT INTO nna_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngaju yankulumarna, kulpulumarnalu ngajumili japartukarti, wurralamarnala palinyja, “Japartukayi, ngajulu kurlujartiny jinirni. Panypanyarnala Ngarrkangapa panypanyarnanga nyuntungu. ");
INSERT INTO nna_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Munu ngaju wurralaminyin nyuntumili partany, puru wantulumarnanga ngaju nyuntumili warrkamukata, warrkamu jilamarnanga nyuntuku.”#' ");
INSERT INTO nna_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jampangarra paliny yana, kulpanya palinymili japartumilikarti. Kajaja ngarrany yirrirni palinymilalu japartulu. Japartumurniny paju karrinyalu, mirti jinalu palinymilaku partanyku. Ngampal jini, ngangkurlu jinikinyipularninyi. ");
INSERT INTO nna_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Partanymurninyju wurrarnala, 'Japartukayi, ngajulu kurlujartiny jinirni. Panypanyarnala Ngarrkangapa nyuntungu. Munu ngaju wurralaminyin nyuntumili partany.' ");
INSERT INTO nna_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Munu puntaju japartumurninyju pinakarrimalu palinymilaku partanymurninyku. Wurrarnajanaku palinymilaku warrkamu pulukurrangu, 'Nyampalu marrayalu wurrukarra ngalypakata palinyku, wirriliyili, jujika wirriliyili jinanga, palaja parirrja palinyja wirriliyili ringi! ");
INSERT INTO nna_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Palaja marrayi purlika, jinjimama, wirlaliyi, wirlanajalu kampalkuluyurru. Palaja ngalkuluminyalu nganyjurrulu ngajumilaku partanyku. Ngalypa wantuluminyi pikaly yija! ");
INSERT INTO nna_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ngajulu wurrarnarna nyungu ngajumili partany yijakapali marlkarri jarrima ngarramarnti. Munurla! Wankanyu! Kaja yiji yana. Yakarnaminyikapali ngarrakunyju. Munurla! Kulpanyaji wankanyu ngarrany!' Palamaja pikalyju kurntarnikinyiyipa yaku jarrinyikinyiyi. ");
INSERT INTO nna_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Murrkangunyamurninyju warrkamu jinikinyi ngunarri. Palaja warrkamuja kulpanya ngurrakarti. Wangka jarrinyikinyi, pinakarrinyijaninyi kurntanaja ngurrangalu yaku jarrinyikinyiyipa. ");
INSERT INTO nna_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Palaja palinyju kamarnalu marrnguku warajaku palinymilaku japartumilaku warrkamu jinakataku. 'Nganija palanga pikalyju kurntarn-kurntarnikinyiyipa yaku jarrinyikinyiyi?' ");
INSERT INTO nna_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Puntaju pala marrngulu wurrarnala, 'Nyuntumili marrka kulpanya kuwarri. Nyuntumilalu japartulu wurrarnanganaku, “Nyungu ngajumili partany kulpanyaji ngajukarti. Wirlaliyi nyarra purlika, jinjimama.”#' ");
INSERT INTO nna_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Murrkangunyamurniny yurnturi jarrinyi, munu yanama mayakarti, jalakarti waninyi, kajamarta. Palaja palinymili japartu yanalu palinykarti, ngarlu japirr marna, 'Kurtali mayakarti kaninykurti.' ");
INSERT INTO nna_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Murrkangunyamurninyju yurnturijartinyju puntaju wurrarnala japartumurninyja, 'Ngaju yija nyuntuku waninyikinyirnangu, warrkamu jinikinyirnangupa nyuntuku partunupa yurranga. Ngajulu yirrkulu nyuntuku pinakarrinyikinyirnangu nyuntuku muwarrjaku. Puntaju munu yingaminyin ngaju wupartupa nanikutu. Ngajumilirrangulu jarnturrangulu yijapa nganamiyirni kuwiyi pikalyju. Munurla! Kumarri marnanyin wirlanaku kuwiyiku nganinyakupa. ");
INSERT INTO nna_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ngaju munu nyungukapali nyuntumilikapali nyirtingunyakapali, nyuntulu nyuntumili warrarn yinyanpa. Palinyju warrarnku warnku mana, wiyirr warnku kurlu jini mirtawanga. Kuwarri paliny kulpanyajalu nyuntulu wirlarnanpalu palinyku kuwiyi jinjimama.' ");
INSERT INTO nna_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Japartumurninyju wurrarnala, 'Partany, nyuntu waninyijin ngajungu, ngajulu kalkurnarnanta japartulu. Nyungu waninyiyinga nyuntumili nganin-nganin. Ngajulu wiyirr kalkurnarnanga nyuntuku. Marlkarri jarrulumarnapa yija nyungu wantulupiyinga nyuntuku. ");
INSERT INTO nna_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngajulu wurrarnarna nyungu nyuntumili marrka yijakapali marlkarri jarrima ngarramarnti. Munurla! Wankanyu! Kaja yiji yana. Yakarnaminyikapali ngarrakunyju. Munurla! Kulpanyaji wankanyu ngarrany! Palajunjalu jurtungu pikaly yiji jarruluminyi.'#” ");
INSERT INTO nna_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yayipirayamulu karra marnalu...nyarra waninyi wirtu yiji wuju partijirri kaniny nganarnangapa nyurranga. Palarranguku nganarnanga ngarnurtupa karrinyi yananyaku nyurrakartiku munu yiji, ngunjul yija palaku. Palarranguku pukun nyurranga ngarnurtupa karrinyi milpanyaku nganarnakarti munu yiji, ngunjul yija palaku. ");
INSERT INTO nna_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","“Jayiman, Jayimankayi, Jayitanju Ngarrka japirr marna nyurraku, marrjalu yakurr manaku nyurraku. Ngajulu ngarlu japirr marnarnangu Ngarrka nyuntuku, Jayimankayi, nyuntuku yijalmarta jinaku Ngarrkanga ngarrakunyju. Nyuntulu warinykurnu jarrinyaja kulpanyaku ngajukarti ngajuku yajanaku, palarrangu jinta pukun ngajuku miranu jilamanjaninyi, janalu ngajuku yirnkulumarta yajanaku.” ");
INSERT INTO nna_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Marrngumili kawu nyarra paliny palinymilijangarra pipi japartuja. Palinymili pirlurr nyarra Ngarrkamilija Pirlurrja. ");
INSERT INTO nna_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Marrngurrangu ngarlungu yija Ngarrkanga / God-ja. Palajunjalu yinyanganyjurrinyi pujamu walja palinymilingarra, palinyja yijalmarta jinakatarrangu munu pujunuku jarrinyaku, ngarramarnti wankanyuku waninyaku palinymilingi ngurranga. ");
INSERT INTO nna_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Munu ngakarnama palinymili pujamu nyungukarti ngapiku, jurtu ngakanaku wiyirrku. Palinyju ngakarna nganyjurruku kartuwarra manaku wiyirrku! ");
INSERT INTO nna_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nganurtulupa yijalmarta jilkulinypili God-mili pujamungu, munu jurtu ngakalkulinyjaninyi. Wiyirr yijalmarta jinakatawayi palajunmarta kurluny-kurlunyjangarra waninyayi kakuputu, God-mili pujamu waljanga yakal manakata. ");
INSERT INTO nna_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yakujunngarra: Tili God-milingarra milpanyanganyjurraku, marrngulu warrukurlaku karrinyaya, kurlujartinykungarra karrinyaya. ");
INSERT INTO nna_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Malyparr karrinyaya Tili God-milakungarra kurlujartiny jinakata, munu milpanyakayi Tili God-milikarti, kurntanyja jinangamarra. ");
INSERT INTO nna_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wiyirr ngalypaku jinakata Tili God-milikarti milpulupiyi, jintalu yirrilapiyi wunyjurrukapali warrkamu jarrinyajanaku jananga. ");
INSERT INTO nna_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jiyijajilu wurrarnajanaku pirirrimartanga palinymilirrangungu, “Munu wantayi ngarlu kurluny-kurluny. Yijalmarta jiliyili Ngarrkanga, ngajumilingi kankajirringi Japartungu. Yijalmarta jiliyiji ngajungu pukun. ");
INSERT INTO nna_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngajumili Japartu ngurrarrangu kurrngaljartiny palinymilingi warrarnja. Yija wurrarnarninyurraku. ");
INSERT INTO nna_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Walangkarr yankulumarna Japartumilikarti. Palanga ngurra parljulumarnanyurraku. Palaja kulpulumarna, kangkulumarnanyurrinyi palakarti, ngajumilikarti Japartumilikarti ngurrakarti, nyurraku waninyaku ngajungu ngarramarnti. Kunmu jarruluminyi ngajumilingi Japartumilingi ngurranga. ");
INSERT INTO nna_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Palakarti yankulumarna. Palaku ruwurtuku palakartiku miranu nyurra.” Palajun Jiyijajilu wurrarnajanaku. ");
INSERT INTO nna_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Warajalu, ngapilu, Tamajilu, ngurnjurnikinyi palaku muwarrku, karra marnalu Jiyijajiku, “Nyampali! Wanyjarni yananyan? Munumpa nganarna palaku. Munumpa nganarna ruwurtuku palakartiku. Wunyjurru yajalapiyirninti palakarti?” ");
INSERT INTO nna_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Wurrarnajanaku Jiyijajilu, “Japartukarti kangkulumarnajaninyi warajapa waraja marrngu parirrja ngajulungarra. Yijaku muwarrku miranu jilamarnajaninyi Japartuku ngajulungarra. Wankanyu ngarrany jilamarnajaninyi ngarrakuny ngajulungarra. Yija ngajumili muwarr: marrngu munu yiji yankuliny ngajumajirri Japartukarti. Yankulupalayi Japartukarti ngalayangarra.” ");
INSERT INTO nna_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","8","...Jiyijajilu karra marnajanaku palinymilirranguku pirirrimartaku, munu yiji nganipa jilkulunyurru ngajumajirralu. Yijapa warinyju warinykurnulu yakalanyili ngaju, paliny wurrulykapali tikirlkapali jarruliny. Wurruly nyarra palajunmarta marrngurrangulu kuru marnayijaninyi minyjinaku. Ngajungungarra kuluna wantulunyurrupa tukulu jilkulunyurru ngajumilija muwarrja, palajunjalu nganikupa Ngarrkangarra japirr malkulunyurru, nganipa pala palangarra jilkuliny. Ngajumilirrangu marrngurrangu ngalypakata jinakatarrangu, kakuputulu ngalypa yiji jinayi. Marrngurrangulu yirrinajalu yijalu yiji nyurra malapiyi Japartu ngajumili. ");
INSERT INTO nna_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","...Nganyjurrulu wiyirrju pinakarrinyanyijaninyi, jana muwarr pinayi nganyjurrumilingi waljarrangungu muwarrjarrangu. ");
INSERT INTO nna_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kuwarringulungarra yijalu yiji kurlkarri malkulunyurrupa jilkulunyurru ngarlulu warinyju, Ngarrkakartingarra jarrayalu; palajunjalungarra kurlujartinyja kurlparr pilkulinyurraku. ");
INSERT INTO nna_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Purlpija Ngarrka miranu waninyijanaku marrngurranguku, yirrkulu kurlu jinikinyayi munumpalu janamilalu. Puntaju munu kurlu jinamajanaku, yakarnajaninyi. Kuwarri yartikarra ngawu kanyjil-kanyjiljaja wurrarnajanaku wiyirrku ngunarrijirriku, “Pinakarrayi! Munu kurlujartiny jinaku. Yakaliya! Kulpanya walarni jarrayi yakujani! Kuwarrija jilkulunyurru ngajumilija muwarrja.” ");
INSERT INTO nna_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Jiyijaji Kurayiji nyarra marlkarri jarrinyajanga, nganyjurru pukun marlkarri jarrinyinyikapali; paliny jungkaranga wirrinajanga, nganyjurru pukun jungkarangakapali jarrinyinyi. Wankanyu jinajanga Japartulu, nganyjurru pukun wankanyu jirninganyjurrinyi Kurayijingi kuluna. (Yijalu yiji yarni-yarnilu Japartulu nganin-nganinkupa jinakata, munu ngarnurtulupa kurnta jinakayi.) Palajunngarra jarrinyanganyjurruku nyarra jampa warinyju ngapanga jirninganyjurrinyi. Palajunngarra Ngarrkalu jirni, nganyjurruku wariny jarrinyakupa ngalypanga yiji waninyaku. ");
INSERT INTO nna_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Marrngurrangulu kurluny-kurluny jinayi ngarrakunyju, puntaju marlkarri jarrulupiyi. Marrngurrangu nyarra Jiyijajingi Kurayijingi nganyjurrumilingi Nyampalingi kulunaja puntaju ngalypanga wantulupiyi. Ngarrkalu wankanyu ngarramarnti kalkulkulinyjaninyi. ");
INSERT INTO nna_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","8","Jampa marrngulu pinakarrinyalu palinymilaku waljaku ngampankataku pirlurrku, paliny yukunykata jarrinyalu Ngarrkaku. Munu pinakarrinyakalu Ngarrkamilaku muwarrku, munu yiji ngunjul palinyku! Palarrangu pinakarrinyakata waljaku ngampankataku pirlurrku, ngunjul yiji janalu munu pikaly jinakayi Ngarrka. ");
INSERT INTO nna_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Nganyjurrulu yijalu nganin-nganin jilkunyi jurtulu, nyarra ngalypa wiyirrju yirrinaku kurlumajirri, pirlpanga. Munu kurntany yiji nganipa jinaku, munu yawurr jarrinyaku, munu nganinyaku marlkaku, munu jintamilingi nyupanga karta karrinyaku, munu kurla-kurla jarrinyaku jintanga, munu kulipatinaku, munu mikulu yirrinaku jinta. ");
INSERT INTO nna_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Nyarra jintalu kuwiyi mirurruku yinganyikinyiyijanaku, palajunju wurranikinyiyijaninyi mirurrurrangu nyampali janaku. Nyuntulu pala kuwiyi ngalkuluman, nyuntu miranu ngalypangarra palajun jinaku. Nyuntu miranu munu kurluny-kurluny palajun jinaku nyuntulu. Ngurnipali nyuntulu wayin minpilamanpa kuwiyi ngalkuluman. Warinyju marrngulu ngurnipali yirrilantili palajun jinaja, palinyju kurlkarri malali kurluny-kurluny yiji palajun jinaku, palinyju pukunngarra palajun jinaku ngurnipali karrulinypa, palinyju palajunku jinaku karruliny jampa nyuntulukurra yirrirninti jinaja. Palinyju kurlkarri malkuliny nyarra kurluny-kurlunyngarra yiji palajun jinaku. Palajunjalu kurluny-kurlunyngarra yiji palinyku. Ngarrkalu wirlalkuliny paliny palajun jinaja. ");
INSERT INTO nna_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","...Jintalu marrngurrangulu wurranayarninyi Kurijin, kurlujartiny ngarrany jinayi. Ngurnipali jana kurla-kurlakatarrangu, ngurnipali lirrjalkatarrangu, ngurnipali ngarluja nyurra marnayijaninyi jinkanajarrangu mangunykapalirrangu, ngurnipali mitulu yimpinakatarrangu, ngurnipali karikatarrangu, ngurnipali ngulyukatarrangu. Munu kulunaku marrngurrangu palajunmarta jinakatarrangu, munu yiji nganinyaku palarrangungu. ");
INSERT INTO nna_vpl VALUES ("C16_9","076_6_9","1CO","6","9","11","Yija yiji nyurra miranu nyarra kurlujartiny jinakatarrangu munu Ngarrkamilingi warrarnja jarrulupiyi. Munu mitu malkulunyurrarningu. Jinta marrngurrangu kurla-kurlakatarrangu waninyayi, jintalu ngarluja nyurra marnayijaninyi jinkanajarrangu mangunykapalirrangu, jinta karta karrinyayijanaku warinymilingi nyupajingi, jintalu pirirrimartalu yikarnayarninyi, jinta ngulyukata waninyayi, jinta lirrjalkatarrangu, jinta karikatarrangu, jinta mitu yimpinakatarrangu, jintalu kulilu ngulyulu mananyakatarrangu. Palajunmarta jinakatarrangu munu Ngarrkamilingi warrarnja jarrulupiyi. Jinta nyurra palajunmartangarra waninyikinyinyurru, kuwarri nyurra wariny. Nyampalilu Jiyijaji Kurayijilupa Pirlurrju Ngarrkamilalu jinta pirnapulunyurrinyi kurlujartinyja, nyuku jirnapulunyurrinyi Ngarrkakungarra, kulurnapulunyurrinyi ngalypanga Ngarrkanga. ");
INSERT INTO nna_vpl VALUES ("C110_12","076_10_12","1CO","10","12","13","Ngurnipali nyuntulu kurlkarri malkulamanparningu nyuntulu jinan jurtulu. Mintu wantuluman puru kurlujartiny jinangamarra. Nyarralu Wirtulu Mirurrulu yirrkulu yakurr malamanta warinypa warinyku kurlujartinyku jinaku. Wiyirr pukun jinta yakurr marnajaninyi marrngurrangu palajunmartalu. Kakuputulu yijalmarta jilali Ngarrkanga, palinyju pirlurr nyuntumili tarn-tarn yiji jilamangalu yakurr manangamarra. Palajun yakurr manajalu, jurtungu nyuntu kurlujartinymajirri. ");
INSERT INTO nna_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Kunmungu jarrinyaja muwarr pinaku Ngarrkanga, wariny Christian-mili yinmajartiny, wariny miranu jilkulinyurrinyi Bible-ja, wariny pinakarrinyaja Ngarrkaja, wariny muwarr pinaku karrinyi muwarrju kajamartajalu warrarnjalu ngajarrijalu, wariny pala warinymili muwarr explain jinaku karrinyi. Wiyirr jilkulinyurru ngalypa jinaku nyurramili church. ");
INSERT INTO nna_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Yijapa wariny muwarr pinaku karrinyi muwarr warinyjalu muwarralu, yijapa kujarra muwarr pilkinypulu, yijapa kujarrapa warajakartijakun, warajangapa warajanga. Palaja wariny muwarr explain jinaku. ");
INSERT INTO nna_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Yijapa wariny explain-a-kata-majirri, palarrangu muwarrku pinaku muwarrju kajamartajalu muwarr pinaka, muwarr pinaku Ngarrkangajakun. ");
INSERT INTO nna_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Yijapa Ngarrkalu muwarr yinyajaninyi, jinta muwarr pinaku, kujarrapa warajalu, jinta (the rest) janamili muwarrku kurlkapirli jarrinyaku, pala ngalypa, pala kurlu? ");
INSERT INTO nna_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Yijapa warajalu muwarr pinikinyi, palaja Ngarrkalu muwarr yinganyalu muwarr winyja wariny marrngu, pala walangkarr marrngu muwarr pinakarrinyaja kajanaku, jama jarrinyaku. ");
INSERT INTO nna_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Nyurra wiyirr muwarr Ngarrkaja muwarr pilkununyurru, warjanga warajanga. Palajunjalu wiyirr miranu jarrulinyurru. Ngarrka muwarr yinganyaja, muwarr pinakata jiparnarnparninyi jalpu. Ngarrka munu karrinyama dis-order, paliny karrinyikinyinganinyi yijalu jinaku wiyirr. ");
INSERT INTO nna_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Yuu, Christian marrkarrangupa Christian brothers, friends, brothers and sisters ?? nyurraku kurlkapirli jinaku karrinyarna pala muwarr ngalypakata. Nyarra “muwarr pirnirninyurraku” wurrarnarnanyurraku ?? Pikalyjartinyju pinakarrinyinyurralu pala muwarr, yijalmarta jirninyurralu, kuwarri yirrkulu tarlka kalkurnanyurru. ");
INSERT INTO nna_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Yirrkulu yijalmarta jinakanu, nyungulu muwarrju ngalypakatalu Nyampali Jesus Christ kartuwarra marnanyurrinyi. Actually it is the Lord Jesus Christ who saves you, when you believe the message. Palajun yijalu yijalmarta jinajalu, munu partarl yijalmarta jirnanyurra. ");
INSERT INTO nna_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Warinyarrangulu purlpi yinku muwarr jakurl kanyajiya. Palaja pala muwarr jakurl kanganyarnanyurraku ngajulu. Pinakarrayi! Nganyjurru wiyirr Ngarrkanga panypanyiyirni. Palajalu Ngarrkalu nganyjurru wirlanaku. Christ marlkarri jarrinyinganyjurruku kartuwarra manaku, Ngarrkamilijangarra muwarrjangarra. Palajun. ");
INSERT INTO nna_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","Jungkaranga wirrirnayi, kujarrapa warajangangarra turlpa jini marlkarrija Ngarrkalu, Ngarrkamilijangarra muwarrjangarra. ");
INSERT INTO nna_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Yirrirni Peter-lu, palaja yirrirnayi Twelve-jungarra ??. ");
INSERT INTO nna_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Palaja kurrngalju yija yirrirnayi, yajanakatarrangulu 500-ju warajangangarra. Jinta ?? purlpi marlkarri jarrinyiyi. Kurrngal ?? wanka jarrinyiyi kuwarri. ");
INSERT INTO nna_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Palaja James-ju yirrirni, yarti wiyirrju Apostles-ju ?? yirrirnayi. ");
INSERT INTO nna_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Yartikala yirrirnirni ngajulu pukun nyirrirnikartilu. ");
INSERT INTO nna_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Jintanga Apostles-ja ?? ngaju puru, wupartukapali yija. I am not even worthy to be called an Apostle - key term: Apostle ? Purlpi wirlarnakinyirnijaninyi Christian-arrangu Ngarrkamilirrangu ngajulungarra key term: 'ekklasia' / 'congregation' / 'ones called together for a meeting'. ");
INSERT INTO nna_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","BUT, Ngarrka ngalypa yija ngajuku key term: gracious, showing favour to people who don't deserve it ??. Palinyjungarra ngaju jirninyi nyungukapali kuwarri. Yuu, munu partarl ngajunga ngalypa jirniji. Munurti! Ngajulu wirtu yija warrkamu jirnirni, ngajunga palarrangulu jintalu Apostles-ju wupartujakun warrkamu jirniyi. Munurti ngajulu, Ngarrkalungarra jirnikinyiji ngajunga. ");
INSERT INTO nna_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Yijapa ngajulu muwarr pirni, yijapa palarrangu muwarr pirniyi, puru wanta, nganarnalu wiyirrju muwarr pirniyirni pala warajajakun muwarr, nyarra muwarr ngalypakata yijalmarta jirnikinyiya nyurralu wiyirrju. ");
INSERT INTO nna_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Nganarnalu miranu jinakinyiyirni Christ marlkarri jarrinyaja Ngarrkalu mana kanya kanka. Jintalu nyurranga wurrarnayi marlkarrinyjarri marlkarri wantulupiyi, munu wankanyu jarrulupiyi. ");
INSERT INTO nna_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Yijapa marlkarrinyjarri marlkarri wantulpiyi, Christ-ngarra pukun marlkarri wantuliny. ");
INSERT INTO nna_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","Yijapa Christ munu wankanyu jarrima, nganarnalu wurranakinyiyirni mitu wakany, nyurralu puru yijalmarta jarrinyinyurru mitungu. ");
INSERT INTO nna_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Yijapa marlkarrinyjarri munu wankanyu jilkulinyjaninyi Ngarrkalu, nganarnalu mitu marnayirni Ngarrka. Wurrarnayirni Ngarrkalu kanka mana Christ. Janamilija muwarrja, nganarnamili muwarr munu yija muwarr. ");
INSERT INTO nna_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Yijapa marlkarrinyjarri munu kanka manamajaninyi Ngarrkalu, Christ munu kanka manama Ngarrkalu. ");
INSERT INTO nna_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Yijapa Christ munu kanka manama Ngarrkalu, puru yijalmarta jirnanyurru, yirrkulu panypanyakatarrangu nyurra. ?? ");
INSERT INTO nna_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Palarrangu yijalmarta jarrinyiyi Christ-japa yarti marlkarri jarrinyiyi Wikakarti Wirtukarti yanayi, munu kulpulupiyi! ");
INSERT INTO nna_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Yijapa nyungungujakun warrarnjajakunngarra wankanyu waninyanga, pikaly waninyanyi Christ-ja, wurrarniyarninyi wankanyu jilinganinyi Ngarrkalu, jinta paju yija jarrulupiyinganaku! more sorry for us than for anyone else ?? ");
INSERT INTO nna_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Pala mitu. Nyungu yija-yiji muwarr: Ngarrkalu marlkarriny jarrinyaja kankangarra mana Christ! Paliny walangkarr yana, palinyja yarti kanka malkulinyjaninyi kurrngal yiji Ngarrkalu! ");
INSERT INTO nna_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Warajalu marrngulu jinajalu wiyirr marlkarri jarrayinyi. Palakapalingarra warinyju marrngulu jinajalu wiyirr wankanyu jarrinyinyi. ");
INSERT INTO nna_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Nganyjurru marrngurrangu wiyirr Adam-milirrangu nyirrirnikartijarrangu. Palaja marrngurrangu wiyirr marlkarri jarruliny nganyjurra. Yakujun nganyjurra wiyirr Christ-milirrangu wankanyu jilkulinynganyjurrinyi Ngarrkalu. Note the forward reference, followed by return to present time: ");
INSERT INTO nna_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Jurtungu yajalkulupiyarninyi. Christ walangkarr, palaja, kulpanyaja Heaven-ja paliny, palinyja yijalmarta jinakatarrangu wiyirr. ");
INSERT INTO nna_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Palaja Christ-ju jipi jilkulinyjaninyi all rulers and powers and forces — shall we specify Satan and the mirurrurrangu ? Yartikarra Christ Nyampali Wirtu jarruliny. Palaja wiyirr yungkuliny Ngarrka. Palaja Ngarrkalu wurralkuliny, “Jipi!” ");
INSERT INTO nna_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Pala yartiku. Kuwarriku Christ nyampali jarrinyakupa wirlalkulinyjaninyi wiyirr yukuny pinakatarrangu palinyku. ");
INSERT INTO nna_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Yukuny pinakata nyirrirningarra Death. ");
INSERT INTO nna_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Ngarrkamili muwarr wurraninyi, “Ngarrkalu wirrirni wiyirr kaninykurti Christ-mili jina.” (Ngarrkalu munu wirralkulinyparninyi kaninykurtingi Christ-mili jina. Ngarrkalu jinta wiyirr wirrirni kaninykurtingi Christ-mili jina.) ");
INSERT INTO nna_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Palaja, Christ wiyirrku Nyampali jarrinyaja, wirrilkulinyparninyi kaninykurtingi Ngarrkamili jina. Palajunju Ngarrka Nyampali Wirtu jarruliny wiyirrku, nyarrakurnujirri. ");
INSERT INTO nna_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Warinyarrangu marlkarri jarrinyiyi janpa jinamajirri. Jintalu wariny marrngu janpa jinijaninya, wurrarnayi, “Palajunju jinajalu ngalypa jilkulinyjanaku marlkarrinyjarriku.” Nyarra warinyarrangulu wurrarnayi, “Marlkarri jarrinyaja, marlkarri wantuluman ngarramarnti.” Janamilirrangu muwarr rurru pirnayarninyi. Yijapa marlkarrinyjarri marlkarri wantulupiyi, janpa jinaku marrngu wariny munu ngalypa jilkuliny, munu wankanyu malkuliny! ");
INSERT INTO nna_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Kurlkapirli jarrulinyurru nganarnapa. Jinta wirla-wirlalkulinynganinyi karrpurrangu karrpu. ");
INSERT INTO nna_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Karrpurrangu warinypa wariny marlkarri wirlalajiyili! Yijarla pala muwarr! Kamparta ngaju Christ-ju jinajalu nyurranga. Yijarla pala muwarr pukun! ");
INSERT INTO nna_vpl VALUES ("C115_32","076_15_32","1CO","15","32","33","Palarrangulu marrngurrangulu Ephesus-ja kulipartirnajiya. Jana lion-arrangukapalipa tiger-arrangukapali! Yijapa marlkarrinyjarri marlkarri wantulupiyi, kulipartinajalu munurti yija jirnirni! Yijapa marlkarrinyjarri marlkarri wantulupiyi, “Ngalkunyi, minpilkunyi, marntungu marlkarri jarruluminyi!” Jintalu wurrarnayi muwarrarrangu palakapali. Mitu muwarr janamili. Munu pinakarrayijanaku! “Bad company corrupts good character.” ");
INSERT INTO nna_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Jurtulu yija kurlkapirli jarrayi, munu kurlujartiny jilkulinyurra stop sinning! Jinta nyurranga munumpa waninyayi Ngarrka. Kurntany wantayi palaku. ");
INSERT INTO nna_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Jintalu japirr marnayi, “Wunyjurru Ngarrkalu kanka malkulinyjaninyi marlkarrinyjarri? Nganikapali kawu janamili?” ");
INSERT INTO nna_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Munu ngawu wantulinyurru. Jijirr jungkanga wirrinaja, marlkarri jarrinyaku. Palajangarrajakun turlpalkuliny, wirtu jarruliny, warruly jarruliny. ");
INSERT INTO nna_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Pala warruly turlpanyaja wariny yija, munu jijirrkapali. ");
INSERT INTO nna_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Ngarrka miranu palaku jijirrku, yinganya kuwarrija kawu, karrinya palangarra. ");
INSERT INTO nna_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Marrngurrangu, kuwiyirrangu, wirrujartinyarrangu, janpamalurrangu majangujartiny, warinypa wariny. ");
INSERT INTO nna_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Wiyirr parlparrja waninyayi kawujartiny. Wiyirr jungkanga waninyayi kawujartiny. Warajapa waraja, wariny yija jintanga wiyirrja. ");
INSERT INTO nna_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Karrpu munu wirlarrakapali. Wirlarra munu panikatarrangukapali. Waraja panikata munu warinykapali panikatakapali. ");
INSERT INTO nna_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Palakapali jarruliny kawuku nganyjurrumilirranguku. Nyungurrangu kawu marlkarri jarrulupiyi, wirrilapiyijaninyi jungkanga, jijirrkapali. Kanka manaja, wankanyu wantulupiyi ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Nyungurrangu kawu manyurla, munu ngalypa yirrinaku. Kanka manaja ngalypa yiji wantulupiyi, marrjapanu. ");
INSERT INTO nna_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Nyungunga warrarnja waninyaja, marrngulu warlininyi nyungu kawu. Partarl warlilkuliny wariny kawu, kanka manaja kawu, parlparrja kawu. ");
INSERT INTO nna_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Ngarrkamilalu muwarrju wurraninyi, “Nyarra walangkarr pirirri, yini Adam, marrngu wankanyu jarrinyi. Nyirrirnikata pirirri, Christ, pirlurr wankanyu jinakata jarrinyi. ");
INSERT INTO nna_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Pala kawu warlinapinti walangkarr jarrayinyi, yarti pala parlparrja kawu jarrayinyi, warlinawayi kawu. ");
INSERT INTO nna_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Ngarrkalu yarni mana pala walangkarr pirirri, Adam, kurlurluja. Pala nyirrirnikata pirirri, Christ, parlparrja milpanya. ");
INSERT INTO nna_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Marrngurrangu nyungunga warrarnja kawujartiny Adam-kapali. Marrngurrangu parlparrja kawujartiny Christ-kapali. ");
INSERT INTO nna_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Kuwarri nyungungu warrarnja nganyjurru kawu Adam-kapali. Yarti parlparrja kawu nganyjurrumili Christ-kapali jarrulupiyi. ");
INSERT INTO nna_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Marrkarrangu ngajumili ??, Ngarrkamili ngurra parlparrja waninyi ngarramarntiku. Nyungurrangu kawu nganyjurrumili, majangujartinypa pijirrijartiny, nyilykirr jarrulupiyi. Munu waninyakayi ngarramarnti. Partarl wantulupiyi Ngarrkamilinga warrarnja parlparrja. ");
INSERT INTO nna_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Yuu, ngurnjul ngalypakata yija wurralamarnanyurraku: Nganyjurranga jinta munu marlkarri jarrulupiyi. Nganyjurra wiyirr warinykapali jarruluminyi. ");
INSERT INTO nna_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Jampangangarra jarruliny, wirlujartukapali. Angel-ju trumpetjartinyju wirtu ngurntirri jilkuliny. Ngarrkalu wiyirr marlkarrinyjarri kanka malkulinyjaninyi, ngarramarntiku munu nyilykirr jarrulupiyi. Palanga wankanyurrangu nyungungu warrarnja wariny jilkulinyjaninyi, nganyjurru munu marlkarri jarruluminyi, wankanyu wantuluminyi ngarramarntiku. ");
INSERT INTO nna_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Nyungurrangu kawu nyilykirrpinti Ngarrkalu wariny jilkulinyjaninyi, marlkarriwayipa nyilykirrwayi. ");
INSERT INTO nna_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Nyungurrangu kawu nganyjurrumili manyurla, marlkarri jarrulupiyi. Ngarrkalu wariny jilkulinyjaninyi, munu yiji marlkarri jarrulupiyi. Palaja marrngu wiyirr miranu jarrulupiyi, Ngarrkamili purlpija muwarr yija: ");
INSERT INTO nna_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","“Marlkarri jinakatakayi, Christ-ju marlkarringarra wirlarnanta! Marlkarri jinakatakayi, partarl kampalkulinynganyjurrinyi!” ");
INSERT INTO nna_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Marrngurrangulu munu pinakarrinyayi Ngarrkanga. Palaja Ngarrkamili Manguny marlkarri wirlanaku. Parra-parra wirtu yija jilkulinyjanaku. ");
INSERT INTO nna_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Ngarrkalu ngakarnanganyjurraku Christ, kartuwarra manakata jarrinyaku nganyjurraku. Christ-ju marlkarri jirni pala marlkarri jinakata. Palajalu nganyjurrulu wurralaminyi Ngarrka, “Yarranija!” ");
INSERT INTO nna_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Palajalu, marrkarrangu, tarlka wantulinyurru, janngankawayi. Yirrkulu pikalyju warrkamu jilkulinyurralu Nyampali Jesus-ku. Wiyirrju jinajarrangulu palinyku Ngarrka pilaly jilkuliny. ?? ");
INSERT INTO nna_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Jipi, muwarr pilamarnanyurraku, Kurijinarranguku. Jintalu wurralapiyinyurruku, “Yijalu pinakarrulunyurru Mujujumili muwarrarrangu, purlpi wirrirnijanaku Juwurranguku marrnguku. Palinyja muwarrja jilkulunyurru. Munujalu nyurra munu Jiyijaji Kurayijimili.” Palajun wurralapiyinyurruku. Mitu yiji janamili muwarr. Jiyijaji milpanya Ngarrkaja kartuwarra manaku nganyjurruku. Yijalmarta jininyurrulu palinyja. Palajalungarra nyurra palinymilirrangu jarrinyinyurru. Munu Jiyijajimili jarrimanyurru pinakarrinyajalu Mujujumilaku muwarrku. Tuku jarrulunyurru mitungumarra! Munu wurralanyurrarningu, “Jiyijaji Kurayijimili nganyjurru, puru ngakarnanganyjurrinyi. Munu pinakarruluminyalu Muwujujumilaku muwarrku. Kuwarri nganyjurrulu turrpalu jinanyi nganiwarralpirtiku karrinyanyi jinaku!” Munu palajun muwarr pilkulunyurru! Palajunja muwarrja lirrjal wirtu jarranyurrulu mayiku, kariku, mirtawaku, pirirriku, nganin-nganinkurrangu, puntaju wirlalanyurrarninyili, ngulyu marranyurrulu, warinyirrangupa kurlujartiny jilinyurrulu. Munu kurlujartinyja yungkulunyurrarninyili. Munu yiji palajun jilkulunyurru! Nyurra Kurayijimilirrangu. Palajalu kuwarringulu yija yiji munu kurlujartiny jilkulunyurru, Kurayijimilija muwarrja jilkulunyurru ngarramarntilu, nyurranga ngarlungu jilkulunyurrarningu, palajunjalu yija-yiji tuku jilkulunyurrarninyi. ");
INSERT INTO nna_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Ngarrkalu wirrirninganyjurruku warinypa wariny muwarrarrangu. Yinyanganyjurrinyi palarrangu muwarr ngalypa wantuluminyi ngungku wiyirr, ngalypa kalkuluminyijaninyi jinta, munu kurlu jilkuluminyijanaku. Waraja wirtu yiji muwarr wirrirninganyjurruku: Nyungulu warajalu muwarrju warlirnajaninyi jinta wiyirr muwarrarrangu Ngarrkaja: “Nyuntulu yijalu yiji tuku jinanparningu. Palajunju wiyirr jinta pukun marrngurrangu tuku jilamanjaninyi nyuntulukapali tuku jinanparningu.” ");
INSERT INTO nna_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Kurlkarri marnarnanyurrinyi yarranyurrulu warinykurnu. Wunyjurru? Muwarrja kulilu yirrirninyurrarningu? Nyurni marnanyurrurnarningu? Tuku jilkulunyurrarningu! Palajunjalu kurlujartinyja yiji jilkulunyurrarningu mujujakartijakun. ");
INSERT INTO nna_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Nyungu muwarr wirtu wurrarnarnanyurraku: Ngarrkamilaku Pirlurrku yiji pinakarrinyaku. Yirrkulu pinakarrayalu palinyku, palinyja muwarrja yirrkulu jilkulunyurru. Palajun jinajalu munu kurlujartiny jilkulunyurru. Yirrkulu wurralkulunyurrarningu, “Yijalu munu pikaly jilkulumarnarningu ngajulujakun, ngajulu pikaly jilkulumarna Ngarrkangarra.” ");
INSERT INTO nna_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Miranu nyurra marrngurranguku, nganyjurru wiyirr pirlurr ngarlu ngampankata, yirrkulu pikaly jinaku karrinyinyarningu nganyjurrulu. Nganyjurru karrinyanyi warinyku, kurluku, Ngarrka Pirlurr karrinyi warinyku, ngalypaku. Paliny karrinyi ngalypakataku, ngungkuku. Wiyirr pinakarrinyakatarrangu Ngarrkamili Pirlurrku jurtungu jilkulinyjaninyi ngungkuku, ngarlu nyinga malkulinyjaninyi kurlujartiny jinajamarra. ");
INSERT INTO nna_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Ngarrkaku Pirlurrku yiji pinakarrulunyurrulu. Palajunjalu munu kurlkarri manaku muwarr nyarra Muwujujuja. ");
INSERT INTO nna_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Kurrngalju marrngurrangulu munu pinakarrulupiyalu Ngarrkamilaku Pirlurrku. Palarrangu jankanyakatarrangu yiji. Nyurra miranu wunyjurrukata marrngurrangu, jampa ngayarta jarrinyanyi nganyjurrumili wiyirrmili pirlurr ngampankata ngarrakuny, kurlujartinyarranguku jinaku karrinyanyi ngarramarnti, kurlujartiny jinanyi ngarramarntilu. Palajunjalu jinta kurla-kurlakatarrangu jarrinyayijanaku jintaku, jintalu pirirrimarta yikarnayarninyi, jintalu mirtawanyjarri yikarnayarninyi, jintalu munu jurtungu warlirnakayarningu; ");
INSERT INTO nna_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","jintalu marni pinayi miyu mangunyarrangukapali, ngarluja nyurra marnayijaninyi, kurlujartinyarrangu maparnjukapali yumuny jinayijanaku jintanga, yukuny pinayarningu, warnta marnayarninyi, miku jarrinyayarningu, wirrilyi jarrinyayi, raka-raka jarrinyayi, jinta pinayarninyi, yirrku waninyayi waljangajakun, ");
INSERT INTO nna_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","jintamilaku wurrukarraku karrinyayijanaku, yawurr jarrinyayi, yawurrja warajanga ngawu jarrinyayi, kurlujartinyarrangu jinayi, nganin-nganinarrangupa jinayi palajunmarta. Palajunmarta yirrkulu jinayi pirlurrjalu ngampankatajalu. Palajunmarta jinakatarrangu munu wantulupiyi Ngarrkanga palinymilingi warrarnja. Yija pala muwarr. Purlpi wurrarnarnanyurraku minyirrju, kuwarri yarrana kurlkapirli jinirninyurrinyi: Palajunmarta jinajarrangu munu wantulupiyi Ngarrkanga. ");
INSERT INTO nna_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Jintalu marrngurrangulu yirrkulu pinakarrulupiyalu Ngarrkamilaku Pirlurrku. Palinyju kurlkapirli jinajaninyi marrngurrangu warinykurnu, ngalypakurnu. Ngarlu nyinga manajaninyi marrngurrangulu ngarlungu wirrilapiyarningu, ngarlu pikaly jinajaninyi, ngarlu wuta jinajaninyi, palinyju nyampa-nyampa jinakatawayi jinajaninyi, ngalypakatarrangu jinajaninyi, yirnikatarrangu jinajaninyi, ");
INSERT INTO nna_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","jakartakata jinajaninyi marrngurranguku, warlilapiyiyarningu janamili walja ngampankata pirlurr. Wayirti? Nganurtu marrngulu karra malkuliny, “Palajunmarta jinaku kurlu. Munu palajun jilaman!” Munu yiji marrngulu palalu muwarr pilkuliny palajunmarta! ");
INSERT INTO nna_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Palarrangulu Kurayiji Jiyijajimilirrangulu yirrkulu wurralkulupiyarningu, “Ngaju ngampankata pirlurr kurlujartinyku karrinyarni. Munu yiji! Ngajulu yakalamarna kurlujartiny. Munu ngampankata jarrulumarna. Ngajulu pinakarrulumarnalu Ngarrkamilakujakun Pirlurrku!” ");
INSERT INTO nna_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Yu! Kurlumajirrilu Pirlurrju wankanyu jininganyjurrinyi. Palajalu nganyjurrulu palinyku yijalu wurralaminyili nyampali jarrulinynganyjurruku. ");
INSERT INTO nna_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Yija munu raka jarruluminyi, yijalu munu yirrngilaminyarninyi, yija munu miku jarruluminyarningu. ");
INSERT INTO nna_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Kurijinarrangukayi, miranu nyurra nganiku Ngarrka karrinyi. Yijapa warinyju Kurijinju kurlujartiny jilkuliny. Kurlumajirriku Pirlurrku pinakarrulunyurrulu, palaja ngalypaku jurti jilkulunyurrulu pala Kurijin, jakartalu. Kurlkapirlilu jilkulunyurru — munu nyurralu jilkulunyurru nyarralukapali. ");
INSERT INTO nna_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","Paju karrulunyurrujanaku ngurnjurljartinyarranguku. Yakujun jinajalu jilkulunyurru Kurayijimilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Munu nyurra-nyurra wantulunyurru. Yijapa nganurturrangulupa wuparturrangulu wurralipiyarningu, “Ngaju wirtu”. Palajunmarta wurranajalu mitu marnarninyi. Yijarla wuparturrangujakun jana. ");
INSERT INTO nna_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Nyuntulu yirrkulu japirr malamanparningu, “Wunyjurru? Pala jinirni Ngarrkaja muwarrja?” Yijapa ngalypa. Palaja ngarlu ngalypa jarruluman. Munu wurralamanparningu, “Palarrangulu jintalu kurlu jinikinyiyi, ngajulu ngalypamarta jinikinyirni.” ");
INSERT INTO nna_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Nyuntumilingarra jurtu jilkuluman nyuntulu. Palajunku karrinyi Ngarrkalu. Munu parrjalamanjaninyi jinta yimpinaku. ");
INSERT INTO nna_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Yijapa marrngulu miranu jilkulinyurrinyi Ngarrkamilaku muwarrku. Puntaju nyurralu yungkulunyurrulu mayipa warnkupa wurrupa nganin-nganin nyurramilaku pirnti pinakataku. ");
INSERT INTO nna_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Pinakarrayi! Marrngulu mitu yakalali Ngarrkanga. Yijapa kurlkarri maninyi, “Ngarrka munumpa ngajuku.” Palinyju puru mitu marnarninyi! Kurlu pini yiji! Ngarrkalu yirrkulu parrjarna, tarn-tarn jilkulinypalu panypanyajaku. ");
INSERT INTO nna_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Yijapa marrngulu kurlu jilkuliny. Puntaju kurlu jilkulinypalu Ngarrkalu. Yijapa marrngulu ngalypa jilkuliny. Puntaju ngalypa jilkulinypalu Ngarrkalu. Yijapa marrngulu yirrkulu jilkuliny ngampan-ngampankatalu pirlurrju. Puntaju marlkarri jarrinyaja Ngarrkalu jurtu ngakalkuliny ngarramarnti. Yijapa marrngulu yirrkulu pinakarrulinypalu Pirlurrku Kurlumajirriku. Puntaju marlkarri jarrinyaja Ngarrkalu wangkamarta wirrilkuliny, palanga wantuliny Ngarrkanga ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Palajalu purnku-purnkuwayilu nganyjurrulu yirrkulu ngalyparrangu jilkuluminyi. Palajun jinaja yartikarra puntaju Ngarrkalu ngalypa yiji jilkulinynganyjurruku. ");
INSERT INTO nna_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Palajalu yirrkulu ngalypa jiliminyijanaku marrnguku wiyirrku, yija-yiji ngalypa jiliminyijanaku yijalmarta jinakatarranguku. ");
INSERT INTO nna_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Munu yawurr jarrinyaku wayinjartiny, pala nyarra ngawu jinakata, kurlkarri manamajirrilu kurlujartiny jilaman. Yijamarta yungkulunyurrarninyili Ngalypakatanga Pirlurrja, palinyju jipanaku nyurraku jurtungu. ");
INSERT INTO nna_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Pirirrimartalu nyarra yijalu yiji tuku jinayarningu jana kawu. Palajunju pukunngarra yijalu tuku jilapiyarninga janamili mirtawanyjarrri. Ngarnurtulupa tuku jinarninga mirtawa palinymili tuku jinarninyi palinyju pukunngarra. ");
INSERT INTO nna_vpl VALUES ("H11_1a","082_1_1a","1TH","1","1a","1a","Nyungu muwarr ngajuja Paul-ja, ngapija, Silas-japa Timothy-ja pukun. Nganarnalu mirli-mirlingi yarntarniyirni nyurraku yijalmarta `jinakatarranguku ngurnungungu, Thessalonica-nga. Ngarrkamilipa Jesus-mili nyurra. Nyarra Ngarrka Japartu nganyjurrumili, nyarra Jesus Christ Nyampali nganyjurrumili. Pulanymilingarra nyurra wiyirr. Nyungu muwarr nyurraku wiyirrku. ");
INSERT INTO nna_vpl VALUES ("H11_1b","082_1_1b","1TH","1","1b","1b","Nganarnalu japirr marnayirni nyurraku Ngarrka Japartu nganyjurrumilipa Jesus Christ nganyjurrumili Nyampali pukun, pulanyju ngalypalu kalkulkulinypulunyurrinyipa ngayiny wutaku jilkulunypulunyurrinyi. ");
INSERT INTO nna_vpl VALUES ("H11_2","082_1_2","1TH","1","2","3","Yirrkulu japirr marnayirni Ngarrka ngalypa jilkulunyurraku wiyirrku. Kurlkarri marnayirninyurrinyi, yijalmarta jirninyurrulu Nyampali Jesus Christ-ja, palajunjalu yirnku jirnanyurru ngarrakuny. Ngayinyja nyurranga Ngarrka, palajunjalu nyurralu yirrkulu nganiwarralpirti jirnanyurru yirnkulu jirnanyurru Ngarrkaku. Nyurralu yijalmarta jirnanyurru Nyampali Jesus kulpuliny kankajirrija, palaja kangkulunyurrinyi Ngarrkamilikarti warrarnkarti. Palajunjalu yirrkulu paliny yajarnanyurru. Jintalu kurlujartiny jirnayinyurraku, munu purlu jarrimanyurralu. Nganarnalu kurlkarri marnayirninyurrinyi nganikapali nyurra. Palajalu yirrkulu karra marnayirnalu Japartu Kankajirriku, “Yarrarnija!” ");
INSERT INTO nna_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Yu, nganarna miranu nyurraku, Ngarrkanga ngayinyja nyurra, ngurrju marnanyurrinyi palinymilirranguku jarrinyaku. ");
INSERT INTO nna_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Nganarna milpanyiyirni nyurraku, wurrarniyirni nyurraku, “Ngarrkalu ngakarna Jesus nyurraku kartuwarra manaku.” Munu nganarnamili muwarrjalujakun yijalmarta jirninyurrulu. Munu! Ngarrkamili Pirlurr Ngalypakata milpnya nyurraku, palinyjungarra wurrarnanyurraku, “Yija pala muwarr!” Nyurralu yijalmarta jirninyurrulu palanga muwarrja. Palajunjalu nganarna miranu nyurraku Ngarrkalu ngurrju marnanyurrinyi palinymilirrangu jarrinyaku. Nyarra waninyikinyiyirninyurraku, miranu nyurra nganarnaku, nganiwarralpirti jirniyirni, nyurralu palajunngarra jilkulunyurru nganarnalukapali. ");
INSERT INTO nna_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Jampa pinakarrinyinyurrunganinyi, nyurralu pukun jirninyurrulu nganarnalukapalipa nganyjurrumilalu Nyampalilu Jesus-jukapali, yirnkulu nganiwarralpirti jirninyurru. Jintalu kurlujartiny jirnayinyurraku, partal ngampa-ngampa pinayinyurrinyi yijalmarta jinaku palinyja. Nyurralu yirrkulu pikalyju yijalmarta jirninyurrulu. Ngalypakatalu Pirlurrju pikaly kalkurnanyurrinyi. ");
INSERT INTO nna_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Palajalu jinta yijalmarta jinakatarrangu palangajirri warrarnjajirri, Macedonia-ngapa Achaia-nga, kurlkapirli jarrinyiyi jana nyurrakapaliku jarrinyaku. ");
INSERT INTO nna_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Nyarra muwarr Nyampali Jesus wirtu jarrinyikinyi nyurraja ngunarrijirri wiyirrkarti marrngurrangukarti Macedonia-ngapa Achaia-nga, palangajirri. Munu palarrangulujakunwayi pinakarrinyiyi pala muwarr, jintalu pukun ngunarrijirri warrarnjajirri pinakarrinyiyi pala muwarr, palarrangu wiyirr miranu nyurraku yijalmarta jirninyurrulu Ngarrkanga. Nganarnalu munu wurrarnamiyirnijanaku nyurra, purlpi ngarrany kaninypirti miranu waninyikinyiyi nyurraku. ");
INSERT INTO nna_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Marrngu ngunarrijirri warrarnjarrangu wurrarnayinyurrinyi. Jana miranungarra nyurraku, pinakarrinyinyurru nganarnamili muwarr, palajunjalu wirrini yakarnanyurrujaninyi mitu mangunykapalirrangu, Ngarrkamilirrangu jarrinyaku karrinyinyurru yija-yiji. Ngarrkangarra yija wankanyu waninyi ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Yu, nyurralu yijalmarta jirninyurrulu nyarranga wankanyu waninyipa ngarrakuny, mimarnanyurralu palinymilaku Pujamuku Jesus-ku. Palinyju wankanyu jirni Jesus marlkarrija. Kuwarri mimarnanyurralu Jesus-ku kulpanyajaku parlparrjaja. Palinyjungarra kartuwarra marnanganyjurrinyi yijalmarta jinakatarrangu. Palajunjalu Ngarrkalu munu kulilu yirrilkulinynganyjurrinyi. ");
INSERT INTO nna_vpl VALUES ("H12_1","082_2_1","1TH","2","1","2","Yu, nyurra miranu milpanyiyirninyurraku, munu puru wurrarnayirninyurraku Ngarrkamili ngalypakata muwarr. Yijalu yijalmarta jirninyurralu. Purlpi Philippi-nga jintalu marrngurrangulu kulilu yirrirniyinganinyi, wirlarniyinganinyi, kurlujartinyja kalkurnikinyiyinganinyi. Miranu nyurra palaku. Palaja yakarniyirni Philippi, milpanyiyirninyurraku Thessalonica-karti. Palanga wurrarniyirninyurraku Ngarrkamili muwarr. Jintalu marrngurrangulu munu pinakarrimiyinganaku. Partal ngampa-ngampa pirniyinganinyi muwarr pinaku. Nganarna munu wirnti karrimiyirnijanaku, Ngarrkalu muwarr pinaku tarn-tarn jirninganinyi. ");
INSERT INTO nna_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Wurrarnikinyiyirninyurraku nyarra yija muwarr, munu purulu mitu manamiyirninyurrinyi ngapiku warnkukupa yingamanyurrunganinyi. Munu. Yirrkulu yirnkulu jirnikinyiyirni nganarnalu. ");
INSERT INTO nna_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Ngarrkalu ngarrakunyju parrjarnanganyjurrinyi, paliny miranungarra nganikupa nganyjurrulu kurlkarri marnanyi. Palinyjungarra ngurrju marnanganinyi nganarna jakul kanganyaku nyungu palinymili yija muwarr nyurranga. Palajalu nganarnalu karrinyiyirnalu Ngarrkakungarra pikaly jinaku, munu marrngurranguku pikaly jinaku. ");
INSERT INTO nna_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Munu nyurra marnamiyirninyurrinyi, ngapi nyarra nyurralu puntajulu wurrarnamanyurrunganinyi yija ngalypakata. Munu lirrjalkatarrangu jarrimiyirni warnkukupa nganiwarralpirtiku. ");
INSERT INTO nna_vpl VALUES ("H12_6","082_2_6","1TH","2","6","7","Munu japirr marnamiyirninyurrinyi nyurralu nyurra manaku nganarnakupa jintalu pukun. Ngarrka miranu ngajuku, ngajulu yijalu wurrarnarni. Nganarnalungarra wurrarniyirninyurraku muwarr nyarra Jesus Christ. Palinyjungarra nyungu ngakarnanganinyi nyurrakarti. Palajunjalu nganarnalu japirr marnamiyirninyurrinyi nyurralu ngalypanga kalkurnamanyurrunganinyipa warnku yingamanyurrunganinyi. Munu! Nganarna panyju karrinyiyirni palajun jinaku. Nganarnalungarra kalkurniyirninyurrinyi ngalypalu. Nyurra miranu nyarra pipilu tukulu kalkurnikinyi partany wupartu palinymili, palajunmartakapali jarrinyiyirninyurraku. ");
INSERT INTO nna_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Nganarnanga ngayinyja yiji nyurra, kurlkarri marnayirninyurrinyi ngarrakuny ngarrakunyju ??. Palajalu munu muwarrjakun yinyayirninyurrinyi ngalypakata Ngarrkaja. Waljakapali jirniyirninyurrinyi nganarnamilikapali pukun. ");
INSERT INTO nna_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Yu, wurrarniyirninyurrakupa muwarr Ngarrkaja, warrkamu jarrinyikinyiyirna mayipinti warnkuku. Munu japirr manamiyirninyurrinyi mayiku. Munu nganamayirni mayi nyurramili. Nganarna marrja warrkamu jarrikinyiyirna karrpungupa warrukartingi pukun warnkuku maninyaku nganarnamilaku. Nyurra miranu palajunngarra palajunjungarra ?? jirnikinyiyirni. ");
INSERT INTO nna_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Nyarra wanikinyiyirninyurraku, ngarrakunyju yirnkulupa kurlumajirralu jirnikinyiyirni Ngarrka pikaly jinaku. Nyurra miranu palaku, Ngarrka pukunngarra, yija-yiji pala muwarr. ");
INSERT INTO nna_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","Nyurra miranu nyarra japartulu miranu jininyi yirnkulu jinaku partany palinymili, palajunmartakapali jarrinyiyirni nyurraku. Nganarnalu ngarrakunyju wurrarniyirni nyurraku yirnkulu jilkulunyurru pikaly jinaku Ngarrkaku. Palinyjungarra ngurrju marnanyurrinyi. Yarti palinyju kangkulinyurrinyi palinymilikarti ngalypakatakarti warrarnkarti. Palajunjalu nyurralu yirnkulu nganiwarralpirti jilkulunyurralu palinykungarra pikaly jinaku. ");
INSERT INTO nna_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Jampa wurrarniyirninyurraku pala ngalypakata muwarr nyurralu pikalyju pinakarrinyinyurru. Kurlkarri marnanyurru, “Nyungu Ngarrkamilingarra muwarr, munu Paulmilijakun.” Pala yijangarra Ngarrkamili muwarr. Nyurralu yijalmarta jirninyurrulu palanga muwarrja, kurlujartiny jinajalu warinykurnu jarrinyinyurru, kuwarri yirnkungu jarrinyinyurru. Palajunjalu nganarnalu yirrkulu karra marnayirnalu Ngarrkaku, “Yarrarnija!” ");
INSERT INTO nna_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Jampa yijalmarta jirninyurrulu Ngarrkamilingi muwarrja nyurramili warrarn waljarrangu marrngurrangu kuli jarrinyiyinyurraku. Nyurra jintakapali jarrinyinyurru, palarrangu yijalmarta jinakatarrangukapali ngapinga, Judea-nga. Janamili warrarn waljarrangu marrngurrangu kuli jarrinyiyijanaku, partal ngampa pirnikinyiyijaninyi Jesus Christ yajanaku. Palajunmartakapali nyurramilalu warrarnja waljarrangulu partal ngampa pirnikinyiyinyurrinyi yajanaku palinyku. ");
INSERT INTO nna_vpl VALUES ("H12_15","082_2_15","1TH","2","15","16","Kurrngalju Jew-arrangulu marrngurrangulu panyju karrinyiyili Ngarrkamilaku muwarrku. Purlpilu jintalu marlkarri wirlarnikinyiyijaninyi Ngarrkamili muwarr jakul kanganyakatarrangu. Nyarra purlpi wirlarniyi jintalu nganyjurrumili Nyampali Jesus. Kuwarrimartanga jintalu jurtu ngakarniyinganinyi nyurramilija tawunja. Janalu ngarrakunyju partal ngampa pirniyinganinyi kanganyaku yija muwarr Nyampali Jesus-mili nyurrakupa warinyarranguku. Yini marnayarninyi “Jew-arrangu”, wiyirr jinta ngunarrijirri ngapi yini marniyijaninyi, “Gentile-arrangu”. Nganarna karrinyiyirnijanaku wiyirrku ngapi Gentile-arranguku miranu jarrinyaku Nyampali Jesus-ku, yijalmarta jinaku palinyja. Wiyirr palajun jinajarrangu Ngarrkalu kartuwarra malkulinyjaninyi. Nyarrarrangu Jew-arrangu ngampa-ngampa pinakatarrangu wiyirrku jintaku. Jana panyju karrinyikinyiyijanaku jintaku Jew-arrangukupa Gentile-arranguku pinakarrinyaku muwarrku Nyampali Jesus-mili. Jana kurlujartinykatarrangu. Palajalu Ngarrka kuli jarrinyijanaku. Yartikala wirlalkulinyjaninyi marrjalu yiji. ");
INSERT INTO nna_vpl VALUES ("H12_17","082_2_17","1TH","2","17","18","Yu, nyarrarrangu Jew-arrangulu jurtu ngakarniyinganinyi nyurramilija tawunja. Palajalu yirrkulu kurlkarri marnayirninyurrinyi, ngayinyja nganarnanga yiji nyurra. Kulpanyaku karrinyikinyiyirninyurraku nyurrakartiku, marrapa karrinyikinyiyirninyurraku. Ngajulu Paul-ju marlumal yakurr marnarna kulpanyaku nyurrakartiku, Jayitanju ngampa-ngampa pirnikinyinyi. ");
INSERT INTO nna_vpl VALUES ("H12_19","082_2_19","1TH","2","19","20","Yu, yija yiji nyurraku kulpanya yirrinaku karrikinyirna. Purlpikurra Nyampali Jesus wurrarniyirninyurraku, yijalmarta jirninyurrulu, kurlujartiny yakarnanyurru, ngalypakatarrangu ngalypa jinakatarangu ?? jarrinyinyurru. Palajunjalu nyurralu pikaly jirninyurrunganinyi yija. Yarti Jesus nganyjurrumili Nyampali kulpuliny parlparrjaja. Palanga nganarnapa nyurra pukun kunmu wararr karruluminyi wangka yiji, palinyju warajanga yirrilkulinynganyjurrinyi. Miranu jarrulupiyirni nyurraku, munu puru wurrarnikinyiyirninyurraku Ngarrkamili ngalypakata muwarr. Palajunjalu pikaly yija yiji jarrulupiyirni. ");
INSERT INTO nna_vpl VALUES ("H13_1","082_3_1","1TH","3","1","2","Ngajulu munu kakurnamarnanyurrinyi, ngayiny kurluny-kurluny jarrinyikinyirni nyurraku. Karrinyikinyirni nyurraku yaninya yirrinaku. Yartikarra ngakarnarna nyurraku Timothy. Timothy waraja, nganarnamilingarra paliny Ngarrkamili jakul kanganyakata, marrngurranguku jakul kanganyajanaku muwarr Jesus Christ-mili. Wurrarnarnala, “Ngaju wantulumarna nyungungu Athens-ja. Nyuntu kulpulumanjanaku Christian-arranguku ngapinga Thessalonica-nga.” Paliny ngakarnarnayurraku jakurlinaku marrjalu, ?? Nyampali Jiyijajinga yijalmarta jilkulinyurrulu ngayiny tarn-tarnjupa wirntimajirralu ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("H13_3","082_3_3","1TH","3","3","4","Jintalu kurluny-kurlunyja wirrilapiyinyurrinyipa wirntiji pilayinyurrinyili, warinykurnu jiliyinyurrinyili yajanaja Nyampalija Jesus-ja. Nyarra waninyiyirninyurrakupa wurrarniyirninyurraku palajunmarta jilkulupiyinyurrinyi. Kuwarri nyurra miranu wurrarniyirninyurraku yija muwarr. ");
INSERT INTO nna_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Yu, ngajulu ngayiny kurluny-kurlunyju kurlkarri marnikinyirninyurrinyi. Kurlkarri marnikinyirni, “Ngurnipali Jayitanju yakurr marnajaninyi, palajalu ngurnipali kuta yakarnaya yajanaku Nyampali Jesus. Yijapa Ngarrkamili muwarr puruku wurrarniyirnijanaku.” Palajunngarra kurlkarri marnikinyirni. Ngaju kurlkapirli jarrinyaku karrinyikinyirninyurraku. Palakungarra Timothy ngakarnarnanyurraku parrjana yirrinaku. ");
INSERT INTO nna_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Timothy kuwarrimartangarra kulpanya. Palinyju wurrarnaji nyurralu yirrkulu yijalmarta jirninyurrulu Ngarrkangapa tuku jirnanyurrarningu ngalypalu. Ngayiny ngalypalu kurlkarri marnanyurrunganinyi, nyurralu karrinyinyurrunganaku karrinyanyurrunganaku ?? yirrinaku nganarnaku. Palajunju pukun nganarnalu karrinyiyirninyurraku yirrinaku nyurraku. ");
INSERT INTO nna_vpl VALUES ("H13_7","082_3_7","1TH","3","7","8","Yu, Timothy-lu jakul kanyaji, pikaly yiji jirninyi palinyju. Nyungungu jintalu kurluny-kurlunyja wirrirnikinyinyiyi. Ngayiny kurlu jirninyiyi. Kuwarri ngaju miranu nyurraku, yirrkulu yajarnanyurru Nyampali Jesus. Palajunja ngaju pikaly jarrinyarninyurraku. ");
INSERT INTO nna_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Muwarr pinaja Ngarrkaku, kurlkarri marnayirninyurrinyi, pikaly yiji nganarna. “Yarrarnija!” karra marnayirnalu Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Yirrkulu ?? night and day muwarr pirniyirnalu Ngarrkaku nyurraku, wurrarniyirnili karrinyiyirninyurraku yarrana yirrinaku, nyurra miranu jilapiyirninyurrinyi Ngarrkaku. Palajunjalu nyurra miranu yiji jarrulunyurralu palinyku. ");
INSERT INTO nna_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Palakungarra japirr marnayirnipulinyi Ngarrka nganyjurrumili Japartupa Jesus nganyjurrumili Nyampali, “Yijapa tukulu kulpanyakanu kawapulunganinyili palamakarti marrngurrangukarti Thessalonica-nga.” ");
INSERT INTO nna_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Japirr marnayirninyurraku Nyampali Jesus, yijalu ngayinyju ngalypalu tuku jilkulinyurrarninyi. Nganarnanga ngayinyja yiji nyurra, palajunmartalu yijalu ngayinyju ngalypalu tuku jilkulunyurrarninyipa jintaku marrngurranguku pukun. ");
INSERT INTO nna_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Karrinyiyirninyurraku tarlka waninyaku pirlurrja nyurramilingi, kurlumajirri yiji waninyaku ?? May he make your hearts strong, blameless and holy. Palajunmartalu japirr marnayirni Nyampali Jesus tarn-tarn jinaku nyurraku. Paliny kulpanyaja parlparrjaja palinymili angel-arrangujartiny ?? “with all his holy people” — does this include Christians/saints? nyurra kurlumajirri wararr karrulunyurru Ngarrkanga nganyjurrumilinga Japartunga. ");
INSERT INTO nna_vpl VALUES ("H14_1","082_4_1","1TH","4","1","2","Yu, nyurra miranu muwarrarranguku nyarra wurrarniyirninyurrakupa. Pala muwarrarrangu nganyjurrumilija Nyampalija Jesus-ja. Nganarnalu miranu jirniyirninyurrinyi wunyjurrukapaliku waninyaku pikaly jinaku Ngarrkaku. Nyurralu pinakarrinyinyurrunganaku. Kuwarri nyungu wurrarniyirninyurraku Nyampalija Jesus-ja: Yirrkulu jirnarrayi yirnkulu yiji nganarnamilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Ngarrkalu karrinyinyurraku yakujun waninyaku. Palinykapali jarrulunyurru, kurlumajirri. Nyurra wiyirr wantulunyurrarningu waljangajakun nyupajingi, munu marru manaku warinymili nyupaji. Munu yiji! ?? - sexual sins - sensitive subject kurla-kurlakatakapalirrangu ");
INSERT INTO nna_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","Jinta marrngurrangu munumpa yiji Ngarrkaku, janalu yirrkulu marru marniyijaninyi mirtawanyjarri warinymili ?? - sexual sins - sensitive subject kurla-kurlakatakapalirrangu. Munu janakapali jarrinyaku ?? yijalmarta jinakatawayirrangukapali. Munu! Nyurramilinga wantulunyurrujanaku waljangajakun nyupajinga. Panyjarrmajirrilu kalkulumanpa ngalypalu jilamanpalu. ");
INSERT INTO nna_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Yijapa nyurranga warinyju ngulyulu kawali warinymili mirtawa. Ngarrkalu kuli jarrulinypalu palaku ngulyukataku. Ngarrkalungarra wirlalkulinyjaninyi palajunmartarrangu. Purlpi nganarnalu minyirrju wurrarniyirninyurraku pala muwarr. ");
INSERT INTO nna_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Ngarrkalu wurrarnanganyjurruku Christian-arranguku palinykapaliku waninyaku, kurlumajirri, munu jintakapali kurla-kurlakatakapalirrangu ?? - sexual sins - sensitive subject. ");
INSERT INTO nna_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Jintalu panypanyayili nyungungu muwarrja. Palarrangulu panypanyakatarrangulu panypanyayinganakupa, panypanyayili Ngarrkangangarra. Ngarrkalungarra yinyanyurrinyi palinymili Ngalypakata Pirlurr, munu panypanyaku palinyja. ");
INSERT INTO nna_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Yu, Ngarrkalu purlpi wurrarnanyurraku ngalypalu tuku jilkulunyurrarninyi. Munu palaku nyungungu mirli-mirlinga yarntalapinyinyurraku, nyurra purlpi miranungarra palaku. ");
INSERT INTO nna_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Yu, nyurralu ngalypalu tuku jirninyurrujaninyi Christian-arrangu nyurramilinga warrarnja, Macedonia-nga. Kuwarri wurrarniyirninyurraku, yirrkulu palajun jiliyi. ");
INSERT INTO nna_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Munu yananyaku jintamilikarti ngurrakarti yimpinaku, jinta marrngurrangu kurrpanakata. Palajunmartaja ngayiny kurlujartiny kuli jarrayili. Yirrkulu marrjalu warrkamu jiliyi. Palangarra nyarra wurrarniyirninyurrakupa purlpilu. ");
INSERT INTO nna_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Warrkamu jarrayi mananyaku warnkuku mayipinti. Palajunjalu nyurra munu kulyi yankulunyurrujanaku jintaku. Marrngurrangulu jinta wurralapiyinyurrinyi ngalypanga yirnkungu waninyanyurru. ");
INSERT INTO nna_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Yuu, pinakarrayi nyungu muwarr yijalmarta jinakatarrangu purlpi marlkarri jarrinyiyipa. Karrinyiyirninyurraku miranu jarrinyaku palarranguku. Palajalu munu yirrku paju karrulunyurrujanaku. Jinta munumpa waninyayalu Ngarrkaku, palajalu paju karrinyayi janaku ngarrakuny. Munu paju karrulunyurru janaku nyarrarrangukapali. Nyarrarrangu yijalmarta jinakatawayirrangu Nyampalingi Jiyijajingi, jana paju yiji marlkarri jarrinyajarranguku. ");
INSERT INTO nna_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Jesus marlkarri jarrinyi. Palaja Ngarrkalu yarrana wankanyu jirni. Yijalmarta jirninyili palanga muwarrja. Palajunjalu yijalmarta jirninyili nyungungu warinyja muwarrja pukun: Yarti Ngarrkalu ngakalkuliny Jesus parlparrjaja mananyaku yijalmarta jinakatarranguku marlkarrinyjarriku. Palarrangu Nyampalilu Jesus-ju kangkulinyjaninyi Japartukarti, yijalmarta jinakatarrangu. ");
INSERT INTO nna_vpl VALUES ("H14_15","082_4_15","1TH","4","15","16","Nganarnalu wurrarniyirninyurraku nyungu muwarr nganyjurrumilija Nyampalija Jesus-ja. Paliny kulpuliny parlparrjaja mananyaku wiyirrku yijalmarta jinakatarranguku, palinyju kangkulinynganyjurrinyi Japartumilikarti warrarnkarti. Palinyju kangkulinyjaninyi kuwarri wankanyupa waninyayi, marlkarri jarrinyaja pukun. Nyarra wankanyu waninyayipa munu jana palaji walangkarra yankulupiyi kanka parlparrkarti. Munu! Pala yakujun jarruliny: Nganyjurrumili Nyampalingarra milpuliny parlparrjapa kamalkulinyjanaku marrjalu marlkarrinyjarriku yijalmarta jinakatarranguku. Wirtulu angel-ju puyu pilkulinypili wirtungu trumpet-ja. Nyarrarrangulu marlkarrinyjarrilu pinakarrulupiyi pala trumpet, Nyampali Jesus pukun kamanaja. Palajunja palarrangu marlkarrinyjarri wanka jarrulupiyi. ");
INSERT INTO nna_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Palaja nyarra wankanyupa waninyayi yijalmarta jinakatarrangu kanka jilkulinyjaninyi. Nganyjurru wiyirr kuru malkulinynganyjurrinyi kanka mujungungu, nyarra marlkarri jarrinyajapa jinta pukun. Palajunngarra nganyjurru wiyirr wantuluminyili nganyjurrumilinga Nyampalinga Jiyijajinga ngarrakuny. ");
INSERT INTO nna_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Palajunjalu nyurralu yirrkulu ngayiny tarlka jiliyarninyipa pikaly jiliyarninyi muwarrjartinyju nyungujartinyju.?? ");
INSERT INTO nna_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Ngurnipali jintalu kurlkarri marnayi, “Nyanga Nyampali Jesus kulpulinynganyjurruku mananyaku? Nyanga wirlalkulinyjaninyi nyarrarrangu kurlujartiny jinakatarrangu?” Nyampa palaji milpuliny Nyampali nganyjurrumili. Purlpi miranungarra nyurra palaku muwarrku. Munu nyungu mirli-mirlilu miranu jilamarnayurrinyi palaku. Nyanga milpuliny? Palaku wiyirr munumpa nganyjurru. ");
INSERT INTO nna_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Nganarnalu nyarra wurrarniyirninyurraku paliny, nyampangarra turlpuliny. Kurrngal marrngurrangu munu mira karrulupiyalu palinyku. Yuu. Ngurnipali ngulyukata yarrali warinymilikarti ngurrakarti warrukartingi. Palarrangu jinta munumpa palaku nyanga milpulinyjanaku janamilinga ngurranga. Janalu munu mintulu mimalapiyalu palaku ngulyukataku. Palajun Nyampali Jesus wangka palaji turlpulinynganyjurruku, kurrngal marrngurrangu munu mira karrulupiyalu palinyku. ");
INSERT INTO nna_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Palanga janalu wurralapiyi, “Nganiwarralpirti ngalypa. Jintalu munu kulilu wirlalapiyinganinyi.” Nyarrarli palajunmarta muwarr pirnalupiyipa, palangangarra Nyampali Jesus ngayarta jarruliny. Palinyju wirlalkulinyjaninyi nyampalu palaji, marrjalu yiji wirlalkulinyjaninyi, partal kuku jarrulupiyalu. Nyurra miranu nyarra mirtawanyjarrilu ngayinykarralu partany kanganyiyijaninyi, parra-parra wirtu, munu partal ngampa pilkulupiyijaninyi partany ngayarta jarrinyaku. Palajunkapalingarra jarrulinyjanaku marrngurranguku, nyarrarrangu palal waninyiyipa, kulpanyajaku munu mira karrulupiyalu Nyampaliku Jesus-ku. Jana partal kuku jarrulupiyalu palinyjamarra. ?? ");
INSERT INTO nna_vpl VALUES ("H15_4","082_5_4","1TH","5","4","5","Yuu, nyurra munu jintakapali, Ngarrkamiliwayi. Jana waninyayi warrukurlangakapali, Satanmilinga warrukurlanga. Jana munu mira karrinyakayalu Nyampaliku Jesus-ku kulpanyaja. Palinyja kulpanyajanga jana marrpalapiyi. Nyurra munu janakapaliwayi. Nyurra Ngarrkamili, waninyinyurru palinymilinga tilinga. Mimarnanyurralu Jesus-ku. Palinyja kulpanyajalu nyurra munu marrpalkulunyurru, pikaly jarrulunyurru. ");
INSERT INTO nna_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","Nganyjurru munu warrukurlangawayi waninyayinyi. Munu karta karruluminyi ngarrakuny jintakapali. Parrilyju mimalaminyalu mira-mira Nyampaliku Jesus-ku kulpuliny. Nganyjurru munu wantuluminyi karikatarrangukapali, nyarrapa minpirnayi yirrkulu. ");
INSERT INTO nna_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Marrngurrangu karta karrinyayi warrukartingangarra, karikatarrangulu minpirniyi warrukartinga pukunngarra. ");
INSERT INTO nna_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Nganyjurru munu wantuluminyi palarrangukapali, jana warrukurlanga waninyayi. Nganyjurru Ngarrkamili, nganyjurru waninyayinyi palinymilinga tilinga. Palajunjalu nganyjurru yirnkungu wantuluminyalu, munu karikatarrangukapali. Nganyjurrulu yirrkulu Ngarrkanga yijalmarta jiliminyilipa ngalypalu tuku jiliminyarninyi. Kurlkarri malaminyi, Nyampali Jesus-jungarra kangkulinynganyjurrinyi palinymili Japartumilikarti warrarnkarti. Palajunjaja Ngarrkalu tuku jilkulinynganyjurrinyi Satanjamarra. ");
INSERT INTO nna_vpl VALUES ("H15_9","082_5_9","1TH","5","9","10","Ngarrkalu mananganyjurrinyi, palinymili waljarrangu jirninganyjurrinyi. Pala jirni munu kulilu yirrinakupa wirlanaku nganyjurruku. Mananganyjurrinyi tuku jinaku, kangkulinynganyjurrinyi palinymilikarti waljakarti warrarnkarti. Palajunjangarra ngakarnanganyjurruku Jesus nganyjurrumili Nyampali. Palinyngarra kartuwarra manaku marlkarri jarrinyinganyjurruku. Yarti wiyirrku kulpulinynganyjurruku mananyaku, wankanyurrangupa marlkarrinyjarri. Palinyju kangkulinynganyjurrinyi wiyirr palinyja waninyaku ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Palajunjalu kurlkapirli jilkulunyurrarninyi nyungulu muwarrju, palaja munu ngayiny kurluny-kurluny jarrulunyurru. Nyurralu purlpilu pala muwarr wurrarnikinyinyurrarningu. Palajun yirrkulu jilkulunyurru tarn-tarnju yijalmarta jinaku. ");
INSERT INTO nna_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Yu, japirr marnayirninyurrinyi ngalypalu kurlkarri malkulunyurrujaninyi nyurramili nyampalirrangu. Ngarrkalungarra ngurrju marnajaninyi palarrangu nyampalirrangu nyurraku. Janalu yijalu yiji tuku jirnayinyurrinyipa miranu jirniyinyurrinyi nyurra yijalmarta jinakatarrangu yirnkungu yananyaku. ");
INSERT INTO nna_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Palajunmarta warrkamu jirnayinyurraku. Palajunjalu yijalu yiji ngalypalu kurlkarri malayijaninyipa ngayinyja nyurramilinga jiliyijaninyi. Munu warnta-warnta malkulunyurrarninyi. ");
INSERT INTO nna_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Yakujun jinaku karrinyiyirninyurraku: Jinta nyurranga warrkamu jinakatawayi, wurralayijanaku warrkamu jinaku. Jinta nyurranga wirntikata, wurralkulunyurrujanaku, “Yijalmarta jilayili Ngarrkanga! Tukulu kalkulkulunyurrinyi palinyjungarra. Wirntiwayi!” Jinta nyurranga nyangalykata, wurralayijanaku, “Yijalu yajalayi Nyampali Jesus!” Kintilu jilkulunyurrujanaku wiyirrku. ");
INSERT INTO nna_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Jintalu kurlujartiny jiliyinyurrakulu, munu nyurralu kurlujartiny jilkulunyurrujanaku puntajulu. Tuku jilkulunyurrarninyi ngalypalu yiji, jinta pukun tuku jilkulunyurrujaninyi, munumparrangu Nyampaliku Jesus-ku. ");
INSERT INTO nna_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Yirrku yiji pikaly wantulunyurru. ");
INSERT INTO nna_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Yirrkulu muwarr pilkulunyurralu Ngarrkaku. ");
INSERT INTO nna_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Karra malkulunyurralu yirrkulu Ngarrkaku, “Yarrarnija!” Palajun karra malkulunyurralu ngalypangapa kurlungu pukun. Christian-arrangulu palajunju jinaku. Palajunmartakungarra Ngarrka karrinyi. ");
INSERT INTO nna_vpl VALUES ("H15_19","082_5_19","1TH","5","19","20","Yijapa Ngalypakata Pirlurr muwarr pilkulunyurraku, munu palal yakalkulunyurru. Yijapa warinyju marrngulu wurralkulunyurraku palinyju muwarr pirninyi muwarr Ngarrkaja. Munu panypanyaku palanga muwarrja. ");
INSERT INTO nna_vpl VALUES ("H15_21","082_5_21","1TH","5","21","22","Kintilu yiji pinakarrulunyurru pala muwarr. Japirr malkulunyurrarningu, “Yija pala muwarr? Ngarrkaja pala?” Yijapa yija-yiji, palajangarra muwarrja jilkulunyurru. Yijapa mitu yiji, munu Ngarrkaja, kurlu pala. Munu kurluja muwarrja jilkulunyurru. ");
INSERT INTO nna_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Ngarrka waninyinyurraku nyurranga, palinyjungarra ngalypanga kalkurnanyurrinyi. Palajunja ngayiny wuta waninyinyurru. Japirr marnarnanyurraku Ngarrka, tuku jilkulunyurrinyi, kurlumajirri. Japirr marnarnanyurraku ngalypalu kalkunaku nyurramili pirlurrpa kurlkapa kawu pukun. Kurlumajirri yakujunngarra wantulunyurru ngarrakuny. Warajanga karrpunga Jesus Christ Nyampali nganyjurrumili kulpuliny parlparrjaja, palinyju wurralkuliny, ngalypa yiji nyurra, kurlumajirri. ");
INSERT INTO nna_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Ngarrkalungarra ngurrju marnanyurrinyi palinymili waljarrangu jarrinyaku. Paliny yirnikata, ngalypa yiji jilkulunyurrinyipa tukulu kalkulunyurrinyi palinyju. ");
INSERT INTO nna_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Yuu, japirr malkulunyurrunganaku Ngarrka, tukulu kalkulkulinynganinyi nganarna pukun. ");
INSERT INTO nna_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Nyurra wiyirr Nyampali Jesus-mili. Wiyirr nyurra warajanga jarrinyajanga pikalyju yampu malayarninyi. ");
INSERT INTO nna_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Ngajulu Paul-ju wurrarnarnanyurraku, Ngarrkalu karrinyinyurraku pinakarrinyaku nyunguku muwarrku. Read-amu jilkulunyurru nyungu mirli-mirli wiyirrju pinakarrinyaku. ");
INSERT INTO nna_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Japirr marnarnanyurraku Jesus Christ nganyjurrumili Nyampali yirrkulu ngalypalu tukulu kalkulkulunyurrinyi. Jipi. ");
INSERT INTO nna_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Nyungu muwarr ngajuja Paul-ja, ngapija, Silas-japa Timothy-ja pukun. Mirli-mirlinga yarntarniyirninyurraku yijalmarta jinakatarranguku ngurnungungu, Thessalonica-nga. Ngarrkamilipa Jesus-mili nyurra. Nyarra Ngarrka Japartu nganyjurrumili, nyarra Jesus Christ Nyampali nganyjurrumili. Pulanymilingarra nyurra wiyirr. ");
INSERT INTO nna_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Japirr marnayirninyurraku Ngarrka Japartu nganyjurrumilipa Jesus Christ nganyjurrumili Nyampali pukun, ngalypalu kalkulkulinypulunyurrinyipa ngayiny ngalypa jilkulinypulunyurrinyi. ");
INSERT INTO nna_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Yuu, kurlkanga jirninyurru yiji. Nyurralu yijalu yijalmarta jirninyurrulu Ngarrkangapa ngalypalu tuku jirninyurrarninyi. Yirnku palajunngarra jirninyurru. Palajunjalu pikaly yiji jirninyurrunganinyi. Palakungarra yirrkulu karra marnayirnalu Ngarrkaku, “Yarrarnija!” ");
INSERT INTO nna_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Nganarnalu nyurra marniyirninyurrinyi jintanga Kurijinarrangungu ngurnarrijirri tawunjarrangu. Wurrarnayirnijanaku nyurralu Thessalonica-nga yijalmarta jirninyurrulu Ngarrkanga, kurlkanga jirninyurru yija. Jinta marrngurrangu kuli jarrinyiyinyurrakupa kurlujartiny jirniyinyurraku, Nyampali Jesus yajanaja partal ngampa-ngampa pirnikinyiyinyurrinyipa. Yirrkulu ngarrany yajarnanyurru paliny. ");
INSERT INTO nna_vpl VALUES ("H21_5","083_1_5","2TH","1","5","7","Palajunjalu Ngarrkalu yarti wurralkulinyurraku, “Ngalpayi ngajumili warrarnja!” Palanga paliny Nyampali wantuliny ngarramarnti. Ngarrka ngalypa yiji, yirnkulu jininyi ngarrakuny. Puntaju nyarrarrangu kulikatarrangu wirlalkulinyjaninyi. Palanga nyurraku ngalypa jilkulinyurraku, nganarnaku pukun. Ngarrkalu palajun jilkulinynganyjurruku parlparrja kulpanyaja Nyampali Jesus. ?? Yuu! Ngarrkalu ngakalkuliny Jesus nganyjurrumili Nyampali parlparrjaja wikanga lalyurr-lalyurrkarranga kaninykurnu, palinymilirrangu marrjapanu angel-jartiny pukun.?? ");
INSERT INTO nna_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Palangangarra Ngarrkalu wirlalkulinyjaninyi nyarra palinyku munumparrangu. Panypanyikinyiyili ngalypanga muwarrja Nyampalimili Jesus-mili, panyju karrikinyiyalu. Palajunjalu wirlalkulinyjaninyi wiyirr.?? ");
INSERT INTO nna_vpl VALUES ("H21_9","083_1_9","2TH","1","9","10","Jurtu ngakalkulinyjaninyi ngarrakuny. Nyarrarrangu marrngurrangu munu wangka palanga wirtunga pirrpanga Jesus-milinga waninyakayi. Munu yiji! Nyampalinga Jesus-ja kaja yija yiji wantulupiyi ngarramarnti.?? Wariny jarrulinynganyjurruku, palinymilirrangu nganyjurru. Nyampalinga Jesus-ja wangka yiji wantuluminyi. Wiyirrju yijalmarta jinakatarrangulu paliny nyurra malaminyi. Yuu, yijalmarta jirninyurrulu nganarnamili muwarrja Nyampaliku Jesus-ku. Palajunja nyurra palanga wantulunyurru palinyja. Warajanga wiyirrju nyurra malaminyi Nyampali Jesus, nyurralupa nganarnalupa jintalu yijalmarta jinakatarrangulu pukun. ");
INSERT INTO nna_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Palajunjalu yirrkulu japirr marnayirninyurraku Ngarrka, palinykapali yarni malkulunyurrinyi palinyju. Ngarrkalungarra ngurrju marnanyurrinyi palinymili jarrinyakupa palinykapali jarrinyaku, kurlumajirri. Nyurralu yijalmarta jirninyurrulu palinyja. Palajunjalu yijalu yiji warrkamu jirninyurralupa yirnkulu jirninyurru palinykungarra pikaly jinaku. Japirr marnayirninyurraku Ngarrka nyurramilaku pirlurrku tarlka jinaku, yijamarta jilkulunyurru yirnkungu ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Yirnkulu jilkulunyurru, palajunjalu jintalu nyurra malapiyi Jesus nganyjurrumili Nyampali. Palinyju nyurra pukun nyurra malkulunyurrinyi ngalypa jinaja. Ngarrkalupa Nyampalilu Jesus-ju ngalypalu kalkulkulinypulunyurrinyi. ");
INSERT INTO nna_vpl VALUES ("H22_1","083_2_1","2TH","2","1","2","Yuu, ngurnipali warinyju wurralalu nyurraku muwarr palajun: “Nyampali Jesus Christ purlpi kulpanya, kanyajaninyi marrngurrangu palinymilirrangu Ngarrkamilikarti warrarnkarti.” Mitu pala muwarr. Ngurnipali warinyju wurralalu muwarr yakujun: “Ngarrkamilalu Pirlurrju wurrarnaji nyarra muwarr.” Ngurnipali jintalu wurraliyili nganarnalu yarntarniyirni mirli-mirlinga, “Nyampali Jesus purlpi kulpanya.” Pinakarrinyajalu muwarr palajunmartaja, munu ngayiny kurlu jarrulunyurru, munu wirnti karrulunyurru. ");
INSERT INTO nna_vpl VALUES ("H22_3a","083_2_3a","2TH","2","3a","3a","Munu yijalmarta jinaku palajunja muwarrja. Puru yiji mitu marnayinyurrinyi. ");
INSERT INTO nna_vpl VALUES ("H22_3b","083_2_3b","2TH","2","3b","3b","Walangkarra palaji wariny marrngu turlpuliny, paliny Satan-mili, paliny yini Kurlujartiny Marrngu. Kurrngalju yiji marrngurrangulu pinakarrulupiyalu palaku Marrnguku, warinykurnu jilkulinyjaninyi Ngarrkangamarra. ");
INSERT INTO nna_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Nyarralu marrngulu wurralkulinyparninyi wirtu yiji paliny. Jakurlilkulinyjaninyi marrngurrangu pinakarrinyaku palinyku. Kajalkuliny Ngarrkamilinga Temple-japa karra malkulinyjanaku wiyirrku, “Ngajungarra nyarra wirtu yiji kankajirrija. Yijalu yiji jilkulunyurru ngajumilija muwarrja. Munu yijalmarta jilkulunyurrulu Ngarrkanga. Munu pinakarrulunyurrujanaku jintaku mangunyarranguku. Yijalu ngajuku pinakarrulupijinyurru!” Yuu, palajun jilkuliny painyju. ");
INSERT INTO nna_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Nyarra wanikinyinyi palanga wurrarnikinyiyirninyurraku nyungu kurlujartinykata marrngu. Kurlkarri malkulunyurru nyungu muwarr. ");
INSERT INTO nna_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Nyarra munu ngayarta jarrima, warinyju ngampa pininyi ngarrany. Nyurra miranu palaku ngampa pinakataku. Yarti pala kurlujartinykata marrngu ngayarta jarruliny Ngarrkamili muwarrja. ");
INSERT INTO nna_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Kuwarri kurrngalju marrngurrangulu yirrkulu panypanyayili Ngarrkanga. Satan-ju kukujarrilu kanganyajaninyi warinykurnu, kurlujartinykurnu. Yartikala Ngarrkalu purlu jilkulinypalu nyarra ngampa pinakata. ");
INSERT INTO nna_vpl VALUES ("H22_8","083_2_8","2TH","2","8","10","Palajangarra pala nyarra Kurlujartinykata Marrngu ngayarta jarruliny. Yuu, Satan-ju ngakalkuliny paliny, mitu marnarrulinyjaninyi maparnjartinyju wirtujartinyjupa. Jilkuliny warinypa wariny kurlujartiny, mitulu palinymilalu ngurra malkulinyjaninyi jinta warinykurnu, kurlungu. Kurlkarri malapiyi paliny wirtu yiji, Ngarrkakapali, pinakarrulupiyalu palinyku. Palaja Jesus nganyjurrumili Nyampali kulpuliny pirrpanga wirtungu yiji parlparrjaja. Wurralkulinypili Kurlujartinykatanga Marrngunga, “Marlkarri wirlalamarnanta kuwarri.” Yija, palalu muwarrju wirlalkuliny. Nyarrapa pinakarrinyiyili palanga Kurlujartinykatanga wirlalkulinyjaninyi wiyirr Ngarrkalu. Pinakarrimayi muwarr yija yiji Ngarrkamili, yijalmarta jirnimayili palinyja, kartuwarra marnamajaninyi. Yakal marnayi muwarr Ngarrkaja. Palajunjalu jurtu ngakalkulinyjaninyi ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Pala yija! Jana panyju karrinyiyi pinakarrinyaku Ngarrkamilaku yijaku muwarrku. Palajunjalungarra Ngarrkalu ngakumpa jilkulinyjaninyi wiyirr kurlkapirlija. Janalu kurlkarri malapiyi warinykurnu, pinakarrulupiyalu palaku kurlujartinykataku mitukataku marrnguku. ");
INSERT INTO nna_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Pikalyju kurlujartiny yajarnayi. Ngarrkalu wirlalkulinyjaninyi palarrangu yakal-yakal manakata palinymilaku yijaku muwarrku. ");
INSERT INTO nna_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Yuu, Nyampalinga Jesus-ja ngayinyja waninyinyurru. Purlpi walangkarrangungarra ngurrju marnanyurrinyi palinymilirranguku jarrinyaku. Ngakarnanyurraku palinymili Ngalypakata Pirlurr kartuwarra manaku nyurraku, ngalypakatarrangu jinaku nyurraku pukun. Pinakarrinyinyurru Ngarrkamili yija muwarrpa yijalmarta jirninyurrulu. Palajunjangarra Ngarrkamilirrangu jarrinyinyurru. Palajunjalu nyurraku yirrkulu karra marnayirnalu Ngarrkaku, “Yarrarnijayi!” ");
INSERT INTO nna_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Ngarrka karrinyanyurraku Nyampalikapali Jesus Christ-kapali jarrinyakupa waninyaku palinyja ngarramarnti.?? Palajunjalungarra ngakarnanganinyi nyurrakarti jakul kanganyaku palinymili ngalypakata muwarr. ");
INSERT INTO nna_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Yuu, tarlka wantayi! Ngarrakunyju yijalmarta jiliyili nyarra muwarr wurrarniyirninyurraku palanga, mirli-mirlinga muwarr yarntarniyirninyurraku. ");
INSERT INTO nna_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","Ngarrkanga nganyjurrumilinga Japartunga ngayinyja yiji nganyjurru wiyirr, palinyju ngalypalu kalkurnanganyjurrinyi. Palajunjalu miranu jarrinyinyi nganyjurru marlkarri jarrinyaja yarrana wankanyu jilkulinynganyjurrinyi, palinyja waninyaku ngarramarnti. Nganarnalu japirr marnayirnipulinyi Jesus Christ nganyjurrumili Nyampalipa Ngarrka Japartu nganyjurrumili, pulanyju ngayiny tarlkapa wirntimajirri kalkulkulinypulunyurrinyi, yirrkulu nyurralu yirnkulu jirnarrayipa yirnku muwarr pirnarrayi. ");
INSERT INTO nna_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Yuu, japirr marnayirninyurrinyi, nyurralu Ngarrkanga muwarr pilkulunyurrunganaku puntaju. Japirr malkulunyurrunganaku ngayiny tarlka jilkulinynganinyi nyampalu jakul kangkulupiyirnijanaku muwarr Nyampali Jesus jintanga marrngurrangungu ngurnarrijirri. Karrinyayirnijanaku pinakarrinyaku pala muwarr, janalu pukun yijalmarta jilapiyili, wunyjurrulu kapali Jakul kanganyikinyiyirninyurraku muwarr Nyampali Jesus-mili. Pinakarrinyaja, pikalyju yijalmarta jirninyurrulu. Palajunju pukun nganarnalu karrinyayirnijanaku jintaku pikalyju yijalmarta jilapiyili. ");
INSERT INTO nna_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Jinta marrngurrangu ngayiny jalypakata, janalu munu yijalmarta jinakayili muwarrja Nyampalinga Jesus-ja. Kuliny-kuliny jarrinyiyi nganarnakupa wirlaliyinganinyili. Japirr malkulunyurru Ngarrka nganarnaku paliny mingka wantuliny nganarnaku palarrangungamarra kurluny-kurluny marrngurrangungamarra. ");
INSERT INTO nna_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Jesus nganyjurrumili Nyampali waninyi nganyjurrunga ngarramarnti, munu wirrina parnpilkulinynganyjurrinyi. Yija yirnkukata paliny. Nyurra yirnkukata jilkulunyurrinyi palinyjupa tuku jilkulunyurrinyi Satan-jamarra. ");
INSERT INTO nna_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Nyampalilu Jesus-ju ngayiny ngalypa jirninganinyi, nyurralu kuwarri yirnku jirninyurru. Yijalu yirnku jirnarrayi nganarnamilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Japirr marnayirninyurraku Jesus-ju nganyjurrumilalu Nyampalilu miranu jilkulinyurrinyi Ngarrkaku, nyurralu yijalu ngayinyja jilkulunyurrarningu Ngarrka. Japirr marnayirni Nyampali Jesus, nyurralu ngayinyju tarlkalu jilkulunyurrulu muwarrja Ngarrkamilija. Jesus-ju nganyjurrumilalu Nyampalilu ngarrakunyju jirnikinyi palinymilija Japartumilija muwarrja. Jintalu kurlu jirnikinyiyalu palinyku, nganin-nganin kurlujartinypa wurrarnikinyayili, palinyju yirrkulu ngarrany jirnikinyi palinymilija Japartumilija muwarrja. Nganarnalu karrinyiyirninyurraku yirrkulu palajunju jirnarrayi Ngarrkamilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Yuu, purlpilu wurrarniyirninyurraku, yija yiji warrkamu jarrulunyurru waljaku warnkuku mayipintiku mananyaku. Jintalu nyurranga panypanyayili nganarnamilia muwarrja, puru kajan-kajarnayi, warrkamumajirri. Pinakarrayi! Wurralapiyirninyurraku muwarr Jesus Christ-ja nganyjurrumilija Nyampalija. Kajamarta wantulunyurru janangamarra palajunkatarrangungamarra, munu kululkulunyurrujaninyi.?? ");
INSERT INTO nna_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Nyurra kurlkapirli, nyurralu jilkulunyurru nganarnalukapali. Nyarra wanikinyinyi palanga, warrkamu jarrikinyiyirni, munu puru kajan-kajarnamiyirni. ");
INSERT INTO nna_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Munu japirr marnamayirninyurrinyi mayiku. Mayiku warnku yinyayirninyurrinyi. Warrkamu jarrinyiyirni. Nganarnalu yija warrkamu jarrikinyiyirna karrpungapa warrukartinga warnkuku waljaku mananyaku nganarnamilaku. Munu mayi ngulyulu nganamiyirninyurruka nyurramili. ");
INSERT INTO nna_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Nyampalilu Jesus-ju ngakarnanganinyi wurranaku muwarrku palinymilaku nyurranga. Palajunjalu japirr marnamiyirninyurrinyingarra mayiku. Puru yakarniyirni. Nganarnalu miranu jinaku karrikinyiyirninyurraku wunyjurruku jilkulunyurru. Palajunjalu marrja yiji warrkamu jarrikinyiyirna. Yakujun pukun ngarra jilkulunyurru nyurralu, warrkamu jarrulunyurru waljaku mayipintiku warnkuku nganarnalukapali. ");
INSERT INTO nna_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Nyarra wanikinyinyi palanga minyirrju wurrarniyirninyurraku, “Warrkamuwayikatarrangu mayiku jamilkulunyurrujaninyi.” ");
INSERT INTO nna_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Wurrarniyinganaku jintalu, nyurranga jinta munu warrkamu jarrinyakayi. Yani-yaninyayijanaku jintamilikarti ngurrakarti, muwarr yimpin-yimpinakata. ");
INSERT INTO nna_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Nyungu muwarr Nyampalija Jesus Christ-ja wurrarnayirnijanaku palarrangungu marrngurrangungu minyirrju: “Minyirr jarrayi! Warrkamu jarrayi yija mayipinti warnku waljaku!” ");
INSERT INTO nna_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Yuu, wiyirrja nyurranga wurrarnayirninyurraku nyungu: Purnku-purnku karrinyawayi, yirnkulu jinarrayi. ");
INSERT INTO nna_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ngurnipali jintalu nyurralu, nyungungu mirli-mirlingi yakal malkulunyurrunganaku. Yini malayijaninyi palarrangu marrngurrangu. Munu kululkulunyurrujaninyi palajun jinakatarrangu. Palajunjalu jana yija kurntanyja wantulupiyarningu. ");
INSERT INTO nna_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Munu yukuny pilkulunyurrujaninyi. Jana Nyampali Jesus-milirrangu pukun nganyjurrukapalingarra. Palajunjalu jinulu wurralkulunyurrujanaku kurlujartiny jirniyi, jurti jilkulunyurrujanaku yirnkuku jinaku. ");
INSERT INTO nna_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Jesus-ju nganyjurrumilalu Nyampalilu ngayiny ngalypa jirninganyjurrinyi. Japirr marnayirninyurraku, palinyju ngayiny ngalypa jilkulunyurrinyi ngarramarnti. Japirr marnayirninyurraku, nyurranga paliny wantulunyurraku ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Nyungungarra milyanga ngajulu Paul-ju yarntarnarnanyurraku parirrju ngajumilalu. Yakujunngarra yarntarnarna milyanga mirli-mirlingarrangu ngajumilirrangu wiyirrja. ");
INSERT INTO nna_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Japirr marnayirninyurraku Jesus Christ nganyjurrumili Nyampali, ngalypalu tukulu kalkulkulinyurrinyi palinyju. Jipi. ");
INSERT INTO nna_vpl VALUES ("T13_2","084_3_2","1TI","3","2","3","Kurijin nyampali nyarra wantuliny yija yiji kurlumajirri. Paliny yija yirti kaniny marrngu wantuliny, paliny nyampali waljaku palinykungarra...munu yawurrkata,...munu kulikata... ");
INSERT INTO nna_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Ngarrkanga yirnkulu yijalmarta jininyalu nganyjurrulu. Palajalu Ngarrkalu Ngalypakata yinyanganyjurrinyi palinymili Pirlurr, yija yiji kurlumajirri paliny. Nyarra Pirlurr Ngarrkaja nganyjurrungu kawungu wantuliny ngarramarnti. Munu wirntikata jinanganyjurrinyi. Munu kurntanykata jinanganyjurrinyi. Yirnkuku ngarlu nyinga marnanganyjurrinyi Ngarrkamilija muwarrja jinaku. Ngarlu nyinga marnanganyjurrinyi ngarlungu jinaku Ngarrkapa marrngurrangu pukun wiyirr. Ngarlu nyinga marnanganyjurrinyi ngalypa jinakupa kurluku yakanaku pukun. ");
INSERT INTO nna_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Kurlkarri mala nyarra wurrarnarnangu, marrngurrangu kurluny-kurluny yija yiji jarrulupiyi. Marrngurrangu wantulupiyi ngampankata, lirrjalkata warnkuku, nyurra-nyurrakata, rakakata, nyurni manakata, panypanyakata pipi japartuku, munu puntaju yinganyakata, wirntimajirri Ngarrkaku; pajuwayikata, yukuny pinakata, jintaku mitu yimpinakata, rirra kararrkata, kulikata, malyparrkata ngalypaku, mitulu kuku jarrilu jinayi marrnguku kurlu pinaku, turrpalu kurlujartinyju jinakata, munu kurlkarri malkulupiyi nganipa jarruliny puntaju, wirtu-wirtu jarrinyakata; pikaly jinayarninyi janalujakun, munu Ngarrka ngarlungu jinakayiyarningu; Kurijinkapalirrangu mitukata wantulupiyi, munumpa wantulupiyi Ngalypakataku Pirlurrku, palinyju Kurijinarrangu ngarlu yirnkukata jinajaninyipa kurlujartinyku karrkanaku jinajaninyi. Munu yiji kulunaku marrngurrangu nyarrarrangu kurlujartiny jinakatarrangu. ");
INSERT INTO nna_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","...Kurijin nyampali...yija yiji, munu nyurra-nyurrakata wantuliny, munu pipurru wirrilyakata, munu yawurrkata, munu kulikata, munu warnkuku lirrjalkata. ");
INSERT INTO nna_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Christian-arrangulu miranu jarrinyaku yirnkumilaku muwarrkupa ngalypalu warrkamu jilkulupiyi ngarramarntilu. Munu puru kajan-kajanaku watapirti. ");
INSERT INTO nna_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","2","Kurrngalju purlpijalu marrngurrangulu parrjarnayinganyjurrinyi. Palajunjalu parnpina wirrilkunyijaninyi nganin-nganin nyarra jinu jinanganyjurrinyipa jurtuku jinaku, nyarra kurlujartinyjurrangu pukun karrpa-karrpa warlirnayinganyjurrinyi. Nganyjurrulu yajalkunyi Jiyijaji jalypalu, kurlkarri malkunyi palinyngarra ngarrakunyju. Palinyju walangkarranguja jipikartijakun Ngarrkanga yijalmartaku jinanganyjurrinyi yijalu. Marlkarri jarrinyaku nayilamu jinajalu kanka mungkanga kurntany yija yiji. Jiyijaji miranungarra palaku, paliny munu purlu jarrima, kurlkarri marnikinyi yarti Ngarrkalu pikaly yiji jilkuliny, nyarra kurntany puru yakarna. Kuwarri kajaninyi wangka yiji Ngarrkanga. ");
INSERT INTO nna_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","15","Kurlkarri mala, ngarnurtulupa karrinyi kurlujartiny jinaku, munu yiji palinyju karra malkuliny, “Ngarrkalu kurlujartinyku jinaku yakurr marnanyi.” Munu nganurtulupa yakurr marnaka Ngarrka kurlujartiny jinaku, Ngarrkalungarra munu yakurr malkuliny ngarnurtupa kurlujartiny jinaku. Nganyjurrulungarra waljalu karrinyanyi kurlujartiny jinaku ngarramarntilu, kurlkarri manajalu yakurr marnanganyjurrinyi palangarra kurlujartiny jinaku. Palajunmarta yirrkulu kurlujartiny jinaja nganyjurru marlkarri jarruluminyi. ");
INSERT INTO nna_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","8","Wurralala Ngarrkanga, “Nganikupa karrinyajin jinaku, palangarra jilamarnangu nyuntuku.” Ngarntanaku Mirurruku Wirtuku, mirti jarrulumangalu. Wangka jarra Ngarrkanga, paliny wangka jarrulumangu nyuntungu... ");
INSERT INTO nna_vpl VALUES ("P11_18","090_1_18","1PE","1","18","19","Nyurramilirrangulu walangkarrangujalu kurlujartiny jinikinyiyi, palajun nyirrirnikartijalu yakurr marnayijaninyi. Palajunngarra nyurra pukun waninyikinyinyurru. Nyurra miranu nyarra warajaku, Jiyijaji Kurayijiku, marrngurrangulu marlkarri wirlarniyi. Janalu palinyja palajun jinajalu, paliny ngapikapali jarrinyi, kukurnjari wupartukapali jarrinyi, nyarra kukurnjari purrpurn yiji, wurrkumajirripa pitamajirri, purlpilu kurlujartiny jinajalu marrngurrangulu, marlkarri wirlarnikinyiyi kukurnjari, wurrarnikinyiyalu Ngarrkaku, “Kurlujartiny jinirni. Palajunjalu nyungu wirlarnarna kukurnjari, puntaju ngaju munu wirlalaminyinkurra palaku kurlujartinyku, puru ngakalaminyin.” Jiyijaji Kurayiji nyarra kukurnjarikapali jarrinyinganyjurruku. Wirtu yiji jininganyjurruku, nganyjurrumili Nyampalingarra marlkarri jarrinyinganyjurruku! Jayitanju munu warlirnakanganyjurrinyi, kuwarringulu Jayitan munu nyampali nganyjurruku! Jiyijajilu kartuwarra marnanganyjurrinyi, warajamalngarra jirni wiyirrku marrngurranguku ngarramarnti. Palajunjalu minyirrju yijalu yiji kurlkarri malkulunyurru paliny, wirntilu pukun. ");
INSERT INTO nna_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","Jungkanga waninyaja Christ parlparrkarti yana. Palanga Ngarrkanga kajaninyi marrjanyukarti. Palinyngarra wirrirni Ngarrkalu nyampali wirtu angel-arrangukupa nyampalirrangukupa, jungkangapa parlparrja, wiyirrku nyarrakurnujirri. ");
INSERT INTO nna_vpl VALUES ("P14_1","090_4_1","1PE","4","1","5","Jungkanga Christ kurluny-kurlunyja wirrirnikinyiya. Munu ngampa pinamajaninyi. Palaja palajun kurlkarri malayi Christ-kapali, nyurralu! Kurluny-kurlunyja waninyajanga nyurra kurlu jinajamajirri, nyurraku miranu wantulupiyi warinyarrangu, nyurralu jipi kurlu yakarnanyurru ngarramarntilu. Kuwarringulu wantulinyurru nyungungu jungkanga Ngarrkamilingi nganirrangupa jilkulinyurru, munu nyurramilingi waljanga jilkulinyurru. Nyurralu jipi kurluny-kurluny yakarnanyurru nyarra purlpilu jinikinyinyurrupa nyarrarrangukapali Ngarrkamajirrirrangukapali. Nyurralu nganiwarralpirti kurntanymajirrilu jinikinyinyurru, kurla-kurlaku kurlkarri marnikinyinyurru, yawurr jarrinyikinyinyurru, ngananyikinyinyurru lirrjalju kuwiyipa mayi wirtu, kurlujartinyju yikarnikinyinyurrarningu, nyurralu marni pinaja mirurrukapali mangunyarrangu, ngayinyja nyurra marnikinyinyurrujaninyi, Kuwarri Ngarrkangalu panypanyakatarrangulu japirr manayinyurrinyi yarrana palajun jinaku, palarrangu kurlujartinyarranguku turrpa-turrpalu jinakata. Munu jinajalu nyurnpaly jarrulupiyinyurraku. Yartikala Ngarrkalu japirr malkulinyjaninyi, pirlpalkulinyparninyi nganirrangu nyarra kurlujartinypa jinikinyiyi palarrangulu marrngurrangulu. Muwarr yungkulinyjaninyi ngungku yiji wankarrangupa marlkarrinyjarri. ");
INSERT INTO nna_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","Mintu wantayi! Parrjarn-parrjarnarra! Pala mirurru yukuny-yukunykata nyurraku. Pala wirtu kuwiyi, ngapi, yini layin pala, ngarurr-ngarurr karra manakata, marnti yananyi kuwiyi ngananyaku kanyjin-kanyjininya. Palakapali marnti yananyi Mirurru Wirtu kanyjin-kanyjininya marrnguku warlinakanu mujujakapaliku jinaku. ");
INSERT INTO nna_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","Tarn-tarn wantayi, kakuputulu yijalmarta jilayili Ngarrkanga. Mirurru ngarntarn-ngarntarnarra! Jintaku miranu nyurra, Ngarrkanga yijalmarta jinakatarrangu ngunarrijirringi yajarri kurlungungarra nyurrakapali. ");
INSERT INTO nna_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Nyungungarra muwarr wurrarnanganyjurruku palinymilalu partanyju, nganarnalu kuwarri wurrarnayirninyurraku nyurranga: Ngarrka kurlumajirri yija yiji, yija yiji paliny ngalypakata ngarramarnti. ");
INSERT INTO nna_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Ngurnipali nganyjurrulu wurralanyili, ngalypangakapali waninyanyi Ngarrkanga, kurlujartiny pukun jinanyi. Palajun jinajalu nganyjurrulu mitu wurrarnanyi, munu jinanyi Ngarrkamilija muwarrja. ");
INSERT INTO nna_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Jampa waninyanyi kurlumajirri, palinykapali kurlumajirri waninyi, pikaly yiji jarruluminyi warajanga, palajunjalu palinymilalu partanyju Jiyijajimilalu pijirrilu janpa jinanganyjurrinyi wiyirrja kurlujartinyja nganyjurrulu jinaja. ");
INSERT INTO nna_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Yijapa nganyjurrulu wurralanyarninyili nganyjurru kurlujartinymajirri, yija yiji mitu marnayinyarningu nganyjurrulu waljalungarra, yijalu jurtu wurrarnakanyi. ");
INSERT INTO nna_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Jampa wurrarnanyili Ngarrkanga kurlujartiny jinanyi, yijakata paliny, jilkuliny palinymilija muwarrja, jurtulu jilkuliny: puru yakalkulinynganyjurrinyi kurlujartiny jinaja, janpa jilkulinynganyjurrinyi wiyirrja kurlujartinyja jinaja nganyjurrumilija. ");
INSERT INTO nna_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","Palanga wantuliny warrukurlamajirri, Ngarrkalungarra pirrpa jilkuliny wiyirr, janyjamajirripa lampumajirri. Nyarrarrangu yijalmarta jinakatarrangu wirtukapali nyampalikapali wantulupiyi ngarrakuny. ");
ALTER TABLE nna_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
