﻿USE sofia;
DROP TABLE IF EXISTS sofia.nmws_vpl;
CREATE TABLE nmws_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nmws_vpl WRITE;
INSERT INTO nmws_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeisu Keriso hana tubu lihuine sohode ti ya. Yeisu Keriso iye Deivid tubutubuine, Deivid iye Eibraham tubutubuine. ");
INSERT INTO nmws_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibraham natune Aisak, Aisak natune Jeikob, Jeikob he-nanatune Juda ge he-hauhavane, ");
INSERT INTO nmws_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda he-nanatune Peres ge Jera, tinadiye Tama, Peres natune Hesron, Hesron natune Ram, ");
INSERT INTO nmws_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram natune Aminadab, Aminadab natune Nason, Nason natune Salmon, ");
INSERT INTO nmws_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon natune Bowasa, tinane iye Reihab, Bowasa natune Obeda, tinane iye Rut, Obeda natune Jesi, ");
INSERT INTO nmws_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi natune Kin Deivid. Deivid natune Solomon, tinane gane iye veto Uraiya poniyene, ");
INSERT INTO nmws_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon natune Rehobowam, Rehobowam natune Abaija, Abaija natune Asa, ");
INSERT INTO nmws_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa natune Jehosefet, Jehosefet natune Jehoram, Jehoram natune Usaiya, ");
INSERT INTO nmws_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya natune Jotem, Jotem natune Ahas, Ahas natune Hesekaiya, ");
INSERT INTO nmws_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaiya natune Manasa, Manasa natune Eimon, Eimon natune Josaiya, ");
INSERT INTO nmws_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiya he-nanatune Jehoyasin ge he-hauhavane, saugeine Babilon si luwom si yawanid Juda ge si yomoteiid Babilon. ");
INSERT INTO nmws_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Si yawanid Juda ge si yomoteiid Babilon he muine: Jehoyasin natune Seyaltiyel, Seyaltiyel natune Serababel, ");
INSERT INTO nmws_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel natune Abiud, Abiud natune Elayakim, Elayakim natune Eiso, ");
INSERT INTO nmws_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eiso natune Jeidok, Jeidok natune Akim, Akim natune Eliud, ");
INSERT INTO nmws_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud natune Eliyesa, Eliyesa natune Meitan, Meitan natune Jeikob, ");
INSERT INTO nmws_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ge Jeikob natune Josep, Meri mwaniyene. Meri i hab Yeisu, iye ta nga Mesaiya. ");
INSERT INTO nmws_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iye te heine Eibraham hana had Deivid ta paidi sai ge sai wedi hohoyowate potin (14), Deivid hana had sauge gane si yomoteiid Juda Babilon sai ge sai wedi hohoyowate potin (14), ge sauge ga yake hana had Mesaiya i youmate sai ge sai wedi hohoyowate potin (14). ");
INSERT INTO nmws_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yeisu Keriso wana youmate sohode ti ya. Tinane Meri bwaine ge Josep si kaukauwaroru. Taine habe si dehaduwe, si paidi Meri hobak i matabuwon Yayaluwo Gagabubine wana gaisi heine. ");
INSERT INTO nmws_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep wana page i dohob ge taine nuwane i depamwadine-yan Meri boda he matadiye, iloke i nuwotu tage wedi kaukauwaroru i elake sumo. ");
INSERT INTO nmws_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","I nunuwotu sohode ti yo, habe he wana heneluluwo Guyau wana anelose i youmate heine ge i nga, “Josep, Deivid tubune, tab u ematok u howo Meri poniyem, kaiwane wana matabuwon i luwom Yayaluwo Gagabubine heine. ");
INSERT INTO nmws_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bwele i hab natune tolomo, ge hidane u tin Yeisu, kaiwane bwele i pwamwadid wana bobode he wedi gegi.” ");
INSERT INTO nmws_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","I youmate sohode ti yo, iloke Guyau wana lihu gane profet hotiya i payoumate i tabwa tolosuwok, ");
INSERT INTO nmws_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","i nga, “Hehoi tan i delotolomo benan habe i matabuwon ge i hab natune tolomo, iloke hidane si tin Imanuwel.” Imanuwel hana sapu te “Helak iye bwaide.” ");
INSERT INTO nmws_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sauge Josep i hene suwoyuk, bwen i hadaenge Meri sohode Guyau wana anelose wana lihu heine. ");
INSERT INTO nmws_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Agegene taine bwaine si dehene toyao hana had i hab natune tolomo. Bwen Josep i tin memai hidane Yeisu. ");
INSERT INTO nmws_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeisu si hab Betlehem, Judiya wana ganahao, saugeine Herodi iye wedi kin. Habe tosibe-yan si sehudi natek si dom Jerusalem, ");
INSERT INTO nmws_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","si tayak si nga, “Memai gane si hab tage Judiya wedi kin iye igohoi? Hana hetutuhi sinanane ha hite paidi natek, iyete ha luwom ge nuwamai ha la ha kululu heine.” ");
INSERT INTO nmws_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sauge Kin Herodi i longe wase ya i nunuwotu nabi kaiwane, sohode hedi Jerusalem hana tomiye bwabwaligadiye. ");
INSERT INTO nmws_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","I gon paseid topowo lalahine ge Logugui hana topapalapu ge i tayakid i nga, “Mesaiya bwele si hab igohoi?” ");
INSERT INTO nmws_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Si liwo si nga, “Betlehem, he Judiya wana ganahao, kaiwane profet i leli sohode ti ya: ");
INSERT INTO nmws_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Humiu Betlehem, Judiya wana ganahao, tan bosowane ta deliwo hidamiu taine i dekai Judiya hana todedei-yan he gamwadiye, kaiwane todedei hotiya benan habe i youmate he gamwamiu iloke i matahasikid lo bobode Isrel.” ");
INSERT INTO nmws_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Habe Herodi i liwo tosibe-yan si luwom he-bwaine si lihu sumo, bwen i tayakid se sauge suwok sinanane ya i youmate. ");
INSERT INTO nmws_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Habeto i patileid si la Betlehem, i nga, “Hu la gen hu luweniyan vetahe memai. Sauge hebe hobak hu paidi, hu luwom lo wase hu giyau, iloke nau hedi a la a kululu heine.” ");
INSERT INTO nmws_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Tosibe si longe kin halingane bwen si dodogan hedi, habe sinanane gane si paidi natek si paidi hedi. Ge sauge si paidi, si yariyae nabi suwok. Bwen sinanane i dedeiyanid hana had i manao he yawan pwatane, gane memai i miye heine. ");
INSERT INTO nmws_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Habe si la si setuk he guwole ge si paidi memai bwaine tinane Meri, bwen si lipwakoko ge si kululu heine. Wedi gogomwau hana nabo si tate habe wedi mulolu si giyau heine, gold, frenkinsens ge enunu gane hidane meya. ");
INSERT INTO nmws_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Heneluluwo heine Helak i liwo heidiye tab si esehavile Herodi heine, ge habe si selok he hiyede mwage hotiya si la he habadiye. ");
INSERT INTO nmws_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sauge tosibe si yogo, habe Josep he wana heneluluwo Guyau wana anelose i youmate heine ge i liwo i nga, “Herodi bwele i luweni memai nuwane i tagapamate. U suwoyuk, memai bwaine ge tinane u sehapeid ge hu iwowo hu la Ijip. Iloke gen hu miyemiye te he yake, hana had a liwo, habeto hu sehavile.” ");
INSERT INTO nmws_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Habe Josep i suwoyuk, memai bwaine ge tinane i sehapeid bwen gogou si yogo si la Ijip, ");
INSERT INTO nmws_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ge si miyemiye te he yake hana had Herodi i mate. I youmate sohode ti yo, iloke Helak wana lihu gane profet hotiya i payoumate i tabwa tolosuwok, i nga, “Natu a gon-an i setagi Ijip.” ");
INSERT INTO nmws_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sauge Herodi i lapu age tosibe si yokapisi-yan, bwen i huge suwok. Habe i patileid wana tosagiyau ge bubuyese bobode he Betlehem ge hana ganahao bwabwaligane, hebwaden wedi bwaime ho-iwo ge i sedau, si tagapamateid. I gorugoru sauge gane i lapu tosibe si lihuyan ge sinanane i youmate. ");
INSERT INTO nmws_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","I youmate sohode ti yo, iloke Jeremaiya wana lihulihu i tabwa tolosuwok, i nga: ");
INSERT INTO nmws_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Halhalinge hotiya si longe he Rama hei, tantan nunuwongakine suwok. Reitsel i tan he-nanatune kaiwadiye, i boleu si payariyae nuwane, kaiwane hobak taine hedi si degan. ");
INSERT INTO nmws_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wedi miyemiye he yake hana had Herodi i mate, bwen he Ijip hei Guyau wana anelose i youmate Josep he wana heneluluwo ");
INSERT INTO nmws_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ge i nga, “U suwoyuk, memai bwaine ge tinane u sehapeid ge hu sehavile Isrel wana ganahao, kaiwane gane nuwane memai i leme hobak i mate.” ");
INSERT INTO nmws_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bwen Josep i suwoyuk, memai bwaine ge tinane i sehapeid ge si sehavile ganahao Isrel. ");
INSERT INTO nmws_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Agegene sauge i longe Akeleyas i tabwa kin he ganahao Judiya, i milase tamane Herodi habane, bwen Josep i matok lok te he hiyebe yake. He wana heneluluwo Helak i liwo heine, bwen i lok he ganahao Galili, ");
INSERT INTO nmws_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ge i la i miye he hiyebe Nasaret. I youmate sohode ti yo, iloke profet wedi lihu Mesaiya kaiwane i tabwa tolosuwok, si liwo, “Benan bobode si nga iye gagama Nasaret.” ");
INSERT INTO nmws_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sauge yake Jon Tobaptais i luwom ge i papalapu he hiyebe kevekeveine Judiya he wedi huyahai gamwane. ");
INSERT INTO nmws_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","I nga, “Hu seyok lemi page ngakngakine, kaiwane Helak wana bagalogugui hana sauge hobak i sepasepase.” ");
INSERT INTO nmws_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon lihuine te profet Aiseya i lihuyan saugeine i liwo i nga: Tolomo hotiya ti yo i gongon he huyahai kevekeveine, i nga, “Guyau wana hiyede hu lovivine-yan, ge hu pasapu.” ");
INSERT INTO nmws_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon hana kaliko iye kaliko gane si ginawi he kamel pupululune ge kiviline hana pan si ginawi he bulumwakau dimwene. Nahane iye kimbi ge giwo gane he huyahai. ");
INSERT INTO nmws_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bobode si luwom heine si hudi Jerusalem, si hudi Judiya he wana ganahao bwabwaligane, ge hiyebe bwabwaligane hebwaden si miye he bwai Joden hadidine. ");
INSERT INTO nmws_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Si waseyan wedi gegi iloke i pabaptaisid he bwai Joden. ");
INSERT INTO nmws_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Boda Farisi ge boda Sadiusi si hoyowate i paidiid si eluwom tage i pabaptaisid, bwen i liwo heidiye i nga, “Humiu sohode mwate! Sega i liwo heimiu ge nuwamiu hu iwowoyan Helak wana pepelase gane i eluwom? ");
INSERT INTO nmws_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hebe tolosuwok hobak hu seyok lemi gegi, gen hinone i youmate he yawedimiu. ");
INSERT INTO nmws_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tab hu enuwotu tage hu nga, ‘Hamai tubumai Eibraham, hamai Helak wana hasehase bobodeidiye!’ A liwo heimiu, Helak bosowaine i yomoid pak ya ge i ginawiid Eibraham he-tutubune. ");
INSERT INTO nmws_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hobak i lovivine-yan wana kelumo ge bwele i gotem hubwahi hewasidiye ge si mabwin. Hubwahi bwabwaligane hebwaden hinodiye taine i dedohob bwele i gu yokid ge i yomo tukanid he hiwo.” ");
INSERT INTO nmws_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Habe Jon i liwo i nga “Nau a pabaptaismiu he bwai, kaiwane hobak hu seyok lemi page ngakngakine. Agegene gane i eluwom he muiu, iye hidane i kai, nau hidau taine i dekai. Nau taine lo dohob i degan ge tage bosowau a delohowo hehene hana pase. Iye habe i pabaptaismiu Yayaluwo Gagabubine heine ge he hiwo. ");
INSERT INTO nmws_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wana sabol mwage i bwangehasik he nimane, hawesine bwen i etelipune wana wit hinone bwaine ge dimwene i ehase, iloke habe hinone suwok i yomotei he hana bagayomotei, ge dimwene i ton he hiwo gane tan sauge hotiya i edebuwode.” ");
INSERT INTO nmws_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Saugeine yake Yeisu i hudi Galili i la he bwai Joden, bwen i liwo Jon heine i nga, “U pabaptaisau.” ");
INSERT INTO nmws_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Agegene Jon nuwane i pi Yeisu wana nuwotu, ge i nga, “Akum huwo te u pabaptaisau. Mwatan ge u luwom heyau?” ");
INSERT INTO nmws_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeisu i golase halingane i nga, “Sauge ya gen ta ginawi sohode lo nuwotu. Hebe ta ginawi sohode, bwele Helak wana nuwotu ta paololek.” Habeto Jon i taem. ");
INSERT INTO nmws_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon i pabaptais Yeisu bwen Yeisu i gaesai he bwai. Ge sauge yake bulubulu i mwapwe ge Yeisu i paidi Helak Yayaluwane sohode lumlum i sesedau ge i luwom heine. ");
INSERT INTO nmws_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bwen hahalinge hotiya i dom he bulubulu i nga, “Ga yetei iye natu nunuwaneine; a yariyae suwok iye kaiwane.” ");
INSERT INTO nmws_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bwen Yayaluwo Gagabubine i pagolok Yeisu i la he huyahai kevekeveine ge bwele Seitan i hamnohon Yeisu. ");
INSERT INTO nmws_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yan ho-epak ge gogou ho-epak Yeisu i palahasik hana buwota ge i hauhawanun, habeto i buwota. ");
INSERT INTO nmws_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bwen Seitan i luwom heine ge i hamnohon i nga, “Hebe tolosuwok huwo Helak Natune, u golok pak ya heidiye iloke si tabwa haga.” ");
INSERT INTO nmws_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yeisu i golase halingane i nga, “Buk Bwabwalene i liwo, ‘Taine tage bobode haga hohowane si han ge yawedidiye i gan, agegene lihu bwabwaligane gane i hudi Helak he hawane si longe bwen yawedidiye i gan.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Habeto Seitan i sehape Yeisu si la Jerusalem, hiyebe bwabwalene, ge i pamidi he Guwole Gagabubine pwatane suwok. ");
INSERT INTO nmws_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bwen i liwo heine i nga, “Hebe tolosuwok huwo Helak Natune, u kolapis dau, kaiwane Buk Bwabwalene i liwo: Helak bwele i liwo wana anelose heidiye si matahasikiwo, si bwangehasikiwo he nimadiye, iloke tan hehem hotiya bwele u depatupe he pak.” ");
INSERT INTO nmws_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeisu i golase halingane i nga, “Buk Bwabwalene i liwo hedi, ‘Tab u ehamnohon Guyau lam Helak.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Habeto Seitan i sehape Yeisu hedi si la he bobokun mimisaiine suwok ge i patohe heine bagalogugui bwabwaligane he panayawi ge hana gogomwau. ");
INSERT INTO nmws_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bwen i nga, “Bigibigi bwabwaligane yake bwele a giyau heim, hebe u lipwakoko ge u tabayaoyao heyau.” ");
INSERT INTO nmws_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yeisu i golase halingane i nga, “U seyokau, Seitan! Kaiwane Buk Bwabwalene i liwo, ‘U tabayaoyao Guyau lam Helak heine, iye i totiya ege te u tapwalolo heine.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Habeto Seitan i seyok Yeisu, bwen anelose si luwom ge si matahasik. ");
INSERT INTO nmws_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sauge Yeisu i longe Jon wasane te hobak si hotei he dibula, bwen i sehavile i la Galili. ");
INSERT INTO nmws_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Taine i demiyemiye Nasaret, age i la i miye Kapeniyam, yawan hotiya he Soge Galili hadidine, mwage hun Sebuloni ge hun Naftalai he wedi ganahao. ");
INSERT INTO nmws_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","I youmate sohode ti yo, iloke profet Aiseya wana lihulihu i tabwa tolosuwok, i nga: ");
INSERT INTO nmws_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Hun Sebuloni ge hun Naftalai he wedi ganahao, gane soge he hana hiyede, he ganahao gane bwai Joden kimwene natek, ge he Galili, gane hebwaden taine Judiya bobodeidiye sohode si hoyowate si miye hei: ");
INSERT INTO nmws_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","bobode si miyemiye he gogou bwen si paidi wayae lahine, si miyemiye he mate gogouine, bwen wayae i pawayaeid. ");
INSERT INTO nmws_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Saugeine ga yake Yeisu i telipune i papalapu i nga, “Hu seyok lemi page ngakngakine, kaiwane Helak wana bagalogugui hana sauge hobak i sepasepase.” ");
INSERT INTO nmws_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeisu i dodogan Soge Galili he hadidine habeto i paidiid tologi si he-iwo, bwaine havane, hotiya Saimon gane hidane Pita ge hotiya Andru. Si howo wedi waimu ge si logilogi he soge. ");
INSERT INTO nmws_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Habeto i liwo heidiye i nga, “Hu luwom hu dumuyai heyau, iloke a palapumiu ge humiu hu tabwa bobode hedi tologi.” ");
INSERT INTO nmws_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Petaege si seyok wedi waimu ge si dumuyai heine. ");
INSERT INTO nmws_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","I dodogan hedi habe bobode si he-iwo hedi i paidiid, Jems Sebedi natune bwaine ge havane Jon. Bwaidiye tamadiye Sebedi si miyemiye he wage, si lolovivine wedi waimu. Yeisu i gon heidiye, ");
INSERT INTO nmws_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","bwen petaege si seyok wedi wage ge tamadiye ge si dumuyai heine. ");
INSERT INTO nmws_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeisu i sebayavin-an Galili hana ganahao bwabwaligane, ge i papalapu he Judiya wedi guwole tapwalolo, i papalapu-yan Helak wana bagalogugui wasane dodohobine, ge bobode hedi bole ge hedi gide tomase ge tomase i pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Si pareru wasane Siriya wana ganahao bwabwaligane, bwen bobode wedi bole tomase ge tomase bwabwaligane si bigi luwom heine, hebwaden tuwadiye si yabwatitilao, hebwaden yayaluwo bikbikine si setuk heidiye, hebwaden si kikiwosi ge hebwaden si mwalomwalo, bwen i pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Boda lahine si sedumuyai, si hudi ganahao Galili, ganahao Dekapolis, ganahao Judiya, panautume Jerusalem ge ganahao gane bwai Joden kimwene natek. ");
INSERT INTO nmws_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeisu i paidiid boda i lok i la i tihe he bobokun ge i tuwodau. Bwen wana topadavae-yan si luwom heine ge si mipase, ");
INSERT INTO nmws_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","habeto hawane i pwe ge i telipune papalapu heidiye i nga: ");
INSERT INTO nmws_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Hebwaden si lapu si gulegule-yan yayaluwo, Helak i muloluyanid, kaiwane Helak wana bagalogugui hobak i miye heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hebwaden si tantan Helak i muloluyanid, kaiwane bwele i payariyaeid. ");
INSERT INTO nmws_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hebwaden si hodonge totodiye Helak i muloluyanid, kaiwane wana liwo tuwoi hiyebeine bwele si paidi. ");
INSERT INTO nmws_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hebwaden si buwota ge si mwaiwom page sapusapuine kaiwane, Helak i muloluyanid, kaiwane yayaluwadiye bwele i pasusuwokuid. ");
INSERT INTO nmws_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hebwaden si hatatilao-yanid hene-bwaidiye Helak i muloluyanid, kaiwane bwele i hatatilao-yanid. ");
INSERT INTO nmws_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hebwaden hatiyediye i wayae Helak i muloluyanid, kaiwane bwele si paidi Helak. ");
INSERT INTO nmws_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hebwaden si kaiwoyan mimalum Helak i muloluyanid, kaiwane bwele i liwo i nga, “Sidiye he-nanatu.” ");
INSERT INTO nmws_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hebwaden si patilaoid kaiwane Helak hawane si hab, Helak i muloluyanid, kaiwane Helak wana bagalogugui hobak i miye heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Hebe bobode si hawa ngakngak-anmiu, si patilaomiu ge wasamiu si wase panpangek-an kaiwane hu dumuyau heyau, Helak i muloluyanmiu. ");
INSERT INTO nmws_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hu yariyae suwok, kaiwane maisamiu lahine mwage he bulubulu. Profet hebwaden veto si patilaoid sohode hedi ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Humiu lemi kaiwo he panayawi sohode soge wana kaiwo. Agegene hebe soge wana gaisi ge hamnane i mwao, taine bosowaine ta depasogesoge hedi. Hobak taine wana kaiwo i degan hedi, bwen ta bili yok iloke bobode si pedongedonge. ");
INSERT INTO nmws_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Humiu sohode wayae he panayawi. Hebe hiyebe hotiya si ginawi he bobokun pwatane, bwele bobode hohoyowate si paidi. ");
INSERT INTO nmws_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Taine sauge hotiya bobode si edeton lampwa ge si edeho pwahem donge he huye. Agegene si hotei he tebol pwatane, iloke wayae i giyau guwole yake hana tomiye bwabwaligadiye heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Humiu hedi lemi wayae gen i tale bobode heidiye sohode ti yo, iloke si paidi lemi ginawi dodohobine ge Tamamiu he bulubulu hidane si tobalan. ");
INSERT INTO nmws_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tab hu enuwotu tage a luwom Moses wana Logugui ge profet wedi papalapu bwele a elake yokid. Taine a deluwom tage a delake yokid, age a luwom a patolosuwokid. ");
INSERT INTO nmws_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tolosuwok a liwo heimiu, hana had bulubulu ge panayawi si mwao, taine Logugui hana lihulihu tankai hotiya bwele i dehao hana had bwabwaligane i tabwa tolosuwok. ");
INSERT INTO nmws_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sega hebe logugui tankai hotiya taine i desenapu-yan ge bobode papaine hedi i palapuid ge si ginawi sohode, bwele hidane i tankai Helak he wana bagalogugui. Agegene sega hebe logugui i senapuyan ge i palapuid bobode, bwele hidane i kai Helak he wana bagalogugui. ");
INSERT INTO nmws_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Farisi ge Logugui hana topapalapu si nga tage sidiye wedi page i sapu, agegene a liwo heimiu, hebe tan lemi page i desapu bitim sidiye wedi page, taine bosowaimiu hu desetuk Helak wana bagalogugui heine. ");
INSERT INTO nmws_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Hobak hu longe Moses wana logugui veto bobode dedei heidiye sohode ti ya, “Tab taurol. Sega hebe i taurol lasene bwele i paidi.” ");
INSERT INTO nmws_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Age nau a liwo heimiu, sega hebe i hugeyan havane bwele lasene i paidi, sega hebe i gopanpangek-an havane hana lihu bwele si pakot, ge sega hebe i liwo i nga, “Kabaleya huwo!” i bosowaine i la hel hiwoine i paidi. ");
INSERT INTO nmws_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Iloke hebe u luwom he Guwole Gagabubine tage lam mulolu u egiyau Helak heine ge habe u nuwopik havam i hugeyaniwo bigi hotiya kaiwane, ");
INSERT INTO nmws_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lam mulolu u hotei he Guwole Gagabubine ge u la bwaim havam gen mangingimiu hu bagavetahe. Habeto u sehavileim ge lam mulolu u giyau Helak heine. ");
INSERT INTO nmws_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Hebe tolomo hotiya i pwatimiwo ge i bwangeiwo hu la he kot, habekik pwapwatim yake gen bwaim hu pasapu he hiyede luwane muyai habe hu sevin he bagakot. Hebe taine, bwele i hoteiiwo jaj heine, habe jaj i pagogiyauiwo pulisiman he nimadiye ge si ho tukaniwo he dibula. ");
INSERT INTO nmws_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tolosuwok a liwo heim, taine bosowaine u desetagi hana had ham vage bwabwaligane u pamaise mwao. ");
INSERT INTO nmws_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Hobak hu longe Moses wana logugui sohode ti ya, “Tab u eganawalan bwaim poniyene.” ");
INSERT INTO nmws_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Age nau a liwo heimiu, hebe sega i hayaoyan vaini hotiya ge nuwane bwaine si hiyene, iye hobak i ganawalan he hatiyene. ");
INSERT INTO nmws_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hebe matam gane he lam hinone i ho pagegiwo, gen u pak yok. I dohob te hebe taine tuwam giniteine hotiya i degan, agegene tab tuwam bwabwaligane si ebigi yok he hel. ");
INSERT INTO nmws_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sohode hedi, hebe nimam gane he lam hinone i ho pagegiwo, gen u gotem yok. I dohob te hebe taine tuwam giniteine hotiya i degan, agegene tab tuwam bwabwaligane si ebigi yok he hel. ");
INSERT INTO nmws_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Moses wana logugui i liwo sohode ti ya, “Sega hebe nuwane i boleu poniyene, dedei gen i leli donge wana boluwo hana sapu wasane, bwen i giyau vaini heine.” ");
INSERT INTO nmws_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Agegene nau a liwo heimiu, hebe tolomo hotiya bwagane poniyene taine i deganawal age i boleu, ge habe vaini yake i haduwe hedi, tolomo wana ngak kaiwane bwen vaini yake i tabwa toganawal. Sohode hedi, tolomo gane i hadaenge vaini seseyokine yake, iye hedi i ganawal. ");
INSERT INTO nmws_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hobak hu longe hedi Moses wana logugui bobode dedei heidiye sohode ti ya, “Tab lam silosilo u elake, age u ginawi sohode lam liwo tuwoi Helak heine.” ");
INSERT INTO nmws_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Agegene nau a liwo heimiu, tab sauge hotiya u esilosilo. Tab u esiloyan bulubulu, kaiwane Helak wana bagamiye ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tab u esiloyan panayawi, kaiwane hehene hana bagahotei ti ya. Tab u esiloyan Jerusalem, kaiwane Kin Lahine habane ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tab u esiloyan kahulum, kaiwane tan bosowaim u deginawi kahulum pupululune hotiya i dekanekane o hotiya i detegetege. ");
INSERT INTO nmws_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iyege te u nga, “Bam” o hebe “Taine.” Sahe hedi u hune i luwom Seitan heine. ");
INSERT INTO nmws_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Hobak hu longe Moses wana logugui sohode ti ya, “Hebe tolomo hotiya i bagapangek bwaine matane hotiya, lasene iye hedi matane hotiya gen si bagapangek. Hebe i tagabebe bwaine ngingine hotiya, lasene iye hedi ngingine hotiya gen si tagabebe.” ");
INSERT INTO nmws_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Agegene nau a liwo heimiu, hebe tolomo hotiya i ginawi ngak heim, tab u epelase. Hebe tolomo hotiya i tagalepe gegelam he lam hinone, u galahaik u giyau gegelam gegebeine heine gen i tagalepe hedi. ");
INSERT INTO nmws_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sohode hedi, hebe tolomo hotiya i hoteiiwo he kot ge tage tuwam hana heyabom i ho, bwen ham kaliko dubedubeine gane tuitui kaiwane gen u taeman hedi heine. ");
INSERT INTO nmws_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Hebe tosagiyao hotiya i ginawi ham logugui tage wana hiyewo u hiyewo hauhawal hewesine i mwalao, gen u hiyewo he hauhawal mwalao. ");
INSERT INTO nmws_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hebe tolomo hotiya i hawanun heim, gen u giyau heine; hebe tolomo hotiya lam bigi i talaiyan, tab u ehahainge. ");
INSERT INTO nmws_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Hobak hu longe tage Moses wana logugui i liwo, “Lam pebwange u nunuwane-yanid, ham siviye u hugeyanid.” ");
INSERT INTO nmws_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Agegene nau a liwo heimiu, hami siviye gen hu nunuwane-yanid, ge hebwaden si patilaomiu gen hu hawanun kaiwadiye, ");
INSERT INTO nmws_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","iloke humiu sohode Tamamiu he bulubulu he-nanatune-yan. Kaiwane i ginawi parae i sai i tale bobode ngakngakidiye ge bobode dodohobidiye heidiye, ge i patile wesi henebwaden wedi page i sapu ge henebwaden wedi page taine i desapu heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hebe hu nunuwane-yanid ege hebwaden gane si nunuwane-yanmiu, bwele mwatan ge Helak i pamaisemiu? Takis hana tohowo si ginginawi sohode hedi ti yo, bwagane sidiye taine bobode dodohobidiye sohode. ");
INSERT INTO nmws_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hebe hu golok he-hauhavamiu ege heidiye, taine i desevevek sohode bobode hohoyowate wedi ginawi. Hebwaden taine togoru-yan, sidiye si ginginawi sohode hedi ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Iyete humiu lemi page bwabwaligane gen i dohob, sohode Tamamiu he bulubulu wana page bwabwaligane i dohob. ");
INSERT INTO nmws_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Sauge hebe ginawi dodohobine hotiya hu pamali, tab hu epampamali bobode he matadiye ge tage ginawi dodohobine yake si epaidi. Hebe humiu hu ginginawi sohode ti yake, Tamamiu he bulubulu taine bwele i depamaisemiu. ");
INSERT INTO nmws_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Iloke sauge hebe bigi hotiya u egiyau togulegule heidiye, tab u egongon dodoganan sohode toyoyokapis wedi page. Sidiye si ginginawi sohode he guwole tapwalolo ge he hiyede, kaiwane nunuwadiye bobode si tobalid. Tolosuwok a liwo heimiu, maisadiye bwabwaligane hobak si howo mwao. ");
INSERT INTO nmws_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Age hebe bigi hotiya u giyau togulegule heidiye, tab nimam gegebeine i elapu nimam hinone wana ginawi. ");
INSERT INTO nmws_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","U ginawi sumwan ege. Tamam bigi bwabwaligane gane u ginawi sumwan i paidi, iloke iye bwele maisam i giyau. ");
INSERT INTO nmws_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sauge hebe hu hawanun, tab hu eginawi pagan sohode toyoyokapis. Sidiye nunuwadiye si talmidi ge si hawanun he guwole tapwalolo ge he hiyede bubusune, kaiwane nuwadiye bobode si paidiid. Tolosuwok a liwo heimiu, maisadiye bwabwaligane hobak si howo mwao. ");
INSERT INTO nmws_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sauge hebe u hawanun, u setuk he rum, hana gane u tagabulim habeto u hawanun Tamam heine, iye taine ta edepaidi. Tamam bigi bwabwaligane gane u ginawi sumwan i paidi, iloke iye bwele maisam i giyau. ");
INSERT INTO nmws_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Sauge hebe hu hawanun, tab lihu bwagebwageine hu egopipiyan sohode hebwaden taine togoru-yan sohode. Sidiye si nuwotu tage Helak hobak i longe wedi hawanun kaiwane wedi hawanun i mwalao. ");
INSERT INTO nmws_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tab hu eginawi pagan sohode sidiye. Habe taine hu dehawanun Tamamiu heine, iye hobak i lapu sahe nuwamiu. ");
INSERT INTO nmws_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iyete hu hawanun sohode ti ya: Tamamai he bulubulu, hidam i gabub gen hamai ha hawatauyan, ");
INSERT INTO nmws_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","lam bagalogugui gen i luwom, lam nuwotu hamai gen ha ginawi he panayawi sohode sidiye si ginawi he bulubulu. ");
INSERT INTO nmws_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yan ya kaiwane nahamai gen u giyau heyai. ");
INSERT INTO nmws_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","U nuwoyok lama gegi, sohode hedi hamai ha nuwoyok hene-bwaimai wedi gegi heyai. ");
INSERT INTO nmws_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tab u ehoteiyai he hamnohon, agegene gen u pwamwadai he gegi. Kaiwane huwo tologugui, huwo togaisi ge huwo towasewase, sauge hohoyowate taine i edemwao. Bam. Sohode. ");
INSERT INTO nmws_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Hebe he-bwaimiu wedi gegi heimiu hu nuwoyok, bwele Tamamiu he bulubulu lemi gegi i nuwoyok hedi. ");
INSERT INTO nmws_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Age hebe he-bwaimiu wedi gegi taine hu denuwoyok, Tamamiu bwele taine i denuwoyok lemi gegi. ");
INSERT INTO nmws_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sauge hebe hu palahasik buwota hawanun kaiwane, tab hemi hao hu epanuwale sohode toyoyokapis. Sidiye hedi hao si panuwale kaiwane nuwadiye bobode si paidiid si palahasik hedi buwota. Tolosuwok a liwo heimiu, maisadiye bwabwaligane hobak si ho mwao. ");
INSERT INTO nmws_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sauge hebe u palahasik buwota, u sawi mangingim ge hulum u paenunu, ");
INSERT INTO nmws_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","iloke tab bobode si elapu te u palahasik buwota. Tamam gane taine ta edepaidi, i totaege te i lapu. Tamam bigi bwabwaligane gane u ginawi sumwan i paidi, iloke iye bwele maisam i giyau. ");
INSERT INTO nmws_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tab hu epase gogomwau he panayawi kaiwamiu, kaiwane he panayawi wada bigi mwatemwate ge pwase si bagapangek, ge tobwahiyewo si setuk ge si bwahawan. ");
INSERT INTO nmws_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Age gogomwau gen hu pase kaiwamiu he bulubulu, kaiwane he bulubulu mwatemwate ge pwase taine bosowaine si debagapangek bigi, ge tobwahiyewo taine bosowaidiye si desetuk ge si debwahawan. ");
INSERT INTO nmws_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Se hiyebe lam gogomwau si miye hei, bwele hatiyem hedi i miye heine. ");
INSERT INTO nmws_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matade sohode tuwade hana suli. Hebe matam i dohob, bwele tuwam bwabwaligane i susuwoku-yan wayae. ");
INSERT INTO nmws_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Age hebe matam i ngak, bwele tuwam bwabwaligane i susuwoku-yan gogou. Hebe wayae gane he yayaluwam i gogou, eu heto gogou hana kai ti yo! ");
INSERT INTO nmws_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Taine bosowaine tolomo hotiya i dekaiwo guyau ho-iwo heidiye. Bwele hotiya i nunuwane-yan ge i hawatauyan, ge bwele hotiya i hugeyan ge i hawatalale-yan. Taine bosowaine hu dekaiwo petaege Helak ge gogomwau heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Iyete a liwo heimiu, tab hu enunuwotu nabiyan yawedimiu kaiwane ge hu nga, “Sahe bwele ha han ge sahe ha mun?” Sohode hedi tab hu enunuwotu tuwamiu kaiwane ge hu nga, “Heto kaliko bwele ha sipo?” Yawed te hana nuwotu i kai, haga hana nuwotu taine i dekai, age? Ge tutuwo te hana nuwotu i kai, kaliko hana nuwotu taine i dekai, age? ");
INSERT INTO nmws_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hu nuwopik manman kaiwadiye, gane si iwowo he hauhawal. Sidiye taine si denamo, taine si dehinhiyen, ge taine si depase haga, age Tamamiu he bulubulu i pahanid. Age humiu hu kaikai, manman taine si dekaikai. Sohode, age? ");
INSERT INTO nmws_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hebe humiu hotiya i nunuwotu yawedine kaiwane, tab bosowaine he wana nunuwotu yawedine hana sauge hewesine i pamwalao? Taine suwok! ");
INSERT INTO nmws_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Sohode hedi, mwatan ge hu nunuwotu kaliko kaiwane? Hu nuwopik mule-yan he huyahai wedi siwi kaiwane. Sidiye taine si dekaiwo, taine hedi kaliko si deseisei. ");
INSERT INTO nmws_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Age a liwo heimiu, kin Solomon wana kaliko, bwagane kaliko dodohobine suwok, taine hana hao i dedohob sohode mule ya hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ilok ta lapu nan he huyahai hedi kaliko Helak i giyau heidiye, yan ya ta paidi nan yake i siwi, agegene beniyan i mate ge si ton he hiwo. Age humiu hami kaliko taine i demigigiyau heimiu hedi? Humiu lemi goru taine i dekai. ");
INSERT INTO nmws_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iyete tab hu enunuwotu ge hu nga “Sahe ha han?” o “Sahe ha mun?” o hebe “Sahe ha sipo?” ");
INSERT INTO nmws_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Hebwaden taine sidiye togoru-yan, sauge hoyowate bigi sohode-yan yake si luweniid. Tamamiu he bulubulu hobak i lapu mwao humiu nunuwamiu bigibigi hebwaden yake. ");
INSERT INTO nmws_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Agegene hu luweni deiyan Helak wana bagalogugui ge page sapusapuine gane iye nuwane, iloke bwele bigibigi hebwaden yake hohoyowate i giyau hedi heimiu. ");
INSERT INTO nmws_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tab beniyan kaiwane hu enunuwotu, kaiwane heto bigi beniyan i youmate heimiu iye beniyan hana puyowo. Yan hotiya ge hotiya hana puyowo i gangan, tab puyowo yake hu eho palahe hedi hei. ");
INSERT INTO nmws_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tab hu ehawa ngakngak-anid hene-bwaimiu, ilok Helak bwele taine i dehawa ngakngak-anmiu. ");
INSERT INTO nmws_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Helak wana hawa ngakngak heimiu bwele sohode lemi hawa ngakngak hene-bwaimiu heidiye. Luvi gane hu ginawi ge hu giyau hene-bwaimiu heidiye, iye te bwele hu howo. ");
INSERT INTO nmws_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mwatan ge u hayaoyan hubwahi sunsunine havam he matane, age hubwahi bwabwaligane iye mwage huwo he matam taine u denunuwotu-yan? ");
INSERT INTO nmws_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hebe hubwahi bwabwaligane mwage he matam, mwatan ge u liwo havam heine u nga, “Hubwahi sunsunine a ho tagan he matam?” ");
INSERT INTO nmws_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Toyoyokapis huwo! Dedei gen u ho tagan hubwahi bwabwaligane huwo he matam, iloke matam i wayae, ge habe bosowaim hubwahi sunsunine u ho tagan havam he matane. ");
INSERT INTO nmws_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tab hu egiyau bigi gabgabubine hehewo heidiye, hebe si tiyepahavile ge si hayakmiu. Tab hu ebili lok lemi bak bobo haodiye, hebe si pedongedonge. ");
INSERT INTO nmws_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Hu hawanun iloke Helak i giyau heimiu; hu luweni iloke hu paidi; hu pitipiti iloke gane i tate heimiu. ");
INSERT INTO nmws_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaiwane sega i hawanun bwele i howo, sega i luweni bwele i paidi, ge sega i pitipiti bwele gane i tate heine. ");
INSERT INTO nmws_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mwatan hebe humiu hotiya natune i hawanun haga kaiwane, bwele u giyau pak? ");
INSERT INTO nmws_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O hebe i hawanun yalogi kaiwane, age bwele u giyau mwate? ");
INSERT INTO nmws_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Humiu, bwagane bobode ngakngakidiye, sauge hohoyowate bigi dodohobine hu egigiyau he-nanatumiu heidiye. Iloke ta lapu vetahe Tamamiu he bulubulu bigi dodohobine bwele i giyau heidiye hebwaden si hawanun heine. ");
INSERT INTO nmws_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Page gane nunuwamiu akum bobode si ginawi heimiu, hu ginawi sohode hedi heidiye. Moses wana Logugui ge profet wedi papalapu sohode ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Hu sesole he bagasetuk kikikipuine. Hel hana bagasetuk i magage ge hana hiyede i meyan, iyete bobode si hoyowate si dodoganan. ");
INSERT INTO nmws_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Age yawed hana bagasetuk i kikipu ge hana hiyede i puyowo, iyete hebwaden si paidi taine si dehoyowate. ");
INSERT INTO nmws_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Hu yehemiu tab topapalapu yoyokapisidiye halingadiye hu elonge. Si luwom heimiu hedi lubluwob sohode sip, si tounuwo, age he yayaluwadiye sidiye sohode hehewo mamalekeidiye. ");
INSERT INTO nmws_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wedi ginawi hinone hu paidi iloke hu lapuid. Siyo greip hinone taine ta edekibo he pipisare, age? Kapoi hinone taine ta edekibo he daudawou, age? ");
INSERT INTO nmws_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sohode hedi, hubwahi dodohobine hinone hamnane i dohob, age hubwahi ngakngakine hinone hamnane i ngak. ");
INSERT INTO nmws_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Taine bosowaine hubwahi dodohobine hinone i dengak, ge taine bosowaine hubwahi ngakngakine hinone i dedohob. ");
INSERT INTO nmws_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hubwahi bwabwaligane hebwaden hinodiye taine si dedohob si ik ge si yok tukanid he hiwo. ");
INSERT INTO nmws_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sohode hedi, topapalapu yoyokapisidiye wedi ginawi hinone hu paidi iloke hu lapuid. ");
INSERT INTO nmws_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Taine tage bobode henebwaden si liwo heyau si nga, “Guyau, guyau” bwabwaligadiye bwele si setuk Helak he wana bagalogugui. Age sega i pabwasowo Tamau he bulubulu wana nuwotu, iye ege bwele i setuk. ");
INSERT INTO nmws_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sauge yan mwaomwaoine i sevin, bobode hoyowate si liwo heyau si nga, “Guyau, guyau, hidam heine ha payoumate Helak wana lihu, hidam heine ha liwo iloke yayaluwo bikbikine si setagi, ge hidam heine ha ginawi pamali yauyawate.” ");
INSERT INTO nmws_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bwele a liwo heidiye a nga, “Tan a delapumiu. Hu leke yokau, humiu ngak hana toginawi.” ");
INSERT INTO nmws_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Iloke sega hebe lo lihulihu ga ya i longe ge i ginawi sohode, iye sohode tolomo gane wana nuwotu i sapu ge wana guwole i pamidi he pak pwatane. ");
INSERT INTO nmws_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wesi i dau lahine, gungun i sali ge yangak i towo gaigaisi he guwole yake, agegene taine i demwabwin, kaiwane hana mwalu i miye he pak pwatane. ");
INSERT INTO nmws_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sega hebe lo lihulihu ga ya i longe ge taine i deginawi sohode, iye sohode tolomo gane taine wana nuwotu i desapu ge wana guwole i pamidi he kelekele pwatane. ");
INSERT INTO nmws_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wesi i dau lahine, gungun i sali ge yangak i towo gaigaisi he guwole yake, bwen i mwabwin, ge wana mwabwin butune i kai. ");
INSERT INTO nmws_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Saugeine Yeisu i gomwao lihulihu ya, bwen boda nuwadiye si hape wana papalapu kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Taine i depapalapu sohode Logugui hana topapalapu-yan, i lihu vetahe ege bwaine ge wana gaisi. ");
INSERT INTO nmws_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sauge Yeisu i hudi he bobokun, boda lahine si dumuyai heine. ");
INSERT INTO nmws_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Toraupoga hotiya i luwom i lipwakoko Yeisu he hana hao, bwen i liwo i nga, “Guyau, hebe nuwam, i bosowaine u bagavetaheyau.” ");
INSERT INTO nmws_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeisu nimane i pamwalao ge i pihasik tolomo yake, habe i nga, “Bam, nuwau. Tuwam i dohob!” Ge petaege hana raupoga i mwao. ");
INSERT INTO nmws_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Habe Yeisu i liwo heine i nga, “Tab tolomo hotiya wana wase u egiyau. Gen u lok u la topowo heine ge tuwam i yeuneyan. Iloke man u howo ge topowo i powoyan Helak heine, sohode Moses wana logugui, iloke bobode si lapu tolosuwok tuwam hobak i dohob.” ");
INSERT INTO nmws_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Saugeine Yeisu i setuk Kapeniyam, Roum wedi tosasagiyao hedi todedei hotiya i luwom Yeisu heine ge i hawanun labe kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I nga, “Guyau, lo tokaiwo mwage i hinhiyene he guwole, tuwane i mwalomwalo ge i tilao suwok.” ");
INSERT INTO nmws_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeisu i liwo heine i nga, “Ta lok ge a la a pamolu.” ");
INSERT INTO nmws_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Todedei i golase Yeisu halingane i nga, “Guyau, tab. Kaiwane nau taine lo dohob i degan ge a deho luwomiwo he lo guwole. U liwo egene, bwen lo tokaiwo i molu. ");
INSERT INTO nmws_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","A lapu bosowaim u ginawi sohode, kaiwane nau a miye lo tonuwakau lalahine wedi logugui he gabulane, ge he gabulau lo tosasagiyao-yan i gan. Hebe a liwo hotiya heine, ‘U lok,’ bwele i lok, ge hebe a liwo hotiya hedi heine, ‘U luwom,’ bwele i luwom. Ge hebe a liwo lo tokaiwo heine, ‘Ga yeya u ginawi,’ bwele i ginawi. Sohedi hedi huwo, bosowaim u liwo ge lo tokaiwo i molu.” ");
INSERT INTO nmws_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sauge Yeisu i longe lihu yake, bwen nuwane i hape, ge i liwo hebwaden si sedumuyai heidiye i nga, “Tolosuwok a liwo heimiu, taine tolomo hotiya a depaidi he Isrel gamwadiye wana goru hana kaikai sohode te tolomo ga yeya. ");
INSERT INTO nmws_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A liwo heimiu, bobode si hoyowate bwele si hudi parae wana bagasai ge wana bagadobiyek, iloke Helak he wana bagalogugui he-bwaidiye Eibraham, Aisak ge Jeikob si tuwodau ge si haga toyao. ");
INSERT INTO nmws_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Agegene Isrel, bwagane tage sidiye bagalogugui bobodeidiye, bwele si yok taganid he gogou, iloke si mitantan ge si sangsangapatad ngingidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bwen Yeisu i liwo tosasagiyao wedi todedei heine i nga, “U sehavile! Bwele a ginawi sohode lam goru.” Ge sauge yake wana tokaiwo i molu. ");
INSERT INTO nmws_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sauge Yeisu i la Pita he wana guwole, i paidi Pita bwatane i hinhiyene, i bole ge tuwane i dayave. ");
INSERT INTO nmws_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","I pihasik nimane bwen tuwane dayaveine i mwao, habeto i suwoyuk i ginawi haga ge i giyau Yeisu i han. ");
INSERT INTO nmws_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Parae i dobiyek bwen hebwaden yayaluwo bikbikine si setuk heidiye, si hoyowate si pagoluwomid Yeisu heine. I liwo ege iloke yayaluwo bikbikine si setagi, ge tobolebole bwabwaligadiye i pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","I ginawi sohode iloke profet Aiseya wana lihulihu i tabwa tolosuwok, i nga, “Iye hada bole i ho yok ge hada gide i hiyewo.” ");
INSERT INTO nmws_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Saugeine Yeisu i paidi boda si mipainan, habe i liwo wana topadavae heidiye i nga, “Ta hadopanek ta la panhiyebe.” ");
INSERT INTO nmws_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Logugui hana topapalapu hotiya i luwom heine ge i nga, “Topapalapu, se hiyebe u ela heine, bwele a dumuyai heim.” ");
INSERT INTO nmws_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeisu i golase halingane i nga, “Hehewo bekikine hedi goi i gan, ge manman hebwaden si iviwowo he hauhawal hedi win i gan, age nau Tolomo Natune taine lo bagamiye i degan ge a dehiyene.” ");
INSERT INTO nmws_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tolomo hotiya hedi, iye Yeisu wana topadavae, i liwo heine i nga, “Guyau, u taemanau a la a matan tamau gen i mate ge a holem, habe a dumuyai heim.” ");
INSERT INTO nmws_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Agegene Yeisu i liwo heine i nga, “U dumuyai heyau. Tomate habe si holem wedi tomate.” ");
INSERT INTO nmws_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeisu i sesai he wage habe wana topadavae si sai, bwen si waleli. ");
INSERT INTO nmws_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sauge hawesine ege yangak rarareine i towo he soge, ge bagod i ligin dohedohe he wage gamwane. Age Yeisu i hiyene. ");
INSERT INTO nmws_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Habeto wana topadavae-yan si la si paik Yeisu ge si liwo heine si nga, “Guyau, u pamwadai! Hawesine ege bwen ha dobiyek ge ha hao!” ");
INSERT INTO nmws_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","I golase halingadiye i nga, “Sahe kaiwane hu matok? Lemi goru taine i dekai.” Habeto i suwoyuk i midi, bwen i liwo yangak ge bagod si malum, ge i mahave suwok. ");
INSERT INTO nmws_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bobode nuwadiye si hape ge si nga, “Age heto tolomo ti ya? Bwagane yangak ge bagod, si longe halingane.” ");
INSERT INTO nmws_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sauge Yeisu i hadopanek i la i tan Gadara he wedi ganahao, i paidiid tomo ho-iwo si setagim he haliwage. Yayaluwo bikbikine si solavi heidiye, iloke wedi page i ngak suwok, tan bosowaine bobode si dedodogan he hiyede yake. ");
INSERT INTO nmws_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Petaege si gon si nga, “Helak Natune huwo, bwele mwatan u ginawi pagan heyai? Age nuwam u pelaseyai? Taine pepelase hana sauge sohode ti ya.” ");
INSERT INTO nmws_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bobo hedi non lahine si miyemiye he yake ge si hagahaga, taine hedi bwage i demwalao. ");
INSERT INTO nmws_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bwen yayaluwo bikbikine si hawanun heine si nga “Hebe u patile taganai, u patileyai ha setuk bobo hana non yake heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Habe i liwo heidiye i nga, “Hu yogo!” Bwen si setagi ge si setuk bobo heidiye. Habeto bobo hedi non bwabwaligadiye si pededok he busunud, si la si pededau he soge ge si matadau. ");
INSERT INTO nmws_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hebwaden si mamatahasik bobo habekik si patadei si la he hiyebe habeto bigi bwabwaligane si waseyan, ge si waseyan sahe i youmate tomo ho-iwo heidiye, hebwaden yayaluwo bikbikine si miye heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bwen bobode bwabwaligadiye si leke hudiim he hiyebe si paidi Yeisu. Sauge si paidi, si hawanun gaigaisi heine tage i eseyok wedi ganahao. ");
INSERT INTO nmws_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeisu i sai he wage ge i hadopanek i sehavile he habane. ");
INSERT INTO nmws_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bwen bobode topadine si hiyewo luwom tomwalomwalo hotiya heine, i hiyene he wana bagahiyene. Sauge Yeisu i paidi wedi goru, i liwo tomwalomwalo yake heine i nga, “Natu, hatiyem i matuwo! Lam gegi Helak he matane hobak a nuwoyok.” ");
INSERT INTO nmws_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iyete Logugui hana topapalapu topadine si pelihulihu-yanid si nga, “Tolomo ya i gobwage, i gopalongani Helak.” ");
INSERT INTO nmws_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yeisu i lapu wadi nuwotu, bwen i liwo i nga, “Sahe kaiwane nuwotu ngakngakine hu nuwotuyan he hatiyemiu? ");
INSERT INTO nmws_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","I meyan te hebe a nga, ‘Lam gegi Helak he matane hobak a nuwoyok.’ Agegene i puyowo te hebe a nga, ‘U suwoyuk ge u dodogan.’ ");
INSERT INTO nmws_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gane pupuyowane a lihuyan ge a ginawi, iloke hu lapu Tolomo Natune wana gaisi i gan he panayawi gegi i nuwoyok.” Habe i liwo tomwalomwalo heine i nga, “U suwoyuk, lam bagahiyene u howo ge u sehavile he lam guwole.” ");
INSERT INTO nmws_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Habeto tolomo yake i suwoyuk ge i sehavile he wana guwole. ");
INSERT INTO nmws_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sauge boda si paidi, nuwadiye si hape ge si tobalan Helak, kaiwane gaisi sohode ti yake i giyau bobode heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeisu i seyok yawan yake ge i dodogan hedi, habe takis hana tohowo hotiya, hidane Metiu, i paidi i tutuwodau he wana bagakaiwo. I liwo heine i nga, “U dumuyai heyau.” Habeto Metiu i midi ge i dumuyai heine. ");
INSERT INTO nmws_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yeisu mwage i hanhan Metiu he wana guwole, bwen takis hana tohowo ge togegi-yan si hoyowate si luwom he-bwaidiye Yeisu ge wana topadavae si hanhan toyao. ");
INSERT INTO nmws_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisi papaine si hite paidi, bwen si tayakid wana topadavae-yan si nga, “Sahe kaiwane lemi topapalapu he-bwaine takis hana tohowo ge togegi si hanhan toyao?” ");
INSERT INTO nmws_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yeisu i longe lihu ya habe i nga, “Hebwaden si molu taine nuwadiye tohesawali, tobolebole ege nuwadiye. ");
INSERT INTO nmws_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gen hu lok hu la lihu ya hana sapu hu luweni, i nga, ‘Nau taine nuwau man powopowoine, nuwau hatatilao pageine.’ Taine a deluwom tage hebwaden si nga ‘Hamai todohob’ a degon heidiye, age a luwom a gon togegi heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Habe Jon Tobaptais wana topadavae si luwom Yeisu heine ge si tayak si nga, “Sahe kaiwane hamai hene-bwaimai ge Farisi ha palahasik buwota hawanun kaiwane, age lam topadavae tan sauge hotiya si edeginawi sohode?” ");
INSERT INTO nmws_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeisu i golase halingadiye i nga, “Hebe haduwe hana sagae si ginawi, tab tohaduwe tolomoine wana pebwange-yan si tan, sauge hebe iye mwage bwaidiye? Taine! Agegene hana sauge habe i sevin, bwen hana siviye i ho yok tohaduwe tolomoine yake he gamwadiye, habeto si palahasik hedi buwota. ");
INSERT INTO nmws_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Taine ta edehowo kaliko tovevai ge ta edepwas he kaliko toyaune masaseine, kaiwane hebe kaliko tovevai i momod pase, bwen i pakai masase yake. ");
INSERT INTO nmws_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sohode hedi, taine waen tovevai ta edeligin he pwatum toyaune gane gout dimwene. Hebe ta ginawi sohode, gout dimwene bwele i masase, waen i daligi ge gout dimwene i ngak. Waen tovevai ta eligin he pwatum tovevai gane gout dimwene, iloke bwele ho-iwo si dohob toyao.” ");
INSERT INTO nmws_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeisu he wana lihulihu yake gamwane, bwen Judiya wedi todedei hotiya i luwom i lipwakoko he hana hao ge i nga, “Natu vainiine sauge ya habe i mate. U luwom u la gen u bwange tuwane iloke yawedine i sehavile.” ");
INSERT INTO nmws_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Habeto Yeisu i suwomidi ge bwaine si lok, ge he-bwaine hedi wana topadavae-yan. ");
INSERT INTO nmws_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Vaini hotiya gide i ho i midimidi-yan madibe bwaime hana hohoyowate hwawate ho-iwo (12), i seluwom Yeisu he muine bwen i bwange hana kaliko busune. ");
INSERT INTO nmws_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Totone i nuwotu i nga, “Hebe hana kaliko ege a bwange, bwen a molu.” ");
INSERT INTO nmws_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yeisu i galahaik i paidi, habe i nga, “Natu, hatiyem i matuwo! Lam goru hobak i pamoluiwo.” Ge petaege vaini yake i molu. ");
INSERT INTO nmws_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sauge Yeisu i setuk todedei yake he wana guwole, i paidiid igo hana towi ge boda henebwaden si lok ge si yabwatan. ");
INSERT INTO nmws_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bwen i liwo heidiye i nga, “Hu yogo. Vaini tei taine i demate, i hiyene ege.” Agegene wana lihu si niveyan. ");
INSERT INTO nmws_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sauge bobode si leke tagi, bwen Yeisu i la i setuk vaini yake he wana rum, i bwange nimane habeto i suwoyuk. ");
INSERT INTO nmws_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ge Yeisu wana ginawi yake wasane i reru he ganahao yake bwabwaligane. ");
INSERT INTO nmws_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeisu i seyok yawan yake ge i dodogan hedi, habeto tomatagin ho-iwo si sedumuyai ge si segongon si nga, “Deivid Tubune, u hatatilao-yanai.” ");
INSERT INTO nmws_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sauge i la i setuk he guwole, habe tomatagin yake si luwom heine ge i tayakid i nga, “Tab hu goru heyau bosowau matamiu a palale?” Si golase halingane si nga, “Bam, Guyau.” ");
INSERT INTO nmws_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Habe matadiye i pihasik ge i nga, “Gen i youmate heimiu sohode he lemi goru.” ");
INSERT INTO nmws_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ge matadiye i mwapwe. Yeisu i gokiki heidiye i nga, “Tab tolomo hotiya wana wase hu egiyau.” ");
INSERT INTO nmws_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Agegene sauge si yogo si pareru Yeisu wasane he ganahao yake. ");
INSERT INTO nmws_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sauge bobode ya si sesetagi he guwole, tolomo hotiya yayaluwo bikbikine i solavi heine ge taine halingane i degan, si ho luwom Yeisu heine. ");
INSERT INTO nmws_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sauge Yeisu i patile tagan yayaluwo bikbikine, habeto tolomo yake halingane i gan. Bobode hoyowate nuwadiye si hape ge si liwo si nga, “Tan sauge hotiya bigi sohode-yan ya ta edepaidi Isrel he gamwane.” ");
INSERT INTO nmws_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Age Farisi si nga, “Yayaluwo bikbikine wedi todedei he wana gaisi te yayaluwo bikbikine i epatile taganid.” ");
INSERT INTO nmws_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeisu i la i sebayavin he hiyebe lalahine ge yawan tankaikai heidiye. Ilok i papalapu he wedi guwole tapwalolo, i papawayae Helak wana bagalogugui wasane dodohobine, ge bobode henebwaden hedi gide ge hedi bole tomase ge tomase i pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sauge i paidiid boda, hatiyene i dau kaiwadiye, kaiwane tuwadiye i saole ge taine hedi tolabe, sohode sip henebwaden taine hedi tomatahasik. ");
INSERT INTO nmws_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Habeto i liwo wana topadavae heidiye i nga, “Baguye i kai hinone hobak i mweho, agegene tokaiwo taine si dehoyowate. ");
INSERT INTO nmws_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iyete hu hawanun Guyau heine, iye baguye tonuwagane, iloke i patileid tokaiwo si la he wana baguye ge hinone si pase.” ");
INSERT INTO nmws_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeisu i gonid wana topadavae-yan si he-yawate si he-iwo (12) si lok heine, ge i giyau gaisi heidiye iloke bosowaidiye yayaluwo bikbikine si patile tagtaganid ge si pamoluid bobode henebwaden hedi gide ge hedi bole tomase ge tomase. ");
INSERT INTO nmws_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Apostol-yan si he-yawate si he-iwo hidadiye ti ya: dedei, Saimon, gane hidane si hune Pita, ge havane Andru; Jems Sebedi natune, ge havane Jon; ");
INSERT INTO nmws_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ge Batolomiu; Tomas ge Metiu gane takis hana tohowo; Jems Alfiyes natune ge Tadiyes; ");
INSERT INTO nmws_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon gane i hudi boda Selot heidiye, ge Judas Iskariyot, iye i waseyan Yeisu. ");
INSERT INTO nmws_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeisu i epatileid apostol si he-yawate si he-iwo hebwaden ya si setagi, iyete i gopagaisiid i nga, “Tab hu elok henebwaden taine Isrel bobodeidiye sohode he wedi ganahao, o hebe hu esetuk Sameriya he habadiye. ");
INSERT INTO nmws_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Age hu lok ege boda Isrel hana sip haohaoidiye heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hu la hu papalapu hu nga, ‘Helak wana bagalogugui hana sauge hobak i sepasepase.’ ");
INSERT INTO nmws_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hu pamoluid tobolebole, hu pasuwoyukid tomate, hu bagavetaheid toraupoga, ge yayaluwo bikbikine hu patile tagtaganid. Hobak hu howo tan maisane, hu giyau tab maisane. ");
INSERT INTO nmws_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tab mwani gold, silba o kopa hu edohe he lemi pwaus ge hu elosehowo; ");
INSERT INTO nmws_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","tab kaliko hana nabo hu elosehowo lemi dodogan kaiwane, tab kaliko mwamwalao ho-iwoine, o hehemiu hana pase o hepotihe hu eseho. Tab hu enunuwotu, kaiwane tokaiwo hedi logugui te matahasikidiye bwele i gan. ");
INSERT INTO nmws_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sauge hebe hu setuk he hiyebe hotiya o he yawan hotiya, tolomo dodohobine hotiya hu luweni he tei, bwen hu miye he wana guwole hana had hu yogo. ");
INSERT INTO nmws_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sauge hu setuk he guwole, hu liwo heidiye hu nga, ‘Helak i giyau mimalum heimiu.’ ");
INSERT INTO nmws_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hebe bobode hebwaden he guwole tei si yariyae kaiwamiu, lemi gomulolu mimalum kaiwane i misuwok heidiye. Hebe taine, humiu ege hu paidi mimalum, age sidiye taine. ");
INSERT INTO nmws_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hebe taine si deyariyae kaiwamiu ge taine lemi lihulihu si delonge, bwen guwole tei o hebe hiyebe tei hu seyok ge hehemiu puhauine hu tagakakalan yok. ");
INSERT INTO nmws_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tolosuwok a liwo heimiu, he hasehase hana yan Sodom ge Gomora hedi pepelase i puyowo, age hiyebe yake hedi pepelase bwele i puyowo suwok. ");
INSERT INTO nmws_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","A patilemiu sohode sip si ela hehewo mamalekeidiye he gamwadiye. Hu sibe sohode mwate ge hu senapu sohode lumlum. ");
INSERT INTO nmws_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Hu yehemiu, kaiwane bobode papaine bwele si yomoteimiu he kot ge siyo veveroroine bwele si howo ge si rabikmiu he wedi guwole tapwalolo. ");
INSERT INTO nmws_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hidau kaiwane bwele si howomiu ge si yomoteimiu tologugui ge kin he matadiye, iloke hu waseyan wase dodohobine heidiye ge henebwaden taine Judiya-yan sohode heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sauge hebe si howomiu hu la kot kaiwane, tab hu enunuwotu sahe bwele hu elihuyan o hebe mwatan bwele hu gopagan. He sauge yake heto lihulihu hu elaman bwele Helak i giyau heimiu. ");
INSERT INTO nmws_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Taine tage humiu hu delihulihu, age Tamamiu Yayaluwane i miye heimiu iye te i lihulihu. ");
INSERT INTO nmws_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Bobode bwele si waseyanid he-hauhavadiye iloke tologugui si lopamateid. Tame bwele si ginawi sohode hedi he-nanatudiye heidiye. Bubuyese bwele si midi he-tintinadiye ge he-tamtamadiye si hata mamaliye-yanid, iloke si giyau tologugui si lopamateid. ");
INSERT INTO nmws_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","He hidau kaiwane bobode hohoyowate bwele si hata mamaliye-yanmiu, age sega hebe i midi gaigaisi hana had he bagapamwao bwele i mwad. ");
INSERT INTO nmws_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sauge hebe si patilaomiu he yawan hotiya bwen hu iwowo hu la yawan hotiya hedi. Tolosuwok a liwo heimiu, lemi kaiwo taine bwele hu depamwao Isrel wedi yawan bwabwaligane heidiye bwen Tolomo Natune i luwom. ");
INSERT INTO nmws_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tosikuru taine i dekai lake wana topapalapu; tokaiwo taine i dekai lake wana guyau. Nau tilao a paidi, iyete humiu hedi bwele tilao hu paidi. ");
INSERT INTO nmws_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","I dohob ege te tosikuru sohode wana topapalapu, ge tokaiwo sohode wana guyau. Nau guwole tonuwage, si nga tage nau Toberenunu, iyete humiu lo guwole hana tomiye, bwele ide ngakngakidiye suwok habe si tin heimiu. ");
INSERT INTO nmws_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tab hu ematokanid bobode, kaiwane bigi yayabomidiye bwele si mwapwe ge bigi mumusumoidiye bwele si youmate. ");
INSERT INTO nmws_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Heto sahe gane a lihuyan heimiu he gogou, hu lihu-yan he wayae; heto sahe gane a hawasige-yan he batimiu, hu la he guwole pwatane hu gon yaleyale-yan. ");
INSERT INTO nmws_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tab hu ematokanid hebwaden si tagapamate tutuwo age taine bosowaidiye yayaluwo si detagapamate. Helak ege te hu matokan, iye bosowaine tutuwo ge yayaluwo i bagapangakid he hel. ");
INSERT INTO nmws_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ripripuye ho-iwo si paliyan toya hotiya, age? Agegene taine hotiya i desopiyele he kelekele tage Tamamiu taine i delapu. ");
INSERT INTO nmws_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sohode hedi humiu hulumiu pupululune bwabwaligane hobak i pahone mwao ge i lapu vetahemiu. ");
INSERT INTO nmws_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iyete tab hu ematok. Humiu hotiya ge hotiya hu kai lake ripripuye hohoyowate maisadiye. ");
INSERT INTO nmws_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sega bobode he matadiye i gopayoumate tage iye lo tolomo, nau hedi bwele a gopayoumate sohode ti yo Tamau heine he bulubulu. ");
INSERT INTO nmws_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Agegene sega bobode he matadiye i yahakanau, nau hedi bwele a yahakan Tamau heine he bulubulu. ");
INSERT INTO nmws_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tab hu enunuwotu a luwom ge tage mimalum a ho luwom he panayawi. A luwom taine tage mimalum a deho luwom, agegene maleke. ");
INSERT INTO nmws_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A luwom a tagaeneene bobode wedi miyemiye. Tolomo i hata mamaliye-yan tamane, vaini i hata mamaliye-yan tinane, ge tolomo poniyene i hata mamaliye-yan yawanine. ");
INSERT INTO nmws_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tolomo hana siviye bwele si hudi he-tutuine he gamwadiye. ");
INSERT INTO nmws_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sega hebe i nunuwane-yanid vetahe tamane ge tinane agegene nau taine i denunuwane vetahe-yanau, taine bosowaine ta denga, ‘Iye lo todumuyai.’ Sega hebe i nunuwane-yan vetahe natune tolomoine o hebe vainiine agegene nau taine i denunuwane vetahe-yanau, taine bosowaine ta denga, ‘Iye lo todumuyai.’ ");
INSERT INTO nmws_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sega hebe taine i dehiyewo wana koros ge i dedumuyau heyau, taine bosowaine ta denga, ‘Iye lo todumuyai.’ ");
INSERT INTO nmws_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sega yawedine i paidi, bwele i supwahao, ge sega hebe yawedine i supwahao nau kaiwau, bwele yawedine i paidi. ");
INSERT INTO nmws_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sega hebe i pagopasemiu, i pagopaseyau, ge sega i pagopaseyau, i pagopase gane i patileyau. ");
INSERT INTO nmws_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sega hebe i pagopase Helak wana hepapatile kaiwane iye Helak wana hepapatile, bwele maisane i howo sohode Helak wana hepapatile maisane; sega hebe i pagopase tolomo dodohobine kaiwane iye tolomo dodohobine, bwele maisane i ho sohode tolomo dodohobine maisane. ");
INSERT INTO nmws_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sega hebe i hudu bwai tuituiine ge i giyau hebwaden tankaikai ya hotiya heine kaiwane iye lo topadavae, tolosuwok a liwo heimiu, maisane taine i dekwale bwele i howo.” ");
INSERT INTO nmws_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Saugeine Yeisu i gopagaisi mwao wana topadavae si he-yawate si he-iwo (12), habe i seyok hiyebe yake i la i papalapu ge i papatuwohe he Galili hiyebeine-yan heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon Tobaptais mwage he dibula, i longe Keriso wana kaiwo wasane, bwen i patile wana topadavae si la ");
INSERT INTO nmws_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","si tayak Yeisu si nga, “Huwo Mesaiya gane ha lapu Helak i epatile i eluwom, o age ha matemate tolomo hotiya hedi kaiwane?” ");
INSERT INTO nmws_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeisu i golase halingadiye i nga, “Hu sehavile hu giyau Jon wana wase sahe hobak hu longe ge hu paidi: ");
INSERT INTO nmws_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","tomatagin si palale matadiye, hebwaden hehediye ngakngakine si dodogan, toraupoga tuwadiye si dohob, tobatitui si longe lihu, tomate si suwoyuk ge togulegule Wase Dodohobine hana papalapu hobak si longe. ");
INSERT INTO nmws_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Gane taine i denuwo veveiwo kaiwau, Helak i muloluyan.” ");
INSERT INTO nmws_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon wana topadavae si sesehavile, habeto Yeisu i lihulihu boda heidiye Jon kaiwane i nga, “Sauge hu la Jon heine he huyahai kevekeveine, sahe nunuwamiu hu paidi? Tab hu lok tage hu la hu paidi tolomo hotiya wana nuwotu taine i degaisi, sohode widi i gewo belen didiyewo? Tan sohode! ");
INSERT INTO nmws_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hebe taine, sahe nunuwamiu hu la hu paidi? Age tolomo hotiya i sipo kaliko dodohobine? Taine, kaiwane hebwaden si sipo kaliko dodohobine si miyemiye kin he wedi guwole. ");
INSERT INTO nmws_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sahe nunuwamiu hu la hu paidi? Age profet hotiya? Bam! A liwo heimiu iye i kai lake ide profet. ");
INSERT INTO nmws_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon lihuine te profet hotiya i luluweliyan, Helak i liwo: Lo hepapatile a patile deiyan he matam, iye bwele hiyede i lovivine-yan kaiwam. ");
INSERT INTO nmws_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tolosuwok a liwo heimiu, hebwaden si youmate he panayawi, bwabwaligadiye Jon Tobaptais i kai lakeid. Age sega hidane i tankai suwok Helak he wana bagalogugui, iye i kai lake Jon. ");
INSERT INTO nmws_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","I telipune saugeine Jon i papalapu hana had sauge ya, bobode ngakngakidiye si lomaleke Helak he wana bagalogugui, si hamnohon tage si ehowo. ");
INSERT INTO nmws_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moses wana Logugui ge profet bwabwaligadiye si wasewase-yan Helak wana bagalogugui wana luwom hana had Jon. ");
INSERT INTO nmws_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ge Jon iye Ilaija gane profet hotiya i nga i eluwom. Akum hu goru sohode ti ya. ");
INSERT INTO nmws_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hebe batimiu i gan, lo lihulihu ya hu longe. ");
INSERT INTO nmws_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Bobode sai hebwaden yan ya, sahe heine a papatini-yanid? Sidiye sohode bubuyese si tutuwodau he bagamwaket, bwen papaine si gon hene-bwaidiye heidiye si nga: ");
INSERT INTO nmws_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ha wi haduwe hana igo kaiwamiu, bwen taine hu desali. Ha wokan nuwongak wokine, bwen taine hu detan. ");
INSERT INTO nmws_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sai hebwaden yan ya wedi page sohode te bubuyese yake wedi page, si papariyere. Kaiwane Jon i luwom ge i palahasik buwota, ge taine i demun waen, iyete bobode si nga, ‘Yayaluwo bikbikine i solavi heine.’ ");
INSERT INTO nmws_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Agegene nau Tolomo Natune a luwom, a han ge a mun, iyete bobode si nga, ‘Tolomo ga ya iye tosoni ge tomunmun, iye takis hana tohowo ge togegi wedi pebwange.’ Agegene sibe gane i hudi Helak heine, ta paidi muiine ge ta hawa tolosuwok-an.” ");
INSERT INTO nmws_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Habe Yeisu i hawa ngakngak-anid hiyebe-yan hebwaden pamali yauyawate i ginawiid i hoyowate he gamwadiye, kaiwane taine si deseyok wedi page ngakngakine. ");
INSERT INTO nmws_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","I nga, “Eeu! Korasin, humiu benan hu ngak! Eeu! Betsaida, humiu benan hu ngak! Akum pamali yauyawate gane a ginawiid heimiu veto gen a ginawi Taya ge Saidon heidiye, sidiye toyauneik kaliko gane si ginawi he man pupululune si sipo ge tuwadiye si yawi he pwaihau, iloke si payoumateid te hobak si seyok wedi gegi. ");
INSERT INTO nmws_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A liwo heimiu, he hasehase hana yan, Taya ge Saidon hedi pepelase i puyowo, age humiu hemi pepelase bwele i puyowo suwok. ");
INSERT INTO nmws_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Mwatan humiu Kapeniyam! Age nuwamiu hidamiu hu hotei senge nate? Agegene bwele si bili dongemiu hu sedau hel. Akum pamali yauyawate gane a ginawiid heimiu veto gen a ginawi Sodom, sidiye si seyok wedi page ngakngakine habe taine pepelase si depaidi, iloke hiyebe Sodom habe mwage i miyemiye hana had yan ya. ");
INSERT INTO nmws_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A liwo heimiu, he hasehase hana yan, Sodom hedi pepelase i puyowo, age humiu hemi pepelase bwele i puyowo suwok.” ");
INSERT INTO nmws_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","He saugeine yake Yeisu i liwo i nga, “A tobaliwo Tamau, bulubulu ge panayawi wedi Guyau, kaiwane u ho sumwan lam bagalogugui hana lapu tosibe ge tolapu heidiye ge hobak u payoumate hebwaden sohode bubuyese heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Bam, Tamau, kaiwane huwo lam nuwotu sohode. ");
INSERT INTO nmws_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tamau hobak i giyau heyau lapu bwabwaligane iloke a payoumate bobode heidiye. Taine hotiya i delapuyau, Tamau ege, ge taine hotiya i delapu Tamau, iyege te nau Natune ge hebwaden habe a haseid a payoumate Tamau heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Hu luwom heyau bwabwaligamiu, humiu hebwaden puyowo hu hiyewo ge tuwamiu si saole, iloke a pamanaomiu. ");
INSERT INTO nmws_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hiyewo gane a giyau gen hu howo ge hu lapu heyau, kaiwane a hodonge totou ge lo page i malum, iloke bwele manao hu paidi. ");
INSERT INTO nmws_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaiwane hiyewo gane a giyau i meyan ge duwohe gane a giyau taine i depuyowo.” ");
INSERT INTO nmws_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Saugeine yake, he Sabat yanine hotiya Yeisu i setukan he wit hana baguye hotiya gamwane. Wana topadavae-yan si buwota, bwen si kibo wit hinone ge si han. ");
INSERT INTO nmws_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sauge Farisi si paidiid, habeto si liwo Yeisu heine si nga, “U paidi, lam topadavae-yan si lake Sabat hana logugui.” ");
INSERT INTO nmws_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeisu i golase halingadiye i nga, “Age taine habe hu depahone Deivid lihuine, mwatan i ginawi pagan saugeine he-bwaineid wana bobode si buwota? ");
INSERT INTO nmws_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deivid i la i setuk Helak he wana guwole, iloke bred gabgabubine gane si hotei Helak he hana hao, topowo i howo i giyau Deivid ge wana bobode heidiye ge si han. Bred yake si han, bwagane logugui i liwo tab si ehan, topowo ege si han. ");
INSERT INTO nmws_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Age taine habe hu edepahone Moses wana Logugui, gane i nga he yan Sabat hotiya ge hotiya topowo-yan si kaikaiwo he Guwole Gagabubine? Yan Sabat hana logugui hobak si lake ti yo, age taine wedi ngak i degan. ");
INSERT INTO nmws_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A liwo heimiu, tolomo hotiya mwage he ya, iye hidane i kai lake Guwole Gagabubine hidane. ");
INSERT INTO nmws_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Helak wana lihulihu hotiya hana sapu taine hu delapu, gane i nga, ‘Nau nuwau hatatilao pageine, tan nuwau man powopowoine.’ Akum lihulihu ga ya hana sapu hu lapu, bwen lo topadavae taine hu dehawa ngakngak-anid, sidiye taine wedi ngak i degan. ");
INSERT INTO nmws_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kaiwane nau Tolomo Natune, nau Sabat hana Guyau.” ");
INSERT INTO nmws_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeisu i dodogan hedi i lok i la i setuk hiyebe yake he wedi guwole tapwalolo. ");
INSERT INTO nmws_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tolomo hotiya mwage te he yake, nimane panihebe hotiya i jalojalo. Farisi nuwadiye Yeisu hana pwapwatim si ginawi, iyete si tayak si nga, “Mwatan wada logugui i liwo pagan? Tab bosowaine tolomo ta pamolu he yan Sabat o taine?” ");
INSERT INTO nmws_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Habe i liwo heidiye i nga, “Hebe humiu hotiya, wana sip hotiya i gan ge yan Sabat i sopiyele he goi, bwele i bwangehasik ge i hotagan, ine? ");
INSERT INTO nmws_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sip bigi lahine, agegene tolomo te bigi lahine suwok. Iyete Logugui i taeman ginawi dodohobine ta ginawi he yan Sabat.” ");
INSERT INTO nmws_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Habe i liwo tolomo yake heine i nga, “U parumwaru nimam.” Bwen nimane i parumwaru, ge hobak i dohob sohode hedi nimane panihebe. ");
INSERT INTO nmws_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Agegene Farisi si setagi, ge si la si nunuwotu mwatan si ginawi pagan iloke Yeisu si lopamate. ");
INSERT INTO nmws_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeisu hobak i lapu Farisi wedi nuwotu bwen i seyok hiyebe yake. Bobode hoyowate si dumuyai hei ge wedi tobolebole-yan bwabwaligadiye i pamoluid, ");
INSERT INTO nmws_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","age i topahadid tab si elihuyan bobode heidiye sega iye. ");
INSERT INTO nmws_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I ginawi sohode ti yake, iloke Helak wana lihulihu gane profet Aiseya i payoumate i tabwa tolosuwok, i nga: ");
INSERT INTO nmws_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Lo tokaiwo tagi ya, gane a hase, a nunuwane-yan ge a yariyae-yan. Yayaluwau a giyau heine, ge iye lo logugui sapusapuine bwele i wasewase-yan bobode bwabwaligadiye heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Taine bwele i dehawagaisi ge i degon yaleyale, ge taine halingane bwele i degopakai he hiyede. ");
INSERT INTO nmws_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mwamwaho gane i kom taine bwele i demwanabebe, suli gane i todau taine bwele i depabuwode. Iye te sohode bobode henebwaden yayaluwadiye i pwayate taine bwele i deboleuid. Bwele i kaiwo hana had nau Helak lo logugui sapusapuine i lake bigi bwabwaligane. ");
INSERT INTO nmws_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iye hidane bobode hoyowate bwele si patamedan. ");
INSERT INTO nmws_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Habeto bobode topadine si ho luwom tolomo hotiya, matane i gin ge taine i delihu, kaiwane yayaluwo bikbikine i solavi heine. Yeisu i pamolu habeto halingane i mapwe ge matane i palale. ");
INSERT INTO nmws_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bwen bobode bwabwaligadiye nuwadiye si hape ge si nga, “Tab hebe iye Deivid Tubune?” ");
INSERT INTO nmws_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Agegene saugeine Farisi-yan si longe ti yake, habe si nga, “Yayaluwo bikbikine wedi todedei, Toberenunu, he wana gaisi te i epatile tagtaganid yayaluwo bikbikine.” ");
INSERT INTO nmws_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeisu i lapu ege wedi nuwotu, bwen i liwo heidiye i nga, “Hebe bagalogugui hotiya i ginawi boda ho-iwo ge totodiye si pelolomalekeid, bagalogugui yake bwele i mwao. O hebe hiyebe hotiya o hebe hun hotiya i ginawi boda ho-iwo ge totodiye si pelolomalekeid, bwele taine i degaisi. ");
INSERT INTO nmws_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sohode hedi, hebe Seitan totone wana boda i patile taganid, iye te totodiye si pelolomalekeid, iloke wana bagalogugui bwele i mwao. ");
INSERT INTO nmws_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hu nga tage Toberenunu he wana gaisi te a epatile tagtaganid yayaluwo bikbikine. Hebe hu liwo sohode ti yake, sega he wana gaisi ge humiu lemi topadavae-yan si epatile tagtaganid yayaluwo bikbikine? Totomiu lemi topadavae si payoumate lemi ngak. ");
INSERT INTO nmws_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Agegene hebe Helak Yayaluwane wana gaisi heine ge a epatile tagtaganid yayaluwo bikbikine, iye te Helak wana bagalogugui hobak i luwom heimiu. ");
INSERT INTO nmws_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Taine bosowaine tolomo hotiya i desetuk tolomo gaigaisiine he wana guwole ge wana gogomwau i deyomo, age? Hebe nuwane, dedei gen i yawan, habe wana guwole bigibigiine i yomo yogoyan. ");
INSERT INTO nmws_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Sega taine i demiyemiye heyau, iye ho siviye. Sega hebe taine bwalu ha deyomo pasepase, iye tobibiyele. ");
INSERT INTO nmws_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","A liwo heimiu, sega hebe i ginawi page ngakngakine ge hebe i gobwage ge i hawatautau-yan Helak, gegi ga yake bosowaine Helak i nuwoyok. Agegene sega hebe i gobwage ge i hawatautau-yan Yayaluwo Gagabubine, gegi ga yake Helak taine bwele i denuwoyok. ");
INSERT INTO nmws_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sega hebe i gopanpangek-an Tolomo Natune, gegi ga yake bosowaine Helak i nuwoyok. Agegene sega hebe i gopanpangek-an Yayaluwo Gagabubine, gegi ga yake Helak taine bwele i denuwoyok, sauge ya o hebe sauge i eluwom. ");
INSERT INTO nmws_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Hebe hubwahi dodohobine, iyete hinone i dohob. Hebe hubwahi ngakngakine, iyete hinone i ngak. Hebe ta paidi hinone bwen ta lapu hubwahi, hebe hubwahi dodohobine o hebe hubwahi ngakngakine. ");
INSERT INTO nmws_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Humiu Farisi sohode mwate! Humiu bobode ngakngakidiye, iyete tan bosowaine lihu dodohobine hu delihuyan. Taine suwok! Sahe hebe i susuwoku he hatiyede, iye te i setagi he hawade. ");
INSERT INTO nmws_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tolomo gane dodohobine i puwoyan page dodohobine, sohode dohob gane i pase he hatiyene. Tolomo gane ngakngakine i puwoyan page ngakngakine, sohode ngak gane i pase he hatiyene. ");
INSERT INTO nmws_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“A liwo heimiu, he hasehase hana yan tolomo hotiya ge hotiya hana kot bwele i gan lihu ngakngakine hohoyowate kaiwane, gane i lihuyan. ");
INSERT INTO nmws_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Hebe halingamiu lihu dodohobine, Helak bwele i hawa dodohob-anmiu. Hebe halingamiu lihu ngakngakine, Helak bwele i hawa ngakngak-anmiu.” ");
INSERT INTO nmws_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Habeto Farisi ge Logugui hana topapalapu topadine si liwo Yeisu heine si nga, “Topapalapu, nuwamai pamali yauyawate hotiya gen u ginawi ha paidi.” ");
INSERT INTO nmws_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeisu i golase halingadiye i nga, “Humiu sai yauyauleine, taine hu demiye Helak heine, bwen nunuwamiu bagapatuwohe hotiya a ginawi heimiu. Agegene taine bagapatuwohe hotiya a degiyau heimiu, iyege te gane i youmate profet Jona heine. ");
INSERT INTO nmws_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sohode Jona i miyemiye he yalogi lahine tiniyene yan ho-tuwon ge gogou ho-tuwon, sohode hedi nau Tolomo Natune a miye he kelekele gamwane yan ho-tuwon ge gogou ho-tuwon. ");
INSERT INTO nmws_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","He hasehase hana yan bobode Ninibe habe si suwomidi ge si hawa ngakngak-anmiu, kaiwane Jona wana papalapu si longe habeto si seyok wedi gegi. Tolomo hotiya mwage he ya, iye i kai lake Jona, age humiu wana papalapu taine hu delonge ge taine hu deseyok lemi gegi. ");
INSERT INTO nmws_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","He hasehase hana yan ganahao Seba wedi kwin habe i suwomidi ge i hawa ngakngak-anmiu, kaiwane iye i luwom he ganahao bwagebwage nuwane i longe Solomon wana papatuwohe sibesibeine. Tolomo hotiya mwage he ya, iye i kai lake Solomon, age humiu taine hu delonge halingane.” ");
INSERT INTO nmws_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sauge yayaluwo bikbikine i setagiim tolomo hotiya heine, bwen i la i sebayavin-an huyahai bwagebwageine wana bagamanao i luweni, age taine i depaidi hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Habeto i liwo i nga, ‘Gen a sehavile he habau gane a seyok.’ Saugeine i sehavile, i paidi bagamiye yake si yahi ge si bagavetahe, agegene guwole gamwane hohowane. ");
INSERT INTO nmws_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Bwen i yogo i la wana pan yayaluwo bikbikine wedi hohoyowate si he-pik (7) hedi i sehapeid, sidiye wedi page ngakngakine suwok, habe he-bwaineid si setuk ge si solavi he bagamiye yake. Bwen tolomo yake wana miyemiye dedei i ngak, age muyai ngakngakine suwok. Bwele i youmate sohode ti yo sai yauyauleine yan ya heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeisu mwage i lihulihu boda heidiye bwen tinane ge he-hauhauvane si sevin, si talmidi dedelawi, nunuwadiye bwaidiye si lihu. ");
INSERT INTO nmws_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Habe tolomo hotiya i giyau wana wase i nga, “Tinam ge he-hauhauvam mwage sidiye dedelawi si midimidi, nunuwadiye hene-bwaim gen hu lihu.” ");
INSERT INTO nmws_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeisu i golase halingane i nga, “Sega tinau, ge segawai he-hauhauvau?” ");
INSERT INTO nmws_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Habe nimane i sudilok wana topadavae heidiye ge i liwo i nga, “Tinau ge he-hauhavau sidiye tagi yeya! ");
INSERT INTO nmws_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sega hebe i pabwasowo Tamau he bulubulu wana nuwotu, iye te havau, lu ge tinau.” ");
INSERT INTO nmws_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","He yan yake Yeisu i setagiim he guwole i lok i la he soge hadidine ge i tuwodau. ");
INSERT INTO nmws_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Boda lahine suwok si mipase ge si mipainan, bwen i gaesai he wage hotiya ge i tuwodau, agegene bobode si talmidi he mamele. ");
INSERT INTO nmws_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Habeto i gohalibe iloke bigi hohoyowate i lihuyan heidiye. I nga, “Tolomo hotiya i lok he baguye ge i yok wit pwatumine. ");
INSERT INTO nmws_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sauge i yok pwatum, topadine si dobu he hiyede, bwen man si yowo dau ge si hanid. ");
INSERT INTO nmws_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Topadine si dobu he poepoe pakpakine, hedi poepoe dodohobine taine i dekai. Habekik bwen si siwi, kaiwane poepoe taine i demidau. ");
INSERT INTO nmws_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Age sauge parae i sai, i yamwanid wit matakabuine bwen si yakiwo, kaiwane hewasidiye taine i desedau vetahe. ");
INSERT INTO nmws_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pwatum topadine si dobu he pipisare gamwadiye, bwen pipisare i siwi gaigaisi ge i bib pamate wit yake. ");
INSERT INTO nmws_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pwatum topadine si dobu he poepoe dodohobine ge si puwo, tomase tomase hinodiye. Papaine hinodiye ho-sangak, topadine ho-ewone, topadine ho-etuwon. ");
INSERT INTO nmws_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Hebe batimiu i gan, lo lihulihu ya hu longe.” ");
INSERT INTO nmws_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yeisu wana topadavae si luwom heine ge si tayak si nga, “Sahe kaiwane u gohalibe bobode heidiye?” ");
INSERT INTO nmws_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yeisu i golase halingadiye i nga, “Helak wana bagalogugui hana nuwotu sumosumoine hobak i payoumate heimiu, age taine i depayoumate heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sega wana lapu i gan, Helak bwele i tubwen, iloke Helak hana lapu bwele i kai suwok heine. Sega Helak hana lapu taine i degan heine, sahe tankai veto wana lapu, Helak bwele i ho yok. ");
INSERT INTO nmws_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pakene a gohalibe heidiye kaiwane si hahayao ege taine si depaidi, si papadavae ege taine si delonge ge si delapu. ");
INSERT INTO nmws_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sidiye he wedi ginawi profet Aiseya wana luluweli i tabwa tolosuwok, i nga: Bwele hu mimi papadavae, agegene taine hu delonge ge hu delapu, bwele hu mimi hahayao, agegene taine hu depaidi. ");
INSERT INTO nmws_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kaiwane bobode ya hatiyediye i pak, si pigane batidiye, ge si pagin matadiye. Akum taine, bwen si paidi he matadiye, si longe he batidiye, ge si lapu he hatiyediye, iloke si nuwo pahavile heyau ge a pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Age humiu hu dohob kaiwane matamiu i wayae ge batimiu i mwapwe. ");
INSERT INTO nmws_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tolosuwok a liwo heimiu, profet ge Helak wana bobode dedei si hoyowate nunuwadiye suwok si paidi sahe humiu hu paidi, agegene taine si depaidi, ge nuwadiye suwok si longe sahe humiu hu longe, agegene taine si delonge. ");
INSERT INTO nmws_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gen hu padavae, iloke hu lapu pwatum hana toyok hana gohalibe hana sapu. ");
INSERT INTO nmws_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sauge hebe tolomo hotiya i longe Helak wana bagalogugui wasane, age hana sapu taine i delapu, bwele Seitan i luwom ge i ho hwae sahe gane si vahi he hatiyene. Iye te pwatum gane i dobu he hiyede. ");
INSERT INTO nmws_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pwatum ga i dobu he poepoe pakpakine, iye te bobode hebwaden wase dodohobine si longe ge tanpeyawate si howo si hotei he hatiyediye bwaine wedi yariyae. ");
INSERT INTO nmws_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Agegene bigi hotiya, wase dodohobine taine si denunuwotu-yan vetahe he hatiyediye, hewasidiye taine i desedau vetahe, iyete wedi sauge taine i demwalao. Sauge hebe si paidi puyowo o hebe bobode si patilaoid wase dodohobine kaiwane, tanpeyawate si pi yayaluwadiye ge si boleu. ");
INSERT INTO nmws_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pwatum ga i dobu he pipisare gamwadiye, iye te bobode hebwaden wase dodohobine si longe, age si nunuwotu panayawi yawedine kaiwane ge si nuwo gogomwau, iyete bigibigi hebwaden ya si bib pamate wase dodohobine ge taine hinone i degan. ");
INSERT INTO nmws_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pwatum gane i dobu he poepoe dodohobine, iye te bobode hebwaden wase dodohobine si longe ge si lapu hana sapu. Si puwo, papaine hinodiye ho-sangak, papaine ho-ewone, papaine ho-etuwon.” ");
INSERT INTO nmws_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeisu i lihuyan gohalibe hotiya hedi heidiye i nga, “Helak wana bagalogugui sohode ti ya. Tolomo hotiya i yok wit pwatumine dodohobine he wana baguye. ");
INSERT INTO nmws_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gogou hotiya bobode bwabwaligadiye si hiyene, bwen hana siviye hotiya i luwom ge i yok nan ngakngakine pwatumine he wit gamwadiye, habeto i yogo. ");
INSERT INTO nmws_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sauge wit i siwi ge i telipune i puwo, bwen nan ngakngakine i youmate hedi. ");
INSERT INTO nmws_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tolomo yake wana tokaiwo si luwom heine si nga, ‘Gamalak, wit pwatumine dodohobine u yok he lam baguye, age? Agegene nan ngakngakine i hudi igohoi?’ ");
INSERT INTO nmws_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I golase halingadiye i nga, ‘Siviye hotiya i ginawi tei.’ Wana tokaiwo si liwo si nga, ‘Tab nuwam hamai ha lok ge ha puik yok?’ ");
INSERT INTO nmws_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I golase halingadiye i nga, ‘Tab, kaiwane hebe nan ngakngakine hu puik yok, bwele hoge hu puik hebo wit. ");
INSERT INTO nmws_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gen si toiwo si siwi toyao, hana had pasepase hana sauge. He saugeine yake a liwo topasepase heidiye a nga: Nan ngakngakine gen hu puik deiyan ge hu kin bwele ta ton, habeto wit hu yomo ge hu pase he lo guwole.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeisu i lihuyan gohalibe hotiya hedi heidiye, i nga, “Helak wana bagalogugui sohode hayao pwatumine, tolomo hotiya i howo ge i vahi he wana malahao. ");
INSERT INTO nmws_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pwatum hohoyowate gamwadiye iye i tankai suwok, agegene sauge i siwi ge i kai, bwen i kai lakeid bigi hohoyowate hebwaden si siwi he malahao. I tabwa hibwahi lahine hotiya bwen man hebwaden si iviwowo he hauhawal hedi win si ginawi he yahahane.” ");
INSERT INTO nmws_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeisu i lihuyan gohalibe hotiya hedi, i nga, “Helak wana bagalogugui sohode yis, vaini hotiya i howo ge i hotei pwalawa hana kaikai sohode beg ho-tuwon he gamwane, habeto yis i kaiwo hana had i tuk soleyan pwalawa bwabwaligane.” ");
INSERT INTO nmws_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeisu i gohalibe iloke bigibigi hebwaden yake bwabwaligane i lihuyan bobode heidiye; he gohalibe ege te bigibigi topadine i lihuyan heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iloke profet wana lihulihu i tabwa tolosuwok i nga: Hawau a pwe ge a gohalibe; a lihuyanid bigibigi mumusumoidiye, hebwaden si musumo saugeine veto panayawi i telipune hana had sauge ya. ");
INSERT INTO nmws_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Habeto Yeisu i seyokid boda ge i la i setuk he guwole. Wana topadavae si luwom heine si nga, “Nan ngakngakine i siwi he baguye hana gohalibe gen u gopawayae heyai.” ");
INSERT INTO nmws_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I golase halingadiye i nga, “Tolomo gane wit pwatumine dodohobine i yok, iye te Tolomo Natune. ");
INSERT INTO nmws_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Baguye iye te panayawi, ge wit pwatumine dodohobine iye te Helak wana bagalogugui bobodeidiye. Nan ngakngakine iye te Seitan wana bobode, ");
INSERT INTO nmws_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ge siviye gane nan ngakngakine pwatumine i yok, iye te Seitan. Pasepase hana sauge iye te sauge mwaomwaoine, ge topasepase sidiye te anelose-yan. ");
INSERT INTO nmws_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Nan ngakngakine si puik yok ge si ton he hiwo, iye te bwele sohode hedi he sauge mwaomwaoine. ");
INSERT INTO nmws_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bwele Tolomo Natune wana anelose-yan i patileid, bwen si puik yok he wana bagalogugui bigi hohoyowate hebwaden si pasopiyeleid bobode ge si gegi, sohode hedi bobode bwabwaligadiye hebwaden page ngakngakine si ginginawi. ");
INSERT INTO nmws_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Habeto si yok tukanid he hiwo lahine gamwane iloke si tantan ge si sangsangapatad ngingidiye. ");
INSERT INTO nmws_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bwen tosapu-yan si tale sohode parae Tamadiye he wana bagalogugui. Hebe batimiu i gan, lo lihulihu ya hu longe.” ");
INSERT INTO nmws_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Helak wana bagalogugui sohode hedi gogomwau lahine si holem he baguye hotiya ge si mate yok. Tolomo hotiya i sepaidi habe i ho sumwan pahavile hedi. I yariyae suwok gogomwau yake kaiwane, iloke i la wana bigibigi hoyowate i paliyan, bwen maniine i howo ge i pamaise baguye yake. ");
INSERT INTO nmws_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Helak wana bagalogugui sohode hedi ti ya. Gogomwau hana topali hotiya i luweniid bak dodohobidiye. ");
INSERT INTO nmws_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sauge hotiya, bak dodohobine suwok maisane lahine i paidi, ilok i la wana bigibigi hohoyowate i paliyan, bwen maniine i howo ge i pamaise bak yake. ");
INSERT INTO nmws_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Helak wana bagalogugui sohode hedi waimu si gaeyan he soge, iloke yalogi tomase ge tomase si huwone. ");
INSERT INTO nmws_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Sauge i susuwoku, tologi si momod senge he kelekele. Habeto si tuwodau, ilok yalogi si lohaseid, hebwaden dodohobidiye si dohe he kekehe, hebwaden ngakngakidiye si yomo yokid. ");
INSERT INTO nmws_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bwele sohode ti yake he sauge mwaomwaoine. Anelose-yan si luwom, tongak ge todohob si yomo teiid tomase, hebwaden si ngak si yomo vevekid. ");
INSERT INTO nmws_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Habeto si yok tukanid he hiwo lahine gamwane, iloke si tantan ge si sangsangapatad ngingidiye. ");
INSERT INTO nmws_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeisu i tayakid wana topadavae i nga, “Tab nuwamiu i sapu lihulihu hebwaden ya kaiwadiye?” Si golase halingane si nga, “Bam.” ");
INSERT INTO nmws_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","I liwo heidiye i nga, “Logugui hana topapalapu bwabwaligadiye, hebwaden hobak si padavae-yan Helak wana bagalogugui, sidiye sohode guwole tonuwage gane bigibigi tovevai ge bigibigi totoyaune i yomo he wana bagasolavi ge i hotei taganid.” ");
INSERT INTO nmws_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Saugeine Yeisu i gomwao gohalibe hebwaden ya, habe i seyok hiyebe yake ");
INSERT INTO nmws_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","i lok i la totone he habane. I papalapu bobode he wedi guwole tapwalolo, bwen nuwadiye si hape si nga, “Wana lapu ya i howo igohoi? Mwatan ge bosowaine pamali yauyawate i ginawiid? ");
INSERT INTO nmws_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iye kapenta natune, age? Tinane hidane Meri, he-hauhavane Jems, Josep, Saimon ge Judas. ");
INSERT INTO nmws_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","He-lulune bwabwaligadiye mwage he-bwaide-yan. Sohode ti yo, age? Age wana lapu ge wana sibe ya i howo igohoi?” ");
INSERT INTO nmws_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iyete si hata mamaliye-yan Yeisu. Yeisu i liwo heidiye i nga, “Bobode bwabwaligadiye si hawatau-yan profet, agegene he-tutuine ge habane bobodeidiye ege taine si dehawatau-yan.” ");
INSERT INTO nmws_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pamali yauyawate taine i dehoyowate i deginawiid he hiyebe yake, kaiwane taine si degoru heine. ");
INSERT INTO nmws_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","He sauge yake, Herodi iye Galili wedi tologugui, i longe Yeisu wasane, ");
INSERT INTO nmws_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","habeto i liwo wana tokaiwo heidiye i nga, “Ga yetei Jon Tobaptais, i suwoyukim he mate. Iye te kaiwane wana gaisi i gan ge pamali yauyawate i ginginawiid.” ");
INSERT INTO nmws_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Veto Herodi i hadaenge hwae Herodiyas, iye havane Filip poniyene. Jon i mimi lihulihu Herodi heine i nga, “Taine bosowaine u dehadaenge.” Iyete baene, Herodi i patileid wana tokaiwo-yan, bwen si bwange Jon si yawan ge si hotei he dibula. ");
INSERT INTO nmws_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodi nuwane i tagapamate, age i matokanid bobode, kaiwane si goru Jon heine iye profet hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodi wana hab yanine yariyaeine hei, Herodiyas natune vainiine i salisali he boda matadiye. Wana salisali Herodi i yariyae-yan suwok, ");
INSERT INTO nmws_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","habeto i nga, “Tolosuwok a silo tamau, hebe sahe u hawanunan, bwele a giyau heim.” ");
INSERT INTO nmws_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tinane i liwo heine, habeto iye i liwo Herodi heine i nga, “Jon Tobaptais dumuwone u gotem, kahulune u ho dohe he nohe, u ho luwom ge u giyau heyau gen a paidi.” ");
INSERT INTO nmws_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kin nuwane i ngak, age i liwo si ginawi sohode vaini yake wana nuwotu, kaiwane hobak i silosilo hebwaden si la he sagae yake he matadiye. ");
INSERT INTO nmws_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iyete i liwo ge Jon dumuwone si gotem he dibula. ");
INSERT INTO nmws_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kahulune si ho dohe he nohe, habeto si ho luwom si giyau vaini yake heine ge i ho giyau tinane heine. ");
INSERT INTO nmws_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bwen Jon wana topadavae si luwom, si howo tuwane ge si la si holem he haliwage, habeto si la si giyau Yeisu wana wase. ");
INSERT INTO nmws_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yeisu i longe wase ya habe i seyok hiyebe yake, ge i sai he wage tage si la si emivevek he papaeli. Bobode si longe wana yogo wasane, bwen si seyokid habadiye ge si dodogan he hehediye si sedumuyai. ");
INSERT INTO nmws_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sauge Yeisu i gaedau ge i paidiid boda, bwen hatiyene i dau kaiwadiye ge wedi tobolebole-yan i pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Saugeine i kokoyavi suwok, wana topadavae si luwom heine si nga, “Hiyebe ya i mipabwagebwage ge hawesine ege bwen i gogou. Boda u patileid si la he yawan-yan ge si pamaise nahadiye.” ");
INSERT INTO nmws_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeisu i golase halingadiye i nga, “Tab si eyogo! Humiu hu giyau haga hotiya si han.” ");
INSERT INTO nmws_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Si liwo heine si nga, “Bred pwahi-lime ge yalogi ho-iwo ege te i gan heyai.” ");
INSERT INTO nmws_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Bwen i nga, “Gen hu yomo luwom heyau.” ");
INSERT INTO nmws_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Habeto i liwo bobode si tuwodau he nan pwapwatane, bwen i howo bred pwahi-lime ge yalogi bunim-iwo, matane i lisin he bulubulu ge i gomulolu Helak heine. Habeto bred i pieneene-yan, bwen i giyau wana topadavae heidiye ge sidiye habe si talaotan bobode heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bobode hoyowate si han tine sus, habeto wedi han tuwoi topadavae si bagavetahe, hana yogowo nabwa-yawate nabwa-iwo (12). ");
INSERT INTO nmws_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bobode henebwaden si hanhan hedi hohoyowate anamate paib tausan, agegene taine si dehowo venakau ge gamagai hedi hohoyowate. ");
INSERT INTO nmws_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Habe Yeisu i liwo wana topadavae heidiye si sai he wage ge si dedei si hadopanek panhiyebe hotiya, habe iye i patileid bobode si yogo. ");
INSERT INTO nmws_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I patile mwaoid si yogo, habeto iye i totiya ege i la i tihe sai he bobokun ge i hauhawanun. Sauge i gogou i totaege i miye te he yake, ");
INSERT INTO nmws_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","agegene wage hobak hana bwage i gan he hiyebe, bagod i tagapagigiyele-yan suwok, kaiwane didiyewo i towo pasanahad. ");
INSERT INTO nmws_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Henanai suwok tri oklok ge siks oklok he hauhawaline, habeto Yeisu i luwom heidiye i dodogon he soge pwatane. ");
INSERT INTO nmws_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wana topadavae-yan si paidi i dodogan he soge pwatane hoge si matok si nga, “Balome ti ya!” Bwen si yale bwaine ge wedi matok. ");
INSERT INTO nmws_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ge petaege Yeisu i liwo heidiye i nga, “Hatiyemiu i matuwo! Tab matok! Nau ti ya.” ");
INSERT INTO nmws_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita i nga, “Guyau, hebe tolosuwok huwo, u liwo heyau a dodogon he soge pwatane ge a lowo heim.” ");
INSERT INTO nmws_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeisu i golase halingane i nga, “U luwom.” Habeto Pita i sedau i dodogan he soge pwatane i la Yeisu heine. ");
INSERT INTO nmws_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Age saugeine i paidi rebu, bwen i matok ge i telipune i dobiyek, habe i gon i nga, “Guyau, u pamwadau!” ");
INSERT INTO nmws_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Petaege Yeisu nimane i pamwalao ge i pihasik, bwen i nga, “Lam goru taine i dekai! Sahe kaiwane u nuwo veveiwo?” ");
INSERT INTO nmws_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sauge si gaesai he wage, bwen didiyewo i mate. ");
INSERT INTO nmws_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Habeto henebwaden si miyemiye he wage si kululu heine si nga, “Tolosuwok, huwo Helak Natune.” ");
INSERT INTO nmws_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Si hadopanek si la si tan he hiyebe Genesaret. ");
INSERT INTO nmws_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sauge bobode si paidi Yeisu si lapu iye ti yo, bwen si patile wase he yawanine bwabwaligane ge si yomo luwomid tobolebole hoyowate. ");
INSERT INTO nmws_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Habeto si hawanun heine wedi tobolebole si pihasik ege hana kaliko busune, ge hebwaden si pinohon, bwabwaligadiye si molu. ");
INSERT INTO nmws_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisi ge Logugui hana topapalapu topadine si hudi Jerusalem si lok Yeisu heine ge si tayak si nga, ");
INSERT INTO nmws_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mwatan ge lam topadavae si sepalongani logugui gane i hudi he-tutubude heidiye? Taine si desawi nimadiye sohode logugui yake hana hiyede, muyai habeto si hanhan.” ");
INSERT INTO nmws_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeisu i golase halingadiye i nga, “Mwatan ge humiu hu sepalongani Helak wana logugui ge hu gorugoru totomiu he lemi papalapu hei, gane i hudi he-tutubumiu heidiye? ");
INSERT INTO nmws_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaiwane Helak i nga, ‘U hawatau-yanid tamam ge tinam’ ge i nga, ‘Sega hebe i gopangakid tamane ge tinane gen si lopamate.’ ");
INSERT INTO nmws_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Agegene humiu hu liwo sohode ti ya: Hebe bigibigi papaine i gan tolomo hotiya heine tage tamane ge tinane hedi labe kaiwane, hu nga i dohob ege hebe taine i degiyau heidiye ge taine i dehawatau-yanid tamane ge tinane. Humiu hu nga bosowaine ege i liwo heidiye i nga, ‘Bigibigi gane tage a egiyau heimiu hobak a siloyan Helak heine, iye te kaiwane taine a degiyau.’ Hu liwo sohode ti yo, age hu sepalongani Helak wana logugui ge hu gorugoru totomiu he lemi papalapu hei gane i hudi he-tutubumiu heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Toyoyokapis humiu! Profet Aiseya i govetahe ege, veto i luluweli-yan kaiwamiu sohode ti ya: Helak i nga, ");
INSERT INTO nmws_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bobode ya si hawatau-yanau he hawadiye dimwene, age hatiyediye hana bwage i mwalao heyau. ");
INSERT INTO nmws_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wedi tapwalolo heyau sohode ege bigi bwage, si papalapu-yan bobode wedi nuwotu tage nau lo logugui.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yeisu i gon paseid boda si lok heine, habeto nime sawisawi lihuine i gopawayae heidiye i nga, “Gen hu padavae iloke nuwamiu i sapu! ");
INSERT INTO nmws_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gane i setuk he hawade taine i depabikide, agegene gane i setagim he hawade iye te i pabikide.” ");
INSERT INTO nmws_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Habe wana topadavae si luwom heine ge si nga, “Tab u lapu lam lihulihu ya i leme Farisi hatiyediye?” ");
INSERT INTO nmws_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeisu i golase halingadiye i nga, “Bwele si puik yok bigi hohoyowate gane Tamau he bulubulu taine i devahi. ");
INSERT INTO nmws_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hu hoteiid! Sidiye todedei-yan matadiye ginginine. Hebe tomatagin i dedeiyan wana pan tomatagin, bwele si toiwo si sopiyele he goi.” ");
INSERT INTO nmws_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita i nga, “Gohalibe ga-ne gen u pawayae heyai.” ");
INSERT INTO nmws_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Habeto Yeisu i liwo heidiye i nga, “Age habe taine nuwamiu i desapu? ");
INSERT INTO nmws_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Age taine hu delapu gane i setuk he hawade i dok he tiniyede habeto i setagi he tuwade? ");
INSERT INTO nmws_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Agegene gane i setagim he hawade, i hudi he hatiyede, iyete iye i pabikide. ");
INSERT INTO nmws_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaiwane nuwotu ngakngakine i setagim he hatiyede: sohode taurol, ganawal, dudubwale, bwahiyewo, pwapwatim yoyokapisi ge loblobae. ");
INSERT INTO nmws_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sidiye te i pabikide; age hebe taine ta desawi nimade ge ta hanhan taine i depabikide.” ");
INSERT INTO nmws_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeisu i seyok hiyebe yake, ge i lok i la Taya ge Saidon he wedi ganahao. ");
INSERT INTO nmws_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Keinan vainiine hotiya i miyemiye te he ganahao yake, iye taine Isrel vainiine sohode. I luwom Yeisu heine ge i gongon i nga, “Guyau, Deivid Tubune, u nuwalolu-yanau! Kaiwane yayaluwo bikbikine i solavi natu vainiine heine ge i papatilao-yan suwok.” ");
INSERT INTO nmws_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yeisu taine i degolase halingane, taine lihu hotiya i delihuyan. Habe wana topadavae si luwom heine ge si gogaigaisi heine si nga, “Vaini tei u patile yok, kaiwane i sesegongon he muide.” ");
INSERT INTO nmws_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bwen Yeisu i liwo i nga, “Tamau i patileyau a luwom boda Isrel wedi sip haohaoidiye ege kaiwadiye.” ");
INSERT INTO nmws_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bwen vaini yake i luwom ge i lipwakoko heine ge i nga, “Guyau, u labeyau.” ");
INSERT INTO nmws_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeisu i golase halingane i nga, “Anamate taine i desapu hebe a labeiwo. Taine bosowaine ta dehowo bubuyese nahadiye ge ta debili yok hehewo heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bwen vaini yake i nga, “Bam, Guyau. Agegene hehewo si han haga mumine, gane i sopiyele tutuidiye he wana teibol i dobu he bwarad, iyete bosowaine ege u labeyau.” ");
INSERT INTO nmws_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Habeto Yeisu i nga, “Vaini, lam goru i kai. Bwele i youmate sohode lam nuwotu.” Ge he sauge yake natune i molu. ");
INSERT INTO nmws_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeisu i seyok hiyebe yake ge i la i dodogan he Soge Galili hadidine. Habeto i la i sesai he bobokun ge i tuwodau. ");
INSERT INTO nmws_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Habe boda non lak si luwom heine ge si yomo luwom tobolebole hoyowate, hebwaden tosesetuhetuhe, tomatagin, hebwaden hehediye i kom, hebwaden tan halingadiye ge topadine hedi, bwen si yomoteiid Yeisu he hehene ge i pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bobode nuwadiye si hape, kaiwane si paidi hebwaden tan halingadiye si lihu, hebwaden hehediye i kom si pasapu, tosesetuhetuhe si dodogan vetahe ge tomatagin matadiye si palale. Iyete heine si tobalan Isrel wedi Helak. ");
INSERT INTO nmws_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yeisu i gon paseid wana topadavae si luwom heine, habe i nga, “Bobode ya nuwau i ngakanid, kaiwane yan ho-tuwon he-bwaide ta miye, ge hobak taine nahadiye i degan. Taine nuwau sohode bubuwotaidiye ge a patile pahavileid, kaiwane hebe tuwadiye i yaroyaro he hiyede.” ");
INSERT INTO nmws_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wana topadavae si liwo heine si nga, “Hiyebe ya i mipabwagebwage, bwele ta howo haga i gohoi ge boda ya ta pahanid?” ");
INSERT INTO nmws_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Habeto Yeisu i tayakid i nga, “Bred pwahi-piye heimiu?” Si nga, “Pwahi-pik (7) ge yalogi tankaikai bunum-iwo ege.” ");
INSERT INTO nmws_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","I liwo boda si tuwodau he kelekele, ");
INSERT INTO nmws_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","habeto i yomo bred pwahi-pik bwaine yalogi, ge i gomulolu Helak heine, i pieneene-yan, bwen i giyau wana topadavae heidiye ge si talaotan bobode heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bwabwaligadiye si han tine sus, habe wedi han tuwoi topadavae si bagavetahe, hana yogowo nabwa-pik. ");
INSERT INTO nmws_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bobode henebwaden si hanhan hedi hohoyowate po tausan, agegene taine si dehowo venakau ge gamagai hedi hohoyowate. ");
INSERT INTO nmws_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yeisu i patileid boda si yogo, bwen i sai he wage i la Magadan he hana ganahao. ");
INSERT INTO nmws_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisi ge Sadiusi topadine si luwom Yeisu heine, nuwadiye si hamnohon, iyete si nga, “Gen u ginawi pamali yauyawate hotiya, iloke ha lapu tolosuwok lam gaisi i hudi Helak heine.” ");
INSERT INTO nmws_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yeisu i golase halingadiye i nga, “Hebe parae wana sauge dobiyek bwen hu nga, ‘Beniyan i mahave, kaiwane bulubulu i dabarairai,’ ");
INSERT INTO nmws_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ge hebe henanai bwen hu nga, ‘Bwele wesi i dau, kaiwane bulubulu i dabarairai ge i tege.’ Bosowaimiu bulubulu hana hao hu yeuneyan ge hu lapu, age sauge gane Helak i hotei hana hetutuhi taine bosowaimiu hana hao hu deyeuneyan ge hu delapu. ");
INSERT INTO nmws_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sai yauyauleine humiu, taine hu demiyemiye Helak heine, iyete nunuwamiu hetutuhi a ginawi kaiwamiu. Agegene taine hetutuhi hotiya bwele a degiyau heimiu, iyege yete gane i youmate profet Jona heine. Sohode hedi, nau bwele a suwoyuk hedi.” Habeto Yeisu i seyokid ge i yogo. ");
INSERT INTO nmws_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sauge si hadopanek, topadavae si nuwodon taine bred hotiya si delohowo. ");
INSERT INTO nmws_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeisu i liwo heidiye i nga, “Matamiu i mwaun ge hu yehemiu Farisi ge Sadiusi wedi yis kaiwane.” ");
INSERT INTO nmws_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Topadavae si pelihulihu-yanid si nga, “I liwo sohode ti yo kaiwane taine ta deholuwom bred hotiya.” ");
INSERT INTO nmws_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeisu i lapu ege wedi lihu, bwen i liwo heidiye i nga, “Lemi goru taine i dekai! Mwatan ge hu pelihulihu-yanmiu bred kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Age habe taine nuwamiu i desapu? Tab hu nuwohasik veto a pieneene-yan bred pwahi-lime bobode paib tausan kaiwadiye? Han tuwoi hana yogowo nabwa-piye hu howo? ");
INSERT INTO nmws_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tab hu nuwohasik veto a pieneene-yan bred pwahi-pik (7) bobode po tausan kaiwadiye? Han tuwoi hana yogowo nabwa-piye hu howo? ");
INSERT INTO nmws_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mwatan ge nuwamiu taine i desapu nau taine a delihulihu heimiu bred kaiwane? Agegene nau a nga, ‘Hu yehemiu Farisi ge Sadiusi wedi yis kaiwane.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Habeto topadavae si lapu taine i delihulihu tage si yeheid yis gane bred kaiwane, agegene i nga si yeheid Farisi ge Sadiusi wedi papalapu kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yeisu i lok i la hiyebe Sesariya Filipai he hana ganahao, habeto i gotayakid wana topadavae totone lihuine, i nga, “Bobode si nga tage Tolomo Natune iye sega?” ");
INSERT INTO nmws_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bwen si golase halingane si nga, “Topadine si nga huwo Jon Tobaptais, topadine si nga huwo Ilaija, ge papaine hedi si nga huwo Jeremaiya o hebe profet hotiya hedi.” ");
INSERT INTO nmws_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I liwo heidiye i nga, “Age humiu, hu nga tage sega nau?” ");
INSERT INTO nmws_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita i golase halingane i nga, “Huwo Mesaiya, Helak yawedine ganganine Natune.” ");
INSERT INTO nmws_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeisu i liwo heine i nga, “Saimon Jona natune, Helak i muloluyaniwo! Kaiwane nuwotu ga ya bobode he panayawi taine si degiyau heim, agegene Tamau he bulubulu i giyau heim. ");
INSERT INTO nmws_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nau a liwo heim, huwo Pita, iloke he pak ya pwatane bwele a pamidi lo ekalesiya, ge Seitan wana boda taine wedi gaisi tage si dekai lake. ");
INSERT INTO nmws_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bwele a giyau heim Helak wana bagalogugui hana ki; iloke heto sahe gane u tepahad he panayawi, bwele Helak i tepahad he bulubulu, ge heto sahe gane u taeman he panayawi, bwele Helak i taeman he bulubulu.” ");
INSERT INTO nmws_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Habeto Yeisu i gopagaisiid wana topadavae tab tolomo hotiya wana wase si egiyau tage iye Mesaiya. ");
INSERT INTO nmws_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","He sauge ga yake ge i lok, Yeisu i gopayoumate wana topadavae heidiye i nga, “Gen a la Jerusalem, iloke Judiya wedi todedei, topowo lalahine ge Logugui hana topapalapu bwele si patilao-yau suwok, habe bobode si lopamateyau bwen he yan ho-tuwonine a suwoyuk hedi.” ");
INSERT INTO nmws_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita i sehape Yeisu si la si mivevek, bwen i topahad i nga, “Guyau, tab sohode ti yo! Bigi ya tab i eyoumate heim.” ");
INSERT INTO nmws_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Habeto Yeisu i galahaik, i liwo Pita heine i nga, “Seitan, u miyokau! Huwo sohode bagasopiyele heyau, kaiwane lam nuwotu taine i delok Helak he wana nuwotu, age i lok bobode he wedi nuwotu.” ");
INSERT INTO nmws_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Habeto Yeisu i liwo wana topadavae heidiye i nga, “Hebe hotiya nuwane i dumuyai heyau, gen i boleu totone wana dohob, i hiyewo wana koros ge i dumuyai heyau. ");
INSERT INTO nmws_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kaiwane sega hebe nuwane totone yawedine i pwamwad, bwele i supwahao, agegene sega hebe yawedine i supwahao nau kaiwau, bwele yawedine i paidi. ");
INSERT INTO nmws_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mwatan hana dohob hebe tolomo hotiya i howo panayawi bwabwaligane i logugui-yan, agegene yawedine suwok i supwahao. Taine bosowaine bigi hotiya i dehowo ge i depamaise pahavile yawedine. ");
INSERT INTO nmws_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kaiwane Tolomo Natune i eluwom bwaine Tamane wana wasewase ge he-bwaine wana anelose-yan, habeto i giyau bobode hoyowate maisadiye sohode he wedi ginawi. ");
INSERT INTO nmws_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tolosuwok a liwo heimiu, bobode topadine sidiye mwage he ya gen si paidi Tolomo Natune i eluwom bwaine ge wana logugui, muyai habe si mate.” ");
INSERT INTO nmws_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yan ho-wone (6) i mwao, bwen Yeisu i sehapeid Pita, Jems ge havane Jon, sidiye ege he-bwaine si la si tihe sai he bobokun mimisaiine. ");
INSERT INTO nmws_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Habe hana hao sesevevekine i youmate he matadiye. Mangingine i tale sohode parae ge hana kaliko i kanekane ge i piklame suwok. ");
INSERT INTO nmws_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bwen topadavae si he-tuwon si paidi Moses ge Ilaija si youmate, ge bwaidiye Yeisu si lihulihu. ");
INSERT INTO nmws_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Habe Pita i liwo Yeisu heine i nga, “Guyau, i dohob te hide mwage he ya. Hebe nuwam, bwen lun ho-tuwon a ginawiid, hotiya huwo, hotiya Moses, ge hotiya Ilaija.” ");
INSERT INTO nmws_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Saugeine Pita mwage i lihulihu, habe yaluyalu kanekaneine i yabomid, bwen halhalinge hotiya i hudi he yaluyalu i nga, “Ga yetei natu nunuwaneine suwok; a yariyae suwok iye kaiwane. Halingane gen hu longe!” ");
INSERT INTO nmws_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sauge topadavae si longe halhalinge ya, bwen si matok suwok ge si tiyepwahem he kelekele. ");
INSERT INTO nmws_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeisu i luwom heidiye, i bwangeid ge i nga, “Hu suwoyuk. Tab matok.” ");
INSERT INTO nmws_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Saugeine matadiye si lisin, taine tolomo hotiya si depaidi, Yeisu i totiya ege. ");
INSERT INTO nmws_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sauge si sesedom he bobokun, bwen Yeisu i liwo heidiye i nga, “Tab hu egiyau tolomo hotiya wana wase heto sahe gane hu paidi kaiwane, hana had Tolomo Natune i suwoyukim he mate.” ");
INSERT INTO nmws_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bwen topadavae si tayak Yeisu si nga, “Sahe kaiwane Logugui hana topapalapu si nga tage Ilaija bwele i eluwom dei, muyai habe Mesaiya i luwom?” ");
INSERT INTO nmws_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeisu i golase halingadiye i nga, “Tolosuwok Ilaija bwele i eluwom dei, iloke bigi hohoyowate i bagavetahe. ");
INSERT INTO nmws_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Age a liwo heimiu, Ilaija hobak i luwom mwao, agegene bobode taine si delapu, iloke bigi hebwaden si nuwotuyan si ginawi ege heine. Sohode hedi, Tolomo Natune bwele habe si patilao.” ");
INSERT INTO nmws_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Habeto topadavae si lapu age Jon Tobaptais lihuine te i nga, “Ilaija hobak i luwom mwao.” ");
INSERT INTO nmws_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sauge si sehavile si la boda heidiye, habe tolomo hotiya i luwom Yeisu heine, i lipwakoko he hana hao ");
INSERT INTO nmws_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ge i nga, “Guyau, gen u hatatilao-yan natu. I kikiwosi ge i nuwale suwok. Sauge i hoyowate i sopiyele he hiwo o hebe he bwai. ");
INSERT INTO nmws_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A ho luwom lam topadavae heidiye, agegene taine bosowaidiye si depamolu.” ");
INSERT INTO nmws_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Habe Yeisu i nga, “Aa humiu, taine lemi goru i degan ge nuwotu bwabwaligane hu pi vevekan! Hobak sauge i mwalao te he-bwalu humiu ta miyemiye he ya! Pe-piye a palahasik kaiwamiu? Sevai yake hu ho luwom heyau.” ");
INSERT INTO nmws_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yeisu i liwo yayaluwo bikbikine heine bwen i setagi, ge petaege sevai yake i molu. ");
INSERT INTO nmws_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Habeto topadavae sidiye ege si luwom Yeisu heine ge si tayak si nga, “Sahe kaiwane hamai taine bosowaimai ha deliwo ge yayaluwo bikbikine i desetagi?” ");
INSERT INTO nmws_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","I golase halingadiye i nga, “Kaiwane taine lemi goru i dekai. Tolosuwok a liwo heimiu, hebe lemi goru i gan, bwagane i tankai sohode hayao pwatumine, bosowaimiu hu liwo bobokun ya heine hu nga, ‘U miyok habam, u la he yake,’ bwen i ginawi sohode. Hebe lemi goru i gan, taine bigi hotiya bwele i depuyowo tage taine bosowaimiu hu deginawi. ");
INSERT INTO nmws_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Age yayaluwo bikbikine sohode ti yake taine bosowaine ta deliwo i desetagi, iyege te hebe ta hawanun ge ta palahasik buwota hawanun yake kaiwane.” ");
INSERT INTO nmws_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Saugeine topadavae si luwom si mipase Galili, habe i liwo heidiye i nga, “Hawesine ege bwen Tolomo Natune si taeman bobode he nimadiye, ");
INSERT INTO nmws_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iloke si lopamate ge he yan ho-tuwonine bwele i suwoyuk hedi.” Bwen topadavae nuwadiye i ngak suwok. ");
INSERT INTO nmws_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Saugeine Yeisu he-bwaine wana topadavae si luwom Kapeniyam, Guwole Gagabubine hana takis hana tohowo si luwom si tayak Pita si nga, “Age lemi topapalapu taine i edepamaise Guwole Gagabubine hana takis?” ");
INSERT INTO nmws_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita i golase halingadiye i nga, “Taine! I epampamaise ege.” Habe Pita i la i setuk he guwole. Habe taine i delihuyan lihu hotiya, bwen Yeisu i liwo dei heine i nga, “Saimon, mwatan lam nuwotu? Panayawi hana kin-yan si howo takis segawai heidiye—he-nanatudiye heidiye o hebe mwage bobode papaine heidiye?” ");
INSERT INTO nmws_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita i golase halingane i nga, “Mwage bobode papaine heidiye.” Bwen Yeisu i nga, “Iyete taine bosowaine kin he-nanatune si depamaise takis. Sohode hedi, akum nau tab a epamaise takis Tamau wana guwole kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Agegene tab Guwole Gagabubine hana takis hana tohowo ta epahugeid. U lok u la he soge bwen lam yao u bili donge. Yalogi gane u kos deiyan u howo, u pisae gamwane, iloke u paidi mwani wana kaikai i bosowaine wada takis. U howo, u la u pamaise huwo ge nau wada takis.” ");
INSERT INTO nmws_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","He sauge yake topadavae si luwom Yeisu heine ge si tayak si nga, “Sega hidane i kai Helak he wana bagalogugui?” ");
INSERT INTO nmws_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Habe Yeisu i gonan memai tankai hotiya ge i pamidi he matadiye, ");
INSERT INTO nmws_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","bwen i liwo heidiye i nga, “Tolosuwok a liwo heimiu, hebe taine hu depi lemi page ge humiu sohode gamagai tankaikai, taine bosowaine bwele hu desetuk Helak he wana bagalogugui. ");
INSERT INTO nmws_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sega hebe i hodonge totone sohode memai ya, iye hidane i kai Helak he wana bagalogugui. ");
INSERT INTO nmws_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ge sega hebe he hidau heine i gon pase memai hotiya sohode ya, iye i gon paseyau. ");
INSERT INTO nmws_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Hebe ta lokin pak pupuyowane tolomo he dumuwone ge ta bili donge he toi ge i matadau, pepelase ga yake taine i dekai suwok. Age sega hebe i pagegi totankainane hotiya sohode memai ya gane i goruim heyau ge i sopiyele, Helak bwele i giyau lase lahine suwok tolomo yake heine. ");
INSERT INTO nmws_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eeu, panayawi geb! Panayawi i ngak kaiwane bigi hebwaden si pagegiid bobode si hoyowate. Tolosuwok bigi sosohode-yan ti yo si youyoumate, agegene sega gane hedi topayoumate, iye hana pepelase bwele i kai. ");
INSERT INTO nmws_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Hebe nimam hotiya o hebe hehem hotiya i pagegiiwo, u gotem yok. I dohob te hebe nimam hotiya o hebe hehem hotiya taine i degan ge u paidi yawed suwok, tab nimam ho-iwo ge hehem ho-iwo si ebili tukaniwo he hiwo mimisuwokine. ");
INSERT INTO nmws_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hebe matam hotiya i pagegiiwo, u pak yok. I dohob te hebe matam hotiya ge u paidi yawed suwok, tab matam ho-iwo si ebili tukaniwo he hel hiwoine. ");
INSERT INTO nmws_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Hu yehemiu tab gamagai tankaikai ya hotiya hu ehite donge. Kaiwane a liwo heimiu, wedi anelose-yan sauge hohoyowate si emiyemiye Tamau he bulubulu he mangingine. ");
INSERT INTO nmws_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tolomo Natune i luwom tosehao-yan i pwamwadid. ");
INSERT INTO nmws_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mwatan lemi nuwotu? Hebe tolomo hotiya wana sip hosangak (100) ge hotiya i sehao, mwatan i ginawi pagan? Bwele naenti naen i seyokid si miyemiye he bobokun, bwen i la i luweni sip gane i sehao. ");
INSERT INTO nmws_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tolosuwok a liwo heimiu, sauge hebe i paidi, wana yariyae i kai suwok sip hotiya ege ya kaiwane, wana yariyae taine i dekai suwok hebwaden naenti naen kaiwadiye hebwaden taine si desehao. ");
INSERT INTO nmws_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ge sohode hedi, Tamamiu he bulubulu taine wana nuwotu sohode tage totankainane ya hotiya bwele i sehao. ");
INSERT INTO nmws_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Hebe havam i ginawi page ngakngakine heim, u lok u la heine ge hu toiwo ege, wana ngak u gopayoumate heine. Hebe i longe halingam, havam hobak u ho pahavile. ");
INSERT INTO nmws_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Agegene hebe taine i delonge halingam, habeto tolomo hotiya o si he-iwo he-bwaim hu lok heine, iloke sohode Moses wana logugui: bobode si toiwo o si he-tuwon si liwo, ‘Bam, ha paidi,’ muyai habe pwapwatim ta patolosuwok. ");
INSERT INTO nmws_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hebe sidiye halingadiye taine i delonge, habe u gopayoumate toekelesiya heidiye. Hebe toekelesiya halingadiye taine i delonge, bwen hana nuwotu u ginawi sohode iye tosesebwage o hebe takis hana tohowo hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tolosuwok a liwo heimiu, heto sahe gane hu tepahad he panayawi bwele Helak i tepahad he bulubulu, ge heto sahe gane hu taeman he panayawi bwele Helak i taeman he bulubulu. ");
INSERT INTO nmws_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A liwo heimiu, hebe hu toiwo lemi nuwotu i hotaege ge hu hawanun bigi hotiya kaiwane, Tamau he bulubulu bwele i ginawi sohode kaiwamiu. ");
INSERT INTO nmws_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kaiwane hebe hu toiwo o hu he-tuwon hu mipase he hidau heine, nau mwage bwaimiu.” ");
INSERT INTO nmws_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Habe Pita i luwom Yeisu heine ge i gotayak i nga, “Guyau, hebe havau i ginawi page ngakngakine heyau, bwele pe-piye a nuwoyok wana ngak? Age sowane pape-pik (7)?” ");
INSERT INTO nmws_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeisu i golase halingane i nga, “Tab u enuwoyok pape-pik ege, agegene u nuwoyok pape-yawate ge sauge hohoyowate. ");
INSERT INTO nmws_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Helak wana bagalogugui pageine sohode ti ya. Kin hotiya nuwane wana tokaiwo si pamaise pahavile hedi vage heine. ");
INSERT INTO nmws_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sauge i telipune kaiwo yake, tolomo hotiya si ho luwom hana vage hana kai sohode kina hedi hohoyowate miliyon hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Taine bosowaine i depamaise, habeto wana gamalak i liwo gen wana bigibigi bwabwaligane ge iye he-bwaine ge he-nanatune si paliyanid ge si tabwa tokaiwo yayawanidiye, habeto bwele i howo mwani ge i lake yok hana vage. ");
INSERT INTO nmws_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tokaiwo i lipwakoko he matane, bwen i hawanun gaigaisi i nga, ‘Gen u palahasik ge u matemate, habe bwabwaligane a pamaise.’ ");
INSERT INTO nmws_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wana gamalak i hatatilao-yan, habeto i nuwoyok hana vage ge i piyok i yogo. ");
INSERT INTO nmws_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sauge tokaiwo yake i setagi, i paidi wana pan tokaiwo hotiya, gane hana vage i gan heine hana kai sohode kina pwahi-iwo ege. I bwange hasik he dumuwone ge i nga, ‘Ham vage u pamaise heyau.’ ");
INSERT INTO nmws_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bwen wana pan tokaiwo i lipwakoko ge i hawanun gaigaisi i nga, ‘Gen u palahasik ge u matemate, habe a pamaise.’ ");
INSERT INTO nmws_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Agegene i boleu, bwen i liwo ge si ho tukan he dibula hana had hebe hana vage i pamaise. ");
INSERT INTO nmws_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tokaiwo topadine hedi si paidi bwaidiye i ginawi page ngakngakine bwaine heine. Nuwadiye i ngak suwok, bwen si lok si la wedi gamalak heine ge bigi bwabwaligane si waseyan. ");
INSERT INTO nmws_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Wedi gamalak i gon tokaiwo yake heine ge i nga, ‘Tokaiwo boliboliine huwo. Ham vage bwabwaligane heyau hobak a nuwoyok, sohode lam hawanun heyau. ");
INSERT INTO nmws_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Akum huwo hedi u hatatilao-yan bwaim, sohode nau a hatatilao-yaniwo.’ ");
INSERT INTO nmws_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wana gamalak i huge bwen i patile si ho tukan he dibula, iloke bwele i paidi lase hana had hebe i pamaise hana vage.” ");
INSERT INTO nmws_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Habeto Yeisu i nga, “Tamau he bulubulu bwele i ginawi heimiu sohode hedi ti yo, hebe taine hu denuwoyokid he-hauhavamiu wedi ngak he hatiyemiu.” ");
INSERT INTO nmws_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Saugeine Yeisu i gomwao lihulihu ya, habeto i seyok ganahao Galili ge i lok i la Judiya he wana ganahao gane bwai Joden kimwine natek. ");
INSERT INTO nmws_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Boda non lak si sedumuyai hei, bwen tobolebole hoyowate i pamoluid he ganahao yake. ");
INSERT INTO nmws_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisi topadine si lok heine tage si ehamnohon, iyete si tayak si nga, “Tab wada logugui i taem tolomo bosowaine i boleu poniyene, hebe i nuwotu paidi boluwo pakene hotiya?” ");
INSERT INTO nmws_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I golase halingadiye i nga, “Age he Buk Bwabwalene taine hu depahone te he bagatelipune hei Toginawi ‘i pamaliid bobode tolomo ge vaini’? ");
INSERT INTO nmws_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ge i liwo sohode, ‘Iye te kaiwane tolomo gen i miyokid tamane ge tinane i la bwaine ge poniyene si mipase, iloke si toiwo si tabwa tutuwo hotaege.’ ");
INSERT INTO nmws_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iloke sidiye taine hedi si detoiwo, agegene sidiye si tabwa sohode hotaege. Helak hobak i tubwenid toyao, iyete tab tolomo hotiya i emwanalakeid.” ");
INSERT INTO nmws_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Habeto Farisi si tayak si nga, “Huwo u liwo sohode ti yo, age sahe kaiwane Moses wana logugui i liwo tolomo i giyau boluwo hana pepa poniyene heine, iloke habe i patile yok ge i yogo?” ");
INSERT INTO nmws_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeisu i golase halingadiye i nga, “Kaiwane hatiyemiu i pak ge hemi papalapu i puyowo suwok, iye te kaiwane Moses i taeman ge hu boleuid he-ponponiyemiu. Age he bagatelipune hei taine hana logugui sohode ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A liwo heimiu, hebe tolomo hotiya i boleu poniyene, bwagane taine i deganawal, ge i hadaenge mwage vaini hotiya, iye hobak i ganawal.” ");
INSERT INTO nmws_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bwen wana topadavae si liwo heine si nga, “Hebe tolomo ge vaini wedi haduwe hana nuwotu sohode yake, i dohoban te tab ta ehaduwe.” ");
INSERT INTO nmws_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeisu i liwo heidiye i nga, “Nuwotu yake taine bobode hoyowate kaiwadiye sohode, iyege yete henebwaden Helak i giyau heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bobode topadine taine bosowaidiye si dehaduwe, kaiwane si habid hedi gide i gan. Topadine taine bosowaidiye si dehaduwe bobode wedi nuwotu kaiwane ge pamali topadine si ginawi heidiye. Ge topadine taine si dehaduwe, kaiwane si pabwabwaleneid Helak wana bagalogugui kaiwane. Sega hebe bosowaine i howo logugui yake, iye i howo.” ");
INSERT INTO nmws_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bobode topadine si sehape luwomid bubuyese Yeisu heine, tage i eho palahe nimane heidiye ge i hawanun kaiwadiye, age wana topadavae si gomamaleke bobode heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Habeto Yeisu i nga, “Bubuyese hu taemanid si luwom heyau, tab hu etopahadid, kaiwane Helak wana bagalogugui i miye sosohode ya heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bwen nimane i ho palahe heidiye ge i hawanun kaiwadiye, habeto i seyok hiyebe yake. ");
INSERT INTO nmws_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tolomo hotiya i luwom Yeisu heine ge i tayak i nga, “Topapalapu, heto pamali dodohobine a ginawi iloke a paidi yawed mimisuwokine?” ");
INSERT INTO nmws_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeisu i golase halingane i nga, “Mwatan ge u tayakau dohob kaiwane? Helak i totaege te iye todohob suwok. Hebe nuwam yawedim u paidi, gen u senapuyan wana logugui.” ");
INSERT INTO nmws_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Bwen tolomo yake i tayak i nga, “Heto logugui-yanid?” Yeisu i nga, “Tab taurol, tab ganawal, tab bwabwahiyewo, tab pwapwatim yoyokapis, ");
INSERT INTO nmws_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","u hawatau-yanid tamam ge tinam, ge u nunuwane-yan bwaim sohode totom u nunuwane-yaniwo.” ");
INSERT INTO nmws_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bwen tolomo yake i liwo heine i nga, “Hebwaden ya bwabwaligane hobak a pabwasowoid. Heto sahe hedi a kwaleyan?” ");
INSERT INTO nmws_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeisu i golase halingane i nga, “Hebe nuwam u tabwa todohob suwok, u la gen u paliyanid lam gogomwau, ge u giyau mwaniine togulegule heidiye, iyete bwele u gogomwau he bulubulu. Habeto u luwom ge u dumuyai heyau.” ");
INSERT INTO nmws_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Saugeine tolomo yake i longe lihulihu ya, bwen i yogo bwaine wana nuwongak, kaiwane iye togogomwau. ");
INSERT INTO nmws_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bwen Yeisu i liwo wana topadavae-yan heidiye i nga, “Tolosuwok a liwo heimiu, togogomwau wedi setuk i puyowo Helak he wana bagalogugui hei. ");
INSERT INTO nmws_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A liwo hedi heimiu, i puyowo te man kamel i sesole he sinai goine, agegene i puyowo suwok tologogomwau wedi setuk Helak he wana bagalogugui hei.” ");
INSERT INTO nmws_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Sauge topadavae si longe lihulihu ya, hatiyediye i youhan suwok bwen si tayak si nga, “Hebe sohode, sega ege bosowaine i mwad?” ");
INSERT INTO nmws_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeisu i lihasik matane heidiye ge i nga, “Bigi yake bobode taine bosowaidiye, age Helak bigi bwabwaligane bosowaine.” ");
INSERT INTO nmws_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bwen Pita i liwo heine i nga, “Age mwatan hamai? Lama bigibigi bwabwaligane hobak ha seyokid, iloke ha luwom ha dumuyai heim. Sahe bwele habe i gan kaiwamai?” ");
INSERT INTO nmws_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeisu i liwo heidiye i nga, “Tolosuwok a liwo heimiu, sauge Tolomo Natune i tabwa kin he panayawi tovevai hei ge i miye he wana bagatuwodau wasesaseine, humiu ho todumuyai hu he-yawate hu he-iwo (12) habe hu miye he tologugui wedi bagatuwodau ge Isrel hedi hun si hun-yawate si hun-iwo (12) hu logugui-yanid. ");
INSERT INTO nmws_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sega hebe hidau kaiwane ge i seyokid wana guwole, hebe he-hauhavane, o he-lulune, o tamane, o tinane, o hebe he-nanatune, o hebe wana poepoe, bwele i ho pakai hedi he pwatane, ge i paidi yawedine mimisuwokine. ");
INSERT INTO nmws_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Agegene hebwaden sauge ya si midei, bwele si hoyowate si midumuyai, ge hebwaden sauge ya si midumuyai, bwele si hoyowate si midei.” ");
INSERT INTO nmws_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Helak wana bagalogugui sohode ti ya. Tolomo hotiya henenai suwok i setagi i pataemid bobode topadine ge si la si kaiwo he wana greip hana baguye. ");
INSERT INTO nmws_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I liwo heidiye i nga, “Yan ya bwele a pamaisemiu silba pele-tiya sohode yan hotiya maisane.” Sidiye si nga, “I dohob,” habeto i patileid si la si kaiwo he wana greip hana baguye. ");
INSERT INTO nmws_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","He naen oklok i setagi hedi, i paidiid bobode topadine si midimidi he bagamaket, si mimibwage ege. ");
INSERT INTO nmws_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Bwen i liwo heidiye i nga, “Humiu hedi, gen hu la hu kaiwo he lo greip hana baguye, iloke a giyau vetahe maisamiu, taine bwele a deginawi pangak heimiu.” ");
INSERT INTO nmws_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bwen si lok. Parae luwane ge he tri oklok i setagi ge i ginawi sohode hedi. ");
INSERT INTO nmws_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hawesine ege paib oklok bwen i setagi hedi ge i paidiid bobode topadine si midimidi. Bwen i tayakid i nga, “Sahe kaiwane hu midimidi he ya, yan bwabwaligane hu mimibwage ege?” ");
INSERT INTO nmws_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Si golase halingane si nga, “Kaiwane taine tolomo hotiya i deyomoyai kaiwo kaiwane.” Bwen i liwo heidiye, “Humiu hedi, gen hu la hu kaiwo he lo greip hana baguye.” ");
INSERT INTO nmws_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hobak i kokoyavi suwok, baguye tonuwage i liwo tokaiwo hedi tomatahasik heine i nga, “U gonid tokaiwo ge maisadiye u giyau, u telipune hebwaden a bigi dumuyaiid heidiye ge u pwamwao henebwaden ga a bigi deiyanid heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hebwaden si kaiwo telipune paib oklok kokoyavi si luwom ge si howo maisadiye hana kaikai sohode yan bwabwaligane maisane, si lotomase silba pele-tiya ngangane. ");
INSERT INTO nmws_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Iyete sauge hebwaden i bigi deiyanid si luwom, si nuwotu tage bwele maisadiye si eho pakai, age sidiye hedi, bwabwaligadiye si ho silba pele-tiya ngangane. ");
INSERT INTO nmws_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Saugeine maisadiye si howo, bwen si telipune si lobaeyan baguye tonuwagane, ");
INSERT INTO nmws_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","si nga, “Bobode hebwaden u bigiid dumuyai ya, si kaiwo patanmwalao, age hamai he parae rarareine ha logaisi he yan bwabwaligane, bwen u pamaiseyai sohode hedi sidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","I golase halingadiye ge i liwo bwaidiye hotiya heine i nga, “Heliya, taine a deginawi pangak heim. Wente u taeman yan bwabwaligane u kaiwo maisam silba pele-tiya, age? ");
INSERT INTO nmws_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Maisam u howo ge u yogo. Nuwau tolomo gane a howo muyai maisane a giyau heine sohode hedi a giyau heim. ");
INSERT INTO nmws_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Age tage tan bosowaiu totou lo mwani a dehowo ge a deginawi sohode sahe a nuwotuyan, ine? Nau a muloluyanid bobode, mwatan ge u yamwakabu-yanau?” ");
INSERT INTO nmws_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bwen Yeisu i nga, “Sohode ti yo, hebwaden sauge ya si midumuyai bwele si midei, ge hebwaden sauge ya si midei bwele si midumuyai.” ");
INSERT INTO nmws_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sauge Yeisu i ela Jerusalem kaiwane, i sehapeid wana topadavae si he-yawate si he-iwo (12), iloke sidiye ege habe i lihulihu heidiye i nga, ");
INSERT INTO nmws_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hobak ta ela Jerusalem kaiwane, iloke Tolomo Natune bwele si taeman topowo lalahine ge Logugui hana topapalapu he nimadiye. Iye hana logugui bwele si ginawi gen i mate ");
INSERT INTO nmws_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ge si hotei hebwaden taine Judiya-yan sohode he nimadiye. Bwen sidiye si yamwa tunetune-yan, si rabrabik-an ge si tagakoros-yan. He yan ho-tuwonine habe i suwoyukim he mate.” ");
INSERT INTO nmws_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Habeto Sebedi poniyene i luwom Yeisu heine, he-bwaine he-nanatune bobode si toiwo, Jems ge Jon, ilok i lipwakoko Yeisu he matane ge i hawanun heine. ");
INSERT INTO nmws_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeisu i liwo heine i nga, “Sahe nunuwam?” Bwen vaini ya i nga, “U liwo tei heyau, sauge hebe u howo lam bagalogugui, he-nanatu si he-iwo ya si tuwodau he bagamiye hahawatauine, hotiya he lam hinone ge hotiya he lam gegebe.” ");
INSERT INTO nmws_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeisu i liwo heidiye i nga, “Taine hu delapu te sahe hu hahawanun-an. Bosowaimiu ege tilao hana kom gane habe a mun hei bwele hu mun hei?” Si golase halingane si nga, “Bam, bosowaimai ege.” ");
INSERT INTO nmws_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Habeto i liwo heidiye i nga, “Tolosuwok, habe hu mun he lo kom heine, age taine bosowau a deliwo sega bwele i tuwodau he lo hinone o hebe sega i tuwodau he lo gegebe. Bagamiye hebwaden yake Tamau i lovivine-yan henebwaden i haseid ege kaiwadiye.” ");
INSERT INTO nmws_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sauge topadavae si he-yawate (10) si longe wase ya, bwen si hata mamaliye-yanid Jems ge Jon. ");
INSERT INTO nmws_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Habeto Yeisu i gon paseid topadavae si lok heine ge i nga, “Hu lapu, hebwaden taine si degoru Helak heine, wedi tologugui-yan si logugui-yanid ge wedi todedei si pagaisi wedi logugui he-bwaidiye heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Agegene humiu tab sohode ti yake. Sega hebe nuwane hidane i kai he gamwamiu, gen i tabwa lemi tokaiwo. ");
INSERT INTO nmws_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ge sega hebe nuwane sohode todedei, gen i tabwa lemi hepapatile. ");
INSERT INTO nmws_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sohode nau Tolomo Natune taine a deluwom tage hu kaiwo heyau, agegene a luwom gen a kaiwo heimiu, ge a taeman yawediu iloke a pamaise pahavileid bobode si hoyowate.” ");
INSERT INTO nmws_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sauge Yeisu he-bwaine wana topadavae si seyok Jeriko, boda non lak si sedumuyai Yeisu he muine. ");
INSERT INTO nmws_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tomatagin si he-iwo si tutuwodau he hiyede hadidine, ge sauge si longe Yeisu i sehadidiid, bwen si gon si nga, “Guyau, Deivid Tubune, u nuwalolu-yanai.” ");
INSERT INTO nmws_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Boda si goyamwarare-yanid ge si liwo heidiye tage si emipahab, agegene sidiye habe si gon gaigaisi si nga, “Guyau, Deivid Tubune, u nuwalolu-yanai.” ");
INSERT INTO nmws_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yeisu i setalmidi, bwen i gon heidiye ge i tayak i nga, “Sahe nuwamiu a ginawi kaiwamiu?” ");
INSERT INTO nmws_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Si golase halingane si nga, “Guyau, nuwamai u palale matamai.” ");
INSERT INTO nmws_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yeisu i hatatilao-yanid ge i pihasik matadiye, bwen he sauge yake matadiye si palale ge si sedumuyai heine. ");
INSERT INTO nmws_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yeisu ge wana topadavae si sepasepase Jerusalem si sevin Betepage Bobokun Oliv yawanine, bwen i patile deiyanid wana topadavae si he-iwo si dedei. ");
INSERT INTO nmws_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","I liwo heidiye i nga, “Hu lok hu la he yawan gane he matade, bwele hu paidi donki hotiya bwaine ge natune mwage he tei si gasi teid. Hu soheid ge hu pagoluwomid heyau. ");
INSERT INTO nmws_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hebe tolomo hotiya i tayakmiu, bwen hu liwo heine hu nga, ‘Guyau nuwane,’ iloke bwele i taemanid ege.” ");
INSERT INTO nmws_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bigi ya i gan iloke profet wana lihulihu i tabwa tolosuwok gane i nga: ");
INSERT INTO nmws_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Saiyon bobodeidiye wedi wase hu giyau hu nga: Hu paidi, lemi kin i eluwom heimiu. Iye wana page i malum, ge i sai he donki, i sai he donki natune pwatane. ");
INSERT INTO nmws_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bwen topadavae si lok ge si ginawi sohode Yeisu wana lihulihu heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Si pagoluwom donki bwaine ge natune, bwen si veli hedi kaliko he pwatadiye, habeto Yeisu i sesai ge i tuwodau hei. ");
INSERT INTO nmws_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Boda lahine hedi kaliko si veli he hiyede ge papaine hedi si la yaheyahe bwaine damwane si temid ge si veli he hiyede. ");
INSERT INTO nmws_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Habeto boda hebwaden si sedei Yeisu he matane ge hebwaden si sedumuyai he muine si gon si nga: Hosana! Ta tobalan Deivid Tubune! Helak gen i gomulolu-yan, iye i luwom Guyau he hidane hei! Hosana! Helak ta tobalan! ");
INSERT INTO nmws_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sauge Yeisu i setuk Jerusalem, bobode hohoyowate hatiyediye i dayave bwen si tayak si nga, “Sega ti yake?” ");
INSERT INTO nmws_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Boda si golase halingadiye si nga, “Profet Yeisu ti ya, i hudi Nasaret, Galili yawanine.” ");
INSERT INTO nmws_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeisu i setuk he Guwole Gagabubine hana bakubaku, bwen hebwaden si lolopalipali ge hebwaden si lolopampamaise i belenid. Mwani hana topapatad wedi teibol ge hebwaden si palipali bunebune wedi bagatuwodau i yok liyeliyeid. ");
INSERT INTO nmws_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I liwo heidiye i nga, “He Buk Bwabwalene hei Helak wana lihulihu si luluweli-yan i nga, ‘Hu tin lo guwole hidane tapwalolo guwoleine,’ agegene humiu hu ginawi sohode tobwahiyewo wedi bagamiye.” ");
INSERT INTO nmws_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Habeto tomatagin ge hebwaden hehediye ngakngakine si luwom heine he Guwole Gagabubine hana bakubaku, bwen i pamoluid. ");
INSERT INTO nmws_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Agegene topowo lalahine ge Logugui hana topapalapu si paidi pamali yauyawate hebwaden Yeisu i ginawiid, ge sohode hedi si paidi gamagai si gongon he Guwole Gagabubine hana bakubaku si nga, “Hosana! Ta tobalan Deivid Tubune,” bwen si hata mamaliye. ");
INSERT INTO nmws_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Habe si liwo Yeisu heine si nga, “Tab u longe gamagai ya mwatan si gopagan?” Yeisu i golase halingadiye i nga, “Bam. Agegene mwatan humiu? Age taine hu depahone buk gane i nga, ‘Gamagai ge bubuyese hobak hu palapuid iloke si lihuyan ham tobal’?” ");
INSERT INTO nmws_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bwen Yeisu i seyokid ge i setagi Jerusalem i lok i la Beteni ge i hiyene te he yake. ");
INSERT INTO nmws_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Henanai suwok, Yeisu i sehavile i ela Jerusalem kaiwane, bwen i sebuwota. ");
INSERT INTO nmws_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I paidi hibwahi fig pwan-tiya he hiyede hadidine, bwen i lok i la hei nuwane i kibo hinone topadine i han, age taine i depaidi hotiya, damwane hohowane ege. Bwen i golok hibwahi yake heine i nga, “Taine sauge hotiya hedi bwele u edepuwo.” Bwen habekik damwane si rabobu. ");
INSERT INTO nmws_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sauge topadavae si paidi, bwen nuwadiye si hape. Habe si tayak, “Mwatan ge habekik fig ya damwane si rabobu?” ");
INSERT INTO nmws_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeisu i golase halingadiye i nga, “Tolosuwok a liwo heimiu, hebe hu goru ge taine hu denuwo hoihoiwo, bosowaimiu ege te hu ginawi sohode sahe a ginawi hibwahi fig ya heine. Agegene taine bigi yake hotiya ege sohode, bosowaimiu ege hu liwo bobokun ya heine hu nga, ‘U yogo u la totom u bili yokiwo he soge,’ bwele i ginawi sohode. ");
INSERT INTO nmws_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hebe hu goru, heto sahe hu hawanunan Helak heine bwele hu paidi.” ");
INSERT INTO nmws_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeisu i setuk he Guwole Gagabubine hana bakubaku ge i papalapu, habeto topowo lalahine ge hiyebe hana tonuwakau si luwom heine ge si tayak si nga, “Se logugui wana gaisi heine ge bigi hebwaden tei u ginginawi? Sega i giyau lam gaisi?” ");
INSERT INTO nmws_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeisu i golase halingadiye i nga, “Nau hedi gen tayak hotiya a gotayak heimiu. Hebe hu golase, iloke habe a lihuyan heimiu sega wana logugui heine ge bigibigi hebwaden ya a ginginawi. ");
INSERT INTO nmws_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon Tobaptais i pabaptaisid bobode. Logugui yake i hudi igohoi? Helak heine, o hebe bobode heidiye?” Bwen si pelihulihu-yanid si nga, “Hebe ta nga, ‘Logugui yake i hudi Helak heine,’ bwele i nga, ‘Sahe kaiwane ge taine hu degoru Jon heine?’ ");
INSERT INTO nmws_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Age hebe ta nga, ‘Logugui yake i hudi bobode heidiye,’ bwele ta matokanid boda, kaiwane si goru te Jon iye profet.” ");
INSERT INTO nmws_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Habeto si golase Yeisu halingane si nga, “Taine ha delapu.” Bwen i nga, “Hebe taine, nau hedi taine bwele a delihuyan te sega wana logugui heine ge bigi hebwaden ya a ginginawi.” ");
INSERT INTO nmws_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Bwen i golok hedi topowo lalahine ge hiyebe hana tonuwakau heidiye i nga, “Mwatan lemi nuwatu? Tolomo hotiya he-nanatune bobode si toiwo, ilok i la gamahun heine ge i nga, ‘Natu, yan ya gen u la u kaiwo he baguye.’ ");
INSERT INTO nmws_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","I golase tamane halingane i nga, ‘A boleu,’ age muyai habe i pi wana nuwotu ge i lok. ");
INSERT INTO nmws_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tamadiye i la natune ho-iwoine heine ge i liwo hedi, ‘Natu, yan ya gen u la u kaiwo he baguye.’ I golase tamane halingane i nga, ‘Tamau, i dohob, habe a lok,’ agegene taine i delok. ");
INSERT INTO nmws_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Si toiwo ya, sega i patolosuwok tamadiye wana nuwotu?” Si nga, “Gane gamahunine.” Habeto Yeisu i liwo heidiye i nga, “Tolosuwok a liwo heimiu, bobode ngakngakidiye sosohode takis hana tohowo ge venakau hebwaden toganawal, sidiye hobak si etuk Helak he wana bagalogugui, agegene humiu tagi ya mwage hu miyemiye ege. ");
INSERT INTO nmws_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kaiwane Jon Tobaptais i luwom heimiu i palapumiu page dodohobine hana hiyede, bwen taine hu degoru heine, agegene takis hana tohowo ge venakau hebwaden toganawal si goru heine. Ge bwagane hobak hu paidiid sohode ti yake, agegene humiu taine hu depi lemi nuwotu iloke hu goru Jon he wana papalapu.” ");
INSERT INTO nmws_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeisu i nga, “Gen a lihuyan gohalibe hotiya hedi hu longe. Tolomo hotiya i ginawi wana baguye, i vahi greip, i gane painan, bwen i hen goi hotiya greip hinone hana bagapepedonge suine kaiwane, ge i ginawi guwole hotiya baguye hana tomatahasik wedi bagamiye. I ginawi mwao, habe i giyau bobode topadine heidiye ge si pakaiwo, bwen iye i yogo i la mwage he hiyebe hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Sauge greip hinone i mweho, habeto baguye tonuwage i patileid wana tokaiwo si la tomatahasik heidiye, tage greip hinone si ewari, topadine bwele tomatahasik si howo, topadine bwele baguye tonuwage i howo. ");
INSERT INTO nmws_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Agegene tomatahasik si bwangeid tokaiwo; hotiya si rabrabik-an, hotiya si tagapamate ge hotiya si leme he pak. ");
INSERT INTO nmws_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Baguye tonuwage i patileid wana tokaiwo topadine hedi, habe hawesine si hoyowate hedi, bwen tomatahasik si ginawi pageine hotiya ege heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mwaomwaoine, i patile natune heidiye i nga, ‘Bwele si hawatauyan natu.’ ");
INSERT INTO nmws_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Agegene sauge tomatahasik si paidi baguye tonuwage natune, si pelihulihu-yanid si nga, ‘Baguye tonuwage natune ti yeya, gane bwele i howo baguye saugeine tamane wana mate he muine. Hu luwom ta tagapamate, iloke ta howo baguye i miyeim heide.’ ");
INSERT INTO nmws_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bwen si bwange ge si bili tagan he greip hana baguye dedelawiine, ge si tagapamate.” ");
INSERT INTO nmws_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Habeto Yeisu i tayakid i nga, “Sauge hebe baguye tonuwage i sehavileim, bwele mwatan i gino pagan tomatahasik heidiye?” ");
INSERT INTO nmws_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Topowo lalahine ge Farisi si nga, “Bwele i tagapamateid bobode ngakngakidiye ya, bwen wana baguye bwele i giyau mwage tomatahasik topadine heidiye, tomatahasik dodohobidiye hebwaden sauge greip hinone i mweho, bwele si wari vetahe ge hinone gane baguye tonuwage kaiwane si giyau heine.” ");
INSERT INTO nmws_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bwen Yeisu i liwo heidiye i nga, “Age taine hu depahone Buk Bwabwalene hana lihu, gane i nga, ‘Pak gane guwole hana toginawi si hawa ngakngak-an ge si boleu, Helak hobak i hotei he guwole hana kona suwok. Ga yeya iye Guyau wana ginawi, hana paipaidi iye baganuwo hape.’ ");
INSERT INTO nmws_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Iyete a liwo heimiu, bwele habe Helak i ho yok wana bagalogugui humiu Judiya heimiu, ge i giyau bobode heidiye hebwaden yawedidiye hinone dodohobine gane bosowaine bagalogugui yake. ");
INSERT INTO nmws_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sega hebe i sopiyele he pak ya bwele i tiyehoho, ge hebe pak ya i sopiyele tolomo hotiya he pwatane, bwele i tagamukumuku-yan.” ");
INSERT INTO nmws_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sauge topowo lalahine ge Farisi si longe gohalibe hebwaden Yeisu i lihuyanid, si lapu te i lihulihu kaiwadiye. ");
INSERT INTO nmws_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Habeto si luweni hiyede tage si ebwange Yeisu ge si yawan, agegene si matokanid boda, kaiwane bobode si goru te Yeisu iye profet. ");
INSERT INTO nmws_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeisu i gohalibe hedi bobode heidiye i nga, ");
INSERT INTO nmws_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Helak wana bagalogugui sohode ti ya. Kin hotiya i ginawi sagae natune tolomoine wana haduwe kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I patileid wana tokaiwo si la bobode hebwaden i hawanunid heidiye si giyau wedi wase gen si luwom he sagae, agegene bobode yake si boleu. ");
INSERT INTO nmws_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Bwen i patileid wana tokaiwo papaine hedi ge i nga, ‘Hebwaden gane a hawanunid sagae kaiwane, wedi wase hu giyau haga hobak a lovivine-yan. Hu nga: Bulumwakau poseposeidiye hobak ha tuwomid ge hobak ha lovivine-yanid bigibigi hoyowate. Bwen egene hu luwom he sagae.’ ");
INSERT INTO nmws_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Age sidiye taine wedi nuwotu i delok hei, iyete hotiya i la he wana baguye, hotiya i la he wana stowa, ");
INSERT INTO nmws_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ge papaine si bwangeid tokaiwo, si rabrabik-anid ge si tagapampamateid. ");
INSERT INTO nmws_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kin i huge suwok, bwen i patileid wana tosasagiyao si la totaurol si tagapampamateid ge si ton yok habadiye. ");
INSERT INTO nmws_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Habeto i liwo wana tokaiwo heidiye i nga, ‘Haduwe sagaeine hobak a lovivine-yan, age hebwaden a hawanunid si boliboli bwen taine si deluwom. ");
INSERT INTO nmws_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hu la he hede yaheyahe. Hebe segawai hu paidiid, hu liwo heidiye gen si luwom he sagae.’ ");
INSERT INTO nmws_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bwen tokaiwo si lok si la he hiyede-yan ge si sehape luwomid bobode bwabwaligadiye hebwaden si paidiid, dodohobidiye ge ngakngakidiye, habeto sagae guwoleine i susuwoku. ");
INSERT INTO nmws_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sauge kin i setuk he sagae guwoleine ge i paidiid bobode, bwen i hite paidi tolomo hotiya taine i desipo haduwe sagaeine hana kaliko. ");
INSERT INTO nmws_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","I tayak i nga, ‘Heliya, mwatan ge u luwom u setuk ge taine u desipo haduwe sagaeine hana kaliko?’ Age tolomo yake taine i degolase kin halingane. ");
INSERT INTO nmws_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bwen kin i liwo wana tokaiwo heidiye i nga, ‘Hu yawan nimane ge hehene bwen hu bili tagan he gogou, ilok i mimitantan ge ngingine i sangsangapatad.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Habeto Yeisu i nga, “Si hoyowate Helak i gonanid, agegene topadine ege te i haseid.” ");
INSERT INTO nmws_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bwen Farisi si seyok Yeisu si la si nuwotu luweni mwatan bwele si ginawi pagan ge si palohe Yeisu iloke he wana lihulihu heine hana pwapwatim si ginawi. ");
INSERT INTO nmws_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Habeto si patileid wedi bobode topadine si la Yeisu heine, he-bwaidiye ge bobode papaine hebwaden nunuwadiye kin Herodi wana logugui. Si liwo heine si nga, “Topapalapu, ha lapu huwo tolihulihu tolosuwokine ge lam papalapu Helak kaiwane i sapu suwok. Taine u dematokan tolomo hotiya, kaiwane taine u degorugoru bobode wedi sibe hana misai heine. ");
INSERT INTO nmws_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iyete gen u liwo ha longe. Moses i liwo ha giyau mwani Helak heine. Age mwatan lam nuwotu? I dohob ege ha pamaise takis Sisa heine o age tab?” ");
INSERT INTO nmws_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yeisu hobak i lapu wedi nuwotu ngakngakine, bwen i liwo heidiye i nga, “Toyoyokapis suwok humiu! Sahe kaiwane hu hamnohonau tage hu epaloheyau? ");
INSERT INTO nmws_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hu patoheyau mwani hotiya, gane tage takis hu epamaise hei.” Habe si howo mwani silba hotiya si giyau heine i paidi, ");
INSERT INTO nmws_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","bwen i tayakid i nga, “Sega kankanunune ti ya? Ge sega hidane si leli he mwani ya tuwane?” ");
INSERT INTO nmws_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Si golase halingane si nga, “Sisa.” Bwen Yeisu i liwo heidiye i nga, “Gane Sisa kaiwane hu giyau Sisa heine, ge gane Helak kaiwane hu giyau Helak heine.” ");
INSERT INTO nmws_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Si longe wana lihulihu ya bwen nuwadiye si hape, habe si seyok Yeisu ge si yogo. ");
INSERT INTO nmws_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","He yanine ga yake, Sadiusi si luwom Yeisu heine. Sadiusi taine wedi goru tage tomate si suwoyuk, iyete si tayak Yeisu si nga, ");
INSERT INTO nmws_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Topapalapu, Moses i liwo hebe tolomo hotiya i haduwe, taine he-nanatune ge i mate, gen havane i hadaenge hagabwiine ge hebe he-nanatudiye i gan, sidiye si tabwa tolomo gane i mate he-nanatune. ");
INSERT INTO nmws_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Sauge hotiya tolomo hotiya he-bwaine he-hauhavane, hedi hohoyowate si he-pik (7). Gamahun i haduwe, taine he-nanatune, habe i mate, bwen havane i hadaenge hagabwiine. ");
INSERT INTO nmws_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Page hotaege yake i gan hedi ho-iwoine heine, sohode hedi ho-tuwonine, ge sohode hedi hana had bwabwaligadiye si sepale. ");
INSERT INTO nmws_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bwen mwaomwaoine, habe vaini yake hedi i mate. ");
INSERT INTO nmws_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hebe tolosuwok tomate bwele si suwoyuk, ilok suwoyuk he muine si he-pik (7) yake he gamwadiye, sega iye vaini yake mwaniyene suwok? Kaiwane bwabwaligadiye si hadaenge.” ");
INSERT INTO nmws_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeisu i golase halingadiye i nga, “Humiu hu bole suwok, kaiwane taine hu delapu Buk Bwabwalene hana lihu ge Helak wana gaisi. ");
INSERT INTO nmws_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sauge hebe tomate bwele si suwoyuk, sidiye sohode anelose-yan he bulubulu, taine si dehaduwe. ");
INSERT INTO nmws_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Agegene tomate wedi suwoyuk lihuine—taine hu depahone heto sahe Helak i lihuyan heimiu he Buk Bwabwalene, ine? ");
INSERT INTO nmws_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","I nga, ‘Sauge ya nau Eibraham, Aisak ge Jeikob wedi Helak.’ Helak i liwo sohode ti yake, iloke ta lapu bobode ya yawedidiye taine i demate suwok. Helak iye taine tomate suwok wedi Helak sohode, age hebwaden yawedidiye ganganine wedi Helak.” ");
INSERT INTO nmws_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Boda si longe Yeisu wana lihulihu ya, bwen nuwadiye si hape wana papalapu kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisi si longe hobak Yeisu i gopamipahabid Sadiusi, bwen Farisi si mipase. ");
INSERT INTO nmws_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Habe bwaidiye hotiya, Logugui hana tosibe, i hamnohon Yeisu ge i tayak i nga, ");
INSERT INTO nmws_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Topapalapu, se logugui i kai Moses he wana Logugui?” ");
INSERT INTO nmws_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeisu i golase halingane i nga, “‘U nunuwane-yan Guyau lam Helak bwaine hatiyem bwabwaligane, yawedim bwabwaligane ge lam nuwotu bwabwaligane.’ ");
INSERT INTO nmws_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Logugui ya i midei ge iye logugui lahine. ");
INSERT INTO nmws_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ge logugui ho-iwoine sohode hedi ti yo, i nga, ‘U nunuwane-yan bwaim sohode totom u nunuwane-yaniwo.’ ");
INSERT INTO nmws_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses wana Logugui bwabwaligane ge profet-yan wedi papalapu, pakediye i talmidi he logugui ho-iwo ya hei.” ");
INSERT INTO nmws_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi mwage si mimibayavin-an Yeisu, bwen i tayakid i nga, ");
INSERT INTO nmws_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwatan lemi nuwatu Mesaiya kaiwane? Iye sega tubune?” Habe si nga, “Iye Deivid tubune.” ");
INSERT INTO nmws_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Bwen Yeisu i tayakid hedi i nga, “Mwatan ge Deivid i lihulihu he Yayaluwo Gagabubine wana nuwotu ge i hawa guyau-yan Mesaiya? Deivid i nga, ");
INSERT INTO nmws_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Helak i liwo lo Guyau heine i nga: U tuwodau he lo hinone hana had a ho dongeid ham siviye he hehem gabulane.’ ");
INSERT INTO nmws_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hebe Deivid i hawa guyau-yan Mesaiya, mwatan ge tage iye Deivid tubune?” ");
INSERT INTO nmws_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Taine bosowaidiye hotiya i degolase Yeisu halingane, bwen taine sauge hotiya hedi bosowaidiye si dehamnohon ge tayak hotiya si degotayak Yeisu heine. ");
INSERT INTO nmws_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Habeto Yeisu i liwo boda heidiye ge wana topadavae heidiye i nga, ");
INSERT INTO nmws_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Logugui hana topapalapu ge Farisi-yan sidiye Moses wana Logugui hana tolapu ge hana totalisi. ");
INSERT INTO nmws_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iyete gen hu longe halingadiye ge wedi lihulihu bwabwaligane gen hu sebelen. Agegene tab hu eginawi sohode sahe si ginginawi, kaiwane gane si papalapu-yan, taine si edeginginawi-yan sohode. ");
INSERT INTO nmws_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wedi logugui i hoyowate iyete hemi hiyewo pupuyowane si ho giyau, age sidiye taine si edeginawi bigi hotiya tage puyowoine hotiya si edehiyewo. ");
INSERT INTO nmws_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bigi bwabwaligane hebwaden si pamaliid, si ginawiid kaiwane nuwadiye bobode si paidiid ge si lapuid tage sidiye todohob. Si ginawi pakai nabo hebwaden Buk Bwabwalene pakene si dohe he gamwane ge si lokin hasik he yamwadiye. Sohode hedi, si pamwalao kevale gane hedi kaliko busune hana kevale. ");
INSERT INTO nmws_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","He sagae hei nunuwadiye si tuwodau he yaho gane bobode lalahine wedi yaho, ge he guwole tapwalolo hei nunuwadiye si tuwodei bobode he matadiye. ");
INSERT INTO nmws_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hebe si paidi bobode he bagamwaket, nuwadiye te bobode bwaidiye wedi hawatau si pata ago heidiye ge si hawa guyau-yanid. ");
INSERT INTO nmws_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tab hene-bwaimiu si ehawa guyau-yanmiu, kaiwane lemi Guyau i totiya ege ge bwabwaligamiu hu hawa he-hauhavamiu ege. ");
INSERT INTO nmws_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tab hu ehawa tamamiu-yan panayawi tolomoine hotiya, kaiwane Tamamiu i totiya ege, iye mwage he bulubulu. ");
INSERT INTO nmws_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tab bobode si ehawa todedei-yanmiu, kaiwane lemi todedei i totiya ege, iye Mesaiya. ");
INSERT INTO nmws_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sega hebe hidane i kai he gamwamiu, iye gen i tabwa lemi tokaiwo. ");
INSERT INTO nmws_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sega hebe i ho senge totone, Helak bwele i hotei donge, ge sega hebe i ho donge totone, Helak bwele i hotei senge. ");
INSERT INTO nmws_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Eeu, Logugui hana topapalapu ge Farisi geb! Toyoyokapis humiu, benan hu ngak! Hu tagabulim Helak wana bagalogugui hana dowa bobode he matadiye. Humiu taine hu desetuk Helak he wana bagalogugui, ge hebwaden nuwadiye si setuk wedi hiyede hu tagabulim. ");
INSERT INTO nmws_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Eeu, Logugui hana topapalapu ge Farisi geb! Toyoyokapis humiu, benan hu ngak! Hu ho haghagabwi wedi guwole ge wedi gogomwau ge hu loglogugui bwage-yan. Sohode hedi, hu papamwalao lemi hawanun-yan bobode he batidiye tage si elongemiu. Lemi page yake kaiwane, bwele hemi pepelase i kai suwok. ");
INSERT INTO nmws_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Eeu, Logugui hana topapalapu ge Farisi geb! Toyoyokapis humiu, benan hu ngak! Hu hamnohon mwao hiyede bwabwaligane iloke hu godohedohe tolomo hotiya nuwane, hu goho ge i sebelenmiu. Humiu hel hana bobode, age sauge tolomo ya hu howo, hu palapu bwen i tabwa hel hana tolomo suwok. ");
INSERT INTO nmws_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Eeu geb! Humiu todedei ngakngakidiye matamiu si gin, benan hu ngak! Humiu hu liwo hu nga, ‘Hebe tolomo hotiya i siloyan Guwole Gagabubine, bosowaine ege i lake yok wana liwo tuwoi; age hebe tolomo hotiya i siloyan Guwole Gagabubine hana gold, taine bosowaine i delake yok wana liwo tuwoi.’ ");
INSERT INTO nmws_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Boliboli humiu, matamiu si gin. Sewalake i kai, gold i kai o Guwole Gagabubine i kai? Agegene Guwole Gagabubine gabubine kaiwane bwen gold i gabub. ");
INSERT INTO nmws_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Humiu hu liwo hedi, ‘Hebe tolomo hotiya i siloyan pak hebwaden si vate bagapowo, bosowaine ege i lake yok wana liwo tuwoi; age hebe tolomo hotiya i siloyan man gane si epowon-an he pwatane, taine bosowaine i delake yok wana liwo tuwoi.’ ");
INSERT INTO nmws_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tomatagin humiu! Sewalake i kai, man i kai o hebe bagapowo i kai? Agegene bagapowo gabubine kaiwane bwen man i gabub. ");
INSERT INTO nmws_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iyete sauge hebe tolomo hotiya i siloyan bagapowo, hobak i siloyan bagapowo bwaine ge man gane si epowon-an he pwatane. ");
INSERT INTO nmws_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sohode hedi, sauge hebe tolomo hotiya i siloyan Guwole Gagabubine, i siloyan Guwole Gagabubine bwaine ge Helak, iye i miyemiye hei. ");
INSERT INTO nmws_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ge sauge hebe tolomo hotiya i siloyan bulubulu, i siloyan Helak wana bagatuwodau wasewaseine bwaine ge iye. ");
INSERT INTO nmws_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Eeu, Logugui hana topapalapu ge Farisi geb! Toyoyokapis humiu, benan hu ngak. Haga hana hepabwalai sohode seiyale, sili ge giwogiwo hu dukan duk-yawate (10), bwen duk-tiya hu giyau Helak heine lemi mulolu, sohode hana logugui. Hu sebelen nabiyan logugui yake, agegene hu minuwodonid Helak wana logugui hana nuwotu lalahine-yanid ge taine hu deginginawi, logugui-yan sohode wada ginawi i sapu, ta nuwalolu-yan hene-bwaide ge ta egotolosuwok. Akum hu senapuyan logugui hebwaden ya ge hu senapuyan hedi haga hana hepabwalai hedi logugui. ");
INSERT INTO nmws_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Humiu todedei ngakngakidiye matamiu si gin! Hu sebelen vetahe logugui hebwaden taine hedi nunuwotu i dekai, agegene hu minuwodonid logugui lalahine-yanid. Humiu hu hudu yok langolango he lemi bwai, age taine hu depaidi kamel bwabwaligane bwen hu tinon bwaine bwai. ");
INSERT INTO nmws_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Eeu, Logugui hana topapalapu ge Farisi geb! Toyoyokapis humiu, benan hu ngak! Humiu sohode bobode si sawi ege kom ge nohe putetediye, age taine si desawi gamwadiye. Hu bagavetahe ege dedelawi, agegene tomemek ge ngakngak pageine i susuwoku he hatiyemiu. ");
INSERT INTO nmws_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Humiu Farisi, matamiu si gin! Dedei gen hu sawi vetahe kom ge nohe gamwadiye, iloke dedelawi bwele i kanekane. ");
INSERT INTO nmws_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Eeu, Logugui hana topapalapu ge Farisi geb! Toyoyokapis humiu, benan hu ngak! Humiu sohode haliwage gane si bagavetahe ge si paisele. Dedelawi hana hao i dohob, agegene he gamwane tomate sinsinagaleine ge buwongeine i susuwoku. ");
INSERT INTO nmws_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sohode hedi, dedelawi bobode si paidimiu tage humiu todohob, agegene loyoyokapis ge ngak pageine i susuwoku he hatiyemiu. ");
INSERT INTO nmws_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Eeu, Logugui hana topapalapu ge Farisi geb! Toyoyokapis humiu, benan hu ngak! Hu ginawi profet hedi haliwage ge hu paisele tonuwakau dedei hebwaden wedi page i sapu hedi haliwage. ");
INSERT INTO nmws_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bwen hu liwo hu nga, “Akum hamai mwage he-tutubumai dedei he wedi sauge, taine ha deginawi sohode sidiye si ginawi, taine ha detagapamateid profet-yan.” ");
INSERT INTO nmws_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hu liwo sohode ti yake, iyete hobak hu gopayoumatemiu age humiu totaurol he-tutubudiye, hebwaden si tagapampamateid profet-yan. ");
INSERT INTO nmws_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gen hu ginawi bebelen ege! Page gane he-tutubumiu si telipune-yan gen hu pwamwao! ");
INSERT INTO nmws_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Humiu sohode mwate! Mwate he-nanatune humiu! Taine bosowaine hu demwad, agegene humiu bwele pepelase habe hu paidi hel. ");
INSERT INTO nmws_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iyete a epatileid profet ge tosibe lalahine-yanid ge topapalapu heimiu. Bwele hu tagapamateid topadine, hu tagakorosid topadine, hu rabrabik-anid topadine he lami guwole tapwalolo gamwane, ge topadine hu belen dodogan-anid si lok he hiyebe tomase ge tomase heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iyete humiu bwele habe hu paidi bobode wedi page sapusapuine hedi taurol bwabwaligane lasene, i telipune Eibol hei, havane Kein iye i taurolan, hana had Sekaraiya, Berekaiya natune, gane humiu Judiya hu taurolan he Guwole Gagabubine ge bagapowo hedi hauhawal. ");
INSERT INTO nmws_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tolosuwok a liwo heimiu, bwele si pate papalahe taurol hohoyawate yake lasene humiu sai ya heimiu. ");
INSERT INTO nmws_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Eeu geb Jerusalem hana tomiye! Humiu hu tagapamateid profet ge hu lemeid hebwaden Helak i patileid heimiu he pak. Sauge i hoyowate nuwau a yomo paseid lemi bobode, sohode pwaol vainiine i yomo paseid he-nanatune he pagagane gabulane, agegene taine nuwamiu sohode. ");
INSERT INTO nmws_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iye te heine Helak bwele habe i galayok lemi Guwole Gagabubine ge taine hinone. ");
INSERT INTO nmws_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","A liwo heimiu, taine hedi bwele hu depaidiyau hana had a sehavileim hedi, bwen he sauge yake bwele hu tobalanau hu nga, ‘Helak gen i gomulolu-yan, iye i luwom Guyau he hidane heine!’ ” ");
INSERT INTO nmws_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sauge Yeisu i seyok Guwole Gagabubine i setagi nuwane i yogo, bwen wana topadavae si luwom heine ge si nga, “Gen matam i lok u paidi Guwole Gagabubine hana hao dodohobine!” ");
INSERT INTO nmws_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yeisu i golase halingadiye i nga, “Guwole ya bwabwaligane mwage hu paipaidi. Tolosuwok a liwo heimiu, pak hebwaden si yomo ge si ginawi guwole ya hei, taine hotiya bwele i demiyemiye he habane, bwele bwabwaligane habe si mwanalakelake.” ");
INSERT INTO nmws_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeisu i la i tihe sai he Bobokun Oliv ge i tuwodau, habeto wana topadavae hohowane ege si luwom heine si nga, “Gen u giyau lama wase, se sauge habe bigi gane lihuine u lihulihu-yan i youmate? Sohode hedi, lam luwom ge sauge mwaomwaoine hetutuhiine mwatan?” ");
INSERT INTO nmws_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeisu i golase halingadiye i nga, “Hu yehemiu, tab tolomo hotiya i egoyokapisimiu. ");
INSERT INTO nmws_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kaiwane bobode si hoyowate bwele si luwom he hidau heine ge si nga, ‘Nau Mesaiya!’ iloke si yokapisiid bobode hoyowate. ");
INSERT INTO nmws_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Benan hu longe helolomaleke butudiye he hadidimiu ge hu longeik maleke wasane he hiyebe bwagebwage, age tab hatiyemiu i ebwalebwale. Bigi sohode-yan yake bwele si gangan, age sauge mwaomwaoine habe taine i deluwom. ");
INSERT INTO nmws_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Boda ge boda bwele si pelolomaleke-yanid, sohode hedi bagalogugui ge bagalogugui bwele si pelolomaleke-yanid. Buwota lahine ge mwaniknik bwele si youmate wabene tomase ge tomase heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ngak hebwaden ya gen si youmate dei, sohode hab tilaoine gen i telipune muyai habe memai i youmate. ");
INSERT INTO nmws_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bwele si bwangemiu, si hoteimiu he bagalase ge si tagapampamatemiu. Nau kaiwau bwen bobode bwabwaligadiye bwele si hata mamaliye-yanmiu. ");
INSERT INTO nmws_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","He sauge yake heine, bobode si hoyowate bwele putetediye si giyau tapwalolo hana goru heine, iloke si waseyanid he-bwaidiye tologugui heidiye ge si hata mamaliye-yanid. ");
INSERT INTO nmws_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Profet yoyokapisidiye si hoyowate bwele si youmate bwen bobode hoyowate bwele si yokapisiid. ");
INSERT INTO nmws_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Page ngakngakine bwele i ekaikai la ege, bwen bobode si hoyowate wedi nunuwane he-bwaidiye heidiye bwele i tankai, ");
INSERT INTO nmws_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","agegene sega hebe i talmidi gaigaisi hana had he bagapamwao hei, bwele mwad i paidi. ");
INSERT INTO nmws_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bwele si papalapu-yan Helak wana bagalogugui wasane dodohobine he panayawi malemaleine ge bobode he wabene bwabwaligane si lapu, habeto sauge mwaomwaoine i sevin. ");
INSERT INTO nmws_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Tobagapangek bwebwehihiine’ gane veto Daniyel i lihuyan habe hu paidi i talmidi he Guwole Gagabubine—humiu hebwaden buk ya hana topahuwone gen nuwamiu i sapu lihulihu ya kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bwen he sauge yake hebwaden si miyemiye he Judiya gen si iwowo si la si sesai he bobokun. ");
INSERT INTO nmws_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hebe tolomo hotiya mwage i miyemiye he wana guwole pwatane gane si gino pamalemale, tab i esedau ge i esetuk he wana guwole ge i ehowo bigi hotiya, i iwowo ege. ");
INSERT INTO nmws_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Hebe tolomo hotiya mwage i kaikaiwo he baguye, tab i esehavile he hiyebe ge i ehowo hana kaliko hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","He sauge yake hei bwele i puyowo suwok venakau tomatabuwon ge topapasui heidiye. Eeu, heto ngak geb ti yake! ");
INSERT INTO nmws_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gen hu hawanun Helak heine tab tuitui he hana sauge o hebe Sabat ge hu eiwowo. ");
INSERT INTO nmws_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kaiwane he sauge yake dogobole lahine suwok bwele i youmate, sosohode yake taine sauge hotiya i edeyoumate he panayawi hana bagatelipune hana had sauge ya. Sohode hedi taine bwele i edegan sauge muyai. ");
INSERT INTO nmws_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Akum Helak taine i depahubo ngak yake hana sauge, bwen taine tolomo hotiya bwele i demwad. Age bobode hebwaden hobak i haseid kaiwadiye te sauge hana mwalao habe i pahubo. ");
INSERT INTO nmws_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","He sauge yake hebe tolomo hotiya i liwo heimiu i nga, ‘Hu paidi, Keriso tage iyeya,’ o hebe hotiya hedi i nga, ‘Iye tage iyeyake,’ tab hu egoru heine. ");
INSERT INTO nmws_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kaiwane keriso yoyokapisidiye ge profet yoyokapisidiye habe bwele si youmate ge si ginawiid pamali yauyawate bobode wedi baganuwo hape, nuwadiye si yokapisiid Helak wana hasehase bobodeidiye, age taine bosowaidiye. ");
INSERT INTO nmws_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iyete hu nuwahasik! A giyau pasuwae lemi wase ti ya. ");
INSERT INTO nmws_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Hebe tolomo hotiya i liwo heimiu i nga, ‘Iye mwage te he huyahai yake,’ tab hu elok, o hebe hotiya i nga, ‘Iye mwage te he guwole ya gamwane,’ tab hu egoru heine. ");
INSERT INTO nmws_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kaiwane Tolomo Natune wana luwom bwele sohode pilame, i piklame natek ge wayayane i la i sevin pok. ");
INSERT INTO nmws_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sohode hedi, hebe buwonge i miye igohoi, bwen habekik kovak si lok ge si segin pase. ");
INSERT INTO nmws_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Dogobole yake he hana bagapamwao hei, bwele parae i gogou, wahiyene taine hedi i detale, sinanane bwele si mamapup he bulubulu si sopiyele, ge togaisi hebwaden he hauhawal si lutulutu. ");
INSERT INTO nmws_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","He sauge yake Tolomo Natune wana luwom hetutuhine bwele i youmate he bulubulu. Tomipanayawi bwabwaligadiye bwele si tantan, ge si paidi Tolomo Natune i eluwom he yaluyalu pwatane, bwaine wana gaisi ge wana wasewase. ");
INSERT INTO nmws_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Habeto bwagigi halingane lahine si wi bwen i patileid wana anelose-yan si la he panayawi bebene ho-pak ge si yomo paseid wana hasehase bobodeidiye, si telipune he panayawi busune hotiya ge si la si pwamwao he busune hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Hu ho bagalapu he hibwahi fig hei. Sauge hebe ta paidi damwane i titi, bwen ta lapu dayave hana sauge hobak i sepasepase. ");
INSERT INTO nmws_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sohode hedi, sauge hebe hu paidi bigi bwabwaligane gane a lihuyanid si youmate, bwen hu lapu Tolomo Natune wana sauge luwom hobak i sepasepase suwok. ");
INSERT INTO nmws_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tolosuwok a liwo heimiu, sai hebwaden ya taine bwele si demate mwao, bwen bigi bwabwaligane hebwaden ya si youmate. ");
INSERT INTO nmws_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Bulubulu ge panayawi bwele si mwao, agegene nau lo lihulihu taine bwele i edemwao. ");
INSERT INTO nmws_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Taine tolomo hotiya i delapu se yan o hebe se sauge. Bwagane anelose-yan he bulubulu, taine si delapu, ge nau hedi Natune taine a delapu, Tamau ege i lapu. ");
INSERT INTO nmws_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sohode veto Nowa he wana sauge, bwele sohode hedi Tolomo Natune wana luwom he hana sauge hei. ");
INSERT INTO nmws_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saugeine habe taine gungun i desai, bobode si hagahaga, si lolomunmun ge si lolohadhaduwe, si pagan sohode ti yake hana had Nowa i la i setuk he wage gamwane. ");
INSERT INTO nmws_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Taine hotiya i denunuwotu heto sahe habe bwele i gan, hana had gungun i sai, bwabwaligadiye si matadau ge si mate. Bwele sohode hedi ti yo Tolomo Natune he wana luwom hei. ");
INSERT INTO nmws_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","He sauge yake, bobode si he-iwo si kaikaiwo he baguye, hotiya si ho yogoyan, hotiya i miye. ");
INSERT INTO nmws_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Venakau si yuhun-iwo si kaikaiwo si hoho wit hinone nahadiye kaiwane, hotiya si ho yogoyan, hotiya i miye. ");
INSERT INTO nmws_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iyete hu yehemiu, kaiwane taine hu delapu se yan bwele lemi Guyau i luwom. ");
INSERT INTO nmws_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hu nuwohasik ti ya: akum hebe guwole tonuwagane i lapu se sauge he gogou bwele tobwahiyewo i luwom, iloke i matalale ge i topahad tab tobwahiyewo i elake wana guwole ge i esetuk. ");
INSERT INTO nmws_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hu lovivine-yanmiu, kaiwane Tolomo Natune wana luwom bwele hatiyemiu i pahan, sauge gane taine hu delapu te bwele i sevin. ");
INSERT INTO nmws_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Akum humiu sohode tokaiwo sensenapuine ge wana nuwotu i sapu, gane wana guyau i hotei i matahasikid tokaiwo bwabwaligadiye ge i giyau nahadiye he hana sauge suwok. ");
INSERT INTO nmws_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sauge hebe wana guyau i sehavileim ge i paidi i ginginawi kaiwo ya, bwele i hawa dohoban. ");
INSERT INTO nmws_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tolosuwok a liwo heimiu, bwele wana guyau i hotei i matahasikid wana bigi bwabwaligane. ");
INSERT INTO nmws_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Agegene mwatan hebe tokaiwo yake i boliboli ge i nunuwotu he hatiyene i nga, ‘Lo gamalak taine bwele habekik i desehavileim,’ ");
INSERT INTO nmws_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","bwen i telipune i rabrabik-anid wana pan tokaiwo ge he-bwaine tomunmun si hanhan ge si lomunmun? ");
INSERT INTO nmws_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bwele wana guyau i sehavileim ge i pahan hatiyene, kaiwane taine i delapu wana sehavileim hana yan ge hana sauge. ");
INSERT INTO nmws_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bwele i tagapangpangek-an tokaiwo ya, ge i ho tukan he toyoyokapis hedi bagalase, bwele i mitantan ge ngingine i sangsangapatad.” ");
INSERT INTO nmws_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Habeto Yeisu i liwo heidiye i nga, “He sauge yake Helak wana bagalogugui sohode ti ya. Hohoen si yuhun-yawate (10) si howo wedi lampwa, si setagi si la si matemate tokaukawaroru tolomoine bwele i hudi vaini he wana guwole ge i sehavileim, bwen si pagotuk-anid bwaine ge vaini. ");
INSERT INTO nmws_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Si yuhun-lime boliboliidiye ge si yuhun-lime sensenapuidiye. ");
INSERT INTO nmws_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Hebwaden boliboliidiye si howo wedi lampwa, age taine si delohowo lampwa hana bwai topadine hedi. ");
INSERT INTO nmws_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hebwaden sensenapuidiye si vedin dohe lampwa hana bwai topadine he pwatum-yan, bwen si losehowo bwaine ge wedi lampwa. ");
INSERT INTO nmws_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tolomo wana luwom i puyowo, bwen hohoen bwabwaligadiye matadiye si won suwok ge si hiyene. ");
INSERT INTO nmws_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","He gogou luwane tolomo hotiya i luwom i gon i nga, ‘Tokaukawaroru tolomoine i eluwom. Hu lok hu la hu paidi.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Habe hohoen bwabwaligadiye si suwoyuk ge si bagavetahe wedi lampwa. ");
INSERT INTO nmws_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hebwaden boliboliidiye si liwo hebwaden sensenapuidiye heidiye si nga, ‘Hu hom bwai hawesine, lama lampwa hobak i ebuwode.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Si golase halingadiye si nga, ‘Taine. Humiu ge hamai tan bosowaide. Gen hu lok hu la he stowa ge hu pamaise lemi lampwa hana bwai topadine.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Agegene sauge si ela bwai pampamaise kaiwane, bwen tokaukawaroru tolomoine i sevin. Hohoen hebwaden si lovivine bwaidiye si setuk he haduwe hana sagae, bwen dowa si tagabulim. ");
INSERT INTO nmws_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Muyai habe hohoen boliboliidiye si luwom ge si nga, ‘Guyau, guyau, gen u tate dowa ge ha setuk.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Agegene i golase halingadiye i nga, ‘Tolosuwok a liwo heimiu, taine a delapumiu.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bwen Yeisu i nga, “Hu yehemiu, kaiwane taine hu delapu se yan o hebe se sauge lemi Guyau bwele i luwom.” ");
INSERT INTO nmws_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Habeto Yeisu i liwo heidiye i nga, “He sauge yake Helak wana bagalogugui sohode ti ya. Tolomo hotiya nuwane i yogo i la mwage he wabene hotiya, habe i gon wana tokaiwo heidiye ge i giyau wana bigibigi bwabwaligane ge si matahasik. ");
INSERT INTO nmws_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I giyau silba hana hohoyowate tausan ho-lime tokaiwo hotiya heine, i giyau tausan ho-iwo tolomo ho-iwoine heine ge i giyau tausan hotiya ho-tuwonine heine. I gorugoru hotiya ge hotiya wana lapu hana kaikai heine, bwen i giyau sohode. I giyau heidiye habeto i yogo i la mwage he wabene hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tolomo gane i howo silba hana hohoyowate tausan ho-lime, habekik i la i pakaiwo bwen i paidi tausan ho-lime hedi. ");
INSERT INTO nmws_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ge tolomo gane i howo tausan ho-iwo, i la i ginawi sohode hedi bwen i paidi tausan ho-iwo hedi. ");
INSERT INTO nmws_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Age tolomo gane i howo tausan hotiya i lok i la i hen kelekele ge i holem wana gamalak wana mwani. ");
INSERT INTO nmws_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Sauge i mwalao habe wedi gamalak i sehavileim, bwen i gon wana tokaiwo heidiye, nuwane i lapu mwatan si pakaiwo pagan wana mwani. ");
INSERT INTO nmws_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tolomo gane i howo silba hana hohoyowate tausan ho-lime, i luwom ge i giyau wana gamalak heine, bwaine ge tausan ho-lime hedi. Habe i nga, ‘Guyau, veto u giyau heyau tausan ho-lime. U paidi, tausan ho-lime hedi a paidi.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wana gamalak i liwo heine i nga, ‘Huwo tokaiwo dodohobine ge sensenapuine. U ginawi vetahe. U matahasikid vetahe bigibigi hebwaden taine si dehoyowate, bwele a hoteiiwo u matahasikid bigibigi si hoyowate. U luwom bwalu huwo ta yariyae toyao.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tolomo gane i howo tausan ho-iwo, i luwom hedi i nga, ‘Guyau, veto u giyau heyau tausan ho-iwo. U paidi, tausan ho-iwo hedi a paidi.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Wana gamalak i liwo heine i nga, ‘Huwo tokaiwo dodohobine ge sensenapuine. U ginawi vetahe. U matahasikid vetahe bigibigi hebwaden taine si dehoyowate, bwele a hoteiiwo u matahasikid bigibigi si hoyowate. U luwom bwalu huwo ta yariyae toyao.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tolomo gane i howo tausan hotiya, i luwom heine ge i nga, ‘Guyau, a lapu huwo lam logugui i gaisi, kaiwane haga gane taine u devahi, u ehen ge u epase senge he lam guwole. Mwage bobode papaine si kaiwoyan hinone i youyoumate, bwen huwo nonowane u eyomo. ");
INSERT INTO nmws_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iyete heine a matokaniwo, a la a hen kelekele ge a holem sumwan lam mwani. U paidi, lam mwani ti ya a ho pahavile heim.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Habeto wana gamalak i liwo heine i nga, ‘Huwo tokaiwo ngakngakine ge tokaiwo pwapwayateine. U lapu ege te haga gane taine a devahi a ehen ge a epase senge he lo guwole. Ge u lapu mwage bobode papaine si kaiwoyan hinone i youyoumate, bwen nau nonowane a eyomo. ");
INSERT INTO nmws_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Akum u la u hotei lo mwani he benk si pakaiwo, ilok sauge a sehavileim bwen a ho pahavile, bwaine hana hetubo, gane si pakaiwo hana hinone. ");
INSERT INTO nmws_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Mwani hu ho hwae hei ge hu giyau tolomo gane wana mwani hana hohoyowate tausan hwawate (10,000) heine. ");
INSERT INTO nmws_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kaiwane sega i gan heine, habe Helak i giyau pakai hedi bwen i madi. Age sega tan degan heine, bwagane gane tankai i miye heine, Helak bwele i ho yok. ");
INSERT INTO nmws_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hu bili tagan tokaiwo ngakngakine ya dedelawi he gogou, iloke i mitantan ge ngingine i sangsangapatad.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sauge Tolomo Natune i luwom he-bwaine anelose-yan bwabwaligadiye ge iye i tabwa kin, bwele i tuwodau he wana bagatuwodau wasewaseine ge i logugui. ");
INSERT INTO nmws_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tomipanayawi bwabwaligadiye bwele si bigipaseid he matane bwen i haseid i yomoteiid he boda ho-iwo, sohode sip hana tomatahasik i haseid sip ge gout ge i hotei vevekanid. ");
INSERT INTO nmws_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sip i yomoteiid he wana hinone ge gout i yomoteiid he wana gegebe. ");
INSERT INTO nmws_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Habe kin i liwo hebwaden si miye he wana hinone heidiye i nga, ‘Humiu hebwaden Tamau i muloluyanmiu, hu luwom hu setuk he bagalogugui, gane Helak i lovivine-yan kaiwamiu saugeine i ginawi panayawi. ");
INSERT INTO nmws_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kaiwane a buwota bwen hu pahanau, a mwaiwom bwen hu pamunau, a mibwabwali bwen hu gon paseyau, ");
INSERT INTO nmws_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","a bukebuke bwen hu pasipoyau, a bole bwen hu matahasikau, a miyemiye he dibula bwen hu luwom hu paidiyau.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Todohob si golase halingane si nga, ‘Guyau, se sauge ha paidiiwo u buwota ge ha pahaniwo, o hebe u mwaiwom ge ha pamuniwo? ");
INSERT INTO nmws_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Se sauge ha paidiiwo u mibwabwali ge ha gon paseiwo, o hebe u bukebuke ge ha pasipoiwo? ");
INSERT INTO nmws_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Se sauge ha paidiiwo u bole o hebe u miyemiye he dibula ge ha lowo ha paidiiwo?’ ");
INSERT INTO nmws_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Habeto kin i golase halingadiye i nga, ‘Tolosuwok a liwo heimiu, heto sahe hebe hu ginawi he-hauhavau ya totankainane hotiya heine, sohode hu ginawi heyau.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Bwele i liwo hebwaden si miye he wana gegebe heidiye i nga, ‘Humiu hebwaden Helak hobak i lihuyan hemi pepelase, hu leke hu la he hiwo mimisuwokine hei, gane Helak i lovivine-yan Seitan he-bwaine ge wana anelose-yan kaiwadiye. ");
INSERT INTO nmws_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kaiwane a buwota taine hu edepahanau, a mwaiwom taine hu edepamunau, ");
INSERT INTO nmws_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","a mibwabwali taine hu edegon paseyau, a bukebuke taine hu edepasipoyau, a bole ge a miyemiye he dibula taine hu edematahasikau.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Sidiye hedi bwele si golase halingane si nga, ‘Guyau, se sauge ha paidiiwo u buwota o hebe u mwaiwom, u mibwabwali o hebe u bukebuke, u bole o hebe u miyemiye he dibula, ge taine ha delabeiwo?’ ");
INSERT INTO nmws_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Habeto i golase halingadiye i nga, ‘Tolosuwok a liwo heimiu, heto sahe hebe taine hu deginawi bobode ya totankainane hotiya heine, sohode taine hu deginawi heyau.’ ");
INSERT INTO nmws_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iye te kaiwane bwele si la he pepelase mimisuwokine hei, agegene todohob bwele si la he yawed mimisuwokine hei.” ");
INSERT INTO nmws_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Saugeine Yeisu i gomwao lihulihu ya bwabwaligane, habeto i liwo wana topadavae heidiye i nga, ");
INSERT INTO nmws_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hu lapu ege te yan ho-iwo ege i miyemiye muyai habe Seyok Sagaeine hana sauge, bwen si bwange Tolomo Natune ge si taeman si tagakoros-yan.” ");
INSERT INTO nmws_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","He sauge yake topowo lalahine ge Judiya wedi todedei si mipase topowo lalahine wedi todedei Kaiyapas he wana guwole. ");
INSERT INTO nmws_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Habeto si nuwotu luluweni mwatan bwele si pagan iloke si bwange sumwan Yeisu ge si lopamate. ");
INSERT INTO nmws_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Si nga, “Tab ta eginawi he sagae hana sauge hei, hebe habe ta pahugeid boda ge si maleke.” ");
INSERT INTO nmws_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yeisu iye mwage Beteni Saimon gane toraupoga he wana guwole, ");
INSERT INTO nmws_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","habe vaini hotiya i luwom heine i loseho poteli hana hao dodohobine, he gamwane enunu bwabwalaiine ge maisane lahine. Sauge Yeisu i tuwodau ge i hanhan, habe enunu yake i ligin Yeisu he hulune. ");
INSERT INTO nmws_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Topadavae si paidi, hoge si hata mamaliye-yan ge si nga, “I bwe te i ligi pasibaleno-yan enunu yake? ");
INSERT INTO nmws_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Akum ta paliyan iloke ta howo mwaniine lahine ge ta giyau togulegule heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yeisu hobak i lapu wedi nuwotu, bwen i liwo heidiye i nga, “Sahe kaiwane ge vaini ya hu tabadiyeye-yan? Ginawi dodohobine suwok te i ginawi heyau ya. ");
INSERT INTO nmws_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Togulegule hene-bwaimiu ege sauge hohoyowate, agegene nau taine sauge hohoyowate bwaimiu sohode. ");
INSERT INTO nmws_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Sauge hawesine ege habe a mate. Vaini ya enunu bwabwalaiine i ligin he tuwau, iloke hana hao sohode hobak i bagavetahe mwao tuwau nau ho hotei pado kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tolosuwok a liwo heimiu, he panayawi malemaleine, se wabene heine hebe si papalapu-yan wase dodohobine ya, page gane vaini ya i ginawi benan si lihuyan, iye hana baganuwohasik.” ");
INSERT INTO nmws_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bwen topadavae si he-yawate si he-iwo (12) bwaidiye hotiya hidane Judas Iskariyot, i lok i la topowo lalahine heidiye ");
INSERT INTO nmws_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ge i nga, “Heto sahe bwele hu egiyau heyau hebe Yeisu a waseyan heimiu ge hu bwange?” Habeto mwani silba hana hohoyowate teti (30) si pahone ge si liwo tei te habe si giyau heine. ");
INSERT INTO nmws_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","He sauge yake Judas i telipune i hayaoyan Yeisu wana dodogan, i luweni hiyede iloke i hotei Yeisu he nimadiye ge bwele si bwange. ");
INSERT INTO nmws_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pwalawa Bwabwalagimo Sagaeine hana yan dedei, topadavae si luwom Yeisu heine ge si tayak si nga, “Nuwam ha lovivine-yan haga kaiwam igohoi, iloke ta han sohode Seyok Sagaeine hana logugui?” ");
INSERT INTO nmws_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","I golase halingadiye i nga, “Hu lok hu la Jerusalem, tolomo hotiya hei, ge hu liwo heine hu nga, ‘Topapalapu i nga: Lo sauge hobak i sepasepase. He-bwalu lo topadavae tage Seyok Sagaeine hinone ha eginawi he lam guwole.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bwen topadavae si ginawi sohode Yeisu wana lihu heidiye ge si lovivine-yan haga Seyok Sagaeine kaiwane. ");
INSERT INTO nmws_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sauge i gogou, Yeisu he-bwaine wana topadavae si he-yawate si he-iwo (12) si tuwodau si yabwahanhan. ");
INSERT INTO nmws_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","He hanhan gamwane, habe i liwo heidiye i nga, “Tolosuwok a liwo heimiu, he gamwamiu ya bwaimiu hotiya bwele i waseyanau.” ");
INSERT INTO nmws_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bwen si hatatilao suwok, hoge hotiya ge hotiya i gotayak Yeisu heine i nga, “Guyau, nau tan sohode, age?” ");
INSERT INTO nmws_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeisu i golase halingadiye i nga, “Tolomo hotiya iye bwalu nimamai i dau he nohe hotaege gamwane, bwele i waseyanau. ");
INSERT INTO nmws_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nau Tolomo Natune bwele habe a mate sohode Buk Bwabwalene hana lihu. Eu geb! Tolomo gane i waseyanau, benan hana pepelase i kai! Akum veto tolomo yake tab tinane i ehab, iloke lase lahine taine bwele i depaidi.” ");
INSERT INTO nmws_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bwen Judas, gane bwele i ewaseyan Yeisu, i nga, “Topapalapu, nau tan sohode, age?” Bwen Yeisu i liwo heine i nga, “Taine, iye te huwo.” ");
INSERT INTO nmws_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sauge si hanhan, Yeisu i howo bred, i gomulolu Helak heine habe i pieneene-yan ge i giyau wana topadavae heidiye i nga, “Hu howo ge hu han. Ga yeya iye tuwau.” ");
INSERT INTO nmws_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Habeto waen hana kom i howo, i gomulolu Helak heine ge i giyau heidiye i nga, “Gen bwabwaligamiu hu mun. ");
INSERT INTO nmws_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ga yeya madibau, iye lihu tuwoi tovevai i patolosuwok. Madibau i dau iloke bobode si hoyowate wedi gegi bwele Helak i sawi yok. ");
INSERT INTO nmws_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A liwo heimiu, waen ga yeya taine hedi a demun, hana had he-bwalu humiu habe waen tovevai ta mun Tamau he wana bagalogugui heine.” ");
INSERT INTO nmws_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Habeto wok hotiya si wokan ge si setagi si la he Bobokun Oliv. ");
INSERT INTO nmws_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yeisu i liwo wana topadavae heidiye i nga, “Gogou ga ya bwele bwabwaligamiu hu iwowo yokau, kaiwane Buk Bwabwalene i nga, ‘Sip hedi tomatahasik a leme iloke sip si pelekeyan tomase ge tomase wedi hiyede.’ ");
INSERT INTO nmws_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Agegene lo suwoyuk hedi he muine, gen a dedei a la Galili, habeto muyai habe hu luwom.” ");
INSERT INTO nmws_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bwen Pita i golase Yeisu halingane i nga, “Bwagane bwele he-bwalu bwabwaligadiye si iwowo, agegene nau tanhebe a deiwowo yokiwo.” ");
INSERT INTO nmws_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeisu i liwo Pita heine i nga, “Tolosuwok a liwo heim, gogou ga ya pwaol tolomoine habe taine i detan, bwele u yahakanau pape-tuwon.” ");
INSERT INTO nmws_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Age Pita i liwo heine i nga, “Bwagane hebe bwalu huwo ta mate, tanhebe a deyahakaniwo.” Ge topadavae bwabwaligadiye si liwo sohode hedi Pita wana lihu. ");
INSERT INTO nmws_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sauge Yeisu he-bwaine wana topadavae si lok si la he malahao hidane Getsemeni, bwen i liwo heidiye i nga, “Hu miye te he ya, nau gen a la he yake ge a hawanun.” ");
INSERT INTO nmws_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","I sehapeid Pita ge Sebedi he-nanatune si he-iwo he-bwaine si lok, ge he sauge yake hatiyene i tilao suwok. ");
INSERT INTO nmws_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hoge i liwo heidiye i nga, “Hatiyeu i tilao suwok, tilao ya hawesine ege bwen i lopamateyau. Hu miye te he ya ge he-bwalu humiu gen ta matalale.” ");
INSERT INTO nmws_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I piliyokid taine hana bwage i degan, bwen i tiyepwahem he kelekele ge i hawanun i nga, “Tamau, hebe bosowaine, bwen tilao hana kom ya tab i eluwom heyau. Agegene tab nau lo nuwotu heine, huwo ege lam nuwotu.” ");
INSERT INTO nmws_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Habe i sehavile topadavae si he-tuwon heidiye ge i paidiid si hinhiyene. I liwo Pita heine i nga, “Mwatan ge taine bosowaimiu gen awa hotiya he-bwalu humiu ta dematalale? ");
INSERT INTO nmws_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hu matalale ge hu hawanun, iloke tab hamnohon kaiwane ge hu esopiyele. Yayaluwamiu nuwane dohob i ginawi, agegene tuwamiu i pwayate.” ");
INSERT INTO nmws_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pe-iwoine hedi i la i hawanun i nga, “Tamau, hebe lam nuwotu sohode a mun mwao te tilao hana kom ya ge taine bosowaine u deho yok, gen sohode lam nuwotu.” ");
INSERT INTO nmws_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sauge i sehavile, i paidiid hedi si hinhiyene, kaiwane matadiye i won suwok. ");
INSERT INTO nmws_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Habeto i seyokid, ge i la hedi i hawanun pe-tuwonine, wana hawanun lihuine hotiya ege. ");
INSERT INTO nmws_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Habe i sehavile hedi topadavae heidiye ge i nga, “Age humiu mwage hu hinhiyene? Hu paidi, hana sauge hobak i sevin ge Tolomo Natune si taeman bobode ngakngakidiye he nimadiye. ");
INSERT INTO nmws_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hu suwoyuk ta lowo heidiye. Tolomo gane i etaemanau, sauge ya hobak i sevin!” ");
INSERT INTO nmws_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sauge Yeisu mwage i lihulihu, bwen Judas i sevin, iye Yeisu wana topadavae hebwaden si he-yawate si he-iwo (12) bwaidiye hotiya. He-bwaine boda lahine, hebwaden topowo lalahine ge Judiya wedi todedei si patileid. Si loseyomo maleke kilepeine ge hubwahi gane hehunik. ");
INSERT INTO nmws_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yeisu hana towase hobak i lihuyan mwao hetutuhi hotiya boda heidiye i nga, “Tolomo gane a nado, iye te hu bwange ge hu yawan.” ");
INSERT INTO nmws_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iyete sauge Judas i sevin, i sesuwok i la Yeisu heine ge i nga “Ago, topapalapu!” bwen i nado. ");
INSERT INTO nmws_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeisu i liwo heine i nga, “Heliya, bigi gane kaiwane ge u luwom, gen u ginawi.” Bwen bobode si pilisai Yeisu heine ge si bwange. ");
INSERT INTO nmws_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hebwaden gane Yeisu he-bwaine, hotiya wana maleke kilepeine i warol tagan he habane, bwen i gotem yok topowo lalahine wedi todedei wana tokaiwo hotiya batine. ");
INSERT INTO nmws_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yeisu i liwo heine i nga, “Lam maleke kilepeine gen u hotei pahavile he habane, kaiwane sega hebe i lomaleke he kilepe, bwele si leme hedi he kilepe hei. ");
INSERT INTO nmws_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Age taine hu delapu te bosowaiu ege a gon Tamau heine labe kaiwane, ine? Iloke petaege bwele i patileid anelose-yan hedi boda lahine si luwom ge si lomaleke kaiwau. ");
INSERT INTO nmws_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Age hebe a ginawi sohode, taine bosowaine Buk Bwabwalene hana lihu i detabwa tolosuwok, gane i nga tage gen i youmate sohode te sauge ya.” ");
INSERT INTO nmws_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","He sauge yake Yeisu i liwo boda heidiye i nga, “Age nau tohawatautau ge hemi siviye? Iyete hu loseyomo maleke kilepeine ge hehunik ge hu luwom tage hu ebwangeyau, ine? Yan hoyowate a miyemiye ge a papalapu he Guwole Gagabubine hana bakubaku, agegene taine hu debwangeyau. ");
INSERT INTO nmws_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bigi bwabwaligane yake hobak i youmate, iloke Buk Bwabwalene gane profet si luluweli-yan i tabwa tolosuwok.” Ge he sauge yake wana topadavae bwabwaligadiye si leke ge si iwowo yok. ");
INSERT INTO nmws_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bobode gane si bwange Yeisu, si sehape lok Kaiyapas he wana guwole, iye topowo lalahine wedi todedei. Logugui hana topapalapu ge Judiya wedi todedei hobak si mipase te he yake. ");
INSERT INTO nmws_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita i sedumuyai-yan Yeisu agegene hana bwage i gan, hana had si sevin topowo lalahine wedi todedei he wana bakubaku. Pita i setuk he bakubaku gamwane, bwen i tuwodau he-bwaine tokaiwo, nuwane i paidi sahe bwele si ginawi Yeisu heine. ");
INSERT INTO nmws_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Topowo lalahine he-bwaidiye Judiya wedi tologugui bwabwaligadiye, si luweni Yeisu hana pwapwatim yoyokapisine iloke bosowaine si liwo gen i mate. ");
INSERT INTO nmws_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Agegene bwagane bobode si hoyowate si luwom ge wedi lihu yoyokapisine si lihuyan, taine hana pwapwatim hotiya si depaidi. Mwaomwaoine habe bobode si he-iwo si luwom ");
INSERT INTO nmws_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ge si nga, “Tolomo ya i liwo, ‘Nau bosowau Helak wana Guwole Gagabubine a mwanalake ge he yan ho-tuwon gamwane a pamidi hedi.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Habe topowo lalahine wedi todedei i suwomidi ge i liwo Yeisu heine i nga, “Mwatan ge taine u degolase halingadiye? Nuwotu gane si lihuyan kaiwam, hana sapu mwatan?” ");
INSERT INTO nmws_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Agegene Yeisu i mipahab. Habeto topowo lalahine wedi todedei i liwo heine i nga, “Helak yawedine ganganine he hidane hei gen u lihu tolosuwok, ge lama wase u giyau hebe huwo Mesaiya Helak Natune, o taine.” ");
INSERT INTO nmws_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeisu i golase halingane i nga, “Sohode te lam lihu tei. Agegene a liwo heimiu, nau Tolomo Natune benan habe hu paidiyau a tuwodau Helak Togaisi he wana hinone ge a sehudiim he yaluyalu pwatane.” ");
INSERT INTO nmws_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iyete topowo lalahine wedi todedei i huge, hoge totone hana kaliko i mwanasase ge i nga, “Tolomo ya i gosenge totone ge i hotei donge Helak hidane. Sowane ti yo. Taine ta deluweni hedi bobode tage si luwom ge si lihu tolomo ya kaiwane. Hobak hu longe i gopalongani Helak. ");
INSERT INTO nmws_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwatan hu nuwotu pagan?” Si golase halingane si nga, “I bosowaine suwok gen i mate.” ");
INSERT INTO nmws_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bwen si luwo punpun-an mangingine ge si lemeleme-yan he nimadiye. Topadine si tagalepelepe-yan ");
INSERT INTO nmws_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ge si nga, “Age huwo Mesaiya? Gen u liwo heyai sega i lemeiwo.” ");
INSERT INTO nmws_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita i tutuwodau he bakubaku, bwen topowo lalahine wedi todedei wana tokaiwo venakau bwaidiye hotiya i luwom heine ge i nga, “Huwo hedi Yeisu gagama Galili bwaine hotiya.” ");
INSERT INTO nmws_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bobode bwabwaligadiye he matadiye bwen i yahak i nga, “Taine a delapu sahe te u lihuyan tei.” ");
INSERT INTO nmws_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bwen i la i setagi he bagasetuk hei, habe vaini hotiya hedi i paidi Pita, hoge i liwo bobode hebwaden si miyemiye he yake heidiye i nga, “Tolomo ya iye Yeisu gagama Nasaret bwaine hotiya.” ");
INSERT INTO nmws_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bwen Pita i yahak-an pe-iwoine, i silosilo ge i nga, “Tolomo tei taine a delapu.” ");
INSERT INTO nmws_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sauge hawesine, bwen bobode hebwaden si midimidi he yake si luwom Pita heine ge si nga, “Tolosuwok huwo Yeisu wana boda bwaidiye hotiya, kaiwane halingam hana gun i payoumateiwo te huwo gagama Galili.” ");
INSERT INTO nmws_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bwen Pita i silosilo ge i nga, “Tolosuwok a liwo heimiu, tolomo tei taine a delapu. Akum taine a delihu tolosuwok, Helak gen i laseyau.” He sauge yake pwaol tolomoine i tan, ");
INSERT INTO nmws_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","bwen Pita i nuwopik Yeisu wana lihulihu gane i nga: “Pwaol tolomoine habe taine i detan, bwele u yahakanau pape-tuwon.” Habe i la i setagi dedelawi ge i tan nabi. ");
INSERT INTO nmws_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Henenai suwok topowo lalahine bwabwaligadiye he-bwaidiye ge Judiya wedi todedei si ginawi Yeisu hana logugui te gen i mate. ");
INSERT INTO nmws_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Habeto si yawan ge si sehape si la si pagotei Pilato he nimane, iye Roum wedi gavana. ");
INSERT INTO nmws_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yeisu hana towase Judas, sauge i paidi Judiya si liwo Yeisu gen i mate, bwen i nuwo ngakan wana ginawi, hoge i ho pahavile mwani silba hana hohoyowate teti (30) topowo lalahine ge todedei heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","I nga, “A gegi suwok, kaiwane Yeisu taine wana ngak i degan, bwen a waseyan heimiu ge bwele hu lopamate.” Si liwo heine si nga, “Lama sanahane tei! Totom ham puyowo tei.” ");
INSERT INTO nmws_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Habeto Judas i yok tei mwani yake he Guwole Gagabubine gamwane, bwen i yogo ge i la i gadisowa. ");
INSERT INTO nmws_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Topowo lalahine si howo mwani yake ge si nga, “Mwani ya i madibe, Logugui taine i detaeman te ta howo ge ta hotei he Guwole Gagabubine hana mwani he hana pase hei.” ");
INSERT INTO nmws_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Habeto si ginawi mwani yake hana logugui, bwen si howo ge si pamaise kelekele hotiya tomibwabwali hedi heliwage. Si pamaise tolomo hotiya heine iye huye hana tohab. ");
INSERT INTO nmws_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iyete hana had yan ya kelekele yake hidane si hune Panamamadibe. ");
INSERT INTO nmws_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iloke profet Jeremaiya wana lihu i tabwa tolosuwok gane i nga, “Si howo mwani hana kaikai silba teti, gane Isrel bobodeidiye si taeman tage gen si pamaise tolomo yake hei. ");
INSERT INTO nmws_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bwen si pamaise huye hana tohab wana kelekele, sohode Helak wana lihu heyau.” ");
INSERT INTO nmws_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yeisu i talmidi Pilato he matane, iye Roum wedi gavana, hoge i tayak i nga, “Huwo Judiya wedi kin?” Yeisu i nga, “Sohode te lam lihu tei.” ");
INSERT INTO nmws_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Topowo lalahine ge Judiya wedi todedei si pwatim Yeisu. Bwagane taine wana ngak i degan, agegene taine i degolase halingadiye hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato i liwo heine i nga, “Tab u longe bigi ho-piye kaiwane ge si pwatimiwo?” ");
INSERT INTO nmws_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Agegene Yeisu taine i degolase halingadiye tankai hotiya, iyete Pilato nuwane i hape. ");
INSERT INTO nmws_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bwaime hotiya ge hotiya, he Seyok Sagaeine hana sauge hei, Pilato i epagotagan hebwaden todibula gane hebe Judiya si ehase. ");
INSERT INTO nmws_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","He sauge yake tolomo hotiya i miye he dibula, hidane Barabas, iye wana ginawi ngak kaiwane bwen wasane i kai. ");
INSERT INTO nmws_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iyete sauge boda si mipase, Pilato i tayakid i nga, “Nunuwamiu sega a pagotagan kaiwamiu, Barabas o Yeisu gane si nga Mesaiya?” ");
INSERT INTO nmws_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I liwo sohode ti yake, kaiwane i lapu vetahe Judiya wedi todedei si yamwa puyowoyan Yeisu iyete si howo ge si hotei he nimane. ");
INSERT INTO nmws_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato mwage he bagakot bwen poniyene i patile lihu heine i nga, “Tolomo tei taine wana ngak, tab bigi hotiya u eginawi heine. A heneluluwo he gogou iye kaiwane ge a matok suwok.” ");
INSERT INTO nmws_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Agegene topowo lalahine ge Judiya wedi todedei si hotei boda hedi pei gen si liwo Pilato i pagotagan Barabas ge Yeisu gen i mate. ");
INSERT INTO nmws_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Habe Pilato i tayakid boda i nga, “Si he-iwo ya, nunuwamiu sega a pagotagan?” Si nga, “Barabas.” ");
INSERT INTO nmws_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bwen i tayakid i nga, “Sahe a ginawi Yeisu kaiwane gane si nga Mesaiya?” Bwabwaligadiye si nga, “U tagakoros-yan!” ");
INSERT INTO nmws_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato i tayakid i nga, “Sahe kaiwane ge a tagakoros-yan? Heto ngak i ginawi?” Agegene si gon gaigaisi suwok si nga, “U tagakoros-yan!” ");
INSERT INTO nmws_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato i lapu taine bosowaine i deginawi hiyede hotiya hedi, ge hawesine ege bwen boda si ginawi maleke. Iyete i howo bwai, i sawi nimane boda he matadiye ge i nga, “Tolomo ya tab wana mate hana pwapwatim hotiya i eluwom heyau. Hana logugui i miyeiwo heimiu.” ");
INSERT INTO nmws_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bobode bwabwaligadiye si nga, “Wana mate hana pwapwatim gen i miyeim hamai heyai ge he-nanatumai heidiye.” ");
INSERT INTO nmws_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iyete i pagotagan Barabas kaiwadiye, ge i liwo tosasagiyao si howo siyo veveroroine ge si rabrabik-an Yeisu, habe i hotei tosasagiyao he nimadiye iloke gen si tagakoros-yan. ");
INSERT INTO nmws_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilato wana tosasagiyao si pagolok Yeisu he logugui hana guwole lahine gamwane, habe si liwo wedi pan tosasagiyao-yan bwabwaligadiye si mipase ge si mipainan Yeisu. ");
INSERT INTO nmws_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Si lake yok hana kaliko, bwen kaliko mwalao matane pepol sohode kin hedi kaliko, si howo ge si pasipo heine. ");
INSERT INTO nmws_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Habeto si howo pipisare ge si ginawi hana dapwapwau iloke si hotei he kahulune. Bwen si howo hepotihe hotiya ge si hotei he nimane wana hinone sohode kin wedi page, habe si lipwakoko he matane, hoge si doteti-yan si nga, “Ago, Judiya wedi kin!” ");
INSERT INTO nmws_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Si luwo punpun-an tuwane ge si howo hepotihe si lodongedonge-yan kahulune. ");
INSERT INTO nmws_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sauge si doteti-yan mwao, bwen si lake yok kaliko mwalao ge si pasipo totone hana kaliko. Habeto si pagotagan si ela bwele si tagakoros-yan. ");
INSERT INTO nmws_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sauge Yeisu si pagotagan si ela tagakoros kaiwane, si paidi tolomo hotiya gagama Sairin, hidane Saimon, bwen si padowakik iloke i hiyewo Yeisu hana koros. ");
INSERT INTO nmws_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Si sevin he hiyebe hotiya hidane Golgota. (Golgota hana sapu iye te “Pana Kaun Pwatumine.”) ");
INSERT INTO nmws_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Habe si ngongoehuk-an waen bwaine yei hotiya hamnane mamaliyeine ge si giyau heine, age sauge i mun nohon, bwen i boleu tan nuwane sohode i demun. ");
INSERT INTO nmws_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sauge si tagakoros-yan i mwao, bwen tosasagiyao si wari hana kaliko, habe si yomo pak ge si yoyoun-an yoyoun hotiya, iye te heine si talaotan kaliko hana pase tomase ge tomase heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bwen si tuwodau te he yake ge si hite kiki-yan. ");
INSERT INTO nmws_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hana pwapwatim si leli ge si tagapatad he kahulune dedenateine, i nga, “Ga yeya Yeisu, Judiya wedi Kin.” ");
INSERT INTO nmws_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tobwahiyewo si he-iwo he-bwaine si tagakorosid. Hotiya hana koros si pamidi he wana hinone ge hotiya he wana gegebe. ");
INSERT INTO nmws_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bobode hebwaden si sehadidi-yan Yeisu matadiye i lok si paidi, bwen huludiye si eloniknik-an ge si yamwa tunetune-yan ");
INSERT INTO nmws_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","si nga, “Veto u liwo tage bwele Guwole Gagabubine u mwanalake ge he yan ho-tuwon gamwane habe u pamidi hedi. Iyete sauge ya totom u pamwadiwo. Hebe huwo Helak natune, u sedau u seyok koros.” ");
INSERT INTO nmws_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Topowo lalahine, he-bwaidiye Logugui hana topapalapu ge Judiya wedi todedei, si yamwa tunetune-yan sohode hedi ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Si nga, “I pwamwadid mwage bobode papaine, agegene taine bosowaine i depwamwad totone. Tage iye Isrel wedi kin! Hebe totone i sedau i seyok koros, habeto ha goru heine. ");
INSERT INTO nmws_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I hotei Helak hana med. Gen ta hayao-yan tab Helak nuwane bwele i pamwad, kaiwane i nga, ‘Nau Helak Natune.’ ” ");
INSERT INTO nmws_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ge tobwahiyewo hebwaden si tagakorosid he-bwaine, sidiye si sinari-yan Yeisu sohode hedi ti yo. ");
INSERT INTO nmws_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Parae luwane, hiyebe bwabwaligane i gogou hana had tri oklok. ");
INSERT INTO nmws_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","He tri oklok he hadidine, Yeisu i gon pakai he halingadiye heine i nga, “Eloi, eloi, lama sabaktani?” Lihu yake hana sapu iye te, “Lo Helak, lo Helak, sahe kaiwane ge u miyokau?” ");
INSERT INTO nmws_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bobode topadine hebwaden si taltalmidi he yake, si longe halingane hoge si nga, “I gonan Ilaija ti yo.” ");
INSERT INTO nmws_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sauge yake tolomo hotiya i patadei i la i howo pune, i pabile he waen mwimwiheine hei ge i momos, bwen i hotei he hubwahi matane ge i pamwalao senge Yeisu i mun. ");
INSERT INTO nmws_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Habe he-bwaine si nga, “Gen ta matemate iloke ta paidi tab bwele Ilaija i luwom ge i pamwad.” ");
INSERT INTO nmws_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeisu i gon pakai hedi, habe yawedine i taeman mwao. ");
INSERT INTO nmws_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kaliko malemaleine gane si pakole ge si libe tem Guwole Gagabubine gamwane hei, sauge yake i masase telipuneik nate hana had i la i dau pa. Mwaniknik i youmate bwen kelekele si lutulutu ge pakpak si mamaene. ");
INSERT INTO nmws_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Haliwage-yan si mwapwe, habeto Helak wana bobode hebwaden si mate dei, si hoyowate si suwoyuk. ");
INSERT INTO nmws_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Si suwoyuk yok hedi haliwage, ge Yeisu wana suwoyuk hedi he muine si la si setuk Jerusalem ge si youmate bobode si hoyowate heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tosasagiyao hebwaden si miyemiye he yake bwaidiye wedi todedei si mimitahasik Yeisu, si hamnohon mwaniknik hamnane ge bigi bwabwaligane gane i gan si paidi, hoge si matok suwok ge si nga, “Tolosuwok iye Helak Natune!” ");
INSERT INTO nmws_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Venakau si hoyowate si midimidi lawi, bwen matadiye i lok ge si hayaoyan Yeisu. Venakau hebwaden ya veto si sebelen Yeisu, bwaidiye si sehudiim Galili ge si matahasik. ");
INSERT INTO nmws_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","He gamwadiye, Meri Magdala vainiine, wana valese Meri gane Jems ge Josep tinadiye, ge hotiya hedi Sebedi he-nanatune tinadiye. ");
INSERT INTO nmws_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sauge i kokoyavi suwok, towasewase hotiya gagama Arimatiya, hidane Josep, i luwom, iye hedi Yeisu wana topadavae hotiya. ");
INSERT INTO nmws_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I la Pilato heine ge i hawanun-an Yeisu tuwane nuwane i ehowo, habeto Pilato i liwo gen si giyau heine. ");
INSERT INTO nmws_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep i howo Yeisu tuwane, i hapo he kaliko tovevai, ");
INSERT INTO nmws_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ge i la i hotei totone he wana haliwage tovevai gamwane, gane veto i hen tukan he pak. Bwen i pulim lok pak lahine hotiya ge i pulim gane haliwage hawane, habe i seyok. ");
INSERT INTO nmws_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri, Magdala vainiine, bwaine wana valese si tuwodau te he yake, hedi hao i loklok he haliwage. ");
INSERT INTO nmws_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabat hana yan lovivine i mwao, i yan hedi, habeto topowo lalahine ge Farisi si lok Pilato heine. ");
INSERT INTO nmws_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Habe si liwo heine si nga, “Gamalak, ha nuwohasik toyoyokapis ga yake, sauge habe taine i demate i nga, ‘Bwele yan ho-tuwon i mwao, habe a suwoyuk hedi.’ ");
INSERT INTO nmws_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iyete u liwo tosasagiyao si la he haliwage ge si matahasik hana had yan ho-tuwonine i mwao. Hebe taine ta deginawi sohode ti yake, anamate wana topadavae bwele si lok ge si howo tuwane, habe si liwo bobode heidiye si nga, ‘Hobak i suwoyuk hedi.’ Iloke yokapisi ga yeya bwele i kai suwok, taine sohode gane dedei.” ");
INSERT INTO nmws_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato i liwo topowo lalahine ge Farisi heidiye i nga, “I dohob, gen hu sehapeid lo tosasagiyao topadine ge hu la hu yomoteiid iloke si matahasik haliwage. Hu lok, bigi bwabwaligane gen hu ginawi gane bosowaimiu hu ginawi iloke haliwage hana matahasik i dohob.” ");
INSERT INTO nmws_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Habeto si la si pap hasik siyo hotiya he haliwage gegedine ge he pak yake wedi bagayeune, bwen si yomoteiid tosasagiyao ilok si matahasik haliwage. ");
INSERT INTO nmws_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yan Sabat i mwao, he wik hana yan dedei hei henanai suwok, Meri Magdala vainiine bwaine wana valese si la si kenani haliwage. ");
INSERT INTO nmws_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Habeto mwaniknik lahine i youmate. Guyau wana anelose hotiya i sehudi he bulubulu i la he haliwage, i pulim yok pak ge i tuwodau he pwatane. ");
INSERT INTO nmws_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mangingine i piklame sohode pilame ge hana kaliko i kanekane sohode kepwalipwali. ");
INSERT INTO nmws_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tosasagiyao hebwaden si mimitahasik haliwage si matok suwok ge si ginu, bwen si sopiyele he kelekele, taine si denipinipi, sidiye sohode tomate. ");
INSERT INTO nmws_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anelose i liwo venakau yake heidiye i nga, “Tab hu ematok! A lapu Yeisu gane si tagakoros-yan hu luluweni. ");
INSERT INTO nmws_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Agegene tan i degan te he ya, hobak i suwoyuk, sohode wana lihu. Hu luwom hu paidi habane, gane i hinhiyene hei. ");
INSERT INTO nmws_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Habekik hu lok ge hu la hu giyau wana topadavae wedi wase hu nga, ‘Hobak i suwoyuk he mate ge bwele i dedei he matamiu i la Galili. Habe hu paidi hei.’ Lemi wase te hobak a giyau tei.” ");
INSERT INTO nmws_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bwen venakau yake habekik si seyok haliwage, si matok, agegene yariyae hedi i susuwoku he hatiyediye, ge si patadei si ela tage si egiyau wana topadavae wedi wase. ");
INSERT INTO nmws_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sauge si edodogan la he hiyede, habe Yeisu i sepaleid ge i nga, “A gomulolu heimiu!” Si luwom heine si lipwakoko, hehene si pihasik ge si kululu heine. ");
INSERT INTO nmws_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Habeto Yeisu i liwo heidiye i nga, “Tab matok! Hu la hu giyau he-hauhavau wedi wase gen si la Galili, habe bwele si paidiyau te he yake.” ");
INSERT INTO nmws_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Saugeine venakau si edodogan la he hiyede, bwen tosasagiyao topadine hebwaden haliwage hana tomatahasik si sehavile si la Jerusalem, ge bigi bwabwaligane gane i youmate si waseyan topowo lalahine heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Habeto topowo lalahine he-bwaidiye Judiya wedi todedei si mipase ge si ginawi wedi logugui hotiya, bwen si giyau mwani lahine tosasagiyao heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Si liwo heidiye si nga, “Hu liwo bobode heidiye hu nga, ‘Ha hene saole he gogou, hoge wana topadavae si luwom ge si howo tuwane.’ ");
INSERT INTO nmws_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hebe Pilato i longe wase ya, hamai habe bwele ha gopasapu heine, iyete taine bwele hu depaidi ngakine hotiya.” ");
INSERT INTO nmws_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bwen tosasagiyao si howo mwani ge si ginawi sohode topowo lalahine wedi lihulihu heidiye. Iyete Judiya bobodeidiye si pareru wase yake hana had yan ya, tage Yeisu wana topadavae si la si howo tuwane. ");
INSERT INTO nmws_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Topadavae hebwaden si he-yawate si he-tiya (11) si la Galili, he bobokun gane veto Yeisu i lihuyan heidiye. ");
INSERT INTO nmws_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Saugeine si paidi, bwen si kululu heine, agegene topadine si nuwo veveiwo. ");
INSERT INTO nmws_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeisu i pililok heidiye bwen i nga, “Logugui ge gaisi bwabwaligane he bulubulu ge he panayawi, hobak Tamau i giyau heyau. ");
INSERT INTO nmws_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iyete hu la hu wase wabene bwabwaligane heidiye gen si tabwa lo topadavae, hu pabaptaisid Tamade, Natune ge Yayaluwo Gagabubine he hidane heine, ");
INSERT INTO nmws_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ge logugui bwabwaligane gane a lihuyan heimiu hu palapuid gen si sebelen. Tolosuwok nau bwele bwaimiu ege sauge bwabwaligane hana had panayawi hana bagapamwao.” ");
INSERT INTO nmws_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Nau Pol, Helak wana nuwotu heine a tabwa Keriso Yeisu wana apostol. A leli leta ya ge a patile i lowo Helak wana bobode hebwaden hu miye Efeso heimiu, humiu togoru suwok Keriso Yeisu heine. ");
INSERT INTO nmws_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Helak Tamade ge wada Guyau Yeisu Keriso gen si muloluyanmiu ge wedi mimalum gen i pasusuwoku hatiyemiu. ");
INSERT INTO nmws_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Ta tobalan Helak, iye wada Guyau Yeisu Keriso wana Helak ge Tamane. I bosowaine suwok ta tobalan, kaiwane Keriso hei hobak i giyau heide mulolu bwabwaligane i hudi he bulubulu yayaluwade wana dohob kaiwane. ");
INSERT INTO nmws_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Sohode tagi ya. Muyai habe i ginawi panayawi, Keriso heine hobak i haseide wana bobode gen ta bwabwalene ge tab hada pwapwatim i egan he matane. ");
INSERT INTO nmws_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","Sauge veto dedei i nunuwane-yanide, iyete i nuwotu pasuwae te Yeisu Keriso wana kaiwo hei habe i hawa he-nanatune-yanide. Iye totone he wana yariyae ge wana nuwotu te i ginawi sohode ti yake. ");
INSERT INTO nmws_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Iyete ta tobalan wana mulolu madimadiine kaiwane, mulolu yake hobak i giyo bwage-yan heide he Natune nunuwaneine suwok. ");
INSERT INTO nmws_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Helak wana mulolu i kai suwok, iyete Keriso wana mate hei Helak hobak i pamaise pahavileide ge i nuwoyok wada gegi. ");
INSERT INTO nmws_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Helak i ligin nabiyan wana mulolu heide bwaine sibe bwabwaligane ge lapu dodohobine. ");
INSERT INTO nmws_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Wana nuwotu sumosumoine hobak i payoumate heide, kaiwane i yariyae-yan te Keriso hei i ginawi sohode. ");
INSERT INTO nmws_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Hana sauge suwok hei benan i ginawi wana nuwotu yake, iye te bwele bigi bwabwaligane he bulubulu ge he panayawi i pipatoyao ge Keriso iye i kaun-an. ");
INSERT INTO nmws_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Hamai Keriso hei Helak i yomoyai wana bobode, kaiwane sauge veto dedei i nuwotu sohode. (Bigi bwabwaligane Helak i ginawiid sohode iye wana nuwotu.) ");
INSERT INTO nmws_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Iyete hamai hebwaden ha hotei deiyan Keriso hana med, Helak i yomoyai wana bobode iloke gen ha hosenge Helak hidane ge ha tobalan. ");
INSERT INTO nmws_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Humiu hedi, hu longe wase tolosuwokine, iye Yeisu Wasane Dodohobine hemi pwamwad kaiwane, iyete hobak hu goru Keriso heine ge hu tabwa wana bobode-yan. Iyete Helak hobak i hotei hetutuhine heimiu sohode bagayeune, iye te Yayaluwo Gagabubine i giyau heimiu sohode wana liwo tuwoi. ");
INSERT INTO nmws_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Hobak ta ho mwao Yayaluwo Gagabubine, iloke ta lapu dohob bwabwaligane hebwaden Helak i gotei kaiwade benan habe ta howo hedi. Ta matemate hana had Helak i sohe suwokanide ge i yomoide bwaide ta miye. Ta hosenge hidane ge ta tobalan! ");
INSERT INTO nmws_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Hobak a longe lemi goru Guyau Yeisu heine ge lemi nunuwane Helak wana bobode heidiye wasane. ");
INSERT INTO nmws_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","Ga yake kaiwane taine a edemanao gomulolu Helak heine kaiwamiu, ge sauge hoyowate a ehauhawanun kaiwamiu. ");
INSERT INTO nmws_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","A hawanun wada Guyau Yeisu Keriso wana Helak, iye Tamade Towasewase, gen i giyau Yayaluwane heimiu, iloke iye i pasibemiu ge i payoumate Helak heimiu, bwen hana lapu i kai heimiu. ");
INSERT INTO nmws_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","A hawanun Helak gen i pawayae lemi nuwotu, iloke gen hu lapu te iye hobak i gon heimiu ge bosowaine bwaimiu lemi hatamatuwo hu mimihuvave wasewase lahine gane Helak habe i giyau hide wana bobode heide. ");
INSERT INTO nmws_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Sohode hedi gen hu lapu Helak wana gaisi i kai suwok mwage i kaikaiwo hide togoru-yan heide. Gaisiine hotaege hei te ");
INSERT INTO nmws_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","Helak i pasuwoyukim Keriso he mate ge i hotei i tuwodau he nimane wana hinone he bulubulu. ");
INSERT INTO nmws_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Iyete Keriso iye i kai lakeid todedei bwabwaligadiye, gaisi denan bwabwaligadiye, anelose-yan bwabwaligadiye, tologugui bwabwaligadiye, ge ide bwabwaligane hebwaden si gan sauge ya ge hebwaden habe si gan sauge eluwom. ");
INSERT INTO nmws_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Helak i hotei Keriso i logugui-yanid bigi bwabwaligadiye si miye he hehene gabulane, ge i hotei i kaunan ekelesiya hana duwohe bwabwaligane. ");
INSERT INTO nmws_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Ekelesiya iye Keriso tuwane, ge Keriso iye i pabwasowo ekelesiya ge i pasusuwoku hana dohob bwabwaligane. ");
INSERT INTO nmws_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Veto lemi hawatautau ge lemi gegi kaiwane yayaluwamiu hobak i mate. ");
INSERT INTO nmws_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","He saugeine yake hu edodoganan panayawi hana nuwotu gogogouine, ge hu esebelen yayaluwo bikbikine wedi todedei Seitan wana hiyede. Iye taine ta depaidi, agegene i logugui-yanid bobode hebwaden taine si dehawatau-yan Helak. ");
INSERT INTO nmws_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Veto hide bwabwaligade ta emiye bobode hebwaden yake he wedi boda, bwen ta esebelen tuwade yawedine ge ta eginginawi page hebwaden tuwade ge wada nuwotu nuwane. Sauge hide ta emimisohode yake, bosowaine te Helak bwaine wana huge i pelaseide hene-bwaide ge bobode hoyowate. ");
INSERT INTO nmws_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","5","Hide wada hawatautau kaiwane yayaluwade hobak i mate. Agegene Helak i susuwoku-yan nuwalolu, ge wana nunuwane heide i kai suwok, iyete i pasuwoyukide bwaide Keriso ta paidi yawed tovevai. Helak wana mulolu bwage hei te hu paidi mwad. ");
INSERT INTO nmws_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Hide ta miye Keriso Yeisu heine, ilok Helak i pasuwoyukide bwaide Keriso he mate, ge i hoteide bwaide Keriso ta miye he bagatuwodau wasewaseine he bulubulu. ");
INSERT INTO nmws_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Iyete hide ta tabwa bagahahayao sauge i eluwom bobodeidiye kaiwadiye iloke si lapu Helak wana mulolu bwage i kai suwok, kaiwane Keriso Yeisu heine i nunuwane-yanide. ");
INSERT INTO nmws_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Sauge hu goru, Helak wana mulolu bwage hei te hu paidi mwad. Taine lemi logaisi hinone sohode, agegene Helak wana giyo bwage heimiu. ");
INSERT INTO nmws_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Taine lemi kaiwo maisane sohode, iyete taine bosowaine humiu hotiya i degotabwaraha. ");
INSERT INTO nmws_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Keriso Yeisu hei Helak i ginawi patovevaiide, nuwane te ta eginawiid kaiwo dodohobidiye, hebwaden i lovivine-yan pasuwae ge habe ta emiyemiye-yan. ");
INSERT INTO nmws_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Humiu si habmiu taine Judiya bobodeidiye sohode-yan. Judiya si godongedongemiu si nga, “Humiu taine hu deho gogotem yok pageine sohode hamai hobak ha howo, iyete humiu taine Helak wana bobode-yan sohode, hamai ege te Helak wana bobode-yan.” (Agegene page yake bobode totodiye si ginawi, ge hana nunuwotu i selok ege te tutuwo hei.) Iyete gen hu nuwopik te mwatan veto lemi miyemiye. ");
INSERT INTO nmws_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Saugeine yake hu mivevek Keriso heine. Humiu sohode bwabwali, taine hidamiu i degan boda Isrel Helak wana bobode heidiye, sohode hedi lihu tuwoi hebwaden Helak he-bwaine Isrel si ginawi, humiu taine kaiwamiu sohode. Lemi miyemiye he panayawi, taine dohob hotiya i degan kaiwamiu ge tage bwaimiu lemi hatamatuwo hu mimihuvave dohob yake kaiwane, ge taine hu delapu Helak. ");
INSERT INTO nmws_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Agegene sauge ya humiu hebwaden veto hemi bwage i mwalao hu miye Keriso Yeisu hei, iyete madibane hobak i mwanapasemiu Helak heine. ");
INSERT INTO nmws_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Keriso iye i pamalum hatiyede iloke hene-bwaide ge hene-bwaide ta mivetahe. Veto hamai Judiya ge humiu hebwaden taine Judiya sohode ta pehugehuge-yanide, bwen pehugehuge yake sohode libegane i wari-yanide boda ho-iwo. Agegene Keriso iye tuwane hei i lake yok libegane yake, bwen i hotei papetaege boda ho-iwo ta tabwa boda hotiya. ");
INSERT INTO nmws_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Judiya lama Logugui loguguiine i hoyowate, age Keriso hobak i pamwao Logugui yake. I ginawi sohode, iloke i hotei papetaege boda ho-iwo yake, bwen i ginawi boda tovevai hotiya ge ta mivetahe. ");
INSERT INTO nmws_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Keriso wana mate he koros i pamwao boda ho-iwo wada pehugehuge, i tubwenide hide sohode tutuwo hotaege ge i ho pahavileide Helak heine. ");
INSERT INTO nmws_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Iye i luwom ge mimalum wasane i papalapu-yan, humiu heimiu hebwaden veto hemi bwage i mwalao Helak heine, ge hamai heyai hebwaden ha mipahubo Helak heine. ");
INSERT INTO nmws_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Hobak ta mivetahe, kaiwane Keriso heine hide boda ho-iwo wada sapu i gan ge bosowaide Yayaluwo Gagabubine wana labe hei ta lok Tamade heine. ");
INSERT INTO nmws_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Iyete sauge ya humiu taine hedi sohode bwabwali ge tosesevin, agegene hene-bwaimiu Helak wana bobode humiu tonhiyebe ge humiu Helak hana hun bobodeidiye. ");
INSERT INTO nmws_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Sohode hedi, humiu guwole gane Helak i pamidi hana ginawi topadine-yan. Hamai apostol he-bwaimai profet hamai sohode pak hebwaden si vateid dedepao guwole hana mwalu kaiwane, ge Keriso Yeisu iye pak rurumwaruine gane si hotei he kona suwok. ");
INSERT INTO nmws_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Guwole hana ginawi bwabwaligane si tubwen Keriso heine bwen guwole i ekaikai la ge i tabwa guwole gagabubine Guyau heine. ");
INSERT INTO nmws_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Hu miye Keriso heine, iloke humiu hedi Helak i tubwen toyaomiu he-bwaimiu wana bobode bwabwaligadiye, bwen hu tabwa Helak bwaine Yayaluwane wedi bagamiye. ");
INSERT INTO nmws_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Helak i ginawi sohode ti yake kaiwamiu, iyete ga yake kaiwane a hauhawanun kaiwamiu. Nau Pol mwage he dibula, kaiwane a ginawi Keriso Yeisu wana kaiwo humiu hebwaden taine Judiya-yan sohode kaiwamiu. ");
INSERT INTO nmws_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Anamate hobak hu longe te Helak i giyau ho mulolu ge a kaiwo kaiwamiu. ");
INSERT INTO nmws_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Ho mulolu gane i giyau iye te i patoheyau wana nuwotu sumosumoine ge a lapu. (Hobak hawesine a lihuyan mwao Helak wana nuwotu sumosumoine lihuine. ");
INSERT INTO nmws_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Iyete hebe hu pahone sahe a luluweli-yan, bwele hu paidi tolosuwok a lapu wana nuwotu sumosumoine, gane i ginawi Keriso hei.) ");
INSERT INTO nmws_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Sauge veto dedei bobodeidiye taine si delapu Helak wana nuwotu sumosumoine, agegene sauge ga ya Yayaluwo Gagabubine wana gaisi heine hobak i payoumate hamai wana apostol-yan ge wana profet-yan gagabubidiye heyai. ");
INSERT INTO nmws_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Wana nuwotu sumosumoine yake sohode ti ya. Humiu hebwaden taine Judiya-yan sohode hu goru he Wase Dodohobine, iloke hamai Judiya hene-bwaimai humiu ta ho toyao wana mulolu gane i lovivine-yan, he-bwaimai humiu hide sohode tutuwo hotaege giniteine, ge Keriso Yeisu heine ta ho toyao Helak wana lihu tuwoi. ");
INSERT INTO nmws_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","I giyau ho mulolu a tabwa Wase Dodohobine yake hana tokaiwo. Ge i giyau wana gaisi heyau ge hei a ginginawi wana kaiwo. ");
INSERT INTO nmws_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Bwagane nau Helak wana bobode bwabwaligadiye wedi totankainane, i giyau ho mulolu te dohob malemaleine gane ta paidi Keriso heine, wasane a papalapu-yan hebwaden taine Judiya-yan sohode heimiu. ");
INSERT INTO nmws_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Helak i giyau lo kaiwo a gopawayae bobode bwabwaligadiye heidiye wana nuwotu sumosumoine gane nuwane i ginawi. Helak, iye bigi bwabwaligadiye hedi toginawi, sauge veto dedei heine wana nuwotu yake i ho sumwan. ");
INSERT INTO nmws_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Nuwane te sauge ya todedei ge gaisi denan he bulubulu, he ekelesiya hei iye wana sibe yauyawate si lapu. ");
INSERT INTO nmws_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Sauge veto dedei suwok Helak i nuwotu bwele i ginawi sohode ti yake, iyete sauge ga ya Keriso Yeisu wada Guyau wana kaiwo heine hobak i ginawi mwao. ");
INSERT INTO nmws_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Ge hide ta miye Keriso hei ge ta goru heine, iloke taine ta dematok te ta lok Helak he hana hao bwaide wada hatamatuwo. ");
INSERT INTO nmws_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Iyete a liwo heimiu, tab nuwamiu i engak ge yayaluwamiu i epwayate kaiwane nau a paidi tilao kaiwamiu. Nau lo tilao hinone te humiu hu paidi dohobine, iyete gen hu yariyae-an. ");
INSERT INTO nmws_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Helak i ginawi sohode ti yake kaiwamiu, iyete a lopwakoko Tamade he matane, ");
INSERT INTO nmws_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","iye hun bwabwaligadiye he bulubulu ge he panayawi hedi topayoumate. ");
INSERT INTO nmws_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Tamade i susuwoku-yan bigi dodohobidiye hohoyowate nuwane i yomo giyau heimiu, iyete a hawanun Yayaluwo Gagabubine wana kaiwo heine gen i pagaisi yayaluwamiu, ");
INSERT INTO nmws_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ge lemi goru kaiwane Keriso gen i solavi he hatiyemiu. A hawanun gen hewasiimiu i sedau he nunuwane pageine ge yawedimiu i matuwo, sohode hubwahi hewasiine i sedau ge i kukuhasik kelekele. ");
INSERT INTO nmws_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","A hawanun he-bwaimiu ge Helak wana bobode bwabwaligadiye bosowaimiu hu lapu Keriso wana nunuwane hana malemale, hana mwalao, hana misai, ge hana midau. ");
INSERT INTO nmws_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Hide bobode taine bosowaine ta delapu Keriso wana nunuwane hana kaikai, age a hawanun gen hu lapu vetahe wana nunuwane yake ge hu hamnohon hamnane. Ilok Helak, iye i susuwoku-yan dohob bwabwaligane, gen i miye heimiu ge i pasusuwokumiu. ");
INSERT INTO nmws_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Helak wana gaisi mwage i kaikaiwo heide, iyete heto sahe ta hawanunan o hebe heto sahe ta nuwotuyan, iye bosowaine i ginawi lake. ");
INSERT INTO nmws_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Iyete hide hebwaden ta miye he ekelesiya gamwane ge Keriso Yeisu heine, sai ge sai ta hawa wasewase-yan Helak, sauge hohoyowate taine i edemwao. Bam, sohode. ");
INSERT INTO nmws_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Nau mwage he dibula kaiwane a kaiwo Guyau kaiwane, iyete a gopagaisimiu yawedimiu hana miyemiye gen sohode Helak wana nuwotu ge habe i gon heimiu. ");
INSERT INTO nmws_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Sauge hoyowate gen hu hotei donge totomiu ge lemi page gen hu pameimei. Tab egene habekik hu ehuge, age bwaimiu lemi nunuwane gen hu palahasik hene-bwaimiu wedi ginawi heimiu. ");
INSERT INTO nmws_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Yayaluwo Gagabubine i pamalumide, ge mimalum yake i tubwenide ta tabwa boda hotaege. Iyete gen hu logaisi ge mitoyao yake pageine tab i emwao. ");
INSERT INTO nmws_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Bwabwaligade hide sohode tutuwo hotaege, ge Yayaluwo Gagabubine gane ta howo iyege te hotiya. Sohode hedi, bwaide wada hatamatuwo bwabwaligade ta mimihuvave dohob hotiya ege te kaiwane, gane Helak i lovivine-yan kaiwade ge habe i gon heide. ");
INSERT INTO nmws_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Wada Guyau iyege te hotiya, bwabwaligade wada goru iyege te hotiya, ge hada baptais iyege te hotiya. ");
INSERT INTO nmws_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Wada Helak iyege te hotiya, iye hide bwabwaligade Tamade. Iye i logugui-yanid bobode bwabwaligadiye, iye i kaiwo bwabwaligadiye heidiye, ge i miye bwabwaligadiye he gamwadiye. ");
INSERT INTO nmws_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Hide hotiya ge hotiya Keriso i talaotan hada mulolu, i giyau heide sohode iye wana nuwotu. ");
INSERT INTO nmws_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Sohode Buk Bwabwalene hana lihulihu, i nga, “Saugeine i sesai nate he hiyebe mimisaiine suwok, he-bwaine ge hebwaden hobak i pakokoveid ge i yawanid, bwen i talaotan bobode hedi mulolu heidiye.” ");
INSERT INTO nmws_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","(Lihu gane i nga, “i sesai” i patoheide te dedei gen i luwom i sedau dedepao suwok he panayawi. ");
INSERT INTO nmws_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Gane i sedau, tolomoine hotaege te i sesai nate. Taine tage i dela i desesai ege te he bulubulu, agegene i sek hedi i misai nate suwok, iloke pihalae bwabwaligadiye bwele i yabom ge i pasusuwoku.) ");
INSERT INTO nmws_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Iloke iye i talaotan bobode hedi mulolu heidiye sohode ti ya. Topadine hedi biyebe i giyau si tabwa apostol, topadine profet, topadine Wase Dodohobine hana towase, ge topadine toekelesiya hedi tomatahasik ge hedi topapalapu. ");
INSERT INTO nmws_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","I giyau bobode hedi biyebe sohode ti yo, nuwane i lovivine-yanid Helak wana bobode si ginawiid kaiwo dodohobidiye, bwen ekelesiya, iye Keriso tuwane, bwele i ekaikai la ge i egaigaisi la. ");
INSERT INTO nmws_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Hana bagapamwao hide sohode boda hotiya suwok kaiwane ta goru Helak Natune heine ge ta lapu vetahe, hide sohode bobode mamatuwoidiye, ge wada page sohode page gane Keriso i susuwoku-yan. ");
INSERT INTO nmws_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Bwen taine hedi hide sohode gamagai, taine hedi hide sohode wage gane bagod i tagaluwomlowo-yan, ge taine hedi bosowaine bobode sibesibeidiye wedi papalapu i dewi liyeliye-yanide sohode yangak wana ginginawi. Sidiye si ginawiid yoyokapis hana hiyede i hoyowate ge hei si pagegiid bobode. ");
INSERT INTO nmws_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Bwele hide taine hedi sohode ti yo, agegene bwaide wada nunuwane lihu tolosuwokine ta lihulihu-yan ge ta siwi gaigaisi hana had ta tubwen suwok Keriso hei, iye ekelesiya hulune. ");
INSERT INTO nmws_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Iye i logugui-yan tutuwo bwabwaligane, bwen giniteine tomase ge tomase si tubwen papetaege. Ginite hotiya ge hotiya totone wana kaiwo i ginginawi, iyete tutuwo bwabwaligane i siwisiwi ge i egaigaisi lok he nunuwane pageine. ");
INSERT INTO nmws_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Guyau he hidane heine a gopagaisimiu sohode ti ya. Tab hedi lemi miyemiye sohode bobode hebwaden taine si delapu Helak. Sidiye wedi nuwotu bwabwaligane taine hinone i degan, ");
INSERT INTO nmws_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ge hatiyediye i gogou. Taine wedi lapu suwok i degan ge hatiyediye i kakasiye sohode pak, iyete sidiye taine hidadiye i degan he yawed gane i hudi Helak heine. ");
INSERT INTO nmws_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Taine hedi si demwadine-yan wedi ginawi, age si taemanid he ginawi ngakngakine hei ge page mwadmwadineine si gino bebelen ege. ");
INSERT INTO nmws_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Agegene humiu lemi lapu Keriso kaiwane taine sohode ti yake. ");
INSERT INTO nmws_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Hobak hu longe mwao Keriso wasane, ge lihu tolosuwokine gane Yeisu heine hobak si palapumiu humiu hana tosedumuyai-yan. ");
INSERT INTO nmws_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Iyete gen hu ho yok yawedimiu toyaune gane pageine veto hu emiyemiye-yan, kaiwane yawed yake hamnaneine i huli pagegimiu bwen i bagapangekmiu. ");
INSERT INTO nmws_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Hatiyemiu ge lemi nuwotu gen i tovevai, ");
INSERT INTO nmws_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ge gen hu ho tukan yawedimiu tovevai, yawed yake pageine sohode Helak wana page, i sapu ge i bwabwalene suwok. ");
INSERT INTO nmws_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Iyete tab hedi hu eyoyokapis! Humiu hotiya ge hotiya gen i egotolosuwok wana pan togoru heine, kaiwane hide bwabwaligade tutuwo hotaege giniteine denan. ");
INSERT INTO nmws_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Hebe hu huge, tab lemi huge i eyouhomiu ge hu eginawi gegi. Ge tab lemi huge hana sauge i emwalao i ela parae i edobiyek, ");
INSERT INTO nmws_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ge tab Seitan wana hauhawal hotiya hu egiyau. ");
INSERT INTO nmws_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Tolomo gane i bwabwahiyewo, tab i ebwahiyewo hedi, agegene gen i pakaiwo nimane kaiwo dodohobine i ginawi. Iloke bwele i paidiid wana bigi i hoyowate ge bosowaine gen i labeid togulegule. ");
INSERT INTO nmws_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Tab lihu ngakngakine hu elihuyan, age lihu dodohobine egene hu elihuyan gane bosowaine i labeid bobode hebwaden hedi puyowo ganganine ge si gaisi. Iloke bobode hebwaden si papadavae-yan lemi lihu, wedi dohob bwele si paidi hei. ");
INSERT INTO nmws_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","Tab hu ebagapangek Helak Yayaluwane Gagabubine nuwane, iye Helak wana yeune heimiu i payoumate te humiu iye wana bobode, iloke hu lapu benan habe i sohe suwokanmiu. ");
INSERT INTO nmws_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Hata mamaliye hamnane bwabwaligane hu ho yok heimiu, bwaine huge. Tab hu egoyamwarare-yanid hene-bwaimiu ge tab hu egopanpangek-anid. Tab pehugehuge pageine i egan heimiu. ");
INSERT INTO nmws_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Age lemi page gen hu pameimei hene-bwaimiu heidiye ge hu hatatilao-yanid. Hu nuwoyok he-bwaimiu wedi gegi heimiu, sohode Keriso hei Helak hobak i nuwoyok lemi gegi. ");
INSERT INTO nmws_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Humiu Helak he-nanatune nunuwaneine, iyete hu hamnohon humiu gen sohode iye. ");
INSERT INTO nmws_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Nunuwane pageine gen hu edodogan-an, sohode Keriso i nunuwane-yanide. Iye i taeman yawedine hide kaiwade sohode powo bwabwalaiine gane Helak i yariyae-yan. ");
INSERT INTO nmws_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Ganawal pageine ge page mwadmwadineine, ge tomemek pageine, tab tankai hotiya i egan heimiu. Page henebwaden yake humiu Helak wana bobode gagabubidiye taine bosowaimiu sohode. ");
INSERT INTO nmws_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Sohode hedi, tab papabek, tab gogobwage suwok, ge tab ganawal dotetiine hu elihuyan, kaiwane taine i dedohob-anmiu. Age hu lihuyan gomulolu egene Helak heine. ");
INSERT INTO nmws_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Nuwamiu i sapu te hebwaden si eginginawi ganawal pageine ge page mwadmwadineine ge hebwaden si tomemek, taine habadiye i degan Keriso ge Helak he wedi bagalogugui hei. (Tomemek pageine te sohode ta kukululu lok helak yoyokapisine heine.) ");
INSERT INTO nmws_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Iyete tab tolomo hotiya wana lihu yoyokapisine hei ge i egohowo nuwamiu. Page denan yake kaiwadiye Helak wana huge bwele i luwom bobode hebwaden taine si delonge halingane heidiye. ");
INSERT INTO nmws_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","Iyete tab hene-bwaimiu bobode sosohode-yan yake hu epebwange. ");
INSERT INTO nmws_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Veto hu emiye he gogou, age sauge ya Guyau heine hu miye he wayae. Iyete yawedimiu hana dodogan gen sohode humiu wayae he-nanatune, ");
INSERT INTO nmws_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","10","ge hu luweni sahe gane Guyau i yariyae-an iloke gen hu lapu. Kaiwane wayae hinone iye te page dodohobine, page sapusapuine ge gotolosuwok. ");
INSERT INTO nmws_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","Tab hu eselok gogou pageine hana ginginawi hei, kaiwane taine hinone i degan, age hu payoumateid he wayae ge bobode si lapu gegi ti yake. ");
INSERT INTO nmws_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","(Gane bobode si ginawi sumwan taine bosowaiu a degotagan, a mwadine-yan hana lihulihu.) ");
INSERT INTO nmws_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Bigi bwabwaligadiye hebwaden ta payoumateid he wayae, hobak ta paidiid vetahe, ");
INSERT INTO nmws_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","kaiwane wayae iye i hotei taganid bigi bwabwaligane ge ta paidi vetahe. Iye te kaiwane wada lihu hotiya i nga: U suwoyuk, huwo tohiyene, u suwoyukim he mate, iloke Keriso wayayane i pawayaeiwo. ");
INSERT INTO nmws_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Yawedimiu hana dodogan hu matahasik vetahe. Gen humiu sohode hebwaden tonuwosapu, tab humiu sohode hebwaden taine nuwadiye i desapu. ");
INSERT INTO nmws_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","Tab lemi sauge dodohobine hotiya hu epasibaleno-yan, kaiwane sauge ya ngak hana ginginawi hobak i gaisi. ");
INSERT INTO nmws_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Tab hu eboliboli, agegene gen nuwamiu i sapu-yan Guyau wana nuwotu kaiwamiu. ");
INSERT INTO nmws_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Tab hu emun kabaleya-yan bwai gaigaisiine, hebe hoge i bagapangekmiu. Agegene hu susuwoku-yan Yayaluwo Gagabubine. ");
INSERT INTO nmws_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Gen hu lihu-yan sam, wok tapwalolo ge wok hebwaden Yayaluwo Gagabubine wana giyau hedi lihulihu hene-bwaimiu heidiye. Gen hu wok tobal Guyau heine he hawamiu ge he hatiyemiu hedi, ");
INSERT INTO nmws_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ge wada Guyau Yeisu Keriso he hidane hei, sauge hohoyowate hu egomulolu Helak Tamade heine bigi bwabwaligane kaiwadiye. ");
INSERT INTO nmws_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Gen hu senapuyan he-bwaimiu wedi logugui Keriso hana hawatau kaiwane. ");
INSERT INTO nmws_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Humiu mehaduwe venakau, gen hu senapuyan he-mwamwaniyemiu wedi logugui sohode hu senapuyan Guyau wana logugui. ");
INSERT INTO nmws_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Kaiwane tolomo iye poniyene hulune sohode te Keriso iye ekelesiya hulune. Ekelesiya iye Keriso tuwane, ge Keriso iye ekelesiya hana Topamwad. ");
INSERT INTO nmws_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Ekelesiya i senapuyan Keriso wana logugui, sohode hedi mehaduwe venakau gen si senapuyan he-mwamwaniyediye wedi logugui sauge hoyowate. ");
INSERT INTO nmws_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Humiu mehaduwe bobode, gen hu nunuwane-yanid he-ponponiyemiu sohode Keriso i nunuwane-yan ekelesiya ge i taeman yawedine kaiwane. ");
INSERT INTO nmws_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Yawedine i taeman nuwane i sawi pakanekane-id togoru-yan he bwai sohode Wase Dodohobine hana lihu. Keriso nuwane i pagabub ekelesiya, ");
INSERT INTO nmws_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ge i pamidi he matane sohode ekelesiya gane hana hao dodohobine suwok, taine hana pupuwok, taine tuwane i debaluli, ge taine ngakine hotiya hedi, agegene i sapusapu ge taine wana ngak i degan. ");
INSERT INTO nmws_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Sohode hedi ti yo, bobode gen si nunuwane-yanid he-ponponiyediye sohode si nunuwane-yan totodiye tuwadiye giniteine denan. Hebe tolomo i nunuwane-yan poniyene, sohode hedi i nunuwane-yan totone. ");
INSERT INTO nmws_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Taine sauge hotiya tolomo hotiya i edehuge-yan totone tuwane. Agegene i pahan ge i matahasik vetahe, sohode Keriso i ginawi hide ekelesiya heide, ");
INSERT INTO nmws_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","kaiwane hide iye tuwane giniteine denan. ");
INSERT INTO nmws_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Buk Bwabwalene i liwo, “Iye te kaiwane tolomo gen i miyokid tamane ge tinane i la bwaine ge poniyene si mipase iloke si toiwo si tabwa tutuwo hotaege.” ");
INSERT INTO nmws_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Buk yake hana nunuwotu i malemale suwok. Nau a lihu lok Keriso bwaine ekelesiya heidiye. ");
INSERT INTO nmws_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Age hana lihulihu i lowo hedi humiu heimiu. Iloke tolomo hotiya ge hotiya gen i nunuwane-yan poniyene sohode i nunuwane-yan totone, ge vaini gen i hawatau-yan mwaniyene. ");
INSERT INTO nmws_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Humiu gamagai, he-tintinamiu ge he-tamtamamiu hawadiye gen hu hab kaiwane humiu hu miye Guyau heine. I sapu te hu ginawi sohode ti yake. ");
INSERT INTO nmws_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Buk Bwabwalene i nga, “Tinam ge tamam gen u hawatau-yanid.” Logugui ga yake iye logugui dedei gane bwaine hana liwo tuwoi, ");
INSERT INTO nmws_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","ge liwo tuwoi yake i nga, “iyete bwele i dohob heim ge yawedim hana miyemiye i mwalao he panayawi.” ");
INSERT INTO nmws_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Humiu tametame, tab hu epahugeid he-nanatumiu, age hu panuboid vetahe, hu pasenapuid ge hu palupuid Guyau kaiwane. ");
INSERT INTO nmws_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Humiu tokaiwo yayawanidiye, gen hu hab lemi tonuwakau he panayawi hawadiye bwaine lemi hawatau ge lemi matok, ge bwaine hatiyemiu wana taem, sohode Keriso hawane hu hab. ");
INSERT INTO nmws_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Tab tage hebe si ehite hasikmiu ge habe hu ekaiwo vetahe, iloke si yariyae-yanmiu. Age hu kaiwo sohode humiu Keriso wana tokaiwo yayawanidiye ge hu ginginawi Helak wana nuwotu bwaine hatiyemiu bwabwaligane. ");
INSERT INTO nmws_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Hu kaiwo bwaine lemi yariyae, sohode hu kaikaiwo Guyau heine, taine tage bobode heidiye. ");
INSERT INTO nmws_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Kaiwane hu lapu Guyau bwele i giyau tolomo hotiya ge hotiya wana kaiwo dodohobine maisane heine, bwagane iye tokaiwo yayawanine o hebe tolomo susuwoheine. ");
INSERT INTO nmws_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Humiu hedi tonuwakau, gen lemi ginawi i dohob lemi tokaiwo yayawanidiye heidiye. Tab hedi hu epamatokid, kaiwane hu lapu sidiye ge humiu lemi Gamalak Lahine mwage he bulubulu, ge iye i ginawi pabwasowo bobode bwabwaligade heide. ");
INSERT INTO nmws_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","A pwamwao lo lihu sohode ti ya: humiu hobak hu miye Guyau heine, iyete wana gaisi lahine gen i pagaisimiu. ");
INSERT INTO nmws_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Gen hu sipo helolomaleke bwabwaligane hebwaden Helak i giyau heimiu, iloke bosowaimiu hu talmidi gaigaisi ge tab Seitan wana nuwotu i eyokapisimiu. ");
INSERT INTO nmws_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Hide taine tage he-bwaide wada pan bobode ta delomaleke, age he-bwaide yayaluwo bikbikine nate he hauhawal he-bwaidiye wedi todedei-yan ge wedi gaisi denan, henebwaden si logugui-yan panayawi gogogouine ya. ");
INSERT INTO nmws_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Helolomaleke hebwaden Helak i giyau heimiu bwabwaligane gen hu sipo, iloke bosowaimiu he sauge ngakngakine hei hu talmidi gaigaisi he maleke, ge sauge hu lomaleke mwao, humiu bwele mwage hu taltalmidi he habamiu. ");
INSERT INTO nmws_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Gen hu talmidi ge lemi siposipo sohode ti ya. Lihu tolosuwok hu lokin vetahe he luwamiu sohode hemi pan, ge page sapusapuine sohode wagwagamiu hana hehogane. ");
INSERT INTO nmws_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Lemi lovivine mimalum Wasane Dodohobine gen hu waseyan, gen sohode hu ho tukan hehemiu hana pase. ");
INSERT INTO nmws_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Sohedi hedi, hu howo goru sohode hemi yagove, ge hei hu hogane Seitan wana wamewame tautauidiye bwabwaligane ge hu pabode wedi dab. ");
INSERT INTO nmws_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Helak wana pwamwad hu howo sohode hemi pwapwahem gaigaisiine, ge Helak wana lihu hu howo sohode maleke kilepeine gane Yayaluwo Gagabubine i giyau heimiu. ");
INSERT INTO nmws_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Ge sauge hohoyowate Yayaluwo Gagabubine he wana gaisi hu ehauhawanun. Hu giyau lemi hawanun Helak heine puyowo bwabwaligadiye kaiwadiye ge hu liwo gen i labemiu. Iloke hu matalale ge hu mimi hauhawanun Helak wana bobode bwabwaligadiye kaiwadiye. ");
INSERT INTO nmws_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Nau hedi gen hu hawanun kaiwau. Hu hawanun te sauge hebe a lihulihu, Helak gen i giyauim lihu iloke hatiyeu i matuwo ge a gotagan Wase Dodohobine, iye Helak wana nuwotu gane veto i misumo. ");
INSERT INTO nmws_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Helak i patileyau Wase Dodohobine yake hana towase, ge ga yake kaiwane nau mwage he dibula. Iyete hu hawanun gen hatiyeu i matuwo ge a waseyan Wase Dodohobine sohode ho logugui. ");
INSERT INTO nmws_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Tisikus, iye havade nunuwaneine ge tokaiwo dodohobine Guyau kaiwane, wasau bwabwaligane habe i lihuyan heimiu, iloke hu lapu mwatan lo miyemiye. ");
INSERT INTO nmws_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Ga yake kaiwane iyete a patile i lowo heimiu iloke hu lapu lama miyemiye wasane ge i pahatamatuwo-miu. ");
INSERT INTO nmws_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Helak Tamade ge wada Guyau Yeisu Keriso gen si pamalum humiu togoru-yan hatiyemiu, ge lemi goru gen si pagaisi ge si labemiu hu nunuwane-yanid hene-bwaimiu. ");
INSERT INTO nmws_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Helak gen i muloluyanid bobode bwabwaligadiye hebwaden si nunuwane-yan wada Guyau Yeisu Keriso sauge hohoyowate taine i edemwao. ");
ALTER TABLE nmws_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
